#!/bin/bash
gmt begin novy1.66_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional novy1.66'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.615
    15.000    42.336
    15.500    42.055
    16.000    41.771
    16.500    41.481
    17.000    41.185
    17.500    40.881
    18.000    40.566
    18.500    40.238
    19.000    39.897
    19.500    39.539
    20.000    39.161
    20.500    38.763
    21.000    38.340
    21.500    37.892
    22.000    37.416
    22.500    36.911
    23.000    36.374
    23.500    35.803
    24.000    34.587
    24.500    33.315
    25.000    32.034
    25.500    30.742
    26.000    29.439
    26.500    28.125
    27.000    26.798
    27.500    25.455
    28.000    24.091
    28.500    22.713
    29.000    21.323
    29.500    19.924
    30.000    18.518
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.091 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     9.261
     1.500    10.241
     2.000    11.221
     2.500    12.201
     3.000    13.181
     3.500    14.160
     4.000    15.139
     4.500    16.116
     5.000    17.093
     5.500    18.069
     6.000    19.043
     6.500    20.016
     7.000    20.988
     7.500    21.958
     8.000    22.927
     8.500    23.893
     9.000    24.858
     9.500    25.821
    10.000    26.781
    10.500    27.739
    11.000    28.695
    11.500    29.648
    12.000    30.598
    12.500    31.545
    13.000    32.490
    13.500    33.431
    14.000    34.369
    14.500    35.303
    15.000    36.234
    15.500    37.162
    16.000    38.085
    16.500    38.715
    17.000    39.205
    17.500    39.737
    18.000    40.084
    18.500    40.374
    19.000    40.605
    19.500    40.778
    20.000    40.892
    20.500    40.948
    21.000    40.943
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    29.490 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    12.807
     2.500    16.009
     3.000    19.211
     3.500    22.413
     4.000    25.614
     4.500    28.816
     5.000    32.018
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    28.614 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.598
     1.000     6.928
     1.500     9.243
     2.000    11.558
     2.500    13.873
     3.000    16.187
     3.500    18.500
     4.000    20.813
     4.500    23.123
     5.000    25.434
     5.500    27.742
     6.000    30.049
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    23.434 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    25.575
     1.500    31.611
     2.000    37.647
     2.500    43.683
     3.000    49.719
     3.500    55.754
     4.000    61.787
     4.500    67.819
     5.000    73.850
     5.500    79.879
     6.000    85.904
     6.500    91.929
     7.000    97.950
     7.500   103.969
     8.000   109.985
     8.500   115.997
     9.000   122.007
     9.500   128.012
    10.000   134.014
    10.500   140.012
    11.000   146.004
    11.500   151.993
    12.000   157.977
    12.500   163.956
    13.000   169.930
    13.500   175.897
    14.000   181.860
    14.500   187.816
    15.000   193.766
    15.500   199.711
    16.000   205.648
    16.500   211.578
    17.000   217.501
    17.500   234.529
    18.000   240.800
    18.500   247.059
    19.000   253.305
    19.500   259.538
    20.000   265.757
    20.500   271.962
    21.000   278.151
    21.500   284.326
    22.000   290.485
    22.500   296.628
    23.000   302.754
    23.500   308.864
    24.000   314.957
    24.500   321.032
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    59.787 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.811
     1.000    21.161
     1.500    30.100
     2.000    38.849
     2.500    47.598
     3.000    56.345
     3.500    65.091
     4.000    73.835
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    63.091 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    37.545
     2.500    47.404
     3.000    57.263
     3.500    67.122
     4.000    76.981
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    59.263 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    15.447    49.486     0.150
    20.237    49.587     0.150
    20.237   275.587     0.150
    20.851   267.415     0.150
    22.473    55.796     0.150
    23.538   486.867     0.150
    23.563   477.574     0.150
    24.229   337.992     0.150
    24.229   474.391     0.150
    25.735   298.422     0.150
    26.228   460.675     0.150
    26.427   311.342     0.150
    26.331   304.464     0.150
    27.902  -318.621     0.150
    27.902   310.129     0.150
    28.527   304.837     0.150
    26.499   303.232     0.150
    29.335   313.448     0.150
    16.137   223.801     0.150
    18.006   243.681     0.150
    19.378   244.273     0.150
    25.158   315.917     0.150
    20.241    46.427     0.150
    20.330    45.387     0.150
    20.617   407.538     0.150
    28.491    68.349     0.150
    18.473   260.154     0.150
    28.379    67.055     0.150
    15.333   299.466     0.150
    17.981   355.060     0.150
    18.976    48.050     0.150
    18.976   254.448     0.150
    20.863    50.921     0.150
    20.879    44.744     0.150
    21.151   275.359     0.150
    21.151    58.562     0.150
    24.946   295.780     0.150
    24.966   292.540     0.150
    26.766   675.545     0.150
    26.921    77.731     0.150
    28.634   212.736     0.150
    29.709  -341.895     0.150
    15.983   221.381     0.150
    18.443   361.169     0.150
    18.794    56.574     0.150
    19.337   259.457     0.150
    19.337   383.457     0.150
    19.930    49.026     0.150
    25.213   295.884     0.150
    25.214   244.665     0.150
    25.386   292.865     0.150
    25.386   308.865     0.150
    25.546   296.993     0.150
    25.511   295.407     0.150
    28.731  -329.289     0.150
    28.731   310.826     0.150
    20.845    57.886     0.150
    23.843   288.986     0.150
    15.175    43.407     0.150
    15.984   221.863     0.150
    16.228    44.721     0.150
    16.228   323.822     0.150
    16.265   232.387     0.150
    16.299   230.990     0.150
    16.320   230.568     0.150
    17.346   237.268     0.150
    18.435   250.956     0.150
    19.423    44.530     0.150
    19.423    45.929     0.150
    19.423   264.030     0.150
    19.423   281.530     0.150
    20.590    42.814     0.150
    20.590    45.814     0.150
    20.590   264.814     0.150
    20.590   288.814     0.150
    20.590   503.814     0.150
    20.590   505.212     0.150
    21.060    53.726     0.150
    21.364    54.775     0.150
    21.364   289.775     0.150
    21.364   305.775     0.150
    23.081   278.540     0.150
    23.782   285.459     0.150
    25.395   302.739     0.150
    25.551   300.916     0.150
    25.672   299.601     0.150
    25.853   299.593     0.150
    27.565   300.409     0.150
    27.565   378.409     0.150
    28.555    73.959     0.150
    28.555   212.357     0.150
    28.555   433.857     0.150
    28.615   310.466     0.150
    28.779   309.244     0.150
    28.779   391.244     0.150
    29.734   317.201     0.150
    19.393    49.319     0.150
    20.596    47.679     0.150
    20.596    51.077     0.150
    21.635   302.444     0.150
    25.888   306.714     0.150
    14.900   562.594     0.150
    14.900   781.496     0.150
    15.344   347.211     0.150
    16.061    51.640     0.150
    16.061   240.038     0.150
    16.788   326.160     0.150
    17.793   244.326     0.150
    19.311    50.017     0.150
    19.311    54.017     0.150
    19.311   743.517     0.150
    19.445   259.047     0.150
    21.026    50.899     0.150
    21.026    64.899     0.150
    21.026   270.899     0.150
    21.026   280.399     0.150
    21.026   302.899     0.150
    21.262   269.446     0.150
    21.262    63.044     0.150
    26.264   235.166     0.150
    26.264   300.166     0.150
    26.264   309.967     0.150
    26.264   370.068     0.150
    29.177   399.380     0.150
    15.096   215.015     0.150
    15.096   557.916     0.150
    15.096   771.615     0.150
    15.223   343.437     0.150
    17.831    49.204     0.150
    18.821   258.653     0.150
    18.821   273.653     0.150
    20.410    59.706     0.150
    20.410   261.206     0.150
    20.410   291.206     0.150
    20.410   504.206     0.150
    20.410   725.908     0.150
    20.863   295.812     0.150
    21.346   285.679     0.150
    22.069   277.343     0.150
    22.069   309.644     0.150
    22.069   714.544     0.150
    24.118   298.233     0.150
    25.364   297.088     0.150
    25.364   307.588     0.150
    25.579   297.783     0.150
    25.892   238.027     0.150
    25.892   296.627     0.150
    25.892   308.427     0.150
    25.892   363.427     0.150
    25.892   682.927     0.150
    26.732  -305.559     0.150
    28.078    70.618     0.150
    29.916   195.567     0.150
    29.916   311.366     0.150
    29.812    78.380     0.150
    29.812   204.780     0.150
    29.812   316.380     0.150
    29.812   411.980     0.150
    19.126    50.607     0.150
    19.126    52.908     0.150
    21.198   272.921     0.150
    26.232   301.779     0.150
    26.232   308.378     0.150
    26.232   369.378     0.150
    26.452    68.410     0.150
    29.801    73.331     0.150
    29.801   317.331     0.150
    29.801   405.431     0.150
    14.568   217.205     0.150
    15.731   223.931     0.150
    15.972   548.917     0.150
    15.972   550.214     0.150
    17.710   257.843     0.150
    17.939    46.366     0.150
    19.014   275.418     0.150
    19.626    50.978     0.150
    21.376    60.851     0.150
    25.043   247.663     0.150
    25.043   293.858     0.150
    25.043   353.061     0.150
    25.043   692.459     0.150
    25.319   297.947     0.150
    27.965    67.662     0.150
    28.222    75.262     0.150
    28.222   218.864     0.150
    28.222   316.067     0.150
    28.222   325.965     0.150
    28.905    69.783     0.150
    28.905   310.588     0.150
    28.905   391.283     0.150
    29.105   210.555     0.150
    29.105   313.360     0.150
    29.105   428.657     0.150
    29.105   663.055     0.150
    29.819    75.455     0.150
    29.819   317.759     0.150
    29.819   405.158     0.150
    15.144    46.683     0.150
    15.144   220.683     0.150
    15.283    46.162     0.150
    16.080    45.467     0.150
    17.894   246.296     0.150
    18.363   253.317     0.150
    19.095   262.576     0.150
    20.704    46.903     0.150
    20.704    54.107     0.150
    20.704   283.302     0.150
    20.796   270.798     0.150
    20.842   273.669     0.150
    21.108   275.082     0.150
    21.564   276.893     0.150
    21.564   279.315     0.150
    21.658   278.216     0.150
    21.744   274.042     0.150
    21.746   274.027     0.150
    22.273   286.491     0.150
    23.529    61.929     0.150
    23.529   262.132     0.150
    23.529   330.132     0.150
    23.837    61.539     0.150
    23.837   259.735     0.150
    23.837   332.141     0.150
    24.230   303.859     0.150
    25.483   242.998     0.150
    25.487   298.678     0.150
    25.489   242.878     0.150
    25.455   300.663     0.150
    25.489   303.961     0.150
    25.737   303.617     0.150
    26.005   237.001     0.150
    26.041   315.309     0.150
    26.446    68.497     0.150
    26.446   301.294     0.150
    26.446   362.200     0.150
    26.711   318.052     0.150
    27.255   324.371     0.150
    27.940   330.513     0.150
    28.865   311.663     0.150
    29.913    84.137     0.150
    29.913   323.832     0.150
    29.913   423.832     0.150
    26.413  -306.044     0.150
    26.413   237.948     0.150
    24.858   300.051     0.150
    26.123   301.669     0.150
    27.802   379.126     0.150
    26.123   306.744     0.150
    26.451    69.824     0.150
    29.908    87.070     0.150
    29.908   326.070     0.150
    19.128    54.450     0.150
    19.128    57.653     0.150
    15.267    54.088     0.150
    19.018    47.722     0.150
    19.018    50.519     0.150
    21.055    64.141     0.150
    15.302    45.657     0.150
    19.055    46.158     0.150
    19.055    49.357     0.150
    20.000   262.030     0.150
    20.614    46.373     0.150
    20.614    48.873     0.150
    20.614   268.275     0.150
    21.093   272.878     0.150
    21.093   278.277     0.150
    21.093   302.077     0.150
    24.282   292.661     0.150
    24.282   300.661     0.150
    24.282   341.161     0.150
    29.970   317.114     0.150
    15.307    47.130     0.150
    17.968    48.172     0.150
    18.004   249.047     0.150
    18.409   254.728     0.150
    19.044   261.219     0.150
    20.159   262.004     0.150
    20.575    62.849     0.150
    20.575   267.049     0.150
    20.628   271.213     0.150
    22.296   284.565     0.150
    24.709   298.545     0.150
    25.585   305.278     0.150
    25.929   296.769     0.150
    26.123   304.109     0.150
    26.649   306.708     0.150
    29.901    72.118     0.150
    29.901   315.518     0.150
    18.785   256.111     0.150
    18.697   259.134     0.150
    18.697   310.837     0.150
    19.800    46.765     0.150
    25.783   301.835     0.150
    26.752   298.437     0.150
    27.134    65.176     0.150
    29.180    69.394     0.150
    29.180   206.394     0.150
    29.180   313.098     0.150
    29.180   396.191     0.150
    29.795   317.223     0.150
    18.747    47.595     0.150
    26.914    66.390     0.150
    29.376    69.755     0.150
    29.376   313.155     0.150
    15.026    52.479     0.150
    18.101    51.495     0.150
    18.101   250.893     0.150
    18.386    50.172     0.150
    18.386   252.973     0.150
    18.921   253.226     0.150
    19.677   258.208     0.150
    20.660    45.234     0.150
    20.892    62.421     0.150
    20.892   266.320     0.150
    21.252   285.125     0.150
    21.252   302.027     0.150
    22.024   277.607     0.150
    23.565   289.528     0.150
    23.565   300.028     0.150
    23.706    60.586     0.150
    23.706   290.086     0.150
    23.706   328.086     0.150
    25.345   302.067     0.150
    26.595   232.870     0.150
    26.595   298.570     0.150
    26.815   304.695     0.150
    29.780   315.500     0.150
    15.091    46.178     0.150
    19.107    52.307     0.150
    20.028   263.766     0.150
    20.247    48.305     0.150
    21.499   271.899     0.150
    23.597   293.281     0.150
    28.823    70.424     0.150
    28.823   313.323     0.150
    28.823   393.026     0.150
    12.274    36.633     0.150
    15.610   217.200     0.150
    16.057    46.482     0.150
    18.707   254.561     0.150
    19.140    45.512     0.150
    20.808    44.548     0.150
    20.808    48.048     0.150
    23.815   291.246     0.150
    20.398    49.125     0.150
    20.856    46.475     0.150
    25.443   302.953     0.150
    10.130    28.852     0.150
    15.337   223.783     0.150
    17.857   245.686     0.150
    18.075    50.039     0.150
    18.198    47.400     0.150
    18.198   266.400     0.150
    20.227   263.123     0.150
    20.376   265.987     0.150
    20.759   270.435     0.150
    21.274   273.281     0.150
    21.306   277.244     0.150
    21.367   272.869     0.150
    23.412   288.556     0.150
    25.346    75.284     0.150
    25.621   240.770     0.150
    25.729   300.816     0.150
    26.093   300.967     0.150
    28.235   316.616     0.150
    29.979   199.115     0.150
    29.979   316.115     0.150
    29.979  -343.955     0.150
    15.535   225.010     0.150
    18.795    49.760     0.150
    18.795   265.160     0.150
    20.195    44.624     0.150
    23.397   291.952     0.150
    18.522   254.340     0.150
    20.259   262.565     0.150
    20.346    46.858     0.150
    29.949   198.393     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    20.366    39.085     0.200
    20.360    37.151     0.200
    20.851    38.415     0.200
    21.851    36.747     0.200
    24.155    32.860     0.200
    25.320    29.267     0.200
    25.307    31.612     0.200
    25.434    28.933     0.200
    25.577    27.266     0.200
    25.640    27.531     0.200
    25.735    26.422     0.200
    25.735    26.222     0.200
    25.777    28.829     0.200
    25.777    27.930     0.200
    25.895    30.560     0.200
    25.927    28.979     0.200
    26.038    31.983     0.200
    26.057    24.659     0.200
    26.050    26.749     0.200
    26.122    29.901     0.200
    26.228    28.675     0.200
    26.235    26.791     0.200
    26.442    27.673     0.200
    26.635    25.822     0.200
    26.635    24.924     0.200
    26.866    23.229     0.200
    27.902    25.129     0.200
    28.527    20.837     0.200
    29.777    17.253     0.200
    20.202    35.612     0.200
    20.184    35.831     0.200
    20.664    38.230     0.200
    26.145    27.264     0.200
    27.832    23.571     0.200
    28.160    20.745     0.200
    19.422    37.116     0.200
    19.422    36.819     0.200
    21.287    39.055     0.200
    25.301    32.210     0.200
    25.301    31.210     0.200
    25.879    28.571     0.200
    26.499    25.232     0.200
    26.990    27.503     0.200
    27.136    27.797     0.200
    27.307    24.099     0.200
    27.657    23.718     0.200
    29.501    18.194     0.200
    25.314    31.373     0.200
    25.429    31.034     0.200
    26.551    24.944     0.200
    27.111    26.403     0.200
    27.327    25.881     0.200
    27.652    24.087     0.200
    28.866    20.924     0.200
    29.335    18.448     0.200
    29.763    19.449     0.200
    16.329    40.976     0.200
    19.642    34.305     0.200
    19.642    35.106     0.200
    20.704    36.912     0.200
    21.122    36.040     0.200
    21.122    36.439     0.200
    21.339    35.701     0.200
    25.553    28.331     0.200
    27.236    22.682     0.200
    28.990    18.318     0.200
    29.379    15.674     0.200
    19.324    39.492     0.200
    19.324    39.793     0.200
    21.279    38.372     0.200
    21.976    38.047     0.200
    27.792    26.666     0.200
    29.970    18.058     0.200
    16.714    32.661     0.200
    26.417    29.021     0.200
    26.427    28.908     0.200
    16.397    41.212     0.200
    20.579    45.210     0.200
    14.617    42.230     0.200
    19.378    39.673     0.200
    19.378    39.773     0.200
    21.185    46.290     0.200
    21.331    38.878     0.200
    22.002    38.753     0.200
    23.817    37.867     0.200
    24.828    34.073     0.200
    25.114    33.740     0.200
    25.123    33.631     0.200
    25.158    51.217     0.200
    26.835    27.654     0.200
    26.835    28.454     0.200
    27.895    29.281     0.200
    14.382    42.407     0.200
    15.687    41.578     0.200
    15.687    42.078     0.200
    16.281    54.646     0.200
    20.241    40.127     0.200
    21.057    39.904     0.200
    25.913    30.231     0.200
    25.913    30.731     0.200
    26.045    29.893     0.200
    26.055    29.783     0.200
    28.491    26.150     0.200
    14.630    42.649     0.200
    15.074    43.872     0.200
    15.160    39.865     0.200
    15.160    40.263     0.200
    15.821    40.151     0.200
    16.398    40.414     0.200
    18.140    40.588     0.200
    19.706    37.809     0.200
    19.706    37.911     0.200
    21.560    25.175     0.200
    21.560    25.472     0.200
    21.677    37.708     0.200
    25.377    32.033     0.200
    25.369    32.731     0.200
    25.509    30.797     0.200
    20.153    33.844     0.200
    20.336    36.415     0.200
    21.051    39.563     0.200
    25.707    32.027     0.200
    15.333    43.966     0.200
    17.385    42.015     0.200
    17.981    42.060     0.200
    19.574    38.471     0.200
    19.574    38.870     0.200
    21.151    37.062     0.200
    21.151    37.562     0.200
    21.943    37.328     0.200
    23.762    36.197     0.200
    24.966    32.540     0.200
    25.075    32.778     0.200
    25.619    30.718     0.200
    25.871    32.382     0.200
    26.766    29.545     0.200
    26.912    27.839     0.200
    26.921    27.731     0.200
    28.634    22.736     0.200
    29.364    19.512     0.200
    14.801    41.768     0.200
    15.522    42.260     0.200
    15.652    43.237     0.200
    15.983    42.381     0.200
    16.282    39.393     0.200
    20.685    38.500     0.200
    22.261    37.118     0.200
    24.473    34.297     0.200
    15.395    43.452     0.200
    17.792    42.285     0.200
    19.337    39.457     0.200
    19.621    40.145     0.200
    21.058    39.366     0.200
    21.283    38.542     0.200
    22.373    36.527     0.200
    23.819    35.051     0.200
    24.189    34.825     0.200
    24.583    32.733     0.200
    25.213    28.324     0.200
    25.213    27.884     0.200
    25.214    28.964     0.200
    25.399    30.707     0.200
    25.386    30.865     0.200
    25.546    29.993     0.200
    25.511    31.006     0.200
    25.567    30.948     0.200
    25.609    30.952     0.200
    25.752    28.388     0.200
    26.035    29.471     0.200
    26.186    27.126     0.200
    26.284    28.880     0.200
    26.421    27.678     0.200
    26.423    26.555     0.200
    27.160    27.664     0.200
    28.731    22.826     0.200
    29.202    20.330     0.200
    15.038    41.354     0.200
    16.362    39.204     0.200
    19.821    38.846     0.200
    20.845    38.386     0.200
    22.231    36.712     0.200
    24.571    34.206     0.200
    16.045    40.981     0.200
    20.292    37.597     0.200
    21.002    34.143     0.200
    16.566    42.093     0.200
    20.419    39.724     0.200
    21.352    38.176     0.200
    20.482    37.173     0.200
    16.265    42.387     0.200
    16.299    39.190     0.200
    16.299    39.088     0.200
    16.320    39.170     0.200
    18.310    40.819     0.200
    20.230    37.486     0.200
    20.590    38.314     0.200
    21.060    38.527     0.200
    21.060    37.929     0.200
    21.191    39.238     0.200
    21.364    39.075     0.200
    21.364    38.447     0.200
    21.610    38.612     0.200
    21.647    38.152     0.200
    22.046    37.119     0.200
    23.081    35.887     0.200
    23.357    32.827     0.200
    23.782    32.959     0.200
    23.782    32.810     0.200
    24.532    31.510     0.200
    24.525    34.193     0.200
    24.897    31.546     0.200
    25.551    31.217     0.200
    25.672    30.801     0.200
    25.772    29.078     0.200
    25.853    28.894     0.200
    26.473    28.828     0.200
    26.589    28.552     0.200
    26.603    25.246     0.200
    26.603    24.645     0.200
    26.730    27.285     0.200
    26.771    27.981     0.200
    26.894    28.870     0.200
    26.955    26.532     0.200
    27.124    28.183     0.200
    27.153    27.256     0.200
    27.171    25.406     0.200
    27.421    25.770     0.200
    27.529    26.234     0.200
    27.565    23.710     0.200
    28.555    22.256     0.200
    28.615    23.665     0.200
    28.779    20.545     0.200
    29.734    18.900     0.200
    29.974    20.304     0.200
    29.974    20.604     0.200
    18.305    41.512     0.200
    20.191    37.653     0.200
    20.191    37.802     0.200
    23.132    33.528     0.200
    23.307    33.936     0.200
    23.688    33.509     0.200
    23.733    33.765     0.200
    25.680    31.239     0.200
    25.888    31.112     0.200
    26.323    29.059     0.200
    26.690    27.774     0.200
    26.731    26.411     0.200
    26.915    27.332     0.200
    27.432    24.796     0.200
    27.432    26.077     0.200
    27.515    23.436     0.200
    28.728    20.568     0.200
    20.219    37.767     0.200
    23.338    33.929     0.200
    23.719    33.400     0.200
    23.764    31.961     0.200
    24.542    32.685     0.200
    20.164    38.811     0.200
    23.278    34.590     0.200
    23.659    34.264     0.200
    23.704    34.423     0.200
    29.947    17.863     0.200
    21.257    37.511     0.200
    21.347    39.656     0.200
    16.643    42.000     0.200
    21.372    37.768     0.200
    25.019    32.021     0.200
    15.344    42.609     0.200
    15.746    44.315     0.200
    17.076    42.996     0.200
    17.793    42.326     0.200
    19.445    41.348     0.200
    19.649    40.732     0.200
    20.142    39.910     0.200
    20.280    40.969     0.200
    20.669    40.305     0.200
    20.669    39.765     0.200
    21.262    39.345     0.200
    21.425    37.747     0.200
    21.912    37.338     0.200
    21.967    37.702     0.200
    21.967    38.112     0.200
    25.232    30.416     0.200
    25.473    30.502     0.200
    25.517    30.045     0.200
    25.432    30.987     0.200
    25.501    32.171     0.200
    25.577    30.994     0.200
    26.202    29.197     0.200
    26.202    28.896     0.200
    26.263    27.279     0.200
    26.264    30.166     0.200
    28.101    26.947     0.200
    28.699    25.362     0.200
    29.159    24.617     0.200
    29.177    20.478     0.200
    15.096    43.416     0.200
    15.223    42.937     0.200
    15.971    42.993     0.200
    17.416    40.550     0.200
    18.821    39.554     0.200
    20.183    38.758     0.200
    20.410    38.908     0.200
    20.731    37.863     0.200
    20.844    37.893     0.200
    20.863    39.312     0.200
    21.317    37.423     0.200
    21.317    35.923     0.200
    21.317    36.234     0.200
    21.346    36.679     0.200
    21.346    36.679     0.200
    21.920    35.433     0.200
    22.069    36.644     0.200
    24.118    34.633     0.200
    24.923    29.840     0.200
    24.923    30.627     0.200
    24.968    30.717     0.200
    24.968    30.416     0.200
    25.334    28.946     0.200
    25.364    30.688     0.200
    25.494    28.676     0.200
    25.579    26.283     0.200
    25.581    27.875     0.200
    25.892    29.427     0.200
    26.053    27.547     0.200
    26.732    25.132     0.200
    27.479    25.004     0.200
    27.479    25.315     0.200
    27.576    25.312     0.200
    27.859    24.678     0.200
    28.078    24.618     0.200
    28.233    24.355     0.200
    28.656    22.255     0.200
    29.916    15.167     0.200
    29.812    19.181     0.200
    15.447    42.935     0.200
    16.792    42.594     0.200
    21.119    41.693     0.200
    21.198    41.121     0.200
    21.345    39.864     0.200
    21.345    38.314     0.200
    21.345    37.793     0.200
    21.439    38.758     0.200
    21.450    38.980     0.200
    21.450    39.155     0.200
    21.450    39.280     0.200
    24.456    34.508     0.200
    24.883    32.817     0.200
    24.883    32.904     0.200
    24.927    32.903     0.200
    25.392    34.069     0.200
    26.232    31.779     0.200
    26.452    29.310     0.200
    26.452    31.290     0.200
    27.583    26.311     0.200
    28.375    25.274     0.200
    28.375    25.423     0.200
    28.751    24.683     0.200
    29.801    20.431     0.200
    29.801    18.841     0.200
    14.568    41.104     0.200
    15.752    41.144     0.200
    15.837    42.794     0.200
    17.428    40.156     0.200
    19.014    39.715     0.200
    19.951    37.682     0.200
    19.951    38.081     0.200
    19.998    39.043     0.200
    19.998    37.629     0.200
    19.998    37.941     0.200
    19.962    39.555     0.200
    20.090    37.941     0.200
    21.246    37.622     0.200
    21.246    37.621     0.200
    21.420    37.339     0.200
    23.027    37.123     0.200
    23.506    33.795     0.200
    23.722    33.775     0.200
    23.722    33.478     0.200
    23.768    33.536     0.200
    23.768    33.005     0.200
    23.768    33.138     0.200
    24.952    33.516     0.200
    25.043    32.061     0.200
    25.148    31.262     0.200
    26.084    29.110     0.200
    26.084    31.751     0.200
    26.357    25.978     0.200
    26.503    30.771     0.200
    26.686    27.888     0.200
    26.891    26.998     0.200
    26.836    28.382     0.200
    26.882    27.298     0.200
    26.882    26.962     0.200
    27.266    26.120     0.200
    27.266    26.417     0.200
    27.451    24.957     0.200
    27.691    24.259     0.200
    27.965    23.662     0.200
    27.965    23.841     0.200
    28.814    20.847     0.200
    28.814    20.949     0.200
    28.905    19.690     0.200
    29.105    22.657     0.200
    29.403    21.781     0.200
    25.642    30.042     0.200
    21.595    38.902     0.200
    21.595    39.925     0.200
    21.689    38.799     0.200
    25.167    31.975     0.200
    25.212    32.000     0.200
    21.362    39.444     0.200
    24.945    32.426     0.200
    26.443    28.250     0.200
    29.819    19.361     0.200
    15.776    39.598     0.200
    20.564    38.642     0.200
    20.658    37.539     0.200
    20.678    37.285     0.200
    24.127    33.984     0.200
    21.425    40.570     0.200
    21.475    37.060     0.200
    25.009    32.333     0.200
    25.053    31.122     0.200
    15.802    39.273     0.200
    20.675    37.971     0.200
    20.669    37.762     0.200
    24.166    33.042     0.200
    27.593    26.300     0.200
    20.003    36.328     0.200
    20.667    36.605     0.200
    21.349    36.928     0.200
    21.391    37.496     0.200
    21.443    36.687     0.200
    24.987    31.572     0.200
    25.593    28.896     0.200
    26.663    27.609     0.200
    29.920    19.097     0.200
    15.292    39.780     0.200
    20.431    36.607     0.200
    20.526    36.630     0.200
    20.540    36.583     0.200
    20.540    36.339     0.200
    21.309    37.061     0.200
    24.005    32.491     0.200
    24.050    32.577     0.200
    25.632    31.017     0.200
    20.039    38.949     0.200
    20.061    39.897     0.200
    23.705    35.509     0.200
    20.044    40.016     0.200
    20.065    40.245     0.200
    20.137    38.903     0.200
    23.709    35.576     0.200
    21.548    40.717     0.200
    21.607    38.373     0.200
    21.642    39.617     0.200
    25.119    33.407     0.200
    17.328    41.998     0.200
    17.795    44.248     0.200
    17.894    42.592     0.200
    18.363    43.613     0.200
    19.095    41.076     0.200
    19.821    40.675     0.200
    19.981    39.654     0.200
    20.704    40.708     0.200
    20.781    39.641     0.200
    20.796    39.962     0.200
    20.842    40.247     0.200
    21.108    41.184     0.200
    21.564    38.917     0.200
    21.564    38.315     0.200
    21.623    38.569     0.200
    21.623    38.874     0.200
    21.678    40.138     0.200
    21.658    38.763     0.200
    21.744    38.074     0.200
    21.787    38.363     0.200
    22.273    38.991     0.200
    22.273    38.491     0.200
    23.520    35.838     0.200
    23.529    37.234     0.200
    23.837    35.938     0.200
    24.230    36.757     0.200
    24.863    33.789     0.200
    25.216    32.544     0.200
    25.216    32.544     0.200
    25.135    32.630     0.200
    25.179    32.566     0.200
    25.179    33.277     0.200
    25.179    32.464     0.200
    25.251    32.693     0.200
    25.423    32.037     0.200
    25.483    30.631     0.200
    25.487    30.881     0.200
    25.487    30.319     0.200
    25.487    30.280     0.200
    25.489    30.799     0.200
    25.455    33.163     0.200
    25.455    32.101     0.200
    25.489    32.961     0.200
    25.492    30.527     0.200
    25.775    31.319     0.200
    25.775    31.202     0.200
    25.758    30.747     0.200
    25.758    31.989     0.200
    25.737    32.086     0.200
    25.950    31.098     0.200
    26.005    29.079     0.200
    26.130    30.952     0.200
    26.446    29.497     0.200
    26.446    28.091     0.200
    26.362    29.981     0.200
    26.523    30.888     0.200
    26.711    29.123     0.200
    26.800    29.076     0.200
    26.784    30.628     0.200
    26.940    28.272     0.200
    27.161    28.099     0.200
    27.255    26.731     0.200
    27.363    27.654     0.200
    27.425    27.168     0.200
    27.857    26.186     0.200
    27.940    25.903     0.200
    28.289    26.087     0.200
    28.362    23.934     0.200
    28.512    26.128     0.200
    28.551    24.919     0.200
    28.551    25.278     0.200
    28.551    25.396     0.200
    28.551    24.130     0.200
    28.551    24.497     0.200
    28.815    24.997     0.200
    28.865    24.765     0.200
    29.100    21.552     0.200
    29.330    24.725     0.200
    21.559    41.224     0.200
    21.624    40.319     0.200
    21.654    40.100     0.200
    16.808    42.220     0.200
    21.590    40.634     0.200
    21.653    40.700     0.200
    21.653    39.727     0.200
    21.653    40.102     0.200
    21.684    39.503     0.200
    25.156    34.280     0.200
    25.201    33.998     0.200
    26.413    30.749     0.200
    28.581    26.356     0.200
    21.675    39.274     0.200
    16.792    42.790     0.200
    21.574    40.756     0.200
    21.669    39.681     0.200
    21.638    39.793     0.200
    25.141    32.847     0.200
    17.146    40.567     0.200
    21.563    36.724     0.200
    21.624    40.151     0.200
    21.657    39.921     0.200
    25.132    32.524     0.200
    20.440    41.190     0.200
    20.698    41.485     0.200
    20.698    41.188     0.200
    21.559    37.837     0.200
    21.559    38.076     0.200
    21.618    40.051     0.200
    21.618    39.851     0.200
    21.618    39.543     0.200
    21.653    39.789     0.200
    24.858    36.238     0.200
    25.130    32.223     0.200
    25.175    31.943     0.200
    25.175    32.201     0.200
    25.246    34.834     0.200
    25.222    32.086     0.200
    25.222    33.411     0.200
    25.222    32.907     0.200
    25.487    33.232     0.200
    25.701    34.656     0.200
    25.731    34.506     0.200
    26.124    32.989     0.200
    26.356    32.802     0.200
    26.705    31.123     0.200
    26.795    31.885     0.200
    27.249    29.589     0.200
    27.934    27.688     0.200
    28.545    25.877     0.200
    28.545    23.845     0.200
    16.795    41.313     0.200
    18.319    40.485     0.200
    21.438    36.597     0.200
    21.438    38.418     0.200
    21.522    37.118     0.200
    19.940    36.494     0.200
    21.389    39.190     0.200
    21.444    38.423     0.200
    21.483    38.043     0.200
    21.597    38.645     0.200
    21.691    37.540     0.200
    21.695    36.618     0.200
    25.175    27.881     0.200
    21.556    40.292     0.200
    25.243    31.041     0.200
    20.144    37.797     0.200
    20.144    40.098     0.200
    20.182    39.350     0.200
    20.182    37.752     0.200
    20.275    40.598     0.200
    23.892    35.682     0.200
    23.939    34.813     0.200
    23.939    34.075     0.200
    24.329    34.482     0.200
    27.802    23.723     0.200
    27.802    26.114     0.200
    17.466    44.178     0.200
    19.090    42.521     0.200
    19.770    40.180     0.200
    19.817    42.551     0.200
    20.439    40.350     0.200
    20.439    40.975     0.200
    20.699    43.043     0.200
    20.840    40.744     0.200
    21.103    41.924     0.200
    21.561    38.787     0.200
    21.561    39.068     0.200
    21.619    39.104     0.200
    21.619    39.405     0.200
    21.619    39.305     0.200
    21.655    38.963     0.200
    21.783    39.095     0.200
    24.227    37.978     0.200
    24.859    35.322     0.200
    24.806    34.210     0.200
    25.132    33.231     0.200
    25.176    34.392     0.200
    25.176    33.412     0.200
    25.248    32.917     0.200
    25.221    33.278     0.200
    25.221    33.702     0.200
    25.221    33.238     0.200
    25.361    33.538     0.200
    25.488    31.325     0.200
    25.703    33.398     0.200
    25.733    32.309     0.200
    26.126    32.152     0.200
    26.123    32.944     0.200
    26.451    30.024     0.200
    26.358    31.156     0.200
    26.707    30.436     0.200
    26.796    30.560     0.200
    26.780    30.753     0.200
    26.935    30.136     0.200
    27.251    27.641     0.200
    28.547    25.879     0.200
    28.547    26.159     0.200
    28.547    25.089     0.200
    20.725    40.316     0.200
    21.571    40.053     0.200
    21.571    39.592     0.200
    21.638    40.170     0.200
    21.638    39.545     0.200
    21.638    39.771     0.200
    21.638    40.076     0.200
    21.665    39.656     0.200
    21.801    39.263     0.200
    24.877    34.698     0.200
    25.134    31.786     0.200
    25.178    33.848     0.200
    25.178    32.199     0.200
    25.509    31.586     0.200
    26.146    32.330     0.200
    26.376    31.817     0.200
    26.724    30.643     0.200
    26.815    30.622     0.200
    26.798    31.051     0.200
    27.266    28.336     0.200
    28.565    25.376     0.200
    28.565    25.830     0.200
    16.115    44.187     0.200
    16.651    42.441     0.200
    20.544    40.286     0.200
    20.913    41.047     0.200
    21.055    41.340     0.200
    21.431    41.060     0.200
    21.431    39.498     0.200
    21.493    39.837     0.200
    21.493    38.985     0.200
    21.525    38.961     0.200
    21.656    39.528     0.200
    25.004    33.674     0.200
    25.049    33.437     0.200
    25.049    32.508     0.200
    28.420    26.093     0.200
    19.035    41.354     0.200
    20.531    41.205     0.200
    20.531    39.303     0.200
    21.432    39.981     0.200
    21.499    39.081     0.200
    21.526    39.409     0.200
    25.002    33.513     0.200
    25.046    33.710     0.200
    16.609    42.300     0.200
    20.520    41.379     0.200
    20.923    41.431     0.200
    20.923    41.630     0.200
    21.445    42.033     0.200
    21.445    41.713     0.200
    21.511    40.062     0.200
    21.511    39.636     0.200
    21.539    39.496     0.200
    21.674    39.258     0.200
    22.270    39.312     0.200
    25.014    33.653     0.200
    25.059    33.663     0.200
    25.059    33.823     0.200
    28.438    25.895     0.200
    16.614    41.950     0.200
    19.856    40.730     0.200
    20.101    40.158     0.200
    20.509    40.639     0.200
    20.682    39.481     0.200
    20.682    39.380     0.200
    21.093    39.976     0.200
    21.449    38.927     0.200
    21.449    39.075     0.200
    21.518    39.022     0.200
    21.518    39.307     0.200
    21.543    39.702     0.200
    21.681    38.918     0.200
    21.863    39.372     0.200
    22.283    38.992     0.200
    22.283    39.293     0.200
    23.649    34.753     0.200
    24.282    34.661     0.200
    24.757    34.330     0.200
    24.905    34.603     0.200
    25.016    33.373     0.200
    25.060    32.985     0.200
    25.060    33.227     0.200
    25.263    32.712     0.200
    25.391    31.016     0.200
    25.322    32.898     0.200
    25.523    32.878     0.200
    25.604    33.367     0.200
    26.119    31.226     0.200
    26.604    30.354     0.200
    26.696    29.707     0.200
    26.679    30.892     0.200
    26.679    30.790     0.200
    27.056    29.472     0.200
    27.218    29.218     0.200
    28.445    25.005     0.200
    28.445    24.587     0.200
    28.445    25.388     0.200
    15.836    46.459     0.200
    16.673    41.369     0.200
    21.454    41.794     0.200
    21.548    40.726     0.200
    25.068    34.021     0.200
    25.320    33.025     0.200
    29.970    19.013     0.200
    16.603    41.550     0.200
    20.498    40.182     0.200
    21.463    39.878     0.200
    21.531    39.742     0.200
    21.557    39.665     0.200
    25.029    34.004     0.200
    17.709    40.921     0.200
    20.107    40.580     0.200
    20.535    40.116     0.200
    21.436    40.570     0.200
    21.499    39.252     0.200
    21.530    40.123     0.200
    25.008    33.240     0.200
    25.052    34.366     0.200
    18.004    44.147     0.200
    18.409    42.927     0.200
    18.551    38.673     0.200
    19.044    43.219     0.200
    19.670    41.752     0.200
    19.894    39.791     0.200
    19.894    39.330     0.200
    20.031    38.900     0.200
    20.159    39.404     0.200
    20.159    38.865     0.200
    20.572    39.988     0.200
    20.575    42.849     0.200
    20.575    41.549     0.200
    20.628    38.994     0.200
    20.980    40.421     0.200
    20.980    38.821     0.200
    21.094    39.796     0.200
    21.395    38.282     0.200
    21.489    38.230     0.200
    21.470    37.605     0.200
    21.470    37.974     0.200
    21.470    39.979     0.200
    21.470    38.354     0.200
    21.633    39.202     0.200
    21.921    37.713     0.200
    22.296    38.266     0.200
    23.564    33.956     0.200
    24.315    36.704     0.200
    24.709    34.965     0.200
    25.002    32.280     0.200
    25.002    32.700     0.200
    25.079    33.984     0.200
    25.370    30.684     0.200
    25.370    30.985     0.200
    25.345    31.040     0.200
    25.558    32.482     0.200
    25.929    31.769     0.200
    25.929    29.820     0.200
    25.981    31.708     0.200
    25.980    31.659     0.200
    26.123    32.109     0.200
    26.208    30.519     0.200
    26.649    29.989     0.200
    26.632    30.057     0.200
    26.788    30.934     0.200
    27.008    29.899     0.200
    27.094    28.621     0.200
    27.603    29.641     0.200
    27.783    27.737     0.200
    27.976    28.234     0.200
    28.015    28.285     0.200
    28.135    28.324     0.200
    28.396    25.494     0.200
    28.396    27.382     0.200
    28.396    25.273     0.200
    28.396    24.414     0.200
    29.901    17.936     0.200
    29.901    17.218     0.200
    29.901    18.679     0.200
    29.974    21.489     0.200
    15.178    43.600     0.200
    15.352    41.777     0.200
    18.522    40.276     0.200
    18.850    37.649     0.200
    19.801    36.650     0.200
    20.675    37.857     0.200
    20.675    35.584     0.200
    20.570    37.178     0.200
    20.570    35.405     0.200
    20.664    37.580     0.200
    20.647    36.373     0.200
    20.647    37.475     0.200
    20.647    36.787     0.200
    20.718    39.442     0.200
    21.262    38.196     0.200
    21.262    37.400     0.200
    21.379    36.837     0.200
    21.379    38.391     0.200
    22.085    36.597     0.200
    23.058    34.942     0.200
    23.885    32.487     0.200
    24.165    32.639     0.200
    24.209    32.506     0.200
    24.209    32.225     0.200
    24.260    31.115     0.200
    24.253    31.358     0.200
    24.407    34.899     0.200
    24.740    30.917     0.200
    24.774    30.920     0.200
    25.075    29.804     0.200
    25.165    29.861     0.200
    25.732    28.041     0.200
    25.828    27.813     0.200
    25.783    29.835     0.200
    25.797    29.055     0.200
    25.968    27.786     0.200
    26.194    27.640     0.200
    26.194    25.843     0.200
    26.194    28.070     0.200
    26.194    25.890     0.200
    26.265    26.209     0.200
    26.404    27.650     0.200
    26.752    28.633     0.200
    26.780    28.053     0.200
    27.134    24.981     0.200
    27.134    22.856     0.200
    26.958    26.935     0.200
    26.958    24.740     0.200
    27.151    26.515     0.200
    27.151    26.680     0.200
    27.190    26.211     0.200
    27.312    26.054     0.200
    27.312    26.601     0.200
    27.572    25.551     0.200
    27.572    23.840     0.200
    27.838    26.955     0.200
    27.967    23.158     0.200
    27.949    24.621     0.200
    27.949    24.864     0.200
    29.180    18.988     0.200
    29.180    18.691     0.200
    29.180    17.621     0.200
    29.146    18.497     0.200
    29.463    18.301     0.200
    29.886    19.257     0.200
    15.123    41.487     0.200
    15.263    43.752     0.200
    16.249    41.344     0.200
    17.126    42.707     0.200
    17.126    40.806     0.200
    18.716    40.260     0.200
    19.107    38.290     0.200
    20.050    37.885     0.200
    20.421    38.339     0.200
    20.816    37.044     0.200
    20.816    37.544     0.200
    20.911    38.018     0.200
    20.904    37.453     0.200
    20.904    37.823     0.200
    20.904    37.847     0.200
    20.904    37.722     0.200
    20.872    39.791     0.200
    21.019    37.692     0.200
    21.019    38.784     0.200
    21.066    37.369     0.200
    21.296    37.528     0.200
    23.270    36.916     0.200
    24.141    34.640     0.200
    24.392    33.211     0.200
    24.437    33.082     0.200
    24.437    32.792     0.200
    24.502    32.230     0.200
    24.788    30.791     0.200
    24.997    32.558     0.200
    25.031    32.662     0.200
    25.642    31.132     0.200
    25.938    29.102     0.200
    25.938    29.924     0.200
    26.085    30.861     0.200
    26.519    28.389     0.200
    26.914    25.289     0.200
    27.140    27.982     0.200
    27.214    26.089     0.200
    27.829    24.808     0.200
    27.829    24.241     0.200
    27.829    25.411     0.200
    27.835    25.982     0.200
    29.216    23.519     0.200
    29.376    18.955     0.200
    29.717    18.547     0.200
    29.717    18.147     0.200
    29.717    17.607     0.200
    15.274    43.083     0.200
    17.616    41.257     0.200
    18.921    39.726     0.200
    19.815    38.587     0.200
    19.815    37.423     0.200
    19.834    38.431     0.200
    19.840    37.208     0.200
    20.892    39.320     0.200
    21.252    39.328     0.200
    21.577    36.128     0.200
    21.579    36.066     0.200
    21.644    36.338     0.200
    21.644    36.845     0.200
    21.644    37.263     0.200
    21.644    36.255     0.200
    21.644    37.204     0.200
    21.644    36.743     0.200
    21.738    36.074     0.200
    21.738    35.856     0.200
    21.809    36.653     0.200
    22.024    37.607     0.200
    23.342    34.623     0.200
    23.565    35.528     0.200
    23.706    32.985     0.200
    23.952    35.013     0.200
    24.552    32.599     0.200
    24.887    32.057     0.200
    25.199    30.974     0.200
    25.199    29.614     0.200
    25.199    30.813     0.200
    25.264    29.626     0.200
    25.309    30.735     0.200
    25.220    32.223     0.200
    25.260    29.645     0.200
    25.345    28.669     0.200
    25.344    30.164     0.200
    25.494    26.599     0.200
    25.494    29.411     0.200
    25.705    30.157     0.200
    25.715    28.384     0.200
    25.693    26.863     0.200
    25.741    28.338     0.200
    25.767    27.156     0.200
    25.968    27.437     0.200
    26.137    26.708     0.200
    26.383    26.100     0.200
    26.595    24.980     0.200
    26.595    26.671     0.200
    26.735    24.990     0.200
    26.815    26.344     0.200
    26.862    26.081     0.200
    27.300    25.179     0.200
    27.777    23.382     0.200
    27.969    22.268     0.200
    28.574    21.763     0.200
    28.574    21.400     0.200
    28.574    22.373     0.200
    29.780    20.301     0.200
    15.010    43.927     0.200
    15.932    40.762     0.200
    15.983    44.264     0.200
    17.651    41.098     0.200
    17.651    40.835     0.200
    17.899    42.913     0.200
    19.155    39.550     0.200
    19.934    39.758     0.200
    19.934    38.848     0.200
    19.934    40.066     0.200
    19.965    39.199     0.200
    19.965    39.750     0.200
    20.028    39.793     0.200
    20.128    40.337     0.200
    21.065    38.956     0.200
    21.368    39.712     0.200
    21.368    40.021     0.200
    21.368    37.959     0.200
    21.368    38.619     0.200
    21.499    38.598     0.200
    21.535    38.575     0.200
    21.535    40.102     0.200
    21.732    39.073     0.200
    21.943    39.815     0.200
    22.447    37.934     0.200
    23.204    36.097     0.200
    23.597    35.515     0.200
    23.598    36.205     0.200
    23.628    35.555     0.200
    23.628    35.395     0.200
    23.714    35.648     0.200
    23.714    35.445     0.200
    23.842    32.953     0.200
    24.053    34.696     0.200
    24.085    34.517     0.200
    24.292    36.697     0.200
    24.477    33.448     0.200
    24.697    33.812     0.200
    24.872    35.868     0.200
    25.063    35.407     0.200
    25.277    34.508     0.200
    25.334    33.641     0.200
    25.714    29.704     0.200
    25.714    33.294     0.200
    25.772    29.132     0.200
    25.772    32.409     0.200
    26.098    31.336     0.200
    26.199    30.726     0.200
    26.473    30.480     0.200
    26.511    32.489     0.200
    26.630    30.428     0.200
    26.702    28.975     0.200
    26.875    28.552     0.200
    26.875    27.986     0.200
    26.875    26.982     0.200
    26.892    29.682     0.200
    26.892    29.065     0.200
    26.892    28.084     0.200
    26.892    29.822     0.200
    26.972    30.170     0.200
    27.271    28.612     0.200
    27.502    26.938     0.200
    27.770    24.719     0.200
    28.476    22.580     0.200
    28.754    24.625     0.200
    28.823    22.018     0.200
    28.823    22.225     0.200
    28.823    20.604     0.200
    28.796    21.638     0.200
    28.796    21.841     0.200
    29.221    22.776     0.200
    29.689    19.212     0.200
    15.115    41.364     0.200
    15.610    43.200     0.200
    19.662    37.918     0.200
    20.330    37.791     0.200
    20.839    38.483     0.200
    21.351    39.178     0.200
    21.653    36.619     0.200
    21.653    36.079     0.200
    21.653    36.719     0.200
    21.722    37.075     0.200
    21.722    36.925     0.200
    21.748    35.928     0.200
    21.885    36.408     0.200
    21.885    36.829     0.200
    22.343    37.433     0.200
    23.338    34.162     0.200
    23.815    33.946     0.200
    24.267    34.680     0.200
    25.212    29.899     0.200
    25.118    31.346     0.200
    25.118    31.521     0.200
    25.242    30.653     0.200
    25.242    29.503     0.200
    25.466    30.163     0.200
    26.209    29.312     0.200
    26.205    28.434     0.200
    26.346    27.766     0.200
    26.346    27.616     0.200
    26.344    27.995     0.200
    27.080    27.243     0.200
    27.464    27.903     0.200
    28.649    21.295     0.200
    28.649    21.135     0.200
    28.649    22.145     0.200
    28.722    23.071     0.200
    28.925    20.619     0.200
    15.881    45.745     0.200
    16.609    42.139     0.200
    17.832    41.473     0.200
    20.193    39.921     0.200
    20.193    39.061     0.200
    20.430    38.548     0.200
    20.430    37.868     0.200
    20.742    39.719     0.200
    20.847    39.681     0.200
    20.847    39.384     0.200
    21.014    39.489     0.200
    21.305    39.537     0.200
    21.305    37.967     0.200
    21.305    39.826     0.200
    21.335    40.495     0.200
    21.335    40.471     0.200
    21.335    38.893     0.200
    21.399    39.466     0.200
    21.499    38.281     0.200
    22.064    40.483     0.200
    24.912    33.639     0.200
    24.942    34.093     0.200
    24.942    32.804     0.200
    25.070    32.599     0.200
    25.197    32.520     0.200
    25.506    30.069     0.200
    25.414    35.191     0.200
    25.443    34.859     0.200
    25.587    29.012     0.200
    25.699    30.563     0.200
    25.836    33.856     0.200
    25.836    33.957     0.200
    26.065    31.891     0.200
    26.228    29.731     0.200
    26.509    32.002     0.200
    26.741    29.200     0.200
    26.493    32.595     0.200
    26.648    31.786     0.200
    27.067    27.694     0.200
    27.131    27.130     0.200
    28.263    25.032     0.200
    28.263    23.267     0.200
    28.263    27.548     0.200
    28.326    26.797     0.200
    29.854    22.472     0.200
    29.981    19.984     0.200
    15.103    41.318     0.200
    15.263    43.345     0.200
    15.337    45.283     0.200
    15.556    44.539     0.200
    15.899    44.733     0.200
    15.988    43.162     0.200
    17.456    41.963     0.200
    17.857    42.885     0.200
    20.094    40.307     0.200
    20.094    39.776     0.200
    20.459    40.417     0.200
    20.500    40.841     0.200
    20.842    39.949     0.200
    20.854    39.705     0.200
    20.877    39.600     0.200
    20.877    39.219     0.200
    20.877    40.287     0.200
    20.857    40.866     0.200
    21.015    40.370     0.200
    21.274    38.911     0.200
    21.274    37.429     0.200
    21.274    38.810     0.200
    21.274    38.698     0.200
    21.306    39.324     0.200
    21.306    38.426     0.200
    21.306    39.361     0.200
    21.306    38.086     0.200
    21.317    38.401     0.200
    21.367    38.834     0.200
    21.367    38.414     0.200
    21.352    40.900     0.200
    21.471    38.920     0.200
    21.471    38.209     0.200
    21.701    38.685     0.200
    21.701    40.785     0.200
    21.701    38.826     0.200
    21.966    38.527     0.200
    21.964    38.890     0.200
    23.412    36.056     0.200
    24.091    32.928     0.200
    24.037    34.872     0.200
    24.037    35.622     0.200
    24.137    36.891     0.200
    24.548    35.501     0.200
    24.878    33.198     0.200
    24.879    33.028     0.200
    24.909    32.538     0.200
    25.044    33.110     0.200
    25.171    31.932     0.200
    25.346    32.983     0.200
    25.387    33.407     0.200
    25.416    33.170     0.200
    25.533    31.597     0.200
    25.533    30.665     0.200
    25.533    31.495     0.200
    25.533    31.866     0.200
    25.533    31.366     0.200
    25.546    31.551     0.200
    25.619    28.883     0.200
    25.619    28.732     0.200
    25.615    29.869     0.200
    25.619    29.094     0.200
    25.621    30.162     0.200
    25.729    29.615     0.200
    25.809    32.175     0.200
    26.093    29.658     0.200
    26.093    30.268     0.200
    26.093    30.967     0.200
    26.093    31.168     0.200
    26.047    29.282     0.200
    26.047    28.051     0.200
    26.057    30.490     0.200
    26.298    28.262     0.200
    26.298    29.272     0.200
    26.482    30.428     0.200
    26.466    30.817     0.200
    26.752    29.175     0.200
    26.752    27.226     0.200
    26.621    30.106     0.200
    27.041    28.213     0.200
    27.041    30.344     0.200
    27.104    27.276     0.200
    27.104    27.165     0.200
    27.161    27.838     0.200
    27.440    28.630     0.200
    27.537    28.321     0.200
    27.818    26.961     0.200
    27.972    27.073     0.200
    28.235    26.007     0.200
    28.235    24.407     0.200
    28.235    26.267     0.200
    28.235    25.677     0.200
    28.235    23.866     0.200
    28.299    26.608     0.200
    28.498    25.539     0.200
    28.659    23.719     0.200
    28.616    24.506     0.200
    29.224    21.824     0.200
    29.824    20.919     0.200
    29.814    21.343     0.200
    29.979    18.186     0.200
    29.979    19.016     0.200
    29.979    18.516     0.200
    14.748    42.088     0.200
    15.330    45.298     0.200
    16.160    41.413     0.200
    16.196    44.288     0.200
    17.057    43.086     0.200
    17.057    42.324     0.200
    18.782    40.408     0.200
    20.278    36.644     0.200
    20.278    38.860     0.200
    20.150    40.348     0.200
    20.605    38.035     0.200
    20.878    37.973     0.200
    20.947    37.241     0.200
    20.947    37.461     0.200
    20.947    37.851     0.200
    21.041    36.823     0.200
    21.044    37.416     0.200
    21.044    37.741     0.200
    21.044    38.097     0.200
    21.129    39.914     0.200
    21.270    40.222     0.200
    22.360    38.656     0.200
    22.358    38.929     0.200
    22.358    38.679     0.200
    23.397    37.652     0.200
    24.281    34.638     0.200
    24.509    32.430     0.200
    24.539    32.833     0.200
    24.802    30.864     0.200
    25.138    32.840     0.200
    25.172    32.440     0.200
    25.799    31.002     0.200
    25.799    30.537     0.200
    26.148    30.770     0.200
    26.225    29.949     0.200
    26.198    31.012     0.200
    26.207    30.457     0.200
    26.207    30.557     0.200
    26.365    29.620     0.200
    26.783    27.146     0.200
    26.765    27.103     0.200
    27.968    23.631     0.200
    27.968    25.150     0.200
    27.968    25.511     0.200
    28.060    25.538     0.200
    29.538    20.798     0.200
    29.853    18.120     0.200
    14.368    43.422     0.200
    14.670    40.990     0.200
    15.903    45.501     0.200
    19.470    39.773     0.200
    19.852    37.825     0.200
    20.124    39.608     0.200
    20.259    40.465     0.200
    20.845    41.132     0.200
    20.896    40.361     0.200
    20.896    40.090     0.200
    21.002    40.573     0.200
    21.240    38.509     0.200
    21.240    37.969     0.200
    21.240    38.819     0.200
    21.274    39.526     0.200
    21.274    39.426     0.200
    21.274    39.251     0.200
    21.274    39.055     0.200
    21.334    38.749     0.200
    21.438    38.571     0.200
    21.438    38.321     0.200
    21.718    41.119     0.200
    21.997    38.812     0.200
    21.995    38.831     0.200
    23.390    37.627     0.200
    24.515    34.903     0.200
    24.846    32.667     0.200
    24.936    33.192     0.200
    25.012    33.905     0.200
    25.139    31.426     0.200
    25.355    32.903     0.200
    25.347    35.489     0.200
    25.384    32.965     0.200
    25.566    30.887     0.200
    25.578    33.992     0.200
    25.647    29.389     0.200
    25.777    31.871     0.200
    25.821    30.797     0.200
    26.125    31.110     0.200
    26.169    29.396     0.200
    26.449    30.227     0.200
    26.433    30.316     0.200
    26.774    28.639     0.200
    26.914    28.007     0.200
    27.072    28.391     0.200
    27.072    30.161     0.200
    27.407    27.871     0.200
    27.822    27.058     0.200
    28.203    25.978     0.200
    28.203    26.169     0.200
    28.267    26.321     0.200
    28.640    25.024     0.200
    29.791    20.506     0.200
    29.949    19.293     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     5.446    16.194     0.200
     6.391    19.169     0.200
     6.859    20.706     0.200
    14.288    35.007     0.200
    15.447    37.486     0.200
    15.996    39.080     0.200
    17.571    39.701     0.200
    20.237    39.587     0.200
    10.289    25.303     0.200
     2.344    10.617     0.200
     2.344    10.117     0.200
     5.073    16.273     0.200
     5.630    15.776     0.200
     6.341    19.976     0.200
     7.429    20.776     0.200
     7.541    21.468     0.200
    11.174    25.071     0.200
    14.855    34.115     0.200
     2.141     9.804     0.200
     5.022    19.183     0.200
     5.048    15.878     0.200
     5.812    16.069     0.200
     7.622    21.038     0.200
     7.707    20.847     0.200
     7.707    21.347     0.200
    16.107    34.124     0.200
    16.365    37.807     0.200
    20.817    41.856     0.200
    20.817    42.356     0.200
     2.074     8.331     0.200
     2.438    11.377     0.200
     4.920    14.118     0.200
     4.920    14.419     0.200
     5.096    15.657     0.200
     7.815    20.326     0.200
    10.895    24.489     0.200
    15.065    31.228     0.200
    16.238    32.534     0.200
    16.329    37.976     0.200
     2.812    11.492     0.200
     3.980    14.559     0.200
     4.385    15.828     0.200
     5.272    18.484     0.200
     5.272    19.083     0.200
     7.026    21.714     0.200
     7.234    21.581     0.200
    11.565    28.035     0.200
    11.565    28.836     0.200
    14.791    34.594     0.200
     2.372    10.838     0.200
     2.275    11.267     0.200
     2.758    12.232     0.200
     2.758    12.927     0.200
     3.068    14.106     0.200
     4.190    14.517     0.200
     4.297    14.161     0.200
     4.297    13.864     0.200
     5.429    16.953     0.200
     6.645    18.161     0.200
     6.718    18.917     0.200
     6.718    19.714     0.200
     7.802    20.971     0.200
     7.802    20.471     0.200
     8.473    24.437     0.200
     8.473    24.234     0.200
     8.473    24.734     0.200
     8.658    24.269     0.200
     8.658    23.769     0.200
     8.773    23.530     0.200
    10.119    24.223     0.200
    10.119    24.622     0.200
    16.714    32.763     0.200
    17.298    30.451     0.200
    20.504    43.035     0.200
     2.307    11.945     0.200
     2.205    12.133     0.200
     2.450    12.879     0.200
     2.679    13.003     0.200
     3.135    16.179     0.200
     3.135    15.980     0.200
     4.321    14.440     0.200
     4.321    14.839     0.200
     5.503    18.747     0.200
     6.794    21.889     0.200
     7.879    22.527     0.200
     8.546    28.541     0.200
     8.546    27.244     0.200
     8.736    24.920     0.200
     8.736    25.119     0.200
     8.736    15.920     0.200
     8.852    25.670     0.200
    10.047    26.628     0.200
    10.047    26.828     0.200
    15.990    37.064     0.200
    16.668    33.855     0.200
    17.126    38.006     0.200
    17.314    32.714     0.200
    20.579    44.710     0.200
    20.626    42.160     0.200
     3.509    13.360     0.200
     3.949    15.133     0.200
     4.335    17.225     0.200
     5.253    17.209     0.200
     5.632    18.093     0.200
     6.359    18.611     0.200
     6.988    21.269     0.200
     7.232    22.416     0.200
     7.232    32.217     0.200
    14.734    37.865     0.200
    14.854    33.774     0.200
    16.137    38.301     0.200
    17.655    35.986     0.200
    18.006    35.181     0.200
    19.121    41.671     0.200
    19.480    43.478     0.200
    19.916    41.397     0.200
     2.477    13.032     0.200
     2.495    12.529     0.200
     3.738    13.320     0.200
     4.224    14.643     0.200
     7.921    26.400     0.200
     8.189    23.578     0.200
    10.683    25.464     0.200
    11.946    31.228     0.200
    11.946    31.329     0.200
    16.902    36.393     0.200
    16.902    36.694     0.200
    17.334    34.354     0.200
    17.442    39.087     0.200
    20.078    39.929     0.200
    20.241    39.427     0.200
    20.330    40.387     0.200
    20.617    43.538     0.200
     2.246    11.071     0.200
     2.246    11.470     0.200
     2.285    11.414     0.200
     2.467    10.486     0.200
     2.467    10.189     0.200
     2.467    10.384     0.200
     3.036    12.952     0.200
     3.713    14.853     0.200
     3.707    13.914     0.200
     4.392    16.825     0.200
     4.713    15.785     0.200
     5.690    16.377     0.200
     6.351    19.162     0.200
     6.788    19.770     0.200
     7.433    22.540     0.200
     7.433    26.337     0.200
     7.433    22.438     0.200
     7.656    23.339     0.200
     7.656    23.643     0.200
     7.818    23.044     0.200
    11.159    24.554     0.200
    17.528    31.224     0.200
    17.612    32.250     0.200
    19.547    42.173     0.200
    20.314    40.214     0.200
     8.255    21.897     0.200
    18.473    41.654     0.200
    20.066    38.557     0.200
     2.218     9.808     0.200
     2.854    12.091     0.200
     3.322    13.136     0.200
     3.666    13.117     0.200
     3.666    13.820     0.200
     5.621    18.305     0.200
     5.621    18.602     0.200
     6.965    20.617     0.200
     8.599    24.550     0.200
     8.599    25.346     0.200
     8.989    25.999     0.200
    13.747    31.672     0.200
    14.599    35.028     0.200
    14.923    36.344     0.200
    15.014    34.884     0.200
    15.333    37.466     0.200
    15.635    36.941     0.200
    16.602    36.148     0.200
    16.602    36.445     0.200
    18.976    41.050     0.200
    20.863    39.421     0.200
    20.879    40.744     0.200
     1.715     9.879     0.200
     1.824     9.514     0.200
     3.181    12.770     0.200
     3.181    12.974     0.200
     4.166    14.681     0.200
     4.497    14.917     0.200
     6.458    18.932     0.200
     7.379    20.788     0.200
     8.233    23.815     0.200
     8.233    24.018     0.200
    10.523    24.594     0.200
    18.794    39.074     0.200
    20.123    39.962     0.200
    20.947    38.942     0.200
     1.927    10.124     0.200
     1.927     9.925     0.200
     2.193    11.518     0.200
     2.193    11.319     0.200
     2.298    11.295     0.200
     2.870    11.620     0.200
     2.870    12.120     0.200
     3.470    13.625     0.200
     3.595    14.358     0.200
     4.099    13.877     0.200
     4.099    14.778     0.200
     4.726    16.166     0.200
     5.852    18.425     0.200
     6.174    19.060     0.200
     6.513    19.208     0.200
     7.178    21.851     0.200
     7.828    22.563     0.200
     8.294    23.728     0.200
     8.861    25.810     0.200
     9.170    25.099     0.200
     9.345    24.355     0.200
     9.438    26.270     0.200
    14.094    33.635     0.200
    14.883    38.728     0.200
    15.357    37.895     0.200
    15.395    36.052     0.200
    15.762    38.474     0.200
    16.068    38.106     0.200
    16.089    37.773     0.200
    17.765    37.800     0.200
    18.417    42.290     0.200
    19.413    40.063     0.200
    19.621    40.635     0.200
    19.930    41.327     0.200
     1.970     9.165     0.200
     1.970     9.366     0.200
     2.054    10.279     0.200
     3.000    13.041     0.200
     3.495    12.163     0.200
     3.516    14.023     0.200
     4.244    13.726     0.200
     4.769    16.399     0.200
     4.836    15.720     0.200
     6.026    17.024     0.200
     6.026    17.724     0.200
     7.089    19.521     0.200
     7.823    21.859     0.200
     7.935    21.555     0.200
     8.025    23.502     0.200
     8.331    20.733     0.200
    10.778    26.168     0.200
     2.165    11.456     0.200
     2.216    12.560     0.200
     2.218    12.835     0.200
     3.413    15.697     0.200
     3.684    16.032     0.200
     3.684    16.227     0.200
     4.571    17.371     0.200
     4.571    17.269     0.200
     4.922    18.385     0.200
     7.746    24.222     0.200
     2.104     9.963     0.200
     2.230    10.596     0.200
     2.231    10.581     0.200
     2.665    12.018     0.200
     3.453    13.717     0.200
     3.692    14.235     0.200
     4.237    14.879     0.200
     4.237    14.176     0.200
     4.613    16.081     0.200
     4.983    15.867     0.200
     5.898    17.287     0.200
     6.536    21.046     0.200
     6.921    18.853     0.200
     7.668    22.337     0.200
     7.764    23.015     0.200
     7.850    22.716     0.200
    16.801    38.545     0.200
     1.952     9.904     0.200
     2.432    12.195     0.200
     3.299    12.476     0.200
     3.888    14.604     0.200
     4.361    16.584     0.200
     1.763     8.789     0.200
     1.719     9.404     0.200
     2.120    10.123     0.200
     2.887    11.871     0.200
     3.095    11.736     0.200
     4.099    14.720     0.200
     4.183    14.042     0.200
     8.635    24.688     0.200
     2.261    10.451     0.200
     2.527    11.840     0.200
     3.199    12.898     0.200
     3.288    13.657     0.200
     3.853    14.470     0.200
     4.189    14.648     0.200
     4.433    15.397     0.200
     4.434    15.392     0.200
     4.448    15.721     0.200
     4.744    14.870     0.200
     5.094    16.281     0.200
     5.164    17.669     0.200
     5.695    17.370     0.200
     5.695    17.670     0.200
     5.733    17.233     0.200
     6.369    18.310     0.200
     6.752    18.933     0.200
     7.503    21.768     0.200
     7.503    21.468     0.200
     7.595    22.793     0.200
     7.595    22.493     0.200
     7.684    22.158     0.200
     8.414    21.337     0.200
     1.946     9.604     0.200
     2.236    11.120     0.200
     2.835    12.031     0.200
     3.985    14.109     0.200
     3.884    13.686     0.200
     4.098    14.696     0.200
     5.042    16.580     0.200
     5.044    16.552     0.200
     5.233    17.246     0.200
     5.774    18.130     0.200
     6.242    17.978     0.200
     7.650    18.867     0.200
     7.657    20.860     0.200
     8.258    25.251     0.200
     8.529    24.879     0.200
     8.697    23.622     0.200
    12.931    32.909     0.200
    15.988    35.668     0.200
     1.731    11.340     0.200
     1.731    12.139     0.200
     1.731    11.139     0.200
     1.820    11.006     0.200
     2.199    12.681     0.200
     2.199    12.482     0.200
     2.828    13.536     0.200
     3.094    13.936     0.200
     3.882    15.337     0.200
     4.021    14.419     0.200
     4.074    15.597     0.200
     4.074    14.998     0.200
     4.131    15.431     0.200
     8.695    26.373     0.200
     8.695    25.174     0.200
     2.206     9.939     0.200
     2.206    10.540     0.200
     2.226    11.715     0.200
     2.828    12.489     0.200
     2.962    13.319     0.200
     3.625    14.386     0.200
     3.625    14.487     0.200
     3.926    14.566     0.200
     3.954    14.652     0.200
     4.852    16.462     0.200
     5.077    16.545     0.200
     5.580    17.273     0.200
     7.526    23.253     0.200
     8.407    25.376     0.200
     8.606    24.855     0.200
     2.072     9.816     0.200
     2.201    10.720     0.200
     2.694    12.663     0.200
     3.486    13.920     0.200
     3.662    14.267     0.200
     3.662    13.767     0.200
     4.250    14.305     0.200
     4.618    16.304     0.200
     4.646    15.686     0.200
     4.964    15.970     0.200
     5.350    17.766     0.200
     5.931    17.388     0.200
     7.796    23.218     0.200
     7.796    22.418     0.200
     7.881    24.628     0.200
     7.881    23.529     0.200
    10.907    26.421     0.200
     2.302    10.835     0.200
     2.449    11.615     0.200
     2.501    12.015     0.200
     3.241    12.978     0.200
     3.914    14.418     0.200
     4.203    14.244     0.200
     4.271    14.861     0.200
     4.401    14.940     0.200
     4.396    15.403     0.200
     4.826    15.978     0.200
     4.860    16.479     0.200
     4.862    15.856     0.200
     5.154    16.257     0.200
     5.643    18.440     0.200
     5.643    16.940     0.200
     5.684    16.866     0.200
     6.317    18.173     0.200
     6.317    17.173     0.200
     6.355    18.436     0.200
     6.355    18.135     0.200
     6.698    19.137     0.200
     7.456    21.087     0.200
     7.456    21.189     0.200
     7.531    22.412     0.200
     7.539    22.815     0.200
     7.539    22.116     0.200
     7.624    22.322     0.200
     8.451    21.553     0.200
     8.451    21.100     0.200
    10.046    24.862     0.200
    11.157    25.390     0.200
    11.157    25.120     0.200
    14.075    33.646     0.200
    15.175    35.809     0.200
    15.377    36.411     0.200
    15.452    37.574     0.200
    15.984    35.863     0.200
    16.228    37.221     0.200
    16.228    37.041     0.200
    16.320    38.467     0.200
    18.327    41.218     0.200
    18.435    39.956     0.200
    18.430    41.116     0.200
    19.423    39.929     0.200
    20.193    39.348     0.200
     2.334    10.838     0.200
     2.334    11.338     0.200
     2.483    12.506     0.200
     2.499    11.918     0.200
     2.499    12.020     0.200
     3.205    13.482     0.200
     3.963    15.232     0.200
     3.963    15.131     0.200
     4.218    14.959     0.200
     4.365    15.444     0.200
     4.368    16.106     0.200
     4.795    16.122     0.200
     5.202    16.875     0.200
     5.202    16.477     0.200
     5.647    17.678     0.200
     6.358    19.576     0.200
     6.655    19.414     0.200
     7.495    23.109     0.200
     7.577    22.253     0.200
     2.301    10.843     0.200
     2.479    11.769     0.200
     2.479    11.871     0.200
     2.517    12.617     0.200
     2.517    12.515     0.200
     3.237    13.820     0.200
     3.237    13.719     0.200
     3.941    14.996     0.200
     4.243    13.872     0.200
     4.397    14.383     0.200
     4.397    15.383     0.200
     4.402    15.927     0.200
     4.829    16.847     0.200
     5.196    16.748     0.200
     5.196    16.553     0.200
     5.679    17.618     0.200
     6.684    18.692     0.200
     7.523    23.195     0.200
     7.523    23.399     0.200
     9.637    25.835     0.200
     2.299    10.533     0.200
     2.299    11.232     0.200
     2.464    11.612     0.200
     2.512    12.051     0.200
     3.241    13.244     0.200
     3.241    13.647     0.200
     3.927    15.031     0.200
     3.927    14.633     0.200
     4.226    14.940     0.200
     4.401    15.506     0.200
     4.401    15.405     0.200
     4.401    16.201     0.200
     5.131    17.488     0.200
     5.176    16.559     0.200
     6.315    18.969     0.200
     6.375    18.271     0.200
     6.692    19.367     0.200
     7.532    23.061     0.200
     7.614    21.407     0.200
     7.614    22.509     0.200
     2.313    10.864     0.200
     2.313    11.763     0.200
     2.494    12.052     0.200
     2.509    12.872     0.200
     3.224    14.229     0.200
     3.224    14.128     0.200
     3.957    15.481     0.200
     4.245    15.619     0.200
     4.384    15.791     0.200
     5.120    18.102     0.200
     5.210    17.157     0.200
     5.210    17.357     0.200
     5.666    18.833     0.200
     6.296    18.986     0.200
     6.386    18.725     0.200
     6.386    18.827     0.200
     6.670    19.216     0.200
     7.587    22.815     0.200
     9.622    26.669     0.200
     2.299    10.088     0.200
     2.299    10.688     0.200
     2.451    11.107     0.200
     2.451    10.908     0.200
     2.506    11.864     0.200
     3.243    13.563     0.200
     3.915    14.517     0.200
     4.211    14.170     0.200
     4.403    15.923     0.200
     4.400    15.767     0.200
     5.130    17.449     0.200
     5.158    16.413     0.200
     5.687    17.650     0.200
     6.699    21.938     0.200
     7.540    23.422     0.200
     7.624    22.740     0.200
     2.314    11.127     0.200
     3.158    13.180     0.200
     3.224    13.412     0.200
     3.953    15.295     0.200
     4.238    14.871     0.200
     4.238    14.676     0.200
     4.259    17.122     0.200
     4.389    16.310     0.200
     4.384    15.773     0.200
     4.384    15.671     0.200
     4.815    16.530     0.200
     5.118    17.700     0.200
     5.204    16.500     0.200
     5.204    16.906     0.200
     5.621    17.134     0.200
     5.621    17.439     0.200
     5.666    17.413     0.200
     6.296    18.060     0.200
     6.380    19.173     0.200
     6.380    18.572     0.200
     6.671    19.283     0.200
     7.439    21.620     0.200
     7.439    21.722     0.200
     7.510    21.887     0.200
     7.510    22.184     0.200
     7.589    21.861     0.200
     7.589    22.564     0.200
     8.497    21.119     0.200
     8.598    25.184     0.200
    11.180    26.167     0.200
    11.180    25.987     0.200
    14.125    34.585     0.200
    15.221    35.093     0.200
    15.330    35.884     0.200
    15.935    34.463     0.200
    16.351    38.040     0.200
    16.351    38.907     0.200
    19.393    39.717     0.200
     2.301    10.743     0.200
     2.301    10.540     0.200
     2.462    11.763     0.200
     2.509    11.515     0.200
     2.509    12.413     0.200
     3.239    13.383     0.200
     3.926    15.179     0.200
     4.221    14.527     0.200
     4.400    15.547     0.200
     4.400    15.149     0.200
     4.399    16.259     0.200
     4.828    16.451     0.200
     5.172    16.827     0.200
     5.172    16.632     0.200
     5.129    17.939     0.200
     5.640    19.076     0.200
     5.682    17.679     0.200
     6.370    18.654     0.200
     6.692    21.497     0.200
     7.533    22.485     0.200
     7.533    23.188     0.200
     7.615    22.423     0.200
     7.615    22.728     0.200
     8.471    21.383     0.200
     8.471    21.008     0.200
    12.187    29.960     0.200
    15.361    36.085     0.200
    17.338    36.731     0.200
     2.330    11.452     0.200
     2.330    10.952     0.200
     2.518    12.663     0.200
     3.206    14.535     0.200
     3.206    14.937     0.200
     4.250    15.450     0.200
     4.250    15.348     0.200
     4.366    16.099     0.200
     4.366    16.298     0.200
     4.377    16.871     0.200
     4.801    17.322     0.200
     5.232    17.986     0.200
     5.232    17.884     0.200
     6.276    20.311     0.200
     6.386    20.117     0.200
     6.649    22.555     0.200
     6.649    20.555     0.200
     7.421    23.647     0.200
     7.487    22.975     0.200
     7.487    23.174     0.200
     7.564    23.176     0.200
     7.564    23.578     0.200
     8.517    23.247     0.200
     8.591    26.389     0.200
    11.200    29.240     0.200
    15.301    36.511     0.200
    16.360    37.498     0.200
    17.348    38.191     0.200
     2.300    10.634     0.200
     2.300     9.931     0.200
     2.443    11.965     0.200
     2.443    11.762     0.200
     3.243    12.719     0.200
     3.908    15.266     0.200
     4.198    14.984     0.200
     4.404    15.485     0.200
     4.397    16.361     0.200
     5.146    16.823     0.200
     5.146    16.925     0.200
     6.321    20.304     0.200
     7.544    23.238     0.200
     7.544    22.238     0.200
     7.630    22.031     0.200
     2.305    10.875     0.200
     2.499    10.012     0.200
     2.659    11.643     0.200
     3.082    12.515     0.200
     3.326    12.561     0.200
     3.489    14.654     0.200
     3.854    14.602     0.200
     3.825    13.939     0.200
     4.683    17.230     0.200
     4.956    16.436     0.200
     5.405    17.905     0.200
     5.689    17.082     0.200
     7.176    18.119     0.200
     8.326    24.707     0.200
     8.497    26.714     0.200
     8.497    23.694     0.200
    10.731    27.140     0.200
     1.628     9.855     0.200
     2.126     9.936     0.200
     2.126     9.635     0.200
     2.299    11.327     0.200
     2.299    11.728     0.200
     2.934    12.615     0.200
     3.696    13.719     0.200
     3.871    14.180     0.200
     5.181    17.092     0.200
     5.181    16.991     0.200
     6.062    18.108     0.200
     8.191    25.858     0.200
     8.507    24.771     0.200
     8.701    25.112     0.200
     8.701    24.412     0.200
     9.059    24.869     0.200
    10.440    25.820     0.200
    17.269    36.820     0.200
     1.913    10.414     0.200
     2.428    11.505     0.200
     3.253    13.277     0.200
     3.861    14.385     0.200
     4.328    14.831     0.200
     2.309    10.821     0.200
     2.309    10.622     0.200
     2.466    11.792     0.200
     2.499    12.304     0.200
     2.499    12.004     0.200
     3.232    13.558     0.200
     3.930    14.902     0.200
     4.214    16.299     0.200
     4.392    15.820     0.200
     4.392    15.519     0.200
     4.390    16.036     0.200
     5.120    17.423     0.200
     5.172    16.709     0.200
     5.172    17.010     0.200
     5.674    17.450     0.200
     6.307    19.169     0.200
     6.362    18.733     0.200
     6.685    21.456     0.200
     7.526    22.542     0.200
     7.609    22.468     0.200
     8.593    27.198     0.200
    11.168    28.639     0.200
    17.347    38.426     0.200
    20.119    42.581     0.200
     1.539     9.761     0.200
     2.428    11.491     0.200
     2.428    12.089     0.200
     2.783    13.852     0.200
     2.954    13.048     0.200
     3.358    13.133     0.200
     3.702    14.223     0.200
     3.987    15.100     0.200
     3.987    15.299     0.200
     4.804    17.560     0.200
     5.087    17.861     0.200
     5.087    18.560     0.200
     5.738    18.258     0.200
     5.738    18.559     0.200
     7.569    24.291     0.200
     8.460    23.690     0.200
     8.700    25.199     0.200
     8.700    25.699     0.200
    10.617    26.723     0.200
    11.798    27.445     0.200
     2.105    10.945     0.200
     2.276    11.849     0.200
     2.679    13.045     0.200
     3.735    14.623     0.200
     3.735    15.123     0.200
     4.589    16.455     0.200
     5.045    17.232     0.200
     5.045    17.029     0.200
     7.737    24.421     0.200
     7.814    23.716     0.200
     7.814    23.216     0.200
     2.371    11.632     0.200
     2.371    11.429     0.200
     2.465    12.734     0.200
     2.555    12.378     0.200
     3.108    14.230     0.200
     3.165    14.365     0.200
     3.740    15.449     0.200
     4.325    16.624     0.200
     4.338    16.776     0.200
     5.066    18.276     0.200
     5.257    17.943     0.200
     5.606    18.876     0.200
     5.606    18.775     0.200
     6.364    19.922     0.200
     6.364    20.126     0.200
     6.607    20.893     0.200
     7.380    21.880     0.200
     7.446    24.006     0.200
     7.446    23.506     0.200
     7.524    23.196     0.200
    20.126    41.009     0.200
     1.989    11.803     0.200
     1.989    11.903     0.200
     2.332    12.401     0.200
     2.332    12.801     0.200
     2.656    14.017     0.200
     3.366    13.936     0.200
     4.094    15.531     0.200
     1.551     9.548     0.200
     2.357     9.748     0.200
     2.352    11.007     0.200
     2.352    10.608     0.200
     2.801    11.859     0.200
     2.801    11.660     0.200
     2.948    12.351     0.200
     3.782    13.609     0.200
     3.977    14.143     0.200
     4.261    15.322     0.200
     5.549    18.091     0.200
     5.834    17.464     0.200
     5.834    17.061     0.200
     1.795    10.932     0.200
     2.267    12.219     0.200
     2.226    12.301     0.200
     2.838    12.950     0.200
     2.838    12.848     0.200
     3.128    14.765     0.200
     3.566    14.662     0.200
     3.494    14.801     0.200
     4.086    15.095     0.200
     4.086    14.994     0.200
     4.384    16.413     0.200
     4.694    16.597     0.200
     4.694    16.894     0.200
     5.576    19.395     0.200
     5.591    18.728     0.200
     5.684    19.336     0.200
     5.820    19.049     0.200
     5.844    19.872     0.200
     5.762    19.336     0.200
     5.786    19.248     0.200
     5.786    19.748     0.200
     6.193    19.005     0.200
     6.409    20.084     0.200
     6.497    19.749     0.200
     6.497    19.549     0.200
     7.106    21.349     0.200
     7.492    19.319     0.200
     7.492    19.839     0.200
     7.796    22.788     0.200
     7.796    24.187     0.200
     7.796    22.488     0.200
     7.796    23.788     0.200
     8.262    24.161     0.200
     8.262    23.961     0.200
     8.830    25.124     0.200
     8.830    26.526     0.200
     9.138    25.531     0.200
     9.138    25.934     0.200
     9.313    25.490     0.200
     9.313    25.591     0.200
     9.646    27.008     0.200
    11.400    28.540     0.200
    14.104    36.874     0.200
    14.900    37.594     0.200
    14.900    37.305     0.200
    15.344    39.312     0.200
    16.061    38.640     0.200
    16.083    38.438     0.200
    17.129    37.453     0.200
    17.129    38.199     0.200
    17.145    37.997     0.200
    17.735    37.102     0.200
    18.035    41.308     0.200
    19.925    41.148     0.200
    21.026    42.200     0.200
     2.252    10.914     0.200
     2.402    10.761     0.200
     3.211    13.321     0.200
     3.292    13.472     0.200
     3.866    14.381     0.200
     4.452    16.536     0.200
     5.121    16.434     0.200
     2.324    11.052     0.200
     2.484    10.784     0.200
     2.474    12.193     0.200
     3.143    14.191     0.200
     3.217    13.523     0.200
     4.378    15.687     0.200
     4.375    15.911     0.200
     5.174    16.487     0.200
     6.348    18.788     0.200
     6.673    19.200     0.200
     7.514    22.983     0.200
     7.514    23.084     0.200
     7.599    22.188     0.200
     7.599    22.594     0.200
     1.790    11.020     0.200
     1.835    11.700     0.200
     1.835    12.400     0.200
     2.325    12.685     0.200
     3.187    14.126     0.200
     3.961    15.584     0.200
     4.243    16.294     0.200
     1.669    10.906     0.200
     1.963     9.178     0.200
     1.963     8.977     0.200
     2.233    10.427     0.200
     2.844    11.199     0.200
     2.844    11.500     0.200
     3.010    12.559     0.200
     3.010    12.158     0.200
     3.751    14.314     0.200
     3.811    13.621     0.200
     3.868    12.652     0.200
     3.982    13.716     0.200
     4.087    14.293     0.200
     5.222    16.751     0.200
     5.297    17.167     0.200
     6.225    17.746     0.200
     6.510    19.120     0.200
     6.538    19.189     0.200
     7.193    19.949     0.200
     7.193    19.839     0.200
     7.647    22.247     0.200
     7.637    19.162     0.200
     8.520    23.359     0.200
     8.690    23.480     0.200
     9.172    24.249     0.200
    10.366    27.912     0.200
    10.366    26.453     0.200
    11.559    30.096     0.200
    12.573    29.565     0.200
    12.687    32.035     0.200
    15.096    37.615     0.200
    15.223    35.336     0.200
    15.457    36.208     0.200
    15.971    39.454     0.200
    16.550    35.924     0.200
    16.550    36.180     0.200
    16.565    35.977     0.200
    17.172    37.585     0.200
    17.831    40.005     0.200
    19.829    39.888     0.200
     1.918    12.625     0.200
     1.918    13.025     0.200
     2.296    12.414     0.200
     2.296    12.815     0.200
     2.698    13.418     0.200
     3.291    14.602     0.200
     3.291    14.703     0.200
     3.625    15.703     0.200
     4.082    15.473     0.200
     4.218    14.688     0.200
     4.301    16.615     0.200
     4.301    16.715     0.200
     5.448    19.131     0.200
     5.448    19.631     0.200
     6.413    20.470     0.200
     6.576    19.868     0.200
     7.836    23.663     0.200
     7.920    22.882     0.200
     8.486    26.574     0.200
     8.697    25.511     0.200
     8.697    25.911     0.200
     8.826    25.410     0.200
     8.826    25.310     0.200
     9.279    27.720     0.200
     9.487    27.691     0.200
    10.109    27.835     0.200
    10.109    25.676     0.200
    13.043    31.990     0.200
    14.575    39.621     0.200
    15.214    35.453     0.200
    15.447    39.135     0.200
    16.550    37.983     0.200
    16.550    38.788     0.200
    17.149    37.975     0.200
     2.571    12.107     0.200
     2.776    12.419     0.200
     2.727    12.781     0.200
     2.885    11.745     0.200
     2.885    11.346     0.200
     3.675    12.926     0.200
     3.710    14.315     0.200
     3.881    14.729     0.200
     3.881    15.026     0.200
     4.111    15.543     0.200
     4.247    15.648     0.200
     4.297    15.272     0.200
     4.541    16.223     0.200
     5.166    16.228     0.200
     5.166    16.126     0.200
     5.166    16.523     0.200
     5.166    19.023     0.200
     5.170    16.577     0.200
     5.831    17.270     0.200
     5.831    17.473     0.200
     5.831    16.270     0.200
     5.831    18.066     0.200
     6.007    18.614     0.200
     6.257    18.188     0.200
     6.929    20.746     0.200
     7.123    21.589     0.200
     7.750    21.767     0.200
     7.760    21.647     0.200
     7.808    22.690     0.200
     7.808    22.588     0.200
     7.970    22.514     0.200
     8.082    19.434     0.200
     8.139    23.758     0.200
    10.340    24.645     0.200
    10.604    28.262     0.200
    11.288    29.687     0.200
    11.572    28.269     0.200
    11.663    26.413     0.200
    14.568    35.705     0.200
    14.816    37.911     0.200
    15.278    36.021     0.200
    15.945    35.528     0.200
    15.972    37.816     0.200
    16.229    36.322     0.200
    17.710    39.640     0.200
     2.663    11.342     0.200
     3.360    11.410     0.200
     4.609    15.737     0.200
     4.990    14.994     0.200
     6.531    20.502     0.200
     7.758    22.582     0.200
     7.758    22.182     0.200
     7.844    22.487     0.200
     7.844    22.688     0.200
     2.316    13.028     0.200
     2.679    13.593     0.200
     3.303    14.614     0.200
     3.605    16.083     0.200
     4.062    16.050     0.200
     4.498    17.168     0.200
     1.803    10.134     0.200
     1.800     8.971     0.200
     1.800     9.572     0.200
     2.289    10.875     0.200
     2.742    11.681     0.200
     3.158    12.529     0.200
     3.158    12.428     0.200
     3.992    14.191     0.200
     4.210    14.953     0.200
     5.350    17.747     0.200
     6.387    18.041     0.200
     6.387    18.241     0.200
     6.310    18.939     0.200
     8.782    24.099     0.200
     9.119    24.063     0.200
    10.224    27.762     0.200
    12.771    33.349     0.200
    12.948    31.679     0.200
    17.480    40.085     0.200
     1.985    13.074     0.200
     2.520    13.533     0.200
     2.520    13.432     0.200
     2.528    14.342     0.200
     3.314    14.763     0.200
     3.506    14.930     0.200
     3.774    15.701     0.200
     4.405    16.835     0.200
     4.405    15.835     0.200
     5.538    19.507     0.200
     5.538    19.406     0.200
     6.066    20.349     0.200
     6.413    20.002     0.200
     6.413    19.901     0.200
     6.826    21.679     0.200
     7.510    22.590     0.200
     7.510    22.395     0.200
     7.510    22.266     0.200
     7.510    22.797     0.200
     7.621    20.667     0.200
     7.965    22.890     0.200
     8.559    28.352     0.200
     8.837    26.309     0.200
     8.837    26.208     0.200
     9.002    26.491     0.200
     9.227    26.458     0.200
     9.227    27.056     0.200
     9.449    26.316     0.200
    14.909    34.555     0.200
    16.815    38.281     0.200
    20.415    42.019     0.200
     1.614    10.504     0.200
     1.928    13.043     0.200
     2.683    13.539     0.200
     3.299    14.641     0.200
     3.299    14.540     0.200
     4.064    15.714     0.200
     4.064    15.613     0.200
     4.313    17.206     0.200
     4.313    16.706     0.200
     6.042    19.233     0.200
     6.574    20.129     0.200
     7.419    22.355     0.200
     8.841    26.364     0.200
     8.841    27.763     0.200
    10.098    26.995     0.200
    11.555    30.496     0.200
    15.445    38.694     0.200
     1.939     8.696     0.200
     2.004     9.935     0.200
     2.004     9.834     0.200
     2.808    11.457     0.200
     3.466    13.073     0.200
     3.466    13.273     0.200
     3.651    13.720     0.200
     4.655    16.794     0.200
     4.757    15.609     0.200
     4.790    15.324     0.200
     4.790    15.125     0.200
     4.809    15.599     0.200
     4.809    15.798     0.200
     6.480    18.103     0.200
     7.092    19.959     0.200
     7.134    22.865     0.200
     7.981    23.189     0.200
     9.068    23.198     0.200
     1.819    10.065     0.200
     1.819    10.167     0.200
     1.847    10.039     0.200
     1.847     9.738     0.200
     2.346    11.113     0.200
     2.346    11.413     0.200
     2.704    11.742     0.200
     2.704    11.941     0.200
     3.161    12.505     0.200
     3.518    13.433     0.200
     3.915    14.100     0.200
     3.915    13.901     0.200
     4.234    14.581     0.200
     4.234    14.682     0.200
     5.181    16.927     0.200
     5.370    17.121     0.200
     5.370    16.621     0.200
     6.342    19.083     0.200
     6.342    18.384     0.200
     7.669    21.203     0.200
     7.791    23.971     0.200
     8.663    23.002     0.200
     8.824    24.714     0.200
     9.102    24.072     0.200
    12.870    32.355     0.200
    12.870    32.007     0.200
    16.991    38.208     0.200
     2.010    10.190     0.200
     2.717    12.741     0.200
     4.083    14.995     0.200
     4.124    14.511     0.200
     4.124    13.909     0.200
     4.406    15.025     0.200
     4.737    16.058     0.200
     4.737    15.957     0.200
     4.677    16.161     0.200
     4.747    16.543     0.200
     4.975    17.683     0.200
     5.298    17.520     0.200
     5.410    17.204     0.200
     7.090    20.701     0.200
     7.799    22.627     0.200
     7.942    23.059     0.200
     8.050    24.193     0.200
     8.975    26.611     0.200
    20.581    39.063     0.200
     1.897     8.734     0.200
     1.897     8.632     0.200
     2.268    10.202     0.200
     2.790    11.611     0.200
     3.078    11.641     0.200
     3.078    12.243     0.200
     3.700    13.883     0.200
     3.972    13.611     0.200
     4.147    15.268     0.200
     5.284    16.601     0.200
     5.828    17.152     0.200
     6.291    17.751     0.200
     6.291    18.051     0.200
     6.336    18.425     0.200
     7.673    20.622     0.200
     8.739    25.578     0.200
    12.922    31.789     0.200
    17.052    36.167     0.200
    17.430    37.754     0.200
    20.667    38.780     0.200
     2.045     9.372     0.200
     2.045     9.172     0.200
     2.142    10.047     0.200
     2.142     9.946     0.200
     2.711    11.398     0.200
     3.339    10.570     0.200
     3.410    12.948     0.200
     3.525    14.304     0.200
     3.525    14.405     0.200
     3.604    13.076     0.200
     4.226    13.819     0.200
     4.537    15.589     0.200
     4.536    15.106     0.200
     4.646    15.821     0.200
     4.684    15.377     0.200
     4.902    15.328     0.200
     4.902    15.028     0.200
     4.951    15.262     0.200
     5.435    16.908     0.200
     5.603    16.557     0.200
     5.970    17.266     0.200
     6.194    17.255     0.200
     6.441    18.766     0.200
     6.441    18.066     0.200
     6.611    17.686     0.200
     6.611    18.285     0.200
     7.000    20.544     0.200
     7.227    20.196     0.200
     7.738    21.732     0.200
     7.738    21.632     0.200
     7.845    22.384     0.200
     7.935    22.235     0.200
     7.935    22.135     0.200
     8.974    24.956     0.200
    13.841    33.725     0.200
    13.841    34.110     0.200
    15.647    35.216     0.200
     1.375    11.464     0.200
     2.167    11.419     0.200
     2.167    12.919     0.200
     2.616    11.873     0.200
     2.616    12.373     0.200
     2.627    13.647     0.200
     2.840    14.068     0.200
     2.950    15.276     0.200
     2.950    13.176     0.200
     3.818    14.147     0.200
     3.932    15.222     0.200
     4.101    16.954     0.200
     4.075    16.555     0.200
     4.109    16.356     0.200
     4.109    16.555     0.200
     4.806    18.220     0.200
     5.173    18.442     0.200
     5.173    18.041     0.200
     5.372    18.514     0.200
     5.396    19.835     0.200
     5.622    18.804     0.200
     6.045    19.159     0.200
     6.045    19.358     0.200
     6.042    19.994     0.200
     6.042    20.713     0.200
     7.421    24.501     0.200
     8.425    26.083     0.200
    14.053    36.509     0.200
    15.292    37.246     0.200
     1.370    11.535     0.200
     2.167    12.733     0.200
     2.615    12.910     0.200
     2.615    13.111     0.200
     2.624    13.809     0.200
     2.841    14.571     0.200
     2.953    15.566     0.200
     2.953    14.566     0.200
     4.097    17.116     0.200
     4.076    16.657     0.200
     5.168    17.913     0.200
     6.044    19.496     0.200
     6.448    23.481     0.200
     7.301    24.019     0.200
     7.425    24.376     0.200
     8.426    26.514     0.200
    14.049    36.080     0.200
    15.297    38.276     0.200
     1.979    10.205     0.200
     2.037    10.825     0.200
     2.769    11.987     0.200
     3.318    11.878     0.200
     3.480    14.189     0.200
     3.500    14.152     0.200
     3.610    14.960     0.200
     4.431    15.286     0.200
     4.615    16.739     0.200
     4.769    16.144     0.200
     4.807    16.101     0.200
     5.018    17.132     0.200
     5.330    17.592     0.200
     5.449    18.702     0.200
     5.687    18.228     0.200
     6.281    18.595     0.200
     7.095    21.895     0.200
     7.942    23.315     0.200
     8.037    23.405     0.200
     1.554    11.354     0.200
     1.985    12.324     0.200
     2.497    13.552     0.200
     2.538    13.473     0.200
     3.322    15.223     0.200
     3.464    13.973     0.200
     3.812    15.407     0.200
     4.323    16.948     0.200
     4.401    17.928     0.200
     5.344    19.730     0.200
     5.537    20.672     0.200
     5.609    18.642     0.200
     6.446    20.173     0.200
     1.952    10.698     0.200
     2.568    12.917     0.200
     2.568    12.617     0.200
     3.288    14.609     0.200
     3.288    14.410     0.200
     3.486    13.905     0.200
     3.821    15.188     0.200
     4.034    16.906     0.200
     4.092    15.931     0.200
     4.369    17.690     0.200
     4.348    16.535     0.200
     6.416    20.013     0.200
     6.416    19.810     0.200
     6.793    20.010     0.200
     7.927    23.271     0.200
     8.799    26.602     0.200
     8.959    26.826     0.200
     8.959    27.025     0.200
    12.780    32.911     0.200
    16.767    40.033     0.200
     1.532    11.210     0.200
     1.959    11.831     0.200
     2.475    13.504     0.200
     2.563    12.976     0.200
     3.295    14.434     0.200
     3.476    15.424     0.200
     3.824    15.469     0.200
     4.375    17.132     0.200
     8.963    25.994     0.200
     1.547    11.268     0.200
     1.783    11.106     0.200
     1.966    12.078     0.200
     2.553    13.227     0.200
     2.490    12.858     0.200
     2.490    13.561     0.200
     3.300    14.408     0.200
     3.300    14.612     0.200
     3.464    15.484     0.200
     3.489    14.300     0.200
     3.806    15.403     0.200
     3.806    15.598     0.200
     4.035    15.330     0.200
     4.035    17.533     0.200
     4.035    15.932     0.200
     4.104    16.021     0.200
     4.332    16.957     0.200
     4.383    17.464     0.200
     4.383    17.668     0.200
     5.290    18.081     0.200
     5.518    19.321     0.200
     5.586    19.332     0.200
     5.864    19.088     0.200
     5.905    20.307     0.200
     6.130    20.682     0.200
     6.051    20.205     0.200
     6.418    19.718     0.200
     6.418    19.921     0.200
     6.806    21.892     0.200
     6.834    21.566     0.200
     6.834    22.160     0.200
     7.046    21.291     0.200
     7.489    23.320     0.200
     7.489    22.234     0.200
     7.489    22.594     0.200
     7.489    23.422     0.200
     7.489    21.726     0.200
     7.646    20.687     0.200
     8.015    23.781     0.200
     7.942    23.538     0.200
     8.541    25.845     0.200
     8.813    26.062     0.200
     8.813    26.468     0.200
     8.975    26.082     0.200
     9.221    28.013     0.200
     9.221    26.935     0.200
     9.441    27.242     0.200
    10.075    24.647     0.200
    11.055    28.805     0.200
    11.780    29.141     0.200
    12.278    32.732     0.200
    12.765    32.396     0.200
    12.765    34.748     0.200
    14.381    38.290     0.200
    15.144    38.487     0.200
    15.144    37.683     0.200
    15.283    39.561     0.200
    15.726    37.992     0.200
    15.660    38.658     0.200
    16.080    40.365     0.200
    16.101    38.716     0.200
    16.503    38.925     0.200
    16.503    40.260     0.200
    16.784    38.183     0.200
    18.041    40.180     0.200
    18.374    39.290     0.200
    19.766    41.138     0.200
    19.766    41.349     0.200
    19.766    40.638     0.200
    19.981    41.732     0.200
    19.952    41.874     0.200
    20.434    40.819     0.200
    20.438    41.453     0.200
    20.438    41.000     0.200
    20.704    41.607     0.200
     1.976    12.460     0.200
     1.976    12.358     0.200
     2.548    13.392     0.200
     2.548    13.189     0.200
     3.314    15.350     0.200
     3.314    14.952     0.200
     3.462    15.627     0.200
     3.464    14.400     0.200
     3.820    15.545     0.200
     4.059    14.449     0.200
     4.392    16.963     0.200
     6.442    20.041     0.200
     6.442    20.244     0.200
     1.976    12.663     0.200
     2.486    14.204     0.200
     2.549    13.476     0.200
     2.549    12.976     0.200
     3.313    14.950     0.200
     3.463    13.509     0.200
     3.462    15.312     0.200
     3.821    15.727     0.200
     3.821    15.626     0.200
     4.391    17.269     0.200
     6.442    20.140     0.200
     6.442    20.335     0.200
    10.062    27.097     0.200
     1.967    11.731     0.200
     2.482    12.530     0.200
     2.555    13.273     0.200
     3.305    14.229     0.200
     3.471    14.288     0.200
     3.469    14.213     0.200
     3.821    15.399     0.200
     4.108    17.358     0.200
     4.384    17.636     0.200
     6.433    20.420     0.200
     8.971    25.001     0.200
     1.998    13.972     0.200
     2.521    13.170     0.200
     2.521    13.471     0.200
     2.517    13.613     0.200
     2.517    13.113     0.200
     3.332    14.704     0.200
     3.332    14.305     0.200
     3.434    15.519     0.200
     3.475    14.339     0.200
     3.790    15.566     0.200
     3.790    15.464     0.200
     4.303    16.974     0.200
     4.416    18.056     0.200
     5.551    19.712     0.200
     6.082    20.322     0.200
     6.084    22.195     0.200
     6.442    21.014     0.200
     6.442    20.213     0.200
     8.845    27.567     0.200
     9.006    26.492     0.200
     9.472    28.635     0.200
    10.042    29.603     0.200
    11.085    31.228     0.200
    12.750    33.274     0.200
    16.871    39.205     0.200
    20.402    41.515     0.200
     1.597    10.736     0.200
     2.540    13.534     0.200
     2.540    13.135     0.200
     2.499    13.310     0.200
     2.499    13.412     0.200
     3.350    14.385     0.200
     3.412    15.766     0.200
     3.477    15.196     0.200
     3.770    15.581     0.200
     4.436    15.805     0.200
     4.436    17.602     0.200
     4.281    15.920     0.200
     6.448    19.628     0.200
     6.448    19.831     0.200
     9.028    25.620     0.200
     9.028    25.819     0.200
    17.787    37.757     0.200
     1.559    12.236     0.200
     1.985    12.258     0.200
     1.985    13.458     0.200
     1.985    13.659     0.200
     2.502    13.233     0.200
     2.502    13.833     0.200
     2.536    13.537     0.200
     2.536    13.137     0.200
     3.472    14.414     0.200
     3.321    14.674     0.200
     3.449    15.583     0.200
     4.402    17.754     0.200
     4.402    17.954     0.200
     5.538    20.703     0.200
     6.097    20.275     0.200
     8.991    26.907     0.200
    17.769    38.389     0.200
     1.182    10.951     0.200
     1.886    11.745     0.200
     2.373    11.960     0.200
     3.235    14.199     0.200
     3.440    14.007     0.200
     3.571    15.774     0.200
     3.927    15.520     0.200
     4.295    17.334     0.200
     4.446    17.166     0.200
     5.434    19.541     0.200
     6.242    20.408     0.200
     6.427    19.245     0.200
     8.869    26.457     0.200
     1.969    11.786     0.200
     2.489    13.111     0.200
     2.489    13.411     0.200
     2.551    12.991     0.200
     2.551    12.691     0.200
     3.304    14.007     0.200
     3.304    14.308     0.200
     3.463    15.144     0.200
     3.810    15.198     0.200
     3.810    15.401     0.200
     4.042    14.993     0.200
     4.386    17.679     0.200
     4.386    15.277     0.200
     4.332    16.404     0.200
     5.521    18.829     0.200
     6.055    19.898     0.200
     6.055    20.598     0.200
     6.425    19.383     0.200
     7.492    21.229     0.200
     7.653    20.154     0.200
     8.544    27.250     0.200
     8.815    26.187     0.200
     8.976    26.211     0.200
     8.976    26.711     0.200
     9.226    24.693     0.200
    10.071    25.136     0.200
    12.769    34.442     0.200
    12.769    30.544     0.200
    16.891    38.345     0.200
    17.774    40.141     0.200
     2.850    12.383     0.200
     3.232    13.528     0.200
     3.392    11.957     0.200
     3.791    15.203     0.200
     4.157    16.328     0.200
     4.492    15.419     0.200
     4.943    16.854     0.200
     5.044    17.281     0.200
     6.894    21.995     0.200
     8.292    23.076     0.200
     1.960    12.261     0.200
     2.484    13.835     0.200
     2.559    13.470     0.200
     2.559    13.271     0.200
     3.294    14.390     0.200
     3.294    14.890     0.200
     3.470    15.528     0.200
     3.491    14.392     0.200
     3.810    15.668     0.200
     3.810    15.770     0.200
     4.031    14.582     0.200
     4.031    15.481     0.200
     4.377    18.046     0.200
     4.377    18.245     0.200
     4.338    16.804     0.200
     4.739    18.222     0.200
     5.284    19.358     0.200
     5.858    20.969     0.200
     6.414    20.375     0.200
     6.800    21.071     0.200
     6.828    22.046     0.200
     7.040    21.974     0.200
     7.483    22.199     0.200
     7.483    21.902     0.200
     7.483    21.082     0.200
     7.646    20.600     0.200
     7.936    24.018     0.200
     8.020    23.137     0.200
     8.807    27.045     0.200
     8.969    27.358     0.200
     9.215    25.386     0.200
     9.215    25.757     0.200
    11.050    30.680     0.200
    11.211    31.196     0.200
    12.769    32.718     0.200
    12.769    34.218     0.200
    14.386    37.850     0.200
    15.280    37.215     0.200
    16.779    38.304     0.200
    16.779    39.476     0.200
    16.779    40.425     0.200
    20.842    41.887     0.200
     1.617    10.909     0.200
     1.530    10.328     0.200
     2.469    12.663     0.200
     2.445    11.249     0.200
     2.826    13.005     0.200
     2.910    12.615     0.200
     3.372    13.223     0.200
     3.661    14.557     0.200
     3.661    14.658     0.200
     4.032    16.519     0.200
     4.032    16.620     0.200
     4.556    16.614     0.200
     5.132    17.190     0.200
     5.132    17.592     0.200
     5.365    18.066     0.200
     5.567    18.517     0.200
     5.757    18.192     0.200
     5.757    18.294     0.200
     7.972    23.742     0.200
     8.625    24.120     0.200
     8.746    24.117     0.200
     8.746    25.515     0.200
     8.858    26.522     0.200
    16.978    37.242     0.200
    18.319    37.392     0.200
     1.802    11.364     0.200
     1.832     9.722     0.200
     2.312    11.617     0.200
     2.730    11.841     0.200
     3.150    12.734     0.200
     3.494    12.524     0.200
     3.947    15.231     0.200
     3.955    14.339     0.200
     3.991    14.818     0.200
     3.991    13.619     0.200
     4.214    16.024     0.200
     4.512    15.742     0.200
     5.352    17.744     0.200
     5.352    17.443     0.200
     5.438    18.438     0.200
     5.662    18.127     0.200
     5.900    19.247     0.200
     6.258    20.369     0.200
     7.320    20.470     0.200
     7.703    20.899     0.200
     8.638    24.588     0.200
     8.796    24.645     0.200
     8.796    25.645     0.200
     9.316    25.228     0.200
    11.040    28.857     0.200
    12.276    33.433     0.200
    12.910    33.515     0.200
    16.983    37.508     0.200
    17.722    38.280     0.200
     2.104    10.924     0.200
     2.459    11.584     0.200
     2.459    11.482     0.200
     2.544    11.791     0.200
     3.315    12.286     0.200
     3.455    13.251     0.200
     3.851    13.935     0.200
     3.851    14.037     0.200
     4.269    14.853     0.200
     4.221    14.413     0.200
     4.509    16.561     0.200
     4.509    16.459     0.200
     5.650    17.443     0.200
     5.743    17.858     0.200
     6.061    19.544     0.200
     6.205    19.767     0.200
     6.939    20.096     0.200
     7.176    21.531     0.200
     7.615    21.702     0.200
     7.615    20.202     0.200
     8.922    25.758     0.200
     9.063    26.308     0.200
     9.397    25.308     0.200
     9.615    26.092     0.200
    12.814    30.689     0.200
     2.481    13.292     0.200
     2.481    13.691     0.200
     2.562    13.555     0.200
     3.290    14.955     0.200
     3.290    14.658     0.200
     3.492    14.394     0.200
     3.812    15.666     0.200
     4.029    15.730     0.200
     4.029    14.230     0.200
     4.341    16.486     0.200
     4.374    17.912     0.200
     4.374    17.013     0.200
     5.509    19.769     0.200
     5.809    20.958     0.200
     5.854    19.331     0.200
     6.139    20.710     0.200
     6.412    20.026     0.200
     6.797    23.238     0.200
     7.036    22.442     0.200
     7.480    22.768     0.200
     8.804    25.508     0.200
     8.966    26.721     0.200
     8.966    27.119     0.200
     9.212    26.447     0.200
    11.046    30.941     0.200
    11.207    32.459     0.200
    17.781    38.350     0.200
     2.068    11.178     0.200
     2.499    12.156     0.200
     2.502    11.810     0.200
     3.424    12.460     0.200
     3.892    14.095     0.200
     4.470    16.351     0.200
     5.612    17.822     0.200
     6.598    18.610     0.200
     2.470    13.820     0.200
     2.575    12.993     0.200
     3.278    14.587     0.200
     3.820    15.561     0.200
     4.023    13.592     0.200
     4.361    17.849     0.200
     5.564    20.408     0.200
     6.030    19.776     0.200
     6.405    19.502     0.200
     8.953    27.758     0.200
     1.148    10.972     0.200
     1.343    11.201     0.200
     2.585    13.606     0.200
     2.585    13.504     0.200
     2.723    13.694     0.200
     2.744    13.057     0.200
     2.907    15.255     0.200
     2.907    15.357     0.200
     3.367    15.487     0.200
     3.875    16.761     0.200
     4.057    16.935     0.200
     4.057    16.833     0.200
     4.033    14.411     0.200
     4.056    16.843     0.200
     4.056    16.343     0.200
     4.420    16.091     0.200
     4.694    18.099     0.200
     4.971    18.670     0.200
     4.964    19.041     0.200
     4.991    18.235     0.200
     4.991    18.036     0.200
     5.579    19.667     0.200
     5.791    17.898     0.200
     5.814    19.127     0.200
     6.012    20.661     0.200
     6.012    20.298     0.200
     6.445    21.869     0.200
     7.102    22.297     0.200
     7.312    23.846     0.200
     7.478    24.313     0.200
     8.087    24.596     0.200
     8.264    25.521     0.200
     9.312    28.907     0.200
     9.714    28.818     0.200
    13.840    36.364     0.200
    13.840    33.664     0.200
    15.456    38.311     0.200
    15.456    38.151     0.200
    15.674    36.164     0.200
    17.300    38.392     0.200
    17.599    38.298     0.200
    17.599    38.649     0.200
     1.961    12.821     0.200
     2.486    13.088     0.200
     2.557    13.861     0.200
     3.295    14.754     0.200
     3.492    14.653     0.200
     3.469    16.121     0.200
     3.808    16.064     0.200
     4.031    16.162     0.200
     4.031    15.662     0.200
     4.099    16.766     0.200
     4.336    17.396     0.200
     4.378    17.705     0.200
     4.378    18.005     0.200
     5.285    19.520     0.200
     5.513    19.760     0.200
     5.513    19.461     0.200
     5.581    19.876     0.200
     5.814    20.357     0.200
     6.113    20.858     0.200
     6.418    21.809     0.200
     6.414    20.450     0.200
     6.414    20.051     0.200
     6.801    22.230     0.200
     7.041    22.734     0.200
     7.484    23.659     0.200
     7.484    22.259     0.200
     7.644    21.692     0.200
     7.644    21.292     0.200
     7.937    24.776     0.200
     8.536    25.888     0.200
     8.809    27.003     0.200
     8.809    26.003     0.200
     8.971    26.514     0.200
     9.216    29.454     0.200
     9.216    29.014     0.200
     9.436    27.826     0.200
     9.436    28.186     0.200
    10.080    25.092     0.200
    11.051    29.434     0.200
    12.767    34.112     0.200
    12.767    34.912     0.200
    16.098    42.138     0.200
    16.504    41.206     0.200
    16.504    40.079     0.200
    16.504    41.405     0.200
    16.780    38.295     0.200
    16.780    38.349     0.200
    16.780    40.674     0.200
    17.142    39.458     0.200
    19.984    43.993     0.200
     1.557    11.713     0.200
     1.747    11.398     0.200
     1.992    12.235     0.200
     1.992    13.837     0.200
     1.992    12.735     0.200
     1.992    13.735     0.200
     2.533    13.422     0.200
     2.533    13.118     0.200
     2.500    13.416     0.200
     3.447    15.855     0.200
     3.330    14.819     0.200
     3.455    14.464     0.200
     3.814    15.669     0.200
     4.071    15.769     0.200
     4.071    15.667     0.200
     4.319    16.274     0.200
     4.408    17.742     0.200
     4.408    17.047     0.200
     5.544    19.888     0.200
     5.544    19.787     0.200
     5.892    19.622     0.200
     6.099    20.207     0.200
     6.116    21.612     0.200
     6.081    20.814     0.200
     6.455    20.349     0.200
     6.455    20.052     0.200
     6.832    22.448     0.200
     7.514    23.196     0.200
     7.514    24.602     0.200
     7.674    22.124     0.200
     7.674    20.647     0.200
     8.016    23.939     0.200
     7.964    25.043     0.200
     7.964    25.543     0.200
     8.568    26.393     0.200
     8.568    28.291     0.200
     8.835    27.080     0.200
     8.835    26.783     0.200
     8.992    27.045     0.200
     8.992    26.147     0.200
     9.255    27.271     0.200
     9.475    27.670     0.200
    10.045    24.954     0.200
    10.045    27.157     0.200
    11.237    30.147     0.200
    12.467    32.496     0.200
    12.774    33.476     0.200
    16.787    40.259     0.200
    16.787    38.829     0.200
    16.787    39.681     0.200
    17.159    40.136     0.200
    19.836    41.601     0.200
    20.408    41.996     0.200
     1.858    12.375     0.200
     2.357    13.052     0.200
     2.357    13.251     0.200
     2.677    13.207     0.200
     3.206    14.345     0.200
     3.465    13.619     0.200
     3.592    15.331     0.200
     3.929    15.500     0.200
     4.003    15.840     0.200
     4.269    17.440     0.200
     4.464    16.563     0.200
     5.407    18.855     0.200
     5.717    19.234     0.200
     5.800    19.171     0.200
     5.955    18.955     0.200
     6.242    20.007     0.200
     6.313    20.381     0.200
     6.398    19.593     0.200
     6.398    19.894     0.200
     6.696    20.717     0.200
     6.718    23.051     0.200
     7.375    22.686     0.200
     7.375    23.658     0.200
     7.713    21.049     0.200
     7.822    22.871     0.200
     8.146    25.387     0.200
     8.434    26.325     0.200
     8.692    25.622     0.200
     8.847    26.006     0.200
     9.153    27.933     0.200
     9.369    27.280     0.200
     9.369    27.721     0.200
    10.173    25.532     0.200
    10.173    28.232     0.200
    10.173    27.372     0.200
    12.886    33.149     0.200
    15.267    40.990     0.200
    16.608    40.470     0.200
    16.651    39.422     0.200
    16.651    39.316     0.200
    19.018    43.222     0.200
    20.544    41.508     0.200
    20.583    43.253     0.200
    20.913    43.098     0.200
     1.872    11.353     0.200
     1.872    12.353     0.200
     1.872    12.154     0.200
     2.669    13.152     0.200
     2.669    12.851     0.200
     3.222    14.200     0.200
     3.222    13.099     0.200
     3.445    13.692     0.200
     3.936    15.369     0.200
     4.049    16.445     0.200
     4.281    17.138     0.200
     4.281    16.938     0.200
     4.459    16.265     0.200
     5.420    18.747     0.200
     5.732    19.502     0.200
     5.971    19.913     0.200
     6.418    19.595     0.200
     6.709    21.802     0.200
     8.149    25.402     0.200
     8.448    25.706     0.200
     8.702    24.445     0.200
     8.702    24.645     0.200
     8.855    25.959     0.200
     8.855    25.658     0.200
     9.172    27.656     0.200
     9.387    26.828     0.200
    10.158    26.400     0.200
    10.158    27.650     0.200
    12.893    34.503     0.200
    16.650    40.205     0.200
    16.619    39.852     0.200
    16.916    37.486     0.200
    17.696    39.084     0.200
     1.430    11.106     0.200
     2.373    13.304     0.200
     2.657    13.895     0.200
     2.657    13.594     0.200
     3.230    14.597     0.200
     3.230    14.699     0.200
     3.447    14.170     0.200
     3.924    16.009     0.200
     3.924    16.208     0.200
     4.028    16.397     0.200
     4.049    16.446     0.200
     4.292    17.713     0.200
     4.446    17.515     0.200
     5.210    19.690     0.200
     5.430    18.923     0.200
     5.430    19.122     0.200
     5.742    19.393     0.200
     5.980    21.010     0.200
     6.226    20.841     0.200
     6.337    21.646     0.200
     6.420    20.176     0.200
     6.420    19.977     0.200
     6.719    21.983     0.200
     7.723    22.274     0.200
     7.845    23.653     0.200
     8.458    27.287     0.200
     8.714    26.012     0.200
     8.714    26.211     0.200
     8.867    26.616     0.200
     9.394    28.010     0.200
    10.149    26.964     0.200
    12.882    34.668     0.200
    16.663    40.637     0.200
    16.912    37.720     0.200
    17.703    40.111     0.200
     2.378    13.183     0.200
     2.649    13.224     0.200
     3.242    14.293     0.200
     3.242    14.394     0.200
     3.435    14.544     0.200
     3.925    15.630     0.200
     3.925    15.732     0.200
     4.062    15.728     0.200
     4.062    14.431     0.200
     4.302    17.232     0.200
     4.302    17.533     0.200
     9.407    27.777     0.200
    10.137    25.486     0.200
    10.137    24.947     0.200
    12.883    33.459     0.200
    14.500    38.014     0.200
    15.251    38.446     0.200
    15.302    39.556     0.200
    16.125    39.657     0.200
    16.146    39.407     0.200
    16.666    38.811     0.200
    16.666    40.569     0.200
    16.614    40.752     0.200
    17.039    39.993     0.200
    18.493    41.315     0.200
    19.055    41.256     0.200
    19.717    41.332     0.200
    19.856    41.918     0.200
    20.000    41.632     0.200
    20.524    41.516     0.200
    20.509    41.389     0.200
    20.614    41.775     0.200
    20.931    40.915     0.200
     3.915    15.879     0.200
     9.397    28.914     0.200
    11.122    29.164     0.200
    12.873    34.088     0.200
    16.601    40.065     0.200
    17.041    37.793     0.200
    16.911    39.313     0.200
    20.092    42.388     0.200
    20.916    40.545     0.200
     1.904    13.330     0.200
     2.392    13.334     0.200
     2.392    13.135     0.200
     2.636    13.790     0.200
     3.252    15.193     0.200
     3.252    14.795     0.200
     3.438    14.528     0.200
     3.912    15.991     0.200
     4.063    15.137     0.200
     4.049    16.889     0.200
     4.314    18.305     0.200
     4.314    16.606     0.200
     4.426    17.491     0.200
     5.232    19.185     0.200
     5.452    19.116     0.200
     5.763    19.787     0.200
     5.846    20.723     0.200
     6.002    20.604     0.200
     6.207    20.813     0.200
     6.359    21.738     0.200
     7.725    20.995     0.200
     8.121    25.174     0.200
     8.480    26.082     0.200
     8.735    25.307     0.200
     8.735    26.706     0.200
     8.888    26.521     0.200
     8.888    26.220     0.200
     9.414    27.910     0.200
    10.127    26.265     0.200
    11.136    31.690     0.200
    12.871    32.419     0.200
    16.680    38.869     0.200
    16.895    39.283     0.200
    17.701    39.579     0.200
    20.498    41.432     0.200
     1.444    10.765     0.200
     1.906    11.676     0.200
     1.906    13.074     0.200
     1.906    12.973     0.200
     2.387    13.069     0.200
     2.637    13.042     0.200
     2.637    12.742     0.200
     3.256    14.216     0.200
     3.425    14.456     0.200
     3.922    15.346     0.200
     4.315    18.168     0.200
     4.315    16.770     0.200
     4.430    16.517     0.200
     5.454    19.172     0.200
     5.454    18.371     0.200
     6.006    20.033     0.200
     6.212    19.727     0.200
     6.446    19.491     0.200
     6.446    18.991     0.200
     8.734    25.190     0.200
     1.116    10.610     0.200
     1.870    12.111     0.200
     1.870    12.212     0.200
     1.870    13.310     0.200
     2.364    13.053     0.200
     2.667    13.707     0.200
     2.667    13.410     0.200
     3.219    14.871     0.200
     3.219    14.672     0.200
     3.453    14.838     0.200
     3.929    16.089     0.200
     4.016    16.371     0.200
     4.280    17.685     0.200
     4.280    16.087     0.200
     5.419    19.998     0.200
     5.419    18.197     0.200
     5.969    20.284     0.200
     6.235    20.673     0.200
     6.411    20.118     0.200
     6.411    20.219     0.200
     7.387    22.231     0.200
     8.703    25.879     0.200
     8.857    26.680     0.200
     9.383    27.721     0.200
    10.160    24.513     0.200
    12.886    32.070     0.200
    17.705    37.868     0.200
    20.531    41.644     0.200
     1.198    11.246     0.200
     1.420    10.659     0.200
     1.866    12.949     0.200
     2.363    12.957     0.200
     2.363    12.855     0.200
     2.670    13.066     0.200
     3.214    14.217     0.200
     3.214    14.018     0.200
     3.459    14.059     0.200
     3.927    15.499     0.200
     4.012    15.811     0.200
     4.277    17.318     0.200
     5.415    19.634     0.200
     5.415    18.532     0.200
     5.964    20.027     0.200
     6.405    19.876     0.200
     6.405    19.478     0.200
     8.699    26.204     0.200
     9.377    27.785     0.200
    10.165    25.206     0.200
    12.884    33.624     0.200
    16.655    40.426     0.200
    16.928    38.877     0.200
    17.709    38.757     0.200
     2.651    13.220     0.200
     3.241    14.524     0.200
     3.434    14.277     0.200
     3.927    15.620     0.200
     4.038    15.434     0.200
     4.300    17.470     0.200
     5.439    18.175     0.200
     5.991    20.541     0.200
     6.223    20.332     0.200
     8.721    26.484     0.200
     8.873    25.305     0.200
     1.385    10.398     0.200
     1.865    11.888     0.200
     1.865    12.388     0.200
     2.327    12.106     0.200
     3.223    13.648     0.200
     3.984    16.270     0.200
     4.015    16.504     0.200
     4.084    14.597     0.200
     4.268    16.746     0.200
     5.410    18.225     0.200
     5.410    20.225     0.200
     5.728    19.408     0.200
     5.772    20.999     0.200
     5.970    19.783     0.200
     6.699    22.879     0.200
     6.717    22.474     0.200
     7.375    22.883     0.200
     7.375    22.389     0.200
     7.375    22.088     0.200
     7.375    21.908     0.200
     7.817    24.638     0.200
     7.817    25.239     0.200
     8.192    23.158     0.200
     8.684    25.122     0.200
     8.684    28.421     0.200
     8.684    24.722     0.200
     8.831    25.304     0.200
     8.831    25.405     0.200
     9.185    28.564     0.200
     9.185    26.404     0.200
     9.398    26.282     0.200
     9.398    27.180     0.200
    10.902    31.335     0.200
    12.942    32.074     0.200
    12.942    31.824     0.200
    14.437    35.076     0.200
    15.307    39.130     0.200
    15.319    39.881     0.200
    16.176    40.788     0.200
    16.610    39.904     0.200
    16.610    39.865     0.200
    16.610    40.914     0.200
    16.610    40.004     0.200
    16.670    40.016     0.200
    16.670    40.955     0.200
    16.670    39.343     0.200
    16.670    39.723     0.200
    17.013    40.718     0.200
    16.990    38.283     0.200
    20.159    45.404     0.200
     2.074    10.222     0.200
     2.032    10.221     0.200
     2.670    12.066     0.200
     2.670    11.769     0.200
     3.446    11.923     0.200
     3.502    13.461     0.200
     3.396    13.502     0.200
     4.039    14.592     0.200
     4.080    13.714     0.200
     4.080    14.112     0.200
     4.428    15.750     0.200
     4.541    15.831     0.200
     4.734    15.084     0.200
     4.734    15.186     0.200
     4.708    15.986     0.200
     4.708    16.189     0.200
     4.930    16.895     0.200
     5.316    16.687     0.200
     5.128    17.190     0.200
     5.625    17.492     0.200
     5.981    16.832     0.200
     5.981    17.629     0.200
     5.997    17.944     0.200
     6.225    18.180     0.200
     6.319    18.083     0.200
     6.650    18.829     0.200
     7.109    20.169     0.200
     7.101    20.358     0.200
     7.057    19.477     0.200
     7.057    19.376     0.200
     7.759    22.086     0.200
     7.759    22.484     0.200
     7.910    22.620     0.200
     7.910    23.120     0.200
     8.024    22.792     0.200
     8.024    22.893     0.200
     8.172    20.064     0.200
     8.172    19.931     0.200
     8.745    25.273     0.200
     8.745    24.266     0.200
     8.990    24.413     0.200
     8.927    25.006     0.200
    10.835    25.107     0.200
    10.835    24.693     0.200
    11.305    29.298     0.200
    12.153    29.505     0.200
    13.667    32.159     0.200
    13.667    33.331     0.200
    14.045    31.818     0.200
    15.481    36.370     0.200
    15.795    34.084     0.200
    15.795    35.857     0.200
    15.795    35.389     0.200
    15.880    39.335     0.200
    16.166    37.981     0.200
    16.220    37.939     0.200
    17.284    40.026     0.200
    19.800    40.265     0.200
    20.940    42.862     0.200
     2.861    12.487     0.200
     3.245    13.403     0.200
     3.365    12.806     0.200
     3.608    14.266     0.200
     4.172    15.588     0.200
     4.110    16.602     0.200
     4.252    15.548     0.200
     4.522    15.301     0.200
     4.944    16.879     0.200
     5.061    16.507     0.200
     5.309    17.513     0.200
     5.349    18.148     0.200
     5.577    18.885     0.200
     6.225    17.624     0.200
     6.394    18.450     0.200
     6.464    19.240     0.200
     6.853    21.893     0.200
     6.892    20.047     0.200
     6.892    19.246     0.200
     7.306    20.911     0.200
     7.991    24.715     0.200
     7.991    24.414     0.200
     8.162    23.722     0.200
     8.162    23.622     0.200
     8.280    23.640     0.200
     8.280    23.240     0.200
     8.759    24.755     0.200
     8.914    25.749     0.200
     8.914    26.648     0.200
     9.105    25.665     0.200
    10.600    28.078     0.200
    10.600    24.939     0.200
    10.600    28.368     0.200
    10.549    29.960     0.200
    13.468    33.791     0.200
    13.468    34.303     0.200
    16.035    37.288     0.200
    16.035    37.323     0.200
    16.422    37.831     0.200
    17.126    39.338     0.200
    17.361    35.267     0.200
    20.052    41.060     0.200
    20.421    39.559     0.200
     2.051     9.195     0.200
     2.595    11.147     0.200
     2.595    11.549     0.200
     2.560    11.261     0.200
     3.174    12.592     0.200
     3.483    13.090     0.200
     3.767    12.173     0.200
     3.639    13.462     0.200
     3.773    14.407     0.200
     3.773    13.107     0.200
     3.995    14.509     0.200
     4.316    15.268     0.200
     4.320    16.715     0.200
     4.320    16.918     0.200
     5.440    17.348     0.200
     5.440    17.246     0.200
     5.708    17.926     0.200
     6.070    18.299     0.200
     6.118    19.037     0.200
     6.166    17.971     0.200
     6.336    18.793     0.200
     6.724    19.768     0.200
     6.772    20.308     0.200
     6.772    20.206     0.200
     6.968    19.920     0.200
     7.376    18.735     0.200
     7.419    21.053     0.200
     7.419    20.854     0.200
     7.893    22.225     0.200
     7.895    21.503     0.200
     8.443    24.201     0.200
     8.776    24.422     0.200
     8.776    24.121     0.200
     8.973    23.921     0.200
     9.029    25.284     0.200
     9.029    25.061     0.200
     9.029    25.163     0.200
     9.258    25.475     0.200
     9.750    24.456     0.200
    11.189    30.656     0.200
    11.956    29.805     0.200
    12.586    32.285     0.200
    12.586    32.160     0.200
    13.094    31.025     0.200
    14.253    34.005     0.200
    14.908    34.619     0.200
    14.908    36.759     0.200
    15.026    38.378     0.200
    15.412    37.474     0.200
    15.805    37.590     0.200
    15.827    37.417     0.200
    16.278    35.506     0.200
    16.278    36.516     0.200
    16.884    37.433     0.200
    16.884    37.268     0.200
    16.884    37.655     0.200
    17.173    38.624     0.200
    18.386    41.774     0.200
    19.677    40.607     0.200
    20.530    39.202     0.200
    20.575    39.572     0.200
    20.660    39.632     0.200
     2.157    12.722     0.200
     2.658    12.871     0.200
     2.719    13.556     0.200
     2.807    14.034     0.200
     2.891    14.353     0.200
     2.891    14.052     0.200
     3.081    14.230     0.200
     3.183    14.444     0.200
     3.815    14.374     0.200
     3.915    15.604     0.200
     3.920    15.548     0.200
     3.994    15.578     0.200
     4.192    16.770     0.200
     4.051    16.119     0.200
     4.353    17.294     0.200
     4.470    16.928     0.200
     4.508    17.685     0.200
     4.769    18.136     0.200
     5.115    18.898     0.200
     4.970    18.096     0.200
     5.281    18.361     0.200
     5.281    18.060     0.200
     5.304    18.294     0.200
     5.336    18.520     0.200
     5.559    18.717     0.200
     5.992    19.963     0.200
     5.976    18.771     0.200
     5.976    19.252     0.200
     5.976    19.021     0.200
     5.976    19.361     0.200
     6.083    19.598     0.200
     6.083    19.497     0.200
     6.369    20.064     0.200
     7.106    22.367     0.200
     7.106    22.668     0.200
     7.219    23.248     0.200
     7.331    23.533     0.200
     8.248    25.337     0.200
     8.248    25.735     0.200
     8.248    25.485     0.200
     8.248    25.997     0.200
     8.359    22.345     0.200
     8.359    22.743     0.200
     8.408    26.212     0.200
     8.408    25.572     0.200
     9.583    27.562     0.200
     9.602    29.040     0.200
    11.271    30.261     0.200
    11.500    27.748     0.200
    11.500    27.541     0.200
    14.161    35.851     0.200
    14.161    36.137     0.200
    14.354    36.573     0.200
    14.888    39.545     0.200
    15.091    39.478     0.200
    15.185    36.525     0.200
    15.185    36.587     0.200
    15.185    37.275     0.200
    15.185    36.185     0.200
    15.983    41.463     0.200
    16.077    40.066     0.200
    17.366    39.928     0.200
    18.165    40.208     0.200
    18.425    41.572     0.200
    18.496    43.334     0.200
    19.107    42.506     0.200
    20.247    44.005     0.200
    20.399    42.053     0.200
     2.450    11.484     0.200
     2.582    11.935     0.200
     2.582    11.536     0.200
     3.401    13.082     0.200
     3.363    13.724     0.200
     3.745    13.966     0.200
     4.094    15.790     0.200
     4.094    13.490     0.200
     4.207    14.977     0.200
     4.235    14.852     0.200
     4.488    15.601     0.200
     4.488    15.101     0.200
     4.599    15.000     0.200
     4.615    15.117     0.200
     4.848    16.299     0.200
     5.394    17.025     0.200
     5.622    17.857     0.200
     5.687    17.610     0.200
     5.921    18.468     0.200
     6.031    18.586     0.200
     6.153    19.070     0.200
     6.486    18.783     0.200
     6.910    19.627     0.200
     7.150    20.530     0.200
     7.388    19.077     0.200
     7.594    20.748     0.200
     7.594    21.255     0.200
     7.594    21.085     0.200
     7.594    20.255     0.200
     7.648    19.114     0.200
     7.648    20.324     0.200
     7.648    19.824     0.200
     7.938    21.932     0.200
     8.645    25.290     0.200
     8.917    24.509     0.200
     9.076    24.650     0.200
     9.312    25.069     0.200
     9.312    25.799     0.200
     9.312    26.159     0.200
     9.534    26.127     0.200
     9.534    25.327     0.200
     9.534    26.607     0.200
     9.897    26.372     0.200
     9.973    22.859     0.200
     9.973    22.991     0.200
     9.973    23.150     0.200
    11.320    28.267     0.200
    12.274    33.133     0.200
    12.707    32.101     0.200
    12.707    32.782     0.200
    13.312    31.823     0.200
    14.305    35.832     0.200
    15.347    37.270     0.200
    16.057    39.282     0.200
    16.145    36.768     0.200
    16.466    36.029     0.200
    16.466    38.309     0.200
    16.466    39.083     0.200
    16.868    36.881     0.200
    16.868    36.871     0.200
    16.868    37.721     0.200
    17.244    38.038     0.200
    19.140    40.012     0.200
    19.994    41.041     0.200
    20.808    39.848     0.200
    20.839    39.283     0.200
     1.968    12.103     0.200
     2.220    11.660     0.200
     2.856    13.643     0.200
     2.856    14.143     0.200
     3.000    15.159     0.200
     3.000    13.659     0.200
     3.763    15.861     0.200
     3.800    15.021     0.200
     3.865    13.571     0.200
     3.865    15.969     0.200
     3.992    15.984     0.200
     3.992    15.687     0.200
     4.076    15.906     0.200
     4.076    15.210     0.200
     4.203    16.120     0.200
     4.442    17.633     0.200
     4.620    17.451     0.200
     5.211    18.559     0.200
     5.211    18.364     0.200
     5.287    18.967     0.200
     5.514    18.319     0.200
     5.559    19.993     0.200
     5.599    18.331     0.200
     5.750    19.861     0.200
     6.115    21.308     0.200
     6.220    19.980     0.200
     6.499    21.027     0.200
     6.527    20.303     0.200
     6.738    21.139     0.200
     7.182    21.004     0.200
     7.182    23.262     0.200
     7.182    22.754     0.200
     7.182    23.059     0.200
     7.388    20.403     0.200
     7.636    24.464     0.200
     8.242    24.779     0.200
     8.509    25.979     0.200
     8.509    25.174     0.200
     8.678    25.197     0.200
     8.950    27.731     0.200
     8.950    26.536     0.200
     8.950    26.926     0.200
     8.950    27.489     0.200
     9.164    26.732     0.200
     9.164    25.951     0.200
    10.096    27.357     0.200
    10.377    27.730     0.200
    10.377    27.113     0.200
    10.767    30.123     0.200
    10.914    32.706     0.200
    12.936    33.096     0.200
    12.936    34.401     0.200
    15.092    39.048     0.200
    15.229    37.749     0.200
    15.970    37.806     0.200
    16.609    36.764     0.200
    16.609    39.090     0.200
    16.539    38.587     0.200
    16.539    39.962     0.200
    16.539    38.415     0.200
    16.860    40.217     0.200
    19.827    41.983     0.200
    20.398    43.320     0.200
    20.531    42.270     0.200
    20.856    40.780     0.200
     1.959    11.213     0.200
     2.189    12.427     0.200
     2.879    13.569     0.200
     2.879    13.868     0.200
     2.989    13.991     0.200
     3.788    14.661     0.200
     3.786    15.590     0.200
     3.879    15.299     0.200
     4.027    15.582     0.200
     4.027    15.281     0.200
     4.056    16.340     0.200
     4.178    16.713     0.200
     4.186    16.025     0.200
     4.648    17.127     0.200
     5.192    18.177     0.200
     5.192    18.376     0.200
     5.276    18.696     0.200
     5.500    19.185     0.200
     5.738    19.806     0.200
     6.098    20.012     0.200
     6.231    19.858     0.200
     6.231    19.656     0.200
     6.448    21.328     0.200
     6.481    20.441     0.200
     6.506    21.142     0.200
     6.506    23.242     0.200
     6.720    21.353     0.200
     7.162    20.300     0.200
     7.162    22.780     0.200
     7.162    21.790     0.200
     7.162    23.190     0.200
     7.417    20.356     0.200
     7.614    23.520     0.200
     7.670    20.964     0.200
     8.276    25.888     0.200
     8.486    25.645     0.200
     8.947    27.565     0.200
     8.947    26.454     0.200
     8.947    27.063     0.200
     8.947    26.764     0.200
     9.152    26.669     0.200
     9.154    26.744     0.200
     9.159    26.529     0.200
     9.159    26.353     0.200
    10.130    26.551     0.200
    10.390    25.258     0.200
    10.390    25.885     0.200
    10.390    25.416     0.200
    10.390    26.276     0.200
    10.390    28.317     0.200
    12.971    32.126     0.200
    12.971    31.899     0.200
    14.347    35.839     0.200
    14.638    37.051     0.200
    15.263    38.155     0.200
    15.899    41.034     0.200
    15.988    39.592     0.200
    16.506    38.078     0.200
    16.506    38.111     0.200
    16.506    37.879     0.200
    16.506    38.949     0.200
    16.632    40.279     0.200
    16.643    40.084     0.200
    16.643    39.446     0.200
    16.643    39.030     0.200
    16.643    40.434     0.200
    16.662    40.232     0.200
    16.831    39.952     0.200
    17.374    40.420     0.200
    17.580    39.516     0.200
    18.520    43.145     0.200
    18.754    42.217     0.200
    19.846    41.967     0.200
    20.094    41.577     0.200
    20.094    40.497     0.200
    20.094    41.737     0.200
    20.227    40.412     0.200
    20.227    41.523     0.200
    20.227    41.722     0.200
    20.376    42.288     0.200
    20.459    41.594     0.200
    20.759    40.557     0.200
    20.759    40.414     0.200
     1.889    10.958     0.200
     3.104    13.378     0.200
     2.982    12.697     0.200
     4.031    15.353     0.200
     3.929    15.047     0.200
     4.153    13.527     0.200
     4.419    14.827     0.200
     4.419    15.127     0.200
     4.924    16.738     0.200
     5.082    17.097     0.200
     5.082    16.996     0.200
     5.260    18.017     0.200
     5.706    19.412     0.200
     5.996    18.725     0.200
     6.366    18.411     0.200
     6.371    19.644     0.200
     6.458    18.530     0.200
     6.602    19.647     0.200
     7.032    20.009     0.200
     7.032    20.700     0.200
     7.032    19.841     0.200
     7.032    20.341     0.200
     7.448    21.282     0.200
     7.811    19.942     0.200
     8.061    20.221     0.200
     8.304    23.886     0.200
     8.304    23.987     0.200
     8.422    23.808     0.200
     9.023    27.022     0.200
     9.023    25.001     0.200
     9.023    25.902     0.200
     9.218    26.187     0.200
     9.218    26.518     0.200
    10.463    26.992     0.200
    10.463    27.210     0.200
    10.463    25.191     0.200
    10.538    30.721     0.200
    10.692    28.222     0.200
    13.372    34.271     0.200
    13.372    32.752     0.200
    13.854    36.920     0.200
    15.676    40.411     0.200
    16.160    36.043     0.200
    16.160    34.764     0.200
    16.160    35.764     0.200
    16.287    40.054     0.200
    16.561    38.231     0.200
    17.057    39.219     0.200
    18.214    41.547     0.200
    20.278    40.050     0.200
    20.195    42.324     0.200
    20.878    39.248     0.200
     1.964    10.871     0.200
     2.156    12.638     0.200
     2.910    13.031     0.200
     2.966    13.675     0.200
     3.806    13.701     0.200
     3.820    16.014     0.200
     3.761    14.698     0.200
     4.028    15.991     0.200
     4.159    15.660     0.200
     4.681    16.469     0.200
     4.944    19.296     0.200
     5.165    18.318     0.200
     5.254    18.578     0.200
     5.715    19.498     0.200
     6.071    19.846     0.200
     6.228    18.917     0.200
     6.454    20.579     0.200
     6.478    22.797     0.200
     6.692    20.995     0.200
     7.134    21.630     0.200
     7.134    20.907     0.200
     7.134    21.739     0.200
     7.436    20.115     0.200
     7.584    23.687     0.200
     7.688    19.883     0.200
     7.688    20.273     0.200
     7.688    20.374     0.200
     8.309    22.726     0.200
     8.455    25.317     0.200
     8.455    25.118     0.200
     8.620    25.597     0.200
     8.620    25.697     0.200
     8.931    25.919     0.200
     8.931    25.669     0.200
     8.931    26.268     0.200
     8.931    26.669     0.200
     9.135    28.289     0.200
     9.137    27.262     0.200
     9.142    26.421     0.200
     9.142    26.711     0.200
    10.160    27.228     0.200
    10.415    24.272     0.200
    10.415    27.554     0.200
    13.002    33.530     0.200
    15.288    38.881     0.200
    15.903    41.701     0.200
    15.993    36.708     0.200
    16.473    35.807     0.200
    16.473    37.676     0.200
    16.670    40.554     0.200
    16.670    39.052     0.200
    16.670    40.402     0.200
    16.798    39.756     0.200
    17.183    38.570     0.200
    17.742    38.088     0.200
    18.522    43.241     0.200
    18.735    42.856     0.200
    20.124    40.467     0.200
    20.124    40.619     0.200
    20.124    41.449     0.200
    20.259    43.246     0.200
    20.346    41.757     0.200
    20.476    41.633     0.200
    20.786    40.146     0.200
    20.786    40.320     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.372    15.034     0.200
     2.275    14.970     0.200
     2.758    17.732     0.200
     3.068    22.106     0.200
     4.190    27.017     0.200
     4.297    27.161     0.200
     4.297    27.661     0.200
     5.429    35.953     0.200
     5.820    39.695     0.200
     8.473    56.836     0.200
     8.658    57.269     0.200
     8.658    56.769     0.200
     2.307    15.145     0.200
     2.205    14.633     0.200
     2.450    15.676     0.200
     2.679    17.804     0.200
     3.135    24.882     0.200
     4.321    26.440     0.200
     4.321    27.042     0.200
     6.794    43.589     0.200
     8.546    57.541     0.200
     3.509    22.360     0.200
     5.253    31.909     0.200
     2.165    13.971     0.200
     2.477    19.532     0.200
     2.495    16.329     0.200
     3.738    24.020     0.200
     4.224    26.542     0.200
     6.208    39.199     0.200
     2.246    13.774     0.200
     2.246    14.173     0.200
     2.285    14.414     0.200
     2.285    16.117     0.200
     2.467    16.283     0.200
     3.036    19.452     0.200
     3.713    23.752     0.200
     3.707    22.914     0.200
     4.392    25.325     0.200
     4.713    32.285     0.200
     6.351    44.459     0.200
     7.433    50.040     0.200
     7.433    49.837     0.200
     2.218    14.808     0.200
     2.854    18.591     0.200
     3.322    20.136     0.200
     3.666    24.117     0.200
     8.599    59.050     0.200
     3.181    21.770     0.200
     4.166    26.282     0.200
     6.300    40.378     0.200
     2.298    13.994     0.200
     2.870    17.819     0.200
     2.870    17.620     0.200
     3.470    22.824     0.200
     3.470    22.625     0.200
     3.595    23.258     0.200
     8.861    58.710     0.200
     9.438    60.369     0.200
     3.495    22.163     0.200
     4.244    26.226     0.200
     5.207    34.890     0.200
     2.165    13.855     0.200
     2.165    14.058     0.200
     2.591    15.985     0.200
     3.413    22.697     0.200
     3.684    24.126     0.200
     3.684    26.032     0.200
     4.134    27.378     0.200
     4.571    28.972     0.200
     4.831    30.340     0.200
     7.625    53.233     0.200
     2.104    12.666     0.200
     2.104    12.362     0.200
     2.230    13.698     0.200
     2.231    13.581     0.200
     2.665    15.221     0.200
     3.453    20.615     0.200
     3.692    22.430     0.200
     4.237    26.176     0.200
     4.613    27.784     0.200
     4.613    27.581     0.200
     4.983    29.968     0.200
     6.434    41.731     0.200
     2.432    14.593     0.200
     3.299    19.777     0.200
     3.888    23.405     0.200
     4.361    26.784     0.200
     6.470    43.481     0.200
     2.120    12.924     0.200
     2.887    17.972     0.200
     3.095    18.935     0.200
     4.100    24.008     0.200
     4.099    25.923     0.200
     5.247    33.627     0.200
     7.206    43.861     0.200
     7.637    48.232     0.200
     2.261    12.951     0.200
     2.387    14.371     0.200
     2.527    15.240     0.200
     3.199    19.298     0.200
     3.288    20.558     0.200
     3.853    24.270     0.200
     4.189    26.849     0.200
     4.189    26.148     0.200
     4.433    27.696     0.200
     4.434    25.692     0.200
     4.434    27.692     0.200
     4.448    27.821     0.200
     4.448    28.221     0.200
     4.744    29.771     0.200
     5.094    31.781     0.200
     5.164    33.069     0.200
     5.695    35.270     0.200
     5.733    35.333     0.200
     6.354    41.580     0.200
     6.354    40.981     0.200
     6.369    39.910     0.200
     6.752    42.133     0.200
     7.503    47.468     0.200
     7.684    48.158     0.200
     2.236    13.222     0.200
     2.835    18.332     0.200
     2.835    17.832     0.200
     3.024    19.824     0.200
     3.985    25.310     0.200
     3.985    25.209     0.200
     3.884    24.785     0.200
     4.098    25.795     0.200
     4.098    23.696     0.200
     4.098    25.596     0.200
     6.242    40.978     0.200
     8.258    51.552     0.200
     2.199    14.982     0.200
     2.199    14.181     0.200
     2.828    18.436     0.200
     2.828    18.335     0.200
     3.094    19.735     0.200
     3.094    20.136     0.200
     3.882    24.536     0.200
     4.021    25.320     0.200
     4.021    25.121     0.200
     4.074    26.197     0.200
     4.074    26.398     0.200
     4.131    26.030     0.200
     6.371    42.689     0.200
     2.226    13.414     0.200
     2.226    13.515     0.200
     2.828    16.989     0.200
     2.828    16.888     0.200
     2.962    18.620     0.200
     2.962    17.921     0.200
     3.625    21.987     0.200
     3.641    21.797     0.200
     3.926    24.566     0.200
     3.926    24.668     0.200
     3.954    24.948     0.200
     3.954    23.851     0.200
     5.077    30.342     0.200
     2.201    13.720     0.200
     2.694    17.663     0.200
     3.486    21.519     0.200
     3.662    22.767     0.200
     4.250    26.505     0.200
     2.302    13.632     0.200
     2.449    15.912     0.200
     2.501    15.612     0.200
     3.241    20.478     0.200
     3.241    19.978     0.200
     4.271    26.061     0.200
     4.401    26.741     0.200
     2.334    14.240     0.200
     2.483    14.603     0.200
     2.483    15.603     0.200
     2.499    15.719     0.200
     2.499    15.918     0.200
     3.205    20.084     0.200
     3.963    24.029     0.200
     3.963    25.529     0.200
     4.218    26.357     0.200
     4.365    25.842     0.200
     2.301    13.640     0.200
     2.479    14.871     0.200
     2.479    15.668     0.200
     2.517    15.117     0.200
     2.517    15.218     0.200
     3.237    20.820     0.200
     3.237    20.320     0.200
     4.243    26.677     0.200
     4.243    26.575     0.200
     4.397    26.282     0.200
     6.309    41.468     0.200
     2.299    13.931     0.200
     2.464    15.311     0.200
     2.512    15.051     0.200
     3.241    20.346     0.200
     3.241    20.744     0.200
     3.927    22.730     0.200
     3.927    24.929     0.200
     4.226    26.241     0.200
     4.401    27.405     0.200
     2.494    15.152     0.200
     2.494    16.353     0.200
     2.509    15.872     0.200
     2.509    16.772     0.200
     3.224    20.628     0.200
     3.224    20.829     0.200
     3.957    25.683     0.200
     4.261    26.831     0.200
     4.245    27.119     0.200
     4.245    26.820     0.200
     2.299    13.487     0.200
     2.451    14.508     0.200
     2.451    15.008     0.200
     2.506    14.864     0.200
     3.243    19.162     0.200
     3.243    19.762     0.200
     3.915    24.218     0.200
     4.403    26.823     0.200
     4.400    26.767     0.200
     2.314    13.823     0.200
     2.314    14.026     0.200
     2.506    15.190     0.200
     2.506    14.987     0.200
     2.490    15.768     0.200
     3.158    19.180     0.200
     3.224    19.912     0.200
     4.238    26.473     0.200
     4.238    25.676     0.200
     4.259    27.520     0.200
     4.389    26.810     0.200
     4.384    26.976     0.200
     4.815    30.530     0.200
     5.118    32.598     0.200
     5.204    32.601     0.200
     5.423    35.639     0.200
     5.621    35.337     0.200
     5.666    35.312     0.200
     6.380    41.369     0.200
     6.380    40.970     0.200
     2.301    13.540     0.200
     2.462    15.661     0.200
     2.462    15.763     0.200
     2.509    15.015     0.200
     2.509    15.218     0.200
     3.239    19.383     0.200
     3.926    24.179     0.200
     4.221    26.425     0.200
     4.400    26.547     0.200
     4.400    26.149     0.200
     2.330    13.553     0.200
     2.499    15.682     0.200
     2.499    15.381     0.200
     2.518    16.562     0.200
     2.518    14.964     0.200
     3.206    19.836     0.200
     3.206    20.836     0.200
     3.980    24.895     0.200
     3.980    25.395     0.200
     4.250    26.251     0.200
     4.250    27.048     0.200
     4.366    27.197     0.200
     4.366    27.798     0.200
     4.377    26.871     0.200
     6.386    40.117     0.200
     6.386    40.320     0.200
     7.421    46.846     0.200
     2.300    13.431     0.200
     2.443    15.059     0.200
     2.443    15.465     0.200
     2.500    15.094     0.200
     2.500    14.891     0.200
     3.164    20.251     0.200
     3.243    18.719     0.200
     3.908    23.165     0.200
     4.198    26.281     0.200
     4.404    26.782     0.200
     2.305    14.175     0.200
     2.305    13.777     0.200
     2.659    16.241     0.200
     2.659    15.741     0.200
     3.082    19.214     0.200
     3.326    21.459     0.200
     3.326    19.862     0.200
     3.489    22.853     0.200
     3.854    23.602     0.200
     3.854    24.802     0.200
     3.825    24.841     0.200
     3.825    24.638     0.200
     4.686    30.287     0.200
     4.683    29.629     0.200
     4.956    30.736     0.200
     5.246    34.547     0.200
     5.405    34.702     0.200
     6.234    40.428     0.200
     7.436    46.899     0.200
     7.940    52.013     0.200
     7.940    52.213     0.200
     8.326    53.508     0.200
     8.497    54.163     0.200
     2.299    13.827     0.200
     2.299    13.928     0.200
     2.860    17.277     0.200
     2.860    17.677     0.200
     2.934    18.016     0.200
     3.696    22.819     0.200
     3.696    22.420     0.200
     3.871    24.480     0.200
     3.871    23.880     0.200
     3.747    24.324     0.200
     4.056    23.515     0.200
     2.428    15.302     0.200
     2.611    17.066     0.200
     3.253    20.675     0.200
     3.861    24.979     0.200
     4.328    26.933     0.200
     2.309    13.622     0.200
     2.466    15.491     0.200
     2.466    15.792     0.200
     2.499    16.101     0.200
     2.499    14.902     0.200
     3.232    20.761     0.200
     3.930    24.804     0.200
     3.930    25.402     0.200
     4.214    26.299     0.200
     4.214    26.799     0.200
     4.392    27.320     0.200
     4.390    27.638     0.200
     2.428    14.890     0.200
     2.428    14.390     0.200
     2.459    14.632     0.200
     2.783    18.251     0.200
     2.783    16.251     0.200
     2.954    18.348     0.200
     2.954    18.548     0.200
     3.358    20.531     0.200
     3.616    23.729     0.200
     3.702    23.324     0.200
     3.702    22.625     0.200
     3.987    25.299     0.200
     5.087    30.662     0.200
     5.087    30.560     0.200
     2.105    14.445     0.200
     2.276    14.751     0.200
     2.276    14.251     0.200
     2.679    16.244     0.200
     3.735    22.924     0.200
     3.735    23.623     0.200
     4.601    28.009     0.200
     2.465    15.828     0.200
     2.465    15.234     0.200
     2.555    15.979     0.200
     2.555    15.878     0.200
     3.108    19.324     0.200
     3.165    19.763     0.200
     3.740    23.356     0.200
     4.019    24.798     0.200
     4.237    26.558     0.200
     4.338    26.971     0.200
     5.066    30.971     0.200
     2.332    14.601     0.200
     2.656    18.117     0.200
     2.656    18.017     0.200
     3.366    21.536     0.200
     4.364    28.186     0.200
     2.357    14.947     0.200
     2.352    14.206     0.200
     2.801    17.457     0.200
     2.801    16.457     0.200
     2.948    17.550     0.200
     2.948    17.851     0.200
     3.782    24.007     0.200
     3.782    23.710     0.200
     3.977    24.241     0.200
     2.267    15.121     0.200
     2.267    14.621     0.200
     2.226    15.101     0.200
     2.226    15.601     0.200
     2.838    19.751     0.200
     2.838    17.047     0.200
     2.838    19.649     0.200
     3.128    22.066     0.200
     3.566    22.763     0.200
     3.494    22.301     0.200
     3.494    21.500     0.200
     4.086    26.095     0.200
     4.086    26.294     0.200
     6.144    41.672     0.200
     2.252    13.508     0.200
     2.402    14.565     0.200
     2.544    15.201     0.200
     3.211    21.125     0.200
     3.292    20.675     0.200
     3.866    23.084     0.200
     4.220    26.452     0.200
     4.444    28.029     0.200
     2.324    13.951     0.200
     2.484    14.682     0.200
     2.484    14.581     0.200
     2.474    15.896     0.200
     3.143    18.894     0.200
     3.217    18.820     0.200
     3.217    22.023     0.200
     3.939    24.893     0.200
     2.325    14.485     0.200
     2.325    15.485     0.200
     2.706    17.728     0.200
     3.187    18.825     0.200
     3.961    25.283     0.200
     4.243    25.894     0.200
     5.935    38.946     0.200
     2.233    13.128     0.200
     2.233    13.827     0.200
     2.844    18.400     0.200
     2.844    18.000     0.200
     3.010    19.358     0.200
     3.010    19.158     0.200
     3.811    24.220     0.200
     3.868    24.351     0.200
     3.868    24.453     0.200
     3.982    24.316     0.200
     3.982    23.216     0.200
     4.087    24.793     0.200
     8.690    54.781     0.200
     2.296    15.114     0.200
     2.698    18.017     0.200
     2.698    18.317     0.200
     3.291    19.402     0.200
     3.291    20.602     0.200
     3.291    22.203     0.200
     3.625    24.002     0.200
     4.072    25.890     0.200
     4.082    26.072     0.200
     4.218    25.888     0.200
     4.218    25.587     0.200
     4.218    27.188     0.200
     4.301    27.615     0.200
     4.301    27.215     0.200
     8.697    54.611     0.200
     2.571    16.912     0.200
     2.776    16.919     0.200
     2.727    16.382     0.200
     2.727    17.085     0.200
     2.885    16.346     0.200
     2.885    16.745     0.200
     3.675    23.324     0.200
     3.710    23.120     0.200
     3.881    24.026     0.200
     3.881    24.323     0.200
     4.247    28.046     0.200
     4.297    26.772     0.200
     2.663    16.542     0.200
     2.663    17.542     0.200
     3.360    21.110     0.200
     3.349    21.142     0.200
     3.698    22.764     0.200
     4.609    27.737     0.200
     4.630    27.890     0.200
     2.316    14.926     0.200
     2.316    16.329     0.200
     2.679    18.491     0.200
     3.303    21.114     0.200
     3.605    23.583     0.200
     4.062    26.452     0.200
     4.062    26.651     0.200
     4.317    25.977     0.200
     4.498    28.668     0.200
     2.289    13.973     0.200
     2.289    13.676     0.200
     2.742    17.783     0.200
     2.742    18.384     0.200
     3.158    19.428     0.200
     3.158    19.127     0.200
     3.658    22.289     0.200
     4.210    26.453     0.200
     4.210    25.551     0.200
     8.629    56.879     0.200
     2.520    17.232     0.200
     2.528    17.041     0.200
     3.314    21.161     0.200
     3.438    22.117     0.200
     3.506    21.231     0.200
     3.774    24.803     0.200
     4.026    24.655     0.200
     4.026    25.455     0.200
     4.304    27.012     0.200
     4.405    27.238     0.200
     4.405    27.437     0.200
     5.308    34.494     0.200
     5.881    40.513     0.200
     7.621    52.999     0.200
     8.559    57.055     0.200
     2.312    14.951     0.200
     2.683    18.437     0.200
     2.683    18.039     0.200
     3.299    19.141     0.200
     3.299    21.040     0.200
     3.299    21.243     0.200
     4.081    26.411     0.200
     4.064    26.613     0.200
     4.064    26.316     0.200
     4.213    27.173     0.200
     4.213    27.673     0.200
     4.313    26.011     0.200
     4.313    27.706     0.200
     5.459    33.031     0.200
     5.459    32.031     0.200
     6.042    38.928     0.200
     6.370    40.801     0.200
     6.574    41.723     0.200
     7.849    49.837     0.200
     8.711    55.584     0.200
     2.004    11.635     0.200
     2.808    16.656     0.200
     2.808    17.855     0.200
     3.466    20.972     0.200
     3.651    22.220     0.200
     3.651    22.420     0.200
     4.809    28.497     0.200
     6.741    46.256     0.200
     2.346    14.316     0.200
     2.346    14.214     0.200
     2.704    16.742     0.200
     2.704    17.742     0.200
     3.161    18.705     0.200
     3.161    20.306     0.200
     3.518    20.335     0.200
     3.915    24.503     0.200
     3.915    24.401     0.200
     4.234    25.182     0.200
     4.234    25.983     0.200
     5.146    34.939     0.200
     8.663    54.701     0.200
     2.028    11.579     0.200
     2.010    12.893     0.200
     2.717    15.937     0.200
     2.717    15.640     0.200
     3.398    20.388     0.200
     3.440    21.894     0.200
     3.591    22.340     0.200
     4.124    24.816     0.200
     4.406    27.720     0.200
     4.747    28.739     0.200
     5.410    33.204     0.200
     7.089    45.612     0.200
     8.975    56.932     0.200
     2.268    14.503     0.200
     2.790    17.708     0.200
     2.790    17.208     0.200
     3.078    17.641     0.200
     3.078    19.841     0.200
     3.700    23.083     0.200
     3.877    23.024     0.200
     3.972    24.009     0.200
     4.147    24.166     0.200
     4.519    28.332     0.200
     4.564    27.509     0.200
     6.598    43.171     0.200
     7.254    47.018     0.200
     2.142    12.647     0.200
     2.711    15.597     0.200
     2.711    15.697     0.200
     3.410    21.249     0.200
     3.525    21.604     0.200
     3.525    22.705     0.200
     3.604    21.876     0.200
     3.604    22.376     0.200
     4.226    25.619     0.200
     4.536    27.606     0.200
     2.167    14.019     0.200
     2.616    15.373     0.200
     2.616    16.774     0.200
     2.627    16.447     0.200
     2.840    17.368     0.200
     2.950    19.076     0.200
     3.478    21.723     0.200
     3.818    23.346     0.200
     3.932    24.122     0.200
     4.101    25.054     0.200
     4.075    24.655     0.200
     4.109    24.555     0.200
     4.109    26.455     0.200
     4.806    30.020     0.200
     5.396    32.735     0.200
     5.895    35.316     0.200
     2.167    14.233     0.200
     2.615    15.910     0.200
     2.615    17.511     0.200
     2.841    17.970     0.200
     2.953    19.366     0.200
     2.953    20.166     0.200
     3.479    22.024     0.200
     3.479    22.725     0.200
     4.097    26.517     0.200
     4.076    25.257     0.200
     4.111    25.546     0.200
     4.385    27.153     0.200
     4.808    30.021     0.200
     5.168    32.013     0.200
     2.037    13.231     0.200
     2.769    15.885     0.200
     2.769    18.088     0.200
     3.318    20.284     0.200
     3.480    22.189     0.200
     3.500    22.246     0.200
     3.610    23.460     0.200
     4.431    27.982     0.200
     4.615    29.145     0.200
     4.769    29.246     0.200
     4.807    31.000     0.200
     5.018    31.632     0.200
     5.330    33.592     0.200
     5.449    34.100     0.200
     5.687    35.330     0.200
     6.701    41.199     0.200
     7.095    44.599     0.200
     7.822    49.909     0.200
     7.942    50.713     0.200
     8.037    51.506     0.200
     2.497    15.552     0.200
     2.538    17.673     0.200
     3.322    20.623     0.200
     3.464    20.773     0.200
     3.812    24.507     0.200
     4.125    27.650     0.200
     4.323    27.348     0.200
     4.401    28.128     0.200
     5.537    34.672     0.200
     5.609    35.142     0.200
     6.446    40.573     0.200
     2.474    15.516     0.200
     2.568    17.117     0.200
     2.568    16.816     0.200
     3.288    21.512     0.200
     3.288    22.211     0.200
     3.480    22.271     0.200
     3.486    20.604     0.200
     3.821    24.086     0.200
     3.821    24.989     0.200
     4.034    26.309     0.200
     4.092    27.833     0.200
     4.369    27.292     0.200
     4.348    26.836     0.200
     6.039    38.502     0.200
     6.409    40.288     0.200
     6.416    41.611     0.200
     6.820    44.090     0.200
     7.032    45.915     0.200
     7.475    47.146     0.200
     7.475    46.412     0.200
     2.475    15.402     0.200
     2.563    17.179     0.200
     2.563    18.976     0.200
     3.295    21.535     0.200
     3.477    21.420     0.200
     3.476    22.322     0.200
     3.824    23.063     0.200
     4.346    27.074     0.200
     4.375    27.234     0.200
     5.582    34.955     0.200
     6.425    41.614     0.200
     2.553    17.829     0.200
     2.553    17.430     0.200
     2.490    15.561     0.200
     2.490    15.959     0.200
     3.300    22.112     0.200
     3.300    21.815     0.200
     3.464    23.484     0.200
     3.489    22.503     0.200
     3.806    25.997     0.200
     3.806    25.200     0.200
     4.035    26.033     0.200
     4.035    25.932     0.200
     4.104    25.724     0.200
     4.332    27.761     0.200
     4.383    28.261     0.200
     6.130    40.284     0.200
     9.441    61.984     0.200
    10.075    63.092     0.200
     2.487    14.396     0.200
     2.487    18.099     0.200
     2.548    17.587     0.200
     2.548    16.985     0.200
     3.314    19.546     0.200
     3.314    21.952     0.200
     3.314    22.647     0.200
     3.462    22.322     0.200
     3.464    21.900     0.200
     3.820    25.045     0.200
     4.117    25.482     0.200
     4.392    26.870     0.200
     4.332    26.659     0.200
     5.528    32.908     0.200
     6.065    40.143     0.200
     6.442    42.845     0.200
     2.486    17.001     0.200
     2.549    17.476     0.200
     2.549    16.976     0.200
     3.463    23.204     0.200
     3.462    21.609     0.200
     3.462    24.210     0.200
     3.821    25.227     0.200
     3.821    24.829     0.200
     4.116    25.886     0.200
     4.333    26.851     0.200
     4.391    28.573     0.200
     5.527    33.213     0.200
     5.527    35.213     0.200
     6.065    39.547     0.200
     6.442    41.640     0.200
     8.977    56.659     0.200
     2.482    15.030     0.200
     2.555    16.871     0.200
     3.305    20.127     0.200
     3.471    22.186     0.200
     3.469    22.213     0.200
     3.821    23.899     0.200
     4.108    25.459     0.200
     4.384    26.738     0.200
     6.056    38.423     0.200
     6.433    41.119     0.200
     2.521    17.471     0.200
     2.521    17.072     0.200
     2.517    16.512     0.200
     2.517    17.512     0.200
     3.332    21.407     0.200
     3.332    20.805     0.200
     3.434    22.621     0.200
     3.475    23.038     0.200
     3.790    25.863     0.200
     3.790    24.863     0.200
     4.056    26.657     0.200
     4.137    26.416     0.200
     4.303    27.076     0.200
     4.416    27.959     0.200
     4.778    30.036     0.200
     6.100    39.103     0.200
     8.574    61.035     0.200
    11.085    70.330     0.200
     2.018    13.028     0.200
     2.540    16.436     0.200
     2.499    17.111     0.200
     3.350    21.986     0.200
     3.350    22.385     0.200
     3.412    23.164     0.200
     3.477    21.997     0.200
     3.770    24.479     0.200
     4.155    26.984     0.200
     4.436    27.505     0.200
     4.281    27.323     0.200
     5.342    34.332     0.200
     5.870    39.576     0.200
     6.101    39.875     0.200
     6.448    42.831     0.200
     6.887    46.500     0.200
     7.995    50.474     0.200
     8.593    55.498     0.200
     9.028    58.421     0.200
     2.502    16.133     0.200
     2.502    17.533     0.200
     2.536    17.537     0.200
     3.472    21.914     0.200
     3.321    21.674     0.200
     3.321    21.474     0.200
     4.125    26.793     0.200
     4.402    28.454     0.200
     2.373    14.765     0.200
     3.235    20.097     0.200
     3.440    21.812     0.200
     3.571    23.071     0.200
     3.927    25.317     0.200
     4.295    26.427     0.200
     4.446    27.870     0.200
     5.434    34.236     0.200
     5.985    38.207     0.200
     6.427    42.042     0.200
     6.723    41.998     0.200
     8.869    56.253     0.200
     2.489    14.814     0.200
     2.489    17.013     0.200
     2.551    16.890     0.200
     3.304    20.405     0.200
     3.304    19.206     0.200
     3.463    22.445     0.200
     3.810    24.600     0.200
     4.042    25.793     0.200
     4.042    26.395     0.200
     4.386    27.476     0.200
     4.386    26.976     0.200
     4.332    27.205     0.200
     7.492    47.632     0.200
     8.544    53.652     0.200
     2.850    16.783     0.200
     3.232    20.428     0.200
     3.392    20.257     0.200
     3.602    21.613     0.200
     3.791    24.203     0.200
     4.157    26.229     0.200
     4.246    26.493     0.200
     4.492    28.020     0.200
     5.044    31.381     0.200
     5.126    31.527     0.200
     5.570    35.138     0.200
     6.233    39.600     0.200
     6.368    41.233     0.200
     2.484    15.636     0.200
     2.484    16.238     0.200
     2.559    17.669     0.200
     2.559    17.470     0.200
     3.294    20.589     0.200
     3.294    20.390     0.200
     3.470    22.931     0.200
     3.491    22.193     0.200
     3.810    24.668     0.200
     3.810    24.969     0.200
     4.031    24.981     0.200
     4.031    25.883     0.200
     4.098    24.406     0.200
     4.377    27.648     0.200
     4.338    27.703     0.200
     4.739    29.425     0.200
     5.512    33.700     0.200
     5.512    33.200     0.200
     2.469    15.163     0.200
     2.445    14.851     0.200
     2.445    14.749     0.200
     2.826    17.204     0.200
     2.826    16.603     0.200
     2.910    19.115     0.200
     3.372    21.524     0.200
     3.661    24.459     0.200
     4.032    25.620     0.200
     4.128    25.409     0.200
     4.288    27.435     0.200
     5.132    31.190     0.200
     8.746    56.316     0.200
     2.312    13.717     0.200
     2.312    14.317     0.200
     2.730    17.741     0.200
     3.150    20.533     0.200
     3.494    21.024     0.200
     3.947    25.432     0.200
     3.955    24.438     0.200
     3.991    25.219     0.200
     3.991    23.920     0.200
     4.214    26.124     0.200
     4.512    28.043     0.200
     8.638    54.289     0.200
     2.104    12.725     0.200
     2.104    12.522     0.200
     2.459    15.982     0.200
     2.544    15.291     0.200
     3.315    19.684     0.200
     3.455    21.955     0.200
     3.851    23.838     0.200
     4.269    26.752     0.200
     4.221    26.514     0.200
     6.061    38.942     0.200
     8.021    50.775     0.200
     8.680    56.180     0.200
     9.615    62.272     0.200
     2.481    14.894     0.200
     2.481    17.292     0.200
     2.562    17.555     0.200
     3.290    21.751     0.200
     3.290    20.251     0.200
     3.492    21.800     0.200
     3.812    25.166     0.200
     3.812    25.370     0.200
     4.029    26.035     0.200
     4.029    24.129     0.200
     4.094    26.967     0.200
     4.341    27.087     0.200
     4.374    27.513     0.200
     4.374    28.513     0.200
     5.509    33.769     0.200
     5.509    33.565     0.200
     6.413    42.014     0.200
     8.531    55.393     0.200
     2.068    12.678     0.200
     2.499    16.255     0.200
     2.502    15.910     0.200
     4.217    27.599     0.200
     4.315    26.863     0.200
     4.470    29.351     0.200
     5.612    34.622     0.200
     5.711    36.264     0.200
     6.172    37.985     0.200
     6.598    42.110     0.200
     9.020    56.656     0.200
     2.470    15.617     0.200
     2.575    17.298     0.200
     3.278    20.283     0.200
     3.495    21.646     0.200
     3.820    25.764     0.200
     4.082    26.705     0.200
     4.361    27.646     0.200
     5.496    32.502     0.200
     6.030    37.174     0.200
     6.405    40.502     0.200
     2.002    12.110     0.200
     2.002    13.008     0.200
     2.002    14.711     0.200
     2.002    12.008     0.200
     2.585    16.504     0.200
     2.585    16.305     0.200
     2.744    18.455     0.200
     2.744    17.756     0.200
     2.907    19.556     0.200
     3.656    23.307     0.200
     3.656    23.107     0.200
     3.875    24.960     0.200
     4.057    24.532     0.200
     4.057    26.333     0.200
     4.056    25.644     0.200
     4.056    25.246     0.200
     4.694    29.001     0.200
     9.714    62.818     0.200
    11.004    70.659     0.200
     2.486    15.988     0.200
     2.486    18.288     0.200
     2.557    18.061     0.200
     3.295    20.554     0.200
     3.492    22.453     0.200
     3.469    23.421     0.200
     3.808    24.364     0.200
     3.808    25.364     0.200
     4.031    26.062     0.200
     4.031    25.862     0.200
     4.099    26.167     0.200
     4.336    28.396     0.200
     4.378    28.205     0.200
     8.536    55.288     0.200
    11.051    70.034     0.200
     2.533    17.422     0.200
     2.533    17.024     0.200
     2.500    15.713     0.200
     3.447    22.652     0.200
     3.330    22.319     0.200
     3.330    22.920     0.200
     3.455    21.769     0.200
     3.814    25.271     0.200
     3.814    25.169     0.200
     4.071    26.074     0.200
     4.319    26.680     0.200
     6.116    39.510     0.200
     7.071    45.657     0.200
     8.568    55.393     0.200
     2.357    14.552     0.200
     2.677    17.707     0.200
     2.677    17.508     0.200
     3.206    19.845     0.200
     3.206    20.544     0.200
     3.465    20.919     0.200
     3.465    22.619     0.200
     3.592    23.233     0.200
     3.929    24.399     0.200
     3.929    25.199     0.200
     4.003    25.738     0.200
     4.028    25.444     0.200
     4.269    26.139     0.200
     4.464    27.563     0.200
     5.800    34.269     0.200
     8.434    52.728     0.200
     8.434    55.126     0.200
     8.692    55.321     0.200
     8.847    55.506     0.200
     9.369    62.405     0.200
     2.360    17.154     0.200
     2.360    16.154     0.200
     2.669    17.750     0.200
     2.669    17.351     0.200
     3.222    19.700     0.200
     3.222    19.497     0.200
     3.445    21.493     0.200
     4.018    25.908     0.200
     3.936    24.369     0.200
     3.936    25.369     0.200
     4.049    25.945     0.200
     4.049    26.246     0.200
     4.281    27.138     0.200
     4.459    27.663     0.200
     5.420    32.645     0.200
     9.387    61.789     0.200
     2.373    15.206     0.200
     2.373    15.105     0.200
     2.657    18.294     0.200
     2.657    17.993     0.200
     3.230    21.398     0.200
     3.230    22.597     0.200
     3.447    22.068     0.200
     3.924    26.009     0.200
     4.028    26.296     0.200
     4.049    26.145     0.200
     4.292    27.713     0.200
     4.446    28.015     0.200
     8.714    57.012     0.200
     2.378    15.284     0.200
     2.378    15.683     0.200
     2.649    17.626     0.200
     3.242    21.394     0.200
     3.435    22.544     0.200
     3.925    25.232     0.200
     3.925    25.431     0.200
     4.039    26.298     0.200
     4.062    26.228     0.200
     4.062    26.829     0.200
     4.302    27.634     0.200
     4.440    28.421     0.200
     5.753    38.698     0.200
     5.992    40.207     0.200
     7.409    48.777     0.200
     8.469    55.596     0.200
     8.469    57.596     0.200
     4.033    23.692     0.200
     3.915    23.680     0.200
     3.915    23.481     0.200
     4.299    27.197     0.200
     5.437    32.009     0.200
     6.343    41.933     0.200
     6.420    42.944     0.200
     7.405    51.541     0.200
     7.405    48.244     0.200
     8.465    56.381     0.200
     2.392    15.533     0.200
     2.392    17.232     0.200
     2.392    16.435     0.200
     2.636    17.989     0.200
     2.636    17.888     0.200
     3.252    21.693     0.200
     3.252    19.396     0.200
     3.438    22.028     0.200
     3.912    24.991     0.200
     3.912    25.491     0.200
     4.063    26.234     0.200
     4.063    25.937     0.200
     4.049    26.389     0.200
     4.314    27.606     0.200
     4.314    27.805     0.200
     4.426    27.893     0.200
     8.480    54.882     0.200
     8.735    55.608     0.200
     9.414    60.883     0.200
    11.136    70.393     0.200
     2.387    15.569     0.200
     2.637    17.343     0.200
     2.637    16.941     0.200
     3.256    21.317     0.200
     3.256    19.419     0.200
     3.425    21.753     0.200
     3.922    25.647     0.200
     3.922    25.244     0.200
     4.053    26.326     0.200
     4.315    27.571     0.200
     4.430    27.318     0.200
     2.364    15.154     0.200
     2.667    18.008     0.200
     3.219    21.473     0.200
     3.219    20.071     0.200
     3.453    22.037     0.200
     3.929    25.988     0.200
     4.016    25.469     0.200
     4.280    27.486     0.200
     4.280    27.087     0.200
     4.456    28.138     0.200
     8.143    58.109     0.200
     8.703    56.078     0.200
     8.857    57.180     0.200
     2.363    14.957     0.200
     2.363    17.156     0.200
     2.670    17.765     0.200
     3.214    20.916     0.200
     3.214    21.818     0.200
     3.459    21.860     0.200
     3.927    25.597     0.200
     4.012    25.713     0.200
     4.277    27.818     0.200
     4.457    27.310     0.200
     2.376    14.429     0.200
     2.376    15.730     0.200
     2.651    17.419     0.200
     3.241    21.727     0.200
     3.434    21.481     0.200
     3.927    25.221     0.200
     4.038    26.032     0.200
     4.300    26.970     0.200
     4.442    27.313     0.200
     5.439    33.776     0.200
     5.991    38.342     0.200
     6.223    39.132     0.200
     6.434    41.973     0.200
     7.407    46.913     0.200
     7.852    49.519     0.200
     8.468    53.332     0.200
     8.721    55.785     0.200
     8.873    56.407     0.200
     2.327    14.606     0.200
     3.403    20.242     0.200
     3.223    20.849     0.200
     3.223    23.247     0.200
     3.223    19.849     0.200
     4.015    26.004     0.200
     4.084    25.398     0.200
     4.268    27.545     0.200
     4.268    27.945     0.200
     5.410    32.827     0.200
     8.441    52.750     0.200
     2.074    13.120     0.200
     2.074    13.019     0.200
     2.032    11.823     0.200
     2.032    12.518     0.200
     2.670    15.472     0.200
     2.670    16.066     0.200
     3.446    21.220     0.200
     3.396    20.900     0.200
     4.080    25.315     0.200
     4.734    28.584     0.200
     4.708    28.384     0.200
     2.861    17.787     0.200
     3.365    21.605     0.200
     3.608    22.566     0.200
     3.790    24.541     0.200
     4.110    25.902     0.200
     4.522    27.901     0.200
     4.522    28.101     0.200
     4.944    29.379     0.200
     8.914    57.949     0.200
     2.595    16.249     0.200
     2.560    16.163     0.200
     3.174    19.194     0.200
     3.174    21.295     0.200
     3.174    19.393     0.200
     3.483    21.090     0.200
     3.767    21.775     0.200
     3.639    24.161     0.200
     3.639    22.364     0.200
     3.773    23.708     0.200
     4.316    26.870     0.200
     8.443    53.600     0.200
     8.776    55.320     0.200
     9.258    60.412     0.200
    10.205    64.159     0.200
     2.157    14.519     0.200
     2.658    16.270     0.200
     2.658    17.668     0.200
     2.658    17.371     0.200
     2.719    17.357     0.200
     2.719    17.255     0.200
     2.807    19.034     0.200
     2.891    18.654     0.200
     2.891    19.154     0.200
     3.081    19.632     0.200
     3.183    19.944     0.200
     3.815    24.573     0.200
     3.915    24.803     0.200
     3.994    25.180     0.200
     3.994    25.781     0.200
     4.051    26.119     0.200
     4.051    26.518     0.200
     4.353    27.095     0.200
     4.504    28.723     0.200
     4.508    28.185     0.200
     8.408    55.794     0.200
     2.070    13.019     0.200
     2.070    12.619     0.200
     2.450    15.884     0.200
     2.450    16.084     0.200
     2.582    16.236     0.200
     2.582    15.736     0.200
     3.401    20.882     0.200
     3.401    22.182     0.200
     3.363    20.824     0.200
     3.456    20.340     0.200
     3.745    23.666     0.200
     4.207    26.777     0.200
     4.235    26.152     0.200
     4.488    27.801     0.200
     4.488    27.401     0.200
     4.599    29.200     0.200
     4.848    30.699     0.200
     5.394    33.825     0.200
     5.622    35.257     0.200
     5.687    35.810     0.200
     5.967    38.141     0.200
     6.153    39.770     0.200
     6.526    41.608     0.200
     6.486    41.783     0.200
     6.910    43.827     0.200
     7.150    44.930     0.200
     8.645    54.990     0.200
     2.220    13.558     0.200
     2.220    14.261     0.200
     2.856    18.948     0.200
     2.856    19.346     0.200
     3.000    19.956     0.200
     3.000    19.854     0.200
     3.763    24.361     0.200
     3.800    23.521     0.200
     3.865    24.469     0.200
     3.865    24.766     0.200
     3.992    25.484     0.200
     4.076    26.007     0.200
     4.076    25.906     0.200
     4.203    27.018     0.200
     4.442    28.633     0.200
     8.950    57.630     0.200
     9.164    59.568     0.200
    10.377    62.589     0.200
    10.767    68.216     0.200
     2.189    13.827     0.200
     2.879    18.569     0.200
     2.879    18.868     0.200
     2.989    19.091     0.200
     2.989    18.091     0.200
     3.788    24.462     0.200
     3.786    23.790     0.200
     3.879    24.299     0.200
     4.027    26.281     0.200
     4.027    24.681     0.200
     4.056    25.039     0.200
     4.056    26.139     0.200
     4.186    26.625     0.200
     8.486    54.145     0.200
     8.947    58.364     0.200
     9.159    58.605     0.200
    10.390    64.360     0.200
     3.104    20.278     0.200
     2.982    18.897     0.200
     2.982    20.697     0.200
     4.031    25.553     0.200
     3.929    24.747     0.200
     3.929    24.946     0.200
     4.153    26.027     0.200
     4.153    26.327     0.200
     6.715    43.639     0.200
     9.023    58.202     0.200
     9.218    61.368     0.200
     2.156    14.437     0.200
     2.156    14.737     0.200
     2.910    18.731     0.200
     2.966    18.774     0.200
     2.966    18.474     0.200
     3.806    24.326     0.200
     3.820    25.114     0.200
     3.761    23.497     0.200
     4.058    25.233     0.200
     4.028    26.391     0.200
     4.028    26.091     0.200
     4.159    26.761     0.200
     8.931    56.268     0.200
     9.142    58.862     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.115     7.462     0.200
     1.229     8.141     0.200
     0.439     4.410     0.200
     0.478     3.122     0.200
     1.097     5.999     0.200
     0.142     1.856     0.200
     0.157     2.079     0.200
     0.325     3.023     0.200
     1.302     7.724     0.200
     1.413     8.025     0.200
     1.296     7.987     0.200
     1.296     8.088     0.200
     1.550     8.722     0.200
     1.550     9.120     0.200
     1.550     8.620     0.200
     2.229    11.597     0.200
     0.110     1.193     0.200
     0.079     1.350     0.200
     0.150     1.221     0.200
     0.332     2.400     0.200
     0.252     2.230     0.200
     0.412     2.565     0.200
     1.218     7.854     0.200
     1.380     8.961     0.200
     1.443     9.032     0.200
     1.512     9.628     0.200
     1.196     8.752     0.200
     1.613    11.994     0.200
     2.889    15.094     0.200
     1.009     6.065     0.200
     1.937    11.134     0.200
     2.165    11.471     0.200
     0.552     4.546     0.200
     0.545     4.320     0.200
     0.783     5.545     0.200
     0.981     6.735     0.200
     0.989     6.634     0.200
     1.005     6.947     0.200
     1.017     7.413     0.200
     1.017     8.408     0.200
     1.297     8.354     0.200
     1.419     9.324     0.200
     1.419     9.020     0.200
     1.419    10.020     0.200
     1.520     9.836     0.200
     1.520    10.539     0.200
     5.690    25.377     0.200
     6.351    28.662     0.200
     7.433    36.540     0.200
     0.558     4.090     0.200
     0.946     5.962     0.200
     1.001     6.212     0.200
     1.685    10.435     0.200
     1.926    10.718     0.200
     0.202     2.045     0.200
     0.541     4.187     0.200
     0.465     3.572     0.200
     0.592     4.994     0.200
     0.737     5.302     0.200
     0.876     5.674     0.200
     1.810    10.282     0.200
     0.734     5.345     0.200
     0.734     4.845     0.200
     0.743     6.445     0.200
     0.750     6.365     0.200
     0.802     5.752     0.200
     0.802     6.053     0.200
     1.567    11.030     0.200
     1.791     9.710     0.200
     8.294    40.228     0.200
     0.192     1.914     0.200
     0.558     3.840     0.200
     0.734     4.384     0.200
     1.113     7.162     0.200
     1.113     6.961     0.200
     1.390     9.136     0.200
     0.127     0.737     0.200
     0.127     0.839     0.200
     0.374     2.153     0.200
     0.899     5.932     0.200
     1.150     7.902     0.200
     1.150     7.504     0.200
     1.206     8.949     0.200
     1.309     8.347     0.200
     0.026     3.209     0.200
     0.026     2.709     0.200
     0.389     2.875     0.200
     0.910     6.105     0.200
     1.288     8.379     0.200
     1.294     8.619     0.200
     1.294     8.416     0.200
     0.150     2.332     0.200
     0.190     1.866     0.200
     0.625     4.983     0.200
     1.177     7.542     0.200
     1.490     9.188     0.200
     1.490     9.087     0.200
     1.724     9.564     0.200
     1.724    10.166     0.200
     1.952    11.505     0.200
     0.167     2.716     0.200
     0.654     4.825     0.200
     1.179     6.798     0.200
     1.414     8.559     0.200
     1.719    10.303     0.200
     0.221     2.853     0.200
     0.163     2.031     0.200
     1.168     7.802     0.200
     1.135     7.582     0.200
     2.261    12.451     0.200
     0.222     2.521     0.200
     0.416     3.863     0.200
     0.416     3.965     0.200
     1.368     8.754     0.200
     1.025     6.660     0.200
     1.025     6.361     0.200
     1.295     7.404     0.200
     1.295     8.003     0.200
     1.946    10.303     0.200
     1.946    10.704     0.200
     5.042    25.080     0.200
     5.774    26.130     0.200
     0.115     1.393     0.200
     0.162     1.054     0.200
     0.558     3.732     0.200
     0.955     6.591     0.200
     1.256     8.285     0.200
     1.355     8.928     0.200
     1.355    10.129     0.200
     1.820    10.506     0.200
     0.175     2.039     0.200
     0.483     3.855     0.200
     0.548     3.096     0.200
     1.100     6.854     0.200
     1.305     7.765     0.200
     1.518     9.272     0.200
     1.518     9.471     0.200
     1.524     9.999     0.200
     2.206    12.439     0.200
     0.046     2.567     0.200
     0.422     3.179     0.200
     0.982     7.440     0.200
     1.216     8.211     0.200
     1.324     8.450     0.200
     1.324     8.250     0.200
     2.072    11.616     0.200
     0.172     1.983     0.200
     0.216     2.576     0.200
     0.216     1.974     0.200
     1.073     6.875     0.200
     1.073     6.575     0.200
     1.154     7.831     0.200
     1.154     7.632     0.200
     1.201     6.982     0.200
     1.217     8.498     0.200
     1.369     9.022     0.200
     1.369     8.823     0.200
     2.302    11.932     0.200
     7.539    35.815     0.200
     7.624    36.822     0.200
     0.144     1.698     0.200
     0.144     1.800     0.200
     0.261     1.834     0.200
     0.261     2.135     0.200
     1.024     6.533     0.200
     1.147     7.490     0.200
     1.251     8.885     0.200
     1.267     8.695     0.200
     1.415     8.970     0.200
     2.334    12.740     0.200
     0.178     1.714     0.200
     0.236     1.944     0.200
     0.236     2.343     0.200
     1.044     6.608     0.200
     1.044     6.905     0.200
     1.180     7.528     0.200
     1.233     9.002     0.200
     1.251     8.793     0.200
     1.414     8.890     0.200
     1.414     8.992     0.200
     2.301    12.539     0.200
     0.176     1.805     0.200
     0.176     2.305     0.200
     0.224     1.852     0.200
     0.224     2.449     0.200
     1.059     6.904     0.200
     1.059     7.005     0.200
     1.170     7.813     0.200
     1.217     8.863     0.200
     1.234     8.565     0.200
     1.393     8.909     0.200
     2.299    12.833     0.200
     0.170     1.575     0.200
     0.251     2.129     0.200
     0.251     1.828     0.200
     1.029     6.642     0.200
     1.175     7.840     0.200
     1.426     9.212     0.200
     2.313    12.464     0.200
     2.313    13.063     0.200
     2.509    13.872     0.200
     0.176     2.360     0.200
     0.215     1.899     0.200
     0.215     2.399     0.200
     1.071     7.008     0.200
     1.160     7.971     0.200
     1.374     8.973     0.200
     0.166     2.387     0.200
     0.248     2.635     0.200
     0.248     2.534     0.200
     1.033     7.174     0.200
     1.170     7.672     0.200
     1.261     8.812     0.200
     1.420     8.363     0.200
     1.420     8.761     0.200
     2.506    12.291     0.200
     0.223     2.184     0.200
     0.223     1.989     0.200
     0.174     2.155     0.200
     1.061     7.012     0.200
     1.166     7.787     0.200
     1.166     7.685     0.200
     1.389     8.186     0.200
     1.389     8.389     0.200
     2.301    11.938     0.200
     0.160     1.479     0.200
     0.160     1.377     0.200
     0.274     2.045     0.200
     0.274     1.944     0.200
     1.171     7.882     0.200
     1.171     7.780     0.200
     1.290     8.794     0.200
     1.447     9.753     0.200
     2.330    13.354     0.200
     2.499    13.581     0.200
     0.175     2.029     0.200
     0.212     2.099     0.200
     0.212     1.904     0.200
     1.152     7.731     0.200
     1.152     7.833     0.200
     1.361     9.093     0.200
     0.160     2.512     0.200
     0.160     2.410     0.200
     1.292     7.998     0.200
     1.292     7.799     0.200
     1.436     8.722     0.200
     1.428     8.407     0.200
     1.683     9.333     0.200
     1.683    10.532     0.200
     1.683     9.732     0.200
     2.499    14.110     0.200
     0.409     3.475     0.200
     0.221     2.167     0.200
     0.221     2.467     0.200
     1.141     7.242     0.200
     1.141     6.942     0.200
     1.369     8.174     0.200
     2.126    12.036     0.200
     2.126    11.736     0.200
     0.171     2.142     0.200
     0.561     4.297     0.200
     1.184     7.725     0.200
     1.184     7.428     0.200
     1.485     9.204     0.200
     1.790    10.460     0.200
     1.790     9.960     0.200
     1.913    11.812     0.200
     7.435    35.277     0.200
     0.166     1.838     0.200
     0.229     2.093     0.200
     0.229     1.593     0.200
     1.157     7.770     0.200
     1.387     9.379     0.200
     0.140     1.494     0.200
     0.140     1.393     0.200
     1.380     9.220     0.200
     1.380     8.919     0.200
     1.539     9.562     0.200
     1.539     9.163     0.200
     1.571     9.894     0.200
     1.569     9.913     0.200
     1.569     9.713     0.200
     2.459    14.031     0.200
     0.040     1.544     0.200
     0.040     1.146     0.200
     0.373     2.160     0.200
     0.373     2.359     0.200
     1.062     7.616     0.200
     1.062     7.514     0.200
     1.312     8.600     0.200
     1.312     8.701     0.200
     1.293     9.021     0.200
     1.293     8.818     0.200
     2.105    11.945     0.200
     0.131     1.272     0.200
     0.314     2.136     0.200
     0.314     2.034     0.200
     1.144     7.743     0.200
     1.324     8.943     0.200
     1.324     8.841     0.200
     1.469     9.956     0.200
     2.371    13.632     0.200
     2.371    13.335     0.200
     0.193     1.662     0.200
     0.822     6.418     0.200
     0.822     6.317     0.200
     1.055     7.401     0.200
     1.402     9.052     0.200
     1.402     9.152     0.200
     1.531     9.842     0.200
     1.989    12.603     0.200
     0.020     2.718     0.200
     0.644     4.628     0.200
     1.273     7.594     0.200
     1.273     7.793     0.200
     1.449     8.339     0.200
     1.537     9.120     0.200
     1.551     9.251     0.200
     2.357    13.048     0.200
     2.357    12.349     0.200
     0.564     4.090     0.200
     0.774     5.840     0.200
     0.774     5.847     0.200
     0.774     6.046     0.200
     1.591    10.511     0.200
     1.795    11.131     0.200
     1.895    11.052     0.200
     6.144    29.070     0.200
     0.164     2.075     0.200
     0.164     2.177     0.200
     0.223     1.987     0.200
     0.223     1.885     0.200
     0.223     2.182     0.200
     1.173     8.012     0.200
     1.173     7.809     0.200
     1.190     7.806     0.200
     1.342     8.727     0.200
     1.342     8.828     0.200
     0.151     1.812     0.200
     0.241     2.154     0.200
     1.142     7.642     0.200
     1.387     9.178     0.200
     0.086     1.106     0.200
     0.557     3.613     0.200
     0.557     4.011     0.200
     1.079     7.324     0.200
     1.382     8.886     0.200
     6.398    30.250     0.200
     0.400     3.423     0.200
     1.026     6.012     0.200
     1.669    10.107     0.200
     1.669     9.806     0.200
     1.669    10.607     0.200
     1.963    10.477     0.200
     6.408    29.703     0.200
     8.690    39.080     0.200
     0.113     0.883     0.200
     0.744     5.322     0.200
     1.024     7.755     0.200
     1.360     9.430     0.200
     1.228     8.274     0.200
     1.228     8.174     0.200
     1.613    10.384     0.200
     7.407    35.088     0.200
     7.407    36.968     0.200
     0.484     3.867     0.200
     0.530     4.234     0.200
     0.796     5.923     0.200
     0.796     6.024     0.200
     0.993     7.022     0.200
     1.406     8.902     0.200
     1.406     8.699     0.200
     1.877    10.508     0.200
     1.877    12.008     0.200
     1.877    10.305     0.200
     0.021     3.183     0.200
     0.384     3.041     0.200
     1.015     6.983     0.200
     1.234     8.223     0.200
     1.288     8.198     0.200
     1.288     7.997     0.200
     1.288     8.395     0.200
     2.107    10.937     0.200
     0.112     0.847     0.200
     0.741     5.404     0.200
     1.045     7.364     0.200
     1.045     6.864     0.200
     1.208     8.453     0.200
     1.380     9.148     0.200
     1.380     9.347     0.200
     1.612    10.347     0.200
     1.931    12.213     0.200
     1.931    12.616     0.200
     0.079     2.555     0.200
     0.552     4.444     0.200
     1.044     6.702     0.200
     1.346     8.276     0.200
     1.269     8.071     0.200
     1.803    11.037     0.200
     1.800     9.971     0.200
     0.258     2.223     0.200
     0.581     4.358     0.200
     0.581     4.257     0.200
     1.060     7.271     0.200
     1.276     8.548     0.200
     1.276     7.946     0.200
     1.577    10.335     0.200
     1.577    10.635     0.200
     1.793    11.313     0.200
     0.110     0.862     0.200
     0.110     0.760     0.200
     1.041     7.387     0.200
     1.377     9.178     0.200
     1.212     8.396     0.200
     1.614    10.004     0.200
     1.928    12.348     0.200
     2.312    12.756     0.200
     2.312    12.951     0.200
     0.242     2.297     0.200
     0.605     3.867     0.200
     0.790     5.306     0.200
     1.077     7.152     0.200
     1.414     9.020     0.200
     1.520     9.089     0.200
     1.939    10.594     0.200
     3.651    16.720     0.200
     6.322    30.551     0.200
     7.863    35.664     0.200
     0.151     2.832     0.200
     0.498     3.976     0.200
     0.498     4.078     0.200
     1.112     6.920     0.200
     1.112     7.119     0.200
     1.234     7.993     0.200
     1.403     8.518     0.200
     1.819    11.167     0.200
     3.161    14.505     0.200
     0.269     2.396     0.200
     0.580     4.081     0.200
     0.772     6.028     0.200
     0.772     5.833     0.200
     0.994     7.139     0.200
     0.994     7.038     0.200
     1.515    10.058     0.200
     1.515    10.261     0.200
     2.028    11.282     0.200
     2.010    10.791     0.200
     7.799    35.432     0.200
     0.174     2.737     0.200
     0.458     3.826     0.200
     1.044     6.288     0.200
     1.325     7.797     0.200
     1.321     8.256     0.200
     1.321     8.154     0.200
     1.733    10.040     0.200
     1.733    10.442     0.200
     1.733    10.340     0.200
     1.897    10.535     0.200
     1.897    10.734     0.200
     2.268    12.503     0.200
     0.108     2.583     0.200
     0.108     2.483     0.200
     0.469     3.469     0.200
     0.469     3.570     0.200
     0.920     6.200     0.200
     0.920     6.500     0.200
     1.382     8.814     0.200
     1.326     8.765     0.200
     2.045    11.472     0.200
     5.603    26.158     0.200
     0.190     1.193     0.200
     0.190     1.393     0.200
     0.516     3.991     0.200
     0.516     4.091     0.200
     0.825     5.775     0.200
     0.825     5.975     0.200
     0.960     6.602     0.200
     0.960     6.502     0.200
     1.375     9.962     0.200
     1.375     9.364     0.200
     0.191     0.893     0.200
     0.191     0.994     0.200
     0.514     4.227     0.200
     0.825     5.704     0.200
     0.825     6.204     0.200
     0.965     6.068     0.200
     0.965     6.469     0.200
     1.371    10.424     0.200
     1.370     9.335     0.200
     0.212     2.222     0.200
     0.567     3.684     0.200
     0.816     6.173     0.200
     1.081     7.890     0.200
     1.376     9.241     0.200
     1.486     9.555     0.200
     1.979    11.205     0.200
     0.223     1.691     0.200
     0.608     4.097     0.200
     1.067     7.736     0.200
     1.247     8.137     0.200
     1.554     9.754     0.200
     1.756    11.700     0.200
     1.985    12.924     0.200
     5.537    26.572     0.200
     0.210     1.626     0.200
     0.576     3.958     0.200
     1.228     8.050     0.200
     1.531     9.618     0.200
     1.952    11.897     0.200
     1.952    13.198     0.200
     1.952    12.100     0.200
     1.783    10.867     0.200
     1.783    11.168     0.200
     2.474    13.016     0.200
     0.208     1.664     0.200
     0.585     3.857     0.200
     1.228     8.157     0.200
     1.532     9.710     0.200
     1.774    11.086     0.200
     1.959    12.636     0.200
     6.143    31.202     0.200
     0.226     1.584     0.200
     0.581     4.043     0.200
     1.083     7.476     0.200
     1.083     7.577     0.200
     1.244     7.993     0.200
     1.244     8.493     0.200
     1.547     9.768     0.200
     1.547     9.666     0.200
     1.966    13.078     0.200
     1.966    12.281     0.200
     6.418    32.117     0.200
     7.489    37.086     0.200
     0.214     1.721     0.200
     0.603     4.086     0.200
     1.077     7.650     0.200
     1.238     8.180     0.200
     1.238     8.375     0.200
     1.545     9.796     0.200
     1.758    11.200     0.200
     1.758    11.005     0.200
     1.976    13.358     0.200
     2.487    14.099     0.200
     0.213     1.632     0.200
     0.603     4.179     0.200
     1.078     7.539     0.200
     1.237     8.489     0.200
     1.237     8.388     0.200
     1.543     9.503     0.200
     1.543    10.206     0.200
     1.758    11.103     0.200
     1.976    12.959     0.200
     7.948    39.863     0.200
     0.212     1.721     0.200
     0.594     3.665     0.200
     1.085     7.633     0.200
     1.234     7.896     0.200
     1.539     9.532     0.200
     1.767    11.276     0.200
     1.967    12.731     0.200
     8.971    43.501     0.200
     0.245     1.530     0.200
     0.608     4.097     0.200
     0.608     4.198     0.200
     1.051     7.323     0.200
     1.269     8.384     0.200
     1.575    10.015     0.200
     1.575    10.116     0.200
     1.763    10.920     0.200
     1.763    11.221     0.200
     1.998    12.269     0.200
     1.998    12.671     0.200
     6.100    29.001     0.200
     0.266     1.667     0.200
     0.618     4.163     0.200
     0.618     4.265     0.200
     1.030     7.158     0.200
     1.030     7.259     0.200
     1.291     9.012     0.200
     1.291     8.910     0.200
     1.597    10.037     0.200
     1.761    10.830     0.200
     2.499    14.510     0.200
     6.101    29.375     0.200
     0.230     1.846     0.200
     0.603     3.994     0.200
     1.253     8.205     0.200
     1.559     9.835     0.200
     1.763    11.254     0.200
     0.105     1.027     0.200
     0.583     3.844     0.200
     1.123     7.352     0.200
     1.182     8.053     0.200
     1.762    10.980     0.200
     1.762    11.285     0.200
     1.886    12.644     0.200
     6.723    32.092     0.200
     0.222     1.867     0.200
     0.587     4.010     0.200
     0.587     3.908     0.200
     1.081     7.343     0.200
     1.243     8.061     0.200
     1.243     8.362     0.200
     1.546     9.817     0.200
     1.969    12.388     0.200
     0.516     4.122     0.200
     0.830     5.562     0.200
     0.796     5.753     0.200
     1.455     9.366     0.200
     1.770    10.490     0.200
     1.760    10.100     0.200
     1.760    11.199     0.200
     1.916    10.879     0.200
     6.233    29.201     0.200
     0.222     1.938     0.200
     0.576     4.403     0.200
     1.089     7.918     0.200
     1.541     9.941     0.200
     1.541     9.840     0.200
     1.786    11.387     0.200
     1.786    11.184     0.200
     1.960    12.562     0.200
     7.936    37.319     0.200
     0.159     1.820     0.200
     0.753     6.097     0.200
     1.577    10.078     0.200
     1.617    10.311     0.200
     0.119     2.106     0.200
     0.516     3.672     0.200
     1.259     8.010     0.200
     1.369     8.321     0.200
     1.802    10.364     0.200
     1.802    11.165     0.200
     1.802    10.466     0.200
     1.832    10.321     0.200
     0.269     2.841     0.200
     0.986     6.873     0.200
     0.986     6.974     0.200
     0.768     5.820     0.200
     1.598     9.331     0.200
     1.605     9.838     0.200
     8.922    40.661     0.200
     0.220     1.886     0.200
     0.220     1.988     0.200
     0.573     4.362     0.200
     1.093     7.803     0.200
     1.093     7.701     0.200
     1.538     9.898     0.200
     1.788    11.279     0.200
     1.788    11.381     0.200
     1.956    12.627     0.200
     0.227     2.160     0.200
     0.756     5.694     0.200
     1.030     6.997     0.200
     1.599     9.252     0.200
     3.424    19.060     0.200
     8.644    42.140     0.200
     0.212     1.772     0.200
     0.565     4.049     0.200
     1.105     7.537     0.200
     1.226     8.130     0.200
     1.527     9.622     0.200
     1.794    11.202     0.200
     1.943    11.961     0.200
     0.458     3.325     0.200
     0.614     4.516     0.200
     0.688     5.342     0.200
     1.148     7.675     0.200
     1.148     7.574     0.200
     1.219     8.255     0.200
     1.343     9.904     0.200
     5.791    27.597     0.200
     0.224     2.090     0.200
     0.576     4.477     0.200
     1.088     8.406     0.200
     1.088     8.006     0.200
     1.241     8.415     0.200
     1.543    10.092     0.200
     1.543     9.893     0.200
     1.787    11.451     0.200
     1.787    11.850     0.200
     1.787    11.350     0.200
     1.961    12.521     0.200
     1.961    12.421     0.200
     0.223     1.783     0.200
     0.617     4.076     0.200
     1.062     7.489     0.200
     1.248     8.314     0.200
     1.248     8.415     0.200
     1.557     9.916     0.200
     1.557     9.815     0.200
     1.747    11.102     0.200
     6.455    31.552     0.200
     7.071    33.962     0.200
     0.111     0.964     0.200
     1.112     7.383     0.200
     1.205     7.686     0.200
     1.205     9.186     0.200
     1.791    10.848     0.200
     1.791    11.048     0.200
     1.858    11.976     0.200
     0.099     0.846     0.200
     0.575     3.887     0.200
     1.111     7.226     0.200
     1.196     7.837     0.200
     1.196     9.337     0.200
     1.196     8.435     0.200
     1.417     9.154     0.200
     1.417     9.053     0.200
     1.771    10.632     0.200
     1.771    10.531     0.200
     2.360    13.552     0.200
     6.326    31.467     0.200
     0.109     1.321     0.200
     0.576     4.378     0.200
     1.124     7.579     0.200
     1.184     8.477     0.200
     1.184     8.278     0.200
     1.430     9.406     0.200
     1.430     9.305     0.200
     1.770    11.446     0.200
     1.770    11.247     0.200
     1.882    12.137     0.200
     1.882    12.836     0.200
     1.882    12.336     0.200
     0.107     0.988     0.200
     0.107     1.089     0.200
     0.589     3.962     0.200
     1.127     7.381     0.200
     1.176     8.313     0.200
     1.435     9.381     0.200
     1.756    10.838     0.200
     1.756    10.736     0.200
     1.893    11.946     0.200
     2.378    13.784     0.200
     0.118     0.885     0.200
     0.575     4.047     0.200
     1.133     6.937     0.200
     1.176     7.534     0.200
     1.439     8.767     0.200
     1.439     9.869     0.200
     1.888    12.426     0.200
     1.770    11.102     0.200
     0.120     0.851     0.200
     0.591     4.052     0.200
     1.163     8.175     0.200
     1.141     7.532     0.200
     1.449     9.634     0.200
     1.755    11.460     0.200
     1.755    10.863     0.200
     1.904    12.330     0.200
     1.904    12.228     0.200
     0.110     0.540     0.200
     1.134     7.486     0.200
     1.134     7.587     0.200
     1.164     7.431     0.200
     1.444     8.964     0.200
     1.744    10.770     0.200
     1.744    10.470     0.200
     0.106     1.394     0.200
     0.567     4.116     0.200
     1.116     7.809     0.200
     1.195     8.292     0.200
     1.195     8.190     0.200
     1.421     9.254     0.200
     1.778    11.489     0.200
     1.778    10.989     0.200
     0.110     0.747     0.200
     0.561     3.776     0.200
     0.561     3.976     0.200
     1.198     7.547     0.200
     1.198     9.445     0.200
     1.420     8.858     0.200
     1.784    10.708     0.200
     1.866    11.750     0.200
     1.866    12.449     0.200
     0.104     1.135     0.200
     0.590     4.471     0.200
     1.178     7.907     0.200
     1.433     9.428     0.200
     1.756    10.661     0.200
     1.891    12.080     0.200
     0.048     0.096     0.200
     1.072     6.949     0.200
     1.865    11.388     0.200
     3.223    16.148     0.200
     0.277     2.994     0.200
     0.557     4.323     0.200
     0.557     4.128     0.200
     0.788     5.631     0.200
     0.788     5.530     0.200
     0.977     6.424     0.200
     1.273     8.370     0.200
     1.498     9.748     0.200
     1.498     9.850     0.200
     2.074    10.324     0.200
     0.536     4.222     0.200
     0.814     6.074     0.200
     0.831     5.673     0.200
     1.464     9.686     0.200
     1.752    10.927     0.200
     1.752    10.427     0.200
     1.775    10.260     0.200
     1.900    10.800     0.200
     0.449     3.389     0.200
     0.381     3.090     0.200
     1.162     7.066     0.200
     1.369     8.459     0.200
     1.624     9.082     0.200
     1.624     9.883     0.200
     1.624     9.782     0.200
     2.051    11.597     0.200
     2.051    11.297     0.200
     0.186     1.418     0.200
     0.186     1.618     0.200
     0.566     4.189     0.200
     0.851     6.159     0.200
     0.851     5.959     0.200
     1.482     9.989     0.200
     0.303     2.539     0.200
     0.663     5.138     0.200
     0.663     4.738     0.200
     0.979     6.642     0.200
     1.331     8.537     0.200
     1.331     8.237     0.200
     1.641     9.820     0.200
     1.730     9.584     0.200
     1.730     9.884     0.200
     2.070    10.819     0.200
     5.687    25.610     0.200
     0.245     2.318     0.200
     0.399     3.413     0.200
     0.399     3.311     0.200
     1.389     9.560     0.200
     1.389     9.256     0.200
     1.282     9.412     0.200
     1.658    10.419     0.200
     1.968    11.205     0.200
     7.636    35.565     0.200
     0.239     2.382     0.200
     0.984     6.982     0.200
     0.984     6.683     0.200
     1.250     8.289     0.200
     1.411     9.202     0.200
     1.642    10.614     0.200
     1.959    12.112     0.200
     6.098    28.711     0.200
     7.614    36.120     0.200
     0.406     3.865     0.200
     0.406     3.465     0.200
     0.623     5.023     0.200
     0.794     5.426     0.200
     0.954     6.764     0.200
     1.635    10.023     0.200
     1.635     9.722     0.200
     1.796    10.333     0.200
     1.589     9.859     0.200
     1.889    12.758     0.200
     0.252     2.454     0.200
     0.432     2.856     0.200
     0.952     6.679     0.200
     1.216     8.299     0.200
     1.441     8.974     0.200
     1.615    10.541     0.200
     1.964    12.070     0.200
     4.028    18.691     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    17.571   234.701     0.200
    20.366   270.085     0.200
    20.664   272.230     0.200
     5.630    79.776     0.200
     7.541   101.468     0.200
     5.812    81.069     0.200
     7.707   106.245     0.200
     7.707   106.745     0.200
    16.107   207.425     0.200
    21.252   282.780     0.200
     7.815   106.326     0.200
    20.704   269.912     0.200
    21.339   274.701     0.200
     5.272    79.484     0.200
     6.367    90.104     0.200
     7.234   101.581     0.200
     1.296    27.987     0.200
     1.550    29.823     0.200
     2.372    41.237     0.200
     6.794    94.788     0.200
     8.546   117.744     0.200
    17.314   236.815     0.200
     2.889    47.794     0.200
     7.232   101.416     0.200
     7.232   101.217     0.200
     1.937    35.231     0.200
     3.738    58.719     0.200
    16.902   220.694     0.200
     1.520    31.539     0.200
     2.285    39.117     0.200
     2.467    40.689     0.200
     3.036    46.952     0.200
     3.707    56.515     0.200
     4.392    63.528     0.200
     4.713    67.785     0.200
     4.713    67.285     0.200
     5.690    81.580     0.200
     5.920    84.191     0.200
     6.351    90.662     0.200
     6.788    92.067     0.200
     7.656   106.643     0.200
     7.656   106.042     0.200
     7.818   107.544     0.200
    11.159   147.554     0.200
    20.153   263.543     0.200
     2.854    48.591     0.200
     3.322    52.636     0.200
     3.666    55.117     0.200
     6.965    99.617     0.200
     8.599   118.050     0.200
    18.221   237.262     0.200
    19.499   258.341     0.200
    19.574   259.471     0.200
     1.810    33.282     0.200
     6.458    90.932     0.200
    10.523   136.594     0.200
    15.652   202.237     0.200
     3.470    54.625     0.200
     5.852    81.127     0.200
     7.828   109.162     0.200
    17.765   233.800     0.200
    19.621   262.725     0.200
    19.621   263.135     0.200
    19.930   264.026     0.200
     1.970    35.265     0.200
     4.836    67.820     0.200
     6.026    85.324     0.200
     6.698    91.983     0.200
     7.823   105.759     0.200
     7.935   110.955     0.200
     7.935   110.055     0.200
     8.025   108.702     0.200
    16.809   213.194     0.200
     2.591    43.290     0.200
     3.413    55.494     0.200
     3.684    56.431     0.200
     4.922    72.588     0.200
     6.898    98.824     0.200
     7.746   107.128     0.200
     2.104    36.065     0.200
     4.613    69.386     0.200
     5.863    82.903     0.200
     5.898    81.888     0.200
     6.536    89.945     0.200
     6.536    90.843     0.200
     7.668   106.931     0.200
     7.764   106.116     0.200
     7.764   106.515     0.200
     7.850   105.810     0.200
     7.850   105.614     0.200
     3.888    58.502     0.200
     4.093    59.213     0.200
     4.361    63.584     0.200
     1.414    28.360     0.200
     1.763    31.488     0.200
     2.120    35.924     0.200
     4.100    61.110     0.200
     4.183    60.742     0.200
     6.438    90.027     0.200
     8.635   116.387     0.200
     2.261    36.651     0.200
     2.387    39.772     0.200
     4.433    65.296     0.200
     4.434    65.292     0.200
     4.448    65.721     0.200
     5.094    71.880     0.200
     5.695    81.170     0.200
     5.733    81.833     0.200
     6.369    87.410     0.200
     6.752    93.633     0.200
     7.595   106.393     0.200
     7.595   104.093     0.200
     7.684   104.259     0.200
     8.414   111.337     0.200
     1.946    35.204     0.200
     1.946    33.503     0.200
     2.236    37.921     0.200
     3.024    46.525     0.200
     3.884    58.586     0.200
     6.242    87.777     0.200
     7.650   102.869     0.200
     8.529   117.079     0.200
     8.697   117.622     0.200
     1.731    34.840     0.200
     1.731    34.039     0.200
     2.828    46.635     0.200
     3.094    49.636     0.200
     3.882    58.837     0.200
     4.021    60.720     0.200
     4.074    62.597     0.200
     4.074    62.097     0.200
     6.371    91.388     0.200
     8.695   122.575     0.200
     8.695   119.373     0.200
     1.524    30.796     0.200
     2.206    37.337     0.200
     2.206    37.540     0.200
     2.226    40.015     0.200
     2.828    47.290     0.200
     3.625    54.886     0.200
     3.641    54.996     0.200
     3.954    59.652     0.200
     4.852    72.762     0.200
     5.077    75.045     0.200
     5.355    77.591     0.200
     5.580    79.573     0.200
     6.361    88.551     0.200
     7.526   104.054     0.200
     8.407   113.974     0.200
     8.407   116.474     0.200
     8.606   118.054     0.200
     1.216    27.612     0.200
     2.072    36.316     0.200
     2.072    36.215     0.200
     3.486    54.120     0.200
     4.964    70.071     0.200
     5.931    83.188     0.200
     6.953    95.355     0.200
     7.796   106.718     0.200
     7.881   107.728     0.200
     7.881   107.928     0.200
     2.302    39.432     0.200
     2.302    38.432     0.200
     2.449    40.814     0.200
     3.241    51.080     0.200
     4.401    64.042     0.200
     4.396    65.200     0.200
     4.860    70.178     0.200
     4.862    69.856     0.200
     5.154    73.155     0.200
     5.643    81.640     0.200
     5.643    79.042     0.200
     5.684    80.964     0.200
     6.317    88.673     0.200
     6.698    93.738     0.200
     7.456   102.888     0.200
     7.539   102.616     0.200
     7.624   104.322     0.200
     8.451   113.877     0.200
    10.046   134.862     0.200
    11.157   146.288     0.200
    20.230   267.935     0.200
    20.193   270.950     0.200
    20.590   269.814     0.200
    21.060   278.726     0.200
    22.046   286.919     0.200
     2.334    38.940     0.200
     2.334    40.139     0.200
     2.483    42.303     0.200
     3.205    51.783     0.200
     3.963    60.330     0.200
     4.218    64.357     0.200
     4.365    65.545     0.200
     4.368    66.106     0.200
     4.795    69.821     0.200
     5.202    73.777     0.200
     5.647    80.978     0.200
     6.358    90.979     0.200
     6.655    94.215     0.200
     7.495   102.410     0.200
     7.577   105.253     0.200
     2.517    42.515     0.200
     3.237    50.820     0.200
     4.397    64.985     0.200
     5.196    73.155     0.200
     6.684    95.692     0.200
     7.523   103.297     0.200
     2.299    38.732     0.200
     2.299    39.634     0.200
     2.512    42.852     0.200
     3.241    50.545     0.200
     4.401    65.608     0.200
     6.315    88.867     0.200
     6.692    92.465     0.200
     7.532   103.061     0.200
     7.614   103.907     0.200
     2.313    40.563     0.200
     3.224    51.528     0.200
     3.957    61.382     0.200
     4.384    66.791     0.200
     5.120    74.500     0.200
     5.210    74.657     0.200
     5.666    79.833     0.200
     6.296    88.284     0.200
     6.386    89.725     0.200
     6.670    94.116     0.200
     7.587   105.815     0.200
     2.299    38.987     0.200
     2.506    40.165     0.200
     5.158    72.513     0.200
     7.540   103.121     0.200
     7.624   106.740     0.200
     2.314    40.026     0.200
     2.506    42.588     0.200
     3.158    51.578     0.200
     3.224    51.514     0.200
     4.238    63.176     0.200
     4.384    65.070     0.200
     4.384    65.671     0.200
     5.204    73.203     0.200
     5.423    81.537     0.200
     5.621    80.939     0.200
     5.621    80.837     0.200
     6.380    91.572     0.200
     6.671    93.783     0.200
     7.510   105.887     0.200
     7.589   104.861     0.200
    11.180   142.901     0.200
    15.935   206.760     0.200
     2.301    39.540     0.200
     2.509    44.319     0.200
     4.400    65.844     0.200
     4.400    65.548     0.200
     4.399    65.657     0.200
     5.172    73.327     0.200
     5.640    81.373     0.200
     6.314    87.804     0.200
     6.692    93.395     0.200
     7.533   105.688     0.200
     7.615   106.923     0.200
     8.471   112.929     0.200
     2.499    43.581     0.200
     2.518    44.261     0.200
     3.206    50.937     0.200
     4.250    65.251     0.200
     4.366    67.400     0.200
     4.366    66.099     0.200
     4.377    67.570     0.200
     4.801    70.521     0.200
     5.232    75.986     0.200
     5.600    80.194     0.200
     5.647    81.545     0.200
     6.276    89.409     0.200
     6.386    90.320     0.200
     6.649    95.555     0.200
     6.649    95.157     0.200
     7.487   106.174     0.200
     8.517   117.344     0.200
     2.300    39.228     0.200
     3.164    52.454     0.200
     4.404    64.485     0.200
     5.687    80.804     0.200
     6.321    88.211     0.200
     6.702    93.267     0.200
     7.544   106.535     0.200
     7.630   105.437     0.200
     2.305    39.675     0.200
     2.659    42.643     0.200
     3.854    59.005     0.200
     8.564   118.130     0.200
     8.564   119.232     0.200
     1.141    26.541     0.200
     1.628    32.155     0.200
     2.299    40.527     0.200
     3.871    58.680     0.200
     3.871    59.580     0.200
     3.747    59.424     0.200
     5.181    75.592     0.200
     2.309    39.423     0.200
     3.232    52.659     0.200
     3.930    61.304     0.200
     5.172    74.112     0.200
     6.307    89.072     0.200
     6.685    94.355     0.200
     6.685    95.855     0.200
     7.609   104.570     0.200
     2.428    42.190     0.200
     2.459    40.531     0.200
     3.702    57.723     0.200
     5.087    74.162     0.200
     8.460   116.393     0.200
    11.798   158.844     0.200
     2.105    37.644     0.200
     2.679    46.943     0.200
     5.045    72.931     0.200
     6.476    92.837     0.200
     7.737   108.620     0.200
     7.814   110.517     0.200
     4.325    66.726     0.200
     4.338    66.471     0.200
     5.257    75.740     0.200
     5.559    80.131     0.200
     5.606    81.376     0.200
     5.606    80.876     0.200
     6.607    91.987     0.200
     7.446   104.506     0.200
     7.524   104.790     0.200
     2.332    42.401     0.200
     3.366    53.236     0.200
     4.094    62.231     0.200
     1.537    29.921     0.200
     1.551    30.548     0.200
     1.551    30.349     0.200
     2.352    40.108     0.200
     2.801    42.359     0.200
     3.628    55.215     0.200
     3.782    56.007     0.200
     1.591    32.410     0.200
     1.591    32.511     0.200
     2.267    40.520     0.200
     3.128    51.566     0.200
     3.494    55.500     0.200
     4.384    67.112     0.200
     5.684    83.539     0.200
     6.409    89.381     0.200
     7.492   103.440     0.200
     2.252    38.609     0.200
     3.292    52.972     0.200
     4.452    66.739     0.200
     7.591   108.304     0.200
     7.591   104.202     0.200
     7.675   105.130     0.200
     2.324    39.849     0.200
     3.217    52.624     0.200
     4.378    65.687     0.200
     4.375    65.411     0.200
     5.174    72.893     0.200
     6.293    90.923     0.200
     6.293    86.830     0.200
     6.673    93.098     0.200
     7.514   104.780     0.200
     7.514   104.584     0.200
     7.599   103.993     0.200
     7.599   103.688     0.200
     1.382    30.787     0.200
     1.835    37.200     0.200
     1.835    37.099     0.200
     3.961    62.584     0.200
     7.637   102.162     0.200
     8.245   113.467     0.200
     8.690   117.281     0.200
    17.122   225.376     0.200
    17.831   238.505     0.200
    18.821   248.454     0.200
    20.863   276.113     0.200
     2.698    45.718     0.200
     3.625    57.603     0.200
     4.082    61.672     0.200
     4.218    64.788     0.200
     4.218    67.688     0.200
     5.448    79.832     0.200
     6.745    98.397     0.200
     7.407   105.368     0.200
     7.836   108.562     0.200
     7.836   108.663     0.200
     8.697   123.711     0.200
     8.826   124.010     0.200
    21.198   282.022     0.200
     2.571    44.310     0.200
     2.776    44.919     0.200
     2.727    45.484     0.200
     2.885    47.643     0.200
     3.675    56.824     0.200
     3.881    60.526     0.200
     3.881    59.729     0.200
     5.166    72.525     0.200
     5.166    73.523     0.200
     5.170    75.374     0.200
     5.758    83.817     0.200
     5.831    82.871     0.200
     5.831    82.770     0.200
     6.257    85.993     0.200
     7.123    98.589     0.200
     7.123    98.394     0.200
     8.139   114.156     0.200
    17.710   235.937     0.200
    21.376   281.851     0.200
     1.015    24.383     0.200
     1.234    27.123     0.200
     1.288    25.897     0.200
     1.288    25.895     0.200
     1.288    26.196     0.200
     2.107    36.336     0.200
     2.663    43.842     0.200
     4.892    68.431     0.200
     7.758   106.382     0.200
     7.844   108.188     0.200
     1.612    33.746     0.200
     2.316    42.426     0.200
     4.062    63.351     0.200
     4.317    65.677     0.200
     1.800    33.072     0.200
     1.800    32.771     0.200
     2.289    38.676     0.200
     3.992    58.991     0.200
     1.793    37.715     0.200
     3.774    59.303     0.200
     3.774    58.803     0.200
     4.026    61.955     0.200
     5.538    80.105     0.200
     6.413    91.202     0.200
    10.059   130.336     0.200
     1.377    31.475     0.200
     1.614    33.301     0.200
     4.064    61.917     0.200
     4.064    63.011     0.200
     5.459    78.633     0.200
     1.077    24.953     0.200
     1.414    28.919     0.200
     1.414    28.321     0.200
     1.939    33.594     0.200
     3.466    51.273     0.200
     4.790    67.523     0.200
     7.981   111.588     0.200
    10.737   137.046     0.200
     2.346    41.214     0.200
     3.161    50.103     0.200
     3.615    55.007     0.200
     3.915    59.901     0.200
     5.370    77.621     0.200
     8.824   120.714     0.200
     2.028    35.477     0.200
     3.398    51.294     0.200
     3.591    55.840     0.200
     4.124    61.316     0.200
     4.737    68.160     0.200
     7.090   100.201     0.200
     7.942   108.762     0.200
     8.050   110.193     0.200
    10.796   142.757     0.200
     1.897    32.035     0.200
     2.268    38.702     0.200
     6.291    89.848     0.200
     1.382    27.614     0.200
     1.382    27.814     0.200
     1.326    27.166     0.200
     2.045    34.772     0.200
     2.045    34.072     0.200
     3.339    49.970     0.200
     3.410    48.948     0.200
     4.536    65.106     0.200
     5.939    83.431     0.200
     6.611    89.386     0.200
     7.000    95.145     0.200
     7.316   100.458     0.200
     7.845   104.985     0.200
     7.845   107.884     0.200
     7.935   108.335     0.200
     7.935   107.436     0.200
     1.375    31.764     0.200
     2.616    44.373     0.200
     2.616    43.974     0.200
     2.627    45.747     0.200
     2.840    50.668     0.200
     2.950    48.876     0.200
     3.478    54.623     0.200
     3.932    60.822     0.200
     4.075    64.855     0.200
     4.109    65.356     0.200
     4.109    63.655     0.200
     5.173    75.442     0.200
     5.173    75.942     0.200
     7.421   105.601     0.200
     1.370    31.635     0.200
     2.615    43.910     0.200
     2.615    44.111     0.200
     2.624    46.210     0.200
     2.841    49.871     0.200
     4.076    64.356     0.200
     5.168    75.812     0.200
     5.168    76.013     0.200
     5.624    82.193     0.200
     7.301   104.618     0.200
     7.425   107.176     0.200
     1.081    25.086     0.200
     1.486    29.555     0.200
     1.979    34.307     0.200
     2.769    45.487     0.200
     3.318    50.581     0.200
     3.480    52.392     0.200
     3.500    54.051     0.200
     3.610    55.460     0.200
     4.431    64.982     0.200
     4.615    66.841     0.200
     4.769    69.144     0.200
     4.807    69.000     0.200
     5.018    72.132     0.200
     5.449    78.202     0.200
     5.687    80.431     0.200
     6.281    87.493     0.200
     6.701    93.800     0.200
     7.095    97.200     0.200
     7.822   107.807     0.200
     7.942   108.010     0.200
     8.037   109.709     0.200
     1.554    33.854     0.200
     2.497    45.352     0.200
     3.464    56.174     0.200
     3.812    59.907     0.200
     4.125    65.450     0.200
     6.446    95.073     0.200
     1.531    33.118     0.200
     1.952    37.100     0.200
     1.783    36.969     0.200
     3.480    54.169     0.200
     3.486    56.104     0.200
     3.821    59.586     0.200
     4.034    62.309     0.200
     4.369    62.593     0.200
     8.959   124.525     0.200
    16.902   212.996     0.200
     1.228    29.759     0.200
     1.532    33.210     0.200
     1.774    37.086     0.200
     3.477    55.217     0.200
     3.476    58.221     0.200
     3.824    59.266     0.200
     6.425    94.809     0.200
     7.932   108.719     0.200
     8.803   124.155     0.200
     8.963   125.392     0.200
     1.547    33.963     0.200
     2.553    41.626     0.200
     2.490    41.264     0.200
     3.806    59.903     0.200
     4.035    62.932     0.200
     5.518    78.423     0.200
     8.975   123.379     0.200
    10.075   138.944     0.200
    16.897   213.736     0.200
    18.374   244.290     0.200
    19.095   255.780     0.200
    19.821   268.902     0.200
    19.952   270.772     0.200
    20.704   276.903     0.200
    21.108   281.785     0.200
     1.238    29.680     0.200
     1.976    37.358     0.200
     2.487    44.497     0.200
     3.464    56.502     0.200
     3.820    60.943     0.200
     4.059    59.847     0.200
     1.543    33.308     0.200
     1.758    35.806     0.200
     3.463    55.407     0.200
     3.821    60.126     0.200
     4.116    64.285     0.200
    10.062   140.300     0.200
     1.234    29.595     0.200
     1.539    32.833     0.200
     4.051    62.222     0.200
     1.269    30.884     0.200
     1.998    38.570     0.200
     2.517    44.414     0.200
     2.517    44.113     0.200
     3.332    52.704     0.200
     3.434    55.019     0.200
     3.790    58.964     0.200
     4.416    66.259     0.200
     5.551    81.110     0.200
     5.618    82.929     0.200
     6.082    88.118     0.200
     6.084    89.195     0.200
     6.442    91.713     0.200
     6.442    91.912     0.200
    16.871   213.065     0.200
     2.540    44.335     0.200
     3.477    55.696     0.200
     3.770    58.780     0.200
     3.770    59.479     0.200
     7.542   107.061     0.200
     7.972   108.743     0.200
     8.867   125.399     0.200
     1.559    33.236     0.200
     1.985    38.258     0.200
     8.831   126.771     0.200
    16.876   212.401     0.200
     1.182    28.350     0.200
     1.430    31.359     0.200
     3.440    54.007     0.200
     3.571    55.969     0.200
     3.571    58.071     0.200
     5.434    80.337     0.200
     7.847   109.777     0.200
     8.716   124.334     0.200
     8.869   122.855     0.200
     2.489    44.212     0.200
     3.810    59.198     0.200
     3.810    59.401     0.200
     4.042    63.293     0.200
     6.425    90.582     0.200
     8.976   124.511     0.200
     8.976   124.711     0.200
     1.455    29.366     0.200
     1.916    35.179     0.200
     3.392    51.757     0.200
     8.169   112.413     0.200
     1.541    32.840     0.200
     2.484    42.636     0.200
     3.294    51.991     0.200
     3.470    55.231     0.200
     3.491    56.091     0.200
     3.810    59.969     0.200
     3.810    60.168     0.200
     4.031    62.184     0.200
     5.512    79.200     0.200
     6.414    92.671     0.200
     7.483   105.199     0.200
     8.969   126.260     0.200
    10.081   136.532     0.200
    10.081   137.489     0.200
     1.410    30.021     0.200
     1.617    32.811     0.200
     2.445    40.851     0.200
     3.372    53.125     0.200
     3.661    56.959     0.200
     4.032    59.718     0.200
     4.128    60.709     0.200
     4.556    70.716     0.200
     5.132    77.092     0.200
     5.132    73.991     0.200
     6.656    91.802     0.200
     7.972   111.144     0.200
     8.746   122.515     0.200
     1.369    29.022     0.200
     1.832    34.122     0.200
     2.312    38.416     0.200
     2.312    41.317     0.200
     2.312    41.117     0.200
     3.494    53.124     0.200
     3.947    59.830     0.200
     3.955    59.038     0.200
     3.955    60.637     0.200
     3.991    60.719     0.200
     4.214    65.024     0.200
     4.512    67.143     0.200
     4.590    66.835     0.200
     5.352    77.044     0.200
     6.258    85.971     0.200
     6.879    95.822     0.200
     7.320   100.671     0.200
     8.638   115.789     0.200
     8.796   119.045     0.200
     8.796   119.645     0.200
    12.276   163.533     0.200
     1.605    30.940     0.200
     2.104    37.522     0.200
     2.544    41.189     0.200
     3.315    49.384     0.200
     3.455    52.552     0.200
     3.851    57.134     0.200
     4.269    63.154     0.200
     4.221    65.014     0.200
     4.509    67.362     0.200
     5.650    79.443     0.200
     6.061    85.340     0.200
     6.939    96.596     0.200
     8.056   110.563     0.200
     2.481    43.691     0.200
     3.290    53.955     0.200
     3.812    60.870     0.200
     4.029    60.933     0.200
     4.029    61.933     0.200
     4.094    62.272     0.200
     4.341    65.689     0.200
     4.374    63.513     0.200
     5.509    78.862     0.200
     5.809    82.161     0.200
     6.139    88.108     0.200
     6.797    94.636     0.200
     7.036    97.840     0.200
     8.531   118.089     0.200
    12.447   167.302     0.200
     1.030    24.097     0.200
     1.561    30.601     0.200
     1.561    32.001     0.200
     2.499    43.755     0.200
     6.598    94.910     0.200
    12.469   164.699     0.200
     1.527    32.825     0.200
     1.794    36.905     0.200
     3.495    55.747     0.200
     3.820    59.357     0.200
     8.953   125.453     0.200
     1.219    29.954     0.200
     1.343    32.701     0.200
     2.723    43.995     0.200
     2.744    47.557     0.200
     2.907    50.157     0.200
     3.367    53.386     0.200
     4.057    62.634     0.200
     4.033    60.711     0.200
     4.056    62.543     0.200
     4.694    70.302     0.200
     4.964    75.041     0.200
     4.991    73.634     0.200
     4.991    73.837     0.200
     5.579    78.468     0.200
     5.791    84.500     0.200
     6.445    89.767     0.200
     7.312   105.846     0.200
     7.478   103.212     0.200
     7.478   107.712     0.200
     1.543    33.192     0.200
     2.486    43.288     0.200
     2.557    44.861     0.200
     3.295    52.254     0.200
     3.492    54.453     0.200
     3.469    57.321     0.200
     3.808    59.964     0.200
     3.808    60.564     0.200
     4.031    61.862     0.200
     4.099    62.466     0.200
     4.378    64.505     0.200
     5.285    76.920     0.200
     5.513    80.361     0.200
     5.513    80.760     0.200
     5.581    82.476     0.200
     5.814    84.257     0.200
     6.113    88.358     0.200
     6.418    90.709     0.200
     6.414    93.851     0.200
     6.414    94.750     0.200
     7.484   104.559     0.200
     7.937   110.376     0.200
     8.018   113.132     0.200
     8.809   122.102     0.200
     8.809   122.503     0.200
     8.971   122.014     0.200
    10.080   135.372     0.200
     3.447    56.253     0.200
     3.455    53.769     0.200
     3.814    60.169     0.200
     3.814    60.372     0.200
     4.071    62.667     0.200
     4.408    65.844     0.200
     5.544    80.982     0.200
     6.116    88.510     0.200
     6.455    92.154     0.200
     8.016   110.939     0.200
     8.992   122.647     0.200
     9.475   132.537     0.200
    10.045   139.454     0.200
    12.774   168.633     0.200
     1.414    31.555     0.200
     1.858    37.375     0.200
     3.465    53.919     0.200
     3.592    56.530     0.200
     3.929    60.899     0.200
     3.929    61.500     0.200
     5.407    79.257     0.200
     5.717    82.035     0.200
     6.242    89.604     0.200
     6.313    91.381     0.200
     6.398    91.695     0.200
     7.822   108.269     0.200
     8.146   115.590     0.200
     8.434   116.427     0.200
     8.692   120.321     0.200
     8.847   121.408     0.200
     1.417    31.256     0.200
     1.872    36.154     0.200
     2.360    41.853     0.200
     3.445    52.595     0.200
     3.936    61.568     0.200
     5.420    76.844     0.200
     8.149   111.300     0.200
     8.855   121.556     0.200
     8.855   123.256     0.200
     9.387   130.726     0.200
    10.158   140.252     0.200
     1.430    31.906     0.200
     1.770    36.645     0.200
     1.882    37.535     0.200
     3.447    54.971     0.200
     3.924    61.411     0.200
     4.028    62.397     0.200
     4.049    61.946     0.200
     4.292    65.615     0.200
     5.430    78.025     0.200
     6.420    90.876     0.200
     8.458   117.189     0.200
     8.714   120.809     0.200
     8.867   121.916     0.200
     8.867   124.014     0.200
     1.176    28.411     0.200
     1.435    31.982     0.200
     3.435    55.247     0.200
     3.925    60.830     0.200
     3.925    61.130     0.200
     8.875   122.562     0.200
    10.137   137.536     0.200
    20.682   275.348     0.200
     1.439    31.068     0.200
     1.888    36.629     0.200
     3.915    60.278     0.200
     1.163    28.573     0.200
     1.449    31.935     0.200
     1.904    37.529     0.200
     2.392    42.232     0.200
     2.636    46.188     0.200
     3.252    53.295     0.200
     3.438    55.430     0.200
     3.912    61.292     0.200
     3.912    61.393     0.200
     4.063    63.137     0.200
     4.063    60.035     0.200
     4.049    62.490     0.200
     4.314    65.508     0.200
     4.426    66.991     0.200
     5.232    77.286     0.200
     5.452    80.917     0.200
     6.002    87.905     0.200
     6.207    90.415     0.200
     6.435    92.448     0.200
     7.420   104.952     0.200
     8.480   117.179     0.200
     8.735   121.507     0.200
     8.735   122.507     0.200
     8.888   123.521     0.200
    10.127   139.765     0.200
     1.134    27.786     0.200
     1.164    27.732     0.200
     1.444    32.066     0.200
     1.906    36.176     0.200
     2.387    41.569     0.200
     3.256    53.216     0.200
     3.425    54.855     0.200
     3.922    60.846     0.200
     3.922    60.744     0.200
     4.315    66.168     0.200
     4.430    66.017     0.200
     5.454    80.871     0.200
     5.454    77.773     0.200
     6.006    87.432     0.200
     6.446    93.592     0.200
     8.734   119.588     0.200
     8.886   122.123     0.200
     1.116    27.212     0.200
     1.195    28.592     0.200
     1.421    31.656     0.200
     1.870    37.310     0.200
     2.364    40.455     0.200
     2.667    45.809     0.200
     3.219    53.172     0.200
     3.453    54.440     0.200
     3.929    61.289     0.200
     4.016    62.270     0.200
     4.041    63.377     0.200
     4.456    67.338     0.200
     5.419    79.096     0.200
     5.419    78.596     0.200
     5.730    82.266     0.200
     5.813    84.406     0.200
     5.969    86.483     0.200
     6.411    92.618     0.200
     7.833   109.022     0.200
     8.703   120.480     0.200
     8.703   121.777     0.200
     8.857   121.977     0.200
     1.420    31.159     0.200
     1.866    37.250     0.200
     5.415    78.431     0.200
    10.165   139.804     0.200
    17.709   234.128     0.200
     1.125    27.329     0.200
     1.433    31.627     0.200
     1.756    36.161     0.200
     3.241    52.426     0.200
     3.434    53.981     0.200
     3.927    61.221     0.200
     4.300    65.271     0.200
     4.442    66.914     0.200
     5.439    79.077     0.200
     5.991    85.939     0.200
     6.223    89.031     0.200
     6.434    92.473     0.200
     7.407   102.515     0.200
     7.852   110.218     0.200
     8.468   117.832     0.200
     8.721   119.082     0.200
     8.873   121.305     0.200
     1.865    37.488     0.200
     2.327    42.307     0.200
     3.223    52.747     0.200
     4.015    62.106     0.200
     4.084    63.497     0.200
     4.268    65.345     0.200
     5.410    78.026     0.200
     5.728    84.309     0.200
     8.192   114.658     0.200
     8.684   119.821     0.200
     8.684   121.122     0.200
     8.831   122.405     0.200
    10.161   139.375     0.200
    10.161   135.976     0.200
    18.551   244.872     0.200
    19.044   255.919     0.200
     0.977    23.424     0.200
     1.273    25.776     0.200
     1.498    30.451     0.200
     1.498    29.951     0.200
     2.074    35.925     0.200
     2.670    45.167     0.200
     3.446    52.923     0.200
     3.502    53.062     0.200
     3.396    51.900     0.200
     4.080    59.714     0.200
     4.541    65.831     0.200
     4.734    67.389     0.200
     4.734    67.287     0.200
     4.708    68.384     0.200
     4.708    68.087     0.200
     4.930    70.794     0.200
     5.316    75.991     0.200
     5.997    83.647     0.200
     6.225    85.579     0.200
     6.650    91.625     0.200
     7.057    97.680     0.200
     7.910   107.721     0.200
     7.910   108.018     0.200
     8.024   109.995     0.200
     8.024   108.190     0.200
     8.990   121.015     0.200
    10.835   141.506     0.200
    10.835   145.287     0.200
    19.800   264.867     0.200
    20.718   275.145     0.200
     1.464    29.285     0.200
     3.365    52.806     0.200
     4.172    64.188     0.200
     4.252    63.349     0.200
     4.522    66.901     0.200
     4.522    67.101     0.200
     4.944    71.879     0.200
     4.944    72.179     0.200
     6.892    94.847     0.200
     8.086   111.803     0.200
     8.162   113.222     0.200
     8.162   113.022     0.200
     8.280   114.940     0.200
     8.280   116.440     0.200
     1.624    31.883     0.200
     2.051    35.496     0.200
     2.560    40.862     0.200
     3.174    49.494     0.200
     3.767    55.076     0.200
     3.639    55.161     0.200
     3.639    53.962     0.200
     3.773    56.708     0.200
     3.773    60.208     0.200
     3.995    58.111     0.200
     4.316    64.268     0.200
     4.320    64.117     0.200
     5.440    78.348     0.200
     6.118    86.037     0.200
     6.724    93.370     0.200
     7.419   102.354     0.200
     7.893   111.425     0.200
     8.776   122.719     0.200
     9.258   126.994     0.200
    10.205   134.558     0.200
    10.205   136.940     0.200
    15.412   196.771     0.200
    15.412   200.474     0.200
    20.892   276.820     0.200
    21.252   276.828     0.200
     2.807    48.636     0.200
     2.891    44.950     0.200
     3.081    50.531     0.200
     3.815    58.772     0.200
     3.994    63.578     0.200
     4.051    62.619     0.200
     4.051    63.018     0.200
     4.470    65.827     0.200
     4.504    67.723     0.200
     5.115    75.398     0.200
     4.970    72.994     0.200
     5.281    76.764     0.200
     5.281    78.361     0.200
     5.304    78.497     0.200
     5.336    77.418     0.200
     5.559    81.417     0.200
     5.992    85.361     0.200
     5.976    86.845     0.200
     6.083    87.399     0.200
     6.369    91.162     0.200
     7.789   108.791     0.200
     8.130   112.366     0.200
     8.248   112.934     0.200
     8.359   115.743     0.200
    11.500   156.299     0.200
    11.500   153.881     0.200
    19.934   264.855     0.200
     1.641    32.120     0.200
     1.641    30.720     0.200
     1.730    31.884     0.200
     2.070    36.719     0.200
     2.582    43.236     0.200
     4.488    66.001     0.200
     5.622    79.357     0.200
     5.622    82.457     0.200
     6.486    90.684     0.200
     6.486    92.984     0.200
     7.648   104.314     0.200
     9.973   135.890     0.200
    16.821   207.915     0.200
    21.574   283.606     0.200
     1.389    31.256     0.200
     1.282    30.318     0.200
     1.968    37.400     0.200
     1.968    37.502     0.200
     2.220    41.863     0.200
     3.763    59.361     0.200
     3.800    59.123     0.200
     3.865    60.672     0.200
     3.865    59.868     0.200
     3.992    62.281     0.200
     3.992    61.882     0.200
     5.211    76.762     0.200
     5.211    75.465     0.200
     5.287    77.163     0.200
     6.420    91.149     0.200
     6.499    92.128     0.200
     7.388   106.434     0.200
     7.641   107.302     0.200
     7.636   106.760     0.200
     8.678   119.400     0.200
    10.377   141.769     0.200
    12.936   169.698     0.200
    16.609   216.137     0.200
    17.832   238.473     0.200
     1.642    33.415     0.200
     1.959    37.012     0.200
     3.788    58.462     0.200
     4.027    60.880     0.200
     4.027    62.980     0.200
     4.428    67.295     0.200
     5.192    76.677     0.200
     5.192    76.978     0.200
     5.276    78.296     0.200
     6.231    90.358     0.200
     6.720    94.753     0.200
     7.162   101.389     0.200
     7.417   105.885     0.200
     9.159   127.427     0.200
    10.130   140.352     0.200
    10.390   138.285     0.200
    10.390   142.715     0.200
    12.971   169.100     0.200
    18.198   240.701     0.200
    20.459   272.819     0.200
    20.857   280.366     0.200
     1.635    31.523     0.200
     1.635    31.722     0.200
     1.796    32.734     0.200
     1.589    31.759     0.200
     8.304   116.687     0.200
     8.422   114.108     0.200
    10.463   137.985     0.200
    10.463   141.992     0.200
    10.538   144.721     0.200
    16.977   211.491     0.200
    20.973   275.038     0.200
     1.216    28.799     0.200
     1.441    31.174     0.200
     1.615    32.541     0.200
     1.615    32.741     0.200
     1.964    37.270     0.200
     2.156    39.437     0.200
     2.966    48.874     0.200
     3.806    59.877     0.200
     3.761    57.698     0.200
     4.058    61.632     0.200
     4.028    60.891     0.200
     5.165    77.217     0.200
     7.436   105.415     0.200
     7.688   105.273     0.200
     8.455   115.618     0.200
    20.346   273.757     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.438    45.877     0.200
     3.643    71.986     0.200
     2.229    41.698     0.200
     2.372    45.635     0.200
     2.275    43.970     0.200
     2.758    54.927     0.200
     3.068    62.301     0.200
     4.190    82.314     0.200
     4.190    82.517     0.200
     4.297    82.763     0.200
     5.429   106.055     0.200
     5.820   114.695     0.200
     6.645   129.966     0.200
     8.473   163.836     0.200
     2.307    42.746     0.200
     3.135    64.679     0.200
     4.321    84.042     0.200
     5.503   104.247     0.200
     5.890   115.329     0.200
     6.794   132.589     0.200
     6.794   128.788     0.200
     7.879   151.027     0.200
     8.546   164.443     0.200
     8.736   167.920     0.200
     8.736   167.420     0.200
     8.852   172.268     0.200
     3.509    67.860     0.200
     4.335    82.225     0.200
     5.253   100.809     0.200
     5.632   111.093     0.200
     6.359   120.611     0.200
     7.232   137.416     0.200
     7.232   137.316     0.200
     2.165    39.870     0.200
     3.738    71.621     0.200
     4.224    82.741     0.200
     6.208   121.199     0.200
     2.467    45.986     0.200
     3.036    59.147     0.200
     3.713    72.955     0.200
     3.707    71.718     0.200
     3.707    72.515     0.200
     4.392    83.528     0.200
     4.713    93.285     0.200
     4.713    92.785     0.200
     4.781    90.491     0.200
     4.781    93.491     0.200
     5.690   110.377     0.200
     6.351   120.162     0.200
     6.788   128.364     0.200
     7.433   142.540     0.200
     7.433   144.243     0.200
    21.051   406.563     0.200
     3.322    64.136     0.200
     3.666    71.117     0.200
     5.621   109.204     0.200
     6.965   136.617     0.200
     3.181    62.567     0.200
     4.166    82.079     0.200
     4.497    88.417     0.200
     6.300   120.378     0.200
     7.379   141.288     0.200
     8.068   155.741     0.200
     2.870    54.421     0.200
     2.870    56.620     0.200
     3.470    68.625     0.200
     3.595    70.559     0.200
     4.099    80.778     0.200
     4.726    90.467     0.200
     5.852   114.826     0.200
     6.174   121.060     0.200
     7.178   139.851     0.200
     8.861   173.110     0.200
     9.170   178.599     0.200
     9.345   179.855     0.200
     9.438   186.469     0.200
     2.054    38.080     0.200
     3.516    67.023     0.200
     4.244    80.726     0.200
     4.769    91.399     0.200
     4.836    93.720     0.200
     4.836    93.921     0.200
     5.207   100.390     0.200
     6.026   115.324     0.200
     6.026   115.724     0.200
     6.476   125.882     0.200
     6.698   127.183     0.200
     7.089   137.322     0.200
     3.413    66.096     0.200
     3.684    72.126     0.200
     4.134    81.581     0.200
     4.134    81.784     0.200
     4.571    88.472     0.200
     4.571    88.269     0.200
     4.831    92.840     0.200
     4.922    96.588     0.200
     5.831   111.564     0.200
     6.335   124.089     0.200
     6.503   123.833     0.200
     6.898   133.723     0.200
     7.625   147.436     0.200
     7.746   149.925     0.200
     2.104    39.065     0.200
     2.230    44.495     0.200
     2.231    42.581     0.200
     2.665    50.721     0.200
     3.453    66.420     0.200
     3.692    71.633     0.200
     3.692    71.532     0.200
     4.237    83.176     0.200
     4.237    82.379     0.200
     4.613    88.183     0.200
     4.613    89.386     0.200
     4.983    97.171     0.200
     5.062    97.548     0.200
     5.863   111.403     0.200
     5.898   112.287     0.200
     6.434   123.926     0.200
     6.434   125.824     0.200
     6.536   124.742     0.200
     7.668   148.134     0.200
     7.764   150.015     0.200
     7.850   152.013     0.200
     3.299    64.175     0.200
     3.888    76.502     0.200
     3.888    76.303     0.200
     4.093    78.815     0.200
     4.093    81.213     0.200
     4.361    83.186     0.200
     5.500   107.394     0.200
     5.587   108.283     0.200
     6.470   126.180     0.200
     6.811   131.801     0.200
     7.468   140.931     0.200
     8.528   165.655     0.200
     2.120    40.525     0.200
     2.887    55.472     0.200
     3.095    58.838     0.200
     4.100    78.110     0.200
     4.099    79.423     0.200
     4.183    80.644     0.200
     5.101    99.832     0.200
     5.103    99.812     0.200
     5.247   102.229     0.200
     5.381   104.964     0.200
     5.835   113.664     0.200
     6.438   127.027     0.200
     6.537   124.475     0.200
     6.545   126.784     0.200
     7.206   137.162     0.200
     7.637   147.533     0.200
     8.286   161.668     0.200
     8.500   164.567     0.200
     8.635   165.785     0.200
     2.527    48.740     0.200
     3.199    62.198     0.200
     3.288    63.157     0.200
     3.853    74.570     0.200
     4.189    79.349     0.200
     4.189    81.448     0.200
     4.433    85.096     0.200
     4.434    85.091     0.200
     4.448    86.021     0.200
     4.448    85.021     0.200
     4.744    91.370     0.200
     5.094    98.281     0.200
     5.164   100.569     0.200
     5.481   103.873     0.200
     5.695   109.270     0.200
     5.733   109.333     0.200
     6.354   123.180     0.200
     6.369   121.709     0.200
     6.369   121.110     0.200
     6.752   130.233     0.200
     7.503   143.869     0.200
     7.595   145.093     0.200
     2.236    43.020     0.200
     2.835    55.832     0.200
     2.835    54.531     0.200
     3.024    59.324     0.200
     3.985    77.609     0.200
     3.985    76.410     0.200
     3.884    76.385     0.200
     3.884    75.686     0.200
     4.098    77.696     0.200
     4.098    78.196     0.200
     5.042    96.080     0.200
     5.044    96.052     0.200
     5.233   100.545     0.200
     5.774   112.130     0.200
     6.242   119.978     0.200
     7.204   137.148     0.200
     7.650   146.818     0.200
     8.258   160.351     0.200
     8.529   163.079     0.200
     8.697   166.722     0.200
     2.828    55.635     0.200
     3.094    60.636     0.200
     3.094    60.337     0.200
     3.882    74.436     0.200
     4.021    78.720     0.200
     4.021    78.419     0.200
     4.074    79.797     0.200
     4.074    78.898     0.200
     4.131    79.331     0.200
     5.273   100.004     0.200
     6.371   124.487     0.200
     6.563   126.754     0.200
     7.238   137.673     0.200
     7.679   146.030     0.200
     8.695   167.575     0.200
     2.206    40.837     0.200
     2.828    53.888     0.200
     2.828    54.888     0.200
     2.962    57.319     0.200
     3.625    69.686     0.200
     3.625    70.186     0.200
     3.641    69.297     0.200
     3.926    75.969     0.200
     3.926    76.168     0.200
     3.954    75.550     0.200
     3.954    76.050     0.200
     4.852    94.364     0.200
     5.077    96.842     0.200
     5.355   103.993     0.200
     5.401   104.551     0.200
     5.580   108.972     0.200
     6.361   122.551     0.200
     6.405   122.937     0.200
     8.606   165.754     0.200
     2.694    52.663     0.200
     3.486    67.120     0.200
     3.662    71.666     0.200
     3.662    70.966     0.200
     4.250    84.906     0.200
     4.250    81.906     0.200
     4.618    88.605     0.200
     4.646    89.786     0.200
     4.964    97.270     0.200
     4.964    95.571     0.200
     5.058    96.674     0.200
     5.350   102.666     0.200
     5.931   114.188     0.200
     2.449    47.513     0.200
     2.501    48.612     0.200
     2.501    48.714     0.200
     3.241    61.881     0.200
     3.241    61.779     0.200
     3.914    75.817     0.200
     4.203    81.744     0.200
     4.203    81.545     0.200
     4.271    83.061     0.200
     4.401    84.139     0.200
     4.401    83.940     0.200
     4.396    84.500     0.200
     4.826    92.080     0.200
     4.860    93.877     0.200
     4.862    92.555     0.200
     5.154   100.956     0.200
     5.154    99.757     0.200
     5.643   108.343     0.200
     5.643   107.241     0.200
     5.684   108.663     0.200
     6.317   119.373     0.200
     6.317   120.474     0.200
     6.355   122.237     0.200
     6.698   128.137     0.200
     7.456   140.787     0.200
     7.456   141.787     0.200
     2.483    48.506     0.200
     2.483    48.904     0.200
     2.499    48.520     0.200
     3.205    60.881     0.200
     3.205    61.881     0.200
     3.963    77.232     0.200
     4.218    83.056     0.200
     4.218    81.459     0.200
     4.239    82.513     0.200
     4.365    83.444     0.200
     4.365    82.643     0.200
     4.368    84.708     0.200
     4.795    91.024     0.200
     5.202   100.477     0.200
     5.202   100.277     0.200
     5.603   108.091     0.200
     5.647   107.279     0.200
     6.278   119.215     0.200
     6.358   122.779     0.200
     6.358   123.979     0.200
     6.655   127.614     0.200
     7.420   143.189     0.200
     7.487   144.808     0.200
     9.615   184.471     0.200
     2.479    47.566     0.200
     2.517    48.922     0.200
     2.517    49.117     0.200
     3.237    62.617     0.200
     3.941    76.394     0.200
     3.941    76.597     0.200
     4.243    81.372     0.200
     4.243    82.278     0.200
     4.272    81.938     0.200
     4.397    83.883     0.200
     4.397    83.985     0.200
     4.402    85.122     0.200
     4.829    91.542     0.200
     5.196   100.451     0.200
     5.196   100.350     0.200
     5.679   107.618     0.200
     6.309   121.468     0.200
     6.388   123.245     0.200
     6.684   129.590     0.200
     7.452   144.731     0.200
     7.468   142.842     0.200
     7.523   144.000     0.200
     9.637   183.733     0.200
     2.299    42.533     0.200
     2.464    47.811     0.200
     2.512    49.250     0.200
     3.241    61.943     0.200
     3.241    62.244     0.200
     3.927    76.429     0.200
     3.927    76.531     0.200
     4.226    79.940     0.200
     4.226    82.041     0.200
     4.274    83.989     0.200
     4.401    84.905     0.200
     4.401    85.006     0.200
     4.401    85.603     0.200
     4.829    93.402     0.200
     5.131    99.488     0.200
     5.176   101.156     0.200
     6.315   118.769     0.200
     6.315   120.367     0.200
     6.375   122.368     0.200
     6.375   122.571     0.200
     6.692   128.566     0.200
     7.456   144.955     0.200
     9.651   184.039     0.200
     3.224    61.429     0.200
     3.224    62.429     0.200
     3.957    77.481     0.200
     4.261    83.232     0.200
     4.245    81.119     0.200
     4.245    82.320     0.200
     4.384    84.891     0.200
     4.817    92.640     0.200
     5.120    99.102     0.200
     5.210   101.356     0.200
     5.666   110.233     0.200
     6.296   121.284     0.200
     6.386   122.327     0.200
     6.386   122.827     0.200
     6.670   128.616     0.200
     7.587   146.213     0.200
     9.622   184.869     0.200
     2.299    42.787     0.200
     2.451    46.508     0.200
     2.451    46.808     0.200
     2.506    49.165     0.200
     2.506    47.963     0.200
     3.243    60.662     0.200
     3.243    61.361     0.200
     3.915    76.718     0.200
     3.915    74.917     0.200
     4.211    81.670     0.200
     4.211    81.272     0.200
     4.274    81.633     0.200
     4.403    83.223     0.200
     4.400    83.267     0.200
     4.830    93.250     0.200
     5.130    98.050     0.200
     5.158    99.313     0.200
     5.158    99.714     0.200
     5.687   107.550     0.200
     6.319   120.563     0.200
     6.319   119.963     0.200
     6.699   128.137     0.200
     2.314    43.424     0.200
     2.506    47.987     0.200
     2.506    48.690     0.200
     3.158    61.875     0.200
     3.224    61.514     0.200
     3.953    77.193     0.200
     3.953    76.693     0.200
     4.238    82.973     0.200
     4.238    81.575     0.200
     4.259    83.724     0.200
     4.389    84.005     0.200
     4.384    83.273     0.200
     4.384    82.671     0.200
     4.815    93.233     0.200
     5.118    99.403     0.200
     5.204   100.305     0.200
     5.621   108.736     0.200
     5.621   108.439     0.200
     5.666   109.515     0.200
     6.296   119.060     0.200
     6.380   125.572     0.200
     6.380   123.173     0.200
     6.671   129.377     0.200
     7.439   144.417     0.200
     7.439   140.917     0.200
     7.589   146.658     0.200
     8.497   162.470     0.200
    16.351   322.993     0.200
    20.191   401.044     0.200
     2.301    43.337     0.200
     2.462    47.865     0.200
     2.462    47.263     0.200
     2.509    48.616     0.200
     2.509    48.913     0.200
     3.239    61.484     0.200
     3.926    75.179     0.200
     3.926    78.077     0.200
     4.221    82.230     0.200
     4.272    83.936     0.200
     4.400    83.649     0.200
     4.400    82.751     0.200
     4.399    84.852     0.200
     4.828    93.451     0.200
     4.862    93.255     0.200
     4.862    93.356     0.200
     5.172    99.132     0.200
     5.172    99.327     0.200
     5.129    99.244     0.200
     5.640   108.576     0.200
     5.682   108.781     0.200
     6.314   120.703     0.200
     6.370   124.849     0.200
     6.692   128.591     0.200
     7.455   144.097     0.200
     7.455   142.292     0.200
     7.533   145.688     0.200
     7.615   146.228     0.200
     8.471   165.164     0.200
    20.219   403.119     0.200
     3.206    61.734     0.200
     3.206    60.937     0.200
     3.980    76.493     0.200
     3.980    78.895     0.200
     4.250    81.751     0.200
     4.366    83.900     0.200
     4.366    83.498     0.200
     4.377    84.473     0.200
     4.801    91.521     0.200
     5.105    98.067     0.200
     5.232   101.384     0.200
     5.232   100.287     0.200
     5.600   108.894     0.200
     5.647   108.447     0.200
     6.276   118.612     0.200
     6.386   123.019     0.200
     6.386   124.219     0.200
     6.649   128.958     0.200
     6.649   128.657     0.200
     7.421   143.647     0.200
     7.421   141.046     0.200
     7.487   144.272     0.200
     7.564   145.977     0.200
     8.517   167.747     0.200
    15.301   305.914     0.200
     2.443    47.364     0.200
     2.500    48.891     0.200
     2.500    47.696     0.200
     3.164    62.352     0.200
     3.243    61.719     0.200
     3.908    74.266     0.200
     3.908    76.165     0.200
     4.198    82.179     0.200
     4.198    80.281     0.200
     4.273    83.210     0.200
     4.404    83.681     0.200
     4.397    84.564     0.200
     4.828    92.637     0.200
     5.146    99.221     0.200
     5.146    99.323     0.200
     5.687   108.608     0.200
     6.321   120.211     0.200
     6.321   119.507     0.200
     6.351   122.452     0.200
     6.702   129.564     0.200
     7.459   143.629     0.200
     7.544   146.035     0.200
     7.597   147.216     0.200
     9.670   185.823     0.200
     2.499    46.512     0.200
     2.659    50.944     0.200
     2.659    50.741     0.200
     3.082    60.515     0.200
     3.082    60.312     0.200
     3.326    64.862     0.200
     3.326    63.260     0.200
     3.489    68.853     0.200
     3.854    73.802     0.200
     3.825    75.138     0.200
     3.825    74.841     0.200
     4.686    89.787     0.200
     4.683    91.230     0.200
     4.956    94.736     0.200
     4.956    93.936     0.200
     5.198   100.518     0.200
     5.246   103.750     0.200
     5.405   106.304     0.200
     5.689   110.179     0.200
     6.234   122.025     0.200
     6.234   117.826     0.200
     6.300   119.554     0.200
     6.939   135.298     0.200
     7.436   141.797     0.200
     7.436   141.297     0.200
     7.940   154.013     0.200
     8.326   159.707     0.200
     8.497   165.183     0.200
     8.564   163.630     0.200
     2.126    39.036     0.200
     2.860    55.477     0.200
     2.934    56.115     0.200
     3.696    71.420     0.200
     3.696    71.920     0.200
     3.871    75.980     0.200
     3.871    75.680     0.200
     3.747    73.525     0.200
     4.938    97.224     0.200
     4.958    96.290     0.200
     5.181    97.691     0.200
     5.181    98.491     0.200
     5.461   106.420     0.200
     5.686   111.000     0.200
     6.062   117.408     0.200
     6.062   117.208     0.200
     6.466   123.692     0.200
     6.466   123.393     0.200
     7.158   134.922     0.200
     8.191   161.358     0.200
     8.507   164.471     0.200
     8.701   168.412     0.200
     9.059   178.627     0.200
     2.611    51.566     0.200
     3.253    62.378     0.200
     3.861    75.682     0.200
     4.027    78.947     0.200
     4.328    83.433     0.200
     5.274   102.691     0.200
     5.465   105.070     0.200
     6.004   116.174     0.200
     6.405   124.704     0.200
     6.753   131.230     0.200
     7.435   144.378     0.200
     2.466    48.093     0.200
     2.466    48.792     0.200
     2.499    49.101     0.200
     2.499    48.902     0.200
     3.232    63.261     0.200
     3.930    75.304     0.200
     3.930    76.304     0.200
     4.214    81.197     0.200
     4.214    81.596     0.200
     4.263    83.015     0.200
     4.392    84.222     0.200
     4.392    84.422     0.200
     4.390    84.739     0.200
     5.120    98.322     0.200
     5.172   100.409     0.200
     5.172   100.909     0.200
     5.674   107.950     0.200
     6.307   119.970     0.200
     6.307   120.669     0.200
     6.362   121.831     0.200
     6.362   122.331     0.200
     6.685   127.554     0.200
     7.447   145.467     0.200
     7.526   142.241     0.200
     7.609   145.171     0.200
     9.648   185.082     0.200
     2.459    45.933     0.200
     2.783    54.653     0.200
     2.783    52.751     0.200
     2.954    57.348     0.200
     2.954    57.247     0.200
     3.358    64.230     0.200
     3.616    71.131     0.200
     3.702    71.426     0.200
     3.702    71.324     0.200
     3.987    76.499     0.200
     3.987    76.299     0.200
     4.804    93.560     0.200
     5.087    96.560     0.200
     5.087    96.162     0.200
     5.322   104.415     0.200
     5.371   105.142     0.200
     5.525   108.152     0.200
     5.738   110.360     0.200
     5.986   116.670     0.200
     6.363   123.164     0.200
     6.432   122.262     0.200
     7.070   133.918     0.200
     7.070   134.820     0.200
     7.569   145.190     0.200
     7.569   143.991     0.200
     8.066   153.089     0.200
     8.460   161.893     0.200
     8.700   167.601     0.200
     2.105    39.046     0.200
     2.679    52.545     0.200
     3.355    66.358     0.200
     3.441    66.149     0.200
     3.735    72.322     0.200
     3.992    77.728     0.200
     4.287    84.276     0.200
     4.601    88.111     0.200
     4.589    87.556     0.200
     5.045    98.931     0.200
     5.045    98.130     0.200
     5.320   103.228     0.200
     6.476   126.138     0.200
     6.897   132.921     0.200
     7.737   148.721     0.200
     7.814   148.420     0.200
     2.371    44.233     0.200
     2.371    44.335     0.200
     3.108    60.926     0.200
     3.165    61.365     0.200
     3.740    72.652     0.200
     4.019    78.900     0.200
     4.019    78.501     0.200
     4.237    82.355     0.200
     4.237    82.254     0.200
     4.325    82.726     0.200
     4.338    82.776     0.200
     5.066    98.072     0.200
     5.257   102.544     0.200
     5.257   102.341     0.200
     5.559   106.826     0.200
     5.606   107.173     0.200
     6.364   122.922     0.200
     6.364   123.126     0.200
     6.607   127.089     0.200
     6.607   124.393     0.200
     7.380   140.973     0.200
     7.446   143.303     0.200
     2.332    42.701     0.200
     3.366    64.236     0.200
     4.094    80.131     0.200
     4.297    83.570     0.200
     4.364    85.485     0.200
     5.513   105.381     0.200
     5.853   115.006     0.200
     6.106   118.858     0.200
     6.657   130.128     0.200
     7.893   153.200     0.200
     8.872   172.173     0.200
     2.357    43.748     0.200
     2.357    44.146     0.200
     2.352    46.007     0.200
     2.352    44.007     0.200
     2.801    53.558     0.200
     2.801    54.058     0.200
     2.948    56.152     0.200
     2.948    56.351     0.200
     3.463    67.141     0.200
     3.628    70.715     0.200
     3.628    74.414     0.200
     3.782    74.409     0.200
     3.782    73.808     0.200
     3.977    75.343     0.200
     4.261    81.720     0.200
     4.826    93.534     0.200
     5.086    96.293     0.200
     2.838    55.950     0.200
     2.838    55.450     0.200
     3.128    61.964     0.200
     3.566    69.861     0.200
     3.566    69.963     0.200
     3.494    67.199     0.200
     3.494    67.301     0.200
     4.086    79.595     0.200
     4.086    80.197     0.200
     4.384    86.413     0.200
     4.694    91.597     0.200
     4.694    91.894     0.200
     5.021    98.675     0.200
     5.576   110.298     0.200
     5.591   108.829     0.200
     5.820   112.850     0.200
     5.820   113.049     0.200
     5.844   113.469     0.200
     5.762   111.836     0.200
     5.786   113.947     0.200
     6.144   121.770     0.200
     6.193   122.204     0.200
     6.409   123.084     0.200
     7.106   136.650     0.200
     7.796   148.269     0.200
     8.830   172.624     0.200
     8.830   173.026     0.200
     9.138   176.633     0.200
     9.313   180.791     0.200
     9.646   190.246     0.200
    11.400   218.138     0.200
    17.129   335.000     0.200
     2.544    49.599     0.200
     3.211    63.524     0.200
     3.292    63.074     0.200
     3.866    74.584     0.200
     3.866    75.178     0.200
     4.220    81.546     0.200
     4.321    82.867     0.200
     4.452    86.434     0.200
     4.444    85.834     0.200
     4.756    91.591     0.200
     4.797    92.617     0.200
     5.121    99.934     0.200
     6.369   120.364     0.200
     6.382   124.120     0.200
     7.675   145.326     0.200
     2.484    49.081     0.200
     2.484    48.979     0.200
     3.143    61.996     0.200
     3.217    61.921     0.200
     3.939    75.995     0.200
     3.939    76.096     0.200
     4.249    82.385     0.200
     4.378    83.687     0.200
     4.375    85.309     0.200
     4.689    91.151     0.200
     4.870    94.737     0.200
     5.174    99.791     0.200
     5.619   108.700     0.200
     6.293   119.626     0.200
     6.293   119.423     0.200
     6.348   123.592     0.200
     6.673   127.598     0.200
     6.673   127.700     0.200
     7.433   141.534     0.200
     7.514   143.381     0.200
     7.599   145.891     0.200
     2.325    43.085     0.200
     3.187    61.927     0.200
     3.961    76.684     0.200
     4.032    78.659     0.200
     4.243    81.894     0.200
     5.383   103.299     0.200
     5.474   106.430     0.200
     5.696   110.644     0.200
     5.935   116.546     0.200
     6.398   123.051     0.200
     7.350   142.539     0.200
     8.818   170.111     0.200
     2.233    43.727     0.200
     2.844    55.000     0.200
     2.844    55.599     0.200
     3.010    58.559     0.200
     3.751    70.914     0.200
     3.811    74.019     0.200
     3.868    75.553     0.200
     3.982    77.515     0.200
     3.982    75.816     0.200
     4.087    77.394     0.200
     4.087    78.394     0.200
     5.222    99.151     0.200
     5.222   100.151     0.200
     5.297   101.868     0.200
     5.525   107.512     0.200
     6.538   124.990     0.200
     8.520   164.760     0.200
     8.690   165.781     0.200
     9.172   182.376     0.200
    16.550   323.080     0.200
    20.844   413.393     0.200
     2.296    42.815     0.200
     3.291    62.703     0.200
     3.291    64.003     0.200
     3.625    71.603     0.200
     4.072    78.990     0.200
     4.082    79.172     0.200
     4.082    79.572     0.200
     4.218    83.188     0.200
     4.218    83.988     0.200
     4.301    82.215     0.200
     4.301    82.615     0.200
     5.448   103.631     0.200
     5.448   104.231     0.200
     5.577   108.418     0.200
     5.783   112.221     0.200
     5.825   113.226     0.200
     6.033   117.502     0.200
     6.310   122.874     0.200
     6.308   121.689     0.200
     6.413   124.571     0.200
     6.576   129.168     0.200
     6.738   128.676     0.200
     6.745   130.196     0.200
     6.745   129.496     0.200
     7.407   140.078     0.200
     7.407   142.468     0.200
     7.836   150.962     0.200
     7.836   149.762     0.200
     8.486   165.873     0.200
     8.486   164.373     0.200
     8.697   168.211     0.200
     8.826   171.410     0.200
     9.487   189.371     0.200
    21.119   428.593     0.200
    21.345   430.288     0.200
     2.571    51.310     0.200
     2.776    52.817     0.200
     2.727    52.585     0.200
     2.885    54.542     0.200
     3.675    69.723     0.200
     3.710    74.018     0.200
     3.881    73.924     0.200
     3.881    73.627     0.200
     4.111    79.637     0.200
     4.247    82.952     0.200
     4.297    83.467     0.200
     4.541    87.223     0.200
     5.166   100.822     0.200
     5.166    99.624     0.200
     5.166    97.820     0.200
     5.170    99.475     0.200
     5.758   110.817     0.200
     5.758   111.410     0.200
     5.831   111.168     0.200
     5.831   109.770     0.200
     6.007   115.317     0.200
     6.257   119.391     0.200
     6.929   135.347     0.200
     7.123   137.488     0.200
     7.123   134.988     0.200
     8.139   163.078     0.200
    15.278   301.817     0.200
    17.428   345.351     0.200
    19.998   397.613     0.200
    20.090   396.535     0.200
    21.246   425.919     0.200
    21.246   425.918     0.200
    26.882   529.985     0.200
     2.107    39.437     0.200
     2.663    51.542     0.200
     3.360    63.510     0.200
     3.349    65.341     0.200
     3.698    71.365     0.200
     3.698    71.565     0.200
     4.240    81.947     0.200
     4.609    86.337     0.200
     4.630    89.590     0.200
     4.892    94.431     0.200
     4.990    96.394     0.200
     5.058    97.392     0.200
     5.894   112.141     0.200
     6.436   122.715     0.200
     6.531   123.402     0.200
     3.303    64.114     0.200
     3.605    70.782     0.200
     4.062    79.651     0.200
     4.062    79.253     0.200
     4.216    84.159     0.200
     4.317    83.477     0.200
     4.498    87.867     0.200
     5.260   102.775     0.200
     5.463   105.299     0.200
     5.590   108.426     0.200
     5.839   113.514     0.200
     6.046   118.302     0.200
     6.289   122.861     0.200
     6.753   131.346     0.200
     7.423   142.928     0.200
     7.853   151.511     0.200
     8.501   164.149     0.200
     8.715   169.454     0.200
     8.845   167.536     0.200
     8.845   171.536     0.200
     2.289    44.273     0.200
     2.742    53.583     0.200
     2.742    53.482     0.200
     3.158    60.729     0.200
     3.158    60.326     0.200
     3.658    69.988     0.200
     4.026    79.300     0.200
     3.992    78.991     0.200
     4.210    81.953     0.200
     4.210    78.852     0.200
     4.531    87.003     0.200
     5.133   100.483     0.200
     5.350   102.849     0.200
     5.446   105.032     0.200
     5.906   115.657     0.200
     6.387   125.139     0.200
     6.310   123.240     0.200
     6.659   129.374     0.200
     7.317   139.998     0.200
     7.761   149.712     0.200
     8.380   162.093     0.200
     8.629   167.679     0.200
     8.782   170.099     0.200
     3.314    64.962     0.200
     3.438    67.218     0.200
     3.774    74.104     0.200
     3.774    73.701     0.200
     4.026    78.252     0.200
     4.026    77.955     0.200
     4.304    84.012     0.200
     4.405    85.136     0.200
     4.405    84.038     0.200
     5.308   105.092     0.200
     5.538   106.308     0.200
     5.881   115.212     0.200
     6.066   119.248     0.200
     6.102   118.733     0.200
     6.148   120.193     0.200
     6.413   124.901     0.200
     6.413   124.604     0.200
     6.826   132.480     0.200
     6.856   131.230     0.200
     6.856   132.332     0.200
     6.856   132.730     0.200
     7.510   142.188     0.200
     7.510   144.594     0.200
     7.621   145.898     0.200
     7.621   150.199     0.200
     7.965   151.690     0.200
     8.559   164.953     0.200
     8.837   170.009     0.200
     9.002   172.491     0.200
     9.227   180.556     0.200
    17.806   347.026     0.200
    20.415   399.594     0.200
     3.299    64.345     0.200
     3.299    62.938     0.200
     3.609    71.424     0.200
     4.081    79.013     0.200
     4.064    79.613     0.200
     4.064    79.113     0.200
     4.213    82.470     0.200
     4.213    84.470     0.200
     4.313    82.206     0.200
     4.313    82.104     0.200
     4.725    92.498     0.200
     5.256   101.507     0.200
     5.459   103.930     0.200
     5.459   103.133     0.200
     5.835   115.441     0.200
     5.867   114.571     0.200
     6.042   117.733     0.200
     6.370   123.700     0.200
     6.292   123.015     0.200
     6.574   128.528     0.200
     6.749   129.274     0.200
     6.757   130.181     0.200
     7.419   141.855     0.200
     7.849   151.141     0.200
     8.497   166.182     0.200
     8.711   167.381     0.200
     8.711   167.780     0.200
     8.841   170.364     0.200
     2.808    54.058     0.200
     2.808    53.957     0.200
     3.466    66.374     0.200
     3.466    66.171     0.200
     3.651    69.920     0.200
     3.651    69.619     0.200
     4.239    82.653     0.200
     4.239    82.056     0.200
     4.398    83.798     0.200
     4.655    91.294     0.200
     4.757    91.210     0.200
     4.790    92.824     0.200
     4.790    92.523     0.200
     4.809    91.798     0.200
     4.809    90.099     0.200
     5.058    97.993     0.200
     5.243   101.734     0.200
     5.255   101.101     0.200
     5.299   100.987     0.200
     5.727   110.085     0.200
     6.096   116.976     0.200
     6.322   120.251     0.200
     6.480   125.404     0.200
     6.741   128.455     0.200
     7.092   136.658     0.200
     7.134   135.568     0.200
     7.863   150.266     0.200
     7.981   152.888     0.200
     8.073   155.507     0.200
     9.068   178.858     0.200
    10.737   203.796     0.200
    13.735   266.382     0.200
     2.346    46.413     0.200
     2.704    53.144     0.200
     2.704    52.843     0.200
     3.161    60.404     0.200
     3.161    62.603     0.200
     3.161    60.505     0.200
     3.518    65.734     0.200
     3.615    69.605     0.200
     3.915    76.503     0.200
     3.973    77.731     0.200
     4.234    80.983     0.200
     4.234    81.581     0.200
     4.481    86.605     0.200
     5.146   101.041     0.200
     5.181   101.728     0.200
     5.370   103.320     0.200
     5.370   101.523     0.200
     5.448   105.616     0.200
     5.720   111.737     0.200
     6.275   121.961     0.200
     6.342   122.981     0.200
     6.659   129.285     0.200
     6.898   132.597     0.200
     7.340   140.831     0.200
     7.669   149.203     0.200
     7.791   148.771     0.200
     8.395   161.223     0.200
     8.663   168.201     0.200
     8.824   170.511     0.200
     9.102   179.072     0.200
    12.870   247.882     0.200
     2.717    52.937     0.200
     2.717    52.241     0.200
     3.398    64.989     0.200
     3.478    67.356     0.200
     3.440    67.198     0.200
     3.591    69.543     0.200
     4.083    78.698     0.200
     4.124    78.316     0.200
     4.124    82.909     0.200
     4.406    85.525     0.200
     4.583    87.856     0.200
     4.737    93.660     0.200
     4.737    91.957     0.200
     4.677    90.262     0.200
     4.747    91.340     0.200
     4.747    89.543     0.200
     4.975    96.386     0.200
     5.298   101.520     0.200
     5.170    99.703     0.200
     5.410   104.501     0.200
     6.018   115.315     0.200
     6.036   115.201     0.200
     6.263   119.047     0.200
     6.687   127.311     0.200
     6.687   127.209     0.200
     7.089   137.112     0.200
     7.799   151.127     0.200
     8.050   155.092     0.200
    10.325   200.748     0.200
     2.268    42.402     0.200
     2.268    43.601     0.200
     2.790    53.912     0.200
     2.790    53.509     0.200
     3.078    58.942     0.200
     3.078    58.841     0.200
     3.547    67.167     0.200
     3.700    71.383     0.200
     3.877    74.426     0.200
     3.931    76.396     0.200
     3.972    77.509     0.200
     3.972    77.708     0.200
     4.147    79.166     0.200
     4.147    79.366     0.200
     4.519    87.933     0.200
     4.564    87.111     0.200
     5.284   100.703     0.200
     5.828   113.750     0.200
     6.291   121.450     0.200
     6.336   123.027     0.200
     6.390   124.190     0.200
     6.572   127.268     0.200
     6.598   127.472     0.200
     7.254   139.819     0.200
     7.673   150.423     0.200
     7.705   145.057     0.200
     8.576   163.184     0.200
     8.739   166.578     0.200
     9.029   174.703     0.200
     9.243   183.740     0.200
    12.922   252.937     0.200
     2.711    52.297     0.200
     2.711    51.997     0.200
     3.339    63.870     0.200
     3.410    66.349     0.200
     3.525    69.005     0.200
     3.604    68.876     0.200
     3.604    68.976     0.200
     4.050    78.380     0.200
     4.226    80.919     0.200
     4.226    83.919     0.200
     4.226    83.719     0.200
     4.537    87.089     0.200
     4.536    87.406     0.200
     4.646    89.020     0.200
     4.684    89.576     0.200
     4.684    90.377     0.200
     4.902    94.928     0.200
     4.902    94.628     0.200
     4.951    95.562     0.200
     5.126    99.020     0.200
     5.134    99.920     0.200
     5.435   103.208     0.200
     5.603   107.357     0.200
     5.939   111.931     0.200
     5.970   115.266     0.200
     8.974   176.308     0.200
    13.841   271.322     0.200
    15.647   309.184     0.200
    17.151   332.789     0.200
    17.466   346.200     0.200
     3.478    67.123     0.200
     3.818    72.547     0.200
     3.932    76.922     0.200
     4.101    79.154     0.200
     4.075    79.355     0.200
     4.109    79.155     0.200
     4.109    78.856     0.200
     4.514    86.131     0.200
     4.550    90.111     0.200
     4.558    88.420     0.200
     4.806    94.320     0.200
     5.027    96.341     0.200
     5.173   102.241     0.200
     5.173   101.641     0.200
     5.372   103.614     0.200
     5.372   102.313     0.200
     5.396   104.335     0.200
     5.622   106.404     0.200
     5.895   112.816     0.200
     6.045   117.259     0.200
     6.045   115.259     0.200
     6.042   116.194     0.200
     6.042   114.063     0.200
     7.421   142.501     0.200
     8.425   164.803     0.200
    11.437   214.691     0.200
    14.053   273.584     0.200
    15.292   298.596     0.200
    17.319   334.542     0.200
     2.615    49.211     0.200
     3.479    67.824     0.200
     3.819    73.962     0.200
     3.929    77.771     0.200
     4.097    79.517     0.200
     4.076    79.556     0.200
     4.111    79.546     0.200
     4.385    84.953     0.200
     4.516    86.428     0.200
     4.808    93.221     0.200
     5.168   101.812     0.200
     5.168   100.913     0.200
     5.399   103.725     0.200
     5.624   108.492     0.200
     6.045   115.880     0.200
     6.045   114.650     0.200
     6.044   118.096     0.200
     6.448   122.981     0.200
     7.301   140.618     0.200
     7.425   142.576     0.200
     8.426   167.094     0.200
    11.434   216.040     0.200
    14.049   274.230     0.200
    15.297   302.118     0.200
    17.322   336.576     0.200
    17.680   345.158     0.200
     2.769    53.690     0.200
     3.318    63.284     0.200
     3.480    67.985     0.200
     3.500    67.449     0.200
     3.610    70.265     0.200
     4.215    81.901     0.200
     4.431    85.185     0.200
     4.615    89.645     0.200
     4.769    91.847     0.200
     4.807    93.601     0.200
     5.018    97.436     0.200
     5.330   102.389     0.200
     5.449   104.803     0.200
     5.687   108.830     0.200
     6.281   120.696     0.200
     6.701   127.597     0.200
     7.095   136.395     0.200
     7.119   138.323     0.200
     7.822   150.714     0.200
     7.942   152.315     0.200
     8.037   155.303     0.200
    10.078   193.688     0.200
     3.322    64.423     0.200
     3.464    65.073     0.200
     3.452    67.111     0.200
     3.452    69.211     0.200
     3.812    74.607     0.200
     4.062    80.390     0.200
     4.125    81.550     0.200
     4.323    84.948     0.200
     4.401    86.328     0.200
     5.311   103.311     0.200
     5.344   105.329     0.200
     5.537   106.672     0.200
     5.609   108.941     0.200
     5.840   111.741     0.200
     5.926   114.841     0.200
     6.073   117.716     0.200
     6.120   119.278     0.200
     6.442   125.114     0.200
     6.446   126.273     0.200
     7.065   138.147     0.200
     7.958   155.519     0.200
     8.829   169.856     0.200
    12.289   236.683     0.200
    12.464   241.639     0.200
     3.288    64.109     0.200
     3.480    67.068     0.200
     3.480    69.068     0.200
     3.486    65.706     0.200
     3.821    74.387     0.200
     4.034    78.906     0.200
     4.034    76.309     0.200
     4.092    79.134     0.200
     4.369    85.190     0.200
     4.369    83.690     0.200
     4.348    83.535     0.200
     5.505   106.542     0.200
     5.574   107.729     0.200
     6.039   116.701     0.200
     6.146   119.757     0.200
     6.409   124.488     0.200
     6.416   125.810     0.200
     6.416   123.810     0.200
     6.793   130.311     0.200
     6.820   130.391     0.200
     6.820   131.391     0.200
     7.032   134.614     0.200
     7.475   144.045     0.200
     7.475   143.014     0.200
     7.654   149.060     0.200
     7.927   151.771     0.200
     8.528   163.863     0.200
     8.799   169.500     0.200
     8.959   173.924     0.200
     9.432   187.324     0.200
    10.087   189.926     0.200
    11.039   211.253     0.200
    12.262   236.183     0.200
    12.780   250.887     0.200
     3.295    64.731     0.200
     3.477    65.717     0.200
     3.476    68.424     0.200
     3.824    74.665     0.200
     4.043    78.808     0.200
     4.098    78.562     0.200
     4.346    84.074     0.200
     4.375    85.335     0.200
     5.582   109.650     0.200
     6.047   117.030     0.200
     6.143   120.202     0.200
     6.415   123.626     0.200
     6.425   126.013     0.200
     6.799   131.947     0.200
     7.038   137.755     0.200
     7.481   145.486     0.200
     7.932   152.524     0.200
     8.534   164.795     0.200
     8.803   169.452     0.200
     8.963   173.892     0.200
     2.490    46.061     0.200
     3.300    65.010     0.200
     3.300    63.908     0.200
     3.464    68.585     0.200
     3.489    66.300     0.200
     3.806    75.403     0.200
     3.806    75.098     0.200
     4.035    79.330     0.200
     4.035    77.830     0.200
     4.104    80.521     0.200
     4.332    85.761     0.200
     4.383    84.066     0.200
     4.383    84.363     0.200
     5.290   103.581     0.200
     5.518   107.516     0.200
     5.518   104.720     0.200
     5.586   109.230     0.200
     5.864   112.791     0.200
     5.905   114.604     0.200
     6.130   119.979     0.200
     6.051   118.002     0.200
     6.418   125.320     0.200
     6.418   124.921     0.200
     6.806   131.290     0.200
     6.806   129.689     0.200
     6.834   131.262     0.200
     6.834   130.965     0.200
     7.046   135.494     0.200
     7.489   143.016     0.200
     7.489   142.070     0.200
     7.489   144.016     0.200
     7.646   149.992     0.200
     7.942   152.835     0.200
     8.541   166.743     0.200
     8.813   170.163     0.200
     8.975   174.176     0.200
     9.441   188.765     0.200
     9.466   189.919     0.200
    10.075   191.092     0.200
    12.278   236.834     0.200
    16.503   324.049     0.200
    16.784   332.754     0.200
    16.897   332.682     0.200
    20.434   396.725     0.200
    21.658   431.888     0.200
    25.758   520.318     0.200
     3.314    65.249     0.200
     3.314    65.147     0.200
     3.462    67.322     0.200
     3.464    65.104     0.200
     3.820    75.639     0.200
     4.059    78.550     0.200
     4.117    81.083     0.200
     4.392    84.667     0.200
     4.332    84.964     0.200
     5.302   101.340     0.200
     5.528   107.612     0.200
     5.600   109.066     0.200
     5.876   114.848     0.200
     6.129   120.291     0.200
     6.442   126.642     0.200
     6.442   122.947     0.200
     6.816   132.976     0.200
     7.056   136.880     0.200
     7.498   144.214     0.200
     7.949   152.862     0.200
     8.552   165.219     0.200
     8.820   170.295     0.200
     8.978   172.649     0.200
     9.459   186.455     0.200
    11.056   214.696     0.200
     3.313    64.551     0.200
     3.463    67.103     0.200
     3.462    67.515     0.200
     3.821    75.524     0.200
     3.821    74.227     0.200
     4.116    80.082     0.200
     4.333    84.546     0.200
     4.391    85.573     0.200
     5.302   103.449     0.200
     5.527   107.213     0.200
     5.600   108.470     0.200
     6.065   118.242     0.200
     6.130   119.178     0.200
     6.432   124.755     0.200
     6.442   126.538     0.200
     6.442   125.140     0.200
     6.816   130.679     0.200
     7.055   135.489     0.200
     7.498   143.519     0.200
     7.948   152.863     0.200
     8.819   169.304     0.200
     8.977   173.253     0.200
     3.305    63.530     0.200
     3.471    65.288     0.200
     3.469    67.916     0.200
     3.821    75.001     0.200
     4.051    79.324     0.200
     4.108    79.057     0.200
     4.339    83.962     0.200
     4.384    84.636     0.200
     4.749    92.674     0.200
     5.519   106.279     0.200
     5.591   109.945     0.200
     6.056   117.724     0.200
     6.136   118.489     0.200
     6.424   124.624     0.200
     6.433   124.920     0.200
     7.047   137.356     0.200
     7.490   143.587     0.200
     7.941   154.023     0.200
     8.543   166.792     0.200
     8.812   168.062     0.200
     8.971   172.903     0.200
    11.050   213.345     0.200
    12.448   241.124     0.200
     3.332    65.005     0.200
     3.332    64.704     0.200
     3.434    67.223     0.200
     3.475    65.741     0.200
     3.790    75.363     0.200
     3.790    74.066     0.200
     4.056    80.055     0.200
     4.137    80.615     0.200
     4.303    84.275     0.200
     4.416    85.857     0.200
     4.416    84.857     0.200
     4.778    93.036     0.200
     5.551   106.513     0.200
     5.618   109.929     0.200
     5.851   114.106     0.200
     6.082   118.021     0.200
     6.084   118.496     0.200
     6.100   118.603     0.200
     6.442   125.514     0.200
     6.455   124.660     0.200
     6.839   132.079     0.200
     6.867   131.756     0.200
     7.079   135.284     0.200
     7.522   144.712     0.200
     7.522   142.681     0.200
     7.650   147.515     0.200
     8.845   169.766     0.200
     9.006   172.792     0.200
     9.251   181.131     0.200
     9.472   187.358     0.200
    10.042   189.606     0.200
    11.085   212.228     0.200
    12.484   240.106     0.200
    12.750   250.126     0.200
    16.495   327.870     0.200
     2.018    37.727     0.200
     3.350    65.584     0.200
     3.412    66.664     0.200
     3.477    65.794     0.200
     3.770    73.780     0.200
     3.770    73.280     0.200
     4.155    80.785     0.200
     4.436    85.704     0.200
     4.436    85.602     0.200
     4.281    83.721     0.200
     4.796    92.806     0.200
     5.342   103.031     0.200
     5.571   107.564     0.200
     5.635   110.313     0.200
     5.870   113.475     0.200
     5.915   114.248     0.200
     5.957   116.560     0.200
     6.101   118.672     0.200
     6.078   118.247     0.200
     6.448   125.530     0.200
     6.448   123.530     0.200
     6.475   126.516     0.200
     6.859   133.734     0.200
     6.887   134.102     0.200
     7.099   136.335     0.200
     7.542   145.158     0.200
     7.641   146.703     0.200
     7.995   152.872     0.200
     8.593   165.498     0.200
     8.867   171.399     0.200
     9.028   175.921     0.200
    11.107   215.552     0.200
     2.502    46.833     0.200
     3.472    66.214     0.200
     3.321    64.774     0.200
     3.321    64.474     0.200
     3.449    67.083     0.200
     3.804    75.233     0.200
     3.804    75.033     0.200
     4.125    80.293     0.200
     4.402    84.554     0.200
     4.402    83.554     0.200
     4.319    83.330     0.200
     4.766    93.011     0.200
     5.311   103.951     0.200
     5.538   106.102     0.200
     5.607   109.294     0.200
     5.884   114.260     0.200
     5.925   114.480     0.200
     5.925   117.180     0.200
     6.072   117.566     0.200
     6.442   124.748     0.200
     6.826   132.070     0.200
     7.508   143.806     0.200
     7.960   151.937     0.200
     8.561   165.021     0.200
     8.831   170.271     0.200
     8.991   174.306     0.200
     9.243   179.863     0.200
     9.463   187.116     0.200
    10.054   191.103     0.200
    12.468   238.924     0.200
    17.769   343.339     0.200
    21.669   429.082     0.200
     3.235    62.699     0.200
     3.440    65.007     0.200
     3.571    70.774     0.200
     3.927    76.715     0.200
     4.032    78.903     0.200
     4.057    79.113     0.200
     4.295    82.927     0.200
     4.446    85.870     0.200
     4.674    91.000     0.200
     5.434   104.541     0.200
     5.828   112.239     0.200
     5.985   116.809     0.200
     6.242   121.408     0.200
     6.340   123.656     0.200
     6.427   126.245     0.200
     6.723   130.092     0.200
     6.961   134.315     0.200
     7.401   141.977     0.200
     7.847   151.176     0.200
     8.462   164.200     0.200
     8.716   167.537     0.200
     8.869   172.152     0.200
    10.944   212.241     0.200
     3.304    64.405     0.200
     3.304    64.206     0.200
     3.463    67.242     0.200
     3.810    74.999     0.200
     3.810    74.799     0.200
     4.042    78.594     0.200
     4.042    77.594     0.200
     4.386    84.777     0.200
     4.386    83.679     0.200
     4.332    83.806     0.200
     4.749    92.342     0.200
     5.521   106.630     0.200
     5.822   113.116     0.200
     5.867   115.290     0.200
     5.909   115.110     0.200
     6.055   117.398     0.200
     6.110   117.657     0.200
     6.130   119.428     0.200
     6.426   125.076     0.200
     6.425   124.383     0.200
     6.425   123.981     0.200
     6.809   132.098     0.200
     6.837   131.677     0.200
     6.837   130.977     0.200
     7.049   137.002     0.200
     7.492   141.928     0.200
     7.492   143.932     0.200
     7.944   152.657     0.200
     8.544   165.750     0.200
     8.815   170.586     0.200
     8.976   172.711     0.200
     9.446   186.666     0.200
    11.056   211.844     0.200
     2.850    55.383     0.200
     3.232    63.328     0.200
     3.392    63.657     0.200
     3.602    69.113     0.200
     3.791    74.403     0.200
     4.080    80.924     0.200
     4.157    80.328     0.200
     4.246    81.694     0.200
     4.492    87.319     0.200
     4.761    93.386     0.200
     4.943    95.054     0.200
     5.044    97.181     0.200
     5.126    98.927     0.200
     5.304   103.840     0.200
     5.345   104.272     0.200
     5.367   105.507     0.200
     5.570   107.738     0.200
     5.858   114.382     0.200
     6.228   119.463     0.200
     6.233   120.701     0.200
     6.368   124.532     0.200
     6.464   125.604     0.200
     6.894   131.195     0.200
     7.311   141.321     0.200
     7.990   154.804     0.200
     8.169   158.213     0.200
     8.292   159.177     0.200
    10.351   200.043     0.200
    10.558   203.931     0.200
    11.740   225.239     0.200
     2.484    45.437     0.200
     3.294    63.991     0.200
     3.470    68.028     0.200
     3.491    65.892     0.200
     3.810    74.867     0.200
     3.810    74.066     0.200
     4.031    79.481     0.200
     4.031    77.082     0.200
     4.098    80.906     0.200
     4.377    85.847     0.200
     4.377    85.648     0.200
     4.338    84.605     0.200
     4.739    92.722     0.200
     5.284   103.061     0.200
     5.512   105.700     0.200
     5.512   105.801     0.200
     5.580   108.711     0.200
     5.813   112.295     0.200
     5.858   113.669     0.200
     5.899   114.787     0.200
     6.115   118.066     0.200
     6.416   124.449     0.200
     6.414   125.375     0.200
     6.800   130.669     0.200
     6.828   132.644     0.200
     7.040   135.674     0.200
     7.483   143.199     0.200
     7.936   154.218     0.200
     8.535   166.527     0.200
     8.807   170.948     0.200
     8.969   174.561     0.200
     9.215   180.085     0.200
    11.050   212.981     0.200
    11.211   217.399     0.200
    12.769   250.015     0.200
    16.506   323.861     0.200
    16.779   328.699     0.200
    20.842   415.379     0.200
    21.618   431.875     0.200
     2.826    54.404     0.200
     2.826    55.802     0.200
     2.910    57.115     0.200
     3.372    64.625     0.200
     3.372    63.922     0.200
     3.659    70.975     0.200
     3.661    73.357     0.200
     4.032    78.519     0.200
     4.032    79.320     0.200
     4.128    78.108     0.200
     4.288    83.833     0.200
     4.556    89.216     0.200
     5.088    99.304     0.200
     5.132    97.792     0.200
     5.132    97.690     0.200
     5.365   104.464     0.200
     5.567   108.814     0.200
     5.757   111.493     0.200
     5.757   111.993     0.200
     6.017   116.265     0.200
     6.656   126.302     0.200
     7.115   136.648     0.200
     7.113   140.173     0.200
     7.615   145.111     0.200
     8.506   162.809     0.200
     8.625   167.722     0.200
     8.746   169.917     0.200
     8.858   174.917     0.200
     2.730    52.841     0.200
     3.150    60.433     0.200
     3.494    65.624     0.200
     3.947    77.731     0.200
     3.955    76.737     0.200
     3.991    77.219     0.200
     3.991    76.818     0.200
     4.214    80.524     0.200
     4.214    80.723     0.200
     4.512    86.344     0.200
     4.590    88.536     0.200
     5.352   102.343     0.200
     5.352   101.244     0.200
     5.438   105.339     0.200
     5.662   110.027     0.200
     5.900   114.846     0.200
     6.258   121.471     0.200
     6.288   121.812     0.200
     6.310   122.164     0.200
     6.879   131.922     0.200
     7.320   138.640     0.200
     7.320   139.770     0.200
     7.320   139.571     0.200
     8.638   165.989     0.200
     8.796   169.346     0.200
     9.316   185.428     0.200
    11.040   212.757     0.200
    12.276   236.734     0.200
    12.910   254.690     0.200
     2.459    48.182     0.200
     2.459    47.682     0.200
     2.544    49.291     0.200
     3.315    63.384     0.200
     3.455    66.853     0.200
     3.455    67.251     0.200
     3.851    75.338     0.200
     4.269    82.752     0.200
     4.221    82.811     0.200
     4.221    81.714     0.200
     4.251    82.863     0.200
     4.509    87.362     0.200
     4.894    93.864     0.200
     5.650   107.845     0.200
     5.743   110.960     0.200
     6.061   117.544     0.200
     6.059   117.168     0.200
     6.205   121.369     0.200
     7.615   145.897     0.200
     7.615   146.804     0.200
     8.680   168.578     0.200
     8.922   171.661     0.200
     9.063   174.410     0.200
     9.925   186.304     0.200
     9.615   190.198     0.200
    11.127   212.718     0.200
    11.319   217.483     0.200
    12.814   252.662     0.200
    16.592   330.355     0.200
     2.481    45.394     0.200
     3.290    64.353     0.200
     3.492    65.894     0.200
     3.812    74.471     0.200
     3.812    74.666     0.200
     4.029    78.129     0.200
     4.029    77.933     0.200
     4.094    80.272     0.200
     4.341    85.486     0.200
     4.374    84.912     0.200
     4.374    84.607     0.200
     4.736    92.587     0.200
     5.509   105.167     0.200
     5.509   103.565     0.200
     5.576   108.877     0.200
     5.809   112.161     0.200
     5.854   114.831     0.200
     6.118   119.155     0.200
     6.139   120.007     0.200
     6.413   125.514     0.200
     6.412   124.526     0.200
     6.412   123.424     0.200
     6.797   131.534     0.200
     6.825   132.209     0.200
     7.036   136.035     0.200
     7.480   144.065     0.200
     7.645   147.527     0.200
     7.932   151.782     0.200
     8.531   166.089     0.200
     8.804   170.610     0.200
     8.966   172.823     0.200
     9.212   178.846     0.200
    11.046   210.738     0.200
    11.207   215.560     0.200
    12.447   237.998     0.200
     2.499    49.255     0.200
     2.502    48.810     0.200
     3.424    65.760     0.200
     3.892    75.795     0.200
     4.217    82.498     0.200
     4.218    82.688     0.200
     4.315    83.863     0.200
     4.470    87.551     0.200
     4.860    93.496     0.200
     5.612   108.722     0.200
     5.711   110.864     0.200
     5.931   115.901     0.200
     5.975   116.290     0.200
     6.011   116.568     0.200
     6.106   118.254     0.200
     6.104   118.775     0.200
     6.172   119.285     0.200
     6.520   125.123     0.200
     6.598   129.010     0.200
     6.901   133.774     0.200
     7.138   138.411     0.200
     7.577   145.194     0.200
     8.015   154.677     0.200
     8.644   168.640     0.200
     8.880   172.081     0.200
     9.020   173.856     0.200
    11.083   212.278     0.200
    11.277   216.715     0.200
    12.469   239.999     0.200
     3.278    63.986     0.200
     3.495    65.849     0.200
     3.820    75.561     0.200
     4.023    78.092     0.200
     4.082    79.798     0.200
     4.361    84.544     0.200
     4.354    85.936     0.200
     4.723    90.723     0.200
     4.723    93.223     0.200
     5.496   104.705     0.200
     5.564   108.704     0.200
     5.797   113.094     0.200
     5.883   112.884     0.200
     6.030   117.377     0.200
     6.151   120.058     0.200
     6.400   124.051     0.200
     6.405   124.502     0.200
     6.784   130.470     0.200
     6.812   132.146     0.200
     7.024   136.276     0.200
     7.467   143.298     0.200
     7.920   149.923     0.200
     7.920   154.423     0.200
     8.519   164.523     0.200
     8.791   168.148     0.200
     8.953   172.953     0.200
    11.034   212.772     0.200
    12.435   237.630     0.200
     2.585    48.407     0.200
     3.367    65.186     0.200
     3.656    72.408     0.200
     3.656    72.107     0.200
     3.875    75.363     0.200
     4.057    78.134     0.200
     4.057    76.435     0.200
     4.056    78.945     0.200
     4.056    78.043     0.200
     4.420    85.693     0.200
     4.694    91.099     0.200
     4.971    95.971     0.200
     4.964    96.143     0.200
     4.991    98.634     0.200
     4.991    98.434     0.200
     5.579   106.264     0.200
     5.791   112.297     0.200
     5.814   112.525     0.200
     6.012   116.337     0.200
     6.012   116.016     0.200
     6.445   124.369     0.200
     7.102   137.996     0.200
     7.312   140.545     0.200
     7.478   145.110     0.200
     7.569   146.550     0.200
     9.714   187.818     0.200
    11.004   211.058     0.200
    11.489   217.676     0.200
     3.295    64.154     0.200
     3.492    66.553     0.200
     3.469    68.721     0.200
     3.808    75.164     0.200
     3.808    74.664     0.200
     4.031    78.262     0.200
     4.031    78.062     0.200
     4.099    79.766     0.200
     4.336    84.996     0.200
     4.378    84.905     0.200
     4.378    84.804     0.200
     5.285   102.320     0.200
     5.513   105.060     0.200
     5.513   103.961     0.200
     5.581   108.676     0.200
     5.814   112.457     0.200
     5.859   113.432     0.200
     5.900   114.448     0.200
     6.113   118.258     0.200
     6.418   124.509     0.200
     6.414   123.450     0.200
     6.801   131.630     0.200
     6.829   131.903     0.200
     6.829   131.303     0.200
     7.041   134.933     0.200
     7.484   142.059     0.200
     7.937   151.775     0.200
     8.536   164.388     0.200
     8.809   169.003     0.200
     8.971   172.914     0.200
     9.436   186.280     0.200
    11.051   211.234     0.200
    12.767   251.612     0.200
    16.504   326.605     0.200
    20.439   403.400     0.200
     3.447    68.050     0.200
     3.330    65.522     0.200
     3.330    65.022     0.200
     3.455    65.464     0.200
     3.814    75.372     0.200
     3.814    75.271     0.200
     4.071    79.667     0.200
     4.071    78.667     0.200
     4.319    83.774     0.200
     4.408    84.945     0.200
     4.408    85.047     0.200
     5.544   106.482     0.200
     5.544   104.685     0.200
     5.847   112.543     0.200
     5.892   113.325     0.200
     6.099   118.207     0.200
     6.116   118.713     0.200
     6.081   118.713     0.200
     6.455   125.756     0.200
     6.455   125.256     0.200
     6.449   123.328     0.200
     6.832   130.354     0.200
     6.858   132.646     0.200
     7.071   137.063     0.200
     7.514   143.492     0.200
     7.514   144.399     0.200
     7.964   152.942     0.200
     8.568   166.689     0.200
     8.835   169.283     0.200
     8.992   172.342     0.200
     9.475   184.154     0.200
    10.045   190.837     0.200
    11.237   217.350     0.200
    12.467   240.097     0.200
    16.520   326.714     0.200
    20.408   400.144     0.200
     2.357    43.450     0.200
     3.206    62.345     0.200
     3.465    65.318     0.200
     3.592    69.632     0.200
     3.929    76.399     0.200
     4.003    78.539     0.200
     4.028    77.846     0.200
     4.269    82.440     0.200
     4.464    86.360     0.200
     5.186   100.532     0.200
     5.407   102.855     0.200
     5.407   104.355     0.200
     5.717   109.835     0.200
     5.761   112.518     0.200
     5.955   115.955     0.200
     6.242   120.604     0.200
     6.313   122.080     0.200
     6.398   123.894     0.200
     6.398   122.496     0.200
     6.696   127.416     0.200
     6.718   129.453     0.200
     6.718   130.051     0.200
     7.375   140.088     0.200
     7.822   148.968     0.200
     7.822   148.570     0.200
     8.434   161.427     0.200
     8.692   167.321     0.200
     8.847   170.006     0.200
     9.369   186.643     0.200
    10.173   193.181     0.200
    16.608   329.368     0.200
    17.713   346.199     0.200
    20.544   403.082     0.200
    20.913   418.172     0.200
    21.493   430.927     0.200
    21.525   429.270     0.200
     2.360    44.052     0.200
     3.222    62.599     0.200
     3.222    62.700     0.200
     3.445    64.794     0.200
     4.018    77.806     0.200
     3.936    76.166     0.200
     3.936    76.869     0.200
     4.049    78.746     0.200
     4.281    82.938     0.200
     4.281    81.638     0.200
     4.459    85.464     0.200
     5.420   104.344     0.200
     5.420   102.645     0.200
     5.732   110.502     0.200
     5.776   111.987     0.200
     5.971   116.514     0.200
     6.326   122.264     0.200
     6.418   123.693     0.200
     6.418   123.794     0.200
     6.709   128.705     0.200
     6.730   131.354     0.200
     7.387   141.085     0.200
     7.833   150.885     0.200
     8.448   163.605     0.200
     8.448   163.206     0.200
     8.702   167.844     0.200
     8.855   169.756     0.200
     9.387   183.226     0.200
    10.158   194.998     0.200
    12.893   250.480     0.200
    16.619   327.004     0.200
     2.373    43.804     0.200
     2.373    44.007     0.200
     3.447    65.568     0.200
     3.924    77.009     0.200
     4.028    78.897     0.200
     4.049    78.844     0.200
     4.292    83.513     0.200
     4.292    83.615     0.200
     4.446    85.214     0.200
     5.210   101.491     0.200
     5.430   103.325     0.200
     5.430   103.224     0.200
     5.742   111.491     0.200
     5.980   116.912     0.200
     6.226   120.142     0.200
     6.337   123.447     0.200
     6.420   124.278     0.200
     6.420   123.977     0.200
     6.719   129.183     0.200
     6.741   129.428     0.200
     6.741   129.228     0.200
     7.398   140.059     0.200
     7.845   151.450     0.200
     8.458   164.087     0.200
     8.714   168.410     0.200
     8.867   170.916     0.200
     9.394   186.092     0.200
    16.609   330.022     0.200
     2.378    44.085     0.200
     3.242    62.695     0.200
     3.242    62.996     0.200
     3.435    64.946     0.200
     3.925    77.330     0.200
     3.925    76.431     0.200
     4.039    79.701     0.200
     4.062    77.931     0.200
     4.062    79.529     0.200
     4.062    79.829     0.200
     4.302    83.634     0.200
     4.302    83.431     0.200
     4.440    86.023     0.200
     5.222   103.099     0.200
     5.441   104.239     0.200
     5.753   112.198     0.200
     5.797   111.479     0.200
     5.835   114.240     0.200
     5.992   117.809     0.200
     6.221   120.140     0.200
     6.348   122.158     0.200
     6.348   124.658     0.200
     6.433   126.658     0.200
     6.730   130.497     0.200
     6.751   128.949     0.200
     7.409   144.176     0.200
     7.854   147.580     0.200
     7.854   150.682     0.200
     8.469   164.198     0.200
     8.723   168.642     0.200
     8.875   170.965     0.200
     9.407   186.398     0.200
    12.173   233.278     0.200
    12.883   250.760     0.200
    20.509   403.514     0.200
    20.931   417.693     0.200
     3.236    63.403     0.200
     3.450    65.901     0.200
     4.033    78.892     0.200
     3.915    75.981     0.200
     3.915    75.879     0.200
     4.048    79.221     0.200
     4.299    83.498     0.200
     4.437    87.382     0.200
     5.217   100.685     0.200
     5.437   105.509     0.200
     5.748   112.090     0.200
     5.830   113.625     0.200
     5.985   116.610     0.200
     6.343   122.534     0.200
     6.217   120.613     0.200
     6.420   126.444     0.200
     6.726   130.871     0.200
     6.748   128.411     0.200
     6.748   131.509     0.200
     7.405   142.244     0.200
     7.405   142.443     0.200
     7.852   150.828     0.200
     8.465   163.978     0.200
     8.721   168.786     0.200
     8.876   169.883     0.200
    10.952   207.757     0.200
    11.122   214.265     0.200
     3.252    63.595     0.200
     3.252    63.396     0.200
     3.438    65.028     0.200
     3.912    76.292     0.200
     3.912    75.893     0.200
     4.063    78.437     0.200
     4.063    79.734     0.200
     4.049    78.592     0.200
     4.314    83.008     0.200
     4.426    85.991     0.200
     5.232   101.185     0.200
     5.452   105.316     0.200
     5.763   111.287     0.200
     5.808   112.271     0.200
     5.846   112.825     0.200
     6.002   116.706     0.200
     6.207   120.313     0.200
     6.359   122.437     0.200
     6.435   124.749     0.200
     6.763   130.521     0.200
     7.420   143.151     0.200
     7.420   141.050     0.200
     7.866   149.846     0.200
     7.866   151.748     0.200
     8.480   164.082     0.200
     8.735   167.909     0.200
     8.888   171.220     0.200
     9.414   187.261     0.200
    10.963   210.705     0.200
    11.136   215.393     0.200
    12.360   237.710     0.200
    12.871   253.794     0.200
    16.603   329.468     0.200
     3.256    62.919     0.200
     3.256    62.817     0.200
     3.425    64.956     0.200
     3.922    76.647     0.200
     3.922    76.545     0.200
     4.053    78.724     0.200
     4.074    80.073     0.200
     4.315    83.168     0.200
     4.315    81.868     0.200
     4.430    85.119     0.200
     5.235   100.726     0.200
     5.454   105.070     0.200
     5.454   102.371     0.200
     5.767   111.722     0.200
     5.849   112.868     0.200
     6.006   117.033     0.200
     6.212   119.129     0.200
     6.361   123.691     0.200
     6.446   125.194     0.200
     6.446   123.893     0.200
     6.743   130.527     0.200
     7.866   152.222     0.200
     8.483   164.327     0.200
     8.734   167.787     0.200
     8.886   171.924     0.200
    11.135   215.880     0.200
     3.219    63.172     0.200
     3.453    65.037     0.200
     3.929    76.789     0.200
     4.016    77.672     0.200
     4.041    78.877     0.200
     4.280    83.087     0.200
     4.280    81.587     0.200
     4.456    86.138     0.200
     5.199   102.266     0.200
     5.419   102.799     0.200
     5.419   105.596     0.200
     5.419   102.498     0.200
     5.730   111.067     0.200
     5.774   112.750     0.200
     5.813   113.605     0.200
     5.969   116.183     0.200
     6.235   120.974     0.200
     6.325   122.119     0.200
     6.411   124.516     0.200
     6.411   122.419     0.200
     6.708   129.257     0.200
     6.730   129.599     0.200
     7.387   143.129     0.200
     7.833   150.124     0.200
     8.447   163.561     0.200
     8.703   167.578     0.200
     8.857   171.680     0.200
     9.383   186.264     0.200
    10.160   194.881     0.200
    11.104   214.461     0.200
    12.886   253.344     0.200
     3.214    62.416     0.200
     3.459    67.059     0.200
     3.927    77.898     0.200
     4.012    79.514     0.200
     4.035    79.033     0.200
     4.277    83.217     0.200
     4.457    86.310     0.200
     5.415   103.333     0.200
     5.415   105.134     0.200
     5.964   116.730     0.200
     6.405   125.079     0.200
     7.383   142.064     0.200
     9.377   187.707     0.200
    12.884   253.987     0.200
     3.241    63.024     0.200
     3.434    64.981     0.200
     3.927    76.120     0.200
     4.038    78.032     0.200
     4.063    78.641     0.200
     4.300    83.571     0.200
     4.442    84.914     0.200
     5.220   101.732     0.200
     5.439   104.175     0.200
     5.991   116.939     0.200
     6.223   119.230     0.200
     6.346   123.093     0.200
     6.434   125.371     0.200
     7.407   142.214     0.200
     7.852   151.519     0.200
     8.468   163.031     0.200
     8.721   167.984     0.200
     8.873   170.208     0.200
    10.947   209.698     0.200
     3.403    64.842     0.200
     3.984    75.171     0.200
     3.984    79.471     0.200
     3.984    75.770     0.200
     4.015    78.905     0.200
     4.084    78.298     0.200
     4.084    78.597     0.200
     4.268    83.246     0.200
     4.268    83.045     0.200
     5.195   101.531     0.200
     5.410   103.827     0.200
     5.410   103.625     0.200
     5.728   113.008     0.200
     5.772   114.200     0.200
     5.970   117.383     0.200
     6.449   124.899     0.200
     6.699   130.280     0.200
     6.717   129.875     0.200
     6.717   130.275     0.200
     7.375   141.233     0.200
     7.375   139.088     0.200
     8.441   162.849     0.200
     8.684   167.821     0.200
     8.831   170.804     0.200
     9.398   183.282     0.200
    10.902   209.735     0.200
    12.942   250.874     0.200
     2.074    38.722     0.200
     2.670    51.472     0.200
     2.670    51.269     0.200
     3.446    66.618     0.200
     3.502    66.766     0.200
     3.502    68.062     0.200
     3.396    65.096     0.200
     3.552    69.376     0.200
     4.039    77.897     0.200
     4.080    79.019     0.200
     4.080    78.714     0.200
     4.428    85.250     0.200
     4.541    88.230     0.200
     4.734    91.287     0.200
     4.734    90.584     0.200
     4.708    89.689     0.200
     4.930    95.099     0.200
     5.316   101.288     0.200
     5.128    99.386     0.200
     5.625   108.085     0.200
     5.981   113.426     0.200
     5.981   113.926     0.200
     5.997   114.343     0.200
     6.225   119.782     0.200
     6.319   120.286     0.200
     6.650   125.625     0.200
     7.109   136.966     0.200
     7.101   137.358     0.200
     7.910   152.620     0.200
     8.024   155.292     0.200
     8.927   176.068     0.200
    10.835   203.686     0.200
    13.667   269.159     0.200
    15.795   309.607     0.200
    17.284   338.558     0.200
    20.664   405.736     0.200
    21.262   413.845     0.200
    21.379   426.969     0.200
     2.861    55.287     0.200
     2.861    54.787     0.200
     3.245    62.403     0.200
     3.608    69.966     0.200
     3.790    74.841     0.200
     3.790    72.640     0.200
     4.172    81.188     0.200
     4.110    79.201     0.200
     4.110    81.602     0.200
     4.252    81.949     0.200
     4.522    88.101     0.200
     4.522    87.202     0.200
     4.765    93.170     0.200
     4.944    94.179     0.200
     4.944    92.780     0.200
     5.061    97.407     0.200
     5.309   101.912     0.200
     5.349   103.748     0.200
     5.577   107.985     0.200
     6.225   119.624     0.200
     6.225   119.224     0.200
     6.233   121.128     0.200
     6.394   124.950     0.200
     6.464   123.841     0.200
     6.853   132.093     0.200
     6.892   131.547     0.200
     6.892   131.746     0.200
     7.306   140.812     0.200
     7.306   138.411     0.200
     7.991   153.515     0.200
     8.086   155.403     0.200
     8.162   157.622     0.200
     8.280   160.040     0.200
     8.914   172.348     0.200
     9.105   180.801     0.200
    13.468   262.178     0.200
    16.035   315.356     0.200
    17.073   335.597     0.200
    17.126   334.962     0.200
    17.361   334.671     0.200
    19.107   381.189     0.200
    20.050   400.626     0.200
    21.019   412.945     0.200
    21.296   423.646     0.200
    26.085   525.631     0.200
     2.595    50.049     0.200
     2.595    49.049     0.200
     2.560    49.562     0.200
     2.560    49.663     0.200
     3.174    61.494     0.200
     3.174    61.393     0.200
     3.483    66.692     0.200
     3.767    70.576     0.200
     3.639    71.962     0.200
     3.773    74.208     0.200
     3.773    73.607     0.200
     3.995    78.213     0.200
     4.316    82.670     0.200
     4.320    84.316     0.200
     5.189   101.280     0.200
     5.440   104.848     0.200
     5.708   110.625     0.200
     5.755   112.175     0.200
     6.070   117.503     0.200
     6.118   119.037     0.200
     6.166   119.374     0.200
     6.336   122.394     0.200
     6.724   129.467     0.200
     6.772   131.604     0.200
     6.968   134.521     0.200
     7.419   142.655     0.200
     7.895   152.003     0.200
     8.443   164.100     0.200
     8.776   168.922     0.200
     8.973   172.823     0.200
     9.258   181.549     0.200
     9.282   185.780     0.200
    10.205   191.593     0.200
    11.189   214.957     0.200
    12.297   235.432     0.200
    12.586   244.910     0.200
    16.278   318.899     0.200
    17.134   333.404     0.200
     3.081    59.730     0.200
     3.183    61.842     0.200
     3.815    73.772     0.200
     3.915    76.604     0.200
     3.920    76.548     0.200
     3.994    76.980     0.200
     3.994    79.980     0.200
     4.192    81.872     0.200
     4.192    82.372     0.200
     4.051    78.217     0.200
     4.353    83.993     0.200
     4.470    86.026     0.200
     4.504    87.524     0.200
     4.508    86.884     0.200
     4.769    92.535     0.200
     4.936    95.184     0.200
     5.115    99.199     0.200
     4.970    95.795     0.200
     5.281   102.060     0.200
     5.281   102.861     0.200
     5.304   102.395     0.200
     5.304   101.997     0.200
     5.336   101.821     0.200
     5.559   105.518     0.200
     5.992   115.162     0.200
     5.976   113.447     0.200
     5.976   114.552     0.200
     6.083   118.497     0.200
     6.369   121.764     0.200
     7.331   139.931     0.200
     7.789   150.393     0.200
     8.130   159.717     0.200
     8.408   165.044     0.200
    11.500   217.799     0.200
    14.161   275.055     0.200
    17.248   330.584     0.200
    17.651   347.710     0.200
    19.965   396.902     0.200
    21.943   429.440     0.200
     2.450    47.484     0.200
     2.582    50.335     0.200
     3.401    65.782     0.200
     3.363    65.024     0.200
     3.456    64.740     0.200
     3.745    72.466     0.200
     4.094    80.390     0.200
     4.094    79.990     0.200
     4.207    82.277     0.200
     4.235    81.452     0.200
     4.488    86.301     0.200
     4.488    85.901     0.200
     4.599    89.900     0.200
     4.615    88.818     0.200
     4.848    93.499     0.200
     5.394   104.825     0.200
     5.622   108.257     0.200
     5.687   110.410     0.200
     5.921   114.968     0.200
     5.967   115.841     0.200
     6.031   117.086     0.200
     6.153   120.070     0.200
     6.526   126.308     0.200
     6.486   126.083     0.200
     6.910   133.727     0.200
     6.938   133.900     0.200
     7.150   138.430     0.200
     7.388   144.952     0.200
     7.594   146.755     0.200
     7.648   148.714     0.200
     8.645   166.790     0.200
     8.645   166.490     0.200
     8.917   172.109     0.200
     9.076   172.950     0.200
     9.534   185.388     0.200
     9.973   186.635     0.200
    12.707   248.950     0.200
    16.466   322.183     0.200
    16.821   323.065     0.200
    16.868   327.438     0.200
    17.781   340.115     0.200
    20.839   414.833     0.200
    21.351   427.650     0.200
     3.763    73.861     0.200
     3.800    73.928     0.200
     3.865    74.868     0.200
     3.865    75.172     0.200
     3.992    78.882     0.200
     3.992    78.586     0.200
     4.076    77.507     0.200
     4.076    78.906     0.200
     4.203    81.222     0.200
     4.442    86.336     0.200
     4.620    89.951     0.200
     4.985    96.999     0.200
     5.211    99.059     0.200
     5.211   100.559     0.200
     5.287   102.764     0.200
     5.514   106.217     0.200
     5.559   107.697     0.200
     5.599   108.026     0.200
     5.750   111.962     0.200
     6.015   116.370     0.200
     6.115   117.808     0.200
     6.220   119.878     0.200
     6.220   121.183     0.200
     6.420   124.649     0.200
     6.499   125.730     0.200
     6.527   125.506     0.200
     6.527   125.701     0.200
     6.738   129.232     0.200
     7.182   136.504     0.200
     7.182   138.465     0.200
     7.388   145.278     0.200
     7.641   147.701     0.200
     7.636   147.667     0.200
     8.234   158.678     0.200
     8.509   163.674     0.200
     8.678   167.900     0.200
     8.950   173.130     0.200
     9.164   180.373     0.200
    10.767   206.420     0.200
    16.539   323.368     0.200
    17.128   333.402     0.200
    20.847   414.712     0.200
    21.014   421.169     0.200
    21.335   421.526     0.200
     2.989    57.391     0.200
     3.788    73.661     0.200
     3.786    74.190     0.200
     3.879    74.998     0.200
     4.027    78.380     0.200
     4.027    78.880     0.200
     4.056    77.539     0.200
     4.178    81.514     0.200
     4.186    80.025     0.200
     4.428    86.396     0.200
     4.648    90.428     0.200
     5.192    99.577     0.200
     5.192    99.376     0.200
     5.276   102.597     0.200
     5.500   105.486     0.200
     5.544   107.869     0.200
     5.738   111.707     0.200
     6.098   117.012     0.200
     6.231   122.156     0.200
     6.231   121.557     0.200
     6.448   124.828     0.200
     6.481   123.740     0.200
     6.506   124.342     0.200
     6.720   128.654     0.200
     7.162   136.096     0.200
     7.162   137.290     0.200
     7.417   145.840     0.200
     7.614   146.020     0.200
     8.218   159.267     0.200
     8.486   163.546     0.200
     8.947   173.664     0.200
     9.159   178.296     0.200
    10.390   196.584     0.200
    10.739   206.649     0.200
    12.971   251.059     0.200
    20.877   416.445     0.200
    21.015   421.232     0.200
    21.306   425.900     0.200
    21.367   422.113     0.200
     3.104    60.078     0.200
     2.982    57.497     0.200
     2.982    57.997     0.200
     4.031    77.853     0.200
     3.929    75.047     0.200
     3.929    75.247     0.200
     4.153    80.027     0.200
     4.153    80.128     0.200
     4.419    84.927     0.200
     4.419    84.528     0.200
     4.924    94.938     0.200
     4.898    95.038     0.200
     5.082    97.097     0.200
     5.082    97.297     0.200
     5.260   101.317     0.200
     5.482   105.927     0.200
     5.706   110.912     0.200
     5.996   116.325     0.200
     6.366   122.411     0.200
     6.371   122.744     0.200
     6.715   129.639     0.200
     6.602   126.147     0.200
     7.448   144.082     0.200
     8.128   157.648     0.200
     8.304   161.187     0.200
     8.422   163.308     0.200
     9.023   175.402     0.200
     9.218   181.368     0.200
    13.372   260.596     0.200
    16.160   313.014     0.200
    16.977   330.216     0.200
    17.057   336.369     0.200
    17.375   331.004     0.200
    21.044   418.566     0.200
     2.910    55.832     0.200
     2.966    58.474     0.200
     3.806    73.976     0.200
     3.820    74.014     0.200
     3.761    74.097     0.200
     4.058    78.433     0.200
     4.058    77.132     0.200
     4.028    77.991     0.200
     4.028    78.091     0.200
     4.159    80.261     0.200
     4.681    90.069     0.200
     4.944    95.597     0.200
     5.165    99.217     0.200
     5.165    98.918     0.200
     5.254   102.978     0.200
     5.519   107.980     0.200
     5.715   111.798     0.200
     6.071   117.046     0.200
     6.228   120.417     0.200
     6.228   120.217     0.200
     6.454   124.079     0.200
     6.478   124.697     0.200
     6.478   125.297     0.200
     6.692   128.795     0.200
     7.134   134.583     0.200
     7.436   146.240     0.200
     8.192   159.592     0.200
     8.455   162.918     0.200
     8.620   166.797     0.200
     8.931   173.669     0.200
     9.142   180.502     0.200
    10.415   195.321     0.200
    13.002   252.180     0.200
    16.473   323.857     0.200
    17.133   334.542     0.200
    20.124   388.842     0.200
    21.002   420.897     0.200
    21.274   421.026     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.141    38.804     0.200
     0.478     9.823     0.200
     0.325     8.421     0.200
     1.302    25.419     0.200
     1.296    25.487     0.200
     3.068    54.301     0.200
     6.645   113.762     0.200
     1.218    25.354     0.200
     1.512    29.429     0.200
     2.205    43.633     0.200
     2.450    46.078     0.200
     2.679    53.206     0.200
     3.135    55.382     0.200
     4.132    77.447     0.200
     3.949    72.234     0.200
     2.477    45.931     0.200
     0.552    11.546     0.200
     0.545    11.422     0.200
     0.545    11.219     0.200
     0.783    15.748     0.200
     0.981    19.438     0.200
     0.989    19.134     0.200
     1.005    20.751     0.200
     1.017    20.015     0.200
     1.017    21.908     0.200
     1.297    25.854     0.200
     1.419    28.223     0.200
     1.419    27.621     0.200
     2.246    42.571     0.200
     2.285    45.617     0.200
     6.501   117.368     0.200
     1.926    37.421     0.200
     6.965   124.617     0.200
     0.202     6.943     0.200
     0.397     9.661     0.200
     0.541    11.586     0.200
     0.465    11.072     0.200
     0.592    12.596     0.200
     0.737    15.404     0.200
     0.743    15.945     0.200
     0.750    15.865     0.200
     2.298    45.095     0.200
     0.192     6.114     0.200
     0.558    12.739     0.200
     1.113    22.162     0.200
     0.127     2.440     0.200
     0.374     7.153     0.200
     0.899    17.932     0.200
     1.150    23.902     0.200
     1.150    23.504     0.200
     1.206    24.347     0.200
     2.165    41.855     0.200
     2.216    44.756     0.200
     2.218    43.937     0.200
     2.591    51.087     0.200
     0.026     3.913     0.200
     0.389     8.578     0.200
     0.910    19.003     0.200
     1.227    25.191     0.200
     1.288    25.879     0.200
     1.294    26.721     0.200
     1.294    25.518     0.200
     2.104    38.862     0.200
     0.150     5.332     0.200
     0.625    13.182     0.200
     1.177    23.741     0.200
     1.490    28.388     0.200
     1.724    32.865     0.200
     1.952    37.704     0.200
     2.432    46.492     0.200
     2.432    47.093     0.200
     0.167     6.517     0.200
     0.654    13.525     0.200
     0.862    17.105     0.200
     1.179    22.900     0.200
     1.719    33.104     0.200
     0.221     7.053     0.200
     0.163     5.331     0.200
     1.168    24.102     0.200
     1.135    23.383     0.200
     2.261    41.451     0.200
     0.222     6.722     0.200
     0.222     6.421     0.200
     0.416    10.465     0.200
     1.368    26.054     0.200
     1.368    26.654     0.200
     1.025    21.361     0.200
     1.025    21.160     0.200
     1.946    36.204     0.200
     0.115     3.893     0.200
     0.162     3.453     0.200
     0.558    11.934     0.200
     1.256    25.285     0.200
     1.355    27.229     0.200
     1.820    34.707     0.200
     1.820    35.207     0.200
     2.199    43.582     0.200
     0.175     5.141     0.200
     0.175     5.340     0.200
     0.483    11.156     0.200
     1.100    22.155     0.200
     1.100    22.553     0.200
     1.305    25.565     0.200
     1.305    25.765     0.200
     1.518    30.171     0.200
     2.206    41.040     0.200
     2.226    43.816     0.200
     0.046     3.166     0.200
     0.422     9.679     0.200
     0.422     9.879     0.200
     0.960    20.499     0.200
     0.982    20.240     0.200
     1.216    24.912     0.200
     1.216    24.711     0.200
     1.324    26.650     0.200
     1.324    27.051     0.200
     2.072    38.616     0.200
     2.201    42.920     0.200
     0.172     5.686     0.200
     0.216     5.576     0.200
     1.073    21.774     0.200
     1.073    20.875     0.200
     1.201    25.685     0.200
     1.217    24.698     0.200
     1.369    27.725     0.200
     1.369    26.425     0.200
     0.144     4.499     0.200
     0.261     6.733     0.200
     1.024    20.932     0.200
     1.147    23.291     0.200
     1.267    25.992     0.200
     1.415    27.970     0.200
     2.334    43.537     0.200
     2.334    44.037     0.200
     2.499    46.117     0.200
     0.178     5.113     0.200
     0.178     4.909     0.200
     0.236     5.944     0.200
     1.044    20.803     0.200
     1.044    21.202     0.200
     1.180    23.926     0.200
     1.414    27.890     0.200
     2.301    41.539     0.200
     2.301    42.140     0.200
     0.176     5.703     0.200
     0.224     6.649     0.200
     1.059    21.806     0.200
     1.170    23.610     0.200
     1.170    23.911     0.200
     1.217    25.765     0.200
     1.234    25.264     0.200
     1.393    27.709     0.200
     0.170     4.876     0.200
     0.170     4.675     0.200
     0.251     6.029     0.200
     0.251     5.828     0.200
     1.029    20.942     0.200
     1.175    24.740     0.200
     1.266    25.584     0.200
     1.426    29.212     0.200
     1.426    28.812     0.200
     2.313    43.563     0.200
     2.494    48.453     0.200
     2.494    48.853     0.200
     2.509    49.372     0.200
     2.509    49.872     0.200
     0.176     5.960     0.200
     0.215     6.399     0.200
     0.215     6.098     0.200
     1.071    21.908     0.200
     1.071    21.508     0.200
     1.160    23.871     0.200
     1.219    25.579     0.200
     1.374    27.272     0.200
     0.166     5.192     0.200
     0.248     6.331     0.200
     0.248     6.135     0.200
     1.033    21.378     0.200
     1.033    21.674     0.200
     1.170    22.977     0.200
     1.170    22.477     0.200
     1.261    25.312     0.200
     1.420    27.261     0.200
     1.420    27.863     0.200
     0.223     6.387     0.200
     0.223     6.286     0.200
     0.174     5.155     0.200
     1.061    21.613     0.200
     1.166    23.685     0.200
     1.166    24.084     0.200
     1.389    26.788     0.200
     1.389    27.889     0.200
     0.160     4.577     0.200
     0.160     4.377     0.200
     0.274     6.444     0.200
     1.171    24.382     0.200
     1.171    24.280     0.200
     1.290    26.794     0.200
     1.290    26.591     0.200
     1.447    28.855     0.200
     1.447    29.054     0.200
     2.330    43.753     0.200
     2.499    49.682     0.200
     2.499    49.280     0.200
     2.518    49.863     0.200
     0.175     5.029     0.200
     0.175     5.131     0.200
     0.212     5.404     0.200
     0.212     5.904     0.200
     1.152    23.434     0.200
     1.152    22.833     0.200
     1.361    27.390     0.200
     1.361    27.492     0.200
     2.300    42.931     0.200
     0.160     5.711     0.200
     1.292    25.600     0.200
     1.292    25.400     0.200
     1.436    28.519     0.200
     2.305    43.375     0.200
     2.305    43.777     0.200
     0.409     9.875     0.200
     0.409     9.975     0.200
     0.221     5.567     0.200
     0.221     6.167     0.200
     1.141    23.242     0.200
     1.141    22.742     0.200
     1.628    31.655     0.200
     2.126    40.236     0.200
     2.299    44.827     0.200
     4.056    75.515     0.200
     0.171     5.345     0.200
     0.171     5.040     0.200
     0.561    11.797     0.200
     1.184    23.631     0.200
     1.184    24.131     0.200
     1.485    28.704     0.200
     1.790    33.655     0.200
     1.913    37.617     0.200
     1.913    37.117     0.200
     2.428    47.302     0.200
     0.166     4.939     0.200
     0.229     6.495     0.200
     1.157    23.974     0.200
     1.157    23.571     0.200
     1.387    28.281     0.200
     2.309    43.423     0.200
     0.140     3.693     0.200
     1.380    27.818     0.200
     1.539    29.960     0.200
     1.539    29.761     0.200
     1.571    31.296     0.200
     1.571    30.894     0.200
     1.569    31.112     0.200
     2.428    46.589     0.200
     2.459    46.632     0.200
     0.040     3.943     0.200
     0.373     7.762     0.200
     1.062    22.217     0.200
     1.062    21.616     0.200
     1.312    27.600     0.200
     1.312    27.201     0.200
     1.293    26.720     0.200
     1.293    26.521     0.200
     2.105    40.445     0.200
     2.276    45.150     0.200
     0.131     3.874     0.200
     0.131     3.772     0.200
     0.314     8.034     0.200
     1.144    23.946     0.200
     1.144    22.946     0.200
     1.324    27.544     0.200
     1.469    29.862     0.200
     1.469    29.760     0.200
     2.465    49.031     0.200
     2.465    46.632     0.200
     2.555    50.183     0.200
     0.193     4.262     0.200
     0.822    17.118     0.200
     0.822    17.518     0.200
     1.055    21.901     0.200
     1.055    22.201     0.200
     1.402    28.252     0.200
     1.989    39.103     0.200
     1.989    40.103     0.200
     1.989    39.603     0.200
     2.332    45.601     0.200
     2.332    45.801     0.200
     2.656    52.617     0.200
     0.020     5.218     0.200
     0.644    14.031     0.200
     1.273    24.793     0.200
     1.273    24.996     0.200
     1.449    27.237     0.200
     1.449    27.339     0.200
     0.564    11.293     0.200
     0.774    15.937     0.200
     0.774    16.039     0.200
     0.774    15.546     0.200
     0.774    16.445     0.200
     1.795    34.228     0.200
     1.895    37.153     0.200
     2.267    44.321     0.200
     2.267    45.121     0.200
     2.226    45.101     0.200
     6.409   115.381     0.200
     0.164     6.278     0.200
     0.223     5.885     0.200
     1.173    24.410     0.200
     1.190    24.502     0.200
     2.252    42.211     0.200
     0.151     4.711     0.200
     0.241     5.553     0.200
     0.241     6.553     0.200
     1.142    23.642     0.200
     1.142    23.541     0.200
     1.241    26.288     0.200
     1.387    27.983     0.200
     1.387    27.882     0.200
     2.324    44.154     0.200
     0.086     3.005     0.200
     0.557    11.911     0.200
     1.079    22.124     0.200
     1.382    27.787     0.200
     1.790    34.620     0.200
     1.835    35.499     0.200
     2.325    46.485     0.200
     2.325    44.884     0.200
     2.706    53.129     0.200
     0.400    10.721     0.200
     1.026    20.613     0.200
     1.026    20.512     0.200
     1.669    33.406     0.200
     1.963    35.778     0.200
     1.963    35.377     0.200
     5.570    98.192     0.200
     6.538   113.490     0.200
     0.113     2.284     0.200
     0.113     2.084     0.200
     0.744    16.622     0.200
     1.024    21.255     0.200
     1.360    27.830     0.200
     1.360    29.031     0.200
     1.228    25.174     0.200
     1.228    25.674     0.200
     1.613    31.184     0.200
     1.918    37.525     0.200
     1.918    38.525     0.200
     1.918    39.726     0.200
     2.698    53.017     0.200
     2.698    53.618     0.200
     6.308   114.590     0.200
     0.484    10.960     0.200
     0.530    12.031     0.200
     0.530    11.632     0.200
     0.796    17.626     0.200
     0.796    17.821     0.200
     0.993    20.725     0.200
     0.993    20.623     0.200
     1.406    27.605     0.200
     1.406    27.503     0.200
     1.877    35.610     0.200
     1.877    37.610     0.200
     1.877    35.508     0.200
     3.881    72.026     0.200
     6.929   122.949     0.200
     0.021     6.583     0.200
     0.384     8.840     0.200
     0.384     9.340     0.200
     1.015    20.883     0.200
     1.234    24.823     0.200
     1.234    25.023     0.200
     1.288    26.198     0.200
     0.112     2.246     0.200
     0.112     1.945     0.200
     0.741    15.904     0.200
     1.045    21.864     0.200
     1.045    21.965     0.200
     1.208    24.953     0.200
     1.380    28.449     0.200
     1.931    38.514     0.200
     1.931    38.315     0.200
     2.316    47.028     0.200
     2.316    46.926     0.200
     2.679    53.394     0.200
     2.679    53.292     0.200
     0.079     5.555     0.200
     0.079     5.156     0.200
     0.552    12.944     0.200
     0.552    11.444     0.200
     1.044    21.202     0.200
     1.044    21.100     0.200
     1.346    26.077     0.200
     1.346    26.179     0.200
     1.269    24.571     0.200
     1.803    36.134     0.200
     1.803    34.037     0.200
     1.803    35.236     0.200
     2.289    42.074     0.200
     0.258     6.023     0.200
     0.581    12.557     0.200
     0.581    11.456     0.200
     1.060    22.771     0.200
     1.060    21.369     0.200
     1.577    31.038     0.200
     1.577    33.237     0.200
     1.793    34.313     0.200
     1.985    40.175     0.200
     1.985    40.277     0.200
     2.520    50.232     0.200
     2.528    49.944     0.200
     3.506    65.731     0.200
     0.110     2.362     0.200
     1.041    20.590     0.200
     1.041    22.387     0.200
     1.377    27.576     0.200
     1.377    28.373     0.200
     1.212    25.396     0.200
     1.614    31.598     0.200
     1.928    38.645     0.200
     2.312    46.154     0.200
     2.683    53.234     0.200
     2.683    52.734     0.200
     7.419   132.355     0.200
     0.242     7.399     0.200
     0.605    12.769     0.200
     0.790    15.904     0.200
     1.077    22.453     0.200
     1.077    22.050     0.200
     1.520    30.186     0.200
     1.520    29.788     0.200
     1.939    35.793     0.200
     2.004    38.834     0.200
     2.004    38.135     0.200
     0.151     5.633     0.200
     0.498    11.578     0.200
     0.498    11.078     0.200
     1.112    22.220     0.200
     1.112    22.619     0.200
     1.234    24.993     0.200
     1.234    24.493     0.200
     1.403    27.417     0.200
     1.403    26.718     0.200
     1.819    36.065     0.200
     1.819    34.366     0.200
     1.819    35.565     0.200
     1.847    34.839     0.200
     0.269     6.896     0.200
     0.772    16.333     0.200
     0.772    16.028     0.200
     0.994    20.936     0.200
     0.994    20.241     0.200
     1.515    30.160     0.200
     2.028    37.875     0.200
     2.010    37.994     0.200
     0.174     6.737     0.200
     0.174     6.139     0.200
     0.458    11.025     0.200
     0.458    11.326     0.200
     1.044    20.788     0.200
     1.044    20.987     0.200
     1.325    25.001     0.200
     1.321    26.256     0.200
     1.733    33.743     0.200
     1.733    33.540     0.200
     1.897    34.933     0.200
     1.897    34.734     0.200
     0.108     6.483     0.200
     0.469    10.570     0.200
     0.920    18.900     0.200
     2.045    37.672     0.200
     2.045    37.072     0.200
     0.190     4.093     0.200
     0.190     3.993     0.200
     0.516    11.792     0.200
     0.825    17.775     0.200
     0.960    19.701     0.200
     1.375    28.562     0.200
     1.375    28.164     0.200
     2.167    42.719     0.200
     2.616    50.274     0.200
     2.616    49.373     0.200
     2.627    52.047     0.200
     2.840    56.368     0.200
     2.950    57.476     0.200
     2.950    58.076     0.200
     0.191     4.094     0.200
     0.514    11.727     0.200
     0.825    18.204     0.200
     0.825    17.404     0.200
     0.965    19.668     0.200
     0.965    19.368     0.200
     1.371    30.325     0.200
     1.370    28.335     0.200
     2.167    42.733     0.200
     2.167    41.832     0.200
     2.615    50.011     0.200
     2.624    52.009     0.200
     2.841    56.871     0.200
     2.953    57.766     0.200
     2.953    58.166     0.200
     0.212     6.121     0.200
     0.567    11.786     0.200
     0.816    17.275     0.200
     1.081    22.484     0.200
     1.376    28.342     0.200
     1.979    36.908     0.200
     2.037    40.231     0.200
     0.223     5.091     0.200
     0.608    12.297     0.200
     1.067    22.537     0.200
     1.247    25.137     0.200
     1.554    31.254     0.200
     1.756    34.900     0.200
     1.985    39.724     0.200
     2.497    49.152     0.200
     2.538    51.073     0.200
     6.073   108.916     0.200
     6.120   109.978     0.200
     7.065   131.346     0.200
     0.210     5.126     0.200
     0.210     4.524     0.200
     0.576    12.258     0.200
     1.098    22.269     0.200
     1.228    24.648     0.200
     1.228    25.449     0.200
     1.531    30.118     0.200
     1.531    29.919     0.200
     1.952    39.198     0.200
     1.783    34.270     0.200
     2.474    48.516     0.200
     2.568    50.617     0.200
     2.568    49.917     0.200
     6.146   110.757     0.200
     8.528   150.762     0.200
     0.208     5.359     0.200
     0.585    12.162     0.200
     1.093    22.337     0.200
     1.228    24.556     0.200
     1.532    30.210     0.200
     1.774    34.485     0.200
     1.959    39.136     0.200
     2.475    47.707     0.200
     2.475    49.800     0.200
     2.563    50.874     0.200
     7.932   142.922     0.200
     8.534   153.999     0.200
     0.226     5.381     0.200
     0.226     5.084     0.200
     0.581    12.340     0.200
     0.581    12.543     0.200
     1.083    22.476     0.200
     1.083    22.273     0.200
     1.244    24.892     0.200
     1.547    30.463     0.200
     1.783    34.606     0.200
     1.966    39.180     0.200
     1.966    38.383     0.200
     2.553    51.430     0.200
     2.553    49.227     0.200
     7.942   142.937     0.200
     0.214     5.127     0.200
     0.603    12.383     0.200
     1.077    22.455     0.200
     1.238    25.477     0.200
     1.545    30.999     0.200
     1.545    30.898     0.200
     1.758    34.607     0.200
     1.758    34.903     0.200
     1.976    39.358     0.200
     1.976    38.757     0.200
     2.487    49.396     0.200
     2.487    48.997     0.200
     2.548    51.087     0.200
     2.548    50.587     0.200
     4.059    74.652     0.200
     5.528   103.510     0.200
     0.213     4.937     0.200
     0.213     4.632     0.200
     0.603    12.679     0.200
     1.078    22.438     0.200
     1.078    21.844     0.200
     1.237    25.185     0.200
     1.237    25.388     0.200
     1.543    30.308     0.200
     1.543    31.003     0.200
     1.758    34.501     0.200
     1.976    39.459     0.200
     2.486    49.408     0.200
     2.549    50.874     0.200
     2.549    50.272     0.200
     3.462    65.015     0.200
     5.527   102.611     0.200
     6.130   112.678     0.200
     0.212     5.123     0.200
     0.594    11.762     0.200
     1.085    22.235     0.200
     1.234    24.794     0.200
     1.539    30.333     0.200
     1.767    34.675     0.200
     1.967    38.832     0.200
     2.482    46.932     0.200
     2.482    49.432     0.200
     2.555    50.672     0.200
     7.941   143.523     0.200
     0.245     5.331     0.200
     0.245     5.530     0.200
     0.608    12.495     0.200
     0.608    12.796     0.200
     1.051    22.323     0.200
     1.269    25.486     0.200
     1.575    31.515     0.200
     1.575    31.616     0.200
     1.998    39.269     0.200
     2.521    50.272     0.200
     2.521    49.971     0.200
     2.517    49.211     0.200
     2.517    49.512     0.200
     6.084   108.594     0.200
     0.266     5.667     0.200
     0.266     4.968     0.200
     0.618    12.765     0.200
     1.030    21.658     0.200
     1.030    21.459     0.200
     1.597    32.337     0.200
     2.018    40.324     0.200
     2.018    39.625     0.200
     1.761    34.330     0.200
     2.540    49.034     0.200
     2.540    49.936     0.200
     2.499    50.310     0.200
     2.499    49.111     0.200
     7.099   129.936     0.200
     0.230     5.346     0.200
     0.603    12.394     0.200
     1.559    31.535     0.200
     1.763    35.354     0.200
     1.985    39.659     0.200
     2.502    49.533     0.200
     2.502    49.233     0.200
     2.536    50.738     0.200
     2.536    50.537     0.200
     6.442   116.547     0.200
     7.508   139.588     0.200
     0.105     3.128     0.200
     0.583    12.047     0.200
     1.123    22.649     0.200
     1.182    24.248     0.200
     1.430    28.663     0.200
     1.762    33.887     0.200
     1.886    37.245     0.200
     1.886    38.245     0.200
     2.373    46.664     0.200
     6.242   112.009     0.200
     0.222     5.367     0.200
     0.222     5.769     0.200
     0.587    12.108     0.200
     1.081    21.746     0.200
     1.081    21.945     0.200
     1.243    25.260     0.200
     1.243    25.362     0.200
     1.546    31.017     0.200
     1.776    33.936     0.200
     1.969    38.888     0.200
     1.969    38.388     0.200
     2.489    48.314     0.200
     2.489    49.111     0.200
     2.551    50.792     0.200
     2.551    50.292     0.200
     3.304    61.605     0.200
     4.042    74.696     0.200
     5.521   101.329     0.200
     6.130   109.729     0.200
     7.049   126.502     0.200
     0.516    11.021     0.200
     0.830    16.662     0.200
     0.796    16.853     0.200
     1.770    35.189     0.200
     1.760    35.100     0.200
     7.990   142.404     0.200
     0.222     5.438     0.200
     0.222     5.239     0.200
     0.576    12.301     0.200
     1.089    23.117     0.200
     1.089    22.718     0.200
     1.541    30.340     0.200
     1.786    34.484     0.200
     1.960    39.062     0.200
     1.960    38.862     0.200
     2.484    49.136     0.200
     2.559    51.771     0.200
     2.559    50.572     0.200
     4.031    74.184     0.200
     5.899   108.088     0.200
     0.159     4.320     0.200
     0.753    16.597     0.200
     0.753    16.495     0.200
     1.577    30.875     0.200
     1.617    32.112     0.200
     1.530    30.227     0.200
     2.469    47.062     0.200
     2.445    46.351     0.200
     2.445    46.452     0.200
     5.567    99.314     0.200
     0.119     5.106     0.200
     0.119     4.905     0.200
     0.516    11.172     0.200
     0.516    11.371     0.200
     1.074    20.565     0.200
     1.259    25.010     0.200
     1.259    25.510     0.200
     1.369    26.022     0.200
     1.802    35.364     0.200
     1.802    34.665     0.200
     1.802    35.765     0.200
     2.312    45.317     0.200
     5.352    97.943     0.200
     6.310   112.065     0.200
     0.269     7.142     0.200
     0.269     6.740     0.200
     0.986    20.775     0.200
     0.986    20.572     0.200
     0.768    16.219     0.200
     0.768    17.219     0.200
     1.598    29.929     0.200
     1.605    30.639     0.200
     2.104    40.725     0.200
     2.104    41.123     0.200
     7.176   130.929     0.200
     0.220     5.183     0.200
     0.220     5.081     0.200
     0.573    12.159     0.200
     1.093    23.303     0.200
     1.093    22.803     0.200
     1.538    32.297     0.200
     1.956    39.424     0.200
     1.956    39.525     0.200
     2.481    48.597     0.200
     2.562    51.555     0.200
     0.227     5.760     0.200
     0.756    16.194     0.200
     1.030    20.597     0.200
     1.229    23.666     0.200
     1.599    30.053     0.200
     2.068    40.977     0.200
     6.011   111.768     0.200
     6.106   108.554     0.200
     7.577   134.694     0.200
     0.212     5.272     0.200
     0.565    12.049     0.200
     1.105    22.740     0.200
     1.527    30.622     0.200
     1.794    34.905     0.200
     1.943    39.062     0.200
     2.470    49.117     0.200
     2.575    51.095     0.200
     5.797   103.789     0.200
     6.151   111.754     0.200
     0.458     9.525     0.200
     0.614    13.215     0.200
     0.688    15.142     0.200
     1.148    23.574     0.200
     1.148    23.675     0.200
     1.219    24.954     0.200
     1.343    28.603     0.200
     1.343    28.904     0.200
     2.002    39.411     0.200
     2.585    50.106     0.200
     2.744    52.557     0.200
     2.744    52.154     0.200
     2.907    56.255     0.200
     2.907    57.954     0.200
     0.224     5.490     0.200
     0.224     4.990     0.200
     0.576    12.477     0.200
     1.088    23.506     0.200
     1.241    25.016     0.200
     1.543    30.792     0.200
     1.787    34.850     0.200
     1.787    35.750     0.200
     1.961    39.021     0.200
     2.486    49.188     0.200
     2.557    51.661     0.200
     2.557    51.461     0.200
     0.223     5.080     0.200
     0.617    12.974     0.200
     0.617    12.381     0.200
     1.062    22.388     0.200
     1.062    22.489     0.200
     1.248    24.915     0.200
     1.248    25.814     0.200
     1.557    31.010     0.200
     1.747    34.000     0.200
     1.747    34.703     0.200
     1.992    39.134     0.200
     1.992    40.931     0.200
     2.533    50.219     0.200
     2.533    50.524     0.200
     2.500    47.416     0.200
     0.111     2.367     0.200
     0.111     3.464     0.200
     1.112    23.383     0.200
     1.205    24.186     0.200
     1.414    28.356     0.200
     1.414    28.954     0.200
     1.791    34.048     0.200
     1.858    36.976     0.200
     1.858    36.176     0.200
     2.357    46.353     0.200
     2.357    46.052     0.200
     2.677    52.910     0.200
     0.099     2.846     0.200
     0.099     2.745     0.200
     0.575    11.590     0.200
     1.196    24.134     0.200
     1.417    27.854     0.200
     1.417    28.154     0.200
     1.771    34.031     0.200
     1.872    37.251     0.200
     2.360    46.353     0.200
     2.669    52.152     0.200
     2.669    51.449     0.200
     0.109     2.720     0.200
     0.109     3.622     0.200
     0.576    12.276     0.200
     0.576    12.378     0.200
     1.124    22.579     0.200
     1.124    23.478     0.200
     1.184    24.778     0.200
     1.430    29.207     0.200
     1.770    34.446     0.200
     1.882    36.238     0.200
     2.373    46.507     0.200
     2.657    52.696     0.200
     2.657    52.395     0.200
     3.230    62.999     0.200
     6.337   116.146     0.200
     0.107     3.386     0.200
     0.107     2.589     0.200
     0.589    12.060     0.200
     0.589    11.861     0.200
     1.127    22.479     0.200
     1.127    24.081     0.200
     1.176    24.512     0.200
     1.176    23.813     0.200
     1.435    29.381     0.200
     1.756    34.135     0.200
     1.893    37.645     0.200
     2.378    46.183     0.200
     2.378    47.483     0.200
     2.649    52.927     0.200
     0.118     2.686     0.200
     0.118     3.385     0.200
     0.575    12.246     0.200
     1.133    25.136     0.200
     1.176    24.335     0.200
     1.439    28.967     0.200
     1.439    28.767     0.200
     1.888    37.426     0.200
     1.888    37.227     0.200
     1.770    34.602     0.200
     2.382    46.766     0.200
     2.649    53.153     0.200
     0.120     3.452     0.200
     0.120     3.151     0.200
     0.591    12.052     0.200
     0.591    12.955     0.200
     1.163    23.573     0.200
     1.141    23.130     0.200
     1.141    23.232     0.200
     1.449    28.731     0.200
     1.755    34.062     0.200
     1.904    37.330     0.200
     2.392    47.135     0.200
     2.636    51.790     0.200
     2.636    51.989     0.200
     0.110     2.740     0.200
     1.134    23.087     0.200
     1.164    24.533     0.200
     1.444    29.363     0.200
     1.444    28.765     0.200
     1.744    33.970     0.200
     1.906    37.274     0.200
     1.906    38.473     0.200
     2.387    46.768     0.200
     2.637    52.042     0.200
     2.637    51.343     0.200
     0.106     3.496     0.200
     0.567    11.815     0.200
     1.116    22.610     0.200
     1.195    24.491     0.200
     1.195    24.592     0.200
     1.421    28.156     0.200
     1.778    33.989     0.200
     1.870    36.111     0.200
     2.364    46.252     0.200
     2.667    52.610     0.200
     2.667    53.008     0.200
     0.110     2.844     0.200
     0.561    12.073     0.200
     1.198    26.145     0.200
     1.866    36.250     0.200
     2.363    46.055     0.200
     2.363    47.055     0.200
     2.670    52.965     0.200
     0.104     3.338     0.200
     0.590    11.873     0.200
     1.178    23.907     0.200
     1.433    28.029     0.200
     1.756    33.763     0.200
     1.891    37.181     0.200
     2.376    45.530     0.200
     2.651    52.020     0.200
     0.048     2.196     0.200
     0.609    11.651     0.200
     0.609    12.352     0.200
     1.072    22.649     0.200
     1.218    24.442     0.200
     1.385    28.197     0.200
     1.385    27.998     0.200
     1.739    34.565     0.200
     1.865    36.289     0.200
     2.327    46.705     0.200
     2.327    46.807     0.200
     3.223    62.747     0.200
     3.223    63.048     0.200
     4.489    83.271     0.200
     0.277     7.299     0.200
     0.277     6.799     0.200
     0.557    12.128     0.200
     0.788    16.436     0.200
     0.788    16.233     0.200
     0.977    19.229     0.200
     2.032    38.823     0.200
     2.032    39.620     0.200
     4.708    87.189     0.200
     0.496    11.786     0.200
     0.496    10.885     0.200
     0.536    11.321     0.200
     0.536    11.921     0.200
     0.814    17.174     0.200
     0.814    17.874     0.200
     0.831    16.673     0.200
     1.752    34.726     0.200
     1.775    34.860     0.200
     1.900    35.400     0.200
     0.449     9.889     0.200
     0.381     8.789     0.200
     1.162    23.367     0.200
     1.162    23.668     0.200
     1.369    27.361     0.200
     1.624    30.782     0.200
     2.051    38.195     0.200
     0.186     4.016     0.200
     0.186     4.118     0.200
     0.566    10.790     0.200
     0.851    17.460     0.200
     0.851    17.459     0.200
     1.482    29.789     0.200
     2.157    42.222     0.200
     2.157    42.019     0.200
     2.658    50.168     0.200
     2.719    52.158     0.200
     2.719    51.755     0.200
     2.807    55.933     0.200
     2.891    56.052     0.200
     2.891    55.552     0.200
     0.303     6.739     0.200
     0.663    14.738     0.200
     0.979    20.042     0.200
     0.979    19.842     0.200
     1.331    26.237     0.200
     1.331    26.037     0.200
     2.070    40.519     0.200
     2.070    39.019     0.200
     0.245     5.818     0.200
     0.245     6.920     0.200
     0.399     9.210     0.200
     1.389    28.060     0.200
     1.658    32.919     0.200
     2.220    43.261     0.200
     2.856    56.245     0.200
     2.856    56.643     0.200
     3.000    58.956     0.200
     6.420   115.945     0.200
     0.239     6.882     0.200
     0.239     6.181     0.200
     0.984    20.282     0.200
     1.250    27.789     0.200
     1.411    28.302     0.200
     2.189    41.728     0.200
     2.879    56.268     0.200
     0.406     9.865     0.200
     0.406     9.765     0.200
     0.794    16.526     0.200
     0.954    20.164     0.200
     1.796    35.034     0.200
     1.796    34.333     0.200
     1.889    37.258     0.200
     0.252     6.855     0.200
     0.252     6.654     0.200
     0.432     8.455     0.200
     0.952    20.179     0.200
     0.952    19.679     0.200
     1.216    24.700     0.200
     1.441    28.274     0.200
     1.964    37.770     0.200
     2.156    43.437     0.200
     2.156    42.237     0.200
     7.688   136.374     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
