#!/bin/bash
gmt begin novy1.66_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance novy1.66'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.000    20.931
     1.100    22.294
     1.200    23.657
     1.300    25.020
     1.400    26.383
     1.500    27.746
     1.600    29.109
     1.700    30.472
     1.800    31.835
     1.900    33.198
     2.000    34.561
     2.100    35.924
     2.200    37.287
     2.300    38.650
     2.400    40.013
     2.500    41.376
     2.600    42.739
     2.700    44.102
     2.800    45.465
     2.900    46.828
     3.000    48.191
     3.100    49.554
     3.200    50.917
     3.300    52.280
     3.400    53.643
     3.500    55.005
     3.600    56.368
     3.700    57.731
     3.800    59.093
     3.900    60.456
     4.000    61.819
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    54.368 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     2.586
     0.200     4.120
     0.300     5.841
     0.400     7.624
     0.500     9.433
     0.600    11.256
     0.700    13.087
     0.800    14.923
     0.900    16.762
     1.000    18.598
     1.100    20.228
     1.200    21.858
     1.300    23.488
     1.400    25.118
     1.500    26.748
     1.600    28.378
     1.700    30.008
     1.800    31.638
     1.900    33.268
     2.000    34.898
     2.100    36.528
     2.200    38.158
     2.300    39.788
     2.400    41.418
     2.500    43.048
     2.600    44.678
     2.700    46.308
     2.800    47.938
     2.900    49.568
     3.000    51.197
     3.100    52.827
     3.200    54.457
     3.300    56.086
     3.400    57.716
     3.500    59.345
     3.600    60.975
     3.700    62.605
     3.800    64.234
     3.900    65.864
     4.000    67.493
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    59.975 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    36.147
     2.100    37.955
     2.200    39.762
     2.300    41.569
     2.400    43.377
     2.500    45.184
     2.600    46.991
     2.700    48.799
     2.800    50.606
     2.900    52.413
     3.000    54.221
     3.100    56.028
     3.200    57.836
     3.300    59.643
     3.400    61.450
     3.500    63.258
     3.600    65.065
     3.700    66.872
     3.800    68.680
     3.900    70.487
     4.000    72.294
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    67.065 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.000    37.245
     1.100    39.619
     1.200    41.993
     1.300    44.367
     1.400    46.741
     1.500    49.116
     1.600    51.490
     1.700    53.864
     1.800    56.238
     1.900    58.612
     2.000    60.987
     2.100    63.361
     2.200    65.735
     2.300    68.109
     2.400    70.483
     2.500    72.858
     2.600    75.232
     2.700    77.606
     2.800    79.980
     2.900    82.354
     3.000    84.729
     3.100    87.103
     3.200    89.477
     3.300    91.851
     3.400    94.225
     3.500    96.599
     3.600    98.973
     3.700   101.347
     3.800   103.720
     3.900   106.094
     4.000   108.467
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    96.973 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     4.564
     0.200     7.270
     0.300    10.307
     0.400    13.453
     0.500    16.646
     0.600    19.863
     0.700    23.094
     0.800    26.334
     0.900    29.581
     1.000    32.831
     1.100    35.938
     1.200    38.854
     1.300    41.771
     1.400    44.688
     1.500    47.605
     1.600    50.522
     1.700    53.438
     1.800    56.355
     1.900    59.272
     2.000    62.189
     2.100    65.106
     2.200    68.022
     2.300    70.939
     2.400    73.856
     2.500    76.773
     2.600    79.690
     2.700    82.606
     2.800    85.523
     2.900    88.439
     3.000    91.355
     3.100    94.271
     3.200    97.188
     3.300   100.104
     3.400   103.020
     3.500   105.936
     3.600   108.852
     3.700   111.768
     3.800   114.684
     3.900   117.600
     4.000   120.515
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   107.852 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.000    60.885
     2.100    64.024
     2.200    67.163
     2.300    70.302
     2.400    73.440
     2.500    76.579
     2.600    79.718
     2.700    82.857
     2.800    85.996
     2.900    89.134
     3.000    92.273
     3.100    95.412
     3.200    98.551
     3.300   101.689
     3.400   104.828
     3.500   107.967
     3.600   111.106
     3.700   114.244
     3.800   117.383
     3.900   120.522
     4.000   123.661
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   113.106 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    23.516
     1.200    24.879
     1.300    26.242
     1.400    27.605
     1.500    28.968
     1.600    30.331
     1.700    31.694
     1.800    33.057
     1.900    34.420
     2.000    35.783
     2.100    37.146
     2.200    38.509
     2.300    39.872
     2.400    41.235
     2.500    42.598
     2.600    43.961
     2.700    45.324
     2.800    46.687
     2.900    48.050
     3.000    49.413
     3.100    50.776
     3.200    52.139
     3.300    53.502
     3.400    54.865
     3.500    56.228
     3.600    57.591
     3.700    58.953
     3.800    60.316
     3.900    61.678
     4.000    63.041
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.853
     0.200     3.706
     0.300     5.559
     0.400     7.413
     0.500     9.266
     0.600    11.119
     0.700    12.972
     0.800    14.825
     0.900    16.678
     1.000    18.532
     1.100    20.385
     1.200    22.238
     1.300    24.091
     1.400    25.944
     1.500    27.605
     1.600    29.235
     1.700    30.865
     1.800    32.495
     1.900    34.125
     2.000    35.755
     2.100    37.385
     2.200    39.015
     2.300    40.645
     2.400    42.275
     2.500    43.905
     2.600    45.535
     2.700    47.165
     2.800    48.795
     2.900    50.425
     3.000    52.055
     3.100    53.684
     3.200    55.314
     3.300    56.943
     3.400    58.573
     3.500    60.202
     3.600    61.832
     3.700    63.462
     3.800    65.091
     3.900    66.721
     4.000    68.350
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    41.808
     1.200    44.182
     1.300    46.556
     1.400    48.930
     1.500    51.305
     1.600    53.679
     1.700    56.053
     1.800    58.427
     1.900    60.801
     2.000    63.176
     2.100    65.550
     2.200    67.924
     2.300    70.298
     2.400    72.672
     2.500    75.047
     2.600    77.421
     2.700    79.795
     2.800    82.169
     2.900    84.543
     3.000    86.918
     3.100    89.292
     3.200    91.666
     3.300    94.040
     3.400    96.414
     3.500    98.789
     3.600   101.162
     3.700   103.537
     3.800   105.910
     3.900   108.284
     4.000   110.657
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.270
     0.200     6.541
     0.300     9.811
     0.400    13.081
     0.500    16.351
     0.600    19.622
     0.700    22.892
     0.800    26.162
     0.900    29.433
     1.000    32.703
     1.100    35.973
     1.200    39.243
     1.300    42.514
     1.400    45.784
     1.500    49.041
     1.600    51.958
     1.700    54.874
     1.800    57.791
     1.900    60.708
     2.000    63.625
     2.100    66.542
     2.200    69.458
     2.300    72.375
     2.400    75.292
     2.500    78.209
     2.600    81.126
     2.700    84.042
     2.800    86.959
     2.900    89.876
     3.000    92.793
     3.100    95.709
     3.200    98.625
     3.300   101.541
     3.400   104.457
     3.500   107.373
     3.600   110.290
     3.700   113.206
     3.800   116.122
     3.900   119.038
     4.000   121.954
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    14.603
     0.800    15.966
     0.900    17.329
     1.000    18.692
     1.100    20.055
     1.200    21.418
     1.300    22.781
     1.400    24.144
     1.500    25.507
     1.600    26.870
     1.700    28.233
     1.800    29.596
     1.900    30.959
     2.000    32.322
     2.100    33.685
     2.200    35.048
     2.300    36.411
     2.400    37.774
     2.500    39.137
     2.600    40.500
     2.700    41.863
     2.800    43.226
     2.900    44.589
     3.000    45.952
     3.100    47.315
     3.200    48.678
     3.300    50.040
     3.400    51.403
     3.500    52.765
     3.600    54.128
     3.700    55.490
     3.800    56.853
     3.900    58.216
     4.000    59.578
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     5.810
     0.200     6.552
     0.300     7.628
     0.400     8.913
     0.500    10.324
     0.600    11.812
     0.700    13.346
     0.800    14.909
     0.900    16.490
     1.000    18.083
     1.100    19.684
     1.200    21.291
     1.300    22.902
     1.400    24.517
     1.500    26.133
     1.600    27.751
     1.700    29.371
     1.800    30.992
     1.900    32.613
     2.000    34.235
     2.100    35.858
     2.200    37.482
     2.300    39.106
     2.400    40.730
     2.500    42.355
     2.600    43.980
     2.700    45.604
     2.800    47.230
     2.900    48.855
     3.000    50.481
     3.100    52.106
     3.200    53.732
     3.300    55.358
     3.400    56.984
     3.500    58.610
     3.600    60.236
     3.700    61.862
     3.800    63.488
     3.900    65.115
     4.000    66.741
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.700    25.985
     0.800    28.359
     0.900    30.733
     1.000    33.107
     1.100    35.481
     1.200    37.856
     1.300    40.230
     1.400    42.604
     1.500    44.978
     1.600    47.352
     1.700    49.727
     1.800    52.101
     1.900    54.475
     2.000    56.849
     2.100    59.223
     2.200    61.598
     2.300    63.972
     2.400    66.346
     2.500    68.720
     2.600    71.094
     2.700    73.469
     2.800    75.843
     2.900    78.217
     3.000    80.591
     3.100    82.965
     3.200    85.339
     3.300    87.713
     3.400    90.087
     3.500    92.460
     3.600    94.834
     3.700    97.207
     3.800    99.581
     3.900   101.954
     4.000   104.328
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100    10.310
     0.200    11.630
     0.300    13.542
     0.400    15.828
     0.500    18.340
     0.600    20.992
     0.700    23.729
     0.800    26.519
     0.900    29.344
     1.000    32.192
     1.100    35.055
     1.200    37.929
     1.300    40.811
     1.400    43.699
     1.500    46.590
     1.600    49.485
     1.700    52.383
     1.800    55.283
     1.900    58.184
     2.000    61.087
     2.100    63.991
     2.200    66.896
     2.300    69.802
     2.400    72.708
     2.500    75.615
     2.600    78.523
     2.700    81.431
     2.800    84.339
     2.900    87.248
     3.000    90.157
     3.100    93.066
     3.200    95.975
     3.300    98.884
     3.400   101.794
     3.500   104.704
     3.600   107.613
     3.700   110.523
     3.800   113.433
     3.900   116.343
     4.000   119.253
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     5.446    79.750     0.200
     6.391    93.750     0.200
     6.859   100.750     0.200
    14.288   201.750     0.200
    15.447   217.750     0.200
    15.996   225.750     0.200
    17.571   244.750     0.200
    20.237   275.750     0.200
    10.289   145.375     0.200
     2.344    37.977     0.200
     2.344    37.477     0.200
     5.073    75.477     0.200
     5.630    81.477     0.200
     6.341    93.977     0.200
     7.429   107.477     0.200
     7.541   109.477     0.200
    11.174   155.477     0.200
    14.855   207.477     0.200
     2.141    34.789     0.200
     5.022    77.789     0.200
     5.048    74.789     0.200
     5.812    83.891     0.200
     7.622   109.988     0.200
     7.707   110.789     0.200
     7.707   111.289     0.200
    16.107   222.090     0.200
    16.365   228.789     0.200
    20.817   284.789     0.200
    20.817   285.289     0.200
     2.074    32.531     0.200
     2.438    39.832     0.200
     4.920    71.531     0.200
     4.920    71.832     0.200
     5.096    75.133     0.200
     7.815   111.531     0.200
    10.895   151.633     0.200
    15.065   207.031     0.200
    16.238   222.031     0.200
    16.329   228.531     0.200
     2.812    44.305     0.200
     3.980    61.004     0.200
     4.385    67.004     0.200
     5.272    80.004     0.200
     5.272    80.604     0.200
     7.026   103.703     0.200
     7.234   106.004     0.200
    11.565   163.004     0.200
    11.565   163.805     0.200
    14.791   207.203     0.200
     2.372    38.516     0.200
     2.275    37.812     0.200
     2.758    44.414     0.200
     2.758    45.109     0.200
     3.068    49.914     0.200
     4.190    63.414     0.200
     4.297    64.312     0.200
     4.297    64.016     0.200
     5.429    80.312     0.200
     6.645    95.711     0.200
     6.718    97.312     0.200
     6.718    98.109     0.200
     7.802   112.016     0.200
     7.802   111.516     0.200
     8.473   123.312     0.200
     8.473   123.109     0.200
     8.473   123.609     0.200
     8.658   125.312     0.200
     8.658   124.812     0.200
     8.773   125.914     0.200
    10.119   142.312     0.200
    10.119   142.711     0.200
    16.714   227.812     0.200
    17.298   232.312     0.200
    20.504   282.312     0.200
     2.307    38.871     0.200
     2.205    37.871     0.200
     2.450    41.473     0.200
     2.679    44.270     0.200
     3.135    52.770     0.200
     3.135    52.570     0.200
     4.321    64.871     0.200
     4.321    65.270     0.200
     5.503    82.973     0.200
     6.794   101.172     0.200
     7.879   114.473     0.200
     8.546   128.270     0.200
     8.546   126.973     0.200
     8.736   126.871     0.200
     8.736   127.070     0.200
     8.736   117.871     0.200
     8.852   128.973     0.200
    10.047   143.871     0.200
    10.047   144.070     0.200
    15.990   223.672     0.200
    16.668   228.371     0.200
    17.126   237.871     0.200
    17.314   234.770     0.200
    20.579   284.871     0.200
    20.626   282.871     0.200
     3.509    54.315     0.200
     3.949    61.215     0.200
     4.335    67.815     0.200
     5.253    78.515     0.200
     5.632    83.815     0.200
     6.359    92.815     0.200
     6.988   102.815     0.200
     7.232   106.815     0.200
     7.232   116.615     0.200
    14.734   209.815     0.200
    14.854   207.115     0.200
    16.137   226.615     0.200
    17.655   242.015     0.200
    18.006   245.315     0.200
    19.121   264.815     0.200
    19.480   270.815     0.200
    19.916   273.815     0.200
     2.477    41.941     0.200
     2.495    41.641     0.200
     3.738    56.941     0.200
     4.224    63.941     0.200
     7.921   118.840     0.200
     8.189   119.141     0.200
    10.683   150.141     0.200
    11.946   170.641     0.200
    11.946   170.742     0.200
    16.902   233.641     0.200
    16.902   233.941     0.200
    17.334   236.641     0.200
    17.442   242.641     0.200
    20.078   274.242     0.200
    20.241   275.641     0.200
    20.330   277.641     0.200
    20.617   284.141     0.200
     2.246    37.281     0.200
     2.246    37.680     0.200
     2.285    38.078     0.200
     2.467    39.281     0.200
     2.467    38.984     0.200
     2.467    39.180     0.200
     3.036    48.383     0.200
     3.713    58.180     0.200
     3.707    57.180     0.200
     4.392    68.078     0.200
     4.713    70.781     0.200
     5.690    82.781     0.200
     6.351    93.281     0.200
     6.788    98.984     0.200
     7.433   109.281     0.200
     7.433   113.078     0.200
     7.433   109.180     0.200
     7.656   112.680     0.200
     7.656   112.984     0.200
     7.818   114.281     0.200
    11.159   154.781     0.200
    17.528   235.781     0.200
    17.612   237.781     0.200
    19.547   270.281     0.200
    20.314   277.281     0.200
     8.255   118.232     0.200
    18.473   257.232     0.200
    20.066   272.732     0.200
     2.218    35.695     0.200
     2.854    45.398     0.200
     3.322    51.898     0.200
     3.666    55.898     0.200
     3.666    56.602     0.200
     5.621    83.898     0.200
     5.621    84.195     0.200
     6.965   101.898     0.200
     8.599   124.898     0.200
     8.599   125.695     0.200
     8.989   130.898     0.200
    13.747   192.102     0.200
    14.599   205.398     0.200
    14.923   210.500     0.200
    15.014   210.102     0.200
    15.333   216.398     0.200
    15.635   219.398     0.200
    16.602   229.898     0.200
    16.602   230.195     0.200
    18.976   262.500     0.200
    20.863   282.898     0.200
    20.879   284.398     0.200
     1.715    29.898     0.200
     1.824    30.797     0.200
     3.181    49.898     0.200
     3.181    50.102     0.200
     4.166    63.297     0.200
     4.497    67.398     0.200
     6.458    94.297     0.200
     7.379   106.898     0.200
     8.233   119.898     0.200
     8.233   120.102     0.200
    10.523   147.398     0.200
    18.794   258.398     0.200
    20.123   274.797     0.200
    20.947   283.398     0.200
     1.927    32.615     0.200
     1.927    32.416     0.200
     2.193    37.115     0.200
     2.193    36.916     0.200
     2.298    38.115     0.200
     2.870    45.115     0.200
     2.870    45.615     0.200
     3.470    54.115     0.200
     3.595    56.314     0.200
     4.099    61.715     0.200
     4.099    62.615     0.200
     4.726    71.314     0.200
     5.852    86.715     0.200
     6.174    91.115     0.200
     6.513    95.215     0.200
     7.178   105.615     0.200
     7.828   113.916     0.200
     8.294   120.516     0.200
     8.861   129.215     0.200
     9.170   132.115     0.200
     9.345   133.416     0.200
     9.438   136.416     0.200
    14.094   198.115     0.200
    14.883   212.416     0.200
    15.357   217.115     0.200
    15.395   215.715     0.200
    15.762   222.416     0.200
    16.068   225.615     0.200
    16.089   225.535     0.200
    17.765   245.115     0.200
    18.417   257.215     0.200
    19.413   266.615     0.200
    19.621   269.615     0.200
    19.930   273.916     0.200
     1.970    32.152     0.200
     1.970    32.353     0.200
     2.054    34.252     0.200
     3.000    48.053     0.200
     3.495    52.952     0.200
     3.516    55.053     0.200
     4.244    63.252     0.200
     4.769    72.053     0.200
     4.836    72.152     0.200
     6.026    87.353     0.200
     6.026    88.053     0.200
     7.089   102.252     0.200
     7.823   113.152     0.200
     7.935   114.152     0.200
     8.025   117.152     0.200
     8.331   117.952     0.200
    10.778   151.952     0.200
     2.165    36.719     0.200
     2.216    38.422     0.200
     2.218    38.719     0.200
     3.413    55.523     0.200
     3.684    59.023     0.200
     3.684    59.219     0.200
     4.571    70.719     0.200
     4.571    70.617     0.200
     4.922    75.820     0.200
     7.746   114.617     0.200
     2.104    34.516     0.200
     2.230    36.617     0.200
     2.231    36.617     0.200
     2.665    43.117     0.200
     3.453    54.016     0.200
     3.692    57.320     0.200
     4.237    64.320     0.200
     4.237    63.617     0.200
     4.613    69.914     0.200
     4.983    74.016     0.200
     5.898    86.117     0.200
     6.536    97.320     0.200
     6.921    99.617     0.200
     7.668   111.820     0.200
     7.764   113.617     0.200
     7.850   114.320     0.200
    16.801   234.617     0.200
     1.952    32.680     0.200
     2.432    40.582     0.200
     3.299    50.980     0.200
     3.888    59.980     0.200
     4.361    67.480     0.200
     1.763    29.359     0.200
     1.719    29.461     0.200
     2.120    34.859     0.200
     2.887    45.559     0.200
     3.095    47.859     0.200
     4.099    62.559     0.200
     4.183    62.859     0.200
     8.635   125.461     0.200
     2.261    36.831     0.200
     2.527    41.331     0.200
     3.199    50.231     0.200
     3.288    52.031     0.200
     3.853    59.432     0.200
     4.189    63.531     0.200
     4.433    67.132     0.200
     4.434    67.132     0.200
     4.448    67.632     0.200
     4.744    70.231     0.200
     5.094    75.731     0.200
     5.164    77.932     0.200
     5.695    83.831     0.200
     5.695    84.132     0.200
     5.733    84.132     0.200
     6.369    92.632     0.200
     6.752    97.731     0.200
     7.503   109.331     0.200
     7.503   109.031     0.200
     7.595   111.432     0.200
     7.595   111.132     0.200
     7.684   111.831     0.200
     8.414   119.531     0.200
     1.946    32.318     0.200
     2.236    37.217     0.200
     2.835    45.117     0.200
     3.985    60.617     0.200
     3.884    59.018     0.200
     4.098    62.518     0.200
     5.042    75.418     0.200
     5.044    75.418     0.200
     5.233    78.318     0.200
     5.774    85.518     0.200
     6.242    90.818     0.200
     7.650   108.143     0.200
     7.657   110.217     0.200
     8.258   121.617     0.200
     8.529   124.418     0.200
     8.697   125.117     0.200
    12.931   183.818     0.200
    15.988   222.244     0.200
     1.731    31.541     0.200
     1.731    32.340     0.200
     1.731    31.340     0.200
     1.820    32.240     0.200
     2.199    38.340     0.200
     2.199    38.141     0.200
     2.828    46.541     0.200
     3.094    50.041     0.200
     3.882    60.641     0.200
     4.021    61.340     0.200
     4.074    63.141     0.200
     4.074    62.541     0.200
     4.131    63.641     0.200
     8.695   127.840     0.200
     8.695   126.641     0.200
     2.206    35.688     0.200
     2.206    36.289     0.200
     2.226    37.688     0.200
     2.828    45.488     0.200
     2.962    47.887     0.200
     3.625    56.688     0.200
     3.625    56.789     0.200
     3.926    60.387     0.200
     3.954    60.789     0.200
     4.852    73.086     0.200
     5.077    75.789     0.200
     5.580    82.387     0.200
     7.526   111.086     0.200
     8.407   123.488     0.200
     8.606   125.289     0.200
     2.072    34.001     0.200
     2.201    36.400     0.200
     2.694    44.101     0.200
     3.486    54.601     0.200
     3.662    57.001     0.200
     3.662    56.501     0.200
     4.250    63.900     0.200
     4.618    70.200     0.200
     4.646    69.900     0.200
     4.964    73.900     0.200
     5.350    80.200     0.200
     5.931    86.601     0.200
     7.796   114.200     0.200
     7.796   113.400     0.200
     7.881   116.601     0.200
     7.881   115.501     0.200
    10.907   153.700     0.200
     2.302    37.699     0.200
     2.449    40.199     0.200
     2.501    41.199     0.200
     3.241    50.797     0.200
     3.914    60.098     0.200
     4.203    63.297     0.200
     4.271    64.699     0.200
     4.401    66.297     0.200
     4.396    66.699     0.200
     4.826    72.297     0.200
     4.860    73.199     0.200
     4.862    72.598     0.200
     5.154    76.398     0.200
     5.643    84.297     0.200
     5.643    82.797     0.200
     5.684    83.199     0.200
     6.317    91.898     0.200
     6.317    90.898     0.200
     6.355    92.598     0.200
     6.355    92.297     0.200
     6.698    97.297     0.200
     7.456   108.098     0.200
     7.456   108.199     0.200
     7.531   110.297     0.200
     7.539   110.797     0.200
     7.539   110.098     0.200
     7.624   111.297     0.200
     8.451   120.172     0.200
     8.451   119.719     0.200
    10.046   142.098     0.200
    11.157   155.598     0.200
    11.157   155.328     0.200
    14.075   197.898     0.200
    15.175   212.898     0.200
    15.377   215.863     0.200
    15.452   217.898     0.200
    15.984   222.398     0.200
    16.228   226.598     0.200
    16.228   226.418     0.200
    16.320   228.918     0.200
    18.327   255.098     0.200
    18.435   255.098     0.200
    18.430   256.199     0.200
    19.423   266.598     0.200
    20.193   274.996     0.200
     2.334    38.078     0.200
     2.334    38.578     0.200
     2.483    41.480     0.200
     2.499    41.078     0.200
     2.499    41.180     0.200
     3.205    50.879     0.200
     3.963    61.480     0.200
     3.963    61.379     0.200
     4.218    64.180     0.200
     4.365    66.379     0.200
     4.368    67.078     0.200
     4.795    72.078     0.200
     5.202    77.578     0.200
     5.202    77.180     0.200
     5.647    83.578     0.200
     6.358    93.777     0.200
     6.655    97.078     0.200
     7.495   110.578     0.200
     7.577   110.680     0.200
     2.301    37.695     0.200
     2.479    40.695     0.200
     2.479    40.797     0.200
     2.517    41.992     0.200
     2.517    41.891     0.200
     3.237    51.594     0.200
     3.237    51.492     0.200
     3.941    60.992     0.200
     4.243    63.391     0.200
     4.397    65.695     0.200
     4.397    66.695     0.200
     4.402    67.297     0.200
     4.829    73.195     0.200
     5.196    77.391     0.200
     5.196    77.195     0.200
     5.679    83.891     0.200
     6.684    96.695     0.200
     7.523   110.992     0.200
     7.523   111.195     0.200
     9.637   138.297     0.200
     2.299    37.363     0.200
     2.299    38.062     0.200
     2.464    40.363     0.200
     2.512    41.363     0.200
     3.241    51.062     0.200
     3.241    51.465     0.200
     3.927    60.863     0.200
     3.927    60.465     0.200
     4.226    64.262     0.200
     4.401    66.863     0.200
     4.401    66.762     0.200
     4.401    67.562     0.200
     5.131    77.363     0.200
     5.176    76.965     0.200
     6.315    92.664     0.200
     6.375    92.664     0.200
     6.692    97.465     0.200
     7.532   110.965     0.200
     7.614   110.262     0.200
     7.614   111.363     0.200
     2.313    37.855     0.200
     2.313    38.754     0.200
     2.494    41.154     0.200
     2.509    42.154     0.200
     3.224    51.855     0.200
     3.224    51.754     0.200
     3.957    61.654     0.200
     4.245    65.154     0.200
     4.384    66.955     0.200
     5.120    77.855     0.200
     5.210    77.955     0.200
     5.210    78.154     0.200
     5.666    84.955     0.200
     6.296    92.455     0.200
     6.386    93.254     0.200
     6.386    93.355     0.200
     6.670    97.055     0.200
     7.587   111.355     0.200
     9.622   138.955     0.200
     2.299    36.912     0.200
     2.299    37.512     0.200
     2.451    39.711     0.200
     2.451    39.512     0.200
     2.506    41.111     0.200
     3.243    51.412     0.200
     3.915    60.211     0.200
     4.211    63.311     0.200
     4.403    67.311     0.200
     4.400    67.111     0.200
     5.130    77.311     0.200
     5.158    76.611     0.200
     5.687    84.012     0.200
     6.699   100.111     0.200
     7.540   111.412     0.200
     7.624   111.711     0.200
     2.314    38.133     0.200
     3.158    50.031     0.200
     3.224    51.031     0.200
     3.953    61.430     0.200
     4.238    64.328     0.200
     4.238    64.133     0.200
     4.259    66.828     0.200
     4.389    67.531     0.200
     4.384    66.930     0.200
     4.384    66.828     0.200
     4.815    72.727     0.200
     5.118    77.430     0.200
     5.204    77.227     0.200
     5.204    77.633     0.200
     5.621    82.727     0.200
     5.621    83.031     0.200
     5.666    83.531     0.200
     6.296    91.531     0.200
     6.380    93.633     0.200
     6.380    93.031     0.200
     6.671    97.133     0.200
     7.439   108.430     0.200
     7.439   108.531     0.200
     7.510   109.531     0.200
     7.510   109.828     0.200
     7.589   110.430     0.200
     7.589   111.133     0.200
     8.497   120.273     0.200
     8.598   125.523     0.200
    11.180   156.633     0.200
    11.180   156.453     0.200
    14.125   199.430     0.200
    15.221   212.727     0.200
    15.330   214.781     0.200
    15.935   220.430     0.200
    16.351   228.852     0.200
    16.351   229.719     0.200
    19.393   266.031     0.200
     2.301    37.594     0.200
     2.301    37.391     0.200
     2.462    40.492     0.200
     2.509    40.789     0.200
     2.509    41.688     0.200
     3.239    51.188     0.200
     3.926    60.992     0.200
     4.221    63.789     0.200
     4.400    66.891     0.200
     4.400    66.492     0.200
     4.399    67.594     0.200
     4.828    72.789     0.200
     5.172    77.188     0.200
     5.172    76.992     0.200
     5.129    77.789     0.200
     5.640    84.891     0.200
     5.682    83.992     0.200
     6.370    92.992     0.200
     6.692    99.594     0.200
     7.533   110.391     0.200
     7.533   111.094     0.200
     7.615   111.289     0.200
     7.615   111.594     0.200
     8.471   120.242     0.200
     8.471   119.867     0.200
    12.187   172.188     0.200
    15.361   215.344     0.200
    17.338   239.070     0.200
     2.330    38.645     0.200
     2.330    38.145     0.200
     2.518    42.047     0.200
     3.206    51.945     0.200
     3.206    52.348     0.200
     4.250    65.047     0.200
     4.250    64.945     0.200
     4.366    67.047     0.200
     4.366    67.246     0.200
     4.377    67.945     0.200
     4.801    73.348     0.200
     5.232    79.047     0.200
     5.232    78.945     0.200
     6.276    93.547     0.200
     6.386    94.645     0.200
     6.649   100.145     0.200
     6.649    98.145     0.200
     7.421   110.246     0.200
     7.487   110.348     0.200
     7.487   110.547     0.200
     7.564   111.445     0.200
     7.564   111.848     0.200
     8.517   122.645     0.200
     8.591   126.645     0.200
    11.200   159.945     0.200
    15.301   215.070     0.200
    16.360   228.418     0.200
    17.348   240.645     0.200
     2.300    37.477     0.200
     2.300    36.773     0.200
     2.443    40.477     0.200
     2.443    40.273     0.200
     3.243    50.570     0.200
     3.908    60.875     0.200
     4.198    63.977     0.200
     4.404    66.875     0.200
     4.397    67.672     0.200
     5.146    76.875     0.200
     5.146    76.977     0.200
     6.321    94.070     0.200
     7.544   111.273     0.200
     7.544   110.273     0.200
     7.630   111.070     0.200
     2.305    37.773     0.200
     2.499    39.176     0.200
     2.659    42.676     0.200
     3.082    48.477     0.200
     3.326    51.375     0.200
     3.489    55.375     0.200
     3.854    59.574     0.200
     3.825    58.574     0.200
     4.683    71.875     0.200
     4.956    74.273     0.200
     5.405    80.977     0.200
     5.689    83.477     0.200
     7.176   101.863     0.200
     8.326   121.875     0.200
     8.497   125.875     0.200
     8.497   122.855     0.200
    10.731   152.375     0.200
     1.628    28.852     0.200
     2.126    34.752     0.200
     2.126    34.451     0.200
     2.299    38.151     0.200
     2.299    38.552     0.200
     2.934    46.852     0.200
     3.696    56.852     0.200
     3.871    59.352     0.200
     5.181    77.552     0.200
     5.181    77.451     0.200
     6.062    88.852     0.200
     8.191   121.451     0.200
     8.507   124.052     0.200
     8.701   126.651     0.200
     8.701   125.951     0.200
     9.059   130.592     0.200
    10.440   147.651     0.200
    17.269   238.352     0.200
     1.913    32.742     0.200
     2.428    39.844     0.200
     3.253    51.242     0.200
     3.861    59.445     0.200
     4.328    65.344     0.200
     2.309    37.770     0.200
     2.309    37.570     0.200
     2.466    40.570     0.200
     2.499    41.473     0.200
     2.499    41.172     0.200
     3.232    51.270     0.200
     3.930    60.770     0.200
     4.214    65.473     0.200
     4.392    67.070     0.200
     4.392    66.770     0.200
     4.390    67.270     0.200
     5.120    77.172     0.200
     5.172    77.070     0.200
     5.172    77.371     0.200
     5.674    83.672     0.200
     6.307    92.770     0.200
     6.362    92.973     0.200
     6.685    99.473     0.200
     7.526   110.371     0.200
     7.609   111.270     0.200
     8.593   127.473     0.200
    11.168   158.973     0.200
    17.347   240.871     0.200
    20.119   277.371     0.200
     1.539    27.723     0.200
     2.428    39.824     0.200
     2.428    40.422     0.200
     2.783    46.324     0.200
     2.954    47.523     0.200
     3.358    52.324     0.200
     3.702    57.422     0.200
     3.987    61.625     0.200
     3.987    61.824     0.200
     4.804    73.625     0.200
     5.087    77.223     0.200
     5.087    77.922     0.200
     5.738    85.223     0.200
     5.738    85.523     0.200
     7.569   112.625     0.200
     8.460   122.422     0.200
     8.700   126.723     0.200
     8.700   127.223     0.200
    10.617   150.625     0.200
    11.798   165.125     0.200
     2.105    35.508     0.200
     2.276    38.406     0.200
     2.679    44.309     0.200
     3.735    58.207     0.200
     3.735    58.707     0.200
     4.589    70.008     0.200
     5.045    76.109     0.200
     5.045    75.906     0.200
     7.737   114.707     0.200
     7.814   114.906     0.200
     7.814   114.406     0.200
     2.371    39.297     0.200
     2.371    39.094     0.200
     2.465    41.500     0.200
     2.555    42.195     0.200
     3.108    50.500     0.200
     3.165    51.297     0.200
     3.740    59.094     0.200
     4.325    67.094     0.200
     4.338    67.398     0.200
     5.066    77.398     0.200
     5.257    79.297     0.200
     5.606    84.297     0.200
     5.606    84.195     0.200
     6.364    94.195     0.200
     6.364    94.398     0.200
     6.607    98.000     0.200
     7.380   108.000     0.200
     7.446   110.898     0.200
     7.446   110.398     0.200
     7.524   111.000     0.200
    20.126   275.875     0.200
     1.989    35.013     0.200
     1.989    35.113     0.200
     2.332    39.613     0.200
     2.332    40.013     0.200
     2.656    45.013     0.200
     3.366    53.213     0.200
     4.094    63.313     0.200
     1.551    27.648     0.200
     2.357    37.250     0.200
     2.352    38.449     0.200
     2.352    38.051     0.200
     2.801    44.551     0.200
     2.801    44.352     0.200
     2.948    46.750     0.200
     3.782    57.750     0.200
     3.977    60.551     0.200
     4.261    65.051     0.200
     5.549    82.852     0.200
     5.834    85.551     0.200
     5.834    85.148     0.200
     1.795    31.875     0.200
     2.267    38.672     0.200
     2.226    38.273     0.200
     2.838    46.074     0.200
     2.838    45.973     0.200
     3.128    51.273     0.200
     3.566    56.273     0.200
     3.494    55.574     0.200
     4.086    62.773     0.200
     4.086    62.672     0.200
     4.384    67.574     0.200
     4.694    71.375     0.200
     4.694    71.672     0.200
     5.576    84.473     0.200
     5.591    83.973     0.200
     5.684    85.672     0.200
     5.820    86.973     0.200
     5.844    88.074     0.200
     5.762    86.574     0.200
     5.786    86.773     0.200
     5.786    87.273     0.200
     6.193    91.273     0.200
     6.409    94.875     0.200
     6.497    95.574     0.200
     6.497    95.375     0.200
     7.106   104.273     0.200
     7.492   106.754     0.200
     7.492   107.273     0.200
     7.796   113.773     0.200
     7.796   115.172     0.200
     7.796   113.473     0.200
     7.796   114.773     0.200
     8.262   120.574     0.200
     8.262   120.375     0.200
     8.830   128.172     0.200
     8.830   129.574     0.200
     9.138   132.172     0.200
     9.138   132.574     0.200
     9.313   134.172     0.200
     9.313   134.273     0.200
     9.646   139.574     0.200
    11.400   161.574     0.200
    14.104   201.473     0.200
    14.900   211.473     0.200
    14.900   211.184     0.200
    15.344   218.375     0.200
    16.061   226.074     0.200
    16.083   226.125     0.200
    17.129   237.352     0.200
    17.129   238.098     0.200
    17.145   238.074     0.200
    17.735   244.074     0.200
    18.035   251.773     0.200
    19.925   273.672     0.200
    21.026   287.574     0.200
     2.252    37.195     0.200
     2.402    38.789     0.200
     3.211    50.789     0.200
     3.292    51.891     0.200
     3.866    59.492     0.200
     4.452    68.492     0.200
     5.121    76.195     0.200
     2.324    38.172     0.200
     2.484    39.773     0.200
     2.474    41.070     0.200
     3.143    50.867     0.200
     3.217    51.070     0.200
     4.378    66.773     0.200
     4.375    66.969     0.200
     5.174    76.867     0.200
     6.348    92.867     0.200
     6.673    97.070     0.200
     7.514   110.672     0.200
     7.514   110.773     0.200
     7.599   110.867     0.200
     7.599   111.273     0.200
     1.790    31.912     0.200
     1.835    33.113     0.200
     1.835    33.812     0.200
     2.325    39.812     0.200
     3.187    51.312     0.200
     3.961    61.812     0.200
     4.243    65.812     0.200
     1.669    30.389     0.200
     1.963    32.090     0.200
     1.963    31.889     0.200
     2.233    36.488     0.200
     2.844    44.389     0.200
     2.844    44.689     0.200
     3.010    47.689     0.200
     3.010    47.289     0.200
     3.751    58.090     0.200
     3.811    58.090     0.200
     3.868    57.789     0.200
     3.982    60.189     0.200
     4.087    61.988     0.200
     5.222    77.689     0.200
     5.297    78.988     0.200
     6.225    90.389     0.200
     6.510    95.090     0.200
     6.538    95.488     0.200
     7.193   103.889     0.200
     7.193   103.779     0.200
     7.647   111.488     0.200
     7.637   108.289     0.200
     8.520   122.789     0.200
     8.690   124.889     0.200
     9.172   131.289     0.200
    10.366   148.889     0.200
    10.366   147.430     0.200
    11.559   164.988     0.200
    12.573   176.289     0.200
    12.687   180.090     0.200
    15.096   213.789     0.200
    15.223   212.988     0.200
    15.457   216.590     0.200
    15.971   225.840     0.200
    16.550   229.059     0.200
    16.550   229.314     0.200
    16.565   229.289     0.200
    17.172   237.988     0.200
    17.831   248.090     0.200
    19.829   271.289     0.200
     1.918    35.006     0.200
     1.918    35.406     0.200
     2.296    39.206     0.200
     2.296    39.606     0.200
     2.698    44.906     0.200
     3.291    53.006     0.200
     3.291    53.106     0.200
     3.625    58.006     0.200
     4.082    63.106     0.200
     4.218    63.906     0.200
     4.301    66.806     0.200
     4.301    66.906     0.200
     5.448    82.706     0.200
     5.448    83.206     0.200
     6.413    95.306     0.200
     6.576    96.606     0.200
     7.836   115.106     0.200
     7.920   115.306     0.200
     8.486   125.606     0.200
     8.697   127.006     0.200
     8.697   127.406     0.200
     8.826   128.406     0.200
     8.826   128.306     0.200
     9.279   136.006     0.200
     9.487   138.406     0.200
    10.109   145.806     0.200
    10.109   143.646     0.200
    13.043   184.206     0.200
    14.575   209.706     0.200
    15.214   213.006     0.200
    15.447   219.406     0.200
    16.550   231.126     0.200
    16.550   231.931     0.200
    17.149   238.106     0.200
     2.571    42.109     0.200
     2.776    44.812     0.200
     2.727    44.609     0.200
     2.885    45.414     0.200
     2.885    45.016     0.200
     3.675    55.812     0.200
     3.710    57.609     0.200
     3.881    60.016     0.200
     3.881    60.312     0.200
     4.111    63.516     0.200
     4.247    65.211     0.200
     4.297    65.414     0.200
     4.541    69.211     0.200
     5.166    76.516     0.200
     5.166    76.414     0.200
     5.166    76.812     0.200
     5.166    79.312     0.200
     5.170    76.914     0.200
     5.831    85.312     0.200
     5.831    85.516     0.200
     5.831    84.312     0.200
     5.831    86.109     0.200
     6.007    88.711     0.200
     6.257    91.211     0.200
     6.929   101.609     0.200
     7.123   104.711     0.200
     7.750   112.211     0.200
     7.760   112.211     0.200
     7.808   113.812     0.200
     7.808   113.711     0.200
     7.970   115.523     0.200
     8.082   113.750     0.200
     8.139   118.734     0.200
    10.340   145.312     0.200
    10.604   152.016     0.200
    11.288   161.414     0.200
    11.572   163.312     0.200
    11.663   162.516     0.200
    14.568   205.711     0.200
    14.816   210.812     0.200
    15.278   214.312     0.200
    15.945   221.609     0.200
    15.972   224.211     0.200
    16.229   225.711     0.200
    17.710   246.312     0.200
     2.663    42.423     0.200
     3.360    50.623     0.200
     4.609    69.523     0.200
     4.990    73.224     0.200
     6.531    96.724     0.200
     7.758   113.123     0.200
     7.758   112.724     0.200
     7.844   114.023     0.200
     7.844   114.224     0.200
     2.316    40.055     0.200
     2.679    44.855     0.200
     3.303    53.156     0.200
     3.605    58.156     0.200
     4.062    63.453     0.200
     4.498    69.656     0.200
     1.803    31.180     0.200
     1.800    29.980     0.200
     1.800    30.582     0.200
     2.289    37.582     0.200
     2.742    43.680     0.200
     3.158    49.383     0.200
     3.158    49.281     0.200
     3.992    60.781     0.200
     4.210    64.082     0.200
     5.350    80.180     0.200
     6.387    92.582     0.200
     6.387    92.781     0.200
     6.310    92.582     0.200
     8.782   126.582     0.200
     9.119   130.480     0.200
    10.224   147.082     0.200
    12.771   182.383     0.200
    12.948   182.781     0.200
    17.480   244.082     0.200
     1.985    36.238     0.200
     2.520    42.941     0.200
     2.520    42.840     0.200
     2.528    43.840     0.200
     3.314    53.441     0.200
     3.506    55.840     0.200
     3.774    59.738     0.200
     4.405    68.238     0.200
     4.405    67.238     0.200
     5.538    84.141     0.200
     5.538    84.039     0.200
     6.066    91.141     0.200
     6.413    94.840     0.200
     6.413    94.738     0.200
     6.826   101.340     0.200
     7.510   110.234     0.200
     7.510   110.039     0.200
     7.510   109.910     0.200
     7.510   110.441     0.200
     7.621   109.609     0.200
     7.965   115.840     0.200
     8.559   128.238     0.200
     8.837   129.441     0.200
     8.837   129.340     0.200
     9.002   131.539     0.200
     9.227   134.141     0.200
     9.227   134.738     0.200
     9.449   136.582     0.200
    14.909   208.539     0.200
    16.815   234.516     0.200
    20.415   280.266     0.200
     1.614    29.344     0.200
     1.928    35.539     0.200
     2.683    44.844     0.200
     3.299    53.141     0.200
     3.299    53.039     0.200
     4.064    63.141     0.200
     4.064    63.039     0.200
     4.313    67.539     0.200
     4.313    67.039     0.200
     6.042    89.742     0.200
     6.574    96.844     0.200
     7.419   108.938     0.200
     8.841   129.539     0.200
     8.841   130.938     0.200
    10.098   144.844     0.200
    11.555   165.344     0.200
    15.445   218.938     0.200
     1.939    31.324     0.200
     2.004    33.324     0.200
     2.004    33.223     0.200
     2.808    44.223     0.200
     3.466    53.523     0.200
     3.466    53.723     0.200
     3.651    56.324     0.200
     4.655    71.121     0.200
     4.757    71.121     0.200
     4.790    71.223     0.200
     4.790    71.023     0.200
     4.809    71.723     0.200
     4.809    71.922     0.200
     6.480    93.723     0.200
     7.092   102.723     0.200
     7.134   106.121     0.200
     7.981   116.324     0.200
     9.068   129.023     0.200
     1.819    31.293     0.200
     1.819    31.395     0.200
     1.847    31.594     0.200
     1.847    31.293     0.200
     2.346    38.492     0.200
     2.346    38.793     0.200
     2.704    43.293     0.200
     2.704    43.492     0.200
     3.161    49.395     0.200
     3.518    54.492     0.200
     3.915    59.793     0.200
     3.915    59.594     0.200
     4.234    63.992     0.200
     4.234    64.094     0.200
     5.181    77.395     0.200
     5.370    79.793     0.200
     5.370    79.293     0.200
     6.342    93.094     0.200
     6.342    92.395     0.200
     7.669   110.695     0.200
     7.791   114.895     0.200
     8.663   124.094     0.200
     8.824   127.695     0.200
     9.102   130.293     0.200
    12.870   182.543     0.200
    12.870   182.195     0.200
    16.991   236.492     0.200
     2.010    33.641     0.200
     2.717    44.445     0.200
     4.083    62.641     0.200
     4.124    62.641     0.200
     4.124    62.039     0.200
     4.406    66.445     0.200
     4.737    71.344     0.200
     4.737    71.242     0.200
     4.677    70.742     0.200
     4.747    71.945     0.200
     4.975    75.742     0.200
     5.298    79.344     0.200
     5.410    80.344     0.200
     7.090   103.445     0.200
     7.799   113.641     0.200
     7.942   115.742     0.200
     8.050   118.141     0.200
     8.975   131.344     0.200
    20.581   279.242     0.200
     1.897    30.867     0.200
     1.897    30.766     0.200
     2.268    36.668     0.200
     2.790    44.168     0.200
     3.078    47.566     0.200
     3.078    48.168     0.200
     3.700    57.066     0.200
     3.972    59.969     0.200
     4.147    63.668     0.200
     5.284    78.266     0.200
     5.828    85.168     0.200
     6.291    91.168     0.200
     6.291    91.469     0.200
     6.336    92.367     0.200
     7.673   110.168     0.200
     8.739   127.566     0.200
    12.922   182.594     0.200
    17.052   235.168     0.200
    17.430   241.168     0.200
    20.667   279.969     0.200
     2.045    33.238     0.200
     2.045    33.039     0.200
     2.142    35.039     0.200
     2.142    34.938     0.200
     2.711    43.039     0.200
     3.339    49.539     0.200
     3.410    52.738     0.200
     3.525    55.438     0.200
     3.525    55.539     0.200
     3.604    55.139     0.200
     4.226    63.139     0.200
     4.537    68.539     0.200
     4.536    68.039     0.200
     4.646    70.039     0.200
     4.684    70.039     0.200
     4.902    72.539     0.200
     4.902    72.238     0.200
     4.951    73.039     0.200
     5.435    80.339     0.200
     5.603    81.938     0.200
     5.970    86.938     0.200
     6.194    89.539     0.200
     6.441    93.938     0.200
     6.441    93.238     0.200
     6.611    94.839     0.200
     6.611    95.438     0.200
     7.000   102.238     0.200
     7.227   104.539     0.200
     7.738   112.039     0.200
     7.738   111.938     0.200
     7.845   113.938     0.200
     7.935   114.839     0.200
     7.935   114.738     0.200
     8.974   129.679     0.200
    13.841   195.253     0.200
    13.841   195.639     0.200
    15.647   217.813     0.200
     1.375    27.507     0.200
     2.167    36.708     0.200
     2.167    38.208     0.200
     2.616    42.407     0.200
     2.616    42.907     0.200
     2.627    44.308     0.200
     2.840    47.208     0.200
     2.950    49.708     0.200
     2.950    47.607     0.200
     3.818    58.708     0.200
     3.932    61.107     0.200
     4.101    64.808     0.200
     4.075    64.107     0.200
     4.109    64.308     0.200
     4.109    64.507     0.200
     4.806    74.308     0.200
     5.173    78.808     0.200
     5.173    78.407     0.200
     5.372    81.208     0.200
     5.396    82.808     0.200
     5.622    84.407     0.200
     6.045    89.708     0.200
     6.045    89.907     0.200
     6.042    90.507     0.200
     6.042    91.227     0.200
     7.421   111.107     0.200
     8.425   124.407     0.200
    14.053   200.507     0.200
    15.292   215.708     0.200
     1.370    27.526     0.200
     2.167    38.026     0.200
     2.615    43.426     0.200
     2.615    43.626     0.200
     2.624    44.426     0.200
     2.841    47.727     0.200
     2.953    50.026     0.200
     2.953    49.026     0.200
     4.097    64.926     0.200
     4.076    64.227     0.200
     5.168    78.227     0.200
     6.044    90.026     0.200
     6.448    98.727     0.200
     7.301   109.227     0.200
     7.425   111.026     0.200
     8.426   124.846     0.200
    14.049   200.026     0.200
    15.297   216.789     0.200
     1.979    33.297     0.200
     2.037    34.594     0.200
     2.769    44.297     0.200
     3.318    50.594     0.200
     3.480    54.797     0.200
     3.500    55.000     0.200
     3.610    57.094     0.200
     4.431    67.000     0.200
     4.615    70.594     0.200
     4.769    71.797     0.200
     4.807    72.195     0.200
     5.018    75.695     0.200
     5.330    79.797     0.200
     5.449    82.297     0.200
     5.687    84.594     0.200
     6.281    91.898     0.200
     7.095   104.695     0.200
     7.942   116.000     0.200
     8.037   117.195     0.200
     1.554    29.493     0.200
     1.985    35.493     0.200
     2.497    42.692     0.200
     2.538    43.093     0.200
     3.322    53.993     0.200
     3.464    54.393     0.200
     3.812    59.893     0.200
     4.323    67.393     0.200
     4.401    69.292     0.200
     5.344    82.093     0.200
     5.537    85.292     0.200
     5.609    84.093     0.200
     6.446    95.393     0.200
     1.952    33.480     0.200
     2.568    42.883     0.200
     2.568    42.582     0.200
     3.288    52.980     0.200
     3.288    52.781     0.200
     3.486    54.582     0.200
     3.821    59.781     0.200
     4.034    63.980     0.200
     4.092    63.680     0.200
     4.369    68.680     0.200
     4.348    67.281     0.200
     6.416    94.883     0.200
     6.416    94.680     0.200
     6.793    99.281     0.200
     7.927   115.781     0.200
     8.799   129.281     0.200
     8.959   131.383     0.200
     8.959   131.582     0.200
    12.780   182.055     0.200
    16.767   235.707     0.200
     1.532    29.094     0.200
     1.959    34.688     0.200
     2.475    42.391     0.200
     2.563    42.891     0.200
     3.295    52.891     0.200
     3.476    55.992     0.200
     3.824    60.094     0.200
     4.375    68.188     0.200
     8.963   130.594     0.200
     1.547    29.320     0.200
     1.783    31.914     0.200
     1.966    35.016     0.200
     2.553    43.016     0.200
     2.490    41.914     0.200
     2.490    42.617     0.200
     3.300    52.914     0.200
     3.300    53.117     0.200
     3.464    55.914     0.200
     3.489    55.016     0.200
     3.806    59.820     0.200
     3.806    60.016     0.200
     4.035    62.414     0.200
     4.035    64.617     0.200
     4.035    63.016     0.200
     4.104    63.914     0.200
     4.332    67.516     0.200
     4.383    68.617     0.200
     4.383    68.820     0.200
     5.290    79.820     0.200
     5.518    83.719     0.200
     5.586    84.516     0.200
     5.864    87.516     0.200
     5.905    89.219     0.200
     6.130    92.219     0.200
     6.051    90.820     0.200
     6.418    94.617     0.200
     6.418    94.820     0.200
     6.806   101.320     0.200
     6.834   101.320     0.200
     6.834   101.914     0.200
     7.046   103.516     0.200
     7.489   110.719     0.200
     7.489   109.633     0.200
     7.489   109.992     0.200
     7.489   110.820     0.200
     7.489   109.125     0.200
     7.646   109.914     0.200
     8.015   117.320     0.200
     7.942   116.219     0.200
     8.541   125.516     0.200
     8.813   128.914     0.200
     8.813   129.320     0.200
     8.975   130.820     0.200
     9.221   135.617     0.200
     9.221   134.539     0.200
     9.441   137.414     0.200
    10.075   142.219     0.200
    11.055   157.820     0.200
    11.780   166.617     0.200
    12.278   176.016     0.200
    12.765   181.367     0.200
    12.765   183.719     0.200
    14.381   206.117     0.200
    15.144   215.219     0.200
    15.144   214.414     0.200
    15.283   217.914     0.200
    15.726   221.516     0.200
    15.660   221.414     0.200
    16.080   228.016     0.200
    16.101   226.617     0.200
    16.503   231.516     0.200
    16.503   232.852     0.200
    16.784   234.047     0.200
    18.041   250.719     0.200
    18.374   253.719     0.200
    19.766   271.805     0.200
    19.766   272.016     0.200
    19.766   271.305     0.200
    19.981   274.914     0.200
    19.952   274.719     0.200
    20.434   279.289     0.200
    20.438   279.969     0.200
    20.438   279.516     0.200
    20.704   283.219     0.200
     1.976    35.523     0.200
     1.976    35.422     0.200
     2.548    43.125     0.200
     2.548    42.922     0.200
     3.314    54.023     0.200
     3.314    53.625     0.200
     3.462    56.023     0.200
     3.464    54.820     0.200
     3.820    60.125     0.200
     4.059    61.820     0.200
     4.392    68.219     0.200
     6.442    95.219     0.200
     6.442    95.422     0.200
     1.976    35.719     0.200
     2.486    43.219     0.200
     2.549    43.219     0.200
     2.549    42.719     0.200
     3.313    53.617     0.200
     3.463    53.922     0.200
     3.462    55.719     0.200
     3.821    60.320     0.200
     3.821    60.219     0.200
     4.391    68.516     0.200
     6.442    95.320     0.200
     6.442    95.516     0.200
    10.062   144.516     0.200
     1.967    34.691     0.200
     2.482    41.492     0.200
     2.555    43.094     0.200
     3.305    52.793     0.200
     3.471    54.793     0.200
     3.469    54.691     0.200
     3.821    59.992     0.200
     4.108    65.293     0.200
     4.384    68.793     0.200
     6.433    95.492     0.200
     8.971   129.691     0.200
     1.998    37.293     0.200
     2.521    42.590     0.200
     2.521    42.891     0.200
     2.517    42.992     0.200
     2.517    42.492     0.200
     3.332    53.590     0.200
     3.332    53.191     0.200
     3.434    55.590     0.200
     3.475    54.891     0.200
     3.790    59.793     0.200
     3.790    59.691     0.200
     4.303    67.191     0.200
     4.416    69.590     0.200
     5.551    84.492     0.200
     6.082    91.293     0.200
     6.084    93.191     0.200
     6.442    96.191     0.200
     6.442    95.391     0.200
     8.845   130.793     0.200
     9.006   131.590     0.200
     9.472   139.168     0.200
    10.042   146.793     0.200
    11.085   160.590     0.200
    12.750   182.066     0.200
    16.871   236.090     0.200
    20.402   279.602     0.200
     1.597    29.375     0.200
     2.540    43.176     0.200
     2.540    42.777     0.200
     2.499    42.477     0.200
     2.499    42.578     0.200
     3.350    53.477     0.200
     3.412    55.578     0.200
     3.477    55.777     0.200
     3.770    59.578     0.200
     4.436    67.578     0.200
     4.436    69.375     0.200
     4.281    65.875     0.200
     6.448    94.875     0.200
     6.448    95.078     0.200
     9.028   130.977     0.200
     9.028   131.176     0.200
    17.787   245.328     0.200
     1.559    30.429     0.200
     1.985    35.429     0.200
     1.985    36.629     0.200
     1.985    36.829     0.200
     2.502    42.429     0.200
     2.502    43.028     0.200
     2.536    43.129     0.200
     2.536    42.729     0.200
     3.472    54.929     0.200
     3.321    53.429     0.200
     3.449    55.829     0.200
     4.402    69.129     0.200
     4.402    69.329     0.200
     5.538    85.329     0.200
     6.097    91.429     0.200
     8.991   131.829     0.200
    17.769   245.754     0.200
     1.182    24.750     0.200
     1.886    33.750     0.200
     2.373    39.648     0.200
     3.235    51.953     0.200
     3.440    54.148     0.200
     3.571    57.453     0.200
     3.927    61.352     0.200
     4.295    67.453     0.200
     4.446    69.047     0.200
     5.434    82.953     0.200
     6.242    93.250     0.200
     6.427    94.250     0.200
     8.869   129.953     0.200
     1.969    34.762     0.200
     2.489    42.160     0.200
     2.489    42.461     0.200
     2.551    42.762     0.200
     2.551    42.461     0.200
     3.304    52.562     0.200
     3.304    52.863     0.200
     3.463    55.562     0.200
     3.810    59.660     0.200
     3.810    59.863     0.200
     4.042    62.160     0.200
     4.386    68.863     0.200
     4.386    66.461     0.200
     4.332    66.961     0.200
     5.521    83.262     0.200
     6.055    90.562     0.200
     6.055    91.262     0.200
     6.425    94.363     0.200
     7.492   108.660     0.200
     7.653   109.461     0.200
     8.544   126.961     0.200
     8.815   129.062     0.200
     8.976   130.961     0.200
     8.976   131.461     0.200
     9.226   132.363     0.200
    10.071   142.660     0.200
    12.769   183.461     0.200
    12.769   179.562     0.200
    16.891   235.461     0.200
    17.774   247.562     0.200
     2.850    45.644     0.200
     3.232    51.243     0.200
     3.392    51.543     0.200
     3.791    59.443     0.200
     4.157    64.843     0.200
     4.492    67.843     0.200
     4.943    74.543     0.200
     5.044    76.144     0.200
     6.894   102.443     0.200
     8.292   119.843     0.200
     1.960    35.129     0.200
     2.484    42.828     0.200
     2.559    43.328     0.200
     2.559    43.129     0.200
     3.294    52.828     0.200
     3.294    53.328     0.200
     3.470    56.027     0.200
     3.491    55.129     0.200
     3.810    60.129     0.200
     3.810    60.230     0.200
     4.031    61.629     0.200
     4.031    62.527     0.200
     4.377    69.129     0.200
     4.377    69.328     0.200
     4.338    67.430     0.200
     4.739    73.527     0.200
     5.284    81.027     0.200
     5.858    89.328     0.200
     6.414    95.230     0.200
     6.800   100.430     0.200
     6.828   101.730     0.200
     7.040   104.129     0.200
     7.483   109.527     0.200
     7.483   109.230     0.200
     7.483   108.410     0.200
     7.646   109.828     0.200
     7.936   116.629     0.200
     8.020   116.730     0.200
     8.807   129.828     0.200
     8.969   132.027     0.200
     9.215   132.930     0.200
     9.215   133.301     0.200
    11.050   159.629     0.200
    11.211   162.027     0.200
    12.769   181.730     0.200
    12.769   183.230     0.200
    14.386   205.730     0.200
    15.280   215.527     0.200
    16.779   234.109     0.200
    16.779   235.281     0.200
    16.779   236.230     0.200
    20.842   285.113     0.200
     1.617    29.777     0.200
     1.530    28.180     0.200
     2.469    41.480     0.200
     2.445    39.777     0.200
     2.826    45.980     0.200
     2.910    46.578     0.200
     3.372    52.578     0.200
     3.661    57.277     0.200
     3.661    57.379     0.200
     4.032    63.578     0.200
     4.032    63.680     0.200
     4.556    69.777     0.200
     5.132    77.078     0.200
     5.132    77.480     0.200
     5.365    80.680     0.200
     5.567    83.480     0.200
     5.757    85.379     0.200
     5.757    85.480     0.200
     7.972   116.777     0.200
     8.625   124.777     0.200
     8.746   126.180     0.200
     8.746   127.578     0.200
     8.858   129.898     0.200
    16.978   235.379     0.200
    18.319   251.180     0.200
     1.802    32.396     0.200
     1.832    31.098     0.200
     2.312    38.598     0.200
     2.730    43.697     0.200
     3.150    49.498     0.200
     3.494    53.297     0.200
     3.947    61.297     0.200
     3.955    60.498     0.200
     3.991    61.396     0.200
     3.991    60.197     0.200
     4.214    65.197     0.200
     4.512    68.396     0.200
     5.352    80.197     0.200
     5.352    79.896     0.200
     5.438    81.896     0.200
     5.662    84.197     0.200
     5.900    88.098     0.200
     6.258    93.396     0.200
     7.320   105.896     0.200
     7.703   110.797     0.200
     8.638   125.396     0.200
     8.796   127.297     0.200
     8.796   128.297     0.200
     9.316   133.943     0.200
    11.040   157.697     0.200
    12.276   176.697     0.200
    12.910   184.172     0.200
    16.983   235.697     0.200
    17.722   245.098     0.200
     2.104    35.477     0.200
     2.459    40.277     0.200
     2.459    40.176     0.200
     2.544    41.477     0.200
     3.315    50.977     0.200
     3.455    53.574     0.200
     3.851    58.875     0.200
     3.851    58.977     0.200
     4.269    64.676     0.200
     4.221    63.676     0.200
     4.509    69.176     0.200
     4.509    69.074     0.200
     5.650    83.375     0.200
     5.743    84.875     0.200
     6.061    90.277     0.200
     6.205    92.176     0.200
     6.939   101.074     0.200
     7.176   105.277     0.200
     7.615   110.574     0.200
     7.615   109.074     0.200
     8.922   129.875     0.200
     9.063   132.074     0.200
     9.397   134.977     0.200
     9.615   138.297     0.200
    12.814   180.227     0.200
     2.481    42.250     0.200
     2.481    42.648     0.200
     2.562    43.453     0.200
     3.290    53.352     0.200
     3.290    53.055     0.200
     3.492    55.148     0.200
     3.812    60.148     0.200
     4.029    62.750     0.200
     4.029    61.250     0.200
     4.341    67.148     0.200
     4.374    68.953     0.200
     4.374    68.055     0.200
     5.509    84.055     0.200
     5.809    88.750     0.200
     5.854    87.648     0.200
     6.139    92.352     0.200
     6.412    94.852     0.200
     6.797   102.555     0.200
     7.036   104.555     0.200
     7.480   110.055     0.200
     8.804   128.250     0.200
     8.966   131.352     0.200
     8.966   131.750     0.200
     9.212   133.953     0.200
    11.046   159.852     0.200
    11.207   163.250     0.200
    17.781   245.852     0.200
     2.068    35.313     0.200
     2.499    41.313     0.200
     2.502    41.013     0.200
     3.424    52.413     0.200
     3.892    59.513     0.200
     4.470    68.513     0.200
     5.612    83.313     0.200
     6.598    95.613     0.200
     2.470    42.641     0.200
     2.575    43.039     0.200
     3.278    52.844     0.200
     3.820    60.141     0.200
     4.023    60.539     0.200
     4.361    68.742     0.200
     5.564    85.344     0.200
     6.030    90.141     0.200
     6.405    94.242     0.200
     8.953   132.242     0.200
     1.148    24.375     0.200
     1.343    26.875     0.200
     2.585    43.777     0.200
     2.585    43.676     0.200
     2.723    45.477     0.200
     2.744    45.078     0.200
     2.907    49.176     0.200
     2.907    49.277     0.200
     3.367    54.777     0.200
     3.875    61.977     0.200
     4.057    64.277     0.200
     4.057    64.176     0.200
     4.033    61.477     0.200
     4.056    64.176     0.200
     4.056    63.676     0.200
     4.420    67.676     0.200
     4.694    72.875     0.200
     4.971    76.676     0.200
     4.964    76.977     0.200
     4.991    76.477     0.200
     4.991    76.277     0.200
     5.579    84.777     0.200
     5.791    85.477     0.200
     5.814    86.977     0.200
     6.012    90.820     0.200
     6.012    90.457     0.200
     6.445    97.078     0.200
     7.102   105.176     0.200
     7.312   109.176     0.200
     7.478   111.578     0.200
     8.087   118.977     0.200
     8.264   121.957     0.200
     9.312   137.578     0.200
     9.714   142.176     0.200
    13.840   197.875     0.200
    13.840   195.176     0.200
    15.456   218.688     0.200
    15.456   218.527     0.200
    15.674   219.078     0.200
    17.300   240.277     0.200
    17.599   243.676     0.200
    17.599   244.027     0.200
     1.961    35.702     0.200
     2.486    42.102     0.200
     2.557    43.702     0.200
     3.295    53.202     0.200
     3.492    55.402     0.200
     3.469    56.602     0.200
     3.808    60.502     0.200
     4.031    63.202     0.200
     4.031    62.702     0.200
     4.099    64.602     0.200
     4.336    68.002     0.200
     4.378    68.802     0.200
     4.378    69.102     0.200
     5.285    81.202     0.200
     5.513    84.102     0.200
     5.513    83.802     0.200
     5.581    85.002     0.200
     5.814    88.202     0.200
     6.113    92.202     0.200
     6.418    96.702     0.200
     6.414    95.302     0.200
     6.414    94.902     0.200
     6.801   101.602     0.200
     7.041   104.902     0.200
     7.484   111.002     0.200
     7.484   109.602     0.200
     7.644   110.902     0.200
     7.644   110.502     0.200
     7.937   117.402     0.200
     8.536   125.502     0.200
     8.809   129.802     0.200
     8.809   128.802     0.200
     8.971   131.202     0.200
     9.216   137.002     0.200
     9.216   136.562     0.200
     9.436   137.941     0.200
     9.436   138.302     0.200
    10.080   142.722     0.200
    11.051   158.401     0.200
    12.767   183.102     0.200
    12.767   183.901     0.200
    16.098   230.002     0.200
    16.504   233.802     0.200
    16.504   232.677     0.200
    16.504   234.002     0.200
    16.780   234.122     0.200
    16.780   234.177     0.200
    16.780   236.502     0.200
    17.142   239.502     0.200
    19.984   277.202     0.200
     1.557    29.883     0.200
     1.747    31.781     0.200
     1.992    35.484     0.200
     1.992    37.086     0.200
     1.992    35.984     0.200
     1.992    36.984     0.200
     2.533    42.984     0.200
     2.533    42.680     0.200
     2.500    42.586     0.200
     3.447    56.086     0.200
     3.330    53.680     0.200
     3.455    54.781     0.200
     3.814    60.180     0.200
     4.071    63.281     0.200
     4.071    63.180     0.200
     4.319    66.680     0.200
     4.408    69.180     0.200
     4.408    68.484     0.200
     5.544    84.586     0.200
     5.544    84.484     0.200
     5.892    88.383     0.200
     6.099    91.383     0.200
     6.116    92.984     0.200
     6.081    91.781     0.200
     6.455    95.680     0.200
     6.455    95.383     0.200
     6.832   102.180     0.200
     7.514   110.883     0.200
     7.514   112.289     0.200
     7.674   111.680     0.200
     7.674   110.203     0.200
     8.016   117.484     0.200
     7.964   117.984     0.200
     7.964   118.484     0.200
     8.568   126.383     0.200
     8.568   128.281     0.200
     8.835   130.180     0.200
     8.835   129.883     0.200
     8.992   131.984     0.200
     8.992   131.086     0.200
     9.255   135.281     0.200
     9.475   138.242     0.200
    10.045   142.180     0.200
    10.045   144.383     0.200
    11.237   161.281     0.200
    12.467   177.984     0.200
    12.774   182.555     0.200
    16.787   236.164     0.200
    16.787   234.734     0.200
    16.787   235.586     0.200
    17.159   240.383     0.200
    19.836   273.086     0.200
    20.408   280.156     0.200
     1.858    34.055     0.200
     2.357    40.555     0.200
     2.357    40.754     0.200
     2.677    44.453     0.200
     3.206    51.754     0.200
     3.465    54.055     0.200
     3.592    57.254     0.200
     3.929    61.355     0.200
     4.003    62.555     0.200
     4.269    67.254     0.200
     4.464    68.656     0.200
     5.407    81.953     0.200
     5.717    85.953     0.200
     5.800    86.855     0.200
     5.955    88.453     0.200
     6.242    92.855     0.200
     6.313    94.055     0.200
     6.398    94.254     0.200
     6.398    94.555     0.200
     6.696    98.855     0.200
     6.718   101.453     0.200
     7.375   108.754     0.200
     7.375   109.727     0.200
     7.713   111.055     0.200
     7.822   114.156     0.200
     8.146   120.453     0.200
     8.434   124.754     0.200
     8.692   127.055     0.200
     8.847   129.254     0.200
     9.153   134.754     0.200
     9.369   136.613     0.200
     9.369   137.055     0.200
    10.173   144.254     0.200
    10.173   146.953     0.200
    10.173   146.094     0.200
    12.886   183.531     0.200
    15.267   219.156     0.200
    16.608   234.281     0.200
    16.651   233.734     0.200
    16.651   233.629     0.200
    19.018   265.156     0.200
    20.544   281.254     0.200
    20.583   283.453     0.200
    20.913   287.156     0.200
     1.872    33.195     0.200
     1.872    34.195     0.200
     1.872    33.996     0.200
     2.669    44.297     0.200
     2.669    43.996     0.200
     3.222    51.797     0.200
     3.222    50.695     0.200
     3.445    53.895     0.200
     3.936    61.297     0.200
     4.049    63.695     0.200
     4.281    67.094     0.200
     4.281    66.895     0.200
     4.459    68.297     0.200
     5.420    81.996     0.200
     5.732    86.395     0.200
     5.971    89.594     0.200
     6.418    94.496     0.200
     6.709   100.094     0.200
     8.149   120.496     0.200
     8.448   124.297     0.200
     8.702   125.996     0.200
     8.702   126.195     0.200
     8.855   129.297     0.200
     8.855   128.996     0.200
     9.172   134.695     0.200
     9.387   136.375     0.200
    10.158   144.945     0.200
    10.158   146.195     0.200
    12.893   184.969     0.200
    16.650   234.516     0.200
    16.619   233.797     0.200
    16.916   234.895     0.200
    17.696   245.594     0.200
     1.430    27.797     0.200
     2.373    40.996     0.200
     2.657    44.898     0.200
     2.657    44.598     0.200
     3.230    52.297     0.200
     3.230    52.398     0.200
     3.447    54.398     0.200
     3.924    61.797     0.200
     3.924    61.996     0.200
     4.028    63.398     0.200
     4.049    63.699     0.200
     4.292    67.797     0.200
     4.446    69.398     0.200
     5.210    80.496     0.200
     5.430    82.297     0.200
     5.430    82.496     0.200
     5.742    86.398     0.200
     5.980    90.797     0.200
     6.226    93.496     0.200
     6.337    95.598     0.200
     6.420    95.098     0.200
     6.420    94.898     0.200
     6.719   100.398     0.200
     7.723   112.398     0.200
     7.845   115.199     0.200
     8.458   125.996     0.200
     8.714   127.699     0.200
     8.714   127.898     0.200
     8.867   130.098     0.200
     9.394   137.637     0.200
    10.149   145.398     0.200
    12.882   184.996     0.200
    16.663   235.098     0.200
    16.912   235.086     0.200
    17.703   246.699     0.200
     2.378    40.934     0.200
     2.649    44.133     0.200
     3.242    52.133     0.200
     3.242    52.234     0.200
     3.435    54.633     0.200
     3.925    61.434     0.200
     3.925    61.535     0.200
     4.062    63.133     0.200
     4.062    61.836     0.200
     4.302    67.434     0.200
     4.302    67.734     0.200
     9.407   137.555     0.200
    10.137   143.785     0.200
    10.137   143.246     0.200
    12.883   183.809     0.200
    14.500   207.234     0.200
    15.251   216.426     0.200
    15.302   218.133     0.200
    16.125   227.836     0.200
    16.146   227.836     0.200
    16.666   233.305     0.200
    16.666   235.062     0.200
    16.614   234.633     0.200
    17.039   238.836     0.200
    18.493   257.133     0.200
    19.055   263.633     0.200
    19.717   271.426     0.200
    19.856   273.633     0.200
    20.000   275.035     0.200
    20.524   281.035     0.200
    20.509   280.734     0.200
    20.614   282.336     0.200
    20.931   285.184     0.200
     3.915    61.562     0.200
     9.397   138.582     0.200
    11.122   158.961     0.200
    12.873   184.312     0.200
    16.601   233.797     0.200
    17.041   236.664     0.200
    16.911   236.664     0.200
    20.092   276.863     0.200
    20.916   284.641     0.200
     1.904    35.547     0.200
     2.392    41.246     0.200
     2.392    41.047     0.200
     2.636    44.547     0.200
     3.252    53.145     0.200
     3.252    52.746     0.200
     3.438    54.645     0.200
     3.912    61.645     0.200
     4.063    62.547     0.200
     4.049    64.145     0.200
     4.314    68.645     0.200
     4.314    66.945     0.200
     4.426    69.145     0.200
     5.232    80.246     0.200
     5.452    82.746     0.200
     5.763    87.047     0.200
     5.846    88.945     0.200
     6.002    90.645     0.200
     6.207    93.246     0.200
     6.359    95.945     0.200
     7.725   111.145     0.200
     8.121   119.945     0.200
     8.480   125.047     0.200
     8.735   127.246     0.200
     8.735   128.645     0.200
     8.888   130.246     0.200
     8.888   129.945     0.200
     9.414   137.773     0.200
    10.127   144.445     0.200
    11.136   161.645     0.200
    12.871   182.621     0.200
    16.680   233.523     0.200
    16.895   236.445     0.200
    17.701   246.145     0.200
    20.498   280.645     0.200
     1.444    27.621     0.200
     1.906    33.922     0.200
     1.906    35.320     0.200
     1.906    35.219     0.200
     2.387    40.922     0.200
     2.637    43.820     0.200
     2.637    43.520     0.200
     3.256    52.219     0.200
     3.425    54.422     0.200
     3.922    61.121     0.200
     4.315    68.520     0.200
     4.315    67.121     0.200
     4.430    68.219     0.200
     5.454    82.820     0.200
     5.454    82.020     0.200
     6.006    90.121     0.200
     6.212    92.219     0.200
     6.446    94.719     0.200
     6.446    94.219     0.200
     8.734   127.121     0.200
     1.116    23.637     0.200
     1.870    33.938     0.200
     1.870    34.039     0.200
     1.870    35.137     0.200
     2.364    40.637     0.200
     2.667    44.836     0.200
     2.667    44.539     0.200
     3.219    52.438     0.200
     3.219    52.238     0.200
     3.453    55.137     0.200
     3.929    61.938     0.200
     4.016    63.238     0.200
     4.280    67.637     0.200
     4.280    66.039     0.200
     5.419    83.238     0.200
     5.419    81.438     0.200
     5.969    89.938     0.200
     6.235    93.438     0.200
     6.411    94.938     0.200
     6.411    95.039     0.200
     7.387   108.438     0.200
     8.703   127.438     0.200
     8.857   130.039     0.200
     9.383   137.219     0.200
    10.160   143.082     0.200
    12.886   182.453     0.200
    17.705   244.480     0.200
    20.531   281.246     0.200
     1.198    25.227     0.200
     1.420    27.227     0.200
     1.866    34.727     0.200
     2.363    40.527     0.200
     2.363    40.426     0.200
     2.670    44.227     0.200
     3.214    51.727     0.200
     3.214    51.527     0.200
     3.459    54.426     0.200
     3.927    61.328     0.200
     4.012    62.625     0.200
     4.277    67.227     0.200
     5.415    82.828     0.200
     5.415    81.727     0.200
     5.964    89.625     0.200
     6.405    94.625     0.200
     6.405    94.227     0.200
     8.699   127.727     0.200
     9.377   137.219     0.200
    10.165   143.828     0.200
    12.884   183.984     0.200
    16.655   234.793     0.200
    16.928   236.426     0.200
    17.709   245.426     0.200
     2.651    44.152     0.200
     3.241    52.352     0.200
     3.434    54.352     0.200
     3.927    61.453     0.200
     4.038    62.555     0.200
     4.300    67.652     0.200
     5.439    81.652     0.200
     5.991    90.453     0.200
     6.223    92.953     0.200
     8.721   128.254     0.200
     8.873   128.852     0.200
     1.385    26.559     0.200
     1.865    33.658     0.200
     1.865    34.158     0.200
     2.327    39.258     0.200
     3.223    51.258     0.200
     3.984    62.758     0.200
     4.015    63.357     0.200
     4.084    62.258     0.200
     4.268    66.559     0.200
     5.410    81.357     0.200
     5.410    83.357     0.200
     5.728    86.258     0.200
     5.772    88.357     0.200
     5.970    89.459     0.200
     6.699   101.059     0.200
     6.717   100.857     0.200
     7.375   108.953     0.200
     7.375   108.459     0.200
     7.375   108.158     0.200
     7.375   107.979     0.200
     7.817   115.857     0.200
     7.817   116.459     0.200
     8.192   118.758     0.200
     8.684   126.459     0.200
     8.684   129.758     0.200
     8.684   126.059     0.200
     8.831   128.357     0.200
     8.831   128.459     0.200
     9.185   135.758     0.200
     9.185   133.598     0.200
     9.398   135.959     0.200
     9.398   136.857     0.200
    10.902   158.559     0.200
    12.942   183.107     0.200
    12.942   182.857     0.200
    14.437   203.559     0.200
    15.307   217.758     0.200
    15.319   218.658     0.200
    16.176   229.559     0.200
    16.610   233.748     0.200
    16.610   233.709     0.200
    16.610   234.758     0.200
    16.610   233.848     0.200
    16.670   234.559     0.200
    16.670   235.498     0.200
    16.670   233.887     0.200
    16.670   234.268     0.200
    17.013   239.258     0.200
    16.990   236.559     0.200
    20.159   280.658     0.200
     2.074    34.430     0.200
     2.032    33.930     0.200
     2.670    43.227     0.200
     2.670    42.930     0.200
     3.446    52.133     0.200
     3.502    54.328     0.200
     3.396    53.133     0.200
     4.039    61.727     0.200
     4.080    61.328     0.200
     4.080    61.727     0.200
     4.428    67.430     0.200
     4.541    68.828     0.200
     4.734    70.328     0.200
     4.734    70.430     0.200
     4.708    70.930     0.200
     4.708    71.133     0.200
     4.930    74.430     0.200
     5.316    78.727     0.200
     5.128    77.031     0.200
     5.625    83.133     0.200
     5.981    86.633     0.200
     5.981    87.430     0.200
     5.997    87.930     0.200
     6.225    90.828     0.200
     6.319    91.828     0.200
     6.650    96.430     0.200
     7.109   103.133     0.200
     7.101   103.227     0.200
     7.057   101.828     0.200
     7.057   101.727     0.200
     7.759   112.633     0.200
     7.759   113.031     0.200
     7.910   114.930     0.200
     7.910   115.430     0.200
     8.024   116.430     0.200
     8.024   116.531     0.200
     8.172   115.430     0.200
     8.172   115.297     0.200
     8.745   127.328     0.200
     8.745   126.320     0.200
     8.990   129.328     0.200
     8.927   129.188     0.200
    10.835   151.547     0.200
    10.835   151.133     0.200
    11.305   161.227     0.200
    12.153   171.328     0.200
    13.667   191.656     0.200
    13.667   192.828     0.200
    14.045   195.727     0.200
    15.481   217.031     0.200
    15.795   218.406     0.200
    15.795   220.180     0.200
    15.795   219.711     0.200
    15.880   224.656     0.200
    16.166   226.633     0.200
    16.220   227.227     0.200
    17.284   241.727     0.200
    19.800   271.328     0.200
    20.940   287.227     0.200
     2.861    45.871     0.200
     3.245    51.271     0.200
     3.365    52.071     0.200
     3.608    56.371     0.200
     4.172    64.271     0.200
     4.110    64.571     0.200
     4.252    65.171     0.200
     4.522    68.071     0.200
     4.944    74.571     0.200
     5.061    75.571     0.200
     5.309    79.472     0.200
     5.349    80.571     0.200
     5.577    83.972     0.200
     6.225    90.271     0.200
     6.394    93.071     0.200
     6.464    94.671     0.200
     6.853   101.871     0.200
     6.892   100.472     0.200
     6.892    99.671     0.200
     7.306   106.171     0.200
     7.991   117.972     0.200
     7.991   117.671     0.200
     8.162   118.972     0.200
     8.162   118.871     0.200
     8.280   120.271     0.200
     8.280   119.871     0.200
     8.759   126.972     0.200
     8.914   129.771     0.200
     8.914   130.671     0.200
     9.105   131.915     0.200
    10.600   151.781     0.200
    10.600   148.642     0.200
    10.600   152.071     0.200
    10.549   153.071     0.200
    13.468   190.959     0.200
    13.468   191.472     0.200
    16.035   224.411     0.200
    16.035   224.446     0.200
    16.422   229.472     0.200
    17.126   239.204     0.200
    17.361   237.871     0.200
    20.052   275.071     0.200
    20.421   277.871     0.200
     2.051    33.133     0.200
     2.595    41.434     0.200
     2.595    41.836     0.200
     2.560    41.133     0.200
     3.174    49.633     0.200
     3.483    53.734     0.200
     3.767    56.133     0.200
     3.639    55.934     0.200
     3.773    58.434     0.200
     3.773    57.133     0.200
     3.995    61.133     0.200
     4.316    65.633     0.200
     4.320    67.133     0.200
     4.320    67.336     0.200
     5.440    80.836     0.200
     5.440    80.734     0.200
     5.708    84.535     0.200
     6.070    89.133     0.200
     6.118    90.434     0.200
     6.166    89.934     0.200
     6.336    92.734     0.200
     6.724    98.234     0.200
     6.772    99.336     0.200
     6.772    99.234     0.200
     6.968   101.234     0.200
     7.376   104.812     0.200
     7.419   107.633     0.200
     7.419   107.434     0.200
     7.893   114.336     0.200
     7.895   113.633     0.200
     8.443   122.734     0.200
     8.776   126.836     0.200
     8.776   126.535     0.200
     8.973   128.633     0.200
     9.029   130.656     0.200
     9.029   130.434     0.200
     9.029   130.535     0.200
     9.258   133.516     0.200
     9.750   138.234     0.200
    11.189   161.234     0.200
    11.956   169.336     0.200
    12.586   179.160     0.200
    12.586   179.035     0.200
    13.094   183.836     0.200
    14.253   200.336     0.200
    14.908   208.594     0.200
    14.908   210.734     0.200
    15.026   213.734     0.200
    15.412   217.336     0.200
    15.805   222.035     0.200
    15.827   222.113     0.200
    16.278   225.473     0.200
    16.278   226.484     0.200
    16.884   234.473     0.200
    16.884   234.309     0.200
    16.884   234.695     0.200
    17.173   239.035     0.200
    18.386   256.336     0.200
    19.677   270.234     0.200
    20.530   278.785     0.200
    20.575   279.684     0.200
    20.660   280.734     0.200
     2.157    37.891     0.200
     2.658    43.891     0.200
     2.719    45.289     0.200
     2.807    46.789     0.200
     2.891    48.090     0.200
     2.891    47.789     0.200
     3.081    50.188     0.200
     3.183    51.590     0.200
     3.815    58.891     0.200
     3.915    61.289     0.200
     3.920    61.289     0.200
     3.994    62.188     0.200
     4.192    65.688     0.200
     4.051    63.391     0.200
     4.353    68.090     0.200
     4.470    69.090     0.200
     4.508    70.289     0.200
     4.769    73.789     0.200
     5.115    78.590     0.200
     4.970    76.090     0.200
     5.281    79.988     0.200
     5.281    79.688     0.200
     5.304    80.188     0.200
     5.336    80.789     0.200
     5.559    83.590     0.200
     5.992    89.891     0.200
     5.976    88.508     0.200
     5.976    88.988     0.200
     5.976    88.758     0.200
     5.976    89.098     0.200
     6.083    90.590     0.200
     6.083    90.488     0.200
     6.369    94.391     0.200
     7.106   105.289     0.200
     7.106   105.590     0.200
     7.219   107.488     0.200
     7.331   109.090     0.200
     8.248   121.590     0.200
     8.248   121.988     0.200
     8.248   121.738     0.200
     8.248   122.250     0.200
     8.359   119.891     0.200
     8.359   120.289     0.200
     8.408   124.328     0.200
     8.408   123.688     0.200
     9.583   139.391     0.200
     9.602   141.090     0.200
    11.271   161.789     0.200
    11.500   161.957     0.200
    11.500   161.750     0.200
    14.161   201.105     0.200
    14.161   201.391     0.200
    14.354   204.090     0.200
    14.888   213.289     0.200
    15.091   215.590     0.200
    15.185   213.738     0.200
    15.185   213.801     0.200
    15.185   214.488     0.200
    15.185   213.398     0.200
    15.983   227.988     0.200
    16.077   227.688     0.200
    17.366   242.590     0.200
    18.165   252.188     0.200
    18.425   256.590     0.200
    18.496   259.188     0.200
    19.107   265.488     0.200
    20.247   280.289     0.200
    20.399   280.113     0.200
     2.450    40.072     0.200
     2.582    42.072     0.200
     2.582    41.672     0.200
     3.401    52.772     0.200
     3.363    52.972     0.200
     3.745    57.672     0.200
     4.094    63.572     0.200
     4.094    61.272     0.200
     4.207    64.072     0.200
     4.235    64.272     0.200
     4.488    67.972     0.200
     4.488    67.472     0.200
     4.599    68.672     0.200
     4.615    68.972     0.200
     4.848    72.872     0.200
     5.394    79.972     0.200
     5.622    83.472     0.200
     5.687    83.972     0.200
     5.921    87.572     0.200
     6.031    88.972     0.200
     6.153    90.872     0.200
     6.486    94.472     0.200
     6.910   100.272     0.200
     7.150   103.972     0.200
     7.388   105.297     0.200
     7.594   109.365     0.200
     7.594   109.872     0.200
     7.594   109.702     0.200
     7.594   108.872     0.200
     7.648   108.372     0.200
     7.648   109.582     0.200
     7.648   109.082     0.200
     7.938   114.572     0.200
     8.645   126.172     0.200
     8.917   128.572     0.200
     9.076   130.572     0.200
     9.312   133.742     0.200
     9.312   134.472     0.200
     9.312   134.832     0.200
     9.534   137.392     0.200
     9.534   136.592     0.200
     9.534   137.872     0.200
     9.897   141.872     0.200
     9.973   139.241     0.200
     9.973   139.372     0.200
     9.973   139.532     0.200
    11.320   160.372     0.200
    12.274   176.372     0.200
    12.707   180.390     0.200
    12.707   181.072     0.200
    13.312   187.172     0.200
    14.305   202.772     0.200
    15.347   216.372     0.200
    16.057   226.672     0.200
    16.145   225.182     0.200
    16.466   228.192     0.200
    16.466   230.472     0.200
    16.466   231.247     0.200
    16.868   233.732     0.200
    16.868   233.722     0.200
    16.868   234.572     0.200
    17.244   239.272     0.200
    19.140   263.372     0.200
    19.994   274.372     0.200
    20.808   282.672     0.200
    20.839   282.472     0.200
     1.968    35.070     0.200
     2.220    37.570     0.200
     2.856    46.969     0.200
     2.856    47.469     0.200
     3.000    50.172     0.200
     3.000    48.672     0.200
     3.763    59.773     0.200
     3.800    59.367     0.200
     3.865    58.672     0.200
     3.865    61.070     0.200
     3.992    62.570     0.200
     3.992    62.273     0.200
     4.076    63.469     0.200
     4.076    62.773     0.200
     4.203    65.172     0.200
     4.442    69.469     0.200
     4.620    71.367     0.200
     5.211    79.367     0.200
     5.211    79.172     0.200
     5.287    80.672     0.200
     5.514    82.672     0.200
     5.559    84.867     0.200
     5.599    83.672     0.200
     5.750    86.969     0.200
     6.115    92.672     0.200
     6.220    92.570     0.200
     6.499    96.867     0.200
     6.527    96.469     0.200
     6.738    99.773     0.200
     7.182   104.812     0.200
     7.182   107.070     0.200
     7.182   106.562     0.200
     7.182   106.867     0.200
     7.388   106.617     0.200
     7.636   113.570     0.200
     8.242   120.969     0.200
     8.509   125.273     0.200
     8.509   124.469     0.200
     8.678   126.469     0.200
     8.950   132.172     0.200
     8.950   130.977     0.200
     8.950   131.367     0.200
     8.950   131.930     0.200
     9.164   133.672     0.200
     9.164   132.891     0.200
    10.096   145.172     0.200
    10.377   148.828     0.200
    10.377   148.211     0.200
    10.767   155.773     0.200
    10.914   160.070     0.200
    12.936   184.062     0.200
    12.936   185.367     0.200
    15.092   215.172     0.200
    15.229   215.477     0.200
    15.970   224.172     0.200
    16.609   230.594     0.200
    16.609   232.922     0.200
    16.539   231.594     0.200
    16.539   232.969     0.200
    16.539   231.422     0.200
    16.860   236.969     0.200
    19.827   273.367     0.200
    20.398   281.367     0.200
    20.531   281.867     0.200
    20.856   284.172     0.200
     1.959    34.072     0.200
     2.189    37.971     0.200
     2.879    47.172     0.200
     2.879    47.471     0.200
     2.989    48.871     0.200
     3.788    58.871     0.200
     3.786    59.771     0.200
     3.879    60.572     0.200
     4.027    62.572     0.200
     4.027    62.271     0.200
     4.056    63.672     0.200
     4.178    65.471     0.200
     4.186    64.871     0.200
     4.648    71.371     0.200
     5.192    78.771     0.200
     5.192    78.971     0.200
     5.276    80.271     0.200
     5.500    83.371     0.200
     5.738    86.771     0.200
     6.098    91.172     0.200
     6.231    92.572     0.200
     6.231    92.371     0.200
     6.448    96.572     0.200
     6.481    96.072     0.200
     6.506    97.072     0.200
     6.506    99.172     0.200
     6.720    99.771     0.200
     7.162   103.881     0.200
     7.162   106.361     0.200
     7.162   105.371     0.200
     7.162   106.771     0.200
     7.417   106.914     0.200
     7.614   112.371     0.200
     7.670   110.471     0.200
     8.276   122.471     0.200
     8.486   124.672     0.200
     8.947   131.973     0.200
     8.947   130.861     0.200
     8.947   131.471     0.200
     8.947   131.172     0.200
     9.152   133.471     0.200
     9.154   133.572     0.200
     9.159   133.418     0.200
     9.159   133.242     0.200
    10.130   144.771     0.200
    10.390   146.514     0.200
    10.390   147.141     0.200
    10.390   146.672     0.200
    10.390   147.531     0.200
    10.390   149.572     0.200
    12.971   183.498     0.200
    12.971   183.271     0.200
    14.347   203.271     0.200
    14.638   207.871     0.200
    15.263   216.271     0.200
    15.899   226.572     0.200
    15.988   226.172     0.200
    16.506   230.701     0.200
    16.506   230.734     0.200
    16.506   230.502     0.200
    16.506   231.572     0.200
    16.632   234.371     0.200
    16.643   234.311     0.200
    16.643   233.672     0.200
    16.643   233.258     0.200
    16.643   234.662     0.200
    16.662   234.672     0.200
    16.831   236.371     0.200
    17.374   243.172     0.200
    17.580   244.672     0.200
    18.520   259.271     0.200
    18.754   261.072     0.200
    19.846   273.572     0.200
    20.094   276.072     0.200
    20.094   274.992     0.200
    20.094   276.232     0.200
    20.227   276.461     0.200
    20.227   277.572     0.200
    20.227   277.771     0.200
    20.376   280.072     0.200
    20.459   280.350     0.200
    20.759   282.814     0.200
    20.759   282.672     0.200
     1.889    32.998     0.200
     3.104    49.599     0.200
     2.982    47.498     0.200
     4.031    62.398     0.200
     3.929    60.898     0.200
     4.153    61.998     0.200
     4.419    66.398     0.200
     4.419    66.698     0.200
     4.924    74.198     0.200
     5.082    76.398     0.200
     5.082    76.298     0.200
     5.260    79.398     0.200
     5.706    85.998     0.200
     5.996    88.698     0.200
     6.366    92.698     0.200
     6.371    93.998     0.200
     6.458    93.898     0.200
     6.602    96.698     0.200
     7.032   102.066     0.200
     7.032   102.758     0.200
     7.032   101.898     0.200
     7.032   102.398     0.200
     7.448   108.198     0.200
     7.811   111.099     0.200
     8.061   114.298     0.200
     8.304   120.798     0.200
     8.304   120.898     0.200
     8.422   122.099     0.200
     9.023   132.318     0.200
     9.023   130.298     0.200
     9.023   131.198     0.200
     9.218   133.758     0.200
     9.218   134.088     0.200
    10.463   149.099     0.200
    10.463   149.317     0.200
    10.463   147.298     0.200
    10.538   153.698     0.200
    10.692   152.998     0.200
    13.372   190.316     0.200
    13.372   188.798     0.200
    13.854   198.599     0.200
    15.676   223.349     0.200
    16.160   224.628     0.200
    16.160   223.349     0.200
    16.160   224.349     0.200
    16.287   230.118     0.200
    16.561   231.498     0.200
    17.057   238.273     0.200
    18.214   254.099     0.200
    20.278   276.698     0.200
    20.195   277.998     0.200
    20.878   282.898     0.200
     1.964    33.793     0.200
     2.156    37.793     0.200
     2.910    46.992     0.200
     2.966    48.293     0.200
     3.806    58.117     0.200
     3.820    60.593     0.200
     3.761    58.593     0.200
     4.028    62.992     0.200
     4.159    64.192     0.200
     4.681    71.093     0.200
     4.944    76.992     0.200
     5.165    78.593     0.200
     5.254    79.893     0.200
     5.715    86.192     0.200
     6.071    90.692     0.200
     6.228    91.593     0.200
     6.454    95.893     0.200
     6.478    98.393     0.200
     6.692    99.093     0.200
     7.134   104.883     0.200
     7.134   104.160     0.200
     7.134   104.992     0.200
     7.436   106.893     0.200
     7.584   112.192     0.200
     7.688   109.603     0.200
     7.688   109.992     0.200
     7.688   110.093     0.200
     8.309   119.692     0.200
     8.455   123.992     0.200
     8.455   123.793     0.200
     8.620   126.192     0.200
     8.620   126.293     0.200
     8.931   130.143     0.200
     8.931   129.893     0.200
     8.931   130.492     0.200
     8.931   130.893     0.200
     9.135   134.893     0.200
     9.137   133.893     0.200
     9.142   133.112     0.200
     9.142   133.402     0.200
    10.160   145.793     0.200
    10.415   145.811     0.200
    10.415   149.093     0.200
    13.002   185.261     0.200
    15.288   217.293     0.200
    15.903   227.293     0.200
    15.993   223.343     0.200
    16.473   228.043     0.200
    16.473   229.912     0.200
    16.670   235.093     0.200
    16.670   233.593     0.200
    16.670   234.942     0.200
    16.798   235.793     0.200
    17.183   239.093     0.200
    17.742   245.143     0.200
    18.522   259.393     0.200
    18.735   261.492     0.200
    20.124   275.311     0.200
    20.124   275.463     0.200
    20.124   276.293     0.200
    20.259   279.673     0.200
    20.346   279.192     0.200
    20.476   280.593     0.200
    20.786   282.718     0.200
    20.786   282.893     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.372    42.711     0.200
     2.275    41.516     0.200
     2.758    49.914     0.200
     3.068    57.914     0.200
     4.190    75.914     0.200
     4.297    77.312     0.200
     4.297    77.812     0.200
     5.429    99.312     0.200
     5.820   107.609     0.200
     8.473   155.711     0.200
     8.658   158.312     0.200
     8.658   157.812     0.200
     2.307    42.070     0.200
     2.205    40.371     0.200
     2.450    44.270     0.200
     2.679    49.070     0.200
     3.135    61.473     0.200
     4.321    76.871     0.200
     4.321    77.473     0.200
     6.794   122.871     0.200
     8.546   157.270     0.200
     3.509    63.315     0.200
     5.253    93.215     0.200
     2.165    39.242     0.200
     2.477    48.441     0.200
     2.495    45.441     0.200
     3.738    67.641     0.200
     4.224    75.840     0.200
     6.208   111.641     0.200
     2.246    39.984     0.200
     2.246    40.383     0.200
     2.285    41.078     0.200
     2.285    42.781     0.200
     2.467    45.078     0.200
     3.036    54.883     0.200
     3.713    67.078     0.200
     3.707    66.180     0.200
     4.392    76.578     0.200
     4.713    87.281     0.200
     6.351   118.578     0.200
     7.433   136.781     0.200
     7.433   136.578     0.200
     2.218    40.695     0.200
     2.854    51.898     0.200
     3.322    58.898     0.200
     3.666    66.898     0.200
     8.599   159.398     0.200
     3.181    58.898     0.200
     4.166    74.898     0.200
     6.300   113.898     0.200
     2.298    40.814     0.200
     2.870    51.314     0.200
     2.870    51.115     0.200
     3.470    63.314     0.200
     3.470    63.115     0.200
     3.595    65.215     0.200
     8.861   162.115     0.200
     9.438   170.516     0.200
     3.495    62.952     0.200
     4.244    75.752     0.200
     5.207    95.652     0.200
     2.165    39.117     0.200
     2.165    39.320     0.200
     2.591    46.219     0.200
     3.413    62.523     0.200
     3.684    67.117     0.200
     3.684    69.023     0.200
     4.134    75.617     0.200
     4.571    82.320     0.200
     4.831    86.719     0.200
     7.625   142.219     0.200
     2.104    37.219     0.200
     2.104    36.914     0.200
     2.230    39.719     0.200
     2.231    39.617     0.200
     2.665    46.320     0.200
     3.453    60.914     0.200
     3.692    65.516     0.200
     4.237    75.617     0.200
     4.613    81.617     0.200
     4.613    81.414     0.200
     4.983    88.117     0.200
     6.434   116.820     0.200
     2.432    42.980     0.200
     3.299    58.281     0.200
     3.888    68.781     0.200
     4.361    77.680     0.200
     6.470   118.980     0.200
     2.120    37.660     0.200
     2.887    51.660     0.200
     3.095    55.059     0.200
     4.100    71.859     0.200
     4.099    73.762     0.200
     5.247    94.859     0.200
     7.206   127.961     0.200
     7.637   137.359     0.200
     2.261    39.331     0.200
     2.387    42.231     0.200
     2.527    44.731     0.200
     3.199    56.632     0.200
     3.288    58.932     0.200
     3.853    69.231     0.200
     4.189    75.731     0.200
     4.189    75.031     0.200
     4.433    79.432     0.200
     4.434    77.432     0.200
     4.434    79.432     0.200
     4.448    79.731     0.200
     4.448    80.132     0.200
     4.744    85.132     0.200
     5.094    91.231     0.200
     5.164    93.331     0.200
     5.695   101.731     0.200
     5.733   102.231     0.200
     6.354   115.731     0.200
     6.354   115.132     0.200
     6.369   114.231     0.200
     6.752   120.932     0.200
     7.503   135.031     0.200
     7.684   137.831     0.200
     2.236    39.318     0.200
     2.835    51.418     0.200
     2.835    50.918     0.200
     3.024    55.117     0.200
     3.985    71.818     0.200
     3.985    71.717     0.200
     3.884    70.117     0.200
     4.098    73.617     0.200
     4.098    71.518     0.200
     4.098    73.418     0.200
     6.242   113.818     0.200
     8.258   147.918     0.200
     2.199    40.641     0.200
     2.199    39.840     0.200
     2.828    51.441     0.200
     2.828    51.340     0.200
     3.094    55.840     0.200
     3.094    56.240     0.200
     3.882    69.840     0.200
     4.021    72.240     0.200
     4.021    72.041     0.200
     4.074    73.740     0.200
     4.074    73.941     0.200
     4.131    74.240     0.200
     6.371   117.041     0.200
     2.226    39.387     0.200
     2.226    39.488     0.200
     2.828    49.988     0.200
     2.828    49.887     0.200
     2.962    53.188     0.200
     2.962    52.488     0.200
     3.625    64.289     0.200
     3.641    64.289     0.200
     3.926    70.387     0.200
     3.926    70.488     0.200
     3.954    71.086     0.200
     3.954    69.988     0.200
     5.077    89.586     0.200
     2.201    39.400     0.200
     2.694    49.101     0.200
     3.486    62.200     0.200
     3.662    65.501     0.200
     4.250    76.101     0.200
     2.302    40.496     0.200
     2.449    44.496     0.200
     2.501    44.797     0.200
     3.241    58.297     0.200
     3.241    57.797     0.200
     4.271    75.898     0.200
     4.401    78.098     0.200
     2.334    41.480     0.200
     2.483    43.578     0.200
     2.483    44.578     0.200
     2.499    44.879     0.200
     2.499    45.078     0.200
     3.205    57.480     0.200
     3.963    70.277     0.200
     3.963    71.777     0.200
     4.218    75.578     0.200
     4.365    76.777     0.200
     2.301    40.492     0.200
     2.479    43.797     0.200
     2.479    44.594     0.200
     2.517    44.492     0.200
     2.517    44.594     0.200
     3.237    58.594     0.200
     3.237    58.094     0.200
     4.243    76.195     0.200
     4.243    76.094     0.200
     4.397    77.594     0.200
     6.309   115.094     0.200
     2.299    40.762     0.200
     2.464    44.062     0.200
     2.512    44.363     0.200
     3.241    58.164     0.200
     3.241    58.562     0.200
     3.927    68.562     0.200
     3.927    70.762     0.200
     4.226    75.562     0.200
     4.401    78.762     0.200
     2.494    44.254     0.200
     2.494    45.455     0.200
     2.509    45.154     0.200
     2.509    46.055     0.200
     3.224    58.254     0.200
     3.224    58.455     0.200
     3.957    71.855     0.200
     4.261    76.555     0.200
     4.245    76.654     0.200
     4.245    76.355     0.200
     2.299    40.311     0.200
     2.451    43.111     0.200
     2.451    43.611     0.200
     2.506    44.111     0.200
     3.243    57.012     0.200
     3.243    57.611     0.200
     3.915    69.912     0.200
     4.403    78.211     0.200
     4.400    78.111     0.200
     2.314    40.828     0.200
     2.314    41.031     0.200
     2.506    44.430     0.200
     2.506    44.227     0.200
     2.490    44.828     0.200
     3.158    56.031     0.200
     3.224    57.531     0.200
     4.238    75.930     0.200
     4.238    75.133     0.200
     4.259    77.227     0.200
     4.389    78.031     0.200
     4.384    78.133     0.200
     4.815    86.727     0.200
     5.118    92.328     0.200
     5.204    93.328     0.200
     5.423    98.930     0.200
     5.621   100.930     0.200
     5.666   101.430     0.200
     6.380   115.828     0.200
     6.380   115.430     0.200
     2.301    40.391     0.200
     2.462    44.391     0.200
     2.462    44.492     0.200
     2.509    44.289     0.200
     2.509    44.492     0.200
     3.239    57.188     0.200
     3.926    69.992     0.200
     4.221    75.688     0.200
     4.400    77.891     0.200
     4.400    77.492     0.200
     2.330    40.746     0.200
     2.499    44.848     0.200
     2.499    44.547     0.200
     2.518    45.945     0.200
     2.518    44.348     0.200
     3.206    57.246     0.200
     3.206    58.246     0.200
     3.980    71.348     0.200
     3.980    71.848     0.200
     4.250    75.848     0.200
     4.250    76.645     0.200
     4.366    78.145     0.200
     4.366    78.746     0.200
     4.377    77.945     0.200
     6.386   114.645     0.200
     6.386   114.848     0.200
     7.421   133.445     0.200
     2.300    40.273     0.200
     2.443    43.570     0.200
     2.443    43.977     0.200
     2.500    44.273     0.200
     2.500    44.070     0.200
     3.164    57.172     0.200
     3.243    56.570     0.200
     3.908    68.773     0.200
     4.198    75.273     0.200
     4.404    78.172     0.200
     2.305    41.074     0.200
     2.305    40.676     0.200
     2.659    47.273     0.200
     2.659    46.773     0.200
     3.082    55.176     0.200
     3.326    60.273     0.200
     3.326    58.676     0.200
     3.489    63.574     0.200
     3.854    68.574     0.200
     3.854    69.773     0.200
     3.825    69.477     0.200
     3.825    69.273     0.200
     4.686    84.977     0.200
     4.683    84.273     0.200
     4.956    88.574     0.200
     5.246    95.773     0.200
     5.405    97.773     0.200
     6.234   113.176     0.200
     7.436   133.676     0.200
     7.940   144.676     0.200
     7.940   144.875     0.200
     8.326   150.676     0.200
     8.497   153.324     0.200
     2.299    40.651     0.200
     2.299    40.752     0.200
     2.860    50.651     0.200
     2.860    51.052     0.200
     2.934    52.252     0.200
     3.696    65.951     0.200
     3.696    65.552     0.200
     3.871    69.651     0.200
     3.871    69.052     0.200
     3.747    68.052     0.200
     4.056    70.852     0.200
     2.428    43.641     0.200
     2.611    47.539     0.200
     3.253    58.641     0.200
     3.861    70.039     0.200
     4.328    77.445     0.200
     2.309    40.570     0.200
     2.466    44.270     0.200
     2.466    44.570     0.200
     2.499    45.270     0.200
     2.499    44.070     0.200
     3.232    58.473     0.200
     3.930    70.672     0.200
     3.930    71.270     0.200
     4.214    75.473     0.200
     4.214    75.973     0.200
     4.392    78.570     0.200
     4.390    78.871     0.200
     2.428    43.223     0.200
     2.428    42.723     0.200
     2.459    43.324     0.200
     2.783    50.723     0.200
     2.783    48.723     0.200
     2.954    52.824     0.200
     2.954    53.023     0.200
     3.358    59.723     0.200
     3.616    65.922     0.200
     3.702    66.523     0.200
     3.702    65.824     0.200
     3.987    71.824     0.200
     5.087    90.023     0.200
     5.087    89.922     0.200
     2.105    39.008     0.200
     2.276    41.309     0.200
     2.276    40.809     0.200
     2.679    47.508     0.200
     3.735    66.508     0.200
     3.735    67.207     0.200
     4.601    81.707     0.200
     2.465    44.594     0.200
     2.465    44.000     0.200
     2.555    45.797     0.200
     2.555    45.695     0.200
     3.108    55.594     0.200
     3.165    56.695     0.200
     3.740    67.000     0.200
     4.019    71.695     0.200
     4.237    76.000     0.200
     4.338    77.594     0.200
     5.066    90.094     0.200
     2.332    41.813     0.200
     2.656    49.113     0.200
     2.656    49.013     0.200
     3.366    60.813     0.200
     4.364    79.113     0.200
     2.357    42.449     0.200
     2.352    41.648     0.200
     2.801    50.148     0.200
     2.801    49.148     0.200
     2.948    51.949     0.200
     2.948    52.250     0.200
     3.782    68.148     0.200
     3.782    67.852     0.200
     3.977    70.648     0.200
     2.267    41.574     0.200
     2.267    41.074     0.200
     2.226    41.074     0.200
     2.226    41.574     0.200
     2.838    52.875     0.200
     2.838    50.172     0.200
     2.838    52.773     0.200
     3.128    58.574     0.200
     3.566    64.375     0.200
     3.494    63.074     0.200
     3.494    62.273     0.200
     4.086    73.773     0.200
     4.086    73.973     0.200
     6.144   113.375     0.200
     2.252    39.789     0.200
     2.402    42.594     0.200
     2.544    44.891     0.200
     3.211    58.594     0.200
     3.292    59.094     0.200
     3.866    68.195     0.200
     4.220    75.695     0.200
     4.444    79.891     0.200
     2.324    41.070     0.200
     2.484    43.672     0.200
     2.484    43.570     0.200
     2.474    44.773     0.200
     3.143    55.570     0.200
     3.217    56.367     0.200
     3.217    59.570     0.200
     3.939    70.867     0.200
     2.325    41.613     0.200
     2.325    42.613     0.200
     2.706    49.312     0.200
     3.187    56.012     0.200
     3.961    71.512     0.200
     4.243    75.412     0.200
     5.935   108.213     0.200
     2.233    39.189     0.200
     2.233    39.889     0.200
     2.844    51.590     0.200
     2.844    51.189     0.200
     3.010    54.488     0.200
     3.010    54.289     0.200
     3.811    68.689     0.200
     3.868    69.488     0.200
     3.868    69.590     0.200
     3.982    70.789     0.200
     3.982    69.689     0.200
     4.087    72.488     0.200
     8.690   156.189     0.200
     2.296    41.906     0.200
     2.698    49.506     0.200
     2.698    49.806     0.200
     3.291    57.806     0.200
     3.291    59.006     0.200
     3.291    60.606     0.200
     3.625    66.306     0.200
     4.072    73.406     0.200
     4.082    73.706     0.200
     4.218    75.106     0.200
     4.218    74.806     0.200
     4.218    76.406     0.200
     4.301    77.806     0.200
     4.301    77.406     0.200
     8.697   156.106     0.200
     2.571    46.914     0.200
     2.776    49.312     0.200
     2.727    48.211     0.200
     2.727    48.914     0.200
     2.885    50.016     0.200
     2.885    50.414     0.200
     3.675    66.211     0.200
     3.710    66.414     0.200
     3.881    69.312     0.200
     3.881    69.609     0.200
     4.247    77.609     0.200
     4.297    76.914     0.200
     2.663    47.623     0.200
     2.663    48.623     0.200
     3.360    60.323     0.200
     3.349    60.224     0.200
     3.698    65.923     0.200
     4.609    81.523     0.200
     4.630    81.923     0.200
     2.316    41.953     0.200
     2.316    43.355     0.200
     2.679    49.754     0.200
     3.303    59.656     0.200
     3.605    65.656     0.200
     4.062    73.855     0.200
     4.062    74.055     0.200
     4.317    76.355     0.200
     4.498    81.156     0.200
     2.289    40.680     0.200
     2.289    40.383     0.200
     2.742    49.781     0.200
     2.742    50.383     0.200
     3.158    56.281     0.200
     3.158    55.980     0.200
     3.658    64.980     0.200
     4.210    75.582     0.200
     4.210    74.680     0.200
     8.629   157.582     0.200
     2.520    46.641     0.200
     2.528    46.539     0.200
     3.314    59.840     0.200
     3.438    62.238     0.200
     3.506    62.141     0.200
     3.774    68.840     0.200
     4.026    71.641     0.200
     4.026    72.441     0.200
     4.304    77.238     0.200
     4.405    78.641     0.200
     4.405    78.840     0.200
     5.308    96.441     0.200
     5.881   109.141     0.200
     7.621   141.941     0.200
     8.559   156.941     0.200
     2.312    41.938     0.200
     2.683    49.742     0.200
     2.683    49.344     0.200
     3.299    57.641     0.200
     3.299    59.539     0.200
     3.299    59.742     0.200
     4.081    74.039     0.200
     4.064    74.039     0.200
     4.064    73.742     0.200
     4.213    76.344     0.200
     4.213    76.844     0.200
     4.313    76.344     0.200
     4.313    78.039     0.200
     5.459    96.742     0.200
     5.459    95.742     0.200
     6.042   109.438     0.200
     6.370   115.141     0.200
     6.574   118.438     0.200
     7.849   141.438     0.200
     8.711   157.242     0.200
     2.004    35.023     0.200
     2.808    49.422     0.200
     2.808    50.621     0.200
     3.466    61.422     0.200
     3.651    64.824     0.200
     3.651    65.023     0.200
     4.809    84.621     0.200
     6.741   124.922     0.200
     2.346    41.695     0.200
     2.346    41.594     0.200
     2.704    48.293     0.200
     2.704    49.293     0.200
     3.161    55.594     0.200
     3.161    57.195     0.200
     3.518    61.395     0.200
     3.915    70.195     0.200
     3.915    70.094     0.200
     4.234    74.594     0.200
     4.234    75.395     0.200
     5.146    94.992     0.200
     8.663   155.793     0.200
     2.028    35.242     0.200
     2.010    36.344     0.200
     2.717    47.641     0.200
     2.717    47.344     0.200
     3.398    60.039     0.200
     3.440    62.039     0.200
     3.591    64.242     0.200
     4.124    72.945     0.200
     4.406    79.141     0.200
     4.747    84.141     0.200
     5.410    96.344     0.200
     7.089   128.344     0.200
     8.975   161.664     0.200
     2.268    40.969     0.200
     2.790    50.266     0.200
     2.790    49.766     0.200
     3.078    53.566     0.200
     3.078    55.766     0.200
     3.700    66.266     0.200
     3.877    68.266     0.200
     3.972    70.367     0.200
     4.147    72.566     0.200
     4.519    81.066     0.200
     4.564    80.766     0.200
     6.598   120.168     0.200
     7.254   131.668     0.200
     2.142    37.639     0.200
     2.711    47.238     0.200
     2.711    47.339     0.200
     3.410    61.039     0.200
     3.525    62.738     0.200
     3.525    63.839     0.200
     3.604    63.938     0.200
     3.604    64.438     0.200
     4.226    74.938     0.200
     4.536    80.539     0.200
     2.167    39.308     0.200
     2.616    45.907     0.200
     2.616    47.308     0.200
     2.627    47.107     0.200
     2.840    50.507     0.200
     2.950    53.507     0.200
     3.478    62.308     0.200
     3.818    67.907     0.200
     3.932    70.007     0.200
     4.101    72.907     0.200
     4.075    72.208     0.200
     4.109    72.507     0.200
     4.109    74.407     0.200
     4.806    86.107     0.200
     5.396    95.708     0.200
     5.895   104.107     0.200
     2.167    39.526     0.200
     2.615    46.426     0.200
     2.615    48.026     0.200
     2.841    51.126     0.200
     2.953    53.826     0.200
     2.953    54.626     0.200
     3.479    62.626     0.200
     3.479    63.326     0.200
     4.097    74.326     0.200
     4.076    72.826     0.200
     4.111    73.526     0.200
     4.385    78.326     0.200
     4.808    86.126     0.200
     5.168    92.326     0.200
     2.037    37.000     0.200
     2.769    48.195     0.200
     2.769    50.398     0.200
     3.318    59.000     0.200
     3.480    62.797     0.200
     3.500    63.094     0.200
     3.610    65.594     0.200
     4.431    79.695     0.200
     4.615    83.000     0.200
     4.769    84.898     0.200
     4.807    87.094     0.200
     5.018    90.195     0.200
     5.330    95.797     0.200
     5.449    97.695     0.200
     5.687   101.695     0.200
     6.701   119.398     0.200
     7.095   127.398     0.200
     7.822   141.195     0.200
     7.942   143.398     0.200
     8.037   145.297     0.200
     2.497    44.692     0.200
     2.538    47.292     0.200
     3.322    59.393     0.200
     3.464    61.192     0.200
     3.812    68.993     0.200
     4.125    75.792     0.200
     4.323    77.792     0.200
     4.401    79.493     0.200
     5.537    99.292     0.200
     5.609   100.593     0.200
     6.446   115.792     0.200
     2.474    44.383     0.200
     2.568    47.082     0.200
     2.568    46.781     0.200
     3.288    59.883     0.200
     3.288    60.582     0.200
     3.480    62.883     0.200
     3.486    61.281     0.200
     3.821    68.680     0.200
     3.821    69.582     0.200
     4.034    73.383     0.200
     4.092    75.582     0.200
     4.369    78.281     0.200
     4.348    77.582     0.200
     6.039   108.980     0.200
     6.409   115.082     0.200
     6.416   116.480     0.200
     6.820   123.680     0.200
     7.032   127.980     0.200
     7.475   134.383     0.200
     7.475   133.648     0.200
     2.475    44.289     0.200
     2.563    47.094     0.200
     2.563    48.891     0.200
     3.295    59.992     0.200
     3.477    61.992     0.200
     3.476    62.891     0.200
     3.824    67.688     0.200
     4.346    77.789     0.200
     4.375    78.289     0.200
     5.582   100.094     0.200
     6.425   116.594     0.200
     2.553    47.617     0.200
     2.553    47.219     0.200
     2.490    44.617     0.200
     2.490    45.016     0.200
     3.300    60.617     0.200
     3.300    60.320     0.200
     3.464    63.914     0.200
     3.489    63.219     0.200
     3.806    70.414     0.200
     3.806    69.617     0.200
     4.035    73.117     0.200
     4.035    73.016     0.200
     4.104    73.617     0.200
     4.332    78.320     0.200
     4.383    79.414     0.200
     6.130   111.820     0.200
     9.441   172.156     0.200
    10.075   180.664     0.200
     2.487    43.422     0.200
     2.487    47.125     0.200
     2.548    47.320     0.200
     2.548    46.719     0.200
     3.314    58.219     0.200
     3.314    60.625     0.200
     3.314    61.320     0.200
     3.462    62.719     0.200
     3.464    62.320     0.200
     3.820    69.625     0.200
     4.117    73.523     0.200
     4.392    78.125     0.200
     4.332    77.219     0.200
     5.528    97.422     0.200
     6.065   110.922     0.200
     6.442   118.023     0.200
     2.486    46.016     0.200
     2.549    47.219     0.200
     2.549    46.719     0.200
     3.463    63.617     0.200
     3.462    62.016     0.200
     3.462    64.617     0.200
     3.821    69.820     0.200
     3.821    69.422     0.200
     4.116    73.922     0.200
     4.333    77.422     0.200
     4.391    79.820     0.200
     5.527    97.719     0.200
     5.527    99.719     0.200
     6.065   110.320     0.200
     6.442   116.820     0.200
     8.977   161.422     0.200
     2.482    43.992     0.200
     2.555    46.691     0.200
     3.305    58.691     0.200
     3.471    62.691     0.200
     3.469    62.691     0.200
     3.821    68.492     0.200
     4.108    73.395     0.200
     4.384    77.895     0.200
     6.056   109.094     0.200
     6.433   116.191     0.200
     2.521    46.891     0.200
     2.521    46.492     0.200
     2.517    45.891     0.200
     2.517    46.891     0.200
     3.332    60.293     0.200
     3.332    59.691     0.200
     3.434    62.691     0.200
     3.475    63.590     0.200
     3.790    70.090     0.200
     3.790    69.090     0.200
     4.056    73.992     0.200
     4.137    74.691     0.200
     4.303    77.293     0.200
     4.416    79.492     0.200
     4.778    85.793     0.200
     6.100   110.293     0.200
     8.574   161.090     0.200
    11.085   199.691     0.200
     2.018    36.578     0.200
     2.540    46.078     0.200
     2.499    46.277     0.200
     3.350    61.078     0.200
     3.350    61.477     0.200
     3.412    62.977     0.200
     3.477    62.578     0.200
     3.770    68.477     0.200
     4.155    75.477     0.200
     4.436    79.277     0.200
     4.281    77.277     0.200
     5.342    96.676     0.200
     5.870   108.078     0.200
     6.101   111.078     0.200
     6.448   118.078     0.200
     6.887   126.875     0.200
     7.995   143.777     0.200
     8.593   155.777     0.200
     9.028   163.777     0.200
     2.502    45.329     0.200
     2.502    46.729     0.200
     2.536    47.129     0.200
     3.472    62.429     0.200
     3.321    60.429     0.200
     3.321    60.229     0.200
     4.125    74.929     0.200
     4.402    79.829     0.200
     2.373    42.453     0.200
     3.235    57.852     0.200
     3.440    61.953     0.200
     3.571    64.750     0.200
     3.927    71.148     0.200
     4.295    76.547     0.200
     4.446    79.750     0.200
     5.434    97.648     0.200
     5.985   108.047     0.200
     6.427   117.047     0.200
     6.723   120.453     0.200
     8.869   159.750     0.200
     2.489    43.863     0.200
     2.489    46.062     0.200
     2.551    46.660     0.200
     3.304    58.961     0.200
     3.304    57.762     0.200
     3.463    62.863     0.200
     3.810    69.062     0.200
     4.042    72.961     0.200
     4.042    73.562     0.200
     4.386    78.660     0.200
     4.386    78.160     0.200
     4.332    77.762     0.200
     7.492   135.062     0.200
     8.544   153.363     0.200
     2.850    50.043     0.200
     3.232    58.144     0.200
     3.392    59.843     0.200
     3.602    63.644     0.200
     3.791    68.443     0.200
     4.157    74.743     0.200
     4.246    76.043     0.200
     4.492    80.443     0.200
     5.044    90.243     0.200
     5.126    91.343     0.200
     5.570   100.144     0.200
     6.233   112.343     0.200
     6.368   115.543     0.200
     2.484    44.629     0.200
     2.484    45.230     0.200
     2.559    47.527     0.200
     2.559    47.328     0.200
     3.294    59.027     0.200
     3.294    58.828     0.200
     3.470    63.430     0.200
     3.491    62.930     0.200
     3.810    69.129     0.200
     3.810    69.430     0.200
     4.031    72.027     0.200
     4.031    72.930     0.200
     4.098    72.230     0.200
     4.377    78.730     0.200
     4.338    78.328     0.200
     4.739    84.730     0.200
     5.512    98.027     0.200
     5.512    97.527     0.200
     2.469    43.980     0.200
     2.445    43.379     0.200
     2.445    43.277     0.200
     2.826    50.180     0.200
     2.826    49.578     0.200
     2.910    53.078     0.200
     3.372    60.879     0.200
     3.661    67.180     0.200
     4.032    72.680     0.200
     4.128    73.578     0.200
     4.288    77.480     0.200
     5.132    91.078     0.200
     8.746   158.379     0.200
     2.312    40.697     0.200
     2.312    41.297     0.200
     2.730    49.598     0.200
     3.150    57.297     0.200
     3.494    61.797     0.200
     3.947    71.498     0.200
     3.955    70.598     0.200
     3.991    71.797     0.200
     3.991    70.498     0.200
     4.214    75.297     0.200
     4.512    80.697     0.200
     8.638   155.098     0.200
     2.104    37.277     0.200
     2.104    37.074     0.200
     2.459    44.676     0.200
     2.544    44.977     0.200
     3.315    58.375     0.200
     3.455    62.277     0.200
     3.851    68.777     0.200
     4.269    76.574     0.200
     4.221    75.777     0.200
     6.061   109.676     0.200
     8.021   144.375     0.200
     8.680   157.477     0.200
     9.615   174.477     0.200
     2.481    43.852     0.200
     2.481    46.250     0.200
     2.562    47.453     0.200
     3.290    60.148     0.200
     3.290    58.648     0.200
     3.492    62.555     0.200
     3.812    69.648     0.200
     3.812    69.852     0.200
     4.029    73.055     0.200
     4.029    71.148     0.200
     4.094    74.750     0.200
     4.341    77.750     0.200
     4.374    78.555     0.200
     4.374    79.555     0.200
     5.509    98.055     0.200
     5.509    97.852     0.200
     6.413   116.852     0.200
     8.531   154.953     0.200
     2.068    36.813     0.200
     2.499    45.413     0.200
     2.502    45.113     0.200
     4.217    76.813     0.200
     4.315    77.213     0.200
     4.470    81.513     0.200
     5.612   100.113     0.200
     5.711   102.913     0.200
     6.172   110.013     0.200
     6.598   119.113     0.200
     9.020   161.913     0.200
     2.470    44.438     0.200
     2.575    47.344     0.200
     3.278    58.539     0.200
     3.495    62.438     0.200
     3.820    70.344     0.200
     4.082    74.344     0.200
     4.361    78.539     0.200
     5.496    96.641     0.200
     6.030   107.539     0.200
     6.405   115.242     0.200
     2.002    35.477     0.200
     2.002    36.375     0.200
     2.002    38.078     0.200
     2.002    35.375     0.200
     2.585    46.676     0.200
     2.585    46.477     0.200
     2.744    50.477     0.200
     2.744    49.777     0.200
     2.907    53.477     0.200
     3.656    65.977     0.200
     3.656    65.777     0.200
     3.875    70.176     0.200
     4.057    71.875     0.200
     4.057    73.676     0.200
     4.056    72.977     0.200
     4.056    72.578     0.200
     4.694    83.777     0.200
     9.714   176.176     0.200
    11.004   199.078     0.200
     2.486    45.002     0.200
     2.486    47.302     0.200
     2.557    47.902     0.200
     3.295    59.002     0.200
     3.492    63.202     0.200
     3.469    63.902     0.200
     3.808    68.802     0.200
     3.808    69.802     0.200
     4.031    73.102     0.200
     4.031    72.902     0.200
     4.099    74.002     0.200
     4.336    79.002     0.200
     4.378    79.302     0.200
     8.536   154.901     0.200
    11.051   199.002     0.200
     2.533    46.984     0.200
     2.533    46.586     0.200
     2.500    44.883     0.200
     3.447    62.883     0.200
     3.330    61.180     0.200
     3.330    61.781     0.200
     3.455    62.086     0.200
     3.814    69.781     0.200
     3.814    69.680     0.200
     4.071    73.586     0.200
     4.319    77.086     0.200
     6.116   110.883     0.200
     7.071   128.180     0.200
     8.568   155.383     0.200
     2.357    42.055     0.200
     2.677    48.953     0.200
     2.677    48.754     0.200
     3.206    57.254     0.200
     3.206    57.953     0.200
     3.465    61.355     0.200
     3.465    63.055     0.200
     3.592    65.156     0.200
     3.929    70.254     0.200
     3.929    71.055     0.200
     4.003    72.453     0.200
     4.028    72.453     0.200
     4.269    75.953     0.200
     4.464    79.656     0.200
     5.800   101.953     0.200
     8.434   151.156     0.200
     8.434   153.555     0.200
     8.692   156.754     0.200
     8.847   158.754     0.200
     9.369   171.738     0.200
     2.360    44.695     0.200
     2.360    43.695     0.200
     2.669    48.895     0.200
     2.669    48.496     0.200
     3.222    57.297     0.200
     3.222    57.094     0.200
     3.445    61.695     0.200
     4.018    72.797     0.200
     3.936    70.297     0.200
     3.936    71.297     0.200
     4.049    73.195     0.200
     4.049    73.496     0.200
     4.281    77.094     0.200
     4.459    79.695     0.200
     5.420    95.895     0.200
     9.387   171.336     0.200
     2.373    42.898     0.200
     2.373    42.797     0.200
     2.657    49.297     0.200
     2.657    48.996     0.200
     3.230    59.098     0.200
     3.230    60.297     0.200
     3.447    62.297     0.200
     3.924    71.797     0.200
     4.028    73.297     0.200
     4.049    73.398     0.200
     4.292    77.797     0.200
     4.446    79.898     0.200
     8.714   158.699     0.200
     2.378    43.035     0.200
     2.378    43.434     0.200
     2.649    48.535     0.200
     3.242    59.234     0.200
     3.435    62.633     0.200
     3.925    71.035     0.200
     3.925    71.234     0.200
     4.039    73.434     0.200
     4.062    73.633     0.200
     4.062    74.234     0.200
     4.302    77.836     0.200
     4.440    80.234     0.200
     5.753   105.836     0.200
     5.992   110.133     0.200
     7.409   135.234     0.200
     8.469   154.434     0.200
     8.469   156.434     0.200
     4.033    70.762     0.200
     3.915    69.363     0.200
     3.915    69.164     0.200
     4.299    77.363     0.200
     5.437    95.461     0.200
     6.343   115.961     0.200
     6.420   117.863     0.200
     7.405   137.961     0.200
     7.405   134.664     0.200
     8.465   155.164     0.200
     2.392    43.445     0.200
     2.392    45.145     0.200
     2.392    44.348     0.200
     2.636    48.746     0.200
     2.636    48.645     0.200
     3.252    59.645     0.200
     3.252    57.348     0.200
     3.438    62.145     0.200
     3.912    70.645     0.200
     3.912    71.145     0.200
     4.063    73.645     0.200
     4.063    73.348     0.200
     4.049    73.645     0.200
     4.314    77.945     0.200
     4.314    78.145     0.200
     4.426    79.547     0.200
     8.480   153.848     0.200
     8.735   157.547     0.200
     9.414   170.746     0.200
    11.136   200.348     0.200
     2.387    43.422     0.200
     2.637    48.121     0.200
     2.637    47.719     0.200
     3.256    59.320     0.200
     3.256    57.422     0.200
     3.425    61.719     0.200
     3.922    71.422     0.200
     3.922    71.020     0.200
     4.053    73.621     0.200
     4.315    77.922     0.200
     4.430    79.020     0.200
     2.364    42.738     0.200
     2.667    49.137     0.200
     3.219    59.039     0.200
     3.219    57.637     0.200
     3.453    62.336     0.200
     3.929    71.836     0.200
     4.016    72.336     0.200
     4.280    77.438     0.200
     4.280    77.039     0.200
     4.456    80.137     0.200
     8.143   153.137     0.200
     8.703   157.637     0.200
     8.857   160.539     0.200
     2.363    42.527     0.200
     2.363    44.727     0.200
     2.670    48.926     0.200
     3.214    58.426     0.200
     3.214    59.328     0.200
     3.459    62.227     0.200
     3.927    71.426     0.200
     4.012    72.527     0.200
     4.277    77.727     0.200
     4.457    79.328     0.200
     2.376    42.152     0.200
     2.376    43.453     0.200
     2.651    48.352     0.200
     3.241    59.555     0.200
     3.434    61.555     0.200
     3.927    71.055     0.200
     4.038    73.152     0.200
     4.300    77.152     0.200
     4.442    79.152     0.200
     5.439    97.254     0.200
     5.991   108.254     0.200
     6.223   111.754     0.200
     6.434   117.055     0.200
     7.407   133.352     0.200
     7.852   141.152     0.200
     8.468   152.152     0.200
     8.721   157.555     0.200
     8.873   159.953     0.200
     2.327    41.758     0.200
     3.403    59.959     0.200
     3.223    58.459     0.200
     3.223    60.857     0.200
     3.223    57.459     0.200
     4.015    72.857     0.200
     4.084    73.059     0.200
     4.268    77.357     0.200
     4.268    77.758     0.200
     5.410    95.959     0.200
     8.441   151.258     0.200
     2.074    37.328     0.200
     2.074    37.227     0.200
     2.032    35.531     0.200
     2.032    36.227     0.200
     2.670    46.633     0.200
     2.670    47.227     0.200
     3.446    61.430     0.200
     3.396    60.531     0.200
     4.080    72.930     0.200
     4.734    83.828     0.200
     4.708    83.328     0.200
     2.861    51.171     0.200
     3.365    60.871     0.200
     3.608    64.671     0.200
     3.790    68.771     0.200
     4.110    73.871     0.200
     4.522    80.671     0.200
     4.522    80.871     0.200
     4.944    87.071     0.200
     8.914   161.972     0.200
     2.595    46.535     0.200
     2.560    46.035     0.200
     3.174    56.234     0.200
     3.174    58.336     0.200
     3.174    56.434     0.200
     3.483    61.734     0.200
     3.767    65.734     0.200
     3.639    66.633     0.200
     3.639    64.836     0.200
     3.773    67.734     0.200
     4.316    77.234     0.200
     8.443   152.133     0.200
     8.776   157.734     0.200
     9.258   168.453     0.200
    10.205   183.254     0.200
     2.157    39.688     0.200
     2.658    47.289     0.200
     2.658    48.688     0.200
     2.658    48.391     0.200
     2.719    49.090     0.200
     2.719    48.988     0.200
     2.807    51.789     0.200
     2.891    52.391     0.200
     2.891    52.891     0.200
     3.081    55.590     0.200
     3.183    57.090     0.200
     3.815    69.090     0.200
     3.915    70.488     0.200
     3.994    71.789     0.200
     3.994    72.391     0.200
     4.051    73.391     0.200
     4.051    73.789     0.200
     4.353    77.891     0.200
     4.504    81.289     0.200
     4.508    80.789     0.200
     8.408   153.910     0.200
     2.070    37.172     0.200
     2.070    36.772     0.200
     2.450    44.472     0.200
     2.450    44.672     0.200
     2.582    46.372     0.200
     2.582    45.872     0.200
     3.401    60.572     0.200
     3.401    61.872     0.200
     3.363    60.072     0.200
     3.456    60.672     0.200
     3.745    67.372     0.200
     4.207    75.872     0.200
     4.235    75.572     0.200
     4.488    80.172     0.200
     4.488    79.772     0.200
     4.599    82.872     0.200
     4.848    87.272     0.200
     5.394    96.772     0.200
     5.622   100.872     0.200
     5.687   102.172     0.200
     5.967   107.772     0.200
     6.153   111.572     0.200
     6.526   117.772     0.200
     6.486   117.472     0.200
     6.910   124.472     0.200
     7.150   128.372     0.200
     8.645   155.872     0.200
     2.220    39.469     0.200
     2.220    40.172     0.200
     2.856    52.273     0.200
     2.856    52.672     0.200
     3.000    54.969     0.200
     3.000    54.867     0.200
     3.763    68.273     0.200
     3.800    67.867     0.200
     3.865    69.570     0.200
     3.865    69.867     0.200
     3.992    72.070     0.200
     4.076    73.570     0.200
     4.076    73.469     0.200
     4.203    76.070     0.200
     4.442    80.469     0.200
     8.950   162.070     0.200
     9.164   166.508     0.200
    10.377   183.688     0.200
    10.767   193.867     0.200
     2.189    39.371     0.200
     2.879    52.172     0.200
     2.879    52.471     0.200
     2.989    53.971     0.200
     2.989    52.971     0.200
     3.788    68.672     0.200
     3.786    67.971     0.200
     3.879    69.572     0.200
     4.027    73.271     0.200
     4.027    71.672     0.200
     4.056    72.371     0.200
     4.056    73.471     0.200
     4.186    75.471     0.200
     8.486   153.172     0.200
     8.947   162.771     0.200
     9.159   165.494     0.200
    10.390   185.615     0.200
     3.104    56.498     0.200
     2.982    53.698     0.200
     2.982    55.498     0.200
     4.031    72.599     0.200
     3.929    70.599     0.200
     3.929    70.798     0.200
     4.153    74.498     0.200
     4.153    74.798     0.200
     6.715   121.998     0.200
     9.023   163.498     0.200
     9.218   168.938     0.200
     2.156    39.593     0.200
     2.156    39.893     0.200
     2.910    52.692     0.200
     2.966    53.393     0.200
     2.966    53.093     0.200
     3.806    68.742     0.200
     3.820    69.692     0.200
     3.761    67.393     0.200
     4.058    72.593     0.200
     4.028    73.393     0.200
     4.028    73.093     0.200
     4.159    75.293     0.200
     8.931   160.492     0.200
     9.142   165.553     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.115    20.477     0.200
     1.229    22.488     0.200
     0.439     9.531     0.200
     0.478     8.703     0.200
     1.097    18.805     0.200
     0.142     3.516     0.200
     0.157     3.914     0.200
     0.325     6.812     0.200
     1.302    22.914     0.200
     1.413    24.516     0.200
     1.296    23.109     0.200
     1.296    23.211     0.200
     1.550    26.812     0.200
     1.550    27.211     0.200
     1.550    26.711     0.200
     2.229    37.609     0.200
     0.110     2.473     0.200
     0.079     2.270     0.200
     0.150     2.973     0.200
     0.332     6.270     0.200
     0.252     5.172     0.200
     0.412     7.371     0.200
     1.218    22.070     0.200
     1.380    25.070     0.200
     1.443    25.871     0.200
     1.512    27.270     0.200
     1.196    22.715     0.200
     1.613    30.815     0.200
     2.889    48.815     0.200
     1.009    17.840     0.200
     1.937    33.742     0.200
     2.165    36.742     0.200
     0.552    10.984     0.200
     0.545    10.680     0.200
     0.783    14.680     0.200
     0.981    18.180     0.200
     0.989    18.180     0.200
     1.005    18.680     0.200
     1.017    19.281     0.200
     1.017    20.281     0.200
     1.297    23.484     0.200
     1.419    25.883     0.200
     1.419    25.578     0.200
     1.419    26.578     0.200
     1.520    27.578     0.200
     1.520    28.281     0.200
     5.690    91.781     0.200
     6.351   102.781     0.200
     7.433   123.281     0.200
     0.558    10.602     0.200
     0.946    17.000     0.200
     1.001    17.898     0.200
     1.685    30.102     0.200
     1.926    33.195     0.200
     0.202     4.398     0.200
     0.541    10.500     0.200
     0.465     9.000     0.200
     0.592    11.898     0.200
     0.737    13.898     0.200
     0.876    15.898     0.200
     1.810    31.398     0.200
     0.734    13.916     0.200
     0.734    13.416     0.200
     0.743    15.115     0.200
     0.750    15.115     0.200
     0.802    15.115     0.200
     0.802    15.416     0.200
     1.567    29.314     0.200
     1.791    30.615     0.200
     8.294   137.016     0.200
     0.192     4.152     0.200
     0.558    10.353     0.200
     0.734    12.952     0.200
     1.113    20.152     0.200
     1.113    19.952     0.200
     1.390    25.353     0.200
     0.127     2.219     0.200
     0.127     2.320     0.200
     0.374     6.523     0.200
     0.899    16.422     0.200
     1.150    21.320     0.200
     1.150    20.922     0.200
     1.206    23.023     0.200
     1.309    23.617     0.200
     0.026     3.516     0.200
     0.026     3.016     0.200
     0.389     7.414     0.200
     0.910    16.719     0.200
     1.288    23.414     0.200
     1.294    23.719     0.200
     1.294    23.516     0.200
     0.150     4.082     0.200
     0.190     4.082     0.200
     0.625    12.281     0.200
     1.177    21.281     0.200
     1.490    26.582     0.200
     1.490    26.480     0.200
     1.724    29.680     0.200
     1.724    30.281     0.200
     1.952    34.281     0.200
     0.167     4.660     0.200
     0.654    12.461     0.200
     1.179    20.559     0.200
     1.414    25.059     0.200
     1.719    30.359     0.200
     0.221     5.432     0.200
     0.163     3.932     0.200
     1.168    21.432     0.200
     1.135    20.831     0.200
     2.261    38.831     0.200
     0.222     5.117     0.200
     0.416     8.717     0.200
     0.416     8.818     0.200
     1.368    24.717     0.200
     1.025    18.617     0.200
     1.025    18.318     0.200
     1.295    22.518     0.200
     1.295    23.117     0.200
     1.946    33.018     0.200
     1.946    33.418     0.200
     5.042    83.918     0.200
     5.774    93.518     0.200
     0.115     2.740     0.200
     0.162     2.941     0.200
     0.558    10.240     0.200
     0.955    17.740     0.200
     1.256    22.941     0.200
     1.355    24.740     0.200
     1.355    25.941     0.200
     1.820    31.740     0.200
     0.175     4.086     0.200
     0.483     9.488     0.200
     0.548     9.488     0.200
     1.100    19.688     0.200
     1.305    22.988     0.200
     1.518    26.988     0.200
     1.518    27.188     0.200
     1.524    27.789     0.200
     2.206    38.188     0.200
     0.046     3.101     0.200
     0.422     8.101     0.200
     0.982    18.900     0.200
     1.216    22.400     0.200
     1.324    23.900     0.200
     1.324    23.700     0.200
     2.072    35.801     0.200
     0.172     3.996     0.200
     0.216     5.098     0.200
     0.216     4.496     0.200
     1.073    19.398     0.200
     1.073    19.098     0.200
     1.154    21.297     0.200
     1.154    21.098     0.200
     1.201    20.996     0.200
     1.217    22.699     0.200
     1.369    24.996     0.200
     1.369    24.797     0.200
     2.302    38.797     0.200
     7.539   123.797     0.200
     7.624   125.797     0.200
     0.144     3.379     0.200
     0.144     3.480     0.200
     0.261     4.879     0.200
     0.261     5.180     0.200
     1.024    18.480     0.200
     1.147    20.879     0.200
     1.251    23.480     0.200
     1.267    23.480     0.200
     1.415    25.480     0.200
     2.334    39.980     0.200
     0.178     3.797     0.200
     0.236     4.695     0.200
     0.236     5.094     0.200
     1.044    18.797     0.200
     1.044    19.094     0.200
     1.180    21.297     0.200
     1.233    23.391     0.200
     1.251    23.391     0.200
     1.414    25.391     0.200
     1.414    25.492     0.200
     2.301    39.391     0.200
     0.176     3.863     0.200
     0.176     4.363     0.200
     0.224     4.465     0.200
     0.224     5.062     0.200
     1.059    19.262     0.200
     1.059    19.363     0.200
     1.170    21.465     0.200
     1.217    23.062     0.200
     1.234    22.965     0.200
     1.393    25.164     0.200
     2.299    39.664     0.200
     0.170     3.555     0.200
     0.251     5.055     0.200
     0.251     4.754     0.200
     1.029    18.654     0.200
     1.175    21.555     0.200
     1.426    25.855     0.200
     2.313    39.455     0.200
     2.313    40.055     0.200
     2.509    43.154     0.200
     0.176     4.412     0.200
     0.215     4.412     0.200
     0.215     4.912     0.200
     1.071    19.512     0.200
     1.160    21.512     0.200
     1.374    25.012     0.200
     0.166     4.328     0.200
     0.248     5.531     0.200
     0.248     5.430     0.200
     1.033    19.227     0.200
     1.170    21.328     0.200
     1.261    23.531     0.200
     1.420    24.930     0.200
     1.420    25.328     0.200
     2.506    41.531     0.200
     0.223     4.789     0.200
     0.223     4.594     0.200
     0.174     4.188     0.200
     1.061    19.391     0.200
     1.166    21.391     0.200
     1.166    21.289     0.200
     1.389    24.391     0.200
     1.389    24.594     0.200
     2.301    38.789     0.200
     0.160     3.348     0.200
     0.160     3.246     0.200
     0.274     5.246     0.200
     0.274     5.145     0.200
     1.171    21.547     0.200
     1.171    21.445     0.200
     1.290    23.848     0.200
     1.447    26.645     0.200
     2.330    40.547     0.200
     2.499    42.746     0.200
     0.175     4.070     0.200
     0.212     4.570     0.200
     0.212     4.375     0.200
     1.152    21.172     0.200
     1.152    21.273     0.200
     1.361    24.977     0.200
     0.160     4.375     0.200
     0.160     4.273     0.200
     1.292    23.074     0.200
     1.292    22.875     0.200
     1.436    25.477     0.200
     1.428    25.074     0.200
     1.683    28.977     0.200
     1.683    30.176     0.200
     1.683    29.375     0.200
     2.499    43.273     0.200
     0.409     8.252     0.200
     0.221     4.752     0.200
     0.221     5.052     0.200
     1.141    20.552     0.200
     1.141    20.252     0.200
     1.369    24.151     0.200
     2.126    36.852     0.200
     2.126    36.552     0.200
     0.171     4.141     0.200
     0.561    10.844     0.200
     1.184    21.539     0.200
     1.184    21.242     0.200
     1.485    26.539     0.200
     1.790    31.344     0.200
     1.790    30.844     0.200
     1.913    34.141     0.200
     7.435   122.039     0.200
     0.166     3.770     0.200
     0.229     4.770     0.200
     0.229     4.270     0.200
     1.157    21.270     0.200
     1.387    25.570     0.200
     0.140     3.125     0.200
     0.140     3.023     0.200
     1.380    25.324     0.200
     1.380    25.023     0.200
     1.539    27.523     0.200
     1.539    27.125     0.200
     1.571    28.223     0.200
     1.569    28.223     0.200
     1.569    28.023     0.200
     2.459    42.723     0.200
     0.040     2.008     0.200
     0.040     1.609     0.200
     0.373     6.508     0.200
     0.373     6.707     0.200
     1.062    20.008     0.200
     1.062    19.906     0.200
     1.312    23.906     0.200
     1.312    24.008     0.200
     1.293    24.109     0.200
     1.293    23.906     0.200
     2.105    36.508     0.200
     0.131     2.797     0.200
     0.314     5.797     0.200
     0.314     5.695     0.200
     1.144    21.094     0.200
     1.324    24.398     0.200
     1.324    24.297     0.200
     1.469    27.094     0.200
     2.371    41.297     0.200
     2.371    41.000     0.200
     0.193     3.913     0.200
     0.822    16.013     0.200
     0.822    15.913     0.200
     1.055    19.713     0.200
     1.402    25.413     0.200
     1.402    25.513     0.200
     1.531    27.713     0.200
     1.989    35.813     0.200
     0.020     2.949     0.200
     0.644    12.148     0.200
     1.273    22.449     0.200
     1.273    22.648     0.200
     1.449    25.250     0.200
     1.537    27.051     0.200
     1.551    27.352     0.200
     2.357    40.551     0.200
     2.357    39.852     0.200
     0.564    10.672     0.200
     0.774    14.875     0.200
     0.774    14.875     0.200
     0.774    15.074     0.200
     1.591    29.074     0.200
     1.795    32.074     0.200
     1.895    33.172     0.200
     6.144   100.773     0.200
     0.164     3.992     0.200
     0.164     4.094     0.200
     0.223     4.594     0.200
     0.223     4.492     0.200
     0.223     4.789     0.200
     1.173    21.695     0.200
     1.173    21.492     0.200
     1.190    21.695     0.200
     1.342    24.391     0.200
     1.342    24.492     0.200
     0.151     3.570     0.200
     0.241     4.969     0.200
     1.142    20.969     0.200
     1.387    25.367     0.200
     0.086     2.113     0.200
     0.557    10.113     0.200
     0.557    10.512     0.200
     1.079    19.912     0.200
     1.382    25.012     0.200
     6.398   104.912     0.200
     0.400     8.090     0.200
     1.026    17.988     0.200
     1.669    29.590     0.200
     1.669    29.289     0.200
     1.669    30.090     0.200
     1.963    33.389     0.200
     6.408   104.488     0.200
     8.690   140.488     0.200
     0.113     2.206     0.200
     0.744    14.006     0.200
     1.024    19.706     0.200
     1.360    25.306     0.200
     1.228    22.606     0.200
     1.228    22.506     0.200
     1.613    29.206     0.200
     7.407   121.526     0.200
     7.407   123.406     0.200
     0.484     9.516     0.200
     0.530    10.414     0.200
     0.796    15.211     0.200
     0.796    15.312     0.200
     0.993    18.609     0.200
     1.406    25.312     0.200
     1.406    25.109     0.200
     1.877    32.414     0.200
     1.877    33.914     0.200
     1.877    32.211     0.200
     0.021     3.423     0.200
     0.384     7.523     0.200
     1.015    18.823     0.200
     1.234    22.623     0.200
     1.288    23.224     0.200
     1.288    23.023     0.200
     1.288    23.423     0.200
     2.107    35.523     0.200
     0.112     2.156     0.200
     0.741    14.055     0.200
     1.045    19.555     0.200
     1.045    19.055     0.200
     1.208    22.555     0.200
     1.380    25.254     0.200
     1.380    25.453     0.200
     1.612    29.156     0.200
     1.931    34.754     0.200
     1.931    35.156     0.200
     0.079     3.480     0.200
     0.552    10.883     0.200
     1.044    18.883     0.200
     1.346    23.980     0.200
     1.269    22.883     0.200
     1.803    32.082     0.200
     1.800    30.980     0.200
     0.258     5.238     0.200
     0.581    11.141     0.200
     0.581    11.039     0.200
     1.060    19.641     0.200
     1.276    23.441     0.200
     1.276    22.840     0.200
     1.577    28.738     0.200
     1.577    29.039     0.200
     1.793    32.238     0.200
     0.110     2.141     0.200
     0.110     2.039     0.200
     1.041    19.539     0.200
     1.377    25.242     0.200
     1.212    22.539     0.200
     1.614    28.844     0.200
     1.928    34.844     0.200
     2.312    39.742     0.200
     2.312    39.938     0.200
     0.242     5.121     0.200
     0.605    10.922     0.200
     0.790    14.523     0.200
     1.077    19.723     0.200
     1.414    25.523     0.200
     1.520    26.824     0.200
     1.939    33.223     0.200
     3.651    59.324     0.200
     6.322   104.324     0.200
     7.863   127.422     0.200
     0.151     4.594     0.200
     0.498     9.793     0.200
     0.498     9.895     0.200
     1.112    19.895     0.200
     1.112    20.094     0.200
     1.234    22.395     0.200
     1.403    24.895     0.200
     1.819    32.395     0.200
     3.161    51.395     0.200
     0.269     5.539     0.200
     0.580    10.844     0.200
     0.772    15.039     0.200
     0.772    14.844     0.200
     0.994    18.742     0.200
     0.994    18.641     0.200
     1.515    27.742     0.200
     1.515    27.945     0.200
     2.028    34.945     0.200
     2.010    34.242     0.200
     7.799   126.445     0.200
     0.174     4.766     0.200
     0.458     9.168     0.200
     1.044    18.469     0.200
     1.325    23.266     0.200
     1.321    23.668     0.200
     1.321    23.566     0.200
     1.733    30.266     0.200
     1.733    30.668     0.200
     1.733    30.566     0.200
     1.897    32.668     0.200
     1.897    32.867     0.200
     2.268    38.969     0.200
     0.108     3.839     0.200
     0.108     3.738     0.200
     0.469     8.938     0.200
     0.469     9.039     0.200
     0.920    16.938     0.200
     0.920    17.238     0.200
     1.382    24.938     0.200
     1.326    24.238     0.200
     2.045    35.339     0.200
     5.603    91.539     0.200
     0.190     3.407     0.200
     0.190     3.607     0.200
     0.516    10.007     0.200
     0.516    10.107     0.200
     0.825    15.407     0.200
     0.825    15.607     0.200
     0.960    17.808     0.200
     0.960    17.708     0.200
     1.375    26.007     0.200
     1.375    25.407     0.200
     0.191     3.126     0.200
     0.191     3.227     0.200
     0.514    10.227     0.200
     0.825    15.326     0.200
     0.825    15.826     0.200
     0.965    17.326     0.200
     0.965    17.727     0.200
     1.371    26.426     0.200
     1.370    25.326     0.200
     0.212     4.695     0.200
     0.567    10.297     0.200
     0.816    15.695     0.200
     1.081    20.500     0.200
     1.376    25.297     0.200
     1.486    26.898     0.200
     1.979    34.297     0.200
     0.223     4.292     0.200
     0.608    11.192     0.200
     1.067    20.192     0.200
     1.247    22.692     0.200
     1.554    27.893     0.200
     1.756    32.192     0.200
     1.985    36.093     0.200
     5.537    91.192     0.200
     0.210     4.082     0.200
     0.576    10.680     0.200
     1.228    22.383     0.200
     1.531    27.480     0.200
     1.952    34.680     0.200
     1.952    35.980     0.200
     1.952    34.883     0.200
     1.783    31.680     0.200
     1.783    31.980     0.200
     2.474    41.883     0.200
     0.208     4.094     0.200
     0.585    10.688     0.200
     1.228    22.492     0.200
     1.532    27.594     0.200
     1.774    31.789     0.200
     1.959    35.492     0.200
     6.143   102.891     0.200
     0.226     4.219     0.200
     0.581    10.820     0.200
     1.083    20.117     0.200
     1.083    20.219     0.200
     1.244    22.516     0.200
     1.244    23.016     0.200
     1.547    27.820     0.200
     1.547    27.719     0.200
     1.966    36.016     0.200
     1.966    35.219     0.200
     6.418   107.016     0.200
     7.489   124.484     0.200
     0.214     4.219     0.200
     0.603    11.125     0.200
     1.077    20.219     0.200
     1.238    22.625     0.200
     1.238    22.820     0.200
     1.545    27.820     0.200
     1.758    31.719     0.200
     1.758    31.523     0.200
     1.976    36.422     0.200
     2.487    43.125     0.200
     0.213     4.117     0.200
     0.603    11.219     0.200
     1.078    20.117     0.200
     1.237    22.922     0.200
     1.237    22.820     0.200
     1.543    27.516     0.200
     1.543    28.219     0.200
     1.758    31.617     0.200
     1.976    36.016     0.200
     7.948   132.617     0.200
     0.212     4.191     0.200
     0.594    10.594     0.200
     1.085    20.293     0.200
     1.234    22.293     0.200
     1.539    27.492     0.200
     1.767    31.895     0.200
     1.967    35.691     0.200
     8.971   148.191     0.200
     0.245     4.391     0.200
     0.608    11.191     0.200
     0.608    11.293     0.200
     1.051    19.590     0.200
     1.269    23.191     0.200
     1.575    28.391     0.200
     1.575    28.492     0.200
     1.763    31.492     0.200
     1.763    31.793     0.200
     1.998    35.590     0.200
     1.998    35.992     0.200
     6.100   100.191     0.200
     0.266     4.777     0.200
     0.618    11.375     0.200
     0.618    11.477     0.200
     1.030    19.176     0.200
     1.030    19.277     0.200
     1.291    24.078     0.200
     1.291    23.977     0.200
     1.597    28.676     0.200
     1.761    31.375     0.200
     2.499    43.676     0.200
     6.101   100.578     0.200
     0.230     4.528     0.200
     0.603    11.028     0.200
     1.253    22.829     0.200
     1.559    28.028     0.200
     1.763    31.829     0.200
     0.105     2.250     0.200
     0.583    10.648     0.200
     1.123    20.453     0.200
     1.182    21.852     0.200
     1.762    31.547     0.200
     1.762    31.852     0.200
     1.886    34.648     0.200
     6.723   110.547     0.200
     0.222     4.461     0.200
     0.587    10.863     0.200
     0.587    10.762     0.200
     1.081    19.961     0.200
     1.243    22.562     0.200
     1.243    22.863     0.200
     1.546    27.863     0.200
     1.969    35.363     0.200
     0.516    10.144     0.200
     0.830    15.243     0.200
     0.796    15.043     0.200
     1.455    26.343     0.200
     1.770    31.144     0.200
     1.760    30.644     0.200
     1.760    31.743     0.200
     1.916    33.243     0.200
     6.233   101.943     0.200
     0.222     4.527     0.200
     0.576    11.129     0.200
     1.089    20.629     0.200
     1.541    27.930     0.200
     1.541    27.828     0.200
     1.786    32.230     0.200
     1.786    32.027     0.200
     1.960    35.430     0.200
     7.936   129.930     0.200
     0.159     3.680     0.200
     0.753    14.879     0.200
     1.577    28.480     0.200
     1.617    29.180     0.200
     0.119     3.498     0.200
     0.516     9.697     0.200
     1.259    22.697     0.200
     1.369    24.297     0.200
     1.802    31.396     0.200
     1.802    32.197     0.200
     1.802    31.498     0.200
     1.832    31.697     0.200
     0.269     5.977     0.200
     0.986    18.375     0.200
     0.986    18.477     0.200
     0.768    14.777     0.200
     1.598    27.977     0.200
     1.605    28.574     0.200
     8.922   144.777     0.200
     0.220     4.453     0.200
     0.220     4.555     0.200
     0.573    11.055     0.200
     1.093    20.555     0.200
     1.093    20.453     0.200
     1.538    27.852     0.200
     1.788    32.148     0.200
     1.788    32.250     0.200
     1.956    35.453     0.200
     0.227     4.813     0.200
     0.756    14.513     0.200
     1.030    19.013     0.200
     1.599    27.913     0.200
     3.424    59.013     0.200
     8.644   143.013     0.200
     0.212     4.242     0.200
     0.565    10.641     0.200
     1.105    20.438     0.200
     1.226    22.438     0.200
     1.527    27.438     0.200
     1.794    32.141     0.200
     1.943    34.641     0.200
     0.458     8.676     0.200
     0.614    11.676     0.200
     0.688    13.375     0.200
     1.148    21.078     0.200
     1.148    20.977     0.200
     1.219    22.477     0.200
     1.343    25.578     0.200
     5.791    95.176     0.200
     0.224     4.702     0.200
     0.576    11.202     0.200
     1.088    21.102     0.200
     1.088    20.702     0.200
     1.241    22.902     0.200
     1.543    28.102     0.200
     1.543    27.902     0.200
     1.787    32.302     0.200
     1.787    32.702     0.200
     1.787    32.202     0.200
     1.961    35.402     0.200
     1.961    35.302     0.200
     0.223     4.383     0.200
     0.617    11.281     0.200
     1.062    19.883     0.200
     1.248    22.883     0.200
     1.248    22.984     0.200
     1.557    28.086     0.200
     1.557    27.984     0.200
     1.747    31.484     0.200
     6.455   106.883     0.200
     7.071   116.484     0.200
     0.111     2.254     0.200
     1.112    20.355     0.200
     1.205    21.754     0.200
     1.205    23.254     0.200
     1.791    31.754     0.200
     1.791    31.953     0.200
     1.858    33.656     0.200
     0.099     1.996     0.200
     0.575    10.594     0.200
     1.111    20.195     0.200
     1.196    21.797     0.200
     1.196    23.297     0.200
     1.196    22.395     0.200
     1.417    25.695     0.200
     1.417    25.594     0.200
     1.771    31.297     0.200
     1.771    31.195     0.200
     2.360    41.094     0.200
     6.326   105.297     0.200
     0.109     2.598     0.200
     0.576    11.098     0.200
     1.124    20.699     0.200
     1.184    22.297     0.200
     1.184    22.098     0.200
     1.430    26.098     0.200
     1.430    25.996     0.200
     1.770    32.098     0.200
     1.770    31.898     0.200
     1.882    34.098     0.200
     1.882    34.797     0.200
     1.882    34.297     0.200
     0.107     2.234     0.200
     0.107     2.336     0.200
     0.589    10.836     0.200
     1.127    20.535     0.200
     1.176    22.035     0.200
     1.435    26.133     0.200
     1.756    31.336     0.200
     1.756    31.234     0.200
     1.893    34.035     0.200
     2.378    41.535     0.200
     0.118     2.262     0.200
     0.575    10.762     0.200
     1.133    20.164     0.200
     1.176    21.262     0.200
     1.439    25.562     0.200
     1.439    26.664     0.200
     1.888    34.461     0.200
     1.770    31.762     0.200
     0.120     2.246     0.200
     0.591    10.945     0.200
     1.163    21.746     0.200
     1.141    20.848     0.200
     1.449    26.547     0.200
     1.755    31.945     0.200
     1.755    31.348     0.200
     1.904    34.547     0.200
     1.904    34.445     0.200
     0.110     1.820     0.200
     1.134    20.719     0.200
     1.134    20.820     0.200
     1.164    21.020     0.200
     1.444    25.820     0.200
     1.744    31.121     0.200
     1.744    30.820     0.200
     0.106     2.637     0.200
     0.567    10.738     0.200
     1.116    20.836     0.200
     1.195    22.238     0.200
     1.195    22.137     0.200
     1.421    25.836     0.200
     1.778    32.238     0.200
     1.778    31.738     0.200
     0.110     2.027     0.200
     0.561    10.328     0.200
     0.561    10.527     0.200
     1.198    21.527     0.200
     1.198    23.426     0.200
     1.420    25.426     0.200
     1.784    31.527     0.200
     1.866    33.527     0.200
     1.866    34.227     0.200
     0.104     2.352     0.200
     0.590    11.352     0.200
     1.178    21.652     0.200
     1.433    26.152     0.200
     1.756    31.152     0.200
     1.891    34.152     0.200
     0.048     0.658     0.200
     1.072    19.459     0.200
     1.865    33.158     0.200
     3.223    53.758     0.200
     0.277     6.227     0.200
     0.557    10.828     0.200
     0.557    10.633     0.200
     0.788    14.828     0.200
     0.788    14.727     0.200
     0.977    17.828     0.200
     1.273    23.227     0.200
     1.498    27.227     0.200
     1.498    27.328     0.200
     2.074    34.531     0.200
     0.536    10.472     0.200
     0.814    15.571     0.200
     0.831    15.371     0.200
     1.464    26.771     0.200
     1.752    31.371     0.200
     1.752    30.871     0.200
     1.775    30.972     0.200
     1.900    32.972     0.200
     0.449     8.633     0.200
     0.381     7.535     0.200
     1.162    20.633     0.200
     1.369    24.434     0.200
     1.624    28.035     0.200
     1.624    28.836     0.200
     1.624    28.734     0.200
     2.051    35.535     0.200
     2.051    35.234     0.200
     0.186     3.590     0.200
     0.186     3.789     0.200
     0.566    10.789     0.200
     0.851    16.090     0.200
     0.851    15.891     0.200
     1.482    27.289     0.200
     0.303     6.072     0.200
     0.663    12.872     0.200
     0.663    12.472     0.200
     0.979    18.072     0.200
     1.331    24.072     0.200
     1.331    23.772     0.200
     1.641    28.972     0.200
     1.730    29.772     0.200
     1.730    30.072     0.200
     2.070    34.972     0.200
     5.687    91.972     0.200
     0.245     5.172     0.200
     0.399     8.070     0.200
     0.399     7.969     0.200
     1.389    25.773     0.200
     1.389    25.469     0.200
     1.282    24.367     0.200
     1.658    29.773     0.200
     1.968    34.172     0.200
     7.636   124.672     0.200
     0.239     5.172     0.200
     0.984    18.471     0.200
     0.984    18.172     0.200
     1.250    22.871     0.200
     1.411    25.672     0.200
     1.642    29.771     0.200
     1.959    34.971     0.200
     6.098    99.871     0.200
     7.614   124.971     0.200
     0.406     8.599     0.200
     0.406     8.198     0.200
     0.623    12.298     0.200
     0.794    14.698     0.200
     0.954    17.898     0.200
     1.635    29.099     0.200
     1.635    28.798     0.200
     1.796    31.298     0.200
     1.589    28.398     0.200
     1.889    34.798     0.200
     0.252     5.393     0.200
     0.432     7.893     0.200
     0.952    17.793     0.200
     1.216    22.492     0.200
     1.441    25.793     0.200
     1.615    29.393     0.200
     1.964    34.992     0.200
     4.028    65.692     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
    17.571   439.750     0.200
    20.366   507.750     0.200
    20.664   513.375     0.200
     5.630   145.477     0.200
     7.541   189.477     0.200
     5.812   148.891     0.200
     7.707   196.188     0.200
     7.707   196.688     0.200
    16.107   395.391     0.200
    21.252   530.789     0.200
     7.815   197.531     0.200
    20.704   511.531     0.200
    21.339   523.730     0.200
     5.272   141.004     0.200
     6.367   164.404     0.200
     7.234   186.004     0.200
     1.296    43.109     0.200
     1.550    47.914     0.200
     2.372    68.914     0.200
     6.794   174.070     0.200
     8.546   217.473     0.200
    17.314   438.871     0.200
     2.889    81.515     0.200
     7.232   185.815     0.200
     7.232   185.615     0.200
     1.937    57.840     0.200
     3.738   102.340     0.200
    16.902   417.941     0.200
     1.520    49.281     0.200
     2.285    65.781     0.200
     2.467    69.484     0.200
     3.036    82.383     0.200
     3.707    99.781     0.200
     4.392   114.781     0.200
     4.713   122.781     0.200
     4.713   122.281     0.200
     5.690   147.984     0.200
     5.920   153.281     0.200
     6.351   164.781     0.200
     6.788   171.281     0.200
     7.656   195.984     0.200
     7.656   195.383     0.200
     7.818   198.781     0.200
    11.159   277.781     0.200
    20.153   498.732     0.200
     2.854    81.898     0.200
     3.322    91.398     0.200
     3.666    97.898     0.200
     6.965   180.898     0.200
     8.599   218.398     0.200
    18.221   449.898     0.200
    19.499   485.898     0.200
    19.574   487.898     0.200
     1.810    54.398     0.200
     6.458   166.297     0.200
    10.523   259.398     0.200
    15.652   384.898     0.200
     3.470    95.115     0.200
     5.852   149.416     0.200
     7.828   200.516     0.200
    17.765   441.115     0.200
    19.621   491.705     0.200
    19.621   492.115     0.200
    19.930   496.615     0.200
     1.970    58.252     0.200
     4.836   124.252     0.200
     6.026   155.652     0.200
     6.698   170.152     0.200
     7.823   197.053     0.200
     7.935   203.553     0.200
     7.935   202.652     0.200
     8.025   202.353     0.200
    16.809   409.353     0.200
     2.591    73.523     0.200
     3.413    95.320     0.200
     3.684    99.422     0.200
     4.922   130.023     0.200
     6.898   179.320     0.200
     7.746   197.523     0.200
     2.104    60.617     0.200
     4.613   123.219     0.200
     5.863   151.320     0.200
     5.898   150.719     0.200
     6.536   166.219     0.200
     6.536   167.117     0.200
     7.668   196.414     0.200
     7.764   196.719     0.200
     7.764   197.117     0.200
     7.850   197.414     0.200
     7.850   197.219     0.200
     3.888   103.879     0.200
     4.093   106.980     0.200
     4.361   114.480     0.200
     1.414    44.859     0.200
     1.763    52.059     0.200
     2.120    60.660     0.200
     4.100   108.961     0.200
     4.183   109.559     0.200
     6.438   165.160     0.200
     8.635   217.160     0.200
     2.261    63.031     0.200
     2.387    67.632     0.200
     4.433   117.031     0.200
     4.434   117.031     0.200
     4.448   117.632     0.200
     5.094   131.331     0.200
     5.695   147.632     0.200
     5.733   148.731     0.200
     6.369   161.731     0.200
     6.752   172.432     0.200
     7.595   195.031     0.200
     7.595   192.731     0.200
     7.684   193.932     0.200
     8.414   209.531     0.200
     1.946    57.918     0.200
     1.946    56.217     0.200
     2.236    64.018     0.200
     3.024    81.818     0.200
     3.884   103.918     0.200
     6.242   160.617     0.200
     7.650   192.145     0.200
     8.529   216.617     0.200
     8.697   219.117     0.200
     1.731    55.041     0.200
     1.731    54.240     0.200
     2.828    79.641     0.200
     3.094    85.740     0.200
     3.882   104.141     0.200
     4.021   107.641     0.200
     4.074   110.141     0.200
     4.074   109.641     0.200
     6.371   165.740     0.200
     8.695   224.041     0.200
     8.695   220.840     0.200
     1.524    48.586     0.200
     2.206    63.086     0.200
     2.206    63.289     0.200
     2.226    65.988     0.200
     2.828    80.289     0.200
     3.625    97.188     0.200
     3.641    97.488     0.200
     3.954   105.789     0.200
     4.852   129.387     0.200
     5.077   134.289     0.200
     5.355   140.086     0.200
     5.580   144.688     0.200
     6.361   162.789     0.200
     7.526   191.887     0.200
     8.407   212.086     0.200
     8.407   214.586     0.200
     8.606   218.488     0.200
     1.216    41.801     0.200
     2.072    60.501     0.200
     2.072    60.400     0.200
     3.486    94.801     0.200
     4.964   128.001     0.200
     5.931   152.400     0.200
     6.953   176.501     0.200
     7.796   197.700     0.200
     7.881   199.700     0.200
     7.881   199.900     0.200
     2.302    66.297     0.200
     2.302    65.297     0.200
     2.449    69.398     0.200
     3.241    88.898     0.200
     4.401   115.398     0.200
     4.396   116.496     0.200
     4.860   126.898     0.200
     4.862   126.598     0.200
     5.154   133.297     0.200
     5.643   147.496     0.200
     5.643   144.898     0.200
     5.684   147.297     0.200
     6.317   162.398     0.200
     6.698   171.898     0.200
     7.456   189.898     0.200
     7.539   190.598     0.200
     7.624   193.297     0.200
     8.451   212.496     0.200
    10.046   252.098     0.200
    11.157   276.496     0.200
    20.230   504.023     0.200
    20.193   506.598     0.200
    20.590   510.098     0.200
    21.060   524.496     0.200
    22.046   544.199     0.200
     2.334    66.180     0.200
     2.334    67.379     0.200
     2.483    71.277     0.200
     3.205    89.180     0.200
     3.963   106.578     0.200
     4.218   113.578     0.200
     4.365   116.480     0.200
     4.368   117.078     0.200
     4.795   125.777     0.200
     5.202   134.480     0.200
     5.647   146.879     0.200
     6.358   165.180     0.200
     6.655   171.879     0.200
     7.495   189.879     0.200
     7.577   193.680     0.200
     2.517    71.891     0.200
     3.237    88.594     0.200
     4.397   116.297     0.200
     5.196   133.797     0.200
     6.684   173.695     0.200
     7.523   191.094     0.200
     2.299    65.562     0.200
     2.299    66.465     0.200
     2.512    72.164     0.200
     3.241    88.363     0.200
     4.401   116.965     0.200
     6.315   162.562     0.200
     6.692   170.562     0.200
     7.532   190.965     0.200
     7.614   192.762     0.200
     2.313    67.555     0.200
     3.224    89.154     0.200
     3.957   107.555     0.200
     4.384   117.955     0.200
     5.120   134.254     0.200
     5.210   135.455     0.200
     5.666   145.955     0.200
     6.296   161.754     0.200
     6.386   164.254     0.200
     6.670   171.955     0.200
     7.587   194.355     0.200
     2.299    65.811     0.200
     2.506    69.412     0.200
     5.158   132.711     0.200
     7.540   191.111     0.200
     7.624   195.711     0.200
     2.314    67.031     0.200
     2.506    71.828     0.200
     3.158    88.430     0.200
     3.224    89.133     0.200
     4.238   112.633     0.200
     4.384   116.227     0.200
     4.384   116.828     0.200
     5.204   133.930     0.200
     5.423   144.828     0.200
     5.621   146.531     0.200
     5.621   146.430     0.200
     6.380   166.031     0.200
     6.671   171.633     0.200
     7.510   193.531     0.200
     7.589   193.430     0.200
    11.180   273.367     0.200
    15.935   392.727     0.200
     2.301    66.391     0.200
     2.509    73.594     0.200
     4.400   117.188     0.200
     4.400   116.891     0.200
     4.399   116.992     0.200
     5.172   133.688     0.200
     5.640   147.188     0.200
     6.314   161.492     0.200
     6.692   171.492     0.200
     7.533   193.594     0.200
     7.615   195.789     0.200
     8.471   211.789     0.200
     2.499    72.746     0.200
     2.518    73.645     0.200
     3.206    88.348     0.200
     4.250   114.848     0.200
     4.366   118.348     0.200
     4.366   117.047     0.200
     4.377   118.645     0.200
     4.801   126.547     0.200
     5.232   137.047     0.200
     5.600   145.547     0.200
     5.647   147.445     0.200
     6.276   162.645     0.200
     6.386   164.848     0.200
     6.649   173.145     0.200
     6.649   172.746     0.200
     7.487   193.547     0.200
     8.517   216.742     0.200
     2.300    66.070     0.200
     3.164    89.375     0.200
     4.404   115.875     0.200
     5.687   147.172     0.200
     6.321   161.977     0.200
     6.702   171.477     0.200
     7.544   194.570     0.200
     7.630   194.477     0.200
     2.305    66.574     0.200
     2.659    73.676     0.200
     3.854   103.977     0.200
     8.564   218.074     0.200
     8.564   219.176     0.200
     1.141    39.852     0.200
     1.628    51.151     0.200
     2.299    67.352     0.200
     3.871   103.852     0.200
     3.871   104.752     0.200
     3.747   103.151     0.200
     5.181   136.052     0.200
     2.309    66.371     0.200
     3.232    90.371     0.200
     3.930   107.172     0.200
     5.172   134.473     0.200
     6.307   162.672     0.200
     6.685   172.371     0.200
     6.685   173.871     0.200
     7.609   193.371     0.200
     2.428    70.523     0.200
     2.459    69.223     0.200
     3.702   100.922     0.200
     5.087   133.523     0.200
     8.460   215.125     0.200
    11.798   296.523     0.200
     2.105    62.207     0.200
     2.679    78.207     0.200
     5.045   131.809     0.200
     6.476   168.406     0.200
     7.737   198.906     0.200
     7.814   201.707     0.200
     4.325   117.195     0.200
     4.338   117.094     0.200
     5.257   137.094     0.200
     5.559   145.000     0.200
     5.606   146.797     0.200
     5.606   146.297     0.200
     6.607   169.094     0.200
     7.446   191.398     0.200
     7.524   192.594     0.200
     2.332    69.613     0.200
     3.366    92.513     0.200
     4.094   110.013     0.200
     1.537    47.852     0.200
     1.551    48.648     0.200
     1.551    48.449     0.200
     2.352    67.551     0.200
     2.801    75.051     0.200
     3.628    97.551     0.200
     3.782   100.148     0.200
     1.591    50.973     0.200
     1.591    51.074     0.200
     2.267    66.973     0.200
     3.128    88.074     0.200
     3.494    96.273     0.200
     4.384   118.273     0.200
     5.684   149.875     0.200
     6.409   164.172     0.200
     7.492   190.875     0.200
     2.252    64.891     0.200
     3.292    91.391     0.200
     4.452   118.695     0.200
     7.591   196.891     0.200
     7.591   192.789     0.200
     7.675   194.695     0.200
     2.324    66.969     0.200
     3.217    90.172     0.200
     4.378   116.773     0.200
     4.375   116.469     0.200
     5.174   133.273     0.200
     6.293   164.367     0.200
     6.293   160.273     0.200
     6.673   170.969     0.200
     7.514   192.469     0.200
     7.514   192.273     0.200
     7.599   192.672     0.200
     7.599   192.367     0.200
     1.382    46.912     0.200
     1.835    58.613     0.200
     1.835    58.512     0.200
     3.961   108.812     0.200
     7.637   191.289     0.200
     8.245   209.689     0.200
     8.690   218.689     0.200
    17.122   425.189     0.200
    17.831   446.590     0.200
    18.821   468.090     0.200
    20.863   519.590     0.200
     2.698    77.206     0.200
     3.625    99.906     0.200
     4.082   109.306     0.200
     4.218   114.006     0.200
     4.218   116.906     0.200
     5.448   143.406     0.200
     6.745   177.106     0.200
     7.407   191.806     0.200
     7.836   200.006     0.200
     7.836   200.106     0.200
     8.697   225.206     0.200
     8.826   227.006     0.200
    21.198   529.406     0.200
     2.571    74.312     0.200
     2.776    77.312     0.200
     2.727    77.312     0.200
     2.885    81.312     0.200
     3.675    99.711     0.200
     3.881   105.812     0.200
     3.881   105.016     0.200
     5.166   132.812     0.200
     5.166   133.812     0.200
     5.170   135.711     0.200
     5.758   151.016     0.200
     5.831   150.914     0.200
     5.831   150.812     0.200
     6.257   159.016     0.200
     7.123   181.711     0.200
     7.123   181.516     0.200
     8.139   209.133     0.200
    17.710   442.609     0.200
    21.376   531.312     0.200
     1.015    36.224     0.200
     1.234    41.523     0.200
     1.288    40.923     0.200
     1.288    40.923     0.200
     1.288    41.224     0.200
     2.107    60.923     0.200
     2.663    74.923     0.200
     4.892   125.523     0.200
     7.758   196.923     0.200
     7.844   199.724     0.200
     1.612    52.555     0.200
     2.316    69.453     0.200
     4.062   110.754     0.200
     4.317   116.055     0.200
     1.800    54.082     0.200
     1.800    53.781     0.200
     2.289    65.383     0.200
     3.992   105.582     0.200
     1.793    58.641     0.200
     3.774   103.340     0.200
     3.774   102.840     0.200
     4.026   108.941     0.200
     5.538   144.738     0.200
     6.413   166.039     0.200
    10.059   247.727     0.200
     1.377    47.539     0.200
     1.614    52.141     0.200
     4.064   109.344     0.200
     4.064   110.438     0.200
     5.459   142.344     0.200
     1.077    37.523     0.200
     1.414    45.422     0.200
     1.414    44.824     0.200
     1.939    56.223     0.200
     3.466    91.723     0.200
     4.790   123.422     0.200
     7.981   204.723     0.200
    10.737   262.344     0.200
     2.346    68.594     0.200
     3.161    86.992     0.200
     3.615    97.195     0.200
     3.915   105.594     0.200
     5.370   140.293     0.200
     8.824   223.695     0.200
     2.028    59.141     0.200
     3.398    90.945     0.200
     3.591    97.742     0.200
     4.124   109.445     0.200
     4.737   123.445     0.200
     7.090   182.945     0.200
     7.942   201.445     0.200
     8.050   204.141     0.200
    10.796   268.742     0.200
     1.897    54.168     0.200
     2.268    65.168     0.200
     6.291   163.266     0.200
     1.382    43.738     0.200
     1.382    43.938     0.200
     1.326    42.639     0.200
     2.045    58.639     0.200
     2.045    57.938     0.200
     3.339    88.938     0.200
     3.410    88.738     0.200
     4.536   118.039     0.200
     5.939   152.738     0.200
     6.611   166.539     0.200
     7.000   176.839     0.200
     7.316   185.839     0.200
     7.845   196.539     0.200
     7.845   199.438     0.200
     7.935   200.938     0.200
     7.935   200.039     0.200
     1.375    47.808     0.200
     2.616    74.907     0.200
     2.616    74.507     0.200
     2.627    76.407     0.200
     2.840    83.808     0.200
     2.950    83.308     0.200
     3.478    95.208     0.200
     3.932   106.708     0.200
     4.075   112.407     0.200
     4.109   113.308     0.200
     4.109   111.607     0.200
     5.173   135.808     0.200
     5.173   136.308     0.200
     7.421   192.208     0.200
     1.370    47.626     0.200
     2.615    74.426     0.200
     2.615    74.626     0.200
     2.624    76.826     0.200
     2.841    83.026     0.200
     4.076   111.926     0.200
     5.168   136.126     0.200
     5.168   136.326     0.200
     5.624   147.826     0.200
     7.301   189.826     0.200
     7.425   193.826     0.200
     1.081    37.695     0.200
     1.486    46.898     0.200
     1.979    57.398     0.200
     2.769    77.797     0.200
     3.318    89.297     0.200
     3.480    93.000     0.200
     3.500    94.898     0.200
     3.610    97.594     0.200
     4.431   116.695     0.200
     4.615   120.695     0.200
     4.769   124.797     0.200
     4.807   125.094     0.200
     5.018   130.695     0.200
     5.449   141.797     0.200
     5.687   146.797     0.200
     6.281   160.797     0.200
     6.701   172.000     0.200
     7.095   180.000     0.200
     7.822   199.094     0.200
     7.942   200.695     0.200
     8.037   203.500     0.200
     1.554    51.993     0.200
     2.497    74.493     0.200
     3.464    96.593     0.200
     3.812   104.393     0.200
     4.125   113.593     0.200
     6.446   170.292     0.200
     1.531    50.980     0.200
     1.952    59.883     0.200
     1.783    57.781     0.200
     3.480    94.781     0.200
     3.486    96.781     0.200
     3.821   104.180     0.200
     4.034   109.383     0.200
     4.369   113.582     0.200
     8.959   229.082     0.200
    16.902   410.242     0.200
     1.228    44.094     0.200
     1.532    51.094     0.200
     1.774    57.789     0.200
     3.477    95.789     0.200
     3.476    98.789     0.200
     3.824   103.891     0.200
     6.425   169.789     0.200
     7.932   201.289     0.200
     8.803   226.891     0.200
     8.963   229.992     0.200
     1.547    52.016     0.200
     2.553    71.414     0.200
     2.490    70.320     0.200
     3.806   104.320     0.200
     4.035   110.016     0.200
     5.518   142.820     0.200
     8.975   228.117     0.200
    10.075   256.516     0.200
    16.897   410.930     0.200
    18.374   458.719     0.200
    19.095   478.617     0.200
    19.821   500.211     0.200
    19.952   503.617     0.200
    20.704   518.516     0.200
    21.108   528.117     0.200
     1.238    44.125     0.200
     1.976    60.422     0.200
     2.487    73.523     0.200
     3.464    96.922     0.200
     3.820   105.523     0.200
     4.059   107.219     0.200
     1.543    51.320     0.200
     1.758    56.320     0.200
     3.463    95.820     0.200
     3.821   104.719     0.200
     4.116   112.320     0.200
    10.062   257.719     0.200
     1.234    43.992     0.200
     1.539    50.793     0.200
     4.051   109.492     0.200
     1.269    45.691     0.200
     1.998    61.891     0.200
     2.517    73.793     0.200
     2.517    73.492     0.200
     3.332    91.590     0.200
     3.434    95.090     0.200
     3.790   103.191     0.200
     4.416   117.793     0.200
     5.551   145.891     0.200
     5.618   148.492     0.200
     6.082   159.090     0.200
     6.084   160.191     0.200
     6.442   166.891     0.200
     6.442   167.090     0.200
    16.871   409.949     0.200
     2.540    73.977     0.200
     3.477    96.277     0.200
     3.770   102.777     0.200
     3.770   103.477     0.200
     7.542   195.078     0.200
     7.972   201.777     0.200
     8.867   228.875     0.200
     1.559    51.429     0.200
     1.985    61.429     0.200
     8.831   229.829     0.200
    16.876   409.338     0.200
     1.182    42.148     0.200
     1.430    48.047     0.200
     3.440    94.148     0.200
     3.571    97.648     0.200
     3.571    99.750     0.200
     5.434   143.750     0.200
     7.847   201.352     0.200
     8.716   226.047     0.200
     8.869   226.352     0.200
     2.489    73.262     0.200
     3.810   103.660     0.200
     3.810   103.863     0.200
     4.042   110.461     0.200
     6.425   165.562     0.200
     8.976   229.262     0.200
     8.976   229.461     0.200
     1.455    46.343     0.200
     1.916    57.543     0.200
     3.392    91.343     0.200
     8.169   207.743     0.200
     1.541    50.828     0.200
     2.484    71.629     0.200
     3.294    90.430     0.200
     3.470    95.730     0.200
     3.491    96.828     0.200
     3.810   104.430     0.200
     3.810   104.629     0.200
     4.031   109.230     0.200
     5.512   143.527     0.200
     6.414   167.527     0.200
     7.483   192.527     0.200
     8.969   230.930     0.200
    10.081   254.172     0.200
    10.081   255.129     0.200
     1.410    46.480     0.200
     1.617    51.680     0.200
     2.445    69.379     0.200
     3.372    92.480     0.200
     3.661    99.680     0.200
     4.032   106.777     0.200
     4.128   108.879     0.200
     4.556   123.879     0.200
     5.132   136.980     0.200
     5.132   133.879     0.200
     6.656   169.480     0.200
     7.972   204.180     0.200
     8.746   224.578     0.200
     1.369    44.998     0.200
     1.832    55.498     0.200
     2.312    65.396     0.200
     2.312    68.297     0.200
     2.312    68.098     0.200
     3.494    93.896     0.200
     3.947   105.896     0.200
     3.955   105.197     0.200
     3.955   106.797     0.200
     3.991   107.297     0.200
     4.214   114.197     0.200
     4.512   119.797     0.200
     4.590   120.396     0.200
     5.352   139.498     0.200
     6.258   158.998     0.200
     6.879   176.098     0.200
     7.320   186.098     0.200
     8.638   216.598     0.200
     8.796   221.697     0.200
     8.796   222.297     0.200
    12.276   306.797     0.200
     1.605    49.676     0.200
     2.104    62.074     0.200
     2.544    70.875     0.200
     3.315    88.074     0.200
     3.455    92.875     0.200
     3.851   102.074     0.200
     4.269   112.977     0.200
     4.221   114.277     0.200
     4.509   119.977     0.200
     5.650   145.375     0.200
     6.061   156.074     0.200
     6.939   177.574     0.200
     8.056   204.574     0.200
     2.481    72.648     0.200
     3.290    92.352     0.200
     3.812   105.352     0.200
     4.029   107.953     0.200
     4.029   108.953     0.200
     4.094   110.055     0.200
     4.341   116.352     0.200
     4.374   114.555     0.200
     5.509   143.148     0.200
     5.809   149.953     0.200
     6.139   159.750     0.200
     6.797   173.953     0.200
     7.036   179.953     0.200
     8.531   217.648     0.200
    12.447   312.555     0.200
     1.030    36.113     0.200
     1.561    48.813     0.200
     1.561    50.213     0.200
     2.499    72.913     0.200
     6.598   171.913     0.200
    12.469   310.213     0.200
     1.527    50.641     0.200
     1.794    57.844     0.200
     3.495    96.539     0.200
     3.820   103.938     0.200
     8.953   229.938     0.200
     1.219    44.176     0.200
     1.343    48.375     0.200
     2.723    75.777     0.200
     2.744    79.578     0.200
     2.907    84.078     0.200
     3.367    92.676     0.200
     4.057   109.977     0.200
     4.033   107.777     0.200
     4.056   109.875     0.200
     4.694   125.078     0.200
     4.964   132.977     0.200
     4.991   131.875     0.200
     4.991   132.078     0.200
     5.579   143.578     0.200
     5.791   152.078     0.200
     6.445   164.977     0.200
     7.312   191.176     0.200
     7.478   190.477     0.200
     7.478   194.977     0.200
     1.543    51.202     0.200
     2.486    72.302     0.200
     2.557    74.702     0.200
     3.295    90.702     0.200
     3.492    95.202     0.200
     3.469    97.802     0.200
     3.808   104.402     0.200
     3.808   105.002     0.200
     4.031   108.902     0.200
     4.099   110.302     0.200
     4.378   115.602     0.200
     5.285   138.602     0.200
     5.513   144.702     0.200
     5.513   145.102     0.200
     5.581   147.602     0.200
     5.814   152.102     0.200
     6.113   159.702     0.200
     6.418   165.602     0.200
     6.414   168.702     0.200
     6.414   169.602     0.200
     7.484   191.901     0.200
     7.937   203.002     0.200
     8.018   206.702     0.200
     8.809   224.901     0.200
     8.809   225.302     0.200
     8.971   226.702     0.200
    10.080   253.002     0.200
     3.447    96.484     0.200
     3.455    94.086     0.200
     3.814   104.680     0.200
     3.814   104.883     0.200
     4.071   110.180     0.200
     4.408   117.281     0.200
     5.544   145.680     0.200
     6.116   159.883     0.200
     6.455   167.484     0.200
     8.016   204.484     0.200
     8.992   227.586     0.200
     9.475   243.109     0.200
    10.045   256.680     0.200
    12.774   317.711     0.200
     1.414    48.055     0.200
     1.858    59.055     0.200
     3.465    94.355     0.200
     3.592    98.453     0.200
     3.929   106.754     0.200
     3.929   107.355     0.200
     5.407   142.355     0.200
     5.717   148.754     0.200
     6.242   162.453     0.200
     6.313   165.055     0.200
     6.398   166.355     0.200
     7.822   199.555     0.200
     8.146   210.656     0.200
     8.434   214.855     0.200
     8.692   221.754     0.200
     8.847   224.656     0.200
     1.417    47.797     0.200
     1.872    57.996     0.200
     2.360    69.395     0.200
     3.445    92.797     0.200
     3.936   107.496     0.200
     5.420   140.094     0.200
     8.149   206.395     0.200
     8.855   224.895     0.200
     8.855   226.594     0.200
     9.387   240.273     0.200
    10.158   258.797     0.200
     1.430    48.598     0.200
     1.770    57.297     0.200
     1.882    59.496     0.200
     3.447    95.199     0.200
     3.924   107.199     0.200
     4.028   109.398     0.200
     4.049   109.199     0.200
     4.292   115.699     0.200
     5.430   141.398     0.200
     6.420   165.797     0.200
     8.458   215.898     0.200
     8.714   222.496     0.200
     8.867   225.398     0.200
     8.867   227.496     0.200
     1.176    42.133     0.200
     1.435    48.734     0.200
     3.435    95.336     0.200
     3.925   106.633     0.200
     3.925   106.934     0.200
     8.875   226.133     0.200
    10.137   255.836     0.200
    20.682   516.703     0.200
     1.439    47.863     0.200
     1.888    58.664     0.200
     3.915   105.961     0.200
     1.163    42.145     0.200
     1.449    48.848     0.200
     1.904    59.746     0.200
     2.392    70.145     0.200
     2.636    76.945     0.200
     3.252    91.246     0.200
     3.438    95.547     0.200
     3.912   106.945     0.200
     3.912   107.047     0.200
     4.063   110.547     0.200
     4.063   107.445     0.200
     4.049   109.746     0.200
     4.314   115.848     0.200
     4.426   118.645     0.200
     5.232   138.348     0.200
     5.452   144.547     0.200
     6.002   157.945     0.200
     6.207   162.848     0.200
     6.435   167.547     0.200
     7.420   191.547     0.200
     8.480   216.145     0.200
     8.735   223.445     0.200
     8.735   224.445     0.200
     8.888   227.246     0.200
    10.127   257.945     0.200
     1.134    41.020     0.200
     1.164    41.320     0.200
     1.444    48.922     0.200
     1.906    58.422     0.200
     2.387    69.422     0.200
     3.256    91.219     0.200
     3.425    94.820     0.200
     3.922   106.621     0.200
     3.922   106.520     0.200
     4.315   116.520     0.200
     4.430   117.719     0.200
     5.454   144.520     0.200
     5.454   141.422     0.200
     6.006   157.520     0.200
     6.446   168.820     0.200
     8.734   221.520     0.200
     8.886   225.820     0.200
     1.116    40.238     0.200
     1.195    42.539     0.200
     1.421    48.238     0.200
     1.870    59.137     0.200
     2.364    68.039     0.200
     2.667    76.938     0.200
     3.219    90.738     0.200
     3.453    94.738     0.200
     3.929   107.137     0.200
     4.016   109.137     0.200
     4.041   110.539     0.200
     4.456   119.336     0.200
     5.419   142.336     0.200
     5.419   141.836     0.200
     5.730   149.137     0.200
     5.813   152.238     0.200
     5.969   156.137     0.200
     6.411   167.438     0.200
     7.833   200.438     0.200
     8.703   222.039     0.200
     8.703   223.336     0.200
     8.857   225.336     0.200
     1.420    47.727     0.200
     1.866    59.027     0.200
     5.415   141.625     0.200
    10.165   258.426     0.200
    17.709   440.797     0.200
     1.125    40.453     0.200
     1.433    48.352     0.200
     1.756    56.652     0.200
     3.241    90.254     0.200
     3.434    94.055     0.200
     3.927   107.055     0.200
     4.300   115.453     0.200
     4.442   118.754     0.200
     5.439   142.555     0.200
     5.991   155.852     0.200
     6.223   161.652     0.200
     6.434   167.555     0.200
     7.407   188.953     0.200
     7.852   201.852     0.200
     8.468   216.652     0.200
     8.721   220.852     0.200
     8.873   224.852     0.200
     1.865    59.258     0.200
     2.327    69.459     0.200
     3.223    90.357     0.200
     4.015   108.959     0.200
     4.084   111.158     0.200
     4.268   115.158     0.200
     5.410   141.158     0.200
     5.728   151.158     0.200
     8.192   210.258     0.200
     8.684   221.158     0.200
     8.684   222.459     0.200
     8.831   225.459     0.200
    10.161   257.957     0.200
    10.161   254.559     0.200
    18.551   461.357     0.200
    19.044   478.158     0.200
     0.977    34.828     0.200
     1.273    40.633     0.200
     1.498    47.930     0.200
     1.498    47.430     0.200
     2.074    60.133     0.200
     2.670    76.328     0.200
     3.446    93.133     0.200
     3.502    93.930     0.200
     3.396    91.531     0.200
     4.080   107.328     0.200
     4.541   118.828     0.200
     4.734   122.633     0.200
     4.734   122.531     0.200
     4.708   123.328     0.200
     4.708   123.031     0.200
     4.930   128.328     0.200
     5.316   138.031     0.200
     5.997   153.633     0.200
     6.225   158.227     0.200
     6.650   169.227     0.200
     7.057   180.031     0.200
     7.910   200.031     0.200
     7.910   200.328     0.200
     8.024   203.633     0.200
     8.024   201.828     0.200
     8.990   225.930     0.200
    10.835   267.945     0.200
    10.835   271.727     0.200
    19.800   495.930     0.200
    20.718   516.930     0.200
     1.464    46.371     0.200
     3.365    92.071     0.200
     4.172   112.871     0.200
     4.252   112.972     0.200
     4.522   119.671     0.200
     4.522   119.871     0.200
     4.944   129.571     0.200
     4.944   129.871     0.200
     6.892   175.271     0.200
     8.086   206.171     0.200
     8.162   208.472     0.200
     8.162   208.271     0.200
     8.280   211.571     0.200
     8.280   213.071     0.200
     1.624    50.836     0.200
     2.051    59.434     0.200
     2.560    70.734     0.200
     3.174    86.535     0.200
     3.767    99.035     0.200
     3.639    97.633     0.200
     3.639    96.434     0.200
     3.773   100.734     0.200
     3.773   104.234     0.200
     3.995   104.734     0.200
     4.316   114.633     0.200
     4.320   114.535     0.200
     5.440   141.836     0.200
     6.118   157.434     0.200
     6.724   171.836     0.200
     7.419   188.934     0.200
     7.893   203.535     0.200
     8.776   225.133     0.200
     9.258   235.035     0.200
    10.205   253.652     0.200
    10.205   256.035     0.200
    15.412   376.633     0.200
    15.412   380.336     0.200
    20.892   520.633     0.200
    21.252   524.836     0.200
     2.807    81.391     0.200
     2.891    78.688     0.200
     3.081    86.488     0.200
     3.815   103.289     0.200
     3.994   110.188     0.200
     4.051   109.891     0.200
     4.051   110.289     0.200
     4.470   117.988     0.200
     4.504   120.289     0.200
     5.115   135.090     0.200
     4.970   130.988     0.200
     5.281   138.391     0.200
     5.281   139.988     0.200
     5.304   140.391     0.200
     5.336   139.688     0.200
     5.559   146.289     0.200
     5.992   155.289     0.200
     5.976   156.582     0.200
     6.083   158.391     0.200
     6.369   165.488     0.200
     7.789   199.688     0.200
     8.130   207.238     0.200
     8.248   209.188     0.200
     8.359   213.289     0.200
    11.500   290.508     0.200
    11.500   288.090     0.200
    19.934   497.488     0.200
     1.641    51.272     0.200
     1.641    49.872     0.200
     1.730    52.072     0.200
     2.070    60.872     0.200
     2.582    73.372     0.200
     4.488   118.372     0.200
     5.622   144.972     0.200
     5.622   148.072     0.200
     6.486   166.372     0.200
     6.486   168.672     0.200
     7.648   193.572     0.200
     9.973   252.272     0.200
    16.821   404.216     0.200
    21.574   535.372     0.200
     1.389    47.469     0.200
     1.282    45.273     0.200
     1.968    60.367     0.200
     1.968    60.469     0.200
     2.220    67.773     0.200
     3.763   103.273     0.200
     3.800   103.469     0.200
     3.865   105.773     0.200
     3.865   104.969     0.200
     3.992   108.867     0.200
     3.992   108.469     0.200
     5.211   137.570     0.200
     5.211   136.273     0.200
     5.287   138.867     0.200
     6.420   166.070     0.200
     6.499   167.969     0.200
     7.388   192.648     0.200
     7.641   196.469     0.200
     7.636   195.867     0.200
     8.678   220.672     0.200
    10.377   262.867     0.200
    12.936   320.664     0.200
    16.609   409.969     0.200
    17.832   446.570     0.200
     1.642    52.572     0.200
     1.959    59.871     0.200
     3.788   102.672     0.200
     4.027   107.871     0.200
     4.027   109.971     0.200
     4.428   118.971     0.200
     5.192   137.271     0.200
     5.192   137.572     0.200
     5.276   139.871     0.200
     6.231   163.072     0.200
     6.720   173.172     0.200
     7.162   184.971     0.200
     7.417   192.443     0.200
     9.159   234.316     0.200
    10.130   258.572     0.200
    10.390   259.541     0.200
    10.390   263.971     0.200
    12.971   320.473     0.200
    18.198   453.072     0.200
    20.459   511.574     0.200
    20.857   523.771     0.200
     1.635    50.599     0.200
     1.635    50.798     0.200
     1.796    53.698     0.200
     1.589    50.298     0.200
     8.304   213.599     0.200
     8.422   212.398     0.200
    10.463   260.092     0.200
    10.463   264.099     0.200
    10.538   267.698     0.200
    16.977   409.616     0.200
    20.973   519.798     0.200
     1.216    42.992     0.200
     1.441    47.992     0.200
     1.615    51.393     0.200
     1.615    51.593     0.200
     1.964    60.192     0.200
     2.156    64.593     0.200
     2.966    83.492     0.200
     3.806   104.293     0.200
     3.761   101.593     0.200
     4.058   108.992     0.200
     4.028   107.893     0.200
     5.165   137.492     0.200
     7.436   192.192     0.200
     7.688   194.992     0.200
     8.455   214.293     0.200
    20.346   511.192     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.141    63.789     0.200
     0.478    15.404     0.200
     0.325    12.211     0.200
     1.302    40.609     0.200
     1.296    40.609     0.200
     3.068    90.109     0.200
     6.645   191.312     0.200
     1.218    39.570     0.200
     1.512    47.070     0.200
     2.205    69.371     0.200
     2.450    74.672     0.200
     2.679    84.473     0.200
     3.135    91.973     0.200
     4.132   125.672     0.200
     3.949   118.315     0.200
     2.477    74.840     0.200
     0.552    17.984     0.200
     0.545    17.781     0.200
     0.545    17.578     0.200
     0.783    24.883     0.200
     0.981    30.883     0.200
     0.989    30.680     0.200
     1.005    32.484     0.200
     1.017    31.883     0.200
     1.017    33.781     0.200
     1.297    40.984     0.200
     1.419    44.781     0.200
     1.419    44.180     0.200
     2.246    68.781     0.200
     2.285    72.281     0.200
     6.501   193.232     0.200
     1.926    59.898     0.200
     6.965   205.898     0.200
     0.202     9.297     0.200
     0.397    14.297     0.200
     0.541    17.898     0.200
     0.465    16.500     0.200
     0.592    19.500     0.200
     0.737    24.000     0.200
     0.743    24.615     0.200
     0.750    24.615     0.200
     2.298    71.916     0.200
     0.192     8.353     0.200
     0.558    19.252     0.200
     1.113    35.152     0.200
     0.127     3.922     0.200
     0.374    11.523     0.200
     0.899    28.422     0.200
     1.150    37.320     0.200
     1.150    36.922     0.200
     1.206    38.422     0.200
     2.165    67.117     0.200
     2.216    70.617     0.200
     2.218    69.820     0.200
     2.591    81.320     0.200
     0.026     4.219     0.200
     0.389    13.117     0.200
     0.910    29.617     0.200
     1.227    39.516     0.200
     1.288    40.914     0.200
     1.294    41.820     0.200
     1.294    40.617     0.200
     2.104    63.414     0.200
     0.150     7.082     0.200
     0.625    20.480     0.200
     1.177    37.480     0.200
     1.490    45.781     0.200
     1.724    52.980     0.200
     1.952    60.480     0.200
     2.432    74.879     0.200
     2.432    75.480     0.200
     0.167     8.461     0.200
     0.654    21.160     0.200
     0.862    27.160     0.200
     1.179    36.660     0.200
     1.719    53.160     0.200
     0.221     9.632     0.200
     0.163     7.231     0.200
     1.168    37.731     0.200
     1.135    36.632     0.200
     2.261    67.831     0.200
     0.222     9.318     0.200
     0.222     9.018     0.200
     0.416    15.318     0.200
     1.368    42.018     0.200
     1.368    42.617     0.200
     1.025    33.318     0.200
     1.025    33.117     0.200
     1.946    58.918     0.200
     0.115     5.240     0.200
     0.162     5.340     0.200
     0.558    18.441     0.200
     1.256    39.941     0.200
     1.355    43.041     0.200
     1.820    55.941     0.200
     1.820    56.441     0.200
     2.199    69.240     0.200
     0.175     7.188     0.200
     0.175     7.387     0.200
     0.483    16.789     0.200
     1.100    34.988     0.200
     1.100    35.387     0.200
     1.305    40.789     0.200
     1.305    40.988     0.200
     1.518    47.887     0.200
     2.206    66.789     0.200
     2.226    69.789     0.200
     0.046     3.700     0.200
     0.422    14.601     0.200
     0.422    14.801     0.200
     0.960    31.700     0.200
     0.982    31.700     0.200
     1.216    39.101     0.200
     1.216    38.900     0.200
     1.324    42.101     0.200
     1.324    42.501     0.200
     2.072    62.801     0.200
     2.201    68.601     0.200
     0.172     7.699     0.200
     0.216     8.098     0.200
     1.073    34.297     0.200
     1.073    33.398     0.200
     1.201    39.699     0.200
     1.217    38.898     0.200
     1.369    43.699     0.200
     1.369    42.398     0.200
     0.144     6.180     0.200
     0.261     9.777     0.200
     1.024    32.879     0.200
     1.147    36.680     0.200
     1.267    40.777     0.200
     1.415    44.480     0.200
     2.334    70.777     0.200
     2.334    71.277     0.200
     2.499    75.277     0.200
     0.178     7.195     0.200
     0.178     6.992     0.200
     0.236     8.695     0.200
     1.044    32.992     0.200
     1.044    33.391     0.200
     1.180    37.695     0.200
     1.414    44.391     0.200
     2.301    68.391     0.200
     2.301    68.992     0.200
     0.176     7.762     0.200
     0.224     9.262     0.200
     1.059    34.164     0.200
     1.170    37.262     0.200
     1.170    37.562     0.200
     1.217    39.965     0.200
     1.234    39.664     0.200
     1.393    43.965     0.200
     0.170     6.855     0.200
     0.170     6.654     0.200
     0.251     8.955     0.200
     0.251     8.754     0.200
     1.029    32.955     0.200
     1.175    38.455     0.200
     1.266    40.355     0.200
     1.426    45.855     0.200
     1.426    45.455     0.200
     2.313    70.555     0.200
     2.494    77.555     0.200
     2.494    77.955     0.200
     2.509    78.654     0.200
     2.509    79.154     0.200
     0.176     8.012     0.200
     0.215     8.912     0.200
     0.215     8.611     0.200
     1.071    34.412     0.200
     1.071    34.012     0.200
     1.160    37.412     0.200
     1.219    39.811     0.200
     1.374    43.311     0.200
     0.166     7.133     0.200
     0.248     9.227     0.200
     0.248     9.031     0.200
     1.033    33.430     0.200
     1.033    33.727     0.200
     1.170    36.633     0.200
     1.170    36.133     0.200
     1.261    40.031     0.200
     1.420    43.828     0.200
     1.420    44.430     0.200
     0.223     8.992     0.200
     0.223     8.891     0.200
     0.174     7.188     0.200
     1.061    33.992     0.200
     1.166    37.289     0.200
     1.166    37.688     0.200
     1.389    42.992     0.200
     1.389    44.094     0.200
     0.160     6.445     0.200
     0.160     6.246     0.200
     0.274     9.645     0.200
     1.171    38.047     0.200
     1.171    37.945     0.200
     1.290    41.848     0.200
     1.290    41.645     0.200
     1.447    45.746     0.200
     1.447    45.945     0.200
     2.330    70.945     0.200
     2.499    78.848     0.200
     2.499    78.445     0.200
     2.518    79.246     0.200
     0.175     7.070     0.200
     0.175     7.172     0.200
     0.212     7.875     0.200
     0.212     8.375     0.200
     1.152    36.875     0.200
     1.152    36.273     0.200
     1.361    43.273     0.200
     1.361    43.375     0.200
     2.300    69.773     0.200
     0.160     7.574     0.200
     1.292    40.676     0.200
     1.292    40.477     0.200
     1.436    45.273     0.200
     2.305    70.273     0.200
     2.305    70.676     0.200
     0.409    14.651     0.200
     0.409    14.752     0.200
     0.221     8.151     0.200
     0.221     8.752     0.200
     1.141    36.552     0.200
     1.141    36.052     0.200
     1.628    50.651     0.200
     2.126    65.052     0.200
     2.299    71.651     0.200
     4.056   122.852     0.200
     0.171     7.344     0.200
     0.171     7.039     0.200
     0.561    18.344     0.200
     1.184    37.445     0.200
     1.184    37.945     0.200
     1.485    46.039     0.200
     1.790    54.539     0.200
     1.913    59.945     0.200
     1.913    59.445     0.200
     2.428    75.641     0.200
     0.166     6.871     0.200
     0.229     9.172     0.200
     1.157    37.473     0.200
     1.157    37.070     0.200
     1.387    44.473     0.200
     2.309    70.371     0.200
     0.140     5.324     0.200
     1.380    43.922     0.200
     1.539    47.922     0.200
     1.539    47.723     0.200
     1.571    49.625     0.200
     1.571    49.223     0.200
     1.569    49.422     0.200
     2.428    74.922     0.200
     2.459    75.324     0.200
     0.040     4.406     0.200
     0.373    12.109     0.200
     1.062    34.609     0.200
     1.062    34.008     0.200
     1.312    42.906     0.200
     1.312    42.508     0.200
     1.293    41.809     0.200
     1.293    41.609     0.200
     2.105    65.008     0.200
     2.276    71.707     0.200
     0.131     5.398     0.200
     0.131     5.297     0.200
     0.314    11.695     0.200
     1.144    37.297     0.200
     1.144    36.297     0.200
     1.324    43.000     0.200
     1.469    47.000     0.200
     1.469    46.898     0.200
     2.465    77.797     0.200
     2.465    75.398     0.200
     2.555    80.000     0.200
     0.193     6.513     0.200
     0.822    26.713     0.200
     0.822    27.113     0.200
     1.055    34.213     0.200
     1.055    34.513     0.200
     1.402    44.613     0.200
     1.989    62.313     0.200
     1.989    63.313     0.200
     1.989    62.813     0.200
     2.332    72.813     0.200
     2.332    73.013     0.200
     2.656    83.613     0.200
     0.020     5.449     0.200
     0.644    21.551     0.200
     1.273    39.648     0.200
     1.273    39.852     0.200
     1.449    44.148     0.200
     1.449    44.250     0.200
     0.564    17.875     0.200
     0.774    24.973     0.200
     0.774    25.074     0.200
     0.774    24.574     0.200
     0.774    25.473     0.200
     1.795    55.172     0.200
     1.895    59.273     0.200
     2.267    70.773     0.200
     2.267    71.574     0.200
     2.226    71.074     0.200
     6.409   190.172     0.200
     0.164     8.195     0.200
     0.223     8.492     0.200
     1.173    38.094     0.200
     1.190    38.391     0.200
     2.252    68.492     0.200
     0.151     6.469     0.200
     0.241     8.367     0.200
     0.241     9.367     0.200
     1.142    36.969     0.200
     1.142    36.867     0.200
     1.241    40.773     0.200
     1.387    44.172     0.200
     1.387    44.070     0.200
     2.324    71.273     0.200
     0.086     4.012     0.200
     0.557    18.412     0.200
     1.079    34.713     0.200
     1.382    43.912     0.200
     1.790    55.512     0.200
     1.835    56.912     0.200
     2.325    73.613     0.200
     2.325    72.012     0.200
     2.706    84.713     0.200
     0.400    15.389     0.200
     1.026    32.590     0.200
     1.026    32.488     0.200
     1.669    52.889     0.200
     1.963    58.689     0.200
     1.963    58.289     0.200
     5.570   163.189     0.200
     6.538   189.789     0.200
     0.113     3.606     0.200
     0.113     3.406     0.200
     0.744    25.306     0.200
     1.024    33.206     0.200
     1.360    43.706     0.200
     1.360    44.906     0.200
     1.228    39.506     0.200
     1.228    40.006     0.200
     1.613    50.006     0.200
     1.918    59.906     0.200
     1.918    60.906     0.200
     1.918    62.106     0.200
     2.698    84.506     0.200
     2.698    85.106     0.200
     6.308   188.206     0.200
     0.484    16.609     0.200
     0.530    18.211     0.200
     0.530    17.812     0.200
     0.796    26.914     0.200
     0.796    27.109     0.200
     0.993    32.312     0.200
     0.993    32.211     0.200
     1.406    44.016     0.200
     1.406    43.914     0.200
     1.877    57.516     0.200
     1.877    59.516     0.200
     1.877    57.414     0.200
     3.881   117.312     0.200
     6.929   203.812     0.200
     0.021     6.823     0.200
     0.384    13.323     0.200
     0.384    13.823     0.200
     1.015    32.724     0.200
     1.234    39.224     0.200
     1.234    39.423     0.200
     1.288    41.224     0.200
     0.112     3.555     0.200
     0.112     3.254     0.200
     0.741    24.555     0.200
     1.045    34.055     0.200
     1.045    34.156     0.200
     1.208    39.055     0.200
     1.380    44.555     0.200
     1.931    61.055     0.200
     1.931    60.855     0.200
     2.316    74.055     0.200
     2.316    73.953     0.200
     2.679    84.656     0.200
     2.679    84.555     0.200
     0.079     6.480     0.200
     0.079     6.082     0.200
     0.552    19.383     0.200
     0.552    17.883     0.200
     1.044    33.383     0.200
     1.044    33.281     0.200
     1.346    41.781     0.200
     1.346    41.883     0.200
     1.269    39.383     0.200
     1.803    57.180     0.200
     1.803    55.082     0.200
     1.803    56.281     0.200
     2.289    68.781     0.200
     0.258     9.039     0.200
     0.581    19.340     0.200
     0.581    18.238     0.200
     1.060    35.141     0.200
     1.060    33.738     0.200
     1.577    49.441     0.200
     1.577    51.641     0.200
     1.793    55.238     0.200
     1.985    63.340     0.200
     1.985    63.441     0.200
     2.520    79.641     0.200
     2.528    79.441     0.200
     3.506   106.641     0.200
     0.110     3.641     0.200
     1.041    32.742     0.200
     1.041    34.539     0.200
     1.377    43.641     0.200
     1.377    44.438     0.200
     1.212    39.539     0.200
     1.614    50.438     0.200
     1.928    61.141     0.200
     2.312    73.141     0.200
     2.683    84.539     0.200
     2.683    84.039     0.200
     7.419   218.938     0.200
     0.242    10.223     0.200
     0.605    19.824     0.200
     0.790    25.121     0.200
     1.077    35.023     0.200
     1.077    34.621     0.200
     1.520    47.922     0.200
     1.520    47.523     0.200
     1.939    58.422     0.200
     2.004    62.223     0.200
     2.004    61.523     0.200
     0.151     7.395     0.200
     0.498    17.395     0.200
     0.498    16.895     0.200
     1.112    35.195     0.200
     1.112    35.594     0.200
     1.234    39.395     0.200
     1.234    38.895     0.200
     1.403    43.793     0.200
     1.403    43.094     0.200
     1.819    57.293     0.200
     1.819    55.594     0.200
     1.819    56.793     0.200
     1.847    56.395     0.200
     0.269    10.039     0.200
     0.772    25.344     0.200
     0.772    25.039     0.200
     0.994    32.539     0.200
     0.994    31.844     0.200
     1.515    47.844     0.200
     2.028    61.539     0.200
     2.010    61.445     0.200
     0.174     8.766     0.200
     0.174     8.168     0.200
     0.458    16.367     0.200
     0.458    16.668     0.200
     1.044    32.969     0.200
     1.044    33.168     0.200
     1.325    40.469     0.200
     1.321    41.668     0.200
     1.733    53.969     0.200
     1.733    53.766     0.200
     1.897    57.066     0.200
     1.897    56.867     0.200
     0.108     7.738     0.200
     0.469    16.039     0.200
     0.920    29.639     0.200
     2.045    61.539     0.200
     2.045    60.938     0.200
     0.190     6.308     0.200
     0.190     6.208     0.200
     0.516    17.808     0.200
     0.825    27.407     0.200
     0.960    30.907     0.200
     1.375    44.607     0.200
     1.375    44.208     0.200
     2.167    68.007     0.200
     2.616    80.808     0.200
     2.616    79.907     0.200
     2.627    82.708     0.200
     2.840    89.507     0.200
     2.950    91.907     0.200
     2.950    92.507     0.200
     0.191     6.326     0.200
     0.514    17.727     0.200
     0.825    27.826     0.200
     0.825    27.026     0.200
     0.965    30.926     0.200
     0.965    30.626     0.200
     1.371    46.326     0.200
     1.370    44.326     0.200
     2.167    68.026     0.200
     2.167    67.126     0.200
     2.615    80.526     0.200
     2.624    82.626     0.200
     2.841    90.026     0.200
     2.953    92.227     0.200
     2.953    92.626     0.200
     0.212     8.594     0.200
     0.567    18.398     0.200
     0.816    26.797     0.200
     1.081    35.094     0.200
     1.376    44.398     0.200
     1.979    60.000     0.200
     2.037    64.000     0.200
     0.223     7.692     0.200
     0.608    19.393     0.200
     1.067    34.993     0.200
     1.247    39.692     0.200
     1.554    49.393     0.200
     1.756    55.393     0.200
     1.985    62.893     0.200
     2.497    78.292     0.200
     2.538    80.692     0.200
     6.073   179.792     0.200
     6.120   181.393     0.200
     7.065   213.792     0.200
     0.210     7.582     0.200
     0.210     6.980     0.200
     0.576    18.980     0.200
     1.098    35.082     0.200
     1.228    38.980     0.200
     1.228    39.781     0.200
     1.531    47.980     0.200
     1.531    47.781     0.200
     1.952    61.980     0.200
     1.783    55.082     0.200
     2.474    77.383     0.200
     2.568    80.582     0.200
     2.568    79.883     0.200
     6.146   182.480     0.200
     8.528   250.281     0.200
     0.208     7.789     0.200
     0.585    18.992     0.200
     1.093    35.094     0.200
     1.228    38.891     0.200
     1.532    48.094     0.200
     1.774    55.188     0.200
     1.959    61.992     0.200
     2.475    76.594     0.200
     2.475    78.688     0.200
     2.563    80.789     0.200
     7.932   235.492     0.200
     8.534   253.594     0.200
     0.226     8.016     0.200
     0.226     7.719     0.200
     0.581    19.117     0.200
     0.581    19.320     0.200
     1.083    35.117     0.200
     1.083    34.914     0.200
     1.244    39.414     0.200
     1.547    48.516     0.200
     1.783    55.414     0.200
     1.966    62.117     0.200
     1.966    61.320     0.200
     2.553    81.219     0.200
     2.553    79.016     0.200
     7.942   235.617     0.200
     0.214     7.625     0.200
     0.603    19.422     0.200
     1.077    35.023     0.200
     1.238    39.922     0.200
     1.545    49.023     0.200
     1.545    48.922     0.200
     1.758    55.125     0.200
     1.758    55.422     0.200
     1.976    62.422     0.200
     1.976    61.820     0.200
     2.487    78.422     0.200
     2.487    78.023     0.200
     2.548    80.820     0.200
     2.548    80.320     0.200
     4.059   122.023     0.200
     5.528   168.023     0.200
     0.213     7.422     0.200
     0.213     7.117     0.200
     0.603    19.719     0.200
     1.078    35.016     0.200
     1.078    34.422     0.200
     1.237    39.617     0.200
     1.237    39.820     0.200
     1.543    48.320     0.200
     1.543    49.016     0.200
     1.758    55.016     0.200
     1.976    62.516     0.200
     2.486    78.422     0.200
     2.549    80.617     0.200
     2.549    80.016     0.200
     3.462   105.422     0.200
     5.527   167.117     0.200
     6.130   184.219     0.200
     0.212     7.594     0.200
     0.594    18.691     0.200
     1.085    34.895     0.200
     1.234    39.191     0.200
     1.539    48.293     0.200
     1.767    55.293     0.200
     1.967    61.793     0.200
     2.482    75.895     0.200
     2.482    78.395     0.200
     2.555    80.492     0.200
     7.941   236.191     0.200
     0.245     8.191     0.200
     0.245     8.391     0.200
     0.608    19.590     0.200
     0.608    19.891     0.200
     1.051    34.590     0.200
     1.269    40.293     0.200
     1.575    49.891     0.200
     1.575    49.992     0.200
     1.998    62.590     0.200
     2.521    79.691     0.200
     2.521    79.391     0.200
     2.517    78.590     0.200
     2.517    78.891     0.200
     6.084   179.590     0.200
     0.266     8.777     0.200
     0.266     8.078     0.200
     0.618    19.977     0.200
     1.030    33.676     0.200
     1.030    33.477     0.200
     1.597    50.977     0.200
     2.018    63.875     0.200
     2.018    63.176     0.200
     1.761    54.875     0.200
     2.540    78.676     0.200
     2.540    79.578     0.200
     2.499    79.477     0.200
     2.499    78.277     0.200
     7.099   212.777     0.200
     0.230     8.028     0.200
     0.603    19.429     0.200
     1.559    49.729     0.200
     1.763    55.929     0.200
     1.985    62.829     0.200
     2.502    78.729     0.200
     2.502    78.429     0.200
     2.536    80.329     0.200
     2.536    80.129     0.200
     6.442   191.729     0.200
     7.508   227.211     0.200
     0.105     4.352     0.200
     0.583    18.852     0.200
     1.123    35.750     0.200
     1.182    38.047     0.200
     1.430    45.352     0.200
     1.762    54.453     0.200
     1.886    59.250     0.200
     1.886    60.250     0.200
     2.373    74.352     0.200
     6.242   184.852     0.200
     0.222     7.961     0.200
     0.222     8.363     0.200
     0.587    18.961     0.200
     1.081    34.363     0.200
     1.081    34.562     0.200
     1.243    39.762     0.200
     1.243    39.863     0.200
     1.546    49.062     0.200
     1.776    54.660     0.200
     1.969    61.863     0.200
     1.969    61.363     0.200
     2.489    77.363     0.200
     2.489    78.160     0.200
     2.551    80.562     0.200
     2.551    80.062     0.200
     3.304   100.160     0.200
     4.042   121.863     0.200
     5.521   165.762     0.200
     6.130   181.262     0.200
     7.049   208.762     0.200
     0.516    17.043     0.200
     0.830    26.343     0.200
     0.796    26.144     0.200
     1.770    55.843     0.200
     1.760    55.644     0.200
     7.990   235.644     0.200
     0.222     8.027     0.200
     0.222     7.828     0.200
     0.576    19.027     0.200
     1.089    35.828     0.200
     1.089    35.430     0.200
     1.541    48.328     0.200
     1.786    55.328     0.200
     1.960    61.930     0.200
     1.960    61.730     0.200
     2.484    78.129     0.200
     2.559    81.629     0.200
     2.559    80.430     0.200
     4.031   121.230     0.200
     5.899   176.930     0.200
     0.159     6.180     0.200
     0.753    25.379     0.200
     0.753    25.277     0.200
     1.577    49.277     0.200
     1.617    50.980     0.200
     1.530    48.078     0.200
     2.469    75.879     0.200
     2.445    74.879     0.200
     2.445    74.980     0.200
     5.567   164.277     0.200
     0.119     6.498     0.200
     0.119     6.297     0.200
     0.516    17.197     0.200
     0.516    17.396     0.200
     1.074    33.098     0.200
     1.259    39.697     0.200
     1.259    40.197     0.200
     1.369    41.998     0.200
     1.802    56.396     0.200
     1.802    55.697     0.200
     1.802    56.797     0.200
     2.312    72.297     0.200
     5.352   160.396     0.200
     6.310   185.697     0.200
     0.269    10.277     0.200
     0.269     9.875     0.200
     0.986    32.277     0.200
     0.986    32.074     0.200
     0.768    25.176     0.200
     0.768    26.176     0.200
     1.598    48.574     0.200
     1.605    49.375     0.200
     2.104    65.277     0.200
     2.104    65.676     0.200
     7.176   214.676     0.200
     0.220     7.750     0.200
     0.220     7.648     0.200
     0.573    18.852     0.200
     1.093    36.055     0.200
     1.093    35.555     0.200
     1.538    50.250     0.200
     1.956    62.250     0.200
     1.956    62.352     0.200
     2.481    77.555     0.200
     2.562    81.453     0.200
     0.227     8.413     0.200
     0.756    25.013     0.200
     1.030    32.613     0.200
     1.229    38.013     0.200
     1.599    48.713     0.200
     2.068    65.113     0.200
     6.011   181.913     0.200
     6.106   179.813     0.200
     7.577   223.113     0.200
     0.212     7.742     0.200
     0.565    18.641     0.200
     1.105    35.641     0.200
     1.527    48.438     0.200
     1.794    55.844     0.200
     1.943    61.742     0.200
     2.470    77.938     0.200
     2.575    81.141     0.200
     5.797   171.438     0.200
     6.151   183.539     0.200
     0.458    14.875     0.200
     0.614    20.375     0.200
     0.688    23.176     0.200
     1.148    36.977     0.200
     1.148    37.078     0.200
     1.219    39.176     0.200
     1.343    44.277     0.200
     1.343    44.578     0.200
     2.002    62.777     0.200
     2.585    80.277     0.200
     2.744    84.578     0.200
     2.744    84.176     0.200
     2.907    90.176     0.200
     2.907    91.875     0.200
     0.224     8.102     0.200
     0.224     7.602     0.200
     0.576    19.202     0.200
     1.088    36.202     0.200
     1.241    39.502     0.200
     1.543    48.802     0.200
     1.787    55.702     0.200
     1.787    56.602     0.200
     1.961    61.902     0.200
     2.486    78.202     0.200
     2.557    81.502     0.200
     2.557    81.302     0.200
     0.223     7.680     0.200
     0.617    20.180     0.200
     0.617    19.586     0.200
     1.062    34.781     0.200
     1.062    34.883     0.200
     1.248    39.484     0.200
     1.248    40.383     0.200
     1.557    49.180     0.200
     1.747    54.383     0.200
     1.747    55.086     0.200
     1.992    62.383     0.200
     1.992    64.180     0.200
     2.533    79.781     0.200
     2.533    80.086     0.200
     2.500    76.586     0.200
     0.111     3.656     0.200
     0.111     4.754     0.200
     1.112    36.355     0.200
     1.205    38.254     0.200
     1.414    44.855     0.200
     1.414    45.453     0.200
     1.791    54.953     0.200
     1.858    58.656     0.200
     1.858    57.855     0.200
     2.357    73.855     0.200
     2.357    73.555     0.200
     2.677    84.156     0.200
     0.099     3.996     0.200
     0.099     3.895     0.200
     0.575    18.297     0.200
     1.196    38.094     0.200
     1.417    44.395     0.200
     1.417    44.695     0.200
     1.771    54.695     0.200
     1.872    59.094     0.200
     2.360    73.895     0.200
     2.669    83.297     0.200
     2.669    82.594     0.200
     0.109     3.996     0.200
     0.109     4.898     0.200
     0.576    18.996     0.200
     0.576    19.098     0.200
     1.124    35.699     0.200
     1.124    36.598     0.200
     1.184    38.598     0.200
     1.430    45.898     0.200
     1.770    55.098     0.200
     1.882    58.199     0.200
     2.373    74.199     0.200
     2.657    83.699     0.200
     2.657    83.398     0.200
     3.230   100.699     0.200
     6.337   190.098     0.200
     0.107     4.633     0.200
     0.107     3.836     0.200
     0.589    18.934     0.200
     0.589    18.734     0.200
     1.127    35.633     0.200
     1.127    37.234     0.200
     1.176    38.234     0.200
     1.176    37.535     0.200
     1.435    46.133     0.200
     1.756    54.633     0.200
     1.893    59.734     0.200
     2.378    73.934     0.200
     2.378    75.234     0.200
     2.649    83.836     0.200
     0.118     4.062     0.200
     0.118     4.762     0.200
     0.575    18.961     0.200
     1.133    38.363     0.200
     1.176    38.062     0.200
     1.439    45.762     0.200
     1.439    45.562     0.200
     1.888    59.461     0.200
     1.888    59.262     0.200
     1.770    55.262     0.200
     2.382    74.562     0.200
     2.649    84.062     0.200
     0.120     4.848     0.200
     0.120     4.547     0.200
     0.591    18.945     0.200
     0.591    19.848     0.200
     1.163    37.145     0.200
     1.141    36.445     0.200
     1.141    36.547     0.200
     1.449    45.645     0.200
     1.755    54.547     0.200
     1.904    59.547     0.200
     2.392    75.047     0.200
     2.636    82.547     0.200
     2.636    82.746     0.200
     0.110     4.020     0.200
     1.134    36.320     0.200
     1.164    38.121     0.200
     1.444    46.219     0.200
     1.444    45.621     0.200
     1.744    54.320     0.200
     1.906    59.520     0.200
     1.906    60.719     0.200
     2.387    74.621     0.200
     2.637    82.820     0.200
     2.637    82.121     0.200
     0.106     4.738     0.200
     0.567    18.438     0.200
     1.116    35.637     0.200
     1.195    38.438     0.200
     1.195    38.539     0.200
     1.421    44.738     0.200
     1.778    54.738     0.200
     1.870    57.938     0.200
     2.364    73.836     0.200
     2.667    83.738     0.200
     2.667    84.137     0.200
     0.110     4.125     0.200
     0.561    18.625     0.200
     1.198    40.125     0.200
     1.866    58.027     0.200
     2.363    73.625     0.200
     2.363    74.625     0.200
     2.670    84.125     0.200
     0.104     4.555     0.200
     0.590    18.754     0.200
     1.178    37.652     0.200
     1.433    44.754     0.200
     1.756    54.254     0.200
     1.891    59.254     0.200
     2.376    73.254     0.200
     2.651    82.953     0.200
     0.048     2.758     0.200
     0.609    18.758     0.200
     0.609    19.459     0.200
     1.072    35.158     0.200
     1.218    38.658     0.200
     1.385    44.357     0.200
     1.385    44.158     0.200
     1.739    54.857     0.200
     1.865    58.059     0.200
     2.327    73.857     0.200
     2.327    73.959     0.200
     3.223   100.357     0.200
     3.223   100.658     0.200
     4.489   135.658     0.200
     0.277    10.531     0.200
     0.277    10.031     0.200
     0.557    18.633     0.200
     0.788    25.633     0.200
     0.788    25.430     0.200
     0.977    30.633     0.200
     2.032    62.531     0.200
     2.032    63.328     0.200
     4.708   142.133     0.200
     0.496    17.571     0.200
     0.496    16.671     0.200
     0.536    17.571     0.200
     0.536    18.171     0.200
     0.814    26.671     0.200
     0.814    27.371     0.200
     0.831    26.371     0.200
     1.752    55.171     0.200
     1.775    55.571     0.200
     1.900    57.571     0.200
     0.449    15.133     0.200
     0.381    13.234     0.200
     1.162    36.934     0.200
     1.162    37.234     0.200
     1.369    43.336     0.200
     1.624    49.734     0.200
     2.051    62.133     0.200
     0.186     6.188     0.200
     0.186     6.289     0.200
     0.566    17.391     0.200
     0.851    27.391     0.200
     0.851    27.391     0.200
     1.482    47.090     0.200
     2.157    67.391     0.200
     2.157    67.188     0.200
     2.658    81.188     0.200
     2.719    83.891     0.200
     2.719    83.488     0.200
     2.807    88.688     0.200
     2.891    89.789     0.200
     2.891    89.289     0.200
     0.303    10.272     0.200
     0.663    22.472     0.200
     0.979    31.472     0.200
     0.979    31.272     0.200
     1.331    41.772     0.200
     1.331    41.572     0.200
     2.070    64.672     0.200
     2.070    63.172     0.200
     0.245     8.672     0.200
     0.245     9.773     0.200
     0.399    13.867     0.200
     1.389    44.273     0.200
     1.658    52.273     0.200
     2.220    69.172     0.200
     2.856    89.570     0.200
     2.856    89.969     0.200
     3.000    93.969     0.200
     6.420   190.867     0.200
     0.239     9.672     0.200
     0.239     8.971     0.200
     0.984    31.771     0.200
     1.250    42.371     0.200
     1.411    44.771     0.200
     2.189    67.271     0.200
     2.879    89.871     0.200
     0.406    14.599     0.200
     0.406    14.498     0.200
     0.794    25.798     0.200
     0.954    31.298     0.200
     1.796    55.998     0.200
     1.796    55.298     0.200
     1.889    59.298     0.200
     0.252     9.793     0.200
     0.252     9.593     0.200
     0.432    13.492     0.200
     0.952    31.293     0.200
     0.952    30.793     0.200
     1.216    38.893     0.200
     1.441    45.093     0.200
     1.964    60.692     0.200
     2.156    68.593     0.200
     2.156    67.393     0.200
     7.688   226.093     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.438    74.332     0.200
     3.643   114.504     0.200
     2.229    67.711     0.200
     2.372    73.312     0.200
     2.275    70.516     0.200
     2.758    87.109     0.200
     3.068    98.109     0.200
     4.190   131.211     0.200
     4.190   131.414     0.200
     4.297   132.914     0.200
     5.429   169.414     0.200
     5.820   182.609     0.200
     6.645   207.516     0.200
     8.473   262.711     0.200
     2.307    69.672     0.200
     3.135   101.270     0.200
     4.321   134.473     0.200
     5.503   168.473     0.200
     5.890   184.070     0.200
     6.794   211.871     0.200
     6.794   208.070     0.200
     7.879   242.973     0.200
     8.546   264.172     0.200
     8.736   269.871     0.200
     8.736   269.371     0.200
     8.852   275.570     0.200
     3.509   108.815     0.200
     4.335   132.815     0.200
     5.253   162.115     0.200
     5.632   176.815     0.200
     6.359   194.815     0.200
     7.232   221.815     0.200
     7.232   221.715     0.200
     2.165    65.141     0.200
     3.738   115.242     0.200
     4.224   132.039     0.200
     6.208   193.641     0.200
     2.467    74.781     0.200
     3.036    94.578     0.200
     3.713   116.281     0.200
     3.707   114.984     0.200
     3.707   115.781     0.200
     4.392   134.781     0.200
     4.713   148.281     0.200
     4.713   147.781     0.200
     4.781   146.281     0.200
     4.781   149.281     0.200
     5.690   176.781     0.200
     6.351   194.281     0.200
     6.788   207.578     0.200
     7.433   229.281     0.200
     7.433   230.984     0.200
    21.051   652.232     0.200
     3.322   102.898     0.200
     3.666   113.898     0.200
     5.621   174.797     0.200
     6.965   217.898     0.200
     3.181    99.695     0.200
     4.166   130.695     0.200
     4.497   140.898     0.200
     6.300   193.898     0.200
     7.379   227.398     0.200
     8.068   249.898     0.200
     2.870    87.916     0.200
     2.870    90.115     0.200
     3.470   109.115     0.200
     3.595   112.516     0.200
     4.099   128.615     0.200
     4.726   145.615     0.200
     5.852   183.115     0.200
     6.174   193.115     0.200
     7.178   223.615     0.200
     8.861   276.516     0.200
     9.170   285.615     0.200
     9.345   288.916     0.200
     9.438   296.615     0.200
     2.054    62.053     0.200
     3.516   108.053     0.200
     4.244   130.252     0.200
     4.769   147.053     0.200
     4.836   150.152     0.200
     4.836   150.353     0.200
     5.207   161.152     0.200
     6.026   185.652     0.200
     6.026   186.053     0.200
     6.476   201.452     0.200
     6.698   205.353     0.200
     7.089   220.053     0.200
     3.413   105.922     0.200
     3.684   115.117     0.200
     4.134   129.820     0.200
     4.134   130.023     0.200
     4.571   141.820     0.200
     4.571   141.617     0.200
     4.831   149.219     0.200
     4.922   154.023     0.200
     5.831   179.617     0.200
     6.335   198.023     0.200
     6.503   199.719     0.200
     6.898   214.219     0.200
     7.625   236.422     0.200
     7.746   240.320     0.200
     2.104    63.617     0.200
     2.230    70.516     0.200
     2.231    68.617     0.200
     2.665    81.820     0.200
     3.453   106.719     0.200
     3.692   114.719     0.200
     3.692   114.617     0.200
     4.237   132.617     0.200
     4.237   131.820     0.200
     4.613   142.016     0.200
     4.613   143.219     0.200
     4.983   155.320     0.200
     5.062   156.617     0.200
     5.863   179.820     0.200
     5.898   181.117     0.200
     6.434   199.016     0.200
     6.434   200.914     0.200
     6.536   201.016     0.200
     7.668   237.617     0.200
     7.764   240.617     0.200
     7.850   243.617     0.200
     3.299   102.680     0.200
     3.888   121.879     0.200
     3.888   121.680     0.200
     4.093   126.582     0.200
     4.093   128.980     0.200
     4.361   134.082     0.200
     5.500   171.582     0.200
     5.587   173.480     0.200
     6.470   201.680     0.200
     6.811   211.281     0.200
     7.468   228.082     0.200
     8.528   265.180     0.200
     2.120    65.262     0.200
     2.887    89.160     0.200
     3.095    94.961     0.200
     4.100   125.961     0.200
     4.099   127.262     0.200
     4.183   129.461     0.200
     5.101   159.359     0.200
     5.103   159.359     0.200
     5.247   163.461     0.200
     5.381   167.762     0.200
     5.835   181.762     0.200
     6.438   202.160     0.200
     6.537   200.762     0.200
     6.545   203.160     0.200
     7.206   221.262     0.200
     7.637   236.660     0.200
     8.286   258.359     0.200
     8.500   263.762     0.200
     8.635   266.559     0.200
     2.527    78.231     0.200
     3.199    99.531     0.200
     3.288   101.531     0.200
     3.853   119.531     0.200
     4.189   128.231     0.200
     4.189   130.331     0.200
     4.433   136.831     0.200
     4.434   136.831     0.200
     4.448   137.932     0.200
     4.448   136.932     0.200
     4.744   146.731     0.200
     5.094   157.731     0.200
     5.164   160.831     0.200
     5.481   167.831     0.200
     5.695   175.731     0.200
     5.733   176.231     0.200
     6.354   197.331     0.200
     6.369   196.031     0.200
     6.369   195.432     0.200
     6.752   209.031     0.200
     7.503   231.432     0.200
     7.595   233.731     0.200
     2.236    69.117     0.200
     2.835    88.918     0.200
     2.835    87.617     0.200
     3.024    94.617     0.200
     3.985   124.117     0.200
     3.985   122.918     0.200
     3.884   121.717     0.200
     3.884   121.018     0.200
     4.098   125.518     0.200
     4.098   126.018     0.200
     5.042   154.918     0.200
     5.044   154.918     0.200
     5.233   161.617     0.200
     5.774   179.518     0.200
     6.242   192.818     0.200
     7.204   221.217     0.200
     7.650   236.094     0.200
     8.258   256.717     0.200
     8.529   262.617     0.200
     8.697   268.217     0.200
     2.828    88.641     0.200
     3.094    96.740     0.200
     3.094    96.441     0.200
     3.882   119.740     0.200
     4.021   125.641     0.200
     4.021   125.340     0.200
     4.074   127.340     0.200
     4.074   126.441     0.200
     4.131   127.541     0.200
     5.273   161.541     0.200
     6.371   198.840     0.200
     6.563   203.340     0.200
     7.238   222.141     0.200
     7.679   235.641     0.200
     8.695   269.041     0.200
     2.206    66.586     0.200
     2.828    86.887     0.200
     2.828    87.887     0.200
     2.962    91.887     0.200
     3.625   111.988     0.200
     3.625   112.488     0.200
     3.641   111.789     0.200
     3.926   121.789     0.200
     3.926   121.988     0.200
     3.954   121.688     0.200
     3.954   122.188     0.200
     4.852   150.988     0.200
     5.077   156.086     0.200
     5.355   166.488     0.200
     5.401   167.586     0.200
     5.580   174.086     0.200
     6.361   196.789     0.200
     6.405   197.688     0.200
     8.606   266.188     0.200
     2.694    84.101     0.200
     3.486   107.801     0.200
     3.662   114.400     0.200
     3.662   113.700     0.200
     4.250   134.501     0.200
     4.250   131.501     0.200
     4.618   142.501     0.200
     4.646   144.001     0.200
     4.964   155.200     0.200
     4.964   153.501     0.200
     5.058   155.700     0.200
     5.350   165.101     0.200
     5.931   183.400     0.200
     2.449    76.098     0.200
     2.501    77.797     0.200
     2.501    77.898     0.200
     3.241    99.699     0.200
     3.241    99.598     0.200
     3.914   121.496     0.200
     4.203   130.797     0.200
     4.203   130.598     0.200
     4.271   132.898     0.200
     4.401   135.496     0.200
     4.401   135.297     0.200
     4.396   135.797     0.200
     4.826   148.398     0.200
     4.860   150.598     0.200
     4.862   149.297     0.200
     5.154   161.098     0.200
     5.154   159.898     0.200
     5.643   174.199     0.200
     5.643   173.098     0.200
     5.684   174.996     0.200
     6.317   193.098     0.200
     6.317   194.199     0.200
     6.355   196.398     0.200
     6.698   206.297     0.200
     7.456   227.797     0.200
     7.456   228.797     0.200
     2.483    77.480     0.200
     2.483    77.879     0.200
     2.499    77.680     0.200
     3.205    98.277     0.200
     3.205    99.277     0.200
     3.963   123.480     0.200
     4.218   132.277     0.200
     4.218   130.680     0.200
     4.239   131.980     0.200
     4.365   134.379     0.200
     4.365   133.578     0.200
     4.368   135.680     0.200
     4.795   146.980     0.200
     5.202   161.180     0.200
     5.202   160.980     0.200
     5.603   173.480     0.200
     5.647   173.180     0.200
     6.278   192.480     0.200
     6.358   196.980     0.200
     6.358   198.180     0.200
     6.655   205.277     0.200
     7.420   229.777     0.200
     7.487   232.180     0.200
     9.615   296.680     0.200
     2.479    76.492     0.200
     2.517    78.297     0.200
     2.517    78.492     0.200
     3.237   100.391     0.200
     3.941   122.391     0.200
     3.941   122.594     0.200
     4.243   130.891     0.200
     4.243   131.797     0.200
     4.272   131.797     0.200
     4.397   135.195     0.200
     4.397   135.297     0.200
     4.402   136.492     0.200
     4.829   147.891     0.200
     5.196   161.094     0.200
     5.196   160.992     0.200
     5.679   173.891     0.200
     6.309   195.094     0.200
     6.388   197.797     0.200
     6.684   207.594     0.200
     7.452   231.695     0.200
     7.468   229.992     0.200
     7.523   231.797     0.200
     9.637   296.195     0.200
     2.299    69.363     0.200
     2.464    76.562     0.200
     2.512    78.562     0.200
     3.241    99.762     0.200
     3.241   100.062     0.200
     3.927   122.262     0.200
     3.927   122.363     0.200
     4.226   129.262     0.200
     4.226   131.363     0.200
     4.274   133.863     0.200
     4.401   136.262     0.200
     4.401   136.363     0.200
     4.401   136.965     0.200
     4.829   149.762     0.200
     5.131   159.363     0.200
     5.176   161.562     0.200
     6.315   192.465     0.200
     6.315   194.062     0.200
     6.375   196.762     0.200
     6.375   196.965     0.200
     6.692   206.664     0.200
     7.456   231.965     0.200
     9.651   296.664     0.200
     3.224    99.055     0.200
     3.224   100.055     0.200
     3.957   123.654     0.200
     4.261   132.955     0.200
     4.245   130.654     0.200
     4.245   131.855     0.200
     4.384   136.055     0.200
     4.817   148.855     0.200
     5.120   158.855     0.200
     5.210   162.154     0.200
     5.666   176.355     0.200
     6.296   194.754     0.200
     6.386   196.855     0.200
     6.386   197.355     0.200
     6.670   206.455     0.200
     7.587   234.754     0.200
     9.622   297.154     0.200
     2.299    69.611     0.200
     2.451    75.111     0.200
     2.451    75.412     0.200
     2.506    78.412     0.200
     2.506    77.211     0.200
     3.243    98.512     0.200
     3.243    99.211     0.200
     3.915   122.412     0.200
     3.915   120.611     0.200
     4.211   130.811     0.200
     4.211   130.412     0.200
     4.274   131.512     0.200
     4.403   134.611     0.200
     4.400   134.611     0.200
     4.830   149.611     0.200
     5.130   157.912     0.200
     5.158   159.512     0.200
     5.158   159.912     0.200
     5.687   173.912     0.200
     6.319   194.311     0.200
     6.319   193.711     0.200
     6.699   206.311     0.200
     2.314    70.430     0.200
     2.506    77.227     0.200
     2.506    77.930     0.200
     3.158    98.727     0.200
     3.224    99.133     0.200
     3.953   123.328     0.200
     3.953   122.828     0.200
     4.238   132.430     0.200
     4.238   131.031     0.200
     4.259   133.430     0.200
     4.389   135.227     0.200
     4.384   134.430     0.200
     4.384   133.828     0.200
     4.815   149.430     0.200
     5.118   159.133     0.200
     5.204   161.031     0.200
     5.621   174.328     0.200
     5.621   174.031     0.200
     5.666   175.633     0.200
     6.296   192.531     0.200
     6.380   200.031     0.200
     6.380   197.633     0.200
     6.671   207.227     0.200
     7.439   231.227     0.200
     7.439   227.727     0.200
     7.589   235.227     0.200
     8.497   261.625     0.200
    16.351   513.805     0.200
    20.191   636.672     0.200
     2.301    70.188     0.200
     2.462    76.594     0.200
     2.462    75.992     0.200
     2.509    77.891     0.200
     2.509    78.188     0.200
     3.239    99.289     0.200
     3.926   120.992     0.200
     3.926   123.891     0.200
     4.221   131.492     0.200
     4.272   133.789     0.200
     4.400   134.992     0.200
     4.400   134.094     0.200
     4.399   136.188     0.200
     4.828   149.789     0.200
     4.862   149.992     0.200
     4.862   150.094     0.200
     5.172   159.492     0.200
     5.172   159.688     0.200
     5.129   159.094     0.200
     5.640   174.391     0.200
     5.682   175.094     0.200
     6.314   194.391     0.200
     6.370   199.188     0.200
     6.692   206.688     0.200
     7.455   231.094     0.200
     7.455   229.289     0.200
     7.533   233.594     0.200
     7.615   235.094     0.200
     8.471   264.023     0.200
    20.219   639.070     0.200
     3.206    99.145     0.200
     3.206    98.348     0.200
     3.980   122.945     0.200
     3.980   125.348     0.200
     4.250   131.348     0.200
     4.366   134.848     0.200
     4.366   134.445     0.200
     4.377   135.547     0.200
     4.801   147.547     0.200
     5.105   157.645     0.200
     5.232   162.445     0.200
     5.232   161.348     0.200
     5.600   174.246     0.200
     5.647   174.348     0.200
     6.276   191.848     0.200
     6.386   197.547     0.200
     6.386   198.746     0.200
     6.649   206.547     0.200
     6.649   206.246     0.200
     7.421   230.246     0.200
     7.421   227.645     0.200
     7.487   231.645     0.200
     7.564   234.246     0.200
     8.517   267.145     0.200
    15.301   484.473     0.200
     2.443    75.875     0.200
     2.500    78.070     0.200
     2.500    76.875     0.200
     3.164    99.273     0.200
     3.243    99.570     0.200
     3.908   119.875     0.200
     3.908   121.773     0.200
     4.198   131.172     0.200
     4.198   129.273     0.200
     4.273   133.070     0.200
     4.404   135.070     0.200
     4.397   135.875     0.200
     4.828   148.977     0.200
     5.146   159.273     0.200
     5.146   159.375     0.200
     5.687   174.977     0.200
     6.321   193.977     0.200
     6.321   193.273     0.200
     6.351   196.570     0.200
     6.702   207.773     0.200
     7.459   230.672     0.200
     7.544   234.070     0.200
     7.597   235.875     0.200
     9.670   298.672     0.200
     2.499    75.676     0.200
     2.659    81.977     0.200
     2.659    81.773     0.200
     3.082    96.477     0.200
     3.082    96.273     0.200
     3.326   103.676     0.200
     3.326   102.074     0.200
     3.489   109.574     0.200
     3.854   118.773     0.200
     3.825   119.773     0.200
     3.825   119.477     0.200
     4.686   144.477     0.200
     4.683   145.875     0.200
     4.956   152.574     0.200
     4.956   151.773     0.200
     5.198   161.176     0.200
     5.246   164.977     0.200
     5.405   169.375     0.200
     5.689   176.574     0.200
     6.234   194.773     0.200
     6.234   190.574     0.200
     6.300   193.074     0.200
     6.939   216.273     0.200
     7.436   228.574     0.200
     7.436   228.074     0.200
     7.940   246.676     0.200
     8.326   256.875     0.200
     8.497   264.344     0.200
     8.564   263.574     0.200
     2.126    63.852     0.200
     2.860    88.852     0.200
     2.934    90.352     0.200
     3.696   114.552     0.200
     3.696   115.052     0.200
     3.871   121.151     0.200
     3.871   120.852     0.200
     3.747   117.252     0.200
     4.938   154.852     0.200
     4.958   154.151     0.200
     5.181   158.151     0.200
     5.181   158.951     0.200
     5.461   170.151     0.200
     5.686   177.352     0.200
     6.062   188.151     0.200
     6.062   187.951     0.200
     6.466   199.151     0.200
     6.466   198.852     0.200
     7.158   218.451     0.200
     8.191   256.951     0.200
     8.507   263.752     0.200
     8.701   269.951     0.200
     9.059   284.351     0.200
     2.611    82.039     0.200
     3.253   100.344     0.200
     3.861   120.742     0.200
     4.027   125.945     0.200
     4.328   133.945     0.200
     5.274   164.242     0.200
     5.465   168.844     0.200
     6.004   186.242     0.200
     6.405   199.445     0.200
     6.753   210.039     0.200
     7.435   231.141     0.200
     2.466    76.871     0.200
     2.466    77.570     0.200
     2.499    78.270     0.200
     2.499    78.070     0.200
     3.232   100.973     0.200
     3.930   121.172     0.200
     3.930   122.172     0.200
     4.214   130.371     0.200
     4.214   130.770     0.200
     4.263   132.770     0.200
     4.392   135.473     0.200
     4.392   135.672     0.200
     4.390   135.973     0.200
     5.120   158.070     0.200
     5.172   160.770     0.200
     5.172   161.270     0.200
     5.674   174.172     0.200
     6.307   193.570     0.200
     6.307   194.270     0.200
     6.362   196.070     0.200
     6.362   196.570     0.200
     6.685   205.570     0.200
     7.447   232.371     0.200
     7.526   230.070     0.200
     7.609   233.973     0.200
     9.648   297.672     0.200
     2.459    74.625     0.200
     2.783    87.125     0.200
     2.783    85.223     0.200
     2.954    91.824     0.200
     2.954    91.723     0.200
     3.358   103.422     0.200
     3.616   113.324     0.200
     3.702   114.625     0.200
     3.702   114.523     0.200
     3.987   123.023     0.200
     3.987   122.824     0.200
     4.804   149.625     0.200
     5.087   155.922     0.200
     5.087   155.523     0.200
     5.322   166.523     0.200
     5.371   167.824     0.200
     5.525   172.625     0.200
     5.738   177.324     0.200
     5.986   186.523     0.200
     6.363   197.422     0.200
     6.432   197.324     0.200
     7.070   216.422     0.200
     7.070   217.324     0.200
     7.569   233.523     0.200
     7.569   232.324     0.200
     8.066   247.223     0.200
     8.460   260.625     0.200
     8.700   269.125     0.200
     2.105    63.609     0.200
     2.679    83.809     0.200
     3.355   105.508     0.200
     3.441   106.309     0.200
     3.735   115.906     0.200
     3.992   124.309     0.200
     4.287   134.309     0.200
     4.601   141.809     0.200
     4.589   141.109     0.200
     5.045   157.809     0.200
     5.045   157.008     0.200
     5.320   165.309     0.200
     6.476   201.707     0.200
     6.897   213.406     0.200
     7.737   239.008     0.200
     7.814   239.609     0.200
     2.371    71.898     0.200
     2.371    72.000     0.200
     3.108    97.195     0.200
     3.165    98.297     0.200
     3.740   116.297     0.200
     4.019   125.797     0.200
     4.019   125.398     0.200
     4.237   131.797     0.200
     4.237   131.695     0.200
     4.325   133.195     0.200
     4.338   133.398     0.200
     5.066   157.195     0.200
     5.257   163.898     0.200
     5.257   163.695     0.200
     5.559   171.695     0.200
     5.606   172.594     0.200
     6.364   197.195     0.200
     6.364   197.398     0.200
     6.607   204.195     0.200
     6.607   201.500     0.200
     7.380   227.094     0.200
     7.446   230.195     0.200
     2.332    69.913     0.200
     3.366   103.513     0.200
     4.094   127.913     0.200
     4.297   133.713     0.200
     4.364   136.413     0.200
     5.513   169.713     0.200
     5.853   183.313     0.200
     6.106   190.113     0.200
     6.657   207.813     0.200
     7.893   245.313     0.200
     8.872   275.713     0.200
     2.357    71.250     0.200
     2.357    71.648     0.200
     2.352    73.449     0.200
     2.352    71.449     0.200
     2.801    86.250     0.200
     2.801    86.750     0.200
     2.948    90.551     0.200
     2.948    90.750     0.200
     3.463   107.551     0.200
     3.628   113.051     0.200
     3.628   116.750     0.200
     3.782   118.551     0.200
     3.782   117.949     0.200
     3.977   121.750     0.200
     4.261   131.449     0.200
     4.826   149.852     0.200
     5.086   155.648     0.200
     2.838    89.074     0.200
     2.838    88.574     0.200
     3.128    98.473     0.200
     3.566   111.473     0.200
     3.566   111.574     0.200
     3.494   107.973     0.200
     3.494   108.074     0.200
     4.086   127.273     0.200
     4.086   127.875     0.200
     4.384   137.574     0.200
     4.694   146.375     0.200
     4.694   146.672     0.200
     5.021   157.273     0.200
     5.576   175.375     0.200
     5.591   174.074     0.200
     5.820   180.773     0.200
     5.820   180.973     0.200
     5.844   181.672     0.200
     5.762   179.074     0.200
     5.786   181.473     0.200
     6.144   193.473     0.200
     6.193   194.473     0.200
     6.409   197.875     0.200
     7.106   219.574     0.200
     7.796   239.254     0.200
     8.830   275.672     0.200
     8.830   276.074     0.200
     9.138   283.273     0.200
     9.313   289.473     0.200
     9.646   302.812     0.200
    11.400   351.172     0.200
    17.129   534.898     0.200
     2.544    79.289     0.200
     3.211   100.992     0.200
     3.292   101.492     0.200
     3.866   119.695     0.200
     3.866   120.289     0.200
     4.220   130.789     0.200
     4.321   133.289     0.200
     4.452   138.391     0.200
     4.444   137.695     0.200
     4.756   147.094     0.200
     4.797   148.594     0.200
     5.121   159.695     0.200
     6.369   194.695     0.200
     6.382   198.594     0.200
     7.675   234.891     0.200
     2.484    78.070     0.200
     2.484    77.969     0.200
     3.143    98.672     0.200
     3.217    99.469     0.200
     3.939   121.969     0.200
     3.939   122.070     0.200
     4.249   131.969     0.200
     4.378   134.773     0.200
     4.375   136.367     0.200
     4.689   145.867     0.200
     4.870   151.570     0.200
     5.174   160.172     0.200
     5.619   174.273     0.200
     6.293   193.070     0.200
     6.293   192.867     0.200
     6.348   197.672     0.200
     6.673   205.469     0.200
     6.673   205.570     0.200
     7.433   228.273     0.200
     7.514   231.070     0.200
     7.599   234.570     0.200
     2.325    70.213     0.200
     3.187    99.113     0.200
     3.961   122.912     0.200
     4.032   125.713     0.200
     4.243   131.412     0.200
     5.383   166.113     0.200
     5.474   170.312     0.200
     5.696   177.113     0.200
     5.935   185.812     0.200
     6.398   197.713     0.200
     7.350   228.312     0.200
     8.818   273.012     0.200
     2.233    69.789     0.200
     2.844    88.189     0.200
     2.844    88.789     0.200
     3.010    93.689     0.200
     3.751   114.689     0.200
     3.811   118.488     0.200
     3.868   120.689     0.200
     3.982   123.988     0.200
     3.982   122.289     0.200
     4.087   125.090     0.200
     4.087   126.090     0.200
     5.222   160.090     0.200
     5.222   161.090     0.200
     5.297   163.689     0.200
     5.525   171.988     0.200
     6.538   201.289     0.200
     8.520   264.189     0.200
     8.690   267.189     0.200
     9.172   289.416     0.200
    16.550   516.215     0.200
    20.844   656.639     0.200
     2.296    69.606     0.200
     3.291   101.106     0.200
     3.291   102.406     0.200
     3.625   113.906     0.200
     4.072   126.506     0.200
     4.082   126.806     0.200
     4.082   127.206     0.200
     4.218   132.406     0.200
     4.218   133.206     0.200
     4.301   132.406     0.200
     4.301   132.806     0.200
     5.448   167.206     0.200
     5.448   167.806     0.200
     5.577   173.506     0.200
     5.783   179.706     0.200
     5.825   181.206     0.200
     6.033   187.906     0.200
     6.310   196.506     0.200
     6.308   195.306     0.200
     6.413   199.406     0.200
     6.576   205.906     0.200
     6.738   207.306     0.200
     6.745   208.906     0.200
     6.745   208.206     0.200
     7.407   226.516     0.200
     7.407   228.906     0.200
     7.836   242.406     0.200
     7.836   241.206     0.200
     8.486   264.906     0.200
     8.486   263.406     0.200
     8.697   269.706     0.200
     8.826   274.406     0.200
     9.487   300.086     0.200
    21.119   675.056     0.200
    21.345   679.381     0.200
     2.571    81.312     0.200
     2.776    85.211     0.200
     2.727    84.414     0.200
     2.885    88.211     0.200
     3.675   112.609     0.200
     3.710   117.312     0.200
     3.881   119.211     0.200
     3.881   118.914     0.200
     4.111   127.609     0.200
     4.247   132.516     0.200
     4.297   133.609     0.200
     4.541   140.211     0.200
     5.166   161.109     0.200
     5.166   159.914     0.200
     5.166   158.109     0.200
     5.170   159.812     0.200
     5.758   178.016     0.200
     5.758   178.609     0.200
     5.831   179.211     0.200
     5.831   177.812     0.200
     6.007   185.414     0.200
     6.257   192.414     0.200
     6.929   216.211     0.200
     7.123   220.609     0.200
     7.123   218.109     0.200
     8.139   258.055     0.200
    15.278   480.109     0.200
    17.428   548.734     0.200
    19.998   630.984     0.200
    20.090   630.984     0.200
    21.246   673.859     0.200
    21.246   673.859     0.200
    26.882   843.703     0.200
     2.107    64.023     0.200
     2.663    82.623     0.200
     3.360   102.724     0.200
     3.349   104.423     0.200
     3.698   114.523     0.200
     3.698   114.724     0.200
     4.240   131.423     0.200
     4.609   140.123     0.200
     4.630   143.623     0.200
     4.892   151.523     0.200
     4.990   154.623     0.200
     5.058   156.423     0.200
     5.894   180.923     0.200
     6.436   197.823     0.200
     6.531   199.623     0.200
     3.303   102.656     0.200
     3.605   112.855     0.200
     4.062   127.055     0.200
     4.062   126.656     0.200
     4.216   133.355     0.200
     4.317   133.855     0.200
     4.498   140.355     0.200
     5.260   164.156     0.200
     5.463   169.055     0.200
     5.590   173.656     0.200
     5.839   181.656     0.200
     6.046   188.855     0.200
     6.289   196.254     0.200
     6.753   210.156     0.200
     7.423   229.555     0.200
     7.853   243.156     0.200
     8.501   263.355     0.200
     8.715   271.156     0.200
     8.845   270.754     0.200
     8.845   274.754     0.200
     2.289    70.980     0.200
     2.742    85.582     0.200
     2.742    85.480     0.200
     3.158    97.582     0.200
     3.158    97.180     0.200
     3.658   112.680     0.200
     4.026   126.281     0.200
     3.992   125.582     0.200
     4.210   131.082     0.200
     4.210   127.980     0.200
     4.531   139.883     0.200
     5.133   160.383     0.200
     5.350   165.281     0.200
     5.446   168.582     0.200
     5.906   184.582     0.200
     6.387   199.680     0.200
     6.310   196.883     0.200
     6.659   207.082     0.200
     7.317   225.383     0.200
     7.761   240.281     0.200
     8.380   259.883     0.200
     8.629   268.383     0.200
     8.782   272.582     0.200
     3.314   103.641     0.200
     3.438   107.340     0.200
     3.774   118.141     0.200
     3.774   117.738     0.200
     4.026   125.238     0.200
     4.026   124.941     0.200
     4.304   134.238     0.200
     4.405   136.539     0.200
     4.405   135.441     0.200
     5.308   167.039     0.200
     5.538   170.941     0.200
     5.881   183.840     0.200
     6.066   190.039     0.200
     6.102   189.941     0.200
     6.148   191.941     0.200
     6.413   199.738     0.200
     6.413   199.441     0.200
     6.826   212.141     0.200
     6.856   211.238     0.200
     6.856   212.340     0.200
     6.856   212.738     0.200
     7.510   229.832     0.200
     7.510   232.238     0.200
     7.621   234.840     0.200
     7.621   239.141     0.200
     7.965   244.641     0.200
     8.559   264.840     0.200
     8.837   273.141     0.200
     9.002   277.539     0.200
     9.227   288.238     0.200
    17.806   554.816     0.200
    20.415   637.840     0.200
     3.299   102.844     0.200
     3.299   101.438     0.200
     3.609   113.539     0.200
     4.081   126.641     0.200
     4.064   127.039     0.200
     4.064   126.539     0.200
     4.213   131.641     0.200
     4.213   133.641     0.200
     4.313   132.539     0.200
     4.313   132.438     0.200
     4.725   147.641     0.200
     5.256   162.844     0.200
     5.459   167.641     0.200
     5.459   166.844     0.200
     5.835   183.539     0.200
     5.867   183.039     0.200
     6.042   188.242     0.200
     6.370   198.039     0.200
     6.292   196.438     0.200
     6.574   205.242     0.200
     6.749   208.039     0.200
     6.757   209.039     0.200
     7.419   228.438     0.200
     7.849   242.742     0.200
     8.497   265.344     0.200
     8.711   269.039     0.200
     8.711   269.438     0.200
     8.841   273.539     0.200
     2.808    86.824     0.200
     2.808    86.723     0.200
     3.466   106.824     0.200
     3.466   106.621     0.200
     3.651   112.523     0.200
     3.651   112.223     0.200
     4.239   132.121     0.200
     4.239   131.523     0.200
     4.398   135.121     0.200
     4.655   145.621     0.200
     4.757   146.723     0.200
     4.790   148.723     0.200
     4.790   148.422     0.200
     4.809   147.922     0.200
     4.809   146.223     0.200
     5.058   157.023     0.200
     5.243   162.922     0.200
     5.255   162.422     0.200
     5.299   162.824     0.200
     5.727   176.922     0.200
     6.096   188.121     0.200
     6.322   194.023     0.200
     6.480   201.023     0.200
     6.741   207.121     0.200
     7.092   219.422     0.200
     7.134   218.824     0.200
     7.863   242.023     0.200
     7.981   246.023     0.200
     8.073   249.723     0.200
     9.068   284.684     0.200
    10.737   329.094     0.200
    13.735   426.672     0.200
     2.346    73.793     0.200
     2.704    84.695     0.200
     2.704    84.395     0.200
     3.161    97.293     0.200
     3.161    99.492     0.200
     3.161    97.395     0.200
     3.518   106.793     0.200
     3.615   111.793     0.200
     3.915   122.195     0.200
     3.973   124.094     0.200
     4.234   130.395     0.200
     4.234   130.992     0.200
     4.481   138.895     0.200
     5.146   161.094     0.200
     5.181   162.195     0.200
     5.370   165.992     0.200
     5.370   164.195     0.200
     5.448   169.195     0.200
     5.720   178.492     0.200
     6.275   195.195     0.200
     6.342   196.992     0.200
     6.659   206.992     0.200
     6.898   213.094     0.200
     7.340   226.492     0.200
     7.669   238.695     0.200
     7.791   239.695     0.200
     8.395   259.195     0.200
     8.663   269.293     0.200
     8.824   273.492     0.200
     9.102   285.293     0.200
    12.870   398.070     0.200
     2.717    84.641     0.200
     2.717    83.945     0.200
     3.398   104.641     0.200
     3.478   107.945     0.200
     3.440   107.344     0.200
     3.591   111.445     0.200
     4.083   126.344     0.200
     4.124   126.445     0.200
     4.124   131.039     0.200
     4.406   136.945     0.200
     4.583   141.344     0.200
     4.737   148.945     0.200
     4.737   147.242     0.200
     4.677   144.844     0.200
     4.747   146.742     0.200
     4.747   144.945     0.200
     4.975   154.445     0.200
     5.298   163.344     0.200
     5.170   160.039     0.200
     5.410   167.641     0.200
     6.018   185.539     0.200
     6.036   185.641     0.200
     6.263   192.141     0.200
     6.687   205.344     0.200
     6.687   205.242     0.200
     7.089   219.844     0.200
     7.799   242.141     0.200
     8.050   249.039     0.200
    10.325   321.242     0.200
     2.268    68.867     0.200
     2.268    70.066     0.200
     2.790    86.469     0.200
     2.790    86.066     0.200
     3.078    94.867     0.200
     3.078    94.766     0.200
     3.547   108.566     0.200
     3.700   114.566     0.200
     3.877   119.668     0.200
     3.931   122.266     0.200
     3.972   123.867     0.200
     3.972   124.066     0.200
     4.147   127.566     0.200
     4.147   127.766     0.200
     4.519   140.668     0.200
     4.564   140.367     0.200
     5.284   162.367     0.200
     5.828   181.766     0.200
     6.291   194.867     0.200
     6.336   196.969     0.200
     6.390   198.766     0.200
     6.572   203.969     0.200
     6.598   204.469     0.200
     7.254   224.469     0.200
     7.673   239.969     0.200
     7.705   234.969     0.200
     8.576   263.266     0.200
     8.739   268.566     0.200
     9.029   280.066     0.200
     9.243   291.605     0.200
    12.922   403.742     0.200
     2.711    83.938     0.200
     2.711    83.639     0.200
     3.339   102.839     0.200
     3.410   106.139     0.200
     3.525   110.139     0.200
     3.604   110.938     0.200
     3.604   111.039     0.200
     4.050   125.639     0.200
     4.226   130.238     0.200
     4.226   133.238     0.200
     4.226   133.039     0.200
     4.537   140.039     0.200
     4.536   140.339     0.200
     4.646   143.238     0.200
     4.684   144.238     0.200
     4.684   145.039     0.200
     4.902   152.139     0.200
     4.902   151.839     0.200
     4.951   153.339     0.200
     5.126   158.839     0.200
     5.134   159.839     0.200
     5.435   166.639     0.200
     5.603   172.738     0.200
     5.939   181.238     0.200
     5.970   184.938     0.200
     8.974   281.031     0.200
    13.841   432.851     0.200
    15.647   491.781     0.200
    17.151   532.944     0.200
    17.466   550.031     0.200
     3.478   107.708     0.200
     3.818   117.107     0.200
     3.932   122.808     0.200
     4.101   127.007     0.200
     4.075   126.907     0.200
     4.109   127.107     0.200
     4.109   126.808     0.200
     4.514   138.808     0.200
     4.550   143.208     0.200
     4.558   141.607     0.200
     4.806   150.407     0.200
     5.027   155.007     0.200
     5.173   162.607     0.200
     5.173   162.007     0.200
     5.372   166.308     0.200
     5.372   165.007     0.200
     5.396   167.308     0.200
     5.622   172.007     0.200
     5.895   181.607     0.200
     6.045   187.808     0.200
     6.045   185.808     0.200
     6.042   186.708     0.200
     6.042   184.577     0.200
     7.421   229.107     0.200
     8.425   263.127     0.200
    11.437   348.157     0.200
    14.053   437.583     0.200
    15.292   477.058     0.200
    17.319   536.657     0.200
     2.615    79.727     0.200
     3.479   108.426     0.200
     3.819   118.526     0.200
     3.929   123.626     0.200
     4.097   127.326     0.200
     4.076   127.126     0.200
     4.111   127.526     0.200
     4.385   136.126     0.200
     4.516   139.126     0.200
     4.808   149.326     0.200
     5.168   162.126     0.200
     5.168   161.227     0.200
     5.399   166.727     0.200
     5.624   174.126     0.200
     6.045   186.426     0.200
     6.045   185.195     0.200
     6.044   188.626     0.200
     6.448   198.227     0.200
     7.301   225.826     0.200
     7.425   229.227     0.200
     8.426   265.426     0.200
    11.434   349.477     0.200
    14.049   438.176     0.200
    15.297   480.631     0.200
    17.322   538.727     0.200
    17.680   551.485     0.200
     2.769    86.000     0.200
     3.318   102.000     0.200
     3.480   108.594     0.200
     3.500   108.297     0.200
     3.610   112.398     0.200
     4.215   131.094     0.200
     4.431   136.898     0.200
     4.615   143.500     0.200
     4.769   147.500     0.200
     4.807   149.695     0.200
     5.018   156.000     0.200
     5.330   164.594     0.200
     5.449   168.398     0.200
     5.687   175.195     0.200
     6.281   194.000     0.200
     6.701   205.797     0.200
     7.095   219.195     0.200
     7.119   221.398     0.200
     7.822   242.000     0.200
     7.942   245.000     0.200
     8.037   249.094     0.200
    10.078   311.297     0.200
     3.322   103.192     0.200
     3.464   105.493     0.200
     3.452   107.393     0.200
     3.452   109.493     0.200
     3.812   119.093     0.200
     4.062   127.792     0.200
     4.125   129.692     0.200
     4.323   135.393     0.200
     4.401   137.692     0.200
     5.311   165.292     0.200
     5.344   167.692     0.200
     5.537   171.292     0.200
     5.609   174.393     0.200
     5.840   179.893     0.200
     5.926   183.993     0.200
     6.073   188.593     0.200
     6.120   190.692     0.200
     6.442   200.292     0.200
     6.446   201.493     0.200
     7.065   220.593     0.200
     7.958   248.393     0.200
     8.829   272.893     0.200
    12.289   380.093     0.200
    12.464   387.093     0.200
     3.288   102.480     0.200
     3.480   107.680     0.200
     3.480   109.680     0.200
     3.486   106.383     0.200
     3.821   118.980     0.200
     4.034   125.980     0.200
     4.034   123.383     0.200
     4.092   126.883     0.200
     4.369   136.180     0.200
     4.369   134.680     0.200
     4.348   134.281     0.200
     5.505   170.781     0.200
     5.574   172.781     0.200
     6.039   187.180     0.200
     6.146   191.480     0.200
     6.409   199.281     0.200
     6.416   200.680     0.200
     6.416   198.680     0.200
     6.793   209.582     0.200
     6.820   209.980     0.200
     6.820   210.980     0.200
     7.032   216.680     0.200
     7.475   231.281     0.200
     7.475   230.250     0.200
     7.654   238.383     0.200
     7.927   244.281     0.200
     8.528   263.383     0.200
     8.799   272.180     0.200
     8.959   278.480     0.200
     9.432   297.395     0.200
    10.087   307.637     0.200
    11.039   340.082     0.200
    12.262   379.281     0.200
    12.780   400.031     0.200
     3.295   103.188     0.200
     3.477   106.289     0.200
     3.476   108.992     0.200
     3.824   119.289     0.200
     4.043   125.992     0.200
     4.098   126.391     0.200
     4.346   134.789     0.200
     4.375   136.391     0.200
     5.582   174.789     0.200
     6.047   187.594     0.200
     6.143   191.891     0.200
     6.415   198.492     0.200
     6.425   200.992     0.200
     6.799   211.289     0.200
     7.038   219.891     0.200
     7.481   232.789     0.200
     7.932   245.094     0.200
     8.534   264.391     0.200
     8.803   272.188     0.200
     8.963   278.492     0.200
     2.490    75.117     0.200
     3.300   103.516     0.200
     3.300   102.414     0.200
     3.464   109.016     0.200
     3.489   107.016     0.200
     3.806   119.820     0.200
     3.806   119.516     0.200
     4.035   126.414     0.200
     4.035   124.914     0.200
     4.104   128.414     0.200
     4.332   136.320     0.200
     4.383   135.219     0.200
     4.383   135.516     0.200
     5.290   165.320     0.200
     5.518   171.914     0.200
     5.518   169.117     0.200
     5.586   174.414     0.200
     5.864   181.219     0.200
     5.905   183.516     0.200
     6.130   191.516     0.200
     6.051   188.617     0.200
     6.418   200.219     0.200
     6.418   199.820     0.200
     6.806   210.719     0.200
     6.806   209.117     0.200
     6.834   211.016     0.200
     6.834   210.719     0.200
     7.046   217.719     0.200
     7.489   230.414     0.200
     7.489   229.469     0.200
     7.489   231.414     0.200
     7.646   239.219     0.200
     7.942   245.516     0.200
     8.541   266.414     0.200
     8.813   273.016     0.200
     8.975   278.914     0.200
     9.441   298.938     0.200
     9.466   300.383     0.200
    10.075   308.664     0.200
    12.278   380.117     0.200
    16.503   516.641     0.200
    16.784   528.617     0.200
    16.897   529.875     0.200
    20.434   635.195     0.200
    21.658   684.641     0.200
    25.758   820.914     0.200
     3.314   103.922     0.200
     3.314   103.820     0.200
     3.462   107.719     0.200
     3.464   105.523     0.200
     3.820   120.219     0.200
     4.059   125.922     0.200
     4.117   129.125     0.200
     4.392   135.922     0.200
     4.332   135.523     0.200
     5.302   163.219     0.200
     5.528   172.125     0.200
     5.600   174.422     0.200
     5.876   183.422     0.200
     6.129   191.820     0.200
     6.442   201.820     0.200
     6.442   198.125     0.200
     6.816   212.523     0.200
     7.056   219.219     0.200
     7.498   231.719     0.200
     7.949   245.625     0.200
     8.552   265.023     0.200
     8.820   273.219     0.200
     8.978   277.422     0.200
     9.459   296.844     0.200
    11.056   343.719     0.200
     3.313   103.219     0.200
     3.463   107.516     0.200
     3.462   107.922     0.200
     3.821   120.117     0.200
     3.821   118.820     0.200
     4.116   128.117     0.200
     4.333   135.117     0.200
     4.391   136.820     0.200
     5.302   165.320     0.200
     5.527   171.719     0.200
     5.600   173.820     0.200
     6.065   189.016     0.200
     6.130   190.719     0.200
     6.432   199.820     0.200
     6.442   201.719     0.200
     6.442   200.320     0.200
     6.816   210.219     0.200
     7.055   217.820     0.200
     7.498   231.016     0.200
     7.948   245.617     0.200
     8.819   272.219     0.200
     8.977   278.016     0.200
     3.305   102.094     0.200
     3.471   105.793     0.200
     3.469   108.395     0.200
     3.821   119.594     0.200
     4.051   126.594     0.200
     4.108   126.992     0.200
     4.339   134.594     0.200
     4.384   135.793     0.200
     4.749   148.094     0.200
     5.519   170.691     0.200
     5.591   175.191     0.200
     6.056   188.395     0.200
     6.136   190.094     0.200
     6.424   199.594     0.200
     6.433   199.992     0.200
     7.047   219.594     0.200
     7.490   230.992     0.200
     7.941   246.691     0.200
     8.543   266.492     0.200
     8.812   270.895     0.200
     8.971   277.594     0.200
    11.050   342.293     0.200
    12.448   386.395     0.200
     3.332   103.891     0.200
     3.332   103.590     0.200
     3.434   107.293     0.200
     3.475   106.293     0.200
     3.790   119.590     0.200
     3.790   118.293     0.200
     4.056   127.391     0.200
     4.137   128.891     0.200
     4.303   134.492     0.200
     4.416   137.391     0.200
     4.416   136.391     0.200
     4.778   148.793     0.200
     5.551   171.293     0.200
     5.618   175.492     0.200
     5.851   182.391     0.200
     6.082   188.992     0.200
     6.084   189.492     0.200
     6.100   189.793     0.200
     6.442   200.691     0.200
     6.455   199.992     0.200
     6.839   211.891     0.200
     6.867   211.891     0.200
     7.079   217.891     0.200
     7.522   232.492     0.200
     7.522   230.461     0.200
     7.650   236.793     0.200
     8.845   272.992     0.200
     9.006   277.891     0.200
     9.251   289.090     0.200
     9.472   297.891     0.200
    10.042   306.797     0.200
    11.085   341.590     0.200
    12.484   385.793     0.200
    12.750   398.918     0.200
    16.495   520.367     0.200
     2.018    61.277     0.200
     3.350   104.676     0.200
     3.412   106.477     0.200
     3.477   106.375     0.200
     3.770   117.777     0.200
     3.770   117.277     0.200
     4.155   129.277     0.200
     4.436   137.477     0.200
     4.436   137.375     0.200
     4.281   133.676     0.200
     4.796   148.777     0.200
     5.342   165.375     0.200
     5.571   172.578     0.200
     5.635   176.078     0.200
     5.870   181.977     0.200
     5.915   183.277     0.200
     5.957   186.078     0.200
     6.101   189.875     0.200
     6.078   189.176     0.200
     6.448   200.777     0.200
     6.448   198.777     0.200
     6.475   202.078     0.200
     6.859   213.777     0.200
     6.887   214.477     0.200
     7.099   219.176     0.200
     7.542   233.176     0.200
     7.641   235.875     0.200
     7.995   246.176     0.200
     8.593   265.777     0.200
     8.867   274.875     0.200
     9.028   281.277     0.200
    11.107   345.176     0.200
     2.502    76.028     0.200
     3.472   106.729     0.200
     3.321   103.528     0.200
     3.321   103.229     0.200
     3.449   107.329     0.200
     3.804   119.629     0.200
     3.804   119.429     0.200
     4.125   128.429     0.200
     4.402   135.929     0.200
     4.402   134.929     0.200
     4.319   133.729     0.200
     4.766   148.629     0.200
     5.311   165.929     0.200
     5.538   170.729     0.200
     5.607   174.729     0.200
     5.884   182.929     0.200
     5.925   183.629     0.200
     5.925   186.329     0.200
     6.072   188.429     0.200
     6.442   199.929     0.200
     6.826   211.729     0.200
     7.508   231.429     0.200
     7.960   244.829     0.200
     8.561   264.929     0.200
     8.831   273.329     0.200
     8.991   279.229     0.200
     9.243   287.729     0.200
     9.463   297.549     0.200
    10.054   308.429     0.200
    12.468   384.429     0.200
    17.769   550.704     0.200
    21.669   681.954     0.200
     3.235   100.453     0.200
     3.440   105.148     0.200
     3.571   112.453     0.200
     3.927   122.547     0.200
     4.032   125.953     0.200
     4.057   126.453     0.200
     4.295   133.047     0.200
     4.446   137.750     0.200
     4.674   145.547     0.200
     5.434   167.953     0.200
     5.828   180.250     0.200
     5.985   186.648     0.200
     6.242   194.250     0.200
     6.340   197.648     0.200
     6.427   201.250     0.200
     6.723   208.547     0.200
     6.961   215.547     0.200
     7.401   228.352     0.200
     7.847   242.750     0.200
     8.462   262.953     0.200
     8.716   269.250     0.200
     8.869   275.648     0.200
    10.944   339.953     0.200
     3.304   102.961     0.200
     3.304   102.762     0.200
     3.463   107.660     0.200
     3.810   119.461     0.200
     3.810   119.262     0.200
     4.042   125.762     0.200
     4.042   124.762     0.200
     4.386   135.961     0.200
     4.386   134.863     0.200
     4.332   134.363     0.200
     4.749   147.762     0.200
     5.521   171.062     0.200
     5.822   181.062     0.200
     5.867   183.762     0.200
     5.909   184.062     0.200
     6.055   188.062     0.200
     6.110   188.961     0.200
     6.130   190.961     0.200
     6.426   200.062     0.200
     6.425   199.363     0.200
     6.425   198.961     0.200
     6.809   211.562     0.200
     6.837   211.461     0.200
     6.837   210.762     0.200
     7.049   219.262     0.200
     7.492   229.359     0.200
     7.492   231.363     0.200
     7.944   245.363     0.200
     8.544   265.461     0.200
     8.815   273.461     0.200
     8.976   277.461     0.200
     9.446   296.902     0.200
    11.056   340.863     0.200
     2.850    88.644     0.200
     3.232   101.043     0.200
     3.392   103.243     0.200
     3.602   111.144     0.200
     3.791   118.644     0.200
     4.080   128.543     0.200
     4.157   128.843     0.200
     4.246   131.243     0.200
     4.492   139.743     0.200
     4.761   148.943     0.200
     4.943   152.743     0.200
     5.044   156.043     0.200
     5.126   158.743     0.200
     5.304   165.743     0.200
     5.345   166.644     0.200
     5.367   168.144     0.200
     5.570   172.743     0.200
     5.858   182.743     0.200
     6.228   192.144     0.200
     6.233   193.443     0.200
     6.368   198.843     0.200
     6.464   201.043     0.200
     6.894   211.644     0.200
     7.311   226.644     0.200
     7.990   248.043     0.200
     8.169   253.543     0.200
     8.292   255.943     0.200
    10.351   320.843     0.200
    10.558   327.144     0.200
    11.740   362.243     0.200
     2.484    74.430     0.200
     3.294   102.430     0.200
     3.470   108.527     0.200
     3.491   106.629     0.200
     3.810   119.328     0.200
     3.810   118.527     0.200
     4.031   126.527     0.200
     4.031   124.129     0.200
     4.098   128.730     0.200
     4.377   136.930     0.200
     4.377   136.730     0.200
     4.338   135.230     0.200
     4.739   148.027     0.200
     5.284   164.730     0.200
     5.512   170.027     0.200
     5.512   170.129     0.200
     5.580   173.828     0.200
     5.813   180.129     0.200
     5.858   182.027     0.200
     5.899   183.629     0.200
     6.115   189.430     0.200
     6.416   199.328     0.200
     6.414   200.230     0.200
     6.800   210.027     0.200
     6.828   212.328     0.200
     7.040   217.828     0.200
     7.483   230.527     0.200
     7.936   246.828     0.200
     8.535   266.129     0.200
     8.807   273.730     0.200
     8.969   279.230     0.200
     9.215   287.629     0.200
    11.050   341.930     0.200
    11.211   348.230     0.200
    12.769   399.027     0.200
    16.506   516.480     0.200
    16.779   524.504     0.200
    20.842   658.605     0.200
    21.618   684.152     0.200
     2.826    87.379     0.200
     2.826    88.777     0.200
     2.910    91.078     0.200
     3.372   103.980     0.200
     3.372   103.277     0.200
     3.659   113.680     0.200
     3.661   116.078     0.200
     4.032   125.578     0.200
     4.032   126.379     0.200
     4.128   126.277     0.200
     4.288   133.879     0.200
     4.556   142.379     0.200
     5.088   158.680     0.200
     5.132   157.680     0.200
     5.132   157.578     0.200
     5.365   167.078     0.200
     5.567   173.777     0.200
     5.757   178.680     0.200
     5.757   179.180     0.200
     6.017   186.480     0.200
     6.656   203.980     0.200
     7.115   219.680     0.200
     7.113   223.180     0.200
     7.615   233.980     0.200
     8.506   262.078     0.200
     8.625   268.379     0.200
     8.746   271.980     0.200
     8.858   278.293     0.200
     2.730    84.697     0.200
     3.150    97.197     0.200
     3.494   106.396     0.200
     3.947   123.797     0.200
     3.955   122.896     0.200
     3.991   123.797     0.200
     3.991   123.396     0.200
     4.214   129.697     0.200
     4.214   129.896     0.200
     4.512   138.998     0.200
     4.590   142.098     0.200
     5.352   164.797     0.200
     5.352   163.697     0.200
     5.438   168.797     0.200
     5.662   176.098     0.200
     5.900   183.697     0.200
     6.258   194.498     0.200
     6.288   195.197     0.200
     6.310   195.797     0.200
     6.879   212.197     0.200
     7.320   224.066     0.200
     7.320   225.197     0.200
     7.320   224.998     0.200
     8.638   266.797     0.200
     8.796   271.998     0.200
     9.316   294.143     0.200
    11.040   341.598     0.200
    12.276   379.998     0.200
    12.910   405.348     0.200
     2.459    76.875     0.200
     2.459    76.375     0.200
     2.544    78.977     0.200
     3.315   102.074     0.200
     3.455   107.176     0.200
     3.455   107.574     0.200
     3.851   120.277     0.200
     4.269   132.574     0.200
     4.221   132.074     0.200
     4.221   130.977     0.200
     4.251   132.477     0.200
     4.509   139.977     0.200
     4.894   150.977     0.200
     5.650   173.777     0.200
     5.743   177.977     0.200
     6.061   188.277     0.200
     6.059   187.875     0.200
     6.205   193.777     0.200
     7.615   234.770     0.200
     7.615   235.676     0.200
     8.680   269.875     0.200
     8.922   275.777     0.200
     9.063   280.176     0.200
     9.925   302.125     0.200
     9.615   302.402     0.200
    11.127   342.574     0.200
    11.319   349.574     0.200
    12.814   402.199     0.200
    16.592   523.988     0.200
     2.481    74.352     0.200
     3.290   102.750     0.200
     3.492   106.648     0.200
     3.812   118.953     0.200
     3.812   119.148     0.200
     4.029   125.148     0.200
     4.029   124.953     0.200
     4.094   128.055     0.200
     4.341   136.148     0.200
     4.374   135.953     0.200
     4.374   135.648     0.200
     4.736   147.852     0.200
     5.509   169.453     0.200
     5.509   167.852     0.200
     5.576   173.953     0.200
     5.809   179.953     0.200
     5.854   183.148     0.200
     6.118   190.555     0.200
     6.139   191.648     0.200
     6.413   200.352     0.200
     6.412   199.352     0.200
     6.412   198.250     0.200
     6.797   210.852     0.200
     6.825   211.852     0.200
     7.036   218.148     0.200
     7.480   231.352     0.200
     7.645   236.750     0.200
     7.932   244.352     0.200
     8.531   265.648     0.200
     8.804   273.352     0.200
     8.966   277.453     0.200
     9.212   286.352     0.200
    11.046   339.648     0.200
    11.207   346.352     0.200
    12.447   383.250     0.200
     2.499    78.413     0.200
     2.502    78.013     0.200
     3.424   105.713     0.200
     3.892   121.213     0.200
     4.217   131.713     0.200
     4.218   131.913     0.200
     4.315   134.213     0.200
     4.470   139.713     0.200
     4.860   150.213     0.200
     5.612   174.213     0.200
     5.711   177.513     0.200
     5.931   185.113     0.200
     5.975   186.013     0.200
     6.011   186.713     0.200
     6.106   189.513     0.200
     6.104   190.013     0.200
     6.172   191.313     0.200
     6.520   201.213     0.200
     6.598   206.013     0.200
     6.901   214.313     0.200
     7.138   221.713     0.200
     7.577   233.613     0.200
     8.015   248.213     0.200
     8.644   269.513     0.200
     8.880   275.713     0.200
     9.020   279.113     0.200
    11.083   341.613     0.200
    11.277   348.313     0.200
    12.469   385.513     0.200
     3.278   102.242     0.200
     3.495   106.641     0.200
     3.820   120.141     0.200
     4.023   125.039     0.200
     4.082   127.438     0.200
     4.361   135.438     0.200
     4.354   136.742     0.200
     4.723   145.844     0.200
     4.723   148.344     0.200
     5.496   168.844     0.200
     5.564   173.641     0.200
     5.797   180.742     0.200
     5.883   181.539     0.200
     6.030   187.742     0.200
     6.151   191.844     0.200
     6.400   198.742     0.200
     6.405   199.242     0.200
     6.784   209.641     0.200
     6.812   211.641     0.200
     7.024   218.242     0.200
     7.467   230.438     0.200
     7.920   242.344     0.200
     7.920   246.844     0.200
     8.519   263.938     0.200
     8.791   270.742     0.200
     8.953   277.438     0.200
    11.034   341.539     0.200
    12.435   382.742     0.200
     2.585    78.578     0.200
     3.367   104.477     0.200
     3.656   115.078     0.200
     3.656   114.777     0.200
     3.875   120.578     0.200
     4.057   125.477     0.200
     4.057   123.777     0.200
     4.056   126.277     0.200
     4.056   125.375     0.200
     4.420   137.277     0.200
     4.694   145.875     0.200
     4.971   153.977     0.200
     4.964   154.078     0.200
     4.991   156.875     0.200
     4.991   156.676     0.200
     5.579   171.375     0.200
     5.791   179.875     0.200
     5.814   180.375     0.200
     6.012   186.496     0.200
     6.012   186.176     0.200
     6.445   199.578     0.200
     7.102   220.875     0.200
     7.312   225.875     0.200
     7.478   232.375     0.200
     7.569   234.875     0.200
     9.714   301.176     0.200
    11.004   339.477     0.200
    11.489   351.754     0.200
     3.295   102.602     0.200
     3.492   107.302     0.200
     3.469   109.202     0.200
     3.808   119.602     0.200
     3.808   119.102     0.200
     4.031   125.302     0.200
     4.031   125.102     0.200
     4.099   127.602     0.200
     4.336   135.602     0.200
     4.378   136.002     0.200
     4.378   135.901     0.200
     5.285   164.002     0.200
     5.513   169.401     0.200
     5.513   168.302     0.200
     5.581   173.802     0.200
     5.814   180.302     0.200
     5.859   181.802     0.200
     5.900   183.302     0.200
     6.113   189.602     0.200
     6.418   199.401     0.200
     6.414   198.302     0.200
     6.801   211.002     0.200
     6.829   211.602     0.200
     6.829   211.002     0.200
     7.041   217.102     0.200
     7.484   229.401     0.200
     7.937   244.401     0.200
     8.536   264.002     0.200
     8.809   271.802     0.200
     8.971   277.602     0.200
     9.436   296.396     0.200
    11.051   340.202     0.200
    12.767   400.602     0.200
    16.504   519.202     0.200
    20.439   641.927     0.200
     3.447   108.281     0.200
     3.330   104.383     0.200
     3.330   103.883     0.200
     3.455   105.781     0.200
     3.814   119.883     0.200
     3.814   119.781     0.200
     4.071   127.180     0.200
     4.071   126.180     0.200
     4.319   134.180     0.200
     4.408   136.383     0.200
     4.408   136.484     0.200
     5.544   171.180     0.200
     5.544   169.383     0.200
     5.847   180.781     0.200
     5.892   182.086     0.200
     6.099   189.383     0.200
     6.116   190.086     0.200
     6.081   189.680     0.200
     6.455   201.086     0.200
     6.455   200.586     0.200
     6.449   198.586     0.200
     6.832   210.086     0.200
     6.858   212.680     0.200
     7.071   219.586     0.200
     7.514   231.180     0.200
     7.514   232.086     0.200
     7.964   245.883     0.200
     8.568   266.680     0.200
     8.835   272.383     0.200
     8.992   277.281     0.200
     9.475   294.727     0.200
    10.045   308.062     0.200
    11.237   348.484     0.200
    12.467   385.586     0.200
    16.520   519.508     0.200
    20.408   638.305     0.200
     2.357    70.953     0.200
     3.206    99.754     0.200
     3.465   105.754     0.200
     3.592   111.555     0.200
     3.929   122.254     0.200
     4.003   125.254     0.200
     4.028   124.855     0.200
     4.269   132.254     0.200
     4.464   138.453     0.200
     5.186   161.055     0.200
     5.407   165.953     0.200
     5.407   167.453     0.200
     5.717   176.555     0.200
     5.761   179.754     0.200
     5.955   185.453     0.200
     6.242   193.453     0.200
     6.313   195.754     0.200
     6.398   198.555     0.200
     6.398   197.156     0.200
     6.696   205.555     0.200
     6.718   207.855     0.200
     6.718   208.453     0.200
     7.375   226.156     0.200
     7.822   240.254     0.200
     7.822   239.855     0.200
     8.434   259.855     0.200
     8.692   268.754     0.200
     8.847   273.254     0.200
     9.369   295.977     0.200
    10.173   311.902     0.200
    16.608   523.180     0.200
    17.713   552.906     0.200
    20.544   642.828     0.200
    20.913   662.230     0.200
    21.493   681.746     0.200
    21.525   680.465     0.200
     2.360    71.594     0.200
     3.222   100.195     0.200
     3.222   100.297     0.200
     3.445   104.996     0.200
     4.018   124.695     0.200
     3.936   122.094     0.200
     3.936   122.797     0.200
     4.049   125.996     0.200
     4.281   132.895     0.200
     4.281   131.594     0.200
     4.459   137.496     0.200
     5.420   167.594     0.200
     5.420   165.895     0.200
     5.732   177.395     0.200
     5.776   179.395     0.200
     5.971   186.195     0.200
     6.326   196.094     0.200
     6.418   198.594     0.200
     6.418   198.695     0.200
     6.709   206.996     0.200
     6.730   209.895     0.200
     7.387   227.297     0.200
     7.833   242.297     0.200
     8.448   262.195     0.200
     8.448   261.797     0.200
     8.702   269.395     0.200
     8.855   273.094     0.200
     9.387   292.773     0.200
    10.158   313.543     0.200
    12.893   400.945     0.200
    16.619   520.949     0.200
     2.373    71.496     0.200
     2.373    71.699     0.200
     3.447   105.797     0.200
     3.924   122.797     0.200
     4.028   125.898     0.200
     4.049   126.098     0.200
     4.292   133.598     0.200
     4.292   133.699     0.200
     4.446   137.098     0.200
     5.210   162.297     0.200
     5.430   166.699     0.200
     5.430   166.598     0.200
     5.742   178.496     0.200
     5.980   186.699     0.200
     6.226   192.797     0.200
     6.337   197.398     0.200
     6.420   199.199     0.200
     6.420   198.898     0.200
     6.719   207.598     0.200
     6.741   208.098     0.200
     6.741   207.898     0.200
     7.398   226.398     0.200
     7.845   242.996     0.200
     8.458   262.797     0.200
     8.714   270.098     0.200
     8.867   274.398     0.200
     9.394   295.719     0.200
    16.609   523.848     0.200
     2.378    71.836     0.200
     3.242   100.535     0.200
     3.242   100.836     0.200
     3.435   105.035     0.200
     3.925   123.133     0.200
     3.925   122.234     0.200
     4.039   126.836     0.200
     4.062   125.336     0.200
     4.062   126.934     0.200
     4.062   127.234     0.200
     4.302   133.836     0.200
     4.302   133.633     0.200
     4.440   137.836     0.200
     5.222   164.035     0.200
     5.441   167.734     0.200
     5.753   179.336     0.200
     5.797   179.133     0.200
     5.835   182.336     0.200
     5.992   187.734     0.200
     6.221   192.734     0.200
     6.348   196.234     0.200
     6.348   198.734     0.200
     6.433   201.734     0.200
     6.730   209.035     0.200
     6.751   207.734     0.200
     7.409   230.633     0.200
     7.854   239.234     0.200
     7.854   242.336     0.200
     8.469   263.035     0.200
     8.723   270.434     0.200
     8.875   274.535     0.200
     9.407   296.176     0.200
    12.173   375.336     0.200
    12.883   401.109     0.200
    20.509   642.859     0.200
    20.931   661.961     0.200
     3.236   101.164     0.200
     3.450   106.164     0.200
     4.033   125.961     0.200
     3.915   121.664     0.200
     3.915   121.562     0.200
     4.048   126.461     0.200
     4.299   133.664     0.200
     4.437   139.164     0.200
     5.217   161.562     0.200
     5.437   168.961     0.200
     5.748   179.164     0.200
     5.830   181.664     0.200
     5.985   186.461     0.200
     6.343   196.562     0.200
     6.217   193.164     0.200
     6.420   201.363     0.200
     6.726   209.363     0.200
     6.748   207.164     0.200
     6.748   210.262     0.200
     7.405   228.664     0.200
     7.405   228.863     0.200
     7.852   242.461     0.200
     8.465   262.762     0.200
     8.721   270.562     0.200
     8.876   273.461     0.200
    10.952   335.562     0.200
    11.122   344.062     0.200
     3.252   101.547     0.200
     3.252   101.348     0.200
     3.438   105.145     0.200
     3.912   121.945     0.200
     3.912   121.547     0.200
     4.063   125.848     0.200
     4.063   127.145     0.200
     4.049   125.848     0.200
     4.314   133.348     0.200
     4.426   137.645     0.200
     5.232   162.246     0.200
     5.452   168.945     0.200
     5.763   178.547     0.200
     5.808   180.047     0.200
     5.846   181.047     0.200
     6.002   186.746     0.200
     6.207   192.746     0.200
     6.359   196.645     0.200
     6.435   199.848     0.200
     6.763   209.445     0.200
     7.420   229.746     0.200
     7.420   227.645     0.200
     7.866   241.645     0.200
     7.866   243.547     0.200
     8.480   263.047     0.200
     8.735   269.848     0.200
     8.888   274.945     0.200
     9.414   297.125     0.200
    10.963   338.645     0.200
    11.136   345.348     0.200
    12.360   381.945     0.200
    12.871   403.996     0.200
    16.603   523.223     0.200
     3.256   100.922     0.200
     3.256   100.820     0.200
     3.425   104.922     0.200
     3.922   122.422     0.200
     3.922   122.320     0.200
     4.053   126.020     0.200
     4.074   127.621     0.200
     4.315   133.520     0.200
     4.315   132.219     0.200
     4.430   136.820     0.200
     5.235   161.820     0.200
     5.454   168.719     0.200
     5.454   166.020     0.200
     5.767   179.020     0.200
     5.849   181.121     0.200
     6.006   187.121     0.200
     6.212   191.621     0.200
     6.361   197.922     0.200
     6.446   200.422     0.200
     6.446   199.121     0.200
     6.743   209.219     0.200
     7.866   244.020     0.200
     8.483   263.320     0.200
     8.734   269.719     0.200
     8.886   275.621     0.200
    11.135   345.820     0.200
     3.219   100.738     0.200
     3.453   105.336     0.200
     3.929   122.637     0.200
     4.016   124.539     0.200
     4.041   126.039     0.200
     4.280   133.039     0.200
     4.280   131.539     0.200
     4.456   138.137     0.200
     5.199   162.938     0.200
     5.419   166.039     0.200
     5.419   168.836     0.200
     5.419   165.738     0.200
     5.730   177.938     0.200
     5.774   180.137     0.200
     5.813   181.438     0.200
     5.969   185.836     0.200
     6.235   193.738     0.200
     6.325   195.938     0.200
     6.411   199.336     0.200
     6.411   197.238     0.200
     6.708   207.539     0.200
     6.730   208.137     0.200
     7.387   229.336     0.200
     7.833   241.539     0.200
     8.447   262.137     0.200
     8.703   269.137     0.200
     8.857   275.039     0.200
     9.383   295.762     0.200
    10.160   313.449     0.200
    11.104   344.039     0.200
    12.886   403.727     0.200
     3.214    99.926     0.200
     3.459   107.426     0.200
     3.927   123.727     0.200
     4.012   126.328     0.200
     4.035   126.125     0.200
     4.277   133.125     0.200
     4.457   138.328     0.200
     5.415   166.527     0.200
     5.415   168.328     0.200
     5.964   186.328     0.200
     6.405   199.828     0.200
     7.383   228.227     0.200
     9.377   297.141     0.200
    12.884   404.348     0.200
     3.241   100.852     0.200
     3.434   105.055     0.200
     3.927   121.953     0.200
     4.038   125.152     0.200
     4.063   126.055     0.200
     4.300   133.754     0.200
     4.442   136.754     0.200
     5.220   162.652     0.200
     5.439   167.652     0.200
     5.991   186.852     0.200
     6.223   191.852     0.200
     6.346   197.152     0.200
     6.434   200.453     0.200
     7.407   228.652     0.200
     7.852   243.152     0.200
     8.468   261.852     0.200
     8.721   269.754     0.200
     8.873   273.754     0.200
    10.947   337.453     0.200
     3.403   104.559     0.200
     3.984   121.658     0.200
     3.984   125.959     0.200
     3.984   122.258     0.200
     4.015   125.758     0.200
     4.084   125.959     0.200
     4.084   126.258     0.200
     4.268   133.059     0.200
     4.268   132.857     0.200
     5.195   162.158     0.200
     5.410   166.959     0.200
     5.410   166.758     0.200
     5.728   179.857     0.200
     5.772   181.559     0.200
     5.970   187.059     0.200
     6.449   200.158     0.200
     6.699   208.459     0.200
     6.717   208.258     0.200
     6.717   208.658     0.200
     7.375   227.303     0.200
     7.375   225.158     0.200
     8.441   261.357     0.200
     8.684   269.158     0.200
     8.831   273.857     0.200
     9.398   292.959     0.200
    10.902   336.959     0.200
    12.942   401.908     0.200
     2.074    62.930     0.200
     2.670    82.633     0.200
     2.670    82.430     0.200
     3.446   106.828     0.200
     3.502   107.633     0.200
     3.502   108.930     0.200
     3.396   104.727     0.200
     3.552   110.828     0.200
     4.039   125.031     0.200
     4.080   126.633     0.200
     4.080   126.328     0.200
     4.428   136.930     0.200
     4.541   141.227     0.200
     4.734   146.531     0.200
     4.734   145.828     0.200
     4.708   144.633     0.200
     4.930   152.633     0.200
     5.316   163.328     0.200
     5.128   159.227     0.200
     5.625   173.727     0.200
     5.981   183.227     0.200
     5.981   183.727     0.200
     5.997   184.328     0.200
     6.225   192.430     0.200
     6.319   194.031     0.200
     6.650   203.227     0.200
     7.109   219.930     0.200
     7.101   220.227     0.200
     7.910   244.930     0.200
     8.024   248.930     0.200
     8.927   280.250     0.200
    10.835   330.125     0.200
    13.667   428.656     0.200
    15.795   493.930     0.200
    17.284   540.258     0.200
    20.664   646.883     0.200
    21.262   661.977     0.200
    21.379   676.461     0.200
     2.861    88.671     0.200
     2.861    88.171     0.200
     3.245   100.271     0.200
     3.608   112.071     0.200
     3.790   119.071     0.200
     3.790   116.871     0.200
     4.172   129.871     0.200
     4.110   127.171     0.200
     4.110   129.571     0.200
     4.252   131.571     0.200
     4.522   140.871     0.200
     4.522   139.972     0.200
     4.765   148.771     0.200
     4.944   151.871     0.200
     4.944   150.472     0.200
     5.061   156.472     0.200
     5.309   163.871     0.200
     5.349   166.171     0.200
     5.577   173.071     0.200
     6.225   192.271     0.200
     6.225   191.871     0.200
     6.233   193.871     0.200
     6.394   199.571     0.200
     6.464   199.271     0.200
     6.853   212.071     0.200
     6.892   211.972     0.200
     6.892   212.171     0.200
     7.306   226.071     0.200
     7.306   223.671     0.200
     7.991   246.771     0.200
     8.086   249.771     0.200
     8.162   252.871     0.200
     8.280   256.671     0.200
     8.914   276.371     0.200
     9.105   287.052     0.200
    13.468   419.347     0.200
    16.035   502.479     0.200
    17.073   534.840     0.200
    17.126   534.828     0.200
    17.361   537.275     0.200
    19.107   604.171     0.200
    20.050   634.611     0.200
    21.019   658.231     0.200
    21.296   672.171     0.200
    26.085   830.041     0.200
     2.595    80.336     0.200
     2.595    79.336     0.200
     2.560    79.434     0.200
     2.560    79.535     0.200
     3.174    98.535     0.200
     3.174    98.434     0.200
     3.483   107.336     0.200
     3.767   114.535     0.200
     3.639   114.434     0.200
     3.773   118.234     0.200
     3.773   117.633     0.200
     3.995   124.836     0.200
     4.316   133.035     0.200
     4.320   134.734     0.200
     5.189   161.836     0.200
     5.440   168.336     0.200
     5.708   177.234     0.200
     5.755   179.336     0.200
     6.070   188.336     0.200
     6.118   190.434     0.200
     6.166   191.336     0.200
     6.336   196.336     0.200
     6.724   207.934     0.200
     6.772   210.633     0.200
     6.968   215.836     0.200
     7.419   229.234     0.200
     7.895   244.133     0.200
     8.443   262.633     0.200
     8.776   271.336     0.200
     8.973   277.535     0.200
     9.258   289.590     0.200
     9.282   294.105     0.200
    10.205   310.688     0.200
    11.189   345.535     0.200
    12.297   378.934     0.200
    12.586   391.785     0.200
    16.278   508.867     0.200
    17.134   533.359     0.200
     3.081    95.688     0.200
     3.183    98.988     0.200
     3.815   118.289     0.200
     3.915   122.289     0.200
     3.920   122.289     0.200
     3.994   123.590     0.200
     3.994   126.590     0.200
     4.192   130.789     0.200
     4.192   131.289     0.200
     4.051   125.488     0.200
     4.353   134.789     0.200
     4.470   138.188     0.200
     4.504   140.090     0.200
     4.508   139.488     0.200
     4.769   148.188     0.200
     4.936   152.789     0.200
     5.115   158.891     0.200
     4.970   153.789     0.200
     5.281   163.688     0.200
     5.281   164.488     0.200
     5.304   164.289     0.200
     5.304   163.891     0.200
     5.336   164.090     0.200
     5.559   170.391     0.200
     5.992   185.090     0.200
     5.976   183.184     0.200
     5.976   184.289     0.200
     6.083   189.488     0.200
     6.369   196.090     0.200
     7.331   225.488     0.200
     7.789   241.289     0.200
     8.130   254.590     0.200
     8.408   263.160     0.200
    11.500   352.008     0.200
    14.161   440.309     0.200
    17.248   531.863     0.200
    17.651   553.703     0.200
    19.965   629.891     0.200
    21.943   685.516     0.200
     2.450    76.072     0.200
     2.582    80.472     0.200
     3.401   105.472     0.200
     3.363   104.272     0.200
     3.456   105.072     0.200
     3.745   116.172     0.200
     4.094   128.172     0.200
     4.094   127.772     0.200
     4.207   131.372     0.200
     4.235   130.872     0.200
     4.488   138.672     0.200
     4.488   138.272     0.200
     4.599   143.572     0.200
     4.615   142.672     0.200
     4.848   150.072     0.200
     5.394   167.772     0.200
     5.622   173.872     0.200
     5.687   176.772     0.200
     5.921   184.072     0.200
     5.967   185.472     0.200
     6.031   187.472     0.200
     6.153   191.872     0.200
     6.526   202.472     0.200
     6.486   201.772     0.200
     6.910   214.372     0.200
     6.938   214.872     0.200
     7.150   221.872     0.200
     7.388   231.172     0.200
     7.594   235.372     0.200
     7.648   237.972     0.200
     8.645   267.672     0.200
     8.645   267.372     0.200
     8.917   276.172     0.200
     9.076   278.872     0.200
     9.534   296.653     0.200
     9.973   303.016     0.200
    12.707   397.240     0.200
    16.466   514.347     0.200
    16.821   519.366     0.200
    16.868   524.289     0.200
    17.781   547.622     0.200
    20.839   658.022     0.200
    21.351   676.819     0.200
     3.763   117.773     0.200
     3.800   118.273     0.200
     3.865   119.969     0.200
     3.865   120.273     0.200
     3.992   125.469     0.200
     3.992   125.172     0.200
     4.076   125.070     0.200
     4.076   126.469     0.200
     4.203   130.273     0.200
     4.442   138.172     0.200
     4.620   143.867     0.200
     4.985   155.172     0.200
     5.211   159.867     0.200
     5.211   161.367     0.200
     5.287   164.469     0.200
     5.514   170.570     0.200
     5.559   172.570     0.200
     5.599   173.367     0.200
     5.750   179.070     0.200
     6.015   186.570     0.200
     6.115   189.172     0.200
     6.220   192.469     0.200
     6.220   193.773     0.200
     6.420   199.570     0.200
     6.499   201.570     0.200
     6.527   201.672     0.200
     6.527   201.867     0.200
     6.738   207.867     0.200
     7.182   220.312     0.200
     7.182   222.273     0.200
     7.388   231.492     0.200
     7.641   236.867     0.200
     7.636   236.773     0.200
     8.234   254.773     0.200
     8.509   262.969     0.200
     8.678   269.172     0.200
     8.950   277.570     0.200
     9.164   287.312     0.200
    10.767   332.070     0.200
    16.539   516.375     0.200
    17.128   533.289     0.200
    20.847   658.000     0.200
    21.014   666.398     0.200
    21.335   670.500     0.200
     2.989    92.271     0.200
     3.788   117.871     0.200
     3.786   118.371     0.200
     3.879   120.271     0.200
     4.027   125.371     0.200
     4.027   125.871     0.200
     4.056   124.871     0.200
     4.178   130.271     0.200
     4.186   128.871     0.200
     4.428   138.072     0.200
     4.648   144.672     0.200
     5.192   160.172     0.200
     5.192   159.971     0.200
     5.276   164.172     0.200
     5.500   169.672     0.200
     5.544   172.572     0.200
     5.738   178.672     0.200
     6.098   188.172     0.200
     6.231   194.871     0.200
     6.231   194.271     0.200
     6.448   200.072     0.200
     6.481   199.371     0.200
     6.506   200.271     0.200
     6.720   207.072     0.200
     7.162   219.678     0.200
     7.162   220.871     0.200
     7.417   232.398     0.200
     7.614   234.871     0.200
     8.218   255.172     0.200
     8.486   262.572     0.200
     8.947   278.072     0.200
     9.159   285.186     0.200
    10.390   317.840     0.200
    10.739   331.971     0.200
    12.971   402.432     0.200
    20.877   660.078     0.200
    21.015   666.473     0.200
    21.306   674.547     0.200
    21.367   671.471     0.200
     3.104    96.298     0.200
     2.982    92.298     0.200
     2.982    92.798     0.200
     4.031   124.898     0.200
     3.929   120.898     0.200
     3.929   121.099     0.200
     4.153   128.498     0.200
     4.153   128.599     0.200
     4.419   136.498     0.200
     4.419   136.099     0.200
     4.924   152.398     0.200
     4.898   152.198     0.200
     5.082   156.398     0.200
     5.082   156.599     0.200
     5.260   162.698     0.200
     5.482   169.898     0.200
     5.706   177.498     0.200
     5.996   186.298     0.200
     6.366   196.698     0.200
     6.371   197.099     0.200
     6.715   207.998     0.200
     6.602   203.198     0.200
     7.448   230.998     0.200
     8.128   252.498     0.200
     8.304   258.099     0.200
     8.422   261.599     0.200
     9.023   280.698     0.200
     9.218   288.938     0.200
    13.372   416.642     0.200
    16.160   501.599     0.200
    16.977   528.341     0.200
    17.057   535.423     0.200
    17.375   533.773     0.200
    21.044   664.148     0.200
     2.910    89.793     0.200
     2.966    93.093     0.200
     3.806   118.393     0.200
     3.820   118.593     0.200
     3.761   117.992     0.200
     4.058   125.793     0.200
     4.058   124.492     0.200
     4.028   124.992     0.200
     4.028   125.093     0.200
     4.159   128.793     0.200
     4.681   144.692     0.200
     4.944   153.293     0.200
     5.165   159.492     0.200
     5.165   159.192     0.200
     5.254   164.293     0.200
     5.519   172.393     0.200
     5.715   178.492     0.200
     6.071   187.893     0.200
     6.228   193.093     0.200
     6.228   192.893     0.200
     6.454   199.393     0.200
     6.478   200.293     0.200
     6.478   200.893     0.200
     6.692   206.893     0.200
     7.134   217.836     0.200
     7.436   233.018     0.200
     8.192   255.192     0.200
     8.455   261.593     0.200
     8.620   267.393     0.200
     8.931   277.893     0.200
     9.142   287.192     0.200
    10.415   316.860     0.200
    13.002   403.910     0.200
    16.473   516.093     0.200
    17.133   534.485     0.200
    20.124   623.686     0.200
    21.002   665.992     0.200
    21.274   669.293     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     2.141    63.789     0.200
     0.478    15.404     0.200
     0.325    12.211     0.200
     1.302    40.609     0.200
     1.296    40.609     0.200
     3.068    90.109     0.200
     6.645   191.312     0.200
     1.218    39.570     0.200
     1.512    47.070     0.200
     2.205    69.371     0.200
     2.450    74.672     0.200
     2.679    84.473     0.200
     3.135    91.973     0.200
     4.132   125.672     0.200
     3.949   118.315     0.200
     2.477    74.840     0.200
     0.552    17.984     0.200
     0.545    17.781     0.200
     0.545    17.578     0.200
     0.783    24.883     0.200
     0.981    30.883     0.200
     0.989    30.680     0.200
     1.005    32.484     0.200
     1.017    31.883     0.200
     1.017    33.781     0.200
     1.297    40.984     0.200
     1.419    44.781     0.200
     1.419    44.180     0.200
     2.246    68.781     0.200
     2.285    72.281     0.200
     6.501   193.232     0.200
     1.926    59.898     0.200
     6.965   205.898     0.200
     0.202     9.297     0.200
     0.397    14.297     0.200
     0.541    17.898     0.200
     0.465    16.500     0.200
     0.592    19.500     0.200
     0.737    24.000     0.200
     0.743    24.615     0.200
     0.750    24.615     0.200
     2.298    71.916     0.200
     0.192     8.353     0.200
     0.558    19.252     0.200
     1.113    35.152     0.200
     0.127     3.922     0.200
     0.374    11.523     0.200
     0.899    28.422     0.200
     1.150    37.320     0.200
     1.150    36.922     0.200
     1.206    38.422     0.200
     2.165    67.117     0.200
     2.216    70.617     0.200
     2.218    69.820     0.200
     2.591    81.320     0.200
     0.026     4.219     0.200
     0.389    13.117     0.200
     0.910    29.617     0.200
     1.227    39.516     0.200
     1.288    40.914     0.200
     1.294    41.820     0.200
     1.294    40.617     0.200
     2.104    63.414     0.200
     0.150     7.082     0.200
     0.625    20.480     0.200
     1.177    37.480     0.200
     1.490    45.781     0.200
     1.724    52.980     0.200
     1.952    60.480     0.200
     2.432    74.879     0.200
     2.432    75.480     0.200
     0.167     8.461     0.200
     0.654    21.160     0.200
     0.862    27.160     0.200
     1.179    36.660     0.200
     1.719    53.160     0.200
     0.221     9.632     0.200
     0.163     7.231     0.200
     1.168    37.731     0.200
     1.135    36.632     0.200
     2.261    67.831     0.200
     0.222     9.318     0.200
     0.222     9.018     0.200
     0.416    15.318     0.200
     1.368    42.018     0.200
     1.368    42.617     0.200
     1.025    33.318     0.200
     1.025    33.117     0.200
     1.946    58.918     0.200
     0.115     5.240     0.200
     0.162     5.340     0.200
     0.558    18.441     0.200
     1.256    39.941     0.200
     1.355    43.041     0.200
     1.820    55.941     0.200
     1.820    56.441     0.200
     2.199    69.240     0.200
     0.175     7.188     0.200
     0.175     7.387     0.200
     0.483    16.789     0.200
     1.100    34.988     0.200
     1.100    35.387     0.200
     1.305    40.789     0.200
     1.305    40.988     0.200
     1.518    47.887     0.200
     2.206    66.789     0.200
     2.226    69.789     0.200
     0.046     3.700     0.200
     0.422    14.601     0.200
     0.422    14.801     0.200
     0.960    31.700     0.200
     0.982    31.700     0.200
     1.216    39.101     0.200
     1.216    38.900     0.200
     1.324    42.101     0.200
     1.324    42.501     0.200
     2.072    62.801     0.200
     2.201    68.601     0.200
     0.172     7.699     0.200
     0.216     8.098     0.200
     1.073    34.297     0.200
     1.073    33.398     0.200
     1.201    39.699     0.200
     1.217    38.898     0.200
     1.369    43.699     0.200
     1.369    42.398     0.200
     0.144     6.180     0.200
     0.261     9.777     0.200
     1.024    32.879     0.200
     1.147    36.680     0.200
     1.267    40.777     0.200
     1.415    44.480     0.200
     2.334    70.777     0.200
     2.334    71.277     0.200
     2.499    75.277     0.200
     0.178     7.195     0.200
     0.178     6.992     0.200
     0.236     8.695     0.200
     1.044    32.992     0.200
     1.044    33.391     0.200
     1.180    37.695     0.200
     1.414    44.391     0.200
     2.301    68.391     0.200
     2.301    68.992     0.200
     0.176     7.762     0.200
     0.224     9.262     0.200
     1.059    34.164     0.200
     1.170    37.262     0.200
     1.170    37.562     0.200
     1.217    39.965     0.200
     1.234    39.664     0.200
     1.393    43.965     0.200
     0.170     6.855     0.200
     0.170     6.654     0.200
     0.251     8.955     0.200
     0.251     8.754     0.200
     1.029    32.955     0.200
     1.175    38.455     0.200
     1.266    40.355     0.200
     1.426    45.855     0.200
     1.426    45.455     0.200
     2.313    70.555     0.200
     2.494    77.555     0.200
     2.494    77.955     0.200
     2.509    78.654     0.200
     2.509    79.154     0.200
     0.176     8.012     0.200
     0.215     8.912     0.200
     0.215     8.611     0.200
     1.071    34.412     0.200
     1.071    34.012     0.200
     1.160    37.412     0.200
     1.219    39.811     0.200
     1.374    43.311     0.200
     0.166     7.133     0.200
     0.248     9.227     0.200
     0.248     9.031     0.200
     1.033    33.430     0.200
     1.033    33.727     0.200
     1.170    36.633     0.200
     1.170    36.133     0.200
     1.261    40.031     0.200
     1.420    43.828     0.200
     1.420    44.430     0.200
     0.223     8.992     0.200
     0.223     8.891     0.200
     0.174     7.188     0.200
     1.061    33.992     0.200
     1.166    37.289     0.200
     1.166    37.688     0.200
     1.389    42.992     0.200
     1.389    44.094     0.200
     0.160     6.445     0.200
     0.160     6.246     0.200
     0.274     9.645     0.200
     1.171    38.047     0.200
     1.171    37.945     0.200
     1.290    41.848     0.200
     1.290    41.645     0.200
     1.447    45.746     0.200
     1.447    45.945     0.200
     2.330    70.945     0.200
     2.499    78.848     0.200
     2.499    78.445     0.200
     2.518    79.246     0.200
     0.175     7.070     0.200
     0.175     7.172     0.200
     0.212     7.875     0.200
     0.212     8.375     0.200
     1.152    36.875     0.200
     1.152    36.273     0.200
     1.361    43.273     0.200
     1.361    43.375     0.200
     2.300    69.773     0.200
     0.160     7.574     0.200
     1.292    40.676     0.200
     1.292    40.477     0.200
     1.436    45.273     0.200
     2.305    70.273     0.200
     2.305    70.676     0.200
     0.409    14.651     0.200
     0.409    14.752     0.200
     0.221     8.151     0.200
     0.221     8.752     0.200
     1.141    36.552     0.200
     1.141    36.052     0.200
     1.628    50.651     0.200
     2.126    65.052     0.200
     2.299    71.651     0.200
     4.056   122.852     0.200
     0.171     7.344     0.200
     0.171     7.039     0.200
     0.561    18.344     0.200
     1.184    37.445     0.200
     1.184    37.945     0.200
     1.485    46.039     0.200
     1.790    54.539     0.200
     1.913    59.945     0.200
     1.913    59.445     0.200
     2.428    75.641     0.200
     0.166     6.871     0.200
     0.229     9.172     0.200
     1.157    37.473     0.200
     1.157    37.070     0.200
     1.387    44.473     0.200
     2.309    70.371     0.200
     0.140     5.324     0.200
     1.380    43.922     0.200
     1.539    47.922     0.200
     1.539    47.723     0.200
     1.571    49.625     0.200
     1.571    49.223     0.200
     1.569    49.422     0.200
     2.428    74.922     0.200
     2.459    75.324     0.200
     0.040     4.406     0.200
     0.373    12.109     0.200
     1.062    34.609     0.200
     1.062    34.008     0.200
     1.312    42.906     0.200
     1.312    42.508     0.200
     1.293    41.809     0.200
     1.293    41.609     0.200
     2.105    65.008     0.200
     2.276    71.707     0.200
     0.131     5.398     0.200
     0.131     5.297     0.200
     0.314    11.695     0.200
     1.144    37.297     0.200
     1.144    36.297     0.200
     1.324    43.000     0.200
     1.469    47.000     0.200
     1.469    46.898     0.200
     2.465    77.797     0.200
     2.465    75.398     0.200
     2.555    80.000     0.200
     0.193     6.513     0.200
     0.822    26.713     0.200
     0.822    27.113     0.200
     1.055    34.213     0.200
     1.055    34.513     0.200
     1.402    44.613     0.200
     1.989    62.313     0.200
     1.989    63.313     0.200
     1.989    62.813     0.200
     2.332    72.813     0.200
     2.332    73.013     0.200
     2.656    83.613     0.200
     0.020     5.449     0.200
     0.644    21.551     0.200
     1.273    39.648     0.200
     1.273    39.852     0.200
     1.449    44.148     0.200
     1.449    44.250     0.200
     0.564    17.875     0.200
     0.774    24.973     0.200
     0.774    25.074     0.200
     0.774    24.574     0.200
     0.774    25.473     0.200
     1.795    55.172     0.200
     1.895    59.273     0.200
     2.267    70.773     0.200
     2.267    71.574     0.200
     2.226    71.074     0.200
     6.409   190.172     0.200
     0.164     8.195     0.200
     0.223     8.492     0.200
     1.173    38.094     0.200
     1.190    38.391     0.200
     2.252    68.492     0.200
     0.151     6.469     0.200
     0.241     8.367     0.200
     0.241     9.367     0.200
     1.142    36.969     0.200
     1.142    36.867     0.200
     1.241    40.773     0.200
     1.387    44.172     0.200
     1.387    44.070     0.200
     2.324    71.273     0.200
     0.086     4.012     0.200
     0.557    18.412     0.200
     1.079    34.713     0.200
     1.382    43.912     0.200
     1.790    55.512     0.200
     1.835    56.912     0.200
     2.325    73.613     0.200
     2.325    72.012     0.200
     2.706    84.713     0.200
     0.400    15.389     0.200
     1.026    32.590     0.200
     1.026    32.488     0.200
     1.669    52.889     0.200
     1.963    58.689     0.200
     1.963    58.289     0.200
     5.570   163.189     0.200
     6.538   189.789     0.200
     0.113     3.606     0.200
     0.113     3.406     0.200
     0.744    25.306     0.200
     1.024    33.206     0.200
     1.360    43.706     0.200
     1.360    44.906     0.200
     1.228    39.506     0.200
     1.228    40.006     0.200
     1.613    50.006     0.200
     1.918    59.906     0.200
     1.918    60.906     0.200
     1.918    62.106     0.200
     2.698    84.506     0.200
     2.698    85.106     0.200
     6.308   188.206     0.200
     0.484    16.609     0.200
     0.530    18.211     0.200
     0.530    17.812     0.200
     0.796    26.914     0.200
     0.796    27.109     0.200
     0.993    32.312     0.200
     0.993    32.211     0.200
     1.406    44.016     0.200
     1.406    43.914     0.200
     1.877    57.516     0.200
     1.877    59.516     0.200
     1.877    57.414     0.200
     3.881   117.312     0.200
     6.929   203.812     0.200
     0.021     6.823     0.200
     0.384    13.323     0.200
     0.384    13.823     0.200
     1.015    32.724     0.200
     1.234    39.224     0.200
     1.234    39.423     0.200
     1.288    41.224     0.200
     0.112     3.555     0.200
     0.112     3.254     0.200
     0.741    24.555     0.200
     1.045    34.055     0.200
     1.045    34.156     0.200
     1.208    39.055     0.200
     1.380    44.555     0.200
     1.931    61.055     0.200
     1.931    60.855     0.200
     2.316    74.055     0.200
     2.316    73.953     0.200
     2.679    84.656     0.200
     2.679    84.555     0.200
     0.079     6.480     0.200
     0.079     6.082     0.200
     0.552    19.383     0.200
     0.552    17.883     0.200
     1.044    33.383     0.200
     1.044    33.281     0.200
     1.346    41.781     0.200
     1.346    41.883     0.200
     1.269    39.383     0.200
     1.803    57.180     0.200
     1.803    55.082     0.200
     1.803    56.281     0.200
     2.289    68.781     0.200
     0.258     9.039     0.200
     0.581    19.340     0.200
     0.581    18.238     0.200
     1.060    35.141     0.200
     1.060    33.738     0.200
     1.577    49.441     0.200
     1.577    51.641     0.200
     1.793    55.238     0.200
     1.985    63.340     0.200
     1.985    63.441     0.200
     2.520    79.641     0.200
     2.528    79.441     0.200
     3.506   106.641     0.200
     0.110     3.641     0.200
     1.041    32.742     0.200
     1.041    34.539     0.200
     1.377    43.641     0.200
     1.377    44.438     0.200
     1.212    39.539     0.200
     1.614    50.438     0.200
     1.928    61.141     0.200
     2.312    73.141     0.200
     2.683    84.539     0.200
     2.683    84.039     0.200
     7.419   218.938     0.200
     0.242    10.223     0.200
     0.605    19.824     0.200
     0.790    25.121     0.200
     1.077    35.023     0.200
     1.077    34.621     0.200
     1.520    47.922     0.200
     1.520    47.523     0.200
     1.939    58.422     0.200
     2.004    62.223     0.200
     2.004    61.523     0.200
     0.151     7.395     0.200
     0.498    17.395     0.200
     0.498    16.895     0.200
     1.112    35.195     0.200
     1.112    35.594     0.200
     1.234    39.395     0.200
     1.234    38.895     0.200
     1.403    43.793     0.200
     1.403    43.094     0.200
     1.819    57.293     0.200
     1.819    55.594     0.200
     1.819    56.793     0.200
     1.847    56.395     0.200
     0.269    10.039     0.200
     0.772    25.344     0.200
     0.772    25.039     0.200
     0.994    32.539     0.200
     0.994    31.844     0.200
     1.515    47.844     0.200
     2.028    61.539     0.200
     2.010    61.445     0.200
     0.174     8.766     0.200
     0.174     8.168     0.200
     0.458    16.367     0.200
     0.458    16.668     0.200
     1.044    32.969     0.200
     1.044    33.168     0.200
     1.325    40.469     0.200
     1.321    41.668     0.200
     1.733    53.969     0.200
     1.733    53.766     0.200
     1.897    57.066     0.200
     1.897    56.867     0.200
     0.108     7.738     0.200
     0.469    16.039     0.200
     0.920    29.639     0.200
     2.045    61.539     0.200
     2.045    60.938     0.200
     0.190     6.308     0.200
     0.190     6.208     0.200
     0.516    17.808     0.200
     0.825    27.407     0.200
     0.960    30.907     0.200
     1.375    44.607     0.200
     1.375    44.208     0.200
     2.167    68.007     0.200
     2.616    80.808     0.200
     2.616    79.907     0.200
     2.627    82.708     0.200
     2.840    89.507     0.200
     2.950    91.907     0.200
     2.950    92.507     0.200
     0.191     6.326     0.200
     0.514    17.727     0.200
     0.825    27.826     0.200
     0.825    27.026     0.200
     0.965    30.926     0.200
     0.965    30.626     0.200
     1.371    46.326     0.200
     1.370    44.326     0.200
     2.167    68.026     0.200
     2.167    67.126     0.200
     2.615    80.526     0.200
     2.624    82.626     0.200
     2.841    90.026     0.200
     2.953    92.227     0.200
     2.953    92.626     0.200
     0.212     8.594     0.200
     0.567    18.398     0.200
     0.816    26.797     0.200
     1.081    35.094     0.200
     1.376    44.398     0.200
     1.979    60.000     0.200
     2.037    64.000     0.200
     0.223     7.692     0.200
     0.608    19.393     0.200
     1.067    34.993     0.200
     1.247    39.692     0.200
     1.554    49.393     0.200
     1.756    55.393     0.200
     1.985    62.893     0.200
     2.497    78.292     0.200
     2.538    80.692     0.200
     6.073   179.792     0.200
     6.120   181.393     0.200
     7.065   213.792     0.200
     0.210     7.582     0.200
     0.210     6.980     0.200
     0.576    18.980     0.200
     1.098    35.082     0.200
     1.228    38.980     0.200
     1.228    39.781     0.200
     1.531    47.980     0.200
     1.531    47.781     0.200
     1.952    61.980     0.200
     1.783    55.082     0.200
     2.474    77.383     0.200
     2.568    80.582     0.200
     2.568    79.883     0.200
     6.146   182.480     0.200
     8.528   250.281     0.200
     0.208     7.789     0.200
     0.585    18.992     0.200
     1.093    35.094     0.200
     1.228    38.891     0.200
     1.532    48.094     0.200
     1.774    55.188     0.200
     1.959    61.992     0.200
     2.475    76.594     0.200
     2.475    78.688     0.200
     2.563    80.789     0.200
     7.932   235.492     0.200
     8.534   253.594     0.200
     0.226     8.016     0.200
     0.226     7.719     0.200
     0.581    19.117     0.200
     0.581    19.320     0.200
     1.083    35.117     0.200
     1.083    34.914     0.200
     1.244    39.414     0.200
     1.547    48.516     0.200
     1.783    55.414     0.200
     1.966    62.117     0.200
     1.966    61.320     0.200
     2.553    81.219     0.200
     2.553    79.016     0.200
     7.942   235.617     0.200
     0.214     7.625     0.200
     0.603    19.422     0.200
     1.077    35.023     0.200
     1.238    39.922     0.200
     1.545    49.023     0.200
     1.545    48.922     0.200
     1.758    55.125     0.200
     1.758    55.422     0.200
     1.976    62.422     0.200
     1.976    61.820     0.200
     2.487    78.422     0.200
     2.487    78.023     0.200
     2.548    80.820     0.200
     2.548    80.320     0.200
     4.059   122.023     0.200
     5.528   168.023     0.200
     0.213     7.422     0.200
     0.213     7.117     0.200
     0.603    19.719     0.200
     1.078    35.016     0.200
     1.078    34.422     0.200
     1.237    39.617     0.200
     1.237    39.820     0.200
     1.543    48.320     0.200
     1.543    49.016     0.200
     1.758    55.016     0.200
     1.976    62.516     0.200
     2.486    78.422     0.200
     2.549    80.617     0.200
     2.549    80.016     0.200
     3.462   105.422     0.200
     5.527   167.117     0.200
     6.130   184.219     0.200
     0.212     7.594     0.200
     0.594    18.691     0.200
     1.085    34.895     0.200
     1.234    39.191     0.200
     1.539    48.293     0.200
     1.767    55.293     0.200
     1.967    61.793     0.200
     2.482    75.895     0.200
     2.482    78.395     0.200
     2.555    80.492     0.200
     7.941   236.191     0.200
     0.245     8.191     0.200
     0.245     8.391     0.200
     0.608    19.590     0.200
     0.608    19.891     0.200
     1.051    34.590     0.200
     1.269    40.293     0.200
     1.575    49.891     0.200
     1.575    49.992     0.200
     1.998    62.590     0.200
     2.521    79.691     0.200
     2.521    79.391     0.200
     2.517    78.590     0.200
     2.517    78.891     0.200
     6.084   179.590     0.200
     0.266     8.777     0.200
     0.266     8.078     0.200
     0.618    19.977     0.200
     1.030    33.676     0.200
     1.030    33.477     0.200
     1.597    50.977     0.200
     2.018    63.875     0.200
     2.018    63.176     0.200
     1.761    54.875     0.200
     2.540    78.676     0.200
     2.540    79.578     0.200
     2.499    79.477     0.200
     2.499    78.277     0.200
     7.099   212.777     0.200
     0.230     8.028     0.200
     0.603    19.429     0.200
     1.559    49.729     0.200
     1.763    55.929     0.200
     1.985    62.829     0.200
     2.502    78.729     0.200
     2.502    78.429     0.200
     2.536    80.329     0.200
     2.536    80.129     0.200
     6.442   191.729     0.200
     7.508   227.211     0.200
     0.105     4.352     0.200
     0.583    18.852     0.200
     1.123    35.750     0.200
     1.182    38.047     0.200
     1.430    45.352     0.200
     1.762    54.453     0.200
     1.886    59.250     0.200
     1.886    60.250     0.200
     2.373    74.352     0.200
     6.242   184.852     0.200
     0.222     7.961     0.200
     0.222     8.363     0.200
     0.587    18.961     0.200
     1.081    34.363     0.200
     1.081    34.562     0.200
     1.243    39.762     0.200
     1.243    39.863     0.200
     1.546    49.062     0.200
     1.776    54.660     0.200
     1.969    61.863     0.200
     1.969    61.363     0.200
     2.489    77.363     0.200
     2.489    78.160     0.200
     2.551    80.562     0.200
     2.551    80.062     0.200
     3.304   100.160     0.200
     4.042   121.863     0.200
     5.521   165.762     0.200
     6.130   181.262     0.200
     7.049   208.762     0.200
     0.516    17.043     0.200
     0.830    26.343     0.200
     0.796    26.144     0.200
     1.770    55.843     0.200
     1.760    55.644     0.200
     7.990   235.644     0.200
     0.222     8.027     0.200
     0.222     7.828     0.200
     0.576    19.027     0.200
     1.089    35.828     0.200
     1.089    35.430     0.200
     1.541    48.328     0.200
     1.786    55.328     0.200
     1.960    61.930     0.200
     1.960    61.730     0.200
     2.484    78.129     0.200
     2.559    81.629     0.200
     2.559    80.430     0.200
     4.031   121.230     0.200
     5.899   176.930     0.200
     0.159     6.180     0.200
     0.753    25.379     0.200
     0.753    25.277     0.200
     1.577    49.277     0.200
     1.617    50.980     0.200
     1.530    48.078     0.200
     2.469    75.879     0.200
     2.445    74.879     0.200
     2.445    74.980     0.200
     5.567   164.277     0.200
     0.119     6.498     0.200
     0.119     6.297     0.200
     0.516    17.197     0.200
     0.516    17.396     0.200
     1.074    33.098     0.200
     1.259    39.697     0.200
     1.259    40.197     0.200
     1.369    41.998     0.200
     1.802    56.396     0.200
     1.802    55.697     0.200
     1.802    56.797     0.200
     2.312    72.297     0.200
     5.352   160.396     0.200
     6.310   185.697     0.200
     0.269    10.277     0.200
     0.269     9.875     0.200
     0.986    32.277     0.200
     0.986    32.074     0.200
     0.768    25.176     0.200
     0.768    26.176     0.200
     1.598    48.574     0.200
     1.605    49.375     0.200
     2.104    65.277     0.200
     2.104    65.676     0.200
     7.176   214.676     0.200
     0.220     7.750     0.200
     0.220     7.648     0.200
     0.573    18.852     0.200
     1.093    36.055     0.200
     1.093    35.555     0.200
     1.538    50.250     0.200
     1.956    62.250     0.200
     1.956    62.352     0.200
     2.481    77.555     0.200
     2.562    81.453     0.200
     0.227     8.413     0.200
     0.756    25.013     0.200
     1.030    32.613     0.200
     1.229    38.013     0.200
     1.599    48.713     0.200
     2.068    65.113     0.200
     6.011   181.913     0.200
     6.106   179.813     0.200
     7.577   223.113     0.200
     0.212     7.742     0.200
     0.565    18.641     0.200
     1.105    35.641     0.200
     1.527    48.438     0.200
     1.794    55.844     0.200
     1.943    61.742     0.200
     2.470    77.938     0.200
     2.575    81.141     0.200
     5.797   171.438     0.200
     6.151   183.539     0.200
     0.458    14.875     0.200
     0.614    20.375     0.200
     0.688    23.176     0.200
     1.148    36.977     0.200
     1.148    37.078     0.200
     1.219    39.176     0.200
     1.343    44.277     0.200
     1.343    44.578     0.200
     2.002    62.777     0.200
     2.585    80.277     0.200
     2.744    84.578     0.200
     2.744    84.176     0.200
     2.907    90.176     0.200
     2.907    91.875     0.200
     0.224     8.102     0.200
     0.224     7.602     0.200
     0.576    19.202     0.200
     1.088    36.202     0.200
     1.241    39.502     0.200
     1.543    48.802     0.200
     1.787    55.702     0.200
     1.787    56.602     0.200
     1.961    61.902     0.200
     2.486    78.202     0.200
     2.557    81.502     0.200
     2.557    81.302     0.200
     0.223     7.680     0.200
     0.617    20.180     0.200
     0.617    19.586     0.200
     1.062    34.781     0.200
     1.062    34.883     0.200
     1.248    39.484     0.200
     1.248    40.383     0.200
     1.557    49.180     0.200
     1.747    54.383     0.200
     1.747    55.086     0.200
     1.992    62.383     0.200
     1.992    64.180     0.200
     2.533    79.781     0.200
     2.533    80.086     0.200
     2.500    76.586     0.200
     0.111     3.656     0.200
     0.111     4.754     0.200
     1.112    36.355     0.200
     1.205    38.254     0.200
     1.414    44.855     0.200
     1.414    45.453     0.200
     1.791    54.953     0.200
     1.858    58.656     0.200
     1.858    57.855     0.200
     2.357    73.855     0.200
     2.357    73.555     0.200
     2.677    84.156     0.200
     0.099     3.996     0.200
     0.099     3.895     0.200
     0.575    18.297     0.200
     1.196    38.094     0.200
     1.417    44.395     0.200
     1.417    44.695     0.200
     1.771    54.695     0.200
     1.872    59.094     0.200
     2.360    73.895     0.200
     2.669    83.297     0.200
     2.669    82.594     0.200
     0.109     3.996     0.200
     0.109     4.898     0.200
     0.576    18.996     0.200
     0.576    19.098     0.200
     1.124    35.699     0.200
     1.124    36.598     0.200
     1.184    38.598     0.200
     1.430    45.898     0.200
     1.770    55.098     0.200
     1.882    58.199     0.200
     2.373    74.199     0.200
     2.657    83.699     0.200
     2.657    83.398     0.200
     3.230   100.699     0.200
     6.337   190.098     0.200
     0.107     4.633     0.200
     0.107     3.836     0.200
     0.589    18.934     0.200
     0.589    18.734     0.200
     1.127    35.633     0.200
     1.127    37.234     0.200
     1.176    38.234     0.200
     1.176    37.535     0.200
     1.435    46.133     0.200
     1.756    54.633     0.200
     1.893    59.734     0.200
     2.378    73.934     0.200
     2.378    75.234     0.200
     2.649    83.836     0.200
     0.118     4.062     0.200
     0.118     4.762     0.200
     0.575    18.961     0.200
     1.133    38.363     0.200
     1.176    38.062     0.200
     1.439    45.762     0.200
     1.439    45.562     0.200
     1.888    59.461     0.200
     1.888    59.262     0.200
     1.770    55.262     0.200
     2.382    74.562     0.200
     2.649    84.062     0.200
     0.120     4.848     0.200
     0.120     4.547     0.200
     0.591    18.945     0.200
     0.591    19.848     0.200
     1.163    37.145     0.200
     1.141    36.445     0.200
     1.141    36.547     0.200
     1.449    45.645     0.200
     1.755    54.547     0.200
     1.904    59.547     0.200
     2.392    75.047     0.200
     2.636    82.547     0.200
     2.636    82.746     0.200
     0.110     4.020     0.200
     1.134    36.320     0.200
     1.164    38.121     0.200
     1.444    46.219     0.200
     1.444    45.621     0.200
     1.744    54.320     0.200
     1.906    59.520     0.200
     1.906    60.719     0.200
     2.387    74.621     0.200
     2.637    82.820     0.200
     2.637    82.121     0.200
     0.106     4.738     0.200
     0.567    18.438     0.200
     1.116    35.637     0.200
     1.195    38.438     0.200
     1.195    38.539     0.200
     1.421    44.738     0.200
     1.778    54.738     0.200
     1.870    57.938     0.200
     2.364    73.836     0.200
     2.667    83.738     0.200
     2.667    84.137     0.200
     0.110     4.125     0.200
     0.561    18.625     0.200
     1.198    40.125     0.200
     1.866    58.027     0.200
     2.363    73.625     0.200
     2.363    74.625     0.200
     2.670    84.125     0.200
     0.104     4.555     0.200
     0.590    18.754     0.200
     1.178    37.652     0.200
     1.433    44.754     0.200
     1.756    54.254     0.200
     1.891    59.254     0.200
     2.376    73.254     0.200
     2.651    82.953     0.200
     0.048     2.758     0.200
     0.609    18.758     0.200
     0.609    19.459     0.200
     1.072    35.158     0.200
     1.218    38.658     0.200
     1.385    44.357     0.200
     1.385    44.158     0.200
     1.739    54.857     0.200
     1.865    58.059     0.200
     2.327    73.857     0.200
     2.327    73.959     0.200
     3.223   100.357     0.200
     3.223   100.658     0.200
     4.489   135.658     0.200
     0.277    10.531     0.200
     0.277    10.031     0.200
     0.557    18.633     0.200
     0.788    25.633     0.200
     0.788    25.430     0.200
     0.977    30.633     0.200
     2.032    62.531     0.200
     2.032    63.328     0.200
     4.708   142.133     0.200
     0.496    17.571     0.200
     0.496    16.671     0.200
     0.536    17.571     0.200
     0.536    18.171     0.200
     0.814    26.671     0.200
     0.814    27.371     0.200
     0.831    26.371     0.200
     1.752    55.171     0.200
     1.775    55.571     0.200
     1.900    57.571     0.200
     0.449    15.133     0.200
     0.381    13.234     0.200
     1.162    36.934     0.200
     1.162    37.234     0.200
     1.369    43.336     0.200
     1.624    49.734     0.200
     2.051    62.133     0.200
     0.186     6.188     0.200
     0.186     6.289     0.200
     0.566    17.391     0.200
     0.851    27.391     0.200
     0.851    27.391     0.200
     1.482    47.090     0.200
     2.157    67.391     0.200
     2.157    67.188     0.200
     2.658    81.188     0.200
     2.719    83.891     0.200
     2.719    83.488     0.200
     2.807    88.688     0.200
     2.891    89.789     0.200
     2.891    89.289     0.200
     0.303    10.272     0.200
     0.663    22.472     0.200
     0.979    31.472     0.200
     0.979    31.272     0.200
     1.331    41.772     0.200
     1.331    41.572     0.200
     2.070    64.672     0.200
     2.070    63.172     0.200
     0.245     8.672     0.200
     0.245     9.773     0.200
     0.399    13.867     0.200
     1.389    44.273     0.200
     1.658    52.273     0.200
     2.220    69.172     0.200
     2.856    89.570     0.200
     2.856    89.969     0.200
     3.000    93.969     0.200
     6.420   190.867     0.200
     0.239     9.672     0.200
     0.239     8.971     0.200
     0.984    31.771     0.200
     1.250    42.371     0.200
     1.411    44.771     0.200
     2.189    67.271     0.200
     2.879    89.871     0.200
     0.406    14.599     0.200
     0.406    14.498     0.200
     0.794    25.798     0.200
     0.954    31.298     0.200
     1.796    55.998     0.200
     1.796    55.298     0.200
     1.889    59.298     0.200
     0.252     9.793     0.200
     0.252     9.593     0.200
     0.432    13.492     0.200
     0.952    31.293     0.200
     0.952    30.793     0.200
     1.216    38.893     0.200
     1.441    45.093     0.200
     1.964    60.692     0.200
     2.156    68.593     0.200
     2.156    67.393     0.200
     7.688   226.093     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
