#!/bin/bash
gmt begin novy1.66_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source novy1.66'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.439     0.026     0.200
     0.478    -0.335     0.200
     0.142    -0.462     0.200
     0.157    -0.329     0.200
     0.325     0.116     0.200
     0.110     0.138     0.200
     0.079     0.349     0.200
     0.150    -0.043     0.200
     0.332    -0.020     0.200
     0.252     0.361     0.200
     0.412    -0.358     0.200
     0.552     0.479     0.200
     0.545     0.297     0.200
     0.783    -0.065     0.200
     0.981     0.082     0.200
     0.989    -0.055     0.200
     0.558    -0.018     0.200
     0.946    -0.619     0.200
     0.202    -0.429     0.200
     0.541     0.063     0.200
     0.465    -0.122     0.200
     0.592     0.544     0.200
     0.737     0.022     0.200
     0.876    -0.240     0.200
     0.734     0.077     0.200
     0.734    -0.423     0.200
     0.743     1.133     0.200
     0.750     1.009     0.200
     0.802     0.021     0.200
     0.802     0.321     0.200
     0.192    -0.778     0.200
     0.558    -0.365     0.200
     0.734    -0.668     0.200
     0.127    -0.156     0.200
     0.127    -0.054     0.200
     0.374    -0.438     0.200
     0.899    -0.272     0.200
     0.026     0.227     0.200
     0.026    -0.273     0.200
     0.389    -0.488     0.200
     0.910     0.163     0.200
     0.150     0.465     0.200
     0.190    -0.132     0.200
     0.625     0.439     0.200
     0.167    -0.090     0.200
     0.654     0.112     0.200
     0.221     0.102     0.200
     0.163    -0.628     0.200
     0.222    -0.069     0.200
     0.416     0.369     0.200
     0.416     0.470     0.200
     0.115     0.227     0.200
     0.162    -0.337     0.200
     0.558    -0.210     0.200
     0.955    -0.016     0.200
     0.175    -0.139     0.200
     0.483     0.155     0.200
     0.548    -1.007     0.200
     0.046     0.220     0.200
     0.422    -0.183     0.200
     0.982     0.925     0.200
     0.172    -0.444     0.200
     0.216     0.043     0.200
     0.216    -0.559     0.200
     0.144    -0.221     0.200
     0.144    -0.120     0.200
     0.261    -0.528     0.200
     0.261    -0.227     0.200
     0.178    -0.503     0.200
     0.236    -0.467     0.200
     0.236    -0.069     0.200
     0.176    -0.302     0.200
     0.176     0.198     0.200
     0.224    -0.424     0.200
     0.224     0.173     0.200
     0.170    -0.128     0.200
     0.251     0.025     0.200
     0.251    -0.276     0.200
     0.176    -0.307     0.200
     0.215    -0.842     0.200
     0.215    -0.342     0.200
     0.166     0.086     0.200
     0.248     0.085     0.200
     0.248    -0.016     0.200
     0.223    -0.179     0.200
     0.223    -0.374     0.200
     0.174    -0.052     0.200
     0.160     0.056     0.200
     0.160    -0.045     0.200
     0.274    -0.037     0.200
     0.274    -0.138     0.200
     0.175    -0.073     0.200
     0.212    -0.129     0.200
     0.212    -0.324     0.200
     0.160     0.371     0.200
     0.160     0.269     0.200
     0.409     0.214     0.200
     0.221    -0.162     0.200
     0.221     0.138     0.200
     0.171     0.212     0.200
     0.561     0.170     0.200
     0.166    -0.035     0.200
     0.229    -0.042     0.200
     0.229    -0.542     0.200
     0.140    -0.068     0.200
     0.140    -0.170     0.200
     0.040     0.107     0.200
     0.040    -0.292     0.200
     0.373    -0.618     0.200
     0.373    -0.419     0.200
     0.131    -0.010     0.200
     0.314    -0.194     0.200
     0.314    -0.295     0.200
     0.193     0.231     0.200
     0.822     0.714     0.200
     0.822     0.614     0.200
     0.020    -0.434     0.200
     0.644    -0.088     0.200
     0.564     0.099     0.200
     0.774     0.419     0.200
     0.774     0.457     0.200
     0.774     0.656     0.200
     0.164    -0.112     0.200
     0.164    -0.010     0.200
     0.223    -0.375     0.200
     0.223    -0.477     0.200
     0.223    -0.180     0.200
     0.151    -0.122     0.200
     0.241    -0.114     0.200
     0.086     0.315     0.200
     0.557    -0.281     0.200
     0.557     0.118     0.200
     0.400    -0.149     0.200
     0.113    -0.054     0.200
     0.744     0.152     0.200
     0.484     0.087     0.200
     0.530     0.175     0.200
     0.796     0.379     0.200
     0.796     0.481     0.200
     0.993     0.567     0.200
     0.021    -0.749     0.200
     0.384    -0.532     0.200
     0.112     0.040     0.200
     0.741     0.268     0.200
     0.079     0.158     0.200
     0.552     0.213     0.200
     0.258     0.399     0.200
     0.581     0.315     0.200
     0.581     0.214     0.200
     0.110    -0.055     0.200
     0.110    -0.156     0.200
     0.242    -0.903     0.200
     0.605    -0.613     0.200
     0.790    -0.041     0.200
     0.151     0.626     0.200
     0.498     0.115     0.200
     0.498     0.216     0.200
     0.269    -0.242     0.200
     0.580    -0.280     0.200
     0.772     0.562     0.200
     0.772     0.367     0.200
     0.994     0.619     0.200
     0.994     0.517     0.200
     0.174    -0.171     0.200
     0.458     0.002     0.200
     0.108    -0.878     0.200
     0.108    -0.979     0.200
     0.469    -0.469     0.200
     0.469    -0.368     0.200
     0.920     0.247     0.200
     0.920     0.547     0.200
     0.190    -0.197     0.200
     0.190     0.003     0.200
     0.516     0.410     0.200
     0.516     0.510     0.200
     0.825     0.076     0.200
     0.825     0.276     0.200
     0.960    -0.016     0.200
     0.960    -0.117     0.200
     0.191    -0.444     0.200
     0.191    -0.344     0.200
     0.514     0.676     0.200
     0.825     0.022     0.200
     0.825     0.522     0.200
     0.965    -0.572     0.200
     0.965    -0.172     0.200
     0.212    -0.007     0.200
     0.567    -0.515     0.200
     0.816     0.347     0.200
     0.223     0.123     0.200
     0.608    -0.125     0.200
     0.210     0.005     0.200
     0.576    -0.091     0.200
     0.208     0.162     0.200
     0.585    -0.220     0.200
     0.226    -0.061     0.200
     0.581    -0.011     0.200
     0.214     0.210     0.200
     0.603    -0.105     0.200
     0.213     0.130     0.200
     0.603    -0.012     0.200
     0.212     0.134     0.200
     0.594    -0.490     0.200
     0.245    -0.189     0.200
     0.608    -0.125     0.200
     0.608    -0.024     0.200
     0.266    -0.211     0.200
     0.618    -0.132     0.200
     0.618    -0.030     0.200
     0.230     0.231     0.200
     0.603    -0.192     0.200
     0.105     0.137     0.200
     0.583    -0.227     0.200
     0.222     0.172     0.200
     0.587    -0.115     0.200
     0.587    -0.216     0.200
     0.516     0.217     0.200
     0.830    -0.293     0.200
     0.796     0.035     0.200
     0.222     0.375     0.200
     0.576     0.396     0.200
     0.159     0.348     0.200
     0.753     0.837     0.200
     0.119     0.050     0.200
     0.516    -0.252     0.200
     0.269     0.256     0.200
     0.986     0.364     0.200
     0.986     0.465     0.200
     0.768     0.272     0.200
     0.220     0.339     0.200
     0.220     0.441     0.200
     0.573     0.377     0.200
     0.227    -0.253     0.200
     0.756     0.200     0.200
     0.212     0.247     0.200
     0.565     0.112     0.200
     0.458     0.152     0.200
     0.614     0.278     0.200
     0.688     0.593     0.200
     0.224     0.517     0.200
     0.576     0.472     0.200
     0.223     0.213     0.200
     0.617    -0.212     0.200
     0.111     0.043     0.200
     0.099    -0.163     0.200
     0.575    -0.154     0.200
     0.109     0.533     0.200
     0.576     0.376     0.200
     0.107     0.142     0.200
     0.107     0.244     0.200
     0.589    -0.140     0.200
     0.118    -0.029     0.200
     0.575     0.037     0.200
     0.120    -0.015     0.200
     0.591    -0.052     0.200
     0.110    -0.603     0.200
     0.106     0.591     0.200
     0.567     0.167     0.200
     0.110    -0.117     0.200
     0.561    -0.137     0.200
     0.561     0.062     0.200
     0.104     0.102     0.200
     0.590     0.330     0.200
     0.048    -0.272     0.200
     0.277     0.062     0.200
     0.557     0.121     0.200
     0.557    -0.074     0.200
     0.788     0.328     0.200
     0.788     0.226     0.200
     0.977     0.219     0.200
     0.536     0.195     0.200
     0.814     0.293     0.200
     0.831    -0.249     0.200
     0.449    -0.212     0.200
     0.381    -0.151     0.200
     0.186     0.015     0.200
     0.186     0.214     0.200
     0.566     0.254     0.200
     0.851     0.281     0.200
     0.851     0.078     0.200
     0.303    -0.444     0.200
     0.663     0.310     0.200
     0.663    -0.090     0.200
     0.979     0.397     0.200
     0.245     0.573     0.200
     0.399     0.606     0.200
     0.399     0.505     0.200
     0.239     0.620     0.200
     0.984     0.190     0.200
     0.984    -0.109     0.200
     0.406     0.626     0.200
     0.406     0.226     0.200
     0.623     0.460     0.200
     0.794    -0.281     0.200
     0.954     0.333     0.200
     0.252     0.534     0.200
     0.432    -0.245     0.200
     0.952     0.090     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.478    -0.508     0.200
     0.325     0.414     0.200
     0.552    -0.524     0.200
     0.545    -0.513     0.200
     0.545    -0.716     0.200
     0.783    -1.036     0.200
     0.981    -1.241     0.200
     0.989    -1.693     0.200
     0.202     0.809     0.200
     0.397     0.316     0.200
     0.541    -0.495     0.200
     0.465     0.440     0.200
     0.592    -0.499     0.200
     0.737    -0.599     0.200
     0.743    -0.003     0.200
     0.750    -0.226     0.200
     0.192    -0.338     0.200
     0.558     0.272     0.200
     0.127    -0.257     0.200
     0.374    -0.749     0.200
     0.899    -1.017     0.200
     0.026    -1.578     0.200
     0.389    -0.810     0.200
     0.910     0.213     0.200
     0.150     0.720     0.200
     0.625    -0.330     0.200
     0.167     0.091     0.200
     0.654    -0.713     0.200
     0.862    -0.681     0.200
     0.221     0.237     0.200
     0.163    -0.804     0.200
     0.222     0.187     0.200
     0.222    -0.114     0.200
     0.416     0.631     0.200
     0.115     0.831     0.200
     0.162    -0.412     0.200
     0.558     0.053     0.200
     0.175    -0.240     0.200
     0.175    -0.041     0.200
     0.483     0.363     0.200
     0.046    -1.375     0.200
     0.422     0.004     0.200
     0.422     0.204     0.200
     0.960     0.431     0.200
     0.982    -0.217     0.200
     0.172    -0.125     0.200
     0.216    -0.810     0.200
     0.144    -0.162     0.200
     0.261     0.253     0.200
     0.178    -0.382     0.200
     0.178    -0.585     0.200
     0.236    -0.401     0.200
     0.176     0.423     0.200
     0.224     0.648     0.200
     0.170     0.371     0.200
     0.170     0.170     0.200
     0.251     0.100     0.200
     0.251    -0.102     0.200
     0.176    -0.306     0.200
     0.215    -0.348     0.200
     0.215    -0.648     0.200
     0.166    -0.343     0.200
     0.248    -0.369     0.200
     0.248    -0.565     0.200
     0.223     0.238     0.200
     0.223     0.137     0.200
     0.174    -0.282     0.200
     0.160     0.655     0.200
     0.160     0.455     0.200
     0.274     0.349     0.200
     0.175    -0.230     0.200
     0.175    -0.129     0.200
     0.212    -0.404     0.200
     0.212     0.096     0.200
     0.160     0.534     0.200
     0.409     0.506     0.200
     0.409     0.606     0.200
     0.221    -0.487     0.200
     0.221     0.114     0.200
     0.171     0.433     0.200
     0.171     0.128     0.200
     0.561    -0.416     0.200
     0.166     0.170     0.200
     0.229     0.697     0.200
     0.140    -0.280     0.200
     0.040     1.060     0.200
     0.373    -0.438     0.200
     0.131     0.460     0.200
     0.131     0.359     0.200
     0.314     1.155     0.200
     0.193     0.089     0.200
     0.822    -0.252     0.200
     0.822     0.148     0.200
     0.020    -0.504     0.200
     0.644    -0.124     0.200
     0.564    -0.739     0.200
     0.774    -0.491     0.200
     0.774    -0.389     0.200
     0.774    -0.845     0.200
     0.774     0.054     0.200
     0.164     0.965     0.200
     0.223    -0.263     0.200
     0.151    -0.035     0.200
     0.241    -0.586     0.200
     0.241     0.414     0.200
     0.086     0.870     0.200
     0.557     0.107     0.200
     0.400     0.852     0.200
     0.113    -0.342     0.200
     0.113    -0.542     0.200
     0.744     0.892     0.200
     0.484    -0.008     0.200
     0.530     0.169     0.200
     0.530    -0.229     0.200
     0.796     0.600     0.200
     0.796     0.795     0.200
     0.993     0.253     0.200
     0.993     0.151     0.200
     0.021    -0.548     0.200
     0.384    -0.929     0.200
     0.384    -0.429     0.200
     0.112    -0.159     0.200
     0.112    -0.460     0.200
     0.741     0.252     0.200
     0.079     0.631     0.200
     0.079     0.233     0.200
     0.552     0.612     0.200
     0.552    -0.888     0.200
     0.258     0.527     0.200
     0.581     0.267     0.200
     0.581    -0.835     0.200
     0.110    -0.194     0.200
     0.242    -0.428     0.200
     0.605    -0.628     0.200
     0.790    -0.732     0.200
     0.151     0.411     0.200
     0.498     0.372     0.200
     0.498    -0.128     0.200
     0.269    -0.148     0.200
     0.772    -0.320     0.200
     0.772    -0.625     0.200
     0.994     0.361     0.200
     0.994    -0.334     0.200
     0.174     0.061     0.200
     0.174    -0.537     0.200
     0.458     0.182     0.200
     0.458     0.483     0.200
     0.108    -0.602     0.200
     0.469    -0.622     0.200
     0.920    -0.021     0.200
     0.190    -0.013     0.200
     0.190    -0.113     0.200
     0.516     0.888     0.200
     0.825     0.369     0.200
     0.960    -0.533     0.200
     0.191     0.039     0.200
     0.514     0.885     0.200
     0.825     0.832     0.200
     0.825     0.032     0.200
     0.965    -0.648     0.200
     0.965    -0.948     0.200
     0.212     0.310     0.200
     0.567    -0.653     0.200
     0.816    -0.227     0.200
     0.223     0.356     0.200
     0.608    -0.552     0.200
     0.210     0.436     0.200
     0.210    -0.165     0.200
     0.576     0.019     0.200
     0.208     0.893     0.200
     0.585    -0.223     0.200
     0.226     0.519     0.200
     0.226     0.222     0.200
     0.581     0.039     0.200
     0.581     0.242     0.200
     0.214     0.575     0.200
     0.603    -0.366     0.200
     0.213     0.408     0.200
     0.213     0.104     0.200
     0.603    -0.072     0.200
     0.212     0.493     0.200
     0.594    -0.828     0.200
     0.245     0.130     0.200
     0.245     0.329     0.200
     0.608    -0.353     0.200
     0.608    -0.052     0.200
     0.266     0.001     0.200
     0.266    -0.698     0.200
     0.618    -0.299     0.200
     0.230     0.466     0.200
     0.603    -0.345     0.200
     0.105     0.661     0.200
     0.583    -0.305     0.200
     0.222     0.444     0.200
     0.222     0.846     0.200
     0.587    -0.367     0.200
     0.516    -0.428     0.200
     0.830    -1.118     0.200
     0.796    -0.240     0.200
     0.222     0.723     0.200
     0.222     0.523     0.200
     0.576     0.116     0.200
     0.159     0.340     0.200
     0.753     0.635     0.200
     0.753     0.533     0.200
     0.119     0.431     0.200
     0.119     0.229     0.200
     0.516    -0.299     0.200
     0.516    -0.100     0.200
     0.269     0.209     0.200
     0.269    -0.193     0.200
     0.986     0.286     0.200
     0.986     0.082     0.200
     0.768    -0.359     0.200
     0.768     0.641     0.200
     0.220     0.511     0.200
     0.220     0.409     0.200
     0.573     0.036     0.200
     0.227    -0.505     0.200
     0.756    -0.144     0.200
     0.212     0.733     0.200
     0.565     0.094     0.200
     0.458    -0.153     0.200
     0.614     0.276     0.200
     0.688     0.632     0.200
     0.224     0.737     0.200
     0.224     0.237     0.200
     0.576     0.295     0.200
     0.223     0.345     0.200
     0.617    -0.074     0.200
     0.617    -0.667     0.200
     0.111    -0.206     0.200
     0.111     0.892     0.200
     0.099     0.212     0.200
     0.099     0.111     0.200
     0.575    -0.623     0.200
     0.109     0.374     0.200
     0.109     1.276     0.200
     0.576     0.104     0.200
     0.576     0.205     0.200
     0.107     0.990     0.200
     0.107     0.193     0.200
     0.589    -0.403     0.200
     0.589    -0.603     0.200
     0.118     0.074     0.200
     0.118     0.773     0.200
     0.575     0.069     0.200
     0.120     0.884     0.200
     0.120     0.584     0.200
     0.591    -0.433     0.200
     0.591     0.470     0.200
     0.110    -0.231     0.200
     0.106     1.188     0.200
     0.567    -0.187     0.200
     0.110     0.391     0.200
     0.561     0.190     0.200
     0.104     0.611     0.200
     0.590    -0.651     0.200
     0.048     1.137     0.200
     0.609    -1.220     0.200
     0.609    -0.519     0.200
     0.277    -0.334     0.200
     0.277    -0.834     0.200
     0.557    -0.329     0.200
     0.788    -0.101     0.200
     0.788    -0.304     0.200
     0.977    -0.652     0.200
     0.496     0.756     0.200
     0.496    -0.144     0.200
     0.536    -0.516     0.200
     0.536     0.084     0.200
     0.814    -0.279     0.200
     0.814     0.421     0.200
     0.831    -1.146     0.200
     0.449    -0.439     0.200
     0.381    -0.286     0.200
     0.186    -0.092     0.200
     0.186     0.010     0.200
     0.566    -1.182     0.200
     0.851    -0.492     0.200
     0.851    -0.496     0.200
     0.303    -1.200     0.200
     0.663     0.228     0.200
     0.979     0.056     0.200
     0.979    -0.144     0.200
     0.245     0.593     0.200
     0.245     1.695     0.200
     0.399     0.732     0.200
     0.239     1.709     0.200
     0.239     1.007     0.200
     0.984    -0.473     0.200
     0.406     0.568     0.200
     0.406     0.467     0.200
     0.794    -0.535     0.200
     0.954     0.108     0.200
     0.252     1.268     0.200
     0.252     1.068     0.200
     0.432    -0.799     0.200
     0.952     0.071     0.200
     0.952    -0.429     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.977    -0.182     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.020
 1.00    0.020
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00   -0.0
 1.00   -0.0
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.2
 1.00   -0.2
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =   0.0 (solid red line)
     0.050    -7.500   Sg = red circles; average =  -0.0 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.2 (dashed green line)
EOF
gmt end
