#!/bin/bash
gmt begin novy1.66_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic novy1.66'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.726
   137.000     1.817
   137.500     1.912
   138.000     2.010
   138.500     2.111
   139.000     2.217
   139.500     2.326
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.802
   142.000     2.932
   142.500     3.067
   143.000     3.207
   143.500     3.352
   144.000     3.503
   144.500     3.659
   145.000     3.821
   145.500     3.990
   146.000     4.164
   146.500     4.346
   147.000     4.534
   147.500     4.730
   148.000     4.933
   148.500     5.144
   149.000     5.364
   149.500     5.592
   150.000     5.830
   150.500     6.078
   151.000     6.336
   151.500     6.605
   152.000     6.884
   152.500     7.172
   153.000     7.471
   153.500     7.781
   154.000     8.101
   154.500     8.432
   155.000     8.774
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.688
   145.500     0.275
   146.000     1.301
   146.500     2.371
   147.000     3.475
   147.500     4.609
   148.000     5.770
   148.500     6.956
   149.000     8.166
   149.500     9.398
   150.000    10.653
   150.500    11.929
   151.000    13.225
   151.500    14.542
   152.000    15.877
   152.500    17.230
   153.000    18.602
   153.500    19.991
   154.000    21.398
   154.500    22.822
   155.000    24.263
   155.500    25.722
   156.000    27.197
   156.500    28.689
   157.000    30.198
   157.500    31.724
   158.000    33.266
   158.500    34.824
   159.000    36.399
   159.500    37.991
   160.000    39.599
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.691
   145.500     0.075
   146.000     0.769
   146.500     1.411
   147.000     2.009
   147.500     2.569
   148.000     3.094
   148.500     3.587
   149.000     4.053
   149.500     4.499
   150.000     4.929
   150.500     5.346
   151.000     5.752
   151.500     6.149
   152.000     6.538
   152.500     6.920
   153.000     7.295
   153.500     7.667
   154.000     8.035
   154.500     8.402
   155.000     8.766
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   140.475     0.666     0.200
   145.717    -1.577     0.200
   147.733     2.032     0.200
   140.195     0.298     0.200
   146.222    -2.811     0.200
   144.209    -3.591     0.200
   144.414    -2.948     0.200
   145.935    -1.265     0.200
   144.480    -3.025     0.200
   144.480    -2.525     0.200
   145.925    -1.211     0.200
   144.836    -1.672     0.200
   144.939    -1.950     0.200
   135.129    -0.616     0.200
   136.060    -1.549     0.200
   137.522    -0.558     0.200
   140.244    -0.039     0.200
   141.385     0.604     0.200
   145.880    -2.177     0.200
   146.417     0.110     0.200
   148.690    -0.059     0.200
   149.723    -1.321     0.200
   151.890    -2.267     0.200
   152.394    -0.018     0.200
   155.178    -0.577     0.200
   155.275    -0.209     0.200
   155.314    -0.262     0.200
   155.466    -0.769     0.200
   155.587    -0.130     0.200
   155.704    -0.787     0.200
   158.600    -2.957     0.200
   144.289    -3.265     0.200
   145.780    -1.637     0.200
   145.836    -1.604     0.200
   145.836    -1.732     0.200
   149.080    -1.521     0.200
   149.080    -0.521     0.200
   149.230    -0.113     0.200
   149.230    -0.312     0.200
   149.230    -0.722     0.200
   144.280    -3.488     0.200
   145.801    -1.509     0.200
   136.488    -1.914     0.200
   145.813    -2.275     0.200
   145.813    -2.150     0.200
   140.463    -0.651     0.200
   144.803    -1.016     0.200
   144.836    -3.775     0.200
   145.639    -1.570     0.200
   146.727     1.585     0.200
   146.727     1.720     0.200
   145.989    -1.656     0.200
   136.312    -2.156     0.200
   140.213    -0.048     0.200
   145.789    -2.408     0.200
   136.555    -2.230     0.200
   136.555    -2.402     0.200
   137.378    -0.034     0.200
   138.291     0.480     0.200
   139.159    -0.056     0.200
   139.675    -0.418     0.200
   139.845    -0.611     0.200
   140.291    -1.334     0.200
   143.676    -2.734     0.200
   144.443    -1.379     0.200
   144.698    -1.790     0.200
   144.810    -1.851     0.200
   144.959    -1.100     0.200
   145.614    -0.149     0.200
   145.799    -2.114     0.200
   146.605     0.526     0.200
   147.110     0.397     0.200
   149.647     0.026     0.200
   149.900    -0.868     0.200
   152.803     2.219     0.200
   149.649     2.353     0.200
   149.596     1.561     0.200
   136.614    -1.198     0.200
   140.352     0.637     0.200
   139.692    -0.389     0.200
   144.690    -3.104     0.200
   136.277    -1.268     0.200
   140.554     0.061     0.200
   145.218    -0.581     0.200
   145.531    -2.025     0.200
   145.872    -0.400     0.200
   149.925    -1.217     0.200
   152.202    -2.038     0.200
   136.637    -3.014     0.200
   145.482    -1.798     0.200
   145.482    -1.697     0.200
   150.146     0.663     0.200
   136.586    -1.677     0.200
   145.853    -1.297     0.200
   146.543     0.284     0.200
   145.636    -1.827     0.200
   145.636    -2.163     0.200
   136.479    -0.841     0.200
   140.454     0.513     0.200
   145.650    -2.113     0.200
   149.709    -0.759     0.200
   145.904    -1.444     0.200
   145.904    -1.203     0.200
   149.371     2.171     0.200
   149.371     0.167     0.200
   144.769    -2.993     0.200
   145.651    -1.666     0.200
   145.651    -2.479     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   150.834     3.064     0.200
   151.369     2.869     0.200
   145.234    -2.369     0.200
   145.113    -4.550     0.200
   145.444    -1.820     0.200
   149.525     3.611     0.200
   145.310    -2.801     0.200
   147.184     2.223     0.200
   149.723     3.381     0.200
   151.890     4.134     0.200
   152.107     5.008     0.200
   149.080     1.979     0.200
   149.080     2.577     0.200
   149.230     3.114     0.200
   150.503     4.526     0.200
   150.782     4.793     0.200
   151.248     4.077     0.200
   149.071     1.955     0.200
   149.194     2.827     0.200
   145.319    -2.987     0.200
   150.108     2.999     0.200
   150.108     2.600     0.200
   151.571     4.542     0.200
   151.865     4.799     0.200
   152.299     4.751     0.200
   149.628     2.780     0.200
   151.080     4.176     0.200
   151.369     5.032     0.200
   151.813     4.461     0.200
   149.405     2.136     0.200
   149.405     2.660     0.200
   151.380     5.276     0.200
   145.163    -2.885     0.200
   149.762     3.163     0.200
   145.076    -2.811     0.200
   146.548     1.218     0.200
   147.074     1.708     0.200
   149.513     2.489     0.200
   149.647     3.987     0.200
   149.900     3.350     0.200
   151.356     4.624     0.200
   151.646     5.315     0.200
   152.087     4.512     0.200
   149.611     3.278     0.200
   145.038    -3.502     0.200
   149.584     3.329     0.200
   149.863     3.106     0.200
   151.314     4.495     0.200
   152.048     4.540     0.200
   149.599     2.910     0.200
   149.547     3.923     0.200
   149.382     3.346     0.200
   150.748     4.188     0.200
   151.031     4.479     0.200
   151.490     4.388     0.200
   146.551     1.441     0.200
   149.388     2.767     0.200
   149.516     2.715     0.200
   149.516     2.955     0.200
   150.953     4.194     0.200
   151.237     4.446     0.200
   151.693     4.360     0.200
   146.808     1.906     0.200
   149.721     2.173     0.200
   149.925     3.494     0.200
   149.925     3.834     0.200
   149.440     3.207     0.200
   149.440     2.660     0.200
   150.425     4.350     0.200
   150.891     3.518     0.200
   145.171    -1.747     0.200
   146.648     1.218     0.200
   148.345     2.500     0.200
   149.619     3.061     0.200
   149.619     3.461     0.200
   151.452     4.276     0.200
   149.732     3.531     0.200
   151.360     4.203     0.200
   151.804     4.101     0.200
   149.709     3.622     0.200
   147.948     1.563     0.200
   149.700     3.593     0.200
   149.594     2.502     0.200
   151.044     4.090     0.200
   151.333     4.240     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   146.592     3.024     0.200
   146.156     1.154     0.200
   164.287    53.186     0.200
   150.108    12.300     0.200
   151.571    14.343     0.200
   151.865    14.600     0.200
   152.299    13.349     0.200
   151.080    10.176     0.200
   151.369    10.833     0.200
   155.701    25.630     0.200
   164.609    54.242     0.200
   146.376     2.664     0.200
   147.252     2.893     0.200
   145.425     0.785     0.200
   145.720     0.670     0.200
   146.548     1.647     0.200
   146.548     2.132     0.200
   149.721    10.736     0.200
   149.721    10.470     0.200
   151.182    11.783     0.200
   151.475    12.599     0.200
   151.911    12.429     0.200
   152.202    15.731     0.200
   164.962    55.595     0.200
   164.606    54.241     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   140.694     1.270     0.200
   139.925     4.085     0.200
   136.977     4.453     0.200
   143.678    -4.854     0.200
   141.208     2.431     0.200
   140.734     1.775     0.200
   137.510     0.864     0.200
   140.342     1.355     0.200
   140.342     2.515     0.200
   150.503     6.925     0.200
   150.782     6.992     0.200
   151.248     6.674     0.200
   150.108     7.397     0.200
   145.639     4.456     0.200
   135.828     1.200     0.200
   136.767     1.893     0.200
   137.120     0.904     0.200
   137.281     2.691     0.200
   138.574     1.710     0.200
   139.141     0.907     0.200
   140.291     0.900     0.200
   143.070     2.333     0.200
   137.298     0.498     0.200
   149.547     4.748     0.200
   140.274     0.866     0.200
   152.202     6.653     0.200
   142.973     1.685     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
