#!/bin/bash
gmt begin novy1.66_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P novy1.66'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.709
    79.000     8.534
    80.000     7.444
    81.000     6.439
    82.000     5.520
    83.000     4.685
    84.000     3.934
    85.000     3.271
    86.000     2.693
    87.000     2.193
    88.000     1.797
    89.000     1.497
    90.000     1.239
    91.000     1.013
    92.000     0.812
    93.000     0.630
    94.000     0.465
    95.000     0.319
    96.000     0.200
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    20.366     1.230     0.200
    20.360    -0.708     0.200
    20.851     0.966     0.200
    21.851     0.210     0.200
    24.155    -0.247     0.200
    25.320    -0.854     0.200
    25.307     1.459     0.200
    25.434    -0.892     0.200
    25.577    -2.188     0.200
    25.640    -1.759     0.200
    25.735    -2.621     0.200
    25.735    -2.820     0.200
    25.777    -0.104     0.200
    25.777    -1.003     0.200
    25.895     1.934     0.200
    25.927     0.438     0.200
    26.038     3.733     0.200
    26.057    -3.540     0.200
    26.050    -1.471     0.200
    26.122     1.871     0.200
    26.228     0.921     0.200
    26.235    -0.943     0.200
    26.442     0.484     0.200
    26.635    -0.857     0.200
    26.635    -1.755     0.200
    26.866    -2.837     0.200
    27.902     1.863     0.200
    28.527    -0.706     0.200
    29.777    -0.798     0.200
    30.601     1.918     0.200
    31.679    -0.586     0.200
    31.861     1.812     0.200
    33.326     2.981     0.200
    33.563    -1.085     0.200
    34.040     0.770     0.200
    34.061     1.588     0.200
    34.583     0.066     0.200
    35.887     0.839     0.200
    36.732    -1.378     0.200
    37.058     0.844     0.200
    37.332    -1.478     0.200
    37.813     1.445     0.200
    38.022    -1.316     0.200
    39.187    -1.103     0.200
    40.159    -1.196     0.200
    40.310     1.558     0.200
    40.372     0.045     0.200
    40.450    -0.602     0.200
    40.586     0.271     0.200
    41.038    -2.457     0.200
    41.338     0.073     0.200
    41.569     0.179     0.200
    41.605    -0.116     0.200
    41.826     0.075     0.200
    43.509    -0.591     0.200
    43.577    -1.136     0.200
    43.922    -1.911     0.200
    44.806     1.019     0.200
    45.791     3.200     0.200
    45.981     1.705     0.200
    46.258    -1.477     0.200
    46.693    -0.894     0.200
    47.592     0.097     0.200
    47.753    -1.156     0.200
    48.354    -0.807     0.200
    48.872     0.209     0.200
    49.856    -0.305     0.200
    49.955    -3.063     0.200
    50.182    -0.782     0.200
    50.328    -0.888     0.200
    50.579     0.218     0.200
    50.841     2.241     0.200
    52.317     0.202     0.200
    53.092    -1.531     0.200
    54.284     0.735     0.200
    54.490    -0.766     0.200
    54.580     3.583     0.200
    54.778    -1.849     0.200
    54.790     0.061     0.200
    54.795     1.024     0.200
    54.970    -0.242     0.200
    55.251     0.731     0.200
    55.357    -1.039     0.200
    55.846     0.447     0.200
    57.181    -0.056     0.200
    57.727     0.098     0.200
    57.796     0.611     0.200
    58.018    -0.943     0.200
    58.768    -0.180     0.200
    59.074    -0.307     0.200
    59.714    -0.728     0.200
    60.756     0.139     0.200
    61.517    -0.022     0.200
    61.963    -1.027     0.200
    62.087     0.137     0.200
    62.523    -0.776     0.200
    65.913    -0.016     0.200
    66.303    -0.516     0.200
    67.878    -0.524     0.200
    69.644    -0.526     0.200
    69.640    -1.502     0.200
    70.936    -0.432     0.200
    70.983     0.283     0.200
    71.421     0.632     0.200
    71.486    -0.759     0.200
    72.180     0.069     0.200
    73.591    -0.298     0.200
    74.598    -0.181     0.200
    74.828     1.488     0.200
    75.389     0.254     0.200
    76.090     0.246     0.200
    76.223     0.487     0.200
    76.407     0.446     0.200
    76.620     0.239     0.200
    77.516     1.201     0.200
    77.727     0.024     0.200
    77.787     0.689     0.200
    79.290     0.400     0.200
    80.218     0.366     0.200
    80.711    -0.284     0.200
    81.942    -0.814     0.200
    82.459    -0.521     0.200
    83.411     0.543     0.200
    83.742     1.841     0.200
    84.141    -1.195     0.200
    84.477     1.100     0.200
    84.480     1.086     0.200
    85.270     0.113     0.200
    85.443     3.251     0.200
    85.757    -0.312     0.200
    87.088    -1.853     0.200
    87.565    -1.161     0.200
    88.956    -0.751     0.200
    20.202    -2.373     0.200
    20.184    -2.170     0.200
    20.664     0.621     0.200
    26.145    -0.706     0.200
    27.832     0.113     0.200
    28.160    -1.812     0.200
    36.227    -0.445     0.200
    37.506     0.274     0.200
    38.678    -0.915     0.200
    39.630    -0.880     0.200
    39.878    -0.442     0.200
    40.028    -0.485     0.200
    40.065    -0.785     0.200
    40.064    -0.175     0.200
    40.522    -0.473     0.200
    41.104    -0.373     0.200
    41.334    -0.769     0.200
    42.801    -0.441     0.200
    43.029    -0.090     0.200
    43.476    -0.496     0.200
    43.486    -0.779     0.200
    44.499     1.292     0.200
    44.807    -1.165     0.200
    44.958    -0.571     0.200
    45.748    -1.331     0.200
    46.204    -0.726     0.200
    47.923    -1.646     0.200
    49.478    -1.698     0.200
    51.799    -1.320     0.200
    52.152     0.051     0.200
    54.026    -0.755     0.200
    54.322    -0.913     0.200
    54.335     0.391     0.200
    55.106    -0.602     0.200
    55.392    -0.662     0.200
    57.124    -0.021     0.200
    57.148     0.708     0.200
    57.552    -0.545     0.200
    61.265    -1.091     0.200
    61.473    -0.205     0.200
    64.355     0.727     0.200
    65.647    -0.674     0.200
    65.990     0.115     0.200
    67.526    -0.679     0.200
    67.697     0.745     0.200
    70.676     0.374     0.200
    71.086     1.382     0.200
    71.339    -1.353     0.200
    73.201     0.126     0.200
    74.514     0.934     0.200
    75.743     0.644     0.200
    75.836     0.317     0.200
    75.929     0.992     0.200
    76.085     1.295     0.200
    76.229     0.785     0.200
    76.305     0.442     0.200
    76.671     0.576     0.200
    77.175     0.736     0.200
    77.261     0.651     0.200
    78.937     0.955     0.200
    79.955    -0.591     0.200
    81.236    -1.458     0.200
    82.221     0.746     0.200
    83.076     0.495     0.200
    84.178     0.241     0.200
    85.380    -0.211     0.200
    85.631     0.937     0.200
    19.422    -1.748     0.200
    19.422    -2.045     0.200
    21.287     1.705     0.200
    25.301     1.738     0.200
    25.301     0.738     0.200
    25.879    -0.400     0.200
    26.499    -2.109     0.200
    26.990     1.465     0.200
    27.136     2.150     0.200
    27.307    -1.089     0.200
    27.657    -0.523     0.200
    29.501    -0.936     0.200
    30.501     3.217     0.200
    30.938     0.363     0.200
    30.938     1.363     0.200
    31.991     1.093     0.200
    33.075     0.596     0.200
    33.149     0.951     0.200
    33.526     0.162     0.200
    36.118    -0.719     0.200
    36.496    -0.651     0.200
    36.496     5.052     0.200
    36.569     1.427     0.200
    37.472    -0.956     0.200
    37.552    -0.629     0.200
    37.552     5.074     0.200
    38.591    -0.898     0.200
    39.510     1.615     0.200
    39.641    -0.471     0.200
    39.716    -0.798     0.200
    39.792     2.274     0.200
    39.970    -1.605     0.200
    40.059    -1.449     0.200
    40.473     2.915     0.200
    40.485    -1.481     0.200
    40.462     0.917     0.200
    40.839    -0.405     0.200
    41.786    -1.182     0.200
    42.814    -1.260     0.200
    44.153    -1.856     0.200
    44.286     1.585     0.200
    44.852     2.066     0.200
    45.047     0.514     0.200
    45.092     0.152     0.200
    45.334     0.331     0.200
    45.343     1.760     0.200
    45.385     0.120     0.200
    45.664     0.518     0.200
    45.664     0.620     0.200
    45.825    -0.655     0.200
    46.049     2.576     0.200
    46.890     0.871     0.200
    46.994    -0.437     0.200
    47.429    -1.729     0.200
    47.483     2.056     0.200
    47.807    -0.963     0.200
    48.237    -0.492     0.200
    48.484    -1.397     0.200
    48.762     0.564     0.200
    49.227    -0.096     0.200
    49.774     0.726     0.200
    50.638     1.181     0.200
    51.419    -0.691     0.200
    51.535    -0.163     0.200
    51.837    -2.817     0.200
    51.798     1.472     0.200
    52.429     1.780     0.200
    53.757    -0.611     0.200
    54.037    -0.053     0.200
    54.188    -3.156     0.200
    54.473    -0.234     0.200
    54.481    -0.291     0.200
    54.841     0.096     0.200
    55.092     0.081     0.200
    55.717     0.082     0.200
    56.396    -0.073     0.200
    56.618    -1.654     0.200
    56.832    -0.176     0.200
    56.926     3.159     0.200
    56.944    -0.966     0.200
    57.035    -0.615     0.200
    57.064     0.078     0.200
    58.044    -0.219     0.200
    58.238    -3.079     0.200
    60.721    -1.221     0.200
    60.778    -0.610     0.200
    61.032    -0.837     0.200
    65.136    -0.589     0.200
    66.365    -1.517     0.200
    68.233    -1.353     0.200
    68.511    -1.093     0.200
    69.347     0.005     0.200
    69.972    -1.145     0.200
    71.502     0.441     0.200
    71.514     0.470     0.200
    72.560    -0.005     0.200
    74.053     0.491     0.200
    75.907    -0.814     0.200
    76.598     1.261     0.200
    76.763     0.124     0.200
    77.087     1.399     0.200
    77.074    -0.924     0.200
    77.472     0.345     0.200
    77.978     0.224     0.200
    78.120     1.234     0.200
    78.151     1.061     0.200
    79.720     0.155     0.200
    79.900     1.479     0.200
    80.810     0.584     0.200
    81.230    -0.654     0.200
    83.047     1.017     0.200
    83.878     1.044     0.200
    85.007     0.323     0.200
    86.135     0.110     0.200
    86.409     0.359     0.200
    87.685    -0.739     0.200
    87.742     1.387     0.200
    25.314     1.541     0.200
    25.429     1.499     0.200
    26.551    -1.654     0.200
    27.111     1.297     0.200
    27.327     1.356     0.200
    27.652     0.442     0.200
    28.866     0.627     0.200
    29.335    -0.538     0.200
    29.763     1.666     0.200
    31.049     1.307     0.200
    32.115     0.929     0.200
    32.567     0.968     0.200
    32.803    -0.101     0.200
    33.201    -0.583     0.200
    33.270     1.821     0.200
    33.457     0.184     0.200
    33.731     0.802     0.200
    34.956     0.393     0.200
    35.159     1.641     0.200
    35.315     0.896     0.200
    36.018    -0.933     0.200
    36.107     0.304     0.200
    36.727     0.209     0.200
    37.357    -0.845     0.200
    38.487    -0.884     0.200
    38.454     0.391     0.200
    39.465     1.923     0.200
    39.570    -0.151     0.200
    39.602     0.785     0.200
    39.874     2.023     0.200
    39.938    -1.013     0.200
    40.015     1.549     0.200
    40.158     0.666     0.200
    40.158     4.268     0.200
    40.361    -0.122     0.200
    40.451     0.737     0.200
    42.064     1.484     0.200
    42.578    -0.802     0.200
    42.642     1.779     0.200
    42.737    -0.798     0.200
    43.735    -1.955     0.200
    44.335    -0.869     0.200
    45.129     0.794     0.200
    45.110     0.949     0.200
    45.182     0.175     0.200
    45.182     4.374     0.200
    45.331     1.397     0.200
    45.941     0.373     0.200
    46.015     0.783     0.200
    46.107     1.059     0.200
    47.029    -0.171     0.200
    47.033    -0.196     0.200
    47.276    -1.198     0.200
    47.594    -0.269     0.200
    47.993     0.337     0.200
    48.310     1.392     0.200
    48.864     0.626     0.200
    49.636     2.026     0.200
    49.737    -0.047     0.200
    49.909     0.644     0.200
    50.652     1.020     0.200
    51.145     1.309     0.200
    51.382    -1.468     0.200
    51.489    -0.267     0.200
    51.755     0.744     0.200
    51.800     0.409     0.200
    51.812     2.015     0.200
    51.956     2.246     0.200
    52.409    -2.127     0.200
    53.027     1.308     0.200
    52.964     1.773     0.200
    53.357     0.074     0.200
    53.490    -0.703     0.200
    53.601    -0.712     0.200
    53.693    -0.891     0.200
    53.980    -0.287     0.200
    54.433     0.010     0.200
    54.504    -0.004     0.200
    54.747     0.730     0.200
    54.776    -0.483     0.200
    55.035     0.043     0.200
    55.336     0.476     0.200
    55.654     0.291     0.200
    55.673     0.049     0.200
    55.688    -0.155     0.200
    56.068     0.721     0.200
    56.774     0.193     0.200
    56.898    -0.689     0.200
    56.931    -0.421     0.200
    57.502    -0.956     0.200
    57.849     0.101     0.200
    58.556    -0.848     0.200
    58.652    -0.016     0.200
    60.134     0.251     0.200
    60.649    -1.172     0.200
    60.825    -0.968     0.200
    61.207    -1.167     0.200
    61.211    -1.190     0.200
    62.167    -0.431     0.200
    62.359    -0.319     0.200
    67.130     0.271     0.200
    68.305    -1.342     0.200
    69.985     1.142     0.200
    70.154     1.101     0.200
    70.541     0.336     0.200
    72.591     1.281     0.200
    72.694    -0.232     0.200
    73.312     0.311     0.200
    73.854     0.127     0.200
    75.302     0.724     0.200
    75.435     0.657     0.200
    75.471     0.948     0.200
    75.843    -0.175     0.200
    76.399     0.559     0.200
    76.531     0.908     0.200
    76.560     1.145     0.200
    76.850    -0.193     0.200
    76.770     0.657     0.200
    77.004     0.440     0.200
    76.919     0.518     0.200
    77.406     0.787     0.200
    78.155    -0.385     0.200
    78.953     0.811     0.200
    80.610     1.624     0.200
    81.351    -0.124     0.200
    82.079     3.635     0.200
    82.779     0.983     0.200
    85.289    -0.509     0.200
    85.400    -1.464     0.200
    85.523     0.022     0.200
    87.843     0.883     0.200
    88.080     0.158     0.200
    95.627    -0.223     0.200
    96.755    -1.349     0.200
    98.340    -1.494     0.200
    16.329     5.026     0.200
    19.642    -2.059     0.200
    19.642    -1.258     0.200
    20.704     1.404     0.200
    21.122     0.899     0.200
    21.122     1.298     0.200
    21.339     0.758     0.200
    25.553     1.071     0.200
    27.236    -0.127     0.200
    28.990     0.336     0.200
    29.379    -1.218     0.200
    31.177     0.901     0.200
    32.240     0.554     0.200
    32.689     1.620     0.200
    32.724     0.313     0.200
    33.325     0.059     0.200
    33.325     0.457     0.200
    33.395     0.451     0.200
    33.585     0.799     0.200
    34.719     0.966     0.200
    35.278     0.954     0.200
    35.434     1.111     0.200
    36.108    -0.973     0.200
    37.441    -0.317     0.200
    37.439    -0.698     0.200
    38.575    -0.677     0.200
    38.490     0.841     0.200
    39.667    -0.999     0.200
    39.732     0.457     0.200
    40.017    -1.014     0.200
    40.005     2.193     0.200
    40.080     1.172     0.200
    40.144     1.537     0.200
    40.446    -1.758     0.200
    40.568    -1.470     0.200
    40.880    -1.045     0.200
    41.605    -1.000     0.200
    42.671    -0.785     0.200
    42.839    -0.852     0.200
    43.777    -2.221     0.200
    43.919    -1.259     0.200
    44.466    -2.137     0.200
    45.061     0.422     0.200
    45.112     1.013     0.200
    45.260     2.043     0.200
    45.260     1.543     0.200
    46.037    -1.000     0.200
    46.717     0.062     0.200
    46.980     0.006     0.200
    47.372    -1.242     0.200
    48.268    -1.487     0.200
    48.993     0.440     0.200
    49.536     0.288     0.200
    49.764     0.752     0.200
    49.997     0.987     0.200
    51.498    -2.523     0.200
    51.602    -1.298     0.200
    51.921     0.323     0.200
    53.146     1.253     0.200
    53.048     1.973     0.200
    53.709    -0.577     0.200
    53.800    -0.647     0.200
    54.089    -0.157     0.200
    54.860    -0.259     0.200
    54.883     0.077     0.200
    55.145    -0.116     0.200
    55.445     0.626     0.200
    55.874    -0.553     0.200
    56.004    -0.983     0.200
    56.301    -1.105     0.200
    56.628    -1.135     0.200
    57.019    -0.706     0.200
    58.784     0.920     0.200
    60.177    -0.690     0.200
    60.477    -1.739     0.200
    60.753    -0.923     0.200
    60.929    -1.016     0.200
    61.064    -0.932     0.200
    66.118    -0.892     0.200
    68.045    -0.321     0.200
    69.430    -0.948     0.200
    70.087     0.507     0.200
    70.481     0.402     0.200
    72.645    -0.432     0.200
    73.234     0.774     0.200
    73.777     0.485     0.200
    74.356    -0.496     0.200
    75.360     1.401     0.200
    76.321     1.216     0.200
    76.490     1.361     0.200
    76.855     1.201     0.200
    77.435     0.547     0.200
    78.086     0.619     0.200
    79.458     0.780     0.200
    82.706     0.503     0.200
    84.735    -0.886     0.200
    85.249    -0.362     0.200
    85.359     0.388     0.200
    87.316    -0.134     0.200
    87.972     1.728     0.200
    88.309     0.632     0.200
    19.324    -0.292     0.200
    19.324     0.009     0.200
    21.279     0.160     0.200
    21.976     0.488     0.200
    27.792     1.880     0.200
    29.970    -0.672     0.200
    33.434     0.067     0.200
    33.434     0.567     0.200
    34.445     0.785     0.200
    38.945    -1.060     0.200
    39.656     1.194     0.200
    39.980     0.299     0.200
    42.291    -1.709     0.200
    43.114     0.505     0.200
    44.062     0.270     0.200
    44.374    -2.036     0.200
    44.661    -1.829     0.200
    45.423     0.113     0.200
    45.787     0.226     0.200
    45.787     0.326     0.200
    47.429    -1.548     0.200
    47.692    -1.190     0.200
    47.725    -0.647     0.200
    48.153     0.742     0.200
    48.996    -0.749     0.200
    52.560     0.383     0.200
    53.523    -1.018     0.200
    53.921     0.361     0.200
    55.152     2.423     0.200
    55.342     1.050     0.200
    57.069    -1.087     0.200
    57.112    -1.591     0.200
    61.168    -0.699     0.200
    64.351    -2.915     0.200
    66.866    -1.160     0.200
    68.789    -0.280     0.200
    70.116    -1.484     0.200
    71.220     0.493     0.200
    77.217     0.009     0.200
    77.589     0.630     0.200
    77.566    -1.543     0.200
    84.351     0.661     0.200
    16.714    -5.601     0.200
    26.417     1.616     0.200
    26.427     1.528     0.200
    38.943    -0.652     0.200
    40.099    -1.289     0.200
    41.013     2.057     0.200
    43.318     9.563     0.200
    43.494    -2.063     0.200
    44.392     0.730     0.200
    46.051     1.556     0.200
    47.701   -11.950     0.200
    48.081   -14.891     0.200
    54.322    -1.136     0.200
    54.704    -0.916     0.200
    55.402   -14.956     0.200
    55.742     2.596     0.200
    69.860     6.341     0.200
    77.986    -0.724     0.200
    16.397     1.856     0.200
    20.579     5.826     0.200
    43.449    -1.364     0.200
    44.327    15.085     0.200
    46.118     4.854     0.200
    47.732     1.240     0.200
    77.984    -1.264     0.200
    14.617     6.013     0.200
    19.378    -0.072     0.200
    19.378     0.028     0.200
    21.185     7.993     0.200
    21.331     0.713     0.200
    22.002     1.219     0.200
    23.817     2.691     0.200
    24.828     1.470     0.200
    25.114     1.872     0.200
    25.123     1.788     0.200
    25.158    19.465     0.200
    26.835     0.290     0.200
    26.835     1.090     0.200
    27.895     4.775     0.200
    33.224    -8.288     0.200
    33.489     0.397     0.200
    37.980    -0.134     0.200
    39.824     2.212     0.200
    40.109    -0.056     0.200
    43.177     0.106     0.200
    44.363     0.363     0.200
    45.111     1.398     0.200
    45.204     2.660     0.200
    45.852     0.528     0.200
    45.852     0.528     0.200
    47.807    -0.769     0.200
    47.821    -1.378     0.200
    48.670     0.562     0.200
    53.422    -0.664     0.200
    54.043    -0.914     0.200
    55.232    -0.349     0.200
    55.462     0.997     0.200
    57.157    -0.699     0.200
    58.666     2.308     0.200
    71.293     0.357     0.200
    76.020     0.892     0.200
    76.262    -0.486     0.200
    77.435   -10.598     0.200
    86.197    -2.359     0.200
    14.382     7.016     0.200
    15.687     3.984     0.200
    15.687     4.484     0.200
    16.281    16.318     0.200
    20.241     1.463     0.200
    21.057     1.922     0.200
    25.913     0.895     0.200
    25.913     1.395     0.200
    26.045     0.902     0.200
    26.055     0.816     0.200
    28.491     3.743     0.200
    32.604     0.421     0.200
    40.360    -0.743     0.200
    41.723    -0.467     0.200
    44.113    -0.336     0.200
    44.293    -1.783     0.200
    44.996     0.607     0.200
    45.941     0.322     0.200
    47.026     0.604     0.200
    47.707    -0.995     0.200
    47.975    -0.803     0.200
    48.062    -1.146     0.200
    48.422    -0.828     0.200
    48.537    -1.115     0.200
    53.142     0.194     0.200
    53.412     0.212     0.200
    54.084    -0.510     0.200
    54.512    -1.830     0.200
    55.595     8.346     0.200
    55.861     0.737     0.200
    56.412    -0.304     0.200
    56.456    -0.815     0.200
    63.813    -1.253     0.200
    77.531    -0.817     0.200
    77.533    -1.632     0.200
    14.630     6.891     0.200
    15.074     7.277     0.200
    15.160     3.141     0.200
    15.160     3.540     0.200
    15.821     2.508     0.200
    16.398     2.085     0.200
    18.140     0.836     0.200
    19.706    -1.127     0.200
    19.706    -1.026     0.200
    21.560   -12.210     0.200
    21.560   -11.913     0.200
    21.677     0.433     0.200
    25.377     1.452     0.200
    25.369     2.129     0.200
    25.509     0.559     0.200
    33.820     1.302     0.200
    34.051     1.693     0.200
    77.604    -0.818     0.200
    77.607    -1.137     0.200
    20.153    -3.542     0.200
    20.336    -0.824     0.200
    21.051     2.930     0.200
    25.707     3.607     0.200
    40.084     0.624     0.200
    41.456    -0.692     0.200
    41.925     0.768     0.200
    42.850     0.238     0.200
    43.672    -0.398     0.200
    43.886    -2.421     0.200
    44.603     0.842     0.200
    45.131    -2.364     0.200
    46.223    -0.301     0.200
    46.606    -0.002     0.200
    47.419     0.049     0.200
    47.782    -1.170     0.200
    48.361    -1.049     0.200
    53.196    -0.078     0.200
    54.197    -0.113     0.200
    54.197    -0.414     0.200
    54.281    -1.024     0.200
    55.362     0.148     0.200
    55.644     0.621     0.200
    55.983    -0.713     0.200
    57.288     0.417     0.200
    57.387    -0.884     0.200
    60.406    -1.250     0.200
    61.214    -1.044     0.200
    61.392    -1.848     0.200
    64.493    -0.564     0.200
    65.813    -1.138     0.200
    66.103    -1.002     0.200
    67.004     0.343     0.200
    67.664    -0.437     0.200
    69.372    -0.605     0.200
    71.046    -1.259     0.200
    75.053    -0.869     0.200
    75.687     0.092     0.200
    76.032    -0.077     0.200
    76.861     0.323     0.200
    78.155     0.094     0.200
    79.073    -0.666     0.200
    79.445    -0.397     0.200
    83.202    -0.427     0.200
    83.601    -0.281     0.200
    84.098    -1.221     0.200
    84.987    -1.415     0.200
    85.741    -1.174     0.200
    86.317    -1.022     0.200
    15.333     6.865     0.200
    17.385     2.651     0.200
    17.981     2.274     0.200
    19.574    -0.706     0.200
    19.574    -0.308     0.200
    21.151    -0.836     0.200
    21.151    -0.336     0.200
    21.943     0.165     0.200
    23.762     1.336     0.200
    24.966     0.749     0.200
    25.075     1.265     0.200
    25.619     0.615     0.200
    25.871     2.935     0.200
    26.766     2.453     0.200
    26.912     1.136     0.200
    26.921     1.052     0.200
    28.634     0.726     0.200
    29.364    -0.461     0.200
    30.140     2.377     0.200
    30.578    -0.494     0.200
    31.687    -0.773     0.200
    32.088     0.407     0.200
    32.614    -0.408     0.200
    33.623    -0.220     0.200
    33.623     0.179     0.200
    34.025     0.280     0.200
    34.301     1.484     0.200
    34.537     1.482     0.200
    34.792    -0.358     0.200
    34.899     1.460     0.200
    35.022    -0.345     0.200
    35.022     0.256     0.200
    34.992     1.615     0.200
    35.034     0.985     0.200
    35.131     1.510     0.200
    36.116    -0.245     0.200
    36.714     2.148     0.200
    37.443     0.247     0.200
    38.696    -0.010     0.200
    38.615     1.561     0.200
    39.887    -0.768     0.200
    41.266    -0.962     0.200
    41.615     1.467     0.200
    42.011     0.136     0.200
    42.114    -0.908     0.200
    42.348     0.189     0.200
    42.698    -0.762     0.200
    43.869     0.675     0.200
    43.964    -0.886     0.200
    44.268    -0.824     0.200
    44.473     3.037     0.200
    44.558     1.360     0.200
    44.741     1.895     0.200
    45.387     1.461     0.200
    45.561     0.383     0.200
    46.049    -0.471     0.200
    46.084    -0.041     0.200
    46.168    -0.210     0.200
    46.545    -0.374     0.200
    46.692    -0.522     0.200
    46.809     1.557     0.200
    46.926     0.642     0.200
    47.386     1.058     0.200
    47.437    -1.044     0.200
    47.667     0.869     0.200
    47.811     1.758     0.200
    48.743    -1.236     0.200
    48.929     0.633     0.200
    49.028    -1.127     0.200
    50.797     0.826     0.200
    51.013    -1.696     0.200
    51.726    -1.044     0.200
    52.618    -0.172     0.200
    52.839    -0.106     0.200
    52.839    -0.207     0.200
    53.038    -0.783     0.200
    53.121    -0.491     0.200
    53.143     0.947     0.200
    53.395     0.096     0.200
    53.493    -0.125     0.200
    53.493     0.375     0.200
    53.597     0.110     0.200
    53.804     1.592     0.200
    54.004     1.128     0.200
    54.100     2.429     0.200
    54.189    -0.218     0.200
    55.120     1.024     0.200
    55.188    -0.067     0.200
    55.269    -1.055     0.200
    55.391     0.071     0.200
    55.480     1.135     0.200
    55.579    -0.286     0.200
    55.754    -0.644     0.200
    56.350    -0.099     0.200
    56.637    -0.345     0.200
    56.724     1.533     0.200
    57.234    -0.077     0.200
    57.295    -0.012     0.200
    57.943    -0.272     0.200
    58.212     0.343     0.200
    58.283     0.448     0.200
    58.325    -0.747     0.200
    58.531    -0.187     0.200
    58.598    -0.152     0.200
    58.604     0.304     0.200
    58.688    -0.573     0.200
    58.808     0.182     0.200
    58.829    -0.657     0.200
    58.899     0.051     0.200
    58.901    -0.758     0.200
    59.133    -1.072     0.200
    59.194    -0.689     0.200
    59.254    -0.207     0.200
    59.365     0.024     0.200
    59.452    -0.871     0.200
    59.471     0.691     0.200
    59.528    -0.804     0.200
    59.653    -0.964     0.200
    59.809    -1.534     0.200
    59.825    -0.944     0.200
    59.873    -0.077     0.200
    59.880    -0.325     0.200
    59.997     0.173     0.200
    60.365    -0.056     0.200
    60.457     0.419     0.200
    60.537    -0.625     0.200
    60.585    -0.754     0.200
    60.752    -0.491     0.200
    61.002    -0.689     0.200
    61.206    -0.281     0.200
    61.336    -0.558     0.200
    61.392     0.865     0.200
    61.438    -0.047     0.200
    61.472     0.019     0.200
    61.654     0.099     0.200
    61.687     0.674     0.200
    61.759    -0.924     0.200
    61.797    -0.172     0.200
    61.836     0.274     0.200
    61.878     0.684     0.200
    61.919     0.112     0.200
    62.134    -0.937     0.200
    62.186     0.020     0.200
    62.190     0.189     0.200
    62.196    -1.247     0.200
    62.262     0.311     0.200
    62.375    -1.344     0.200
    62.373    -1.255     0.200
    62.389     0.160     0.200
    62.396     0.116     0.200
    62.452    -1.680     0.200
    62.505    -1.321     0.200
    62.552     1.168     0.200
    62.586    -0.758     0.200
    62.695    -2.588     0.200
    62.702    -1.135     0.200
    62.704    -1.446     0.200
    62.705    -1.548     0.200
    62.781    -0.259     0.200
    62.783    -1.433     0.200
    62.786    -1.090     0.200
    62.837    -0.250     0.200
    62.856    -1.184     0.200
    63.002    -0.032     0.200
    63.025    -1.815     0.200
    63.115    -2.412     0.200
    63.141    -2.688     0.200
    63.155    -1.441     0.200
    63.159    -0.537     0.200
    63.180    -1.109     0.200
    63.397    -0.354     0.200
    63.566    -0.664     0.200
    63.657    -0.969     0.200
    63.746    -0.354     0.200
    63.933    -0.082     0.200
    63.963    -1.283     0.200
    63.983    -0.823     0.200
    64.225    -0.807     0.200
    64.343    -0.776     0.200
    66.009    -1.293     0.200
    66.068     0.323     0.200
    66.478    -0.407     0.200
    66.700     0.383     0.200
    66.750    -0.043     0.200
    67.090    -0.809     0.200
    67.279     0.891     0.200
    67.792     0.352     0.200
    67.797    -0.381     0.200
    69.919     1.114     0.200
    69.911    -0.839     0.200
    70.918     0.210     0.200
    71.943     0.818     0.200
    72.177     0.418     0.200
    72.222     0.353     0.200
    72.592     0.733     0.200
    72.877     0.747     0.200
    73.541    -0.179     0.200
    73.552     0.055     0.200
    73.766     0.502     0.200
    73.878     0.245     0.200
    74.494     1.546     0.200
    74.575     0.483     0.200
    75.034     0.626     0.200
    75.080    -1.243     0.200
    75.241     2.433     0.200
    75.343     2.345     0.200
    75.391    -0.329     0.200
    75.438     2.299     0.200
    75.627     0.917     0.200
    76.739     1.185     0.200
    76.757     0.786     0.200
    76.799     0.753     0.200
    77.130    -0.517     0.200
    77.416     1.085     0.200
    78.557     0.743     0.200
    78.630     1.342     0.200
    79.111     0.402     0.200
    79.131    -0.012     0.200
    79.380     1.230     0.200
    79.545     0.328     0.200
    80.726     0.956     0.200
    80.679    -0.497     0.200
    81.095    -0.013     0.200
    82.119     0.577     0.200
    83.212    -0.114     0.200
    83.215    -0.130     0.200
    89.017     0.678     0.200
    14.801     6.037     0.200
    15.522     5.395     0.200
    15.652     6.195     0.200
    15.983     4.915     0.200
    16.282     1.577     0.200
    20.685     0.768     0.200
    22.261     0.845     0.200
    24.473     1.848     0.200
    34.462     1.108     0.200
    34.535     1.677     0.200
    38.886    -0.883     0.200
    44.240     0.859     0.200
    44.649     1.756     0.200
    44.758     0.218     0.200
    45.749     0.767     0.200
    47.615     0.082     0.200
    47.951    -1.500     0.200
    49.188     0.450     0.200
    53.034    -0.111     0.200
    54.039     0.214     0.200
    54.125    -0.916     0.200
    55.207    -0.169     0.200
    55.482     0.052     0.200
    55.640    -0.083     0.200
    56.088     0.308     0.200
    58.742    -0.617     0.200
    61.065    -1.273     0.200
    61.242     0.123     0.200
    61.242    -1.279     0.200
    61.248     0.282     0.200
    61.375    -1.078     0.200
    61.569    -1.287     0.200
    61.596    -1.671     0.200
    61.599    -1.587     0.200
    62.436    -0.609     0.200
    62.837    -1.186     0.200
    63.226    -0.969     0.200
    67.776     0.396     0.200
    68.115     1.360     0.200
    72.511     1.122     0.200
    73.878     1.172     0.200
    75.137     1.016     0.200
    75.412     1.108     0.200
    76.756     1.268     0.200
    76.787     1.169     0.200
    76.851     1.135     0.200
    77.021     0.926     0.200
    77.972    -0.157     0.200
    78.268     0.218     0.200
    78.304     1.093     0.200
    79.205     0.736     0.200
    79.251     0.851     0.200
    79.324     0.909     0.200
    79.392     0.916     0.200
    79.663     0.779     0.200
    83.342     0.099     0.200
    15.395     6.386     0.200
    17.792     2.755     0.200
    19.337     0.247     0.200
    19.621     1.145     0.200
    21.058     1.527     0.200
    21.283     0.904     0.200
    22.373    -0.062     0.200
    23.819     0.485     0.200
    24.189     1.199     0.200
    24.583     0.109     0.200
    25.213    -2.682     0.200
    25.213    -3.121     0.200
    25.214    -2.037     0.200
    25.399     0.184     0.200
    25.386     0.308     0.200
    25.546    -0.148     0.200
    25.511     0.773     0.200
    25.567     0.861     0.200
    25.609     0.975     0.200
    25.752    -1.217     0.200
    26.035     0.606     0.200
    26.186    -1.345     0.200
    26.284     0.668     0.200
    26.421    -0.173     0.200
    26.423    -1.290     0.200
    27.160     1.775     0.200
    28.731     1.238     0.200
    29.202     0.055     0.200
    30.136     0.778     0.200
    30.282     1.884     0.200
    30.414    -0.680     0.200
    31.158     0.752     0.200
    31.158     1.452     0.200
    31.461    -0.411     0.200
    32.102     0.447     0.200
    32.950     0.617     0.200
    33.720    -0.694     0.200
    33.720    -0.294     0.200
    33.860    -0.315     0.200
    34.592     0.846     0.200
    34.843     1.082     0.200
    34.934     1.353     0.200
    35.156     0.897     0.200
    35.200     1.319     0.200
    35.288     1.224     0.200
    35.338     0.913     0.200
    35.367     1.663     0.200
    35.394     0.352     0.200
    35.432     1.322     0.200
    35.939     1.472     0.200
    36.551    -1.092     0.200
    36.551    -0.493     0.200
    37.149     1.439     0.200
    37.483    -1.016     0.200
    37.954    -0.001     0.200
    37.954    -1.501     0.200
    37.933     1.183     0.200
    37.933     1.584     0.200
    38.003     0.586     0.200
    38.003     0.785     0.200
    38.112    -0.132     0.200
    38.915    -1.277     0.200
    39.022     0.524     0.200
    39.108    -1.194     0.200
    39.366     0.245     0.200
    39.840     0.202     0.200
    41.045     0.225     0.200
    41.128     2.548     0.200
    41.271    -0.640     0.200
    41.372    -0.656     0.200
    41.489     0.176     0.200
    41.640     2.840     0.200
    41.895    -0.748     0.200
    41.895     0.332     0.200
    41.810     1.653     0.200
    42.075     0.286     0.200
    42.161     0.383     0.200
    42.355     0.602     0.200
    42.399    -0.859     0.200
    42.866    -0.652     0.200
    43.540    -2.098     0.200
    43.544     1.366     0.200
    43.977    -0.212     0.200
    44.200    -1.400     0.200
    44.176     0.792     0.200
    44.176     0.093     0.200
    44.562    -0.100     0.200
    44.769     1.448     0.200
    44.801     0.894     0.200
    44.923    -1.678     0.200
    45.458     0.574     0.200
    45.602     0.033     0.200
    45.710     0.678     0.200
    45.710     0.959     0.200
    45.743    -0.381     0.200
    45.902    -0.937     0.200
    45.902    -0.237     0.200
    46.015    -1.132     0.200
    46.089     1.391     0.200
    46.303     0.902     0.200
    46.298    -0.760     0.200
    46.497     0.977     0.200
    46.871    -0.554     0.200
    47.222    -0.793     0.200
    47.498    -0.642     0.200
    47.770     2.449     0.200
    48.130    -0.937     0.200
    48.352    -2.055     0.200
    48.427    -0.938     0.200
    48.366     0.139     0.200
    48.521    -0.359     0.200
    48.577     0.408     0.200
    48.796    -1.174     0.200
    48.887    -0.532     0.200
    48.887     0.096     0.200
    49.630     0.144     0.200
    49.994     0.379     0.200
    49.897     0.515     0.200
    50.003     0.909     0.200
    50.252    -0.582     0.200
    50.824    -0.398     0.200
    50.898    -1.330     0.200
    51.107    -0.029     0.200
    51.098     0.237     0.200
    51.245     0.129     0.200
    51.407    -0.483     0.200
    51.695     1.566     0.200
    51.686     0.634     0.200
    51.818     0.147     0.200
    51.947     1.986     0.200
    52.025     0.503     0.200
    52.173     1.004     0.200
    52.247     1.152     0.200
    52.437    -0.460     0.200
    52.648    -0.023     0.200
    52.721     0.435     0.200
    52.813     0.254     0.200
    52.826    -0.239     0.200
    52.879    -0.629     0.200
    52.928     0.906     0.200
    52.949     0.254     0.200
    53.058     1.449     0.200
    53.172     1.012     0.200
    53.272     0.876     0.200
    53.301    -0.339     0.200
    53.301     0.331     0.200
    53.361     0.020     0.200
    53.411     0.950     0.200
    53.609     0.897     0.200
    53.643     0.149     0.200
    53.842     0.392     0.200
    53.842    -0.247     0.200
    53.842     0.872     0.200
    53.930     0.050     0.200
    53.924     1.091     0.200
    53.964     1.896     0.200
    54.003     2.514     0.200
    54.020    -0.014     0.200
    54.020     0.197     0.200
    54.081    -1.053     0.200
    54.115     1.195     0.200
    54.208     0.015     0.200
    54.276     0.161     0.200
    54.276     0.470     0.200
    54.377     0.888     0.200
    54.429     1.406     0.200
    54.498     0.906     0.200
    54.649     1.612     0.200
    54.902     0.974     0.200
    54.920    -0.355     0.200
    54.920     0.544     0.200
    54.918    -0.141     0.200
    54.997    -0.708     0.200
    55.244     0.607     0.200
    55.305     1.068     0.200
    55.309     0.334     0.200
    55.318     0.168     0.200
    55.512    -1.924     0.200
    55.688     0.181     0.200
    55.814     0.809     0.200
    55.874    -0.027     0.200
    56.003     0.052     0.200
    56.033    -0.165     0.200
    56.076    -0.666     0.200
    56.076     0.033     0.200
    56.069    -0.422     0.200
    56.215     0.438     0.200
    56.319     0.294     0.200
    56.357     0.525     0.200
    56.377    -0.616     0.200
    56.380     0.361     0.200
    56.424     0.186     0.200
    56.538     0.237     0.200
    56.538    -0.564     0.200
    56.670     0.697     0.200
    56.670     0.268     0.200
    56.668     0.307     0.200
    56.682     0.212     0.200
    56.702     0.070     0.200
    56.702    -1.934     0.200
    56.780    -1.583     0.200
    56.828     0.173     0.200
    56.868     0.282     0.200
    56.932     0.275     0.200
    56.942     0.663     0.200
    56.962     0.720     0.200
    56.962     0.270     0.200
    56.964    -0.489     0.200
    56.964     0.329     0.200
    56.968     0.051     0.200
    56.978     0.427     0.200
    56.988     0.279     0.200
    56.999    -0.040     0.200
    57.007     0.434     0.200
    57.092     0.271     0.200
    57.138     0.173     0.200
    57.175    -0.284     0.200
    57.210     0.280     0.200
    57.230    -0.236     0.200
    57.246    -0.787     0.200
    57.251     0.180     0.200
    57.293     0.282     0.200
    57.332    -2.793     0.200
    57.310     0.060     0.200
    57.364     0.278     0.200
    57.418     0.119     0.200
    57.517    -0.502     0.200
    57.486    -0.555     0.200
    57.525    -0.103     0.200
    57.519     0.287     0.200
    57.553    -0.555     0.200
    57.559     0.006     0.200
    57.592    -0.526     0.200
    57.601     0.108     0.200
    57.652     0.151     0.200
    57.667    -0.954     0.200
    57.680    -0.848     0.200
    57.671    -2.021     0.200
    57.673    -0.296     0.200
    57.710    -0.060     0.200
    57.710    -0.191     0.200
    57.738     0.245     0.200
    57.747     0.580     0.200
    57.766    -0.453     0.200
    57.790     0.081     0.200
    57.828     0.109     0.200
    57.942     0.110     0.200
    57.987    -1.006     0.200
    57.996    -0.064     0.200
    58.016    -0.906     0.200
    58.032     0.684     0.200
    58.029     0.006     0.200
    58.018     0.077     0.200
    58.051    -0.650     0.200
    58.038     0.040     0.200
    58.100    -0.598     0.200
    58.104     0.475     0.200
    58.104     0.204     0.200
    58.099    -0.092     0.200
    58.290    -0.623     0.200
    58.303    -0.508     0.200
    58.303    -0.629     0.200
    58.301     0.097     0.200
    58.287    -0.431     0.200
    58.302    -0.010     0.200
    58.342     0.414     0.200
    58.395    -0.446     0.200
    58.386    -2.397     0.200
    58.519    -2.763     0.200
    58.558    -0.099     0.200
    58.579    -0.338     0.200
    58.585    -0.183     0.200
    58.611     0.432     0.200
    58.641     0.429     0.200
    58.650    -0.235     0.200
    58.681    -0.151     0.200
    58.663     0.074     0.200
    58.663     0.443     0.200
    58.810     0.251     0.200
    58.826     0.140     0.200
    58.860     0.502     0.200
    58.890    -0.806     0.200
    58.895    -0.339     0.200
    58.938    -0.138     0.200
    58.921     0.279     0.200
    59.017    -0.186     0.200
    59.064    -2.513     0.200
    59.077     0.097     0.200
    59.077    -0.332     0.200
    59.154    -0.834     0.200
    59.191    -2.396     0.200
    59.212     0.860     0.200
    59.227    -0.485     0.200
    59.358    -0.147     0.200
    59.465    -0.986     0.200
    59.568    -0.101     0.200
    59.572    -0.929     0.200
    59.589    -1.143     0.200
    59.601    -0.528     0.200
    59.600    -0.623     0.200
    59.671     0.122     0.200
    59.735     0.448     0.200
    59.756     0.306     0.200
    59.804    -0.125     0.200
    59.804    -0.325     0.200
    59.865    -0.443     0.200
    59.853    -0.160     0.200
    59.892    -0.233     0.200
    59.959    -0.792     0.200
    60.023    -0.133     0.200
    60.050    -0.117     0.200
    60.042     2.608     0.200
    60.099    -0.151     0.200
    60.101    -0.165     0.200
    60.172    -0.451     0.200
    60.194     0.198     0.200
    60.249     0.011     0.200
    60.258    -0.741     0.200
    60.235     0.218     0.200
    60.278    -0.777     0.200
    60.304    -0.757     0.200
    60.344    -0.432     0.200
    60.347     0.317     0.200
    60.407    -0.461     0.200
    60.468    -0.379     0.200
    60.497    -1.576     0.200
    60.536    -0.441     0.200
    60.565    -1.166     0.200
    60.623    -0.538     0.200
    60.623    -0.038     0.200
    60.623    -0.736     0.200
    60.689    -0.585     0.200
    60.738    -0.518     0.200
    60.780    -0.607     0.200
    60.789    -0.668     0.200
    60.889    -0.844     0.200
    60.971    -0.401     0.200
    60.970    -0.299     0.200
    60.994    -0.456     0.200
    61.058     0.003     0.200
    61.065    -1.243     0.200
    61.150     0.481     0.200
    61.171     0.236     0.200
    61.185    -1.053     0.200
    61.230     1.041     0.200
    61.245    -0.461     0.200
    61.385     0.091     0.200
    61.441     0.109     0.200
    61.494    -0.700     0.200
    61.498    -0.577     0.200
    61.542     0.131     0.200
    61.578     0.152     0.200
    61.588    -0.079     0.200
    61.595    -0.329     0.200
    61.649     0.406     0.200
    61.670    -0.335     0.200
    61.692     1.515     0.200
    61.887    -0.700     0.200
    61.909    -1.244     0.200
    61.958    -0.474     0.200
    61.994    -0.016     0.200
    62.089    -1.354     0.200
    62.120     0.140     0.200
    62.127     0.194     0.200
    62.151     0.129     0.200
    62.186    -2.044     0.200
    62.218    -1.120     0.200
    62.327    -1.052     0.200
    62.358     0.343     0.200
    62.363    -0.490     0.200
    62.397    -1.521     0.200
    62.399    -1.531     0.200
    62.398    -0.024     0.200
    62.418    -1.158     0.200
    62.431    -1.524     0.200
    62.433     0.144     0.200
    62.499    -1.200     0.200
    62.513    -0.494     0.200
    62.525    -1.004     0.200
    62.570     0.314     0.200
    62.596    -0.811     0.200
    62.707     3.181     0.200
    62.761    -1.570     0.200
    62.848    -1.525     0.200
    62.854    -2.525     0.200
    62.879    -2.017     0.200
    62.892    -1.022     0.200
    62.900    -0.196     0.200
    62.971     0.257     0.200
    62.987    -0.352     0.200
    62.933     0.707     0.200
    63.054     1.005     0.200
    63.138    -0.954     0.200
    63.187    -0.079     0.200
    63.211    -1.238     0.200
    63.232    -0.327     0.200
    63.278    -0.587     0.200
    63.368    -0.879     0.200
    63.389    -0.123     0.200
    63.463    -0.610     0.200
    63.482     0.264     0.200
    63.498    -0.442     0.200
    63.619     0.394     0.200
    63.672    -1.188     0.200
    63.688     0.107     0.200
    63.722    -1.018     0.200
    63.736    -0.308     0.200
    63.805     0.130     0.200
    64.009    -0.806     0.200
    64.044    -0.943     0.200
    64.159     2.834     0.200
    64.213     0.447     0.200
    64.389     0.095     0.200
    64.452    -0.713     0.200
    64.540    -0.190     0.200
    65.000     0.280     0.200
    65.064    -0.308     0.200
    65.096    -0.311     0.200
    65.116     0.526     0.200
    65.170     0.828     0.200
    65.329     1.113     0.200
    65.597    -1.362     0.200
    65.897     0.667     0.200
    66.154     0.153     0.200
    66.206    -0.281     0.200
    66.419     0.354     0.200
    66.471     0.118     0.200
    66.558     0.167     0.200
    66.558    -0.012     0.200
    66.571     0.383     0.200
    66.731     0.862     0.200
    66.806    -0.930     0.200
    66.917     1.115     0.200
    66.994     0.202     0.200
    67.072     0.920     0.200
    67.176     0.336     0.200
    67.181     0.689     0.200
    67.423     0.612     0.200
    67.426     0.284     0.200
    67.471     0.767     0.200
    67.511     0.777     0.200
    67.511     1.104     0.200
    67.542     1.020     0.200
    67.714    -0.174     0.200
    67.774     1.027     0.200
    67.946     0.674     0.200
    68.511     1.228     0.200
    68.584     1.155     0.200
    68.609    -0.089     0.200
    68.719     1.142     0.200
    68.929     1.834     0.200
    68.982     1.018     0.200
    69.150     1.093     0.200
    69.450    -0.114     0.200
    69.459    -0.373     0.200
    69.633     0.854     0.200
    69.796     1.740     0.200
    70.279     0.287     0.200
    70.625     0.542     0.200
    70.604     1.300     0.200
    71.034     0.184     0.200
    71.065    -1.906     0.200
    71.055    -0.346     0.200
    71.059     0.935     0.200
    71.193     0.882     0.200
    71.375    -0.078     0.200
    71.305     0.243     0.200
    71.414     0.915     0.200
    71.639     0.329     0.200
    71.639     0.198     0.200
    71.663     0.465     0.200
    71.711    -0.009     0.200
    71.829     0.383     0.200
    71.832     0.265     0.200
    71.878     0.432     0.200
    71.858     0.608     0.200
    72.053     0.831     0.200
    72.255    -0.322     0.200
    72.400     0.374     0.200
    72.592     0.718     0.200
    72.655     0.542     0.200
    72.809    -0.022     0.200
    73.261     0.195     0.200
    73.305     0.724     0.200
    73.430     0.718     0.200
    73.477     0.482     0.200
    73.492     0.995     0.200
    73.539    -0.297     0.200
    73.581    -0.420     0.200
    73.612    -0.065     0.200
    73.640    -0.536     0.200
    73.580     0.374     0.200
    73.744     0.610     0.200
    74.113     0.352     0.200
    74.226    -0.306     0.200
    74.280     0.663     0.200
    74.329     0.142     0.200
    74.319     0.922     0.200
    74.467    -0.510     0.200
    74.622     1.390     0.200
    74.648     1.236     0.200
    74.662     0.158     0.200
    74.700    -0.561     0.200
    74.748     0.542     0.200
    74.721     1.016     0.200
    74.753     0.630     0.200
    74.724    -0.304     0.200
    74.954     0.967     0.200
    74.953    -0.926     0.200
    75.033     1.512     0.200
    75.055     0.886     0.200
    75.152     1.327     0.200
    75.135    -0.109     0.200
    75.232     1.565     0.200
    75.289     0.157     0.200
    75.271     0.636     0.200
    75.419     0.127     0.200
    75.455     0.282     0.200
    75.480     0.341     0.200
    75.760     0.832     0.200
    76.000     0.615     0.200
    76.129     1.227     0.200
    76.152     1.201     0.200
    76.168     0.704     0.200
    76.304     0.935     0.200
    76.323     0.725     0.200
    76.322    -0.365     0.200
    76.408     0.243     0.200
    76.567     0.846     0.200
    77.007    -0.142     0.200
    77.140     1.012     0.200
    77.129     0.973     0.200
    77.042    -0.439     0.200
    77.218     0.677     0.200
    77.529     0.052     0.200
    77.527    -0.655     0.200
    77.535    -0.503     0.200
    77.740    -0.446     0.200
    77.752     0.990     0.200
    77.911     0.502     0.200
    77.987     0.382     0.200
    78.098    -0.435     0.200
    78.272     0.199     0.200
    78.536     0.241     0.200
    78.736     0.539     0.200
    78.741    -0.291     0.200
    78.815    -0.395     0.200
    78.878     0.162     0.200
    79.174    -1.461     0.200
    79.201    -0.609     0.200
    79.680     0.279     0.200
    79.727     0.123     0.200
    79.780    -0.113     0.200
    79.916    -0.200     0.200
    79.927    -0.161     0.200
    80.163    -0.833     0.200
    80.278     0.142     0.200
    80.413    -0.302     0.200
    80.455    -0.309     0.200
    80.673     0.424     0.200
    80.755     0.385     0.200
    81.080    -1.250     0.200
    81.201    -0.698     0.200
    81.088    -1.291     0.200
    81.088    -0.892     0.200
    81.397     0.666     0.200
    81.539     0.615     0.200
    82.402    -0.023     0.200
    82.556     0.175     0.200
    82.875    -0.886     0.200
    82.982    -1.142     0.200
    83.087    -0.983     0.200
    83.113    -0.018     0.200
    83.767     0.218     0.200
    83.857    -0.646     0.200
    83.923    -1.283     0.200
    84.762    -0.139     0.200
    84.793    -0.294     0.200
    84.946    -0.567     0.200
    85.183     0.148     0.200
    85.190    -0.586     0.200
    85.661    -0.439     0.200
    85.855    -0.102     0.200
    86.210    -1.055     0.200
    86.341    -1.196     0.200
    86.602    -0.780     0.200
    86.997    -1.410     0.200
    86.997    -1.511     0.200
    87.346    -1.208     0.200
    87.664    -1.240     0.200
    87.700    -1.110     0.200
    87.825    -0.805     0.200
    88.864    -0.617     0.200
    88.907    -0.219     0.200
    88.998    -0.851     0.200
    89.200    -0.879     0.200
    89.200    -1.099     0.200
    89.269     1.281     0.200
    89.299     1.535     0.200
    89.516     0.123     0.200
    90.297    -1.027     0.200
    90.438    -0.685     0.200
    90.565    -1.074     0.200
    90.565    -1.574     0.200
    92.525     2.341     0.200
    94.625     0.877     0.200
    95.624     0.012     0.200
    98.159    -1.673     0.200
    15.038     5.562     0.200
    16.362     1.684     0.200
    19.821     0.846     0.200
    20.845     1.216     0.200
    22.231     0.838     0.200
    24.571     2.462     0.200
    45.336     0.221     0.200
    47.798    -1.685     0.200
    75.355    -1.020     0.200
    81.649    -2.038     0.200
    16.045     3.821     0.200
    20.292    -0.033     0.200
    21.002    -2.891     0.200
    37.392    -1.498     0.200
    37.962    -1.381     0.200
    41.199    -0.690     0.200
    41.650    -0.786     0.200
    45.632     0.250     0.200
    47.618    -1.110     0.200
    47.618    -0.659     0.200
    56.482    -2.244     0.200
    16.566     4.104     0.200
    20.419     1.913     0.200
    21.352     1.171     0.200
    38.701    -0.943     0.200
    42.540    -0.322     0.200
    77.579    -1.481     0.200
    81.127    -0.835     0.200
    20.482    -0.870     0.200
    16.265     4.718     0.200
    16.299     1.482     0.200
    16.299     1.381     0.200
    16.320     1.440     0.200
    18.310     1.499     0.200
    20.230    -0.478     0.200
    20.590     0.643     0.200
    21.060     1.259     0.200
    21.060     0.662     0.200
    21.191     2.087     0.200
    21.364     2.081     0.200
    21.364     1.452     0.200
    21.610     1.845     0.200
    21.647     1.420     0.200
    22.046     0.773     0.200
    23.081     0.635     0.200
    23.357    -2.111     0.200
    23.782    -1.094     0.200
    23.782    -1.243     0.200
    24.532    -0.637     0.200
    24.525     2.027     0.200
    24.897     0.336     0.200
    25.551     1.696     0.200
    25.672     1.595     0.200
    25.772     0.131     0.200
    25.853     0.159     0.200
    26.473     1.722     0.200
    26.589     1.752     0.200
    26.603    -1.518     0.200
    26.603    -2.119     0.200
    26.730     0.860     0.200
    26.771     1.664     0.200
    26.894     2.879     0.200
    26.955     0.705     0.200
    27.124     2.807     0.200
    27.153     1.960     0.200
    27.171     0.156     0.200
    27.421     1.193     0.200
    27.529     1.950     0.200
    27.565    -0.476     0.200
    28.555     0.790     0.200
    28.615     2.364     0.200
    28.779    -0.299     0.200
    29.734     0.729     0.200
    29.974     2.808     0.200
    29.974     3.109     0.200
    30.897    -2.349     0.200
    31.488     0.746     0.200
    31.507     0.678     0.200
    33.573     0.675     0.200
    33.619     1.672     0.200
    33.856     1.816     0.200
    33.922     1.844     0.200
    33.960     0.810     0.200
    33.971     2.120     0.200
    34.001     1.453     0.200
    34.086     1.915     0.200
    34.524     0.425     0.200
    34.548     2.114     0.200
    34.787     0.649     0.200
    34.998    -0.372     0.200
    34.998     0.226     0.200
    35.447    -1.136     0.200
    35.447    -0.535     0.200
    35.447    -1.476     0.200
    36.007    -2.440     0.200
    36.558    -1.053     0.200
    36.917    -0.236     0.200
    36.948     2.426     0.200
    37.360    -0.573     0.200
    37.436    -0.517     0.200
    37.462     0.264     0.200
    37.787     0.031     0.200
    37.930    -1.059     0.200
    37.930    -0.907     0.200
    38.026     1.799     0.200
    38.316     0.857     0.200
    38.663     1.164     0.200
    38.742    -1.027     0.200
    39.465     1.727     0.200
    39.465     1.574     0.200
    39.541    -1.506     0.200
    39.629    -0.974     0.200
    40.146     1.266     0.200
    40.385    -1.222     0.200
    40.733    -0.895     0.200
    40.996    -1.766     0.200
    41.158    -1.298     0.200
    41.150     0.160     0.200
    41.303     0.515     0.200
    41.608    -1.092     0.200
    41.988    -2.898     0.200
    42.400     1.623     0.200
    42.623     0.032     0.200
    42.623     0.329     0.200
    43.241    -2.228     0.200
    43.612    -0.864     0.200
    43.600     0.226     0.200
    43.726     0.008     0.200
    43.732    -1.185     0.200
    43.980    -0.031     0.200
    43.980     1.368     0.200
    43.980     1.481     0.200
    44.088     1.101     0.200
    44.328     1.379     0.200
    44.751    -2.521     0.200
    44.859    -1.060     0.200
    44.869     0.250     0.200
    45.289     1.122     0.200
    45.647    -0.013     0.200
    45.673    -0.521     0.200
    45.848     2.095     0.200
    46.249     0.736     0.200
    46.649    -0.002     0.200
    46.861    -1.860     0.200
    46.959    -1.127     0.200
    46.959    -0.526     0.200
    47.289    -0.500     0.200
    47.449     1.553     0.200
    47.581    -1.474     0.200
    47.581    -0.899     0.200
    47.678    -0.456     0.200
    47.671     0.629     0.200
    47.831    -0.965     0.200
    47.844     1.364     0.200
    47.844     1.926     0.200
    48.425     0.966     0.200
    48.881     0.160     0.200
    49.116     1.028     0.200
    49.116     0.887     0.200
    49.109    -1.750     0.200
    49.144    -2.525     0.200
    49.239    -0.256     0.200
    49.282     1.274     0.200
    49.370     0.565     0.200
    49.436     0.640     0.200
    49.674     0.229     0.200
    49.752     2.333     0.200
    49.851     1.691     0.200
    50.011     0.133     0.200
    50.145    -0.651     0.200
    50.190     1.277     0.200
    50.420     0.315     0.200
    50.430     1.487     0.200
    50.770     0.324     0.200
    50.834     0.140     0.200
    51.067     0.384     0.200
    51.279    -0.502     0.200
    51.358     0.706     0.200
    51.487     0.367     0.200
    51.487     3.648     0.200
    51.520     1.386     0.200
    51.682     2.174     0.200
    51.722     0.477     0.200
    51.767     0.453     0.200
    51.789     0.382     0.200
    51.857    -0.025     0.200
    51.909    -0.135     0.200
    51.909     0.904     0.200
    52.216     2.600     0.200
    52.411     1.050     0.200
    52.537     0.017     0.200
    52.731    -0.325     0.200
    52.875     0.519     0.200
    52.959     2.195     0.200
    53.304     1.254     0.200
    53.431     0.322     0.200
    53.545    -0.514     0.200
    53.556    -0.395     0.200
    53.651    -0.190     0.200
    53.646     1.747     0.200
    53.891     0.057     0.200
    54.046     1.717     0.200
    54.282     0.701     0.200
    54.384    -0.039     0.200
    54.385    -0.652     0.200
    54.720    -0.084     0.200
    54.735    -0.295     0.200
    54.735     0.305     0.200
    54.782    -0.036     0.200
    54.902    -0.054     0.200
    54.987     0.381     0.200
    55.139     0.086     0.200
    55.142    -0.125     0.200
    55.175    -0.375     0.200
    55.431    -0.573     0.200
    55.486     1.883     0.200
    55.611     0.187     0.200
    55.611     0.187     0.200
    55.621     0.312     0.200
    55.644    -0.754     0.200
    55.769     0.024     0.200
    55.768    -0.146     0.200
    56.078    -0.666     0.200
    56.402    -0.277     0.200
    56.484     0.737     0.200
    56.511    -2.258     0.200
    56.520     0.585     0.200
    56.535    -0.838     0.200
    56.570     0.896     0.200
    56.610     0.237     0.200
    56.612     0.827     0.200
    56.625    -1.393     0.200
    56.717     0.387     0.200
    56.798    -1.782     0.200
    56.841    -0.798     0.200
    56.866    -1.145     0.200
    56.953    -0.590     0.200
    57.037    -0.445     0.200
    57.039    -0.003     0.200
    57.112    -1.501     0.200
    57.161    -0.594     0.200
    57.218     0.935     0.200
    57.245     0.945     0.200
    57.268    -1.582     0.200
    57.269    -1.439     0.200
    57.392    -0.993     0.200
    57.422     0.793     0.200
    57.469     1.063     0.200
    57.481     0.978     0.200
    57.543    -1.901     0.200
    57.617     0.519     0.200
    57.621    -1.253     0.200
    57.631    -1.364     0.200
    57.789     0.849     0.200
    57.866    -0.232     0.200
    57.890    -1.196     0.200
    57.890    -0.497     0.200
    57.999    -1.767     0.200
    58.009     1.568     0.200
    58.245     0.118     0.200
    58.278    -1.318     0.200
    58.347     0.604     0.200
    58.378    -0.414     0.200
    58.395     0.866     0.200
    58.411     0.259     0.200
    58.530     2.487     0.200
    58.612     0.750     0.200
    58.730     0.331     0.200
    58.771     0.445     0.200
    58.814     0.651     0.200
    58.908     0.793     0.200
    58.918    -1.678     0.200
    58.927     0.162     0.200
    58.968     0.177     0.200
    58.969    -0.531     0.200
    59.083     0.278     0.200
    59.148    -1.269     0.200
    59.175     0.239     0.200
    59.290     0.148     0.200
    59.426    -0.396     0.200
    59.477     0.156     0.200
    59.763     0.282     0.200
    59.804     0.503     0.200
    59.852     0.971     0.200
    60.020    -0.379     0.200
    60.025     0.586     0.200
    60.070    -0.042     0.200
    60.097    -0.561     0.200
    60.153    -0.396     0.200
    60.165     0.023     0.200
    60.163     0.737     0.200
    60.184    -1.409     0.200
    60.231    -0.052     0.200
    60.245    -0.258     0.200
    60.260    -0.029     0.200
    60.301     0.023     0.200
    60.321    -1.217     0.200
    60.511    -0.735     0.200
    60.629     0.323     0.200
    60.718    -0.832     0.200
    60.767    -0.688     0.200
    60.814    -1.378     0.200
    61.055    -2.025     0.200
    61.128    -2.303     0.200
    61.204    -1.953     0.200
    61.201    -0.489     0.200
    61.205    -1.940     0.200
    61.268    -1.488     0.200
    61.275     1.361     0.200
    61.362    -0.827     0.200
    61.382    -1.714     0.200
    61.406     0.176     0.200
    61.494    -1.590     0.200
    61.494    -1.590     0.200
    61.503    -0.991     0.200
    61.537    -0.709     0.200
    61.595    -0.502     0.200
    61.637    -1.896     0.200
    61.645     0.262     0.200
    61.711    -0.583     0.200
    61.746    -1.517     0.200
    61.775    -0.412     0.200
    61.846    -0.692     0.200
    61.884    -0.344     0.200
    61.951    -0.199     0.200
    62.068    -1.085     0.200
    62.077    -0.743     0.200
    62.124    -0.361     0.200
    62.124    -0.361     0.200
    62.177    -1.416     0.200
    62.407    -1.960     0.200
    62.489    -0.902     0.200
    62.518    -0.397     0.200
    62.553    -0.931     0.200
    62.576    -1.687     0.200
    62.778    -1.936     0.200
    62.795    -1.748     0.200
    62.796    -2.056     0.200
    62.919    -1.869     0.200
    62.957     0.177     0.200
    63.017    -0.622     0.200
    63.151    -0.814     0.200
    63.235    -1.971     0.200
    63.779    -1.962     0.200
    64.449    -1.061     0.200
    64.854    -0.609     0.200
    65.239    -0.314     0.200
    65.500    -1.602     0.200
    65.865     0.803     0.200
    65.986    -0.439     0.200
    66.088    -1.390     0.200
    66.506     0.030     0.200
    66.556     2.156     0.200
    66.895     2.123     0.200
    66.916     0.964     0.200
    67.011     0.327     0.200
    67.263     0.248     0.200
    67.549    -0.140     0.200
    67.627     1.815     0.200
    67.693     0.187     0.200
    68.075     0.887     0.200
    68.288     1.123     0.200
    68.333     0.528     0.200
    68.462    -0.041     0.200
    68.483    -0.366     0.200
    68.657     3.042     0.200
    69.215     0.167     0.200
    69.301     0.294     0.200
    69.374     0.492     0.200
    69.418    -0.182     0.200
    69.501    -1.219     0.200
    69.740     0.428     0.200
    69.882     0.353     0.200
    70.089     0.096     0.200
    70.089     0.596     0.200
    70.089    -0.096     0.200
    70.236     0.883     0.200
    70.252     0.685     0.200
    70.697    -0.201     0.200
    70.703     0.030     0.200
    70.800    -0.159     0.200
    70.818     0.119     0.200
    70.932     0.243     0.200
    70.932    -0.089     0.200
    71.071     2.538     0.200
    71.285     2.758     0.200
    71.286     1.994     0.200
    71.382     1.910     0.200
    71.698    -1.669     0.200
    71.698    -2.462     0.200
    72.191    -0.149     0.200
    72.260    -0.213     0.200
    72.299     2.225     0.200
    72.402     0.190     0.200
    72.481    -0.414     0.200
    72.826     1.408     0.200
    72.835     0.485     0.200
    72.860     0.468     0.200
    73.013     0.518     0.200
    73.091     0.598     0.200
    73.096     0.179     0.200
    73.186     0.733     0.200
    73.414     0.091     0.200
    73.518     0.546     0.200
    73.850     0.630     0.200
    74.647    -1.404     0.200
    74.753     1.069     0.200
    74.802    -0.314     0.200
    75.231     0.620     0.200
    75.451     1.242     0.200
    75.668    -0.801     0.200
    75.844    -1.007     0.200
    76.160     0.447     0.200
    76.503     0.147     0.200
    76.883     0.602     0.200
    76.932     0.325     0.200
    77.077     1.008     0.200
    77.195    -0.212     0.200
    77.572     0.133     0.200
    78.111    -0.265     0.200
    78.111    -1.207     0.200
    78.118    -0.744     0.200
    78.812     1.443     0.200
    78.919    -0.122     0.200
    79.506     0.367     0.200
    79.749    -0.951     0.200
    79.882     1.403     0.200
    80.191    -0.433     0.200
    80.217     1.115     0.200
    80.243     0.315     0.200
    80.387     0.401     0.200
    80.747     0.974     0.200
    80.876     0.304     0.200
    81.342     0.004     0.200
    81.342    -0.797     0.200
    81.464    -0.212     0.200
    81.643    -0.541     0.200
    81.643    -0.290     0.200
    81.819     0.252     0.200
    81.866     0.332     0.200
    81.892    -0.504     0.200
    82.113     1.125     0.200
    82.113     0.758     0.200
    82.299    -1.147     0.200
    82.634     0.185     0.200
    82.941     0.518     0.200
    83.342    -0.795     0.200
    83.822     0.679     0.200
    83.995     0.295     0.200
    84.328    -1.495     0.200
    84.888     0.931     0.200
    84.917    -0.168     0.200
    84.962     1.001     0.200
    86.009     0.089     0.200
    86.397     2.137     0.200
    86.760    -1.007     0.200
    87.429    -1.156     0.200
    87.742    -1.158     0.200
    87.847    -0.752     0.200
    89.830    -0.096     0.200
    89.886     0.241     0.200
    89.886     0.541     0.200
    91.260    -0.850     0.200
    98.803    -0.895     0.200
    98.904    -1.748     0.200
    18.305     2.062     0.200
    20.191    -0.484     0.200
    20.191    -0.335     0.200
    23.132    -1.811     0.200
    23.307    -1.202     0.200
    23.688    -0.934     0.200
    23.733    -0.564     0.200
    25.680     1.903     0.200
    25.888     2.317     0.200
    26.323     1.405     0.200
    26.690     1.089     0.200
    26.731    -0.165     0.200
    26.915     1.246     0.200
    27.432     0.097     0.200
    27.432     1.379     0.200
    27.515    -1.040     0.200
    28.728    -0.570     0.200
    31.515     0.591     0.200
    33.603     1.197     0.200
    33.839     1.249     0.200
    33.869     1.560     0.200
    33.903     1.281     0.200
    33.951     1.774     0.200
    34.294     1.488     0.200
    34.528     1.461     0.200
    35.961    -1.473     0.200
    36.744    -0.525     0.200
    36.878    -0.737     0.200
    36.960    -1.894     0.200
    37.326    -1.329     0.200
    37.317    -2.530     0.200
    37.706    -0.683     0.200
    37.887    -0.901     0.200
    38.668     0.577     0.200
    39.601     0.473     0.200
    40.335    -1.425     0.200
    41.036    -1.691     0.200
    41.127     0.242     0.200
    41.111    -2.429     0.200
    41.252    -0.692     0.200
    41.560    -0.676     0.200
    43.018     0.900     0.200
    43.197    -2.344     0.200
    43.930    -0.055     0.200
    43.930     1.305     0.200
    44.279     1.352     0.200
    45.364     1.205     0.200
    45.684    -0.326     0.200
    45.786    -0.840     0.200
    47.186    -0.851     0.200
    47.239    -0.341     0.200
    47.535    -1.044     0.200
    47.535    -0.684     0.200
    49.859     0.874     0.200
    50.140     2.010     0.200
    50.380    -0.057     0.200
    51.303     1.672     0.200
    51.307     1.399     0.200
    51.334    -0.841     0.200
    51.474     0.005     0.200
    51.672     1.030     0.200
    51.981     0.701     0.200
    51.982     1.916     0.200
    52.488    -0.146     0.200
    52.826     0.558     0.200
    53.507     0.042     0.200
    53.602    -0.463     0.200
    53.729     1.313     0.200
    53.807     0.736     0.200
    53.840     0.640     0.200
    53.882     0.391     0.200
    54.627     0.362     0.200
    54.686     0.233     0.200
    54.938     0.216     0.200
    55.092     0.057     0.200
    55.381     0.207     0.200
    55.562     0.614     0.200
    55.562     0.614     0.200
    55.571     0.943     0.200
    56.410     1.028     0.200
    56.434     1.367     0.200
    56.511    -1.981     0.200
    56.563     1.353     0.200
    56.765     0.180     0.200
    57.114    -0.250     0.200
    57.195     1.264     0.200
    57.372     0.513     0.200
    57.419     0.987     0.200
    58.230    -1.204     0.200
    58.428     0.666     0.200
    58.566     1.513     0.200
    58.708     1.043     0.200
    58.777     0.789     0.200
    58.869    -1.664     0.200
    58.974     0.704     0.200
    59.099    -1.461     0.200
    59.351     0.844     0.200
    59.540    -0.114     0.200
    60.112     1.054     0.200
    60.717    -0.877     0.200
    60.876    -1.866     0.200
    61.065    -1.343     0.200
    61.132    -1.696     0.200
    61.138    -1.840     0.200
    61.155    -1.657     0.200
    61.313    -1.326     0.200
    61.554    -1.252     0.200
    61.588    -1.484     0.200
    61.649     0.026     0.200
    61.696    -1.313     0.200
    62.033    -1.375     0.200
    62.361     0.870     0.200
    62.658     0.837     0.200
    62.748    -1.861     0.200
    63.094     1.265     0.200
    65.451    -1.720     0.200
    65.938    -1.555     0.200
    70.041    -0.216     0.200
    72.196    -0.013     0.200
    75.673    -0.862     0.200
    76.895     0.155     0.200
    78.154    -0.831     0.200
    81.679    -0.517     0.200
    82.073     1.654     0.200
    86.009     0.491     0.200
    20.219    -0.489     0.200
    23.338    -1.317     0.200
    23.719    -1.114     0.200
    23.764    -2.440     0.200
    24.542     0.261     0.200
    37.910    -0.784     0.200
    41.587    -1.139     0.200
    47.560    -1.632     0.200
    78.136     0.292     0.200
    20.164    -0.624     0.200
    23.278    -1.878     0.200
    23.659    -1.614     0.200
    23.704    -1.342     0.200
    29.947    -1.236     0.200
    37.868    -1.393     0.200
    41.538    -1.697     0.200
    44.010    -3.186     0.200
    45.758    -2.009     0.200
    47.514    -1.081     0.200
    47.514    -1.234     0.200
    21.257    -0.009     0.200
    21.347     2.217     0.200
    45.512    -0.188     0.200
    16.643     3.547     0.200
    21.372     0.352     0.200
    25.019     0.667     0.200
    42.715    -0.560     0.200
    47.118     0.710     0.200
    45.818     2.224     0.200
    15.344     4.863     0.200
    15.746     6.009     0.200
    17.076     3.233     0.200
    17.793     2.005     0.200
    19.445     1.368     0.200
    19.649     0.903     0.200
    20.142     0.459     0.200
    20.280     1.626     0.200
    20.669     1.280     0.200
    20.669     0.740     0.200
    21.262     0.832     0.200
    21.425    -0.619     0.200
    21.912    -0.569     0.200
    21.967    -0.151     0.200
    21.967     0.259     0.200
    25.232    -1.449     0.200
    25.473    -0.740     0.200
    25.517    -1.082     0.200
    25.432    -0.362     0.200
    25.501     1.003     0.200
    25.577     0.021     0.200
    26.202    -0.143     0.200
    26.202    -0.444     0.200
    26.263    -1.900     0.200
    26.264     0.990     0.200
    28.101     2.701     0.200
    28.699     2.767     0.200
    29.159     3.305     0.200
    29.177    -0.784     0.200
    30.120     2.561     0.200
    30.389    -2.022     0.200
    30.801     0.447     0.200
    30.801     0.447     0.200
    32.083    -0.044     0.200
    33.048    -1.597     0.200
    36.561     0.658     0.200
    36.735    -1.533     0.200
    37.104    -0.567     0.200
    37.136    -0.238     0.200
    37.485    -1.309     0.200
    38.336    -2.285     0.200
    38.905    -1.464     0.200
    39.985    -1.577     0.200
    41.024     2.525     0.200
    41.513     0.508     0.200
    41.874    -1.649     0.200
    42.384    -1.511     0.200
    42.383     0.600     0.200
    42.849    -0.690     0.200
    42.850    -1.104     0.200
    42.850    -1.002     0.200
    42.887    -1.096     0.200
    44.184    -2.056     0.200
    44.198     0.095     0.200
    44.198     0.435     0.200
    44.515    -0.314     0.200
    45.682    -0.020     0.200
    45.682     0.113     0.200
    46.321    -0.672     0.200
    46.475     0.189     0.200
    46.841    -0.101     0.200
    46.840    -0.174     0.200
    47.524    -2.829     0.200
    47.523    -0.707     0.200
    48.096    -1.261     0.200
    48.096    -1.784     0.200
    48.068    -1.454     0.200
    48.689    -0.544     0.200
    48.689    -1.044     0.200
    48.941    -1.053     0.200
    49.889     0.432     0.200
    50.239    -0.626     0.200
    50.239    -0.075     0.200
    50.800    -3.515     0.200
    51.146    -0.516     0.200
    51.893    -0.583     0.200
    52.587     0.134     0.200
    52.707    -0.254     0.200
    52.720     0.252     0.200
    52.806    -0.089     0.200
    52.986    -0.214     0.200
    53.033     0.533     0.200
    53.151     0.766     0.200
    53.262    -0.962     0.200
    53.278     0.796     0.200
    53.685    -0.877     0.200
    53.737     0.159     0.200
    53.739    -1.073     0.200
    53.746    -0.927     0.200
    53.756     0.786     0.200
    53.814    -0.822     0.200
    53.912     0.556     0.200
    53.911     0.088     0.200
    54.136    -0.404     0.200
    54.136     0.244     0.200
    54.257     0.559     0.200
    54.278     0.209     0.200
    54.419    -0.038     0.200
    54.419     0.481     0.200
    54.487     0.492     0.200
    54.889     0.075     0.200
    54.902    -0.126     0.200
    54.979    -0.779     0.200
    55.282     0.532     0.200
    55.300     0.302     0.200
    55.400     0.379     0.200
    55.685    -0.432     0.200
    55.746    -1.763     0.200
    55.874     0.074     0.200
    56.016     0.356     0.200
    56.058    -0.041     0.200
    56.249     0.795     0.200
    56.254    -0.282     0.200
    56.346     0.197     0.200
    56.358     0.113     0.200
    56.470     0.220     0.200
    56.519    -0.033     0.200
    56.519    -0.733     0.200
    56.598    -0.695     0.200
    56.651     0.426     0.200
    56.945     0.441     0.200
    56.945     0.441     0.200
    57.010    -0.958     0.200
    57.907     0.432     0.200
    58.005    -1.052     0.200
    58.012     1.117     0.200
    58.288    -0.905     0.200
    58.363    -0.350     0.200
    58.379    -0.230     0.200
    58.504    -0.124     0.200
    58.807    -0.233     0.200
    58.879    -0.417     0.200
    59.060    -0.396     0.200
    59.138    -0.892     0.200
    59.204     0.599     0.200
    59.210    -0.831     0.200
    59.247    -0.887     0.200
    59.342    -0.425     0.200
    59.524    -0.899     0.200
    59.584    -0.518     0.200
    60.228    -0.841     0.200
    60.287    -0.851     0.200
    60.396    -1.194     0.200
    60.423    -0.578     0.200
    61.502    -1.508     0.200
    61.628     1.008     0.200
    61.892    -1.142     0.200
    62.102     0.148     0.200
    62.109     0.302     0.200
    62.202    -1.022     0.200
    62.383    -1.535     0.200
    62.384    -1.642     0.200
    62.401    -1.256     0.200
    62.483    -1.300     0.200
    62.715     0.345     0.200
    62.833    -1.540     0.200
    62.876    -1.025     0.200
    62.942     0.437     0.200
    63.119     0.260     0.200
    63.260    -1.901     0.200
    63.352    -0.986     0.200
    63.479    -0.326     0.200
    63.501    -0.572     0.200
    63.583    -1.112     0.200
    63.703    -0.908     0.200
    63.780    -0.914     0.200
    63.830    -0.542     0.200
    63.945    -1.701     0.200
    64.029    -0.956     0.200
    64.090    -0.857     0.200
    64.194    -0.886     0.200
    64.435    -0.821     0.200
    64.475     0.117     0.200
    64.523    -0.395     0.200
    65.048    -0.217     0.200
    65.205    -0.472     0.200
    65.426    -0.159     0.200
    65.493    -0.447     0.200
    65.617    -1.426     0.200
    65.660     0.047     0.200
    65.760    -0.129     0.200
    65.708    -0.496     0.200
    65.795    -0.723     0.200
    65.805    -0.216     0.200
    65.932    -0.173     0.200
    65.970    -0.319     0.200
    66.000     0.836     0.200
    66.155    -0.503     0.200
    66.304    -0.483     0.200
    66.359    -0.382     0.200
    66.451    -0.542     0.200
    66.653    -0.256     0.200
    66.790    -0.730     0.200
    66.763     0.089     0.200
    66.767     0.310     0.200
    66.983    -0.123     0.200
    66.992    -0.119     0.200
    67.079     0.675     0.200
    67.098     0.382     0.200
    67.265    -1.555     0.200
    67.247    -0.099     0.200
    67.262     0.067     0.200
    67.440    -0.134     0.200
    67.453    -0.080     0.200
    67.487    -0.229     0.200
    67.538    -0.385     0.200
    67.674    -0.426     0.200
    67.699    -0.411     0.200
    67.697    -0.274     0.200
    67.738    -0.553     0.200
    67.924    -0.332     0.200
    67.919     0.373     0.200
    68.045     0.561     0.200
    68.078     0.341     0.200
    68.123     0.582     0.200
    68.181    -0.272     0.200
    68.302     0.120     0.200
    68.373     0.184     0.200
    68.416     0.218     0.200
    68.467     0.303     0.200
    68.657     0.299     0.200
    68.767     0.503     0.200
    68.858     0.135     0.200
    68.928    -0.267     0.200
    69.023    -0.394     0.200
    69.075     0.201     0.200
    69.075     0.538     0.200
    69.231     0.006     0.200
    69.236     0.349     0.200
    69.324    -0.235     0.200
    69.428     0.271     0.200
    69.469    -1.263     0.200
    69.469    -1.529     0.200
    69.436     0.620     0.200
    69.458     0.942     0.200
    69.470     0.243     0.200
    69.546     0.038     0.200
    69.628     0.393     0.200
    69.708     0.430     0.200
    69.721     0.264     0.200
    69.855     0.118     0.200
    69.860     0.731     0.200
    69.873    -1.196     0.200
    69.873    -0.539     0.200
    69.961    -0.108     0.200
    69.990     0.461     0.200
    70.035     0.327     0.200
    70.072     0.479     0.200
    70.135     1.073     0.200
    70.124    -0.786     0.200
    70.203     1.328     0.200
    70.228     0.400     0.200
    70.233     0.487     0.200
    70.257     0.648     0.200
    70.266     0.055     0.200
    70.329     1.133     0.200
    70.400     0.327     0.200
    70.413     1.069     0.200
    70.464    -0.156     0.200
    70.480    -0.479     0.200
    70.529     0.047     0.200
    70.808     0.166     0.200
    70.818     0.023     0.200
    70.828     1.186     0.200
    70.930    -0.494     0.200
    70.958     0.585     0.200
    71.017     0.649     0.200
    71.023     0.684     0.200
    71.030     0.249     0.200
    71.050     0.137     0.200
    71.084    -0.546     0.200
    71.183    -0.116     0.200
    71.189     0.427     0.200
    71.220     0.354     0.200
    71.359     0.133     0.200
    71.359     0.164     0.200
    71.290     0.330     0.200
    71.322     1.041     0.200
    71.450     0.384     0.200
    71.461     0.741     0.200
    71.471    -0.537     0.200
    71.531    -0.125     0.200
    71.623     0.372     0.200
    71.578     0.619     0.200
    71.636     1.219     0.200
    71.639     1.005     0.200
    71.660     0.304     0.200
    71.854     0.450     0.200
    71.870     0.912     0.200
    71.931     0.165     0.200
    71.954     0.665     0.200
    72.079     0.380     0.200
    72.123     0.605     0.200
    72.161     0.747     0.200
    72.165     0.518     0.200
    72.177     0.912     0.200
    72.197     1.279     0.200
    72.276     0.457     0.200
    72.284     0.170     0.200
    72.283     0.144     0.200
    72.383     0.691     0.200
    72.396     0.987     0.200
    72.481     0.003     0.200
    72.496     0.267     0.200
    72.496     0.693     0.200
    72.502     0.850     0.200
    72.539     0.902     0.200
    72.553     0.977     0.200
    72.657     0.399     0.200
    72.671     0.768     0.200
    72.721     0.488     0.200
    72.783     0.803     0.200
    72.811     1.087     0.200
    72.833     1.619     0.200
    72.924     0.750     0.200
    73.020     1.167     0.200
    73.039     0.706     0.200
    73.053     0.959     0.200
    73.135     0.746     0.200
    73.141     0.966     0.200
    73.166     1.015     0.200
    73.183     0.759     0.200
    73.279     0.169     0.200
    73.421     1.258     0.200
    73.419     1.149     0.200
    73.428     0.523     0.200
    73.473     0.099     0.200
    73.567     0.658     0.200
    73.567    -0.576     0.200
    73.611     0.937     0.200
    73.645     0.713     0.200
    73.651     0.710     0.200
    73.715     0.227     0.200
    73.718     0.511     0.200
    73.807     1.489     0.200
    73.799     0.947     0.200
    73.866     1.090     0.200
    73.947     1.059     0.200
    73.997     1.375     0.200
    74.120     0.297     0.200
    74.254     1.374     0.200
    74.258     0.465     0.200
    74.436     0.538     0.200
    74.453    -0.655     0.200
    74.453    -1.319     0.200
    74.553     0.308     0.200
    74.551     0.440     0.200
    74.691     1.232     0.200
    74.718     1.380     0.200
    74.724    -1.059     0.200
    74.724    -1.228     0.200
    74.845     0.719     0.200
    74.993     0.819     0.200
    75.017    -0.579     0.200
    75.017     0.913     0.200
    75.153     0.605     0.200
    75.166     0.537     0.200
    75.158    -0.382     0.200
    75.163    -0.120     0.200
    75.234     0.069     0.200
    75.316    -0.031     0.200
    75.331     0.069     0.200
    75.340     0.596     0.200
    75.488     0.417     0.200
    75.512     0.189     0.200
    75.718     0.595     0.200
    75.736    -0.003     0.200
    75.765     0.700     0.200
    75.876     0.259     0.200
    75.943     0.613     0.200
    75.998     0.253     0.200
    76.046     0.215     0.200
    76.063     0.408     0.200
    76.304     0.551     0.200
    76.316     0.537     0.200
    76.347     0.337     0.200
    76.414     0.514     0.200
    76.475     0.373     0.200
    76.576     0.887     0.200
    76.608     0.840     0.200
    76.635     0.650     0.200
    76.751     0.498     0.200
    76.773     0.676     0.200
    76.799     0.905     0.200
    77.020    -0.118     0.200
    77.030    -1.162     0.200
    77.129    -0.084     0.200
    77.154    -1.456     0.200
    77.347     0.196     0.200
    77.348     0.604     0.200
    77.512     0.787     0.200
    77.529    -1.098     0.200
    77.531    -1.209     0.200
    77.893     0.618     0.200
    78.057     0.885     0.200
    78.138     0.886     0.200
    78.236     1.390     0.200
    78.304     0.822     0.200
    78.547     0.328     0.200
    78.582     0.608     0.200
    78.789     0.376     0.200
    78.999     0.305     0.200
    79.062     0.405     0.200
    79.072     0.347     0.200
    79.262     0.520     0.200
    79.339     0.089     0.200
    79.656     0.540     0.200
    79.695     0.694     0.200
    79.941     0.410     0.200
    80.074     0.959     0.200
    80.141    -0.250     0.200
    80.288     0.631     0.200
    80.463     0.251     0.200
    80.445    -0.590     0.200
    80.445    -1.848     0.200
    80.521    -0.183     0.200
    80.546     0.017     0.200
    80.689     0.719     0.200
    80.700    -0.049     0.200
    80.700     0.084     0.200
    80.766     0.350     0.200
    80.766     0.971     0.200
    80.763     0.855     0.200
    80.773     0.491     0.200
    80.916     0.287     0.200
    81.029     0.443     0.200
    81.089    -0.933     0.200
    81.203     0.519     0.200
    81.278     0.308     0.200
    81.358     0.863     0.200
    81.412     0.762     0.200
    81.468     0.426     0.200
    81.644     0.289     0.200
    81.744     1.167     0.200
    81.863     0.281     0.200
    82.222     0.899     0.200
    82.859     0.187     0.200
    83.153     0.347     0.200
    83.544     0.412     0.200
    83.967     0.289     0.200
    84.367     0.085     0.200
    84.419    -1.136     0.200
    84.426    -0.370     0.200
    84.954     0.479     0.200
    85.205    -0.684     0.200
    85.251     0.455     0.200
    86.214    -0.518     0.200
    87.251    -1.088     0.200
    87.320    -1.020     0.200
    88.931    -0.977     0.200
    91.446     0.113     0.200
    15.096     7.733     0.200
    15.223     7.069     0.200
    15.971     6.124     0.200
    17.416     2.289     0.200
    18.821     1.062     0.200
    20.183     1.277     0.200
    20.410     1.610     0.200
    20.731     0.833     0.200
    20.844     0.960     0.200
    20.863     2.396     0.200
    21.317     0.909     0.200
    21.317    -0.591     0.200
    21.317    -0.280     0.200
    21.346     0.191     0.200
    21.346     0.191     0.200
    21.920    -0.511     0.200
    22.069     0.847     0.200
    24.118     1.994     0.200
    24.923    -0.742     0.200
    24.923     0.045     0.200
    24.968     0.251     0.200
    24.968    -0.050     0.200
    25.334    -0.575     0.200
    25.364     1.246     0.200
    25.494    -0.430     0.200
    25.579    -2.602     0.200
    25.581    -1.006     0.200
    25.892     1.360     0.200
    26.053    -0.099     0.200
    26.732    -0.724     0.200
    27.479     1.152     0.200
    27.479     1.463     0.200
    27.576     1.723     0.200
    27.859     1.859     0.200
    28.078     2.401     0.200
    28.233     2.567     0.200
    28.656     1.637     0.200
    29.916    -1.923     0.200
    29.812     1.798     0.200
    30.187     0.184     0.200
    31.718     0.583     0.200
    32.496    -0.345     0.200
    34.020     0.954     0.200
    34.255     1.519     0.200
    34.349     1.299     0.200
    34.584     0.868     0.200
    34.609     1.456     0.200
    34.691     1.643     0.200
    34.748     1.651     0.200
    34.763     1.919     0.200
    34.815     0.973     0.200
    34.840     1.555     0.200
    35.337     1.477     0.200
    35.712    -0.248     0.200
    36.894     2.254     0.200
    37.030     0.045     0.200
    37.203    -0.574     0.200
    37.444    -0.929     0.200
    37.935     0.829     0.200
    38.144    -0.830     0.200
    38.714    -0.844     0.200
    38.605     0.789     0.200
    38.951     0.092     0.200
    39.684    -1.826     0.200
    40.615     1.549     0.200
    41.463     0.772     0.200
    42.017     0.238     0.200
    42.091    -1.963     0.200
    42.428    -0.913     0.200
    42.536     0.489     0.200
    42.915     0.730     0.200
    43.734     0.903     0.200
    44.139     1.269     0.200
    44.208    -2.083     0.200
    44.363     1.156     0.200
    44.430     0.763     0.200
    44.698     0.800     0.200
    44.698     0.699     0.200
    44.719     0.945     0.200
    45.026     1.488     0.200
    45.156     1.354     0.200
    45.156     0.854     0.200
    45.156     1.053     0.200
    45.903     2.445     0.200
    46.296     0.045     0.200
    46.391    -0.136     0.200
    46.578    -0.068     0.200
    46.625     0.767     0.200
    46.959     0.262     0.200
    47.396     0.294     0.200
    47.469     0.480     0.200
    47.676    -1.028     0.200
    47.688    -1.622     0.200
    47.828    -0.360     0.200
    48.008    -0.390     0.200
    48.359     0.688     0.200
    48.446    -1.484     0.200
    48.446    -1.458     0.200
    50.365    -0.016     0.200
    50.932     2.108     0.200
    51.372     1.480     0.200
    51.372     1.781     0.200
    52.186    -0.290     0.200
    52.180     0.751     0.200
    52.328     0.158     0.200
    52.324    -0.713     0.200
    52.589    -2.777     0.200
    52.677     1.269     0.200
    52.834     0.204     0.200
    53.493     0.456     0.200
    53.765    -1.138     0.200
    53.897     0.298     0.200
    54.023     0.378     0.200
    54.023     0.579     0.200
    54.299     1.211     0.200
    54.538     0.122     0.200
    54.558    -0.919     0.200
    54.558    -0.818     0.200
    54.643    -0.835     0.200
    54.643    -0.636     0.200
    54.946     0.170     0.200
    55.036    -0.385     0.200
    55.724    -0.236     0.200
    55.724    -0.037     0.200
    55.852    -0.054     0.200
    55.873     0.879     0.200
    55.875     0.869     0.200
    56.003    -0.032     0.200
    56.126    -0.216     0.200
    56.156    -1.236     0.200
    56.161     0.138     0.200
    56.161    -0.751     0.200
    56.530     1.149     0.200
    56.606     0.065     0.200
    56.606     0.065     0.200
    56.612     0.353     0.200
    56.652     1.297     0.200
    57.181     0.495     0.200
    57.528     0.836     0.200
    57.644     0.823     0.200
    58.075     0.086     0.200
    58.877    -0.399     0.200
    59.878     0.010     0.200
    61.229     0.367     0.200
    61.767     1.939     0.200
    62.070     0.279     0.200
    62.151     0.057     0.200
    63.209     0.911     0.200
    63.485     0.274     0.200
    63.593    -1.038     0.200
    64.205     2.931     0.200
    64.639    -0.809     0.200
    65.678    -0.721     0.200
    65.794    -0.607     0.200
    66.003    -1.143     0.200
    66.200    -0.117     0.200
    66.294    -0.713     0.200
    66.307    -0.453     0.200
    66.344    -0.645     0.200
    66.424    -0.326     0.200
    66.444     0.298     0.200
    66.478    -0.305     0.200
    66.643    -0.373     0.200
    66.844    -0.255     0.200
    66.937    -0.440     0.200
    67.143     0.141     0.200
    67.163    -0.138     0.200
    67.273     0.570     0.200
    67.277     0.481     0.200
    67.468    -0.242     0.200
    67.472    -0.373     0.200
    67.487    -0.081     0.200
    67.554     0.225     0.200
    67.713     0.266     0.200
    67.738    -0.466     0.200
    67.793     0.219     0.200
    67.918     0.686     0.200
    67.932    -0.212     0.200
    67.950     0.183     0.200
    67.974     0.025     0.200
    68.015     0.239     0.200
    68.166     0.209     0.200
    68.177     0.333     0.200
    68.193     0.040     0.200
    68.202    -0.174     0.200
    68.209     0.489     0.200
    68.417    -0.321     0.200
    68.586     0.606     0.200
    68.613    -0.078     0.200
    68.649    -0.146     0.200
    68.776     0.525     0.200
    68.952    -0.210     0.200
    69.100     0.220     0.200
    69.149     0.186     0.200
    69.238     0.121     0.200
    69.257     0.032     0.200
    69.373     0.403     0.200
    69.407     0.362     0.200
    69.435    -0.125     0.200
    69.510     0.179     0.200
    69.560    -0.101     0.200
    69.572    -0.159     0.200
    69.649    -0.853     0.200
    69.670     0.467     0.200
    69.738     0.239     0.200
    69.742     0.273     0.200
    69.797    -0.109     0.200
    69.912    -0.073     0.200
    69.925     0.320     0.200
    69.957     0.108     0.200
    69.976     0.012     0.200
    70.096     0.379     0.200
    70.192     0.287     0.200
    70.321    -0.422     0.200
    70.321    -0.648     0.200
    70.345     0.190     0.200
    70.360     0.346     0.200
    70.425    -0.122     0.200
    70.464     0.157     0.200
    70.563     0.217     0.200
    70.654     0.201     0.200
    70.699    -0.222     0.200
    70.712     0.286     0.200
    70.733     0.379     0.200
    70.744     0.578     0.200
    70.748    -0.186     0.200
    70.834     0.524     0.200
    70.928     0.442     0.200
    70.941     0.240     0.200
    70.946    -0.104     0.200
    71.006     0.178     0.200
    71.049     0.049     0.200
    71.280     0.293     0.200
    71.305     0.273     0.200
    71.310     0.111     0.200
    71.339     0.433     0.200
    71.446     0.723     0.200
    71.518    -0.087     0.200
    71.524     0.421     0.200
    71.528     0.387     0.200
    71.538     0.582     0.200
    71.661    -0.175     0.200
    71.704     0.222     0.200
    71.701     0.325     0.200
    71.765     0.187     0.200
    71.825     0.538     0.200
    71.920    -0.367     0.200
    71.995    -0.270     0.200
    72.078     0.284     0.200
    72.130     0.057     0.200
    72.130     0.216     0.200
    72.148     0.195     0.200
    72.154     0.603     0.200
    72.170    -0.247     0.200
    72.359     0.578     0.200
    72.375     0.684     0.200
    72.470     0.604     0.200
    72.494    -0.313     0.200
    72.579     0.075     0.200
    72.586     0.702     0.200
    72.644     0.506     0.200
    72.657     0.390     0.200
    72.663     0.554     0.200
    72.708     0.590     0.200
    72.757     0.358     0.200
    72.881     0.295     0.200
    72.902     0.327     0.200
    72.953     0.354     0.200
    72.980     0.373     0.200
    73.027     0.703     0.200
    73.041     0.637     0.200
    73.111     0.276     0.200
    73.165     0.165     0.200
    73.187     0.219     0.200
    73.204     0.624     0.200
    73.271     1.880     0.200
    73.287     0.577     0.200
    73.295     1.900     0.200
    73.323    -1.728     0.200
    73.324     0.736     0.200
    73.478     0.374     0.200
    73.548     0.726     0.200
    73.576     0.541     0.200
    73.602     0.463     0.200
    73.639     0.688     0.200
    73.648     0.995     0.200
    73.656     0.657     0.200
    73.653     0.391     0.200
    73.746     0.877     0.200
    73.746     0.610     0.200
    73.797     1.051     0.200
    73.907     0.898     0.200
    73.932     1.003     0.200
    73.939     0.368     0.200
    73.948     1.393     0.200
    74.059     0.923     0.200
    74.095     0.076     0.200
    74.105     0.796     0.200
    74.111     0.609     0.200
    74.113     0.987     0.200
    74.112     0.957     0.200
    74.133     0.496     0.200
    74.169     0.413     0.200
    74.197     1.281     0.200
    74.225     0.998     0.200
    74.259     0.815     0.200
    74.289     0.770     0.200
    74.364     0.636     0.200
    74.373     0.864     0.200
    74.446    -1.270     0.200
    74.444     0.953     0.200
    74.457     0.916     0.200
    74.512     0.653     0.200
    74.520     0.748     0.200
    74.653     1.014     0.200
    74.709     1.234     0.200
    74.731     0.912     0.200
    74.748     1.073     0.200
    74.768     0.600     0.200
    75.027     0.038     0.200
    75.078     0.099     0.200
    75.096     0.516     0.200
    75.177     0.188     0.200
    75.187    -0.736     0.200
    75.187    -0.776     0.200
    75.213     0.473     0.200
    75.243     0.947     0.200
    75.312     0.279     0.200
    75.369     0.842     0.200
    75.447    -0.523     0.200
    75.643     0.137     0.200
    75.756     0.718     0.200
    75.818     0.582     0.200
    75.836     0.615     0.200
    75.837     0.902     0.200
    76.002     0.323     0.200
    76.177     0.251     0.200
    76.211     0.614     0.200
    76.253     0.877     0.200
    76.287     0.484     0.200
    76.474     0.189     0.200
    76.472     0.273     0.200
    76.533     0.692     0.200
    76.533     0.106     0.200
    76.571     0.186     0.200
    76.620    -1.862     0.200
    76.795     0.177     0.200
    76.809     0.303     0.200
    76.811     0.018     0.200
    76.859     0.338     0.200
    76.866     0.266     0.200
    76.953     0.416     0.200
    76.998     0.377     0.200
    77.019    -0.072     0.200
    76.914    -0.289     0.200
    77.085     0.452     0.200
    77.128     0.746     0.200
    77.186     0.958     0.200
    77.266     0.357     0.200
    77.271     0.621     0.200
    77.278     0.567     0.200
    77.310     0.965     0.200
    77.345     0.702     0.200
    77.476     0.401     0.200
    77.542    -0.897     0.200
    77.545     0.163     0.200
    77.702    -0.249     0.200
    77.557    -0.571     0.200
    77.564    -0.377     0.200
    77.758     0.144     0.200
    77.846     0.237     0.200
    77.857     0.352     0.200
    77.978     0.310     0.200
    78.104     0.534     0.200
    78.197     0.587     0.200
    78.244     0.495     0.200
    78.373    -0.253     0.200
    78.392     0.221     0.200
    78.400     0.229     0.200
    78.508     0.790     0.200
    78.518     0.645     0.200
    78.557     0.826     0.200
    78.659     0.168     0.200
    78.775    -0.133     0.200
    78.819    -0.101     0.200
    78.838     0.853     0.200
    79.049     0.224     0.200
    79.057     0.030     0.200
    79.104     0.015     0.200
    79.173     0.550     0.200
    79.200    -0.300     0.200
    79.386     0.385     0.200
    79.507     0.049     0.200
    79.525     0.461     0.200
    79.542    -1.513     0.200
    79.576     0.118     0.200
    79.582     0.434     0.200
    79.589     0.774     0.200
    79.640    -0.247     0.200
    79.711    -0.210     0.200
    79.838     0.234     0.200
    79.893     0.771     0.200
    79.926     0.277     0.200
    80.079     0.633     0.200
    80.126     0.846     0.200
    80.147    -0.390     0.200
    80.175     1.065     0.200
    80.257    -0.195     0.200
    80.307    -0.043     0.200
    80.333    -0.902     0.200
    80.387     0.376     0.200
    80.499     0.079     0.200
    80.575     0.258     0.200
    80.615     0.287     0.200
    80.719     0.740     0.200
    80.599    -0.094     0.200
    80.599     0.281     0.200
    80.794     0.160     0.200
    80.803     0.428     0.200
    80.916     0.945     0.200
    80.925     0.436     0.200
    80.965     0.522     0.200
    81.002    -0.228     0.200
    81.040     0.467     0.200
    81.204     0.702     0.200
    81.259     0.742     0.200
    81.112    -0.261     0.200
    81.271     1.010     0.200
    81.271     0.177     0.200
    81.425     0.562     0.200
    81.547     0.225     0.200
    81.547     0.350     0.200
    81.592     0.758     0.200
    81.706     0.543     0.200
    81.792     0.709     0.200
    81.912     0.537     0.200
    81.961    -0.511     0.200
    81.977    -0.945     0.200
    81.977     0.948     0.200
    82.150     0.439     0.200
    82.241     0.903     0.200
    82.315     0.736     0.200
    82.365     0.680     0.200
    82.524     0.652     0.200
    82.627     0.512     0.200
    82.720     0.549     0.200
    82.932     0.508     0.200
    83.099     0.548     0.200
    83.236    -0.813     0.200
    83.290     0.413     0.200
    83.232     1.078     0.200
    83.232     1.629     0.200
    83.232     0.908     0.200
    83.328     0.734     0.200
    83.376     0.772     0.200
    83.587     0.804     0.200
    83.847     0.965     0.200
    84.355     0.322     0.200
    84.751    -0.119     0.200
    84.780    -0.592     0.200
    84.867     0.732     0.200
    84.942     0.593     0.200
    85.451     1.106     0.200
    85.629     0.089     0.200
    87.638     0.258     0.200
    87.640    -0.575     0.200
    87.738    -0.111     0.200
    89.398     0.247     0.200
    89.409    -0.006     0.200
    89.890    -0.357     0.200
    90.982    -0.273     0.200
    90.982    -0.492     0.200
    15.447     4.537     0.200
    16.792     2.572     0.200
    21.119     2.484     0.200
    21.198     1.982     0.200
    21.345     0.855     0.200
    21.345    -0.695     0.200
    21.345    -1.215     0.200
    21.439    -0.164     0.200
    21.450     0.067     0.200
    21.450     0.243     0.200
    21.450     0.368     0.200
    24.456     0.044     0.200
    24.883    -0.553     0.200
    24.883    -0.466     0.200
    24.927    -0.354     0.200
    25.392     2.011     0.200
    26.232     1.910     0.200
    26.452     0.020     0.200
    26.452     2.000     0.200
    27.583     0.041     0.200
    28.375     1.172     0.200
    28.375     1.321     0.200
    28.751     1.624     0.200
    29.801     0.307     0.200
    29.801    -1.283     0.200
    30.160     1.925     0.200
    30.259     0.556     0.200
    32.458    -1.416     0.200
    32.458    -0.557     0.200
    37.125    -0.677     0.200
    37.872     0.541     0.200
    38.441    -1.284     0.200
    39.459    -2.088     0.200
    41.862     0.556     0.200
    42.312    -1.319     0.200
    42.325    -1.199     0.200
    44.789     0.014     0.200
    45.090    -0.583     0.200
    45.090     0.047     0.200
    46.436    -0.296     0.200
    46.436    -0.021     0.200
    47.317    -1.113     0.200
    47.520    -1.501     0.200
    47.520     0.199     0.200
    47.533    -1.095     0.200
    47.533    -1.694     0.200
    48.195    -1.184     0.200
    51.536    -0.496     0.200
    51.549    -0.439     0.200
    51.627     0.679     0.200
    52.223     2.534     0.200
    52.462     0.155     0.200
    52.696    -0.176     0.200
    52.878     0.238     0.200
    52.878     0.126     0.200
    53.175     1.085     0.200
    53.337     0.194     0.200
    53.579    -1.681     0.200
    53.579    -0.481     0.200
    53.704     0.297     0.200
    53.704    -0.003     0.200
    54.344     0.123     0.200
    54.356    -0.455     0.200
    54.712     0.348     0.200
    55.807    -0.052     0.200
    55.826    -1.334     0.200
    55.967    -0.447     0.200
    56.158     0.837     0.200
    56.401    -0.400     0.200
    56.555    -0.625     0.200
    57.852    -1.219     0.200
    59.046    -1.108     0.200
    61.060    -0.133     0.200
    61.361    -1.266     0.200
    61.557     0.105     0.200
    61.564    -0.240     0.200
    61.670    -0.860     0.200
    61.868    -1.695     0.200
    61.869    -1.597     0.200
    61.926    -0.581     0.200
    61.949    -0.438     0.200
    62.398    -0.346     0.200
    62.960    -1.097     0.200
    63.074    -1.354     0.200
    63.274    -0.882     0.200
    63.507    -1.027     0.200
    63.582    -1.323     0.200
    65.667    -1.044     0.200
    66.733    -0.991     0.200
    68.710     0.422     0.200
    69.253     0.525     0.200
    69.299     0.054     0.200
    69.644     0.726     0.200
    70.011     0.407     0.200
    70.829    -0.041     0.200
    71.608     0.295     0.200
    71.682     0.123     0.200
    72.017     0.881     0.200
    72.292     0.465     0.200
    72.675     1.199     0.200
    72.794     0.641     0.200
    73.626     0.454     0.200
    74.873    -0.336     0.200
    74.873    -0.216     0.200
    75.122    -0.657     0.200
    75.964     0.037     0.200
    77.382     1.658     0.200
    77.883    -0.975     0.200
    78.611     0.037     0.200
    78.739     1.062     0.200
    80.686     0.641     0.200
    81.433    -0.895     0.200
    81.644    -1.549     0.200
    83.016     0.913     0.200
    83.334     0.971     0.200
    84.438     0.017     0.200
    85.302     0.578     0.200
    86.219    -0.072     0.200
    89.085     0.585     0.200
    90.860    -0.928     0.200
    14.568     5.831     0.200
    15.752     3.970     0.200
    15.837     5.511     0.200
    17.428     1.282     0.200
    19.014     0.699     0.200
    19.951    -0.642     0.200
    19.951    -0.244     0.200
    19.998     0.754     0.200
    19.998    -0.660     0.200
    19.998    -0.347     0.200
    19.962     1.239     0.200
    20.090    -0.276     0.200
    21.246     0.377     0.200
    21.246     0.377     0.200
    21.420     0.253     0.200
    23.027     1.666     0.200
    23.506    -1.106     0.200
    23.722    -0.582     0.200
    23.722    -0.879     0.200
    23.768    -0.703     0.200
    23.768    -1.234     0.200
    23.768    -1.101     0.200
    24.952     2.295     0.200
    25.043     1.073     0.200
    25.148     0.546     0.200
    26.084     0.829     0.200
    26.084     3.470     0.200
    26.357    -1.585     0.200
    26.503     3.592     0.200
    26.686     1.193     0.200
    26.891     0.847     0.200
    26.836     2.085     0.200
    26.882     1.125     0.200
    26.882     0.789     0.200
    27.266     0.973     0.200
    27.266     1.270     0.200
    27.451     0.310     0.200
    27.691     0.263     0.200
    27.965     0.415     0.200
    27.965     0.595     0.200
    28.814    -0.051     0.200
    28.814     0.050     0.200
    28.905    -0.955     0.200
    29.105     2.569     0.200
    29.403     2.527     0.200
    30.877    -0.110     0.200
    31.286    -0.423     0.200
    31.286    -0.228     0.200
    31.762    -0.510     0.200
    32.777     0.983     0.200
    32.978     1.632     0.200
    33.325     1.905     0.200
    33.340     0.973     0.200
    33.455     1.870     0.200
    33.467     1.957     0.200
    33.468     1.657     0.200
    33.555     1.793     0.200
    33.558     0.373     0.200
    33.999     1.738     0.200
    34.031     1.657     0.200
    35.819    -0.873     0.200
    35.841    -1.363     0.200
    36.327     0.881     0.200
    36.471    -1.747     0.200
    37.448    -0.988     0.200
    37.793    -1.773     0.200
    37.690     0.395     0.200
    37.849     0.948     0.200
    38.038     0.560     0.200
    38.363    -1.056     0.200
    38.513     1.554     0.200
    39.077    -2.070     0.200
    39.542     0.738     0.200
    40.053     0.890     0.200
    40.251    -2.946     0.200
    41.457    -1.193     0.200
    41.499    -1.740     0.200
    41.535    -0.838     0.200
    41.942    -0.934     0.200
    41.966    -2.261     0.200
    43.677     0.215     0.200
    44.007    -0.291     0.200
    44.007     1.607     0.200
    44.037     0.273     0.200
    44.341    -2.072     0.200
    45.085    -1.274     0.200
    45.121    -1.269     0.200
    45.247    -1.176     0.200
    45.335    -1.334     0.200
    45.380     2.110     0.200
    45.327    -0.721     0.200
    45.581     0.300     0.200
    45.866     0.916     0.200
    45.919    -0.149     0.200
    45.881    -0.403     0.200
    46.216     0.257     0.200
    46.251     0.186     0.200
    46.325    -0.699     0.200
    46.783    -0.987     0.200
    46.794    -0.861     0.200
    46.795    -1.285     0.200
    46.882     1.056     0.200
    47.516    -0.014     0.200
    47.665     0.138     0.200
    47.792    -0.328     0.200
    47.902    -0.410     0.200
    47.966    -0.901     0.200
    47.966    -0.869     0.200
    48.001     0.723     0.200
    48.092    -0.125     0.200
    48.759    -0.509     0.200
    49.397    -1.402     0.200
    50.015    -1.108     0.200
    50.582    -0.198     0.200
    50.582    -0.604     0.200
    50.621     0.402     0.200
    50.652     0.270     0.200
    50.709    -0.263     0.200
    50.794     0.000     0.200
    50.826     0.257     0.200
    50.977     0.016     0.200
    51.227     0.539     0.200
    51.277     0.163     0.200
    51.336     0.029     0.200
    51.329    -0.919     0.200
    51.302     0.201     0.200
    51.328    -0.514     0.200
    51.418    -0.092     0.200
    51.533    -1.754     0.200
    51.604    -0.283     0.200
    51.747    -2.548     0.200
    51.758     0.474     0.200
    51.836     1.288     0.200
    51.836     0.889     0.200
    51.801    -0.083     0.200
    51.838     0.668     0.200
    51.874     0.102     0.200
    51.884     0.128     0.200
    51.870     0.011     0.200
    52.310     0.694     0.200
    52.375     0.278     0.200
    52.504     0.117     0.200
    52.600     0.505     0.200
    52.634     0.759     0.200
    52.662     0.254     0.200
    52.807    -0.323     0.200
    52.807     0.177     0.200
    52.984    -0.230     0.200
    53.141     0.413     0.200
    53.171     0.294     0.200
    53.182     0.914     0.200
    53.281     0.482     0.200
    53.806     0.425     0.200
    53.842     0.938     0.200
    53.839    -0.114     0.200
    53.943    -0.578     0.200
    53.943    -0.874     0.200
    54.204     0.322     0.200
    54.271     0.029     0.200
    54.308    -0.335     0.200
    54.332    -0.312     0.200
    54.551    -0.401     0.200
    54.694     0.056     0.200
    54.825     0.008     0.200
    54.870    -0.011     0.200
    54.908     0.008     0.200
    54.919     0.026     0.200
    54.955    -0.028     0.200
    54.963     0.213     0.200
    54.997     0.064     0.200
    55.029     0.028     0.200
    55.081     0.784     0.200
    55.258     0.082     0.200
    55.293    -0.169     0.200
    55.328     0.079     0.200
    55.409     0.392     0.200
    55.410     0.090     0.200
    55.410    -0.309     0.200
    55.451    -0.510     0.200
    55.564     0.380     0.200
    55.602    -0.396     0.200
    55.877     0.319     0.200
    55.900     0.267     0.200
    56.298    -0.375     0.200
    56.358     0.753     0.200
    56.358     0.089     0.200
    56.369     0.266     0.200
    56.377     0.002     0.200
    56.576    -0.674     0.200
    56.633     0.436     0.200
    56.680     0.731     0.200
    56.711    -0.215     0.200
    56.728     0.585     0.200
    56.868     0.888     0.200
    57.004     0.402     0.200
    57.062     0.389     0.200
    57.129    -1.738     0.200
    57.111    -0.399     0.200
    57.157    -1.081     0.200
    57.137    -0.375     0.200
    57.198    -0.268     0.200
    57.449    -0.262     0.200
    57.512     0.653     0.200
    57.693     0.232     0.200
    58.106    -0.291     0.200
    58.105     0.755     0.200
    58.185    -0.412     0.200
    58.185    -0.787     0.200
    58.580    -0.471     0.200
    58.614    -0.913     0.200
    58.781    -0.367     0.200
    59.136    -0.537     0.200
    59.142    -0.019     0.200
    59.218    -0.902     0.200
    59.291    -0.808     0.200
    59.463    -0.593     0.200
    59.698    -0.917     0.200
    60.381    -0.712     0.200
    60.381    -0.400     0.200
    60.480    -0.780     0.200
    60.927    -1.227     0.200
    61.044    -0.023     0.200
    61.050     0.241     0.200
    61.135    -0.255     0.200
    61.239    -1.139     0.200
    61.429    -0.424     0.200
    61.640    -0.751     0.200
    61.888    -0.419     0.200
    62.014    -0.763     0.200
    62.273    -0.960     0.200
    62.317    -0.499     0.200
    62.398    -0.939     0.200
    62.469    -0.621     0.200
    62.607    -1.039     0.200
    62.762    -0.374     0.200
    63.128    -1.110     0.200
    63.444    -0.099     0.200
    66.921    -1.063     0.200
    67.590     0.304     0.200
    67.632    -0.649     0.200
    68.666     0.933     0.200
    68.888     0.352     0.200
    68.895     0.151     0.200
    68.923     0.238     0.200
    69.054    -0.395     0.200
    69.054    -0.036     0.200
    69.256    -0.082     0.200
    69.286    -0.009     0.200
    69.330    -0.096     0.200
    69.503    -0.419     0.200
    69.691    -0.681     0.200
    69.712     0.769     0.200
    69.744    -0.144     0.200
    69.955     0.469     0.200
    70.030    -0.726     0.200
    70.046     0.382     0.200
    70.098    -0.313     0.200
    70.102     0.564     0.200
    70.114    -1.637     0.200
    70.122     0.824     0.200
    70.257     0.379     0.200
    70.274    -0.765     0.200
    70.337     0.326     0.200
    70.340     0.320     0.200
    70.342    -0.750     0.200
    70.364     0.671     0.200
    70.405    -0.728     0.200
    70.488    -0.453     0.200
    70.523    -0.861     0.200
    70.661     0.460     0.200
    70.800    -0.387     0.200
    70.818    -0.530     0.200
    70.845    -0.302     0.200
    70.901    -0.041     0.200
    71.024    -0.472     0.200
    71.049     0.309     0.200
    71.052    -0.191     0.200
    71.180     0.125     0.200
    71.185    -0.653     0.200
    71.191     0.264     0.200
    71.197    -0.638     0.200
    71.293     0.397     0.200
    71.293    -0.002     0.200
    71.370    -0.233     0.200
    71.370    -0.538     0.200
    71.380     1.232     0.200
    71.416    -0.011     0.200
    71.436    -0.664     0.200
    71.440    -1.107     0.200
    71.459    -0.543     0.200
    71.510    -0.124     0.200
    71.570    -0.003     0.200
    71.698    -0.663     0.200
    71.716    -0.684     0.200
    71.793    -0.462     0.200
    71.798     0.203     0.200
    71.823    -0.390     0.200
    71.869    -0.363     0.200
    71.920    -0.567     0.200
    71.951    -0.643     0.200
    71.992    -0.229     0.200
    72.006     0.260     0.200
    72.037    -0.067     0.200
    72.040    -0.204     0.200
    72.066    -0.761     0.200
    72.112    -0.408     0.200
    72.109     0.434     0.200
    72.119    -0.144     0.200
    72.118    -0.317     0.200
    72.212     0.168     0.200
    72.237    -0.599     0.200
    72.325    -2.128     0.200
    72.332    -0.365     0.200
    72.332    -0.630     0.200
    72.382     0.135     0.200
    72.393    -0.358     0.200
    72.506     0.140     0.200
    72.611    -0.424     0.200
    72.611     0.027     0.200
    72.640     0.088     0.200
    72.655    -0.707     0.200
    72.668     0.203     0.200
    72.726    -0.039     0.200
    72.911    -0.299     0.200
    72.963     0.371     0.200
    72.963    -0.004     0.200
    72.970    -0.687     0.200
    73.017     0.079     0.200
    73.067     0.047     0.200
    73.071     0.172     0.200
    73.081     0.208     0.200
    73.080    -0.932     0.200
    73.094    -0.473     0.200
    73.101     0.088     0.200
    73.161    -0.336     0.200
    73.200    -0.550     0.200
    73.310     0.246     0.200
    73.331     0.191     0.200
    73.430     0.569     0.200
    73.437    -0.535     0.200
    73.449     0.435     0.200
    73.574     0.059     0.200
    73.585     0.659     0.200
    73.586    -0.015     0.200
    73.676     0.782     0.200
    73.762     0.596     0.200
    73.800     0.812     0.200
    73.800     0.555     0.200
    73.815    -0.444     0.200
    73.839     0.494     0.200
    73.914    -0.500     0.200
    73.918    -0.272     0.200
    73.921    -0.709     0.200
    74.007     0.298     0.200
    74.069     0.042     0.200
    74.093    -0.566     0.200
    74.099    -0.175     0.200
    74.108     0.570     0.200
    74.108     0.422     0.200
    74.175     0.328     0.200
    74.354    -0.730     0.200
    74.367    -0.457     0.200
    74.236    -1.295     0.200
    74.236    -0.318     0.200
    74.477    -0.016     0.200
    74.481     0.653     0.200
    74.620    -0.818     0.200
    74.627    -0.343     0.200
    74.669    -0.107     0.200
    74.738    -0.463     0.200
    74.836     1.169     0.200
    74.868    -0.767     0.200
    75.027     0.694     0.200
    75.105    -0.400     0.200
    75.111    -0.694     0.200
    75.193     0.467     0.200
    75.206     0.838     0.200
    75.226    -0.450     0.200
    75.231    -0.893     0.200
    75.230     0.949     0.200
    75.253    -0.010     0.200
    75.287     1.493     0.200
    75.334     0.438     0.200
    75.435    -0.412     0.200
    75.447     0.067     0.200
    75.568    -0.214     0.200
    75.707    -0.765     0.200
    75.743    -1.317     0.200
    75.919    -0.557     0.200
    75.950     0.434     0.200
    76.056    -0.369     0.200
    76.134     0.152     0.200
    76.231     0.842     0.200
    76.254    -0.543     0.200
    76.269    -0.491     0.200
    76.269    -0.593     0.200
    76.312    -0.449     0.200
    76.397     1.036     0.200
    76.397     0.896     0.200
    76.414    -0.661     0.200
    76.458    -0.947     0.200
    76.506    -0.913     0.200
    76.559    -0.690     0.200
    76.708    -0.653     0.200
    76.753    -0.703     0.200
    76.754     0.959     0.200
    76.910    -0.999     0.200
    76.940    -0.273     0.200
    77.028    -0.523     0.200
    77.047    -0.100     0.200
    77.062     0.345     0.200
    77.142     0.129     0.200
    77.203    -0.500     0.200
    77.205    -0.753     0.200
    77.305    -0.731     0.200
    77.312    -0.074     0.200
    77.342    -0.726     0.200
    77.450     0.746     0.200
    77.549    -0.053     0.200
    77.579    -0.817     0.200
    77.618    -0.100     0.200
    77.665     0.966     0.200
    77.665     0.505     0.200
    77.714    -1.166     0.200
    77.596    -0.874     0.200
    77.777    -0.437     0.200
    77.807     0.130     0.200
    77.834     0.416     0.200
    77.919     0.124     0.200
    77.922    -0.672     0.200
    77.942     0.926     0.200
    77.953    -0.399     0.200
    77.978     0.728     0.200
    78.004    -0.614     0.200
    78.187    -0.198     0.200
    78.228    -0.315     0.200
    78.326    -0.172     0.200
    78.350    -0.226     0.200
    78.421    -0.340     0.200
    78.423     0.653     0.200
    78.450     0.375     0.200
    78.462    -0.792     0.200
    78.521     0.124     0.200
    78.614    -0.170     0.200
    78.656    -0.328     0.200
    78.674     0.030     0.200
    78.698     0.041     0.200
    78.707     0.896     0.200
    78.746     0.337     0.200
    78.755     0.620     0.200
    78.796    -0.153     0.200
    78.949     0.638     0.200
    78.981     0.257     0.200
    78.999     0.597     0.200
    79.063     1.149     0.200
    79.077     0.528     0.200
    79.179     0.035     0.200
    79.219    -0.895     0.200
    79.242    -0.458     0.200
    79.304    -0.251     0.200
    79.331     0.017     0.200
    79.341     0.641     0.200
    79.341     0.463     0.200
    79.359     0.309     0.200
    79.522     0.334     0.200
    79.558     0.739     0.200
    79.624     0.357     0.200
    79.646     0.910     0.200
    79.671    -0.016     0.200
    79.714     0.630     0.200
    79.761     0.006     0.200
    79.784    -0.681     0.200
    79.819    -1.481     0.200
    79.863     0.651     0.200
    79.868     0.760     0.200
    79.942    -0.520     0.200
    79.951     0.054     0.200
    79.953     0.372     0.200
    79.993     0.615     0.200
    79.952     0.898     0.200
    80.069     0.969     0.200
    80.113     0.431     0.200
    80.158     0.035     0.200
    80.292    -0.279     0.200
    80.304    -0.295     0.200
    80.314     0.721     0.200
    80.324     0.716     0.200
    80.380    -0.465     0.200
    80.429     0.695     0.200
    80.475     0.691     0.200
    80.502     0.710     0.200
    80.548    -0.171     0.200
    80.635     0.792     0.200
    80.740     0.608     0.200
    80.762    -0.075     0.200
    80.780    -0.250     0.200
    80.783     0.624     0.200
    80.783     0.788     0.200
    80.829     0.039     0.200
    80.840     0.775     0.200
    80.845     0.452     0.200
    81.020     0.119     0.200
    81.183     0.827     0.200
    81.114    -0.641     0.200
    81.269     1.011     0.200
    81.275     1.260     0.200
    81.304    -0.034     0.200
    81.374     0.680     0.200
    81.504     0.986     0.200
    81.562     0.625     0.200
    81.627     0.228     0.200
    81.650     0.614     0.200
    81.700     0.641     0.200
    81.719     0.689     0.200
    81.837     1.277     0.200
    81.837     0.964     0.200
    81.968     0.453     0.200
    82.017    -0.436     0.200
    82.090    -0.085     0.200
    82.202     0.434     0.200
    82.245     0.346     0.200
    82.241     0.316     0.200
    82.243     1.473     0.200
    82.270    -0.301     0.200
    82.362     0.333     0.200
    82.396     0.671     0.200
    82.404     1.130     0.200
    82.404     0.763     0.200
    82.435    -0.507     0.200
    82.430     0.048     0.200
    82.430     0.525     0.200
    82.463    -0.458     0.200
    82.486     0.473     0.200
    82.585     0.617     0.200
    82.606     0.215     0.200
    82.691     0.373     0.200
    82.725    -0.432     0.200
    82.744     0.551     0.200
    82.813    -0.643     0.200
    82.888    -0.622     0.200
    82.932    -0.165     0.200
    82.970     0.865     0.200
    82.979     0.488     0.200
    83.038     0.310     0.200
    83.093     0.907     0.200
    83.114    -0.390     0.200
    83.277     0.592     0.200
    83.284     0.718     0.200
    83.324    -0.886     0.200
    83.321     0.614     0.200
    83.387     0.610     0.200
    83.393     1.049     0.200
    83.510     0.508     0.200
    83.628     0.113     0.200
    83.653     0.884     0.200
    83.762     0.826     0.200
    83.810     0.194     0.200
    84.026    -0.288     0.200
    84.099     0.335     0.200
    84.132     0.645     0.200
    84.195     1.019     0.200
    84.219    -0.431     0.200
    84.308     0.745     0.200
    84.363    -0.222     0.200
    84.421     0.352     0.200
    84.468     0.419     0.200
    84.471     0.350     0.200
    84.499     1.051     0.200
    84.726     0.085     0.200
    84.730     1.123     0.200
    84.820     0.662     0.200
    84.877     0.034     0.200
    84.939     1.364     0.200
    84.963     0.649     0.200
    85.035     0.427     0.200
    85.069     0.923     0.200
    85.115     1.387     0.200
    85.215     0.993     0.200
    85.246     0.151     0.200
    85.286     0.364     0.200
    85.320     0.503     0.200
    85.383     0.653     0.200
    85.485     0.677     0.200
    85.493     0.552     0.200
    85.530     0.343     0.200
    85.558     0.164     0.200
    85.591     0.384     0.200
    85.667     0.396     0.200
    85.775     0.641     0.200
    85.852     0.388     0.200
    85.879     0.425     0.200
    85.919     0.248     0.200
    85.989     0.288     0.200
    86.118     0.462     0.200
    86.164    -0.260     0.200
    86.186     0.289     0.200
    86.246     0.961     0.200
    86.279     0.752     0.200
    86.334     0.187     0.200
    86.357     0.229     0.200
    86.477     1.000     0.200
    86.553     0.735     0.200
    86.625     0.508     0.200
    86.636     0.782     0.200
    86.689     0.332     0.200
    86.748     0.058     0.200
    86.811     0.603     0.200
    86.857    -0.121     0.200
    86.930    -0.142     0.200
    87.008    -0.036     0.200
    87.077     0.284     0.200
    87.103     0.085     0.200
    87.169     0.073     0.200
    87.267     0.260     0.200
    87.309     0.134     0.200
    87.377     0.370     0.200
    87.421     0.297     0.200
    87.433    -0.151     0.200
    87.545     0.212     0.200
    87.650    -0.197     0.200
    87.708    -0.389     0.200
    87.762    -0.252     0.200
    87.771     0.749     0.200
    87.825    -0.101     0.200
    87.982     0.770     0.200
    88.197     0.313     0.200
    88.202     0.373     0.200
    88.436     0.261     0.200
    88.507     0.286     0.200
    88.765     0.273     0.200
    88.793    -0.046     0.200
    88.917     0.332     0.200
    88.924     0.097     0.200
    89.126     0.231     0.200
    89.132     0.040     0.200
    89.137     0.104     0.200
    89.182    -0.217     0.200
    89.206     0.163     0.200
    89.446     0.620     0.200
    89.492     0.031     0.200
    89.564    -0.089     0.200
    89.594     0.333     0.200
    89.681     0.123     0.200
    89.737     0.354     0.200
    89.757    -0.004     0.200
    89.778    -0.103     0.200
    89.952     0.538     0.200
    89.974     0.334     0.200
    90.041    -0.058     0.200
    90.065     0.032     0.200
    90.142     0.048     0.200
    90.146     0.156     0.200
    90.356     0.292     0.200
    90.440    -0.076     0.200
    90.453     0.490     0.200
    90.486     0.874     0.200
    90.549    -0.044     0.200
    90.562     0.343     0.200
    90.749     0.104     0.200
    90.759    -1.554     0.200
    91.256    -0.299     0.200
    91.371    -0.415     0.200
    92.064     0.016     0.200
    98.845    -0.705     0.200
    25.642     0.604     0.200
    21.595    -0.163     0.200
    21.595     0.861     0.200
    21.689    -0.178     0.200
    25.167    -0.969     0.200
    25.212    -0.829     0.200
    32.741    -0.462     0.200
    42.643    -1.849     0.200
    42.643    -0.189     0.200
    44.799    -0.242     0.200
    47.837    -1.044     0.200
    48.508    -1.026     0.200
    48.508    -1.299     0.200
    48.508    -0.823     0.200
    55.903    -2.278     0.200
    56.287    -0.267     0.200
    56.287     0.830     0.200
    71.148    -0.872     0.200
    77.611    -0.780     0.200
    81.165    -0.701     0.200
    21.362     0.452     0.200
    24.945    -0.785     0.200
    26.443    -1.063     0.200
    29.819    -0.713     0.200
    45.108    -0.395     0.200
    15.776     3.274     0.200
    20.564     1.828     0.200
    20.658     0.804     0.200
    20.678     0.567     0.200
    24.127     1.758     0.200
    21.425     3.345     0.200
    21.475    -0.118     0.200
    25.009     1.105     0.200
    25.053     0.009     0.200
    44.938     0.143     0.200
    46.615    -0.502     0.200
    56.016    -2.148     0.200
    77.625    -1.420     0.200
    15.802     2.034     0.200
    20.675     0.230     0.200
    20.669     0.016     0.200
    24.166    -0.189     0.200
    27.593     2.037     0.200
    41.900    -0.968     0.200
    45.381    -0.770     0.200
    46.945    -0.281     0.200
    47.527    -1.584     0.200
    47.838    -1.109     0.200
    57.167    -0.811     0.200
    76.578     1.097     0.200
    77.990    -0.316     0.200
    81.524    -0.247     0.200
    20.003    -1.294     0.200
    20.667    -0.479     0.200
    21.349     0.442     0.200
    21.391     1.050     0.200
    21.443     0.288     0.200
    24.987     1.155     0.200
    25.593     0.048     0.200
    26.663     1.570     0.200
    29.920     2.019     0.200
    41.457     0.300     0.200
    41.705     0.468     0.200
    42.441     0.863     0.200
    43.968     0.917     0.200
    44.628    -0.967     0.200
    45.017    -0.503     0.200
    47.683     0.291     0.200
    56.085    -1.152     0.200
    75.626     2.179     0.200
    15.292     4.206     0.200
    20.431    -0.198     0.200
    20.526    -0.098     0.200
    20.540    -0.132     0.200
    20.540    -0.377     0.200
    21.309     1.017     0.200
    24.005     0.085     0.200
    24.050     0.285     0.200
    25.632     2.791     0.200
    38.008    -1.096     0.200
    41.743    -0.363     0.200
    41.743    -0.034     0.200
    44.235    -0.009     0.200
    45.414    -0.447     0.200
    46.953    -0.303     0.200
    47.687    -1.321     0.200
    47.687    -0.922     0.200
    53.229     0.404     0.200
    70.232     0.308     0.200
    76.617     1.228     0.200
    81.642    -0.057     0.200
    90.073     0.222     0.200
    20.039    -1.151     0.200
    20.061    -0.186     0.200
    23.705    -0.859     0.200
    38.143    -1.745     0.200
    41.765    -1.252     0.200
    46.669    -0.702     0.200
    47.767    -2.004     0.200
    51.792     0.043     0.200
    20.044    -0.505     0.200
    20.065    -0.261     0.200
    20.137    -1.546     0.200
    23.709    -1.236     0.200
    38.146    -2.293     0.200
    41.769    -1.551     0.200
    21.548     2.179     0.200
    21.607    -0.110     0.200
    21.642     1.167     0.200
    25.119     0.946     0.200
    42.602     0.584     0.200
    44.819    -0.634     0.200
    55.913    -1.341     0.200
    77.636    -1.596     0.200
    81.189    -1.941     0.200
    17.328     1.500     0.200
    17.795     3.399     0.200
    17.894     1.676     0.200
    18.363     2.407     0.200
    19.095     0.281     0.200
    19.821     0.408     0.200
    19.981    -0.490     0.200
    20.704     1.143     0.200
    20.781     0.141     0.200
    20.796     0.475     0.200
    20.842     0.798     0.200
    21.108     1.965     0.200
    21.564     0.109     0.200
    21.564    -0.493     0.200
    21.623    -0.184     0.200
    21.623     0.121     0.200
    21.678     1.436     0.200
    21.658     0.042     0.200
    21.744    -0.567     0.200
    21.787    -0.236     0.200
    22.273     0.868     0.200
    22.273     0.368     0.200
    23.520    -0.926     0.200
    23.529     0.480     0.200
    23.837    -0.096     0.200
    24.230     1.717     0.200
    24.863     0.367     0.200
    25.216     0.031     0.200
    25.216     0.031     0.200
    25.135    -0.093     0.200
    25.179    -0.043     0.200
    25.179     0.668     0.200
    25.179    -0.145     0.200
    25.251     0.270     0.200
    25.423     0.057     0.200
    25.483    -1.191     0.200
    25.487    -0.930     0.200
    25.487    -1.493     0.200
    25.487    -1.532     0.200
    25.489    -1.008     0.200
    25.455     1.266     0.200
    25.455     0.204     0.200
    25.489     1.153     0.200
    25.492    -1.272     0.200
    25.775     0.256     0.200
    25.775     0.139     0.200
    25.758    -0.361     0.200
    25.758     0.881     0.200
    25.737     0.923     0.200
    25.950     0.491     0.200
    26.005    -1.386     0.200
    26.130     0.816     0.200
    26.446     0.190     0.200
    26.446    -1.216     0.200
    26.362     0.454     0.200
    26.523     1.786     0.200
    26.711     0.516     0.200
    26.800     0.707     0.200
    26.784     2.216     0.200
    26.940     0.273     0.200
    27.161     0.693     0.200
    27.255    -0.424     0.200
    27.363     0.790     0.200
    27.425     0.470     0.200
    27.857     0.660     0.200
    27.940     0.605     0.200
    28.289     1.748     0.200
    28.362    -0.205     0.200
    28.512     2.407     0.200
    28.551     1.305     0.200
    28.551     1.664     0.200
    28.551     1.781     0.200
    28.551     0.516     0.200
    28.551     0.883     0.200
    28.815     2.115     0.200
    28.865     2.022     0.200
    29.100    -0.536     0.200
    29.330     3.281     0.200
    30.024     1.040     0.200
    30.078     0.471     0.200
    30.078    -1.240     0.200
    30.134     0.729     0.200
    30.453     0.051     0.200
    30.889     2.392     0.200
    30.889     1.970     0.200
    30.889     0.798     0.200
    30.970     0.038     0.200
    31.348     0.907     0.200
    31.808    -0.890     0.200
    31.951     0.746     0.200
    31.951     0.043     0.200
    32.239     0.512     0.200
    32.309     0.502     0.200
    32.332     0.001     0.200
    32.628     1.370     0.200
    33.059     0.944     0.200
    33.072     0.279     0.200
    33.351     0.772     0.200
    34.224    -2.114     0.200
    34.309     0.654     0.200
    34.409     0.441     0.200
    34.409    -0.012     0.200
    34.546     0.892     0.200
    34.640     1.180     0.200
    34.873     0.675     0.200
    34.901     1.234     0.200
    34.984     1.014     0.200
    35.040     0.729     0.200
    35.040     0.230     0.200
    35.058     1.382     0.200
    35.105     0.567     0.200
    35.133     1.235     0.200
    35.457    -0.609     0.200
    35.631     1.144     0.200
    35.761     0.622     0.200
    35.761     0.130     0.200
    36.331    -0.551     0.200
    36.331     0.472     0.200
    36.497    -0.872     0.200
    37.080     1.361     0.200
    37.296     0.424     0.200
    37.296     0.526     0.200
    37.377    -1.638     0.200
    37.377    -0.888     0.200
    37.314    -0.549     0.200
    37.314    -0.424     0.200
    37.616    -0.709     0.200
    37.859    -0.542     0.200
    37.859    -1.206     0.200
    37.859    -0.682     0.200
    38.035    -0.939     0.200
    38.151    -1.209     0.200
    38.211     1.583     0.200
    38.721    -2.171     0.200
    38.721    -1.211     0.200
    38.721    -0.781     0.200
    38.739    -0.344     0.200
    38.787    -1.161     0.200
    38.850     0.388     0.200
    38.850    -0.479     0.200
    39.195     0.842     0.200
    39.195    -0.259     0.200
    39.195    -0.322     0.200
    39.464    -0.822     0.200
    39.680    -0.846     0.200
    39.731    -3.100     0.200
    40.097    -1.382     0.200
    40.548     0.264     0.200
    40.620     0.107     0.200
    40.699    -0.615     0.200
    40.739    -2.003     0.200
    40.734     1.743     0.200
    40.892     1.056     0.200
    40.892     0.658     0.200
    41.149     0.587     0.200
    41.306    -0.680     0.200
    41.587     0.114     0.200
    41.587    -0.886     0.200
    41.677     0.374     0.200
    41.677    -0.345     0.200
    41.804    -2.261     0.200
    41.890    -0.259     0.200
    42.629     0.011     0.200
    42.592    -0.485     0.200
    42.612    -0.854     0.200
    42.614    -0.639     0.200
    42.752    -1.430     0.200
    42.679    -1.190     0.200
    42.757    -0.648     0.200
    43.159     0.168     0.200
    43.365    -0.081     0.200
    43.799    -0.603     0.200
    43.850     0.474     0.200
    44.078    -0.454     0.200
    44.068    -0.415     0.200
    44.068    -1.611     0.200
    44.113    -1.873     0.200
    44.147     0.630     0.200
    44.181    -0.517     0.200
    44.207    -1.599     0.200
    44.240     0.192     0.200
    44.240     0.347     0.200
    44.201     1.814     0.200
    44.253     1.002     0.200
    44.412     1.101     0.200
    44.416     0.744     0.200
    44.420     0.271     0.200
    44.436    -0.047     0.200
    44.433     0.867     0.200
    44.575     0.182     0.200
    44.585    -0.056     0.200
    44.745     0.074     0.200
    44.797     0.614     0.200
    44.809    -0.327     0.200
    44.809     0.415     0.200
    44.975    -0.157     0.200
    45.014    -0.254     0.200
    45.246     0.577     0.200
    45.166     0.322     0.200
    45.341     1.608     0.200
    45.321    -0.255     0.200
    45.352     1.433     0.200
    45.352     0.894     0.200
    45.352     0.745     0.200
    45.352     0.347     0.200
    45.389     0.656     0.200
    45.473    -0.320     0.200
    45.705    -0.318     0.200
    45.666    -0.527     0.200
    45.800    -0.490     0.200
    45.804     1.968     0.200
    45.802     0.292     0.200
    45.895    -0.570     0.200
    45.973     0.101     0.200
    45.976    -1.932     0.200
    46.011     0.528     0.200
    46.010     0.640     0.200
    46.105    -0.036     0.200
    46.155    -1.284     0.200
    46.101     0.071     0.200
    46.168     0.110     0.200
    46.197    -0.078     0.200
    46.280     0.643     0.200
    46.290    -0.876     0.200
    46.229    -1.088     0.200
    46.376     0.502     0.200
    46.440    -0.321     0.200
    46.479    -0.481     0.200
    46.499    -0.309     0.200
    46.509    -0.429     0.200
    46.447    -1.418     0.200
    46.518     0.350     0.200
    46.525    -0.020     0.200
    46.685    -0.060     0.200
    46.632     1.934     0.200
    46.632     1.450     0.200
    46.846    -0.178     0.200
    46.958    -0.140     0.200
    46.958    -0.343     0.200
    46.917     0.134     0.200
    46.918     0.508     0.200
    47.065    -0.321     0.200
    47.105    -0.246     0.200
    47.090    -0.399     0.200
    47.176     0.085     0.200
    47.226     0.350     0.200
    47.197     0.536     0.200
    47.187    -0.345     0.200
    47.308    -2.534     0.200
    47.256     1.189     0.200
    47.373    -0.109     0.200
    47.538    -0.006     0.200
    47.481     1.488     0.200
    47.587    -2.005     0.200
    47.677    -1.803     0.200
    47.633    -0.500     0.200
    47.734    -0.449     0.200
    47.764     0.892     0.200
    47.737     0.127     0.200
    47.806    -0.904     0.200
    47.806    -0.904     0.200
    47.941     0.359     0.200
    48.039     0.079     0.200
    48.060    -1.309     0.200
    48.060    -1.652     0.200
    47.952    -0.156     0.200
    48.143    -2.117     0.200
    48.252    -0.669     0.200
    48.311     0.217     0.200
    48.298    -0.671     0.200
    48.356     0.085     0.200
    48.444     0.763     0.200
    48.476     0.208     0.200
    48.445    -0.670     0.200
    48.478     0.005     0.200
    48.480    -0.915     0.200
    48.480    -1.063     0.200
    48.539    -1.112     0.200
    48.572    -1.754     0.200
    48.572    -0.278     0.200
    48.600    -0.242     0.200
    48.641    -1.353     0.200
    48.682    -0.571     0.200
    48.731    -1.348     0.200
    48.834     0.225     0.200
    49.058     1.037     0.200
    49.060     0.501     0.200
    49.140    -0.631     0.200
    49.239     0.754     0.200
    49.218     0.314     0.200
    49.516     1.048     0.200
    49.523    -1.414     0.200
    49.572     0.638     0.200
    49.694     2.052     0.200
    49.671    -0.344     0.200
    49.705     2.003     0.200
    49.705     0.534     0.200
    49.755     0.269     0.200
    49.741    -0.143     0.200
    49.900     0.509     0.200
    49.900    -0.850     0.200
    49.891    -0.341     0.200
    49.949    -0.490     0.200
    50.027    -0.250     0.200
    50.135     0.579     0.200
    50.253     0.435     0.200
    50.499     1.965     0.200
    50.557    -0.304     0.200
    50.654     0.509     0.200
    50.864    -1.079     0.200
    50.910     1.085     0.200
    50.910    -0.081     0.200
    50.922     0.610     0.200
    50.922     0.001     0.200
    51.146     0.230     0.200
    51.255    -0.063     0.200
    51.306     0.178     0.200
    51.410    -0.149     0.200
    51.445     0.430     0.200
    51.507     0.431     0.200
    51.520     0.090     0.200
    51.649    -0.576     0.200
    51.599     1.310     0.200
    51.678     0.919     0.200
    51.708     0.713     0.200
    51.762    -0.505     0.200
    51.748    -0.060     0.200
    51.748    -0.240     0.200
    51.831     1.143     0.200
    51.821    -0.103     0.200
    51.791     0.878     0.200
    51.833     0.101     0.200
    51.837     0.061     0.200
    51.876     0.118     0.200
    51.909     0.059     0.200
    51.883    -0.064     0.200
    51.883    -0.329     0.200
    52.026     0.258     0.200
    52.012     0.356     0.200
    52.012     2.582     0.200
    52.036     0.405     0.200
    52.036    -0.111     0.200
    52.109    -0.068     0.200
    52.116     0.909     0.200
    52.151     0.670     0.200
    52.233     0.426     0.200
    52.233     0.066     0.200
    52.235     1.056     0.200
    52.213    -0.329     0.200
    52.231     0.088     0.200
    52.251     0.752     0.200
    52.399     1.058     0.200
    52.325     0.498     0.200
    52.374     0.014     0.200
    52.482     0.017     0.200
    52.442    -0.380     0.200
    52.478    -1.056     0.200
    52.509     1.018     0.200
    52.534    -0.358     0.200
    52.602    -0.018     0.200
    52.618     0.127     0.200
    52.623     1.309     0.200
    52.704     0.336     0.200
    52.749     0.630     0.200
    52.721     1.076     0.200
    52.777     1.177     0.200
    52.875     0.233     0.200
    52.857     0.255     0.200
    52.913     1.266     0.200
    52.913     0.839     0.200
    52.978     0.754     0.200
    52.978     0.152     0.200
    52.964     0.380     0.200
    53.030     0.629     0.200
    53.067     0.572     0.200
    53.226    -0.032     0.200
    53.145     0.300     0.200
    53.145     0.519     0.200
    53.145     0.017     0.200
    53.404     1.210     0.200
    53.448     1.389     0.200
    53.458     0.213     0.200
    53.446     0.885     0.200
    53.491     1.348     0.200
    53.491    -0.027     0.200
    53.538     0.078     0.200
    53.538     0.179     0.200
    53.520     0.807     0.200
    53.618    -0.166     0.200
    53.552    -0.175     0.200
    53.622     0.764     0.200
    53.649     0.048     0.200
    53.658     0.901     0.200
    53.867     0.016     0.200
    53.867     0.540     0.200
    53.867    -0.288     0.200
    53.889     0.511     0.200
    53.890     0.451     0.200
    53.898    -0.030     0.200
    53.938     0.196     0.200
    53.990     0.120     0.200
    53.993     0.697     0.200
    53.973     0.246     0.200
    54.015     0.435     0.200
    54.077     0.282     0.200
    54.139     1.184     0.200
    54.139    -0.175     0.200
    54.222     0.026     0.200
    54.184     1.369     0.200
    54.211     0.507     0.200
    54.211     0.405     0.200
    54.476     0.871     0.200
    54.544    -0.417     0.200
    54.503     0.823     0.200
    54.478     0.916     0.200
    54.542    -0.368     0.200
    54.582    -0.697     0.200
    54.584     0.924     0.200
    54.583     0.091     0.200
    54.600     0.615     0.200
    54.629     0.658     0.200
    54.633     0.132     0.200
    54.633     0.523     0.200
    54.645    -0.437     0.200
    54.645     0.047     0.200
    54.662     0.179     0.200
    54.726     0.080     0.200
    54.695     0.806     0.200
    54.784     0.532     0.200
    54.838     1.049     0.200
    54.862     0.226     0.200
    54.857     0.013     0.200
    54.944     0.388     0.200
    54.902     0.086     0.200
    54.922     1.050     0.200
    54.997     0.288     0.200
    55.009     0.003     0.200
    55.026     0.489     0.200
    55.039     0.690     0.200
    55.046     0.351     0.200
    55.087     0.250     0.200
    55.135     0.699     0.200
    55.147     0.576     0.200
    55.165     0.287     0.200
    55.152     0.255     0.200
    55.317    -0.212     0.200
    55.336     0.531     0.200
    55.501    -0.237     0.200
    55.561     0.804     0.200
    55.619     0.311     0.200
    55.612     0.858     0.200
    55.758    -0.294     0.200
    55.696     0.312     0.200
    55.668     3.258     0.200
    55.713     0.387     0.200
    55.751     0.419     0.200
    55.761     0.090     0.200
    55.737     1.361     0.200
    55.806     0.273     0.200
    55.817     0.446     0.200
    55.906    -1.874     0.200
    55.896     0.128     0.200
    55.969    -0.900     0.200
    55.978     0.624     0.200
    56.024     0.904     0.200
    56.091     0.335     0.200
    56.096     0.585     0.200
    56.096    -0.181     0.200
    56.133    -0.273     0.200
    56.232    -0.575     0.200
    56.160     0.933     0.200
    56.160    -0.997     0.200
    56.149    -0.114     0.200
    56.199    -0.740     0.200
    56.213     0.507     0.200
    56.195    -0.315     0.200
    56.256     0.350     0.200
    56.256    -0.181     0.200
    56.256    -0.127     0.200
    56.259     0.330     0.200
    56.259    -0.076     0.200
    56.288    -0.181     0.200
    56.323     0.569     0.200
    56.351     0.174     0.200
    56.334     0.885     0.200
    56.336    -0.136     0.200
    56.391     0.634     0.200
    56.439     0.379     0.200
    56.439     0.543     0.200
    56.439    -0.160     0.200
    56.516     0.682     0.200
    56.636     0.405     0.200
    56.647    -0.139     0.200
    56.690     0.082     0.200
    56.690     0.605     0.200
    56.690     0.051     0.200
    56.738     0.011     0.200
    56.738    -0.388     0.200
    56.704     0.315     0.200
    56.737     0.228     0.200
    56.813    -0.542     0.200
    56.837     0.609     0.200
    56.856     0.372     0.200
    56.897    -0.815     0.200
    56.908     0.608     0.200
    56.922     0.112     0.200
    56.991     0.072     0.200
    57.038     1.081     0.200
    57.047    -0.155     0.200
    57.113     1.755     0.200
    57.150     0.586     0.200
    57.282     0.361     0.200
    57.288     0.089     0.200
    57.297    -0.929     0.200
    57.320    -0.115     0.200
    57.341     0.342     0.200
    57.352    -0.639     0.200
    57.351    -2.455     0.200
    57.367     1.464     0.200
    57.406    -0.116     0.200
    57.440    -0.948     0.200
    57.448     0.288     0.200
    57.441     0.134     0.200
    57.489     0.751     0.200
    57.555    -0.168     0.200
    57.564    -0.031     0.200
    57.608     0.460     0.200
    57.635     0.551     0.200
    57.656     0.516     0.200
    57.681     0.246     0.200
    57.736    -0.447     0.200
    57.745     0.893     0.200
    57.746    -0.616     0.200
    57.763     0.273     0.200
    57.777     0.489     0.200
    57.807    -0.742     0.200
    57.827     0.574     0.200
    57.843    -0.996     0.200
    57.891     0.141     0.200
    57.893     0.655     0.200
    57.952     0.162     0.200
    57.970     0.218     0.200
    57.996    -0.133     0.200
    57.996    -0.273     0.200
    58.043     0.800     0.200
    58.074    -0.363     0.200
    58.090     0.072     0.200
    58.121     0.353     0.200
    58.259     0.382     0.200
    58.274    -0.910     0.200
    58.330     0.420     0.200
    58.359     0.391     0.200
    58.367    -0.728     0.200
    58.485     0.113     0.200
    58.493    -0.946     0.200
    58.503     0.083     0.200
    58.503    -1.011     0.200
    58.503    -1.222     0.200
    58.530     0.260     0.200
    58.562    -0.333     0.200
    58.562    -0.583     0.200
    58.569    -0.686     0.200
    58.579     0.360     0.200
    58.653     0.140     0.200
    58.657    -0.291     0.200
    58.657    -0.393     0.200
    58.674    -0.086     0.200
    58.703     0.192     0.200
    58.701     0.203     0.200
    58.717    -1.661     0.200
    58.721    -0.532     0.200
    58.724    -0.857     0.200
    58.730    -0.897     0.200
    58.740     0.481     0.200
    58.741     1.164     0.200
    58.819     0.091     0.200
    58.819    -0.518     0.200
    58.815     0.383     0.200
    58.825     2.640     0.200
    58.858    -2.078     0.200
    58.859    -1.193     0.200
    58.856    -0.773     0.200
    58.919    -1.214     0.200
    58.919    -2.073     0.200
    58.928    -2.133     0.200
    58.942     0.351     0.200
    58.959     0.019     0.200
    58.959    -0.785     0.200
    58.945     0.209     0.200
    58.964    -0.824     0.200
    59.023     0.387     0.200
    59.106    -0.112     0.200
    59.084     2.042     0.200
    59.107    -1.243     0.200
    59.152    -0.232     0.200
    59.167     1.868     0.200
    59.287    -1.161     0.200
    59.298    -1.286     0.200
    59.302    -0.867     0.200
    59.314    -2.107     0.200
    59.334    -0.884     0.200
    59.455     0.353     0.200
    59.450    -0.394     0.200
    59.460    -1.262     0.200
    59.495    -0.302     0.200
    59.507     0.212     0.200
    59.538    -0.299     0.200
    59.553    -1.705     0.200
    59.553    -1.502     0.200
    59.580    -0.291     0.200
    59.611    -0.301     0.200
    59.660     1.257     0.200
    59.683    -2.801     0.200
    59.693    -0.464     0.200
    59.703    -0.539     0.200
    59.860    -1.323     0.200
    59.897    -0.373     0.200
    59.987    -1.290     0.200
    60.010    -1.354     0.200
    60.057     1.326     0.200
    60.086    -0.571     0.200
    60.129    -0.865     0.200
    60.155    -0.938     0.200
    60.170    -0.747     0.200
    60.221    -0.298     0.200
    60.242    -2.038     0.200
    60.298    -0.523     0.200
    60.381    -1.986     0.200
    60.389    -0.845     0.200
    60.681    -1.070     0.200
    60.682    -0.249     0.200
    60.707    -1.232     0.200
    60.725    -0.441     0.200
    60.877    -0.318     0.200
    60.875    -1.062     0.200
    60.850     2.310     0.200
    60.903    -0.993     0.200
    60.934    -1.292     0.200
    61.029    -0.712     0.200
    61.047     0.381     0.200
    61.078    -2.650     0.200
    61.098    -0.003     0.200
    61.108    -0.429     0.200
    61.164    -1.568     0.200
    61.269     1.766     0.200
    61.317    -0.991     0.200
    61.347    -0.064     0.200
    61.378    -1.234     0.200
    61.427    -0.713     0.200
    61.581    -1.278     0.200
    61.685    -0.648     0.200
    61.827    -0.965     0.200
    61.884    -0.709     0.200
    62.174    -1.129     0.200
    62.249    -1.040     0.200
    62.209     0.623     0.200
    62.209    -1.080     0.200
    62.238    -0.472     0.200
    62.321     1.971     0.200
    62.865     2.749     0.200
    63.370    -1.710     0.200
    63.348    -0.946     0.200
    63.361    -3.163     0.200
    63.361    -2.796     0.200
    64.085    -1.089     0.200
    64.710     0.586     0.200
    65.429     0.138     0.200
    65.471    -0.716     0.200
    65.762    -1.740     0.200
    66.016    -2.037     0.200
    66.029     0.337     0.200
    66.163    -1.627     0.200
    66.116     0.277     0.200
    66.116    -1.950     0.200
    66.314     0.936     0.200
    66.621     0.877     0.200
    66.621     0.080     0.200
    66.730     0.740     0.200
    66.868    -0.809     0.200
    66.995     0.823     0.200
    67.337     0.973     0.200
    67.382    -1.188     0.200
    67.525    -1.489     0.200
    67.589     0.465     0.200
    67.660     0.036     0.200
    67.700    -0.532     0.200
    67.690    -0.799     0.200
    67.928    -0.936     0.200
    67.934    -0.797     0.200
    68.141    -0.386     0.200
    68.249     0.715     0.200
    68.267     0.280     0.200
    68.304     0.833     0.200
    68.520     0.147     0.200
    68.592    -0.387     0.200
    68.520     0.491     0.200
    68.699    -0.479     0.200
    68.775     0.845     0.200
    68.822    -0.939     0.200
    68.873    -0.668     0.200
    68.912     0.753     0.200
    68.990     1.208     0.200
    68.997    -0.765     0.200
    69.032     0.937     0.200
    69.091    -0.363     0.200
    69.155    -0.090     0.200
    69.207     1.259     0.200
    69.428    -0.507     0.200
    69.487    -0.176     0.200
    69.487    -0.832     0.200
    69.525     0.737     0.200
    69.650    -0.091     0.200
    69.679    -0.363     0.200
    69.691     0.808     0.200
    69.772     0.968     0.200
    69.781     0.288     0.200
    69.922     0.474     0.200
    69.922     0.052     0.200
    69.979     1.496     0.200
    70.058    -0.401     0.200
    70.058    -0.768     0.200
    69.964     1.687     0.200
    69.964     0.359     0.200
    70.119    -0.760     0.200
    70.273     0.869     0.200
    70.308     0.594     0.200
    70.371     0.873     0.200
    70.392     0.460     0.200
    70.555     0.599     0.200
    70.617    -0.115     0.200
    70.646     1.348     0.200
    70.833     0.668     0.200
    70.962     0.485     0.200
    71.035     0.723     0.200
    71.095    -0.178     0.200
    71.095    -1.295     0.200
    71.053     0.335     0.200
    71.118     0.056     0.200
    71.188     0.653     0.200
    71.216    -2.007     0.200
    71.216    -1.453     0.200
    71.220     0.425     0.200
    71.279     0.058     0.200
    71.383    -0.360     0.200
    71.461     0.861     0.200
    71.546     1.015     0.200
    71.650    -0.075     0.200
    71.738     0.758     0.200
    71.759    -1.433     0.200
    71.823    -1.441     0.200
    71.910     0.663     0.200
    71.910     0.108     0.200
    72.057     0.336     0.200
    72.122     0.935     0.200
    72.121    -0.894     0.200
    72.188     0.603     0.200
    72.236    -0.015     0.200
    72.306     0.186     0.200
    72.381     0.198     0.200
    72.397     0.168     0.200
    72.367     0.323     0.200
    72.408     0.384     0.200
    72.408     0.782     0.200
    72.482    -0.070     0.200
    72.526     0.075     0.200
    72.537     0.055     0.200
    72.523     0.058     0.200
    72.624     0.334     0.200
    72.693     0.334     0.200
    72.739    -0.347     0.200
    72.741    -0.433     0.200
    72.689     0.104     0.200
    72.784     1.023     0.200
    72.809     0.883     0.200
    72.847     0.434     0.200
    72.847     0.059     0.200
    72.940     0.193     0.200
    73.028     1.295     0.200
    73.050    -0.115     0.200
    73.087    -1.637     0.200
    73.087    -1.285     0.200
    73.132     2.379     0.200
    73.132    -0.067     0.200
    73.177     1.023     0.200
    73.323     0.348     0.200
    73.380     0.881     0.200
    73.428    -1.693     0.200
    73.478     0.336     0.200
    73.687     0.339     0.200
    73.701    -0.060     0.200
    73.809    -0.309     0.200
    73.845     0.610     0.200
    73.828     1.483     0.200
    73.929     0.196     0.200
    73.956     0.606     0.200
    73.974     1.157     0.200
    73.916    -0.446     0.200
    73.991     0.746     0.200
    74.130    -0.800     0.200
    74.088     0.461     0.200
    74.191    -0.825     0.200
    74.218    -1.474     0.200
    74.272     0.386     0.200
    74.388     0.508     0.200
    74.388     0.711     0.200
    74.451    -0.227     0.200
    74.460     0.074     0.200
    74.538     0.089     0.200
    74.507    -0.185     0.200
    74.569     0.556     0.200
    74.569     0.259     0.200
    74.717     0.882     0.200
    74.793     1.055     0.200
    74.831    -1.063     0.200
    74.875    -0.464     0.200
    74.840     0.686     0.200
    74.918     0.611     0.200
    74.920    -0.164     0.200
    74.920    -0.336     0.200
    74.920    -0.336     0.200
    74.920    -0.375     0.200
    74.966     0.253     0.200
    75.020     0.468     0.200
    75.020     0.741     0.200
    75.140     1.032     0.200
    75.191    -0.245     0.200
    75.191    -0.049     0.200
    75.353    -0.873     0.200
    75.491     0.730     0.200
    75.494     0.616     0.200
    75.507    -1.140     0.200
    75.527     0.235     0.200
    75.548    -1.410     0.200
    75.558     0.244     0.200
    75.715     0.220     0.200
    75.781    -1.146     0.200
    75.865     0.208     0.200
    75.873    -1.680     0.200
    75.894    -0.808     0.200
    75.970     0.763     0.200
    76.021     0.206     0.200
    76.113    -0.394     0.200
    76.145     0.212     0.200
    76.258     0.053     0.200
    76.258     0.709     0.200
    76.261    -0.902     0.200
    76.276     0.951     0.200
    76.284    -0.857     0.200
    76.311    -0.809     0.200
    76.322     0.208     0.200
    76.335    -1.001     0.200
    76.396    -0.331     0.200
    76.396    -1.262     0.200
    76.442     0.628     0.200
    76.449    -1.129     0.200
    76.487     1.295     0.200
    76.516    -0.486     0.200
    76.591    -1.288     0.200
    76.621    -0.901     0.200
    76.621    -1.135     0.200
    76.635    -0.800     0.200
    76.713     0.351     0.200
    76.788    -0.596     0.200
    76.788    -0.697     0.200
    76.795    -0.987     0.200
    76.793    -0.047     0.200
    76.818    -1.397     0.200
    76.832    -0.743     0.200
    76.856    -0.956     0.200
    76.929     0.212     0.200
    76.957    -1.135     0.200
    76.999     0.755     0.200
    76.999    -0.191     0.200
    77.004     0.224     0.200
    77.008    -0.346     0.200
    77.023    -0.642     0.200
    77.034    -1.136     0.200
    77.054    -0.261     0.200
    77.071     0.038     0.200
    77.076    -0.626     0.200
    77.104    -0.234     0.200
    77.048    -0.031     0.200
    77.165    -0.383     0.200
    77.176    -0.899     0.200
    77.219     1.142     0.200
    77.209    -0.156     0.200
    77.219     0.129     0.200
    77.219     0.402     0.200
    77.280     0.324     0.200
    77.300    -0.704     0.200
    77.300    -1.001     0.200
    77.332    -0.837     0.200
    77.336    -0.241     0.200
    77.420     0.626     0.200
    77.440     0.080     0.200
    77.446     0.364     0.200
    77.470    -0.763     0.200
    77.487    -0.449     0.200
    77.497    -0.839     0.200
    77.510    -0.518     0.200
    77.532    -0.355     0.200
    77.470    -0.663     0.200
    77.465    -0.466     0.200
    77.551    -1.006     0.200
    77.574     0.358     0.200
    77.583     1.049     0.200
    77.588     0.632     0.200
    77.642     0.214     0.200
    77.647    -0.270     0.200
    77.677    -0.319     0.200
    77.670     0.220     0.200
    77.684     0.509     0.200
    77.680    -0.899     0.200
    77.624    -0.641     0.200
    77.693    -0.458     0.200
    77.631    -0.930     0.200
    77.633    -0.803     0.200
    77.707    -0.184     0.200
    77.726     0.443     0.200
    77.726    -0.057     0.200
    77.736    -0.664     0.200
    77.686    -0.806     0.200
    77.778    -0.995     0.200
    77.779    -0.279     0.200
    77.820     0.843     0.200
    77.832     0.041     0.200
    77.859    -0.521     0.200
    77.862    -0.601     0.200
    77.877    -0.904     0.200
    77.887    -0.319     0.200
    77.890    -0.015     0.200
    77.890    -0.265     0.200
    77.902    -0.083     0.200
    77.924    -0.515     0.200
    77.945     0.079     0.200
    77.944    -0.849     0.200
    77.944    -0.708     0.200
    77.972    -0.684     0.200
    77.982    -0.159     0.200
    77.991     0.906     0.200
    78.023    -0.363     0.200
    78.023     0.278     0.200
    78.049    -1.022     0.200
    78.106     0.700     0.200
    78.129    -0.684     0.200
    78.199    -0.995     0.200
    78.236     0.831     0.200
    78.242    -0.625     0.200
    78.256    -0.404     0.200
    78.259    -0.620     0.200
    78.272    -0.318     0.200
    78.295    -0.840     0.200
    78.300    -0.996     0.200
    78.300    -0.760     0.200
    78.322    -0.220     0.200
    78.367    -0.269     0.200
    78.375     0.823     0.200
    78.381     0.219     0.200
    78.381    -0.546     0.200
    78.417    -0.048     0.200
    78.426    -0.771     0.200
    78.450     0.349     0.200
    78.473     0.361     0.200
    78.474     0.154     0.200
    78.497    -1.077     0.200
    78.524     0.218     0.200
    78.551     1.070     0.200
    78.569    -0.739     0.200
    78.567    -0.844     0.200
    78.567    -0.555     0.200
    78.579    -0.981     0.200
    78.585    -0.576     0.200
    78.596     0.183     0.200
    78.654    -0.215     0.200
    78.681    -0.082     0.200
    78.681    -0.184     0.200
    78.679    -1.134     0.200
    78.710     0.131     0.200
    78.794     0.670     0.200
    78.803     0.771     0.200
    78.821     0.678     0.200
    78.849    -0.888     0.200
    78.851     0.295     0.200
    78.864    -0.286     0.200
    78.919     0.352     0.200
    78.954     0.620     0.200
    78.955     0.631     0.200
    78.944     0.349     0.200
    78.947    -0.226     0.200
    78.964     0.628     0.200
    78.957    -1.375     0.200
    78.957    -0.234     0.200
    78.985     0.848     0.200
    79.036     0.084     0.200
    79.041    -1.138     0.200
    79.044    -0.320     0.200
    79.030     0.076     0.200
    79.038    -0.850     0.200
    79.043    -0.139     0.200
    79.043     0.010     0.200
    79.052    -0.784     0.200
    79.053     0.232     0.200
    79.072     0.067     0.200
    79.105     0.806     0.200
    79.095    -0.270     0.200
    79.101    -0.363     0.200
    79.113     0.090     0.200
    79.116    -1.128     0.200
    79.131    -0.035     0.200
    79.138     0.386     0.200
    79.123     0.340     0.200
    79.123    -0.394     0.200
    79.159     0.229     0.200
    79.168     0.611     0.200
    79.180    -0.753     0.200
    79.180    -0.316     0.200
    79.184     0.354     0.200
    79.172     0.284     0.200
    79.203    -0.322     0.200
    79.206     0.883     0.200
    79.202    -0.754     0.200
    79.218     0.086     0.200
    79.211     0.290     0.200
    79.227    -0.323     0.200
    79.232    -0.323     0.200
    79.240     0.547     0.200
    79.265    -0.191     0.200
    79.276     0.091     0.200
    79.299     0.607     0.200
    79.307    -0.321     0.200
    79.296    -1.089     0.200
    79.313    -1.277     0.200
    79.313    -1.074     0.200
    79.340    -0.702     0.200
    79.342    -0.449     0.200
    79.353     0.225     0.200
    79.361     0.502     0.200
    79.372    -0.184     0.200
    79.369    -0.396     0.200
    79.389    -1.243     0.200
    79.410     0.577     0.200
    79.415    -0.818     0.200
    79.454    -0.404     0.200
    79.454    -0.006     0.200
    79.471     0.362     0.200
    79.479    -0.456     0.200
    79.495     0.864     0.200
    79.540     0.041     0.200
    79.553    -0.613     0.200
    79.611     0.883     0.200
    79.614     0.184     0.200
    79.614     0.124     0.200
    79.615     0.159     0.200
    79.618     0.076     0.200
    79.634    -0.688     0.200
    79.655     0.565     0.200
    79.672     0.337     0.200
    79.665     0.073     0.200
    79.665     0.276     0.200
    79.675     0.361     0.200
    79.679    -0.028     0.200
    79.721     0.005     0.200
    79.727    -0.754     0.200
    79.746    -0.693     0.200
    79.746    -0.310     0.200
    79.802    -1.131     0.200
    79.827    -0.643     0.200
    79.835    -1.397     0.200
    79.849     0.363     0.200
    79.840    -0.214     0.200
    79.852    -0.654     0.200
    79.892     0.396     0.200
    80.026    -1.314     0.200
    80.026    -0.955     0.200
    79.923    -0.942     0.200
    79.937     0.248     0.200
    79.968    -1.392     0.200
    79.978    -0.755     0.200
    79.970    -0.680     0.200
    79.969    -0.534     0.200
    79.969     0.145     0.200
    80.064    -0.440     0.200
    80.115     0.728     0.200
    80.122    -0.411     0.200
    80.169     0.788     0.200
    80.174     0.572     0.200
    80.187     0.862     0.200
    80.208    -0.202     0.200
    80.208     0.439     0.200
    80.236    -0.949     0.200
    80.257     0.198     0.200
    80.264     0.255     0.200
    80.298    -1.687     0.200
    80.300     0.521     0.200
    80.316    -0.155     0.200
    80.344     0.734     0.200
    80.344     0.156     0.200
    80.345    -0.363     0.200
    80.345     0.043     0.200
    80.341    -0.818     0.200
    80.351     0.823     0.200
    80.347    -0.681     0.200
    80.356    -0.155     0.200
    80.361    -0.816     0.200
    80.357     0.774     0.200
    80.357    -0.109     0.200
    80.366     0.157     0.200
    80.400     0.676     0.200
    80.415    -0.702     0.200
    80.451    -0.608     0.200
    80.487    -0.567     0.200
    80.487    -0.418     0.200
    80.487     0.297     0.200
    80.514     0.421     0.200
    80.558     0.607     0.200
    80.562    -0.802     0.200
    80.565    -0.086     0.200
    80.565    -0.547     0.200
    80.566    -0.640     0.200
    80.609     0.005     0.200
    80.609     0.153     0.200
    80.611    -0.693     0.200
    80.634    -0.362     0.200
    80.634    -0.542     0.200
    80.664    -0.271     0.200
    80.664    -0.669     0.200
    80.609     0.415     0.200
    80.679     0.423     0.200
    80.737     0.421     0.200
    80.737    -0.243     0.200
    80.738    -0.121     0.200
    80.742    -0.559     0.200
    80.757     0.463     0.200
    80.771    -0.643     0.200
    80.816    -0.478     0.200
    80.823    -0.966     0.200
    80.833     0.263     0.200
    80.792     0.334     0.200
    80.891     0.543     0.200
    80.901    -0.547     0.200
    80.922     0.596     0.200
    80.939     0.150     0.200
    80.939     0.431     0.200
    80.941     0.684     0.200
    80.961     0.547     0.200
    80.983     0.391     0.200
    80.985     0.433     0.200
    81.079    -0.737     0.200
    81.145     0.269     0.200
    81.072     0.737     0.200
    81.140    -0.886     0.200
    81.166    -0.311     0.200
    81.171    -0.464     0.200
    81.202    -0.190     0.200
    81.233    -0.138     0.200
    81.264     0.573     0.200
    81.183    -0.543     0.200
    81.184    -0.596     0.200
    81.261    -0.582     0.200
    81.268    -0.809     0.200
    81.275     0.025     0.200
    81.348     0.377     0.200
    81.349    -1.002     0.200
    81.350    -0.415     0.200
    81.389     0.019     0.200
    81.453    -1.048     0.200
    81.472     0.252     0.200
    81.491     0.146     0.200
    81.510     0.370     0.200
    81.510     0.691     0.200
    81.503    -0.918     0.200
    81.527     0.555     0.200
    81.527    -0.109     0.200
    81.533    -0.119     0.200
    81.561    -0.781     0.200
    81.587    -0.612     0.200
    81.598     0.860     0.200
    81.613    -0.587     0.200
    81.637    -0.916     0.200
    81.696     0.686     0.200
    81.709    -0.675     0.200
    81.714     0.035     0.200
    81.731    -0.476     0.200
    81.771    -1.007     0.200
    81.771    -0.866     0.200
    81.778     0.605     0.200
    81.770    -0.238     0.200
    81.770    -0.535     0.200
    81.845    -0.521     0.200
    81.845    -0.396     0.200
    81.845    -1.154     0.200
    81.862    -0.842     0.200
    81.881     0.734     0.200
    81.884    -1.008     0.200
    81.889    -0.625     0.200
    81.902    -0.396     0.200
    81.907    -0.379     0.200
    81.930     0.633     0.200
    81.927    -0.712     0.200
    81.927    -1.236     0.200
    81.931     0.234     0.200
    81.934    -0.108     0.200
    81.950    -1.780     0.200
    81.964     0.711     0.200
    82.021    -1.119     0.200
    82.033     0.457     0.200
    82.033     0.699     0.200
    82.096    -0.228     0.200
    82.102    -0.866     0.200
    82.136    -1.029     0.200
    82.139    -0.974     0.200
    82.137     0.385     0.200
    82.189    -0.568     0.200
    82.268    -1.008     0.200
    82.265    -0.690     0.200
    82.265    -1.096     0.200
    82.301    -0.716     0.200
    82.301    -0.997     0.200
    82.303    -0.590     0.200
    82.303    -0.773     0.200
    82.303    -1.085     0.200
    82.302    -0.368     0.200
    82.310    -0.131     0.200
    82.352    -0.246     0.200
    82.354     0.088     0.200
    82.401    -0.384     0.200
    82.423    -0.788     0.200
    82.423    -0.968     0.200
    82.425    -0.119     0.200
    82.464    -0.504     0.200
    82.472    -0.735     0.200
    82.539    -0.481     0.200
    82.539    -0.676     0.200
    82.557    -0.443     0.200
    82.608    -1.101     0.200
    82.622    -0.727     0.200
    82.647    -0.948     0.200
    82.647    -0.823     0.200
    82.666    -0.118     0.200
    82.681    -0.214     0.200
    82.690     0.028     0.200
    82.709    -1.335     0.200
    82.710    -1.208     0.200
    82.715    -0.365     0.200
    82.731    -0.327     0.200
    82.793    -0.305     0.200
    82.799    -0.265     0.200
    82.855    -0.743     0.200
    82.891    -0.974     0.200
    82.926    -0.883     0.200
    82.975    -1.202     0.200
    83.024    -0.802     0.200
    83.026    -0.820     0.200
    83.028    -1.119     0.200
    83.059    -0.099     0.200
    83.059     0.854     0.200
    83.061    -0.258     0.200
    83.061    -0.531     0.200
    83.066    -1.105     0.200
    83.066    -0.128     0.200
    83.081    -0.914     0.200
    83.095    -0.884     0.200
    83.095    -0.212     0.200
    83.155    -0.743     0.200
    83.154    -0.481     0.200
    83.194    -0.528     0.200
    83.219    -0.885     0.200
    83.279    -0.858     0.200
    83.324    -0.029     0.200
    83.377    -0.912     0.200
    83.377    -0.412     0.200
    83.376    -0.117     0.200
    83.406    -0.530     0.200
    83.423    -0.868     0.200
    83.428    -0.454     0.200
    83.452    -0.563     0.200
    83.463    -0.860     0.200
    83.472    -0.433     0.200
    83.473    -0.940     0.200
    83.473    -0.815     0.200
    83.480    -1.492     0.200
    83.532    -1.126     0.200
    83.571    -0.137     0.200
    83.509     2.283     0.200
    83.509     1.057     0.200
    83.509     0.799     0.200
    83.615    -0.659     0.200
    83.632    -0.694     0.200
    83.674    -1.078     0.200
    83.683    -0.806     0.200
    83.719    -1.060     0.200
    83.727     1.436     0.200
    83.738     0.444     0.200
    83.738    -0.783     0.200
    83.746     0.864     0.200
    83.748    -0.441     0.200
    83.754    -1.425     0.200
    83.754    -1.643     0.200
    83.760    -0.481     0.200
    83.761    -0.536     0.200
    83.842    -0.199     0.200
    83.848    -0.559     0.200
    83.848    -0.754     0.200
    83.930    -0.672     0.200
    83.933    -0.380     0.200
    83.952    -0.907     0.200
    83.952    -0.540     0.200
    83.952    -0.407     0.200
    83.963    -0.311     0.200
    84.068    -1.071     0.200
    84.110    -0.200     0.200
    84.110     0.409     0.200
    84.102    -0.379     0.200
    84.170    -0.733     0.200
    84.082     1.461     0.200
    84.205    -1.009     0.200
    84.303    -0.702     0.200
    84.310    -0.468     0.200
    84.359    -0.858     0.200
    84.365    -1.011     0.200
    84.366    -0.453     0.200
    84.482     0.414     0.200
    84.482     0.054     0.200
    84.512    -0.498     0.200
    84.512    -0.686     0.200
    84.522    -1.269     0.200
    84.529    -0.727     0.200
    84.529    -0.203     0.200
    84.550    -0.158     0.200
    84.556    -0.519     0.200
    84.564    -0.167     0.200
    84.569    -0.172     0.200
    84.583    -0.122     0.200
    84.630    -0.538     0.200
    84.636    -0.154     0.200
    84.765    -0.965     0.200
    84.772    -0.876     0.200
    84.871    -0.991     0.200
    84.870    -0.641     0.200
    84.885     0.972     0.200
    84.885     0.323     0.200
    84.969    -0.530     0.200
    84.969    -0.054     0.200
    85.020    -1.003     0.200
    85.026    -0.153     0.200
    85.041     0.029     0.200
    85.041    -0.213     0.200
    85.033    -0.227     0.200
    85.119    -0.108     0.200
    85.175    -0.913     0.200
    85.175    -1.131     0.200
    85.219     0.079     0.200
    85.284    -0.520     0.200
    85.284    -0.410     0.200
    85.287    -0.711     0.200
    85.327    -0.143     0.200
    85.374    -0.169     0.200
    85.374     0.424     0.200
    85.431    -0.329     0.200
    85.443    -0.193     0.200
    85.468    -0.636     0.200
    85.478    -0.999     0.200
    85.497    -0.829     0.200
    85.610    -0.757     0.200
    85.615    -0.026     0.200
    85.627    -0.527     0.200
    85.627    -0.410     0.200
    85.628    -0.526     0.200
    85.636    -0.393     0.200
    85.645     0.013     0.200
    85.655    -0.628     0.200
    85.690    -0.720     0.200
    85.746    -0.715     0.200
    85.773    -0.998     0.200
    85.790    -0.849     0.200
    85.822    -0.490     0.200
    85.822    -0.389     0.200
    85.921    -0.980     0.200
    85.921    -0.527     0.200
    85.932    -1.243     0.200
    85.941    -0.666     0.200
    86.387    -1.951     0.200
    86.098    -0.686     0.200
    86.098    -0.998     0.200
    86.154    -0.814     0.200
    86.154    -0.392     0.200
    86.486    -1.813     0.200
    86.241     0.055     0.200
    86.283    -0.284     0.200
    86.289    -0.697     0.200
    86.310    -0.510     0.200
    86.310    -0.783     0.200
    86.320    -0.590     0.200
    86.325    -0.254     0.200
    86.331     0.354     0.200
    86.334    -0.426     0.200
    86.334    -0.130     0.200
    86.362    -1.134     0.200
    86.404     0.157     0.200
    86.441    -0.795     0.200
    86.533    -0.600     0.200
    86.581    -0.280     0.200
    86.581    -0.687     0.200
    86.616    -0.423     0.200
    86.645    -0.370     0.200
    86.739    -0.596     0.200
    86.739     0.428     0.200
    86.769    -0.563     0.200
    86.769    -0.282     0.200
    86.770    -0.549     0.200
    86.686     0.642     0.200
    86.806    -0.447     0.200
    86.827    -0.214     0.200
    86.827    -0.949     0.200
    86.835    -0.354     0.200
    86.835    -0.659     0.200
    86.882    -0.424     0.200
    86.939    -0.179     0.200
    86.983    -0.276     0.200
    86.983    -0.175     0.200
    87.045    -0.573     0.200
    87.064     0.052     0.200
    87.092    -0.598     0.200
    87.160    -0.021     0.200
    87.160    -0.326     0.200
    87.168    -1.225     0.200
    87.197    -0.139     0.200
    87.197    -0.548     0.200
    87.265    -0.822     0.200
    87.314    -0.277     0.200
    87.347    -1.220     0.200
    87.366    -1.068     0.200
    87.309    -0.118     0.200
    87.412    -0.843     0.200
    87.421    -0.139     0.200
    87.427    -0.154     0.200
    87.427     0.291     0.200
    87.519    -0.551     0.200
    87.536    -1.098     0.200
    87.540    -0.807     0.200
    87.545    -0.378     0.200
    87.561    -0.352     0.200
    87.561    -0.673     0.200
    87.632    -0.850     0.200
    87.647    -1.234     0.200
    87.686    -0.766     0.200
    87.694     0.101     0.200
    87.689    -0.742     0.200
    87.696    -0.858     0.200
    87.852    -0.431     0.200
    87.852    -1.204     0.200
    87.954     0.143     0.200
    87.968    -0.413     0.200
    88.058    -0.240     0.200
    88.091    -0.123     0.200
    88.104    -0.553     0.200
    88.176     0.007     0.200
    88.190     0.141     0.200
    88.197    -0.404     0.200
    88.235    -0.151     0.200
    88.248    -0.678     0.200
    88.247    -0.597     0.200
    88.247    -0.480     0.200
    88.320     0.052     0.200
    88.338     0.053     0.200
    88.343    -0.448     0.200
    88.370     0.418     0.200
    88.392    -0.305     0.200
    88.392    -0.071     0.200
    88.505    -0.071     0.200
    88.522    -0.044     0.200
    88.540    -0.191     0.200
    88.605    -0.019     0.200
    88.665     0.047     0.200
    88.703    -0.224     0.200
    88.710     0.438     0.200
    88.723     0.171     0.200
    88.789    -0.498     0.200
    88.841    -0.211     0.200
    88.873    -0.753     0.200
    88.925    -0.394     0.200
    89.029    -0.892     0.200
    89.054    -0.051     0.200
    89.054     0.207     0.200
    89.061    -0.435     0.200
    89.114    -0.149     0.200
    89.129     0.012     0.200
    89.129     0.152     0.200
    89.130     0.111     0.200
    89.149     0.169     0.200
    89.149    -0.066     0.200
    89.143    -0.109     0.200
    89.143     0.188     0.200
    89.152    -0.632     0.200
    89.170     0.017     0.200
    89.209     0.632     0.200
    89.209    -0.235     0.200
    89.370    -0.266     0.200
    89.439     0.401     0.200
    89.459    -0.565     0.200
    89.469     0.073     0.200
    89.497    -0.805     0.200
    89.497    -0.625     0.200
    89.521     0.317     0.200
    89.582    -0.340     0.200
    89.562    -0.665     0.200
    89.562     1.077     0.200
    89.648     0.353     0.200
    89.648     0.720     0.200
    89.661    -0.410     0.200
    89.662    -0.120     0.200
    89.673    -0.084     0.200
    89.673    -0.404     0.200
    89.714     0.038     0.200
    89.714     0.897     0.200
    90.035    -0.190     0.200
    90.095     0.992     0.200
    90.144    -0.423     0.200
    90.209    -0.157     0.200
    90.220    -0.074     0.200
    90.360    -0.104     0.200
    90.393     0.125     0.200
    90.511     1.539     0.200
    90.508     0.472     0.200
    90.489    -0.917     0.200
    90.652    -0.219     0.200
    90.668     0.675     0.200
    90.719    -0.276     0.200
    90.750     0.690     0.200
    90.757    -0.382     0.200
    90.692    -1.188     0.200
    91.139    -0.622     0.200
    91.139    -0.333     0.200
    91.270    -0.070     0.200
    91.302     0.487     0.200
    91.354    -0.208     0.200
    91.594     0.211     0.200
    91.594    -0.070     0.200
    92.069     0.878     0.200
    92.696     1.016     0.200
    95.616     0.022     0.200
    21.559     1.983     0.200
    21.624     1.139     0.200
    21.654     0.947     0.200
    42.593    -0.070     0.200
    16.808     1.664     0.200
    21.590     1.279     0.200
    21.653     1.403     0.200
    21.653     0.430     0.200
    21.653     0.805     0.200
    21.684     0.235     0.200
    25.156     1.006     0.200
    25.201     0.837     0.200
    26.413     0.749     0.200
    28.581     2.213     0.200
    30.093     0.393     0.200
    42.618    -0.101     0.200
    44.777     0.364     0.200
    45.371     0.239     0.200
    45.408     1.094     0.200
    45.408     0.043     0.200
    48.481     0.120     0.200
    55.877    -1.634     0.200
    71.123     0.954     0.200
    77.641    -1.262     0.200
    81.195    -1.245     0.200
    91.154    -1.115     0.200
    21.675     0.284     0.200
    42.632    -0.002     0.200
    44.762     1.503     0.200
    16.792     2.249     0.200
    21.574     1.386     0.200
    21.669     0.399     0.200
    21.638     0.483     0.200
    25.141    -0.468     0.200
    42.607    -1.454     0.200
    44.787     0.625     0.200
    48.471    -1.469     0.200
    71.112     0.036     0.200
    17.146     0.482     0.200
    21.563    -1.799     0.200
    21.624     1.684     0.200
    21.657     1.486     0.200
    25.132     0.097     0.200
    47.801    -1.907     0.200
    20.440     0.983     0.200
    20.698     1.489     0.200
    20.698     1.192     0.200
    21.559    -1.404     0.200
    21.559    -1.166     0.200
    21.618     0.864     0.200
    21.618     0.665     0.200
    21.618     0.356     0.200
    21.653     0.635     0.200
    24.858     2.347     0.200
    25.130    -0.968     0.200
    25.175    -1.133     0.200
    25.175    -0.875     0.200
    25.246     1.943     0.200
    25.222    -0.867     0.200
    25.222     0.457     0.200
    25.222    -0.046     0.200
    25.487     0.963     0.200
    25.701     2.944     0.200
    25.731     2.872     0.200
    26.124     2.381     0.200
    26.356     2.803     0.200
    26.705     2.045     0.200
    26.795     3.045     0.200
    27.249     1.962     0.200
    27.934     1.917     0.200
    28.545     1.788     0.200
    28.545    -0.243     0.200
    30.447     0.852     0.200
    30.447    -0.667     0.200
    31.342     1.747     0.200
    32.704    -0.889     0.200
    34.225     0.626     0.200
    37.077    -0.960     0.200
    40.616    -1.002     0.200
    42.612    -1.156     0.200
    42.612    -0.804     0.200
    44.442     0.677     0.200
    44.814    -0.978     0.200
    44.814     0.463     0.200
    44.814    -0.439     0.200
    45.348     1.222     0.200
    46.485    -0.715     0.200
    47.255     0.554     0.200
    47.803    -1.865     0.200
    48.479    -0.673     0.200
    48.479    -0.544     0.200
    49.064     1.641     0.200
    49.245     1.355     0.200
    51.003     1.913     0.200
    53.987    -1.231     0.200
    53.991     0.243     0.200
    56.094    -0.164     0.200
    56.254    -0.301     0.200
    71.115    -0.769     0.200
    71.116    -0.326     0.200
    71.116    -0.217     0.200
    74.925    -1.738     0.200
    75.976     0.948     0.200
    77.630    -1.079     0.200
    77.630    -0.759     0.200
    81.183     0.530     0.200
    81.183     0.370     0.200
    89.135     0.046     0.200
    89.135    -0.341     0.200
    91.135     0.173     0.200
    16.795     1.806     0.200
    18.319    -0.166     0.200
    21.438    -1.756     0.200
    21.438     0.064     0.200
    21.522    -1.158     0.200
    48.101    -0.496     0.200
    19.940    -2.122     0.200
    21.389     1.790     0.200
    21.444     1.073     0.200
    21.483     0.729     0.200
    39.093    -0.632     0.200
    44.944     0.093     0.200
    21.597     1.579     0.200
    21.691     0.564     0.200
    21.695    -0.354     0.200
    25.175    -2.917     0.200
    30.033    -2.142     0.200
    81.349    -0.933     0.200
    21.556     0.906     0.200
    25.243    -2.009     0.200
    20.144    -2.504     0.200
    20.144    -0.204     0.200
    20.182    -0.922     0.200
    20.182    -2.519     0.200
    20.275     0.399     0.200
    23.892    -0.516     0.200
    23.939    -1.268     0.200
    23.939    -2.006     0.200
    24.329    -0.609     0.200
    27.802    -2.256     0.200
    27.802     0.134     0.200
    31.458    -0.442     0.200
    38.422    -1.810     0.200
    42.035    -0.955     0.200
    42.036    -1.282     0.200
    43.988     0.182     0.200
    45.148    -0.383     0.200
    45.534    -0.658     0.200
    45.871     0.153     0.200
    45.885     0.139     0.200
    46.099    -0.135     0.200
    46.099     0.087     0.200
    46.294     0.346     0.200
    46.309    -0.689     0.200
    46.914    -1.491     0.200
    47.021     0.055     0.200
    47.315    -0.254     0.200
    47.659    -1.524     0.200
    47.748    -0.110     0.200
    47.770    -0.664     0.200
    47.945    -0.109     0.200
    48.007    -0.662     0.200
    48.043    -0.976     0.200
    48.078     0.431     0.200
    48.164     0.175     0.200
    48.579     0.892     0.200
    48.921     0.370     0.200
    48.969    -0.366     0.200
    48.993    -0.250     0.200
    49.143    -1.833     0.200
    50.370    -1.299     0.200
    50.550     1.187     0.200
    50.927    -1.092     0.200
    52.924    -0.755     0.200
    57.006    -1.897     0.200
    71.867    -0.299     0.200
    77.294     0.154     0.200
    90.121    -0.668     0.200
    17.466     3.047     0.200
    19.090     1.157     0.200
    19.770    -0.691     0.200
    19.817     1.714     0.200
    20.439    -0.001     0.200
    20.439     0.624     0.200
    20.699     2.906     0.200
    20.840     0.725     0.200
    21.103     2.132     0.200
    21.561    -0.595     0.200
    21.561    -0.315     0.200
    21.619    -0.223     0.200
    21.619     0.077     0.200
    21.619    -0.023     0.200
    21.655    -0.331     0.200
    21.783    -0.079     0.200
    24.227     2.324     0.200
    24.859     1.284     0.200
    24.806     0.034     0.200
    25.132    -0.106     0.200
    25.176     1.170     0.200
    25.176     0.189     0.200
    25.248    -0.122     0.200
    25.221     0.168     0.200
    25.221     0.593     0.200
    25.221     0.128     0.200
    25.361     0.792     0.200
    25.488    -1.092     0.200
    25.703     1.539     0.200
    25.733     0.528     0.200
    26.126     1.397     0.200
    26.123     2.181     0.200
    26.451     0.122     0.200
    26.358     1.009     0.200
    26.707     1.210     0.200
    26.796     1.572     0.200
    26.780     1.721     0.200
    26.935     1.518     0.200
    27.251    -0.134     0.200
    28.547     1.642     0.200
    28.547     1.922     0.200
    28.547     0.852     0.200
    30.076     0.955     0.200
    30.449    -0.144     0.200
    31.344     0.791     0.200
    32.706    -0.028     0.200
    32.706    -0.308     0.200
    33.069     2.315     0.200
    36.813     0.457     0.200
    36.813    -0.853     0.200
    37.296    -2.504     0.200
    37.310     0.275     0.200
    37.605    -0.028     0.200
    38.216    -0.690     0.200
    38.722    -0.094     0.200
    38.722    -0.493     0.200
    40.889     1.323     0.200
    40.889     0.773     0.200
    41.146     0.488     0.200
    41.587    -0.415     0.200
    41.682     0.180     0.200
    41.682    -0.515     0.200
    41.767    -0.477     0.200
    42.266    -0.361     0.200
    42.614    -0.303     0.200
    42.614    -0.703     0.200
    42.634     0.135     0.200
    43.343     0.704     0.200
    43.747     0.465     0.200
    43.747    -0.129     0.200
    43.917    -1.419     0.200
    44.179     0.358     0.200
    44.245    -0.418     0.200
    44.296     0.351     0.200
    44.417     0.436     0.200
    44.417    -1.076     0.200
    44.421     0.675     0.200
    44.421     0.008     0.200
    44.425     0.389     0.200
    44.425     0.250     0.200
    44.441    -0.631     0.200
    44.580    -0.118     0.200
    44.590    -0.529     0.200
    44.750     0.710     0.200
    44.814    -1.127     0.200
    44.814     0.583     0.200
    44.814     0.003     0.200
    44.881    -0.642     0.200
    44.980    -0.139     0.200
    45.018    -0.239     0.200
    45.018    -0.657     0.200
    45.350     2.222     0.200
    45.350    -0.028     0.200
    45.386     0.530     0.200
    45.495    -0.975     0.200
    45.978    -0.614     0.200
    46.016    -0.553     0.200
    46.110     0.104     0.200
    46.160    -0.516     0.200
    46.172     0.516     0.200
    46.172    -0.264     0.200
    46.445    -0.526     0.200
    46.484    -0.745     0.200
    46.504    -0.589     0.200
    46.523    -0.437     0.200
    46.690    -0.492     0.200
    46.760     0.595     0.200
    46.760     0.063     0.200
    46.813     1.687     0.200
    46.894     0.152     0.200
    47.070    -0.475     0.200
    47.230    -2.246     0.200
    47.255     0.074     0.200
    47.640    -0.333     0.200
    47.680    -1.329     0.200
    47.653     0.696     0.200
    47.653    -0.415     0.200
    47.805     0.258     0.200
    47.805    -0.111     0.200
    47.805     0.659     0.200
    48.064    -1.836     0.200
    48.064    -1.264     0.200
    48.481    -0.669     0.200
    48.481    -0.520     0.200
    48.861    -0.419     0.200
    49.063    -0.880     0.200
    49.244     0.115     0.200
    49.233     0.449     0.200
    51.820     0.046     0.200
    51.832     0.270     0.200
    51.832     0.153     0.200
    52.304    -0.511     0.200
    52.705     1.818     0.200
    53.143     0.145     0.200
    53.867     1.166     0.200
    53.937     1.549     0.200
    53.993     0.744     0.200
    54.210     1.057     0.200
    54.632     1.485     0.200
    54.726    -0.294     0.200
    54.901     0.634     0.200
    54.996     0.448     0.200
    55.134     1.048     0.200
    55.806    -0.086     0.200
    55.911    -1.740     0.200
    56.096     0.236     0.200
    56.255    -0.831     0.200
    56.255    -0.506     0.200
    56.391     0.327     0.200
    57.634     0.413     0.200
    58.367     1.740     0.200
    58.579     0.660     0.200
    58.812    -0.823     0.200
    59.968     0.249     0.200
    59.978     0.809     0.200
    61.317     0.032     0.200
    61.427     0.006     0.200
    61.650    -1.069     0.200
    61.853     1.061     0.200
    62.457     0.105     0.200
    62.687     0.371     0.200
    63.375    -1.504     0.200
    65.766    -1.537     0.200
    66.034     0.070     0.200
    66.735     0.236     0.200
    67.022    -0.086     0.200
    67.664     0.248     0.200
    69.927     0.506     0.200
    70.392    -0.211     0.200
    70.376     0.746     0.200
    70.651     0.620     0.200
    71.053    -0.134     0.200
    71.116    -0.099     0.200
    71.118    -0.004     0.200
    71.118    -0.259     0.200
    71.165    -0.313     0.200
    71.221    -0.051     0.200
    71.732     0.081     0.200
    71.910     0.392     0.200
    72.127     0.857     0.200
    72.367    -0.846     0.200
    72.575    -0.188     0.200
    72.690     1.132     0.200
    72.711     0.309     0.200
    72.852    -0.032     0.200
    73.091    -1.737     0.200
    73.323    -0.425     0.200
    74.134    -1.420     0.200
    74.195    -0.980     0.200
    74.879    -0.711     0.200
    74.924    -0.428     0.200
    75.196    -0.711     0.200
    75.196    -1.342     0.200
    75.975     0.912     0.200
    75.975    -0.253     0.200
    76.118     0.038     0.200
    76.118    -0.444     0.200
    76.263    -0.002     0.200
    76.625    -0.830     0.200
    77.080    -1.214     0.200
    77.305    -1.199     0.200
    77.697    -0.161     0.200
    77.689     0.245     0.200
    77.731    -0.042     0.200
    77.783    -0.276     0.200
    77.622    -0.906     0.200
    77.629    -1.121     0.200
    77.629    -0.845     0.200
    77.631    -0.979     0.200
    78.246    -0.605     0.200
    78.372    -0.068     0.200
    78.430    -0.564     0.200
    78.799     0.175     0.200
    78.826    -0.183     0.200
    79.206    -0.760     0.200
    79.245     0.075     0.200
    79.318    -0.752     0.200
    79.304     0.269     0.200
    79.458    -0.775     0.200
    79.707     0.206     0.200
    79.750    -0.239     0.200
    79.897     0.284     0.200
    79.942     0.441     0.200
    80.304    -0.297     0.200
    80.350    -0.048     0.200
    80.356     0.501     0.200
    80.742     0.034     0.200
    80.927     0.753     0.200
    80.944     0.795     0.200
    80.951     0.681     0.200
    81.182    -0.725     0.200
    81.182    -0.426     0.200
    81.507    -0.206     0.200
    81.618     0.049     0.200
    82.038     0.004     0.200
    82.561    -1.101     0.200
    82.651    -1.412     0.200
    82.685    -1.464     0.200
    83.065    -0.517     0.200
    83.064     0.278     0.200
    83.064    -0.304     0.200
    83.158    -0.630     0.200
    83.175    -0.725     0.200
    83.328    -1.198     0.200
    83.485    -1.219     0.200
    83.723    -1.350     0.200
    83.795    -0.999     0.200
    83.853    -0.665     0.200
    84.314    -0.577     0.200
    84.534    -0.590     0.200
    84.534    -1.528     0.200
    84.560    -0.640     0.200
    84.890    -0.172     0.200
    85.123    -1.234     0.200
    85.179    -1.380     0.200
    85.292    -0.665     0.200
    85.379    -0.355     0.200
    85.482    -0.747     0.200
    85.631    -0.939     0.200
    86.290    -1.299     0.200
    86.339    -0.495     0.200
    86.409    -0.503     0.200
    86.445    -0.995     0.200
    86.987    -1.303     0.200
    87.165    -0.712     0.200
    87.370    -1.355     0.200
    87.432    -1.576     0.200
    87.694    -0.861     0.200
    88.609    -1.050     0.200
    89.135    -0.344     0.200
    89.154    -0.388     0.200
    89.501    -0.940     0.200
    89.677    -0.979     0.200
    91.137    -1.364     0.200
    91.137    -0.779     0.200
    20.725     0.342     0.200
    21.571     0.823     0.200
    21.571     0.362     0.200
    21.638     1.002     0.200
    21.638     0.377     0.200
    21.638     0.603     0.200
    21.638     0.908     0.200
    21.665     0.513     0.200
    21.801     0.249     0.200
    24.877     0.857     0.200
    25.134    -1.394     0.200
    25.178     0.782     0.200
    25.178    -0.867     0.200
    25.509    -0.626     0.200
    26.146     1.779     0.200
    26.376     1.870     0.200
    26.724     1.617     0.200
    26.815     1.836     0.200
    26.798     2.221     0.200
    27.266     0.754     0.200
    28.565     1.342     0.200
    28.565     1.795     0.200
    30.464     1.160     0.200
    30.464     1.262     0.200
    31.359     1.839     0.200
    39.231    -0.675     0.200
    40.901     1.085     0.200
    42.592    -0.786     0.200
    42.593    -0.571     0.200
    42.593    -0.094     0.200
    44.207    -1.178     0.200
    44.776    -1.674     0.200
    44.776    -0.276     0.200
    45.673    -0.938     0.200
    46.446    -1.521     0.200
    46.464    -0.160     0.200
    46.464    -0.934     0.200
    47.792    -0.931     0.200
    48.024    -1.332     0.200
    48.456    -0.025     0.200
    51.808     0.485     0.200
    55.870    -1.355     0.200
    55.870    -1.011     0.200
    56.079    -0.800     0.200
    56.079     0.801     0.200
    56.238    -0.170     0.200
    71.098     0.392     0.200
    77.663    -1.267     0.200
    77.663    -1.791     0.200
    81.217    -1.663     0.200
    16.115     4.902     0.200
    16.651     2.559     0.200
    20.544     0.588     0.200
    20.913     1.660     0.200
    21.055     2.075     0.200
    21.431     2.130     0.200
    21.431     0.567     0.200
    21.493     0.963     0.200
    21.493     0.111     0.200
    21.525     0.117     0.200
    21.656     0.805     0.200
    25.004     0.615     0.200
    25.049     0.492     0.200
    25.049    -0.438     0.200
    28.420     2.116     0.200
    38.646    -1.137     0.200
    39.142    -0.114     0.200
    41.751     0.676     0.200
    42.339     0.498     0.200
    42.518    -0.687     0.200
    42.520    -0.936     0.200
    42.520    -0.261     0.200
    42.720     0.215     0.200
    44.522     1.020     0.200
    44.890     0.619     0.200
    44.890    -0.854     0.200
    44.890     0.560     0.200
    46.563    -0.748     0.200
    46.563    -0.271     0.200
    47.692    -0.959     0.200
    48.114    -1.346     0.200
    48.396    -0.732     0.200
    55.963    -1.695     0.200
    55.963    -1.520     0.200
    56.152    -1.216     0.200
    71.022    -0.090     0.200
    74.990    -1.096     0.200
    76.056     0.511     0.200
    77.675    -1.036     0.200
    81.226    -0.845     0.200
    91.019    -0.698     0.200
    19.035     0.799     0.200
    20.531     1.781     0.200
    20.531    -0.121     0.200
    21.432     1.337     0.200
    21.499     0.498     0.200
    21.526     0.851     0.200
    25.002     0.750     0.200
    25.046     1.061     0.200
    39.162     1.344     0.200
    42.506     0.375     0.200
    44.872     0.551     0.200
    46.544     0.106     0.200
    55.944    -1.198     0.200
    56.140     0.046     0.200
    71.009     0.727     0.200
    76.039     0.627     0.200
    77.694    -0.725     0.200
    91.011    -0.688     0.200
    16.609     1.944     0.200
    20.520     1.094     0.200
    20.923     1.482     0.200
    20.923     1.681     0.200
    21.445     2.545     0.200
    21.445     2.225     0.200
    21.511     0.634     0.200
    21.511     0.209     0.200
    21.539     0.094     0.200
    21.674    -0.018     0.200
    22.270     0.613     0.200
    25.014     0.013     0.200
    25.059     0.137     0.200
    25.059     0.297     0.200
    28.438     1.358     0.200
    30.337    -0.056     0.200
    30.337     0.643     0.200
    38.638    -2.026     0.200
    39.167    -0.155     0.200
    40.774    -0.377     0.200
    42.515    -0.835     0.200
    42.515    -1.507     0.200
    44.476     0.278     0.200
    44.865     0.325     0.200
    45.232     0.451     0.200
    46.538    -0.536     0.200
    46.538    -0.103     0.200
    47.694     0.366     0.200
    48.389    -0.562     0.200
    53.026     0.459     0.200
    55.938    -1.591     0.200
    55.991     1.279     0.200
    56.151    -0.444     0.200
    70.671     0.286     0.200
    71.019    -0.120     0.200
    71.698    -0.777     0.200
    72.890     0.315     0.200
    74.965    -0.745     0.200
    76.031     0.487     0.200
    77.689    -1.213     0.200
    77.772     0.180     0.200
    79.027     0.638     0.200
    79.193     0.906     0.200
    81.241    -1.141     0.200
    85.410     0.066     0.200
    91.023    -1.793     0.200
    16.614     1.976     0.200
    19.856     0.348     0.200
    20.101    -0.036     0.200
    20.509     0.772     0.200
    20.682    -0.244     0.200
    20.682    -0.346     0.200
    21.093     0.602     0.200
    21.449    -0.130     0.200
    21.449     0.019     0.200
    21.518     0.028     0.200
    21.518     0.313     0.200
    21.543     0.731     0.200
    21.681     0.076     0.200
    21.863     0.702     0.200
    22.283     0.736     0.200
    22.283     1.037     0.200
    23.649    -1.908     0.200
    24.282    -0.396     0.200
    24.757     0.485     0.200
    24.905     1.137     0.200
    25.016     0.191     0.200
    25.060    -0.083     0.200
    25.060     0.159     0.200
    25.263     0.169     0.200
    25.391    -1.199     0.200
    25.322     0.507     0.200
    25.523     1.008     0.200
    25.604     1.706     0.200
    26.119     0.909     0.200
    26.604     1.314     0.200
    26.696     0.909     0.200
    26.679     2.049     0.200
    26.679     1.947     0.200
    27.056     1.632     0.200
    27.218     1.812     0.200
    28.445     0.943     0.200
    28.445     0.525     0.200
    28.445     1.326     0.200
    30.025     0.124     0.200
    30.030     3.554     0.200
    30.342     0.191     0.200
    30.342     0.191     0.200
    31.238     0.646     0.200
    31.944    -0.226     0.200
    32.590    -0.524     0.200
    33.013     1.824     0.200
    34.366     0.619     0.200
    34.484     0.897     0.200
    34.816     0.429     0.200
    34.838     1.143     0.200
    34.977     0.835     0.200
    34.990     0.829     0.200
    35.046     0.043     0.200
    35.456     1.102     0.200
    37.100    -0.344     0.200
    37.186    -1.679     0.200
    37.186    -1.578     0.200
    37.308    -0.079     0.200
    38.267    -0.420     0.200
    38.283     0.043     0.200
    38.283    -1.391     0.200
    38.629    -1.654     0.200
    39.180     0.351     0.200
    39.180     0.062     0.200
    40.779     1.030     0.200
    40.779     0.003     0.200
    41.188    -0.243     0.200
    41.773    -1.443     0.200
    41.713     0.358     0.200
    41.713    -0.360     0.200
    42.301     0.354     0.200
    42.301     0.464     0.200
    42.509    -0.402     0.200
    43.383     0.641     0.200
    43.786     1.198     0.200
    43.786     0.260     0.200
    44.196     0.599     0.200
    44.314     1.582     0.200
    44.283     0.466     0.200
    44.455     0.630     0.200
    44.455     1.064     0.200
    44.460     0.903     0.200
    44.460     0.482     0.200
    44.463     0.185     0.200
    44.485     0.484     0.200
    44.619     0.245     0.200
    44.629     0.498     0.200
    44.792     0.383     0.200
    44.852    -0.249     0.200
    44.852     0.333     0.200
    45.046     1.233     0.200
    45.057     0.060     0.200
    45.232     0.858     0.200
    45.232     0.756     0.200
    45.269     1.038     0.200
    45.398     0.510     0.200
    45.898    -2.464     0.200
    46.024    -0.204     0.200
    46.063    -1.714     0.200
    46.218    -0.229     0.200
    46.486    -0.244     0.200
    46.525    -0.149     0.200
    46.724     0.538     0.200
    46.803     0.633     0.200
    46.803     0.242     0.200
    46.930     0.510     0.200
    46.930     0.229     0.200
    46.990     0.046     0.200
    46.990     0.206     0.200
    47.166     0.072     0.200
    47.166    -0.170     0.200
    47.178    -0.104     0.200
    47.299     0.105     0.200
    47.690    -0.842     0.200
    47.690     0.150     0.200
    47.690    -0.948     0.200
    47.696     0.955     0.200
    47.696     0.119     0.200
    47.773    -0.349     0.200
    48.076    -1.190     0.200
    48.076    -1.393     0.200
    48.131    -1.161     0.200
    48.382    -1.203     0.200
    48.382    -0.992     0.200
    48.701     0.588     0.200
    48.904     1.359     0.200
    49.116     0.913     0.200
    49.105     1.719     0.200
    49.285     1.048     0.200
    52.191    -0.160     0.200
    52.191    -0.262     0.200
    53.025     0.653     0.200
    53.025     1.560     0.200
    53.441     2.900     0.200
    53.756    -0.210     0.200
    54.098     0.385     0.200
    54.364    -0.255     0.200
    54.521    -0.297     0.200
    54.536     0.473     0.200
    54.618    -1.098     0.200
    54.790    -0.051     0.200
    54.984    -0.755     0.200
    55.215     0.176     0.200
    55.391    -0.691     0.200
    55.819     0.832     0.200
    55.866     0.902     0.200
    55.925    -1.602     0.200
    55.986    -0.166     0.200
    55.986    -0.467     0.200
    56.146    -0.198     0.200
    56.146    -0.534     0.200
    56.141    -0.235     0.200
    56.224     0.443     0.200
    56.524     2.011     0.200
    56.517     0.614     0.200
    56.582     0.256     0.200
    56.782     0.630     0.200
    57.176     0.472     0.200
    57.522     0.548     0.200
    57.634     0.578     0.200
    57.841     0.094     0.200
    58.017    -0.641     0.200
    58.036    -1.632     0.200
    58.220     0.440     0.200
    58.249     0.322     0.200
    58.256    -1.518     0.200
    58.420     0.508     0.200
    58.460     1.087     0.200
    58.469    -0.490     0.200
    58.703    -0.451     0.200
    58.832     1.696     0.200
    58.996    -0.826     0.200
    59.176    -1.037     0.200
    59.345     0.031     0.200
    59.859     0.115     0.200
    60.500    -1.273     0.200
    63.371    -0.857     0.200
    65.774    -1.468     0.200
    66.908    -0.010     0.200
    67.426     0.036     0.200
    67.479     0.040     0.200
    67.697    -0.321     0.200
    67.697     0.858     0.200
    67.740    -0.249     0.200
    67.967     0.471     0.200
    68.914     0.404     0.200
    69.690     0.507     0.200
    69.722     1.451     0.200
    69.957     0.581     0.200
    69.957    -0.259     0.200
    70.087    -0.613     0.200
    70.087    -0.305     0.200
    70.290    -0.358     0.200
    70.420     1.179     0.200
    70.658     0.291     0.200
    70.732    -0.462     0.200
    70.691    -0.032     0.200
    70.694     0.685     0.200
    70.861    -0.046     0.200
    70.950     0.411     0.200
    71.011    -0.586     0.200
    71.012    -0.440     0.200
    71.063     0.029     0.200
    71.118     1.395     0.200
    71.115    -0.095     0.200
    71.115    -0.298     0.200
    71.224    -1.950     0.200
    71.239     0.329     0.200
    71.304     0.977     0.200
    71.313    -0.026     0.200
    71.572     0.351     0.200
    71.513     0.345     0.200
    71.669    -0.135     0.200
    71.685     0.580     0.200
    71.807    -0.365     0.200
    71.761    -0.285     0.200
    71.761    -0.086     0.200
    71.755     0.860     0.200
    72.092     0.796     0.200
    72.151    -0.039     0.200
    72.174     0.834     0.200
    72.264     1.396     0.200
    72.236     0.480     0.200
    72.473    -0.052     0.200
    72.422    -0.259     0.200
    72.586    -0.527     0.200
    72.570     0.527     0.200
    72.658    -0.273     0.200
    72.725     0.453     0.200
    72.745     0.698     0.200
    72.745     0.553     0.200
    72.770     0.448     0.200
    72.837     0.681     0.200
    72.877     0.314     0.200
    73.054    -1.303     0.200
    73.096    -1.477     0.200
    73.096    -1.375     0.200
    73.220    -0.693     0.200
    73.164     2.018     0.200
    73.164     1.420     0.200
    73.704     0.688     0.200
    73.870     0.455     0.200
    74.006     0.610     0.200
    74.025     0.450     0.200
    74.113    -1.909     0.200
    74.169     0.640     0.200
    74.284     0.196     0.200
    74.394     1.129     0.200
    74.465    -0.187     0.200
    74.500    -0.089     0.200
    74.737     0.534     0.200
    74.858    -0.511     0.200
    74.873     0.846     0.200
    74.952    -1.399     0.200
    74.952    -1.251     0.200
    74.952    -0.283     0.200
    74.952    -0.162     0.200
    74.968     0.480     0.200
    75.009     0.564     0.200
    75.214    -1.124     0.200
    75.214    -0.319     0.200
    75.544    -0.867     0.200
    75.566    -1.575     0.200
    75.610    -0.600     0.200
    75.764    -1.598     0.200
    75.880    -1.442     0.200
    75.902     0.334     0.200
    75.922    -0.744     0.200
    76.019     0.665     0.200
    76.106     0.543     0.200
    76.129    -0.303     0.200
    76.298    -0.121     0.200
    76.298     0.825     0.200
    76.446     0.746     0.200
    76.627    -0.951     0.200
    76.719     0.590     0.200
    76.770    -0.195     0.200
    76.989    -0.688     0.200
    77.003    -0.274     0.200
    77.044     0.173     0.200
    77.053    -0.142     0.200
    77.044     0.396     0.200
    77.044    -0.690     0.200
    77.190     0.217     0.200
    77.250     0.709     0.200
    77.310    -0.234     0.200
    77.313    -0.798     0.200
    77.313    -0.463     0.200
    77.462     0.815     0.200
    77.514     0.227     0.200
    77.611    -0.279     0.200
    77.631     1.133     0.200
    77.672    -0.010     0.200
    77.693    -1.279     0.200
    77.693    -1.080     0.200
    77.700    -0.943     0.200
    77.713     0.389     0.200
    77.755    -1.696     0.200
    77.757    -0.558     0.200
    77.759     0.360     0.200
    77.759     0.071     0.200
    77.861    -0.544     0.200
    77.862    -0.621     0.200
    77.872     0.397     0.200
    77.855     0.849     0.200
    77.904    -0.454     0.200
    78.028     0.719     0.200
    78.031     0.840     0.200
    78.075     0.836     0.200
    78.218    -0.456     0.200
    78.247    -0.044     0.200
    78.300    -0.059     0.200
    78.411    -1.029     0.200
    78.418    -0.209     0.200
    78.425     0.728     0.200
    78.457     1.057     0.200
    78.823    -0.238     0.200
    78.823     0.481     0.200
    78.848     0.429     0.200
    78.849     0.604     0.200
    78.871     0.835     0.200
    78.919     0.467     0.200
    78.928    -0.037     0.200
    78.936    -0.089     0.200
    79.025     0.720     0.200
    79.014     0.674     0.200
    79.044     0.580     0.200
    79.055    -1.919     0.200
    79.071     0.322     0.200
    79.080     0.704     0.200
    79.149     0.325     0.200
    79.180     1.205     0.200
    79.348     0.654     0.200
    79.434     0.165     0.200
    79.541    -0.682     0.200
    79.591    -0.161     0.200
    79.640     0.552     0.200
    79.651     0.131     0.200
    79.659    -0.577     0.200
    79.854    -0.163     0.200
    80.045     0.181     0.200
    80.182    -0.122     0.200
    80.182     1.960     0.200
    80.240     0.279     0.200
    80.222     0.765     0.200
    80.278    -0.011     0.200
    80.270    -0.537     0.200
    80.332    -0.703     0.200
    80.370    -0.048     0.200
    80.370    -0.243     0.200
    80.380     0.475     0.200
    80.384     0.591     0.200
    80.548    -0.340     0.200
    80.590    -0.413     0.200
    80.618    -0.404     0.200
    80.645     0.215     0.200
    80.768     0.303     0.200
    80.768    -0.350     0.200
    80.870    -2.148     0.200
    80.970     0.894     0.200
    80.989     0.334     0.200
    80.989     0.135     0.200
    80.996    -0.035     0.200
    81.024     0.276     0.200
    81.156    -0.523     0.200
    81.215    -0.152     0.200
    81.252    -0.518     0.200
    81.255    -0.167     0.200
    81.313     0.532     0.200
    81.642    -0.560     0.200
    81.642    -0.916     0.200
    81.648     0.977     0.200
    81.694    -0.011     0.200
    81.753    -0.265     0.200
    81.753     0.102     0.200
    81.747    -0.863     0.200
    81.826    -0.133     0.200
    81.886    -0.699     0.200
    81.895    -0.798     0.200
    81.916    -1.294     0.200
    81.909    -1.004     0.200
    81.920     0.645     0.200
    81.920     0.512     0.200
    82.006     0.699     0.200
    82.276    -1.032     0.200
    82.392    -0.214     0.200
    82.523     0.020     0.200
    82.541    -0.769     0.200
    82.627    -1.531     0.200
    82.700    -0.765     0.200
    82.712    -0.298     0.200
    83.018    -0.655     0.200
    83.044     0.066     0.200
    83.050    -0.094     0.200
    83.093     0.375     0.200
    83.093     0.113     0.200
    83.093     0.734     0.200
    83.136     0.274     0.200
    83.156    -1.029     0.200
    83.293    -0.476     0.200
    83.388     0.097     0.200
    83.433    -1.416     0.200
    83.460    -0.289     0.200
    83.483    -1.776     0.200
    83.544    -0.277     0.200
    83.712    -1.084     0.200
    83.781     1.124     0.200
    83.802    -1.513     0.200
    83.856    -0.552     0.200
    83.856    -1.001     0.200
    83.859    -0.285     0.200
    83.943    -1.433     0.200
    84.078    -0.681     0.200
    84.503     0.190     0.200
    84.508     0.081     0.200
    84.508     0.221     0.200
    84.529    -0.573     0.200
    84.529    -0.315     0.200
    84.532    -0.791     0.200
    84.548    -0.501     0.200
    84.555    -0.154     0.200
    84.569    -0.324     0.200
    84.705     0.495     0.200
    84.786    -1.012     0.200
    84.880    -0.832     0.200
    84.923     0.982     0.200
    84.944     0.197     0.200
    85.070    -0.338     0.200
    85.070    -0.752     0.200
    85.186    -1.114     0.200
    85.186    -1.762     0.200
    85.397    -0.231     0.200
    85.397    -0.032     0.200
    85.462    -0.289     0.200
    85.509     0.079     0.200
    85.784    -1.882     0.200
    85.799    -1.048     0.200
    86.112    -0.041     0.200
    86.338    -0.696     0.200
    86.338    -0.360     0.200
    86.348     0.675     0.200
    86.439    -0.278     0.200
    86.439    -0.586     0.200
    86.452    -1.138     0.200
    86.783    -0.461     0.200
    86.884    -0.694     0.200
    87.185     0.160     0.200
    87.185    -0.450     0.200
    87.357     0.252     0.200
    89.163     0.468     0.200
    89.163     0.225     0.200
    89.176    -0.002     0.200
    89.176    -0.103     0.200
    91.021    -0.563     0.200
    91.021    -0.313     0.200
    15.836     7.401     0.200
    16.673     1.336     0.200
    21.454     2.742     0.200
    21.548     1.760     0.200
    25.068     0.973     0.200
    25.320     0.628     0.200
    29.970    -0.787     0.200
    37.199    -2.661     0.200
    38.644    -1.739     0.200
    39.169    -0.568     0.200
    42.523    -0.939     0.200
    44.860     0.294     0.200
    45.241     0.513     0.200
    46.535    -1.076     0.200
    47.702     0.026     0.200
    48.396    -0.083     0.200
    53.035     0.404     0.200
    54.631     0.031     0.200
    55.936    -1.425     0.200
    56.159    -0.123     0.200
    60.514    -1.491     0.200
    71.026     0.079     0.200
    74.962    -1.169     0.200
    76.027     0.801     0.200
    77.678     0.435     0.200
    77.685    -2.155     0.200
    81.236    -0.809     0.200
    91.032    -1.692     0.200
    16.603     1.329     0.200
    20.498     0.021     0.200
    21.463     0.549     0.200
    21.531     0.475     0.200
    21.557     0.422     0.200
    25.029     0.553     0.200
    42.519    -1.294     0.200
    42.519     0.167     0.200
    44.455     0.349     0.200
    44.844    -0.703     0.200
    44.844     0.547     0.200
    46.710    -2.007     0.200
    55.919    -1.470     0.200
    71.022     0.622     0.200
    76.010     0.758     0.200
    77.696    -0.844     0.200
    80.980    -1.093     0.200
    81.247    -1.080     0.200
    44.876     0.826     0.200
    17.709     0.001     0.200
    20.107     0.391     0.200
    20.535     0.270     0.200
    21.436     1.502     0.200
    21.499     0.242     0.200
    21.530     1.141     0.200
    25.008     0.038     0.200
    25.052     1.279     0.200
    48.394    -1.628     0.200
    55.954    -1.748     0.200
    56.152     0.406     0.200
    76.048     0.556     0.200
    77.680    -0.723     0.200
    81.231    -1.634     0.200
    18.004     2.629     0.200
    18.409     1.164     0.200
    18.551    -3.060     0.200
    19.044     1.822     0.200
    19.670     0.806     0.200
    19.894    -0.987     0.200
    19.894    -1.448     0.200
    20.031    -1.774     0.200
    20.159    -1.170     0.200
    20.159    -1.709     0.200
    20.572    -0.255     0.200
    20.575     2.609     0.200
    20.575     1.308     0.200
    20.628    -1.202     0.200
    20.980     0.522     0.200
    20.980    -1.079     0.200
    21.094    -0.005     0.200
    21.395    -1.251     0.200
    21.489    -1.218     0.200
    21.470    -1.861     0.200
    21.470    -1.492     0.200
    21.470     0.514     0.200
    21.470    -1.111     0.200
    21.633    -0.113     0.200
    21.921    -1.329     0.200
    22.296    -0.407     0.200
    23.564    -3.334     0.200
    24.315     1.274     0.200
    24.709     0.541     0.200
    25.002    -1.391     0.200
    25.002    -0.971     0.200
    25.079     0.510     0.200
    25.370    -2.038     0.200
    25.370    -1.737     0.200
    25.345    -1.747     0.200
    25.558     0.245     0.200
    25.929     0.498     0.200
    25.929    -1.451     0.200
    25.981     0.574     0.200
    25.980     0.523     0.200
    26.123     1.345     0.200
    26.208    -0.020     0.200
    26.649     0.610     0.200
    26.632     0.633     0.200
    26.788     1.924     0.200
    27.008     1.476     0.200
    27.094     0.426     0.200
    27.603     2.814     0.200
    27.783     1.400     0.200
    27.976     2.425     0.200
    28.015     2.582     0.200
    28.135     2.950     0.200
    28.396     0.841     0.200
    28.396     2.730     0.200
    28.396     0.620     0.200
    28.396    -0.239     0.200
    29.901    -2.518     0.200
    29.901    -3.236     0.200
    29.901    -1.775     0.200
    29.974     1.242     0.200
    30.040     1.626     0.200
    30.292    -0.795     0.200
    30.292    -0.295     0.200
    30.292    -0.545     0.200
    31.188     0.855     0.200
    31.948     2.002     0.200
    32.532    -0.967     0.200
    34.231     2.052     0.200
    34.353     0.699     0.200
    34.795     1.173     0.200
    34.813     2.114     0.200
    34.953     2.504     0.200
    34.953     2.605     0.200
    35.624     0.127     0.200
    37.268    -0.272     0.200
    37.268    -1.286     0.200
    37.167     0.241     0.200
    37.117    -0.230     0.200
    37.675     0.174     0.200
    38.287    -1.334     0.200
    38.580    -0.618     0.200
    39.181     0.665     0.200
    39.181     1.566     0.200
    40.726     0.200     0.200
    40.726    -0.374     0.200
    40.726     0.436     0.200
    41.130    -2.906     0.200
    41.714    -2.606     0.200
    41.822    -0.739     0.200
    42.313    -0.078     0.200
    42.416    -2.334     0.200
    43.398     0.314     0.200
    43.607    -0.266     0.200
    43.800    -0.411     0.200
    43.800     0.208     0.200
    43.862     1.460     0.200
    43.958    -1.458     0.200
    44.212     0.367     0.200
    44.289     0.306     0.200
    44.298    -0.635     0.200
    44.353    -0.287     0.200
    44.255     0.002     0.200
    44.468     1.039     0.200
    44.468    -0.342     0.200
    44.474     0.164     0.200
    44.474    -0.348     0.200
    44.478    -0.375     0.200
    44.501    -0.325     0.200
    44.633     0.212     0.200
    44.644    -0.488     0.200
    44.808    -0.385     0.200
    44.850    -0.226     0.200
    44.866    -0.895     0.200
    44.866    -0.776     0.200
    45.038     0.750     0.200
    45.072    -0.728     0.200
    45.151    -0.559     0.200
    45.174    -0.328     0.200
    45.174    -0.918     0.200
    45.419     0.747     0.200
    45.562     0.831     0.200
    45.768    -1.167     0.200
    46.081    -1.107     0.200
    46.177    -1.102     0.200
    46.213    -2.137     0.200
    46.236    -0.865     0.200
    46.346    -0.228     0.200
    46.445     1.447     0.200
    46.501    -1.009     0.200
    46.587    -0.724     0.200
    46.736    -0.633     0.200
    46.639     0.604     0.200
    46.639     0.274     0.200
    46.819     1.231     0.200
    46.819     0.344     0.200
    46.943    -0.410     0.200
    46.943    -0.082     0.200
    46.998    -0.513     0.200
    46.827     1.633     0.200
    47.124    -0.801     0.200
    47.264    -0.292     0.200
    47.316    -0.045     0.200
    47.624    -0.992     0.200
    47.691    -1.455     0.200
    47.712    -1.274     0.200
    47.632    -1.448     0.200
    47.632    -0.647     0.200
    48.010     0.346     0.200
    48.117    -3.657     0.200
    48.117    -3.106     0.200
    48.810     0.080     0.200
    48.921     1.341     0.200
    49.120    -0.569     0.200
    49.301    -0.092     0.200
    50.167    -2.310     0.200
    50.711     0.326     0.200
    50.920     0.736     0.200
    51.441     0.589     0.200
    52.134     0.416     0.200
    53.608    -0.994     0.200
    53.699    -1.350     0.200
    53.699    -0.448     0.200
    53.771     0.424     0.200
    53.822     1.049     0.200
    54.464    -0.238     0.200
    54.480     0.176     0.200
    54.824     0.310     0.200
    54.996    -2.098     0.200
    54.996     0.582     0.200
    54.973    -1.529     0.200
    55.118     1.123     0.200
    55.930    -1.518     0.200
    55.930    -1.817     0.200
    56.467     2.142     0.200
    57.623     0.029     0.200
    58.199     2.361     0.200
    58.363     0.292     0.200
    58.650     0.456     0.200
    58.776    -0.861     0.200
    58.940    -1.640     0.200
    63.363    -0.670     0.200
    65.773    -1.124     0.200
    67.708    -0.690     0.200
    67.708    -0.376     0.200
    67.708     0.239     0.200
    67.752     0.731     0.200
    67.976     0.029     0.200
    69.041    -0.372     0.200
    69.702    -0.467     0.200
    69.967    -0.475     0.200
    70.671     0.046     0.200
    70.700    -0.728     0.200
    71.118    -0.439     0.200
    71.118    -0.822     0.200
    71.221    -1.745     0.200
    71.221    -0.893     0.200
    71.694    -0.236     0.200
    72.102     0.036     0.200
    72.266     0.705     0.200
    72.435     0.047     0.200
    72.525     0.720     0.200
    72.579    -0.156     0.200
    72.666    -1.743     0.200
    72.756     0.283     0.200
    72.757     0.991     0.200
    72.757     0.178     0.200
    72.778     0.032     0.200
    73.069     0.037     0.200
    73.093    -1.556     0.200
    73.173     0.565     0.200
    73.173     1.131     0.200
    73.219     0.718     0.200
    73.422    -0.098     0.200
    73.713     0.037     0.200
    73.879     0.174     0.200
    73.880     0.660     0.200
    73.971     2.074     0.200
    74.023     0.750     0.200
    74.034     0.177     0.200
    74.097     0.122     0.200
    74.517     0.724     0.200
    74.884     1.110     0.200
    74.961    -1.577     0.200
    74.961     0.320     0.200
    74.961    -0.792     0.200
    74.961    -1.632     0.200
    74.961    -0.780     0.200
    74.985    -0.211     0.200
    75.022     0.815     0.200
    75.219     0.182     0.200
    75.219    -1.781     0.200
    75.362    -1.636     0.200
    75.418     0.313     0.200
    75.505    -0.817     0.200
    75.629     0.526     0.200
    75.781     0.336     0.200
    75.876    -0.321     0.200
    76.086     0.061     0.200
    76.129    -0.760     0.200
    76.122     1.865     0.200
    76.194     0.049     0.200
    76.310     0.241     0.200
    76.310     0.794     0.200
    76.370     0.730     0.200
    76.464     0.754     0.200
    76.554     2.067     0.200
    76.623    -2.048     0.200
    76.735    -0.370     0.200
    76.751    -0.390     0.200
    76.763     0.462     0.200
    76.973     0.040     0.200
    77.023     1.012     0.200
    77.030     0.166     0.200
    77.035     0.671     0.200
    77.058     0.176     0.200
    77.058     0.826     0.200
    77.169    -1.273     0.200
    77.169     0.676     0.200
    77.228     0.265     0.200
    77.290     0.221     0.200
    77.312    -1.463     0.200
    77.312    -1.998     0.200
    77.473    -0.360     0.200
    77.475    -0.788     0.200
    77.498     0.634     0.200
    77.621     1.141     0.200
    77.637     1.005     0.200
    77.768     0.460     0.200
    77.580     0.035     0.200
    77.817     0.182     0.200
    77.839     0.952     0.200
    77.839     1.087     0.200
    77.847     0.081     0.200
    77.850     0.952     0.200
    77.868     0.418     0.200
    77.905    -0.319     0.200
    77.733    -0.073     0.200
    77.733     0.327     0.200
    77.740    -0.436     0.200
    77.740    -0.112     0.200
    77.762    -0.145     0.200
    77.795     0.301     0.200
    78.040     0.330     0.200
    78.043     0.300     0.200
    78.090     0.704     0.200
    78.198    -0.505     0.200
    78.227     1.121     0.200
    78.280     0.311     0.200
    78.281     0.533     0.200
    78.299     0.062     0.200
    78.301     1.726     0.200
    78.397     0.585     0.200
    78.442     1.146     0.200
    78.470     1.230     0.200
    78.529     1.521     0.200
    78.580     0.831     0.200
    78.708    -0.856     0.200
    78.832    -1.239     0.200
    78.842    -0.963     0.200
    78.864     0.077     0.200
    78.889     0.872     0.200
    78.900     1.504     0.200
    78.911     0.793     0.200
    78.919    -0.544     0.200
    79.003     1.453     0.200
    79.023     1.076     0.200
    79.018     1.638     0.200
    79.057    -0.125     0.200
    79.081     0.128     0.200
    79.089     0.539     0.200
    79.159    -0.421     0.200
    79.176     0.147     0.200
    79.198    -0.326     0.200
    79.193     0.461     0.200
    79.205     0.539     0.200
    79.213     1.066     0.200
    79.264    -0.014     0.200
    79.273     0.598     0.200
    79.277     0.866     0.200
    79.312    -0.082     0.200
    79.309     0.630     0.200
    79.321     0.862     0.200
    79.351     0.867     0.200
    79.365     0.224     0.200
    79.365     1.347     0.200
    79.407     1.684     0.200
    79.516    -0.229     0.200
    79.573     1.356     0.200
    79.620     1.201     0.200
    79.620     1.503     0.200
    79.632     1.403     0.200
    79.641     0.012     0.200
    79.799     1.652     0.200
    79.872     0.364     0.200
    79.958     1.040     0.200
    79.970    -0.915     0.200
    80.006     0.576     0.200
    80.162    -1.053     0.200
    80.162    -0.483     0.200
    80.221     0.613     0.200
    80.260    -0.183     0.200
    80.269    -0.393     0.200
    80.390     1.130     0.200
    80.390     0.188     0.200
    80.392     1.103     0.200
    80.392     0.455     0.200
    80.572    -0.450     0.200
    80.572     0.058     0.200
    80.776     1.264     0.200
    80.776     0.869     0.200
    80.823     0.754     0.200
    80.852     0.262     0.200
    80.942     0.692     0.200
    80.986     0.532     0.200
    81.006    -0.434     0.200
    81.006     0.689     0.200
    81.006     0.355     0.200
    81.013     0.492     0.200
    81.037     1.433     0.200
    81.037     0.875     0.200
    81.137    -0.262     0.200
    81.238     1.037     0.200
    81.291     0.002     0.200
    81.666     0.390     0.200
    81.737     0.615     0.200
    81.747     0.021     0.200
    81.747     0.256     0.200
    81.809    -1.652     0.200
    81.871     0.088     0.200
    81.892    -0.248     0.200
    81.900    -0.019     0.200
    81.911     0.172     0.200
    81.998     0.881     0.200
    82.079     0.475     0.200
    82.098     1.391     0.200
    82.098     1.007     0.200
    82.114    -0.093     0.200
    82.273     0.153     0.200
    82.275     0.147     0.200
    82.294     0.228     0.200
    82.294    -0.669     0.200
    82.404    -0.674     0.200
    82.404    -0.351     0.200
    82.429     0.201     0.200
    82.508     0.910     0.200
    82.508    -0.408     0.200
    82.525     0.598     0.200
    82.623     0.128     0.200
    82.623     0.006     0.200
    82.695     0.480     0.200
    82.827     0.538     0.200
    83.028     0.922     0.200
    83.035     0.558     0.200
    83.051     0.746     0.200
    83.057     0.790     0.200
    83.103    -0.047     0.200
    83.103     1.561     0.200
    83.119     1.076     0.200
    83.142     0.520     0.200
    83.142    -0.130     0.200
    83.198    -0.559     0.200
    83.287     0.635     0.200
    83.295    -0.240     0.200
    83.346     0.168     0.200
    83.371     0.146     0.200
    83.426    -1.077     0.200
    83.430    -0.526     0.200
    83.441    -0.346     0.200
    83.447     0.462     0.200
    83.447     0.779     0.200
    83.468    -0.289     0.200
    83.468     0.016     0.200
    83.600    -0.678     0.200
    83.701    -1.368     0.200
    83.791     0.460     0.200
    83.801    -1.818     0.200
    83.799     0.654     0.200
    83.853    -0.207     0.200
    83.860    -0.104     0.200
    83.911     0.026     0.200
    83.932    -1.740     0.200
    84.137     0.340     0.200
    84.137    -0.535     0.200
    84.150    -0.945     0.200
    84.179     0.794     0.200
    84.330    -0.250     0.200
    84.491     0.285     0.200
    84.514     1.521     0.200
    84.514     0.999     0.200
    84.522    -0.211     0.200
    84.522    -0.566     0.200
    84.537    -0.223     0.200
    84.550    -0.912     0.200
    84.564    -0.773     0.200
    84.605    -0.722     0.200
    84.625     0.015     0.200
    84.707     0.585     0.200
    84.712     0.446     0.200
    84.876     0.221     0.200
    84.934     1.705     0.200
    84.946    -0.239     0.200
    84.986    -0.299     0.200
    85.008     0.567     0.200
    85.032    -0.482     0.200
    85.184    -0.066     0.200
    85.240    -0.377     0.200
    85.244    -0.194     0.200
    85.326    -0.174     0.200
    85.400     0.276     0.200
    85.400     1.296     0.200
    85.405     0.805     0.200
    85.464    -0.373     0.200
    85.479     0.492     0.200
    85.522     1.087     0.200
    85.607     0.253     0.200
    85.782    -0.803     0.200
    85.796    -0.186     0.200
    85.794     0.778     0.200
    85.896     0.937     0.200
    85.918     1.333     0.200
    86.357    -0.251     0.200
    86.111     0.243     0.200
    86.455    -0.211     0.200
    86.281    -0.066     0.200
    86.332    -0.643     0.200
    86.348     1.344     0.200
    86.450     0.137     0.200
    86.449    -0.505     0.200
    86.449     1.630     0.200
    86.610     1.247     0.200
    86.524     0.213     0.200
    86.709     0.770     0.200
    86.709     1.013     0.200
    86.744    -0.099     0.200
    86.807     0.054     0.200
    86.810    -0.180     0.200
    86.877    -0.068     0.200
    86.994     0.331     0.200
    86.994     0.913     0.200
    87.189     0.820     0.200
    87.189     0.240     0.200
    87.289     1.411     0.200
    87.534    -0.384     0.200
    87.666     0.885     0.200
    88.371    -0.548     0.200
    89.152    -0.787     0.200
    89.172    -1.190     0.200
    89.226     0.862     0.200
    90.962    -1.919     0.200
    92.631    -1.325     0.200
    15.178     7.601     0.200
    15.352     5.528     0.200
    18.522     1.345     0.200
    18.850    -1.058     0.200
    19.801    -1.366     0.200
    20.675     0.542     0.200
    20.675    -1.731     0.200
    20.570    -0.225     0.200
    20.570    -1.998     0.200
    20.664     0.255     0.200
    20.647    -0.965     0.200
    20.647     0.137     0.200
    20.647    -0.551     0.200
    20.718     2.164     0.200
    21.262     1.394     0.200
    21.262     0.597     0.200
    21.379     0.141     0.200
    21.379     1.695     0.200
    22.085     0.576     0.200
    23.058    -0.049     0.200
    23.885    -1.003     0.200
    24.165    -0.141     0.200
    24.209    -0.160     0.200
    24.209    -0.441     0.200
    24.260    -1.424     0.200
    24.253    -1.198     0.200
    24.407     2.735     0.200
    24.740    -0.394     0.200
    24.774    -0.304     0.200
    25.075    -0.646     0.200
    25.165    -0.358     0.200
    25.732    -0.707     0.200
    25.828    -0.683     0.200
    25.783     1.222     0.200
    25.797     0.479     0.200
    25.968    -0.346     0.200
    26.194     0.103     0.200
    26.194    -1.694     0.200
    26.194     0.533     0.200
    26.194    -1.647     0.200
    26.265    -1.141     0.200
    26.404     0.666     0.200
    26.752     2.569     0.200
    26.780     2.065     0.200
    27.134    -0.064     0.200
    27.134    -2.189     0.200
    26.958     1.419     0.200
    26.958    -0.776     0.200
    27.151     1.517     0.200
    27.151     1.681     0.200
    27.190     1.318     0.200
    27.312     1.487     0.200
    27.312     2.034     0.200
    27.572     1.689     0.200
    27.572    -0.022     0.200
    27.838     3.819     0.200
    27.967     0.374     0.200
    27.949     1.789     0.200
    27.949     2.031     0.200
    29.180    -0.431     0.200
    29.180    -0.728     0.200
    29.180    -1.798     0.200
    29.146    -1.018     0.200
    29.463    -0.327     0.200
    29.886     1.820     0.200
    30.359    -0.465     0.200
    31.322    -0.251     0.200
    31.737    -0.964     0.200
    31.737    -0.761     0.200
    32.375    -0.471     0.200
    32.913    -0.821     0.200
    32.830     0.634     0.200
    33.253    -0.790     0.200
    33.517    -2.195     0.200
    33.609     1.507     0.200
    33.810     2.054     0.200
    33.806     0.293     0.200
    33.911     2.172     0.200
    34.156     2.050     0.200
    34.171     1.516     0.200
    34.227     1.837     0.200
    34.284     1.845     0.200
    34.299     1.217     0.200
    34.299     1.808     0.200
    34.386     2.153     0.200
    34.389     1.025     0.200
    34.830    -0.083     0.200
    34.827     1.742     0.200
    34.860     1.956     0.200
    35.728    -2.109     0.200
    36.354    -1.466     0.200
    36.538    -2.640     0.200
    36.538    -2.538     0.200
    36.769     0.234     0.200
    36.701    -0.530     0.200
    36.962     0.250     0.200
    37.503    -1.102     0.200
    37.503     1.054     0.200
    37.614    -2.182     0.200
    38.184    -1.196     0.200
    38.184    -1.399     0.200
    38.454    -0.261     0.200
    38.758    -0.226     0.200
    38.915     0.953     0.200
    38.801    -0.143     0.200
    38.801     0.420     0.200
    39.952    -2.282     0.200
    39.914     2.831     0.200
    39.898     0.762     0.200
    39.898    -0.613     0.200
    39.898    -0.473     0.200
    40.097    -0.390     0.200
    40.166    -0.049     0.200
    40.413    -1.308     0.200
    40.760    -1.573     0.200
    41.023    -1.544     0.200
    40.973     1.357     0.200
    41.710    -1.482     0.200
    41.794    -1.066     0.200
    41.926    -0.544     0.200
    41.926    -1.935     0.200
    41.980     0.885     0.200
    42.243    -1.359     0.200
    42.243    -0.094     0.200
    42.393    -1.762     0.200
    42.855     0.165     0.200
    42.899     0.301     0.200
    43.282     1.056     0.200
    43.020     1.009     0.200
    43.319     0.569     0.200
    43.333    -1.379     0.200
    43.333     0.293     0.200
    43.457     0.458     0.200
    43.488     0.972     0.200
    43.788     0.632     0.200
    43.897    -3.218     0.200
    43.897    -2.765     0.200
    43.895    -0.708     0.200
    43.895     0.471     0.200
    43.970     0.453     0.200
    44.109     0.786     0.200
    44.210     0.872     0.200
    44.365    -2.131     0.200
    44.365     0.533     0.200
    44.433     0.032     0.200
    44.446     0.019     0.200
    44.476    -2.405     0.200
    44.421    -0.109     0.200
    44.471    -1.252     0.200
    44.471     0.599     0.200
    44.401     1.020     0.200
    44.401    -0.878     0.200
    44.436     0.788     0.200
    44.436     0.358     0.200
    44.513    -1.653     0.200
    44.560     1.267     0.200
    44.861    -3.075     0.200
    44.850    -0.138     0.200
    44.891     0.033     0.200
    45.040    -0.059     0.200
    45.090     0.973     0.200
    44.892     0.261     0.200
    45.219    -1.879     0.200
    45.215     0.181     0.200
    45.084     0.855     0.200
    45.388     0.564     0.200
    45.395    -1.322     0.200
    45.395     0.686     0.200
    45.426    -0.018     0.200
    45.425    -0.020     0.200
    45.449    -1.958     0.200
    45.636    -0.308     0.200
    45.667    -0.965     0.200
    45.842     1.692     0.200
    45.842    -0.699     0.200
    45.924     0.179     0.200
    46.223    -0.992     0.200
    46.349    -0.023     0.200
    46.394    -2.705     0.200
    46.394    -2.416     0.200
    46.255    -0.562     0.200
    46.116     1.373     0.200
    46.156     0.928     0.200
    46.543    -0.143     0.200
    46.431    -0.642     0.200
    46.397     0.399     0.200
    46.691    -0.658     0.200
    46.776    -1.567     0.200
    46.627     0.717     0.200
    46.992    -0.424     0.200
    46.967    -0.895     0.200
    46.967    -1.535     0.200
    46.967    -0.942     0.200
    46.967    -1.535     0.200
    46.979    -2.638     0.200
    47.272     0.229     0.200
    47.006     0.796     0.200
    47.204    -0.072     0.200
    47.638    -1.243     0.200
    47.688    -2.524     0.200
    47.833    -2.100     0.200
    47.868    -1.154     0.200
    47.868    -0.849     0.200
    47.872    -0.811     0.200
    47.908     0.561     0.200
    47.954    -1.942     0.200
    47.760     0.655     0.200
    48.237     0.421     0.200
    48.248    -1.487     0.200
    48.297     0.693     0.200
    48.320    -0.243     0.200
    48.339    -2.492     0.200
    48.485    -1.668     0.200
    48.459    -0.832     0.200
    48.710    -1.736     0.200
    48.710     0.483     0.200
    48.980    -0.421     0.200
    49.092    -0.732     0.200
    48.908     0.269     0.200
    49.307    -0.924     0.200
    49.406    -0.487     0.200
    49.406    -1.776     0.200
    49.620    -2.013     0.200
    49.697    -2.275     0.200
    49.687    -0.839     0.200
    49.961    -0.869     0.200
    50.097    -2.341     0.200
    50.097    -0.638     0.200
    50.045     0.152     0.200
    50.578     0.317     0.200
    50.668     0.172     0.200
    50.799    -1.552     0.200
    50.794     0.536     0.200
    50.814     0.166     0.200
    50.773    -0.420     0.200
    50.977    -1.168     0.200
    50.989    -0.071     0.200
    50.989    -0.759     0.200
    51.048     0.087     0.200
    51.239    -1.745     0.200
    51.239     0.278     0.200
    50.938     1.365     0.200
    51.539     0.091     0.200
    51.639     0.007     0.200
    51.748     0.435     0.200
    51.867    -0.033     0.200
    51.779     1.464     0.200
    51.784     0.952     0.200
    51.784     1.170     0.200
    51.894     0.053     0.200
    51.923     0.495     0.200
    52.054     1.108     0.200
    52.112     1.166     0.200
    52.112    -0.678     0.200
    52.206     0.628     0.200
    52.206    -0.693     0.200
    52.206     0.876     0.200
    52.206    -0.483     0.200
    52.597     1.025     0.200
    52.597     0.924     0.200
    52.650     1.131     0.200
    52.785     0.164     0.200
    52.853     1.476     0.200
    53.087     0.262     0.200
    53.087    -1.199     0.200
    53.087     0.004     0.200
    53.175     0.062     0.200
    53.254     0.173     0.200
    53.217     0.342     0.200
    53.226     0.683     0.200
    53.252     0.191     0.200
    53.328     0.114     0.200
    53.411     0.824     0.200
    53.687     1.097     0.200
    53.751    -0.073     0.200
    53.854    -0.495     0.200
    53.854     0.169     0.200
    53.899    -0.125     0.200
    53.990    -0.821     0.200
    54.047     0.963     0.200
    54.122     0.312     0.200
    54.156     0.141     0.200
    54.280     0.165     0.200
    54.297     0.448     0.200
    54.477     0.937     0.200
    55.018     0.310     0.200
    55.150    -0.235     0.200
    55.192     1.098     0.200
    55.239    -0.084     0.200
    55.335    -1.178     0.200
    55.335     0.517     0.200
    55.335    -1.538     0.200
    55.365    -1.047     0.200
    55.171     1.025     0.200
    55.492     0.118     0.200
    55.492    -0.796     0.200
    55.567    -0.729     0.200
    55.567    -1.050     0.200
    55.846     1.096     0.200
    55.855    -1.537     0.200
    55.951     0.239     0.200
    55.976     0.661     0.200
    55.800     0.178     0.200
    56.345    -1.742     0.200
    56.345    -2.328     0.200
    56.496     0.453     0.200
    56.238     0.671     0.200
    56.762    -2.340     0.200
    56.845     0.970     0.200
    56.968     1.177     0.200
    57.198    -0.971     0.200
    57.169     0.765     0.200
    57.227    -1.480     0.200
    57.372    -0.645     0.200
    57.567     0.551     0.200
    57.593     0.442     0.200
    57.595     0.786     0.200
    57.770     0.764     0.200
    57.818     0.772     0.200
    57.871    -1.439     0.200
    57.821    -0.065     0.200
    58.182     1.007     0.200
    58.512    -0.899     0.200
    59.214    -0.585     0.200
    59.511     1.874     0.200
    60.533    -0.738     0.200
    60.636    -1.159     0.200
    63.664    -1.750     0.200
    64.685    -1.661     0.200
    66.153    -1.151     0.200
    66.648     0.995     0.200
    69.131    -0.917     0.200
    69.516    -0.755     0.200
    69.516    -1.083     0.200
    70.332     1.146     0.200
    70.436     0.800     0.200
    70.415     0.045     0.200
    70.949    -0.124     0.200
    71.026     0.064     0.200
    71.026     1.635     0.200
    71.218    -0.136     0.200
    71.294     1.930     0.200
    71.421     0.488     0.200
    71.853     0.467     0.200
    71.853     1.077     0.200
    72.204     0.293     0.200
    72.270    -0.064     0.200
    72.378     0.736     0.200
    72.401     1.015     0.200
    72.836     0.595     0.200
    72.936     0.373     0.200
    72.978     0.512     0.200
    73.289     0.245     0.200
    73.289     1.253     0.200
    73.671     2.761     0.200
    74.484    -0.805     0.200
    74.618     0.119     0.200
    74.750    -1.266     0.200
    74.691    -0.163     0.200
    75.201     0.640     0.200
    75.459    -0.756     0.200
    75.459     0.158     0.200
    75.459    -0.599     0.200
    75.574     0.698     0.200
    75.664     0.886     0.200
    76.222    -1.318     0.200
    76.232    -0.257     0.200
    76.622     1.259     0.200
    76.622     0.837     0.200
    76.672     0.549     0.200
    76.846     0.769     0.200
    76.846     1.300     0.200
    77.294     0.661     0.200
    77.625     0.735     0.200
    77.625     0.962     0.200
    77.691    -0.665     0.200
    77.790    -0.429     0.200
    78.234     1.863     0.200
    78.267     0.931     0.200
    77.950    -0.605     0.200
    77.950    -0.308     0.200
    77.952    -0.471     0.200
    78.481     0.957     0.200
    78.663     0.680     0.200
    78.885     1.210     0.200
    79.033     1.202     0.200
    79.036     0.022     0.200
    79.308     0.308     0.200
    79.308     1.105     0.200
    79.484     1.122     0.200
    79.658     0.076     0.200
    79.722     0.203     0.200
    79.910     1.048     0.200
    79.955     1.195     0.200
    79.803     0.038     0.200
    80.142     1.138     0.200
    80.453     0.000     0.200
    80.546     1.268     0.200
    80.822     0.891     0.200
    80.890     0.318     0.200
    80.890     0.951     0.200
    81.142     0.918     0.200
    81.261     0.285     0.200
    81.261     1.105     0.200
    81.101    -0.105     0.200
    81.413     0.811     0.200
    81.582     0.601     0.200
    81.582     1.702     0.200
    81.601    -0.505     0.200
    81.601     0.433     0.200
    81.484    -0.338     0.200
    81.484    -0.479     0.200
    82.128    -0.396     0.200
    82.128     0.221     0.200
    82.152     0.188     0.200
    82.263     1.097     0.200
    82.594     1.029     0.200
    82.682     0.883     0.200
    82.531     1.533     0.200
    82.531     0.478     0.200
    83.305     0.232     0.200
    83.109     1.317     0.200
    83.609     0.640     0.200
    83.609     1.562     0.200
    83.951    -1.294     0.200
    84.301     0.581     0.200
    84.372     1.019     0.200
    84.721     2.084     0.200
    84.721     0.732     0.200
    84.819    -0.319     0.200
    84.819    -0.569     0.200
    85.462     0.520     0.200
    85.462     1.442     0.200
    85.554     0.055     0.200
    85.554     0.297     0.200
    85.835     0.874     0.200
    85.695     0.806     0.200
    86.067     0.820     0.200
    86.651    -0.910     0.200
    86.651    -0.215     0.200
    86.958     0.362     0.200
    86.958     0.893     0.200
    89.674     0.280     0.200
    89.675     0.347     0.200
    90.249     0.112     0.200
    90.249    -0.334     0.200
    91.961    -0.851     0.200
    15.123     4.943     0.200
    15.263     7.002     0.200
    16.249     3.308     0.200
    17.126     3.813     0.200
    17.126     1.913     0.200
    18.716     0.755     0.200
    19.107    -0.943     0.200
    20.050    -0.646     0.200
    20.421     0.104     0.200
    20.816    -0.861     0.200
    20.816    -0.361     0.200
    20.911     0.193     0.200
    20.904    -0.378     0.200
    20.904    -0.008     0.200
    20.904     0.017     0.200
    20.904    -0.108     0.200
    20.872     1.934     0.200
    21.019    -0.039     0.200
    21.019     1.054     0.200
    21.066    -0.320     0.200
    21.296     0.044     0.200
    23.270     1.446     0.200
    24.141     1.043     0.200
    24.392     0.253     0.200
    24.437     0.237     0.200
    24.437    -0.053     0.200
    24.502    -0.448     0.200
    24.788    -1.154     0.200
    24.997     1.148     0.200
    25.031     1.340     0.200
    25.642     1.391     0.200
    25.938     0.134     0.200
    25.938     0.956     0.200
    26.085     2.278     0.200
    26.519     0.949     0.200
    26.914    -1.105     0.200
    27.140     2.194     0.200
    27.214     0.497     0.200
    27.829     0.883     0.200
    27.829     0.316     0.200
    27.829     1.486     0.200
    27.835     2.075     0.200
    29.216     3.436     0.200
    29.376    -0.680     0.200
    29.717    -0.132     0.200
    29.717    -0.531     0.200
    29.717    -1.071     0.200
    31.610     0.117     0.200
    31.966    -1.086     0.200
    32.396    -0.283     0.200
    32.632     0.973     0.200
    33.085    -0.350     0.200
    33.509     0.677     0.200
    33.666    -0.021     0.200
    34.137     2.090     0.200
    34.458     1.809     0.200
    34.517     2.293     0.200
    34.612     1.071     0.200
    35.062     1.790     0.200
    36.611    -0.151     0.200
    36.684    -1.418     0.200
    36.900    -0.506     0.200
    36.900    -0.956     0.200
    37.082    -1.036     0.200
    37.082    -1.223     0.200
    37.282     1.181     0.200
    38.262    -0.634     0.200
    38.262    -1.095     0.200
    38.601    -0.267     0.200
    38.692     0.427     0.200
    39.219    -0.824     0.200
    39.846    -0.939     0.200
    40.148     0.851     0.200
    40.148     1.275     0.200
    40.148     1.185     0.200
    40.607    -2.350     0.200
    40.930    -1.413     0.200
    41.081    -0.540     0.200
    41.207    -2.592     0.200
    41.531    -0.486     0.200
    41.594    -0.384     0.200
    41.635    -0.478     0.200
    41.703    -1.025     0.200
    41.765     0.079     0.200
    41.862    -0.001     0.200
    41.900    -1.472     0.200
    41.972     0.640     0.200
    41.984    -0.010     0.200
    42.048    -1.457     0.200
    42.050    -0.898     0.200
    42.050    -1.048     0.200
    42.047     0.080     0.200
    42.363    -0.679     0.200
    42.406    -0.227     0.200
    42.604    -0.604     0.200
    42.654    -0.165     0.200
    42.690    -0.222     0.200
    42.690    -0.029     0.200
    42.702    -0.136     0.200
    43.009    -0.475     0.200
    43.038     0.062     0.200
    43.067    -0.409     0.200
    43.067     0.210     0.200
    43.213    -0.308     0.200
    43.247     0.305     0.200
    43.444     0.760     0.200
    43.558     0.031     0.200
    43.585    -2.241     0.200
    43.571     0.586     0.200
    43.689    -0.249     0.200
    43.689     0.315     0.200
    43.761     0.432     0.200
    43.833     0.109     0.200
    43.857     0.062     0.200
    43.972     0.535     0.200
    43.972     0.852     0.200
    43.974     0.505     0.200
    44.162     0.691     0.200
    44.229    -0.795     0.200
    44.229     0.442     0.200
    44.234    -0.876     0.200
    44.234     0.562     0.200
    44.245     0.369     0.200
    44.238     0.697     0.200
    44.281    -0.076     0.200
    44.314     0.972     0.200
    44.340    -0.595     0.200
    44.470     0.823     0.200
    44.536     0.973     0.200
    44.596     0.382     0.200
    44.624     0.262     0.200
    44.618     1.219     0.200
    44.619     1.484     0.200
    44.619    -1.276     0.200
    44.619     0.954     0.200
    44.654    -1.120     0.200
    44.679    -0.390     0.200
    44.736    -1.575     0.200
    44.802     0.467     0.200
    44.802     0.939     0.200
    44.825     0.517     0.200
    44.834     0.347     0.200
    44.877     0.590     0.200
    44.939     1.364     0.200
    44.991    -0.776     0.200
    45.004     0.346     0.200
    45.153     1.222     0.200
    45.177    -0.964     0.200
    45.177     0.376     0.200
    45.193    -0.661     0.200
    45.193     0.860     0.200
    45.220     0.015     0.200
    45.220     0.087     0.200
    45.244     1.076     0.200
    45.377    -0.270     0.200
    45.339    -0.803     0.200
    45.339     0.072     0.200
    45.416    -1.023     0.200
    45.429    -0.326     0.200
    45.429    -0.172     0.200
    45.521     0.806     0.200
    45.521     0.679     0.200
    45.536     0.080     0.200
    45.559    -0.199     0.200
    45.573     0.571     0.200
    45.572     0.629     0.200
    45.603    -0.362     0.200
    45.824     0.120     0.200
    45.827     0.717     0.200
    45.883    -0.432     0.200
    45.956    -0.433     0.200
    45.956     0.778     0.200
    45.980    -0.040     0.200
    45.978    -0.285     0.200
    45.976     1.289     0.200
    46.087    -0.441     0.200
    46.087     0.030     0.200
    46.072     3.136     0.200
    46.118     0.025     0.200
    46.138    -0.266     0.200
    46.138     0.112     0.200
    46.144     0.196     0.200
    46.152     0.299     0.200
    46.213    -0.344     0.200
    46.330    -0.113     0.200
    46.371    -0.271     0.200
    46.428     0.084     0.200
    46.469     0.004     0.200
    46.469    -0.126     0.200
    46.469    -0.988     0.200
    46.488    -0.436     0.200
    46.569    -0.616     0.200
    46.569    -0.757     0.200
    46.570    -0.580     0.200
    46.619    -0.125     0.200
    46.619    -0.469     0.200
    46.698    -0.677     0.200
    46.811    -0.817     0.200
    46.811    -1.120     0.200
    46.832    -0.247     0.200
    46.848    -0.495     0.200
    46.866    -0.517     0.200
    46.869    -2.422     0.200
    46.891    -0.806     0.200
    46.964    -0.119     0.200
    46.970    -0.307     0.200
    47.072    -0.676     0.200
    47.115    -1.536     0.200
    47.141    -1.073     0.200
    47.193    -0.205     0.200
    47.193    -0.390     0.200
    47.240    -0.246     0.200
    47.288    -1.000     0.200
    47.288    -0.493     0.200
    47.307    -0.613     0.200
    47.321    -0.192     0.200
    47.349    -0.446     0.200
    47.373    -0.950     0.200
    47.547    -0.971     0.200
    47.550    -0.512     0.200
    47.617    -0.199     0.200
    47.636     0.075     0.200
    47.694     0.221     0.200
    47.694    -0.256     0.200
    47.698    -0.219     0.200
    47.698     0.023     0.200
    47.739    -1.128     0.200
    47.934    -0.987     0.200
    47.969    -1.078     0.200
    47.969    -1.104     0.200
    47.971    -1.047     0.200
    48.046    -1.090     0.200
    48.032    -0.097     0.200
    48.056    -2.026     0.200
    48.056    -1.165     0.200
    48.043     0.664     0.200
    48.085    -0.728     0.200
    48.085     0.034     0.200
    48.095    -0.107     0.200
    48.132    -1.271     0.200
    48.120    -0.318     0.200
    48.319    -1.681     0.200
    48.394     0.395     0.200
    48.503    -0.242     0.200
    48.519     0.071     0.200
    48.863    -0.117     0.200
    48.899    -1.130     0.200
    49.253    -0.612     0.200
    49.389     0.180     0.200
    49.510    -0.923     0.200
    49.510    -0.563     0.200
    49.570    -0.130     0.200
    50.008    -0.146     0.200
    50.070    -2.087     0.200
    50.198     0.235     0.200
    50.304    -0.178     0.200
    50.734    -1.354     0.200
    51.040    -0.325     0.200
    51.137     0.004     0.200
    51.153    -0.340     0.200
    51.165    -0.227     0.200
    51.342    -0.225     0.200
    51.642     0.465     0.200
    51.655     0.078     0.200
    51.871     0.135     0.200
    51.955     1.063     0.200
    52.093     0.409     0.200
    52.236     0.551     0.200
    52.296     0.658     0.200
    52.419    -0.297     0.200
    52.419    -0.108     0.200
    52.419     1.041     0.200
    52.419    -0.249     0.200
    52.779     0.213     0.200
    52.810     0.995     0.200
    52.959     0.067     0.200
    53.034     1.512     0.200
    53.053     0.219     0.200
    53.241    -0.185     0.200
    53.369    -0.323     0.200
    53.376     0.324     0.200
    53.400     0.246     0.200
    53.572     0.187     0.200
    53.844     2.091     0.200
    53.841     0.462     0.200
    53.928     0.309     0.200
    53.991    -0.201     0.200
    54.008     0.095     0.200
    54.001    -0.667     0.200
    54.042    -0.064     0.200
    54.129    -1.253     0.200
    54.129    -0.793     0.200
    54.276     0.136     0.200
    54.276     0.336     0.200
    54.278    -0.197     0.200
    54.331     0.283     0.200
    54.475    -0.181     0.200
    54.891    -0.524     0.200
    55.134    -0.621     0.200
    55.211    -0.043     0.200
    55.264    -0.321     0.200
    55.318     1.208     0.200
    55.318    -0.066     0.200
    55.318    -1.077     0.200
    55.336    -0.425     0.200
    55.348     0.624     0.200
    55.483    -0.582     0.200
    55.483    -0.402     0.200
    55.471    -0.553     0.200
    55.641     0.106     0.200
    55.641    -0.109     0.200
    55.667    -0.725     0.200
    55.754     0.009     0.200
    55.754    -0.814     0.200
    56.129     0.529     0.200
    56.176    -1.871     0.200
    56.230    -0.815     0.200
    56.654     0.576     0.200
    56.799     1.297     0.200
    57.002     0.751     0.200
    57.121     0.997     0.200
    57.290    -0.780     0.200
    57.540    -0.468     0.200
    57.573    -0.915     0.200
    57.716     0.719     0.200
    57.744     0.950     0.200
    57.745     0.268     0.200
    57.771    -0.157     0.200
    57.799    -1.348     0.200
    57.831    -1.046     0.200
    57.831    -0.420     0.200
    57.918     0.463     0.200
    57.959     0.294     0.200
    57.966     0.857     0.200
    58.004    -0.527     0.200
    58.025    -0.937     0.200
    58.073     0.150     0.200
    58.311    -0.535     0.200
    58.330     0.085     0.200
    58.542    -0.675     0.200
    58.888     0.503     0.200
    60.046    -2.083     0.200
    60.319    -0.764     0.200
    60.463    -0.809     0.200
    60.794    -0.732     0.200
    61.533    -1.253     0.200
    61.634    -0.378     0.200
    67.860     0.106     0.200
    68.038     0.417     0.200
    69.443    -1.040     0.200
    69.974     1.288     0.200
    70.088     0.486     0.200
    70.122     0.712     0.200
    70.223     0.557     0.200
    70.228     0.884     0.200
    70.286     0.228     0.200
    70.384     0.151     0.200
    70.544     0.132     0.200
    70.730     1.254     0.200
    70.813     0.949     0.200
    71.016     0.254     0.200
    71.082     1.049     0.200
    71.264     0.833     0.200
    71.374    -0.325     0.200
    71.479     0.528     0.200
    71.638     0.568     0.200
    71.693     1.163     0.200
    72.080     0.261     0.200
    73.091     0.781     0.200
    73.183     0.729     0.200
    73.299    -1.466     0.200
    73.481     1.420     0.200
    74.404    -0.153     0.200
    74.995    -0.107     0.200
    75.269     0.191     0.200
    75.269    -0.280     0.200
    75.489    -0.981     0.200
    75.489     0.068     0.200
    76.219    -0.700     0.200
    76.366    -0.428     0.200
    76.410     0.645     0.200
    76.646     1.022     0.200
    76.817    -1.218     0.200
    77.418     0.721     0.200
    77.536    -0.942     0.200
    78.012     0.676     0.200
    78.022     1.495     0.200
    77.931    -0.938     0.200
    78.077     0.726     0.200
    78.268     1.208     0.200
    78.454     0.453     0.200
    78.573     1.030     0.200
    78.674     0.983     0.200
    78.820     0.877     0.200
    78.821     0.359     0.200
    78.975     0.005     0.200
    79.020     1.354     0.200
    79.124     0.981     0.200
    79.484    -0.953     0.200
    79.494    -0.991     0.200
    79.694     0.951     0.200
    79.742     0.795     0.200
    79.974    -0.504     0.200
    80.032     0.026     0.200
    80.391     0.885     0.200
    80.611     0.913     0.200
    80.652     0.249     0.200
    80.700     0.890     0.200
    80.710     0.885     0.200
    81.075     0.696     0.200
    81.193     1.557     0.200
    81.200     1.086     0.200
    81.380     0.993     0.200
    81.387    -1.238     0.200
    81.387     0.895     0.200
    81.394     0.895     0.200
    81.550    -0.283     0.200
    81.571     0.225     0.200
    81.470    -0.838     0.200
    81.817    -0.000     0.200
    81.943    -0.281     0.200
    81.983    -0.517     0.200
    82.049     1.168     0.200
    82.266     0.755     0.200
    82.379    -0.302     0.200
    82.459    -0.660     0.200
    82.788     0.852     0.200
    82.788     1.299     0.200
    82.788     1.589     0.200
    83.122    -0.863     0.200
    83.417    -0.066     0.200
    83.417     1.334     0.200
    83.417     1.036     0.200
    83.617    -0.984     0.200
    83.830    -1.026     0.200
    84.053    -0.344     0.200
    84.164    -0.342     0.200
    84.517    -0.184     0.200
    84.685    -0.086     0.200
    84.796     0.480     0.200
    85.225    -0.174     0.200
    85.265     1.101     0.200
    85.370     0.339     0.200
    85.663     0.778     0.200
    85.948    -0.258     0.200
    85.948     1.362     0.200
    86.510     0.032     0.200
    86.510    -0.280     0.200
    86.766     0.532     0.200
    87.464     0.137     0.200
    88.605     0.378     0.200
    89.462     0.156     0.200
    89.484     0.517     0.200
    89.672    -0.242     0.200
    89.810    -0.409     0.200
    90.442    -0.426     0.200
    15.274     6.567     0.200
    17.616     2.244     0.200
    18.921     0.646     0.200
    19.815     0.158     0.200
    19.815    -1.006     0.200
    19.834     0.016     0.200
    19.840    -1.203     0.200
    20.892     1.764     0.200
    21.252     2.089     0.200
    21.577    -0.812     0.200
    21.579    -0.873     0.200
    21.644    -0.540     0.200
    21.644    -0.032     0.200
    21.644     0.385     0.200
    21.644    -0.623     0.200
    21.644     0.326     0.200
    21.644    -0.135     0.200
    21.738    -0.714     0.200
    21.738    -0.933     0.200
    21.809    -0.068     0.200
    22.024     1.097     0.200
    23.342    -0.476     0.200
    23.565     0.777     0.200
    23.706    -1.412     0.200
    23.952     1.239     0.200
    24.552     0.353     0.200
    24.887     0.667     0.200
    25.199     0.388     0.200
    25.199    -0.972     0.200
    25.199     0.228     0.200
    25.264    -0.792     0.200
    25.309     0.433     0.200
    25.220     1.691     0.200
    25.260    -0.783     0.200
    25.345    -1.539     0.200
    25.344    -0.047     0.200
    25.494    -3.222     0.200
    25.494    -0.410     0.200
    25.705     0.884     0.200
    25.715    -0.861     0.200
    25.693    -2.442     0.200
    25.741    -0.841     0.200
    25.767    -1.955     0.200
    25.968    -1.149     0.200
    26.137    -1.436     0.200
    26.383    -1.397     0.200
    26.595    -1.956     0.200
    26.595    -0.265     0.200
    26.735    -1.576     0.200
    26.815    -0.009     0.200
    26.862    -0.146     0.200
    27.300     0.123     0.200
    27.777    -0.381     0.200
    27.969    -0.969     0.200
    28.574     0.198     0.200
    28.574    -0.165     0.200
    28.574     0.808     0.200
    29.780     2.106     0.200
    30.257    -1.372     0.200
    30.257    -0.915     0.200
    30.498    -0.207     0.200
    30.586     1.180     0.200
    32.213     1.332     0.200
    32.355     0.754     0.200
    32.836    -0.406     0.200
    32.836    -0.906     0.200
    32.757     2.587     0.200
    33.370    -0.030     0.200
    33.952    -0.135     0.200
    34.254    -1.123     0.200
    34.241     0.610     0.200
    34.510    -1.770     0.200
    34.421     1.198     0.200
    34.512     1.111     0.200
    34.734     1.486     0.200
    34.778     1.105     0.200
    34.916     1.218     0.200
    34.916     1.320     0.200
    34.946     0.656     0.200
    34.972     0.538     0.200
    35.010     1.204     0.200
    36.587    -1.320     0.200
    36.954     0.501     0.200
    36.822     0.870     0.200
    37.314    -0.877     0.200
    37.524    -1.976     0.200
    37.654    -0.549     0.200
    37.655    -0.650     0.200
    37.655    -1.037     0.200
    37.655    -0.689     0.200
    37.782    -0.590     0.200
    37.782    -0.364     0.200
    38.312    -0.455     0.200
    38.354     1.151     0.200
    38.416    -1.204     0.200
    38.633     0.472     0.200
    38.662     0.477     0.200
    38.985    -0.943     0.200
    38.985    -1.455     0.200
    38.985    -1.615     0.200
    38.977     0.340     0.200
    38.977    -0.629     0.200
    39.944    -0.868     0.200
    40.374    -1.785     0.200
    40.557    -0.000     0.200
    40.913     0.731     0.200
    40.966    -0.698     0.200
    40.959     0.547     0.200
    40.959    -0.676     0.200
    40.959    -0.637     0.200
    41.345     0.845     0.200
    41.362     0.530     0.200
    41.428     0.513     0.200
    41.470     0.590     0.200
    41.488    -1.327     0.200
    41.540     0.596     0.200
    41.642     1.114     0.200
    41.727     0.532     0.200
    41.795    -0.542     0.200
    41.860    -0.003     0.200
    41.860     0.262     0.200
    41.928     0.060     0.200
    42.165     0.602     0.200
    42.178     0.168     0.200
    42.433    -0.081     0.200
    42.433     0.637     0.200
    42.438     0.252     0.200
    42.444     0.005     0.200
    42.509     0.704     0.200
    42.526     1.018     0.200
    42.487    -0.388     0.200
    42.776     0.565     0.200
    42.776     0.432     0.200
    42.776     0.574     0.200
    42.785     0.381     0.200
    42.791     0.397     0.200
    42.779    -1.056     0.200
    42.819     0.661     0.200
    42.855    -0.847     0.200
    42.857    -0.663     0.200
    42.857    -0.807     0.200
    42.985     0.516     0.200
    43.013     0.697     0.200
    43.023    -0.443     0.200
    43.036     0.437     0.200
    43.064     0.969     0.200
    43.266    -0.332     0.200
    43.266     0.891     0.200
    43.327    -1.021     0.200
    43.380     0.704     0.200
    43.451    -1.105     0.200
    43.451     0.942     0.200
    43.503    -0.133     0.200
    43.503     1.238     0.200
    43.608     1.322     0.200
    43.621     0.838     0.200
    43.643    -0.102     0.200
    43.643     0.793     0.200
    43.670     0.892     0.200
    43.843     0.894     0.200
    43.847     1.880     0.200
    43.908    -0.531     0.200
    43.909    -0.113     0.200
    43.909     1.286     0.200
    43.959    -1.760     0.200
    43.959     0.732     0.200
    43.963     0.571     0.200
    43.963     0.746     0.200
    43.982     0.675     0.200
    44.000     0.306     0.200
    44.000     0.701     0.200
    44.022     0.679     0.200
    44.067     0.323     0.200
    44.096    -1.692     0.200
    44.110    -2.394     0.200
    44.218     0.862     0.200
    44.231     0.411     0.200
    44.340    -0.381     0.200
    44.340     0.373     0.200
    44.392    -2.349     0.200
    44.408     0.192     0.200
    44.414     0.906     0.200
    44.419     0.214     0.200
    44.454     1.074     0.200
    44.478     0.764     0.200
    44.478     1.116     0.200
    44.582     0.040     0.200
    44.582     0.696     0.200
    44.585     0.567     0.200
    44.585    -0.093     0.200
    44.588     0.540     0.200
    44.588     0.677     0.200
    44.588     0.880     0.200
    44.595     1.040     0.200
    44.595     0.618     0.200
    44.589     1.711     0.200
    44.636     1.113     0.200
    44.742     0.363     0.200
    44.751     0.479     0.200
    44.874     1.160     0.200
    44.907     1.850     0.200
    44.971    -1.851     0.200
    44.971     0.446     0.200
    44.978    -2.658     0.200
    44.978     0.221     0.200
    44.978    -0.880     0.200
    45.026     0.868     0.200
    45.025     0.579     0.200
    45.181     0.166     0.200
    45.181    -0.213     0.200
    45.242     0.885     0.200
    45.243     0.539     0.200
    45.346     1.971     0.200
    45.379     0.985     0.200
    45.561     1.300     0.200
    45.588    -2.437     0.200
    45.534    -0.340     0.200
    45.600    -0.076     0.200
    45.639     0.401     0.200
    45.612    -0.955     0.200
    45.694    -0.734     0.200
    45.689     0.264     0.200
    45.659    -0.425     0.200
    45.792     0.416     0.200
    45.792     0.914     0.200
    45.866    -0.106     0.200
    45.866     0.023     0.200
    45.875     0.629     0.200
    45.875     0.204     0.200
    46.021    -0.413     0.200
    46.021    -0.593     0.200
    46.048    -0.308     0.200
    46.163    -0.939     0.200
    46.163    -0.400     0.200
    46.173     0.758     0.200
    46.229    -1.856     0.200
    46.253     0.399     0.200
    46.261    -0.597     0.200
    46.322     0.166     0.200
    46.460    -1.191     0.200
    46.554     0.264     0.200
    46.604     0.465     0.200
    46.646    -2.557     0.200
    46.674     0.374     0.200
    46.700    -0.220     0.200
    46.700    -0.540     0.200
    46.700     0.432     0.200
    46.719     0.209     0.200
    46.863    -0.508     0.200
    46.863     0.500     0.200
    46.872     0.260     0.200
    46.914     0.478     0.200
    46.928    -0.624     0.200
    46.928    -0.394     0.200
    46.991    -0.284     0.200
    47.081     0.164     0.200
    47.148     0.025     0.200
    47.148    -0.420     0.200
    47.248    -0.213     0.200
    47.302    -0.781     0.200
    47.364    -0.790     0.200
    47.364     0.139     0.200
    47.350    -0.900     0.200
    47.407     0.359     0.200
    47.793    -0.784     0.200
    47.793     0.658     0.200
    47.805     0.587     0.200
    47.808     0.866     0.200
    47.839    -0.037     0.200
    47.839     0.787     0.200
    47.912     0.043     0.200
    47.944    -0.777     0.200
    47.944    -1.437     0.200
    48.018     0.582     0.200
    48.018     0.281     0.200
    48.010    -0.967     0.200
    48.010    -1.280     0.200
    48.010    -0.448     0.200
    48.233     0.358     0.200
    48.254    -0.505     0.200
    48.254     1.120     0.200
    48.274    -1.754     0.200
    48.274    -1.520     0.200
    48.394    -2.447     0.200
    48.471     0.048     0.200
    48.507    -0.586     0.200
    48.518    -0.633     0.200
    48.518     0.340     0.200
    48.554    -0.450     0.200
    48.562     0.885     0.200
    48.619     0.992     0.200
    48.662     0.620     0.200
    48.700    -0.416     0.200
    48.734    -0.727     0.200
    48.735    -1.016     0.200
    48.735    -0.590     0.200
    48.798    -0.735     0.200
    48.826    -0.991     0.200
    48.826    -0.624     0.200
    48.897    -0.535     0.200
    48.950     0.329     0.200
    48.984     0.859     0.200
    48.986    -1.041     0.200
    49.141     0.774     0.200
    49.221    -0.261     0.200
    49.344     0.981     0.200
    49.401    -0.535     0.200
    49.723     1.115     0.200
    49.795     0.966     0.200
    50.012    -0.438     0.200
    50.062     1.101     0.200
    50.503     0.413     0.200
    50.530    -0.577     0.200
    50.573     0.388     0.200
    50.823     0.766     0.200
    50.838     0.615     0.200
    50.834     0.553     0.200
    50.916    -0.079     0.200
    51.147     0.603     0.200
    51.147     0.267     0.200
    51.148    -0.382     0.200
    51.339     0.756     0.200
    51.498     0.479     0.200
    51.521    -0.481     0.200
    51.612    -0.356     0.200
    51.663    -0.392     0.200
    51.822    -0.045     0.200
    52.040    -0.063     0.200
    52.023    -0.678     0.200
    52.036    -0.551     0.200
    52.216     0.102     0.200
    52.657     2.210     0.200
    52.837     0.175     0.200
    53.013    -0.038     0.200
    53.242    -0.208     0.200
    53.300     0.350     0.200
    53.301    -0.441     0.200
    53.301    -0.292     0.200
    53.301     0.759     0.200
    53.974     0.245     0.200
    54.066     0.400     0.200
    54.192    -0.304     0.200
    54.214     0.571     0.200
    54.219     0.434     0.200
    54.353    -0.188     0.200
    54.383    -2.237     0.200
    54.383    -0.214     0.200
    54.314     0.744     0.200
    54.314    -0.956     0.200
    54.216     1.755     0.200
    54.428     0.619     0.200
    54.312    -0.915     0.200
    54.449    -0.392     0.200
    54.449     0.659     0.200
    54.855     0.412     0.200
    54.959    -0.839     0.200
    55.120    -1.067     0.200
    55.124    -0.232     0.200
    55.229     0.515     0.200
    55.582    -0.078     0.200
    56.118    -1.986     0.200
    56.199     1.262     0.200
    56.233     0.407     0.200
    56.324    -0.010     0.200
    56.324    -0.338     0.200
    56.482    -0.471     0.200
    56.482    -0.611     0.200
    56.631    -1.057     0.200
    56.856     0.945     0.200
    57.100    -1.256     0.200
    57.177    -0.429     0.200
    57.507     0.529     0.200
    57.854     0.775     0.200
    57.968     1.106     0.200
    58.174     0.589     0.200
    58.557     0.603     0.200
    58.586     0.741     0.200
    58.758     0.594     0.200
    58.807     0.679     0.200
    58.874    -2.111     0.200
    58.873    -0.512     0.200
    58.873     0.308     0.200
    59.683    -1.157     0.200
    61.343    -1.353     0.200
    62.407     0.333     0.200
    64.575     0.208     0.200
    65.603    -1.044     0.200
    67.042    -0.402     0.200
    67.839    -0.490     0.200
    69.754    -1.810     0.200
    69.825     0.732     0.200
    69.841     0.472     0.200
    70.107     0.160     0.200
    70.254    -0.045     0.200
    70.469     0.274     0.200
    70.789     0.030     0.200
    71.010     0.581     0.200
    71.303    -1.487     0.200
    71.303    -0.069     0.200
    71.357    -0.630     0.200
    71.358     0.219     0.200
    71.915    -0.182     0.200
    72.555     0.312     0.200
    72.669     0.990     0.200
    72.884     0.445     0.200
    72.959    -1.889     0.200
    72.959     0.169     0.200
    73.039     0.583     0.200
    73.039    -0.401     0.200
    73.312    -1.426     0.200
    73.312    -1.215     0.200
    73.658    -1.061     0.200
    73.858    -0.365     0.200
    73.873    -0.647     0.200
    73.960    -0.764     0.200
    74.024     0.451     0.200
    74.031     0.443     0.200
    74.111    -0.624     0.200
    74.689    -2.385     0.200
    75.073    -0.620     0.200
    75.108    -1.049     0.200
    75.108    -0.650     0.200
    75.108    -1.323     0.200
    75.108    -0.362     0.200
    75.108    -1.459     0.200
    75.296    -1.854     0.200
    75.394    -1.189     0.200
    75.394    -0.142     0.200
    75.651    -0.478     0.200
    75.739    -1.323     0.200
    76.100    -0.893     0.200
    76.128    -0.343     0.200
    76.213    -0.617     0.200
    76.328    -0.290     0.200
    76.434     0.374     0.200
    76.596    -1.986     0.200
    76.849    -1.590     0.200
    76.849    -0.539     0.200
    76.891     0.881     0.200
    77.010    -0.484     0.200
    77.107    -0.478     0.200
    77.114     0.163     0.200
    77.164     0.007     0.200
    77.267    -0.857     0.200
    77.192    -0.904     0.200
    77.429    -2.391     0.200
    77.520    -1.041     0.200
    77.508    -0.885     0.200
    77.346    -0.427     0.200
    77.353    -0.591     0.200
    77.353    -1.177     0.200
    77.355    -1.042     0.200
    77.408    -1.175     0.200
    77.590    -1.433     0.200
    77.637    -0.348     0.200
    77.879     0.102     0.200
    77.915     0.477     0.200
    77.975     0.550     0.200
    78.189    -1.564     0.200
    78.195    -1.837     0.200
    78.532    -0.566     0.200
    78.531     0.676     0.200
    78.591    -0.610     0.200
    78.696    -1.023     0.200
    78.886    -0.600     0.200
    78.886    -0.369     0.200
    78.975     0.246     0.200
    79.171    -0.209     0.200
    79.228    -1.021     0.200
    79.260    -1.065     0.200
    79.309     0.846     0.200
    79.395    -0.283     0.200
    79.392     0.155     0.200
    79.455     0.247     0.200
    79.492    -0.473     0.200
    79.545    -1.163     0.200
    79.545    -0.464     0.200
    79.654     1.034     0.200
    79.897     0.621     0.200
    79.971    -0.081     0.200
    80.049     0.151     0.200
    80.198    -1.439     0.200
    80.476    -0.105     0.200
    80.530    -1.709     0.200
    80.528     0.424     0.200
    80.540    -0.121     0.200
    80.929    -0.883     0.200
    80.929     0.328     0.200
    81.082     0.623     0.200
    80.905    -0.631     0.200
    80.906    -0.359     0.200
    80.906    -0.218     0.200
    81.155     0.437     0.200
    81.307    -0.070     0.200
    81.476    -0.578     0.200
    81.476    -1.097     0.200
    81.946    -1.230     0.200
    82.099    -1.014     0.200
    82.538    -0.952     0.200
    82.949    -1.516     0.200
    83.269    -0.836     0.200
    83.423    -0.395     0.200
    83.423    -0.965     0.200
    83.660    -0.596     0.200
    83.759     0.232     0.200
    83.930    -0.731     0.200
    83.967    -1.412     0.200
    84.075    -1.252     0.200
    84.075    -0.865     0.200
    84.099    -1.823     0.200
    84.160    -0.602     0.200
    84.199    -1.348     0.200
    84.409    -1.407     0.200
    84.432    -1.957     0.200
    84.509    -1.132     0.200
    84.746    -1.269     0.200
    84.760    -0.997     0.200
    84.766    -0.453     0.200
    84.766    -0.879     0.200
    84.875    -0.718     0.200
    84.991    -0.851     0.200
    85.063     0.078     0.200
    85.114    -1.639     0.200
    85.184    -0.447     0.200
    85.184     0.135     0.200
    85.239    -0.677     0.200
    85.581    -0.310     0.200
    85.997    -1.260     0.200
    86.016    -0.450     0.200
    86.526    -2.081     0.200
    86.542    -1.401     0.200
    86.546    -1.945     0.200
    86.567    -1.139     0.200
    86.567    -0.573     0.200
    86.823    -0.368     0.200
    86.852    -0.329     0.200
    87.116    -0.346     0.200
    87.301    -1.939     0.200
    87.361     0.248     0.200
    87.361    -0.073     0.200
    87.860    -0.731     0.200
    88.338    -0.596     0.200
    88.493    -0.308     0.200
    89.316     0.758     0.200
    89.316    -0.173     0.200
    89.316     0.096     0.200
    89.383     0.265     0.200
    89.730    -0.722     0.200
    89.914    -0.606     0.200
    15.010     6.337     0.200
    15.932     1.834     0.200
    15.983     5.270     0.200
    17.651     0.484     0.200
    17.651     0.220     0.200
    17.899     2.126     0.200
    19.155    -1.062     0.200
    19.934    -0.281     0.200
    19.934    -1.191     0.200
    19.934     0.028     0.200
    19.965    -0.816     0.200
    19.965    -0.265     0.200
    20.028    -0.173     0.200
    20.128     0.449     0.200
    21.065    -0.158     0.200
    21.368     0.868     0.200
    21.368     1.177     0.200
    21.368    -0.886     0.200
    21.368    -0.226     0.200
    21.499    -0.128     0.200
    21.535    -0.117     0.200
    21.535     1.410     0.200
    21.732     0.565     0.200
    21.943     1.509     0.200
    22.447     0.132     0.200
    23.204    -0.887     0.200
    23.597    -0.974     0.200
    23.598    -0.282     0.200
    23.628    -0.857     0.200
    23.628    -1.017     0.200
    23.714    -0.546     0.200
    23.714    -0.749     0.200
    23.842    -2.918     0.200
    24.053    -0.641     0.200
    24.085    -0.738     0.200
    24.292     1.968     0.200
    24.477    -0.812     0.200
    24.697     0.116     0.200
    24.872     2.622     0.200
    25.063     2.650     0.200
    25.277     2.303     0.200
    25.334     1.584     0.200
    25.714    -1.367     0.200
    25.714     2.223     0.200
    25.772    -1.788     0.200
    25.772     1.489     0.200
    26.098     1.267     0.200
    26.199     0.922     0.200
    26.473     1.397     0.200
    26.511     3.505     0.200
    26.630     1.760     0.200
    26.702     0.498     0.200
    26.875     0.535     0.200
    26.875    -0.032     0.200
    26.875    -1.035     0.200
    26.892     1.708     0.200
    26.892     1.091     0.200
    26.892     0.111     0.200
    26.892     1.849     0.200
    26.972     2.409     0.200
    27.271     1.651     0.200
    27.502     0.601     0.200
    27.770    -0.893     0.200
    28.476    -1.091     0.200
    28.754     1.727     0.200
    28.823    -0.689     0.200
    28.823    -0.482     0.200
    28.823    -2.103     0.200
    28.796    -1.144     0.200
    28.796    -0.940     0.200
    29.221     1.180     0.200
    29.689    -1.071     0.200
    30.542    -1.309     0.200
    31.166    -0.715     0.200
    31.166    -0.465     0.200
    31.166    -1.277     0.200
    31.625    -0.460     0.200
    32.761     0.725     0.200
    32.761     2.764     0.200
    33.780     0.447     0.200
    34.136     0.277     0.200
    36.111    -0.243     0.200
    36.221    -2.289     0.200
    36.225    -0.419     0.200
    37.126    -0.759     0.200
    37.493    -3.215     0.200
    38.063    -1.413     0.200
    38.318     0.078     0.200
    38.318     0.913     0.200
    39.951    -1.751     0.200
    40.372    -1.137     0.200
    40.591    -2.358     0.200
    40.977    -1.241     0.200
    41.261    -2.177     0.200
    41.342    -2.337     0.200
    41.673    -1.203     0.200
    41.673    -0.957     0.200
    41.673    -1.758     0.200
    42.308    -1.082     0.200
    43.003    -1.366     0.200
    43.364    -1.108     0.200
    43.482    -1.517     0.200
    43.663    -2.527     0.200
    43.863     0.764     0.200
    43.863    -0.845     0.200
    43.863     0.963     0.200
    43.863     1.276     0.200
    43.895     0.007     0.200
    43.895     0.207     0.200
    44.016    -0.863     0.200
    44.016    -3.016     0.200
    44.016    -2.664     0.200
    44.021     1.497     0.200
    44.308    -0.901     0.200
    44.921    -0.561     0.200
    44.867    -0.473     0.200
    45.056    -0.237     0.200
    45.094    -0.238     0.200
    45.107     0.040     0.200
    45.646    -1.452     0.200
    45.710    -0.020     0.200
    45.729    -0.615     0.200
    46.030     0.116     0.200
    46.551    -1.185     0.200
    46.566    -0.550     0.200
    46.566    -1.203     0.200
    46.566    -1.703     0.200
    46.578    -1.394     0.200
    46.578    -1.798     0.200
    46.581    -1.019     0.200
    46.591    -1.100     0.200
    46.594    -1.121     0.200
    46.603    -1.193     0.200
    46.603    -1.192     0.200
    46.607    -1.125     0.200
    46.608    -1.132     0.200
    46.618    -1.110     0.200
    46.628    -1.190     0.200
    47.344    -1.518     0.200
    47.538    -1.296     0.200
    47.538    -0.226     0.200
    47.680    -0.998     0.200
    47.680    -1.276     0.200
    47.722    -0.624     0.200
    47.717    -0.727     0.200
    47.788    -0.041     0.200
    47.788    -0.840     0.200
    47.843    -0.865     0.200
    47.885    -0.990     0.200
    48.008    -1.950     0.200
    48.724    -0.967     0.200
    48.850    -0.669     0.200
    48.995    -1.789     0.200
    49.325    -0.471     0.200
    49.459    -1.081     0.200
    50.425     0.663     0.200
    51.535     0.793     0.200
    51.684     0.692     0.200
    51.684     0.839     0.200
    51.689     0.453     0.200
    51.695     0.506     0.200
    51.701     0.464     0.200
    52.046     1.312     0.200
    52.170     0.372     0.200
    52.170     1.232     0.200
    53.752     0.489     0.200
    53.767     0.176     0.200
    53.766     0.159     0.200
    54.606     0.462     0.200
    55.012    -0.879     0.200
    55.165     0.081     0.200
    55.524     0.227     0.200
    55.647     0.047     0.200
    55.598     0.715     0.200
    56.863    -1.915     0.200
    57.035    -1.432     0.200
    57.165     0.717     0.200
    57.929    -1.978     0.200
    58.422     0.484     0.200
    58.372     1.231     0.200
    58.895    -0.310     0.200
    58.895     0.979     0.200
    64.102    -1.805     0.200
    69.794    -0.733     0.200
    70.123    -1.886     0.200
    70.142     0.325     0.200
    71.026    -1.328     0.200
    71.572    -0.256     0.200
    72.042    -1.995     0.200
    72.776    -0.257     0.200
    73.647    -1.065     0.200
    74.095    -1.369     0.200
    74.347    -1.500     0.200
    74.561     0.287     0.200
    74.561    -0.085     0.200
    76.024    -0.532     0.200
    76.207     0.503     0.200
    77.238     0.882     0.200
    77.910    -0.299     0.200
    77.910    -0.710     0.200
    77.916    -0.536     0.200
    81.435    -0.155     0.200
    81.435    -0.315     0.200
    82.221    -0.095     0.200
    83.530    -2.192     0.200
    88.467    -1.148     0.200
    88.500    -1.004     0.200
    89.787     0.085     0.200
    89.787    -0.567     0.200
    90.242     1.166     0.200
    15.115     5.333     0.200
    15.610     6.466     0.200
    19.662    -0.345     0.200
    20.330     0.050     0.200
    20.839     1.166     0.200
    21.351     2.314     0.200
    21.653     0.036     0.200
    21.653    -0.504     0.200
    21.653     0.136     0.200
    21.722     0.557     0.200
    21.722     0.407     0.200
    21.748    -0.565     0.200
    21.885     0.048     0.200
    21.885     0.468     0.200
    22.343     1.530     0.200
    23.338    -0.654     0.200
    23.815     0.129     0.200
    24.267     2.008     0.200
    25.212    -0.349     0.200
    25.118     0.855     0.200
    25.118     1.030     0.200
    25.242     0.482     0.200
    25.242    -0.669     0.200
    25.466     0.573     0.200
    26.209     1.662     0.200
    26.205     0.774     0.200
    26.346     0.476     0.200
    26.346     0.326     0.200
    26.344     0.701     0.200
    27.080     1.903     0.200
    27.464     3.596     0.200
    28.649     0.243     0.200
    28.649     0.083     0.200
    28.649     1.093     0.200
    28.722     2.222     0.200
    28.925     0.334     0.200
    30.244    -2.455     0.200
    30.500     1.579     0.200
    30.548     0.108     0.200
    32.006     0.615     0.200
    32.298     2.172     0.200
    32.431     1.230     0.200
    32.786    -0.646     0.200
    32.786    -0.686     0.200
    33.794     0.179     0.200
    35.533     0.389     0.200
    35.533     1.759     0.200
    35.864    -0.116     0.200
    35.864     1.304     0.200
    36.708     0.587     0.200
    37.332    -1.908     0.200
    37.415    -0.309     0.200
    37.415     0.261     0.200
    37.852    -0.115     0.200
    37.883    -0.778     0.200
    38.111     0.051     0.200
    38.727    -1.871     0.200
    38.798     0.529     0.200
    39.279     0.843     0.200
    40.059    -1.600     0.200
    40.234     0.162     0.200
    40.419    -0.362     0.200
    40.432     0.174     0.200
    40.464     0.466     0.200
    40.493     0.718     0.200
    40.577     0.747     0.200
    40.754     1.038     0.200
    40.961     0.735     0.200
    41.247     0.494     0.200
    41.259    -0.104     0.200
    41.365    -2.669     0.200
    41.583    -0.786     0.200
    41.665    -0.839     0.200
    41.944    -2.906     0.200
    42.170     0.196     0.200
    42.233    -1.579     0.200
    42.241    -0.260     0.200
    42.639    -0.876     0.200
    42.649    -2.549     0.200
    42.736    -1.958     0.200
    43.240     0.147     0.200
    43.349    -0.687     0.200
    43.645    -0.566     0.200
    43.700    -1.333     0.200
    43.708     0.465     0.200
    43.818     0.178     0.200
    44.083    -1.727     0.200
    44.083    -1.917     0.200
    44.145     0.458     0.200
    44.323     0.150     0.200
    44.323     0.660     0.200
    44.338     0.732     0.200
    44.478    -0.277     0.200
    44.488    -0.557     0.200
    44.647     0.692     0.200
    44.712    -0.429     0.200
    44.712     0.491     0.200
    44.712     0.191     0.200
    45.109     0.401     0.200
    45.423     0.500     0.200
    45.423     0.390     0.200
    45.423    -0.010     0.200
    45.423     1.350     0.200
    45.460     0.569     0.200
    45.391     0.488     0.200
    45.584     0.817     0.200
    45.607     0.174     0.200
    45.878     1.591     0.200
    45.874    -0.068     0.200
    45.912    -1.285     0.200
    46.051     0.128     0.200
    46.068    -0.059     0.200
    46.193    -0.623     0.200
    46.399    -0.662     0.200
    46.894     2.115     0.200
    46.894     0.015     0.200
    47.061     0.149     0.200
    47.151     0.414     0.200
    47.538     0.409     0.200
    47.839    -0.943     0.200
    47.854    -1.037     0.200
    47.854    -0.662     0.200
    47.854    -0.262     0.200
    47.854    -0.662     0.200
    47.866    -0.955     0.200
    47.882    -0.878     0.200
    47.884    -0.793     0.200
    47.888    -0.925     0.200
    47.892    -0.854     0.200
    48.075    -1.298     0.200
    48.214    -1.596     0.200
    48.267    -1.106     0.200
    48.495    -0.915     0.200
    48.495    -0.965     0.200
    48.588    -0.967     0.200
    48.955    -0.649     0.200
    49.023    -0.667     0.200
    48.961     1.019     0.200
    49.076    -0.577     0.200
    49.080    -0.908     0.200
    49.310     1.124     0.200
    49.355     1.718     0.200
    49.509     1.576     0.200
    49.676     0.585     0.200
    50.001    -0.831     0.200
    50.624    -1.047     0.200
    51.656    -0.597     0.200
    51.847    -0.331     0.200
    51.883    -0.199     0.200
    52.350     0.238     0.200
    52.350     0.508     0.200
    52.575    -0.626     0.200
    52.566     0.119     0.200
    52.666     0.355     0.200
    52.795     0.683     0.200
    52.745    -0.098     0.200
    52.918     0.137     0.200
    53.032    -0.104     0.200
    53.213     0.060     0.200
    53.213     0.259     0.200
    53.213     0.509     0.200
    53.213     0.759     0.200
    53.225     0.375     0.200
    53.230    -0.463     0.200
    53.286     0.784     0.200
    53.502     0.337     0.200
    53.671     0.858     0.200
    53.685    -0.506     0.200
    53.689    -0.139     0.200
    53.906    -0.327     0.200
    53.906     0.323     0.200
    53.974     0.477     0.200
    54.028     0.626     0.200
    54.030     0.568     0.200
    54.030     0.778     0.200
    54.052     0.011     0.200
    54.253     0.743     0.200
    54.253     0.363     0.200
    54.517     0.924     0.200
    54.623    -0.237     0.200
    54.672    -0.799     0.200
    54.679     0.303     0.200
    54.622    -0.228     0.200
    54.735    -0.757     0.200
    54.758    -0.529     0.200
    54.758    -1.749     0.200
    54.879     0.999     0.200
    54.941    -0.150     0.200
    54.941     0.560     0.200
    55.173    -0.124     0.200
    55.173    -0.464     0.200
    55.192    -0.161     0.200
    55.659     0.157     0.200
    55.790     0.655     0.200
    55.818    -0.568     0.200
    55.760    -1.748     0.200
    55.838    -0.300     0.200
    55.820    -1.405     0.200
    55.820    -1.690     0.200
    55.858    -1.893     0.200
    55.992     0.853     0.200
    56.014    -0.569     0.200
    56.018     0.798     0.200
    56.045     0.211     0.200
    56.132     0.784     0.200
    56.132     0.284     0.200
    56.132    -0.716     0.200
    56.292     0.240     0.200
    56.292    -0.185     0.200
    56.292     0.010     0.200
    56.292     0.140     0.200
    56.677     0.601     0.200
    56.723    -0.263     0.200
    56.738     0.772     0.200
    56.791     0.291     0.200
    56.851     0.854     0.200
    57.189     0.416     0.200
    57.211     0.760     0.200
    57.329     0.664     0.200
    57.675     0.874     0.200
    57.783     1.093     0.200
    57.789    -1.058     0.200
    57.789    -0.258     0.200
    57.816     0.724     0.200
    57.818    -0.690     0.200
    57.992     0.501     0.200
    58.059    -0.850     0.200
    58.167    -0.447     0.200
    58.367     0.573     0.200
    58.396     0.896     0.200
    58.566     0.309     0.200
    58.605     0.338     0.200
    58.616     0.464     0.200
    58.671    -0.942     0.200
    58.847    -1.595     0.200
    58.898    -0.474     0.200
    58.900    -0.379     0.200
    58.908    -0.212     0.200
    58.908     0.288     0.200
    58.978     0.832     0.200
    59.132    -0.702     0.200
    59.375     0.851     0.200
    59.491    -0.008     0.200
    59.569    -0.735     0.200
    59.689     1.175     0.200
    60.004    -0.437     0.200
    60.018     1.162     0.200
    63.294    -1.217     0.200
    63.989     0.078     0.200
    64.287    -1.499     0.200
    65.678    -1.107     0.200
    65.678    -0.217     0.200
    65.678    -0.557     0.200
    67.286    -0.328     0.200
    67.336     0.153     0.200
    67.565    -0.534     0.200
    67.605    -1.424     0.200
    67.605    -0.245     0.200
    68.170    -0.193     0.200
    68.423    -0.130     0.200
    68.437    -0.223     0.200
    68.495     0.000     0.200
    68.567     0.042     0.200
    68.777     0.559     0.200
    68.903     0.095     0.200
    69.297     0.521     0.200
    69.432    -0.760     0.200
    69.432    -1.075     0.200
    69.426     0.756     0.200
    69.554    -0.549     0.200
    69.582    -0.521     0.200
    70.210     1.162     0.200
    70.248    -0.453     0.200
    71.145     0.007     0.200
    71.145     0.482     0.200
    71.135    -1.473     0.200
    71.135    -1.158     0.200
    71.158     0.888     0.200
    71.604     0.782     0.200
    71.635    -0.033     0.200
    71.963     0.396     0.200
    72.029     0.497     0.200
    72.209     0.663     0.200
    72.531     0.676     0.200
    72.600     0.518     0.200
    72.612     0.699     0.200
    72.657    -0.672     0.200
    72.911     1.311     0.200
    73.039     0.523     0.200
    73.287     0.666     0.200
    73.594     0.679     0.200
    74.786    -0.726     0.200
    74.827    -2.051     0.200
    74.827    -0.421     0.200
    74.827     0.029     0.200
    75.102     0.170     0.200
    75.102     0.380     0.200
    75.270     0.621     0.200
    75.277     0.703     0.200
    75.393     0.566     0.200
    75.872     1.150     0.200
    76.574     0.107     0.200
    76.618     0.185     0.200
    77.217    -0.437     0.200
    77.644     0.770     0.200
    77.644    -0.680     0.200
    77.720    -0.470     0.200
    77.694    -1.029     0.200
    77.931     0.024     0.200
    78.222    -0.911     0.200
    78.277     0.546     0.200
    78.453     0.660     0.200
    78.458    -1.238     0.200
    78.703    -0.266     0.200
    78.703     1.044     0.200
    78.705    -0.699     0.200
    79.012     1.219     0.200
    79.042     0.824     0.200
    79.066     0.053     0.200
    79.075     0.714     0.200
    79.125    -1.040     0.200
    79.171     0.396     0.200
    79.214     0.183     0.200
    79.259     0.122     0.200
    79.378     0.578     0.200
    80.887     0.560     0.200
    81.207    -0.441     0.200
    81.521    -0.779     0.200
    81.773    -0.007     0.200
    81.801    -0.747     0.200
    82.966     0.219     0.200
    82.966    -1.011     0.200
    82.966     0.628     0.200
    82.966    -0.212     0.200
    84.181     1.360     0.200
    84.440    -0.976     0.200
    84.453    -0.171     0.200
    84.453     0.419     0.200
    84.471    -0.440     0.200
    84.571    -1.076     0.200
    84.790    -0.842     0.200
    85.286     0.668     0.200
    85.357    -0.444     0.200
    85.372    -0.949     0.200
    85.538    -1.917     0.200
    86.256    -0.011     0.200
    86.256     0.169     0.200
    86.493    -0.169     0.200
    86.604    -0.163     0.200
    87.459    -1.623     0.200
    87.467    -0.420     0.200
    87.609    -0.233     0.200
    88.092     0.706     0.200
    88.770    -0.425     0.200
    89.037     0.087     0.200
    89.037     0.372     0.200
    89.465     0.342     0.200
    91.196    -0.540     0.200
    91.196    -0.975     0.200
    91.278    -0.344     0.200
    15.881     6.629     0.200
    16.609     2.170     0.200
    17.832     0.467     0.200
    20.193    -0.201     0.200
    20.193    -1.060     0.200
    20.430    -1.384     0.200
    20.430    -2.063     0.200
    20.742     0.044     0.200
    20.847     0.095     0.200
    20.847    -0.202     0.200
    21.014     0.046     0.200
    21.305     0.351     0.200
    21.305    -1.219     0.200
    21.305     0.640     0.200
    21.335     1.335     0.200
    21.335     1.311     0.200
    21.335    -0.267     0.200
    21.399     0.365     0.200
    21.499    -0.730     0.200
    22.064     2.009     0.200
    24.912     0.192     0.200
    24.942     0.723     0.200
    24.942    -0.566     0.200
    25.070    -0.442     0.200
    25.197    -0.194     0.200
    25.506    -1.848     0.200
    25.414     3.038     0.200
    25.443     2.779     0.200
    25.587    -2.692     0.200
    25.699    -0.852     0.200
    25.836     2.800     0.200
    25.836     2.901     0.200
    26.065     1.432     0.200
    26.228    -0.300     0.200
    26.509     2.711     0.200
    26.741     0.523     0.200
    26.493     3.262     0.200
    26.648     2.863     0.200
    27.067    -0.116     0.200
    27.131    -0.510     0.200
    28.263     0.471     0.200
    28.263    -1.295     0.200
    28.263     2.986     0.200
    28.326     2.407     0.200
    29.854     2.345     0.200
    29.981     0.217     0.200
    30.014     0.930     0.200
    30.101     1.962     0.200
    30.175    -0.193     0.200
    30.175    -0.396     0.200
    31.194     2.508     0.200
    32.485    -1.689     0.200
    32.921    -1.230     0.200
    33.611     0.223     0.200
    36.021     0.853     0.200
    37.196    -2.930     0.200
    37.444    -0.216     0.200
    40.816    -1.368     0.200
    41.455    -2.001     0.200
    42.477    -1.776     0.200
    42.544     0.152     0.200
    42.544    -1.793     0.200
    42.847    -0.833     0.200
    43.114    -0.864     0.200
    43.727    -1.197     0.200
    44.113     0.105     0.200
    44.025    -0.365     0.200
    44.191     0.032     0.200
    44.607    -0.466     0.200
    44.503    -1.892     0.200
    44.861    -1.458     0.200
    45.146     0.377     0.200
    45.146    -0.131     0.200
    45.146     1.635     0.200
    45.182    -0.708     0.200
    45.306     0.805     0.200
    45.336    -1.335     0.200
    45.473     0.279     0.200
    45.372    -1.517     0.200
    45.996    -0.530     0.200
    46.120     0.456     0.200
    46.273    -1.185     0.200
    46.461    -0.319     0.200
    46.590     0.479     0.200
    46.766    -1.665     0.200
    46.766     0.290     0.200
    46.771     2.099     0.200
    46.998    -0.419     0.200
    47.668    -0.139     0.200
    47.668     0.166     0.200
    47.668    -1.436     0.200
    47.680     0.376     0.200
    47.922    -1.000     0.200
    48.441    -0.602     0.200
    50.645     2.346     0.200
    52.617     0.410     0.200
    52.948    -1.134     0.200
    52.948     0.615     0.200
    52.948    -0.190     0.200
    53.114     0.481     0.200
    53.308     2.014     0.200
    53.758     0.611     0.200
    54.015     2.127     0.200
    54.524     1.215     0.200
    54.636     0.103     0.200
    54.793     0.671     0.200
    54.858     0.602     0.200
    55.029     1.755     0.200
    55.638     0.905     0.200
    55.655     2.111     0.200
    55.837     1.531     0.200
    55.996    -0.801     0.200
    55.996    -0.567     0.200
    55.996     0.402     0.200
    56.000     1.205     0.200
    56.000     0.064     0.200
    56.164    -1.550     0.200
    56.164    -0.300     0.200
    56.154    -0.730     0.200
    56.154    -0.534     0.200
    56.522    -0.265     0.200
    56.602     2.077     0.200
    56.645     0.888     0.200
    56.724     3.130     0.200
    57.059     1.850     0.200
    57.521     0.974     0.200
    57.521     0.435     0.200
    57.637     0.570     0.200
    57.674     0.059     0.200
    57.752    -1.312     0.200
    58.229     1.196     0.200
    58.260    -0.869     0.200
    58.479    -0.504     0.200
    58.544    -1.108     0.200
    58.544    -0.023     0.200
    58.842     0.651     0.200
    59.707     2.124     0.200
    59.707     2.624     0.200
    61.894    -0.841     0.200
    62.144    -0.344     0.200
    63.057    -0.736     0.200
    69.652    -1.204     0.200
    71.117    -0.983     0.200
    71.043    -0.692     0.200
    71.043     0.043     0.200
    75.195    -1.928     0.200
    75.455    -1.173     0.200
    75.455    -0.165     0.200
    75.651     1.601     0.200
    76.263     0.442     0.200
    76.455     0.380     0.200
    77.550    -0.422     0.200
    77.565    -1.126     0.200
    77.565    -0.829     0.200
    81.112    -0.989     0.200
    81.112    -1.497     0.200
    83.337     0.254     0.200
    89.407    -0.972     0.200
    15.103     3.553     0.200
    15.263     5.341     0.200
    15.337     7.170     0.200
    15.556     6.114     0.200
    15.899     5.847     0.200
    15.988     4.162     0.200
    17.456     1.495     0.200
    17.857     2.125     0.200
    20.094     0.392     0.200
    20.094    -0.139     0.200
    20.459     0.792     0.200
    20.500     1.249     0.200
    20.842     0.643     0.200
    20.854     0.409     0.200
    20.877     0.324     0.200
    20.877    -0.057     0.200
    20.877     1.011     0.200
    20.857     1.573     0.200
    21.015     1.212     0.200
    21.274    -0.018     0.200
    21.274    -1.501     0.200
    21.274    -0.120     0.200
    21.274    -0.231     0.200
    21.306     0.424     0.200
    21.306    -0.474     0.200
    21.306     0.461     0.200
    21.306    -0.814     0.200
    21.317    -0.490     0.200
    21.367    -0.011     0.200
    21.367    -0.431     0.200
    21.352     2.040     0.200
    21.471     0.169     0.200
    21.471    -0.542     0.200
    21.701     0.148     0.200
    21.701     2.247     0.200
    21.701     0.288     0.200
    21.966     0.243     0.200
    21.964     0.605     0.200
    23.412    -0.691     0.200
    24.091    -2.312     0.200
    24.037    -0.506     0.200
    24.037     0.244     0.200
    24.137     1.768     0.200
    24.548     1.423     0.200
    24.878    -0.033     0.200
    24.879    -0.200     0.200
    24.909    -0.615     0.200
    25.044     0.304     0.200
    25.171    -0.547     0.200
    25.346     0.957     0.200
    25.387     1.486     0.200
    25.416     1.324     0.200
    25.533     0.056     0.200
    25.533    -0.876     0.200
    25.533    -0.045     0.200
    25.533     0.326     0.200
    25.533    -0.174     0.200
    25.546     0.043     0.200
    25.619    -2.434     0.200
    25.619    -2.585     0.200
    25.615    -1.459     0.200
    25.619    -2.224     0.200
    25.621    -1.151     0.200
    25.729    -1.417     0.200
    25.809     1.352     0.200
    26.093    -0.424     0.200
    26.093     0.186     0.200
    26.093     0.885     0.200
    26.093     1.086     0.200
    26.047    -0.920     0.200
    26.047    -2.150     0.200
    26.057     0.313     0.200
    26.298    -1.281     0.200
    26.298    -0.271     0.200
    26.482     1.368     0.200
    26.466     1.715     0.200
    26.752     0.830     0.200
    26.752    -1.119     0.200
    26.621     1.414     0.200
    27.041     0.637     0.200
    27.041     2.768     0.200
    27.104    -0.131     0.200
    27.104    -0.242     0.200
    27.161     0.584     0.200
    27.440     2.124     0.200
    27.537     2.079     0.200
    27.818     1.483     0.200
    27.972     2.017     0.200
    28.235     1.673     0.200
    28.235     0.073     0.200
    28.235     1.932     0.200
    28.235     1.343     0.200
    28.235    -0.468     0.200
    28.299     2.450     0.200
    28.498     1.931     0.200
    28.659     0.558     0.200
    28.616     1.224     0.200
    29.224     0.237     0.200
    29.824     1.015     0.200
    29.814     1.410     0.200
    29.979    -1.283     0.200
    29.979    -0.453     0.200
    29.979    -0.953     0.200
    30.075     2.096     0.200
    30.145    -0.604     0.200
    30.145     0.877     0.200
    30.145    -0.914     0.200
    30.571     2.915     0.200
    30.561     1.299     0.200
    31.038     1.289     0.200
    32.451    -1.417     0.200
    32.451    -0.837     0.200
    32.451    -0.957     0.200
    32.701     1.474     0.200
    32.886    -1.248     0.200
    33.576    -1.571     0.200
    33.998     1.255     0.200
    34.063     2.554     0.200
    34.115     0.579     0.200
    34.115     0.343     0.200
    34.115    -0.157     0.200
    34.115     0.444     0.200
    34.231     1.637     0.200
    34.326     1.813     0.200
    34.562     0.768     0.200
    34.584     1.476     0.200
    34.666     1.768     0.200
    34.724     1.669     0.200
    34.724     1.670     0.200
    34.737     2.151     0.200
    34.792     0.876     0.200
    34.816     1.974     0.200
    35.288     1.698     0.200
    35.311     1.304     0.200
    35.434    -0.155     0.200
    35.434     0.726     0.200
    36.016     0.968     0.200
    36.306    -0.129     0.200
    36.827    -2.080     0.200
    36.901     1.696     0.200
    36.901    -0.105     0.200
    36.931    -0.669     0.200
    36.931     1.040     0.200
    36.992     0.439     0.200
    36.992     0.208     0.200
    37.163    -1.833     0.200
    37.420    -0.772     0.200
    37.397    -0.719     0.200
    38.288    -0.332     0.200
    38.326     1.164     0.200
    38.680    -1.453     0.200
    38.599    -0.579     0.200
    38.599     1.020     0.200
    38.599     0.731     0.200
    38.642     0.000     0.200
    38.945    -0.685     0.200
    38.945    -0.008     0.200
    38.945     0.932     0.200
    38.998    -0.317     0.200
    38.999     0.179     0.200
    39.414    -0.680     0.200
    39.414    -0.292     0.200
    39.711    -0.140     0.200
    39.859     0.343     0.200
    40.059    -0.301     0.200
    40.111    -0.018     0.200
    40.407     0.120     0.200
    40.384     0.843     0.200
    40.573    -0.522     0.200
    40.647    -1.440     0.200
    41.006    -0.166     0.200
    41.138     0.142     0.200
    41.104    -1.199     0.200
    41.421     0.197     0.200
    41.515    -0.216     0.200
    41.682    -0.545     0.200
    41.702    -1.512     0.200
    41.785    -0.073     0.200
    42.059    -0.356     0.200
    42.105    -1.407     0.200
    42.396    -1.079     0.200
    42.552     0.454     0.200
    42.508    -1.195     0.200
    42.481    -1.872     0.200
    42.512    -0.821     0.200
    42.522    -1.302     0.200
    42.528     1.849     0.200
    42.898     0.207     0.200
    42.898     0.437     0.200
    43.129    -3.335     0.200
    43.692    -0.552     0.200
    44.099    -0.645     0.200
    43.991     0.621     0.200
    44.015    -1.266     0.200
    44.197     0.531     0.200
    44.286    -0.457     0.200
    44.197     0.467     0.200
    44.471    -0.728     0.200
    44.471    -1.129     0.200
    44.611    -0.426     0.200
    44.715     0.913     0.200
    44.715    -0.776     0.200
    44.715     0.124     0.200
    44.871    -0.214     0.200
    44.881    -0.603     0.200
    44.819    -0.804     0.200
    45.044    -0.898     0.200
    45.023    -1.391     0.200
    45.103    -0.370     0.200
    45.103    -0.569     0.200
    45.103     0.072     0.200
    45.103    -0.260     0.200
    45.116    -0.569     0.200
    45.128    -0.027     0.200
    45.181    -0.220     0.200
    45.112     1.908     0.200
    45.112     0.765     0.200
    45.112     0.945     0.200
    45.112     1.484     0.200
    45.112     1.164     0.200
    45.112    -0.737     0.200
    45.142     0.320     0.200
    45.147    -0.326     0.200
    45.147    -0.018     0.200
    45.147    -0.816     0.200
    45.275    -0.732     0.200
    45.309    -0.314     0.200
    45.364    -0.611     0.200
    45.271     1.196     0.200
    45.478     0.061     0.200
    45.563     1.683     0.200
    45.711    -0.854     0.200
    45.717     0.763     0.200
    45.842    -0.146     0.200
    45.861    -0.116     0.200
    46.086    -0.374     0.200
    46.278     0.225     0.200
    46.316    -0.328     0.200
    46.584    -1.100     0.200
    46.584    -1.362     0.200
    46.556     0.590     0.200
    46.556     3.158     0.200
    46.556     0.697     0.200
    46.556     1.809     0.200
    46.769     0.360     0.200
    46.769     0.090     0.200
    46.600    -0.926     0.200
    46.774    -0.603     0.200
    46.820    -0.714     0.200
    46.736     2.182     0.200
    46.957    -0.244     0.200
    46.957    -0.984     0.200
    46.963    -0.130     0.200
    47.084    -0.443     0.200
    47.084    -0.972     0.200
    47.129     2.365     0.200
    47.362    -0.211     0.200
    47.420     0.066     0.200
    47.420    -0.294     0.200
    47.530    -1.071     0.200
    47.552    -0.522     0.200
    47.618    -1.334     0.200
    47.633    -0.976     0.200
    47.633    -0.653     0.200
    47.633    -1.253     0.200
    47.645    -1.696     0.200
    47.645    -0.536     0.200
    47.645    -1.446     0.200
    47.645    -1.346     0.200
    47.645    -1.030     0.200
    47.647    -1.362     0.200
    47.660    -1.363     0.200
    47.662    -1.380     0.200
    47.668    -1.324     0.200
    47.671    -1.346     0.200
    47.929     0.391     0.200
    48.023    -0.204     0.200
    48.113    -1.597     0.200
    48.194     2.315     0.200
    48.272    -0.545     0.200
    48.410    -1.266     0.200
    48.410    -1.292     0.200
    48.480    -1.310     0.200
    48.420    -0.087     0.200
    48.420     1.153     0.200
    48.611    -0.165     0.200
    48.751    -1.392     0.200
    48.855    -1.294     0.200
    48.987     0.799     0.200
    49.752    -1.549     0.200
    49.767    -0.716     0.200
    49.767    -1.265     0.200
    49.915    -0.124     0.200
    50.346    -1.661     0.200
    50.400    -1.369     0.200
    50.611     1.525     0.200
    50.594     0.406     0.200
    50.594     0.183     0.200
    50.749     0.914     0.200
    51.100     0.583     0.200
    51.128     0.437     0.200
    51.431     0.390     0.200
    51.431    -0.133     0.200
    51.565    -0.170     0.200
    51.565     0.886     0.200
    51.565     0.741     0.200
    51.646    -1.018     0.200
    51.658     0.043     0.200
    51.695     0.112     0.200
    51.725    -0.476     0.200
    51.725     0.180     0.200
    51.718     0.392     0.200
    51.718     0.705     0.200
    51.793     1.232     0.200
    51.914    -0.346     0.200
    51.895     1.033     0.200
    51.895     0.035     0.200
    51.911     1.053     0.200
    51.926     0.075     0.200
    51.929     1.763     0.200
    51.928     1.343     0.200
    51.996     0.233     0.200
    52.144     0.245     0.200
    52.144     0.415     0.200
    52.137     0.424     0.200
    52.137     0.815     0.200
    52.187     0.056     0.200
    52.257     1.242     0.200
    52.361     0.397     0.200
    52.350    -0.355     0.200
    52.448     0.930     0.200
    52.455     0.956     0.200
    52.583     0.675     0.200
    52.538     0.415     0.200
    52.643     1.225     0.200
    52.730     1.328     0.200
    52.756     1.523     0.200
    52.791     0.786     0.200
    52.791     1.124     0.200
    52.913     0.842     0.200
    52.913     1.042     0.200
    52.913    -0.458     0.200
    52.913     1.241     0.200
    52.996     1.671     0.200
    53.080     1.143     0.200
    53.190     1.412     0.200
    53.262     1.583     0.200
    53.262    -0.110     0.200
    53.296     0.921     0.200
    53.336     0.706     0.200
    53.450     0.487     0.200
    53.529     1.263     0.200
    53.529     1.569     0.200
    53.724     0.136     0.200
    53.724    -0.122     0.200
    53.724     0.518     0.200
    53.650     0.340     0.200
    53.786     0.553     0.200
    53.850     0.595     0.200
    53.856     0.510     0.200
    53.856     0.871     0.200
    53.782     0.225     0.200
    53.880     0.148     0.200
    53.896     2.524     0.200
    53.981     0.539     0.200
    54.058     0.335     0.200
    54.058     0.624     0.200
    54.328     0.461     0.200
    54.328     1.301     0.200
    54.332     0.926     0.200
    54.310    -0.045     0.200
    54.310    -0.206     0.200
    54.422     0.757     0.200
    54.490     0.285     0.200
    54.490     0.775     0.200
    54.498     0.628     0.200
    54.518     0.145     0.200
    54.518    -0.076     0.200
    54.592    -0.358     0.200
    54.603    -1.035     0.200
    54.603    -0.205     0.200
    54.689     0.936     0.200
    54.759     0.134     0.200
    54.759     0.523     0.200
    54.792     0.891     0.200
    54.824     0.524     0.200
    54.824     0.137     0.200
    54.861     1.095     0.200
    54.861     1.364     0.200
    54.974    -0.366     0.200
    54.934     0.924     0.200
    55.059    -0.090     0.200
    55.061    -0.162     0.200
    54.962     1.422     0.200
    54.962     2.162     0.200
    55.314    -0.296     0.200
    55.210    -0.629     0.200
    55.463    -1.258     0.200
    55.478     0.218     0.200
    55.494     0.014     0.200
    55.604     0.535     0.200
    55.621     1.141     0.200
    55.635     0.472     0.200
    55.684    -0.035     0.200
    55.704     0.443     0.200
    55.695     1.585     0.200
    55.671     0.551     0.200
    55.758    -0.003     0.200
    55.803     0.572     0.200
    55.807    -0.029     0.200
    55.807    -0.205     0.200
    55.832     0.429     0.200
    55.962    -0.037     0.200
    55.962    -0.838     0.200
    55.966     0.436     0.200
    56.104    -1.621     0.200
    56.164    -1.646     0.200
    56.164    -2.433     0.200
    56.164    -1.082     0.200
    56.009     2.126     0.200
    56.088     1.002     0.200
    56.120    -0.733     0.200
    56.120    -1.479     0.200
    56.120     0.482     0.200
    56.132     0.740     0.200
    56.067     1.710     0.200
    56.259     0.407     0.200
    56.488     0.441     0.200
    56.488    -1.686     0.200
    56.516    -0.714     0.200
    56.566    -0.134     0.200
    56.567     0.580     0.200
    56.567     0.940     0.200
    56.611    -0.016     0.200
    56.690     0.809     0.200
    56.620     1.170     0.200
    56.690     1.566     0.200
    56.885    -1.008     0.200
    56.954    -2.069     0.200
    57.010    -0.077     0.200
    57.025     0.517     0.200
    57.132     0.401     0.200
    57.139     0.258     0.200
    57.301     1.950     0.200
    57.487     0.470     0.200
    57.487     1.039     0.200
    57.490     1.043     0.200
    57.603     0.747     0.200
    57.603     1.069     0.200
    57.640     0.506     0.200
    57.652     0.914     0.200
    57.722    -1.775     0.200
    57.722    -0.827     0.200
    57.655    -0.447     0.200
    57.715     1.640     0.200
    57.808     0.092     0.200
    57.865     0.626     0.200
    57.907    -0.231     0.200
    57.947    -0.797     0.200
    58.036    -0.877     0.200
    58.036    -0.547     0.200
    58.123    -0.805     0.200
    58.086    -1.026     0.200
    58.086     1.423     0.200
    58.195     0.413     0.200
    58.223     0.458     0.200
    58.223     0.713     0.200
    58.182     2.828     0.200
    58.227     0.019     0.200
    58.195     0.700     0.200
    58.195     3.101     0.200
    58.324    -0.092     0.200
    58.396     0.252     0.200
    58.437    -0.165     0.200
    58.445     0.221     0.200
    58.420    -0.447     0.200
    58.513    -0.445     0.200
    58.513    -0.054     0.200
    58.513     0.327     0.200
    58.513     0.126     0.200
    58.592    -0.529     0.200
    58.703    -0.323     0.200
    58.773    -1.643     0.200
    58.776    -1.152     0.200
    58.809     0.046     0.200
    58.838    -1.841     0.200
    58.838     0.069     0.200
    58.816     3.068     0.200
    58.851    -0.126     0.200
    58.976    -0.241     0.200
    59.004    -0.757     0.200
    59.137    -0.410     0.200
    59.174    -0.069     0.200
    59.321     0.173     0.200
    59.321     0.703     0.200
    59.353    -1.233     0.200
    59.421    -0.373     0.200
    59.574     2.666     0.200
    59.674     0.470     0.200
    59.674     1.779     0.200
    59.674     1.179     0.200
    60.043     1.339     0.200
    60.399    -1.445     0.200
    60.483     1.629     0.200
    60.809    -1.217     0.200
    60.857    -1.776     0.200
    61.539    -0.729     0.200
    62.111    -0.204     0.200
    62.346    -0.815     0.200
    62.644    -1.908     0.200
    62.638    -1.594     0.200
    62.844     0.051     0.200
    65.392     0.481     0.200
    66.009    -1.199     0.200
    66.009    -0.619     0.200
    66.009    -0.408     0.200
    66.027    -1.327     0.200
    66.027    -0.626     0.200
    66.027    -0.836     0.200
    67.947     0.369     0.200
    69.638    -0.935     0.200
    70.068    -0.337     0.200
    70.162     0.336     0.200
    70.301    -0.486     0.200
    70.578    -0.197     0.200
    70.749     0.222     0.200
    70.876     0.129     0.200
    71.010    -0.138     0.200
    71.010    -0.388     0.200
    71.076     0.012     0.200
    71.276     0.099     0.200
    71.276     0.660     0.200
    71.455    -1.575     0.200
    71.455    -2.878     0.200
    71.557     0.936     0.200
    71.587    -0.069     0.200
    71.681    -0.114     0.200
    71.817    -0.384     0.200
    71.817     0.575     0.200
    72.273     0.156     0.200
    72.341     0.882     0.200
    72.485    -0.063     0.200
    72.604     1.433     0.200
    72.455    -0.932     0.200
    72.594    -0.320     0.200
    72.818     0.458     0.200
    72.995     0.706     0.200
    73.066     0.297     0.200
    73.230    -1.163     0.200
    73.328    -1.439     0.200
    73.766    -3.160     0.200
    73.751     0.058     0.200
    73.990     0.108     0.200
    74.204    -0.233     0.200
    74.291    -0.088     0.200
    74.291     0.252     0.200
    74.399    -0.040     0.200
    74.469     0.176     0.200
    74.469    -1.144     0.200
    74.420     0.338     0.200
    74.744     0.295     0.200
    74.923    -0.159     0.200
    74.923     0.061     0.200
    75.200    -0.788     0.200
    75.200    -0.473     0.200
    75.457    -0.584     0.200
    75.457    -0.753     0.200
    75.457    -0.253     0.200
    75.657     0.870     0.200
    76.272     0.729     0.200
    76.548     0.375     0.200
    76.929    -0.383     0.200
    76.929    -0.906     0.200
    77.548    -0.791     0.200
    77.548    -0.182     0.200
    77.583    -0.393     0.200
    77.583    -0.765     0.200
    77.583    -0.534     0.200
    77.589    -0.645     0.200
    77.589    -0.532     0.200
    77.634    -0.778     0.200
    78.618    -0.150     0.200
    79.069     0.849     0.200
    79.321    -0.126     0.200
    79.321    -0.606     0.200
    80.482     0.164     0.200
    80.482     0.414     0.200
    80.629     0.476     0.200
    80.881     1.175     0.200
    81.242     1.154     0.200
    81.244     0.741     0.200
    81.242    -0.137     0.200
    81.242     0.914     0.200
    81.136    -0.505     0.200
    81.136    -0.335     0.200
    81.389    -0.125     0.200
    81.595    -0.942     0.200
    81.955    -0.499     0.200
    83.192     0.853     0.200
    83.342     0.404     0.200
    83.342     1.064     0.200
    83.342     1.324     0.200
    83.363    -1.698     0.200
    83.363    -1.179     0.200
    83.763     1.607     0.200
    83.763     1.398     0.200
    84.087    -0.988     0.200
    84.087    -0.418     0.200
    84.752    -1.071     0.200
    84.752    -0.071     0.200
    86.243     0.936     0.200
    86.243     0.581     0.200
    86.379    -0.231     0.200
    86.564    -0.537     0.200
    86.564    -0.877     0.200
    86.688     0.276     0.200
    89.411    -1.684     0.200
    89.411    -0.068     0.200
    89.411    -1.826     0.200
    89.890     0.393     0.200
    90.671    -1.143     0.200
    90.928     1.350     0.200
    90.939    -0.293     0.200
    91.337     0.641     0.200
    91.337     0.391     0.200
    14.748     6.220     0.200
    15.330     8.451     0.200
    16.160     3.480     0.200
    16.196     6.313     0.200
    17.057     4.252     0.200
    17.057     3.489     0.200
    18.782     0.949     0.200
    20.278    -1.707     0.200
    20.278     0.509     0.200
    20.150     1.895     0.200
    20.605    -0.048     0.200
    20.878     0.120     0.200
    20.947    -0.552     0.200
    20.947    -0.332     0.200
    20.947     0.057     0.200
    21.041    -0.888     0.200
    21.044    -0.293     0.200
    21.044     0.032     0.200
    21.044     0.388     0.200
    21.129     2.281     0.200
    21.270     2.715     0.200
    22.360     2.198     0.200
    22.358     2.469     0.200
    22.358     2.219     0.200
    23.397     2.330     0.200
    24.281     1.396     0.200
    24.509    -0.231     0.200
    24.539     0.248     0.200
    24.802    -1.047     0.200
    25.138     1.793     0.200
    25.172     1.482     0.200
    25.799     1.670     0.200
    25.799     1.205     0.200
    26.148     2.353     0.200
    26.225     1.734     0.200
    26.198     2.726     0.200
    26.207     2.195     0.200
    26.207     2.295     0.200
    26.365     1.772     0.200
    26.783     0.403     0.200
    26.765     0.313     0.200
    27.968     0.087     0.200
    27.968     1.607     0.200
    27.968     1.967     0.200
    28.060     2.247     0.200
    29.538     1.617     0.200
    29.853    -0.174     0.200
    30.276     3.677     0.200
    30.751     1.480     0.200
    30.874     1.299     0.200
    32.083    -0.926     0.200
    34.171     1.523     0.200
    34.270    -0.041     0.200
    34.519     2.177     0.200
    34.519     1.206     0.200
    34.593     1.763     0.200
    34.654     2.638     0.200
    35.199     1.734     0.200
    35.569    -1.141     0.200
    35.853    -2.163     0.200
    36.424    -3.072     0.200
    36.826     0.044     0.200
    36.752     0.610     0.200
    36.752     1.320     0.200
    37.071    -1.917     0.200
    37.071    -1.439     0.200
    37.569     0.550     0.200
    37.685    -0.910     0.200
    37.717    -0.866     0.200
    38.286    -0.673     0.200
    38.286    -1.113     0.200
    38.286    -1.293     0.200
    38.314    -0.078     0.200
    38.331    -0.703     0.200
    38.560    -0.176     0.200
    38.693    -0.982     0.200
    38.910    -0.440     0.200
    38.883    -0.881     0.200
    39.244    -0.806     0.200
    39.392    -1.012     0.200
    39.451    -0.952     0.200
    39.690     0.023     0.200
    39.878    -0.269     0.200
    39.867     0.002     0.200
    39.998    -1.063     0.200
    40.104    -0.126     0.200
    40.241    -0.803     0.200
    40.431    -0.402     0.200
    40.668    -0.270     0.200
    40.817    -0.185     0.200
    40.821    -0.130     0.200
    40.843    -0.839     0.200
    41.040    -0.534     0.200
    41.009    -0.836     0.200
    41.386     0.198     0.200
    42.040    -0.778     0.200
    42.101    -0.863     0.200
    42.101    -1.269     0.200
    42.101    -0.689     0.200
    42.329    -0.668     0.200
    42.629    -0.754     0.200
    42.692    -0.463     0.200
    43.242    -1.134     0.200
    43.279    -0.594     0.200
    43.532    -0.526     0.200
    43.532     0.004     0.200
    43.583    -1.466     0.200
    43.861    -2.130     0.200
    43.861    -1.739     0.200
    43.861    -1.940     0.200
    43.841     1.665     0.200
    43.975    -0.019     0.200
    44.052    -0.939     0.200
    44.079    -0.452     0.200
    44.127    -0.095     0.200
    44.611    -0.440     0.200
    44.708    -0.368     0.200
    44.708     0.992     0.200
    44.708     1.372     0.200
    44.729     1.007     0.200
    44.766     0.616     0.200
    44.889     1.330     0.200
    45.095     0.794     0.200
    45.095     0.294     0.200
    45.095    -0.496     0.200
    45.095     0.394     0.200
    45.107     0.594     0.200
    45.148    -0.222     0.200
    45.446     1.760     0.200
    45.448    -1.489     0.200
    45.672    -0.401     0.200
    46.011    -0.235     0.200
    46.339    -0.080     0.200
    46.543    -0.465     0.200
    46.698    -0.617     0.200
    46.836     0.466     0.200
    46.868    -0.929     0.200
    47.222    -1.081     0.200
    47.222    -0.975     0.200
    47.222    -0.355     0.200
    47.482    -0.330     0.200
    47.707    -1.347     0.200
    47.645     2.567     0.200
    48.006    -1.442     0.200
    48.006    -1.643     0.200
    48.006    -1.067     0.200
    48.079    -0.377     0.200
    48.145    -1.685     0.200
    48.095    -0.568     0.200
    48.339    -0.011     0.200
    48.607     0.219     0.200
    49.394    -0.819     0.200
    49.466    -1.451     0.200
    49.761    -1.228     0.200
    49.925    -1.074     0.200
    50.036    -1.952     0.200
    50.136    -1.680     0.200
    50.222    -0.591     0.200
    50.424     0.379     0.200
    50.608    -0.404     0.200
    50.658    -0.485     0.200
    50.752    -0.953     0.200
    50.893    -0.129     0.200
    50.927    -0.906     0.200
    51.040     0.073     0.200
    51.248     0.005     0.200
    51.248    -0.776     0.200
    51.286    -0.302     0.200
    51.169     0.016     0.200
    51.353    -0.932     0.200
    51.732     0.223     0.200
    51.732     0.033     0.200
    51.849     1.369     0.200
    52.037     0.507     0.200
    52.171     0.167     0.200
    52.309     1.233     0.200
    52.384     1.027     0.200
    52.525     0.681     0.200
    52.525    -0.499     0.200
    52.668     0.556     0.200
    52.804     1.605     0.200
    52.883     0.985     0.200
    52.865     0.646     0.200
    52.926     0.491     0.200
    53.040     0.436     0.200
    53.100     0.072     0.200
    53.120     0.582     0.200
    53.120     0.351     0.200
    53.310     0.659     0.200
    53.310     0.163     0.200
    53.310    -0.167     0.200
    53.332     0.095     0.200
    53.375     0.287     0.200
    53.311     1.080     0.200
    53.389     0.157     0.200
    53.436     0.126     0.200
    53.442     0.462     0.200
    53.442     0.563     0.200
    53.466     0.119     0.200
    53.568     0.733     0.200
    53.574     0.283     0.200
    53.598     0.404     0.200
    53.645     0.677     0.200
    53.915     1.309     0.200
    53.915     1.199     0.200
    53.922     0.718     0.200
    54.012     0.613     0.200
    54.077     0.189     0.200
    54.077     0.019     0.200
    54.084     0.181     0.200
    54.104    -0.304     0.200
    54.180    -0.845     0.200
    54.190    -0.637     0.200
    54.190    -1.007     0.200
    54.276     0.864     0.200
    54.345     0.280     0.200
    54.345     0.161     0.200
    54.413    -0.024     0.200
    54.413     0.107     0.200
    54.447     2.218     0.200
    54.492     0.075     0.200
    54.520     0.137     0.200
    54.562    -0.456     0.200
    54.582     0.310     0.200
    54.648    -0.310     0.200
    54.732     0.569     0.200
    54.901    -0.006     0.200
    55.065     0.496     0.200
    55.080    -0.442     0.200
    55.123     1.305     0.200
    55.191     0.652     0.200
    55.208     0.119     0.200
    55.271    -0.248     0.200
    55.292    -0.086     0.200
    55.350     0.133     0.200
    55.394    -0.530     0.200
    55.394    -0.327     0.200
    55.419     1.141     0.200
    55.456     0.001     0.200
    55.551    -0.045     0.200
    55.548     0.356     0.200
    55.548     0.556     0.200
    55.548    -0.544     0.200
    55.619    -0.724     0.200
    55.618    -0.082     0.200
    55.673     0.204     0.200
    55.707    -0.355     0.200
    55.707     0.120     0.200
    55.707     0.140     0.200
    55.690     0.358     0.200
    55.743    -0.045     0.200
    55.743     0.066     0.200
    55.729    -0.183     0.200
    55.729    -0.052     0.200
    56.069    -1.725     0.200
    56.069    -1.295     0.200
    56.058    -1.518     0.200
    56.075     1.105     0.200
    56.075     0.821     0.200
    56.121     0.521     0.200
    56.121     0.630     0.200
    56.153     0.055     0.200
    56.153     0.165     0.200
    56.154     0.105     0.200
    56.162     0.636     0.200
    56.174     0.080     0.200
    56.192     0.273     0.200
    56.197     0.477     0.200
    56.197     0.256     0.200
    56.263    -0.692     0.200
    56.393     0.173     0.200
    56.476     0.025     0.200
    56.547     0.142     0.200
    56.599    -0.201     0.200
    56.597     0.500     0.200
    56.612     1.292     0.200
    56.673     0.354     0.200
    56.708     0.151     0.200
    56.726     0.647     0.200
    56.740    -0.176     0.200
    56.922    -0.350     0.200
    56.922     0.070     0.200
    56.938     0.469     0.200
    56.938     0.609     0.200
    57.073     0.890     0.200
    57.073     0.588     0.200
    57.080    -0.028     0.200
    57.171     0.198     0.200
    57.189     1.299     0.200
    57.189     0.967     0.200
    57.226     0.790     0.200
    57.243    -0.254     0.200
    57.282     0.200     0.200
    57.322    -1.323     0.200
    57.283     0.253     0.200
    57.394     0.590     0.200
    57.460    -0.021     0.200
    57.507    -0.184     0.200
    57.514     0.545     0.200
    57.536    -0.967     0.200
    57.536    -0.818     0.200
    57.625    -0.438     0.200
    57.625    -0.198     0.200
    57.717    -0.243     0.200
    57.717     0.037     0.200
    57.739     1.305     0.200
    57.781     0.732     0.200
    57.810     1.190     0.200
    57.813     0.100     0.200
    57.846    -0.623     0.200
    57.915    -0.643     0.200
    57.915     0.147     0.200
    57.983     0.550     0.200
    58.024     0.426     0.200
    58.031     0.864     0.200
    58.048     0.130     0.200
    58.178    -0.839     0.200
    58.178    -0.729     0.200
    58.292    -0.573     0.200
    58.362    -0.977     0.200
    58.395     0.617     0.200
    58.425    -0.161     0.200
    58.425     0.278     0.200
    58.562     0.515     0.200
    58.562     0.138     0.200
    58.754    -1.778     0.200
    58.908     0.574     0.200
    59.008    -0.242     0.200
    59.474    -0.677     0.200
    59.474    -0.517     0.200
    59.515    -0.750     0.200
    59.895    -0.536     0.200
    59.985    -0.545     0.200
    60.511    -0.737     0.200
    60.775     0.443     0.200
    60.775     0.603     0.200
    60.775     1.673     0.200
    61.377     3.781     0.200
    62.504    -2.747     0.200
    63.286    -0.531     0.200
    64.360     0.624     0.200
    65.892    -0.869     0.200
    65.892    -1.129     0.200
    65.892    -0.518     0.200
    67.917     0.590     0.200
    70.599     0.161     0.200
    70.599    -0.691     0.200
    72.969     0.758     0.200
    73.200    -1.307     0.200
    74.000    -0.534     0.200
    74.704    -0.298     0.200
    75.152    -0.176     0.200
    75.152    -0.396     0.200
    75.378    -0.427     0.200
    75.378     0.384     0.200
    75.378     1.174     0.200
    75.622     0.940     0.200
    76.282     0.682     0.200
    76.282    -0.113     0.200
    76.524     1.154     0.200
    77.433    -1.562     0.200
    77.941    -0.639     0.200
    77.941    -0.014     0.200
    79.009     1.058     0.200
    79.479    -0.200     0.200
    80.591     0.472     0.200
    81.743    -0.474     0.200
    81.483    -0.391     0.200
    82.927     0.466     0.200
    82.927    -0.058     0.200
    83.299     0.001     0.200
    83.299     0.932     0.200
    83.299     1.372     0.200
    83.299     1.772     0.200
    83.955    -0.995     0.200
    83.955    -0.475     0.200
    84.393     0.936     0.200
    85.553     0.731     0.200
    86.084     1.327     0.200
    86.416    -0.230     0.200
    86.416     0.201     0.200
    86.647    -0.862     0.200
    86.474     1.184     0.200
    89.366    -0.202     0.200
    89.366     0.093     0.200
    89.722    -0.593     0.200
    90.536    -0.641     0.200
    90.536    -0.938     0.200
    14.368     7.332     0.200
    14.670     4.306     0.200
    15.903     6.863     0.200
    19.470    -0.330     0.200
    19.852    -1.994     0.200
    20.124     0.000     0.200
    20.259     0.964     0.200
    20.845     2.113     0.200
    20.896     1.386     0.200
    20.896     1.115     0.200
    21.002     1.689     0.200
    21.240    -0.165     0.200
    21.240    -0.705     0.200
    21.240     0.144     0.200
    21.274     0.882     0.200
    21.274     0.781     0.200
    21.274     0.606     0.200
    21.274     0.411     0.200
    21.334     0.159     0.200
    21.438     0.075     0.200
    21.438    -0.175     0.200
    21.718     2.884     0.200
    21.997     0.845     0.200
    21.995     0.862     0.200
    23.390     1.144     0.200
    24.515     1.045     0.200
    24.846    -0.344     0.200
    24.936     0.411     0.200
    25.012     1.320     0.200
    25.139    -0.832     0.200
    25.355     1.203     0.200
    25.347     3.770     0.200
    25.384     1.340     0.200
    25.566    -0.265     0.200
    25.578     2.872     0.200
    25.647    -1.552     0.200
    25.777     1.268     0.200
    25.821     0.309     0.200
    26.125     1.417     0.200
    26.169    -0.182     0.200
    26.449     1.387     0.200
    26.433     1.433     0.200
    26.774     0.657     0.200
    26.914     0.397     0.200
    27.072     1.202     0.200
    27.072     2.973     0.200
    27.407     1.582     0.200
    27.822     1.895     0.200
    28.203     1.859     0.200
    28.203     2.050     0.200
    28.267     2.381     0.200
    28.640     2.114     0.200
    29.791     0.815     0.200
    29.949     0.045     0.200
    30.044     2.204     0.200
    30.112     0.505     0.200
    31.131     0.600     0.200
    32.419    -0.403     0.200
    32.419    -0.173     0.200
    33.683    -0.262     0.200
    34.207     0.874     0.200
    34.302     0.349     0.200
    34.560     1.565     0.200
    34.700    -0.394     0.200
    34.700     0.208     0.200
    34.712     2.399     0.200
    34.791     0.513     0.200
    35.403     0.930     0.200
    36.806    -2.070     0.200
    36.898    -1.848     0.200
    36.960     0.281     0.200
    36.960    -0.429     0.200
    38.056    -1.213     0.200
    38.092     0.475     0.200
    38.310    -0.066     0.200
    38.543     1.322     0.200
    38.661    -0.234     0.200
    38.961     0.885     0.200
    38.932     0.816     0.200
    39.730     0.554     0.200
    40.372    -1.162     0.200
    40.561     0.507     0.200
    40.561     0.897     0.200
    41.073    -0.917     0.200
    41.392     1.261     0.200
    41.673    -1.238     0.200
    42.075    -1.030     0.200
    42.366    -0.802     0.200
    42.508    -0.402     0.200
    42.451    -1.193     0.200
    42.488    -0.820     0.200
    42.958     0.985     0.200
    43.655     0.604     0.200
    43.920    -0.544     0.200
    43.958    -0.880     0.200
    44.131     0.909     0.200
    44.436     1.186     0.200
    44.735    -0.420     0.200
    44.735     0.130     0.200
    44.735     0.300     0.200
    45.123     0.178     0.200
    45.123     0.258     0.200
    45.123    -0.191     0.200
    45.080     1.334     0.200
    45.080     0.455     0.200
    45.080     1.565     0.200
    45.115    -0.052     0.200
    45.115     0.174     0.200
    45.239     0.387     0.200
    45.270     0.942     0.200
    45.305     1.061     0.200
    45.531     2.474     0.200
    45.834     0.005     0.200
    46.059    -0.587     0.200
    46.338     0.306     0.200
    46.433    -0.193     0.200
    46.523     2.851     0.200
    46.523     2.292     0.200
    46.523    -0.078     0.200
    46.784     0.025     0.200
    46.704     1.722     0.200
    46.781     2.128     0.200
    46.993     0.242     0.200
    46.931     0.054     0.200
    47.589    -0.476     0.200
    47.604    -0.719     0.200
    47.604    -0.794     0.200
    47.617    -1.188     0.200
    47.617    -1.658     0.200
    47.617    -1.992     0.200
    47.634    -0.521     0.200
    47.643    -0.396     0.200
    47.666    -0.575     0.200
    47.668    -0.084     0.200
    47.741    -0.258     0.200
    47.949     0.706     0.200
    47.975     2.239     0.200
    48.091    -1.417     0.200
    48.345    -1.006     0.200
    48.389    -1.365     0.200
    48.389    -0.965     0.200
    48.827    -0.938     0.200
    49.738    -0.906     0.200
    49.882     1.435     0.200
    50.340     0.924     0.200
    50.790     2.136     0.200
    51.158     0.427     0.200
    51.355     0.014     0.200
    51.425    -0.089     0.200
    51.460     0.227     0.200
    51.399    -0.331     0.200
    51.629     0.024     0.200
    51.960     0.292     0.200
    51.945     0.188     0.200
    51.966    -0.163     0.200
    52.051     0.316     0.200
    52.100     0.222     0.200
    52.109    -0.049     0.200
    52.116     1.292     0.200
    52.108     0.193     0.200
    52.108     0.353     0.200
    52.227    -1.124     0.200
    52.258     0.634     0.200
    52.419     0.458     0.200
    52.695     1.167     0.200
    52.762     0.590     0.200
    52.762     0.400     0.200
    52.881     0.417     0.200
    52.882     0.865     0.200
    52.882     0.625     0.200
    53.052     0.638     0.200
    53.158     0.111     0.200
    53.244     0.642     0.200
    53.268     1.162     0.200
    53.307     0.431     0.200
    53.422     0.224     0.200
    53.422    -0.466     0.200
    53.487    -0.088     0.200
    53.499     1.225     0.200
    53.499     1.035     0.200
    53.697     0.044     0.200
    53.697    -0.486     0.200
    53.667     1.231     0.200
    53.720    -1.231     0.200
    53.776     0.535     0.200
    53.830     0.443     0.200
    53.864     0.391     0.200
    53.953     0.631     0.200
    54.006     0.223     0.200
    54.301     1.299     0.200
    54.393     0.833     0.200
    54.463     0.280     0.200
    54.463    -0.180     0.200
    54.472    -0.244     0.200
    54.578    -0.551     0.200
    54.578    -0.810     0.200
    54.662     0.974     0.200
    54.674     0.190     0.200
    54.671    -0.455     0.200
    54.732     0.229     0.200
    54.732     0.468     0.200
    54.765     1.100     0.200
    54.795    -0.008     0.200
    54.795    -0.288     0.200
    54.879     0.202     0.200
    54.940     0.974     0.200
    55.117     0.838     0.200
    55.172    -0.238     0.200
    55.452    -0.585     0.200
    55.593     0.609     0.200
    55.679     0.061     0.200
    55.632     3.102     0.200
    55.776    -0.678     0.200
    55.779    -0.282     0.200
    55.779    -0.048     0.200
    55.677    -0.013     0.200
    55.823     0.397     0.200
    55.805    -0.085     0.200
    55.843     0.256     0.200
    55.936     0.191     0.200
    55.934     0.034     0.200
    55.934     0.404     0.200
    56.060    -0.009     0.200
    56.033     0.858     0.200
    56.094    -0.040     0.200
    56.094     0.085     0.200
    56.094    -0.171     0.200
    56.178    -1.239     0.200
    56.101     0.347     0.200
    56.128    -0.293     0.200
    56.233     0.294     0.200
    56.535     0.452     0.200
    56.580     0.193     0.200
    56.584     0.293     0.200
    56.664     0.583     0.200
    56.845    -1.228     0.200
    56.999    -0.365     0.200
    57.095    -0.135     0.200
    57.112     0.123     0.200
    57.325     0.451     0.200
    57.460     0.611     0.200
    57.419     0.834     0.200
    57.419     0.614     0.200
    57.459     0.796     0.200
    57.576     1.058     0.200
    57.576     0.471     0.200
    57.614    -0.224     0.200
    57.619     0.747     0.200
    57.701    -1.418     0.200
    57.682    -0.988     0.200
    57.901     0.436     0.200
    57.957    -0.066     0.200
    58.012    -0.897     0.200
    58.012    -1.147     0.200
    58.053     1.115     0.200
    58.105    -0.174     0.200
    58.133     1.299     0.200
    58.162     1.093     0.200
    58.291     0.091     0.200
    58.295    -0.807     0.200
    58.482    -0.043     0.200
    58.480     0.200     0.200
    58.565    -0.851     0.200
    58.782    -0.580     0.200
    58.812    -0.414     0.200
    59.180     0.172     0.200
    59.295     0.577     0.200
    59.641     1.060     0.200
    59.851    -0.496     0.200
    60.006    -0.275     0.200
    60.255    -0.203     0.200
    60.373    -0.834     0.200
    60.373    -1.004     0.200
    60.928    -1.531     0.200
    61.045    -1.297     0.200
    61.160     0.415     0.200
    61.160     0.265     0.200
    61.173     1.236     0.200
    61.515    -1.159     0.200
    62.085    -0.328     0.200
    62.546    -1.084     0.200
    62.819    -0.748     0.200
    63.673    -0.379     0.200
    64.396     0.204     0.200
    65.442     0.974     0.200
    66.021    -1.100     0.200
    66.021    -0.869     0.200
    67.965    -0.110     0.200
    67.965    -0.751     0.200
    67.965    -0.291     0.200
    69.638    -0.466     0.200
    70.986     0.158     0.200
    71.466    -1.246     0.200
    72.624     0.921     0.200
    73.014     0.055     0.200
    73.339    -1.526     0.200
    73.654    -0.904     0.200
    74.457    -1.279     0.200
    74.492     2.899     0.200
    74.760     0.294     0.200
    74.945    -0.915     0.200
    74.956     0.044     0.200
    75.217    -0.223     0.200
    75.279     0.492     0.200
    75.472    -0.189     0.200
    75.472     0.031     0.200
    75.675     0.727     0.200
    76.293     0.973     0.200
    76.293     0.674     0.200
    76.567     0.580     0.200
    76.604    -0.723     0.200
    77.560    -0.829     0.200
    77.601    -0.740     0.200
    78.617     0.197     0.200
    78.980    -0.262     0.200
    80.358    -0.089     0.200
    80.646     0.443     0.200
    80.851     0.976     0.200
    81.147    -0.341     0.200
    81.147    -0.772     0.200
    81.959    -0.126     0.200
    83.160     0.944     0.200
    83.160     0.204     0.200
    83.160     1.254     0.200
    83.359     0.796     0.200
    83.359     0.027     0.200
    83.368    -1.380     0.200
    83.731     1.196     0.200
    84.098    -1.250     0.200
    84.424     0.273     0.200
    84.761    -0.050     0.200
    85.652     0.258     0.200
    86.573    -0.339     0.200
    86.804    -0.398     0.200
    89.429     0.113     0.200
    89.429    -0.063     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   102.692    -0.866     0.200
   100.286    -1.352     0.200
   100.389    -0.488     0.200
   100.496    -0.706     0.200
   100.755    -0.767     0.200
   106.115     4.236     0.200
    99.816    -1.111     0.200
   118.700     1.912     0.200
    99.962    -0.236     0.200
    99.962     0.209     0.200
   100.065     0.353     0.200
   100.172     0.279     0.200
   100.431     1.532     0.200
   135.333     0.164     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    43.509   104.409     0.200
    75.907    16.686     0.200
    76.598     8.761     0.200
    42.737   112.804     0.200
    53.693    70.410     0.200
    54.747    60.730     0.200
    85.400     3.837     0.200
    53.142    65.194     0.200
    28.634   190.726     0.200
    32.088   167.204     0.200
    55.188    60.535     0.200
    58.899    44.152     0.200
    25.214   213.665     0.200
    37.483   137.084     0.200
    38.915   129.922     0.200
    39.366   128.646     0.200
    42.866   110.848     0.200
    46.303    95.902     0.200
    47.222    90.707     0.200
    51.107    71.170     0.200
    52.813    69.655     0.200
    56.076    57.334     0.200
    56.538    54.538     0.200
    78.878     8.560     0.200
    79.680     7.879     0.200
    80.278     7.242     0.200
    80.755     7.885     0.200
    81.080     6.049     0.200
    81.088     6.908     0.200
    83.113     7.382     0.200
    77.579     5.549     0.200
    20.590   251.143     0.200
    28.555   190.892     0.200
    40.385   120.278     0.200
    41.988   118.102     0.200
    43.726   109.008     0.200
    44.088   107.101     0.200
    45.837    94.087     0.200
    46.249    96.435     0.200
    49.239    87.744     0.200
    53.651    66.708     0.200
    99.166    -0.216     0.200
    45.758    97.288     0.200
    15.344   309.465     0.200
    16.788   286.661     0.200
    26.264   205.990     0.200
    30.120   184.764     0.200
    36.735   140.068     0.200
    15.223   307.569     0.200
    22.069   241.546     0.200
    25.892   209.959     0.200
    29.916   178.477     0.200
    29.812   187.398     0.200
    36.863   138.617     0.200
    38.951   130.142     0.200
    41.463   114.973     0.200
    80.307     6.326     0.200
    80.333     5.909     0.200
    80.387     6.427     0.200
    80.615     6.554     0.200
    80.599     5.955     0.200
    80.925     6.737     0.200
    81.002     6.133     0.200
    81.259     6.699     0.200
    81.961     5.989     0.200
    81.977     5.274     0.200
    83.236     5.777     0.200
    25.043   216.675     0.200
    28.222   196.323     0.200
    29.105   190.468     0.200
    38.038   135.162     0.200
    38.363   132.717     0.200
    44.007   105.912     0.200
    51.336    73.826     0.200
    51.747    70.054     0.200
    52.504    69.719     0.200
    53.281    67.278     0.200
    23.529   225.379     0.200
    23.837   223.700     0.200
    25.483   211.176     0.200
    25.489   211.070     0.200
    26.005   206.536     0.200
    30.024   184.744     0.200
    30.078   179.471     0.200
    37.296   137.822     0.200
    37.296   137.924     0.200
    39.195   130.030     0.200
    44.253   104.706     0.200
    45.352    99.847     0.200
    46.440    94.445     0.200
    46.632    92.450     0.200
    47.734    89.270     0.200
    48.039    87.759     0.200
    48.143    84.484     0.200
    48.356    87.014     0.200
    48.412    84.910     0.200
    49.891    80.542     0.200
    52.442    70.699     0.200
    53.145    65.222     0.200
    53.145    65.322     0.200
    53.649    67.868     0.200
    54.478    63.002     0.200
    54.645    62.469     0.200
    54.695    62.345     0.200
    60.707    43.432     0.200
    26.413   207.948     0.200
    45.232   102.049     0.200
    39.180   129.562     0.200
    45.232    99.655     0.200
    45.898    94.466     0.200
    45.241   101.213     0.200
    18.697   272.025     0.200
    29.180   186.975     0.200
    38.184   133.804     0.200
    38.801   131.873     0.200
    45.426    98.787     0.200
    44.619   102.454     0.200
    56.176    57.029     0.200
    26.595   205.934     0.200
    30.257   176.683     0.200
    36.111   143.457     0.200
    25.621   209.457     0.200
    29.979   179.647     0.200
    38.945   130.264     0.200
    41.421   115.197     0.200
    42.512   110.466     0.200
    43.991   105.221     0.200
    46.600    93.853     0.200
    54.603    62.166     0.200
    57.722    51.770     0.200
    41.009   117.464     0.200
    29.949   179.144     0.200
    36.806   138.631     0.200
    43.958   105.019     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
