#!/bin/bash
gmt begin novy1.66_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times novy1.66'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.784
    25.500   328.327
    26.000   332.859
    26.500   337.380
    27.000   341.888
    27.500   346.380
    28.000   350.852
    28.500   355.308
    29.000   359.753
    29.500   364.189
    30.000   368.618
    30.500   373.039
    31.000   377.452
    31.500   381.857
    32.000   386.254
    32.500   390.642
    33.000   395.019
    33.500   399.383
    34.000   403.734
    34.500   408.069
    35.000   412.390
    35.500   416.695
    36.000   420.985
    36.500   425.260
    37.000   429.520
    37.500   433.763
    38.000   437.991
    38.500   442.203
    39.000   446.398
    39.500   450.577
    40.000   454.738
    40.500   458.882
    41.000   463.009
    41.500   467.119
    42.000   471.212
    42.500   475.288
    43.000   479.347
    43.500   483.387
    44.000   487.411
    44.500   491.416
    45.000   495.403
    45.500   499.373
    46.000   503.324
    46.500   507.258
    47.000   511.173
    47.500   515.071
    48.000   518.950
    48.500   522.811
    49.000   526.654
    49.500   530.479
    50.000   534.285
    50.500   538.074
    51.000   541.843
    51.500   545.595
    52.000   549.329
    52.500   553.044
    53.000   556.742
    53.500   560.422
    54.000   564.084
    54.500   567.728
    55.000   571.353
    55.500   574.960
    56.000   578.548
    56.500   582.118
    57.000   585.669
    57.500   589.203
    58.000   592.718
    58.500   596.215
    59.000   599.694
    59.500   603.155
    60.000   606.597
    60.500   610.021
    61.000   613.427
    61.500   616.814
    62.000   620.182
    62.500   623.533
    63.000   626.866
    63.500   630.181
    64.000   633.478
    64.500   636.757
    65.000   640.019
    65.500   643.262
    66.000   646.487
    66.500   649.695
    67.000   652.884
    67.500   656.055
    68.000   659.208
    68.500   662.342
    69.000   665.459
    69.500   668.557
    70.000   671.637
    70.500   674.699
    71.000   677.743
    71.500   680.769
    72.000   683.777
    72.500   686.766
    73.000   689.738
    73.500   692.690
    74.000   695.624
    74.500   698.539
    75.000   701.435
    75.500   704.313
    76.000   707.173
    76.500   710.014
    77.000   712.837
    77.500   715.642
    78.000   718.429
    78.500   721.198
    79.000   723.949
    79.500   726.681
    80.000   729.395
    80.500   732.090
    81.000   734.765
    81.500   737.421
    82.000   740.058
    82.500   742.676
    83.000   745.275
    83.500   747.856
    84.000   750.417
    84.500   752.958
    85.000   755.478
    85.500   757.978
    86.000   760.460
    86.500   762.924
    87.000   765.370
    87.500   767.794
    88.000   770.182
    88.500   772.549
    89.000   774.903
    89.500   777.249
    90.000   779.587
    90.500   781.918
    91.000   784.243
    91.500   786.562
    92.000   788.877
    92.500   791.187
    93.000   793.495
    93.500   795.798
    94.000   798.098
    94.500   800.394
    95.000   802.684
    95.500   804.969
    96.000   807.247
    96.500   809.518
    97.000   811.784
    97.500   814.042
    98.000   816.294
    98.500   818.538
    99.000   820.774
    99.500   823.003
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1122.017
   116.000  1122.979
   116.500  1123.941
   117.000  1124.903
   117.500  1125.865
   118.000  1126.827
   118.500  1127.789
   119.000  1128.750
   119.500  1129.712
   120.000  1130.673
   120.500  1131.634
   121.000  1132.595
   121.500  1133.555
   122.000  1134.516
   122.500  1135.476
   123.000  1136.435
   123.500  1137.394
   124.000  1138.353
   124.500  1139.311
   125.000  1140.269
   125.500  1141.226
   126.000  1142.182
   126.500  1143.138
   127.000  1144.094
   127.500  1145.048
   128.000  1146.001
   128.500  1146.954
   129.000  1147.906
   129.500  1148.857
   130.000  1149.807
   130.500  1150.756
   131.000  1151.703
   131.500  1152.650
   132.000  1153.595
   132.500  1154.538
   133.000  1155.481
   133.500  1156.421
   134.000  1157.360
   134.500  1158.297
   135.000  1159.232
   135.500  1160.166
   136.000  1161.097
   136.500  1162.026
   137.000  1162.952
   137.500  1163.876
   138.000  1164.797
   138.500  1165.716
   139.000  1166.632
   139.500  1167.544
   140.000  1168.454
   140.500  1169.360
   141.000  1170.263
   141.500  1171.161
   142.000  1172.056
   142.500  1172.946
   143.000  1173.832
   143.500  1174.714
   144.000  1175.590
   144.500  1176.461
   145.000  1177.327
   145.500  1178.186
   146.000  1179.040
   146.500  1179.888
   147.000  1180.729
   147.500  1181.563
   148.000  1182.390
   148.500  1183.210
   149.000  1184.021
   149.500  1184.824
   150.000  1185.617
   150.500  1186.401
   151.000  1187.174
   151.500  1187.937
   152.000  1188.691
   152.500  1189.434
   153.000  1190.168
   153.500  1190.891
   154.000  1191.603
   154.500  1192.304
   155.000  1192.995
   155.500  1193.674
   156.000  1194.341
   156.500  1194.997
   157.000  1195.640
   157.500  1196.272
   158.000  1196.891
   158.500  1197.498
   159.000  1198.092
   159.500  1198.673
   160.000  1199.242
   160.500  1199.797
   161.000  1200.339
   161.500  1200.869
   162.000  1201.385
   162.500  1201.888
   163.000  1202.378
   163.500  1202.854
   164.000  1203.316
   164.500  1203.764
   165.000  1204.199
   165.500  1204.619
   166.000  1205.026
   166.500  1205.419
   167.000  1205.799
   167.500  1206.164
   168.000  1206.515
   168.500  1206.852
   169.000  1207.175
   169.500  1207.483
   170.000  1207.778
   170.500  1208.058
   171.000  1208.324
   171.500  1208.576
   172.000  1208.814
   172.500  1209.037
   173.000  1209.246
   173.500  1209.440
   174.000  1209.621
   174.500  1209.787
   175.000  1209.938
   175.500  1210.075
   176.000  1210.198
   176.500  1210.306
   177.000  1210.400
   177.500  1210.479
   178.000  1210.544
   178.500  1210.595
   179.000  1210.631
   179.500  1210.653
   180.000  1210.660
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.958
     1.000   992.967
     1.500   992.981
     2.000   993.000
     2.500   993.026
     3.000   993.056
     3.500   993.093
     4.000   993.135
     4.500   993.182
     5.000   993.235
     5.500   993.294
     6.000   993.358
     6.500   993.428
     7.000   993.504
     7.500   993.585
     8.000   993.671
     8.500   993.764
     9.000   993.861
     9.500   993.965
    10.000   994.074
    10.500   994.188
    11.000   994.308
    11.500   994.434
    12.000   994.565
    12.500   994.701
    13.000   994.843
    13.500   994.991
    14.000   995.144
    14.500   995.303
    15.000   995.467
    15.500   995.637
    16.000   995.812
    16.500   995.993
    17.000   996.179
    17.500   996.371
    18.000   996.568
    18.500   996.771
    19.000   996.979
    19.500   997.193
    20.000   997.412
    20.500   997.636
    21.000   997.866
    21.500   998.102
    22.000   998.343
    22.500   998.589
    23.000   998.840
    23.500   999.097
    24.000   999.360
    24.500   999.627
    25.000   999.901
    25.500  1000.179
    26.000  1000.463
    26.500  1000.752
    27.000  1001.047
    27.500  1001.346
    28.000  1001.651
    28.500  1001.962
    29.000  1002.277
    29.500  1002.599
    30.000  1002.925
    30.500  1003.256
    31.000  1003.593
    31.500  1003.935
    32.000  1004.282
    32.500  1004.635
    33.000  1004.992
    33.500  1005.355
    34.000  1005.723
    34.500  1006.096
    35.000  1006.474
    35.500  1006.858
    36.000  1007.246
    36.500  1007.640
    37.000  1008.038
    37.500  1008.442
    38.000  1008.851
    38.500  1009.265
    39.000  1009.684
    39.500  1010.108
    40.000  1010.537
    40.500  1010.971
    41.000  1011.410
    41.500  1011.854
    42.000  1012.303
    42.500  1012.756
    43.000  1013.215
    43.500  1013.679
    44.000  1014.147
    44.500  1014.621
    45.000  1015.099
    45.500  1015.582
    46.000  1016.070
    46.500  1016.563
    47.000  1017.061
    47.500  1017.563
    48.000  1018.070
    48.500  1018.582
    49.000  1019.099
    49.500  1019.620
    50.000  1020.146
    50.500  1020.677
    51.000  1021.213
    51.500  1021.753
    52.000  1022.298
    52.500  1022.847
    53.000  1023.401
    53.500  1023.959
    54.000  1024.522
    54.500  1025.090
    55.000  1025.662
    55.500  1026.239
    56.000  1026.820
    56.500  1027.406
    57.000  1027.996
    57.500  1028.590
    58.000  1029.189
    58.500  1029.792
    59.000  1030.400
    59.500  1031.012
    60.000  1031.629
    60.500  1032.249
    61.000  1032.874
    61.500  1033.504
    62.000  1034.137
    62.500  1034.775
    63.000  1035.417
    63.500  1036.063
    64.000  1036.714
    64.500  1037.368
    65.000  1038.027
    65.500  1038.690
    66.000  1039.357
    66.500  1040.028
    67.000  1040.703
    67.500  1041.382
    68.000  1042.065
    68.500  1042.752
    69.000  1043.444
    69.500  1044.139
    70.000  1044.838
    70.500  1045.541
    71.000  1046.248
    71.500  1046.958
    72.000  1047.673
    72.500  1048.391
    73.000  1049.113
    73.500  1049.839
    74.000  1050.569
    74.500  1051.303
    75.000  1052.040
    75.500  1052.781
    76.000  1053.526
    76.500  1054.274
    77.000  1055.026
    77.500  1055.781
    78.000  1056.540
    78.500  1057.303
    79.000  1058.069
    79.500  1058.839
    80.000  1059.612
    80.500  1060.389
    81.000  1061.169
    81.500  1061.953
    82.000  1062.740
    82.500  1063.530
    83.000  1064.324
    83.500  1065.121
    84.000  1065.921
    84.500  1066.725
    85.000  1067.532
    85.500  1068.342
    86.000  1069.156
    86.500  1069.973
    87.000  1070.793
    87.500  1071.616
    88.000  1072.442
    88.500  1073.271
    89.000  1074.103
    89.500  1074.939
    90.000  1075.777
    90.500  1076.619
    91.000  1077.463
    91.500  1078.311
    92.000  1079.161
    92.500  1080.014
    93.000  1080.871
    93.500  1081.730
    94.000  1082.592
    94.500  1083.457
    95.000  1084.324
    95.500  1085.195
    96.000  1086.068
    96.500  1086.944
    97.000  1087.822
    97.500  1088.703
    98.000  1089.587
    98.500  1090.474
    99.000  1091.363
    99.500  1092.255
   100.000  1093.149
   100.500  1094.046
   101.000  1094.946
   101.500  1095.848
   102.000  1096.752
   102.500  1097.659
   103.000  1098.568
   103.500  1099.480
   104.000  1100.394
   104.500  1101.310
   105.000  1102.229
   105.500  1103.150
   106.000  1104.073
   106.500  1104.999
   107.000  1105.927
   107.500  1106.857
   108.000  1107.789
   108.500  1108.723
   109.000  1109.660
   109.500  1110.598
   110.000  1111.539
   110.500  1112.481
   111.000  1113.426
   111.500  1114.373
   112.000  1115.322
   112.500  1116.272
   113.000  1117.225
   113.500  1118.180
   114.000  1119.136
   114.500  1120.095
   115.000  1121.055
   115.500  1122.017
   116.000  1122.981
   116.500  1123.946
   117.000  1124.914
   117.500  1125.883
   118.000  1126.853
   118.500  1127.826
   119.000  1128.800
   119.500  1129.776
   120.000  1130.753
   120.500  1131.732
   121.000  1132.712
   121.500  1133.694
   122.000  1134.678
   122.500  1135.663
   123.000  1136.649
   123.500  1137.637
   124.000  1138.627
   124.500  1139.617
   125.000  1140.609
   125.500  1141.603
   126.000  1142.598
   126.500  1143.594
   127.000  1144.591
   127.500  1145.590
   128.000  1146.589
   128.500  1147.590
   129.000  1148.593
   129.500  1149.596
   130.000  1150.600
   130.500  1151.606
   131.000  1152.613
   131.500  1153.620
   132.000  1154.629
   132.500  1155.639
   133.000  1156.650
   133.500  1157.661
   134.000  1158.674
   134.500  1159.688
   135.000  1160.702
   135.500  1161.718
   136.000  1162.734
   136.500  1163.751
   137.000  1164.769
   137.500  1165.788
   138.000  1166.807
   138.500  1167.827
   139.000  1168.848
   139.500  1169.870
   140.000  1170.892
   140.500  1171.915
   141.000  1172.939
   141.500  1173.963
   142.000  1174.988
   142.500  1176.013
   143.000  1177.039
   143.500  1178.066
   144.000  1179.093
   144.500  1180.120
   145.000  1181.148
   145.500  1182.176
   146.000  1183.205
   146.500  1184.234
   147.000  1185.263
   147.500  1186.293
   148.000  1187.323
   148.500  1188.354
   149.000  1189.385
   149.500  1190.416
   150.000  1191.447
   150.500  1192.479
   151.000  1193.510
   151.500  1194.542
   152.000  1195.574
   152.500  1196.607
   153.000  1197.639
   153.500  1198.671
   154.000  1199.704
   154.500  1200.736
   155.000  1201.769
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.638
   145.500  1178.461
   146.000  1180.342
   146.500  1182.259
   147.000  1184.204
   147.500  1186.172
   148.000  1188.160
   148.500  1190.166
   149.000  1192.187
   149.500  1194.222
   150.000  1196.270
   150.500  1198.330
   151.000  1200.400
   151.500  1202.479
   152.000  1204.568
   152.500  1206.665
   153.000  1208.769
   153.500  1210.881
   154.000  1213.001
   154.500  1215.126
   155.000  1217.258
   155.500  1219.396
   156.000  1221.538
   156.500  1223.686
   157.000  1225.838
   157.500  1227.995
   158.000  1230.156
   158.500  1232.322
   159.000  1234.491
   159.500  1236.664
   160.000  1238.840
   160.500  1241.020
   161.000  1243.202
   161.500  1245.388
   162.000  1247.576
   162.500  1249.767
   163.000  1251.960
   163.500  1254.155
   164.000  1256.353
   164.500  1258.552
   165.000  1260.754
   165.500  1262.957
   166.000  1265.162
   166.500  1267.369
   167.000  1269.577
   167.500  1271.787
   168.000  1273.998
   168.500  1276.210
   169.000  1278.423
   169.500  1280.638
   170.000  1282.853
   170.500  1285.070
   171.000  1287.287
   171.500  1289.505
   172.000  1291.724
   172.500  1293.943
   173.000  1296.163
   173.500  1298.384
   174.000  1300.605
   174.500  1302.826
   175.000  1305.048
   175.500  1307.270
   176.000  1309.492
   176.500  1311.715
   177.000  1313.937
   177.500  1316.160
   178.000  1318.383
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.636
   145.500  1178.262
   146.000  1179.809
   146.500  1181.299
   147.000  1182.738
   147.500  1184.133
   148.000  1185.484
   148.500  1186.797
   149.000  1188.074
   149.500  1189.322
   150.000  1190.546
   150.500  1191.746
   151.000  1192.926
   151.500  1194.087
   152.000  1195.229
   152.500  1196.354
   153.000  1197.463
   153.500  1198.557
   154.000  1199.638
   154.500  1200.707
   155.000  1201.761
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.834
     1.000   509.870
     1.500   509.930
     2.000   510.014
     2.500   510.122
     3.000   510.254
     3.500   510.410
     4.000   510.590
     4.500   510.793
     5.000   511.021
     5.500   511.272
     6.000   511.547
     6.500   511.846
     7.000   512.168
     7.500   512.514
     8.000   512.883
     8.500   513.276
     9.000   513.693
     9.500   514.132
    10.000   514.595
    10.500   515.080
    11.000   515.589
    11.500   516.121
    12.000   516.675
    12.500   517.253
    13.000   517.852
    13.500   518.475
    14.000   519.119
    14.500   519.786
    15.000   520.475
    15.500   521.187
    16.000   521.920
    16.500   522.674
    17.000   523.451
    17.500   524.249
    18.000   525.068
    18.500   525.909
    19.000   526.770
    19.500   527.653
    20.000   528.556
    20.500   529.480
    21.000   530.424
    21.500   531.389
    22.000   532.373
    22.500   533.378
    23.000   534.403
    23.500   535.447
    24.000   536.511
    24.500   537.594
    25.000   538.696
    25.500   539.817
    26.000   540.957
    26.500   542.115
    27.000   543.292
    27.500   544.488
    28.000   545.701
    28.500   546.932
    29.000   548.181
    29.500   549.448
    30.000   550.732
    30.500   552.033
    31.000   553.351
    31.500   554.686
    32.000   556.037
    32.500   557.405
    33.000   558.790
    33.500   560.190
    34.000   561.606
    34.500   563.038
    35.000   564.485
    35.500   565.948
    36.000   567.426
    36.500   568.919
    37.000   570.426
    37.500   571.948
    38.000   573.485
    38.500   575.036
    39.000   576.600
    39.500   578.179
    40.000   579.771
    40.500   581.377
    41.000   582.996
    41.500   584.628
    42.000   586.273
    42.500   587.930
    43.000   589.601
    43.500   591.283
    44.000   592.978
    44.500   594.685
    45.000   596.404
    45.500   598.134
    46.000   599.876
    46.500   601.629
    47.000   603.394
    47.500   605.169
    48.000   606.955
    48.500   608.752
    49.000   610.559
    49.500   612.376
    50.000   614.204
    50.500   616.041
    51.000   617.889
    51.500   619.746
    52.000   621.612
    52.500   623.488
    53.000   625.373
    53.500   627.266
    54.000   629.169
    54.500   631.081
    55.000   633.000
    55.500   634.929
    56.000   636.865
    56.500   638.810
    57.000   640.762
    57.500   642.722
    58.000   644.690
    58.500   646.665
    59.000   648.648
    59.500   650.638
    60.000   652.635
    60.500   654.639
    61.000   656.649
    61.500   658.666
    62.000   660.690
    62.500   662.720
    63.000   664.756
    63.500   666.799
    64.000   668.847
    64.500   670.901
    65.000   672.961
    65.500   675.026
    66.000   677.097
    66.500   679.174
    67.000   681.255
    67.500   683.342
    68.000   685.433
    68.500   687.530
    69.000   689.631
    69.500   691.737
    70.000   693.847
    70.500   695.962
    71.000   698.081
    71.500   700.204
    72.000   702.331
    72.500   704.462
    73.000   706.597
    73.500   708.736
    74.000   710.879
    74.500   713.025
    75.000   715.174
    75.500   717.327
    76.000   719.483
    76.500   721.643
    77.000   723.805
    77.500   725.970
    78.000   728.139
    78.500   730.310
    79.000   732.483
    79.500   734.660
    80.000   736.839
    80.500   739.020
    81.000   741.204
    81.500   743.390
    82.000   745.578
    82.500   747.768
    83.000   749.960
    83.500   752.155
    84.000   754.351
    84.500   756.549
    85.000   758.749
    85.500   760.950
    86.000   763.153
    86.500   765.357
    87.000   767.563
    87.500   769.771
    88.000   771.979
    88.500   774.189
    89.000   776.400
    89.500   778.613
    90.000   780.826
    90.500   783.040
    91.000   785.255
    91.500   787.471
    92.000   789.688
    92.500   791.906
    93.000   794.124
    93.500   796.343
    94.000   798.563
    94.500   800.783
    95.000   803.004
    95.500   805.225
    96.000   807.446
    96.500   809.668
    97.000   811.890
    97.500   814.113
    98.000   816.335
    98.500   818.558
    99.000   820.780
    99.500   823.003
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.623
    29.000   425.181
    29.500   430.737
    30.000   436.294
    30.500   441.849
    31.000   447.402
    31.500   452.954
    32.000   458.504
    32.500   464.051
    33.000   469.596
    33.500   475.137
    34.000   480.674
    34.500   486.208
    35.000   491.736
    35.500   497.260
    36.000   502.778
    36.500   508.290
    37.000   513.796
    37.500   519.294
    38.000   524.785
    38.500   530.267
    39.000   535.740
    39.500   541.204
    40.000   546.658
    40.500   552.102
    41.000   557.534
    41.500   562.955
    42.000   568.363
    42.500   573.758
    43.000   579.140
    43.500   584.509
    44.000   589.862
    44.500   595.201
    45.000   600.525
    45.500   605.833
    46.000   611.125
    46.500   616.400
    47.000   621.658
    47.500   626.405
    48.000   630.976
    48.500   635.542
    49.000   640.103
    49.500   644.660
    50.000   649.211
    50.500   653.758
    51.000   658.299
    51.500   662.834
    52.000   667.364
    52.500   671.888
    53.000   676.407
    53.500   680.919
    54.000   685.424
    54.500   689.921
    55.000   694.410
    55.500   698.888
    56.000   703.355
    56.500   707.815
    57.000   712.269
    57.500   716.717
    58.000   721.161
    58.500   725.599
    59.000   730.034
    59.500   734.465
    60.000   738.892
    60.500   743.315
    61.000   747.734
    61.500   752.150
    62.000   756.561
    62.500   760.969
    63.000   765.373
    63.500   769.772
    64.000   774.168
    64.500   778.559
    65.000   782.944
    65.500   787.325
    66.000   791.700
    66.500   796.068
    67.000   800.430
    67.500   804.784
    68.000   809.132
    68.500   813.472
    69.000   817.805
    69.500   822.129
    70.000   826.447
    70.500   830.756
    71.000   835.059
    71.500   839.353
    72.000   843.641
    72.500   847.920
    73.000   852.192
    73.500   856.456
    74.000   860.713
    74.500   864.961
    75.000   869.202
    75.500   873.435
    76.000   877.659
    76.500   881.876
    77.000   886.084
    77.500   890.284
    78.000   894.476
    78.500   898.660
    79.000   902.835
    79.500   907.001
    80.000   911.159
    80.500   915.308
    81.000   919.449
    81.500   923.581
    82.000   927.704
    82.500   931.820
    83.000   935.926
    83.500   940.024
    84.000   944.114
    84.500   948.195
    85.000   952.267
    85.500   956.331
    86.000   960.386
    86.500   964.432
    87.000   968.469
    87.500   972.497
    88.000   976.517
    88.500   980.527
    89.000   984.529
    89.500   988.522
    90.000   992.505
    90.500   996.480
    91.000  1000.446
    91.500  1004.403
    92.000  1008.351
    92.500  1012.290
    93.000  1016.219
    93.500  1020.140
    94.000  1024.052
    94.500  1027.955
    95.000  1031.848
    95.500  1035.733
    96.000  1039.609
    96.500  1043.475
    97.000  1047.332
    97.500  1051.181
    98.000  1055.020
    98.500  1058.850
    99.000  1062.671
    99.500  1066.483
   100.000  1070.285
   100.500  1074.079
   101.000  1077.863
   101.500  1081.638
   102.000  1085.404
   102.500  1089.161
   103.000  1092.909
   103.500  1096.648
   104.000  1100.378
   104.500  1104.099
   105.000  1107.811
   105.500  1111.514
   106.000  1115.208
   106.500  1118.893
   107.000  1122.570
   107.500  1126.237
   108.000  1129.895
   108.500  1133.544
   109.000  1137.184
   109.500  1140.815
   110.000  1144.436
   110.500  1148.048
   111.000  1151.651
   111.500  1155.244
   112.000  1158.828
   112.500  1162.404
   113.000  1165.969
   113.500  1169.526
   114.000  1173.074
   114.500  1176.613
   115.000  1180.142
   115.500  1183.662
   116.000  1187.174
   116.500  1190.676
   117.000  1194.170
   117.500  1197.654
   118.000  1201.129
   118.500  1204.595
   119.000  1208.052
   119.500  1211.499
   120.000  1214.938
   120.500  1218.367
   121.000  1221.787
   121.500  1225.198
   122.000  1228.599
   122.500  1231.991
   123.000  1235.375
   123.500  1238.749
   124.000  1242.114
   124.500  1245.470
   125.000  1248.817
   125.500  1252.155
   126.000  1255.484
   126.500  1258.804
   127.000  1262.115
   127.500  1265.417
   128.000  1268.710
   128.500  1271.995
   129.000  1275.270
   129.500  1278.537
   130.000  1281.794
   130.500  1285.042
   131.000  1288.282
   131.500  1291.512
   132.000  1294.734
   132.500  1297.946
   133.000  1301.150
   133.500  1304.344
   134.000  1307.529
   134.500  1310.705
   135.000  1313.872
   135.500  1317.030
   136.000  1320.179
   136.500  1323.319
   137.000  1326.450
   137.500  1329.572
   138.000  1332.684
   138.500  1335.788
   139.000  1338.882
   139.500  1341.967
   140.000  1345.044
   140.500  1348.111
   141.000  1351.169
   141.500  1354.218
   142.000  1357.258
   142.500  1360.289
   143.000  1363.311
   143.500  1366.324
   144.000  1369.328
   144.500  1372.322
   145.000  1375.308
   145.500  1378.284
   146.000  1381.251
   146.500  1384.209
   147.000  1387.157
   147.500  1390.096
   148.000  1393.026
   148.500  1395.946
   149.000  1398.857
   149.500  1401.759
   150.000  1404.651
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.226
   100.500   827.449
   101.000   829.672
   101.500   831.895
   102.000   834.117
   102.500   836.340
   103.000   838.563
   103.500   840.786
   104.000   843.009
   104.500   845.232
   105.000   847.454
   105.500   849.677
   106.000   851.900
   106.500   854.123
   107.000   856.346
   107.500   858.569
   108.000   860.791
   108.500   863.014
   109.000   865.237
   109.500   867.460
   110.000   869.683
   110.500   871.906
   111.000   874.128
   111.500   876.351
   112.000   878.574
   112.500   880.797
   113.000   883.020
   113.500   885.243
   114.000   887.465
   114.500   889.688
   115.000   891.911
   115.500   894.134
   116.000   896.357
   116.500   898.580
   117.000   900.802
   117.500   903.025
   118.000   905.248
   118.500   907.471
   119.000   909.694
   119.500   911.917
   120.000   914.140
   120.500   916.362
   121.000   918.585
   121.500   920.808
   122.000   923.031
   122.500   925.254
   123.000   927.477
   123.500   929.699
   124.000   931.922
   124.500   934.145
   125.000   936.368
   125.500   938.591
   126.000   940.814
   126.500   943.036
   127.000   945.259
   127.500   947.482
   128.000   949.705
   128.500   951.928
   129.000   954.151
   129.500   956.373
   130.000   958.596
   130.500   960.819
   131.000   963.042
   131.500   965.265
   132.000   967.488
   132.500   969.710
   133.000   971.933
   133.500   974.156
   134.000   976.379
   134.500   978.602
   135.000   980.825
   135.500   983.047
   136.000   985.270
   136.500   987.493
   137.000   989.716
   137.500   991.939
   138.000   994.162
   138.500   996.384
   139.000   998.607
   139.500  1000.830
   140.000  1003.053
   140.500  1005.276
   141.000  1007.499
   141.500  1009.721
   142.000  1011.944
   142.500  1014.167
   143.000  1016.390
   143.500  1018.613
   144.000  1020.836
   144.500  1023.058
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.543
    15.000   395.782
    15.500   406.016
    16.000   416.244
    16.500   426.462
    17.000   436.665
    17.500   446.850
    18.000   457.012
    18.500   467.146
    19.000   477.246
    19.500   487.307
    20.000   497.322
    20.500   507.285
    21.000   517.191
    21.500   527.034
    22.000   536.810
    22.500   546.512
    23.000   555.187
    23.500   563.329
    24.000   571.439
    24.500   579.515
    25.000   587.548
    25.500   595.502
    26.000   603.413
    26.500   611.313
    27.000   619.205
    27.500   627.089
    28.000   634.966
    28.500   642.836
    29.000   650.700
    29.500   658.557
    30.000   666.407
    30.500   674.249
    31.000   682.081
    31.500   689.902
    32.000   697.710
    32.500   705.504
    33.000   713.282
    33.500   721.044
    34.000   728.788
    34.500   736.513
    35.000   744.219
    35.500   751.906
    36.000   759.573
    36.500   767.221
    37.000   774.848
    37.500   782.454
    38.000   790.039
    38.500   797.602
    39.000   805.144
    39.500   812.662
    40.000   820.159
    40.500   827.632
    41.000   835.081
    41.500   842.507
    42.000   849.909
    42.500   857.287
    43.000   864.640
    43.500   871.969
    44.000   879.273
    44.500   886.553
    45.000   893.807
    45.500   901.036
    46.000   908.239
    46.500   915.417
    47.000   922.568
    47.500   929.693
    48.000   936.791
    48.500   943.863
    49.000   950.907
    49.500   957.924
    50.000   964.915
    50.500   971.878
    51.000   978.814
    51.500   985.723
    52.000   992.604
    52.500   999.457
    53.000  1006.284
    53.500  1013.084
    54.000  1019.858
    54.500  1026.606
    55.000  1033.328
    55.500  1040.022
    56.000  1046.689
    56.500  1053.328
    57.000  1059.939
    57.500  1066.522
    58.000  1073.077
    58.500  1079.603
    59.000  1086.103
    59.500  1092.574
    60.000  1099.018
    60.500  1105.435
    61.000  1111.823
    61.500  1118.183
    62.000  1124.516
    62.500  1130.819
    63.000  1137.095
    63.500  1143.341
    64.000  1149.560
    64.500  1155.750
    65.000  1161.911
    65.500  1168.045
    66.000  1174.150
    66.500  1180.227
    67.000  1186.276
    67.500  1192.296
    68.000  1198.288
    68.500  1204.251
    69.000  1210.185
    69.500  1216.091
    70.000  1221.968
    70.500  1227.816
    71.000  1233.635
    71.500  1239.426
    72.000  1245.187
    72.500  1250.919
    73.000  1256.621
    73.500  1262.294
    74.000  1267.936
    74.500  1273.548
    75.000  1279.130
    75.500  1284.683
    76.000  1290.207
    76.500  1295.702
    77.000  1301.167
    77.500  1306.601
    78.000  1312.006
    78.500  1317.380
    79.000  1322.724
    79.500  1328.038
    80.000  1333.324
    80.500  1338.580
    81.000  1343.806
    81.500  1349.001
    82.000  1354.163
    82.500  1359.294
    83.000  1364.393
    83.500  1369.460
    84.000  1374.497
    84.500  1379.502
    85.000  1384.477
    85.500  1389.420
    86.000  1394.331
    86.500  1399.211
    87.000  1404.058
    87.500  1408.872
    88.000  1413.654
    88.500  1418.402
    89.000  1423.117
    89.500  1427.799
    90.000  1432.447
    90.500  1437.062
    91.000  1441.642
    91.500  1446.189
    92.000  1450.702
    92.500  1455.181
    93.000  1459.626
    93.500  1464.036
    94.000  1468.421
    94.500  1472.789
    95.000  1477.144
    95.500  1481.488
    96.000  1485.819
    96.500  1490.138
    97.000  1494.440
    97.500  1498.722
    98.000  1502.984
    98.500  1507.226
    99.000  1511.449
    99.500  1515.652
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   720.622
     1.000   720.669
     1.500   720.746
     2.000   720.855
     2.500   720.995
     3.000   721.167
     3.500   721.369
     4.000   721.602
     4.500   721.866
     5.000   722.160
     5.500   722.486
     6.000   722.842
     6.500   723.229
     7.000   723.646
     7.500   724.094
     8.000   724.572
     8.500   725.080
     9.000   725.618
     9.500   726.187
    10.000   726.784
    10.500   727.412
    11.000   728.069
    11.500   728.756
    12.000   729.471
    12.500   730.216
    13.000   730.989
    13.500   731.791
    14.000   732.622
    14.500   733.480
    15.000   734.367
    15.500   735.282
    16.000   736.224
    16.500   737.194
    17.000   738.191
    17.500   739.215
    18.000   740.266
    18.500   741.343
    19.000   742.446
    19.500   743.576
    20.000   744.731
    20.500   745.912
    21.000   747.117
    21.500   748.349
    22.000   749.604
    22.500   750.884
    23.000   752.188
    23.500   753.517
    24.000   754.868
    24.500   756.243
    25.000   757.641
    25.500   759.062
    26.000   760.505
    26.500   761.971
    27.000   763.458
    27.500   764.966
    28.000   766.496
    28.500   768.047
    29.000   769.618
    29.500   771.210
    30.000   772.821
    30.500   774.453
    31.000   776.103
    31.500   777.772
    32.000   779.461
    32.500   781.167
    33.000   782.891
    33.500   784.633
    34.000   786.393
    34.500   788.169
    35.000   789.962
    35.500   791.772
    36.000   793.597
    36.500   795.438
    37.000   797.295
    37.500   799.166
    38.000   801.052
    38.500   802.953
    39.000   804.867
    39.500   806.795
    40.000   808.737
    40.500   810.691
    41.000   812.659
    41.500   814.638
    42.000   816.629
    42.500   818.633
    43.000   820.647
    43.500   822.672
    44.000   824.708
    44.500   826.755
    45.000   828.811
    45.500   830.877
    46.000   832.953
    46.500   835.037
    47.000   837.131
    47.500   839.232
    48.000   841.342
    48.500   843.459
    49.000   845.584
    49.500   847.716
    50.000   849.855
    50.500   852.001
    51.000   854.152
    51.500   856.310
    52.000   858.473
    52.500   860.642
    53.000   862.816
    53.500   864.994
    54.000   867.177
    54.500   869.365
    55.000   871.556
    55.500   873.751
    56.000   875.949
    56.500   878.151
    57.000   880.356
    57.500   882.563
    58.000   884.773
    58.500   886.985
    59.000   889.199
    59.500   891.415
    60.000   893.632
    60.500   895.851
    61.000   898.071
    61.500   900.292
    62.000   902.514
    62.500   904.736
    63.000   906.958
    63.500   909.181
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   932.676
     1.000   932.742
     1.500   932.853
     2.000   933.008
     2.500   933.207
     3.000   933.451
     3.500   933.738
     4.000   934.070
     4.500   934.446
     5.000   934.865
     5.500   935.329
     6.000   935.836
     6.500   936.387
     7.000   936.981
     7.500   937.619
     8.000   938.301
     8.500   939.025
     9.000   939.793
     9.500   940.604
    10.000   941.457
    10.500   942.353
    11.000   943.292
    11.500   944.272
    12.000   945.295
    12.500   946.360
    13.000   947.467
    13.500   948.615
    14.000   949.805
    14.500   951.035
    15.000   952.307
    15.500   953.619
    16.000   954.972
    16.500   956.364
    17.000   957.797
    17.500   959.270
    18.000   960.782
    18.500   962.333
    19.000   963.924
    19.500   965.553
    20.000   967.220
    20.500   968.925
    21.000   970.669
    21.500   972.450
    22.000   974.268
    22.500   976.123
    23.000   978.015
    23.500   979.943
    24.000   981.908
    24.500   983.908
    25.000   985.944
    25.500   988.014
    26.000   990.120
    26.500   992.260
    27.000   994.435
    27.500   996.643
    28.000   998.885
    28.500  1001.160
    29.000  1003.468
    29.500  1005.809
    30.000  1008.182
    30.500  1010.587
    31.000  1013.023
    31.500  1015.491
    32.000  1017.990
    32.500  1020.519
    33.000  1023.079
    33.500  1025.668
    34.000  1028.287
    34.500  1030.935
    35.000  1033.613
    35.500  1036.318
    36.000  1039.052
    36.500  1041.814
    37.000  1044.604
    37.500  1047.421
    38.000  1050.264
    38.500  1053.134
    39.000  1056.031
    39.500  1058.953
    40.000  1061.901
    40.500  1064.874
    41.000  1067.872
    41.500  1070.894
    42.000  1073.941
    42.500  1077.011
    43.000  1080.106
    43.500  1083.223
    44.000  1086.364
    44.500  1089.526
    45.000  1092.712
    45.500  1095.919
    46.000  1099.148
    46.500  1102.398
    47.000  1105.669
    47.500  1108.961
    48.000  1112.274
    48.500  1115.606
    49.000  1118.958
    49.500  1122.330
    50.000  1125.721
    50.500  1129.131
    51.000  1132.559
    51.500  1136.005
    52.000  1139.470
    52.500  1142.953
    53.000  1146.452
    53.500  1149.969
    54.000  1153.503
    54.500  1157.053
    55.000  1160.620
    55.500  1164.202
    56.000  1167.800
    56.500  1171.414
    57.000  1175.043
    57.500  1178.687
    58.000  1182.345
    58.500  1186.018
    59.000  1189.705
    59.500  1193.406
    60.000  1197.120
    60.500  1200.848
    61.000  1204.589
    61.500  1208.342
    62.000  1212.109
    62.500  1215.887
    63.000  1219.678
    63.500  1223.481
    64.000  1227.295
    64.500  1231.121
    65.000  1234.958
    65.500  1238.805
    66.000  1242.664
    66.500  1246.533
    67.000  1250.412
    67.500  1254.302
    68.000  1258.201
    68.500  1262.109
    69.000  1266.028
    69.500  1269.955
    70.000  1273.891
    70.500  1277.836
    71.000  1281.790
    71.500  1285.752
    72.000  1289.722
    72.500  1293.700
    73.000  1297.686
    73.500  1301.679
    74.000  1305.680
    74.500  1309.688
    75.000  1313.703
    75.500  1317.725
    76.000  1321.753
    76.500  1325.788
    77.000  1329.829
    77.500  1333.876
    78.000  1337.930
    78.500  1341.989
    79.000  1346.053
    79.500  1350.123
    80.000  1354.198
    80.500  1358.278
    81.000  1362.363
    81.500  1366.453
    82.000  1370.548
    82.500  1374.647
    83.000  1378.750
    83.500  1382.857
    84.000  1386.969
    84.500  1391.084
    85.000  1395.203
    85.500  1399.325
    86.000  1403.451
    86.500  1407.580
    87.000  1411.712
    87.500  1415.848
    88.000  1419.986
    88.500  1424.127
    89.000  1428.270
    89.500  1432.416
    90.000  1436.564
    90.500  1440.714
    91.000  1444.867
    91.500  1449.021
    92.000  1453.177
    92.500  1457.335
    93.000  1461.495
    93.500  1465.656
    94.000  1469.818
    94.500  1473.982
    95.000  1478.146
    95.500  1482.312
    96.000  1486.479
    96.500  1490.646
    97.000  1494.815
    97.500  1498.984
    98.000  1503.153
    98.500  1507.323
    99.000  1511.493
    99.500  1515.663
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.497
    29.500   783.736
    30.000   793.975
    30.500   804.211
    31.000   814.445
    31.500   824.676
    32.000   834.902
    32.500   845.123
    33.000   855.339
    33.500   865.547
    34.000   875.748
    34.500   885.940
    35.000   896.122
    35.500   906.292
    36.000   916.450
    36.500   926.594
    37.000   936.722
    37.500   946.834
    38.000   956.928
    38.500   966.660
    39.000   977.057
    39.500   987.088
    40.000   997.094
    40.500  1007.075
    41.000  1017.029
    41.500  1026.955
    42.000  1036.850
    42.500  1046.715
    43.000  1056.547
    43.500  1066.344
    44.000  1076.107
    44.500  1085.834
    45.000  1095.523
    45.500  1104.899
    46.000  1113.069
    46.500  1121.222
    47.000  1129.359
    47.500  1137.478
    48.000  1145.582
    48.500  1153.669
    49.000  1161.738
    49.500  1169.787
    50.000  1177.810
    50.500  1185.796
    51.000  1193.726
    51.500  1201.642
    52.000  1209.551
    52.500  1217.455
    53.000  1225.353
    53.500  1233.247
    54.000  1241.136
    54.500  1249.023
    55.000  1256.905
    55.500  1264.784
    56.000  1272.660
    56.500  1280.532
    57.000  1288.402
    57.500  1296.267
    58.000  1304.130
    58.500  1311.989
    59.000  1319.845
    59.500  1327.698
    60.000  1335.546
    60.500  1343.390
    61.000  1351.230
    61.500  1359.066
    62.000  1366.896
    62.500  1374.720
    63.000  1382.538
    63.500  1390.350
    64.000  1398.156
    64.500  1405.954
    65.000  1413.745
    65.500  1421.529
    66.000  1429.304
    66.500  1437.071
    67.000  1444.829
    67.500  1452.578
    68.000  1460.319
    68.500  1468.050
    69.000  1475.772
    69.500  1483.484
    70.000  1491.186
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     5.446    99.750     0.150
     6.391   114.750     0.150
     6.391   170.750     0.150
     6.859   128.750     0.150
    17.142   233.750     0.150
    17.142   539.750     0.150
    18.776   583.750     0.150
    20.366   507.750     0.150
    20.360   498.750     0.150
    20.751   599.352     0.150
    20.751   598.750     0.150
    20.751   656.648     0.150
    20.851    10.000     0.150
    22.171   689.250     0.150
    22.171   688.750     0.150
    22.171   854.551     0.150
    23.066   621.551     0.150
    23.250   325.750     0.150
    23.832   707.852     0.150
    24.694   590.352     0.150
    24.694   832.250     0.150
    25.003   329.750     0.150
    25.003   772.750     0.150
    25.003   329.250     0.150
    25.003   781.051     0.150
    25.151   800.750     0.150
    25.301   797.750     0.150
    25.307   731.148     0.150
    25.632   335.148     0.150
    25.640   785.449     0.150
    25.646   800.750     0.150
    25.646   821.148     0.150
    25.735   598.750     0.150
    25.895   837.250     0.150
    25.927   624.750     0.150
    26.038   724.551     0.150
    26.038   828.852     0.150
    26.044   825.148     0.150
    26.122   853.750     0.150
    26.228   334.750     0.150
    26.228   766.750     0.150
    26.181   844.852     0.150
    26.427   344.852     0.150
    26.427   860.750     0.150
    26.427   981.148     0.150
    26.442   979.051     0.150
    26.331   339.750     0.150
    26.331   339.750     0.150
    26.331   611.750     0.150
    26.894   343.750     0.150
    26.988   859.648     0.150
    26.988   956.250     0.150
    27.140   402.750     0.150
    27.174   857.148     0.150
    27.235   351.051     0.150
    27.235   362.750     0.150
    28.527   353.750     0.150
    28.527   637.750     0.150
    29.777   478.750     0.150
    31.861   567.750     0.150
    35.566   476.750     0.150
    36.410   431.750     0.150
    37.332   953.750     0.150
    38.022   521.750     0.150
    40.450   571.750     0.150
    40.450   456.750     0.150
    40.450   553.750     0.150
    40.450   822.750     0.150
    45.313   497.750     0.150
    45.313   900.750     0.150
    45.981   672.750     0.150
    45.981   503.750     0.150
    45.981   672.750     0.150
    45.981   912.750     0.150
    46.693   513.750     0.150
    46.693  1168.750     0.150
    46.693  1280.750     0.150
    46.693   506.750     0.150
    46.693   911.750     0.150
    46.693  1168.750     0.150
    47.753   944.750     0.150
    50.182   967.750     0.150
    50.579   537.750     0.150
    50.579     8.000     0.150
    50.579   656.750     0.150
    50.579   973.750     0.150
    51.567   554.750     0.150
    53.092   741.750     0.150
    54.284   995.750     0.150
    54.490   987.750     0.150
    54.580   776.750     0.150
    54.580   990.750     0.150
    54.778  1494.750     0.150
    54.790  1253.750     0.150
    55.666   583.750     0.150
    55.666   756.750     0.150
    55.846   764.750     0.150
    55.841   582.750     0.150
    55.841  1063.750     0.150
    55.841  1706.750     0.150
    55.871   572.750     0.150
    57.536   563.750     0.150
    57.727   628.750     0.150
    58.330   594.750     0.150
    58.330  1137.750     0.150
    58.768   631.750     0.150
    58.897   598.750     0.150
    58.897  1066.750     0.150
    59.301   606.750     0.150
    59.714   610.750     0.150
    59.714   602.750     0.150
    59.714  1092.750     0.150
    60.558   615.750     0.150
    60.800  1407.750     0.150
    60.961   627.750     0.150
    60.961  1140.750     0.150
    60.961  1367.750     0.150
    61.731   616.750     0.150
    61.731   666.750     0.150
    61.832   624.750     0.150
    63.253  1127.750     0.150
    65.732   653.750     0.150
    66.373   657.750     0.150
    70.762   682.750     0.150
    70.983  1243.750     0.150
    73.591   867.750     0.150
    76.090   732.750     0.150
    77.798   723.750     0.150
    78.807   729.750     0.150
    79.946   791.750     0.150
    80.218  2224.750     0.150
    83.219   752.750     0.150
    83.277   754.750     0.150
    83.822   753.750     0.150
    84.181   759.750     0.150
    88.956   983.750     0.150
     6.521   101.375     0.150
    20.184   485.375     0.150
    32.838   389.375     0.150
    34.347   403.773     0.150
    37.506   507.375     0.150
    38.678     2.703     0.150
    39.630   554.375     0.150
    40.652   471.375     0.150
    41.319   470.375     0.150
    43.029   594.375     0.150
    43.029   869.375     0.150
    43.029  1051.375     0.150
    45.036   498.375     0.150
    49.567   529.078     0.150
    51.084   548.375     0.150
    57.124   728.375     0.150
    57.148  4059.375     0.150
    60.955   611.578     0.150
    61.473   615.078     0.150
    61.473   684.375     0.150
    61.923   617.875     0.150
    71.339   692.375     0.150
    71.736   681.875     0.150
    71.736   713.375     0.150
    75.743   724.375     0.150
    76.305     4.203     0.150
    78.183   715.875     0.150
    79.955   720.375     0.150
    11.174   155.477     0.150
    17.405   235.477     0.150
    17.405   416.477     0.150
    17.405   240.477     0.150
    18.332   262.477     0.150
    21.071   289.477     0.150
    21.287   287.477     0.150
    26.990   342.477     0.150
    27.136   344.477     0.150
    27.657   346.477     0.150
    27.657  1144.477     0.150
    27.657  1144.477     0.150
    27.657  1144.477     0.150
    32.433   397.477     0.150
    33.001   393.477     0.150
    33.149   396.477     0.150
    36.496   429.477     0.150
    36.554   431.078     0.150
    37.472   437.477     0.150
    37.472   460.477     0.150
    37.472   499.477     0.150
    37.472   535.477     0.150
    37.552   438.477     0.150
    38.591   445.477     0.150
    39.373   453.477     0.150
    39.373   453.477     0.150
    39.716   454.477     0.150
    39.716   482.477     0.150
    39.716   529.477     0.150
    39.716   625.477     0.150
    40.045   460.078     0.150
    40.839   460.477     0.150
    42.499   478.477     0.150
    42.674   479.180     0.150
    42.814   856.477     0.150
    42.814  1052.477     0.150
    43.732   492.273     0.150
    44.387   490.477     0.150
    44.387   879.477     0.150
    45.092   495.477     0.150
    46.023   507.375     0.150
    49.227   534.477     0.150
    49.645   535.477     0.150
    49.752   542.273     0.150
    49.774   532.477     0.150
    51.163   540.477     0.150
    51.419   543.477     0.150
    51.535   549.477     0.150
    51.535   584.477     0.150
    51.535   703.477     0.150
    51.798   555.477     0.150
    51.798   568.477     0.150
    53.757   567.477     0.150
    53.757   673.477     0.150
    53.757   747.477     0.150
    54.026   628.477     0.150
    54.657   571.477     0.150
    54.841   575.477     0.150
    55.717   582.477     0.150
    56.832   575.477     0.150
    57.259   600.477     0.150
    61.027   616.375     0.150
    63.843   635.477     0.150
    68.307   649.477     0.150
    69.612   665.477     0.150
    72.560   692.477     0.150
    72.560   713.477     0.150
    75.907   839.477     0.150
    76.598   750.477     0.150
    76.598   821.477     0.150
    77.087   754.477     0.150
    77.074   737.477     0.150
    78.007   722.977     0.150
    78.007   747.477     0.150
    82.515   733.680     0.150
     2.141    34.789     0.150
     2.141    63.789     0.150
     5.812    83.891     0.150
     5.812   148.891     0.150
     5.812   182.789     0.150
     7.622   109.988     0.150
     7.707   207.988     0.150
     7.707   207.988     0.150
    10.989   152.090     0.150
    10.989   268.590     0.150
    10.989   221.188     0.150
    10.989   268.590     0.150
    21.252   289.789     0.150
    25.314   326.789     0.150
    25.429   851.688     0.150
    26.551   618.789     0.150
    26.551   618.789     0.150
    26.551   618.789     0.150
    27.111   342.789     0.150
    27.327   344.789     0.150
    27.652   346.789     0.150
    29.335   360.789     0.150
    29.335   655.789     0.150
    31.049   377.789     0.150
    32.115   386.789     0.150
    32.567   390.789     0.150
    32.803   391.789     0.150
    37.357    17.801     0.150
    38.487     9.000     0.150
    40.015   454.988     0.150
    40.015   454.988     0.150
    40.158   458.891     0.150
    45.131   493.789     0.150
    45.182   499.789     0.150
    45.939   499.789     0.150
    51.755    13.000     0.150
    51.800   731.789     0.150
    53.021   561.789     0.150
    53.021    13.000     0.150
    53.021    23.000     0.150
    53.021   633.789     0.150
    53.693   585.789     0.150
    53.693   705.789     0.150
    53.693   802.789     0.150
    54.747    14.000     0.150
    54.747    26.000     0.150
    56.366   581.391     0.150
    56.955   592.789     0.150
    58.128   598.789     0.150
    60.960   611.391     0.150
    64.928   640.789     0.150
    70.541   673.789     0.150
    70.541   673.789     0.150
    73.312   694.789     0.150
    77.004   741.289     0.150
    79.885   725.188     0.150
    83.671   752.789     0.150
    85.400   759.789     0.150
   137.884  1153.789     0.150
   156.766  1197.891     0.150
     2.074    32.531     0.150
     4.214    66.930     0.150
     5.909    89.031     0.150
     7.708   109.430     0.150
     7.708   109.430     0.150
     7.815   111.531     0.150
     7.815   197.531     0.150
    10.895   151.633     0.150
    15.065   207.031     0.150
    20.704   278.531     0.150
    20.704   511.531     0.150
    24.522    21.930     0.150
    27.236   340.531     0.150
    27.450   232.531     0.150
    27.450   422.531     0.150
    27.777   350.531     0.150
    27.777   350.531     0.150
    29.379   358.531     0.150
    31.177   376.531     0.150
    32.240   385.531     0.150
    32.689   390.531     0.150
    32.724   389.531     0.150
    33.395   395.531     0.150
    36.108   417.531     0.150
    37.439     4.797     0.150
    40.005   453.531     0.150
    40.446   537.230     0.150
    40.568   454.531     0.150
    40.880   457.531     0.150
    44.466   485.531     0.150
    45.061   529.332     0.150
    46.037     6.297     0.150
    47.956   520.832     0.150
    51.498   539.531     0.150
    54.089    19.500     0.150
    54.089   697.531     0.150
    54.860   616.531     0.150
    54.860   717.531     0.150
    56.321   577.332     0.150
    59.539   608.531     0.150
    62.219   617.531     0.150
    83.611   747.230     0.150
    85.359   753.930     0.150
    85.359   753.930     0.150
   113.879    68.430     0.150
     0.478     8.703     0.150
     0.478    15.404     0.150
     2.812    44.305     0.150
     3.643    64.404     0.150
     3.643    64.404     0.150
     3.643   114.504     0.150
     3.980    61.004     0.150
     5.272   141.004     0.150
     6.367    91.404     0.150
     6.367    91.404     0.150
     6.367   164.404     0.150
     7.234   106.004     0.150
     7.234   186.004     0.150
    14.791   207.203     0.150
    21.279   286.703     0.150
    21.279   286.703     0.150
    21.263   295.004     0.150
    21.976   294.504     0.150
    26.267   329.004     0.150
    26.267   617.004     0.150
    26.804   346.703     0.150
    26.804   346.703     0.150
    26.804   346.703     0.150
    27.792   351.004     0.150
    27.792   351.004     0.150
    29.007   364.004     0.150
    29.007   364.004     0.150
    29.970   367.805     0.150
    29.970   367.805     0.150
    33.187   401.604     0.150
    33.187   401.604     0.150
    43.009   477.004     0.150
    43.109   478.004     0.150
    45.122   501.004     0.150
    45.122   501.004     0.150
    46.334   503.004     0.150
    47.692   515.504     0.150
    47.692   515.504     0.150
    52.560   557.004     0.150
    52.560    13.000     0.150
    53.921   568.104     0.150
    54.024   568.004     0.150
    55.110   575.504     0.150
    55.110   575.504     0.150
    84.351    12.000     0.150
     0.036     2.812     0.150
     0.036     5.016     0.150
     1.413    42.516     0.150
     2.229    65.914     0.150
     4.190    75.414     0.150
     4.190   113.414     0.150
     4.190    63.414     0.150
     4.190   112.609     0.150
     4.190    63.414     0.150
     4.190   113.414     0.150
     4.297   125.312     0.150
     6.645   104.312     0.150
     6.645   191.312     0.150
     6.718   210.609     0.150
     7.802   244.711     0.150
     7.802   244.711     0.150
     8.473   219.211     0.150
     8.658   270.711     0.150
     8.773   273.312     0.150
    15.916   225.609     0.150
    15.916   225.609     0.150
    16.714   227.812     0.150
    16.714   227.711     0.150
    17.298   232.312     0.150
    17.298   232.312     0.150
    20.504   282.609     0.150
    20.527   283.312     0.150
    20.527   283.312     0.150
    32.012   388.312     0.150
    38.943   452.312     0.150
    41.420   469.812     0.150
    43.318   490.516     0.150
    43.796   488.312     0.150
    46.051   504.312     0.150
    47.701   503.711     0.150
    48.081   503.711     0.150
    55.402   558.312     0.150
    55.789   581.312     0.150
    65.624   647.312     0.150
    69.860   676.109     0.150
    76.211   713.109     0.150
     1.380    41.473     0.150
     1.380    25.070     0.150
     1.380    40.871     0.150
     1.380    25.070     0.150
     1.380    41.473     0.150
     1.443    44.070     0.150
     1.512    28.871     0.150
     1.512    46.871     0.150
     1.512    28.871     0.150
     1.512    46.973     0.150
     3.135    61.473     0.150
     3.135    91.973     0.150
     3.135   101.270     0.150
     4.132    62.172     0.150
     4.132    62.172     0.150
     4.132   125.672     0.150
     4.321   137.871     0.150
     4.321    64.871     0.150
     4.321   137.871     0.150
     5.503   100.172     0.150
     6.794   116.871     0.150
     6.794   122.973     0.150
     6.794   116.871     0.150
     6.794   122.871     0.150
     6.794   211.871     0.150
     7.879   142.973     0.150
     8.546   128.270     0.150
     8.546   217.473     0.150
     8.546   264.172     0.150
     8.546   128.270     0.150
     8.546   157.270     0.150
     8.546   217.473     0.150
     8.546   264.172     0.150
     8.736   117.871     0.150
     8.736   269.871     0.150
     8.736   126.871     0.150
     8.736   269.871     0.150
    14.663   204.871     0.150
    15.907   231.871     0.150
    15.990   223.672     0.150
    16.668   228.371     0.150
    16.668   228.371     0.150
    16.668   228.371     0.150
    16.668   228.371     0.150
    17.126   420.871     0.150
    17.126   237.871     0.150
    17.126   420.871     0.150
    17.314   234.770     0.150
    17.314   234.770     0.150
    17.314   438.871     0.150
    20.579   285.371     0.150
    21.291   291.871     0.150
    22.519   303.871     0.150
    44.327   505.871     0.150
    46.118   509.871     0.150
    46.118   509.871     0.150
     0.609     8.415     0.150
     0.609    16.815     0.150
     0.609     8.415     0.150
     0.609    16.815     0.150
     1.196    22.715     0.150
     1.196    24.815     0.150
     2.889    44.815     0.150
     3.509    54.315     0.150
     3.509    63.315     0.150
     3.509   108.815     0.150
     3.949    61.215     0.150
     3.949   118.315     0.150
     4.335    67.815     0.150
     4.335   132.815     0.150
     5.253    78.515     0.150
     5.253    93.215     0.150
     5.253   162.115     0.150
     5.632   102.815     0.150
     6.359    92.815     0.150
     6.359   194.815     0.150
     6.988   127.815     0.150
     6.988   219.815     0.150
     6.988   102.815     0.150
     6.988   127.815     0.150
     6.988   219.815     0.150
     7.232   116.615     0.150
     7.232   106.815     0.150
     7.232   185.815     0.150
     7.232   221.815     0.150
    11.605   168.815     0.150
    11.605   168.815     0.150
    14.854   207.115     0.150
    15.586   224.815     0.150
    16.137   412.115     0.150
    16.137   226.615     0.150
    16.137   412.115     0.150
    17.655   242.015     0.150
    17.655   441.815     0.150
    17.655   242.015     0.150
    18.006   245.315     0.150
    18.006   453.815     0.150
    18.006   453.815     0.150
    18.006   453.815     0.150
    18.006   245.315     0.150
    18.006   453.815     0.150
    19.378   470.415     0.150
    21.185   293.515     0.150
    21.185   293.515     0.150
    22.002   295.515     0.150
    25.158   344.815     0.150
    25.158   609.515     0.150
    27.895   354.815     0.150
    27.895   354.815     0.150
    33.224   388.815     0.150
    39.076   447.715     0.150
    45.204   499.815     0.150
    77.435   704.815     0.150
   143.678  1170.315     0.150
   143.678  1170.315     0.150
     1.009    29.941     0.150
     1.009    17.840     0.150
     1.009    29.941     0.150
     1.937    33.742     0.150
     1.937    57.840     0.150
     2.165    36.742     0.150
     2.165    39.242     0.150
     2.165    65.141     0.150
     2.495    41.641     0.150
     2.495    45.441     0.150
     2.477    41.941     0.150
     2.477    48.441     0.150
     2.477    74.840     0.150
     3.738    56.941     0.150
     3.738    67.641     0.150
     3.738   102.340     0.150
     3.738   115.242     0.150
     4.224    63.941     0.150
     4.224    75.840     0.150
     4.224   132.039     0.150
     6.053   177.641     0.150
     6.208   103.641     0.150
     6.208   167.141     0.150
     6.208   103.641     0.150
     6.208   111.641     0.150
     6.208   167.141     0.150
     6.208   193.641     0.150
     7.921   118.840     0.150
     7.921   206.641     0.150
     7.921   247.141     0.150
     7.921   118.840     0.150
     7.921   206.641     0.150
     7.921   247.141     0.150
     8.189   214.742     0.150
     8.189   119.141     0.150
     8.189   214.742     0.150
    16.281   244.641     0.150
    16.902   417.941     0.150
    17.334   236.641     0.150
    17.334   236.641     0.150
    17.675   244.242     0.150
    17.675   432.641     0.150
    17.675   244.242     0.150
    17.675   432.641     0.150
    20.241   278.641     0.150
    20.241     4.000     0.150
    20.241     6.301     0.150
    20.330   277.641     0.150
    20.330     5.000     0.150
    20.330   538.641     0.150
    20.438   284.641     0.150
    20.438   284.641     0.150
    20.617   648.141     0.150
    21.057   285.641     0.150
    21.876   297.641     0.150
    28.491   359.340     0.150
    28.491   415.941     0.150
    45.941   502.840     0.150
    53.142   574.641     0.150
    54.422   565.039     0.150
    55.595   583.641     0.150
    55.595   583.641     0.150
    55.861   578.039     0.150
     0.545    10.680     0.150
     0.545    17.781     0.150
     1.419    25.883     0.150
     1.419    44.781     0.150
     1.520    34.781     0.150
     2.246    70.078     0.150
     3.713    69.383     0.150
     3.713    87.383     0.150
     3.713    94.781     0.150
     3.707    57.180     0.150
     3.707    61.281     0.150
     3.707    66.180     0.150
     3.707    68.281     0.150
     3.707    76.578     0.150
     3.707    57.180     0.150
     3.707    66.180     0.150
     3.707   114.984     0.150
     4.392    73.578     0.150
     4.392    85.781     0.150
     4.392   109.281     0.150
     4.713    82.281     0.150
     4.713    70.781     0.150
     4.713    74.281     0.150
     4.713    70.781     0.150
     4.713    82.281     0.150
     4.713   122.781     0.150
     4.713   148.281     0.150
     4.781    95.281     0.150
     4.781   158.281     0.150
     4.781   170.383     0.150
     5.690   103.383     0.150
     5.690    82.781     0.150
     5.690    91.781     0.150
     5.690   103.781     0.150
     5.690   139.984     0.150
     5.690   159.078     0.150
     5.690   176.781     0.150
     5.690   176.781     0.150
     5.690    82.781     0.150
     5.690   103.383     0.150
     5.690   176.781     0.150
     5.920    84.984     0.150
     5.920    93.281     0.150
     5.920   105.078     0.150
     5.920   109.281     0.150
     5.920   116.781     0.150
     5.920   187.281     0.150
     6.351   102.781     0.150
     6.788   127.281     0.150
     6.788    98.984     0.150
     6.788   107.578     0.150
     6.788   127.281     0.150
     6.788    98.984     0.150
     6.788   127.281     0.150
     7.433   109.281     0.150
     7.433   113.078     0.150
     7.433   142.984     0.150
     7.433   208.781     0.150
     7.433   136.781     0.150
     7.433   229.281     0.150
     7.656   142.781     0.150
     7.656   238.578     0.150
     7.656   121.281     0.150
     7.656   129.781     0.150
     7.656   237.383     0.150
     7.656   112.680     0.150
     7.656   142.781     0.150
     7.656   195.984     0.150
     7.656   238.578     0.150
     7.818   120.383     0.150
     7.818   132.781     0.150
     7.818   243.281     0.150
    11.159   154.781     0.150
    11.159   154.781     0.150
    11.159   277.781     0.150
    16.398   231.781     0.150
    17.528   235.781     0.150
    17.528   235.781     0.150
    17.612   237.781     0.150
    17.612   237.781     0.150
    21.560   276.781     0.150
    21.560   277.078     0.150
    25.499   327.781     0.150
    48.126   519.578     0.150
     5.603   100.232     0.150
     5.603   100.232     0.150
     5.603   118.932     0.150
     6.501   113.232     0.150
     6.501   113.232     0.150
     8.445   119.232     0.150
    14.507   215.332     0.150
    14.682   199.232     0.150
    15.891   222.232     0.150
    16.271   221.732     0.150
    17.329   234.732     0.150
    17.329   417.232     0.150
    17.329   234.732     0.150
    17.329   417.232     0.150
    18.938   256.832     0.150
    20.066   272.732     0.150
    20.472   284.232     0.150
    20.472   284.633     0.150
    22.320   298.232     0.150
    24.450   313.633     0.150
    25.634   325.232     0.150
    25.707   664.232     0.150
    25.707   846.232     0.150
    26.106   339.232     0.150
    26.106   339.232     0.150
    26.219   340.232     0.150
    26.219   619.232     0.150
    26.229   340.232     0.150
    26.229   619.232     0.150
    26.354   343.732     0.150
    26.354   343.732     0.150
    27.917   356.232     0.150
    27.917   356.232     0.150
    28.379   359.232     0.150
    28.379   359.232     0.150
    28.379   398.232     0.150
    29.503   363.232     0.150
    29.503   363.232     0.150
    31.861   390.232     0.150
    31.861   390.232     0.150
    32.918   399.232     0.150
    33.361   403.533     0.150
    33.361   403.533     0.150
    37.775   426.232     0.150
    38.946   445.232     0.150
    40.418   464.033     0.150
    40.418   464.033     0.150
    45.131   492.232     0.150
    45.131    10.000     0.150
    46.467   507.633     0.150
    52.498   541.232     0.150
    54.281   657.232     0.150
    55.362   572.232     0.150
    61.406   622.633     0.150
    77.917   711.832     0.150
    77.919   712.033     0.150
   145.989  1172.732     0.150
     0.558     9.898     0.150
     0.946    17.000     0.150
     0.946    34.000     0.150
     1.926    33.195     0.150
     2.218    35.695     0.150
     2.218    74.000     0.150
     2.421    37.898     0.150
     2.421    38.602     0.150
     2.854    45.398     0.150
     3.322    51.898     0.150
     5.621   104.195     0.150
     5.621   151.898     0.150
     6.965   124.898     0.150
     6.965   167.898     0.150
     6.965   101.898     0.150
     6.965   124.898     0.150
     6.965   180.898     0.150
     6.965   217.898     0.150
     8.599   272.398     0.150
    10.105   140.898     0.150
    10.105   140.898     0.150
    13.747   192.102     0.150
    13.747   192.102     0.150
    13.747   192.102     0.150
    14.599   205.398     0.150
    14.599   205.398     0.150
    15.333   459.898     0.150
    15.635   219.398     0.150
    15.635   219.398     0.150
    16.785   231.898     0.150
    16.785   422.898     0.150
    16.785   231.898     0.150
    16.785   422.898     0.150
    17.183   233.898     0.150
    17.183   233.898     0.150
    17.981   541.898     0.150
    18.221   244.000     0.150
    18.221   244.000     0.150
    18.221   449.898     0.150
    18.976   599.398     0.150
    18.976   626.898     0.150
    19.499   271.398     0.150
    19.527   273.898     0.150
    19.527   274.695     0.150
    19.574   487.898     0.150
    20.879   630.898     0.150
    20.879   670.898     0.150
    21.151    10.500     0.150
    21.151    10.000     0.150
    21.151   522.195     0.150
    21.943   711.898     0.150
    23.762     5.398     0.150
    23.762     9.398     0.150
    24.946   317.898     0.150
    24.966     4.000     0.150
    25.075     5.000     0.150
    25.512   331.898     0.150
    25.619   329.695     0.150
    26.766   341.898     0.150
    28.634   356.898     0.150
    29.364   426.898     0.150
    29.364   541.195     0.150
    29.364   763.898     0.150
    29.709   370.695     0.150
    30.578   372.898     0.150
    30.578     6.000     0.150
    32.088   387.102     0.150
    32.088   467.898     0.150
    32.088   693.898     0.150
    32.614   390.898     0.150
    34.025   403.898     0.150
    34.025   726.898     0.150
    35.022   508.898     0.150
    35.022   747.695     0.150
    39.393   454.398     0.150
    41.266   463.898     0.150
    41.266   583.898     0.150
    41.266   837.898     0.150
    41.266   853.898     0.150
    41.615   857.898     0.150
    42.011   913.195     0.150
    42.114   578.898     0.150
    42.114   855.898     0.150
    42.114   470.898     0.150
    42.114     7.000     0.150
    42.114   578.898     0.150
    42.114   855.898     0.150
    42.114  1037.898     0.150
    42.348   473.898     0.150
    42.348   613.898     0.150
    44.022   487.602     0.150
    44.558   492.898     0.150
    44.741   494.898     0.150
    44.741   906.898     0.150
    45.561   499.898     0.150
    46.049   502.898     0.150
    46.165   504.102     0.150
    46.165   653.898     0.150
    46.165   919.898     0.150
    46.165   927.898     0.150
    46.545   506.898     0.150
    46.545   928.898     0.150
    46.809   510.898     0.150
    47.386   514.898     0.150
    47.386   929.898     0.150
    47.667   516.898     0.150
    48.071   507.898     0.150
    48.071   939.898     0.150
    48.071   507.898     0.150
    48.071   939.898     0.150
    48.743   523.102     0.150
    51.013   969.898     0.150
    51.013   539.898     0.150
    51.013     8.000     0.150
    51.013   969.898     0.150
    53.038    14.797     0.150
    53.038   555.898     0.150
    53.038     6.602     0.150
    53.038    14.797     0.150
    53.121   556.797     0.150
    53.121     7.000     0.150
    53.121  1015.898     0.150
    55.188   572.297     0.150
    55.188   632.898     0.150
    55.269   783.898     0.150
    55.269   571.898     0.150
    55.269   695.898     0.150
    55.269   783.898     0.150
    55.269  1645.898     0.150
    55.269   571.898     0.150
    56.128   577.898     0.150
    56.350   580.602     0.150
    56.350   587.898     0.150
    56.350  1060.898     0.150
    56.350  1330.898     0.150
    56.350   580.602     0.150
    56.350  1060.898     0.150
    57.295   587.398     0.150
    57.295     7.000     0.150
    58.283     0.305     0.150
    58.283     7.500     0.150
    58.283   594.797     0.150
    58.283     7.500     0.150
    58.291   593.500     0.150
    58.598   596.398     0.150
    58.598     6.500     0.150
    58.899     7.406     0.150
    58.899   719.898     0.150
    58.899   598.695     0.150
    58.899     7.406     0.150
    58.899   642.797     0.150
    67.732   657.898     0.150
    80.679   732.195     0.150
    81.767   743.898     0.150
   140.662  1160.898     0.150
   140.925  1157.898     0.150
   144.939  1174.898     0.150
   145.444  1175.898     0.150
     0.397    -2.203     0.150
     0.465    37.500     0.150
     0.465     9.000     0.150
     0.592    11.898     0.150
     0.737    13.898     0.150
     0.737    24.000     0.150
     0.876    26.500     0.150
     0.876    15.898     0.150
     0.876    26.500     0.150
     1.810    31.398     0.150
     1.810    54.398     0.150
     1.824    30.797     0.150
     1.824    35.398     0.150
     4.166    63.297     0.150
     4.166    74.898     0.150
     4.166   130.695     0.150
     4.497    80.398     0.150
     4.497   119.898     0.150
     4.497    67.398     0.150
     4.497    80.398     0.150
     4.497   119.898     0.150
     4.497   140.898     0.150
     6.300    95.898     0.150
     6.300    96.102     0.150
     6.458   117.297     0.150
     6.458   202.695     0.150
     7.379   106.898     0.150
     7.379   135.102     0.150
     8.068   121.297     0.150
     8.068   121.398     0.150
     8.068   249.898     0.150
     8.233   214.898     0.150
    10.523   147.398     0.150
    10.523   259.398     0.150
    15.522   223.398     0.150
    16.282   522.398     0.150
    17.239   232.898     0.150
    17.239   433.898     0.150
    17.239   232.898     0.150
    17.239   433.898     0.150
    18.443   261.000     0.150
    18.443   475.898     0.150
    18.443   565.898     0.150
    18.794   592.898     0.150
    20.167   280.000     0.150
    20.685   279.898     0.150
    26.002   336.102     0.150
    28.182   362.898     0.150
    28.182   405.398     0.150
    28.182   362.898     0.150
    28.182   405.398     0.150
    43.855   484.500     0.150
    44.649   493.398     0.150
    44.649   888.195     0.150
    44.758   492.695     0.150
    54.125   563.102     0.150
    54.125   563.102     0.150
    55.207   571.695     0.150
    55.207   571.695     0.150
    55.482     0.203     0.150
    55.640   580.898     0.150
    59.449   600.195     0.150
    77.975   716.695     0.150
    79.205   724.695     0.150
    83.342   746.102     0.150
   140.455  1162.898     0.150
     0.734    22.016     0.150
     0.743    15.115     0.150
     0.743    15.115     0.150
     0.750    15.115     0.150
     1.791    30.016     0.150
     1.791    30.016     0.150
     1.791    30.016     0.150
     1.791    30.016     0.150
     1.791    30.615     0.150
     1.791    30.615     0.150
     2.193    36.916     0.150
     2.193    36.916     0.150
     2.193    37.115     0.150
     2.298    38.115     0.150
     2.298    38.115     0.150
     2.870    45.615     0.150
     3.470    54.215     0.150
     3.470    98.516     0.150
     3.470   110.916     0.150
     3.470    54.115     0.150
     3.595    57.215     0.150
     3.595    57.215     0.150
     3.595    57.215     0.150
     4.099    62.615     0.150
     4.099    62.615     0.150
     4.099    74.516     0.150
     4.726    77.615     0.150
     4.726    85.215     0.150
     5.852    91.215     0.150
     5.852   107.215     0.150
     5.852   111.916     0.150
     6.174    96.115     0.150
     6.174   105.615     0.150
     6.174   113.115     0.150
     6.513    98.416     0.150
     6.513   116.115     0.150
     7.178   126.115     0.150
     7.178   181.115     0.150
     7.178   223.115     0.150
     7.178   105.615     0.150
     7.178   114.016     0.150
     7.178   135.314     0.150
     7.178   188.115     0.150
     7.178   105.615     0.150
     7.178   126.115     0.150
     7.178   181.115     0.150
     7.178   223.115     0.150
     7.828   125.115     0.150
     7.828   134.115     0.150
     7.828   242.215     0.150
     7.828   113.916     0.150
     7.828   125.115     0.150
     7.828   134.115     0.150
     7.828   200.516     0.150
     7.828   242.215     0.150
     8.294   126.416     0.150
     8.294   149.916     0.150
     8.294   257.115     0.150
     9.170   138.115     0.150
     9.170   163.215     0.150
     9.170   253.115     0.150
     9.345   137.115     0.150
     9.345   149.314     0.150
     9.345   188.416     0.150
     9.438   243.215     0.150
     9.783   135.615     0.150
     9.783   135.615     0.150
    14.094   198.115     0.150
    14.094   198.115     0.150
    14.094   198.115     0.150
    14.094   198.115     0.150
    14.883   212.416     0.150
    14.883   212.416     0.150
    15.357   217.115     0.150
    15.395     6.000     0.150
    15.395     9.301     0.150
    15.395   385.115     0.150
    15.395   398.115     0.150
    16.068   225.615     0.150
    16.068   225.615     0.150
    16.068   225.615     0.150
    17.765   245.115     0.150
    17.765   441.115     0.150
    17.792   249.916     0.150
    17.792     9.199     0.150
    17.792   447.115     0.150
    18.417   257.215     0.150
    18.417   573.115     0.150
    19.337   265.115     0.150
    19.337   647.115     0.150
    19.930   273.916     0.150
    19.930   523.115     0.150
    21.058   285.115     0.150
    21.058     6.500     0.150
    21.058    17.000     0.150
    21.283   286.916     0.150
    21.283     6.199     0.150
    21.283     9.699     0.150
    21.283   525.115     0.150
    22.373   297.615     0.150
    22.373     7.000     0.150
    22.373   547.115     0.150
    22.373   697.115     0.150
    24.189     7.000     0.150
    24.189    13.000     0.150
    24.189   577.115     0.150
    25.213   611.895     0.150
    25.213   322.115     0.150
    25.213   590.115     0.150
    25.399   327.115     0.150
    25.386   327.115     0.150
    25.386     7.500     0.150
    25.386   372.615     0.150
    25.546   328.115     0.150
    25.546   595.115     0.150
    25.511     6.400     0.150
    26.035   615.135     0.150
    27.160   344.615     0.150
    28.731   358.115     0.150
    28.731     6.000     0.150
    28.731   646.115     0.150
    29.202   361.115     0.150
    30.136   370.115     0.150
    30.136   429.115     0.150
    30.282   372.516     0.150
    30.282   450.115     0.150
    30.414     9.000     0.150
    30.414   453.115     0.150
    30.414   371.115     0.150
    30.414     9.000     0.150
    30.414   436.115     0.150
    30.414   453.115     0.150
    32.102   387.115     0.150
    32.102   689.115     0.150
    35.922   420.984     0.150
    36.551   761.416     0.150
    37.149   774.545     0.150
    39.875   453.295     0.150
    39.875     2.631     0.150
    40.525   452.115     0.150
    41.045   584.115     0.150
    41.045   463.115     0.150
    41.045   556.115     0.150
    41.045   584.115     0.150
    41.045   833.115     0.150
    41.128   588.115     0.150
    41.128  1065.115     0.150
    41.128   466.115     0.150
    41.128   565.615     0.150
    41.128   588.115     0.150
    41.128   840.115     0.150
    41.128  1015.115     0.150
    41.128  1065.115     0.150
    41.895   469.115     0.150
    41.895     6.500     0.150
    41.895   845.115     0.150
    41.895  1029.115     0.150
    42.075   593.115     0.150
    42.075   471.615     0.150
    42.075   575.115     0.150
    42.075   593.115     0.150
    42.075   848.115     0.150
    42.161  1321.115     0.150
    42.399   473.016     0.150
    43.540   481.115     0.150
    43.540   869.615     0.150
    44.176   488.416     0.150
    45.458   499.115     0.150
    45.458   901.115     0.150
    45.710   915.516     0.150
    45.710   501.215     0.150
    45.710   610.814     0.150
    45.710   906.115     0.150
    45.710   915.516     0.150
    46.089   660.916     0.150
    46.089   770.916     0.150
    46.089  1133.916     0.150
    46.303   913.115     0.150
    46.303   915.115     0.150
    46.303   506.115     0.150
    46.303   601.115     0.150
    46.303   913.115     0.150
    46.303   915.115     0.150
    46.303  1100.115     0.150
    47.132   511.516     0.150
    47.132   514.115     0.150
    47.222    12.000     0.150
    47.222   565.615     0.150
    47.222   610.615     0.150
    47.222   616.115     0.150
    47.222   939.115     0.150
    47.935   505.115     0.150
    47.935   505.115     0.150
    47.935   633.115     0.150
    47.935   935.115     0.150
    48.887     1.330     0.150
    49.994    17.000     0.150
    50.252     1.740     0.150
    50.824   715.115     0.150
    50.824   965.115     0.150
    50.824   539.615     0.150
    50.824   715.115     0.150
    50.824   965.115     0.150
    51.107     1.619     0.150
    51.167   545.115     0.150
    51.167   668.115     0.150
    51.167   983.115     0.150
    51.167   545.115     0.150
    51.167   668.115     0.150
    51.167   983.115     0.150
    51.167  1199.115     0.150
    51.440   540.215     0.150
    51.525   548.936     0.150
    51.525     1.549     0.150
    52.813   555.115     0.150
    52.813   624.516     0.150
    53.842   593.615     0.150
    54.920   569.926     0.150
    54.997   570.115     0.150
    54.997   570.115     0.150
    54.997   573.215     0.150
    54.997   577.314     0.150
    54.997   586.115     0.150
    54.997  1009.115     0.150
    55.318   573.314     0.150
    55.318     7.000     0.150
    55.318  1040.115     0.150
    55.512  2293.115     0.150
    55.725   575.115     0.150
    55.725   573.814     0.150
    55.725  2378.514     0.150
    56.076    17.100     0.150
    56.076   577.916     0.150
    56.076   586.016     0.150
    56.076   595.016     0.150
    56.076   577.916     0.150
    56.076     8.100     0.150
    56.377   671.115     0.150
    56.377   732.115     0.150
    56.377   789.615     0.150
    56.377   580.115     0.150
    56.377     7.500     0.150
    56.377   789.615     0.150
    56.538   585.814     0.150
    56.538   611.516     0.150
    56.538   616.615     0.150
    56.538  2373.014     0.150
    56.594   578.795     0.150
    56.962    16.699     0.150
    56.999   652.115     0.150
    57.984   588.154     0.150
    58.032     7.400     0.150
    58.032   623.814     0.150
    58.290  1075.115     0.150
    58.304   599.314     0.150
    58.611     7.100     0.150
    58.641     7.301     0.150
    58.641   628.516     0.150
    58.810     7.900     0.150
    58.860     7.801     0.150
    58.860   628.715     0.150
    58.987   593.996     0.150
    59.026   594.875     0.150
    59.343   613.314     0.150
    59.439   610.615     0.150
    59.885   599.596     0.150
    60.395   610.814     0.150
    61.519   623.615     0.150
    71.065  2346.615     0.150
    71.639   850.115     0.150
    83.113   764.615     0.150
   123.369  1133.115     0.150
   123.369  1247.115     0.150
   140.199  1162.115     0.150
   140.489  1161.115     0.150
   145.310  1174.516     0.150
   145.880  1176.115     0.150
   146.417  1196.215     0.150
   151.890  1377.115     0.150
   151.890  1442.115     0.150
     0.192     5.152     0.150
     0.558    10.353     0.150
     0.558    10.353     0.150
     0.734    20.152     0.150
     0.734    12.952     0.150
     0.734    20.452     0.150
     0.734    12.952     0.150
     0.734    20.152     0.150
     1.113    20.152     0.150
     1.113    35.152     0.150
     1.470    27.053     0.150
     1.470    48.752     0.150
     1.970    59.952     0.150
     1.970    32.353     0.150
     1.970    32.353     0.150
     1.970    32.152     0.150
     1.970    59.952     0.150
     3.495    52.952     0.150
     3.495    62.952     0.150
     3.516    59.553     0.150
     3.516    60.752     0.150
     3.516    67.553     0.150
     3.516    88.252     0.150
     4.244   107.553     0.150
     4.244   121.152     0.150
     4.769    76.152     0.150
     4.769    85.652     0.150
     4.769   120.353     0.150
     4.769   128.152     0.150
     4.836    72.053     0.150
     4.836    76.152     0.150
     4.836    86.353     0.150
     4.836    72.152     0.150
     4.836   150.152     0.150
     6.026   110.152     0.150
     6.026   107.952     0.150
     6.026    87.353     0.150
     6.026   110.152     0.150
     6.026   185.652     0.150
     6.476    95.652     0.150
     6.476   115.353     0.150
     6.476   119.152     0.150
     6.476   156.353     0.150
     6.476   185.252     0.150
     6.698   103.053     0.150
     6.698   118.652     0.150
     6.698   124.053     0.150
     7.089   126.752     0.150
     7.089   218.152     0.150
     7.089   111.452     0.150
     7.089   126.353     0.150
     7.089   174.152     0.150
     7.089   126.752     0.150
     7.089   218.152     0.150
     7.823   202.553     0.150
     7.823   241.652     0.150
     7.823   113.152     0.150
     7.823   133.952     0.150
     7.823   221.652     0.150
     7.823   241.252     0.150
     7.823   113.152     0.150
     7.823   202.553     0.150
     7.823   241.652     0.150
     7.935   247.353     0.150
     7.935   113.452     0.150
     7.935   124.152     0.150
     7.935   141.252     0.150
     7.935   219.452     0.150
     7.935   245.452     0.150
     7.935   114.152     0.150
     7.935   203.553     0.150
     7.935   247.353     0.150
     8.025   139.053     0.150
     8.025   146.053     0.150
     8.025   215.652     0.150
     8.025   251.252     0.150
     8.331   211.952     0.150
     8.331   262.353     0.150
    10.778   281.152     0.150
    10.778   151.952     0.150
    10.778   281.152     0.150
    13.779   201.152     0.150
    15.170   209.152     0.150
    15.170   209.152     0.150
    16.335   215.152     0.150
    16.335   400.452     0.150
    16.335   215.152     0.150
    16.335   400.452     0.150
    16.362   230.152     0.150
    16.362   230.152     0.150
    16.362   230.152     0.150
    16.383   224.952     0.150
    16.809   228.053     0.150
    18.624   254.152     0.150
    18.624     8.500     0.150
    18.624    11.000     0.150
    20.845     6.500     0.150
    20.845    11.500     0.150
    20.845   281.652     0.150
    20.845   293.152     0.150
    20.845   301.152     0.150
    22.231     6.000     0.150
    38.023   431.652     0.150
    38.926   437.752     0.150
    40.629   464.252     0.150
    40.629   464.252     0.150
    41.321   458.152     0.150
    41.321   468.553     0.150
    41.776   464.553     0.150
    44.305   495.353     0.150
    44.305   495.353     0.150
    46.071   507.252     0.150
    46.882   509.652     0.150
    47.712   519.652     0.150
    55.194   577.553     0.150
    55.351   565.853     0.150
    55.807   580.452     0.150
    55.807   580.452     0.150
    57.040   579.652     0.150
    58.466   599.952     0.150
    59.107   604.152     0.150
    60.794   615.952     0.150
    60.959   618.752     0.150
    60.965   618.853     0.150
    61.104   617.652     0.150
    61.338   618.053     0.150
    61.342   618.152     0.150
    61.564   622.752     0.150
    61.801   623.952     0.150
    62.962   629.452     0.150
    70.267   667.452     0.150
    78.115   715.152     0.150
     0.127     5.117     0.150
     0.127     2.219     0.150
     0.127     5.117     0.150
     0.374    11.320     0.150
     0.374     6.523     0.150
     0.374     6.523     0.150
     0.374     6.523     0.150
     0.374     6.523     0.150
     0.374    11.320     0.150
     0.899    16.422     0.150
     0.899    28.422     0.150
     1.150    20.922     0.150
     1.150    20.922     0.150
     1.150    23.820     0.150
     1.150    27.820     0.150
     1.150    21.320     0.150
     1.150    37.320     0.150
     1.206    23.023     0.150
     1.206    38.422     0.150
     1.309    23.320     0.150
     1.309    41.320     0.150
     1.309    41.219     0.150
     1.309    23.617     0.150
     1.309    41.219     0.150
     1.309    23.320     0.150
     1.309    41.320     0.150
     2.165    63.023     0.150
     2.165    67.117     0.150
     2.165    36.719     0.150
     2.165    39.320     0.150
     2.165    63.023     0.150
     2.165    67.117     0.150
     2.165    39.117     0.150
     2.165    67.117     0.150
     2.216    41.422     0.150
     2.216    38.422     0.150
     2.216    41.422     0.150
     2.216    70.617     0.150
     2.591    42.422     0.150
     2.591    42.422     0.150
     2.591    46.219     0.150
     2.591    73.523     0.150
     2.591    81.320     0.150
     3.413   111.219     0.150
     3.413    55.523     0.150
     3.413    62.523     0.150
     3.413    95.320     0.150
     3.413   105.922     0.150
     3.413   111.219     0.150
     3.684    68.820     0.150
     3.684    59.023     0.150
     3.684    67.117     0.150
     3.684    68.820     0.150
     3.684    99.422     0.150
     3.684   115.117     0.150
     3.684   115.117     0.150
     4.134    76.422     0.150
     4.134    76.422     0.150
     4.134   130.023     0.150
     4.134    75.617     0.150
     4.134   129.820     0.150
     4.571    82.320     0.150
     4.571   151.523     0.150
     4.571    70.617     0.150
     4.571    82.320     0.150
     4.571   141.617     0.150
     4.571   151.523     0.150
     4.571    70.719     0.150
     4.571    82.320     0.150
     4.571   141.820     0.150
     4.831    92.523     0.150
     4.831    86.719     0.150
     4.831    92.523     0.150
     4.831   149.219     0.150
     4.922    89.320     0.150
     4.922    75.820     0.150
     4.922   130.023     0.150
     4.922    89.320     0.150
     4.922   154.023     0.150
     5.831   179.617     0.150
     6.335    96.219     0.150
     6.335   114.023     0.150
     6.335    96.219     0.150
     6.335   114.023     0.150
     6.335   198.023     0.150
     6.503   116.719     0.150
     6.503   119.023     0.150
     6.503   116.719     0.150
     6.503   119.023     0.150
     6.503   199.719     0.150
     6.898   107.922     0.150
     6.898   129.117     0.150
     6.898   107.922     0.150
     6.898   129.117     0.150
     6.898   179.320     0.150
     6.898   214.219     0.150
     7.625   142.219     0.150
     7.625   236.422     0.150
     7.746   114.617     0.150
     7.746   197.523     0.150
     7.746   240.320     0.150
     0.389     7.414     0.150
     0.389    12.617     0.150
     0.389     7.414     0.150
     0.389    13.117     0.150
     0.910    18.617     0.150
     1.227    22.617     0.150
     1.227    22.617     0.150
     1.227    22.617     0.150
     1.227    22.617     0.150
     1.288    23.414     0.150
     1.288    23.414     0.150
     1.294    24.117     0.150
     1.294    23.719     0.150
     1.294    41.820     0.150
     2.104    34.516     0.150
     2.104    34.516     0.150
     2.104    39.320     0.150
     2.104    42.414     0.150
     2.104    37.219     0.150
     2.104    63.414     0.150
     2.230    41.414     0.150
     2.230    47.414     0.150
     2.665    52.516     0.150
     2.665    86.414     0.150
     3.692    67.516     0.150
     3.692    69.117     0.150
     3.692   120.414     0.150
     3.692    67.820     0.150
     4.237    76.617     0.150
     4.237    64.320     0.150
     4.237    76.617     0.150
     4.237   132.617     0.150
     4.613    81.617     0.150
     4.613   142.016     0.150
     4.983    78.719     0.150
     4.983   128.414     0.150
     5.863   104.016     0.150
     5.863   104.016     0.150
     5.863   151.320     0.150
     5.863   179.820     0.150
     5.863   151.414     0.150
     5.863   179.914     0.150
     5.863   104.016     0.150
     5.863   151.320     0.150
     5.863   179.820     0.150
     5.898   199.219     0.150
     6.434    95.219     0.150
     6.434   116.914     0.150
     6.434   174.320     0.150
     6.536    92.516     0.150
     6.536   105.414     0.150
     6.536   117.719     0.150
     6.536    92.516     0.150
     6.536   166.219     0.150
     6.921   107.320     0.150
     6.921   121.617     0.150
     6.921   127.617     0.150
     6.921   173.719     0.150
     6.921   215.320     0.150
     6.921   222.719     0.150
     7.668   128.516     0.150
     7.668   141.719     0.150
     7.764   113.617     0.150
     7.764   120.617     0.150
     7.764   113.617     0.150
     7.764   196.719     0.150
     7.850   140.617     0.150
     7.850   122.719     0.150
     7.850   131.016     0.150
     7.850   140.617     0.150
     7.850   197.414     0.150
    16.174   227.820     0.150
    16.174   227.820     0.150
    16.801   234.617     0.150
    22.163   300.617     0.150
     0.150     7.082     0.150
     0.625    12.281     0.150
     0.625    12.281     0.150
     0.625    16.680     0.150
     1.177    19.082     0.150
     1.177    34.680     0.150
     1.177    19.082     0.150
     1.177    34.680     0.150
     1.490    26.480     0.150
     1.490    26.480     0.150
     1.490    45.480     0.150
     1.724    51.879     0.150
     1.724    30.281     0.150
     1.724    52.980     0.150
     1.952    32.680     0.150
     1.952    34.281     0.150
     1.952    60.480     0.150
     2.432    45.781     0.150
     2.432    42.980     0.150
     2.432    70.281     0.150
     2.432    40.582     0.150
     2.432    42.980     0.150
     2.432    70.281     0.150
     2.432    75.480     0.150
     3.888    59.980     0.150
     3.888    77.680     0.150
     3.888    59.980     0.150
     3.888    68.781     0.150
     3.888    77.680     0.150
     3.888   103.879     0.150
     3.888   121.680     0.150
     4.093    66.281     0.150
     4.093    74.082     0.150
     4.093    64.980     0.150
     4.093    74.879     0.150
     4.093    64.980     0.150
     4.093    74.879     0.150
     4.093   106.980     0.150
     4.093   128.980     0.150
     4.361    67.480     0.150
     4.361    77.680     0.150
     4.361   114.480     0.150
     4.361   134.082     0.150
     5.500    99.980     0.150
     5.500    99.980     0.150
     5.500   171.582     0.150
     5.587   143.980     0.150
     5.587   143.980     0.150
     5.587   173.480     0.150
     6.179   105.082     0.150
     6.470   177.680     0.150
     6.470   118.980     0.150
     6.470   177.680     0.150
     6.470   201.680     0.150
     6.811   211.281     0.150
     7.468   132.082     0.150
     7.468   132.082     0.150
     7.468   228.082     0.150
     7.913   143.480     0.150
     7.913   243.480     0.150
     7.913   142.680     0.150
     7.913   219.281     0.150
     7.913   244.480     0.150
     7.913   142.680     0.150
     7.913   219.281     0.150
     7.913   244.480     0.150
     8.528   154.980     0.150
     8.528   242.480     0.150
     8.528   154.980     0.150
     8.528   242.480     0.150
     8.528   265.180     0.150
     0.167     4.660     0.150
     0.167     8.461     0.150
     0.654    12.461     0.150
     0.654    21.160     0.150
     0.862    14.660     0.150
     0.862    14.660     0.150
     0.862    27.160     0.150
     1.179    20.559     0.150
     1.179    20.559     0.150
     1.414    25.059     0.150
     1.414    44.859     0.150
     1.763    29.359     0.150
     1.763    52.059     0.150
     1.719    29.461     0.150
     1.719    30.359     0.150
     1.719    53.160     0.150
     2.120    34.859     0.150
     2.120    37.660     0.150
     2.120    60.660     0.150
     2.120    65.262     0.150
     2.887    45.559     0.150
     2.887    51.660     0.150
     2.887    89.160     0.150
     3.095    47.859     0.150
     3.095    55.059     0.150
     3.095    94.961     0.150
     4.100    71.859     0.150
     4.100   108.961     0.150
     4.100   125.961     0.150
     4.099    62.559     0.150
     4.099    73.762     0.150
     4.099   127.262     0.150
     4.183    62.859     0.150
     4.183   109.559     0.150
     4.183   129.461     0.150
     5.247    80.059     0.150
     5.247    80.059     0.150
     5.247    94.859     0.150
     5.247   163.461     0.150
     5.381   167.762     0.150
     5.835   181.762     0.150
     6.438    95.359     0.150
     6.438    95.359     0.150
     6.438   165.160     0.150
     6.438   202.160     0.150
     6.537   200.762     0.150
     6.545   203.160     0.150
     7.206   127.961     0.150
     7.206   221.262     0.150
     7.637   137.359     0.150
     7.637   236.660     0.150
     8.286   258.359     0.150
     8.500   263.762     0.150
     8.635   125.461     0.150
     8.635   217.160     0.150
     8.635   266.559     0.150
     0.163     3.731     0.150
     0.163     7.132     0.150
     1.135    20.831     0.150
     1.135    22.531     0.150
     1.135    24.331     0.150
     1.135    36.132     0.150
     2.261    36.831     0.150
     2.261    36.831     0.150
     2.261    67.831     0.150
     2.387    39.132     0.150
     2.387    46.432     0.150
     2.387    74.132     0.150
     2.527    47.331     0.150
     3.288    61.132     0.150
     3.853    69.132     0.150
     3.853    71.331     0.150
     3.853    89.932     0.150
     4.189    72.731     0.150
     4.189    81.531     0.150
     4.433    77.432     0.150
     4.448    67.632     0.150
     4.448    67.632     0.150
     4.448    73.432     0.150
     4.744    82.831     0.150
     5.094    91.331     0.150
     5.094    93.831     0.150
     5.164   136.432     0.150
     5.695   102.031     0.150
     5.695   175.731     0.150
     5.733    91.531     0.150
     6.354   197.731     0.150
     6.354    94.632     0.150
     6.354   172.031     0.150
     6.369   113.932     0.150
     6.369    92.731     0.150
     6.752   208.731     0.150
     6.752   120.932     0.150
     7.503   133.432     0.150
     7.503   231.432     0.150
     7.469   105.531     0.150
     7.595   136.132     0.150
     7.595   235.831     0.150
     7.684   237.432     0.150
     7.684   237.432     0.150
    11.106   153.932     0.150
    16.045   400.132     0.150
    23.843   317.831     0.150
     0.222     5.117     0.150
     0.416    16.117     0.150
     1.368    23.117     0.150
     1.368    30.217     0.150
     1.025    21.818     0.150
     1.025    31.217     0.150
     1.295    40.518     0.150
     1.295    40.518     0.150
     1.681    30.617     0.150
     1.681    53.518     0.150
     1.681    30.617     0.150
     1.681    53.518     0.150
     1.946    39.217     0.150
     2.236    40.217     0.150
     2.236    70.717     0.150
     2.236    45.518     0.150
     2.835    56.318     0.150
     2.835   100.818     0.150
     3.024    61.117     0.150
     3.884    66.818     0.150
     3.884    70.117     0.150
     5.042    89.717     0.150
     5.044    83.918     0.150
     5.044    89.717     0.150
     5.233    93.318     0.150
     5.233    92.418     0.150
     5.233   161.717     0.150
     5.774   103.918     0.150
     6.242   195.818     0.150
     6.549   120.318     0.150
     6.549   202.717     0.150
     6.549   202.818     0.150
     7.204   128.117     0.150
     7.204   128.217     0.150
     7.204   221.818     0.150
     7.657   136.617     0.150
     7.657   235.418     0.150
     7.657   235.318     0.150
     8.529   128.318     0.150
     8.529   153.418     0.150
     8.529   265.518     0.150
     8.529   153.518     0.150
     8.697   129.918     0.150
     8.697   157.918     0.150
     8.697   267.117     0.150
     8.697   130.217     0.150
     8.974   145.918     0.150
    15.988   508.928     0.150
    16.566   542.639     0.150
    21.352     4.984     0.150
    21.352     7.553     0.150
    29.912   377.518     0.150
    45.072   489.217     0.150
    48.435   522.467     0.150
     0.115     5.240     0.150
     0.558    16.941     0.150
     0.558    10.240     0.150
     0.558    16.941     0.150
     0.558    18.441     0.150
     0.955    16.641     0.150
     0.955    28.740     0.150
     0.955    16.641     0.150
     0.955    28.740     0.150
     1.355    43.441     0.150
     1.355    24.441     0.150
     1.355    24.441     0.150
     1.355    25.941     0.150
     1.355    43.041     0.150
     1.731    32.340     0.150
     1.731    31.340     0.150
     1.731    32.340     0.150
     1.731    54.240     0.150
     1.820    32.240     0.150
     1.820    56.441     0.150
     2.199    66.941     0.150
     2.199    70.340     0.150
     2.199    67.141     0.150
     2.199    38.141     0.150
     2.199    39.840     0.150
     2.199    67.141     0.150
     2.199    69.240     0.150
     2.828    88.641     0.150
     2.828    46.541     0.150
     2.828    51.340     0.150
     2.828    79.641     0.150
     2.828    88.641     0.150
     3.094    61.240     0.150
     3.094    50.041     0.150
     3.094    56.240     0.150
     3.094    61.240     0.150
     3.094    85.740     0.150
     3.094    96.441     0.150
     3.882    60.641     0.150
     3.882    69.840     0.150
     3.882   104.141     0.150
     3.882   119.740     0.150
     4.021    61.340     0.150
     4.021    72.041     0.150
     4.021   107.641     0.150
     4.021   125.340     0.150
     4.074    77.041     0.150
     4.074    62.541     0.150
     4.074    73.941     0.150
     4.074    77.041     0.150
     4.074   109.641     0.150
     4.074   126.441     0.150
     4.131    63.641     0.150
     4.131    74.240     0.150
     4.131   127.541     0.150
     5.273   161.541     0.150
     6.371   201.441     0.150
     6.371   114.141     0.150
     6.371   114.141     0.150
     6.371   165.740     0.150
     6.371   198.840     0.150
     6.563   203.340     0.150
     7.238   129.441     0.150
     7.679   136.541     0.150
     7.679   235.641     0.150
     8.695   157.441     0.150
     8.695   269.941     0.150
     8.695   126.641     0.150
     8.695   220.840     0.150
     8.695   269.041     0.150
     0.175     3.488     0.150
     0.548    16.789     0.150
     1.100    19.086     0.150
     1.100    39.887     0.150
     1.305    23.086     0.150
     1.305    42.988     0.150
     1.518    45.789     0.150
     1.518    32.688     0.150
     1.518    53.488     0.150
     1.524    27.289     0.150
     1.524    47.789     0.150
     1.524    27.188     0.150
     1.524    50.586     0.150
     2.206    35.688     0.150
     2.206    38.188     0.150
     2.206    63.086     0.150
     2.206    66.586     0.150
     2.206    38.188     0.150
     2.206    43.188     0.150
     2.226    70.086     0.150
     2.962    58.086     0.150
     2.962    91.789     0.150
     3.625    56.688     0.150
     3.625    64.289     0.150
     3.625    97.188     0.150
     3.625   111.988     0.150
     3.625    64.387     0.150
     3.625    97.188     0.150
     3.641    55.387     0.150
     3.926   106.688     0.150
     3.926    60.387     0.150
     3.926    70.387     0.150
     3.926   106.688     0.150
     3.926   121.789     0.150
     3.926    60.289     0.150
     3.926   135.988     0.150
     3.954    60.789     0.150
     3.954    71.086     0.150
     3.954   121.688     0.150
     3.954    60.887     0.150
     4.852    87.086     0.150
     4.852    93.289     0.150
     5.580   100.688     0.150
     5.580   108.789     0.150
     5.981    90.188     0.150
     5.981   108.988     0.150
     5.981   187.586     0.150
     5.981    90.188     0.150
     5.981   108.988     0.150
     5.981   187.586     0.150
     7.054   127.188     0.150
     7.054   218.188     0.150
     7.526   134.188     0.150
     7.526   231.188     0.150
     8.086   249.289     0.150
     8.407   149.988     0.150
     8.407   123.488     0.150
     8.407   149.988     0.150
     8.407   212.086     0.150
     8.407   260.086     0.150
     8.606   154.688     0.150
     8.606   266.387     0.150
     8.606   125.289     0.150
     8.606   154.688     0.150
     8.606   266.387     0.150
     8.606   125.289     0.150
     8.606   234.289     0.150
     0.046     1.700     0.150
     0.046     6.501     0.150
     0.422     8.101     0.150
     0.960    19.301     0.150
     0.982    35.001     0.150
     1.216    22.301     0.150
     1.216    22.301     0.150
     1.216    22.301     0.150
     1.324    25.601     0.150
     2.072    34.101     0.150
     2.201    61.301     0.150
     3.662    65.601     0.150
     4.250    63.900     0.150
     4.250    76.200     0.150
     4.618    82.801     0.150
     4.964    88.501     0.150
     4.964    73.801     0.150
     4.964    89.101     0.150
     5.350    95.301     0.150
     6.453   115.400     0.150
     6.453   200.501     0.150
     6.453    95.900     0.150
     6.453   116.601     0.150
     6.453   199.700     0.150
     6.569    93.301     0.150
     6.569   119.301     0.150
     6.569   204.700     0.150
     6.953   126.200     0.150
     6.953   216.001     0.150
     6.953   214.801     0.150
     7.700   138.001     0.150
     7.700   239.301     0.150
     7.700   239.400     0.150
     7.796   139.700     0.150
     7.796   241.501     0.150
     7.796   241.101     0.150
     7.881   142.801     0.150
     7.881   246.700     0.150
     7.881   244.601     0.150
     0.172     3.898     0.150
     1.154    38.098     0.150
     1.154    37.398     0.150
     2.302    35.199     0.150
     2.302    70.797     0.150
     2.449    44.699     0.150
     2.449    77.199     0.150
     2.501    44.699     0.150
     3.914    68.199     0.150
     3.914    70.699     0.150
     3.914    73.496     0.150
     4.203    76.199     0.150
     4.203    70.297     0.150
     4.203    75.598     0.150
     4.271    70.398     0.150
     4.271    78.598     0.150
     4.401    66.297     0.150
     4.401    66.297     0.150
     4.401    72.797     0.150
     4.396    72.199     0.150
     4.396    78.996     0.150
     4.396    83.199     0.150
     4.826    90.996     0.150
     4.860    87.398     0.150
     4.862    87.496     0.150
     5.154    92.699     0.150
     5.154    76.398     0.150
     5.154    76.398     0.150
     5.154    82.797     0.150
     5.154    92.797     0.150
     5.643    90.496     0.150
     5.643    99.398     0.150
     5.684    89.898     0.150
     5.684   101.996     0.150
     6.317   112.098     0.150
     6.317    97.898     0.150
     6.317   112.598     0.150
     6.317   115.398     0.150
     6.355   117.199     0.150
     6.355   198.797     0.150
     6.355    99.398     0.150
     6.355   114.797     0.150
     7.456   131.297     0.150
     7.456   114.199     0.150
     7.456   134.098     0.150
     7.531   140.098     0.150
     7.539   137.699     0.150
     7.539   198.199     0.150
     7.539   233.199     0.150
     7.539   110.098     0.150
     7.539   110.098     0.150
     7.539   117.199     0.150
     7.539   233.598     0.150
     7.624   111.297     0.150
     7.624   111.297     0.150
     7.624   119.098     0.150
     7.624   235.098     0.150
     8.451   153.699     0.150
     8.451   264.797     0.150
     8.451   153.707     0.150
     8.451   212.508     0.150
     8.451   264.859     0.150
    15.175   382.199     0.150
    15.377   482.387     0.150
    15.452   398.496     0.150
    16.228   247.398     0.150
    16.228   412.898     0.150
    16.228   537.398     0.150
    16.265   406.398     0.150
    16.299   421.199     0.150
    16.320   510.121     0.150
    17.346   234.898     0.150
    17.346   235.688     0.150
    18.310     3.402     0.150
    18.310     5.902     0.150
    18.310   269.199     0.150
    18.430   461.496     0.150
    19.218   264.898     0.150
    19.423   281.199     0.150
    19.423   295.398     0.150
    19.423   484.699     0.150
    20.590   300.098     0.150
    20.590   536.098     0.150
    20.590   278.598     0.150
    20.590   -14.000     0.150
    20.590   300.098     0.150
    20.590   505.098     0.150
    20.590   529.098     0.150
    20.590   536.098     0.150
    20.590   278.598     0.150
    20.590   -17.000     0.150
    20.590   -14.000     0.150
    20.590   300.098     0.150
    20.590   505.098     0.150
    20.590   529.098     0.150
    20.590   536.098     0.150
    20.590   744.098     0.150
    20.590   745.496     0.150
    21.060   518.699     0.150
    21.060   555.699     0.150
    21.364   322.098     0.150
    21.364   525.098     0.150
    24.525   577.199     0.150
    24.897   370.098     0.150
    25.395   327.098     0.150
    25.853     3.898     0.150
    25.853   596.398     0.150
    25.853   330.598     0.150
    25.853     3.898     0.150
    25.853   596.398     0.150
    26.363   339.066     0.150
    26.363   339.066     0.150
    26.589   624.648     0.150
    26.603   610.098     0.150
    26.603   335.098     0.150
    26.603   607.098     0.150
    26.730   339.227     0.150
    26.771   340.398     0.150
    26.894   342.719     0.150
    27.124   344.719     0.150
    27.153   344.137     0.150
    27.171   343.699     0.150
    27.171   402.398     0.150
    27.421   345.770     0.150
    28.555     4.602     0.150
    28.555     8.203     0.150
    28.555   420.098     0.150
    28.555   642.496     0.150
    28.779   412.098     0.150
    28.779   548.098     0.150
    29.974     7.602     0.150
    31.507     6.902     0.150
    31.507     9.902     0.150
    31.507   463.996     0.150
    31.507   703.398     0.150
    31.507   827.598     0.150
    31.507   381.496     0.150
    31.507     9.801     0.150
    31.507   463.996     0.150
    31.507   691.098     0.150
    31.507   703.398     0.150
    31.507  1006.699     0.150
    31.507   381.496     0.150
    31.507     6.902     0.150
    31.507     9.801     0.150
    31.507   442.297     0.150
    31.507   463.996     0.150
    31.507   691.098     0.150
    31.507   703.398     0.150
    31.507   801.297     0.150
    31.507   827.598     0.150
    31.507  1006.699     0.150
    33.573   700.098     0.150
    33.737   403.098     0.150
    33.960   460.098     0.150
    36.007   757.496     0.150
    36.558   780.098     0.150
    36.948   768.199     0.150
    38.885   444.859     0.150
    38.885   444.859     0.150
    39.541   818.699     0.150
    41.608   465.797     0.150
    41.988   849.098     0.150
    41.988  1035.098     0.150
    42.400   474.977     0.150
    43.241   477.949     0.150
    43.980   625.898     0.150
    44.859   893.098     0.150
    44.869   503.688     0.150
    44.869  1080.039     0.150
    44.869  1425.758     0.150
    45.837   497.297     0.150
    45.837   647.898     0.150
    45.837   895.898     0.150
    45.848   503.098     0.150
    46.249   653.297     0.150
    46.249   922.199     0.150
    46.249  1177.699     0.150
    47.289  1156.297     0.150
    47.289   511.797     0.150
    47.284   523.098     0.150
    47.581   513.098     0.150
    48.425   529.957     0.150
    48.425  1439.277     0.150
    48.425  1576.727     0.150
    48.425  1766.488     0.150
    48.474   527.887     0.150
    49.116   527.438     0.150
    49.109  1250.527     0.150
    49.109  1583.168     0.150
    49.239  1243.098     0.150
    49.282   528.957     0.150
    49.370   528.918     0.150
    49.436  1186.496     0.150
    49.436   529.496     0.150
    49.436   957.699     0.150
    50.145   533.598     0.150
    50.145   965.098     0.150
    50.145   533.598     0.150
    50.145   965.098     0.150
    50.145  1186.297     0.150
    50.420   536.648     0.150
    50.430  1193.098     0.150
    50.430   537.898     0.150
    50.770   550.199     0.150
    50.770   550.199     0.150
    50.770   654.098     0.150
    50.770   976.297     0.150
    50.770  1210.699     0.150
    50.770   539.297     0.150
    50.834   539.547     0.150
    51.067   541.586     0.150
    51.279   542.336     0.150
    51.384   544.699     0.150
    51.384   668.797     0.150
    51.384   977.996     0.150
    51.520   535.898     0.150
    51.682   548.039     0.150
    51.722   546.637     0.150
    52.411  1231.699     0.150
    52.537   989.098     0.150
    52.875   555.199     0.150
    52.875  1003.398     0.150
    52.959   557.496     0.150
    53.556  1014.098     0.150
    53.651   589.098     0.150
    53.651   685.098     0.150
    53.651   739.098     0.150
    53.651  1267.098     0.150
    53.651   560.199     0.150
    53.651   627.098     0.150
    53.651  1013.098     0.150
    53.932   563.898     0.150
    53.932  1247.496     0.150
    54.676   568.797     0.150
    54.735   567.996     0.150
    54.735   567.996     0.150
    54.735  1031.098     0.150
    54.735  1255.098     0.150
    54.735   567.996     0.150
    54.735  1031.098     0.150
    54.735  1255.098     0.150
    54.950   558.406     0.150
    54.987   570.496     0.150
    54.987  1029.898     0.150
    55.611   711.797     0.150
    55.611   574.797     0.150
    55.611     5.801     0.150
    55.611   711.797     0.150
    55.611  1041.996     0.150
    55.611  1267.398     0.150
    56.727   584.496     0.150
    56.841   632.027     0.150
    56.841  1049.098     0.150
    56.841   585.059     0.150
    56.841   632.027     0.150
    56.841  1049.098     0.150
    57.037  1805.898     0.150
    57.481   682.199     0.150
    58.480   593.098     0.150
    58.987   596.898     0.150
    59.083   599.496     0.150
    60.614   607.496     0.150
    60.760   609.996     0.150
    60.925   609.797     0.150
    61.114   611.098     0.150
    61.180   611.098     0.150
    61.186   611.098     0.150
    61.537     0.297     0.150
    61.600   614.398     0.150
    61.636   614.098     0.150
    62.081   617.898     0.150
    62.336   619.496     0.150
    62.616   621.297     0.150
    63.160   624.797     0.150
    69.501   664.629     0.150
    72.717   686.898     0.150
    78.120   717.098     0.150
    79.305   726.398     0.150
    91.260   783.371     0.150
     0.261     9.777     0.150
     0.261    21.980     0.150
     1.024    18.379     0.150
     1.024    32.777     0.150
     1.147    20.879     0.150
     1.147    21.980     0.150
     1.147    36.777     0.150
     1.251    40.879     0.150
     1.415    25.578     0.150
     1.415    25.578     0.150
     1.415    25.578     0.150
     1.415    44.578     0.150
     3.205    57.578     0.150
     3.963   121.777     0.150
     4.218    75.578     0.150
     4.368    78.680     0.150
     5.202    93.078     0.150
     5.202    93.777     0.150
     6.278   111.980     0.150
     6.358   114.680     0.150
     6.358   115.277     0.150
     6.655   119.277     0.150
     7.495   232.180     0.150
     7.495   110.578     0.150
     7.495   232.277     0.150
     7.577   134.777     0.150
     7.577   233.777     0.150
     7.577   233.777     0.150
     9.615   172.879     0.150
     0.178     3.797     0.150
     0.236     8.695     0.150
     1.180    37.891     0.150
     1.180    21.297     0.150
     1.233    40.594     0.150
     1.251    40.594     0.150
     1.414    25.492     0.150
     1.414    25.492     0.150
     1.414    44.297     0.150
     2.301    38.594     0.150
     2.479    75.492     0.150
     3.237   100.297     0.150
     3.941    71.594     0.150
     3.941    60.992     0.150
     3.941    71.492     0.150
     5.196    93.891     0.150
     5.196    93.492     0.150
     6.309   112.594     0.150
     6.309   195.094     0.150
     6.388    94.797     0.150
     6.388   115.094     0.150
     6.388   197.992     0.150
     6.388    38.695     0.150
     6.388   114.992     0.150
     6.684   117.195     0.150
     6.684   207.391     0.150
     7.523   135.492     0.150
     7.523   231.594     0.150
     0.176     7.762     0.150
     0.224     9.664     0.150
     1.059    34.164     0.150
     1.170    21.465     0.150
     1.393    43.762     0.150
     1.393    25.262     0.150
     1.393    25.262     0.150
     1.393    25.262     0.150
     2.299    70.762     0.150
     4.226    76.664     0.150
     4.274    77.465     0.150
     4.401    79.863     0.150
     5.131    92.863     0.150
     5.176    78.965     0.150
     5.176    92.965     0.150
     5.176    92.465     0.150
     5.176   161.562     0.150
     6.315   112.262     0.150
     6.315    92.664     0.150
     6.315   113.465     0.150
     6.375   115.363     0.150
     6.375    92.762     0.150
     6.375   115.363     0.150
     6.692   120.562     0.150
     7.532   134.762     0.150
     7.532   233.164     0.150
     7.532   110.965     0.150
     7.532   233.164     0.150
     7.614   135.965     0.150
     7.614   235.863     0.150
     7.614   234.664     0.150
     0.170     3.555     0.150
     1.029    18.455     0.150
     1.029    32.555     0.150
     1.175    21.555     0.150
     1.175    38.455     0.150
     1.426    25.955     0.150
     1.426    25.955     0.150
     1.426    25.955     0.150
     2.494    41.254     0.150
     3.224    89.154     0.150
     3.957    72.055     0.150
     3.957   123.555     0.150
     5.120    92.754     0.150
     5.210    93.355     0.150
     5.210    93.355     0.150
     5.210   162.254     0.150
     6.296   113.555     0.150
     6.386   113.754     0.150
     6.386   115.055     0.150
     6.386   164.254     0.150
     6.670   119.154     0.150
     0.176     4.512     0.150
     0.176     7.912     0.150
     1.071    19.611     0.150
     1.160    37.311     0.150
     1.160    21.512     0.150
     1.160    21.512     0.150
     1.160    21.512     0.150
     1.219    23.611     0.150
     1.374    43.412     0.150
     1.374    25.012     0.150
     1.374    25.012     0.150
     1.374    25.012     0.150
     2.451    48.012     0.150
     2.506    42.111     0.150
     2.506    44.012     0.150
     3.243    51.412     0.150
     3.915    71.211     0.150
     4.211    75.611     0.150
     4.211    75.711     0.150
     5.130    91.912     0.150
     5.158    91.912     0.150
     5.158    76.711     0.150
     5.158    92.811     0.150
     5.687   101.311     0.150
     5.687   156.811     0.150
     6.319   112.512     0.150
     6.319   112.412     0.150
     6.699   120.711     0.150
     7.459   133.111     0.150
     7.459   228.611     0.150
     7.540   136.512     0.150
     7.540   234.611     0.150
     7.540   202.811     0.150
     7.540   231.412     0.150
     7.624   137.711     0.150
     7.624   235.711     0.150
     0.166     4.328     0.150
     0.166     7.133     0.150
     1.033    19.133     0.150
     1.170    21.328     0.150
     1.170    21.328     0.150
     1.170    21.328     0.150
     2.314    38.531     0.150
     2.314    71.133     0.150
     2.506    49.430     0.150
     2.490    41.227     0.150
     2.490    50.531     0.150
     2.490    77.531     0.150
     2.490    85.828     0.150
     2.490    41.133     0.150
     2.490    44.828     0.150
     2.490    75.828     0.150
     3.953    71.633     0.150
     3.953    61.828     0.150
     3.953    71.930     0.150
     4.389    67.531     0.150
     4.389    67.531     0.150
     4.384    66.930     0.150
     4.384    66.930     0.150
     4.384    78.227     0.150
     4.849   152.031     0.150
     5.204    93.531     0.150
     5.204   161.031     0.150
     5.423   170.633     0.150
     5.621    96.031     0.150
     5.666   159.727     0.150
     6.296   111.031     0.150
     6.671   123.930     0.150
     7.439   140.430     0.150
     7.439   132.633     0.150
     7.510   234.430     0.150
     7.510   136.727     0.150
     7.510   233.930     0.150
     7.589   135.930     0.150
     7.589   235.531     0.150
     8.497   209.578     0.150
     8.497   120.227     0.150
     8.497   261.633     0.150
     8.497   120.258     0.150
     8.497   264.078     0.150
     8.598   129.727     0.150
     8.598   271.656     0.150
    12.157   170.430     0.150
    15.330   479.477     0.150
    17.341   236.133     0.150
    17.341   435.828     0.150
    17.341   237.242     0.150
    18.305   458.531     0.150
    20.596   284.531     0.150
    20.596   300.930     0.150
    20.596   284.531     0.150
    20.596   -12.898     0.150
    20.596   300.930     0.150
    20.596   498.430     0.150
    20.596   284.531     0.150
    20.596   -12.898     0.150
    20.596    -9.500     0.150
    20.596   300.930     0.150
    20.596   493.430     0.150
    20.596   498.430     0.150
    20.596   519.430     0.150
    21.414   292.727     0.150
    21.635   299.531     0.150
    22.063   296.430     0.150
    23.307   305.961     0.150
    23.688   576.539     0.150
    23.733   568.633     0.150
    23.733   310.781     0.150
    24.557   317.430     0.150
    24.557     9.602     0.150
    24.557    13.602     0.150
    24.557   578.430     0.150
    25.888     6.500     0.150
    25.888   603.633     0.150
    25.888   333.227     0.150
    25.888     6.500     0.150
    25.888   603.633     0.150
    25.888   608.828     0.150
    27.113   333.531     0.150
    27.488   331.602     0.150
    28.728   355.789     0.150
    31.515     6.500     0.150
    31.515   692.930     0.150
    31.515   381.633     0.150
    31.515     6.500     0.150
    31.515   692.930     0.150
    38.842   444.422     0.150
    40.335   556.227     0.150
    40.335   575.227     0.150
    43.930   622.633     0.150
    43.930   873.828     0.150
    45.786   593.328     0.150
    45.786   898.430     0.150
    45.786  1155.031     0.150
    53.507   567.328     0.150
    53.602   588.430     0.150
    53.602   559.727     0.150
    53.602   567.727     0.150
    53.636   560.633     0.150
    54.686   568.328     0.150
    54.686   568.328     0.150
    58.939   596.633     0.150
    60.565   607.430     0.150
    60.711   609.430     0.150
    61.552   614.430     0.150
    62.286   619.328     0.150
    78.157   713.531     0.150
     0.174     4.094     0.150
     0.174     7.188     0.150
     1.166    41.492     0.150
     1.389    24.391     0.150
     1.389    24.391     0.150
     2.462    40.688     0.150
     3.239    61.992     0.150
     3.926    71.391     0.150
     4.399    78.992     0.150
     4.862    86.594     0.150
     5.172    92.688     0.150
     5.172    92.188     0.150
     5.129    91.992     0.150
     5.640   146.188     0.150
     5.640   174.391     0.150
     5.682   101.391     0.150
     5.682   154.891     0.150
     6.314   112.391     0.150
     6.314   113.492     0.150
     6.370   116.188     0.150
     6.370   115.094     0.150
     6.370   197.492     0.150
     7.455   116.391     0.150
     7.455   115.891     0.150
     7.533   134.891     0.150
     7.533   234.594     0.150
     7.615   135.789     0.150
     7.615   136.992     0.150
     7.615   236.391     0.150
     8.471   120.242     0.150
     8.471   211.789     0.150
     8.471   264.023     0.150
     8.602   128.891     0.150
    15.361   386.117     0.150
    15.361   481.562     0.150
    15.361   215.344     0.150
    15.361   386.109     0.150
    15.361   481.570     0.150
    17.338   236.289     0.150
    45.671   498.141     0.150
    47.560   512.469     0.150
     0.274    10.246     0.150
     1.005    17.848     0.150
     1.005    31.348     0.150
     1.005    17.848     0.150
     1.005    31.547     0.150
     1.171    42.547     0.150
     1.290    23.848     0.150
     1.447    26.645     0.150
     1.447    26.645     0.150
     1.447    26.547     0.150
     4.250   131.445     0.150
     5.105    79.746     0.150
     5.105    97.047     0.150
     5.232    93.547     0.150
     5.232    93.547     0.150
     6.276   112.246     0.150
     6.649   119.645     0.150
     7.421   133.848     0.150
     7.487   228.047     0.150
     7.564   234.348     0.150
     0.175     4.070     0.150
     0.175     4.070     0.150
     0.175     3.977     0.150
     0.212     4.570     0.150
     0.212     7.875     0.150
     1.079    19.375     0.150
     1.079    33.773     0.150
     1.079    19.273     0.150
     1.079    33.977     0.150
     1.079    19.375     0.150
     1.079    33.773     0.150
     1.152    21.172     0.150
     1.152    21.172     0.150
     1.152    41.570     0.150
     1.361    24.977     0.150
     1.361    24.977     0.150
     1.361    25.070     0.150
     2.300    37.477     0.150
     2.300    40.273     0.150
     2.300    66.070     0.150
     2.300    69.773     0.150
     2.443    75.875     0.150
     2.443    40.477     0.150
     2.443    43.570     0.150
     2.443    75.875     0.150
     2.500    44.273     0.150
     2.500    78.070     0.150
     3.164    57.172     0.150
     3.164    89.375     0.150
     3.164    99.273     0.150
     3.243    50.570     0.150
     3.243    56.570     0.150
     3.243    99.570     0.150
     3.908    58.773     0.150
     3.908    70.977     0.150
     3.908    58.773     0.150
     3.908    68.773     0.150
     3.908   119.875     0.150
     4.198    75.875     0.150
     4.198    75.875     0.150
     4.198   131.172     0.150
     4.273    77.273     0.150
     4.273    77.273     0.150
     4.273   133.070     0.150
     4.404    66.875     0.150
     4.404    78.172     0.150
     4.404   115.875     0.150
     4.404   135.070     0.150
     4.397    78.875     0.150
     4.397    67.672     0.150
     4.397    78.875     0.150
     4.397   135.875     0.150
     4.828    79.672     0.150
     4.828    79.672     0.150
     4.828   148.977     0.150
     5.146    92.570     0.150
     5.146   131.477     0.150
     5.146    92.477     0.150
     5.146    76.875     0.150
     5.146    92.570     0.150
     5.146   131.477     0.150
     5.146   159.273     0.150
     5.687    91.375     0.150
     5.687    91.375     0.150
     5.687   147.172     0.150
     5.687   174.977     0.150
     6.321   160.672     0.150
     6.321   111.375     0.150
     6.321    94.070     0.150
     6.321   160.672     0.150
     6.321   193.977     0.150
     6.351   114.477     0.150
     6.351   114.477     0.150
     6.351   196.570     0.150
     6.702   104.477     0.150
     6.702   121.273     0.150
     6.702   104.477     0.150
     6.702   121.273     0.150
     6.702   171.477     0.150
     6.702   207.773     0.150
     7.459   115.070     0.150
     7.459   115.070     0.150
     7.459   230.672     0.150
     7.544   136.773     0.150
     7.544   188.570     0.150
     7.544   234.172     0.150
     7.544   111.273     0.150
     7.544   136.773     0.150
     7.544   194.570     0.150
     7.544   234.070     0.150
     7.630   234.070     0.150
     7.630   136.477     0.150
     7.630   234.375     0.150
     7.630   111.070     0.150
     7.630   194.477     0.150
     7.630   234.070     0.150
     0.160     4.375     0.150
     0.160     4.375     0.150
     1.292    23.074     0.150
     1.292    23.074     0.150
     1.436    25.477     0.150
     1.436    25.477     0.150
     1.436    25.375     0.150
     1.436    44.977     0.150
     1.428    25.074     0.150
     1.428    25.074     0.150
     1.428    43.676     0.150
     1.428    25.074     0.150
     1.428    43.875     0.150
     1.683    37.273     0.150
     1.683    52.977     0.150
     1.683    51.176     0.150
     2.305    49.773     0.150
     3.082    55.176     0.150
     3.854   118.773     0.150
     4.956    88.176     0.150
     5.689   102.375     0.150
     5.689   102.273     0.150
     5.689   176.477     0.150
     6.234    94.676     0.150
     6.234    95.773     0.150
     6.234   112.875     0.150
     6.537   123.574     0.150
     6.537   199.375     0.150
     6.939   123.273     0.150
     6.939   214.074     0.150
     7.176   110.984     0.150
     7.176   179.926     0.150
     7.176   221.363     0.150
     7.436   130.875     0.150
     7.940   249.977     0.150
     8.326   147.977     0.150
     8.326   256.375     0.150
     8.564   126.574     0.150
     8.564   127.875     0.150
     8.564   152.977     0.150
     8.564   262.375     0.150
    10.731   157.605     0.150
    10.731   296.914     0.150
    10.731   320.715     0.150
    17.637   241.477     0.150
    41.769   459.273     0.150
    56.642   588.969     0.150
    56.642   588.965     0.150
     0.409     8.252     0.150
     0.221     4.752     0.150
     0.221     8.752     0.150
     1.369    24.151     0.150
     1.369    24.151     0.150
     1.369    42.752     0.150
     1.369    24.151     0.150
     1.369    42.052     0.150
     1.628    28.852     0.150
     1.628    28.852     0.150
     1.628    34.951     0.150
     1.628    28.951     0.150
     2.299    71.651     0.150
     2.860    47.651     0.150
     2.860    88.752     0.150
     3.871    59.352     0.150
     4.056    60.352     0.150
     4.938    90.552     0.150
     4.958    89.451     0.150
     5.181    91.852     0.150
     5.181    93.451     0.150
     5.461    99.552     0.150
     5.686   102.252     0.150
     6.062   109.151     0.150
     6.062   112.052     0.150
     6.466   115.552     0.150
     6.466   114.052     0.150
     7.158   127.951     0.150
     7.158   114.252     0.150
     7.158   132.352     0.150
     7.158   223.352     0.150
     7.628   136.352     0.150
     7.628   234.151     0.150
     8.191   253.052     0.150
     8.191   149.352     0.150
     8.507   151.052     0.150
     8.507   261.651     0.150
     8.701   239.352     0.150
     8.701   155.752     0.150
     8.701   267.451     0.150
    21.372   287.151     0.150
    42.715   475.852     0.150
    47.118   626.752     0.150
    47.118   664.651     0.150
    47.118   918.352     0.150
    47.118   937.352     0.150
    47.118  1196.552     0.150
    77.382   712.011     0.150
     0.171     4.141     0.150
     0.171     4.141     0.150
     0.171     7.344     0.150
     0.561    10.844     0.150
     0.561    18.344     0.150
     1.184    22.641     0.150
     1.184    40.039     0.150
     1.184    42.641     0.150
     1.184    21.539     0.150
     1.184    22.641     0.150
     1.184    37.445     0.150
     1.184    40.039     0.150
     1.184    42.641     0.150
     1.485    26.539     0.150
     1.485    46.539     0.150
     1.485    26.539     0.150
     1.485    46.039     0.150
     1.790    54.039     0.150
     1.790    31.344     0.150
     1.790    54.539     0.150
     1.913    39.539     0.150
     1.913    34.141     0.150
     1.913    32.742     0.150
     1.913    34.141     0.150
     1.913    39.539     0.150
     1.913    59.945     0.150
     2.428    39.844     0.150
     2.428    43.641     0.150
     2.428    75.641     0.150
     2.611    52.641     0.150
     2.611    45.945     0.150
     2.611    47.445     0.150
     2.611    83.945     0.150
     2.611    47.539     0.150
     2.611    52.641     0.150
     2.611    82.039     0.150
     3.253    55.039     0.150
     3.253    51.242     0.150
     3.253    55.039     0.150
     3.253    58.641     0.150
     3.253   100.344     0.150
     3.861    63.242     0.150
     3.861    59.445     0.150
     3.861    63.242     0.150
     3.861    70.039     0.150
     3.861   120.742     0.150
     4.027    64.344     0.150
     4.027    73.344     0.150
     4.027    64.344     0.150
     4.027    73.344     0.150
     4.027   125.945     0.150
     4.328    65.344     0.150
     4.328    77.445     0.150
     4.328   133.945     0.150
     5.274    95.945     0.150
     5.274    95.945     0.150
     5.274   164.242     0.150
     5.465   168.844     0.150
     6.004   138.039     0.150
     6.004   138.039     0.150
     6.004   186.242     0.150
     6.405    95.742     0.150
     6.405   116.141     0.150
     6.405   163.141     0.150
     6.405    95.742     0.150
     6.405   116.141     0.150
     6.405   163.141     0.150
     6.405   199.445     0.150
     6.753   210.039     0.150
     7.435   153.039     0.150
     7.435   122.039     0.150
     7.435   153.039     0.150
     7.435   231.141     0.150
     7.885   243.242     0.150
     7.885   243.242     0.150
     8.489   263.539     0.150
     8.489   263.539     0.150
     0.166     3.672     0.150
     0.166     6.871     0.150
     0.166     6.871     0.150
     0.229     9.570     0.150
     0.229     4.770     0.150
     0.229     9.570     0.150
     1.056    18.672     0.150
     1.056    32.871     0.150
     1.056    18.570     0.150
     1.056    33.070     0.150
     1.056    18.672     0.150
     1.056    32.871     0.150
     1.157    22.770     0.150
     1.157    21.270     0.150
     1.157    21.270     0.150
     1.157    22.770     0.150
     1.157    37.473     0.150
     1.387    25.570     0.150
     1.387    25.570     0.150
     1.387    25.473     0.150
     1.387    44.473     0.150
     2.309    45.871     0.150
     2.309    37.770     0.150
     2.309    40.570     0.150
     2.309    45.871     0.150
     2.309    66.371     0.150
     2.309    70.371     0.150
     2.466    40.473     0.150
     2.466    40.570     0.150
     2.466    44.270     0.150
     2.466    76.871     0.150
     2.499    41.473     0.150
     2.499    45.270     0.150
     2.499    78.270     0.150
     3.232    51.270     0.150
     3.232    58.473     0.150
     3.232    90.371     0.150
     3.232   100.973     0.150
     3.930    60.770     0.150
     3.930    60.770     0.150
     3.930    70.672     0.150
     3.930   107.172     0.150
     3.930   121.172     0.150
     4.214    65.473     0.150
     4.214    75.473     0.150
     4.214   130.371     0.150
     4.263   132.770     0.150
     4.392    80.973     0.150
     4.392   119.473     0.150
     4.392    67.070     0.150
     4.392    80.973     0.150
     4.392   119.473     0.150
     4.392   135.473     0.150
     4.390    67.270     0.150
     4.390    78.871     0.150
     4.390   135.973     0.150
     5.120    91.770     0.150
     5.120    77.172     0.150
     5.120    91.770     0.150
     5.120   158.070     0.150
     5.172    93.473     0.150
     5.172    93.270     0.150
     5.172    77.070     0.150
     5.172    93.473     0.150
     5.172   134.473     0.150
     5.172   160.770     0.150
     5.674   104.473     0.150
     5.674    83.672     0.150
     5.674   104.473     0.150
     5.674   174.172     0.150
     6.307    95.672     0.150
     6.307   112.473     0.150
     6.307   112.570     0.150
     6.307    95.672     0.150
     6.307   112.473     0.150
     6.307   162.672     0.150
     6.307   193.570     0.150
     6.362    94.473     0.150
     6.362   117.570     0.150
     6.362   113.770     0.150
     6.362    94.473     0.150
     6.362   117.570     0.150
     6.362   196.070     0.150
     6.685    99.473     0.150
     6.685   172.371     0.150
     6.685   173.871     0.150
     6.685   205.570     0.150
     7.447   112.473     0.150
     7.447   134.770     0.150
     7.447   112.473     0.150
     7.447   134.770     0.150
     7.447   232.371     0.150
     7.526   134.672     0.150
     7.526   189.973     0.150
     7.609   115.070     0.150
     7.609   190.473     0.150
     7.609   136.371     0.150
     7.609   234.371     0.150
     7.609   115.070     0.150
     7.609   190.473     0.150
     7.609   233.973     0.150
    45.818   594.871     0.150
    45.818   612.570     0.150
    45.818   907.371     0.150
    45.818   916.172     0.150
    45.818  1163.473     0.150
     0.140     5.324     0.150
     1.380    43.922     0.150
     1.380    25.324     0.150
     1.380    43.922     0.150
     1.539    27.523     0.150
     1.539    47.922     0.150
     1.571    28.223     0.150
     1.571    28.223     0.150
     1.571    49.625     0.150
     1.569    34.023     0.150
     1.569    48.023     0.150
     1.569    28.223     0.150
     1.569    34.023     0.150
     1.569    49.422     0.150
     2.428    74.922     0.150
     2.428    39.824     0.150
     2.428    43.223     0.150
     2.428    70.523     0.150
     2.428    74.922     0.150
     2.459    38.523     0.150
     2.459    38.125     0.150
     2.459    38.523     0.150
     2.459    43.324     0.150
     2.459    69.223     0.150
     2.459    75.324     0.150
     2.783    46.324     0.150
     2.783    50.723     0.150
     2.783    87.125     0.150
     2.954    47.523     0.150
     2.954    52.824     0.150
     2.954    91.824     0.150
     3.358    59.723     0.150
     3.358   103.324     0.150
     3.358    52.324     0.150
     3.358    59.723     0.150
     3.358   103.422     0.150
     3.616    59.523     0.150
     3.616   102.023     0.150
     3.616    59.523     0.150
     3.616    65.922     0.150
     3.616   102.023     0.150
     3.616   113.324     0.150
     3.702    54.723     0.150
     3.702    57.422     0.150
     3.702    66.523     0.150
     3.702   100.922     0.150
     3.702   114.625     0.150
     3.987    69.223     0.150
     3.987    61.625     0.150
     3.987    69.223     0.150
     3.987   123.023     0.150
     4.804    86.422     0.150
     4.804    73.625     0.150
     4.804    86.422     0.150
     4.804   149.625     0.150
     5.087    77.223     0.150
     5.087    90.023     0.150
     5.087   155.922     0.150
     5.322   166.523     0.150
     5.371   167.824     0.150
     5.525   100.723     0.150
     5.525   100.723     0.150
     5.525   172.625     0.150
     5.738   103.324     0.150
     5.738   103.422     0.150
     5.738   177.324     0.150
     5.738    85.223     0.150
     5.738   103.324     0.150
     5.738   177.324     0.150
     5.986   186.523     0.150
     6.363   197.422     0.150
     6.403   114.125     0.150
     6.403   162.723     0.150
     6.403   200.625     0.150
     6.432   197.324     0.150
     7.070   126.625     0.150
     7.070   216.422     0.150
     7.569   136.324     0.150
     7.569   137.723     0.150
     7.569   112.625     0.150
     7.569   136.324     0.150
     7.569   233.523     0.150
     8.066   145.223     0.150
     8.066   249.023     0.150
     8.066   247.223     0.150
     8.460   129.922     0.150
     8.460   150.922     0.150
     8.460   261.922     0.150
     8.460   122.422     0.150
     8.460   215.125     0.150
     8.460   260.625     0.150
     8.591   121.625     0.150
     8.700   225.723     0.150
     8.700   156.523     0.150
     8.700   268.125     0.150
     8.700   126.723     0.150
     8.700   225.723     0.150
     8.700   269.125     0.150
    17.572   244.723     0.150
     0.040     4.609     0.150
     0.040     2.008     0.150
     0.040     4.609     0.150
     0.373     6.707     0.150
     0.373    12.109     0.150
     0.373     6.508     0.150
     0.373     6.707     0.150
     0.373    12.109     0.150
     1.062    30.707     0.150
     1.062    20.008     0.150
     1.062    30.707     0.150
     1.062    34.609     0.150
     1.252    22.109     0.150
     1.252    38.809     0.150
     1.252    22.109     0.150
     1.252    38.809     0.150
     1.312    23.906     0.150
     1.312    42.906     0.150
     1.293    25.406     0.150
     1.293    44.809     0.150
     1.293    24.109     0.150
     1.293    25.406     0.150
     1.293    41.809     0.150
     1.293    44.809     0.150
     2.105    35.508     0.150
     2.105    36.508     0.150
     2.105    62.207     0.150
     2.105    65.008     0.150
     2.276    71.609     0.150
     2.276    38.406     0.150
     2.276    41.309     0.150
     2.276    71.707     0.150
     2.679    44.309     0.150
     2.679    47.508     0.150
     2.679    78.207     0.150
     2.679    83.809     0.150
     3.355   105.508     0.150
     3.441   106.309     0.150
     3.735   115.906     0.150
     3.735    58.207     0.150
     3.735    66.508     0.150
     3.735   115.906     0.150
     4.287    68.309     0.150
     4.287    77.609     0.150
     4.287    68.309     0.150
     4.287    77.609     0.150
     4.287   134.309     0.150
     4.601    81.707     0.150
     4.601   141.809     0.150
     4.589    81.008     0.150
     4.589    70.008     0.150
     4.589    81.008     0.150
     4.589   141.109     0.150
     5.045    91.309     0.150
     5.045    90.609     0.150
     5.045    76.109     0.150
     5.045    91.309     0.150
     5.045   131.809     0.150
     5.045   157.809     0.150
     5.320   165.309     0.150
     6.476    98.707     0.150
     6.476   117.109     0.150
     6.476    98.707     0.150
     6.476   117.109     0.150
     6.476   168.406     0.150
     6.476   201.707     0.150
     6.897   171.406     0.150
     6.897   171.406     0.150
     6.897   213.406     0.150
     7.737   135.008     0.150
     7.737   138.406     0.150
     7.737   195.008     0.150
     7.737   239.008     0.150
     7.814   139.707     0.150
     7.814   114.906     0.150
     7.814   201.707     0.150
     7.814   239.609     0.150
     0.131     2.797     0.150
     0.131     2.797     0.150
     0.131     5.398     0.150
     0.314    11.797     0.150
     0.314     5.797     0.150
     0.314    11.695     0.150
     0.968    17.000     0.150
     0.968    30.398     0.150
     0.968    34.000     0.150
     0.968    17.000     0.150
     0.968    30.297     0.150
     0.968    17.000     0.150
     0.968    30.398     0.150
     0.968    34.000     0.150
     1.144    42.594     0.150
     1.144    21.094     0.150
     1.144    21.094     0.150
     1.144    37.297     0.150
     1.144    42.594     0.150
     1.324    42.797     0.150
     1.324    24.398     0.150
     1.324    43.000     0.150
     1.469    27.094     0.150
     1.469    27.094     0.150
     1.469    47.000     0.150
     2.371    39.297     0.150
     2.371    41.297     0.150
     2.371    71.898     0.150
     2.465    41.500     0.150
     2.465    44.594     0.150
     2.465    77.797     0.150
     2.555    43.398     0.150
     2.555    85.297     0.150
     2.555    43.398     0.150
     2.555    45.797     0.150
     2.555    80.000     0.150
     2.555    85.297     0.150
     3.108    89.898     0.150
     3.108    50.500     0.150
     3.108    55.594     0.150
     3.108    89.898     0.150
     3.108    97.195     0.150
     3.165    90.500     0.150
     3.165    51.297     0.150
     3.165    56.695     0.150
     3.165    90.500     0.150
     3.165    98.297     0.150
     3.740    59.094     0.150
     3.740    67.000     0.150
     3.740   116.297     0.150
     4.019    73.297     0.150
     4.019    73.297     0.150
     4.019   125.797     0.150
     4.237    76.797     0.150
     4.237    76.000     0.150
     4.237   131.797     0.150
     4.325    67.094     0.150
     4.325   117.195     0.150
     4.325   133.195     0.150
     4.338    69.000     0.150
     4.338    67.398     0.150
     4.338    69.000     0.150
     4.338    77.594     0.150
     4.338   117.094     0.150
     4.338   133.398     0.150
     5.066    77.398     0.150
     5.066    90.094     0.150
     5.066   157.195     0.150
     5.257    79.297     0.150
     5.257    94.898     0.150
     5.257    79.297     0.150
     5.257   137.094     0.150
     5.257   163.898     0.150
     5.559   100.094     0.150
     5.606   101.797     0.150
     5.606   101.695     0.150
     5.606   172.594     0.150
     5.606    84.297     0.150
     5.606   101.797     0.150
     5.606   146.797     0.150
     5.606   172.594     0.150
     6.364   114.195     0.150
     6.364   114.094     0.150
     6.364    94.195     0.150
     6.364   114.195     0.150
     6.364   197.195     0.150
     6.607   115.594     0.150
     6.607    98.000     0.150
     6.607   169.094     0.150
     6.607   204.195     0.150
     7.446   130.398     0.150
     7.446   110.898     0.150
     7.446   191.398     0.150
     7.446   230.195     0.150
     8.714   129.477     0.150
     8.714   275.953     0.150
    23.631   314.773     0.150
    47.513   516.000     0.150
    47.513   516.500     0.150
     0.193     3.813     0.150
     0.193     6.113     0.150
     0.193     3.913     0.150
     0.193     6.513     0.150
     0.822    16.613     0.150
     0.822    28.613     0.150
     0.822    16.013     0.150
     0.822    16.613     0.150
     0.822    26.713     0.150
     0.822    28.613     0.150
     1.055    19.713     0.150
     1.055    19.713     0.150
     1.055    34.213     0.150
     1.402    44.313     0.150
     1.402    25.413     0.150
     1.402    44.313     0.150
     1.531    47.313     0.150
     1.531    27.413     0.150
     1.531    47.013     0.150
     1.531    27.713     0.150
     1.531    47.313     0.150
     1.989    35.813     0.150
     1.989    35.013     0.150
     1.989    35.813     0.150
     1.989    62.313     0.150
     1.989    63.313     0.150
     2.332    41.813     0.150
     2.332    39.613     0.150
     2.332    41.813     0.150
     2.332    69.613     0.150
     2.332    72.813     0.150
     2.656    83.713     0.150
     2.656    45.013     0.150
     2.656    49.113     0.150
     2.656    83.613     0.150
     3.366    53.213     0.150
     3.366    60.813     0.150
     3.366    92.513     0.150
     3.366   103.513     0.150
     4.094    74.913     0.150
     4.094    63.313     0.150
     4.094    74.913     0.150
     4.094   110.013     0.150
     4.094   127.913     0.150
     4.297    85.613     0.150
     4.297    85.613     0.150
     4.297   133.713     0.150
     4.364    79.113     0.150
     4.364   136.413     0.150
     5.513   123.413     0.150
     5.513   123.413     0.150
     5.513   169.713     0.150
     5.853   135.813     0.150
     5.853   135.813     0.150
     5.853   183.313     0.150
     6.106   132.213     0.150
     6.106   132.213     0.150
     6.106   190.113     0.150
     6.657   121.213     0.150
     6.657   189.413     0.150
     6.657   121.213     0.150
     6.657   189.413     0.150
     6.657   207.813     0.150
     8.872   223.313     0.150
     0.020     2.949     0.150
     0.020     5.449     0.150
     0.644    12.148     0.150
     0.644    21.551     0.150
     0.713    12.148     0.150
     0.713    20.949     0.150
     1.273    22.449     0.150
     1.273    39.648     0.150
     1.449    30.449     0.150
     1.449    25.250     0.150
     1.449    25.250     0.150
     1.449    30.449     0.150
     1.449    44.148     0.150
     1.551    27.352     0.150
     1.551    27.352     0.150
     1.551    27.648     0.150
     1.551    48.648     0.150
     2.357    45.449     0.150
     2.357    37.250     0.150
     2.357    40.551     0.150
     2.357    45.449     0.150
     2.357    71.250     0.150
     2.352    43.148     0.150
     2.352    38.449     0.150
     2.352    43.148     0.150
     2.352    73.449     0.150
     2.801    44.551     0.150
     2.801    50.148     0.150
     2.801    75.051     0.150
     2.801    86.250     0.150
     2.948    46.750     0.150
     2.948    46.750     0.150
     2.948    51.949     0.150
     2.948    90.551     0.150
     3.463    58.750     0.150
     3.463    62.148     0.150
     3.463    58.750     0.150
     3.463    62.148     0.150
     3.463   107.551     0.150
     3.628    62.750     0.150
     3.628    65.750     0.150
     3.628    62.750     0.150
     3.628    65.750     0.150
     3.628    97.551     0.150
     3.628   113.051     0.150
     3.628   116.750     0.150
     3.782    57.750     0.150
     3.782    57.750     0.150
     3.782    68.148     0.150
     3.782   100.148     0.150
     3.782   118.551     0.150
     3.977    99.051     0.150
     3.977    60.551     0.150
     3.977    70.648     0.150
     3.977    99.051     0.150
     3.977   121.750     0.150
     4.261    76.449     0.150
     4.261    65.051     0.150
     4.261    76.449     0.150
     4.261   131.449     0.150
     4.826    86.750     0.150
     4.826    86.750     0.150
     4.826   149.852     0.150
     5.086    92.250     0.150
     5.086    92.250     0.150
     5.086   155.648     0.150
     5.549    99.949     0.150
     5.549   173.648     0.150
     5.549    82.852     0.150
     5.549    99.949     0.150
     5.549   173.648     0.150
     5.834   105.148     0.150
     5.834   162.750     0.150
     5.834   182.148     0.150
     5.834    85.551     0.150
     5.834   105.148     0.150
     5.834   162.750     0.150
     5.834   182.148     0.150
     7.557   140.750     0.150
     7.557   233.750     0.150
     7.557   140.750     0.150
     7.557   233.750     0.150
    10.583   157.250     0.150
     0.564    16.973     0.150
     0.564    10.672     0.150
     0.774    14.875     0.150
     0.774    17.473     0.150
     0.774    30.875     0.150
     1.591    29.074     0.150
     1.795    30.973     0.150
     1.795    54.973     0.150
     1.795    30.973     0.150
     1.895    57.574     0.150
     1.895    33.172     0.150
     1.895    34.375     0.150
     1.895    36.875     0.150
     2.267    38.672     0.150
     2.267    46.375     0.150
     2.226    38.273     0.150
     2.226    38.273     0.150
     2.226    38.273     0.150
     2.226    71.074     0.150
     3.128    62.074     0.150
     3.566    56.273     0.150
     3.566    64.375     0.150
     3.566   101.273     0.150
     3.494    55.574     0.150
     3.494    55.574     0.150
     3.494    55.574     0.150
     4.086    69.473     0.150
     4.086   105.375     0.150
     4.384    80.473     0.150
     4.694    84.672     0.150
     4.694    71.473     0.150
     4.694    71.672     0.150
     4.694    71.672     0.150
     4.694    75.773     0.150
     4.694    85.074     0.150
     4.694   142.574     0.150
     5.021    77.273     0.150
     5.021   143.375     0.150
     5.021   161.273     0.150
     5.576   101.773     0.150
     5.591    89.473     0.150
     5.591    93.172     0.150
     5.591   101.672     0.150
     5.820   105.273     0.150
     5.820    86.875     0.150
     5.820    98.074     0.150
     5.820   110.773     0.150
     5.844    92.172     0.150
     5.844   102.074     0.150
     5.844   108.172     0.150
     5.762   154.273     0.150
     5.786   106.074     0.150
     5.786   156.273     0.150
     5.786   108.473     0.150
     6.409   116.875     0.150
     6.497   118.672     0.150
     6.497   203.473     0.150
     6.497    97.172     0.150
     6.497   119.273     0.150
     6.497   176.473     0.150
     6.497   203.473     0.150
     7.106   110.273     0.150
     7.146   129.773     0.150
     7.146   221.773     0.150
     7.492   232.984     0.150
     7.492   106.773     0.150
     7.492   232.973     0.150
     7.492   137.773     0.150
     7.492   231.473     0.150
     7.677   237.773     0.150
     7.796   141.473     0.150
     7.796   241.875     0.150
     7.796   143.172     0.150
     7.796   224.473     0.150
     7.796   241.375     0.150
     8.262   148.672     0.150
     8.262   255.574     0.150
     8.830   159.574     0.150
     8.830   186.773     0.150
     9.138   245.875     0.150
     9.138   142.273     0.150
     9.138   246.074     0.150
     9.313   138.074     0.150
     9.313   248.574     0.150
     9.646   258.273     0.150
     9.646   139.613     0.150
     9.646   258.273     0.150
     9.812   137.535     0.150
     9.812   137.773     0.150
     9.812   257.574     0.150
    11.400   171.672     0.150
    11.400   321.172     0.150
    12.457   172.273     0.150
    12.457   325.273     0.150
    14.104   204.875     0.150
    14.104     3.398     0.150
    14.104   357.773     0.150
    14.624   217.773     0.150
    14.900   383.172     0.150
    15.344     4.102     0.150
    15.344     8.703     0.150
    15.344   391.074     0.150
    15.344   392.473     0.150
    15.344   404.875     0.150
    15.401   222.973     0.150
    15.401   392.773     0.150
    16.061   405.973     0.150
    16.061   226.074     0.150
    16.061   239.074     0.150
    16.061   405.973     0.150
    16.083   226.172     0.150
    16.788   229.125     0.150
    16.788   403.145     0.150
    16.788   228.875     0.150
    19.311   271.172     0.150
    19.311   489.473     0.150
    19.311   533.875     0.150
    19.649   270.074     0.150
    20.669   648.117     0.150
    21.026   310.273     0.150
    21.262     4.102     0.150
    21.262     7.301     0.150
    21.262    23.699     0.150
    21.262   287.473     0.150
    21.262     4.102     0.150
    21.262     7.301     0.150
    21.262   517.574     0.150
    21.262  1151.773     0.150
    21.262   287.473     0.150
    21.262     4.102     0.150
    21.262   311.172     0.150
    21.262   517.574     0.150
    21.425   287.723     0.150
    21.912   293.074     0.150
    21.967   294.074     0.150
    21.967   294.422     0.150
    22.357   297.273     0.150
    22.357     5.699     0.150
    25.275   325.172     0.150
    25.232   324.898     0.150
    25.432   327.773     0.150
    26.264     5.602     0.150
    26.264     9.000     0.150
    26.264    43.102     0.150
    28.101   354.875     0.150
    30.120     6.203     0.150
    30.120     9.000     0.150
    30.120   768.473     0.150
    32.083     4.699     0.150
    32.083   694.672     0.150
    32.083   807.973     0.150
    32.083   387.375     0.150
    32.083     4.699     0.150
    32.083   453.875     0.150
    32.083   694.672     0.150
    32.083   807.973     0.150
    37.104   441.074     0.150
    38.336   438.973     0.150
    38.905   444.523     0.150
    39.985   453.473     0.150
    42.384   473.273     0.150
    44.184   487.273     0.150
    44.515   491.672     0.150
    46.840   510.199     0.150
    47.524   667.672     0.150
    47.524  1197.574     0.150
    48.096   518.898     0.150
    48.689   523.672     0.150
    50.800   537.273     0.150
    51.893   548.375     0.150
    51.912   548.902     0.150
    51.912   548.875     0.150
    51.912   555.172     0.150
    52.674   558.773     0.150
    52.707   554.773     0.150
    52.720   555.375     0.150
    53.278   560.074     0.150
    53.737   562.773     0.150
    53.737     4.102     0.150
    53.756   563.574     0.150
    53.912   564.473     0.150
    54.278   566.773     0.150
    54.278     3.602     0.150
    54.487   568.574     0.150
    54.487     4.000     0.150
    54.893   570.203     0.150
    54.893   570.172     0.150
    54.901   575.375     0.150
    54.902   570.875     0.150
    54.902   570.945     0.150
    54.902     4.047     0.150
    54.979   570.973     0.150
    54.979   570.875     0.150
    54.979     4.000     0.150
    55.287   575.152     0.150
    55.287   575.172     0.150
    55.671   575.973     0.150
    55.671   575.973     0.150
    56.058   579.375     0.150
    56.058     4.098     0.150
    56.254   580.574     0.150
    56.358   581.672     0.150
    56.358     3.801     0.150
    56.519   582.672     0.150
    56.519   581.988     0.150
    56.651   584.074     0.150
    56.741   588.973     0.150
    56.945   586.172     0.150
    56.945     4.203     0.150
    57.907   592.949     0.150
    58.005   592.172     0.150
    58.012   594.375     0.150
    58.012   594.375     0.150
    59.210   600.773     0.150
    59.524   602.875     0.150
    59.524   602.875     0.150
    59.584   603.672     0.150
    59.584   603.672     0.150
    60.228   607.773     0.150
    60.228   607.773     0.150
    60.287   608.172     0.150
    60.423   609.375     0.150
    61.502   615.773     0.150
    61.502   615.773     0.150
    61.628   619.172     0.150
    61.892   618.773     0.150
    61.892   618.773     0.150
    62.102   621.473     0.150
    62.102   621.473     0.150
    62.109   621.672     0.150
    62.109   621.672     0.150
    62.202   620.973     0.150
    62.202   620.973     0.150
    62.383   621.672     0.150
    62.383   621.672     0.150
    62.384   621.574     0.150
    62.384   621.574     0.150
    62.401   622.074     0.150
    62.401   622.074     0.150
    62.483   622.574     0.150
    62.483   622.574     0.150
    62.495   624.914     0.150
    62.495   624.875     0.150
    62.715   625.773     0.150
    62.715   625.773     0.150
    62.833   624.672     0.150
    62.833   624.672     0.150
    62.876   625.473     0.150
    62.876   625.473     0.150
    63.119   628.375     0.150
    63.119   628.375     0.150
    63.260   627.172     0.150
    63.352   628.672     0.150
    63.352   628.672     0.150
    63.479   630.172     0.150
    63.479   630.172     0.150
    63.501   630.074     0.150
    63.501   630.074     0.150
    63.583   630.074     0.150
    63.583   630.074     0.150
    63.780   631.574     0.150
    63.780   631.574     0.150
    64.029   633.172     0.150
    64.029   633.172     0.150
    64.090   633.672     0.150
    64.090   633.672     0.150
    64.435   635.973     0.150
    65.617   643.074     0.150
    65.760   645.273     0.150
    65.760   645.273     0.150
    66.790   651.273     0.150
    66.790   651.273     0.150
    67.265   653.473     0.150
    67.265   653.473     0.150
    71.531   681.273     0.150
    71.531   681.301     0.150
    71.623   682.375     0.150
    71.954   685.145     0.150
    72.079   685.074     0.150
    72.833   690.875     0.150
    72.952   687.812     0.150
    75.017   701.473     0.150
    77.529   715.156     0.150
    80.141   730.402     0.150
    80.445   731.648     0.150
    80.445   730.375     0.150
    80.700   733.574     0.150
    81.089   734.773     0.150
    82.859   745.172     0.150
    84.419   751.875     0.150
    85.205   756.273     0.150
    86.214   761.473     0.150
    87.320   766.375     0.150
    88.931   774.023     0.150
   136.488  1160.574     0.150
   150.108  1204.273     0.150
   150.108  1188.910     0.150
   151.571  1198.172     0.150
   151.571  1210.273     0.150
   151.571  1229.172     0.150
   151.865  1199.074     0.150
   151.865  1208.574     0.150
   151.865  1229.973     0.150
   152.299  1199.574     0.150
   152.299  1211.973     0.150
   152.299  1231.172     0.150
     0.164     8.195     0.150
     0.164     4.094     0.150
     0.164     8.195     0.150
     0.223     4.492     0.150
     0.223     4.789     0.150
     0.223     8.492     0.150
     1.121    19.695     0.150
     1.121    34.789     0.150
     1.121    19.695     0.150
     1.121    19.695     0.150
     1.121    19.695     0.150
     1.121    34.891     0.150
     1.173    37.492     0.150
     1.173    21.492     0.150
     1.173    38.094     0.150
     1.190    21.695     0.150
     1.190    21.695     0.150
     1.190    21.695     0.150
     1.190    38.391     0.150
     1.342    42.891     0.150
     1.342    25.391     0.150
     1.342    42.891     0.150
     1.342    24.492     0.150
     1.342    25.391     0.150
     1.342    42.891     0.150
     2.252    37.195     0.150
     2.252    39.789     0.150
     2.252    64.891     0.150
     2.252    68.492     0.150
     2.402    75.391     0.150
     2.402    38.789     0.150
     2.402    42.594     0.150
     2.402    75.391     0.150
     2.544    44.891     0.150
     2.544    79.289     0.150
     3.211    50.789     0.150
     3.211    58.594     0.150
     3.211   100.992     0.150
     3.292    51.891     0.150
     3.292    59.094     0.150
     3.292    91.391     0.150
     3.292   101.492     0.150
     3.866    69.992     0.150
     3.866    59.492     0.150
     3.866    69.992     0.150
     3.866   120.289     0.150
     4.220    75.695     0.150
     4.220   130.789     0.150
     4.321   133.289     0.150
     4.452    80.789     0.150
     4.452    68.492     0.150
     4.452    80.789     0.150
     4.452   118.695     0.150
     4.452   138.391     0.150
     4.444    72.891     0.150
     4.444    72.891     0.150
     4.444    79.891     0.150
     4.444   137.695     0.150
     4.756   147.094     0.150
     5.121    93.492     0.150
     5.121    76.195     0.150
     5.121    93.492     0.150
     5.121   159.695     0.150
     5.736   101.695     0.150
     5.736   174.695     0.150
     5.736   101.695     0.150
     5.736   174.695     0.150
     6.369    97.195     0.150
     6.369   115.789     0.150
     6.369   194.695     0.150
     6.382   115.594     0.150
     6.382   115.594     0.150
     6.382   198.594     0.150
     6.750   121.992     0.150
     7.591   114.289     0.150
     7.591   136.195     0.150
     7.591   233.289     0.150
     7.591   192.789     0.150
     7.591   233.289     0.150
     7.675   114.891     0.150
     7.675   114.891     0.150
     7.675   194.695     0.150
     7.675   234.891     0.150
     0.151     6.469     0.150
     0.241     4.969     0.150
     0.241     4.969     0.150
     0.241     9.367     0.150
     1.048    18.570     0.150
     1.048    33.070     0.150
     1.048    18.672     0.150
     1.048    33.070     0.150
     1.048    37.273     0.150
     1.048    18.672     0.150
     1.048    33.070     0.150
     1.048    37.273     0.150
     1.142    20.969     0.150
     1.142    20.969     0.150
     1.142    36.867     0.150
     1.241    23.969     0.150
     1.241    23.969     0.150
     1.241    40.773     0.150
     1.387    25.367     0.150
     1.387    25.367     0.150
     1.387    25.367     0.150
     1.387    26.172     0.150
     2.324    38.172     0.150
     2.324    41.070     0.150
     2.324    66.969     0.150
     2.324    71.273     0.150
     2.484    42.469     0.150
     2.484    48.070     0.150
     2.484    39.773     0.150
     2.484    43.570     0.150
     2.484    48.070     0.150
     2.484    77.969     0.150
     2.474    77.969     0.150
     2.474    41.070     0.150
     2.474    44.773     0.150
     2.474    77.969     0.150
     3.143    50.867     0.150
     3.143    55.570     0.150
     3.143    98.672     0.150
     3.217    51.070     0.150
     3.217    56.367     0.150
     3.217    59.570     0.150
     3.217    90.172     0.150
     3.217    99.469     0.150
     3.939    62.672     0.150
     3.939    73.367     0.150
     3.939    62.969     0.150
     3.939    62.969     0.150
     3.939    70.867     0.150
     3.939   122.070     0.150
     4.249    76.867     0.150
     4.249    76.867     0.150
     4.249   131.969     0.150
     4.378    66.773     0.150
     4.378   116.773     0.150
     4.378   134.773     0.150
     4.375    78.672     0.150
     4.375    66.969     0.150
     4.375    78.672     0.150
     4.375   116.469     0.150
     4.375   136.367     0.150
     4.689   145.867     0.150
     4.870    87.367     0.150
     5.174    93.070     0.150
     5.174    76.867     0.150
     5.174    93.070     0.150
     5.174   133.273     0.150
     5.174   160.172     0.150
     5.619   174.273     0.150
     6.293    95.672     0.150
     6.293   114.469     0.150
     6.293   160.273     0.150
     6.293   192.867     0.150
     6.348   114.367     0.150
     6.348    92.867     0.150
     6.348   114.367     0.150
     6.348   197.672     0.150
     6.673   119.672     0.150
     6.673    97.070     0.150
     6.673   170.969     0.150
     6.673   205.570     0.150
     7.433   132.367     0.150
     7.433   132.367     0.150
     7.433   228.273     0.150
     7.514   135.469     0.150
     7.514   231.867     0.150
     7.514   110.773     0.150
     7.514   192.273     0.150
     7.514   231.070     0.150
     7.599   135.773     0.150
     7.599   234.773     0.150
     7.599   111.273     0.150
     7.599   192.367     0.150
     7.599   234.570     0.150
     0.086     2.113     0.150
     0.086     4.012     0.150
     0.557    10.113     0.150
     0.557    10.512     0.150
     0.557    18.412     0.150
     1.079    18.812     0.150
     1.079    32.713     0.150
     1.079    18.812     0.150
     1.079    32.713     0.150
     1.382    26.713     0.150
     1.382    24.812     0.150
     1.382    43.412     0.150
     1.382    25.012     0.150
     1.382    26.713     0.150
     1.382    43.912     0.150
     1.382    46.912     0.150
     1.790    31.912     0.150
     1.790    55.512     0.150
     1.835    33.213     0.150
     1.835    33.113     0.150
     1.835    33.812     0.150
     1.835    58.613     0.150
     2.325    39.912     0.150
     2.325    39.812     0.150
     2.325    41.613     0.150
     2.325    70.213     0.150
     2.325    73.613     0.150
     2.706    49.312     0.150
     2.706    84.613     0.150
     2.706    49.312     0.150
     2.706    84.713     0.150
     3.187   108.012     0.150
     3.187    51.312     0.150
     3.187    56.012     0.150
     3.187    99.113     0.150
     3.187   108.012     0.150
     3.961    61.812     0.150
     3.961    71.512     0.150
     3.961   108.812     0.150
     3.961   122.912     0.150
     4.032   125.713     0.150
     4.243    65.812     0.150
     4.243    75.412     0.150
     4.243   131.412     0.150
     5.383   166.113     0.150
     5.474   170.312     0.150
     5.935    99.312     0.150
     5.935    99.312     0.150
     5.935   108.213     0.150
     5.935   185.812     0.150
     6.398   183.812     0.150
     6.398   104.912     0.150
     6.398   183.812     0.150
     6.398   197.713     0.150
     7.350   228.312     0.150
     8.818   234.812     0.150
     8.818   234.812     0.150
     8.818   273.012     0.150
     0.400     8.090     0.150
     0.400    13.289     0.150
     1.026    17.889     0.150
     1.669    36.889     0.150
     1.669    52.988     0.150
     1.963    33.389     0.150
     1.963    38.889     0.150
     2.233    36.488     0.150
     2.233    42.090     0.150
     2.233    65.889     0.150
     2.233    69.889     0.150
     2.844    53.988     0.150
     2.844    97.590     0.150
     3.010    47.289     0.150
     3.010    47.289     0.150
     3.010    60.488     0.150
     3.010    93.689     0.150
     3.811    77.090     0.150
     3.811   125.090     0.150
     3.868   120.789     0.150
     3.982    60.189     0.150
     3.982    65.189     0.150
     3.982   109.789     0.150
     4.087    61.988     0.150
     4.087    66.889     0.150
     4.087    74.289     0.150
     4.087   103.289     0.150
     5.222    77.689     0.150
     5.222    92.090     0.150
     5.222   166.988     0.150
     5.297    95.189     0.150
     5.297   104.789     0.150
     5.297   145.789     0.150
     5.525    97.590     0.150
     5.525   100.389     0.150
     5.570    99.889     0.150
     5.570   173.889     0.150
     5.570   221.789     0.150
     6.225   113.590     0.150
     6.225   195.488     0.150
     6.225   112.889     0.150
     6.225   177.289     0.150
     6.225   193.689     0.150
     6.408   116.090     0.150
     6.408   198.488     0.150
     6.510   117.988     0.150
     6.510   157.389     0.150
     6.510   202.689     0.150
     6.538   118.889     0.150
     6.538   202.988     0.150
     6.538   111.689     0.150
     6.538   117.689     0.150
     6.538   221.689     0.150
     7.193   129.289     0.150
     7.193   222.389     0.150
     7.193   103.889     0.150
     7.193   111.689     0.150
     7.193   223.789     0.150
     7.193   133.629     0.150
     7.193   223.090     0.150
     7.647   117.789     0.150
     7.647   130.389     0.150
     7.647   210.289     0.150
     7.647   234.789     0.150
     7.637   195.488     0.150
     7.637   108.189     0.150
     7.637   139.689     0.150
     7.637   237.689     0.150
     7.637   108.250     0.150
     7.637   195.529     0.150
     8.245   121.889     0.150
     8.245   150.189     0.150
     8.245   255.090     0.150
     8.245   122.389     0.150
     8.245   129.590     0.150
     8.245   255.389     0.150
     8.520   149.889     0.150
     8.520   122.889     0.150
     8.520   127.988     0.150
     8.520   149.289     0.150
     8.520   212.389     0.150
     8.520   238.189     0.150
     8.690   154.988     0.150
     8.690   269.590     0.150
     8.690   124.789     0.150
     8.690   124.789     0.150
     8.690   124.789     0.150
     8.690   129.789     0.150
    10.366   269.090     0.150
    12.927   179.289     0.150
    14.312   204.289     0.150
    14.312   213.289     0.150
    14.312   363.090     0.150
    15.096     4.100     0.150
    15.096     6.699     0.150
    15.096   380.889     0.150
    15.096   400.289     0.150
    15.223   216.789     0.150
    15.223     3.699     0.150
    16.550   229.309     0.150
    16.550   516.209     0.150
    17.122   232.889     0.150
    17.122   232.389     0.150
    17.831   454.689     0.150
    18.821     6.500     0.150
    18.821    10.400     0.150
    19.829   492.289     0.150
    20.410     6.699     0.150
    20.410    10.500     0.150
    20.863     7.100     0.150
    20.863    10.100     0.150
    20.863   306.289     0.150
    20.863   506.289     0.150
    21.346   285.789     0.150
    21.346   534.789     0.150
    21.920   291.289     0.150
    22.069     7.000     0.150
    22.069    10.000     0.150
    22.069    25.400     0.150
    22.069   529.090     0.150
    24.118     6.500     0.150
    24.118     9.500     0.150
    24.118    33.799     0.150
    24.118   567.789     0.150
    24.720   323.090     0.150
    24.923   590.176     0.150
    24.968   321.779     0.150
    25.334    11.299     0.150
    25.364     8.699     0.150
    25.892     7.299     0.150
    25.892    10.799     0.150
    25.892    42.500     0.150
    26.053   595.590     0.150
    27.479   345.658     0.150
    28.656   356.590     0.150
    29.916   427.488     0.150
    29.812     5.600     0.150
    29.812    12.000     0.150
    31.718     7.500     0.150
    31.718     9.900     0.150
    34.131   405.289     0.150
    34.609   408.789     0.150
    34.748   410.189     0.150
    36.863   429.789     0.150
    36.894     6.199     0.150
    37.935   439.568     0.150
    38.144   436.689     0.150
    38.714   441.459     0.150
    38.605   442.189     0.150
    38.605     6.061     0.150
    38.951   581.238     0.150
    38.951   444.389     0.150
    38.951   574.488     0.150
    39.684   448.590     0.150
    42.091   468.289     0.150
    43.174   474.389     0.150
    43.174   864.289     0.150
    43.174  1098.189     0.150
    44.208   485.289     0.150
    45.026   495.379     0.150
    45.026     5.141     0.150
    46.296   503.988     0.150
    46.625   507.289     0.150
    47.688   513.209     0.150
    48.225   520.090     0.150
    48.446   519.209     0.150
    50.354   540.289     0.150
    51.372   544.379     0.150
    51.372     5.871     0.150
    51.701   550.889     0.150
    51.701   550.859     0.150
    52.180   549.709     0.150
    52.328   550.189     0.150
    52.328   711.889     0.150
    52.324   554.889     0.150
    52.324   549.328     0.150
    52.324     5.961     0.150
    52.834   554.010     0.150
    53.317   563.789     0.150
    53.317   563.818     0.150
    53.342   553.689     0.150
    53.342   553.689     0.150
    53.448   563.289     0.150
    53.448     0.000     0.150
    53.493   559.078     0.150
    53.765   559.449     0.150
    53.765     6.279     0.150
    53.920   561.389     0.150
    54.023   562.920     0.150
    54.558   565.488     0.150
    54.558     5.791     0.150
    54.558  1039.289     0.150
    54.558  1284.289     0.150
    54.558   565.488     0.150
    54.558     5.791     0.150
    54.558  1039.289     0.150
    54.558  1284.289     0.150
    54.643   566.189     0.150
    54.643     5.199     0.150
    54.643  1258.289     0.150
    54.643   566.189     0.150
    54.643     5.199     0.150
    54.866   564.488     0.150
    54.866   564.439     0.150
    54.902   561.988     0.150
    55.724   589.090     0.150
    55.852   575.699     0.150
    56.156   576.689     0.150
    56.156     5.240     0.150
    56.161   578.090     0.150
    56.161   577.189     0.150
    56.161     5.699     0.150
    56.292   584.590     0.150
    56.292   584.629     0.150
    56.300   578.689     0.150
    56.300   578.689     0.150
    56.606   581.189     0.150
    56.606     5.299     0.150
    56.606   581.189     0.150
    56.606     5.299     0.150
    57.644   589.289     0.150
    58.877   596.689     0.150
    58.946   602.090     0.150
    59.226   604.090     0.150
    59.258   604.590     0.150
    60.110   610.389     0.150
    61.229   613.559     0.150
    61.578   617.189     0.150
    61.578   617.189     0.150
    61.578   617.189     0.150
    61.760   618.689     0.150
    61.760   618.689     0.150
    61.760   618.689     0.150
    61.888   621.988     0.150
    61.888   621.988     0.150
    61.888   621.988     0.150
    62.102   622.988     0.150
    62.102   622.988     0.150
    62.102   622.988     0.150
    62.104   622.988     0.150
    62.104   622.988     0.150
    62.104   622.988     0.150
    62.151   619.479     0.150
    62.368   624.889     0.150
    62.368   624.889     0.150
    62.368   624.889     0.150
    62.554   625.889     0.150
    62.763   627.988     0.150
    62.763   627.988     0.150
    62.763   627.988     0.150
    63.041   629.988     0.150
    63.041   629.988     0.150
    63.041   629.988     0.150
    63.106   630.689     0.150
    63.106   630.689     0.150
    63.106   630.689     0.150
    63.313   631.488     0.150
    63.313   631.488     0.150
    63.313   631.488     0.150
    63.350   631.889     0.150
    63.350   631.889     0.150
    63.350   631.889     0.150
    63.485   628.590     0.150
    63.515   632.988     0.150
    63.515   632.988     0.150
    63.515   632.988     0.150
    63.593   627.988     0.150
    63.734   634.389     0.150
    63.734   634.389     0.150
    63.734   634.389     0.150
    63.822   634.889     0.150
    63.822   634.889     0.150
    63.822   634.889     0.150
    66.003   643.549     0.150
    66.003     6.141     0.150
    66.471   650.488     0.150
    66.471   650.488     0.150
    66.471   650.488     0.150
    67.713   655.840     0.150
    67.932   656.828     0.150
    67.932     5.871     0.150
    71.995   681.723     0.150
    71.995   681.648     0.150
    72.470   685.398     0.150
    72.586   686.209     0.150
    72.586     6.500     0.150
    72.980   688.229     0.150
    73.295   691.578     0.150
    73.649   695.889     0.150
    75.243   701.939     0.150
    75.243     6.180     0.150
    75.447   701.709     0.150
    75.447     6.051     0.150
    76.533   709.059     0.150
    77.557   713.578     0.150
    77.557     5.961     0.150
    77.557     8.740     0.150
    79.057   722.529     0.150
    79.057     6.721     0.150
    79.542   723.619     0.150
    79.542     7.119     0.150
    80.147   727.939     0.150
    80.147     7.080     0.150
    80.615   731.229     0.150
    80.599   730.709     0.150
    80.599   736.760     0.150
    80.599   731.039     0.150
    81.259   735.068     0.150
    83.232     6.191     0.150
    83.328   745.930     0.150
    83.328     6.010     0.150
    84.751   752.279     0.150
    84.751     5.959     0.150
    85.629   756.930     0.150
    89.398   775.189     0.150
    89.398     6.699     0.150
    89.409   775.029     0.150
    89.890   776.898     0.150
    89.890     6.230     0.150
    90.982   781.840     0.150
    90.982     5.719     0.150
    99.816   821.459     0.150
   140.463  1166.760     0.150
   146.727  1186.469     0.150
   151.813  1196.988     0.150
     0.113     2.206     0.150
     0.744    14.006     0.150
     0.744    25.306     0.150
     0.744    14.006     0.150
     0.744    25.306     0.150
     1.024    19.606     0.150
     1.024    38.806     0.150
     1.024    19.706     0.150
     1.360    25.306     0.150
     1.360    29.206     0.150
     1.360    49.806     0.150
     1.360    25.306     0.150
     1.360    43.706     0.150
     1.228    43.006     0.150
     1.228    22.606     0.150
     1.228    39.506     0.150
     1.613    50.106     0.150
     1.613    29.306     0.150
     1.613    29.206     0.150
     1.613    50.106     0.150
     1.918    35.006     0.150
     1.918    35.006     0.150
     1.918    35.406     0.150
     1.918    59.906     0.150
     2.296    39.606     0.150
     2.296    39.606     0.150
     2.296    42.006     0.150
     2.296    73.906     0.150
     2.296    39.206     0.150
     2.296    41.906     0.150
     2.296    69.606     0.150
     2.698    44.906     0.150
     2.698    44.906     0.150
     2.698    44.906     0.150
     2.698    49.806     0.150
     2.698    49.806     0.150
     2.698    55.206     0.150
     2.698    44.906     0.150
     2.698    49.506     0.150
     2.698    84.506     0.150
     3.291    86.206     0.150
     3.291    96.306     0.150
     3.291   110.906     0.150
     3.291    53.006     0.150
     3.291    57.806     0.150
     3.291   101.106     0.150
     4.072    65.806     0.150
     4.072   101.906     0.150
     4.082    63.106     0.150
     4.082    68.606     0.150
     4.082    73.706     0.150
     4.082    76.506     0.150
     4.082    82.006     0.150
     4.082   109.306     0.150
     4.082   131.606     0.150
     4.082    63.106     0.150
     4.082    73.706     0.150
     4.082   109.306     0.150
     4.082   126.806     0.150
     4.218    63.906     0.150
     4.218    75.106     0.150
     4.218   114.006     0.150
     4.218   132.406     0.150
     4.301    79.406     0.150
     4.301    66.806     0.150
     4.301    77.806     0.150
     4.301   132.406     0.150
     5.448    97.606     0.150
     5.448    94.706     0.150
     5.448   103.506     0.150
     5.448    82.706     0.150
     5.448    97.606     0.150
     5.448   143.406     0.150
     5.448   167.206     0.150
     5.577   101.706     0.150
     5.577   131.406     0.150
     5.825   103.406     0.150
     5.825   143.406     0.150
     6.033    88.306     0.150
     6.033   109.106     0.150
     6.033   201.506     0.150
     6.310   113.306     0.150
     6.308   112.906     0.150
     6.308   202.406     0.150
     6.413   115.506     0.150
     6.413   171.506     0.150
     6.413   184.606     0.150
     6.413   209.306     0.150
     6.576   119.806     0.150
     6.576    96.606     0.150
     6.576   105.706     0.150
     6.576   119.606     0.150
     6.576   184.206     0.150
     6.576   218.606     0.150
     6.576    96.606     0.150
     6.576   119.806     0.150
     6.738   136.506     0.150
     6.738   158.306     0.150
     6.745   122.206     0.150
     6.745   122.206     0.150
     6.745   208.906     0.150
     7.407   111.806     0.150
     7.407   134.206     0.150
     7.407   134.406     0.150
     7.407   111.806     0.150
     7.407   134.206     0.150
     7.836   141.006     0.150
     7.836   141.206     0.150
     7.836   141.006     0.150
     7.836   200.006     0.150
     7.920   115.256     0.150
     8.486   123.006     0.150
     8.486   154.206     0.150
     8.486   128.506     0.150
     8.486   146.406     0.150
     8.486   153.906     0.150
     8.486   156.106     0.150
     8.486   154.206     0.150
     8.697   158.306     0.150
     8.697   267.706     0.150
     8.697   139.206     0.150
     8.697   127.006     0.150
     8.697   158.306     0.150
     8.697   267.706     0.150
     8.826   158.506     0.150
     8.826   273.806     0.150
     8.826   139.306     0.150
     8.826   246.706     0.150
     8.826   128.406     0.150
     8.826   158.506     0.150
     8.826   273.806     0.150
     9.279   135.976     0.150
     9.279   294.736     0.150
    10.109   306.596     0.150
    14.575   209.706     0.150
    14.575   215.206     0.150
    14.575   372.406     0.150
    15.214   381.706     0.150
    15.447     3.700     0.150
    15.447     8.200     0.150
    15.447   390.806     0.150
    16.293   237.606     0.150
    16.550   525.729     0.150
    16.792   536.684     0.150
    19.126   270.006     0.150
    21.119   288.206     0.150
    21.119   288.156     0.150
    21.119   675.056     0.150
    21.119   288.206     0.150
    21.198     4.601     0.150
    21.198     7.400     0.150
    21.198   553.406     0.150
    21.345   679.376     0.150
    21.439   679.381     0.150
    21.450   289.316     0.150
    21.450   682.336     0.150
    24.927   323.706     0.150
    26.232     4.200     0.150
    26.232     7.000     0.150
    26.232   379.906     0.150
    27.583   348.187     0.150
    28.751   360.216     0.150
    30.160   431.806     0.150
    30.259   372.456     0.150
    32.059   391.206     0.150
    36.611   418.206     0.150
    37.872   438.506     0.150
    37.872   438.506     0.150
    39.459   449.206     0.150
    39.459   449.206     0.150
    41.862   471.706     0.150
    41.862   471.706     0.150
    46.436   507.816     0.150
    47.520   516.546     0.150
    47.994   521.406     0.150
    47.994   521.376     0.150
    48.195   519.306     0.150
    51.549   546.606     0.150
    52.223   546.806     0.150
    52.696   555.406     0.150
    52.878   558.906     0.150
    53.175   560.206     0.150
    53.337   560.506     0.150
    53.579   560.406     0.150
    53.704   563.266     0.150
    54.344   567.806     0.150
    54.356   567.306     0.150
    54.437   566.206     0.150
    54.437   566.206     0.150
    54.712   570.706     0.150
    54.750   569.906     0.150
    54.750   569.906     0.150
    55.685   579.306     0.150
    55.685   579.306     0.150
    55.807   578.206     0.150
    56.158   581.606     0.150
    61.060   614.826     0.150
    61.949   620.496     0.150
    65.667   644.356     0.150
    70.592   677.626     0.150
    71.682   683.076     0.150
    72.292   687.076     0.150
    75.122   702.626     0.150
    78.739   724.676     0.150
    83.016   747.366     0.150
    83.334   749.146     0.150
    85.302   758.706     0.150
    86.219   762.646     0.150
   149.405  1188.516     0.150
   149.933  1178.606     0.150
   149.933  1178.606     0.150
   149.933  1179.906     0.150
   151.380  1194.206     0.150
   152.116  1196.206     0.150
   152.116  1196.206     0.150
     0.484     9.516     0.150
     0.484    15.312     0.150
     0.484     9.516     0.150
     0.484    15.312     0.150
     0.530    10.414     0.150
     0.530    10.414     0.150
     0.530    10.414     0.150
     0.530    17.812     0.150
     0.796    20.211     0.150
     0.796    31.312     0.150
     0.796    15.312     0.150
     0.796    27.109     0.150
     0.993    18.609     0.150
     0.993    18.609     0.150
     0.993    18.516     0.150
     0.993    18.516     0.150
     0.993    18.516     0.150
     0.993    32.211     0.150
     1.406    25.109     0.150
     1.406    43.914     0.150
     1.877    32.414     0.150
     1.877    32.414     0.150
     1.877    32.211     0.150
     1.877    57.414     0.150
     2.571    42.109     0.150
     2.571    42.109     0.150
     2.776    51.414     0.150
     2.727    44.609     0.150
     2.727    44.609     0.150
     2.727    91.109     0.150
     2.885    45.414     0.150
     2.885    45.414     0.150
     2.885    87.516     0.150
     2.885    45.016     0.150
     2.885    50.414     0.150
     2.885    87.516     0.150
     3.675    55.812     0.150
     3.675    66.211     0.150
     3.675   112.516     0.150
     3.675    55.812     0.150
     3.675    66.211     0.150
     3.675   112.516     0.150
     3.710    74.016     0.150
     3.710   102.812     0.150
     3.710   122.109     0.150
     3.881    60.016     0.150
     3.881    60.016     0.150
     3.881    76.711     0.150
     3.881    60.312     0.150
     3.881    69.609     0.150
     3.881   105.016     0.150
     3.881   118.914     0.150
     4.111    74.609     0.150
     4.111    78.609     0.150
     4.247    83.914     0.150
     4.247    77.109     0.150
     4.247    77.109     0.150
     4.297   109.914     0.150
     4.297   136.711     0.150
     4.297    78.812     0.150
     4.297    78.812     0.150
     4.541    69.211     0.150
     4.541    69.211     0.150
     4.541    81.609     0.150
     4.541    83.516     0.150
     5.166    76.516     0.150
     5.166    76.516     0.150
     5.166    81.312     0.150
     5.166    92.414     0.150
     5.166    92.016     0.150
     5.166   161.109     0.150
     5.166    76.414     0.150
     5.166    92.016     0.150
     5.166   161.109     0.150
     5.166    93.609     0.150
     5.166    93.812     0.150
     5.166    93.812     0.150
     5.166   158.109     0.150
     5.170    76.914     0.150
     5.170    76.914     0.150
     5.170    82.211     0.150
     5.170    92.711     0.150
     5.758    91.414     0.150
     5.758    96.711     0.150
     5.758   102.211     0.150
     5.758   182.914     0.150
     5.831    94.016     0.150
     5.831   105.609     0.150
     5.831   176.516     0.150
     5.831   105.516     0.150
     5.831    85.516     0.150
     5.831   105.516     0.150
     5.831   150.812     0.150
     5.831   177.812     0.150
     6.007    94.914     0.150
     6.007   108.711     0.150
     6.257   111.711     0.150
     6.257    91.211     0.150
     6.257   111.711     0.150
     6.257   159.016     0.150
     6.257   192.414     0.150
     6.929   101.609     0.150
     6.929   101.609     0.150
     6.929   125.812     0.150
     6.929   101.609     0.150
     6.929   126.914     0.150
     6.929   215.914     0.150
     6.929   101.609     0.150
     6.929   126.914     0.150
     6.929   215.914     0.150
     7.123   109.711     0.150
     7.123   125.016     0.150
     7.123   129.109     0.150
     7.123   228.914     0.150
     7.123   104.711     0.150
     7.123   104.711     0.150
     7.123   181.516     0.150
     7.123   218.109     0.150
     7.750   119.109     0.150
     7.750   139.609     0.150
     7.750   240.211     0.150
     7.760   120.312     0.150
     7.760   139.711     0.150
     7.760   213.016     0.150
     7.760   239.516     0.150
     7.808   120.516     0.150
     7.808   141.109     0.150
     7.808   186.109     0.150
     7.808   243.109     0.150
     7.808   203.016     0.150
     8.139   118.734     0.150
     8.139   209.133     0.150
     8.139   258.055     0.150
    13.999   194.516     0.150
    14.568     3.500     0.150
    14.568   219.516     0.150
    14.568   370.414     0.150
    14.816   217.312     0.150
    14.816   376.609     0.150
    14.828   216.211     0.150
    15.278   214.344     0.150
    15.278   214.336     0.150
    15.278   480.109     0.150
    15.731   225.109     0.150
    15.945   405.211     0.150
    15.972   403.812     0.150
    16.229   407.109     0.150
    17.710   250.016     0.150
    17.710     3.398     0.150
    17.973   245.516     0.150
    17.939   464.914     0.150
    19.014     6.703     0.150
    19.014    13.703     0.150
    19.014   470.312     0.150
    19.951   270.859     0.150
    19.951   622.891     0.150
    19.951   270.859     0.150
    19.951   622.898     0.150
    19.962   490.812     0.150
    21.376   293.312     0.150
    21.376     4.000     0.150
    21.420     3.500     0.150
    21.420     6.500     0.150
    23.027   305.836     0.150
    23.722   310.320     0.150
    23.722   579.695     0.150
    23.722   310.328     0.150
    23.722   579.695     0.150
    25.043     4.203     0.150
    25.043     7.203     0.150
    25.043    37.797     0.150
    25.108   333.016     0.150
    25.319   323.211     0.150
    26.084   333.539     0.150
    26.177   337.641     0.150
    26.357   333.570     0.150
    26.891   340.844     0.150
    26.891   340.836     0.150
    26.882   340.992     0.150
    26.882   843.703     0.150
    27.266   344.344     0.150
    27.691   631.516     0.150
    27.965   356.211     0.150
    28.222   358.516     0.150
    28.222     5.797     0.150
    28.222     8.695     0.150
    28.814   357.172     0.150
    28.905   418.312     0.150
    28.905   747.016     0.150
    29.403   364.953     0.150
    30.877     5.797     0.150
    30.877     7.898     0.150
    37.448   431.391     0.150
    37.793   433.609     0.150
    37.793   433.562     0.150
    37.690   434.781     0.150
    38.038   437.914     0.150
    38.038   572.516     0.150
    38.363   439.039     0.150
    38.363   572.812     0.150
    39.077   444.016     0.150
    40.594   454.109     0.150
    40.594  1008.211     0.150
    41.499   464.414     0.150
    41.942   468.836     0.150
    44.037   487.031     0.150
    44.037   487.039     0.150
    44.341   493.016     0.150
    44.341   487.109     0.150
    44.341   493.016     0.150
    45.348   494.312     0.150
    45.866   502.172     0.150
    45.881   601.312     0.150
    45.881   907.711     0.150
    45.881  1102.711     0.150
    45.881  1156.516     0.150
    46.216   504.305     0.150
    46.251   504.516     0.150
    46.783   507.484     0.150
    46.783   507.484     0.150
    46.795   507.352     0.150
    47.015   518.516     0.150
    47.516   514.195     0.150
    47.665   515.461     0.150
    47.792   516.039     0.150
    47.902   516.789     0.150
    47.966   516.812     0.150
    47.966   516.836     0.150
    49.397   527.312     0.150
    49.889   542.109     0.150
    50.015   532.312     0.150
    50.582   537.484     0.150
    50.621   538.414     0.150
    50.652   538.516     0.150
    50.652   538.609     0.150
    50.977   540.711     0.150
    51.227   543.109     0.150
    51.277   543.109     0.150
    51.336   543.414     0.150
    51.329   542.453     0.150
    51.418   543.914     0.150
    51.604   545.109     0.150
    51.747   543.914     0.150
    51.758   547.016     0.150
    51.836   548.016     0.150
    51.838   547.812     0.150
    51.874   547.516     0.150
    52.375   551.414     0.150
    52.504   552.211     0.150
    52.600   553.312     0.150
    52.662   562.609     0.150
    52.662   553.516     0.150
    52.662  1238.516     0.150
    52.984   555.414     0.150
    53.141   563.109     0.150
    53.141   566.711     0.150
    53.141   557.211     0.150
    53.141  1250.414     0.150
    53.171   566.609     0.150
    53.171   557.312     0.150
    53.281   558.312     0.150
    53.806   568.109     0.150
    53.806   562.109     0.150
    53.943   561.812     0.150
    53.943  1039.312     0.150
    53.943  1236.312     0.150
    53.943  1276.312     0.150
    54.204   570.711     0.150
    54.204   574.516     0.150
    54.204   564.914     0.150
    54.271   571.609     0.150
    54.271   565.109     0.150
    54.308   565.016     0.150
    54.694   568.211     0.150
    54.694     9.500     0.150
    54.963   570.312     0.150
    54.997   569.516     0.150
    54.997   569.516     0.150
    55.029   570.609     0.150
    55.029     6.203     0.150
    55.029     9.602     0.150
    55.258   577.711     0.150
    55.258   582.109     0.150
    55.258   572.312     0.150
    55.258   572.273     0.150
    55.328   572.812     0.150
    55.410   573.414     0.150
    55.410     9.500     0.150
    55.410   573.016     0.150
    55.564   574.812     0.150
    55.564     6.297     0.150
    55.564     9.602     0.150
    55.900   577.109     0.150
    56.711   582.414     0.150
    56.711     6.297     0.150
    57.004   585.109     0.150
    57.129   583.859     0.150
    58.106   592.211     0.150
    58.185   592.609     0.150
    58.580   595.312     0.150
    58.580   595.312     0.150
    58.614   595.109     0.150
    58.614   595.109     0.150
    58.781   596.844     0.150
    59.136   599.109     0.150
    59.218   599.312     0.150
    59.218   599.312     0.150
    59.291   599.914     0.150
    59.291   599.914     0.150
    59.463   601.312     0.150
    59.698   602.609     0.150
    60.480   608.109     0.150
    60.480   608.109     0.150
    60.927   610.711     0.150
    61.044   612.711     0.150
    61.044   612.711     0.150
    61.050   613.016     0.150
    61.050   613.016     0.150
    61.239   612.914     0.150
    61.239   612.914     0.150
    61.429   614.883     0.150
    61.640   616.016     0.150
    61.640   616.016     0.150
    61.888   618.016     0.150
    61.888   618.016     0.150
    62.014   618.516     0.150
    62.014   618.516     0.150
    62.317   620.812     0.150
    62.317   620.812     0.150
    62.398   620.914     0.150
    62.398   620.914     0.150
    62.469   621.711     0.150
    62.469   621.711     0.150
    62.607   622.211     0.150
    62.607   622.211     0.150
    62.762   623.914     0.150
    63.128   625.609     0.150
    63.128   625.609     0.150
    63.444   628.711     0.150
    68.888   664.062     0.150
    69.054   664.391     0.150
    70.114   669.688     0.150
    70.405   672.391     0.150
    72.325   682.586     0.150
    73.081   689.453     0.150
    73.053   689.414     0.150
    73.101   689.414     0.150
    73.762   693.852     0.150
    76.231   708.266     0.150
    76.269   707.094     0.150
    76.458   707.844     0.150
    77.062   712.492     0.150
    77.450   715.086     0.150
    77.665   716.539     0.150
    77.596   714.289     0.150
    77.942   718.023     0.150
    79.819   725.914     0.150
    79.942   727.547     0.150
    79.952   728.992     0.150
    80.113   729.453     0.150
    80.113   729.531     0.150
    80.783   733.250     0.150
    81.114   733.711     0.150
    82.430   741.336     0.150
    84.421   751.891     0.150
    86.625   763.016     0.150
    89.974   778.766     0.150
    90.486   781.688     0.150
    90.759   780.539     0.150
    98.845   818.336     0.150
   136.312  1158.461     0.150
   140.213  1167.734     0.150
   145.163  1173.664     0.150
   147.252  1182.984     0.150
   148.495  1183.719     0.150
   148.495  1183.727     0.150
   149.762  1187.336     0.150
     0.021     3.423     0.150
     0.021     6.823     0.150
     0.021     6.823     0.150
     0.384     7.523     0.150
     0.384     7.523     0.150
     0.384    13.323     0.150
     1.015    18.823     0.150
     1.015    22.423     0.150
     1.015    32.823     0.150
     1.015    18.823     0.150
     1.015    32.724     0.150
     1.234    22.623     0.150
     1.234    22.623     0.150
     1.234    22.623     0.150
     1.234    22.623     0.150
     1.234    39.224     0.150
     1.288    24.323     0.150
     1.288    29.724     0.150
     1.288    23.224     0.150
     1.288    40.923     0.150
     1.288    23.423     0.150
     1.288    24.423     0.150
     1.288    43.523     0.150
     1.288    23.423     0.150
     1.288    40.923     0.150
     3.360    72.323     0.150
     3.698    67.724     0.150
     3.698    67.724     0.150
     3.698   114.523     0.150
     4.240    65.623     0.150
     4.609   144.724     0.150
     4.630    84.323     0.150
     4.630    86.623     0.150
     4.892    77.323     0.150
     4.892    87.523     0.150
     4.990    88.923     0.150
     4.990   136.724     0.150
     6.436   115.724     0.150
     6.436    96.224     0.150
     6.436   116.224     0.150
     6.436   199.123     0.150
     6.436   115.724     0.150
     6.436   197.823     0.150
     6.531   116.323     0.150
     6.531   181.523     0.150
     6.531   199.623     0.150
     6.531   206.423     0.150
     6.531    96.724     0.150
     6.531   116.323     0.150
     6.531   199.623     0.150
     6.916   122.923     0.150
     6.916   128.823     0.150
     6.916   187.123     0.150
     6.916   213.823     0.150
     6.916   219.123     0.150
     6.916   212.823     0.150
     7.664   237.724     0.150
     7.758   137.724     0.150
     7.758   239.023     0.150
     7.758   121.923     0.150
     7.758   137.823     0.150
     7.758   238.523     0.150
     7.758   113.123     0.150
     7.758   137.724     0.150
     7.758   239.023     0.150
     7.844   139.724     0.150
     7.844   239.523     0.150
     7.844   140.423     0.150
     7.844   241.923     0.150
     7.844   114.023     0.150
     7.844   139.724     0.150
     7.844   239.523     0.150
     0.112     2.156     0.150
     0.112     2.156     0.150
     0.112     3.555     0.150
     0.741    15.953     0.150
     0.741    29.656     0.150
     0.741    14.055     0.150
     0.741    15.953     0.150
     0.741    24.555     0.150
     0.741    29.656     0.150
     1.045    19.555     0.150
     1.045    34.055     0.150
     1.208    24.656     0.150
     1.208    42.754     0.150
     1.208    22.555     0.150
     1.208    39.055     0.150
     1.208    22.555     0.150
     1.208    24.656     0.150
     1.208    39.055     0.150
     1.208    42.754     0.150
     1.380    27.055     0.150
     1.380    47.254     0.150
     1.380    44.453     0.150
     1.380    25.254     0.150
     1.380    27.055     0.150
     1.380    44.555     0.150
     1.380    47.254     0.150
     1.612    50.656     0.150
     1.612    29.156     0.150
     1.612    50.656     0.150
     1.612    52.555     0.150
     1.931    37.855     0.150
     1.931    34.754     0.150
     1.931    37.855     0.150
     1.931    61.055     0.150
     2.316    70.953     0.150
     2.316    40.055     0.150
     2.316    40.055     0.150
     2.316    41.953     0.150
     2.316    70.953     0.150
     2.316    74.055     0.150
     2.679    49.656     0.150
     2.679    44.855     0.150
     2.679    49.754     0.150
     2.679    84.656     0.150
     3.303    53.156     0.150
     3.303    59.656     0.150
     3.303   102.656     0.150
     3.605    58.156     0.150
     3.605    65.656     0.150
     3.605   112.855     0.150
     4.062   108.855     0.150
     4.062   131.555     0.150
     4.062    63.453     0.150
     4.062    63.453     0.150
     4.062    73.855     0.150
     4.062   108.855     0.150
     4.062   127.055     0.150
     4.062   131.555     0.150
     4.216   133.355     0.150
     4.317    72.055     0.150
     4.317    72.055     0.150
     4.317    76.355     0.150
     4.317   116.055     0.150
     4.317   133.855     0.150
     4.498    75.156     0.150
     4.498   103.855     0.150
     4.498    69.656     0.150
     4.498    75.156     0.150
     4.498    81.156     0.150
     4.498   103.855     0.150
     4.498   140.355     0.150
     7.853   252.453     0.150
     8.501   268.855     0.150
     0.079     3.383     0.150
     0.079     3.480     0.150
     0.079     6.480     0.150
     0.552    10.883     0.150
     0.552    10.883     0.150
     0.552    19.383     0.150
     1.044    39.082     0.150
     1.044    18.980     0.150
     1.044    18.883     0.150
     1.044    33.383     0.150
     1.044    39.082     0.150
     1.346    24.883     0.150
     1.346    43.281     0.150
     1.346    23.883     0.150
     1.346    23.980     0.150
     1.346    24.883     0.150
     1.346    41.781     0.150
     1.346    43.281     0.150
     1.803    32.082     0.150
     1.803    32.082     0.150
     1.803    34.680     0.150
     1.803    31.180     0.150
     1.803    32.180     0.150
     1.803    31.180     0.150
     1.803    32.082     0.150
     1.803    32.082     0.150
     1.803    32.082     0.150
     1.803    34.680     0.150
     1.803    57.180     0.150
     1.800    29.980     0.150
     1.800    30.980     0.150
     1.800    54.082     0.150
     2.289    42.781     0.150
     2.289    37.582     0.150
     2.289    37.582     0.150
     2.289    40.680     0.150
     2.289    42.781     0.150
     2.289    70.980     0.150
     2.742    54.680     0.150
     2.742    43.680     0.150
     2.742    49.781     0.150
     2.742    54.680     0.150
     2.742    85.582     0.150
     3.158    52.480     0.150
     3.158    49.383     0.150
     3.158    52.480     0.150
     3.158    56.281     0.150
     3.158    97.582     0.150
     3.658    64.980     0.150
     3.658   112.680     0.150
     4.026   126.281     0.150
     3.992    65.680     0.150
     3.992    60.781     0.150
     3.992    72.680     0.150
     3.992   125.582     0.150
     3.992    60.781     0.150
     3.992    65.680     0.150
     3.992   105.582     0.150
     3.992   125.582     0.150
     4.210    80.680     0.150
     4.210    64.082     0.150
     4.210    64.082     0.150
     4.210    75.582     0.150
     4.210    80.680     0.150
     4.210   131.082     0.150
     4.531    70.082     0.150
     4.531    82.180     0.150
     4.531    70.082     0.150
     4.531    82.180     0.150
     4.531   139.883     0.150
     5.133    92.180     0.150
     5.133    92.180     0.150
     5.133   160.383     0.150
     5.350    94.781     0.150
     5.350   151.180     0.150
     5.350    80.180     0.150
     5.350    94.781     0.150
     5.350   151.180     0.150
     5.350   165.281     0.150
     5.446    97.383     0.150
     5.446   156.082     0.150
     5.446    97.383     0.150
     5.446   156.082     0.150
     5.446   168.582     0.150
     5.906    86.180     0.150
     5.906   106.883     0.150
     5.906   170.480     0.150
     5.906   190.383     0.150
     5.906    86.180     0.150
     5.906   106.883     0.150
     5.906   170.480     0.150
     5.906   184.582     0.150
     5.906   190.383     0.150
     6.387   101.680     0.150
     6.387   116.281     0.150
     6.387   115.383     0.150
     6.387   198.582     0.150
     6.387    92.582     0.150
     6.387   101.680     0.150
     6.387   116.281     0.150
     6.387   199.680     0.150
     6.310    97.082     0.150
     6.310    92.582     0.150
     6.310    97.082     0.150
     6.310   196.883     0.150
     7.317   128.883     0.150
     7.761   139.281     0.150
     7.761   139.180     0.150
     7.761   139.281     0.150
     7.761   240.281     0.150
     8.380   147.883     0.150
     8.782   126.582     0.150
     8.782   272.582     0.150
    21.426   290.781     0.150
     1.060    22.840     0.150
     1.060    38.141     0.150
     1.060    19.039     0.150
     1.276    25.441     0.150
     1.276    39.641     0.150
     1.276    44.441     0.150
     1.577    57.238     0.150
     1.793    33.941     0.150
     1.793    30.539     0.150
     1.793    54.738     0.150
     1.985    32.441     0.150
     1.985    36.238     0.150
     2.528    65.141     0.150
     2.528    79.441     0.150
     3.314    63.039     0.150
     3.438    53.539     0.150
     3.506    92.539     0.150
     3.774    73.340     0.150
     3.774   123.340     0.150
     3.774    56.340     0.150
     3.774    66.039     0.150
     4.405   110.141     0.150
     4.405   140.641     0.150
     5.308    90.941     0.150
     5.308   126.340     0.150
     5.538    94.840     0.150
     5.538    99.539     0.150
     5.538    99.738     0.150
     5.881   197.840     0.150
     6.066    93.539     0.150
     6.066   109.941     0.150
     6.066   115.641     0.150
     6.066   201.441     0.150
     6.080   109.539     0.150
     6.080   117.641     0.150
     6.080   190.641     0.150
     6.102   176.141     0.150
     6.148   110.840     0.150
     6.148   130.141     0.150
     6.413   117.039     0.150
     6.413   185.840     0.150
     6.413   204.641     0.150
     6.413   114.840     0.150
     6.826   120.441     0.150
     6.826   151.539     0.150
     6.856   124.738     0.150
     7.510   119.340     0.150
     7.510   136.738     0.150
     7.510   136.879     0.150
     7.510   229.828     0.150
     7.510   238.711     0.150
     7.510   133.539     0.150
     7.510   233.039     0.150
     7.621   138.738     0.150
     7.621   242.988     0.150
     7.621   109.641     0.150
     7.965   137.340     0.150
     7.965   256.238     0.150
     7.965   141.441     0.150
     8.559   271.141     0.150
     8.837   140.641     0.150
     8.837   172.941     0.150
     8.837   241.441     0.150
     8.837   159.941     0.150
     8.837   274.641     0.150
     9.002   164.039     0.150
     9.002   251.641     0.150
     9.227   165.539     0.150
     9.227   262.738     0.150
     9.227   295.039     0.150
     9.449   299.473     0.150
    10.059   310.488     0.150
    10.059   136.238     0.150
    16.472   522.613     0.150
    16.815   530.465     0.150
    16.899   231.770     0.150
    16.899   233.641     0.150
    17.806   244.879     0.150
    17.806   429.215     0.150
    18.342   251.941     0.150
    21.652   289.090     0.150
    25.212   326.238     0.150
    44.799   493.270     0.150
    77.604   719.641     0.150
    77.604   719.641     0.150
     1.041    41.641     0.150
     1.041    19.539     0.150
     1.377    25.242     0.150
     1.614    29.344     0.150
     1.614    29.344     0.150
     1.614    49.242     0.150
     1.928    34.844     0.150
     1.928    61.141     0.150
     2.312    74.039     0.150
     3.299    86.039     0.150
     4.725    60.742     0.150
     5.459    77.039     0.150
     5.459   115.141     0.150
     5.459    81.039     0.150
     6.042   101.641     0.150
     6.042   201.742     0.150
     6.370   201.938     0.150
     6.292   113.141     0.150
     6.292   127.844     0.150
     6.292   202.938     0.150
     6.292   115.844     0.150
     6.574   125.344     0.150
     6.574   188.539     0.150
     6.574    96.844     0.150
     6.574   118.344     0.150
     6.574   205.742     0.150
     6.749   113.641     0.150
     6.749   217.742     0.150
     7.849   211.938     0.150
     8.711   138.438     0.150
     8.711   225.641     0.150
     8.711   139.938     0.150
     8.841   143.539     0.150
     8.841   236.844     0.150
     8.841   159.938     0.150
     8.841   273.438     0.150
    14.561   225.938     0.150
    42.341   478.141     0.150
     0.242     7.723     0.150
     0.242    13.121     0.150
     0.242     5.121     0.150
     0.242    10.223     0.150
     0.605    16.824     0.150
     1.077    21.523     0.150
     1.077    19.723     0.150
     1.414    25.523     0.150
     1.414    25.523     0.150
     1.414    27.324     0.150
     1.414    25.523     0.150
     1.520    29.121     0.150
     1.520    26.824     0.150
     1.939    38.922     0.150
     1.939    54.324     0.150
     2.808    89.523     0.150
     3.466    63.422     0.150
     3.651    56.422     0.150
     4.239    83.324     0.150
     4.239    76.621     0.150
     4.398   114.023     0.150
     4.655    84.324     0.150
     4.655   152.121     0.150
     4.757    76.723     0.150
     4.757    84.723     0.150
     4.790    78.621     0.150
     4.790    84.922     0.150
     4.809    75.422     0.150
     4.809    85.723     0.150
     5.058    74.121     0.150
     5.058    90.723     0.150
     5.255   140.422     0.150
     5.727    82.324     0.150
     5.727    89.324     0.150
     5.727   100.422     0.150
     5.727   182.223     0.150
     6.096    92.922     0.150
     6.096   109.223     0.150
     6.322    96.121     0.150
     6.322   112.824     0.150
     6.322   177.223     0.150
     6.480   102.824     0.150
     6.480   115.621     0.150
     6.480   121.324     0.150
     6.480   204.223     0.150
     6.480   115.422     0.150
     6.480   200.723     0.150
     6.741   197.824     0.150
     7.092   108.422     0.150
     7.092   126.324     0.150
     7.092   198.023     0.150
     7.134   127.621     0.150
     7.134   194.621     0.150
     7.863   135.023     0.150
     7.981   144.023     0.150
     7.981   143.922     0.150
     8.073   148.922     0.150
     8.073   201.523     0.150
     8.073   257.824     0.150
    13.735   189.098     0.150
    15.776   223.723     0.150
    17.069   229.781     0.150
    20.613   274.992     0.150
    41.808   471.836     0.150
    46.879   512.707     0.150
    46.879   512.723     0.150
    47.431   514.773     0.150
    47.740   517.730     0.150
     1.234    26.094     0.150
     1.234    22.395     0.150
     1.403    24.992     0.150
     1.819    60.492     0.150
     1.819    32.395     0.150
     1.847    54.195     0.150
     1.847    55.094     0.150
     2.346    47.895     0.150
     2.346    69.695     0.150
     2.704    55.094     0.150
     3.161    49.492     0.150
     3.518   111.895     0.150
     3.915    64.793     0.150
     3.915    67.492     0.150
     3.915   126.895     0.150
     3.915   122.195     0.150
     4.234    79.395     0.150
     4.481   126.895     0.150
     5.181    93.695     0.150
     5.370    95.695     0.150
     5.370    95.492     0.150
     5.448    97.395     0.150
     5.720   166.293     0.150
     5.720   197.492     0.150
     6.279   114.293     0.150
     6.275   112.594     0.150
     6.342   114.395     0.150
     6.342   201.094     0.150
     6.342   113.293     0.150
     6.342   196.793     0.150
     6.659   101.594     0.150
     6.659   118.594     0.150
     6.659   221.293     0.150
     6.898   108.895     0.150
     6.898   120.793     0.150
     7.340   109.395     0.150
     7.340   130.895     0.150
     7.340   135.094     0.150
     7.340   133.492     0.150
     7.340   227.094     0.150
     7.669   171.492     0.150
     7.791   245.293     0.150
     8.143   153.793     0.150
     8.395   149.594     0.150
     8.395   273.695     0.150
     8.395   111.293     0.150
     8.663   129.695     0.150
     8.663   234.293     0.150
     8.824   235.293     0.150
     9.102   219.992     0.150
     9.318   294.750     0.150
    21.475   290.992     0.150
    21.519   290.570     0.150
     0.269    12.344     0.150
     0.269     5.445     0.150
     0.269    10.039     0.150
     0.580    18.742     0.150
     0.580    10.844     0.150
     0.580    18.344     0.150
     0.772    17.344     0.150
     0.994    18.742     0.150
     0.994    18.742     0.150
     0.994    20.844     0.150
     0.994    36.344     0.150
     1.515    48.344     0.150
     2.010    64.039     0.150
     2.717    44.445     0.150
     3.398    56.039     0.150
     3.478    52.844     0.150
     3.478    60.242     0.150
     3.478    66.641     0.150
     3.591    61.344     0.150
     4.083    74.141     0.150
     4.124   103.641     0.150
     4.124    71.945     0.150
     4.583   146.641     0.150
     4.737    73.844     0.150
     4.737    85.445     0.150
     4.737    85.242     0.150
     4.677    82.945     0.150
     4.677   149.844     0.150
     4.747   139.445     0.150
     4.747    71.945     0.150
     4.747    84.945     0.150
     4.975    88.945     0.150
     4.975   102.945     0.150
     5.298    94.344     0.150
     5.170   146.445     0.150
     5.410   173.344     0.150
     6.018   129.539     0.150
     6.018   167.039     0.150
     6.036    96.641     0.150
     6.036   107.641     0.150
     6.036   195.742     0.150
     6.263    84.039     0.150
     6.263    97.039     0.150
     6.366    94.742     0.150
     6.366   114.039     0.150
     6.366   178.641     0.150
     6.366   198.242     0.150
     6.366   114.445     0.150
     6.366   198.445     0.150
     6.687    95.344     0.150
     6.687   118.945     0.150
     6.687   210.445     0.150
     6.687   120.141     0.150
     7.089   204.039     0.150
     7.090   111.445     0.150
     7.090   138.141     0.150
     7.090   218.445     0.150
     7.799   140.742     0.150
     7.799   250.445     0.150
     7.799   142.242     0.150
     7.942   123.445     0.150
     7.942   244.344     0.150
     7.942   247.539     0.150
     7.942   121.141     0.150
     8.050   128.641     0.150
     8.050   141.445     0.150
     8.203   124.945     0.150
     8.793   133.039     0.150
     8.987   137.242     0.150
     8.987   235.039     0.150
     8.975   285.539     0.150
    10.102   150.742     0.150
    10.102   177.844     0.150
    10.102   272.844     0.150
    10.102   313.539     0.150
    10.325   273.445     0.150
    10.796   156.641     0.150
    11.327   286.344     0.150
    11.327   346.539     0.150
    13.675   429.664     0.150
    15.802   500.031     0.150
    17.171   233.648     0.150
    27.593   348.344     0.150
     0.174     4.766     0.150
     0.458     9.168     0.150
     1.044    18.566     0.150
     1.325    23.266     0.150
     1.325    39.469     0.150
     1.321    31.367     0.150
     1.321    41.668     0.150
     1.897    36.367     0.150
     2.268    36.766     0.150
     2.268    38.969     0.150
     2.790    56.566     0.150
     2.790    44.266     0.150
     3.547    56.668     0.150
     3.547    68.066     0.150
     3.547    89.066     0.150
     3.877    61.969     0.150
     3.972    68.066     0.150
     3.972    59.969     0.150
     4.147    78.668     0.150
     4.147    63.766     0.150
     4.147    74.367     0.150
     4.564    63.969     0.150
     5.284    93.668     0.150
     5.635   172.469     0.150
     5.828   104.266     0.150
     6.291   111.867     0.150
     6.291   112.066     0.150
     6.291   194.969     0.150
     6.336   112.469     0.150
     6.572    92.969     0.150
     6.572   120.566     0.150
     6.598   205.367     0.150
     6.811   104.668     0.150
     6.811   119.867     0.150
     6.811   176.668     0.150
     6.811   207.566     0.150
     7.254   130.266     0.150
     7.254   224.367     0.150
     7.705   107.668     0.150
     7.705   137.969     0.150
     7.705   199.668     0.150
     8.576   121.668     0.150
     8.576   224.066     0.150
     8.576   127.566     0.150
     8.576   268.668     0.150
     8.739   237.168     0.150
     9.243   135.418     0.150
    10.300   139.766     0.150
    17.052   224.977     0.150
     0.108     6.039     0.150
     0.108     7.738     0.150
     0.469    16.039     0.150
     0.920    27.938     0.150
     1.382    24.938     0.150
     1.326    25.039     0.150
     2.045    33.238     0.150
     2.045    33.238     0.150
     2.142    66.238     0.150
     2.142    37.738     0.150
     2.142    65.339     0.150
     2.711    43.039     0.150
     2.711    47.139     0.150
     3.339    62.738     0.150
     3.339   108.938     0.150
     3.410    54.639     0.150
     3.525    65.238     0.150
     3.525    97.938     0.150
     3.525   110.039     0.150
     3.604   116.839     0.150
     4.050    73.438     0.150
     4.226    76.039     0.150
     4.537    84.839     0.150
     4.536   129.438     0.150
     4.536   145.039     0.150
     4.646    83.639     0.150
     4.684    84.238     0.150
     4.684    70.039     0.150
     4.684    83.238     0.150
     4.684   124.639     0.150
     4.902    86.139     0.150
     4.902   158.738     0.150
     4.902    86.839     0.150
     4.951    81.039     0.150
     4.951    88.938     0.150
     5.126   104.339     0.150
     5.134   123.238     0.150
     5.435    96.039     0.150
     5.435   172.438     0.150
     5.603    99.738     0.150
     5.603   155.339     0.150
     5.939   184.139     0.150
     5.970    95.839     0.150
     5.970   168.339     0.150
     5.970   169.738     0.150
     6.194    96.839     0.150
     6.194   109.039     0.150
     6.194   170.639     0.150
     6.194   192.039     0.150
     6.441   102.238     0.150
     6.441   116.539     0.150
     6.441   200.039     0.150
     6.441   205.839     0.150
     6.441   113.238     0.150
     6.441   196.839     0.150
     6.611   118.639     0.150
     6.611   204.139     0.150
     6.611   118.839     0.150
     6.611   203.639     0.150
     7.000   216.039     0.150
     7.000   234.738     0.150
     7.227   110.139     0.150
     7.227   128.938     0.150
     7.227   224.539     0.150
     7.316   175.738     0.150
     7.316   226.539     0.150
     7.316   228.039     0.150
     7.738   137.839     0.150
     7.738   239.738     0.150
     7.845   120.438     0.150
     7.845   149.039     0.150
     7.845   243.238     0.150
     7.845   247.238     0.150
     7.845   113.839     0.150
     7.845   140.339     0.150
     7.935   124.438     0.150
     7.935   138.238     0.150
     7.935   245.938     0.150
     7.935   141.738     0.150
    10.865   145.139     0.150
    10.865   280.539     0.150
    15.292   391.539     0.150
    15.292   417.139     0.150
    17.151   232.021     0.150
    17.151   411.695     0.150
    17.151   232.639     0.150
    24.005   312.639     0.150
    47.687   512.938     0.150
    53.229   556.539     0.150
     0.516    13.308     0.150
     0.516    18.107     0.150
     0.825    25.607     0.150
     0.960    22.007     0.150
     0.960    38.007     0.150
     0.960    30.808     0.150
     1.375    29.708     0.150
     1.375    26.007     0.150
     1.375    43.007     0.150
     2.167    68.007     0.150
     2.616    49.708     0.150
     2.950    51.507     0.150
     2.950    55.507     0.150
     3.478    52.808     0.150
     3.478    65.107     0.150
     3.818    99.407     0.150
     4.514    66.208     0.150
     4.514    79.208     0.150
     5.027    74.407     0.150
     5.027    88.907     0.150
     5.027   100.808     0.150
     5.027   139.607     0.150
     5.173    92.907     0.150
     5.173    93.208     0.150
     5.372    96.107     0.150
     5.622   104.308     0.150
     5.895    86.007     0.150
     6.045   108.308     0.150
     6.045   172.208     0.150
     6.045   108.708     0.150
     6.042   108.407     0.150
     6.042   106.827     0.150
     7.163   112.808     0.150
     7.163   222.808     0.150
     7.421   135.107     0.150
    17.319   239.157     0.150
    17.681   243.267     0.150
    17.681   546.816     0.150
    20.133   272.782     0.150
     0.191     6.227     0.150
     0.514    10.227     0.150
     0.514    18.026     0.150
     0.825    17.126     0.150
     0.825    15.426     0.150
     0.965    21.727     0.150
     0.965    35.926     0.150
     1.370    25.326     0.150
     1.370    44.426     0.150
     2.167    38.026     0.150
     2.167    39.526     0.150
     2.624    48.626     0.150
     2.953    56.826     0.150
     2.953    87.526     0.150
     4.111    61.026     0.150
     4.111    77.426     0.150
     4.111   127.526     0.150
     4.808    71.526     0.150
     5.168    78.227     0.150
     5.168    93.126     0.150
     5.399   147.626     0.150
     5.624    83.026     0.150
     5.624   100.227     0.150
     6.045   107.670     0.150
     6.044   108.826     0.150
     6.044   176.426     0.150
     6.448   116.026     0.150
     7.301   130.426     0.150
     7.425   134.826     0.150
     8.426   150.746     0.150
    15.297   216.826     0.150
     0.816    32.094     0.150
     1.081    20.500     0.150
     1.081    20.500     0.150
     1.376    26.297     0.150
     2.037    40.398     0.150
     2.037    58.594     0.150
     2.769    57.094     0.150
     3.610    68.695     0.150
     4.215   100.195     0.150
     6.281   119.094     0.150
     0.223    16.292     0.150
     0.608    11.192     0.150
     0.608    11.192     0.150
     0.608    14.893     0.150
     1.067    22.493     0.150
     1.067    39.393     0.150
     1.554    31.292     0.150
     1.985    38.692     0.150
     2.497    83.993     0.150
     3.322    84.692     0.150
     3.452    88.593     0.150
     3.812   124.493     0.150
     4.062    94.593     0.150
     4.125    70.093     0.150
     4.323   105.393     0.150
     4.401    71.692     0.150
     4.401   114.192     0.150
     4.767   146.493     0.150
     5.344    96.893     0.150
     5.344   173.393     0.150
     6.073   106.993     0.150
     6.073   202.493     0.150
     6.446   104.893     0.150
     7.065   130.893     0.150
     8.829   132.192     0.150
     8.829   207.292     0.150
     8.829   281.893     0.150
    12.289   377.393     0.150
    12.464   394.993     0.150
     0.210    12.680     0.150
     0.210     4.082     0.150
     1.098    19.980     0.150
     1.098    22.281     0.150
     1.098    23.980     0.150
     1.098    39.180     0.150
     1.098    19.980     0.150
     1.098    32.680     0.150
     1.228    44.281     0.150
     1.228    22.383     0.150
     1.531    28.883     0.150
     1.531    27.480     0.150
     1.952    37.582     0.150
     1.952    58.281     0.150
     1.783    54.781     0.150
     2.474    80.383     0.150
     2.568    54.383     0.150
     3.288    63.383     0.150
     3.288    84.180     0.150
     3.288   102.383     0.150
     3.486    57.082     0.150
     3.486    89.281     0.150
     3.821    70.480     0.150
     3.821    75.480     0.150
     3.821   124.480     0.150
     3.821    59.781     0.150
     3.821   104.180     0.150
     3.821   118.980     0.150
     4.034    69.883     0.150
     4.034    84.680     0.150
     4.034   134.480     0.150
     4.092    70.180     0.150
     4.092   103.180     0.150
     4.092   137.180     0.150
     4.369    80.680     0.150
     4.369    68.680     0.150
     4.369    79.781     0.150
     4.348    85.582     0.150
     4.348   102.480     0.150
     4.348   129.281     0.150
     5.505    95.383     0.150
     5.574    92.781     0.150
     5.574   101.582     0.150
     6.039    92.180     0.150
     6.039   114.680     0.150
     6.146   110.082     0.150
     6.146   112.281     0.150
     6.409   117.582     0.150
     6.409   208.781     0.150
     6.416   180.582     0.150
     6.416   207.980     0.150
     6.416   115.082     0.150
     6.793   117.480     0.150
     6.793   224.883     0.150
     7.032   219.781     0.150
     7.032   228.180     0.150
     7.475   240.180     0.150
     7.654   189.082     0.150
     7.654   227.980     0.150
     7.654   231.281     0.150
     7.927   128.082     0.150
     7.927   253.082     0.150
     8.031   130.180     0.150
     8.031   250.980     0.150
     8.799   248.383     0.150
     8.799   284.781     0.150
     8.959   139.980     0.150
     8.959   164.082     0.150
     8.959   230.781     0.150
     8.959   163.082     0.150
     8.959   278.582     0.150
     9.432   173.035     0.150
    11.039   165.383     0.150
    11.039   172.883     0.150
    11.039   337.781     0.150
    16.902   231.891     0.150
     0.585    27.094     0.150
     1.093    20.094     0.150
     1.093    22.391     0.150
     1.093    39.188     0.150
     1.228    26.789     0.150
     1.532    34.992     0.150
     1.774    34.391     0.150
     1.959    39.094     0.150
     3.295   110.289     0.150
     3.477    57.289     0.150
     3.477   115.391     0.150
     3.476    85.992     0.150
     3.824    62.094     0.150
     3.824   124.188     0.150
     4.043    90.188     0.150
     4.098   135.391     0.150
     4.346    69.391     0.150
     4.346    83.188     0.150
     4.346   110.289     0.150
     4.375    81.891     0.150
     4.375   139.289     0.150
     5.582   182.594     0.150
     6.047   106.688     0.150
     6.047   110.492     0.150
     6.415    73.391     0.150
     6.425    93.188     0.150
     6.425   104.188     0.150
     6.799   132.594     0.150
     6.799   189.289     0.150
     7.038   199.289     0.150
     8.803   161.094     0.150
     8.963   139.594     0.150
     8.963   171.289     0.150
     8.963   241.391     0.150
     0.226     4.219     0.150
     0.581    10.820     0.150
     1.083    24.414     0.150
     1.083    39.914     0.150
     1.244    38.516     0.150
     1.547    35.219     0.150
     1.547    57.719     0.150
     1.547    48.414     0.150
     1.783    68.016     0.150
     1.783    31.914     0.150
     1.783    55.219     0.150
     1.966    37.516     0.150
     1.966    33.414     0.150
     1.966    59.117     0.150
     2.553    62.320     0.150
     2.553    43.016     0.150
     2.490    42.516     0.150
     2.490    46.320     0.150
     2.490    75.320     0.150
     3.300    63.719     0.150
     3.300    70.117     0.150
     3.300   109.414     0.150
     3.464    68.414     0.150
     3.489    92.719     0.150
     3.806    90.516     0.150
     4.035   145.516     0.150
     4.104    65.719     0.150
     4.104   134.820     0.150
     4.383   113.719     0.150
     4.383   143.719     0.150
     4.383    80.117     0.150
     5.518    87.617     0.150
     5.518    94.719     0.150
     5.518   186.516     0.150
     5.518    84.820     0.150
     5.518    98.820     0.150
     5.586   101.719     0.150
     5.586   160.219     0.150
     5.864   107.719     0.150
     5.864   196.914     0.150
     5.905   110.516     0.150
     5.905   180.820     0.150
     6.130   164.320     0.150
     6.130   197.516     0.150
     6.051    95.820     0.150
     6.051   110.414     0.150
     6.051   184.820     0.150
     6.418   119.016     0.150
     6.418   210.320     0.150
     6.418   115.719     0.150
     6.806   114.320     0.150
     6.806   123.320     0.150
     6.806   166.016     0.150
     6.806   101.320     0.150
     6.806   122.617     0.150
     6.834   125.617     0.150
     6.834   191.617     0.150
     6.834   223.719     0.150
     6.834   122.219     0.150
     7.046   126.320     0.150
     7.046   172.320     0.150
     7.489   121.820     0.150
     7.489   135.016     0.150
     7.489   205.219     0.150
     7.489   240.320     0.150
     7.489   135.320     0.150
     7.646   113.117     0.150
     7.646   139.617     0.150
     7.646   208.617     0.150
     7.646   263.914     0.150
     7.646   109.867     0.150
     8.015   147.719     0.150
     7.942   127.219     0.150
     7.942   143.719     0.150
     8.541   159.320     0.150
     8.541   247.914     0.150
     8.541   127.914     0.150
     8.541   270.820     0.150
     8.813   235.914     0.150
     8.813   247.516     0.150
     8.813   157.219     0.150
     8.813   272.320     0.150
     8.975   151.219     0.150
     8.975   250.719     0.150
    10.075   141.891     0.150
    10.075   260.414     0.150
    10.075   140.938     0.150
    11.055   339.820     0.150
    11.055   360.516     0.150
    12.765   391.664     0.150
    14.293   200.016     0.150
    14.293   362.516     0.150
    14.381   369.320     0.150
    15.144   383.719     0.150
    16.080   406.117     0.150
    16.101   226.586     0.150
    16.503   231.484     0.150
    16.784   231.617     0.150
    16.897   231.062     0.150
    16.897   230.914     0.150
    16.897   230.047     0.150
    19.095     6.203     0.150
    19.095     9.102     0.150
    19.766   608.922     0.150
    19.821   271.914     0.150
    19.821   500.117     0.150
    19.981   488.516     0.150
    20.438   279.469     0.150
    20.704   282.273     0.150
    20.796   282.617     0.150
    20.796   513.414     0.150
    20.842   654.742     0.150
    21.108     5.102     0.150
    21.564   290.617     0.150
    21.623   290.867     0.150
    21.623   675.320     0.150
    21.623   291.219     0.150
    21.787   292.617     0.150
    22.273     6.703     0.150
    22.273    27.000     0.150
    22.273   298.367     0.150
    23.520   310.266     0.150
    23.529   565.820     0.150
    24.230     3.703     0.150
    24.230     5.102     0.150
    24.230   578.617     0.150
    24.863   595.125     0.150
    24.863   323.914     0.150
    25.216   326.805     0.150
    25.179   595.477     0.150
    25.251   600.547     0.150
    25.251   327.320     0.150
    25.423   385.414     0.150
    25.423   667.117     0.150
    25.489     4.102     0.150
    25.489   593.414     0.150
    25.492   606.758     0.150
    25.492   328.016     0.150
    25.775   594.820     0.150
    25.758   600.391     0.150
    25.737   332.414     0.150
    25.737   603.914     0.150
    26.130   624.750     0.150
    26.130   335.820     0.150
    26.446   385.617     0.150
    26.362   337.617     0.150
    26.523   340.461     0.150
    26.711   340.820     0.150
    26.800   636.711     0.150
    26.800   341.820     0.150
    26.784   343.117     0.150
    26.940   342.617     0.150
    27.161   345.016     0.150
    27.255   344.719     0.150
    27.425   347.211     0.150
    27.757   354.016     0.150
    28.133   356.914     0.150
    28.170   357.469     0.150
    28.362   354.914     0.150
    28.551   904.109     0.150
    28.551   358.055     0.150
    28.930   364.336     0.150
    29.913   374.914     0.150
    29.913     8.102     0.150
    30.078   765.719     0.150
    30.078   781.414     0.150
    30.134   371.516     0.150
    30.453   373.695     0.150
    30.889   378.359     0.150
    31.252   386.719     0.150
    31.348   382.414     0.150
    31.951     4.398     0.150
    31.951     5.398     0.150
    31.951   386.906     0.150
    32.239   389.891     0.150
    32.309   390.547     0.150
    32.332   390.258     0.150
    34.224   404.570     0.150
    34.409   408.336     0.150
    35.610   419.617     0.150
    35.761   420.609     0.150
    35.761   420.156     0.150
    35.918   426.320     0.150
    36.896   425.516     0.150
    36.896   565.117     0.150
    36.896   768.117     0.150
    37.080   432.617     0.150
    37.296   433.617     0.150
    37.296   433.617     0.150
    37.296   783.820     0.150
    37.296   783.820     0.150
    37.314   432.773     0.150
    38.151   439.117     0.150
    38.211   442.391     0.150
    38.721   577.594     0.150
    38.850   445.664     0.150
    39.464   450.500     0.150
    39.665   449.297     0.150
    40.097   455.219     0.150
    40.739   587.617     0.150
    40.739  1042.320     0.150
    40.734   463.625     0.150
    41.587   585.320     0.150
    41.587   592.719     0.150
    41.587  1073.414     0.150
    42.629   477.367     0.150
    43.386   478.016     0.150
    44.113   487.516     0.150
    44.420   492.188     0.150
    44.745   494.523     0.150
    44.975   496.078     0.150
    45.014   496.258     0.150
    45.352   500.164     0.150
    45.352   649.719     0.150
    46.011   505.000     0.150
    46.010   505.117     0.150
    46.010   911.117     0.150
    46.229   911.117     0.150
    46.229   941.117     0.150
    46.229  1117.117     0.150
    46.499   507.969     0.150
    46.518   508.836     0.150
    46.632   510.836     0.150
    46.632   601.789     0.150
    47.105   512.789     0.150
    47.197   619.320     0.150
    47.197   673.320     0.150
    47.197   929.320     0.150
    47.197  1195.414     0.150
    47.806   517.609     0.150
    48.143   518.984     0.150
    48.143   605.586     0.150
    48.476   523.930     0.150
    48.412   523.906     0.150
    48.412   522.016     0.150
    48.412   521.969     0.150
    48.412   608.141     0.150
    48.480   522.820     0.150
    48.600   524.414     0.150
    49.523   530.320     0.150
    49.900   535.117     0.150
    50.027   535.305     0.150
    50.027   535.414     0.150
    50.253   537.625     0.150
    50.253   537.719     0.150
    50.499   975.117     0.150
    50.499   541.117     0.150
    50.499   544.117     0.150
    50.499   657.117     0.150
    50.499   975.117     0.150
    50.864   652.820     0.150
    50.864   973.617     0.150
    50.864   991.617     0.150
    50.864  1289.516     0.150
    51.748   547.188     0.150
    51.748   547.188     0.150
    51.837   549.258     0.150
    51.883   549.211     0.150
    52.116   552.188     0.150
    52.213   551.672     0.150
    52.231   552.219     0.150
    52.251   553.031     0.150
    52.482   554.016     0.150
    52.478   552.945     0.150
    52.509   740.719     0.150
    52.509  1010.516     0.150
    52.534   554.117     0.150
    52.534   554.094     0.150
    52.777   557.359     0.150
    52.857   557.031     0.150
    52.978   557.844     0.150
    52.964   557.945     0.150
    53.145   559.430     0.150
    53.145   624.094     0.150
    53.448   562.516     0.150
    53.458   561.414     0.150
    53.491   561.430     0.150
    53.552   561.719     0.150
    53.552  1017.617     0.150
    53.649  1017.984     0.150
    53.867   563.906     0.150
    53.890   564.617     0.150
    53.990   565.219     0.150
    53.990  1022.617     0.150
    53.993   565.820     0.150
    53.993  1023.320     0.150
    54.015   565.719     0.150
    54.015  1020.617     0.150
    54.139   566.055     0.150
    54.222   566.766     0.150
    54.211  1263.117     0.150
    54.206   578.320     0.150
    54.629   570.414     0.150
    54.629  1030.719     0.150
    54.645  1026.117     0.150
    54.645   569.414     0.150
    54.645   632.320     0.150
    54.645   693.117     0.150
    54.645  1026.117     0.150
    54.726   570.914     0.150
    54.726   699.117     0.150
    54.726   760.117     0.150
    54.726  1253.117     0.150
    54.726   571.125     0.150
    54.726   570.914     0.150
    54.726  1029.117     0.150
    54.784   571.414     0.150
    54.838   572.320     0.150
    55.009   572.516     0.150
    55.026   573.117     0.150
    55.026  1037.516     0.150
    55.039  1033.914     0.150
    55.039   573.414     0.150
    55.039  1033.914     0.150
    55.135   574.117     0.150
    55.219  1279.219     0.150
    55.426   576.125     0.150
    55.476   580.820     0.150
    55.761   578.016     0.150
    55.761  1047.719     0.150
    55.906   577.117     0.150
    56.096   580.914     0.150
    56.096  1050.117     0.150
    56.149   581.516     0.150
    56.195   580.664     0.150
    56.256  2389.016     0.150
    56.259   581.414     0.150
    56.439   582.586     0.150
    56.516   585.719     0.150
    56.738   584.930     0.150
    56.752   584.250     0.150
    57.320   588.867     0.150
    57.351   593.820     0.150
    57.777   592.734     0.150
    57.807   591.758     0.150
    58.657   598.047     0.150
    58.701   598.867     0.150
    58.740   599.469     0.150
    58.741   600.156     0.150
    58.819   599.039     0.150
    58.959   599.758     0.150
    59.287   601.648     0.150
    59.460   602.719     0.150
    59.538   604.164     0.150
    59.553   603.156     0.150
    60.664   620.516     0.150
    61.347   616.820     0.150
    61.347   616.859     0.150
    61.388   621.320     0.150
    62.238   622.414     0.150
    62.244   628.016     0.150
    63.370   628.719     0.150
    65.762   644.328     0.150
    67.434   656.117     0.150
    67.434   656.078     0.150
    67.660   657.414     0.150
    67.660   657.375     0.150
    68.775   666.000     0.150
    70.617   676.445     0.150
    71.216   678.734     0.150
    71.383   680.766     0.150
    71.461   682.523     0.150
    71.704   684.477     0.150
    71.771   684.016     0.150
    72.236   686.234     0.150
    72.306   686.930     0.150
    72.408   687.711     0.150
    72.526   688.109     0.150
    72.575   689.219     0.150
    73.028   692.320     0.150
    73.809   695.289     0.150
    74.218   696.609     0.150
    74.388   699.516     0.150
    74.388  1274.320     0.150
    74.835   701.414     0.150
    74.835   701.406     0.150
    74.966   702.570     0.150
    75.020   703.117     0.150
    75.020  1281.414     0.150
    75.191   703.461     0.150
    75.491   706.148     0.150
    75.558   705.984     0.150
    75.894   706.805     0.150
    76.113   708.617     0.150
    76.258   709.844     0.150
    76.276   710.766     0.150
    76.793   711.430     0.150
    77.048   714.203     0.150
    77.670   717.859     0.150
    77.624   716.805     0.150
    77.972   718.664     0.150
    77.991   720.406     0.150
    78.023   719.359     0.150
    78.295   720.344     0.150
    78.367   721.297     0.150
    78.367   721.266     0.150
    78.450   722.328     0.150
    78.596   723.000     0.150
    78.794   724.648     0.150
    78.794   724.578     0.150
    79.030   725.250     0.150
    79.138   726.188     0.150
    79.299   727.328     0.150
    79.299   727.344     0.150
    79.313   725.539     0.150
    79.802   728.320     0.150
    79.827   729.016     0.150
    79.969   729.836     0.150
    80.415   732.039     0.150
    80.562   732.711     0.150
    80.609   734.234     0.150
    80.939   735.727     0.150
    80.983   736.227     0.150
    81.072   736.977     0.150
    81.233   737.008     0.150
    81.184  2338.820     0.150
    81.268   736.570     0.150
    81.268   736.555     0.150
    81.709   738.977     0.150
    81.714   739.656     0.150
    81.714   739.719     0.150
    81.731   739.289     0.150
    81.845   739.180     0.150
    82.033   741.789     0.150
    82.710   743.664     0.150
    83.024   745.695     0.150
    83.059   746.617     0.150
    83.095   745.969     0.150
    83.279   747.016     0.150
    83.472   748.398     0.150
    83.571   749.188     0.150
    83.848   750.188     0.150
    83.952   750.477     0.150
    84.110   751.875     0.150
    84.170   751.758     0.150
    84.303   752.414     0.150
    84.529   753.539     0.150
    84.710   754.438     0.150
    85.026   756.609     0.150
    85.374   758.289     0.150
    86.310   762.586     0.150
    86.334   762.820     0.150
    86.404   763.789     0.150
    86.645   764.375     0.150
    86.769   764.797     0.150
    86.686   765.586     0.150
    87.421   768.414     0.150
    87.632   768.648     0.150
    87.632   768.727     0.150
    88.320   772.867     0.150
    89.149   776.906     0.150
    89.459   777.711     0.150
    89.662   778.945     0.150
    89.673   779.125     0.150
    90.668   784.500     0.150
    90.692   782.734     0.150
    91.139   785.445     0.150
    99.962   826.414     0.150
   124.487  1135.211     0.150
   128.616  1143.227     0.150
   130.743  1146.828     0.150
   132.973  1156.328     0.150
   132.973  1151.773     0.150
   135.828  1156.008     0.150
   136.555  1161.117     0.150
   136.767  1157.984     0.150
   137.120  1156.711     0.150
   138.277  1160.078     0.150
   138.574  1161.359     0.150
   139.141  1162.055     0.150
   139.159  1160.773     0.150
   139.675  1162.055     0.150
   139.845  1163.820     0.150
   140.291  1168.773     0.150
   140.291  1165.656     0.150
   141.577  1167.984     0.150
   142.707  1169.266     0.150
   143.070  1169.500     0.150
   144.035  1169.266     0.150
   144.119  1168.109     0.150
   144.810  1171.234     0.150
   145.151  1171.938     0.150
   145.343  1172.867     0.150
   145.425  1172.984     0.150
   146.548  1175.656     0.150
   146.890  1176.938     0.150
   147.074  1176.234     0.150
   149.513  1178.836     0.150
   149.647  1188.398     0.150
   164.399  1199.375     0.150
     0.214    11.922     0.150
     0.214     4.125     0.150
     0.603    11.125     0.150
     0.603    19.422     0.150
     1.077    22.523     0.150
     1.077    24.320     0.150
     1.077    39.320     0.150
     1.077    20.125     0.150
     1.077    35.023     0.150
     1.238    24.523     0.150
     1.238    38.625     0.150
     1.238    46.023     0.150
     1.545    30.922     0.150
     1.545    36.125     0.150
     1.545    54.125     0.150
     1.545    27.820     0.150
     1.758    57.320     0.150
     1.976    38.023     0.150
     2.487    39.625     0.150
     2.487    69.422     0.150
     2.487    75.625     0.150
     2.548    88.523     0.150
     3.314   109.422     0.150
     3.314 75688.016     0.150
     3.464    66.125     0.150
     3.820    93.125     0.150
     3.820   110.320     0.150
     3.820    60.125     0.150
     3.820    69.719     0.150
     3.820   120.125     0.150
     4.059   130.125     0.150
     4.059    70.320     0.150
     4.117   137.523     0.150
     4.392   108.625     0.150
     4.392   144.125     0.150
     4.332    66.125     0.150
     4.332   101.422     0.150
     4.332   126.820     0.150
     5.528    93.922     0.150
     5.600   102.422     0.150
     5.600   178.320     0.150
     5.600   186.922     0.150
     6.065   186.625     0.150
     6.065   191.820     0.150
     6.129   168.422     0.150
     6.442   116.125     0.150
     6.816   207.320     0.150
     7.056   134.320     0.150
     7.056   233.125     0.150
     7.949   142.023     0.150
     8.552   163.219     0.150
     8.552   271.320     0.150
     8.820   139.125     0.150
     8.820   246.422     0.150
     8.820   283.922     0.150
     8.978   128.023     0.150
     8.978   224.922     0.150
     8.978   247.219     0.150
    81.209   746.273     0.150
     0.213    11.320     0.150
     0.213    15.320     0.150
     0.213     4.117     0.150
     0.603    14.422     0.150
     0.603    11.219     0.150
     0.603    19.719     0.150
     1.078    22.516     0.150
     1.078    39.320     0.150
     1.078    20.117     0.150
     1.237    46.117     0.150
     1.758    31.617     0.150
     1.758    53.820     0.150
     1.976    34.516     0.150
     1.976    37.922     0.150
     1.976    65.219     0.150
     1.976    62.422     0.150
     2.486    75.617     0.150
     2.549    88.320     0.150
     3.313    63.219     0.150
     3.313    88.016     0.150
     3.313   111.719     0.150
     3.821    61.820     0.150
     3.821    98.422     0.150
     3.821   112.719     0.150
     4.116   138.617     0.150
     4.333    72.016     0.150
     4.333   128.922     0.150
     4.391    85.016     0.150
     5.527   115.617     0.150
     5.600    98.117     0.150
     5.600   187.016     0.150
     6.065   193.922     0.150
     6.432   204.320     0.150
     6.442   102.820     0.150
     6.442   206.219     0.150
     6.442   116.016     0.150
     6.816   180.320     0.150
     6.816   213.422     0.150
     7.948   138.617     0.150
     8.819   134.219     0.150
     8.819   168.719     0.150
     8.977   164.516     0.150
     8.977   223.117     0.150
     8.977   257.922     0.150
     0.212     9.691     0.150
     1.085    22.492     0.150
     1.085    26.492     0.150
     1.234    45.895     0.150
     1.539    28.895     0.150
     1.767    59.492     0.150
     2.555    49.191     0.150
     2.555    88.293     0.150
     3.305    85.691     0.150
     3.305   105.793     0.150
     3.471    79.492     0.150
     3.471    98.395     0.150
     3.469    86.191     0.150
     3.821    62.992     0.150
     3.821   124.492     0.150
     4.108   133.992     0.150
     4.339    73.895     0.150
     4.384    83.691     0.150
     4.384   139.594     0.150
     5.519    78.492     0.150
     5.591    94.691     0.150
     5.591   171.191     0.150
     6.056   111.691     0.150
     6.136   140.293     0.150
     6.136   179.594     0.150
     6.433    97.793     0.150
     6.433   104.094     0.150
     7.047   105.992     0.150
     7.047   112.293     0.150
     7.047   213.992     0.150
     7.490   118.191     0.150
     7.941   167.293     0.150
     7.941   209.293     0.150
     8.812   134.094     0.150
     8.812   246.793     0.150
     8.971   248.691     0.150
    11.050   888.492     0.150
    12.448   390.395     0.150
    12.448   395.992     0.150
     0.245     4.391     0.150
     0.608    13.590     0.150
     0.608    22.590     0.150
     1.051    22.293     0.150
     1.051    23.992     0.150
     1.051    38.590     0.150
     1.051    19.492     0.150
     1.051    33.191     0.150
     1.269    25.191     0.150
     1.269    39.891     0.150
     1.269    23.191     0.150
     1.575    29.793     0.150
     1.763    33.891     0.150
     1.763    54.293     0.150
     1.763    54.191     0.150
     1.998    35.590     0.150
     1.998    60.391     0.150
     3.332   110.391     0.150
     3.790   123.293     0.150
     3.790   103.191     0.150
     4.137   108.793     0.150
     4.137   133.590     0.150
     4.416    85.191     0.150
     4.416    69.590     0.150
     4.416    80.891     0.150
     5.551    95.891     0.150
     5.551    99.391     0.150
     5.618    87.391     0.150
     5.618   102.391     0.150
     5.851   106.090     0.150
     6.082   109.391     0.150
     6.082   197.992     0.150
     6.084   110.492     0.150
     6.100   177.090     0.150
     6.100   209.090     0.150
     6.442   105.191     0.150
     6.442   117.293     0.150
     6.442   206.691     0.150
     6.442   115.293     0.150
     6.442   197.090     0.150
     6.839   123.293     0.150
     6.867   124.891     0.150
     7.079   126.691     0.150
     7.079   229.793     0.150
     7.522   136.191     0.150
     7.522   127.078     0.150
     7.522   115.293     0.150
     7.650   123.691     0.150
     7.994   125.492     0.150
     8.574   272.191     0.150
     8.845   140.090     0.150
     8.845   231.691     0.150
     9.006   144.891     0.150
     9.006   226.391     0.150
     9.251   305.691     0.150
     9.251   142.590     0.150
     9.472   139.191     0.150
    10.042   260.191     0.150
    11.085   208.492     0.150
    12.484   350.492     0.150
    16.808   522.016     0.150
    16.871   233.500     0.150
    16.871   533.652     0.150
    20.402   644.570     0.150
    38.719   446.559     0.150
    45.371   918.191     0.150
     0.266    14.578     0.150
     0.266     4.777     0.150
     0.618    18.676     0.150
     1.030    21.977     0.150
     1.030    23.375     0.150
     1.030    37.477     0.150
     1.291    40.375     0.150
     1.291    46.176     0.150
     1.291    42.777     0.150
     1.597    49.477     0.150
     1.597    28.676     0.150
     2.018    35.578     0.150
     2.018    35.578     0.150
     2.018    37.777     0.150
     1.761    32.977     0.150
     1.761    31.375     0.150
     1.761    53.676     0.150
     2.540    41.676     0.150
     2.540    85.078     0.150
     2.499    84.277     0.150
     2.499    46.375     0.150
     3.350    63.078     0.150
     3.350   113.977     0.150
     3.350 14480.578     0.150
     3.350    53.477     0.150
     3.350   104.676     0.150
     3.412    84.477     0.150
     3.412    86.875     0.150
     3.477    65.977     0.150
     3.770    77.277     0.150
     3.770    90.477     0.150
     3.770   125.176     0.150
     3.770    59.578     0.150
     3.770    68.477     0.150
     4.155   104.375     0.150
     4.155   120.875     0.150
     4.436   108.676     0.150
     4.436    80.977     0.150
     4.281   110.078     0.150
     4.796   122.477     0.150
     5.342   190.676     0.150
     5.571    88.375     0.150
     5.571   105.578     0.150
     5.635   103.176     0.150
     5.635   164.277     0.150
     5.635   189.477     0.150
     5.870   186.277     0.150
     5.870   195.477     0.150
     5.915   189.277     0.150
     5.915   198.777     0.150
     6.101   202.578     0.150
     6.078    86.578     0.150
     6.078   106.676     0.150
     6.078   192.176     0.150
     6.448   103.375     0.150
     6.448   186.477     0.150
     6.448   115.676     0.150
     6.475   100.477     0.150
     6.475   145.375     0.150
     6.859   121.176     0.150
     6.859   209.676     0.150
     6.859   224.875     0.150
     6.887   229.977     0.150
     6.887   214.375     0.150
     7.099   225.176     0.150
     7.641   186.977     0.150
     7.641   221.176     0.150
     7.641   243.977     0.150
     7.641   258.875     0.150
     7.995   211.977     0.150
     7.995   242.676     0.150
     7.972   125.578     0.150
     8.593   132.875     0.150
     8.593   140.176     0.150
     8.593   238.477     0.150
     8.867   123.777     0.150
     8.867   148.875     0.150
     9.028   143.777     0.150
     9.028   172.875     0.150
     9.028   251.977     0.150
     9.486   141.500     0.150
     9.486   300.656     0.150
    11.107   338.176     0.150
    11.107   354.777     0.150
    12.731   407.926     0.150
     0.230    11.929     0.150
     0.230     4.528     0.150
     0.603    15.729     0.150
     0.603    11.028     0.150
     0.603    19.028     0.150
     1.253    27.729     0.150
     1.253    39.929     0.150
     1.253    46.429     0.150
     1.253    22.829     0.150
     1.253    39.929     0.150
     1.559    58.929     0.150
     1.559    28.028     0.150
     1.559    48.028     0.150
     1.763    34.129     0.150
     1.763    59.429     0.150
     1.763    31.829     0.150
     1.763    54.429     0.150
     1.985    35.528     0.150
     1.985    60.028     0.150
     2.502    48.229     0.150
     2.502    73.329     0.150
     2.536    47.129     0.150
     3.321    58.329     0.150
     3.321    99.929     0.150
     3.449    62.829     0.150
     3.449    66.129     0.150
     3.804    59.829     0.150
     3.804    68.929     0.150
     3.804   124.129     0.150
     3.804    59.829     0.150
     3.804    69.129     0.150
     3.804   104.929     0.150
     4.055   120.929     0.150
     4.055   125.329     0.150
     4.402   109.329     0.150
     4.402    80.329     0.150
     4.319    77.528     0.150
     4.319   108.929     0.150
     4.766    93.528     0.150
     5.311   174.929     0.150
     5.538   101.629     0.150
     5.607   101.629     0.150
     5.839   101.028     0.150
     5.839   105.829     0.150
     5.839   179.829     0.150
     5.884   121.929     0.150
     6.072   109.229     0.150
     6.072   110.829     0.150
     6.116   177.129     0.150
     6.116   190.528     0.150
     6.116   197.329     0.150
     6.097   109.528     0.150
     6.097   166.429     0.150
     6.097   189.629     0.150
     6.439    95.429     0.150
     6.439   105.329     0.150
     6.439   116.528     0.150
     6.439   196.729     0.150
     6.439   199.629     0.150
     6.439   216.329     0.150
     6.439    95.429     0.150
     6.439   115.229     0.150
     6.439   164.129     0.150
     6.439   196.729     0.150
     6.826   215.329     0.150
     7.065   220.429     0.150
     7.508   130.423     0.150
     7.508   134.929     0.150
     7.508   136.329     0.150
     7.508   231.528     0.150
     7.960   233.329     0.150
     7.960   238.729     0.150
     8.009   147.829     0.150
     8.009   253.429     0.150
     8.561   223.429     0.150
     8.561   261.229     0.150
     8.831   140.929     0.150
     8.831   155.729     0.150
     8.831   284.329     0.150
     8.831   141.929     0.150
     8.831   275.329     0.150
     8.991   256.129     0.150
     9.243   296.829     0.150
     9.243   305.129     0.150
     9.463   144.680     0.150
     9.463   179.269     0.150
     9.463   256.068     0.150
    10.054   250.979     0.150
    10.054   139.729     0.150
    10.054   265.129     0.150
    12.468   239.929     0.150
    12.468   329.028     0.150
    12.468   355.129     0.150
    12.468   390.829     0.150
    16.792   520.979     0.150
    16.876   232.688     0.150
    16.876   520.638     0.150
    17.769   430.879     0.150
    21.638   686.535     0.150
    42.607   476.429     0.150
    53.148   561.651     0.150
    55.884   580.079     0.150
    56.252   583.429     0.150
     1.123    43.453     0.150
     1.430    25.352     0.150
     1.430    27.453     0.150
     1.762    34.453     0.150
     1.886    36.352     0.150
     3.235    54.453     0.150
     3.235    82.250     0.150
     3.235   112.547     0.150
     3.571    59.953     0.150
     3.927    63.953     0.150
     3.927    73.352     0.150
     3.927   129.352     0.150
     4.032    58.953     0.150
     4.032   133.453     0.150
     4.295   110.047     0.150
     4.295   139.047     0.150
     4.446   116.453     0.150
     4.446   145.148     0.150
     5.434   171.352     0.150
     5.985    92.750     0.150
     5.985   181.750     0.150
     6.242   206.750     0.150
     6.427    98.047     0.150
     6.427   213.547     0.150
     6.723   124.648     0.150
     6.961   225.250     0.150
     7.401   116.250     0.150
     7.847   236.852     0.150
     8.462   254.648     0.150
     8.716   147.750     0.150
     8.716   247.047     0.150
     8.869   142.453     0.150
     8.869   248.453     0.150
    10.944   345.453     0.150
     0.222     5.660     0.150
     0.222    10.160     0.150
     0.222     4.363     0.150
     0.587    18.363     0.150
     1.081    22.160     0.150
     1.081    39.160     0.150
     1.081    19.961     0.150
     1.243    25.461     0.150
     1.243    42.660     0.150
     1.243    46.961     0.150
     1.546    29.062     0.150
     1.546    51.562     0.150
     1.546    27.863     0.150
     1.546    47.363     0.150
     1.776    31.863     0.150
     1.776    32.160     0.150
     1.776    55.863     0.150
     1.776    31.863     0.150
     1.776    53.863     0.150
     1.969    65.062     0.150
     1.969    35.363     0.150
     2.489    81.660     0.150
     2.551    46.660     0.150
     3.463   114.660     0.150
     3.810    61.363     0.150
     3.810   123.863     0.150
     3.810    69.062     0.150
     4.386   107.863     0.150
     4.332   142.961     0.150
     4.749    79.363     0.150
     5.521    89.062     0.150
     5.521    99.262     0.150
     5.822   101.762     0.150
     5.822   113.363     0.150
     5.822   186.062     0.150
     5.909   146.863     0.150
     6.055   107.863     0.150
     6.055   168.363     0.150
     6.055   193.762     0.150
     6.130   111.160     0.150
     6.130   164.762     0.150
     6.426   171.562     0.150
     6.426   215.660     0.150
     6.425   116.363     0.150
     6.425    94.363     0.150
     6.425   115.262     0.150
     6.809   195.762     0.150
     6.837   214.762     0.150
     6.837   122.660     0.150
     7.049   169.160     0.150
     7.492   130.934     0.150
     7.492   120.562     0.150
     7.492   197.762     0.150
     7.944   126.660     0.150
     7.944   143.160     0.150
     7.944   250.363     0.150
     8.544   260.562     0.150
     8.544   266.660     0.150
     8.815   154.461     0.150
     8.815   218.762     0.150
     8.976   142.961     0.150
     9.446   172.820     0.150
    11.056   348.863     0.150
    12.769   401.465     0.150
    17.774   430.910     0.150
    21.624   293.160     0.150
    77.638   718.863     0.150
     0.516    14.443     0.150
     0.830    17.943     0.150
     0.830    30.443     0.150
     1.455    48.343     0.150
     1.770    32.644     0.150
     1.760    35.144     0.150
     1.760    65.343     0.150
     2.850    60.443     0.150
     2.850    92.243     0.150
     3.232    66.443     0.150
     3.602    53.644     0.150
     4.080    59.043     0.150
     4.157    67.943     0.150
     4.157   119.043     0.150
     4.492    72.043     0.150
     4.492    85.543     0.150
     4.492   146.543     0.150
     4.943    89.644     0.150
     4.943   135.443     0.150
     5.044   136.243     0.150
     5.304   155.743     0.150
     5.304   161.243     0.150
     5.345   172.144     0.150
     5.367   169.543     0.150
     6.233   151.743     0.150
     6.368    95.743     0.150
     6.368    99.443     0.150
     6.368   211.243     0.150
     6.464   124.243     0.150
     6.464   181.743     0.150
     6.464   205.443     0.150
     6.894   188.543     0.150
     7.311   177.343     0.150
     7.311   193.843     0.150
     7.311   229.443     0.150
     8.169   127.144     0.150
     8.169   225.644     0.150
     8.292   130.343     0.150
     8.292   144.644     0.150
     8.292   261.644     0.150
    10.351   316.543     0.150
    10.351   326.644     0.150
    10.558   332.644     0.150
    11.740   367.243     0.150
    11.740   371.343     0.150
     0.222     4.430     0.150
     1.089    22.930     0.150
     1.089    39.629     0.150
     1.089    20.629     0.150
     1.541    30.629     0.150
     1.541    47.629     0.150
     1.786    55.328     0.150
     1.960    38.230     0.150
     1.960    63.730     0.150
     1.960    33.129     0.150
     1.960    59.230     0.150
     2.484    49.430     0.150
     2.484    78.129     0.150
     2.559    54.828     0.150
     2.559    88.328     0.150
     3.294   111.730     0.150
     3.294   102.527     0.150
     3.470    66.828     0.150
     3.810    61.828     0.150
     3.810    70.828     0.150
     3.810   124.828     0.150
     4.098   104.629     0.150
     4.098   135.527     0.150
     4.377    73.527     0.150
     4.377    79.828     0.150
     4.377   123.730     0.150
     4.338   109.730     0.150
     4.739   154.730     0.150
     5.284    95.828     0.150
     5.284   199.930     0.150
     5.512    81.430     0.150
     5.512   163.629     0.150
     5.512    81.328     0.150
     5.580   101.430     0.150
     5.813    85.527     0.150
     5.813    99.828     0.150
     5.813   105.129     0.150
     5.813   162.629     0.150
     5.813   178.430     0.150
     5.858   105.129     0.150
     5.858   161.328     0.150
     5.899    92.629     0.150
     5.899   107.828     0.150
     5.899   197.129     0.150
     6.416   104.430     0.150
     6.416   115.629     0.150
     6.416   202.027     0.150
     6.414   116.430     0.150
     6.414   193.230     0.150
     6.800   115.629     0.150
     6.800   122.129     0.150
     6.800   185.629     0.150
     6.800   216.527     0.150
     6.828   123.230     0.150
     6.828   193.527     0.150
     6.828   224.828     0.150
     6.828   123.930     0.150
     6.828   212.328     0.150
     7.040   127.730     0.150
     7.040   201.730     0.150
     7.483   107.449     0.150
     7.483   128.871     0.150
     7.483   228.297     0.150
     7.483   128.328     0.150
     7.483   133.629     0.150
     7.646   109.840     0.150
     7.936   143.629     0.150
     7.936   220.230     0.150
     7.936   144.328     0.150
     8.020   144.328     0.150
     8.020   201.930     0.150
     8.535   128.230     0.150
     8.535   153.730     0.150
     8.535   158.129     0.150
     8.535   272.129     0.150
     8.535   128.930     0.150
     8.535   157.629     0.150
     8.535   266.129     0.150
     8.807   155.828     0.150
     8.807   176.828     0.150
     8.807   244.527     0.150
     8.807   129.730     0.150
     8.807   159.527     0.150
     8.807   273.527     0.150
     8.969   139.328     0.150
     8.969   236.527     0.150
     8.969   263.828     0.150
     8.969   131.930     0.150
     9.215   167.230     0.150
     9.215   229.828     0.150
     9.215   267.629     0.150
     9.215   302.527     0.150
     9.435   134.062     0.150
     9.435   291.328     0.150
     9.435   135.527     0.150
     9.435   135.539     0.150
    10.081   141.418     0.150
    10.081   306.371     0.150
    10.081   141.129     0.150
    10.081   142.277     0.150
    11.050   178.129     0.150
    11.050   292.430     0.150
    11.211   189.930     0.150
    11.211   333.527     0.150
    14.386   369.730     0.150
    15.280   382.527     0.150
    16.779   236.180     0.150
    16.853   224.328     0.150
    17.780   242.754     0.150
    17.780   425.180     0.150
    17.780   549.578     0.150
    19.815   274.039     0.150
    19.815   274.027     0.150
    20.440   626.980     0.150
    20.440   276.730     0.150
    20.698     4.203     0.150
    20.698   282.738     0.150
    20.842   285.129     0.150
    21.618   292.367     0.150
    21.653   677.055     0.150
    21.781   294.629     0.150
    21.781   294.660     0.150
    24.228   316.930     0.150
    24.858   326.328     0.150
    24.858   590.129     0.150
    25.246   329.430     0.150
    25.428   340.328     0.150
    25.487   597.277     0.150
    25.487   330.629     0.150
    25.487   597.230     0.150
    25.701   334.527     0.150
    25.731   334.730     0.150
    25.781   331.230     0.150
    26.124   337.828     0.150
    26.123   334.629     0.150
    26.356   340.328     0.150
    26.705   342.730     0.150
    26.795   344.527     0.150
    26.778   345.160     0.150
    26.778   345.129     0.150
    27.249   347.527     0.150
    27.934   353.629     0.150
    30.074   390.730     0.150
    30.447   374.910     0.150
    31.342   383.629     0.150
    42.612   476.938     0.150
    44.425   490.730     0.150
    45.348   497.230     0.150
    47.803   517.129     0.150
    47.803   517.129     0.150
    53.987   564.328     0.150
    53.991   565.828     0.150
    54.643   572.527     0.150
    56.094   580.629     0.150
    77.630   717.250     0.150
     0.159     3.680     0.150
     0.159     6.277     0.150
     0.753    14.879     0.150
     1.410    24.078     0.150
     1.410    42.980     0.150
     1.410    23.980     0.150
     1.410    42.480     0.150
     1.577    28.480     0.150
     1.577    48.578     0.150
     1.617    54.277     0.150
     1.617    29.277     0.150
     1.617    51.777     0.150
     1.530    33.379     0.150
     1.530    28.277     0.150
     1.530    48.078     0.150
     2.445    39.777     0.150
     3.661    67.180     0.150
     3.661   102.180     0.150
     3.661   115.980     0.150
     4.032    75.078     0.150
     4.032    73.980     0.150
     4.556    82.578     0.150
     5.088    92.180     0.150
     5.132    91.980     0.150
     5.365    96.480     0.150
     5.567   100.180     0.150
     5.757   103.180     0.150
     5.757   105.078     0.150
     6.356   113.180     0.150
     6.356   194.680     0.150
     6.656   117.980     0.150
     7.115   128.480     0.150
     7.115   220.180     0.150
     7.615   135.480     0.150
     7.615   138.980     0.150
     8.110   146.777     0.150
     8.506   132.680     0.150
     8.506   152.480     0.150
     8.506   167.980     0.150
     8.506   129.480     0.150
     8.746   136.578     0.150
     8.746   238.180     0.150
     8.746   157.777     0.150
     8.746   272.078     0.150
    16.149   511.133     0.150
    16.795   531.020     0.150
    28.371   352.277     0.150
    45.373   502.043     0.150
    48.101   517.379     0.150
     0.119     3.498     0.150
     0.516     9.697     0.150
     1.074    17.297     0.150
     1.074    31.797     0.150
     1.074    17.297     0.150
     1.259    22.697     0.150
     1.369    25.396     0.150
     1.369    24.197     0.150
     1.369    41.998     0.150
     1.832    55.498     0.150
     2.312    38.598     0.150
     2.312    72.396     0.150
     2.730    53.998     0.150
     3.150    97.098     0.150
     3.494    87.697     0.150
     3.955    64.896     0.150
     3.955    76.498     0.150
     3.955   130.197     0.150
     3.955    60.498     0.150
     3.955    70.598     0.150
     3.955   122.797     0.150
     4.214    69.498     0.150
     4.214    65.197     0.150
     4.214    75.998     0.150
     4.590    82.697     0.150
     5.352    96.396     0.150
     5.352    97.297     0.150
     5.438    98.197     0.150
     5.438   153.998     0.150
     5.662   102.697     0.150
     5.900   106.197     0.150
     6.258   112.697     0.150
     6.310   122.197     0.150
     6.310   148.797     0.150
     6.310   160.297     0.150
     6.879   123.498     0.150
     6.879   153.998     0.150
     6.879   167.197     0.150
     7.320   130.498     0.150
     7.320   137.098     0.150
     7.320   128.998     0.150
     7.768   138.998     0.150
     7.768   214.098     0.150
     7.768   238.998     0.150
     8.379   151.697     0.150
     8.379   260.297     0.150
     8.379   128.098     0.150
     8.638   139.797     0.150
     8.638   227.998     0.150
     8.638   129.896     0.150
     8.638   156.598     0.150
     8.796   134.098     0.150
     8.796   244.297     0.150
     8.796   158.498     0.150
     8.796   272.098     0.150
     9.101   128.797     0.150
    11.040   315.498     0.150
    12.276   222.098     0.150
    16.612   237.748     0.150
    21.444   288.697     0.150
     0.269     5.977     0.150
     0.986    19.777     0.150
     0.768    14.777     0.150
     1.275    21.277     0.150
     1.275    38.477     0.150
     1.275    21.176     0.150
     1.275    38.875     0.150
     1.605    28.777     0.150
     2.104    41.277     0.150
     2.104    35.477     0.150
     2.459    49.074     0.150
     2.544    52.977     0.150
     3.455    71.875     0.150
     3.455    53.477     0.150
     3.455    63.574     0.150
     3.851   124.574     0.150
     3.851    68.875     0.150
     3.851   105.176     0.150
     3.851   120.277     0.150
     4.221    76.977     0.150
     4.251    78.375     0.150
     4.251   106.477     0.150
     4.251   140.277     0.150
     4.509    73.477     0.150
     4.509    80.875     0.150
     4.509    81.375     0.150
     4.509   139.977     0.150
     4.894    87.977     0.150
     5.650   101.074     0.150
     5.743   103.477     0.150
     6.205   112.777     0.150
     6.205   158.277     0.150
     6.557   118.375     0.150
     6.557   202.977     0.150
     6.606   119.477     0.150
     6.606   204.875     0.150
     6.939   127.176     0.150
     6.939   214.676     0.150
     7.176   129.875     0.150
     7.176   222.277     0.150
     7.615   114.945     0.150
     7.615   140.777     0.150
     7.615   221.977     0.150
     8.056   144.176     0.150
     8.056   248.176     0.150
     8.922   244.777     0.150
     9.063   247.777     0.150
     9.925   136.176     0.150
    11.127   322.875     0.150
    17.640   239.875     0.150
    17.640   422.250     0.150
    17.640   550.477     0.150
    17.640   240.375     0.150
    21.695   286.777     0.150
    28.620   352.875     0.150
    44.641   488.777     0.150
    77.794   718.570     0.150
     1.093    22.648     0.150
     1.093    39.250     0.150
     1.237    20.453     0.150
     1.237    37.250     0.150
     1.538    30.648     0.150
     1.538    48.148     0.150
     1.538    27.852     0.150
     1.538    48.148     0.150
     1.788    55.250     0.150
     1.788    55.352     0.150
     1.956    35.453     0.150
     1.956    60.648     0.150
     2.481    48.352     0.150
     2.481    77.555     0.150
     3.290   111.055     0.150
     3.290   102.750     0.150
     3.812   102.352     0.150
     3.812   124.352     0.150
     3.812    60.148     0.150
     4.029    82.852     0.150
     4.094   133.648     0.150
     4.736    71.453     0.150
     4.736    85.953     0.150
     4.736   154.055     0.150
     5.509    82.148     0.150
     5.576   100.352     0.150
     5.809   105.055     0.150
     5.854   106.250     0.150
     6.139   111.250     0.150
     6.413   110.148     0.150
     6.412   116.250     0.150
     6.412   213.852     0.150
     6.412    94.852     0.150
     6.412   115.055     0.150
     6.825   123.352     0.150
     7.480   133.750     0.150
     7.480   195.750     0.150
     7.480   135.148     0.150
     7.480   231.953     0.150
     7.645   115.555     0.150
     7.932   125.852     0.150
     7.932   141.953     0.150
     7.932   145.250     0.150
     8.022   147.055     0.150
     8.804   149.055     0.150
     8.804   176.453     0.150
     8.804   228.453     0.150
     8.966   139.750     0.150
     8.966   162.555     0.150
     8.966   277.750     0.150
    11.773   164.953     0.150
    12.447   223.453     0.150
    16.905   238.750     0.150
    25.243   325.555     0.150
     1.030    20.713     0.150
     1.229    20.413     0.150
     1.229    34.813     0.150
     1.561    28.213     0.150
     1.561    32.313     0.150
     2.502    87.313     0.150
     3.424    67.913     0.150
     3.424    96.013     0.150
     4.217    80.013     0.150
     4.217   102.513     0.150
     4.217   116.113     0.150
     4.218    93.413     0.150
     4.218   134.213     0.150
     4.315   138.913     0.150
     4.470    76.513     0.150
     4.470   144.813     0.150
     4.860   106.613     0.150
     5.612   161.213     0.150
     5.711   183.513     0.150
     5.931   149.213     0.150
     5.931   188.113     0.150
     6.011   112.813     0.150
     6.011   181.913     0.150
     6.106   194.513     0.150
     6.172   175.713     0.150
     6.520   198.213     0.150
     6.598    98.113     0.150
     6.598   209.613     0.150
     7.138   119.913     0.150
     7.577    91.213     0.150
     7.577   212.613     0.150
     8.015   143.213     0.150
     8.644   131.013     0.150
     8.644   277.813     0.150
     8.880   131.013     0.150
     8.880   142.913     0.150
     8.880   272.713     0.150
     8.880   282.513     0.150
     9.020   132.513     0.150
     9.020   143.613     0.150
     9.020   240.313     0.150
    11.083   338.113     0.150
    11.277   358.113     0.150
    12.469   392.413     0.150
     0.565    15.742     0.150
     1.105    22.539     0.150
     1.105    39.242     0.150
     1.226    24.641     0.150
     1.226    37.539     0.150
     1.226    46.344     0.150
     1.527    33.539     0.150
     1.794    34.742     0.150
     2.575    85.844     0.150
     3.278    62.438     0.150
     4.023    65.938     0.150
     4.082    68.938     0.150
     4.361   141.039     0.150
     4.354    76.242     0.150
     5.564   101.141     0.150
     5.797   105.742     0.150
     5.797   112.141     0.150
     6.030 50596.641     0.150
     6.030   113.844     0.150
     6.400   207.938     0.150
     6.405   103.539     0.150
     7.467   116.938     0.150
     7.920   122.742     0.150
     7.920   138.742     0.150
     7.920   221.242     0.150
     8.519   249.344     0.150
     8.791   124.344     0.150
     8.791   253.742     0.150
     8.953   251.641     0.150
    11.034   324.742     0.150
    12.435   371.742     0.150
     0.458     8.676     0.150
     0.458    14.477     0.150
     0.614    11.676     0.150
     0.614    20.375     0.150
     0.688    13.375     0.150
     0.688    21.777     0.150
     1.148    44.176     0.150
     1.219    24.477     0.150
     1.219    22.477     0.150
     1.219    39.176     0.150
     1.343    25.578     0.150
     2.002    36.375     0.150
     2.002    63.477     0.150
     2.585    73.977     0.150
     2.723    48.078     0.150
     2.723    83.578     0.150
     2.744    45.078     0.150
     2.907    74.977     0.150
     2.907    85.477     0.150
     3.367    61.875     0.150
     3.875    75.676     0.150
     4.033    73.977     0.150
     4.033   126.676     0.150
     4.420    80.375     0.150
     4.420   115.676     0.150
     4.971    89.375     0.150
     4.971    95.375     0.150
     4.964    90.578     0.150
     4.991    90.477     0.150
     4.991    90.375     0.150
     5.579    99.875     0.150
     5.791    85.176     0.150
     5.791   104.777     0.150
     5.791   102.676     0.150
     5.791   149.375     0.150
     5.791   177.176     0.150
     5.814   104.977     0.150
     5.814   109.977     0.150
     6.012    90.777     0.150
     6.012   108.578     0.150
     6.445   116.777     0.150
     7.102   129.777     0.150
     7.478   135.578     0.150
     7.478   111.578     0.150
     7.478   234.777     0.150
     7.569   137.676     0.150
     7.995   117.477     0.150
     7.995   117.465     0.150
     8.087   119.008     0.150
     8.264   262.297     0.150
     8.264   121.977     0.150
     9.714   267.977     0.150
    11.004   161.676     0.150
    11.489   158.895     0.150
    11.489   284.496     0.150
    15.456   491.578     0.150
    17.599   241.078     0.150
    17.863   244.777     0.150
    17.863   245.027     0.150
    20.144   272.867     0.150
    20.309   275.375     0.150
    20.309   275.355     0.150
    27.802   391.375     0.150
    27.802   620.176     0.150
    43.988   488.875     0.150
    46.294   507.355     0.150
    47.659   516.125     0.150
    47.748   518.258     0.150
     0.224     4.702     0.150
     0.576    11.202     0.150
     0.576    19.202     0.150
     1.088    23.202     0.150
     1.088    40.002     0.150
     1.088    33.802     0.150
     1.241    24.602     0.150
     1.241    44.002     0.150
     1.241    22.902     0.150
     1.241    39.602     0.150
     1.543    29.202     0.150
     1.543    47.802     0.150
     1.787    35.202     0.150
     1.787    55.502     0.150
     1.961    38.402     0.150
     1.961    60.402     0.150
     2.557    47.902     0.150
     3.295    63.202     0.150
     3.295   111.602     0.150
     3.808    63.202     0.150
     3.808   124.702     0.150
     3.808    60.502     0.150
     4.031    80.902     0.150
     4.378    73.402     0.150
     4.378    83.802     0.150
     4.378    80.402     0.150
     5.285    95.702     0.150
     5.513    98.202     0.150
     5.513   103.502     0.150
     5.513    99.302     0.150
     5.581   101.702     0.150
     5.581   107.002     0.150
     5.814   105.102     0.150
     5.859   106.202     0.150
     5.900   107.102     0.150
     6.113   110.302     0.150
     6.418   115.402     0.150
     6.414   117.502     0.150
     6.414   201.102     0.150
     6.414   115.902     0.150
     6.801   122.302     0.150
     6.829   123.802     0.150
     6.829    95.402     0.150
     6.829   124.202     0.150
     7.041   130.002     0.150
     7.484   135.901     0.150
     7.484   232.102     0.150
     7.484   134.502     0.150
     7.644   239.602     0.150
     7.644   110.532     0.150
     7.937   142.302     0.150
     8.018   115.902     0.150
     8.536   128.602     0.150
     8.536   154.602     0.150
     8.536   267.002     0.150
     8.809   140.102     0.150
     8.809   159.702     0.150
     8.809   272.102     0.150
     8.971   142.002     0.150
     9.436   138.282     0.150
    10.080   141.401     0.150
    11.051   276.802     0.150
    15.144   219.702     0.150
    15.144   390.802     0.150
    15.144   405.702     0.150
    15.279   221.602     0.150
    16.077   232.901     0.150
    16.077   407.802     0.150
    16.098   229.962     0.150
    16.504   233.762     0.150
    16.504   234.042     0.150
    16.780   529.852     0.150
    16.780   236.502     0.150
    16.902   232.102     0.150
    16.902   231.632     0.150
    17.782   243.077     0.150
    17.782   432.577     0.150
    17.782   242.752     0.150
    19.090     4.500     0.150
    19.090     7.300     0.150
    19.817   273.802     0.150
    20.699     4.700     0.150
    20.699    10.500     0.150
    20.840   656.202     0.150
    21.103   278.302     0.150
    21.103     7.400     0.150
    21.103    10.900     0.150
    21.103     4.600     0.150
    21.103   522.802     0.150
    21.103   533.901     0.150
    21.619   291.412     0.150
    21.619   291.562     0.150
    21.655   688.499     0.150
    21.783   293.321     0.150
    22.269   301.602     0.150
    22.269     8.000     0.150
    22.269   550.102     0.150
    24.859   325.401     0.150
    25.248   327.502     0.150
    25.221   327.562     0.150
    25.488   328.702     0.150
    25.703   333.302     0.150
    25.733   332.602     0.150
    26.126   337.002     0.150
    26.451   615.401     0.150
    26.358   338.702     0.150
    26.707   342.002     0.150
    26.796   343.202     0.150
    26.780   343.202     0.150
    26.935   344.401     0.150
    27.251   345.602     0.150
    29.908   376.802     0.150
    30.449   374.132     0.150
    31.344   382.901     0.150
    32.706   395.502     0.150
    37.296   431.202     0.150
    37.310   434.102     0.150
    38.216   440.812     0.150
    42.266   471.981     0.150
    42.634   478.202     0.150
    44.116   490.102     0.150
    44.980   496.842     0.150
    45.346   499.212     0.150
    46.016   504.571     0.150
    46.445   508.042     0.150
    46.504   508.441     0.150
    46.523   508.672     0.150
    46.894   511.231     0.150
    51.832   551.302     0.150
    52.304   552.802     0.150
    52.705   558.102     0.150
    53.143   561.552     0.150
    53.621   565.643     0.150
    53.621   565.002     0.150
    53.993   566.502     0.150
    54.210   568.401     0.150
    54.901   573.102     0.150
    54.996   571.807     0.150
    55.978   582.970     0.150
    56.096   581.202     0.150
    56.255   581.562     0.150
    56.752   587.938     0.150
    57.287   591.030     0.150
    57.744   594.602     0.150
    57.952   596.606     0.150
    58.330   599.273     0.150
    58.812   599.262     0.150
    59.336   604.802     0.150
    60.040   609.202     0.150
    61.846   622.602     0.150
    62.240   623.901     0.150
    62.607   626.102     0.150
    63.249   631.202     0.150
    63.375   629.632     0.150
    65.766   645.242     0.150
    68.519   666.177     0.150
    71.771   683.702     0.150
    75.196   702.972     0.150
    77.622   717.151     0.150
    81.206   735.478     0.150
    81.182   737.111     0.150
    81.603   739.791     0.150
    83.064   747.142     0.150
    83.853   750.802     0.150
    83.853   750.752     0.150
    84.534   753.441     0.150
    86.339   763.401     0.150
    86.339   763.412     0.150
   151.351  1192.729     0.150
     0.223     4.383     0.150
     0.223     7.680     0.150
     0.617    11.281     0.150
     1.062    21.586     0.150
     1.062    39.281     0.150
     1.062    19.883     0.150
     1.248    46.984     0.150
     1.557    52.086     0.150
     1.557    48.680     0.150
     1.747    31.484     0.150
     2.533    49.781     0.150
     2.500    48.484     0.150
     3.447   115.883     0.150
     3.330    88.281     0.150
     3.330   111.883     0.150
     3.330    53.586     0.150
     3.814    61.680     0.150
     3.814   139.680     0.150
     3.814    60.086     0.150
     4.071    73.586     0.150
     4.319   143.086     0.150
     4.408    80.180     0.150
     4.408   144.781     0.150
     4.408    80.086     0.150
     5.544    99.586     0.150
     5.544   140.781     0.150
     5.544   100.586     0.150
     5.847    89.484     0.150
     5.847   100.680     0.150
     5.847   105.781     0.150
     5.892   105.680     0.150
     6.099   109.781     0.150
     6.116   106.883     0.150
     6.081   107.883     0.150
     6.081   110.383     0.150
     6.455   117.484     0.150
     6.455   116.281     0.150
     6.449    94.680     0.150
     6.449   116.484     0.150
     6.449   156.086     0.150
     6.449   181.883     0.150
     6.832   122.086     0.150
     6.832   217.984     0.150
     6.858   124.086     0.150
     7.071   215.586     0.150
     7.514   134.984     0.150
     7.514   214.281     0.150
     7.514   136.586     0.150
     7.964   128.086     0.150
     7.964   142.883     0.150
     8.568   274.281     0.150
     8.568   157.383     0.150
     8.568   266.281     0.150
     8.835   233.984     0.150
     8.835   160.086     0.150
     8.835   273.680     0.150
     8.992   140.680     0.150
     9.255   135.305     0.150
    10.045   250.336     0.150
    10.045   141.891     0.150
    11.237   184.984     0.150
    12.467   188.383     0.150
    12.467   230.180     0.150
    12.774   393.609     0.150
    16.861   232.484     0.150
    16.861   232.516     0.150
    16.787   529.383     0.150
    17.753   244.656     0.150
    17.753   561.031     0.150
    17.753   244.781     0.150
    17.753   244.734     0.150
    19.128   273.383     0.150
    19.836   273.086     0.150
    20.725   282.211     0.150
    21.801   293.727     0.150
    24.877   324.984     0.150
    25.509   329.180     0.150
    26.146   337.383     0.150
    26.376   339.586     0.150
    26.724   342.484     0.150
    26.815   343.484     0.150
    26.798   343.781     0.150
    27.266   346.484     0.150
    28.565   359.227     0.150
    30.464   375.383     0.150
    30.464   375.453     0.150
    31.359   383.883     0.150
    46.464   507.570     0.150
    91.129   788.281     0.150
     0.111     2.254     0.150
     0.554    10.156     0.150
     0.554    18.156     0.150
     1.112    34.555     0.150
     1.112    20.355     0.150
     1.205    42.254     0.150
     1.205    21.754     0.150
     1.205    37.656     0.150
     1.414    25.555     0.150
     1.414    27.355     0.150
     1.414    25.555     0.150
     1.791    54.754     0.150
     1.791    70.754     0.150
     1.858    34.453     0.150
     1.858    35.355     0.150
     1.858    33.656     0.150
     2.357    42.055     0.150
     2.677    92.254     0.150
     2.677    44.355     0.150
     2.677    82.156     0.150
     3.206    60.555     0.150
     3.206    82.055     0.150
     3.206   110.754     0.150
     3.206    51.754     0.150
     3.206    99.754     0.150
     3.929    73.355     0.150
     3.929    92.754     0.150
     3.929   127.656     0.150
     3.929   150.953     0.150
     3.929    61.355     0.150
     3.929   122.156     0.150
     4.003    73.355     0.150
     4.003    75.055     0.150
     4.003   131.355     0.150
     4.028   131.953     0.150
     4.269    68.754     0.150
     4.269    77.855     0.150
     4.269    67.254     0.150
     4.269    77.953     0.150
     4.269   132.254     0.150
     5.186    93.355     0.150
     5.186    94.953     0.150
     5.407    92.156     0.150
     5.407    96.355     0.150
     5.407   102.555     0.150
     5.407   122.754     0.150
     5.407   176.953     0.150
     5.407    81.953     0.150
     5.407    96.656     0.150
     5.717   102.855     0.150
     5.717   105.953     0.150
     5.717   134.656     0.150
     5.761   104.453     0.150
     5.800   178.254     0.150
     5.955    94.453     0.150
     5.955   100.953     0.150
     5.955   107.855     0.150
     6.242   113.055     0.150
     6.313   102.055     0.150
     6.313   113.754     0.150
     6.398   102.055     0.150
     6.398   115.953     0.150
     6.398   140.055     0.150
     6.398   184.156     0.150
     6.398   212.855     0.150
     6.398   114.855     0.150
     6.696   117.754     0.150
     6.696   120.656     0.150
     6.696   130.156     0.150
     6.718   122.254     0.150
     7.375   119.453     0.150
     7.375   132.055     0.150
     7.375   133.355     0.150
     7.375   228.355     0.150
     7.713   111.086     0.150
     7.822   123.254     0.150
     7.822   141.055     0.150
     7.822   141.754     0.150
     8.146   254.754     0.150
     8.434   259.754     0.150
     8.692   127.055     0.150
     8.692   268.656     0.150
     8.847   248.254     0.150
     8.847   224.656     0.150
     8.847   272.254     0.150
     9.153   134.754     0.150
     9.369   244.977     0.150
    10.173   253.305     0.150
    10.173   261.855     0.150
    12.886   323.281     0.150
    12.886   394.129     0.150
    12.886   183.555     0.150
    15.267   219.156     0.150
    15.267   388.254     0.150
    16.115   232.227     0.150
    16.651   517.406     0.150
    16.936   231.023     0.150
    17.713   243.105     0.150
    17.713   429.504     0.150
    17.713   242.555     0.150
    17.713   242.566     0.150
    19.887   275.156     0.150
    21.055     2.801     0.150
    21.055     4.898     0.150
    21.493   290.656     0.150
    21.656   292.246     0.150
    30.320   374.555     0.150
    30.320   374.535     0.150
    30.320   374.555     0.150
    30.320   374.535     0.150
    39.142   448.555     0.150
    42.720   478.336     0.150
    46.563   508.535     0.150
    53.018   556.555     0.150
    56.152   579.555     0.150
     0.099     1.996     0.150
     1.111    34.297     0.150
     1.111    38.594     0.150
     1.111    41.496     0.150
     1.111    20.195     0.150
     1.111    34.395     0.150
     1.196    37.797     0.150
     1.196    41.594     0.150
     1.417    27.797     0.150
     1.771    33.695     0.150
     1.771    54.496     0.150
     1.872    35.094     0.150
     1.872    59.094     0.150
     2.360    37.797     0.150
     2.360    41.094     0.150
     3.222    60.695     0.150
     3.222   110.895     0.150
     3.936   128.094     0.150
     3.936    61.297     0.150
     4.281    77.695     0.150
     5.420    97.695     0.150
     5.420    81.996     0.150
     5.732   103.297     0.150
     5.776   104.797     0.150
     5.971   107.496     0.150
     5.971   194.695     0.150
     6.418   115.594     0.150
     6.418   211.594     0.150
     6.418    94.496     0.150
     6.418   117.195     0.150
     6.709   119.895     0.150
     6.709   203.895     0.150
     6.730   122.594     0.150
     7.387   131.695     0.150
     7.833   141.395     0.150
     7.833   218.996     0.150
     7.729   113.895     0.150
     8.448   152.695     0.150
     8.448   126.695     0.150
     8.702   154.094     0.150
     8.702   268.996     0.150
     8.855   159.395     0.150
     8.855   272.797     0.150
    16.650   525.621     0.150
    17.696   242.844     0.150
    19.035     5.098     0.150
    19.035     8.398     0.150
     0.576    13.398     0.150
     0.576    22.598     0.150
     0.576    11.098     0.150
     1.124    39.098     0.150
     1.124    20.797     0.150
     1.184    24.398     0.150
     1.184    25.898     0.150
     1.184    42.496     0.150
     1.184    37.996     0.150
     1.430    29.797     0.150
     1.430    45.098     0.150
     1.770    54.699     0.150
     1.882    35.398     0.150
     1.882    59.199     0.150
     2.373    48.598     0.150
     2.373    40.996     0.150
     2.657    92.699     0.150
     3.230    63.496     0.150
     3.230   109.496     0.150
     3.230   100.797     0.150
     3.447   114.297     0.150
     3.924    72.496     0.150
     3.924   129.996     0.150
     3.924   137.199     0.150
     3.924   107.297     0.150
     3.924   122.699     0.150
     4.028   133.598     0.150
     4.292    80.098     0.150
     4.292    67.797     0.150
     4.292    78.898     0.150
     5.210    96.898     0.150
     5.430    93.098     0.150
     5.430    96.996     0.150
     5.430    96.898     0.150
     5.430   139.297     0.150
     5.742   106.398     0.150
     5.980   108.996     0.150
     5.980   199.098     0.150
     6.226   112.996     0.150
     6.337   114.797     0.150
     6.420   115.699     0.150
     6.420   215.598     0.150
     6.420   115.699     0.150
     6.719   120.598     0.150
     6.719   189.797     0.150
     6.719   213.199     0.150
     6.741   122.297     0.150
     7.398   120.797     0.150
     7.398   136.098     0.150
     7.398   111.379     0.150
     7.723   112.398     0.150
     7.845   141.297     0.150
     8.136   116.598     0.150
     8.458   153.898     0.150
     8.714   154.996     0.150
     8.714   269.699     0.150
     8.867   139.898     0.150
     8.867   173.398     0.150
     8.867   132.098     0.150
     8.867   161.598     0.150
    10.149   143.496     0.150
    10.149   315.824     0.150
    12.882   409.047     0.150
    16.912   234.098     0.150
    17.703   243.121     0.150
    17.703   246.648     0.150
    21.511   291.117     0.150
    21.674   292.148     0.150
    22.270     5.000     0.150
    25.014   325.598     0.150
    30.337   373.148     0.150
    30.337   373.867     0.150
    70.671   677.828     0.150
    79.193   727.699     0.150
    85.410   759.426     0.150
     0.589    23.934     0.150
     0.589    10.836     0.150
     1.127    25.336     0.150
     1.127    38.336     0.150
     1.127    20.633     0.150
     1.176    24.133     0.150
     1.176    25.734     0.150
     1.176    22.035     0.150
     1.756    54.133     0.150
     1.893    46.633     0.150
     1.893    62.535     0.150
     2.378    45.734     0.150
     2.649    53.336     0.150
     2.649    62.133     0.150
     3.242    83.535     0.150
     3.242    59.234     0.150
     3.925   127.836     0.150
     3.925   137.535     0.150
     4.039   101.035     0.150
     4.302    79.633     0.150
     4.302    85.336     0.150
     4.302   120.836     0.150
     4.302    78.836     0.150
     4.440    74.836     0.150
     5.222    95.336     0.150
     5.441    86.836     0.150
     5.441    92.234     0.150
     5.441    97.734     0.150
     5.441   181.633     0.150
     5.753   146.336     0.150
     5.753   184.934     0.150
     5.797   100.934     0.150
     5.797   108.535     0.150
     5.797   187.535     0.150
     5.835   109.336     0.150
     5.835   198.434     0.150
     6.221   111.035     0.150
     6.221   114.434     0.150
     6.348   115.234     0.150
     6.348   185.434     0.150
     6.433   122.934     0.150
     6.433   216.035     0.150
     6.730   117.734     0.150
     6.730   212.633     0.150
     6.751   121.836     0.150
     6.751   212.234     0.150
     6.751   121.836     0.150
     6.751   210.535     0.150
     7.409   133.934     0.150
     7.409   224.234     0.150
     7.409   230.734     0.150
     7.854   164.934     0.150
     7.854   223.336     0.150
     8.469   310.734     0.150
     8.723   185.836     0.150
     8.723   262.133     0.150
     8.875   127.336     0.150
     9.192   137.934     0.150
     9.192   137.953     0.150
    10.137   313.184     0.150
    10.137   142.434     0.150
    11.123   167.133     0.150
    12.173   385.633     0.150
    14.387   207.133     0.150
    14.387   368.633     0.150
    14.500   371.934     0.150
    15.302   387.836     0.150
    16.125   406.234     0.150
    16.146   227.812     0.150
    16.666   525.914     0.150
    16.614   234.645     0.150
    16.614   525.465     0.150
    16.899   233.035     0.150
    16.899   232.766     0.150
    17.693   242.836     0.150
    17.693   240.633     0.150
    17.693   240.613     0.150
    17.912   239.934     0.150
    18.389   260.336     0.150
    18.389   452.234     0.150
    19.717   271.336     0.150
    20.101   297.035     0.150
    20.524   280.996     0.150
    20.614   277.336     0.150
    20.614   277.324     0.150
    20.682   516.633     0.150
    21.093     4.301     0.150
    21.518   290.086     0.150
    21.543   675.262     0.150
    21.681   291.953     0.150
    22.283     4.598     0.150
    22.283   299.375     0.150
    23.649   555.934     0.150
    24.757   323.234     0.150
    25.391   327.234     0.150
    25.604   332.133     0.150
    26.604   340.734     0.150
    26.696   341.234     0.150
    27.056   345.133     0.150
    29.813   374.234     0.150
    30.025   370.133     0.150
    30.342   373.055     0.150
    30.342   373.055     0.150
    31.238   381.336     0.150
    31.944     5.801     0.150
    31.944     8.699     0.150
    34.366   408.684     0.150
    35.563   415.734     0.150
    37.186   514.934     0.150
    38.267   440.984     0.150
    42.683   477.133     0.150
    42.683   477.113     0.150
    44.463   492.555     0.150
    45.057   497.125     0.150
    45.898   501.285     0.150
    45.898   501.285     0.150
    45.898   649.156     0.150
    45.898  1162.324     0.150
    46.063   503.355     0.150
    46.486   508.133     0.150
    46.525   508.633     0.150
    46.525   508.633     0.150
    47.468   510.035     0.150
    47.468   923.133     0.150
    47.690   516.812     0.150
    48.131   520.035     0.150
    53.025   555.133     0.150
    53.025   555.156     0.150
    53.883   564.133     0.150
    53.905   563.734     0.150
    53.905   563.734     0.150
    54.098   566.434     0.150
    54.536   569.633     0.150
    54.536   569.715     0.150
    54.929   579.234     0.150
    55.215   574.285     0.150
    55.986   579.504     0.150
    56.582   624.676     0.150
    58.703   598.465     0.150
    59.176   601.113     0.150
    62.129   622.734     0.150
    62.129   622.766     0.150
    63.371   629.684     0.150
    65.774   644.812     0.150
    67.479   657.203     0.150
    67.697   659.465     0.150
    68.182   661.863     0.150
    70.658   677.195     0.150
    71.761   683.355     0.150
    72.877   690.543     0.150
    73.603   694.633     0.150
    74.284   698.734     0.150
    74.873   702.824     0.150
    75.009   703.363     0.150
    75.214   702.805     0.150
    75.610   705.645     0.150
    76.129   708.984     0.150
    76.298   710.016     0.150
    76.627   710.094     0.150
    76.719   713.145     0.150
    77.700   717.133     0.150
    77.713   718.426     0.150
    78.031   720.715     0.150
    78.823   724.023     0.150
    79.180   727.473     0.150
    79.291   725.863     0.150
    79.854   729.723     0.150
    80.384   731.555     0.150
    80.989   736.305     0.150
    81.215   737.062     0.150
    81.747   739.254     0.150
    83.044   746.793     0.150
    83.156   746.285     0.150
    83.856   750.406     0.150
    84.078   751.414     0.150
    84.529   753.824     0.150
    85.397   758.484     0.150
    86.338   762.766     0.150
    89.176   777.004     0.150
     0.118     2.262     0.150
     1.133    35.062     0.150
     1.133    22.863     0.150
     1.176    23.664     0.150
     1.176    41.562     0.150
     1.888    35.562     0.150
     1.888    36.363     0.150
     1.770    65.363     0.150
     2.382    78.863     0.150
     2.649   102.562     0.150
     3.236   111.262     0.150
     3.236   121.863     0.150
     4.033   132.961     0.150
     3.915   127.164     0.150
     3.915   128.863     0.150
     3.915    58.762     0.150
     4.048    75.062     0.150
     5.437   180.863     0.150
     5.748   165.062     0.150
     5.748   188.062     0.150
     6.343   125.961     0.150
     6.420   215.664     0.150
     6.726   204.164     0.150
     8.721   284.062     0.150
     8.876   190.961     0.150
     9.397   299.184     0.150
    10.952   296.762     0.150
    10.952   152.863     0.150
    10.952   246.863     0.150
    11.122   303.664     0.150
    11.122   309.863     0.150
    12.349   340.664     0.150
    12.349   191.062     0.150
    17.906   239.461     0.150
    21.520   292.195     0.150
    25.320   328.562     0.150
    37.199   429.762     0.150
    81.236   736.562     0.150
     0.120     2.246     0.150
     0.591    10.848     0.150
     1.163    23.848     0.150
     1.163    21.746     0.150
     1.163    37.047     0.150
     1.141    23.246     0.150
     1.141    42.746     0.150
     1.141    20.945     0.150
     1.449    29.445     0.150
     1.449    26.547     0.150
     1.449    45.547     0.150
     1.755    33.246     0.150
     1.755    54.645     0.150
     1.904    58.547     0.150
     3.252   109.246     0.150
     3.912   137.246     0.150
     3.912   153.547     0.150
     3.912    61.645     0.150
     4.049   133.246     0.150
     4.314   133.348     0.150
     5.232    94.445     0.150
     5.452    97.848     0.150
     5.452   103.145     0.150
     5.763   104.746     0.150
     5.808   105.145     0.150
     5.846   105.848     0.150
     5.846   186.145     0.150
     6.002   108.945     0.150
     6.207   111.945     0.150
     6.359   106.547     0.150
     6.359   114.348     0.150
     6.359   217.145     0.150
     6.435    96.945     0.150
     6.435   109.348     0.150
     6.435   116.445     0.150
     6.435   121.746     0.150
     6.435   211.145     0.150
     6.763   121.848     0.150
     7.420   133.445     0.150
     7.420   136.047     0.150
     7.420   134.348     0.150
     7.866   142.945     0.150
     7.866   143.945     0.150
     8.121   149.246     0.150
     8.480   162.145     0.150
     8.480   263.145     0.150
     8.735   248.645     0.150
     8.735   157.547     0.150
     8.735   270.445     0.150
     8.888   157.945     0.150
     8.888   160.848     0.150
     8.888   274.945     0.150
    10.963   348.445     0.150
    12.871   313.320     0.150
    16.680   527.496     0.150
    17.701   243.145     0.150
    17.701   432.848     0.150
     0.110     1.820     0.150
     1.134    25.719     0.150
     1.134    36.320     0.150
     1.164    23.320     0.150
     1.444    25.820     0.150
     1.744    33.020     0.150
     1.744    53.422     0.150
     1.744    53.719     0.150
     1.906    36.219     0.150
     1.906    34.020     0.150
     1.906    59.520     0.150
     3.256    62.219     0.150
     3.256   107.219     0.150
     3.256    52.219     0.150
     3.922   127.121     0.150
     3.922    61.121     0.150
     4.315    78.020     0.150
     5.235    93.820     0.150
     5.454    98.121     0.150
     5.454   103.121     0.150
     5.454    96.719     0.150
     5.767   103.621     0.150
     6.006   109.422     0.150
     6.212   112.121     0.150
     6.446   115.719     0.150
     6.446   114.320     0.150
     7.421   229.422     0.150
     8.129   154.422     0.150
     8.886   131.820     0.150
     0.106     2.637     0.150
     0.567    12.938     0.150
     1.116    20.836     0.150
     1.116    35.637     0.150
     1.195    23.938     0.150
     1.195    29.938     0.150
     1.195    47.238     0.150
     1.421    28.637     0.150
     1.421    25.738     0.150
     1.421    44.539     0.150
     1.778    33.938     0.150
     1.778    54.539     0.150
     1.870    35.738     0.150
     1.870    59.039     0.150
     2.667    49.039     0.150
     3.219   100.836     0.150
     3.453    65.039     0.150
     3.453    69.738     0.150
     3.929    78.637     0.150
     3.929   127.438     0.150
     3.929   138.137     0.150
     3.929    61.938     0.150
     3.929    71.738     0.150
     3.929   107.137     0.150
     3.929   122.637     0.150
     4.456    84.336     0.150
     5.419    87.637     0.150
     5.419    98.336     0.150
     5.419   170.836     0.150
     5.419    96.836     0.150
     5.730   103.938     0.150
     5.730   182.137     0.150
     5.813   105.836     0.150
     5.969   108.039     0.150
     6.235   112.238     0.150
     6.235   119.336     0.150
     6.411   116.637     0.150
     6.411   208.637     0.150
     6.411   115.637     0.150
     6.730   122.836     0.150
     7.387   126.336     0.150
     7.387   133.539     0.150
     7.387   235.938     0.150
     7.833   140.938     0.150
     7.833   141.438     0.150
     8.447   226.438     0.150
     8.703   138.438     0.150
     8.703   131.039     0.150
     8.703   269.039     0.150
     8.857   132.336     0.150
     8.857   161.938     0.150
     8.857   274.137     0.150
    10.160   143.082     0.150
    10.160   252.824     0.150
    21.436   293.336     0.150
    21.501   293.117     0.150
    21.531   293.320     0.150
    25.007   328.719     0.150
    55.949   580.422     0.150
    55.949   580.438     0.150
     0.110     2.027     0.150
     0.110     4.027     0.150
     0.561    12.926     0.150
     0.561    18.625     0.150
     1.116    17.828     0.150
     1.116    34.027     0.150
     1.198    36.926     0.150
     1.198    21.527     0.150
     1.198    36.328     0.150
     1.420    44.227     0.150
     1.420    25.328     0.150
     1.420    42.426     0.150
     1.784    54.727     0.150
     1.866    36.527     0.150
     1.866    33.527     0.150
     1.866    59.027     0.150
     2.363    44.727     0.150
     3.214    99.828     0.150
     3.927    64.027     0.150
     5.415    97.227     0.150
     5.415    97.227     0.150
     5.964   108.426     0.150
     6.405   115.527     0.150
     6.405   115.426     0.150
     6.405   201.125     0.150
     7.383   131.727     0.150
     8.699   160.625     0.150
     9.377   245.691     0.150
    10.165   142.051     0.150
    10.165   246.355     0.150
    10.165   322.477     0.150
    12.884   325.527     0.150
    16.608   534.043     0.150
    16.655   534.797     0.150
    21.499   687.402     0.150
    21.499   292.926     0.150
    21.530   686.902     0.150
    71.021   680.828     0.150
     0.590    23.055     0.150
     1.125    19.754     0.150
     1.125    22.453     0.150
     1.125    34.254     0.150
     1.178    25.055     0.150
     1.178    43.555     0.150
     1.178    55.754     0.150
     1.433    29.152     0.150
     1.756    35.055     0.150
     1.891    36.652     0.150
     2.651    86.152     0.150
     3.434    64.555     0.150
     3.927   127.254     0.150
     4.038    80.352     0.150
     4.038   132.953     0.150
     4.442   143.555     0.150
     5.439   183.152     0.150
     5.991   115.555     0.150
     6.223   169.754     0.150
     6.434    96.953     0.150
     6.434   118.254     0.150
     6.434   211.953     0.150
     7.407   135.852     0.150
     7.852   153.953     0.150
     7.852   164.852     0.150
     7.852   264.754     0.150
     8.468   175.453     0.150
     8.721   226.555     0.150
     8.721   238.453     0.150
     8.873   138.352     0.150
     8.873   166.953     0.150
     8.873   281.754     0.150
     0.048     0.658     0.150
     0.609     9.959     0.150
     0.609     9.959     0.150
     1.072    22.459     0.150
     1.072    39.959     0.150
     1.072    19.559     0.150
     1.072    35.158     0.150
     1.218    19.459     0.150
     1.218    21.758     0.150
     1.218    35.059     0.150
     1.218    19.459     0.150
     1.218    34.658     0.150
     1.385    24.758     0.150
     1.385    47.459     0.150
     1.385    24.758     0.150
     1.739    29.459     0.150
     1.739    32.959     0.150
     1.739    51.758     0.150
     1.739    28.959     0.150
     1.739    33.059     0.150
     1.739    52.258     0.150
     1.865    36.658     0.150
     1.865    33.158     0.150
     2.327    45.059     0.150
     2.327    39.158     0.150
     2.327    41.758     0.150
     2.692    42.258     0.150
     2.692    47.059     0.150
     2.692    54.459     0.150
     2.692    68.258     0.150
     2.692    73.559     0.150
     2.692    80.857     0.150
     2.692    42.258     0.150
     2.692    46.959     0.150
     2.692    80.258     0.150
     3.403    51.959     0.150
     3.223    83.658     0.150
     3.223    51.357     0.150
     3.984    59.559     0.150
     3.984    70.158     0.150
     3.984   105.059     0.150
     3.984    59.658     0.150
     3.984    69.959     0.150
     3.984   106.559     0.150
     4.084    61.059     0.150
     4.084    73.158     0.150
     4.268    79.459     0.150
     4.268    66.559     0.150
     4.489    77.459     0.150
     4.489   117.059     0.150
     5.195    94.258     0.150
     5.410    97.059     0.150
     5.410    81.059     0.150
     5.410   141.059     0.150
     5.728   104.658     0.150
     5.772   105.857     0.150
     5.970   108.559     0.150
     6.272    91.959     0.150
     6.272   110.459     0.150
     6.272   190.758     0.150
     6.449    93.559     0.150
     6.449   116.559     0.150
     6.449   177.559     0.150
     6.449    94.059     0.150
     6.449   114.758     0.150
     6.449   198.158     0.150
     6.699   121.758     0.150
     6.717   121.959     0.150
     6.717   121.857     0.150
     7.375   133.758     0.150
     7.375   229.158     0.150
     7.375   132.658     0.150
     7.375   227.357     0.150
     7.779   110.758     0.150
     7.779   110.768     0.150
     7.817   139.559     0.150
     7.817   242.258     0.150
     7.817   139.258     0.150
     8.192   147.059     0.150
     8.441   128.559     0.150
     8.441   128.459     0.150
     8.684   139.158     0.150
     8.684   154.559     0.150
     8.684   268.857     0.150
     8.831   139.658     0.150
     8.831   158.959     0.150
     8.831   225.459     0.150
     8.831   271.857     0.150
     9.398   136.898     0.150
    10.161   141.707     0.150
    10.161   306.707     0.150
    10.161   141.658     0.150
    12.942   327.883     0.150
    14.437   369.059     0.150
    15.307   225.758     0.150
    15.307   383.158     0.150
    15.307   397.258     0.150
    15.307   217.857     0.150
    15.319   391.459     0.150
    16.154   230.158     0.150
    16.176   229.588     0.150
    16.610   516.105     0.150
    16.670   520.383     0.150
    16.892   230.758     0.150
    16.892   229.379     0.150
    17.013   428.857     0.150
    19.044     4.199     0.150
    19.044     6.600     0.150
    19.670   271.258     0.150
    20.031   507.658     0.150
    20.540   277.982     0.150
    20.540   638.008     0.150
    20.540   276.959     0.150
    20.572   280.059     0.150
    20.575   281.658     0.150
    20.628   279.658     0.150
    20.628   511.857     0.150
    20.980   285.299     0.150
    20.980   660.908     0.150
    21.094     3.100     0.150
    21.094     5.600     0.150
    21.094   522.059     0.150
    21.094   529.658     0.150
    21.094   548.059     0.150
    21.395   287.998     0.150
    21.489   672.320     0.150
    21.470   674.250     0.150
    21.633   291.648     0.150
    22.296     6.799     0.150
    22.296   324.559     0.150
    24.315     3.299     0.150
    24.315     6.600     0.150
    24.315   580.959     0.150
    24.315   589.059     0.150
    24.709   323.258     0.150
    24.709   586.857     0.150
    24.958   320.346     0.150
    25.079   326.658     0.150
    25.370   326.789     0.150
    25.370   325.283     0.150
    25.370   327.068     0.150
    25.345   326.758     0.150
    25.585   326.559     0.150
    25.558   330.658     0.150
    25.981   334.857     0.150
    26.208   336.357     0.150
    26.649   340.959     0.150
    26.649   617.658     0.150
    26.632   340.758     0.150
    26.788   343.459     0.150
    27.008   345.059     0.150
    27.094   344.758     0.150
    27.783   351.959     0.150
    28.688   364.258     0.150
    28.774   363.068     0.150
    29.768   374.459     0.150
    29.768     7.100     0.150
    29.974   371.258     0.150
    30.040   674.459     0.150
    30.292   372.039     0.150
    30.292   372.588     0.150
    31.188   381.559     0.150
    31.948     3.500     0.150
    31.948     5.000     0.150
    32.532   390.107     0.150
    34.353   409.168     0.150
    34.461   412.258     0.150
    34.894   415.658     0.150
    34.963   416.959     0.150
    35.024   416.258     0.150
    35.537   421.357     0.150
    35.624   419.549     0.150
    37.130   427.658     0.150
    37.130   427.658     0.150
    37.167   432.818     0.150
    37.430   432.758     0.150
    38.287   440.709     0.150
    42.313   473.738     0.150
    42.453   477.088     0.150
    42.455   473.910     0.150
    42.702   477.559     0.150
    42.702   477.518     0.150
    44.018   484.658     0.150
    44.018   484.658     0.150
    44.018   484.719     0.150
    44.478   492.559     0.150
    44.866   494.059     0.150
    44.866   495.268     0.150
    45.038   498.158     0.150
    45.072   498.027     0.150
    46.042   503.668     0.150
    46.081   504.518     0.150
    46.501   507.938     0.150
    46.530   507.008     0.150
    46.530   507.018     0.150
    46.536   506.777     0.150
    46.998   512.408     0.150
    47.019   509.059     0.150
    47.019   619.459     0.150
    47.190   512.328     0.150
    47.409   508.857     0.150
    47.712   517.129     0.150
    47.632   514.834     0.150
    47.632   516.379     0.150
    47.632   517.197     0.150
    48.077   518.148     0.150
    48.077   518.229     0.150
    48.117   518.479     0.150
    48.330   519.758     0.150
    48.330   520.320     0.150
    50.167   534.959     0.150
    50.167   535.008     0.150
    51.441   547.408     0.150
    51.660   546.486     0.150
    51.660   546.459     0.150
    51.660   546.678     0.150
    52.134   552.459     0.150
    52.738   556.229     0.150
    52.803   554.965     0.150
    52.803   554.959     0.150
    52.967   556.758     0.150
    52.967   555.658     0.150
    52.967   560.658     0.150
    52.967   556.648     0.150
    53.449   558.986     0.150
    53.449   558.959     0.150
    53.537   569.236     0.150
    53.699   562.258     0.150
    53.822   561.258     0.150
    53.822   561.258     0.150
    53.826   562.357     0.150
    53.826   567.357     0.150
    53.826   562.357     0.150
    53.848   562.758     0.150
    53.848   566.857     0.150
    53.848   562.758     0.150
    54.041   564.857     0.150
    54.041   564.857     0.150
    54.480   569.459     0.150
    54.480   569.488     0.150
    54.562   567.158     0.150
    54.562   571.158     0.150
    54.562  1252.158     0.150
    54.562   567.158     0.150
    54.562   571.158     0.150
    54.562  1027.158     0.150
    54.562   570.738     0.150
    54.734   569.357     0.150
    54.824   572.158     0.150
    54.872   578.857     0.150
    54.872     0.000     0.150
    55.809   578.213     0.150
    55.927   576.133     0.150
    55.927   576.158     0.150
    55.930   578.268     0.150
    56.089   578.883     0.150
    56.089   578.709     0.150
    56.584   582.877     0.150
    57.119   587.203     0.150
    57.465   589.510     0.150
    57.577   590.375     0.150
    57.784   591.529     0.150
    58.164   594.318     0.150
    58.192   593.596     0.150
    58.403   599.316     0.150
    58.413   596.096     0.150
    58.650   599.459     0.150
    59.119   600.658     0.150
    59.119   600.697     0.150
    63.363   630.328     0.150
    65.773   645.688     0.150
    67.708   658.758     0.150
    69.967   672.457     0.150
    70.671   677.559     0.150
    70.958   677.334     0.150
    70.958   677.559     0.150
    71.221   679.979     0.150
    72.252   686.578     0.150
    73.069   691.959     0.150
    73.093   691.396     0.150
    73.880   697.348     0.150
    74.216   698.133     0.150
    74.842   699.904     0.150
    74.884   703.688     0.150
    75.022   704.158     0.150
    75.219   704.639     0.150
    75.629   707.309     0.150
    76.036   708.084     0.150
    76.036   708.258     0.150
    76.129   707.928     0.150
    76.310   710.908     0.150
    76.623   712.689     0.150
    76.735   712.777     0.150
    77.738   716.566     0.150
    77.768   719.469     0.150
    77.740   718.607     0.150
    77.743   719.168     0.150
    78.043   720.777     0.150
    79.193   727.219     0.150
    79.365   727.938     0.150
    79.872   730.838     0.150
    79.925   731.939     0.150
    81.169   737.322     0.150
    81.207   738.893     0.150
    81.330   739.492     0.150
    82.098   743.777     0.150
    83.008   747.623     0.150
    83.103   747.658     0.150
    83.853   751.246     0.150
    83.853   751.219     0.150
    84.522   754.648     0.150
    84.530   754.879     0.150
    84.684   751.400     0.150
    84.986   756.969     0.150
    85.184   758.229     0.150
    85.400   759.527     0.150
    85.607   760.648     0.150
    86.332   763.250     0.150
    86.332   763.268     0.150
    89.172   775.559     0.150
    89.172   775.559     0.150
    89.181   778.258     0.150
    89.181   778.180     0.150
    89.181   778.299     0.150
    89.661   780.861     0.150
     0.277     6.227     0.150
     0.277     6.227     0.150
     0.557    16.727     0.150
     0.557    10.828     0.150
     0.788    14.828     0.150
     0.977    20.031     0.150
     0.977    17.828     0.150
     0.977    17.828     0.150
     1.273    23.227     0.150
     1.273    40.633     0.150
     1.273    43.930     0.150
     2.074    43.133     0.150
     2.074    63.430     0.150
     2.670    52.430     0.150
     3.502    64.727     0.150
     3.502    54.328     0.150
     3.502    64.727     0.150
     3.396   110.633     0.150
     3.552    57.531     0.150
     3.552    65.531     0.150
     4.039    72.930     0.150
     4.080    73.328     0.150
     4.428    79.031     0.150
     4.428   120.031     0.150
     4.541    81.828     0.150
     4.734    84.328     0.150
     4.708    84.227     0.150
     4.708    88.133     0.150
     4.930    89.133     0.150
     5.316    94.930     0.150
     5.316   100.828     0.150
     5.128    92.930     0.150
     5.625    92.328     0.150
     5.625   100.328     0.150
     5.981   107.328     0.150
     5.981   113.133     0.150
     5.981   152.430     0.150
     5.997   115.633     0.150
     6.225   114.727     0.150
     6.319   112.133     0.150
     6.319    91.828     0.150
     6.319   113.828     0.150
     6.319   195.727     0.150
     6.650   120.430     0.150
     6.650   120.031     0.150
     6.650   205.531     0.150
     7.109   127.828     0.150
     7.109   177.727     0.150
     7.101   128.430     0.150
     7.101   133.031     0.150
     7.057   218.531     0.150
     7.057   133.930     0.150
     7.057   217.227     0.150
     7.759   239.328     0.150
     7.759   139.430     0.150
     7.759   239.633     0.150
     7.910   242.633     0.150
     7.910   122.727     0.150
     7.910   141.930     0.150
     8.024   143.828     0.150
     8.024   248.531     0.150
     8.024   123.828     0.150
     8.024   143.727     0.150
    10.835   151.172     0.150
    12.380   179.531     0.150
    12.380   188.227     0.150
    12.380   320.727     0.150
    12.380   340.227     0.150
    14.882   212.727     0.150
    14.882   380.727     0.150
    15.795   220.133     0.150
    16.199   236.227     0.150
    16.220   227.219     0.150
    17.219   233.750     0.150
    17.219   412.602     0.150
    17.219   532.750     0.150
    17.219   233.930     0.150
    17.219   232.797     0.150
    17.303   235.102     0.150
    17.303   416.680     0.150
    17.303   543.203     0.150
    17.303   235.727     0.150
    17.303   234.367     0.150
    17.842   237.727     0.150
    18.306   263.531     0.150
    18.522     5.102     0.150
    18.522     9.297     0.150
    18.785   259.633     0.150
    18.697   262.227     0.150
    18.850   257.680     0.150
    19.350   272.727     0.150
    19.350   472.930     0.150
    19.801   267.727     0.150
    20.089   279.227     0.150
    20.647   277.281     0.150
    20.647   644.570     0.150
    20.647   278.430     0.150
    20.810   278.633     0.150
    20.810   278.641     0.150
    20.718     5.500     0.150
    20.718     7.500     0.150
    21.379   286.297     0.150
    21.379   287.930     0.150
    21.461   292.328     0.150
    21.461     5.703     0.150
    22.085     5.102     0.150
    22.085     8.703     0.150
    23.058     7.398     0.150
    23.885   311.273     0.150
    24.260   314.281     0.150
    24.740   319.680     0.150
    24.774   320.078     0.150
    25.075   322.438     0.150
    25.165   323.562     0.150
    25.732   328.367     0.150
    25.828   329.297     0.150
    26.265   332.742     0.150
    27.134   346.531     0.150
    27.134   624.828     0.150
    27.572   347.406     0.150
    27.572   347.227     0.150
    28.959   364.031     0.150
    28.959    10.695     0.150
    28.959   657.328     0.150
    29.180   766.133     0.150
    29.146   358.688     0.150
    29.463   362.141     0.150
    29.886   368.039     0.150
    29.795   370.227     0.150
    30.359   369.977     0.150
    30.435   375.031     0.150
    31.322   378.648     0.150
    31.616   386.727     0.150
    31.616     3.805     0.150
    33.253   395.031     0.150
    33.806   400.891     0.150
    34.830   409.461     0.150
    35.728   415.086     0.150
    36.289   426.133     0.150
    36.354   421.141     0.150
    37.068   424.297     0.150
    37.069   425.133     0.150
    37.614   431.172     0.150
    38.184   436.688     0.150
    38.454   440.156     0.150
    38.915   440.828     0.150
    38.915   440.781     0.150
    38.801   443.758     0.150
    39.952   448.961     0.150
    39.914   449.531     0.150
    41.421   466.227     0.150
    41.924   467.547     0.150
    42.416   467.031     0.150
    42.416   844.531     0.150
    42.416  1069.727     0.150
    42.855   474.758     0.150
    42.899   474.422     0.150
    43.319   478.531     0.150
    43.319   478.500     0.150
    43.457   480.219     0.150
    43.897   484.930     0.150
    43.970   482.938     0.150
    44.194   491.531     0.150
    44.401   490.133     0.150
    44.820   490.852     0.150
    44.891   493.133     0.150
    45.219   591.031     0.150
    45.219   637.328     0.150
    45.219   493.883     0.150
    45.219   493.883     0.150
    45.219   493.883     0.150
    45.219   583.570     0.150
    45.219   591.117     0.150
    45.219   637.328     0.150
    45.219   893.648     0.150
    45.219  1190.531     0.150
    45.426   493.859     0.150
    45.426   494.008     0.150
    45.667   498.227     0.150
    46.194   501.391     0.150
    46.194   502.086     0.150
    46.349   502.602     0.150
    46.255   649.430     0.150
    46.255  1171.430     0.150
    46.431   504.672     0.150
    46.992   506.828     0.150
    46.992   506.797     0.150
    46.967   508.531     0.150
    47.097   508.391     0.150
    47.272   507.797     0.150
    47.868   515.328     0.150
    47.953   518.727     0.150
    48.320   517.148     0.150
    48.339   517.672     0.150
    48.485   518.336     0.150
    49.092   525.133     0.150
    49.620   527.898     0.150
    49.687   529.531     0.150
    50.097   531.211     0.150
    50.799   537.359     0.150
    50.989   538.031     0.150
    51.458   542.594     0.150
    51.458   542.531     0.150
    51.507   548.688     0.150
    51.690   549.430     0.150
    51.690   554.930     0.150
    51.894   547.133     0.150
    52.112   548.047     0.150
    52.650   553.828     0.150
    52.785   553.930     0.150
    52.886   555.227     0.150
    53.087   554.688     0.150
    53.126   559.727     0.150
    53.254   555.773     0.150
    53.226   557.633     0.150
    53.328   556.133     0.150
    53.328   556.102     0.150
    53.411   559.133     0.150
    53.854   561.031     0.150
    53.899   561.727     0.150
    53.899   574.031     0.150
    53.990   570.930     0.150
    53.990   561.727     0.150
    53.990  1266.930     0.150
    54.047   563.930     0.150
    54.156   563.828     0.150
    55.492   571.797     0.150
    55.567   572.922     0.150
    55.923   583.227     0.150
    57.227   584.352     0.150
    57.821   589.891     0.150
    58.512   593.883     0.150
    60.533   607.992     0.150
    61.491   614.031     0.150
    61.491   614.062     0.150
    63.664   628.047     0.150
    66.153   644.797     0.150
    67.463   652.883     0.150
    70.415   670.883     0.150
    70.479   671.633     0.150
    70.479   674.484     0.150
    71.218   677.406     0.150
    72.270   683.797     0.150
    72.270   684.797     0.150
    72.378   686.211     0.150
    72.798   687.547     0.150
    72.798   688.469     0.150
    72.936   688.211     0.150
    74.484   696.109     0.150
    74.536   694.320     0.150
    75.201   701.742     0.150
    75.574   703.961     0.150
    76.232   706.703     0.150
    76.846   711.258     0.150
    77.950   716.289     0.150
    79.308   724.398     0.150
    81.568   737.547     0.150
    81.601   735.969     0.150
    81.780   738.375     0.150
    81.916   739.367     0.150
    82.465   742.344     0.150
    83.609   747.547     0.150
    85.695   758.188     0.150
    86.651   761.211     0.150
    89.675   778.383     0.150
   149.316  1184.789     0.150
     0.496    10.371     0.150
     0.496    20.371     0.150
     0.496    10.371     0.150
     0.536    10.472     0.150
     0.814    18.271     0.150
     0.814    30.472     0.150
     0.814    15.571     0.150
     0.831    15.371     0.150
     0.831    15.371     0.150
     0.831    15.271     0.150
     0.831    26.171     0.150
     1.464    26.771     0.150
     1.464    46.371     0.150
     1.752    56.271     0.150
     1.775    32.371     0.150
     1.775    35.472     0.150
     1.775    31.071     0.150
     1.775    53.771     0.150
     1.900    36.972     0.150
     1.900    32.972     0.150
     1.900    34.371     0.150
     1.900    57.472     0.150
     2.861    45.871     0.150
     2.861    51.171     0.150
     3.365   104.972     0.150
     3.608   119.472     0.150
     3.790    61.171     0.150
     3.790    71.972     0.150
     3.790    95.472     0.150
     3.790    61.171     0.150
     3.790    69.771     0.150
     4.172    76.071     0.150
     4.110    73.771     0.150
     4.252    76.571     0.150
     4.522    72.071     0.150
     4.522    68.071     0.150
     4.765    86.271     0.150
     4.944    88.771     0.150
     4.944    74.472     0.150
     5.061    91.171     0.150
     5.309    82.671     0.150
     5.309    95.472     0.150
     5.349    96.871     0.150
     5.577   100.771     0.150
     6.225   202.071     0.150
     6.225   112.271     0.150
     6.233   189.972     0.150
     6.394   116.071     0.150
     6.394    92.972     0.150
     6.394   113.071     0.150
     6.394   196.371     0.150
     6.464   101.972     0.150
     6.464   116.571     0.150
     6.853   124.171     0.150
     6.892   123.972     0.150
     6.892   125.571     0.150
     6.892   175.371     0.150
     7.306   135.972     0.150
     7.306   106.171     0.150
     7.991   146.071     0.150
     7.991   145.071     0.150
     7.991   249.371     0.150
     8.086   121.062     0.150
     8.086   216.921     0.150
     8.086   118.171     0.150
     8.086   121.071     0.150
     8.162   125.472     0.150
     8.162   143.472     0.150
     8.162   252.972     0.150
     8.280   130.571     0.150
     8.280   149.171     0.150
     8.280   148.771     0.150
     8.280   255.671     0.150
     8.759   226.871     0.150
     8.759   274.371     0.150
     8.914   133.981     0.150
     9.105   137.521     0.150
     9.105   137.571     0.150
    10.600   261.209     0.150
    10.600   326.016     0.150
    12.400   183.671     0.150
    12.400   328.972     0.150
    13.910   210.671     0.150
    14.783   217.472     0.150
    15.737   231.371     0.150
    15.737     4.101     0.150
    15.737   240.472     0.150
    16.035   224.451     0.150
    16.035   224.371     0.150
    16.228   233.071     0.150
    16.249   230.972     0.150
    17.073   232.935     0.150
    17.073   409.560     0.150
    17.073   232.631     0.150
    17.073   233.271     0.150
    17.361   235.633     0.150
    17.361   420.246     0.150
    17.361   236.661     0.150
    17.361   237.871     0.150
    17.590   238.371     0.150
    18.716     3.700     0.150
    18.716     6.200     0.150
    19.107   261.371     0.150
    20.050   271.961     0.150
    20.668   285.321     0.150
    20.717   286.271     0.150
    20.911   652.346     0.150
    20.904   654.208     0.150
    20.872     5.000     0.150
    21.066   283.171     0.150
    21.296   289.381     0.150
    21.296   289.371     0.150
    21.296   286.071     0.150
    22.192   302.371     0.150
    23.270     4.399     0.150
    23.270     6.000     0.150
    24.141   316.401     0.150
    24.392   581.696     0.150
    24.502   318.231     0.150
    24.423   322.871     0.150
    24.788   320.102     0.150
    24.997   324.331     0.150
    25.031   324.771     0.150
    25.561   321.071     0.150
    25.642   330.401     0.150
    25.938   332.671     0.150
    25.928   336.871     0.150
    26.085   335.291     0.150
    26.519   337.951     0.150
    27.140   344.671     0.150
    27.214   343.701     0.150
    27.835   350.871     0.150
    29.216    10.699     0.150
    29.717   365.371     0.150
    29.717   364.371     0.150
    30.586   380.871     0.150
    31.610   382.271     0.150
    33.509   399.472     0.150
    36.611   425.371     0.150
    36.684   503.771     0.150
    36.684   424.871     0.150
    36.684   503.771     0.150
    36.900   427.521     0.150
    37.082   428.352     0.150
    40.083   459.571     0.150
    40.083   557.171     0.150
    41.609   471.571     0.150
    44.619   498.972     0.150
    44.619   504.472     0.150
    45.177   495.171     0.150
    45.244   495.401     0.150
    45.377   642.071     0.150
    45.377  1152.571     0.150
    45.377   497.521     0.150
    45.377   497.521     0.150
    45.377   497.521     0.150
    45.377   603.521     0.150
    45.377   642.111     0.150
    45.377   898.651     0.150
    45.377  1152.591     0.150
    46.469   506.371     0.150
    46.469   655.571     0.150
    46.469  1179.472     0.150
    46.866   508.972     0.150
    46.866   509.010     0.150
    47.072   510.413     0.150
    47.969   516.972     0.150
    47.971   517.091     0.150
    48.032   518.474     0.150
    48.056   517.472     0.150
    48.503   521.937     0.150
    51.040   541.204     0.150
    51.165   542.211     0.150
    51.165   542.171     0.150
    51.642   546.472     0.150
    51.655   546.171     0.150
    52.093   549.071     0.150
    52.296   551.430     0.150
    52.296   551.571     0.150
    52.779   554.671     0.150
    52.810   555.671     0.150
    52.959   555.871     0.150
    53.053   554.981     0.150
    53.275   561.571     0.150
    53.369   567.871     0.150
    53.369   558.472     0.150
    53.376   566.972     0.150
    53.376   559.171     0.150
    53.572   560.472     0.150
    54.042   563.571     0.150
    54.042   571.472     0.150
    54.129   563.571     0.150
    54.129    10.500     0.150
    54.331   566.071     0.150
    55.483   579.071     0.150
    55.483   573.771     0.150
    55.471   573.571     0.150
    55.754   576.171     0.150
    57.500   587.021     0.150
    58.110   591.501     0.150
    58.073   592.671     0.150
    58.664   595.131     0.150
    58.664   595.171     0.150
    61.634   616.671     0.150
    71.016   677.371     0.150
    75.489   702.571     0.150
    81.357   737.256     0.150
    81.387   734.871     0.150
    86.510   762.271     0.150
   147.877  1182.852     0.150
     0.449     8.633     0.150
     0.449    14.035     0.150
     0.381     7.633     0.150
     0.381    14.035     0.150
     1.162    21.133     0.150
     1.162    27.035     0.150
     1.162    20.633     0.150
     1.369    24.434     0.150
     1.369    43.434     0.150
     1.624    32.934     0.150
     2.051    42.133     0.150
     2.051    64.336     0.150
     2.051    33.035     0.150
     2.051    62.133     0.150
     2.595    51.035     0.150
     2.595    46.535     0.150
     2.560    51.234     0.150
     2.560    41.035     0.150
     2.560    46.035     0.150
     3.174    49.633     0.150
     3.639    55.934     0.150
     3.639   114.434     0.150
     3.773    69.633     0.150
     3.773    74.434     0.150
     3.773    69.035     0.150
     3.995    64.633     0.150
     3.995    72.336     0.150
     4.320    78.035     0.150
     4.320   136.633     0.150
     5.189    75.934     0.150
     5.189    92.934     0.150
     5.440    91.336     0.150
     5.440    97.434     0.150
     5.440    98.035     0.150
     5.440   172.633     0.150
     5.708    94.633     0.150
     5.708   102.035     0.150
     5.755   102.734     0.150
     5.755   161.633     0.150
     6.118   110.133     0.150
     6.166   111.336     0.150
     6.166   205.133     0.150
     6.166    89.934     0.150
     6.166   109.535     0.150
     6.166   191.336     0.150
     6.336   101.035     0.150
     6.336   113.734     0.150
     6.724   111.535     0.150
     6.724   120.633     0.150
     6.772   122.535     0.150
     6.772   122.633     0.150
     6.772   210.934     0.150
     6.968   124.934     0.150
     7.376   104.836     0.150
     7.419   116.934     0.150
     7.419   133.336     0.150
     7.419   232.133     0.150
     7.419   232.535     0.150
     7.895   125.434     0.150
     7.895   142.035     0.150
     8.443   130.234     0.150
     8.443   122.734     0.150
     8.443   151.336     0.150
     8.776   133.836     0.150
     8.776   156.734     0.150
     8.776   272.133     0.150
     8.973   137.133     0.150
     9.750   251.836     0.150
    10.205   142.129     0.150
    10.205   141.734     0.150
    11.956   174.133     0.150
    11.956     3.102     0.150
    11.956   313.535     0.150
    11.956   319.336     0.150
    12.586   308.559     0.150
    14.253   361.535     0.150
    15.026   385.633     0.150
    15.026   399.133     0.150
    15.274   396.035     0.150
    15.412   210.836     0.150
    15.805   400.535     0.150
    15.827   222.133     0.150
    16.278   225.434     0.150
    16.791   219.934     0.150
    16.884   234.734     0.150
    17.134   232.203     0.150
    17.134   412.680     0.150
    17.134   232.516     0.150
    17.134   232.535     0.150
    17.849   252.535     0.150
    18.049   242.344     0.150
    18.049   243.234     0.150
    18.101   255.734     0.150
    18.101   478.234     0.150
    18.253   241.234     0.150
    18.921     6.500     0.150
    18.921    10.699     0.150
    19.815   618.508     0.150
    19.834   269.836     0.150
    19.840   260.934     0.150
    19.840   491.633     0.150
    20.530   274.633     0.150
    20.575   276.562     0.150
    20.575   276.535     0.150
    20.892     4.000     0.150
    20.892     6.902     0.150
    21.252     4.199     0.150
    21.252     7.199     0.150
    21.809   291.133     0.150
    22.024     9.902     0.150
    23.342   307.035     0.150
    23.565     4.500     0.150
    23.565     6.699     0.150
    23.952     6.500     0.150
    23.952     9.500     0.150
    23.952   577.133     0.150
    24.887   322.434     0.150
    25.199   325.035     0.150
    25.199   324.934     0.150
    25.264   326.734     0.150
    25.264   590.211     0.150
    25.309   326.035     0.150
    25.345   324.434     0.150
    25.345   597.836     0.150
    25.368   323.836     0.150
    25.494   324.035     0.150
    25.715   328.434     0.150
    25.741   328.734     0.150
    26.137   331.633     0.150
    26.383   333.934     0.150
    26.735   625.953     0.150
    26.735   336.934     0.150
    26.815   339.234     0.150
    26.815   617.535     0.150
    27.300   343.734     0.150
    27.969   348.633     0.150
    30.257   368.535     0.150
    30.257   437.336     0.150
    30.498   380.535     0.150
    30.498   371.836     0.150
    30.586     3.098     0.150
    30.586     5.500     0.150
    31.724   386.836     0.150
    31.724     2.297     0.150
    32.355   389.234     0.150
    33.273   402.035     0.150
    34.254   403.836     0.150
    34.241   405.535     0.150
    34.866   411.035     0.150
    36.587   423.734     0.150
    36.822   427.836     0.150
    37.314   430.336     0.150
    37.524   431.035     0.150
    38.416   439.336     0.150
    38.633   442.836     0.150
    40.947   465.633     0.150
    40.947   564.734     0.150
    40.959   460.395     0.150
    41.181   463.176     0.150
    41.795   584.434     0.150
    42.083   476.035     0.150
    42.985   476.684     0.150
    44.305   488.234     0.150
    44.392   487.273     0.150
    44.523   490.816     0.150
    44.589   490.113     0.150
    44.907   491.062     0.150
    44.907   491.035     0.150
    45.499   504.883     0.150
    45.499   504.836     0.150
    46.163   502.734     0.150
    46.229   502.305     0.150
    46.229   502.305     0.150
    46.229   651.504     0.150
    46.229  1167.414     0.150
    46.229   502.234     0.150
    46.229   610.535     0.150
    46.229   651.434     0.150
    46.229   908.934     0.150
    46.229  1167.336     0.150
    46.261   503.824     0.150
    46.322   502.484     0.150
    46.451   512.863     0.150
    46.914   507.383     0.150
    47.350   620.234     0.150
    47.350   666.336     0.150
    47.350  1194.035     0.150
    47.752   510.934     0.150
    47.752   671.234     0.150
    47.752   927.035     0.150
    47.808   517.297     0.150
    47.912   517.586     0.150
    48.010   517.633     0.150
    48.394   518.535     0.150
    48.735   522.633     0.150
    50.749   533.234     0.150
    50.749   603.234     0.150
    50.749   533.234     0.150
    50.749   650.234     0.150
    50.749  1124.234     0.150
    50.916   541.484     0.150
    52.036   555.867     0.150
    52.036   555.836     0.150
    52.105   556.285     0.150
    52.297   557.555     0.150
    52.297   557.535     0.150
    52.518   558.543     0.150
    52.518   558.535     0.150
    52.568   558.660     0.150
    52.568   558.633     0.150
    52.657   555.434     0.150
    52.837   552.414     0.150
    52.919   561.535     0.150
    52.919   561.535     0.150
    52.957   562.430     0.150
    53.138   563.004     0.150
    53.138   563.035     0.150
    53.172   563.832     0.150
    53.172   563.836     0.150
    53.300   558.336     0.150
    53.453   566.188     0.150
    53.654   566.906     0.150
    53.654   566.934     0.150
    53.909   568.332     0.150
    54.090   571.375     0.150
    54.090   569.633     0.150
    54.090   571.336     0.150
    54.214   565.234     0.150
    54.214   571.734     0.150
    54.219   565.133     0.150
    54.219   571.734     0.150
    54.353   572.297     0.150
    54.353   565.535     0.150
    54.383   563.633     0.150
    54.428   573.133     0.150
    54.428   566.836     0.150
    54.428   573.133     0.150
    54.800   575.020     0.150
    54.800   575.035     0.150
    54.876   575.965     0.150
    54.876   575.934     0.150
    54.762   567.535     0.150
    54.959   682.234     0.150
    55.057   581.535     0.150
    55.201   577.504     0.150
    55.201   577.535     0.150
    55.229   572.535     0.150
    55.991   584.727     0.150
    56.180   585.371     0.150
    56.324   579.535     0.150
    56.324   586.434     0.150
    56.482   579.695     0.150
    56.631   581.035     0.150
    58.351   600.875     0.150
    58.383   601.113     0.150
    58.579   602.723     0.150
    59.049   604.406     0.150
    59.118   605.504     0.150
    59.774   602.734     0.150
    59.774   602.734     0.150
    62.469   622.543     0.150
    62.469   622.535     0.150
    64.575   636.434     0.150
    68.727   662.473     0.150
    70.107   671.406     0.150
    70.254   670.434     0.150
    70.789   675.535     0.150
    70.848   674.195     0.150
    71.358   677.426     0.150
    71.465   678.625     0.150
    72.884   688.395     0.150
    73.960   693.633     0.150
    74.177   694.184     0.150
    74.736   696.906     0.150
    74.736   696.934     0.150
    75.137   700.035     0.150
    75.137   700.035     0.150
    75.394   701.535     0.150
    75.553   701.875     0.150
    75.651   703.734     0.150
    76.128   705.660     0.150
    76.328   706.727     0.150
    76.832   709.164     0.150
    76.832   709.133     0.150
    77.164   711.035     0.150
    77.520   713.688     0.150
    77.346   713.336     0.150
    77.353   713.234     0.150
    77.879   715.434     0.150
    77.915   714.945     0.150
    78.166   717.363     0.150
    78.166   717.336     0.150
    79.173   722.855     0.150
    79.309   725.434     0.150
    79.545   724.734     0.150
    80.528   729.855     0.150
    80.540   730.406     0.150
    80.906   733.035     0.150
    81.422   735.605     0.150
    81.476   735.734     0.150
    84.056   748.535     0.150
    84.075   748.535     0.150
    84.766   752.836     0.150
    85.581   757.086     0.150
    85.581   757.035     0.150
    86.567   761.133     0.150
    89.316   775.434     0.150
   144.897  1170.734     0.150
   148.068  1191.453     0.150
   149.925  1183.234     0.150
     0.566    10.789     0.150
     0.566    17.391     0.150
     0.851    17.891     0.150
     0.851    20.688     0.150
     0.851    16.090     0.150
     0.851    27.391     0.150
     0.851    15.891     0.150
     0.851    27.391     0.150
     1.468    27.488     0.150
     1.468    45.988     0.150
     1.482    27.289     0.150
     1.482    47.090     0.150
     2.157    46.289     0.150
     2.157    64.289     0.150
     2.157    37.891     0.150
     2.658    90.789     0.150
     2.658    43.988     0.150
     2.658    81.090     0.150
     2.719    57.988     0.150
     2.719    77.090     0.150
     2.719    45.289     0.150
     3.815    58.891     0.150
     3.815   103.289     0.150
     3.994    62.090     0.150
     4.192    76.488     0.150
     4.192    65.590     0.150
     4.192    77.688     0.150
     4.051    63.488     0.150
     4.051   125.391     0.150
     4.353   111.590     0.150
     4.470    79.590     0.150
     4.470   142.289     0.150
     4.508   118.488     0.150
     4.508    70.289     0.150
     4.508   139.488     0.150
     4.769    85.988     0.150
     5.115    91.891     0.150
     5.115    78.590     0.150
     5.115   135.090     0.150
     4.970    89.188     0.150
     4.970    76.090     0.150
     4.970   130.988     0.150
     5.281    94.590     0.150
     5.281   174.789     0.150
     5.281    94.688     0.150
     5.304    95.289     0.150
     5.304    97.688     0.150
     5.304   105.090     0.150
     5.304    95.891     0.150
     5.336    95.391     0.150
     5.336   187.590     0.150
     5.336    80.789     0.150
     5.336   139.688     0.150
     5.559    99.188     0.150
     5.559   180.188     0.150
     5.559    83.590     0.150
     5.559   146.289     0.150
     5.992   108.090     0.150
     5.992   228.988     0.150
     5.992    89.891     0.150
     5.992   155.289     0.150
     5.976   108.730     0.150
     5.976   107.789     0.150
     5.976   147.090     0.150
     6.083   110.391     0.150
     6.083   109.688     0.150
     6.083   189.488     0.150
     6.369   118.391     0.150
     6.369    94.391     0.150
     6.369   165.488     0.150
     7.106   128.789     0.150
     7.106   196.688     0.150
     7.106   221.090     0.150
     7.106   130.891     0.150
     7.106   221.090     0.150
     7.219   130.090     0.150
     7.219   191.090     0.150
     7.219   224.289     0.150
     7.219   107.488     0.150
     7.219   130.789     0.150
     7.219   224.688     0.150
     7.331   193.688     0.150
     7.331   109.090     0.150
     7.331   225.488     0.150
     7.789   118.391     0.150
     7.789   118.391     0.150
     7.789   199.688     0.150
     8.130   117.391     0.150
     8.130   148.590     0.150
     8.248   148.688     0.150
     8.248   255.789     0.150
     8.359   151.188     0.150
     8.359   258.590     0.150
     8.359   303.188     0.150
     8.359   120.289     0.150
     8.408   219.762     0.150
     8.408   219.789     0.150
     8.408   123.688     0.150
    11.271   291.391     0.150
    11.500   160.988     0.150
    11.500   161.020     0.150
    15.010   215.688     0.150
    15.010     3.699     0.150
    15.010   386.188     0.150
    15.091   384.891     0.150
    15.185   382.230     0.150
    15.185   466.004     0.150
    15.983     4.000     0.150
    15.983   242.188     0.150
    15.983   406.590     0.150
    16.077   227.730     0.150
    17.248   236.266     0.150
    17.248   413.391     0.150
    17.248   236.891     0.150
    17.248   236.711     0.150
    17.691   241.883     0.150
    17.691   426.094     0.150
    17.691   546.883     0.150
    17.691   241.988     0.150
    17.691   242.301     0.150
    17.691   241.801     0.150
    17.899     5.898     0.150
    18.165   252.199     0.150
    18.252   258.688     0.150
    18.252   468.188     0.150
    19.155   263.129     0.150
    19.404   257.789     0.150
    19.951   278.289     0.150
    19.965   272.789     0.150
    19.965   271.430     0.150
    20.028   624.305     0.150
    20.028   273.590     0.150
    20.128   273.391     0.150
    20.128   273.410     0.150
    21.065   284.750     0.150
    21.535   289.867     0.150
    21.943   295.988     0.150
    22.447     3.098     0.150
    22.447     6.000     0.150
    23.204   306.898     0.150
    23.842   311.270     0.150
    24.053   315.410     0.150
    24.085   315.609     0.150
    24.477   319.098     0.150
    25.063   327.910     0.150
    25.126   325.590     0.150
    25.126   325.617     0.150
    25.334     2.199     0.150
    25.334   603.188     0.150
    25.714   329.738     0.150
    25.772   329.879     0.150
    26.702   340.559     0.150
    27.156   348.688     0.150
    28.476   354.969     0.150
    28.796   357.699     0.150
    28.796   357.879     0.150
    29.221   363.879     0.150
    29.689   365.738     0.150
    30.542   373.027     0.150
    34.136   406.090     0.150
    37.493   431.379     0.150
    40.372   994.391     0.150
    44.867   637.188     0.150
    44.867  1138.789     0.150
    44.867   494.809     0.150
    44.867   494.809     0.150
    44.867   494.809     0.150
    44.867   599.738     0.150
    44.867   637.230     0.150
    44.867   892.617     0.150
    44.867  1095.340     0.150
    44.867  1138.867     0.150
    45.729   647.590     0.150
    45.729  1156.391     0.150
    47.538   515.008     0.150
    48.724   524.438     0.150
    51.110   545.098     0.150
    51.684   548.789     0.150
    53.689   563.789     0.150
    53.689   566.789     0.150
    53.689   563.789     0.150
    53.752   563.699     0.150
    56.627   580.051     0.150
    56.863   582.461     0.150
    57.165   588.480     0.150
    58.371   594.277     0.150
    64.102   633.289     0.150
    70.142   671.520     0.150
    73.191   690.539     0.150
    76.516   710.160     0.150
    77.916   718.309     0.150
   147.094  1183.477     0.150
   148.723  1185.883     0.150
   148.723  1185.738     0.150
   149.440  1188.340     0.150
   164.962  1260.789     0.150
     0.303     5.972     0.150
     0.303    10.272     0.150
     0.663    20.172     0.150
     0.979    19.572     0.150
     0.979    34.272     0.150
     0.979    18.072     0.150
     1.331    46.372     0.150
     1.641    28.872     0.150
     1.730    52.072     0.150
     2.070    41.272     0.150
     2.070    34.872     0.150
     2.450    50.172     0.150
     2.450    75.972     0.150
     2.582    80.372     0.150
     3.401    52.672     0.150
     3.401   105.372     0.150
     3.456    53.272     0.150
     4.094    74.172     0.150
     4.094    73.672     0.150
     4.207    82.572     0.150
     4.488    85.572     0.150
     4.599    88.772     0.150
     4.615    82.672     0.150
     5.394   103.972     0.150
     5.622    83.572     0.150
     5.622   100.872     0.150
     5.622   173.872     0.150
     5.921   106.072     0.150
     6.031   108.472     0.150
     6.526   112.272     0.150
     6.486    94.372     0.150
     6.486   115.072     0.150
     6.486   201.672     0.150
     6.938   123.972     0.150
     6.938   104.272     0.150
     6.938   123.872     0.150
     6.938   214.372     0.150
     7.388   133.072     0.150
     7.594   229.290     0.150
     7.594   136.072     0.150
     7.594   109.932     0.150
     7.648   138.772     0.150
     7.648   109.572     0.150
     8.645   127.872     0.150
     8.917   164.172     0.150
     8.917   249.772     0.150
     8.917   128.572     0.150
     8.917   159.772     0.150
     8.917   276.772     0.150
     9.076   246.872     0.150
     9.534   233.872     0.150
     9.897   257.672     0.150
     9.973   241.416     0.150
     9.973   139.172     0.150
    12.274   179.872     0.150
    15.553   224.672     0.150
    15.553   395.672     0.150
    15.610     3.800     0.150
    15.610     7.000     0.150
    15.610   238.372     0.150
    16.057   407.672     0.150
    16.145   225.172     0.150
    16.821   228.691     0.150
    16.821   228.952     0.150
    16.868   233.672     0.150
    17.781   240.922     0.150
    17.781   426.647     0.150
    17.781   241.982     0.150
    17.781   241.972     0.150
    17.914   244.672     0.150
    17.914   442.872     0.150
    18.707   259.372     0.150
    20.330   636.722     0.150
    20.330   274.972     0.150
    21.574   294.372     0.150
    21.748   687.255     0.150
    21.885   291.772     0.150
    22.343   537.372     0.150
    23.815     2.500     0.150
    23.815     6.300     0.150
    25.466   327.372     0.150
    30.500     5.500     0.150
    30.548   372.372     0.150
    35.864   418.472     0.150
    37.357   428.697     0.150
    37.415   431.472     0.150
    37.668   431.172     0.150
    38.111   437.672     0.150
    42.354   460.872     0.150
    43.463   477.072     0.150
    44.240   486.922     0.150
    44.647   491.972     0.150
    45.912   500.072     0.150
    46.051   652.872     0.150
    46.051  1167.772     0.150
    46.051   502.582     0.150
    46.051   502.582     0.150
    46.051   502.582     0.150
    46.051   609.812     0.150
    46.051   652.912     0.150
    46.051   908.452     0.150
    46.051  1167.782     0.150
    52.350   550.872     0.150
    53.502   559.472     0.150
    53.927   562.472     0.150
    53.927   562.472     0.150
    53.974   563.072     0.150
    54.030   563.572     0.150
    54.030   562.572     0.150
    54.052   563.172     0.150
    54.253   565.372     0.150
    54.758   576.472     0.150
    54.758   567.772     0.150
    55.173   571.172     0.150
    56.045   577.772     0.150
    56.132   579.022     0.150
    56.766   583.592     0.150
    57.818   589.472     0.150
    58.908   597.572     0.150
    59.569   601.572     0.150
    63.294   626.272     0.150
    64.287   632.572     0.150
    67.336   653.872     0.150
    67.565   654.572     0.150
    71.135   675.812     0.150
    71.635   680.172     0.150
    72.090   682.512     0.150
    72.209   684.372     0.150
    72.285   683.422     0.150
    75.102   700.872     0.150
    75.393   702.972     0.150
    76.574   709.172     0.150
    77.651   719.572     0.150
    78.453   720.272     0.150
    78.703   720.672     0.150
    78.722   720.262     0.150
    79.042   723.672     0.150
    82.966   743.892     0.150
    82.969   742.332     0.150
    83.608   754.202     0.150
    83.608   754.172     0.150
    84.453   748.712     0.150
    86.256   760.372     0.150
    89.037   774.072     0.150
    89.059   772.102     0.150
    89.059   772.072     0.150
   152.183  1191.023     0.150
     0.245     5.172     0.150
     0.399    13.773     0.150
     1.019    18.469     0.150
     1.019    30.773     0.150
     1.019    18.469     0.150
     1.019    32.273     0.150
     1.019    40.273     0.150
     1.389    28.172     0.150
     1.389    44.070     0.150
     1.282    22.969     0.150
     1.282    37.969     0.150
     1.282    22.969     0.150
     1.282    39.570     0.150
     1.658    29.773     0.150
     1.658    29.773     0.150
     1.658    29.773     0.150
     1.658    52.273     0.150
     1.968    34.172     0.150
     1.968    35.070     0.150
     2.220    37.570     0.150
     3.000    62.969     0.150
     3.000    93.969     0.150
     3.000   102.469     0.150
     3.763    59.773     0.150
     3.763    72.672     0.150
     3.763   103.273     0.150
     3.800   125.172     0.150
     3.800   143.570     0.150
     3.992    72.070     0.150
     4.442   153.570     0.150
     4.620    71.367     0.150
     4.620    84.070     0.150
     4.620   143.867     0.150
     4.985    89.367     0.150
     5.211    93.172     0.150
     5.211    93.672     0.150
     5.211   176.367     0.150
     5.287    94.867     0.150
     5.514    98.773     0.150
     5.559    84.867     0.150
     5.559   100.773     0.150
     5.559   172.570     0.150
     5.599   100.867     0.150
     5.750   104.070     0.150
     5.750   212.672     0.150
     6.015   108.367     0.150
     6.115    92.672     0.150
     6.115   110.570     0.150
     6.115   189.172     0.150
     6.115   208.672     0.150
     6.220   111.367     0.150
     6.220    94.367     0.150
     6.220   112.367     0.150
     6.420   116.172     0.150
     6.499    96.867     0.150
     6.499   116.969     0.150
     6.499   167.969     0.150
     6.499   207.773     0.150
     6.527   117.367     0.150
     6.527   117.672     0.150
     6.738    99.773     0.150
     6.738   120.867     0.150
     6.738   207.867     0.150
     7.182   128.586     0.150
     7.182   129.172     0.150
     7.182   109.133     0.150
     7.641   108.992     0.150
     7.641   108.969     0.150
     7.641   137.273     0.150
     7.636   113.570     0.150
     7.636   137.672     0.150
     7.636   195.867     0.150
     7.636   243.367     0.150
     8.242   205.867     0.150
     8.234   123.969     0.150
     8.234   123.969     0.150
     8.234   149.172     0.150
     8.234   220.469     0.150
     8.509   262.070     0.150
     8.509   137.172     0.150
     8.509   238.570     0.150
     8.678   156.273     0.150
     8.678   217.570     0.150
     8.678   268.969     0.150
     8.678   126.469     0.150
     8.678   133.172     0.150
    10.377   145.797     0.150
    10.377   315.414     0.150
    10.377   148.273     0.150
    10.377   265.969     0.150
    10.767   155.773     0.150
    12.936   398.617     0.150
    15.881   400.672     0.150
    15.970   224.117     0.150
    16.609   514.297     0.150
    16.609   230.477     0.150
    17.128   234.938     0.150
    17.128   234.539     0.150
    17.128   415.164     0.150
    17.128   239.672     0.150
    17.788   242.469     0.150
    17.788   429.648     0.150
    17.788   549.820     0.150
    17.788   241.070     0.150
    17.788   241.023     0.150
    18.760   264.172     0.150
    20.072   268.914     0.150
    20.072   629.117     0.150
    20.072   268.914     0.150
    20.430   276.992     0.150
    20.531   281.961     0.150
    20.742   644.945     0.150
    20.742   281.867     0.150
    20.847   280.367     0.150
    21.399   679.078     0.150
    21.499   289.141     0.150
    21.499   291.281     0.150
    25.070   325.211     0.150
    25.197   326.594     0.150
    25.331   332.867     0.150
    25.414   331.781     0.150
    25.443   331.797     0.150
    25.443   599.867     0.150
    26.228   335.773     0.150
    26.509   341.461     0.150
    26.493   341.844     0.150
    26.648   342.797     0.150
    27.067   343.562     0.150
    27.067   348.461     0.150
    27.131   343.773     0.150
    28.694   367.773     0.150
    29.854   370.953     0.150
    29.981   369.891     0.150
    30.014   672.672     0.150
    30.014   766.570     0.150
    30.101     7.398     0.150
    30.175   371.141     0.150
    30.175   370.977     0.150
    30.601   379.570     0.150
    30.601   379.594     0.150
    31.194   382.930     0.150
    32.921   394.289     0.150
    40.808   459.547     0.150
    42.543   474.703     0.150
    42.544   477.070     0.150
    44.025   628.867     0.150
    45.096   495.672     0.150
    45.096   495.328     0.150
    67.704   507.891     0.150
    46.590   513.633     0.150
    46.766   510.867     0.150
    46.998   629.273     0.150
    46.998   663.867     0.150
    46.998  1195.469     0.150
    47.680   518.070     0.150
    48.017   519.141     0.150
    52.384   556.312     0.150
    52.852   561.211     0.150
    53.308   562.281     0.150
    53.330   562.867     0.150
    53.330   562.859     0.150
    53.890   565.969     0.150
    53.890   565.977     0.150
    53.913   566.172     0.150
    53.913   566.180     0.150
    54.015   567.609     0.150
    54.092   568.172     0.150
    54.092   568.195     0.150
    54.636   570.070     0.150
    54.793   572.867     0.150
    54.793   572.859     0.150
    54.858   572.172     0.150
    55.029   574.531     0.150
    55.718   575.430     0.150
    55.718   575.469     0.150
    55.866   581.414     0.150
    56.154   580.398     0.150
    57.637   593.367     0.150
    57.637   593.383     0.150
    58.257   597.930     0.150
    58.430   595.594     0.150
    58.544   596.703     0.150
    60.993   614.297     0.150
    62.144   622.109     0.150
    66.010   650.273     0.150
   109.669   672.070     0.150
    75.455   704.148     0.150
   149.732  1190.062     0.150
     0.239     5.172     0.150
     0.984    36.871     0.150
     0.984    30.971     0.150
     1.250    39.471     0.150
     1.250    22.971     0.150
     1.250    39.271     0.150
     1.411    25.672     0.150
     1.411    25.672     0.150
     1.411    55.271     0.150
     1.411    25.672     0.150
     1.411    43.971     0.150
     1.959    34.072     0.150
     1.959    34.971     0.150
     1.959    59.771     0.150
     2.189    37.871     0.150
     2.189    39.271     0.150
     2.189    67.271     0.150
     2.879    89.971     0.150
     2.989   103.271     0.150
     2.989    48.971     0.150
     2.989    92.271     0.150
     3.786   125.172     0.150
     3.879   137.471     0.150
     4.027   131.771     0.150
     4.056   128.672     0.150
     4.056    63.572     0.150
     4.056   124.871     0.150
     4.178    76.172     0.150
     4.178   142.172     0.150
     4.428    68.072     0.150
     4.428    80.271     0.150
     4.648    83.871     0.150
     5.192    89.971     0.150
     5.192    93.672     0.150
     5.276    95.271     0.150
     5.500    92.771     0.150
     5.500    98.672     0.150
     5.544   100.471     0.150
     5.738   104.072     0.150
     6.098   109.271     0.150
     6.231   113.172     0.150
     6.231   113.072     0.150
     6.448   116.971     0.150
     6.481   116.572     0.150
     6.506   116.971     0.150
     6.720   121.072     0.150
     7.162   128.342     0.150
     7.162   110.078     0.150
     7.162   200.465     0.150
     7.162   128.471     0.150
     7.162   109.182     0.150
     7.614   137.072     0.150
     7.670   110.471     0.150
     8.218   124.371     0.150
     8.218   149.172     0.150
     8.218   124.172     0.150
     8.218   148.771     0.150
     8.486   239.871     0.150
     8.486   124.672     0.150
     8.486   152.672     0.150
     8.486   262.871     0.150
     8.947   245.002     0.150
     8.947   131.971     0.150
     8.947   131.982     0.150
     8.947   131.471     0.150
    10.130   147.072     0.150
    10.390   156.672     0.150
    15.337     3.500     0.150
    15.337     7.000     0.150
    15.337   237.072     0.150
    15.556   413.771     0.150
    15.899     3.500     0.150
    15.988   229.771     0.150
    16.506   512.227     0.150
    16.643   517.539     0.150
    16.643   234.672     0.150
    17.124   234.891     0.150
    17.124   235.215     0.150
    17.124   413.682     0.150
    17.124   532.486     0.150
    17.760   241.564     0.150
    17.760   427.703     0.150
    17.760   547.637     0.150
    17.760   241.102     0.150
    17.760   241.072     0.150
    20.094   611.965     0.150
    20.227   276.371     0.150
    20.459   279.172     0.150
    20.459   280.381     0.150
    20.459   279.072     0.150
    20.500   280.152     0.150
    20.759   633.797     0.150
    20.877   282.871     0.150
    20.857    10.500     0.150
    21.306   286.771     0.150
    21.352     4.699     0.150
    21.471   285.771     0.150
    21.471   285.771     0.150
    23.412     7.500     0.150
    24.137     6.699     0.150
    24.137   581.072     0.150
    24.548   321.982     0.150
    24.878   586.979     0.150
    24.909   323.271     0.150
    25.044   325.361     0.150
    25.171   325.711     0.150
    25.387   329.721     0.150
    25.416   329.791     0.150
    25.621   329.082     0.150
    25.760   331.471     0.150
    25.809   333.432     0.150
    26.093   334.172     0.150
    26.482   339.512     0.150
    26.466   339.752     0.150
    26.621   340.832     0.150
    27.041   343.771     0.150
    27.104   343.572     0.150
    27.161   344.871     0.150
    28.235   355.447     0.150
    28.235   355.541     0.150
    28.235   355.271     0.150
    30.075    11.801     0.150
    30.145   369.871     0.150
    30.571   377.551     0.150
    31.038   380.012     0.150
    32.701     5.000     0.150
    34.115   405.961     0.150
   162.368   409.971     0.150
    46.735   416.141     0.150
    46.735   416.072     0.150
    46.735   416.471     0.150
    35.434   416.871     0.150
    46.535   422.801     0.150
    36.827   576.072     0.150
    36.827   919.572     0.150
    36.992   427.982     0.150
    36.992   427.971     0.150
    36.992   430.572     0.150
    43.591   430.982     0.150
    38.599   443.371     0.150
    41.421   591.971     0.150
    41.421  1056.271     0.150
   120.207   494.432     0.150
   120.207   494.771     0.150
    45.112   498.121     0.150
    45.861   503.031     0.150
    45.861   503.031     0.150
    45.861   649.311     0.150
    45.861  1114.652     0.150
    45.861  1164.682     0.150
    45.861   502.971     0.150
    45.861   609.072     0.150
    45.861   649.271     0.150
    45.861   908.172     0.150
    45.861  1164.672     0.150
   114.729   504.141     0.150
    46.316   506.371     0.150
    46.600   618.002     0.150
    46.963   670.371     0.150
    46.963  1121.672     0.150
    46.963  1186.072     0.150
    47.633   516.111     0.150
    47.633   515.672     0.150
    47.645   515.471     0.150
    48.272   521.471     0.150
    52.448   523.432     0.150
    48.410   521.771     0.150
    48.410   521.771     0.150
    87.103   524.332     0.150
   109.612   529.012     0.150
    49.767   532.771     0.150
    49.953   536.971     0.150
    50.346   536.162     0.150
    68.336   541.311     0.150
    68.336   543.021     0.150
    68.336   543.072     0.150
    51.431   546.410     0.150
    51.431   544.031     0.150
    51.565   546.871     0.150
    51.658   547.771     0.150
    51.914   549.271     0.150
    52.144   551.545     0.150
    52.137   551.672     0.150
    52.361   553.371     0.150
    52.756   557.371     0.150
    52.791   556.871     0.150
    53.262   561.172     0.150
    53.262   561.232     0.150
    53.296   560.764     0.150
    53.450   561.471     0.150
    53.450   561.482     0.150
    53.724   563.172     0.150
    53.856   564.471     0.150
    54.058   565.820     0.150
    54.422   568.871     0.150
    54.603   568.371     0.150
    54.603   765.771     0.150
    54.689   571.002     0.150
    54.792   571.719     0.150
    54.824   571.172     0.150
    54.861   572.332     0.150
    54.905   569.832     0.150
    54.934   571.752     0.150
    54.934   572.672     0.150
    55.962   579.221     0.150
    56.611   583.781     0.150
    58.513   597.262     0.150
    58.513   597.641     0.150
    62.583   614.072     0.150
    66.009   646.871     0.150
    71.276   680.422     0.150
    94.675   682.262     0.150
    72.455   686.451     0.150
    73.611   694.221     0.150
    74.291   698.172     0.150
    74.448   698.492     0.150
    74.420   699.371     0.150
    74.420   699.271     0.150
    74.923   701.771     0.150
    75.457   704.471     0.150
    76.272   710.471     0.150
    76.929   713.031     0.150
    77.583   716.371     0.150
    78.671   721.691     0.150
    78.671   721.672     0.150
    81.136   736.172     0.150
    83.192   748.072     0.150
    84.087   750.871     0.150
    84.752   754.172     0.150
    86.564   763.672     0.150
    89.411   777.771     0.150
   144.788  1170.971     0.150
     0.406    17.698     0.150
     0.623    12.498     0.150
     0.623    21.398     0.150
     0.623    21.498     0.150
     0.623    26.099     0.150
     0.794    25.398     0.150
     0.794    14.798     0.150
     0.954    17.898     0.150
     0.954    23.198     0.150
     0.954    31.198     0.150
     0.954    34.898     0.150
     1.635    37.198     0.150
     1.635    58.998     0.150
     1.796    32.798     0.150
     1.796    31.198     0.150
     1.796    32.198     0.150
     1.889    32.898     0.150
     1.889    34.798     0.150
     1.889    59.298     0.150
     3.104    62.398     0.150
     3.104   101.398     0.150
     2.982    47.398     0.150
     2.982    53.698     0.150
     3.929    60.898     0.150
     4.419    79.298     0.150
     4.419   114.698     0.150
     4.419    79.798     0.150
     4.419   115.798     0.150
     4.924    92.498     0.150
     4.898    88.998     0.150
     5.082    90.898     0.150
     5.082    93.198     0.150
     5.260    95.398     0.150
     5.706   103.599     0.150
     6.366   114.498     0.150
     6.366   196.599     0.150
     6.458   115.099     0.150
     6.458   198.698     0.150
     6.458    93.998     0.150
     6.458   117.198     0.150
     6.458   201.099     0.150
     7.032   125.841     0.150
     7.032   213.966     0.150
     7.032   129.698     0.150
     7.032   134.898     0.150
     7.032   216.898     0.150
     7.448   135.798     0.150
     7.811   143.349     0.150
     7.811   207.023     0.150
     7.811   241.349     0.150
     8.061   113.448     0.150
     8.061   114.298     0.150
     8.061   146.398     0.150
     8.061   248.898     0.150
     8.128   122.698     0.150
     8.128   127.198     0.150
     8.304   149.099     0.150
     8.304   227.698     0.150
     8.641   129.298     0.150
     8.641   271.298     0.150
     9.023   136.519     0.150
     9.218   239.618     0.150
     9.218   241.738     0.150
    10.463   155.498     0.150
    10.463   315.817     0.150
    10.538   153.698     0.150
    12.433   176.099     0.150
    13.372   338.041     0.150
    15.330     4.000     0.150
    15.330   400.498     0.150
    15.535   228.099     0.150
    15.535     8.199     0.150
    15.676   223.349     0.150
    15.676   229.498     0.150
    16.287   230.099     0.150
    16.977   232.218     0.150
    16.977   231.892     0.150
    16.977   231.698     0.150
    17.057   242.099     0.150
    17.375   236.573     0.150
    17.375   419.873     0.150
    17.375   234.929     0.150
    17.375   235.898     0.150
    18.214   462.998     0.150
    18.419   258.698     0.150
    20.150   524.498     0.150
    20.605   501.698     0.150
    21.041   663.523     0.150
    21.044   283.599     0.150
    20.973   289.998     0.150
    20.973     8.601     0.150
    21.206   282.898     0.150
    21.206   282.898     0.150
    21.129   672.248     0.150
    21.270   677.198     0.150
    22.270   290.599     0.150
    23.397     3.600     0.150
    24.281   318.078     0.150
    24.509   318.448     0.150
    24.539   316.108     0.150
    24.452   325.798     0.150
    24.802   320.328     0.150
    25.138   326.208     0.150
    25.172   326.218     0.150
    25.613   335.599     0.150
    26.035   336.186     0.150
    26.035   335.599     0.150
    26.035   335.599     0.150
    26.225   336.019     0.150
    26.356   342.599     0.150
    26.356   616.198     0.150
    26.365   337.309     0.150
    27.968   351.538     0.150
    28.060   352.998     0.150
    29.577   382.698     0.150
    29.577   441.099     0.150
    29.853   366.498     0.150
    30.276   374.139     0.150
    30.751   376.179     0.150
    30.874   377.059     0.150
    34.519   409.798     0.150
    34.750   409.798     0.150
    35.229   413.798     0.150
    36.752   428.088     0.150
    36.752   427.398     0.150
    37.685     0.130     0.150
    37.717   434.099     0.150
    37.717   434.048     0.150
    37.717     0.021     0.150
    38.331     0.029     0.150
    38.560   441.898     0.150
    38.693   442.198     0.150
    38.883   443.889     0.150
    39.392     0.140     0.150
    39.451     0.110     0.150
    39.998     0.040     0.150
    40.241   455.288     0.150
    41.040   462.158     0.150
    42.692   475.738     0.150
    42.760   471.998     0.150
    42.760   608.198     0.150
    43.279     0.030     0.150
    43.532   482.468     0.150
    43.861     0.051     0.150
    44.052     0.040     0.150
    44.611   491.208     0.150
    45.448   496.818     0.150
    45.448   496.818     0.150
    45.448   641.078     0.150
    45.448  1199.408     0.150
    45.448   496.798     0.150
    45.448   602.599     0.150
    45.448   640.998     0.150
    45.448   897.498     0.150
    46.339   505.298     0.150
    46.543   506.479     0.150
    47.222   511.298     0.150
    47.222   511.998     0.150
    47.707   514.698     0.150
    48.006   516.698     0.150
    51.040   541.559     0.150
    51.236   540.198     0.150
    51.248   543.099     0.150
    51.169   542.479     0.150
    51.732   546.889     0.150
    51.732   546.723     0.150
    52.037   549.448     0.150
    52.171   550.118     0.150
    52.309     0.080     0.150
    52.384   552.548     0.150
    52.525   552.099     0.150
    52.668     0.130     0.150
    52.883   556.226     0.150
    52.865   555.698     0.150
    53.040   556.809     0.150
    53.100     0.029     0.150
    53.120     0.100     0.150
    53.310   558.528     0.150
    53.310   558.998     0.150
    53.332     0.040     0.150
    53.341   558.858     0.150
    53.341   558.858     0.150
    53.375   559.128     0.150
    53.311   559.448     0.150
    53.389   559.099     0.150
    53.389   551.898     0.150
    53.389   551.898     0.150
    53.436   559.418     0.150
    53.442     0.061     0.150
    53.442   559.898     0.150
    53.466     0.021     0.150
    53.568   560.938     0.150
    53.568   560.938     0.150
    53.568   560.998     0.150
    53.598   560.878     0.150
    53.645     0.061     0.150
    53.645   561.398     0.150
    53.645   561.391     0.150
    53.915     0.130     0.150
    54.012   564.099     0.150
    54.077   564.168     0.150
    54.084     0.030     0.150
    54.104     0.030     0.150
    54.180     0.119     0.150
    54.190   564.168     0.150
    54.190   563.798     0.150
    54.190  1254.698     0.150
    54.190  1692.698     0.150
    54.276   566.260     0.150
    54.345     0.030     0.150
    54.413     0.060     0.150
    54.413   566.498     0.150
    54.447   568.943     0.150
    54.492     0.101     0.150
    54.520   567.349     0.150
    54.562   567.059     0.150
    54.582   567.968     0.150
    54.648     0.050     0.150
    54.453   572.389     0.150
    54.732     0.100     0.150
    54.901   569.968     0.150
    55.080   570.828     0.150
    55.208     0.330     0.150
    55.271   572.398     0.150
    55.292   572.718     0.150
    55.394   573.208     0.150
    55.456   574.048     0.150
    55.551   574.648     0.150
    55.548   574.998     0.150
    55.618   575.059     0.150
    55.673   575.748     0.150
    55.707   575.918     0.150
    55.690   576.019     0.150
    56.069   577.099     0.150
    56.058   576.788     0.150
    56.075   579.238     0.150
    56.162   579.738     0.150
    56.174   579.208     0.150
    56.192   579.578     0.150
    56.197   579.548     0.150
    56.263   579.148     0.150
    56.393   580.858     0.150
    56.476   581.328     0.150
    56.547   581.929     0.150
    56.599   581.958     0.150
    56.740   582.979     0.150
    57.073   586.108     0.150
    57.080   585.538     0.150
    57.189   587.309     0.150
    57.243   586.468     0.150
    57.282   587.198     0.150
    57.460   588.309     0.150
    57.514   589.188     0.150
    57.570   589.068     0.150
    57.570   589.078     0.150
    57.625   589.078     0.150
    57.846   590.398     0.150
    57.915   590.809     0.150
    57.915   590.751     0.150
    58.048   592.519     0.150
    58.098   592.599     0.150
    58.098   592.679     0.150
    58.292   593.618     0.150
    58.425   594.858     0.150
    58.562   596.118     0.150
    58.908   598.958     0.150
    59.008   598.868     0.150
    59.895   604.668     0.150
    59.985   605.278     0.150
    61.127   611.918     0.150
    61.127   611.918     0.150
    61.229   618.898     0.150
    61.229   618.898     0.150
    61.697   617.798     0.150
    61.546   622.238     0.150
    63.286   627.559     0.150
    75.378   702.498     0.150
    76.275   716.599     0.150
    79.689   732.378     0.150
    81.483   738.479     0.150
    81.483   738.498     0.150
    82.927   746.898     0.150
    82.927   752.398     0.150
    83.955   748.498     0.150
    84.594   750.679     0.150
    86.416   761.599     0.150
    89.366   775.998     0.150
     0.252     5.393     0.150
     0.952    34.492     0.150
     0.952    17.793     0.150
     1.216    22.492     0.150
     1.216    37.593     0.150
     1.441    25.793     0.150
     1.441    25.793     0.150
     1.441    25.793     0.150
     1.441    45.093     0.150
     1.615    29.293     0.150
     1.964    33.793     0.150
     1.964    34.992     0.150
     2.156    37.793     0.150
     2.910    56.793     0.150
     2.910    59.692     0.150
     2.910    97.593     0.150
     2.910    46.992     0.150
     2.910    52.593     0.150
     2.910    89.793     0.150
     2.966    57.293     0.150
     2.966    48.293     0.150
     2.966    93.093     0.150
     4.058    62.093     0.150
     4.058   139.593     0.150
     4.058    72.692     0.150
     4.028    62.992     0.150
     4.681    84.192     0.150
     4.944    89.192     0.150
     5.165    92.793     0.150
     5.165    79.992     0.150
     5.165    94.293     0.150
     5.254    95.393     0.150
     5.519    99.192     0.150
     5.715   103.492     0.150
     6.071   110.192     0.150
     6.228   113.593     0.150
     6.228   220.192     0.150
     6.228    91.593     0.150
     6.228   112.593     0.150
     6.454   116.793     0.150
     6.478   117.293     0.150
     6.478   116.793     0.150
     7.134   128.660     0.150
     7.134   104.853     0.150
     7.134   128.992     0.150
     7.134   220.692     0.150
     7.134   104.992     0.150
     7.436   134.942     0.150
     7.584   127.492     0.150
     7.584   136.692     0.150
     7.584   235.293     0.150
     7.688   138.692     0.150
     7.688   237.093     0.150
     7.688   277.692     0.150
     8.192   125.393     0.150
     8.192   148.492     0.150
     8.455   135.293     0.150
     8.455   238.293     0.150
     8.455   152.893     0.150
     8.455   262.793     0.150
     8.620   139.192     0.150
     8.931   318.992     0.150
    10.160   261.793     0.150
    10.415   145.811     0.150
    10.415   257.586     0.150
    10.415   145.812     0.150
    13.002   318.410     0.150
    15.903   227.293     0.150
    15.903   404.192     0.150
    15.993   223.393     0.150
    16.670   519.893     0.150
    16.670   234.992     0.150
    17.133   234.961     0.150
    17.133   415.761     0.150
    17.742   429.168     0.150
    17.742   543.293     0.150
    17.742   242.393     0.150
    17.742   242.093     0.150
    19.470   266.992     0.150
    20.124   275.293     0.150
    20.476   280.623     0.150
    20.476   283.793     0.150
    20.786   644.718     0.150
    20.845     4.000     0.150
    20.845   516.293     0.150
    20.896   284.192     0.150
    20.896   652.442     0.150
    21.274   287.293     0.150
    21.334   667.543     0.150
    21.438   288.492     0.150
    21.718   294.593     0.150
    22.067   297.793     0.150
    22.067   543.793     0.150
    24.515   321.072     0.150
    24.846   322.612     0.150
    24.936   324.242     0.150
    25.012   325.763     0.150
    25.139   324.873     0.150
    25.355   328.803     0.150
    25.384   329.213     0.150
    25.566   329.242     0.150
    25.647   328.692     0.150
    25.777   332.723     0.150
    26.125   607.893     0.150
    26.169   334.793     0.150
    26.320   340.593     0.150
    26.449   338.973     0.150
    26.433   338.883     0.150
    26.774   341.003     0.150
    26.914   342.162     0.150
    27.009   349.593     0.150
    27.072   344.223     0.150
    27.072   344.192     0.150
    27.505   351.253     0.150
    28.583   360.902     0.150
    29.949   663.192     0.150
    30.112   370.692     0.150
    31.131   379.862     0.150
    54.301   403.473     0.150
    34.560   410.793     0.150
    46.758   417.562     0.150
    35.263   416.293     0.150
    35.403   417.393     0.150
    36.960   429.393     0.150
    38.056   437.893     0.150
    38.092   439.793     0.150
    38.543   444.492     0.150
    38.661   443.923     0.150
    38.932   447.242     0.150
    38.932   449.093     0.150
    40.372   457.293     0.150
    40.561   460.893     0.150
    42.488   474.963     0.150
    43.097   475.293     0.150
    43.097   856.893     0.150
    43.097  1049.093     0.150
    43.920   486.793     0.150
    45.115   499.093     0.150
    45.834   502.623     0.150
    45.834   502.623     0.150
    45.834   650.362     0.150
    45.834   908.272     0.150
    45.834  1120.362     0.150
    45.834  1191.402     0.150
    46.059   654.562     0.150
    46.059  1123.242     0.150
    46.523   512.492     0.150
    46.784   510.093     0.150
    46.931   668.093     0.150
    46.931  1191.393     0.150
    47.444   515.833     0.150
    47.444   515.793     0.150
    47.604   515.772     0.150
    47.617   514.893     0.150
    33.509   526.812     0.150
    49.738   531.988     0.150
   111.038   536.793     0.150
    51.355   545.093     0.150
    51.425   545.593     0.150
    51.629   547.169     0.150
    52.116   552.094     0.150
    52.108   551.100     0.150
    52.258   552.518     0.150
    52.419   553.492     0.150
    52.695   556.293     0.150
    52.701   554.839     0.150
    52.762   555.971     0.150
    52.882   557.393     0.150
    53.244   559.772     0.150
    53.268   560.531     0.150
    53.272   563.992     0.150
    53.272   564.029     0.150
    53.422   560.034     0.150
    53.487   560.893     0.150
    53.697   562.593     0.150
    53.697   561.977     0.150
    53.728   562.593     0.150
    53.728   562.593     0.150
    53.776   563.593     0.150
    53.830   563.893     0.150
    53.953   564.992     0.150
    54.300   569.093     0.150
    54.300   569.083     0.150
    54.463   568.393     0.150
    54.463   567.919     0.150
    54.472   567.893     0.150
    54.492   566.683     0.150
    54.492   566.692     0.150
    54.578   568.093     0.150
    54.578  1022.393     0.150
    54.578  1250.393     0.150
    54.578  1370.393     0.150
    54.662   570.477     0.150
    54.674   569.763     0.150
    54.732   570.293     0.150
    54.765   571.393     0.150
    54.765   571.376     0.150
    54.795   570.236     0.150
    54.879   571.293     0.150
    55.729   573.625     0.150
    55.843   578.293     0.150
    55.936   578.893     0.150
    56.094   579.763     0.150
    56.178   579.192     0.150
    56.233   581.093     0.150
    56.580   583.482     0.150
    56.584   582.337     0.150
    56.845   583.992     0.150
    57.576   591.393     0.150
    58.012   592.492     0.150
    58.105   593.893     0.150
    58.197   593.408     0.150
    58.812   598.593     0.150
    59.180   601.692     0.150
    60.928   611.973     0.150
    61.160   615.393     0.150
    61.515   616.393     0.150
    62.085   621.093     0.150
    62.546   623.393     0.150
    62.819   625.492     0.150
    63.673   631.593     0.150
    66.021   646.393     0.150
    67.965   659.293     0.150
    70.986   678.433     0.150
    72.624   689.093     0.150
    75.217   703.093     0.150
    75.472   704.793     0.150
    76.567   711.593     0.150
    76.604   710.492     0.150
    77.601   716.103     0.150
    77.601   718.593     0.150
    80.358   731.893     0.150
    80.851   735.593     0.150
    83.160   746.942     0.150
    84.098   750.263     0.150
    84.098   750.293     0.150
    84.424   753.492     0.150
    84.761   754.763     0.150
    84.761   754.793     0.150
    85.652   759.593     0.150
    86.573   763.683     0.150
    86.573   763.593     0.150
   149.594  1188.185     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     5.446    79.750     0.150
     6.391    93.750     0.150
     6.859   100.750     0.150
    14.288   201.750     0.150
    15.447   217.750     0.150
    15.447   229.750     0.150
    15.996   225.750     0.150
    17.571   244.750     0.150
    17.571   439.750     0.150
    20.237   275.750     0.150
    20.237   285.750     0.150
    20.237   511.750     0.150
    20.366   507.750     0.150
    20.366   276.750     0.150
    20.360   274.750     0.150
    20.851   281.750     0.150
    20.851   510.750     0.150
    21.851   291.750     0.150
    22.473   318.051     0.150
    23.538   761.551     0.150
    23.563   752.551     0.150
    24.155   314.750     0.150
    24.229   620.750     0.150
    24.229   757.148     0.150
    25.320   324.750     0.150
    25.307   326.949     0.150
    25.434   325.750     0.150
    25.577   325.750     0.150
    25.640   326.750     0.150
    25.735   326.750     0.150
    25.735   598.750     0.150
    25.735   326.551     0.150
    25.777   329.648     0.150
    25.777   328.750     0.150
    25.895   332.750     0.150
    25.927   331.551     0.150
    26.038   335.852     0.150
    26.057   328.750     0.150
    26.050   330.750     0.150
    26.122   334.750     0.150
    26.228   334.750     0.150
    26.228   766.750     0.150
    26.235   332.949     0.150
    26.427   619.750     0.150
    26.442   336.250     0.150
    26.331   611.750     0.150
    26.635   336.648     0.150
    26.635   335.750     0.150
    26.866   336.750     0.150
    27.902   350.750     0.150
    27.902     7.000     0.150
    27.902   635.750     0.150
    28.527   353.750     0.150
    28.527   637.750     0.150
    29.777   364.750     0.150
    30.601   374.750     0.150
    31.679   381.750     0.150
    31.861   385.750     0.150
    31.861   694.750     0.150
    33.326   399.750     0.150
    33.326   718.750     0.150
    33.563   397.750     0.150
    34.040   403.750     0.150
    34.061   404.750     0.150
    34.583   407.750     0.150
    35.887   419.750     0.150
    36.732   424.750     0.150
    36.732   766.750     0.150
    36.732   908.750     0.150
    37.058   429.750     0.150
    37.058     9.000     0.150
    37.058   772.750     0.150
    37.332   429.750     0.150
    37.813   436.750     0.150
    37.813   786.750     0.150
    38.022   435.750     0.150
    38.022   784.750     0.150
    38.052  1054.750     0.150
    39.187   445.750     0.150
    39.187   815.750     0.150
    40.159   453.750     0.150
    40.310   457.750     0.150
    40.372   456.750     0.150
    40.372   550.750     0.150
    40.450   456.750     0.150
    40.450   553.750     0.150
    40.450   822.750     0.150
    40.586   458.750     0.150
    41.038   459.750     0.150
    41.038   564.750     0.150
    41.038   828.750     0.150
    41.338   464.750     0.150
    41.338     9.000     0.150
    41.338   838.750     0.150
    41.569   466.750     0.150
    41.569   563.750     0.150
    41.569   838.750     0.150
    41.605   466.750     0.150
    41.605   810.750     0.150
    41.826   468.750     0.150
    43.509   481.750     0.150
    43.509   586.750     0.150
    43.509   867.750     0.150
    43.577   481.750     0.150
    43.922   483.750     0.150
    43.922   873.750     0.150
    44.806   493.750     0.150
    45.313     9.000     0.150
    45.313   605.750     0.150
    45.791   503.750     0.150
    45.791   906.750     0.150
    45.981   503.750     0.150
    45.981   912.750     0.150
    46.258   502.750     0.150
    46.693   506.750     0.150
    46.693   911.750     0.150
    47.592   514.750     0.150
    47.753   514.750     0.150
    47.753   931.750     0.150
    48.354   519.750     0.150
    48.872   524.750     0.150
    48.872   638.750     0.150
    48.872   947.750     0.150
    49.856   531.750     0.150
    49.856   644.750     0.150
    49.955   529.750     0.150
    50.182   533.750     0.150
    50.182     8.000     0.150
    50.182   651.750     0.150
    50.328   534.750     0.150
    50.579   537.750     0.150
    50.579     8.000     0.150
    50.579   656.750     0.150
    50.579   973.750     0.150
    50.841   541.750     0.150
    52.317   550.750     0.150
    52.317   994.750     0.150
    53.092   554.750     0.150
    53.092  1008.750     0.150
    54.284   565.750     0.150
    54.490   565.750     0.150
    54.580   570.750     0.150
    54.778   566.750     0.150
    54.778  1032.750     0.150
    54.790   568.750     0.150
    54.790  1031.750     0.150
    54.795   569.750     0.150
    54.795  1029.750     0.150
    54.970   569.750     0.150
    54.970  1021.750     0.150
    55.251   572.750     0.150
    55.251  1027.750     0.150
    55.357   571.750     0.150
    55.357     8.000     0.150
    55.357   693.750     0.150
    55.357  1035.750     0.150
    55.846   576.750     0.150
    55.871  1042.750     0.150
    57.181   585.750     0.150
    57.181     6.000     0.150
    57.536  1062.750     0.150
    57.727   589.750     0.150
    57.796   590.750     0.150
    58.018   590.750     0.150
    58.018     8.000     0.150
    58.768   596.750     0.150
    58.768  1077.750     0.150
    59.074   598.750     0.150
    59.413  1100.750     0.150
    59.714   602.750     0.150
    59.714  1092.750     0.150
    60.756   610.750     0.150
    61.517   615.750     0.150
    61.832  1121.750     0.150
    61.832  1365.750     0.150
    61.963   617.750     0.150
    62.087   619.750     0.150
    62.523   621.750     0.150
    65.913   644.750     0.150
    66.303   646.750     0.150
    67.878   656.750     0.150
    69.644   667.750     0.150
    69.640   666.750     0.150
    70.762   830.750     0.150
    70.762  1228.750     0.150
    70.936   675.750     0.150
    70.983   676.750     0.150
    71.421   679.750     0.150
    71.486   678.750     0.150
    71.486     9.000     0.150
    71.486   840.750     0.150
    72.180   683.750     0.150
    73.591   691.750     0.150
    73.591  1261.750     0.150
    74.598   697.750     0.150
    74.828   700.750     0.150
    75.389   702.750     0.150
    76.090   706.750     0.150
    76.223   707.750     0.150
    76.407   708.750     0.150
    76.620   709.750     0.150
    77.516   715.750     0.150
    77.727   715.750     0.150
    77.787   716.750     0.150
    79.290   724.750     0.150
    80.218   729.750     0.150
    80.711   731.750     0.150
    81.942   737.750     0.150
    81.942    10.000     0.150
    82.459   740.750     0.150
    83.277  1368.750     0.150
    83.411   746.750     0.150
    83.742   749.750     0.150
    84.141   748.750     0.150
    84.141     9.000     0.150
    84.477   752.750     0.150
    84.480   752.750     0.150
    85.270   755.750     0.150
    85.270  1382.750     0.150
    85.443   759.750     0.150
    85.443     8.000     0.150
    85.757   757.750     0.150
    85.757   955.750     0.150
    87.088   762.750     0.150
    87.088     9.000     0.150
    87.565   765.750     0.150
    88.956   772.750     0.150
   128.709  1143.750     0.150
   128.709  1152.750     0.150
   140.475  1168.750     0.150
   140.694  1169.750     0.150
   145.717  1175.750     0.150
   147.733  1182.750     0.150
   150.834  1188.750     0.150
    10.289   145.375     0.150
    20.202   271.375     0.150
    20.184   271.375     0.150
    20.664   279.375     0.150
    20.664   513.375     0.150
    26.145   332.375     0.150
    27.832   348.375     0.150
    28.160   349.375     0.150
    36.227   421.375     0.150
    37.506   432.977     0.150
    37.506   779.375     0.150
    37.506   949.375     0.150
    38.678   441.672     0.150
    39.630   449.672     0.150
    39.878   452.172     0.150
    39.878     7.203     0.150
    39.878   551.375     0.150
    40.028   453.375     0.150
    40.065   453.375     0.150
    40.065     6.000     0.150
    40.064   453.977     0.150
    40.522   457.477     0.150
    41.104   462.375     0.150
    41.334   463.875     0.150
    42.801   476.172     0.150
    42.801   859.375     0.150
    43.029   478.375     0.150
    43.476   481.578     0.150
    43.486   481.375     0.150
    44.499   491.578     0.150
    44.807   491.578     0.150
    44.807     5.797     0.150
    44.958   493.375     0.150
    45.748   498.875     0.150
    46.204   503.078     0.150
    47.923   515.578     0.150
    47.923     7.797     0.150
    49.478   527.477     0.150
    51.799   545.375     0.150
    52.152   549.375     0.150
    54.026   562.375     0.150
    54.322   564.375     0.150
    54.335   565.773     0.150
    55.106   570.375     0.150
    55.106     6.000     0.150
    55.392   572.375     0.150
    57.124   585.375     0.150
    57.124     6.000     0.150
    57.124   715.375     0.150
    57.148   586.273     0.150
    57.552   587.875     0.150
    61.265   612.977     0.150
    61.473   615.273     0.150
    64.355   635.375     0.150
    65.647   642.375     0.150
    65.990   645.375     0.150
    67.526   654.375     0.150
    67.697   656.875     0.150
    70.676   674.977     0.150
    71.086   678.477     0.150
    71.339   677.273     0.150
    71.339     7.102     0.150
    71.339    10.102     0.150
    73.201   689.875     0.150
    74.514   698.375     0.150
    75.743   705.172     0.150
    75.743     6.203     0.150
    75.836   705.375     0.150
    75.836     8.000     0.150
    75.929   706.578     0.150
    76.085   707.773     0.150
    76.229   708.078     0.150
    76.229     6.297     0.150
    76.305   708.172     0.150
    76.671   710.375     0.150
    76.671     7.000     0.150
    77.175   713.375     0.150
    77.261   713.773     0.150
    77.261     6.602     0.150
    78.937   723.375     0.150
    79.955   727.375     0.150
    81.236   733.375     0.150
    82.221   740.773     0.150
    83.076   744.977     0.150
    83.076     8.398     0.150
    84.178   750.375     0.150
    85.380   755.977     0.150
    85.631   758.375     0.150
   139.925  1171.172     0.150
   140.195  1167.875     0.150
   146.222  1175.375     0.150
   151.369  1189.375     0.150
   151.369  1195.375     0.150
   151.369  1204.375     0.150
     1.115    20.477     0.150
     2.344    37.977     0.150
     2.344    37.477     0.150
     5.073    75.477     0.150
     5.630    81.477     0.150
     5.630   145.477     0.150
     6.341    93.977     0.150
     7.429   107.477     0.150
     7.541   109.477     0.150
     7.541   189.477     0.150
    11.174   155.477     0.150
    14.855   207.477     0.150
    19.422   263.773     0.150
    19.422   263.477     0.150
    21.287   287.477     0.150
    25.301   327.477     0.150
    25.301   326.477     0.150
    25.879   330.578     0.150
    26.499   334.477     0.150
    26.499   612.477     0.150
    26.990   342.477     0.150
    27.136   344.477     0.150
    27.307   342.773     0.150
    27.657   346.477     0.150
    29.501   362.477     0.150
    30.501   375.477     0.150
    30.938   376.477     0.150
    30.938   377.477     0.150
    31.991   386.477     0.150
    33.075   395.477     0.150
    33.149   396.477     0.150
    33.526   398.977     0.150
    36.118   420.477     0.150
    36.496   423.773     0.150
    36.496   509.477     0.150
    36.569   426.477     0.150
    37.472   431.773     0.150
    37.472   512.477     0.150
    37.472   776.477     0.150
    37.552   432.773     0.150
    37.552   522.477     0.150
    38.591   441.273     0.150
    38.591   526.477     0.150
    39.510   451.477     0.150
    39.641   450.477     0.150
    39.716   450.773     0.150
    39.716   818.477     0.150
    39.792   454.477     0.150
    39.970   452.078     0.150
    40.059   452.977     0.150
    40.473   460.773     0.150
    40.485   456.477     0.150
    40.462   458.680     0.150
    40.839   460.477     0.150
    41.786   467.477     0.150
    42.814   475.773     0.150
    42.814   579.477     0.150
    44.153   485.977     0.150
    44.286   490.477     0.150
    44.852   495.477     0.150
    45.047   495.477     0.150
    45.092   495.477     0.150
    45.334   497.578     0.150
    45.343   499.078     0.150
    45.385   497.773     0.150
    45.664   500.375     0.150
    45.664   500.477     0.150
    45.664   612.477     0.150
    45.825   500.477     0.150
    46.049   505.477     0.150
    46.890   510.375     0.150
    46.994   509.875     0.150
    47.429   511.977     0.150
    47.483   516.180     0.150
    47.807   515.680     0.150
    48.237   519.477     0.150
    48.484   520.477     0.150
    48.762   524.578     0.150
    48.762   948.477     0.150
    49.227   527.477     0.150
    49.645   645.477     0.150
    49.774   532.477     0.150
    50.638   539.477     0.150
    51.419   543.477     0.150
    51.535   544.875     0.150
    51.837   544.477     0.150
    51.798   548.477     0.150
    52.429   553.477     0.150
    53.757   560.875     0.150
    54.037   563.477     0.150
    54.188   561.477     0.150
    54.473   566.477     0.150
    54.481   566.477     0.150
    54.841   569.477     0.150
    55.092   571.273     0.150
    55.717   575.773     0.150
    56.396   580.477     0.150
    56.618   580.477     0.150
    56.832   583.477     0.150
    56.926   587.477     0.150
    56.944   583.477     0.150
    57.035   584.477     0.150
    57.064   585.375     0.150
    58.044   591.977     0.150
    58.238   590.477     0.150
    60.721   609.477     0.150
    60.778   610.477     0.150
    61.032   611.977     0.150
    65.136   639.477     0.150
    66.365   646.477     0.150
    68.233   658.477     0.150
    68.511   660.477     0.150
    69.347   666.773     0.150
    69.972   669.477     0.150
    71.502   680.375     0.150
    71.514   680.477     0.150
    72.560   686.273     0.150
    74.053   695.578     0.150
    75.907   704.977     0.150
    75.907   722.477     0.150
    76.598   710.977     0.150
    76.598   718.477     0.150
    76.763   710.773     0.150
    77.087   713.875     0.150
    77.074   711.477     0.150
    77.472   714.977     0.150
    77.978   717.680     0.150
    78.120   719.477     0.150
    78.151   719.477     0.150
    79.720   727.180     0.150
    79.900   729.477     0.150
    80.810   733.477     0.150
    81.230   734.477     0.150
    81.230  1351.477     0.150
    83.047   745.680     0.150
    83.878   749.977     0.150
    83.878     5.500     0.150
    85.007   754.977     0.150
    86.135   760.375     0.150
    86.409   761.977     0.150
    87.685   767.078     0.150
    87.742   769.477     0.150
   136.977  1166.477     0.150
   144.209  1171.477     0.150
     1.229    22.488     0.150
     2.141    34.789     0.150
     2.141    63.789     0.150
     5.022    77.789     0.150
     5.048    74.789     0.150
     5.812    83.891     0.150
     5.812   148.891     0.150
     7.622   109.988     0.150
     7.707   110.789     0.150
     7.707   196.188     0.150
     7.707   111.289     0.150
     7.707   196.688     0.150
    16.107   222.090     0.150
    16.107   395.391     0.150
    16.365   228.789     0.150
    20.817   284.789     0.150
    20.817   285.289     0.150
    21.252   530.789     0.150
    25.314   326.789     0.150
    25.429   327.789     0.150
    26.551   334.789     0.150
    27.111   342.789     0.150
    27.327   344.789     0.150
    27.652   346.789     0.150
    28.866   357.789     0.150
    29.335   360.789     0.150
    29.335   655.789     0.150
    29.763   366.789     0.150
    31.049   377.789     0.150
    32.115   386.789     0.150
    32.567   390.789     0.150
    32.803   391.789     0.150
    33.201   394.789     0.150
    33.270   397.789     0.150
    33.457   397.789     0.150
    33.731   400.789     0.150
    34.956   410.988     0.150
    35.159   413.988     0.150
    35.315   414.590     0.150
    36.018   418.789     0.150
    36.107   420.789     0.150
    36.727   425.988     0.150
    37.357   430.289     0.150
    37.357   508.789     0.150
    38.487   439.789     0.150
    38.487   531.090     0.150
    38.454   440.789     0.150
    39.465   450.789     0.150
    39.570   449.590     0.150
    39.570     4.398     0.150
    39.570   538.789     0.150
    39.570   804.789     0.150
    39.602   450.789     0.150
    39.874   454.289     0.150
    39.938   451.789     0.150
    40.015   454.988     0.150
    40.158   455.289     0.150
    40.361   456.188     0.150
    40.361   549.789     0.150
    40.451   457.789     0.150
    42.064   471.789     0.150
    42.578   473.688     0.150
    42.578   578.688     0.150
    42.642   476.789     0.150
    42.737   474.988     0.150
    42.737   576.090     0.150
    42.737   588.590     0.150
    43.735   481.891     0.150
    44.335   487.789     0.150
    45.129   495.789     0.150
    45.110   495.789     0.150
    45.182   495.590     0.150
    45.331   497.988     0.150
    45.941   501.789     0.150
    46.015   502.789     0.150
    46.107   503.789     0.150
    47.029   509.789     0.150
    47.033   509.789     0.150
    47.276   510.688     0.150
    47.594   514.090     0.150
    47.993   517.789     0.150
    48.310   521.289     0.150
    48.864   524.789     0.150
    49.636   532.090     0.150
    49.737   530.789     0.150
    49.909   532.789     0.150
    50.652   538.789     0.150
    51.145   542.789     0.150
    51.382   541.789     0.150
    51.489   543.789     0.150
    51.755   546.789     0.150
    51.800   546.789     0.150
    51.812   548.488     0.150
    51.956   549.789     0.150
    52.409   548.789     0.150
    53.027   556.789     0.150
    52.964   556.789     0.150
    53.357   557.988     0.150
    53.490   558.188     0.150
    53.601   558.988     0.150
    53.693   559.488     0.150
    53.693   630.789     0.150
    53.980   562.188     0.150
    54.433   565.789     0.150
    54.504   566.289     0.150
    54.747   568.789     0.150
    54.747   628.789     0.150
    54.776   567.789     0.150
    55.035   570.188     0.150
    55.336   572.789     0.150
    55.654   574.891     0.150
    55.673   574.789     0.150
    55.688   574.688     0.150
    56.068   578.289     0.150
    56.774   582.789     0.150
    56.898   582.789     0.150
    56.931   583.289     0.150
    57.502   586.789     0.150
    57.849   590.289     0.150
    58.556   594.289     0.150
    58.652   595.789     0.150
    60.134   606.289     0.150
    60.649   608.391     0.150
    60.825   609.789     0.150
    61.207   612.188     0.150
    61.211   612.188     0.150
    62.167   619.391     0.150
    62.359   620.789     0.150
    67.130   652.488     0.150
    68.305   658.289     0.150
    69.985   671.188     0.150
    70.154   672.188     0.150
    70.541   673.789     0.150
    72.591   687.090     0.150
    72.694   686.188     0.150
    73.312   690.391     0.150
    73.854   693.391     0.150
    75.302   702.391     0.150
    75.435   703.090     0.150
    75.471   703.590     0.150
    75.843   704.590     0.150
    76.399   708.488     0.150
    76.399     4.301     0.150
    76.531   709.590     0.150
    76.560   709.988     0.150
    76.850   710.289     0.150
    76.770   710.688     0.150
    77.004   711.789     0.150
    76.919   711.391     0.150
    77.406   714.391     0.150
    78.155   717.391     0.150
    78.953   722.988     0.150
    80.610   732.789     0.150
    81.351   734.988     0.150
    82.079   742.590     0.150
    82.779   743.590     0.150
    85.289   754.891     0.150
    85.289     4.199     0.150
    85.400   754.488     0.150
    85.400     5.301     0.150
    85.400   759.789     0.150
    85.523   756.590     0.150
    87.843   768.789     0.150
    88.080   769.188     0.150
    95.627   803.789     0.150
    96.755   807.789     0.150
    98.340   814.789     0.150
   102.692   834.789     0.150
   128.590  1144.789     0.150
   144.414  1171.789     0.150
   145.935  1176.090     0.150
   156.766  1225.988     0.150
     0.439     9.531     0.150
     2.074    32.531     0.150
     2.438    39.832     0.150
     2.438    74.332     0.150
     4.920    71.531     0.150
     4.920    71.832     0.150
     5.096    75.133     0.150
     7.815   111.531     0.150
     7.815   197.531     0.150
    10.895   151.633     0.150
    15.065   207.031     0.150
    16.238   222.031     0.150
    16.329   228.531     0.150
    16.329   231.531     0.150
    19.642   263.531     0.150
    19.642   264.332     0.150
    20.704   278.531     0.150
    20.704   511.531     0.150
    21.122   282.531     0.150
    21.122   282.930     0.150
    21.339   284.730     0.150
    21.339   523.730     0.150
    25.553   326.531     0.150
    27.236   340.531     0.150
    28.990   356.633     0.150
    29.379   358.531     0.150
    31.177   376.531     0.150
    32.240   385.531     0.150
    32.689   390.531     0.150
    32.724   389.531     0.150
    33.325   394.531     0.150
    33.325   394.930     0.150
    33.395   395.531     0.150
    33.585   397.531     0.150
    33.585   721.531     0.150
    34.719   407.531     0.150
    35.278   412.332     0.150
    35.434   413.832     0.150
    36.108   417.531     0.150
    37.441   429.531     0.150
    37.439   429.133     0.150
    38.575   438.730     0.150
    38.575   523.531     0.150
    38.490   439.531     0.150
    39.667   447.531     0.150
    39.732   449.531     0.150
    40.017   450.430     0.150
    40.005   453.531     0.150
    40.080   453.133     0.150
    40.144   454.031     0.150
    40.446   453.230     0.150
    40.446   552.832     0.150
    40.568   454.531     0.150
    40.880   457.531     0.150
    41.605   463.531     0.150
    42.671   472.430     0.150
    42.839   473.730     0.150
    43.777   479.930     0.150
    43.919   482.031     0.150
    44.466   485.531     0.150
    45.061   492.832     0.150
    45.112   493.832     0.150
    45.260   496.031     0.150
    45.260   495.531     0.150
    46.037   499.133     0.150
    46.717   505.531     0.150
    46.980   507.531     0.150
    47.372   509.332     0.150
    48.268   516.031     0.150
    48.268    10.801     0.150
    48.993   523.531     0.150
    49.536   527.531     0.150
    49.764   529.730     0.150
    49.997   531.730     0.150
    51.498   539.531     0.150
    51.602   541.531     0.150
    51.921   545.531     0.150
    53.146   555.531     0.150
    53.048   555.531     0.150
    53.709   557.832     0.150
    53.800   558.430     0.150
    54.089   561.031     0.150
    54.860   566.531     0.150
    54.860    11.000     0.150
    54.883   567.031     0.150
    55.145   568.730     0.150
    55.445   571.633     0.150
    55.874   573.531     0.150
    56.004   574.031     0.150
    56.301   576.031     0.150
    56.628   578.332     0.150
    57.019   581.531     0.150
    58.784   595.531     0.150
    60.177   603.531     0.150
    60.477   604.531     0.150
    60.753   607.230     0.150
    60.929   608.332     0.150
    61.064   609.332     0.150
    66.118   642.730     0.150
    68.045   655.531     0.150
    69.430   663.531     0.150
    70.087   669.031     0.150
    70.481   671.332     0.150
    72.645   683.531     0.150
    73.234   688.230     0.150
    73.777   691.133     0.150
    74.356   693.531     0.150
    75.360   701.230     0.150
    76.321   706.531     0.150
    76.490   707.633     0.150
    76.855   709.531     0.150
    77.435   712.133     0.150
    78.086   715.832     0.150
    79.458   723.531     0.150
    82.706   740.531     0.150
    84.735   749.531     0.150
    85.249   752.633     0.150
    85.359   753.930     0.150
    87.316   763.031     0.150
    87.972   768.031     0.150
    88.309   768.531     0.150
   144.480  1169.531     0.150
   144.480  1170.031     0.150
   145.925  1173.832     0.150
     0.478     8.703     0.150
     0.478    15.404     0.150
     1.097    18.805     0.150
     2.812    44.305     0.150
     3.643   114.504     0.150
     3.980    61.004     0.150
     4.385    67.004     0.150
     5.272    80.004     0.150
     5.272   141.004     0.150
     5.272    80.604     0.150
     6.367   164.404     0.150
     7.026   103.703     0.150
     7.234   106.004     0.150
     7.234   186.004     0.150
    11.565   163.004     0.150
    11.565   163.805     0.150
    14.791   207.203     0.150
    19.324   265.004     0.150
    19.324   265.305     0.150
    21.279   286.703     0.150
    21.976   294.504     0.150
    27.792   351.004     0.150
    29.970   367.805     0.150
    33.434   399.004     0.150
    33.434   399.504     0.150
    33.434     5.500     0.150
    34.445   408.504     0.150
    38.945   445.004     0.150
    39.656   453.203     0.150
    39.980   455.004     0.150
    39.980     4.000     0.150
    42.291   472.004     0.150
    43.009     6.900     0.150
    43.114   480.904     0.150
    44.062   488.305     0.150
    44.374   488.504     0.150
    44.661   491.004     0.150
    45.423   499.004     0.150
    45.787   502.004     0.150
    45.787   502.104     0.150
    46.334     6.500     0.150
    47.429   513.104     0.150
    47.692   515.504     0.150
    47.725   516.305     0.150
    48.153   521.004     0.150
    48.996   526.004     0.150
    52.560   554.004     0.150
    52.560     5.000     0.150
    53.523   559.703     0.150
    53.921   564.004     0.150
    53.921     4.000     0.150
    55.152   575.004     0.150
    55.342   575.004     0.150
    57.069   585.203     0.150
    57.112   585.004     0.150
    61.168   614.004     0.150
    64.351   633.004     0.150
    66.866   651.004     0.150
    68.789   664.004     0.150
    70.116   671.004     0.150
    71.220   679.703     0.150
    77.217   714.203     0.150
    77.589   716.904     0.150
    77.566   714.604     0.150
    84.351   753.004     0.150
   145.234  1175.504     0.150
     0.142     3.516     0.150
     0.157     3.914     0.150
     0.325     6.812     0.150
     0.325    12.211     0.150
     1.302    22.914     0.150
     1.302    40.609     0.150
     1.413    24.516     0.150
     1.296    23.109     0.150
     1.296    43.109     0.150
     1.296    23.211     0.150
     1.296    40.609     0.150
     1.550    26.812     0.150
     1.550    27.211     0.150
     1.550    47.914     0.150
     1.550    26.711     0.150
     2.229    37.609     0.150
     2.229    67.711     0.150
     2.372    38.516     0.150
     2.372    42.711     0.150
     2.372    68.914     0.150
     2.372    73.312     0.150
     2.275    37.812     0.150
     2.275    41.516     0.150
     2.275    70.516     0.150
     2.758    44.414     0.150
     2.758    49.914     0.150
     2.758    87.109     0.150
     2.758    45.109     0.150
     3.068    49.914     0.150
     3.068    57.914     0.150
     3.068    90.109     0.150
     3.068    98.109     0.150
     4.190    63.414     0.150
     4.190   131.211     0.150
     4.190    75.914     0.150
     4.190   131.414     0.150
     4.297    64.312     0.150
     4.297    77.312     0.150
     4.297    64.016     0.150
     4.297    77.812     0.150
     4.297   132.914     0.150
     5.429    80.312     0.150
     5.429    99.312     0.150
     5.429   169.414     0.150
     5.820   107.609     0.150
     5.820   182.609     0.150
     6.645    95.711     0.150
     6.645   207.516     0.150
     6.718    97.312     0.150
     6.718    98.109     0.150
     7.802   112.016     0.150
     7.802   111.516     0.150
     8.473   123.312     0.150
     8.473   123.109     0.150
     8.473   155.711     0.150
     8.473   262.711     0.150
     8.473   123.609     0.150
     8.658   125.312     0.150
     8.658   158.312     0.150
     8.658   124.812     0.150
     8.658   157.812     0.150
     8.773   125.914     0.150
    10.119   142.312     0.150
    10.119   142.711     0.150
    20.504   282.312     0.150
    26.417   337.312     0.150
    26.427   337.312     0.150
    38.943   444.312     0.150
    40.099   453.312     0.150
    41.013   464.211     0.150
    43.494   480.312     0.150
    44.392   490.312     0.150
    46.051   504.312     0.150
    54.322   564.312     0.150
    54.704   567.312     0.150
    55.742   578.312     0.150
    77.986   716.609     0.150
     0.110     2.473     0.150
     0.079     2.270     0.150
     0.150     2.973     0.150
     0.332     6.270     0.150
     0.252     5.172     0.150
     0.412     7.371     0.150
     1.218    22.070     0.150
     1.218    39.570     0.150
     1.380    25.070     0.150
     1.443    25.871     0.150
     1.512    27.270     0.150
     1.512    47.070     0.150
     2.307    38.871     0.150
     2.307    42.070     0.150
     2.307    69.672     0.150
     2.205    37.871     0.150
     2.205    40.371     0.150
     2.205    69.371     0.150
     2.450    41.473     0.150
     2.450    44.270     0.150
     2.450    74.672     0.150
     2.679    44.270     0.150
     2.679    49.070     0.150
     2.679    84.473     0.150
     3.135    52.770     0.150
     3.135    61.473     0.150
     3.135   101.270     0.150
     3.135    52.570     0.150
     4.132   125.672     0.150
     4.321    64.871     0.150
     4.321    76.871     0.150
     4.321    65.270     0.150
     4.321    77.473     0.150
     4.321   134.473     0.150
     5.503    82.973     0.150
     5.503   168.473     0.150
     5.890   184.070     0.150
     6.794   122.871     0.150
     6.794   174.070     0.150
     6.794   211.871     0.150
     6.794   101.172     0.150
     6.794   208.070     0.150
     7.879   114.473     0.150
     7.879   242.973     0.150
     8.546   157.270     0.150
     8.546   217.473     0.150
     8.546   264.172     0.150
     8.546   126.973     0.150
     8.736   126.871     0.150
     8.736   269.871     0.150
     8.736   127.070     0.150
     8.736   269.371     0.150
     8.852   128.973     0.150
     8.852   275.570     0.150
    10.047   143.871     0.150
    10.047   144.070     0.150
    15.990   223.672     0.150
    16.397   232.570     0.150
    17.126   237.871     0.150
    17.314   438.871     0.150
    20.579   284.871     0.150
    20.626   282.871     0.150
    43.449   482.371     0.150
    47.732   518.871     0.150
    77.984   717.871     0.150
     1.196    22.715     0.150
     1.613    30.815     0.150
     2.889    48.815     0.150
     2.889    81.515     0.150
     3.509    54.315     0.150
     3.509    63.315     0.150
     3.509   108.815     0.150
     3.949    61.215     0.150
     3.949   118.315     0.150
     4.335    67.815     0.150
     4.335   132.815     0.150
     5.253    78.515     0.150
     5.253    93.215     0.150
     5.253   162.115     0.150
     5.632    83.815     0.150
     5.632   176.815     0.150
     6.359    92.815     0.150
     6.359   194.815     0.150
     6.988   102.815     0.150
     7.232   106.815     0.150
     7.232   185.815     0.150
     7.232   221.815     0.150
     7.232   185.615     0.150
     7.232   221.715     0.150
    14.617   212.815     0.150
    14.734   209.815     0.150
    14.854   207.115     0.150
    16.137   226.615     0.150
    16.137   412.115     0.150
    18.006   453.815     0.150
    19.121   264.815     0.150
    19.378   265.815     0.150
    19.378   265.915     0.150
    19.480   270.815     0.150
    19.916   273.815     0.150
    21.331   287.815     0.150
    22.002   295.515     0.150
    23.817   315.815     0.150
    24.828   323.815     0.150
    25.114   326.815     0.150
    25.123   326.815     0.150
    26.835   340.815     0.150
    26.835   341.615     0.150
    33.489   399.815     0.150
    37.980   437.815     0.150
    39.824   455.615     0.150
    39.824   823.815     0.150
    40.109   455.715     0.150
    43.177   481.015     0.150
    44.363   490.815     0.150
    45.111   497.815     0.150
    45.204   499.815     0.150
    45.852   502.815     0.150
    45.852   502.815     0.150
    47.807   516.815     0.150
    47.821   516.315     0.150
    48.670   524.815     0.150
    53.422   559.315     0.150
    54.043   563.615     0.150
    55.232   572.815     0.150
    55.462   575.815     0.150
    57.157   586.215     0.150
    58.666   599.815     0.150
    71.293   680.015     0.150
    76.020   708.315     0.150
    76.262   708.315     0.150
    86.197   759.215     0.150
   145.113  1173.115     0.150
     1.009    17.840     0.150
     1.937    33.742     0.150
     1.937    57.840     0.150
     2.165    36.742     0.150
     2.165    39.242     0.150
     2.165    65.141     0.150
     2.477    41.941     0.150
     2.477    48.441     0.150
     2.477    74.840     0.150
     2.495    41.641     0.150
     2.495    45.441     0.150
     3.738    56.941     0.150
     3.738    67.641     0.150
     3.738   102.340     0.150
     3.738   115.242     0.150
     4.224    63.941     0.150
     4.224    75.840     0.150
     4.224   132.039     0.150
     6.208   111.641     0.150
     6.208   193.641     0.150
     8.189   119.141     0.150
    10.683   150.141     0.150
    11.946   170.641     0.150
    11.946   170.742     0.150
    14.382   210.242     0.150
    15.687   224.641     0.150
    15.687   225.141     0.150
    16.902   233.641     0.150
    16.902   417.941     0.150
    16.902   233.941     0.150
    17.442   242.641     0.150
    20.078   274.242     0.150
    20.241   275.641     0.150
    20.241   282.641     0.150
    20.241   276.340     0.150
    20.330   277.641     0.150
    20.330   282.641     0.150
    20.617   284.141     0.150
    21.057   285.641     0.150
    25.913   332.641     0.150
    25.913   333.141     0.150
    26.045   333.840     0.150
    26.055   333.840     0.150
    28.491   358.641     0.150
    28.491   400.840     0.150
    32.604   391.641     0.150
    40.360   456.641     0.150
    41.723   468.141     0.150
    44.113   487.641     0.150
    44.293   487.641     0.150
    44.996   495.641     0.150
    45.941   502.840     0.150
    47.026   511.641     0.150
    47.707   515.340     0.150
    47.975   517.609     0.150
    48.062   517.941     0.150
    48.422   521.039     0.150
    48.537   521.641     0.150
    53.142   557.641     0.150
    53.142     8.000     0.150
    53.142   622.641     0.150
    53.412   559.641     0.150
    54.084   563.840     0.150
    54.512   565.641     0.150
    55.861   577.941     0.150
    56.412   580.840     0.150
    56.456   580.641     0.150
    63.813   630.641     0.150
    77.531   714.641     0.150
    77.533   713.840     0.150
     0.552    10.984     0.150
     0.552    17.984     0.150
     0.545    10.680     0.150
     0.545    17.781     0.150
     0.545    17.578     0.150
     0.783    14.680     0.150
     0.783    24.883     0.150
     0.981    18.180     0.150
     0.981    30.883     0.150
     0.989    18.180     0.150
     0.989    30.680     0.150
     1.005    18.680     0.150
     1.005    32.484     0.150
     1.017    19.281     0.150
     1.017    31.883     0.150
     1.017    20.281     0.150
     1.017    33.781     0.150
     1.297    23.484     0.150
     1.297    40.984     0.150
     1.419    25.883     0.150
     1.419    44.781     0.150
     1.419    25.578     0.150
     1.419    26.578     0.150
     1.419    44.180     0.150
     1.520    27.578     0.150
     1.520    28.281     0.150
     1.520    49.281     0.150
     2.246    37.281     0.150
     2.246    39.984     0.150
     2.246    68.781     0.150
     2.246    37.680     0.150
     2.246    40.383     0.150
     2.285    38.078     0.150
     2.285    41.078     0.150
     2.285    42.781     0.150
     2.285    65.781     0.150
     2.285    72.281     0.150
     2.467    39.281     0.150
     2.467    38.984     0.150
     2.467    45.078     0.150
     2.467    69.484     0.150
     2.467    74.781     0.150
     2.467    39.180     0.150
     3.036    48.383     0.150
     3.036    54.883     0.150
     3.036    82.383     0.150
     3.036    94.578     0.150
     3.713    58.180     0.150
     3.713    67.078     0.150
     3.713   116.281     0.150
     3.707    57.180     0.150
     3.707    66.180     0.150
     3.707   114.984     0.150
     3.707    99.781     0.150
     3.707   115.781     0.150
     4.392    68.078     0.150
     4.392    76.578     0.150
     4.392   114.781     0.150
     4.392   134.781     0.150
     4.713    70.781     0.150
     4.713   122.781     0.150
     4.713   148.281     0.150
     4.713    87.281     0.150
     4.713   122.281     0.150
     4.713   147.781     0.150
     4.781   146.281     0.150
     4.781   149.281     0.150
     5.690    82.781     0.150
     5.690   176.781     0.150
     5.690   147.984     0.150
     5.920   153.281     0.150
     6.351    93.281     0.150
     6.351   118.578     0.150
     6.351   164.781     0.150
     6.351   194.281     0.150
     6.788    98.984     0.150
     6.788   171.281     0.150
     6.788   207.578     0.150
     7.433   109.281     0.150
     7.433   136.781     0.150
     7.433   229.281     0.150
     7.433   123.281     0.150
     7.433   136.578     0.150
     7.433   230.984     0.150
     7.433   109.180     0.150
     7.656   112.680     0.150
     7.656   195.984     0.150
     7.656   112.984     0.150
     7.656   195.383     0.150
     7.818   114.281     0.150
     7.818   198.781     0.150
    11.159   277.781     0.150
    14.630   213.383     0.150
    15.074   219.781     0.150
    15.160   216.781     0.150
    15.160   217.180     0.150
    15.821   224.781     0.150
    16.398   231.781     0.150
    18.140   252.281     0.150
    19.547   270.281     0.150
    19.706   267.781     0.150
    19.706   267.883     0.150
    20.314   277.281     0.150
    21.677   290.680     0.150
    25.377   328.180     0.150
    25.369   328.781     0.150
    25.509   328.484     0.150
    33.820   402.984     0.150
    34.051   405.383     0.150
    77.604   714.883     0.150
    77.607   714.578     0.150
     6.501   193.232     0.150
     8.255   118.232     0.150
    18.473   257.232     0.150
    18.473   475.732     0.150
    20.066   272.732     0.150
    20.153   269.033     0.150
    20.153   498.732     0.150
    20.336   273.732     0.150
    21.051   285.232     0.150
    21.051   652.232     0.150
    25.707   332.033     0.150
    28.379   398.232     0.150
    38.946     7.000     0.150
    40.084   454.232     0.150
    41.456   464.232     0.150
    41.925   469.533     0.150
    42.850   476.533     0.150
    43.672   482.533     0.150
    43.886   482.232     0.150
    44.603   491.232     0.150
    45.131   492.232     0.150
    45.131    10.000     0.150
    46.223   502.932     0.150
    46.606   506.232     0.150
    46.606    11.000     0.150
    47.419   512.633     0.150
    47.782   514.232     0.150
    48.361   518.832     0.150
    53.196   556.232     0.150
    54.197   563.533     0.150
    54.197   563.232     0.150
    54.281   563.232     0.150
    55.362   572.232     0.150
    55.644   574.732     0.150
    55.644     8.500     0.150
    55.983   575.832     0.150
    57.288   586.232     0.150
    57.387   585.633     0.150
    60.406   606.232     0.150
    61.214   611.932     0.150
    61.392   612.332     0.150
    64.493   634.232     0.150
    65.813   642.232     0.150
    66.103   644.232     0.150
    67.004   651.332     0.150
    67.664   654.732     0.150
    69.372   665.232     0.150
    71.046   674.832     0.150
    75.053   698.932     0.150
    75.687   703.533     0.150
    76.032   705.332     0.150
    76.861   710.432     0.150
    78.155   717.432     0.150
    79.073   721.732     0.150
    79.445   724.033     0.150
    83.202   743.932     0.150
    83.601   746.133     0.150
    84.098   747.732     0.150
    84.987   752.033     0.150
    85.741   756.033     0.150
    86.317   759.033     0.150
   145.989  1182.033     0.150
     0.558    10.602     0.150
     0.946    17.000     0.150
     1.001    17.898     0.150
     1.685    30.102     0.150
     1.926    33.195     0.150
     1.926    59.898     0.150
     2.218    35.695     0.150
     2.218    40.695     0.150
     2.854    45.398     0.150
     2.854    51.898     0.150
     2.854    81.898     0.150
     3.322    51.898     0.150
     3.322    58.898     0.150
     3.322    91.398     0.150
     3.322   102.898     0.150
     3.666    55.898     0.150
     3.666    56.602     0.150
     3.666    66.898     0.150
     3.666    97.898     0.150
     3.666   113.898     0.150
     5.621    83.898     0.150
     5.621    84.195     0.150
     5.621   174.797     0.150
     6.965   101.898     0.150
     6.965   180.898     0.150
     6.965   205.898     0.150
     6.965   217.898     0.150
     8.599   124.898     0.150
     8.599   125.695     0.150
     8.599   159.398     0.150
     8.599   218.398     0.150
     8.989   130.898     0.150
    13.747   192.102     0.150
    14.599   205.398     0.150
    14.923   210.500     0.150
    15.014   210.102     0.150
    15.333   216.398     0.150
    15.333   222.898     0.150
    15.333   478.398     0.150
    15.635   219.398     0.150
    16.602   229.898     0.150
    16.602   230.195     0.150
    17.385   244.898     0.150
    17.981   251.898     0.150
    17.981   564.898     0.150
    18.221   449.898     0.150
    18.976   262.500     0.150
    18.976   269.500     0.150
    18.976   475.898     0.150
    19.499   485.898     0.150
    19.574   266.898     0.150
    19.574   487.898     0.150
    19.574   267.297     0.150
    20.863   282.898     0.150
    20.863   294.398     0.150
    20.879   284.398     0.150
    20.879   288.398     0.150
    21.151   283.898     0.150
    21.151   522.195     0.150
    21.151   284.398     0.150
    21.151   305.398     0.150
    21.943   293.398     0.150
    23.762   313.500     0.150
    24.946   586.898     0.150
    24.966   323.898     0.150
    24.966   583.898     0.150
    25.075   325.398     0.150
    25.619   329.695     0.150
    25.871   334.297     0.150
    26.766   341.898     0.150
    26.766   987.898     0.150
    26.912   341.898     0.150
    26.921   341.898     0.150
    26.921   391.898     0.150
    28.634   356.898     0.150
    28.634   546.898     0.150
    29.364   362.195     0.150
    29.709     4.805     0.150
    30.140   371.898     0.150
    30.578   372.898     0.150
    30.578     6.000     0.150
    31.687   382.398     0.150
    32.088   387.102     0.150
    32.088   693.898     0.150
    32.088   553.898     0.150
    32.614   390.898     0.150
    33.623   399.898     0.150
    33.623   400.297     0.150
    34.025   403.898     0.150
    34.025   726.898     0.150
    34.301   407.500     0.150
    34.537   409.539     0.150
    34.792   409.898     0.150
    34.899   412.641     0.150
    35.022   411.898     0.150
    35.022   747.695     0.150
    35.022   412.500     0.150
    34.992   413.602     0.150
    35.034   413.336     0.150
    35.131   414.695     0.150
    36.116   421.398     0.150
    36.714   428.898     0.150
    36.714     4.797     0.150
    36.714   769.898     0.150
    37.443   433.195     0.150
    38.696   443.500     0.150
    38.696     6.898     0.150
    38.615   444.398     0.150
    39.887   452.695     0.150
    39.887     8.000     0.150
    41.266   463.898     0.150
    41.266   837.898     0.150
    41.266   853.898     0.150
    41.266   563.898     0.150
    41.615   469.195     0.150
    42.011   471.102     0.150
    42.114   470.898     0.150
    42.114     7.000     0.150
    42.114  1037.898     0.150
    42.348   473.898     0.150
    42.348   579.898     0.150
    42.698   475.797     0.150
    43.869   486.695     0.150
    43.964   485.898     0.150
    44.022     5.398     0.150
    44.268   488.398     0.150
    44.268     7.500     0.150
    44.473   493.898     0.150
    44.558   492.898     0.150
    44.741   494.898     0.150
    45.387   499.602     0.150
    45.561   499.898     0.150
    46.049   502.898     0.150
    46.084   503.602     0.150
    46.165     5.797     0.150
    46.165   611.898     0.150
    46.165   911.898     0.150
    46.168   504.102     0.150
    46.168     5.797     0.150
    46.168   911.898     0.150
    46.168   927.898     0.150
    46.545   506.898     0.150
    46.692   507.898     0.150
    46.692   612.898     0.150
    46.809   510.898     0.150
    46.809   619.898     0.150
    46.926   510.898     0.150
    46.926     4.500     0.150
    47.386   514.898     0.150
    47.386   929.898     0.150
    47.437   513.195     0.150
    47.437     7.703     0.150
    47.667   516.898     0.150
    47.667   628.898     0.150
    47.811   518.898     0.150
    48.071   632.898     0.150
    48.743   523.102     0.150
    48.929   526.398     0.150
    49.028   525.398     0.150
    50.797   540.797     0.150
    51.013   539.898     0.150
    51.013     8.000     0.150
    51.013   661.898     0.150
    51.726   545.898     0.150
    52.618   553.398     0.150
    52.839   555.102     0.150
    52.839   555.000     0.150
    53.038   555.898     0.150
    53.038     6.602     0.150
    53.121   556.797     0.150
    53.121     7.000     0.150
    53.121  1015.898     0.150
    53.143   558.398     0.150
    53.395   559.398     0.150
    53.493   559.898     0.150
    53.493   560.398     0.150
    53.597   560.898     0.150
    53.804   563.898     0.150
    54.004   564.898     0.150
    54.100   566.898     0.150
    54.189   564.898     0.150
    54.189     7.602     0.150
    55.120   572.898     0.150
    55.188   572.297     0.150
    55.188     6.602     0.150
    55.188   632.898     0.150
    55.188     7.000     0.150
    55.269   571.898     0.150
    55.269   695.898     0.150
    55.391   573.898     0.150
    55.480   575.602     0.150
    55.579   574.898     0.150
    55.579     7.398     0.150
    55.579   700.898     0.150
    55.754   575.797     0.150
    56.350   580.602     0.150
    56.350  1060.898     0.150
    56.637   582.398     0.150
    56.637     7.703     0.150
    56.637   704.898     0.150
    56.637   709.602     0.150
    56.724   584.898     0.150
    57.234   586.898     0.150
    57.234     7.602     0.150
    57.295   587.398     0.150
    57.295     7.000     0.150
    57.943   591.695     0.150
    58.212   594.195     0.150
    58.283   594.797     0.150
    58.325   593.898     0.150
    58.531   595.898     0.150
    58.598   596.398     0.150
    58.598     6.500     0.150
    58.604   596.898     0.150
    58.688   596.602     0.150
    58.688     8.398     0.150
    58.808   598.195     0.150
    58.829   597.500     0.150
    58.899   598.695     0.150
    58.899   642.797     0.150
    58.901   597.898     0.150
    59.133   599.195     0.150
    59.194   600.000     0.150
    59.254   600.898     0.150
    59.365   601.898     0.150
    59.365     9.000     0.150
    59.452   601.602     0.150
    59.471   603.297     0.150
    59.528   602.195     0.150
    59.653   602.898     0.150
    59.809   603.398     0.150
    59.825   604.102     0.150
    59.873   605.297     0.150
    59.880   605.102     0.150
    59.997   606.398     0.150
    60.365   608.695     0.150
    60.457   609.797     0.150
    60.537   609.297     0.150
    60.585   609.500     0.150
    60.752   610.898     0.150
    61.002   612.398     0.150
    61.206   614.195     0.150
    61.336   614.797     0.150
    61.392   616.602     0.150
    61.438   616.000     0.150
    61.472   616.297     0.150
    61.654   617.602     0.150
    61.687   618.398     0.150
    61.759   617.289     0.150
    61.797   618.297     0.150
    61.836   619.000     0.150
    61.878   619.695     0.150
    61.919   619.398     0.150
    62.134   619.797     0.150
    62.186   621.102     0.150
    62.190   621.297     0.150
    62.196   619.898     0.150
    62.262   621.898     0.150
    62.375   621.000     0.150
    62.373   621.078     0.150
    62.389   622.602     0.150
    62.396   622.602     0.150
    62.452   621.180     0.150
    62.505   621.898     0.150
    62.552   624.695     0.150
    62.586   623.000     0.150
    62.695   621.898     0.150
    62.702   623.398     0.150
    62.704   623.102     0.150
    62.705   623.000     0.150
    62.781   624.797     0.150
    62.783   623.641     0.150
    62.786   624.000     0.150
    62.837   625.180     0.150
    62.856   624.375     0.150
    63.002   626.500     0.150
    63.025   624.867     0.150
    63.115   624.867     0.150
    63.141   624.766     0.150
    63.155   626.102     0.150
    63.159   627.031     0.150
    63.180   626.602     0.150
    63.397   628.797     0.150
    63.566   629.602     0.150
    63.657   629.898     0.150
    63.746   631.102     0.150
    63.933   632.602     0.150
    63.963   631.602     0.150
    63.983   632.195     0.150
    64.225   633.797     0.150
    64.343   634.602     0.150
    66.009   644.898     0.150
    66.068   646.898     0.150
    66.478   648.797     0.150
    66.700   651.000     0.150
    66.750   650.898     0.150
    67.090   652.297     0.150
    67.279   655.195     0.150
    67.792   657.898     0.150
    67.797   657.195     0.150
    69.919   671.898     0.150
    69.911   669.898     0.150
    70.918   677.102     0.150
    71.943   683.898     0.150
    72.177   684.898     0.150
    72.222   685.102     0.150
    72.592   687.695     0.150
    72.877   689.398     0.150
    73.541   692.398     0.150
    73.552   692.695     0.150
    73.766   694.398     0.150
    73.878   694.797     0.150
    74.494   699.695     0.150
    74.575   699.102     0.150
    75.034   701.898     0.150
    75.080   700.297     0.150
    75.241   704.898     0.150
    75.343   705.398     0.150
    75.391   703.000     0.150
    75.438   705.898     0.150
    75.627   705.602     0.150
    76.739   712.195     0.150
    76.757   711.898     0.150
    76.799   712.102     0.150
    77.130   712.695     0.150
    77.416   715.898     0.150
    78.557   721.898     0.150
    78.630   722.898     0.150
    79.111   724.602     0.150
    79.131   724.297     0.150
    79.380   726.898     0.150
    79.545   726.898     0.150
    80.726   733.898     0.150
    80.679   732.195     0.150
    81.095   734.898     0.150
    82.119   740.898     0.150
    83.212   745.898     0.150
    83.215   745.898     0.150
    89.017   775.297     0.150
   141.208  1172.695     0.150
   144.836  1175.000     0.150
   144.939  1174.898     0.150
   144.939  1179.898     0.150
   145.444  1175.898     0.150
   146.592  1182.695     0.150
   149.525  1188.102     0.150
     0.202     4.398     0.150
     0.202     9.297     0.150
     0.397    14.297     0.150
     0.541    10.500     0.150
     0.541    17.898     0.150
     0.465     9.000     0.150
     0.465    16.500     0.150
     0.592    11.898     0.150
     0.592    19.500     0.150
     0.737    13.898     0.150
     0.737    24.000     0.150
     0.876    15.898     0.150
     1.810    31.398     0.150
     1.810    54.398     0.150
     1.715    29.898     0.150
     1.824    30.797     0.150
     3.181    49.898     0.150
     3.181    50.102     0.150
     3.181    58.898     0.150
     3.181    99.695     0.150
     4.166    63.297     0.150
     4.166    74.898     0.150
     4.166   130.695     0.150
     4.497    67.398     0.150
     4.497   140.898     0.150
     6.300   113.898     0.150
     6.300   193.898     0.150
     6.458    94.297     0.150
     6.458   166.297     0.150
     7.379   106.898     0.150
     7.379   227.398     0.150
     8.068   249.898     0.150
     8.233   119.898     0.150
     8.233   120.102     0.150
    10.523   147.398     0.150
    10.523   259.398     0.150
    14.801   214.500     0.150
    15.522   223.398     0.150
    15.652   225.898     0.150
    15.652   384.898     0.150
    15.983   228.898     0.150
    15.983   407.898     0.150
    16.282   229.398     0.150
    18.443   576.398     0.150
    18.794   258.398     0.150
    18.794   275.898     0.150
    20.123   274.797     0.150
    20.685   279.898     0.150
    20.947   283.398     0.150
    22.261   296.898     0.150
    24.473   319.898     0.150
    34.462   407.898     0.150
    34.535   409.102     0.150
    38.886   443.602     0.150
    44.240   489.227     0.150
    44.649   493.398     0.150
    44.649   888.195     0.150
    44.758   492.727     0.150
    45.749   501.141     0.150
    47.615   515.078     0.150
    47.951   516.102     0.150
    49.188   527.570     0.150
    53.034   555.898     0.150
    54.039   563.602     0.150
    54.125   563.102     0.150
    55.207   571.695     0.150
    55.482   573.898     0.150
    55.640   574.898     0.150
    56.088   578.500     0.150
    58.742   596.297     0.150
    61.065   611.602     0.150
    61.242   614.195     0.150
    61.242   612.797     0.150
    61.248   614.398     0.150
    61.375   613.898     0.150
    61.569   615.000     0.150
    61.596   614.797     0.150
    61.599   614.898     0.150
    62.436   621.500     0.150
    62.837   623.602     0.150
    63.226   626.398     0.150
    67.776   657.188     0.150
    68.115   660.289     0.150
    72.511   686.945     0.150
    73.878   695.070     0.150
    75.137   702.227     0.150
    75.412   703.898     0.150
    76.756   711.711     0.150
    76.787   711.789     0.150
    76.851   712.117     0.150
    77.021   712.867     0.150
    77.972   717.102     0.150
    78.268   719.117     0.150
    78.304   720.188     0.150
    79.205   724.789     0.150
    79.251   725.156     0.150
    79.324   725.609     0.150
    79.392   725.992     0.150
    79.663   727.328     0.150
    83.342   746.117     0.150
   140.734  1170.500     0.150
     0.734    13.916     0.150
     0.734    13.416     0.150
     0.743    15.115     0.150
     0.743    24.615     0.150
     0.750    15.115     0.150
     0.750    24.615     0.150
     0.802    15.115     0.150
     0.802    15.416     0.150
     1.567    29.314     0.150
     1.791    30.615     0.150
     1.927    32.615     0.150
     1.927    32.416     0.150
     2.193    37.115     0.150
     2.193    36.916     0.150
     2.298    38.115     0.150
     2.298    40.814     0.150
     2.298    71.916     0.150
     2.870    45.115     0.150
     2.870    45.615     0.150
     2.870    51.314     0.150
     2.870    87.916     0.150
     2.870    51.115     0.150
     2.870    90.115     0.150
     3.470    54.115     0.150
     3.470    63.314     0.150
     3.470    63.115     0.150
     3.470    95.115     0.150
     3.470   109.115     0.150
     3.595    56.314     0.150
     3.595    65.215     0.150
     3.595   112.516     0.150
     4.099    61.715     0.150
     4.099    62.615     0.150
     4.099   128.615     0.150
     4.726    71.314     0.150
     4.726   145.615     0.150
     5.852    86.715     0.150
     5.852   149.416     0.150
     5.852   183.115     0.150
     6.174    91.115     0.150
     6.174   193.115     0.150
     6.513    95.215     0.150
     7.178   105.615     0.150
     7.178   223.615     0.150
     7.828   113.916     0.150
     7.828   200.516     0.150
     8.294   120.516     0.150
     8.294   137.016     0.150
     8.861   129.215     0.150
     8.861   162.115     0.150
     8.861   276.516     0.150
     9.170   132.115     0.150
     9.170   285.615     0.150
     9.345   133.416     0.150
     9.345   288.916     0.150
     9.438   136.416     0.150
     9.438   170.516     0.150
     9.438   296.615     0.150
    14.094   198.115     0.150
    14.883   212.416     0.150
    15.357   217.115     0.150
    15.395   215.715     0.150
    15.395   223.115     0.150
    15.762   222.416     0.150
    16.068   225.615     0.150
    16.089   225.535     0.150
    17.765   245.115     0.150
    17.765   441.115     0.150
    17.792   249.916     0.150
    18.417   257.215     0.150
    19.337   265.115     0.150
    19.337   485.115     0.150
    19.337   609.115     0.150
    19.413   266.615     0.150
    19.621   269.125     0.150
    19.621   491.705     0.150
    19.621   269.615     0.150
    19.621   492.115     0.150
    19.930   273.916     0.150
    19.930   281.615     0.150
    19.930   496.615     0.150
    21.058   285.115     0.150
    21.283   286.916     0.150
    22.373   297.615     0.150
    23.819   313.016     0.150
    24.189   317.115     0.150
    24.583   319.615     0.150
    25.213   322.555     0.150
    25.213   322.115     0.150
    25.213   590.115     0.150
    25.214   323.215     0.150
    25.214   538.916     0.150
    25.399   327.115     0.150
    25.386   327.115     0.150
    25.386   589.115     0.150
    25.386   605.115     0.150
    25.546   328.115     0.150
    25.546   595.115     0.150
    25.511   328.715     0.150
    25.511   593.115     0.150
    25.567   329.314     0.150
    25.609   329.814     0.150
    25.752   328.916     0.150
    26.035   333.305     0.150
    26.186   332.715     0.150
    26.284   335.615     0.150
    26.421   336.016     0.150
    26.423   334.916     0.150
    27.160   344.615     0.150
    28.731   358.115     0.150
    28.731     6.000     0.150
    28.731   646.115     0.150
    29.202   361.115     0.150
    30.136   370.115     0.150
    30.136     7.000     0.150
    30.136   669.115     0.150
    30.136   769.115     0.150
    30.282   372.516     0.150
    30.282   435.615     0.150
    30.414   371.115     0.150
    30.414   436.115     0.150
    31.158   379.115     0.150
    31.158   379.814     0.150
    31.461   380.615     0.150
    32.102   387.115     0.150
    32.102     6.000     0.150
    32.950   394.715     0.150
    32.950   713.115     0.150
    33.720   400.115     0.150
    33.720   400.516     0.150
    33.860   401.715     0.150
    34.592   409.225     0.150
    34.843   411.625     0.150
    34.934   412.686     0.150
    35.156   414.145     0.150
    35.200   414.945     0.150
    35.288   415.605     0.150
    35.338   415.725     0.150
    35.367   416.725     0.150
    35.394   415.645     0.150
    35.432   416.945     0.150
    35.939   421.445     0.150
    36.551   424.115     0.150
    36.551   761.416     0.150
    36.551   424.715     0.150
    37.149   431.734     0.150
    37.149     6.621     0.150
    37.483   432.115     0.150
    37.483   570.215     0.150
    37.954   437.115     0.150
    37.954   435.615     0.150
    37.933   438.115     0.150
    37.933   438.516     0.150
    38.003   438.115     0.150
    38.003   438.314     0.150
    38.112   438.314     0.150
    38.915   443.916     0.150
    38.915   575.115     0.150
    39.022   446.615     0.150
    39.108   445.615     0.150
    39.366   449.215     0.150
    39.366   577.615     0.150
    39.840   453.115     0.150
    41.045   463.115     0.150
    41.045   556.115     0.150
    41.045   833.115     0.150
    41.128   466.115     0.150
    41.128   565.615     0.150
    41.128   840.115     0.150
    41.128  1015.115     0.150
    41.271   464.105     0.150
    41.372   464.916     0.150
    41.489   466.715     0.150
    41.640   470.615     0.150
    41.895   469.115     0.150
    41.895     6.500     0.150
    41.895   845.115     0.150
    41.895  1029.115     0.150
    41.895   470.195     0.150
    41.810   470.814     0.150
    42.075   471.615     0.150
    42.075   575.115     0.150
    42.075   848.115     0.150
    42.161   472.416     0.150
    42.355   474.215     0.150
    42.399   473.115     0.150
    42.866   477.115     0.150
    42.866   588.615     0.150
    42.866   861.016     0.150
    43.540   481.115     0.150
    43.540   869.615     0.150
    43.544   484.615     0.150
    43.977   486.516     0.150
    44.200   487.115     0.150
    44.176   489.115     0.150
    44.176   881.365     0.150
    44.176   488.416     0.150
    44.562   491.314     0.150
    44.562   886.516     0.150
    44.769   494.516     0.150
    44.801   494.215     0.150
    44.923   492.615     0.150
    45.458   499.115     0.150
    45.458   901.115     0.150
    45.602   499.715     0.150
    45.710   501.215     0.150
    45.710   610.814     0.150
    45.710   906.115     0.150
    45.710   501.496     0.150
    45.743   500.416     0.150
    45.902   501.115     0.150
    45.902   501.814     0.150
    46.015   501.814     0.150
    46.089   504.916     0.150
    46.303   506.115     0.150
    46.303   601.115     0.150
    46.303  1100.115     0.150
    46.298   504.416     0.150
    46.497   507.715     0.150
    46.871   509.115     0.150
    47.132     6.600     0.150
    47.132   921.115     0.150
    47.222   511.615     0.150
    47.222     7.000     0.150
    47.222   603.115     0.150
    47.222   923.115     0.150
    47.498   513.916     0.150
    47.770   519.115     0.150
    47.935   633.115     0.150
    47.935   935.115     0.150
    48.130   518.516     0.150
    48.352   519.115     0.150
    48.427   520.814     0.150
    48.366   521.416     0.150
    48.521   522.115     0.150
    48.577   523.314     0.150
    48.796   523.416     0.150
    48.796   946.916     0.150
    48.887   524.756     0.150
    48.887   525.385     0.150
    49.630   531.115     0.150
    49.994   534.115     0.150
    49.994     8.000     0.150
    49.897   533.516     0.150
    50.003   534.715     0.150
    50.252   535.115     0.150
    50.824   539.615     0.150
    50.898   539.246     0.150
    50.898     3.080     0.150
    51.107   542.115     0.150
    51.107   613.314     0.150
    51.167  1199.115     0.150
    51.098   542.314     0.150
    51.245   543.314     0.150
    51.407   543.916     0.150
    51.695   548.115     0.150
    51.686   547.115     0.150
    51.818   547.615     0.150
    51.947   550.416     0.150
    52.025   549.516     0.150
    52.173   551.115     0.150
    52.247   551.814     0.150
    52.437   551.615     0.150
    52.648   553.615     0.150
    52.721   554.615     0.150
    52.813   555.115     0.150
    52.813   624.516     0.150
    52.826   554.715     0.150
    52.826  1002.115     0.150
    52.879   554.715     0.150
    52.879     6.801     0.150
    52.879  1002.115     0.150
    52.928   556.615     0.150
    52.949   556.115     0.150
    53.058   558.115     0.150
    53.172   558.516     0.150
    53.272   559.115     0.150
    53.301   558.115     0.150
    53.301   558.785     0.150
    53.361   558.916     0.150
    53.411   560.215     0.150
    53.609   561.615     0.150
    53.643   561.115     0.150
    53.643  1025.115     0.150
    53.842   562.814     0.150
    53.842     6.801     0.150
    53.842   562.176     0.150
    53.842     6.369     0.150
    53.842  1024.955     0.150
    53.842  1161.676     0.150
    53.842   563.295     0.150
    53.930   563.115     0.150
    53.924   564.115     0.150
    53.964   565.215     0.150
    54.003   566.115     0.150
    54.020   563.715     0.150
    54.020   563.926     0.150
    54.081   563.115     0.150
    54.115   565.615     0.150
    54.208   565.115     0.150
    54.276   565.756     0.150
    54.276   566.064     0.150
    54.377   567.215     0.150
    54.429   568.115     0.150
    54.498   568.115     0.150
    54.649   569.916     0.150
    54.902   571.115     0.150
    54.920   569.916     0.150
    54.920     8.799     0.150
    54.920   570.814     0.150
    54.918   570.115     0.150
    54.997   570.115     0.150
    54.997     7.199     0.150
    55.244   573.215     0.150
    55.305   574.115     0.150
    55.305     6.000     0.150
    55.309   573.416     0.150
    55.318   573.314     0.150
    55.318     7.000     0.150
    55.318  1040.115     0.150
    55.512   572.615     0.150
    55.512  2300.217     0.150
    55.688   575.984     0.150
    55.814   577.516     0.150
    55.814     7.400     0.150
    55.874   577.115     0.150
    56.003   578.115     0.150
    56.033   578.115     0.150
    56.076   577.916     0.150
    56.076     8.100     0.150
    56.076   578.615     0.150
    56.076   635.916     0.150
    56.069   578.115     0.150
    56.215   580.016     0.150
    56.319   580.615     0.150
    56.357   581.115     0.150
    56.377   580.115     0.150
    56.377     7.500     0.150
    56.380   581.115     0.150
    56.424   581.256     0.150
    56.538   582.115     0.150
    56.538     6.600     0.150
    56.538   581.314     0.150
    56.538   636.416     0.150
    56.538  1056.215     0.150
    56.670   583.516     0.150
    56.670   583.086     0.150
    56.668   583.115     0.150
    56.682   583.115     0.150
    56.702   583.115     0.150
    56.702   581.115     0.150
    56.702  1055.115     0.150
    56.780   582.016     0.150
    56.828   584.115     0.150
    56.868   584.506     0.150
    56.932   584.955     0.150
    56.942   585.416     0.150
    56.962   585.615     0.150
    56.962     6.801     0.150
    56.962   585.166     0.150
    56.964   584.416     0.150
    56.964   585.234     0.150
    56.968   584.984     0.150
    56.978   585.436     0.150
    56.988   585.355     0.150
    56.999   585.115     0.150
    57.007   585.645     0.150
    57.092   586.086     0.150
    57.138   586.314     0.150
    57.175   586.115     0.150
    57.210   586.926     0.150
    57.230   586.555     0.150
    57.246   586.115     0.150
    57.251   587.115     0.150
    57.293   587.516     0.150
    57.332   584.715     0.150
    57.310   587.416     0.150
    57.364   588.016     0.150
    57.418   588.234     0.150
    57.517   588.314     0.150
    57.486   588.045     0.150
    57.525   588.766     0.150
    57.519   589.115     0.150
    57.553   588.516     0.150
    57.559   589.115     0.150
    57.592   588.814     0.150
    57.601   589.516     0.150
    57.652   589.916     0.150
    57.667   588.916     0.150
    57.680   589.115     0.150
    57.671   587.875     0.150
    57.673   589.615     0.150
    57.710   590.115     0.150
    57.710   589.984     0.150
    57.738   590.615     0.150
    57.747   591.016     0.150
    57.766   590.115     0.150
    57.790   590.814     0.150
    57.828   591.115     0.150
    57.942   591.916     0.150
    57.987   591.115     0.150
    57.996   592.115     0.150
    58.016   591.416     0.150
    58.032   593.115     0.150
    58.029   592.416     0.150
    58.018   592.416     0.150
    58.051   591.916     0.150
    58.038   592.516     0.150
    58.100   592.314     0.150
    58.104   593.416     0.150
    58.104   593.145     0.150
    58.099   592.814     0.150
    58.099     5.801     0.150
    58.290   593.615     0.150
    58.290     7.000     0.150
    58.303   593.826     0.150
    58.303     6.658     0.150
    58.303  1077.154     0.150
    58.303   593.705     0.150
    58.304     6.801     0.150
    58.301   594.416     0.150
    58.287   593.785     0.150
    58.302   594.314     0.150
    58.342   595.016     0.150
    58.395   594.525     0.150
    58.395     6.670     0.150
    58.386   592.516     0.150
    58.519   593.076     0.150
    58.558   596.016     0.150
    58.579   595.916     0.150
    58.585   596.115     0.150
    58.585     4.500     0.150
    58.611   596.916     0.150
    58.641   597.115     0.150
    58.650   596.516     0.150
    58.681   596.814     0.150
    58.663   596.916     0.150
    58.663   597.285     0.150
    58.810   598.115     0.150
    58.826   598.115     0.150
    58.860   598.715     0.150
    58.890   597.615     0.150
    58.895   598.115     0.150
    58.938   598.615     0.150
    58.921   598.916     0.150
    59.017   599.115     0.150
    59.064   597.115     0.150
    59.077   599.814     0.150
    59.077   599.385     0.150
    59.154   599.416     0.150
    59.154     7.488     0.150
    59.191   598.115     0.150
    59.212   601.516     0.150
    59.227   600.275     0.150
    59.358   601.516     0.150
    59.358     7.100     0.150
    59.358  1093.115     0.150
    59.465   601.416     0.150
    59.568   603.016     0.150
    59.572   602.215     0.150
    59.589   602.115     0.150
    59.601   602.814     0.150
    59.600   602.715     0.150
    59.671   603.945     0.150
    59.735   604.715     0.150
    59.756   604.715     0.150
    59.804   604.615     0.150
    59.804   604.416     0.150
    59.865   604.715     0.150
    59.853   604.916     0.150
    59.892   605.115     0.150
    59.959   605.016     0.150
    60.023   606.115     0.150
    60.050   606.314     0.150
    60.042   608.984     0.150
    60.099   606.615     0.150
    60.101   606.615     0.150
    60.172   606.814     0.150
    60.194   607.615     0.150
    60.249   607.805     0.150
    60.258   607.115     0.150
    60.235   607.916     0.150
    60.278   607.215     0.150
    60.304   607.416     0.150
    60.344   608.016     0.150
    60.347   608.785     0.150
    60.407   608.416     0.150
    60.468   608.916     0.150
    60.497   607.916     0.150
    60.536   609.314     0.150
    60.565   608.785     0.150
    60.623   609.814     0.150
    60.623   610.314     0.150
    60.623   609.615     0.150
    60.689   610.215     0.150
    60.738   610.615     0.150
    60.780   610.814     0.150
    60.789   610.814     0.150
    60.889   611.314     0.150
    60.971   612.314     0.150
    60.970   612.416     0.150
    60.994   612.416     0.150
    61.058   613.314     0.150
    61.065   612.115     0.150
    61.150   614.416     0.150
    61.171   614.314     0.150
    61.185   613.115     0.150
    61.230   615.516     0.150
    61.245   614.115     0.150
    61.385   615.615     0.150
    61.441   616.016     0.150
    61.494   615.564     0.150
    61.498   615.715     0.150
    61.542   616.715     0.150
    61.578   616.984     0.150
    61.588   616.814     0.150
    61.595   616.615     0.150
    61.649   617.715     0.150
    61.670   617.115     0.150
    61.692   619.115     0.150
    61.887   618.215     0.150
    61.909   617.814     0.150
    61.958   618.916     0.150
    61.994   619.615     0.150
    62.089   618.916     0.150
    62.120   620.615     0.150
    62.127   620.715     0.150
    62.151   620.814     0.150
    62.186   618.875     0.150
    62.218   620.016     0.150
    62.327   620.814     0.150
    62.358   622.416     0.150
    62.363   621.615     0.150
    62.397   620.814     0.150
    62.399   620.814     0.150
    62.398   622.314     0.150
    62.418   621.314     0.150
    62.431   621.035     0.150
    62.433   622.715     0.150
    62.499   621.814     0.150
    62.513   622.615     0.150
    62.525   622.186     0.150
    62.570   623.805     0.150
    62.596   622.855     0.150
    62.707   627.586     0.150
    62.761   623.195     0.150
    62.848   623.814     0.150
    62.854   622.855     0.150
    62.879   623.535     0.150
    62.892   624.615     0.150
    62.900   625.496     0.150
    62.971   626.416     0.150
    62.987   625.916     0.150
    62.933   626.615     0.150
    63.054   627.715     0.150
    63.138   626.314     0.150
    63.187   627.516     0.150
    63.211   626.516     0.150
    63.232   627.564     0.150
    63.278   627.615     0.150
    63.368   627.916     0.150
    63.389   628.814     0.150
    63.463   628.814     0.150
    63.482   629.814     0.150
    63.498   629.215     0.150
    63.619   630.846     0.150
    63.672   629.615     0.150
    63.688   631.016     0.150
    63.722   630.115     0.150
    63.736   630.916     0.150
    63.805   631.814     0.150
    64.009   632.215     0.150
    64.044   632.314     0.150
    64.159   636.846     0.150
    64.213   634.814     0.150
    64.389   635.615     0.150
    64.452   635.215     0.150
    64.540   636.314     0.150
    65.000   639.785     0.150
    65.064   639.615     0.150
    65.096   639.814     0.150
    65.116   640.785     0.150
    65.170   641.436     0.150
    65.329   642.756     0.150
    65.597   642.016     0.150
    65.897   645.975     0.150
    66.154   647.115     0.150
    66.206   647.016     0.150
    66.419   649.016     0.150
    66.471   649.115     0.150
    66.558   649.715     0.150
    66.558   649.535     0.150
    66.571   650.016     0.150
    66.731   651.516     0.150
    66.806   650.205     0.150
    66.917   652.955     0.150
    66.994   652.535     0.150
    67.072   653.746     0.150
    67.176   653.826     0.150
    67.181   654.205     0.150
    67.423   655.666     0.150
    67.426   655.355     0.150
    67.471   656.125     0.150
    67.511   656.385     0.150
    67.511   656.715     0.150
    67.542   656.826     0.150
    67.714   656.715     0.150
    67.714  2357.814     0.150
    67.774   658.295     0.150
    67.946   659.025     0.150
    68.511   663.125     0.150
    68.584   663.506     0.150
    68.609   662.416     0.150
    68.719   664.336     0.150
    68.929   666.336     0.150
    68.982   665.846     0.150
    69.150   666.965     0.150
    69.450   667.615     0.150
    69.459   667.416     0.150
    69.633   669.715     0.150
    69.796   671.605     0.150
    70.279   673.115     0.150
    70.625   675.484     0.150
    70.604   676.115     0.150
    71.034   677.615     0.150
    71.065   675.715     0.150
    71.055   677.215     0.150
    71.059   678.516     0.150
    71.193   679.275     0.150
    71.193     6.699     0.150
    71.375   679.416     0.150
    71.305   679.314     0.150
    71.414   680.645     0.150
    71.414     7.102     0.150
    71.639   681.416     0.150
    71.639   681.285     0.150
    71.663   681.695     0.150
    71.711   681.516     0.150
    71.829   682.615     0.150
    71.832   682.516     0.150
    71.878   682.955     0.150
    71.858   683.016     0.150
    72.053   684.404     0.150
    72.053     6.621     0.150
    72.255   684.465     0.150
    72.400   686.025     0.150
    72.592   687.516     0.150
    72.655   687.715     0.150
    72.809   688.064     0.150
    72.809     7.750     0.150
    73.261   690.955     0.150
    73.305   691.746     0.150
    73.430   692.475     0.150
    73.430     6.400     0.150
    73.477   692.516     0.150
    73.492   693.115     0.150
    73.539   692.105     0.150
    73.539     7.250     0.150
    73.581   692.225     0.150
    73.612   692.766     0.150
    73.640   692.455     0.150
    73.580   693.016     0.150
    73.744   694.215     0.150
    74.113   696.115     0.150
    74.226   696.115     0.150
    74.226   865.115     0.150
    74.280   697.404     0.150
    74.329   697.166     0.150
    74.319   697.885     0.150
    74.319     6.701     0.150
    74.467   697.314     0.150
    74.467     7.602     0.150
    74.622   700.115     0.150
    74.648   700.115     0.150
    74.662   699.115     0.150
    74.700   698.615     0.150
    74.700  2347.314     0.150
    74.748   699.996     0.150
    74.721   700.314     0.150
    74.753   700.115     0.150
    74.724   699.016     0.150
    74.724     7.900     0.150
    74.954   701.615     0.150
    74.953   699.715     0.150
    75.033   702.615     0.150
    75.033  1280.115     0.150
    75.055   702.115     0.150
    75.152   703.115     0.150
    75.135   701.586     0.150
    75.135     7.350     0.150
    75.232   703.814     0.150
    75.289   702.734     0.150
    75.289     7.201     0.150
    75.271   703.115     0.150
    75.419   703.455     0.150
    75.419     8.199     0.150
    75.455   703.814     0.150
    75.455     7.701     0.150
    75.480   704.016     0.150
    75.480     7.799     0.150
    75.760   706.115     0.150
    76.000   707.266     0.150
    76.000     7.299     0.150
    76.129   708.615     0.150
    76.152   708.715     0.150
    76.168   708.314     0.150
    76.304   709.314     0.150
    76.323   709.215     0.150
    76.322   708.115     0.150
    76.408   709.215     0.150
    76.567   710.715     0.150
    77.007   712.215     0.150
    77.140   714.115     0.150
    77.129   714.016     0.150
    77.042   712.115     0.150
    77.218   714.215     0.150
    77.529   715.336     0.150
    77.527   714.615     0.150
    77.527  1859.014     0.150
    77.527  2341.217     0.150
    77.535   714.814     0.150
    77.535     8.201     0.150
    77.740   716.016     0.150
    77.752   717.516     0.150
    77.752     7.500     0.150
    77.911   717.916     0.150
    77.987   718.215     0.150
    77.987     8.100     0.150
    78.098   718.016     0.150
    78.272   719.615     0.150
    78.536   721.115     0.150
    78.736   722.516     0.150
    78.741   721.715     0.150
    78.815   722.016     0.150
    78.878   722.916     0.150
    78.878   731.314     0.150
    79.174   722.916     0.150
    79.174     8.000     0.150
    79.201   723.916     0.150
    79.201  1853.814     0.150
    79.680   727.416     0.150
    79.680   735.016     0.150
    79.727   727.516     0.150
    79.780   727.564     0.150
    79.916   728.215     0.150
    79.927   728.314     0.150
    80.163   728.916     0.150
    80.278   730.516     0.150
    80.278   737.615     0.150
    80.413   730.795     0.150
    80.455   731.016     0.150
    80.673   732.916     0.150
    80.755   733.314     0.150
    80.755   740.814     0.150
    81.080   733.416     0.150
    81.080   740.715     0.150
    81.201   734.615     0.150
    81.088   733.416     0.150
    81.088   733.814     0.150
    81.088   741.615     0.150
    81.397   737.016     0.150
    81.539   737.715     0.150
    81.539     6.900     0.150
    82.402   741.615     0.150
    82.556   742.615     0.150
    82.875   743.215     0.150
    82.982   743.516     0.150
    82.982     8.299     0.150
    83.087   744.215     0.150
    83.087     7.701     0.150
    83.113   745.314     0.150
    83.113   752.715     0.150
    83.767   748.916     0.150
    83.857   748.516     0.150
    83.857     6.799     0.150
    83.923   748.215     0.150
    83.923     7.600     0.150
    84.762   753.615     0.150
    84.793   753.615     0.150
    84.946   754.115     0.150
    85.183   756.016     0.150
    85.183     6.900     0.150
    85.190   755.314     0.150
    85.661   757.814     0.150
    85.661     7.602     0.150
    85.855   759.115     0.150
    86.210   759.916     0.150
    86.210     7.398     0.150
    86.341   760.416     0.150
    86.602   762.115     0.150
    86.602   962.516     0.150
    86.997   763.416     0.150
    86.997   763.314     0.150
    87.346   765.314     0.150
    87.664   766.814     0.150
    87.664     8.602     0.150
    87.700   767.115     0.150
    87.825   768.016     0.150
    88.864   773.115     0.150
    88.864     7.500     0.150
    88.907   773.715     0.150
    88.907  1832.314     0.150
    88.907  2320.717     0.150
    88.998   773.516     0.150
    88.998     7.600     0.150
    89.200   774.436     0.150
    89.200     6.699     0.150
    89.200  1826.717     0.150
    89.200   774.215     0.150
    89.269   776.916     0.150
    89.299   777.314     0.150
    89.516   776.916     0.150
    90.297   779.416     0.150
    90.438   780.416     0.150
    90.438     7.699     0.150
    90.565   780.615     0.150
    90.565   780.115     0.150
    92.525   793.115     0.150
    94.625   801.314     0.150
    94.625     7.400     0.150
    95.624   805.016     0.150
    95.624     6.600     0.150
    98.159   814.805     0.150
   100.286   824.615     0.150
   100.286  1801.514     0.150
   100.389   825.936     0.150
   100.496   826.195     0.150
   100.755   827.285     0.150
   106.115   856.115     0.150
   112.801  1115.516     0.150
   122.070  1132.516     0.150
   122.070  1132.215     0.150
   123.369  1133.115     0.150
   123.369  1141.115     0.150
   129.171  1146.416     0.150
   129.171  1146.016     0.150
   135.129  1158.314     0.150
   136.060  1159.115     0.150
   137.510  1164.215     0.150
   137.522  1162.814     0.150
   140.244  1168.314     0.150
   140.244  1344.115     0.150
   141.385  1171.016     0.150
   145.310  1174.516     0.150
   145.310  1381.115     0.150
   145.880  1176.115     0.150
   146.156  1179.916     0.150
   146.417  1179.314     0.150
   147.184  1182.715     0.150
   148.690  1182.916     0.150
   149.723  1183.314     0.150
   149.723  1188.016     0.150
   151.890  1185.715     0.150
   151.890  1192.115     0.150
   151.890  1200.115     0.150
   151.890  1406.115     0.150
   152.107  1193.314     0.150
   152.394  1188.715     0.150
   155.178  1192.115     0.150
   155.275  1192.615     0.150
   155.314  1192.615     0.150
   155.466  1192.314     0.150
   155.587  1193.115     0.150
   155.704  1192.615     0.150
   158.600  1194.115     0.150
   164.287  1199.715     0.150
   164.287  1256.215     0.150
   164.287  1478.814     0.150
     0.192     4.152     0.150
     0.192     8.353     0.150
     0.558    10.353     0.150
     0.558    19.252     0.150
     0.734    12.952     0.150
     1.113    20.152     0.150
     1.113    35.152     0.150
     1.113    19.952     0.150
     1.390    25.353     0.150
     1.970    32.152     0.150
     1.970    32.353     0.150
     1.970    58.252     0.150
     2.054    34.252     0.150
     2.054    62.053     0.150
     3.000    48.053     0.150
     3.495    52.952     0.150
     3.495    62.952     0.150
     3.516    55.053     0.150
     3.516   108.053     0.150
     4.244    63.252     0.150
     4.244    75.752     0.150
     4.244   130.252     0.150
     4.769    72.053     0.150
     4.769   147.053     0.150
     4.836    72.152     0.150
     4.836   150.152     0.150
     4.836   124.252     0.150
     4.836   150.353     0.150
     5.207    95.652     0.150
     5.207   161.152     0.150
     6.026    87.353     0.150
     6.026   185.652     0.150
     6.026    88.053     0.150
     6.026   155.652     0.150
     6.026   186.053     0.150
     6.476   201.452     0.150
     6.698   170.152     0.150
     6.698   205.353     0.150
     7.089   102.252     0.150
     7.089   220.053     0.150
     7.823   113.152     0.150
     7.823   197.053     0.150
     7.935   114.152     0.150
     7.935   203.553     0.150
     7.935   202.652     0.150
     8.025   117.152     0.150
     8.025   202.353     0.150
     8.331   117.952     0.150
    10.778   151.952     0.150
    15.038   216.853     0.150
    16.362   230.152     0.150
    16.809   409.353     0.150
    19.821   270.152     0.150
    20.845   281.652     0.150
    20.845   301.152     0.150
    22.231   296.152     0.150
    24.571   320.952     0.150
    45.336   496.853     0.150
    47.798   514.252     0.150
    75.355   700.952     0.150
    81.649   734.652     0.150
     0.127     2.219     0.150
     0.127     2.320     0.150
     0.127     3.922     0.150
     0.374     6.523     0.150
     0.374    11.523     0.150
     0.899    16.422     0.150
     0.899    28.422     0.150
     1.150    21.320     0.150
     1.150    37.320     0.150
     1.150    20.922     0.150
     1.150    36.922     0.150
     1.206    23.023     0.150
     1.206    38.422     0.150
     1.309    23.617     0.150
     2.165    39.117     0.150
     2.165    67.117     0.150
     2.165    36.719     0.150
     2.165    39.320     0.150
     2.216    38.422     0.150
     2.216    70.617     0.150
     2.218    38.719     0.150
     2.218    69.820     0.150
     2.591    46.219     0.150
     2.591    73.523     0.150
     2.591    81.320     0.150
     3.413    55.523     0.150
     3.413    62.523     0.150
     3.413    95.320     0.150
     3.413   105.922     0.150
     3.684    59.023     0.150
     3.684    67.117     0.150
     3.684    99.422     0.150
     3.684   115.117     0.150
     3.684    59.219     0.150
     3.684    69.023     0.150
     4.134    75.617     0.150
     4.134   129.820     0.150
     4.134   130.023     0.150
     4.571    70.719     0.150
     4.571    82.320     0.150
     4.571   141.820     0.150
     4.571    70.617     0.150
     4.571   141.617     0.150
     4.831    86.719     0.150
     4.831   149.219     0.150
     4.922    75.820     0.150
     4.922   130.023     0.150
     4.922   154.023     0.150
     5.831   179.617     0.150
     6.335   198.023     0.150
     6.503   199.719     0.150
     6.898   179.320     0.150
     6.898   214.219     0.150
     7.625   142.219     0.150
     7.625   236.422     0.150
     7.746   114.617     0.150
     7.746   197.523     0.150
     7.746   240.320     0.150
     0.026     3.516     0.150
     0.026     3.016     0.150
     0.026     4.219     0.150
     0.389     7.414     0.150
     0.389    13.117     0.150
     0.910    16.719     0.150
     0.910    29.617     0.150
     1.227    39.516     0.150
     1.288    23.414     0.150
     1.288    40.914     0.150
     1.294    23.719     0.150
     1.294    41.820     0.150
     1.294    23.516     0.150
     1.294    40.617     0.150
     2.104    37.219     0.150
     2.104    63.414     0.150
     2.104    34.516     0.150
     2.104    36.914     0.150
     2.104    60.617     0.150
     2.104    63.617     0.150
     2.230    36.617     0.150
     2.230    39.719     0.150
     2.230    70.516     0.150
     2.231    36.617     0.150
     2.231    39.617     0.150
     2.231    68.617     0.150
     2.665    43.117     0.150
     2.665    46.320     0.150
     2.665    81.820     0.150
     3.453    54.016     0.150
     3.453    60.914     0.150
     3.453   106.719     0.150
     3.692    57.320     0.150
     3.692    65.516     0.150
     3.692   114.719     0.150
     3.692   114.617     0.150
     4.237    64.320     0.150
     4.237   132.617     0.150
     4.237    63.617     0.150
     4.237    75.617     0.150
     4.237   131.820     0.150
     4.613    81.617     0.150
     4.613   142.016     0.150
     4.613    69.914     0.150
     4.613    81.414     0.150
     4.613   123.219     0.150
     4.613   143.219     0.150
     4.983    74.016     0.150
     4.983    88.117     0.150
     4.983   155.320     0.150
     5.062   156.617     0.150
     5.863   151.320     0.150
     5.863   179.820     0.150
     5.898    86.117     0.150
     5.898   150.719     0.150
     5.898   181.117     0.150
     6.434   116.820     0.150
     6.434   199.016     0.150
     6.434   200.914     0.150
     6.536   166.219     0.150
     6.536    97.320     0.150
     6.536   167.117     0.150
     6.536   201.016     0.150
     6.921    99.617     0.150
     7.668   111.820     0.150
     7.668   196.414     0.150
     7.668   237.617     0.150
     7.764   113.617     0.150
     7.764   196.719     0.150
     7.764   197.117     0.150
     7.764   240.617     0.150
     7.850   197.414     0.150
     7.850   114.320     0.150
     7.850   197.219     0.150
     7.850   243.617     0.150
    16.801   234.617     0.150
     0.150     4.082     0.150
     0.150     7.082     0.150
     0.190     4.082     0.150
     0.625    12.281     0.150
     0.625    20.480     0.150
     1.177    21.281     0.150
     1.177    37.480     0.150
     1.490    26.582     0.150
     1.490    45.781     0.150
     1.490    26.480     0.150
     1.724    29.680     0.150
     1.724    30.281     0.150
     1.724    52.980     0.150
     1.952    32.680     0.150
     1.952    34.281     0.150
     1.952    60.480     0.150
     2.432    42.980     0.150
     2.432    74.879     0.150
     2.432    40.582     0.150
     2.432    75.480     0.150
     3.299    50.980     0.150
     3.299    58.281     0.150
     3.299   102.680     0.150
     3.888    59.980     0.150
     3.888   121.879     0.150
     3.888    68.781     0.150
     3.888   103.879     0.150
     3.888   121.680     0.150
     4.093   126.582     0.150
     4.093   106.980     0.150
     4.093   128.980     0.150
     4.361    67.480     0.150
     4.361    77.680     0.150
     4.361   114.480     0.150
     4.361   134.082     0.150
     5.500   171.582     0.150
     5.587   173.480     0.150
     6.470   118.980     0.150
     6.470   201.680     0.150
     6.811   211.281     0.150
     7.468   228.082     0.150
     8.528   265.180     0.150
     0.167     4.660     0.150
     0.167     8.461     0.150
     0.654    12.461     0.150
     0.654    21.160     0.150
     0.862    27.160     0.150
     1.179    20.559     0.150
     1.179    36.660     0.150
     1.414    25.059     0.150
     1.414    44.859     0.150
     1.763    29.359     0.150
     1.763    52.059     0.150
     1.719    29.461     0.150
     1.719    30.359     0.150
     1.719    53.160     0.150
     2.120    34.859     0.150
     2.120    37.660     0.150
     2.120    60.660     0.150
     2.120    65.262     0.150
     2.887    45.559     0.150
     2.887    51.660     0.150
     2.887    89.160     0.150
     3.095    47.859     0.150
     3.095    55.059     0.150
     3.095    94.961     0.150
     4.100    71.859     0.150
     4.100   108.961     0.150
     4.100   125.961     0.150
     4.099    62.559     0.150
     4.099    73.762     0.150
     4.099   127.262     0.150
     4.183    62.859     0.150
     4.183   109.559     0.150
     4.183   129.461     0.150
     5.101   159.359     0.150
     5.103   159.359     0.150
     5.247    94.859     0.150
     5.247   163.461     0.150
     5.381   167.762     0.150
     5.835   181.762     0.150
     6.438   165.160     0.150
     6.438   202.160     0.150
     6.537   200.762     0.150
     6.545   203.160     0.150
     7.206   127.961     0.150
     7.206   221.262     0.150
     7.637   137.359     0.150
     7.637   236.660     0.150
     8.286   258.359     0.150
     8.500   263.762     0.150
     8.635   125.461     0.150
     8.635   217.160     0.150
     8.635   266.559     0.150
     0.221     5.432     0.150
     0.221     9.632     0.150
     0.163     3.932     0.150
     0.163     7.231     0.150
     1.168    21.432     0.150
     1.168    37.731     0.150
     1.135    20.831     0.150
     1.135    36.632     0.150
     2.261    39.331     0.150
     2.261    67.831     0.150
     2.261    36.831     0.150
     2.261    38.831     0.150
     2.261    63.031     0.150
     2.387    42.231     0.150
     2.387    67.632     0.150
     2.527    41.331     0.150
     2.527    44.731     0.150
     2.527    78.231     0.150
     3.199    50.231     0.150
     3.199    56.632     0.150
     3.199    99.531     0.150
     3.288    52.031     0.150
     3.288    58.932     0.150
     3.288   101.531     0.150
     3.853    69.231     0.150
     3.853    59.432     0.150
     3.853   119.531     0.150
     4.189    75.731     0.150
     4.189   128.231     0.150
     4.189    63.531     0.150
     4.189    75.031     0.150
     4.189   130.331     0.150
     4.433    67.132     0.150
     4.433    79.432     0.150
     4.433   117.031     0.150
     4.433   136.831     0.150
     4.434    67.132     0.150
     4.434    77.432     0.150
     4.434    79.432     0.150
     4.434   117.031     0.150
     4.434   136.831     0.150
     4.448    79.731     0.150
     4.448   137.932     0.150
     4.448    67.632     0.150
     4.448    80.132     0.150
     4.448   117.632     0.150
     4.448   136.932     0.150
     4.744    70.231     0.150
     4.744    85.132     0.150
     4.744   146.731     0.150
     5.094    91.231     0.150
     5.094    75.731     0.150
     5.094   131.331     0.150
     5.094   157.731     0.150
     5.164    77.932     0.150
     5.164    93.331     0.150
     5.164   160.831     0.150
     5.481   167.831     0.150
     5.695    83.831     0.150
     5.695   175.731     0.150
     5.695    84.132     0.150
     5.695   101.731     0.150
     5.695   147.632     0.150
     5.733    84.132     0.150
     5.733   102.231     0.150
     5.733   148.731     0.150
     5.733   176.231     0.150
     6.354   115.731     0.150
     6.354   115.132     0.150
     6.354   197.331     0.150
     6.369    92.632     0.150
     6.369   196.031     0.150
     6.369   114.231     0.150
     6.369   161.731     0.150
     6.369   195.432     0.150
     6.752   120.932     0.150
     6.752    97.731     0.150
     6.752   172.432     0.150
     6.752   209.031     0.150
     7.503   109.331     0.150
     7.503   231.432     0.150
     7.503   109.031     0.150
     7.503   135.031     0.150
     7.595   111.432     0.150
     7.595   195.031     0.150
     7.595   111.132     0.150
     7.595   192.731     0.150
     7.595   233.731     0.150
     7.684   137.831     0.150
     7.684   111.831     0.150
     7.684   193.932     0.150
     8.414   119.531     0.150
     8.414   209.531     0.150
    16.045   228.231     0.150
    20.292   274.406     0.150
    21.002   279.231     0.150
    23.843   567.231     0.150
    37.392   429.932     0.150
    37.962   434.869     0.150
    41.199   462.531     0.150
    41.650   466.132     0.150
    45.632   499.231     0.150
    47.618   513.432     0.150
    47.618   513.882     0.150
    56.482   578.276     0.150
     0.222     5.117     0.150
     0.222     9.318     0.150
     0.222     9.018     0.150
     0.416     8.717     0.150
     0.416     8.818     0.150
     0.416    15.318     0.150
     1.368    42.018     0.150
     1.368    24.717     0.150
     1.368    42.617     0.150
     1.025    18.617     0.150
     1.025    33.318     0.150
     1.025    18.318     0.150
     1.025    33.117     0.150
     1.295    22.518     0.150
     1.295    23.117     0.150
     1.946    33.018     0.150
     1.946    57.918     0.150
     1.946    32.318     0.150
     1.946    33.418     0.150
     1.946    56.217     0.150
     1.946    58.918     0.150
     2.236    37.217     0.150
     2.236    39.318     0.150
     2.236    64.018     0.150
     2.236    69.117     0.150
     2.835    51.418     0.150
     2.835    88.918     0.150
     2.835    45.117     0.150
     2.835    50.918     0.150
     2.835    87.617     0.150
     3.024    55.117     0.150
     3.024    81.818     0.150
     3.024    94.617     0.150
     3.985    71.818     0.150
     3.985   124.117     0.150
     3.985    60.617     0.150
     3.985    71.717     0.150
     3.985   122.918     0.150
     3.884    70.117     0.150
     3.884   121.717     0.150
     3.884    59.018     0.150
     3.884   103.918     0.150
     3.884   121.018     0.150
     4.098    73.617     0.150
     4.098   125.518     0.150
     4.098    62.518     0.150
     4.098    71.518     0.150
     4.098    73.418     0.150
     4.098   126.018     0.150
     5.042    75.418     0.150
     5.042    83.918     0.150
     5.042   154.918     0.150
     5.044    75.418     0.150
     5.044   154.918     0.150
     5.233   161.617     0.150
     5.233    78.318     0.150
     5.774    85.518     0.150
     5.774    93.518     0.150
     5.774   179.518     0.150
     6.242    90.818     0.150
     6.242   113.818     0.150
     6.242   160.617     0.150
     6.242   192.818     0.150
     7.204   221.217     0.150
     7.650   108.143     0.150
     7.650   192.145     0.150
     7.650   236.094     0.150
     7.657   110.217     0.150
     8.258   121.617     0.150
     8.258   147.918     0.150
     8.258   256.717     0.150
     8.529   124.418     0.150
     8.529   216.617     0.150
     8.529   262.617     0.150
     8.697   125.117     0.150
     8.697   219.117     0.150
     8.697   268.217     0.150
    12.931   183.818     0.150
    15.988   222.244     0.150
    16.566   235.418     0.150
    20.419   278.018     0.150
    21.352   287.357     0.150
    38.701   441.840     0.150
    42.540   474.174     0.150
    42.540     8.395     0.150
    45.072     6.500     0.150
    45.072    12.102     0.150
    46.742   513.693     0.150
    77.579   713.422     0.150
    77.579   720.451     0.150
    81.127   733.418     0.150
     0.115     2.740     0.150
     0.115     5.240     0.150
     0.162     2.941     0.150
     0.162     5.340     0.150
     0.558    10.240     0.150
     0.558    18.441     0.150
     0.955    17.740     0.150
     1.256    22.941     0.150
     1.256    39.941     0.150
     1.355    24.740     0.150
     1.355    25.941     0.150
     1.355    43.041     0.150
     1.731    31.541     0.150
     1.731    32.340     0.150
     1.731    55.041     0.150
     1.731    31.340     0.150
     1.731    54.240     0.150
     1.820    31.740     0.150
     1.820    55.941     0.150
     1.820    32.240     0.150
     1.820    56.441     0.150
     2.199    38.340     0.150
     2.199    40.641     0.150
     2.199    38.141     0.150
     2.199    39.840     0.150
     2.199    69.240     0.150
     2.828    51.441     0.150
     2.828    88.641     0.150
     2.828    46.541     0.150
     2.828    51.340     0.150
     2.828    79.641     0.150
     3.094    55.840     0.150
     3.094    96.740     0.150
     3.094    50.041     0.150
     3.094    56.240     0.150
     3.094    85.740     0.150
     3.094    96.441     0.150
     3.882    60.641     0.150
     3.882    69.840     0.150
     3.882   104.141     0.150
     3.882   119.740     0.150
     4.021    72.240     0.150
     4.021   125.641     0.150
     4.021    61.340     0.150
     4.021    72.041     0.150
     4.021   107.641     0.150
     4.021   125.340     0.150
     4.074    63.141     0.150
     4.074    73.740     0.150
     4.074   110.141     0.150
     4.074   127.340     0.150
     4.074    62.541     0.150
     4.074    73.941     0.150
     4.074   109.641     0.150
     4.074   126.441     0.150
     4.131    63.641     0.150
     4.131    74.240     0.150
     4.131   127.541     0.150
     5.273   161.541     0.150
     6.371   117.041     0.150
     6.371   165.740     0.150
     6.371   198.840     0.150
     6.563   203.340     0.150
     7.238   222.141     0.150
     7.679   235.641     0.150
     8.695   127.840     0.150
     8.695   224.041     0.150
     8.695   126.641     0.150
     8.695   220.840     0.150
     8.695   269.041     0.150
     0.175     7.188     0.150
     0.175     4.086     0.150
     0.175     7.387     0.150
     0.483     9.488     0.150
     0.483    16.789     0.150
     0.548     9.488     0.150
     1.100    34.988     0.150
     1.100    19.688     0.150
     1.100    35.387     0.150
     1.305    22.988     0.150
     1.305    40.789     0.150
     1.305    40.988     0.150
     1.518    26.988     0.150
     1.518    27.188     0.150
     1.518    47.887     0.150
     1.524    27.789     0.150
     1.524    48.586     0.150
     2.206    35.688     0.150
     2.206    38.188     0.150
     2.206    63.086     0.150
     2.206    66.586     0.150
     2.206    36.289     0.150
     2.206    63.289     0.150
     2.206    66.789     0.150
     2.226    39.387     0.150
     2.226    37.688     0.150
     2.226    39.488     0.150
     2.226    65.988     0.150
     2.226    69.789     0.150
     2.828    49.988     0.150
     2.828    86.887     0.150
     2.828    45.488     0.150
     2.828    49.887     0.150
     2.828    80.289     0.150
     2.828    87.887     0.150
     2.962    53.188     0.150
     2.962    91.887     0.150
     2.962    47.887     0.150
     2.962    52.488     0.150
     3.625    56.688     0.150
     3.625    64.289     0.150
     3.625    97.188     0.150
     3.625   111.988     0.150
     3.625    56.789     0.150
     3.625   112.488     0.150
     3.641    64.289     0.150
     3.641    97.488     0.150
     3.641   111.789     0.150
     3.926    60.387     0.150
     3.926    70.387     0.150
     3.926   121.789     0.150
     3.926    70.488     0.150
     3.926   121.988     0.150
     3.954    60.789     0.150
     3.954    71.086     0.150
     3.954   121.688     0.150
     3.954    69.988     0.150
     3.954   105.789     0.150
     3.954   122.188     0.150
     4.852    73.086     0.150
     4.852   129.387     0.150
     4.852   150.988     0.150
     5.077    75.789     0.150
     5.077    89.586     0.150
     5.077   134.289     0.150
     5.077   156.086     0.150
     5.355   140.086     0.150
     5.355   166.488     0.150
     5.401   167.586     0.150
     5.580    82.387     0.150
     5.580   144.688     0.150
     5.580   174.086     0.150
     6.361   162.789     0.150
     6.361   196.789     0.150
     6.405   197.688     0.150
     7.526   111.086     0.150
     7.526   191.887     0.150
     8.407   123.488     0.150
     8.407   212.086     0.150
     8.407   214.586     0.150
     8.606   125.289     0.150
     8.606   218.488     0.150
     8.606   266.188     0.150
     0.046     3.700     0.150
     0.046     3.101     0.150
     0.422     8.101     0.150
     0.422    14.601     0.150
     0.422    14.801     0.150
     0.960    31.700     0.150
     0.982    18.900     0.150
     0.982    31.700     0.150
     1.216    22.400     0.150
     1.216    39.101     0.150
     1.216    38.900     0.150
     1.216    41.801     0.150
     1.324    23.900     0.150
     1.324    42.101     0.150
     1.324    23.700     0.150
     1.324    42.501     0.150
     2.072    34.001     0.150
     2.072    60.501     0.150
     2.072    35.801     0.150
     2.072    60.400     0.150
     2.072    62.801     0.150
     2.201    36.400     0.150
     2.201    39.400     0.150
     2.201    68.601     0.150
     2.694    44.101     0.150
     2.694    49.101     0.150
     2.694    84.101     0.150
     3.486    54.601     0.150
     3.486    62.200     0.150
     3.486    94.801     0.150
     3.486   107.801     0.150
     3.662    57.001     0.150
     3.662    65.501     0.150
     3.662   114.400     0.150
     3.662    56.501     0.150
     3.662   113.700     0.150
     4.250    63.900     0.150
     4.250    76.101     0.150
     4.250   134.501     0.150
     4.250   131.501     0.150
     4.618    70.200     0.150
     4.618   142.501     0.150
     4.646    69.900     0.150
     4.646   144.001     0.150
     4.964    73.900     0.150
     4.964   155.200     0.150
     4.964   128.001     0.150
     4.964   153.501     0.150
     5.058   155.700     0.150
     5.350    80.200     0.150
     5.350   165.101     0.150
     5.931    86.601     0.150
     5.931   152.400     0.150
     5.931   183.400     0.150
     6.953   176.501     0.150
     7.796   114.200     0.150
     7.796   113.400     0.150
     7.796   197.700     0.150
     7.881   116.601     0.150
     7.881   199.700     0.150
     7.881   115.501     0.150
     7.881   199.900     0.150
    10.907   153.700     0.150
    20.482   276.200     0.150
     0.172     3.996     0.150
     0.172     7.699     0.150
     0.216     5.098     0.150
     0.216     4.496     0.150
     0.216     8.098     0.150
     1.073    19.398     0.150
     1.073    34.297     0.150
     1.073    19.098     0.150
     1.073    33.398     0.150
     1.154    21.297     0.150
     1.154    21.098     0.150
     1.201    20.996     0.150
     1.201    39.699     0.150
     1.217    22.699     0.150
     1.217    38.898     0.150
     1.369    24.996     0.150
     1.369    43.699     0.150
     1.369    24.797     0.150
     1.369    42.398     0.150
     2.302    66.297     0.150
     2.302    37.699     0.150
     2.302    38.797     0.150
     2.302    40.496     0.150
     2.302    65.297     0.150
     2.449    76.098     0.150
     2.449    40.199     0.150
     2.449    44.496     0.150
     2.449    69.398     0.150
     2.501    44.797     0.150
     2.501    77.797     0.150
     2.501    41.199     0.150
     2.501    77.898     0.150
     3.241    58.297     0.150
     3.241    99.699     0.150
     3.241    50.797     0.150
     3.241    57.797     0.150
     3.241    88.898     0.150
     3.241    99.598     0.150
     3.914    60.098     0.150
     3.914   121.496     0.150
     4.203   130.797     0.150
     4.203    63.297     0.150
     4.203   130.598     0.150
     4.271    64.699     0.150
     4.271    75.898     0.150
     4.271   132.898     0.150
     4.401    78.098     0.150
     4.401   135.496     0.150
     4.401    66.297     0.150
     4.401   115.398     0.150
     4.401   135.297     0.150
     4.396    66.699     0.150
     4.396   116.496     0.150
     4.396   135.797     0.150
     4.826    72.297     0.150
     4.826   148.398     0.150
     4.860    73.199     0.150
     4.860   126.898     0.150
     4.860   150.598     0.150
     4.862    72.598     0.150
     4.862   126.598     0.150
     4.862   149.297     0.150
     5.154   161.098     0.150
     5.154    76.398     0.150
     5.154   133.297     0.150
     5.154   159.898     0.150
     5.643    84.297     0.150
     5.643   147.496     0.150
     5.643   174.199     0.150
     5.643    82.797     0.150
     5.643   144.898     0.150
     5.643   173.098     0.150
     5.684    83.199     0.150
     5.684   147.297     0.150
     5.684   174.996     0.150
     6.317    91.898     0.150
     6.317   193.098     0.150
     6.317    90.898     0.150
     6.317   162.398     0.150
     6.317   194.199     0.150
     6.355    92.598     0.150
     6.355    92.297     0.150
     6.355   196.398     0.150
     6.698    97.297     0.150
     6.698   171.898     0.150
     6.698   206.297     0.150
     7.456   108.098     0.150
     7.456   227.797     0.150
     7.456   108.199     0.150
     7.456   189.898     0.150
     7.456   228.797     0.150
     7.531   110.297     0.150
     7.539   110.797     0.150
     7.539   110.098     0.150
     7.539   123.797     0.150
     7.539   190.598     0.150
     7.624   111.297     0.150
     7.624   125.797     0.150
     7.624   193.297     0.150
     8.451   212.496     0.150
     8.451   120.172     0.150
     8.451   119.719     0.150
    10.046   142.098     0.150
    10.046   252.098     0.150
    11.157   155.598     0.150
    11.157   276.496     0.150
    11.157   155.328     0.150
    14.075   197.898     0.150
    15.175   212.898     0.150
    15.175   220.496     0.150
    15.377   215.863     0.150
    15.452   217.898     0.150
    15.984   222.398     0.150
    15.984   408.398     0.150
    16.228   226.598     0.150
    16.228   234.098     0.150
    16.228   513.199     0.150
    16.228   226.418     0.150
    16.265   232.199     0.150
    16.265   422.199     0.150
    16.299   229.398     0.150
    16.299   421.199     0.150
    16.299   229.297     0.150
    16.320   229.621     0.150
    16.320   421.020     0.150
    16.320   228.918     0.150
    17.346   439.699     0.150
    18.310   254.496     0.150
    18.327   255.098     0.150
    18.435   255.098     0.150
    18.435   466.098     0.150
    18.430   256.199     0.150
    19.423   266.598     0.150
    19.423   271.199     0.150
    19.423   272.598     0.150
    19.423   490.699     0.150
    19.423   508.199     0.150
    20.230   273.574     0.150
    20.230   504.023     0.150
    20.193   274.996     0.150
    20.193   506.598     0.150
    20.590   278.598     0.150
    20.590   283.098     0.150
    20.590   286.098     0.150
    20.590   505.098     0.150
    20.590   529.098     0.150
    20.590   744.098     0.150
    20.590   745.496     0.150
    20.590   510.098     0.150
    21.060   284.297     0.150
    21.060   299.496     0.150
    21.060   524.496     0.150
    21.060   283.699     0.150
    21.191   286.539     0.150
    21.364   288.398     0.150
    21.364   304.098     0.150
    21.364   539.098     0.150
    21.364   555.098     0.150
    21.364   287.770     0.150
    21.610   290.797     0.150
    21.647   290.770     0.150
    22.046   294.398     0.150
    22.046   544.199     0.150
    23.081   305.246     0.150
    23.081   547.898     0.150
    23.357   305.398     0.150
    23.782   310.496     0.150
    23.782   562.996     0.150
    23.782   310.348     0.150
    24.532   317.797     0.150
    24.525   320.398     0.150
    24.897   322.098     0.150
    25.395   599.098     0.150
    25.551   329.398     0.150
    25.551   599.098     0.150
    25.672   330.398     0.150
    25.672   599.199     0.150
    25.772   329.836     0.150
    25.853   330.598     0.150
    25.853   601.297     0.150
    26.473   337.770     0.150
    26.589   338.848     0.150
    26.603   335.699     0.150
    26.603   335.098     0.150
    26.730   339.227     0.150
    26.771   340.398     0.150
    26.894   342.719     0.150
    26.955   341.098     0.150
    27.124   344.719     0.150
    27.153   344.137     0.150
    27.171   342.488     0.150
    27.421   345.770     0.150
    27.529   347.496     0.150
    27.565   345.398     0.150
    27.565   622.098     0.150
    27.565   700.098     0.150
    28.555   355.496     0.150
    28.555   407.199     0.150
    28.555   545.598     0.150
    28.555   767.098     0.150
    28.615   357.598     0.150
    28.615   644.398     0.150
    28.779   356.398     0.150
    28.779   645.098     0.150
    28.779   727.098     0.150
    29.734   365.898     0.150
    29.734   664.199     0.150
    29.974   370.098     0.150
    29.974   370.398     0.150
    30.897   373.098     0.150
    31.488   381.398     0.150
    31.507   381.496     0.150
    31.507   442.398     0.150
    31.507   691.098     0.150
    31.507   774.398     0.150
    31.507   801.398     0.150
    31.507  1006.699     0.150
    31.507   442.297     0.150
    31.507   801.297     0.150
    31.507   774.297     0.150
    33.573   399.598     0.150
    33.619   400.996     0.150
    33.856   403.199     0.150
    33.922   403.797     0.150
    33.960   403.098     0.150
    33.971   404.496     0.150
    34.001   404.098     0.150
    34.086   405.297     0.150
    34.524   407.598     0.150
    34.548   409.496     0.150
    34.787   410.098     0.150
    34.998   410.898     0.150
    34.998   411.496     0.150
    35.447   413.996     0.150
    35.447   414.598     0.150
    35.447   745.496     0.150
    35.447   413.656     0.150
    36.007   417.496     0.150
    36.558   423.598     0.150
    36.917   427.469     0.150
    36.948   430.398     0.150
    36.948   513.496     0.150
    37.360   430.898     0.150
    37.436   777.098     0.150
    37.436   431.598     0.150
    37.462   432.598     0.150
    37.787   435.117     0.150
    37.930   435.234     0.150
    37.930   435.387     0.150
    38.026   438.898     0.150
    38.316   440.398     0.150
    38.663   443.629     0.150
    38.742   442.098     0.150
    39.465   450.898     0.150
    39.465   450.746     0.150
    39.541   448.297     0.150
    39.541   545.996     0.150
    39.629   449.566     0.150
    39.629     4.703     0.150
    40.146   456.098     0.150
    40.385   455.598     0.150
    40.385   551.699     0.150
    40.385   577.098     0.150
    40.385   822.297     0.150
    40.385  1002.098     0.150
    40.733   458.797     0.150
    40.733   557.199     0.150
    40.733   827.199     0.150
    40.996   460.098     0.150
    40.996     7.602     0.150
    40.996   560.098     0.150
    41.158   461.898     0.150
    41.150   463.289     0.150
    41.150   835.348     0.150
    41.303   464.898     0.150
    41.303  1019.598     0.150
    41.608   465.797     0.150
    41.988   467.098     0.150
    41.988   565.098     0.150
    41.988   588.098     0.150
    41.988  1068.098     0.150
    42.400   474.977     0.150
    42.623   475.199     0.150
    42.623   475.496     0.150
    43.241   477.949     0.150
    43.612   482.309     0.150
    43.600   483.297     0.150
    43.726   484.098     0.150
    43.726   593.098     0.150
    43.726   873.098     0.150
    43.726  1067.098     0.150
    43.732   482.949     0.150
    43.732     6.387     0.150
    43.980   486.098     0.150
    43.980   487.496     0.150
    43.980   589.098     0.150
    43.980   877.598     0.150
    43.980  1076.797     0.150
    43.980   487.609     0.150
    44.088   488.098     0.150
    44.088   594.098     0.150
    44.088   879.098     0.150
    44.088  1065.098     0.150
    44.328   490.297     0.150
    44.328  1087.496     0.150
    44.751   489.777     0.150
    44.751     7.332     0.150
    44.859   492.098     0.150
    44.869   493.488     0.150
    44.869   601.797     0.150
    44.869   898.148     0.150
    45.289   497.699     0.150
    45.647   499.398     0.150
    45.673   499.098     0.150
    45.837   594.996     0.150
    45.837   606.996     0.150
    45.837  1096.398     0.150
    45.848   503.098     0.150
    46.249   504.898     0.150
    46.249   600.598     0.150
    46.249   910.297     0.150
    46.249  1113.098     0.150
    46.461   911.336     0.150
    46.649   507.297     0.150
    46.861   507.098     0.150
    46.959   508.598     0.150
    46.959   509.199     0.150
    47.289   511.797     0.150
    47.449   515.098     0.150
    47.581   513.098     0.150
    47.581   513.672     0.150
    47.678   514.867     0.150
    47.671   515.898     0.150
    47.831   515.547     0.150
    47.844   517.977     0.150
    47.844   518.539     0.150
    48.425   522.066     0.150
    48.425   948.348     0.150
    48.881   524.770     0.150
    49.116   527.438     0.150
    49.116   948.477     0.150
    49.116  1162.688     0.150
    49.116   527.297     0.150
    49.116   948.699     0.150
    49.109   524.609     0.150
    49.109   641.258     0.150
    49.109   955.898     0.150
    49.144   524.098     0.150
    49.239   527.098     0.150
    49.239   615.098     0.150
    49.239   952.098     0.150
    49.282   528.957     0.150
    49.370   528.918     0.150
    49.436   529.496     0.150
    49.436   957.699     0.150
    49.674   530.898     0.150
    49.674   645.297     0.150
    49.674   955.199     0.150
    49.674  1170.699     0.150
    49.752   533.598     0.150
    49.851   533.707     0.150
    50.011   533.367     0.150
    50.145   533.598     0.150
    50.145   965.098     0.150
    50.145  1186.297     0.150
    50.190   535.867     0.150
    50.420   536.648     0.150
    50.430   537.898     0.150
    50.770   654.098     0.150
    50.770   976.297     0.150
    50.770   539.297     0.150
    50.834   539.598     0.150
    51.067   541.598     0.150
    51.279   542.297     0.150
    51.358   544.098     0.150
    51.384  1197.098     0.150
    51.487   544.727     0.150
    51.487   548.008     0.150
    51.520   545.996     0.150
    51.520   986.398     0.150
    51.682   547.996     0.150
    51.722   546.598     0.150
    51.767   546.906     0.150
    51.789   546.996     0.150
    51.857   547.098     0.150
    51.909   547.379     0.150
    51.909   548.418     0.150
    52.216   552.398     0.150
    52.216   996.996     0.150
    52.411   552.297     0.150
    52.537   552.199     0.150
    52.537     6.000     0.150
    52.537   667.098     0.150
    52.537  1210.098     0.150
    52.731   553.289     0.150
    52.875   555.199     0.150
    52.875  1003.398     0.150
    52.875  1233.598     0.150
    52.959   557.496     0.150
    53.304   559.098     0.150
    53.431   559.098     0.150
    53.545   559.098     0.150
    53.556   559.297     0.150
    53.556  1232.098     0.150
    53.651   560.199     0.150
    53.651   627.098     0.150
    53.651  1013.098     0.150
    53.651  1235.098     0.150
    53.646   562.098     0.150
    53.891   562.199     0.150
    53.932  1018.699     0.150
    54.046   564.996     0.150
    54.282   565.699     0.150
    54.384   565.699     0.150
    54.385   565.098     0.150
    54.676  1026.898     0.150
    54.720   568.098     0.150
    54.735   567.996     0.150
    54.735  1031.098     0.150
    54.735  1255.098     0.150
    54.735   568.598     0.150
    54.782   568.598     0.150
    54.902   569.449     0.150
    54.987   570.496     0.150
    54.987  1029.898     0.150
    54.987  1263.996     0.150
    55.139   571.297     0.150
    55.142   571.109     0.150
    55.175   571.098     0.150
    55.431   572.746     0.150
    55.486   575.598     0.150
    55.611   574.797     0.150
    55.611     5.801     0.150
    55.611  1041.996     0.150
    55.611  1267.398     0.150
    55.611   574.797     0.150
    55.611     5.801     0.150
    55.611  1041.996     0.150
    55.611  1267.398     0.150
    55.621   574.996     0.150
    55.644   574.098     0.150
    55.769   575.770     0.150
    55.768   575.598     0.150
    56.078   577.297     0.150
    56.402   579.996     0.150
    56.484   581.598     0.150
    56.511   578.793     0.150
    56.520   581.699     0.150
    56.535   580.379     0.150
    56.570   582.367     0.150
    56.610   581.988     0.150
    56.612   582.598     0.150
    56.625   580.469     0.150
    56.717   582.898     0.150
    56.798   581.309     0.150
    56.841   582.598     0.150
    56.866   582.426     0.150
    56.953   583.598     0.150
    57.037   584.336     0.150
    57.037  1063.027     0.150
    57.037  1294.199     0.150
    57.039   584.797     0.150
    57.112   583.816     0.150
    57.161   585.066     0.150
    57.218   586.996     0.150
    57.245   587.199     0.150
    57.268   584.836     0.150
    57.269   584.988     0.150
    57.392   586.297     0.150
    57.422   588.297     0.150
    57.469   588.898     0.150
    57.481   588.898     0.150
    57.543   586.457     0.150
    57.617   589.398     0.150
    57.621   587.656     0.150
    57.631   587.609     0.150
    57.789   590.938     0.150
    57.866   590.398     0.150
    57.890   589.598     0.150
    57.890   590.297     0.150
    57.999   589.797     0.150
    58.009   593.199     0.150
    58.245   593.398     0.150
    58.278   592.199     0.150
    58.347   594.598     0.150
    58.378   593.797     0.150
    58.395   595.199     0.150
    58.411   594.699     0.150
    58.530   597.758     0.150
    58.612   596.598     0.150
    58.730   596.996     0.150
    58.771   597.398     0.150
    58.814   597.898     0.150
    58.908   598.699     0.150
    58.918   596.297     0.150
    58.927   598.199     0.150
    58.968   598.496     0.150
    58.969   597.797     0.150
    59.083   599.398     0.150
    59.148   598.297     0.150
    59.175   599.996     0.150
    59.290   600.699     0.150
    59.426   601.098     0.150
    59.477   601.996     0.150
    59.763   604.098     0.150
    59.804   604.598     0.150
    59.852   605.398     0.150
    60.020   605.199     0.150
    60.025   606.199     0.150
    60.070   605.879     0.150
    60.097   605.547     0.150
    60.153   606.098     0.150
    60.165   606.598     0.150
    60.163   607.297     0.150
    60.184   605.297     0.150
    60.231   606.977     0.150
    60.245   606.867     0.150
    60.260   607.199     0.150
    60.301   607.527     0.150
    60.321   606.426     0.150
    60.511   608.207     0.150
    60.629   610.066     0.150
    60.718   609.520     0.150
    60.767   609.996     0.150
    60.814   609.629     0.150
    61.055   610.617     0.150
    61.128   610.836     0.150
    61.204   611.699     0.150
    61.201   613.148     0.150
    61.205   611.719     0.150
    61.268   612.598     0.150
    61.275   615.496     0.150
    61.362   613.898     0.150
    61.382   613.148     0.150
    61.406   615.199     0.150
    61.494   614.027     0.150
    61.494   614.027     0.150
    61.503   614.688     0.150
    61.537   615.199     0.150
    61.595   615.797     0.150
    61.637   614.688     0.150
    61.645   616.898     0.150
    61.711   616.496     0.150
    61.746   615.797     0.150
    61.775   617.098     0.150
    61.846   617.297     0.150
    61.884   617.898     0.150
    61.951   618.496     0.150
    62.068   618.398     0.150
    62.077   618.797     0.150
    62.124   619.496     0.150
    62.124   619.496     0.150
    62.177   618.797     0.150
    62.407   619.797     0.150
    62.489   621.398     0.150
    62.518   622.098     0.150
    62.553   621.797     0.150
    62.576   621.199     0.150
    62.778   622.297     0.150
    62.795   622.598     0.150
    62.796   622.297     0.150
    62.919   623.297     0.150
    62.957   625.598     0.150
    63.017   625.199     0.150
    63.151   625.898     0.150
    63.235   625.297     0.150
    63.779   628.898     0.150
    64.449   634.199     0.150
    64.854   637.297     0.150
    65.239   640.098     0.150
    65.500   640.496     0.150
    65.865   645.258     0.150
    65.986   644.797     0.150
    66.088   644.496     0.150
    66.506   648.598     0.150
    66.556   651.047     0.150
    66.895   653.176     0.150
    66.916   652.148     0.150
    67.011   652.117     0.150
    67.263   653.637     0.150
    67.549   655.059     0.150
    67.627   657.508     0.150
    67.693   656.297     0.150
    68.075   659.398     0.150
    68.288   660.969     0.150
    68.333   660.656     0.150
    68.462   660.898     0.150
    68.483   660.699     0.150
    68.657   665.199     0.150
    69.215   665.789     0.150
    69.301   666.449     0.150
    69.374   667.098     0.150
    69.418   666.699     0.150
    69.501   666.172     0.150
    69.740   669.297     0.150
    69.882   670.098     0.150
    70.089   671.109     0.150
    70.089   671.609     0.150
    70.089   670.918     0.150
    70.236   672.797     0.150
    70.252   672.699     0.150
    70.697   674.527     0.150
    70.703   674.797     0.150
    70.800   675.199     0.150
    70.818   675.586     0.150
    70.932   676.398     0.150
    70.932  1233.398     0.150
    70.932  1508.996     0.150
    70.932   676.066     0.150
    71.071   679.539     0.150
    71.285   681.059     0.150
    71.286   680.297     0.150
    71.382   680.797     0.150
    71.698   679.121     0.150
    71.698   678.328     0.150
    72.191   683.598     0.150
    72.260   683.949     0.150
    72.299   686.617     0.150
    72.402   685.199     0.150
    72.481   685.066     0.150
    72.826   688.938     0.150
    72.835   688.066     0.150
    72.860   688.199     0.150
    73.013   689.156     0.150
    73.091   689.699     0.150
    73.096   689.309     0.150
    73.186   690.398     0.150
    73.414   691.098     0.150
    73.518   692.168     0.150
    73.850   694.199     0.150
    74.647   696.809     0.150
    74.753   699.898     0.150
    74.802   698.797     0.150
    75.231   702.207     0.150
    75.451   704.098     0.150
    75.668   703.297     0.150
    75.844   704.098     0.150
    76.160   707.348     0.150
    76.503   708.996     0.150
    76.883   711.598     0.150
    76.932   711.598     0.150
    77.077   713.098     0.150
    77.195   712.539     0.150
    77.572   714.996     0.150
    78.111   717.598     0.150
    78.111   716.656     0.150
    78.118   717.156     0.150
    78.812   723.176     0.150
    78.919   722.199     0.150
    79.506   725.898     0.150
    79.749   725.898     0.150
    79.882   728.977     0.150
    80.191   728.809     0.150
    80.217   730.496     0.150
    80.243   729.836     0.150
    80.387   730.699     0.150
    80.747   733.199     0.150
    80.876   733.219     0.150
    81.342   735.398     0.150
    81.342   734.598     0.150
    81.464   735.828     0.150
    81.643   736.449     0.150
    81.643   736.699     0.150
    81.819   738.168     0.150
    81.866   738.496     0.150
    81.892   737.797     0.150
    82.113   740.586     0.150
    82.113   740.219     0.150
    82.299   739.289     0.150
    82.634   742.367     0.150
    82.941   744.297     0.150
    83.342   745.059     0.150
    83.822   748.996     0.150
    83.995   749.496     0.150
    84.328   749.398     0.150
    84.888   754.656     0.150
    84.917   753.699     0.150
    84.962   755.098     0.150
    86.009   759.398     0.150
    86.397   763.359     0.150
    86.760   761.996     0.150
    87.429   765.098     0.150
    87.742   766.598     0.150
    87.847   767.508     0.150
    89.830   777.496     0.150
    89.886   778.098     0.150
    89.886   778.398     0.150
    91.260   783.398     0.150
    98.803   817.797     0.150
    98.904   817.398     0.150
    99.166   820.098     0.150
   128.448  1144.398     0.150
   128.448  1144.297     0.150
   128.448  1144.062     0.150
   132.855  1153.648     0.150
   140.342  1169.199     0.150
   140.342  1170.359     0.150
   144.289  1171.598     0.150
   145.780  1175.797     0.150
   145.836  1175.926     0.150
   145.836  1175.797     0.150
   149.080  1181.398     0.150
   149.080  1184.898     0.150
   149.080  1182.398     0.150
   149.080  1185.496     0.150
   149.230  1183.047     0.150
   149.230  1182.848     0.150
   149.230  1186.273     0.150
   149.230  1182.438     0.150
   150.503  1189.699     0.150
   150.503  1192.098     0.150
   150.782  1190.398     0.150
   150.782  1192.598     0.150
   151.248  1190.398     0.150
   151.248  1192.996     0.150
     0.144     3.379     0.150
     0.144     3.480     0.150
     0.144     6.180     0.150
     0.261     4.879     0.150
     0.261     9.777     0.150
     0.261     5.180     0.150
     1.024    18.480     0.150
     1.024    32.879     0.150
     1.147    20.879     0.150
     1.147    36.680     0.150
     1.251    23.480     0.150
     1.267    23.480     0.150
     1.267    40.777     0.150
     1.415    25.480     0.150
     1.415    44.480     0.150
     2.334    38.078     0.150
     2.334    39.980     0.150
     2.334    66.180     0.150
     2.334    70.777     0.150
     2.334    38.578     0.150
     2.334    41.480     0.150
     2.334    67.379     0.150
     2.334    71.277     0.150
     2.483    43.578     0.150
     2.483    77.480     0.150
     2.483    41.480     0.150
     2.483    44.578     0.150
     2.483    71.277     0.150
     2.483    77.879     0.150
     2.499    41.078     0.150
     2.499    44.879     0.150
     2.499    75.277     0.150
     2.499    41.180     0.150
     2.499    45.078     0.150
     2.499    77.680     0.150
     3.205    57.480     0.150
     3.205    98.277     0.150
     3.205    50.879     0.150
     3.205    89.180     0.150
     3.205    99.277     0.150
     3.963    61.480     0.150
     3.963    70.277     0.150
     3.963    61.379     0.150
     3.963    71.777     0.150
     3.963   106.578     0.150
     3.963   123.480     0.150
     4.218    75.578     0.150
     4.218   132.277     0.150
     4.218    64.180     0.150
     4.218   113.578     0.150
     4.218   130.680     0.150
     4.239   131.980     0.150
     4.365    76.777     0.150
     4.365   134.379     0.150
     4.365    66.379     0.150
     4.365   116.480     0.150
     4.365   133.578     0.150
     4.368    67.078     0.150
     4.368   117.078     0.150
     4.368   135.680     0.150
     4.795    72.078     0.150
     4.795   125.777     0.150
     4.795   146.980     0.150
     5.202    77.578     0.150
     5.202   161.180     0.150
     5.202    77.180     0.150
     5.202   134.480     0.150
     5.202   160.980     0.150
     5.603   173.480     0.150
     5.647    83.578     0.150
     5.647   146.879     0.150
     5.647   173.180     0.150
     6.278   192.480     0.150
     6.358   196.980     0.150
     6.358    93.777     0.150
     6.358   165.180     0.150
     6.358   198.180     0.150
     6.655    97.078     0.150
     6.655   171.879     0.150
     6.655   205.277     0.150
     7.420   229.777     0.150
     7.495   110.578     0.150
     7.495   189.879     0.150
     7.487   232.180     0.150
     7.577   110.680     0.150
     7.577   193.680     0.150
     9.615   296.680     0.150
     0.178     3.797     0.150
     0.178     7.195     0.150
     0.178     6.992     0.150
     0.236     4.695     0.150
     0.236     8.695     0.150
     0.236     5.094     0.150
     1.044    18.797     0.150
     1.044    32.992     0.150
     1.044    19.094     0.150
     1.044    33.391     0.150
     1.180    21.297     0.150
     1.180    37.695     0.150
     1.233    23.391     0.150
     1.251    23.391     0.150
     1.414    25.391     0.150
     1.414    44.391     0.150
     1.414    25.492     0.150
     2.301    37.695     0.150
     2.301    39.391     0.150
     2.301    68.391     0.150
     2.301    40.492     0.150
     2.301    68.992     0.150
     2.479    40.695     0.150
     2.479    43.797     0.150
     2.479    40.797     0.150
     2.479    44.594     0.150
     2.479    76.492     0.150
     2.517    41.992     0.150
     2.517    44.492     0.150
     2.517    78.297     0.150
     2.517    41.891     0.150
     2.517    44.594     0.150
     2.517    71.891     0.150
     2.517    78.492     0.150
     3.237    51.594     0.150
     3.237    58.594     0.150
     3.237   100.391     0.150
     3.237    51.492     0.150
     3.237    58.094     0.150
     3.237    88.594     0.150
     3.941    60.992     0.150
     3.941   122.391     0.150
     3.941   122.594     0.150
     4.243    63.391     0.150
     4.243    76.195     0.150
     4.243   130.891     0.150
     4.243    76.094     0.150
     4.243   131.797     0.150
     4.272   131.797     0.150
     4.397    65.695     0.150
     4.397    77.594     0.150
     4.397   116.297     0.150
     4.397   135.195     0.150
     4.397    66.695     0.150
     4.397   135.297     0.150
     4.402    67.297     0.150
     4.402   136.492     0.150
     4.829    73.195     0.150
     4.829   147.891     0.150
     5.196    77.391     0.150
     5.196   161.094     0.150
     5.196    77.195     0.150
     5.196   133.797     0.150
     5.196   160.992     0.150
     5.679    83.891     0.150
     5.679   173.891     0.150
     6.309   115.094     0.150
     6.309   195.094     0.150
     6.388   197.797     0.150
     6.684    96.695     0.150
     6.684   173.695     0.150
     6.684   207.594     0.150
     7.452   231.695     0.150
     7.468   229.992     0.150
     7.523   110.992     0.150
     7.523   111.195     0.150
     7.523   191.094     0.150
     7.523   231.797     0.150
     9.637   138.297     0.150
     9.637   296.195     0.150
     0.176     3.863     0.150
     0.176     7.762     0.150
     0.176     4.363     0.150
     0.224     4.465     0.150
     0.224     9.262     0.150
     0.224     5.062     0.150
     1.059    19.262     0.150
     1.059    34.164     0.150
     1.059    19.363     0.150
     1.170    21.465     0.150
     1.170    37.262     0.150
     1.170    37.562     0.150
     1.217    23.062     0.150
     1.217    39.965     0.150
     1.234    22.965     0.150
     1.234    39.664     0.150
     1.393    25.164     0.150
     1.393    43.965     0.150
     2.299    37.363     0.150
     2.299    39.664     0.150
     2.299    65.562     0.150
     2.299    69.363     0.150
     2.299    38.062     0.150
     2.299    40.762     0.150
     2.299    66.465     0.150
     2.464    40.363     0.150
     2.464    44.062     0.150
     2.464    76.562     0.150
     2.512    41.363     0.150
     2.512    44.363     0.150
     2.512    72.164     0.150
     2.512    78.562     0.150
     3.241    51.062     0.150
     3.241    58.164     0.150
     3.241    99.762     0.150
     3.241    51.465     0.150
     3.241    58.562     0.150
     3.241    88.363     0.150
     3.241   100.062     0.150
     3.927    60.863     0.150
     3.927    68.562     0.150
     3.927   122.262     0.150
     3.927    60.465     0.150
     3.927    70.762     0.150
     3.927   122.363     0.150
     4.226    75.562     0.150
     4.226   129.262     0.150
     4.226    64.262     0.150
     4.226   131.363     0.150
     4.274   133.863     0.150
     4.401    66.863     0.150
     4.401    78.762     0.150
     4.401   136.262     0.150
     4.401    66.762     0.150
     4.401   116.965     0.150
     4.401   136.363     0.150
     4.401    67.562     0.150
     4.401   136.965     0.150
     4.829   149.762     0.150
     5.131    77.363     0.150
     5.131   159.363     0.150
     5.176   161.562     0.150
     5.176    76.965     0.150
     6.315    92.664     0.150
     6.315   192.465     0.150
     6.315   162.562     0.150
     6.315   194.062     0.150
     6.375    92.664     0.150
     6.375   196.762     0.150
     6.375   196.965     0.150
     6.692    97.465     0.150
     6.692   170.562     0.150
     6.692   206.664     0.150
     7.456   231.965     0.150
     7.532   110.965     0.150
     7.532   190.965     0.150
     7.614   110.262     0.150
     7.614   111.363     0.150
     7.614   192.762     0.150
     9.651   296.664     0.150
     0.170     3.555     0.150
     0.170     6.855     0.150
     0.170     6.654     0.150
     0.251     5.055     0.150
     0.251     8.955     0.150
     0.251     4.754     0.150
     0.251     8.754     0.150
     1.029    32.955     0.150
     1.029    18.654     0.150
     1.175    21.555     0.150
     1.175    38.455     0.150
     1.266    40.355     0.150
     1.426    25.855     0.150
     1.426    45.855     0.150
     1.426    45.455     0.150
     2.313    37.855     0.150
     2.313    39.455     0.150
     2.313    38.754     0.150
     2.313    40.055     0.150
     2.313    67.555     0.150
     2.313    70.555     0.150
     2.494    41.154     0.150
     2.494    44.254     0.150
     2.494    77.555     0.150
     2.494    45.455     0.150
     2.494    77.955     0.150
     2.509    42.154     0.150
     2.509    45.154     0.150
     2.509    78.654     0.150
     2.509    43.154     0.150
     2.509    46.055     0.150
     2.509    79.154     0.150
     3.224    51.855     0.150
     3.224    58.254     0.150
     3.224    89.154     0.150
     3.224    99.055     0.150
     3.224    51.754     0.150
     3.224    58.455     0.150
     3.224   100.055     0.150
     3.957    71.855     0.150
     3.957   123.654     0.150
     3.957    61.654     0.150
     3.957   107.555     0.150
     4.261    76.555     0.150
     4.261   132.955     0.150
     4.245    76.654     0.150
     4.245   130.654     0.150
     4.245    65.154     0.150
     4.245    76.355     0.150
     4.245   131.855     0.150
     4.384    66.955     0.150
     4.384   117.955     0.150
     4.384   136.055     0.150
     4.817   148.855     0.150
     5.120    77.855     0.150
     5.120   134.254     0.150
     5.120   158.855     0.150
     5.210    77.955     0.150
     5.210   162.154     0.150
     5.210    78.154     0.150
     5.210   135.455     0.150
     5.666    84.955     0.150
     5.666   145.955     0.150
     5.666   176.355     0.150
     6.296    92.455     0.150
     6.296   161.754     0.150
     6.296   194.754     0.150
     6.386    93.254     0.150
     6.386   164.254     0.150
     6.386   196.855     0.150
     6.386    93.355     0.150
     6.386   197.355     0.150
     6.670    97.055     0.150
     6.670   171.955     0.150
     6.670   206.455     0.150
     7.587   111.355     0.150
     7.587   194.355     0.150
     7.587   234.754     0.150
     9.622   138.955     0.150
     9.622   297.154     0.150
     0.176     4.412     0.150
     0.176     8.012     0.150
     0.215     4.412     0.150
     0.215     8.912     0.150
     0.215     4.912     0.150
     0.215     8.611     0.150
     1.071    19.512     0.150
     1.071    34.412     0.150
     1.071    34.012     0.150
     1.160    21.512     0.150
     1.160    37.412     0.150
     1.219    39.811     0.150
     1.374    25.012     0.150
     1.374    43.311     0.150
     2.299    36.912     0.150
     2.299    37.512     0.150
     2.299    40.311     0.150
     2.299    65.811     0.150
     2.299    69.611     0.150
     2.451    39.711     0.150
     2.451    43.111     0.150
     2.451    75.111     0.150
     2.451    39.512     0.150
     2.451    43.611     0.150
     2.451    75.412     0.150
     2.506    44.111     0.150
     2.506    78.412     0.150
     2.506    41.111     0.150
     2.506    69.412     0.150
     2.506    77.211     0.150
     3.243    51.412     0.150
     3.243    57.012     0.150
     3.243    98.512     0.150
     3.243    57.611     0.150
     3.243    99.211     0.150
     3.915    60.211     0.150
     3.915   122.412     0.150
     3.915    69.912     0.150
     3.915   120.611     0.150
     4.211    63.311     0.150
     4.211   130.811     0.150
     4.211   130.412     0.150
     4.274   131.512     0.150
     4.403    67.311     0.150
     4.403    78.211     0.150
     4.403   134.611     0.150
     4.400    67.111     0.150
     4.400    78.111     0.150
     4.400   134.611     0.150
     4.830   149.611     0.150
     5.130    77.311     0.150
     5.130   157.912     0.150
     5.158    76.611     0.150
     5.158   159.512     0.150
     5.158   132.711     0.150
     5.158   159.912     0.150
     5.687    84.012     0.150
     5.687   173.912     0.150
     6.319   194.311     0.150
     6.319   193.711     0.150
     6.699   100.111     0.150
     6.699   206.311     0.150
     7.540   111.412     0.150
     7.540   191.111     0.150
     7.624   111.711     0.150
     7.624   195.711     0.150
     0.166     4.328     0.150
     0.166     7.133     0.150
     0.248     5.531     0.150
     0.248     9.227     0.150
     0.248     5.430     0.150
     0.248     9.031     0.150
     1.033    19.227     0.150
     1.033    33.430     0.150
     1.033    33.727     0.150
     1.170    21.328     0.150
     1.170    36.633     0.150
     1.170    36.133     0.150
     1.261    23.531     0.150
     1.261    40.031     0.150
     1.420    24.930     0.150
     1.420    43.828     0.150
     1.420    25.328     0.150
     1.420    44.430     0.150
     2.314    40.828     0.150
     2.314    67.031     0.150
     2.314    38.133     0.150
     2.314    41.031     0.150
     2.314    70.430     0.150
     2.506    41.531     0.150
     2.506    44.430     0.150
     2.506    71.828     0.150
     2.506    77.227     0.150
     2.506    44.227     0.150
     2.506    77.930     0.150
     2.490    44.828     0.150
     3.158    50.031     0.150
     3.158    56.031     0.150
     3.158    88.430     0.150
     3.158    98.727     0.150
     3.224    51.031     0.150
     3.224    57.531     0.150
     3.224    89.133     0.150
     3.224    99.133     0.150
     3.953    61.430     0.150
     3.953   123.328     0.150
     3.953   122.828     0.150
     4.238    64.328     0.150
     4.238    75.930     0.150
     4.238   112.633     0.150
     4.238   132.430     0.150
     4.238    64.133     0.150
     4.238    75.133     0.150
     4.238   131.031     0.150
     4.259    66.828     0.150
     4.259    77.227     0.150
     4.259   133.430     0.150
     4.389    67.531     0.150
     4.389    78.031     0.150
     4.389   135.227     0.150
     4.384    66.930     0.150
     4.384    78.133     0.150
     4.384   116.227     0.150
     4.384   134.430     0.150
     4.384    66.828     0.150
     4.384   116.828     0.150
     4.384   133.828     0.150
     4.815    72.727     0.150
     4.815    86.727     0.150
     4.815   149.430     0.150
     5.118    77.430     0.150
     5.118    92.328     0.150
     5.118   159.133     0.150
     5.204    77.227     0.150
     5.204    93.328     0.150
     5.204   133.930     0.150
     5.204   161.031     0.150
     5.204    77.633     0.150
     5.423    98.930     0.150
     5.423   144.828     0.150
     5.621    82.727     0.150
     5.621   100.930     0.150
     5.621   146.531     0.150
     5.621   174.328     0.150
     5.621    83.031     0.150
     5.621   146.430     0.150
     5.621   174.031     0.150
     5.666    83.531     0.150
     5.666   101.430     0.150
     5.666   175.633     0.150
     6.296    91.531     0.150
     6.296   192.531     0.150
     6.380    93.633     0.150
     6.380   115.828     0.150
     6.380   166.031     0.150
     6.380   200.031     0.150
     6.380    93.031     0.150
     6.380   115.430     0.150
     6.380   197.633     0.150
     6.671    97.133     0.150
     6.671   171.633     0.150
     6.671   207.227     0.150
     7.439   108.430     0.150
     7.439   231.227     0.150
     7.439   108.531     0.150
     7.439   227.727     0.150
     7.510   109.531     0.150
     7.510   193.531     0.150
     7.510   109.828     0.150
     7.589   110.430     0.150
     7.589   193.430     0.150
     7.589   235.227     0.150
     7.589   111.133     0.150
     8.497   120.273     0.150
     8.497   261.625     0.150
     8.598   125.523     0.150
    11.180   156.633     0.150
    11.180   156.453     0.150
    11.180   273.367     0.150
    14.125   199.430     0.150
    15.221   212.727     0.150
    15.330   214.781     0.150
    15.935   220.430     0.150
    15.935   392.727     0.150
    16.351   228.852     0.150
    16.351   513.805     0.150
    16.351   229.719     0.150
    18.305   255.133     0.150
    19.393   266.031     0.150
    19.393   275.633     0.150
    20.191   273.281     0.150
    20.191   636.672     0.150
    20.191   273.430     0.150
    20.596   288.031     0.150
    20.596   291.430     0.150
    21.635   554.930     0.150
    23.132   303.477     0.150
    23.307   305.930     0.150
    23.688   309.945     0.150
    23.733   310.727     0.150
    25.680   330.930     0.150
    25.888   333.227     0.150
    25.888   608.828     0.150
    26.323   336.250     0.150
    26.690   339.242     0.150
    26.731   338.359     0.150
    26.915   341.430     0.150
    27.432   344.930     0.150
    27.432   346.211     0.150
    27.515   344.531     0.150
    28.728   355.828     0.150
    31.515   381.633     0.150
    31.515   697.633     0.150
    33.603   400.531     0.150
    33.839   402.633     0.150
    33.869   403.211     0.150
    33.903   403.227     0.150
    33.951   404.133     0.150
    34.294   406.828     0.150
    34.528   408.828     0.150
    35.961   418.227     0.150
    36.744   425.859     0.150
    36.878   426.789     0.150
    36.960   426.336     0.150
    37.326   430.008     0.150
    37.317   428.727     0.150
    37.706   433.867     0.150
    37.887   435.180     0.150
    38.668   443.234     0.150
    39.601   450.938     0.150
    40.335   455.133     0.150
    41.036   460.656     0.150
    41.127   463.336     0.150
    41.111   460.531     0.150
    41.252   463.430     0.150
    41.560   465.977     0.150
    43.018   479.430     0.150
    43.197   477.633     0.150
    43.930   485.828     0.150
    43.930   588.133     0.150
    43.930   487.188     0.150
    44.279   490.031     0.150
    45.364   498.531     0.150
    45.684   499.531     0.150
    45.786   499.828     0.150
    45.786  1097.031     0.150
    47.186   510.805     0.150
    47.239   511.727     0.150
    47.535   513.328     0.150
    47.535   513.688     0.150
    49.859   533.109     0.150
    50.140   536.383     0.150
    50.380   536.133     0.150
    51.303   544.812     0.150
    51.307   544.570     0.150
    51.334   542.531     0.150
    51.474   544.430     0.150
    51.672   546.930     0.150
    51.981   548.906     0.150
    51.982   550.133     0.150
    52.488   551.828     0.150
    52.826   555.031     0.150
    53.507   559.531     0.150
    53.602   559.727     0.150
    53.602     8.000     0.150
    53.729   562.430     0.150
    53.807   562.430     0.150
    53.840   562.570     0.150
    53.882   562.633     0.150
    54.627   568.031     0.150
    54.686   568.328     0.150
    54.938   570.133     0.150
    55.092   571.094     0.150
    55.381   573.328     0.150
    55.562   575.031     0.150
    55.562   575.031     0.150
    55.571   575.430     0.150
    56.410   581.516     0.150
    56.434   582.031     0.150
    56.511   579.227     0.150
    56.563   582.930     0.150
    56.765   583.195     0.150
    57.114   585.242     0.150
    57.195   587.328     0.150
    57.372   587.828     0.150
    57.419   588.633     0.150
    58.230   592.133     0.150
    58.428   595.391     0.150
    58.566   597.195     0.150
    58.708   597.719     0.150
    58.777   597.945     0.150
    58.869   596.133     0.150
    58.974   599.227     0.150
    59.099   597.930     0.150
    59.351   601.977     0.150
    59.540   602.328     0.150
    60.112   607.430     0.150
    60.717   609.633     0.150
    60.876   609.727     0.150
    61.065   611.531     0.150
    61.132   611.633     0.150
    61.138   611.531     0.150
    61.155   611.828     0.150
    61.313   613.227     0.150
    61.554   614.930     0.150
    61.588   614.930     0.150
    61.649   616.852     0.150
    61.696   615.828     0.150
    62.033   618.031     0.150
    62.361   622.477     0.150
    62.658   624.430     0.150
    62.748   622.328     0.150
    63.094   627.758     0.150
    65.451   640.227     0.150
    65.938   643.531     0.150
    70.041   670.664     0.150
    72.196   683.930     0.150
    75.673   703.430     0.150
    76.895   711.383     0.150
    78.154   717.438     0.150
    81.679   736.828     0.150
    82.073   741.070     0.150
    86.009   759.969     0.150
   144.280  1171.531     0.150
   145.801  1176.133     0.150
   149.071  1185.031     0.150
   149.194  1186.102     0.150
     0.223     4.789     0.150
     0.223     8.992     0.150
     0.223     4.594     0.150
     0.223     8.891     0.150
     0.174     4.188     0.150
     0.174     7.188     0.150
     1.061    19.391     0.150
     1.061    33.992     0.150
     1.166    21.391     0.150
     1.166    37.289     0.150
     1.166    21.289     0.150
     1.166    37.688     0.150
     1.389    24.391     0.150
     1.389    42.992     0.150
     1.389    24.594     0.150
     1.389    44.094     0.150
     2.301    37.594     0.150
     2.301    40.391     0.150
     2.301    66.391     0.150
     2.301    70.188     0.150
     2.301    37.391     0.150
     2.301    38.789     0.150
     2.462    44.391     0.150
     2.462    76.594     0.150
     2.462    40.492     0.150
     2.462    44.492     0.150
     2.462    75.992     0.150
     2.509    40.789     0.150
     2.509    44.289     0.150
     2.509    73.594     0.150
     2.509    77.891     0.150
     2.509    41.688     0.150
     2.509    44.492     0.150
     2.509    78.188     0.150
     3.239    51.188     0.150
     3.239    57.188     0.150
     3.239    99.289     0.150
     3.926    69.992     0.150
     3.926   120.992     0.150
     3.926    60.992     0.150
     3.926   123.891     0.150
     4.221    63.789     0.150
     4.221    75.688     0.150
     4.221   131.492     0.150
     4.272   133.789     0.150
     4.400    66.891     0.150
     4.400    77.891     0.150
     4.400   117.188     0.150
     4.400   134.992     0.150
     4.400    66.492     0.150
     4.400    77.492     0.150
     4.400   116.891     0.150
     4.400   134.094     0.150
     4.399    67.594     0.150
     4.399   116.992     0.150
     4.399   136.188     0.150
     4.828    72.789     0.150
     4.828   149.789     0.150
     4.862   149.992     0.150
     4.862   150.094     0.150
     5.172    77.188     0.150
     5.172   133.688     0.150
     5.172   159.492     0.150
     5.172    76.992     0.150
     5.172   159.688     0.150
     5.129    77.789     0.150
     5.129   159.094     0.150
     5.640   174.391     0.150
     5.640    84.891     0.150
     5.640   147.188     0.150
     5.682    83.992     0.150
     5.682   175.094     0.150
     6.314   161.492     0.150
     6.314   194.391     0.150
     6.370   199.188     0.150
     6.370    92.992     0.150
     6.692    99.594     0.150
     6.692   171.492     0.150
     6.692   206.688     0.150
     7.455   231.094     0.150
     7.455   229.289     0.150
     7.533   110.391     0.150
     7.533   193.594     0.150
     7.533   233.594     0.150
     7.533   111.094     0.150
     7.615   111.289     0.150
     7.615   195.789     0.150
     7.615   235.094     0.150
     7.615   111.594     0.150
     8.471   120.242     0.150
     8.471   211.789     0.150
     8.471   264.023     0.150
     8.471   119.867     0.150
    12.187   172.188     0.150
    15.361   215.344     0.150
    17.338   239.070     0.150
    20.219   273.719     0.150
    20.219   639.070     0.150
    23.338   306.289     0.150
    23.719   310.203     0.150
    23.764   309.289     0.150
    24.542   319.094     0.150
    37.910   435.648     0.150
    41.587   465.891     0.150
    47.560   513.094     0.150
    78.136   718.625     0.150
     0.160     3.348     0.150
     0.160     6.445     0.150
     0.160     3.246     0.150
     0.160     6.246     0.150
     0.274     5.246     0.150
     0.274     9.645     0.150
     0.274     5.145     0.150
     1.171    21.547     0.150
     1.171    38.047     0.150
     1.171    21.445     0.150
     1.171    37.945     0.150
     1.290    23.848     0.150
     1.290    41.848     0.150
     1.290    41.645     0.150
     1.447    26.645     0.150
     1.447    45.746     0.150
     1.447    45.945     0.150
     2.330    38.645     0.150
     2.330    40.746     0.150
     2.330    70.945     0.150
     2.330    38.145     0.150
     2.330    40.547     0.150
     2.499    44.848     0.150
     2.499    72.746     0.150
     2.499    78.848     0.150
     2.499    42.746     0.150
     2.499    44.547     0.150
     2.499    78.445     0.150
     2.518    42.047     0.150
     2.518    45.945     0.150
     2.518    73.645     0.150
     2.518    79.246     0.150
     2.518    44.348     0.150
     3.206    51.945     0.150
     3.206    57.246     0.150
     3.206    88.348     0.150
     3.206    99.145     0.150
     3.206    52.348     0.150
     3.206    58.246     0.150
     3.206    98.348     0.150
     3.980    71.348     0.150
     3.980   122.945     0.150
     3.980    71.848     0.150
     3.980   125.348     0.150
     4.250    65.047     0.150
     4.250    75.848     0.150
     4.250   114.848     0.150
     4.250   131.348     0.150
     4.250    64.945     0.150
     4.250    76.645     0.150
     4.366    67.047     0.150
     4.366    78.145     0.150
     4.366   118.348     0.150
     4.366   134.848     0.150
     4.366    67.246     0.150
     4.366    78.746     0.150
     4.366   117.047     0.150
     4.366   134.445     0.150
     4.377    67.945     0.150
     4.377    77.945     0.150
     4.377   118.645     0.150
     4.377   135.547     0.150
     4.801    73.348     0.150
     4.801   126.547     0.150
     4.801   147.547     0.150
     5.105   157.645     0.150
     5.232    79.047     0.150
     5.232   137.047     0.150
     5.232   162.445     0.150
     5.232    78.945     0.150
     5.232   161.348     0.150
     5.600   145.547     0.150
     5.600   174.246     0.150
     5.647   147.445     0.150
     5.647   174.348     0.150
     6.276    93.547     0.150
     6.276   162.645     0.150
     6.276   191.848     0.150
     6.386    94.645     0.150
     6.386   114.645     0.150
     6.386   164.848     0.150
     6.386   197.547     0.150
     6.386   114.848     0.150
     6.386   198.746     0.150
     6.649   100.145     0.150
     6.649   173.145     0.150
     6.649   206.547     0.150
     6.649    98.145     0.150
     6.649   172.746     0.150
     6.649   206.246     0.150
     7.421   133.445     0.150
     7.421   230.246     0.150
     7.421   110.246     0.150
     7.421   227.645     0.150
     7.487   110.348     0.150
     7.487   193.547     0.150
     7.487   231.645     0.150
     7.487   110.547     0.150
     7.564   111.445     0.150
     7.564   234.246     0.150
     7.564   111.848     0.150
     8.517   122.645     0.150
     8.517   216.742     0.150
     8.517   267.145     0.150
     8.591   126.645     0.150
    11.200   159.945     0.150
    15.301   215.070     0.150
    15.301   484.473     0.150
    16.360   228.418     0.150
    17.348   240.645     0.150
    20.164   274.121     0.150
    23.278   306.246     0.150
    23.659   310.363     0.150
    23.704   311.047     0.150
    29.947   367.348     0.150
    37.868   435.922     0.150
    41.538   466.172     0.150
    44.010   484.746     0.150
    44.010   880.746     0.150
    45.758   499.848     0.150
    45.758   599.145     0.150
    45.758   608.145     0.150
    45.758   901.848     0.150
    47.514   514.547     0.150
    47.514   514.395     0.150
     0.175     4.070     0.150
     0.175     7.070     0.150
     0.175     7.172     0.150
     0.212     4.570     0.150
     0.212     7.875     0.150
     0.212     4.375     0.150
     0.212     8.375     0.150
     1.152    21.172     0.150
     1.152    36.875     0.150
     1.152    21.273     0.150
     1.152    36.273     0.150
     1.361    24.977     0.150
     1.361    43.273     0.150
     1.361    43.375     0.150
     2.300    37.477     0.150
     2.300    40.273     0.150
     2.300    66.070     0.150
     2.300    69.773     0.150
     2.300    36.773     0.150
     2.443    40.477     0.150
     2.443    43.570     0.150
     2.443    75.875     0.150
     2.443    40.273     0.150
     2.443    43.977     0.150
     2.500    44.273     0.150
     2.500    78.070     0.150
     2.500    44.070     0.150
     2.500    76.875     0.150
     3.164    57.172     0.150
     3.164    89.375     0.150
     3.164    99.273     0.150
     3.243    50.570     0.150
     3.243    56.570     0.150
     3.243    99.570     0.150
     3.908    68.773     0.150
     3.908   119.875     0.150
     3.908    60.875     0.150
     3.908   121.773     0.150
     4.198   131.172     0.150
     4.198    63.977     0.150
     4.198    75.273     0.150
     4.198   129.273     0.150
     4.273   133.070     0.150
     4.404    66.875     0.150
     4.404    78.172     0.150
     4.404   115.875     0.150
     4.404   135.070     0.150
     4.397    67.672     0.150
     4.397   135.875     0.150
     4.828   148.977     0.150
     5.146    76.875     0.150
     5.146   159.273     0.150
     5.146    76.977     0.150
     5.146   159.375     0.150
     5.687   147.172     0.150
     5.687   174.977     0.150
     6.321    94.070     0.150
     6.321   193.977     0.150
     6.321   161.977     0.150
     6.321   193.273     0.150
     6.351   196.570     0.150
     6.702   171.477     0.150
     6.702   207.773     0.150
     7.459   230.672     0.150
     7.544   111.273     0.150
     7.544   194.570     0.150
     7.544   234.070     0.150
     7.544   110.273     0.150
     7.597   235.875     0.150
     7.630   111.070     0.150
     7.630   194.477     0.150
     9.670   298.672     0.150
     0.160     4.375     0.150
     0.160     7.574     0.150
     0.160     4.273     0.150
     1.292    23.074     0.150
     1.292    40.676     0.150
     1.292    22.875     0.150
     1.292    40.477     0.150
     1.436    25.477     0.150
     1.436    45.273     0.150
     1.428    25.074     0.150
     1.683    28.977     0.150
     1.683    30.176     0.150
     1.683    29.375     0.150
     2.305    37.773     0.150
     2.305    41.074     0.150
     2.305    66.574     0.150
     2.305    70.273     0.150
     2.305    40.676     0.150
     2.305    70.676     0.150
     2.499    39.176     0.150
     2.499    43.273     0.150
     2.499    75.676     0.150
     2.659    42.676     0.150
     2.659    47.273     0.150
     2.659    73.676     0.150
     2.659    81.977     0.150
     2.659    46.773     0.150
     2.659    81.773     0.150
     3.082    48.477     0.150
     3.082    55.176     0.150
     3.082    96.477     0.150
     3.082    96.273     0.150
     3.326    51.375     0.150
     3.326    60.273     0.150
     3.326   103.676     0.150
     3.326    58.676     0.150
     3.326   102.074     0.150
     3.489    55.375     0.150
     3.489    63.574     0.150
     3.489   109.574     0.150
     3.854    59.574     0.150
     3.854    68.574     0.150
     3.854   103.977     0.150
     3.854   118.773     0.150
     3.854    69.773     0.150
     3.825    58.574     0.150
     3.825    69.477     0.150
     3.825   119.773     0.150
     3.825    69.273     0.150
     3.825   119.477     0.150
     4.686    84.977     0.150
     4.686   144.477     0.150
     4.683    71.875     0.150
     4.683    84.273     0.150
     4.683   145.875     0.150
     4.956    74.273     0.150
     4.956    88.574     0.150
     4.956   152.574     0.150
     4.956   151.773     0.150
     5.198   161.176     0.150
     5.246    95.773     0.150
     5.246   164.977     0.150
     5.405    80.977     0.150
     5.405    97.773     0.150
     5.405   169.375     0.150
     5.689    83.477     0.150
     5.689   176.574     0.150
     6.234   113.176     0.150
     6.234   194.773     0.150
     6.234   190.574     0.150
     6.300   193.074     0.150
     6.939   216.273     0.150
     7.176   101.863     0.150
     7.436   133.676     0.150
     7.436   228.574     0.150
     7.436   228.074     0.150
     7.940   144.676     0.150
     7.940   246.676     0.150
     7.940   144.875     0.150
     8.326   121.875     0.150
     8.326   150.676     0.150
     8.326   256.875     0.150
     8.497   125.875     0.150
     8.497   122.855     0.150
     8.497   153.324     0.150
     8.497   264.344     0.150
     8.564   218.074     0.150
     8.564   263.574     0.150
     8.564   219.176     0.150
    10.731   152.375     0.150
    21.257   285.574     0.150
    21.347   288.773     0.150
    45.512   498.625     0.150
     0.409     8.252     0.150
     0.409    14.651     0.150
     0.409    14.752     0.150
     0.221     4.752     0.150
     0.221     5.052     0.150
     0.221     8.151     0.150
     0.221     8.752     0.150
     1.141    20.552     0.150
     1.141    36.552     0.150
     1.141    39.852     0.150
     1.141    20.252     0.150
     1.141    36.052     0.150
     1.369    24.151     0.150
     1.628    28.852     0.150
     1.628    51.151     0.150
     1.628    50.651     0.150
     2.126    34.752     0.150
     2.126    36.852     0.150
     2.126    65.052     0.150
     2.126    34.451     0.150
     2.126    36.552     0.150
     2.126    63.852     0.150
     2.299    38.151     0.150
     2.299    40.651     0.150
     2.299    67.352     0.150
     2.299    71.651     0.150
     2.299    38.552     0.150
     2.299    40.752     0.150
     2.860    50.651     0.150
     2.860    88.852     0.150
     2.860    51.052     0.150
     2.934    46.852     0.150
     2.934    52.252     0.150
     2.934    90.352     0.150
     3.696    56.852     0.150
     3.696    65.951     0.150
     3.696   114.552     0.150
     3.696    65.552     0.150
     3.696   115.052     0.150
     3.871    59.352     0.150
     3.871    69.651     0.150
     3.871   103.852     0.150
     3.871   121.151     0.150
     3.871    69.052     0.150
     3.871   104.752     0.150
     3.871   120.852     0.150
     3.747    68.052     0.150
     3.747   103.151     0.150
     3.747   117.252     0.150
     4.056    70.852     0.150
     4.056   122.852     0.150
     4.938   154.852     0.150
     4.958   154.151     0.150
     5.181    77.552     0.150
     5.181   136.052     0.150
     5.181   158.151     0.150
     5.181    77.451     0.150
     5.181   158.951     0.150
     5.461   170.151     0.150
     5.686   177.352     0.150
     6.062    88.852     0.150
     6.062   188.151     0.150
     6.062   187.951     0.150
     6.466   199.151     0.150
     6.466   198.852     0.150
     7.158   218.451     0.150
     8.191   121.451     0.150
     8.191   256.951     0.150
     8.507   263.752     0.150
     8.507   124.052     0.150
     8.701   126.651     0.150
     8.701   269.951     0.150
     8.701   125.951     0.150
     9.059   130.592     0.150
     9.059   284.351     0.150
    10.440   147.651     0.150
    16.643   236.227     0.150
    17.269   238.352     0.150
    21.372   287.177     0.150
    25.019   323.988     0.150
    42.715   475.826     0.150
    47.118   512.151     0.150
    47.118  1127.951     0.150
     0.171     4.141     0.150
     0.171     7.344     0.150
     0.171     7.039     0.150
     0.561    10.844     0.150
     0.561    18.344     0.150
     1.184    21.539     0.150
     1.184    37.445     0.150
     1.184    21.242     0.150
     1.184    37.945     0.150
     1.485    26.539     0.150
     1.485    46.039     0.150
     1.790    31.344     0.150
     1.790    54.539     0.150
     1.790    30.844     0.150
     1.913    32.742     0.150
     1.913    34.141     0.150
     1.913    59.945     0.150
     1.913    59.445     0.150
     2.428    39.844     0.150
     2.428    43.641     0.150
     2.428    75.641     0.150
     2.611    47.539     0.150
     2.611    82.039     0.150
     3.253    51.242     0.150
     3.253    58.641     0.150
     3.253   100.344     0.150
     3.861    59.445     0.150
     3.861    70.039     0.150
     3.861   120.742     0.150
     4.027   125.945     0.150
     4.328    65.344     0.150
     4.328    77.445     0.150
     4.328   133.945     0.150
     5.274   164.242     0.150
     5.465   168.844     0.150
     6.004   186.242     0.150
     6.405   199.445     0.150
     6.753   210.039     0.150
     7.435   122.039     0.150
     7.435   231.141     0.150
     0.166     3.770     0.150
     0.166     6.871     0.150
     0.229     4.770     0.150
     0.229     4.270     0.150
     0.229     9.172     0.150
     1.157    21.270     0.150
     1.157    37.473     0.150
     1.157    37.070     0.150
     1.387    25.570     0.150
     1.387    44.473     0.150
     2.309    37.770     0.150
     2.309    40.570     0.150
     2.309    66.371     0.150
     2.309    70.371     0.150
     2.309    37.570     0.150
     2.466    40.570     0.150
     2.466    44.270     0.150
     2.466    76.871     0.150
     2.466    44.570     0.150
     2.466    77.570     0.150
     2.499    41.473     0.150
     2.499    45.270     0.150
     2.499    78.270     0.150
     2.499    41.172     0.150
     2.499    44.070     0.150
     2.499    78.070     0.150
     3.232    51.270     0.150
     3.232    58.473     0.150
     3.232    90.371     0.150
     3.232   100.973     0.150
     3.930    60.770     0.150
     3.930    70.672     0.150
     3.930   107.172     0.150
     3.930   121.172     0.150
     3.930    71.270     0.150
     3.930   122.172     0.150
     4.214    65.473     0.150
     4.214    75.473     0.150
     4.214   130.371     0.150
     4.214    75.973     0.150
     4.214   130.770     0.150
     4.263   132.770     0.150
     4.392    67.070     0.150
     4.392   135.473     0.150
     4.392    66.770     0.150
     4.392    78.570     0.150
     4.392   135.672     0.150
     4.390    67.270     0.150
     4.390    78.871     0.150
     4.390   135.973     0.150
     5.120    77.172     0.150
     5.120   158.070     0.150
     5.172    77.070     0.150
     5.172   134.473     0.150
     5.172   160.770     0.150
     5.172    77.371     0.150
     5.172   161.270     0.150
     5.674    83.672     0.150
     5.674   174.172     0.150
     6.307   162.672     0.150
     6.307   193.570     0.150
     6.307    92.770     0.150
     6.307   194.270     0.150
     6.362   196.070     0.150
     6.362    92.973     0.150
     6.362   196.570     0.150
     6.685    99.473     0.150
     6.685   172.371     0.150
     6.685   173.871     0.150
     6.685   205.570     0.150
     7.447   232.371     0.150
     7.526   110.371     0.150
     7.526   230.070     0.150
     7.609   233.973     0.150
     7.609   111.270     0.150
     7.609   193.371     0.150
     8.593   127.473     0.150
     9.648   297.672     0.150
    11.168   158.973     0.150
    17.347   240.871     0.150
    20.119   277.371     0.150
    45.818   503.770     0.150
    45.818  1107.770     0.150
     0.140     3.125     0.150
     0.140     5.324     0.150
     0.140     3.023     0.150
     1.380    25.324     0.150
     1.380    43.922     0.150
     1.380    25.023     0.150
     1.539    27.523     0.150
     1.539    47.922     0.150
     1.539    27.125     0.150
     1.539    27.723     0.150
     1.539    47.723     0.150
     1.571    28.223     0.150
     1.571    49.625     0.150
     1.571    49.223     0.150
     1.569    28.223     0.150
     1.569    49.422     0.150
     1.569    28.023     0.150
     2.428    39.824     0.150
     2.428    43.223     0.150
     2.428    70.523     0.150
     2.428    74.922     0.150
     2.428    40.422     0.150
     2.428    42.723     0.150
     2.459    43.324     0.150
     2.459    69.223     0.150
     2.459    75.324     0.150
     2.459    42.723     0.150
     2.459    74.625     0.150
     2.783    46.324     0.150
     2.783    50.723     0.150
     2.783    87.125     0.150
     2.783    48.723     0.150
     2.783    85.223     0.150
     2.954    47.523     0.150
     2.954    52.824     0.150
     2.954    91.824     0.150
     2.954    53.023     0.150
     2.954    91.723     0.150
     3.358    52.324     0.150
     3.358    59.723     0.150
     3.358   103.422     0.150
     3.616    65.922     0.150
     3.616   113.324     0.150
     3.702    57.422     0.150
     3.702    66.523     0.150
     3.702   100.922     0.150
     3.702   114.625     0.150
     3.702    65.824     0.150
     3.702   114.523     0.150
     3.987    61.625     0.150
     3.987   123.023     0.150
     3.987    61.824     0.150
     3.987    71.824     0.150
     3.987   122.824     0.150
     4.804    73.625     0.150
     4.804   149.625     0.150
     5.087    77.223     0.150
     5.087    90.023     0.150
     5.087   155.922     0.150
     5.087    77.922     0.150
     5.087    89.922     0.150
     5.087   133.523     0.150
     5.087   155.523     0.150
     5.322   166.523     0.150
     5.371   167.824     0.150
     5.525   172.625     0.150
     5.738    85.223     0.150
     5.738   177.324     0.150
     5.738    85.523     0.150
     5.986   186.523     0.150
     6.363   197.422     0.150
     6.432   197.324     0.150
     7.070   216.422     0.150
     7.070   217.324     0.150
     7.569   112.625     0.150
     7.569   233.523     0.150
     7.569   232.324     0.150
     8.066   247.223     0.150
     8.460   122.422     0.150
     8.460   215.125     0.150
     8.460   260.625     0.150
     8.700   126.723     0.150
     8.700   269.125     0.150
     8.700   127.223     0.150
    10.617   150.625     0.150
    11.798   165.125     0.150
    11.798   296.523     0.150
     0.040     2.008     0.150
     0.040     1.609     0.150
     0.040     4.406     0.150
     0.373     6.508     0.150
     0.373     6.707     0.150
     0.373    12.109     0.150
     1.062    20.008     0.150
     1.062    34.609     0.150
     1.062    19.906     0.150
     1.062    34.008     0.150
     1.312    23.906     0.150
     1.312    42.906     0.150
     1.312    24.008     0.150
     1.312    42.508     0.150
     1.293    24.109     0.150
     1.293    41.809     0.150
     1.293    23.906     0.150
     1.293    41.609     0.150
     2.105    35.508     0.150
     2.105    36.508     0.150
     2.105    62.207     0.150
     2.105    65.008     0.150
     2.105    39.008     0.150
     2.105    63.609     0.150
     2.276    38.406     0.150
     2.276    41.309     0.150
     2.276    71.707     0.150
     2.276    40.809     0.150
     2.679    44.309     0.150
     2.679    47.508     0.150
     2.679    78.207     0.150
     2.679    83.809     0.150
     3.355   105.508     0.150
     3.441   106.309     0.150
     3.735    58.207     0.150
     3.735    66.508     0.150
     3.735   115.906     0.150
     3.735    58.707     0.150
     3.735    67.207     0.150
     3.992   124.309     0.150
     4.287   134.309     0.150
     4.601    81.707     0.150
     4.601   141.809     0.150
     4.589    70.008     0.150
     4.589   141.109     0.150
     5.045    76.109     0.150
     5.045   131.809     0.150
     5.045   157.809     0.150
     5.045    75.906     0.150
     5.045   157.008     0.150
     5.320   165.309     0.150
     6.476   168.406     0.150
     6.476   201.707     0.150
     6.897   213.406     0.150
     7.737   239.008     0.150
     7.737   114.707     0.150
     7.737   198.906     0.150
     7.814   114.906     0.150
     7.814   201.707     0.150
     7.814   239.609     0.150
     7.814   114.406     0.150
     0.131     2.797     0.150
     0.131     5.398     0.150
     0.131     5.297     0.150
     0.314     5.797     0.150
     0.314    11.695     0.150
     0.314     5.695     0.150
     1.144    21.094     0.150
     1.144    37.297     0.150
     1.144    36.297     0.150
     1.324    24.398     0.150
     1.324    43.000     0.150
     1.324    24.297     0.150
     1.469    27.094     0.150
     1.469    47.000     0.150
     1.469    46.898     0.150
     2.371    39.297     0.150
     2.371    41.297     0.150
     2.371    71.898     0.150
     2.371    39.094     0.150
     2.371    41.000     0.150
     2.371    72.000     0.150
     2.465    41.500     0.150
     2.465    44.594     0.150
     2.465    77.797     0.150
     2.465    44.000     0.150
     2.465    75.398     0.150
     2.555    45.797     0.150
     2.555    80.000     0.150
     2.555    42.195     0.150
     2.555    45.695     0.150
     3.108    50.500     0.150
     3.108    55.594     0.150
     3.108    97.195     0.150
     3.165    51.297     0.150
     3.165    56.695     0.150
     3.165    98.297     0.150
     3.740    59.094     0.150
     3.740    67.000     0.150
     3.740   116.297     0.150
     4.019   125.797     0.150
     4.019    71.695     0.150
     4.019   125.398     0.150
     4.237    76.000     0.150
     4.237   131.797     0.150
     4.237   131.695     0.150
     4.325    67.094     0.150
     4.325   117.195     0.150
     4.325   133.195     0.150
     4.338    67.398     0.150
     4.338    77.594     0.150
     4.338   117.094     0.150
     4.338   133.398     0.150
     5.066    77.398     0.150
     5.066    90.094     0.150
     5.066   157.195     0.150
     5.257    79.297     0.150
     5.257   137.094     0.150
     5.257   163.898     0.150
     5.257   163.695     0.150
     5.559   145.000     0.150
     5.559   171.695     0.150
     5.606    84.297     0.150
     5.606   146.797     0.150
     5.606   172.594     0.150
     5.606    84.195     0.150
     5.606   146.297     0.150
     6.364    94.195     0.150
     6.364   197.195     0.150
     6.364    94.398     0.150
     6.364   197.398     0.150
     6.607    98.000     0.150
     6.607   169.094     0.150
     6.607   204.195     0.150
     6.607   201.500     0.150
     7.380   108.000     0.150
     7.380   227.094     0.150
     7.446   110.898     0.150
     7.446   191.398     0.150
     7.446   230.195     0.150
     7.446   110.398     0.150
     7.524   111.000     0.150
     7.524   192.594     0.150
    20.126   275.875     0.150
     0.193     3.913     0.150
     0.193     6.513     0.150
     0.822    16.013     0.150
     0.822    26.713     0.150
     0.822    15.913     0.150
     0.822    27.113     0.150
     1.055    19.713     0.150
     1.055    34.213     0.150
     1.055    34.513     0.150
     1.402    25.413     0.150
     1.402    25.513     0.150
     1.402    44.613     0.150
     1.531    27.713     0.150
     1.989    35.013     0.150
     1.989    35.813     0.150
     1.989    62.313     0.150
     1.989    63.313     0.150
     1.989    35.113     0.150
     1.989    62.813     0.150
     2.332    39.613     0.150
     2.332    41.813     0.150
     2.332    69.613     0.150
     2.332    72.813     0.150
     2.332    40.013     0.150
     2.332    69.913     0.150
     2.332    73.013     0.150
     2.656    45.013     0.150
     2.656    49.113     0.150
     2.656    83.613     0.150
     2.656    49.013     0.150
     3.366    53.213     0.150
     3.366    60.813     0.150
     3.366    92.513     0.150
     3.366   103.513     0.150
     4.094    63.313     0.150
     4.094   110.013     0.150
     4.094   127.913     0.150
     4.297   133.713     0.150
     4.364    79.113     0.150
     4.364   136.413     0.150
     5.513   169.713     0.150
     5.853   183.313     0.150
     6.106   190.113     0.150
     6.657   207.813     0.150
     7.893   245.313     0.150
     8.872   275.713     0.150
     0.020     2.949     0.150
     0.020     5.449     0.150
     0.644    12.148     0.150
     0.644    21.551     0.150
     1.273    22.449     0.150
     1.273    39.648     0.150
     1.273    22.648     0.150
     1.273    39.852     0.150
     1.449    25.250     0.150
     1.449    44.148     0.150
     1.449    44.250     0.150
     1.537    27.051     0.150
     1.537    47.852     0.150
     1.551    27.352     0.150
     1.551    27.648     0.150
     1.551    48.648     0.150
     1.551    48.449     0.150
     2.357    37.250     0.150
     2.357    40.551     0.150
     2.357    71.250     0.150
     2.357    39.852     0.150
     2.357    42.449     0.150
     2.357    71.648     0.150
     2.352    38.449     0.150
     2.352    73.449     0.150
     2.352    38.051     0.150
     2.352    41.648     0.150
     2.352    67.551     0.150
     2.352    71.449     0.150
     2.801    44.551     0.150
     2.801    50.148     0.150
     2.801    75.051     0.150
     2.801    86.250     0.150
     2.801    44.352     0.150
     2.801    49.148     0.150
     2.801    86.750     0.150
     2.948    46.750     0.150
     2.948    51.949     0.150
     2.948    90.551     0.150
     2.948    52.250     0.150
     2.948    90.750     0.150
     3.463   107.551     0.150
     3.628    97.551     0.150
     3.628   113.051     0.150
     3.628   116.750     0.150
     3.782    57.750     0.150
     3.782    68.148     0.150
     3.782   100.148     0.150
     3.782   118.551     0.150
     3.782    67.852     0.150
     3.782   117.949     0.150
     3.977    60.551     0.150
     3.977    70.648     0.150
     3.977   121.750     0.150
     4.261    65.051     0.150
     4.261   131.449     0.150
     4.826   149.852     0.150
     5.086   155.648     0.150
     5.549    82.852     0.150
     5.834    85.551     0.150
     5.834    85.148     0.150
     0.564    10.672     0.150
     0.564    17.875     0.150
     0.774    14.875     0.150
     0.774    24.973     0.150
     0.774    25.074     0.150
     0.774    14.875     0.150
     0.774    24.574     0.150
     0.774    15.074     0.150
     0.774    25.473     0.150
     1.591    29.074     0.150
     1.591    50.973     0.150
     1.591    51.074     0.150
     1.795    31.875     0.150
     1.795    32.074     0.150
     1.795    55.172     0.150
     1.895    33.172     0.150
     1.895    59.273     0.150
     2.267    38.672     0.150
     2.267    41.574     0.150
     2.267    66.973     0.150
     2.267    70.773     0.150
     2.267    41.074     0.150
     2.267    71.574     0.150
     2.226    38.273     0.150
     2.226    41.074     0.150
     2.226    71.074     0.150
     2.226    41.574     0.150
     2.838    46.074     0.150
     2.838    52.875     0.150
     2.838    89.074     0.150
     2.838    45.973     0.150
     2.838    50.172     0.150
     2.838    52.773     0.150
     2.838    88.574     0.150
     3.128    51.273     0.150
     3.128    58.574     0.150
     3.128    88.074     0.150
     3.128    98.473     0.150
     3.566    56.273     0.150
     3.566    64.375     0.150
     3.566   111.473     0.150
     3.566   111.574     0.150
     3.494    55.574     0.150
     3.494    63.074     0.150
     3.494    96.273     0.150
     3.494   107.973     0.150
     3.494    62.273     0.150
     3.494   108.074     0.150
     4.086    62.773     0.150
     4.086    73.773     0.150
     4.086   127.273     0.150
     4.086    62.672     0.150
     4.086    73.973     0.150
     4.086   127.875     0.150
     4.384    67.574     0.150
     4.384   118.273     0.150
     4.384   137.574     0.150
     4.694    71.375     0.150
     4.694   146.375     0.150
     4.694    71.672     0.150
     4.694   146.672     0.150
     5.021   157.273     0.150
     5.576    84.473     0.150
     5.576   175.375     0.150
     5.591    83.973     0.150
     5.591   174.074     0.150
     5.684    85.672     0.150
     5.684   149.875     0.150
     5.820    86.973     0.150
     5.820   180.773     0.150
     5.820   180.973     0.150
     5.844    88.074     0.150
     5.844   181.672     0.150
     5.762    86.574     0.150
     5.762   179.074     0.150
     5.786    86.773     0.150
     5.786    87.273     0.150
     5.786   181.473     0.150
     6.144   100.773     0.150
     6.144   113.375     0.150
     6.144   193.473     0.150
     6.193    91.273     0.150
     6.193   194.473     0.150
     6.409    94.875     0.150
     6.409   164.172     0.150
     6.409   190.172     0.150
     6.409   197.875     0.150
     6.497    95.574     0.150
     6.497    95.375     0.150
     7.106   104.273     0.150
     7.106   219.574     0.150
     7.492   106.754     0.150
     7.492   107.273     0.150
     7.492   190.875     0.150
     7.796   113.773     0.150
     7.796   239.254     0.150
     7.796   115.172     0.150
     7.796   113.473     0.150
     7.796   114.773     0.150
     8.262   120.574     0.150
     8.262   120.375     0.150
     8.830   128.172     0.150
     8.830   275.672     0.150
     8.830   129.574     0.150
     8.830   276.074     0.150
     9.138   132.172     0.150
     9.138   132.574     0.150
     9.138   283.273     0.150
     9.313   134.172     0.150
     9.313   134.273     0.150
     9.313   289.473     0.150
     9.646   139.574     0.150
     9.646   302.812     0.150
    11.400   161.574     0.150
    11.400   351.172     0.150
    14.104   201.473     0.150
    14.900   211.473     0.150
    14.900   736.473     0.150
    14.900   955.375     0.150
    14.900   211.184     0.150
    15.344   218.375     0.150
    15.344   221.672     0.150
    15.344   526.273     0.150
    15.746   228.074     0.150
    16.061   226.074     0.150
    16.061   239.074     0.150
    16.061   427.473     0.150
    16.083   226.125     0.150
    16.788   522.074     0.150
    17.129   237.352     0.150
    17.129   238.098     0.150
    17.129   534.898     0.150
    17.145   238.074     0.150
    17.076   242.273     0.150
    17.735   244.074     0.150
    17.793   249.973     0.150
    17.793   451.973     0.150
    18.035   251.773     0.150
    19.311   275.375     0.150
    19.311   279.375     0.150
    19.311   968.875     0.150
    19.445   268.273     0.150
    19.445   485.973     0.150
    19.649   270.035     0.150
    19.925   273.672     0.150
    20.142   274.973     0.150
    20.280   277.633     0.150
    20.669   281.512     0.150
    20.669   280.973     0.150
    21.026   287.574     0.150
    21.026   296.273     0.150
    21.026   516.273     0.150
    21.026   525.773     0.150
    21.026   548.273     0.150
    21.262   287.473     0.150
    21.262   517.574     0.150
    21.262   311.172     0.150
    21.425   287.773     0.150
    21.912   293.055     0.150
    21.967   294.062     0.150
    21.967   294.473     0.150
    25.232   324.875     0.150
    25.473   327.773     0.150
    25.517   327.832     0.150
    25.432   327.773     0.150
    25.501   329.773     0.150
    25.577   329.473     0.150
    26.202   334.973     0.150
    26.202   334.672     0.150
    26.263   333.773     0.150
    26.264   336.672     0.150
    26.264   541.672     0.150
    26.264   606.672     0.150
    26.264   616.473     0.150
    26.264   676.574     0.150
    28.101   354.883     0.150
    28.699   360.273     0.150
    29.159   364.902     0.150
    29.177   360.973     0.150
    29.177   739.875     0.150
    30.120   372.672     0.150
    30.120   432.172     0.150
    30.120   554.875     0.150
    30.120   670.473     0.150
    30.120   680.074     0.150
    30.120   774.273     0.150
    30.120   777.074     0.150
    30.120  1008.473     0.150
    30.389   370.473     0.150
    30.389   426.273     0.150
    30.389   670.574     0.150
    30.389   766.074     0.150
    30.801   376.574     0.150
    30.801   376.574     0.150
    32.083   387.375     0.150
    32.083   453.875     0.150
    32.083   704.074     0.150
    33.048   394.273     0.150
    36.561   426.875     0.150
    36.735   426.172     0.150
    36.735   567.773     0.150
    37.104   430.273     0.150
    37.136   430.875     0.150
    37.136   778.172     0.150
    37.485   432.762     0.150
    38.336   438.973     0.150
    38.905   444.574     0.150
    39.985   453.473     0.150
    41.024   466.172     0.150
    41.513   468.172     0.150
    41.874   468.973     0.150
    41.874     5.102     0.150
    41.874   566.875     0.150
    42.384   473.273     0.150
    42.383   475.375     0.150
    42.849   477.875     0.150
    42.850   477.473     0.150
    42.850   477.574     0.150
    42.887   477.773     0.150
    44.184   487.273     0.150
    44.198   489.535     0.150
    44.198   489.875     0.150
    44.515   491.664     0.150
    45.682   501.242     0.150
    45.682   501.375     0.150
    45.682   904.074     0.150
    46.321   505.625     0.150
    46.475   507.695     0.150
    46.841   510.273     0.150
    46.840   510.195     0.150
    47.524   512.875     0.150
    47.524   624.172     0.150
    47.524   926.574     0.150
    47.523   514.992     0.150
    48.096   518.875     0.150
    48.096   518.352     0.150
    48.068   518.473     0.150
    48.689   524.172     0.150
    48.689   523.672     0.150
    48.941   525.594     0.150
    49.889   534.324     0.150
    50.239   535.922     0.150
    50.239   536.473     0.150
    50.800   537.273     0.150
    50.800     6.000     0.150
    51.146   542.875     0.150
    51.893   548.395     0.150
    52.587   554.273     0.150
    52.587     5.301     0.150
    52.707   554.773     0.150
    52.720   555.375     0.150
    52.806   555.672     0.150
    52.986   556.875     0.150
    53.033   557.973     0.150
    53.151   559.074     0.150
    53.262   558.164     0.150
    53.278   560.035     0.150
    53.685   561.352     0.150
    53.737   562.773     0.150
    53.737     4.102     0.150
    53.739   561.555     0.150
    53.746   561.754     0.150
    53.756   563.535     0.150
    53.814   562.352     0.150
    53.822   567.375     0.150
    53.912   564.445     0.150
    53.911   563.973     0.150
    53.911     3.500     0.150
    54.136   565.125     0.150
    54.136   565.773     0.150
    54.257   566.973     0.150
    54.257     3.699     0.150
    54.278   566.773     0.150
    54.278     3.602     0.150
    54.419   567.555     0.150
    54.419   568.074     0.150
    54.487   568.574     0.150
    54.487     4.000     0.150
    54.889   571.074     0.150
    54.889     4.199     0.150
    54.902   570.973     0.150
    54.902     4.000     0.150
    54.979   570.875     0.150
    54.979     4.000     0.150
    55.282   574.375     0.150
    55.282     5.898     0.150
    55.300   574.273     0.150
    55.300     4.102     0.150
    55.400   575.074     0.150
    55.400     3.598     0.150
    55.685   576.312     0.150
    55.746   575.418     0.150
    55.874   578.172     0.150
    56.016   579.473     0.150
    56.016     3.500     0.150
    56.058   579.375     0.150
    56.058     4.098     0.150
    56.249   581.578     0.150
    56.254   580.535     0.150
    56.346   581.672     0.150
    56.358   581.672     0.150
    56.358     3.801     0.150
    56.470   582.574     0.150
    56.519   582.672     0.150
    56.519   581.973     0.150
    56.598   582.574     0.150
    56.651   584.074     0.150
    56.945   586.172     0.150
    56.945     4.203     0.150
    56.945   586.172     0.150
    56.945     4.203     0.150
    57.010   585.238     0.150
    57.907   592.949     0.150
    58.005   592.152     0.150
    58.012   594.375     0.150
    58.288   594.281     0.150
    58.363   595.363     0.150
    58.379   595.594     0.150
    58.504   596.574     0.150
    58.807   598.574     0.150
    58.879   598.895     0.150
    59.060   600.172     0.150
    59.138   600.215     0.150
    59.204   602.160     0.150
    59.210   600.773     0.150
    59.247   600.973     0.150
    59.342   602.094     0.150
    59.524   602.875     0.150
    59.584   603.672     0.150
    60.228   607.773     0.150
    60.287   608.172     0.150
    60.396   608.574     0.150
    60.423   609.375     0.150
    61.502   615.773     0.150
    61.628   619.145     0.150
    61.892   618.773     0.150
    62.102   621.473     0.150
    62.109   621.672     0.150
    62.202   620.973     0.150
    62.383   621.672     0.150
    62.384   621.574     0.150
    62.401   622.074     0.150
    62.483   622.574     0.150
    62.715   625.773     0.150
    62.833   624.672     0.150
    62.876   625.473     0.150
    62.942   627.375     0.150
    63.119   628.375     0.150
    63.260   627.152     0.150
    63.352   628.672     0.150
    63.479   630.172     0.150
    63.501   630.074     0.150
    63.583   630.074     0.150
    63.703   631.074     0.150
    63.780   631.574     0.150
    63.830   632.273     0.150
    63.945   631.875     0.150
    64.029   633.172     0.150
    64.090   633.672     0.150
    64.194   634.324     0.150
    64.435   635.973     0.150
    64.475   637.172     0.150
    64.523   636.973     0.150
    65.048   640.574     0.150
    65.205   641.336     0.150
    65.426   643.082     0.150
    65.493   643.230     0.150
    65.617   643.055     0.150
    65.660   644.805     0.150
    65.760   645.273     0.150
    65.708   644.566     0.150
    65.795   644.906     0.150
    65.805   645.477     0.150
    65.932   646.336     0.150
    65.970   646.438     0.150
    66.000   647.785     0.150
    66.155   647.441     0.150
    66.304   648.414     0.150
    66.359   648.871     0.150
    66.451   649.297     0.150
    66.653   650.875     0.150
    66.790   651.273     0.150
    66.763   651.926     0.150
    66.767   652.172     0.150
    66.983   653.113     0.150
    66.992   653.172     0.150
    67.079   654.523     0.150
    67.098   654.352     0.150
    67.265   653.473     0.150
    67.247   654.816     0.150
    67.262   655.074     0.150
    67.440   656.004     0.150
    67.453   656.137     0.150
    67.487   656.203     0.150
    67.538   656.371     0.150
    67.674   657.188     0.150
    67.699   657.363     0.150
    67.697   657.488     0.150
    67.738   657.465     0.150
    67.924   658.859     0.150
    67.919   659.535     0.150
    68.045   660.516     0.150
    68.078   660.500     0.150
    68.123   661.023     0.150
    68.181   660.531     0.150
    68.302   661.688     0.150
    68.373   662.191     0.150
    68.416   662.496     0.150
    68.467   662.898     0.150
    68.657   664.086     0.150
    68.767   664.973     0.150
    68.858   665.172     0.150
    68.928   665.207     0.150
    69.023   665.668     0.150
    69.075   666.590     0.150
    69.075   666.926     0.150
    69.231   667.363     0.150
    69.236   667.734     0.150
    69.324   667.695     0.150
    69.428   668.848     0.150
    69.469   667.562     0.150
    69.469   667.297     0.150
    69.436   669.242     0.150
    69.458   669.699     0.150
    69.470   669.074     0.150
    69.546   669.340     0.150
    69.628   670.199     0.150
    69.708   670.734     0.150
    69.721   670.645     0.150
    69.855   671.324     0.150
    69.860   671.973     0.150
    69.873   670.125     0.150
    69.873   670.781     0.150
    69.961   671.750     0.150
    69.990   672.500     0.150
    70.035   672.645     0.150
    70.072   673.023     0.150
    70.135   674.000     0.150
    70.124   672.074     0.150
    70.203   674.672     0.150
    70.228   673.898     0.150
    70.233   674.016     0.150
    70.257   674.324     0.150
    70.266   673.789     0.150
    70.329   675.250     0.150
    70.400   674.875     0.150
    70.413   675.699     0.150
    70.464   674.785     0.150
    70.480   674.559     0.150
    70.529   675.387     0.150
    70.808   677.203     0.150
    70.818   677.125     0.150
    70.828   678.348     0.150
    70.930   677.285     0.150
    70.958   678.539     0.150
    71.017   678.961     0.150
    71.023   679.027     0.150
    71.030   678.637     0.150
    71.050   678.648     0.150
    71.084   678.172     0.150
    71.183   679.199     0.150
    71.189   679.777     0.150
    71.220   679.895     0.150
    71.359   680.512     0.150
    71.359   680.543     0.150
    71.290   680.297     0.150
    71.322   681.195     0.150
    71.450   681.312     0.150
    71.461   681.738     0.150
    71.471   680.520     0.150
    71.531   681.293     0.150
    71.623   682.344     0.150
    71.578   682.324     0.150
    71.636   683.273     0.150
    71.639   683.074     0.150
    71.660   682.500     0.150
    71.854   683.812     0.150
    71.870   684.371     0.150
    71.931   683.992     0.150
    71.954   684.633     0.150
    72.079   685.094     0.150
    72.123   685.582     0.150
    72.161   685.949     0.150
    72.165   685.750     0.150
    72.177   686.215     0.150
    72.197   686.699     0.150
    72.276   686.348     0.150
    72.284   686.113     0.150
    72.283   686.078     0.150
    72.383   687.223     0.150
    72.396   687.598     0.150
    72.481   687.117     0.150
    72.496   687.473     0.150
    72.496   687.898     0.150
    72.502   688.094     0.150
    72.539   688.367     0.150
    72.553   688.523     0.150
    72.657   688.562     0.150
    72.671   689.016     0.150
    72.721   689.031     0.150
    72.783   689.715     0.150
    72.811   690.168     0.150
    72.833   690.832     0.150
    72.924   690.500     0.150
    73.020   691.488     0.150
    73.039   691.137     0.150
    73.053   691.473     0.150
    73.135   691.750     0.150
    73.141   692.000     0.150
    73.166   692.199     0.150
    73.183   692.043     0.150
    73.279   692.023     0.150
    73.421   693.949     0.150
    73.419   693.824     0.150
    73.428   693.254     0.150
    73.473   693.094     0.150
    73.567   694.207     0.150
    73.567   692.973     0.150
    73.611   694.746     0.150
    73.645   694.723     0.150
    73.651   694.750     0.150
    73.715   694.645     0.150
    73.718   694.945     0.150
    73.807   696.449     0.150
    73.799   695.859     0.150
    73.866   696.395     0.150
    73.947   696.836     0.150
    73.997   697.449     0.150
    74.120   697.090     0.150
    74.254   698.949     0.150
    74.258   698.059     0.150
    74.436   699.168     0.150
    74.453   698.074     0.150
    74.453   697.410     0.150
    74.553   699.617     0.150
    74.551   699.742     0.150
    74.691   701.348     0.150
    74.718   701.648     0.150
    74.724   699.242     0.150
    74.724   699.074     0.150
    74.845   701.723     0.150
    74.993   702.680     0.150
    75.017   701.422     0.150
    75.017   702.910     0.150
    75.153   703.391     0.150
    75.166   703.395     0.150
    75.158   702.430     0.150
    75.163   702.723     0.150
    75.234   703.320     0.150
    75.316   703.691     0.150
    75.331   703.879     0.150
    75.340   704.457     0.150
    75.488   705.125     0.150
    75.512   705.035     0.150
    75.718   706.625     0.150
    75.736   706.125     0.150
    75.765   707.000     0.150
    75.876   707.188     0.150
    75.943   707.926     0.150
    75.998   707.883     0.150
    76.046   708.113     0.150
    76.063   708.406     0.150
    76.304   709.922     0.150
    76.316   709.973     0.150
    76.347   709.949     0.150
    76.414   710.504     0.150
    76.475   710.711     0.150
    76.576   711.797     0.150
    76.608   711.934     0.150
    76.635   711.895     0.150
    76.751   712.398     0.150
    76.773   712.699     0.150
    76.799   713.074     0.150
    77.020   713.297     0.150
    77.030   712.312     0.150
    77.129   713.945     0.150
    77.154   712.715     0.150
    77.347   715.449     0.150
    77.348   715.863     0.150
    77.512   716.961     0.150
    77.529   715.172     0.150
    77.531   715.074     0.150
    77.893   718.922     0.150
    78.057   720.098     0.150
    78.138   720.551     0.150
    78.236   721.598     0.150
    78.304   721.406     0.150
    78.547   722.254     0.150
    78.582   722.727     0.150
    78.789   723.633     0.150
    78.999   724.715     0.150
    79.062   725.164     0.150
    79.072   725.160     0.150
    79.262   726.371     0.150
    79.339   726.359     0.150
    79.656   728.539     0.150
    79.695   728.906     0.150
    79.941   729.953     0.150
    80.074   731.223     0.150
    80.141   730.375     0.150
    80.288   732.047     0.150
    80.463   732.609     0.150
    80.445   731.672     0.150
    80.445   730.414     0.150
    80.521   732.488     0.150
    80.546   732.824     0.150
    80.689   734.293     0.150
    80.700   733.582     0.150
    80.700   733.715     0.150
    80.766   734.332     0.150
    80.766   734.953     0.150
    80.763   734.824     0.150
    80.773   734.512     0.150
    80.916   735.070     0.150
    81.029   735.832     0.150
    81.089   734.773     0.150
    81.203   736.832     0.150
    81.278   737.023     0.150
    81.358   738.000     0.150
    81.412   738.184     0.150
    81.468   738.145     0.150
    81.644   738.941     0.150
    81.744   740.348     0.150
    81.863   740.086     0.150
    82.222   742.590     0.150
    82.859   745.203     0.150
    83.153   746.883     0.150
    83.544   748.965     0.150
    83.967   751.008     0.150
    84.367   752.840     0.150
    84.419   751.883     0.150
    84.426   752.684     0.150
    84.954   756.199     0.150
    85.205   756.293     0.150
    85.251   757.660     0.150
    86.214   761.473     0.150
    87.251   765.973     0.150
    87.320   766.375     0.150
    88.931   774.074     0.150
    91.446   786.898     0.150
   136.488  1160.574     0.150
   145.319  1175.375     0.150
   145.813  1176.934     0.150
   145.813  1177.059     0.150
   150.108  1189.273     0.150
   150.108  1193.672     0.150
   150.108  1198.574     0.150
   150.108  1188.875     0.150
   151.571  1193.074     0.150
   151.571  1202.875     0.150
   151.865  1193.773     0.150
   151.865  1203.574     0.150
   152.299  1194.375     0.150
   152.299  1202.973     0.150
     0.164     3.992     0.150
     0.164     8.195     0.150
     0.164     4.094     0.150
     0.223     4.594     0.150
     0.223     4.492     0.150
     0.223     4.789     0.150
     0.223     8.492     0.150
     1.173    21.695     0.150
     1.173    21.492     0.150
     1.173    38.094     0.150
     1.190    21.695     0.150
     1.190    38.391     0.150
     1.342    24.391     0.150
     1.342    24.492     0.150
     2.252    37.195     0.150
     2.252    39.789     0.150
     2.252    64.891     0.150
     2.252    68.492     0.150
     2.402    38.789     0.150
     2.402    42.594     0.150
     2.544    44.891     0.150
     2.544    79.289     0.150
     3.211    50.789     0.150
     3.211    58.594     0.150
     3.211   100.992     0.150
     3.292    51.891     0.150
     3.292    59.094     0.150
     3.292    91.391     0.150
     3.292   101.492     0.150
     3.866    68.195     0.150
     3.866   119.695     0.150
     3.866    59.492     0.150
     3.866   120.289     0.150
     4.220    75.695     0.150
     4.220   130.789     0.150
     4.321   133.289     0.150
     4.452    68.492     0.150
     4.452   118.695     0.150
     4.452   138.391     0.150
     4.444    79.891     0.150
     4.444   137.695     0.150
     4.756   147.094     0.150
     4.797   148.594     0.150
     5.121    76.195     0.150
     5.121   159.695     0.150
     6.369   194.695     0.150
     6.382   198.594     0.150
     7.591   196.891     0.150
     7.591   192.789     0.150
     7.675   194.695     0.150
     7.675   234.891     0.150
     0.151     3.570     0.150
     0.151     6.469     0.150
     0.241     4.969     0.150
     0.241     8.367     0.150
     0.241     9.367     0.150
     1.142    20.969     0.150
     1.142    36.969     0.150
     1.142    36.867     0.150
     1.241    40.773     0.150
     1.387    25.367     0.150
     1.387    44.172     0.150
     1.387    44.070     0.150
     2.324    38.172     0.150
     2.324    41.070     0.150
     2.324    66.969     0.150
     2.324    71.273     0.150
     2.484    43.672     0.150
     2.484    78.070     0.150
     2.484    39.773     0.150
     2.484    43.570     0.150
     2.484    77.969     0.150
     2.474    41.070     0.150
     2.474    44.773     0.150
     3.143    50.867     0.150
     3.143    55.570     0.150
     3.143    98.672     0.150
     3.217    51.070     0.150
     3.217    56.367     0.150
     3.217    59.570     0.150
     3.217    90.172     0.150
     3.217    99.469     0.150
     3.939   121.969     0.150
     3.939    70.867     0.150
     3.939   122.070     0.150
     4.249   131.969     0.150
     4.378    66.773     0.150
     4.378   116.773     0.150
     4.378   134.773     0.150
     4.375    66.969     0.150
     4.375   116.469     0.150
     4.375   136.367     0.150
     4.689   145.867     0.150
     4.870   151.570     0.150
     5.174    76.867     0.150
     5.174   133.273     0.150
     5.174   160.172     0.150
     5.619   174.273     0.150
     6.293   164.367     0.150
     6.293   193.070     0.150
     6.293   160.273     0.150
     6.293   192.867     0.150
     6.348    92.867     0.150
     6.348   197.672     0.150
     6.673   205.469     0.150
     6.673    97.070     0.150
     6.673   170.969     0.150
     6.673   205.570     0.150
     7.433   228.273     0.150
     7.514   110.672     0.150
     7.514   192.469     0.150
     7.514   110.773     0.150
     7.514   192.273     0.150
     7.514   231.070     0.150
     7.599   110.867     0.150
     7.599   192.672     0.150
     7.599   111.273     0.150
     7.599   192.367     0.150
     7.599   234.570     0.150
     0.086     2.113     0.150
     0.086     4.012     0.150
     0.557    10.113     0.150
     0.557    10.512     0.150
     0.557    18.412     0.150
     1.079    19.912     0.150
     1.079    34.713     0.150
     1.382    25.012     0.150
     1.382    43.912     0.150
     1.382    46.912     0.150
     1.790    31.912     0.150
     1.790    55.512     0.150
     1.835    33.113     0.150
     1.835    33.812     0.150
     1.835    58.613     0.150
     1.835    56.912     0.150
     1.835    58.512     0.150
     2.325    39.812     0.150
     2.325    41.613     0.150
     2.325    70.213     0.150
     2.325    73.613     0.150
     2.325    42.613     0.150
     2.325    72.012     0.150
     2.706    49.312     0.150
     2.706    84.713     0.150
     3.187    51.312     0.150
     3.187    56.012     0.150
     3.187    99.113     0.150
     3.961    61.812     0.150
     3.961    71.512     0.150
     3.961   108.812     0.150
     3.961   122.912     0.150
     4.032   125.713     0.150
     4.243    65.812     0.150
     4.243    75.412     0.150
     4.243   131.412     0.150
     5.383   166.113     0.150
     5.474   170.312     0.150
     5.696   177.113     0.150
     5.935   108.213     0.150
     5.935   185.812     0.150
     6.398   104.912     0.150
     6.398   197.713     0.150
     7.350   228.312     0.150
     8.818   273.012     0.150
     0.400     8.090     0.150
     0.400    15.389     0.150
     1.026    17.988     0.150
     1.026    32.590     0.150
     1.026    32.488     0.150
     1.669    29.590     0.150
     1.669    30.389     0.150
     1.669    52.889     0.150
     1.669    29.289     0.150
     1.669    30.090     0.150
     1.963    32.090     0.150
     1.963    33.389     0.150
     1.963    58.689     0.150
     1.963    31.889     0.150
     1.963    58.289     0.150
     2.233    36.488     0.150
     2.233    39.189     0.150
     2.233    69.789     0.150
     2.233    39.889     0.150
     2.844    44.389     0.150
     2.844    51.590     0.150
     2.844    88.189     0.150
     2.844    44.689     0.150
     2.844    51.189     0.150
     2.844    88.789     0.150
     3.010    47.689     0.150
     3.010    54.488     0.150
     3.010    93.689     0.150
     3.010    47.289     0.150
     3.010    54.289     0.150
     3.751    58.090     0.150
     3.751   114.689     0.150
     3.811    58.090     0.150
     3.811    68.689     0.150
     3.811   118.488     0.150
     3.868    69.488     0.150
     3.868   120.689     0.150
     3.868    57.789     0.150
     3.868    69.590     0.150
     3.982    60.189     0.150
     3.982    70.789     0.150
     3.982   123.988     0.150
     3.982    69.689     0.150
     3.982   122.289     0.150
     4.087    61.988     0.150
     4.087    72.488     0.150
     4.087   125.090     0.150
     4.087   126.090     0.150
     5.222    77.689     0.150
     5.222   160.090     0.150
     5.222   161.090     0.150
     5.297    78.988     0.150
     5.297   163.689     0.150
     5.525   171.988     0.150
     5.570   163.189     0.150
     6.225    90.389     0.150
     6.408   104.488     0.150
     6.510    95.090     0.150
     6.538    95.488     0.150
     6.538   189.789     0.150
     6.538   201.289     0.150
     7.193   103.889     0.150
     7.193   103.779     0.150
     7.647   111.488     0.150
     7.637   108.289     0.150
     7.637   191.289     0.150
     8.245   209.689     0.150
     8.520   122.789     0.150
     8.520   264.189     0.150
     8.690   124.889     0.150
     8.690   140.488     0.150
     8.690   156.189     0.150
     8.690   218.689     0.150
     8.690   267.189     0.150
     9.172   131.289     0.150
     9.172   289.416     0.150
    10.366   148.889     0.150
    10.366   147.430     0.150
    11.559   164.988     0.150
    12.573   176.289     0.150
    12.687   180.090     0.150
    15.096   213.789     0.150
    15.096   219.590     0.150
    15.096   391.189     0.150
    15.096   734.090     0.150
    15.096   947.789     0.150
    15.223   220.590     0.150
    15.223   521.090     0.150
    15.223   212.988     0.150
    15.457   216.590     0.150
    15.971   225.840     0.150
    15.971   229.379     0.150
    16.550   229.059     0.150
    16.550   229.314     0.150
    16.550   516.215     0.150
    16.565   229.289     0.150
    17.122   425.189     0.150
    17.172   237.988     0.150
    17.416   243.789     0.150
    17.831   248.090     0.150
    17.831   257.289     0.150
    17.831   446.590     0.150
    18.821   259.189     0.150
    18.821   468.090     0.150
    18.821   478.289     0.150
    18.821   493.289     0.150
    19.829   271.289     0.150
    20.183   274.289     0.150
    20.410   277.090     0.150
    20.410   297.889     0.150
    20.410   499.389     0.150
    20.410   529.389     0.150
    20.410   742.389     0.150
    20.410   964.090     0.150
    20.731   279.789     0.150
    20.844   281.139     0.150
    20.844   656.639     0.150
    20.863   282.789     0.150
    20.863   519.590     0.150
    20.863   539.289     0.150
    21.317   286.189     0.150
    21.317   284.689     0.150
    21.317   285.000     0.150
    21.346   285.789     0.150
    21.346   285.789     0.150
    21.346   534.789     0.150
    21.920   291.238     0.150
    22.069   294.189     0.150
    22.069   534.889     0.150
    22.069   567.189     0.150
    22.069   972.090     0.150
    24.118   316.090     0.150
    24.118   579.689     0.150
    24.923   320.689     0.150
    24.923   321.477     0.150
    24.968   322.090     0.150
    24.968   321.789     0.150
    25.334   324.590     0.150
    25.364   326.689     0.150
    25.364   593.090     0.150
    25.364   603.590     0.150
    25.494   326.189     0.150
    25.579   324.789     0.150
    25.579   596.289     0.150
    25.581   326.400     0.150
    25.892   331.590     0.150
    25.892   540.189     0.150
    25.892   598.789     0.150
    25.892   610.590     0.150
    25.892   665.590     0.150
    25.892   985.090     0.150
    26.053   331.590     0.150
    26.732   337.090     0.150
    26.732     6.398     0.150
    27.479   345.689     0.150
    27.479   346.000     0.150
    27.576   347.129     0.150
    27.859   349.789     0.150
    28.078   352.289     0.150
    28.078   398.289     0.150
    28.233   353.840     0.150
    28.656   356.670     0.150
    29.916   364.289     0.150
    29.916   544.689     0.150
    29.916   660.488     0.150
    29.812   367.090     0.150
    29.812   426.289     0.150
    29.812   552.689     0.150
    29.812   664.289     0.150
    29.812   759.889     0.150
    30.187   368.789     0.150
    31.718   382.689     0.150
    31.718   450.889     0.150
    31.718   692.789     0.150
    31.718   705.389     0.150
    32.496   388.590     0.150
    34.020   403.189     0.150
    34.255   405.789     0.150
    34.349   406.389     0.150
    34.584   407.988     0.150
    34.609   408.789     0.150
    34.691   409.689     0.150
    34.748   410.189     0.150
    34.763   410.590     0.150
    34.815   410.090     0.150
    34.840   410.889     0.150
    35.337   415.090     0.150
    35.712   416.590     0.150
    36.863   508.289     0.150
    36.863   565.289     0.150
    36.894   429.189     0.150
    36.894   774.189     0.150
    37.030   428.139     0.150
    37.030     6.990     0.150
    37.203   428.988     0.150
    37.444   430.680     0.150
    37.444     5.125     0.150
    37.935   436.590     0.150
    38.144   436.689     0.150
    38.714   441.465     0.150
    38.605   442.189     0.150
    38.605     6.100     0.150
    38.951   444.389     0.150
    38.951   574.439     0.150
    39.684   448.590     0.150
    40.615   459.689     0.150
    41.463   465.889     0.150
    41.463     3.801     0.150
    41.463   560.389     0.150
    41.463   580.090     0.150
    42.017   469.889     0.150
    42.091   468.289     0.150
    42.428   472.090     0.150
    42.536   474.369     0.150
    42.915   477.689     0.150
    43.174  1074.090     0.150
    43.734   484.469     0.150
    43.734     5.650     0.150
    44.139   488.090     0.150
    44.208   485.289     0.150
    44.363   489.770     0.150
    44.430   489.908     0.150
    44.698   492.090     0.150
    44.698   491.988     0.150
    44.719   492.398     0.150
    44.719     5.801     0.150
    45.026   495.389     0.150
    45.026     5.100     0.150
    45.156   496.289     0.150
    45.156   495.789     0.150
    45.156   601.090     0.150
    45.156   495.988     0.150
    45.903   503.289     0.150
    46.296   503.988     0.150
    46.391   504.549     0.150
    46.391     5.650     0.150
    46.578   506.090     0.150
    46.625   507.289     0.150
    46.959   509.398     0.150
    47.396   512.840     0.150
    47.396     5.699     0.150
    47.469   513.590     0.150
    47.676   513.689     0.150
    47.676     4.924     0.150
    47.688   513.189     0.150
    47.828   515.539     0.150
    48.008   516.898     0.150
    48.008     6.010     0.150
    48.225     5.539     0.150
    48.359   520.689     0.150
    48.359     5.920     0.150
    48.446   519.189     0.150
    48.446   519.215     0.150
    50.365   535.309     0.150
    50.932   541.709     0.150
    50.932     5.330     0.150
    51.372   544.389     0.150
    51.372     5.900     0.150
    51.372   544.689     0.150
    52.186   548.689     0.150
    52.180   549.689     0.150
    52.328   550.189     0.150
    52.324   549.289     0.150
    52.324     6.000     0.150
    52.589   549.189     0.150
    52.677   553.889     0.150
    52.834   553.988     0.150
    53.493   559.090     0.150
    53.765   559.488     0.150
    53.765     6.201     0.150
    53.897   561.889     0.150
    53.897     4.701     0.150
    53.920     5.100     0.150
    54.023   562.889     0.150
    54.023   563.090     0.150
    54.299   565.738     0.150
    54.538   566.389     0.150
    54.538     5.500     0.150
    54.558   565.488     0.150
    54.558     5.801     0.150
    54.558  1039.289     0.150
    54.558   565.590     0.150
    54.558     5.500     0.150
    54.643   566.189     0.150
    54.643     5.199     0.150
    54.643   566.389     0.150
    54.643     5.000     0.150
    54.643     8.100     0.150
    54.643  1036.289     0.150
    54.744   575.090     0.150
    54.946   569.389     0.150
    54.946     4.801     0.150
    55.036   569.488     0.150
    55.724   574.590     0.150
    55.724   574.789     0.150
    55.724     5.100     0.150
    55.852   575.689     0.150
    55.873   576.775     0.150
    55.875   576.775     0.150
    56.003   576.789     0.150
    56.003     5.400     0.150
    56.126   577.488     0.150
    56.126     5.602     0.150
    56.156   576.684     0.150
    56.156     5.250     0.150
    56.161   578.090     0.150
    56.161   577.201     0.150
    56.161     5.701     0.150
    56.530   581.730     0.150
    56.606   581.189     0.150
    56.606     5.299     0.150
    56.606   581.189     0.150
    56.606     5.299     0.150
    56.612   581.520     0.150
    56.612     5.770     0.150
    56.652   582.748     0.150
    57.181   585.693     0.150
    57.528   588.486     0.150
    57.644   589.289     0.150
    58.075   591.578     0.150
    58.075     4.361     0.150
    58.170   597.689     0.150
    58.877   596.689     0.150
    59.878   604.010     0.150
    61.229   613.590     0.150
    61.767   618.789     0.150
    62.070   619.170     0.150
    62.151   619.488     0.150
    63.209   627.398     0.150
    63.485   628.590     0.150
    63.593   627.988     0.150
    64.205   635.988     0.150
    64.639   635.090     0.150
    65.678   641.920     0.150
    65.794   642.781     0.150
    66.003   643.590     0.150
    66.003     6.100     0.150
    66.200   645.879     0.150
    66.294   645.887     0.150
    66.307   646.232     0.150
    66.344   646.279     0.150
    66.424   647.109     0.150
    66.424     6.230     0.150
    66.444   647.859     0.150
    66.478   647.473     0.150
    66.643   648.459     0.150
    66.844   649.859     0.150
    66.937   650.266     0.150
    67.143   652.156     0.150
    67.163   652.004     0.150
    67.273   653.408     0.150
    67.277   653.348     0.150
    67.468   653.832     0.150
    67.472   653.729     0.150
    67.472     6.051     0.150
    67.487   654.115     0.150
    67.554   654.846     0.150
    67.713   655.889     0.150
    67.738   655.316     0.150
    67.793   656.344     0.150
    67.918   657.600     0.150
    67.932   656.789     0.150
    67.932     5.900     0.150
    67.950   657.295     0.150
    67.974   657.293     0.150
    68.015   657.762     0.150
    68.166   658.678     0.150
    68.177   658.875     0.150
    68.193   658.680     0.150
    68.193     5.689     0.150
    68.202   658.520     0.150
    68.202     6.719     0.150
    68.209   659.229     0.150
    68.417   659.723     0.150
    68.586   661.703     0.150
    68.613   661.191     0.150
    68.649   661.348     0.150
    68.776   662.809     0.150
    68.952   663.172     0.150
    69.100   664.518     0.150
    69.149   664.787     0.150
    69.238   665.277     0.150
    69.257   665.305     0.150
    69.373   666.391     0.150
    69.407   666.561     0.150
    69.435   666.246     0.150
    69.510   667.014     0.150
    69.560   667.041     0.150
    69.572   667.061     0.150
    69.649   666.840     0.150
    69.649     5.824     0.150
    69.670   668.289     0.150
    69.738   668.482     0.150
    69.742   668.541     0.150
    69.797   668.496     0.150
    69.912   669.238     0.150
    69.925   669.713     0.150
    69.957   669.695     0.150
    69.976   669.721     0.150
    70.096   670.822     0.150
    70.192   671.318     0.150
    70.321   671.396     0.150
    70.321   671.170     0.150
    70.345   672.158     0.150
    70.360   672.404     0.150
    70.425   672.332     0.150
    70.464   672.852     0.150
    70.563   673.518     0.150
    70.654   674.053     0.150
    70.699   673.904     0.150
    70.712   674.490     0.150
    70.733   674.715     0.150
    70.744   674.979     0.150
    70.748   674.236     0.150
    70.834   675.475     0.150
    70.928   675.963     0.150
    70.941   675.836     0.150
    70.946   675.527     0.150
    71.006   676.170     0.150
    71.049   676.303     0.150
    71.049     5.699     0.150
    71.280   677.945     0.150
    71.305   678.074     0.150
    71.310   677.945     0.150
    71.339   678.441     0.150
    71.451   682.590     0.150
    71.446   679.381     0.150
    71.518   679.004     0.150
    71.524   679.549     0.150
    71.528   679.537     0.150
    71.538   679.793     0.150
    71.661   679.779     0.150
    71.704   680.430     0.150
    71.701   680.520     0.150
    71.765   680.764     0.150
    71.825   681.475     0.150
    71.920   681.139     0.150
    71.920     7.170     0.150
    71.995   681.689     0.150
    72.078   682.742     0.150
    72.130   682.822     0.150
    72.130   682.982     0.150
    72.148   683.066     0.150
    72.154   683.512     0.150
    72.170   682.762     0.150
    72.359   684.711     0.150
    72.375   684.916     0.150
    72.470   685.402     0.150
    72.494   684.629     0.150
    72.494     5.650     0.150
    72.579   685.523     0.150
    72.586   686.189     0.150
    72.586     6.500     0.150
    72.644   686.338     0.150
    72.657   686.299     0.150
    72.663   686.498     0.150
    72.708   686.805     0.150
    72.757   686.865     0.150
    72.881   687.535     0.150
    72.902   687.695     0.150
    72.953   688.021     0.150
    72.980   688.201     0.150
    73.027   688.809     0.150
    73.041   688.828     0.150
    73.111   688.879     0.150
    73.165   689.088     0.150
    73.187   689.270     0.150
    73.204   689.777     0.150
    73.271   691.430     0.150
    73.271     5.859     0.150
    73.287   690.217     0.150
    73.295   691.590     0.150
    73.323   688.129     0.150
    73.323     5.820     0.150
    73.324   690.594     0.150
    73.478   691.145     0.150
    73.548   691.902     0.150
    73.576   691.887     0.150
    73.602   691.959     0.150
    73.639   692.402     0.150
    73.648   692.760     0.150
    73.656   692.469     0.150
    73.653   692.186     0.150
    73.746   693.219     0.150
    73.746   692.953     0.150
    73.797   693.695     0.150
    73.907   694.184     0.150
    73.932   694.436     0.150
    73.939   693.840     0.150
    73.939     6.359     0.150
    73.948   694.920     0.150
    73.948     5.779     0.150
    74.059   695.096     0.150
    74.095   694.459     0.150
    74.105   695.238     0.150
    74.105     5.910     0.150
    74.111   695.088     0.150
    74.113   695.479     0.150
    74.113     6.221     0.150
    74.112   695.439     0.150
    74.133   695.100     0.150
    74.169   695.232     0.150
    74.197   696.260     0.150
    74.197     5.818     0.150
    74.225   696.139     0.150
    74.259   696.158     0.150
    74.259     6.361     0.150
    74.289   696.285     0.150
    74.364   696.588     0.150
    74.373   696.869     0.150
    74.446   695.158     0.150
    74.446     6.500     0.150
    74.444   697.371     0.150
    74.457   697.410     0.150
    74.512   697.469     0.150
    74.520   697.609     0.150
    74.653   698.645     0.150
    74.709   699.189     0.150
    74.731   698.994     0.150
    74.748   699.254     0.150
    74.768   698.896     0.150
    75.027   699.830     0.150
    75.078   700.189     0.150
    75.096   700.709     0.150
    75.177   700.848     0.150
    75.187   699.979     0.150
    75.187   699.939     0.150
    75.187     6.049     0.150
    75.213   701.342     0.150
    75.243   701.988     0.150
    75.243     6.102     0.150
    75.312   701.715     0.150
    75.369   702.605     0.150
    75.447   701.689     0.150
    75.447     6.100     0.150
    75.643   703.469     0.150
    75.643     6.270     0.150
    75.756   704.701     0.150
    75.818   704.918     0.150
    75.836   705.055     0.150
    75.837   705.346     0.150
    76.002   705.709     0.150
    76.177   706.633     0.150
    76.211   707.189     0.150
    76.253   707.689     0.150
    76.253     5.900     0.150
    76.287   707.490     0.150
    76.474   708.254     0.150
    76.472   708.328     0.150
    76.533   709.090     0.150
    76.533   708.504     0.150
    76.571   708.801     0.150
    76.620   707.029     0.150
    76.620     6.811     0.150
    76.795   710.057     0.150
    76.809   710.262     0.150
    76.811   709.988     0.150
    76.859   710.582     0.150
    76.866   710.547     0.150
    76.953   711.189     0.150
    76.953     6.400     0.150
    76.998   711.402     0.150
    77.019   711.068     0.150
    76.914   710.260     0.150
    76.914     6.270     0.150
    77.085   711.965     0.150
    77.128   712.500     0.150
    77.186   713.041     0.150
    77.266   712.885     0.150
    77.271   713.178     0.150
    77.278   713.166     0.150
    77.310   713.742     0.150
    77.345   713.676     0.150
    77.476   714.107     0.150
    77.542   713.180     0.150
    77.542     6.090     0.150
    77.545   714.256     0.150
    77.702   714.719     0.150
    77.702     6.670     0.150
    77.557   713.590     0.150
    77.557     6.000     0.150
    77.557     8.699     0.150
    77.564   713.822     0.150
    77.564     5.625     0.150
    77.758   715.422     0.150
    77.846   716.004     0.150
    77.857   716.182     0.150
    77.978   716.814     0.150
    78.104   717.736     0.150
    78.197   718.305     0.150
    78.244   718.475     0.150
    78.373   718.439     0.150
    78.392   719.020     0.150
    78.400   719.072     0.150
    78.508   720.229     0.150
    78.518   720.139     0.150
    78.557   720.531     0.150
    78.659   720.438     0.150
    78.775   720.773     0.150
    78.819   721.049     0.150
    78.838   722.107     0.150
    79.049   722.633     0.150
    79.057   722.488     0.150
    79.057     6.801     0.150
    79.104   722.727     0.150
    79.173   723.643     0.150
    79.200   722.939     0.150
    79.200     6.811     0.150
    79.386   724.637     0.150
    79.507   724.961     0.150
    79.525   725.469     0.150
    79.542   723.590     0.150
    79.542     7.199     0.150
    79.576   725.404     0.150
    79.582   725.754     0.150
    79.589   726.135     0.150
    79.640   725.389     0.150
    79.640     6.141     0.150
    79.711   725.811     0.150
    79.838   726.945     0.150
    79.893   727.777     0.150
    79.926   727.463     0.150
    80.079   728.645     0.150
    80.126   729.111     0.150
    80.147   727.988     0.150
    80.147     7.000     0.150
    80.175   729.596     0.150
    80.257   728.779     0.150
    80.307   729.199     0.150
    80.307   735.568     0.150
    80.333   728.479     0.150
    80.333   735.289     0.150
    80.387   730.049     0.150
    80.387   736.100     0.150
    80.499   730.355     0.150
    80.575   730.943     0.150
    80.615   731.182     0.150
    80.615   737.449     0.150
    80.719   732.195     0.150
    80.599   730.715     0.150
    80.599   736.764     0.150
    80.599   731.090     0.150
    80.794   732.016     0.150
    80.803   732.334     0.150
    80.916   733.453     0.150
    80.925   732.988     0.150
    80.925   739.289     0.150
    80.965   733.291     0.150
    81.002   732.738     0.150
    81.002   739.100     0.150
    81.040   733.637     0.150
    81.204   734.744     0.150
    81.259   735.072     0.150
    81.259   741.029     0.150
    81.112   733.289     0.150
    81.271   735.408     0.150
    81.271   734.572     0.150
    81.425   735.777     0.150
    81.547   736.082     0.150
    81.547   736.207     0.150
    81.592   736.854     0.150
    81.706   737.242     0.150
    81.792   737.857     0.150
    81.912   738.318     0.150
    81.961   737.529     0.150
    81.961   744.029     0.150
    81.977   737.180     0.150
    81.977   743.398     0.150
    81.977   739.074     0.150
    82.150   739.469     0.150
    82.241   740.410     0.150
    82.315   740.633     0.150
    82.365   740.836     0.150
    82.524   741.641     0.150
    82.627   742.033     0.150
    82.720   742.555     0.150
    82.932   743.615     0.150
    83.099   744.521     0.150
    83.236   743.869     0.150
    83.236   750.459     0.150
    83.290   745.369     0.150
    83.232   745.738     0.150
    83.232     6.176     0.150
    83.232   746.289     0.150
    83.232   745.568     0.150
    83.328   745.889     0.150
    83.328     6.100     0.150
    83.376   746.176     0.150
    83.587   747.291     0.150
    83.847   748.785     0.150
    84.355   750.729     0.150
    84.751   752.289     0.150
    84.751     6.000     0.150
    84.780   751.959     0.150
    84.780     6.359     0.150
    84.867   753.723     0.150
    84.942   753.959     0.150
    85.451   757.021     0.150
    85.629   756.889     0.150
    87.638   766.889     0.150
    87.640   766.068     0.150
    87.738   767.000     0.150
    89.398   775.189     0.150
    89.398     6.674     0.150
    89.409   774.988     0.150
    89.890   776.889     0.150
    89.890     6.201     0.150
    90.982   782.059     0.150
    90.982     5.871     0.150
    90.982   781.840     0.150
    90.982     5.725     0.150
    99.816   821.465     0.150
   140.463  1166.764     0.150
   144.803  1174.090     0.150
   144.836  1171.389     0.150
   145.639  1174.975     0.150
   145.639  1181.000     0.150
   146.727  1179.975     0.150
   146.727  1186.424     0.150
   146.727  1180.109     0.150
   149.628  1185.926     0.150
   149.628  1192.227     0.150
   151.080  1189.590     0.150
   151.080  1195.590     0.150
   151.369  1190.889     0.150
   151.369  1196.689     0.150
   151.813  1190.988     0.150
   155.701  1217.689     0.150
   164.609  1256.215     0.150
   164.609  1262.613     0.150
     0.113     2.206     0.150
     0.113     3.606     0.150
     0.113     3.406     0.150
     0.744    14.006     0.150
     0.744    25.306     0.150
     1.024    19.706     0.150
     1.024    33.206     0.150
     1.360    25.306     0.150
     1.360    43.706     0.150
     1.360    44.906     0.150
     1.228    22.606     0.150
     1.228    39.506     0.150
     1.228    22.506     0.150
     1.228    40.006     0.150
     1.613    29.206     0.150
     1.613    50.006     0.150
     1.918    35.006     0.150
     1.918    35.406     0.150
     1.918    59.906     0.150
     1.918    60.906     0.150
     1.918    62.106     0.150
     2.296    39.206     0.150
     2.296    41.906     0.150
     2.296    69.606     0.150
     2.296    39.606     0.150
     2.698    44.906     0.150
     2.698    49.506     0.150
     2.698    84.506     0.150
     2.698    49.806     0.150
     2.698    77.206     0.150
     2.698    85.106     0.150
     3.291    53.006     0.150
     3.291    57.806     0.150
     3.291   101.106     0.150
     3.291    53.106     0.150
     3.291    59.006     0.150
     3.291    60.606     0.150
     3.291   102.406     0.150
     3.625    58.006     0.150
     3.625    66.306     0.150
     3.625    99.906     0.150
     3.625   113.906     0.150
     4.072    73.406     0.150
     4.072   126.506     0.150
     4.082    63.106     0.150
     4.082    73.706     0.150
     4.082   109.306     0.150
     4.082   126.806     0.150
     4.082   127.206     0.150
     4.218    63.906     0.150
     4.218    75.106     0.150
     4.218   114.006     0.150
     4.218   132.406     0.150
     4.218    74.806     0.150
     4.218    76.406     0.150
     4.218   116.906     0.150
     4.218   133.206     0.150
     4.301    66.806     0.150
     4.301    77.806     0.150
     4.301   132.406     0.150
     4.301    66.906     0.150
     4.301    77.406     0.150
     4.301   132.806     0.150
     5.448    82.706     0.150
     5.448   143.406     0.150
     5.448   167.206     0.150
     5.448    83.206     0.150
     5.448   167.806     0.150
     5.577   173.506     0.150
     5.783   179.706     0.150
     5.825   181.206     0.150
     6.033   187.906     0.150
     6.310   196.506     0.150
     6.308   188.206     0.150
     6.308   195.306     0.150
     6.413    95.306     0.150
     6.413   199.406     0.150
     6.576    96.606     0.150
     6.576   205.906     0.150
     6.738   207.306     0.150
     6.745   208.906     0.150
     6.745   177.106     0.150
     6.745   208.206     0.150
     7.407   121.526     0.150
     7.407   226.516     0.150
     7.407   123.406     0.150
     7.407   191.806     0.150
     7.407   228.906     0.150
     7.836   200.006     0.150
     7.836   115.106     0.150
     7.836   200.106     0.150
     7.836   242.406     0.150
     7.836   241.206     0.150
     7.920   115.306     0.150
     8.486   264.906     0.150
     8.486   125.606     0.150
     8.486   263.406     0.150
     8.697   127.006     0.150
     8.697   127.406     0.150
     8.697   156.106     0.150
     8.697   225.206     0.150
     8.697   269.706     0.150
     8.826   128.406     0.150
     8.826   128.306     0.150
     8.826   227.006     0.150
     8.826   274.406     0.150
     9.279   136.006     0.150
     9.487   138.406     0.150
     9.487   300.086     0.150
    10.109   145.806     0.150
    10.109   143.646     0.150
    13.043   184.206     0.150
    15.214   213.006     0.150
    15.447   219.406     0.150
    15.447   223.206     0.150
    16.550   231.126     0.150
    16.550   231.931     0.150
    16.792   238.559     0.150
    17.149   238.106     0.150
    19.126   273.806     0.150
    19.126   276.106     0.150
    21.119   675.056     0.150
    21.119   288.156     0.150
    21.198   288.506     0.150
    21.198   520.306     0.150
    21.198   529.406     0.150
    21.345   288.956     0.150
    21.345   679.381     0.150
    21.345   287.406     0.150
    21.345   286.886     0.150
    21.439   288.956     0.150
    21.450   289.306     0.150
    21.450   289.481     0.150
    21.450   289.606     0.150
    24.456   319.906     0.150
    24.883   323.206     0.150
    24.883   323.293     0.150
    24.927   323.806     0.150
    25.392   330.396     0.150
    26.232   337.906     0.150
    26.232   607.906     0.150
    26.232   614.506     0.150
    26.232   675.506     0.150
    26.452   338.006     0.150
    26.452   377.106     0.150
    26.452   339.986     0.150
    27.583   348.206     0.150
    28.375   356.406     0.150
    28.375   356.556     0.150
    28.751   360.206     0.150
    29.801   368.206     0.150
    29.801   421.106     0.150
    29.801   665.106     0.150
    29.801   753.206     0.150
    29.801   366.616     0.150
    30.160   373.006     0.150
    30.160   670.806     0.150
    30.160   774.106     0.150
    30.259   372.506     0.150
    32.458   389.906     0.150
    32.458   390.766     0.150
    37.125   430.961     0.150
    37.872   438.506     0.150
    38.441   441.481     0.150
    39.459   449.206     0.150
    41.862   471.706     0.150
    42.312   473.506     0.150
    42.325   473.731     0.150
    44.789   494.806     0.150
    45.090   496.606     0.150
    45.090   601.206     0.150
    45.090   895.606     0.150
    45.090   497.236     0.150
    46.436   507.531     0.150
    46.436   507.806     0.150
    47.317   513.606     0.150
    47.317     3.600     0.150
    47.520   514.806     0.150
    47.520   516.506     0.150
    47.533   515.306     0.150
    47.533   514.706     0.150
    48.195   520.350     0.150
    51.536   546.456     0.150
    51.549   546.606     0.150
    51.627   548.306     0.150
    52.223   554.606     0.150
    52.462   554.006     0.150
    52.696   555.406     0.150
    52.878   557.166     0.150
    52.878   557.056     0.150
    53.175   560.206     0.150
    53.337   560.506     0.150
    53.579   560.406     0.150
    53.579   561.606     0.150
    53.704   563.306     0.150
    53.704   563.006     0.150
    54.344   567.806     0.150
    54.356   567.316     0.150
    54.712   570.706     0.150
    55.807   578.206     0.150
    55.826   577.060     0.150
    55.967   578.956     0.150
    56.158   581.606     0.150
    56.401   582.106     0.150
    56.555   582.976     0.150
    57.852   591.556     0.150
    59.046   600.006     0.150
    61.060   614.806     0.150
    61.361   615.706     0.150
    61.557   618.406     0.150
    61.564   618.106     0.150
    61.670   618.206     0.150
    61.868   618.706     0.150
    61.869   618.806     0.150
    61.926   620.206     0.150
    61.949   620.506     0.150
    62.398   623.606     0.150
    62.960   626.606     0.150
    63.074   627.106     0.150
    63.274   628.906     0.150
    63.507   630.306     0.150
    63.582   630.506     0.150
    65.667   644.406     0.150
    66.733   651.306     0.150
    68.710   665.187     0.150
    69.253   668.666     0.150
    69.299   668.481     0.150
    69.644   671.286     0.150
    70.011   673.226     0.150
    70.829   677.781     0.150
    71.608   682.836     0.150
    71.682   683.106     0.150
    72.017   685.876     0.150
    72.292   687.106     0.150
    72.675   690.126     0.150
    72.794   690.276     0.150
    73.626   695.006     0.150
    74.873   701.486     0.150
    74.873   701.606     0.150
    75.122   702.606     0.150
    75.964   708.131     0.150
    77.382   717.766     0.150
    77.883   717.931     0.150
    78.611   722.976     0.150
    78.739   724.706     0.150
    80.686   734.856     0.150
    81.433   737.306     0.150
    81.644   737.766     0.150
    83.016   747.406     0.150
    83.334   749.106     0.150
    84.438   753.796     0.150
    85.302   758.706     0.150
    86.219   762.606     0.150
    89.085   777.031     0.150
    90.860   783.806     0.150
   145.989  1178.539     0.150
   146.376  1183.516     0.150
   149.405  1187.981     0.150
   149.405  1188.506     0.150
   151.380  1194.206     0.150
     0.484     9.516     0.150
     0.484    16.609     0.150
     0.530    10.414     0.150
     0.530    18.211     0.150
     0.530    17.812     0.150
     0.796    15.211     0.150
     0.796    26.914     0.150
     0.796    15.312     0.150
     0.796    27.109     0.150
     0.993    18.609     0.150
     0.993    32.312     0.150
     0.993    32.211     0.150
     1.406    25.312     0.150
     1.406    44.016     0.150
     1.406    25.109     0.150
     1.406    43.914     0.150
     1.877    32.414     0.150
     1.877    33.914     0.150
     1.877    57.516     0.150
     1.877    59.516     0.150
     1.877    32.211     0.150
     1.877    57.414     0.150
     2.571    42.109     0.150
     2.571    46.914     0.150
     2.571    74.312     0.150
     2.571    81.312     0.150
     2.776    44.812     0.150
     2.776    49.312     0.150
     2.776    77.312     0.150
     2.776    85.211     0.150
     2.727    44.609     0.150
     2.727    48.211     0.150
     2.727    48.914     0.150
     2.727    77.312     0.150
     2.727    84.414     0.150
     2.885    45.414     0.150
     2.885    50.016     0.150
     2.885    81.312     0.150
     2.885    88.211     0.150
     2.885    45.016     0.150
     2.885    50.414     0.150
     3.675    55.812     0.150
     3.675    66.211     0.150
     3.675    99.711     0.150
     3.675   112.609     0.150
     3.710    57.609     0.150
     3.710    66.414     0.150
     3.710   117.312     0.150
     3.881    60.016     0.150
     3.881    69.312     0.150
     3.881   105.812     0.150
     3.881   117.312     0.150
     3.881   119.211     0.150
     3.881    60.312     0.150
     3.881    69.609     0.150
     3.881   105.016     0.150
     3.881   118.914     0.150
     4.111    63.516     0.150
     4.111   127.609     0.150
     4.247    65.211     0.150
     4.247    77.609     0.150
     4.247   132.516     0.150
     4.297    65.414     0.150
     4.297    76.914     0.150
     4.297   133.609     0.150
     4.541    69.211     0.150
     4.541   140.211     0.150
     5.166    76.516     0.150
     5.166   132.812     0.150
     5.166   161.109     0.150
     5.166    76.414     0.150
     5.166    76.812     0.150
     5.166    79.312     0.150
     5.166   133.812     0.150
     5.166   159.914     0.150
     5.166   158.109     0.150
     5.170    76.914     0.150
     5.170   135.711     0.150
     5.170   159.812     0.150
     5.758   151.016     0.150
     5.758   178.016     0.150
     5.758   178.609     0.150
     5.831    85.312     0.150
     5.831   150.914     0.150
     5.831   179.211     0.150
     5.831    85.516     0.150
     5.831   150.812     0.150
     5.831   177.812     0.150
     5.831    84.312     0.150
     5.831    86.109     0.150
     6.007    88.711     0.150
     6.007   185.414     0.150
     6.257    91.211     0.150
     6.257   159.016     0.150
     6.257   192.414     0.150
     6.929   101.609     0.150
     6.929   203.812     0.150
     6.929   216.211     0.150
     7.123   104.711     0.150
     7.123   181.711     0.150
     7.123   220.609     0.150
     7.123   181.516     0.150
     7.123   218.109     0.150
     7.750   112.211     0.150
     7.760   112.211     0.150
     7.808   113.812     0.150
     7.808   113.711     0.150
     7.970   115.523     0.150
     8.082   113.750     0.150
     8.139   118.734     0.150
     8.139   209.133     0.150
     8.139   258.055     0.150
    10.340   145.312     0.150
    10.604   152.016     0.150
    11.288   161.414     0.150
    11.572   163.312     0.150
    11.663   162.516     0.150
    14.568   205.711     0.150
    14.568   211.109     0.150
    14.568   387.211     0.150
    14.816   210.812     0.150
    15.278   214.312     0.150
    15.278   480.109     0.150
    15.731   407.516     0.150
    15.752   224.969     0.150
    15.837   227.609     0.150
    15.945   221.609     0.150
    15.972   224.211     0.150
    15.972   735.312     0.150
    15.972   736.609     0.150
    16.229   225.711     0.150
    17.428   243.539     0.150
    17.428   548.734     0.150
    17.710   246.312     0.150
    17.710   442.609     0.150
    17.710   464.516     0.150
    17.939   255.711     0.150
    19.014   261.609     0.150
    19.014   497.312     0.150
    19.626   280.016     0.150
    19.951   270.516     0.150
    19.951   270.914     0.150
    19.998   272.414     0.150
    19.998   271.000     0.150
    19.998   630.984     0.150
    19.998   271.312     0.150
    19.962   272.516     0.150
    20.090   272.391     0.150
    20.090   630.984     0.150
    21.246   285.562     0.150
    21.246   673.859     0.150
    21.246   285.562     0.150
    21.246   673.859     0.150
    21.376   310.312     0.150
    21.376   531.312     0.150
    21.420   287.312     0.150
    23.027   305.844     0.150
    23.506   308.109     0.150
    23.722   310.609     0.150
    23.722   310.312     0.150
    23.768   310.914     0.150
    23.768   310.383     0.150
    23.768   310.516     0.150
    24.952   324.711     0.150
    25.043   324.312     0.150
    25.043   539.914     0.150
    25.043   586.109     0.150
    25.043   645.312     0.150
    25.043   984.711     0.150
    25.148   324.742     0.150
    25.319   593.414     0.150
    26.084   333.516     0.150
    26.084   336.156     0.150
    26.357   333.570     0.150
    26.503   340.062     0.150
    26.686   339.312     0.150
    26.891   340.812     0.150
    26.836   341.555     0.150
    26.882   341.016     0.150
    26.882   843.703     0.150
    26.882   340.680     0.150
    27.266   344.312     0.150
    27.266   344.609     0.150
    27.451   345.312     0.150
    27.691   347.414     0.150
    27.965   350.016     0.150
    27.965   394.016     0.150
    27.965   350.195     0.150
    28.222   404.609     0.150
    28.222   548.211     0.150
    28.222   645.414     0.150
    28.222   655.312     0.150
    28.814   357.109     0.150
    28.814   357.211     0.150
    28.905   357.016     0.150
    28.905   407.109     0.150
    28.905   647.914     0.150
    28.905   728.609     0.150
    29.105   362.312     0.150
    29.105   550.211     0.150
    29.105   653.016     0.150
    29.105   768.312     0.150
    29.105  1002.711     0.150
    29.403   364.914     0.150
    30.877   375.312     0.150
    30.877   439.914     0.150
    30.877   681.609     0.150
    30.877   783.711     0.150
    31.286   378.609     0.150
    31.286   378.805     0.150
    31.762   382.711     0.150
    32.777   393.109     0.150
    32.978   395.516     0.150
    33.325   398.812     0.150
    33.340   398.016     0.150
    33.455   399.914     0.150
    33.467   400.109     0.150
    33.468   399.812     0.150
    33.555   400.711     0.150
    33.558   399.312     0.150
    33.999   404.516     0.150
    34.031   404.711     0.150
    35.819   417.609     0.150
    35.819   497.414     0.150
    35.841   417.312     0.150
    36.327   423.711     0.150
    36.327   766.211     0.150
    36.471   422.312     0.150
    37.448   431.383     0.150
    37.793   433.516     0.150
    37.690   434.812     0.150
    37.849   436.711     0.150
    38.038   437.914     0.150
    38.038   572.516     0.150
    38.363   439.039     0.150
    38.363   572.812     0.150
    38.513   442.914     0.150
    39.077   444.016     0.150
    39.542   450.711     0.150
    40.053   455.109     0.150
    40.251   452.914     0.150
    40.251     7.797     0.150
    40.594   553.711     0.150
    41.457   464.609     0.150
    41.457     9.406     0.150
    41.499   464.414     0.150
    41.535   465.609     0.150
    41.535     7.305     0.150
    41.942   468.844     0.150
    41.966   467.711     0.150
    41.966   840.711     0.150
    41.966  1030.016     0.150
    43.677   484.062     0.150
    44.007   486.211     0.150
    44.007   589.211     0.150
    44.007   592.414     0.150
    44.007   878.914     0.150
    44.007  1076.914     0.150
    44.007   488.109     0.150
    44.037   487.016     0.150
    44.341   487.109     0.150
    45.085   493.836     0.150
    45.121   494.125     0.150
    45.247   495.219     0.150
    45.335   495.766     0.150
    45.380   499.562     0.150
    45.327   496.312     0.150
    45.581   499.344     0.150
    45.866   502.211     0.150
    45.919   501.570     0.150
    45.881   501.016     0.150
    46.216   504.312     0.150
    46.251   504.516     0.150
    46.325   504.211     0.150
    46.325   910.609     0.150
    46.783   507.516     0.150
    46.794   507.734     0.150
    46.795   507.312     0.150
    46.882   510.336     0.150
    47.516   514.211     0.150
    47.665   515.516     0.150
    47.792   516.039     0.150
    47.902   516.812     0.150
    47.966   516.812     0.150
    47.966   516.844     0.150
    48.001   518.711     0.150
    48.092   518.562     0.150
    48.759   523.320     0.150
    49.397   527.312     0.150
    50.015   532.312     0.150
    50.582   537.516     0.150
    50.582   537.109     0.150
    50.621   538.414     0.150
    50.652   538.516     0.150
    50.709   538.414     0.150
    50.794   539.312     0.150
    50.826   539.812     0.150
    50.977   540.711     0.150
    51.227   543.109     0.150
    51.277   543.109     0.150
    51.336   543.414     0.150
    51.336   617.211     0.150
    51.329   542.414     0.150
    51.302   543.336     0.150
    51.328   542.812     0.150
    51.418   543.914     0.150
    51.533   543.109     0.150
    51.604   545.109     0.150
    51.747   543.914     0.150
    51.747   616.516     0.150
    51.747   662.516     0.150
    51.758   547.016     0.150
    51.836   548.414     0.150
    51.836   548.016     0.150
    51.801   546.781     0.150
    51.838   547.812     0.150
    51.874   547.516     0.150
    51.884   547.609     0.150
    51.870   547.391     0.150
    52.310   551.352     0.150
    52.375   551.414     0.150
    52.504   552.211     0.150
    52.504   621.812     0.150
    52.504   669.312     0.150
    52.600   553.312     0.150
    52.634   553.812     0.150
    52.662   553.516     0.150
    52.807   554.016     0.150
    52.807     9.594     0.150
    52.807   554.516     0.150
    52.984   555.414     0.150
    53.141   557.211     0.150
    53.141     5.898     0.150
    53.171   557.312     0.150
    53.182   558.016     0.150
    53.281   558.312     0.150
    53.281   625.109     0.150
    53.806   562.109     0.150
    53.806     6.000     0.150
    53.842   562.883     0.150
    53.839   561.812     0.150
    53.943   562.109     0.150
    53.943     9.500     0.150
    53.943   561.812     0.150
    54.204   564.914     0.150
    54.204     5.797     0.150
    54.271   565.109     0.150
    54.271     6.500     0.150
    54.308   565.016     0.150
    54.332   565.211     0.150
    54.551   566.711     0.150
    54.551     9.602     0.150
    54.694   568.211     0.150
    54.694     9.500     0.150
    54.825   569.109     0.150
    54.825     6.203     0.150
    54.825     9.602     0.150
    54.870   569.414     0.150
    54.870     6.102     0.150
    54.870     9.602     0.150
    54.908   569.711     0.150
    54.908     6.305     0.150
    54.908     9.703     0.150
    54.919   569.812     0.150
    54.919     6.297     0.150
    54.919     9.703     0.150
    54.955   570.016     0.150
    54.955     6.500     0.150
    54.955     9.695     0.150
    54.963   570.312     0.150
    54.997   570.414     0.150
    55.029   570.609     0.150
    55.029     6.203     0.150
    55.029     9.602     0.150
    55.081   571.734     0.150
    55.258   572.312     0.150
    55.258     5.398     0.150
    55.293   572.312     0.150
    55.293     6.398     0.150
    55.293     9.398     0.150
    55.328   572.812     0.150
    55.409   573.711     0.150
    55.409     9.398     0.150
    55.410   573.414     0.150
    55.410     9.500     0.150
    55.410   573.016     0.150
    55.451   573.109     0.150
    55.451     6.305     0.150
    55.451     9.406     0.150
    55.564   574.812     0.150
    55.564     6.297     0.150
    55.564     9.602     0.150
    55.602   574.312     0.150
    55.877   577.000     0.150
    55.900   577.109     0.150
    56.298   579.312     0.150
    56.298     6.398     0.150
    56.358   580.875     0.150
    56.358   580.211     0.150
    56.369   580.461     0.150
    56.377   580.258     0.150
    56.576   581.000     0.150
    56.633   582.516     0.150
    56.680   583.141     0.150
    56.711   582.414     0.150
    56.711     6.297     0.150
    56.728   583.336     0.150
    56.868   584.633     0.150
    57.004   585.109     0.150
    57.062   585.508     0.150
    57.129   583.859     0.150
    57.111   585.070     0.150
    57.157   584.711     0.150
    57.137   585.273     0.150
    57.198   585.812     0.150
    57.449   587.594     0.150
    57.512   588.953     0.150
    57.693   589.805     0.150
    58.106   592.180     0.150
    58.105   593.219     0.150
    58.185   592.609     0.150
    58.185   592.234     0.150
    58.580   595.312     0.150
    58.614   595.109     0.150
    58.781   596.812     0.150
    59.136   599.109     0.150
    59.142   599.672     0.150
    59.218   599.312     0.150
    59.291   599.914     0.150
    59.463   601.312     0.150
    59.698   602.609     0.150
    60.381   607.500     0.150
    60.381   607.812     0.150
    60.480   608.109     0.150
    60.927   610.711     0.150
    61.044   612.711     0.150
    61.050   613.016     0.150
    61.135   613.094     0.150
    61.239   612.914     0.150
    61.429   614.914     0.150
    61.640   616.016     0.150
    61.888   618.016     0.150
    62.014   618.516     0.150
    62.273   620.055     0.150
    62.317   620.812     0.150
    62.398   620.914     0.150
    62.469   621.711     0.150
    62.607   622.211     0.150
    62.762   623.914     0.150
    63.128   625.609     0.150
    63.444   628.711     0.150
    66.921   650.312     0.150
    67.590   655.922     0.150
    67.632   655.234     0.150
    68.666   663.305     0.150
    68.888   664.109     0.150
    68.895   663.953     0.150
    68.923   664.211     0.150
    69.054   664.391     0.150
    69.054   664.750     0.150
    69.256   665.961     0.150
    69.286   666.219     0.150
    69.330   666.406     0.150
    69.503   667.148     0.150
    69.691   668.047     0.150
    69.712   669.625     0.150
    69.744   668.914     0.150
    69.955   670.820     0.150
    70.030   670.086     0.150
    70.046   671.297     0.150
    70.098   670.922     0.150
    70.102   671.820     0.150
    70.114   669.695     0.150
    70.122   672.203     0.150
    70.257   672.586     0.150
    70.274   671.547     0.150
    70.337   673.023     0.150
    70.340   673.031     0.150
    70.342   671.977     0.150
    70.364   673.531     0.150
    70.405   672.383     0.150
    70.488   673.164     0.150
    70.523   672.969     0.150
    70.661   675.133     0.150
    70.800   675.133     0.150
    70.818   675.102     0.150
    70.845   675.492     0.150
    70.901   676.094     0.150
    71.024   676.406     0.150
    71.049   677.344     0.150
    71.052   676.859     0.150
    71.180   677.953     0.150
    71.185   677.203     0.150
    71.191   678.156     0.150
    71.197   677.289     0.150
    71.293   678.906     0.150
    71.293   678.508     0.150
    71.370   678.742     0.150
    71.370   678.438     0.150
    71.380   680.266     0.150
    71.416   679.242     0.150
    71.436   678.711     0.150
    71.440   678.289     0.150
    71.459   678.969     0.150
    71.510   679.695     0.150
    71.570   680.180     0.150
    71.698   680.289     0.150
    71.716   680.375     0.150
    71.793   681.062     0.150
    71.798   681.758     0.150
    71.823   681.312     0.150
    71.869   681.617     0.150
    71.920   681.719     0.150
    71.951   681.828     0.150
    71.992   682.492     0.150
    72.006   683.062     0.150
    72.037   682.922     0.150
    72.040   682.805     0.150
    72.066   682.398     0.150
    72.112   683.031     0.150
    72.109   683.852     0.150
    72.119   683.336     0.150
    72.118   683.156     0.150
    72.212   684.203     0.150
    72.237   683.586     0.150
    72.325   682.586     0.150
    72.332   684.391     0.150
    72.332   684.125     0.150
    72.382   685.188     0.150
    72.393   684.758     0.150
    72.506   685.930     0.150
    72.611   685.992     0.150
    72.611   686.445     0.150
    72.640   686.680     0.150
    72.655   685.969     0.150
    72.668   686.961     0.150
    72.726   687.062     0.150
    72.911   687.898     0.150
    72.963   688.875     0.150
    72.963   688.500     0.150
    72.970   687.859     0.150
    73.017   688.906     0.150
    73.067   689.172     0.150
    73.071   689.320     0.150
    73.081   689.414     0.150
    73.080   688.266     0.150
    73.094   688.812     0.150
    73.101   689.414     0.150
    73.161   689.344     0.150
    73.200   689.359     0.150
    73.310   690.805     0.150
    73.331   690.875     0.150
    73.430   691.836     0.150
    73.437   690.773     0.150
    73.449   691.812     0.150
    73.574   692.172     0.150
    73.585   692.836     0.150
    73.586   692.172     0.150
    73.676   693.492     0.150
    73.762   693.812     0.150
    73.800   694.250     0.150
    73.800   693.992     0.150
    73.815   693.086     0.150
    73.839   694.164     0.150
    73.914   693.609     0.150
    73.918   693.859     0.150
    73.921   693.438     0.150
    74.007   694.953     0.150
    74.069   695.055     0.150
    74.093   694.586     0.150
    74.099   695.016     0.150
    74.108   695.812     0.150
    74.108   695.664     0.150
    74.175   695.961     0.150
    74.354   695.945     0.150
    74.367   696.297     0.150
    74.236   694.695     0.150
    74.236   695.672     0.150
    74.477   697.375     0.150
    74.481   698.070     0.150
    74.620   697.406     0.150
    74.627   697.922     0.150
    74.669   698.398     0.150
    74.738   698.445     0.150
    74.836   700.641     0.150
    74.868   698.891     0.150
    75.027   701.273     0.150
    75.105   700.625     0.150
    75.111   700.367     0.150
    75.193   702.000     0.150
    75.206   702.445     0.150
    75.226   701.273     0.150
    75.231   700.859     0.150
    75.230   702.695     0.150
    75.253   701.867     0.150
    75.287   703.570     0.150
    75.334   702.781     0.150
    75.435   702.516     0.150
    75.447   703.062     0.150
    75.568   703.477     0.150
    75.707   703.719     0.150
    75.743   703.375     0.150
    75.919   705.141     0.150
    75.950   706.305     0.150
    76.056   706.109     0.150
    76.134   707.070     0.150
    76.231   708.312     0.150
    76.254   707.062     0.150
    76.269   707.195     0.150
    76.269   707.094     0.150
    76.312   707.484     0.150
    76.397   709.453     0.150
    76.397   709.312     0.150
    76.414   707.852     0.150
    76.458   707.812     0.150
    76.506   708.117     0.150
    76.559   708.641     0.150
    76.708   709.523     0.150
    76.753   709.727     0.150
    76.754   711.391     0.150
    76.910   710.312     0.150
    76.940   711.211     0.150
    77.028   711.453     0.150
    77.047   711.984     0.150
    77.062   712.516     0.150
    77.142   712.750     0.150
    77.203   712.461     0.150
    77.205   712.219     0.150
    77.305   712.805     0.150
    77.312   713.500     0.150
    77.342   713.016     0.150
    77.450   715.094     0.150
    77.549   714.844     0.150
    77.579   714.250     0.150
    77.618   715.188     0.150
    77.665   716.516     0.150
    77.665   716.055     0.150
    77.714   714.656     0.150
    77.596   714.289     0.150
    77.777   715.734     0.150
    77.807   716.469     0.150
    77.834   716.906     0.150
    77.919   717.086     0.150
    77.922   716.305     0.150
    77.942   718.016     0.150
    77.953   716.750     0.150
    77.978   718.016     0.150
    78.004   716.820     0.150
    78.187   718.250     0.150
    78.228   718.359     0.150
    78.326   719.047     0.150
    78.350   719.125     0.150
    78.421   719.406     0.150
    78.423   720.406     0.150
    78.450   720.281     0.150
    78.462   719.180     0.150
    78.521   720.422     0.150
    78.614   720.641     0.150
    78.656   720.711     0.150
    78.674   721.172     0.150
    78.698   721.312     0.150
    78.707   722.219     0.150
    78.746   721.875     0.150
    78.755   722.203     0.150
    78.796   721.656     0.150
    78.949   723.289     0.150
    78.981   723.086     0.150
    78.999   723.523     0.150
    79.063   724.422     0.150
    79.077   723.883     0.150
    79.179   723.945     0.150
    79.219   723.234     0.150
    79.242   723.797     0.150
    79.304   724.344     0.150
    79.331   724.758     0.150
    79.341   725.438     0.150
    79.341   725.258     0.150
    79.359   725.203     0.150
    79.522   726.117     0.150
    79.558   726.719     0.150
    79.624   726.695     0.150
    79.646   727.367     0.150
    79.671   726.578     0.150
    79.714   727.453     0.150
    79.761   727.086     0.150
    79.784   726.523     0.150
    79.819   725.914     0.150
    79.863   728.281     0.150
    79.868   728.422     0.150
    79.942   727.539     0.150
    79.951   728.164     0.150
    79.953   728.492     0.150
    79.993   728.953     0.150
    79.952   729.016     0.150
    80.069   729.719     0.150
    80.113   729.414     0.150
    80.158   729.266     0.150
    80.292   729.672     0.150
    80.304   729.719     0.150
    80.314   730.789     0.150
    80.324   730.836     0.150
    80.380   729.961     0.150
    80.429   731.383     0.150
    80.475   731.625     0.150
    80.502   731.789     0.150
    80.548   731.156     0.150
    80.635   732.586     0.150
    80.740   732.961     0.150
    80.762   732.398     0.150
    80.780   732.320     0.150
    80.783   733.211     0.150
    80.783   733.375     0.150
    80.829   732.867     0.150
    80.840   733.664     0.150
    80.845   733.367     0.150
    81.020   733.969     0.150
    81.183   735.547     0.150
    81.114   733.711     0.150
    81.269   736.188     0.150
    81.275   736.469     0.150
    81.304   735.328     0.150
    81.374   736.414     0.150
    81.504   737.406     0.150
    81.562   737.352     0.150
    81.627   737.297     0.150
    81.650   737.805     0.150
    81.700   738.094     0.150
    81.719   738.242     0.150
    81.837   739.453     0.150
    81.837   739.141     0.150
    81.968   739.320     0.150
    82.017   738.688     0.150
    82.090   739.422     0.150
    82.202   740.531     0.150
    82.245   740.664     0.150
    82.241   740.617     0.150
    82.243   741.781     0.150
    82.270   740.148     0.150
    82.362   741.266     0.150
    82.396   741.781     0.150
    82.404   742.281     0.150
    82.404   741.914     0.150
    82.435   740.805     0.150
    82.430   741.336     0.150
    82.430   741.812     0.150
    82.463   741.000     0.150
    82.486   742.055     0.150
    82.585   742.711     0.150
    82.606   742.422     0.150
    82.691   743.023     0.150
    82.725   742.391     0.150
    82.744   743.477     0.150
    82.813   742.641     0.150
    82.888   743.047     0.150
    82.932   743.734     0.150
    82.970   744.961     0.150
    82.979   744.633     0.150
    83.038   744.758     0.150
    83.093   745.641     0.150
    83.114   744.453     0.150
    83.277   746.273     0.150
    83.284   746.438     0.150
    83.324   745.039     0.150
    83.321   746.523     0.150
    83.387   746.859     0.150
    83.393   747.328     0.150
    83.510   747.391     0.150
    83.628   747.602     0.150
    83.653   748.500     0.150
    83.762   749.000     0.150
    83.810   748.617     0.150
    84.026   749.234     0.150
    84.099   750.234     0.150
    84.132   750.711     0.150
    84.195   751.406     0.150
    84.219   750.078     0.150
    84.308   751.703     0.150
    84.363   751.016     0.150
    84.421   751.883     0.150
    84.468   752.188     0.150
    84.471   752.133     0.150
    84.499   752.977     0.150
    84.726   753.156     0.150
    84.730   754.219     0.150
    84.820   754.211     0.150
    84.877   753.867     0.150
    84.939   755.508     0.150
    84.963   754.914     0.150
    85.035   755.055     0.150
    85.069   755.719     0.150
    85.115   756.414     0.150
    85.215   756.523     0.150
    85.246   755.836     0.150
    85.286   756.250     0.150
    85.320   756.555     0.150
    85.383   757.023     0.150
    85.485   757.555     0.150
    85.493   757.469     0.150
    85.530   757.445     0.150
    85.558   757.406     0.150
    85.591   757.789     0.150
    85.667   758.180     0.150
    85.775   758.961     0.150
    85.852   759.086     0.150
    85.879   759.258     0.150
    85.919   759.281     0.150
    85.989   759.664     0.150
    86.118   760.477     0.150
    86.164   759.984     0.150
    86.186   760.641     0.150
    86.246   761.609     0.150
    86.279   761.562     0.150
    86.334   761.266     0.150
    86.357   761.422     0.150
    86.477   762.781     0.150
    86.553   762.891     0.150
    86.625   763.016     0.150
    86.636   763.344     0.150
    86.689   763.156     0.150
    86.748   763.172     0.150
    86.811   764.023     0.150
    86.857   763.523     0.150
    86.930   763.859     0.150
    87.008   764.344     0.150
    87.077   765.000     0.150
    87.103   764.930     0.150
    87.169   765.234     0.150
    87.267   765.898     0.150
    87.309   765.977     0.150
    87.377   766.539     0.150
    87.421   766.680     0.150
    87.433   766.289     0.150
    87.545   767.195     0.150
    87.650   767.289     0.150
    87.708   767.375     0.150
    87.762   767.766     0.150
    87.771   768.812     0.150
    87.825   768.219     0.150
    87.982   769.836     0.150
    88.197   770.398     0.150
    88.202   770.484     0.150
    88.436   771.477     0.150
    88.507   771.836     0.150
    88.765   773.039     0.150
    88.793   772.852     0.150
    88.917   773.812     0.150
    88.924   773.609     0.150
    89.126   774.695     0.150
    89.132   774.531     0.150
    89.137   774.617     0.150
    89.182   774.508     0.150
    89.206   775.000     0.150
    89.446   776.586     0.150
    89.492   776.211     0.150
    89.564   776.430     0.150
    89.594   776.992     0.150
    89.681   777.188     0.150
    89.737   777.680     0.150
    89.757   777.414     0.150
    89.778   777.414     0.150
    89.952   778.867     0.150
    89.974   778.766     0.150
    90.041   778.688     0.150
    90.065   778.891     0.150
    90.142   779.266     0.150
    90.146   779.391     0.150
    90.356   780.508     0.150
    90.440   780.531     0.150
    90.453   781.156     0.150
    90.486   781.695     0.150
    90.549   781.070     0.150
    90.562   781.516     0.150
    90.749   782.148     0.150
    90.759   780.539     0.150
    91.256   784.102     0.150
    91.371   784.516     0.150
    92.064   788.156     0.150
    98.845   818.344     0.150
   136.312  1158.461     0.150
   140.213  1167.734     0.150
   145.163  1173.664     0.150
   147.252  1182.984     0.150
   149.762  1187.344     0.150
     0.021     3.423     0.150
     0.021     6.823     0.150
     0.384     7.523     0.150
     0.384    13.323     0.150
     0.384    13.823     0.150
     1.015    18.823     0.150
     1.015    32.724     0.150
     1.015    36.224     0.150
     1.234    22.623     0.150
     1.234    39.224     0.150
     1.234    39.423     0.150
     1.234    41.523     0.150
     1.288    23.224     0.150
     1.288    40.923     0.150
     1.288    23.023     0.150
     1.288    41.224     0.150
     1.288    23.423     0.150
     1.288    40.923     0.150
     1.288    41.224     0.150
     2.107    35.523     0.150
     2.107    60.923     0.150
     2.107    64.023     0.150
     2.663    42.423     0.150
     2.663    47.623     0.150
     2.663    48.623     0.150
     2.663    74.923     0.150
     2.663    82.623     0.150
     3.360    50.623     0.150
     3.360    60.323     0.150
     3.360   102.724     0.150
     3.349    60.224     0.150
     3.349   104.423     0.150
     3.698   114.523     0.150
     3.698    65.923     0.150
     3.698   114.724     0.150
     4.240   131.423     0.150
     4.609    69.523     0.150
     4.609    81.523     0.150
     4.609   140.123     0.150
     4.630    81.923     0.150
     4.630   143.623     0.150
     4.892   125.523     0.150
     4.892   151.523     0.150
     4.990    73.224     0.150
     4.990   154.623     0.150
     5.058   156.423     0.150
     5.894   180.923     0.150
     6.436   197.823     0.150
     6.531    96.724     0.150
     6.531   199.623     0.150
     7.758   113.123     0.150
     7.758   112.724     0.150
     7.758   196.923     0.150
     7.844   114.023     0.150
     7.844   114.224     0.150
     7.844   199.724     0.150
     0.112     2.156     0.150
     0.112     3.555     0.150
     0.112     3.254     0.150
     0.741    14.055     0.150
     0.741    24.555     0.150
     1.045    19.555     0.150
     1.045    34.055     0.150
     1.045    19.055     0.150
     1.045    34.156     0.150
     1.208    22.555     0.150
     1.208    39.055     0.150
     1.380    25.254     0.150
     1.380    44.555     0.150
     1.380    25.453     0.150
     1.612    29.156     0.150
     1.612    52.555     0.150
     1.931    34.754     0.150
     1.931    61.055     0.150
     1.931    35.156     0.150
     1.931    60.855     0.150
     2.316    40.055     0.150
     2.316    41.953     0.150
     2.316    74.055     0.150
     2.316    43.355     0.150
     2.316    69.453     0.150
     2.316    73.953     0.150
     2.679    44.855     0.150
     2.679    49.754     0.150
     2.679    84.656     0.150
     2.679    84.555     0.150
     3.303    53.156     0.150
     3.303    59.656     0.150
     3.303   102.656     0.150
     3.605    58.156     0.150
     3.605    65.656     0.150
     3.605   112.855     0.150
     4.062    63.453     0.150
     4.062    73.855     0.150
     4.062   127.055     0.150
     4.062    74.055     0.150
     4.062   110.754     0.150
     4.062   126.656     0.150
     4.216   133.355     0.150
     4.317    76.355     0.150
     4.317   116.055     0.150
     4.317   133.855     0.150
     4.498    69.656     0.150
     4.498    81.156     0.150
     4.498   140.355     0.150
     5.260   164.156     0.150
     5.463   169.055     0.150
     5.590   173.656     0.150
     5.839   181.656     0.150
     6.046   188.855     0.150
     6.289   196.254     0.150
     6.753   210.156     0.150
     7.423   229.555     0.150
     7.853   243.156     0.150
     8.501   263.355     0.150
     8.715   271.156     0.150
     8.845   270.754     0.150
     8.845   274.754     0.150
     0.079     3.480     0.150
     0.079     6.480     0.150
     0.079     6.082     0.150
     0.552    10.883     0.150
     0.552    19.383     0.150
     0.552    17.883     0.150
     1.044    18.883     0.150
     1.044    33.383     0.150
     1.044    33.281     0.150
     1.346    23.980     0.150
     1.346    41.781     0.150
     1.346    41.883     0.150
     1.269    22.883     0.150
     1.269    39.383     0.150
     1.803    31.180     0.150
     1.803    32.082     0.150
     1.803    57.180     0.150
     1.803    55.082     0.150
     1.803    56.281     0.150
     1.800    29.980     0.150
     1.800    30.980     0.150
     1.800    54.082     0.150
     1.800    30.582     0.150
     1.800    53.781     0.150
     2.289    37.582     0.150
     2.289    40.680     0.150
     2.289    70.980     0.150
     2.289    40.383     0.150
     2.289    65.383     0.150
     2.289    68.781     0.150
     2.742    43.680     0.150
     2.742    49.781     0.150
     2.742    85.582     0.150
     2.742    50.383     0.150
     2.742    85.480     0.150
     3.158    49.383     0.150
     3.158    56.281     0.150
     3.158    97.582     0.150
     3.158    49.281     0.150
     3.158    55.980     0.150
     3.158    97.180     0.150
     3.658    64.980     0.150
     3.658   112.680     0.150
     4.026   126.281     0.150
     3.992    60.781     0.150
     3.992   105.582     0.150
     3.992   125.582     0.150
     4.210    64.082     0.150
     4.210    75.582     0.150
     4.210   131.082     0.150
     4.210    74.680     0.150
     4.210   127.980     0.150
     4.531   139.883     0.150
     5.133   160.383     0.150
     5.350    80.180     0.150
     5.350   165.281     0.150
     5.446   168.582     0.150
     5.906   184.582     0.150
     6.387    92.582     0.150
     6.387   199.680     0.150
     6.387    92.781     0.150
     6.310    92.582     0.150
     6.310   196.883     0.150
     6.659   207.082     0.150
     7.317   225.383     0.150
     7.761   240.281     0.150
     8.380   259.883     0.150
     8.629   157.582     0.150
     8.629   268.383     0.150
     8.782   126.582     0.150
     8.782   272.582     0.150
     9.119   130.480     0.150
    10.224   147.082     0.150
    12.771   182.383     0.150
    12.948   182.781     0.150
    17.480   244.082     0.150
    25.642   329.281     0.150
     0.258     5.238     0.150
     0.258     9.039     0.150
     0.581    11.141     0.150
     0.581    19.340     0.150
     0.581    11.039     0.150
     0.581    18.238     0.150
     1.060    19.641     0.150
     1.060    35.141     0.150
     1.060    33.738     0.150
     1.276    23.441     0.150
     1.276    22.840     0.150
     1.577    28.738     0.150
     1.577    49.441     0.150
     1.577    29.039     0.150
     1.577    51.641     0.150
     1.793    32.238     0.150
     1.793    55.238     0.150
     1.793    58.641     0.150
     1.985    36.238     0.150
     1.985    63.340     0.150
     1.985    63.441     0.150
     2.520    42.941     0.150
     2.520    46.641     0.150
     2.520    79.641     0.150
     2.520    42.840     0.150
     2.528    46.539     0.150
     2.528    79.441     0.150
     2.528    43.840     0.150
     3.314    53.441     0.150
     3.314    59.840     0.150
     3.314   103.641     0.150
     3.438    62.238     0.150
     3.438   107.340     0.150
     3.506    55.840     0.150
     3.506    62.141     0.150
     3.506   106.641     0.150
     3.774    59.738     0.150
     3.774    68.840     0.150
     3.774   103.340     0.150
     3.774   118.141     0.150
     3.774   102.840     0.150
     3.774   117.738     0.150
     4.026    71.641     0.150
     4.026   125.238     0.150
     4.026    72.441     0.150
     4.026   108.941     0.150
     4.026   124.941     0.150
     4.304    77.238     0.150
     4.304   134.238     0.150
     4.405    68.238     0.150
     4.405    78.641     0.150
     4.405   136.539     0.150
     4.405    67.238     0.150
     4.405    78.840     0.150
     4.405   135.441     0.150
     5.308    96.441     0.150
     5.308   167.039     0.150
     5.538    84.141     0.150
     5.538   170.941     0.150
     5.538    84.039     0.150
     5.538   144.738     0.150
     5.881   109.141     0.150
     5.881   183.840     0.150
     6.066    91.141     0.150
     6.066   190.039     0.150
     6.102   189.941     0.150
     6.148   191.941     0.150
     6.413    94.840     0.150
     6.413   199.738     0.150
     6.413    94.738     0.150
     6.413   166.039     0.150
     6.413   199.441     0.150
     6.826   101.340     0.150
     6.826   212.141     0.150
     6.856   211.238     0.150
     6.856   212.340     0.150
     6.856   212.738     0.150
     7.510   110.234     0.150
     7.510   229.832     0.150
     7.510   110.039     0.150
     7.510   232.238     0.150
     7.510   109.910     0.150
     7.510   110.441     0.150
     7.621   234.840     0.150
     7.621   239.141     0.150
     7.621   109.609     0.150
     7.621   141.941     0.150
     7.965   115.840     0.150
     7.965   244.641     0.150
     8.559   156.941     0.150
     8.559   264.840     0.150
     8.559   128.238     0.150
     8.837   129.441     0.150
     8.837   273.141     0.150
     8.837   129.340     0.150
     9.002   131.539     0.150
     9.002   277.539     0.150
     9.227   288.238     0.150
     9.227   134.141     0.150
     9.227   134.738     0.150
     9.449   136.582     0.150
    10.059   247.727     0.150
    14.909   208.539     0.150
    16.815   234.516     0.150
    17.806   554.816     0.150
    20.415   280.266     0.150
    20.415   637.840     0.150
    21.595   290.918     0.150
    21.595   291.941     0.150
    21.689   291.914     0.150
    25.167   325.676     0.150
    25.212   326.219     0.150
    32.741   393.648     0.150
    42.643   475.980     0.150
    42.643   477.641     0.150
    44.799   494.941     0.150
    47.837   518.039     0.150
    48.508   523.238     0.150
    48.508   522.965     0.150
    48.508   523.441     0.150
    55.903   576.984     0.150
    56.287   581.742     0.150
    56.287   582.840     0.150
    71.148   679.211     0.150
    77.611   716.938     0.150
    81.165   736.402     0.150
   145.789  1177.789     0.150
     0.110     2.141     0.150
     0.110     3.641     0.150
     0.110     2.039     0.150
     1.041    19.539     0.150
     1.041    32.742     0.150
     1.041    34.539     0.150
     1.377    25.242     0.150
     1.377    43.641     0.150
     1.377    47.539     0.150
     1.377    44.438     0.150
     1.212    22.539     0.150
     1.212    39.539     0.150
     1.614    29.344     0.150
     1.614    50.438     0.150
     1.614    52.141     0.150
     1.614    28.844     0.150
     1.928    34.844     0.150
     1.928    35.539     0.150
     1.928    61.141     0.150
     2.312    39.742     0.150
     2.312    41.938     0.150
     2.312    73.141     0.150
     2.312    39.938     0.150
     2.683    44.844     0.150
     2.683    49.742     0.150
     2.683    84.539     0.150
     2.683    49.344     0.150
     2.683    84.039     0.150
     3.299    53.141     0.150
     3.299    57.641     0.150
     3.299    59.539     0.150
     3.299   102.844     0.150
     3.299    53.039     0.150
     3.299    59.742     0.150
     3.299   101.438     0.150
     3.609   113.539     0.150
     4.081    74.039     0.150
     4.081   126.641     0.150
     4.064    63.141     0.150
     4.064    74.039     0.150
     4.064   109.344     0.150
     4.064   127.039     0.150
     4.064    63.039     0.150
     4.064    73.742     0.150
     4.064   110.438     0.150
     4.064   126.539     0.150
     4.213    76.344     0.150
     4.213   131.641     0.150
     4.213    76.844     0.150
     4.213   133.641     0.150
     4.313    67.539     0.150
     4.313    76.344     0.150
     4.313   132.539     0.150
     4.313    67.039     0.150
     4.313    78.039     0.150
     4.313   132.438     0.150
     4.725   147.641     0.150
     5.256   162.844     0.150
     5.459    96.742     0.150
     5.459   167.641     0.150
     5.459    95.742     0.150
     5.459   142.344     0.150
     5.459   166.844     0.150
     5.835   183.539     0.150
     5.867   183.039     0.150
     6.042    89.742     0.150
     6.042   109.438     0.150
     6.042   188.242     0.150
     6.370   115.141     0.150
     6.370   198.039     0.150
     6.292   196.438     0.150
     6.574    96.844     0.150
     6.574   118.438     0.150
     6.574   205.242     0.150
     6.749   208.039     0.150
     6.757   209.039     0.150
     7.419   218.938     0.150
     7.419   228.438     0.150
     7.419   108.938     0.150
     7.849   141.438     0.150
     7.849   242.742     0.150
     8.497   265.344     0.150
     8.711   157.242     0.150
     8.711   269.039     0.150
     8.711   269.438     0.150
     8.841   129.539     0.150
     8.841   273.539     0.150
     8.841   130.938     0.150
    10.098   144.844     0.150
    11.555   165.344     0.150
    15.445   218.938     0.150
    21.362   288.742     0.150
    24.945   323.539     0.150
    26.443   336.844     0.150
    29.819   367.344     0.150
    29.819   423.438     0.150
    29.819   665.742     0.150
    29.819   753.141     0.150
    45.108   496.938     0.150
     0.242     5.121     0.150
     0.242    10.223     0.150
     0.605    10.922     0.150
     0.605    19.824     0.150
     0.790    14.523     0.150
     0.790    25.121     0.150
     1.077    19.723     0.150
     1.077    35.023     0.150
     1.077    37.523     0.150
     1.077    34.621     0.150
     1.414    25.523     0.150
     1.414    45.422     0.150
     1.414    44.824     0.150
     1.520    26.824     0.150
     1.520    47.922     0.150
     1.520    47.523     0.150
     1.939    33.223     0.150
     1.939    58.422     0.150
     1.939    31.324     0.150
     1.939    56.223     0.150
     2.004    33.324     0.150
     2.004    35.023     0.150
     2.004    62.223     0.150
     2.004    33.223     0.150
     2.004    61.523     0.150
     2.808    44.223     0.150
     2.808    49.422     0.150
     2.808    86.824     0.150
     2.808    50.621     0.150
     2.808    86.723     0.150
     3.466    53.523     0.150
     3.466    61.422     0.150
     3.466    91.723     0.150
     3.466   106.824     0.150
     3.466    53.723     0.150
     3.466   106.621     0.150
     3.651    56.324     0.150
     3.651    59.324     0.150
     3.651    64.824     0.150
     3.651   112.523     0.150
     3.651    65.023     0.150
     3.651   112.223     0.150
     4.239   132.121     0.150
     4.239   131.523     0.150
     4.398   135.121     0.150
     4.655    71.121     0.150
     4.655   145.621     0.150
     4.757    71.121     0.150
     4.757   146.723     0.150
     4.790    71.223     0.150
     4.790   123.422     0.150
     4.790   148.723     0.150
     4.790    71.023     0.150
     4.790   148.422     0.150
     4.809    71.723     0.150
     4.809    84.621     0.150
     4.809   147.922     0.150
     4.809    71.922     0.150
     4.809   146.223     0.150
     5.058   157.023     0.150
     5.243   162.922     0.150
     5.255   162.422     0.150
     5.299   162.824     0.150
     5.727   176.922     0.150
     6.096   188.121     0.150
     6.322   104.324     0.150
     6.322   194.023     0.150
     6.480   201.023     0.150
     6.480    93.723     0.150
     6.741   124.922     0.150
     6.741   207.121     0.150
     7.092   102.723     0.150
     7.092   219.422     0.150
     7.134   106.121     0.150
     7.134   218.824     0.150
     7.863   242.023     0.150
     7.863   127.422     0.150
     7.981   116.324     0.150
     7.981   204.723     0.150
     7.981   246.023     0.150
     8.073   249.723     0.150
     9.068   129.023     0.150
     9.068   284.684     0.150
    10.737   262.344     0.150
    10.737   329.094     0.150
    13.735   426.672     0.150
    15.776   223.699     0.150
    20.564   278.621     0.150
    20.658   278.621     0.150
    20.678   278.598     0.150
    24.127   315.547     0.150
     0.151     4.594     0.150
     0.151     7.395     0.150
     0.498     9.793     0.150
     0.498    17.395     0.150
     0.498     9.895     0.150
     0.498    16.895     0.150
     1.112    19.895     0.150
     1.112    35.195     0.150
     1.112    20.094     0.150
     1.112    35.594     0.150
     1.234    22.395     0.150
     1.234    39.395     0.150
     1.234    38.895     0.150
     1.403    24.895     0.150
     1.403    43.793     0.150
     1.403    43.094     0.150
     1.819    31.293     0.150
     1.819    32.395     0.150
     1.819    57.293     0.150
     1.819    31.395     0.150
     1.819    55.594     0.150
     1.819    56.793     0.150
     1.847    31.594     0.150
     1.847    56.395     0.150
     1.847    31.293     0.150
     2.346    38.492     0.150
     2.346    41.695     0.150
     2.346    68.594     0.150
     2.346    73.793     0.150
     2.346    38.793     0.150
     2.346    41.594     0.150
     2.704    43.293     0.150
     2.704    48.293     0.150
     2.704    84.695     0.150
     2.704    43.492     0.150
     2.704    49.293     0.150
     2.704    84.395     0.150
     3.161    49.395     0.150
     3.161    51.395     0.150
     3.161    55.594     0.150
     3.161    97.293     0.150
     3.161    99.492     0.150
     3.161    57.195     0.150
     3.161    86.992     0.150
     3.161    97.395     0.150
     3.518    54.492     0.150
     3.518    61.395     0.150
     3.518   106.793     0.150
     3.615    97.195     0.150
     3.615   111.793     0.150
     3.915    59.793     0.150
     3.915    70.195     0.150
     3.915   122.195     0.150
     3.915    59.594     0.150
     3.915    70.094     0.150
     3.915   105.594     0.150
     3.973   124.094     0.150
     4.234    63.992     0.150
     4.234    74.594     0.150
     4.234   130.395     0.150
     4.234    64.094     0.150
     4.234    75.395     0.150
     4.234   130.992     0.150
     4.481   138.895     0.150
     5.146    94.992     0.150
     5.146   161.094     0.150
     5.181    77.395     0.150
     5.181   162.195     0.150
     5.370    79.793     0.150
     5.370   165.992     0.150
     5.370    79.293     0.150
     5.370   140.293     0.150
     5.370   164.195     0.150
     5.448   169.195     0.150
     5.720   178.492     0.150
     6.275   195.195     0.150
     6.342    93.094     0.150
     6.342   196.992     0.150
     6.342    92.395     0.150
     6.659   206.992     0.150
     6.898   213.094     0.150
     7.340   226.492     0.150
     7.669   238.695     0.150
     7.669   110.695     0.150
     7.791   114.895     0.150
     7.791   239.695     0.150
     8.395   259.195     0.150
     8.663   124.094     0.150
     8.663   155.793     0.150
     8.663   269.293     0.150
     8.824   127.695     0.150
     8.824   223.695     0.150
     8.824   273.492     0.150
     9.102   285.293     0.150
     9.102   130.293     0.150
    12.870   182.543     0.150
    12.870   398.070     0.150
    12.870   182.195     0.150
    16.991   236.492     0.150
    21.425   290.594     0.150
    21.475   287.668     0.150
    25.009   324.184     0.150
    25.053   323.492     0.150
    44.938   494.242     0.150
    46.615   506.844     0.150
    56.016   575.688     0.150
    77.625   714.070     0.150
     0.269     5.539     0.150
     0.269    10.039     0.150
     0.580    10.844     0.150
     0.772    15.039     0.150
     0.772    25.344     0.150
     0.772    14.844     0.150
     0.772    25.039     0.150
     0.994    18.742     0.150
     0.994    32.539     0.150
     0.994    18.641     0.150
     0.994    31.844     0.150
     1.515    27.742     0.150
     1.515    47.844     0.150
     1.515    27.945     0.150
     2.028    35.242     0.150
     2.028    59.141     0.150
     2.028    61.539     0.150
     2.028    34.945     0.150
     2.010    34.242     0.150
     2.010    36.344     0.150
     2.010    33.641     0.150
     2.010    61.445     0.150
     2.717    44.445     0.150
     2.717    47.641     0.150
     2.717    84.641     0.150
     2.717    47.344     0.150
     2.717    83.945     0.150
     3.398    60.039     0.150
     3.398    90.945     0.150
     3.398   104.641     0.150
     3.478   107.945     0.150
     3.440    62.039     0.150
     3.440   107.344     0.150
     3.591    64.242     0.150
     3.591    97.742     0.150
     3.591   111.445     0.150
     4.083    62.641     0.150
     4.083   126.344     0.150
     4.124    62.641     0.150
     4.124    72.945     0.150
     4.124   126.445     0.150
     4.124   131.039     0.150
     4.124    62.039     0.150
     4.124   109.445     0.150
     4.406    66.445     0.150
     4.406    79.141     0.150
     4.406   136.945     0.150
     4.583   141.344     0.150
     4.737    71.344     0.150
     4.737   123.445     0.150
     4.737   148.945     0.150
     4.737    71.242     0.150
     4.737   147.242     0.150
     4.677    70.742     0.150
     4.677   144.844     0.150
     4.747    71.945     0.150
     4.747    84.141     0.150
     4.747   146.742     0.150
     4.747   144.945     0.150
     4.975    75.742     0.150
     4.975   154.445     0.150
     5.298    79.344     0.150
     5.298   163.344     0.150
     5.170   160.039     0.150
     5.410    80.344     0.150
     5.410    96.344     0.150
     5.410   167.641     0.150
     6.018   185.539     0.150
     6.036   185.641     0.150
     6.263   192.141     0.150
     6.687   205.344     0.150
     6.687   205.242     0.150
     7.089   128.344     0.150
     7.089   219.844     0.150
     7.090   103.445     0.150
     7.090   182.945     0.150
     7.799   113.641     0.150
     7.799   126.445     0.150
     7.799   242.141     0.150
     7.942   115.742     0.150
     7.942   201.445     0.150
     8.050   118.141     0.150
     8.050   204.141     0.150
     8.050   249.039     0.150
     8.975   131.344     0.150
     8.975   161.664     0.150
    10.325   321.242     0.150
    10.796   268.742     0.150
    15.802   223.680     0.150
    20.581   279.242     0.150
    20.675   279.250     0.150
    20.669   278.969     0.150
    24.166   315.062     0.150
    27.593   348.312     0.150
    41.900   468.469     0.150
    45.381   496.695     0.150
    46.945   509.492     0.150
    47.527   512.727     0.150
    47.838   515.617     0.150
    57.167   585.055     0.150
    76.578   710.539     0.150
    77.990   717.039     0.150
    81.524   736.281     0.150
     0.174     4.766     0.150
     0.174     8.766     0.150
     0.174     8.168     0.150
     0.458     9.168     0.150
     0.458    16.367     0.150
     0.458    16.668     0.150
     1.044    18.469     0.150
     1.044    32.969     0.150
     1.044    33.168     0.150
     1.325    23.266     0.150
     1.325    40.469     0.150
     1.321    23.668     0.150
     1.321    41.668     0.150
     1.321    23.566     0.150
     1.733    30.266     0.150
     1.733    30.668     0.150
     1.733    53.969     0.150
     1.733    30.566     0.150
     1.733    53.766     0.150
     1.897    30.867     0.150
     1.897    32.668     0.150
     1.897    54.168     0.150
     1.897    57.066     0.150
     1.897    30.766     0.150
     1.897    32.867     0.150
     1.897    56.867     0.150
     2.268    36.668     0.150
     2.268    38.969     0.150
     2.268    40.969     0.150
     2.268    68.867     0.150
     2.268    65.168     0.150
     2.268    70.066     0.150
     2.790    44.168     0.150
     2.790    50.266     0.150
     2.790    86.469     0.150
     2.790    49.766     0.150
     2.790    86.066     0.150
     3.078    47.566     0.150
     3.078    53.566     0.150
     3.078    94.867     0.150
     3.078    48.168     0.150
     3.078    55.766     0.150
     3.078    94.766     0.150
     3.547   108.566     0.150
     3.700    57.066     0.150
     3.700    66.266     0.150
     3.700   114.566     0.150
     3.877    68.266     0.150
     3.877   119.668     0.150
     3.931   122.266     0.150
     3.972    59.969     0.150
     3.972   123.867     0.150
     3.972    70.367     0.150
     3.972   124.066     0.150
     4.147    63.668     0.150
     4.147    72.566     0.150
     4.147   127.566     0.150
     4.147   127.766     0.150
     4.519    81.066     0.150
     4.519   140.668     0.150
     4.564    80.766     0.150
     4.564   140.367     0.150
     5.284    78.266     0.150
     5.284   162.367     0.150
     5.828    85.168     0.150
     5.828   181.766     0.150
     6.291    91.168     0.150
     6.291   163.266     0.150
     6.291   194.867     0.150
     6.291    91.469     0.150
     6.336    92.367     0.150
     6.336   196.969     0.150
     6.390   198.766     0.150
     6.572   203.969     0.150
     6.598   204.469     0.150
     6.598   120.168     0.150
     7.254   224.469     0.150
     7.254   131.668     0.150
     7.673   239.969     0.150
     7.673   110.168     0.150
     7.705   234.969     0.150
     8.576   263.266     0.150
     8.739   127.566     0.150
     8.739   268.566     0.150
     9.029   280.066     0.150
     9.243   291.605     0.150
    12.922   182.594     0.150
    12.922   403.742     0.150
    17.052   235.168     0.150
    17.430   241.168     0.150
    20.003   269.766     0.150
    20.667   279.969     0.150
    20.667   277.793     0.150
    21.349   286.066     0.150
    21.391   287.133     0.150
    21.443   286.922     0.150
    24.987   323.168     0.150
    25.593   327.566     0.150
    26.663   338.766     0.150
    29.920   368.266     0.150
    41.457   465.367     0.150
    41.705   467.566     0.150
    42.441   473.969     0.150
    43.968   486.367     0.150
    44.628   489.766     0.150
    45.017   493.324     0.150
    47.683   515.066     0.150
    56.085   576.262     0.150
    75.626   705.414     0.150
     0.108     3.839     0.150
     0.108     7.738     0.150
     0.108     3.738     0.150
     0.469     8.938     0.150
     0.469    16.039     0.150
     0.469     9.039     0.150
     0.920    16.938     0.150
     0.920    29.639     0.150
     0.920    17.238     0.150
     1.382    24.938     0.150
     1.382    43.738     0.150
     1.382    43.938     0.150
     1.326    24.238     0.150
     1.326    42.639     0.150
     2.045    33.238     0.150
     2.045    35.339     0.150
     2.045    58.639     0.150
     2.045    61.539     0.150
     2.045    33.039     0.150
     2.045    57.938     0.150
     2.045    60.938     0.150
     2.142    35.039     0.150
     2.142    37.639     0.150
     2.142    34.938     0.150
     2.711    43.039     0.150
     2.711    47.238     0.150
     2.711    47.339     0.150
     2.711    83.938     0.150
     2.711    83.639     0.150
     3.339    49.539     0.150
     3.339    88.938     0.150
     3.339   102.839     0.150
     3.410    52.738     0.150
     3.410    61.039     0.150
     3.410    88.738     0.150
     3.410   106.139     0.150
     3.525    55.438     0.150
     3.525    62.738     0.150
     3.525   110.139     0.150
     3.525    55.539     0.150
     3.525    63.839     0.150
     3.604    55.139     0.150
     3.604    63.938     0.150
     3.604   110.938     0.150
     3.604    64.438     0.150
     3.604   111.039     0.150
     4.050   125.639     0.150
     4.226   130.238     0.150
     4.226   133.238     0.150
     4.226    63.139     0.150
     4.226    74.938     0.150
     4.226   133.039     0.150
     4.537    68.539     0.150
     4.537   140.039     0.150
     4.536    68.039     0.150
     4.536    80.539     0.150
     4.536   118.039     0.150
     4.536   140.339     0.150
     4.646    70.039     0.150
     4.646   143.238     0.150
     4.684    70.039     0.150
     4.684   144.238     0.150
     4.684   145.039     0.150
     4.902    72.539     0.150
     4.902   152.139     0.150
     4.902    72.238     0.150
     4.902   151.839     0.150
     4.951    73.039     0.150
     4.951   153.339     0.150
     5.126   158.839     0.150
     5.134   159.839     0.150
     5.435    80.339     0.150
     5.435   166.639     0.150
     5.603    81.938     0.150
     5.603    91.539     0.150
     5.603   172.738     0.150
     5.939   152.738     0.150
     5.939   181.238     0.150
     5.970    86.938     0.150
     5.970   184.938     0.150
     6.194    89.539     0.150
     6.441    93.938     0.150
     6.441    93.238     0.150
     6.611    94.839     0.150
     6.611   166.539     0.150
     6.611    95.438     0.150
     7.000   102.238     0.150
     7.000   176.839     0.150
     7.227   104.539     0.150
     7.316   185.839     0.150
     7.738   112.039     0.150
     7.738   111.938     0.150
     7.845   113.938     0.150
     7.845   196.539     0.150
     7.845   199.438     0.150
     7.935   114.839     0.150
     7.935   200.938     0.150
     7.935   114.738     0.150
     7.935   200.039     0.150
     8.974   129.679     0.150
     8.974   281.031     0.150
    13.841   195.253     0.150
    13.841   432.851     0.150
    13.841   195.639     0.150
    15.292   218.238     0.150
    15.647   217.813     0.150
    15.647   491.781     0.150
    17.151   532.944     0.150
    17.466   550.031     0.150
    20.431   275.039     0.150
    20.526   276.164     0.150
    20.540   276.283     0.150
    20.540   276.039     0.150
    21.309   285.738     0.150
    24.005   312.631     0.150
    24.050   313.238     0.150
    25.632   330.139     0.150
    38.008   434.738     0.150
    41.743   466.510     0.150
    41.743   466.839     0.150
    44.235   487.039     0.150
    45.414   495.988     0.150
    46.953   508.238     0.150
    47.687   512.938     0.150
    47.687   513.338     0.150
    53.229   556.539     0.150
    70.232   671.008     0.150
    76.617   709.525     0.150
    81.642   735.720     0.150
    90.073   777.729     0.150
     0.190     3.407     0.150
     0.190     6.308     0.150
     0.190     3.607     0.150
     0.190     6.208     0.150
     0.516    10.007     0.150
     0.516    17.808     0.150
     0.516    10.107     0.150
     0.825    15.407     0.150
     0.825    27.407     0.150
     0.825    15.607     0.150
     0.960    17.808     0.150
     0.960    30.907     0.150
     0.960    17.708     0.150
     1.375    26.007     0.150
     1.375    44.607     0.150
     1.375    25.407     0.150
     1.375    27.507     0.150
     1.375    44.208     0.150
     1.375    47.808     0.150
     2.167    36.708     0.150
     2.167    39.308     0.150
     2.167    68.007     0.150
     2.167    38.208     0.150
     2.616    42.407     0.150
     2.616    45.907     0.150
     2.616    74.907     0.150
     2.616    80.808     0.150
     2.616    42.907     0.150
     2.616    47.308     0.150
     2.616    74.507     0.150
     2.616    79.907     0.150
     2.627    44.308     0.150
     2.627    47.107     0.150
     2.627    76.407     0.150
     2.627    82.708     0.150
     2.840    47.208     0.150
     2.840    50.507     0.150
     2.840    83.808     0.150
     2.840    89.507     0.150
     2.950    49.708     0.150
     2.950    83.308     0.150
     2.950    91.907     0.150
     2.950    47.607     0.150
     2.950    53.507     0.150
     2.950    92.507     0.150
     3.478    62.308     0.150
     3.478    95.208     0.150
     3.478   107.708     0.150
     3.818    58.708     0.150
     3.818    67.907     0.150
     3.818   117.107     0.150
     3.932    61.107     0.150
     3.932    70.007     0.150
     3.932   106.708     0.150
     3.932   122.808     0.150
     4.101    64.808     0.150
     4.101    72.907     0.150
     4.101   127.007     0.150
     4.075    64.107     0.150
     4.075    72.208     0.150
     4.075   112.407     0.150
     4.075   126.907     0.150
     4.109    64.308     0.150
     4.109    72.507     0.150
     4.109   113.308     0.150
     4.109   127.107     0.150
     4.109    64.507     0.150
     4.109    74.407     0.150
     4.109   111.607     0.150
     4.109   126.808     0.150
     4.514   138.808     0.150
     4.550   143.208     0.150
     4.558   141.607     0.150
     4.806    74.308     0.150
     4.806    86.107     0.150
     4.806   150.407     0.150
     5.027   155.007     0.150
     5.173    78.808     0.150
     5.173   135.808     0.150
     5.173   162.607     0.150
     5.173    78.407     0.150
     5.173   136.308     0.150
     5.173   162.007     0.150
     5.372   166.308     0.150
     5.372    81.208     0.150
     5.372   165.007     0.150
     5.396    82.808     0.150
     5.396    95.708     0.150
     5.396   167.308     0.150
     5.622    84.407     0.150
     5.622   172.007     0.150
     5.895   104.107     0.150
     5.895   181.607     0.150
     6.045    89.708     0.150
     6.045   187.808     0.150
     6.045    89.907     0.150
     6.045   185.808     0.150
     6.042    90.507     0.150
     6.042   186.708     0.150
     6.042    91.227     0.150
     6.042   184.577     0.150
     7.421   111.107     0.150
     7.421   192.208     0.150
     7.421   229.107     0.150
     8.425   124.407     0.150
     8.425   263.127     0.150
    11.437   348.157     0.150
    14.053   200.507     0.150
    14.053   437.583     0.150
    15.292   215.708     0.150
    15.292   477.058     0.150
    17.319   536.657     0.150
    20.039   272.808     0.150
    20.061   274.007     0.150
    23.705   312.146     0.150
    38.143   438.507     0.150
    41.765   469.107     0.150
    46.669   508.958     0.150
    47.767   516.215     0.150
    51.792   548.907     0.150
     0.191     3.126     0.150
     0.191     6.326     0.150
     0.191     3.227     0.150
     0.514    10.227     0.150
     0.514    17.727     0.150
     0.825    15.326     0.150
     0.825    15.826     0.150
     0.825    27.826     0.150
     0.825    27.026     0.150
     0.965    17.326     0.150
     0.965    30.926     0.150
     0.965    17.727     0.150
     0.965    30.626     0.150
     1.371    26.426     0.150
     1.371    46.326     0.150
     1.370    25.326     0.150
     1.370    27.526     0.150
     1.370    44.326     0.150
     1.370    47.626     0.150
     2.167    38.026     0.150
     2.167    39.526     0.150
     2.167    68.026     0.150
     2.167    67.126     0.150
     2.615    43.426     0.150
     2.615    46.426     0.150
     2.615    74.426     0.150
     2.615    80.526     0.150
     2.615    43.626     0.150
     2.615    48.026     0.150
     2.615    74.626     0.150
     2.615    79.727     0.150
     2.624    44.426     0.150
     2.624    76.826     0.150
     2.624    82.626     0.150
     2.841    47.727     0.150
     2.841    51.126     0.150
     2.841    83.026     0.150
     2.841    90.026     0.150
     2.953    50.026     0.150
     2.953    53.826     0.150
     2.953    92.227     0.150
     2.953    49.026     0.150
     2.953    54.626     0.150
     2.953    92.626     0.150
     3.479    62.626     0.150
     3.479    63.326     0.150
     3.479   108.426     0.150
     3.819   118.526     0.150
     3.929   123.626     0.150
     4.097    64.926     0.150
     4.097    74.326     0.150
     4.097   127.326     0.150
     4.076    64.227     0.150
     4.076    72.826     0.150
     4.076   111.926     0.150
     4.076   127.126     0.150
     4.111    73.526     0.150
     4.111   127.526     0.150
     4.385    78.326     0.150
     4.385   136.126     0.150
     4.516   139.126     0.150
     4.808    86.126     0.150
     4.808   149.326     0.150
     5.168    78.227     0.150
     5.168    92.326     0.150
     5.168   136.126     0.150
     5.168   162.126     0.150
     5.168   136.326     0.150
     5.168   161.227     0.150
     5.399   166.727     0.150
     5.624   147.826     0.150
     5.624   174.126     0.150
     6.045   186.426     0.150
     6.045   185.195     0.150
     6.044    90.026     0.150
     6.044   188.626     0.150
     6.448    98.727     0.150
     6.448   198.227     0.150
     7.301   109.227     0.150
     7.301   189.826     0.150
     7.301   225.826     0.150
     7.425   111.026     0.150
     7.425   193.826     0.150
     7.425   229.227     0.150
     8.426   124.846     0.150
     8.426   265.426     0.150
    11.434   349.477     0.150
    14.049   200.026     0.150
    14.049   438.176     0.150
    15.297   216.789     0.150
    15.297   480.631     0.150
    17.322   538.727     0.150
    17.680   551.485     0.150
    20.044   273.926     0.150
    20.065   274.401     0.150
    20.137   273.901     0.150
    23.709   312.265     0.150
    38.146   438.452     0.150
    41.769   469.309     0.150
     0.212     4.695     0.150
     0.212     8.594     0.150
     0.567    10.297     0.150
     0.567    18.398     0.150
     0.816    15.695     0.150
     0.816    26.797     0.150
     1.081    20.500     0.150
     1.081    35.094     0.150
     1.081    37.695     0.150
     1.376    25.297     0.150
     1.376    44.398     0.150
     1.486    26.898     0.150
     1.486    46.898     0.150
     1.979    33.297     0.150
     1.979    34.297     0.150
     1.979    57.398     0.150
     1.979    60.000     0.150
     2.037    34.594     0.150
     2.037    37.000     0.150
     2.037    64.000     0.150
     2.769    44.297     0.150
     2.769    48.195     0.150
     2.769    50.398     0.150
     2.769    77.797     0.150
     2.769    86.000     0.150
     3.318    50.594     0.150
     3.318    59.000     0.150
     3.318    89.297     0.150
     3.318   102.000     0.150
     3.480    54.797     0.150
     3.480    62.797     0.150
     3.480    93.000     0.150
     3.480   108.594     0.150
     3.500    55.000     0.150
     3.500    63.094     0.150
     3.500    94.898     0.150
     3.500   108.297     0.150
     3.610    57.094     0.150
     3.610    65.594     0.150
     3.610    97.594     0.150
     3.610   112.398     0.150
     4.215   131.094     0.150
     4.431    67.000     0.150
     4.431    79.695     0.150
     4.431   116.695     0.150
     4.431   136.898     0.150
     4.615    70.594     0.150
     4.615    83.000     0.150
     4.615   120.695     0.150
     4.615   143.500     0.150
     4.769    71.797     0.150
     4.769    84.898     0.150
     4.769   124.797     0.150
     4.769   147.500     0.150
     4.807    72.195     0.150
     4.807    87.094     0.150
     4.807   125.094     0.150
     4.807   149.695     0.150
     5.018    75.695     0.150
     5.018    90.195     0.150
     5.018   130.695     0.150
     5.018   156.000     0.150
     5.330    79.797     0.150
     5.330    95.797     0.150
     5.330   164.594     0.150
     5.449    82.297     0.150
     5.449    97.695     0.150
     5.449   141.797     0.150
     5.449   168.398     0.150
     5.687    84.594     0.150
     5.687   101.695     0.150
     5.687   146.797     0.150
     5.687   175.195     0.150
     6.281    91.898     0.150
     6.281   160.797     0.150
     6.281   194.000     0.150
     6.701   119.398     0.150
     6.701   172.000     0.150
     6.701   205.797     0.150
     7.095   104.695     0.150
     7.095   127.398     0.150
     7.095   180.000     0.150
     7.095   219.195     0.150
     7.119   221.398     0.150
     7.822   141.195     0.150
     7.822   199.094     0.150
     7.822   242.000     0.150
     7.942   116.000     0.150
     7.942   143.398     0.150
     7.942   200.695     0.150
     7.942   245.000     0.150
     8.037   117.195     0.150
     8.037   145.297     0.150
     8.037   203.500     0.150
     8.037   249.094     0.150
    10.078   311.297     0.150
     0.223     4.292     0.150
     0.223     7.692     0.150
     0.608    11.192     0.150
     0.608    19.393     0.150
     1.067    20.192     0.150
     1.067    34.993     0.150
     1.247    22.692     0.150
     1.247    39.692     0.150
     1.554    27.893     0.150
     1.554    29.493     0.150
     1.554    49.393     0.150
     1.554    51.993     0.150
     1.756    32.192     0.150
     1.756    55.393     0.150
     1.985    35.493     0.150
     1.985    36.093     0.150
     1.985    62.893     0.150
     2.497    42.692     0.150
     2.497    44.692     0.150
     2.497    74.493     0.150
     2.497    78.292     0.150
     2.538    43.093     0.150
     2.538    47.292     0.150
     2.538    80.692     0.150
     3.322    53.993     0.150
     3.322    59.393     0.150
     3.322   103.192     0.150
     3.464    54.393     0.150
     3.464    61.192     0.150
     3.464    96.593     0.150
     3.464   105.493     0.150
     3.452   107.393     0.150
     3.452   109.493     0.150
     3.812    59.893     0.150
     3.812    68.993     0.150
     3.812   104.393     0.150
     3.812   119.093     0.150
     4.062   127.792     0.150
     4.125    75.792     0.150
     4.125   113.593     0.150
     4.125   129.692     0.150
     4.323    67.393     0.150
     4.323    77.792     0.150
     4.323   135.393     0.150
     4.401    69.292     0.150
     4.401    79.493     0.150
     4.401   137.692     0.150
     5.311   165.292     0.150
     5.344    82.093     0.150
     5.344   167.692     0.150
     5.537    85.292     0.150
     5.537    91.192     0.150
     5.537    99.292     0.150
     5.537   171.292     0.150
     5.609    84.093     0.150
     5.609   100.593     0.150
     5.609   174.393     0.150
     5.840   179.893     0.150
     5.926   183.993     0.150
     6.073   179.792     0.150
     6.073   188.593     0.150
     6.120   181.393     0.150
     6.120   190.692     0.150
     6.442   200.292     0.150
     6.446    95.393     0.150
     6.446   115.792     0.150
     6.446   170.292     0.150
     6.446   201.493     0.150
     7.065   213.792     0.150
     7.065   220.593     0.150
     7.958   248.393     0.150
     8.829   272.893     0.150
    12.289   380.093     0.150
    12.464   387.093     0.150
     0.210     4.082     0.150
     0.210     7.582     0.150
     0.210     6.980     0.150
     0.576    10.680     0.150
     0.576    18.980     0.150
     1.098    35.082     0.150
     1.228    22.383     0.150
     1.228    38.980     0.150
     1.228    39.781     0.150
     1.531    27.480     0.150
     1.531    47.980     0.150
     1.531    50.980     0.150
     1.531    47.781     0.150
     1.952    34.680     0.150
     1.952    35.980     0.150
     1.952    61.980     0.150
     1.952    33.480     0.150
     1.952    34.883     0.150
     1.952    59.883     0.150
     1.783    31.680     0.150
     1.783    55.082     0.150
     1.783    57.781     0.150
     1.783    31.980     0.150
     2.474    41.883     0.150
     2.474    44.383     0.150
     2.474    77.383     0.150
     2.568    42.883     0.150
     2.568    47.082     0.150
     2.568    80.582     0.150
     2.568    42.582     0.150
     2.568    46.781     0.150
     2.568    79.883     0.150
     3.288    52.980     0.150
     3.288    59.883     0.150
     3.288   102.480     0.150
     3.288    52.781     0.150
     3.288    60.582     0.150
     3.480    62.883     0.150
     3.480    94.781     0.150
     3.480   107.680     0.150
     3.480   109.680     0.150
     3.486    54.582     0.150
     3.486    61.281     0.150
     3.486    96.781     0.150
     3.486   106.383     0.150
     3.821    59.781     0.150
     3.821    68.680     0.150
     3.821   104.180     0.150
     3.821   118.980     0.150
     3.821    69.582     0.150
     4.034   125.980     0.150
     4.034    63.980     0.150
     4.034    73.383     0.150
     4.034   109.383     0.150
     4.034   123.383     0.150
     4.092    63.680     0.150
     4.092    75.582     0.150
     4.092   126.883     0.150
     4.369    68.680     0.150
     4.369    78.281     0.150
     4.369   113.582     0.150
     4.369   136.180     0.150
     4.369   134.680     0.150
     4.348    67.281     0.150
     4.348    77.582     0.150
     4.348   134.281     0.150
     5.505   170.781     0.150
     5.574   172.781     0.150
     6.039   108.980     0.150
     6.039   187.180     0.150
     6.146   182.480     0.150
     6.146   191.480     0.150
     6.409   115.082     0.150
     6.409   199.281     0.150
     6.416    94.883     0.150
     6.416   116.480     0.150
     6.416   200.680     0.150
     6.416    94.680     0.150
     6.416   198.680     0.150
     6.793    99.281     0.150
     6.793   209.582     0.150
     6.820   209.980     0.150
     6.820   123.680     0.150
     6.820   210.980     0.150
     7.032   127.980     0.150
     7.032   216.680     0.150
     7.475   134.383     0.150
     7.475   231.281     0.150
     7.475   133.648     0.150
     7.475   230.250     0.150
     7.654   238.383     0.150
     7.927   115.781     0.150
     7.927   244.281     0.150
     8.528   250.281     0.150
     8.528   263.383     0.150
     8.799   129.281     0.150
     8.799   272.180     0.150
     8.959   131.383     0.150
     8.959   278.480     0.150
     8.959   131.582     0.150
     8.959   229.082     0.150
     9.432   297.395     0.150
    10.087   307.637     0.150
    11.039   340.082     0.150
    12.262   379.281     0.150
    12.780   182.055     0.150
    12.780   400.031     0.150
    16.767   235.707     0.150
    16.902   410.242     0.150
    21.548   292.180     0.150
    21.607   290.531     0.150
    21.642   292.180     0.150
    25.119   326.543     0.150
    42.602   477.457     0.150
    44.819   494.082     0.150
    55.913   577.355     0.150
    77.636   715.605     0.150
    81.189   734.633     0.150
   118.700   911.082     0.150
     0.208     4.094     0.150
     0.208     7.789     0.150
     0.585    10.688     0.150
     0.585    18.992     0.150
     1.093    35.094     0.150
     1.228    22.492     0.150
     1.228    38.891     0.150
     1.228    44.094     0.150
     1.532    27.594     0.150
     1.532    29.094     0.150
     1.532    48.094     0.150
     1.532    51.094     0.150
     1.774    31.789     0.150
     1.774    55.188     0.150
     1.774    57.789     0.150
     1.959    34.688     0.150
     1.959    35.492     0.150
     1.959    61.992     0.150
     2.475    42.391     0.150
     2.475    44.289     0.150
     2.475    76.594     0.150
     2.475    78.688     0.150
     2.563    42.891     0.150
     2.563    47.094     0.150
     2.563    48.891     0.150
     2.563    80.789     0.150
     3.295    52.891     0.150
     3.295    59.992     0.150
     3.295   103.188     0.150
     3.477    61.992     0.150
     3.477    95.789     0.150
     3.477   106.289     0.150
     3.476    55.992     0.150
     3.476    62.891     0.150
     3.476    98.789     0.150
     3.476   108.992     0.150
     3.824    60.094     0.150
     3.824    67.688     0.150
     3.824   103.891     0.150
     3.824   119.289     0.150
     4.043   125.992     0.150
     4.098   126.391     0.150
     4.346    77.789     0.150
     4.346   134.789     0.150
     4.375    68.188     0.150
     4.375    78.289     0.150
     4.375   136.391     0.150
     5.582   100.094     0.150
     5.582   174.789     0.150
     6.047   187.594     0.150
     6.143   102.891     0.150
     6.143   191.891     0.150
     6.415   198.492     0.150
     6.425   116.594     0.150
     6.425   169.789     0.150
     6.425   200.992     0.150
     6.799   211.289     0.150
     7.038   219.891     0.150
     7.481   232.789     0.150
     7.932   201.289     0.150
     7.932   235.492     0.150
     7.932   245.094     0.150
     8.534   253.594     0.150
     8.534   264.391     0.150
     8.803   226.891     0.150
     8.803   272.188     0.150
     8.963   130.594     0.150
     8.963   229.992     0.150
     8.963   278.492     0.150
     0.226     4.219     0.150
     0.226     8.016     0.150
     0.226     7.719     0.150
     0.581    10.820     0.150
     0.581    19.117     0.150
     0.581    19.320     0.150
     1.083    20.117     0.150
     1.083    35.117     0.150
     1.083    20.219     0.150
     1.083    34.914     0.150
     1.244    22.516     0.150
     1.244    39.414     0.150
     1.244    23.016     0.150
     1.547    27.820     0.150
     1.547    29.320     0.150
     1.547    48.516     0.150
     1.547    52.016     0.150
     1.547    27.719     0.150
     1.783    31.914     0.150
     1.783    55.414     0.150
     1.966    35.016     0.150
     1.966    36.016     0.150
     1.966    62.117     0.150
     1.966    35.219     0.150
     1.966    61.320     0.150
     2.553    43.016     0.150
     2.553    47.617     0.150
     2.553    71.414     0.150
     2.553    81.219     0.150
     2.553    47.219     0.150
     2.553    79.016     0.150
     2.490    41.914     0.150
     2.490    44.617     0.150
     2.490    70.320     0.150
     2.490    42.617     0.150
     2.490    45.016     0.150
     2.490    75.117     0.150
     3.300    52.914     0.150
     3.300    60.617     0.150
     3.300   103.516     0.150
     3.300    53.117     0.150
     3.300    60.320     0.150
     3.300   102.414     0.150
     3.464    55.914     0.150
     3.464    63.914     0.150
     3.464   109.016     0.150
     3.489    55.016     0.150
     3.489    63.219     0.150
     3.489   107.016     0.150
     3.806    59.820     0.150
     3.806    70.414     0.150
     3.806   119.820     0.150
     3.806    60.016     0.150
     3.806    69.617     0.150
     3.806   104.320     0.150
     3.806   119.516     0.150
     4.035    62.414     0.150
     4.035    64.617     0.150
     4.035    73.117     0.150
     4.035   126.414     0.150
     4.035    63.016     0.150
     4.035    73.016     0.150
     4.035   110.016     0.150
     4.035   124.914     0.150
     4.104    63.914     0.150
     4.104    73.617     0.150
     4.104   128.414     0.150
     4.332    67.516     0.150
     4.332    78.320     0.150
     4.332   136.320     0.150
     4.383    68.617     0.150
     4.383    79.414     0.150
     4.383   135.219     0.150
     4.383    68.820     0.150
     4.383   135.516     0.150
     5.290    79.820     0.150
     5.290   165.320     0.150
     5.518    83.719     0.150
     5.518   171.914     0.150
     5.518   142.820     0.150
     5.518   169.117     0.150
     5.586    84.516     0.150
     5.586   174.414     0.150
     5.864    87.516     0.150
     5.864   181.219     0.150
     5.905    89.219     0.150
     5.905   183.516     0.150
     6.130    92.219     0.150
     6.130   111.820     0.150
     6.130   191.516     0.150
     6.051    90.820     0.150
     6.051   188.617     0.150
     6.418    94.617     0.150
     6.418   107.016     0.150
     6.418   200.219     0.150
     6.418    94.820     0.150
     6.418   199.820     0.150
     6.806   101.320     0.150
     6.806   210.719     0.150
     6.806   209.117     0.150
     6.834   101.320     0.150
     6.834   211.016     0.150
     6.834   101.914     0.150
     6.834   210.719     0.150
     7.046   103.516     0.150
     7.046   217.719     0.150
     7.489   110.719     0.150
     7.489   230.414     0.150
     7.489   109.633     0.150
     7.489   124.484     0.150
     7.489   229.469     0.150
     7.489   109.992     0.150
     7.489   110.820     0.150
     7.489   231.414     0.150
     7.489   109.125     0.150
     7.646   239.219     0.150
     7.646   109.914     0.150
     8.015   117.320     0.150
     7.942   235.617     0.150
     7.942   245.516     0.150
     7.942   116.219     0.150
     8.541   125.516     0.150
     8.541   266.414     0.150
     8.813   128.914     0.150
     8.813   273.016     0.150
     8.813   129.320     0.150
     8.975   130.820     0.150
     8.975   228.117     0.150
     8.975   278.914     0.150
     9.221   135.617     0.150
     9.221   134.539     0.150
     9.441   137.414     0.150
     9.441   172.156     0.150
     9.441   298.938     0.150
     9.466   300.383     0.150
    10.075   180.664     0.150
    10.075   308.664     0.150
    10.075   142.219     0.150
    10.075   256.516     0.150
    11.055   157.820     0.150
    11.780   166.617     0.150
    12.278   176.016     0.150
    12.278   380.117     0.150
    12.765   181.367     0.150
    12.765   183.719     0.150
    14.381   206.117     0.150
    15.144   215.219     0.150
    15.144   223.414     0.150
    15.144   397.414     0.150
    15.144   214.414     0.150
    15.283   217.914     0.150
    15.283   224.516     0.150
    15.726   221.516     0.150
    15.660   221.414     0.150
    16.080   228.016     0.150
    16.080   233.117     0.150
    16.101   226.617     0.150
    16.503   231.516     0.150
    16.503   232.852     0.150
    16.503   516.641     0.150
    16.784   234.047     0.150
    16.784   528.617     0.150
    16.897   410.930     0.150
    16.897   529.875     0.150
    17.328   244.219     0.150
    17.795   251.914     0.150
    17.894   251.414     0.150
    17.894   455.117     0.150
    18.041   250.719     0.150
    18.374   253.719     0.150
    18.374   458.719     0.150
    18.363   257.914     0.150
    18.363   467.617     0.150
    19.095   263.914     0.150
    19.095   478.617     0.150
    19.095   485.414     0.150
    19.766   271.805     0.150
    19.766   272.016     0.150
    19.766   271.305     0.150
    19.821   271.984     0.150
    19.821   500.211     0.150
    19.981   274.914     0.150
    19.981   272.836     0.150
    19.952   274.719     0.150
    19.952   503.617     0.150
    20.434   279.289     0.150
    20.434   635.195     0.150
    20.438   279.969     0.150
    20.438   279.516     0.150
    20.704   283.219     0.150
    20.704   288.516     0.150
    20.704   295.719     0.150
    20.704   518.516     0.150
    20.704   524.914     0.150
    20.704   282.320     0.150
    20.781   282.156     0.150
    20.796   282.648     0.150
    20.796   513.484     0.150
    20.842   283.469     0.150
    20.842   516.891     0.150
    21.108   287.516     0.150
    21.108   521.414     0.150
    21.108   528.117     0.150
    21.564   290.570     0.150
    21.564   528.547     0.150
    21.564   289.969     0.150
    21.564   530.969     0.150
    21.623   290.914     0.150
    21.623   291.219     0.150
    21.678   293.117     0.150
    21.658   291.516     0.150
    21.658   530.969     0.150
    21.658   684.641     0.150
    21.744   291.820     0.150
    21.744   527.789     0.150
    21.746   527.797     0.150
    21.787   292.617     0.150
    22.273   298.914     0.150
    22.273   546.414     0.150
    22.273   298.414     0.150
    23.520   310.320     0.150
    23.529   311.820     0.150
    23.529   336.516     0.150
    23.529   536.719     0.150
    23.529   604.719     0.150
    23.837   314.117     0.150
    23.837   339.719     0.150
    23.837   537.914     0.150
    23.837   610.320     0.150
    24.230   319.516     0.150
    24.230   586.617     0.150
    24.863   323.945     0.150
    25.216   326.820     0.150
    25.216   326.820     0.150
    25.135   325.953     0.150
    25.179   326.406     0.150
    25.179   327.117     0.150
    25.179   326.305     0.150
    25.251   327.375     0.150
    25.423   328.719     0.150
    25.483   328.023     0.150
    25.483   540.391     0.150
    25.487   328.320     0.150
    25.487   327.758     0.150
    25.487   327.719     0.150
    25.487   596.117     0.150
    25.489   328.258     0.150
    25.489   540.336     0.150
    25.455   330.219     0.150
    25.455   597.719     0.150
    25.455   329.156     0.150
    25.489   330.414     0.150
    25.489   601.414     0.150
    25.492   328.023     0.150
    25.775   332.117     0.150
    25.775   332.000     0.150
    25.758   331.344     0.150
    25.758   820.914     0.150
    25.758   332.586     0.150
    25.737   332.438     0.150
    25.737   603.969     0.150
    25.950   333.938     0.150
    26.005   332.555     0.150
    26.005   540.477     0.150
    26.041   619.211     0.150
    26.130   335.891     0.150
    26.446   338.117     0.150
    26.446   377.117     0.150
    26.446   609.914     0.150
    26.446   670.820     0.150
    26.446   336.711     0.150
    26.362   337.625     0.150
    26.523   340.414     0.150
    26.711   340.836     0.150
    26.711   629.766     0.150
    26.800   341.836     0.150
    26.784   343.195     0.150
    26.940   342.656     0.150
    27.161   345.070     0.150
    27.255   344.797     0.150
    27.255   642.438     0.150
    27.363   346.984     0.150
    27.425   347.219     0.150
    27.857   351.273     0.150
    27.940   351.961     0.150
    27.940   656.570     0.150
    28.289   356.219     0.150
    28.362   354.914     0.150
    28.512   358.867     0.150
    28.551   358.109     0.150
    28.551   358.469     0.150
    28.551   358.586     0.150
    28.551   357.320     0.150
    28.551   357.688     0.150
    28.815   361.266     0.150
    28.865   361.617     0.150
    28.865   648.516     0.150
    29.100   361.148     0.150
    29.330   367.008     0.150
    29.913   433.219     0.150
    29.913   672.914     0.150
    29.913   772.914     0.150
    30.024   370.914     0.150
    30.024   431.414     0.150
    30.024   554.617     0.150
    30.024   670.617     0.150
    30.024   766.414     0.150
    30.024   775.914     0.150
    30.024  1009.719     0.150
    30.078   370.820     0.150
    30.078   425.320     0.150
    30.078   549.820     0.150
    30.078   671.320     0.150
    30.078   369.109     0.150
    30.134   371.578     0.150
    30.453   373.719     0.150
    30.889   379.914     0.150
    30.889   379.492     0.150
    30.889   378.320     0.150
    30.970   378.273     0.150
    31.252   695.219     0.150
    31.348   382.469     0.150
    31.808   384.727     0.150
    31.951   387.617     0.150
    31.951   700.219     0.150
    31.951   704.914     0.150
    31.951   386.914     0.150
    32.239   389.914     0.150
    32.309   390.516     0.150
    32.332   390.219     0.150
    32.628   394.180     0.150
    33.059   397.523     0.150
    33.072   396.977     0.150
    33.351   399.906     0.150
    34.224   404.617     0.150
    34.309   408.117     0.150
    34.409   408.773     0.150
    34.409   408.320     0.150
    34.546   410.414     0.150
    34.640   411.516     0.150
    34.873   413.016     0.150
    34.901   413.820     0.150
    34.984   414.320     0.150
    35.040   414.516     0.150
    35.040   414.016     0.150
    35.058   415.320     0.150
    35.105   414.914     0.150
    35.133   415.820     0.150
    35.457   416.766     0.150
    35.631   420.016     0.150
    35.761   420.609     0.150
    35.761   420.117     0.150
    36.331   424.320     0.150
    36.331   425.344     0.150
    36.497   425.414     0.150
    36.497   771.320     0.150
    37.080   432.617     0.150
    37.080   517.719     0.150
    37.080   780.719     0.150
    37.296   433.516     0.150
    37.296   570.914     0.150
    37.296   783.820     0.150
    37.296   433.617     0.150
    37.296   571.016     0.150
    37.377   432.141     0.150
    37.377   432.891     0.150
    37.314   432.695     0.150
    37.314   432.820     0.150
    37.616   435.094     0.150
    37.859   437.320     0.150
    37.859   436.656     0.150
    37.859   437.180     0.150
    38.035   791.336     0.150
    38.035   438.406     0.150
    38.151   439.117     0.150
    38.211   442.414     0.150
    38.721   442.945     0.150
    38.721   532.320     0.150
    38.721   443.906     0.150
    38.721   444.336     0.150
    38.739   444.930     0.150
    38.787   444.508     0.150
    38.850   446.586     0.150
    38.850   445.719     0.150
    39.195   449.930     0.150
    39.195   448.828     0.150
    39.195   448.766     0.150
    39.195   579.117     0.150
    39.464   450.516     0.150
    39.680   452.289     0.150
    39.731   450.461     0.150
    40.097   455.219     0.150
    40.548   460.609     0.150
    40.620   461.047     0.150
    40.699   460.977     0.150
    40.739   459.914     0.150
    40.739   556.617     0.150
    40.739   830.016     0.150
    40.734   463.617     0.150
    40.892   464.242     0.150
    40.892   463.844     0.150
    41.149   465.891     0.150
    41.306   465.914     0.150
    41.306   838.719     0.150
    41.587   469.016     0.150
    41.587   565.719     0.150
    41.587   844.320     0.150
    41.587  1025.719     0.150
    41.587   468.016     0.150
    41.677   470.008     0.150
    41.677   846.828     0.150
    41.677   469.289     0.150
    41.804   468.414     0.150
    41.890   471.117     0.150
    41.890   847.320     0.150
    42.629   477.414     0.150
    42.592   476.617     0.150
    42.592   857.320     0.150
    42.612   476.414     0.150
    42.614   476.641     0.150
    42.752   476.969     0.150
    42.679   476.617     0.150
    42.679   858.914     0.150
    42.757   477.797     0.150
    43.159   481.867     0.150
    43.365   483.289     0.150
    43.386   579.516     0.150
    43.386   863.719     0.150
    43.799   486.258     0.150
    43.850   487.750     0.150
    44.078   488.656     0.150
    44.068   488.609     0.150
    44.068   487.414     0.150
    44.113   487.516     0.150
    44.147   490.289     0.150
    44.181   489.414     0.150
    44.207   488.539     0.150
    44.240   490.594     0.150
    44.240   490.750     0.150
    44.201   491.906     0.150
    44.253   491.516     0.150
    44.253   595.219     0.150
    44.412   492.883     0.150
    44.416   492.562     0.150
    44.420   492.117     0.150
    44.436   491.930     0.150
    44.433   492.820     0.150
    44.575   493.266     0.150
    44.585   493.109     0.150
    44.745   494.516     0.150
    44.797   495.469     0.150
    44.809   494.625     0.150
    44.809   495.367     0.150
    44.975   496.117     0.150
    45.014   496.328     0.150
    45.246   499.008     0.150
    45.166   498.117     0.150
    45.341   500.797     0.150
    45.321   498.773     0.150
    45.352   500.703     0.150
    45.352   500.164     0.150
    45.352   500.016     0.150
    45.352   599.117     0.150
    45.352   607.219     0.150
    45.352   903.219     0.150
    45.352   499.617     0.150
    45.389   500.219     0.150
    45.389   903.617     0.150
    45.473   499.914     0.150
    45.705   501.750     0.150
    45.666   501.234     0.150
    45.800   502.328     0.150
    45.800   903.641     0.150
    45.804   504.820     0.150
    45.802   503.125     0.150
    45.895   503.000     0.150
    45.973   504.289     0.150
    45.976   502.273     0.150
    46.011   505.016     0.150
    46.010   505.117     0.150
    46.010   911.117     0.150
    46.105   505.188     0.150
    46.155   504.336     0.150
    46.101   505.266     0.150
    46.168   505.828     0.150
    46.197   505.875     0.150
    46.280   507.250     0.150
    46.290   505.805     0.150
    46.229   505.117     0.150
    46.376   507.859     0.150
    46.440   507.539     0.150
    46.440   602.305     0.150
    46.479   507.688     0.150
    46.499   508.016     0.150
    46.509   507.977     0.150
    46.447   506.500     0.150
    46.518   508.820     0.150
    46.525   508.508     0.150
    46.685   509.727     0.150
    46.632   511.305     0.150
    46.632   510.820     0.150
    46.632   601.820     0.150
    46.846   510.867     0.150
    46.958   511.781     0.150
    46.958   511.578     0.150
    46.917   511.734     0.150
    46.918   512.117     0.150
    47.065   512.438     0.150
    47.105   512.820     0.150
    47.090   512.555     0.150
    47.176   513.711     0.150
    47.226   514.359     0.150
    47.197   514.320     0.150
    47.197  1132.719     0.150
    47.187   513.367     0.150
    47.308   512.117     0.150
    47.256   515.438     0.150
    47.373   515.047     0.150
    47.538   516.438     0.150
    47.481   517.484     0.150
    47.587   514.820     0.150
    47.587   932.914     0.150
    47.677   515.719     0.150
    47.633   516.680     0.150
    47.734   517.516     0.150
    47.734   607.234     0.150
    47.764   519.094     0.150
    47.737   518.117     0.150
    47.806   517.617     0.150
    47.806   935.719     0.150
    47.806   517.617     0.150
    47.941   519.930     0.150
    48.039   520.406     0.150
    48.039   608.086     0.150
    48.060   519.180     0.150
    48.060   518.836     0.150
    47.952   519.500     0.150
    48.143   519.016     0.150
    48.143   605.617     0.150
    48.252   521.305     0.150
    48.311   522.648     0.150
    48.298   521.664     0.150
    48.356   522.867     0.150
    48.356   609.797     0.150
    48.444   524.219     0.150
    48.476   523.914     0.150
    48.412   945.117     0.150
    48.412   608.117     0.150
    48.445   522.797     0.150
    48.478   523.727     0.150
    48.480   522.820     0.150
    48.480   522.672     0.150
    48.539   523.078     0.150
    48.572   522.688     0.150
    48.572   524.164     0.150
    48.600   524.414     0.150
    48.641   523.625     0.150
    48.682   524.719     0.150
    48.731   524.320     0.150
    48.834   526.688     0.150
    49.058   529.219     0.150
    49.060   528.695     0.150
    49.140   528.180     0.150
    49.239   530.320     0.150
    49.218   529.719     0.150
    49.218   643.117     0.150
    49.218   956.117     0.150
    49.516   532.727     0.150
    49.523   530.320     0.150
    49.572   532.750     0.150
    49.694   535.094     0.150
    49.671   532.516     0.150
    49.705   535.125     0.150
    49.705   533.656     0.150
    49.755   533.773     0.150
    49.741   533.258     0.150
    49.900   535.117     0.150
    49.900   533.758     0.150
    49.891   534.195     0.150
    49.891   615.078     0.150
    49.949   534.492     0.150
    50.027   535.320     0.150
    50.135   536.969     0.150
    50.253   537.719     0.150
    50.499   541.117     0.150
    50.499   657.117     0.150
    50.499  1193.117     0.150
    50.557   539.281     0.150
    50.654   540.828     0.150
    50.864   540.820     0.150
    50.864  1194.914     0.150
    50.910   543.336     0.150
    50.910   542.172     0.150
    50.922   542.953     0.150
    50.922   542.344     0.150
    51.146   544.258     0.150
    51.255   544.781     0.150
    51.306   545.406     0.150
    51.410   545.859     0.150
    51.445   546.695     0.150
    51.507   547.164     0.150
    51.507   989.898     0.150
    51.520   546.922     0.150
    51.649   547.219     0.150
    51.599   548.727     0.150
    51.678   548.930     0.150
    51.708   548.945     0.150
    51.762   548.133     0.150
    51.748   548.477     0.150
    51.748   548.297     0.150
    51.831   550.297     0.150
    51.821   548.977     0.150
    51.791   549.734     0.150
    51.833   549.273     0.150
    51.837   549.258     0.150
    51.876   549.609     0.150
    51.909   549.797     0.150
    51.883   549.477     0.150
    51.883   549.211     0.150
    52.026   550.867     0.150
    52.012   550.859     0.150
    52.012   553.086     0.150
    52.036   551.086     0.150
    52.036   550.570     0.150
    52.109   551.156     0.150
    52.116   552.188     0.150
    52.151   552.211     0.150
    52.233   552.570     0.150
    52.233   552.211     0.150
    52.235   553.219     0.150
    52.213   551.672     0.150
    52.231   552.219     0.150
    52.251   553.031     0.150
    52.399   554.438     0.150
    52.325   553.328     0.150
    52.374   553.211     0.150
    52.482   554.016     0.150
    52.442   553.320     0.150
    52.442   624.398     0.150
    52.478   552.914     0.150
    52.509   555.219     0.150
    52.509   676.820     0.150
    52.509  1000.117     0.150
    52.509  1023.516     0.150
    52.534   554.023     0.150
    52.534  1002.906     0.150
    52.602   554.867     0.150
    52.618   555.133     0.150
    52.623   556.352     0.150
    52.704   555.977     0.150
    52.749   556.602     0.150
    52.721   556.844     0.150
    52.777   557.359     0.150
    52.875   557.141     0.150
    52.875  1008.898     0.150
    52.857   557.031     0.150
    52.913   558.453     0.150
    52.913   558.023     0.150
    52.978   558.422     0.150
    52.978   557.820     0.150
    52.964   557.945     0.150
    53.030   558.680     0.150
    53.067   558.898     0.150
    53.226   559.461     0.150
    53.145   559.195     0.150
    53.145   559.414     0.150
    53.145   624.117     0.150
    53.145   558.914     0.150
    53.145   624.219     0.150
    53.404   562.016     0.150
    53.448   562.516     0.150
    53.458   561.414     0.150
    53.446   562.000     0.150
    53.491   562.789     0.150
    53.491   561.414     0.150
    53.538   561.867     0.150
    53.538   561.969     0.150
    53.520   562.461     0.150
    53.618   562.211     0.150
    53.552   561.719     0.150
    53.552  1017.617     0.150
    53.622   563.172     0.150
    53.649   562.648     0.150
    53.649   630.469     0.150
    53.658   563.570     0.150
    53.867   564.219     0.150
    53.867  1020.914     0.150
    53.867   564.742     0.150
    53.867   563.914     0.150
    53.889   564.875     0.150
    53.890  1020.820     0.150
    53.890   564.820     0.150
    53.898   564.398     0.150
    53.938   564.914     0.150
    53.990   565.219     0.150
    53.990  1022.617     0.150
    53.993   565.820     0.150
    53.993  1023.320     0.150
    53.973   565.219     0.150
    54.015   565.719     0.150
    54.015  1020.617     0.150
    54.077   566.016     0.150
    54.139   567.375     0.150
    54.139   566.016     0.150
    54.222   566.820     0.150
    54.184   567.883     0.150
    54.211   567.219     0.150
    54.211   567.117     0.150
    54.211  1031.617     0.150
    54.476   569.516     0.150
    54.544   568.719     0.150
    54.503   569.664     0.150
    54.478   569.570     0.150
    54.478   631.656     0.150
    54.542   568.758     0.150
    54.582   568.719     0.150
    54.584   570.352     0.150
    54.583   569.516     0.150
    54.600   570.156     0.150
    54.629   570.414     0.150
    54.629  1030.719     0.150
    54.633   569.914     0.150
    54.633  1032.219     0.150
    54.633   570.305     0.150
    54.645   569.438     0.150
    54.645   632.344     0.150
    54.645   693.117     0.150
    54.645   569.922     0.150
    54.645  1245.117     0.150
    54.662   570.172     0.150
    54.726  1029.117     0.150
    54.726   570.539     0.150
    54.695   571.039     0.150
    54.695   632.578     0.150
    54.784   571.414     0.150
    54.838   572.320     0.150
    54.862   571.672     0.150
    54.857   571.422     0.150
    54.944   572.430     0.150
    54.902   571.820     0.150
    54.902  1036.320     0.150
    54.922   572.930     0.150
    54.997   572.711     0.150
    55.009   572.516     0.150
    55.009  1041.516     0.150
    55.009  1273.719     0.150
    55.026   573.117     0.150
    55.026  1037.516     0.150
    55.039   573.414     0.150
    55.046   573.125     0.150
    55.087   573.320     0.150
    55.135   574.117     0.150
    55.147   574.086     0.150
    55.165   573.922     0.150
    55.152   573.797     0.150
    55.219  1041.414     0.150
    55.317   574.523     0.150
    55.336   575.398     0.150
    55.501   575.820     0.150
    55.561   577.297     0.150
    55.619   577.219     0.150
    55.612   577.719     0.150
    55.758   577.609     0.150
    55.696   577.773     0.150
    55.668   580.516     0.150
    55.713   577.969     0.150
    55.751   578.273     0.150
    55.761   578.016     0.150
    55.761  1047.719     0.150
    55.737   579.117     0.150
    55.806   578.523     0.150
    55.817   578.773     0.150
    55.906   577.094     0.150
    55.896   579.023     0.150
    55.969   578.516     0.150
    55.978   580.109     0.150
    56.024   580.719     0.150
    56.091   580.625     0.150
    56.096   580.914     0.150
    56.096  1050.117     0.150
    56.096   580.148     0.150
    56.133   580.320     0.150
    56.232   580.727     0.150
    56.160   581.719     0.150
    56.160   579.789     0.150
    56.149   580.594     0.150
    56.199   580.320     0.150
    56.213   581.672     0.150
    56.195   580.719     0.150
    56.256   581.820     0.150
    56.256   581.289     0.150
    56.256   581.344     0.150
    56.259   581.820     0.150
    56.259   581.414     0.150
    56.288   581.516     0.150
    56.323   582.516     0.150
    56.351   582.320     0.150
    56.334   582.914     0.150
    56.336   581.906     0.150
    56.391   583.070     0.150
    56.439   583.156     0.150
    56.439   583.320     0.150
    56.439   582.617     0.150
    56.516   584.008     0.150
    56.636   584.586     0.150
    56.647   584.117     0.150
    56.690   584.648     0.150
    56.690   585.172     0.150
    56.690   584.617     0.150
    56.738   584.914     0.150
    56.738   584.516     0.150
    56.704   584.977     0.150
    56.737   585.125     0.150
    56.813   584.898     0.150
    56.837   586.219     0.150
    56.856   586.117     0.150
    56.897   585.219     0.150
    56.908   586.719     0.150
    56.922   586.320     0.150
    56.991   586.773     0.150
    57.038   588.117     0.150
    57.047   586.945     0.150
    57.113   589.320     0.150
    57.150   588.414     0.150
    57.282   589.117     0.150
    57.282  1069.375     0.150
    57.288   588.891     0.150
    57.297   587.938     0.150
    57.320   588.914     0.150
    57.341   589.516     0.150
    57.352   588.617     0.150
    57.351   586.789     0.150
    57.367   590.820     0.150
    57.406   589.516     0.150
    57.440   588.930     0.150
    57.448   590.219     0.150
    57.441   590.016     0.150
    57.489   590.969     0.150
    57.555   590.516     0.150
    57.564   590.719     0.150
    57.608   591.516     0.150
    57.635   591.797     0.150
    57.656   591.914     0.150
    57.681   591.820     0.150
    57.736   591.516     0.150
    57.745   592.914     0.150
    57.746   591.414     0.150
    57.763   592.422     0.150
    57.777   592.734     0.150
    57.807   591.719     0.150
    57.827   593.172     0.150
    57.843   591.719     0.150
    57.891   593.188     0.150
    57.893   593.719     0.150
    57.952   593.641     0.150
    57.970   593.820     0.150
    57.996   593.656     0.150
    57.996   593.516     0.150
    58.043   594.914     0.150
    58.074   593.969     0.150
    58.090   594.516     0.150
    58.121   595.016     0.150
    58.259   596.008     0.150
    58.274   594.820     0.150
    58.330   596.547     0.150
    58.359   596.719     0.150
    58.367   595.656     0.150
    58.485   597.320     0.150
    58.493   596.320     0.150
    58.503   597.414     0.150
    58.503   596.320     0.150
    58.503   596.109     0.150
    58.530   597.781     0.150
    58.562   597.414     0.150
    58.562   597.164     0.150
    58.569   597.109     0.150
    58.579   598.227     0.150
    58.653   598.516     0.150
    58.657   598.117     0.150
    58.657   598.016     0.150
    58.674   598.438     0.150
    58.703   598.922     0.150
    58.701   598.914     0.150
    58.717   597.164     0.150
    58.721   598.320     0.150
    58.724   598.016     0.150
    58.730   598.016     0.150
    58.740   599.469     0.150
    58.741   600.156     0.150
    58.819   599.625     0.150
    58.819   599.016     0.150
    58.815   599.891     0.150
    58.825   602.219     0.150
    58.858   597.727     0.150
    58.859   598.617     0.150
    58.856   599.016     0.150
    58.919   599.016     0.150
    58.919   598.156     0.150
    58.928   598.156     0.150
    58.942   600.742     0.150
    58.959   600.523     0.150
    58.959   599.719     0.150
    58.945   600.617     0.150
    58.964   599.719     0.150
    59.023   601.336     0.150
    59.106   601.414     0.150
    59.084   603.414     0.150
    59.107   600.289     0.150
    59.152   601.617     0.150
    59.167   603.820     0.150
    59.287   601.617     0.150
    59.298   601.570     0.150
    59.302   602.016     0.150
    59.314   600.859     0.150
    59.334   602.219     0.150
    59.455   604.297     0.150
    59.450   603.516     0.150
    59.460   602.719     0.150
    59.495   603.914     0.150
    59.507   604.516     0.150
    59.538   604.219     0.150
    59.553   602.914     0.150
    59.553   603.117     0.150
    59.580   604.516     0.150
    59.611   604.719     0.150
    59.660   606.617     0.150
    59.683   602.719     0.150
    59.693   605.117     0.150
    59.703   605.117     0.150
    59.860   605.414     0.150
    59.897   606.617     0.150
    59.987   606.320     0.150
    60.010   606.414     0.150
    60.057   609.414     0.150
    60.086   607.719     0.150
    60.129   607.719     0.150
    60.155   607.820     0.150
    60.170   608.117     0.150
    60.221   608.914     0.150
    60.242   607.320     0.150
    60.298   609.219     0.150
    60.381   608.320     0.150
    60.389   609.516     0.150
    60.681   611.289     0.150
    60.682   612.117     0.150
    60.707   611.305     0.150
    60.707   655.969     0.150
    60.725   612.219     0.150
    60.877   613.375     0.150
    60.875   612.617     0.150
    60.850   615.820     0.150
    60.903   612.875     0.150
    60.934   612.789     0.150
    61.029   614.016     0.150
    61.047   615.227     0.150
    61.078   612.406     0.150
    61.098   615.188     0.150
    61.108   614.836     0.150
    61.164   614.070     0.150
    61.269   618.117     0.150
    61.317   615.688     0.150
    61.347   616.820     0.150
    61.378   615.859     0.150
    61.427   616.711     0.150
    61.581   617.188     0.150
    61.685   618.516     0.150
    61.827   619.156     0.150
    61.884   619.797     0.150
    62.174   621.328     0.150
    62.249   621.914     0.150
    62.209   623.312     0.150
    62.209   621.609     0.150
    62.238   622.414     0.150
    62.321   625.414     0.150
    62.865   629.820     0.150
    63.370   628.719     0.150
    63.348   629.336     0.150
    63.361   627.203     0.150
    63.361   627.570     0.150
    64.085   634.055     0.150
    64.710   639.820     0.150
    65.429   644.047     0.150
    65.471   643.469     0.150
    65.762   644.320     0.150
    66.016   645.664     0.150
    66.029   648.117     0.150
    66.163   647.016     0.150
    66.116   648.617     0.150
    66.116   646.391     0.150
    66.314   650.547     0.150
    66.621   652.453     0.150
    66.621   651.656     0.150
    66.730   653.016     0.150
    66.868   652.344     0.150
    66.995   654.789     0.150
    67.337   657.109     0.150
    67.382   655.234     0.150
    67.525   655.836     0.150
    67.589   658.195     0.150
    67.660   658.211     0.150
    67.700   657.898     0.150
    67.690   657.570     0.150
    67.928   658.930     0.150
    67.934   659.109     0.150
    68.141   660.820     0.150
    68.249   662.602     0.150
    68.267   662.273     0.150
    68.304   663.062     0.150
    68.520   663.727     0.150
    68.592   663.641     0.150
    68.520   664.070     0.150
    68.699   664.219     0.150
    68.775   666.016     0.150
    68.822   664.523     0.150
    68.873   665.117     0.150
    68.912   666.781     0.150
    68.990   667.719     0.150
    68.997   665.789     0.150
    69.032   667.711     0.150
    69.091   666.773     0.150
    69.155   667.445     0.150
    69.207   669.117     0.150
    69.428   668.719     0.150
    69.487   669.414     0.150
    69.487   668.758     0.150
    69.525   670.562     0.150
    69.650   670.508     0.150
    69.679   670.414     0.150
    69.691   671.656     0.150
    69.772   672.320     0.150
    69.781   671.695     0.150
    69.922   672.750     0.150
    69.922   672.328     0.150
    69.979   674.117     0.150
    70.058   672.711     0.150
    70.058   672.344     0.150
    69.964   674.219     0.150
    69.964   672.891     0.150
    70.119   672.727     0.150
    70.273   675.297     0.150
    70.308   675.234     0.150
    70.371   675.898     0.150
    70.392   675.617     0.150
    70.392  1225.219     0.150
    70.392  1500.914     0.150
    70.555   676.750     0.150
    70.617   676.414     0.150
    70.646   678.055     0.150
    70.833   678.516     0.150
    70.833  1234.219     0.150
    70.833  1512.117     0.150
    70.962   679.117     0.150
    71.035   679.797     0.150
    71.095   679.258     0.150
    71.095   678.141     0.150
    71.053   679.516     0.150
    71.053  1243.016     0.150
    71.053  1510.719     0.150
    71.118   679.633     0.150
    71.188   680.656     0.150
    71.216   678.164     0.150
    71.216   678.719     0.150
    71.220   680.617     0.150
    71.279   680.609     0.150
    71.383   680.820     0.150
    71.461   682.516     0.150
    71.546   683.180     0.150
    71.650   682.719     0.150
    71.738   684.078     0.150
    71.759   682.016     0.150
    71.823   682.391     0.150
    71.910   685.016     0.150
    71.910  1249.820     0.150
    71.910  1525.016     0.150
    71.910   684.461     0.150
    72.057   685.570     0.150
    72.122   686.562     0.150
    72.121   684.727     0.150
    72.188   686.625     0.150
    72.236   686.297     0.150
    72.306   686.914     0.150
    72.381   687.375     0.150
    72.397   687.438     0.150
    72.367   687.414     0.150
    72.408   687.719     0.150
    72.408   688.117     0.150
    72.408  1254.117     0.150
    72.482   687.711     0.150
    72.526   688.117     0.150
    72.537   688.164     0.150
    72.523   688.078     0.150
    72.624   688.961     0.150
    72.575  1257.914     0.150
    72.575  1538.320     0.150
    72.693   689.367     0.150
    72.739   688.961     0.150
    72.741   688.891     0.150
    72.689   689.117     0.150
    72.689  1258.914     0.150
    72.689  1537.219     0.150
    72.784   690.602     0.150
    72.809   690.609     0.150
    72.847   690.383     0.150
    72.847   690.008     0.150
    72.940   690.695     0.150
    73.028   692.320     0.150
    73.050   691.039     0.150
    73.087   689.734     0.150
    73.087   690.086     0.150
    73.132   694.016     0.150
    73.132   691.570     0.150
    73.177   692.930     0.150
    73.252  1266.516     0.150
    73.252  1547.320     0.150
    73.323   693.117     0.150
    73.323  1266.414     0.150
    73.323  1551.320     0.150
    73.380   693.984     0.150
    73.428   691.695     0.150
    73.478   694.016     0.150
    73.687   695.250     0.150
    73.701   694.930     0.150
    73.809   695.320     0.150
    73.845   696.445     0.150
    73.828   697.219     0.150
    73.828  1271.414     0.150
    73.929   696.523     0.150
    73.956   697.094     0.150
    73.974   697.750     0.150
    73.916   695.805     0.150
    73.991   697.438     0.150
    74.130   696.703     0.150
    74.088   697.719     0.150
    74.191   697.039     0.150
    74.218   696.547     0.150
    74.272   698.719     0.150
    74.272  1276.914     0.150
    74.272  1565.414     0.150
    74.388   699.516     0.150
    74.388  1274.367     0.150
    74.388   699.719     0.150
    74.451   699.148     0.150
    74.460   699.500     0.150
    74.538   699.969     0.150
    74.507   699.516     0.150
    74.569   700.617     0.150
    74.569  1281.617     0.150
    74.569   700.320     0.150
    74.717   701.805     0.150
    74.793   702.414     0.150
    74.793  1284.617     0.150
    74.793  1573.117     0.150
    74.831   700.516     0.150
    74.875   701.375     0.150
    74.840   702.320     0.150
    74.918   702.695     0.150
    74.920   701.930     0.150
    74.920   701.758     0.150
    74.920   701.758     0.150
    74.920   701.719     0.150
    74.966   702.617     0.150
    75.020   703.141     0.150
    75.020  1281.461     0.150
    75.020   703.414     0.150
    75.020  1286.320     0.150
    75.020  1580.320     0.150
    75.140   704.398     0.150
    75.191   703.414     0.150
    75.191   703.609     0.150
    75.240  1288.516     0.150
    75.353   703.719     0.150
    75.491   706.117     0.150
    75.494   706.016     0.150
    75.507   704.336     0.150
    75.527   705.828     0.150
    75.548   704.305     0.150
    75.558   706.016     0.150
    75.715   706.891     0.150
    75.781   705.898     0.150
    75.865   707.734     0.150
    75.873   705.891     0.150
    75.894   706.883     0.150
    75.970   708.891     0.150
    76.021   708.625     0.150
    76.113   708.547     0.150
    76.145   709.336     0.150
    76.258   709.820     0.150
    76.258   710.477     0.150
    76.261   708.883     0.150
    76.276   710.820     0.150
    76.284   709.055     0.150
    76.311   709.258     0.150
    76.322   710.336     0.150
    76.335   709.203     0.150
    76.396   710.219     0.150
    76.396   709.289     0.150
    76.442   711.438     0.150
    76.449   709.719     0.150
    76.487   712.359     0.150
    76.516   710.742     0.150
    76.591   710.367     0.150
    76.621   710.922     0.150
    76.621   710.688     0.150
    76.635   711.102     0.150
    76.713   712.695     0.150
    76.788   712.172     0.150
    76.788   712.070     0.150
    76.795   711.820     0.150
    76.793   712.750     0.150
    76.818   711.539     0.150
    76.832   712.273     0.150
    76.856   712.195     0.150
    76.929   713.773     0.150
    76.957   712.586     0.150
    76.999   714.711     0.150
    76.999   713.766     0.150
    77.004   714.211     0.150
    77.008   713.664     0.150
    77.023   713.453     0.150
    77.034   713.016     0.150
    77.054   714.008     0.150
    77.071   714.398     0.150
    77.076   713.766     0.150
    77.104   714.312     0.150
    77.048   714.203     0.150
    77.165   714.508     0.150
    77.176   714.055     0.150
    77.219   716.336     0.150
    77.209   714.984     0.150
    77.219   715.320     0.150
    77.219   715.594     0.150
    77.280   715.859     0.150
    77.300   714.945     0.150
    77.300   714.648     0.150
    77.332   714.992     0.150
    77.336   715.609     0.150
    77.420   716.945     0.150
    77.440   716.516     0.150
    77.446   716.828     0.150
    77.470   715.836     0.150
    77.487   716.250     0.150
    77.497   715.914     0.150
    77.510   716.305     0.150
    77.532   716.594     0.150
    77.470   715.938     0.150
    77.465   716.109     0.150
    77.551   716.047     0.150
    77.574   717.539     0.150
    77.583   718.281     0.150
    77.588   717.891     0.150
    77.642   717.773     0.150
    77.647   717.320     0.150
    77.677   717.438     0.150
    77.670   717.938     0.150
    77.684   718.305     0.150
    77.680   716.875     0.150
    77.624   716.820     0.150
    77.693   717.391     0.150
    77.631   716.570     0.150
    77.633   716.711     0.150
    77.707   717.742     0.150
    77.726   718.477     0.150
    77.726   717.977     0.150
    77.736   717.422     0.150
    77.686   717.000     0.150
    77.778   717.328     0.150
    77.779   718.047     0.150
    77.820   719.398     0.150
    77.832   718.664     0.150
    77.859   718.250     0.150
    77.862   718.188     0.150
    77.877   717.969     0.150
    77.887   718.609     0.150
    77.890   718.930     0.150
    77.890   718.680     0.150
    77.902   718.930     0.150
    77.924   718.617     0.150
    77.945   719.328     0.150
    77.944   718.398     0.150
    77.944   718.539     0.150
    77.972   718.719     0.150
    77.982   719.297     0.150
    77.991   720.414     0.150
    78.023   719.320     0.150
    78.023   719.961     0.150
    78.049   718.805     0.150
    78.106   720.844     0.150
    78.129   719.586     0.150
    78.199   719.664     0.150
    78.236   721.695     0.150
    78.242   720.273     0.150
    78.256   720.570     0.150
    78.259   720.375     0.150
    78.272   720.750     0.150
    78.295   720.352     0.150
    78.300   720.227     0.150
    78.300   720.461     0.150
    78.322   721.125     0.150
    78.367   721.320     0.150
    78.375   722.461     0.150
    78.381   721.891     0.150
    78.381   721.125     0.150
    78.417   721.820     0.150
    78.426   721.148     0.150
    78.450   722.398     0.150
    78.473   722.539     0.150
    78.474   722.336     0.150
    78.497   721.234     0.150
    78.524   722.680     0.150
    78.551   723.680     0.150
    78.569   721.969     0.150
    78.567   721.852     0.150
    78.567   722.141     0.150
    78.579   721.781     0.150
    78.585   722.219     0.150
    78.596   723.039     0.150
    78.654   722.961     0.150
    78.681   723.242     0.150
    78.681   723.141     0.150
    78.679   722.180     0.150
    78.710   723.617     0.150
    78.794   724.617     0.150
    78.803   724.766     0.150
    78.821   724.773     0.150
    78.849   723.359     0.150
    78.851   724.555     0.150
    78.864   724.047     0.150
    78.919   724.984     0.150
    78.954   725.445     0.150
    78.955   725.461     0.150
    78.944   725.117     0.150
    78.947   724.562     0.150
    78.964   725.508     0.150
    78.957   723.469     0.150
    78.957   724.609     0.150
    78.985   725.844     0.150
    79.036   725.359     0.150
    79.041   724.164     0.150
    79.044   725.000     0.150
    79.030   725.320     0.150
    79.038   724.438     0.150
    79.043   725.172     0.150
    79.043   725.320     0.150
    79.052   724.578     0.150
    79.053   725.602     0.150
    79.072   725.539     0.150
    79.105   726.461     0.150
    79.095   725.328     0.150
    79.101   725.266     0.150
    79.113   725.789     0.150
    79.116   724.586     0.150
    79.131   725.758     0.150
    79.138   726.219     0.150
    79.123   726.094     0.150
    79.123   725.359     0.150
    79.159   726.180     0.150
    79.168   726.609     0.150
    79.180   725.312     0.150
    79.180   725.750     0.150
    79.184   726.438     0.150
    79.172   726.305     0.150
    79.203   725.867     0.150
    79.206   727.086     0.150
    79.202   725.430     0.150
    79.218   726.359     0.150
    79.211   726.523     0.150
    79.227   726.000     0.150
    79.232   726.023     0.150
    79.240   726.938     0.150
    79.265   726.336     0.150
    79.276   726.680     0.150
    79.299   727.320     0.150
    79.307   726.438     0.150
    79.296   725.609     0.150
    79.313   725.516     0.150
    79.313   725.719     0.150
    79.340   726.234     0.150
    79.342   726.500     0.150
    79.353   727.234     0.150
    79.361   727.555     0.150
    79.372   726.930     0.150
    79.369   726.703     0.150
    79.389   725.961     0.150
    79.410   727.898     0.150
    79.415   726.531     0.150
    79.454   727.156     0.150
    79.454   727.555     0.150
    79.471   728.016     0.150
    79.479   727.242     0.150
    79.495   728.648     0.150
    79.540   728.070     0.150
    79.553   727.484     0.150
    79.611   729.297     0.150
    79.614   728.617     0.150
    79.614   728.555     0.150
    79.615   728.594     0.150
    79.618   728.531     0.150
    79.634   727.852     0.150
    79.655   729.219     0.150
    79.672   729.086     0.150
    79.665   728.781     0.150
    79.665   728.984     0.150
    79.675   729.125     0.150
    79.679   728.758     0.150
    79.721   729.016     0.150
    79.727   728.289     0.150
    79.746   728.453     0.150
    79.746   728.836     0.150
    79.802   728.320     0.150
    79.827   728.945     0.150
    79.835   728.234     0.150
    79.849   730.070     0.150
    79.840   729.445     0.150
    79.852   729.070     0.150
    79.892   730.336     0.150
    80.026   729.352     0.150
    80.026   729.711     0.150
    79.923   729.164     0.150
    79.937   730.430     0.150
    79.968   728.961     0.150
    79.978   729.648     0.150
    79.970   729.680     0.150
    79.969   729.820     0.150
    79.969   730.500     0.150
    80.064   730.430     0.150
    80.115   731.875     0.150
    80.122   730.773     0.150
    80.169   732.227     0.150
    80.174   732.039     0.150
    80.187   732.398     0.150
    80.208   731.445     0.150
    80.208   732.086     0.150
    80.236   730.852     0.150
    80.257   732.109     0.150
    80.264   732.203     0.150
    80.298   730.445     0.150
    80.300   732.664     0.150
    80.316   732.078     0.150
    80.344   733.117     0.150
    80.344   732.539     0.150
    80.345   732.023     0.150
    80.345   732.430     0.150
    80.341   731.547     0.150
    80.351   733.242     0.150
    80.347   731.719     0.150
    80.356   732.289     0.150
    80.361   731.656     0.150
    80.357   733.227     0.150
    80.357   732.344     0.150
    80.366   732.656     0.150
    80.400   733.359     0.150
    80.415   732.062     0.150
    80.451   732.352     0.150
    80.487   732.586     0.150
    80.487   732.734     0.150
    80.487   733.445     0.150
    80.514   733.719     0.150
    80.558   734.141     0.150
    80.562   732.750     0.150
    80.565   733.484     0.150
    80.565   733.023     0.150
    80.566   732.938     0.150
    80.609   733.812     0.150
    80.609   733.961     0.150
    80.611   733.125     0.150
    80.634   733.578     0.150
    80.634   733.398     0.150
    80.664   733.828     0.150
    80.664   733.430     0.150
    80.609   734.219     0.150
    80.679   734.602     0.150
    80.737   734.914     0.150
    80.737   734.250     0.150
    80.738   734.375     0.150
    80.742   733.961     0.150
    80.757   735.062     0.150
    80.771   734.031     0.150
    80.816   734.438     0.150
    80.823   733.984     0.150
    80.833   735.266     0.150
    80.792   735.117     0.150
    80.891   735.859     0.150
    80.901   734.820     0.150
    80.922   736.078     0.150
    80.939   735.719     0.150
    80.939   736.000     0.150
    80.941   736.266     0.150
    80.961   736.234     0.150
    80.983   736.195     0.150
    80.985   736.250     0.150
    81.079   735.578     0.150
    81.145   736.938     0.150
    81.072   737.016     0.150
    81.140   735.758     0.150
    81.166   736.469     0.150
    81.171   736.344     0.150
    81.202   736.781     0.150
    81.233   737.000     0.150
    81.264   737.875     0.150
    81.183   736.328     0.150
    81.184   736.281     0.150
    81.261   736.703     0.150
    81.268   736.516     0.150
    81.275   737.383     0.150
    81.348   738.125     0.150
    81.349   736.750     0.150
    81.350   737.344     0.150
    81.389   737.984     0.150
    81.453   737.258     0.150
    81.472   738.656     0.150
    81.491   738.648     0.150
    81.510   738.977     0.150
    81.510   739.297     0.150
    81.503   737.648     0.150
    81.527   739.250     0.150
    81.527   738.586     0.150
    81.533   738.609     0.150
    81.561   738.094     0.150
    81.587   738.398     0.150
    81.598   739.930     0.150
    81.613   738.562     0.150
    81.637   738.359     0.150
    81.696   740.273     0.150
    81.709   738.984     0.150
    81.714   739.719     0.150
    81.731   739.297     0.150
    81.771   738.977     0.150
    81.771   739.117     0.150
    81.778   740.625     0.150
    81.770   739.742     0.150
    81.770   739.445     0.150
    81.845   739.852     0.150
    81.845   739.977     0.150
    81.845   739.219     0.150
    81.862   739.625     0.150
    81.881   741.297     0.150
    81.884   739.570     0.150
    81.889   739.984     0.150
    81.902   740.281     0.150
    81.907   740.320     0.150
    81.930   741.453     0.150
    81.927   740.094     0.150
    81.927   739.570     0.150
    81.931   741.062     0.150
    81.934   740.734     0.150
    81.950   739.148     0.150
    81.964   741.711     0.150
    82.021   740.180     0.150
    82.033   741.820     0.150
    82.033   742.062     0.150
    82.096   741.469     0.150
    82.102   740.859     0.150
    82.136   740.875     0.150
    82.139   740.945     0.150
    82.137   742.297     0.150
    82.189   741.617     0.150
    82.268   741.586     0.150
    82.265   741.891     0.150
    82.265   741.484     0.150
    82.301   742.055     0.150
    82.301   741.773     0.150
    82.303   742.188     0.150
    82.303   742.008     0.150
    82.303   741.695     0.150
    82.302   742.406     0.150
    82.310   742.688     0.150
    82.352   742.789     0.150
    82.354   743.133     0.150
    82.401   742.906     0.150
    82.423   742.617     0.150
    82.423   742.438     0.150
    82.425   743.297     0.150
    82.464   743.117     0.150
    82.472   742.930     0.150
    82.539   743.531     0.150
    82.539   743.336     0.150
    82.557   743.664     0.150
    82.608   743.273     0.150
    82.622   743.719     0.150
    82.647   743.625     0.150
    82.647   743.750     0.150
    82.666   744.555     0.150
    82.681   744.539     0.150
    82.690   744.828     0.150
    82.709   743.562     0.150
    82.710   743.695     0.150
    82.715   744.562     0.150
    82.731   744.688     0.150
    82.793   745.031     0.150
    82.799   745.102     0.150
    82.855   744.914     0.150
    82.891   744.867     0.150
    82.926   745.141     0.150
    82.975   745.078     0.150
    83.024   745.734     0.150
    83.026   745.727     0.150
    83.028   745.438     0.150
    83.059   746.617     0.150
    83.059   747.570     0.150
    83.061   746.469     0.150
    83.061   746.195     0.150
    83.066   745.648     0.150
    83.066   746.625     0.150
    83.081   745.914     0.150
    83.095   746.016     0.150
    83.095   746.688     0.150
    83.155   746.469     0.150
    83.154   746.727     0.150
    83.194   746.883     0.150
    83.219   746.656     0.150
    83.279   746.992     0.150
    83.324   748.055     0.150
    83.377   747.445     0.150
    83.377   747.945     0.150
    83.376   748.234     0.150
    83.406   747.977     0.150
    83.423   747.727     0.150
    83.428   748.164     0.150
    83.452   748.180     0.150
    83.463   747.938     0.150
    83.472   748.414     0.150
    83.473   747.914     0.150
    83.473   748.039     0.150
    83.480   747.398     0.150
    83.532   748.031     0.150
    83.571   749.219     0.150
    83.509   751.320     0.150
    83.509   750.094     0.150
    83.509   749.836     0.150
    83.615   748.922     0.150
    83.632   748.977     0.150
    83.674   748.805     0.150
    83.683   749.125     0.150
    83.719   749.055     0.150
    83.727   751.594     0.150
    83.738   750.656     0.150
    83.738   749.430     0.150
    83.746   751.117     0.150
    83.748   749.820     0.150
    83.754   748.867     0.150
    83.754   748.648     0.150
    83.760   749.844     0.150
    83.761   749.797     0.150
    83.842   750.547     0.150
    83.848   750.219     0.150
    83.848   750.023     0.150
    83.930   750.523     0.150
    83.933   750.828     0.150
    83.952   750.398     0.150
    83.952   750.766     0.150
    83.952   750.898     0.150
    83.963   751.055     0.150
    84.068   750.828     0.150
    84.110   751.914     0.150
    84.110   752.523     0.150
    84.102   751.695     0.150
    84.170   751.688     0.150
    84.082   753.430     0.150
    84.205   751.586     0.150
    84.303   752.391     0.150
    84.310   752.664     0.150
    84.359   752.523     0.150
    84.365   752.398     0.150
    84.366   752.961     0.150
    84.482   754.414     0.150
    84.482   754.055     0.150
    84.512   753.656     0.150
    84.512   753.469     0.150
    84.522   752.938     0.150
    84.529   753.516     0.150
    84.529   754.039     0.150
    84.550   754.188     0.150
    84.556   753.859     0.150
    84.564   754.250     0.150
    84.569   754.273     0.150
    84.583   754.391     0.150
    84.630   754.211     0.150
    84.636   754.625     0.150
    84.765   754.469     0.150
    84.772   754.594     0.150
    84.871   754.977     0.150
    84.870   755.320     0.150
    84.885   757.008     0.150
    84.885   756.359     0.150
    84.969   755.930     0.150
    84.969   756.406     0.150
    85.020   755.711     0.150
    85.026   756.594     0.150
    85.041   756.852     0.150
    85.041   756.609     0.150
    85.033   756.555     0.150
    85.119   757.102     0.150
    85.175   756.578     0.150
    85.175   756.359     0.150
    85.219   757.789     0.150
    85.284   757.516     0.150
    85.284   757.625     0.150
    85.287   757.344     0.150
    85.327   758.109     0.150
    85.374   758.320     0.150
    85.374   758.914     0.150
    85.431   758.445     0.150
    85.443   758.641     0.150
    85.468   758.320     0.150
    85.478   758.008     0.150
    85.497   758.273     0.150
    85.610   758.906     0.150
    85.615   759.664     0.150
    85.627   759.219     0.150
    85.627   759.336     0.150
    85.628   759.227     0.150
    85.636   759.398     0.150
    85.645   759.852     0.150
    85.655   759.258     0.150
    85.690   759.344     0.150
    85.746   759.625     0.150
    85.773   759.477     0.150
    85.790   759.711     0.150
    85.822   760.227     0.150
    85.822   760.328     0.150
    85.921   760.227     0.150
    85.921   760.680     0.150
    85.932   760.016     0.150
    85.941   760.641     0.150
    86.387   761.555     0.150
    86.098   761.398     0.150
    86.098   761.086     0.150
    86.154   761.547     0.150
    86.154   761.969     0.150
    86.486   762.180     0.150
    86.241   762.844     0.150
    86.283   762.711     0.150
    86.289   762.328     0.150
    86.310   762.617     0.150
    86.310   762.344     0.150
    86.320   762.586     0.150
    86.325   762.945     0.150
    86.331   763.586     0.150
    86.334   762.820     0.150
    86.334   763.117     0.150
    86.362   762.250     0.150
    86.404   763.750     0.150
    86.441   762.977     0.150
    86.533   763.625     0.150
    86.581   764.180     0.150
    86.581   763.773     0.150
    86.616   764.211     0.150
    86.645   764.406     0.150
    86.739   764.641     0.150
    86.739   765.664     0.150
    86.769   764.820     0.150
    86.769   765.102     0.150
    86.770   764.836     0.150
    86.686   765.617     0.150
    86.806   765.117     0.150
    86.827   765.453     0.150
    86.827   764.719     0.150
    86.835   765.352     0.150
    86.835   765.047     0.150
    86.882   765.508     0.150
    86.939   766.031     0.150
    86.983   766.148     0.150
    86.983   766.250     0.150
    87.045   766.156     0.150
    87.064   766.875     0.150
    87.092   766.359     0.150
    87.160   767.266     0.150
    87.160   766.961     0.150
    87.168   766.102     0.150
    87.197   767.328     0.150
    87.197   766.922     0.150
    87.265   766.977     0.150
    87.314   767.758     0.150
    87.347   766.977     0.150
    87.366   767.219     0.150
    87.309   767.891     0.150
    87.412   767.664     0.150
    87.421   768.414     0.150
    87.427   768.430     0.150
    87.427   768.875     0.150
    87.519   768.477     0.150
    87.536   768.008     0.150
    87.540   768.320     0.150
    87.545   768.773     0.150
    87.561   768.875     0.150
    87.561   768.555     0.150
    87.632   768.719     0.150
    87.647   768.406     0.150
    87.686   769.062     0.150
    87.694   769.969     0.150
    87.689   769.102     0.150
    87.696   769.016     0.150
    87.852   770.188     0.150
    87.852   769.414     0.150
    87.954   771.250     0.150
    87.968   770.758     0.150
    88.058   771.359     0.150
    88.091   771.633     0.150
    88.104   771.266     0.150
    88.176   772.164     0.150
    88.190   772.367     0.150
    88.197   771.852     0.150
    88.235   772.289     0.150
    88.248   771.820     0.150
    88.247   771.898     0.150
    88.247   772.016     0.150
    88.320   772.891     0.150
    88.338   772.977     0.150
    88.343   772.500     0.150
    88.370   773.492     0.150
    88.392   772.875     0.150
    88.392   773.109     0.150
    88.505   773.641     0.150
    88.522   773.750     0.150
    88.540   773.688     0.150
    88.605   774.164     0.150
    88.665   774.516     0.150
    88.703   774.422     0.150
    88.710   775.117     0.150
    88.723   774.914     0.150
    88.789   774.555     0.150
    88.841   775.086     0.150
    88.873   774.695     0.150
    88.925   775.297     0.150
    89.029   775.289     0.150
    89.054   776.250     0.150
    89.054   776.508     0.150
    89.061   775.898     0.150
    89.114   776.430     0.150
    89.129   776.664     0.150
    89.129   776.805     0.150
    89.130   776.766     0.150
    89.149   776.914     0.150
    89.149   776.680     0.150
    89.143   776.609     0.150
    89.143   776.906     0.150
    89.152   776.125     0.150
    89.170   776.859     0.150
    89.209   777.656     0.150
    89.209   776.789     0.150
    89.370   777.516     0.150
    89.439   778.508     0.150
    89.459   777.633     0.150
    89.469   778.320     0.150
    89.497   777.570     0.150
    89.497   777.750     0.150
    89.521   778.805     0.150
    89.582   778.438     0.150
    89.562   778.016     0.150
    89.562  1427.320     0.150
    89.562  1787.016     0.150
    89.562   779.758     0.150
    89.648   779.438     0.150
    89.648   779.805     0.150
    89.661   778.734     0.150
    89.662   779.031     0.150
    89.673   779.117     0.150
    89.673   778.797     0.150
    89.714   779.430     0.150
    89.714   780.289     0.150
    90.035   780.703     0.150
    90.095   782.164     0.150
    90.144   780.977     0.150
    90.209   781.547     0.150
    90.220   781.680     0.150
    90.360   782.305     0.150
    90.393   782.688     0.150
    90.511   784.648     0.150
    90.508   783.570     0.150
    90.489   782.094     0.150
    90.652   783.547     0.150
    90.668   784.516     0.150
    90.719   783.805     0.150
    90.750   784.914     0.150
    90.757   783.875     0.150
    90.692   782.766     0.150
    91.139   785.406     0.150
    91.139   785.695     0.150
    91.270   786.570     0.150
    91.302   787.273     0.150
    91.354   786.820     0.150
    91.594   788.352     0.150
    91.594   788.070     0.150
    92.069   791.219     0.150
    92.696   794.250     0.150
    95.616   806.664     0.150
    99.962   825.969     0.150
    99.962   826.414     0.150
   100.065   827.016     0.150
   100.172   827.414     0.150
   100.431   829.820     0.150
   122.025  1134.180     0.150
   124.643  1140.711     0.150
   128.616  1148.023     0.150
   129.003  1147.953     0.150
   130.254  1153.570     0.150
   130.404  1151.516     0.150
   130.743  1153.258     0.150
   132.973  1156.320     0.150
   132.973  1156.867     0.150
   133.094  1159.078     0.150
   134.230  1158.500     0.150
   135.828  1163.148     0.150
   136.555  1161.070     0.150
   136.555  1160.898     0.150
   136.767  1165.586     0.150
   137.120  1165.250     0.150
   137.281  1167.336     0.150
   137.378  1164.789     0.150
   138.291  1166.984     0.150
   138.574  1168.734     0.150
   139.141  1168.969     0.150
   139.159  1168.039     0.150
   139.675  1168.617     0.150
   139.845  1168.734     0.150
   140.291  1168.820     0.150
   140.291  1171.055     0.150
   143.070  1177.461     0.150
   143.676  1173.461     0.150
   144.443  1176.156     0.150
   144.698  1176.188     0.150
   144.810  1176.320     0.150
   144.959  1177.328     0.150
   145.076  1175.820     0.150
   145.425  1180.016     0.150
   145.614  1179.406     0.150
   145.720  1180.406     0.150
   145.799  1177.758     0.150
   146.548  1182.789     0.150
   146.548  1182.359     0.150
   146.548  1183.273     0.150
   146.605  1181.766     0.150
   147.074  1183.734     0.150
   147.110  1182.484     0.150
   149.513  1188.508     0.150
   149.647  1190.219     0.150
   149.647  1186.258     0.150
   149.900  1185.766     0.150
   149.900  1189.984     0.150
   151.356  1193.516     0.150
   151.646  1194.648     0.150
   152.087  1194.508     0.150
   152.803  1193.273     0.150
     0.214     4.219     0.150
     0.214     7.625     0.150
     0.603    11.125     0.150
     0.603    19.422     0.150
     1.077    20.219     0.150
     1.077    35.023     0.150
     1.238    22.625     0.150
     1.238    44.125     0.150
     1.238    22.820     0.150
     1.238    39.922     0.150
     1.545    27.820     0.150
     1.545    49.023     0.150
     1.545    48.922     0.150
     1.758    31.719     0.150
     1.758    55.125     0.150
     1.758    31.523     0.150
     1.758    55.422     0.150
     1.976    35.523     0.150
     1.976    36.422     0.150
     1.976    62.422     0.150
     1.976    35.422     0.150
     1.976    60.422     0.150
     1.976    61.820     0.150
     2.487    43.422     0.150
     2.487    78.422     0.150
     2.487    43.125     0.150
     2.487    47.125     0.150
     2.487    73.523     0.150
     2.487    78.023     0.150
     2.548    43.125     0.150
     2.548    47.320     0.150
     2.548    80.820     0.150
     2.548    42.922     0.150
     2.548    46.719     0.150
     2.548    80.320     0.150
     3.314    54.023     0.150
     3.314    58.219     0.150
     3.314    60.625     0.150
     3.314   103.922     0.150
     3.314    53.625     0.150
     3.314    61.320     0.150
     3.314   103.820     0.150
     3.462    56.023     0.150
     3.462    62.719     0.150
     3.462   107.719     0.150
     3.464    54.820     0.150
     3.464    62.320     0.150
     3.464    96.922     0.150
     3.464   105.523     0.150
     3.820    60.125     0.150
     3.820    69.625     0.150
     3.820   120.219     0.150
     3.820   105.523     0.150
     4.059   125.922     0.150
     4.059    61.820     0.150
     4.059   107.219     0.150
     4.059   122.023     0.150
     4.117    73.523     0.150
     4.117   129.125     0.150
     4.392    68.219     0.150
     4.392    78.125     0.150
     4.392   135.922     0.150
     4.332    77.219     0.150
     4.332   135.523     0.150
     5.302   163.219     0.150
     5.528    97.422     0.150
     5.528   168.023     0.150
     5.528   172.125     0.150
     5.600   174.422     0.150
     5.876   183.422     0.150
     6.065   110.922     0.150
     6.129   191.820     0.150
     6.442    95.219     0.150
     6.442   118.023     0.150
     6.442   201.820     0.150
     6.442    95.422     0.150
     6.442   198.125     0.150
     6.816   212.523     0.150
     7.056   219.219     0.150
     7.498   231.719     0.150
     7.949   245.625     0.150
     8.552   265.023     0.150
     8.820   273.219     0.150
     8.978   277.422     0.150
     9.459   296.844     0.150
    11.056   343.719     0.150
    21.559   292.820     0.150
    21.624   292.672     0.150
    21.654   292.797     0.150
    42.593   477.508     0.150
     0.213     4.117     0.150
     0.213     7.422     0.150
     0.213     7.117     0.150
     0.603    11.219     0.150
     0.603    19.719     0.150
     1.078    20.117     0.150
     1.078    35.016     0.150
     1.078    34.422     0.150
     1.237    22.922     0.150
     1.237    39.617     0.150
     1.237    22.820     0.150
     1.237    39.820     0.150
     1.543    27.516     0.150
     1.543    48.320     0.150
     1.543    51.320     0.150
     1.543    28.219     0.150
     1.543    49.016     0.150
     1.758    31.617     0.150
     1.758    55.016     0.150
     1.758    56.320     0.150
     1.976    36.016     0.150
     1.976    62.516     0.150
     1.976    35.719     0.150
     2.486    43.219     0.150
     2.486    46.016     0.150
     2.486    78.422     0.150
     2.549    43.219     0.150
     2.549    47.219     0.150
     2.549    80.617     0.150
     2.549    42.719     0.150
     2.549    46.719     0.150
     2.549    80.016     0.150
     3.313    53.617     0.150
     3.313   103.219     0.150
     3.463    53.922     0.150
     3.463    63.617     0.150
     3.463    95.820     0.150
     3.463   107.516     0.150
     3.462    55.719     0.150
     3.462    62.016     0.150
     3.462    64.617     0.150
     3.462   105.422     0.150
     3.462   107.922     0.150
     3.821    60.320     0.150
     3.821    69.820     0.150
     3.821   120.117     0.150
     3.821    60.219     0.150
     3.821    69.422     0.150
     3.821   104.719     0.150
     3.821   118.820     0.150
     4.116    73.922     0.150
     4.116   112.320     0.150
     4.116   128.117     0.150
     4.333    77.422     0.150
     4.333   135.117     0.150
     4.391    68.516     0.150
     4.391    79.820     0.150
     4.391   136.820     0.150
     5.302   165.320     0.150
     5.527    97.719     0.150
     5.527    99.719     0.150
     5.527   167.117     0.150
     5.527   171.719     0.150
     5.600   173.820     0.150
     6.065   110.320     0.150
     6.065   189.016     0.150
     6.130   184.219     0.150
     6.130   190.719     0.150
     6.432   199.820     0.150
     6.442    95.320     0.150
     6.442   116.820     0.150
     6.442   201.719     0.150
     6.442    95.516     0.150
     6.442   200.320     0.150
     6.816   210.219     0.150
     7.055   217.820     0.150
     7.498   231.016     0.150
     7.948   132.617     0.150
     7.948   245.617     0.150
     8.819   272.219     0.150
     8.977   161.422     0.150
     8.977   278.016     0.150
    10.062   144.516     0.150
    10.062   257.719     0.150
     0.212     4.191     0.150
     0.212     7.594     0.150
     0.594    10.594     0.150
     0.594    18.691     0.150
     1.085    20.293     0.150
     1.085    34.895     0.150
     1.234    22.293     0.150
     1.234    39.191     0.150
     1.234    43.992     0.150
     1.539    27.492     0.150
     1.539    48.293     0.150
     1.539    50.793     0.150
     1.767    31.895     0.150
     1.767    55.293     0.150
     1.967    34.691     0.150
     1.967    35.691     0.150
     1.967    61.793     0.150
     2.482    41.492     0.150
     2.482    43.992     0.150
     2.482    75.895     0.150
     2.482    78.395     0.150
     2.555    43.094     0.150
     2.555    46.691     0.150
     2.555    80.492     0.150
     3.305    52.793     0.150
     3.305    58.691     0.150
     3.305   102.094     0.150
     3.471    54.793     0.150
     3.471    62.691     0.150
     3.471   105.793     0.150
     3.469    54.691     0.150
     3.469    62.691     0.150
     3.469   108.395     0.150
     3.821    59.992     0.150
     3.821    68.492     0.150
     3.821   119.594     0.150
     4.051   109.492     0.150
     4.051   126.594     0.150
     4.108    65.293     0.150
     4.108    73.395     0.150
     4.108   126.992     0.150
     4.339   134.594     0.150
     4.384    68.793     0.150
     4.384    77.895     0.150
     4.384   135.793     0.150
     4.749   148.094     0.150
     5.519   170.691     0.150
     5.591   175.191     0.150
     6.056   109.094     0.150
     6.056   188.395     0.150
     6.136   190.094     0.150
     6.424   199.594     0.150
     6.433    95.492     0.150
     6.433   116.191     0.150
     6.433   199.992     0.150
     7.047   219.594     0.150
     7.490   230.992     0.150
     7.941   236.191     0.150
     7.941   246.691     0.150
     8.543   266.492     0.150
     8.812   270.895     0.150
     8.971   129.691     0.150
     8.971   148.191     0.150
     8.971   277.594     0.150
    11.050   342.293     0.150
    12.448   386.395     0.150
     0.245     4.391     0.150
     0.245     8.191     0.150
     0.245     8.391     0.150
     0.608    11.191     0.150
     0.608    19.590     0.150
     0.608    11.293     0.150
     0.608    19.891     0.150
     1.051    19.590     0.150
     1.051    34.590     0.150
     1.269    23.191     0.150
     1.269    45.691     0.150
     1.269    40.293     0.150
     1.575    28.391     0.150
     1.575    49.891     0.150
     1.575    28.492     0.150
     1.575    49.992     0.150
     1.763    31.492     0.150
     1.763    31.793     0.150
     1.998    35.590     0.150
     1.998    35.992     0.150
     1.998    62.590     0.150
     1.998    37.293     0.150
     1.998    61.891     0.150
     2.521    42.590     0.150
     2.521    46.891     0.150
     2.521    79.691     0.150
     2.521    42.891     0.150
     2.521    46.492     0.150
     2.521    79.391     0.150
     2.517    42.992     0.150
     2.517    45.891     0.150
     2.517    73.793     0.150
     2.517    78.590     0.150
     2.517    42.492     0.150
     2.517    46.891     0.150
     2.517    73.492     0.150
     2.517    78.891     0.150
     3.332    53.590     0.150
     3.332    60.293     0.150
     3.332    91.590     0.150
     3.332   103.891     0.150
     3.332    53.191     0.150
     3.332    59.691     0.150
     3.332   103.590     0.150
     3.434    55.590     0.150
     3.434    62.691     0.150
     3.434    95.090     0.150
     3.434   107.293     0.150
     3.475    54.891     0.150
     3.475    63.590     0.150
     3.475   106.293     0.150
     3.790    59.793     0.150
     3.790    70.090     0.150
     3.790   103.191     0.150
     3.790   119.590     0.150
     3.790    59.691     0.150
     3.790    69.090     0.150
     3.790   118.293     0.150
     4.056    73.992     0.150
     4.056   127.391     0.150
     4.137    74.691     0.150
     4.137   128.891     0.150
     4.303    67.191     0.150
     4.303    77.293     0.150
     4.303   134.492     0.150
     4.416    69.590     0.150
     4.416    79.492     0.150
     4.416   117.793     0.150
     4.416   137.391     0.150
     4.416   136.391     0.150
     4.778    85.793     0.150
     4.778   148.793     0.150
     5.551    84.492     0.150
     5.551   145.891     0.150
     5.551   171.293     0.150
     5.618   148.492     0.150
     5.618   175.492     0.150
     5.851   182.391     0.150
     6.082    91.293     0.150
     6.082   159.090     0.150
     6.082   188.992     0.150
     6.084    93.191     0.150
     6.084   160.191     0.150
     6.084   179.590     0.150
     6.084   189.492     0.150
     6.100   100.191     0.150
     6.100   110.293     0.150
     6.100   189.793     0.150
     6.442    96.191     0.150
     6.442   166.891     0.150
     6.442   200.691     0.150
     6.442    95.391     0.150
     6.442   167.090     0.150
     6.455   199.992     0.150
     6.839   211.891     0.150
     6.867   211.891     0.150
     7.079   217.891     0.150
     7.522   232.492     0.150
     7.522   230.461     0.150
     7.650   236.793     0.150
     8.574   161.090     0.150
     8.845   130.793     0.150
     8.845   272.992     0.150
     9.006   131.590     0.150
     9.006   277.891     0.150
     9.251   289.090     0.150
     9.472   139.168     0.150
     9.472   297.891     0.150
    10.042   306.797     0.150
    10.042   146.793     0.150
    11.085   160.590     0.150
    11.085   199.691     0.150
    11.085   341.590     0.150
    12.484   385.793     0.150
    12.750   182.066     0.150
    12.750   398.918     0.150
    16.495   520.367     0.150
    16.808   238.367     0.150
    16.871   409.949     0.150
    16.871   236.090     0.150
    20.402   279.602     0.150
    21.590   292.590     0.150
    21.653   293.391     0.150
    21.653   292.418     0.150
    21.653   292.793     0.150
    21.684   292.559     0.150
    25.156   327.855     0.150
    25.201   328.090     0.150
    26.413   338.992     0.150
    26.413     2.199     0.150
    26.413   546.191     0.150
    28.581   359.891     0.150
    30.093   371.492     0.150
    42.618   477.840     0.150
    44.777   495.691     0.150
    45.371   500.293     0.150
    45.371     2.898     0.150
    45.408   501.441     0.150
    45.408   500.391     0.150
    48.481   524.496     0.150
    55.877   577.766     0.150
    71.123   681.215     0.150
    77.641   716.953     0.150
    81.195   736.352     0.150
    91.154   785.652     0.150
     0.266     4.777     0.150
     0.266     8.777     0.150
     0.266     8.078     0.150
     0.618    11.375     0.150
     0.618    19.977     0.150
     0.618    11.477     0.150
     1.030    19.176     0.150
     1.030    33.676     0.150
     1.030    19.277     0.150
     1.030    33.477     0.150
     1.291    24.078     0.150
     1.291    23.977     0.150
     1.597    28.676     0.150
     1.597    29.375     0.150
     1.597    50.977     0.150
     2.018    36.578     0.150
     2.018    63.875     0.150
     2.018    61.277     0.150
     2.018    63.176     0.150
     1.761    31.375     0.150
     1.761    54.875     0.150
     2.540    43.176     0.150
     2.540    78.676     0.150
     2.540    42.777     0.150
     2.540    46.078     0.150
     2.540    73.977     0.150
     2.540    79.578     0.150
     2.499    42.477     0.150
     2.499    43.676     0.150
     2.499    46.277     0.150
     2.499    79.477     0.150
     2.499    42.578     0.150
     2.499    78.277     0.150
     3.350    53.477     0.150
     3.350    61.078     0.150
     3.350   104.676     0.150
     3.350    61.477     0.150
     3.412    55.578     0.150
     3.412    62.977     0.150
     3.412   106.477     0.150
     3.477    55.777     0.150
     3.477    62.578     0.150
     3.477    96.277     0.150
     3.477   106.375     0.150
     3.770    59.578     0.150
     3.770    68.477     0.150
     3.770   102.777     0.150
     3.770   117.777     0.150
     3.770   103.477     0.150
     3.770   117.277     0.150
     4.155    75.477     0.150
     4.155   129.277     0.150
     4.436    67.578     0.150
     4.436    79.277     0.150
     4.436   137.477     0.150
     4.436    69.375     0.150
     4.436   137.375     0.150
     4.281    65.875     0.150
     4.281    77.277     0.150
     4.281   133.676     0.150
     4.796   148.777     0.150
     5.342    96.676     0.150
     5.342   165.375     0.150
     5.571   172.578     0.150
     5.635   176.078     0.150
     5.870   108.078     0.150
     5.870   181.977     0.150
     5.915   183.277     0.150
     5.957   186.078     0.150
     6.101   100.578     0.150
     6.101   111.078     0.150
     6.101   189.875     0.150
     6.078   189.176     0.150
     6.448    94.875     0.150
     6.448   118.078     0.150
     6.448   200.777     0.150
     6.448    95.078     0.150
     6.448   198.777     0.150
     6.475   202.078     0.150
     6.859   213.777     0.150
     6.887   214.477     0.150
     6.887   126.875     0.150
     7.099   212.777     0.150
     7.099   219.176     0.150
     7.542   195.078     0.150
     7.542   233.176     0.150
     7.641   235.875     0.150
     7.995   143.777     0.150
     7.995   246.176     0.150
     7.972   201.777     0.150
     8.593   265.777     0.150
     8.593   155.777     0.150
     8.867   228.875     0.150
     8.867   274.875     0.150
     9.028   130.977     0.150
     9.028   163.777     0.150
     9.028   281.277     0.150
     9.028   131.176     0.150
    11.107   345.176     0.150
    17.787   245.328     0.150
    21.675   292.227     0.150
    42.632   477.742     0.150
    44.762   496.395     0.150
     0.230     4.528     0.150
     0.230     8.028     0.150
     0.603    11.028     0.150
     0.603    19.429     0.150
     1.253    22.829     0.150
     1.559    28.028     0.150
     1.559    30.429     0.150
     1.559    49.729     0.150
     1.559    51.429     0.150
     1.763    31.829     0.150
     1.763    55.929     0.150
     1.985    35.429     0.150
     1.985    36.629     0.150
     1.985    62.829     0.150
     1.985    36.829     0.150
     1.985    61.429     0.150
     2.502    42.429     0.150
     2.502    45.329     0.150
     2.502    76.028     0.150
     2.502    78.729     0.150
     2.502    43.028     0.150
     2.502    46.729     0.150
     2.502    78.429     0.150
     2.536    43.129     0.150
     2.536    47.129     0.150
     2.536    80.329     0.150
     2.536    42.729     0.150
     2.536    80.129     0.150
     3.472    54.929     0.150
     3.472    62.429     0.150
     3.472   106.729     0.150
     3.321    60.429     0.150
     3.321   103.528     0.150
     3.321    53.429     0.150
     3.321    60.229     0.150
     3.321   103.229     0.150
     3.449    55.829     0.150
     3.449   107.329     0.150
     3.804   119.629     0.150
     3.804   119.429     0.150
     4.125    74.929     0.150
     4.125   128.429     0.150
     4.402    69.129     0.150
     4.402    79.829     0.150
     4.402   135.929     0.150
     4.402    69.329     0.150
     4.402   134.929     0.150
     4.319   133.729     0.150
     4.766   148.629     0.150
     5.311   165.929     0.150
     5.538    85.329     0.150
     5.538   170.729     0.150
     5.607   174.729     0.150
     5.884   182.929     0.150
     5.925   183.629     0.150
     5.925   186.329     0.150
     6.072   188.429     0.150
     6.097    91.429     0.150
     6.442   191.729     0.150
     6.442   199.929     0.150
     6.826   211.729     0.150
     7.508   227.211     0.150
     7.508   231.429     0.150
     7.960   244.829     0.150
     8.561   264.929     0.150
     8.831   229.829     0.150
     8.831   273.329     0.150
     8.991   131.829     0.150
     8.991   279.229     0.150
     9.243   287.729     0.150
     9.463   297.549     0.150
    10.054   308.429     0.150
    12.468   384.429     0.150
    16.792   238.754     0.150
    16.876   409.338     0.150
    17.769   245.754     0.150
    17.769   550.704     0.150
    21.574   292.528     0.150
    21.669   292.554     0.150
    21.669   681.954     0.150
    21.638   292.305     0.150
    25.141   326.242     0.150
    42.607   476.396     0.150
    44.787   496.028     0.150
    48.471   522.830     0.150
    71.112   680.229     0.150
     0.105     2.250     0.150
     0.105     4.352     0.150
     0.583    10.648     0.150
     0.583    18.852     0.150
     1.123    20.453     0.150
     1.123    35.750     0.150
     1.182    21.852     0.150
     1.182    24.750     0.150
     1.182    38.047     0.150
     1.182    42.148     0.150
     1.430    45.352     0.150
     1.430    48.047     0.150
     1.762    31.547     0.150
     1.762    31.852     0.150
     1.762    54.453     0.150
     1.886    33.750     0.150
     1.886    34.648     0.150
     1.886    59.250     0.150
     1.886    60.250     0.150
     2.373    39.648     0.150
     2.373    42.453     0.150
     2.373    74.352     0.150
     3.235    51.953     0.150
     3.235    57.852     0.150
     3.235   100.453     0.150
     3.440    54.148     0.150
     3.440    61.953     0.150
     3.440    94.148     0.150
     3.440   105.148     0.150
     3.571    57.453     0.150
     3.571    64.750     0.150
     3.571    97.648     0.150
     3.571    99.750     0.150
     3.571   112.453     0.150
     3.927    61.352     0.150
     3.927    71.148     0.150
     3.927   122.547     0.150
     4.032   125.953     0.150
     4.057   126.453     0.150
     4.295    67.453     0.150
     4.295    76.547     0.150
     4.295   133.047     0.150
     4.446    69.047     0.150
     4.446    79.750     0.150
     4.446   137.750     0.150
     4.674   145.547     0.150
     5.434    82.953     0.150
     5.434    97.648     0.150
     5.434   143.750     0.150
     5.434   167.953     0.150
     5.828   180.250     0.150
     5.985   108.047     0.150
     5.985   186.648     0.150
     6.242    93.250     0.150
     6.242   184.852     0.150
     6.242   194.250     0.150
     6.340   197.648     0.150
     6.427    94.250     0.150
     6.427   117.047     0.150
     6.427   201.250     0.150
     6.723   110.547     0.150
     6.723   120.453     0.150
     6.723   208.547     0.150
     6.961   215.547     0.150
     7.401   228.352     0.150
     7.847   201.352     0.150
     7.847   242.750     0.150
     8.462   262.953     0.150
     8.716   226.047     0.150
     8.716   269.250     0.150
     8.869   129.953     0.150
     8.869   159.750     0.150
     8.869   226.352     0.150
     8.869   275.648     0.150
    10.944   339.953     0.150
     0.222     4.461     0.150
     0.222     7.961     0.150
     0.222     8.363     0.150
     0.587    10.863     0.150
     0.587    18.961     0.150
     0.587    10.762     0.150
     1.081    19.961     0.150
     1.081    34.363     0.150
     1.081    34.562     0.150
     1.243    22.562     0.150
     1.243    39.762     0.150
     1.243    22.863     0.150
     1.243    39.863     0.150
     1.546    27.863     0.150
     1.546    49.062     0.150
     1.776    54.660     0.150
     1.969    34.762     0.150
     1.969    35.363     0.150
     1.969    61.863     0.150
     1.969    61.363     0.150
     2.489    42.160     0.150
     2.489    43.863     0.150
     2.489    77.363     0.150
     2.489    42.461     0.150
     2.489    46.062     0.150
     2.489    73.262     0.150
     2.489    78.160     0.150
     2.551    42.762     0.150
     2.551    46.660     0.150
     2.551    80.562     0.150
     2.551    42.461     0.150
     2.551    80.062     0.150
     3.304    52.562     0.150
     3.304    58.961     0.150
     3.304   100.160     0.150
     3.304   102.961     0.150
     3.304    52.863     0.150
     3.304    57.762     0.150
     3.304   102.762     0.150
     3.463    55.562     0.150
     3.463    62.863     0.150
     3.463   107.660     0.150
     3.810    59.660     0.150
     3.810    69.062     0.150
     3.810   103.660     0.150
     3.810   119.461     0.150
     3.810    59.863     0.150
     3.810   103.863     0.150
     3.810   119.262     0.150
     4.042    72.961     0.150
     4.042   121.863     0.150
     4.042   125.762     0.150
     4.042    62.160     0.150
     4.042    73.562     0.150
     4.042   110.461     0.150
     4.042   124.762     0.150
     4.386    68.863     0.150
     4.386    78.660     0.150
     4.386   135.961     0.150
     4.386    66.461     0.150
     4.386    78.160     0.150
     4.386   134.863     0.150
     4.332    66.961     0.150
     4.332    77.762     0.150
     4.332   134.363     0.150
     4.749   147.762     0.150
     5.521    83.262     0.150
     5.521   165.762     0.150
     5.521   171.062     0.150
     5.822   181.062     0.150
     5.867   183.762     0.150
     5.909   184.062     0.150
     6.055    90.562     0.150
     6.055    91.262     0.150
     6.055   188.062     0.150
     6.110   188.961     0.150
     6.130   181.262     0.150
     6.130   190.961     0.150
     6.426   200.062     0.150
     6.425    94.363     0.150
     6.425   199.363     0.150
     6.425   165.562     0.150
     6.425   198.961     0.150
     6.809   211.562     0.150
     6.837   211.461     0.150
     6.837   210.762     0.150
     7.049   208.762     0.150
     7.049   219.262     0.150
     7.492   229.359     0.150
     7.492   135.062     0.150
     7.492   231.363     0.150
     7.492   108.660     0.150
     7.653   109.461     0.150
     7.944   245.363     0.150
     8.544   126.961     0.150
     8.544   265.461     0.150
     8.544   153.363     0.150
     8.815   129.062     0.150
     8.815   273.461     0.150
     8.976   130.961     0.150
     8.976   229.262     0.150
     8.976   277.461     0.150
     8.976   131.461     0.150
     8.976   229.461     0.150
     9.226   132.363     0.150
     9.446   296.902     0.150
    10.071   142.660     0.150
    11.056   340.863     0.150
    12.769   183.461     0.150
    12.769   179.562     0.150
    16.891   235.461     0.150
    17.146   240.660     0.150
    17.774   247.562     0.150
    21.563   288.363     0.150
    21.624   292.500     0.150
    21.657   292.660     0.150
    25.132   325.816     0.150
    47.801   516.262     0.150
     0.516    10.144     0.150
     0.516    17.043     0.150
     0.830    15.243     0.150
     0.830    26.343     0.150
     0.796    15.043     0.150
     0.796    26.144     0.150
     1.455    26.343     0.150
     1.455    46.343     0.150
     1.770    31.144     0.150
     1.770    55.843     0.150
     1.760    30.644     0.150
     1.760    31.743     0.150
     1.760    55.644     0.150
     1.916    33.243     0.150
     1.916    57.543     0.150
     2.850    45.644     0.150
     2.850    50.043     0.150
     2.850    88.644     0.150
     3.232    51.243     0.150
     3.232    58.144     0.150
     3.232   101.043     0.150
     3.392    51.543     0.150
     3.392    59.843     0.150
     3.392    91.343     0.150
     3.392   103.243     0.150
     3.602    63.644     0.150
     3.602   111.144     0.150
     3.791    59.443     0.150
     3.791    68.443     0.150
     3.791   118.644     0.150
     4.080   128.543     0.150
     4.157    64.843     0.150
     4.157    74.743     0.150
     4.157   128.843     0.150
     4.246    76.043     0.150
     4.246   131.243     0.150
     4.492    67.843     0.150
     4.492    80.443     0.150
     4.492   139.743     0.150
     4.761   148.943     0.150
     4.943    74.543     0.150
     4.943   152.743     0.150
     5.044    76.144     0.150
     5.044    90.243     0.150
     5.044   156.043     0.150
     5.126    91.343     0.150
     5.126   158.743     0.150
     5.304   165.743     0.150
     5.345   166.644     0.150
     5.367   168.144     0.150
     5.570   100.144     0.150
     5.570   172.743     0.150
     5.858   182.743     0.150
     6.228   192.144     0.150
     6.233   101.943     0.150
     6.233   112.343     0.150
     6.233   193.443     0.150
     6.368   115.543     0.150
     6.368   198.843     0.150
     6.464   201.043     0.150
     6.894   102.443     0.150
     6.894   211.644     0.150
     7.311   226.644     0.150
     7.990   235.644     0.150
     7.990   248.043     0.150
     8.169   207.743     0.150
     8.169   253.543     0.150
     8.292   119.843     0.150
     8.292   255.943     0.150
    10.351   320.843     0.150
    10.558   327.144     0.150
    11.740   362.243     0.150
     0.222     4.527     0.150
     0.222     8.027     0.150
     0.222     7.828     0.150
     0.576    11.129     0.150
     0.576    19.027     0.150
     1.089    20.629     0.150
     1.089    35.828     0.150
     1.089    35.430     0.150
     1.541    27.930     0.150
     1.541    48.328     0.150
     1.541    50.828     0.150
     1.541    27.828     0.150
     1.786    32.230     0.150
     1.786    55.328     0.150
     1.786    32.027     0.150
     1.960    35.430     0.150
     1.960    61.930     0.150
     1.960    35.129     0.150
     1.960    61.730     0.150
     2.484    44.629     0.150
     2.484    74.430     0.150
     2.484    78.129     0.150
     2.484    42.828     0.150
     2.484    45.230     0.150
     2.484    71.629     0.150
     2.559    43.328     0.150
     2.559    47.527     0.150
     2.559    81.629     0.150
     2.559    43.129     0.150
     2.559    47.328     0.150
     2.559    80.430     0.150
     3.294    52.828     0.150
     3.294    59.027     0.150
     3.294    90.430     0.150
     3.294   102.430     0.150
     3.294    53.328     0.150
     3.294    58.828     0.150
     3.470    56.027     0.150
     3.470    63.430     0.150
     3.470    95.730     0.150
     3.470   108.527     0.150
     3.491    55.129     0.150
     3.491    62.930     0.150
     3.491    96.828     0.150
     3.491   106.629     0.150
     3.810    60.129     0.150
     3.810    69.129     0.150
     3.810   104.430     0.150
     3.810   119.328     0.150
     3.810    60.230     0.150
     3.810    69.430     0.150
     3.810   104.629     0.150
     3.810   118.527     0.150
     4.031    61.629     0.150
     4.031    72.027     0.150
     4.031   121.230     0.150
     4.031   126.527     0.150
     4.031    62.527     0.150
     4.031    72.930     0.150
     4.031   109.230     0.150
     4.031   124.129     0.150
     4.098    72.230     0.150
     4.098   128.730     0.150
     4.377    69.129     0.150
     4.377   136.930     0.150
     4.377    69.328     0.150
     4.377    78.730     0.150
     4.377   136.730     0.150
     4.338    67.430     0.150
     4.338    78.328     0.150
     4.338   135.230     0.150
     4.739    73.527     0.150
     4.739    84.730     0.150
     4.739   148.027     0.150
     5.284    81.027     0.150
     5.284   164.730     0.150
     5.512    98.027     0.150
     5.512   170.027     0.150
     5.512    97.527     0.150
     5.512   143.527     0.150
     5.512   170.129     0.150
     5.580   173.828     0.150
     5.813   180.129     0.150
     5.858    89.328     0.150
     5.858   182.027     0.150
     5.899   176.930     0.150
     5.899   183.629     0.150
     6.115   189.430     0.150
     6.416   199.328     0.150
     6.414    95.230     0.150
     6.414   167.527     0.150
     6.414   200.230     0.150
     6.800   100.430     0.150
     6.800   210.027     0.150
     6.828   212.328     0.150
     6.828   101.730     0.150
     7.040   104.129     0.150
     7.040   217.828     0.150
     7.483   109.527     0.150
     7.483   192.527     0.150
     7.483   230.527     0.150
     7.483   109.230     0.150
     7.483   108.410     0.150
     7.646   109.828     0.150
     7.936   116.629     0.150
     7.936   129.930     0.150
     7.936   246.828     0.150
     8.020   116.730     0.150
     8.535   266.129     0.150
     8.807   129.828     0.150
     8.807   273.730     0.150
     8.969   132.027     0.150
     8.969   279.230     0.150
     8.969   230.930     0.150
     9.215   287.629     0.150
     9.215   132.930     0.150
     9.215   133.301     0.150
    10.081   254.172     0.150
    10.081   255.129     0.150
    11.050   159.629     0.150
    11.050   341.930     0.150
    11.211   162.027     0.150
    11.211   348.230     0.150
    12.769   181.730     0.150
    12.769   399.027     0.150
    12.769   183.230     0.150
    14.386   205.730     0.150
    15.280   215.527     0.150
    16.506   516.480     0.150
    16.779   234.109     0.150
    16.779   235.281     0.150
    16.779   524.504     0.150
    16.779   236.230     0.150
    20.440   279.730     0.150
    20.698   283.027     0.150
    20.698   282.730     0.150
    20.842   285.113     0.150
    20.842   658.605     0.150
    21.559   289.430     0.150
    21.559   289.668     0.150
    21.618   292.328     0.150
    21.618   292.129     0.150
    21.618   684.152     0.150
    21.618   291.820     0.150
    21.653   292.480     0.150
    24.858   326.328     0.150
    24.858   590.141     0.150
    25.130   325.492     0.150
    25.175   325.730     0.150
    25.175   325.988     0.150
    25.246   329.457     0.150
    25.222   326.430     0.150
    25.222   327.754     0.150
    25.222   327.250     0.150
    25.487   330.660     0.150
    25.701   334.590     0.150
    25.731   334.789     0.150
    26.124   337.859     0.150
    26.123   606.527     0.150
    26.356   340.379     0.150
    26.705   342.770     0.150
    26.795   344.578     0.150
    27.249   347.590     0.150
    27.934   353.680     0.150
    28.545   359.000     0.150
    28.545   356.969     0.150
    30.447   374.930     0.150
    30.447   373.410     0.150
    31.342   383.719     0.150
    32.704   393.051     0.150
    34.225   407.828     0.150
    37.077   430.730     0.150
    37.077   776.828     0.150
    40.616   460.367     0.150
    42.612   476.578     0.150
    42.612   476.930     0.150
    44.442   493.168     0.150
    44.814   494.488     0.150
    44.814   495.930     0.150
    44.814   495.027     0.150
    45.348   500.930     0.150
    46.485   507.969     0.150
    47.255   515.270     0.150
    47.803   517.105     0.150
    48.479   523.527     0.150
    48.479   523.656     0.150
    49.064   530.340     0.150
    49.245   531.438     0.150
    51.003   545.340     0.150
    53.987   564.328     0.150
    53.991   565.828     0.150
    56.094   580.629     0.150
    56.254   581.633     0.150
    71.115   679.277     0.150
    71.116   679.730     0.150
    71.116   679.840     0.150
    74.925   700.879     0.150
    75.976   709.602     0.150
    77.630   716.910     0.150
    77.630   717.230     0.150
    81.183   737.898     0.150
    81.183   737.738     0.150
    89.135   777.227     0.150
    89.135   776.840     0.150
    91.135   786.688     0.150
     0.159     3.680     0.150
     0.159     6.180     0.150
     0.753    14.879     0.150
     0.753    25.379     0.150
     0.753    25.277     0.150
     1.410    46.480     0.150
     1.577    28.480     0.150
     1.577    49.277     0.150
     1.617    29.180     0.150
     1.617    50.980     0.150
     1.617    29.777     0.150
     1.617    51.680     0.150
     1.530    28.180     0.150
     1.530    48.078     0.150
     2.469    41.480     0.150
     2.469    43.980     0.150
     2.469    75.879     0.150
     2.445    39.777     0.150
     2.445    43.379     0.150
     2.445    69.379     0.150
     2.445    74.879     0.150
     2.445    43.277     0.150
     2.445    74.980     0.150
     2.826    50.180     0.150
     2.826    87.379     0.150
     2.826    45.980     0.150
     2.826    49.578     0.150
     2.826    88.777     0.150
     2.910    46.578     0.150
     2.910    53.078     0.150
     2.910    91.078     0.150
     3.372   103.980     0.150
     3.372    52.578     0.150
     3.372    60.879     0.150
     3.372    92.480     0.150
     3.372   103.277     0.150
     3.659   113.680     0.150
     3.661    57.277     0.150
     3.661    67.180     0.150
     3.661    99.680     0.150
     3.661   116.078     0.150
     3.661    57.379     0.150
     4.032    63.578     0.150
     4.032    72.680     0.150
     4.032   106.777     0.150
     4.032   125.578     0.150
     4.032    63.680     0.150
     4.032   126.379     0.150
     4.128    73.578     0.150
     4.128   108.879     0.150
     4.128   126.277     0.150
     4.288    77.480     0.150
     4.288   133.879     0.150
     4.556    69.777     0.150
     4.556   123.879     0.150
     4.556   142.379     0.150
     5.088   158.680     0.150
     5.132    77.078     0.150
     5.132    91.078     0.150
     5.132   136.980     0.150
     5.132   157.680     0.150
     5.132    77.480     0.150
     5.132   133.879     0.150
     5.132   157.578     0.150
     5.365    80.680     0.150
     5.365   167.078     0.150
     5.567    83.480     0.150
     5.567   164.277     0.150
     5.567   173.777     0.150
     5.757    85.379     0.150
     5.757   178.680     0.150
     5.757    85.480     0.150
     5.757   179.180     0.150
     6.017   186.480     0.150
     6.656   169.480     0.150
     6.656   203.980     0.150
     7.115   219.680     0.150
     7.113   223.180     0.150
     7.615   233.980     0.150
     7.972   116.777     0.150
     7.972   204.180     0.150
     8.506   262.078     0.150
     8.625   268.379     0.150
     8.625   124.777     0.150
     8.746   126.180     0.150
     8.746   158.379     0.150
     8.746   271.980     0.150
     8.746   127.578     0.150
     8.746   224.578     0.150
     8.858   129.898     0.150
     8.858   278.293     0.150
    16.795   237.312     0.150
    16.978   235.379     0.150
    18.319   254.273     0.150
    18.319   251.180     0.150
    21.438   286.777     0.150
    21.438   288.598     0.150
    21.522   288.277     0.150
    48.101   519.680     0.150
     0.119     3.498     0.150
     0.119     6.498     0.150
     0.119     6.297     0.150
     0.516     9.697     0.150
     0.516    17.197     0.150
     0.516    17.396     0.150
     1.074    33.098     0.150
     1.259    22.697     0.150
     1.259    39.697     0.150
     1.259    40.197     0.150
     1.369    24.297     0.150
     1.369    41.998     0.150
     1.369    44.998     0.150
     1.802    31.396     0.150
     1.802    32.197     0.150
     1.802    56.396     0.150
     1.802    31.498     0.150
     1.802    32.396     0.150
     1.802    55.697     0.150
     1.802    56.797     0.150
     1.832    31.697     0.150
     1.832    55.498     0.150
     1.832    31.098     0.150
     2.312    38.598     0.150
     2.312    40.697     0.150
     2.312    65.396     0.150
     2.312    68.297     0.150
     2.312    72.297     0.150
     2.312    41.297     0.150
     2.312    68.098     0.150
     2.730    43.697     0.150
     2.730    49.598     0.150
     2.730    84.697     0.150
     3.150    97.197     0.150
     3.150    49.498     0.150
     3.150    57.297     0.150
     3.494    53.297     0.150
     3.494    61.797     0.150
     3.494    93.896     0.150
     3.494   106.396     0.150
     3.947    61.297     0.150
     3.947    71.498     0.150
     3.947   105.896     0.150
     3.947   123.797     0.150
     3.955    60.498     0.150
     3.955    70.598     0.150
     3.955   105.197     0.150
     3.955   122.896     0.150
     3.955   106.797     0.150
     3.991    61.396     0.150
     3.991    71.797     0.150
     3.991   123.797     0.150
     3.991    60.197     0.150
     3.991    70.498     0.150
     3.991   107.297     0.150
     3.991   123.396     0.150
     4.214    65.197     0.150
     4.214    75.297     0.150
     4.214   114.197     0.150
     4.214   129.697     0.150
     4.214   129.896     0.150
     4.512    68.396     0.150
     4.512    80.697     0.150
     4.512   119.797     0.150
     4.512   138.998     0.150
     4.590   120.396     0.150
     4.590   142.098     0.150
     5.352    80.197     0.150
     5.352   139.498     0.150
     5.352   160.396     0.150
     5.352   164.797     0.150
     5.352    79.896     0.150
     5.352   163.697     0.150
     5.438    81.896     0.150
     5.438   168.797     0.150
     5.662    84.197     0.150
     5.662   176.098     0.150
     5.900    88.098     0.150
     5.900   183.697     0.150
     6.258    93.396     0.150
     6.258   158.998     0.150
     6.258   194.498     0.150
     6.288   195.197     0.150
     6.310   185.697     0.150
     6.310   195.797     0.150
     6.879   176.098     0.150
     6.879   212.197     0.150
     7.320   224.066     0.150
     7.320   105.896     0.150
     7.320   186.098     0.150
     7.320   225.197     0.150
     7.320   224.998     0.150
     7.703   110.797     0.150
     8.638   125.396     0.150
     8.638   155.098     0.150
     8.638   216.598     0.150
     8.638   266.797     0.150
     8.796   127.297     0.150
     8.796   221.697     0.150
     8.796   271.998     0.150
     8.796   128.297     0.150
     8.796   222.297     0.150
     9.316   133.943     0.150
     9.316   294.143     0.150
    11.040   157.697     0.150
    11.040   341.598     0.150
    12.276   176.697     0.150
    12.276   306.797     0.150
    12.276   379.998     0.150
    12.910   184.172     0.150
    12.910   405.348     0.150
    16.983   235.697     0.150
    17.722   245.098     0.150
    19.940   269.197     0.150
    21.389   288.797     0.150
    21.444   288.672     0.150
    21.483   288.748     0.150
    39.093   445.896     0.150
    44.944   494.396     0.150
     0.269     5.977     0.150
     0.269    10.277     0.150
     0.269     9.875     0.150
     0.986    18.375     0.150
     0.986    32.277     0.150
     0.986    18.477     0.150
     0.986    32.074     0.150
     0.768    14.777     0.150
     0.768    25.176     0.150
     0.768    26.176     0.150
     1.598    27.977     0.150
     1.598    48.574     0.150
     1.605    28.574     0.150
     1.605    49.375     0.150
     1.605    49.676     0.150
     2.104    35.477     0.150
     2.104    37.277     0.150
     2.104    62.074     0.150
     2.104    65.277     0.150
     2.104    37.074     0.150
     2.104    65.676     0.150
     2.459    40.277     0.150
     2.459    44.676     0.150
     2.459    76.875     0.150
     2.459    40.176     0.150
     2.459    76.375     0.150
     2.544    41.477     0.150
     2.544    44.977     0.150
     2.544    70.875     0.150
     2.544    78.977     0.150
     3.315    50.977     0.150
     3.315    58.375     0.150
     3.315    88.074     0.150
     3.315   102.074     0.150
     3.455    53.574     0.150
     3.455    62.277     0.150
     3.455    92.875     0.150
     3.455   107.176     0.150
     3.455   107.574     0.150
     3.851    58.875     0.150
     3.851    68.777     0.150
     3.851   102.074     0.150
     3.851   120.277     0.150
     3.851    58.977     0.150
     4.269    64.676     0.150
     4.269    76.574     0.150
     4.269   112.977     0.150
     4.269   132.574     0.150
     4.221   132.074     0.150
     4.221    63.676     0.150
     4.221    75.777     0.150
     4.221   114.277     0.150
     4.221   130.977     0.150
     4.251   132.477     0.150
     4.509    69.176     0.150
     4.509   119.977     0.150
     4.509   139.977     0.150
     4.509    69.074     0.150
     4.894   150.977     0.150
     5.650    83.375     0.150
     5.650   145.375     0.150
     5.650   173.777     0.150
     5.743    84.875     0.150
     5.743   177.977     0.150
     6.061    90.277     0.150
     6.061   109.676     0.150
     6.061   156.074     0.150
     6.061   188.277     0.150
     6.059   187.875     0.150
     6.205    92.176     0.150
     6.205   193.777     0.150
     6.939   101.074     0.150
     6.939   177.574     0.150
     7.176   105.277     0.150
     7.176   214.676     0.150
     7.615   234.770     0.150
     7.615   110.574     0.150
     7.615   235.676     0.150
     7.615   109.074     0.150
     8.021   144.375     0.150
     8.056   204.574     0.150
     8.680   157.477     0.150
     8.680   269.875     0.150
     8.922   129.875     0.150
     8.922   144.777     0.150
     8.922   275.777     0.150
     9.063   132.074     0.150
     9.063   280.176     0.150
     9.397   134.977     0.150
     9.925   302.125     0.150
     9.615   138.297     0.150
     9.615   174.477     0.150
     9.615   302.402     0.150
    11.127   342.574     0.150
    11.319   349.574     0.150
    12.814   180.227     0.150
    12.814   402.199     0.150
    16.592   523.988     0.150
    21.597   290.676     0.150
    21.691   290.676     0.150
    21.695   289.801     0.150
    25.175   321.676     0.150
    30.033   365.977     0.150
    81.349   734.832     0.150
     0.220     4.453     0.150
     0.220     7.750     0.150
     0.220     4.555     0.150
     0.220     7.648     0.150
     0.573    11.055     0.150
     0.573    18.852     0.150
     1.093    20.555     0.150
     1.093    36.055     0.150
     1.093    20.453     0.150
     1.093    35.555     0.150
     1.538    27.852     0.150
     1.538    50.250     0.150
     1.788    32.148     0.150
     1.788    32.250     0.150
     1.956    35.453     0.150
     1.956    62.250     0.150
     1.956    62.352     0.150
     2.481    42.250     0.150
     2.481    43.852     0.150
     2.481    74.352     0.150
     2.481    77.555     0.150
     2.481    42.648     0.150
     2.481    46.250     0.150
     2.481    72.648     0.150
     2.562    43.453     0.150
     2.562    47.453     0.150
     2.562    81.453     0.150
     3.290    53.352     0.150
     3.290    60.148     0.150
     3.290    92.352     0.150
     3.290   102.750     0.150
     3.290    53.055     0.150
     3.290    58.648     0.150
     3.492    55.148     0.150
     3.492    62.555     0.150
     3.492   106.648     0.150
     3.812    60.148     0.150
     3.812    69.648     0.150
     3.812   118.953     0.150
     3.812    69.852     0.150
     3.812   105.352     0.150
     3.812   119.148     0.150
     4.029    62.750     0.150
     4.029    73.055     0.150
     4.029   107.953     0.150
     4.029   125.148     0.150
     4.029    61.250     0.150
     4.029    71.148     0.150
     4.029   108.953     0.150
     4.029   124.953     0.150
     4.094    74.750     0.150
     4.094   110.055     0.150
     4.094   128.055     0.150
     4.341    67.148     0.150
     4.341    77.750     0.150
     4.341   116.352     0.150
     4.341   136.148     0.150
     4.374    68.953     0.150
     4.374    78.555     0.150
     4.374   114.555     0.150
     4.374   135.953     0.150
     4.374    68.055     0.150
     4.374    79.555     0.150
     4.374   135.648     0.150
     4.736   147.852     0.150
     5.509    84.055     0.150
     5.509    98.055     0.150
     5.509   169.453     0.150
     5.509    97.852     0.150
     5.509   143.148     0.150
     5.509   167.852     0.150
     5.576   173.953     0.150
     5.809    88.750     0.150
     5.809   149.953     0.150
     5.809   179.953     0.150
     5.854    87.648     0.150
     5.854   183.148     0.150
     6.118   190.555     0.150
     6.139    92.352     0.150
     6.139   159.750     0.150
     6.139   191.648     0.150
     6.413   116.852     0.150
     6.413   200.352     0.150
     6.412    94.852     0.150
     6.412   199.352     0.150
     6.412   198.250     0.150
     6.797   102.555     0.150
     6.797   173.953     0.150
     6.797   210.852     0.150
     6.825   211.852     0.150
     7.036   104.555     0.150
     7.036   179.953     0.150
     7.036   218.148     0.150
     7.480   110.055     0.150
     7.480   231.352     0.150
     7.645   236.750     0.150
     7.932   244.352     0.150
     8.531   154.953     0.150
     8.531   217.648     0.150
     8.531   265.648     0.150
     8.804   128.250     0.150
     8.804   273.352     0.150
     8.966   131.352     0.150
     8.966   277.453     0.150
     8.966   131.750     0.150
     9.212   286.352     0.150
     9.212   133.953     0.150
    11.046   159.852     0.150
    11.046   339.648     0.150
    11.207   163.250     0.150
    11.207   346.352     0.150
    12.447   312.555     0.150
    12.447   383.250     0.150
    17.781   245.852     0.150
    21.556   291.852     0.150
    25.243   325.633     0.150
     0.227     4.813     0.150
     0.227     8.413     0.150
     0.756    14.513     0.150
     0.756    25.013     0.150
     1.030    19.013     0.150
     1.030    32.613     0.150
     1.030    36.113     0.150
     1.229    38.013     0.150
     1.561    48.813     0.150
     1.561    50.213     0.150
     1.599    27.913     0.150
     1.599    48.713     0.150
     2.068    35.313     0.150
     2.068    36.813     0.150
     2.068    65.113     0.150
     2.499    41.313     0.150
     2.499    45.413     0.150
     2.499    72.913     0.150
     2.499    78.413     0.150
     2.502    41.013     0.150
     2.502    45.113     0.150
     2.502    78.013     0.150
     3.424    52.413     0.150
     3.424    59.013     0.150
     3.424   105.713     0.150
     3.892    59.513     0.150
     3.892   121.213     0.150
     4.217    76.813     0.150
     4.217   131.713     0.150
     4.218   131.913     0.150
     4.315    77.213     0.150
     4.315   134.213     0.150
     4.470    68.513     0.150
     4.470    81.513     0.150
     4.470   139.713     0.150
     4.860   150.213     0.150
     5.612    83.313     0.150
     5.612   100.113     0.150
     5.612   174.213     0.150
     5.711   102.913     0.150
     5.711   177.513     0.150
     5.931   185.113     0.150
     5.975   186.013     0.150
     6.011   186.713     0.150
     6.106   179.813     0.150
     6.106   189.513     0.150
     6.104   190.013     0.150
     6.172   110.013     0.150
     6.172   191.313     0.150
     6.520   201.213     0.150
     6.598    95.613     0.150
     6.598   119.113     0.150
     6.598   171.913     0.150
     6.598   206.013     0.150
     6.901   214.313     0.150
     7.138   221.713     0.150
     7.577   223.113     0.150
     7.577   233.613     0.150
     8.015   248.213     0.150
     8.644   143.013     0.150
     8.644   269.513     0.150
     8.880   275.713     0.150
     9.020   161.913     0.150
     9.020   279.113     0.150
    11.083   341.613     0.150
    11.277   348.313     0.150
    12.469   310.213     0.150
    12.469   385.513     0.150
     0.212     4.242     0.150
     0.212     7.742     0.150
     0.565    10.641     0.150
     0.565    18.641     0.150
     1.105    20.438     0.150
     1.105    35.641     0.150
     1.226    22.438     0.150
     1.527    27.438     0.150
     1.527    48.438     0.150
     1.527    50.641     0.150
     1.794    32.141     0.150
     1.794    55.844     0.150
     1.794    57.844     0.150
     1.943    34.641     0.150
     1.943    61.742     0.150
     2.470    42.641     0.150
     2.470    44.438     0.150
     2.470    77.938     0.150
     2.575    43.039     0.150
     2.575    47.344     0.150
     2.575    81.141     0.150
     3.278    52.844     0.150
     3.278    58.539     0.150
     3.278   102.242     0.150
     3.495    62.438     0.150
     3.495    96.539     0.150
     3.495   106.641     0.150
     3.820    60.141     0.150
     3.820    70.344     0.150
     3.820   103.938     0.150
     3.820   120.141     0.150
     4.023    60.539     0.150
     4.023   125.039     0.150
     4.082    74.344     0.150
     4.082   127.438     0.150
     4.361    68.742     0.150
     4.361    78.539     0.150
     4.361   135.438     0.150
     4.354   136.742     0.150
     4.723   145.844     0.150
     4.723   148.344     0.150
     5.496    96.641     0.150
     5.496   168.844     0.150
     5.564    85.344     0.150
     5.564   173.641     0.150
     5.797   171.438     0.150
     5.797   180.742     0.150
     5.883   181.539     0.150
     6.030    90.141     0.150
     6.030   107.539     0.150
     6.030   187.742     0.150
     6.151   183.539     0.150
     6.151   191.844     0.150
     6.400   198.742     0.150
     6.405    94.242     0.150
     6.405   115.242     0.150
     6.405   199.242     0.150
     6.784   209.641     0.150
     6.812   211.641     0.150
     7.024   218.242     0.150
     7.467   230.438     0.150
     7.920   242.344     0.150
     7.920   246.844     0.150
     8.519   263.938     0.150
     8.791   270.742     0.150
     8.953   132.242     0.150
     8.953   229.938     0.150
     8.953   277.438     0.150
    11.034   341.539     0.150
    12.435   382.742     0.150
     0.458     8.676     0.150
     0.458    14.875     0.150
     0.614    11.676     0.150
     0.614    20.375     0.150
     0.688    13.375     0.150
     0.688    23.176     0.150
     1.148    21.078     0.150
     1.148    24.375     0.150
     1.148    36.977     0.150
     1.148    20.977     0.150
     1.148    37.078     0.150
     1.219    22.477     0.150
     1.219    39.176     0.150
     1.219    44.176     0.150
     1.343    25.578     0.150
     1.343    26.875     0.150
     1.343    44.277     0.150
     1.343    48.375     0.150
     1.343    44.578     0.150
     2.002    35.477     0.150
     2.002    36.375     0.150
     2.002    38.078     0.150
     2.002    62.777     0.150
     2.002    35.375     0.150
     2.585    43.777     0.150
     2.585    46.676     0.150
     2.585    80.277     0.150
     2.585    43.676     0.150
     2.585    46.477     0.150
     2.585    78.578     0.150
     2.723    45.477     0.150
     2.723    75.777     0.150
     2.744    45.078     0.150
     2.744    50.477     0.150
     2.744    79.578     0.150
     2.744    84.578     0.150
     2.744    49.777     0.150
     2.744    84.176     0.150
     2.907    49.176     0.150
     2.907    90.176     0.150
     2.907    49.277     0.150
     2.907    53.477     0.150
     2.907    84.078     0.150
     2.907    91.875     0.150
     3.367    54.777     0.150
     3.367    92.676     0.150
     3.367   104.477     0.150
     3.656    65.977     0.150
     3.656   115.078     0.150
     3.656    65.777     0.150
     3.656   114.777     0.150
     3.875    61.977     0.150
     3.875    70.176     0.150
     3.875   120.578     0.150
     4.057    64.277     0.150
     4.057    71.875     0.150
     4.057   125.477     0.150
     4.057    64.176     0.150
     4.057    73.676     0.150
     4.057   109.977     0.150
     4.057   123.777     0.150
     4.033    61.477     0.150
     4.033   107.777     0.150
     4.056    64.176     0.150
     4.056    72.977     0.150
     4.056   109.875     0.150
     4.056   126.277     0.150
     4.056    63.676     0.150
     4.056    72.578     0.150
     4.056   125.375     0.150
     4.420    67.676     0.150
     4.420   137.277     0.150
     4.694    72.875     0.150
     4.694    83.777     0.150
     4.694   125.078     0.150
     4.694   145.875     0.150
     4.971    76.676     0.150
     4.971   153.977     0.150
     4.964    76.977     0.150
     4.964   132.977     0.150
     4.964   154.078     0.150
     4.991    76.477     0.150
     4.991   131.875     0.150
     4.991   156.875     0.150
     4.991    76.277     0.150
     4.991   132.078     0.150
     4.991   156.676     0.150
     5.579    84.777     0.150
     5.579   143.578     0.150
     5.579   171.375     0.150
     5.791    95.176     0.150
     5.791   152.078     0.150
     5.791   179.875     0.150
     5.791    85.477     0.150
     5.814    86.977     0.150
     5.814   180.375     0.150
     6.012    90.820     0.150
     6.012   186.496     0.150
     6.012   186.176     0.150
     6.012    90.457     0.150
     6.445    97.078     0.150
     6.445   164.977     0.150
     6.445   199.578     0.150
     7.102   105.176     0.150
     7.102   220.875     0.150
     7.312   109.176     0.150
     7.312   191.176     0.150
     7.312   225.875     0.150
     7.478   111.578     0.150
     7.478   190.477     0.150
     7.478   232.375     0.150
     7.478   194.977     0.150
     7.569   234.875     0.150
     8.087   118.977     0.150
     8.264   121.957     0.150
     9.312   137.578     0.150
     9.714   142.176     0.150
     9.714   176.176     0.150
     9.714   301.176     0.150
    11.004   199.078     0.150
    11.004   339.477     0.150
    11.489   351.754     0.150
    13.840   197.875     0.150
    13.840   195.176     0.150
    15.456   218.688     0.150
    15.456   218.527     0.150
    15.674   219.078     0.150
    17.300   240.277     0.150
    17.599   243.676     0.150
    17.599   244.027     0.150
    20.144   272.875     0.150
    20.144   275.176     0.150
    20.182   274.875     0.150
    20.182   273.277     0.150
    20.275   277.203     0.150
    23.892   314.504     0.150
    23.939   314.176     0.150
    23.939   313.438     0.150
    24.329   318.398     0.150
    27.802   348.176     0.150
    27.802   703.578     0.150
    27.802   350.566     0.150
    31.458   382.398     0.150
    38.422   441.105     0.150
    42.035   471.918     0.150
    42.036   471.602     0.150
    43.988   488.875     0.150
    45.148   497.586     0.150
    45.534   500.367     0.150
    45.871   503.848     0.150
    45.885   503.945     0.150
    46.099   505.355     0.150
    46.099   505.578     0.150
    46.294   507.375     0.150
    46.309   506.457     0.150
    46.914   510.402     0.150
    47.021   512.785     0.150
    47.315   514.766     0.150
    47.659   516.176     0.150
    47.748   518.277     0.150
    47.770   517.898     0.150
    47.945   519.805     0.150
    48.007   519.738     0.150
    48.043   519.699     0.150
    48.078   521.375     0.150
    48.164   521.785     0.150
    48.579   525.707     0.150
    48.921   527.816     0.150
    48.969   527.445     0.150
    48.993   527.746     0.150
    49.143   527.316     0.150
    50.370   537.188     0.150
    50.550   541.035     0.150
    50.927   541.605     0.150
    52.924   556.828     0.150
    57.006   585.227     0.150
    71.867   684.125     0.150
    77.294   716.098     0.150
    90.121   780.961     0.150
     0.224     4.702     0.150
     0.224     8.102     0.150
     0.224     7.602     0.150
     0.576    11.202     0.150
     0.576    19.202     0.150
     1.088    21.102     0.150
     1.088    36.202     0.150
     1.088    20.702     0.150
     1.241    22.902     0.150
     1.241    39.502     0.150
     1.543    28.102     0.150
     1.543    48.802     0.150
     1.543    51.202     0.150
     1.543    27.902     0.150
     1.787    32.302     0.150
     1.787    32.702     0.150
     1.787    55.702     0.150
     1.787    56.602     0.150
     1.787    32.202     0.150
     1.961    35.402     0.150
     1.961    61.902     0.150
     1.961    35.302     0.150
     1.961    35.702     0.150
     2.486    42.102     0.150
     2.486    45.002     0.150
     2.486    47.302     0.150
     2.486    72.302     0.150
     2.486    78.202     0.150
     2.557    43.702     0.150
     2.557    47.902     0.150
     2.557    74.702     0.150
     2.557    81.502     0.150
     2.557    81.302     0.150
     3.295    53.202     0.150
     3.295    59.002     0.150
     3.295    90.702     0.150
     3.295   102.602     0.150
     3.492    55.402     0.150
     3.492    63.202     0.150
     3.492    95.202     0.150
     3.492   107.302     0.150
     3.469    56.602     0.150
     3.469    63.902     0.150
     3.469    97.802     0.150
     3.469   109.202     0.150
     3.808    60.502     0.150
     3.808    68.802     0.150
     3.808   104.402     0.150
     3.808   119.602     0.150
     3.808    69.802     0.150
     3.808   105.002     0.150
     3.808   119.102     0.150
     4.031    63.202     0.150
     4.031    73.102     0.150
     4.031   125.302     0.150
     4.031    62.702     0.150
     4.031    72.902     0.150
     4.031   108.902     0.150
     4.031   125.102     0.150
     4.099    64.602     0.150
     4.099    74.002     0.150
     4.099   110.302     0.150
     4.099   127.602     0.150
     4.336    68.002     0.150
     4.336    79.002     0.150
     4.336   135.602     0.150
     4.378    68.802     0.150
     4.378    79.302     0.150
     4.378   115.602     0.150
     4.378   136.002     0.150
     4.378    69.102     0.150
     4.378   135.901     0.150
     5.285    81.202     0.150
     5.285   138.602     0.150
     5.285   164.002     0.150
     5.513    84.102     0.150
     5.513   144.702     0.150
     5.513   169.401     0.150
     5.513    83.802     0.150
     5.513   145.102     0.150
     5.513   168.302     0.150
     5.581    85.002     0.150
     5.581   147.602     0.150
     5.581   173.802     0.150
     5.814    88.202     0.150
     5.814   152.102     0.150
     5.814   180.302     0.150
     5.859   181.802     0.150
     5.900   183.302     0.150
     6.113    92.202     0.150
     6.113   159.702     0.150
     6.113   189.602     0.150
     6.418    96.702     0.150
     6.418   165.602     0.150
     6.418   199.401     0.150
     6.414    95.302     0.150
     6.414   168.702     0.150
     6.414    94.902     0.150
     6.414   169.602     0.150
     6.414   198.302     0.150
     6.801   101.602     0.150
     6.801   211.002     0.150
     6.829   211.602     0.150
     6.829   211.002     0.150
     7.041   104.902     0.150
     7.041   217.102     0.150
     7.484   111.002     0.150
     7.484   191.901     0.150
     7.484   109.602     0.150
     7.484   229.401     0.150
     7.644   110.902     0.150
     7.644   110.502     0.150
     7.937   117.402     0.150
     7.937   203.002     0.150
     7.937   244.401     0.150
     8.018   206.702     0.150
     8.536   125.502     0.150
     8.536   154.901     0.150
     8.536   264.002     0.150
     8.809   129.802     0.150
     8.809   224.901     0.150
     8.809   271.802     0.150
     8.809   128.802     0.150
     8.809   225.302     0.150
     8.971   131.202     0.150
     8.971   226.702     0.150
     8.971   277.602     0.150
     9.216   137.002     0.150
     9.216   136.562     0.150
     9.436   137.941     0.150
     9.436   296.396     0.150
     9.436   138.302     0.150
    10.080   253.002     0.150
    10.080   142.722     0.150
    11.051   158.401     0.150
    11.051   199.002     0.150
    11.051   340.202     0.150
    12.767   183.102     0.150
    12.767   400.602     0.150
    12.767   183.901     0.150
    16.098   230.002     0.150
    16.504   233.802     0.150
    16.504   232.677     0.150
    16.504   519.202     0.150
    16.504   234.002     0.150
    16.780   234.122     0.150
    16.780   234.177     0.150
    16.780   236.502     0.150
    17.142   239.502     0.150
    17.466   248.002     0.150
    19.090   265.302     0.150
    19.770   270.901     0.150
    19.817   273.812     0.150
    19.984   277.202     0.150
    20.439   278.877     0.150
    20.439   641.927     0.150
    20.439   279.502     0.150
    20.699   284.602     0.150
    20.840   283.952     0.150
    21.103   288.202     0.150
    21.561   290.401     0.150
    21.561   290.682     0.150
    21.619   291.401     0.150
    21.619   291.702     0.150
    21.619   291.602     0.150
    21.655   291.677     0.150
    21.783   293.302     0.150
    24.227   320.702     0.150
    24.859   325.432     0.150
    24.806   323.691     0.150
    25.132   326.523     0.150
    25.176   328.202     0.150
    25.176   327.222     0.150
    25.248   327.562     0.150
    25.221   327.602     0.150
    25.221   328.026     0.150
    25.221   327.562     0.150
    25.361   329.502     0.150
    25.488   328.771     0.150
    25.703   333.352     0.150
    25.733   332.611     0.150
    26.126   337.042     0.150
    26.123   337.802     0.150
    26.123   611.602     0.150
    26.451   338.702     0.150
    26.451   378.502     0.150
    26.358   338.752     0.150
    26.707   342.102     0.150
    26.796   343.271     0.150
    26.780   343.271     0.150
    26.935   344.472     0.150
    27.251   345.662     0.150
    28.547   359.021     0.150
    28.547   359.302     0.150
    28.547   358.231     0.150
    29.908   436.102     0.150
    29.908   675.102     0.150
    30.076   371.901     0.150
    30.076   426.802     0.150
    30.076   672.401     0.150
    30.076   761.401     0.150
    30.449   374.102     0.150
    31.344   382.932     0.150
    32.706   394.082     0.150
    32.706   393.802     0.150
    33.069   399.602     0.150
    36.813   430.062     0.150
    36.813   428.752     0.150
    37.296   431.202     0.150
    37.310   434.102     0.150
    37.605   436.302     0.150
    38.216   440.802     0.150
    38.722   445.651     0.150
    38.722   445.252     0.150
    40.889   465.102     0.150
    40.889   464.552     0.150
    41.146   466.382     0.150
    41.587   469.102     0.150
    41.587   567.602     0.150
    41.587  1078.002     0.150
    41.682   470.478     0.150
    41.682   469.782     0.150
    41.767   470.521     0.150
    42.266   474.716     0.150
    42.614   477.602     0.150
    42.614   477.202     0.150
    42.634   478.202     0.150
    43.343   484.516     0.150
    43.747   487.536     0.150
    43.747   486.941     0.150
    43.917   487.021     0.150
    44.179   490.900     0.150
    44.245   490.651     0.150
    44.296   491.832     0.150
    44.417   492.884     0.150
    44.417   491.372     0.150
    44.421   493.159     0.150
    44.421   492.492     0.150
    44.425   492.901     0.150
    44.425   492.762     0.150
    44.441   492.012     0.150
    44.580   493.632     0.150
    44.590   493.302     0.150
    44.750   495.818     0.150
    44.814   494.492     0.150
    44.814   496.202     0.150
    44.814   495.622     0.150
    44.881   495.512     0.150
    44.980   496.802     0.150
    45.018   497.010     0.150
    45.018   496.592     0.150
    45.350   502.102     0.150
    45.350   499.852     0.150
    45.386   500.702     0.150
    45.495   500.062     0.150
    45.978   504.242     0.150
    46.016   504.602     0.150
    46.110   505.995     0.150
    46.160   505.771     0.150
    46.172   506.901     0.150
    46.172   506.122     0.150
    46.445   508.002     0.150
    46.484   508.092     0.150
    46.504   508.401     0.150
    46.523   508.702     0.150
    46.690   509.962     0.150
    46.760   511.593     0.150
    46.760   511.062     0.150
    46.813   513.102     0.150
    46.894   512.199     0.150
    47.070   512.952     0.150
    47.230   512.432     0.150
    47.255   514.941     0.150
    47.640   517.532     0.150
    47.680   516.852     0.150
    47.653   518.663     0.150
    47.653   517.552     0.150
    47.805   519.401     0.150
    47.805   519.032     0.150
    47.805   519.802     0.150
    48.064   519.319     0.150
    48.064   519.892     0.150
    48.481   523.702     0.150
    48.481   523.852     0.150
    48.861   526.882     0.150
    49.063   527.972     0.150
    49.244   530.352     0.150
    49.233   530.602     0.150
    51.820   549.752     0.150
    51.832   550.068     0.150
    51.832   549.952     0.150
    52.304   552.802     0.150
    52.705   558.102     0.150
    53.143   559.662     0.150
    53.867   566.002     0.150
    53.937   566.901     0.150
    53.993   566.502     0.150
    54.210   568.401     0.150
    54.632   571.901     0.150
    54.726   570.802     0.150
    54.901   573.002     0.150
    54.996   573.502     0.150
    55.134   575.102     0.150
    55.806   578.802     0.150
    55.911   577.901     0.150
    56.096   581.202     0.150
    56.255   581.276     0.150
    56.255   581.602     0.150
    56.391   583.401     0.150
    57.634   592.296     0.150
    58.367   598.763     0.150
    58.579   599.166     0.150
    58.812   599.302     0.150
    59.968   608.372     0.150
    59.978   609.002     0.150
    61.317   617.352     0.150
    61.427   618.071     0.150
    61.650   618.502     0.150
    61.853   622.002     0.150
    62.457   625.102     0.150
    62.687   626.901     0.150
    63.375   629.602     0.150
    65.766   645.202     0.150
    66.034   648.532     0.150
    66.735   653.194     0.150
    67.022   654.702     0.150
    67.664   659.104     0.150
    69.927   673.465     0.150
    70.392   675.602     0.150
    70.376   676.455     0.150
    70.651   678.011     0.150
    71.053   679.702     0.150
    71.116   680.122     0.150
    71.118   680.227     0.150
    71.118   679.972     0.150
    71.165   680.202     0.150
    71.221   680.802     0.150
    71.732   684.024     0.150
    71.910   685.401     0.150
    72.127   687.170     0.150
    72.367   686.901     0.150
    72.575   688.802     0.150
    72.690   690.802     0.150
    72.711   690.109     0.150
    72.852   690.601     0.150
    73.091   690.317     0.150
    73.323   693.002     0.150
    74.134   696.764     0.150
    74.195   697.563     0.150
    74.879   701.808     0.150
    74.924   702.352     0.150
    75.196   703.633     0.150
    75.196   703.002     0.150
    75.975   709.727     0.150
    75.975   708.562     0.150
    76.118   709.663     0.150
    76.118   709.182     0.150
    76.263   710.452     0.150
    76.625   711.677     0.150
    77.080   713.858     0.150
    77.305   715.136     0.150
    77.697   718.370     0.150
    77.689   718.728     0.150
    77.731   718.679     0.150
    77.783   718.731     0.150
    77.622   717.202     0.150
    77.629   717.026     0.150
    77.629   717.302     0.150
    77.631   717.182     0.150
    78.246   720.975     0.150
    78.372   722.209     0.150
    78.430   722.038     0.150
    78.799   724.810     0.150
    78.826   724.600     0.150
    79.206   726.107     0.150
    79.245   727.154     0.150
    79.318   726.726     0.150
    79.304   727.670     0.150
    79.458   727.468     0.150
    79.707   729.805     0.150
    79.750   729.593     0.150
    79.897   730.912     0.150
    79.942   731.312     0.150
    80.304   732.529     0.150
    80.350   733.026     0.150
    80.356   733.608     0.150
    80.742   735.215     0.150
    80.927   736.924     0.150
    80.944   737.053     0.150
    80.951   736.976     0.150
    81.182   736.802     0.150
    81.182   737.102     0.150
    81.507   739.045     0.150
    81.618   739.887     0.150
    82.038   742.057     0.150
    82.561   743.691     0.150
    82.651   743.847     0.150
    82.685   743.972     0.150
    83.065   746.895     0.150
    83.064   747.684     0.150
    83.064   747.102     0.150
    83.158   747.262     0.150
    83.175   747.252     0.150
    83.328   747.570     0.150
    83.485   748.357     0.150
    83.723   749.451     0.150
    83.795   750.172     0.150
    83.853   750.800     0.150
    84.314   753.240     0.150
    84.534   754.340     0.150
    84.534   753.401     0.150
    84.560   754.425     0.150
    84.890   756.554     0.150
    85.123   756.661     0.150
    85.179   756.799     0.150
    85.292   758.076     0.150
    85.379   758.824     0.150
    85.482   758.946     0.150
    85.631   759.494     0.150
    86.290   762.396     0.150
    86.339   763.440     0.150
    86.409   763.780     0.150
    86.445   763.466     0.150
    86.987   765.812     0.150
    87.165   767.266     0.150
    87.370   767.618     0.150
    87.432   767.695     0.150
    87.694   769.670     0.150
    88.609   773.821     0.150
    89.135   777.002     0.150
    89.154   777.049     0.150
    89.501   778.124     0.150
    89.677   778.911     0.150
    91.137   785.327     0.150
    91.137   785.912     0.150
   149.649  1189.276     0.150
     0.223     4.383     0.150
     0.223     7.680     0.150
     0.617    11.281     0.150
     0.617    20.180     0.150
     0.617    19.586     0.150
     1.062    19.883     0.150
     1.062    34.781     0.150
     1.062    34.883     0.150
     1.248    22.883     0.150
     1.248    39.484     0.150
     1.248    22.984     0.150
     1.248    40.383     0.150
     1.557    28.086     0.150
     1.557    29.883     0.150
     1.557    49.180     0.150
     1.557    27.984     0.150
     1.747    31.484     0.150
     1.747    54.383     0.150
     1.747    31.781     0.150
     1.747    55.086     0.150
     1.992    35.484     0.150
     1.992    37.086     0.150
     1.992    62.383     0.150
     1.992    35.984     0.150
     1.992    36.984     0.150
     1.992    64.180     0.150
     2.533    42.984     0.150
     2.533    46.984     0.150
     2.533    79.781     0.150
     2.533    42.680     0.150
     2.533    46.586     0.150
     2.533    80.086     0.150
     2.500    42.586     0.150
     2.500    44.883     0.150
     2.500    76.586     0.150
     3.447    56.086     0.150
     3.447    62.883     0.150
     3.447    96.484     0.150
     3.447   108.281     0.150
     3.330    53.680     0.150
     3.330    61.180     0.150
     3.330   104.383     0.150
     3.330    61.781     0.150
     3.330   103.883     0.150
     3.455    54.781     0.150
     3.455    62.086     0.150
     3.455    94.086     0.150
     3.455   105.781     0.150
     3.814    60.180     0.150
     3.814    69.781     0.150
     3.814   104.680     0.150
     3.814   119.883     0.150
     3.814    69.680     0.150
     3.814   104.883     0.150
     3.814   119.781     0.150
     4.071    63.281     0.150
     4.071    73.586     0.150
     4.071   127.180     0.150
     4.071    63.180     0.150
     4.071   110.180     0.150
     4.071   126.180     0.150
     4.319    66.680     0.150
     4.319    77.086     0.150
     4.319   134.180     0.150
     4.408    69.180     0.150
     4.408   117.281     0.150
     4.408   136.383     0.150
     4.408    68.484     0.150
     4.408   136.484     0.150
     5.544    84.586     0.150
     5.544   171.180     0.150
     5.544    84.484     0.150
     5.544   145.680     0.150
     5.544   169.383     0.150
     5.847   180.781     0.150
     5.892    88.383     0.150
     5.892   182.086     0.150
     6.099    91.383     0.150
     6.099   189.383     0.150
     6.116    92.984     0.150
     6.116   110.883     0.150
     6.116   159.883     0.150
     6.116   190.086     0.150
     6.081    91.781     0.150
     6.081   189.680     0.150
     6.455    95.680     0.150
     6.455   106.883     0.150
     6.455   167.484     0.150
     6.455   201.086     0.150
     6.455    95.383     0.150
     6.455   200.586     0.150
     6.449   198.586     0.150
     6.832   102.180     0.150
     6.832   210.086     0.150
     6.858   212.680     0.150
     7.071   116.484     0.150
     7.071   128.180     0.150
     7.071   219.586     0.150
     7.514   110.883     0.150
     7.514   231.180     0.150
     7.514   232.086     0.150
     7.514   112.289     0.150
     7.674   111.680     0.150
     7.674   110.203     0.150
     8.016   117.484     0.150
     8.016   204.484     0.150
     7.964   117.984     0.150
     7.964   245.883     0.150
     7.964   118.484     0.150
     8.568   126.383     0.150
     8.568   155.383     0.150
     8.568   266.680     0.150
     8.568   128.281     0.150
     8.835   130.180     0.150
     8.835   272.383     0.150
     8.835   129.883     0.150
     8.992   131.984     0.150
     8.992   227.586     0.150
     8.992   277.281     0.150
     8.992   131.086     0.150
     9.255   135.281     0.150
     9.475   138.242     0.150
     9.475   243.109     0.150
     9.475   294.727     0.150
    10.045   142.180     0.150
    10.045   308.062     0.150
    10.045   144.383     0.150
    10.045   256.680     0.150
    11.237   161.281     0.150
    11.237   348.484     0.150
    12.467   177.984     0.150
    12.467   385.586     0.150
    12.774   182.555     0.150
    12.774   317.711     0.150
    16.520   519.508     0.150
    16.787   236.164     0.150
    16.787   234.734     0.150
    16.787   235.586     0.150
    17.159   240.383     0.150
    19.128   277.680     0.150
    19.128   280.883     0.150
    19.836   273.086     0.150
    20.408   280.156     0.150
    20.408   638.305     0.150
    20.725   282.180     0.150
    21.571   291.781     0.150
    21.571   291.320     0.150
    21.638   292.680     0.150
    21.638   292.055     0.150
    21.638   292.281     0.150
    21.638   292.586     0.150
    21.665   292.484     0.150
    21.801   293.680     0.150
    24.877   325.016     0.150
    25.134   325.102     0.150
    25.178   327.680     0.150
    25.178   326.031     0.150
    25.509   329.273     0.150
    26.146   337.453     0.150
    26.376   339.625     0.150
    26.724   342.516     0.150
    26.815   343.555     0.150
    26.798   343.789     0.150
    27.266   346.531     0.150
    28.565   358.727     0.150
    28.565   359.180     0.150
    30.464   375.383     0.150
    30.464   375.484     0.150
    31.359   383.961     0.150
    39.231   449.180     0.150
    40.901   464.805     0.150
    42.592   476.781     0.150
    42.593   477.008     0.150
    42.593   477.484     0.150
    44.207   489.430     0.150
    44.776   493.484     0.150
    44.776   494.883     0.150
    45.673   501.344     0.150
    46.446   506.859     0.150
    46.464   508.359     0.150
    46.464   507.586     0.150
    47.792   517.961     0.150
    48.024   519.352     0.150
    48.456   524.000     0.150
    51.808   549.945     0.150
    55.870   577.836     0.150
    55.870   578.180     0.150
    56.079   579.883     0.150
    56.079   581.484     0.150
    56.238   581.656     0.150
    71.098   680.336     0.150
    77.663   716.906     0.150
    77.663   716.383     0.150
    81.217   735.883     0.150
     0.111     2.254     0.150
     0.111     3.656     0.150
     0.111     4.754     0.150
     1.112    20.355     0.150
     1.112    36.355     0.150
     1.205    21.754     0.150
     1.205    23.254     0.150
     1.205    38.254     0.150
     1.414    44.855     0.150
     1.414    48.055     0.150
     1.414    45.453     0.150
     1.791    31.754     0.150
     1.791    31.953     0.150
     1.791    54.953     0.150
     1.858    33.656     0.150
     1.858    58.656     0.150
     1.858    34.055     0.150
     1.858    57.855     0.150
     1.858    59.055     0.150
     2.357    40.555     0.150
     2.357    42.055     0.150
     2.357    70.953     0.150
     2.357    73.855     0.150
     2.357    40.754     0.150
     2.357    73.555     0.150
     2.677    44.453     0.150
     2.677    48.953     0.150
     2.677    84.156     0.150
     2.677    48.754     0.150
     3.206    51.754     0.150
     3.206    57.254     0.150
     3.206    99.754     0.150
     3.206    57.953     0.150
     3.465    54.055     0.150
     3.465    61.355     0.150
     3.465    63.055     0.150
     3.465    94.355     0.150
     3.465   105.754     0.150
     3.592    57.254     0.150
     3.592    65.156     0.150
     3.592    98.453     0.150
     3.592   111.555     0.150
     3.929    61.355     0.150
     3.929    70.254     0.150
     3.929   106.754     0.150
     3.929   122.254     0.150
     3.929    71.055     0.150
     3.929   107.355     0.150
     4.003    62.555     0.150
     4.003    72.453     0.150
     4.003   125.254     0.150
     4.028    72.453     0.150
     4.028   124.855     0.150
     4.269    67.254     0.150
     4.269    75.953     0.150
     4.269   132.254     0.150
     4.464    68.656     0.150
     4.464    79.656     0.150
     4.464   138.453     0.150
     5.186   161.055     0.150
     5.407    81.953     0.150
     5.407   165.953     0.150
     5.407   142.355     0.150
     5.407   167.453     0.150
     5.717    85.953     0.150
     5.717   148.754     0.150
     5.717   176.555     0.150
     5.761   179.754     0.150
     5.800    86.855     0.150
     5.800   101.953     0.150
     5.955    88.453     0.150
     5.955   185.453     0.150
     6.242    92.855     0.150
     6.242   162.453     0.150
     6.242   193.453     0.150
     6.313    94.055     0.150
     6.313   165.055     0.150
     6.313   195.754     0.150
     6.398    94.254     0.150
     6.398   166.355     0.150
     6.398   198.555     0.150
     6.398    94.555     0.150
     6.398   197.156     0.150
     6.696    98.855     0.150
     6.696   205.555     0.150
     6.718   207.855     0.150
     6.718   101.453     0.150
     6.718   208.453     0.150
     7.375   108.754     0.150
     7.375   226.156     0.150
     7.375   109.727     0.150
     7.713   111.055     0.150
     7.822   114.156     0.150
     7.822   199.555     0.150
     7.822   240.254     0.150
     7.822   239.855     0.150
     8.146   120.453     0.150
     8.146   210.656     0.150
     8.434   124.754     0.150
     8.434   151.156     0.150
     8.434   214.855     0.150
     8.434   259.855     0.150
     8.434   153.555     0.150
     8.692   127.055     0.150
     8.692   156.754     0.150
     8.692   221.754     0.150
     8.692   268.754     0.150
     8.847   129.254     0.150
     8.847   224.656     0.150
     8.847   273.254     0.150
     8.847   158.754     0.150
     9.153   134.754     0.150
     9.369   136.613     0.150
     9.369   171.738     0.150
     9.369   295.977     0.150
     9.369   137.055     0.150
    10.173   144.254     0.150
    10.173   311.902     0.150
    10.173   146.953     0.150
    10.173   146.094     0.150
    12.886   183.531     0.150
    15.267   232.254     0.150
    16.115   232.254     0.150
    16.608   234.281     0.150
    16.608   523.180     0.150
    16.651   233.734     0.150
    16.651   233.629     0.150
    16.651   236.754     0.150
    17.713   552.906     0.150
    19.018   265.156     0.150
    19.018   269.656     0.150
    19.018   272.453     0.150
    20.544   280.031     0.150
    20.544   642.828     0.150
    20.544   281.254     0.150
    20.583   283.453     0.150
    20.913   285.105     0.150
    20.913   662.230     0.150
    20.913   287.156     0.150
    21.055   287.055     0.150
    21.055   309.855     0.150
    21.431   291.156     0.150
    21.431   289.594     0.150
    21.493   290.656     0.150
    21.493   289.805     0.150
    21.493   681.746     0.150
    21.525   290.156     0.150
    21.525   680.465     0.150
    21.656   292.254     0.150
    25.004   325.473     0.150
    25.049   325.754     0.150
    25.049   324.824     0.150
    28.420   357.754     0.150
    38.646   443.355     0.150
    39.142   448.535     0.150
    41.751   470.914     0.150
    42.339   475.543     0.150
    42.518   475.816     0.150
    42.520   475.578     0.150
    42.520   476.254     0.150
    42.720   478.355     0.150
    44.522   493.684     0.150
    44.890   496.215     0.150
    44.890   494.742     0.150
    44.890   496.156     0.150
    46.563   508.078     0.150
    46.563   508.555     0.150
    47.692   516.680     0.150
    48.114   519.566     0.150
    48.396   522.355     0.150
    55.963   577.680     0.150
    55.963   577.855     0.150
    56.152   579.512     0.150
    71.022   678.906     0.150
    74.990   701.406     0.150
    76.056   709.129     0.150
    77.675   716.711     0.150
    81.226   736.254     0.150
    91.019   784.773     0.150
   149.611  1189.453     0.150
     0.099     1.996     0.150
     0.099     3.996     0.150
     0.099     3.895     0.150
     0.575    10.594     0.150
     0.575    18.297     0.150
     1.111    20.195     0.150
     1.196    21.797     0.150
     1.196    23.297     0.150
     1.196    22.395     0.150
     1.196    38.094     0.150
     1.417    25.695     0.150
     1.417    44.395     0.150
     1.417    47.797     0.150
     1.417    25.594     0.150
     1.417    44.695     0.150
     1.771    31.297     0.150
     1.771    31.195     0.150
     1.771    54.695     0.150
     1.872    33.195     0.150
     1.872    34.195     0.150
     1.872    59.094     0.150
     1.872    33.996     0.150
     1.872    57.996     0.150
     2.360    41.094     0.150
     2.360    44.695     0.150
     2.360    71.594     0.150
     2.360    43.695     0.150
     2.360    69.395     0.150
     2.360    73.895     0.150
     2.669    44.297     0.150
     2.669    48.895     0.150
     2.669    83.297     0.150
     2.669    43.996     0.150
     2.669    48.496     0.150
     2.669    82.594     0.150
     3.222    51.797     0.150
     3.222    57.297     0.150
     3.222   100.195     0.150
     3.222    50.695     0.150
     3.222    57.094     0.150
     3.222   100.297     0.150
     3.445    53.895     0.150
     3.445    61.695     0.150
     3.445    92.797     0.150
     3.445   104.996     0.150
     4.018    72.797     0.150
     4.018   124.695     0.150
     3.936    61.297     0.150
     3.936    70.297     0.150
     3.936   122.094     0.150
     3.936    71.297     0.150
     3.936   107.496     0.150
     3.936   122.797     0.150
     4.049    73.195     0.150
     4.049   125.996     0.150
     4.049    63.695     0.150
     4.049    73.496     0.150
     4.281    67.094     0.150
     4.281    77.094     0.150
     4.281   132.895     0.150
     4.281    66.895     0.150
     4.281   131.594     0.150
     4.459    68.297     0.150
     4.459    79.695     0.150
     4.459   137.496     0.150
     5.420    81.996     0.150
     5.420   167.594     0.150
     5.420    95.895     0.150
     5.420   140.094     0.150
     5.420   165.895     0.150
     5.732    86.395     0.150
     5.732   177.395     0.150
     5.776   179.395     0.150
     5.971    89.594     0.150
     5.971   186.195     0.150
     6.326   105.297     0.150
     6.326   196.094     0.150
     6.418    94.496     0.150
     6.418   198.594     0.150
     6.418   198.695     0.150
     6.709   100.094     0.150
     6.709   206.996     0.150
     6.730   209.895     0.150
     7.387   227.297     0.150
     7.833   242.297     0.150
     8.149   120.496     0.150
     8.149   206.395     0.150
     8.448   124.297     0.150
     8.448   262.195     0.150
     8.448   261.797     0.150
     8.702   125.996     0.150
     8.702   269.395     0.150
     8.702   126.195     0.150
     8.855   129.297     0.150
     8.855   224.895     0.150
     8.855   273.094     0.150
     8.855   128.996     0.150
     8.855   226.594     0.150
     9.172   134.695     0.150
     9.387   136.375     0.150
     9.387   171.336     0.150
     9.387   240.273     0.150
     9.387   292.773     0.150
    10.158   144.945     0.150
    10.158   313.543     0.150
    10.158   146.195     0.150
    10.158   258.797     0.150
    12.893   184.969     0.150
    12.893   400.945     0.150
    16.650   234.516     0.150
    16.619   233.797     0.150
    16.619   520.949     0.150
    16.916   234.895     0.150
    17.696   245.594     0.150
    19.035   263.496     0.150
    20.531   280.797     0.150
    20.531   278.895     0.150
    21.432   290.094     0.150
    21.499   289.969     0.150
    21.526   290.621     0.150
    25.002   325.281     0.150
    25.046   325.996     0.150
    39.162   449.848     0.150
    42.506   476.469     0.150
    44.872   495.695     0.150
    46.544   508.469     0.150
    55.944   577.719     0.150
    56.140   580.371     0.150
    71.009   679.316     0.150
    76.039   708.820     0.150
    77.694   716.797     0.150
    91.011   784.414     0.150
     0.109     2.598     0.150
     0.109     3.996     0.150
     0.109     4.898     0.150
     0.576    11.098     0.150
     0.576    18.996     0.150
     0.576    19.098     0.150
     1.124    20.699     0.150
     1.124    35.699     0.150
     1.124    36.598     0.150
     1.184    22.297     0.150
     1.184    38.598     0.150
     1.184    22.098     0.150
     1.430    26.098     0.150
     1.430    27.797     0.150
     1.430    48.598     0.150
     1.430    25.996     0.150
     1.430    45.898     0.150
     1.770    32.098     0.150
     1.770    57.297     0.150
     1.770    31.898     0.150
     1.770    55.098     0.150
     1.882    34.098     0.150
     1.882    34.797     0.150
     1.882    59.496     0.150
     1.882    34.297     0.150
     1.882    58.199     0.150
     2.373    40.996     0.150
     2.373    42.898     0.150
     2.373    71.496     0.150
     2.373    74.199     0.150
     2.373    42.797     0.150
     2.373    71.699     0.150
     2.657    44.898     0.150
     2.657    49.297     0.150
     2.657    83.699     0.150
     2.657    44.598     0.150
     2.657    48.996     0.150
     2.657    83.398     0.150
     3.230    52.297     0.150
     3.230    59.098     0.150
     3.230   100.699     0.150
     3.230    52.398     0.150
     3.230    60.297     0.150
     3.447    54.398     0.150
     3.447    62.297     0.150
     3.447    95.199     0.150
     3.447   105.797     0.150
     3.924    61.797     0.150
     3.924   107.199     0.150
     3.924   122.797     0.150
     3.924    61.996     0.150
     3.924    71.797     0.150
     4.028    63.398     0.150
     4.028    73.297     0.150
     4.028   109.398     0.150
     4.028   125.898     0.150
     4.049    63.699     0.150
     4.049    73.398     0.150
     4.049   109.199     0.150
     4.049   126.098     0.150
     4.292    67.797     0.150
     4.292    77.797     0.150
     4.292   115.699     0.150
     4.292   133.598     0.150
     4.292   133.699     0.150
     4.446    69.398     0.150
     4.446    79.898     0.150
     4.446   137.098     0.150
     5.210    80.496     0.150
     5.210   162.297     0.150
     5.430    82.297     0.150
     5.430   141.398     0.150
     5.430   166.699     0.150
     5.430    82.496     0.150
     5.430   166.598     0.150
     5.742    86.398     0.150
     5.742   178.496     0.150
     5.980    90.797     0.150
     5.980   186.699     0.150
     6.226    93.496     0.150
     6.226   192.797     0.150
     6.337    95.598     0.150
     6.337   190.098     0.150
     6.337   197.398     0.150
     6.420    95.098     0.150
     6.420   165.797     0.150
     6.420   199.199     0.150
     6.420    94.898     0.150
     6.420   198.898     0.150
     6.719   100.398     0.150
     6.719   207.598     0.150
     6.741   208.098     0.150
     6.741   207.898     0.150
     7.398   226.398     0.150
     7.723   112.398     0.150
     7.845   115.199     0.150
     7.845   242.996     0.150
     8.458   125.996     0.150
     8.458   215.898     0.150
     8.458   262.797     0.150
     8.714   127.699     0.150
     8.714   158.699     0.150
     8.714   222.496     0.150
     8.714   270.098     0.150
     8.714   127.898     0.150
     8.867   130.098     0.150
     8.867   225.398     0.150
     8.867   274.398     0.150
     8.867   227.496     0.150
     9.394   137.637     0.150
     9.394   295.719     0.150
    10.149   145.398     0.150
    12.882   184.996     0.150
    16.609   236.125     0.150
    16.609   523.848     0.150
    16.663   235.098     0.150
    16.912   235.086     0.150
    17.703   246.699     0.150
    20.520   280.848     0.150
    20.923   285.598     0.150
    20.923   285.797     0.150
    21.445   292.297     0.150
    21.445   291.977     0.150
    21.511   291.098     0.150
    21.511   290.672     0.150
    21.539   290.859     0.150
    21.674   292.199     0.150
    22.270   299.199     0.150
    25.014   325.570     0.150
    25.059   326.098     0.150
    25.059   326.258     0.150
    28.438   357.770     0.150
    30.337   373.199     0.150
    30.337   373.898     0.150
    38.638   443.012     0.150
    39.167   449.320     0.150
    40.774   462.457     0.150
    42.515   476.270     0.150
    42.515   475.598     0.150
    44.476   493.199     0.150
    44.865   496.348     0.150
    45.232   499.398     0.150
    45.232   600.996     0.150
    45.232   900.496     0.150
    46.538   508.723     0.150
    46.538   509.156     0.150
    47.694   518.648     0.150
    48.389   523.105     0.150
    53.026   559.113     0.150
    55.938   578.246     0.150
    55.991   581.496     0.150
    56.151   580.914     0.150
    70.671   677.797     0.150
    71.019   679.508     0.150
    71.698   682.957     0.150
    72.890   691.176     0.150
    74.965   702.270     0.150
    76.031   709.621     0.150
    77.689   717.273     0.150
    77.772   719.129     0.150
    79.027   726.527     0.150
    79.193   727.699     0.150
    81.241   736.699     0.150
    85.410   759.398     0.150
    91.023   784.367     0.150
   149.596  1188.398     0.150
     0.107     2.234     0.150
     0.107     4.633     0.150
     0.107     2.336     0.150
     0.107     3.836     0.150
     0.589    10.836     0.150
     0.589    18.934     0.150
     0.589    18.734     0.150
     1.127    20.535     0.150
     1.127    35.633     0.150
     1.127    37.234     0.150
     1.176    22.035     0.150
     1.176    38.234     0.150
     1.176    42.133     0.150
     1.176    37.535     0.150
     1.435    26.133     0.150
     1.435    46.133     0.150
     1.435    48.734     0.150
     1.756    31.336     0.150
     1.756    54.633     0.150
     1.756    31.234     0.150
     1.893    34.035     0.150
     1.893    59.734     0.150
     2.378    40.934     0.150
     2.378    43.035     0.150
     2.378    71.836     0.150
     2.378    73.934     0.150
     2.378    41.535     0.150
     2.378    43.434     0.150
     2.378    75.234     0.150
     2.649    44.133     0.150
     2.649    48.535     0.150
     2.649    83.836     0.150
     3.242    52.133     0.150
     3.242    59.234     0.150
     3.242   100.535     0.150
     3.242    52.234     0.150
     3.242   100.836     0.150
     3.435    54.633     0.150
     3.435    62.633     0.150
     3.435    95.336     0.150
     3.435   105.035     0.150
     3.925    61.434     0.150
     3.925    71.035     0.150
     3.925   106.633     0.150
     3.925   123.133     0.150
     3.925    61.535     0.150
     3.925    71.234     0.150
     3.925   106.934     0.150
     3.925   122.234     0.150
     4.039    73.434     0.150
     4.039   126.836     0.150
     4.062    63.133     0.150
     4.062    73.633     0.150
     4.062   125.336     0.150
     4.062   126.934     0.150
     4.062    61.836     0.150
     4.062    74.234     0.150
     4.062   127.234     0.150
     4.302    67.434     0.150
     4.302    77.836     0.150
     4.302   133.836     0.150
     4.302    67.734     0.150
     4.302   133.633     0.150
     4.440    80.234     0.150
     4.440   137.836     0.150
     5.222   164.035     0.150
     5.441   167.734     0.150
     5.753   105.836     0.150
     5.753   179.336     0.150
     5.797   179.133     0.150
     5.835   182.336     0.150
     5.992   110.133     0.150
     5.992   187.734     0.150
     6.221   192.734     0.150
     6.348   196.234     0.150
     6.348   198.734     0.150
     6.433   201.734     0.150
     6.730   209.035     0.150
     6.751   207.734     0.150
     7.409   230.633     0.150
     7.409   135.234     0.150
     7.854   239.234     0.150
     7.854   242.336     0.150
     8.469   154.434     0.150
     8.469   263.035     0.150
     8.469   156.434     0.150
     8.723   270.434     0.150
     8.875   226.133     0.150
     8.875   274.535     0.150
     9.407   137.555     0.150
     9.407   296.176     0.150
    10.137   143.785     0.150
    10.137   255.836     0.150
    10.137   143.246     0.150
    12.173   375.336     0.150
    12.883   183.809     0.150
    12.883   401.109     0.150
    14.500   207.234     0.150
    15.251   216.426     0.150
    15.302   218.133     0.150
    15.302   224.234     0.150
    16.125   227.836     0.150
    16.146   227.836     0.150
    16.666   233.305     0.150
    16.666   235.062     0.150
    16.614   234.633     0.150
    16.614   235.832     0.150
    17.039   238.836     0.150
    18.493   257.133     0.150
    19.055   263.633     0.150
    19.055   268.535     0.150
    19.055   271.734     0.150
    19.717   271.426     0.150
    19.856   273.633     0.150
    19.856   272.445     0.150
    20.000   275.035     0.150
    20.000   495.434     0.150
    20.101   274.734     0.150
    20.524   281.035     0.150
    20.509   279.984     0.150
    20.509   642.859     0.150
    20.509   280.734     0.150
    20.614   282.336     0.150
    20.614   286.934     0.150
    20.614   289.434     0.150
    20.614   508.836     0.150
    20.682   280.836     0.150
    20.682   516.703     0.150
    20.682   280.734     0.150
    20.931   285.184     0.150
    20.931   661.961     0.150
    21.093   286.133     0.150
    21.093   519.035     0.150
    21.093   524.434     0.150
    21.093   548.234     0.150
    21.449   289.234     0.150
    21.449   289.383     0.150
    21.518   290.133     0.150
    21.518   290.418     0.150
    21.543   291.109     0.150
    21.681   291.934     0.150
    21.863   294.508     0.150
    22.283   299.035     0.150
    22.283   299.336     0.150
    23.649   310.734     0.150
    24.282   318.035     0.150
    24.282   576.035     0.150
    24.282   584.035     0.150
    24.282   624.535     0.150
    24.757   323.246     0.150
    24.905   325.246     0.150
    25.016   325.305     0.150
    25.060   325.434     0.150
    25.060   325.676     0.150
    25.263   327.535     0.150
    25.391   327.324     0.150
    25.322   328.410     0.150
    25.523   330.734     0.150
    25.604   332.164     0.150
    26.119   336.035     0.150
    26.604   340.824     0.150
    26.696   341.246     0.150
    26.679   342.234     0.150
    26.679   342.133     0.150
    27.056   345.215     0.150
    27.218   346.855     0.150
    28.445   356.953     0.150
    28.445   356.535     0.150
    28.445   357.336     0.150
    30.025   370.156     0.150
    30.030   373.633     0.150
    30.342   373.035     0.150
    30.342   373.035     0.150
    31.238   381.395     0.150
    31.944   386.734     0.150
    32.590   392.105     0.150
    33.013   398.160     0.150
    34.366   408.734     0.150
    34.484   410.035     0.150
    34.816   412.434     0.150
    34.838   413.336     0.150
    34.977   414.234     0.150
    34.990   414.336     0.150
    35.046   414.035     0.150
    35.456   418.625     0.150
    37.100   431.234     0.150
    37.100   780.234     0.150
    37.186   430.633     0.150
    37.186   514.836     0.150
    37.186   430.734     0.150
    37.308   433.266     0.150
    38.267   441.035     0.150
    38.283   441.637     0.150
    38.283   440.203     0.150
    38.629   442.848     0.150
    39.180   449.473     0.150
    39.180   449.184     0.150
    39.180   578.684     0.150
    40.779   463.434     0.150
    40.779   462.406     0.150
    41.188   465.535     0.150
    41.773   469.133     0.150
    41.713   470.441     0.150
    41.713   469.723     0.150
    42.301   475.246     0.150
    42.301   475.355     0.150
    42.509   476.184     0.150
    43.383   484.309     0.150
    43.786   488.113     0.150
    43.786   487.176     0.150
    44.196   490.805     0.150
    44.314   492.734     0.150
    44.283   491.375     0.150
    44.455   492.910     0.150
    44.455   493.344     0.150
    44.460   493.227     0.150
    44.460   492.805     0.150
    44.463   492.535     0.150
    44.485   493.004     0.150
    44.619   493.836     0.150
    44.629   494.176     0.150
    44.792   495.355     0.150
    44.852   495.203     0.150
    44.852   495.785     0.150
    45.046   498.234     0.150
    45.057   497.148     0.150
    45.232   499.336     0.150
    45.232   598.133     0.150
    45.232   901.535     0.150
    45.232   499.234     0.150
    45.269   499.809     0.150
    45.398   500.305     0.150
    45.898   501.285     0.150
    45.898   598.215     0.150
    45.898   608.906     0.150
    45.898   830.383     0.150
    45.898   832.594     0.150
    45.898   905.543     0.150
    45.898  1097.363     0.150
    45.898  1112.504     0.150
    46.024   504.543     0.150
    46.063   503.336     0.150
    46.218   506.043     0.150
    46.486   508.133     0.150
    46.525   508.535     0.150
    46.724   510.785     0.150
    46.803   511.496     0.150
    46.803   511.105     0.150
    46.930   512.367     0.150
    46.930   512.086     0.150
    46.990   512.375     0.150
    46.990   512.535     0.150
    47.166   513.777     0.150
    47.166   513.535     0.150
    47.178   513.691     0.150
    47.299   514.844     0.150
    47.468     2.500     0.150
    47.690   516.941     0.150
    47.690   517.934     0.150
    47.690   516.836     0.150
    47.696   518.781     0.150
    47.696   517.945     0.150
    47.773   518.074     0.150
    48.076   519.586     0.150
    48.076   519.383     0.150
    48.131   520.035     0.150
    48.382   521.934     0.150
    48.382   522.145     0.150
    48.701   526.180     0.150
    48.904   528.516     0.150
    49.116   529.695     0.150
    49.105   530.414     0.150
    49.285   531.125     0.150
    52.191   551.836     0.150
    52.191   551.734     0.150
    53.025   558.828     0.150
    53.025   559.734     0.150
    53.441   564.133     0.150
    53.756   563.336     0.150
    54.098   566.434     0.150
    54.364   567.734     0.150
    54.521   568.836     0.150
    54.536   569.715     0.150
    54.618   568.734     0.150
    54.790   571.035     0.150
    54.984   571.734     0.150
    55.215   574.336     0.150
    55.391   574.734     0.150
    55.819   579.336     0.150
    55.866   579.746     0.150
    55.925   577.660     0.150
    55.986   579.535     0.150
    55.986   579.234     0.150
    56.146   580.645     0.150
    56.146   580.309     0.150
    56.141   580.574     0.150
    56.224   581.844     0.150
    56.524   585.555     0.150
    56.517   584.105     0.150
    56.582   584.211     0.150
    56.782   586.004     0.150
    57.176   588.641     0.150
    57.522   591.164     0.150
    57.634   591.977     0.150
    57.841   592.949     0.150
    58.017   593.453     0.150
    58.036   592.594     0.150
    58.220   595.957     0.150
    58.249   596.039     0.150
    58.256   594.250     0.150
    58.420   597.422     0.150
    58.460   598.277     0.150
    58.469   596.770     0.150
    58.703   598.434     0.150
    58.832   601.484     0.150
    58.996   600.102     0.150
    59.176   601.133     0.150
    59.345   603.375     0.150
    59.859   607.004     0.150
    60.500   610.008     0.150
    63.371   629.734     0.150
    65.774   644.836     0.150
    66.908   653.562     0.150
    67.426   656.895     0.150
    67.479   657.234     0.150
    67.697   658.254     0.150
    67.697   659.434     0.150
    67.740   658.594     0.150
    67.967   660.746     0.150
    68.914   666.605     0.150
    69.690   671.516     0.150
    69.722   672.656     0.150
    69.957   673.234     0.150
    69.957   672.395     0.150
    70.087   672.836     0.150
    70.087   673.145     0.150
    70.290   674.336     0.150
    70.420   676.668     0.150
    70.658   677.234     0.150
    70.732   676.934     0.150
    70.691   677.113     0.150
    70.694   677.848     0.150
    70.861   678.133     0.150
    70.950   679.133     0.150
    71.011   678.504     0.150
    71.012   678.660     0.150
    71.063   679.434     0.150
    71.118   681.133     0.150
    71.115   679.629     0.150
    71.115   679.426     0.150
    71.224   678.434     0.150
    71.239   680.801     0.150
    71.304   681.844     0.150
    71.313   680.895     0.150
    71.572   682.836     0.150
    71.513   682.473     0.150
    71.669   682.934     0.150
    71.685   683.746     0.150
    71.807   683.535     0.150
    71.761   683.336     0.150
    71.761   683.535     0.150
    71.755   684.449     0.150
    72.092   686.406     0.150
    72.151   685.926     0.150
    72.174   686.938     0.150
    72.264   688.035     0.150
    72.236   686.953     0.150
    72.473   687.836     0.150
    72.422   687.324     0.150
    72.586   688.035     0.150
    72.570   688.996     0.150
    72.658   688.715     0.150
    72.725   689.844     0.150
    72.745   690.207     0.150
    72.745   690.062     0.150
    72.770   690.105     0.150
    72.837   690.738     0.150
    72.877   690.605     0.150
    73.054   690.035     0.150
    73.096   690.113     0.150
    73.096   690.215     0.150
    73.220   691.633     0.150
    73.164   694.012     0.150
    73.164   693.414     0.150
    73.704   695.863     0.150
    73.870   696.605     0.150
    74.006   697.555     0.150
    74.025   697.504     0.150
    74.113   695.660     0.150
    74.169   698.535     0.150
    74.284   698.766     0.150
    74.394   700.336     0.150
    74.465   699.434     0.150
    74.500   699.734     0.150
    74.737   701.734     0.150
    74.858   701.391     0.150
    74.873   702.836     0.150
    74.952   701.047     0.150
    74.952   701.195     0.150
    74.952   702.164     0.150
    74.952   702.285     0.150
    74.968   703.016     0.150
    75.009   703.336     0.150
    75.214   702.836     0.150
    75.214   703.641     0.150
    75.544   704.984     0.150
    75.566   704.406     0.150
    75.610   705.633     0.150
    75.764   705.516     0.150
    75.880   706.336     0.150
    75.902   708.234     0.150
    75.922   707.273     0.150
    76.019   709.234     0.150
    76.106   709.605     0.150
    76.129   708.895     0.150
    76.298   710.035     0.150
    76.298   710.980     0.150
    76.446   711.746     0.150
    76.627   711.074     0.150
    76.719   713.133     0.150
    76.770   712.637     0.150
    76.989   713.379     0.150
    77.003   713.871     0.150
    77.044   714.547     0.150
    77.053   714.285     0.150
    77.044   714.770     0.150
    77.044   713.684     0.150
    77.190   715.414     0.150
    77.250   716.242     0.150
    77.310   715.637     0.150
    77.313   715.090     0.150
    77.313   715.426     0.150
    77.462   717.535     0.150
    77.514   717.238     0.150
    77.611   717.273     0.150
    77.631   718.801     0.150
    77.672   717.887     0.150
    77.693   716.734     0.150
    77.693   716.934     0.150
    77.700   717.109     0.150
    77.713   718.512     0.150
    77.755   716.664     0.150
    77.757   717.809     0.150
    77.759   718.742     0.150
    77.759   718.453     0.150
    77.861   718.402     0.150
    77.862   718.332     0.150
    77.872   719.406     0.150
    77.855   719.766     0.150
    77.904   718.734     0.150
    78.028   720.594     0.150
    78.031   720.734     0.150
    78.075   720.973     0.150
    78.218   720.473     0.150
    78.247   721.047     0.150
    78.300   721.324     0.150
    78.411   720.973     0.150
    78.418   721.828     0.150
    78.425   722.805     0.150
    78.457   723.312     0.150
    78.823   724.035     0.150
    78.823   724.754     0.150
    78.848   724.836     0.150
    78.849   725.016     0.150
    78.871   725.371     0.150
    78.919   725.266     0.150
    78.928   724.809     0.150
    78.936   724.805     0.150
    79.025   726.098     0.150
    79.014   725.996     0.150
    79.044   726.062     0.150
    79.055   723.625     0.150
    79.071   725.953     0.150
    79.080   726.383     0.150
    79.149   726.383     0.150
    79.180   727.434     0.150
    79.348   727.801     0.150
    79.434   727.781     0.150
    79.541   727.516     0.150
    79.591   728.312     0.150
    79.640   729.289     0.150
    79.651   728.930     0.150
    79.659   728.262     0.150
    79.854   729.734     0.150
    80.045   731.117     0.150
    80.182   731.551     0.150
    80.182   733.633     0.150
    80.240   732.266     0.150
    80.222   732.656     0.150
    80.278   732.180     0.150
    80.270   731.613     0.150
    80.332   731.781     0.150
    80.370   732.641     0.150
    80.370   732.445     0.150
    80.380   733.215     0.150
    80.384   733.352     0.150
    80.548   733.301     0.150
    80.590   733.453     0.150
    80.618   733.613     0.150
    80.645   734.379     0.150
    80.768   735.125     0.150
    80.768   734.473     0.150
    80.870   733.219     0.150
    80.970   736.797     0.150
    80.989   736.336     0.150
    80.989   736.137     0.150
    80.996   736.004     0.150
    81.024   736.465     0.150
    81.156   736.367     0.150
    81.215   737.055     0.150
    81.252   736.883     0.150
    81.255   737.254     0.150
    81.313   738.258     0.150
    81.642   738.910     0.150
    81.642   738.555     0.150
    81.648   740.480     0.150
    81.694   739.734     0.150
    81.753   739.789     0.150
    81.753   740.156     0.150
    81.747   739.160     0.150
    81.826   740.305     0.150
    81.886   740.059     0.150
    81.895   740.004     0.150
    81.916   739.621     0.150
    81.909   739.875     0.150
    81.920   741.578     0.150
    81.920   741.445     0.150
    82.006   742.086     0.150
    82.276   741.773     0.150
    82.392   743.195     0.150
    82.523   744.117     0.150
    82.541   743.418     0.150
    82.627   743.105     0.150
    82.700   744.254     0.150
    82.712   744.781     0.150
    83.018   746.016     0.150
    83.044   746.867     0.150
    83.050   746.742     0.150
    83.093   747.434     0.150
    83.093   747.172     0.150
    83.093   747.793     0.150
    83.136   747.551     0.150
    83.156   746.355     0.150
    83.293   747.613     0.150
    83.388   748.676     0.150
    83.433   747.395     0.150
    83.460   748.664     0.150
    83.483   747.293     0.150
    83.544   749.105     0.150
    83.712   749.160     0.150
    83.781   751.723     0.150
    83.802   749.195     0.150
    83.856   750.434     0.150
    83.856   749.984     0.150
    83.859   750.715     0.150
    83.943   749.996     0.150
    84.078   751.434     0.150
    84.503   754.465     0.150
    84.508   754.383     0.150
    84.508   754.523     0.150
    84.529   753.836     0.150
    84.529   754.094     0.150
    84.532   753.633     0.150
    84.548   754.004     0.150
    84.555   754.383     0.150
    84.569   754.285     0.150
    84.705   755.793     0.150
    84.786   754.695     0.150
    84.880   755.344     0.150
    84.923   757.375     0.150
    84.944   756.695     0.150
    85.070   756.797     0.150
    85.070   756.383     0.150
    85.186   756.602     0.150
    85.186   755.953     0.150
    85.397   758.535     0.150
    85.397   758.734     0.150
    85.462   758.805     0.150
    85.509   759.406     0.150
    85.784   758.812     0.150
    85.799   759.723     0.150
    86.112   762.277     0.150
    86.338   762.734     0.150
    86.338   763.070     0.150
    86.348   764.156     0.150
    86.439   763.652     0.150
    86.439   763.344     0.150
    86.452   762.855     0.150
    86.783   765.156     0.150
    86.884   765.414     0.150
    87.185   767.734     0.150
    87.185   767.125     0.150
    87.357   768.660     0.150
    89.163   777.445     0.150
    89.163   777.203     0.150
    89.176   777.035     0.150
    89.176   776.934     0.150
    91.021   785.086     0.150
    91.021   785.336     0.150
   136.614  1162.383     0.150
   137.298  1165.344     0.150
   145.038  1175.234     0.150
   149.584  1189.633     0.150
   149.863  1189.852     0.150
   151.314  1193.496     0.150
   152.048  1194.648     0.150
     0.118     2.262     0.150
     0.118     4.062     0.150
     0.118     4.762     0.150
     0.575    10.762     0.150
     0.575    18.961     0.150
     1.133    20.164     0.150
     1.133    38.363     0.150
     1.176    21.262     0.150
     1.176    38.062     0.150
     1.439    25.562     0.150
     1.439    45.762     0.150
     1.439    47.863     0.150
     1.439    26.664     0.150
     1.439    45.562     0.150
     1.888    34.461     0.150
     1.888    59.461     0.150
     1.888    58.664     0.150
     1.888    59.262     0.150
     1.770    31.762     0.150
     1.770    55.262     0.150
     2.382    74.562     0.150
     2.649    84.062     0.150
     3.236   101.164     0.150
     3.450   106.164     0.150
     4.033    70.762     0.150
     4.033   125.961     0.150
     3.915    61.562     0.150
     3.915    69.363     0.150
     3.915   121.664     0.150
     3.915    69.164     0.150
     3.915   105.961     0.150
     3.915   121.562     0.150
     4.048   126.461     0.150
     4.299    77.363     0.150
     4.299   133.664     0.150
     4.437   139.164     0.150
     5.217   161.562     0.150
     5.437    95.461     0.150
     5.437   168.961     0.150
     5.748   179.164     0.150
     5.830   181.664     0.150
     5.985   186.461     0.150
     6.343   115.961     0.150
     6.343   196.562     0.150
     6.217   193.164     0.150
     6.420   117.863     0.150
     6.420   201.363     0.150
     6.726   209.363     0.150
     6.748   207.164     0.150
     6.748   210.262     0.150
     7.405   137.961     0.150
     7.405   228.664     0.150
     7.405   134.664     0.150
     7.405   228.863     0.150
     7.852   242.461     0.150
     8.465   155.164     0.150
     8.465   262.762     0.150
     8.721   270.562     0.150
     8.876   273.461     0.150
     9.397   138.582     0.150
    10.952   335.562     0.150
    11.122   344.062     0.150
    11.122   158.961     0.150
    12.873   184.312     0.150
    15.836   231.262     0.150
    16.601   233.797     0.150
    16.673   235.938     0.150
    17.041   236.664     0.150
    16.911   236.664     0.150
    20.092   276.863     0.150
    20.916   284.641     0.150
    21.454   292.164     0.150
    21.548   292.195     0.150
    25.068   326.562     0.150
    25.320   328.512     0.150
    29.970   368.762     0.150
    29.970   666.863     0.150
    37.199   429.762     0.150
    38.644   442.887     0.150
    39.169   448.461     0.150
    42.523   475.758     0.150
    44.860   495.812     0.150
    45.241   499.062     0.150
    45.241   599.762     0.150
    46.535   507.688     0.150
    47.702   517.902     0.150
    48.396   523.164     0.150
    53.035   558.648     0.150
    54.631   569.961     0.150
    55.936   577.914     0.150
    56.159   580.812     0.150
    60.514   609.887     0.150
    71.026   679.262     0.150
    74.962   701.332     0.150
    76.027   709.414     0.150
    77.678   718.363     0.150
    77.685   715.812     0.150
    81.236   736.512     0.150
    91.032   784.008     0.150
   149.599  1189.238     0.150
     0.120     2.246     0.150
     0.120     4.848     0.150
     0.120     4.547     0.150
     0.591    10.945     0.150
     0.591    18.945     0.150
     0.591    19.848     0.150
     1.163    21.746     0.150
     1.163    37.145     0.150
     1.163    42.145     0.150
     1.141    20.848     0.150
     1.141    36.445     0.150
     1.141    36.547     0.150
     1.449    26.547     0.150
     1.449    45.645     0.150
     1.449    48.848     0.150
     1.755    31.945     0.150
     1.755    54.547     0.150
     1.755    31.348     0.150
     1.904    34.547     0.150
     1.904    59.547     0.150
     1.904    34.445     0.150
     1.904    35.547     0.150
     1.904    59.746     0.150
     2.392    41.246     0.150
     2.392    43.445     0.150
     2.392    45.145     0.150
     2.392    70.145     0.150
     2.392    75.047     0.150
     2.392    41.047     0.150
     2.392    44.348     0.150
     2.636    44.547     0.150
     2.636    48.746     0.150
     2.636    76.945     0.150
     2.636    82.547     0.150
     2.636    48.645     0.150
     2.636    82.746     0.150
     3.252    53.145     0.150
     3.252    59.645     0.150
     3.252    91.246     0.150
     3.252   101.547     0.150
     3.252    52.746     0.150
     3.252    57.348     0.150
     3.252   101.348     0.150
     3.438    54.645     0.150
     3.438    62.145     0.150
     3.438    95.547     0.150
     3.438   105.145     0.150
     3.912    61.645     0.150
     3.912    70.645     0.150
     3.912   106.945     0.150
     3.912   121.945     0.150
     3.912    71.145     0.150
     3.912   107.047     0.150
     3.912   121.547     0.150
     4.063    73.645     0.150
     4.063   110.547     0.150
     4.063   125.848     0.150
     4.063    62.547     0.150
     4.063    73.348     0.150
     4.063   107.445     0.150
     4.063   127.145     0.150
     4.049    64.145     0.150
     4.049    73.645     0.150
     4.049   109.746     0.150
     4.049   125.848     0.150
     4.314    68.645     0.150
     4.314    77.945     0.150
     4.314   115.848     0.150
     4.314   133.348     0.150
     4.314    66.945     0.150
     4.314    78.145     0.150
     4.426    69.145     0.150
     4.426    79.547     0.150
     4.426   118.645     0.150
     4.426   137.645     0.150
     5.232    80.246     0.150
     5.232   138.348     0.150
     5.232   162.246     0.150
     5.452    82.746     0.150
     5.452   144.547     0.150
     5.452   168.945     0.150
     5.763    87.047     0.150
     5.763   178.547     0.150
     5.808   180.047     0.150
     5.846    88.945     0.150
     5.846   181.047     0.150
     6.002    90.645     0.150
     6.002   157.945     0.150
     6.002   186.746     0.150
     6.207    93.246     0.150
     6.207   162.848     0.150
     6.207   192.746     0.150
     6.359    95.945     0.150
     6.359   196.645     0.150
     6.435   167.547     0.150
     6.435   199.848     0.150
     6.763   209.445     0.150
     7.420   191.547     0.150
     7.420   229.746     0.150
     7.420   227.645     0.150
     7.725   111.145     0.150
     7.866   241.645     0.150
     7.866   243.547     0.150
     8.121   119.945     0.150
     8.480   125.047     0.150
     8.480   153.848     0.150
     8.480   216.145     0.150
     8.480   263.047     0.150
     8.735   127.246     0.150
     8.735   157.547     0.150
     8.735   223.445     0.150
     8.735   269.848     0.150
     8.735   128.645     0.150
     8.735   224.445     0.150
     8.888   130.246     0.150
     8.888   227.246     0.150
     8.888   274.945     0.150
     8.888   129.945     0.150
     9.414   137.773     0.150
     9.414   170.746     0.150
     9.414   297.125     0.150
    10.127   144.445     0.150
    10.127   257.945     0.150
    10.963   338.645     0.150
    11.136   161.645     0.150
    11.136   200.348     0.150
    11.136   345.348     0.150
    12.360   381.945     0.150
    12.871   182.621     0.150
    12.871   403.996     0.150
    16.603   235.305     0.150
    16.603   523.223     0.150
    16.680   233.523     0.150
    16.895   236.445     0.150
    17.701   246.145     0.150
    20.498   279.395     0.150
    20.498   280.645     0.150
    21.463   290.348     0.150
    21.531   291.012     0.150
    21.557   291.234     0.150
    25.029   326.094     0.150
    42.519   475.684     0.150
    42.519   477.145     0.150
    44.455   492.945     0.150
    44.844   494.996     0.150
    44.844   496.246     0.150
    46.710   508.445     0.150
    55.919   578.070     0.150
    71.022   680.109     0.150
    76.010   709.605     0.150
    77.696   717.512     0.150
    80.980   735.191     0.150
    81.247   736.629     0.150
     0.110     1.820     0.150
     0.110     4.020     0.150
     1.134    20.719     0.150
     1.134    36.320     0.150
     1.134    41.020     0.150
     1.134    20.820     0.150
     1.164    21.020     0.150
     1.164    38.121     0.150
     1.164    41.320     0.150
     1.444    25.820     0.150
     1.444    27.621     0.150
     1.444    46.219     0.150
     1.444    48.922     0.150
     1.444    45.621     0.150
     1.744    31.121     0.150
     1.744    54.320     0.150
     1.744    30.820     0.150
     1.906    33.922     0.150
     1.906    35.320     0.150
     1.906    59.520     0.150
     1.906    60.719     0.150
     1.906    35.219     0.150
     1.906    58.422     0.150
     2.387    40.922     0.150
     2.387    43.422     0.150
     2.387    69.422     0.150
     2.387    74.621     0.150
     2.637    43.820     0.150
     2.637    48.121     0.150
     2.637    82.820     0.150
     2.637    43.520     0.150
     2.637    47.719     0.150
     2.637    82.121     0.150
     3.256    52.219     0.150
     3.256    59.320     0.150
     3.256    91.219     0.150
     3.256   100.922     0.150
     3.256    57.422     0.150
     3.256   100.820     0.150
     3.425    54.422     0.150
     3.425    61.719     0.150
     3.425    94.820     0.150
     3.425   104.922     0.150
     3.922    61.121     0.150
     3.922    71.422     0.150
     3.922   106.621     0.150
     3.922   122.422     0.150
     3.922    71.020     0.150
     3.922   106.520     0.150
     3.922   122.320     0.150
     4.053    73.621     0.150
     4.053   126.020     0.150
     4.074   127.621     0.150
     4.315    68.520     0.150
     4.315    77.922     0.150
     4.315   116.520     0.150
     4.315   133.520     0.150
     4.315    67.121     0.150
     4.315   132.219     0.150
     4.430    68.219     0.150
     4.430    79.020     0.150
     4.430   117.719     0.150
     4.430   136.820     0.150
     5.235   161.820     0.150
     5.454    82.820     0.150
     5.454   144.520     0.150
     5.454   168.719     0.150
     5.454    82.020     0.150
     5.454   141.422     0.150
     5.454   166.020     0.150
     5.767   179.020     0.150
     5.849   181.121     0.150
     6.006    90.121     0.150
     6.006   157.520     0.150
     6.006   187.121     0.150
     6.212    92.219     0.150
     6.212   191.621     0.150
     6.361   197.922     0.150
     6.446    94.719     0.150
     6.446   168.820     0.150
     6.446   200.422     0.150
     6.446    94.219     0.150
     6.446   199.121     0.150
     6.743   209.219     0.150
     7.866   244.020     0.150
     8.483   263.320     0.150
     8.734   127.121     0.150
     8.734   221.520     0.150
     8.734   269.719     0.150
     8.886   225.820     0.150
     8.886   275.621     0.150
    11.135   345.820     0.150
     0.106     2.637     0.150
     0.106     4.738     0.150
     0.567    10.738     0.150
     0.567    18.438     0.150
     1.116    20.836     0.150
     1.116    23.637     0.150
     1.116    35.637     0.150
     1.116    40.238     0.150
     1.195    22.238     0.150
     1.195    38.438     0.150
     1.195    42.539     0.150
     1.195    22.137     0.150
     1.195    38.539     0.150
     1.421    25.836     0.150
     1.421    44.738     0.150
     1.421    48.238     0.150
     1.778    32.238     0.150
     1.778    54.738     0.150
     1.778    31.738     0.150
     1.870    33.938     0.150
     1.870    59.137     0.150
     1.870    34.039     0.150
     1.870    35.137     0.150
     1.870    57.938     0.150
     2.364    40.637     0.150
     2.364    42.738     0.150
     2.364    68.039     0.150
     2.364    73.836     0.150
     2.667    44.836     0.150
     2.667    49.137     0.150
     2.667    76.938     0.150
     2.667    83.738     0.150
     2.667    44.539     0.150
     2.667    84.137     0.150
     3.219    52.438     0.150
     3.219    59.039     0.150
     3.219    90.738     0.150
     3.219   100.738     0.150
     3.219    52.238     0.150
     3.219    57.637     0.150
     3.453    55.137     0.150
     3.453    62.336     0.150
     3.453    94.738     0.150
     3.453   105.336     0.150
     3.929    61.938     0.150
     3.929    71.836     0.150
     3.929   107.137     0.150
     3.929   122.637     0.150
     4.016    63.238     0.150
     4.016    72.336     0.150
     4.016   109.137     0.150
     4.016   124.539     0.150
     4.041   110.539     0.150
     4.041   126.039     0.150
     4.280    67.637     0.150
     4.280    77.438     0.150
     4.280   133.039     0.150
     4.280    66.039     0.150
     4.280    77.039     0.150
     4.280   131.539     0.150
     4.456    80.137     0.150
     4.456   119.336     0.150
     4.456   138.137     0.150
     5.199   162.938     0.150
     5.419    83.238     0.150
     5.419   142.336     0.150
     5.419   166.039     0.150
     5.419   168.836     0.150
     5.419    81.438     0.150
     5.419   141.836     0.150
     5.419   165.738     0.150
     5.730   149.137     0.150
     5.730   177.938     0.150
     5.774   180.137     0.150
     5.813   152.238     0.150
     5.813   181.438     0.150
     5.969    89.938     0.150
     5.969   156.137     0.150
     5.969   185.836     0.150
     6.235    93.438     0.150
     6.235   193.738     0.150
     6.325   195.938     0.150
     6.411    94.938     0.150
     6.411   167.438     0.150
     6.411   199.336     0.150
     6.411    95.039     0.150
     6.411   197.238     0.150
     6.708   207.539     0.150
     6.730   208.137     0.150
     7.387   108.438     0.150
     7.387   229.336     0.150
     7.833   200.438     0.150
     7.833   241.539     0.150
     8.143   153.137     0.150
     8.447   262.137     0.150
     8.703   127.438     0.150
     8.703   157.637     0.150
     8.703   222.039     0.150
     8.703   269.137     0.150
     8.703   223.336     0.150
     8.857   130.039     0.150
     8.857   160.539     0.150
     8.857   225.336     0.150
     8.857   275.039     0.150
     9.383   137.219     0.150
     9.383   295.762     0.150
    10.160   313.449     0.150
    11.104   344.039     0.150
    12.886   182.453     0.150
    12.886   403.727     0.150
    17.705   244.480     0.150
    20.531   281.246     0.150
    44.876   496.625     0.150
     0.110     2.027     0.150
     0.110     4.125     0.150
     0.561    10.328     0.150
     0.561    18.625     0.150
     0.561    10.527     0.150
     1.198    21.527     0.150
     1.198    23.426     0.150
     1.198    25.227     0.150
     1.198    40.125     0.150
     1.420    25.426     0.150
     1.420    27.227     0.150
     1.420    47.727     0.150
     1.784    31.527     0.150
     1.866    33.527     0.150
     1.866    34.227     0.150
     1.866    59.027     0.150
     1.866    34.727     0.150
     1.866    58.027     0.150
     2.363    40.527     0.150
     2.363    42.527     0.150
     2.363    44.727     0.150
     2.363    73.625     0.150
     2.363    40.426     0.150
     2.363    74.625     0.150
     2.670    44.227     0.150
     2.670    48.926     0.150
     2.670    84.125     0.150
     3.214    51.727     0.150
     3.214    58.426     0.150
     3.214    99.926     0.150
     3.214    51.527     0.150
     3.214    59.328     0.150
     3.459    54.426     0.150
     3.459    62.227     0.150
     3.459   107.426     0.150
     3.927    61.328     0.150
     3.927    71.426     0.150
     3.927   123.727     0.150
     4.012    62.625     0.150
     4.012    72.527     0.150
     4.012   126.328     0.150
     4.035   126.125     0.150
     4.277    67.227     0.150
     4.277    77.727     0.150
     4.277   133.125     0.150
     4.457    79.328     0.150
     4.457   138.328     0.150
     5.415    82.828     0.150
     5.415   166.527     0.150
     5.415    81.727     0.150
     5.415   141.625     0.150
     5.415   168.328     0.150
     5.964    89.625     0.150
     5.964   186.328     0.150
     6.405    94.625     0.150
     6.405   199.828     0.150
     6.405    94.227     0.150
     7.383   228.227     0.150
     8.699   127.727     0.150
     9.377   137.219     0.150
     9.377   297.141     0.150
    10.165   143.828     0.150
    10.165   258.426     0.150
    12.884   183.984     0.150
    12.884   404.348     0.150
    16.655   234.793     0.150
    16.928   236.426     0.150
    17.709   247.590     0.150
    17.709   440.797     0.150
    17.709   245.426     0.150
    20.107   275.227     0.150
    20.535   279.766     0.150
    21.436   290.727     0.150
    21.499   290.148     0.150
    21.530   291.379     0.150
    25.008   325.082     0.150
    25.052   326.727     0.150
    48.394   521.602     0.150
    55.954   577.727     0.150
    56.152   581.293     0.150
    76.048   709.289     0.150
    77.680   717.215     0.150
    81.231   735.656     0.150
     0.104     2.352     0.150
     0.104     4.555     0.150
     0.590    11.352     0.150
     0.590    18.754     0.150
     1.125    40.453     0.150
     1.178    21.652     0.150
     1.178    37.652     0.150
     1.433    26.152     0.150
     1.433    44.754     0.150
     1.433    48.352     0.150
     1.756    31.152     0.150
     1.756    54.254     0.150
     1.756    56.652     0.150
     1.891    34.152     0.150
     1.891    59.254     0.150
     2.376    42.152     0.150
     2.376    43.453     0.150
     2.376    73.254     0.150
     2.651    44.152     0.150
     2.651    48.352     0.150
     2.651    82.953     0.150
     3.241    52.352     0.150
     3.241    59.555     0.150
     3.241    90.254     0.150
     3.241   100.852     0.150
     3.434    54.352     0.150
     3.434    61.555     0.150
     3.434    94.055     0.150
     3.434   105.055     0.150
     3.927    61.453     0.150
     3.927    71.055     0.150
     3.927   107.055     0.150
     3.927   121.953     0.150
     4.038    62.555     0.150
     4.038    73.152     0.150
     4.038   125.152     0.150
     4.063   126.055     0.150
     4.300    67.652     0.150
     4.300    77.152     0.150
     4.300   115.453     0.150
     4.300   133.754     0.150
     4.442    79.152     0.150
     4.442   118.754     0.150
     4.442   136.754     0.150
     5.220   162.652     0.150
     5.439    81.652     0.150
     5.439    97.254     0.150
     5.439   142.555     0.150
     5.439   167.652     0.150
     5.991    90.453     0.150
     5.991   108.254     0.150
     5.991   155.852     0.150
     5.991   186.852     0.150
     6.223    92.953     0.150
     6.223   111.754     0.150
     6.223   161.652     0.150
     6.223   191.852     0.150
     6.346   197.152     0.150
     6.434   117.055     0.150
     6.434   167.555     0.150
     6.434   200.453     0.150
     7.407   133.352     0.150
     7.407   188.953     0.150
     7.407   228.652     0.150
     7.852   141.152     0.150
     7.852   201.852     0.150
     7.852   243.152     0.150
     8.468   152.152     0.150
     8.468   216.652     0.150
     8.468   261.852     0.150
     8.721   128.254     0.150
     8.721   157.555     0.150
     8.721   220.852     0.150
     8.721   269.754     0.150
     8.873   128.852     0.150
     8.873   159.953     0.150
     8.873   224.852     0.150
     8.873   273.754     0.150
    10.947   337.453     0.150
     0.048     0.658     0.150
     0.048     2.758     0.150
     0.609    18.758     0.150
     0.609    19.459     0.150
     1.072    19.459     0.150
     1.072    35.158     0.150
     1.218    38.658     0.150
     1.385    26.559     0.150
     1.385    44.357     0.150
     1.385    44.158     0.150
     1.739    54.857     0.150
     1.865    33.158     0.150
     1.865    33.658     0.150
     1.865    59.258     0.150
     1.865    34.158     0.150
     1.865    58.059     0.150
     2.327    39.258     0.150
     2.327    41.758     0.150
     2.327    69.459     0.150
     2.327    73.857     0.150
     2.327    73.959     0.150
     3.403    59.959     0.150
     3.403   104.559     0.150
     3.223    51.258     0.150
     3.223    53.758     0.150
     3.223    58.459     0.150
     3.223    60.857     0.150
     3.223    90.357     0.150
     3.223   100.357     0.150
     3.223    57.459     0.150
     3.223   100.658     0.150
     3.984    62.758     0.150
     3.984   121.658     0.150
     3.984   125.959     0.150
     3.984   122.258     0.150
     4.015    63.357     0.150
     4.015    72.857     0.150
     4.015   108.959     0.150
     4.015   125.758     0.150
     4.084    62.258     0.150
     4.084    73.059     0.150
     4.084   125.959     0.150
     4.084   111.158     0.150
     4.084   126.258     0.150
     4.268    66.559     0.150
     4.268    77.357     0.150
     4.268   115.158     0.150
     4.268   133.059     0.150
     4.268    77.758     0.150
     4.268   132.857     0.150
     4.489   135.658     0.150
     5.195   162.158     0.150
     5.410    81.357     0.150
     5.410    83.357     0.150
     5.410   141.158     0.150
     5.410   166.959     0.150
     5.410    95.959     0.150
     5.410   166.758     0.150
     5.728    86.258     0.150
     5.728   151.158     0.150
     5.728   179.857     0.150
     5.772    88.357     0.150
     5.772   181.559     0.150
     5.970    89.459     0.150
     5.970   187.059     0.150
     6.449   200.158     0.150
     6.699   101.059     0.150
     6.699   208.459     0.150
     6.717   208.258     0.150
     6.717   100.857     0.150
     6.717   208.658     0.150
     7.375   108.953     0.150
     7.375   227.303     0.150
     7.375   108.459     0.150
     7.375   225.158     0.150
     7.375   108.158     0.150
     7.375   107.979     0.150
     7.817   115.857     0.150
     7.817   116.459     0.150
     8.192   118.758     0.150
     8.192   210.258     0.150
     8.441   151.258     0.150
     8.441   261.357     0.150
     8.684   126.459     0.150
     8.684   129.758     0.150
     8.684   221.158     0.150
     8.684   269.158     0.150
     8.684   126.059     0.150
     8.684   222.459     0.150
     8.831   128.357     0.150
     8.831   225.459     0.150
     8.831   273.857     0.150
     8.831   128.459     0.150
     9.185   135.758     0.150
     9.185   133.598     0.150
     9.398   135.959     0.150
     9.398   292.959     0.150
     9.398   136.857     0.150
    10.161   257.957     0.150
    10.161   254.559     0.150
    10.902   158.559     0.150
    10.902   336.959     0.150
    12.942   183.107     0.150
    12.942   401.908     0.150
    12.942   182.857     0.150
    14.437   203.559     0.150
    15.307   217.758     0.150
    15.319   218.658     0.150
    16.176   229.559     0.150
    16.610   233.748     0.150
    16.610   233.709     0.150
    16.610   234.758     0.150
    16.610   233.848     0.150
    16.670   234.559     0.150
    16.670   235.498     0.150
    16.670   233.887     0.150
    16.670   234.268     0.150
    17.013   239.258     0.150
    16.990   236.559     0.150
    17.968   257.857     0.150
    18.004   254.258     0.150
    18.004   459.158     0.150
    18.409   257.758     0.150
    18.409   469.559     0.150
    18.551   255.158     0.150
    18.551   461.357     0.150
    19.044   265.459     0.150
    19.044   478.158     0.150
    19.044   483.459     0.150
    19.670   271.299     0.150
    19.894   271.959     0.150
    19.894   271.498     0.150
    20.031   272.658     0.150
    20.159   274.658     0.150
    20.159   280.658     0.150
    20.159   497.258     0.150
    20.159   274.119     0.150
    20.572   280.059     0.150
    20.575   282.959     0.150
    20.575   302.959     0.150
    20.575   507.158     0.150
    20.575   281.658     0.150
    20.628   279.729     0.150
    20.628   511.947     0.150
    20.980   285.258     0.150
    20.980   283.658     0.150
    21.094   285.959     0.150
    21.395   287.959     0.150
    21.489   289.008     0.150
    21.470   288.158     0.150
    21.470   288.527     0.150
    21.470   290.533     0.150
    21.470   288.908     0.150
    21.633   291.658     0.150
    21.921   293.533     0.150
    22.296   298.459     0.150
    22.296   544.758     0.150
    23.564   308.947     0.150
    24.315   320.459     0.150
    24.709   323.318     0.150
    24.709   586.898     0.150
    25.002   324.059     0.150
    25.002   324.479     0.150
    25.079   326.658     0.150
    25.370   326.758     0.150
    25.370   327.059     0.150
    25.345   326.818     0.150
    25.585   603.857     0.150
    25.558   330.738     0.150
    25.929   334.357     0.150
    25.929   599.357     0.150
    25.929   332.408     0.150
    25.981   334.908     0.150
    25.980   334.848     0.150
    26.123   336.959     0.150
    26.123   608.959     0.150
    26.208   336.369     0.150
    26.649   340.979     0.150
    26.649   617.697     0.150
    26.632   340.848     0.150
    26.788   343.549     0.150
    27.008   345.088     0.150
    27.094   344.809     0.150
    27.603   351.768     0.150
    27.783   351.969     0.150
    27.976   354.719     0.150
    28.015   355.219     0.150
    28.135   356.658     0.150
    28.396   356.879     0.150
    28.396   358.768     0.150
    28.396   356.658     0.150
    28.396   355.799     0.150
    29.901   366.877     0.150
    29.901   366.158     0.150
    29.901   421.059     0.150
    29.901   664.459     0.150
    29.901   367.619     0.150
    29.974   371.289     0.150
    30.040   372.258     0.150
    30.040   771.559     0.150
    30.292   372.059     0.150
    30.292   372.559     0.150
    30.292   372.309     0.150
    31.188   381.619     0.150
    31.948   389.459     0.150
    31.948   700.158     0.150
    32.532   391.619     0.150
    34.231   409.459     0.150
    34.353   409.158     0.150
    34.795   413.459     0.150
    34.813   414.559     0.150
    34.953   416.158     0.150
    34.953   416.258     0.150
    35.624   419.559     0.150
    37.268   433.197     0.150
    37.268   432.184     0.150
    37.167   432.857     0.150
    37.117   431.959     0.150
    37.117   779.459     0.150
    37.675   437.098     0.150
    38.287   440.758     0.150
    38.580   443.934     0.150
    39.181   450.258     0.150
    39.181   451.158     0.150
    40.726   462.633     0.150
    40.726   462.059     0.150
    40.726   462.869     0.150
    41.130   462.857     0.150
    41.714   467.959     0.150
    41.822   470.709     0.150
    42.313   475.381     0.150
    42.416   473.959     0.150
    43.398   484.572     0.150
    43.607   485.678     0.150
    43.800   487.090     0.150
    43.800   487.709     0.150
    43.862   489.459     0.150
    43.958   487.309     0.150
    44.212   491.178     0.150
    44.289   491.729     0.150
    44.298   490.857     0.150
    44.353   491.648     0.150
    44.255   491.158     0.150
    44.468   493.898     0.150
    44.468   492.518     0.150
    44.474   493.070     0.150
    44.474   492.559     0.150
    44.478   492.559     0.150
    44.501   492.799     0.150
    44.633   494.389     0.150
    44.644   493.777     0.150
    44.808   495.184     0.150
    44.850   495.678     0.150
    44.866   495.139     0.150
    44.866   495.258     0.150
    45.038   498.158     0.150
    45.072   496.945     0.150
    45.151   497.746     0.150
    45.174   498.158     0.150
    45.174   898.959     0.150
    45.174   497.568     0.150
    45.419   501.178     0.150
    45.562   502.398     0.150
    45.768   502.027     0.150
    46.081   504.559     0.150
    46.177   505.316     0.150
    46.213   504.568     0.150
    46.236   506.018     0.150
    46.346   507.523     0.150
    46.445   509.979     0.150
    46.501   507.959     0.150
    46.587   508.918     0.150
    46.736   510.178     0.150
    46.639   510.658     0.150
    46.639   510.328     0.150
    46.819   512.695     0.150
    46.819   511.809     0.150
    46.943   512.020     0.150
    46.943   512.348     0.150
    46.998   512.354     0.150
    46.827   513.158     0.150
    47.124   513.049     0.150
    47.019   921.258     0.150
    47.019  1127.357     0.150
    47.264   514.648     0.150
    47.316   515.299     0.150
    47.624   516.748     0.150
    47.691   516.809     0.150
    47.712   517.152     0.150
    47.632   516.357     0.150
    47.632   517.158     0.150
    48.010   521.078     0.150
    48.117   517.908     0.150
    48.117   518.459     0.150
    48.810   526.988     0.150
    48.921   529.098     0.150
    49.120   528.719     0.150
    49.301   530.578     0.150
    50.167   534.959     0.150
    50.711   541.709     0.150
    50.920   543.697     0.150
    51.441   547.459     0.150
    52.134   552.459     0.150
    53.608   561.947     0.150
    53.699   562.256     0.150
    53.699   563.158     0.150
    53.771   564.559     0.150
    53.822   565.559     0.150
    53.822     4.301     0.150
    53.826     5.000     0.150
    53.848     4.100     0.150
    54.464   568.959     0.150
    54.480   569.488     0.150
    54.562  1027.158     0.150
    54.824   572.115     0.150
    54.996   570.959     0.150
    54.996   573.639     0.150
    54.973   571.359     0.150
    55.118   575.059     0.150
    55.930   578.258     0.150
    55.930   577.959     0.150
    55.930     4.398     0.150
    56.467   585.758     0.150
    57.623   591.838     0.150
    58.199   598.213     0.150
    58.363   597.293     0.150
    58.650   599.459     0.150
    58.776   599.016     0.150
    58.940   599.379     0.150
    63.363   630.357     0.150
    65.773   645.658     0.150
    67.708   658.443     0.150
    67.708   658.758     0.150
    67.708   659.373     0.150
    67.752   660.139     0.150
    67.976   660.848     0.150
    69.041   667.107     0.150
    69.702   671.107     0.150
    69.967   672.729     0.150
    70.671   677.559     0.150
    70.700   676.959     0.150
    71.118   679.791     0.150
    71.118   679.408     0.150
    71.221   679.107     0.150
    71.221   679.959     0.150
    71.694   683.479     0.150
    72.102   686.197     0.150
    72.266   687.848     0.150
    72.435   688.197     0.150
    72.525   689.408     0.150
    72.579   688.857     0.150
    72.666   687.789     0.150
    72.756   690.348     0.150
    72.757   691.061     0.150
    72.757   690.248     0.150
    72.778   690.229     0.150
    73.069   691.959     0.150
    73.093   690.508     0.150
    73.173   693.102     0.150
    73.173   693.668     0.150
    73.219   693.527     0.150
    73.422   693.908     0.150
    73.713   695.758     0.150
    73.879   696.869     0.150
    73.880   697.357     0.150
    73.971   699.309     0.150
    74.023   698.289     0.150
    74.034   697.777     0.150
    74.097   698.092     0.150
    74.517   701.139     0.150
    74.884   703.658     0.150
    74.961   701.412     0.150
    74.961   703.309     0.150
    74.961   702.197     0.150
    74.961   701.357     0.150
    74.961   702.209     0.150
    74.985   702.918     0.150
    75.022   704.158     0.150
    75.219   704.658     0.150
    75.219   702.695     0.150
    75.362   703.668     0.150
    75.418   705.938     0.150
    75.505   705.309     0.150
    75.629   707.357     0.150
    75.781   708.039     0.150
    75.876   707.928     0.150
    76.086   709.508     0.150
    76.129   708.934     0.150
    76.122   711.518     0.150
    76.194   710.107     0.150
    76.310   710.959     0.150
    76.310   711.512     0.150
    76.370   711.789     0.150
    76.464   712.348     0.150
    76.554   714.172     0.150
    76.623   710.447     0.150
    76.735   712.758     0.150
    76.751   712.830     0.150
    76.763   713.748     0.150
    76.973   714.508     0.150
    77.023   715.766     0.150
    77.030   714.959     0.150
    77.035   715.488     0.150
    77.058   715.127     0.150
    77.058   715.777     0.150
    77.169   714.299     0.150
    77.169   716.248     0.150
    77.228   716.170     0.150
    77.290   716.475     0.150
    77.312   714.914     0.150
    77.312   714.379     0.150
    77.473   716.916     0.150
    77.475   716.498     0.150
    77.498   718.049     0.150
    77.621   719.248     0.150
    77.637   719.197     0.150
    77.768   719.385     0.150
    77.580   717.908     0.150
    77.817   719.383     0.150
    77.839   720.273     0.150
    77.839   720.408     0.150
    77.847   719.445     0.150
    77.850   720.334     0.150
    77.868   719.898     0.150
    77.905   719.369     0.150
    77.733   718.658     0.150
    77.733   719.059     0.150
    77.740   718.334     0.150
    77.740   718.658     0.150
    77.762   718.748     0.150
    77.795   719.379     0.150
    78.040   720.768     0.150
    78.043   720.758     0.150
    78.090   721.418     0.150
    78.198   720.812     0.150
    78.227   722.598     0.150
    78.280   722.078     0.150
    78.281   722.309     0.150
    78.299   721.938     0.150
    78.301   723.609     0.150
    78.397   723.000     0.150
    78.442   723.812     0.150
    78.470   724.049     0.150
    78.529   724.668     0.150
    78.580   724.258     0.150
    78.708   723.277     0.150
    78.832   723.578     0.150
    78.842   723.908     0.150
    78.864   725.068     0.150
    78.889   726.000     0.150
    78.900   726.691     0.150
    78.911   726.041     0.150
    78.919   724.748     0.150
    79.003   727.209     0.150
    79.023   726.938     0.150
    79.018   727.477     0.150
    79.057   725.928     0.150
    79.081   726.309     0.150
    79.089   726.768     0.150
    79.159   726.188     0.150
    79.176   726.848     0.150
    79.198   726.498     0.150
    79.193   727.258     0.150
    79.205   727.398     0.150
    79.213   727.969     0.150
    79.264   727.168     0.150
    79.273   727.828     0.150
    79.277   728.119     0.150
    79.312   727.363     0.150
    79.309   728.061     0.150
    79.321   728.357     0.150
    79.351   728.527     0.150
    79.365   727.959     0.150
    79.365   729.082     0.150
    79.407   729.648     0.150
    79.516   728.328     0.150
    79.573   730.225     0.150
    79.620   730.326     0.150
    79.620   730.629     0.150
    79.632   730.594     0.150
    79.641   729.252     0.150
    79.799   731.748     0.150
    79.872   730.857     0.150
    79.958   731.998     0.150
    79.970   730.107     0.150
    80.006   731.795     0.150
    80.162   731.008     0.150
    80.162   731.578     0.150
    80.221   732.994     0.150
    80.260   732.406     0.150
    80.269   732.248     0.150
    80.390   734.420     0.150
    80.390   733.479     0.150
    80.392   734.406     0.150
    80.392   733.758     0.150
    80.572   733.820     0.150
    80.572   734.328     0.150
    80.776   736.623     0.150
    80.776   736.229     0.150
    80.823   736.369     0.150
    80.852   736.029     0.150
    80.942   736.941     0.150
    80.986   737.018     0.150
    81.006   736.158     0.150
    81.006   737.281     0.150
    81.006   736.947     0.150
    81.013   737.121     0.150
    81.037   738.188     0.150
    81.037   737.629     0.150
    81.137   737.027     0.150
    81.238   738.865     0.150
    81.291   738.107     0.150
    81.666   740.484     0.150
    81.737   741.082     0.150
    81.747   740.543     0.150
    81.747   740.777     0.150
    81.809   739.195     0.150
    81.871   741.262     0.150
    81.892   741.039     0.150
    81.900   741.309     0.150
    81.911   741.559     0.150
    81.998   742.723     0.150
    82.079   742.746     0.150
    82.098   743.758     0.150
    82.098   743.373     0.150
    82.114   742.359     0.150
    82.273   743.438     0.150
    82.275   743.443     0.150
    82.294   743.625     0.150
    82.294   742.729     0.150
    82.404   743.299     0.150
    82.404   743.619     0.150
    82.429   744.305     0.150
    82.508   745.426     0.150
    82.508   744.107     0.150
    82.525   745.201     0.150
    82.623   745.240     0.150
    82.623   745.119     0.150
    82.695   745.969     0.150
    82.827   746.715     0.150
    83.028   748.139     0.150
    83.035   747.812     0.150
    83.051   748.086     0.150
    83.057   748.156     0.150
    83.103   747.559     0.150
    83.103   749.166     0.150
    83.119   748.766     0.150
    83.142   748.328     0.150
    83.142   747.678     0.150
    83.198   747.539     0.150
    83.287   749.191     0.150
    83.295   748.357     0.150
    83.346   749.027     0.150
    83.371   749.139     0.150
    83.426   748.197     0.150
    83.430   748.768     0.150
    83.441   749.008     0.150
    83.447   749.842     0.150
    83.447   750.158     0.150
    83.468   749.203     0.150
    83.468   749.508     0.150
    83.600   749.490     0.150
    83.701   749.318     0.150
    83.791   751.607     0.150
    83.801   749.379     0.150
    83.799   751.846     0.150
    83.853   751.258     0.150
    83.860   751.398     0.150
    83.911   751.789     0.150
    83.932   750.129     0.150
    84.137   753.254     0.150
    84.137   752.379     0.150
    84.150   752.039     0.150
    84.179   753.922     0.150
    84.330   753.646     0.150
    84.491   754.998     0.150
    84.514   756.350     0.150
    84.514   755.828     0.150
    84.522   754.658     0.150
    84.522   754.303     0.150
    84.537   754.723     0.150
    84.550   754.098     0.150
    84.564   754.309     0.150
    84.605   754.566     0.150
    84.625   755.408     0.150
    84.707   756.389     0.150
    84.712   756.277     0.150
    84.876   756.879     0.150
    84.934   758.654     0.150
    84.946   756.768     0.150
    84.986   756.912     0.150
    85.008   757.889     0.150
    85.032   756.959     0.150
    85.184   758.139     0.150
    85.240   758.107     0.150
    85.244   758.309     0.150
    85.326   758.738     0.150
    85.400   759.559     0.150
    85.400   760.578     0.150
    85.405   760.113     0.150
    85.464   759.229     0.150
    85.479   760.168     0.150
    85.522   760.979     0.150
    85.607   760.568     0.150
    85.782   760.379     0.150
    85.796   761.068     0.150
    85.794   762.023     0.150
    85.896   762.686     0.150
    85.918   763.189     0.150
    86.357   763.777     0.150
    86.111   763.057     0.150
    86.455   764.295     0.150
    86.281   763.588     0.150
    86.332   763.258     0.150
    86.348   765.328     0.150
    86.450   764.619     0.150
    86.449   763.973     0.150
    86.449   766.107     0.150
    86.610   766.518     0.150
    86.524   765.059     0.150
    86.709   766.525     0.150
    86.709   766.768     0.150
    86.744   765.826     0.150
    86.807   766.289     0.150
    86.810   766.068     0.150
    86.877   766.508     0.150
    86.994   767.477     0.150
    86.994   768.059     0.150
    87.189   768.918     0.150
    87.189   768.338     0.150
    87.289   769.990     0.150
    87.534   769.383     0.150
    87.666   771.283     0.150
    88.371   773.199     0.150
    89.152   776.639     0.150
    89.172   776.334     0.150
    89.226   778.639     0.150
    90.962   783.959     0.150
    92.631   792.277     0.150
   149.547  1190.684     0.150
   149.547  1191.508     0.150
     0.277     6.227     0.150
     0.277    10.531     0.150
     0.277    10.031     0.150
     0.557    10.828     0.150
     0.557    10.633     0.150
     0.557    18.633     0.150
     0.788    14.828     0.150
     0.788    25.633     0.150
     0.788    14.727     0.150
     0.788    25.430     0.150
     0.977    17.828     0.150
     0.977    30.633     0.150
     0.977    34.828     0.150
     1.273    23.227     0.150
     1.273    40.633     0.150
     1.498    27.227     0.150
     1.498    47.930     0.150
     1.498    27.328     0.150
     1.498    47.430     0.150
     2.074    34.430     0.150
     2.074    37.328     0.150
     2.074    62.930     0.150
     2.074    34.531     0.150
     2.074    37.227     0.150
     2.074    60.133     0.150
     2.032    35.531     0.150
     2.032    62.531     0.150
     2.032    33.930     0.150
     2.032    36.227     0.150
     2.032    63.328     0.150
     2.670    43.227     0.150
     2.670    46.633     0.150
     2.670    82.633     0.150
     2.670    42.930     0.150
     2.670    47.227     0.150
     2.670    76.328     0.150
     2.670    82.430     0.150
     3.446    52.133     0.150
     3.446    61.430     0.150
     3.446    93.133     0.150
     3.446   106.828     0.150
     3.502    54.328     0.150
     3.502   107.633     0.150
     3.502    93.930     0.150
     3.502   108.930     0.150
     3.396    53.133     0.150
     3.396    60.531     0.150
     3.396    91.531     0.150
     3.396   104.727     0.150
     3.552   110.828     0.150
     4.039    61.727     0.150
     4.039   125.031     0.150
     4.080    61.328     0.150
     4.080   126.633     0.150
     4.080    61.727     0.150
     4.080    72.930     0.150
     4.080   107.328     0.150
     4.080   126.328     0.150
     4.428    67.430     0.150
     4.428   136.930     0.150
     4.541    68.828     0.150
     4.541   118.828     0.150
     4.541   141.227     0.150
     4.734    70.328     0.150
     4.734    83.828     0.150
     4.734   122.633     0.150
     4.734   146.531     0.150
     4.734    70.430     0.150
     4.734   122.531     0.150
     4.734   145.828     0.150
     4.708    70.930     0.150
     4.708    83.328     0.150
     4.708   123.328     0.150
     4.708   142.133     0.150
     4.708    71.133     0.150
     4.708   123.031     0.150
     4.708   144.633     0.150
     4.930    74.430     0.150
     4.930   128.328     0.150
     4.930   152.633     0.150
     5.316    78.727     0.150
     5.316   138.031     0.150
     5.316   163.328     0.150
     5.128    77.031     0.150
     5.128   159.227     0.150
     5.625    83.133     0.150
     5.625   173.727     0.150
     5.981    86.633     0.150
     5.981   183.227     0.150
     5.981    87.430     0.150
     5.981   183.727     0.150
     5.997    87.930     0.150
     5.997   153.633     0.150
     5.997   184.328     0.150
     6.225    90.828     0.150
     6.225   158.227     0.150
     6.225   192.430     0.150
     6.319    91.828     0.150
     6.319   194.031     0.150
     6.650   203.227     0.150
     6.650    96.430     0.150
     6.650   169.227     0.150
     7.109   103.133     0.150
     7.109   219.930     0.150
     7.101   103.227     0.150
     7.101   220.227     0.150
     7.057   101.828     0.150
     7.057   101.727     0.150
     7.057   180.031     0.150
     7.759   112.633     0.150
     7.759   113.031     0.150
     7.910   114.930     0.150
     7.910   200.031     0.150
     7.910   115.430     0.150
     7.910   200.328     0.150
     7.910   244.930     0.150
     8.024   116.430     0.150
     8.024   203.633     0.150
     8.024   116.531     0.150
     8.024   201.828     0.150
     8.024   248.930     0.150
     8.172   115.430     0.150
     8.172   115.297     0.150
     8.745   127.328     0.150
     8.745   126.320     0.150
     8.990   129.328     0.150
     8.990   225.930     0.150
     8.927   129.188     0.150
     8.927   280.250     0.150
    10.835   151.547     0.150
    10.835   267.945     0.150
    10.835   330.125     0.150
    10.835   151.133     0.150
    10.835   271.727     0.150
    11.305   161.227     0.150
    12.153   171.328     0.150
    13.667   191.656     0.150
    13.667   428.656     0.150
    13.667   192.828     0.150
    14.045   195.727     0.150
    15.178   220.727     0.150
    15.352   220.930     0.150
    15.481   217.031     0.150
    15.795   218.406     0.150
    15.795   220.180     0.150
    15.795   493.930     0.150
    15.795   219.711     0.150
    15.880   224.656     0.150
    16.166   226.633     0.150
    16.220   227.227     0.150
    17.284   241.727     0.150
    17.284   540.258     0.150
    18.522   256.430     0.150
    18.785   475.328     0.150
    18.697   477.328     0.150
    18.697   529.031     0.150
    18.850   257.633     0.150
    19.801   267.727     0.150
    19.800   271.328     0.150
    19.800   277.828     0.150
    19.800   495.930     0.150
    20.675   279.133     0.150
    20.675   276.859     0.150
    20.570   277.227     0.150
    20.570   275.453     0.150
    20.664   278.727     0.150
    20.664   646.883     0.150
    20.647   277.328     0.150
    20.647   278.430     0.150
    20.647   277.742     0.150
    20.718   281.227     0.150
    20.718   516.930     0.150
    20.940   287.227     0.150
    21.262   286.328     0.150
    21.262   661.977     0.150
    21.262   285.531     0.150
    21.379   286.328     0.150
    21.379   287.883     0.150
    21.379   676.461     0.150
    22.085   294.328     0.150
    23.058   304.031     0.150
    23.885   311.227     0.150
    24.165   314.641     0.150
    24.209   315.031     0.150
    24.209   314.750     0.150
    24.260   314.227     0.150
    24.253   314.391     0.150
    24.407   319.727     0.150
    24.740   319.633     0.150
    24.774   320.031     0.150
    25.075   322.430     0.150
    25.165   323.531     0.150
    25.732   328.328     0.150
    25.828   329.227     0.150
    25.783   330.727     0.150
    25.783   602.727     0.150
    25.797   330.109     0.150
    25.968   330.828     0.150
    26.194   333.328     0.150
    26.194   331.531     0.150
    26.194   333.758     0.150
    26.194   331.578     0.150
    26.265   332.727     0.150
    26.404   335.789     0.150
    26.752   340.828     0.150
    26.752   610.633     0.150
    26.780   340.578     0.150
    27.134   341.633     0.150
    27.134   381.828     0.150
    27.134   339.508     0.150
    26.958   341.531     0.150
    26.958   339.336     0.150
    27.151   343.367     0.150
    27.151   343.531     0.150
    27.190   343.523     0.150
    27.312   344.781     0.150
    27.312   345.328     0.150
    27.572   347.320     0.150
    27.572   345.609     0.150
    27.838   351.828     0.150
    27.967   349.531     0.150
    27.949   350.789     0.150
    27.949   351.031     0.150
    29.180   359.523     0.150
    29.180   359.227     0.150
    29.180   409.930     0.150
    29.180   546.930     0.150
    29.180   653.633     0.150
    29.180   736.727     0.150
    29.180   358.156     0.150
    29.146   358.633     0.150
    29.463   362.133     0.150
    29.886   368.031     0.150
    29.795   664.930     0.150
    30.359   369.930     0.150
    31.322   378.633     0.150
    31.737   381.578     0.150
    31.737   381.781     0.150
    32.375   387.672     0.150
    32.913   392.031     0.150
    32.830   392.758     0.150
    33.253   395.031     0.150
    33.517   395.930     0.150
    33.517   468.531     0.150
    33.609   400.430     0.150
    33.810   402.727     0.150
    33.806   400.930     0.150
    33.911   403.727     0.150
    34.156   405.727     0.150
    34.171   405.328     0.150
    34.227   406.133     0.150
    34.284   406.633     0.150
    34.299   406.133     0.150
    34.299   406.727     0.150
    34.386   407.828     0.150
    34.389   406.727     0.150
    34.830   409.430     0.150
    34.827   411.227     0.150
    34.860   411.727     0.150
    35.728   415.133     0.150
    36.354   421.133     0.150
    36.538   421.531     0.150
    36.538   421.633     0.150
    36.769   426.375     0.150
    36.701   425.031     0.150
    36.962   428.031     0.150
    36.962   778.031     0.150
    37.503   431.273     0.150
    37.503   433.430     0.150
    37.614   431.133     0.150
    38.184   436.930     0.150
    38.184   571.930     0.150
    38.184   436.727     0.150
    38.454   440.133     0.150
    38.758   442.727     0.150
    38.915   445.219     0.150
    38.801   443.164     0.150
    38.801   575.180     0.150
    38.801   443.727     0.150
    39.952   450.633     0.150
    39.914   455.430     0.150
    39.914   812.930     0.150
    39.898   453.227     0.150
    39.898   451.852     0.150
    39.898   451.992     0.150
    40.097   453.727     0.150
    40.166   454.641     0.150
    40.413   455.430     0.150
    40.760   458.031     0.150
    40.760   551.531     0.150
    41.023   460.227     0.150
    40.973   462.719     0.150
    41.710   465.930     0.150
    41.794   467.031     0.150
    41.926   468.633     0.150
    41.926   467.242     0.150
    41.980   470.508     0.150
    42.243   470.406     0.150
    42.243   471.672     0.150
    42.393   471.227     0.150
    42.855   476.906     0.150
    42.899   477.398     0.150
    43.282   481.250     0.150
    43.020   479.086     0.150
    43.319   481.062     0.150
    43.333   479.227     0.150
    43.333   480.898     0.150
    43.457   482.062     0.150
    43.488   482.828     0.150
    43.788   484.906     0.150
    43.897   481.930     0.150
    43.897   482.383     0.150
    43.895   484.422     0.150
    43.895   485.602     0.150
    43.970   486.188     0.150
    44.109   487.633     0.150
    44.210   488.531     0.150
    44.365   486.773     0.150
    44.365   489.438     0.150
    44.433   489.477     0.150
    44.446   489.570     0.150
    44.476   487.383     0.150
    44.421   489.242     0.150
    44.471   488.492     0.150
    44.471   490.344     0.150
    44.401   490.211     0.150
    44.401   488.312     0.150
    44.436   490.258     0.150
    44.436   592.656     0.150
    44.436   489.828     0.150
    44.513   488.430     0.150
    44.560   491.727     0.150
    44.861   489.781     0.150
    44.850   492.633     0.150
    44.891   493.133     0.150
    45.040   494.227     0.150
    45.090   495.656     0.150
    44.892   493.367     0.150
    45.219   493.828     0.150
    45.219   893.633     0.150
    45.219  1097.188     0.150
    45.215   495.852     0.150
    45.084   495.492     0.150
    45.388   497.609     0.150
    45.395   495.781     0.150
    45.395   497.789     0.150
    45.426   497.328     0.150
    45.426   596.133     0.150
    45.425   497.320     0.150
    45.449   495.570     0.150
    45.636   498.703     0.150
    45.667   498.289     0.150
    45.842   502.328     0.150
    45.842   499.938     0.150
    45.924   501.461     0.150
    46.223   502.648     0.150
    46.349   504.609     0.150
    46.394   502.281     0.150
    46.394   502.570     0.150
    46.255   503.328     0.150
    46.255   609.430     0.150
    46.255   910.828     0.150
    46.255  1113.031     0.150
    46.116   504.172     0.150
    46.156   504.039     0.150
    46.543   506.008     0.150
    46.431   504.633     0.150
    46.397   505.406     0.150
    46.691   506.656     0.150
    46.776   506.414     0.150
    46.627   507.531     0.150
    46.992   509.242     0.150
    46.967   508.578     0.150
    46.967   507.938     0.150
    46.967   508.531     0.150
    46.967   507.938     0.150
    46.979   506.930     0.150
    47.272   512.078     0.150
    47.006   510.570     0.150
    47.204   511.250     0.150
    47.638   513.453     0.150
    47.688   512.562     0.150
    47.833   514.109     0.150
    47.868   515.328     0.150
    47.868   515.633     0.150
    47.872   515.703     0.150
    47.908   517.352     0.150
    47.954   515.203     0.150
    47.760   516.297     0.150
    48.237   519.758     0.150
    48.248   517.938     0.150
    48.297   520.492     0.150
    48.320   519.734     0.150
    48.339   517.633     0.150
    48.485   519.578     0.150
    48.459   520.219     0.150
    48.710   521.242     0.150
    48.710   523.461     0.150
    48.980   524.633     0.150
    49.092   525.180     0.150
    48.908   524.773     0.150
    49.307   526.633     0.150
    49.406   527.828     0.150
    49.406   526.539     0.150
    49.620   527.930     0.150
    49.697   528.258     0.150
    49.687   529.617     0.150
    49.961   531.672     0.150
    50.097   531.227     0.150
    50.097   532.930     0.150
    50.045   533.328     0.150
    50.578   537.531     0.150
    50.668   538.062     0.150
    50.799   537.328     0.150
    50.794   539.375     0.150
    50.814   539.156     0.150
    50.773   538.258     0.150
    50.977   539.047     0.150
    50.989   540.234     0.150
    50.989   539.547     0.150
    51.048   540.836     0.150
    51.239   540.438     0.150
    51.239   542.461     0.150
    50.938   541.289     0.150
    51.539   544.523     0.150
    51.639   545.188     0.150
    51.748   546.430     0.150
    51.867   546.852     0.150
    51.779   547.688     0.150
    51.784   547.211     0.150
    51.784   547.430     0.150
    51.894   547.133     0.150
    51.923   547.797     0.150
    52.054   549.383     0.150
    52.112   549.875     0.150
    52.112   548.031     0.150
    52.206   550.031     0.150
    52.206   548.711     0.150
    52.206   550.281     0.150
    52.206   548.922     0.150
    52.597   553.328     0.150
    52.597   553.227     0.150
    52.650   553.828     0.150
    52.785   553.859     0.150
    52.853   555.672     0.150
    53.087   556.188     0.150
    53.087   554.727     0.150
    53.087   555.930     0.150
    53.175   556.633     0.150
    53.254   557.328     0.150
    53.217   557.227     0.150
    53.226   557.633     0.150
    53.252   557.328     0.150
    53.328   557.812     0.150
    53.411   559.133     0.150
    53.687   561.430     0.150
    53.751   560.727     0.150
    53.854   561.062     0.150
    53.854   561.727     0.150
    53.899   561.758     0.150
    53.990   561.727     0.150
    53.990     9.203     0.150
    54.047   563.930     0.150
    54.122   563.828     0.150
    54.156   563.906     0.150
    54.280   564.828     0.150
    54.297   565.234     0.150
    54.477   567.039     0.150
    55.018   570.328     0.150
    55.150   570.742     0.150
    55.192   572.375     0.150
    55.239   571.531     0.150
    55.335   571.133     0.150
    55.335   572.828     0.150
    55.335     8.305     0.150
    55.335   570.773     0.150
    55.365   571.477     0.150
    55.171   572.148     0.150
    55.492   573.555     0.150
    55.492   572.641     0.150
    55.567   573.250     0.150
    55.567   572.930     0.150
    55.846   577.078     0.150
    55.855   574.508     0.150
    55.951   576.969     0.150
    55.976   577.570     0.150
    55.800   575.828     0.150
    56.345   577.805     0.150
    56.345   577.219     0.150
    56.496   581.078     0.150
    56.238   579.453     0.150
    56.762   580.172     0.150
    56.845   584.070     0.150
    56.968   585.148     0.150
    57.198   584.633     0.150
    57.169   586.164     0.150
    57.227   584.328     0.150
    57.372   586.188     0.150
    57.567   588.758     0.150
    57.593   588.828     0.150
    57.595   589.188     0.150
    57.770   590.398     0.150
    57.818   590.742     0.150
    57.871   588.906     0.150
    57.821   589.930     0.150
    58.182   593.531     0.150
    58.512   593.930     0.150
    59.214   599.117     0.150
    59.511   603.633     0.150
    60.533   608.031     0.150
    60.636   608.312     0.150
    63.664   628.031     0.150
    64.685   634.820     0.150
    66.153   644.828     0.150
    66.648   650.148     0.150
    69.131   663.859     0.150
    69.516   666.406     0.150
    69.516   666.078     0.150
    70.332   673.320     0.150
    70.436   673.609     0.150
    70.415   672.727     0.150
    70.949   675.812     0.150
    71.026   676.469     0.150
    71.026   678.039     0.150
    71.218   677.430     0.150
    71.294   679.953     0.150
    71.421   679.281     0.150
    71.853   681.859     0.150
    71.853   682.469     0.150
    72.204   683.789     0.150
    72.270   683.828     0.150
    72.378   685.273     0.150
    72.401   685.688     0.150
    72.836   687.859     0.150
    72.936   688.227     0.150
    72.978   688.617     0.150
    73.289   690.188     0.150
    73.289   691.195     0.150
    73.671   694.953     0.150
    74.484   696.133     0.150
    74.618   697.836     0.150
    74.750   697.219     0.150
    74.691   697.977     0.150
    75.201   701.727     0.150
    75.459   701.812     0.150
    75.459   702.727     0.150
    75.459   701.969     0.150
    75.574   703.930     0.150
    75.664   704.633     0.150
    76.222   705.609     0.150
    76.232   706.727     0.150
    76.622   710.453     0.150
    76.622   710.031     0.150
    76.672   710.023     0.150
    76.846   711.227     0.150
    76.846   711.758     0.150
    77.294   713.641     0.150
    77.625   715.562     0.150
    77.625   715.789     0.150
    77.691   714.531     0.150
    77.790   715.320     0.150
    78.234   720.078     0.150
    78.267   719.328     0.150
    77.950   716.031     0.150
    77.950   716.328     0.150
    77.952   716.180     0.150
    78.481   720.539     0.150
    78.663   721.266     0.150
    78.885   723.016     0.150
    79.033   723.820     0.150
    79.036   722.656     0.150
    79.308   724.430     0.150
    79.308   725.227     0.150
    79.484   726.203     0.150
    79.658   726.102     0.150
    79.722   726.578     0.150
    79.910   728.438     0.150
    79.955   728.828     0.150
    79.803   726.852     0.150
    80.142   729.781     0.150
    80.453   730.320     0.150
    80.546   732.086     0.150
    80.822   733.188     0.150
    80.890   732.977     0.150
    80.890   733.609     0.150
    81.142   734.922     0.150
    81.261   734.922     0.150
    81.261   735.742     0.150
    81.101   733.680     0.150
    81.413   736.250     0.150
    81.582   736.938     0.150
    81.582   738.039     0.150
    81.601   735.930     0.150
    81.601   736.867     0.150
    81.484   735.477     0.150
    81.484   735.336     0.150
    82.128   738.812     0.150
    82.128   739.430     0.150
    82.152   739.523     0.150
    82.263   741.016     0.150
    82.594   742.672     0.150
    82.682   742.984     0.150
    82.531   742.852     0.150
    82.531   741.797     0.150
    83.305   745.562     0.150
    83.109   745.633     0.150
    83.609   747.531     0.150
    83.609   748.453     0.150
    83.951   747.352     0.150
    84.301   751.008     0.150
    84.372   751.805     0.150
    84.721   754.633     0.150
    84.721   753.281     0.150
    84.819   752.727     0.150
    84.819   752.477     0.150
    85.462   756.781     0.150
    85.462   757.703     0.150
    85.554   756.773     0.150
    85.554   757.016     0.150
    85.835   758.992     0.150
    85.695   758.227     0.150
    86.067   760.086     0.150
    86.651   761.227     0.150
    86.651   761.922     0.150
    86.958   764.000     0.150
    86.958   764.531     0.150
    89.674   776.812     0.150
    89.675   776.883     0.150
    90.249   779.328     0.150
    90.249   778.883     0.150
    91.961   786.312     0.150
   135.333   980.930     0.150
   135.333   986.328     0.150
   140.352  1168.156     0.150
   149.382  1186.406     0.150
   150.748  1189.398     0.150
   151.031  1190.125     0.150
   151.490  1190.734     0.150
     0.496    17.571     0.150
     0.496    16.671     0.150
     0.536    10.472     0.150
     0.536    17.571     0.150
     0.536    18.171     0.150
     0.814    15.571     0.150
     0.814    26.671     0.150
     0.814    27.371     0.150
     0.831    15.371     0.150
     0.831    26.371     0.150
     1.464    26.771     0.150
     1.464    46.371     0.150
     1.752    31.371     0.150
     1.752    55.171     0.150
     1.752    30.871     0.150
     1.775    30.972     0.150
     1.775    55.571     0.150
     1.900    32.972     0.150
     1.900    57.571     0.150
     2.861    45.871     0.150
     2.861    51.171     0.150
     2.861    88.671     0.150
     2.861    88.171     0.150
     3.245    51.271     0.150
     3.245   100.271     0.150
     3.365    52.071     0.150
     3.365    60.871     0.150
     3.365    92.071     0.150
     3.608    56.371     0.150
     3.608    64.671     0.150
     3.608   112.071     0.150
     3.790    68.771     0.150
     3.790   119.071     0.150
     3.790   116.871     0.150
     4.172    64.271     0.150
     4.172   112.871     0.150
     4.172   129.871     0.150
     4.110    73.871     0.150
     4.110   127.171     0.150
     4.110    64.571     0.150
     4.110   129.571     0.150
     4.252    65.171     0.150
     4.252   112.972     0.150
     4.252   131.571     0.150
     4.522    68.071     0.150
     4.522    80.671     0.150
     4.522   119.671     0.150
     4.522   140.871     0.150
     4.522    80.871     0.150
     4.522   119.871     0.150
     4.522   139.972     0.150
     4.765   148.771     0.150
     4.944    74.571     0.150
     4.944   129.571     0.150
     4.944   151.871     0.150
     4.944    87.071     0.150
     4.944   129.871     0.150
     4.944   150.472     0.150
     5.061    75.571     0.150
     5.061   156.472     0.150
     5.309    79.472     0.150
     5.309   163.871     0.150
     5.349    80.571     0.150
     5.349   166.171     0.150
     5.577    83.972     0.150
     5.577   173.071     0.150
     6.225   192.271     0.150
     6.225    90.271     0.150
     6.225   191.871     0.150
     6.233   193.871     0.150
     6.394    93.071     0.150
     6.394   199.571     0.150
     6.464    94.671     0.150
     6.464   199.271     0.150
     6.853   101.871     0.150
     6.853   212.071     0.150
     6.892   100.472     0.150
     6.892   175.271     0.150
     6.892   211.972     0.150
     6.892    99.671     0.150
     6.892   212.171     0.150
     7.306   106.171     0.150
     7.306   226.071     0.150
     7.306   223.671     0.150
     7.991   117.972     0.150
     7.991   246.771     0.150
     7.991   117.671     0.150
     8.086   206.171     0.150
     8.086   249.771     0.150
     8.162   118.972     0.150
     8.162   208.472     0.150
     8.162   252.871     0.150
     8.162   118.871     0.150
     8.162   208.271     0.150
     8.280   120.271     0.150
     8.280   211.571     0.150
     8.280   256.671     0.150
     8.280   119.871     0.150
     8.280   213.071     0.150
     8.759   126.972     0.150
     8.914   129.771     0.150
     8.914   161.972     0.150
     8.914   276.371     0.150
     8.914   130.671     0.150
     9.105   131.915     0.150
     9.105   287.052     0.150
    10.600   151.781     0.150
    10.600   148.642     0.150
    10.600   152.071     0.150
    10.549   153.071     0.150
    13.468   190.959     0.150
    13.468   419.347     0.150
    13.468   191.472     0.150
    15.123   217.972     0.150
    15.263   221.871     0.150
    16.035   224.411     0.150
    16.035   224.446     0.150
    16.035   502.479     0.150
    16.249   230.972     0.150
    16.422   229.472     0.150
    17.073   534.840     0.150
    17.126   242.571     0.150
    17.126   240.671     0.150
    17.126   239.204     0.150
    17.126   534.828     0.150
    17.361   537.275     0.150
    18.716   258.671     0.150
    18.747   266.371     0.150
    19.107   261.271     0.150
    19.107   604.171     0.150
    20.050   271.871     0.150
    20.050   634.611     0.150
    20.052   275.071     0.150
    20.421   276.651     0.150
    20.421   277.871     0.150
    20.816   279.972     0.150
    20.816   280.472     0.150
    20.911   282.046     0.150
    20.904   281.401     0.150
    20.904   281.771     0.150
    20.904   281.796     0.150
    20.904   281.671     0.150
    20.872   283.371     0.150
    21.019   282.979     0.150
    21.019   658.231     0.150
    21.019   284.071     0.150
    21.066   283.211     0.150
    21.296   286.053     0.150
    21.296   672.171     0.150
    23.270   308.472     0.150
    24.141   316.371     0.150
    24.392   317.871     0.150
    24.437   318.262     0.150
    24.437   317.972     0.150
    24.502   318.171     0.150
    24.788   320.071     0.150
    24.997   324.271     0.150
    25.031   324.771     0.150
    25.642   330.371     0.150
    25.938   331.800     0.150
    25.938   332.621     0.150
    26.085   335.271     0.150
    26.085   830.041     0.150
    26.519   337.871     0.150
    26.914   339.371     0.150
    26.914   380.472     0.150
    27.140   344.711     0.150
    27.214   343.671     0.150
    27.829   349.568     0.150
    27.829   349.001     0.150
    27.829   350.171     0.150
    27.835   350.821     0.150
    29.216   364.472     0.150
    29.376   361.771     0.150
    29.376   412.571     0.150
    29.376   655.972     0.150
    29.717   365.341     0.150
    29.717   364.941     0.150
    29.717   364.401     0.150
    31.610   382.302     0.150
    31.966   384.231     0.150
    32.396   388.810     0.150
    32.632   392.131     0.150
    33.085   394.771     0.150
    33.509   399.501     0.150
    33.666   400.171     0.150
    34.137   406.371     0.150
    34.458   408.871     0.150
    34.517   409.871     0.150
    34.612   409.472     0.150
    35.062   414.071     0.150
    36.611   425.411     0.150
    36.684   424.771     0.150
    36.900   427.521     0.150
    36.900   427.071     0.150
    37.082   428.541     0.150
    37.082   428.354     0.150
    37.282   432.456     0.150
    38.262   438.921     0.150
    38.262   438.460     0.150
    38.601   442.141     0.150
    38.692   443.602     0.150
    39.219   446.762     0.150
    39.846   451.871     0.150
    40.148   456.166     0.150
    40.148   456.591     0.150
    40.148   456.501     0.150
    40.607   456.771     0.150
    40.930   460.371     0.150
    40.930   555.371     0.150
    40.930   832.771     0.150
    41.081   462.488     0.150
    41.207   461.472     0.150
    41.531   466.237     0.150
    41.594   466.856     0.150
    41.635   467.097     0.150
    41.703   467.106     0.150
    41.765   468.721     0.150
    41.862   469.433     0.150
    41.900   468.271     0.150
    41.972   470.976     0.150
    41.984   470.421     0.150
    42.048   469.501     0.150
    42.050   470.071     0.150
    42.050   469.921     0.150
    42.047   471.027     0.150
    42.363   472.843     0.150
    42.406   473.649     0.150
    42.604   474.881     0.150
    42.654   475.722     0.150
    42.690   475.961     0.150
    42.690   476.154     0.150
    42.702   476.141     0.150
    43.009   478.297     0.150
    43.038   479.062     0.150
    43.067   478.831     0.150
    43.067   479.449     0.150
    43.213   480.109     0.150
    43.247   480.998     0.150
    43.444   483.045     0.150
    43.558   483.230     0.150
    43.585   481.182     0.150
    43.571   483.896     0.150
    43.689   484.012     0.150
    43.689   484.576     0.150
    43.761   485.270     0.150
    43.833   485.523     0.150
    43.857   485.672     0.150
    43.972   487.071     0.150
    43.972   487.389     0.150
    43.974   487.057     0.150
    44.162   488.745     0.150
    44.229   487.802     0.150
    44.229   489.039     0.150
    44.234   487.762     0.150
    44.234   489.200     0.150
    44.245   489.093     0.150
    44.238   489.360     0.150
    44.281   488.932     0.150
    44.314   490.244     0.150
    44.340   488.892     0.150
    44.470   491.348     0.150
    44.536   492.022     0.150
    44.596   491.913     0.150
    44.624   492.019     0.150
    44.618   492.922     0.150
    44.619   493.201     0.150
    44.619   490.441     0.150
    44.619   492.671     0.150
    44.619   594.171     0.150
    44.654   490.871     0.150
    44.679   491.803     0.150
    44.736   491.071     0.150
    44.802   493.642     0.150
    44.802   494.114     0.150
    44.825   493.870     0.150
    44.834   493.771     0.150
    44.877   494.361     0.150
    44.939   495.631     0.150
    44.991   493.901     0.150
    45.004   495.131     0.150
    45.153   497.192     0.150
    45.177   495.191     0.150
    45.177   496.531     0.150
    45.193   495.621     0.150
    45.193   497.143     0.150
    45.220   496.512     0.150
    45.220   496.584     0.150
    45.244   497.762     0.150
    45.377   497.472     0.150
    45.377   603.472     0.150
    45.377   898.571     0.150
    45.377  1102.871     0.150
    45.339   496.642     0.150
    45.339   497.517     0.150
    45.416   497.031     0.150
    45.429   497.831     0.150
    45.429   497.984     0.150
    45.521   499.691     0.150
    45.521   499.564     0.150
    45.536   499.083     0.150
    45.559   498.984     0.150
    45.573   499.865     0.150
    45.572   499.921     0.150
    45.603   499.171     0.150
    45.824   501.397     0.150
    45.827   502.021     0.150
    45.883   501.312     0.150
    45.956   501.892     0.150
    45.956   503.103     0.150
    45.980   502.472     0.150
    45.978   502.211     0.150
    45.976   503.771     0.150
    46.087   502.911     0.150
    46.087   503.382     0.150
    46.072   506.371     0.150
    46.118   503.623     0.150
    46.138   503.491     0.150
    46.138   503.869     0.150
    46.144   503.999     0.150
    46.152   504.167     0.150
    46.213   504.004     0.150
    46.330   505.151     0.150
    46.371   505.318     0.150
    46.428   506.121     0.150
    46.469   506.361     0.150
    46.469   506.231     0.150
    46.469   505.371     0.150
    46.469   615.472     0.150
    46.469   913.771     0.150
    46.469  1114.671     0.150
    46.488   506.071     0.150
    46.569   506.531     0.150
    46.569   506.391     0.150
    46.570   506.574     0.150
    46.619   507.411     0.150
    46.619   507.066     0.150
    46.698   507.477     0.150
    46.811   508.225     0.150
    46.811   507.922     0.150
    46.832   508.959     0.150
    46.848   508.834     0.150
    46.866   508.951     0.150
    46.869   507.071     0.150
    46.891   508.861     0.150
    46.964   510.120     0.150
    46.970   509.974     0.150
    47.072   510.401     0.150
    47.115   509.881     0.150
    47.141   510.546     0.150
    47.193   511.821     0.150
    47.193   511.637     0.150
    47.240   512.142     0.150
    47.288   511.762     0.150
    47.288   512.269     0.150
    47.307   512.296     0.150
    47.321   512.829     0.150
    47.349   512.795     0.150
    47.373   512.479     0.150
    47.547   513.812     0.150
    47.550   514.289     0.150
    47.617   515.127     0.150
    47.636   515.543     0.150
    47.694   516.142     0.150
    47.694   515.665     0.150
    47.698   515.731     0.150
    47.698   515.974     0.150
    47.739   515.142     0.150
    47.934   516.791     0.150
    47.969   516.972     0.150
    47.969   516.946     0.150
    47.971   517.021     0.150
    48.046   517.562     0.150
    48.032   518.441     0.150
    48.056   516.701     0.150
    48.056   517.562     0.150
    48.043   519.291     0.150
    48.085   518.222     0.150
    48.085   518.983     0.150
    48.095   518.917     0.150
    48.132   518.041     0.150
    48.120   518.905     0.150
    48.319   519.074     0.150
    48.394   521.733     0.150
    48.503   521.932     0.150
    48.519   522.373     0.150
    48.863   524.824     0.150
    48.899   524.091     0.150
    49.253   527.321     0.150
    49.389   529.151     0.150
    49.510   528.972     0.150
    49.510   529.331     0.150
    49.570   530.223     0.150
    50.008   533.543     0.150
    50.070   532.071     0.150
    50.198   535.360     0.150
    50.304   535.755     0.150
    50.734   537.822     0.150
    51.040   541.161     0.150
    51.137   542.218     0.150
    51.153   541.991     0.150
    51.165   542.196     0.150
    51.342   543.525     0.150
    51.642   546.463     0.150
    51.655   546.171     0.150
    51.871   547.839     0.150
    51.955   549.395     0.150
    52.093   549.767     0.150
    52.236   550.972     0.150
    52.296   551.529     0.150
    52.419   551.481     0.150
    52.419   551.671     0.150
    52.419   552.821     0.150
    52.419   551.531     0.150
    52.779   554.660     0.150
    52.810   555.671     0.150
    52.959   555.841     0.150
    53.034   557.845     0.150
    53.053   556.689     0.150
    53.241   557.671     0.150
    53.369   558.472     0.150
    53.376   559.171     0.150
    53.376     7.801     0.150
    53.400   559.271     0.150
    53.572   560.472     0.150
    53.844   564.371     0.150
    53.841   562.718     0.150
    53.928   563.206     0.150
    53.991   563.154     0.150
    54.008   563.571     0.150
    54.001   562.762     0.150
    54.042   563.661     0.150
    54.129   563.111     0.150
    54.129   563.571     0.150
    54.129   685.071     0.150
    54.276   565.571     0.150
    54.276   565.771     0.150
    54.278   565.252     0.150
    54.331   566.120     0.150
    54.475   566.702     0.150
    54.891   569.377     0.150
    55.134   571.035     0.150
    55.211   572.171     0.150
    55.264   572.271     0.150
    55.318   574.193     0.150
    55.318   572.914     0.150
    55.318   571.903     0.150
    55.336   572.690     0.150
    55.348   573.826     0.150
    55.483   573.591     0.150
    55.483   573.771     0.150
    55.483     5.300     0.150
    55.471   573.531     0.150
    55.641   575.411     0.150
    55.641   575.196     0.150
    55.667   574.769     0.150
    55.754   576.125     0.150
    55.754   575.302     0.150
    56.129   579.332     0.150
    56.176   577.271     0.150
    56.176   636.171     0.150
    56.230   578.711     0.150
    56.654   583.125     0.150
    56.799   584.871     0.150
    57.002   585.768     0.150
    57.121   586.854     0.150
    57.290   586.271     0.150
    57.540   588.352     0.150
    57.573   588.131     0.150
    57.716   590.772     0.150
    57.744   591.200     0.150
    57.745   590.527     0.150
    57.771   590.281     0.150
    57.799   589.291     0.150
    57.831   589.815     0.150
    57.831   590.441     0.150
    57.918   591.935     0.150
    57.959   592.058     0.150
    57.966   592.668     0.150
    58.004   591.552     0.150
    58.025   591.291     0.150
    58.073   592.711     0.150
    58.311   593.691     0.150
    58.330   594.443     0.150
    58.542   595.161     0.150
    58.888   598.752     0.150
    60.046   604.161     0.150
    60.319   607.352     0.150
    60.463   608.291     0.150
    60.794   610.621     0.150
    61.533   615.111     0.150
    61.634   616.671     0.150
    67.860   657.757     0.150
    68.038   659.187     0.150
    69.443   666.487     0.150
    69.974   672.083     0.150
    70.088   671.981     0.150
    70.122   672.415     0.150
    70.223   672.882     0.150
    70.228   673.241     0.150
    70.286   672.937     0.150
    70.384   673.459     0.150
    70.544   674.421     0.150
    70.730   676.673     0.150
    70.813   676.877     0.150
    71.016   677.411     0.150
    71.082   678.609     0.150
    71.264   679.494     0.150
    71.374   679.004     0.150
    71.479   680.486     0.150
    71.638   681.488     0.150
    71.693   682.411     0.150
    72.080   683.833     0.150
    73.091   690.371     0.150
    73.183   690.863     0.150
    73.299   689.356     0.150
    73.481   693.317     0.150
    74.404   697.142     0.150
    74.995   700.611     0.150
    75.269   702.491     0.150
    75.269   702.021     0.150
    75.489   702.581     0.150
    75.489   703.630     0.150
    76.219   707.032     0.150
    76.366   708.142     0.150
    76.410   709.462     0.150
    76.646   711.177     0.150
    76.817   709.903     0.150
    77.418   715.216     0.150
    77.536   714.213     0.150
    78.012   718.483     0.150
    78.022   719.359     0.150
    77.931   716.421     0.150
    78.077   718.896     0.150
    78.268   720.433     0.150
    78.454   720.706     0.150
    78.573   721.944     0.150
    78.674   722.450     0.150
    78.820   723.150     0.150
    78.821   722.636     0.150
    78.975   723.129     0.150
    79.020   724.722     0.150
    79.124   724.921     0.150
    79.484   724.954     0.150
    79.494   724.969     0.150
    79.694   727.999     0.150
    79.742   728.102     0.150
    79.974   728.060     0.150
    80.032   728.903     0.150
    80.391   731.700     0.150
    80.611   732.906     0.150
    80.652   732.465     0.150
    80.700   733.363     0.150
    80.710   733.412     0.150
    81.075   735.171     0.150
    81.193   736.660     0.150
    81.200   736.225     0.150
    81.380   737.090     0.150
    81.387   734.892     0.150
    81.387   737.024     0.150
    81.394   737.062     0.150
    81.550   736.713     0.150
    81.571   737.331     0.150
    81.470   735.735     0.150
    81.817   738.401     0.150
    81.943   738.788     0.150
    81.983   738.760     0.150
    82.049   740.790     0.150
    82.266   741.519     0.150
    82.379   741.052     0.150
    82.459   741.111     0.150
    82.788   744.334     0.150
    82.788   744.781     0.150
    82.788   745.071     0.150
    83.122   744.351     0.150
    83.417   746.671     0.150
    83.417   748.071     0.150
    83.417   747.772     0.150
    83.617   746.781     0.150
    83.830   747.830     0.150
    84.053   749.649     0.150
    84.164   750.216     0.150
    84.517   752.167     0.150
    84.685   753.111     0.150
    84.796   754.240     0.150
    85.225   755.735     0.150
    85.265   757.210     0.150
    85.370   756.975     0.150
    85.663   758.871     0.150
    85.948   759.251     0.150
    85.948   760.871     0.150
    86.510   762.312     0.150
    86.510   761.999     0.150
    86.766   764.063     0.150
    87.464   767.061     0.150
    88.605   772.724     0.150
    89.462   776.531     0.150
    89.484   776.996     0.150
    89.672   777.114     0.150
    89.810   777.595     0.150
    90.442   780.526     0.150
   139.692  1166.789     0.150
   140.274  1169.102     0.150
   144.690  1172.972     0.150
   146.551  1180.699     0.150
   149.388  1186.696     0.150
   149.516  1186.849     0.150
   149.516  1187.088     0.150
   150.953  1190.579     0.150
   151.237  1191.268     0.150
   151.693  1191.872     0.150
     0.449     8.633     0.150
     0.449    15.133     0.150
     0.381     7.535     0.150
     0.381    13.234     0.150
     1.162    20.633     0.150
     1.162    36.934     0.150
     1.162    37.234     0.150
     1.369    24.434     0.150
     1.369    43.336     0.150
     1.624    28.035     0.150
     1.624    28.836     0.150
     1.624    49.734     0.150
     1.624    28.734     0.150
     1.624    50.836     0.150
     2.051    33.133     0.150
     2.051    35.535     0.150
     2.051    62.133     0.150
     2.051    35.234     0.150
     2.051    59.434     0.150
     2.595    41.434     0.150
     2.595    46.535     0.150
     2.595    80.336     0.150
     2.595    41.836     0.150
     2.595    79.336     0.150
     2.560    41.133     0.150
     2.560    46.035     0.150
     2.560    70.734     0.150
     2.560    79.434     0.150
     2.560    79.535     0.150
     3.174    49.633     0.150
     3.174    56.234     0.150
     3.174    58.336     0.150
     3.174    86.535     0.150
     3.174    98.535     0.150
     3.174    56.434     0.150
     3.174    98.434     0.150
     3.483    53.734     0.150
     3.483    61.734     0.150
     3.483   107.336     0.150
     3.767    56.133     0.150
     3.767    65.734     0.150
     3.767    99.035     0.150
     3.767   114.535     0.150
     3.639    55.934     0.150
     3.639    66.633     0.150
     3.639    97.633     0.150
     3.639   114.434     0.150
     3.639    64.836     0.150
     3.639    96.434     0.150
     3.773    58.434     0.150
     3.773    67.734     0.150
     3.773   100.734     0.150
     3.773   118.234     0.150
     3.773    57.133     0.150
     3.773   104.234     0.150
     3.773   117.633     0.150
     3.995    61.133     0.150
     3.995   104.734     0.150
     3.995   124.836     0.150
     4.316    65.633     0.150
     4.316    77.234     0.150
     4.316   114.633     0.150
     4.316   133.035     0.150
     4.320    67.133     0.150
     4.320   114.535     0.150
     4.320   134.734     0.150
     4.320    67.336     0.150
     5.189   161.836     0.150
     5.440    80.836     0.150
     5.440   141.836     0.150
     5.440   168.336     0.150
     5.440    80.734     0.150
     5.708    84.535     0.150
     5.708   177.234     0.150
     5.755   179.336     0.150
     6.070    89.133     0.150
     6.070   188.336     0.150
     6.118    90.434     0.150
     6.118   157.434     0.150
     6.118   190.434     0.150
     6.166    89.934     0.150
     6.166   191.336     0.150
     6.336    92.734     0.150
     6.336   196.336     0.150
     6.724    98.234     0.150
     6.724   171.836     0.150
     6.724   207.934     0.150
     6.772    99.336     0.150
     6.772   210.633     0.150
     6.772    99.234     0.150
     6.968   101.234     0.150
     6.968   215.836     0.150
     7.376   104.812     0.150
     7.419   107.633     0.150
     7.419   188.934     0.150
     7.419   229.234     0.150
     7.419   107.434     0.150
     7.893   114.336     0.150
     7.893   203.535     0.150
     7.895   113.633     0.150
     7.895   244.133     0.150
     8.443   122.734     0.150
     8.443   152.133     0.150
     8.443   262.633     0.150
     8.776   126.836     0.150
     8.776   157.734     0.150
     8.776   271.336     0.150
     8.776   126.535     0.150
     8.776   225.133     0.150
     8.973   128.633     0.150
     8.973   277.535     0.150
     9.029   130.656     0.150
     9.029   130.434     0.150
     9.029   130.535     0.150
     9.258   133.516     0.150
     9.258   168.453     0.150
     9.258   235.035     0.150
     9.258   289.590     0.150
     9.282   294.105     0.150
     9.750   138.234     0.150
    10.205   183.254     0.150
    10.205   253.652     0.150
    10.205   310.688     0.150
    10.205   256.035     0.150
    11.189   161.234     0.150
    11.189   345.535     0.150
    11.956   169.336     0.150
    12.297   378.934     0.150
    12.586   179.160     0.150
    12.586   391.785     0.150
    12.586   179.035     0.150
    13.094   183.836     0.150
    14.253   200.336     0.150
    14.908   208.594     0.150
    14.908   210.734     0.150
    15.026   213.734     0.150
    15.026   227.836     0.150
    15.274   221.336     0.150
    15.412   376.633     0.150
    15.412   217.336     0.150
    15.412   380.336     0.150
    15.805   222.035     0.150
    15.827   222.113     0.150
    16.278   225.473     0.150
    16.278   226.484     0.150
    16.278   508.867     0.150
    16.884   234.473     0.150
    16.884   234.309     0.150
    16.884   234.695     0.150
    17.134   533.359     0.150
    17.173   239.035     0.150
    17.616   246.836     0.150
    18.101   262.734     0.150
    18.101   462.133     0.150
    18.386   256.336     0.150
    18.386   264.734     0.150
    18.386   467.535     0.150
    18.921   260.535     0.150
    18.921   474.035     0.150
    19.815   269.828     0.150
    19.815   268.664     0.150
    19.677   270.234     0.150
    19.677   487.836     0.150
    19.834   269.895     0.150
    19.840   268.746     0.150
    20.530   278.785     0.150
    20.575   279.684     0.150
    20.660   280.734     0.150
    20.660   286.336     0.150
    20.892   283.133     0.150
    20.892   306.234     0.150
    20.892   510.133     0.150
    20.892   520.633     0.150
    21.252   287.336     0.150
    21.252   524.836     0.150
    21.252   533.133     0.150
    21.252   550.035     0.150
    21.577   287.934     0.150
    21.579   287.895     0.150
    21.644   288.926     0.150
    21.644   289.434     0.150
    21.644   289.844     0.150
    21.644   288.836     0.150
    21.644   289.785     0.150
    21.644   289.324     0.150
    21.738   289.754     0.150
    21.738   289.535     0.150
    21.809   291.164     0.150
    22.024   294.633     0.150
    22.024   534.633     0.150
    23.342   307.023     0.150
    23.565   310.535     0.150
    23.565   564.535     0.150
    23.565   575.035     0.150
    23.706   309.633     0.150
    23.706   337.234     0.150
    23.706   566.734     0.150
    23.706   604.734     0.150
    23.952   314.535     0.150
    24.552   319.125     0.150
    24.887   322.484     0.150
    25.199   325.043     0.150
    25.199   323.684     0.150
    25.199   324.883     0.150
    25.264   324.453     0.150
    25.309   326.086     0.150
    25.220   326.535     0.150
    25.260   324.430     0.150
    25.345   324.445     0.150
    25.345   597.844     0.150
    25.344   325.926     0.150
    25.494   324.113     0.150
    25.494   326.926     0.150
    25.705   330.133     0.150
    25.715   328.484     0.150
    25.693   326.695     0.150
    25.741   328.734     0.150
    25.767   327.855     0.150
    25.968   330.484     0.150
    26.137   331.723     0.150
    26.383   333.984     0.150
    26.595   335.344     0.150
    26.595   337.035     0.150
    26.595   543.234     0.150
    26.595   608.934     0.150
    26.735   336.984     0.150
    26.815   339.273     0.150
    26.815   617.625     0.150
    26.862   339.562     0.150
    27.300   343.766     0.150
    27.777   347.535     0.150
    27.969   348.664     0.150
    28.574   355.227     0.150
    28.574   354.863     0.150
    28.574   355.836     0.150
    29.780   367.836     0.150
    29.780   663.035     0.150
    30.257   368.578     0.150
    30.257   369.035     0.150
    30.257   426.035     0.150
    30.257   546.633     0.150
    30.257   669.535     0.150
    30.257   762.035     0.150
    30.498   371.875     0.150
    30.586   374.035     0.150
    30.586   678.234     0.150
    32.213   388.516     0.150
    32.355   389.184     0.150
    32.836   392.234     0.150
    32.836   391.734     0.150
    32.757   394.535     0.150
    32.757   708.836     0.150
    33.370   397.273     0.150
    33.952   402.234     0.150
    34.254   403.863     0.150
    34.241   405.484     0.150
    34.510   405.434     0.150
    34.421   407.633     0.150
    34.512   408.336     0.150
    34.734   410.633     0.150
    34.778   410.633     0.150
    34.916   411.934     0.150
    34.916   412.035     0.150
    34.946   411.633     0.150
    34.972   411.734     0.150
    35.010   412.734     0.150
    36.587   423.734     0.150
    36.954   428.680     0.150
    36.822   427.926     0.150
    36.822   774.633     0.150
    37.314   430.355     0.150
    37.524   431.035     0.150
    37.524   510.434     0.150
    37.654   433.562     0.150
    37.655   433.473     0.150
    37.655   433.086     0.150
    37.655   433.434     0.150
    37.782   434.609     0.150
    37.782   434.836     0.150
    38.312   439.215     0.150
    38.354   441.172     0.150
    38.416   439.336     0.150
    38.633   442.836     0.150
    38.662   443.086     0.150
    38.985   444.375     0.150
    38.985   443.863     0.150
    38.985   443.703     0.150
    38.977   445.594     0.150
    38.977   444.625     0.150
    39.944   452.445     0.150
    40.374   455.094     0.150
    40.557   458.395     0.150
    40.913   462.062     0.150
    40.966   461.074     0.150
    40.959   462.258     0.150
    40.959   461.035     0.150
    40.959   461.074     0.150
    41.345   465.734     0.150
    41.362   465.559     0.150
    41.428   466.082     0.150
    41.470   466.504     0.150
    41.488   464.734     0.150
    41.540   467.086     0.150
    41.642   468.434     0.150
    41.727   468.551     0.150
    41.795   468.035     0.150
    41.795   568.934     0.150
    41.795   847.633     0.150
    41.795  1029.934     0.150
    41.860   469.105     0.150
    41.860   469.371     0.150
    41.928   469.723     0.150
    42.165   472.199     0.150
    42.178   471.875     0.150
    42.433   473.695     0.150
    42.433   474.414     0.150
    42.438   474.070     0.150
    42.444   473.875     0.150
    42.509   475.105     0.150
    42.526   475.555     0.150
    42.487   473.836     0.150
    42.776   477.133     0.150
    42.776   477.000     0.150
    42.776   477.141     0.150
    42.785   477.020     0.150
    42.791   477.090     0.150
    42.779   475.535     0.150
    42.819   477.578     0.150
    42.855   476.363     0.150
    42.857   476.559     0.150
    42.857   476.414     0.150
    42.985   478.777     0.150
    43.013   479.188     0.150
    43.023   478.125     0.150
    43.036   479.113     0.150
    43.064   479.867     0.150
    43.266   480.203     0.150
    43.266   481.426     0.150
    43.327   480.004     0.150
    43.380   482.160     0.150
    43.451   480.926     0.150
    43.451   482.973     0.150
    43.503   482.312     0.150
    43.503   483.684     0.150
    43.608   484.617     0.150
    43.621   484.234     0.150
    43.643   483.473     0.150
    43.643   484.367     0.150
    43.670   484.684     0.150
    43.843   486.074     0.150
    43.847   487.094     0.150
    43.908   485.176     0.150
    43.909   485.605     0.150
    43.909   487.004     0.150
    43.959   484.355     0.150
    43.959   486.848     0.150
    43.963   486.715     0.150
    43.963   486.891     0.150
    43.982   486.977     0.150
    44.000   486.754     0.150
    44.000   487.148     0.150
    44.022   487.301     0.150
    44.067   487.309     0.150
    44.096   485.523     0.150
    44.110   484.934     0.150
    44.218   489.059     0.150
    44.231   488.711     0.150
    44.340   488.785     0.150
    44.340   489.539     0.150
    44.392   487.234     0.150
    44.408   489.906     0.150
    44.414   490.668     0.150
    44.419   490.016     0.150
    44.454   491.156     0.150
    44.478   491.035     0.150
    44.478   491.387     0.150
    44.582   491.145     0.150
    44.582   491.801     0.150
    44.585   491.695     0.150
    44.585   491.035     0.150
    44.588   491.695     0.150
    44.588   491.832     0.150
    44.588   492.035     0.150
    44.595   492.246     0.150
    44.595   491.824     0.150
    44.589   492.875     0.150
    44.636   492.648     0.150
    44.742   492.746     0.150
    44.751   492.934     0.150
    44.874   494.594     0.150
    44.907   495.543     0.150
    44.971   492.355     0.150
    44.971   494.652     0.150
    44.978   491.605     0.150
    44.978   494.484     0.150
    44.978   493.383     0.150
    45.026   495.508     0.150
    45.025   495.215     0.150
    45.181   496.043     0.150
    45.181   495.664     0.150
    45.242   497.246     0.150
    45.243   496.902     0.150
    45.346   499.156     0.150
    45.379   498.434     0.150
    45.561   500.184     0.150
    45.588   496.664     0.150
    45.534   498.336     0.150
    45.600   499.121     0.150
    45.639   499.906     0.150
    45.612   498.336     0.150
    45.694   499.203     0.150
    45.689   500.164     0.150
    45.659   499.234     0.150
    45.792   501.129     0.150
    45.792   501.625     0.150
    45.866   501.195     0.150
    45.866   501.324     0.150
    45.875   501.996     0.150
    45.875   501.570     0.150
    46.021   502.105     0.150
    46.021   501.926     0.150
    46.048   502.426     0.150
    46.163   502.703     0.150
    46.163   503.242     0.150
    46.173   504.473     0.150
    46.229   502.305     0.150
    46.229   610.586     0.150
    46.229   908.973     0.150
    46.229  1115.766     0.150
    46.229  1097.934     0.150
    46.253   504.750     0.150
    46.261   503.812     0.150
    46.322   505.055     0.150
    46.460   504.785     0.150
    46.554   506.977     0.150
    46.604   507.566     0.150
    46.646   504.875     0.150
    46.674   508.023     0.150
    46.700   507.633     0.150
    46.700   507.312     0.150
    46.700   508.285     0.150
    46.719   508.215     0.150
    46.863   508.625     0.150
    46.863   509.633     0.150
    46.872   509.461     0.150
    46.914   510.008     0.150
    46.928   509.016     0.150
    46.928   509.246     0.150
    46.991   509.848     0.150
    47.081   510.996     0.150
    47.148   511.383     0.150
    47.148   510.938     0.150
    47.248   511.922     0.150
    47.302   511.773     0.150
    47.364   512.254     0.150
    47.364   513.184     0.150
    47.350   512.035     0.150
    47.350   927.133     0.150
    47.407   513.734     0.150
    47.793   515.594     0.150
    47.793   517.035     0.150
    47.805   517.055     0.150
    47.808   517.355     0.150
    47.839   516.695     0.150
    47.839   517.520     0.150
    47.912   517.336     0.150
    47.944   516.766     0.150
    47.944   516.105     0.150
    48.018   518.695     0.150
    48.018   518.395     0.150
    48.010   517.086     0.150
    48.010   516.773     0.150
    48.010   517.605     0.150
    48.233   520.137     0.150
    48.254   519.434     0.150
    48.254   521.059     0.150
    48.274   518.344     0.150
    48.274   518.578     0.150
    48.394   518.574     0.150
    48.471   521.664     0.150
    48.507   521.305     0.150
    48.518   521.344     0.150
    48.518   522.316     0.150
    48.554   521.805     0.150
    48.562   523.199     0.150
    48.619   523.742     0.150
    48.662   523.707     0.150
    48.700   522.965     0.150
    48.734   522.914     0.150
    48.735   522.633     0.150
    48.735   523.059     0.150
    48.798   523.395     0.150
    48.826   523.355     0.150
    48.826   523.723     0.150
    48.897   524.355     0.150
    48.950   525.625     0.150
    48.984   526.414     0.150
    48.986   524.535     0.150
    49.141   527.531     0.150
    49.221   527.113     0.150
    49.344   529.293     0.150
    49.401   528.215     0.150
    49.723   532.320     0.150
    49.795   532.719     0.150
    50.012   532.965     0.150
    50.062   534.883     0.150
    50.503   537.535     0.150
    50.530   536.746     0.150
    50.573   538.035     0.150
    50.749   650.234     0.150
    50.749  1124.234     0.150
    50.823   540.301     0.150
    50.838   540.262     0.150
    50.834   540.168     0.150
    50.916   540.156     0.150
    51.147   542.574     0.150
    51.147   542.238     0.150
    51.148   541.594     0.150
    51.339   544.164     0.150
    51.498   545.082     0.150
    51.521   544.293     0.150
    51.612   545.102     0.150
    51.663   545.445     0.150
    51.822   546.980     0.150
    52.040   548.582     0.150
    52.023   547.844     0.150
    52.036   548.062     0.150
    52.216   550.055     0.150
    52.657   555.434     0.150
    52.837   554.730     0.150
    53.013   555.820     0.150
    53.242   557.332     0.150
    53.300   558.324     0.150
    53.301   557.535     0.150
    53.301   557.684     0.150
    53.301   558.734     0.150
    53.974   563.156     0.150
    54.066   563.980     0.150
    54.192   564.199     0.150
    54.214   565.234     0.150
    54.219   565.133     0.150
    54.353   565.484     0.150
    54.383   563.656     0.150
    54.383   565.680     0.150
    54.314   566.133     0.150
    54.314   564.434     0.150
    54.216   566.434     0.150
    54.428   566.836     0.150
    54.312   564.465     0.150
    54.449   565.984     0.150
    54.449   567.035     0.150
    54.855   569.734     0.150
    54.959   569.234     0.150
    54.959     6.500     0.150
    54.959  1042.234     0.150
    54.959  1258.234     0.150
    55.120   570.168     0.150
    55.124   571.035     0.150
    55.229   572.535     0.150
    55.582   574.484     0.150
    56.118   576.418     0.150
    56.199   580.246     0.150
    56.233   579.633     0.150
    56.324   579.863     0.150
    56.324   579.535     0.150
    56.482   580.535     0.150
    56.482   580.395     0.150
    56.631   581.004     0.150
    56.856   584.605     0.150
    57.100   584.133     0.150
    57.177   585.504     0.150
    57.507   588.793     0.150
    57.854   591.480     0.150
    57.968   592.609     0.150
    58.174   593.535     0.150
    58.557   596.227     0.150
    58.586   596.562     0.150
    58.758   597.613     0.150
    58.807   598.039     0.150
    58.874   595.715     0.150
    58.873   597.312     0.150
    58.873   598.133     0.150
    59.683   602.266     0.150
    61.343   613.406     0.150
    62.407   622.246     0.150
    64.575   636.453     0.150
    65.603   641.883     0.150
    67.042   651.746     0.150
    67.839   656.699     0.150
    69.754   667.309     0.150
    69.825   670.285     0.150
    69.841   670.125     0.150
    70.107   671.445     0.150
    70.254   672.145     0.150
    70.469   673.773     0.150
    70.789   675.484     0.150
    71.010   677.375     0.150
    71.303   677.086     0.150
    71.303   678.504     0.150
    71.357   678.266     0.150
    71.358   679.125     0.150
    71.915   682.078     0.150
    72.555   686.395     0.150
    72.669   687.754     0.150
    72.884   688.484     0.150
    72.959   686.594     0.150
    72.959   688.652     0.150
    73.039   689.543     0.150
    73.039   688.559     0.150
    73.312   689.145     0.150
    73.312   689.355     0.150
    73.658   691.543     0.150
    73.858   693.414     0.150
    73.873   693.223     0.150
    73.960   693.613     0.150
    74.024   695.203     0.150
    74.031   695.234     0.150
    74.111   694.633     0.150
    74.689   696.234     0.150
    75.073   700.223     0.150
    75.108   699.996     0.150
    75.108   700.395     0.150
    75.108   699.723     0.150
    75.108   700.684     0.150
    75.108   699.586     0.150
    75.296   700.273     0.150
    75.394   701.504     0.150
    75.394   702.551     0.150
    75.651   703.684     0.150
    75.739   703.344     0.150
    76.100   705.836     0.150
    76.128   706.543     0.150
    76.213   706.754     0.150
    76.328   707.734     0.150
    76.434   709.000     0.150
    76.596   707.555     0.150
    76.849   709.383     0.150
    76.849   710.434     0.150
    76.891   712.086     0.150
    77.010   711.395     0.150
    77.107   711.945     0.150
    77.114   712.625     0.150
    77.164   712.750     0.150
    77.267   712.465     0.150
    77.192   711.996     0.150
    77.429   711.836     0.150
    77.520   713.695     0.150
    77.508   713.785     0.150
    77.346   713.336     0.150
    77.353   713.211     0.150
    77.353   712.625     0.150
    77.355   712.773     0.150
    77.408   712.934     0.150
    77.590   713.695     0.150
    77.637   715.043     0.150
    77.879   716.840     0.150
    77.915   717.414     0.150
    77.975   717.820     0.150
    78.189   716.895     0.150
    78.195   716.656     0.150
    78.532   719.793     0.150
    78.531   721.027     0.150
    78.591   720.074     0.150
    78.696   720.234     0.150
    78.886   721.703     0.150
    78.886   721.934     0.150
    78.975   723.039     0.150
    79.171   723.656     0.150
    79.228   723.156     0.150
    79.260   723.285     0.150
    79.309   725.465     0.150
    79.395   724.805     0.150
    79.392   725.227     0.150
    79.455   725.664     0.150
    79.492   725.145     0.150
    79.545   724.746     0.150
    79.545   725.445     0.150
    79.654   727.535     0.150
    79.897   728.438     0.150
    79.971   728.137     0.150
    80.049   728.789     0.150
    80.198   728.004     0.150
    80.476   730.836     0.150
    80.530   729.523     0.150
    80.528   731.641     0.150
    80.540   731.160     0.150
    80.929   732.484     0.150
    80.929   733.695     0.150
    81.082   734.801     0.150
    80.905   732.605     0.150
    80.906   732.883     0.150
    80.906   733.023     0.150
    81.155   735.008     0.150
    81.307   735.309     0.150
    81.476   735.695     0.150
    81.476   735.176     0.150
    81.946   737.523     0.150
    82.099   738.543     0.150
    82.538   740.898     0.150
    82.949   742.473     0.150
    83.269   744.805     0.150
    83.423   746.043     0.150
    83.423   745.473     0.150
    83.660   747.055     0.150
    83.759   748.395     0.150
    83.930   748.305     0.150
    83.967   747.812     0.150
    84.075   748.523     0.150
    84.075   748.910     0.150
    84.099   748.074     0.150
    84.160   749.605     0.150
    84.199   749.055     0.150
    84.409   750.062     0.150
    84.432   749.633     0.150
    84.509   750.844     0.150
    84.746   751.906     0.150
    84.760   752.246     0.150
    84.766   752.824     0.150
    84.766   752.398     0.150
    84.875   753.105     0.150
    84.991   753.555     0.150
    85.063   754.848     0.150
    85.114   753.383     0.150
    85.184   754.926     0.150
    85.184   755.508     0.150
    85.239   754.973     0.150
    85.581   757.043     0.150
    85.997   758.156     0.150
    86.016   759.062     0.150
    86.526   759.945     0.150
    86.542   760.703     0.150
    86.546   760.176     0.150
    86.567   761.086     0.150
    86.567   761.652     0.150
    86.823   763.109     0.150
    86.852   763.293     0.150
    87.116   764.562     0.150
    87.301   763.863     0.150
    87.361   766.344     0.150
    87.361   766.023     0.150
    87.860   767.758     0.150
    88.338   770.156     0.150
    88.493   771.176     0.150
    89.316   776.113     0.150
    89.316   775.184     0.150
    89.316   775.453     0.150
    89.383   775.934     0.150
    89.730   776.570     0.150
    89.914   777.547     0.150
   136.277  1159.285     0.150
   140.554  1168.461     0.150
   145.218  1176.062     0.150
   145.531  1175.156     0.150
   145.872  1177.363     0.150
   146.808  1181.254     0.150
   149.721  1194.852     0.150
   149.721  1186.289     0.150
   149.721  1194.586     0.150
   149.925  1187.934     0.150
   149.925  1194.809     0.150
   149.925  1183.223     0.150
   149.925  1188.273     0.150
   149.925  1195.062     0.150
   151.182  1198.176     0.150
   151.475  1199.438     0.150
   151.911  1199.926     0.150
   152.202  1185.895     0.150
   152.202  1194.586     0.150
   152.202  1203.664     0.150
     0.186     3.590     0.150
     0.186     6.188     0.150
     0.186     3.789     0.150
     0.186     6.289     0.150
     0.566    10.789     0.150
     0.566    17.391     0.150
     0.851    16.090     0.150
     0.851    27.391     0.150
     0.851    15.891     0.150
     0.851    27.391     0.150
     1.482    27.289     0.150
     1.482    47.090     0.150
     2.157    37.891     0.150
     2.157    39.688     0.150
     2.157    67.391     0.150
     2.157    67.188     0.150
     2.658    43.891     0.150
     2.658    47.289     0.150
     2.658    48.688     0.150
     2.658    81.188     0.150
     2.658    48.391     0.150
     2.719    45.289     0.150
     2.719    49.090     0.150
     2.719    83.891     0.150
     2.719    48.988     0.150
     2.719    83.488     0.150
     2.807    46.789     0.150
     2.807    51.789     0.150
     2.807    81.391     0.150
     2.807    88.688     0.150
     2.891    48.090     0.150
     2.891    52.391     0.150
     2.891    78.688     0.150
     2.891    89.789     0.150
     2.891    47.789     0.150
     2.891    52.891     0.150
     2.891    89.289     0.150
     3.081    50.188     0.150
     3.081    55.590     0.150
     3.081    86.488     0.150
     3.081    95.688     0.150
     3.183    51.590     0.150
     3.183    57.090     0.150
     3.183    98.988     0.150
     3.815    58.891     0.150
     3.815    69.090     0.150
     3.815   103.289     0.150
     3.815   118.289     0.150
     3.915    61.289     0.150
     3.915    70.488     0.150
     3.915   122.289     0.150
     3.920    61.289     0.150
     3.920   122.289     0.150
     3.994    62.188     0.150
     3.994    71.789     0.150
     3.994   123.590     0.150
     3.994    72.391     0.150
     3.994   110.188     0.150
     3.994   126.590     0.150
     4.192    65.688     0.150
     4.192   130.789     0.150
     4.192   131.289     0.150
     4.051    63.391     0.150
     4.051    73.391     0.150
     4.051   109.891     0.150
     4.051   125.488     0.150
     4.051    73.789     0.150
     4.051   110.289     0.150
     4.353    68.090     0.150
     4.353    77.891     0.150
     4.353   134.789     0.150
     4.470    69.090     0.150
     4.470   117.988     0.150
     4.470   138.188     0.150
     4.504    81.289     0.150
     4.504   120.289     0.150
     4.504   140.090     0.150
     4.508    70.289     0.150
     4.508    80.789     0.150
     4.508   139.488     0.150
     4.769    73.789     0.150
     4.769   148.188     0.150
     4.936   152.789     0.150
     5.115    78.590     0.150
     5.115   135.090     0.150
     5.115   158.891     0.150
     4.970    76.090     0.150
     4.970   130.988     0.150
     4.970   153.789     0.150
     5.281    79.988     0.150
     5.281   138.391     0.150
     5.281   163.688     0.150
     5.281    79.688     0.150
     5.281   139.988     0.150
     5.281   164.488     0.150
     5.304   140.391     0.150
     5.304   164.289     0.150
     5.304    80.188     0.150
     5.304   163.891     0.150
     5.336    80.789     0.150
     5.336   139.688     0.150
     5.336   164.090     0.150
     5.559    83.590     0.150
     5.559   146.289     0.150
     5.559   170.391     0.150
     5.992    89.891     0.150
     5.992   155.289     0.150
     5.992   185.090     0.150
     5.976    88.508     0.150
     5.976   156.582     0.150
     5.976   183.184     0.150
     5.976    88.988     0.150
     5.976   184.289     0.150
     5.976    88.758     0.150
     5.976    89.098     0.150
     6.083    90.590     0.150
     6.083   158.391     0.150
     6.083   189.488     0.150
     6.083    90.488     0.150
     6.369    94.391     0.150
     6.369   165.488     0.150
     6.369   196.090     0.150
     7.106   105.289     0.150
     7.106   105.590     0.150
     7.219   107.488     0.150
     7.331   109.090     0.150
     7.331   225.488     0.150
     7.789   199.688     0.150
     7.789   241.289     0.150
     8.130   207.238     0.150
     8.130   254.590     0.150
     8.248   121.590     0.150
     8.248   209.188     0.150
     8.248   121.988     0.150
     8.248   121.738     0.150
     8.248   122.250     0.150
     8.359   119.891     0.150
     8.359   213.289     0.150
     8.359   120.289     0.150
     8.408   124.328     0.150
     8.408   153.910     0.150
     8.408   263.160     0.150
     8.408   123.688     0.150
     9.583   139.391     0.150
     9.602   141.090     0.150
    11.271   161.789     0.150
    11.500   161.957     0.150
    11.500   290.508     0.150
    11.500   352.008     0.150
    11.500   288.090     0.150
    11.500   161.750     0.150
    14.161   201.105     0.150
    14.161   440.309     0.150
    14.161   201.391     0.150
    14.354   204.090     0.150
    14.888   213.289     0.150
    15.010   219.090     0.150
    15.091   215.590     0.150
    15.091   222.289     0.150
    15.185   213.738     0.150
    15.185   213.801     0.150
    15.185   214.488     0.150
    15.185   213.398     0.150
    15.932   226.688     0.150
    15.983   227.988     0.150
    15.983   230.789     0.150
    16.077   227.688     0.150
    17.248   531.863     0.150
    17.366   242.590     0.150
    17.651   247.090     0.150
    17.651   246.828     0.150
    17.651   553.703     0.150
    17.899   251.789     0.150
    18.165   252.188     0.150
    18.425   256.590     0.150
    18.496   259.188     0.150
    19.107   265.488     0.150
    19.107   275.289     0.150
    19.155   263.090     0.150
    19.934   272.391     0.150
    19.934   271.480     0.150
    19.934   497.488     0.150
    19.934   272.699     0.150
    19.965   272.188     0.150
    19.965   272.738     0.150
    19.965   629.891     0.150
    20.028   273.516     0.150
    20.028   497.488     0.150
    20.128   275.230     0.150
    20.247   280.289     0.150
    20.247   284.590     0.150
    20.399   280.113     0.150
    21.065   284.789     0.150
    21.368   289.082     0.150
    21.368   289.391     0.150
    21.368   287.328     0.150
    21.368   287.988     0.150
    21.499   289.488     0.150
    21.499   522.789     0.150
    21.535   289.891     0.150
    21.535   291.418     0.150
    21.732   292.688     0.150
    21.943   295.891     0.150
    21.943   685.516     0.150
    22.447   299.891     0.150
    23.204   306.891     0.150
    23.597   310.891     0.150
    23.597   568.656     0.150
    23.598   311.590     0.150
    23.628   311.289     0.150
    23.628   311.129     0.150
    23.714   312.391     0.150
    23.714   312.188     0.150
    23.842   311.188     0.150
    24.053   315.391     0.150
    24.085   315.590     0.150
    24.292   320.188     0.150
    24.477   319.090     0.150
    24.697   322.027     0.150
    24.872   326.129     0.150
    25.063   327.891     0.150
    25.277   329.488     0.150
    25.334   329.289     0.150
    25.714   329.789     0.150
    25.714   333.379     0.150
    25.772   329.891     0.150
    25.772   333.168     0.150
    26.098   335.898     0.150
    26.199   336.469     0.150
    26.473   339.418     0.150
    26.511   341.867     0.150
    26.630   341.199     0.150
    26.702   340.590     0.150
    26.875   342.188     0.150
    26.875   341.621     0.150
    26.875   340.617     0.150
    26.892   343.508     0.150
    26.892   342.891     0.150
    26.892   341.910     0.150
    26.892   343.648     0.150
    26.972   344.930     0.150
    27.271   346.859     0.150
    27.502   347.891     0.150
    27.770   348.789     0.150
    28.476   354.891     0.150
    28.754   360.188     0.150
    28.823   358.383     0.150
    28.823   358.590     0.150
    28.823   406.789     0.150
    28.823   649.688     0.150
    28.823   729.391     0.150
    28.823   356.969     0.150
    28.796   357.688     0.150
    28.796   357.891     0.150
    29.221   363.789     0.150
    29.689   365.688     0.150
    30.542   372.988     0.150
    31.166   379.090     0.150
    31.166   379.340     0.150
    31.166   378.527     0.150
    31.625   383.391     0.150
    32.761   394.551     0.150
    32.761   396.590     0.150
    33.780   403.160     0.150
    34.136   406.090     0.150
    36.111   422.590     0.150
    36.111   566.289     0.150
    36.221   421.488     0.150
    36.225   423.391     0.150
    37.126   430.730     0.150
    37.493   431.391     0.150
    38.063   438.012     0.150
    38.318   441.652     0.150
    38.318   532.703     0.150
    38.318   442.488     0.150
    39.951   453.488     0.150
    40.372   457.590     0.150
    40.372   554.988     0.150
    40.591   458.188     0.150
    40.977   462.488     0.150
    41.261   463.891     0.150
    41.342   464.391     0.150
    41.673   468.242     0.150
    41.673   468.488     0.150
    41.673   467.688     0.150
    42.308   473.551     0.150
    43.003   478.918     0.150
    43.364   482.090     0.150
    43.482   482.641     0.150
    43.663   483.090     0.150
    43.863   487.988     0.150
    43.863   486.379     0.150
    43.863   488.188     0.150
    43.863   488.500     0.150
    43.895   487.488     0.150
    43.895   487.688     0.150
    44.016   487.590     0.150
    44.016   485.438     0.150
    44.016   485.789     0.150
    44.021   489.988     0.150
    44.308   489.891     0.150
    44.921   495.129     0.150
    44.867   494.789     0.150
    44.867   599.688     0.150
    44.867   892.590     0.150
    44.867  1095.289     0.150
    45.056   496.527     0.150
    45.094   496.828     0.150
    45.107   497.211     0.150
    45.646   499.988     0.150
    45.710   501.930     0.150
    45.729   501.488     0.150
    45.729   610.090     0.150
    45.729   906.090     0.150
    45.729  1097.789     0.150
    46.030   504.590     0.150
    46.551   507.391     0.150
    46.566   508.141     0.150
    46.566   507.488     0.150
    46.566   506.988     0.150
    46.578   507.391     0.150
    46.578   506.988     0.150
    46.581   507.789     0.150
    46.591   507.789     0.150
    46.594   507.789     0.150
    46.603   507.789     0.150
    46.603   507.789     0.150
    46.607   507.891     0.150
    46.608   507.891     0.150
    46.618   507.988     0.150
    46.628   507.988     0.150
    47.344   513.258     0.150
    47.538   514.988     0.150
    47.538   516.059     0.150
    47.680   516.391     0.150
    47.680   516.113     0.150
    47.722   517.090     0.150
    47.717   516.949     0.150
    47.788   518.188     0.150
    47.788   517.391     0.150
    47.843   517.789     0.150
    47.885   517.988     0.150
    48.008   517.980     0.150
    48.724   524.488     0.150
    48.850   525.758     0.150
    48.995   525.750     0.150
    49.325   529.590     0.150
    49.459   530.008     0.150
    50.425   539.090     0.150
    51.535   547.578     0.150
    51.684   548.590     0.150
    51.684   548.738     0.150
    51.689   548.391     0.150
    51.695   548.488     0.150
    51.701   548.488     0.150
    51.701     3.000     0.150
    52.046   551.910     0.150
    52.170   551.891     0.150
    52.170   552.750     0.150
    53.752   563.688     0.150
    53.767   563.488     0.150
    53.766   563.461     0.150
    54.606   569.891     0.150
    54.606     2.797     0.150
    55.012   571.488     0.150
    55.165   573.555     0.150
    55.524   576.289     0.150
    55.647   576.992     0.150
    55.598   577.309     0.150
    56.863   583.715     0.150
    57.035   585.422     0.150
    57.165   588.488     0.150
    57.929   591.180     0.150
    58.422   597.090     0.150
    58.372   597.488     0.150
    58.895   599.590     0.150
    58.895   600.879     0.150
    64.102   633.289     0.150
    69.794   670.590     0.150
    70.123   671.461     0.150
    70.142   673.789     0.150
    71.026   677.527     0.150
    71.572   681.898     0.150
    72.042   682.988     0.150
    72.776   689.109     0.150
    73.647   693.449     0.150
    74.095   695.770     0.150
    74.347   697.109     0.150
    74.561   700.141     0.150
    74.561   699.770     0.150
    76.024   707.738     0.150
    76.207   709.812     0.150
    77.238   716.020     0.150
    77.910   718.590     0.150
    77.910   718.180     0.150
    77.916   718.391     0.150
    81.435   737.891     0.150
    81.435   737.730     0.150
    82.221   742.090     0.150
    83.530   746.789     0.150
    88.467   772.219     0.150
    88.500   772.520     0.150
    89.787   779.652     0.150
    89.787   779.000     0.150
    90.242   782.859     0.150
   128.099  1146.312     0.150
   136.637  1160.266     0.150
   145.482  1177.359     0.150
   145.482  1177.461     0.150
   149.440  1188.938     0.150
   149.440  1188.391     0.150
   150.146  1187.512     0.150
   150.425  1191.637     0.150
   150.891  1191.527     0.150
   164.962  1260.766     0.150
     0.303     6.072     0.150
     0.303    10.272     0.150
     0.663    12.872     0.150
     0.663    22.472     0.150
     0.663    12.472     0.150
     0.979    18.072     0.150
     0.979    31.472     0.150
     0.979    31.272     0.150
     1.331    24.072     0.150
     1.331    41.772     0.150
     1.331    23.772     0.150
     1.331    41.572     0.150
     1.641    28.972     0.150
     1.641    51.272     0.150
     1.641    49.872     0.150
     1.730    29.772     0.150
     1.730    52.072     0.150
     1.730    30.072     0.150
     2.070    34.972     0.150
     2.070    37.172     0.150
     2.070    64.672     0.150
     2.070    36.772     0.150
     2.070    60.872     0.150
     2.070    63.172     0.150
     2.450    40.072     0.150
     2.450    44.472     0.150
     2.450    76.072     0.150
     2.450    44.672     0.150
     2.582    42.072     0.150
     2.582    46.372     0.150
     2.582    73.372     0.150
     2.582    80.472     0.150
     2.582    41.672     0.150
     2.582    45.872     0.150
     3.401    52.772     0.150
     3.401    60.572     0.150
     3.401   105.472     0.150
     3.401    61.872     0.150
     3.363    52.972     0.150
     3.363    60.072     0.150
     3.363   104.272     0.150
     3.456    60.672     0.150
     3.456   105.072     0.150
     3.745    57.672     0.150
     3.745    67.372     0.150
     3.745   116.172     0.150
     4.094    63.572     0.150
     4.094   128.172     0.150
     4.094    61.272     0.150
     4.094   127.772     0.150
     4.207    64.072     0.150
     4.207    75.872     0.150
     4.207   131.372     0.150
     4.235    64.272     0.150
     4.235    75.572     0.150
     4.235   130.872     0.150
     4.488    67.972     0.150
     4.488    80.172     0.150
     4.488   118.372     0.150
     4.488   138.672     0.150
     4.488    67.472     0.150
     4.488    79.772     0.150
     4.488   138.272     0.150
     4.599    68.672     0.150
     4.599    82.872     0.150
     4.599   143.572     0.150
     4.615    68.972     0.150
     4.615   142.672     0.150
     4.848    72.872     0.150
     4.848    87.272     0.150
     4.848   150.072     0.150
     5.394    79.972     0.150
     5.394    96.772     0.150
     5.394   167.772     0.150
     5.622    83.472     0.150
     5.622   100.872     0.150
     5.622   144.972     0.150
     5.622   173.872     0.150
     5.622   148.072     0.150
     5.687    83.972     0.150
     5.687    91.972     0.150
     5.687   102.172     0.150
     5.687   176.772     0.150
     5.921    87.572     0.150
     5.921   184.072     0.150
     5.967   107.772     0.150
     5.967   185.472     0.150
     6.031    88.972     0.150
     6.031   187.472     0.150
     6.153    90.872     0.150
     6.153   111.572     0.150
     6.153   191.872     0.150
     6.526   117.772     0.150
     6.526   202.472     0.150
     6.486    94.472     0.150
     6.486   117.472     0.150
     6.486   166.372     0.150
     6.486   201.772     0.150
     6.486   168.672     0.150
     6.910   100.272     0.150
     6.910   124.472     0.150
     6.910   214.372     0.150
     6.938   214.872     0.150
     7.150   103.972     0.150
     7.150   128.372     0.150
     7.150   221.872     0.150
     7.388   105.297     0.150
     7.388   231.172     0.150
     7.594   109.365     0.150
     7.594   109.872     0.150
     7.594   235.372     0.150
     7.594   109.702     0.150
     7.594   108.872     0.150
     7.648   108.372     0.150
     7.648   193.572     0.150
     7.648   237.972     0.150
     7.648   109.582     0.150
     7.648   109.082     0.150
     7.938   114.572     0.150
     8.645   126.172     0.150
     8.645   155.872     0.150
     8.645   267.672     0.150
     8.645   267.372     0.150
     8.917   128.572     0.150
     8.917   276.172     0.150
     9.076   130.572     0.150
     9.076   278.872     0.150
     9.312   133.742     0.150
     9.312   134.472     0.150
     9.312   134.832     0.150
     9.534   137.392     0.150
     9.534   296.653     0.150
     9.534   136.592     0.150
     9.534   137.872     0.150
     9.897   141.872     0.150
     9.973   139.241     0.150
     9.973   303.016     0.150
     9.973   139.372     0.150
     9.973   252.272     0.150
     9.973   139.532     0.150
    11.320   160.372     0.150
    12.274   176.372     0.150
    12.707   180.390     0.150
    12.707   397.240     0.150
    12.707   181.072     0.150
    13.312   187.172     0.150
    14.305   202.772     0.150
    15.115   217.752     0.150
    15.347   216.372     0.150
    15.610   225.372     0.150
    15.610   399.372     0.150
    16.057   226.672     0.150
    16.057   233.872     0.150
    16.145   225.182     0.150
    16.466   228.192     0.150
    16.466   230.472     0.150
    16.466   231.247     0.150
    16.466   514.347     0.150
    16.821   404.216     0.150
    16.821   519.366     0.150
    16.868   233.732     0.150
    16.868   233.722     0.150
    16.868   524.289     0.150
    16.868   234.572     0.150
    17.244   239.272     0.150
    17.781   547.622     0.150
    18.707   472.872     0.150
    19.140   263.372     0.150
    19.140   268.872     0.150
    19.662   267.372     0.150
    19.994   274.372     0.150
    20.330   275.047     0.150
    20.808   282.672     0.150
    20.808   287.372     0.150
    20.808   290.872     0.150
    20.839   281.672     0.150
    20.839   658.022     0.150
    20.839   282.472     0.150
    21.351   288.347     0.150
    21.351   676.819     0.150
    21.574   535.372     0.150
    21.653   289.312     0.150
    21.653   288.772     0.150
    21.653   289.412     0.150
    21.722   290.572     0.150
    21.722   290.422     0.150
    21.748   289.722     0.150
    21.885   291.812     0.150
    21.885   292.232     0.150
    22.343   298.172     0.150
    23.338   306.512     0.150
    23.815   311.872     0.150
    23.815   569.172     0.150
    24.267   317.872     0.150
    25.212   324.122     0.150
    25.118   324.472     0.150
    25.118   324.647     0.150
    25.242   325.222     0.150
    25.242   324.072     0.150
    25.466   327.352     0.150
    26.209   335.172     0.150
    26.205   334.252     0.150
    26.346   335.222     0.150
    26.346   335.072     0.150
    26.344   335.432     0.150
    27.080   343.272     0.150
    27.464   348.412     0.150
    28.649   355.632     0.150
    28.649   355.472     0.150
    28.649   356.482     0.150
    28.722   358.262     0.150
    28.925   358.172     0.150
    30.244   367.072     0.150
    30.500   373.372     0.150
    30.548   372.322     0.150
    32.006   385.672     0.150
    32.298   389.792     0.150
    32.431   390.012     0.150
    32.786   391.252     0.150
    32.786   391.212     0.150
    33.794   400.872     0.150
    35.533   416.112     0.150
    35.533   417.482     0.150
    35.864   418.442     0.150
    35.864   419.862     0.150
    36.708   426.362     0.150
    37.332   429.172     0.150
    37.415   431.472     0.150
    37.415   432.042     0.150
    37.852   435.362     0.150
    37.883   434.962     0.150
    38.111   437.712     0.150
    38.727   440.972     0.150
    38.798   443.972     0.150
    39.279   448.309     0.150
    40.059   452.362     0.150
    40.234   455.572     0.150
    40.419   456.582     0.150
    40.432   457.222     0.150
    40.464   457.782     0.150
    40.493   458.272     0.150
    40.577   458.992     0.150
    40.754   460.752     0.150
    40.961   462.152     0.150
    41.247   464.262     0.150
    41.259   463.762     0.150
    41.365   462.072     0.150
    41.583   465.742     0.150
    41.665   466.362     0.150
    41.944   466.572     0.150
    42.170   471.522     0.150
    42.233   470.262     0.150
    42.241   471.642     0.150
    42.639   474.272     0.150
    42.649   472.672     0.150
    42.736   473.972     0.150
    43.240   480.162     0.150
    43.349   480.202     0.150
    43.463   862.972     0.150
    43.645   482.712     0.150
    43.700   482.392     0.150
    43.708   484.252     0.150
    43.818   484.852     0.150
    44.083   485.072     0.150
    44.083   484.882     0.150
    44.145   487.752     0.150
    44.323   488.872     0.150
    44.323   489.382     0.150
    44.338   489.572     0.150
    44.478   489.682     0.150
    44.488   489.482     0.150
    44.647   492.002     0.150
    44.712   491.402     0.150
    44.712   492.322     0.150
    44.712   492.022     0.150
    45.109   495.392     0.150
    45.423   497.982     0.150
    45.423   497.872     0.150
    45.423   497.472     0.150
    45.423   498.832     0.150
    45.460   498.347     0.150
    45.391   497.712     0.150
    45.584   499.572     0.150
    45.607   499.112     0.150
    45.878   502.672     0.150
    45.874   500.982     0.150
    45.912   500.062     0.150
    46.051   502.572     0.150
    46.051   609.772     0.150
    46.051   908.372     0.150
    46.051  1111.952     0.150
    46.068   502.522     0.150
    46.193   502.942     0.150
    46.399   504.522     0.150
    46.894   511.172     0.150
    46.894   509.072     0.150
    47.061   510.512     0.150
    47.151   511.482     0.150
    47.538   514.492     0.150
    47.839   515.472     0.150
    47.854   515.497     0.150
    47.854   515.872     0.150
    47.854   516.272     0.150
    47.854   515.872     0.150
    47.866   515.672     0.150
    47.882   515.872     0.150
    47.884   515.972     0.150
    47.888   515.872     0.150
    47.892   515.972     0.150
    48.075   516.942     0.150
    48.214   517.717     0.150
    48.267   518.622     0.150
    48.495   520.572     0.150
    48.495   520.522     0.150
    48.588   521.232     0.150
    48.955   524.372     0.150
    49.023   524.872     0.150
    48.961   526.082     0.150
    49.076   525.372     0.150
    49.080   525.072     0.150
    49.310   528.862     0.150
    49.355   529.802     0.150
    49.509   530.832     0.150
    49.676   531.112     0.150
    50.001   532.172     0.150
    50.624   536.672     0.150
    51.656   544.872     0.150
    51.847   546.562     0.150
    51.883   546.962     0.150
    52.350   550.872     0.150
    52.350   551.142     0.150
    52.575   551.672     0.150
    52.566   552.352     0.150
    52.666   553.332     0.150
    52.795   554.612     0.150
    52.745   553.462     0.150
    52.918   554.972     0.150
    53.032   555.572     0.150
    53.213   557.072     0.150
    53.213   557.272     0.150
    53.213   557.522     0.150
    53.213   557.772     0.150
    53.225   557.472     0.150
    53.230   556.672     0.150
    53.286   558.332     0.150
    53.502   559.472     0.150
    53.671   561.232     0.150
    53.685   559.972     0.150
    53.689   560.372     0.150
    53.906   561.772     0.150
    53.906   562.422     0.150
    53.974   563.072     0.150
    54.028   563.612     0.150
    54.030   563.572     0.150
    54.030   563.782     0.150
    54.052   563.172     0.150
    54.253   565.372     0.150
    54.253   564.992     0.150
    54.517   567.472     0.150
    54.623   567.082     0.150
    54.672   566.872     0.150
    54.679   568.032     0.150
    54.622   567.082     0.150
    54.735   567.372     0.150
    54.758   567.772     0.150
    54.758   566.552     0.150
    54.879   570.172     0.150
    54.941   569.472     0.150
    54.941   570.182     0.150
    55.173   571.172     0.150
    55.173   570.832     0.150
    55.192   571.272     0.150
    55.659   574.952     0.150
    55.790   576.395     0.150
    55.818   575.372     0.150
    55.760   573.772     0.150
    55.838   575.782     0.150
    55.820   574.547     0.150
    55.820   574.262     0.150
    55.858   574.332     0.150
    55.992   578.040     0.150
    56.014   576.772     0.150
    56.018   578.172     0.150
    56.045   577.772     0.150
    56.132   578.972     0.150
    56.132   578.472     0.150
    56.132   577.472     0.150
    56.292   579.572     0.150
    56.292   579.147     0.150
    56.292   579.342     0.150
    56.292   579.472     0.150
    56.677   582.670     0.150
    56.723   582.137     0.150
    56.738   583.272     0.150
    56.791   583.170     0.150
    56.851   584.162     0.150
    57.189   586.113     0.150
    57.211   586.613     0.150
    57.329   587.351     0.150
    57.675   590.001     0.150
    57.783   590.980     0.150
    57.789   588.872     0.150
    57.789   589.672     0.150
    57.816   590.840     0.150
    57.818   589.442     0.150
    57.992   591.850     0.150
    58.059   590.972     0.150
    58.167   592.132     0.150
    58.367   594.547     0.150
    58.396   595.072     0.150
    58.566   595.672     0.150
    58.605   595.971     0.150
    58.616   596.174     0.150
    58.671   595.152     0.150
    58.847   595.722     0.150
    58.898   597.202     0.150
    58.900   597.312     0.150
    58.908   597.532     0.150
    58.908   598.032     0.150
    58.978   599.063     0.150
    59.132   598.592     0.150
    59.132   727.082     0.150
    59.375   601.832     0.150
    59.491   601.772     0.150
    59.569   601.582     0.150
    59.689   604.322     0.150
    60.004   604.872     0.150
    60.018   606.572     0.150
    63.294   626.282     0.150
    63.989   632.162     0.150
    64.287   632.542     0.150
    65.678   641.982     0.150
    65.678   642.872     0.150
    65.678   642.532     0.150
    67.286   653.042     0.150
    67.336   653.842     0.150
    67.565   654.602     0.150
    67.605   653.962     0.150
    67.605   655.142     0.150
    68.170   658.752     0.150
    68.423   660.402     0.150
    68.437   660.392     0.150
    68.495   660.982     0.150
    68.567   661.472     0.150
    68.777   663.302     0.150
    68.903   663.622     0.150
    69.297   666.492     0.150
    69.432   666.047     0.150
    69.432   665.732     0.150
    69.426   667.522     0.150
    69.554   667.012     0.150
    69.582   667.212     0.150
    70.210   672.752     0.150
    70.248   671.372     0.150
    71.145   677.297     0.150
    71.145   677.772     0.150
    71.135   675.757     0.150
    71.135   676.072     0.150
    71.158   678.252     0.150
    71.604   680.842     0.150
    71.635   680.212     0.150
    71.963   682.612     0.150
    72.029   683.112     0.150
    72.209   684.352     0.150
    72.531   686.292     0.150
    72.600   686.542     0.150
    72.612   686.792     0.150
    72.657   685.692     0.150
    72.911   689.182     0.150
    73.039   689.152     0.150
    73.287   690.762     0.150
    73.594   692.582     0.150
    74.786   698.132     0.150
    74.827   697.042     0.150
    74.827   698.672     0.150
    74.827   699.122     0.150
    75.102   700.852     0.150
    75.102   701.062     0.150
    75.270   702.272     0.150
    75.277   702.392     0.150
    75.393   702.922     0.150
    75.872   706.247     0.150
    76.574   709.192     0.150
    76.618   709.522     0.150
    77.217   712.272     0.150
    77.644   715.872     0.150
    77.644   714.422     0.150
    77.720   715.052     0.150
    77.694   714.352     0.150
    77.931   716.722     0.150
    78.222   717.402     0.150
    78.277   719.162     0.150
    78.453   720.252     0.150
    78.458   718.382     0.150
    78.703   720.702     0.150
    78.703   722.012     0.150
    78.705   720.282     0.150
    79.012   723.882     0.150
    79.042   723.652     0.150
    79.066   723.012     0.150
    79.075   723.722     0.150
    79.125   722.242     0.150
    79.171   723.932     0.150
    79.214   723.952     0.150
    79.259   724.142     0.150
    79.378   725.242     0.150
    80.887   733.372     0.150
    81.207   734.072     0.150
    81.521   735.402     0.150
    81.773   737.502     0.150
    81.801   736.912     0.150
    82.966   743.962     0.150
    82.966   742.732     0.150
    82.966   744.372     0.150
    82.966   743.532     0.150
    84.181   751.342     0.150
    84.440   750.322     0.150
    84.453   751.192     0.150
    84.453   751.782     0.150
    84.471   751.012     0.150
    84.571   750.882     0.150
    84.790   752.222     0.150
    85.286   756.222     0.150
    85.357   755.462     0.150
    85.372   755.032     0.150
    85.372     1.710     0.150
    85.538   754.892     0.150
    86.256   760.352     0.150
    86.256   760.532     0.150
    86.493   761.362     0.150
    86.604   761.912     0.150
    87.459   764.612     0.150
    87.467   765.852     0.150
    87.609   766.722     0.150
    88.092   769.962     0.150
    88.770   772.032     0.150
    89.037   773.797     0.150
    89.037   774.082     0.150
    89.465   776.062     0.150
    91.196   783.247     0.150
    91.196   782.812     0.150
    91.278   783.822     0.150
   136.586  1159.107     0.150
   145.171  1174.472     0.150
   145.853  1176.091     0.150
   146.543  1178.842     0.150
   146.648  1179.952     0.150
   148.345  1184.054     0.150
   149.619  1186.672     0.150
   149.619  1187.072     0.150
   151.452  1190.736     0.150
     0.245     5.172     0.150
     0.245     8.672     0.150
     0.245     9.773     0.150
     0.399     8.070     0.150
     0.399    13.867     0.150
     0.399     7.969     0.150
     1.389    25.773     0.150
     1.389    44.273     0.150
     1.389    25.469     0.150
     1.389    47.469     0.150
     1.282    24.367     0.150
     1.282    45.273     0.150
     1.658    29.773     0.150
     1.658    52.273     0.150
     1.968    34.172     0.150
     1.968    35.070     0.150
     1.968    60.367     0.150
     1.968    60.469     0.150
     2.220    37.570     0.150
     2.220    39.469     0.150
     2.220    67.773     0.150
     2.220    40.172     0.150
     2.220    69.172     0.150
     2.856    46.969     0.150
     2.856    52.273     0.150
     2.856    89.570     0.150
     2.856    47.469     0.150
     2.856    52.672     0.150
     2.856    89.969     0.150
     3.000    50.172     0.150
     3.000    54.969     0.150
     3.000    93.969     0.150
     3.000    48.672     0.150
     3.000    54.867     0.150
     3.763    59.773     0.150
     3.763   103.273     0.150
     3.763    68.273     0.150
     3.763   117.773     0.150
     3.800    59.367     0.150
     3.800    67.867     0.150
     3.800   103.469     0.150
     3.800   118.273     0.150
     3.865    58.672     0.150
     3.865    69.570     0.150
     3.865   105.773     0.150
     3.865   119.969     0.150
     3.865    61.070     0.150
     3.865    69.867     0.150
     3.865   104.969     0.150
     3.865   120.273     0.150
     3.992    62.570     0.150
     3.992    72.070     0.150
     3.992   108.867     0.150
     3.992   125.469     0.150
     3.992    62.273     0.150
     3.992   108.469     0.150
     3.992   125.172     0.150
     4.076    63.469     0.150
     4.076    73.570     0.150
     4.076   125.070     0.150
     4.076    62.773     0.150
     4.076    73.469     0.150
     4.076   126.469     0.150
     4.203    65.172     0.150
     4.203    76.070     0.150
     4.203   130.273     0.150
     4.442    69.469     0.150
     4.442    80.469     0.150
     4.442   138.172     0.150
     4.620    71.367     0.150
     4.620   143.867     0.150
     4.985   155.172     0.150
     5.211    79.367     0.150
     5.211   137.570     0.150
     5.211   159.867     0.150
     5.211    79.172     0.150
     5.211   136.273     0.150
     5.211   161.367     0.150
     5.287    80.672     0.150
     5.287   138.867     0.150
     5.287   164.469     0.150
     5.514    82.672     0.150
     5.514   170.570     0.150
     5.559    84.867     0.150
     5.559   172.570     0.150
     5.599    83.672     0.150
     5.599   173.367     0.150
     5.750    86.969     0.150
     5.750   179.070     0.150
     6.015   186.570     0.150
     6.115    92.672     0.150
     6.115   189.172     0.150
     6.220    92.570     0.150
     6.220   192.469     0.150
     6.220   193.773     0.150
     6.420   166.070     0.150
     6.420   190.867     0.150
     6.420   199.570     0.150
     6.499    96.867     0.150
     6.499   167.969     0.150
     6.499   201.570     0.150
     6.527    96.469     0.150
     6.527   201.672     0.150
     6.527   201.867     0.150
     6.738    99.773     0.150
     6.738   207.867     0.150
     7.182   104.812     0.150
     7.182   220.312     0.150
     7.182   107.070     0.150
     7.182   106.562     0.150
     7.182   106.867     0.150
     7.182   222.273     0.150
     7.388   106.617     0.150
     7.388   192.648     0.150
     7.388   231.492     0.150
     7.641   196.469     0.150
     7.641   236.867     0.150
     7.636   113.570     0.150
     7.636   195.867     0.150
     7.636   124.672     0.150
     7.636   236.773     0.150
     8.242   120.969     0.150
     8.234   254.773     0.150
     8.509   125.273     0.150
     8.509   124.469     0.150
     8.509   262.969     0.150
     8.678   126.469     0.150
     8.678   220.672     0.150
     8.678   269.172     0.150
     8.950   132.172     0.150
     8.950   130.977     0.150
     8.950   131.367     0.150
     8.950   162.070     0.150
     8.950   277.570     0.150
     8.950   131.930     0.150
     9.164   133.672     0.150
     9.164   166.508     0.150
     9.164   287.312     0.150
     9.164   132.891     0.150
    10.096   145.172     0.150
    10.377   148.828     0.150
    10.377   148.211     0.150
    10.377   183.688     0.150
    10.377   262.867     0.150
    10.767   155.773     0.150
    10.767   193.867     0.150
    10.767   332.070     0.150
    10.914   160.070     0.150
    12.936   184.062     0.150
    12.936   320.664     0.150
    12.936   185.367     0.150
    15.092   215.172     0.150
    15.229   215.477     0.150
    15.881   231.070     0.150
    15.970   224.172     0.150
    16.609   235.969     0.150
    16.609   230.594     0.150
    16.609   232.922     0.150
    16.609   409.969     0.150
    16.539   231.594     0.150
    16.539   232.969     0.150
    16.539   516.375     0.150
    16.539   231.422     0.150
    16.860   236.969     0.150
    17.128   533.289     0.150
    17.832   249.570     0.150
    17.832   446.570     0.150
    19.827   273.367     0.150
    20.193   275.570     0.150
    20.193   274.711     0.150
    20.430   276.969     0.150
    20.430   276.289     0.150
    20.398   281.367     0.150
    20.398   287.172     0.150
    20.531   281.867     0.150
    20.742   281.773     0.150
    20.847   282.969     0.150
    20.847   282.672     0.150
    20.847   658.000     0.150
    20.856   284.172     0.150
    20.856   289.867     0.150
    21.014   284.719     0.150
    21.014   666.398     0.150
    21.305   288.172     0.150
    21.305   286.602     0.150
    21.305   288.461     0.150
    21.335   289.469     0.150
    21.335   289.445     0.150
    21.335   670.500     0.150
    21.335   287.867     0.150
    21.399   289.195     0.150
    21.499   289.172     0.150
    22.064   297.969     0.150
    24.912   324.367     0.150
    24.942   325.172     0.150
    24.942   323.883     0.150
    25.070   325.172     0.150
    25.197   326.570     0.150
    25.506   327.719     0.150
    25.414   331.773     0.150
    25.443   331.773     0.150
    25.443   599.867     0.150
    25.587   327.617     0.150
    25.699   330.469     0.150
    25.836   335.367     0.150
    25.836   335.469     0.150
    26.065   336.070     0.150
    26.228   335.812     0.150
    26.509   341.367     0.150
    26.741   341.273     0.150
    26.493   341.773     0.150
    26.648   342.773     0.150
    27.067   343.570     0.150
    27.131   343.750     0.150
    28.263   354.867     0.150
    28.263   353.102     0.150
    28.263   357.383     0.150
    28.326   357.359     0.150
    29.854   370.867     0.150
    29.981   369.867     0.150
    30.014   370.867     0.150
    30.014   427.273     0.150
    30.101   372.672     0.150
    30.175   371.172     0.150
    30.175   370.969     0.150
    31.194   382.867     0.150
    32.485   390.023     0.150
    32.921   394.297     0.150
    33.611   401.773     0.150
    36.021   423.227     0.150
    37.196   429.469     0.150
    37.444   434.281     0.150
    40.816   461.344     0.150
    41.455   465.969     0.150
    41.455   567.172     0.150
    42.477   474.547     0.150
    42.544   477.023     0.150
    42.544   475.078     0.150
    42.847   478.500     0.150
    43.114   480.633     0.150
    43.727   485.242     0.150
    44.113   489.648     0.150
    44.025   488.469     0.150
    44.025   591.172     0.150
    44.191   490.203     0.150
    44.607   493.031     0.150
    44.503   490.773     0.150
    44.861   494.070     0.150
    45.146   498.172     0.150
    45.146   497.664     0.150
    45.146   499.430     0.150
    45.182   497.367     0.150
    45.306   499.867     0.150
    45.336   497.969     0.150
    45.473   500.664     0.150
    45.372   498.070     0.150
    45.996   503.992     0.150
    46.120   505.953     0.150
    46.273   505.523     0.150
    46.461   507.867     0.150
    46.590   509.672     0.150
    46.766   508.914     0.150
    46.766   510.867     0.150
    46.771   512.711     0.150
    46.998   511.969     0.150
    46.998   925.273     0.150
    47.668   517.469     0.150
    47.668   517.773     0.150
    47.668   516.172     0.150
    47.680   518.078     0.150
    47.922   518.578     0.150
    48.441   522.992     0.150
    50.645   542.758     0.150
    52.617   555.570     0.150
    52.948   556.469     0.150
    52.948   558.219     0.150
    52.948   557.414     0.150
    53.114   559.312     0.150
    53.308   562.273     0.150
    53.758   564.172     0.150
    54.015   567.570     0.150
    54.524   570.367     0.150
    54.636   570.070     0.150
    54.793   571.773     0.150
    54.858   572.180     0.150
    55.029   574.570     0.150
    55.638   578.109     0.150
    55.655   579.438     0.150
    55.837   580.164     0.150
    55.996   578.969     0.150
    55.996   579.203     0.150
    55.996   580.172     0.150
    56.000   581.008     0.150
    56.000   579.867     0.150
    56.164   579.422     0.150
    56.164   580.672     0.150
    56.154   580.172     0.150
    56.154   580.367     0.150
    56.522   583.266     0.150
    56.602   586.172     0.150
    56.645   585.289     0.150
    56.724   588.094     0.150
    57.059   589.195     0.150
    57.521   591.578     0.150
    57.521   591.039     0.150
    57.637   591.992     0.150
    57.674   591.742     0.150
    57.752   590.922     0.150
    58.229   596.773     0.150
    58.260   594.930     0.150
    58.479   596.820     0.150
    58.544   596.672     0.150
    58.544   597.758     0.150
    58.842   600.508     0.150
    59.707   607.969     0.150
    59.707   608.469     0.150
    61.894   619.891     0.150
    62.144   622.070     0.150
    63.057   627.773     0.150
    69.652   669.570     0.150
    71.117   678.750     0.150
    71.043   678.594     0.150
    71.043   679.328     0.150
    75.195   701.922     0.150
    75.455   704.172     0.150
    75.455   705.180     0.150
    75.651   708.070     0.150
    76.263   710.398     0.150
    76.455   711.430     0.150
    77.550   716.789     0.150
    77.565   716.172     0.150
    77.565   716.469     0.150
    81.112   735.672     0.150
    81.112   735.164     0.150
    83.337   748.570     0.150
    89.407   777.148     0.150
   145.636  1177.938     0.150
   145.636  1177.602     0.150
   149.732  1190.070     0.150
   151.360  1193.273     0.150
   151.804  1193.844     0.150
     0.239     5.172     0.150
     0.239     9.672     0.150
     0.239     8.971     0.150
     0.984    18.471     0.150
     0.984    31.771     0.150
     0.984    18.172     0.150
     1.250    22.871     0.150
     1.250    42.371     0.150
     1.411    25.672     0.150
     1.411    44.771     0.150
     1.642    29.771     0.150
     1.642    52.572     0.150
     1.959    34.072     0.150
     1.959    34.971     0.150
     1.959    59.871     0.150
     2.189    37.971     0.150
     2.189    39.371     0.150
     2.189    67.271     0.150
     2.879    47.172     0.150
     2.879    52.172     0.150
     2.879    89.871     0.150
     2.879    47.471     0.150
     2.879    52.471     0.150
     2.989    48.871     0.150
     2.989    53.971     0.150
     2.989    92.271     0.150
     2.989    52.971     0.150
     3.788    58.871     0.150
     3.788    68.672     0.150
     3.788   102.672     0.150
     3.788   117.871     0.150
     3.786    59.771     0.150
     3.786    67.971     0.150
     3.786   118.371     0.150
     3.879    60.572     0.150
     3.879    69.572     0.150
     3.879   120.271     0.150
     4.027    62.572     0.150
     4.027    73.271     0.150
     4.027   107.871     0.150
     4.027   125.371     0.150
     4.027    62.271     0.150
     4.027    71.672     0.150
     4.027   109.971     0.150
     4.027   125.871     0.150
     4.056    63.672     0.150
     4.056    72.371     0.150
     4.056   124.871     0.150
     4.056    73.471     0.150
     4.178    65.471     0.150
     4.178   130.271     0.150
     4.186    64.871     0.150
     4.186    75.471     0.150
     4.186   128.871     0.150
     4.428   118.971     0.150
     4.428   138.072     0.150
     4.648    71.371     0.150
     4.648   144.672     0.150
     5.192    78.771     0.150
     5.192   137.271     0.150
     5.192   160.172     0.150
     5.192    78.971     0.150
     5.192   137.572     0.150
     5.192   159.971     0.150
     5.276    80.271     0.150
     5.276   139.871     0.150
     5.276   164.172     0.150
     5.500    83.371     0.150
     5.500   169.672     0.150
     5.544   172.572     0.150
     5.738    86.771     0.150
     5.738   178.672     0.150
     6.098    91.172     0.150
     6.098    99.871     0.150
     6.098   188.172     0.150
     6.231    92.572     0.150
     6.231   163.072     0.150
     6.231   194.871     0.150
     6.231    92.371     0.150
     6.231   194.271     0.150
     6.448    96.572     0.150
     6.448   200.072     0.150
     6.481    96.072     0.150
     6.481   199.371     0.150
     6.506    97.072     0.150
     6.506   200.271     0.150
     6.506    99.172     0.150
     6.720    99.771     0.150
     6.720   173.172     0.150
     6.720   207.072     0.150
     7.162   103.881     0.150
     7.162   219.678     0.150
     7.162   106.361     0.150
     7.162   105.371     0.150
     7.162   184.971     0.150
     7.162   220.871     0.150
     7.162   106.771     0.150
     7.417   106.914     0.150
     7.417   192.443     0.150
     7.417   232.398     0.150
     7.614   112.371     0.150
     7.614   124.971     0.150
     7.614   234.871     0.150
     7.670   110.471     0.150
     8.276   122.471     0.150
     8.218   255.172     0.150
     8.486   124.672     0.150
     8.486   153.172     0.150
     8.486   262.572     0.150
     8.947   131.973     0.150
     8.947   130.861     0.150
     8.947   131.471     0.150
     8.947   162.771     0.150
     8.947   278.072     0.150
     8.947   131.172     0.150
     9.152   133.471     0.150
     9.154   133.572     0.150
     9.159   133.418     0.150
     9.159   165.494     0.150
     9.159   234.316     0.150
     9.159   285.186     0.150
     9.159   133.242     0.150
    10.130   144.771     0.150
    10.130   258.572     0.150
    10.390   146.514     0.150
    10.390   185.615     0.150
    10.390   259.541     0.150
    10.390   317.840     0.150
    10.390   147.141     0.150
    10.390   146.672     0.150
    10.390   263.971     0.150
    10.390   147.531     0.150
    10.390   149.572     0.150
    10.739   331.971     0.150
    12.971   183.498     0.150
    12.971   320.473     0.150
    12.971   402.432     0.150
    12.971   183.271     0.150
    14.347   203.271     0.150
    14.638   207.871     0.150
    15.103   217.572     0.150
    15.263   221.461     0.150
    15.263   216.271     0.150
    15.337   224.271     0.150
    15.337   402.771     0.150
    15.556   226.072     0.150
    15.899   226.572     0.150
    15.899   230.271     0.150
    15.988   229.742     0.150
    15.988   226.172     0.150
    16.506   230.701     0.150
    16.506   230.734     0.150
    16.506   230.502     0.150
    16.506   231.572     0.150
    16.632   234.371     0.150
    16.643   234.311     0.150
    16.643   233.672     0.150
    16.643   233.258     0.150
    16.643   234.662     0.150
    16.662   234.672     0.150
    16.831   236.371     0.150
    17.374   243.172     0.150
    17.456   245.672     0.150
    17.580   244.672     0.150
    17.857   251.271     0.150
    17.857   454.072     0.150
    18.075   260.971     0.150
    18.198   259.771     0.150
    18.198   453.072     0.150
    18.198   478.771     0.150
    18.520   259.271     0.150
    18.754   261.072     0.150
    19.846   273.572     0.150
    20.094   274.803     0.150
    20.094   276.072     0.150
    20.094   274.992     0.150
    20.094   276.232     0.150
    20.094   274.271     0.150
    20.227   276.461     0.150
    20.227   277.572     0.150
    20.227   499.172     0.150
    20.227   277.771     0.150
    20.376   280.072     0.150
    20.376   503.771     0.150
    20.459   280.350     0.150
    20.459   511.574     0.150
    20.459   279.172     0.150
    20.500   280.072     0.150
    20.759   282.814     0.150
    20.759   512.693     0.150
    20.759   282.672     0.150
    20.842   283.172     0.150
    20.854   283.072     0.150
    20.877   283.232     0.150
    20.877   282.852     0.150
    20.877   283.920     0.150
    20.877   660.078     0.150
    20.857   284.271     0.150
    20.857   523.771     0.150
    21.015   285.611     0.150
    21.015   666.473     0.150
    21.274   287.174     0.150
    21.274   521.543     0.150
    21.274   285.691     0.150
    21.274   287.072     0.150
    21.274   286.961     0.150
    21.306   287.971     0.150
    21.306   287.072     0.150
    21.306   288.008     0.150
    21.306   525.891     0.150
    21.306   674.547     0.150
    21.306   286.732     0.150
    21.317   287.172     0.150
    21.367   288.191     0.150
    21.367   522.227     0.150
    21.367   671.471     0.150
    21.367   287.771     0.150
    21.352   290.072     0.150
    21.471   289.482     0.150
    21.471   288.771     0.150
    21.701   291.932     0.150
    21.701   294.031     0.150
    21.701   292.072     0.150
    21.966   294.871     0.150
    21.964   295.211     0.150
    23.412   309.271     0.150
    23.412   561.771     0.150
    24.091   314.072     0.150
    24.037   315.381     0.150
    24.037   316.131     0.150
    24.137   318.572     0.150
    24.548   321.971     0.150
    24.878   323.529     0.150
    24.879   323.371     0.150
    24.909   323.221     0.150
    25.044   325.371     0.150
    25.171   325.672     0.150
    25.346   328.771     0.150
    25.346   371.072     0.150
    25.387   329.672     0.150
    25.416   329.771     0.150
    25.533   329.572     0.150
    25.533   328.641     0.150
    25.533   329.471     0.150
    25.533   329.842     0.150
    25.533   329.342     0.150
    25.546   329.672     0.150
    25.619   327.861     0.150
    25.619   327.711     0.150
    25.615   328.801     0.150
    25.619   328.072     0.150
    25.621   329.160     0.150
    25.621   539.768     0.150
    25.729   329.871     0.150
    25.729   601.072     0.150
    25.809   333.371     0.150
    26.093   334.162     0.150
    26.093   334.771     0.150
    26.093   335.471     0.150
    26.093   335.672     0.150
    26.093   605.471     0.150
    26.047   333.252     0.150
    26.047   332.021     0.150
    26.057   334.572     0.150
    26.298   335.162     0.150
    26.298   336.172     0.150
    26.482   339.471     0.150
    26.466   339.672     0.150
    26.752   341.371     0.150
    26.752   339.422     0.150
    26.621   340.771     0.150
    27.041   343.781     0.150
    27.041   345.912     0.150
    27.104   343.582     0.150
    27.104   343.471     0.150
    27.161   344.811     0.150
    27.440   348.852     0.150
    27.537   349.682     0.150
    27.818   351.602     0.150
    27.972   353.512     0.150
    28.235   355.512     0.150
    28.235   646.121     0.150
    28.235   353.912     0.150
    28.235   355.771     0.150
    28.235   355.182     0.150
    28.235   353.371     0.150
    28.299   356.861     0.150
    28.498   358.111     0.150
    28.659   358.172     0.150
    28.616   358.451     0.150
    29.224   362.871     0.150
    29.824   368.971     0.150
    29.814   369.271     0.150
    29.979   368.041     0.150
    29.979   368.871     0.150
    29.979   548.971     0.150
    29.979   665.971     0.150
    29.979   368.371     0.150
    29.979     5.900     0.150
    30.075   372.271     0.150
    30.145   370.191     0.150
    30.145   371.672     0.150
    30.145   369.881     0.150
    30.571   377.471     0.150
    30.561   375.771     0.150
    30.561   779.572     0.150
    31.038   379.971     0.150
    32.451   389.691     0.150
    32.451   390.271     0.150
    32.451   390.152     0.150
    32.701   394.771     0.150
    32.701   707.771     0.150
    32.701   721.771     0.150
    32.886   393.672     0.150
    33.576   399.371     0.150
    33.998   405.871     0.150
    34.063   407.732     0.150
    34.115   406.207     0.150
    34.115   405.971     0.150
    34.115   405.471     0.150
    34.115   406.072     0.150
    34.231   408.271     0.150
    34.326   409.271     0.150
    34.562   410.271     0.150
    34.584   411.172     0.150
    34.666   412.172     0.150
    34.724   412.572     0.150
    34.724   412.572     0.150
    34.737   413.172     0.150
    34.792   412.371     0.150
    34.816   413.672     0.150
    35.288   417.471     0.150
    35.311   417.271     0.150
    35.434   416.871     0.150
    35.434   417.752     0.150
    36.016   422.992     0.150
    36.306   424.371     0.150
    36.827   426.871     0.150
    36.827   509.271     0.150
    36.827   768.971     0.150
    36.901   431.271     0.150
    36.901   778.072     0.150
    36.901   429.471     0.150
    36.931   429.162     0.150
    36.931   430.871     0.150
    36.992   430.791     0.150
    36.992   430.561     0.150
    37.163   429.971     0.150
    37.420   433.211     0.150
    37.397   433.072     0.150
    38.288   440.992     0.150
    38.326   442.811     0.150
    38.680   443.168     0.150
    38.599   443.361     0.150
    38.599   444.961     0.150
    38.599   444.672     0.150
    38.642   444.301     0.150
    38.945   446.154     0.150
    38.945   577.104     0.150
    38.945   446.832     0.150
    38.945   447.771     0.150
    38.998   446.971     0.150
    38.999   447.471     0.150
    39.414   450.082     0.150
    39.414   450.471     0.150
    39.711   453.102     0.150
    39.859   454.811     0.150
    40.059   455.832     0.150
    40.111   456.551     0.150
    40.407   459.141     0.150
    40.384   459.672     0.150
    40.573   459.871     0.150
    40.647   459.561     0.150
    41.006   463.801     0.150
    41.138   465.191     0.150
    41.104   463.572     0.150
    41.421   467.572     0.150
    41.421   563.471     0.150
    41.421   582.572     0.150
    41.421   844.172     0.150
    41.515   467.932     0.150
    41.682   468.971     0.150
    41.702   468.172     0.150
    41.785   470.291     0.150
    42.059   472.252     0.150
    42.105   471.572     0.150
    42.396   474.271     0.150
    42.552   477.072     0.150
    42.508   475.072     0.150
    42.481   474.172     0.150
    42.512   475.473     0.150
    42.512   586.760     0.150
    42.522   475.072     0.150
    42.528   478.271     0.150
    42.898   479.641     0.150
    42.898   479.871     0.150
    43.129   477.971     0.150
    43.129   577.471     0.150
    43.129   863.271     0.150
    43.692   485.291     0.150
    44.099   488.471     0.150
    43.991   488.871     0.150
    43.991   593.471     0.150
    43.991  1085.771     0.150
    44.015   487.182     0.150
    44.197   490.432     0.150
    44.286   490.162     0.150
    44.197   490.371     0.150
    44.471   491.371     0.150
    44.471   490.971     0.150
    44.611   492.791     0.150
    44.715   494.961     0.150
    44.715   493.271     0.150
    44.715   494.172     0.150
    44.871   495.072     0.150
    44.881   494.771     0.150
    44.819   494.072     0.150
    45.044   495.771     0.150
    45.023   495.111     0.150
    45.103   496.771     0.150
    45.103   496.572     0.150
    45.103   497.213     0.150
    45.103   900.775     0.150
    45.103   496.881     0.150
    45.116   496.672     0.150
    45.128   497.311     0.150
    45.181   497.541     0.150
    45.112   499.115     0.150
    45.112   497.973     0.150
    45.112   498.152     0.150
    45.112   498.691     0.150
    45.112   498.371     0.150
    45.112   898.871     0.150
    45.112   496.471     0.150
    45.142   497.771     0.150
    45.147   497.162     0.150
    45.147   497.471     0.150
    45.147   496.672     0.150
    45.275   497.771     0.150
    45.309   498.461     0.150
    45.364   498.602     0.150
    45.271   499.672     0.150
    45.478   500.172     0.150
    45.563   502.471     0.150
    45.711   501.102     0.150
    45.717   502.771     0.150
    45.842   502.852     0.150
    45.861   503.031     0.150
    45.861   609.162     0.150
    45.861   908.201     0.150
    46.086   504.541     0.150
    46.278   506.652     0.150
    46.316   506.402     0.150
    46.584   507.732     0.150
    46.584   507.471     0.150
    46.556   509.203     0.150
    46.556   511.771     0.150
    46.556   509.311     0.150
    46.556   510.422     0.150
    46.769   510.641     0.150
    46.769   510.371     0.150
    46.600   508.031     0.150
    46.600   602.811     0.150
    46.600   918.811     0.150
    46.774   509.721     0.150
    46.820   509.971     0.150
    46.736   512.211     0.150
    46.957   511.512     0.150
    46.957   510.771     0.150
    46.963   511.672     0.150
    46.963   621.072     0.150
    46.963   921.072     0.150
    47.084   512.301     0.150
    47.084   511.771     0.150
    47.129   515.461     0.150
    47.362   514.701     0.150
    47.420   515.432     0.150
    47.420   515.072     0.150
    47.530   515.152     0.150
    47.552   515.871     0.150
    47.618   515.572     0.150
    47.633   516.049     0.150
    47.633   516.371     0.150
    47.633   515.771     0.150
    47.645   515.422     0.150
    47.645   516.582     0.150
    47.645   515.672     0.150
    47.645   515.771     0.150
    47.645   516.088     0.150
    47.647   515.771     0.150
    47.660   515.871     0.150
    47.662   5