#!/bin/bash
gmt begin novy1.66_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-5/4/0/34
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya10f5+l'Counts' -BWeSn+t'Origin Time Mislocation novy1.66' << EOF
     1.082
    -1.125
    -0.188
    -0.609
    -0.246
     1.699
    -0.695
    -0.371
     0.306
     0.555
    -1.039
    -0.469
     0.422
    -2.797
     1.086
    -0.659
     0.414
    -0.938
     0.172
    -0.352
    -2.898
    -1.562
     0.232
    -0.121
    -0.011
    -0.395
    -0.031
    -0.312
     0.051
     0.041
    -0.400
    -0.992
    -1.695
    -1.156
    -0.445
    -0.734
    -0.556
     0.430
    -0.137
     0.219
    -0.402
     0.188
     0.902
    -0.152
     1.117
    -0.508
    -0.234
     0.402
     0.039
     0.506
     0.367
    -0.483
     0.848
    -0.707
    -0.707
    -0.188
    -1.215
    -1.344
    -1.766
    -1.465
     0.102
    -0.819
     0.100
    -0.016
     0.685
    -0.547
     0.477
     0.391
    -0.266
     0.602
     0.387
     0.195
    -0.801
     2.550
     0.438
     0.074
    -0.066
     1.117
     0.363
    -0.062
    -2.344
    -0.523
     0.003
     0.523
    -0.566
     2.053
    -0.992
     1.211
     0.746
     1.590
     0.605
     0.023
     0.719
     0.891
     0.711
     0.219
     0.145
     0.959
    -0.789
    -0.237
    -0.852
     0.301
    -2.177
     0.297
     0.992
    -1.461
     0.994
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.016    29.785 Median =  -0.0 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.0  0.
 -0.0  29.2
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -4.800    32.215 Author: all ( 107 samples)
EOF
gmt end
