#!/bin/bash
gmt begin novy1.66_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-39/39/-39/39
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation novy1.66'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    11.900    11.900
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.236     2.362
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.463   -20.059
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.463   -20.059 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.241    14.185
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.241    14.185 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.412     7.697
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.412     7.697 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.528    10.864
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.528    10.864 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.536     7.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.972   -11.168
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.972   -11.168 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.054     2.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.318     7.477
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.932    14.310
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.932    14.310 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.732     0.458
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.459     3.739
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.414     5.258
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.708     7.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.952     6.629
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.995     2.892
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.884     3.498
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.805    -7.819
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.361     3.135
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.265     4.720
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.053   -11.392
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    21.393     3.007
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    21.393     3.007 22
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.711     0.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.944     1.348
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.894     1.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.037     4.161
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.606     1.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.851     2.369
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.999     1.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.113     2.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.860     1.617
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.491    -5.616
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.602     5.340
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.991     1.947
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.388     4.897
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.420    -1.279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.720    13.955
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.720    13.955 37
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.716     2.642
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.042     2.916
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.326    -0.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.738     6.373
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.659     2.202
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.538     1.290
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.459     3.801
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.566     2.521
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.856     4.372
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.162     4.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.645     1.771
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.166     9.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.297    -2.656
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.524     7.840
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.659     2.654
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.469     1.418
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.138    -6.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.724     1.421
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.772   -11.523
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.772   -11.523 56
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.734    -1.010
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.297    -1.795
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.543    15.546
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.543    15.546 59
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.900    -5.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.839     6.911
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.305     1.986
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.750     5.335
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.585     3.308
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.612     2.483
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.753    -9.328
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.857     3.350
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.785     4.309
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.068    -5.771
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.681     1.567
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.260     1.449
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.126    -4.359
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.771   -17.498
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.771   -17.498 73
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -20.813    32.049
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -20.813    32.049 74
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.814     2.504
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.406    -3.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.450     4.744
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.428    -1.291
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.229    -1.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.689     3.663
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.558    18.018
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.558    18.018 81
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.801     2.882
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.916     3.966
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.644     2.218
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.538    -1.184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.458    10.649
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.176     3.859
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.230    12.054
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.230    12.054 88
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.743     2.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.065     3.713
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.198    -1.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.002   -12.872
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.002   -12.872 92
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.057     3.404
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.834     2.824
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.870     4.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.368     5.270
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.690     2.927
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.332    13.333
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.332    13.333 98
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.412    19.642
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.412    19.642 99
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.991     8.622
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.397    11.370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.578     9.283
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.024     2.938
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.275     3.707
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.079     9.162
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.853    18.013
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.853    18.013 106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.618     9.940
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -1.279     3.142     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -37.000    37.000 Author: all ( 107 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -37.000   -37.000 Average =   3.4 km at 337.8 deg; median =    5.9 km
EOF
gmt end
