#!/bin/bash
gmt begin novy1.66_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-25/18/0/17
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation novy1.66' << EOF
     3.300
    -4.200
    -3.000
    -9.100
    -7.500
    13.100
    -8.600
     2.000
    -0.000
     3.000
    -3.100
    -0.500
     2.300
   -16.500
     4.500
    -5.000
     6.000
    -9.100
     5.000
    -0.000
    -8.300
    -0.600
     1.000
    -0.000
     4.000
    -2.100
     1.000
    -3.000
     3.000
     1.000
    -5.000
    -2.400
    -3.000
     5.000
   -15.000
    -5.000
    -3.000
     2.000
    -0.000
     1.000
    -4.000
     2.000
     8.000
     1.000
     6.400
    -0.000
    -2.000
    -0.000
    -0.200
     0.500
     0.300
    -1.000
     6.000
   -12.200
     1.000
     6.000
   -19.800
   -11.500
   -14.100
   -12.000
    -3.200
    -2.100
     2.900
     2.000
    -0.000
     4.000
     2.000
     2.400
     9.000
     6.000
     1.000
     2.200
     8.000
     3.100
    -0.000
     4.000
   -15.000
     9.000
     3.200
     0.400
    -5.500
     3.100
    -0.000
    -0.000
     2.500
    10.000
    -0.700
     8.900
     4.000
    10.000
     4.900
     7.000
     9.000
     3.000
     8.000
     4.200
    -0.000
     8.600
    -6.100
    -2.700
    -5.000
     2.600
   -13.800
     4.000
     7.300
   -13.100
     5.200
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     1.000    14.892 Median =   1.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.
  1.0  14.6
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -24.000    16.108 Author: all ( 107 samples)
EOF
gmt end
