#!/bin/bash
gmt begin novy1.66_depth_histogram pdf,ps
proj=-JX12/10
reg=-R0/40/0/15
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depths novy1.66' << EOF
    18.000
    18.000
    16.000
    20.000
    35.000
    10.000
    17.000
     6.000
    10.000
    13.000
    14.000
    23.000
    13.000
    17.000
    14.000
    20.000
     0.000
    19.000
    13.000
    21.000
    20.000
    18.000
     7.000
    15.000
    16.000
    18.000
    14.000
    16.000
    15.000
    11.000
    20.000
    17.000
    16.000
     8.000
    15.000
    15.000
    15.000
    13.000
    13.000
    10.000
    10.000
     8.000
     4.000
    19.000
     8.000
    16.000
    14.000
     4.000
    22.000
     4.000
    17.000
    25.000
     0.000
    17.000
     2.000
     4.000
    25.000
    16.000
    17.000
    22.000
    26.000
     4.000
     1.000
    15.000
     0.000
     6.000
     3.000
     4.000
     1.000
     1.000
     5.000
     0.000
     2.000
     0.000
     4.000
     6.000
    15.000
     1.000
     8.000
    15.000
    16.000
     0.000
    16.000
     3.000
     2.000
     0.000
     1.000
     4.000
     6.000
     0.000
     3.000
     3.000
     1.000
     7.000
     2.000
     3.000
     6.000
     0.000
    20.000
    15.000
    17.000
     5.000
    19.000
     3.000
     5.000
    15.000
     7.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000    14.100 Median of constrained depths =  13.0
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000    13.200 Spread of constrained depths =   9.6
EOF
gmt end
