#!/bin/bash
gmt begin novy1.66_dcal pdf,ps
proj=-JM16.0c+
reg=-R107.7/117.9/53.4/58.3
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration novy1.66'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
   111.201    55.887
   111.872    56.109
>
   111.201    55.887
   111.368    55.420
>
   111.201    55.887
   111.368    55.420
>
   113.519    56.184
   113.396    56.308
>
   113.670    56.350
   113.396    56.308
>
   113.980    56.300
   113.396    56.308
>
   113.980    56.300
   113.396    56.308
>
   113.360    56.280
   113.531    56.333
>
   113.670    56.350
   113.531    56.333
>
   113.519    56.184
   113.531    56.333
>
   113.050    56.140
   113.531    56.333
>
   113.980    56.300
   113.531    56.333
>
   113.670    55.930
   113.531    56.333
>
   111.724    56.133
   112.029    55.610
>
   111.724    56.133
   112.029    55.610
>
   111.201    55.887
   112.029    55.610
>
   111.201    55.887
   112.029    55.610
>
   111.201    55.887
   112.029    55.610
>
   113.050    56.140
   112.029    55.610
>
   113.050    56.140
   112.029    55.610
>
   113.670    55.930
   112.029    55.610
>
   113.670    55.930
   112.029    55.610
>
   113.116    56.387
   112.029    55.610
>
   113.116    56.387
   112.029    55.610
>
   113.627    55.489
   114.576    55.629
>
   113.360    56.280
   114.576    55.629
>
   113.050    56.140
   112.689    56.147
>
   113.050    56.140
   112.689    56.147
>
   113.360    56.280
   112.689    56.147
>
   111.724    56.133
   112.689    56.147
>
   111.724    56.133
   112.689    56.147
>
   113.519    56.184
   112.689    56.147
>
   113.519    56.184
   112.689    56.147
>
   113.670    55.930
   112.689    56.147
>
   113.670    55.930
   112.689    56.147
>
   113.980    56.300
   112.689    56.147
>
   113.980    56.300
   112.689    56.147
>
   111.201    55.887
   112.689    56.147
>
   113.360    56.280
   114.614    56.064
>
   113.360    56.280
   114.614    56.064
>
   115.703    56.491
   114.614    56.064
>
   115.703    56.491
   114.614    56.064
>
   115.702    56.504
   114.614    56.064
>
   115.702    56.504
   114.614    56.064
>
   113.627    55.489
   114.614    56.064
>
   113.627    55.489
   114.614    56.064
>
   111.724    56.133
   112.061    56.164
>
   111.724    56.133
   112.061    56.164
>
   111.201    55.887
   112.061    56.164
>
   111.201    55.887
   112.061    56.164
>
   113.360    56.280
   112.061    56.164
>
   111.724    56.133
   111.822    56.019
>
   111.724    56.133
   111.822    56.019
>
   111.724    56.133
   111.822    56.019
>
   111.201    55.887
   111.822    56.019
>
   111.201    55.887
   111.822    56.019
>
   113.360    56.280
   111.822    56.019
>
   113.360    56.280
   111.822    56.019
>
   111.724    56.133
   111.758    56.115
>
   111.724    56.133
   111.758    56.115
>
   111.724    56.133
   111.758    56.115
>
   111.201    55.887
   111.758    56.115
>
   111.201    55.887
   111.758    56.115
>
   113.360    56.280
   111.758    56.115
>
   113.360    56.280
   111.758    56.115
>
   113.559    56.117
   113.824    56.102
>
   113.559    56.117
   113.824    56.102
>
   113.519    56.184
   113.824    56.102
>
   113.627    55.489
   113.824    56.102
>
   113.627    55.489
   113.824    56.102
>
   113.559    56.117
   113.261    56.108
>
   113.559    56.117
   113.261    56.108
>
   113.627    55.489
   113.261    56.108
>
   113.627    55.489
   113.261    56.108
>
   111.724    56.133
   113.261    56.108
>
   111.201    55.887
   111.506    56.024
>
   111.201    55.887
   111.506    56.024
>
   111.724    56.133
   111.506    56.024
>
   111.724    56.133
   111.506    56.024
>
   113.559    56.117
   113.498    55.897
>
   113.559    56.117
   113.498    55.897
>
   113.559    56.117
   113.498    55.897
>
   113.627    55.489
   113.498    55.897
>
   113.627    55.489
   113.498    55.897
>
   113.627    55.489
   113.498    55.897
>
   113.559    56.117
   113.418    56.032
>
   113.559    56.117
   113.418    56.032
>
   113.519    56.184
   113.418    56.032
>
   113.519    56.184
   113.418    56.032
>
   113.627    55.489
   113.418    56.032
>
   113.627    55.489
   113.418    56.032
>
   111.724    56.133
   113.418    56.032
>
   113.627    55.489
   113.465    55.638
>
   113.627    55.489
   113.465    55.638
>
   113.627    55.489
   113.465    55.638
>
   113.559    56.117
   113.465    55.638
>
   113.559    56.117
   113.465    55.638
>
   113.519    56.184
   113.465    55.638
>
   111.724    56.133
   111.805    56.136
>
   111.724    56.133
   111.805    56.136
>
   111.201    55.887
   111.805    56.136
>
   111.201    55.887
   111.805    56.136
>
   111.201    55.887
   111.805    56.136
>
   113.519    56.184
   111.805    56.136
>
   113.559    56.117
   111.805    56.136
>
   113.559    56.117
   111.805    56.136
>
   111.201    55.887
   111.395    56.019
>
   111.201    55.887
   111.395    56.019
>
   111.724    56.133
   111.395    56.019
>
   111.724    56.133
   111.395    56.019
>
   111.724    56.133
   111.395    56.019
>
   111.201    55.887
   111.306    56.017
>
   111.201    55.887
   111.306    56.017
>
   111.201    55.887
   111.306    56.017
>
   111.724    56.133
   111.306    56.017
>
   111.724    56.133
   111.306    56.017
>
   111.724    56.133
   111.306    56.017
>
   111.201    55.887
   111.330    56.049
>
   111.201    55.887
   111.330    56.049
>
   111.201    55.887
   111.330    56.049
>
   111.724    56.133
   111.330    56.049
>
   111.724    56.133
   111.330    56.049
>
   111.724    56.133
   111.330    56.049
>
   111.201    55.887
   111.362    56.037
>
   111.201    55.887
   111.362    56.037
>
   111.201    55.887
   111.362    56.037
>
   111.724    56.133
   111.362    56.037
>
   111.724    56.133
   111.362    56.037
>
   111.724    56.133
   111.362    56.037
>
   111.201    55.887
   111.304    56.045
>
   111.201    55.887
   111.304    56.045
>
   111.201    55.887
   111.304    56.045
>
   111.724    56.133
   111.304    56.045
>
   111.724    56.133
   111.304    56.045
>
   111.724    56.133
   111.304    56.045
>
   111.724    56.133
   111.304    56.045
>
   111.201    55.887
   111.390    56.025
>
   111.201    55.887
   111.390    56.025
>
   111.724    56.133
   111.390    56.025
>
   111.724    56.133
   111.390    56.025
>
   111.724    56.133
   111.390    56.025
>
   111.724    56.133
   111.390    56.025
>
   111.201    55.887
   111.312    56.040
>
   111.201    55.887
   111.312    56.040
>
   111.724    56.133
   111.312    56.040
>
   111.724    56.133
   111.312    56.040
>
   111.724    56.133
   111.312    56.040
>
   111.724    56.133
   111.312    56.040
>
   111.724    56.133
   111.367    56.033
>
   111.724    56.133
   111.367    56.033
>
   111.724    56.133
   111.367    56.033
>
   111.724    56.133
   111.367    56.033
>
   111.201    55.887
   111.367    56.033
>
   111.201    55.887
   111.367    56.033
>
   111.201    55.887
   111.261    56.042
>
   111.201    55.887
   111.261    56.042
>
   111.201    55.887
   111.261    56.042
>
   111.201    55.887
   111.261    56.042
>
   111.724    56.133
   111.261    56.042
>
   111.724    56.133
   111.261    56.042
>
   111.724    56.133
   111.261    56.042
>
   111.201    55.887
   111.408    56.016
>
   111.201    55.887
   111.408    56.016
>
   111.201    55.887
   111.408    56.016
>
   111.724    56.133
   111.408    56.016
>
   111.724    56.133
   111.408    56.016
>
   111.724    56.133
   111.408    56.016
>
   111.724    56.133
   111.408    56.016
>
   113.627    55.489
   113.524    55.340
>
   113.627    55.489
   113.524    55.340
>
   113.627    55.489
   113.524    55.340
>
   113.559    56.117
   113.603    55.709
>
   113.559    56.117
   113.603    55.709
>
   113.559    56.117
   113.603    55.709
>
   113.627    55.489
   113.603    55.709
>
   113.627    55.489
   113.603    55.709
>
   113.627    55.489
   113.603    55.709
>
   113.627    55.489
   113.603    55.709
>
   113.559    56.117
   113.828    56.036
>
   113.559    56.117
   113.828    56.036
>
   113.559    56.117
   113.828    56.036
>
   113.627    55.489
   113.828    56.036
>
   113.627    55.489
   113.828    56.036
>
   111.201    55.887
   111.363    56.024
>
   111.201    55.887
   111.363    56.024
>
   111.724    56.133
   111.363    56.024
>
   111.724    56.133
   111.363    56.024
>
   111.724    56.133
   111.363    56.024
>
   113.627    55.489
   113.755    55.370
>
   113.627    55.489
   113.755    55.370
>
   113.627    55.489
   113.755    55.370
>
   111.724    56.133
   111.662    56.153
>
   111.724    56.133
   111.662    56.153
>
   111.724    56.133
   111.662    56.153
>
   111.201    55.887
   111.662    56.153
>
   111.201    55.887
   111.662    56.153
>
   111.201    55.887
   111.662    56.153
>
   111.201    55.887
   111.203    56.017
>
   111.201    55.887
   111.203    56.017
>
   111.201    55.887
   111.203    56.017
>
   111.724    56.133
   111.203    56.017
>
   111.724    56.133
   111.203    56.017
>
   111.724    56.133
   111.203    56.017
>
   113.559    56.117
   113.585    56.308
>
   113.559    56.117
   113.585    56.308
>
   113.627    55.489
   113.585    56.308
>
   113.627    55.489
   113.585    56.308
>
   113.627    55.489
   113.585    56.308
>
   113.627    55.489
   113.585    56.308
>
   113.627    55.489
   113.653    55.476
>
   113.627    55.489
   113.653    55.476
>
   113.559    56.117
   113.653    55.476
>
   113.559    56.117
   113.653    55.476
>
   113.559    56.117
   114.558    56.055
>
   113.559    56.117
   114.558    56.055
>
   113.627    55.489
   114.558    56.055
>
   113.627    55.489
   114.558    56.055
>
   113.627    55.489
   114.558    56.055
>
   115.703    56.491
   114.558    56.055
>
   115.703    56.491
   114.558    56.055
>
   115.703    56.491
   114.558    56.055
>
   115.703    56.491
   114.558    56.055
>
   111.724    56.133
   111.468    56.051
>
   111.724    56.133
   111.468    56.051
>
   111.724    56.133
   111.468    56.051
>
   111.201    55.887
   111.468    56.051
>
   111.201    55.887
   111.468    56.051
>
   111.201    55.887
   111.468    56.051
>
   111.201    55.887
   111.468    56.051
>
   111.201    55.887
   111.353    56.010
>
   111.201    55.887
   111.353    56.010
>
   111.724    56.133
   111.353    56.010
>
   111.724    56.133
   111.353    56.010
>
   111.724    56.133
   111.353    56.010
>
   113.559    56.117
   113.640    56.044
>
   113.559    56.117
   113.640    56.044
>
   113.627    55.489
   113.640    56.044
>
   113.627    55.489
   113.640    56.044
>
   113.627    55.489
   113.640    56.044
>
   113.627    55.489
   113.494    55.880
>
   113.627    55.489
   113.494    55.880
>
   113.559    56.117
   113.546    56.229
>
   113.559    56.117
   113.546    56.229
>
   113.559    56.117
   113.546    56.229
>
   113.627    55.489
   113.546    56.229
>
   113.627    55.489
   113.546    56.229
>
   111.201    55.887
   111.162    55.404
>
   111.201    55.887
   111.162    55.404
>
   111.162    54.876
   111.162    55.404
>
   111.162    54.876
   111.162    55.404
>
   111.162    54.876
   111.162    55.404
>
   111.724    56.133
   111.162    55.404
>
   111.724    56.133
   111.162    55.404
>
   111.724    56.133
   111.162    55.404
>
   111.724    56.133
   111.162    55.404
>
   109.541    55.775
   111.162    55.404
>
   109.541    55.775
   111.162    55.404
>
   109.541    55.775
   111.162    55.404
>
   111.724    56.133
   111.747    56.116
>
   111.724    56.133
   111.747    56.116
>
   111.201    55.887
   111.747    56.116
>
   111.201    55.887
   111.747    56.116
>
   111.201    55.887
   111.747    56.116
>
   113.559    56.117
   113.584    56.227
>
   113.559    56.117
   113.584    56.227
>
   113.559    56.117
   113.584    56.227
>
   113.627    55.489
   113.584    56.227
>
   113.627    55.489
   113.584    56.227
>
   113.559    56.117
   113.577    56.038
>
   113.559    56.117
   113.577    56.038
>
   113.559    56.117
   113.577    56.038
>
   113.627    55.489
   113.577    56.038
>
   113.627    55.489
   113.577    56.038
>
   113.627    55.489
   113.577    56.038
>
   113.559    56.117
   113.992    56.030
>
   113.559    56.117
   113.992    56.030
>
   113.627    55.489
   113.992    56.030
>
   113.627    55.489
   113.992    56.030
>
   113.627    55.489
   113.992    56.030
>
   113.627    55.489
   113.992    56.030
>
   113.559    56.117
   113.578    56.225
>
   113.559    56.117
   113.578    56.225
>
   113.559    56.117
   113.578    56.225
>
   111.724    56.133
   112.150    56.170
>
   111.724    56.133
   112.150    56.170
>
   111.201    55.887
   112.150    56.170
>
   111.201    55.887
   112.150    56.170
>
   113.559    56.117
   112.150    56.170
>
   113.559    56.117
   112.150    56.170
>
   113.559    56.117
   113.687    55.985
>
   113.559    56.117
   113.687    55.985
>
   113.627    55.489
   113.687    55.985
>
   113.627    55.489
   113.687    55.985
>
   113.627    55.489
   113.687    55.985
>
   113.627    55.489
   113.687    55.985
>
   111.724    56.133
   112.184    56.057
>
   111.724    56.133
   112.184    56.057
>
   111.201    55.887
   112.184    56.057
>
   113.559    56.117
   112.184    56.057
>
   113.559    56.117
   112.184    56.057
>
   113.559    56.117
   112.184    56.057
>
   113.559    56.117
   112.184    56.057
>
   113.627    55.489
   112.184    56.057
>
   113.627    55.489
   112.184    56.057
>
   113.627    55.489
   112.184    56.057
>
   113.627    55.489
   112.184    56.057
>
   113.559    56.117
   113.552    55.943
>
   113.559    56.117
   113.552    55.943
>
   113.559    56.117
   113.552    55.943
>
   113.627    55.489
   113.552    55.943
>
   113.627    55.489
   113.552    55.943
>
   113.627    55.489
   113.552    55.943
>
   111.724    56.133
   111.915    56.126
>
   111.724    56.133
   111.915    56.126
>
   111.724    56.133
   111.915    56.126
>
   111.201    55.887
   111.915    56.126
>
   111.201    55.887
   111.915    56.126
>
   111.201    55.887
   111.915    56.126
>
   113.559    56.117
   111.915    56.126
>
   113.559    56.117
   111.915    56.126
>
   113.559    56.117
   111.915    56.126
>
   111.201    55.887
   111.232    55.698
>
   111.201    55.887
   111.232    55.698
>
   111.201    55.887
   111.232    55.698
>
   111.201    55.887
   111.232    55.698
>
   111.724    56.133
   111.232    55.698
>
   111.724    56.133
   111.232    55.698
>
   111.724    56.133
   111.232    55.698
>
   111.162    54.876
   111.232    55.698
>
   111.162    54.876
   111.232    55.698
>
   111.162    54.876
   111.232    55.698
>
   109.541    55.775
   111.232    55.698
>
   109.541    55.775
   111.232    55.698
>
   109.541    55.775
   111.232    55.698
>
   111.201    55.887
   111.239    55.697
>
   111.201    55.887
   111.239    55.697
>
   111.201    55.887
   111.239    55.697
>
   111.724    56.133
   111.239    55.697
>
   111.724    56.133
   111.239    55.697
>
   111.162    54.876
   111.239    55.697
>
   111.162    54.876
   111.239    55.697
>
   111.162    54.876
   111.239    55.697
>
   111.162    54.876
   111.239    55.697
>
   109.541    55.775
   111.239    55.697
>
   109.541    55.775
   111.239    55.697
>
   109.541    55.775
   111.239    55.697
>
   109.541    55.775
   111.239    55.697
>
   111.724    56.133
   112.101    56.140
>
   111.724    56.133
   112.101    56.140
>
   111.201    55.887
   112.101    56.140
>
   111.201    55.887
   112.101    56.140
>
   113.559    56.117
   112.101    56.140
>
   113.559    56.117
   112.101    56.140
>
   113.559    56.117
   113.946    56.068
>
   113.559    56.117
   113.946    56.068
>
   113.627    55.489
   113.946    56.068
>
   113.627    55.489
   113.946    56.068
>
   113.559    56.117
   113.908    56.041
>
   113.559    56.117
   113.908    56.041
>
   113.559    56.117
   113.908    56.041
>
   113.627    55.489
   113.908    56.041
>
   113.627    55.489
   113.908    56.041
>
   113.559    56.117
   113.910    56.050
>
   113.559    56.117
   113.910    56.050
>
   113.627    55.489
   113.910    56.050
>
   113.627    55.489
   113.910    56.050
>
   113.559    56.117
   113.937    56.041
>
   113.559    56.117
   113.937    56.041
>
   113.559    56.117
   113.937    56.041
>
   113.627    55.489
   113.937    56.041
>
   113.627    55.489
   113.937    56.041
>
   113.627    55.489
   113.937    56.041
>
   113.559    56.117
   113.929    56.065
>
   113.559    56.117
   113.929    56.065
>
   113.627    55.489
   113.929    56.065
>
   113.627    55.489
   113.929    56.065
>
   113.559    56.117
   113.927    56.066
>
   113.559    56.117
   113.927    56.066
>
   113.559    56.117
   113.927    56.066
>
   113.627    55.489
   113.927    56.066
>
   113.627    55.489
   113.927    56.066
>
   113.559    56.117
   113.920    56.057
>
   113.559    56.117
   113.920    56.057
>
   113.627    55.489
   113.920    56.057
>
   113.627    55.489
   113.920    56.057
>
   113.559    56.117
   113.983    56.061
>
   113.559    56.117
   113.983    56.061
>
   113.559    56.117
   113.983    56.061
>
   113.627    55.489
   113.983    56.061
>
   113.627    55.489
   113.983    56.061
>
   113.627    55.489
   113.983    56.061
>
   113.627    55.489
   113.983    56.061
>
   113.559    56.117
   114.023    56.063
>
   113.559    56.117
   114.023    56.063
>
   113.559    56.117
   114.023    56.063
>
   113.627    55.489
   114.023    56.063
>
   113.627    55.489
   114.023    56.063
>
   113.627    55.489
   114.023    56.063
>
   113.559    56.117
   113.955    56.060
>
   113.559    56.117
   113.955    56.060
>
   113.627    55.489
   113.955    56.060
>
   113.627    55.489
   113.955    56.060
>
   113.559    56.117
   113.723    56.068
>
   113.559    56.117
   113.723    56.068
>
   113.627    55.489
   113.723    56.068
>
   113.627    55.489
   113.723    56.068
>
   113.559    56.117
   113.935    56.048
>
   113.559    56.117
   113.935    56.048
>
   113.559    56.117
   113.935    56.048
>
   113.627    55.489
   113.935    56.048
>
   113.627    55.489
   113.935    56.048
>
   113.627    55.489
   113.935    56.048
>
   113.559    56.117
   112.643    56.057
>
   113.559    56.117
   112.643    56.057
>
   111.201    55.887
   112.643    56.057
>
   111.201    55.887
   112.643    56.057
>
   113.627    55.489
   112.643    56.057
>
   113.627    55.489
   112.643    56.057
>
   113.559    56.117
   113.927    56.038
>
   113.559    56.117
   113.927    56.038
>
   113.559    56.117
   113.927    56.038
>
   113.627    55.489
   113.927    56.038
>
   113.627    55.489
   113.927    56.038
>
   113.627    55.489
   113.833    55.382
>
   113.627    55.489
   113.833    55.382
>
   113.559    56.117
   113.833    55.382
>
   113.559    56.117
   113.833    55.382
>
   113.559    56.117
   113.833    55.382
>
   113.559    56.117
   113.624    56.004
>
   113.559    56.117
   113.624    56.004
>
   113.559    56.117
   113.624    56.004
>
   113.627    55.489
   113.624    56.004
>
   113.627    55.489
   113.624    56.004
>
   113.627    55.489
   113.624    56.004
>
   113.559    56.117
   113.997    56.225
>
   113.559    56.117
   113.997    56.225
>
   113.559    56.117
   113.997    56.225
>
   115.703    56.491
   113.997    56.225
>
   115.703    56.491
   113.997    56.225
>
   115.703    56.491
   113.997    56.225
>
   115.703    56.491
   113.997    56.225
>
   113.627    55.489
   113.997    56.225
>
   113.627    55.489
   113.997    56.225
>
   113.627    55.489
   113.997    56.225
>
   113.559    56.117
   113.922    56.035
>
   113.559    56.117
   113.922    56.035
>
   113.559    56.117
   113.922    56.035
>
   113.559    56.117
   113.922    56.035
>
   113.627    55.489
   113.922    56.035
>
   113.627    55.489
   113.922    56.035
>
   113.559    56.117
   113.915    56.224
>
   113.559    56.117
   113.915    56.224
>
   113.627    55.489
   113.915    56.224
>
   113.627    55.489
   113.915    56.224
>
   113.559    56.117
   113.902    56.030
>
   113.559    56.117
   113.902    56.030
>
   113.627    55.489
   113.902    56.030
>
   113.627    55.489
   113.902    56.030
>
   111.201    55.887
   111.486    55.459
>
   111.201    55.887
   111.486    55.459
>
   111.162    54.876
   111.486    55.459
>
   111.162    54.876
   111.486    55.459
>
   111.724    56.133
   111.486    55.459
>
   111.724    56.133
   111.486    55.459
>
   113.559    56.117
   113.931    56.037
>
   113.559    56.117
   113.931    56.037
>
   113.559    56.117
   113.931    56.037
>
   113.627    55.489
   113.931    56.037
>
   113.627    55.489
   113.931    56.037
>
   113.559    56.117
   113.949    56.077
>
   113.559    56.117
   113.949    56.077
>
   113.627    55.489
   113.949    56.077
>
   113.627    55.489
   113.949    56.077
>
   113.627    55.489
   113.949    56.077
>
   113.559    56.117
   113.699    56.039
>
   113.559    56.117
   113.699    56.039
>
   113.559    56.117
   113.699    56.039
>
   113.559    56.117
   113.701    56.061
>
   113.559    56.117
   113.701    56.061
>
   113.559    56.117
   113.701    56.061
>
   113.627    55.489
   113.701    56.061
>
   113.627    55.489
   113.701    56.061
>
   113.559    56.117
   113.724    56.060
>
   113.559    56.117
   113.724    56.060
>
   113.559    56.117
   113.724    56.060
>
   113.627    55.489
   113.724    56.060
>
   113.627    55.489
   113.724    56.060
>
   113.627    55.489
   113.724    56.060
>
   113.559    56.117
   113.732    56.073
>
   113.559    56.117
   113.732    56.073
>
   113.559    56.117
   113.732    56.073
>
   113.559    56.117
   113.732    56.073
>
   113.627    55.489
   113.732    56.073
>
   113.627    55.489
   113.732    56.073
>
   113.627    55.489
   113.732    56.073
>
   113.559    56.117
   113.741    56.059
>
   113.559    56.117
   113.741    56.059
>
   113.559    56.117
   113.741    56.059
>
   113.627    55.489
   113.741    56.059
>
   113.627    55.489
   113.741    56.059
>
   113.559    56.117
   113.756    56.073
>
   113.559    56.117
   113.756    56.073
>
   113.559    56.117
   113.756    56.073
>
   113.627    55.489
   113.756    56.073
>
   113.627    55.489
   113.756    56.073
>
   113.627    55.489
   113.756    56.073
>
   113.559    56.117
   113.745    56.085
>
   113.559    56.117
   113.745    56.085
>
   113.559    56.117
   113.709    56.052
>
   113.559    56.117
   113.709    56.052
>
   113.627    55.489
   113.709    56.052
>
   113.627    55.489
   113.709    56.052
>
   113.559    56.117
   113.708    56.047
>
   113.559    56.117
   113.708    56.047
>
   113.627    55.489
   113.708    56.047
>
   113.627    55.489
   113.708    56.047
>
   113.627    55.489
   113.708    56.047
>
   113.559    56.117
   113.727    56.074
>
   113.559    56.117
   113.727    56.074
>
   113.627    55.489
   113.727    56.074
>
   113.627    55.489
   113.727    56.074
>
   113.559    56.117
   113.635    56.096
>
   113.559    56.117
   113.635    56.096
>
   113.627    55.489
   113.635    56.096
>
   113.627    55.489
   113.635    56.096
>
   111.724    56.133
   112.166    56.010
>
   111.724    56.133
   112.166    56.010
>
   111.724    56.133
   112.166    56.010
>
   111.201    55.887
   112.166    56.010
>
   111.201    55.887
   112.166    56.010
>
   111.201    55.887
   112.166    56.010
>
   113.559    56.117
   112.166    56.010
>
   113.559    56.117
   112.166    56.010
>
   113.559    56.117
   112.166    56.010
>
   113.559    56.117
   112.166    56.010
>
   113.627    55.489
   112.166    56.010
>
   113.627    55.489
   112.166    56.010
>
   113.627    55.489
   112.166    56.010
>
   111.724    56.133
   112.604    56.085
>
   111.724    56.133
   112.604    56.085
>
   113.559    56.117
   112.604    56.085
>
   113.559    56.117
   112.604    56.085
>
   113.559    56.117
   112.604    56.085
>
   111.201    55.887
   112.604    56.085
>
   111.201    55.887
   112.604    56.085
>
   111.201    55.887
   112.604    56.085
>
   113.627    55.489
   112.604    56.085
>
   113.627    55.489
   112.604    56.085
>
   113.559    56.117
   114.071    55.773
>
   113.559    56.117
   114.071    55.773
>
   113.627    55.489
   114.071    55.773
>
   113.627    55.489
   114.071    55.773
>
   111.201    55.887
   111.046    55.722
>
   111.201    55.887
   111.046    55.722
>
   111.201    55.887
   111.046    55.722
>
   111.201    55.887
   111.046    55.722
>
   111.722    56.141
   111.046    55.722
>
   111.722    56.141
   111.046    55.722
>
   109.545    55.770
   111.046    55.722
>
   109.545    55.770
   111.046    55.722
>
   111.162    54.876
   111.046    55.722
>
   111.162    54.876
   111.046    55.722
>
   113.559    56.117
   114.097    56.094
>
   113.559    56.117
   114.097    56.094
>
   113.627    55.489
   114.097    56.094
>
   113.627    55.489
   114.097    56.094
>
   113.627    55.489
   114.097    56.094
>
   115.703    56.491
   114.097    56.094
>
   115.703    56.491
   114.097    56.094
>
   115.703    56.491
   114.097    56.094
>
   113.559    56.117
   113.474    55.877
>
   113.559    56.117
   113.474    55.877
>
   113.559    56.117
   113.474    55.877
>
   113.627    55.489
   113.474    55.877
>
   113.627    55.489
   113.474    55.877
>
   113.627    55.489
   113.474    55.877
>
   113.559    56.117
   113.417    55.891
>
   113.559    56.117
   113.417    55.891
>
   113.559    56.117
   113.417    55.891
>
   111.722    56.141
   113.417    55.891
>
   111.722    56.141
   113.417    55.891
>
   111.722    56.141
   113.417    55.891
>
   113.559    56.117
   112.835    56.144
>
   113.559    56.117
   112.835    56.144
>
   113.559    56.117
   112.835    56.144
>
   113.559    56.117
   112.835    56.144
>
   111.722    56.141
   112.835    56.144
>
   113.627    55.489
   112.835    56.144
>
   113.627    55.489
   112.835    56.144
>
   111.201    55.887
   112.835    56.144
>
   111.201    55.887
   112.835    56.144
>
   113.559    56.117
   113.358    55.892
>
   113.559    56.117
   113.358    55.892
>
   113.559    56.117
   113.358    55.892
>
   113.627    55.489
   113.358    55.892
>
   113.627    55.489
   113.358    55.892
>
   111.722    56.141
   113.358    55.892
>
   111.722    56.141
   113.358    55.892
>
   111.722    56.141
   113.358    55.892
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
   111.201    55.887     0.300
   113.519    56.184     0.300
   113.670    56.350     0.300
   113.980    56.300     0.300
   113.360    56.280     0.300
   113.050    56.140     0.300
   113.670    55.930     0.300
   111.724    56.133     0.300
   113.116    56.387     0.300
   113.627    55.489     0.300
   115.703    56.491     0.300
   115.702    56.504     0.300
   113.559    56.117     0.300
   111.162    54.876     0.300
   109.541    55.775     0.300
   111.722    56.141     0.300
   109.545    55.770     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
   113.168    55.901     0.200
>
   112.846    56.406     0.200
>
   111.500    55.924     0.200
>
   111.638    56.118     0.200
>
   111.872    56.109     0.200
>
   111.368    55.420     0.200
>
   113.396    56.308     0.200
>
   113.531    56.333     0.200
>
   111.470    55.298     0.200
>
   112.967    55.735     0.200
>
   112.029    55.610     0.200
>
   113.092    56.173     0.200
>
   114.576    55.629     0.200
>
   112.689    56.147     0.200
>
   114.614    56.064     0.200
>
   112.061    56.164     0.200
>
   111.822    56.019     0.200
>
   111.758    56.115     0.200
>
   113.824    56.102     0.200
>
   113.261    56.108     0.200
>
   111.506    56.024     0.200
>
   113.498    55.897     0.200
>
   113.418    56.032     0.200
>
   113.465    55.638     0.200
>
   111.805    56.136     0.200
>
   111.395    56.019     0.200
>
   111.306    56.017     0.200
>
   111.330    56.049     0.200
>
   111.362    56.037     0.200
>
   111.304    56.045     0.200
>
   111.390    56.025     0.200
>
   111.312    56.040     0.200
>
   111.367    56.033     0.200
>
   111.261    56.042     0.200
>
   111.408    56.016     0.200
>
   113.524    55.340     0.200
>
   113.603    55.709     0.200
>
   113.828    56.036     0.200
>
   111.363    56.024     0.200
>
   113.755    55.370     0.200
>
   111.662    56.153     0.200
>
   111.203    56.017     0.200
>
   113.585    56.308     0.200
>
   113.653    55.476     0.200
>
   114.558    56.055     0.200
>
   111.468    56.051     0.200
>
   111.353    56.010     0.200
>
   113.640    56.044     0.200
>
   113.494    55.880     0.200
>
   113.546    56.229     0.200
>
   111.162    55.404     0.200
>
   111.747    56.116     0.200
>
   113.584    56.227     0.200
>
   113.577    56.038     0.200
>
   113.992    56.030     0.200
>
   113.578    56.225     0.200
>
   112.150    56.170     0.200
>
   113.687    55.985     0.200
>
   112.184    56.057     0.200
>
   113.552    55.943     0.200
>
   111.915    56.126     0.200
>
   111.232    55.698     0.200
>
   111.239    55.697     0.200
>
   112.101    56.140     0.200
>
   113.946    56.068     0.200
>
   113.908    56.041     0.200
>
   113.910    56.050     0.200
>
   113.937    56.041     0.200
>
   113.929    56.065     0.200
>
   113.927    56.066     0.200
>
   113.920    56.057     0.200
>
   113.983    56.061     0.200
>
   114.023    56.063     0.200
>
   113.955    56.060     0.200
>
   113.723    56.068     0.200
>
   113.935    56.048     0.200
>
   112.643    56.057     0.200
>
   113.927    56.038     0.200
>
   113.833    55.382     0.200
>
   113.624    56.004     0.200
>
   113.997    56.225     0.200
>
   113.922    56.035     0.200
>
   113.915    56.224     0.200
>
   113.902    56.030     0.200
>
   111.486    55.459     0.200
>
   113.931    56.037     0.200
>
   113.949    56.077     0.200
>
   113.699    56.039     0.200
>
   113.701    56.061     0.200
>
   113.724    56.060     0.200
>
   113.732    56.073     0.200
>
   113.741    56.059     0.200
>
   113.756    56.073     0.200
>
   113.745    56.085     0.200
>
   113.709    56.052     0.200
>
   113.708    56.047     0.200
>
   113.727    56.074     0.200
>
   113.635    56.096     0.200
>
   112.166    56.010     0.200
>
   112.604    56.085     0.200
>
   114.071    55.773     0.200
>
   111.046    55.722     0.200
>
   114.097    56.094     0.200
>
   113.474    55.877     0.200
>
   113.417    55.891     0.200
>
   112.835    56.144     0.200
>
   113.358    55.892     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
   112.941    55.988     0.000   222.000   222.000
   112.941    55.988     0.000   444.000   444.000
EOF
gmt end
