#!/bin/bash
gmt begin novy1.66_base pdf,ps
proj=-JM16.0c+
reg=-R110.9/114.7/55.2/56.5
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map novy1.66'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
   113.168    55.901 1
   112.846    56.406 2
   111.500    55.924 3
   111.638    56.118 4
   111.872    56.109 5
   111.368    55.420 6
   113.396    56.308 7
   113.531    56.333 8
   111.470    55.298 9
   112.967    55.735 10
   112.029    55.610 11
   113.092    56.173 12
   114.576    55.629 13
   112.689    56.147 14
   114.614    56.064 15
   112.061    56.164 16
   111.822    56.019 17
   111.758    56.115 18
   113.824    56.102 19
   113.261    56.108 20
   111.506    56.024 21
   113.498    55.897 22
   113.418    56.032 23
   113.465    55.638 24
   111.805    56.136 25
   111.395    56.019 26
   111.306    56.017 27
   111.330    56.049 28
   111.362    56.037 29
   111.304    56.045 30
   111.390    56.025 31
   111.312    56.040 32
   111.367    56.033 33
   111.261    56.042 34
   111.408    56.016 35
   113.524    55.340 36
   113.603    55.709 37
   113.828    56.036 38
   111.363    56.024 39
   113.755    55.370 40
   111.662    56.153 41
   111.203    56.017 42
   113.585    56.308 43
   113.653    55.476 44
   114.558    56.055 45
   111.468    56.051 46
   111.353    56.010 47
   113.640    56.044 48
   113.494    55.880 49
   113.546    56.229 50
   111.162    55.404 51
   111.747    56.116 52
   113.584    56.227 53
   113.577    56.038 54
   113.992    56.030 55
   113.578    56.225 56
   112.150    56.170 57
   113.687    55.985 58
   112.184    56.057 59
   113.552    55.943 60
   111.915    56.126 61
   111.232    55.698 62
   111.239    55.697 63
   112.101    56.140 64
   113.946    56.068 65
   113.908    56.041 66
   113.910    56.050 67
   113.937    56.041 68
   113.929    56.065 69
   113.927    56.066 70
   113.920    56.057 71
   113.983    56.061 72
   114.023    56.063 73
   113.955    56.060 74
   113.723    56.068 75
   113.935    56.048 76
   112.643    56.057 77
   113.927    56.038 78
   113.833    55.382 79
   113.624    56.004 80
   113.997    56.225 81
   113.922    56.035 82
   113.915    56.224 83
   113.902    56.030 84
   111.486    55.459 85
   113.931    56.037 86
   113.949    56.077 87
   113.699    56.039 88
   113.701    56.061 89
   113.724    56.060 90
   113.732    56.073 91
   113.741    56.059 92
   113.756    56.073 93
   113.745    56.085 94
   113.709    56.052 95
   113.708    56.047 96
   113.727    56.074 97
   113.635    56.096 98
   112.166    56.010 99
   112.604    56.085 100
   114.071    55.773 101
   111.046    55.722 102
   114.097    56.094 103
   113.474    55.877 104
   113.417    55.891 105
   112.835    56.144 106
   113.358    55.892 107
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
   113.300    55.922
   113.168    55.901
>
   112.883    56.226
   112.846    56.406
>
   111.521    56.051
   111.500    55.924
>
   111.456    56.188
   111.638    56.118
>
   111.767    56.206
   111.872    56.109
>
   111.297    55.491
   111.368    55.420
>
   113.316    56.208
   113.396    56.308
>
   113.433    56.354
   113.531    56.333
>
   111.492    55.365
   111.470    55.298
>
   112.839    55.863
   112.967    55.735
>
   112.088    55.614
   112.029    55.610
>
   113.085    56.206
   113.092    56.173
>
   114.523    55.676
   114.576    55.629
>
   112.550    56.213
   112.689    56.147
>
   114.566    56.123
   114.614    56.064
>
   112.110    56.190
   112.061    56.164
>
   111.760    56.050
   111.822    56.019
>
   111.730    56.045
   111.758    56.115
>
   113.770    56.130
   113.824    56.102
>
   113.240    56.150
   113.261    56.108
>
   111.554    55.922
   111.506    56.024
>
   113.840    55.924
   113.498    55.897
>
   113.390    56.040
   113.418    56.032
>
   113.450    55.650
   113.465    55.638
>
   111.790    56.150
   111.805    56.136
>
   111.378    56.056
   111.395    56.019
>
   111.280    56.030
   111.306    56.017
>
   111.300    56.070
   111.330    56.049
>
   111.330    56.050
   111.362    56.037
>
   111.270    56.070
   111.304    56.045
>
   111.360    56.040
   111.390    56.025
>
   111.321    55.990
   111.312    56.040
>
   111.425    56.080
   111.367    56.033
>
   111.165    56.060
   111.261    56.042
>
   111.370    56.060
   111.408    56.016
>
   113.360    55.329
   113.524    55.340
>
   113.740    55.835
   113.603    55.709
>
   113.800    56.060
   113.828    56.036
>
   111.330    56.050
   111.363    56.024
>
   113.750    55.370
   113.755    55.370
>
   111.570    56.210
   111.662    56.153
>
   111.230    56.036
   111.203    56.017
>
   113.560    56.320
   113.585    56.308
>
   113.630    55.510
   113.653    55.476
>
   114.453    56.077
   114.558    56.055
>
   111.390    56.090
   111.468    56.051
>
   111.270    56.050
   111.353    56.010
>
   113.630    56.060
   113.640    56.044
>
   113.492    55.966
   113.494    55.880
>
   113.428    56.206
   113.546    56.229
>
   111.185    55.474
   111.162    55.404
>
   111.720    56.140
   111.747    56.116
>
   113.560    56.240
   113.584    56.227
>
   113.447    55.983
   113.577    56.038
>
   113.980    56.043
   113.992    56.030
>
   113.451    56.123
   113.578    56.225
>
   112.162    56.161
   112.150    56.170
>
   113.724    55.968
   113.687    55.985
>
   112.192    56.197
   112.184    56.057
>
   113.566    55.892
   113.552    55.943
>
   111.838    56.188
   111.915    56.126
>
   111.285    55.716
   111.232    55.698
>
   111.251    55.745
   111.239    55.697
>
   112.060    56.170
   112.101    56.140
>
   113.920    56.090
   113.946    56.068
>
   113.831    55.957
   113.908    56.041
>
   113.880    56.080
   113.910    56.050
>
   114.014    56.079
   113.937    56.041
>
   113.879    56.014
   113.929    56.065
>
   113.900    56.080
   113.927    56.066
>
   113.900    56.070
   113.920    56.057
>
   114.017    56.022
   113.983    56.061
>
   113.977    55.906
   114.023    56.063
>
   113.624    56.349
   113.955    56.060
>
   113.710    56.090
   113.723    56.068
>
   113.881    56.020
   113.935    56.048
>
   112.620    56.100
   112.643    56.057
>
   113.888    56.026
   113.927    56.038
>
   113.672    55.366
   113.833    55.382
>
   113.549    56.036
   113.624    56.004
>
   114.102    56.387
   113.997    56.225
>
   113.893    56.061
   113.922    56.035
>
   113.900    56.260
   113.915    56.224
>
   113.860    56.050
   113.902    56.030
>
   111.446    55.448
   111.486    55.459
>
   113.892    56.132
   113.931    56.037
>
   114.048    56.112
   113.949    56.077
>
   113.749    56.148
   113.699    56.039
>
   113.577    56.083
   113.701    56.061
>
   113.707    56.093
   113.724    56.060
>
   113.648    56.062
   113.732    56.073
>
   113.646    55.943
   113.741    56.059
>
   113.821    56.104
   113.756    56.073
>
   113.716    56.111
   113.745    56.085
>
   113.771    56.092
   113.709    56.052
>
   113.714    56.094
   113.708    56.047
>
   113.700    56.100
   113.727    56.074
>
   113.706    56.215
   113.635    56.096
>
   112.205    56.186
   112.166    56.010
>
   112.572    56.162
   112.604    56.085
>
   114.076    55.875
   114.071    55.773
>
   111.136    55.805
   111.046    55.722
>
   114.000    56.121
   114.097    56.094
>
   113.589    55.911
   113.474    55.877
>
   113.482    55.974
   113.417    55.891
>
   112.880    56.306
   112.835    56.144
>
   113.417    55.981
   113.358    55.892
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
   113.174    55.901
   113.168    55.901
>
   112.859    56.401
   112.846    56.406
>
   111.502    55.925
   111.500    55.924
>
   111.634    56.116
   111.638    56.118
>
   111.873    56.109
   111.872    56.109
>
   111.369    55.421
   111.368    55.420
>
   113.396    56.309
   113.396    56.308
>
   113.530    56.333
   113.531    56.333
>
   111.469    55.302
   111.470    55.298
>
   112.969    55.737
   112.967    55.735
>
   112.030    55.607
   112.029    55.610
>
   113.100    56.172
   113.092    56.173
>
   114.578    55.630
   114.576    55.629
>
   112.688    56.145
   112.689    56.147
>
   114.614    56.063
   114.614    56.064
>
   112.061    56.165
   112.061    56.164
>
   111.822    56.018
   111.822    56.019
>
   111.756    56.117
   111.758    56.115
>
   113.824    56.102
   113.824    56.102
>
   113.260    56.107
   113.261    56.108
>
   111.507    56.024
   111.506    56.024
>
   113.498    55.897
   113.498    55.897
>
   113.418    56.032
   113.418    56.032
>
   113.465    55.638
   113.465    55.638
>
   111.805    56.136
   111.805    56.136
>
   111.395    56.019
   111.395    56.019
>
   111.306    56.017
   111.306    56.017
>
   111.330    56.049
   111.330    56.049
>
   111.362    56.037
   111.362    56.037
>
   111.305    56.045
   111.304    56.045
>
   111.390    56.026
   111.390    56.025
>
   111.313    56.040
   111.312    56.040
>
   111.368    56.032
   111.367    56.033
>
   111.261    56.042
   111.261    56.042
>
   111.408    56.016
   111.408    56.016
>
   113.524    55.340
   113.524    55.340
>
   113.605    55.709
   113.603    55.709
>
   113.828    56.037
   113.828    56.036
>
   111.363    56.024
   111.363    56.024
>
   113.756    55.370
   113.755    55.370
>
   111.662    56.153
   111.662    56.153
>
   111.204    56.017
   111.203    56.017
>
   113.585    56.309
   113.585    56.308
>
   113.653    55.476
   113.653    55.476
>
   114.558    56.055
   114.558    56.055
>
   111.469    56.051
   111.468    56.051
>
   111.354    56.010
   111.353    56.010
>
   113.641    56.044
   113.640    56.044
>
   113.495    55.880
   113.494    55.880
>
   113.546    56.230
   113.546    56.229
>
   111.163    55.404
   111.162    55.404
>
   111.746    56.115
   111.747    56.116
>
   113.583    56.227
   113.584    56.227
>
   113.577    56.038
   113.577    56.038
>
   113.992    56.029
   113.992    56.030
>
   113.578    56.225
   113.578    56.225
>
   112.150    56.170
   112.150    56.170
>
   113.688    55.985
   113.687    55.985
>
   112.185    56.057
   112.184    56.057
>
   113.552    55.943
   113.552    55.943
>
   111.916    56.126
   111.915    56.126
>
   111.233    55.698
   111.232    55.698
>
   111.240    55.697
   111.239    55.697
>
   112.102    56.140
   112.101    56.140
>
   113.946    56.067
   113.946    56.068
>
   113.908    56.040
   113.908    56.041
>
   113.910    56.050
   113.910    56.050
>
   113.937    56.041
   113.937    56.041
>
   113.929    56.065
   113.929    56.065
>
   113.927    56.066
   113.927    56.066
>
   113.920    56.057
   113.920    56.057
>
   113.983    56.061
   113.983    56.061
>
   114.023    56.063
   114.023    56.063
>
   113.956    56.060
   113.955    56.060
>
   113.723    56.068
   113.723    56.068
>
   113.935    56.048
   113.935    56.048
>
   112.644    56.058
   112.643    56.057
>
   113.928    56.039
   113.927    56.038
>
   113.834    55.382
   113.833    55.382
>
   113.624    56.003
   113.624    56.004
>
   113.997    56.225
   113.997    56.225
>
   113.922    56.035
   113.922    56.035
>
   113.916    56.224
   113.915    56.224
>
   113.902    56.030
   113.902    56.030
>
   111.486    55.459
   111.486    55.459
>
   113.930    56.037
   113.931    56.037
>
   113.948    56.076
   113.949    56.077
>
   113.699    56.039
   113.699    56.039
>
   113.701    56.060
   113.701    56.061
>
   113.724    56.060
   113.724    56.060
>
   113.732    56.073
   113.732    56.073
>
   113.740    56.059
   113.741    56.059
>
   113.756    56.073
   113.756    56.073
>
   113.746    56.085
   113.745    56.085
>
   113.709    56.052
   113.709    56.052
>
   113.709    56.047
   113.708    56.047
>
   113.728    56.074
   113.727    56.074
>
   113.636    56.095
   113.635    56.096
>
   112.166    56.010
   112.166    56.010
>
   112.604    56.085
   112.604    56.085
>
   114.071    55.772
   114.071    55.773
>
   111.046    55.722
   111.046    55.722
>
   114.098    56.093
   114.097    56.094
>
   113.473    55.876
   113.474    55.877
>
   113.418    55.891
   113.417    55.891
>
   112.835    56.144
   112.835    56.144
>
   113.360    55.891
   113.358    55.892
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
   113.168    55.901   -30.164     3.866     4.503
   112.846    56.406     3.786     0.467     6.293
   111.500    55.924    79.956     3.491     4.827
   111.638    56.118    72.400     2.813     4.201
   111.872    56.109    81.136     2.232     3.838
   111.368    55.420    32.593     4.662     5.732
   113.396    56.308    78.072     1.647     3.031
   113.531    56.333    72.515     1.553     3.848
   111.470    55.298    39.844     3.820     5.254
   112.967    55.735   -79.538     3.425     3.787
   112.029    55.610    61.894     1.616     2.477
   113.092    56.173    -5.186     0.073     5.287
   114.576    55.629   -88.994     1.923     2.097
   112.689    56.147   -85.427     1.515     1.914
   114.614    56.064    59.757     1.098     1.529
   112.061    56.164    69.425     2.740     4.656
   111.822    56.019    65.516     2.018     3.328
   111.758    56.115    52.389     1.910     3.767
   113.824    56.102    50.432     3.161     3.608
   113.261    56.108    67.613     2.034     4.311
   111.506    56.024    51.059     1.622     3.310
   113.498    55.897    41.361     1.890     2.368
   113.418    56.032    55.237     1.862     2.610
   113.465    55.638    38.723     1.820     2.459
   111.805    56.136    63.618     2.113     3.908
   111.395    56.019    57.960     1.201     1.404
   111.306    56.017    49.140     1.544     3.390
   111.330    56.049    53.211     1.840     3.895
   111.362    56.037    47.838     1.543     3.429
   111.304    56.045    50.626     1.695     3.386
   111.390    56.025    50.206     2.191     4.863
   111.312    56.040    51.943     1.509     1.801
   111.367    56.033    49.845     1.604     3.027
   111.261    56.042    56.696     1.646     2.893
   111.408    56.016    50.708     1.799     3.867
   113.524    55.340    47.170     1.924     3.045
   113.603    55.709    19.690     1.807     2.391
   113.828    56.036    45.688     2.373     2.801
   111.363    56.024    50.970     1.854     4.028
   113.755    55.370    48.827     1.988     2.673
   111.662    56.153    50.067     1.792     3.476
   111.203    56.017    44.394     1.293     2.902
   113.585    56.308    68.934     2.299     2.991
   113.653    55.476    40.481     1.907     2.777
   114.558    56.055    60.399     1.006     1.441
   111.468    56.051    52.090     2.129     5.558
   111.353    56.010    54.567     2.086     4.880
   113.640    56.044    67.472     2.399     2.711
   113.494    55.880    45.034     1.089     1.719
   113.546    56.229    54.079     1.562     2.062
   111.162    55.404    53.075     0.881     1.203
   111.747    56.116    52.815     2.159     3.554
   113.584    56.227    68.654     1.703     2.886
   113.577    56.038    57.879     1.981     2.910
   113.992    56.030    62.203     1.893     2.584
   113.578    56.225    66.339     1.781     2.970
   112.150    56.170    63.206     1.915     3.684
   113.687    55.985    57.914     2.035     2.754
   112.184    56.057    63.241     1.753     2.797
   113.552    55.943    47.115     1.953     2.825
   111.915    56.126    52.139     1.734     2.900
   111.232    55.698    41.839     1.537     2.711
   111.239    55.697    41.793     1.567     2.870
   112.101    56.140    59.640     1.318     2.570
   113.946    56.068    62.172     1.950     2.955
   113.908    56.041    61.683     1.832     2.597
   113.910    56.050    63.417     2.035     2.974
   113.937    56.041    55.302     0.769     1.022
   113.929    56.065    58.435     1.863     2.632
   113.927    56.066    72.977     1.524     2.361
   113.920    56.057    61.498     2.166     3.235
   113.983    56.061    67.392     1.453     2.323
   114.023    56.063    65.618     1.672     2.755
   113.955    56.060    55.019     1.711     2.877
   113.723    56.068    59.615     1.467     2.267
   113.935    56.048    73.705     1.546     2.616
   112.643    56.057    59.015     1.854     3.530
   113.927    56.038    61.508     1.502     2.149
   113.833    55.382    46.265     1.920     2.509
   113.624    56.004    54.275     1.592     2.294
   113.997    56.225    60.866     1.517     2.615
   113.922    56.035    64.064     1.725     2.510
   113.915    56.224    60.893     1.795     3.732
   113.902    56.030    57.977     2.166     3.090
   111.486    55.459    53.447     1.562     2.644
   113.931    56.037    59.723     1.248     1.866
   113.949    56.077    63.255     1.474     2.219
   113.699    56.039    62.197     1.426     2.041
   113.701    56.061    57.919     1.613     2.295
   113.724    56.060    61.940     1.375     1.869
   113.732    56.073    57.693     1.072     1.478
   113.741    56.059    66.996     2.416     3.219
   113.756    56.073    63.726     1.246     1.864
   113.745    56.085    67.143     1.579     2.672
   113.709    56.052    59.222     1.421     2.326
   113.708    56.047    54.759     2.292     3.117
   113.727    56.074    61.471     1.546     2.327
   113.635    56.096    39.353     1.549     2.385
   112.166    56.010    56.409     1.193     1.608
   112.604    56.085    61.134     1.047     1.596
   114.071    55.773    56.079     1.092     1.412
   111.046    55.722    37.929     1.021     1.323
   114.097    56.094    35.025     0.925     1.230
   113.474    55.877    41.483     1.328     1.641
   113.417    55.891    28.755     0.871     1.043
   112.835    56.144    78.102     1.173     1.444
   113.358    55.892    15.741     0.993     1.155
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
   111.041    55.252     8.087     0.933     1.418
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
   111.063    55.252   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
   111.041    55.252     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
   111.041    55.252     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
   111.041    55.207   5 km
EOF
gmt end
