#!/bin/bash
gmt begin larino1.84_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases larino1.84'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     2.973
     1.500    -0.871
     2.000    -4.716
     2.500    -8.560
     3.000   -12.404
     3.500   -16.248
     4.000   -20.096
     4.500   -23.944
     5.000   -27.795
     5.500   -31.646
     6.000   -35.500
     6.500   -39.356
     7.000   -43.216
     7.500   -47.078
     8.000   -50.942
     8.500   -54.811
     9.000   -58.682
     9.500   -62.557
    10.000   -66.437
    10.500   -70.320
    11.000   -74.208
    11.500   -78.100
    12.000   -81.998
    12.500   -85.900
    13.000   -89.808
    13.500   -93.721
    14.000   -97.640
    14.500  -101.566
    15.000  -105.496
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -86.808 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.060
     1.000    -0.570
     1.500    -2.201
     2.000    -3.832
     2.500    -5.462
     3.000    -7.094
     3.500    -8.728
     4.000   -10.363
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -13.363 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
    11.504    56.028     0.200
     3.002    14.310     0.200
     3.086    12.769     0.200
     3.054    12.941     0.200
     3.135    11.251     0.200
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     7.220     4.082     0.200
     8.761     0.222     0.200
     3.177     0.067     0.200
     3.096     7.355     0.200
     3.191     7.087     0.200
     3.125     1.086     0.200
    10.090     2.408     0.200
    10.160     3.184     0.200
     6.569    -0.198     0.200
     3.150     1.575     0.200
     3.655    -2.137     0.200
     3.543     5.730     0.200
     4.919     1.611     0.200
     3.240    -0.575     0.200
     3.260    -1.091     0.200
     3.186    -1.081     0.200
     4.346     0.488     0.200
     4.379    -1.859     0.200
    10.136     6.137     0.200
     5.455     1.807     0.200
     5.764     5.997     0.200
     3.126    -3.043     0.200
     4.361     0.317     0.200
     2.932     7.590     0.200
     3.907    -5.523     0.200
     4.320    -2.308     0.200
     4.620     4.885     0.200
     6.400    -2.036     0.200
     3.925     2.042     0.200
     6.017     1.901     0.200
     9.856     2.837     0.200
     4.624     4.364     0.200
     4.117    -3.413     0.200
     4.272    -1.200     0.200
     6.585     3.270     0.200
     3.249    -0.752     0.200
     3.765     4.233     0.200
     4.125    -2.192     0.200
     4.655    11.523     0.200
     6.184     5.840     0.200
     7.482     5.905     0.200
     8.640     4.209     0.200
     5.260     5.887     0.200
     5.485     0.206     0.200
     3.602     5.495     0.200
     2.508     2.068     0.200
     4.285    -2.704     0.200
     5.559     5.814     0.200
     7.693     0.154     0.200
     9.187    -5.204     0.200
     4.808     3.117     0.200
     5.489     3.718     0.200
     4.819     1.124     0.200
     5.576    -0.069     0.200
     3.733     5.432     0.200
     4.795     3.262     0.200
     5.476     4.679     0.200
     4.809     2.354     0.200
     6.680     5.249     0.200
     4.802     0.702     0.200
     5.481     3.880     0.200
     4.299     0.520     0.200
     5.799     3.471     0.200
     9.209    -7.317     0.200
     9.226     3.268     0.200
     4.325     0.924     0.200
     6.873    -4.332     0.200
     4.334     0.350     0.200
     7.703     0.245     0.200
     3.930     4.183     0.200
     9.241     1.468     0.200
     3.953     4.114     0.200
     7.729     0.480     0.200
     8.928     3.867     0.200
     9.221    -4.879     0.200
     4.294    -6.124     0.200
     7.720     0.295     0.200
     4.407     6.618     0.200
     2.531    -2.597     0.200
     8.718    -6.193     0.200
     9.612     6.102     0.200
     4.838     6.629     0.200
     2.887     2.336     0.200
     7.400    -1.951     0.200
     5.689     4.604     0.200
     6.031     6.752     0.200
     6.182    -0.006     0.200
     8.011    -3.017     0.200
     8.848    -5.494     0.200
     2.666     0.660     0.200
     9.992     3.116     0.200
     9.702     0.076     0.200
     9.708    -5.732     0.200
     9.745    -6.206     0.200
     4.369     0.872     0.200
     7.052    -3.193     0.200
     8.834     3.389     0.200
     9.555     2.334     0.200
     6.448    -2.467     0.200
     8.796   -42.289     0.200
     9.540     0.714     0.200
     3.262    -2.676     0.200
     3.770    -1.291     0.200
     3.800     4.805     0.200
     3.926    -0.234     0.200
     4.398    -2.436     0.200
     4.846     5.609     0.200
     5.809    -5.659     0.200
     5.957     6.862     0.200
     6.330    -5.477     0.200
     6.560    -7.171     0.200
     6.935    -7.549     0.200
     7.132    -6.002     0.200
     7.219    -7.164     0.200
     7.752   -37.764     0.200
     8.002    -6.984     0.200
     8.244    -8.541     0.200
     8.474    -9.244     0.200
     8.464    53.883     0.200
     8.621    -8.899     0.200
     8.814   -41.333     0.200
     9.242    -9.388     0.200
     9.300    -9.324     0.200
     9.434    -7.157     0.200
     9.561    -0.904     0.200
     9.599    -9.307     0.200
     9.607    -9.369     0.200
     9.641    -9.430     0.200
    10.788    -7.190     0.200
    10.807    -9.298     0.200
    11.446    -8.056     0.200
     6.560     5.212     0.200
     9.567     2.989     0.200
     9.639     2.220     0.200
     9.815     1.113     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     3.905   -16.061     0.200
     4.020   -19.984     0.200
     4.678   -24.354     0.200
     4.749   -23.215     0.200
     4.865   -25.179     0.200
     4.933   -25.317     0.200
     5.565   -32.471     0.200
     6.748   -37.961     0.200
     7.196   -46.178     0.200
     8.074   -54.008     0.200
     8.839   -57.064     0.200
     8.872   -55.305     0.200
     8.981   -62.541     0.200
     9.113   -58.926     0.200
     9.818   -67.278     0.200
    10.284   -67.064     0.200
     4.680   -24.195     0.200
     4.797   -24.892     0.200
     4.941   -26.956     0.200
     5.111   -30.163     0.200
     5.546   -31.445     0.200
     8.080   -49.266     0.200
     8.882   -57.698     0.200
     8.910   -58.084     0.200
     9.126   -58.023     0.200
     9.244   -61.354     0.200
     3.177   -13.433     0.200
     4.002   -21.604     0.200
     4.213   -24.072     0.200
     4.952   -32.002     0.200
     6.432   -39.418     0.200
     7.099   -47.578     0.200
     8.504   -60.895     0.200
     8.843   -64.255     0.200
     9.598   -67.578     0.200
     9.805   -71.443     0.200
     4.965   -27.868     0.200
     5.085   -27.401     0.200
     6.878   -42.026     0.200
     7.020   -41.511     0.200
     6.969   -44.305     0.200
     7.109   -43.964     0.200
     8.351   -53.728     0.200
     8.449   -55.438     0.200
     9.138   -60.652     0.200
     9.275   -63.604     0.200
     9.451   -62.587     0.200
     9.571   -64.678     0.200
    10.505   -71.496     0.200
    11.877   -81.600     0.200
     3.041   -12.633     0.200
     3.300   -11.558     0.200
     4.087   -17.196     0.200
     4.670   -23.778     0.200
     5.017   -28.063     0.200
     5.197   -29.474     0.200
     5.438   -30.022     0.200
     5.885   -37.809     0.200
     5.957   -35.071     0.200
     7.059   -43.520     0.200
     7.132   -39.832     0.200
     8.395   -52.855     0.200
     9.536   -65.734     0.200
     9.661   -66.699     0.200
    10.605   -68.928     0.200
     8.184   -58.399     0.200
     3.033   -13.516     0.200
     3.597   -14.404     0.200
     3.975   -15.503     0.200
     4.241   -23.808     0.200
     4.693   -23.657     0.200
     5.010   -26.812     0.200
     5.174   -29.291     0.200
     5.241   -31.527     0.200
     5.874   -35.590     0.200
     7.057   -42.492     0.200
     7.056   -43.059     0.200
     7.273   -45.933     0.200
     7.283   -43.249     0.200
     7.456   -42.742     0.200
     7.676   -49.718     0.200
     8.391   -53.367     0.200
     8.391   -53.867     0.200
     9.170   -61.080     0.200
     9.170   -61.580     0.200
     9.326   -61.912     0.200
     9.645   -64.136     0.200
    10.027   -62.731     0.200
    10.087   -61.144     0.200
    10.566   -71.114     0.200
    10.601   -68.441     0.200
    20.013  -133.782     0.200
    21.117  -143.784     0.200
    22.087  -154.552     0.200
     3.034   -11.066     0.200
     4.921   -24.179     0.200
     4.979   -27.106     0.200
     5.833   -35.283     0.200
     7.030   -40.230     0.200
     8.363   -52.484     0.200
     9.147   -60.325     0.200
     9.597   -63.405     0.200
     1.998    -6.103     0.200
     3.821   -17.087     0.200
     4.193   -20.679     0.200
     4.880   -25.951     0.200
     4.919   -28.690     0.200
     4.923   -24.332     0.200
     4.927   -23.444     0.200
     5.178   -30.492     0.200
     5.729   -34.868     0.200
     5.766   -32.050     0.200
     6.993   -42.430     0.200
     8.318   -52.438     0.200
     9.455   -62.999     0.200
    10.057   -67.556     0.200
     1.945    -4.896     0.200
     3.056   -12.121     0.200
     4.663   -24.580     0.200
     4.806   -26.090     0.200
     4.843   -27.393     0.200
     4.876   -22.815     0.200
     4.930   -23.546     0.200
     5.104   -29.141     0.200
     5.693   -30.234     0.200
     6.919   -39.575     0.200
     8.243   -49.564     0.200
     8.243   -49.865     0.200
     9.385   -60.946     0.200
     9.981   -68.649     0.200
    10.453   -67.611     0.200
     0.930     3.772     0.200
     2.410    -7.637     0.200
     3.127   -13.887     0.200
     3.761   -15.983     0.200
     3.950   -19.980     0.200
     4.007   -18.481     0.200
     4.811   -22.772     0.200
     5.105   -27.592     0.200
     5.725   -33.734     0.200
     5.793   -30.892     0.200
     6.921   -39.635     0.200
     9.038   -56.755     0.200
     9.070   -56.255     0.200
     3.037   -11.525     0.200
     4.945   -27.617     0.200
     4.784   -25.418     0.200
     5.187   -29.689     0.200
     5.789   -35.256     0.200
     6.866   -43.414     0.200
     7.003   -43.736     0.200
     8.334   -53.928     0.200
     9.122   -60.908     0.200
     9.254   -62.508     0.200
    10.544   -28.998     0.200
     0.981     3.637     0.200
     1.215     2.715     0.200
     2.844   -10.133     0.200
     3.904   -15.545     0.200
     3.965   -18.649     0.200
     4.140   -15.714     0.200
     4.689   -23.227     0.200
     4.901   -27.331     0.200
     5.132   -26.971     0.200
     5.767   -35.100     0.200
     6.793   -40.109     0.200
     6.947   -40.006     0.200
     7.613   -40.107     0.200
     8.282   -53.300     0.200
    10.044   -68.174     0.200
     1.464    -1.261     0.200
     1.780    -1.298     0.200
     3.449   -14.213     0.200
     3.732   -15.179     0.200
     4.116   -19.852     0.200
     4.352   -18.834     0.200
     4.713   -23.568     0.200
     4.852   -26.688     0.200
     4.852   -21.188     0.200
     4.965   -27.273     0.200
     5.425   -31.346     0.200
     5.545   -32.837     0.200
     5.602   -31.461     0.200
     6.674   -41.418     0.200
     6.674   -38.418     0.200
     8.108   -50.886     0.200
     8.904   -56.138     0.200
     1.112     1.999     0.200
     2.402   -12.486     0.200
     2.695   -11.261     0.200
     2.996   -11.223     0.200
     5.052   -29.369     0.200
     5.282   -31.188     0.200
     8.432   -53.529     0.200
     9.211   -62.238     0.200
     9.211   -62.738     0.200
     1.501     1.786     0.200
     4.711   -21.552     0.200
     4.913   -23.679     0.200
     5.576   -27.878     0.200
     6.785   -37.724     0.200
     8.110   -48.711     0.200
     3.071   -11.594     0.200
     3.523   -17.451     0.200
     3.982   -15.193     0.200
     4.088   -18.338     0.200
     4.188   -23.521     0.200
     4.703   -23.857     0.200
     4.703   -19.857     0.200
     4.957   -28.778     0.200
     5.133   -28.263     0.200
     5.189   -28.853     0.200
     5.890   -27.460     0.200
     7.004   -40.788     0.200
     7.221   -42.656     0.200
     7.242   -43.325     0.200
     7.395   -42.183     0.200
     7.409   -45.616     0.200
     8.338   -53.075     0.200
     9.119   -59.840     0.200
     9.119   -60.340     0.200
     9.591   -64.502     0.200
    10.100   -67.918     0.200
     2.723   -10.121     0.200
     3.560   -16.060     0.200
     3.723   -15.021     0.200
     3.982   -16.040     0.200
     4.185   -16.695     0.200
     4.203   -23.643     0.200
     4.360   -21.134     0.200
     4.959   -28.213     0.200
     5.014   -29.350     0.200
     5.253   -32.443     0.200
     5.916   -33.965     0.200
     7.068   -42.487     0.200
     7.323   -43.549     0.200
     7.483   -48.621     0.200
     8.400   -54.708     0.200
     8.400   -54.308     0.200
     9.798   -61.818     0.200
    10.611   -67.779     0.200
     1.070     2.025     0.200
     3.423   -16.160     0.200
     4.208   -22.440     0.200
     4.196   -19.058     0.200
     5.047   -30.840     0.200
     5.289   -32.691     0.200
     7.104   -43.737     0.200
     8.435   -56.940     0.200
     3.770   -16.876     0.200
     3.825   -14.327     0.200
     3.983   -15.257     0.200
     4.107   -18.184     0.200
     4.414   -17.589     0.200
     4.491   -19.850     0.200
     4.700   -22.776     0.200
     5.071   -26.222     0.200
     5.512   -30.024     0.200
     6.065   -32.333     0.200
     6.348   -36.606     0.200
     6.736   -38.824     0.200
     6.854   -39.546     0.200
     6.881   -40.419     0.200
     7.652   -48.466     0.200
     7.892   -47.442     0.200
     8.192   -49.965     0.200
     8.192   -49.567     0.200
     8.252   -50.880     0.200
     9.018   -56.143     0.200
     9.018   -56.643     0.200
     9.040   -60.160     0.200
    11.867   -72.473     0.200
     2.283    -5.837     0.200
     2.659    -8.745     0.200
     3.362   -12.541     0.200
     3.679   -18.573     0.200
     3.745   -18.464     0.200
     3.745   -15.660     0.200
     3.874   -17.962     0.200
     4.157   -19.020     0.200
     4.286   -20.334     0.200
     4.302   -20.113     0.200
     4.414   -21.270     0.200
     4.638   -23.280     0.200
     4.842   -19.951     0.200
     5.315   -26.634     0.200
     5.494   -28.001     0.200
     5.489   -29.564     0.200
     6.038   -35.059     0.200
     6.427   -34.698     0.200
     6.470   -36.454     0.200
     6.646   -38.520     0.200
     6.646   -38.020     0.200
     6.780   -38.880     0.200
     6.780   -38.677     0.200
     7.060   -39.739     0.200
     8.203   -53.891     0.200
     8.360   -51.972     0.200
     8.425   -54.428     0.200
     8.536   -57.544     0.200
     1.038     2.130     0.200
     1.170     1.451     0.200
     2.823   -11.960     0.200
     3.006   -12.669     0.200
     3.036   -14.721     0.200
     3.240   -12.779     0.200
     3.476   -13.169     0.200
     3.623   -18.700     0.200
     4.168   -20.192     0.200
     4.206   -21.587     0.200
     4.320   -23.308     0.200
     4.485   -23.456     0.200
     4.593   -25.865     0.200
     4.989   -29.515     0.200
     5.333   -33.513     0.200
     5.273   -31.727     0.200
     5.519   -29.915     0.200
     5.556   -34.584     0.200
     5.706   -32.355     0.200
     5.706   -30.054     0.200
     5.724   -33.803     0.200
     5.910   -37.801     0.200
     6.291   -36.885     0.200
     6.627   -42.538     0.200
     6.716   -47.063     0.200
     7.640   -50.653     0.200
     7.634   -52.469     0.200
     8.380   -55.109     0.200
     9.257   -65.901     0.200
     9.959   -69.368     0.200
    10.028   -71.161     0.200
    10.234   -72.887     0.200
    11.506   -77.510     0.200
     3.213   -10.298     0.200
     3.381   -13.612     0.200
     3.422   -14.926     0.200
     3.667   -13.682     0.200
     3.760   -15.643     0.200
     3.888   -16.180     0.200
     4.118   -21.898     0.200
     4.128   -18.416     0.200
     4.302   -16.826     0.200
     4.319   -16.843     0.200
     5.328   -27.331     0.200
     5.513   -29.614     0.200
     5.979   -40.987     0.200
     6.316   -36.646     0.200
     6.633   -38.717     0.200
     7.540   -47.473     0.200
     8.381   -55.135     0.200
     2.624   -11.094     0.200
     2.957   -15.662     0.200
     3.867   -22.488     0.200
     4.156   -25.775     0.200
     4.233   -24.302     0.200
     4.841   -27.388     0.200
     5.343   -32.194     0.200
     5.970   -37.077     0.200
     5.943   -33.310     0.200
     6.214   -39.307     0.200
     6.256   -44.531     0.200
     6.305   -35.772     0.200
     7.309   -48.608     0.200
     7.553   -50.243     0.200
     8.082   -55.102     0.200
     8.278   -56.340     0.200
     8.625   -60.816     0.200
     8.800   -62.488     0.200
     9.494   -67.865     0.200
     9.563   -67.055     0.200
     9.769   -69.788     0.200
     9.884   -71.055     0.200
    10.083   -71.554     0.200
     3.631   -17.140     0.200
     3.664   -17.682     0.200
     4.049   -19.977     0.200
     4.131   -19.476     0.200
     4.557   -23.980     0.200
     4.596   -23.924     0.200
     4.610   -28.555     0.200
     4.899   -28.614     0.200
     4.918   -28.318     0.200
     8.023   -50.871     0.200
     8.845   -58.926     0.200
     1.616    -1.171     0.200
     3.457   -14.533     0.200
     3.481   -17.311     0.200
     4.053   -20.422     0.200
     4.341   -23.659     0.200
     4.480   -23.481     0.200
     5.095   -29.970     0.200
     5.533   -29.559     0.200
     5.909   -38.257     0.200
     6.154   -37.628     0.200
     6.438   -42.844     0.200
     7.494   -48.627     0.200
     8.261  -100.827     0.200
     8.261   -55.827     0.200
     8.471   -59.469     0.200
     8.814   -63.348     0.200
     8.985   -64.088     0.200
     9.280   -64.145     0.200
     9.734   -68.012     0.200
     9.942   -70.607     0.200
    10.233   -68.929     0.200
    11.247   -75.397     0.200
     2.384    -8.992     0.200
     3.283   -14.509     0.200
     3.732   -15.225     0.200
     3.833   -18.333     0.200
     3.920   -18.207     0.200
     4.084   -17.889     0.200
     4.176   -17.297     0.200
     4.380   -22.880     0.200
     4.392   -22.651     0.200
     4.374   -19.083     0.200
     4.386   -19.457     0.200
     4.766   -28.298     0.200
     5.046   -30.874     0.200
     7.488   -46.309     0.200
     0.922     0.625     0.200
     3.061   -12.881     0.200
     3.231   -14.184     0.200
     3.299   -14.934     0.200
     3.444   -15.518     0.200
     3.550   -16.887     0.200
     3.579   -16.301     0.200
     4.053   -20.835     0.200
     4.180   -23.441     0.200
     4.124   -20.384     0.200
     4.177   -21.453     0.200
     4.367   -26.576     0.200
     4.923   -29.613     0.200
     6.017   -35.997     0.200
     6.518   -38.653     0.200
     6.591   -39.972     0.200
     8.027   -54.298     0.200
     8.027   -51.298     0.200
     8.841   -58.923     0.200
     1.077     5.134     0.200
     1.494     1.906     0.200
     1.539     0.387     0.200
     1.722     0.686     0.200
     3.005   -11.068     0.200
     3.195   -12.002     0.200
     3.203   -13.065     0.200
     3.459   -15.583     0.200
     3.471   -14.235     0.200
     3.545   -15.390     0.200
     3.940   -17.827     0.200
     4.006   -17.412     0.200
     4.089   -19.439     0.200
     4.116   -19.695     0.200
     4.339   -19.263     0.200
     4.523   -21.590     0.200
     4.544   -23.853     0.200
     4.757   -21.845     0.200
     5.092   -25.649     0.200
     5.124   -27.626     0.200
     5.373   -26.028     0.200
     5.636   -27.681     0.200
     5.864   -32.806     0.200
     6.108   -33.593     0.200
     6.136   -31.945     0.200
     6.136   -28.640     0.200
     6.211   -31.824     0.200
     7.649   -44.679     0.200
     8.649   -55.906     0.200
     8.771   -55.959     0.200
     1.062     1.461     0.200
     1.292    -1.331     0.200
     2.350    -9.076     0.200
     2.907   -13.222     0.200
     3.058   -12.298     0.200
     3.416   -14.143     0.200
     3.598   -15.139     0.200
     3.611   -15.452     0.200
     3.927   -22.571     0.200
     3.997   -23.761     0.200
     4.013   -20.267     0.200
     4.047   -22.971     0.200
     4.220   -23.346     0.200
     4.286   -23.746     0.200
     4.375   -21.767     0.200
     4.645   -26.806     0.200
     4.922   -30.597     0.200
     5.985   -33.279     0.200
     6.067   -35.797     0.200
     6.062   -37.953     0.200
     6.227   -37.358     0.200
     7.074   -46.622     0.200
     7.158   -48.264     0.200
     7.370   -48.692     0.200
     8.151   -55.969     0.200
     8.457   -58.455     0.200
     8.630   -60.837     0.200
     8.796   -62.106     0.200
     9.140   -63.219     0.200
     9.463   -66.855     0.200
     9.536   -68.877     0.200
     9.745   -69.387     0.200
     9.829   -69.755     0.200
     9.857   -70.249     0.200
    10.049   -69.616     0.200
     1.510    -0.002     0.200
     1.767    -1.453     0.200
     2.041    -4.118     0.200
     2.039    -3.960     0.200
     3.926   -17.487     0.200
     4.344   -20.338     0.200
     4.511   -22.423     0.200
     4.588   -22.668     0.200
     5.367   -30.450     0.200
     6.299   -31.293     0.200
     7.368   -45.886     0.200
     7.664   -48.169     0.200
     8.766   -58.423     0.200
     8.943   -59.919     0.200
     9.105   -61.350     0.200
    10.038   -66.544     0.200
     3.846   -19.370     0.200
     4.313   -22.091     0.200
     4.336   -22.803     0.200
     4.392   -24.876     0.200
     4.551   -25.815     0.200
     5.733   -30.497     0.200
     6.326   -34.087     0.200
     7.407   -48.652     0.200
     7.703   -50.734     0.200
     8.476   -57.743     0.200
     8.778   -60.215     0.200
     9.116   -63.632     0.200
    10.040   -67.630     0.200
     1.296     0.223     0.200
     1.533    -1.405     0.200
     1.666    -2.112     0.200
     2.159    -6.753     0.200
     2.241    -9.323     0.200
     2.536    -9.786     0.200
     2.609   -11.588     0.200
     3.152   -15.431     0.200
     3.673   -18.014     0.200
     3.739   -18.035     0.200
     3.716   -19.385     0.200
     4.360   -24.513     0.200
     4.481   -25.231     0.200
     4.472   -25.553     0.200
     5.661   -32.264     0.200
     6.249   -36.081     0.200
     6.331   -35.297     0.200
     6.365   -36.571     0.200
     6.508   -37.713     0.200
     7.217   -47.184     0.200
     7.506   -50.132     0.200
     7.514   -50.998     0.200
     8.540   -55.202     0.200
     9.895   -71.970     0.200
    10.164   -70.192     0.200
    10.283   -75.663     0.200
    10.488   -76.063     0.200
     2.257   -10.192     0.200
     2.527   -12.047     0.200
     2.598   -12.487     0.200
     3.016   -13.664     0.200
     3.141   -15.723     0.200
     3.170   -16.042     0.200
     3.663   -17.650     0.200
     4.350   -25.628     0.200
     4.462   -25.502     0.200
     6.241   -34.591     0.200
     6.324   -36.912     0.200
     6.324   -34.912     0.200
     7.207   -46.591     0.200
     7.572   -53.179     0.200
     8.973   -62.985     0.200
     9.166   -65.812     0.200
     9.895   -71.610     0.200
     9.959   -71.962     0.200
    10.163   -74.005     0.200
    10.163   -71.903     0.200
     2.190    -7.820     0.200
     2.381   -10.074     0.200
     2.409    -8.665     0.200
     2.636   -11.760     0.200
     2.668   -11.175     0.200
     2.724   -12.250     0.200
     3.162   -14.135     0.200
     3.269   -15.918     0.200
     3.305   -15.857     0.200
     3.754   -20.782     0.200
     3.837   -20.610     0.200
     4.272   -25.200     0.200
     4.464   -27.102     0.200
     4.447   -26.255     0.200
     4.548   -26.949     0.200
     5.353   -33.494     0.200
     5.448   -34.097     0.200
     5.533   -34.289     0.200
     6.552   -43.095     0.200
     6.868   -44.917     0.200
     7.146   -46.911     0.200
     7.555   -53.384     0.200
     7.575   -53.532     0.200
     9.185   -67.058     0.200
     9.880   -71.595     0.200
     9.950   -72.914     0.200
    10.272   -74.107     0.200
     3.012   -12.194     0.200
     3.009   -10.488     0.200
     3.269   -14.426     0.200
     3.282   -12.643     0.200
     3.354   -14.320     0.200
     3.756   -15.763     0.200
     3.770   -15.301     0.200
     3.898   -17.868     0.200
     3.926   -18.365     0.200
     3.945   -15.753     0.200
     4.506   -23.350     0.200
     4.484   -21.255     0.200
     4.606   -23.917     0.200
     4.524   -21.802     0.200
     4.945   -26.229     0.200
     5.681   -31.138     0.200
     5.935   -34.350     0.200
     6.027   -35.091     0.200
     6.218   -35.113     0.200
     6.158   -29.318     0.200
     6.242   -33.775     0.200
     6.241   -31.426     0.200
     6.553   -40.642     0.200
     7.622   -46.730     0.200
     8.427   -54.739     0.200
     8.719   -58.494     0.200
     8.855   -60.310     0.200
     9.741   -66.990     0.200
     0.992     3.465     0.200
     3.833   -16.570     0.200
     3.997   -18.878     0.200
     4.060   -18.769     0.200
     4.215   -20.099     0.200
     4.411   -22.806     0.200
     4.716   -23.471     0.200
     4.722   -23.777     0.200
     5.247   -28.353     0.200
     5.808   -31.977     0.200
     5.997   -34.773     0.200
     6.213   -34.980     0.200
     6.275   -35.290     0.200
     6.341   -35.481     0.200
     6.442   -35.757     0.200
     6.483   -34.895     0.200
     7.538   -46.742     0.200
     7.830   -47.791     0.200
     8.663   -55.698     0.200
     9.529   -64.140     0.200
     1.240    -0.463     0.200
     2.125    -7.301     0.200
     3.173   -12.139     0.200
     3.676   -15.786     0.200
     3.718   -16.004     0.200
     3.778   -16.510     0.200
     4.907   -26.189     0.200
     4.920   -29.995     0.200
     6.026   -37.178     0.200
     6.596   -41.336     0.200
     8.947   -61.163     0.200
     9.323   -65.981     0.200
     2.314    -6.681     0.200
     2.246    -7.103     0.200
     2.431    -7.470     0.200
     2.601    -9.178     0.200
     3.512   -17.241     0.200
     3.625   -16.817     0.200
     3.912   -20.439     0.200
     4.125   -20.192     0.200
     4.078   -16.905     0.200
     4.333   -22.062     0.200
     4.245   -23.579     0.200
     4.397   -22.006     0.200
     5.505   -29.611     0.200
     6.021   -37.480     0.200
     6.088   -31.396     0.200
     6.170   -33.717     0.200
     6.184   -33.855     0.200
     6.328   -34.902     0.200
     6.573   -36.682     0.200
     6.934   -35.717     0.200
     7.187   -45.933     0.200
     7.511   -49.020     0.200
     7.482   -49.595     0.200
     7.482   -45.595     0.200
     8.169   -55.159     0.200
     8.265   -55.207     0.200
     8.351   -57.653     0.200
     8.355   -51.856     0.200
     8.338   -61.228     0.200
     8.500   -56.657     0.200
     8.540   -57.942     0.200
     8.719   -60.500     0.200
     8.879   -60.166     0.200
     9.250   -62.640     0.200
     9.603   -65.221     0.200
     9.700   -65.818     0.200
     9.813   -66.294     0.200
     9.892   -66.188     0.200
     9.923   -66.169     0.200
    10.108   -66.940     0.200
    10.411   -70.329     0.200
    11.052   -77.253     0.200
     1.154     1.840     0.200
     1.457    -0.533     0.200
     3.646   -17.151     0.200
     4.159   -20.999     0.200
     4.356   -22.442     0.200
     4.415   -23.328     0.200
     4.655   -21.313     0.200
     5.522   -30.395     0.200
     6.096   -31.996     0.200
     6.190   -34.186     0.200
     8.492   -56.843     0.200
     8.532   -57.624     0.200
     8.714   -58.398     0.200
     8.870   -59.140     0.200
     9.506   -63.001     0.200
     9.796   -64.994     0.200
     4.669   -21.957     0.200
     4.698   -23.799     0.200
     4.786   -23.883     0.200
     5.097   -24.934     0.200
     5.099   -27.990     0.200
     6.073   -34.860     0.200
     6.199   -35.357     0.200
     6.332   -33.569     0.200
     6.316   -36.510     0.200
     6.320   -34.805     0.200
     6.459   -34.720     0.200
     6.476   -34.764     0.200
     6.474   -32.096     0.200
     6.579   -38.501     0.200
     6.834   -38.502     0.200
     7.481   -44.202     0.200
     7.774   -48.284     0.200
     8.503   -53.991     0.200
     8.594   -53.786     0.200
     8.642   -57.111     0.200
     8.875   -55.808     0.200
     9.029   -52.861     0.200
     9.491   -62.227     0.200
     4.015   -17.700     0.200
     4.225   -20.884     0.200
     4.321   -17.811     0.200
     4.733   -23.980     0.200
     5.438   -33.415     0.200
     6.309   -31.035     0.200
     6.293   -34.921     0.200
     6.377   -33.999     0.200
     6.502   -32.649     0.200
     6.520   -32.416     0.200
     6.543   -37.344     0.200
     7.560   -47.488     0.200
     8.512   -53.857     0.200
     8.883   -55.721     0.200
     3.970   -17.047     0.200
     4.171   -19.725     0.200
     4.378   -20.007     0.200
     4.687   -23.502     0.200
     4.706   -24.406     0.200
     5.124   -24.841     0.200
     5.117   -28.548     0.200
     5.883   -34.497     0.200
     6.087   -35.538     0.200
     6.220   -38.870     0.200
     6.289   -30.780     0.200
     6.361   -32.365     0.200
     6.347   -35.406     0.200
     6.371   -31.275     0.200
     6.326   -34.837     0.200
     6.499   -36.325     0.200
     6.500   -31.971     0.200
     7.519   -46.373     0.200
     7.812   -48.052     0.200
     8.103   -49.489     0.200
     8.521   -56.039     0.200
     8.634   -56.114     0.200
     8.676   -57.033     0.200
     8.894   -56.539     0.200
     9.729   -61.726     0.200
     1.113     3.788     0.200
     1.182     3.417     0.200
     3.273   -10.969     0.200
     3.456   -12.384     0.200
     3.473   -11.929     0.200
     3.735   -14.436     0.200
     3.814   -14.441     0.200
     4.199   -18.419     0.200
     4.358   -18.776     0.200
     4.383   -19.458     0.200
     4.572   -20.756     0.200
     4.577   -24.917     0.200
     5.651   -32.277     0.200
     6.066   -33.422     0.200
     7.680   -45.790     0.200
     1.585    -3.675     0.200
     2.175    -6.975     0.200
     2.389    -8.352     0.200
     2.369    -9.329     0.200
     2.651   -10.342     0.200
     2.630   -10.981     0.200
     2.712   -11.778     0.200
     3.141   -14.198     0.200
     3.256   -15.240     0.200
     3.289   -15.485     0.200
     3.720   -18.633     0.200
     3.801   -19.628     0.200
     4.112   -18.655     0.200
     4.412   -24.294     0.200
     4.514   -25.521     0.200
     4.265   -21.122     0.200
     5.534   -33.243     0.200
     5.627   -30.701     0.200
     6.220   -35.890     0.200
     6.273   -34.869     0.200
     6.355   -35.686     0.200
     6.475   -41.584     0.200
     6.549   -42.237     0.200
     6.560   -41.460     0.200
     6.620   -48.662     0.200
     7.092   -51.944     0.200
     7.208   -46.814     0.200
     7.229   -47.384     0.200
     7.537   -51.062     0.200
     7.558   -52.303     0.200
     7.567   -49.305     0.200
     7.614   -52.003     0.200
     7.704   -45.326     0.200
     8.213   -57.082     0.200
     8.254   -53.356     0.200
     8.487   -60.752     0.200
     8.496   -58.955     0.200
     8.661   -58.470     0.200
     8.779   -61.832     0.200
     8.896   -56.831     0.200
     8.942   -58.888     0.200
     8.978   -65.512     0.200
     9.161   -66.117     0.200
     9.374   -64.772     0.200
     9.862   -69.759     0.200
    10.137   -73.268     0.200
    10.228   -70.554     0.200
    10.253   -74.241     0.200
    10.761   -75.763     0.200
    13.124   -96.851     0.200
    13.412   -97.687     0.200
    13.484   -97.963     0.200
     2.136    -7.342     0.200
     2.331    -9.243     0.200
     2.348    -8.573     0.200
     2.594   -12.373     0.200
     2.610   -11.585     0.200
     2.673   -12.578     0.200
     3.100   -14.616     0.200
     3.217   -16.331     0.200
     3.249   -15.548     0.200
     3.704   -19.661     0.200
     4.086   -19.264     0.200
     4.395   -24.661     0.200
     4.500   -26.104     0.200
     5.510   -33.323     0.200
     6.201   -37.922     0.200
     6.266   -36.867     0.200
     6.348   -35.690     0.200
     6.497   -39.592     0.200
     6.523   -35.509     0.200
     6.627   -50.610     0.200
     7.046   -48.611     0.200
     7.572   -53.985     0.200
     7.550   -50.266     0.200
     9.166   -67.305     0.200
     9.360   -64.144     0.200
     9.876   -71.217     0.200
    10.242   -72.919     0.200
     2.632    -9.534     0.200
     2.966   -11.724     0.200
     3.506   -15.706     0.200
     3.516   -13.996     0.200
     3.595   -14.900     0.200
     4.174   -20.955     0.200
     4.250   -22.253     0.200
     4.634   -23.414     0.200
     5.967   -30.191     0.200
     5.988   -33.659     0.200
     6.071   -31.370     0.200
     6.214   -31.417     0.200
     6.325   -33.768     0.200
     6.634   -37.436     0.200
     7.031   -46.622     0.200
     8.127   -52.946     0.200
     8.430   -55.860     0.200
     8.636   -58.893     0.200
     8.810   -59.224     0.200
     9.776   -67.133     0.200
     9.891   -65.480     0.200
     1.734    -4.386     0.200
     2.450    -8.380     0.200
     2.620    -8.926     0.200
     2.664   -10.500     0.200
     2.903   -11.331     0.200
     2.948   -12.973     0.200
     2.999   -12.766     0.200
     3.362   -14.332     0.200
     3.540   -16.721     0.200
     3.555   -16.546     0.200
     3.651   -18.149     0.200
     4.082   -23.520     0.200
     4.227   -23.905     0.200
     4.299   -23.200     0.200
     4.687   -25.681     0.200
     5.408   -31.466     0.200
     6.009   -32.493     0.200
     6.041   -36.820     0.200
     6.110   -37.002     0.200
     6.110   -33.705     0.200
     6.357   -32.974     0.200
     7.082   -48.170     0.200
     8.144   -54.587     0.200
     8.666   -58.234     0.200
     8.836   -59.421     0.200
     9.792   -68.429     0.200
     1.741    -0.751     0.200
     2.608    -7.543     0.200
     2.901   -10.990     0.200
     2.942    -9.624     0.200
     3.481   -13.735     0.200
     3.491   -12.976     0.200
     3.577   -16.655     0.200
     3.952   -19.092     0.200
     4.004   -19.770     0.200
     4.159   -17.995     0.200
     4.237   -20.273     0.200
     4.618   -22.243     0.200
     5.169   -27.610     0.200
     5.697   -30.946     0.200
     5.973   -32.989     0.200
     5.973   -31.589     0.200
     6.131   -33.702     0.200
     6.631   -38.052     0.200
     6.802   -37.976     0.200
     7.182   -44.640     0.200
     8.132   -50.631     0.200
     8.431   -54.008     0.200
     8.635   -56.476     0.200
     8.811   -57.579     0.200
     9.782   -67.535     0.200
     9.898   -68.109     0.200
     2.602    -9.322     0.200
     2.855   -10.103     0.200
     2.878   -11.900     0.200
     2.940   -11.509     0.200
     3.324   -13.115     0.200
     3.483   -15.342     0.200
     3.503   -15.389     0.200
     4.131   -22.374     0.200
     4.118   -17.150     0.200
     4.293   -22.713     0.200
     4.372   -25.309     0.200
     4.752   -24.656     0.200
     4.813   -25.706     0.200
     4.868   -26.856     0.200
     5.455   -28.248     0.200
     5.482   -30.508     0.200
     6.091   -34.318     0.200
     6.106   -35.802     0.200
     6.174   -36.137     0.200
     6.194   -35.788     0.200
     6.338   -35.437     0.200
     6.446   -37.048     0.200
     6.719   -42.427     0.200
     6.711   -41.964     0.200
     6.757   -40.710     0.200
     6.944   -44.954     0.200
     7.082   -44.430     0.200
     7.120   -44.234     0.200
     7.150   -45.881     0.200
     7.150   -46.482     0.200
     7.181   -46.560     0.200
     7.280   -48.190     0.200
     7.300   -45.641     0.200
     7.318   -44.718     0.200
     7.446   -48.163     0.200
     7.560   -47.256     0.200
     7.589   -47.992     0.200
     7.604   -49.890     0.200
     8.032   -50.988     0.200
     8.216   -55.064     0.200
     8.237   -55.250     0.200
     8.259   -55.637     0.200
     8.432   -56.114     0.200
     8.548   -57.593     0.200
     8.672   -55.621     0.200
     8.756   -60.005     0.200
     9.229   -62.792     0.200
     9.229   -62.292     0.200
     9.885   -71.194     0.200
     9.971   -70.420     0.200
     9.999   -70.382     0.200
     1.192     0.013     0.200
     1.233     0.597     0.200
     1.287    -0.521     0.200
     4.607   -27.353     0.200
     4.703   -27.705     0.200
     5.062   -31.075     0.200
     5.734   -35.388     0.200
     5.816   -35.665     0.200
     6.416   -40.698     0.200
     6.447   -38.283     0.200
     6.555   -40.185     0.200
     6.816   -41.939     0.200
     7.124   -42.037     0.200
     7.466   -49.767     0.200
     7.762   -52.570     0.200
     8.918   -61.417     0.200
     9.298   -66.061     0.200
    10.249   -70.299     0.200
     2.781   -10.225     0.200
     2.866   -13.147     0.200
     2.958   -11.894     0.200
     2.988   -12.101     0.200
     3.239   -13.943     0.200
     3.260   -14.005     0.200
     3.327   -14.600     0.200
     3.700   -17.224     0.200
     3.759   -16.006     0.200
     3.869   -18.324     0.200
     3.888   -18.832     0.200
     3.888   -18.832     0.200
     4.055   -19.879     0.200
     4.151   -19.544     0.200
     4.148   -22.126     0.200
     4.262   -22.246     0.200
     4.280   -21.117     0.200
     4.345   -22.108     0.200
     4.354   -23.413     0.200
     4.394   -23.941     0.200
     4.471   -24.200     0.200
     4.469   -20.801     0.200
     4.818   -26.477     0.200
     6.035   -33.145     0.200
     6.120   -33.564     0.200
     6.169   -35.698     0.200
     6.640   -36.035     0.200
     6.664   -40.107     0.200
     7.028   -44.622     0.200
     7.048   -43.486     0.200
     7.492   -49.555     0.200
     8.375   -57.347     0.200
     8.706   -60.534     0.200
     8.752   -59.386     0.200
     9.356   -64.430     0.200
     9.653   -65.852     0.200
     2.853   -10.433     0.200
     2.988    -9.392     0.200
     3.237   -10.496     0.200
     3.261   -11.674     0.200
     3.326   -11.892     0.200
     3.455   -15.400     0.200
     3.697   -14.152     0.200
     3.803   -17.508     0.200
     3.868   -15.900     0.200
     3.887   -15.658     0.200
     3.887   -15.658     0.200
     3.911   -15.359     0.200
     3.959   -20.489     0.200
     4.043   -20.409     0.200
     4.192   -21.356     0.200
     4.342   -21.872     0.200
     4.463   -20.045     0.200
     4.806   -22.597     0.200
     5.254   -27.956     0.200
     5.482   -27.741     0.200
     5.559   -28.186     0.200
     6.022   -31.164     0.200
     6.104   -31.977     0.200
     6.108   -32.387     0.200
     6.156   -32.916     0.200
     6.185   -37.435     0.200
     6.251   -33.030     0.200
     6.370   -37.100     0.200
     6.405   -35.993     0.200
     6.628   -35.972     0.200
     6.673   -40.399     0.200
     6.875   -42.486     0.200
     7.186   -42.950     0.200
     7.314   -44.916     0.200
     7.480   -46.672     0.200
     7.630   -47.630     0.200
     7.693   -49.284     0.200
     8.004   -52.084     0.200
     8.093   -50.699     0.200
     8.177   -52.449     0.200
     8.284   -52.179     0.200
     8.364   -54.510     0.200
     8.386   -55.894     0.200
     8.386   -55.894     0.200
     8.441   -51.230     0.200
     8.694   -55.551     0.200
     8.741   -58.150     0.200
     8.902   -60.700     0.200
     9.221   -61.876     0.200
     9.221   -62.676     0.200
     9.347   -60.450     0.200
     9.621   -62.742     0.200
     9.643   -63.357     0.200
     9.689   -62.519     0.200
     9.718   -64.313     0.200
     9.989   -62.609     0.200
    10.033   -59.457     0.200
    10.218   -66.985     0.200
    10.931   -74.569     0.200
    10.970   -76.765     0.200
    11.179   -76.640     0.200
    12.916   -88.804     0.200
    14.359   -94.554     0.200
    18.262  -121.631     0.200
    18.464  -122.593     0.200
    18.464  -121.820     0.200
    18.789  -128.703     0.200
    18.789  -128.094     0.200
    18.789  -127.355     0.200
    20.687  -139.148     0.200
     2.746    -9.267     0.200
     2.854   -11.181     0.200
     2.923   -10.299     0.200
     2.954   -10.844     0.200
     3.204   -12.725     0.200
     3.226   -13.571     0.200
     3.293   -13.738     0.200
     3.666   -15.834     0.200
     3.835   -17.660     0.200
     3.854   -18.333     0.200
     3.854   -18.333     0.200
     4.046   -17.488     0.200
     4.133   -20.137     0.200
     4.262   -20.702     0.200
     4.329   -22.068     0.200
     4.344   -22.426     0.200
     4.387   -22.563     0.200
     4.456   -23.697     0.200
     4.497   -21.040     0.200
     4.808   -25.082     0.200
     4.863   -24.133     0.200
     5.489   -29.583     0.200
     5.887   -34.914     0.200
     6.035   -32.698     0.200
     6.118   -34.012     0.200
     6.159   -34.723     0.200
     6.196   -38.506     0.200
     6.266   -35.510     0.200
     6.552   -42.772     0.200
     6.646   -37.466     0.200
     6.961   -42.048     0.200
     7.047   -44.163     0.200
     7.068   -44.825     0.200
     7.190   -45.297     0.200
     7.484   -47.729     0.200
     8.387   -56.348     0.200
     8.764   -59.599     0.200
     9.375   -61.565     0.200
     9.670   -66.036     0.200
     2.810    -8.963     0.200
     2.868   -10.971     0.200
     2.986   -10.166     0.200
     3.018   -10.755     0.200
     3.267   -12.205     0.200
     3.289   -13.299     0.200
     3.356   -13.320     0.200
     3.727   -15.450     0.200
     3.789   -14.626     0.200
     3.898   -17.320     0.200
     3.917   -17.163     0.200
     3.917   -17.163     0.200
     4.055   -20.180     0.200
     4.153   -20.744     0.200
     4.287   -23.227     0.200
     4.355   -21.772     0.200
     4.392   -22.938     0.200
     4.440   -20.367     0.200
     4.476   -22.723     0.200
     4.819   -26.676     0.200
     5.576   -33.170     0.200
     6.026   -32.738     0.200
     6.169   -34.377     0.200
     7.197   -46.072     0.200
     7.491   -48.289     0.200
     8.298   -55.676     0.200
     8.358   -55.062     0.200
     8.703   -54.705     0.200
     8.734   -58.593     0.200
     9.631   -62.735     0.200
     9.701   -60.430     0.200
     2.748    -9.293     0.200
     2.841    -9.402     0.200
     2.923    -9.778     0.200
     2.957   -11.691     0.200
     3.205   -12.064     0.200
     3.230   -13.926     0.200
     3.295   -14.202     0.200
     3.665   -15.114     0.200
     3.837   -17.847     0.200
     3.855   -17.380     0.200
     3.855   -17.380     0.200
     4.033   -17.890     0.200
     4.121   -18.166     0.200
     4.236   -19.328     0.200
     4.317   -20.684     0.200
     4.331   -21.214     0.200
     4.374   -21.507     0.200
     4.444   -21.525     0.200
     4.489   -20.152     0.200
     4.776   -24.628     0.200
     4.795   -24.238     0.200
     4.867   -22.719     0.200
     5.476   -29.723     0.200
     5.545   -31.409     0.200
     6.022   -31.330     0.200
     6.104   -32.242     0.200
     6.109   -32.100     0.200
     6.146   -33.478     0.200
     6.252   -33.744     0.200
     6.633   -35.802     0.200
     6.655   -41.194     0.200
     7.177   -44.047     0.200
     7.471   -46.478     0.200
     8.018   -50.720     0.200
     8.093   -52.490     0.200
     8.273   -54.299     0.200
     8.374   -54.301     0.200
     8.421   -51.801     0.200
     8.687   -55.617     0.200
     8.685   -55.242     0.200
     8.751   -58.253     0.200
     9.216   -61.492     0.200
     9.216   -62.192     0.200
     9.659   -63.618     0.200
     9.681   -62.930     0.200
     1.192     1.831     0.200
     2.855   -12.468     0.200
     3.778   -17.024     0.200
     4.043   -18.435     0.200
     4.139   -21.577     0.200
     4.337   -22.845     0.200
     4.381   -24.122     0.200
     4.806   -25.819     0.200
     7.027   -44.503     0.200
     7.480   -50.359     0.200
     8.355   -55.906     0.200
     8.731   -60.241     0.200
     9.632   -65.678     0.200
     1.147     2.042     0.200
     1.054     2.488     0.200
     1.189     2.729     0.200
     2.857   -10.637     0.200
     2.793    -9.642     0.200
     2.968    -9.893     0.200
     3.001   -11.738     0.200
     3.250   -12.276     0.200
     3.274   -14.201     0.200
     3.340   -13.879     0.200
     3.710   -15.232     0.200
     3.882   -17.801     0.200
     3.900   -17.662     0.200
     3.900   -17.662     0.200
     4.046   -19.352     0.200
     4.141   -20.555     0.200
     4.167   -20.383     0.200
     4.274   -22.498     0.200
     4.383   -22.863     0.200
     4.464   -23.075     0.200
     4.809   -26.646     0.200
     5.564   -30.982     0.200
     6.159   -34.458     0.200
     6.625   -36.509     0.200
     7.482   -49.690     0.200
     8.359   -55.083     0.200
     8.736   -58.418     0.200
     9.636   -63.958     0.200
     9.712   -64.779     0.200
     1.174     1.393     0.200
     1.298     2.873     0.200
     2.761    -9.560     0.200
     2.849   -10.106     0.200
     2.937    -9.747     0.200
     2.970   -11.213     0.200
     3.218   -12.621     0.200
     3.243   -14.228     0.200
     3.308   -14.087     0.200
     3.437   -16.127     0.200
     3.679   -15.234     0.200
     3.744   -16.560     0.200
     3.850   -17.915     0.200
     3.868   -18.356     0.200
     3.868   -18.356     0.200
     4.040   -18.652     0.200
     4.130   -18.543     0.200
     4.136   -17.871     0.200
     4.244   -18.907     0.200
     4.261   -21.730     0.200
     4.326   -21.346     0.200
     4.338   -21.098     0.200
     4.380   -22.015     0.200
     4.453   -22.264     0.200
     4.802   -26.391     0.200
     5.481   -29.417     0.200
     5.553   -31.807     0.200
     6.111   -34.400     0.200
     6.153   -34.722     0.200
     6.633   -36.755     0.200
     7.030   -42.530     0.200
     7.051   -42.794     0.200
     7.477   -47.204     0.200
     8.014   -50.933     0.200
     8.280   -54.567     0.200
     8.372   -56.483     0.200
     8.749   -58.329     0.200
     9.654   -63.318     0.200
     9.726   -64.601     0.200
     2.771    -8.020     0.200
     2.870   -10.061     0.200
     2.949    -9.107     0.200
     2.978   -10.016     0.200
     3.229   -11.170     0.200
     3.248   -12.319     0.200
     3.316   -12.263     0.200
     3.692   -14.751     0.200
     3.747   -15.067     0.200
     3.859   -16.398     0.200
     3.878   -16.607     0.200
     3.878   -16.607     0.200
     4.151   -18.561     0.200
     4.282   -18.738     0.200
     4.359   -19.285     0.200
     4.401   -21.391     0.200
     4.481   -20.541     0.200
     4.823   -23.685     0.200
     6.174   -35.712     0.200
     6.424   -36.822     0.200
     2.880   -11.576     0.200
     4.071   -18.703     0.200
     4.160   -21.753     0.200
     4.274   -20.044     0.200
     4.356   -23.007     0.200
     4.370   -23.590     0.200
     4.483   -24.702     0.200
     4.496   -22.683     0.200
     4.833   -25.888     0.200
     6.185   -35.422     0.200
     8.402   -57.414     0.200
     8.779   -59.157     0.200
     1.045     3.093     0.200
     2.872   -11.495     0.200
     2.808    -9.579     0.200
     2.984   -10.617     0.200
     3.015   -11.449     0.200
     3.265   -12.925     0.200
     3.286   -13.622     0.200
     3.354   -13.706     0.200
     3.481   -14.250     0.200
     3.726   -15.741     0.200
     3.824   -19.985     0.200
     3.772   -16.261     0.200
     3.936   -17.931     0.200
     3.896   -17.521     0.200
     3.915   -17.556     0.200
     3.915   -17.556     0.200
     4.060   -20.713     0.200
     4.157   -22.096     0.200
     4.304   -17.840     0.200
     4.360   -24.795     0.200
     4.445   -22.595     0.200
     4.502   -21.026     0.200
     4.688   -26.997     0.200
     4.824   -24.909     0.200
     4.961   -28.262     0.200
     4.922   -23.737     0.200
     4.994   -29.271     0.200
     5.148   -25.542     0.200
     5.282   -29.082     0.200
     5.339   -30.900     0.200
     5.496   -31.233     0.200
     5.580   -29.787     0.200
     5.724   -34.474     0.200
     5.799   -34.229     0.200
     6.031   -32.397     0.200
     5.994   -37.168     0.200
     6.114   -34.006     0.200
     6.116   -34.776     0.200
     6.064   -35.780     0.200
     6.174   -34.311     0.200
     6.259   -33.016     0.200
     6.206   -39.809     0.200
     6.339   -37.792     0.200
     6.295   -37.399     0.200
     6.388   -38.102     0.200
     6.458   -38.121     0.200
     6.633   -37.751     0.200
     6.697   -42.995     0.200
     6.790   -36.430     0.200
     6.757   -40.986     0.200
     6.881   -42.758     0.200
     6.899   -45.690     0.200
     7.010   -44.229     0.200
     7.031   -44.194     0.200
     7.029   -44.385     0.200
     7.202   -45.011     0.200
     7.325   -45.633     0.200
     7.496   -48.432     0.200
     7.715   -51.539     0.200
     7.801   -51.985     0.200
     7.973   -54.598     0.200
     7.999   -52.957     0.200
     8.183   -54.461     0.200
     8.303   -55.708     0.200
     8.364   -56.331     0.200
     8.398   -55.905     0.200
     8.465   -51.941     0.200
     8.708   -56.752     0.200
     8.709   -50.686     0.200
     8.740   -59.562     0.200
     8.940   -60.225     0.200
     8.940   -58.588     0.200
     9.235   -63.338     0.200
     9.235   -63.439     0.200
     9.339   -63.038     0.200
     9.347   -60.703     0.200
     9.592   -65.471     0.200
     9.628   -64.110     0.200
     9.637   -65.500     0.200
     9.706   -62.870     0.200
     9.716   -68.903     0.200
     9.913   -67.246     0.200
     9.995   -65.766     0.200
     9.964   -68.502     0.200
    10.345   -67.663     0.200
    10.735   -71.717     0.200
    10.932   -77.058     0.200
    10.975   -76.518     0.200
    10.955   -70.651     0.200
    10.971   -74.963     0.200
    11.180   -79.102     0.200
    11.310   -69.226     0.200
    11.465   -71.468     0.200
    18.805  -126.345     0.200
    20.762  -144.858     0.200
     1.648    -0.950     0.200
     2.871   -11.394     0.200
     2.837    -9.855     0.200
     3.011   -10.727     0.200
     3.045   -11.851     0.200
     3.294   -13.352     0.200
     3.317   -13.891     0.200
     3.383   -14.437     0.200
     3.753   -16.319     0.200
     3.816   -16.409     0.200
     3.925   -18.224     0.200
     3.944   -18.177     0.200
     3.944   -18.177     0.200
     4.013   -20.397     0.200
     4.056   -20.266     0.200
     4.159   -19.886     0.200
     4.295   -24.022     0.200
     4.357   -22.109     0.200
     4.357   -24.279     0.200
     4.391   -24.444     0.200
     4.482   -24.270     0.200
     4.821   -26.179     0.200
     4.716   -24.380     0.200
     5.025   -28.496     0.200
     5.489   -29.863     0.200
     5.581   -31.479     0.200
     5.754   -34.703     0.200
     6.019   -30.955     0.200
     6.101   -32.863     0.200
     6.102   -32.797     0.200
     6.024   -37.344     0.200
     6.171   -34.963     0.200
     6.245   -35.133     0.200
     6.324   -38.492     0.200
     7.491   -49.232     0.200
     8.343   -56.325     0.200
     8.719   -59.145     0.200
     9.226   -63.432     0.200
     9.313   -62.776     0.200
     9.612   -66.969     0.200
     9.695   -66.672     0.200
     9.887   -66.963     0.200
     1.059     1.162     0.200
     1.647    -1.995     0.200
     2.871   -11.459     0.200
     2.831   -12.214     0.200
     3.006   -12.731     0.200
     3.039   -13.989     0.200
     3.288   -15.390     0.200
     3.311   -16.362     0.200
     3.378   -16.263     0.200
     3.748   -18.345     0.200
     3.920   -20.472     0.200
     3.938   -20.538     0.200
     3.938   -20.538     0.200
     4.057   -20.704     0.200
     4.158   -20.407     0.200
     4.271   -22.437     0.200
     4.294   -22.498     0.200
     4.357   -23.003     0.200
     4.356   -22.696     0.200
     4.391   -24.579     0.200
     4.481   -24.663     0.200
     4.420   -20.475     0.200
     7.492   -50.060     0.200
     8.346   -55.845     0.200
     8.722   -59.370     0.200
     9.617   -65.415     0.200
     1.071     2.668     0.200
     1.199     2.657     0.200
     1.659    -2.074     0.200
     2.859   -11.413     0.200
     4.045   -20.069     0.200
     4.147   -21.229     0.200
     4.260   -21.473     0.200
     8.334   -54.945     0.200
     8.710   -58.670     0.200
     1.217     2.480     0.200
     2.836    -9.435     0.200
     3.802   -12.977     0.200
     4.022   -18.245     0.200
     4.123   -19.072     0.200
     4.235   -17.736     0.200
     4.258   -21.950     0.200
     4.358   -20.821     0.200
     4.445   -22.446     0.200
     4.786   -24.994     0.200
     6.136   -33.289     0.200
     7.458   -46.988     0.200
     8.266   -52.903     0.200
     8.325   -54.785     0.200
     8.702   -58.919     0.200
     9.602   -63.742     0.200
     1.203     2.809     0.200
     1.663    -1.529     0.200
     2.824    -9.076     0.200
     2.853   -10.133     0.200
     2.996    -9.910     0.200
     3.033   -11.518     0.200
     3.279   -12.371     0.200
     3.307   -14.245     0.200
     3.371   -13.957     0.200
     3.737   -15.004     0.200
     3.808   -14.333     0.200
     3.913   -17.959     0.200
     3.930   -17.205     0.200
     3.930   -17.205     0.200
     4.039   -18.956     0.200
     4.140   -19.845     0.200
     4.253   -21.204     0.200
     4.276   -23.675     0.200
     4.338   -20.122     0.200
     4.374   -22.480     0.200
     4.463   -22.430     0.200
     4.803   -26.181     0.200
     5.473   -28.509     0.200
     6.153   -33.971     0.200
     7.474   -47.555     0.200
     8.283   -53.391     0.200
     8.334   -57.216     0.200
     8.710   -59.445     0.200
     9.607   -64.874     0.200
     9.686   -67.287     0.200
     1.118     4.185     0.200
     1.670    -1.201     0.200
     2.842    -9.707     0.200
     3.024    -9.495     0.200
     3.361   -11.696     0.200
     3.647   -17.469     0.200
     3.726   -13.316     0.200
     3.795   -16.285     0.200
     3.789   -16.579     0.200
     3.911   -15.312     0.200
     3.903   -15.072     0.200
     3.920   -15.171     0.200
     3.920   -15.171     0.200
     3.984   -19.757     0.200
     4.029   -18.041     0.200
     4.129   -20.271     0.200
     4.242   -18.006     0.200
     4.327   -20.243     0.200
     4.328   -21.203     0.200
     4.365   -21.617     0.200
     4.521   -21.873     0.200
     4.715   -24.902     0.200
     4.793   -24.888     0.200
     4.935   -23.902     0.200
     5.014   -29.022     0.200
     5.289   -29.383     0.200
     5.464   -29.656     0.200
     5.742   -34.011     0.200
     5.998   -31.185     0.200
     6.016   -36.987     0.200
     6.080   -32.992     0.200
     6.082   -33.657     0.200
     6.081   -37.115     0.200
     6.143   -33.581     0.200
     6.225   -34.100     0.200
     6.598   -35.234     0.200
     6.781   -43.304     0.200
     7.170   -44.162     0.200
     7.464   -46.479     0.200
     7.688   -48.423     0.200
     7.967   -49.618     0.200
     8.272   -54.394     0.200
     8.331   -54.840     0.200
     8.676   -56.979     0.200
     8.707   -59.171     0.200
     8.920   -57.250     0.200
     9.202   -61.152     0.200
     9.276   -57.352     0.200
     9.308   -60.435     0.200
     9.336   -63.788     0.200
     9.559   -65.880     0.200
     9.594   -63.892     0.200
     9.606   -64.272     0.200
     9.674   -63.317     0.200
     9.683   -66.022     0.200
     9.883   -65.163     0.200
     9.946   -64.256     0.200
    10.179   -67.540     0.200
    10.328   -67.325     0.200
    10.939   -70.005     0.200
    10.950   -72.813     0.200
     2.829    -8.850     0.200
     4.018   -17.538     0.200
     4.112   -17.661     0.200
     4.226   -19.242     0.200
     4.309   -19.892     0.200
     4.435   -21.635     0.200
     4.781   -23.960     0.200
     6.131   -31.879     0.200
     7.455   -45.426     0.200
     8.342   -54.246     0.200
     8.719   -56.593     0.200
     9.328   -59.295     0.200
     9.623   -62.372     0.200
     2.870   -11.280     0.200
     4.056   -20.180     0.200
     4.156   -20.645     0.200
     4.269   -22.954     0.200
     4.354   -24.129     0.200
     4.391   -22.311     0.200
     4.479   -24.410     0.200
     4.820   -26.503     0.200
     6.170   -34.600     0.200
     7.983   -51.269     0.200
     8.350   -56.397     0.200
     8.726   -59.323     0.200
     9.322   -60.622     0.200
     9.621   -64.405     0.200
     1.217     2.585     0.200
     2.838   -10.170     0.200
     4.024   -18.350     0.200
     4.125   -19.544     0.200
     4.238   -20.293     0.200
     4.323   -19.830     0.200
     4.448   -22.808     0.200
     4.415   -18.844     0.200
     4.788   -25.269     0.200
     5.458   -28.110     0.200
     6.138   -33.857     0.200
     7.459   -47.846     0.200
     8.323   -56.619     0.200
     8.699   -56.755     0.200
     9.300   -59.105     0.200
     9.598   -63.643     0.200
     0.851     2.800     0.200
     1.100     1.681     0.200
     2.866   -12.186     0.200
     2.845   -10.605     0.200
     3.054   -13.003     0.200
     3.302   -13.145     0.200
     3.327   -15.905     0.200
     3.392   -15.226     0.200
     3.760   -15.873     0.200
     3.814   -18.009     0.200
     3.827   -17.521     0.200
     3.934   -19.075     0.200
     3.952   -18.786     0.200
     3.952   -18.786     0.200
     4.050   -19.354     0.200
     4.155   -21.098     0.200
     4.267   -22.544     0.200
     4.292   -26.373     0.200
     4.350   -23.093     0.200
     4.353   -22.574     0.200
     4.384   -22.780     0.200
     4.403   -22.474     0.200
     4.477   -25.171     0.200
     4.815   -24.847     0.200
     4.912   -30.189     0.200
     4.963   -24.149     0.200
     5.320   -31.262     0.200
     5.482   -30.484     0.200
     5.576   -32.593     0.200
     6.010   -32.126     0.200
     6.092   -34.233     0.200
     6.093   -34.151     0.200
     6.164   -34.920     0.200
     6.236   -35.792     0.200
     6.972   -45.541     0.200
     6.993   -44.807     0.200
     7.191   -46.769     0.200
     7.485   -47.173     0.200
     7.963   -52.429     0.200
     8.026   -54.729     0.200
     8.062   -53.594     0.200
     8.295   -55.567     0.200
     8.331   -57.624     0.200
     8.379   -58.032     0.200
     8.476   -57.094     0.200
     8.694   -56.315     0.200
     8.708   -60.849     0.200
     8.927   -51.479     0.200
     9.218   -64.138     0.200
     9.218   -64.842     0.200
     9.301   -64.156     0.200
     9.600   -66.552     0.200
     9.683   -67.771     0.200
     9.874   -67.341     0.200
    10.169   -68.970     0.200
     4.064   -20.429     0.200
     4.275   -19.725     0.200
     4.443   -22.707     0.200
     4.828   -25.407     0.200
     6.034   -31.757     0.200
     6.119   -35.831     0.200
     6.178   -35.209     0.200
     7.032   -46.965     0.200
     7.500   -49.821     0.200
     8.365   -57.644     0.200
     8.741   -60.972     0.200
     9.638   -67.582     0.200
     2.797    -7.051     0.200
     2.970    -7.829     0.200
     3.007    -8.539     0.200
     3.253   -10.048     0.200
     3.281   -11.522     0.200
     3.344   -11.285     0.200
     3.711   -13.207     0.200
     3.771   -15.024     0.200
     3.783   -13.901     0.200
     3.886   -15.085     0.200
     3.903   -15.220     0.200
     3.903   -15.220     0.200
     3.971   -14.671     0.200
     4.129   -18.295     0.200
     4.331   -20.174     0.200
     4.326   -20.145     0.200
     4.369   -21.186     0.200
     4.441   -23.153     0.200
     4.795   -23.396     0.200
     5.272   -27.454     0.200
     5.552   -32.266     0.200
     6.091   -32.870     0.200
     6.146   -32.902     0.200
     6.996   -44.951     0.200
     7.017   -45.415     0.200
     7.468   -46.327     0.200
     8.275   -54.291     0.200
     8.344   -55.777     0.200
     8.681   -54.463     0.200
     8.720   -58.415     0.200
     9.324   -61.858     0.200
     9.621   -65.376     0.200
     1.196     2.783     0.200
     2.836    -8.861     0.200
     2.863    -9.866     0.200
     3.009    -9.334     0.200
     3.044   -10.978     0.200
     3.292   -12.035     0.200
     3.317   -13.465     0.200
     3.382   -13.013     0.200
     3.750   -14.713     0.200
     3.817   -16.066     0.200
     3.925   -17.348     0.200
     3.942   -17.441     0.200
     3.942   -17.441     0.200
     4.010   -17.850     0.200
     4.048   -18.623     0.200
     4.263   -18.518     0.200
     4.348   -22.326     0.200
     4.382   -22.080     0.200
     4.473   -22.179     0.200
     4.813   -24.517     0.200
     5.573   -29.125     0.200
     6.162   -33.500     0.200
     7.483   -47.470     0.200
     8.293   -50.834     0.200
     8.336   -56.795     0.200
     8.712   -60.619     0.200
     9.606   -65.371     0.200
     9.687   -66.048     0.200
     1.049     2.491     0.200
     1.178     2.466     0.200
     1.426     0.312     0.200
     1.638    -0.377     0.200
     2.876   -10.945     0.200
     4.063   -19.421     0.200
     7.021   -43.542     0.200
     8.357   -56.386     0.200
     8.733   -59.510     0.200
     9.328   -59.988     0.200
     9.627   -63.774     0.200
     1.078     3.532     0.200
     1.206     2.503     0.200
     1.666    -0.365     0.200
     2.853   -10.289     0.200
     4.038   -19.226     0.200
     4.141   -19.514     0.200
     4.254   -21.255     0.200
     4.338   -21.842     0.200
     4.464   -22.557     0.200
     4.803   -27.660     0.200
     6.152   -33.743     0.200
     7.473   -48.112     0.200
     8.283   -55.278     0.200
     8.327   -54.695     0.200
     8.683   -55.971     0.200
     8.704   -58.222     0.200
     9.599   -63.110     0.200
     9.679   -63.753     0.200
     2.872   -10.156     0.200
     2.784    -8.555     0.200
     2.962    -8.774     0.200
     2.991   -10.713     0.200
     3.242   -11.588     0.200
     3.262   -13.351     0.200
     3.330   -12.689     0.200
     3.704   -14.115     0.200
     3.872   -16.745     0.200
     3.892   -16.654     0.200
     3.892   -16.654     0.200
     4.061   -19.449     0.200
     4.154   -18.973     0.200
     4.268   -20.849     0.200
     4.286   -21.571     0.200
     4.351   -21.028     0.200
     4.360   -20.878     0.200
     4.400   -22.280     0.200
     4.477   -22.848     0.200
     4.468   -22.646     0.200
     4.824   -23.817     0.200
     6.175   -34.543     0.200
     6.691   -41.597     0.200
     7.030   -42.743     0.200
     7.051   -43.109     0.200
     7.498   -47.395     0.200
     8.303   -55.099     0.200
     8.379   -55.417     0.200
     8.712   -56.869     0.200
     8.756   -59.050     0.200
     9.239   -60.888     0.200
     9.358   -60.254     0.200
     9.656   -64.586     0.200
     9.732   -65.310     0.200
     2.773    -9.529     0.200
     2.868   -10.632     0.200
     2.951   -10.040     0.200
     2.980   -11.899     0.200
     3.232   -12.632     0.200
     3.251   -14.472     0.200
     3.319   -14.132     0.200
     3.694   -15.438     0.200
     3.861   -18.063     0.200
     3.881   -17.917     0.200
     3.881   -17.917     0.200
     4.150   -20.441     0.200
     4.143   -18.514     0.200
     4.281   -22.396     0.200
     4.357   -21.613     0.200
     4.398   -23.111     0.200
     4.477   -23.819     0.200
     4.821   -26.213     0.200
     4.949   -28.807     0.200
     6.172   -35.141     0.200
     7.036   -43.632     0.200
     7.057   -43.694     0.200
     7.496   -48.509     0.200
     8.300   -55.089     0.200
     8.383   -55.023     0.200
     8.760   -58.964     0.200
     9.662   -63.458     0.200
     2.855    -9.190     0.200
     2.832    -7.761     0.200
     3.004    -8.123     0.200
     3.041   -10.124     0.200
     3.288   -10.687     0.200
     3.315   -13.418     0.200
     3.379   -12.993     0.200
     3.745   -13.435     0.200
     3.803   -15.324     0.200
     3.816   -16.219     0.200
     3.921   -16.655     0.200
     3.938   -15.981     0.200
     3.938   -15.981     0.200
     4.004   -19.600     0.200
     4.026   -13.880     0.200
     4.208   -18.441     0.200
     4.341   -21.855     0.200
     4.375   -21.447     0.200
     4.411   -22.988     0.200
     4.695   -24.484     0.200
     4.805   -23.375     0.200
     4.951   -21.011     0.200
     5.027   -25.670     0.200
     5.307   -27.872     0.200
     5.565   -27.777     0.200
     6.086   -30.597     0.200
     6.088   -31.038     0.200
     6.028   -33.276     0.200
     6.155   -32.060     0.200
     6.231   -32.377     0.200
     6.330   -33.907     0.200
     6.602   -35.840     0.200
     6.889   -44.040     0.200
     6.975   -43.979     0.200
     6.996   -43.243     0.200
     7.475   -46.532     0.200
     7.703   -45.575     0.200
     7.964   -49.824     0.200
     8.060   -51.050     0.200
     8.285   -54.991     0.200
     8.331   -55.344     0.200
     8.372   -56.362     0.200
     8.372   -56.362     0.200
     8.686   -56.296     0.200
     8.707   -58.969     0.200
     9.211   -61.743     0.200
     9.211   -62.243     0.200
     9.304   -61.489     0.200
     9.599   -64.456     0.200
     9.602   -64.559     0.200
     9.683   -65.703     0.200
     9.878   -65.193     0.200
    10.173   -69.044     0.200
    10.900   -75.598     0.200
     2.862    -9.615     0.200
     2.821   -10.278     0.200
     2.995   -10.149     0.200
     3.029   -12.768     0.200
     3.277   -13.041     0.200
     3.302   -15.631     0.200
     3.367   -15.045     0.200
     3.736   -15.598     0.200
     3.910   -18.642     0.200
     3.928   -18.632     0.200
     3.928   -18.632     0.200
     3.997   -17.381     0.200
     4.194   -17.597     0.200
     4.348   -22.065     0.200
     4.384   -22.198     0.200
     4.520   -22.534     0.200
     4.812   -24.081     0.200
     4.938   -24.281     0.200
     5.012   -26.753     0.200
     5.295   -28.457     0.200
     5.571   -28.028     0.200
     6.097   -31.029     0.200
     6.099   -33.683     0.200
     6.162   -35.075     0.200
     6.242   -33.323     0.200
     7.484   -48.368     0.200
     7.979   -51.965     0.200
     8.072   -51.138     0.200
     8.344   -54.360     0.200
     8.695   -55.657     0.200
     8.721   -59.189     0.200
     9.220   -62.823     0.200
     9.220   -63.023     0.200
     9.617   -63.805     0.200
     9.693   -59.003     0.200
     1.194     3.054     0.200
     1.653    -0.734     0.200
     2.803    -8.410     0.200
     2.856   -10.220     0.200
     2.977   -10.483     0.200
     3.012    -9.895     0.200
     3.260   -12.343     0.200
     3.285   -11.382     0.200
     3.350   -12.572     0.200
     3.719   -16.145     0.200
     3.786   -16.905     0.200
     3.892   -16.425     0.200
     3.910   -17.196     0.200
     3.910   -17.196     0.200
     4.380   -22.946     0.200
     4.807   -26.572     0.200
     4.922   -27.805     0.200
     6.100   -31.780     0.200
     6.157   -35.177     0.200
     8.351   -55.212     0.200
     8.727   -58.743     0.200
     9.626   -63.848     0.200
     1.184     3.239     0.200
     2.719    -8.962     0.200
     2.845    -9.247     0.200
     2.896   -10.315     0.200
     2.927   -11.156     0.200
     3.177   -12.281     0.200
     3.200   -12.891     0.200
     3.266   -13.214     0.200
     3.639   -15.759     0.200
     3.808   -17.404     0.200
     3.827   -17.729     0.200
     3.827   -17.729     0.200
     3.886   -16.831     0.200
     4.093   -19.227     0.200
     4.249   -21.046     0.200
     4.336   -21.820     0.200
     4.382   -22.178     0.200
     4.520   -22.243     0.200
     4.799   -25.311     0.200
     5.545   -31.548     0.200
     5.946   -34.063     0.200
     6.118   -35.117     0.200
     6.124   -31.814     0.200
     6.151   -33.360     0.200
     6.268   -31.154     0.200
     7.062   -45.430     0.200
     7.083   -43.693     0.200
     7.478   -47.506     0.200
     8.277   -54.944     0.200
     8.396   -56.022     0.200
     8.394   -58.060     0.200
     8.394   -58.060     0.200
     8.416   -52.474     0.200
     8.695   -54.312     0.200
     8.684   -51.553     0.200
     8.773   -57.380     0.200
     9.226   -61.426     0.200
     9.390   -62.231     0.200
     9.684   -65.855     0.200
     9.751   -65.981     0.200
     1.265     0.373     0.200
     1.632    -0.862     0.200
     2.828   -11.539     0.200
     2.883   -12.040     0.200
     3.005   -12.632     0.200
     3.035   -13.282     0.200
     3.286   -14.563     0.200
     3.305   -15.412     0.200
     3.374   -15.880     0.200
     3.747   -17.797     0.200
     3.916   -19.436     0.200
     3.936   -19.853     0.200
     3.936   -19.853     0.200
     4.369   -25.499     0.200
     4.405   -24.020     0.200
     6.035   -31.998     0.200
     6.183   -35.008     0.200
     6.262   -37.288     0.200
     6.632   -35.141     0.200
     7.023   -43.119     0.200
     7.505   -49.896     0.200
     8.360   -55.514     0.200
     8.736   -58.737     0.200
     9.630   -65.262     0.200
     2.803    -9.790     0.200
     2.860    -9.772     0.200
     2.978   -10.033     0.200
     3.011   -12.073     0.200
     3.260   -12.844     0.200
     3.284   -14.860     0.200
     3.350   -14.453     0.200
     3.719   -15.490     0.200
     3.892   -18.320     0.200
     3.910   -18.278     0.200
     3.910   -18.278     0.200
     4.279   -22.537     0.200
     4.347   -21.504     0.200
     4.385   -21.894     0.200
     4.811   -27.415     0.200
     5.567   -28.390     0.200
     6.020   -30.542     0.200
     6.102   -30.752     0.200
     6.161   -32.322     0.200
     6.248   -33.470     0.200
     7.484   -48.043     0.200
     8.355   -56.250     0.200
     8.731   -58.883     0.200
     9.630   -65.277     0.200
     1.145     2.236     0.200
     1.938    -4.918     0.200
     2.530    -8.041     0.200
     2.808   -11.028     0.200
     2.879   -11.851     0.200
     2.985   -11.631     0.200
     3.015   -13.151     0.200
     3.266   -13.996     0.200
     3.285   -15.550     0.200
     3.354   -15.410     0.200
     3.728   -17.124     0.200
     3.896   -19.420     0.200
     3.916   -19.392     0.200
     3.916   -19.392     0.200
     4.366   -22.681     0.200
     4.404   -24.172     0.200
     4.830   -23.197     0.200
     6.181   -33.002     0.200
     6.639   -36.628     0.200
     7.036   -44.728     0.200
     8.370   -55.800     0.200
     8.746   -59.331     0.200
     9.643   -64.046     0.200
     9.722   -66.365     0.200
     2.743   -10.172     0.200
     2.881   -11.556     0.200
     2.924   -11.437     0.200
     2.948   -11.985     0.200
     3.203   -13.781     0.200
     3.217   -13.970     0.200
     3.287   -14.337     0.200
     3.668   -17.245     0.200
     3.830   -18.254     0.200
     3.851   -18.542     0.200
     3.851   -18.542     0.200
     4.372   -23.428     0.200
     4.416   -23.128     0.200
     7.512   -49.281     0.200
     8.415   -59.211     0.200
     8.792   -60.456     0.200
     9.769   -67.330     0.200
     2.881   -11.006     0.200
     2.843    -9.500     0.200
     3.019    -9.903     0.200
     3.051   -11.449     0.200
     3.301   -12.513     0.200
     3.322   -14.062     0.200
     3.389   -14.155     0.200
     3.761   -15.435     0.200
     3.932   -17.861     0.200
     3.951   -17.680     0.200
     3.951   -17.680     0.200
     4.022   -17.408     0.200
     4.042   -16.331     0.200
     4.213   -19.526     0.200
     4.366   -22.793     0.200
     4.400   -23.063     0.200
     4.536   -22.485     0.200
     4.630   -22.568     0.200
     4.680   -25.640     0.200
     4.831   -26.616     0.200
     4.958   -24.148     0.200
     5.180   -26.951     0.200
     5.318   -29.851     0.200
     5.498   -31.674     0.200
     5.591   -33.431     0.200
     6.110   -34.359     0.200
     6.180   -34.396     0.200
     6.253   -33.796     0.200
     6.622   -36.801     0.200
     6.713   -42.089     0.200
     6.915   -43.895     0.200
     7.501   -48.857     0.200
     7.729   -47.571     0.200
     7.978   -51.884     0.200
     8.079   -51.595     0.200
     8.311   -56.333     0.200
     8.348   -55.809     0.200
     8.482   -54.664     0.200
     8.710   -56.902     0.200
     8.724   -60.227     0.200
     9.235   -62.739     0.200
     9.235   -63.138     0.200
     9.315   -63.182     0.200
     9.616   -65.296     0.200
     9.621   -67.063     0.200
     9.680   -66.252     0.200
     9.889   -66.957     0.200
    19.617  -130.955     0.200
     2.856    -9.502     0.200
     2.874   -10.683     0.200
     3.030    -9.433     0.200
     3.064   -11.863     0.200
     3.312   -12.575     0.200
     3.336   -15.084     0.200
     3.402   -14.545     0.200
     3.771   -14.876     0.200
     3.945   -18.393     0.200
     3.963   -17.710     0.200
     3.963   -17.710     0.200
     4.391   -22.966     0.200
     4.823   -25.365     0.200
     5.488   -31.561     0.200
     5.586   -33.343     0.200
     6.015   -32.545     0.200
     6.097   -31.350     0.200
     6.240   -32.291     0.200
     6.608   -36.458     0.200
     7.492   -47.679     0.200
     8.333   -55.423     0.200
     8.708   -58.940     0.200
     8.701   -54.995     0.200
     9.599   -64.577     0.200
     1.066     2.921     0.200
     1.190     2.590     0.200
     2.851   -11.260     0.200
     3.025   -11.315     0.200
     3.059   -13.261     0.200
     3.307   -13.978     0.200
     3.331   -16.221     0.200
     3.397   -15.722     0.200
     3.766   -16.550     0.200
     3.828   -18.794     0.200
     3.939   -19.450     0.200
     3.958   -19.378     0.200
     3.958   -19.378     0.200
     4.057   -19.641     0.200
     4.162   -20.683     0.200
     4.300   -23.321     0.200
     4.358   -22.854     0.200
     4.361   -22.453     0.200
     4.391   -24.395     0.200
     5.488   -33.295     0.200
     6.098   -33.126     0.200
     6.172   -34.652     0.200
     6.610   -38.050     0.200
     6.974   -44.593     0.200
     6.995   -44.858     0.200
     7.492   -50.100     0.200
     8.335   -55.738     0.200
     8.711   -60.655     0.200
     9.603   -65.517     0.200
     1.192     2.974     0.200
     1.651    -0.116     0.200
     2.797    -9.397     0.200
     2.855    -9.842     0.200
     2.972   -10.180     0.200
     3.006   -11.189     0.200
     3.254   -12.655     0.200
     3.279   -13.520     0.200
     3.344   -13.525     0.200
     3.713   -15.875     0.200
     3.886   -17.411     0.200
     3.904   -17.894     0.200
     3.904   -17.894     0.200
     4.171   -17.987     0.200
     4.343   -21.922     0.200
     4.381   -22.129     0.200
     4.446   -21.903     0.200
     5.960   -35.084     0.200
     6.100   -33.425     0.200
     6.103   -32.613     0.200
     6.157   -36.841     0.200
     6.929   -38.805     0.200
     7.007   -42.574     0.200
     7.026   -44.677     0.200
     7.480   -47.568     0.200
     8.286   -55.727     0.200
     8.354   -56.189     0.200
     8.731   -60.025     0.200
     2.877   -11.370     0.200
     2.869   -10.801     0.200
     3.050   -11.779     0.200
     3.087   -13.484     0.200
     3.333   -14.522     0.200
     3.360   -16.114     0.200
     3.424   -15.742     0.200
     3.790   -17.212     0.200
     3.966   -19.814     0.200
     3.984   -19.595     0.200
     4.371   -21.500     0.200
     4.381   -22.522     0.200
     5.478   -30.382     0.200
     6.165   -37.056     0.200
     6.591   -35.355     0.200
     6.947   -43.864     0.200
     6.968   -43.428     0.200
     7.190   -45.555     0.200
     7.483   -47.656     0.200
     7.940   -51.817     0.200
     8.312   -55.432     0.200
     8.688   -59.944     0.200
     9.577   -64.612     0.200
     1.067     2.534     0.200
     2.885   -11.943     0.200
     2.875   -11.829     0.200
     3.049   -12.560     0.200
     3.082   -14.121     0.200
     3.332   -14.708     0.200
     3.353   -16.759     0.200
     3.421   -16.437     0.200
     3.791   -17.859     0.200
     3.963   -20.257     0.200
     3.982   -20.165     0.200
     4.399   -24.900     0.200
     4.833   -26.557     0.200
     6.182   -36.616     0.200
     7.501   -49.531     0.200
     2.872   -12.221     0.200
     2.818   -10.947     0.200
     2.994   -11.648     0.200
     3.026   -13.000     0.200
     3.276   -14.170     0.200
     3.298   -15.212     0.200
     3.365   -15.235     0.200
     3.736   -16.953     0.200
     3.783   -18.534     0.200
     3.907   -19.161     0.200
     3.926   -19.344     0.200
     4.189   -19.603     0.200
     4.359   -24.778     0.200
     4.395   -23.528     0.200
     4.433   -22.150     0.200
     4.514   -23.197     0.200
     4.934   -26.007     0.200
     5.156   -29.364     0.200
     5.293   -30.750     0.200
     5.929   -33.958     0.200
     5.961   -38.457     0.200
     6.109   -35.376     0.200
     6.111   -34.230     0.200
     6.169   -39.364     0.200
     6.173   -34.189     0.200
     6.214   -34.807     0.200
     6.520   -45.088     0.200
     6.626   -41.065     0.200
     6.643   -40.980     0.200
     6.657   -38.836     0.200
     6.699   -42.775     0.200
     6.902   -42.919     0.200
     6.931   -41.824     0.200
     7.001   -44.335     0.200
     7.022   -43.804     0.200
     7.201   -46.577     0.200
     7.495   -49.589     0.200
     7.717   -50.365     0.200
     8.303   -57.197     0.200
     8.356   -57.203     0.200
     8.468   -51.832     0.200
     8.732   -61.130     0.200
     8.722   -56.210     0.200
     9.232   -63.759     0.200
     9.232   -64.259     0.200
     9.329   -64.051     0.200
     9.628   -66.119     0.200
     9.708   -65.965     0.200
     9.903   -66.649     0.200
     1.076     2.206     0.200
     4.219   -19.927     0.200
     4.378   -24.259     0.200
     4.401   -21.979     0.200
     4.809   -26.628     0.200
     6.087   -34.144     0.200
     6.159   -35.105     0.200
     6.298   -39.134     0.200
     6.969   -45.384     0.200
     6.990   -45.749     0.200
     7.479   -47.659     0.200
     8.289   -56.051     0.200
     8.327   -56.739     0.200
     8.703   -60.760     0.200
     9.297   -63.194     0.200
     9.597   -66.585     0.200
     1.068     3.282     0.200
     1.194     2.198     0.200
     2.845   -10.724     0.200
     3.019   -11.605     0.200
     3.302   -14.044     0.200
     3.326   -15.077     0.200
     3.392   -15.042     0.200
     3.760   -17.188     0.200
     3.934   -19.038     0.200
     3.952   -19.177     0.200
     4.218   -21.101     0.200
     4.353   -23.186     0.200
     4.386   -24.443     0.200
     4.818   -27.008     0.200
     4.878   -27.911     0.200
     5.484   -31.249     0.200
     5.579   -34.949     0.200
     6.013   -33.094     0.200
     6.096   -33.822     0.200
     6.095   -34.701     0.200
     6.167   -35.486     0.200
     6.239   -33.960     0.200
     6.608   -42.560     0.200
     6.608   -35.667     0.200
     6.975   -44.895     0.200
     6.996   -45.161     0.200
     7.265   -46.605     0.200
     7.487   -49.141     0.200
     7.965   -53.389     0.200
     8.298   -57.230     0.200
     8.334   -57.589     0.200
     8.710   -60.809     0.200
     9.221   -64.009     0.200
     9.303   -63.807     0.200
     9.603   -66.107     0.200
     1.073     0.709     0.200
     2.859    -9.942     0.200
     2.871   -11.424     0.200
     3.032   -10.212     0.200
     3.067   -12.334     0.200
     3.315   -13.056     0.200
     3.340   -15.057     0.200
     3.406   -14.771     0.200
     3.773   -15.660     0.200
     3.948   -18.547     0.200
     3.965   -18.202     0.200
     4.392   -22.861     0.200
     4.355   -22.604     0.200
     4.387   -23.616     0.200
     4.820   -27.829     0.200
     5.000   -28.733     0.200
     5.485   -31.406     0.200
     5.583   -33.823     0.200
     6.010   -33.571     0.200
     6.092   -33.979     0.200
     6.169   -36.097     0.200
     6.236   -33.517     0.200
     6.965   -44.251     0.200
     6.986   -44.516     0.200
     7.488   -47.931     0.200
     7.957   -52.574     0.200
     8.300   -55.958     0.200
     8.328   -56.931     0.200
     8.703   -59.946     0.200
     6.276   -41.360     0.200
     6.322   -39.420     0.200
     7.461   -47.746     0.200
     8.303   -57.225     0.200
     8.541   -60.475     0.200
     8.679   -61.547     0.200
     1.053     2.234     0.200
     1.431    -1.150     0.200
     2.863   -12.075     0.200
     4.388   -23.073     0.200
     4.814   -23.898     0.200
     4.968   -28.765     0.200
     5.487   -27.334     0.200
     5.571   -29.170     0.200
     6.108   -32.702     0.200
     6.165   -32.602     0.200
     6.251   -33.047     0.200
     7.006   -43.369     0.200
     7.027   -43.728     0.200
     7.487   -48.319     0.200
     8.357   -56.314     0.200
     8.593   -58.475     0.200
     8.734   -60.043     0.200
     9.632   -66.421     0.200
     2.870   -11.456     0.200
     4.392   -23.167     0.200
     4.707   -25.199     0.200
     4.984   -28.554     0.200
     4.943   -24.343     0.200
     5.015   -27.308     0.200
     7.013   -44.372     0.200
     7.198   -46.228     0.200
     7.198   -45.946     0.200
     7.492   -47.743     0.200
     8.300   -55.377     0.200
     8.349   -55.808     0.200
     8.390   -57.208     0.200
     8.586   -59.124     0.200
     8.725   -59.333     0.200
     9.228   -64.080     0.200
     9.228   -64.679     0.200
     9.321   -63.117     0.200
     9.620   -65.499     0.200
     1.435    -1.659     0.200
     2.873   -10.913     0.200
     2.835    -9.940     0.200
     3.010   -11.389     0.200
     3.043   -11.282     0.200
     3.292   -13.462     0.200
     3.314   -13.163     0.200
     3.381   -13.995     0.200
     3.751   -17.126     0.200
     3.827   -18.492     0.200
     3.800   -17.824     0.200
     3.923   -17.498     0.200
     3.942   -18.452     0.200
     4.058   -18.939     0.200
     4.012   -17.623     0.200
     4.297   -24.873     0.200
     4.358   -22.529     0.200
     4.393   -23.123     0.200
     4.417   -20.899     0.200
     4.530   -22.684     0.200
     4.713   -24.113     0.200
     4.823   -25.549     0.200
     4.875   -27.826     0.200
     4.860   -26.747     0.200
     4.950   -25.099     0.200
     5.022   -27.385     0.200
     5.170   -29.711     0.200
     5.294   -30.982     0.200
     5.348   -33.562     0.200
     5.491   -30.943     0.200
     5.583   -31.241     0.200
     5.752   -34.278     0.200
     5.921   -35.653     0.200
     5.950   -36.971     0.200
     6.021   -32.852     0.200
     6.105   -34.192     0.200
     6.104   -34.357     0.200
     6.021   -35.268     0.200
     6.172   -34.135     0.200
     6.092   -37.426     0.200
     6.248   -34.130     0.200
     6.316   -36.687     0.200
     6.361   -38.226     0.200
     6.321   -37.253     0.200
     6.486   -38.682     0.200
     6.618   -37.073     0.200
     6.607   -35.607     0.200
     6.660   -39.590     0.200
     6.704   -44.277     0.200
     6.783   -41.227     0.200
     6.906   -44.878     0.200
     6.988   -44.377     0.200
     7.009   -44.343     0.200
     7.199   -46.181     0.200
     7.493   -48.209     0.200
     7.720   -50.529     0.200
     7.978   -53.559     0.200
     8.040   -54.438     0.200
     8.076   -50.073     0.200
     8.303   -56.165     0.200
     8.346   -57.732     0.200
     8.390   -56.831     0.200
     8.390   -56.831     0.200
     8.472   -54.047     0.200
     8.583   -60.163     0.200
     8.703   -57.872     0.200
     8.722   -60.955     0.200
     9.212   -59.385     0.200
     9.229   -62.616     0.200
     9.229   -62.717     0.200
     9.316   -63.688     0.200
     9.615   -66.482     0.200
     9.681   -66.060     0.200
     9.697   -68.280     0.200
     9.718   -67.637     0.200
     9.890   -67.777     0.200
    10.184   -68.810     0.200
    10.806   -71.310     0.200
    10.916   -79.104     0.200
    11.163   -80.730     0.200
    18.397  -126.656     0.200
     1.009     1.650     0.200
     1.059     2.874     0.200
     1.060     1.754     0.200
     1.419     0.172     0.200
     2.753    -9.580     0.200
     2.780    -9.764     0.200
     2.810   -12.799     0.200
     3.152   -12.437     0.200
     3.296   -13.599     0.200
     3.319   -14.497     0.200
     3.704   -18.559     0.200
     4.199   -22.262     0.200
     4.309   -22.956     0.200
     4.764   -29.176     0.200
     5.440   -30.612     0.200
     5.520   -31.619     0.200
     6.118   -35.505     0.200
     6.160   -37.029     0.200
     6.852   -42.150     0.200
     7.464   -45.969     0.200
     7.451   -48.846     0.200
     8.666   -59.662     0.200
     8.863   -60.522     0.200
     9.048   -61.957     0.200
    10.028   -70.825     0.200
     2.865   -10.975     0.200
     2.790   -10.240     0.200
     2.966   -11.482     0.200
     3.049   -11.962     0.200
     3.248   -13.340     0.200
     3.269   -13.215     0.200
     3.335   -13.974     0.200
     3.336   -14.321     0.200
     3.464   -17.381     0.200
     3.709   -16.736     0.200
     3.769   -15.738     0.200
     3.878   -17.424     0.200
     3.897   -19.234     0.200
     3.919   -16.389     0.200
     3.989   -16.157     0.200
     4.353   -22.632     0.200
     4.392   -22.901     0.200
     4.487   -22.404     0.200
     4.817   -29.271     0.200
     4.847   -27.528     0.200
     4.817   -25.768     0.200
     4.963   -28.495     0.200
     4.906   -23.772     0.200
     5.265   -30.172     0.200
     5.492   -31.872     0.200
     5.572   -34.785     0.200
     5.893   -35.782     0.200
     6.113   -35.747     0.200
     6.116   -35.244     0.200
     6.168   -36.785     0.200
     6.224   -34.217     0.200
     6.220   -37.544     0.200
     6.259   -35.884     0.200
     6.306   -36.873     0.200
     6.401   -37.689     0.200
     6.635   -38.083     0.200
     6.686   -42.625     0.200
     6.888   -43.514     0.200
     7.019   -43.877     0.200
     7.040   -45.141     0.200
     7.050   -44.654     0.200
     7.197   -46.104     0.200
     7.197   -45.794     0.200
     7.167   -45.268     0.200
     7.316   -45.697     0.200
     7.491   -48.227     0.200
     7.580   -52.042     0.200
     7.706   -50.865     0.200
     7.879   -51.224     0.200
     8.006   -53.760     0.200
     8.093   -53.528     0.200
     8.259   -53.280     0.200
     8.296   -56.158     0.200
     8.369   -57.753     0.200
     8.454   -54.458     0.200
     8.603   -59.595     0.200
     8.704   -57.685     0.200
     8.745   -59.390     0.200
     9.074   -58.296     0.200
     9.231   -64.898     0.200
     9.231   -63.998     0.200
     9.348   -62.686     0.200
     9.645   -65.419     0.200
     9.722   -67.845     0.200
     0.822     2.525     0.200
     1.177     1.167     0.200
     1.412    -0.685     0.200
     1.949    -7.466     0.200
     2.560   -10.272     0.200
     3.794   -21.779     0.200
     3.794   -19.833     0.200
     4.138   -23.686     0.200
     4.519   -28.264     0.200
     5.227   -32.934     0.200
     5.873   -37.912     0.200
     5.945   -37.400     0.200
     5.969   -37.226     0.200
     6.078   -39.286     0.200
     6.112   -38.476     0.200
     6.539   -40.809     0.200
     6.569   -42.670     0.200
     6.795   -45.421     0.200
     7.113   -46.920     0.200
     7.134   -46.758     0.200
     7.456   -50.893     0.200
     8.056   -57.493     0.200
     8.346   -59.081     0.200
     8.546   -58.239     0.200
     8.727   -62.667     0.200
     9.437   -66.467     0.200
     9.713   -68.620     0.200
     9.707   -70.243     0.200
     9.825   -69.981     0.200
    10.029   -70.749     0.200
    10.343   -73.316     0.200
     3.262   -10.422     0.200
     3.331   -10.795     0.200
     3.707   -13.517     0.200
     3.874   -14.655     0.200
     3.894   -15.029     0.200
     4.367   -21.360     0.200
     4.470   -23.592     0.200
     4.454   -21.860     0.200
     4.735   -25.915     0.200
     4.831   -23.924     0.200
     4.898   -24.252     0.200
     4.971   -27.270     0.200
     5.507   -29.260     0.200
     6.046   -30.553     0.200
     6.129   -32.260     0.200
     6.182   -33.545     0.200
     6.275   -32.304     0.200
     6.651   -36.805     0.200
     7.211   -45.948     0.200
     7.505   -47.998     0.200
     8.022   -51.666     0.200
     8.385   -56.073     0.200
     8.619   -57.217     0.200
     8.761   -57.911     0.200
     1.036     2.748     0.200
     2.811   -11.828     0.200
     4.074   -23.490     0.200
     4.239   -25.559     0.200
     4.423   -24.520     0.200
     4.789   -27.475     0.200
     4.948   -30.548     0.200
     5.266   -32.452     0.200
     5.644   -33.649     0.200
     6.060   -38.563     0.200
     6.180   -39.172     0.200
     6.557   -42.173     0.200
     6.625   -41.631     0.200
     7.047   -46.329     0.200
     7.271   -48.423     0.200
     7.582   -52.080     0.200
     7.602   -51.818     0.200
     7.933   -52.903     0.200
     8.513   -59.285     0.200
     8.775   -60.507     0.200
     8.959   -61.935     0.200
     9.158   -64.148     0.200
     9.903   -71.763     0.200
    10.167   -72.122     0.200
    10.148   -70.501     0.200
    10.289   -74.281     0.200
    10.499   -73.759     0.200
    10.817   -77.327     0.200
     1.635    -0.095     0.200
     2.398    -8.952     0.200
     3.792   -16.147     0.200
     4.366   -21.949     0.200
     4.730   -24.848     0.200
     4.792   -24.065     0.200
     5.549   -29.742     0.200
     6.002   -33.029     0.200
     6.085   -33.737     0.200
     6.088   -33.927     0.200
     6.143   -33.471     0.200
     6.231   -34.768     0.200
     6.606   -37.657     0.200
     7.171   -44.872     0.200
     7.465   -46.993     0.200
     8.340   -58.136     0.200
     8.575   -59.370     0.200
     8.717   -61.873     0.200
     9.509   -68.092     0.200
     9.693   -69.932     0.200
     3.045   -11.931     0.200
     3.332   -13.509     0.200
     3.584   -14.542     0.200
     3.550   -15.402     0.200
     3.573   -15.095     0.200
     3.702   -16.071     0.200
     3.823   -17.105     0.200
     3.846   -17.459     0.200
     3.960   -17.843     0.200
     4.393   -22.739     0.200
     4.327   -20.703     0.200
     4.391   -21.303     0.200
     4.447   -21.803     0.200
     4.699   -24.815     0.200
     5.060   -26.389     0.200
     5.115   -28.352     0.200
     5.519   -29.238     0.200
     5.729   -32.881     0.200
     5.959   -37.585     0.200
     5.988   -34.158     0.200
     6.028   -36.552     0.200
     6.144   -32.848     0.200
     6.305   -35.632     0.200
     6.361   -41.520     0.200
     6.378   -39.047     0.200
     6.601   -37.533     0.200
     6.862   -38.506     0.200
     7.235   -45.128     0.200
     7.876   -49.356     0.200
     8.115   -52.131     0.200
     8.168   -52.001     0.200
     0.886     1.589     0.200
     1.115     1.407     0.200
     1.234     1.637     0.200
     1.453    -0.998     0.200
     1.458     0.939     0.200
     1.614    -0.912     0.200
     2.023    -5.570     0.200
     2.439   -10.242     0.200
     4.732   -26.939     0.200
     5.017   -29.731     0.200
     5.092   -29.751     0.200
     5.765   -33.521     0.200
     5.844   -35.707     0.200
     6.446   -39.275     0.200
     7.651   -50.470     0.200
     7.792   -51.042     0.200
     8.938   -62.162     0.200
     9.318   -65.001     0.200
     0.861     1.870     0.200
     0.904     2.291     0.200
     0.959     2.464     0.200
     1.009     1.374     0.200
     1.031     0.081     0.200
     1.011     1.028     0.200
     1.072     1.088     0.200
     1.154     1.278     0.200
     1.196    -0.564     0.200
     2.691   -11.725     0.200
     2.982   -13.975     0.200
     3.091   -13.305     0.200
     3.199   -12.602     0.200
     3.391   -14.376     0.200
     3.597   -18.241     0.200
     3.706   -16.959     0.200
     4.056   -23.417     0.200
     4.191   -22.203     0.200
     4.280   -23.522     0.200
     4.371   -27.770     0.200
     4.429   -25.687     0.200
     4.429   -24.952     0.200
     4.464   -27.459     0.200
     4.564   -25.501     0.200
     4.562   -28.958     0.200
     4.648   -25.123     0.200
     5.330   -34.299     0.200
     5.392   -29.340     0.200
     6.003   -35.005     0.200
     6.003   -38.037     0.200
     6.021   -33.475     0.200
     6.104   -35.730     0.200
     6.130   -34.227     0.200
     6.274   -36.038     0.200
     6.320   -36.426     0.200
     6.386   -41.188     0.200
     6.403   -39.014     0.200
     6.706   -39.507     0.200
     6.706   -41.531     0.200
     6.962   -47.030     0.200
     6.991   -46.142     0.200
     7.049   -47.609     0.200
     7.049   -46.547     0.200
     7.284   -49.438     0.200
     7.304   -49.683     0.200
     7.346   -50.302     0.200
     8.107   -55.421     0.200
     8.139   -52.551     0.200
     8.186   -58.245     0.200
     8.228   -57.169     0.200
     8.517   -59.340     0.200
     8.716   -61.241     0.200
     8.763   -62.426     0.200
     8.899   -62.931     0.200
     9.140   -64.967     0.200
     9.608   -67.999     0.200
     9.879   -70.419     0.200
     9.885   -70.290     0.200
     9.880   -69.172     0.200
     9.974   -70.805     0.200
     9.997   -71.439     0.200
    10.512   -74.877     0.200
     3.059   -13.031     0.200
     3.423   -13.577     0.200
     3.621   -14.949     0.200
     3.666   -14.936     0.200
     3.816   -19.567     0.200
     3.857   -15.723     0.200
     3.894   -15.635     0.200
     3.958   -17.593     0.200
     3.994   -17.363     0.200
     4.061   -19.801     0.200
     4.367   -19.770     0.200
     4.503   -21.083     0.200
     4.536   -20.867     0.200
     5.219   -26.899     0.200
     5.325   -30.288     0.200
     5.402   -30.045     0.200
     5.812   -31.592     0.200
     5.882   -35.919     0.200
     6.014   -35.331     0.200
     6.038   -37.486     0.200
     6.239   -35.082     0.200
     6.295   -35.195     0.200
     6.320   -34.964     0.200
     6.437   -37.031     0.200
     6.554   -37.613     0.200
     6.740   -37.168     0.200
     7.557   -48.199     0.200
     7.847   -48.218     0.200
     7.920   -50.918     0.200
     1.857    -5.214     0.200
     2.817   -11.947     0.200
     2.839    -9.937     0.200
     2.872   -12.133     0.200
     3.014   -11.076     0.200
     3.098   -11.253     0.200
     3.296   -12.920     0.200
     3.319   -13.153     0.200
     3.381   -13.118     0.200
     3.385   -13.663     0.200
     3.385   -13.663     0.200
     3.755   -16.577     0.200
     3.928   -17.251     0.200
     3.946   -17.933     0.200
     3.946   -17.933     0.200
     4.057   -20.339     0.200
     4.057   -20.237     0.200
     4.160   -21.605     0.200
     4.357   -22.752     0.200
     4.391   -23.229     0.200
     4.498   -25.029     0.200
     4.821   -28.285     0.200
     4.867   -26.416     0.200
     5.010   -28.598     0.200
     5.022   -29.127     0.200
     5.320   -30.640     0.200
     5.489   -32.535     0.200
     5.582   -35.723     0.200
     6.119   -37.808     0.200
     6.171   -35.934     0.200
     6.193   -37.969     0.200
     6.202   -38.705     0.200
     6.245   -36.693     0.200
     6.281   -38.881     0.200
     6.281   -38.801     0.200
     6.478   -37.712     0.200
     6.616   -45.566     0.200
     6.906   -45.148     0.200
     6.983   -48.096     0.200
     7.004   -48.363     0.200
     7.068   -44.901     0.200
     7.198   -45.278     0.200
     7.198   -45.793     0.200
     7.273   -50.412     0.200
     7.372   -47.931     0.200
     7.491   -48.723     0.200
     7.973   -56.382     0.200
     8.050   -56.528     0.200
     8.301   -56.493     0.200
     8.308   -53.999     0.200
     8.342   -59.365     0.200
     8.472   -56.218     0.200
     8.579   -61.007     0.200
     8.718   -62.091     0.200
     9.205   -58.138     0.200
     9.311   -66.306     0.200
     9.508   -68.141     0.200
     9.611   -68.803     0.200
     9.693   -69.414     0.200
     9.713   -69.956     0.200
     9.885   -71.193     0.200
     0.707     3.465     0.200
     0.844     1.236     0.200
     0.884     0.978     0.200
     2.575    -9.232     0.200
     2.754   -13.584     0.200
     3.170   -13.199     0.200
     3.190   -13.430     0.200
     3.190   -13.430     0.200
     4.360   -25.717     0.200
     4.362   -26.119     0.200
     4.702   -26.797     0.200
     4.982   -29.150     0.200
     5.361   -32.106     0.200
     6.036   -36.497     0.200
     6.055   -37.450     0.200
     6.136   -37.328     0.200
     6.279   -38.205     0.200
     6.396   -39.253     0.200
     6.470   -39.766     0.200
     6.553   -42.435     0.200
     6.848   -43.555     0.200
     6.940   -48.618     0.200
     6.942   -47.864     0.200
     7.107   -48.014     0.200
     7.165   -51.453     0.200
     7.404   -50.229     0.200
     7.478   -52.474     0.200
     7.499   -52.813     0.200
     8.412   -59.974     0.200
     8.681   -62.603     0.200
     8.869   -64.155     0.200
     9.064   -66.232     0.200
     9.612   -63.898     0.200
     9.800   -71.677     0.200
     9.883   -70.901     0.200
    10.066   -73.392     0.200
    10.186   -74.119     0.200
     0.672     2.262     0.200
     0.662     2.297     0.200
     0.695     2.734     0.200
     0.770     2.568     0.200
     0.761     1.866     0.200
     0.764     1.645     0.200
     0.840     2.740     0.200
     1.032     1.157     0.200
     1.045     1.064     0.200
     1.524    -3.736     0.200
     2.339    -8.869     0.200
     2.576   -10.795     0.200
     2.569   -10.154     0.200
     2.748   -11.942     0.200
     2.779   -12.025     0.200
     2.826   -12.409     0.200
     2.863   -12.784     0.200
     2.863   -12.784     0.200
     2.965   -13.815     0.200
     3.197   -16.777     0.200
     3.331   -16.614     0.200
     3.409   -16.675     0.200
     3.455   -17.647     0.200
     3.455   -17.647     0.200
     3.923   -20.837     0.200
     4.199   -24.599     0.200
     4.344   -24.843     0.200
     4.669   -23.338     0.200
     5.038   -33.214     0.200
     5.056   -29.512     0.200
     5.165   -29.058     0.200
     5.311   -30.205     0.200
     5.800   -32.845     0.200
     6.419   -39.518     0.200
     6.410   -41.134     0.200
     6.472   -44.576     0.200
     6.502   -39.116     0.200
     6.530   -40.476     0.200
     6.542   -40.208     0.200
     6.691   -42.422     0.200
     6.710   -39.934     0.200
     6.909   -41.124     0.200
     6.982   -48.466     0.200
     7.085   -44.974     0.200
     7.092   -42.541     0.200
     7.226   -50.588     0.200
     7.344   -48.641     0.200
     7.457   -50.123     0.200
     7.457   -49.576     0.200
     7.577   -52.898     0.200
     7.597   -53.055     0.200
     7.754   -51.219     0.200
     7.885   -55.980     0.200
     7.873   -52.782     0.200
     8.105   -59.349     0.200
     8.546   -61.235     0.200
     8.554   -55.169     0.200
     8.559   -58.550     0.200
     8.779   -66.420     0.200
     8.870   -63.407     0.200
     9.083   -64.843     0.200
     9.250   -66.739     0.200
     9.904   -71.376     0.200
     9.925   -71.759     0.200
    10.054   -72.843     0.200
    10.191   -73.682     0.200
    10.232   -74.378     0.200
    10.269   -74.667     0.200
    10.301   -74.854     0.200
    10.485   -76.095     0.200
    10.786   -78.343     0.200
    11.415   -83.693     0.200
    11.672   -85.733     0.200
     0.649     1.605     0.200
     0.772     1.990     0.200
     0.755     1.741     0.200
     0.758     1.847     0.200
     0.844     2.812     0.200
     0.925     2.254     0.200
     0.941     1.929     0.200
     0.953     0.976     0.200
     1.028     1.089     0.200
     1.039     1.038     0.200
     2.863   -13.192     0.200
     3.653   -17.133     0.200
     4.205   -24.805     0.200
     5.041   -33.529     0.200
     6.425   -38.719     0.200
     6.416   -39.699     0.200
     6.476   -44.520     0.200
     6.986   -48.793     0.200
     7.231   -50.342     0.200
     7.582   -52.863     0.200
     7.602   -53.019     0.200
     7.760   -51.223     0.200
     7.796   -55.065     0.200
     7.890   -55.537     0.200
     8.552   -60.608     0.200
     8.876   -63.098     0.200
     9.089   -64.636     0.200
     9.256   -66.027     0.200
     9.909   -71.345     0.200
    10.196   -73.455     0.200
    10.275   -74.230     0.200
    11.421   -82.991     0.200
     1.223     0.460     0.200
     1.398    -0.072     0.200
     2.929   -12.578     0.200
     2.998   -10.894     0.200
     3.077   -11.413     0.200
     3.148   -11.955     0.200
     3.236   -12.537     0.200
     3.273   -13.010     0.200
     3.278   -13.188     0.200
     3.296   -13.240     0.200
     3.365   -13.636     0.200
     3.365   -13.636     0.200
     3.366   -13.580     0.200
     3.740   -17.031     0.200
     3.907   -17.633     0.200
     3.927   -17.867     0.200
     3.927   -17.867     0.200
     3.964   -19.977     0.200
     5.030   -27.550     0.200
     5.343   -29.598     0.200
     5.509   -30.206     0.200
     5.596   -31.490     0.200
     6.107   -34.423     0.200
     6.125   -33.882     0.200
     6.188   -36.850     0.200
     6.270   -35.865     0.200
     6.294   -37.164     0.200
     6.503   -37.778     0.200
     6.641   -39.553     0.200
     7.510   -49.237     0.200
     8.002   -52.749     0.200
     8.370   -55.996     0.200
     8.607   -59.114     0.200
     8.746   -60.225     0.200
     9.426   -64.182     0.200
     9.537   -66.084     0.200
     9.640   -64.369     0.200
     9.872   -65.615     0.200
     1.985    -9.018     0.200
     2.664   -10.434     0.200
     2.710   -11.523     0.200
     3.215   -12.973     0.200
     3.296   -12.750     0.200
     3.474   -14.003     0.200
     3.488   -14.339     0.200
     3.488   -14.339     0.200
     3.627   -18.622     0.200
     3.737   -21.810     0.200
     4.126   -21.889     0.200
     4.141   -22.455     0.200
     4.428   -25.704     0.200
     4.549   -24.981     0.200
     4.786   -29.683     0.200
     4.761   -25.542     0.200
     4.913   -27.191     0.200
     5.285   -30.309     0.200
     5.400   -31.439     0.200
     6.012   -33.740     0.200
     6.060   -35.368     0.200
     6.125   -34.118     0.200
     6.166   -40.417     0.200
     6.260   -34.895     0.200
     6.502   -37.776     0.200
     6.682   -41.478     0.200
     6.895   -46.245     0.200
     7.067   -47.598     0.200
     7.052   -44.900     0.200
     7.225   -48.482     0.200
     7.245   -49.130     0.200
     7.363   -49.380     0.200
     7.480   -50.095     0.200
     8.133   -56.088     0.200
     8.177   -56.263     0.200
     8.479   -58.757     0.200
     8.685   -60.468     0.200
     8.860   -61.922     0.200
     9.534   -67.086     0.200
     9.550   -67.286     0.200
     9.670   -67.993     0.200
     9.826   -68.948     0.200
     2.701   -10.822     0.200
     2.810    -9.775     0.200
     2.817    -9.717     0.200
     2.817    -9.717     0.200
     3.099   -11.541     0.200
     3.183   -12.611     0.200
     3.358   -13.155     0.200
     3.372   -13.601     0.200
     3.372   -13.601     0.200
     3.603   -17.639     0.200
     3.677   -18.009     0.200
     3.802   -19.450     0.200
     3.929   -20.361     0.200
     4.657   -23.468     0.200
     4.915   -24.134     0.200
     4.893   -30.320     0.200
     5.303   -29.434     0.200
     6.012   -33.551     0.200
     6.027   -33.943     0.200
     6.036   -34.032     0.200
     6.119   -33.403     0.200
     6.161   -34.450     0.200
     6.261   -41.501     0.200
     6.289   -35.130     0.200
     6.533   -36.393     0.200
     6.723   -37.137     0.200
     6.749   -44.545     0.200
     6.808   -45.614     0.200
     7.305   -48.583     0.200
     7.325   -48.227     0.200
     7.355   -49.369     0.200
     8.249   -55.694     0.200
     8.536   -58.214     0.200
     8.734   -58.884     0.200
     8.918   -60.808     0.200
     9.590   -66.419     0.200
     9.629   -66.842     0.200
     9.732   -67.012     0.200
     9.900   -69.343     0.200
     9.995   -70.045     0.200
    10.221   -72.702     0.200
     1.351     0.860     0.200
     1.342     0.497     0.200
     1.656    -0.565     0.200
     1.638     0.277     0.200
     2.426    -8.047     0.200
     2.648   -10.229     0.200
     2.956   -11.389     0.200
     3.003   -10.356     0.200
     3.443   -14.814     0.200
     3.443   -14.714     0.200
     3.443   -15.244     0.200
     3.698   -15.911     0.200
     3.698   -18.271     0.200
     3.780   -13.495     0.200
     3.922   -15.095     0.200
     3.922   -20.375     0.200
     3.925   -15.395     0.200
     3.988   -15.393     0.200
     4.043   -15.724     0.200
     4.328   -19.408     0.200
     4.407   -20.094     0.200
     4.611   -24.314     0.200
     4.659   -23.768     0.200
     4.623   -22.772     0.200
     4.718   -26.278     0.200
     4.740   -25.448     0.200
     4.808   -26.169     0.200
     4.873   -25.465     0.200
     4.870   -25.259     0.200
     4.922   -24.872     0.200
     5.184   -28.543     0.200
     5.456   -28.160     0.200
     5.497   -27.781     0.200
     5.453   -28.981     0.200
     5.532   -28.343     0.200
     5.840   -32.090     0.200
     5.826   -33.153     0.200
     6.011   -32.592     0.200
     6.045   -34.488     0.200
     6.175   -38.221     0.200
     6.535   -35.552     0.200
     6.603   -41.992     0.200
     6.587   -35.121     0.200
     6.632   -38.006     0.200
     6.669   -40.100     0.200
     6.692   -37.754     0.200
     6.688   -38.123     0.200
     6.757   -37.091     0.200
     6.723   -38.760     0.200
     6.977   -44.846     0.200
     6.999   -40.025     0.200
     6.988   -40.277     0.200
     7.112   -40.601     0.200
     7.379   -47.472     0.200
     7.400   -47.551     0.200
     7.379   -48.188     0.200
     7.471   -47.712     0.200
     7.540   -46.480     0.200
     7.588   -45.155     0.200
     7.629   -49.024     0.200
     7.709   -48.611     0.200
     7.717   -49.812     0.200
     7.717   -49.812     0.200
     7.813   -49.850     0.200
     7.947   -49.393     0.200
     8.011   -51.635     0.200
     8.210   -54.327     0.200
     8.210   -53.022     0.200
     8.386   -55.121     0.200
     8.397   -55.855     0.200
     8.685   -57.986     0.200
     8.807   -59.041     0.200
     8.786   -53.891     0.200
     8.962   -58.121     0.200
     9.060   -61.478     0.200
     9.224   -60.559     0.200
     9.706   -65.838     0.200
     9.772   -68.055     0.200
     9.958   -68.036     0.200
    10.024   -67.927     0.200
    10.149   -69.005     0.200
    10.221   -64.079     0.200
    18.428  -125.239     0.200
     1.855     2.201     0.200
     2.662   -11.721     0.200
     3.184   -10.238     0.200
     3.391   -14.621     0.200
     3.408   -14.134     0.200
     3.385   -11.290     0.200
     3.432   -11.687     0.200
     3.457   -12.266     0.200
     3.573   -12.948     0.200
     3.794   -13.954     0.200
     3.934   -17.195     0.200
     3.939   -16.058     0.200
     4.002   -16.345     0.200
     4.057   -16.281     0.200
     4.148   -17.071     0.200
     4.254   -18.451     0.200
     4.337   -20.969     0.200
     4.426   -22.563     0.200
     4.418   -23.920     0.200
     4.651   -26.725     0.200
     5.190   -28.538     0.200
     5.344   -29.063     0.200
     5.466   -27.895     0.200
     5.506   -27.477     0.200
     5.538   -31.070     0.200
     5.845   -31.934     0.200
     6.017   -34.101     0.200
     6.092   -35.515     0.200
     6.169   -38.839     0.200
     6.539   -36.925     0.200
     6.596   -42.080     0.200
     6.624   -42.579     0.200
     6.589   -34.302     0.200
     6.582   -41.127     0.200
     6.693   -38.429     0.200
     6.695   -39.165     0.200
     6.760   -38.571     0.200
     6.787   -41.446     0.200
     6.972   -45.400     0.200
     6.990   -39.572     0.200
     7.114   -39.773     0.200
     7.396   -47.744     0.200
     7.464   -49.408     0.200
     7.624   -49.771     0.200
     7.724   -50.630     0.200
     8.018   -51.266     0.200
     8.394   -55.983     0.200
     8.806   -58.434     0.200
     9.777   -63.694     0.200
     1.428     2.036     0.200
     1.748    -2.721     0.200
     3.404   -15.004     0.200
     3.394   -11.783     0.200
     3.441   -11.882     0.200
     3.464   -14.522     0.200
     3.464   -12.221     0.200
     3.583   -12.773     0.200
     3.802   -14.238     0.200
     3.949   -15.477     0.200
     4.009   -16.398     0.200
     4.065   -16.657     0.200
     4.159   -19.838     0.200
     4.349   -21.139     0.200
     4.438   -22.729     0.200
     4.652   -28.077     0.200
     4.776   -23.964     0.200
     4.756   -26.415     0.200
     5.518   -28.192     0.200
     5.856   -32.127     0.200
     6.598   -43.267     0.200
     6.626   -43.251     0.200
     6.702   -37.841     0.200
     6.708   -37.516     0.200
     6.800   -39.666     0.200
     7.467   -49.503     0.200
     7.737   -49.673     0.200
     7.838   -51.154     0.200
     8.031   -51.168     0.200
     8.814   -60.502     0.200
     9.069   -62.691     0.200
    10.027   -69.742     0.200
    10.118   -70.754     0.200
     1.750    -0.183     0.200
     2.285    -7.050     0.200
     2.288    -6.992     0.200
     2.819   -11.180     0.200
     2.839    -9.716     0.200
     3.016   -11.230     0.200
     3.097   -11.791     0.200
     3.167   -12.326     0.200
     3.255   -12.790     0.200
     3.293   -12.795     0.200
     3.297   -13.642     0.200
     3.316   -13.332     0.200
     3.385   -14.812     0.200
     3.385   -14.011     0.200
     3.384   -13.902     0.200
     3.674   -16.192     0.200
     3.758   -16.657     0.200
     3.841   -18.960     0.200
     3.927   -18.010     0.200
     3.947   -18.028     0.200
     4.021   -18.674     0.200
     4.125   -22.600     0.200
     4.258   -22.210     0.200
     4.366   -22.332     0.200
     4.503   -23.671     0.200
     4.706   -23.613     0.200
     5.005   -27.557     0.200
     5.027   -27.491     0.200
     5.020   -26.445     0.200
     5.310   -28.488     0.200
     5.506   -29.516     0.200
     5.641   -29.956     0.200
     6.036   -34.487     0.200
     6.098   -33.685     0.200
     6.119   -36.526     0.200
     6.118   -34.883     0.200
     6.188   -36.953     0.200
     6.218   -37.079     0.200
     6.262   -35.245     0.200
     6.297   -38.756     0.200
     6.495   -36.305     0.200
     6.631   -38.526     0.200
     7.215   -46.001     0.200
     7.508   -48.541     0.200
     2.312    -7.353     0.200
     2.633   -10.843     0.200
     2.635    -9.557     0.200
     2.678   -10.373     0.200
     2.823   -12.895     0.200
     2.882   -11.215     0.200
     2.976   -10.527     0.200
     3.024   -10.919     0.200
     3.182   -15.395     0.200
     3.181   -13.510     0.200
     3.185   -12.452     0.200
     3.383   -14.125     0.200
     3.430   -14.218     0.200
     3.549   -18.404     0.200
     3.514   -15.280     0.200
     3.611   -15.359     0.200
     3.617   -15.622     0.200
     3.625   -15.887     0.200
     3.656   -16.457     0.200
     3.722   -17.564     0.200
     3.722   -16.763     0.200
     3.757   -17.375     0.200
     3.922   -15.989     0.200
     4.029   -18.681     0.200
     4.064   -17.599     0.200
     4.148   -19.589     0.200
     4.164   -20.601     0.200
     4.130   -19.888     0.200
     4.235   -20.619     0.200
     4.261   -20.838     0.200
     4.267   -20.630     0.200
     4.295   -19.763     0.200
     4.298   -21.336     0.200
     4.348   -18.565     0.200
     4.438   -24.759     0.200
     4.490   -23.104     0.200
     4.495   -22.761     0.200
     4.495   -20.292     0.200
     4.649   -24.358     0.200
     4.738   -25.455     0.200
     5.114   -28.245     0.200
     5.268   -27.292     0.200
     5.261   -30.040     0.200
     5.299   -27.390     0.200
     5.742   -35.008     0.200
     5.905   -32.374     0.200
     6.173   -39.356     0.200
     6.204   -37.934     0.200
     6.209   -33.854     0.200
     6.233   -33.742     0.200
     6.276   -33.719     0.200
     6.291   -34.066     0.200
     6.418   -33.387     0.200
     6.457   -35.883     0.200
     6.545   -41.356     0.200
     6.558   -39.902     0.200
     6.609   -36.925     0.200
     6.643   -36.948     0.200
     6.745   -38.149     0.200
     6.951   -44.422     0.200
     6.973   -44.205     0.200
     7.040   -45.546     0.200
     7.055   -46.523     0.200
     7.197   -46.619     0.200
     7.220   -46.889     0.200
     7.423   -46.378     0.200
     7.471   -47.824     0.200
     7.746   -48.111     0.200
     7.763   -49.447     0.200
     7.880   -46.481     0.200
     7.954   -53.602     0.200
     7.977   -51.932     0.200
     8.055   -53.859     0.200
     8.255   -54.665     0.200
     8.406   -55.551     0.200
     8.524   -54.993     0.200
     8.672   -57.282     0.200
     8.777   -59.615     0.200
     9.274   -62.744     0.200
     9.277   -61.966     0.200
     9.462   -64.012     0.200
     9.548   -64.146     0.200
     9.600   -64.284     0.200
     9.641   -65.789     0.200
     9.690   -66.244     0.200
     9.743   -66.421     0.200
     9.834   -66.627     0.200
    10.112   -68.516     0.200
    10.208   -68.758     0.200
    10.204   -68.489     0.200
    10.303   -70.784     0.200
    10.607   -72.320     0.200
    10.633   -74.133     0.200
    10.757   -65.064     0.200
    11.001   -76.197     0.200
    11.236   -78.366     0.200
    11.757   -81.567     0.200
    11.721   -73.643     0.200
    12.574   -86.879     0.200
    12.865   -91.293     0.200
    12.908   -90.560     0.200
    13.877   -98.167     0.200
    14.127  -100.515     0.200
    14.350  -100.162     0.200
    15.786  -105.479     0.200
    15.841  -105.221     0.200
    20.867  -143.374     0.200
     1.027     2.543     0.200
     1.132     2.231     0.200
     2.317    -7.106     0.200
     2.428    -9.168     0.200
     2.640   -11.440     0.200
     2.642    -9.585     0.200
     2.682   -10.507     0.200
     2.826   -10.511     0.200
     2.982   -10.736     0.200
     3.027   -13.504     0.200
     3.189   -13.831     0.200
     3.187   -13.330     0.200
     3.386   -14.930     0.200
     3.432   -15.385     0.200
     3.516   -16.059     0.200
     3.556   -19.081     0.200
     3.614   -16.744     0.200
     3.618   -16.475     0.200
     3.626   -16.828     0.200
     3.658   -17.145     0.200
     3.724   -17.727     0.200
     3.760   -17.690     0.200
     4.031   -20.066     0.200
     4.133   -20.899     0.200
     4.237   -20.718     0.200
     4.289   -20.817     0.200
     4.268   -21.299     0.200
     4.301   -21.616     0.200
     4.648   -25.103     0.200
     5.275   -27.739     0.200
     6.176   -40.173     0.200
     6.207   -37.943     0.200
     6.216   -33.232     0.200
     6.239   -33.317     0.200
     6.463   -36.946     0.200
     6.616   -36.363     0.200
     6.649   -36.240     0.200
     6.956   -44.492     0.200
     7.478   -47.200     0.200
     7.752   -48.523     0.200
     7.769   -48.480     0.200
     7.982   -54.311     0.200
     8.412   -57.255     0.200
     8.678   -59.389     0.200
     9.695   -67.815     0.200
     2.639   -10.282     0.200
     2.646    -8.738     0.200
     2.845   -11.758     0.200
     2.989   -11.514     0.200
     3.047   -12.458     0.200
     3.186   -13.091     0.200
     3.746   -19.339     0.200
     3.746   -19.011     0.200
     4.424   -24.742     0.200
     4.760   -26.184     0.200
     5.263   -31.236     0.200
     6.243   -38.323     0.200
     6.362   -39.583     0.200
     7.471   -49.624     0.200
     1.161     1.518     0.200
     2.435   -10.247     0.200
     2.640   -10.389     0.200
     2.648    -9.830     0.200
     2.992   -11.784     0.200
     3.054   -13.907     0.200
     3.210   -15.539     0.200
     3.216   -13.011     0.200
     3.286   -13.284     0.200
     3.412   -14.340     0.200
     3.461   -14.793     0.200
     3.544   -15.038     0.200
     3.641   -15.701     0.200
     3.648   -16.105     0.200
     3.656   -16.082     0.200
     3.685   -16.496     0.200
     3.753   -18.432     0.200
     3.753   -16.534     0.200
     3.785   -16.674     0.200
     3.918   -19.267     0.200
     3.952   -20.958     0.200
     4.058   -19.032     0.200
     4.096   -21.109     0.200
     4.158   -20.290     0.200
     4.297   -20.797     0.200
     4.328   -21.185     0.200
     4.430   -23.399     0.200
     4.519   -24.133     0.200
     4.766   -27.557     0.200
     5.117   -26.378     0.200
     5.267   -28.411     0.200
     5.303   -27.986     0.200
     5.528   -30.511     0.200
     5.707   -32.545     0.200
     5.911   -33.021     0.200
     6.046   -32.246     0.200
     6.201   -34.135     0.200
     6.222   -34.241     0.200
     6.250   -38.601     0.200
     6.267   -33.002     0.200
     6.283   -34.157     0.200
     6.369   -40.072     0.200
     6.409   -34.406     0.200
     6.458   -36.009     0.200
     6.633   -35.930     0.200
     6.732   -36.590     0.200
     7.012   -48.077     0.200
     7.762   -50.449     0.200
     7.759   -52.154     0.200
     8.389   -60.104     0.200
     8.657   -60.994     0.200
     1.788    -4.801     0.200
     2.391    -7.815     0.200
     2.694   -10.578     0.200
     2.791   -12.847     0.200
     3.030   -11.947     0.200
     3.225   -16.378     0.200
     3.214   -13.789     0.200
     3.187   -12.995     0.200
     3.283   -15.919     0.200
     3.293   -14.717     0.200
     3.430   -14.686     0.200
     3.516   -15.320     0.200
     3.583   -17.034     0.200
     3.615   -16.359     0.200
     3.615   -16.140     0.200
     3.621   -15.835     0.200
     3.660   -15.969     0.200
     3.722   -17.388     0.200
     3.722   -17.048     0.200
     3.924   -18.790     0.200
     4.137   -19.701     0.200
     4.180   -21.201     0.200
     4.255   -22.650     0.200
     4.267   -20.920     0.200
     4.301   -21.099     0.200
     4.492   -23.309     0.200
     4.896   -30.927     0.200
     5.062   -25.823     0.200
     5.115   -29.845     0.200
     5.245   -29.026     0.200
     5.331   -27.834     0.200
     5.768   -34.989     0.200
     6.196   -39.469     0.200
     6.226   -39.416     0.200
     6.244   -33.671     0.200
     6.311   -34.652     0.200
     6.350   -36.555     0.200
     6.304   -38.849     0.200
     6.490   -38.549     0.200
     6.490   -38.073     0.200
     6.572   -42.103     0.200
     6.621   -40.578     0.200
     6.980   -45.034     0.200
     7.002   -45.317     0.200
     7.064   -45.079     0.200
     7.224   -47.557     0.200
     7.288   -48.495     0.200
     7.700   -44.539     0.200
     7.772   -50.144     0.200
     7.796   -50.807     0.200
     7.819   -50.422     0.200
     7.830   -46.066     0.200
     7.979   -53.001     0.200
     8.007   -53.492     0.200
     8.086   -53.984     0.200
     8.278   -55.171     0.200
     8.439   -56.778     0.200
     8.603   -53.483     0.200
     8.706   -58.934     0.200
     8.686   -55.903     0.200
     8.810   -59.938     0.200
     8.743   -56.226     0.200
     9.133   -52.567     0.200
     9.293   -63.253     0.200
    10.002   -66.620     0.200
     3.029   -12.491     0.200
     3.188   -12.980     0.200
     3.431   -14.792     0.200
     3.517   -14.704     0.200
     3.615   -16.028     0.200
     3.616   -15.661     0.200
     3.623   -15.575     0.200
     3.660   -16.133     0.200
     3.723   -16.649     0.200
     4.136   -19.938     0.200
     4.171   -21.516     0.200
     4.249   -21.506     0.200
     4.268   -20.519     0.200
     4.301   -20.578     0.200
     5.760   -33.705     0.200
     5.765   -31.917     0.200
     6.219   -38.158     0.200
     6.340   -36.214     0.200
     6.481   -36.597     0.200
     6.564   -40.503     0.200
     6.971   -42.018     0.200
     6.993   -41.600     0.200
     7.216   -44.160     0.200
     7.280   -48.115     0.200
     7.280   -47.714     0.200
     7.765   -48.691     0.200
     7.787   -50.474     0.200
     7.971   -50.613     0.200
    10.185   -70.715     0.200
     4.852   -29.884     0.200
     7.963   -52.925     0.200
     8.890   -61.302     0.200
     9.266   -64.314     0.200
     2.726    -9.782     0.200
     2.726    -8.680     0.200
     2.905   -11.453     0.200
     2.905    -9.953     0.200
     2.984   -10.260     0.200
     3.054   -10.994     0.200
     3.142   -11.174     0.200
     3.185   -13.331     0.200
     3.185   -11.632     0.200
     3.204   -12.939     0.200
     3.204   -12.337     0.200
     3.274   -12.765     0.200
     3.271   -12.474     0.200
     3.648   -15.008     0.200
     3.648   -15.207     0.200
     3.771   -16.303     0.200
     3.804   -16.986     0.200
     3.814   -16.472     0.200
     3.834   -16.403     0.200
     3.881   -15.962     0.200
     3.904   -19.246     0.200
     3.967   -22.409     0.200
     4.034   -20.796     0.200
     4.098   -21.300     0.200
     4.383   -22.723     0.200
     4.676   -23.610     0.200
     4.717   -24.697     0.200
     4.814   -24.213     0.200
     4.840   -23.607     0.200
     4.933   -26.044     0.200
     4.973   -27.512     0.200
     5.017   -26.696     0.200
     5.343   -28.090     0.200
     5.327   -28.642     0.200
     5.498   -30.573     0.200
     5.560   -33.068     0.200
     5.560   -32.814     0.200
     5.642   -31.634     0.200
     5.879   -32.828     0.200
     6.123   -34.239     0.200
     6.131   -34.319     0.200
     6.137   -35.989     0.200
     6.166   -36.359     0.200
     6.166   -36.003     0.200
     6.254   -33.793     0.200
     6.187   -36.009     0.200
     6.256   -37.270     0.200
     6.280   -33.278     0.200
     6.515   -36.111     0.200
     6.530   -37.759     0.200
     6.555   -39.071     0.200
     6.662   -36.789     0.200
     6.665   -42.569     0.200
     6.866   -44.541     0.200
     7.197   -45.528     0.200
     7.197   -45.106     0.200
     7.270   -52.224     0.200
     7.289   -45.846     0.200
     7.319   -45.483     0.200
     7.367   -51.514     0.200
     7.426   -47.592     0.200
     7.492   -48.065     0.200
     7.585   -48.633     0.200
     7.690   -50.948     0.200
     7.690   -50.042     0.200
     8.012   -52.960     0.200
     8.089   -56.895     0.200
     8.123   -50.175     0.200
     8.271   -52.775     0.200
     8.291   -54.911     0.200
     8.406   -59.338     0.200
     8.636   -59.351     0.200
     8.641   -48.899     0.200
     8.783   -61.894     0.200
     9.462   -68.316     0.200
     9.692   -69.298     0.200
     9.702   -61.924     0.200
     9.762   -70.725     0.200
     9.797   -69.434     0.200
     9.798   -71.685     0.200
    10.069   -68.856     0.200
    10.415   -76.744     0.200
    10.415   -76.934     0.200
    10.969   -81.003     0.200
    11.219   -82.316     0.200
    19.526  -132.364     0.200
     0.834     2.167     0.200
     0.944     1.839     0.200
     0.939     1.872     0.200
     0.947     1.728     0.200
     1.016     2.371     0.200
     0.993     1.419     0.200
     1.014     1.092     0.200
     1.626    -3.768     0.200
     1.899    -6.783     0.200
     1.955    -5.530     0.200
     2.059    -6.848     0.200
     2.114    -7.239     0.200
     2.168    -7.750     0.200
     2.235    -8.654     0.200
     2.366    -9.982     0.200
     3.269   -12.539     0.200
     3.364   -13.348     0.200
     3.519   -14.356     0.200
     3.541   -14.549     0.200
     3.977   -21.061     0.200
     4.163   -22.848     0.200
     4.435   -25.388     0.200
     4.777   -26.289     0.200
     4.789   -30.620     0.200
     4.916   -29.953     0.200
     5.016   -29.544     0.200
     5.382   -31.139     0.200
     5.485   -33.684     0.200
     5.503   -31.427     0.200
     6.105   -35.333     0.200
     6.132   -37.854     0.200
     6.172   -35.471     0.200
     6.188   -36.465     0.200
     6.206   -36.657     0.200
     6.211   -36.516     0.200
     6.350   -35.916     0.200
     6.369   -37.044     0.200
     6.591   -38.047     0.200
     6.719   -43.785     0.200
     6.745   -42.723     0.200
     6.764   -41.905     0.200
     6.931   -45.612     0.200
     7.092   -47.217     0.200
     7.174   -47.515     0.200
     7.162   -47.445     0.200
     7.271   -47.973     0.200
     7.291   -48.727     0.200
     7.470   -49.993     0.200
     7.517   -50.477     0.200
     7.591   -52.335     0.200
     8.232   -56.059     0.200
     8.549   -59.004     0.200
     8.761   -60.013     0.200
     8.929   -62.445     0.200
     9.597   -67.623     0.200
     9.604   -66.852     0.200
     9.735   -68.290     0.200
     9.879   -69.268     0.200
     9.876   -68.872     0.200
     9.963   -69.417     0.200
     9.991   -69.718     0.200
    10.182   -71.664     0.200
     1.257     0.073     0.200
     1.407    -0.513     0.200
     1.481    -0.737     0.200
     1.488    -0.081     0.200
     4.383   -22.280     0.200
     4.760   -25.174     0.200
     4.899   -25.631     0.200
     5.000   -24.739     0.200
     5.366   -30.809     0.200
     5.467   -28.980     0.200
     5.486   -29.313     0.200
     6.090   -34.037     0.200
     6.115   -33.138     0.200
     6.186   -38.702     0.200
     7.512   -51.462     0.200
     8.223   -55.581     0.200
     8.538   -59.659     0.200
     8.748   -59.441     0.200
     8.917   -62.702     0.200
     9.870   -69.399     0.200
     1.989    -6.202     0.200
     2.199    -7.719     0.200
     2.431    -8.334     0.200
     2.483    -9.991     0.200
     2.705   -11.276     0.200
     3.056   -14.017     0.200
     3.245   -16.023     0.200
     4.300   -23.471     0.200
     5.084   -28.784     0.200
     5.121   -30.172     0.200
     5.127   -30.056     0.200
     5.215   -30.452     0.200
     5.251   -31.301     0.200
     5.280   -31.420     0.200
     5.443   -32.473     0.200
     5.692   -32.673     0.200
     5.825   -34.085     0.200
     6.003   -35.637     0.200
     6.138   -36.313     0.200
     6.138   -36.400     0.200
     6.426   -41.124     0.200
     7.394   -51.109     0.200
     7.498   -48.810     0.200
     7.688   -50.259     0.200
     9.942   -69.053     0.200
     2.075    -4.699     0.200
     2.240    -7.944     0.200
     2.455    -8.867     0.200
     2.471    -8.828     0.200
     2.632    -9.120     0.200
     2.684   -10.200     0.200
     2.785   -10.774     0.200
     2.997   -10.402     0.200
     3.028   -12.611     0.200
     3.010   -10.384     0.200
     3.099   -13.919     0.200
     3.212   -13.988     0.200
     3.197   -11.738     0.200
     3.261   -12.262     0.200
     3.338   -12.712     0.200
     3.415   -15.444     0.200
     3.429   -15.969     0.200
     3.431   -13.433     0.200
     3.452   -13.614     0.200
     3.468   -13.909     0.200
     3.474   -13.708     0.200
     3.515   -16.673     0.200
     3.551   -14.643     0.200
     3.551   -14.245     0.200
     3.568   -14.400     0.200
     3.708   -15.228     0.200
     3.787   -18.617     0.200
     3.849   -16.495     0.200
     3.929   -17.230     0.200
     3.929   -17.527     0.200
     3.942   -17.337     0.200
     4.119   -21.941     0.200
     4.095   -18.279     0.200
     4.120   -18.499     0.200
     4.353   -22.679     0.200
     4.397   -23.299     0.200
     4.471   -24.277     0.200
     4.502   -22.911     0.200
     4.550   -22.805     0.200
     4.729   -26.496     0.200
     4.775   -26.321     0.200
     4.970   -24.862     0.200
     4.970   -25.010     0.200
     5.052   -26.721     0.200
     5.082   -26.868     0.200
     5.141   -27.336     0.200
     5.146   -27.043     0.200
     5.190   -31.812     0.200
     5.222   -29.517     0.200
     5.429   -28.701     0.200
     5.496   -30.890     0.200
     5.617   -30.263     0.200
     5.617   -29.998     0.200
     5.746   -32.616     0.200
     5.915   -34.973     0.200
     6.037   -36.465     0.200
     6.116   -32.411     0.200
     6.159   -32.645     0.200
     6.191   -34.362     0.200
     6.184   -34.225     0.200
     6.163   -36.354     0.200
     6.198   -33.688     0.200
     6.261   -35.677     0.200
     6.281   -34.588     0.200
     6.317   -35.835     0.200
     6.317   -35.585     0.200
     6.334   -33.602     0.200
     6.448   -36.518     0.200
     6.460   -38.871     0.200
     6.562   -36.609     0.200
     6.682   -38.356     0.200
     6.773   -38.675     0.200
     6.797   -41.032     0.200
     6.941   -41.307     0.200
     6.990   -41.464     0.200
     7.085   -42.880     0.200
     7.126   -37.379     0.200
     7.248   -43.852     0.200
     7.286   -45.536     0.200
     7.337   -45.265     0.200
     7.337   -44.921     0.200
     7.562   -46.278     0.200
     7.624   -47.574     0.200
     7.630   -47.554     0.200
     8.377   -53.715     0.200
     8.452   -55.805     0.200
     8.629   -56.206     0.200
     8.667   -56.142     0.200
     8.750   -57.357     0.200
     9.433   -62.898     0.200
     9.608   -62.453     0.200
     9.661   -62.732     0.200
     9.721   -64.433     0.200
     9.762   -65.940     0.200
     9.786   -64.678     0.200
     9.862   -64.709     0.200
    11.201   -75.540     0.200
     2.263    -7.619     0.200
     2.478    -9.411     0.200
     2.490    -9.722     0.200
     2.660    -9.077     0.200
     2.712    -9.928     0.200
     2.811   -12.398     0.200
     3.121   -14.524     0.200
     3.229   -16.070     0.200
     3.441   -16.588     0.200
     3.435   -16.555     0.200
     3.529   -17.635     0.200
     3.578   -16.490     0.200
     4.139   -22.933     0.200
     4.333   -24.642     0.200
     4.376   -22.940     0.200
     4.492   -25.030     0.200
     4.578   -26.992     0.200
     4.986   -26.380     0.200
     5.155   -28.276     0.200
     5.164   -27.819     0.200
     5.439   -29.309     0.200
     5.765   -32.131     0.200
     5.784   -37.331     0.200
     6.124   -32.647     0.200
     6.164   -34.505     0.200
     6.197   -34.754     0.200
     6.206   -34.181     0.200
     6.190   -38.715     0.200
     6.265   -41.867     0.200
     6.263   -36.878     0.200
     6.332   -36.582     0.200
     6.340   -35.351     0.200
     6.467   -37.306     0.200
     6.486   -39.197     0.200
     6.571   -43.970     0.200
     6.568   -36.932     0.200
     6.960   -46.914     0.200
     7.301   -46.228     0.200
     7.352   -49.228     0.200
     7.585   -45.624     0.200
     7.644   -48.200     0.200
     8.375   -56.356     0.200
     8.629   -59.615     0.200
     8.748   -60.190     0.200
     2.120    -6.126     0.200
     2.242    -7.448     0.200
     2.457    -8.188     0.200
     2.472    -9.683     0.200
     2.639    -9.625     0.200
     2.690    -8.703     0.200
     2.789    -9.924     0.200
     3.028   -13.411     0.200
     3.212   -14.286     0.200
     3.427   -17.713     0.200
     3.416   -15.520     0.200
     3.513   -17.835     0.200
     3.787   -19.152     0.200
     3.937   -17.561     0.200
     4.120   -21.244     0.200
     4.216   -21.394     0.200
     4.315   -24.845     0.200
     4.355   -22.671     0.200
     4.557   -25.199     0.200
     4.698   -24.187     0.200
     4.970   -25.210     0.200
     5.059   -27.912     0.200
     5.140   -25.920     0.200
     5.146   -27.849     0.200
     5.426   -29.596     0.200
     5.790   -34.193     0.200
     5.746   -31.435     0.200
     6.187   -33.102     0.200
     6.256   -38.409     0.200
     6.330   -35.028     0.200
     6.316   -36.225     0.200
     6.449   -40.318     0.200
     6.962   -44.141     0.200
     7.285   -45.385     0.200
     7.336   -45.656     0.200
     7.629   -46.786     0.200
     8.371   -55.010     0.200
     8.624   -57.716     0.200
     8.745   -58.453     0.200
     9.601   -64.512     0.200
     2.074    -4.603     0.200
     2.116    -6.275     0.200
     2.243    -7.373     0.200
     2.458    -8.454     0.200
     2.475    -8.534     0.200
     2.631    -9.246     0.200
     2.685    -9.266     0.200
     3.103   -13.625     0.200
     3.217   -15.029     0.200
     3.418   -16.168     0.200
     3.434   -16.544     0.200
     3.520   -17.957     0.200
     4.123   -21.363     0.200
     4.356   -22.690     0.200
     4.475   -24.125     0.200
     4.733   -25.758     0.200
     5.151   -27.306     0.200
     5.435   -28.926     0.200
     6.322   -36.916     0.200
     6.452   -38.051     0.200
     7.243   -49.532     0.200
     7.291   -42.842     0.200
     7.343   -46.680     0.200
     7.564   -45.620     0.200
     7.635   -46.963     0.200
     8.383   -57.571     0.200
     8.757   -60.611     0.200
     2.116    -5.713     0.200
     2.238    -7.344     0.200
     2.453    -8.655     0.200
     2.467    -8.483     0.200
     2.635    -8.450     0.200
     2.686    -8.703     0.200
     2.784   -10.296     0.200
     3.024   -13.345     0.200
     3.002   -13.595     0.200
     3.096   -12.528     0.200
     3.208   -14.694     0.200
     3.411   -16.345     0.200
     3.423   -16.085     0.200
     3.509   -17.423     0.200
     3.556   -16.070     0.200
     3.782   -19.771     0.200
     3.985   -19.179     0.200
     4.116   -21.280     0.200
     4.212   -22.269     0.200
     4.316   -21.654     0.200
     4.310   -23.456     0.200
     4.350   -22.848     0.200
     4.468   -24.272     0.200
     4.553   -24.787     0.200
     4.661   -23.563     0.200
     4.726   -25.882     0.200
     4.966   -26.089     0.200
     5.136   -25.703     0.200
     5.142   -27.839     0.200
     5.423   -29.528     0.200
     5.484   -31.405     0.200
     5.742   -30.291     0.200
     5.790   -33.977     0.200
     5.920   -35.617     0.200
     6.110   -34.134     0.200
     6.152   -33.892     0.200
     6.184   -33.571     0.200
     6.191   -34.622     0.200
     6.168   -37.770     0.200
     6.253   -37.702     0.200
     6.312   -35.698     0.200
     6.327   -34.951     0.200
     6.444   -37.307     0.200
     6.466   -38.537     0.200
     6.556   -37.502     0.200
     6.982   -42.569     0.200
     7.082   -43.354     0.200
     7.126   -38.462     0.200
     7.281   -43.854     0.200
     7.332   -46.720     0.200
     7.560   -46.689     0.200
     7.625   -46.657     0.200
     8.369   -53.932     0.200
     8.742   -56.581     0.200
     9.425   -63.014     0.200
     9.600   -63.364     0.200
     9.755   -68.960     0.200
     3.361   -14.486     0.200
     4.108   -19.919     0.200
     4.392   -25.946     0.200
     4.443   -24.952     0.200
     4.987   -26.755     0.200
     4.994   -28.370     0.200
     5.296   -30.195     0.200
     5.342   -28.500     0.200
     5.508   -28.325     0.200
     5.488   -26.223     0.200
     5.883   -36.280     0.200
     6.042   -31.472     0.200
     6.107   -31.674     0.200
     6.124   -30.576     0.200
     6.186   -34.823     0.200
     6.229   -34.126     0.200
     6.269   -31.764     0.200
     6.343   -39.257     0.200
     6.388   -39.995     0.200
     6.502   -35.376     0.200
     6.641   -37.044     0.200
     6.648   -41.629     0.200
     7.014   -45.350     0.200
     7.035   -45.114     0.200
     7.154   -45.767     0.200
     7.214   -45.946     0.200
     7.342   -45.737     0.200
     7.374   -46.264     0.200
     7.508   -47.613     0.200
     8.371   -57.349     0.200
     8.607   -59.655     0.200
     8.747   -60.673     0.200
     9.642   -66.543     0.200
     9.875   -67.125     0.200
    10.122   -70.128     0.200
     2.241    -7.756     0.200
     2.456    -8.767     0.200
     2.471    -9.425     0.200
     2.484    -8.602     0.200
     2.637    -8.749     0.200
     2.688    -9.059     0.200
     2.769   -12.675     0.200
     2.787   -10.972     0.200
     3.028   -13.469     0.200
     3.015   -11.251     0.200
     3.100   -13.937     0.200
     3.212   -14.904     0.200
     3.202   -12.584     0.200
     3.267   -13.126     0.200
     3.344   -13.672     0.200
     3.415   -15.506     0.200
     3.427   -17.439     0.200
     3.436   -14.290     0.200
     3.458   -14.485     0.200
     3.474   -14.585     0.200
     3.513   -17.546     0.200
     3.549   -17.293     0.200
     3.556   -15.112     0.200
     3.563   -19.531     0.200
     3.573   -15.342     0.200
     3.854   -17.358     0.200
     3.940   -17.496     0.200
     4.119   -20.827     0.200
     4.126   -19.355     0.200
     4.216   -19.240     0.200
     4.317   -23.437     0.200
     4.354   -22.287     0.200
     4.472   -24.113     0.200
     4.542   -24.240     0.200
     4.775   -26.035     0.200
     4.969   -26.598     0.200
     5.140   -28.405     0.200
     5.146   -27.638     0.200
     5.427   -29.941     0.200
     5.746   -32.367     0.200
     6.113   -32.631     0.200
     6.156   -34.652     0.200
     6.188   -34.243     0.200
     6.195   -35.791     0.200
     6.257   -35.661     0.200
     6.315   -37.304     0.200
     6.448   -38.159     0.200
     7.285   -45.499     0.200
     7.336   -44.300     0.200
     7.629   -48.104     0.200
     8.372   -54.772     0.200
     8.625   -57.370     0.200
     8.746   -58.514     0.200
     2.346    -8.409     0.200
     2.922   -10.534     0.200
     3.023   -11.230     0.200
     3.086   -12.130     0.200
     3.167   -12.204     0.200
     3.209   -12.221     0.200
     3.223   -13.081     0.200
     3.254   -12.856     0.200
     3.286   -12.670     0.200
     3.308   -13.768     0.200
     3.588   -15.335     0.200
     3.661   -15.747     0.200
     3.723   -17.524     0.200
     3.810   -19.093     0.200
     3.849   -17.613     0.200
     3.862   -17.812     0.200
     4.013   -20.143     0.200
     4.304   -23.431     0.200
     4.726   -25.858     0.200
     4.889   -28.750     0.200
     5.403   -32.530     0.200
     5.479   -32.446     0.200
     5.863   -40.551     0.200
     5.969   -34.780     0.200
     6.077   -36.446     0.200
     6.178   -36.270     0.200
     6.177   -38.064     0.200
     6.616   -46.839     0.200
     6.595   -43.272     0.200
     6.797   -44.064     0.200
     6.972   -49.815     0.200
     6.993   -49.873     0.200
     7.043   -45.577     0.200
     7.106   -48.094     0.200
     7.275   -52.224     0.200
     7.260   -47.746     0.200
     7.350   -48.186     0.200
     7.952   -57.370     0.200
     8.205   -55.982     0.200
     8.200   -52.644     0.200
     8.303   -58.917     0.200
     8.391   -55.108     0.200
     8.533   -62.009     0.200
     8.681   -63.173     0.200
     9.300   -68.112     0.200
     9.359   -68.495     0.200
     9.476   -69.485     0.200
     9.593   -70.496     0.200
     9.665   -70.889     0.200
     9.658   -71.073     0.200
     9.699   -71.463     0.200
     9.696   -71.073     0.200
    10.166   -69.743     0.200
     2.438    -9.348     0.200
     2.779    -9.960     0.200
     2.781   -11.524     0.200
     2.987   -11.943     0.200
     3.022   -11.954     0.200
     3.108   -12.985     0.200
     3.207   -15.345     0.200
     3.314   -14.109     0.200
     3.365   -14.947     0.200
     3.624   -16.657     0.200
     3.627   -15.646     0.200
     3.858   -18.178     0.200
     3.893   -18.480     0.200
     3.898   -21.738     0.200
     4.025   -22.953     0.200
     4.090   -24.238     0.200
     4.307   -25.496     0.200
     4.343   -25.951     0.200
     4.849   -28.481     0.200
     5.226   -28.316     0.200
     5.547   -31.106     0.200
     5.931   -38.792     0.200
     6.249   -37.720     0.200
     6.316   -37.363     0.200
     6.331   -36.790     0.200
     6.334   -35.718     0.200
     6.376   -38.362     0.200
     6.463   -40.352     0.200
     6.477   -36.680     0.200
     7.342   -47.201     0.200
     8.576   -59.937     0.200
     8.815   -63.118     0.200
     8.952   -62.950     0.200
     9.741   -71.949     0.200
     2.434    -9.521     0.200
     2.779   -12.237     0.200
     2.778   -10.805     0.200
     2.984   -10.747     0.200
     3.106   -11.628     0.200
     3.206   -12.300     0.200
     3.207   -12.322     0.200
     3.217   -12.343     0.200
     3.313   -13.370     0.200
     3.362   -13.238     0.200
     3.619   -15.995     0.200
     3.623   -15.388     0.200
     3.733   -16.107     0.200
     3.857   -16.835     0.200
     3.893   -21.171     0.200
     3.891   -17.616     0.200
     4.021   -23.419     0.200
     4.088   -23.552     0.200
     4.340   -25.148     0.200
     4.502   -26.566     0.200
     4.509   -26.501     0.200
     4.583   -29.533     0.200
     4.820   -27.858     0.200
     4.846   -29.375     0.200
     4.854   -28.238     0.200
     5.069   -30.747     0.200
     5.216   -29.375     0.200
     5.374   -33.413     0.200
     5.397   -34.050     0.200
     5.537   -31.877     0.200
     6.240   -37.369     0.200
     6.262   -36.281     0.200
     6.307   -38.112     0.200
     6.325   -36.556     0.200
     6.366   -38.299     0.200
     6.454   -40.183     0.200
     6.538   -44.898     0.200
     7.059   -47.014     0.200
     7.218   -48.780     0.200
     7.332   -47.795     0.200
     7.358   -51.111     0.200
     7.398   -48.771     0.200
     7.478   -52.216     0.200
     7.502   -48.857     0.200
     7.692   -51.103     0.200
     8.193   -56.281     0.200
     8.492   -55.656     0.200
     8.568   -59.061     0.200
     8.807   -61.631     0.200
     8.944   -62.271     0.200
     9.526   -66.322     0.200
     9.624   -67.740     0.200
     9.732   -68.074     0.200
     9.829   -70.140     0.200
     9.890   -68.987     0.200
     9.919   -69.973     0.200
     9.930   -70.533     0.200
     0.702     1.344     0.200
     0.785     1.226     0.200
     0.914     1.503     0.200
     0.933     1.838     0.200
     0.922     1.798     0.200
     0.927     0.428     0.200
     1.081     0.310     0.200
     2.111    -6.813     0.200
     2.303    -8.486     0.200
     2.369    -8.692     0.200
     2.440    -9.329     0.200
     2.531   -10.028     0.200
     2.567   -10.174     0.200
     2.598   -10.244     0.200
     2.656   -10.893     0.200
     2.680   -11.447     0.200
     2.949   -13.286     0.200
     3.051   -14.219     0.200
     3.198   -14.989     0.200
     3.221   -15.286     0.200
     3.898   -23.148     0.200
     3.854   -20.433     0.200
     4.803   -25.251     0.200
     5.007   -30.519     0.200
     5.415   -32.999     0.200
     5.497   -35.537     0.200
     6.024   -38.171     0.200
     6.068   -39.322     0.200
     6.083   -38.502     0.200
     6.155   -37.350     0.200
     6.222   -38.220     0.200
     6.294   -38.194     0.200
     6.441   -43.689     0.200
     6.600   -43.530     0.200
     6.661   -43.215     0.200
     6.862   -44.917     0.200
     6.989   -47.940     0.200
     6.979   -45.321     0.200
     7.035   -48.417     0.200
     7.135   -48.129     0.200
     7.135   -48.797     0.200
     7.161   -49.192     0.200
     7.216   -47.541     0.200
     7.432   -52.384     0.200
     7.498   -51.574     0.200
     7.472   -51.324     0.200
     7.561   -52.334     0.200
     7.774   -54.336     0.200
     7.822   -54.463     0.200
     8.014   -52.848     0.200
     8.174   -57.123     0.200
     8.415   -59.048     0.200
     8.619   -60.733     0.200
     8.690   -60.862     0.200
     8.686   -61.733     0.200
     8.880   -62.397     0.200
     9.009   -63.791     0.200
     9.072   -63.881     0.200
     9.743   -69.241     0.200
     9.695   -70.955     0.200
     9.800   -69.858     0.200
     9.890   -70.404     0.200
    10.060   -71.793     0.200
    10.068   -71.843     0.200
    10.091   -72.089     0.200
    10.102   -72.518     0.200
    10.166   -73.062     0.200
    10.187   -72.835     0.200
    10.394   -74.581     0.200
    10.433   -74.628     0.200
    10.709   -76.873     0.200
    10.896   -78.289     0.200
    11.211   -80.775     0.200
    11.476   -82.874     0.200
    12.355   -89.842     0.200
    13.055   -95.238     0.200
    13.343   -97.455     0.200
    13.419   -98.165     0.200
    14.427  -106.133     0.200
    14.906  -109.724     0.200
     0.744     1.255     0.200
     0.765     1.271     0.200
     0.858     1.845     0.200
     0.903     2.569     0.200
     0.847     1.789     0.200
     0.965     1.428     0.200
     0.952     1.056     0.200
     1.232    -2.580     0.200
     1.449    -4.033     0.200
     1.717    -5.665     0.200
     1.728    -6.102     0.200
     1.872    -7.313     0.200
     1.938    -6.890     0.200
     1.898    -7.295     0.200
     2.079    -8.877     0.200
     2.247    -7.774     0.200
     2.574   -12.278     0.200
     2.738   -11.800     0.200
     2.869   -14.116     0.200
     3.066   -15.523     0.200
     3.093   -14.701     0.200
     3.481   -18.725     0.200
     3.480   -19.627     0.200
     3.836   -21.372     0.200
     3.875   -21.837     0.200
     3.992   -24.759     0.200
     4.117   -24.672     0.200
     4.360   -26.119     0.200
     4.366   -26.319     0.200
     4.815   -29.095     0.200
     4.925   -32.298     0.200
     5.100   -31.483     0.200
     5.171   -34.187     0.200
     5.466   -35.479     0.200
     5.515   -34.339     0.200
     5.591   -35.962     0.200
     5.917   -37.425     0.200
     6.113   -38.836     0.200
     6.138   -40.981     0.200
     6.167   -40.576     0.200
     6.257   -36.922     0.200
     6.340   -38.546     0.200
     6.374   -39.640     0.200
     6.400   -40.511     0.200
     6.518   -41.492     0.200
     6.547   -45.310     0.200
     6.765   -43.065     0.200
     6.969   -45.342     0.200
     7.021   -47.043     0.200
     7.091   -49.737     0.200
     7.221   -49.474     0.200
     7.269   -51.104     0.200
     7.518   -53.079     0.200
     7.588   -53.701     0.200
     7.608   -53.744     0.200
     7.879   -55.822     0.200
     7.931   -56.272     0.200
     8.526   -61.142     0.200
     8.800   -63.431     0.200
     8.989   -65.226     0.200
     9.183   -66.453     0.200
     9.853   -71.605     0.200
     9.911   -72.235     0.200
    10.179   -74.534     0.200
    10.277   -74.639     0.200
    10.298   -75.321     0.200
    10.504   -76.842     0.200
    10.819   -79.213     0.200
     2.672   -10.865     0.200
     2.929   -11.407     0.200
     3.162   -13.566     0.200
     3.257   -14.096     0.200
     3.332   -14.456     0.200
     3.452   -15.657     0.200
     3.915   -19.149     0.200
     3.997   -19.246     0.200
     4.045   -19.983     0.200
     6.529   -39.011     0.200
     6.604   -39.029     0.200
     6.669   -38.663     0.200
     7.635   -50.258     0.200
     7.929   -49.987     0.200
     1.975    -5.234     0.200
     2.781    -9.045     0.200
     2.936   -10.157     0.200
     3.050   -10.760     0.200
     3.108   -11.311     0.200
     3.186   -11.862     0.200
     3.253   -12.491     0.200
     3.297   -12.379     0.200
     3.287   -14.280     0.200
     3.334   -13.147     0.200
     3.607   -15.112     0.200
     3.672   -15.266     0.200
     3.754   -18.266     0.200
     3.873   -16.653     0.200
     3.882   -17.017     0.200
     4.366   -26.175     0.200
     4.533   -21.336     0.200
     4.673   -23.631     0.200
     4.672   -25.365     0.200
     4.767   -27.079     0.200
     4.839   -24.545     0.200
     4.866   -26.617     0.200
     4.898   -25.534     0.200
     4.924   -26.082     0.200
     5.032   -27.275     0.200
     5.057   -27.969     0.200
     5.184   -27.338     0.200
     5.287   -30.072     0.200
     5.346   -29.613     0.200
     5.365   -30.354     0.200
     5.388   -30.175     0.200
     5.399   -30.522     0.200
     5.458   -31.699     0.200
     5.488   -32.634     0.200
     5.562   -31.494     0.200
     5.571   -33.183     0.200
     5.730   -34.117     0.200
     5.793   -32.438     0.200
     5.769   -33.644     0.200
     5.818   -34.736     0.200
     5.887   -31.278     0.200
     5.913   -32.880     0.200
     5.904   -34.332     0.200
     5.958   -31.477     0.200
     5.969   -33.072     0.200
     5.973   -32.565     0.200
     6.023   -34.822     0.200
     6.074   -33.624     0.200
     6.088   -34.331     0.200
     6.117   -34.169     0.200
     6.131   -36.981     0.200
     6.351   -35.897     0.200
     6.497   -37.852     0.200
     6.742   -37.324     0.200
     6.756   -41.144     0.200
     7.052   -44.388     0.200
     7.052   -44.306     0.200
     7.226   -45.444     0.200
     7.296   -46.151     0.200
     7.304   -46.817     0.200
     7.345   -47.625     0.200
     7.434   -48.719     0.200
     7.569   -48.513     0.200
     7.569   -47.517     0.200
     7.614   -50.323     0.200
     7.745   -47.298     0.200
     8.076   -53.572     0.200
     8.139   -55.501     0.200
     8.158   -51.487     0.200
     8.558   -56.565     0.200
     9.532   -67.848     0.200
     9.555   -64.666     0.200
     9.899   -62.258     0.200
    10.226   -67.758     0.200
    10.803   -79.343     0.200
    10.829   -73.827     0.200
    10.973   -73.685     0.200
    11.053   -82.159     0.200
    16.694  -110.866     0.200
     1.066     2.245     0.200
     1.080     2.736     0.200
     1.080     2.499     0.200
     1.118     3.232     0.200
     1.099     2.971     0.200
     1.149     2.596     0.200
     1.161     0.337     0.200
     1.168     0.753     0.200
     1.198     2.637     0.200
     1.223     1.720     0.200
     1.239     1.810     0.200
     1.315     0.746     0.200
     1.351     0.777     0.200
     1.533     0.359     0.200
     1.574    -0.983     0.200
     2.932    -9.899     0.200
     3.106   -11.019     0.200
     3.252   -11.951     0.200
     3.291   -12.294     0.200
     3.331   -13.772     0.200
     3.331   -12.178     0.200
     3.603   -14.488     0.200
     3.666   -17.980     0.200
     3.776   -16.550     0.200
     3.800   -20.077     0.200
     3.800   -18.234     0.200
     3.871   -16.467     0.200
     3.878   -16.801     0.200
     3.910   -19.111     0.200
     4.380   -21.351     0.200
     4.444   -26.095     0.200
     4.536   -21.586     0.200
     4.658   -22.903     0.200
     4.648   -23.771     0.200
     4.851   -25.934     0.200
     4.834   -27.104     0.200
     5.020   -28.498     0.200
     5.035   -28.152     0.200
     5.035   -28.480     0.200
     5.169   -27.597     0.200
     5.257   -29.813     0.200
     5.331   -29.131     0.200
     5.331   -29.287     0.200
     5.358   -32.209     0.200
     5.417   -31.705     0.200
     5.417   -31.923     0.200
     5.614   -33.644     0.200
     5.779   -32.156     0.200
     5.802   -38.499     0.200
     5.819   -35.381     0.200
     5.873   -32.933     0.200
     5.873   -31.011     0.200
     5.898   -33.208     0.200
     5.926   -35.810     0.200
     5.955   -33.364     0.200
     5.959   -33.048     0.200
     6.008   -34.578     0.200
     6.008   -34.430     0.200
     6.075   -36.044     0.200
     6.103   -34.387     0.200
     6.116   -36.947     0.200
     6.337   -37.489     0.200
     6.429   -36.188     0.200
     6.448   -38.967     0.200
     6.483   -37.652     0.200
     6.498   -37.551     0.200
     6.540   -41.777     0.200
     6.728   -36.812     0.200
     6.903   -44.905     0.200
     6.905   -43.041     0.200
     6.924   -47.259     0.200
     6.975   -44.194     0.200
     7.037   -44.074     0.200
     7.037   -44.363     0.200
     7.126   -49.564     0.200
     7.211   -47.646     0.200
     7.213   -44.303     0.200
     7.282   -43.794     0.200
     7.290   -46.149     0.200
     7.331   -47.042     0.200
     7.419   -48.232     0.200
     7.425   -47.132     0.200
     7.499   -48.627     0.200
     7.554   -48.545     0.200
     7.554   -49.420     0.200
     7.599   -48.040     0.200
     7.733   -48.788     0.200
     7.797   -48.622     0.200
     7.880   -54.270     0.200
     7.995   -56.293     0.200
     8.138   -54.035     0.200
     8.144   -53.124     0.200
     8.229   -57.716     0.200
     8.332   -53.782     0.200
     8.458   -58.984     0.200
     8.606   -60.079     0.200
     8.796   -59.187     0.200
     9.231   -65.594     0.200
     9.285   -65.395     0.200
     9.402   -67.018     0.200
     9.522   -67.430     0.200
     9.584   -68.091     0.200
     9.597   -67.874     0.200
     9.629   -68.324     0.200
     9.795   -66.281     0.200
     9.811   -70.066     0.200
     9.887   -65.845     0.200
    10.111   -72.894     0.200
    10.249   -73.150     0.200
    10.265   -73.878     0.200
    10.236   -68.333     0.200
    10.476   -70.015     0.200
    10.652   -77.428     0.200
    10.675   -69.637     0.200
    10.716   -78.958     0.200
    10.791   -78.235     0.200
    10.816   -73.384     0.200
    10.882   -71.084     0.200
    10.961   -75.648     0.200
    11.041   -79.965     0.200
    11.444   -84.141     0.200
    11.750   -84.735     0.200
    11.934   -85.761     0.200
    12.507   -90.937     0.200
    12.796   -93.103     0.200
    12.858   -93.667     0.200
    13.850   -98.325     0.200
    14.119  -107.045     0.200
    14.327  -106.045     0.200
    15.300   -99.911     0.200
    17.914  -128.651     0.200
    20.469  -140.933     0.200
     2.360    -8.022     0.200
     2.941   -10.256     0.200
     2.941   -11.053     0.200
     3.054   -11.719     0.200
     3.113   -11.382     0.200
     3.190   -12.242     0.200
     3.256   -12.336     0.200
     3.302   -13.882     0.200
     3.337   -14.509     0.200
     3.337   -13.009     0.200
     3.611   -14.998     0.200
     3.677   -16.369     0.200
     3.877   -17.219     0.200
     3.886   -17.201     0.200
     3.923   -19.877     0.200
     4.009   -17.630     0.200
     4.052   -20.864     0.200
     4.398   -26.733     0.200
     4.372   -23.413     0.200
     4.406   -23.687     0.200
     4.535   -21.966     0.200
     4.728   -26.889     0.200
     4.872   -26.146     0.200
     4.842   -27.819     0.200
     5.034   -28.690     0.200
     5.266   -30.732     0.200
     5.264   -30.769     0.200
     5.367   -31.357     0.200
     5.496   -27.959     0.200
     5.627   -34.973     0.200
     5.750   -34.382     0.200
     5.799   -30.335     0.200
     5.809   -37.956     0.200
     5.785   -34.902     0.200
     5.892   -33.384     0.200
     5.920   -32.323     0.200
     5.974   -30.564     0.200
     5.978   -32.382     0.200
     5.933   -36.103     0.200
     6.030   -35.078     0.200
     6.030   -35.265     0.200
     6.080   -34.400     0.200
     6.092   -36.955     0.200
     6.122   -34.767     0.200
     6.138   -35.562     0.200
     6.255   -34.727     0.200
     6.330   -42.180     0.200
     6.260   -40.259     0.200
     6.356   -33.823     0.200
     6.447   -37.113     0.200
     6.469   -39.163     0.200
     6.501   -36.473     0.200
     6.501   -36.840     0.200
     6.515   -37.588     0.200
     6.560   -44.976     0.200
     6.561   -41.502     0.200
     6.746   -40.622     0.200
     6.914   -47.991     0.200
     6.926   -43.764     0.200
     7.002   -42.779     0.200
     6.997   -43.116     0.200
     6.997   -43.265     0.200
     7.058   -44.569     0.200
     7.058   -46.037     0.200
     7.132   -48.698     0.200
     7.179   -44.182     0.200
     7.219   -49.063     0.200
     7.233   -45.107     0.200
     7.303   -44.813     0.200
     7.311   -46.373     0.200
     7.311   -48.139     0.200
     7.352   -47.762     0.200
     7.352   -46.669     0.200
     7.405   -45.999     0.200
     7.441   -48.131     0.200
     7.440   -49.396     0.200
     7.451   -48.609     0.200
     7.386   -47.248     0.200
     7.515   -50.114     0.200
     7.576   -51.050     0.200
     7.620   -48.869     0.200
     7.752   -50.764     0.200
     7.893   -54.310     0.200
     8.002   -56.586     0.200
     8.005   -51.683     0.200
     8.165   -51.249     0.200
     8.244   -57.440     0.200
     8.353   -54.412     0.200
     8.474   -59.345     0.200
     8.464   -62.719     0.200
     8.621   -60.204     0.200
     8.903   -56.962     0.200
     9.242   -65.583     0.200
     9.300   -66.324     0.200
     9.416   -67.314     0.200
     9.434   -65.861     0.200
     9.534   -67.554     0.200
     9.599   -68.206     0.200
     9.607   -69.267     0.200
     9.641   -69.329     0.200
     9.665   -64.402     0.200
     9.903   -63.477     0.200
     9.903   -64.118     0.200
    10.260   -75.055     0.200
    10.236   -61.684     0.200
    10.224   -70.399     0.200
    10.626   -71.551     0.200
    10.668   -76.320     0.200
    10.664   -70.556     0.200
    10.692   -68.853     0.200
    10.807   -77.900     0.200
    10.849   -73.914     0.200
    10.899   -76.074     0.200
    10.977   -75.505     0.200
    11.057   -80.210     0.200
    11.446   -81.454     0.200
    11.759   -85.668     0.200
    12.519   -92.860     0.200
    12.808   -95.028     0.200
    12.869   -95.064     0.200
    14.129  -104.904     0.200
    16.698  -113.252     0.200
    17.931  -128.079     0.200
    18.519  -131.973     0.200
    18.891  -128.761     0.200
    19.104  -130.398     0.200
    19.112  -129.763     0.200
    19.296  -133.704     0.200
    20.062  -136.978     0.200
    20.476  -141.439     0.200
    20.476  -142.010     0.200
    20.658  -143.183     0.200
    22.584  -160.774     0.200
     3.069   -11.263     0.200
     3.127   -11.699     0.200
     3.204   -12.529     0.200
     3.272   -12.498     0.200
     3.313   -13.403     0.200
     3.352   -13.745     0.200
     3.352   -13.245     0.200
     3.625   -15.586     0.200
     3.688   -15.994     0.200
     3.892   -17.446     0.200
     3.900   -17.490     0.200
     3.932   -19.529     0.200
     4.064   -19.713     0.200
     4.379   -24.697     0.200
     4.415   -23.340     0.200
     4.553   -22.434     0.200
     4.793   -25.804     0.200
     4.856   -26.501     0.200
     5.042   -28.211     0.200
     5.278   -30.089     0.200
     5.430   -32.056     0.200
     5.513   -27.981     0.200
     5.797   -33.648     0.200
     5.877   -31.102     0.200
     5.946   -33.570     0.200
     5.959   -33.228     0.200
     5.947   -35.795     0.200
     6.019   -34.833     0.200
     6.484   -37.204     0.200
     6.895   -44.238     0.200
     6.915   -43.492     0.200
     6.987   -44.652     0.200
     7.304   -47.413     0.200
     7.340   -47.461     0.200
     7.873   -51.566     0.200
     8.456   -55.839     0.200
     8.603   -59.077     0.200
     9.223   -62.729     0.200
     9.281   -62.199     0.200
     9.515   -65.002     0.200
     9.580   -65.074     0.200
     2.344    -8.751     0.200
     2.925   -10.448     0.200
     3.035   -10.750     0.200
     3.095   -11.439     0.200
     3.173   -11.716     0.200
     3.238   -12.263     0.200
     3.286   -12.899     0.200
     3.319   -16.249     0.200
     3.319   -13.054     0.200
     3.594   -15.165     0.200
     3.661   -15.682     0.200
     3.868   -16.966     0.200
     3.909   -20.536     0.200
     4.035   -22.759     0.200
     4.360   -26.435     0.200
     4.515   -22.029     0.200
     4.684   -26.519     0.200
     4.713   -28.848     0.200
     4.766   -27.622     0.200
     4.879   -24.392     0.200
     4.898   -29.415     0.200
     5.021   -30.183     0.200
     5.250   -31.470     0.200
     5.245   -30.116     0.200
     5.359   -31.277     0.200
     5.359   -31.035     0.200
     5.351   -33.452     0.200
     5.476   -27.095     0.200
     5.808   -32.677     0.200
     5.768   -36.891     0.200
     5.902   -31.957     0.200
     5.902   -32.590     0.200
     5.926   -33.229     0.200
     5.916   -36.561     0.200
     5.975   -30.953     0.200
     5.985   -33.381     0.200
     5.990   -32.527     0.200
     6.034   -37.455     0.200
     6.034   -35.588     0.200
     6.088   -35.031     0.200
     6.106   -35.923     0.200
     6.133   -32.788     0.200
     6.139   -34.862     0.200
     6.266   -34.906     0.200
     6.368   -33.910     0.200
     6.460   -37.131     0.200
     6.465   -37.669     0.200
     6.514   -35.443     0.200
     6.529   -38.563     0.200
     6.560   -42.484     0.200
     6.925   -45.140     0.200
     6.953   -47.142     0.200
     7.001   -45.180     0.200
     7.063   -46.229     0.200
     7.063   -45.042     0.200
     7.229   -46.804     0.200
     7.312   -48.225     0.200
     7.357   -47.263     0.200
     7.447   -49.948     0.200
     7.456   -46.760     0.200
     7.465   -48.797     0.200
     7.530   -49.865     0.200
     7.625   -51.436     0.200
     7.746   -48.781     0.200
     7.910   -54.774     0.200
     8.152   -56.521     0.200
     8.164   -52.342     0.200
     8.259   -57.551     0.200
     8.397   -56.720     0.200
     8.457   -61.917     0.200
     8.489   -59.027     0.200
     8.637   -60.515     0.200
     9.068   -54.275     0.200
     9.260   -65.979     0.200
     9.315   -65.731     0.200
     9.432   -66.846     0.200
     9.552   -67.926     0.200
     9.615   -68.322     0.200
     9.659   -68.616     0.200
     9.917   -61.685     0.200
    10.139   -72.850     0.200
    10.278   -73.837     0.200
    10.206   -71.237     0.200
    10.705   -71.342     0.200
    10.822   -77.677     0.200
    11.072   -80.600     0.200
    15.313  -103.861     0.200
     2.340    -9.626     0.200
     3.315   -15.433     0.200
     3.904   -19.718     0.200
     4.031   -21.939     0.200
     4.387   -24.527     0.200
     4.682   -24.608     0.200
     4.762   -27.709     0.200
     5.902   -28.155     0.200
     5.911   -36.148     0.200
     5.976   -31.033     0.200
     5.990   -32.700     0.200
     5.985   -29.969     0.200
     6.033   -35.851     0.200
     6.133   -32.477     0.200
     6.368   -32.821     0.200
     6.515   -33.398     0.200
     6.934   -44.274     0.200
     6.955   -44.636     0.200
     8.260   -53.208     0.200
     8.490   -55.471     0.200
     8.638   -58.580     0.200
     9.554   -65.310     0.200
     2.336    -8.280     0.200
     2.917   -10.707     0.200
     3.030   -11.791     0.200
     3.089   -12.146     0.200
     3.166   -12.602     0.200
     3.233   -13.517     0.200
     3.278   -13.436     0.200
     3.314   -15.577     0.200
     3.314   -13.881     0.200
     3.587   -15.953     0.200
     3.653   -16.423     0.200
     3.853   -18.182     0.200
     3.862   -18.055     0.200
     3.899   -18.738     0.200
     4.028   -20.214     0.200
     4.382   -22.353     0.200
     4.671   -27.521     0.200
     4.704   -24.749     0.200
     4.758   -26.259     0.200
     4.818   -26.077     0.200
     4.836   -27.216     0.200
     4.867   -26.709     0.200
     5.347   -30.824     0.200
     5.796   -32.626     0.200
     5.892   -31.691     0.200
     5.913   -33.197     0.200
     5.909   -35.856     0.200
     5.944   -35.963     0.200
     5.965   -33.606     0.200
     5.974   -33.443     0.200
     5.979   -33.601     0.200
     6.022   -35.726     0.200
     6.122   -35.409     0.200
     6.126   -37.516     0.200
     6.357   -34.201     0.200
     6.505   -37.603     0.200
     6.927   -42.724     0.200
     6.948   -42.383     0.200
     7.904   -51.284     0.200
     8.251   -56.005     0.200
     8.480   -56.449     0.200
     8.629   -59.066     0.200
     9.255   -61.514     0.200
     9.307   -65.379     0.200
     9.425   -65.015     0.200
     9.546   -64.345     0.200
     9.607   -65.584     0.200
     9.620   -65.403     0.200
     9.645   -69.075     0.200
     9.653   -66.242     0.200
     9.834   -66.285     0.200
    10.135   -68.621     0.200
     1.521    -2.332     0.200
     4.635   -24.055     0.200
     4.801   -26.676     0.200
     4.829   -25.387     0.200
     5.310   -30.439     0.200
     5.758   -31.705     0.200
     5.798   -36.707     0.200
     5.853   -33.339     0.200
     5.876   -33.258     0.200
     5.927   -32.833     0.200
     5.935   -32.028     0.200
     5.940   -31.526     0.200
     5.985   -33.430     0.200
     6.084   -34.989     0.200
     6.092   -34.665     0.200
     6.319   -36.324     0.200
     6.466   -37.756     0.200
     6.894   -45.065     0.200
     6.915   -45.822     0.200
     7.204   -48.285     0.200
     8.214   -56.114     0.200
     8.442   -57.739     0.200
     8.592   -59.085     0.200
     9.222   -64.050     0.200
     9.270   -64.188     0.200
     9.389   -65.049     0.200
     9.512   -65.244     0.200
    12.848   -91.411     0.200
     1.977    -7.041     0.200
     2.739   -10.061     0.200
     2.930    -9.295     0.200
     3.045   -10.859     0.200
     3.103   -10.885     0.200
     3.265   -15.670     0.200
     3.248   -12.394     0.200
     3.289   -12.008     0.200
     3.328   -12.839     0.200
     3.601   -14.773     0.200
     3.868   -17.031     0.200
     3.875   -16.982     0.200
     3.909   -15.555     0.200
     4.530   -22.545     0.200
     4.664   -22.401     0.200
     4.831   -25.087     0.200
     4.830   -24.780     0.200
     4.858   -25.972     0.200
     5.030   -27.675     0.200
     5.254   -28.182     0.200
     5.338   -30.023     0.200
     5.422   -31.942     0.200
     5.785   -31.960     0.200
     5.879   -30.403     0.200
     5.905   -31.734     0.200
     5.923   -33.786     0.200
     5.952   -31.417     0.200
     5.962   -32.850     0.200
     5.967   -33.380     0.200
     6.110   -30.946     0.200
     6.121   -36.094     0.200
     6.491   -35.981     0.200
     6.910   -45.391     0.200
     8.236   -55.110     0.200
     8.465   -56.081     0.200
     8.613   -58.574     0.200
     9.238   -61.979     0.200
     9.529   -66.115     0.200
     9.636   -66.312     0.200
     9.802   -68.553     0.200
     1.235     1.888     0.200
     1.215     1.968     0.200
     1.327     2.541     0.200
     3.321   -14.199     0.200
     4.519   -22.363     0.200
     4.678   -25.200     0.200
     4.826   -25.710     0.200
     4.873   -27.085     0.200
     5.018   -27.272     0.200
     5.192   -26.556     0.200
     5.247   -29.655     0.200
     5.353   -30.352     0.200
     5.353   -27.484     0.200
     5.435   -32.582     0.200
     5.823   -32.394     0.200
     5.896   -32.742     0.200
     5.919   -32.534     0.200
     5.917   -34.992     0.200
     5.952   -36.312     0.200
     5.968   -32.243     0.200
     5.978   -32.665     0.200
     6.028   -35.087     0.200
     6.099   -34.753     0.200
     6.133   -37.279     0.200
     6.361   -34.381     0.200
     6.507   -37.288     0.200
     6.947   -42.719     0.200
     6.995   -44.860     0.200
     7.057   -45.998     0.200
     7.225   -45.449     0.200
     7.351   -49.140     0.200
     7.903   -50.351     0.200
     8.252   -54.814     0.200
     8.482   -56.288     0.200
     8.630   -57.981     0.200
     9.254   -60.454     0.200
     9.426   -63.909     0.200
     9.545   -62.599     0.200
     9.608   -63.188     0.200
     9.619   -63.740     0.200
     9.652   -65.190     0.200
     2.735   -10.023     0.200
     3.323   -13.872     0.200
     3.789   -18.032     0.200
     3.907   -16.667     0.200
     4.408   -25.251     0.200
     4.669   -26.993     0.200
     4.766   -25.103     0.200
     4.834   -26.808     0.200
     4.827   -25.651     0.200
     4.863   -26.429     0.200
     5.023   -27.455     0.200
     5.249   -29.325     0.200
     5.426   -32.049     0.200
     5.770   -33.718     0.200
     5.791   -32.298     0.200
     5.816   -36.783     0.200
     5.886   -32.726     0.200
     5.910   -32.557     0.200
     5.918   -34.339     0.200
     5.943   -34.159     0.200
     5.968   -33.493     0.200
     5.973   -33.388     0.200
     6.019   -35.109     0.200
     6.090   -35.058     0.200
     6.116   -35.231     0.200
     6.125   -36.937     0.200
     6.246   -38.030     0.200
     6.498   -36.712     0.200
     6.565   -43.146     0.200
     6.918   -46.512     0.200
     6.938   -45.573     0.200
     6.986   -44.786     0.200
     7.048   -45.012     0.200
     7.218   -45.040     0.200
     7.225   -49.144     0.200
     7.342   -46.861     0.200
     7.609   -48.740     0.200
     8.243   -54.933     0.200
     8.621   -57.597     0.200
     9.245   -64.506     0.200
     9.417   -65.033     0.200
     9.537   -65.540     0.200
     9.611   -65.188     0.200
     9.825   -68.072     0.200
     5.443   -31.233     0.200
     5.614   -31.552     0.200
     5.902   -32.895     0.200
     6.093   -33.621     0.200
     6.208   -37.841     0.200
     6.584   -35.309     0.200
     6.616   -38.616     0.200
     6.655   -37.018     0.200
     6.670   -38.187     0.200
     6.702   -35.925     0.200
     6.725   -40.590     0.200
     6.790   -39.950     0.200
     6.907   -41.574     0.200
     7.813   -48.805     0.200
     7.827   -50.233     0.200
     5.624   -31.542     0.200
     5.627   -32.100     0.200
     5.909   -32.636     0.200
     6.102   -36.311     0.200
     6.219   -39.056     0.200
     6.534   -36.881     0.200
     6.591   -35.929     0.200
     6.621   -37.043     0.200
     6.661   -37.334     0.200
     6.679   -40.513     0.200
     6.673   -35.927     0.200
     6.737   -42.172     0.200
     6.800   -40.128     0.200
     6.919   -43.078     0.200
     7.822   -49.313     0.200
     2.863   -10.383     0.200
     3.141   -12.778     0.200
     3.172   -12.467     0.200
     3.357   -14.253     0.200
     3.386   -14.559     0.200
     3.509   -15.568     0.200
     3.525   -15.671     0.200
     3.586   -16.180     0.200
     3.654   -16.051     0.200
     3.654   -16.750     0.200
     3.774   -17.666     0.200
     3.994   -18.828     0.200
     3.994   -19.328     0.200
     4.108   -18.440     0.200
     4.141   -20.378     0.200
     4.256   -21.334     0.200
     4.288   -20.341     0.200
     4.455   -21.641     0.200
     4.477   -21.554     0.200
     4.546   -23.232     0.200
     4.587   -21.262     0.200
     4.744   -24.310     0.200
     4.933   -26.100     0.200
     4.965   -26.903     0.200
     5.198   -28.009     0.200
     5.254   -27.872     0.200
     5.454   -29.358     0.200
     5.534   -29.863     0.200
     5.570   -30.279     0.200
     5.593   -32.427     0.200
     5.625   -31.195     0.200
     5.776   -32.512     0.200
     5.911   -32.828     0.200
     5.970   -35.186     0.200
     6.104   -36.049     0.200
     6.176   -37.186     0.200
     6.197   -36.265     0.200
     6.220   -37.301     0.200
     6.277   -36.304     0.200
     6.536   -37.066     0.200
     6.593   -34.914     0.200
     6.623   -38.948     0.200
     6.663   -38.721     0.200
     6.681   -38.687     0.200
     6.709   -36.282     0.200
     6.737   -40.057     0.200
     6.801   -41.715     0.200
     6.919   -42.562     0.200
     7.538   -48.788     0.200
     7.823   -49.166     0.200
     8.116   -52.308     0.200
     9.852   -66.329     0.200
     5.634   -32.458     0.200
     5.789   -34.076     0.200
     6.987   -39.821     0.200
     7.000   -41.414     0.200
     8.020   -50.379     0.200
     2.375    -8.903     0.200
     2.635   -10.539     0.200
     2.703   -11.312     0.200
     2.791   -12.501     0.200
     2.833   -11.525     0.200
     2.862   -12.353     0.200
     2.922   -12.528     0.200
     2.929   -11.765     0.200
     3.211   -15.290     0.200
     3.302   -16.085     0.200
     3.464   -17.811     0.200
     3.483   -17.319     0.200
     3.690   -18.943     0.200
     4.734   -27.416     0.200
     4.870   -28.798     0.200
     4.980   -29.070     0.200
     5.353   -31.353     0.200
     5.435   -34.336     0.200
     5.467   -32.354     0.200
     5.917   -37.139     0.200
     5.939   -36.803     0.200
     6.010   -36.893     0.200
     6.080   -35.349     0.200
     6.089   -38.116     0.200
     6.121   -38.109     0.200
     6.162   -36.761     0.200
     6.184   -35.909     0.200
     6.192   -37.824     0.200
     6.327   -37.647     0.200
     6.357   -38.846     0.200
     6.570   -40.119     0.200
     6.689   -43.361     0.200
     6.749   -41.578     0.200
     7.048   -47.245     0.200
     7.133   -47.245     0.200
     7.280   -49.488     0.200
     7.429   -49.519     0.200
     7.481   -48.951     0.200
     7.539   -51.739     0.200
     7.539   -50.209     0.200
     7.673   -51.437     0.200
     7.738   -49.101     0.200
     8.100   -51.682     0.200
     8.316   -55.339     0.200
     9.639   -65.780     0.200
     9.871   -70.724     0.200
     2.698    -9.776     0.200
     3.041   -10.134     0.200
     3.044   -11.135     0.200
     3.281   -12.241     0.200
     3.370   -12.855     0.200
     3.464   -13.152     0.200
     3.471   -14.180     0.200
     3.574   -15.520     0.200
     3.574   -13.920     0.200
     3.574   -13.500     0.200
     3.628   -14.931     0.200
     3.670   -14.871     0.200
     3.839   -18.627     0.200
     3.887   -17.555     0.200
     3.887   -16.055     0.200
     3.999   -18.204     0.200
     3.999   -17.104     0.200
     4.119   -20.399     0.200
     4.119   -18.699     0.200
     4.149   -20.050     0.200
     4.143   -17.223     0.200
     4.156   -18.064     0.200
     4.198   -20.823     0.200
     4.284   -22.429     0.200
     4.367   -21.956     0.200
     4.354   -21.946     0.200
     4.606   -23.650     0.200
     4.620   -21.400     0.200
     4.765   -25.588     0.200
     4.766   -25.131     0.200
     5.112   -28.569     0.200
     5.134   -26.389     0.200
     5.119   -27.491     0.200
     5.307   -27.953     0.200
     5.500   -31.390     0.200
     5.906   -32.129     0.200
     6.216   -32.749     0.200
     6.279   -33.481     0.200
     6.318   -34.031     0.200
     6.353   -34.554     0.200
     6.361   -32.428     0.200
     6.360   -34.337     0.200
     6.429   -34.870     0.200
     6.481   -36.429     0.200
     6.496   -34.204     0.200
     6.470   -40.643     0.200
     6.588   -39.678     0.200
     6.607   -37.977     0.200
     6.723   -38.579     0.200
     6.805   -39.574     0.200
     6.839   -36.687     0.200
     7.503   -45.165     0.200
     7.795   -49.050     0.200
     3.009   -10.834     0.200
     3.067   -11.281     0.200
     3.146   -12.362     0.200
     3.239   -12.641     0.200
     3.258   -13.037     0.200
     3.357   -13.675     0.200
     3.382   -14.368     0.200
     3.657   -15.485     0.200
     3.755   -16.988     0.200
     3.901   -18.314     0.200
     3.929   -19.443     0.200
     3.928   -17.669     0.200
     4.468   -22.479     0.200
     4.932   -24.111     0.200
     5.126   -28.308     0.200
     5.441   -30.535     0.200
     5.535   -30.038     0.200
     5.606   -31.311     0.200
     5.685   -31.265     0.200
     6.052   -35.645     0.200
     6.140   -34.119     0.200
     6.204   -33.982     0.200
     6.224   -35.655     0.200
     6.324   -38.861     0.200
     6.382   -36.811     0.200
     6.737   -39.093     0.200
     6.796   -43.087     0.200
     6.997   -44.630     0.200
     7.098   -41.161     0.200
     7.311   -48.437     0.200
     7.452   -46.190     0.200
     7.818   -53.205     0.200
    10.043   -69.099     0.200
     4.388   -21.611     0.200
     5.140   -27.588     0.200
     5.951   -33.246     0.200
     6.013   -32.050     0.200
     6.899   -44.894     0.200
     6.970   -44.057     0.200
     7.265   -47.783     0.200
     7.523   -49.772     0.200
     2.313    -9.153     0.200
     2.367    -8.972     0.200
     2.750   -10.560     0.200
     2.844   -12.559     0.200
     3.928   -19.317     0.200
     4.374   -20.251     0.200
     4.424   -21.165     0.200
     4.595   -22.834     0.200
     4.634   -22.431     0.200
     4.682   -22.801     0.200
     4.893   -25.913     0.200
     5.060   -26.302     0.200
     5.145   -28.073     0.200
     5.309   -26.492     0.200
     5.570   -32.679     0.200
     5.816   -32.072     0.200
     5.881   -34.045     0.200
     5.923   -33.272     0.200
     6.094   -35.824     0.200
     6.278   -36.576     0.200
     7.065   -42.261     0.200
     7.101   -44.711     0.200
     1.179     0.450     0.200
     2.118    -6.390     0.200
     2.333    -7.284     0.200
     3.872   -17.700     0.200
     4.850   -28.297     0.200
     5.025   -29.373     0.200
     5.026   -26.105     0.200
     5.062   -25.751     0.200
     5.454   -32.271     0.200
     5.503   -31.034     0.200
     5.624   -33.996     0.200
     5.624   -34.887     0.200
     5.940   -34.317     0.200
     6.012   -32.671     0.200
     6.063   -32.292     0.200
     6.090   -35.238     0.200
     6.094   -33.280     0.200
     6.149   -37.919     0.200
     6.173   -36.553     0.200
     6.197   -35.741     0.200
     6.197   -36.639     0.200
     6.233   -36.303     0.200
     6.325   -38.779     0.200
     6.368   -34.681     0.200
     6.463   -36.963     0.200
     6.524   -38.746     0.200
     6.545   -36.941     0.200
     6.590   -36.536     0.200
     6.675   -40.820     0.200
     6.759   -43.782     0.200
     6.939   -42.474     0.200
     7.032   -44.610     0.200
     7.125   -45.594     0.200
     7.166   -48.190     0.200
     7.220   -46.273     0.200
     7.220   -45.859     0.200
     7.501   -48.711     0.200
     7.503   -46.253     0.200
     7.513   -49.673     0.200
     7.592   -49.673     0.200
     7.658   -50.976     0.200
     7.767   -52.022     0.200
     7.767   -51.843     0.200
     7.789   -52.917     0.200
     7.916   -50.455     0.200
     7.963   -51.254     0.200
     8.017   -52.466     0.200
     8.291   -56.887     0.200
     8.300   -55.518     0.200
     8.332   -56.531     0.200
     8.362   -54.487     0.200
     8.531   -56.138     0.200
     8.545   -56.175     0.200
     8.545   -55.497     0.200
     8.675   -59.002     0.200
     8.982   -61.054     0.200
     9.029   -54.594     0.200
     9.246   -62.819     0.200
     9.356   -62.400     0.200
     9.460   -64.198     0.200
     9.551   -64.574     0.200
     9.648   -65.648     0.200
     9.688   -68.024     0.200
     9.721   -65.168     0.200
     9.980   -63.878     0.200
    10.219   -70.145     0.200
    10.779   -69.335     0.200
    10.973   -72.369     0.200
    11.121   -78.746     0.200
    15.531  -103.591     0.200
    16.920  -112.558     0.200
    18.510  -125.482     0.200
    18.510  -127.188     0.200
    18.568  -134.099     0.200
    19.066  -129.597     0.200
     1.263     0.969     0.200
     1.602    -0.976     0.200
     3.025   -11.790     0.200
     3.426   -12.426     0.200
     3.527   -16.722     0.200
     3.629   -15.936     0.200
     3.686   -16.795     0.200
     4.169   -18.797     0.200
     4.373   -23.298     0.200
     4.530   -25.489     0.200
     4.616   -26.663     0.200
     4.694   -26.078     0.200
     4.880   -26.363     0.200
     4.912   -25.530     0.200
     5.289   -29.625     0.200
     5.809   -33.142     0.200
     5.903   -33.073     0.200
     5.927   -32.409     0.200
     5.975   -31.986     0.200
     5.985   -32.304     0.200
     5.990   -32.567     0.200
     6.036   -34.794     0.200
     6.141   -35.669     0.200
     6.368   -36.454     0.200
     6.514   -37.907     0.200
     7.065   -44.735     0.200
     7.209   -44.203     0.200
     7.304   -40.866     0.200
     7.315   -44.902     0.200
     7.315   -44.690     0.200
     7.359   -47.602     0.200
     7.579   -49.136     0.200
     7.626   -47.979     0.200
     8.837   -49.059     0.200
    10.208   -70.187     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.580     0.554     0.200
     2.947    -7.982     0.200
     3.862   -10.493     0.200
     0.542     1.696     0.200
     2.943    -6.909     0.200
     4.941    -8.755     0.200
     8.882   -21.698     0.200
     0.450     1.213     0.200
     0.691     0.568     0.200
     2.042    -2.752     0.200
     2.499    -5.732     0.200
     4.196   -13.001     0.200
    10.562   -23.799     0.200
     3.631    -8.239     0.200
     2.135    -2.130     0.200
     8.845   -28.362     0.200
    10.281     8.136     0.200
     3.322   -11.300     0.200
     4.111   -12.912     0.200
     4.398   -16.800     0.200
     4.895   -11.547     0.200
     6.525   -25.215     0.200
     9.756   -23.655     0.200
    10.601   -30.441     0.200
     0.899     2.256     0.200
     2.992    -7.596     0.200
     4.125   -10.510     0.200
     4.193   -16.166     0.200
     0.615     2.767     0.200
     3.405   -11.190     0.200
     7.352   -24.836     0.200
     2.026     2.304     0.200
     2.212    -4.499     0.200
    10.318   -33.945     0.200
     0.664     2.727     0.200
     2.265    -2.048     0.200
     3.617   -10.096     0.200
     6.936   -21.098     0.200
     7.314   -25.094     0.200
     2.170     1.090     0.200
     2.070    -2.366     0.200
     2.787    -7.219     0.200
     3.326   -10.597     0.200
     3.222    -6.955     0.200
     3.399   -10.562     0.200
     9.798   -31.918     0.200
     0.701     2.728     0.200
     2.192    -2.039     0.200
     5.888   -10.689     0.200
     9.222   -28.889     0.200
     2.022    -3.364     0.200
     3.012    -5.275     0.200
     3.745    -7.006     0.200
     5.970   -13.519     0.200
     7.335   -14.301     0.200
     7.997   -18.787     0.200
     0.090     1.693     0.200
     1.225     0.702     0.200
     1.294     0.042     0.200
     2.134     2.386     0.200
     2.236    -2.843     0.200
     3.197    -6.293     0.200
     5.494   -19.400     0.200
     0.093     2.586     0.200
     1.289    -1.314     0.200
     2.168     0.820     0.200
     2.343    -1.740     0.200
     2.311    -2.733     0.200
     2.465    -4.617     0.200
     2.759    -7.912     0.200
     4.168   -11.692     0.200
     1.453     0.004     0.200
     1.260     0.855     0.200
     3.522   -12.552     0.200
     0.377     2.023     0.200
     0.760     1.388     0.200
     1.226    -0.826     0.200
     2.232     3.790     0.200
     2.254     6.135     0.200
     3.753   -11.919     0.200
     3.753    -6.318     0.200
     4.480   -11.684     0.200
     9.182   -30.017     0.200
     0.670     2.332     0.200
     1.862    -2.784     0.200
     0.205     1.589     0.200
     1.254     0.516     0.200
     1.710    -2.922     0.200
     1.918    -3.301     0.200
     2.015     1.600     0.200
     0.600     1.403     0.200
     1.531    -1.691     0.200
     1.453     1.355     0.200
     2.508    -6.666     0.200
     2.675    -8.265     0.200
     2.722    -8.469     0.200
     2.959   -10.282     0.200
     3.008   -10.711     0.200
     0.733     2.230     0.200
     1.189     2.090     0.200
     0.707     1.033     0.200
     1.886    -0.843     0.200
     1.363    -2.908     0.200
     1.913    -3.929     0.200
     1.366    -2.536     0.200
     9.321   -23.209     0.200
     0.349     2.440     0.200
     0.834     1.058     0.200
     9.832   -33.274     0.200
     0.332     3.087     0.200
     0.628     2.227     0.200
     3.833   -11.570     0.200
     0.661     2.108     0.200
     1.437    -1.511     0.200
     1.459    -2.206     0.200
     2.664    -8.179     0.200
     2.825    -9.598     0.200
     2.921   -10.237     0.200
     3.029   -10.974     0.200
     3.160   -11.709     0.200
     0.572     2.237     0.200
     1.052     0.738     0.200
     1.179     0.219     0.200
     1.619    -3.252     0.200
     1.727    -3.767     0.200
     1.995    -4.345     0.200
     4.655   -10.977     0.200
     6.021   -16.777     0.200
     9.693   -28.965     0.200
     0.310     2.826     0.200
     6.671   -20.629     0.200
     6.834   -14.502     0.200
     0.683     1.996     0.200
     0.335     2.664     0.200
     0.722     2.705     0.200
     1.738    -2.518     0.200
     3.100    -6.493     0.200
     7.567   -27.805     0.200
     8.565   -28.756     0.200
     0.162     0.036     0.200
     0.627     0.987     0.200
     0.685     0.942     0.200
     0.704     1.755     0.200
     0.786     2.059     0.200
     0.787     1.430     0.200
     0.895     1.310     0.200
     2.414    -5.564     0.200
     2.863    -7.574     0.200
     3.317    -8.634     0.200
     0.570     1.410     0.200
     0.629     0.636     0.200
     0.739     0.163     0.200
     1.575    -0.531     0.200
     0.190     0.131     0.200
     0.647     2.328     0.200
     0.731     0.858     0.200
     0.922     2.526     0.200
     2.390    -5.008     0.200
     2.551    -4.363     0.200
     2.837    -7.640     0.200
     3.290   -10.125     0.200
     0.176     1.986     0.200
     0.522     0.933     0.200
     0.669     1.753     0.200
     0.834     0.030     0.200
     0.935     0.722     0.200
     2.394    -6.982     0.200
     2.578    -7.558     0.200
     4.118    -6.752     0.200
     4.515   -18.358     0.200
     0.187     3.057     0.200
     0.255     3.797     0.200
     0.764     0.068     0.200
     0.780     0.966     0.200
     1.082    -0.015     0.200
     2.441    -2.341     0.200
     2.673    -7.275     0.200
     3.333    -9.514     0.200
     3.382    -8.379     0.200
     0.517     1.273     0.200
     0.499     1.993     0.200
     0.558     2.171     0.200
     0.732     2.144     0.200
     0.791     0.278     0.200
     0.840     2.588     0.200
     1.040     1.243     0.200
     0.448     1.533     0.200
     0.510     1.007     0.200
     1.189     1.099     0.200
     2.780    -7.529     0.200
     2.955    -8.139     0.200
     4.897    -8.003     0.200
     5.776   -10.065     0.200
     6.673   -13.899     0.200
     6.875   -14.389     0.200
     9.689   -25.519     0.200
     0.482     1.212     0.200
     0.485     1.719     0.200
     0.722     2.517     0.200
     0.759     1.761     0.200
     0.418     1.330     0.200
     0.528     1.303     0.200
     0.514     1.886     0.200
     0.546     1.698     0.200
     1.269    -0.097     0.200
     9.701   -30.430     0.200
     0.585     0.942     0.200
     0.735     2.787     0.200
     0.862     1.063     0.200
     9.681   -22.930     0.200
     0.518     1.990     0.200
     0.752     1.264     0.200
     0.810     1.871     0.200
     0.533     2.034     0.200
     0.806     2.338     0.200
     3.775   -10.856     0.200
     0.502     1.801     0.200
     0.573     1.398     0.200
     0.813     2.567     0.200
     1.049     1.221     0.200
     0.458     0.346     0.200
     0.488     2.215     0.200
     0.505     2.344     0.200
     0.570     0.818     0.200
     0.721     2.956     0.200
     0.800     1.692     0.200
     0.779     3.210     0.200
     0.835     2.294     0.200
     1.031     2.007     0.200
     1.169     0.782     0.200
     0.469     1.066     0.200
     0.492     1.150     0.200
     0.583     0.979     0.200
     1.017     0.819     0.200
     0.421     1.724     0.200
     4.007   -15.611     0.200
     4.502    -9.726     0.200
     5.799   -15.131     0.200
     6.899   -24.690     0.200
     9.706   -32.870     0.200
     0.391     0.878     0.200
     0.501     1.683     0.200
     0.573     0.694     0.200
     0.528     2.278     0.200
     0.766     1.485     0.200
     0.568     0.680     0.200
     0.525     1.637     0.200
     0.842     0.122     0.200
     0.502     0.540     0.200
     0.573     0.083     0.200
     0.847     1.796     0.200
     0.561     1.861     0.200
     0.771     2.922     0.200
     0.782     3.095     0.200
     1.463    -0.346     0.200
     1.676    -2.049     0.200
     0.509     0.911     0.200
     0.538     2.186     0.200
     0.566     3.205     0.200
     0.756     2.777     0.200
     0.774     3.012     0.200
     0.840     2.962     0.200
     0.516     1.686     0.200
     0.560     0.599     0.200
     0.777     1.699     0.200
     0.869     2.031     0.200
     1.079     0.320     0.200
     2.814    -7.334     0.200
     2.986    -8.173     0.200
     4.006   -11.511     0.200
     4.521   -10.873     0.200
     4.935   -11.902     0.200
     9.172   -29.816     0.200
     9.674   -29.317     0.200
     0.534     2.889     0.200
     0.550     1.512     0.200
     0.528     1.634     0.200
     0.766     2.871     0.200
     0.878     0.737     0.200
     0.800     3.439     0.200
     0.513     1.014     0.200
     0.522     1.688     0.200
     0.561     1.406     0.200
     1.185     0.470     0.200
     1.645    -3.448     0.200
     0.567     1.222     0.200
     0.549     2.159     0.200
     0.785     2.778     0.200
     0.839     1.510     0.200
     0.490     0.339     0.200
     0.584     2.282     0.200
     0.859     1.265     0.200
     3.019   -10.681     0.200
     3.940   -15.337     0.200
     9.694   -31.905     0.200
     0.507     0.837     0.200
     0.529     1.460     0.200
     0.820     1.533     0.200
     1.174     0.668     0.200
     1.634    -3.399     0.200
     3.788   -14.035     0.200
     0.530     3.206     0.200
     0.541     3.483     0.200
     0.782     1.282     0.200
     0.764     3.300     0.200
     0.865     2.106     0.200
     0.392     0.696     0.200
     0.499     1.701     0.200
     0.575     2.622     0.200
     0.743     1.661     0.200
     0.852     2.155     0.200
     0.849     1.920     0.200
     9.218   -30.670     0.200
     0.405     1.089     0.200
     0.516     1.101     0.200
     0.558     1.040     0.200
     0.752     2.200     0.200
     0.833     1.806     0.200
     0.394     0.999     0.200
     0.498     1.730     0.200
     0.850     2.232     0.200
     0.556     0.733     0.200
     0.518     3.015     0.200
     0.495     1.790     0.200
     0.787     2.244     0.200
     0.728     1.455     0.200
     0.793     1.972     0.200
     1.035     2.730     0.200
     0.492     1.993     0.200
     0.566     2.179     0.200
     0.724     1.893     0.200
     0.782     1.914     0.200
     0.837     2.052     0.200
     0.541     1.748     0.200
     0.574     1.802     0.200
     0.777     1.818     0.200
     1.075     1.431     0.200
     4.951    -6.610     0.200
     9.685   -32.265     0.200
     0.560     3.232     0.200
     0.756     2.320     0.200
     0.834     2.323     0.200
     3.802   -12.265     0.200
     4.520   -11.235     0.200
     0.425     1.356     0.200
     0.531     1.906     0.200
     0.544     1.366     0.200
     0.757     1.709     0.200
     0.817     2.489     0.200
     0.854     1.246     0.200
     1.061     1.356     0.200
     0.509     0.551     0.200
     0.461     2.994     0.200
     6.651   -23.693     0.200
     9.688   -33.963     0.200
     0.272     0.558     0.200
     0.401     1.045     0.200
     0.456     1.597     0.200
     0.514     1.177     0.200
     0.560     0.582     0.200
     0.561     0.176     0.200
     0.744     1.890     0.200
     0.829     1.489     0.200
     0.836     1.318     0.200
     1.127    -0.624     0.200
     1.954    -4.668     0.200
     0.425     0.114     0.200
     0.480     0.407     0.200
     0.533     1.202     0.200
     0.518     3.284     0.200
     0.548    -0.364     0.200
     0.542     1.667     0.200
     0.581     0.193     0.200
     0.773     2.474     0.200
     0.816     2.431     0.200
     6.622   -17.929     0.200
     7.484   -27.441     0.200
     0.253     1.600     0.200
     0.461     0.579     0.200
     0.502     0.782     0.200
     0.530     0.452     0.200
     0.534     1.176     0.200
     0.562     0.281     0.200
     0.816     0.662     0.200
     1.039     0.992     0.200
     0.196     1.297     0.200
     0.471     0.982     0.200
     0.472     1.613     0.200
     0.556     2.574     0.200
     0.602     1.164     0.200
     4.536   -12.485     0.200
     9.710   -32.188     0.200
     0.372     0.511     0.200
     0.465     1.107     0.200
     0.482     1.743     0.200
     0.521     1.023     0.200
     0.592     1.996     0.200
     0.845     2.836     0.200
     0.867     1.228     0.200
     0.487     1.292     0.200
     0.536     1.165     0.200
     0.523     1.171     0.200
     0.587     0.738     0.200
     0.862     0.760     0.200
     0.431     0.975     0.200
     0.485     1.136     0.200
     0.537     1.355     0.200
     0.554     0.897     0.200
     0.538     2.256     0.200
     0.811     2.530     0.200
     1.058     2.968     0.200
     0.317     1.300     0.200
     0.472     0.712     0.200
     0.457     1.787     0.200
     0.521     1.658     0.200
     0.617     1.898     0.200
     0.799     2.484     0.200
     0.891     1.815     0.200
     0.316     2.346     0.200
     0.466     1.626     0.200
     0.455     0.799     0.200
     0.506     0.036     0.200
     4.315   -13.346     0.200
     0.261     2.536     0.200
     0.467     1.948     0.200
     0.533     1.973     0.200
     0.839     1.660     0.200
     6.699   -15.376     0.200
     6.901   -24.774     0.200
     9.207   -33.268     0.200
     0.285     0.986     0.200
     0.585     0.708     0.200
     0.859     1.422     0.200
     1.202     0.370     0.200
     0.286     0.668     0.200
     0.491     0.907     0.200
     0.537     1.477     0.200
     0.583     1.291     0.200
     0.858     1.500     0.200
     0.478     1.678     0.200
     0.544     2.114     0.200
     0.597     2.080     0.200
     0.782     1.898     0.200
     0.297     1.238     0.200
     0.371     1.037     0.200
     0.604     2.718     0.200
     0.878     2.260     0.200
     1.099     2.181     0.200
     0.054     2.396     0.200
     0.246     1.519     0.200
     0.424     0.872     0.200
     0.515     1.996     0.200
     0.533     1.634     0.200
     0.542     1.548     0.200
     0.759     1.969     0.200
     0.070     2.517     0.200
     6.704     7.126     0.200
     6.906   -15.078     0.200
     9.703   -31.241     0.200
     0.366     0.256     0.200
     0.600     2.822     0.200
     2.209    -5.197     0.200
     2.403    -6.503     0.200
     2.465    -7.281     0.200
     2.674    -8.728     0.200
     2.688    -8.343     0.200
     0.234     2.329     0.200
     0.548     2.170     0.200
     0.505     1.439     0.200
     0.739     1.618     0.200
     2.397    -6.087     0.200
     0.253     3.063     0.200
     0.400     2.405     0.200
     0.564     1.899     0.200
     0.743     1.026     0.200
     0.903    -0.054     0.200
     1.185    -1.891     0.200
     0.030     2.265     0.200
     0.444     2.158     0.200
     0.444     2.642     0.200
     0.488     0.835     0.200
     0.464     1.509     0.200
     0.518     1.313     0.200
     0.560     3.077     0.200
     0.793     2.493     0.200
     2.786    -6.835     0.200
     2.964    -7.980     0.200
     3.043    -8.341     0.200
     3.245    -9.237     0.200
     3.333   -10.467     0.200
     0.155     3.165     0.200
     0.762     0.015     0.200
     0.819     0.525     0.200
     1.224    -1.029     0.200
     1.655    -2.872     0.200
     1.655    -2.583     0.200
     1.988    -5.154     0.200
     0.074     2.310     0.200
     0.418     2.999     0.200
     0.543     1.722     0.200
     1.073     1.732     0.200
     1.627    -2.028     0.200
     2.136    -1.249     0.200
     2.398    -5.333     0.200
     0.440     2.086     0.200
     0.563     0.990     0.200
     0.393     1.202     0.200
     0.435     1.591     0.200
     0.536     2.685     0.200
     0.583     1.901     0.200
     0.583     0.972     0.200
     0.678     0.683     0.200
     0.729     0.742     0.200
     0.748     1.836     0.200
     0.815     1.433     0.200
     0.973     1.333     0.200
     1.084     1.107     0.200
     3.286    -8.740     0.200
     3.400   -10.534     0.200
     0.238     2.614     0.200
     0.363     2.652     0.200
     0.515     0.520     0.200
     0.599     2.372     0.200
     0.625     0.545     0.200
     0.726     0.834     0.200
     0.772     1.492     0.200
     0.787     1.398     0.200
     0.782     1.273     0.200
     2.260    -5.887     0.200
     2.287    -4.778     0.200
     2.457    -6.707     0.200
     2.553    -7.514     0.200
     2.739    -8.647     0.200
     2.792    -8.887     0.200
     2.826    -9.931     0.200
     2.837   -10.110     0.200
     9.029   -27.318     0.200
     0.127     1.597     0.200
     0.177     0.711     0.200
     0.325     1.932     0.200
     0.351     1.306     0.200
     0.407     1.127     0.200
     0.075     3.594     0.200
     0.222     2.533     0.200
     0.304     2.937     0.200
     0.305     1.988     0.200
     0.392     1.231     0.200
     0.425     1.372     0.200
     0.410     2.170     0.200
     0.448    -0.151     0.200
     0.499     1.850     0.200
     0.467     1.456     0.200
     0.696     0.700     0.200
     0.691     1.852     0.200
     0.842     1.675     0.200
     1.640    -1.338     0.200
     2.442    -6.712     0.200
     0.143     5.061     0.200
     0.199     4.665     0.200
     2.081    -5.390     0.200
     2.269    -6.235     0.200
     2.342    -7.446     0.200
     2.543    -8.215     0.200
     2.628    -9.220     0.200
     2.628    -9.220     0.200
     2.645    -8.960     0.200
     0.261     3.916     0.200
     0.296     3.976     0.200
     0.374     2.128     0.200
     0.422     3.008     0.200
     0.532     2.818     0.200
     0.554     2.722     0.200
     0.562     1.855     0.200
     0.556     2.653     0.200
     0.623     1.936     0.200
     0.623     1.636     0.200
     0.626     1.430     0.200
     0.654     1.734     0.200
     0.803     0.905     0.200
     2.059    -3.198     0.200
     2.863    -8.886     0.200
     0.265     3.562     0.200
     0.299     3.692     0.200
     0.313     3.764     0.200
     0.374     4.033     0.200
     0.417     3.341     0.200
     0.534     2.643     0.200
     0.557     2.306     0.200
     0.558     2.878     0.200
     0.550     2.136     0.200
     0.616     1.938     0.200
     0.672     1.975     0.200
     0.658     1.827     0.200
     0.620     1.211     0.200
     0.697     1.591     0.200
     0.799     0.946     0.200
     0.833     0.759     0.200
     1.278    -1.338     0.200
     0.045     4.415     0.200
     0.167     3.727     0.200
     0.232     2.769     0.200
     0.244     2.905     0.200
     0.298     2.185     0.200
     0.328     1.431     0.200
     0.394     1.047     0.200
     0.382     2.336     0.200
     0.449     0.893     0.200
     0.663     1.610     0.200
     0.708     1.584     0.200
     0.817     1.435     0.200
     0.921     1.130     0.200
     1.183     0.032     0.200
     2.820    -9.348     0.200
     0.255     2.344     0.200
     0.298     2.882     0.200
     0.420     1.237     0.200
     0.539     1.653     0.200
     0.429     3.135     0.200
     0.454     2.540     0.200
     0.630     0.765     0.200
     0.697     1.349     0.200
     0.742     1.919     0.200
     0.781     1.188     0.200
     0.819     1.086     0.200
     0.810     1.049     0.200
     0.875     0.110     0.200
     0.856     1.517     0.200
     0.934     0.516     0.200
     1.344    -2.173     0.200
     2.384    -6.232     0.200
     2.649    -7.538     0.200
     2.712    -8.523     0.200
     2.795    -8.653     0.200
     2.837    -9.389     0.200
     2.851    -9.231     0.200
     2.885    -9.120     0.200
     2.934   -10.463     0.200
     2.934   -10.463     0.200
     0.218     2.564     0.200
     0.342     2.444     0.200
     0.366     2.782     0.200
     0.362     1.404     0.200
     0.532    -0.066     0.200
     0.604     1.450     0.200
     0.747     0.524     0.200
     0.747     1.504     0.200
     0.789     1.522     0.200
     0.780     0.473     0.200
     0.780     1.423     0.200
     0.800     1.314     0.200
     0.870     0.911     0.200
     0.980     1.021     0.200
     2.267    -5.684     0.200
     2.440    -6.645     0.200
     2.533    -7.197     0.200
     2.595    -8.076     0.200
     2.627    -8.090     0.200
     2.679    -8.326     0.200
     2.721    -9.067     0.200
     2.735    -9.106     0.200
     2.771    -9.240     0.200
     0.053     3.734     0.200
     0.256     2.619     0.200
     0.336     2.281     0.200
     0.314     2.161     0.200
     0.306     2.819     0.200
     0.426     1.634     0.200
     0.476     2.025     0.200
     0.540     1.703     0.200
     1.422    -0.642     0.200
     2.927    -6.958     0.200
     3.147    -8.831     0.200
     3.170    -9.475     0.200
     3.254    -9.418     0.200
     3.306   -10.369     0.200
     3.317   -10.234     0.200
     3.371   -10.829     0.200
     3.418   -11.526     0.200
     3.443   -11.214     0.200
     0.048     2.923     0.200
     0.116     0.826     0.200
     0.291     1.695     0.200
     0.261     2.549     0.200
     0.254     2.868     0.200
     0.370     1.473     0.200
     0.315     1.826     0.200
     0.343     2.846     0.200
     0.317     3.003     0.200
     0.423     1.016     0.200
     0.484     1.281     0.200
     0.551     1.652     0.200
     1.351     0.187     0.200
     2.662    -5.190     0.200
     2.941    -8.116     0.200
     2.970    -7.351     0.200
     3.161    -9.382     0.200
     3.268    -9.876     0.200
     3.319   -10.805     0.200
     3.331   -10.580     0.200
     3.457   -11.166     0.200
     0.039     2.979     0.200
     0.120     1.799     0.200
     0.312     2.010     0.200
     0.299     1.424     0.200
     0.256     2.572     0.200
     0.307     2.166     0.200
     0.375     0.427     0.200
     0.318     2.606     0.200
     0.412     0.940     0.200
     0.496     1.374     0.200
     0.564     1.525     0.200
     1.351    -0.022     0.200
     2.417    -5.419     0.200
     2.949    -7.894     0.200
     3.168    -9.234     0.200
     3.194   -10.355     0.200
     3.276   -10.250     0.200
     3.325   -10.913     0.200
     3.338   -10.613     0.200
     3.464   -11.320     0.200
     0.063     4.562     0.200
     0.173     3.184     0.200
     0.216     3.046     0.200
     0.228     2.237     0.200
     0.291     1.661     0.200
     0.321     2.005     0.200
     0.429     0.975     0.200
     0.394     2.600     0.200
     0.451     1.596     0.200
     0.504     1.785     0.200
     0.513     1.202     0.200
     0.766     0.699     0.200
     2.069    -5.400     0.200
     2.446    -6.964     0.200
     2.493    -6.381     0.200
     2.603    -7.211     0.200
     2.897    -9.353     0.200
     0.180     2.686     0.200
     0.289     1.204     0.200
     0.421     1.820     0.200
     0.507     0.605     0.200
     0.587     1.535     0.200
     0.990    -0.670     0.200
     1.130    -0.047     0.200
     1.851    -1.874     0.200
     2.421    -7.262     0.200
     9.968   -30.054     0.200
    10.060   -26.274     0.200
     0.176     2.028     0.200
     0.186     2.501     0.200
     0.181     2.573     0.200
     0.285     1.191     0.200
     0.300     1.451     0.200
     0.307     1.935     0.200
     0.385     0.993     0.200
     0.463     1.647     0.200
     0.521     1.126     0.200
     2.852    -5.311     0.200
     2.887    -8.932     0.200
     0.151     2.132     0.200
     0.196     2.279     0.200
     0.206     2.031     0.200
     0.284     1.418     0.200
     0.375     1.718     0.200
     0.385     1.900     0.200
     0.608     0.348     0.200
     1.872    -1.557     0.200
     2.900    -9.704     0.200
     0.144     2.160     0.200
     0.201     1.116     0.200
     0.213     1.968     0.200
     0.265     1.921     0.200
     0.337     2.278     0.200
     0.371     1.346     0.200
     0.387     1.965     0.200
     0.376     1.470     0.200
     0.679     1.795     0.200
     1.055     0.865     0.200
     1.993    -3.857     0.200
     2.334    -6.954     0.200
     0.046     3.282     0.200
     0.099     2.193     0.200
     0.192     1.867     0.200
     0.192     2.277     0.200
     0.174     2.481     0.200
     0.174     2.621     0.200
     0.204     2.340     0.200
     0.204     2.639     0.200
     0.285     2.217     0.200
     0.336     1.529     0.200
     0.336     0.519     0.200
     0.440     1.862     0.200
     0.780     0.019     0.200
     1.028     0.189     0.200
     1.742    -1.279     0.200
     0.043     3.775     0.200
     0.186     2.342     0.200
     0.177     2.387     0.200
     0.198     3.157     0.200
     0.318     1.642     0.200
     0.293     2.120     0.200
     1.835     0.028     0.200
     0.139     3.140     0.200
     0.143     2.652     0.200
     0.230     2.951     0.200
     0.257     2.754     0.200
     0.334     2.147     0.200
     0.345     1.831     0.200
     0.371     1.698     0.200
     0.401     1.469     0.200
     0.445     1.530     0.200
     0.461     1.756     0.200
     0.480     1.141     0.200
     0.481     1.762     0.200
     0.528     1.401     0.200
     0.610     1.989     0.200
     0.729     1.003     0.200
     0.070     3.056     0.200
     0.117     3.139     0.200
     0.324     1.423     0.200
     0.351     1.456     0.200
     0.365     1.222     0.200
     0.475     1.298     0.200
     0.495     1.249     0.200
     0.541     0.666     0.200
     0.613     0.935     0.200
     0.681     1.732     0.200
     0.704     1.131     0.200
     2.162     2.092     0.200
     2.337    -4.561     0.200
     9.702   -27.924     0.200
     0.182     2.428     0.200
     0.290     2.341     0.200
     0.356     2.161     0.200
     0.375     1.884     0.200
     0.423     2.301     0.200
     0.418     2.308     0.200
     0.603     1.394     0.200
     0.612     1.987     0.200
     0.631     2.469     0.200
     0.680     1.503     0.200
     0.701     2.388     0.200
     0.700     2.099     0.200
     0.743     2.229     0.200
     0.848     1.602     0.200
     0.903     0.565     0.200
     0.912     0.021     0.200
     2.432    -6.285     0.200
     2.618    -7.694     0.200
     2.689    -8.132     0.200
     2.760    -8.803     0.200
     2.851    -9.563     0.200
     2.885    -9.651     0.200
     2.894    -9.838     0.200
     2.911    -9.874     0.200
     2.977   -10.352     0.200
     2.992   -10.537     0.200
     0.290     2.511     0.200
     0.359     2.826     0.200
     0.431     1.905     0.200
     0.440     1.700     0.200
     0.419     2.693     0.200
     0.605     1.084     0.200
     0.620     0.655     0.200
     0.623     1.112     0.200
     0.648     0.934     0.200
     0.695     0.924     0.200
     0.714     1.307     0.200
     0.761     0.852     0.200
     0.865     0.995     0.200
     0.906     0.903     0.200
     0.920     0.471     0.200
     0.953     0.796     0.200
     0.958     0.994     0.200
     1.010     0.182     0.200
     1.109     0.061     0.200
     1.301    -0.738     0.200
     1.633    -1.231     0.200
     1.625    -0.260     0.200
     2.069    -1.905     0.200
     2.061    -3.950     0.200
     2.133    -4.790     0.200
     0.061     4.814     0.200
     0.186     2.481     0.200
     0.241     1.874     0.200
     0.223     2.763     0.200
     0.301     2.205     0.200
     0.314     0.855     0.200
     0.381     1.676     0.200
     0.423     1.492     0.200
     0.420     1.657     0.200
     0.476     1.124     0.200
     0.514     0.453     0.200
     0.524     1.267     0.200
     0.569     1.226     0.200
     0.604     0.794     0.200
     0.658     0.478     0.200
     0.726     0.621     0.200
     0.719     2.012     0.200
     0.728     1.635     0.200
     0.039     2.388     0.200
     0.194     1.559     0.200
     0.239     2.848     0.200
     0.250     1.482     0.200
     0.311     1.372     0.200
     0.332     0.407     0.200
     0.338     0.888     0.200
     0.355     1.280     0.200
     0.404     1.226     0.200
     0.399     2.780     0.200
     0.421     2.574     0.200
     0.480     2.401     0.200
     0.510     0.387     0.200
     0.614     1.451     0.200
     0.724     2.071     0.200
     0.852     2.035     0.200
     1.262     0.098     0.200
     1.975    -1.319     0.200
     0.029     2.690     0.200
     0.170     1.442     0.200
     0.222     1.894     0.200
     0.249     2.014     0.200
     0.295     1.467     0.200
     0.304     1.682     0.200
     0.338     1.694     0.200
     0.333     1.468     0.200
     0.390     1.431     0.200
     0.427     1.303     0.200
     0.453     0.654     0.200
     0.616     0.614     0.200
     0.733     1.004     0.200
     0.878     1.021     0.200
     0.990     0.237     0.200
     2.103    -4.931     0.200
     2.142    -5.698     0.200
     0.031     2.778     0.200
     0.244     1.708     0.200
     0.236     2.863     0.200
     0.303     1.953     0.200
     0.324     1.871     0.200
     0.355     1.397     0.200
     0.342     1.909     0.200
     0.406     2.277     0.200
     0.609     1.536     0.200
     2.081    -4.618     0.200
     0.044     2.511     0.200
     0.192     0.639     0.200
     0.251     0.516     0.200
     0.245     2.839     0.200
     0.316     1.524     0.200
     0.334     1.418     0.200
     0.397     2.761     0.200
     0.410     1.098     0.200
     0.621     1.027     0.200
     0.032     2.953     0.200
     0.196     1.354     0.200
     0.233     2.679     0.200
     0.248     1.495     0.200
     0.303     1.156     0.200
     0.327     1.483     0.200
     0.345     1.613     0.200
     0.359     1.569     0.200
     0.396     0.906     0.200
     0.403     2.283     0.200
     0.607     1.321     0.200
     0.857     1.285     0.200
     2.077    -4.771     0.200
     0.043     3.041     0.200
     0.169     2.195     0.200
     0.205     2.616     0.200
     0.246     1.785     0.200
     0.237     2.313     0.200
     0.314     1.458     0.200
     0.381     2.027     0.200
     0.453     1.544     0.200
     0.454     1.993     0.200
     0.528     1.074     0.200
     0.535     1.331     0.200
     0.522     1.358     0.200
     0.520     1.012     0.200
     0.520     1.720     0.200
     0.557     1.841     0.200
     0.624     0.516     0.200
     0.633     0.924     0.200
     0.668     0.710     0.200
     0.669     1.303     0.200
     0.663     1.354     0.200
     0.681     1.355     0.200
     0.709     2.023     0.200
     0.786     0.166     0.200
     0.889     0.720     0.200
     0.944     0.088     0.200
     1.181     0.060     0.200
     1.732    -3.063     0.200
     2.887    -8.573     0.200
     3.414    -5.926     0.200
     0.033     3.185     0.200
     0.151     2.347     0.200
     0.193     1.522     0.200
     0.236     3.130     0.200
     0.246     1.918     0.200
     0.305     1.463     0.200
     0.327     1.484     0.200
     0.341     2.000     0.200
     0.355     1.557     0.200
     0.404     2.228     0.200
     0.682     2.004     0.200
     2.079    -4.316     0.200
     2.118    -5.364     0.200
     3.530   -10.477     0.200
     0.135     3.144     0.200
     0.257     2.627     0.200
     0.249     2.626     0.200
     0.194     2.876     0.200
     0.330     2.784     0.200
     0.416     1.931     0.200
     0.501     0.937     0.200
     0.463     1.061     0.200
     0.561     1.539     0.200
     0.557     1.925     0.200
     0.487     1.737     0.200
     0.589     1.472     0.200
     0.568     1.310     0.200
     0.637     1.763     0.200
     0.771     0.582     0.200
     0.743     1.722     0.200
     0.764     1.876     0.200
     0.887    -0.052     0.200
     2.758    -8.938     0.200
     0.065     4.471     0.200
     0.173     3.292     0.200
     0.176     3.167     0.200
     0.234     2.344     0.200
     0.236     2.632     0.200
     0.304     2.427     0.200
     0.303     2.383     0.200
     0.368     2.625     0.200
     0.372     1.526     0.200
     0.455     2.195     0.200
     0.474     1.402     0.200
     0.489     0.458     0.200
     0.501     1.760     0.200
     0.574     0.989     0.200
     0.591     1.227     0.200
     0.620     0.733     0.200
     0.664     1.221     0.200
     0.721     1.571     0.200
     0.061     5.288     0.200
     0.164     3.557     0.200
     0.184     3.396     0.200
     0.227     2.649     0.200
     0.238     2.480     0.200
     0.300     2.819     0.200
     0.311     2.196     0.200
     0.373     1.802     0.200
     0.377     1.498     0.200
     0.419     1.856     0.200
     0.474     1.615     0.200
     0.464     1.635     0.200
     0.486     0.833     0.200
     0.527     0.818     0.200
     0.510     0.776     0.200
     0.569     1.095     0.200
     0.575     1.522     0.200
     0.601     0.701     0.200
     0.618     1.039     0.200
     0.712     0.176     0.200
     0.958     0.672     0.200
     0.921     1.231     0.200
     0.107     5.599     0.200
     0.196     3.882     0.200
     0.182     4.719     0.200
     0.325     3.887     0.200
     0.503     2.770     0.200
     0.669     1.583     0.200
     0.920     0.140     0.200
     0.861     0.206     0.200
     1.401    -2.472     0.200
     2.656    -7.332     0.200
     0.571     2.328     0.200
     0.761     0.816     0.200
     1.001     1.599     0.200
     1.003     1.836     0.200
     1.036     1.247     0.200
     0.082     3.267     0.200
     0.140     3.340     0.200
     0.207     2.427     0.200
     0.218     2.570     0.200
     0.306     1.530     0.200
     0.301     2.762     0.200
     0.344     1.466     0.200
     0.396     1.747     0.200
     0.337     2.079     0.200
     0.347     2.061     0.200
     0.420     1.717     0.200
     0.365     2.752     0.200
     0.402     1.887     0.200
     0.415     2.264     0.200
     0.476     1.842     0.200
     0.514     2.329     0.200
     0.689     1.330     0.200
     0.186     2.366     0.200
     0.231     2.861     0.200
     0.251     2.472     0.200
     0.454     1.362     0.200
     0.484     1.413     0.200
     0.534     1.685     0.200
     0.535     1.767     0.200
     0.678     1.962     0.200
     0.722     0.394     0.200
     0.913     0.015     0.200
     1.840    -4.534     0.200
     9.555   -33.666     0.200
     0.175     2.292     0.200
     0.206     2.722     0.200
     0.236     2.530     0.200
     0.260     1.994     0.200
     0.360     2.357     0.200
     0.468     1.235     0.200
     0.489     1.019     0.200
     0.528     0.782     0.200
     0.538     1.544     0.200
     0.533     0.363     0.200
     0.544     0.534     0.200
     0.566     1.078     0.200
     0.583     0.750     0.200
     0.631     0.939     0.200
     0.681     0.336     0.200
     0.681     1.195     0.200
     0.690     0.441     0.200
     0.717     0.291     0.200
     0.811     0.721     0.200
     0.912     0.041     0.200
     1.984    -3.343     0.200
     2.349    -6.024     0.200
     3.048   -10.001     0.200
     3.182   -10.532     0.200
     7.733   -22.492     0.200
     9.042     6.679     0.200
     9.540   -29.286     0.200
     0.189     2.149     0.200
     0.227     2.895     0.200
     0.185     2.559     0.200
     0.249     1.499     0.200
     0.341     2.872     0.200
     0.324     2.512     0.200
     0.447     1.813     0.200
     0.535     2.241     0.200
     0.531     1.760     0.200
     0.524     1.188     0.200
     0.531     1.153     0.200
     0.565     1.686     0.200
     0.610     1.538     0.200
     0.721     0.462     0.200
     0.721     0.243     0.200
     0.680     0.486     0.200
     0.680     1.306     0.200
     0.827     1.527     0.200
     1.837    -3.050     0.200
     1.974    -2.837     0.200
     4.373   -12.955     0.200
     8.005   -18.183     0.200
     9.561   -32.904     0.200
     0.171     2.081     0.200
     0.214     2.286     0.200
     0.200     2.412     0.200
     0.269     1.852     0.200
     0.341     1.861     0.200
     0.467     1.033     0.200
     0.453     1.759     0.200
     0.525     1.138     0.200
     0.562     0.894     0.200
     0.549     1.352     0.200
     0.619     1.402     0.200
     2.371    -6.533     0.200
     2.954    -9.603     0.200
     0.205     1.431     0.200
     0.178     2.908     0.200
     0.245     3.020     0.200
     0.231     2.043     0.200
     0.318     2.961     0.200
     0.349     2.412     0.200
     0.449     1.946     0.200
     0.495     1.170     0.200
     0.549     1.624     0.200
     0.574     1.112     0.200
     0.660     0.891     0.200
     0.740     0.869     0.200
     7.746   -20.383     0.200
     9.567   -30.011     0.200
     0.179     2.800     0.200
     0.249     2.007     0.200
     0.353     2.299     0.200
     0.320     3.073     0.200
     0.207     2.918     0.200
     0.229     2.299     0.200
     0.451     1.575     0.200
     0.500     1.155     0.200
     0.533     1.302     0.200
     0.509     1.410     0.200
     0.557     1.248     0.200
     0.508     0.201     0.200
     0.190     2.409     0.200
     0.236     1.993     0.200
     0.251     2.412     0.200
     0.331     3.556     0.200
     0.361     2.707     0.200
     0.462     1.529     0.200
     0.503     0.827     0.200
     0.510     0.486     0.200
     0.552     0.790     0.200
     0.555     1.282     0.200
     0.659     0.769     0.200
     0.740     0.309     0.200
     0.788     1.476     0.200
     0.859     0.820     0.200
     0.875    -0.273     0.200
     0.933    -0.202     0.200
     0.089     4.361     0.200
     0.128     3.634     0.200
     0.228     2.267     0.200
     0.270     2.127     0.200
     0.368     2.931     0.200
     0.383     1.548     0.200
     0.492     1.082     0.200
     0.524     1.558     0.200
     0.550     1.060     0.200
     0.533     0.897     0.200
     0.655     0.128     0.200
     0.680     0.822     0.200
     0.713     0.469     0.200
     0.810     0.496     0.200
     0.837     0.433     0.200
     0.910     0.319     0.200
     0.972    -0.137     0.200
     0.966    -0.133     0.200
     0.990    -0.490     0.200
     1.121    -0.542     0.200
     1.256    -1.122     0.200
     0.089     2.842     0.200
     0.113     3.256     0.200
     0.126     2.943     0.200
     0.199     2.046     0.200
     0.183     2.283     0.200
     0.253     2.058     0.200
     0.339     2.121     0.200
     0.358     1.223     0.200
     0.464     2.058     0.200
     0.491     1.520     0.200
     0.541     1.227     0.200
     0.541     1.963     0.200
     0.534     1.731     0.200
     0.527     0.426     0.200
     0.581     0.948     0.200
     0.685     1.043     0.200
     0.723     0.157     0.200
     0.860     0.561     0.200
     0.871     1.465     0.200
     0.962     1.370     0.200
     0.988     0.436     0.200
     1.022     1.056     0.200
     1.232    -0.383     0.200
     1.344     0.062     0.200
     1.437    -0.302     0.200
     1.624    -3.524     0.200
     0.087     2.519     0.200
     0.120     2.479     0.200
     0.117     2.468     0.200
     0.199     1.281     0.200
     0.184     2.547     0.200
     0.243     2.088     0.200
     0.237     1.873     0.200
     0.324     2.301     0.200
     0.453     1.816     0.200
     0.494     1.119     0.200
     0.515     1.012     0.200
     0.548     0.610     0.200
     0.516     1.440     0.200
     0.547     0.747     0.200
     0.675     0.581     0.200
     0.665     0.607     0.200
     0.675     0.971     0.200
     0.736    -0.230     0.200
     0.714     1.618     0.200
     0.794     1.360     0.200
     0.796     1.164     0.200
     0.859     1.244     0.200
     0.868    -0.126     0.200
     0.896    -0.115     0.200
     0.855     0.985     0.200
     0.927    -0.294     0.200
     0.943     0.463     0.200
     0.973    -0.748     0.200
     0.946     0.889     0.200
     0.090     2.810     0.200
     0.114     3.069     0.200
     0.120     2.830     0.200
     0.190     1.804     0.200
     0.194     1.762     0.200
     0.242     2.379     0.200
     0.245     2.000     0.200
     0.357     3.097     0.200
     0.461     1.632     0.200
     0.494     1.437     0.200
     0.521     0.309     0.200
     0.541     1.395     0.200
     0.545     1.848     0.200
     0.068     2.791     0.200
     0.142     1.511     0.200
     0.134     2.299     0.200
     0.148     2.495     0.200
     0.187     2.121     0.200
     0.207     2.036     0.200
     0.249     1.475     0.200
     0.331     1.794     0.200
     0.337     1.496     0.200
     0.332     1.792     0.200
     0.333     2.431     0.200
     0.371     2.357     0.200
     0.364     1.074     0.200
     0.379     1.669     0.200
     0.353     2.265     0.200
     0.375     1.232     0.200
     0.464     1.488     0.200
     0.432     0.785     0.200
     0.443     0.889     0.200
     0.478     0.860     0.200
     0.491     1.394     0.200
     0.477     1.759     0.200
     0.516     1.663     0.200
     0.600     2.042     0.200
     0.080     1.970     0.200
     0.135     2.286     0.200
     0.133     2.276     0.200
     0.188     1.241     0.200
     0.198     1.794     0.200
     0.346     1.181     0.200
     0.351     1.435     0.200
     0.325     2.307     0.200
     0.325     2.495     0.200
     0.332     2.299     0.200
     0.345     2.445     0.200
     0.368     1.565     0.200
     0.352     1.464     0.200
     0.373     1.939     0.200
     0.365     1.694     0.200
     0.451     0.927     0.200
     0.419     0.967     0.200
     0.462     2.176     0.200
     0.529     0.702     0.200
     0.081     2.247     0.200
     0.141     2.365     0.200
     0.200     1.530     0.200
     0.122     2.943     0.200
     0.213     1.452     0.200
     0.251     1.627     0.200
     0.341     1.073     0.200
     0.366     1.235     0.200
     0.388     1.438     0.200
     0.380     1.185     0.200
     0.318     2.363     0.200
     0.318     2.313     0.200
     0.325     2.077     0.200
     0.339     2.246     0.200
     0.433     0.869     0.200
     0.436     1.084     0.200
     0.478     0.846     0.200
     0.081     3.290     0.200
     0.125     2.604     0.200
     0.148     1.775     0.200
     0.197     1.946     0.200
     0.209     2.480     0.200
     0.248     1.634     0.200
     0.302     2.092     0.200
     0.344     0.880     0.200
     0.319     3.451     0.200
     0.320     2.335     0.200
     0.327     2.909     0.200
     0.363     2.557     0.200
     0.363     1.898     0.200
     0.378     2.625     0.200
     0.376     2.022     0.200
     0.384     2.204     0.200
     0.440     1.534     0.200
     0.430     1.159     0.200
     0.474     2.953     0.200
     0.042     2.589     0.200
     0.082     2.253     0.200
     0.090     1.756     0.200
     0.095     1.938     0.200
     0.113     1.266     0.200
     0.135     1.713     0.200
     0.169     2.311     0.200
     0.210     2.430     0.200
     0.250     2.635     0.200
     0.261     1.383     0.200
     0.314     1.298     0.200
     0.312     2.677     0.200
     0.341     0.947     0.200
     0.387     1.777     0.200
     0.470     1.668     0.200
     3.448    -6.698     0.200
     0.111     4.658     0.200
     0.156     3.742     0.200
     0.186     3.587     0.200
     0.203     3.648     0.200
     0.209     3.250     0.200
     0.242     2.414     0.200
     0.253     2.748     0.200
     0.253     3.179     0.200
     0.384     2.727     0.200
     0.441     1.319     0.200
     0.574     2.581     0.200
     0.677     0.839     0.200
     0.746     0.952     0.200
     0.749     2.136     0.200
     0.764     1.455     0.200
     1.010    -0.065     0.200
     1.517    -0.918     0.200
     2.557    -5.960     0.200
     3.204   -10.002     0.200
     0.030     2.727     0.200
     0.115     0.532     0.200
     0.183     2.150     0.200
     0.180     1.363     0.200
     0.195     1.493     0.200
     0.228     0.854     0.200
     0.332     2.256     0.200
     0.353     1.863     0.200
     0.514     1.559     0.200
     0.512     2.547     0.200
     0.070     4.823     0.200
     0.213     2.612     0.200
     0.225     1.925     0.200
     0.230     2.471     0.200
     0.234     2.138     0.200
     0.290     2.758     0.200
     0.314     2.297     0.200
     0.322     2.149     0.200
     0.324     1.083     0.200
     0.330     2.401     0.200
     0.337     2.280     0.200
     0.352     0.900     0.200
     0.370     1.305     0.200
     0.364     1.799     0.200
     0.416     2.266     0.200
     0.411     2.929     0.200
     0.435     0.757     0.200
     0.446     1.606     0.200
     0.462     1.108     0.200
     0.459     2.266     0.200
     0.485     1.078     0.200
     0.515     0.517     0.200
     0.531     1.514     0.200
     0.524     0.729     0.200
     0.534     0.436     0.200
     0.535    -0.322     0.200
     0.570     1.080     0.200
     0.563     2.547     0.200
     0.580     0.175     0.200
     0.570     2.190     0.200
     0.600     1.442     0.200
     0.611     1.997     0.200
     0.658     0.687     0.200
     0.650     1.507     0.200
     0.653     0.762     0.200
     0.654     1.824     0.200
     0.679     1.435     0.200
     0.710     1.854     0.200
     0.706     1.277     0.200
     0.698     1.134     0.200
     0.771     1.117     0.200
     0.819     1.345     0.200
     0.821    -0.189     0.200
     0.825     1.411     0.200
     0.829     1.557     0.200
     2.817    -9.337     0.200
     9.815   -25.887     0.200
     0.135     1.893     0.200
     0.170     2.291     0.200
     0.170     1.507     0.200
     0.209     2.081     0.200
     0.241     2.171     0.200
     0.344     1.709     0.200
     0.383     0.982     0.200
     0.406     0.550     0.200
     0.442     1.516     0.200
     0.474     1.585     0.200
     0.102     2.874     0.200
     0.234     0.985     0.200
     0.296     2.034     0.200
     0.315     1.322     0.200
     0.331     1.412     0.200
     0.340     1.050     0.200
     0.364     1.479     0.200
     0.404     2.102     0.200
     0.404     1.724     0.200
     0.409     1.862     0.200
     0.405     1.184     0.200
     0.424     1.486     0.200
     0.424     1.586     0.200
     0.462     1.356     0.200
     0.484     0.870     0.200
     0.500     0.452     0.200
     0.503     1.353     0.200
     0.509     1.085     0.200
     0.523     1.536     0.200
     0.588     1.385     0.200
     0.658     0.457     0.200
     0.691     0.200     0.200
     1.117     0.779     0.200
     2.330    -5.658     0.200
     0.169     3.511     0.200
     0.233     3.295     0.200
     0.226     3.615     0.200
     0.237     2.681     0.200
     0.242     2.911     0.200
     0.270     2.522     0.200
     0.262     1.690     0.200
     0.310     2.760     0.200
     0.339     2.147     0.200
     0.353     0.994     0.200
     0.397     1.999     0.200
     0.406     1.902     0.200
     0.413     1.186     0.200
     0.461     2.377     0.200
     0.513     1.834     0.200
     0.518     0.959     0.200
     0.537     1.577     0.200
     0.533     1.891     0.200
     0.632     0.586     0.200
     0.646     0.194     0.200
     0.654     0.449     0.200
     0.678     0.595     0.200
     0.705     1.048     0.200
     0.705     0.934     0.200
     0.706     0.603     0.200
     0.803     0.716     0.200
     0.803     2.107     0.200
     1.288    -0.721     0.200
     1.998    -1.146     0.200
     2.667    -8.548     0.200
     3.281    -9.300     0.200
     4.180   -14.972     0.200
     9.721   -28.168     0.200
     0.076     2.766     0.200
     0.049     3.924     0.200
     0.094     3.185     0.200
     0.094     3.405     0.200
     0.177     2.784     0.200
     0.177     2.554     0.200
     0.231     2.273     0.200
     0.231     1.644     0.200
     0.233     2.681     0.200
     0.240     2.168     0.200
     0.317     3.346     0.200
     0.317     2.186     0.200
     0.317     2.346     0.200
     0.345     2.937     0.200
     0.363     1.074     0.200
     0.363     0.684     0.200
     0.412     1.827     0.200
     0.445     2.361     0.200
     0.474     1.918     0.200
     0.491     1.227     0.200
     0.515     0.755     0.200
     0.515     1.475     0.200
     0.509     3.152     0.200
     0.509     2.202     0.200
     0.551     1.116     0.200
     0.544     1.521     0.200
     0.568     2.078     0.200
     0.568     0.638     0.200
     0.570     1.413     0.200
     0.605     1.604     0.200
     0.626     2.324     0.200
     0.664     0.563     0.200
     0.664     1.023     0.200
     0.737     0.582     0.200
     0.737     0.421     0.200
     0.746     1.036     0.200
     0.750     0.621     0.200
     0.793     1.431     0.200
     1.822    -3.909     0.200
     1.899    -0.453     0.200
     1.958    -2.733     0.200
     2.559    -3.901     0.200
EOF
gmt end
