#!/bin/bash
gmt begin larino1.84_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional larino1.84'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    42.199
    14.500    41.921
    15.000    41.642
    15.500    41.361
    16.000    41.076
    16.500    40.787
    17.000    40.490
    17.500    40.185
    18.000    39.869
    18.500    39.541
    19.000    39.199
    19.500    38.839
    20.000    38.461
    20.500    38.061
    21.000    37.637
    21.500    37.187
    22.000    36.709
    22.500    36.202
    23.000    35.663
    23.500    35.090
    24.000    33.838
    24.500    32.566
    25.000    31.284
    25.500    29.992
    26.000    28.688
    26.500    27.373
    27.000    26.046
    27.500    24.702
    28.000    23.338
    28.500    21.958
    29.000    20.568
    29.500    19.169
    30.000    17.762
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    20.338 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     8.068
     1.500     9.102
     2.000    10.136
     2.500    11.170
     3.000    12.204
     3.500    13.237
     4.000    14.269
     4.500    15.300
     5.000    16.330
     5.500    17.358
     6.000    18.385
     6.500    19.410
     7.000    20.434
     7.500    21.455
     8.000    22.474
     8.500    23.491
     9.000    24.506
     9.500    25.518
    10.000    26.527
    10.500    27.533
    11.000    28.536
    11.500    29.536
    12.000    30.532
    12.500    31.526
    13.000    32.515
    13.500    33.500
    14.000    34.482
    14.500    35.460
    15.000    36.261
    15.500    36.973
    16.000    37.626
    16.500    38.157
    17.000    38.621
    17.500    39.089
    18.000    39.432
    18.500    39.716
    19.000    39.943
    19.500    40.112
    20.000    40.223
    20.500    40.274
    21.000    40.265
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    29.515 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.677
     1.000     5.998
     1.500     8.318
     2.000    10.638
     2.500    12.959
     3.000    15.278
     3.500    17.597
     4.000    19.914
     4.500    22.230
     5.000    24.545
     5.500    26.859
     6.000    29.171
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    22.545 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    23.003
     1.500    29.174
     2.000    35.344
     2.500    41.515
     3.000    47.686
     3.500    53.857
     4.000    60.024
     4.500    66.191
     5.000    72.355
     5.500    78.519
     6.000    84.680
     6.500    90.839
     7.000    96.994
     7.500   103.147
     8.000   109.298
     8.500   115.444
     9.000   121.588
     9.500   127.728
    10.000   133.863
    10.500   139.995
    11.000   146.122
    11.500   152.245
    12.000   158.362
    12.500   164.475
    13.000   170.582
    13.500   176.684
    14.000   182.780
    14.500   188.869
    15.000   194.954
    15.500   201.031
    16.000   207.101
    16.500   213.165
    17.000   219.221
    17.500   233.592
    18.000   239.863
    18.500   246.120
    19.000   252.365
    19.500   258.597
    20.000   264.814
    20.500   271.017
    21.000   277.205
    21.500   283.378
    22.000   289.536
    22.500   295.677
    23.000   301.802
    23.500   307.910
    24.000   314.001
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    58.024 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.075
     1.000    19.460
     1.500    27.844
     2.000    36.228
     2.500    44.613
     3.000    52.996
     3.500    61.377
     4.000    69.757
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    59.377 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    18.218   253.013     0.150
    20.013    54.070     0.150
    20.513   287.232     0.150
    20.636   286.800     0.150
    20.869    56.075     0.150
    21.120   285.143     0.150
    23.380   292.770     0.150
    23.631   294.639     0.150
    24.482   298.908     0.150
    19.411   266.234     0.150
    21.156   295.870     0.150
    20.644    51.129     0.150
    11.504   286.462     0.150
    18.741    53.014     0.150
    20.266    53.215     0.150
    21.151    58.887     0.150
    23.934   298.404     0.150
    24.196   297.553     0.150
    24.488   296.940     0.150
    19.935    52.400     0.150
     7.119    25.150     0.150
     8.851    29.441     0.150
     3.002    74.447     0.150
     3.086    74.576     0.150
    19.668    50.264     0.150
    21.218    60.470     0.150
     3.054    74.106     0.150
     3.135    74.052     0.150
     6.920    21.982     0.150
     7.014    22.681     0.150
    20.714   269.511     0.150
    21.689    63.035     0.150
     6.966    25.201     0.150
     7.059    22.714     0.150
    16.972   244.975     0.150
    17.434    46.386     0.150
    18.065    48.495     0.150
    18.342    48.982     0.150
    18.342   252.982     0.150
    18.430   251.393     0.150
    18.591   261.082     0.150
    19.917   273.903     0.150
    20.409   266.365     0.150
    20.451    54.674     0.150
    20.451   263.475     0.150
    20.451   294.577     0.150
    20.687    58.217     0.150
    20.734    57.667     0.150
    20.734   271.667     0.150
    21.459   276.206     0.150
    22.925   281.425     0.150
    24.062    62.832     0.150
    24.062   289.332     0.150
    24.062   337.332     0.150
    27.801   309.200     0.150
    28.331   305.120     0.150
     9.651    31.280     0.150
    11.359    35.145     0.150
    16.949   229.900     0.150
    18.278   249.959     0.150
    18.445   249.455     0.150
    18.567   248.016     0.150
    18.567   248.907     0.150
    18.805   250.492     0.150
    18.805   250.664     0.150
    19.505   255.927     0.150
    19.911   274.935     0.150
    20.478   261.725     0.150
    20.499    57.383     0.150
    20.499   267.684     0.150
    20.499   288.082     0.150
    20.762   299.007     0.150
    20.916   265.236     0.150
    21.486   274.554     0.150
    23.876   289.669     0.150
    20.534    54.281     0.150
    21.514   278.761     0.150
    21.514   306.761     0.150
    28.363   305.431     0.150
    14.941   227.675     0.150
    15.442   223.503     0.150
    15.968   227.424     0.150
    15.979   239.385     0.150
    16.122   226.877     0.150
    16.430   239.348     0.150
    16.810   239.116     0.150
    17.406   241.994     0.150
    17.460   251.542     0.150
    18.733   250.506     0.150
    19.037    49.059     0.150
    19.604   251.444     0.150
    19.773   295.704     0.150
    19.996   261.170     0.150
    20.007   261.550     0.150
    20.856    55.039     0.150
    20.856   268.738     0.150
    21.122   268.031     0.150
    23.180    63.313     0.150
    23.180   267.716     0.150
    23.180   292.415     0.150
    28.794   210.439     0.150
    24.569   292.802     0.150
    15.313    46.337     0.150
    15.313   223.009     0.150
    18.347   251.620     0.150
    15.300    44.182     0.150
    15.300   221.011     0.150
    16.926   244.704     0.150
    17.076    45.400     0.150
    17.193    46.489     0.150
    17.200   247.411     0.150
    17.924    46.464     0.150
    17.924   246.964     0.150
    18.283    46.877     0.150
    18.344   247.558     0.150
    20.319   263.802     0.150
    20.760   287.362     0.150
    24.064   285.903     0.150
    28.298   215.296     0.150
    16.397   236.035     0.150
    16.926   239.962     0.150
    17.042   243.210     0.150
    17.201   244.348     0.150
    17.919   241.866     0.150
    18.134   245.898     0.150
    18.140   243.629     0.150
    18.370   250.432     0.150
    18.351   248.330     0.150
    18.403   248.711     0.150
    18.554   248.851     0.150
    18.648   250.357     0.150
    18.802   254.709     0.150
    19.036   253.615     0.150
    19.042   252.675     0.150
    19.293   256.974     0.150
    19.472   260.650     0.150
    20.204   263.977     0.150
    20.283   251.380     0.150
    20.337    54.352     0.150
    20.535   268.265     0.150
    20.635   265.679     0.150
    20.781   286.465     0.150
    21.218   274.440     0.150
    21.623   277.585     0.150
    22.798   283.496     0.150
    24.071   286.379     0.150
    24.388   297.550     0.150
    24.570   296.632     0.150
    25.604   299.416     0.150
    26.155   303.204     0.150
    26.365   302.250     0.150
    27.600   307.917     0.150
    27.692   308.027     0.150
    28.320   310.661     0.150
    28.320   214.833     0.150
    29.325   317.138     0.150
    17.055    44.471     0.150
    18.127    45.517     0.150
    18.333   248.821     0.150
    20.780   285.915     0.150
    24.053   287.863     0.150
    28.321   214.339     0.150
    17.108    45.119     0.150
    17.454    45.408     0.150
    17.996    48.266     0.150
    24.230   285.118     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    22.931    36.338     0.200
    24.261    32.820     0.200
    22.948    36.767     0.200
    24.284    33.475     0.200
    20.354    39.078     0.200
    22.832    35.554     0.200
    20.393    38.470     0.200
    22.836    38.056     0.200
    24.477    33.607     0.200
    22.518    40.252     0.200
    22.864    37.012     0.200
    24.160    33.097     0.200
    26.974    25.250     0.200
    14.850    46.320     0.200
    20.390    37.461     0.200
    21.120    37.143     0.200
    21.515    41.541     0.200
    22.841    37.061     0.200
    23.191    36.075     0.200
    23.380    37.770     0.200
    23.928    36.372     0.200
    23.992    36.632     0.200
    24.482    32.908     0.200
    27.197    27.222     0.200
    20.092    39.278     0.200
    20.092    39.579     0.200
    22.793    40.447     0.200
    20.255    37.372     0.200
    18.990    39.612     0.200
    23.088    36.694     0.200
    20.551    36.930     0.200
    21.156    37.870     0.200
    21.119    40.601     0.200
    22.880    34.958     0.200
    23.231    34.853     0.200
    24.521    32.606     0.200
    27.238    25.200     0.200
    22.976    35.346     0.200
    18.227    43.530     0.200
    18.227    43.929     0.200
    20.644    41.536     0.200
    21.083    38.204     0.200
    21.131    42.045     0.200
    22.798    36.188     0.200
    23.144    34.251     0.200
    24.013    40.007     0.200
    24.440    32.033     0.200
    16.051    41.264     0.200
    20.550    37.771     0.200
    20.930    36.331     0.200
    22.877    35.605     0.200
    23.218    35.325     0.200
    24.519    31.449     0.200
    20.438    36.942     0.200
    23.256    34.960     0.200
    17.543    41.987     0.200
    18.970    39.944     0.200
    19.194    39.719     0.200
    19.597    40.118     0.200
    20.521    38.233     0.200
    21.151    40.887     0.200
    21.151    41.688     0.200
    21.663    42.516     0.200
    23.119    36.226     0.200
    24.196    39.354     0.200
    24.196    40.155     0.200
    24.488    34.541     0.200
    24.567    36.018     0.200
    26.462    32.906     0.200
    27.110    26.343     0.200
    18.365    41.232     0.200
    21.738    42.369     0.200
    22.256    36.323     0.200
    22.488    36.718     0.200
    23.899    34.143     0.200
    26.656    29.969     0.200
    21.790    34.399     0.200
    23.432    31.634     0.200
    19.305    36.960     0.200
    21.939    34.013     0.200
    23.581    33.853     0.200
    18.610    37.591     0.200
    20.965    36.874     0.200
    18.409    37.975     0.200
    18.417    36.672     0.200
    20.632    36.729     0.200
    28.264    20.158     0.200
    20.618    37.147     0.200
    28.251    20.768     0.200
    18.194    40.801     0.200
    19.519    39.944     0.200
    18.170    40.041     0.200
    19.156    38.931     0.200
    19.384    37.769     0.200
    19.384    36.871     0.200
    19.482    38.429     0.200
    19.482    38.429     0.200
    20.800    36.743     0.200
    21.218    43.470     0.200
    21.460    36.244     0.200
    28.376    20.136     0.200
    19.461    40.327     0.200
    19.904    39.858     0.200
    20.098    39.991     0.200
    21.235    39.124     0.200
    21.689    41.035     0.200
    21.893    36.552     0.200
    21.345    39.971     0.200
    19.500    39.827     0.200
    20.172    38.577     0.200
    21.280    38.755     0.200
    18.202    39.962     0.200
    18.415    39.172     0.200
    18.415    39.773     0.200
    18.483    40.776     0.200
    19.154    36.157     0.200
    19.545    37.284     0.200
    19.595    36.402     0.200
    20.722    36.254     0.200
    21.385    35.220     0.200
    18.080    41.722     0.200
    19.322    39.338     0.200
    21.275    36.289     0.200
    18.393    40.605     0.200
    19.439    38.364     0.200
    20.711    36.808     0.200
    20.920    35.910     0.200
    14.081    47.216     0.200
    14.155    39.449     0.200
    14.358    39.231     0.200
    14.578    40.832     0.200
    14.985    42.741     0.200
    15.054    40.228     0.200
    15.098    41.937     0.200
    15.198    41.895     0.200
    15.329    41.247     0.200
    15.329    42.247     0.200
    15.402    41.952     0.200
    15.402    42.702     0.200
    15.548    42.990     0.200
    15.947    39.930     0.200
    15.962    41.419     0.200
    16.239    46.322     0.200
    16.330    40.512     0.200
    16.400    46.356     0.200
    16.649    44.084     0.200
    16.787    42.727     0.200
    16.852    40.304     0.200
    16.943    44.113     0.200
    16.972    41.178     0.200
    17.044    41.034     0.200
    17.111    44.648     0.200
    17.116    41.140     0.200
    17.172    40.343     0.200
    17.184    40.792     0.200
    17.336    41.373     0.200
    17.378    41.647     0.200
    17.378    43.139     0.200
    17.355    41.101     0.200
    17.712    43.539     0.200
    17.724    43.235     0.200
    17.743    41.371     0.200
    17.795    44.168     0.200
    17.796    42.657     0.200
    17.810    44.187     0.200
    17.844    42.798     0.200
    17.941    40.440     0.200
    18.006    44.856     0.200
    18.065    40.522     0.200
    18.065    42.112     0.200
    18.065    40.182     0.200
    18.262    41.414     0.200
    18.286    41.822     0.200
    18.325    45.181     0.200
    18.331    43.847     0.200
    18.388    42.252     0.200
    18.461    39.594     0.200
    18.789    41.455     0.200
    18.873    39.185     0.200
    18.908    39.713     0.200
    18.964    36.031     0.200
    19.053    39.768     0.200
    19.149    39.468     0.200
    19.170    38.523     0.200
    19.361    39.198     0.200
    19.559    39.082     0.200
    19.559    38.484     0.200
    19.755    38.793     0.200
    19.752    39.831     0.200
    20.471    39.543     0.200
    20.687    39.217     0.200
    20.891    38.040     0.200
    20.891    38.341     0.200
    21.459    42.206     0.200
    21.549    37.359     0.200
    22.925    39.585     0.200
    24.062    35.832     0.200
    24.512    35.999     0.200
    26.161    31.841     0.200
    26.194    31.598     0.200
    26.217    30.589     0.200
    27.032    29.072     0.200
    27.719    26.638     0.200
    27.801    27.801     0.200
    28.068    25.272     0.200
    28.273    25.780     0.200
    28.331    23.120     0.200
    28.438    23.031     0.200
    28.438    22.251     0.200
    28.560    24.931     0.200
    28.637    23.949     0.200
    28.718    24.175     0.200
    28.810    21.524     0.200
    28.955    23.254     0.200
    29.130    23.299     0.200
    29.359    23.112     0.200
    29.727    21.241     0.200
    14.331    39.066     0.200
    14.734    38.655     0.200
    14.896    40.409     0.200
    15.027    39.332     0.200
    15.070    40.569     0.200
    15.354    42.683     0.200
    15.303    40.678     0.200
    15.375    39.935     0.200
    15.574    43.684     0.200
    15.649    40.951     0.200
    15.709    43.281     0.200
    15.735    39.803     0.200
    15.944    41.591     0.200
    15.971    41.864     0.200
    15.974    39.177     0.200
    15.924    42.977     0.200
    15.936    42.484     0.200
    16.106    40.832     0.200
    16.160    45.873     0.200
    16.236    39.222     0.200
    16.239    39.884     0.200
    16.311    44.455     0.200
    16.311    42.694     0.200
    16.311    39.270     0.200
    16.361    44.128     0.200
    16.361    39.194     0.200
    16.422    41.307     0.200
    16.477    42.910     0.200
    16.622    40.721     0.200
    16.850    40.913     0.200
    16.854    44.145     0.200
    16.922    39.627     0.200
    16.949    41.103     0.200
    17.021    40.564     0.200
    17.111    40.840     0.200
    17.091    41.955     0.200
    17.096    39.941     0.200
    17.150    39.361     0.200
    17.339    40.599     0.200
    17.359    43.545     0.200
    17.359    40.213     0.200
    17.705    39.601     0.200
    17.666    40.453     0.200
    17.699    39.632     0.200
    17.718    40.930     0.200
    17.773    41.391     0.200
    17.771    42.315     0.200
    17.819    41.455     0.200
    17.925    43.879     0.200
    17.944    39.289     0.200
    18.067    40.631     0.200
    18.067    41.330     0.200
    18.230    41.157     0.200
    18.278    41.787     0.200
    18.312    39.032     0.200
    18.254    39.780     0.200
    18.364    41.689     0.200
    18.321    39.499     0.200
    18.448    42.642     0.200
    18.468    40.336     0.200
    18.483    38.437     0.200
    18.483    39.109     0.200
    18.430    43.021     0.200
    18.384    40.657     0.200
    18.513    41.404     0.200
    18.438    42.135     0.200
    18.523    41.796     0.200
    18.445    37.955     0.200
    18.533    38.722     0.200
    18.635    38.431     0.200
    18.805    40.953     0.200
    18.805    41.113     0.200
    18.970    38.427     0.200
    19.029    38.468     0.200
    19.200    37.732     0.200
    19.128    38.573     0.200
    19.161    38.092     0.200
    19.269    39.037     0.200
    19.391    38.509     0.200
    19.505    38.576     0.200
    19.505    38.177     0.200
    19.421    38.355     0.200
    19.589    38.500     0.200
    19.589    37.699     0.200
    19.662    38.665     0.200
    19.780    38.273     0.200
    19.763    38.368     0.200
    19.785    38.610     0.200
    20.229    38.431     0.200
    20.197    38.803     0.200
    20.197    39.080     0.200
    20.394    37.817     0.200
    20.430    38.110     0.200
    20.438    37.085     0.200
    20.581    37.629     0.200
    20.810    37.798     0.200
    20.758    39.060     0.200
    20.916    37.115     0.200
    21.177    38.209     0.200
    21.265    37.655     0.200
    21.362    38.080     0.200
    21.486    40.554     0.200
    21.574    36.936     0.200
    23.876    33.669     0.200
    24.089    33.177     0.200
    24.531    34.757     0.200
    24.531    34.897     0.200
    26.166    28.146     0.200
    26.189    32.425     0.200
    26.189    27.976     0.200
    26.509    29.181     0.200
    27.003    28.991     0.200
    27.003    25.851     0.200
    27.003    27.800     0.200
    27.741    24.099     0.200
    27.826    24.474     0.200
    28.089    22.885     0.200
    28.245    24.154     0.200
    28.355    23.494     0.200
    28.460    20.962     0.200
    28.509    22.881     0.200
    28.532    22.822     0.200
    28.833    21.823     0.200
    28.736    22.550     0.200
    28.736    25.077     0.200
    28.904    25.365     0.200
    28.904    22.088     0.200
    29.148    20.842     0.200
    29.376    21.219     0.200
    19.501    37.973     0.200
    20.922    37.365     0.200
    14.321    39.969     0.200
    14.321    40.712     0.200
    14.543    41.096     0.200
    15.062    41.856     0.200
    15.292    41.906     0.200
    15.292    42.851     0.200
    15.365    41.847     0.200
    15.365    43.276     0.200
    15.908    41.380     0.200
    15.908    42.880     0.200
    15.925    41.888     0.200
    15.925    42.955     0.200
    16.613    43.065     0.200
    16.729    42.279     0.200
    16.932    42.839     0.200
    17.071    41.519     0.200
    17.132    42.709     0.200
    17.687    44.114     0.200
    17.687    42.704     0.200
    17.706    43.610     0.200
    20.226    40.769     0.200
    20.890    38.499     0.200
    21.548    37.174     0.200
    26.999    29.857     0.200
    28.432    23.316     0.200
    17.730    43.378     0.200
    20.236    36.700     0.200
    20.920    36.854     0.200
    18.303    45.082     0.200
    20.908    38.867     0.200
    15.275    44.315     0.200
    15.348    44.026     0.200
    15.893    43.684     0.200
    15.908    43.250     0.200
    19.485    40.232     0.200
    20.232    40.392     0.200
    20.907    38.859     0.200
    28.447    23.975     0.200
    18.475    39.378     0.200
    19.617    38.182     0.200
    20.933    37.230     0.200
    21.591    37.155     0.200
    28.473    23.985     0.200
    20.918    37.228     0.200
    20.919    38.317     0.200
    19.223    37.897     0.200
    19.332    37.298     0.200
    19.607    38.517     0.200
    19.787    37.615     0.200
    20.456    35.604     0.200
    20.923    37.578     0.200
    21.514    42.761     0.200
    21.581    36.280     0.200
    28.363    21.630     0.200
    28.464    21.685     0.200
    19.573    38.417     0.200
    20.904    37.728     0.200
    28.451    22.267     0.200
    20.915    37.363     0.200
    19.421    38.130     0.200
    20.179    38.737     0.200
    20.967    40.942     0.200
    21.665    37.294     0.200
    18.019    39.781     0.200
    19.334    37.836     0.200
    20.579    36.575     0.200
    21.241    34.482     0.200
    23.017    34.059     0.200
    21.432    36.470     0.200
    20.543    35.653     0.200
    28.168    19.492     0.200
    18.685    35.436     0.200
    19.372    37.401     0.200
    19.618    37.810     0.200
    19.740    36.811     0.200
    19.740    36.362     0.200
    20.945    35.355     0.200
    20.946    35.641     0.200
    26.140    25.722     0.200
    28.562    18.930     0.200
    18.428    40.373     0.200
    18.793    39.008     0.200
    19.880    40.073     0.200
    19.938    39.048     0.200
    20.020    38.957     0.200
    20.020    38.955     0.200
    20.731    40.450     0.200
    20.791    36.496     0.200
    21.250    40.243     0.200
    21.388    38.254     0.200
    21.388    38.248     0.200
    21.401    42.053     0.200
    21.530    42.376     0.200
    22.566    37.957     0.200
    22.566    38.236     0.200
    22.566    39.886     0.200
    27.582    26.350     0.200
    28.955    19.193     0.200
    28.955    19.198     0.200
    14.309    44.279     0.200
    21.399    38.338     0.200
    14.312    45.573     0.200
    18.448    40.318     0.200
    20.039    38.744     0.200
    20.039    39.809     0.200
    21.412    38.969     0.200
    28.978    20.184     0.200
    14.407    43.795     0.200
    19.518    38.931     0.200
    14.941    44.238     0.200
    15.380    39.762     0.200
    15.536    41.306     0.200
    15.588    41.627     0.200
    15.870    40.322     0.200
    15.956    40.273     0.200
    15.979    40.924     0.200
    16.202    40.613     0.200
    16.430    40.169     0.200
    16.543    41.964     0.200
    16.580    41.682     0.200
    16.669    40.895     0.200
    16.704    42.593     0.200
    16.731    40.981     0.200
    16.759    41.448     0.200
    16.838    41.207     0.200
    17.006    40.033     0.200
    17.105    41.114     0.200
    17.358    42.363     0.200
    17.406    44.275     0.200
    17.460    41.562     0.200
    17.475    41.391     0.200
    17.482    40.217     0.200
    17.500    41.897     0.200
    17.591    42.838     0.200
    17.756    40.819     0.200
    17.806    43.523     0.200
    18.321    40.608     0.200
    18.769    39.394     0.200
    18.769    39.245     0.200
    19.600    39.330     0.200
    19.594    37.268     0.200
    19.604    37.143     0.200
    19.773    38.771     0.200
    19.773    39.032     0.200
    19.949    38.973     0.200
    19.996    37.467     0.200
    20.007    37.448     0.200
    20.007    38.843     0.200
    20.007    38.480     0.200
    20.038    38.257     0.200
    20.012    38.881     0.200
    20.133    39.573     0.200
    20.488    37.421     0.200
    20.519    37.621     0.200
    20.856    35.738     0.200
    21.033    38.011     0.200
    21.032    39.376     0.200
    21.032    40.454     0.200
    21.122    36.629     0.200
    21.157    40.018     0.200
    21.280    37.821     0.200
    21.281    37.239     0.200
    21.844    40.203     0.200
    22.222    38.098     0.200
    22.463    38.088     0.200
    22.912    38.532     0.200
    22.912    38.141     0.200
    22.912    39.430     0.200
    23.180    37.813     0.200
    23.557    38.020     0.200
    23.715    37.672     0.200
    23.758    35.574     0.200
    23.982    37.662     0.200
    24.139    35.128     0.200
    24.516    36.424     0.200
    24.521    36.062     0.200
    24.620    33.614     0.200
    24.857    36.847     0.200
    25.901    32.064     0.200
    26.304    31.857     0.200
    26.583    30.603     0.200
    27.599    24.145     0.200
    28.794    20.955     0.200
    19.780    38.451     0.200
    21.286    36.436     0.200
    21.290    36.687     0.200
    18.804    38.761     0.200
    19.485    39.133     0.200
    19.634    38.907     0.200
    19.808    37.788     0.200
    19.808    38.379     0.200
    19.812    38.179     0.200
    19.852    38.929     0.200
    20.026    38.743     0.200
    20.072    38.142     0.200
    20.875    35.131     0.200
    20.867    39.628     0.200
    21.031    39.732     0.200
    21.309    36.593     0.200
    21.310    37.924     0.200
    21.841    39.852     0.200
    22.906    38.733     0.200
    22.906    38.252     0.200
    27.621    22.198     0.200
    28.825    22.325     0.200
    21.033    39.872     0.200
    21.301    37.216     0.200
    18.093    40.552     0.200
    19.499    38.974     0.200
    19.526    38.853     0.200
    20.881    37.572     0.200
    20.882    37.502     0.200
    22.500    36.451     0.200
    24.304    31.796     0.200
    24.480    33.540     0.200
    27.372    25.693     0.200
    28.435    21.363     0.200
    28.807    20.055     0.200
    20.746    36.488     0.200
    19.318    39.305     0.200
    19.469    36.831     0.200
    19.641    39.577     0.200
    19.646    36.148     0.200
    19.662    36.133     0.200
    19.684    36.118     0.200
    19.816    38.147     0.200
    21.105    37.959     0.200
    21.146    34.946     0.200
    21.375    34.606     0.200
    21.777    36.109     0.200
    22.761    39.368     0.200
    24.569    32.895     0.200
    24.776    33.893     0.200
    26.700    26.408     0.200
    14.563    42.594     0.200
    21.127    37.352     0.200
    21.108    38.691     0.200
    21.102    38.232     0.200
    20.929    38.594     0.200
    14.360    43.555     0.200
    17.990    41.580     0.200
    20.814    37.799     0.200
    21.070    35.100     0.200
    14.427    37.740     0.200
    14.906    38.448     0.200
    19.406    36.331     0.200
    20.304    35.391     0.200
    20.580    35.383     0.200
    23.911    32.383     0.200
    28.202    19.431     0.200
    19.486    36.185     0.200
    20.627    35.195     0.200
    16.284    40.425     0.200
    17.874    41.562     0.200
    17.927    41.568     0.200
    18.252    39.973     0.200
    18.347    41.421     0.200
    18.494    43.643     0.200
    18.920    43.145     0.200
    19.112    39.247     0.200
    19.354    39.363     0.200
    19.378    37.872     0.200
    19.395    38.950     0.200
    19.494    40.211     0.200
    19.622    38.512     0.200
    20.097    42.479     0.200
    20.284    41.809     0.200
    20.536    41.675     0.200
    20.774    38.220     0.200
    20.774    37.763     0.200
    20.776    37.947     0.200
    20.802    40.132     0.200
    20.994    39.427     0.200
    21.165    37.828     0.200
    21.822    36.165     0.200
    22.581    40.313     0.200
    24.475    34.004     0.200
    28.215    23.359     0.200
    28.313    23.402     0.200
    14.119    40.761     0.200
    14.911    42.187     0.200
    14.911    39.218     0.200
    14.912    42.004     0.200
    15.068    43.324     0.200
    15.223    43.279     0.200
    15.326    41.918     0.200
    15.430    41.093     0.200
    15.585    41.655     0.200
    15.772    41.633     0.200
    15.852    41.618     0.200
    16.089    44.380     0.200
    16.323    41.958     0.200
    16.490    42.526     0.200
    16.707    41.930     0.200
    16.926    43.102     0.200
    16.932    43.332     0.200
    17.000    43.601     0.200
    17.067    41.736     0.200
    17.123    42.202     0.200
    17.152    42.465     0.200
    17.797    41.037     0.200
    17.797    42.131     0.200
    17.879    41.028     0.200
    17.923    41.360     0.200
    18.070    45.656     0.200
    18.110    40.826     0.200
    18.143    42.696     0.200
    18.144    43.575     0.200
    18.223    41.567     0.200
    18.223    40.817     0.200
    18.239    41.586     0.200
    18.239    42.243     0.200
    18.344    40.558     0.200
    18.494    43.707     0.200
    18.526    39.501     0.200
    18.920    42.628     0.200
    18.921    43.897     0.200
    19.089    39.259     0.200
    19.097    39.368     0.200
    19.120    38.564     0.200
    19.169    39.747     0.200
    19.305    38.556     0.200
    19.339    39.045     0.200
    19.339    38.092     0.200
    19.471    38.400     0.200
    19.471    38.603     0.200
    19.471    39.165     0.200
    19.501    39.363     0.200
    19.653    38.761     0.200
    20.105    42.142     0.200
    20.293    39.465     0.200
    20.293    40.965     0.200
    20.319    36.506     0.200
    20.331    39.071     0.200
    20.463    40.124     0.200
    20.469    38.113     0.200
    20.469    40.722     0.200
    20.550    39.639     0.200
    20.620    39.094     0.200
    20.638    39.564     0.200
    20.760    37.612     0.200
    20.761    37.324     0.200
    20.800    41.135     0.200
    20.812    39.946     0.200
    21.163    37.159     0.200
    21.210    38.093     0.200
    21.234    39.581     0.200
    21.422    41.809     0.200
    21.501    43.356     0.200
    21.720    38.618     0.200
    21.808    36.027     0.200
    22.566    38.720     0.200
    22.580    37.156     0.200
    22.580    38.085     0.200
    22.580    37.296     0.200
    22.580    37.828     0.200
    23.229    37.157     0.200
    24.112    34.352     0.200
    24.467    33.108     0.200
    25.386    32.814     0.200
    27.319    25.423     0.200
    27.670    24.823     0.200
    28.201    23.602     0.200
    28.201    23.032     0.200
    28.298    20.999     0.200
    14.129    39.302     0.200
    14.338    38.866     0.200
    14.664    41.887     0.200
    14.738    39.911     0.200
    14.934    41.662     0.200
    14.934    40.303     0.200
    14.932    40.538     0.200
    15.322    42.508     0.200
    15.320    41.056     0.200
    15.347    42.151     0.200
    15.451    41.286     0.200
    15.605    41.191     0.200
    15.664    40.510     0.200
    15.793    41.137     0.200
    15.873    41.540     0.200
    16.036    41.513     0.200
    16.036    41.661     0.200
    16.068    42.036     0.200
    16.070    43.609     0.200
    16.022    39.558     0.200
    16.089    43.025     0.200
    16.132    42.206     0.200
    16.215    42.182     0.200
    16.287    41.919     0.200
    16.351    42.690     0.200
    16.397    43.535     0.200
    16.432    40.032     0.200
    16.511    42.183     0.200
    16.511    41.597     0.200
    16.729    41.427     0.200
    16.890    42.179     0.200
    16.926    43.267     0.200
    16.926    42.759     0.200
    16.937    40.575     0.200
    17.055    41.049     0.200
    17.003    42.624     0.200
    17.123    42.658     0.200
    17.075    44.163     0.200
    17.149    42.765     0.200
    17.201    43.950     0.200
    17.253    40.615     0.200
    17.267    41.749     0.200
    17.345    40.665     0.200
    17.345    41.454     0.200
    17.366    41.049     0.200
    17.422    43.601     0.200
    17.715    42.755     0.200
    17.761    42.615     0.200
    17.762    40.506     0.200
    17.761    44.303     0.200
    17.818    41.531     0.200
    17.826    42.299     0.200
    17.878    41.289     0.200
    17.869    41.031     0.200
    17.894    43.515     0.200
    17.931    39.580     0.200
    17.919    41.069     0.200
    17.940    39.767     0.200
    17.940    40.946     0.200
    17.940    41.603     0.200
    18.031    41.566     0.200
    18.068    42.729     0.200
    18.077    42.027     0.200
    18.101    42.071     0.200
    18.077    43.835     0.200
    18.134    39.030     0.200
    18.131    41.206     0.200
    18.137    41.430     0.200
    18.140    42.793     0.200
    18.140    40.379     0.200
    18.146    41.962     0.200
    18.238    41.353     0.200
    18.238    39.392     0.200
    18.238    42.540     0.200
    18.261    40.628     0.200
    18.259    40.804     0.200
    18.259    39.898     0.200
    18.339    42.331     0.200
    18.339    38.731     0.200
    18.370    40.018     0.200
    18.351    41.033     0.200
    18.403    38.367     0.200
    18.497    44.269     0.200
    18.519    37.146     0.200
    18.642    38.562     0.200
    18.756    42.316     0.200
    18.802    38.740     0.200
    18.862    41.576     0.200
    18.891    39.432     0.200
    18.941    40.038     0.200
    18.923    43.099     0.200
    19.036    38.186     0.200
    19.104    36.045     0.200
    19.112    35.753     0.200
    19.111    38.566     0.200
    19.191    35.124     0.200
    19.191    39.757     0.200
    19.177    41.888     0.200
    19.296    37.603     0.200
    19.326    38.745     0.200
    19.361    39.046     0.200
    19.361    38.796     0.200
    19.472    38.064     0.200
    19.489    36.365     0.200
    19.489    37.373     0.200
    19.489    37.256     0.200
    19.489    38.068     0.200
    19.494    39.260     0.200
    19.551    41.678     0.200
    19.639    41.737     0.200
    20.062    38.396     0.200
    20.096    39.803     0.200
    20.204    37.578     0.200
    20.283    40.278     0.200
    20.337    36.555     0.200
    20.431    41.934     0.200
    20.476    37.293     0.200
    20.476    38.426     0.200
    20.476    38.933     0.200
    20.535    38.749     0.200
    20.529    37.407     0.200
    20.529    43.009     0.200
    20.658    38.177     0.200
    20.665    38.478     0.200
    20.635    36.781     0.200
    20.645    38.989     0.200
    20.781    36.340     0.200
    20.781    37.395     0.200
    20.783    36.700     0.200
    20.801    39.623     0.200
    20.805    40.884     0.200
    21.170    40.632     0.200
    21.218    37.550     0.200
    21.231    38.265     0.200
    21.425    40.860     0.200
    21.505    40.717     0.200
    21.623    38.663     0.200
    21.741    38.226     0.200
    21.829    35.839     0.200
    22.568    39.152     0.200
    22.584    37.041     0.200
    22.584    37.462     0.200
    22.584    38.775     0.200
    22.584    38.033     0.200
    22.798    36.059     0.200
    23.250    36.764     0.200
    24.071    30.879     0.200
    24.133    35.953     0.200
    24.163    35.005     0.200
    24.481    32.496     0.200
    24.570    34.592     0.200
    24.735    32.494     0.200
    25.408    32.822     0.200
    25.604    29.033     0.200
    26.155    27.736     0.200
    26.365    27.726     0.200
    26.443    30.283     0.200
    27.336    24.570     0.200
    27.600    24.213     0.200
    27.692    26.426     0.200
    27.946    23.547     0.200
    28.222    21.862     0.200
    28.222    22.652     0.200
    28.320    22.598     0.200
    28.320    20.481     0.200
    28.320    22.028     0.200
    29.325    20.395     0.200
    14.928    42.407     0.200
    14.928    40.048     0.200
    15.313    41.672     0.200
    15.445    41.759     0.200
    16.267    44.711     0.200
    16.510    41.559     0.200
    16.510    41.942     0.200
    17.816    41.060     0.200
    17.816    42.037     0.200
    17.885    40.294     0.200
    17.954    40.283     0.200
    18.057    45.243     0.200
    18.133    40.512     0.200
    18.254    39.471     0.200
    18.256    40.868     0.200
    18.343    37.448     0.200
    18.477    43.173     0.200
    18.843    44.129     0.200
    18.903    45.319     0.200
    19.041    37.563     0.200
    19.090    38.280     0.200
    19.092    38.566     0.200
    19.196    37.685     0.200
    19.158    40.190     0.200
    19.283    39.629     0.200
    19.325    38.973     0.200
    19.366    38.063     0.200
    19.370    38.037     0.200
    19.389    38.625     0.200
    19.406    37.297     0.200
    19.479    38.392     0.200
    19.479    38.806     0.200
    19.481    37.923     0.200
    19.540    38.160     0.200
    19.475    39.060     0.200
    19.633    38.098     0.200
    19.620    42.053     0.200
    20.077    41.193     0.200
    20.265    39.947     0.200
    20.265    41.127     0.200
    20.328    38.643     0.200
    20.458    38.493     0.200
    20.465    39.528     0.200
    20.534    41.425     0.200
    20.780    35.993     0.200
    20.780    36.868     0.200
    20.780    37.368     0.200
    20.781    36.362     0.200
    20.818    40.012     0.200
    20.977    36.415     0.200
    21.230    38.628     0.200
    21.219    38.146     0.200
    21.406    40.920     0.200
    21.817    37.093     0.200
    22.548    41.512     0.200
    22.565    36.457     0.200
    23.247    38.331     0.200
    24.053    31.066     0.200
    24.467    33.528     0.200
    25.406    32.664     0.200
    27.326    25.366     0.200
    28.321    21.589     0.200
    28.321    21.488     0.200
    28.321    24.160     0.200
    20.775    36.472     0.200
    14.389    43.734     0.200
    20.767    37.197     0.200
    21.541    36.561     0.200
    21.553    37.467     0.200
    21.553    37.902     0.200
    21.642    38.664     0.200
    14.846    40.880     0.200
    19.422    37.635     0.200
    20.233    38.137     0.200
    20.688    35.931     0.200
    20.689    35.461     0.200
    14.352    40.312     0.200
    18.590    38.159     0.200
    19.614    38.292     0.200
    20.670    39.082     0.200
    21.012    36.840     0.200
    20.634    37.230     0.200
    14.224    45.561     0.200
    14.468    43.661     0.200
    14.516    39.592     0.200
    14.677    42.060     0.200
    14.834    44.437     0.200
    15.137    41.089     0.200
    15.477    42.908     0.200
    15.481    42.530     0.200
    15.531    41.839     0.200
    15.660    40.743     0.200
    16.710    39.862     0.200
    16.814    42.858     0.200
    16.814    43.764     0.200
    16.832    44.047     0.200
    16.885    40.395     0.200
    16.911    40.198     0.200
    16.920    44.414     0.200
    16.959    43.692     0.200
    17.014    42.783     0.200
    17.015    42.055     0.200
    17.218    41.147     0.200
    17.218    39.967     0.200
    17.218    42.287     0.200
    17.601    43.509     0.200
    17.632    41.029     0.200
    17.638    43.261     0.200
    17.688    40.937     0.200
    17.780    41.247     0.200
    17.940    44.282     0.200
    18.281    41.150     0.200
    18.465    38.976     0.200
    18.510    38.383     0.200
    18.510    39.572     0.200
    19.066    39.193     0.200
    19.144    39.333     0.200
    19.305    37.992     0.200
    19.314    36.986     0.200
    19.381    39.414     0.200
    19.500    38.524     0.200
    19.524    39.362     0.200
    19.525    38.396     0.200
    19.674    38.651     0.200
    19.698    38.544     0.200
    19.700    38.242     0.200
    19.700    37.906     0.200
    19.700    37.008     0.200
    19.700    37.485     0.200
    19.699    37.890     0.200
    19.867    38.139     0.200
    20.320    39.325     0.200
    20.549    34.978     0.200
    20.575    38.991     0.200
    20.632    37.508     0.200
    20.639    38.134     0.200
    20.639    39.228     0.200
    20.702    38.793     0.200
    20.806    39.074     0.200
    20.835    37.238     0.200
    20.855    38.000     0.200
    20.928    38.960     0.200
    20.982    37.503     0.200
    20.982    36.956     0.200
    21.428    37.055     0.200
    21.744    37.185     0.200
    22.167    36.906     0.200
    22.297    36.073     0.200
    22.337    37.534     0.200
    22.722    37.665     0.200
    22.722    37.188     0.200
    22.722    37.321     0.200
    22.967    37.191     0.200
    23.196    35.924     0.200
    23.455    35.908     0.200
    23.480    36.131     0.200
    24.216    32.669     0.200
    24.230    29.118     0.200
    24.328    30.363     0.200
    24.653    32.536     0.200
    24.682    32.445     0.200
    26.741    26.343     0.200
    27.547    24.607     0.200
    27.892    21.387     0.200
    28.510    22.277     0.200
    28.510    21.847     0.200
    18.345    41.373     0.200
    18.906    41.892     0.200
    19.201    39.279     0.200
    19.368    39.636     0.200
    19.623    38.907     0.200
    20.107    38.818     0.200
    20.465    39.059     0.200
    20.631    39.087     0.200
    20.783    38.236     0.200
    20.783    38.526     0.200
    20.813    38.482     0.200
    21.587    38.112     0.200
    22.799    37.921     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.897     8.804     0.200
     2.932     9.723     0.200
     3.434    15.071     0.200
     3.459    13.974     0.200
     3.634    14.138     0.200
     3.743    15.266     0.200
     3.905    15.365     0.200
     4.020    12.531     0.200
     4.127    16.779     0.200
     4.840    15.055     0.200
     4.865    17.268     0.200
     4.933    15.879     0.200
     5.565    17.895     0.200
     6.371    21.594     0.200
     6.646    20.182     0.200
     6.655    18.777     0.200
     6.645    19.391     0.200
     6.717    18.557     0.200
     6.748    19.695     0.200
     6.748    22.195     0.200
     6.855    19.339     0.200
     7.193    22.701     0.200
     7.220    22.689     0.200
     7.332    20.477     0.200
     7.426    23.280     0.200
     7.537    24.984     0.200
     7.916    23.567     0.200
     7.949    22.870     0.200
     8.074    21.217     0.200
     8.385    27.089     0.200
     8.839    24.787     0.200
     8.872    24.404     0.200
     8.981    23.537     0.200
     9.058    27.240     0.200
     9.113    24.598     0.200
     9.145    24.325     0.200
     9.266    24.606     0.200
     9.781    24.992     0.200
     9.818    26.369     0.200
     9.818    29.369     0.200
    10.284    25.926     0.200
    10.464    30.230     0.200
    20.292    43.132     0.200
     2.769    14.553     0.200
     2.943    14.030     0.200
     4.389    16.744     0.200
     4.680    16.151     0.200
     4.797    15.890     0.200
     4.941    18.410     0.200
     4.917    18.089     0.200
     4.917    19.089     0.200
     5.111    16.219     0.200
     5.546    17.945     0.200
     5.721    19.699     0.200
     6.424    21.406     0.200
     6.614    19.483     0.200
     6.675    19.577     0.200
     6.756    22.129     0.200
     6.778    21.172     0.200
     6.813    20.357     0.200
     7.861    24.132     0.200
     7.967    22.893     0.200
     8.080    21.476     0.200
     8.168    23.544     0.200
     8.882    24.114     0.200
     8.978    24.695     0.200
     9.126    25.369     0.200
     9.106    28.597     0.200
     9.244    25.196     0.200
     9.790    25.223     0.200
     9.818    26.292     0.200
    10.290    28.489     0.200
     1.260     6.766     0.200
     1.457     7.165     0.200
     1.719     6.907     0.200
     2.042     9.446     0.200
     2.176     8.280     0.200
     3.177    13.399     0.200
     3.923    15.893     0.200
     4.002    12.065     0.200
     4.172    15.588     0.200
     4.213    13.110     0.200
     5.109    14.856     0.200
     5.451    16.659     0.200
     5.874    17.425     0.200
     6.330    19.600     0.200
     6.585    21.423     0.200
     6.805    21.863     0.200
     7.099    18.123     0.200
     7.365    19.022     0.200
     7.476    19.231     0.200
     8.403    20.404     0.200
     8.504    19.434     0.200
     8.586    20.775     0.200
     8.670    21.188     0.200
     8.843    21.573     0.200
     9.598    22.365     0.200
     9.805    22.851     0.200
     9.893    22.823     0.200
     9.919    22.716     0.200
     2.154     9.870     0.200
     3.513    11.512     0.200
     3.981    16.153     0.200
     3.979    16.772     0.200
     4.319    15.604     0.200
     4.196    18.542     0.200
     4.766    17.384     0.200
     4.965    15.173     0.200
     5.085    14.560     0.200
     5.532    19.447     0.200
     5.812    17.182     0.200
     5.871    17.990     0.200
     5.865    22.360     0.200
     6.440    19.858     0.200
     6.878    20.741     0.200
     7.020    20.293     0.200
     6.947    18.537     0.200
     6.969    18.282     0.200
     7.066    22.950     0.200
     7.109    19.337     0.200
     7.146    22.611     0.200
     8.351    22.048     0.200
     8.449    20.607     0.200
     9.138    23.576     0.200
     9.144    24.292     0.200
     9.237    23.610     0.200
     9.275    23.975     0.200
     9.451    24.317     0.200
     9.571    25.022     0.200
    10.052    25.704     0.200
    10.107    29.062     0.200
    10.505    27.416     0.200
    10.562    26.752     0.200
    11.877    30.604     0.200
    19.317    39.881     0.200
    20.505    39.718     0.200
     1.603    10.054     0.200
     2.264    10.841     0.200
     2.568    12.386     0.200
     3.041    12.773     0.200
     3.125    16.286     0.200
     3.300    14.246     0.200
     3.401    15.571     0.200
     3.574    13.248     0.200
     3.631    15.487     0.200
     3.892    15.340     0.200
     3.953    16.029     0.200
     4.084    15.390     0.200
     4.087    17.462     0.200
     4.670    16.260     0.200
     5.197    15.817     0.200
     5.428    17.408     0.200
     6.545    19.877     0.200
     6.894    18.810     0.200
     7.080    19.936     0.200
     7.059    20.978     0.200
     7.035    22.160     0.200
     7.220    19.899     0.200
     7.237    20.804     0.200
     8.395    22.292     0.200
     8.395    24.490     0.200
     8.481    23.286     0.200
     8.988    26.363     0.200
     9.172    24.717     0.200
     9.233    24.504     0.200
     9.327    24.211     0.200
     9.461    26.850     0.200
     9.484    25.786     0.200
     9.661    23.912     0.200
    10.026    32.255     0.200
    10.018    27.344     0.200
    10.160    26.690     0.200
    11.422    30.964     0.200
    20.508    41.931     0.200
     2.378     9.790     0.200
     3.191    14.004     0.200
     3.363    14.588     0.200
     3.474    13.501     0.200
     3.780    15.530     0.200
     3.818    14.187     0.200
     3.858    14.917     0.200
     4.070    14.749     0.200
     4.031    16.003     0.200
     4.594    16.422     0.200
     4.628    18.531     0.200
     4.698    15.615     0.200
     4.919    16.632     0.200
     5.690    17.137     0.200
     5.722    18.760     0.200
     6.363    20.788     0.200
     6.569    20.379     0.200
     6.734    20.958     0.200
     7.011    19.723     0.200
     8.070    22.459     0.200
     8.184    26.530     0.200
     8.425    22.425     0.200
     8.299    23.294     0.200
     8.845    25.313     0.200
     9.699    29.846     0.200
     9.764    26.299     0.200
     9.842    27.688     0.200
    19.023    41.543     0.200
    20.067    39.649     0.200
     2.137    10.172     0.200
     2.549    10.871     0.200
     2.639    10.722     0.200
     2.691    11.008     0.200
     3.033    12.726     0.200
     3.150    14.661     0.200
     3.322    14.345     0.200
     3.326    14.296     0.200
     3.425    13.750     0.200
     3.597    13.441     0.200
     3.655    17.066     0.200
     3.905    15.250     0.200
     3.975    14.624     0.200
     4.109    15.769     0.200
     4.693    16.847     0.200
     4.948    16.468     0.200
     5.174    16.039     0.200
     5.241    15.953     0.200
     5.454    15.973     0.200
     5.452    17.285     0.200
     5.550    18.651     0.200
     5.579    19.010     0.200
     5.874    17.066     0.200
     5.943    20.566     0.200
     5.942    17.770     0.200
     5.954    24.128     0.200
     6.166    18.661     0.200
     6.225    20.970     0.200
     6.525    21.474     0.200
     6.856    21.610     0.200
     6.896    18.143     0.200
     6.896    22.143     0.200
     7.035    19.619     0.200
     7.057    19.661     0.200
     7.056    19.773     0.200
     7.056    21.273     0.200
     7.113    21.212     0.200
     7.198    19.921     0.200
     7.140    23.292     0.200
     7.273    22.742     0.200
     7.327    24.815     0.200
     7.456    21.104     0.200
     7.445    24.738     0.200
     7.572    23.249     0.200
     7.779    20.834     0.200
     8.391    22.697     0.200
     8.352    25.646     0.200
     8.493    21.705     0.200
     8.403    24.550     0.200
     8.403    25.050     0.200
     8.416    26.401     0.200
     8.490    23.536     0.200
     8.419    23.961     0.200
     8.599    30.268     0.200
     8.668    29.462     0.200
     9.008    26.491     0.200
     9.170    24.100     0.200
     9.218    24.542     0.200
     9.257    25.584     0.200
     9.311    23.855     0.200
     9.209    28.144     0.200
     9.326    24.984     0.200
     9.340    24.820     0.200
     9.425    23.632     0.200
     9.362    25.960     0.200
     9.645    24.557     0.200
     9.485    28.928     0.200
     9.508    27.757     0.200
     9.668    25.790     0.200
     9.756    28.861     0.200
    10.027    27.604     0.200
    10.087    25.700     0.200
    10.154    29.123     0.200
    10.040    26.450     0.200
    10.296    32.463     0.200
    10.350    26.829     0.200
    10.566    28.815     0.200
    10.601    27.000     0.200
    10.699    33.262     0.200
    11.370    31.923     0.200
    11.446    32.838     0.200
    11.949    32.674     0.200
    11.985    33.252     0.200
    12.277    35.349     0.200
    12.619    34.350     0.200
    12.717    33.406     0.200
    13.290    38.516     0.200
    15.614    39.397     0.200
    15.999    36.904     0.200
    18.218    37.013     0.200
    18.983    40.687     0.200
    19.348    39.323     0.200
    19.436    41.297     0.200
    20.013    40.970     0.200
    20.513    41.232     0.200
    20.636    40.300     0.200
     1.208     8.525     0.200
     2.496    11.495     0.200
     3.034    13.214     0.200
     3.202    16.158     0.200
     3.361    14.399     0.200
     3.471    15.318     0.200
     3.637    14.182     0.200
     3.709    16.943     0.200
     3.949    15.743     0.200
     4.190    15.227     0.200
     4.157    16.112     0.200
     4.163    18.049     0.200
     4.736    17.252     0.200
     4.921    17.994     0.200
     5.119    17.188     0.200
     5.215    16.567     0.200
     5.500    17.438     0.200
     5.833    17.554     0.200
     5.896    18.017     0.200
     5.893    20.856     0.200
     6.471    23.109     0.200
     7.030    20.584     0.200
     6.980    21.068     0.200
     7.002    21.010     0.200
     7.143    22.270     0.200
     7.440    21.802     0.200
     8.363    22.029     0.200
     8.463    22.365     0.200
     8.492    25.524     0.200
     8.471    24.665     0.200
     9.038    25.148     0.200
     9.147    24.884     0.200
     9.263    25.222     0.200
     9.597    25.226     0.200
    10.009    27.819     0.200
    10.062    26.903     0.200
    19.491    45.171     0.200
    20.365    39.570     0.200
     1.924    10.590     0.200
     1.998     9.721     0.200
     2.328    10.573     0.200
     2.394    12.701     0.200
     3.406    15.492     0.200
     3.543    14.592     0.200
     3.668    16.431     0.200
     3.821    14.147     0.200
     3.911    16.702     0.200
     4.142    15.906     0.200
     4.202    15.600     0.200
     4.357    16.087     0.200
     4.366    16.790     0.200
     4.663    14.325     0.200
     4.880    18.291     0.200
     4.919    16.136     0.200
     4.923    16.283     0.200
     4.927    17.242     0.200
     5.178    17.816     0.200
     5.596    17.238     0.200
     5.729    17.882     0.200
     5.766    17.947     0.200
     5.699    19.730     0.200
     6.327    18.400     0.200
     6.621    20.976     0.200
     6.789    20.111     0.200
     6.809    19.679     0.200
     6.889    19.841     0.200
     6.950    20.531     0.200
     6.993    20.634     0.200
     7.441    25.901     0.200
     7.309    22.940     0.200
     8.318    21.868     0.200
     8.675    24.900     0.200
     9.118    24.532     0.200
    10.026    27.730     0.200
    10.057    27.878     0.200
     1.854    11.313     0.200
     1.945     9.854     0.200
     2.264    11.528     0.200
     2.432    12.567     0.200
     2.841    13.787     0.200
     3.056    14.086     0.200
     4.374    16.901     0.200
     4.663    14.326     0.200
     4.806    19.165     0.200
     4.843    16.524     0.200
     4.876    16.745     0.200
     4.930    17.607     0.200
     5.104    17.187     0.200
     5.654    18.269     0.200
     5.713    18.177     0.200
     6.297    20.265     0.200
     6.737    19.820     0.200
     6.759    20.367     0.200
     6.900    21.028     0.200
     6.919    21.005     0.200
     6.919    23.005     0.200
     7.135    22.478     0.200
     7.200    20.723     0.200
     7.372    26.520     0.200
     7.998    21.409     0.200
     8.243    22.548     0.200
     8.243    22.649     0.200
     8.304    26.644     0.200
     8.503    25.514     0.200
     8.702    24.897     0.200
     8.961    26.177     0.200
     9.045    25.197     0.200
     9.174    28.486     0.200
     9.385    24.927     0.200
     9.832    28.012     0.200
     9.933    28.824     0.200
     9.952    27.202     0.200
     9.981    27.769     0.200
    19.224    42.097     0.200
    20.251    40.814     0.200
     2.117    10.546     0.200
     2.243    12.366     0.200
     2.410    11.629     0.200
     3.127    12.754     0.200
     3.240    15.433     0.200
     3.347    15.190     0.200
     3.481    15.127     0.200
     3.626    14.141     0.200
     3.761    16.356     0.200
     3.950    15.648     0.200
     4.007    15.283     0.200
     4.175    16.326     0.200
     4.193    18.115     0.200
     4.734    17.502     0.200
     4.811    16.601     0.200
     4.868    14.835     0.200
     5.056    16.453     0.200
     5.105    15.967     0.200
     5.514    17.105     0.200
     5.725    16.939     0.200
     5.793    18.144     0.200
     6.137    19.132     0.200
     6.778    18.651     0.200
     6.921    20.087     0.200
     6.921    21.986     0.200
     7.661    23.345     0.200
     7.806    21.651     0.200
     8.253    21.436     0.200
     8.352    21.676     0.200
     8.505    23.797     0.200
     9.000    25.719     0.200
     9.038    24.776     0.200
     9.953    24.500     0.200
     1.486     8.903     0.200
     2.439    10.489     0.200
     3.037    12.307     0.200
     3.682    14.183     0.200
     3.768    17.172     0.200
     3.998    15.592     0.200
     4.062    16.147     0.200
     4.211    16.410     0.200
     4.804    12.188     0.200
     4.893    16.654     0.200
     4.945    15.038     0.200
     4.784    17.415     0.200
     5.059    15.214     0.200
     5.187    16.514     0.200
     5.553    17.446     0.200
     5.789    16.694     0.200
     5.846    18.024     0.200
     6.866    19.119     0.200
     7.003    19.528     0.200
     7.003    21.528     0.200
     7.703    23.353     0.200
     8.334    21.695     0.200
     8.495    25.114     0.200
     9.122    24.800     0.200
     9.072    24.878     0.200
     9.254    24.754     0.200
    10.087    26.033     0.200
    10.544    27.200     0.200
    19.301    39.208     0.200
    20.153    38.961     0.200
     2.188    10.696     0.200
     2.263    12.417     0.200
     2.464    11.470     0.200
     2.844    13.035     0.200
     3.124    15.271     0.200
     3.306    15.543     0.200
     3.433    14.167     0.200
     3.584    14.704     0.200
     3.706    16.982     0.200
     3.904    16.162     0.200
     3.965    15.460     0.200
     4.125    16.791     0.200
     4.140    17.013     0.200
     4.689    17.502     0.200
     4.839    17.051     0.200
     4.901    15.334     0.200
     4.900    12.041     0.200
     5.112    16.072     0.200
     5.132    16.531     0.200
     5.465    18.253     0.200
     5.767    17.421     0.200
     5.841    18.066     0.200
     6.113    18.893     0.200
     6.793    19.953     0.200
     6.947    20.151     0.200
     6.947    22.151     0.200
     7.016    21.353     0.200
     7.049    25.964     0.200
     7.765    21.608     0.200
     8.282    21.881     0.200
     8.299    29.376     0.200
     8.381    22.317     0.200
     8.383    22.891     0.200
     8.403    26.161     0.200
     8.451    24.899     0.200
     8.969    27.558     0.200
     9.062    25.468     0.200
     9.118    26.814     0.200
     9.196    28.915     0.200
     9.531    27.005     0.200
     9.628    28.868     0.200
     9.662    28.466     0.200
     9.922    28.438     0.200
     9.979    26.576     0.200
    10.492    27.783     0.200
    19.241    40.688     0.200
    20.415    39.985     0.200
     1.464    10.053     0.200
     1.621     9.220     0.200
     1.927    10.641     0.200
     2.212    10.514     0.200
     2.425    10.940     0.200
     3.015    13.950     0.200
     3.409    15.051     0.200
     3.617    14.424     0.200
     3.732    14.976     0.200
     3.899    16.136     0.200
     3.942    16.735     0.200
     4.075    15.978     0.200
     4.116    15.596     0.200
     4.320    16.021     0.200
     4.352    18.041     0.200
     4.713    14.832     0.200
     4.852    18.506     0.200
     4.965    17.685     0.200
     5.425    16.821     0.200
     5.545    17.226     0.200
     5.602    17.754     0.200
     5.653    18.560     0.200
     6.471    20.213     0.200
     6.674    18.253     0.200
     6.781    20.001     0.200
     7.987    22.928     0.200
     8.108    21.315     0.200
     8.200    21.837     0.200
     8.355    26.629     0.200
     8.876    23.046     0.200
     8.904    23.917     0.200
     9.016    23.912     0.200
     9.788    27.905     0.200
     9.814    25.100     0.200
     9.853    26.650     0.200
    10.318    25.723     0.200
    19.084    41.119     0.200
    19.929    39.858     0.200
     1.377     7.692     0.200
     1.573     7.409     0.200
     2.123     9.987     0.200
     2.579    10.469     0.200
     2.996    12.295     0.200
     3.617    10.553     0.200
     3.333    15.067     0.200
     3.426    14.080     0.200
     3.606    12.678     0.200
     3.640    14.489     0.200
     3.984    14.671     0.200
     4.107    15.736     0.200
     4.105    17.060     0.200
     4.699    15.427     0.200
     4.699    18.327     0.200
     5.052    15.113     0.200
     5.194    15.146     0.200
     5.282    15.419     0.200
     5.452    16.537     0.200
     5.913    16.256     0.200
     5.977    20.017     0.200
     5.979    17.289     0.200
     6.840    19.444     0.200
     6.936    18.824     0.200
     7.097    19.438     0.200
     7.154    22.380     0.200
     7.092    19.000     0.200
     7.314    22.408     0.200
     7.038    21.133     0.200
     7.932    22.801     0.200
     7.724    25.620     0.200
     7.788    21.873     0.200
     8.432    21.363     0.200
     8.534    22.171     0.200
     8.645    21.579     0.200
     8.525    24.274     0.200
     8.682    25.445     0.200
     9.254    23.271     0.200
     9.211    23.267     0.200
     9.027    25.423     0.200
     9.020    27.495     0.200
     9.298    24.250     0.200
     9.242    26.911     0.200
     9.301    27.218     0.200
     9.245    26.873     0.200
     9.364    25.490     0.200
     9.830    25.850     0.200
     9.687    24.718     0.200
     9.687    25.218     0.200
     9.850    29.810     0.200
    10.067    28.279     0.200
    10.128    25.066     0.200
    10.128    23.566     0.200
    10.195    25.291     0.200
    10.053    26.447     0.200
    10.311    28.437     0.200
    10.642    26.566     0.200
    10.873    30.872     0.200
    11.366    28.120     0.200
    11.793    30.738     0.200
    16.033    35.658     0.200
    19.135    42.453     0.200
    19.411    43.234     0.200
    20.249    39.058     0.200
     1.501    10.854     0.200
     2.170    10.551     0.200
     2.480    12.435     0.200
     3.467    16.712     0.200
     3.510    15.114     0.200
     3.678    14.752     0.200
     3.793    14.511     0.200
     3.997    16.326     0.200
     4.177    16.029     0.200
     4.412    19.087     0.200
     4.913    19.134     0.200
     4.970    18.368     0.200
     5.142    17.366     0.200
     5.353    16.803     0.200
     5.474    16.985     0.200
     5.527    17.367     0.200
     5.576    18.303     0.200
     5.714    18.391     0.200
     6.480    21.749     0.200
     6.785    20.687     0.200
     6.808    23.519     0.200
     8.110    22.930     0.200
     8.199    22.793     0.200
     8.847    25.630     0.200
     8.912    24.375     0.200
     9.057    24.682     0.200
     9.114    28.017     0.200
     9.802    27.979     0.200
     9.848    28.440     0.200
     2.198    10.095     0.200
     2.787    13.612     0.200
     3.071    13.409     0.200
     3.326    14.129     0.200
     3.523    13.327     0.200
     3.441    15.388     0.200
     3.602    14.304     0.200
     3.690    17.776     0.200
     3.917    15.137     0.200
     3.982    15.568     0.200
     4.188    17.867     0.200
     4.128    16.164     0.200
     4.137    18.165     0.200
     4.346    18.326     0.200
     4.703    17.353     0.200
     4.957    15.696     0.200
     5.133    15.445     0.200
     5.189    17.482     0.200
     5.399    16.335     0.200
     5.433    17.838     0.200
     5.471    17.400     0.200
     5.623    15.821     0.200
     5.701    19.316     0.200
     5.819    17.338     0.200
     5.890    21.510     0.200
     5.888    18.034     0.200
     6.476    22.163     0.200
     6.991    19.152     0.200
     7.015    19.177     0.200
     7.004    20.801     0.200
     7.059    23.369     0.200
     7.155    19.948     0.200
     7.221    22.976     0.200
     7.836    23.191     0.200
     7.784    23.399     0.200
     8.338    21.640     0.200
     8.439    21.957     0.200
     8.455    24.574     0.200
     8.447    24.064     0.200
     9.044    25.696     0.200
     9.000    27.208     0.200
     9.000    28.208     0.200
     9.119    24.523     0.200
     9.045    26.685     0.200
     9.206    24.806     0.200
     9.257    24.712     0.200
     9.179    28.525     0.200
     9.271    25.156     0.200
     9.271    25.446     0.200
     9.227    29.561     0.200
     9.370    24.191     0.200
     9.591    25.414     0.200
     9.660    28.512     0.200
     9.825    30.584     0.200
     9.979    28.791     0.200
    10.035    26.331     0.200
    10.100    27.379     0.200
    10.480    27.642     0.200
    10.510    30.290     0.200
    10.370    29.227     0.200
    10.549    28.140     0.200
    11.474    34.234     0.200
    12.082    36.047     0.200
    12.514    34.003     0.200
    12.737    33.605     0.200
    19.482    41.892     0.200
    19.654    40.083     0.200
    19.988    41.981     0.200
    20.156    39.425     0.200
    20.470    41.153     0.200
    20.644    41.333     0.200
     2.086    11.236     0.200
     2.185     9.291     0.200
     2.504    10.868     0.200
     2.624    10.567     0.200
     2.679    11.020     0.200
     3.399    14.018     0.200
     3.502    14.220     0.200
     3.982    14.716     0.200
     4.052    14.693     0.200
     4.185    16.248     0.200
     4.185    18.140     0.200
     4.203    15.538     0.200
     4.360    16.201     0.200
     4.770    16.413     0.200
     4.959    16.714     0.200
     5.014    15.475     0.200
     5.253    16.579     0.200
     5.453    15.847     0.200
     5.518    18.184     0.200
     5.673    16.283     0.200
     5.860    17.703     0.200
     5.916    18.540     0.200
     5.907    19.651     0.200
     6.234    18.830     0.200
     6.786    20.390     0.200
     7.068    20.095     0.200
     7.068    22.095     0.200
     7.115    22.554     0.200
     7.323    20.127     0.200
     7.316    25.011     0.200
     7.682    22.939     0.200
     7.798    23.577     0.200
     7.885    22.272     0.200
     8.400    21.851     0.200
     8.400    21.952     0.200
     8.499    21.107     0.200
     9.081    27.608     0.200
     9.186    22.881     0.200
     9.188    25.355     0.200
     9.310    26.935     0.200
     9.273    24.371     0.200
     9.320    24.824     0.200
     9.398    24.414     0.200
     9.741    26.909     0.200
     9.798    28.640     0.200
    10.051    27.784     0.200
    10.101    25.709     0.200
    10.156    28.065     0.200
    10.611    25.756     0.200
    11.922    32.755     0.200
    19.365    39.593     0.200
    19.492    41.115     0.200
    20.403    39.081     0.200
     2.519    10.564     0.200
     2.588    10.256     0.200
     2.644    10.801     0.200
     3.423    13.707     0.200
     3.519    13.990     0.200
     3.697    15.111     0.200
     4.002    13.958     0.200
     4.075    14.300     0.200
     4.208    14.848     0.200
     4.200    15.249     0.200
     4.196    17.489     0.200
     4.379    12.354     0.200
     4.791    16.044     0.200
     4.994    16.877     0.200
     5.047    13.857     0.200
     5.289    15.140     0.200
     5.486    16.741     0.200
     5.545    16.748     0.200
     5.704    15.292     0.200
     5.888    16.445     0.200
     5.940    17.632     0.200
     6.267    19.319     0.200
     6.962    19.205     0.200
     7.104    19.154     0.200
     7.879    21.505     0.200
     8.435    20.819     0.200
     8.532    21.383     0.200
     8.577    23.364     0.200
     9.111    27.133     0.200
     9.222    23.532     0.200
    10.136    25.167     0.200
    19.401    39.544     0.200
     1.652    10.437     0.200
     1.751    10.681     0.200
     1.966     9.379     0.200
     2.027    11.569     0.200
     2.049    12.011     0.200
     2.935    12.466     0.200
     3.012    15.763     0.200
     3.200    13.380     0.200
     3.745    15.615     0.200
     3.770    15.529     0.200
     3.825    15.783     0.200
     3.983    16.931     0.200
     4.107    15.684     0.200
     4.222    17.348     0.200
     4.255    18.066     0.200
     4.414    17.412     0.200
     4.446    17.130     0.200
     4.491    16.608     0.200
     4.700    18.766     0.200
     4.767    18.483     0.200
     4.776    16.488     0.200
     5.071    17.544     0.200
     5.189    18.467     0.200
     5.378    16.559     0.200
     5.510    17.921     0.200
     5.512    17.089     0.200
     5.520    19.796     0.200
     5.764    17.253     0.200
     5.970    20.053     0.200
     6.065    20.744     0.200
     6.348    21.039     0.200
     6.650    17.108     0.200
     6.626    21.594     0.200
     6.772    25.686     0.200
     6.862    20.743     0.200
     6.791    21.366     0.200
     6.854    19.735     0.200
     6.881    21.312     0.200
     6.984    21.612     0.200
     7.092    22.350     0.200
     7.154    22.734     0.200
     7.239    25.237     0.200
     7.335    21.619     0.200
     7.404    21.610     0.200
     7.382    23.072     0.200
     7.393    22.440     0.200
     7.576    24.409     0.200
     7.777    26.960     0.200
     7.905    24.469     0.200
     7.997    28.393     0.200
     8.192    23.119     0.200
     8.252    24.813     0.200
     8.264    22.383     0.200
     8.267    27.243     0.200
     8.282    24.063     0.200
     8.529    25.584     0.200
     8.622    26.096     0.200
     8.760    25.491     0.200
     8.749    26.612     0.200
     8.981    24.409     0.200
     9.018    24.482     0.200
     9.018    24.583     0.200
     9.040    24.820     0.200
     9.101    24.515     0.200
     9.129    29.486     0.200
     9.360    30.485     0.200
     9.400    29.519     0.200
     9.423    30.758     0.200
     9.705    28.162     0.200
     9.666    32.013     0.200
     9.897    25.721     0.200
     9.897    28.221     0.200
     9.915    26.216     0.200
     9.942    27.196     0.200
     9.917    29.992     0.200
    10.078    32.109     0.200
    10.091    29.061     0.200
    10.206    29.918     0.200
    10.263    31.451     0.200
    10.398    28.170     0.200
    10.790    32.003     0.200
    10.920    30.483     0.200
    11.305    33.784     0.200
    11.504    33.763     0.200
    11.951    33.857     0.200
    12.136    30.786     0.200
    12.645    37.355     0.200
    13.900    36.011     0.200
    14.437    38.640     0.200
    17.543    39.987     0.200
    18.555    42.677     0.200
    18.699    42.802     0.200
    18.748    41.036     0.200
    18.808    45.728     0.200
    18.807    41.141     0.200
    18.858    43.850     0.200
    19.021    41.947     0.200
    19.003    41.452     0.200
    19.003    45.053     0.200
    19.262    45.334     0.200
    19.373    41.939     0.200
    19.564    41.004     0.200
    19.546    41.015     0.200
    19.621    42.142     0.200
    19.678    44.076     0.200
    20.014    40.552     0.200
    20.266    42.215     0.200
     1.978    10.959     0.200
     2.283    10.900     0.200
     2.370    11.591     0.200
     2.664    13.953     0.200
     3.132    13.890     0.200
     3.362    14.409     0.200
     3.679    14.912     0.200
     3.745    15.245     0.200
     3.874    16.540     0.200
     4.099    14.217     0.200
     4.107    17.412     0.200
     4.180    14.871     0.200
     4.157    16.240     0.200
     4.166    15.428     0.200
     4.286    16.821     0.200
     4.302    18.245     0.200
     4.399    18.413     0.200
     4.332    16.201     0.200
     4.412    14.764     0.200
     4.414    16.639     0.200
     4.591    18.968     0.200
     4.638    18.420     0.200
     4.828    18.201     0.200
     4.827    15.822     0.200
     4.849    19.963     0.200
     4.846    16.998     0.200
     4.842    16.038     0.200
     4.885    17.542     0.200
     4.969    19.056     0.200
     5.091    16.639     0.200
     5.315    18.922     0.200
     5.435    18.914     0.200
     5.494    17.139     0.200
     5.494    20.232     0.200
     5.489    18.886     0.200
     5.727    19.011     0.200
     5.776    20.142     0.200
     5.888    20.037     0.200
     5.999    18.932     0.200
     5.996    20.171     0.200
     6.038    18.584     0.200
     6.105    19.305     0.200
     6.173    19.310     0.200
     6.107    19.784     0.200
     6.179    19.439     0.200
     6.219    19.077     0.200
     6.219    20.476     0.200
     6.187    19.846     0.200
     6.297    20.464     0.200
     6.295    19.788     0.200
     6.427    21.244     0.200
     6.470    21.541     0.200
     6.450    20.774     0.200
     6.646    20.288     0.200
     6.646    20.695     0.200
     6.660    22.122     0.200
     6.612    21.890     0.200
     6.662    21.299     0.200
     6.738    21.414     0.200
     6.780    23.924     0.200
     6.797    22.933     0.200
     6.850    20.104     0.200
     6.887    21.470     0.200
     6.841    21.213     0.200
     6.976    22.138     0.200
     7.034    21.965     0.200
     7.060    22.162     0.200
     7.230    21.972     0.200
     7.191    23.632     0.200
     7.287    22.907     0.200
     7.414    21.632     0.200
     7.520    21.491     0.200
     7.747    24.637     0.200
     8.143    23.019     0.200
     8.152    25.414     0.200
     8.283    24.379     0.200
     8.352    25.277     0.200
     8.294    25.257     0.200
     8.360    23.280     0.200
     8.425    22.827     0.200
     8.536    23.432     0.200
     8.586    27.843     0.200
     8.852    25.039     0.200
     8.848    27.794     0.200
     8.869    27.547     0.200
     8.924    26.409     0.200
     9.212    25.543     0.200
     9.249    25.108     0.200
     9.263    27.950     0.200
     9.313    27.166     0.200
     9.724    26.567     0.200
     9.909    29.410     0.200
     9.909    28.410     0.200
    10.848    33.243     0.200
    11.460    32.313     0.200
    11.669    31.864     0.200
    18.532    41.483     0.200
    19.530    40.526     0.200
    19.935    40.400     0.200
     1.371     9.235     0.200
     1.483     9.328     0.200
     1.659     9.677     0.200
     2.125     9.734     0.200
     2.311    10.562     0.200
     2.354    10.560     0.200
     2.448    13.767     0.200
     2.656    11.545     0.200
     2.823    12.088     0.200
     3.006    12.649     0.200
     3.049    12.149     0.200
     3.036    12.599     0.200
     3.109    13.861     0.200
     3.201    13.684     0.200
     3.476    13.965     0.200
     3.444    14.042     0.200
     3.437    13.430     0.200
     3.623    14.861     0.200
     3.987    16.508     0.200
     3.874    15.625     0.200
     3.907    15.836     0.200
     3.923    14.757     0.200
     4.206    14.454     0.200
     4.206    15.853     0.200
     4.320    13.820     0.200
     4.485    15.291     0.200
     4.543    16.517     0.200
     4.593    14.536     0.200
     4.620    15.519     0.200
     4.685    16.856     0.200
     5.054    16.049     0.200
     4.989    16.415     0.200
     5.266    18.078     0.200
     5.333    16.103     0.200
     5.406    16.251     0.200
     5.273    17.395     0.200
     5.368    15.895     0.200
     5.328    17.456     0.200
     5.519    16.629     0.200
     5.474    17.055     0.200
     5.556    18.699     0.200
     5.706    16.943     0.200
     5.761    18.304     0.200
     5.724    18.041     0.200
     5.854    18.120     0.200
     5.910    18.570     0.200
     6.140    18.385     0.200
     6.113    20.202     0.200
     6.291    19.121     0.200
     6.194    18.358     0.200
     6.271    19.357     0.200
     6.419    19.328     0.200
     6.484    19.969     0.200
     6.627    17.699     0.200
     6.667    20.036     0.200
     6.628    19.185     0.200
     6.716    18.659     0.200
     7.171    20.855     0.200
     7.191    21.613     0.200
     7.640    20.376     0.200
     7.634    20.843     0.200
     7.770    21.161     0.200
     7.803    22.078     0.200
     8.273    26.495     0.200
     8.380    23.741     0.200
     8.309    23.073     0.200
     8.837    23.514     0.200
     8.916    22.585     0.200
     8.927    26.859     0.200
     9.072    23.767     0.200
     9.257    23.408     0.200
     9.959    24.711     0.200
    10.028    24.306     0.200
    10.234    24.904     0.200
    10.325    25.042     0.200
    10.548    27.241     0.200
    11.506    30.657     0.200
    18.508    40.044     0.200
     1.912    12.239     0.200
     1.984    10.408     0.200
     2.148    12.491     0.200
     3.133    16.995     0.200
     3.134    13.982     0.200
     3.213    15.060     0.200
     3.381    14.405     0.200
     3.422    13.819     0.200
     3.680    15.608     0.200
     3.667    15.265     0.200
     3.760    15.175     0.200
     3.888    17.989     0.200
     4.070    16.463     0.200
     4.175    14.238     0.200
     4.118    15.395     0.200
     4.128    15.477     0.200
     4.167    16.430     0.200
     4.180    16.581     0.200
     4.302    17.949     0.200
     4.319    17.659     0.200
     4.338    16.829     0.200
     4.343    17.673     0.200
     4.405    17.449     0.200
     4.432    15.834     0.200
     4.435    15.898     0.200
     4.580    17.710     0.200
     4.641    20.197     0.200
     4.842    15.552     0.200
     4.857    17.071     0.200
     4.862    18.618     0.200
     4.894    18.043     0.200
     4.976    19.482     0.200
     5.328    18.383     0.200
     5.511    19.748     0.200
     5.744    19.030     0.200
     5.901    18.691     0.200
     6.008    19.847     0.200
     6.198    22.027     0.200
     6.198    19.231     0.200
     6.240    19.741     0.200
     6.316    19.554     0.200
     6.481    20.919     0.200
     6.633    20.147     0.200
     7.540    20.561     0.200
     7.604    23.322     0.200
     1.754     7.614     0.200
     2.044     9.729     0.200
     2.267    10.024     0.200
     2.468     8.778     0.200
     2.533    11.324     0.200
     2.633    10.055     0.200
     2.852    11.800     0.200
     2.957    12.072     0.200
     3.011    11.946     0.200
     3.107    12.129     0.200
     3.147    11.662     0.200
     3.445    11.884     0.200
     3.506    14.171     0.200
     3.461    12.889     0.200
     3.685    12.581     0.200
     3.867    13.361     0.200
     3.825    13.946     0.200
     3.927    12.854     0.200
     3.948    11.116     0.200
     3.891    12.675     0.200
     4.078    13.797     0.200
     4.156    13.678     0.200
     4.059    14.313     0.200
     4.233    12.985     0.200
     4.183    14.867     0.200
     4.841    14.784     0.200
     5.065    14.779     0.200
     5.343    15.729     0.200
     5.457    16.400     0.200
     5.515    17.028     0.200
     5.598    15.261     0.200
     5.503    16.467     0.200
     5.730    16.618     0.200
     5.727    16.748     0.200
     5.712    17.024     0.200
     5.824    17.318     0.200
     5.855    16.756     0.200
     5.970    17.410     0.200
     5.943    17.928     0.200
     5.881    18.455     0.200
     6.041    19.382     0.200
     6.165    16.843     0.200
     6.214    18.164     0.200
     6.256    16.878     0.200
     6.305    18.409     0.200
     6.287    19.720     0.200
     6.601    19.047     0.200
     6.686    20.054     0.200
     6.660    18.566     0.200
     6.725    16.799     0.200
     6.787    19.884     0.200
     6.826    20.529     0.200
     7.062    18.970     0.200
     7.169    18.022     0.200
     7.309    19.289     0.200
     7.338    20.255     0.200
     7.493    20.639     0.200
     7.594    20.065     0.200
     8.461    20.349     0.200
     8.470    26.233     0.200
     8.625    20.835     0.200
     8.800    20.983     0.200
     9.494    22.293     0.200
     9.563    21.686     0.200
     9.769    22.281     0.200
     9.860    22.823     0.200
     9.884    22.931     0.200
    10.083    23.214     0.200
     1.535     9.060     0.200
     1.672     8.954     0.200
     1.735    10.225     0.200
     1.934     9.193     0.200
     2.677    12.228     0.200
     2.740    10.989     0.200
     3.189    12.248     0.200
     3.144    12.279     0.200
     3.317    12.761     0.200
     3.377    13.054     0.200
     3.631    13.890     0.200
     3.664    14.412     0.200
     3.727    15.473     0.200
     3.736    14.670     0.200
     3.925    15.163     0.200
     4.131    15.763     0.200
     4.209    16.346     0.200
     4.221    16.006     0.200
     4.258    15.177     0.200
     4.260    16.357     0.200
     4.376    16.298     0.200
     4.557    14.690     0.200
     4.596    15.335     0.200
     4.899    16.403     0.200
     4.918    15.182     0.200
     5.149    17.381     0.200
     5.355    17.478     0.200
     5.447    17.902     0.200
     5.463    19.220     0.200
     5.995    19.009     0.200
     6.008    19.455     0.200
     6.413    17.836     0.200
     6.699    20.691     0.200
     6.753    18.659     0.200
     7.284    22.470     0.200
     8.023    21.836     0.200
     8.964    22.964     0.200
     1.616     9.192     0.200
     2.043     9.202     0.200
     2.155     8.903     0.200
     2.450    10.460     0.200
     2.542    10.381     0.200
     2.585    10.774     0.200
     3.039    13.586     0.200
     3.317    12.843     0.200
     3.457    14.206     0.200
     3.481    14.420     0.200
     3.466    13.598     0.200
     3.689    14.498     0.200
     3.753    13.954     0.200
     3.929    15.994     0.200
     4.074    15.707     0.200
     4.092    15.799     0.200
     4.138    13.353     0.200
     4.138    13.454     0.200
     4.170    14.087     0.200
     4.218    17.031     0.200
     4.245    15.007     0.200
     4.341    14.788     0.200
     4.480    17.261     0.200
     4.879    15.509     0.200
     4.957    17.301     0.200
     5.095    15.586     0.200
     5.208    15.767     0.200
     5.251    16.264     0.200
     5.316    18.004     0.200
     5.363    17.062     0.200
     5.533    17.076     0.200
     5.630    17.351     0.200
     5.781    16.782     0.200
     5.850    17.578     0.200
     5.887    18.550     0.200
     5.909    18.093     0.200
     5.923    17.819     0.200
     5.958    18.827     0.200
     6.097    19.196     0.200
     6.155    18.824     0.200
     6.154    18.233     0.200
     6.203    19.654     0.200
     6.232    20.117     0.200
     6.242    19.107     0.200
     6.259    20.300     0.200
     6.344    17.508     0.200
     6.402    19.638     0.200
     6.438    18.310     0.200
     6.455    20.518     0.200
     6.530    20.848     0.200
     6.541    18.712     0.200
     6.656    17.233     0.200
     6.688    19.345     0.200
     6.735    20.242     0.200
     6.780    20.031     0.200
     6.788    21.123     0.200
     6.874    21.625     0.200
     6.903    19.989     0.200
     6.918    21.818     0.200
     7.016    21.773     0.200
     7.060    20.300     0.200
     7.080    17.311     0.200
     7.238    19.983     0.200
     7.335    20.047     0.200
     7.356    19.909     0.200
     7.494    20.790     0.200
     7.511    21.598     0.200
     7.605    23.095     0.200
     7.609    20.255     0.200
     7.624    21.571     0.200
     8.261    22.641     0.200
     8.646    21.749     0.200
     8.814    23.191     0.200
     8.985    22.390     0.200
     9.111    26.719     0.200
     9.280    26.744     0.200
     9.661    23.597     0.200
     9.734    23.658     0.200
     9.942    23.527     0.200
    10.027    24.328     0.200
    10.252    27.402     0.200
    11.247    31.492     0.200
     1.826     9.766     0.200
     1.946    10.263     0.200
     2.079    10.311     0.200
     2.247    10.144     0.200
     2.325    11.940     0.200
     2.404    10.614     0.200
     2.384    10.753     0.200
     2.577    12.501     0.200
     2.842    12.703     0.200
     2.879    13.179     0.200
     3.232    13.855     0.200
     3.283    13.255     0.200
     3.585    13.731     0.200
     3.732    15.521     0.200
     3.833    14.840     0.200
     3.920    16.819     0.200
     3.981    15.210     0.200
     4.064    13.438     0.200
     4.176    16.841     0.200
     4.380    14.853     0.200
     4.392    18.318     0.200
     4.374    17.027     0.200
     4.386    17.389     0.200
     4.435    15.216     0.200
     4.771    15.895     0.200
     4.766    15.955     0.200
     4.807    16.477     0.200
     4.983    18.211     0.200
     5.046    15.587     0.200
     5.456    18.297     0.200
     5.938    18.777     0.200
     6.073    19.602     0.200
     6.193    20.505     0.200
     6.284    20.939     0.200
     7.488    21.385     0.200
     8.350    22.131     0.200
     1.670     7.868     0.200
     1.582     8.186     0.200
     1.668     8.387     0.200
     1.862     8.817     0.200
     2.000     9.009     0.200
     1.903     9.941     0.200
     2.084    11.734     0.200
     2.188     9.418     0.200
     2.485     9.851     0.200
     2.716     9.458     0.200
     2.655    10.963     0.200
     2.997    10.975     0.200
     3.032    13.770     0.200
     3.061    11.032     0.200
     3.231    11.140     0.200
     3.299    11.252     0.200
     3.542    11.813     0.200
     3.444    12.361     0.200
     3.550    12.421     0.200
     3.579    12.585     0.200
     3.648    15.281     0.200
     3.835    13.998     0.200
     4.053    13.152     0.200
     4.180    11.775     0.200
     4.124    13.324     0.200
     4.246    14.103     0.200
     4.177    13.510     0.200
     4.281    12.697     0.200
     4.542    14.449     0.200
     4.595    16.529     0.200
     4.618    13.161     0.200
     4.542    15.247     0.200
     4.833    14.753     0.200
     4.896    16.014     0.200
     4.923    15.097     0.200
     5.060    16.803     0.200
     5.400    15.338     0.200
     5.635    14.895     0.200
     5.917    16.596     0.200
     6.017    17.929     0.200
     6.017    19.328     0.200
     6.071    18.305     0.200
     6.492    17.887     0.200
     6.518    17.086     0.200
     6.518    20.093     0.200
     6.591    19.341     0.200
     6.657    18.563     0.200
     6.711    21.037     0.200
     7.292    20.250     0.200
     8.027    21.280     0.200
     8.107    21.145     0.200
     9.009    22.413     0.200
    10.235    25.106     0.200
     1.710    10.225     0.200
     1.722    10.479     0.200
     2.024    10.860     0.200
     2.143    11.267     0.200
     2.122    11.721     0.200
     2.349    12.970     0.200
     2.561    11.195     0.200
     2.764    12.623     0.200
     2.872    13.567     0.200
     3.005    14.420     0.200
     3.158    14.530     0.200
     3.198    14.063     0.200
     3.195    14.792     0.200
     3.203    14.499     0.200
     3.459    15.114     0.200
     3.471    15.678     0.200
     3.545    15.513     0.200
     3.608    15.677     0.200
     3.805    14.978     0.200
     3.790    18.653     0.200
     3.923    15.203     0.200
     3.917    15.065     0.200
     3.940    16.697     0.200
     4.006    16.133     0.200
     4.089    16.767     0.200
     4.116    16.849     0.200
     4.237    16.040     0.200
     4.236    16.348     0.200
     4.339    16.849     0.200
     4.338    17.654     0.200
     4.411    18.302     0.200
     4.486    17.528     0.200
     4.523    17.501     0.200
     4.544    17.757     0.200
     4.642    18.409     0.200
     4.757    18.326     0.200
     5.023    16.565     0.200
     5.092    17.556     0.200
     5.124    19.844     0.200
     5.252    16.787     0.200
     5.566    18.028     0.200
     5.636    19.008     0.200
     5.815    19.915     0.200
     5.864    20.053     0.200
     5.951    20.837     0.200
     6.108    21.318     0.200
     6.136    22.670     0.200
     6.211    21.294     0.200
     6.260    19.025     0.200
     6.212    21.151     0.200
     6.298    20.187     0.200
     6.375    22.607     0.200
     6.433    20.510     0.200
     6.598    21.244     0.200
     6.738    21.934     0.200
     6.988    19.931     0.200
     7.010    20.683     0.200
     7.034    22.432     0.200
     7.159    22.777     0.200
     7.649    23.022     0.200
     8.437    24.222     0.200
     8.649    23.444     0.200
     8.771    25.425     0.200
     1.292     8.248     0.200
     1.453     7.468     0.200
     1.880     8.987     0.200
     1.732     8.519     0.200
     1.784     7.316     0.200
     2.350    10.106     0.200
     2.227    10.539     0.200
     2.350    11.298     0.200
     2.508    10.267     0.200
     2.499    11.870     0.200
     2.675    10.814     0.200
     2.661    10.270     0.200
     2.722    10.863     0.200
     2.722    10.563     0.200
     2.985    11.990     0.200
     2.959    11.893     0.200
     3.008    11.533     0.200
     3.216    13.191     0.200
     3.058    11.949     0.200
     3.270    13.658     0.200
     3.199    11.594     0.200
     3.163    14.370     0.200
     3.416    14.069     0.200
     3.368    13.524     0.200
     3.651    13.319     0.200
     3.521    12.835     0.200
     3.598    14.835     0.200
     3.611    14.784     0.200
     3.927    15.002     0.200
     3.927    15.596     0.200
     3.997    12.290     0.200
     3.830    13.338     0.200
     4.013    14.502     0.200
     4.047    13.901     0.200
     4.090    13.802     0.200
     3.943    13.916     0.200
     4.220    14.182     0.200
     4.286    14.204     0.200
     4.082    14.796     0.200
     4.127    14.869     0.200
     4.375    15.573     0.200
     4.671    15.914     0.200
     4.739    14.723     0.200
     4.645    15.930     0.200
     4.922    14.092     0.200
     5.056    14.221     0.200
     5.064    14.936     0.200
     5.119    17.187     0.200
     5.188    17.391     0.200
     5.688    17.249     0.200
     5.520    17.010     0.200
     5.845    17.715     0.200
     5.775    17.428     0.200
     5.985    18.192     0.200
     5.874    18.883     0.200
     6.067    18.126     0.200
     6.062    18.884     0.200
     6.083    18.234     0.200
     6.100    21.346     0.200
     5.979    18.654     0.200
     6.215    18.300     0.200
     6.227    18.661     0.200
     6.247    16.829     0.200
     6.457    16.969     0.200
     6.541    20.198     0.200
     6.374    19.048     0.200
     6.596    19.661     0.200
     6.688    20.282     0.200
     6.708    17.347     0.200
     6.724    19.356     0.200
     6.988    21.840     0.200
     7.042    18.650     0.200
     7.074    18.771     0.200
     7.137    18.437     0.200
     7.158    18.502     0.200
     7.370    19.424     0.200
     7.595    20.793     0.200
     8.457    20.338     0.200
     8.630    21.220     0.200
     8.583    26.268     0.200
     8.796    21.078     0.200
     9.463    22.492     0.200
     9.536    22.342     0.200
     9.745    22.806     0.200
     9.829    22.622     0.200
     9.857    22.895     0.200
    10.049    23.957     0.200
    19.369    37.388     0.200
     1.699    11.441     0.200
     1.700    11.128     0.200
     1.740    11.962     0.200
     2.041    11.154     0.200
     2.202    12.372     0.200
     2.039    12.477     0.200
     2.185    14.273     0.200
     2.381    11.879     0.200
     2.856    15.408     0.200
     3.280    14.798     0.200
     3.341    13.980     0.200
     3.517    16.331     0.200
     3.568    16.232     0.200
     3.416    17.411     0.200
     3.535    15.511     0.200
     3.699    15.998     0.200
     3.926    16.052     0.200
     4.069    17.486     0.200
     4.204    18.209     0.200
     4.344    16.875     0.200
     4.335    18.275     0.200
     4.257    16.908     0.200
     4.511    16.628     0.200
     4.588    16.728     0.200
     4.588    17.927     0.200
     4.511    19.123     0.200
     4.557    17.947     0.200
     5.367    17.642     0.200
     5.375    17.446     0.200
     5.411    19.320     0.200
     5.555    19.727     0.200
     5.735    20.847     0.200
     5.876    21.201     0.200
     5.860    20.977     0.200
     6.299    23.766     0.200
     6.223    21.151     0.200
     6.454    19.653     0.200
     6.478    21.370     0.200
     6.959    22.563     0.200
     7.368    21.488     0.200
     7.368    20.388     0.200
     7.664    21.834     0.200
     8.943    24.605     0.200
     9.105    24.418     0.200
    10.038    26.123     0.200
     1.677     8.973     0.200
     1.886     9.531     0.200
     2.013     9.551     0.200
     2.029     9.257     0.200
     2.009    10.994     0.200
     2.158    10.755     0.200
     2.388     9.968     0.200
     2.383    12.331     0.200
     2.823    14.256     0.200
     3.227    11.581     0.200
     3.283    13.127     0.200
     3.287    12.675     0.200
     3.373    14.282     0.200
     3.573    13.244     0.200
     3.496    13.842     0.200
     3.846    12.261     0.200
     3.819    14.864     0.200
     3.970    14.212     0.200
     4.098    15.210     0.200
     4.336    13.339     0.200
     4.267    14.963     0.200
     4.551    14.629     0.200
     4.550    16.839     0.200
     4.624    14.775     0.200
     5.320    17.207     0.200
     5.397    14.950     0.200
     5.388    15.559     0.200
     5.405    17.458     0.200
     5.568    19.065     0.200
     5.733    17.738     0.200
     6.326    21.116     0.200
     7.407    19.399     0.200
     7.407    19.298     0.200
     7.703    19.549     0.200
     8.778    22.298     0.200
     8.958    22.395     0.200
     9.116    22.557     0.200
    10.040    26.371     0.200
    18.653    41.054     0.200
     2.038    10.925     0.200
     2.069    10.158     0.200
     2.241    10.353     0.200
     2.281    12.386     0.200
     2.278    10.824     0.200
     2.359    11.178     0.200
     2.542    12.543     0.200
     2.577    12.028     0.200
     2.609    12.059     0.200
     2.746    12.155     0.200
     2.730    12.238     0.200
     2.995    13.001     0.200
     3.030    13.847     0.200
     3.040    14.027     0.200
     3.049    14.124     0.200
     3.152    14.313     0.200
     3.294    13.761     0.200
     3.411    14.003     0.200
     3.628    15.264     0.200
     3.638    13.450     0.200
     3.687    14.971     0.200
     3.673    14.243     0.200
     3.739    14.863     0.200
     3.716    14.043     0.200
     3.776    15.138     0.200
     4.037    15.383     0.200
     4.048    15.965     0.200
     4.117    15.054     0.200
     4.278    16.173     0.200
     4.375    16.442     0.200
     4.360    15.820     0.200
     4.481    15.813     0.200
     4.472    15.314     0.200
     4.868    15.286     0.200
     5.152    17.676     0.200
     5.230    16.069     0.200
     5.290    16.070     0.200
     5.299    16.968     0.200
     5.327    18.040     0.200
     5.431    16.828     0.200
     5.544    18.705     0.200
     5.661    19.337     0.200
     6.138    18.970     0.200
     6.249    19.079     0.200
     6.331    19.817     0.200
     6.365    19.821     0.200
     6.387    20.669     0.200
     6.508    20.751     0.200
     6.530    21.003     0.200
     6.634    18.786     0.200
     6.857    21.187     0.200
     7.047    21.762     0.200
     7.072    21.871     0.200
     7.200    23.181     0.200
     7.217    20.681     0.200
     7.217    20.080     0.200
     7.454    20.320     0.200
     7.506    23.508     0.200
     7.514    21.512     0.200
     7.572    19.634     0.200
     7.592    20.304     0.200
     8.828    22.971     0.200
     8.977    23.538     0.200
     9.895    24.626     0.200
     9.960    24.264     0.200
    10.164    24.990     0.200
    10.164    26.389     0.200
    10.261    26.558     0.200
    10.283    24.998     0.200
    10.488    24.808     0.200
     1.792    11.035     0.200
     2.057    10.743     0.200
     2.171    11.323     0.200
     2.265    12.724     0.200
     2.257    11.415     0.200
     2.529    13.438     0.200
     2.527    12.164     0.200
     2.598    12.839     0.200
     3.016    14.753     0.200
     3.006    14.069     0.200
     3.141    14.294     0.200
     3.170    14.558     0.200
     3.686    14.735     0.200
     3.663    14.211     0.200
     3.728    15.353     0.200
     3.728    13.549     0.200
     3.770    15.157     0.200
     4.025    15.785     0.200
     4.104    14.655     0.200
     4.350    15.494     0.200
     4.462    14.980     0.200
     4.273    15.386     0.200
     5.224    15.689     0.200
     5.427    16.523     0.200
     5.544    18.458     0.200
     5.295    16.965     0.200
     5.660    18.900     0.200
     6.022    18.582     0.200
     6.241    19.619     0.200
     6.324    20.056     0.200
     6.546    18.559     0.200
     6.572    20.452     0.200
     6.631    18.868     0.200
     7.043    22.262     0.200
     7.207    20.256     0.200
     7.207    19.756     0.200
     7.502    23.099     0.200
     7.572    20.689     0.200
     7.731    22.529     0.200
     8.973    24.143     0.200
     9.166    23.785     0.200
     9.895    24.282     0.200
    10.163    26.155     0.200
    10.488    26.555     0.200
    19.144    40.145     0.200
     1.550     7.821     0.200
     1.705     9.308     0.200
     2.072    10.420     0.200
     2.190     9.649     0.200
     2.381    10.420     0.200
     2.409    10.291     0.200
     2.748    11.235     0.200
     2.636    11.243     0.200
     2.668    11.769     0.200
     2.724    11.717     0.200
     2.905    12.792     0.200
     3.089    10.557     0.200
     3.301    12.984     0.200
     3.162    12.906     0.200
     3.398    12.850     0.200
     3.269    13.559     0.200
     3.305    13.241     0.200
     3.623    14.122     0.200
     3.680    13.867     0.200
     3.519    12.640     0.200
     3.614    13.428     0.200
     3.754    12.301     0.200
     3.661    13.684     0.200
     3.837    13.536     0.200
     3.850    14.675     0.200
     4.104    14.829     0.200
     4.226    13.884     0.200
     4.272    13.558     0.200
     4.464    14.612     0.200
     4.447    14.712     0.200
     4.346    15.412     0.200
     4.384    15.551     0.200
     4.548    14.036     0.200
     4.768    16.761     0.200
     5.070    17.113     0.200
     5.115    16.214     0.200
     5.353    15.234     0.200
     5.448    15.828     0.200
     5.533    17.938     0.200
     5.356    17.003     0.200
     5.401    18.675     0.200
     5.694    18.808     0.200
     6.082    17.725     0.200
     6.189    18.086     0.200
     6.417    19.919     0.200
     6.552    17.846     0.200
     6.596    19.226     0.200
     6.642    17.990     0.200
     6.569    19.742     0.200
     6.868    17.554     0.200
     6.963    20.945     0.200
     7.016    20.025     0.200
     7.068    20.921     0.200
     7.146    21.517     0.200
     7.305    20.259     0.200
     7.305    20.157     0.200
     7.450    20.065     0.200
     7.522    21.928     0.200
     7.555    18.843     0.200
     7.575    19.104     0.200
     7.725    21.351     0.200
     7.971    21.381     0.200
     8.686    20.646     0.200
     8.845    21.887     0.200
     8.922    22.390     0.200
     9.004    22.235     0.200
     9.185    22.319     0.200
     9.880    23.105     0.200
     9.950    23.287     0.200
    10.246    24.335     0.200
    10.272    23.734     0.200
    10.468    24.544     0.200
    11.209    26.703     0.200
    20.757    38.873     0.200
     1.975    11.552     0.200
     2.244    13.416     0.200
     2.416    12.708     0.200
     2.722    13.238     0.200
     2.814    13.754     0.200
     2.996    15.140     0.200
     3.012    13.944     0.200
     3.009    14.982     0.200
     3.247    15.612     0.200
     3.269    14.949     0.200
     3.282    15.597     0.200
     3.354    15.258     0.200
     3.641    13.710     0.200
     3.733    16.035     0.200
     3.756    17.169     0.200
     3.770    14.804     0.200
     3.898    16.510     0.200
     3.926    16.778     0.200
     3.945    15.761     0.200
     4.070    17.404     0.200
     4.157    16.888     0.200
     4.330    16.862     0.200
     4.459    18.359     0.200
     4.407    16.074     0.200
     4.484    19.465     0.200
     4.606    18.050     0.200
     4.524    16.806     0.200
     4.910    19.303     0.200
     4.903    18.685     0.200
     4.945    18.615     0.200
     5.062    16.827     0.200
     5.141    17.599     0.200
     5.349    20.177     0.200
     5.528    20.080     0.200
     5.624    20.171     0.200
     5.681    19.700     0.200
     5.765    19.924     0.200
     5.907    22.269     0.200
     5.963    19.611     0.200
     5.935    20.173     0.200
     6.027    19.027     0.200
     6.218    21.673     0.200
     6.158    23.231     0.200
     6.242    21.355     0.200
     6.241    22.173     0.200
     6.416    19.719     0.200
     6.458    21.634     0.200
     6.592    21.974     0.200
     6.553    21.050     0.200
     6.736    22.290     0.200
     6.980    21.583     0.200
     7.110    19.430     0.200
     7.131    19.884     0.200
     7.393    22.127     0.200
     7.328    21.276     0.200
     7.622    22.446     0.200
     8.479    23.943     0.200
     8.719    22.448     0.200
     8.855    22.258     0.200
     2.112    10.883     0.200
     2.361    11.069     0.200
     2.955    13.438     0.200
     3.000    12.914     0.200
     3.204    13.336     0.200
     3.258    14.905     0.200
     3.254    14.151     0.200
     3.410    14.134     0.200
     3.350    13.926     0.200
     3.471    15.414     0.200
     3.632    14.041     0.200
     3.678    14.501     0.200
     3.833    14.199     0.200
     3.902    17.989     0.200
     3.997    16.881     0.200
     4.060    15.747     0.200
     4.158    15.801     0.200
     4.215    15.534     0.200
     4.282    15.651     0.200
     4.262    14.493     0.200
     4.327    18.429     0.200
     4.716    18.490     0.200
     4.722    17.014     0.200
     4.776    17.991     0.200
     5.144    16.290     0.200
     5.247    18.750     0.200
     5.259    19.050     0.200
     5.408    17.611     0.200
     5.808    21.051     0.200
     5.780    18.176     0.200
     5.997    19.475     0.200
     6.070    20.189     0.200
     6.096    19.280     0.200
     6.201    21.463     0.200
     6.213    21.395     0.200
     6.205    18.109     0.200
     6.234    17.977     0.200
     6.275    21.498     0.200
     6.303    20.872     0.200
     6.341    20.627     0.200
     6.372    18.963     0.200
     6.442    22.683     0.200
     6.459    21.153     0.200
     6.483    21.166     0.200
     6.495    21.233     0.200
     6.587    21.851     0.200
     6.736    21.313     0.200
     6.730    21.523     0.200
     6.879    21.986     0.200
     7.238    23.153     0.200
     7.511    24.375     0.200
     7.538    21.253     0.200
     7.538    20.452     0.200
     7.640    22.471     0.200
     7.830    22.047     0.200
     7.898    23.154     0.200
     8.503    24.401     0.200
     8.671    24.436     0.200
     8.732    24.426     0.200
     8.892    28.659     0.200
     9.529    26.423     0.200
    14.128    34.148     0.200
     1.437     8.981     0.200
     1.459     6.826     0.200
     1.741     8.840     0.200
     1.832     8.381     0.200
     2.125     7.959     0.200
     2.295    10.372     0.200
     2.292    10.608     0.200
     2.664    11.072     0.200
     2.710    12.026     0.200
     2.825    11.488     0.200
     2.881    10.631     0.200
     2.921    11.568     0.200
     3.029    11.704     0.200
     3.060    13.043     0.200
     3.160    12.381     0.200
     3.173    12.424     0.200
     3.195    12.468     0.200
     3.421    14.633     0.200
     3.463    13.542     0.200
     3.676    13.454     0.200
     3.715    14.105     0.200
     3.718    13.667     0.200
     3.778    13.666     0.200
     3.870    14.790     0.200
     4.178    15.229     0.200
     4.597    15.866     0.200
     4.855    17.896     0.200
     4.907    15.595     0.200
     4.920    16.244     0.200
     5.352    16.905     0.200
     5.458    17.359     0.200
     5.513    15.719     0.200
     5.560    17.407     0.200
     5.799    18.420     0.200
     6.399    18.778     0.200
     6.489    18.652     0.200
     6.628    18.382     0.200
     6.839    18.747     0.200
     6.873    19.449     0.200
     7.009    19.957     0.200
     7.439    22.749     0.200
     7.570    20.119     0.200
     7.591    20.170     0.200
     7.709    19.187     0.200
     8.005    21.139     0.200
     8.947    21.545     0.200
     9.323    21.457     0.200
     1.619     9.288     0.200
     1.881    10.034     0.200
     1.917    10.717     0.200
     2.314    11.678     0.200
     2.246    11.582     0.200
     2.431    11.320     0.200
     2.541    12.636     0.200
     2.601    11.328     0.200
     2.725    13.384     0.200
     2.747    13.327     0.200
     2.989    13.100     0.200
     3.054    13.343     0.200
     3.019    13.257     0.200
     3.055    12.745     0.200
     3.290    14.391     0.200
     3.342    15.085     0.200
     3.213    14.589     0.200
     3.556    16.093     0.200
     3.474    14.145     0.200
     3.512    14.305     0.200
     3.625    13.684     0.200
     3.580    14.515     0.200
     3.628    16.141     0.200
     3.765    15.148     0.200
     3.718    14.196     0.200
     3.718    14.200     0.200
     3.822    17.168     0.200
     3.854    15.506     0.200
     3.983    15.102     0.200
     3.912    15.428     0.200
     3.904    15.524     0.200
     4.106    13.964     0.200
     4.125    14.738     0.200
     4.078    15.389     0.200
     4.203    14.835     0.200
     4.296    15.811     0.200
     4.333    15.522     0.200
     4.245    15.649     0.200
     4.397    14.670     0.200
     4.425    16.494     0.200
     4.350    16.616     0.200
     4.376    16.518     0.200
     4.672    16.857     0.200
     4.692    16.933     0.200
     4.696    15.077     0.200
     4.636    16.981     0.200
     4.679    17.414     0.200
     4.655    17.262     0.200
     4.741    17.363     0.200
     4.762    17.518     0.200
     5.020    15.508     0.200
     5.150    16.194     0.200
     5.163    15.835     0.200
     5.186    18.459     0.200
     5.161    18.859     0.200
     5.505    17.950     0.200
     5.449    18.289     0.200
     5.465    18.011     0.200
     5.626    18.715     0.200
     5.672    16.592     0.200
     5.536    17.773     0.200
     5.702    18.743     0.200
     5.743    18.666     0.200
     5.749    18.704     0.200
     5.915    20.915     0.200
     5.773    20.615     0.200
     5.949    19.933     0.200
     5.957    21.414     0.200
     5.944    18.122     0.200
     6.061    21.655     0.200
     6.021    18.525     0.200
     5.951    18.343     0.200
     6.104    19.554     0.200
     6.088    19.542     0.200
     6.047    19.019     0.200
     6.151    20.805     0.200
     6.143    19.892     0.200
     6.001    20.052     0.200
     6.170    19.875     0.200
     6.184    19.712     0.200
     6.072    19.622     0.200
     6.227    17.513     0.200
     6.209    19.921     0.200
     6.234    21.974     0.200
     6.279    22.104     0.200
     6.304    21.305     0.200
     6.301    19.650     0.200
     6.326    18.158     0.200
     6.328    20.444     0.200
     6.365    19.609     0.200
     6.413    20.348     0.200
     6.452    21.093     0.200
     6.369    19.961     0.200
     6.378    20.659     0.200
     6.462    19.679     0.200
     6.527    17.917     0.200
     6.530    18.214     0.200
     6.540    20.593     0.200
     6.575    19.751     0.200
     6.579    19.834     0.200
     6.573    21.080     0.200
     6.573    24.080     0.200
     6.626    20.058     0.200
     6.595    20.127     0.200
     6.715    18.329     0.200
     6.756    20.540     0.200
     6.775    21.628     0.200
     6.782    18.734     0.200
     6.703    21.857     0.200
     6.852    20.627     0.200
     6.917    21.475     0.200
     6.945    17.907     0.200
     7.005    23.235     0.200
     7.044    21.583     0.200
     7.017    20.305     0.200
     7.113    20.371     0.200
     7.199    19.777     0.200
     7.200    23.058     0.200
     7.187    20.515     0.200
     7.187    20.218     0.200
     7.220    20.035     0.200
     7.218    21.255     0.200
     7.088    20.665     0.200
     7.242    23.773     0.200
     7.110    22.112     0.200
     7.256    21.114     0.200
     7.383    22.023     0.200
     7.511    22.727     0.200
     7.482    20.669     0.200
     7.528    21.442     0.200
     7.586    21.059     0.200
     7.543    23.058     0.200
     7.692    21.428     0.200
     7.625    22.103     0.200
     7.636    21.969     0.200
     7.695    21.782     0.200
     7.779    22.310     0.200
     7.935    21.423     0.200
     7.811    23.430     0.200
     7.994    21.593     0.200
     8.169    21.554     0.200
     8.296    23.270     0.200
     8.265    22.635     0.200
     8.386    21.718     0.200
     8.308    27.127     0.200
     8.429    21.317     0.200
     8.500    21.494     0.200
     8.540    21.716     0.200
     8.511    26.267     0.200
     8.631    22.567     0.200
     8.685    23.136     0.200
     8.719    22.440     0.200
     8.640    27.261     0.200
     8.879    22.073     0.200
     8.884    24.303     0.200
     8.921    25.275     0.200
     8.785    25.566     0.200
     8.908    28.629     0.200
     9.137    27.452     0.200
     9.207    23.438     0.200
     9.250    24.341     0.200
     9.381    23.902     0.200
     9.289    24.678     0.200
     9.526    23.813     0.200
     9.454    25.758     0.200
     9.603    23.818     0.200
     9.700    26.084     0.200
     9.693    24.974     0.200
     9.729    26.554     0.200
     9.740    25.813     0.200
     9.790    27.444     0.200
     9.813    24.064     0.200
     9.892    24.547     0.200
     9.796    26.770     0.200
     9.923    24.686     0.200
    10.097    27.952     0.200
    10.108    25.727     0.200
    10.004    26.341     0.200
    10.156    26.768     0.200
    10.411    26.094     0.200
    10.397    30.555     0.200
    11.052    28.316     0.200
    11.306    29.146     0.200
    11.203    34.846     0.200
    11.458    31.372     0.200
    12.050    30.860     0.200
    12.799    30.522     0.200
    13.088    31.354     0.200
    14.694    37.210     0.200
    20.238    41.811     0.200
     1.600     9.471     0.200
     1.915    10.893     0.200
     1.963    11.334     0.200
     2.238    11.926     0.200
     2.296    11.352     0.200
     2.422    11.480     0.200
     2.591    13.001     0.200
     2.625    12.408     0.200
     2.777    14.029     0.200
     2.796    12.715     0.200
     2.981    12.852     0.200
     3.038    13.789     0.200
     3.065    13.268     0.200
     3.277    15.001     0.200
     3.506    16.825     0.200
     3.678    15.215     0.200
     3.646    13.190     0.200
     3.794    14.370     0.200
     3.960    15.719     0.200
     4.356    15.307     0.200
     4.356    17.908     0.200
     4.415    16.909     0.200
     4.655    16.922     0.200
     4.791    17.233     0.200
     5.022    15.633     0.200
     5.143    16.222     0.200
     5.169    18.617     0.200
     5.175    15.645     0.200
     5.466    18.146     0.200
     5.522    18.305     0.200
     5.663    16.754     0.200
     5.785    18.237     0.200
     5.800    20.460     0.200
     6.075    18.953     0.200
     6.096    19.604     0.200
     6.190    20.106     0.200
     6.215    18.408     0.200
     6.408    20.359     0.200
     6.510    18.867     0.200
     6.543    20.490     0.200
     6.592    20.510     0.200
     6.723    20.984     0.200
     6.827    20.474     0.200
     7.178    20.071     0.200
     7.199    20.626     0.200
     7.208    19.817     0.200
     7.486    21.986     0.200
     7.503    20.076     0.200
     8.153    20.998     0.200
     8.492    21.839     0.200
     8.532    22.274     0.200
     8.714    22.547     0.200
     8.870    22.729     0.200
     9.506    23.907     0.200
     9.584    23.392     0.200
     9.796    24.423     0.200
     9.872    24.939     0.200
     1.978    10.859     0.200
     2.214    11.511     0.200
     2.813    14.019     0.200
     2.898    12.621     0.200
     3.036    14.111     0.200
     3.226    14.698     0.200
     3.242    14.605     0.200
     3.289    13.850     0.200
     3.468    14.966     0.200
     3.510    15.681     0.200
     3.570    15.279     0.200
     3.766    17.290     0.200
     3.930    15.077     0.200
     4.016    16.872     0.200
     3.991    17.468     0.200
     4.115    17.021     0.200
     4.150    16.913     0.200
     4.193    18.210     0.200
     4.530    17.273     0.200
     4.583    14.359     0.200
     4.647    19.203     0.200
     4.669    16.954     0.200
     4.669    18.954     0.200
     4.624    18.679     0.200
     4.667    20.181     0.200
     4.698    18.591     0.200
     4.786    16.987     0.200
     5.015    19.610     0.200
     5.097    20.456     0.200
     5.099    19.091     0.200
     5.179    17.696     0.200
     5.260    18.049     0.200
     5.376    18.202     0.200
     5.443    18.621     0.200
     5.526    21.046     0.200
     5.489    21.087     0.200
     5.586    19.852     0.200
     5.597    19.842     0.200
     5.574    20.090     0.200
     5.698    19.947     0.200
     5.759    20.175     0.200
     5.771    20.610     0.200
     5.883    18.590     0.200
     5.846    20.162     0.200
     5.941    20.814     0.200
     6.040    21.267     0.200
     5.998    22.935     0.200
     6.068    20.432     0.200
     6.109    21.504     0.200
     6.073    21.585     0.200
     6.215    21.004     0.200
     6.199    21.201     0.200
     6.258    22.611     0.200
     6.274    22.429     0.200
     6.310    19.803     0.200
     6.319    18.798     0.200
     6.331    21.655     0.200
     6.332    21.853     0.200
     6.340    21.256     0.200
     6.352    18.909     0.200
     6.359    22.105     0.200
     6.317    22.421     0.200
     6.316    20.833     0.200
     6.320    23.144     0.200
     6.425    22.142     0.200
     6.453    22.535     0.200
     6.459    20.964     0.200
     6.476    22.162     0.200
     6.474    21.984     0.200
     6.489    19.620     0.200
     6.468    21.860     0.200
     6.468    21.656     0.200
     6.579    22.282     0.200
     6.678    21.710     0.200
     6.671    24.086     0.200
     6.756    23.122     0.200
     6.724    22.176     0.200
     6.805    23.125     0.200
     6.799    22.792     0.200
     6.890    25.637     0.200
     6.967    22.840     0.200
     7.075    21.783     0.200
     7.096    22.628     0.200
     7.166    23.513     0.200
     7.331    25.585     0.200
     7.379    24.825     0.200
     7.481    21.340     0.200
     7.506    24.050     0.200
     7.538    24.675     0.200
     7.538    24.175     0.200
     7.745    23.354     0.200
     7.774    22.024     0.200
     7.851    23.919     0.200
     7.943    25.948     0.200
     8.026    25.971     0.200
     8.091    23.218     0.200
     8.092    24.603     0.200
     8.106    23.843     0.200
     8.106    23.547     0.200
     8.148    27.054     0.200
     8.503    23.018     0.200
     8.642    25.287     0.200
     8.722    30.648     0.200
     8.829    30.109     0.200
     8.875    24.464     0.200
     8.941    29.799     0.200
     9.029    27.879     0.200
     9.160    29.343     0.200
     9.426    24.435     0.200
     9.422    28.180     0.200
     9.491    27.083     0.200
     9.493    28.357     0.200
     9.515    30.601     0.200
     9.719    26.827     0.200
     9.867    26.593     0.200
     9.981    27.659     0.200
    10.244    31.486     0.200
    11.587    31.919     0.200
    14.282    35.363     0.200
    18.576    41.456     0.200
    19.785    40.856     0.200
    20.714    42.308     0.200
    20.878    41.193     0.200
     1.473     9.963     0.200
     1.761    11.206     0.200
     1.907    12.202     0.200
     2.053    10.404     0.200
     2.249    12.012     0.200
     2.490    13.199     0.200
     2.874    13.316     0.200
     2.869    12.672     0.200
     4.015    17.509     0.200
     4.225    17.650     0.200
     4.321    16.538     0.200
     4.442    18.728     0.200
     4.733    19.123     0.200
     4.745    18.690     0.200
     4.758    18.269     0.200
     5.182    16.882     0.200
     5.190    19.716     0.200
     5.838    18.734     0.200
     5.941    19.829     0.200
     6.041    20.863     0.200
     6.155    21.211     0.200
     6.264    20.054     0.200
     6.309    23.335     0.200
     6.293    20.023     0.200
     6.377    21.735     0.200
     6.383    23.109     0.200
     6.431    21.411     0.200
     6.502    22.584     0.200
     6.520    23.775     0.200
     6.543    21.302     0.200
     6.673    21.761     0.200
     6.644    22.026     0.200
     6.706    19.100     0.200
     7.295    22.925     0.200
     7.560    22.035     0.200
     7.852    23.228     0.200
     8.080    23.162     0.200
     8.883    24.995     0.200
     1.794    10.755     0.200
     1.881    11.735     0.200
     1.988    10.984     0.200
     2.259    11.330     0.200
     2.818    14.001     0.200
     2.872    15.272     0.200
     3.070    14.258     0.200
     3.258    14.768     0.200
     3.281    15.102     0.200
     3.280    14.513     0.200
     3.454    14.983     0.200
     3.496    15.186     0.200
     3.546    15.805     0.200
     3.602    15.548     0.200
     3.927    17.466     0.200
     3.970    17.664     0.200
     4.029    15.873     0.200
     4.029    17.567     0.200
     4.171    15.816     0.200
     4.148    17.186     0.200
     4.171    18.412     0.200
     4.185    17.350     0.200
     4.378    15.893     0.200
     4.574    17.109     0.200
     4.649    15.831     0.200
     4.644    18.393     0.200
     4.687    18.887     0.200
     4.706    16.964     0.200
     4.706    18.764     0.200
     4.703    18.581     0.200
     4.897    17.112     0.200
     5.124    19.292     0.200
     5.124    20.792     0.200
     5.117    19.191     0.200
     5.170    17.459     0.200
     5.410    19.054     0.200
     5.485    17.576     0.200
     5.592    19.531     0.200
     5.883    18.636     0.200
     5.866    20.337     0.200
     5.963    21.501     0.200
     6.096    20.349     0.200
     6.087    21.060     0.200
     6.220    20.600     0.200
     6.289    22.793     0.200
     6.278    22.973     0.200
     6.315    18.790     0.200
     6.361    21.952     0.200
     6.347    19.021     0.200
     6.334    20.992     0.200
     6.326    23.241     0.200
     6.499    20.447     0.200
     6.500    22.530     0.200
     6.484    19.520     0.200
     6.498    21.756     0.200
     6.619    19.850     0.200
     6.599    21.941     0.200
     6.682    22.708     0.200
     6.746    21.579     0.200
     6.824    22.257     0.200
     6.896    26.636     0.200
     7.015    22.680     0.200
     7.105    22.778     0.200
     7.150    23.147     0.200
     7.195    23.620     0.200
     7.335    22.693     0.200
     7.519    22.239     0.200
     7.551    22.966     0.200
     7.812    22.923     0.200
     7.888    24.338     0.200
     8.093    24.440     0.200
     8.103    24.522     0.200
     8.521    21.645     0.200
     8.634    25.028     0.200
     8.662    27.501     0.200
     8.676    22.543     0.200
     8.894    24.100     0.200
     9.199    27.740     0.200
     9.526    28.015     0.200
     9.532    27.246     0.200
    14.261    35.163     0.200
    19.823    42.053     0.200
     1.520     9.837     0.200
     2.012    11.793     0.200
     2.053    12.020     0.200
     2.149    12.297     0.200
     2.266    12.032     0.200
     2.265    10.838     0.200
     2.333    10.744     0.200
     2.766    13.391     0.200
     2.816    12.816     0.200
     3.099    13.412     0.200
     3.273    14.182     0.200
     3.456    14.441     0.200
     3.473    14.740     0.200
     3.649    15.685     0.200
     3.735    15.083     0.200
     3.814    15.561     0.200
     4.094    16.401     0.200
     4.099    15.839     0.200
     4.182    17.365     0.200
     4.199    15.977     0.200
     4.358    16.915     0.200
     4.383    16.627     0.200
     4.572    18.520     0.200
     4.577    18.961     0.200
     4.905    19.138     0.200
     4.966    16.421     0.200
     4.973    18.939     0.200
     5.244    18.280     0.200
     5.602    18.494     0.200
     5.651    21.422     0.200
     6.034    19.055     0.200
     6.066    19.482     0.200
     6.203    20.283     0.200
     6.217    20.023     0.200
     6.405    19.330     0.200
     6.477    22.071     0.200
     7.057    20.822     0.200
     7.417    22.615     0.200
     7.680    23.045     0.200
     8.545    23.459     0.200
     1.383     9.570     0.200
     1.445     9.111     0.200
     1.386     7.509     0.200
     1.585     8.281     0.200
     1.738    10.092     0.200
     2.175     9.694     0.200
     2.107    11.291     0.200
     2.389    10.200     0.200
     2.369    10.224     0.200
     2.265    10.251     0.200
     2.726    11.362     0.200
     2.651    11.248     0.200
     2.630    10.493     0.200
     2.712    10.934     0.200
     3.278    13.430     0.200
     2.939    11.983     0.200
     3.141    13.523     0.200
     3.118    12.890     0.200
     3.100    13.103     0.200
     3.256    13.682     0.200
     3.289    13.990     0.200
     3.603    14.829     0.200
     3.720    12.873     0.200
     3.801    13.716     0.200
     3.590    12.984     0.200
     3.530    13.881     0.200
     3.546    13.020     0.200
     3.561    12.127     0.200
     3.649    13.083     0.200
     3.677    13.961     0.200
     3.718    15.888     0.200
     4.131    13.671     0.200
     3.865    15.011     0.200
     4.239    13.456     0.200
     3.951    15.154     0.200
     4.259    14.480     0.200
     4.333    15.715     0.200
     4.412    14.383     0.200
     4.435    14.531     0.200
     4.446    15.088     0.200
     4.120    14.918     0.200
     4.514    14.195     0.200
     4.265    15.306     0.200
     4.350    15.198     0.200
     4.404    16.724     0.200
     4.397    15.766     0.200
     4.634    15.995     0.200
     4.554    17.530     0.200
     4.889    14.726     0.200
     4.948    15.331     0.200
     4.991    14.726     0.200
     4.653    16.672     0.200
     4.695    15.888     0.200
     4.775    16.853     0.200
     5.081    16.783     0.200
     5.241    15.311     0.200
     5.321    15.477     0.200
     5.072    16.249     0.200
     5.423    16.389     0.200
     5.137    16.631     0.200
     5.514    18.322     0.200
     5.534    16.498     0.200
     5.627    17.011     0.200
     5.640    17.475     0.200
     5.363    17.375     0.200
     5.408    17.484     0.200
     5.491    18.496     0.200
     5.416    18.870     0.200
     5.559    16.770     0.200
     5.619    18.503     0.200
     5.973    17.351     0.200
     6.052    18.054     0.200
     5.707    18.950     0.200
     6.061    18.566     0.200
     6.095    18.343     0.200
     5.806    18.277     0.200
     6.173    19.148     0.200
     6.220    18.390     0.200
     5.934    17.949     0.200
     6.273    18.477     0.200
     5.985    19.032     0.200
     5.978    18.311     0.200
     6.285    18.798     0.200
     6.308    19.066     0.200
     6.339    18.808     0.200
     6.355    19.113     0.200
     6.390    19.706     0.200
     6.475    20.716     0.200
     6.528    19.500     0.200
     6.571    19.492     0.200
     6.320    20.326     0.200
     6.282    18.481     0.200
     6.620    18.124     0.200
     6.598    19.702     0.200
     6.664    20.106     0.200
     6.664    20.911     0.200
     6.668    19.687     0.200
     6.384    18.780     0.200
     6.849    17.756     0.200
     6.851    17.470     0.200
     6.899    18.754     0.200
     6.591    20.662     0.200
     6.954    20.124     0.200
     6.718    20.678     0.200
     7.026    18.886     0.200
     7.043    21.286     0.200
     6.710    20.176     0.200
     7.009    21.085     0.200
     7.092    18.313     0.200
     7.175    21.045     0.200
     7.185    19.835     0.200
     7.137    21.387     0.200
     7.208    19.757     0.200
     7.229    23.417     0.200
     7.269    18.854     0.200
     7.281    16.495     0.200
     7.310    20.869     0.200
     7.385    23.796     0.200
     7.430    19.670     0.200
     7.477    20.316     0.200
     7.497    20.981     0.200
     7.250    19.973     0.200
     7.186    21.013     0.200
     7.537    19.218     0.200
     7.563    20.917     0.200
     7.558    19.378     0.200
     7.567    20.268     0.200
     7.242    21.467     0.200
     7.575    25.385     0.200
     7.614    21.319     0.200
     7.624    24.507     0.200
     7.694    20.590     0.200
     7.706    21.854     0.200
     7.704    20.881     0.200
     7.677    25.691     0.200
     7.721    21.672     0.200
     7.790    21.869     0.200
     7.819    23.030     0.200
     7.795    25.111     0.200
     7.869    22.351     0.200
     7.899    19.393     0.200
     7.901    21.271     0.200
     7.867    25.572     0.200
     7.691    23.325     0.200
     7.945    21.260     0.200
     8.066    21.735     0.200
     8.076    22.829     0.200
     8.157    22.880     0.200
     8.213    21.228     0.200
     8.254    21.759     0.200
     8.314    21.557     0.200
     8.351    21.325     0.200
     8.336    26.293     0.200
     8.487    21.240     0.200
     8.499    21.794     0.200
     8.496    22.326     0.200
     8.309    25.219     0.200
     8.661    22.006     0.200
     8.660    23.308     0.200
     8.759    21.264     0.200
     8.779    21.724     0.200
     8.896    22.759     0.200
     8.942    23.325     0.200
     8.978    23.208     0.200
     9.061    24.239     0.200
     9.036    26.025     0.200
     9.158    24.206     0.200
     9.161    22.671     0.200
     9.374    23.288     0.200
     9.139    24.421     0.200
     9.731    23.720     0.200
     9.737    24.344     0.200
     9.862    23.189     0.200
     9.963    25.788     0.200
     9.963    26.109     0.200
    10.024    26.852     0.200
    10.137    23.575     0.200
    10.115    28.032     0.200
    10.228    23.512     0.200
    10.253    23.722     0.200
    10.451    24.313     0.200
    10.468    27.413     0.200
    10.761    26.195     0.200
    11.571    27.143     0.200
    12.405    29.019     0.200
    13.124    32.124     0.200
    13.412    31.457     0.200
    13.484    32.518     0.200
    14.487    33.909     0.200
    19.389    38.809     0.200
    19.545    38.691     0.200
     1.374     7.017     0.200
     1.751     9.417     0.200
     2.124    10.394     0.200
     2.307    10.237     0.200
     2.136     9.133     0.200
     2.399    10.564     0.200
     2.253     9.661     0.200
     2.331     9.351     0.200
     2.348     9.956     0.200
     2.735    10.636     0.200
     2.594    10.584     0.200
     2.610    10.895     0.200
     2.673    11.162     0.200
     2.957    13.473     0.200
     3.100    12.778     0.200
     3.079    11.323     0.200
     3.286    12.711     0.200
     3.217    13.510     0.200
     3.249    13.536     0.200
     3.614    13.784     0.200
     3.509    12.606     0.200
     3.704    12.730     0.200
     3.662    13.618     0.200
     3.985    13.850     0.200
     4.227    12.931     0.200
     4.104    14.340     0.200
     4.350    14.890     0.200
     4.230    15.694     0.200
     4.461    14.301     0.200
     4.395    14.768     0.200
     4.322    15.079     0.200
     4.500    13.937     0.200
     4.378    15.462     0.200
     4.883    14.068     0.200
     4.750    16.127     0.200
     4.979    14.645     0.200
     5.109    16.238     0.200
     5.042    15.088     0.200
     5.239    15.018     0.200
     5.129    15.703     0.200
     5.312    15.468     0.200
     5.428    15.693     0.200
     5.527    17.656     0.200
     5.338    16.866     0.200
     5.377    16.206     0.200
     5.510    16.050     0.200
     5.399    18.245     0.200
     5.614    16.946     0.200
     5.457    17.878     0.200
     5.582    17.415     0.200
     5.688    18.252     0.200
     5.776    17.186     0.200
     6.113    17.620     0.200
     5.902    16.959     0.200
     5.951    18.305     0.200
     6.201    18.188     0.200
     6.266    19.534     0.200
     6.348    19.269     0.200
     6.391    19.573     0.200
     6.449    20.591     0.200
     6.256    18.225     0.200
     6.497    19.439     0.200
     6.283    19.235     0.200
     6.511    22.273     0.200
     6.540    20.032     0.200
     6.523    20.037     0.200
     6.578    22.987     0.200
     6.356    18.905     0.200
     6.575    18.725     0.200
     6.627    17.623     0.200
     6.665    21.374     0.200
     6.829    20.708     0.200
     6.849    21.122     0.200
     6.860    17.597     0.200
     6.684    20.555     0.200
     6.978    21.821     0.200
     7.034    21.274     0.200
     7.046    20.726     0.200
     7.102    18.179     0.200
     7.162    21.577     0.200
     7.226    18.928     0.200
     7.440    18.927     0.200
     7.502    20.502     0.200
     7.552    18.225     0.200
     7.572    18.787     0.200
     7.572    19.687     0.200
     7.550    19.952     0.200
     7.588    21.208     0.200
     7.717    19.994     0.200
     7.717    20.593     0.200
     7.887    21.213     0.200
     7.946    20.425     0.200
     8.129    22.396     0.200
     8.498    20.487     0.200
     8.503    21.229     0.200
     8.680    22.658     0.200
     8.665    21.236     0.200
     8.784    20.944     0.200
     8.899    22.004     0.200
     8.944    22.281     0.200
     8.979    21.065     0.200
     9.059    25.232     0.200
     9.166    21.089     0.200
     9.360    26.229     0.200
     9.876    22.502     0.200
    10.142    28.001     0.200
    10.149    22.520     0.200
    10.242    23.130     0.200
    10.266    22.653     0.200
    10.467    23.610     0.200
     2.370    11.512     0.200
     2.632    12.324     0.200
     2.966    13.274     0.200
     3.506    14.467     0.200
     3.516    15.544     0.200
     3.595    14.810     0.200
     3.872    15.307     0.200
     4.250    15.169     0.200
     4.634    15.993     0.200
     4.916    15.932     0.200
     5.031    16.526     0.200
     5.152    19.112     0.200
     5.360    20.419     0.200
     5.779    19.930     0.200
     5.967    20.629     0.200
     5.988    18.684     0.200
     6.071    20.024     0.200
     6.118    20.073     0.200
     6.214    21.952     0.200
     6.325    20.723     0.200
     6.488    19.176     0.200
     6.602    20.623     0.200
     6.634    21.646     0.200
     6.659    20.350     0.200
     7.031    19.625     0.200
     7.175    20.439     0.200
     7.507    21.860     0.200
     8.127    21.830     0.200
     8.430    21.092     0.200
     8.636    23.085     0.200
     8.810    23.249     0.200
     9.776    25.282     0.200
    20.614    42.148     0.200
     1.497     9.511     0.200
     1.575     7.707     0.200
     1.892     9.800     0.200
     2.392    10.267     0.200
     2.450    11.371     0.200
     2.620    12.502     0.200
     2.664    11.378     0.200
     2.903    13.131     0.200
     2.948    12.237     0.200
     3.033    13.192     0.200
     2.999    12.400     0.200
     3.369    14.664     0.200
     3.362    14.422     0.200
     3.540    14.346     0.200
     3.555    14.272     0.200
     3.651    14.676     0.200
     4.082    14.944     0.200
     4.227    12.756     0.200
     4.199    14.685     0.200
     4.299    14.310     0.200
     4.585    17.574     0.200
     4.687    14.288     0.200
     5.408    18.864     0.200
     5.480    17.934     0.200
     6.041    17.480     0.200
     6.357    20.086     0.200
     7.082    18.606     0.200
     7.187    20.015     0.200
     7.513    19.710     0.200
     8.144    20.841     0.200
     8.666    22.051     0.200
    20.674    38.462     0.200
     1.489    10.069     0.200
     1.892    11.268     0.200
     2.299    12.310     0.200
     2.373    11.552     0.200
     2.385    12.707     0.200
     2.390    12.296     0.200
     2.551    13.537     0.200
     2.608    12.283     0.200
     2.837    14.172     0.200
     2.926    13.595     0.200
     2.901    12.625     0.200
     2.942    12.891     0.200
     3.024    14.653     0.200
     3.206    14.928     0.200
     3.248    15.641     0.200
     3.304    15.580     0.200
     3.290    15.837     0.200
     3.481    14.956     0.200
     3.491    15.365     0.200
     3.577    15.597     0.200
     3.887    15.878     0.200
     3.952    14.591     0.200
     4.004    15.621     0.200
     4.091    16.700     0.200
     4.032    17.191     0.200
     4.159    15.409     0.200
     4.167    18.109     0.200
     4.538    18.285     0.200
     4.618    16.453     0.200
     4.703    16.257     0.200
     4.673    17.707     0.200
     4.748    18.838     0.200
     4.911    15.932     0.200
     5.075    16.412     0.200
     5.159    18.842     0.200
     5.169    18.022     0.200
     5.491    19.167     0.200
     5.697    19.462     0.200
     5.769    20.915     0.200
     5.973    19.743     0.200
     6.058    20.550     0.200
     6.131    21.097     0.200
     6.616    21.829     0.200
     6.631    22.362     0.200
     6.675    23.048     0.200
     6.802    23.665     0.200
     7.182    21.224     0.200
     7.312    21.915     0.200
     8.132    22.847     0.200
     8.431    22.657     0.200
     8.635    23.276     0.200
     8.811    24.414     0.200
     9.782    24.891     0.200
     9.898    25.139     0.200
     1.905    10.338     0.200
     1.956    10.944     0.200
     2.128    10.740     0.200
     2.251    11.501     0.200
     2.485    11.076     0.200
     2.394    11.131     0.200
     2.394    11.138     0.200
     2.578    12.334     0.200
     2.519    10.875     0.200
     2.602    11.599     0.200
     2.855    13.103     0.200
     2.878    12.113     0.200
     3.040    12.594     0.200
     2.940    12.481     0.200
     3.126    12.994     0.200
     3.355    14.125     0.200
     3.409    13.587     0.200
     3.324    14.253     0.200
     3.382    14.302     0.200
     3.538    13.488     0.200
     3.483    14.031     0.200
     3.503    14.434     0.200
     3.602    14.940     0.200
     3.632    12.686     0.200
     3.753    13.372     0.200
     4.071    15.666     0.200
     4.087    13.383     0.200
     3.938    15.318     0.200
     4.131    14.465     0.200
     4.118    16.421     0.200
     4.293    15.072     0.200
     4.372    14.557     0.200
     4.446    14.521     0.200
     4.555    14.283     0.200
     4.574    14.590     0.200
     4.515    17.581     0.200
     4.703    14.507     0.200
     4.715    14.917     0.200
     4.721    14.694     0.200
     4.712    15.486     0.200
     4.752    15.423     0.200
     4.772    15.029     0.200
     4.795    14.819     0.200
     4.662    16.863     0.200
     4.813    16.704     0.200
     4.868    16.857     0.200
     4.994    14.864     0.200
     5.020    15.258     0.200
     5.039    15.471     0.200
     5.155    15.516     0.200
     5.194    15.961     0.200
     5.260    17.988     0.200
     5.268    16.278     0.200
     5.455    16.916     0.200
     5.482    17.399     0.200
     5.403    17.719     0.200
     5.382    17.071     0.200
     5.679    20.394     0.200
     5.868    17.689     0.200
     6.071    19.624     0.200
     6.091    18.888     0.200
     6.106    18.812     0.200
     6.161    20.670     0.200
     6.175    19.513     0.200
     6.174    19.224     0.200
     6.194    19.383     0.200
     6.207    19.434     0.200
     6.338    19.412     0.200
     6.381    18.205     0.200
     6.381    22.009     0.200
     6.446    19.871     0.200
     6.513    19.564     0.200
     6.558    21.635     0.200
     6.686    21.554     0.200
     6.740    21.922     0.200
     6.757    20.823     0.200
     6.817    21.122     0.200
     6.817    21.224     0.200
     6.868    22.919     0.200
     6.944    19.635     0.200
     6.836    21.992     0.200
     7.082    21.324     0.200
     7.082    21.726     0.200
     7.120    21.080     0.200
     7.150    19.532     0.200
     7.150    19.720     0.200
     7.181    19.473     0.200
     7.181    19.871     0.200
     7.266    20.684     0.200
     7.280    20.121     0.200
     7.300    19.081     0.200
     7.318    20.470     0.200
     7.446    20.679     0.200
     7.560    21.258     0.200
     7.589    21.212     0.200
     7.604    22.131     0.200
     7.726    21.016     0.200
     7.855    22.070     0.200
     8.032    21.220     0.200
     8.216    21.396     0.200
     8.237    21.542     0.200
     8.259    20.591     0.200
     8.118    24.136     0.200
     8.394    23.113     0.200
     8.432    21.375     0.200
     8.548    21.418     0.200
     8.493    25.618     0.200
     8.672    21.972     0.200
     8.722    22.992     0.200
     8.756    22.187     0.200
     9.071    28.416     0.200
     9.229    23.467     0.200
     9.256    22.855     0.200
     9.656    25.586     0.200
     9.816    26.013     0.200
     9.885    23.310     0.200
     9.971    24.107     0.200
     9.999    23.988     0.200
    10.192    24.634     0.200
     1.325     8.032     0.200
     1.287     7.570     0.200
     1.447     8.111     0.200
     1.553     9.263     0.200
     1.791     9.086     0.200
     1.914    10.549     0.200
     2.047    10.700     0.200
     2.162    10.060     0.200
     2.343    10.652     0.200
     2.441    11.562     0.200
     2.788    12.396     0.200
     2.744    12.568     0.200
     2.854    10.786     0.200
     3.074    11.585     0.200
     3.333    13.305     0.200
     3.382    14.184     0.200
     3.346    12.845     0.200
     3.489    13.727     0.200
     3.450    13.238     0.200
     3.511    12.709     0.200
     3.721    15.127     0.200
     3.775    15.002     0.200
     3.815    15.114     0.200
     3.845    15.120     0.200
     4.302    15.290     0.200
     4.549    16.622     0.200
     4.607    15.328     0.200
     4.703    14.503     0.200
     5.062    15.418     0.200
     5.112    16.937     0.200
     5.177    14.794     0.200
     5.153    17.361     0.200
     5.564    17.057     0.200
     5.623    19.531     0.200
     5.734    16.674     0.200
     5.816    17.122     0.200
     6.416    18.115     0.200
     6.447    18.855     0.200
     6.530    19.085     0.200
     6.541    20.058     0.200
     6.555    19.102     0.200
     6.816    20.329     0.200
     7.007    20.114     0.200
     7.055    20.865     0.200
     7.124    20.755     0.200
     7.186    21.831     0.200
     7.291    22.502     0.200
     7.466    19.323     0.200
     7.638    21.259     0.200
     7.658    22.120     0.200
     7.762    21.407     0.200
     7.862    24.637     0.200
     7.951    24.706     0.200
     8.603    21.201     0.200
     8.918    22.917     0.200
     9.298    22.380     0.200
    10.360    26.294     0.200
    10.547    27.107     0.200
     1.635     9.201     0.200
     1.633     9.820     0.200
     1.647     8.935     0.200
     1.677     9.286     0.200
     1.788     9.750     0.200
     1.921     8.685     0.200
     2.012    10.537     0.200
     2.126    10.369     0.200
     2.534    11.124     0.200
     2.781    12.411     0.200
     2.787    10.726     0.200
     2.866    11.490     0.200
     2.958    13.047     0.200
     2.988    12.990     0.200
     3.239    13.576     0.200
     3.260    13.763     0.200
     3.327    13.581     0.200
     3.700    14.165     0.200
     3.759    16.285     0.200
     3.869    15.261     0.200
     3.888    14.987     0.200
     3.888    14.987     0.200
     4.055    13.927     0.200
     4.151    15.506     0.200
     4.148    15.616     0.200
     4.262    14.506     0.200
     4.280    15.006     0.200
     4.345    14.578     0.200
     4.354    15.339     0.200
     4.394    16.072     0.200
     4.471    14.638     0.200
     4.469    15.303     0.200
     4.818    15.726     0.200
     5.902    17.770     0.200
     6.035    19.827     0.200
     6.120    19.627     0.200
     6.169    18.563     0.200
     6.365    18.278     0.200
     6.411    18.736     0.200
     6.640    21.564     0.200
     6.664    19.279     0.200
     7.028    19.040     0.200
     7.048    19.096     0.200
     7.221    20.682     0.200
     7.322    20.800     0.200
     7.492    19.116     0.200
     8.014    21.330     0.200
     8.100    21.919     0.200
     8.375    21.011     0.200
     8.752    20.116     0.200
     8.752    21.716     0.200
     9.653    23.700     0.200
     1.630    10.203     0.200
     1.644    10.150     0.200
     1.673    10.211     0.200
     1.647     9.891     0.200
     1.781    10.730     0.200
     1.928     9.690     0.200
     2.023    11.559     0.200
     2.023    11.426     0.200
     2.324    12.480     0.200
     2.780    12.757     0.200
     2.795    12.575     0.200
     2.853    12.820     0.200
     2.891    13.753     0.200
     2.891    13.503     0.200
     2.955    13.264     0.200
     2.988    13.317     0.200
     3.137    14.426     0.200
     3.111    13.633     0.200
     3.142    13.797     0.200
     3.184    14.081     0.200
     3.191    14.191     0.200
     3.237    14.655     0.200
     3.237    14.217     0.200
     3.261    14.242     0.200
     3.272    14.447     0.200
     3.337    15.202     0.200
     3.326    14.442     0.200
     3.455    15.312     0.200
     3.506    15.026     0.200
     3.536    14.519     0.200
     3.697    16.397     0.200
     3.734    15.902     0.200
     3.740    15.364     0.200
     3.750    16.680     0.200
     3.753    14.965     0.200
     3.762    15.736     0.200
     3.796    16.327     0.200
     3.796    15.339     0.200
     3.774    15.930     0.200
     3.774    15.789     0.200
     3.803    15.130     0.200
     3.821    15.939     0.200
     3.868    16.403     0.200
     3.901    17.465     0.200
     3.887    16.542     0.200
     3.887    16.542     0.200
     3.911    16.297     0.200
     3.937    15.551     0.200
     3.937    14.692     0.200
     3.959    15.679     0.200
     3.977    17.703     0.200
     4.043    15.599     0.200
     4.082    14.556     0.200
     4.073    16.971     0.200
     4.115    16.987     0.200
     4.136    15.941     0.200
     4.172    15.677     0.200
     4.192    15.914     0.200
     4.206    18.054     0.200
     4.256    18.060     0.200
     4.250    16.062     0.200
     4.227    16.303     0.200
     4.268    15.828     0.200
     4.268    15.929     0.200
     4.285    17.628     0.200
     4.333    16.463     0.200
     4.324    18.880     0.200
     4.342    16.650     0.200
     4.342    15.868     0.200
     4.370    17.444     0.200
     4.382    15.106     0.200
     4.382    16.305     0.200
     4.463    16.251     0.200
     4.463    16.751     0.200
     4.459    16.143     0.200
     4.454    18.209     0.200
     4.497    18.562     0.200
     4.481    17.844     0.200
     4.553    15.260     0.200
     4.556    15.112     0.200
     4.565    18.058     0.200
     4.576    15.432     0.200
     4.649    15.262     0.200
     4.649    15.781     0.200
     4.646    18.702     0.200
     4.680    15.277     0.200
     4.686    15.667     0.200
     4.736    15.669     0.200
     4.735    15.797     0.200
     4.745    15.255     0.200
     4.788    15.135     0.200
     4.788    15.365     0.200
     4.806    17.158     0.200
     4.805    17.540     0.200
     4.824    16.484     0.200
     4.866    16.350     0.200
     4.925    15.802     0.200
     4.897    18.885     0.200
     4.931    16.188     0.200
     4.985    15.846     0.200
     4.971    18.553     0.200
     5.000    16.577     0.200
     5.000    16.686     0.200
     4.974    18.094     0.200
     5.022    16.151     0.200
     5.022    16.831     0.200
     5.040    16.844     0.200
     5.040    17.023     0.200
     5.066    16.510     0.200
     5.117    16.496     0.200
     5.117    17.815     0.200
     5.200    17.180     0.200
     5.254    19.030     0.200
     5.330    18.438     0.200
     5.388    19.757     0.200
     5.440    19.003     0.200
     5.451    18.829     0.200
     5.482    18.663     0.200
     5.482    18.561     0.200
     5.505    19.501     0.200
     5.559    17.962     0.200
     5.599    19.822     0.200
     5.621    19.041     0.200
     5.703    19.478     0.200
     5.752    21.074     0.200
     5.754    20.010     0.200
     5.771    18.755     0.200
     5.796    18.600     0.200
     5.776    19.531     0.200
     5.855    20.915     0.200
     5.857    19.090     0.200
     5.867    18.565     0.200
     5.895    19.842     0.200
     5.895    21.142     0.200
     5.903    20.946     0.200
     5.932    19.312     0.200
     5.944    21.164     0.200
     5.970    17.462     0.200
     5.975    19.903     0.200
     5.976    21.902     0.200
     6.022    19.858     0.200
     6.032    22.182     0.200
     6.072    21.673     0.200
     6.041    20.136     0.200
     6.076    17.876     0.200
     6.099    21.457     0.200
     6.099    21.656     0.200
     6.102    22.136     0.200
     6.102    21.136     0.200
     6.104    20.296     0.200
     6.108    20.555     0.200
     6.124    21.166     0.200
     6.156    20.094     0.200
     6.185    19.455     0.200
     6.218    19.774     0.200
     6.238    21.939     0.200
     6.251    20.785     0.200
     6.255    21.459     0.200
     6.255    21.338     0.200
     6.247    19.638     0.200
     6.243    21.781     0.200
     6.281    21.337     0.200
     6.342    22.017     0.200
     6.358    20.741     0.200
     6.360    18.782     0.200
     6.363    18.578     0.200
     6.370    20.496     0.200
     6.389    20.531     0.200
     6.405    20.593     0.200
     6.405    20.695     0.200
     6.431    17.803     0.200
     6.482    21.294     0.200
     6.529    18.749     0.200
     6.531    18.614     0.200
     6.532    23.411     0.200
     6.554    19.046     0.200
     6.625    18.023     0.200
     6.625    18.426     0.200
     6.628    21.186     0.200
     6.640    20.548     0.200
     6.619    20.394     0.200
     6.656    21.564     0.200
     6.656    23.263     0.200
     6.673    20.262     0.200
     6.725    22.168     0.200
     6.766    18.594     0.200
     6.786    20.842     0.200
     6.787    22.733     0.200
     6.786    21.445     0.200
     6.854    21.649     0.200
     6.875    21.320     0.200
     6.875    20.411     0.200
     6.909    21.206     0.200
     6.939    19.861     0.200
     6.947    20.468     0.200
     6.950    20.127     0.200
     6.945    22.584     0.200
     6.987    23.199     0.200
     6.988    23.590     0.200
     6.992    20.338     0.200
     7.018    20.534     0.200
     7.018    20.036     0.200
     7.039    20.689     0.200
     7.083    20.583     0.200
     7.083    21.083     0.200
     7.084    24.160     0.200
     7.127    20.865     0.200
     7.153    21.397     0.200
     7.153    25.057     0.200
     7.153    24.557     0.200
     7.181    20.831     0.200
     7.189    23.445     0.200
     7.186    21.081     0.200
     7.199    20.931     0.200
     7.214    23.449     0.200
     7.218    21.605     0.200
     7.230    22.258     0.200
     7.234    22.019     0.200
     7.234    21.110     0.200
     7.234    21.813     0.200
     7.266    24.040     0.200
     7.278    24.498     0.200
     7.314    23.782     0.200
     7.314    25.083     0.200
     7.308    21.351     0.200
     7.329    24.107     0.200
     7.360    21.646     0.200
     7.457    24.613     0.200
     7.480    21.348     0.200
     7.532    23.837     0.200
     7.567    22.594     0.200
     7.569    21.305     0.200
     7.576    21.127     0.200
     7.576    21.728     0.200
     7.620    20.707     0.200
     7.630    21.736     0.200
     7.693    24.434     0.200
     7.722    21.876     0.200
     7.745    23.249     0.200
     7.796    22.085     0.200
     7.801    21.182     0.200
     7.801    21.904     0.200
     7.859    22.221     0.200
     7.873    21.153     0.200
     7.888    20.988     0.200
     7.878    23.699     0.200
     7.972    22.506     0.200
     7.948    25.188     0.200
     8.004    22.431     0.200
     7.987    24.933     0.200
     8.019    23.558     0.200
     8.061    22.068     0.200
     8.061    21.498     0.200
     8.087    23.059     0.200
     8.087    22.860     0.200
     8.093    24.595     0.200
     8.093    26.196     0.200
     8.125    22.432     0.200
     8.177    25.205     0.200
     8.254    22.108     0.200
     8.254    21.827     0.200
     8.254    22.507     0.200
     8.257    23.674     0.200
     8.274    21.875     0.200
     8.278    25.133     0.200
     8.284    23.059     0.200
     8.364    22.026     0.200
     8.364    23.026     0.200
     8.369    24.970     0.200
     8.355    25.132     0.200
     8.386    23.875     0.200
     8.386    23.875     0.200
     8.442    25.124     0.200
     8.441    25.135     0.200
     8.435    24.197     0.200
     8.506    22.577     0.200
     8.506    22.319     0.200
     8.506    23.077     0.200
     8.533    27.456     0.200
     8.565    23.584     0.200
     8.565    23.107     0.200
     8.572    27.200     0.200
     8.669    25.464     0.200
     8.685    23.982     0.200
     8.694    25.484     0.200
     8.700    26.411     0.200
     8.741    23.028     0.200
     8.741    23.528     0.200
     8.727    25.790     0.200
     8.816    24.954     0.200
     8.816    24.364     0.200
     8.816    26.056     0.200
     8.864    28.213     0.200
     8.864    28.393     0.200
     8.902    24.300     0.200
     8.920    25.045     0.200
     8.960    25.080     0.200
     8.971    26.050     0.200
     9.013    26.449     0.200
     9.069    23.697     0.200
     9.067    31.019     0.200
     9.137    28.107     0.200
     9.171    28.314     0.200
     9.171    27.614     0.200
     9.169    27.335     0.200
     9.190    25.186     0.200
     9.190    25.784     0.200
     9.190    27.784     0.200
     9.187    28.221     0.200
     9.221    24.224     0.200
     9.313    28.468     0.200
     9.313    27.249     0.200
     9.347    24.562     0.200
     9.373    27.904     0.200
     9.446    26.400     0.200
     9.502    26.548     0.200
     9.502    27.146     0.200
     9.504    26.827     0.200
     9.504    27.425     0.200
     9.537    26.542     0.200
     9.544    27.555     0.200
     9.621    26.561     0.200
     9.622    30.549     0.200
     9.622    28.850     0.200
     9.643    25.201     0.200
     9.643    26.998     0.200
     9.624    27.821     0.200
     9.689    26.561     0.200
     9.699    28.345     0.200
     9.712    25.199     0.200
     9.718    25.629     0.200
     9.796    27.812     0.200
     9.922    26.244     0.200
     9.922    27.244     0.200
     9.897    29.340     0.200
     9.967    28.720     0.200
     9.937    28.068     0.200
     9.985    27.297     0.200
     9.989    29.153     0.200
     9.976    29.220     0.200
     9.983    29.137     0.200
    10.033    30.895     0.200
    10.044    29.428     0.200
    10.218    27.787     0.200
    10.296    28.483     0.200
    10.314    31.273     0.200
    10.360    31.128     0.200
    10.368    28.256     0.200
    10.490    29.412     0.200
    10.578    28.190     0.200
    10.678    30.721     0.200
    10.666    30.761     0.200
    10.731    30.610     0.200
    10.806    32.735     0.200
    10.806    33.536     0.200
    10.803    30.012     0.200
    10.847    31.246     0.200
    10.852    29.595     0.200
    10.872    28.384     0.200
    10.879    29.374     0.200
    10.892    29.525     0.200
    10.931    29.176     0.200
    10.970    30.081     0.200
    10.978    30.705     0.200
    10.991    30.057     0.200
    11.051    31.570     0.200
    11.179    30.075     0.200
    11.159    32.407     0.200
    11.280    31.001     0.200
    11.316    31.475     0.200
    11.390    32.915     0.200
    11.487    30.163     0.200
    11.509    31.630     0.200
    11.509    32.830     0.200
    11.580    32.893     0.200
    11.686    31.734     0.200
    11.666    33.000     0.200
    11.825    33.738     0.200
    11.854    31.996     0.200
    11.944    33.601     0.200
    12.224    30.995     0.200
    12.234    33.881     0.200
    12.324    33.378     0.200
    12.381    35.154     0.200
    12.635    37.889     0.200
    12.648    38.228     0.200
    12.890    34.499     0.200
    12.916    33.906     0.200
    12.922    34.354     0.200
    12.942    35.136     0.200
    12.997    36.940     0.200
    12.991    36.338     0.200
    13.273    35.545     0.200
    13.356    35.974     0.200
    13.415    35.478     0.200
    13.495    35.543     0.200
    13.495    35.863     0.200
    13.652    36.714     0.200
    13.839    35.491     0.200
    13.963    34.387     0.200
    13.963    36.289     0.200
    14.001    37.788     0.200
    14.032    38.789     0.200
    14.081    32.919     0.200
    14.228    35.392     0.200
    14.359    37.063     0.200
    14.384    39.178     0.200
    14.452    36.965     0.200
    14.452    37.187     0.200
    14.760    38.229     0.200
    14.774    37.416     0.200
    14.915    37.181     0.200
    15.027    38.737     0.200
    15.218    37.641     0.200
    15.408    35.826     0.200
    15.553    39.134     0.200
    15.594    39.259     0.200
    15.947    38.032     0.200
    15.944    37.881     0.200
    16.126    37.753     0.200
    16.244    33.504     0.200
    16.310    39.442     0.200
    16.381    38.932     0.200
    16.425    35.806     0.200
    16.475    39.355     0.200
    16.699    38.461     0.200
    16.853    37.401     0.200
    16.972    39.507     0.200
    18.262    39.226     0.200
    18.413    45.715     0.200
    18.430    41.468     0.200
    18.464    40.588     0.200
    18.464    41.646     0.200
    18.464    40.419     0.200
    18.520    41.576     0.200
    18.518    41.036     0.200
    18.645    42.349     0.200
    18.691    44.281     0.200
    18.740    41.547     0.200
    18.777    42.015     0.200
    18.789    41.217     0.200
    18.789    42.237     0.200
    18.956    41.226     0.200
    19.013    41.361     0.200
    19.015    41.919     0.200
    19.123    41.201     0.200
    19.256    41.026     0.200
    19.318    40.052     0.200
    19.408    40.941     0.200
    19.488    40.512     0.200
    19.488    40.512     0.200
    19.624    44.894     0.200
    19.708    42.951     0.200
    19.774    40.579     0.200
    19.917    41.004     0.200
    20.096    44.113     0.200
    20.186    40.364     0.200
    20.186    41.841     0.200
    20.212    41.266     0.200
    20.331    41.677     0.200
    20.409    40.166     0.200
    20.409    40.268     0.200
    20.417    41.170     0.200
    20.451    40.276     0.200
    20.471    40.773     0.200
    20.471    42.140     0.200
    20.643    40.734     0.200
    20.734    40.667     0.200
     1.665     9.748     0.200
     1.637     9.341     0.200
     1.897     9.167     0.200
     2.003    11.004     0.200
     2.307    12.251     0.200
     2.544    11.863     0.200
     2.746    12.183     0.200
     2.854    11.891     0.200
     2.923    13.610     0.200
     2.954    13.180     0.200
     3.098    14.577     0.200
     3.204    13.991     0.200
     3.226    13.293     0.200
     3.293    13.611     0.200
     3.666    15.504     0.200
     3.732    14.604     0.200
     3.747    14.173     0.200
     3.835    15.641     0.200
     3.854    15.720     0.200
     3.854    15.720     0.200
     3.964    15.521     0.200
     4.046    14.312     0.200
     4.089    13.931     0.200
     4.133    14.965     0.200
     4.248    15.025     0.200
     4.262    15.774     0.200
     4.329    15.405     0.200
     4.344    15.290     0.200
     4.387    14.515     0.200
     4.456    15.426     0.200
     4.497    16.535     0.200
     4.808    16.013     0.200
     4.832    15.340     0.200
     4.947    15.660     0.200
     5.127    15.717     0.200
     5.489    18.160     0.200
     5.927    19.952     0.200
     5.951    19.373     0.200
     5.994    17.062     0.200
     6.035    20.085     0.200
     6.101    17.960     0.200
     6.118    19.323     0.200
     6.123    19.167     0.200
     6.159    19.242     0.200
     6.196    19.006     0.200
     6.237    21.427     0.200
     6.266    19.792     0.200
     6.391    20.438     0.200
     6.438    18.887     0.200
     6.552    18.660     0.200
     6.646    20.557     0.200
     6.670    20.978     0.200
     6.686    21.090     0.200
     6.961    20.882     0.200
     7.015    20.747     0.200
     7.043    21.022     0.200
     7.047    19.883     0.200
     7.068    21.538     0.200
     7.190    20.311     0.200
     7.207    21.514     0.200
     7.484    20.075     0.200
     8.030    22.104     0.200
     8.387    21.840     0.200
     8.764    22.441     0.200
     8.834    27.745     0.200
     9.375    23.713     0.200
    20.882    41.585     0.200
     1.604     9.985     0.200
     1.617     9.909     0.200
     1.642    10.124     0.200
     1.762    10.817     0.200
     1.839    10.465     0.200
     1.947     9.764     0.200
     2.028    11.467     0.200
     2.324    12.204     0.200
     2.517    12.060     0.200
     2.810    13.088     0.200
     2.868    12.572     0.200
     2.812    12.199     0.200
     2.986    13.916     0.200
     3.018    13.412     0.200
     3.177    14.107     0.200
     3.108    15.006     0.200
     3.267    14.000     0.200
     3.328    14.642     0.200
     3.289    13.999     0.200
     3.356    14.144     0.200
     3.727    16.092     0.200
     3.733    15.250     0.200
     3.744    14.850     0.200
     3.755    16.325     0.200
     3.789    15.864     0.200
     3.898    16.073     0.200
     3.917    16.276     0.200
     3.917    16.276     0.200
     3.989    16.384     0.200
     4.055    17.134     0.200
     4.153    13.851     0.200
     4.245    17.718     0.200
     4.287    16.147     0.200
     4.245    16.536     0.200
     4.351    15.729     0.200
     4.355    17.459     0.200
     4.392    16.027     0.200
     4.301    18.701     0.200
     4.440    16.366     0.200
     4.476    16.327     0.200
     4.714    14.830     0.200
     4.819    16.644     0.200
     4.931    15.681     0.200
     5.017    16.139     0.200
     5.124    16.325     0.200
     5.284    18.012     0.200
     5.412    18.926     0.200
     5.576    17.510     0.200
     5.803    18.858     0.200
     5.876    20.402     0.200
     6.026    21.059     0.200
     6.067    17.599     0.200
     6.169    19.688     0.200
     6.239    20.993     0.200
     6.337    20.924     0.200
     6.383    19.388     0.200
     6.640    20.095     0.200
     6.693    22.967     0.200
     7.005    20.034     0.200
     7.026    19.989     0.200
     7.179    23.102     0.200
     7.197    20.486     0.200
     7.194    22.425     0.200
     7.297    23.219     0.200
     7.491    21.258     0.200
     7.993    21.904     0.200
     8.075    22.546     0.200
     8.298    23.662     0.200
     8.358    22.043     0.200
     8.421    25.106     0.200
     8.368    24.927     0.200
     8.734    22.050     0.200
     9.203    26.979     0.200
     9.631    25.181     0.200
     9.701    25.873     0.200
     9.698    25.203     0.200
     9.970    27.044     0.200
    10.580    27.650     0.200
    14.213    35.314     0.200
     1.659    10.467     0.200
     1.650    10.345     0.200
     1.804    11.351     0.200
     2.748    13.209     0.200
     2.775    13.050     0.200
     2.841    12.857     0.200
     2.923    13.468     0.200
     2.957    13.652     0.200
     3.155    15.920     0.200
     3.205    14.717     0.200
     3.230    13.860     0.200
     3.295    14.681     0.200
     3.512    14.877     0.200
     3.665    16.748     0.200
     3.733    16.998     0.200
     3.745    15.898     0.200
     3.761    15.040     0.200
     3.837    16.260     0.200
     3.855    16.671     0.200
     3.855    16.671     0.200
     4.033    15.431     0.200
     4.075    14.839     0.200
     4.129    17.693     0.200
     4.121    16.807     0.200
     4.236    16.310     0.200
     4.270    18.772     0.200
     4.207    16.866     0.200
     4.317    16.523     0.200
     4.331    16.611     0.200
     4.374    15.609     0.200
     4.444    16.416     0.200
     4.489    16.568     0.200
     4.654    17.748     0.200
     4.776    14.794     0.200
     4.795    16.900     0.200
     4.867    19.162     0.200
     4.933    16.507     0.200
     4.946    19.123     0.200
     4.949    19.007     0.200
     5.030    17.413     0.200
     5.114    16.846     0.200
     5.312    18.811     0.200
     5.476    19.056     0.200
     5.545    18.251     0.200
     5.605    19.548     0.200
     5.674    18.945     0.200
     5.776    20.098     0.200
     5.747    19.891     0.200
     5.917    19.706     0.200
     5.950    20.404     0.200
     5.954    21.970     0.200
     6.022    20.484     0.200
     6.088    18.586     0.200
     6.104    20.324     0.200
     6.109    20.664     0.200
     6.094    20.839     0.200
     6.146    20.032     0.200
     6.252    20.890     0.200
     6.212    21.266     0.200
     6.259    22.437     0.200
     6.381    19.884     0.200
     6.429    20.328     0.200
     6.633    21.654     0.200
     6.675    21.156     0.200
     6.762    22.548     0.200
     6.914    23.267     0.200
     7.035    20.555     0.200
     7.056    20.812     0.200
     7.177    21.403     0.200
     7.237    23.803     0.200
     7.334    23.770     0.200
     7.284    22.277     0.200
     7.322    23.512     0.200
     7.471    21.570     0.200
     8.018    22.186     0.200
     8.093    24.312     0.200
     8.114    23.373     0.200
     8.260    24.922     0.200
     8.275    24.389     0.200
     8.374    22.333     0.200
     8.751    23.133     0.200
     9.363    23.885     0.200
     9.659    25.343     0.200
     9.681    24.980     0.200
     9.940    25.957     0.200
    10.549    29.266     0.200
    10.938    27.004     0.200
     1.651     8.691     0.200
     1.767     9.039     0.200
     1.943     8.337     0.200
     2.031    10.470     0.200
     2.106    10.616     0.200
     2.131    11.731     0.200
     2.330    11.515     0.200
     2.514    10.631     0.200
     2.855    11.007     0.200
     2.880    12.209     0.200
     3.127    13.397     0.200
     3.173    13.803     0.200
     3.778    15.455     0.200
     4.337    14.716     0.200
     4.381    16.522     0.200
     4.448    14.644     0.200
     4.806    15.154     0.200
     5.881    17.017     0.200
     6.343    18.825     0.200
     6.389    18.181     0.200
     7.006    18.988     0.200
     7.027    18.943     0.200
     7.480    21.959     0.200
     7.993    20.872     0.200
     8.355    20.045     0.200
     8.731    20.951     0.200
     9.334    22.418     0.200
     9.632    23.244     0.200
     9.909    24.905     0.200
     1.433     8.874     0.200
     1.618    10.280     0.200
     1.648     9.889     0.200
     1.771    10.810     0.200
     1.938     9.363     0.200
     2.027    11.200     0.200
     2.326    12.867     0.200
     2.518    11.947     0.200
     2.857    12.132     0.200
     2.793    13.342     0.200
     2.805    12.067     0.200
     3.001    13.310     0.200
     3.112    13.228     0.200
     3.250    15.080     0.200
     3.274    13.933     0.200
     3.340    14.074     0.200
     3.710    16.410     0.200
     3.740    15.006     0.200
     3.882    16.239     0.200
     3.900    16.206     0.200
     3.900    16.206     0.200
     4.167    16.072     0.200
     4.274    17.618     0.200
     4.338    15.058     0.200
     4.383    16.142     0.200
     4.464    16.016     0.200
     4.452    16.050     0.200
     4.809    15.880     0.200
     4.928    15.597     0.200
     5.118    16.981     0.200
     5.564    17.466     0.200
     5.885    19.721     0.200
     6.159    18.713     0.200
     6.347    19.827     0.200
     6.394    19.081     0.200
     6.625    20.984     0.200
     6.647    21.127     0.200
     8.359    21.349     0.200
     8.736    22.150     0.200
     9.338    24.114     0.200
     9.636    24.948     0.200
     9.712    24.754     0.200
    10.209    27.449     0.200
    11.497    31.424     0.200
     1.648     9.738     0.200
     1.662    10.730     0.200
     1.646    10.278     0.200
     1.914     9.920     0.200
     2.319    12.904     0.200
     2.761    13.371     0.200
     2.849    12.496     0.200
     2.782    12.522     0.200
     2.970    13.970     0.200
     3.108    13.640     0.200
     3.218    14.950     0.200
     3.243    14.284     0.200
     3.308    15.001     0.200
     3.437    15.217     0.200
     3.679    16.978     0.200
     3.741    15.442     0.200
     3.755    15.095     0.200
     3.850    16.369     0.200
     3.868    16.687     0.200
     3.868    16.687     0.200
     4.130    15.994     0.200
     4.136    16.363     0.200
     4.261    17.803     0.200
     4.213    16.455     0.200
     4.326    16.114     0.200
     4.380    15.715     0.200
     4.453    16.031     0.200
     4.480    16.847     0.200
     4.802    16.486     0.200
     4.824    17.110     0.200
     4.935    16.248     0.200
     5.029    16.776     0.200
     4.956    18.284     0.200
     5.118    15.748     0.200
     5.481    18.663     0.200
     5.609    19.164     0.200
     5.776    20.370     0.200
     5.910    20.059     0.200
     5.961    21.056     0.200
     6.086    17.973     0.200
     6.111    20.205     0.200
     6.153    19.421     0.200
     6.371    18.587     0.200
     6.373    20.250     0.200
     6.420    20.199     0.200
     6.633    20.917     0.200
     6.669    21.498     0.200
     7.030    20.184     0.200
     7.051    20.541     0.200
     7.327    23.715     0.200
     7.477    21.364     0.200
     8.014    22.698     0.200
     8.372    22.318     0.200
     8.344    26.252     0.200
     8.749    22.818     0.200
     9.654    25.857     0.200
     9.726    26.219     0.200
    10.375    29.152     0.200
    10.869    29.686     0.200
     1.645    10.297     0.200
     1.627    10.546     0.200
     1.801    11.000     0.200
     2.545    12.805     0.200
     2.774    13.444     0.200
     2.771    12.788     0.200
     2.870    12.491     0.200
     2.913    13.876     0.200
     2.949    13.458     0.200
     2.978    13.362     0.200
     3.090    14.393     0.200
     3.229    14.115     0.200
     3.248    13.804     0.200
     3.316    14.402     0.200
     3.692    15.069     0.200
     3.720    15.664     0.200
     3.734    14.962     0.200
     3.747    16.785     0.200
     3.859    15.028     0.200
     3.878    15.207     0.200
     4.348    15.989     0.200
     4.359    19.035     0.200
     4.401    16.156     0.200
     4.481    16.416     0.200
     4.474    15.605     0.200
     4.823    16.822     0.200
     4.884    16.910     0.200
     4.952    16.855     0.200
     5.915    19.981     0.200
     6.174    20.056     0.200
     6.377    20.589     0.200
     6.424    20.047     0.200
     6.677    19.291     0.200
     7.040    20.652     0.200
     8.026    22.646     0.200
     8.387    22.140     0.200
     8.763    24.041     0.200
     9.368    24.383     0.200
     1.614     9.715     0.200
     1.659     9.722     0.200
     2.880    11.461     0.200
     4.071    14.417     0.200
     4.274    14.831     0.200
     4.356    14.876     0.200
     4.496    16.067     0.200
     4.833    15.826     0.200
     6.185    18.955     0.200
     6.392    19.631     0.200
     6.439    19.190     0.200
     6.693    19.225     0.200
     7.056    19.890     0.200
     7.077    19.646     0.200
     7.249    20.936     0.200
     7.509    18.797     0.200
     8.402    20.980     0.200
     8.476    24.814     0.200
    10.255    26.250     0.200
    10.884    28.310     0.200
     1.608     8.879     0.200
     1.621     9.287     0.200
     1.651     9.233     0.200
     1.637     9.452     0.200
     1.833    10.084     0.200
     1.942     9.428     0.200
     2.022    11.108     0.200
     2.318    11.715     0.200
     2.523    11.602     0.200
     2.872    11.478     0.200
     2.808    11.364     0.200
     2.887    12.852     0.200
     2.807    11.986     0.200
     2.984    11.757     0.200
     3.015    11.736     0.200
     3.134    13.721     0.200
     3.181    13.484     0.200
     3.183    12.872     0.200
     3.102    12.859     0.200
     3.102    12.398     0.200
     3.123    13.380     0.200
     3.334    14.486     0.200
     3.245    13.069     0.200
     3.481    14.778     0.200
     3.491    13.910     0.200
     3.491    13.457     0.200
     3.521    13.837     0.200
     3.632    15.618     0.200
     3.726    13.695     0.200
     3.787    14.207     0.200
     3.824    14.012     0.200
     3.772    14.285     0.200
     3.785    12.932     0.200
     3.728    13.799     0.200
     3.738    13.674     0.200
     3.751    15.125     0.200
     3.798    14.973     0.200
     3.936    14.871     0.200
     3.931    15.169     0.200
     3.931    15.033     0.200
     3.896    14.116     0.200
     3.915    14.761     0.200
     3.915    14.761     0.200
     3.989    15.354     0.200
     4.060    14.630     0.200
     4.096    13.692     0.200
     4.110    16.695     0.200
     4.157    14.445     0.200
     4.046    15.087     0.200
     4.181    14.402     0.200
     4.215    14.709     0.200
     4.239    16.173     0.200
     4.178    16.549     0.200
     4.251    16.992     0.200
     4.291    14.421     0.200
     4.163    18.862     0.200
     4.304    14.877     0.200
     4.355    14.859     0.200
     4.240    15.822     0.200
     4.360    15.444     0.200
     4.364    17.070     0.200
     4.397    14.591     0.200
     4.299    16.631     0.200
     4.298    18.072     0.200
     4.480    14.898     0.200
     4.445    15.732     0.200
     4.492    16.803     0.200
     4.568    14.743     0.200
     4.570    14.670     0.200
     4.559    16.742     0.200
     4.583    13.977     0.200
     4.436    17.060     0.200
     4.502    16.860     0.200
     4.513    20.300     0.200
     4.658    14.746     0.200
     4.693    14.419     0.200
     4.693    14.829     0.200
     4.698    14.853     0.200
     4.583    17.421     0.200
     4.583    17.019     0.200
     4.746    14.763     0.200
     4.747    14.797     0.200
     4.747    15.200     0.200
     4.627    17.486     0.200
     4.627    17.607     0.200
     4.800    14.461     0.200
     4.800    14.781     0.200
     4.688    16.737     0.200
     4.715    13.705     0.200
     4.824    16.110     0.200
     4.838    15.199     0.200
     4.880    15.576     0.200
     4.835    16.485     0.200
     4.937    15.265     0.200
     4.961    15.761     0.200
     4.922    17.658     0.200
     5.013    15.299     0.200
     5.013    15.998     0.200
     5.023    15.842     0.200
     5.052    15.522     0.200
     5.077    15.382     0.200
     4.994    17.642     0.200
     5.100    18.303     0.200
     5.129    16.002     0.200
     5.148    17.368     0.200
     5.282    18.111     0.200
     5.431    18.841     0.200
     5.339    17.931     0.200
     5.355    18.734     0.200
     5.496    17.460     0.200
     5.407    19.203     0.200
     5.494    18.473     0.200
     5.494    18.614     0.200
     5.580    16.783     0.200
     5.587    19.194     0.200
     5.628    18.121     0.200
     5.741    20.027     0.200
     5.742    20.125     0.200
     5.774    18.006     0.200
     5.805    17.756     0.200
     5.724    18.648     0.200
     5.842    19.929     0.200
     5.870    17.904     0.200
     5.799    18.325     0.200
     5.881    19.363     0.200
     5.889    21.177     0.200
     5.935    18.535     0.200
     5.931    20.480     0.200
     5.969    17.046     0.200
     5.963    19.912     0.200
     6.031    19.312     0.200
     6.020    20.756     0.200
     6.073    16.963     0.200
     6.059    20.592     0.200
     5.994    19.172     0.200
     5.988    20.916     0.200
     6.114    19.254     0.200
     6.116    19.126     0.200
     6.090    21.171     0.200
     6.090    19.940     0.200
     6.064    18.548     0.200
     6.174    18.751     0.200
     6.176    19.028     0.200
     6.221    19.402     0.200
     6.149    20.541     0.200
     6.224    20.472     0.200
     6.259    19.556     0.200
     6.244    19.892     0.200
     6.244    20.131     0.200
     6.206    18.978     0.200
     6.277    18.851     0.200
     6.331    20.820     0.200
     6.270    20.134     0.200
     6.355    17.649     0.200
     6.358    17.843     0.200
     6.342    19.387     0.200
     6.388    19.156     0.200
     6.339    19.595     0.200
     6.379    19.128     0.200
     6.295    20.734     0.200
     6.388    19.552     0.200
     6.424    17.168     0.200
     6.509    21.137     0.200
     6.528    18.822     0.200
     6.522    18.076     0.200
     6.458    19.673     0.200
     6.458    19.935     0.200
     6.550    17.758     0.200
     6.633    20.501     0.200
     6.642    20.084     0.200
     6.650    20.396     0.200
     6.645    20.252     0.200
     6.589    20.064     0.200
     6.697    18.447     0.200
     6.697    20.146     0.200
     6.622    20.020     0.200
     6.643    20.777     0.200
     6.715    21.968     0.200
     6.759    18.173     0.200
     6.790    20.265     0.200
     6.771    22.881     0.200
     6.845    21.464     0.200
     6.757    20.342     0.200
     6.881    20.605     0.200
     6.899    19.992     0.200
     6.910    20.265     0.200
     6.939    20.027     0.200
     6.957    20.016     0.200
     6.946    19.545     0.200
     6.991    19.815     0.200
     6.973    23.723     0.200
     6.970    22.460     0.200
     6.917    20.000     0.200
     6.917    20.179     0.200
     7.015    19.637     0.200
     7.015    20.039     0.200
     7.010    19.888     0.200
     7.010    19.490     0.200
     6.972    21.939     0.200
     7.031    19.745     0.200
     7.082    19.848     0.200
     7.082    19.950     0.200
     7.069    24.500     0.200
     7.029    20.610     0.200
     7.129    20.902     0.200
     7.129    21.203     0.200
     7.177    20.741     0.200
     7.181    20.297     0.200
     7.181    21.496     0.200
     7.202    20.449     0.200
     7.196    21.123     0.200
     7.172    22.807     0.200
     7.082    21.654     0.200
     7.213    21.323     0.200
     7.199    22.887     0.200
     7.225    21.988     0.200
     7.225    22.090     0.200
     7.236    21.657     0.200
     7.229    21.444     0.200
     7.250    23.591     0.200
     7.303    22.775     0.200
     7.355    21.068     0.200
     7.325    20.719     0.200
     7.354    22.474     0.200
     7.376    22.220     0.200
     7.441    23.959     0.200
     7.496    20.718     0.200
     7.572    21.287     0.200
     7.584    20.194     0.200
     7.578    20.761     0.200
     7.620    20.476     0.200
     7.617    21.114     0.200
     7.638    20.724     0.200
     7.715    23.641     0.200
     7.726    21.841     0.200
     7.680    23.675     0.200
     7.801    21.137     0.200
     7.800    20.450     0.200
     7.800    21.271     0.200
     7.758    22.765     0.200
     7.875    20.296     0.200
     7.973    20.969     0.200
     7.903    22.078     0.200
     7.999    21.456     0.200
     7.999    20.757     0.200
     7.916    26.919     0.200
     7.947    21.616     0.200
     7.973    23.756     0.200
     8.059    21.554     0.200
     8.059    21.015     0.200
     8.091    21.482     0.200
     8.080    24.306     0.200
     8.080    24.107     0.200
     8.131    21.894     0.200
     8.183    22.207     0.200
     8.255    21.970     0.200
     8.255    21.420     0.200
     8.255    22.072     0.200
     8.259    22.919     0.200
     8.218    27.196     0.200
     8.288    20.974     0.200
     8.303    21.904     0.200
     8.302    24.489     0.200
     8.364    21.395     0.200
     8.364    22.594     0.200
     8.387    22.419     0.200
     8.398    23.300     0.200
     8.398    23.300     0.200
     8.334    25.044     0.200
     8.426    24.069     0.200
     8.465    24.713     0.200
     8.362    24.718     0.200
     8.507    22.427     0.200
     8.507    21.631     0.200
     8.507    22.131     0.200
     8.458    23.973     0.200
     8.567    22.429     0.200
     8.567    21.769     0.200
     8.567    22.726     0.200
     8.477    26.371     0.200
     8.563    26.772     0.200
     8.563    26.975     0.200
     8.601    26.425     0.200
     8.708    22.976     0.200
     8.709    26.162     0.200
     8.699    25.788     0.200
     8.721    25.920     0.200
     8.726    24.665     0.200
     8.740    21.804     0.200
     8.740    20.702     0.200
     8.749    25.006     0.200
     8.660    26.235     0.200
     8.820    23.674     0.200
     8.820    23.053     0.200
     8.820    25.272     0.200
     8.909    25.036     0.200
     8.894    27.611     0.200
     8.894    27.369     0.200
     8.940    27.558     0.200
     8.940    23.238     0.200
     8.930    25.091     0.200
     9.068    23.074     0.200
     9.032    25.893     0.200
     9.195    26.795     0.200
     9.208    23.945     0.200
     9.209    25.436     0.200
     9.209    27.834     0.200
     9.167    27.627     0.200
     9.167    28.224     0.200
     9.235    24.032     0.200
     9.231    30.571     0.200
     9.288    24.325     0.200
     9.288    25.418     0.200
     9.288    26.516     0.200
     9.339    23.716     0.200
     9.339    23.318     0.200
     9.347    24.752     0.200
     9.484    25.422     0.200
     9.484    25.621     0.200
     9.459    25.915     0.200
     9.592    24.258     0.200
     9.628    25.042     0.200
     9.637    24.436     0.200
     9.637    23.436     0.200
     9.637    25.733     0.200
     9.651    29.878     0.200
     9.706    26.035     0.200
     9.704    24.456     0.200
     9.704    24.557     0.200
     9.716    24.713     0.200
     9.631    26.906     0.200
     9.913    25.814     0.200
     9.913    25.115     0.200
     9.995    28.965     0.200
     9.964    26.231     0.200
     9.964    28.071     0.200
    10.031    26.888     0.200
    10.039    29.555     0.200
    10.005    28.945     0.200
    10.011    27.277     0.200
    10.208    29.171     0.200
    10.208    27.972     0.200
    10.264    28.617     0.200
    10.264    29.914     0.200
    10.347    27.247     0.200
    10.345    27.151     0.200
    10.495    28.811     0.200
    10.587    27.752     0.200
    10.735    29.091     0.200
    10.791    29.567     0.200
    10.791    30.067     0.200
    10.833    28.980     0.200
    10.851    27.817     0.200
    10.851    27.930     0.200
    10.856    27.913     0.200
    10.932    28.719     0.200
    10.919    28.977     0.200
    10.975    28.988     0.200
    10.914    28.930     0.200
    10.955    27.678     0.200
    10.971    31.962     0.200
    10.971    28.341     0.200
    10.971    29.455     0.200
    11.058    30.353     0.200
    11.180    28.933     0.200
    11.183    29.796     0.200
    11.310    29.813     0.200
    11.359    33.247     0.200
    11.465    31.392     0.200
    11.490    32.718     0.200
    11.490    31.918     0.200
    11.598    32.653     0.200
    11.662    29.107     0.200
    11.843    31.389     0.200
    11.888    35.563     0.200
    11.918    29.572     0.200
    11.918    31.458     0.200
    12.205    30.706     0.200
    12.205    33.066     0.200
    12.163    37.363     0.200
    12.209    32.714     0.200
    12.335    35.351     0.200
    12.345    32.531     0.200
    12.345    32.230     0.200
    12.910    32.844     0.200
    12.916    30.321     0.200
    12.916    32.200     0.200
    12.970    34.488     0.200
    12.970    33.602     0.200
    13.014    35.425     0.200
    13.096    30.396     0.200
    13.096    34.494     0.200
    13.096    34.017     0.200
    13.435    36.417     0.200
    13.522    34.398     0.200
    13.627    36.818     0.200
    13.627    32.647     0.200
    13.824    36.977     0.200
    13.865    35.502     0.200
    13.954    33.754     0.200
    13.974    36.183     0.200
    13.974    33.629     0.200
    14.023    34.275     0.200
    14.023    34.650     0.200
    14.056    37.264     0.200
    14.219    34.169     0.200
    14.331    38.210     0.200
    14.366    37.248     0.200
    14.388    33.395     0.200
    14.428    34.491     0.200
    14.428    36.136     0.200
    14.551    33.352     0.200
    14.551    36.864     0.200
    14.551    35.079     0.200
    14.734    33.913     0.200
    14.734    36.456     0.200
    14.750    35.111     0.200
    14.896    36.831     0.200
    15.070    35.780     0.200
    15.070    37.753     0.200
    15.232    37.939     0.200
    15.303    35.319     0.200
    15.303    36.811     0.200
    15.330    36.226     0.200
    15.305    34.295     0.200
    15.375    36.454     0.200
    15.344    34.534     0.200
    15.436    35.160     0.200
    15.574    36.094     0.200
    15.709    36.012     0.200
    15.729    35.912     0.200
    15.917    36.423     0.200
    15.924    38.316     0.200
    15.936    37.324     0.200
    15.936    37.820     0.200
    15.946    37.508     0.200
    15.960    35.750     0.200
    16.129    37.932     0.200
    16.106    38.899     0.200
    16.124    38.028     0.200
    16.311    38.649     0.200
    16.438    36.972     0.200
    16.622    38.393     0.200
    16.727    38.596     0.200
    16.739    37.951     0.200
    17.375    38.536     0.200
    17.827    38.837     0.200
    18.278    38.248     0.200
    18.545    40.929     0.200
    18.620    40.805     0.200
    18.770    42.519     0.200
    18.714    41.910     0.200
    18.821    40.553     0.200
    18.755    39.633     0.200
    18.893    42.805     0.200
    18.791    39.514     0.200
    18.913    39.623     0.200
    18.805    40.742     0.200
    18.805    42.074     0.200
    19.057    40.309     0.200
    19.076    40.752     0.200
    19.126    41.211     0.200
    19.026    39.966     0.200
    19.142    40.877     0.200
    19.229    39.402     0.200
    19.360    39.712     0.200
    19.521    40.487     0.200
    19.770    41.586     0.200
    19.911    42.334     0.200
    19.985    39.022     0.200
    20.121    41.489     0.200
    20.205    43.222     0.200
    20.092    40.125     0.200
    20.197    39.604     0.200
    20.222    40.305     0.200
    20.342    40.306     0.200
    20.478    39.026     0.200
    20.428    39.507     0.200
    20.499    40.191     0.200
    20.499    40.383     0.200
    20.679    39.775     0.200
    20.654    40.472     0.200
    20.716    39.550     0.200
    20.762    40.007     0.200
    20.872    40.668     0.200
     1.648     9.493     0.200
     1.859     9.676     0.200
     2.041    10.584     0.200
     2.504    11.454     0.200
     2.871    12.219     0.200
     2.837    11.783     0.200
     3.011    12.892     0.200
     3.045    12.405     0.200
     3.158    13.325     0.200
     3.157    13.010     0.200
     3.197    13.244     0.200
     3.116    12.795     0.200
     3.124    12.212     0.200
     3.294    13.509     0.200
     3.317    13.151     0.200
     3.383    13.825     0.200
     3.473    14.681     0.200
     3.499    13.187     0.200
     3.527    13.857     0.200
     3.662    15.107     0.200
     3.753    15.123     0.200
     3.761    15.506     0.200
     3.816    14.218     0.200
     3.737    14.507     0.200
     3.745    14.210     0.200
     3.747    15.104     0.200
     3.906    14.526     0.200
     3.795    15.289     0.200
     3.925    15.208     0.200
     3.944    15.615     0.200
     3.944    15.615     0.200
     4.013    14.649     0.200
     4.056    14.286     0.200
     4.159    15.721     0.200
     4.033    15.477     0.200
     4.213    15.903     0.200
     4.272    15.569     0.200
     4.295    15.219     0.200
     4.357    15.307     0.200
     4.357    15.135     0.200
     4.338    16.065     0.200
     4.391    14.204     0.200
     4.290    17.649     0.200
     4.482    15.368     0.200
     4.414    15.628     0.200
     4.467    16.912     0.200
     4.562    14.161     0.200
     4.534    16.949     0.200
     4.440    17.234     0.200
     4.685    14.086     0.200
     4.689    14.468     0.200
     4.735    14.361     0.200
     4.791    14.255     0.200
     4.821    15.486     0.200
     4.688    14.536     0.200
     4.716    16.550     0.200
     4.873    15.136     0.200
     4.922    15.168     0.200
     5.004    15.204     0.200
     5.003    15.498     0.200
     5.043    15.185     0.200
     5.066    14.763     0.200
     5.025    16.749     0.200
     5.119    15.633     0.200
     5.405    18.222     0.200
     5.366    17.884     0.200
     5.489    17.586     0.200
     5.343    19.157     0.200
     5.467    18.039     0.200
     5.558    19.130     0.200
     5.713    19.844     0.200
     5.756    18.068     0.200
     5.754    17.832     0.200
     5.830    18.212     0.200
     5.853    18.842     0.200
     5.947    16.748     0.200
     6.019    19.606     0.200
     5.992    20.195     0.200
     6.051    17.112     0.200
     6.101    19.345     0.200
     6.102    19.033     0.200
     6.062    20.372     0.200
     6.062    20.462     0.200
     6.024    19.322     0.200
     6.171    18.935     0.200
     6.156    18.902     0.200
     6.203    20.160     0.200
     6.180    19.630     0.200
     6.245    19.163     0.200
     6.303    20.259     0.200
     6.334    17.294     0.200
     6.313    19.375     0.200
     6.300    20.230     0.200
     6.352    19.057     0.200
     6.358    19.043     0.200
     6.324    19.982     0.200
     6.400    16.884     0.200
     6.506    18.316     0.200
     6.496    17.646     0.200
     6.616    20.542     0.200
     6.624    20.644     0.200
     6.618    20.517     0.200
     6.688    20.185     0.200
     6.674    19.864     0.200
     6.733    17.936     0.200
     6.772    21.918     0.200
     6.786    20.029     0.200
     6.890    20.445     0.200
     6.918    20.213     0.200
     6.970    19.209     0.200
     6.992    19.650     0.200
     6.985    19.338     0.200
     7.006    19.491     0.200
     7.062    20.035     0.200
     7.111    20.662     0.200
     7.154    20.459     0.200
     7.195    18.786     0.200
     7.174    20.528     0.200
     7.189    21.148     0.200
     7.170    23.172     0.200
     7.204    21.371     0.200
     7.275    22.944     0.200
     7.331    20.791     0.200
     7.407    22.308     0.200
     7.491    19.821     0.200
     7.560    20.326     0.200
     7.594    20.928     0.200
     7.719    21.760     0.200
     7.975    21.285     0.200
     8.052    23.779     0.200
     8.307    23.976     0.200
     8.343    20.986     0.200
     8.363    24.146     0.200
     8.397    24.455     0.200
     8.719    21.797     0.200
     8.920    26.090     0.200
     9.210    27.260     0.200
     9.313    23.263     0.200
     9.454    25.618     0.200
     9.612    23.768     0.200
     9.678    24.003     0.200
     9.695    24.212     0.200
     9.887    25.169     0.200
    10.012    26.670     0.200
    10.181    25.933     0.200
    10.600    25.241     0.200
    10.913    25.492     0.200
    12.885    30.881     0.200
    18.480    39.133     0.200
    19.501    39.051     0.200
    20.224    40.109     0.200
     1.582     8.862     0.200
     1.647     9.125     0.200
     1.966     8.709     0.200
     2.038    10.906     0.200
     2.332    12.084     0.200
     2.507    11.282     0.200
     2.871    11.867     0.200
     2.867    13.073     0.200
     2.831    12.466     0.200
     2.830    11.314     0.200
     3.006    13.314     0.200
     3.039    12.921     0.200
     3.116    13.678     0.200
     3.161    13.022     0.200
     3.114    13.381     0.200
     3.288    13.585     0.200
     3.311    13.507     0.200
     3.378    13.641     0.200
     3.748    15.103     0.200
     3.736    14.635     0.200
     3.920    15.255     0.200
     3.938    15.399     0.200
     3.938    15.399     0.200
     4.090    16.197     0.200
     4.294    15.917     0.200
     4.357    17.088     0.200
     4.356    14.662     0.200
     4.391    15.982     0.200
     4.292    17.764     0.200
     4.420    15.454     0.200
     4.924    14.794     0.200
     5.006    15.536     0.200
     5.121    16.845     0.200
     5.759    17.610     0.200
     5.921    18.736     0.200
     5.921    18.837     0.200
     5.950    16.093     0.200
     5.950    16.292     0.200
     6.055    16.581     0.200
     6.206    19.811     0.200
     6.318    18.597     0.200
     6.364    18.768     0.200
     6.510    17.858     0.200
     6.921    20.261     0.200
     6.989    18.870     0.200
     7.010    19.426     0.200
     7.158    20.598     0.200
     7.280    22.772     0.200
     7.979    21.422     0.200
     8.346    20.728     0.200
     8.722    21.741     0.200
     9.891    25.102     0.200
    10.767    30.078     0.200
    11.821    29.683     0.200
     1.448     8.341     0.200
     1.659     9.439     0.200
     1.734    10.158     0.200
     1.975     8.783     0.200
     2.050    10.944     0.200
     2.495    12.366     0.200
     2.840    12.162     0.200
     2.859    11.299     0.200
     3.104    13.835     0.200
     4.412    15.758     0.200
     4.912    15.272     0.200
     5.849    18.298     0.200
     6.310    18.919     0.200
     6.978    19.713     0.200
     6.999    19.871     0.200
     7.270    20.407     0.200
     8.334    21.087     0.200
     8.710    21.900     0.200
     9.307    23.740     0.200
     9.881    25.341     0.200
     1.676    10.120     0.200
     1.972     9.918     0.200
     2.358    13.025     0.200
     2.836    12.619     0.200
     2.838    12.773     0.200
     3.142    15.486     0.200
     3.767    15.733     0.200
     3.802    18.170     0.200
     4.022    16.582     0.200
     4.123    16.413     0.200
     4.258    16.643     0.200
     4.320    15.846     0.200
     4.358    16.373     0.200
     4.421    16.443     0.200
     4.786    16.776     0.200
     4.897    16.476     0.200
     6.136    20.224     0.200
     6.315    20.739     0.200
     6.362    19.593     0.200
     6.976    19.722     0.200
     7.171    20.948     0.200
     7.458    20.999     0.200
     8.325    21.974     0.200
     8.702    22.882     0.200
     9.602    25.381     0.200
     9.670    24.891     0.200
     9.880    26.740     0.200
    13.921    34.179     0.200
     1.663     9.843     0.200
     1.739    10.534     0.200
     1.971     9.641     0.200
     2.051    11.382     0.200
     2.084    11.643     0.200
     2.347    12.753     0.200
     2.494    13.120     0.200
     2.824    13.474     0.200
     2.857    14.288     0.200
     2.853    12.261     0.200
     2.836    12.779     0.200
     2.996    14.079     0.200
     3.033    13.790     0.200
     3.105    15.543     0.200
     3.279    14.573     0.200
     3.307    14.037     0.200
     3.371    14.300     0.200
     3.737    16.801     0.200
     3.752    16.615     0.200
     3.808    18.336     0.200
     3.913    16.405     0.200
     3.930    16.454     0.200
     3.930    16.454     0.200
     4.039    15.664     0.200
     4.140    15.830     0.200
     4.253    15.508     0.200
     4.276    16.372     0.200
     4.338    15.578     0.200
     4.374    16.030     0.200
     4.418    16.115     0.200
     4.463    15.398     0.200
     4.803    16.324     0.200
     4.909    16.124     0.200
     5.104    15.902     0.200
     5.473    18.508     0.200
     5.853    18.674     0.200
     6.153    19.673     0.200
     6.314    19.788     0.200
     6.361    19.045     0.200
     6.616    20.470     0.200
     6.981    21.213     0.200
     7.001    21.469     0.200
     7.474    20.851     0.200
     8.334    23.315     0.200
     8.710    24.525     0.200
     9.607    26.657     0.200
     9.674    25.679     0.200
     9.686    25.936     0.200
     1.591     9.675     0.200
     1.605    10.006     0.200
     1.634     9.773     0.200
     1.670     9.925     0.200
     1.741    10.742     0.200
     1.864    10.549     0.200
     1.969    10.055     0.200
     2.055    11.766     0.200
     2.352    12.868     0.200
     2.490    12.483     0.200
     2.814    13.079     0.200
     2.842    12.570     0.200
     2.855    13.836     0.200
     2.835    12.808     0.200
     2.986    13.370     0.200
     3.024    13.661     0.200
     3.102    14.321     0.200
     3.148    14.338     0.200
     3.152    13.873     0.200
     3.136    13.227     0.200
     3.153    12.835     0.200
     3.197    14.301     0.200
     3.269    14.261     0.200
     3.301    15.382     0.200
     3.299    14.353     0.200
     3.267    13.544     0.200
     3.361    14.292     0.200
     3.464    15.803     0.200
     3.524    14.164     0.200
     3.553    14.115     0.200
     3.647    15.979     0.200
     3.726    15.856     0.200
     3.757    16.364     0.200
     3.795    15.121     0.200
     3.789    15.319     0.200
     3.761    15.430     0.200
     3.801    15.982     0.200
     3.771    15.032     0.200
     3.778    15.816     0.200
     3.865    17.593     0.200
     3.826    16.142     0.200
     3.911    16.900     0.200
     3.899    15.770     0.200
     3.903    16.340     0.200
     3.920    16.192     0.200
     3.920    16.192     0.200
     3.984    16.212     0.200
     4.029    15.364     0.200
     4.063    14.371     0.200
     4.078    16.683     0.200
     4.066    15.928     0.200
     4.129    16.279     0.200
     4.147    15.057     0.200
     4.208    16.910     0.200
     4.219    18.070     0.200
     4.242    16.052     0.200
     4.264    16.076     0.200
     4.327    16.036     0.200
     4.328    17.097     0.200
     4.333    17.888     0.200
     4.325    18.062     0.200
     4.365    15.207     0.200
     4.322    18.598     0.200
     4.451    16.104     0.200
     4.423    16.227     0.200
     4.460    18.197     0.200
     4.468    16.882     0.200
     4.535    15.191     0.200
     4.537    15.466     0.200
     4.528    17.892     0.200
     4.521    17.382     0.200
     4.549    15.133     0.200
     4.624    15.322     0.200
     4.660    15.095     0.200
     4.665    15.602     0.200
     4.713    15.524     0.200
     4.714    15.496     0.200
     4.657    17.675     0.200
     4.715    18.138     0.200
     4.714    14.622     0.200
     4.767    15.217     0.200
     4.793    16.711     0.200
     4.805    16.174     0.200
     4.848    16.337     0.200
     4.903    16.085     0.200
     4.935    19.346     0.200
     4.980    16.295     0.200
     4.989    16.781     0.200
     5.019    16.240     0.200
     5.014    18.527     0.200
     5.043    16.134     0.200
     5.096    16.791     0.200
     5.289    18.504     0.200
     5.369    18.827     0.200
     5.401    18.814     0.200
     5.376    19.210     0.200
     5.464    17.779     0.200
     5.466    18.844     0.200
     5.466    19.536     0.200
     5.551    17.957     0.200
     5.559    20.500     0.200
     5.559    19.910     0.200
     5.712    20.578     0.200
     5.740    19.039     0.200
     5.742    19.393     0.200
     5.771    18.492     0.200
     5.815    19.683     0.200
     5.815    19.374     0.200
     5.836    18.935     0.200
     5.855    19.513     0.200
     5.901    19.568     0.200
     5.904    20.737     0.200
     5.936    17.469     0.200
     5.998    19.946     0.200
     5.992    20.908     0.200
     6.016    19.872     0.200
     6.041    17.921     0.200
     6.032    20.543     0.200
     6.059    20.430     0.200
     6.062    21.401     0.200
     6.080    20.189     0.200
     6.082    19.863     0.200
     6.081    19.840     0.200
     6.143    19.956     0.200
     6.142    19.459     0.200
     6.162    21.624     0.200
     6.187    21.036     0.200
     6.198    20.409     0.200
     6.225    20.192     0.200
     6.216    21.361     0.200
     6.225    19.710     0.200
     6.269    18.984     0.200
     6.279    20.760     0.200
     6.302    21.049     0.200
     6.323    18.353     0.200
     6.326    17.950     0.200
     6.317    19.616     0.200
     6.321    21.390     0.200
     6.350    19.388     0.200
     6.364    19.668     0.200
     6.476    20.781     0.200
     6.495    19.349     0.200
     6.492    18.723     0.200
     6.518    18.281     0.200
     6.598    21.636     0.200
     6.609    21.218     0.200
     6.616    20.527     0.200
     6.617    21.324     0.200
     6.671    22.489     0.200
     6.658    21.846     0.200
     6.686    21.776     0.200
     6.728    18.576     0.200
     6.747    21.506     0.200
     6.781    21.269     0.200
     6.815    21.955     0.200
     6.873    21.731     0.200
     6.876    21.594     0.200
     6.905    20.154     0.200
     6.914    20.053     0.200
     6.958    20.236     0.200
     6.948    23.859     0.200
     6.947    22.463     0.200
     6.939    20.944     0.200
     6.947    21.574     0.200
     6.982    20.155     0.200
     6.980    20.183     0.200
     6.982    22.560     0.200
     7.001    20.338     0.200
     7.049    20.877     0.200
     7.044    23.733     0.200
     7.095    21.336     0.200
     7.145    21.155     0.200
     7.162    21.249     0.200
     7.162    22.858     0.200
     7.153    21.767     0.200
     7.170    20.962     0.200
     7.148    22.020     0.200
     7.163    21.340     0.200
     7.181    21.933     0.200
     7.174    23.022     0.200
     7.193    22.593     0.200
     7.197    21.851     0.200
     7.226    22.614     0.200
     7.275    23.845     0.200
     7.323    21.775     0.200
     7.349    22.319     0.200
     7.390    23.296     0.200
     7.464    21.231     0.200
     7.469    21.982     0.200
     7.532    21.544     0.200
     7.544    21.297     0.200
     7.587    21.001     0.200
     7.584    21.531     0.200
     7.688    23.163     0.200
     7.692    21.578     0.200
     7.767    21.097     0.200
     7.853    21.287     0.200
     7.967    22.365     0.200
     7.967    23.058     0.200
     8.026    21.976     0.200
     8.057    22.215     0.200
     8.053    24.763     0.200
     8.221    22.098     0.200
     8.272    23.301     0.200
     8.275    25.156     0.200
     8.331    21.622     0.200
     8.341    25.695     0.200
     8.364    23.230     0.200
     8.364    23.230     0.200
     8.401    24.799     0.200
     8.440    26.349     0.200
     8.473    22.858     0.200
     8.533    22.959     0.200
     8.684    28.597     0.200
     8.693    26.491     0.200
     8.707    22.929     0.200
     8.893    27.221     0.200
     8.920    26.601     0.200
     9.035    23.598     0.200
     9.151    24.443     0.200
     9.172    30.802     0.200
     9.180    28.907     0.200
     9.202    25.258     0.200
     9.276    26.553     0.200
     9.308    24.109     0.200
     9.336    27.829     0.200
     9.462    24.622     0.200
     9.559    24.884     0.200
     9.594    25.878     0.200
     9.606    24.636     0.200
     9.633    29.300     0.200
     9.674    26.448     0.200
     9.674    25.048     0.200
     9.683    25.235     0.200
     9.883    26.098     0.200
     9.946    29.884     0.200
     9.997    28.064     0.200
     9.996    26.346     0.200
    10.179    26.849     0.200
    10.328    29.978     0.200
    10.604    27.961     0.200
    10.950    30.828     0.200
    11.146    27.160     0.200
    11.647    32.670     0.200
    11.647    34.033     0.200
    11.815    29.960     0.200
    11.908    34.329     0.200
    11.908    32.903     0.200
    12.183    32.999     0.200
    12.196    33.687     0.200
    12.196    33.949     0.200
    12.879    31.445     0.200
    12.905    36.548     0.200
    12.905    35.282     0.200
    12.961    36.300     0.200
    12.961    37.596     0.200
    13.499    34.810     0.200
    13.615    38.474     0.200
    13.964    39.248     0.200
    14.414    37.751     0.200
    14.414    36.369     0.200
    15.984    37.322     0.200
    18.452    41.489     0.200
    18.471    41.325     0.200
    18.607    40.892     0.200
    19.303    41.848     0.200
    19.473    40.984     0.200
    19.473    40.664     0.200
     1.766    11.513     0.200
     1.944    11.320     0.200
     2.093    12.967     0.200
     2.499    12.979     0.200
     2.829    13.154     0.200
     4.018    16.308     0.200
     4.309    16.830     0.200
     4.452    16.829     0.200
     4.435    17.392     0.200
     4.781    17.097     0.200
     5.880    20.168     0.200
     6.131    20.635     0.200
     6.344    20.550     0.200
     6.392    20.295     0.200
     6.639    21.612     0.200
     6.999    21.205     0.200
     7.200    24.168     0.200
     7.455    23.489     0.200
     7.983    22.920     0.200
     8.076    24.435     0.200
     8.342    22.339     0.200
     8.719    23.340     0.200
     9.328    25.234     0.200
     1.645     9.845     0.200
     1.749    10.499     0.200
     1.960     9.067     0.200
     2.035    10.861     0.200
     2.100    11.475     0.200
     2.330    12.459     0.200
     2.510    11.996     0.200
     2.870    11.355     0.200
     4.354    14.882     0.200
     4.391    15.239     0.200
     4.426    15.831     0.200
     4.479    14.872     0.200
     4.820    15.540     0.200
     4.926    15.497     0.200
     5.864    18.463     0.200
     6.170    19.084     0.200
     6.324    19.385     0.200
     6.370    18.953     0.200
     6.628    20.044     0.200
     6.994    19.969     0.200
     7.015    19.825     0.200
     7.181    22.782     0.200
     7.983    20.425     0.200
     8.350    20.949     0.200
     8.726    21.254     0.200
     9.322    23.695     0.200
     1.464     8.901     0.200
     1.584     9.103     0.200
     1.677     9.958     0.200
     1.733    11.033     0.200
     1.976    10.255     0.200
     2.063    11.945     0.200
     2.073    11.423     0.200
     2.359    12.857     0.200
     2.482    12.015     0.200
     2.838    12.880     0.200
     2.847    13.490     0.200
     3.094    14.876     0.200
     3.143    14.987     0.200
     3.144    15.680     0.200
     4.238    15.950     0.200
     4.323    15.703     0.200
     4.448    16.383     0.200
     4.415    15.889     0.200
     4.788    16.536     0.200
     4.896    15.934     0.200
     5.090    16.087     0.200
     5.458    18.319     0.200
     5.828    18.700     0.200
     5.847    19.484     0.200
     5.894    20.034     0.200
     5.928    17.234     0.200
     6.138    19.885     0.200
     6.180    22.101     0.200
     6.310    20.382     0.200
     6.356    19.539     0.200
     6.487    19.016     0.200
     6.609    21.891     0.200
     6.609    20.995     0.200
     6.898    21.121     0.200
     6.950    20.802     0.200
     6.975    21.722     0.200
     6.972    20.151     0.200
     6.993    20.110     0.200
     7.267    22.816     0.200
     7.959    22.437     0.200
     8.323    20.387     0.200
     8.699    22.299     0.200
     9.598    24.607     0.200
     1.657     9.370     0.200
     1.983     8.782     0.200
     2.053    10.531     0.200
     2.493    11.291     0.200
     2.345    11.265     0.200
     2.866    11.120     0.200
     2.845    11.904     0.200
     3.019    13.216     0.200
     3.054    12.484     0.200
     3.146    13.958     0.200
     3.144    13.570     0.200
     3.125    12.276     0.200
     3.299    14.322     0.200
     3.302    13.634     0.200
     3.327    12.450     0.200
     3.392    13.718     0.200
     3.760    15.600     0.200
     3.863    16.327     0.200
     3.751    14.950     0.200
     3.745    14.238     0.200
     3.753    13.969     0.200
     3.827    17.524     0.200
     3.940    15.001     0.200
     3.934    15.009     0.200
     3.952    15.505     0.200
     3.952    15.505     0.200
     4.050    13.799     0.200
     4.019    15.543     0.200
     4.081    13.075     0.200
     4.074    16.053     0.200
     4.155    13.805     0.200
     4.201    15.595     0.200
     4.215    17.083     0.200
     4.267    14.184     0.200
     4.292    14.195     0.200
     4.326    16.105     0.200
     4.350    14.568     0.200
     4.353    14.162     0.200
     4.384    13.726     0.200
     4.292    17.532     0.200
     4.403    15.708     0.200
     4.455    16.911     0.200
     4.477    14.308     0.200
     4.521    16.625     0.200
     4.544    16.146     0.200
     4.681    15.225     0.200
     4.815    15.194     0.200
     4.822    14.778     0.200
     4.912    14.859     0.200
     4.992    15.562     0.200
     4.963    17.261     0.200
     5.111    14.873     0.200
     5.320    17.295     0.200
     5.482    16.413     0.200
     5.576    16.103     0.200
     5.746    17.173     0.200
     5.840    17.628     0.200
     5.841    18.825     0.200
     5.907    18.946     0.200
     5.935    16.324     0.200
     5.841    18.424     0.200
     6.010    19.249     0.200
     6.039    17.452     0.200
     6.092    18.688     0.200
     6.093    18.985     0.200
     6.145    18.169     0.200
     6.164    18.548     0.200
     6.192    19.825     0.200
     6.236    18.908     0.200
     6.190    19.145     0.200
     6.301    18.954     0.200
     6.346    19.219     0.200
     6.309    19.755     0.200
     6.495    18.086     0.200
     6.619    20.037     0.200
     6.606    20.000     0.200
     6.730    21.948     0.200
     6.684    19.877     0.200
     6.879    20.611     0.200
     6.907    19.986     0.200
     6.958    20.077     0.200
     6.972    19.218     0.200
     6.980    21.026     0.200
     6.993    19.473     0.200
     7.050    20.809     0.200
     7.012    21.558     0.200
     7.142    20.332     0.200
     7.162    20.300     0.200
     7.158    21.951     0.200
     7.177    21.022     0.200
     7.191    19.263     0.200
     7.192    21.651     0.200
     7.195    20.554     0.200
     7.263    22.919     0.200
     7.319    20.668     0.200
     7.485    19.742     0.200
     7.715    23.214     0.200
     7.963    20.960     0.200
     8.026    20.624     0.200
     8.040    21.958     0.200
     8.062    22.193     0.200
     8.295    21.284     0.200
     8.304    24.760     0.200
     8.331    20.357     0.200
     8.385    23.034     0.200
     8.476    21.370     0.200
     8.694    23.027     0.200
     8.708    21.469     0.200
     8.927    26.590     0.200
     9.036    22.435     0.200
     9.198    22.937     0.200
     9.206    26.654     0.200
     9.218    22.905     0.200
     9.301    23.045     0.200
     9.442    25.296     0.200
     9.600    23.643     0.200
     9.666    24.184     0.200
     9.683    23.882     0.200
     9.694    24.860     0.200
     9.874    24.945     0.200
    10.307    25.902     0.200
    10.791    27.554     0.200
    11.447    29.496     0.200
    13.916    31.984     0.200
    18.474    40.517     0.200
    19.494    38.887     0.200
    19.494    38.637     0.200
     1.421     8.336     0.200
     1.605     9.231     0.200
     1.634     9.621     0.200
     1.648    10.096     0.200
     1.766    10.399     0.200
     1.943     8.951     0.200
     2.020    11.081     0.200
     2.115    10.778     0.200
     2.138    12.128     0.200
     2.525    11.914     0.200
     2.887    13.367     0.200
     3.099    13.402     0.200
     3.136    13.701     0.200
     3.497    15.759     0.200
     3.788    18.032     0.200
     4.064    15.705     0.200
     4.359    15.200     0.200
     4.443    16.085     0.200
     4.828    15.894     0.200
     4.939    15.739     0.200
     5.025    15.865     0.200
     5.881    17.206     0.200
     6.034    20.312     0.200
     6.119    18.927     0.200
     6.178    18.736     0.200
     6.341    18.232     0.200
     6.387    19.599     0.200
     6.645    18.088     0.200
     7.011    18.920     0.200
     7.032    19.275     0.200
     7.198    20.431     0.200
     7.303    20.613     0.200
     7.500    21.507     0.200
     7.999    20.581     0.200
     8.365    21.411     0.200
     8.741    21.820     0.200
     9.339    22.948     0.200
     9.638    23.161     0.200
     9.704    23.587     0.200
     1.652    10.040     0.200
     1.663    10.785     0.200
     1.848    11.521     0.200
     2.043    12.259     0.200
     2.342    13.140     0.200
     2.797    13.876     0.200
     2.818    13.512     0.200
     2.970    14.800     0.200
     3.007    14.192     0.200
     3.127    13.771     0.200
     3.151    14.627     0.200
     3.253    15.268     0.200
     3.281    14.692     0.200
     3.344    15.260     0.200
     3.519    15.087     0.200
     3.711    16.952     0.200
     3.755    15.843     0.200
     3.780    16.401     0.200
     3.766    15.790     0.200
     3.771    16.210     0.200
     3.783    16.872     0.200
     3.886    16.776     0.200
     3.903    16.725     0.200
     3.903    16.725     0.200
     4.032    16.015     0.200
     4.069    15.279     0.200
     4.129    15.455     0.200
     4.242    16.183     0.200
     4.263    15.271     0.200
     4.331    16.692     0.200
     4.326    16.880     0.200
     4.369    16.030     0.200
     4.326    19.136     0.200
     4.441    16.595     0.200
     4.452    16.339     0.200
     4.503    18.472     0.200
     4.795    17.356     0.200
     4.811    16.575     0.200
     4.913    16.746     0.200
     5.002    18.106     0.200
     4.917    19.535     0.200
     5.103    17.081     0.200
     5.272    19.590     0.200
     5.552    18.432     0.200
     5.752    20.808     0.200
     5.832    21.561     0.200
     5.872    21.690     0.200
     5.797    20.066     0.200
     6.091    21.135     0.200
     6.146    20.698     0.200
     6.234    22.264     0.200
     6.335    19.888     0.200
     6.382    20.241     0.200
     6.633    20.510     0.200
     6.996    21.577     0.200
     7.017    21.232     0.200
     7.174    21.495     0.200
     7.191    24.498     0.200
     7.155    22.619     0.200
     7.291    21.930     0.200
     7.468    21.163     0.200
     7.687    24.312     0.200
     7.982    23.569     0.200
     8.070    24.144     0.200
     8.275    23.752     0.200
     8.344    23.247     0.200
     8.419    24.572     0.200
     8.681    26.513     0.200
     8.720    23.753     0.200
     9.180    27.090     0.200
     9.324    25.606     0.200
     9.621    25.838     0.200
     9.689    26.244     0.200
     9.678    26.878     0.200
     9.697    25.757     0.200
     9.900    26.191     0.200
    10.830    29.136     0.200
    19.477    41.722     0.200
    19.477    41.322     0.200
    20.887    40.912     0.200
     1.575     9.771     0.200
     1.588     9.605     0.200
     1.618     9.657     0.200
     1.656     9.909     0.200
     1.734    10.727     0.200
     1.975    10.550     0.200
     2.049    12.092     0.200
     2.496    12.559     0.200
     2.836    13.528     0.200
     2.856    14.518     0.200
     2.840    14.450     0.200
     2.863    12.351     0.200
     3.009    14.442     0.200
     3.044    14.282     0.200
     3.105    15.834     0.200
     3.124    16.074     0.200
     3.192    15.362     0.200
     3.292    15.624     0.200
     3.317    14.749     0.200
     3.382    14.648     0.200
     3.745    14.813     0.200
     3.755    15.887     0.200
     3.754    15.125     0.200
     3.750    17.095     0.200
     3.817    17.193     0.200
     3.925    16.591     0.200
     3.942    16.983     0.200
     3.942    16.983     0.200
     4.010    16.945     0.200
     4.048    15.210     0.200
     4.151    15.298     0.200
     4.263    15.237     0.200
     4.288    18.104     0.200
     4.298    18.688     0.200
     4.348    15.938     0.200
     4.349    15.386     0.200
     4.382    15.799     0.200
     4.411    16.064     0.200
     4.473    15.906     0.200
     4.535    17.613     0.200
     4.822    16.822     0.200
     4.914    16.679     0.200
     4.954    17.734     0.200
     4.996    17.760     0.200
     5.111    16.817     0.200
     5.573    17.804     0.200
     5.848    19.493     0.200
     6.162    19.929     0.200
     6.309    19.919     0.200
     6.354    19.685     0.200
     6.612    20.875     0.200
     6.695    22.611     0.200
     6.978    20.503     0.200
     6.999    20.457     0.200
     7.166    21.318     0.200
     7.270    23.200     0.200
     7.483    21.215     0.200
     7.968    22.456     0.200
     8.047    23.832     0.200
     8.336    21.365     0.200
     8.392    24.101     0.200
     8.712    22.276     0.200
     9.450    25.555     0.200
     9.606    26.239     0.200
     1.638     9.706     0.200
     1.754    10.842     0.200
     1.955     9.325     0.200
     2.028    10.969     0.200
     2.323    12.268     0.200
     2.517    11.962     0.200
     2.876    11.730     0.200
     4.063    17.252     0.200
     4.430    15.917     0.200
     5.869    19.927     0.200
     6.374    19.729     0.200
     6.633    19.503     0.200
     7.000    19.930     0.200
     7.021    19.884     0.200
     7.989    21.980     0.200
     8.357    20.694     0.200
     8.733    20.804     0.200
     1.455     9.243     0.200
     1.574     9.648     0.200
     1.666     9.677     0.200
     1.729    10.744     0.200
     1.980     9.704     0.200
     2.057    11.991     0.200
     2.352    13.117     0.200
     2.488    11.627     0.200
     2.853    12.486     0.200
     3.144    14.121     0.200
     4.038    14.817     0.200
     4.254    15.381     0.200
     4.408    16.142     0.200
     4.464    17.530     0.200
     4.803    16.837     0.200
     4.904    16.227     0.200
     5.843    19.592     0.200
     5.901    19.615     0.200
     6.140    19.625     0.200
     6.152    19.587     0.200
     6.186    20.190     0.200
     6.351    19.568     0.200
     6.607    21.683     0.200
     6.614    21.294     0.200
     6.874    21.564     0.200
     6.902    21.931     0.200
     6.972    19.919     0.200
     6.977    22.156     0.200
     6.993    20.475     0.200
     7.161    23.312     0.200
     7.473    21.771     0.200
     7.961    21.880     0.200
     8.042    24.435     0.200
     8.327    21.601     0.200
     8.704    22.813     0.200
     9.599    25.061     0.200
     1.632    10.258     0.200
     1.645    10.099     0.200
     1.675    10.550     0.200
     1.630    10.224     0.200
     1.789    10.829     0.200
     1.814    10.915     0.200
     2.008    12.032     0.200
     2.537    12.442     0.200
     2.872    12.527     0.200
     2.784    14.113     0.200
     2.786    12.992     0.200
     2.991    13.861     0.200
     3.094    13.789     0.200
     3.242    14.872     0.200
     3.262    14.365     0.200
     3.330    14.839     0.200
     3.704    16.968     0.200
     3.722    15.505     0.200
     3.735    14.983     0.200
     3.872    16.422     0.200
     3.892    16.639     0.200
     3.892    16.639     0.200
     4.061    15.145     0.200
     4.100    15.187     0.200
     4.154    16.194     0.200
     4.268    16.224     0.200
     4.286    15.677     0.200
     4.351    16.380     0.200
     4.400    15.654     0.200
     4.400    18.052     0.200
     4.477    16.465     0.200
     4.468    17.152     0.200
     4.824    17.002     0.200
     4.843    16.979     0.200
     4.947    16.265     0.200
     4.898    18.443     0.200
     5.037    17.153     0.200
     5.135    17.111     0.200
     5.883    19.643     0.200
     5.775    19.009     0.200
     5.903    20.606     0.200
     5.948    20.285     0.200
     5.985    17.855     0.200
     6.090    18.789     0.200
     6.175    19.738     0.200
     6.190    20.159     0.200
     6.234    20.855     0.200
     6.125    20.924     0.200
     6.365    20.220     0.200
     6.245    21.514     0.200
     6.411    20.181     0.200
     6.543    19.642     0.200
     6.666    21.404     0.200
     6.618    21.661     0.200
     7.007    21.427     0.200
     7.030    18.962     0.200
     6.948    22.820     0.200
     7.195    22.141     0.200
     7.169    23.206     0.200
     7.222    24.324     0.200
     7.324    22.531     0.200
     7.352    23.604     0.200
     7.498    21.895     0.200
     8.017    22.344     0.200
     8.141    20.771     0.200
     8.296    27.882     0.200
     8.379    22.218     0.200
     8.310    25.421     0.200
     8.756    22.823     0.200
     8.872    28.659     0.200
     9.358    24.791     0.200
     9.656    25.513     0.200
     9.637    29.663     0.200
     9.732    25.724     0.200
     9.946    26.816     0.200
    11.864    30.739     0.200
     1.642     9.829     0.200
     1.655     9.801     0.200
     1.685     9.848     0.200
     1.630     9.896     0.200
     1.797    10.899     0.200
     1.912    10.023     0.200
     2.004    11.220     0.200
     2.541    12.135     0.200
     2.868    12.361     0.200
     2.778    12.993     0.200
     2.909    13.721     0.200
     2.980    13.798     0.200
     3.156    14.798     0.200
     3.093    13.236     0.200
     3.208    14.846     0.200
     3.232    14.934     0.200
     3.254    15.367     0.200
     3.251    14.010     0.200
     3.319    14.581     0.200
     3.489    13.161     0.200
     3.694    16.388     0.200
     3.818    14.510     0.200
     3.723    14.927     0.200
     3.737    14.848     0.200
     3.762    15.899     0.200
     3.861    16.031     0.200
     3.881    16.201     0.200
     3.881    16.201     0.200
     4.059    14.697     0.200
     4.150    15.063     0.200
     4.143    16.771     0.200
     4.281    17.556     0.200
     4.347    16.041     0.200
     4.398    15.392     0.200
     4.473    15.647     0.200
     4.477    16.466     0.200
     4.438    16.541     0.200
     4.821    16.456     0.200
     4.842    16.380     0.200
     4.949    15.651     0.200
     5.041    16.479     0.200
     5.135    16.543     0.200
     5.789    20.126     0.200
     5.911    20.029     0.200
     6.172    19.385     0.200
     6.374    20.238     0.200
     6.420    20.095     0.200
     6.673    21.437     0.200
     7.331    22.961     0.200
     7.496    21.138     0.200
     8.022    21.194     0.200
     8.383    22.186     0.200
     8.760    22.493     0.200
    20.902    39.834     0.200
     1.590    10.184     0.200
     1.619    10.140     0.200
     1.663    10.430     0.200
     1.868    11.044     0.200
     1.977    10.569     0.200
     2.855    13.159     0.200
     2.832    13.911     0.200
     2.842    13.173     0.200
     3.041    14.850     0.200
     3.130    13.577     0.200
     3.140    14.566     0.200
     3.288    15.753     0.200
     3.315    14.837     0.200
     3.379    15.287     0.200
     3.514    14.987     0.200
     3.745    17.772     0.200
     3.715    15.475     0.200
     3.752    15.659     0.200
     3.763    16.493     0.200
     3.761    15.688     0.200
     3.803    15.955     0.200
     3.816    16.010     0.200
     3.896    16.786     0.200
     3.927    17.208     0.200
     3.921    17.222     0.200
     3.938    17.711     0.200
     3.938    17.711     0.200
     4.004    16.642     0.200
     4.073    15.226     0.200
     4.076    17.596     0.200
     4.048    14.189     0.200
     4.208    17.837     0.200
     4.329    17.764     0.200
     4.341    16.686     0.200
     4.275    16.851     0.200
     4.375    16.083     0.200
     4.411    17.064     0.200
     4.457    18.294     0.200
     4.524    18.077     0.200
     4.456    18.050     0.200
     4.534    17.822     0.200
     4.695    15.654     0.200
     4.805    16.967     0.200
     4.815    16.914     0.200
     4.723    18.595     0.200
     4.908    16.769     0.200
     4.991    17.329     0.200
     4.951    18.860     0.200
     5.065    19.262     0.200
     5.104    17.227     0.200
     5.027    19.017     0.200
     5.020    19.151     0.200
     5.307    19.187     0.200
     5.396    19.338     0.200
     5.459    20.084     0.200
     5.375    19.558     0.200
     5.440    20.250     0.200
     5.552    20.913     0.200
     5.565    18.394     0.200
     5.658    20.710     0.200
     5.705    21.268     0.200
     5.706    21.386     0.200
     5.743    19.729     0.200
     5.663    19.651     0.200
     5.777    19.417     0.200
     5.838    19.712     0.200
     5.846    20.011     0.200
     5.904    20.236     0.200
     5.830    19.704     0.200
     5.935    18.079     0.200
     5.985    22.064     0.200
     6.040    18.728     0.200
     6.055    21.988     0.200
     6.055    21.449     0.200
     6.086    20.712     0.200
     6.088    20.897     0.200
     6.028    20.457     0.200
     6.024    21.945     0.200
     6.144    20.444     0.200
     6.155    20.716     0.200
     6.095    20.431     0.200
     6.189    21.708     0.200
     6.209    22.021     0.200
     6.231    21.426     0.200
     6.178    21.640     0.200
     6.295    21.771     0.200
     6.239    20.196     0.200
     6.308    20.529     0.200
     6.320    18.859     0.200
     6.323    19.047     0.200
     6.344    21.208     0.200
     6.354    20.491     0.200
     6.296    21.761     0.200
     6.390    18.993     0.200
     6.330    22.407     0.200
     6.494    20.050     0.200
     6.485    25.461     0.200
     6.516    18.998     0.200
     6.490    21.341     0.200
     6.602    21.796     0.200
     6.611    22.392     0.200
     6.617    21.814     0.200
     6.610    22.202     0.200
     6.680    22.266     0.200
     6.724    19.540     0.200
     6.655    21.576     0.200
     6.673    22.367     0.200
     6.758    23.169     0.200
     6.877    21.883     0.200
     6.791    21.628     0.200
     6.889    23.745     0.200
     6.906    21.051     0.200
     6.911    21.385     0.200
     6.837    22.455     0.200
     6.958    21.041     0.200
     6.975    21.037     0.200
     6.981    21.074     0.200
     6.996    20.993     0.200
     6.951    21.565     0.200
     7.049    21.673     0.200
     6.999    23.563     0.200
     7.098    22.211     0.200
     7.062    22.107     0.200
     7.143    22.080     0.200
     7.162    21.955     0.200
     7.164    23.831     0.200
     7.194    22.986     0.200
     7.180    22.325     0.200
     7.117    23.685     0.200
     7.233    24.626     0.200
     7.268    24.125     0.200
     7.321    22.607     0.200
     7.475    22.001     0.200
     7.406    24.314     0.200
     7.487    24.367     0.200
     7.533    22.632     0.200
     7.587    21.798     0.200
     7.695    24.142     0.200
     7.703    24.789     0.200
     7.767    22.594     0.200
     7.793    24.294     0.200
     7.964    23.298     0.200
     7.932    23.672     0.200
     8.025    22.384     0.200
     8.045    24.254     0.200
     8.060    23.384     0.200
     7.980    23.551     0.200
     8.029    26.537     0.200
     8.222    22.492     0.200
     8.285    23.655     0.200
     8.291    26.451     0.200
     8.331    22.520     0.200
     8.372    24.335     0.200
     8.372    24.335     0.200
     8.391    25.312     0.200
     8.456    27.759     0.200
     8.474    23.046     0.200
     8.397    26.250     0.200
     8.535    23.140     0.200
     8.686    24.578     0.200
     8.695    25.664     0.200
     8.707    23.730     0.200
     8.707    28.924     0.200
     8.718    24.906     0.200
     8.789    25.673     0.200
     8.912    29.195     0.200
     9.035    23.999     0.200
     9.189    24.808     0.200
     9.194    26.240     0.200
     9.194    30.440     0.200
     9.189    28.801     0.200
     9.211    24.849     0.200
     9.260    27.337     0.200
     9.304    25.065     0.200
     9.319    27.535     0.200
     9.450    27.256     0.200
     9.599    26.717     0.200
     9.602    25.479     0.200
     9.669    26.105     0.200
     9.652    31.801     0.200
     9.683    26.142     0.200
     9.685    26.719     0.200
     9.666    27.938     0.200
     9.839    28.623     0.200
     9.878    27.064     0.200
     9.999    26.550     0.200
    10.173    28.721     0.200
    10.800    30.208     0.200
    11.147    28.750     0.200
    11.326    31.562     0.200
    12.172    29.907     0.200
    12.875    33.090     0.200
    13.517    36.268     0.200
    14.398    37.969     0.200
    14.398    35.147     0.200
    15.994    40.146     0.200
    16.918    40.697     0.200
    18.464    40.745     0.200
    18.480    44.668     0.200
    19.315    40.929     0.200
    19.595    40.770     0.200
    20.232    44.332     0.200
     1.604     9.446     0.200
     1.633     9.498     0.200
     1.652    10.136     0.200
     1.854    10.739     0.200
     1.962    10.165     0.200
     2.040    11.777     0.200
     2.336    12.917     0.200
     2.862    13.244     0.200
     2.821    13.632     0.200
     2.827    12.789     0.200
     3.029    13.838     0.200
     3.162    14.465     0.200
     3.119    13.601     0.200
     3.277    15.054     0.200
     3.302    14.016     0.200
     3.367    14.713     0.200
     3.505    14.374     0.200
     3.736    17.218     0.200
     3.743    14.974     0.200
     3.759    15.852     0.200
     3.752    15.183     0.200
     3.802    17.890     0.200
     3.806    15.660     0.200
     3.910    16.485     0.200
     3.928    16.815     0.200
     3.928    16.815     0.200
     3.997    16.550     0.200
     4.194    17.413     0.200
     4.284    15.770     0.200
     4.348    16.121     0.200
     4.260    16.547     0.200
     4.384    15.304     0.200
     4.426    16.513     0.200
     4.448    17.838     0.200
     4.520    18.307     0.200
     4.812    16.104     0.200
     4.824    16.105     0.200
     4.920    16.329     0.200
     4.938    20.431     0.200
     5.004    17.103     0.200
     5.005    18.347     0.200
     5.114    16.510     0.200
     5.295    19.112     0.200
     5.571    17.651     0.200
     5.648    19.345     0.200
     5.756    19.240     0.200
     5.789    18.707     0.200
     5.851    19.279     0.200
     5.862    19.556     0.200
     5.816    19.384     0.200
     5.917    20.607     0.200
     5.949    17.735     0.200
     6.054    19.013     0.200
     6.097    21.003     0.200
     6.099    20.382     0.200
     6.157    20.107     0.200
     6.162    19.550     0.200
     6.202    21.477     0.200
     6.242    21.011     0.200
     6.283    20.643     0.200
     6.323    19.574     0.200
     6.335    19.539     0.200
     6.369    19.437     0.200
     6.508    19.908     0.200
     6.625    21.546     0.200
     6.690    21.984     0.200
     6.891    21.545     0.200
     6.919    22.011     0.200
     6.972    21.099     0.200
     6.990    20.184     0.200
     6.995    22.427     0.200
     7.011    20.840     0.200
     7.179    23.475     0.200
     7.283    23.869     0.200
     7.484    21.027     0.200
     7.979    21.648     0.200
     8.072    24.554     0.200
     8.292    22.594     0.200
     8.344    21.879     0.200
     8.406    25.256     0.200
     8.721    23.088     0.200
     9.196    24.942     0.200
     9.220    24.159     0.200
     9.319    24.611     0.200
     9.617    25.228     0.200
     9.684    24.951     0.200
     9.693    26.144     0.200
    10.839    27.769     0.200
     1.653     9.763     0.200
     1.760    10.722     0.200
     1.949     9.365     0.200
     2.035    11.380     0.200
     2.125    10.035     0.200
     2.510    12.424     0.200
     2.803    13.657     0.200
     2.856    12.137     0.200
     2.875    13.483     0.200
     2.977    13.905     0.200
     3.012    14.433     0.200
     3.122    15.340     0.200
     3.260    14.298     0.200
     3.350    14.828     0.200
     3.719    15.375     0.200
     3.786    17.923     0.200
     3.892    16.630     0.200
     3.910    16.292     0.200
     3.910    16.292     0.200
     4.275    15.318     0.200
     4.314    18.628     0.200
     4.380    14.885     0.200
     4.440    16.181     0.200
     4.807    16.207     0.200
     5.113    16.674     0.200
     5.874    19.652     0.200
     6.100    20.910     0.200
     6.157    19.449     0.200
     6.336    20.159     0.200
     6.383    19.719     0.200
     6.636    21.258     0.200
     7.000    19.610     0.200
     7.193    23.364     0.200
     7.987    21.891     0.200
     8.351    21.452     0.200
     8.727    22.359     0.200
     9.328    23.739     0.200
     9.479    26.175     0.200
     1.704     9.847     0.200
     1.639    10.144     0.200
     1.996    11.776     0.200
     2.304    13.081     0.200
     2.719    13.148     0.200
     2.747    13.151     0.200
     2.896    13.848     0.200
     2.927    13.768     0.200
     3.177    14.336     0.200
     3.200    14.412     0.200
     3.266    14.539     0.200
     3.639    15.948     0.200
     3.690    16.168     0.200
     3.808    16.164     0.200
     3.827    16.272     0.200
     3.827    16.272     0.200
     3.886    16.883     0.200
     4.093    17.059     0.200
     4.249    16.849     0.200
     4.336    17.430     0.200
     4.382    15.596     0.200
     4.520    16.490     0.200
     4.799    17.226     0.200
     5.545    17.921     0.200
     5.894    19.543     0.200
     5.946    19.741     0.200
     6.005    17.752     0.200
     6.118    21.234     0.200
     6.124    20.662     0.200
     6.151    20.044     0.200
     6.204    20.027     0.200
     6.243    21.569     0.200
     6.268    21.286     0.200
     6.411    20.314     0.200
     6.459    19.856     0.200
     6.561    19.563     0.200
     6.651    22.711     0.200
     6.666    22.438     0.200
     6.678    21.702     0.200
     6.651    19.520     0.200
     6.703    21.700     0.200
     6.970    21.793     0.200
     7.025    21.751     0.200
     7.062    20.323     0.200
     7.083    20.580     0.200
     7.114    21.805     0.200
     7.219    22.490     0.200
     7.266    21.833     0.200
     7.362    21.320     0.200
     7.478    20.870     0.200
     7.656    21.978     0.200
     8.043    22.065     0.200
     8.142    22.613     0.200
     8.277    22.738     0.200
     8.396    22.346     0.200
     8.495    23.296     0.200
     8.773    23.045     0.200
     9.226    25.468     0.200
     9.390    24.349     0.200
     9.684    26.119     0.200
     9.688    26.079     0.200
     9.751    25.734     0.200
     9.755    25.391     0.200
     9.967    25.715     0.200
    10.265    27.941     0.200
    10.411    26.933     0.200
    11.209    27.428     0.200
    12.957    31.521     0.200
     1.590     9.981     0.200
     1.632     9.418     0.200
     1.723     9.989     0.200
     1.755    10.076     0.200
     1.954     8.895     0.200
     2.024    10.778     0.200
     2.110    10.744     0.200
     2.521    11.405     0.200
     2.828    12.786     0.200
     2.881    13.081     0.200
     2.883    11.438     0.200
     3.005    13.907     0.200
     3.035    13.487     0.200
     3.130    14.246     0.200
     3.174    13.569     0.200
     3.175    14.023     0.200
     3.286    14.509     0.200
     3.305    14.165     0.200
     3.374    14.285     0.200
     3.747    15.689     0.200
     3.916    15.568     0.200
     3.936    15.848     0.200
     3.936    15.848     0.200
     4.251    15.793     0.200
     4.369    17.217     0.200
     4.405    17.003     0.200
     4.430    15.815     0.200
     4.938    14.838     0.200
     4.998    17.177     0.200
     5.636    18.233     0.200
     6.000    19.985     0.200
     6.035    21.182     0.200
     6.117    20.222     0.200
     6.183    19.546     0.200
     6.262    18.735     0.200
     6.329    18.250     0.200
     6.374    18.121     0.200
     6.632    22.407     0.200
     7.002    18.795     0.200
     7.023    18.851     0.200
     7.992    20.440     0.200
     8.360    20.744     0.200
     8.413    22.431     0.200
     8.736    21.452     0.200
     9.330    22.923     0.200
     9.630    23.728     0.200
     1.608     9.672     0.200
     1.648    10.461     0.200
     1.763    11.143     0.200
     1.946    10.348     0.200
     2.329    12.921     0.200
     2.514    12.549     0.200
     2.803    14.566     0.200
     2.812    13.553     0.200
     2.879    14.311     0.200
     2.860    12.863     0.200
     2.978    15.533     0.200
     3.011    14.443     0.200
     3.113    14.654     0.200
     3.176    14.943     0.200
     3.260    15.933     0.200
     3.284    15.076     0.200
     3.350    15.337     0.200
     3.719    17.461     0.200
     3.740    15.207     0.200
     3.892    16.752     0.200
     3.910    17.187     0.200
     3.910    17.187     0.200
     4.279    18.466     0.200
     4.385    15.828     0.200
     4.443    17.051     0.200
     4.811    17.253     0.200
     4.926    16.488     0.200
     5.014    17.050     0.200
     5.877    19.010     0.200
     6.020    22.542     0.200
     6.102    22.183     0.200
     6.105    21.154     0.200
     6.161    19.994     0.200
     6.339    19.719     0.200
     6.385    19.980     0.200
     6.640    21.010     0.200
     7.004    20.062     0.200
     7.025    20.716     0.200
     7.298    21.235     0.200
     7.484    22.460     0.200
     8.075    23.158     0.200
     8.355    23.398     0.200
     8.731    23.204     0.200
    20.903    41.986     0.200
     1.630     9.604     0.200
     1.610     8.879     0.200
     1.735    10.050     0.200
     1.771     9.749     0.200
     1.938     9.215     0.200
     2.120    10.097     0.200
     2.142    11.834     0.200
     2.312    11.780     0.200
     2.530    11.198     0.200
     2.802    11.703     0.200
     2.808    12.630     0.200
     2.879    12.105     0.200
     2.892    13.185     0.200
     2.985    13.714     0.200
     3.015    12.988     0.200
     3.140    14.227     0.200
     3.188    13.543     0.200
     3.266    14.108     0.200
     3.285    13.395     0.200
     3.354    13.950     0.200
     3.721    15.444     0.200
     3.728    15.301     0.200
     3.896    15.259     0.200
     3.916    15.312     0.200
     3.916    15.312     0.200
     4.404    16.633     0.200
     4.448    15.618     0.200
     4.944    14.590     0.200
     5.136    16.767     0.200
     5.797    18.674     0.200
     5.886    18.541     0.200
     6.181    19.599     0.200
     6.346    19.363     0.200
     6.392    19.237     0.200
     6.639    22.945     0.200
     6.650    19.623     0.200
     7.016    19.754     0.200
     7.036    19.611     0.200
     7.203    20.462     0.200
     7.503    22.667     0.200
     8.004    21.318     0.200
     8.370    20.746     0.200
     8.746    21.354     0.200
     9.344    23.683     0.200
     9.643    23.697     0.200
     1.608     9.575     0.200
     1.787    10.118     0.200
     1.835    10.415     0.200
     1.875     9.468     0.200
     1.974     9.984     0.200
     2.167    11.266     0.200
     2.572    11.863     0.200
     2.743    12.390     0.200
     2.881    11.690     0.200
     2.924    13.149     0.200
     2.948    12.953     0.200
     3.203    13.245     0.200
     3.217    13.479     0.200
     3.287    13.339     0.200
     3.668    14.752     0.200
     3.830    15.129     0.200
     3.851    14.750     0.200
     3.851    14.750     0.200
     4.416    14.723     0.200
     4.515    15.764     0.200
     6.710    19.451     0.200
     7.072    20.124     0.200
     8.057    21.427     0.200
     8.792    21.754     0.200
     1.573     9.217     0.200
     1.586     9.509     0.200
     1.617     9.648     0.200
     1.709     9.439     0.200
     1.640    10.014     0.200
     1.857    10.457     0.200
     1.970     9.814     0.200
     2.510    11.890     0.200
     2.867    13.148     0.200
     2.881    11.954     0.200
     2.843    12.446     0.200
     2.834    12.417     0.200
     3.019    13.894     0.200
     3.051    13.071     0.200
     3.159    13.380     0.200
     3.108    13.592     0.200
     3.301    14.313     0.200
     3.322    13.391     0.200
     3.389    14.102     0.200
     3.490    14.493     0.200
     3.761    15.566     0.200
     3.737    15.828     0.200
     3.784    15.832     0.200
     3.909    15.882     0.200
     3.932    15.471     0.200
     3.951    15.903     0.200
     3.951    15.903     0.200
     4.066    15.127     0.200
     4.022    16.619     0.200
     4.090    17.287     0.200
     4.098    14.065     0.200
     4.169    15.902     0.200
     4.231    17.758     0.200
     4.154    16.720     0.200
     4.282    15.200     0.200
     4.213    16.354     0.200
     4.306    15.468     0.200
     4.341    16.793     0.200
     4.267    16.214     0.200
     4.366    15.624     0.200
     4.368    15.226     0.200
     4.400    14.570     0.200
     4.400    17.269     0.200
     4.413    16.122     0.200
     4.471    17.623     0.200
     4.492    15.447     0.200
     4.536    16.528     0.200
     4.536    17.077     0.200
     4.630    17.978     0.200
     4.680    14.071     0.200
     4.831    16.544     0.200
     4.839    15.736     0.200
     5.009    16.244     0.200
     4.958    17.958     0.200
     5.076    18.669     0.200
     5.015    18.095     0.200
     5.128    15.856     0.200
     5.180    17.365     0.200
     5.318    18.240     0.200
     5.407    19.549     0.200
     5.468    20.336     0.200
     5.468    19.067     0.200
     5.498    18.755     0.200
     5.439    19.144     0.200
     5.559    18.545     0.200
     5.591    17.166     0.200
     5.665    18.667     0.200
     5.714    20.603     0.200
     5.714    19.540     0.200
     5.651    18.669     0.200
     5.763    18.477     0.200
     5.800    18.232     0.200
     5.814    19.967     0.200
     5.853    19.111     0.200
     5.904    20.422     0.200
     5.834    18.838     0.200
     5.935    20.461     0.200
     5.993    20.458     0.200
     6.031    20.035     0.200
     6.055    17.376     0.200
     6.063    19.963     0.200
     6.063    20.600     0.200
     6.110    19.619     0.200
     6.109    20.126     0.200
     6.016    20.906     0.200
     6.180    19.893     0.200
     6.195    20.027     0.200
     6.218    21.253     0.200
     6.253    20.545     0.200
     6.184    20.444     0.200
     6.304    20.416     0.200
     6.312    19.650     0.200
     6.337    17.696     0.200
     6.354    19.435     0.200
     6.309    20.096     0.200
     6.358    19.526     0.200
     6.306    20.532     0.200
     6.622    20.940     0.200
     6.619    20.672     0.200
     6.690    22.626     0.200
     6.713    23.376     0.200
     6.736    19.038     0.200
     6.655    19.949     0.200
     6.741    21.446     0.200
     6.678    20.683     0.200
     6.833    20.877     0.200
     6.915    22.815     0.200
     6.939    21.536     0.200
     6.944    22.276     0.200
     6.987    19.977     0.200
     7.008    19.732     0.200
     7.040    22.064     0.200
     7.008    22.338     0.200
     7.170    22.443     0.200
     7.205    25.283     0.200
     7.205    22.033     0.200
     7.243    23.484     0.200
     7.277    22.898     0.200
     7.411    22.727     0.200
     7.390    23.375     0.200
     7.412    22.625     0.200
     7.497    23.130     0.200
     7.501    20.685     0.200
     7.729    24.881     0.200
     7.786    23.058     0.200
     7.978    21.714     0.200
     7.938    22.983     0.200
     8.053    23.341     0.200
     8.009    24.157     0.200
     8.311    24.233     0.200
     8.317    23.982     0.200
     8.348    21.398     0.200
     8.396    23.933     0.200
     8.370    25.442     0.200
     8.482    26.131     0.200
     8.710    24.865     0.200
     8.724    22.112     0.200
     8.734    27.996     0.200
     8.789    25.048     0.200
     8.928    28.063     0.200
     8.955    25.108     0.200
     9.065    25.831     0.200
     9.221    26.711     0.200
     9.235    25.444     0.200
     9.315    24.105     0.200
     9.452    25.507     0.200
     9.487    25.908     0.200
     9.616    24.103     0.200
     9.621    25.342     0.200
     9.680    25.045     0.200
     9.710    27.302     0.200
     9.889    25.517     0.200
    10.762    28.223     0.200
    10.801    28.873     0.200
    10.949    28.846     0.200
    11.457    30.516     0.200
    12.379    33.150     0.200
    14.393    33.018     0.200
    18.490    40.012     0.200
    19.510    40.034     0.200
    19.510    39.605     0.200
    20.223    40.316     0.200
    20.467    40.968     0.200
     1.652    10.456     0.200
     1.722    10.820     0.200
     1.987     9.556     0.200
     2.051    11.493     0.200
     2.082    12.200     0.200
     2.495    12.433     0.200
     2.851    13.725     0.200
     2.856    13.380     0.200
     2.874    12.235     0.200
     3.030    14.359     0.200
     3.064    13.500     0.200
     3.143    15.194     0.200
     3.312    14.953     0.200
     3.336    13.678     0.200
     3.402    14.592     0.200
     3.739    15.970     0.200
     3.771    16.769     0.200
     3.945    16.315     0.200
     3.963    16.482     0.200
     3.963    16.482     0.200
     4.058    14.633     0.200
     4.164    15.787     0.200
     4.276    15.000     0.200
     4.362    15.310     0.200
     4.396    16.414     0.200
     4.391    16.179     0.200
     4.391    15.179     0.200
     4.823    16.534     0.200
     4.829    15.875     0.200
     4.916    16.702     0.200
     4.972    17.393     0.200
     5.488    18.569     0.200
     5.586    17.235     0.200
     5.836    18.909     0.200
     6.015    19.626     0.200
     6.097    21.468     0.200
     6.296    19.048     0.200
     6.341    19.220     0.200
     6.602    19.066     0.200
     6.608    23.000     0.200
     6.971    20.373     0.200
     7.492    20.787     0.200
     7.962    21.305     0.200
     8.333    20.478     0.200
     8.708    22.392     0.200
     9.684    24.410     0.200
     1.563     9.060     0.200
     1.576     9.000     0.200
     1.651     9.618     0.200
     1.727    10.309     0.200
     1.983     8.950     0.200
     2.049    10.961     0.200
     2.497    11.507     0.200
     2.851    12.800     0.200
     3.025    13.627     0.200
     3.059    12.931     0.200
     3.104    14.187     0.200
     3.120    13.221     0.200
     3.146    13.623     0.200
     3.122    14.164     0.200
     3.307    14.291     0.200
     3.331    13.087     0.200
     3.397    14.114     0.200
     3.766    15.777     0.200
     3.739    14.826     0.200
     3.746    14.432     0.200
     3.828    13.854     0.200
     3.939    15.386     0.200
     3.958    15.734     0.200
     3.958    15.734     0.200
     4.057    16.138     0.200
     4.275    14.594     0.200
     4.361    14.867     0.200
     4.391    15.150     0.200
     4.401    15.729     0.200
     4.485    16.460     0.200
     4.822    15.913     0.200
     4.917    15.815     0.200
     4.996    15.742     0.200
     5.844    18.589     0.200
     5.841    18.827     0.200
     6.172    20.166     0.200
     6.300    18.764     0.200
     6.346    19.036     0.200
     6.610    23.250     0.200
     6.606    18.891     0.200
     6.974    19.600     0.200
     6.995    19.154     0.200
     7.492    21.560     0.200
     8.335    21.117     0.200
     8.711    21.629     0.200
     9.303    23.527     0.200
     9.603    24.325     0.200
     9.686    23.048     0.200
     1.651    10.321     0.200
     1.766    10.981     0.200
     1.944     9.755     0.200
     2.032    11.836     0.200
     2.105    11.472     0.200
     2.797    13.473     0.200
     2.855    13.264     0.200
     2.972    14.146     0.200
     3.006    13.808     0.200
     3.254    14.723     0.200
     3.279    14.474     0.200
     3.344    14.823     0.200
     3.713    16.002     0.200
     3.886    15.937     0.200
     3.904    16.126     0.200
     3.904    16.126     0.200
     4.171    16.767     0.200
     4.381    17.821     0.200
     4.446    16.258     0.200
     5.563    18.531     0.200
     5.880    18.730     0.200
     5.924    20.213     0.200
     5.960    17.794     0.200
     6.100    19.859     0.200
     6.157    21.490     0.200
     6.342    19.638     0.200
     6.388    19.895     0.200
     6.621    22.782     0.200
     6.642    19.539     0.200
     6.929    21.484     0.200
     6.982    21.365     0.200
     7.005    20.297     0.200
     7.007    22.075     0.200
     7.026    20.454     0.200
     7.170    22.875     0.200
     7.992    21.582     0.200
     8.354    21.951     0.200
     8.731    22.656     0.200
     9.333    24.126     0.200
     9.631    24.755     0.200
     9.699    24.465     0.200
     1.460     9.559     0.200
     1.667     9.653     0.200
     1.698    11.032     0.200
     2.062    11.667     0.200
     2.877    13.499     0.200
     2.869    11.911     0.200
     3.050    14.506     0.200
     3.087    13.652     0.200
     3.333    14.917     0.200
     3.360    14.287     0.200
     3.424    14.646     0.200
     3.790    16.334     0.200
     3.826    14.457     0.200
     3.966    15.993     0.200
     3.984    16.370     0.200
     4.050    15.231     0.200
     4.252    16.954     0.200
     4.301    16.781     0.200
     4.371    16.456     0.200
     4.381    15.737     0.200
     4.381    17.643     0.200
     4.816    16.265     0.200
     5.006    16.850     0.200
     5.478    18.743     0.200
     5.582    17.032     0.200
     5.812    19.449     0.200
     6.000    21.843     0.200
     6.082    20.799     0.200
     6.165    19.627     0.200
     6.271    20.092     0.200
     6.316    19.659     0.200
     6.578    21.096     0.200
     6.591    22.860     0.200
     6.947    20.995     0.200
     6.968    20.648     0.200
     7.190    20.265     0.200
     7.236    23.026     0.200
     7.483    20.738     0.200
     7.940    21.814     0.200
     8.012    22.973     0.200
     8.312    22.065     0.200
     8.688    22.680     0.200
     9.577    25.107     0.200
     1.441     8.475     0.200
     1.998     9.208     0.200
     2.053    11.036     0.200
     2.885    11.199     0.200
     2.875    12.294     0.200
     3.049    13.278     0.200
     3.082    12.650     0.200
     3.332    13.511     0.200
     3.353    12.987     0.200
     3.421    13.592     0.200
     3.791    15.175     0.200
     3.963    14.743     0.200
     3.982    14.988     0.200
     4.399    14.714     0.200
     4.567    16.552     0.200
     4.833    15.148     0.200
     5.018    16.195     0.200
     5.865    18.406     0.200
     6.182    18.708     0.200
     6.337    19.399     0.200
     7.501    20.417     0.200
    12.724    31.361     0.200
     1.428     8.700     0.200
     1.609     9.112     0.200
     1.640     9.757     0.200
     1.757     9.468     0.200
     1.641     9.315     0.200
     1.952     8.949     0.200
     2.029    10.895     0.200
     2.516    11.658     0.200
     2.872    11.895     0.200
     2.818    13.101     0.200
     2.994    13.696     0.200
     3.026    13.567     0.200
     3.172    13.863     0.200
     3.276    14.503     0.200
     3.298    14.252     0.200
     3.365    14.103     0.200
     3.736    16.016     0.200
     3.731    14.711     0.200
     3.741    14.440     0.200
     3.783    14.242     0.200
     3.907    16.125     0.200
     3.926    15.929     0.200
     4.189    16.005     0.200
     4.293    15.689     0.200
     4.250    15.791     0.200
     4.395    15.306     0.200
     4.433    16.355     0.200
     4.310    16.995     0.200
     4.514    15.511     0.200
     4.823    16.108     0.200
     4.698    17.025     0.200
     5.016    15.856     0.200
     4.982    16.856     0.200
     4.934    17.713     0.200
     5.005    17.478     0.200
     4.996    17.584     0.200
     5.285    16.419     0.200
     5.293    18.046     0.200
     5.349    17.941     0.200
     5.494    20.277     0.200
     5.418    18.162     0.200
     5.581    16.865     0.200
     5.768    18.518     0.200
     5.637    18.101     0.200
     5.863    18.268     0.200
     5.871    19.275     0.200
     5.929    18.902     0.200
     5.810    18.285     0.200
     5.961    16.730     0.200
     6.109    19.993     0.200
     6.111    19.676     0.200
     5.999    20.383     0.200
     6.005    18.412     0.200
     6.169    18.799     0.200
     6.173    19.251     0.200
     6.075    19.071     0.200
     6.214    20.166     0.200
     6.183    20.629     0.200
     6.254    19.700     0.200
     6.237    18.704     0.200
     6.160    19.498     0.200
     6.331    19.002     0.200
     6.377    19.367     0.200
     6.281    19.890     0.200
     6.306    20.660     0.200
     6.520    18.506     0.200
     6.613    16.620     0.200
     6.626    21.857     0.200
     6.636    20.951     0.200
     6.635    21.162     0.200
     6.643    20.167     0.200
     6.699    19.709     0.200
     6.654    20.234     0.200
     6.902    20.635     0.200
     6.768    19.912     0.200
     6.931    20.403     0.200
     6.813    21.380     0.200
     6.983    19.394     0.200
     7.001    19.792     0.200
     7.006    20.523     0.200
     7.022    20.047     0.200
     6.983    21.898     0.200
     7.169    20.528     0.200
     7.188    20.710     0.200
     7.189    20.501     0.200
     7.204    21.816     0.200
     7.216    21.183     0.200
     7.201    20.256     0.200
     7.091    21.635     0.200
     7.293    22.987     0.200
     7.495    20.826     0.200
     7.613    19.849     0.200
     7.990    21.649     0.200
     8.004    23.987     0.200
     8.303    23.899     0.200
     8.356    21.272     0.200
     8.468    25.870     0.200
     8.706    24.292     0.200
     8.732    22.085     0.200
     8.722    26.999     0.200
     9.210    27.313     0.200
     9.232    25.553     0.200
     9.329    23.018     0.200
     9.628    24.327     0.200
     9.694    24.359     0.200
     9.708    24.696     0.200
     9.704    25.145     0.200
     9.903    25.419     0.200
    18.482    41.441     0.200
    20.207    40.178     0.200
     1.453     8.464     0.200
     2.860    11.667     0.200
     4.219    16.186     0.200
     4.287    17.400     0.200
     4.378    16.033     0.200
     4.401    16.468     0.200
     4.809    16.001     0.200
     6.087    19.586     0.200
     6.159    19.053     0.200
     6.298    18.623     0.200
     6.344    18.989     0.200
     6.602    19.076     0.200
     6.969    18.899     0.200
     6.990    19.055     0.200
     7.155    19.822     0.200
     7.959    21.649     0.200
     8.327    20.450     0.200
     8.703    21.761     0.200
     9.297    23.427     0.200
     9.597    24.733     0.200
     1.444     8.692     0.200
     2.868    11.413     0.200
     2.845    12.614     0.200
     3.019    12.436     0.200
     3.302    12.877     0.200
     3.326    13.133     0.200
     3.392    13.166     0.200
     3.521    12.320     0.200
     3.760    14.897     0.200
     3.823    14.594     0.200
     3.934    14.569     0.200
     3.952    14.649     0.200
     4.218    16.184     0.200
     4.294    16.992     0.200
     4.386    14.618     0.200
     4.404    16.311     0.200
     4.818    15.587     0.200
     4.878    15.787     0.200
     5.296    17.304     0.200
     5.484    17.504     0.200
     5.579    16.100     0.200
     5.843    16.824     0.200
     6.013    19.439     0.200
     6.096    19.373     0.200
     6.095    19.180     0.200
     6.167    18.938     0.200
     6.239    20.101     0.200
     6.189    19.580     0.200
     6.348    19.224     0.200
     6.309    20.186     0.200
     6.608    20.494     0.200
     6.608    20.892     0.200
     6.975    19.411     0.200
     6.996    19.166     0.200
     7.011    21.989     0.200
     7.160    19.851     0.200
     7.265    22.820     0.200
     7.487    20.830     0.200
     7.965    21.154     0.200
     8.334    20.846     0.200
     8.387    23.036     0.200
     8.710    21.758     0.200
     9.201    26.931     0.200
     9.303    23.139     0.200
     9.603    24.041     0.200
     9.668    24.078     0.200
     9.877    25.044     0.200
     1.657     9.790     0.200
     1.717    10.323     0.200
     1.992     9.475     0.200
     2.077    11.615     0.200
     2.490    11.797     0.200
     2.846    13.651     0.200
     2.859    12.821     0.200
     2.871    12.186     0.200
     3.032    13.626     0.200
     3.067    12.746     0.200
     3.096    15.226     0.200
     3.176    15.024     0.200
     3.315    13.955     0.200
     3.340    12.969     0.200
     3.406    14.121     0.200
     3.456    16.458     0.200
     3.743    16.177     0.200
     3.773    15.800     0.200
     3.948    15.243     0.200
     3.965    15.666     0.200
     4.161    14.921     0.200
     4.284    18.312     0.200
     4.299    17.778     0.200
     4.392    16.004     0.200
     4.355    17.129     0.200
     4.387    14.956     0.200
     4.820    16.208     0.200
     4.825    16.086     0.200
     5.000    16.909     0.200
     5.048    17.745     0.200
     5.112    15.691     0.200
     5.485    18.349     0.200
     5.583    17.202     0.200
     5.831    18.400     0.200
     5.837    18.632     0.200
     5.905    18.941     0.200
     5.930    17.145     0.200
     6.010    20.714     0.200
     6.092    20.954     0.200
     6.169    19.464     0.200
     6.190    19.219     0.200
     6.236    22.183     0.200
     6.336    19.311     0.200
     6.491    19.105     0.200
     6.597    20.262     0.200
     6.603    23.192     0.200
     6.903    20.897     0.200
     6.954    20.497     0.200
     6.965    19.968     0.200
     6.986    19.422     0.200
     7.148    22.932     0.200
     7.255    20.689     0.200
     7.488    20.364     0.200
     7.957    21.298     0.200
     8.328    21.071     0.200
     8.703    21.884     0.200
     1.700    10.887     0.200
     2.009     9.956     0.200
     2.053    11.668     0.200
     2.072    13.006     0.200
     2.465    12.028     0.200
     2.874    13.714     0.200
     3.072    15.341     0.200
     3.118    15.408     0.200
     4.379    16.074     0.200
     6.276    17.142     0.200
     6.322    19.506     0.200
     7.236    22.336     0.200
     7.461    23.003     0.200
     7.934    20.688     0.200
     8.013    22.665     0.200
     8.303    21.584     0.200
     8.541    22.004     0.200
     8.679    22.095     0.200
     1.645     9.521     0.200
     1.765    10.430     0.200
     1.945     9.025     0.200
     2.108    11.121     0.200
     2.291    11.386     0.200
     2.326    12.475     0.200
     2.517    11.747     0.200
     2.810    12.323     0.200
     2.863    11.188     0.200
     2.881    13.697     0.200
     3.132    13.670     0.200
     3.736    15.014     0.200
     3.747    14.191     0.200
     3.761    15.333     0.200
     4.388    15.411     0.200
     4.444    15.759     0.200
     4.814    16.035     0.200
     4.920    17.900     0.200
     4.968    16.243     0.200
     5.487    18.282     0.200
     5.571    16.912     0.200
     5.798    17.860     0.200
     6.108    20.641     0.200
     6.165    19.081     0.200
     6.251    20.767     0.200
     6.340    18.829     0.200
     6.386    19.291     0.200
     6.642    18.915     0.200
     7.197    22.629     0.200
     7.299    20.636     0.200
     7.487    20.547     0.200
     8.357    21.289     0.200
     8.593    22.041     0.200
     8.734    21.295     0.200
     1.600     9.375     0.200
     1.646     9.542     0.200
     1.747     9.153     0.200
     1.962     9.351     0.200
     2.509    11.562     0.200
     2.870    11.767     0.200
     2.826    11.962     0.200
     3.164    13.718     0.200
     3.113    13.222     0.200
     3.125    13.780     0.200
     3.501    13.483     0.200
     3.497    13.230     0.200
     3.735    14.456     0.200
     3.744    14.749     0.200
     3.793    14.085     0.200
     4.093    16.487     0.200
     4.270    14.984     0.200
     4.293    17.247     0.200
     4.259    15.736     0.200
     4.355    15.270     0.200
     4.392    14.996     0.200
     4.424    15.918     0.200
     4.523    16.458     0.200
     4.725    16.999     0.200
     4.697    14.586     0.200
     4.707    16.690     0.200
     4.821    16.089     0.200
     4.832    16.411     0.200
     4.870    16.214     0.200
     4.926    15.514     0.200
     4.993    18.134     0.200
     5.009    15.783     0.200
     4.984    16.979     0.200
     4.943    17.162     0.200
     5.006    18.228     0.200
     5.121    16.460     0.200
     5.288    16.335     0.200
     5.358    18.054     0.200
     5.490    17.774     0.200
     5.428    19.005     0.200
     5.580    16.831     0.200
     5.646    18.654     0.200
     5.761    18.643     0.200
     5.744    18.227     0.200
     5.872    18.413     0.200
     5.820    18.627     0.200
     6.022    19.869     0.200
     6.057    16.956     0.200
     6.008    20.729     0.200
     6.015    19.433     0.200
     6.104    19.909     0.200
     6.170    19.336     0.200
     6.249    20.521     0.200
     6.239    19.035     0.200
     6.322    19.166     0.200
     6.368    19.334     0.200
     6.315    20.645     0.200
     6.620    22.189     0.200
     6.626    19.719     0.200
     6.643    20.320     0.200
     6.992    20.246     0.200
     7.013    19.801     0.200
     7.179    19.864     0.200
     7.100    22.488     0.200
     7.198    20.645     0.200
     7.198    20.358     0.200
     7.189    21.478     0.200
     7.189    20.948     0.200
     7.284    19.644     0.200
     7.492    20.716     0.200
     7.982    21.700     0.200
     8.012    24.339     0.200
     8.119    23.982     0.200
     8.304    21.746     0.200
     8.349    21.116     0.200
     8.406    23.749     0.200
     8.380    25.153     0.200
     8.586    22.049     0.200
     8.725    22.125     0.200
     8.911    27.113     0.200
     9.228    25.556     0.200
     9.321    24.074     0.200
     9.660    26.885     0.200
     9.701    24.438     0.200
     9.895    25.576     0.200
    10.592    28.841     0.200
    14.400    33.993     0.200
    15.007    34.331     0.200
     1.623     8.690     0.200
     1.742     9.304     0.200
     1.646     9.723     0.200
     1.968     9.566     0.200
     2.873    11.982     0.200
     2.835    12.467     0.200
     2.832    12.180     0.200
     3.010    12.814     0.200
     3.043    12.809     0.200
     3.200    14.083     0.200
     3.122    13.590     0.200
     3.113    13.297     0.200
     3.292    13.534     0.200
     3.314    13.171     0.200
     3.381    13.912     0.200
     3.497    14.094     0.200
     3.764    15.374     0.200
     3.660    14.219     0.200
     3.746    15.379     0.200
     3.751    14.750     0.200
     3.735    14.795     0.200
     3.743    14.625     0.200
     3.827    14.184     0.200
     3.909    15.452     0.200
     3.800    16.184     0.200
     3.813    13.330     0.200
     3.944    14.556     0.200
     3.923    15.966     0.200
     3.942    14.950     0.200
     4.058    14.707     0.200
     4.089    17.087     0.200
     4.012    16.336     0.200
     4.216    16.411     0.200
     4.230    17.374     0.200
     4.281    17.388     0.200
     4.297    15.289     0.200
     4.358    15.768     0.200
     4.265    15.555     0.200
     4.393    14.365     0.200
     4.417    15.880     0.200
     4.470    16.537     0.200
     4.530    16.958     0.200
     4.690    14.138     0.200
     4.627    17.568     0.200
     4.713    16.929     0.200
     4.823    16.048     0.200
     4.832    15.924     0.200
     4.924    15.310     0.200
     4.875    16.533     0.200
     4.860    16.274     0.200
     4.989    18.395     0.200
     5.006    15.985     0.200
     4.990    16.400     0.200
     4.950    17.659     0.200
     5.077    17.851     0.200
     5.122    15.849     0.200
     5.012    17.842     0.200
     5.022    17.442     0.200
     5.170    16.576     0.200
     5.223    19.270     0.200
     5.294    17.051     0.200
     5.408    17.699     0.200
     5.470    19.715     0.200
     5.491    18.046     0.200
     5.523    17.588     0.200
     5.434    18.910     0.200
     5.583    17.078     0.200
     5.668    17.136     0.200
     5.717    18.905     0.200
     5.716    18.793     0.200
     5.759    18.439     0.200
     5.651    18.385     0.200
     5.795    17.805     0.200
     5.854    18.015     0.200
     5.752    18.047     0.200
     5.906    19.706     0.200
     5.921    18.736     0.200
     5.827    18.824     0.200
     5.950    16.796     0.200
     6.021    19.359     0.200
     6.054    17.160     0.200
     6.105    19.086     0.200
     6.104    19.399     0.200
     6.014    21.146     0.200
     6.021    19.059     0.200
     6.159    19.252     0.200
     6.172    19.297     0.200
     6.092    18.837     0.200
     6.206    20.308     0.200
     6.248    19.415     0.200
     6.177    20.240     0.200
     6.244    19.261     0.200
     6.306    18.946     0.200
     6.316    18.723     0.200
     6.337    17.099     0.200
     6.355    18.741     0.200
     6.361    19.192     0.200
     6.297    20.639     0.200
     6.321    20.482     0.200
     6.499    17.924     0.200
     6.569    17.731     0.200
     6.486    19.635     0.200
     6.621    20.962     0.200
     6.618    20.894     0.200
     6.627    20.295     0.200
     6.633    20.523     0.200
     6.607    20.528     0.200
     6.691    17.782     0.200
     6.617    19.904     0.200
     6.736    16.014     0.200
     6.704    19.797     0.200
     6.704    23.398     0.200
     6.745    20.417     0.200
     6.775    21.769     0.200
     6.671    20.976     0.200
     6.893    20.994     0.200
     6.783    20.126     0.200
     6.906    22.740     0.200
     6.943    20.903     0.200
     6.829    21.133     0.200
     6.947    23.256     0.200
     6.973    20.757     0.200
     6.988    20.385     0.200
     7.009    20.640     0.200
     7.043    21.436     0.200
     7.065    20.885     0.200
     6.945    20.284     0.200
     7.000    22.443     0.200
     7.113    21.114     0.200
     7.157    20.409     0.200
     7.173    22.118     0.200
     7.057    20.894     0.200
     7.177    20.876     0.200
     7.203    21.567     0.200
     7.207    22.520     0.200
     7.199    20.224     0.200
     7.104    21.920     0.200
     7.195    21.366     0.200
     7.278    22.491     0.200
     7.334    20.936     0.200
     7.334    21.037     0.200
     7.352    20.773     0.200
     7.493    20.780     0.200
     7.548    21.239     0.200
     7.597    20.975     0.200
     7.602    20.110     0.200
     7.720    22.246     0.200
     7.782    21.608     0.200
     7.833    21.718     0.200
     7.859    21.014     0.200
     7.783    22.496     0.200
     7.960    21.541     0.200
     7.978    21.629     0.200
     8.040    21.501     0.200
     8.055    24.025     0.200
     8.076    21.685     0.200
     7.975    21.703     0.200
     8.001    22.456     0.200
     8.017    24.769     0.200
     8.237    21.102     0.200
     8.303    22.039     0.200
     8.346    21.234     0.200
     8.400    24.104     0.200
     8.390    24.617     0.200
     8.390    24.617     0.200
     8.490    21.855     0.200
     8.384    25.486     0.200
     8.472    24.557     0.200
     8.550    22.045     0.200
     8.583    22.160     0.200
     8.703    24.157     0.200
     8.722    22.044     0.200
     8.725    26.613     0.200
     8.919    27.268     0.200
     9.050    22.713     0.200
     9.133    28.942     0.200
     9.157    23.370     0.200
     9.206    25.389     0.200
     9.212    25.225     0.200
     9.229    24.529     0.200
     9.260    26.307     0.200
     9.316    24.009     0.200
     9.319    26.465     0.200
     9.457    27.267     0.200
     9.615    24.416     0.200
     9.681    24.749     0.200
     9.697    25.358     0.200
     9.718    24.917     0.200
     9.703    25.600     0.200
     9.848    27.404     0.200
     9.890    26.114     0.200
    10.038    26.687     0.200
    10.184    26.878     0.200
    10.322    28.974     0.200
    10.627    30.321     0.200
    10.765    29.000     0.200
    10.806    29.829     0.200
    10.916    27.139     0.200
    11.163    27.457     0.200
    11.462    31.869     0.200
    11.634    30.514     0.200
    11.890    31.353     0.200
    11.954    32.219     0.200
    12.598    30.308     0.200
    12.888    31.229     0.200
    12.888    34.596     0.200
    12.945    32.263     0.200
    13.599    35.914     0.200
    13.931    34.252     0.200
    14.400    33.949     0.200
    14.400    32.718     0.200
    14.414    38.111     0.200
    18.397    40.034     0.200
    18.482    39.840     0.200
    19.503    39.631     0.200
    19.503    39.608     0.200
    20.221    40.898     0.200
    20.456    42.003     0.200
     1.495     7.501     0.200
     1.673     8.632     0.200
     1.847    10.096     0.200
     2.212    11.539     0.200
     2.374    10.142     0.200
     2.469    10.640     0.200
     2.465    10.737     0.200
     2.615    10.636     0.200
     2.674    12.081     0.200
     2.688    10.760     0.200
     2.753    12.046     0.200
     2.780    12.625     0.200
     2.810    10.074     0.200
     2.831    11.215     0.200
     3.152    13.511     0.200
     3.271    13.075     0.200
     3.296    12.992     0.200
     3.319    13.543     0.200
     3.493    13.990     0.200
     3.550    14.218     0.200
     3.704    13.173     0.200
     3.705    14.314     0.200
     3.783    13.398     0.200
     4.102    13.878     0.200
     4.144    14.085     0.200
     4.199    13.812     0.200
     4.309    15.661     0.200
     4.407    13.623     0.200
     4.494    16.310     0.200
     4.499    15.751     0.200
     4.764    14.751     0.200
     4.882    13.873     0.200
     4.997    16.838     0.200
     5.214    17.199     0.200
     5.249    16.097     0.200
     5.406    17.567     0.200
     5.440    15.961     0.200
     5.520    15.937     0.200
     5.520    18.628     0.200
     5.833    18.183     0.200
     6.013    18.075     0.200
     6.118    17.648     0.200
     6.160    17.562     0.200
     6.378    18.118     0.200
     6.852    19.190     0.200
     6.861    19.277     0.200
     7.106    18.428     0.200
     7.431    19.335     0.200
     7.464    20.541     0.200
     7.451    19.397     0.200
     7.601    22.245     0.200
     7.767    21.113     0.200
     8.377    20.695     0.200
     8.666    21.717     0.200
     8.863    22.313     0.200
     9.048    22.665     0.200
    10.028    24.628     0.200
     1.638     9.215     0.200
     1.930     8.810     0.200
     2.018    10.788     0.200
     2.397    10.766     0.200
     2.527    11.740     0.200
     2.865    11.476     0.200
     2.790    12.055     0.200
     2.796    12.106     0.200
     2.966    12.715     0.200
     3.049    13.945     0.200
     3.192    13.188     0.200
     3.103    13.126     0.200
     3.130    12.808     0.200
     3.248    13.672     0.200
     3.269    13.731     0.200
     3.335    13.870     0.200
     3.336    13.702     0.200
     3.464    14.907     0.200
     3.495    13.215     0.200
     3.709    14.395     0.200
     3.796    16.020     0.200
     3.816    14.674     0.200
     3.756    14.902     0.200
     3.769    16.752     0.200
     3.731    14.468     0.200
     3.743    14.327     0.200
     3.939    16.039     0.200
     3.878    15.502     0.200
     3.897    16.701     0.200
     3.919    15.702     0.200
     4.054    14.893     0.200
     3.989    17.468     0.200
     4.117    16.594     0.200
     4.118    15.912     0.200
     4.149    15.241     0.200
     4.353    15.682     0.200
     4.392    14.777     0.200
     4.229    15.888     0.200
     4.287    15.604     0.200
     4.442    16.371     0.200
     4.487    17.371     0.200
     4.653    15.312     0.200
     4.728    16.354     0.200
     4.817    15.618     0.200
     4.676    16.852     0.200
     4.847    15.865     0.200
     4.938    15.510     0.200
     4.963    16.315     0.200
     4.906    17.986     0.200
     5.127    15.735     0.200
     4.979    17.628     0.200
     4.973    17.695     0.200
     5.265    16.489     0.200
     5.492    17.838     0.200
     5.330    17.738     0.200
     5.393    18.802     0.200
     5.572    17.614     0.200
     5.620    18.155     0.200
     5.708    18.762     0.200
     5.853    19.928     0.200
     5.893    19.059     0.200
     6.113    19.595     0.200
     6.116    19.559     0.200
     5.980    19.280     0.200
     5.977    20.483     0.200
     6.168    18.856     0.200
     6.048    20.075     0.200
     6.224    19.779     0.200
     6.220    18.546     0.200
     6.259    20.288     0.200
     6.132    20.169     0.200
     6.306    18.840     0.200
     6.355    18.670     0.200
     6.252    19.968     0.200
     6.401    18.730     0.200
     6.283    20.971     0.200
     6.443    20.148     0.200
     6.635    21.209     0.200
     6.656    20.365     0.200
     6.686    20.105     0.200
     6.573    19.824     0.200
     6.607    20.127     0.200
     6.627    21.402     0.200
     6.784    21.063     0.200
     6.888    22.952     0.200
     6.743    21.039     0.200
     6.789    21.505     0.200
     7.019    19.819     0.200
     7.040    20.475     0.200
     7.050    20.761     0.200
     6.955    22.374     0.200
     7.014    20.759     0.200
     7.197    20.548     0.200
     7.197    20.261     0.200
     7.167    20.292     0.200
     7.212    22.774     0.200
     7.074    22.186     0.200
     7.313    22.585     0.200
     7.316    21.252     0.200
     7.491    20.316     0.200
     7.360    23.347     0.200
     7.580    20.479     0.200
     7.706    23.219     0.200
     7.879    22.288     0.200
     7.875    22.331     0.200
     8.006    22.703     0.200
     8.065    21.720     0.200
     8.093    22.184     0.200
     8.091    22.808     0.200
     7.985    24.545     0.200
     8.259    21.850     0.200
     8.296    24.016     0.200
     8.291    27.013     0.200
     8.369    21.072     0.200
     8.316    24.681     0.200
     8.439    24.054     0.200
     8.511    22.216     0.200
     8.354    24.749     0.200
     8.570    23.418     0.200
     8.603    21.832     0.200
     8.564    25.291     0.200
     8.704    24.158     0.200
     8.745    21.777     0.200
     8.876    26.838     0.200
     8.876    27.248     0.200
     9.074    23.247     0.200
     9.202    25.150     0.200
     9.200    29.770     0.200
     9.231    24.306     0.200
     9.498    26.592     0.200
     9.645    26.175     0.200
     9.713    26.187     0.200
     9.722    24.182     0.200
     9.886    27.171     0.200
     9.923    24.738     0.200
    10.117    28.098     0.200
    10.367    25.650     0.200
    14.445    35.228     0.200
    18.476    39.613     0.200
    19.499    40.177     0.200
    19.499    40.492     0.200
    20.186    41.551     0.200
     1.177     7.835     0.200
     1.240     8.306     0.200
     1.412     9.797     0.200
     1.437     9.111     0.200
     1.469    10.027     0.200
     1.463     7.703     0.200
     1.649     7.826     0.200
     1.816     7.874     0.200
     1.949     8.572     0.200
     1.893     9.084     0.200
     2.293    10.215     0.200
     2.509    10.889     0.200
     2.560    10.424     0.200
     3.794    13.275     0.200
     3.923    14.800     0.200
     3.974    13.498     0.200
     4.138    14.284     0.200
     4.519    14.744     0.200
     5.640    17.051     0.200
     5.863    18.558     0.200
     5.873    18.028     0.200
     5.945    18.789     0.200
     5.969    18.917     0.200
     6.112    19.345     0.200
     6.539    20.464     0.200
     6.569    17.214     0.200
     6.795    16.977     0.200
     7.113    17.965     0.200
     7.212    20.607     0.200
     7.412    18.483     0.200
     7.456    18.655     0.200
     8.056    20.364     0.200
     8.346    21.380     0.200
     8.546    22.337     0.200
     8.727    21.727     0.200
     9.437    22.149     0.200
     9.707    23.889     0.200
     9.803    23.776     0.200
     9.825    23.512     0.200
    10.029    23.734     0.200
    10.343    24.964     0.200
     1.623     9.980     0.200
     1.917     9.450     0.200
     2.786    13.332     0.200
     2.878    14.097     0.200
     2.964    14.184     0.200
     3.043    14.134     0.200
     3.245    15.053     0.200
     3.262    14.657     0.200
     3.333    14.788     0.200
     3.331    14.846     0.200
     3.707    16.317     0.200
     3.828    14.617     0.200
     3.874    16.175     0.200
     3.894    16.280     0.200
     4.119    14.864     0.200
     4.367    15.813     0.200
     4.470    16.449     0.200
     4.454    16.538     0.200
     4.735    15.893     0.200
     4.831    17.040     0.200
     4.898    20.257     0.200
     4.971    17.205     0.200
     5.507    19.548     0.200
     6.046    19.556     0.200
     6.129    20.595     0.200
     6.182    19.878     0.200
     6.240    20.650     0.200
     6.275    21.289     0.200
     6.414    19.171     0.200
     6.651    21.805     0.200
     6.670    20.183     0.200
     7.034    21.329     0.200
     7.055    21.084     0.200
     7.225    20.407     0.200
     7.211    20.901     0.200
     7.328    21.506     0.200
     7.358    22.752     0.200
     8.022    23.006     0.200
     8.105    23.029     0.200
     8.385    23.468     0.200
     8.452    22.987     0.200
     8.619    22.630     0.200
     8.761    23.977     0.200
     8.875    26.861     0.200
     9.510    24.837     0.200
    14.354    37.050     0.200
     1.520     8.835     0.200
     1.594     9.177     0.200
     1.540     8.303     0.200
     1.655     9.941     0.200
     1.988    10.672     0.200
     2.811    11.725     0.200
     4.074    14.736     0.200
     4.239    15.690     0.200
     4.304    15.149     0.200
     4.423    14.564     0.200
     4.789    16.007     0.200
     4.948    16.058     0.200
     5.266    17.557     0.200
     5.644    18.666     0.200
     6.060    18.426     0.200
     6.105    18.729     0.200
     6.180    19.052     0.200
     6.557    19.858     0.200
     6.625    19.620     0.200
     6.934    21.251     0.200
     7.047    21.432     0.200
     7.108    20.527     0.200
     7.271    19.219     0.200
     7.582    19.191     0.200
     7.602    18.855     0.200
     7.593    20.463     0.200
     7.933    20.996     0.200
     8.513    20.830     0.200
     8.775    21.664     0.200
     8.959    22.621     0.200
     9.158    21.595     0.200
     9.903    23.302     0.200
    10.167    23.424     0.200
    10.148    24.854     0.200
    10.289    24.205     0.200
    10.499    24.946     0.200
    10.817    25.640     0.200
    13.520    31.495     0.200
     1.666     9.706     0.200
     1.635    10.664     0.200
     1.613    10.431     0.200
     1.709     9.906     0.200
     1.755    10.965     0.200
     2.046    11.071     0.200
     2.136    10.727     0.200
     2.091    12.050     0.200
     2.273    12.126     0.200
     2.398    13.148     0.200
     2.499    12.590     0.200
     2.922    13.316     0.200
     3.792    14.807     0.200
     4.091    16.093     0.200
     4.081    15.247     0.200
     4.211    15.510     0.200
     4.366    14.899     0.200
     4.626    15.321     0.200
     4.730    14.226     0.200
     4.792    16.324     0.200
     4.909    16.359     0.200
     4.917    16.679     0.200
     5.549    17.597     0.200
     6.002    18.601     0.200
     6.085    18.541     0.200
     6.088    18.807     0.200
     6.143    19.066     0.200
     6.231    19.536     0.200
     6.332    17.052     0.200
     6.379    17.104     0.200
     6.606    19.860     0.200
     6.630    17.376     0.200
     6.993    18.546     0.200
     7.014    18.702     0.200
     7.171    20.864     0.200
     7.465    21.232     0.200
     7.553    21.405     0.200
     7.979    20.539     0.200
     8.340    22.019     0.200
     8.575    22.883     0.200
     8.717    22.726     0.200
     9.321    22.675     0.200
     9.686    23.312     0.200
     9.722    23.393     0.200
     9.896    23.358     0.200
     1.486     8.987     0.200
     1.590     9.569     0.200
     1.642    10.462     0.200
     1.746    10.559     0.200
     1.763    10.653     0.200
     1.809    10.418     0.200
     1.810    10.607     0.200
     2.485    12.020     0.200
     2.508    12.237     0.200
     2.830    13.696     0.200
     3.045    13.169     0.200
     3.332    13.844     0.200
     3.360    13.716     0.200
     3.584    14.156     0.200
     3.550    15.337     0.200
     3.573    14.799     0.200
     3.702    15.520     0.200
     3.823    15.224     0.200
     3.846    15.528     0.200
     3.960    15.417     0.200
     4.247    16.761     0.200
     4.393    15.459     0.200
     4.327    17.186     0.200
     4.391    17.637     0.200
     4.447    17.669     0.200
     4.614    18.479     0.200
     4.636    16.991     0.200
     4.771    18.446     0.200
     5.054    18.749     0.200
     5.060    17.571     0.200
     5.084    17.313     0.200
     5.115    17.400     0.200
     5.259    19.113     0.200
     5.283    20.117     0.200
     5.311    19.247     0.200
     5.441    18.574     0.200
     5.519    18.815     0.200
     5.729    18.167     0.200
     5.959    18.782     0.200
     5.988    20.070     0.200
     6.028    18.181     0.200
     6.144    19.920     0.200
     6.305    18.854     0.200
     6.361    18.790     0.200
     6.378    19.096     0.200
     6.356    20.626     0.200
     6.439    20.674     0.200
     6.601    20.792     0.200
     6.679    21.552     0.200
     6.792    19.766     0.200
     6.862    21.443     0.200
     7.018    24.618     0.200
     7.227    20.391     0.200
     7.235    21.089     0.200
     7.249    20.636     0.200
     7.246    22.427     0.200
     7.437    20.637     0.200
     7.437    25.731     0.200
     7.443    21.659     0.200
     7.876    21.605     0.200
     7.876    22.105     0.200
     7.932    21.266     0.200
     8.115    24.021     0.200
     8.175    21.618     0.200
     8.168    23.107     0.200
     8.276    21.854     0.200
     8.742    21.702     0.200
     9.023    23.721     0.200
     9.046    24.859     0.200
    10.373    28.171     0.200
    10.394    29.927     0.200
    12.475    30.780     0.200
    14.657    36.474     0.200
    16.016    37.847     0.200
    18.484    42.123     0.200
    18.613    43.720     0.200
    20.179    40.136     0.200
     1.614     9.120     0.200
     1.667    10.604     0.200
     1.849     8.790     0.200
     1.940     9.730     0.200
     2.439    11.807     0.200
     2.558    12.813     0.200
     2.711    11.818     0.200
     4.732    14.740     0.200
     5.017    15.192     0.200
     5.114    17.183     0.200
     5.844    17.009     0.200
     7.013    19.720     0.200
     7.651    20.879     0.200
     7.792    20.334     0.200
     8.618    22.291     0.200
     8.938    23.158     0.200
     9.147    23.014     0.200
     9.318    24.326     0.200
     1.155     6.686     0.200
     1.281     7.211     0.200
     1.292     8.389     0.200
     1.301     7.282     0.200
     1.309     7.585     0.200
     1.405     7.862     0.200
     1.388     7.460     0.200
     1.428     7.198     0.200
     1.523     7.490     0.200
     1.598     7.707     0.200
     1.624     8.709     0.200
     1.624     7.482     0.200
     1.624     8.208     0.200
     1.719     8.898     0.200
     1.764     7.977     0.200
     1.819     8.731     0.200
     1.930     8.637     0.200
     1.980    10.062     0.200
     2.151    10.152     0.200
     2.155     9.605     0.200
     2.245     9.961     0.200
     2.260     9.984     0.200
     2.287     9.947     0.200
     2.321    10.176     0.200
     2.403    11.320     0.200
     2.466    10.387     0.200
     2.457    10.408     0.200
     2.523    10.224     0.200
     2.553    10.856     0.200
     2.581    11.736     0.200
     2.616    10.436     0.200
     2.691    10.653     0.200
     2.739    11.392     0.200
     2.792    10.918     0.200
     2.834    11.490     0.200
     2.826    11.803     0.200
     2.837    11.945     0.200
     2.885    12.502     0.200
     2.900    11.021     0.200
     3.017    12.151     0.200
     3.011    12.529     0.200
     3.091    11.192     0.200
     3.199    12.412     0.200
     3.344    13.637     0.200
     3.318    12.593     0.200
     3.378    13.897     0.200
     3.391    14.141     0.200
     3.475    12.613     0.200
     3.531    14.053     0.200
     3.566    13.044     0.200
     3.597    13.285     0.200
     3.654    14.024     0.200
     3.659    14.357     0.200
     3.706    12.607     0.200
     3.721    14.336     0.200
     3.857    12.946     0.200
     3.924    14.469     0.200
     3.976    14.863     0.200
     4.000    12.680     0.200
     4.063    13.755     0.200
     4.056    14.344     0.200
     4.056    14.524     0.200
     4.113    16.253     0.200
     4.190    14.267     0.200
     4.191    14.047     0.200
     4.280    13.306     0.200
     4.372    14.236     0.200
     4.375    14.607     0.200
     4.371    14.970     0.200
     4.429    16.184     0.200
     4.429    15.966     0.200
     4.445    13.988     0.200
     4.464    14.761     0.200
     4.506    19.156     0.200
     4.537    14.054     0.200
     4.553    15.927     0.200
     4.564    13.696     0.200
     4.568    14.730     0.200
     4.562    15.533     0.200
     4.648    14.856     0.200
     4.738    16.672     0.200
     4.732    14.672     0.200
     4.821    15.994     0.200
     4.983    14.604     0.200
     5.027    17.500     0.200
     5.076    14.824     0.200
     5.082    17.354     0.200
     5.170    15.129     0.200
     5.339    15.973     0.200
     5.339    15.856     0.200
     5.330    16.108     0.200
     5.392    16.674     0.200
     5.487    15.628     0.200
     5.504    16.029     0.200
     5.658    18.630     0.200
     5.698    15.464     0.200
     5.772    17.207     0.200
     5.800    16.979     0.200
     5.759    18.751     0.200
     5.759    18.853     0.200
     5.867    17.700     0.200
     5.854    17.440     0.200
     6.003    18.031     0.200
     6.003    17.703     0.200
     6.021    17.846     0.200
     6.023    17.036     0.200
     6.104    17.998     0.200
     6.130    18.171     0.200
     6.151    16.378     0.200
     6.161    19.270     0.200
     6.239    16.547     0.200
     6.274    18.427     0.200
     6.320    19.810     0.200
     6.320    18.505     0.200
     6.353    18.426     0.200
     6.386    19.636     0.200
     6.403    17.535     0.200
     6.463    20.033     0.200
     6.706    19.260     0.200
     6.706    19.799     0.200
     6.726    16.862     0.200
     6.785    18.674     0.200
     6.889    21.066     0.200
     6.962    18.215     0.200
     6.991    20.177     0.200
     7.049    18.795     0.200
     7.049    19.154     0.200
     7.105    22.947     0.200
     7.284    17.458     0.200
     7.304    18.221     0.200
     7.346    19.836     0.200
     7.449    19.830     0.200
     7.438    20.374     0.200
     7.464    18.454     0.200
     7.571    19.400     0.200
     7.623    18.794     0.200
     7.730    21.248     0.200
     7.765    25.041     0.200
     7.818    23.175     0.200
     7.992    20.194     0.200
     8.107    22.355     0.200
     8.178    20.229     0.200
     8.186    20.225     0.200
     8.228    19.938     0.200
     8.235    20.863     0.200
     8.368    25.894     0.200
     8.368    24.011     0.200
     8.399    20.649     0.200
     8.419    20.712     0.200
     8.415    20.159     0.200
     8.517    21.163     0.200
     8.590    21.423     0.200
     8.635    21.595     0.200
     8.681    22.359     0.200
     8.716    21.141     0.200
     8.806    22.488     0.200
     8.899    21.111     0.200
     9.140    22.701     0.200
     9.134    23.666     0.200
     9.227    22.385     0.200
     9.608    22.840     0.200
     9.879    22.567     0.200
     9.885    24.307     0.200
     9.898    23.346     0.200
     9.880    28.297     0.200
     9.974    23.272     0.200
     9.997    22.798     0.200
    10.199    23.140     0.200
    10.512    24.487     0.200
    13.910    35.233     0.200
    13.910    37.132     0.200
    19.115    39.687     0.200
    19.978    39.916     0.200
    20.579    38.403     0.200
     1.397     8.531     0.200
     1.521     8.482     0.200
     1.569     9.418     0.200
     1.577     9.324     0.200
     1.557     9.957     0.200
     1.560     9.019     0.200
     1.699    10.304     0.200
     1.729    10.154     0.200
     1.811    10.394     0.200
     1.802     9.295     0.200
     1.849     9.255     0.200
     1.949     9.979     0.200
     1.946     9.426     0.200
     2.048     9.637     0.200
     2.099    11.141     0.200
     2.162    11.990     0.200
     2.242    10.166     0.200
     2.202    11.329     0.200
     2.206    10.683     0.200
     2.293    11.066     0.200
     2.293    11.569     0.200
     2.317    12.185     0.200
     2.503    11.013     0.200
     2.541    11.071     0.200
     2.542    12.159     0.200
     2.966    14.716     0.200
     3.059    12.633     0.200
     3.304    14.772     0.200
     3.306    12.812     0.200
     3.423    13.312     0.200
     3.621    14.098     0.200
     3.666    14.541     0.200
     3.857    15.134     0.200
     3.862    13.262     0.200
     3.894    14.992     0.200
     3.887    13.362     0.200
     3.958    15.117     0.200
     3.994    15.572     0.200
     4.061    14.336     0.200
     4.081    13.198     0.200
     4.367    16.852     0.200
     4.503    17.673     0.200
     4.536    17.289     0.200
     4.636    16.901     0.200
     4.739    17.922     0.200
     5.119    17.286     0.200
     5.167    16.832     0.200
     5.219    17.007     0.200
     5.325    18.992     0.200
     5.402    18.965     0.200
     5.395    17.272     0.200
     5.462    17.795     0.200
     5.478    17.179     0.200
     5.575    17.974     0.200
     5.581    17.238     0.200
     5.599    16.585     0.200
     5.641    17.696     0.200
     5.632    18.099     0.200
     5.786    18.511     0.200
     5.799    18.754     0.200
     5.812    18.090     0.200
     5.886    19.993     0.200
     5.918    18.667     0.200
     6.014    17.741     0.200
     6.032    18.017     0.200
     6.038    17.462     0.200
     6.237    18.537     0.200
     6.239    18.636     0.200
     6.295    18.399     0.200
     6.320    19.018     0.200
     6.420    20.607     0.200
     6.438    19.303     0.200
     6.437    19.096     0.200
     6.554    19.481     0.200
     6.667    22.222     0.200
     6.722    22.279     0.200
     6.740    19.995     0.200
     6.735    19.397     0.200
     6.858    22.105     0.200
     6.886    20.974     0.200
     6.924    20.027     0.200
     7.068    23.645     0.200
     7.108    21.078     0.200
     7.446    22.335     0.200
     7.486    20.362     0.200
     7.557    20.880     0.200
     7.577    21.904     0.200
     7.814    23.038     0.200
     7.847    22.457     0.200
     7.920    23.008     0.200
     7.920    23.110     0.200
     8.053    22.159     0.200
     8.094    21.869     0.200
     8.465    23.942     0.200
     8.637    22.136     0.200
     8.722    22.242     0.200
     8.803    27.295     0.200
     9.094    23.203     0.200
     9.169    22.722     0.200
     9.504    24.122     0.200
     9.519    28.449     0.200
     9.532    22.595     0.200
     9.572    25.829     0.200
     9.587    23.846     0.200
    10.104    29.915     0.200
    13.905    34.425     0.200
     1.393     9.304     0.200
     1.396     9.360     0.200
     1.420     8.793     0.200
     1.499     8.968     0.200
     1.574     9.188     0.200
     1.586     9.454     0.200
     1.587     9.537     0.200
     1.557     8.691     0.200
     1.554     8.516     0.200
     1.618     9.480     0.200
     1.589     9.021     0.200
     1.637     8.958     0.200
     1.640     8.718     0.200
     1.656     9.231     0.200
     1.704     9.177     0.200
     1.769     9.118     0.200
     1.803     9.616     0.200
     1.857    10.085     0.200
     1.861     9.343     0.200
     1.919     9.366     0.200
     2.064     8.379     0.200
     2.137    10.817     0.200
     2.154    10.016     0.200
     2.442    11.810     0.200
     2.658    11.337     0.200
     2.817    12.084     0.200
     2.817    11.881     0.200
     2.862    12.667     0.200
     2.839    12.829     0.200
     2.872    11.621     0.200
     2.914    12.959     0.200
     2.914    12.858     0.200
     3.014    13.087     0.200
     3.012    13.909     0.200
     3.111    14.159     0.200
     3.098    13.102     0.200
     3.155    12.441     0.200
     3.116    12.787     0.200
     3.124    13.509     0.200
     3.187    12.463     0.200
     3.204    12.566     0.200
     3.309    14.343     0.200
     3.296    13.395     0.200
     3.319    12.829     0.200
     3.310    14.431     0.200
     3.381    13.801     0.200
     3.385    13.851     0.200
     3.385    13.851     0.200
     3.472    15.242     0.200
     3.465    13.225     0.200
     3.468    14.092     0.200
     3.512    14.277     0.200
     3.673    15.496     0.200
     3.755    14.638     0.200
     3.737    14.449     0.200
     3.745    14.354     0.200
     3.766    14.612     0.200
     3.794    15.481     0.200
     3.805    14.355     0.200
     3.805    14.457     0.200
     3.844    14.607     0.200
     3.944    16.007     0.200
     3.928    15.023     0.200
     3.946    15.208     0.200
     3.946    15.208     0.200
     3.967    16.361     0.200
     4.015    16.202     0.200
     4.057    14.776     0.200
     4.084    15.406     0.200
     4.089    13.542     0.200
     4.123    14.841     0.200
     4.160    15.019     0.200
     4.270    15.066     0.200
     4.270    15.230     0.200
     4.357    15.015     0.200
     4.391    14.517     0.200
     4.412    16.073     0.200
     4.498    16.069     0.200
     4.498    15.967     0.200
     4.536    16.227     0.200
     4.536    16.102     0.200
     4.686    14.473     0.200
     4.686    14.575     0.200
     4.718    16.300     0.200
     4.821    15.377     0.200
     4.867    15.666     0.200
     4.838    16.300     0.200
     4.877    15.845     0.200
     4.864    16.499     0.200
     4.942    17.081     0.200
     4.942    16.972     0.200
     4.955    16.969     0.200
     5.010    15.729     0.200
     5.022    15.959     0.200
     5.022    15.256     0.200
     5.017    17.384     0.200
     5.027    17.194     0.200
     5.087    14.492     0.200
     5.119    15.520     0.200
     5.229    19.046     0.200
     5.295    16.463     0.200
     5.320    16.495     0.200
     5.314    17.451     0.200
     5.368    17.510     0.200
     5.439    18.412     0.200
     5.489    17.638     0.200
     5.510    16.153     0.200
     5.582    16.681     0.200
     5.670    17.889     0.200
     5.655    17.994     0.200
     5.755    17.990     0.200
     5.757    18.281     0.200
     5.851    19.581     0.200
     5.819    18.660     0.200
     5.832    17.406     0.200
     5.872    19.228     0.200
     6.018    18.390     0.200
     6.019    19.915     0.200
     6.027    18.928     0.200
     6.081    19.274     0.200
     6.101    18.367     0.200
     6.097    18.708     0.200
     6.171    18.620     0.200
     6.193    18.786     0.200
     6.202    17.602     0.200
     6.245    19.319     0.200
     6.239    18.651     0.200
     6.281    18.451     0.200
     6.281    18.392     0.200
     6.311    18.510     0.200
     6.269    20.202     0.200
     6.301    19.121     0.200
     6.301    19.621     0.200
     6.356    19.081     0.200
     6.302    20.018     0.200
     6.302    20.518     0.200
     6.326    20.328     0.200
     6.347    18.693     0.200
     6.478    19.884     0.200
     6.491    19.403     0.200
     6.615    20.541     0.200
     6.616    16.356     0.200
     6.655    19.803     0.200
     6.816    20.420     0.200
     6.789    20.339     0.200
     6.797    20.690     0.200
     6.834    20.096     0.200
     6.876    21.819     0.200
     6.865    21.045     0.200
     6.983    19.269     0.200
     6.950    19.551     0.200
     7.004    18.422     0.200
     6.962    20.897     0.200
     6.962    21.116     0.200
     7.062    20.045     0.200
     7.109    21.029     0.200
     7.198    19.815     0.200
     7.198    19.549     0.200
     7.193    20.716     0.200
     7.273    19.580     0.200
     7.259    20.643     0.200
     7.263    22.207     0.200
     7.338    21.223     0.200
     7.327    23.984     0.200
     7.372    21.032     0.200
     7.357    21.107     0.200
     7.491    20.332     0.200
     7.621    23.620     0.200
     7.719    22.580     0.200
     7.726    22.302     0.200
     7.788    22.570     0.200
     7.973    19.519     0.200
     7.980    21.631     0.200
     8.050    19.119     0.200
     8.065    21.708     0.200
     8.065    22.637     0.200
     8.075    21.730     0.200
     8.301    22.984     0.200
     8.342    20.912     0.200
     8.319    25.883     0.200
     8.395    20.293     0.200
     8.486    21.535     0.200
     8.579    21.034     0.200
     8.701    24.018     0.200
     8.718    21.523     0.200
     8.922    27.024     0.200
     8.922    27.134     0.200
     8.941    27.716     0.200
     9.065    24.468     0.200
     9.311    21.799     0.200
     9.508    22.903     0.200
     9.489    23.721     0.200
     9.489    23.877     0.200
     9.611    22.701     0.200
     9.676    22.141     0.200
     9.713    23.206     0.200
     9.658    27.971     0.200
     9.885    22.800     0.200
    10.153    27.751     0.200
    10.598    27.078     0.200
    11.089    28.951     0.200
     0.960     6.584     0.200
     0.983     7.813     0.200
     0.946     6.048     0.200
     0.996     7.363     0.200
     0.956     6.037     0.200
     1.062     6.596     0.200
     1.180     7.222     0.200
     1.110     6.333     0.200
     1.158     6.473     0.200
     1.183     6.986     0.200
     1.243     7.388     0.200
     1.131     6.492     0.200
     1.205     6.426     0.200
     1.263     7.550     0.200
     1.157     6.584     0.200
     1.244     7.070     0.200
     1.415     7.672     0.200
     1.381     7.479     0.200
     1.384     7.635     0.200
     1.376     7.132     0.200
     1.495     8.141     0.200
     1.449     7.073     0.200
     1.538     8.445     0.200
     1.459     7.261     0.200
     1.502     7.367     0.200
     1.623     7.952     0.200
     1.621     7.970     0.200
     1.566     7.014     0.200
     1.616     7.328     0.200
     1.601     7.711     0.200
     1.625     7.328     0.200
     1.638     7.278     0.200
     1.783     8.483     0.200
     1.709     7.441     0.200
     1.705     7.496     0.200
     1.763     7.619     0.200
     1.878     9.775     0.200
     1.768     8.156     0.200
     1.840     8.520     0.200
     1.931     9.058     0.200
     2.100    10.180     0.200
     2.165    10.023     0.200
     2.198     9.738     0.200
     2.081     9.398     0.200
     2.314     8.883     0.200
     2.269    10.312     0.200
     2.411    10.256     0.200
     2.424     9.498     0.200
     2.342    10.062     0.200
     2.510     9.799     0.200
     2.646     9.913     0.200
     2.543    10.916     0.200
     2.575    10.241     0.200
     2.628    10.721     0.200
     2.628    10.721     0.200
     2.645    11.022     0.200
     2.777    11.283     0.200
     2.754     9.841     0.200
     2.910    10.627     0.200
     2.808    11.413     0.200
     2.984    10.668     0.200
     2.934    11.754     0.200
     3.076    12.493     0.200
     3.017    12.384     0.200
     3.170    11.897     0.200
     3.059    12.587     0.200
     3.099    11.689     0.200
     3.170    12.194     0.200
     3.316    11.794     0.200
     3.190    12.365     0.200
     3.190    12.365     0.200
     3.283    11.084     0.200
     3.507    12.164     0.200
     3.530    12.699     0.200
     3.474    13.145     0.200
     3.629    12.082     0.200
     3.738    12.769     0.200
     3.786    13.205     0.200
     3.786    14.302     0.200
     3.769    12.809     0.200
     3.838    13.678     0.200
     4.023    13.141     0.200
     3.938    12.636     0.200
     3.971    14.347     0.200
     4.111    15.112     0.200
     4.104    13.695     0.200
     4.129    14.502     0.200
     4.254    13.951     0.200
     4.121    13.575     0.200
     4.177    13.944     0.200
     4.212    12.669     0.200
     4.246    13.942     0.200
     4.246    12.844     0.200
     4.387    13.789     0.200
     4.389    11.875     0.200
     4.360    12.609     0.200
     4.362    12.864     0.200
     4.345    14.380     0.200
     4.567    13.977     0.200
     4.536    17.480     0.200
     4.556    15.019     0.200
     4.702    14.238     0.200
     4.745    13.714     0.200
     4.628    16.582     0.200
     4.816    14.126     0.200
     4.782    12.876     0.200
     4.785    15.553     0.200
     4.982    14.331     0.200
     5.089    15.902     0.200
     5.119    13.852     0.200
     5.223    15.639     0.200
     5.111    14.900     0.200
     5.225    15.412     0.200
     5.266    16.599     0.200
     5.266    16.736     0.200
     5.361    15.264     0.200
     5.473    15.202     0.200
     5.381    15.687     0.200
     5.642    15.054     0.200
     5.639    15.484     0.200
     5.547    17.655     0.200
     5.624    18.350     0.200
     5.868    15.313     0.200
     5.750    18.292     0.200
     5.750    17.792     0.200
     5.800    17.709     0.200
     5.821    18.338     0.200
     6.036    16.499     0.200
     6.036    16.547     0.200
     6.055    16.874     0.200
     5.973    17.191     0.200
     5.983    18.369     0.200
     5.988    18.911     0.200
     6.136    16.470     0.200
     6.219    16.727     0.200
     6.156    19.080     0.200
     6.279    16.706     0.200
     6.396    16.692     0.200
     6.287    17.314     0.200
     6.450    19.121     0.200
     6.470    18.070     0.200
     6.514    17.771     0.200
     6.390    18.619     0.200
     6.390    18.119     0.200
     6.397    19.162     0.200
     6.553    17.118     0.200
     6.677    18.762     0.200
     6.848    18.800     0.200
     6.729    18.947     0.200
     6.729    18.466     0.200
     6.789    18.141     0.200
     6.940    19.995     0.200
     7.001    20.090     0.200
     6.942    19.678     0.200
     7.107    19.315     0.200
     7.107    18.245     0.200
     7.217    20.068     0.200
     7.404    19.209     0.200
     7.375    23.323     0.200
     7.356    20.449     0.200
     7.438    20.091     0.200
     7.571    21.232     0.200
     7.587    22.646     0.200
     7.946    24.731     0.200
     7.959    21.910     0.200
     8.062    26.904     0.200
     8.186    23.864     0.200
     8.186    24.899     0.200
     8.384    26.053     0.200
     8.681    19.081     0.200
     8.810    26.121     0.200
     9.064    20.015     0.200
     9.074    25.198     0.200
     9.800    21.523     0.200
     9.700    22.623     0.200
    10.066    21.523     0.200
    10.166    21.848     0.200
    10.186    21.414     0.200
    12.783    28.915     0.200
    17.965    37.035     0.200
    19.377    38.169     0.200
     1.032     6.833     0.200
     0.958     6.195     0.200
     1.045     7.086     0.200
     1.116     7.355     0.200
     1.032     6.533     0.200
     1.045     6.388     0.200
     1.099     6.650     0.200
     1.216     6.686     0.200
     1.248     6.515     0.200
     1.309     7.199     0.200
     1.341     6.624     0.200
     1.524     7.491     0.200
     1.535     7.869     0.200
     1.599     7.811     0.200
     1.856     9.622     0.200
     2.059     9.946     0.200
     2.339    10.282     0.200
     2.488    10.844     0.200
     2.576    10.512     0.200
     2.569    10.600     0.200
     2.748    11.007     0.200
     2.779    10.843     0.200
     2.826    11.196     0.200
     2.863    11.962     0.200
     2.965    11.273     0.200
     3.197    12.266     0.200
     3.331    12.706     0.200
     3.433    13.116     0.200
     3.409    12.801     0.200
     3.455    12.556     0.200
     3.455    12.556     0.200
     3.651    14.071     0.200
     3.654    12.835     0.200
     3.669    14.155     0.200
     3.934    14.362     0.200
     3.923    14.450     0.200
     3.995    13.856     0.200
     4.101    14.122     0.200
     4.127    14.309     0.200
     4.127    14.411     0.200
     4.127    13.809     0.200
     4.199    12.459     0.200
     4.175    14.649     0.200
     4.255    15.716     0.200
     4.344    17.176     0.200
     4.383    13.724     0.200
     4.407    12.353     0.200
     4.476    12.345     0.200
     4.394    15.201     0.200
     4.408    15.235     0.200
     4.419    14.912     0.200
     4.442    13.443     0.200
     4.444    14.611     0.200
     4.669    15.088     0.200
     4.756    15.071     0.200
     4.757    15.067     0.200
     4.787    16.010     0.200
     4.815    16.288     0.200
     5.027    16.207     0.200
     5.056    14.868     0.200
     5.072    15.590     0.200
     5.072    15.789     0.200
     5.165    15.501     0.200
     5.183    15.051     0.200
     5.145    16.139     0.200
     5.182    15.104     0.200
     5.182    15.401     0.200
     5.166    16.884     0.200
     5.166    16.485     0.200
     5.213    15.642     0.200
     5.233    17.011     0.200
     5.231    17.274     0.200
     5.311    15.539     0.200
     5.247    17.049     0.200
     5.247    16.948     0.200
     5.401    18.348     0.200
     5.402    16.940     0.200
     5.492    16.492     0.200
     5.572    18.651     0.200
     5.601    18.417     0.200
     5.691    16.023     0.200
     5.673    17.774     0.200
     5.739    16.109     0.200
     5.704    18.111     0.200
     5.728    18.128     0.200
     5.800    16.610     0.200
     5.753    18.738     0.200
     5.753    18.039     0.200
     5.879    17.570     0.200
     5.882    18.431     0.200
     5.889    18.455     0.200
     5.889    18.256     0.200
     5.900    18.721     0.200
     6.001    17.141     0.200
     5.985    17.437     0.200
     5.985    18.136     0.200
     5.966    17.755     0.200
     6.035    17.944     0.200
     6.051    18.658     0.200
     6.085    18.662     0.200
     6.107    18.901     0.200
     6.147    18.745     0.200
     6.207    17.637     0.200
     6.160    18.785     0.200
     6.205    17.369     0.200
     6.162    17.960     0.200
     6.208    18.130     0.200
     6.286    19.221     0.200
     6.293    19.337     0.200
     6.326    17.655     0.200
     6.335    18.848     0.200
     6.340    18.384     0.200
     6.419    18.388     0.200
     6.410    18.201     0.200
     6.419    17.794     0.200
     6.472    17.151     0.200
     6.502    18.787     0.200
     6.523    18.926     0.200
     6.530    18.386     0.200
     6.542    18.131     0.200
     6.495    18.583     0.200
     6.527    18.708     0.200
     6.667    19.010     0.200
     6.691    19.434     0.200
     6.621    18.206     0.200
     6.710    18.368     0.200
     6.668    19.959     0.200
     6.720    19.449     0.200
     6.731    18.431     0.200
     6.799    19.138     0.200
     6.909    19.654     0.200
     6.982    17.391     0.200
     7.085    20.621     0.200
     7.092    18.712     0.200
     7.092    20.013     0.200
     7.092    18.314     0.200
     7.119    19.403     0.200
     7.092    20.012     0.200
     7.120    19.882     0.200
     7.226    17.950     0.200
     7.344    20.068     0.200
     7.338    22.339     0.200
     7.457    19.050     0.200
     7.457    19.323     0.200
     7.577    18.359     0.200
     7.575    23.530     0.200
     7.597    17.919     0.200
     7.628    20.557     0.200
     7.754    19.887     0.200
     7.754    19.989     0.200
     7.792    18.846     0.200
     7.827    19.196     0.200
     7.827    20.731     0.200
     7.885    19.157     0.200
     7.808    21.755     0.200
     7.873    19.405     0.200
     7.835    22.144     0.200
     7.901    22.376     0.200
     8.105    23.591     0.200
     8.243    22.982     0.200
     8.375    22.136     0.200
     8.375    21.738     0.200
     8.357    23.648     0.200
     8.424    20.971     0.200
     8.441    22.972     0.200
     8.511    21.047     0.200
     8.546    20.845     0.200
     8.554    22.157     0.200
     8.493    25.352     0.200
     8.493    24.258     0.200
     8.540    23.917     0.200
     8.562    26.456     0.200
     8.562    26.558     0.200
     8.594    20.485     0.200
     8.604    22.174     0.200
     8.667    20.632     0.200
     8.779    25.225     0.200
     8.870    19.762     0.200
     8.836    25.762     0.200
     8.872    22.944     0.200
     8.872    23.546     0.200
     9.020    21.417     0.200
     8.998    22.670     0.200
     9.083    21.880     0.200
     9.092    25.870     0.200
     9.124    23.301     0.200
     9.148    24.417     0.200
     9.170    26.358     0.200
     9.250    21.532     0.200
     9.337    25.513     0.200
     9.436    23.664     0.200
     9.547    22.663     0.200
     9.565    22.585     0.200
     9.904    23.097     0.200
     9.828    25.984     0.200
     9.925    21.448     0.200
     9.963    24.205     0.200
    10.054    22.945     0.200
    10.078    23.269     0.200
    10.191    23.148     0.200
    10.232    23.569     0.200
    10.269    23.530     0.200
    10.301    23.370     0.200
    10.485    23.816     0.200
    10.786    24.602     0.200
    10.920    24.534     0.200
    11.415    25.758     0.200
    11.672    26.261     0.200
    13.156    32.201     0.200
    13.808    35.837     0.200
    14.992    37.450     0.200
    15.002    32.408     0.200
    18.368    38.922     0.200
    18.530    39.034     0.200
    20.166    39.017     0.200
    20.500    39.242     0.200
     0.941     6.685     0.200
     0.953     6.259     0.200
     1.035     6.596     0.200
     1.028     6.380     0.200
     1.119     7.115     0.200
     1.093     6.518     0.200
     1.194     7.634     0.200
     1.184     6.656     0.200
     1.242     6.383     0.200
     1.278     7.063     0.200
     1.295     6.859     0.200
     1.361     7.092     0.200
     1.380     7.768     0.200
     1.350     6.726     0.200
     1.367     6.918     0.200
     1.447     7.986     0.200
     1.438     7.395     0.200
     1.541     7.991     0.200
     1.518     7.559     0.200
     1.572     8.432     0.200
     1.594     7.771     0.200
     1.872     9.135     0.200
     2.019    10.314     0.200
     2.034     9.930     0.200
     2.062    10.417     0.200
     3.653    13.938     0.200
     3.649    12.890     0.200
     3.670    14.939     0.200
     3.936    14.840     0.200
     3.990    14.105     0.200
     4.096    14.270     0.200
     4.130    14.182     0.200
     4.205    12.264     0.200
     4.252    15.451     0.200
     4.405    15.265     0.200
     4.419    15.101     0.200
     4.444    13.313     0.200
     4.446    15.187     0.200
     4.787    16.512     0.200
     5.062    15.155     0.200
     5.066    15.751     0.200
     5.161    16.642     0.200
     5.243    17.092     0.200
     5.396    18.402     0.200
     5.489    17.612     0.200
     5.568    18.800     0.200
     5.698    15.796     0.200
     5.668    17.734     0.200
     5.700    18.557     0.200
     5.745    15.328     0.200
     5.723    18.583     0.200
     5.877    18.481     0.200
     5.883    18.215     0.200
     5.896    18.972     0.200
     6.032    17.877     0.200
     6.047    18.909     0.200
     6.102    19.058     0.200
     6.142    18.894     0.200
     6.155    19.243     0.200
     6.159    17.700     0.200
     6.288    19.688     0.200
     6.322    18.092     0.200
     6.336    19.131     0.200
     6.416    18.026     0.200
     6.425    17.978     0.200
     6.476    16.095     0.200
     6.508    18.842     0.200
     6.521    18.772     0.200
     6.616    18.271     0.200
     6.663    20.118     0.200
     6.716    19.600     0.200
     6.727    19.374     0.200
     6.739    20.025     0.200
     6.986    17.041     0.200
     7.091    20.377     0.200
     7.115    19.940     0.200
     7.133    20.238     0.200
     7.131    20.848     0.200
     7.231    17.890     0.200
     7.282    20.895     0.200
     7.602    18.553     0.200
     7.760    19.814     0.200
     7.796    18.793     0.200
     7.890    19.996     0.200
     8.552    20.680     0.200
     8.876    20.987     0.200
     9.089    21.505     0.200
     9.256    21.964     0.200
     9.909    22.931     0.200
     9.931    23.274     0.200
    10.196    23.077     0.200
    10.275    23.665     0.200
    11.421    26.188     0.200
     1.424     8.510     0.200
     1.423     9.028     0.200
     1.413     8.847     0.200
     1.478     9.489     0.200
     1.528    10.404     0.200
     1.528     8.798     0.200
     1.527     8.516     0.200
     1.563     9.186     0.200
     1.614     9.094     0.200
     1.607     8.670     0.200
     1.625     9.770     0.200
     1.610     8.841     0.200
     1.644     9.651     0.200
     1.627     8.642     0.200
     1.678     9.449     0.200
     1.734     8.898     0.200
     1.774     9.931     0.200
     1.889     9.191     0.200
     2.020     9.961     0.200
     2.073     9.844     0.200
     2.124    11.244     0.200
     2.167    10.140     0.200
     2.228    10.336     0.200
     2.379    11.568     0.200
     2.800    12.057     0.200
     2.820    12.127     0.200
     2.929    12.904     0.200
     2.998    12.650     0.200
     3.077    13.019     0.200
     3.148    12.896     0.200
     3.236    12.772     0.200
     3.273    13.339     0.200
     3.278    13.172     0.200
     3.296    13.375     0.200
     3.365    13.364     0.200
     3.365    13.364     0.200
     3.366    13.746     0.200
     3.514    14.230     0.200
     3.740    14.087     0.200
     3.907    14.931     0.200
     3.927    15.401     0.200
     3.927    15.401     0.200
     3.964    14.501     0.200
     4.004    15.612     0.200
     4.004    15.206     0.200
     4.074    16.788     0.200
     4.173    14.637     0.200
     4.348    15.889     0.200
     4.374    15.885     0.200
     4.440    15.814     0.200
     4.469    17.877     0.200
     4.469    14.775     0.200
     4.486    14.880     0.200
     4.807    16.239     0.200
     4.838    15.460     0.200
     4.887    15.300     0.200
     5.004    15.691     0.200
     5.030    17.043     0.200
     5.343    18.057     0.200
     5.420    19.478     0.200
     5.596    16.442     0.200
     5.880    18.509     0.200
     5.972    19.037     0.200
     6.107    20.746     0.200
     6.125    19.891     0.200
     6.188    18.603     0.200
     6.270    18.872     0.200
     6.294    17.938     0.200
     6.340    19.442     0.200
     6.385    19.016     0.200
     6.503    20.769     0.200
     6.641    21.910     0.200
     7.510    20.286     0.200
     8.002    21.642     0.200
     8.370    21.251     0.200
     8.607    21.984     0.200
     8.746    21.767     0.200
     9.426    23.729     0.200
     9.706    24.066     0.200
     1.256     7.778     0.200
     1.169     6.993     0.200
     1.260     7.231     0.200
     1.313     7.416     0.200
     1.344     7.351     0.200
     1.392     8.189     0.200
     1.337     7.533     0.200
     1.503     8.003     0.200
     1.671     8.439     0.200
     1.757     8.330     0.200
     1.826     8.832     0.200
     1.972     8.128     0.200
     1.985     8.099     0.200
     1.985    10.869     0.200
     2.358    10.425     0.200
     2.384    10.718     0.200
     2.664    12.258     0.200
     2.710    10.677     0.200
     2.649    11.923     0.200
     2.712    11.693     0.200
     2.795    12.225     0.200
     2.837    11.833     0.200
     2.851    12.270     0.200
     2.893    12.173     0.200
     2.885    11.869     0.200
     2.934    12.001     0.200
     2.934    12.001     0.200
     3.158    13.890     0.200
     3.215    13.821     0.200
     3.296    13.372     0.200
     3.426    12.660     0.200
     3.474    14.391     0.200
     3.488    14.031     0.200
     3.488    14.031     0.200
     3.564    14.848     0.200
     3.627    13.017     0.200
     3.737    13.706     0.200
     3.921    12.477     0.200
     3.948    13.368     0.200
     3.904    15.276     0.200
     3.973    13.777     0.200
     3.990    14.071     0.200
     4.040    13.889     0.200
     4.046    13.921     0.200
     4.126    12.910     0.200
     4.210    13.704     0.200
     4.141    15.958     0.200
     4.326    15.255     0.200
     4.366    14.686     0.200
     4.406    15.626     0.200
     4.428    15.938     0.200
     4.433    15.403     0.200
     4.447    15.143     0.200
     4.522    15.776     0.200
     4.523    16.358     0.200
     4.549    18.953     0.200
     4.596    13.804     0.200
     4.669    14.850     0.200
     4.700    16.389     0.200
     4.786    15.584     0.200
     4.668    16.967     0.200
     4.761    14.745     0.200
     4.709    16.283     0.200
     4.806    15.152     0.200
     4.913    15.308     0.200
     4.923    17.588     0.200
     5.077    16.687     0.200
     5.285    15.558     0.200
     5.373    16.131     0.200
     5.400    16.322     0.200
     5.396    17.463     0.200
     5.444    16.903     0.200
     5.517    17.754     0.200
     5.545    18.333     0.200
     5.729    19.478     0.200
     6.012    18.079     0.200
     6.012    18.239     0.200
     6.024    17.840     0.200
     5.983    19.912     0.200
     6.060    17.617     0.200
     6.095    18.414     0.200
     6.125    17.862     0.200
     6.166    18.184     0.200
     6.071    19.585     0.200
     6.260    19.187     0.200
     6.175    20.078     0.200
     6.241    20.209     0.200
     6.248    19.225     0.200
     6.502    19.160     0.200
     6.649    19.847     0.200
     6.682    20.061     0.200
     6.706    19.784     0.200
     6.643    20.617     0.200
     6.895    19.270     0.200
     7.067    18.938     0.200
     7.052    21.045     0.200
     7.225    18.427     0.200
     7.245    18.089     0.200
     7.363    19.408     0.200
     7.496    21.262     0.200
     7.480    22.056     0.200
     7.556    20.757     0.200
     7.734    24.557     0.200
     8.049    21.011     0.200
     8.177    20.316     0.200
     8.349    22.006     0.200
     8.479    20.884     0.200
     8.601    21.159     0.200
     8.685    21.088     0.200
     8.860    19.943     0.200
     9.534    23.878     0.200
     9.550    22.694     0.200
     9.670    23.392     0.200
     9.826    22.668     0.200
     9.844    24.754     0.200
     9.916    23.124     0.200
     9.941    23.826     0.200
    10.138    24.324     0.200
    20.635    40.483     0.200
     1.426     7.942     0.200
     1.455     7.906     0.200
     1.501     9.973     0.200
     1.494     9.552     0.200
     1.469     8.142     0.200
     1.516     8.200     0.200
     1.647     9.773     0.200
     1.646     7.882     0.200
     1.739     8.590     0.200
     1.766     8.379     0.200
     1.874     9.017     0.200
     1.903     8.978     0.200
     1.910     8.603     0.200
     1.922     9.055     0.200
     2.118     9.673     0.200
     2.242    10.122     0.200
     2.265    10.153     0.200
     2.267    10.729     0.200
     2.440    10.919     0.200
     2.486    10.678     0.200
     2.533    11.032     0.200
     2.540    11.045     0.200
     2.540    11.043     0.200
     2.595    11.303     0.200
     2.627    11.830     0.200
     2.622    10.991     0.200
     2.671    11.815     0.200
     2.679    12.028     0.200
     2.701    10.872     0.200
     2.702    11.061     0.200
     2.721    12.034     0.200
     2.725    11.685     0.200
     2.735    12.172     0.200
     2.745    11.360     0.200
     2.771    11.755     0.200
     2.810    11.800     0.200
     2.817    11.912     0.200
     2.817    11.912     0.200
     2.837    11.582     0.200
     2.845    11.942     0.200
     2.879    12.484     0.200
     2.986    12.847     0.200
     2.992    12.574     0.200
     3.087    13.359     0.200
     3.099    13.026     0.200
     3.145    12.590     0.200
     3.183    13.143     0.200
     3.254    13.208     0.200
     3.323    12.311     0.200
     3.358    13.602     0.200
     3.365    13.722     0.200
     3.372    13.638     0.200
     3.372    13.638     0.200
     3.456    14.262     0.200
     3.603    13.337     0.200
     3.709    13.801     0.200
     3.802    12.413     0.200
     3.915    13.201     0.200
     3.920    13.941     0.200
     3.929    13.737     0.200
     3.934    14.273     0.200
     3.909    14.671     0.200
     4.012    12.870     0.200
     4.163    16.206     0.200
     4.200    14.269     0.200
     4.242    15.480     0.200
     4.293    16.689     0.200
     4.306    13.640     0.200
     4.299    15.421     0.200
     4.331    16.147     0.200
     4.350    15.422     0.200
     4.423    16.973     0.200
     4.571    13.842     0.200
     4.571    14.822     0.200
     4.540    16.307     0.200
     4.642    14.614     0.200
     4.657    14.872     0.200
     4.665    14.550     0.200
     4.696    14.283     0.200
     4.744    15.823     0.200
     4.764    14.192     0.200
     4.785    15.238     0.200
     4.804    14.220     0.200
     4.915    15.512     0.200
     5.064    17.194     0.200
     5.281    17.955     0.200
     5.303    16.030     0.200
     5.345    16.198     0.200
     5.404    16.452     0.200
     5.536    17.582     0.200
     5.901    19.820     0.200
     5.930    19.382     0.200
     6.012    16.988     0.200
     6.027    17.974     0.200
     5.991    19.970     0.200
     6.036    18.914     0.200
     6.119    18.727     0.200
     6.161    18.282     0.200
     6.261    16.617     0.200
     6.289    18.013     0.200
     6.394    20.173     0.200
     6.533    19.436     0.200
     6.565    20.874     0.200
     6.723    20.583     0.200
     6.749    17.731     0.200
     6.808    17.943     0.200
     6.989    21.825     0.200
     7.305    19.938     0.200
     7.325    19.701     0.200
     7.355    19.554     0.200
     7.358    21.822     0.200
     7.645    20.069     0.200
     8.249    20.726     0.200
     8.536    21.369     0.200
     8.734    22.461     0.200
     8.918    22.317     0.200
     9.629    23.021     0.200
     9.732    23.617     0.200
     9.904    23.907     0.200
     9.900    23.855     0.200
     9.995    23.750     0.200
    10.221    24.415     0.200
    10.640    25.821     0.200
     1.448     8.825     0.200
     1.520     9.291     0.200
     1.656    11.023     0.200
     1.656    10.803     0.200
     1.588    10.838     0.200
     1.638     9.317     0.200
     1.674    10.843     0.200
     1.759    11.201     0.200
     1.774    10.121     0.200
     1.764    11.345     0.200
     1.764    10.655     0.200
     1.741     9.714     0.200
     1.867    10.839     0.200
     1.845     9.993     0.200
     1.877    10.118     0.200
     1.975    11.381     0.200
     2.152    12.172     0.200
     2.391    12.623     0.200
     2.426    12.919     0.200
     2.426    11.720     0.200
     2.607    12.208     0.200
     2.648    12.420     0.200
     2.648    12.700     0.200
     2.648    11.420     0.200
     2.887    12.028     0.200
     2.964    14.238     0.200
     2.927    13.669     0.200
     2.956    13.027     0.200
     2.956    13.227     0.200
     3.003    12.439     0.200
     3.081    13.375     0.200
     3.147    14.102     0.200
     3.170    13.928     0.200
     3.170    14.129     0.200
     3.216    13.701     0.200
     3.258    15.607     0.200
     3.254    14.355     0.200
     3.306    14.848     0.200
     3.317    14.813     0.200
     3.317    14.313     0.200
     3.383    12.958     0.200
     3.398    13.752     0.200
     3.371    14.589     0.200
     3.418    14.938     0.200
     3.443    14.248     0.200
     3.443    14.548     0.200
     3.443    14.848     0.200
     3.443    14.478     0.200
     3.523    16.216     0.200
     3.511    15.750     0.200
     3.559    15.597     0.200
     3.559    15.997     0.200
     3.721    18.286     0.200
     3.698    14.968     0.200
     3.698    14.667     0.200
     3.698    13.877     0.200
     3.835    16.674     0.200
     3.843    17.885     0.200
     3.780    16.316     0.200
     3.795    14.990     0.200
     3.923    16.048     0.200
     3.922    16.260     0.200
     3.922    14.900     0.200
     3.925    16.723     0.200
     4.001    17.441     0.200
     3.969    15.505     0.200
     4.021    17.504     0.200
     3.988    16.987     0.200
     4.073    16.499     0.200
     4.043    17.250     0.200
     4.052    15.641     0.200
     4.159    14.596     0.200
     4.134    15.585     0.200
     4.134    14.985     0.200
     4.149    16.013     0.200
     4.149    15.772     0.200
     4.218    18.905     0.200
     4.215    19.634     0.200
     4.240    16.143     0.200
     4.240    16.343     0.200
     4.262    16.586     0.200
     4.328    15.940     0.200
     4.318    16.736     0.200
     4.449    15.484     0.200
     4.407    17.202     0.200
     4.419    16.454     0.200
     4.448    17.215     0.200
     4.588    14.589     0.200
     4.574    16.045     0.200
     4.529    16.879     0.200
     4.611    15.136     0.200
     4.659    15.955     0.200
     4.659    16.461     0.200
     4.682    18.393     0.200
     4.718    16.866     0.200
     4.718    16.746     0.200
     4.718    16.567     0.200
     4.753    16.455     0.200
     4.740    17.499     0.200
     4.744    17.665     0.200
     4.796    18.557     0.200
     4.808    18.613     0.200
     4.808    18.023     0.200
     4.873    15.980     0.200
     4.870    17.785     0.200
     4.922    18.091     0.200
     4.983    18.279     0.200
     5.006    17.308     0.200
     5.033    16.488     0.200
     5.038    17.529     0.200
     5.068    18.078     0.200
     5.095    17.971     0.200
     5.184    18.544     0.200
     5.244    18.934     0.200
     5.275    18.371     0.200
     5.337    16.834     0.200
     5.326    17.175     0.200
     5.326    17.075     0.200
     5.428    17.578     0.200
     5.361    18.264     0.200
     5.456    17.495     0.200
     5.449    16.338     0.200
     5.434    19.417     0.200
     5.497    16.894     0.200
     5.453    20.857     0.200
     5.532    18.451     0.200
     5.486    19.303     0.200
     5.572    17.607     0.200
     5.542    18.157     0.200
     5.626    18.366     0.200
     5.658    19.698     0.200
     5.718    20.601     0.200
     5.735    18.895     0.200
     5.735    18.695     0.200
     5.846    18.508     0.200
     5.840    17.905     0.200
     5.826    19.669     0.200
     5.826    19.539     0.200
     5.865    20.681     0.200
     5.946    19.738     0.200
     5.900    18.178     0.200
     5.909    20.765     0.200
     5.941    21.493     0.200
     6.011    20.939     0.200
     5.988    19.447     0.200
     6.011    20.784     0.200
     6.083    18.202     0.200
     6.045    20.912     0.200
     6.045    20.783     0.200
     6.066    20.434     0.200
     6.175    17.765     0.200
     6.121    21.300     0.200
     6.128    21.015     0.200
     6.133    20.652     0.200
     6.153    21.016     0.200
     6.155    21.099     0.200
     6.249    20.406     0.200
     6.189    21.307     0.200
     6.193    19.151     0.200
     6.313    20.552     0.200
     6.313    20.242     0.200
     6.313    21.052     0.200
     6.349    20.832     0.200
     6.358    20.129     0.200
     6.370    21.192     0.200
     6.371    20.978     0.200
     6.447    21.294     0.200
     6.535    24.379     0.200
     6.489    20.802     0.200
     6.603    19.569     0.200
     6.514    20.510     0.200
     6.587    20.640     0.200
     6.632    19.932     0.200
     6.548    20.812     0.200
     6.617    22.573     0.200
     6.556    22.015     0.200
     6.568    22.582     0.200
     6.602    20.781     0.200
     6.590    20.917     0.200
     6.669    21.924     0.200
     6.605    21.249     0.200
     6.692    21.524     0.200
     6.688    20.181     0.200
     6.673    22.050     0.200
     6.757    22.301     0.200
     6.707    21.452     0.200
     6.723    21.554     0.200
     6.732    21.867     0.200
     6.778    19.628     0.200
     6.791    21.077     0.200
     6.815    21.299     0.200
     6.977    24.304     0.200
     6.895    22.258     0.200
     6.999    23.176     0.200
     6.999    25.146     0.200
     6.988    22.070     0.200
     6.937    21.876     0.200
     7.006    22.572     0.200
     7.112    23.155     0.200
     7.191    23.528     0.200
     7.117    21.075     0.200
     7.379    21.420     0.200
     7.379    21.714     0.200
     7.471    21.338     0.200
     7.385    22.841     0.200
     7.465    24.458     0.200
     7.441    24.196     0.200
     7.434    22.473     0.200
     7.629    23.392     0.200
     7.548    22.239     0.200
     7.601    25.326     0.200
     7.601    22.256     0.200
     7.591    23.140     0.200
     7.643    23.931     0.200
     7.709    20.832     0.200
     7.717    21.326     0.200
     7.717    21.312     0.200
     7.708    25.277     0.200
     7.813    23.848     0.200
     7.915    21.965     0.200
     7.888    23.172     0.200
     7.914    26.166     0.200
     7.947    22.586     0.200
     8.011    21.494     0.200
     8.011    21.334     0.200
     7.978    24.522     0.200
     7.979    22.814     0.200
     7.997    24.797     0.200
     8.083    24.494     0.200
     8.084    24.787     0.200
     8.210    23.039     0.200
     8.210    21.820     0.200
     8.202    25.810     0.200
     8.288    27.708     0.200
     8.386    22.058     0.200
     8.397    22.635     0.200
     8.328    25.339     0.200
     8.382    24.268     0.200
     8.382    24.108     0.200
     8.414    24.942     0.200
     8.411    26.367     0.200
     8.495    26.692     0.200
     8.565    24.674     0.200
     8.685    23.074     0.200
     8.659    25.472     0.200
     8.736    23.474     0.200
     8.807    24.054     0.200
     8.786    27.894     0.200
     8.786    24.594     0.200
     8.815    22.858     0.200
     8.796    26.173     0.200
     8.908    27.122     0.200
     8.865    25.568     0.200
     8.962    23.583     0.200
     8.965    27.400     0.200
     9.060    23.896     0.200
     8.983    26.098     0.200
     8.989    26.826     0.200
     8.991    25.806     0.200
     9.053    28.185     0.200
     9.082    26.042     0.200
     9.087    28.233     0.200
     9.087    26.983     0.200
     9.097    25.267     0.200
     9.224    24.889     0.200
     9.179    26.912     0.200
     9.256    28.113     0.200
     9.266    25.290     0.200
     9.355    25.360     0.200
     9.333    27.909     0.200
     9.401    28.320     0.200
     9.395    25.883     0.200
     9.405    25.673     0.200
     9.435    26.416     0.200
     9.438    26.286     0.200
     9.443    26.324     0.200
     9.462    26.701     0.200
     9.496    26.413     0.200
     9.496    25.994     0.200
     9.706    24.864     0.200
     9.709    28.129     0.200
     9.722    25.385     0.200
     9.686    28.390     0.200
     9.742    28.938     0.200
     9.753    28.357     0.200
     9.763    29.468     0.200
     9.772    26.380     0.200
     9.772    27.487     0.200
     9.772    26.147     0.200
     9.958    25.119     0.200
    10.024    25.350     0.200
    10.149    25.885     0.200
    10.221    26.548     0.200
    10.221    27.648     0.200
    10.265    26.236     0.200
    10.184    29.077     0.200
    10.224    27.008     0.200
    10.410    29.846     0.200
    10.410    29.006     0.200
    10.416    28.669     0.200
    10.722    31.499     0.200
    10.877    30.893     0.200
    11.790    32.732     0.200
    13.730    34.566     0.200
    13.730    34.570     0.200
    14.297    36.746     0.200
    14.297    38.547     0.200
    14.297    36.743     0.200
    14.498    34.342     0.200
    18.200    39.811     0.200
    18.522    42.300     0.200
    18.843    41.834     0.200
    18.995    41.035     0.200
    19.695    42.987     0.200
    19.715    42.413     0.200
    19.981    43.837     0.200
    20.060    43.901     0.200
    20.052    41.356     0.200
    20.124    41.745     0.200
    20.193    44.690     0.200
    20.272    42.068     0.200
    20.569    41.155     0.200
    20.569    40.985     0.200
    20.576    41.685     0.200
    20.630    42.574     0.200
    20.814    45.728     0.200
     1.460    10.078     0.200
     1.528     9.043     0.200
     1.675    10.473     0.200
     1.749    10.297     0.200
     1.886    11.405     0.200
     1.984    11.958     0.200
     2.426    13.302     0.200
     2.426    12.362     0.200
     2.661    11.738     0.200
     2.662    12.539     0.200
     2.662    11.589     0.200
     2.941    13.590     0.200
     2.941    12.890     0.200
     2.970    12.845     0.200
     2.970    12.646     0.200
     3.161    13.726     0.200
     3.184    13.847     0.200
     3.184    13.347     0.200
     3.268    14.276     0.200
     3.319    14.176     0.200
     3.331    14.439     0.200
     3.391    12.779     0.200
     3.385    14.508     0.200
     3.432    14.957     0.200
     3.457    14.571     0.200
     3.457    14.271     0.200
     3.457    14.771     0.200
     3.457    15.170     0.200
     3.573    15.616     0.200
     3.573    15.015     0.200
     3.710    15.909     0.200
     3.794    16.236     0.200
     3.934    15.002     0.200
     3.934    15.801     0.200
     3.939    16.541     0.200
     3.977    15.895     0.200
     4.002    16.809     0.200
     4.057    17.170     0.200
     4.166    16.996     0.200
     4.148    15.606     0.200
     4.161    17.249     0.200
     4.254    15.963     0.200
     4.276    16.506     0.200
     4.337    15.852     0.200
     4.326    16.825     0.200
     4.426    16.299     0.200
     4.427    16.743     0.200
     4.418    17.698     0.200
     4.458    16.462     0.200
     4.581    17.044     0.200
     4.651    15.934     0.200
     4.543    16.997     0.200
     4.668    17.440     0.200
     4.692    18.654     0.200
     4.732    16.785     0.200
     4.732    16.485     0.200
     4.752    17.970     0.200
     4.820    18.681     0.200
     4.880    18.257     0.200
     4.881    17.649     0.200
     4.935    17.373     0.200
     5.020    17.029     0.200
     5.047    17.007     0.200
     5.052    17.348     0.200
     5.190    18.231     0.200
     5.254    19.695     0.200
     5.280    17.892     0.200
     5.344    17.410     0.200
     5.339    17.000     0.200
     5.375    18.689     0.200
     5.440    19.222     0.200
     5.466    20.674     0.200
     5.506    17.123     0.200
     5.538    18.649     0.200
     5.726    20.993     0.200
     5.747    20.537     0.200
     5.747    20.347     0.200
     5.845    19.580     0.200
     5.914    18.297     0.200
     5.949    20.690     0.200
     6.017    21.813     0.200
     6.018    21.085     0.200
     6.053    20.968     0.200
     6.169    18.121     0.200
     6.080    20.757     0.200
     6.128    22.600     0.200
     6.134    21.327     0.200
     6.326    21.180     0.200
     6.378    21.385     0.200
     6.596    18.336     0.200
     6.624    18.704     0.200
     6.589    22.549     0.200
     6.563    22.022     0.200
     6.557    20.686     0.200
     6.621    22.772     0.200
     6.582    19.603     0.200
     6.693    19.679     0.200
     6.695    21.949     0.200
     6.787    21.408     0.200
     6.986    24.313     0.200
     6.972    19.848     0.200
     6.990    23.500     0.200
     7.114    24.310     0.200
     7.396    20.099     0.200
     7.464    20.602     0.200
     7.624    20.638     0.200
     7.724    20.720     0.200
     8.018    22.838     0.200
     8.002    24.324     0.200
     8.380    22.411     0.200
     8.394    22.651     0.200
     8.509    27.111     0.200
     8.806    23.547     0.200
     9.060    23.577     0.200
     9.101    28.422     0.200
     9.777    27.442     0.200
     9.777    27.311     0.200
    10.198    28.899     0.200
    20.744    41.602     0.200
     1.428     9.237     0.200
     1.428     8.627     0.200
     1.526     9.395     0.200
     1.584    10.817     0.200
     1.661    10.619     0.200
     1.667    10.456     0.200
     1.679     9.471     0.200
     1.761    11.512     0.200
     1.748    10.198     0.200
     1.884    10.411     0.200
     1.984    11.750     0.200
     2.673    12.035     0.200
     2.949    13.481     0.200
     2.949    13.083     0.200
     3.168    14.227     0.200
     3.194    13.826     0.200
     3.194    13.624     0.200
     3.276    14.470     0.200
     3.325    14.294     0.200
     3.338    14.847     0.200
     3.338    13.548     0.200
     3.404    12.770     0.200
     3.421    13.526     0.200
     3.394    14.496     0.200
     3.441    15.544     0.200
     3.464    15.371     0.200
     3.464    15.371     0.200
     3.583    15.390     0.200
     3.583    14.790     0.200
     3.714    15.655     0.200
     3.802    16.426     0.200
     3.947    16.443     0.200
     3.947    15.241     0.200
     3.949    16.817     0.200
     4.009    17.110     0.200
     4.065    17.164     0.200
     4.159    15.467     0.200
     4.265    16.429     0.200
     4.265    15.830     0.200
     4.349    15.993     0.200
     4.438    16.038     0.200
     4.422    17.671     0.200
     4.471    15.482     0.200
     4.594    18.089     0.200
     4.652    17.809     0.200
     4.681    15.880     0.200
     4.776    18.143     0.200
     4.743    16.553     0.200
     4.743    16.254     0.200
     4.756    18.015     0.200
     4.823    18.987     0.200
     4.893    18.101     0.200
     5.276    17.634     0.200
     5.351    16.154     0.200
     5.382    18.495     0.200
     5.437    18.247     0.200
     5.471    20.470     0.200
     5.518    16.921     0.200
     5.584    18.434     0.200
     5.663    19.819     0.200
     5.724    21.003     0.200
     5.751    20.602     0.200
     5.856    18.720     0.200
     5.837    18.779     0.200
     5.946    20.609     0.200
     6.003    19.541     0.200
     6.015    20.307     0.200
     6.052    20.672     0.200
     6.052    21.272     0.200
     6.125    20.121     0.200
     6.159    21.622     0.200
     6.193    20.527     0.200
     6.374    21.312     0.200
     6.452    21.707     0.200
     6.502    19.924     0.200
     6.598    17.698     0.200
     6.599    22.217     0.200
     6.560    22.050     0.200
     6.557    20.577     0.200
     6.593    21.664     0.200
     6.702    21.113     0.200
     6.708    21.947     0.200
     6.800    19.836     0.200
     6.790    20.561     0.200
     6.974    25.040     0.200
     7.467    19.362     0.200
     7.737    20.880     0.200
     7.838    23.335     0.200
     7.940    26.744     0.200
     8.031    21.684     0.200
     8.226    26.707     0.200
     8.518    26.790     0.200
     8.518    26.091     0.200
     8.814    22.041     0.200
     9.110    26.704     0.200
     9.110    27.685     0.200
     9.184    27.125     0.200
     9.742    24.317     0.200
     9.710    28.690     0.200
     9.773    29.148     0.200
     9.773    29.355     0.200
     9.766    29.638     0.200
     9.779    30.283     0.200
    10.027    23.991     0.200
    10.118    24.318     0.200
    10.206    28.998     0.200
    13.904    37.945     0.200
    19.964    41.226     0.200
    20.589    41.125     0.200
    20.650    42.122     0.200
    20.751    41.241     0.200
     1.409     8.535     0.200
     1.405     9.101     0.200
     1.402     8.623     0.200
     1.421     9.154     0.200
     1.517     9.803     0.200
     1.538     9.053     0.200
     1.544     8.717     0.200
     1.572     9.344     0.200
     1.620     9.217     0.200
     1.631     9.508     0.200
     1.622     9.376     0.200
     1.627     9.184     0.200
     1.646     9.169     0.200
     1.687     9.199     0.200
     1.719     9.595     0.200
     1.752     9.402     0.200
     1.750     9.319     0.200
     1.907     9.496     0.200
     1.925    10.009     0.200
     2.037     9.807     0.200
     2.069     9.683     0.200
     2.246    10.968     0.200
     2.285    10.524     0.200
     2.288    10.576     0.200
     2.323    10.001     0.200
     2.446    12.833     0.200
     2.446    12.731     0.200
     2.493    11.399     0.200
     2.603    12.238     0.200
     2.819    12.484     0.200
     2.819    11.780     0.200
     2.839    11.749     0.200
     2.839    12.347     0.200
     2.897    13.272     0.200
     2.897    13.440     0.200
     2.888    11.972     0.200
     2.934    12.967     0.200
     3.016    13.080     0.200
     3.016    12.881     0.200
     3.097    12.836     0.200
     3.167    12.815     0.200
     3.202    14.104     0.200
     3.255    12.899     0.200
     3.293    13.154     0.200
     3.293    13.353     0.200
     3.324    12.448     0.200
     3.297    13.198     0.200
     3.316    13.383     0.200
     3.385    14.382     0.200
     3.385    13.780     0.200
     3.385    13.890     0.200
     3.385    13.382     0.200
     3.384    14.385     0.200
     3.384    13.682     0.200
     3.524    14.258     0.200
     3.524    14.785     0.200
     3.658    13.891     0.200
     3.674    14.299     0.200
     3.758    15.318     0.200
     3.799    14.747     0.200
     3.841    14.345     0.200
     3.873    15.976     0.200
     3.875    15.162     0.200
     3.927    14.551     0.200
     3.947    14.920     0.200
     3.967    14.961     0.200
     4.021    15.358     0.200
     4.021    16.057     0.200
     4.073    14.139     0.200
     4.125    15.532     0.200
     4.160    15.231     0.200
     4.176    14.748     0.200
     4.179    15.006     0.200
     4.206    15.892     0.200
     4.258    15.685     0.200
     4.319    15.575     0.200
     4.373    15.239     0.200
     4.421    16.287     0.200
     4.366    16.425     0.200
     4.484    17.342     0.200
     4.484    16.744     0.200
     4.503    16.726     0.200
     4.503    16.027     0.200
     4.706    16.655     0.200
     4.838    15.851     0.200
     4.824    16.983     0.200
     4.867    17.377     0.200
     4.906    16.718     0.200
     5.005    15.691     0.200
     5.027    16.229     0.200
     5.020    17.801     0.200
     5.030    17.576     0.200
     5.030    16.974     0.200
     5.250    19.013     0.200
     5.291    18.032     0.200
     5.313    18.077     0.200
     5.310    16.706     0.200
     5.310    16.905     0.200
     5.337    17.524     0.200
     5.313    18.378     0.200
     5.447    18.205     0.200
     5.439    18.604     0.200
     5.506    18.102     0.200
     5.598    16.819     0.200
     5.641    18.441     0.200
     5.862    15.966     0.200
     5.828    16.845     0.200
     5.858    19.516     0.200
     6.036    20.806     0.200
     6.098    20.865     0.200
     6.119    19.938     0.200
     6.118    19.959     0.200
     6.188    19.323     0.200
     6.218    19.850     0.200
     6.262    21.185     0.200
     6.297    18.716     0.200
     6.366    17.484     0.200
     6.308    19.272     0.200
     6.495    21.622     0.200
     6.629    17.723     0.200
     6.631    22.361     0.200
     7.018    19.683     0.200
     7.215    20.434     0.200
     7.286    19.949     0.200
     7.317    23.666     0.200
     7.385    21.289     0.200
     7.508    20.552     0.200
     7.988    20.460     0.200
     8.357    21.347     0.200
     8.596    22.464     0.200
     8.733    22.959     0.200
     8.926    29.383     0.200
     9.625    23.850     0.200
    20.938    40.708     0.200
     1.347     7.983     0.200
     1.495     9.356     0.200
     1.608     9.386     0.200
     1.734     9.617     0.200
     1.687     8.795     0.200
     1.691     9.364     0.200
     1.709     9.221     0.200
     1.762     9.062     0.200
     1.857     9.628     0.200
     1.843     9.620     0.200
     1.851     9.436     0.200
     1.851     9.315     0.200
     1.934    10.474     0.200
     1.938    10.326     0.200
     1.962     8.922     0.200
     1.984    10.595     0.200
     1.993    10.515     0.200
     1.949     9.441     0.200
     2.056    10.345     0.200
     2.077     9.309     0.200
     2.084    11.660     0.200
     2.176    11.258     0.200
     2.182    10.961     0.200
     2.192    11.251     0.200
     2.165    10.155     0.200
     2.244    11.085     0.200
     2.182    10.356     0.200
     2.281    11.446     0.200
     2.316    10.900     0.200
     2.328    10.203     0.200
     2.328    10.313     0.200
     2.312    10.231     0.200
     2.358    10.990     0.200
     2.358    10.631     0.200
     2.305    10.633     0.200
     2.386    12.300     0.200
     2.393    11.326     0.200
     2.419    11.120     0.200
     2.421    11.047     0.200
     2.494    11.009     0.200
     2.504    10.980     0.200
     2.532    12.208     0.200
     2.565    12.612     0.200
     2.573    12.705     0.200
     2.521    10.459     0.200
     2.528    11.249     0.200
     2.633    11.499     0.200
     2.635    11.370     0.200
     2.677    12.141     0.200
     2.694    10.663     0.200
     2.657    12.126     0.200
     2.779    12.511     0.200
     2.790    13.146     0.200
     2.823    12.339     0.200
     2.823    12.082     0.200
     2.823    10.878     0.200
     2.828    12.179     0.200
     2.824    14.474     0.200
     2.824    13.962     0.200
     2.858    11.318     0.200
     2.858    11.775     0.200
     2.882    12.144     0.200
     2.976    13.038     0.200
     3.021    10.823     0.200
     3.021    11.573     0.200
     2.974    14.057     0.200
     3.052    13.429     0.200
     2.990    11.772     0.200
     3.024    13.200     0.200
     3.038    11.766     0.200
     3.109    12.609     0.200
     3.154    12.687     0.200
     3.166    13.475     0.200
     3.194    12.503     0.200
     3.194    13.351     0.200
     3.182    12.721     0.200
     3.181    13.106     0.200
     3.185    12.650     0.200
     3.185    12.251     0.200
     3.185    12.450     0.200
     3.276    13.217     0.200
     3.229    12.548     0.200
     3.274    13.834     0.200
     3.276    10.162     0.200
     3.309    14.257     0.200
     3.318    13.073     0.200
     3.315    13.305     0.200
     3.338    12.647     0.200
     3.375    13.329     0.200
     3.383    13.545     0.200
     3.383    13.341     0.200
     3.383    13.045     0.200
     3.380    16.677     0.200
     3.430    13.193     0.200
     3.509    14.686     0.200
     3.509    15.644     0.200
     3.469    13.049     0.200
     3.549    14.041     0.200
     3.514    13.312     0.200
     3.583    13.751     0.200
     3.582    15.323     0.200
     3.566    13.861     0.200
     3.608    13.831     0.200
     3.608    14.671     0.200
     3.611    13.381     0.200
     3.617    13.918     0.200
     3.617    13.617     0.200
     3.625    14.020     0.200
     3.625    13.223     0.200
     3.636    16.508     0.200
     3.707    15.491     0.200
     3.656    14.866     0.200
     3.656    13.866     0.200
     3.722    13.888     0.200
     3.722    14.517     0.200
     3.722    14.251     0.200
     3.722    14.810     0.200
     3.722    13.591     0.200
     3.757    14.880     0.200
     3.757    14.380     0.200
     3.755    15.850     0.200
     3.767    17.363     0.200
     3.864    14.853     0.200
     3.900    15.110     0.200
     3.900    15.419     0.200
     3.900    14.782     0.200
     3.900    15.630     0.200
     3.938    12.646     0.200
     3.930    14.337     0.200
     3.930    13.567     0.200
     3.911    17.255     0.200
     3.931    16.323     0.200
     3.922    15.861     0.200
     4.080    14.918     0.200
     4.029    15.212     0.200
     4.089    14.618     0.200
     4.064    14.696     0.200
     4.064    15.099     0.200
     4.064    15.896     0.200
     4.064    15.528     0.200
     4.064    15.759     0.200
     4.148    14.253     0.200
     4.114    15.739     0.200
     4.114    15.602     0.200
     4.164    13.743     0.200
     4.130    16.930     0.200
     4.130    15.231     0.200
     4.138    15.705     0.200
     4.212    15.708     0.200
     4.167    18.313     0.200
     4.235    14.404     0.200
     4.215    15.671     0.200
     4.282    15.239     0.200
     4.253    14.792     0.200
     4.261    15.305     0.200
     4.261    14.305     0.200
     4.270    14.600     0.200
     4.248    17.728     0.200
     4.313    14.407     0.200
     4.267    15.934     0.200
     4.319    12.551     0.200
     4.295    16.257     0.200
     4.298    15.563     0.200
     4.344    14.339     0.200
     4.302    17.381     0.200
     4.348    16.088     0.200
     4.348    16.619     0.200
     4.403    14.843     0.200
     4.403    16.042     0.200
     4.438    13.217     0.200
     4.457    15.574     0.200
     4.457    14.503     0.200
     4.396    15.221     0.200
     4.473    18.214     0.200
     4.489    14.941     0.200
     4.490    15.329     0.200
     4.475    15.703     0.200
     4.475    17.304     0.200
     4.475    16.531     0.200
     4.495    16.271     0.200
     4.495    15.869     0.200
     4.495    16.611     0.200
     4.535    14.904     0.200
     4.567    15.888     0.200
     4.567    16.126     0.200
     4.641    15.638     0.200
     4.649    15.528     0.200
     4.649    14.977     0.200
     4.649    15.414     0.200
     4.664    17.536     0.200
     4.738    15.740     0.200
     4.783    17.304     0.200
     4.883    14.448     0.200
     4.873    15.958     0.200
     4.873    16.161     0.200
     4.915    17.052     0.200
     4.885    16.017     0.200
     4.885    16.313     0.200
     4.950    16.426     0.200
     4.984    14.997     0.200
     5.074    16.994     0.200
     5.103    16.627     0.200
     5.103    16.467     0.200
     5.114    16.503     0.200
     5.084    18.693     0.200
     5.178    20.764     0.200
     5.190    15.894     0.200
     5.198    17.222     0.200
     5.215    15.379     0.200
     5.166    18.434     0.200
     5.205    16.680     0.200
     5.205    18.987     0.200
     5.268    17.141     0.200
     5.241    16.565     0.200
     5.261    16.931     0.200
     5.299    16.203     0.200
     5.255    17.702     0.200
     5.258    17.163     0.200
     5.258    18.562     0.200
     5.362    18.428     0.200
     5.420    16.078     0.200
     5.420    16.179     0.200
     5.394    19.672     0.200
     5.395    18.364     0.200
     5.468    17.186     0.200
     5.415    18.133     0.200
     5.439    19.559     0.200
     5.534    17.668     0.200
     5.501    18.728     0.200
     5.566    16.270     0.200
     5.650    17.494     0.200
     5.646    19.237     0.200
     5.713    18.258     0.200
     5.742    17.712     0.200
     5.740    18.940     0.200
     5.740    18.389     0.200
     5.707    17.927     0.200
     5.801    17.628     0.200
     5.905    17.262     0.200
     5.866    19.674     0.200
     5.873    18.586     0.200
     5.973    20.620     0.200
     6.039    19.603     0.200
     6.031    15.634     0.200
     6.005    18.846     0.200
     6.005    19.045     0.200
     6.039    20.047     0.200
     6.126    20.238     0.200
     6.093    17.917     0.200
     6.089    20.166     0.200
     6.100    19.039     0.200
     6.173    17.990     0.200
     6.204    17.527     0.200
     6.182    19.815     0.200
     6.209    19.163     0.200
     6.146    21.404     0.200
     6.225    22.281     0.200
     6.233    18.842     0.200
     6.221    18.228     0.200
     6.278    19.725     0.200
     6.276    19.369     0.200
     6.291    19.738     0.200
     6.230    19.618     0.200
     6.230    19.719     0.200
     6.316    20.824     0.200
     6.285    19.828     0.200
     6.294    19.124     0.200
     6.339    19.852     0.200
     6.332    21.425     0.200
     6.342    21.015     0.200
     6.358    19.125     0.200
     6.358    19.328     0.200
     6.418    20.242     0.200
     6.457    19.734     0.200
     6.442    20.850     0.200
     6.476    20.856     0.200
     6.470    21.122     0.200
     6.470    20.822     0.200
     6.475    19.166     0.200
     6.475    19.365     0.200
     6.545    20.646     0.200
     6.558    21.407     0.200
     6.552    21.769     0.200
     6.609    18.857     0.200
     6.561    20.664     0.200
     6.643    20.278     0.200
     6.582    19.420     0.200
     6.585    21.574     0.200
     6.586    21.463     0.200
     6.619    22.075     0.200
     6.624    20.625     0.200
     6.624    20.324     0.200
     6.717    20.940     0.200
     6.665    21.543     0.200
     6.696    19.582     0.200
     6.696    19.231     0.200
     6.745    20.610     0.200
     6.760    20.430     0.200
     6.747    19.583     0.200
     6.739    20.088     0.200
     6.739    20.787     0.200
     6.802    22.745     0.200
     6.803    21.633     0.200
     6.859    21.146     0.200
     6.906    20.628     0.200
     6.882    20.214     0.200
     6.930    21.606     0.200
     6.930    21.164     0.200
     6.980    20.464     0.200
     6.958    20.420     0.200
     6.964    20.553     0.200
     7.040    20.569     0.200
     7.007    21.049     0.200
     7.055    21.592     0.200
     7.069    21.527     0.200
     7.140    21.101     0.200
     7.126    20.282     0.200
     7.173    21.577     0.200
     7.197    23.737     0.200
     7.158    20.391     0.200
     7.158    21.192     0.200
     7.154    22.835     0.200
     7.189    22.136     0.200
     7.220    25.691     0.200
     7.207    22.715     0.200
     7.259    19.715     0.200
     7.221    21.161     0.200
     7.253    21.182     0.200
     7.233    21.519     0.200
     7.292    20.935     0.200
     7.292    20.435     0.200
     7.322    22.474     0.200
     7.423    21.301     0.200
     7.471    21.043     0.200
     7.471    20.754     0.200
     7.471    20.293     0.200
     7.495    22.559     0.200
     7.533    21.517     0.200
     7.583    21.927     0.200
     7.583    22.563     0.200
     7.583    23.501     0.200
     7.588    21.775     0.200
     7.588    22.658     0.200
     7.590    21.654     0.200
     7.662    20.905     0.200
     7.670    23.023     0.200
     7.690    23.087     0.200
     7.746    21.932     0.200
     7.763    21.337     0.200
     7.763    20.638     0.200
     7.763    21.708     0.200
     7.788    22.239     0.200
     7.788    21.438     0.200
     7.770    23.499     0.200
     7.777    23.858     0.200
     7.831    21.543     0.200
     7.880    20.662     0.200
     7.818    22.995     0.200
     7.898    25.106     0.200
     7.859    23.908     0.200
     7.891    24.113     0.200
     7.934    21.437     0.200
     7.954    22.908     0.200
     7.959    23.937     0.200
     8.011    25.468     0.200
     8.019    24.745     0.200
     8.019    25.202     0.200
     8.055    21.520     0.200
     8.055    21.848     0.200
     8.084    22.288     0.200
     8.021    23.521     0.200
     8.188    22.270     0.200
     8.208    24.838     0.200
     8.255    21.985     0.200
     8.264    22.685     0.200
     8.305    21.905     0.200
     8.299    23.273     0.200
     8.259    21.840     0.200
     8.306    25.294     0.200
     8.323    24.689     0.200
     8.406    22.126     0.200
     8.345    23.042     0.200
     8.402    25.678     0.200
     8.415    25.218     0.200
     8.409    25.294     0.200
     8.455    25.154     0.200
     8.443    24.290     0.200
     8.524    22.448     0.200
     8.519    24.909     0.200
     8.570    22.115     0.200
     8.596    22.714     0.200
     8.604    21.888     0.200
     8.604    21.915     0.200
     8.641    22.386     0.200
     8.600    26.491     0.200
     8.614    25.320     0.200
     8.672    22.120     0.200
     8.656    24.710     0.200
     8.656    26.546     0.200
     8.656    24.511     0.200
     8.678    23.554     0.200
     8.698    26.219     0.200
     8.698    25.777     0.200
     8.777    22.596     0.200
     8.754    24.667     0.200
     8.832    24.459     0.200
     8.829    24.397     0.200
     8.848    26.038     0.200
     8.844    25.522     0.200
     8.952    24.260     0.200
     8.920    25.579     0.200
     8.997    27.036     0.200
     9.010    26.782     0.200
     9.018    26.685     0.200
     9.051    24.804     0.200
     9.072    27.559     0.200
     9.121    25.188     0.200
     9.093    27.626     0.200
     9.137    24.002     0.200
     9.138    27.121     0.200
     9.179    24.211     0.200
     9.161    26.162     0.200
     9.157    24.364     0.200
     9.245    24.738     0.200
     9.220    27.491     0.200
     9.274    23.903     0.200
     9.262    24.137     0.200
     9.237    26.352     0.200
     9.271    26.036     0.200
     9.299    28.005     0.200
     9.299    26.943     0.200
     9.299    27.888     0.200
     9.328    26.963     0.200
     9.336    27.076     0.200
     9.462    24.206     0.200
     9.462    24.408     0.200
     9.443    27.835     0.200
     9.489    24.323     0.200
     9.489    25.272     0.200
     9.536    26.344     0.200
     9.600    25.795     0.200
     9.577    28.264     0.200
     9.577    27.413     0.200
     9.566    27.296     0.200
     9.570    27.480     0.200
     9.641    25.718     0.200
     9.609    26.191     0.200
     9.609    26.926     0.200
     9.724    26.249     0.200
     9.774    26.362     0.200
     9.740    27.438     0.200
     9.755    26.188     0.200
     9.834    26.556     0.200
     9.800    28.394     0.200
     9.821    28.043     0.200
     9.878    28.651     0.200
     9.878    29.417     0.200
     9.885    29.363     0.200
     9.893    27.872     0.200
     9.968    26.601     0.200
     9.968    26.250     0.200
     9.949    27.717     0.200
     9.949    28.092     0.200
     9.928    28.529     0.200
     9.942    28.795     0.200
     9.979    28.165     0.200
    10.029    28.475     0.200
    10.060    29.530     0.200
    10.060    30.459     0.200
    10.112    27.222     0.200
    10.114    27.001     0.200
    10.124    31.014     0.200
    10.208    26.701     0.200
    10.163    29.079     0.200
    10.180    28.196     0.200
    10.218    28.182     0.200
    10.225    28.752     0.200
    10.204    29.124     0.200
    10.303    28.290     0.200
    10.274    29.730     0.200
    10.314    29.894     0.200
    10.381    27.578     0.200
    10.389    29.324     0.200
    10.393    29.437     0.200
    10.515    29.613     0.200
    10.607    27.340     0.200
    10.631    29.745     0.200
    10.678    29.215     0.200
    10.678    29.422     0.200
    10.757    31.195     0.200
    10.747    29.193     0.200
    10.763    30.249     0.200
    10.926    27.942     0.200
    11.001    30.847     0.200
    11.046    29.235     0.200
    11.094    30.819     0.200
    11.067    30.109     0.200
    11.176    28.226     0.200
    11.236    29.900     0.200
    11.258    30.239     0.200
    11.308    32.860     0.200
    11.482    30.428     0.200
    11.523    29.251     0.200
    11.687    31.482     0.200
    11.735    30.974     0.200
    11.757    30.723     0.200
    11.721    31.137     0.200
    11.942    31.960     0.200
    12.028    33.954     0.200
    12.574    31.684     0.200
    12.853    35.333     0.200
    12.908    31.789     0.200
    12.863    37.410     0.200
    13.810    34.762     0.200
    13.822    33.847     0.200
    13.822    33.320     0.200
    13.822    33.722     0.200
    13.877    33.882     0.200
    13.907    35.235     0.200
    13.907    34.755     0.200
    14.006    33.472     0.200
    14.082    33.196     0.200
    14.127    34.360     0.200
    14.122    33.306     0.200
    14.123    34.560     0.200
    14.350    34.264     0.200
    14.442    34.587     0.200
    14.414    35.638     0.200
    14.497    38.036     0.200
    14.673    37.689     0.200
    14.673    38.169     0.200
    14.673    37.801     0.200
    14.770    37.565     0.200
    15.433    36.717     0.200
    15.442    36.960     0.200
    15.578    38.896     0.200
    15.786    35.707     0.200
    15.841    37.066     0.200
    15.968    37.983     0.200
    16.122    37.428     0.200
    16.160    38.236     0.200
    16.309    37.154     0.200
    16.659    39.520     0.200
    16.810    37.897     0.200
    16.837    39.241     0.200
    16.877    39.577     0.200
    17.050    37.644     0.200
    17.435    39.419     0.200
    17.591    39.709     0.200
    18.134    39.507     0.200
    18.364    39.373     0.200
    18.528    39.902     0.200
    18.553    40.529     0.200
    18.626    41.381     0.200
    18.770    39.640     0.200
    18.733    40.409     0.200
    18.956    43.009     0.200
    19.157    45.164     0.200
    19.451    39.664     0.200
    19.451    40.632     0.200
    19.778    40.233     0.200
    19.793    40.408     0.200
    19.818    40.298     0.200
    19.792    39.950     0.200
    20.312    41.292     0.200
    20.312    42.581     0.200
    20.866    41.321     0.200
    20.858    40.116     0.200
    20.867    41.590     0.200
    20.867    40.203     0.200
    20.874    44.672     0.200
     1.467    10.329     0.200
     1.485     9.411     0.200
     1.497     8.235     0.200
     1.614    11.024     0.200
     1.607     9.069     0.200
     1.685     9.207     0.200
     1.687     9.200     0.200
     1.704    10.219     0.200
     1.809    10.350     0.200
     1.841     9.723     0.200
     2.053    10.835     0.200
     2.130     9.010     0.200
     2.163    10.575     0.200
     2.317    10.215     0.200
     2.302    11.149     0.200
     2.428    10.739     0.200
     2.510    12.158     0.200
     2.640    10.662     0.200
     2.642    10.640     0.200
     2.682    10.888     0.200
     2.818    14.122     0.200
     2.826    11.368     0.200
     2.826    12.329     0.200
     2.826    13.227     0.200
     2.847    14.279     0.200
     2.887    11.749     0.200
     2.982    12.681     0.200
     3.027    12.667     0.200
     3.189    12.184     0.200
     3.183    12.857     0.200
     3.187    12.311     0.200
     3.281    13.758     0.200
     3.386    13.392     0.200
     3.386    13.595     0.200
     3.432    13.059     0.200
     3.516    13.278     0.200
     3.588    15.242     0.200
     3.614    13.640     0.200
     3.618    13.787     0.200
     3.618    13.889     0.200
     3.626    13.593     0.200
     3.658    14.124     0.200
     3.724    14.154     0.200
     3.724    14.154     0.200
     3.760    14.931     0.200
     3.904    16.601     0.200
     3.906    14.926     0.200
     3.906    15.200     0.200
     3.937    14.569     0.200
     4.031    14.866     0.200
     4.064    14.889     0.200
     4.064    15.514     0.200
     4.115    15.656     0.200
     4.155    15.056     0.200
     4.133    15.778     0.200
     4.237    14.057     0.200
     4.256    15.437     0.200
     4.265    14.636     0.200
     4.289    15.094     0.200
     4.268    15.595     0.200
     4.301    15.524     0.200
     4.350    15.840     0.200
     4.393    15.838     0.200
     4.407    16.184     0.200
     4.495    15.749     0.200
     4.495    16.356     0.200
     4.541    15.155     0.200
     4.648    15.717     0.200
     4.656    16.177     0.200
     4.656    16.373     0.200
     4.877    16.397     0.200
     4.889    16.659     0.200
     4.957    16.436     0.200
     5.083    18.997     0.200
     5.121    16.266     0.200
     5.203    19.391     0.200
     5.275    18.009     0.200
     5.257    18.157     0.200
     5.306    16.834     0.200
     5.424    16.310     0.200
     5.541    17.943     0.200
     5.644    19.537     0.200
     5.694    16.672     0.200
     5.746    17.755     0.200
     5.747    19.566     0.200
     5.911    17.631     0.200
     6.004    18.936     0.200
     6.037    16.714     0.200
     6.176    17.933     0.200
     6.143    21.627     0.200
     6.207    17.676     0.200
     6.239    18.680     0.200
     6.229    20.219     0.200
     6.282    20.303     0.200
     6.297    20.089     0.200
     6.297    19.227     0.200
     6.330    22.040     0.200
     6.358    19.517     0.200
     6.425    21.015     0.200
     6.463    19.837     0.200
     6.438    21.269     0.200
     6.467    21.936     0.200
     6.549    18.279     0.200
     6.548    22.191     0.200
     6.557    21.389     0.200
     6.616    19.207     0.200
     6.649    20.451     0.200
     6.625    20.796     0.200
     6.751    21.477     0.200
     6.800    21.859     0.200
     6.881    20.810     0.200
     6.925    22.026     0.200
     6.956    19.232     0.200
     6.977    19.583     0.200
     6.962    21.067     0.200
     7.043    19.209     0.200
     7.069    21.909     0.200
     7.201    24.173     0.200
     7.192    22.105     0.200
     7.265    21.424     0.200
     7.257    21.147     0.200
     7.478    20.547     0.200
     7.589    23.746     0.200
     7.589    19.597     0.200
     7.592    22.233     0.200
     7.713    22.307     0.200
     7.752    22.442     0.200
     7.769    20.940     0.200
     7.795    23.746     0.200
     7.779    22.648     0.200
     7.895    23.886     0.200
     7.982    20.962     0.200
     8.062    21.598     0.200
     8.062    21.731     0.200
     8.258    22.530     0.200
     8.279    26.497     0.200
     8.306    22.973     0.200
     8.412    21.941     0.200
     8.531    22.652     0.200
     8.525    22.521     0.200
     8.615    24.881     0.200
     8.678    22.436     0.200
     8.663    26.039     0.200
     8.663    26.219     0.200
     8.701    25.784     0.200
     8.783    23.212     0.200
     8.839    24.665     0.200
     8.853    24.841     0.200
     9.141    26.304     0.200
     9.162    24.730     0.200
     9.269    24.643     0.200
     9.302    26.146     0.200
     9.302    28.818     0.200
     9.695    23.269     0.200
     9.882    28.324     0.200
     9.896    27.355     0.200
    10.200    29.885     0.200
    10.395    28.864     0.200
    14.123    34.117     0.200
    14.673    36.581     0.200
    18.623    42.696     0.200
     1.505     9.386     0.200
     1.785     9.667     0.200
     1.866    10.015     0.200
     1.872    10.283     0.200
     1.971    10.206     0.200
     2.188    11.768     0.200
     2.329    10.204     0.200
     2.432    10.058     0.200
     2.639    10.437     0.200
     2.696    11.267     0.200
     2.845    11.718     0.200
     2.845    12.398     0.200
     2.845    12.203     0.200
     2.900    12.011     0.200
     2.989    12.041     0.200
     3.047    12.855     0.200
     3.186    12.019     0.200
     3.203    13.311     0.200
     3.203    13.209     0.200
     3.209    12.452     0.200
     3.283    13.598     0.200
     3.406    13.452     0.200
     3.596    15.327     0.200
     3.641    14.007     0.200
     3.746    14.382     0.200
     3.746    14.187     0.200
     3.779    14.993     0.200
     3.914    15.122     0.200
     3.914    14.723     0.200
     3.914    14.106     0.200
     4.088    15.313     0.200
     4.154    14.426     0.200
     4.138    16.087     0.200
     4.274    15.610     0.200
     4.280    15.244     0.200
     4.280    15.447     0.200
     4.345    15.586     0.200
     4.345    15.688     0.200
     4.424    15.968     0.200
     4.424    16.366     0.200
     4.494    15.144     0.200
     4.512    16.934     0.200
     4.545    14.724     0.200
     4.760    16.651     0.200
     4.906    16.738     0.200
     5.117    17.164     0.200
     5.226    17.307     0.200
     5.268    16.581     0.200
     5.263    17.279     0.200
     5.302    16.253     0.200
     5.284    17.635     0.200
     5.438    16.532     0.200
     5.530    17.881     0.200
     5.673    18.691     0.200
     5.909    17.528     0.200
     5.909    17.646     0.200
     6.102    19.090     0.200
     6.203    19.381     0.200
     6.225    18.280     0.200
     6.269    17.943     0.200
     6.243    19.131     0.200
     6.315    18.915     0.200
     6.362    20.247     0.200
     6.458    19.588     0.200
     6.614    18.348     0.200
     6.648    20.756     0.200
     6.716    19.129     0.200
     6.914    23.238     0.200
     7.274    20.699     0.200
     7.471    20.429     0.200
     7.757    22.973     0.200
     9.321    25.691     0.200
     1.373     9.731     0.200
     1.377     9.106     0.200
     1.510     9.058     0.200
     1.519     8.166     0.200
     1.632     9.597     0.200
     1.713     7.765     0.200
     1.717     9.646     0.200
     1.791     9.814     0.200
     1.874     9.956     0.200
     1.879     9.792     0.200
     2.085    10.798     0.200
     2.194    11.612     0.200
     2.334    10.586     0.200
     2.333    11.695     0.200
     2.435    10.330     0.200
     2.552    13.320     0.200
     2.640    10.858     0.200
     2.648    10.853     0.200
     2.701    11.090     0.200
     2.846     9.113     0.200
     2.851    11.873     0.200
     2.851    12.053     0.200
     2.851    12.272     0.200
     2.905    11.711     0.200
     2.992    12.476     0.200
     3.054    12.568     0.200
     3.187    12.368     0.200
     3.210    12.961     0.200
     3.210    13.063     0.200
     3.216    12.498     0.200
     3.286    13.471     0.200
     3.412    13.604     0.200
     3.412    13.206     0.200
     3.461    13.430     0.200
     3.547    13.243     0.200
     3.544    13.355     0.200
     3.600    15.203     0.200
     3.641    14.033     0.200
     3.648    13.753     0.200
     3.648    13.855     0.200
     3.656    13.355     0.200
     3.685    13.816     0.200
     3.753    14.231     0.200
     3.753    14.130     0.200
     3.753    14.231     0.200
     3.785    14.646     0.200
     3.785    14.544     0.200
     3.918    15.305     0.200
     3.918    15.156     0.200
     3.918    15.734     0.200
     4.058    15.459     0.200
     4.096    15.127     0.200
     4.096    15.354     0.200
     4.155    14.678     0.200
     4.146    15.731     0.200
     4.158    14.896     0.200
     4.206    15.038     0.200
     4.281    15.664     0.200
     4.286    14.507     0.200
     4.286    14.703     0.200
     4.297    15.970     0.200
     4.328    15.910     0.200
     4.346    15.811     0.200
     4.430    15.829     0.200
     4.430    16.125     0.200
     4.496    15.152     0.200
     4.519    16.186     0.200
     4.548    15.270     0.200
     4.651    16.143     0.200
     4.651    16.432     0.200
     4.766    16.100     0.200
     4.912    16.794     0.200
     4.912    16.599     0.200
     5.117    16.380     0.200
     5.224    15.362     0.200
     5.232    16.964     0.200
     5.267    16.752     0.200
     5.269    17.432     0.200
     5.303    16.284     0.200
     5.291    17.283     0.200
     5.443    16.902     0.200
     5.528    17.907     0.200
     5.680    18.329     0.200
     5.707    15.819     0.200
     5.716    18.719     0.200
     5.738    17.475     0.200
     5.784    18.147     0.200
     5.830    17.486     0.200
     5.911    17.383     0.200
     6.046    17.855     0.200
     6.109    19.133     0.200
     6.145    18.109     0.200
     6.195    17.124     0.200
     6.201    19.998     0.200
     6.222    20.781     0.200
     6.250    19.086     0.200
     6.267    18.213     0.200
     6.283    20.398     0.200
     6.321    19.056     0.200
     6.369    19.996     0.200
     6.458    19.580     0.200
     6.520    20.629     0.200
     6.616    17.693     0.200
     6.633    21.862     0.200
     6.655    19.760     0.200
     6.655    20.518     0.200
     6.732    19.612     0.200
     6.721    19.089     0.200
     6.721    19.589     0.200
     6.909    21.938     0.200
     7.012    21.485     0.200
     7.172    22.424     0.200
     7.280    21.138     0.200
     7.471    20.612     0.200
     7.762    20.531     0.200
     7.759    22.471     0.200
     8.042    23.731     0.200
     8.300    23.253     0.200
     8.657    21.094     0.200
     8.665    25.476     0.200
     8.726    23.964     0.200
     8.760    20.597     0.200
     9.165    24.861     0.200
     9.327    27.243     0.200
     9.327    26.032     0.200
     9.902    27.244     0.200
     1.788    10.350     0.200
     1.742     9.712     0.200
     1.828     9.712     0.200
     2.144    11.518     0.200
     2.283    11.402     0.200
     2.332    10.342     0.200
     2.391    11.381     0.200
     2.375    11.524     0.200
     2.449    10.585     0.200
     2.664    10.181     0.200
     2.663    11.214     0.200
     2.694    11.372     0.200
     2.791    11.979     0.200
     2.832    12.021     0.200
     2.832    11.740     0.200
     2.832    11.890     0.200
     2.914    14.400     0.200
     3.000    12.170     0.200
     3.030    13.066     0.200
     3.182    12.098     0.200
     3.225    13.631     0.200
     3.214    12.441     0.200
     3.186    12.763     0.200
     3.187    12.445     0.200
     3.187    12.547     0.200
     3.303    13.741     0.200
     3.283    13.385     0.200
     3.293    11.791     0.200
     3.389    13.487     0.200
     3.430    13.216     0.200
     3.516    13.709     0.200
     3.583    13.892     0.200
     3.579    14.467     0.200
     3.605    15.374     0.200
     3.615    13.852     0.200
     3.615    13.859     0.200
     3.621    13.988     0.200
     3.699    14.573     0.200
     3.660    13.734     0.200
     3.722    14.274     0.200
     3.722    14.005     0.200
     3.722    14.105     0.200
     3.765    15.107     0.200
     3.877    17.692     0.200
     3.901    16.172     0.200
     3.945    17.148     0.200
     3.956    12.757     0.200
     3.924    14.792     0.200
     3.924    14.591     0.200
     3.963    14.135     0.200
     3.963    13.195     0.200
     4.137    15.163     0.200
     4.180    14.322     0.200
     4.198    13.933     0.200
     4.255    13.882     0.200
     4.262    15.100     0.200
     4.274    14.461     0.200
     4.267    15.047     0.200
     4.290    13.482     0.200
     4.313    14.934     0.200
     4.301    15.149     0.200
     4.377    15.164     0.200
     4.414    15.932     0.200
     4.492    14.725     0.200
     4.520    14.293     0.200
     4.562    15.023     0.200
     4.597    15.293     0.200
     4.671    15.136     0.200
     4.682    16.074     0.200
     4.682    15.606     0.200
     4.721    15.075     0.200
     4.772    17.635     0.200
     4.896    15.320     0.200
     4.887    15.507     0.200
     4.896    16.108     0.200
     4.967    16.713     0.200
     4.979    15.844     0.200
     5.115    15.942     0.200
     5.147    17.103     0.200
     5.147    16.611     0.200
     5.224    15.993     0.200
     5.233    16.806     0.200
     5.245    18.732     0.200
     5.302    17.274     0.200
     5.331    16.423     0.200
     5.370    15.968     0.200
     5.436    15.604     0.200
     5.569    17.585     0.200
     5.680    18.334     0.200
     5.712    16.885     0.200
     5.768    17.234     0.200
     5.774    18.992     0.200
     5.774    17.712     0.200
     5.847    17.972     0.200
     5.795    21.199     0.200
     5.936    17.681     0.200
     5.936    17.304     0.200
     5.994    19.097     0.200
     6.073    19.509     0.200
     6.090    18.735     0.200
     6.196    17.535     0.200
     6.226    17.386     0.200
     6.244    20.792     0.200
     6.244    20.618     0.200
     6.267    19.417     0.200
     6.214    20.322     0.200
     6.311    19.610     0.200
     6.325    20.150     0.200
     6.350    19.906     0.200
     6.304    19.209     0.200
     6.453    19.918     0.200
     6.488    19.746     0.200
     6.490    20.193     0.200
     6.490    19.971     0.200
     6.449    21.283     0.200
     6.449    21.783     0.200
     6.469    20.848     0.200
     6.572    21.841     0.200
     6.568    19.589     0.200
     6.640    18.811     0.200
     6.677    21.162     0.200
     6.621    20.773     0.200
     6.621    20.493     0.200
     6.621    21.074     0.200
     6.710    19.833     0.200
     6.764    22.063     0.200
     6.779    22.930     0.200
     6.779    22.368     0.200
     6.789    20.541     0.200
     6.865    21.329     0.200
     6.910    21.878     0.200
     6.910    22.804     0.200
     7.002    19.631     0.200
     6.950    21.429     0.200
     7.048    23.171     0.200
     7.064    19.908     0.200
     7.085    19.863     0.200
     7.127    22.271     0.200
     7.224    24.439     0.200
     7.196    22.365     0.200
     7.264    21.266     0.200
     7.288    19.087     0.200
     7.319    22.530     0.200
     7.452    21.676     0.200
     7.505    20.993     0.200
     7.505    20.842     0.200
     7.505    20.262     0.200
     7.514    22.348     0.200
     7.607    21.063     0.200
     7.600    22.046     0.200
     7.684    23.670     0.200
     7.689    23.307     0.200
     7.772    21.936     0.200
     7.796    21.156     0.200
     7.796    20.757     0.200
     7.773    23.372     0.200
     7.778    23.922     0.200
     7.819    22.293     0.200
     7.830    22.166     0.200
     7.865    22.116     0.200
     7.979    20.824     0.200
     7.966    22.776     0.200
     8.035    24.176     0.200
     8.086    24.078     0.200
     8.086    22.898     0.200
     8.086    21.879     0.200
     8.222    23.489     0.200
     8.278    22.036     0.200
     8.215    22.973     0.200
     8.215    22.673     0.200
     8.297    24.317     0.200
     8.328    23.577     0.200
     8.335    23.670     0.200
     8.439    21.857     0.200
     8.411    25.119     0.200
     8.469    24.504     0.200
     8.545    24.117     0.200
     8.629    22.440     0.200
     8.612    24.439     0.200
     8.631    25.622     0.200
     8.706    22.245     0.200
     8.686    25.276     0.200
     8.686    24.977     0.200
     8.686    24.106     0.200
     8.706    25.240     0.200
     8.810    22.429     0.200
     8.743    24.206     0.200
     8.743    24.505     0.200
     8.863    23.312     0.200
     8.956    25.524     0.200
     9.035    27.399     0.200
     9.082    25.451     0.200
     9.107    25.668     0.200
     9.133    26.362     0.200
     9.125    24.352     0.200
     9.148    25.967     0.200
     9.143    24.943     0.200
     9.161    25.656     0.200
     9.203    25.137     0.200
     9.225    26.683     0.200
     9.293    23.089     0.200
     9.277    24.985     0.200
     9.294    23.679     0.200
     9.307    26.934     0.200
     9.307    26.479     0.200
     9.307    26.694     0.200
     9.297    27.252     0.200
     9.358    26.836     0.200
     9.358    25.329     0.200
     9.453    27.143     0.200
     9.522    24.267     0.200
     9.567    28.092     0.200
     9.604    27.262     0.200
     9.586    27.176     0.200
     9.748    24.282     0.200
     9.759    25.951     0.200
     9.794    26.947     0.200
     9.892    28.496     0.200
     9.900    27.996     0.200
     9.901    27.298     0.200
     9.957    27.343     0.200
     9.957    28.544     0.200
    10.002    26.719     0.200
    10.002    26.158     0.200
     9.950    25.525     0.200
    10.041    28.345     0.200
    10.177    28.361     0.200
    10.396    28.815     0.200
    10.680    29.007     0.200
    10.680    28.818     0.200
    10.751    29.313     0.200
    10.778    31.165     0.200
    12.329    32.865     0.200
    13.064    34.390     0.200
    13.839    33.436     0.200
    13.839    33.838     0.200
    14.133    34.330     0.200
    14.662    37.430     0.200
    18.168    39.451     0.200
    18.605    42.499     0.200
    18.796    39.890     0.200
    20.875    42.930     0.200
    20.937    41.507     0.200
     1.749     9.967     0.200
     1.833     9.682     0.200
     2.151    10.968     0.200
     2.290    11.151     0.200
     2.327    10.369     0.200
     2.382    11.377     0.200
     2.442    10.701     0.200
     2.656    10.850     0.200
     2.656    11.020     0.200
     2.690    11.248     0.200
     2.831    12.309     0.200
     2.831    11.640     0.200
     2.994    12.425     0.200
     3.029    12.943     0.200
     3.185    12.799     0.200
     3.188    12.672     0.200
     3.205    12.777     0.200
     3.296    13.903     0.200
     3.389    13.427     0.200
     3.431    13.233     0.200
     3.517    13.734     0.200
     3.599    15.072     0.200
     3.615    13.983     0.200
     3.616    13.371     0.200
     3.616    14.072     0.200
     3.623    13.792     0.200
     3.660    14.266     0.200
     3.723    14.124     0.200
     3.723    14.024     0.200
     3.764    15.052     0.200
     3.918    14.853     0.200
     3.954    16.135     0.200
     4.136    14.905     0.200
     4.171    14.604     0.200
     4.249    14.492     0.200
     4.261    15.250     0.200
     4.271    14.726     0.200
     4.268    15.566     0.200
     4.301    15.577     0.200
     4.301    15.876     0.200
     4.368    15.103     0.200
     4.412    15.888     0.200
     4.511    15.225     0.200
     4.673    16.043     0.200
     4.776    17.556     0.200
     4.884    15.476     0.200
     4.894    16.263     0.200
     5.138    17.120     0.200
     5.252    18.092     0.200
     5.293    16.848     0.200
     5.322    15.807     0.200
     5.432    16.079     0.200
     5.559    18.676     0.200
     5.706    16.584     0.200
     5.760    18.458     0.200
     5.765    19.576     0.200
     5.798    21.243     0.200
     5.928    17.702     0.200
     6.094    18.744     0.200
     6.188    18.054     0.200
     6.219    17.802     0.200
     6.234    21.788     0.200
     6.257    21.017     0.200
     6.302    19.446     0.200
     6.340    20.380     0.200
     6.481    18.763     0.200
     6.472    20.945     0.200
     6.564    19.772     0.200
     6.632    18.963     0.200
     6.623    21.048     0.200
     6.623    21.183     0.200
     6.707    19.662     0.200
     6.787    20.178     0.200
     6.915    21.679     0.200
     6.971    20.918     0.200
     6.954    21.521     0.200
     6.993    20.667     0.200
     7.262    21.268     0.200
     7.280    20.111     0.200
     7.495    20.529     0.200
     7.692    23.302     0.200
     7.765    21.950     0.200
     7.787    20.698     0.200
     7.822    22.788     0.200
     7.971    22.149     0.200
     8.031    23.660     0.200
     8.614    25.195     0.200
     8.678    26.223     0.200
     8.678    24.602     0.200
     8.705    25.866     0.200
     9.104    26.433     0.200
     9.146    26.436     0.200
     9.162    26.442     0.200
     9.305    26.849     0.200
     9.305    27.067     0.200
     9.451    26.622     0.200
     9.889    28.132     0.200
     9.992    27.362     0.200
    10.038    28.158     0.200
    14.129    34.533     0.200
    14.667    36.271     0.200
     1.438     8.230     0.200
     1.470     8.271     0.200
     1.473     9.983     0.200
     1.543     9.090     0.200
     1.605     9.589     0.200
     1.613    10.078     0.200
     4.852    17.198     0.200
     5.276    16.659     0.200
     5.837    17.768     0.200
     5.982    18.829     0.200
     6.342    20.910     0.200
     6.546    22.291     0.200
     6.628    19.843     0.200
     6.630    19.700     0.200
     6.684    20.604     0.200
     6.782    20.967     0.200
     6.817    21.764     0.200
     7.014    21.637     0.200
     7.647    24.378     0.200
     7.963    20.785     0.200
     8.512    21.478     0.200
     8.890    21.869     0.200
     9.128    22.394     0.200
     9.266    22.584     0.200
    10.241    24.007     0.200
     1.465     8.922     0.200
     1.521     8.735     0.200
     1.556    10.153     0.200
     1.514     8.723     0.200
     1.553     9.042     0.200
     1.554     9.186     0.200
     1.562     9.280     0.200
     1.648    10.065     0.200
     1.626     9.442     0.200
     1.688    10.553     0.200
     1.695     9.036     0.200
     1.653     9.438     0.200
     1.701    10.718     0.200
     1.665     9.343     0.200
     1.680     9.495     0.200
     1.781    10.644     0.200
     1.781    10.976     0.200
     1.736     9.571     0.200
     1.825    10.314     0.200
     1.824     9.787     0.200
     1.929    10.200     0.200
     2.124    11.005     0.200
     2.102    11.081     0.200
     2.107    10.536     0.200
     2.162    10.696     0.200
     2.337    11.527     0.200
     2.337    10.653     0.200
     2.388    12.180     0.200
     2.440    12.286     0.200
     2.522    11.958     0.200
     2.524    11.182     0.200
     2.524    12.478     0.200
     2.531    12.464     0.200
     2.544    11.690     0.200
     2.562    11.978     0.200
     2.566    12.288     0.200
     2.596    12.717     0.200
     2.672    12.878     0.200
     2.707    12.038     0.200
     2.707    11.839     0.200
     2.752    12.852     0.200
     2.726    12.515     0.200
     2.726    11.917     0.200
     2.867    13.177     0.200
     2.867    12.951     0.200
     2.937    13.129     0.200
     2.905    12.626     0.200
     2.905    12.227     0.200
     2.949    12.636     0.200
     2.984    12.906     0.200
     3.054    13.084     0.200
     3.141    13.522     0.200
     3.111    12.865     0.200
     3.182    14.875     0.200
     3.142    13.259     0.200
     3.185    13.158     0.200
     3.185    13.561     0.200
     3.236    12.804     0.200
     3.236    12.503     0.200
     3.241    13.651     0.200
     3.204    13.435     0.200
     3.296    13.234     0.200
     3.296    15.425     0.200
     3.274    13.217     0.200
     3.274    14.018     0.200
     3.271    14.550     0.200
     3.271    13.699     0.200
     3.271    14.808     0.200
     3.271    13.449     0.200
     3.271    13.550     0.200
     3.324    14.161     0.200
     3.326    14.207     0.200
     3.446    14.803     0.200
     3.446    14.604     0.200
     3.461    13.352     0.200
     3.526    14.156     0.200
     3.637    13.378     0.200
     3.642    13.955     0.200
     3.648    14.755     0.200
     3.648    14.158     0.200
     3.657    15.055     0.200
     3.706    15.840     0.200
     3.678    15.626     0.200
     3.731    15.028     0.200
     3.691    15.411     0.200
     3.691    14.846     0.200
     3.691    14.545     0.200
     3.748    16.544     0.200
     3.766    15.275     0.200
     3.771    14.520     0.200
     3.771    14.223     0.200
     3.804    14.568     0.200
     3.814    14.817     0.200
     3.834    14.987     0.200
     3.834    16.187     0.200
     3.830    14.820     0.200
     3.881    15.599     0.200
     3.881    15.759     0.200
     3.904    13.583     0.200
     3.946    17.071     0.200
     3.914    15.648     0.200
     3.914    15.051     0.200
     3.967    15.736     0.200
     4.034    15.448     0.200
     4.034    16.171     0.200
     4.000    17.943     0.200
     4.015    16.874     0.200
     4.015    17.155     0.200
     4.014    16.484     0.200
     4.014    15.984     0.200
     4.053    14.128     0.200
     4.098    14.100     0.200
     4.136    14.461     0.200
     4.166    15.590     0.200
     4.171    15.537     0.200
     4.171    15.678     0.200
     4.187    15.363     0.200
     4.187    15.160     0.200
     4.181    17.386     0.200
     4.173    15.633     0.200
     4.196    19.155     0.200
     4.262    15.177     0.200
     4.242    18.921     0.200
     4.288    14.731     0.200
     4.309    16.161     0.200
     4.320    18.194     0.200
     4.351    14.955     0.200
     4.351    15.635     0.200
     4.337    18.776     0.200
     4.372    14.842     0.200
     4.372    14.713     0.200
     4.384    16.660     0.200
     4.388    14.573     0.200
     4.383    16.671     0.200
     4.383    14.972     0.200
     4.396    16.820     0.200
     4.396    15.421     0.200
     4.396    15.628     0.200
     4.423    17.131     0.200
     4.423    17.010     0.200
     4.521    15.766     0.200
     4.521    16.567     0.200
     4.521    15.329     0.200
     4.575    17.144     0.200
     4.597    11.850     0.200
     4.597    17.021     0.200
     4.607    19.995     0.200
     4.621    16.401     0.200
     4.676    15.340     0.200
     4.712    14.948     0.200
     4.717    16.682     0.200
     4.757    15.468     0.200
     4.775    16.856     0.200
     4.775    19.473     0.200
     4.757    16.807     0.200
     4.794    15.705     0.200
     4.794    15.252     0.200
     4.814    16.154     0.200
     4.794    16.581     0.200
     4.838    15.434     0.200
     4.838    15.204     0.200
     4.832    16.199     0.200
     4.843    15.362     0.200
     4.850    15.360     0.200
     4.840    18.243     0.200
     4.939    16.485     0.200
     4.955    16.546     0.200
     4.962    15.919     0.200
     4.962    16.298     0.200
     4.933    16.060     0.200
     4.933    15.458     0.200
     4.916    17.958     0.200
     4.973    16.214     0.200
     5.017    16.585     0.200
     5.064    18.734     0.200
     5.066    18.663     0.200
     5.060    16.054     0.200
     5.071    16.553     0.200
     5.071    16.190     0.200
     5.139    15.652     0.200
     5.139    16.633     0.200
     5.143    15.921     0.200
     5.145    18.476     0.200
     5.206    18.531     0.200
     5.343    16.744     0.200
     5.327    17.259     0.200
     5.412    16.848     0.200
     5.416    18.233     0.200
     5.481    17.817     0.200
     5.502    18.749     0.200
     5.498    17.454     0.200
     5.498    17.958     0.200
     5.498    17.560     0.200
     5.560    17.423     0.200
     5.560    17.252     0.200
     5.560    17.650     0.200
     5.576    16.757     0.200
     5.638    17.999     0.200
     5.667    17.688     0.200
     5.642    18.381     0.200
     5.806    19.575     0.200
     5.813    18.324     0.200
     5.768    19.698     0.200
     5.805    18.466     0.200
     5.850    19.713     0.200
     5.909    20.365     0.200
     5.879    19.920     0.200
     5.950    18.489     0.200
     5.967    19.376     0.200
     5.967    19.044     0.200
     5.918    19.363     0.200
     6.014    17.392     0.200
     5.983    19.301     0.200
     6.085    20.013     0.200
     6.120    17.845     0.200
     6.123    18.971     0.200
     6.131    19.874     0.200
     6.137    19.130     0.200
     6.166    19.492     0.200
     6.206    19.998     0.200
     6.206    20.478     0.200
     6.206    20.197     0.200
     6.254    19.544     0.200
     6.254    20.856     0.200
     6.187    20.620     0.200
     6.256    19.213     0.200
     6.226    21.369     0.200
     6.280    19.782     0.200
     6.319    21.082     0.200
     6.292    20.188     0.200
     6.378    20.189     0.200
     6.461    19.220     0.200
     6.479    17.573     0.200
     6.515    19.995     0.200
     6.509    20.170     0.200
     6.571    18.773     0.200
     6.555    20.728     0.200
     6.555    20.627     0.200
     6.662    21.421     0.200
     6.662    21.288     0.200
     6.671    19.040     0.200
     6.677    21.895     0.200
     6.665    19.737     0.200
     6.709    20.533     0.200
     6.706    22.153     0.200
     6.764    21.334     0.200
     6.866    18.892     0.200
     6.841    20.295     0.200
     6.906    21.231     0.200
     6.907    20.290     0.200
     6.980    21.530     0.200
     7.068    20.835     0.200
     7.068    21.437     0.200
     7.026    20.131     0.200
     7.089    20.994     0.200
     7.089    20.592     0.200
     7.098    22.097     0.200
     7.131    19.210     0.200
     7.197    19.968     0.200
     7.197    20.483     0.200
     7.197    20.382     0.200
     7.227    21.662     0.200
     7.270    21.986     0.200
     7.289    21.660     0.200
     7.272    23.259     0.200
     7.319    21.914     0.200
     7.367    22.549     0.200
     7.367    23.952     0.200
     7.404    22.222     0.200
     7.407    25.509     0.200
     7.407    21.935     0.200
     7.426    22.561     0.200
     7.403    24.264     0.200
     7.492    20.496     0.200
     7.492    20.945     0.200
     7.531    23.943     0.200
     7.531    25.037     0.200
     7.585    20.813     0.200
     7.585    20.125     0.200
     7.613    21.382     0.200
     7.690    22.728     0.200
     7.690    24.451     0.200
     7.690    22.486     0.200
     7.819    24.975     0.200
     7.917    24.507     0.200
     8.012    21.425     0.200
     8.051    21.669     0.200
     8.051    22.469     0.200
     8.089    25.528     0.200
     8.123    21.227     0.200
     8.123    21.981     0.200
     8.147    23.451     0.200
     8.147    24.353     0.200
     8.156    21.340     0.200
     8.213    25.124     0.200
     8.213    26.175     0.200
     8.271    24.720     0.200
     8.271    23.798     0.200
     8.271    23.599     0.200
     8.292    21.324     0.200
     8.291    22.064     0.200
     8.381    23.317     0.200
     8.406    21.631     0.200
     8.406    21.831     0.200
     8.377    23.862     0.200
     8.498    24.356     0.200
     8.545    22.507     0.200
     8.525    28.334     0.200
     8.636    22.638     0.200
     8.636    22.537     0.200
     8.641    26.182     0.200
     8.650    26.401     0.200
     8.699    25.608     0.200
     8.709    22.886     0.200
     8.783    22.230     0.200
     8.816    27.239     0.200
     8.816    26.621     0.200
     8.918    25.949     0.200
     9.187    27.514     0.200
     9.199    23.588     0.200
     9.240    24.401     0.200
     9.240    22.940     0.200
     9.397    23.568     0.200
     9.397    23.865     0.200
     9.389    27.553     0.200
     9.396    27.822     0.200
     9.392    25.322     0.200
     9.409    27.440     0.200
     9.462    25.506     0.200
     9.465    26.472     0.200
     9.465    27.972     0.200
     9.559    25.964     0.200
     9.539    28.071     0.200
     9.577    23.856     0.200
     9.651    25.105     0.200
     9.651    24.976     0.200
     9.692    24.422     0.200
     9.692    24.723     0.200
     9.702    25.506     0.200
     9.702    25.193     0.200
     9.761    24.618     0.200
     9.762    24.704     0.200
     9.762    25.602     0.200
     9.740    26.331     0.200
     9.740    25.565     0.200
     9.797    24.398     0.200
     9.798    25.176     0.200
     9.943    27.993     0.200
     9.943    27.293     0.200
     9.973    26.037     0.200
    10.069    26.430     0.200
    10.185    29.193     0.200
    10.271    28.164     0.200
    10.301    29.062     0.200
    10.415    28.378     0.200
    10.415    28.279     0.200
    10.861    28.677     0.200
    10.969    30.413     0.200
    11.219    29.700     0.200
    11.219    30.598     0.200
    11.566    29.144     0.200
    13.337    34.182     0.200
    14.280    35.276     0.200
    14.299    34.760     0.200
    14.299    37.509     0.200
    14.510    36.542     0.200
    18.347    38.312     0.200
    18.471    39.835     0.200
    19.499    39.576     0.200
    20.417    42.063     0.200
    20.584    40.391     0.200
    20.584    40.813     0.200
     1.262     7.346     0.200
     1.272     7.335     0.200
     1.300     7.239     0.200
     1.276     7.386     0.200
     1.412     8.858     0.200
     1.448     7.759     0.200
     1.495     8.360     0.200
     1.479     8.460     0.200
     1.510     8.186     0.200
     1.528     8.066     0.200
     1.588     8.098     0.200
     1.626     8.819     0.200
     1.621     8.573     0.200
     1.616     8.303     0.200
     1.630     8.416     0.200
     1.658     9.046     0.200
     1.815     7.945     0.200
     1.806     9.542     0.200
     1.899     8.847     0.200
     1.955     9.275     0.200
     2.031     9.407     0.200
     2.059     9.959     0.200
     2.114     9.491     0.200
     2.117    10.170     0.200
     2.168    10.528     0.200
     2.235     9.462     0.200
     2.417     9.792     0.200
     2.432    10.323     0.200
     2.432    11.323     0.200
     2.618    11.546     0.200
     2.618    11.648     0.200
     2.689    11.825     0.200
     2.760    11.887     0.200
     2.851    12.135     0.200
     2.885    12.234     0.200
     2.894    12.231     0.200
     2.936    13.742     0.200
     2.911    11.631     0.200
     2.977    12.721     0.200
     2.977    12.467     0.200
     2.992    12.390     0.200
     3.266    13.485     0.200
     3.269    13.049     0.200
     3.364    13.241     0.200
     3.397    13.593     0.200
     3.435    15.320     0.200
     3.513    13.603     0.200
     3.519    13.735     0.200
     3.541    13.680     0.200
     3.643    13.986     0.200
     3.807    14.678     0.200
     3.902    12.270     0.200
     3.977    12.850     0.200
     3.949    14.113     0.200
     4.028    15.900     0.200
     3.996    14.670     0.200
     3.996    14.920     0.200
     4.059    14.137     0.200
     4.125    14.668     0.200
     4.163    14.244     0.200
     4.144    15.937     0.200
     4.230    13.119     0.200
     4.344    18.454     0.200
     4.399    14.384     0.200
     4.394    15.424     0.200
     4.435    14.337     0.200
     4.509    16.982     0.200
     4.642    15.836     0.200
     4.732    14.712     0.200
     4.777    14.511     0.200
     4.789    16.311     0.200
     4.812    17.943     0.200
     4.916    14.975     0.200
     4.901    17.607     0.200
     5.016    15.617     0.200
     5.028    16.723     0.200
     5.043    16.456     0.200
     5.112    18.722     0.200
     5.132    16.615     0.200
     5.220    16.582     0.200
     5.231    16.261     0.200
     5.247    16.766     0.200
     5.382    15.667     0.200
     5.386    16.951     0.200
     5.426    16.777     0.200
     5.503    16.500     0.200
     5.520    18.086     0.200
     5.637    16.722     0.200
     5.653    18.028     0.200
     5.675    18.471     0.200
     5.692    19.274     0.200
     5.892    18.111     0.200
     5.950    21.222     0.200
     5.942    19.854     0.200
     5.982    19.000     0.200
     5.988    19.323     0.200
     6.017    20.318     0.200
     6.105    19.680     0.200
     6.132    17.783     0.200
     6.172    17.538     0.200
     6.188    18.911     0.200
     6.206    18.610     0.200
     6.211    17.835     0.200
     6.170    19.996     0.200
     6.197    19.286     0.200
     6.199    21.064     0.200
     6.350    19.272     0.200
     6.369    19.221     0.200
     6.411    20.087     0.200
     6.430    18.864     0.200
     6.473    21.166     0.200
     6.494    20.384     0.200
     6.477    19.816     0.200
     6.591    19.241     0.200
     6.745    21.486     0.200
     6.764    19.946     0.200
     6.841    19.973     0.200
     6.931    18.318     0.200
     6.931    22.517     0.200
     6.938    19.534     0.200
     7.092    18.837     0.200
     7.174    19.005     0.200
     7.162    20.517     0.200
     7.271    19.754     0.200
     7.291    19.416     0.200
     7.285    25.020     0.200
     7.470    19.330     0.200
     7.591    19.716     0.200
     7.637    23.802     0.200
     7.638    24.162     0.200
     7.933    24.209     0.200
     8.107    24.099     0.200
     8.137    23.543     0.200
     8.232    20.235     0.200
     8.549    20.735     0.200
     8.534    24.418     0.200
     8.550    23.526     0.200
     8.761    21.965     0.200
     8.929    21.803     0.200
     9.102    28.176     0.200
     9.184    26.005     0.200
     9.597    22.905     0.200
     9.604    22.923     0.200
     9.735    23.398     0.200
     9.879    24.311     0.200
     9.876    25.478     0.200
     9.963    24.239     0.200
     9.991    24.004     0.200
    10.182    24.779     0.200
     1.465     8.066     0.200
     1.481     9.010     0.200
     1.488     9.970     0.200
     1.550     8.804     0.200
     2.273    10.536     0.200
     2.442    11.122     0.200
     4.383    14.059     0.200
     4.717    14.733     0.200
     4.760    14.953     0.200
     4.788    16.109     0.200
     4.865    14.275     0.200
     4.899    15.088     0.200
     4.956    14.349     0.200
     5.000    16.713     0.200
     5.193    15.818     0.200
     5.257    14.769     0.200
     5.366    16.530     0.200
     5.486    17.431     0.200
     5.519    16.257     0.200
     5.673    17.101     0.200
     5.730    16.927     0.200
     5.869    18.275     0.200
     6.090    18.874     0.200
     6.115    18.077     0.200
     6.173    19.124     0.200
     6.197    18.790     0.200
     7.512    25.010     0.200
     8.223    20.022     0.200
     8.538    20.547     0.200
     8.748    22.088     0.200
     8.917    21.914     0.200
     9.870    23.598     0.200
     0.923     6.575     0.200
     1.017     7.028     0.200
     1.044     7.075     0.200
     1.212     7.873     0.200
     1.234     8.466     0.200
     1.723     9.151     0.200
     1.989     9.275     0.200
     2.199     8.989     0.200
     2.431    11.191     0.200
     2.431    11.062     0.200
     2.483     9.682     0.200
     2.705    11.441     0.200
     2.775    11.873     0.200
     2.776    11.666     0.200
     2.981    12.169     0.200
     3.056    11.202     0.200
     3.205    12.553     0.200
     3.245    11.521     0.200
     3.311    12.825     0.200
     3.359    13.756     0.200
     3.615    15.569     0.200
     3.771    14.554     0.200
     3.861    14.399     0.200
     3.890    13.867     0.200
     4.018    14.676     0.200
     4.075    15.310     0.200
     4.141    15.739     0.200
     4.300    14.794     0.200
     4.393    17.051     0.200
     4.499    14.761     0.200
     4.715    17.839     0.200
     4.742    14.823     0.200
     5.084    18.437     0.200
     5.100    17.750     0.200
     5.121    17.800     0.200
     5.127    17.734     0.200
     5.215    18.004     0.200
     5.273    18.134     0.200
     5.280    18.142     0.200
     5.443    18.045     0.200
     5.480    18.615     0.200
     5.692    19.138     0.200
     5.825    19.587     0.200
     6.003    20.404     0.200
     6.138    20.331     0.200
     6.138    20.334     0.200
     6.509    21.000     0.200
     7.394    18.940     0.200
     7.498    22.765     0.200
     9.942    27.311     0.200
     1.664    10.483     0.200
     1.793    10.542     0.200
     1.792    10.746     0.200
     1.873    11.733     0.200
     1.884    10.768     0.200
     1.891    10.370     0.200
     1.975    10.559     0.200
     2.075    10.569     0.200
     2.115    10.729     0.200
     2.240    10.797     0.200
     2.242    10.815     0.200
     2.277    12.025     0.200
     2.455    11.015     0.200
     2.471    10.779     0.200
     2.480    12.058     0.200
     2.531    12.676     0.200
     2.632    12.743     0.200
     2.696    13.578     0.200
     2.684    12.180     0.200
     2.785    12.002     0.200
     2.837    13.637     0.200
     2.857    14.845     0.200
     2.857    14.634     0.200
     2.948    13.737     0.200
     2.997    13.442     0.200
     2.997    13.637     0.200
     3.028    12.330     0.200
     3.010    13.299     0.200
     3.010    13.697     0.200
     3.076    13.327     0.200
     3.076    12.960     0.200
     3.035    14.085     0.200
     3.099    13.327     0.200
     3.190    14.236     0.200
     3.201    14.748     0.200
     3.212    12.762     0.200
     3.197    14.804     0.200
     3.197    14.109     0.200
     3.260    15.521     0.200
     3.261    14.161     0.200
     3.250    13.296     0.200
     3.250    13.961     0.200
     3.338    14.360     0.200
     3.389    16.275     0.200
     3.415    13.793     0.200
     3.429    13.712     0.200
     3.413    14.087     0.200
     3.431    14.581     0.200
     3.482    15.751     0.200
     3.452    14.533     0.200
     3.452    14.635     0.200
     3.468    14.647     0.200
     3.474    14.676     0.200
     3.515    14.015     0.200
     3.551    15.037     0.200
     3.551    15.178     0.200
     3.551    15.693     0.200
     3.551    14.857     0.200
     3.551    14.881     0.200
     3.568    16.177     0.200
     3.568    14.880     0.200
     3.708    14.843     0.200
     3.708    17.569     0.200
     3.708    16.749     0.200
     3.755    16.800     0.200
     3.787    14.936     0.200
     3.783    16.562     0.200
     3.844    15.666     0.200
     3.823    16.444     0.200
     3.823    15.022     0.200
     3.849    15.502     0.200
     3.892    18.099     0.200
     3.929    16.539     0.200
     3.929    16.765     0.200
     3.929    15.625     0.200
     3.929    16.070     0.200
     3.942    15.718     0.200
     4.062    15.719     0.200
     4.059    18.809     0.200
     4.119    15.178     0.200
     4.095    16.035     0.200
     4.120    16.134     0.200
     4.128    17.454     0.200
     4.202    15.984     0.200
     4.209    16.196     0.200
     4.209    16.993     0.200
     4.323    16.070     0.200
     4.327    15.726     0.200
     4.306    17.278     0.200
     4.315    17.413     0.200
     4.353    16.409     0.200
     4.391    14.538     0.200
     4.397    16.411     0.200
     4.418    15.929     0.200
     4.395    16.635     0.200
     4.395    16.775     0.200
     4.471    16.060     0.200
     4.505    16.348     0.200
     4.505    16.715     0.200
     4.502    12.958     0.200
     4.502    14.177     0.200
     4.550    16.928     0.200
     4.677    16.495     0.200
     4.654    17.976     0.200
     4.692    17.066     0.200
     4.692    17.168     0.200
     4.692    16.363     0.200
     4.729    16.773     0.200
     4.725    18.474     0.200
     4.725    18.755     0.200
     4.732    18.497     0.200
     4.775    16.169     0.200
     4.805    15.389     0.200
     4.775    17.804     0.200
     4.857    17.244     0.200
     4.970    16.841     0.200
     4.970    17.107     0.200
     5.002    15.649     0.200
     5.012    17.313     0.200
     4.976    19.350     0.200
     5.012    17.827     0.200
     5.043    17.581     0.200
     5.058    17.838     0.200
     5.058    16.424     0.200
     5.052    17.865     0.200
     5.082    18.221     0.200
     5.115    19.701     0.200
     5.101    18.606     0.200
     5.140    16.577     0.200
     5.141    18.148     0.200
     5.146    16.646     0.200
     5.137    18.768     0.200
     5.137    18.292     0.200
     5.190    17.855     0.200
     5.222    17.332     0.200
     5.222    17.175     0.200
     5.222    17.480     0.200
     5.268    17.803     0.200
     5.343    19.973     0.200
     5.429    17.339     0.200
     5.496    18.871     0.200
     5.496    17.684     0.200
     5.537    19.604     0.200
     5.617    20.316     0.200
     5.617    20.144     0.200
     5.746    18.210     0.200
     5.746    18.319     0.200
     5.798    18.959     0.200
     5.771    20.073     0.200
     5.876    19.144     0.200
     5.915    19.592     0.200
     5.949    20.390     0.200
     5.962    19.683     0.200
     6.001    18.214     0.200
     6.037    19.660     0.200
     6.055    20.363     0.200
     6.116    20.875     0.200
     6.116    21.071     0.200
     6.075    22.021     0.200
     6.101    19.748     0.200
     6.159    21.966     0.200
     6.191    20.861     0.200
     6.184    20.553     0.200
     6.163    20.597     0.200
     6.198    20.607     0.200
     6.237    19.030     0.200
     6.261    20.054     0.200
     6.281    19.317     0.200
     6.294    20.063     0.200
     6.317    20.177     0.200
     6.317    20.036     0.200
     6.334    22.288     0.200
     6.309    22.403     0.200
     6.383    21.929     0.200
     6.392    20.942     0.200
     6.448    19.174     0.200
     6.460    21.475     0.200
     6.460    20.217     0.200
     6.460    20.928     0.200
     6.500    20.173     0.200
     6.562    21.736     0.200
     6.582    22.306     0.200
     6.557    21.535     0.200
     6.588    20.724     0.200
     6.678    22.305     0.200
     6.682    21.121     0.200
     6.773    20.984     0.200
     6.790    21.811     0.200
     6.797    21.605     0.200
     6.941    21.013     0.200
     6.990    21.951     0.200
     7.059    22.047     0.200
     7.085    23.535     0.200
     7.106    23.195     0.200
     7.126    23.758     0.200
     7.126    23.118     0.200
     7.165    22.279     0.200
     7.124    22.241     0.200
     7.237    26.068     0.200
     7.286    21.296     0.200
     7.337    20.881     0.200
     7.337    20.366     0.200
     7.337    20.038     0.200
     7.392    22.710     0.200
     7.392    20.734     0.200
     7.392    22.952     0.200
     7.392    22.453     0.200
     7.562    22.874     0.200
     7.613    22.055     0.200
     7.624    24.548     0.200
     7.635    22.449     0.200
     7.630    20.878     0.200
     7.630    20.457     0.200
     7.626    23.726     0.200
     7.707    21.926     0.200
     7.699    23.921     0.200
     7.821    24.162     0.200
     7.890    24.303     0.200
     7.890    22.787     0.200
     7.890    24.037     0.200
     7.977    23.432     0.200
     8.004    24.620     0.200
     8.081    26.807     0.200
     8.133    23.973     0.200
     8.133    22.567     0.200
     8.161    23.282     0.200
     8.140    25.035     0.200
     8.188    25.454     0.200
     8.250    24.126     0.200
     8.327    24.850     0.200
     8.334    26.665     0.200
     8.377    23.270     0.200
     8.452    24.586     0.200
     8.485    25.902     0.200
     8.485    25.402     0.200
     8.485    23.808     0.200
     8.499    22.506     0.200
     8.498    23.834     0.200
     8.530    22.582     0.200
     8.508    25.717     0.200
     8.629    22.828     0.200
     8.619    24.028     0.200
     8.667    25.772     0.200
     8.750    24.104     0.200
     8.741    25.279     0.200
     8.792    27.816     0.200
     8.891    26.169     0.200
     8.896    26.555     0.200
     8.946    26.945     0.200
     8.972    25.935     0.200
     9.007    24.591     0.200
     9.086    25.889     0.200
     9.105    25.772     0.200
     9.111    27.196     0.200
     9.111    25.384     0.200
     9.251    27.609     0.200
     9.347    24.605     0.200
     9.350    26.205     0.200
     9.433    25.843     0.200
     9.531    25.893     0.200
     9.608    26.399     0.200
     9.661    26.779     0.200
     9.681    28.641     0.200
     9.721    26.175     0.200
     9.703    28.081     0.200
     9.762    26.598     0.200
     9.760    28.222     0.200
     9.786    27.123     0.200
     9.838    26.015     0.200
     9.838    25.632     0.200
     9.862    27.729     0.200
     9.866    27.235     0.200
    10.004    29.065     0.200
    10.148    28.596     0.200
    10.172    28.938     0.200
    10.265    29.236     0.200
    13.625    34.679     0.200
    13.625    34.414     0.200
    13.625    33.859     0.200
    14.259    35.709     0.200
    14.261    35.537     0.200
    14.261    36.287     0.200
    14.540    36.276     0.200
    14.540    38.345     0.200
    14.540    34.431     0.200
    14.580    34.847     0.200
    15.259    35.886     0.200
    15.350    36.813     0.200
    16.418    37.506     0.200
    17.975    39.706     0.200
    18.550    43.612     0.200
    18.629    40.684     0.200
    19.641    39.905     0.200
    19.810    40.190     0.200
    20.065    42.283     0.200
    20.264    42.113     0.200
    20.863    39.891     0.200
     1.070     7.456     0.200
     1.168     7.883     0.200
     1.228     9.994     0.200
     1.244     8.643     0.200
     1.369     9.430     0.200
     1.435     9.242     0.200
     1.497     9.814     0.200
     1.522     9.744     0.200
     1.554     9.440     0.200
     1.556     8.859     0.200
     1.562     9.934     0.200
     1.622     9.168     0.200
     1.903    10.052     0.200
     2.103    11.192     0.200
     2.142     9.794     0.200
     2.263    10.349     0.200
     2.330    11.980     0.200
     2.478    10.460     0.200
     2.490     9.806     0.200
     2.660    12.148     0.200
     2.712    11.662     0.200
     2.811    11.686     0.200
     3.025    11.922     0.200
     3.025    12.118     0.200
     3.046    11.507     0.200
     3.121    12.236     0.200
     3.229    11.538     0.200
     3.415    16.480     0.200
     3.441    12.760     0.200
     3.435    12.808     0.200
     3.478    13.737     0.200
     3.529    12.601     0.200
     3.578    13.975     0.200
     3.578    14.272     0.200
     3.734    16.349     0.200
     3.734    14.451     0.200
     3.868    16.583     0.200
     3.952    15.804     0.200
     4.090    14.998     0.200
     4.139    14.982     0.200
     4.218    15.802     0.200
     4.238    15.968     0.200
     4.238    14.569     0.200
     4.305    16.083     0.200
     4.346    15.306     0.200
     4.333    14.953     0.200
     4.376    14.262     0.200
     4.492    15.872     0.200
     4.521    17.662     0.200
     4.578    15.303     0.200
     4.720    16.143     0.200
     4.720    16.541     0.200
     4.986    15.989     0.200
     5.041    16.598     0.200
     5.109    16.901     0.200
     5.250    16.257     0.200
     5.522    17.187     0.200
     5.784    19.328     0.200
     5.941    18.196     0.200
     6.197    21.184     0.200
     6.190    19.984     0.200
     6.265    19.117     0.200
     6.263    20.274     0.200
     6.332    20.004     0.200
     6.467    19.856     0.200
     6.486    20.530     0.200
     6.571    21.544     0.200
     7.301    20.418     0.200
     7.352    20.175     0.200
     7.585    22.605     0.200
     7.644    22.619     0.200
     7.910    21.461     0.200
     8.629    21.629     0.200
     9.760    27.931     0.200
     1.022     7.610     0.200
     0.969     7.406     0.200
     1.014     7.917     0.200
     1.164     8.471     0.200
     1.228     8.621     0.200
     1.228     8.791     0.200
     1.346     9.020     0.200
     1.615     9.434     0.200
     1.786     9.697     0.200
     1.898    10.226     0.200
     1.982    10.636     0.200
     2.081    10.495     0.200
     2.120    10.289     0.200
     2.242     9.844     0.200
     2.457    10.486     0.200
     2.472    10.146     0.200
     2.639    12.153     0.200
     2.690    11.711     0.200
     3.028    11.508     0.200
     3.005    13.285     0.200
     3.005    12.985     0.200
     3.017    13.238     0.200
     3.212    12.094     0.200
     3.392    16.760     0.200
     3.427    12.108     0.200
     3.416    13.118     0.200
     3.460    13.471     0.200
     3.513    12.418     0.200
     3.559    14.520     0.200
     3.559    14.720     0.200
     3.712    16.734     0.200
     3.712    17.034     0.200
     3.787    13.422     0.200
     3.847    16.857     0.200
     3.937    17.002     0.200
     4.068    15.374     0.200
     4.120    14.400     0.200
     4.201    16.619     0.200
     4.216    16.451     0.200
     4.216    16.851     0.200
     4.315    16.291     0.200
     4.327    14.950     0.200
     4.313    16.520     0.200
     4.355    15.238     0.200
     4.557    17.073     0.200
     4.698    16.421     0.200
     4.698    16.721     0.200
     4.970    16.611     0.200
     5.019    17.181     0.200
     5.059    17.515     0.200
     5.089    17.061     0.200
     5.228    16.545     0.200
     5.500    17.970     0.200
     5.923    18.733     0.200
     6.187    20.670     0.200
     6.273    18.442     0.200
     6.316    19.546     0.200
     6.449    18.762     0.200
     6.575    23.123     0.200
     6.962    20.405     0.200
     7.230    24.580     0.200
     7.336    20.612     0.200
     7.564    22.477     0.200
     7.629    22.521     0.200
     8.371    22.561     0.200
     8.624    23.114     0.200
     8.745    23.201     0.200
     9.427    23.735     0.200
     0.961     7.731     0.200
     1.002     7.535     0.200
     1.150     8.564     0.200
     1.241     9.598     0.200
     2.074    11.630     0.200
     2.116    10.904     0.200
     2.243    11.409     0.200
     2.458    11.345     0.200
     2.475    10.635     0.200
     2.631    12.625     0.200
     2.685    12.266     0.200
     2.995    13.215     0.200
     2.995    13.520     0.200
     3.007    13.282     0.200
     3.033    12.135     0.200
     3.103    12.996     0.200
     3.217    12.363     0.200
     3.391    16.511     0.200
     3.418    13.920     0.200
     3.434    12.834     0.200
     3.449    14.329     0.200
     3.520    12.844     0.200
     3.548    14.571     0.200
     3.548    14.766     0.200
     3.710    16.873     0.200
     3.710    17.076     0.200
     3.846    15.784     0.200
     4.060    15.888     0.200
     4.123    15.785     0.200
     4.207    16.074     0.200
     4.209    16.463     0.200
     4.209    16.862     0.200
     4.304    16.652     0.200
     4.329    15.654     0.200
     4.331    16.036     0.200
     4.356    15.912     0.200
     4.475    15.687     0.200
     4.548    16.696     0.200
     4.691    16.834     0.200
     4.733    16.854     0.200
     4.975    17.284     0.200
     5.079    16.998     0.200
     5.147    19.303     0.200
     5.151    15.827     0.200
     5.476    18.261     0.200
     5.498    18.419     0.200
     5.623    20.479     0.200
     5.750    18.261     0.200
     6.122    22.961     0.200
     6.165    18.963     0.200
     6.197    20.289     0.200
     6.204    20.895     0.200
     6.267    20.909     0.200
     6.287    21.710     0.200
     6.322    20.868     0.200
     6.340    20.075     0.200
     6.452    19.281     0.200
     6.588    22.092     0.200
     7.111    22.985     0.200
     7.243    24.050     0.200
     7.343    20.438     0.200
     7.564    23.598     0.200
     7.635    22.974     0.200
     1.016     7.455     0.200
     1.164     8.343     0.200
     1.168     8.007     0.200
     1.243     8.653     0.200
     1.504    10.132     0.200
     1.530     9.932     0.200
     1.801    10.042     0.200
     1.801    10.284     0.200
     1.899    10.456     0.200
     1.986    11.156     0.200
     1.946    11.606     0.200
     1.982    10.483     0.200
     2.038    10.380     0.200
     2.077    11.618     0.200
     2.116    11.620     0.200
     2.119    11.098     0.200
     2.116    10.152     0.200
     2.238     9.768     0.200
     2.249    11.123     0.200
     2.321    12.362     0.200
     2.321    11.727     0.200
     2.285    12.929     0.200
     2.410    11.707     0.200
     2.453    10.503     0.200
     2.467    10.291     0.200
     2.503    11.652     0.200
     2.523    11.707     0.200
     2.525    12.474     0.200
     2.549    12.484     0.200
     2.635    12.557     0.200
     2.686    11.597     0.200
     2.784    12.202     0.200
     2.870    13.987     0.200
     2.865    11.905     0.200
     3.024    11.793     0.200
     3.002    13.128     0.200
     3.002    13.230     0.200
     3.014    12.978     0.200
     3.068    12.974     0.200
     3.096    12.999     0.200
     3.208    12.149     0.200
     3.201    13.900     0.200
     3.388    15.015     0.200
     3.411    13.072     0.200
     3.423    12.552     0.200
     3.458    13.602     0.200
     3.509    12.490     0.200
     3.556    13.822     0.200
     3.556    14.361     0.200
     3.556    14.806     0.200
     3.707    15.594     0.200
     3.707    15.789     0.200
     3.782    14.343     0.200
     3.842    17.315     0.200
     3.936    14.023     0.200
     4.065    15.620     0.200
     4.116    14.650     0.200
     4.212    16.398     0.200
     4.212    16.500     0.200
     4.316    15.893     0.200
     4.323    15.003     0.200
     4.310    17.161     0.200
     4.350    14.659     0.200
     4.468    15.971     0.200
     4.500    15.434     0.200
     4.553    16.518     0.200
     4.661    18.521     0.200
     4.695    16.666     0.200
     4.695    17.073     0.200
     4.695    16.166     0.200
     4.726    15.286     0.200
     4.733    17.128     0.200
     4.966    16.473     0.200
     5.004    16.967     0.200
     4.984    19.202     0.200
     5.015    17.426     0.200
     5.055    16.559     0.200
     5.086    17.099     0.200
     5.133    16.836     0.200
     5.136    17.304     0.200
     5.142    15.875     0.200
     5.144    18.225     0.200
     5.189    18.124     0.200
     5.223    17.706     0.200
     5.223    15.597     0.200
     5.223    16.800     0.200
     5.423    16.864     0.200
     5.484    18.356     0.200
     5.561    17.014     0.200
     5.561    19.015     0.200
     5.611    18.662     0.200
     5.706    19.235     0.200
     5.742    17.567     0.200
     5.790    18.591     0.200
     5.883    18.799     0.200
     5.920    19.270     0.200
     6.042    19.550     0.200
     6.110    20.850     0.200
     6.104    19.902     0.200
     6.152    19.844     0.200
     6.184    21.002     0.200
     6.253    19.031     0.200
     6.273    18.547     0.200
     6.312    20.077     0.200
     6.327    21.022     0.200
     6.444    18.967     0.200
     6.502    19.815     0.200
     6.556    20.324     0.200
     6.591    20.376     0.200
     6.961    21.425     0.200
     6.982    21.076     0.200
     7.062    21.047     0.200
     7.098    21.928     0.200
     7.126    24.247     0.200
     7.229    21.794     0.200
     7.281    22.289     0.200
     7.332    20.136     0.200
     7.391    22.564     0.200
     7.391    22.689     0.200
     7.560    22.638     0.200
     7.625    22.673     0.200
     7.887    23.085     0.200
     7.996    21.744     0.200
     8.319    23.277     0.200
     8.369    22.891     0.200
     8.482    26.312     0.200
     8.664    26.250     0.200
     8.742    23.632     0.200
     8.887    27.150     0.200
     9.101    26.950     0.200
     9.114    28.265     0.200
     9.357    24.461     0.200
     9.425    25.464     0.200
     9.523    24.625     0.200
     9.600    24.828     0.200
     9.755    26.024     0.200
    13.626    34.830     0.200
    14.254    35.261     0.200
    18.557    43.912     0.200
     0.989     7.138     0.200
     1.022     7.252     0.200
     1.773    10.137     0.200
     1.870    10.059     0.200
     1.830     9.778     0.200
     1.888    10.185     0.200
     1.864     9.905     0.200
     1.908    10.046     0.200
     1.887     9.721     0.200
     2.014    11.216     0.200
     2.060    10.014     0.200
     2.095    10.562     0.200
     2.120    10.914     0.200
     2.125    10.883     0.200
     2.124    11.253     0.200
     2.240    10.934     0.200
     2.276    10.763     0.200
     2.270    11.104     0.200
     2.305    11.174     0.200
     2.318    10.196     0.200
     2.424    11.310     0.200
     2.424    10.729     0.200
     2.475    11.430     0.200
     2.528    11.525     0.200
     2.560    11.645     0.200
     2.590    12.301     0.200
     2.597    11.310     0.200
     2.632    12.021     0.200
     2.635    12.342     0.200
     2.650    12.111     0.200
     2.796    12.072     0.200
     2.815    11.745     0.200
     2.885    11.911     0.200
     2.887    14.326     0.200
     2.926    13.465     0.200
     2.994    13.767     0.200
     3.072    12.554     0.200
     3.188    14.995     0.200
     3.173    13.137     0.200
     3.249    13.579     0.200
     3.327    11.528     0.200
     3.362    14.565     0.200
     3.361    13.550     0.200
     3.396    12.584     0.200
     3.406    13.504     0.200
     3.510    15.039     0.200
     3.510    13.599     0.200
     3.600    15.531     0.200
     3.657    14.227     0.200
     3.652    14.377     0.200
     3.853    15.236     0.200
     3.916    13.501     0.200
     4.000    16.027     0.200
     4.072    14.276     0.200
     4.170    14.533     0.200
     4.169    14.928     0.200
     4.207    18.602     0.200
     4.238    16.040     0.200
     4.238    16.572     0.200
     4.304    16.017     0.200
     4.298    16.341     0.200
     4.341    15.817     0.200
     4.372    17.581     0.200
     4.443    16.547     0.200
     4.482    17.195     0.200
     4.482    16.525     0.200
     4.506    17.420     0.200
     4.600    15.446     0.200
     4.600    18.221     0.200
     4.686    17.113     0.200
     4.836    15.531     0.200
     4.836    16.625     0.200
     4.874    16.536     0.200
     4.946    15.867     0.200
     4.949    15.451     0.200
     4.987    19.700     0.200
     4.987    16.588     0.200
     5.002    16.578     0.200
     4.994    16.526     0.200
     4.985    17.627     0.200
     5.028    17.483     0.200
     5.012    18.280     0.200
     5.012    14.616     0.200
     4.997    18.091     0.200
     5.040    16.919     0.200
     5.115    16.048     0.200
     5.228    19.592     0.200
     5.296    16.797     0.200
     5.385    17.007     0.200
     5.408    19.986     0.200
     5.508    19.172     0.200
     5.488    20.711     0.200
     5.593    17.874     0.200
     5.624    19.267     0.200
     5.638    19.505     0.200
     5.818    18.259     0.200
     5.883    18.550     0.200
     5.841    20.141     0.200
     5.987    21.233     0.200
     6.042    22.136     0.200
     6.107    20.549     0.200
     6.124    21.207     0.200
     6.186    19.713     0.200
     6.161    21.697     0.200
     6.229    20.807     0.200
     6.269    21.534     0.200
     6.228    21.625     0.200
     6.291    19.264     0.200
     6.288    21.212     0.200
     6.276    19.837     0.200
     6.276    20.835     0.200
     6.294    21.345     0.200
     6.343    19.584     0.200
     6.307    21.500     0.200
     6.388    18.954     0.200
     6.379    21.571     0.200
     6.641    22.515     0.200
     6.648    20.322     0.200
     6.681    22.331     0.200
     6.718    22.223     0.200
     6.849    21.668     0.200
     7.014    20.246     0.200
     7.035    20.200     0.200
     7.154    20.018     0.200
     7.200    24.579     0.200
     7.214    20.785     0.200
     7.305    21.247     0.200
     7.342    21.922     0.200
     7.333    24.946     0.200
     7.374    22.442     0.200
     7.508    20.878     0.200
     7.490    23.791     0.200
     7.611    24.139     0.200
     8.004    22.398     0.200
     8.301    24.823     0.200
     8.371    22.616     0.200
     8.607    23.153     0.200
     8.747    23.424     0.200
     8.904    25.120     0.200
     8.904    24.714     0.200
     9.470    28.181     0.200
     9.496    27.130     0.200
     9.552    26.454     0.200
    10.122    28.455     0.200
    19.517    40.746     0.200
     1.024     7.392     0.200
     1.037     7.420     0.200
     1.013     7.298     0.200
     1.240     8.155     0.200
     1.304     8.796     0.200
     1.500     9.758     0.200
     1.527    10.090     0.200
     1.646     9.936     0.200
     1.798    10.012     0.200
     1.980     9.956     0.200
     2.079    11.075     0.200
     2.118    10.346     0.200
     2.118    10.584     0.200
     2.241    10.445     0.200
     2.456    10.195     0.200
     2.471     9.999     0.200
     2.484    11.045     0.200
     2.637    11.256     0.200
     2.637    12.213     0.200
     2.637    11.456     0.200
     2.688    11.200     0.200
     2.769    11.251     0.200
     2.787    11.776     0.200
     3.002    12.786     0.200
     3.028    11.641     0.200
     3.015    12.042     0.200
     3.015    12.940     0.200
     3.100    12.330     0.200
     3.138    13.402     0.200
     3.212    12.047     0.200
     3.202    13.056     0.200
     3.202    13.556     0.200
     3.267    13.703     0.200
     3.344    13.604     0.200
     3.391    15.854     0.200
     3.415    12.394     0.200
     3.427    11.875     0.200
     3.436    14.131     0.200
     3.458    13.676     0.200
     3.458    14.074     0.200
     3.474    14.190     0.200
     3.513    11.786     0.200
     3.549    12.617     0.200
     3.556    14.224     0.200
     3.556    14.423     0.200
     3.573    14.427     0.200
     3.710    16.525     0.200
     3.854    14.946     0.200
     4.031    12.278     0.200
     4.066    14.276     0.200
     4.119    13.944     0.200
     4.126    15.581     0.200
     4.201    14.399     0.200
     4.214    16.150     0.200
     4.317    15.940     0.200
     4.327    14.434     0.200
     4.354    15.418     0.200
     4.472    15.298     0.200
     4.497    14.821     0.200
     4.542    15.802     0.200
     4.660    18.013     0.200
     4.696    16.422     0.200
     4.696    16.563     0.200
     4.775    14.887     0.200
     5.146    17.102     0.200
     5.192    18.047     0.200
     5.454    18.992     0.200
     5.498    17.763     0.200
     5.498    18.775     0.200
     5.661    20.500     0.200
     5.792    18.436     0.200
     6.237    19.537     0.200
     6.257    20.017     0.200
     6.275    19.592     0.200
     6.315    18.096     0.200
     6.448    19.968     0.200
     7.123    22.522     0.200
     7.336    19.788     0.200
     7.563    22.667     0.200
     7.629    22.598     0.200
     8.625    22.879     0.200
     8.746    23.964     0.200
     1.040     8.143     0.200
     1.016     7.323     0.200
     1.020     7.296     0.200
     1.030     7.411     0.200
     1.038     7.359     0.200
     1.044     7.171     0.200
     1.407     7.931     0.200
     1.441     7.787     0.200
     1.489     7.885     0.200
     1.502     8.404     0.200
     1.543     8.921     0.200
     1.616     8.258     0.200
     1.654     8.495     0.200
     1.663     8.713     0.200
     1.724     8.953     0.200
     1.767     8.719     0.200
     1.828     9.922     0.200
     1.779     8.820     0.200
     1.777     8.721     0.200
     1.823     8.740     0.200
     1.839     9.249     0.200
     1.875     9.096     0.200
     1.926     9.646     0.200
     1.917     9.158     0.200
     2.171     9.680     0.200
     2.234    10.554     0.200
     2.347    11.223     0.200
     2.347    11.599     0.200
     2.346     8.924     0.200
     2.346     8.682     0.200
     2.346     9.120     0.200
     2.374    10.452     0.200
     2.398    10.213     0.200
     2.459    10.944     0.200
     2.464    11.342     0.200
     2.477    12.338     0.200
     2.698    12.770     0.200
     2.729    11.055     0.200
     2.773    10.440     0.200
     2.758    11.709     0.200
     2.758    11.811     0.200
     2.811    12.064     0.200
     2.823    12.449     0.200
     2.961    11.129     0.200
     2.922    12.897     0.200
     2.922    11.999     0.200
     3.040    12.964     0.200
     3.080    13.740     0.200
     3.023    12.619     0.200
     3.078    13.581     0.200
     3.086    12.682     0.200
     3.134    12.054     0.200
     3.224    13.442     0.200
     3.167    12.937     0.200
     3.225    11.364     0.200
     3.209    13.248     0.200
     3.223    12.781     0.200
     3.223    13.078     0.200
     3.254    12.822     0.200
     3.286    13.346     0.200
     3.308    13.355     0.200
     3.308    12.495     0.200
     3.308    13.089     0.200
     3.399    13.533     0.200
     3.399    14.033     0.200
     3.547    12.908     0.200
     3.541    13.378     0.200
     3.588    14.630     0.200
     3.661    14.381     0.200
     3.723    13.554     0.200
     3.810    12.828     0.200
     3.772    13.780     0.200
     3.822    12.587     0.200
     3.848    14.402     0.200
     3.849    14.380     0.200
     3.862    15.036     0.200
     3.914    13.924     0.200
     4.013    13.860     0.200
     4.054    13.694     0.200
     4.190    13.616     0.200
     4.293    13.833     0.200
     4.304    14.415     0.200
     4.446    15.415     0.200
     4.397    13.984     0.200
     4.485    14.081     0.200
     4.661    14.656     0.200
     4.679    16.856     0.200
     4.726    15.352     0.200
     4.726    15.031     0.200
     4.759    14.951     0.200
     4.853    14.552     0.200
     4.859    14.439     0.200
     4.860    15.827     0.200
     4.889    15.272     0.200
     4.882    18.921     0.200
     4.923    15.942     0.200
     4.968    15.520     0.200
     4.962    15.463     0.200
     5.052    15.140     0.200
     5.147    16.171     0.200
     5.185    19.283     0.200
     5.244    16.018     0.200
     5.313    16.220     0.200
     5.347    17.767     0.200
     5.479    16.173     0.200
     5.703    17.497     0.200
     5.863    18.582     0.200
     5.806    17.942     0.200
     5.890    21.535     0.200
     5.948    19.246     0.200
     5.969    18.076     0.200
     6.021    19.957     0.200
     5.994    17.597     0.200
     6.030    19.652     0.200
     6.035    20.062     0.200
     6.019    19.859     0.200
     6.151    18.911     0.200
     6.178    19.773     0.200
     6.177    17.653     0.200
     6.229    20.224     0.200
     6.296    19.466     0.200
     6.381    19.334     0.200
     6.496    19.992     0.200
     6.559    21.928     0.200
     6.616    20.889     0.200
     6.595    22.932     0.200
     6.762    20.146     0.200
     6.797    20.781     0.200
     6.972    17.638     0.200
     6.993    17.293     0.200
     7.043    19.102     0.200
     7.106    19.493     0.200
     7.185    21.552     0.200
     7.275    22.599     0.200
     7.260    20.673     0.200
     7.350    19.332     0.200
     7.400    20.036     0.200
     7.439    24.340     0.200
     7.614    22.091     0.200
     7.614    20.341     0.200
     8.221    22.687     0.200
     8.303    20.203     0.200
     8.681    21.300     0.200
     8.826    24.009     0.200
     9.856    27.678     0.200
     9.878    21.918     0.200
    10.177    28.130     0.200
    10.166    25.919     0.200
    18.384    40.457     0.200
     1.005     7.094     0.200
     1.007     7.410     0.200
     1.162     7.908     0.200
     1.198     8.197     0.200
     1.244     8.589     0.200
     1.264     8.778     0.200
     1.295     8.884     0.200
     1.304     8.661     0.200
     1.303     9.087     0.200
     1.355     8.618     0.200
     1.370     8.291     0.200
     1.411     8.647     0.200
     1.469     8.714     0.200
     1.574     9.590     0.200
     1.572     9.503     0.200
     1.999     9.370     0.200
     2.146     9.407     0.200
     2.438    10.739     0.200
     2.779    11.898     0.200
     2.781    11.280     0.200
     2.987    12.278     0.200
     3.022    11.872     0.200
     3.108    12.264     0.200
     3.207    12.805     0.200
     3.314    14.011     0.200
     3.314    13.261     0.200
     3.365    13.758     0.200
     3.477    14.702     0.200
     3.624    14.837     0.200
     3.627    15.603     0.200
     3.858    15.707     0.200
     3.893    15.701     0.200
     3.898    15.339     0.200
     4.013    14.272     0.200
     4.013    13.999     0.200
     4.025    15.265     0.200
     4.090    13.999     0.200
     4.343    15.047     0.200
     4.506    15.512     0.200
     4.587    15.795     0.200
     4.824    15.937     0.200
     4.849    16.341     0.200
     4.856    15.863     0.200
     5.024    16.011     0.200
     5.035    15.444     0.200
     5.034    15.999     0.200
     5.075    16.310     0.200
     5.180    16.332     0.200
     5.183    14.955     0.200
     5.247    16.706     0.200
     5.323    16.277     0.200
     5.594    17.206     0.200
     5.707    19.322     0.200
     5.820    18.319     0.200
     5.931    18.811     0.200
     6.249    20.230     0.200
     6.316    20.645     0.200
     6.331    20.527     0.200
     6.334    18.235     0.200
     6.376    18.798     0.200
     6.477    21.033     0.200
     6.543    19.180     0.200
     8.576    20.650     0.200
     8.815    22.453     0.200
     8.952    21.562     0.200
     9.741    22.562     0.200
     0.930     7.419     0.200
     0.935     7.725     0.200
     0.954     7.087     0.200
     1.011     7.128     0.200
     1.015     7.318     0.200
     1.040     7.420     0.200
     1.236     8.746     0.200
     1.208     8.328     0.200
     1.214     8.994     0.200
     1.290     9.159     0.200
     1.297     8.778     0.200
     1.566     9.797     0.200
     1.568     9.230     0.200
     1.552     9.287     0.200
     1.682     9.063     0.200
     1.650     9.144     0.200
     1.760     9.612     0.200
     1.722     9.127     0.200
     1.993     9.605     0.200
     2.109    10.456     0.200
     2.295    11.137     0.200
     2.299    11.408     0.200
     2.305    10.593     0.200
     2.397    12.565     0.200
     2.434    10.735     0.200
     2.504    11.698     0.200
     2.560    12.438     0.200
     2.680    12.721     0.200
     2.724    12.143     0.200
     2.779    11.316     0.200
     2.779    11.613     0.200
     2.778    11.227     0.200
     2.778    11.125     0.200
     2.954    13.866     0.200
     2.984    12.318     0.200
     3.022    12.975     0.200
     3.021    12.192     0.200
     3.106    12.288     0.200
     3.184    13.378     0.200
     3.206    12.823     0.200
     3.207    12.112     0.200
     3.207    12.612     0.200
     3.217    12.995     0.200
     3.293    12.816     0.200
     3.313    12.787     0.200
     3.362    14.005     0.200
     3.362    14.107     0.200
     3.529    14.770     0.200
     3.619    14.300     0.200
     3.623    14.366     0.200
     3.733    14.775     0.200
     3.777    14.170     0.200
     3.873    14.775     0.200
     3.857    15.624     0.200
     3.864    14.045     0.200
     3.893    15.309     0.200
     3.893    15.106     0.200
     3.891    15.931     0.200
     4.004    13.723     0.200
     4.021    15.320     0.200
     4.021    15.117     0.200
     4.042    14.577     0.200
     4.103    12.154     0.200
     4.088    15.831     0.200
     4.088    16.636     0.200
     4.254    14.704     0.200
     4.334    14.160     0.200
     4.340    15.292     0.200
     4.393    17.179     0.200
     4.502    15.605     0.200
     4.502    15.707     0.200
     4.509    17.219     0.200
     4.583    16.159     0.200
     4.820    16.193     0.200
     4.846    16.291     0.200
     4.854    15.891     0.200
     5.015    15.605     0.200
     5.015    14.925     0.200
     5.069    15.882     0.200
     5.173    15.422     0.200
     5.216    17.961     0.200
     5.240    16.989     0.200
     5.374    17.027     0.200
     5.397    16.258     0.200
     5.399    19.811     0.200
     5.537    16.512     0.200
     5.697    17.378     0.200
     5.668    17.489     0.200
     5.759    16.724     0.200
     5.817    17.454     0.200
     5.930    18.834     0.200
     6.046    19.782     0.200
     6.240    20.987     0.200
     6.262    19.675     0.200
     6.265    19.713     0.200
     6.307    18.908     0.200
     6.325    19.258     0.200
     6.366    19.595     0.200
     6.454    18.477     0.200
     6.468    20.664     0.200
     6.538    19.948     0.200
     6.841    21.450     0.200
     7.332    21.877     0.200
     7.358    22.975     0.200
     7.398    19.706     0.200
     7.478    22.573     0.200
     7.502    21.198     0.200
     8.568    20.654     0.200
     8.807    21.070     0.200
     8.944    21.370     0.200
     9.526    22.977     0.200
     9.624    22.429     0.200
     9.829    22.739     0.200
     9.890    23.821     0.200
     9.930    23.361     0.200
     9.958    23.034     0.200
     1.024     6.246     0.200
     1.081     6.434     0.200
     1.143     6.564     0.200
     1.153     6.941     0.200
     1.196     8.549     0.200
     1.142     6.880     0.200
     1.232     7.070     0.200
     1.224     6.777     0.200
     1.213     6.963     0.200
     1.356     7.884     0.200
     1.354     7.306     0.200
     1.410     7.514     0.200
     1.413     7.124     0.200
     1.439     7.214     0.200
     1.440     7.174     0.200
     1.447     7.591     0.200
     1.450     7.544     0.200
     1.401     7.409     0.200
     1.460     7.137     0.200
     1.460     7.277     0.200
     1.449     7.559     0.200
     1.485     7.699     0.200
     1.534     7.162     0.200
     1.588     7.731     0.200
     1.580     7.307     0.200
     1.577     8.114     0.200
     1.592     7.231     0.200
     1.692     8.576     0.200
     1.678     7.900     0.200
     1.701     7.898     0.200
     1.676     7.558     0.200
     1.728     7.584     0.200
     1.796     7.650     0.200
     1.753     8.142     0.200
     1.905     8.563     0.200
     1.865     8.753     0.200
     1.868     9.408     0.200
     1.919     8.837     0.200
     1.993     9.747     0.200
     1.997     9.540     0.200
     1.943     9.160     0.200
     2.005     8.401     0.200
     1.975     9.932     0.200
     2.029     8.835     0.200
     2.108     9.756     0.200
     2.132     8.960     0.200
     2.155    10.244     0.200
     2.164     9.733     0.200
     2.099     9.404     0.200
     2.179    10.392     0.200
     2.111     9.469     0.200
     2.111     9.570     0.200
     2.194    10.163     0.200
     2.194    10.443     0.200
     2.199    10.200     0.200
     2.202    10.295     0.200
     2.207    10.368     0.200
     2.193     8.608     0.200
     2.194     9.794     0.200
     2.305    10.231     0.200
     2.241    10.718     0.200
     2.323     9.560     0.200
     2.366    10.684     0.200
     2.303     9.733     0.200
     2.303    10.033     0.200
     2.333     9.415     0.200
     2.408    11.083     0.200
     2.428     9.968     0.200
     2.369    10.359     0.200
     2.455    10.211     0.200
     2.434    11.001     0.200
     2.482    10.656     0.200
     2.487     9.584     0.200
     2.511    10.426     0.200
     2.440    10.434     0.200
     2.551    11.535     0.200
     2.503    10.773     0.200
     2.519    11.309     0.200
     2.531    10.567     0.200
     2.649    10.485     0.200
     2.567    11.046     0.200
     2.567    10.845     0.200
     2.664    11.777     0.200
     2.598    10.588     0.200
     2.667    11.604     0.200
     2.699    11.261     0.200
     2.707    11.091     0.200
     2.680    11.133     0.200
     2.656    11.312     0.200
     2.656    10.468     0.200
     2.656    11.008     0.200
     2.680    11.330     0.200
     2.680    10.830     0.200
     2.732    12.327     0.200
     2.775    11.587     0.200
     2.788    10.952     0.200
     2.780    10.387     0.200
     2.798    11.511     0.200
     2.715    10.600     0.200
     2.816    11.826     0.200
     2.834    10.909     0.200
     2.783    11.191     0.200
     2.783    11.865     0.200
     2.783    11.515     0.200
     2.871    11.564     0.200
     2.875    12.257     0.200
     2.891    12.330     0.200
     2.904    11.569     0.200
     2.912    11.241     0.200
     2.929    11.900     0.200
     2.936    11.747     0.200
     2.974    13.171     0.200
     3.025    11.916     0.200
     2.949    11.486     0.200
     3.019    11.553     0.200
     3.076    12.563     0.200
     3.067    12.590     0.200
     3.067    10.711     0.200
     3.051    11.597     0.200
     3.167    12.328     0.200
     3.169    12.182     0.200
     3.169    12.761     0.200
     3.192    13.488     0.200
     3.116    12.067     0.200
     3.116    11.824     0.200
     3.220    13.014     0.200
     3.183    11.659     0.200
     3.198    12.077     0.200
     3.226    12.453     0.200
     3.259    12.574     0.200
     3.221    12.121     0.200
     3.316    12.512     0.200
     3.251    11.117     0.200
     3.339    12.742     0.200
     3.381    10.873     0.200
     3.381    11.093     0.200
     3.385    10.884     0.200
     3.342    12.397     0.200
     3.454    13.110     0.200
     3.408    13.728     0.200
     3.508    13.029     0.200
     3.482    11.873     0.200
     3.500    13.655     0.200
     3.587    12.184     0.200
     3.598    11.812     0.200
     3.673    13.323     0.200
     3.654    14.027     0.200
     3.662    12.070     0.200
     3.703    12.923     0.200
     3.712    11.573     0.200
     3.724    13.443     0.200
     3.751    12.334     0.200
     3.760    13.301     0.200
     3.737    13.508     0.200
     3.820    12.946     0.200
     3.770    12.312     0.200
     3.823    14.494     0.200
     3.898    12.085     0.200
     3.898    11.415     0.200
     3.880    13.102     0.200
     3.880    13.821     0.200
     3.854    14.853     0.200
     3.971    12.662     0.200
     3.997    12.259     0.200
     4.029    14.855     0.200
     4.048    13.368     0.200
     3.982    15.035     0.200
     3.982    14.775     0.200
     4.112    12.202     0.200
     4.036    14.698     0.200
     4.235    15.444     0.200
     4.386    14.287     0.200
     4.386    14.270     0.200
     4.406    13.267     0.200
     4.359    14.935     0.200
     4.359    14.565     0.200
     4.417    16.205     0.200
     4.417    14.456     0.200
     4.444    15.440     0.200
     4.499    18.198     0.200
     4.592    13.358     0.200
     4.730    14.164     0.200
     4.730    14.007     0.200
     4.730    14.485     0.200
     4.706    16.579     0.200
     4.746    13.670     0.200
     4.786    14.089     0.200
     4.816    14.090     0.200
     4.848    14.053     0.200
     4.846    14.613     0.200
     4.865    13.895     0.200
     4.795    17.241     0.200
     4.803    18.319     0.200
     4.810    15.867     0.200
     4.905    13.817     0.200
     4.919    13.989     0.200
     4.919    13.789     0.200
     4.909    15.819     0.200
     5.007    14.813     0.200
     5.042    13.419     0.200
     5.042    13.919     0.200
     5.053    13.541     0.200
     5.088    14.371     0.200
     5.106    14.711     0.200
     5.134    14.493     0.200
     5.170    14.604     0.200
     5.206    14.911     0.200
     5.228    16.630     0.200
     5.218    16.105     0.200
     5.341    15.260     0.200
     5.261    16.405     0.200
     5.272    16.979     0.200
     5.378    14.980     0.200
     5.397    14.809     0.200
     5.393    15.723     0.200
     5.415    15.541     0.200
     5.357    17.192     0.200
     5.384    18.190     0.200
     5.383    16.279     0.200
     5.400    15.291     0.200
     5.497    16.147     0.200
     5.464    17.944     0.200
     5.469    17.282     0.200
     5.470    19.471     0.200
     5.574    18.113     0.200
     5.661    18.102     0.200
     5.709    18.953     0.200
     5.754    18.560     0.200
     5.851    17.530     0.200
     5.820    18.781     0.200
     6.024    17.220     0.200
     5.963    18.510     0.200
     6.068    17.488     0.200
     6.083    17.715     0.200
     6.155    17.601     0.200
     6.155    17.720     0.200
     6.090    19.932     0.200
     6.110    20.411     0.200
     6.185    17.013     0.200
     6.238    18.074     0.200
     6.245    17.695     0.200
     6.192    19.280     0.200
     6.270    17.811     0.200
     6.294    17.842     0.200
     6.211    19.525     0.200
     6.414    18.235     0.200
     6.406    18.545     0.200
     6.441    19.832     0.200
     6.481    17.507     0.200
     6.600    18.376     0.200
     6.661    18.964     0.200
     6.664    20.231     0.200
     6.671    18.581     0.200
     6.693    20.393     0.200
     6.781    19.643     0.200
     6.862    19.440     0.200
     6.989    19.745     0.200
     6.979    20.063     0.200
     7.035    18.801     0.200
     7.075    18.938     0.200
     7.135    18.887     0.200
     7.135    18.840     0.200
     7.126    21.039     0.200
     7.161    18.638     0.200
     7.142    22.543     0.200
     7.216    20.094     0.200
     7.341    19.210     0.200
     7.327    22.510     0.200
     7.432    19.275     0.200
     7.498    18.805     0.200
     7.472    20.731     0.200
     7.472    20.911     0.200
     7.574    19.804     0.200
     7.561    19.645     0.200
     7.622    23.435     0.200
     7.636    22.287     0.200
     7.774    24.280     0.200
     7.822    20.617     0.200
     7.908    24.216     0.200
     7.908    24.055     0.200
     7.893    23.641     0.200
     8.014    22.977     0.200
     8.068    24.101     0.200
     8.092    22.752     0.200
     8.174    20.309     0.200
     8.221    24.019     0.200
     8.288    19.912     0.200
     8.335    20.143     0.200
     8.335    20.337     0.200
     8.415    20.902     0.200
     8.450    20.618     0.200
     8.501    22.698     0.200
     8.517    20.925     0.200
     8.528    25.488     0.200
     8.619    21.314     0.200
     8.690    21.694     0.200
     8.686    21.741     0.200
     8.801    21.085     0.200
     8.741    25.009     0.200
     8.836    21.796     0.200
     8.880    22.073     0.200
     8.847    25.700     0.200
     8.872    25.816     0.200
     9.009    21.965     0.200
     9.072    22.032     0.200
     9.639    24.312     0.200
     9.743    23.507     0.200
     9.691    26.478     0.200
     9.695    23.789     0.200
     9.695    26.091     0.200
     9.800    23.537     0.200
     9.890    23.890     0.200
    10.060    24.106     0.200
    10.068    23.214     0.200
    10.091    24.139     0.200
    10.166    23.165     0.200
    10.187    24.017     0.200
    10.394    24.607     0.200
    10.433    24.749     0.200
    10.709    25.629     0.200
    11.211    26.876     0.200
    11.476    26.983     0.200
    13.343    30.696     0.200
    13.419    30.609     0.200
    13.711    35.351     0.200
    15.598    33.516     0.200
    17.185    35.853     0.200
    18.312    38.406     0.200
    19.968    39.499     0.200
     0.965     6.278     0.200
     0.996     6.556     0.200
     0.995     6.908     0.200
     0.952     6.665     0.200
     1.001     5.971     0.200
     1.074     6.040     0.200
     1.036     6.365     0.200
     1.141     5.991     0.200
     1.232     6.233     0.200
     1.257     6.925     0.200
     1.274     7.465     0.200
     1.297     6.914     0.200
     1.370     6.605     0.200
     1.449     7.119     0.200
     1.449     6.689     0.200
     1.339     7.035     0.200
     1.411     6.808     0.200
     1.380     7.127     0.200
     1.465     7.222     0.200
     1.483     7.923     0.200
     1.525     7.217     0.200
     1.638     7.692     0.200
     1.691     8.091     0.200
     1.606     7.592     0.200
     1.717     8.097     0.200
     1.669     7.516     0.200
     1.728     7.859     0.200
     1.728     7.369     0.200
     1.752     8.050     0.200
     1.872     7.541     0.200
     1.795     8.301     0.200
     1.982     8.766     0.200
     1.938     9.022     0.200
     1.898     9.078     0.200
     1.909     9.606     0.200
     1.943     8.313     0.200
     2.079     8.290     0.200
     2.104     7.996     0.200
     2.053     9.074     0.200
     2.051     8.898     0.200
     2.235    10.050     0.200
     2.264    10.048     0.200
     2.275     9.970     0.200
     2.289    10.122     0.200
     2.303    10.122     0.200
     2.247     9.379     0.200
     2.157    10.117     0.200
     2.391    10.304     0.200
     2.261     9.545     0.200
     2.416    10.074     0.200
     2.259     9.339     0.200
     2.518    10.684     0.200
     2.539     9.770     0.200
     2.464    10.475     0.200
     2.566    10.015     0.200
     2.432    10.866     0.200
     2.574     9.533     0.200
     2.621    10.402     0.200
     2.493    10.435     0.200
     2.761    10.438     0.200
     2.774    11.403     0.200
     2.738    11.459     0.200
     2.733    11.246     0.200
     2.604     9.858     0.200
     2.818    10.764     0.200
     2.770    11.213     0.200
     2.869    10.519     0.200
     2.974    10.879     0.200
     3.020    12.055     0.200
     3.023    11.195     0.200
     3.058    11.869     0.200
     3.066    10.809     0.200
     3.102    11.063     0.200
     3.093    11.417     0.200
     3.107    11.678     0.200
     3.107    12.018     0.200
     3.021    11.781     0.200
     3.032    11.755     0.200
     3.265    12.236     0.200
     3.276    12.050     0.200
     3.154    12.030     0.200
     3.216    12.901     0.200
     3.307    12.043     0.200
     3.426    12.151     0.200
     3.320    12.294     0.200
     3.481    10.950     0.200
     3.481    10.761     0.200
     3.480    11.327     0.200
     3.363    13.693     0.200
     3.364    13.173     0.200
     3.413    12.903     0.200
     3.534    11.552     0.200
     3.741    12.476     0.200
     3.814    13.071     0.200
     3.627    13.710     0.200
     3.820    12.944     0.200
     3.661    11.814     0.200
     3.836    13.357     0.200
     3.798    12.812     0.200
     3.875    12.739     0.200
     3.992    11.345     0.200
     3.992    11.895     0.200
     4.086    12.150     0.200
     4.135    13.893     0.200
     4.117    13.424     0.200
     4.360    13.343     0.200
     4.366    13.769     0.200
     4.480    12.996     0.200
     4.502    13.018     0.200
     4.416    12.497     0.200
     4.335    15.044     0.200
     4.815    14.702     0.200
     4.815    14.545     0.200
     4.699    15.395     0.200
     4.724    15.205     0.200
     4.745    14.960     0.200
     4.925    14.428     0.200
     4.797    14.948     0.200
     4.834    15.116     0.200
     4.892    14.946     0.200
     5.100    15.218     0.200
     4.946    15.312     0.200
     4.959    15.466     0.200
     4.959    15.158     0.200
     5.107    15.531     0.200
     5.150    15.530     0.200
     5.466    16.081     0.200
     5.515    15.523     0.200
     5.360    18.885     0.200
     5.591    16.038     0.200
     5.518    18.041     0.200
     5.618    18.167     0.200
     5.710    18.204     0.200
     5.917    17.268     0.200
     5.812    18.113     0.200
     6.113    18.051     0.200
     6.138    17.638     0.200
     6.167    17.251     0.200
     6.069    17.313     0.200
     6.257    17.589     0.200
     6.100    18.752     0.200
     6.340    18.201     0.200
     6.374    17.678     0.200
     6.400    18.340     0.200
     6.285    18.992     0.200
     6.518    18.582     0.200
     6.547    19.930     0.200
     6.765    19.206     0.200
     6.969    20.397     0.200
     7.021    19.196     0.200
     7.221    18.089     0.200
     7.269    17.801     0.200
     7.518    19.402     0.200
     7.588    18.284     0.200
     7.608    18.548     0.200
     7.879    18.890     0.200
     7.931    18.982     0.200
     8.526    19.935     0.200
     8.800    20.237     0.200
     9.183    20.974     0.200
     9.853    22.050     0.200
    10.001    22.526     0.200
    10.202    23.479     0.200
    10.277    23.405     0.200
    10.298    23.454     0.200
    10.504    23.653     0.200
    10.819    24.382     0.200
     1.026     7.719     0.200
     1.144     8.227     0.200
     1.179     8.504     0.200
     1.314     9.167     0.200
     1.298     8.895     0.200
     1.388     9.962     0.200
     1.440     9.786     0.200
     1.462     9.487     0.200
     1.490     9.133     0.200
     1.602     9.102     0.200
     1.588     9.255     0.200
     1.697     9.727     0.200
     1.943    10.608     0.200
     2.112    10.088     0.200
     2.234     9.770     0.200
     2.234     9.890     0.200
     2.456     9.608     0.200
     2.563    10.761     0.200
     2.630    11.165     0.200
     2.630    11.765     0.200
     2.630    10.965     0.200
     2.672    10.341     0.200
     2.734    10.765     0.200
     2.776    11.295     0.200
     2.796    12.389     0.200
     2.929    12.070     0.200
     2.929    12.870     0.200
     2.959    11.826     0.200
     2.950    12.728     0.200
     2.950    12.528     0.200
     3.035    11.691     0.200
     3.126    13.070     0.200
     3.162    13.060     0.200
     3.162    13.160     0.200
     3.156    13.420     0.200
     3.257    13.545     0.200
     3.304    12.249     0.200
     3.328    13.138     0.200
     3.332    13.876     0.200
     3.435    13.464     0.200
     3.452    14.277     0.200
     3.452    13.677     0.200
     3.539    14.455     0.200
     3.656    13.207     0.200
     3.743    12.940     0.200
     3.734    15.677     0.200
     3.816    12.927     0.200
     3.867    14.427     0.200
     3.867    14.726     0.200
     3.915    15.068     0.200
     3.994    14.806     0.200
     3.997    16.212     0.200
     4.077    16.345     0.200
     4.045    15.646     0.200
     4.057    14.912     0.200
     4.111    13.191     0.200
     4.107    14.573     0.200
     4.221    15.998     0.200
     4.221    15.498     0.200
     4.252    14.839     0.200
     4.258    15.865     0.200
     4.258    16.565     0.200
     4.336    14.255     0.200
     4.493    15.924     0.200
     4.520    15.408     0.200
     4.556    14.655     0.200
     4.584    15.865     0.200
     4.693    15.256     0.200
     4.710    15.025     0.200
     4.700    16.106     0.200
     4.700    16.006     0.200
     4.725    14.913     0.200
     4.725    14.213     0.200
     4.967    15.831     0.200
     4.999    15.120     0.200
     5.009    16.401     0.200
     5.016    16.813     0.200
     5.029    17.273     0.200
     5.256    16.017     0.200
     5.293    16.790     0.200
     5.293    16.390     0.200
     5.373    18.049     0.200
     5.419    16.014     0.200
     5.448    16.285     0.200
     5.493    17.848     0.200
     5.561    17.961     0.200
     5.753    16.508     0.200
     6.008    17.275     0.200
     6.369    18.158     0.200
     6.447    18.636     0.200
     6.498    18.896     0.200
     6.496    19.405     0.200
     6.526    19.076     0.200
     6.529    19.909     0.200
     6.604    19.442     0.200
     6.607    19.387     0.200
     6.669    18.721     0.200
     6.704    18.682     0.200
     7.032    23.162     0.200
     7.574    22.671     0.200
     7.635    19.256     0.200
     7.753    22.580     0.200
     7.929    22.627     0.200
     9.850    26.887     0.200
     1.849     9.796     0.200
     1.840    10.114     0.200
     1.975    10.416     0.200
     1.987    10.794     0.200
     2.355    11.248     0.200
     2.746    12.386     0.200
     2.781    12.268     0.200
     2.781    12.369     0.200
     2.804    13.703     0.200
     2.815    13.279     0.200
     2.915    13.311     0.200
     2.936    12.760     0.200
     2.979    13.663     0.200
     3.053    15.093     0.200
     3.050    13.234     0.200
     3.033    15.206     0.200
     3.033    14.015     0.200
     3.087    14.924     0.200
     3.100    12.513     0.200
     3.108    13.451     0.200
     3.141    12.966     0.200
     3.163    14.222     0.200
     3.186    13.850     0.200
     3.209    14.722     0.200
     3.253    13.965     0.200
     3.253    13.664     0.200
     3.253    14.066     0.200
     3.263    14.505     0.200
     3.263    13.236     0.200
     3.297    14.454     0.200
     3.287    13.466     0.200
     3.334    13.437     0.200
     3.334    14.062     0.200
     3.372    14.272     0.200
     3.509    14.973     0.200
     3.541    15.610     0.200
     3.571    15.066     0.200
     3.607    15.333     0.200
     3.675    14.252     0.200
     3.672    15.578     0.200
     3.666    15.273     0.200
     3.666    15.554     0.200
     3.754    13.620     0.200
     3.758    15.970     0.200
     3.758    16.169     0.200
     3.784    17.190     0.200
     3.778    15.735     0.200
     3.796    14.123     0.200
     3.772    14.889     0.200
     3.770    17.042     0.200
     3.770    14.003     0.200
     3.770    15.675     0.200
     3.811    15.825     0.200
     3.828    15.437     0.200
     3.877    16.196     0.200
     3.873    16.726     0.200
     3.882    16.629     0.200
     3.909    15.413     0.200
     3.909    15.304     0.200
     3.917    16.512     0.200
     3.917    15.614     0.200
     3.917    16.114     0.200
     3.922    16.305     0.200
     4.001    16.753     0.200
     4.008    15.697     0.200
     4.008    15.970     0.200
     4.013    15.839     0.200
     4.047    17.098     0.200
     4.047    16.997     0.200
     4.152    16.102     0.200
     4.206    13.121     0.200
     4.235    14.430     0.200
     4.235    14.051     0.200
     4.279    16.183     0.200
     4.366    17.275     0.200
     4.366    16.275     0.200
     4.400    17.274     0.200
     4.418    14.619     0.200
     4.399    16.186     0.200
     4.399    17.327     0.200
     4.373    16.674     0.200
     4.373    16.494     0.200
     4.369    19.641     0.200
     4.459    14.839     0.200
     4.437    18.206     0.200
     4.437    18.456     0.200
     4.533    17.629     0.200
     4.599    14.836     0.200
     4.673    16.282     0.200
     4.673    16.091     0.200
     4.673    16.403     0.200
     4.679    15.126     0.200
     4.626    17.658     0.200
     4.672    17.900     0.200
     4.672    17.208     0.200
     4.672    17.509     0.200
     4.722    16.620     0.200
     4.761    15.191     0.200
     4.777    17.586     0.200
     4.797    15.685     0.200
     4.803    16.044     0.200
     4.770    15.910     0.200
     4.770    16.117     0.200
     4.767    17.829     0.200
     4.767    17.200     0.200
     4.767    17.098     0.200
     4.833    16.933     0.200
     4.839    16.224     0.200
     4.838    17.269     0.200
     4.866    16.688     0.200
     4.905    16.429     0.200
     4.903    17.605     0.200
     4.903    17.804     0.200
     4.903    17.472     0.200
     4.898    18.569     0.200
     4.898    18.870     0.200
     4.924    17.460     0.200
     4.924    17.999     0.200
     5.028    17.749     0.200
     5.032    18.457     0.200
     5.032    17.707     0.200
     5.032    17.906     0.200
     5.037    18.844     0.200
     5.037    19.247     0.200
     5.097    17.138     0.200
     5.057    17.613     0.200
     5.160    18.647     0.200
     5.184    16.882     0.200
     5.260    17.950     0.200
     5.287    19.425     0.200
     5.346    18.433     0.200
     5.346    18.945     0.200
     5.362    18.412     0.200
     5.362    17.846     0.200
     5.365    18.813     0.200
     5.432    17.098     0.200
     5.388    18.747     0.200
     5.388    18.450     0.200
     5.416    18.726     0.200
     5.399    18.522     0.200
     5.399    18.420     0.200
     5.458    18.529     0.200
     5.488    18.684     0.200
     5.488    18.583     0.200
     5.562    18.515     0.200
     5.562    19.116     0.200
     5.571    18.812     0.200
     5.621    18.129     0.200
     5.667    18.805     0.200
     5.680    19.042     0.200
     5.713    18.859     0.200
     5.730    19.056     0.200
     5.730    18.856     0.200
     5.777    17.211     0.200
     5.793    18.632     0.200
     5.780    19.074     0.200
     5.801    18.012     0.200
     5.801    19.344     0.200
     5.769    18.803     0.200
     5.769    19.104     0.200
     5.809    19.438     0.200
     5.810    20.096     0.200
     5.818    19.134     0.200
     5.818    18.981     0.200
     5.850    17.151     0.200
     5.887    19.931     0.200
     5.913    19.917     0.200
     5.904    19.626     0.200
     5.950    18.900     0.200
     5.929    19.337     0.200
     5.958    18.990     0.200
     5.969    19.583     0.200
     5.973    19.313     0.200
     6.023    19.498     0.200
     6.023    19.697     0.200
     6.074    19.825     0.200
     6.074    19.036     0.200
     6.043    19.311     0.200
     6.088    19.410     0.200
     6.042    20.116     0.200
     6.088    18.329     0.200
     6.088    19.122     0.200
     6.067    22.129     0.200
     6.117    19.841     0.200
     6.131    19.021     0.200
     6.190    21.785     0.200
     6.236    21.350     0.200
     6.300    21.415     0.200
     6.331    19.147     0.200
     6.351    20.631     0.200
     6.312    21.460     0.200
     6.336    20.979     0.200
     6.395    21.098     0.200
     6.497    20.234     0.200
     6.497    21.269     0.200
     6.559    20.179     0.200
     6.561    22.412     0.200
     6.553    21.058     0.200
     6.610    23.124     0.200
     6.742    21.235     0.200
     6.742    19.973     0.200
     6.756    20.581     0.200
     6.716    21.355     0.200
     6.754    20.038     0.200
     6.754    20.679     0.200
     6.764    22.172     0.200
     6.779    22.218     0.200
     6.814    21.151     0.200
     6.774    21.578     0.200
     6.863    20.940     0.200
     6.913    20.557     0.200
     6.933    19.713     0.200
     6.990    20.546     0.200
     6.959    22.213     0.200
     7.052    19.537     0.200
     7.052    20.443     0.200
     7.052    20.584     0.200
     7.052    20.197     0.200
     7.052    20.662     0.200
     7.056    20.462     0.200
     7.065    20.827     0.200
     7.132    24.095     0.200
     7.107    22.291     0.200
     7.218    22.186     0.200
     7.218    23.448     0.200
     7.226    21.398     0.200
     7.296    21.886     0.200
     7.304    21.588     0.200
     7.274    21.641     0.200
     7.345    20.434     0.200
     7.345    20.286     0.200
     7.318    21.432     0.200
     7.337    21.300     0.200
     7.410    23.153     0.200
     7.434    20.651     0.200
     7.447    21.390     0.200
     7.457    24.353     0.200
     7.464    22.316     0.200
     7.569    22.396     0.200
     7.569    21.568     0.200
     7.569    22.876     0.200
     7.614    21.478     0.200
     7.657    25.209     0.200
     7.745    27.238     0.200
     7.746    21.911     0.200
     7.765    21.810     0.200
     7.891    21.844     0.200
     7.896    24.085     0.200
     7.957    21.636     0.200
     7.927    24.722     0.200
     7.991    21.177     0.200
     7.998    24.189     0.200
     8.002    22.447     0.200
     7.980    22.706     0.200
     8.076    21.484     0.200
     8.076    22.785     0.200
     8.058    23.386     0.200
     8.058    23.487     0.200
     8.072    22.225     0.200
     8.153    21.906     0.200
     8.158    21.260     0.200
     8.158    25.943     0.200
     8.233    22.550     0.200
     8.241    21.758     0.200
     8.228    25.452     0.200
     8.228    26.155     0.200
     8.249    22.600     0.200
     8.250    22.601     0.200
     8.250    22.651     0.200
     8.239    24.830     0.200
     8.362    23.238     0.200
     8.379    22.224     0.200
     8.379    21.943     0.200
     8.471    22.677     0.200
     8.478    24.190     0.200
     8.558    23.404     0.200
     8.618    22.554     0.200
     8.658    25.873     0.200
     8.734    24.988     0.200
     8.762    25.644     0.200
     8.801    27.819     0.200
     8.834    27.759     0.200
     8.834    25.481     0.200
     8.834    27.899     0.200
     8.834    27.528     0.200
     8.885    25.642     0.200
     8.885    25.759     0.200
     8.890    26.679     0.200
     8.963    27.474     0.200
     9.057    24.559     0.200
     9.085    24.010     0.200
     9.078    25.085     0.200
     9.240    24.391     0.200
     9.297    24.934     0.200
     9.368    29.267     0.200
     9.414    24.171     0.200
     9.422    27.979     0.200
     9.424    27.298     0.200
     9.480    26.641     0.200
     9.480    28.059     0.200
     9.532    24.882     0.200
     9.532    24.406     0.200
     9.555    23.841     0.200
     9.555    25.720     0.200
     9.555    25.489     0.200
     9.537    25.424     0.200
     9.537    26.162     0.200
     9.596    25.640     0.200
     9.606    24.826     0.200
     9.569    26.657     0.200
     9.634    25.603     0.200
     9.639    25.637     0.200
     9.802    25.735     0.200
     9.819    25.833     0.200
     9.862    27.053     0.200
     9.915    27.563     0.200
     9.963    27.120     0.200
    10.120    26.732     0.200
    10.216    29.654     0.200
    10.258    27.013     0.200
    10.226    26.992     0.200
    10.226    27.652     0.200
    10.226    26.555     0.200
    10.338    28.640     0.200
    10.702    29.068     0.200
    10.803    29.451     0.200
    10.848    27.684     0.200
    11.053    29.838     0.200
    11.081    30.195     0.200
    11.442    32.433     0.200
    11.753    30.173     0.200
    11.753    32.470     0.200
    12.406    32.191     0.200
    13.302    35.589     0.200
    14.009    37.831     0.200
    14.182    37.424     0.200
    14.398    36.005     0.200
    14.398    38.095     0.200
    14.399    35.875     0.200
    14.399    38.247     0.200
    14.420    37.016     0.200
    15.313    37.560     0.200
    16.694    37.808     0.200
    17.073    39.289     0.200
    18.332    39.948     0.200
    18.519    43.506     0.200
    18.583    44.759     0.200
    19.354    40.187     0.200
    19.482    40.772     0.200
    20.035    42.121     0.200
    20.284    41.207     0.200
    20.466    42.285     0.200
    20.472    40.421     0.200
    20.641    41.151     0.200
     1.066     8.012     0.200
     1.080     7.957     0.200
     1.080     7.922     0.200
     1.131     7.941     0.200
     1.175     8.158     0.200
     1.153     7.899     0.200
     1.154     7.883     0.200
     1.161     7.806     0.200
     1.168     7.804     0.200
     1.223     8.427     0.200
     1.239     8.447     0.200
     1.328     8.545     0.200
     1.756     9.528     0.200
     1.842    10.068     0.200
     1.850     9.717     0.200
     1.984    10.405     0.200
     2.349    11.223     0.200
     2.349    10.927     0.200
     2.741    12.039     0.200
     2.902    13.668     0.200
     2.932    12.422     0.200
     2.968    13.361     0.200
     3.048    12.761     0.200
     3.046    12.990     0.200
     3.046    13.428     0.200
     3.046    13.881     0.200
     3.094    13.198     0.200
     3.106    12.992     0.200
     3.153    14.050     0.200
     3.198    14.560     0.200
     3.182    13.101     0.200
     3.252    13.887     0.200
     3.252    13.387     0.200
     3.272    12.951     0.200
     3.272    14.334     0.200
     3.291    14.024     0.200
     3.331    13.731     0.200
     3.331    13.958     0.200
     3.331    14.262     0.200
     3.360    14.426     0.200
     3.373    14.945     0.200
     3.379    15.168     0.200
     3.496    14.436     0.200
     3.530    15.799     0.200
     3.561    14.876     0.200
     3.603    14.880     0.200
     3.660    14.179     0.200
     3.660    14.023     0.200
     3.675    13.948     0.200
     3.666    15.350     0.200
     3.681    13.077     0.200
     3.681    14.241     0.200
     3.739    13.149     0.200
     3.732    17.376     0.200
     3.750    15.272     0.200
     3.773    16.992     0.200
     3.772    14.718     0.200
     3.772    15.291     0.200
     3.772    14.642     0.200
     3.802    16.119     0.200
     3.776    14.726     0.200
     3.776    15.570     0.200
     3.776    15.312     0.200
     3.818    15.359     0.200
     3.800    13.956     0.200
     3.800    14.276     0.200
     3.800    15.081     0.200
     3.800    14.706     0.200
     3.867    15.994     0.200
     3.871    16.665     0.200
     3.894    14.482     0.200
     3.878    16.579     0.200
     3.910    15.402     0.200
     3.921    16.190     0.200
     3.974    16.055     0.200
     3.991    16.639     0.200
     3.998    15.399     0.200
     3.998    15.837     0.200
     4.003    15.621     0.200
     4.056    15.398     0.200
     4.042    16.357     0.200
     4.042    16.162     0.200
     4.132    14.915     0.200
     4.193    14.247     0.200
     4.220    14.341     0.200
     4.220    14.123     0.200
     4.328    15.779     0.200
     4.328    15.990     0.200
     4.396    16.539     0.200
     4.396    17.234     0.200
     4.402    16.758     0.200
     4.403    14.781     0.200
     4.393    15.765     0.200
     4.380    16.134     0.200
     4.380    16.618     0.200
     4.380    15.970     0.200
     4.444    14.802     0.200
     4.451    18.125     0.200
     4.536    17.834     0.200
     4.585    15.050     0.200
     4.611    17.044     0.200
     4.658    15.547     0.200
     4.658    15.375     0.200
     4.658    16.211     0.200
     4.664    14.741     0.200
     4.648    18.023     0.200
     4.648    18.281     0.200
     4.648    17.891     0.200
     4.648    18.164     0.200
     4.678    15.134     0.200
     4.678    15.244     0.200
     4.715    16.008     0.200
     4.747    15.050     0.200
     4.783    15.513     0.200
     4.788    15.885     0.200
     4.770    16.563     0.200
     4.776    15.291     0.200
     4.776    15.502     0.200
     4.774    17.376     0.200
     4.774    16.517     0.200
     4.774    16.415     0.200
     4.819    17.106     0.200
     4.824    15.859     0.200
     4.851    16.096     0.200
     4.834    17.119     0.200
     4.894    16.320     0.200
     4.894    15.523     0.200
     4.894    17.023     0.200
     4.903    18.717     0.200
     5.020    16.254     0.200
     5.035    18.021     0.200
     5.035    17.670     0.200
     5.035    17.873     0.200
     5.042    19.189     0.200
     5.064    17.940     0.200
     5.148    18.252     0.200
     5.148    17.557     0.200
     5.148    17.065     0.200
     5.169    16.621     0.200
     5.253    16.028     0.200
     5.257    17.884     0.200
     5.293    19.570     0.200
     5.331    17.064     0.200
     5.331    18.501     0.200
     5.331    17.376     0.200
     5.358    17.709     0.200
     5.358    17.084     0.200
     5.374    18.519     0.200
     5.417    17.059     0.200
     5.397    18.503     0.200
     5.459    19.218     0.200
     5.467    18.229     0.200
     5.497    18.484     0.200
     5.540    18.374     0.200
     5.572    18.402     0.200
     5.614    16.112     0.200
     5.653    17.864     0.200
     5.653    18.200     0.200
     5.736    18.097     0.200
     5.740    18.546     0.200
     5.779    17.851     0.200
     5.788    18.965     0.200
     5.775    18.235     0.200
     5.802    20.320     0.200
     5.802    18.193     0.200
     5.819    19.017     0.200
     5.873    18.210     0.200
     5.873    19.171     0.200
     5.873    18.710     0.200
     5.898    18.337     0.200
     5.935    18.386     0.200
     5.910    19.763     0.200
     5.945    17.578     0.200
     5.926    19.684     0.200
     5.914    19.511     0.200
     5.955    19.280     0.200
     5.954    18.646     0.200
     5.959    18.953     0.200
     6.008    18.931     0.200
     6.008    19.618     0.200
     6.008    19.423     0.200
     6.004    19.863     0.200
     6.059    19.126     0.200
     6.059    18.852     0.200
     6.075    18.983     0.200
     6.047    19.750     0.200
     6.047    19.562     0.200
     6.050    20.128     0.200
     6.103    19.390     0.200
     6.074    22.046     0.200
     6.088    19.193     0.200
     6.116    18.728     0.200
     6.127    23.412     0.200
     6.132    20.668     0.200
     6.168    22.657     0.200
     6.181    21.607     0.200
     6.181    18.857     0.200
     6.154    20.923     0.200
     6.200    19.176     0.200
     6.243    19.273     0.200
     6.270    21.068     0.200
     6.255    20.741     0.200
     6.293    19.868     0.200
     6.326    20.312     0.200
     6.337    19.371     0.200
     6.320    21.172     0.200
     6.368    22.321     0.200
     6.351    19.414     0.200
     6.346    20.477     0.200
     6.381    20.558     0.200
     6.374    20.920     0.200
     6.401    20.544     0.200
     6.429    20.136     0.200
     6.403    20.908     0.200
     6.448    20.386     0.200
     6.448    20.683     0.200
     6.483    19.416     0.200
     6.483    20.377     0.200
     6.498    21.024     0.200
     6.489    20.803     0.200
     6.540    20.111     0.200
     6.540    20.588     0.200
     6.551    20.280     0.200
     6.551    20.780     0.200
     6.552    19.236     0.200
     6.600    20.152     0.200
     6.612    19.969     0.200
     6.612    19.867     0.200
     6.654    21.380     0.200
     6.728    20.124     0.200
     6.719    21.326     0.200
     6.745    20.243     0.200
     6.745    22.071     0.200
     6.802    20.717     0.200
     6.903    19.274     0.200
     6.903    18.970     0.200
     6.905    20.657     0.200
     6.924    18.626     0.200
     6.924    19.430     0.200
     6.975    20.026     0.200
     6.985    20.550     0.200
     6.959    22.816     0.200
     7.037    19.962     0.200
     7.037    20.063     0.200
     7.037    19.938     0.200
     7.043    20.289     0.200
     7.043    21.398     0.200
     7.043    22.078     0.200
     7.054    20.621     0.200
     7.080    21.117     0.200
     7.162    21.050     0.200
     7.182    24.050     0.200
     7.211    23.087     0.200
     7.211    22.587     0.200
     7.211    23.548     0.200
     7.213    21.665     0.200
     7.195    21.374     0.200
     7.195    21.952     0.200
     7.282    22.259     0.200
     7.290    20.861     0.200
     7.290    21.072     0.200
     7.331    20.609     0.200
     7.331    20.484     0.200
     7.337    22.536     0.200
     7.388    20.567     0.200
     7.352    23.330     0.200
     7.403    22.869     0.200
     7.403    23.057     0.200
     7.419    20.219     0.200
     7.425    19.519     0.200
     7.384    23.170     0.200
     7.434    20.617     0.200
     7.434    20.476     0.200
     7.454    20.936     0.200
     7.454    21.350     0.200
     7.480    21.039     0.200
     7.468    22.103     0.200
     7.499    20.431     0.200
     7.494    23.038     0.200
     7.494    24.038     0.200
     7.554    21.270     0.200
     7.554    21.684     0.200
     7.589    21.800     0.200
     7.599    21.559     0.200
     7.647    23.982     0.200
     7.735    21.828     0.200
     7.733    25.291     0.200
     7.733    26.635     0.200
     7.743    21.803     0.200
     7.753    21.077     0.200
     7.786    21.869     0.200
     7.773    24.821     0.200
     7.846    25.303     0.200
     7.861    21.616     0.200
     7.870    24.743     0.200
     7.880    20.468     0.200
     7.880    21.171     0.200
     7.875    23.898     0.200
     7.875    24.297     0.200
     7.924    25.253     0.200
     7.924    25.417     0.200
     7.944    21.503     0.200
     7.953    22.252     0.200
     7.939    24.216     0.200
     7.978    21.540     0.200
     7.978    23.219     0.200
     7.995    23.837     0.200
     7.995    23.439     0.200
     7.990    26.488     0.200
     8.002    24.856     0.200
     8.061    22.166     0.200
     8.060    23.101     0.200
     8.060    23.671     0.200
     8.124    20.734     0.200
     8.138    21.869     0.200
     8.144    23.338     0.200
     8.144    24.096     0.200
     8.171    22.816     0.200
     8.222    23.182     0.200
     8.225    23.126     0.200
     8.225    24.048     0.200
     8.229    21.604     0.200
     8.229    20.706     0.200
     8.235    21.169     0.200
     8.235    21.036     0.200
     8.235    22.692     0.200
     8.235    20.755     0.200
     8.235    22.700     0.200
     8.235    21.036     0.200
     8.235    20.732     0.200
     8.221    26.376     0.200
     8.221    26.548     0.200
     8.281    22.732     0.200
     8.309    24.125     0.200
     8.311    25.172     0.200
     8.332    23.697     0.200
     8.332    24.494     0.200
     8.352    21.685     0.200
     8.335    25.660     0.200
     8.308    25.276     0.200
     8.367    22.032     0.200
     8.367    22.235     0.200
     8.435    25.699     0.200
     8.458    22.132     0.200
     8.467    26.260     0.200
     8.467    25.885     0.200
     8.473    24.368     0.200
     8.473    28.586     0.200
     8.479    24.249     0.200
     8.490    24.639     0.200
     8.490    25.090     0.200
     8.533    25.352     0.200
     8.559    25.953     0.200
     8.559    26.062     0.200
     8.569    24.425     0.200
     8.566    27.668     0.200
     8.606    22.700     0.200
     8.611    26.042     0.200
     8.614    26.408     0.200
     8.678    23.365     0.200
     8.678    23.224     0.200
     8.684    26.191     0.200
     8.692    23.692     0.200
     8.692    23.950     0.200
     8.707    22.528     0.200
     8.719    22.549     0.200
     8.719    23.221     0.200
     8.744    24.795     0.200
     8.756    24.354     0.200
     8.776    24.018     0.200
     8.796    27.785     0.200
     8.809    23.834     0.200
     8.809    23.990     0.200
     8.792    25.776     0.200
     8.792    26.486     0.200
     8.830    23.428     0.200
     8.828    26.851     0.200
     8.828    26.702     0.200
     8.828    27.687     0.200
     8.863    23.207     0.200
     8.885    25.675     0.200
     8.937    25.334     0.200
     9.042    23.078     0.200
     9.042    23.562     0.200
     9.042    23.820     0.200
     9.046    25.706     0.200
     9.046    25.862     0.200
     9.046    26.597     0.200
     9.046    28.008     0.200
     9.046    25.922     0.200
     9.046    27.571     0.200
     9.046    28.633     0.200
     9.039    26.744     0.200
     9.041    26.518     0.200
     9.038    27.451     0.200
     9.071    23.124     0.200
     9.071    22.991     0.200
     9.085    27.789     0.200
     9.109    26.725     0.200
     9.126    27.933     0.200
     9.231    22.906     0.200
     9.231    23.304     0.200
     9.285    23.179     0.200
     9.354    28.272     0.200
     9.354    28.772     0.200
     9.359    29.009     0.200
     9.359    28.422     0.200
     9.366    28.408     0.200
     9.402    23.511     0.200
     9.416    27.609     0.200
     9.416    26.953     0.200
     9.430    25.182     0.200
     9.430    26.658     0.200
     9.418    27.096     0.200
     9.473    24.702     0.200
     9.474    27.564     0.200
     9.474    27.994     0.200
     9.483    27.766     0.200
     9.499    24.947     0.200
     9.522    22.905     0.200
     9.522    23.304     0.200
     9.519    28.446     0.200
     9.540    25.121     0.200
     9.540    25.699     0.200
     9.540    24.777     0.200
     9.568    26.629     0.200
     9.545    26.040     0.200
     9.584    24.580     0.200
     9.591    24.496     0.200
     9.591    26.449     0.200
     9.597    24.040     0.200
     9.597    23.642     0.200
     9.579    25.883     0.200
     9.629    23.859     0.200
     9.629    23.757     0.200
     9.665    26.712     0.200
     9.657    28.738     0.200
     9.655    29.158     0.200
     9.672    28.632     0.200
     9.672    28.765     0.200
     9.690    29.147     0.200
     9.763    27.350     0.200
     9.795    28.719     0.200
     9.811    23.346     0.200
     9.887    26.302     0.200
     9.887    25.623     0.200
     9.887    26.669     0.200
     9.887    27.357     0.200
     9.887    26.052     0.200
     9.875    24.930     0.200
     9.875    27.844     0.200
     9.898    27.933     0.200
     9.898    27.691     0.200
     9.898    28.269     0.200
     9.981    27.256     0.200
     9.958    27.848     0.200
     9.986    29.193     0.200
     9.986    29.302     0.200
    10.010    28.093     0.200
    10.072    27.592     0.200
    10.111    24.134     0.200
    10.108    27.326     0.200
    10.214    26.918     0.200
    10.214    28.090     0.200
    10.217    30.796     0.200
    10.249    24.132     0.200
    10.253    26.912     0.200
    10.265    30.540     0.200
    10.236    26.638     0.200
    10.236    25.645     0.200
    10.341    26.740     0.200
    10.333    28.182     0.200
    10.446    28.023     0.200
    10.446    29.476     0.200
    10.476    28.351     0.200
    10.584    30.220     0.200
    10.608    29.594     0.200
    10.652    28.154     0.200
    10.652    29.225     0.200
    10.675    29.310     0.200
    10.675    27.903     0.200
    10.679    29.941     0.200
    10.716    32.477     0.200
    10.716    31.977     0.200
    10.785    28.664     0.200
    10.791    28.000     0.200
    10.791    28.602     0.200
    10.816    28.766     0.200
    10.826    29.301     0.200
    10.831    27.512     0.200
    10.838    26.681     0.200
    10.838    30.900     0.200
    10.882    29.601     0.200
    10.889    27.978     0.200
    10.903    29.660     0.200
    10.903    30.035     0.200
    10.961    29.042     0.200
    10.953    31.514     0.200
    11.041    25.684     0.200
    11.041    27.184     0.200
    11.101    31.375     0.200
    11.118    31.701     0.200
    11.163    29.298     0.200
    11.201    30.118     0.200
    11.234    30.028     0.200
    11.434    31.614     0.200
    11.434    30.802     0.200
    11.444    32.582     0.200
    11.502    28.798     0.200
    11.502    31.455     0.200
    11.496    29.002     0.200
    11.750    28.411     0.200
    11.750    29.614     0.200
    11.754    30.461     0.200
    11.760    29.388     0.200
    11.760    29.623     0.200
    11.934    33.072     0.200
    12.057    32.126     0.200
    12.071    32.058     0.200
    12.123    31.458     0.200
    12.194    31.833     0.200
    12.407    33.501     0.200
    12.424    32.649     0.200
    12.460    32.285     0.200
    12.507    33.677     0.200
    12.507    30.576     0.200
    12.796    29.405     0.200
    12.798    33.385     0.200
    12.858    29.377     0.200
    13.191    33.199     0.200
    13.194    33.368     0.200
    13.268    33.394     0.200
    13.273    33.444     0.200
    13.280    32.186     0.200
    13.280    33.772     0.200
    13.280    34.014     0.200
    13.292    32.599     0.200
    13.292    33.310     0.200
    13.292    33.411     0.200
    13.374    34.020     0.200
    13.850    30.896     0.200
    14.327    36.034     0.200
    14.327    34.932     0.200
    14.348    36.494     0.200
    14.382    37.793     0.200
    14.386    37.956     0.200
    14.400    37.984     0.200
    14.400    37.577     0.200
    14.420    35.152     0.200
    14.642    38.958     0.200
    14.911    37.398     0.200
    15.247    36.768     0.200
    15.300    36.878     0.200
    15.406    36.912     0.200
    16.020    36.136     0.200
    16.286    39.111     0.200
    17.353    39.781     0.200
    17.348    40.080     0.200
    17.914    39.642     0.200
    17.923    38.680     0.200
    18.112    38.261     0.200
    18.317    38.966     0.200
    18.609    43.062     0.200
    18.621    40.291     0.200
    18.920    42.940     0.200
    19.477    40.627     0.200
    20.041    41.426     0.200
    20.469    41.254     0.200
    20.469    40.558     0.200
    20.638    40.392     0.200
    20.677    41.935     0.200
     1.618     8.904     0.200
     1.673    10.295     0.200
     1.769     8.644     0.200
     1.769     8.745     0.200
     1.710     9.273     0.200
     1.722     9.231     0.200
     1.850    10.064     0.200
     1.837     9.456     0.200
     1.974     9.715     0.200
     2.360    10.647     0.200
     2.360    10.248     0.200
     2.456    11.267     0.200
     2.750    11.490     0.200
     2.922    12.985     0.200
     2.981    13.716     0.200
     2.941    11.862     0.200
     3.028    12.950     0.200
     3.028    13.505     0.200
     3.028    13.747     0.200
     3.054    12.753     0.200
     3.165    13.895     0.200
     3.113    12.863     0.200
     3.212    14.177     0.200
     3.190    13.058     0.200
     3.256    13.287     0.200
     3.256    13.389     0.200
     3.262    12.473     0.200
     3.262    12.949     0.200
     3.302    13.451     0.200
     3.302    13.553     0.200
     3.387    14.689     0.200
     3.337    13.028     0.200
     3.337    13.239     0.200
     3.337    13.536     0.200
     3.337    14.036     0.200
     3.337    13.747     0.200
     3.394    15.217     0.200
     3.379    13.854     0.200
     3.516    13.753     0.200
     3.544    15.356     0.200
     3.573    14.733     0.200
     3.611    14.245     0.200
     3.682    13.567     0.200
     3.682    13.426     0.200
     3.660    13.131     0.200
     3.660    14.373     0.200
     3.677    14.482     0.200
     3.760    12.568     0.200
     3.750    15.221     0.200
     3.786    15.906     0.200
     3.786    16.594     0.200
     3.764    14.656     0.200
     3.813    15.158     0.200
     3.830    14.927     0.200
     3.784    15.428     0.200
     3.775    14.703     0.200
     3.775    15.282     0.200
     3.770    15.051     0.200
     3.770    15.894     0.200
     3.770    16.019     0.200
     3.800    14.446     0.200
     3.800    14.821     0.200
     3.800    14.946     0.200
     3.878    15.418     0.200
     3.916    13.389     0.200
     3.877    15.839     0.200
     3.886    15.635     0.200
     3.923    15.007     0.200
     3.923    14.702     0.200
     3.969    13.825     0.200
     3.926    15.692     0.200
     3.989    16.428     0.200
     4.003    16.617     0.200
     4.009    15.171     0.200
     4.009    15.405     0.200
     4.015    15.274     0.200
     4.073    14.167     0.200
     4.078    14.819     0.200
     4.052    16.298     0.200
     4.052    15.697     0.200
     4.210    13.584     0.200
     4.241    13.489     0.200
     4.241    14.396     0.200
     4.320    15.278     0.200
     4.320    15.481     0.200
     4.398    15.861     0.200
     4.398    16.463     0.200
     4.372    14.562     0.200
     4.372    14.163     0.200
     4.415    16.257     0.200
     4.362    19.049     0.200
     4.424    14.155     0.200
     4.373    15.667     0.200
     4.373    16.261     0.200
     4.406    15.371     0.200
     4.430    18.567     0.200
     4.535    17.518     0.200
     4.604    14.531     0.200
     4.621    17.044     0.200
     4.684    14.297     0.200
     4.680    15.296     0.200
     4.680    14.976     0.200
     4.680    15.726     0.200
     4.680    16.140     0.200
     4.699    15.063     0.200
     4.645    16.734     0.200
     4.645    17.765     0.200
     4.645    17.273     0.200
     4.767    14.484     0.200
     4.728    15.615     0.200
     4.765    14.871     0.200
     4.765    15.293     0.200
     4.802    14.994     0.200
     4.809    15.845     0.200
     4.782    17.086     0.200
     4.766    16.567     0.200
     4.846    15.529     0.200
     4.840    16.483     0.200
     4.872    15.781     0.200
     4.842    16.973     0.200
     4.910    15.990     0.200
     4.910    15.388     0.200
     4.899    18.317     0.200
     5.034    15.838     0.200
     5.033    17.460     0.200
     5.033    17.889     0.200
     5.037    19.001     0.200
     5.056    17.882     0.200
     5.189    16.106     0.200
     5.167    18.330     0.200
     5.167    15.979     0.200
     5.266    17.535     0.200
     5.264    17.660     0.200
     5.352    16.594     0.200
     5.352    17.734     0.200
     5.352    17.289     0.200
     5.367    17.152     0.200
     5.367    17.824     0.200
     5.364    18.191     0.200
     5.438    16.580     0.200
     5.387    18.122     0.200
     5.456    19.120     0.200
     5.457    17.904     0.200
     5.486    18.561     0.200
     5.496    20.161     0.200
     5.529    18.162     0.200
     5.560    18.301     0.200
     5.627    16.424     0.200
     5.674    17.370     0.200
     5.750    16.484     0.200
     5.728    18.442     0.200
     5.799    17.776     0.200
     5.806    18.327     0.200
     5.806    18.624     0.200
     5.809    19.100     0.200
     5.785    20.592     0.200
     5.785    17.973     0.200
     5.841    19.799     0.200
     5.853    16.909     0.200
     5.815    19.610     0.200
     5.892    18.491     0.200
     5.892    19.351     0.200
     5.892    18.686     0.200
     5.920    18.262     0.200
     5.963    18.506     0.200
     5.957    17.994     0.200
     5.904    19.581     0.200
     5.902    19.009     0.200
     5.974    18.929     0.200
     5.978    18.928     0.200
     5.933    19.242     0.200
     5.976    18.262     0.200
     6.030    18.548     0.200
     6.030    19.040     0.200
     6.030    19.282     0.200
     5.992    21.320     0.200
     5.992    18.367     0.200
     5.999    19.478     0.200
     6.080    18.729     0.200
     6.092    19.129     0.200
     6.044    18.339     0.200
     6.044    19.456     0.200
     6.041    19.690     0.200
     6.122    19.474     0.200
     6.133    21.341     0.200
     6.066    21.695     0.200
     6.088    19.142     0.200
     6.138    18.343     0.200
     6.175    21.702     0.200
     6.196    20.524     0.200
     6.196    18.782     0.200
     6.156    20.444     0.200
     6.188    18.580     0.200
     6.236    21.315     0.200
     6.242    19.048     0.200
     6.330    19.417     0.200
     6.260    20.335     0.200
     6.306    20.392     0.200
     6.356    19.715     0.200
     6.311    20.829     0.200
     6.335    20.861     0.200
     6.388    20.540     0.200
     6.350    19.385     0.200
     6.393    21.630     0.200
     6.447    20.268     0.200
     6.412    21.029     0.200
     6.394    20.969     0.200
     6.469    20.402     0.200
     6.501    19.875     0.200
     6.501    20.274     0.200
     6.515    20.829     0.200
     6.488    20.170     0.200
     6.560    20.426     0.200
     6.561    20.221     0.200
     6.561    20.346     0.200
     6.567    20.898     0.200
     6.611    23.110     0.200
     6.593    22.044     0.200
     6.616    21.431     0.200
     6.664    23.811     0.200
     6.621    21.417     0.200
     6.699    23.383     0.200
     6.656    21.114     0.200
     6.746    19.927     0.200
     6.746    20.068     0.200
     6.755    19.966     0.200
     6.755    21.645     0.200
     6.730    21.645     0.200
     6.730    21.543     0.200
     6.715    21.618     0.200
     6.742    21.005     0.200
     6.770    22.192     0.200
     6.818    19.991     0.200
     6.816    21.696     0.200
     6.816    21.485     0.200
     6.772    21.358     0.200
     6.781    22.049     0.200
     6.914    20.101     0.200
     6.914    19.601     0.200
     6.863    20.596     0.200
     6.935    19.960     0.200
     6.935    19.858     0.200
     7.002    21.278     0.200
     6.997    19.635     0.200
     6.964    22.312     0.200
     6.958    21.489     0.200
     6.969    20.757     0.200
     7.058    19.331     0.200
     7.058    20.073     0.200
     7.058    19.612     0.200
     7.058    19.346     0.200
     7.068    20.200     0.200
     7.063    20.153     0.200
     7.063    21.606     0.200
     7.067    20.416     0.200
     7.132    23.057     0.200
     7.095    25.003     0.200
     7.179    20.989     0.200
     7.187    24.694     0.200
     7.219    23.040     0.200
     7.219    22.540     0.200
     7.219    23.235     0.200
     7.183    21.217     0.200
     7.183    21.889     0.200
     7.233    20.377     0.200
     7.233    20.947     0.200
     7.303    21.166     0.200
     7.303    21.963     0.200
     7.303    22.323     0.200
     7.311    20.765     0.200
     7.311    22.124     0.200
     7.272    20.828     0.200
     7.352    19.775     0.200
     7.352    20.189     0.200
     7.352    19.908     0.200
     7.320    21.469     0.200
     7.347    22.946     0.200
     7.405    22.625     0.200
     7.336    22.173     0.200
     7.441    20.840     0.200
     7.440    19.537     0.200
     7.440    20.209     0.200
     7.356    22.638     0.200
     7.445    19.238     0.200
     7.451    20.391     0.200
     7.451    20.532     0.200
     7.416    23.820     0.200
     7.386    22.789     0.200
     7.476    21.442     0.200
     7.476    20.848     0.200
     7.450    23.059     0.200
     7.450    24.395     0.200
     7.500    21.219     0.200
     7.515    20.451     0.200
     7.493    24.950     0.200
     7.464    21.788     0.200
     7.510    24.325     0.200
     7.510    25.255     0.200
     7.588    22.039     0.200
     7.576    20.674     0.200
     7.576    23.221     0.200
     7.576    22.846     0.200
     7.576    22.166     0.200
     7.548    20.894     0.200
     7.609    19.985     0.200
     7.620    21.058     0.200
     7.768    21.207     0.200
     7.763    19.933     0.200
     7.752    25.218     0.200
     7.752    24.859     0.200
     7.758    24.755     0.200
     7.806    20.373     0.200
     7.818    25.749     0.200
     7.771    22.299     0.200
     7.823    24.980     0.200
     7.802    22.636     0.200
     7.882    20.449     0.200
     7.893    21.180     0.200
     7.863    25.337     0.200
     7.836    22.841     0.200
     7.889    23.645     0.200
     7.885    24.108     0.200
     7.885    24.280     0.200
     7.885    22.675     0.200
     7.961    21.186     0.200
     7.961    21.475     0.200
     7.895    22.849     0.200
     7.973    20.531     0.200
     7.936    25.072     0.200
     7.936    25.533     0.200
     7.953    24.090     0.200
     7.926    23.392     0.200
     7.996    20.327     0.200
     7.996    22.264     0.200
     7.996    21.366     0.200
     7.948    24.422     0.200
     8.002    23.504     0.200
     8.002    24.004     0.200
     7.975    26.124     0.200
     7.959    24.231     0.200
     7.959    24.411     0.200
     7.987    24.975     0.200
     7.973    24.971     0.200
     7.952    22.785     0.200
     8.005    23.562     0.200
     8.082    22.164     0.200
     8.061    21.236     0.200
     8.061    23.415     0.200
     8.061    22.970     0.200
     8.073    22.369     0.200
     8.145    20.664     0.200
     8.092    24.250     0.200
     8.159    22.173     0.200
     8.159    22.001     0.200
     8.159    21.821     0.200
     8.165    22.689     0.200
     8.165    23.103     0.200
     8.165    24.299     0.200
     8.165    23.916     0.200
     8.165    23.502     0.200
     8.191    22.485     0.200
     8.164    25.291     0.200
     8.233    24.002     0.200
     8.244    21.083     0.200
     8.244    21.778     0.200
     8.244    23.189     0.200
     8.255    20.488     0.200
     8.255    22.129     0.200
     8.255    22.363     0.200
     8.255    20.355     0.200
     8.255    22.371     0.200
     8.255    23.980     0.200
     8.255    20.348     0.200
     8.234    25.462     0.200
     8.234    25.102     0.200
     8.243    24.780     0.200
     8.302    22.699     0.200
     8.331    24.525     0.200
     8.320    26.886     0.200
     8.329    24.767     0.200
     8.353    24.305     0.200
     8.353    24.094     0.200
     8.373    21.357     0.200
     8.383    21.611     0.200
     8.383    21.861     0.200
     8.315    24.354     0.200
     8.391    25.583     0.200
     8.474    22.293     0.200
     8.453    25.043     0.200
     8.464    25.914     0.200
     8.464    25.281     0.200
     8.493    27.865     0.200
     8.493    26.076     0.200
     8.484    26.166     0.200
     8.485    25.330     0.200
     8.478    23.848     0.200
     8.478    25.238     0.200
     8.499    25.159     0.200
     8.551    25.994     0.200
     8.551    25.598     0.200
     8.521    25.281     0.200
     8.581    27.060     0.200
     8.581    25.849     0.200
     8.621    21.977     0.200
     8.591    26.169     0.200
     8.628    26.892     0.200
     8.632    26.453     0.200
     8.609    24.273     0.200
     8.676    26.553     0.200
     8.663    26.181     0.200
     8.699    23.778     0.200
     8.714    23.791     0.200
     8.714    23.603     0.200
     8.702    26.740     0.200
     8.728    22.832     0.200
     8.740    24.515     0.200
     8.740    23.679     0.200
     8.749    23.991     0.200
     8.777    25.859     0.200
     8.830    22.843     0.200
     8.830    23.601     0.200
     8.814    28.721     0.200
     8.814    28.479     0.200
     8.802    25.512     0.200
     8.802    26.277     0.200
     8.788    24.227     0.200
     8.851    24.341     0.200
     8.840    24.988     0.200
     8.840    25.801     0.200
     8.840    26.777     0.200
     8.840    26.926     0.200
     8.903    23.049     0.200
     8.903    25.549     0.200
     8.908    23.095     0.200
     8.881    26.855     0.200
     8.888    25.067     0.200
     8.888    25.294     0.200
     8.888    25.263     0.200
     8.936    25.011     0.200
     8.969    26.774     0.200
     9.064    24.101     0.200
     9.064    24.336     0.200
     9.068    27.141     0.200
     9.068    26.868     0.200
     9.066    27.984     0.200
     9.066    24.429     0.200
     9.066    27.844     0.200
     9.059    27.069     0.200
     9.056    26.704     0.200
     9.091    22.203     0.200
     9.091    22.656     0.200
     9.050    27.232     0.200
     9.098    27.383     0.200
     9.079    25.232     0.200
     9.120    27.304     0.200
     9.120    26.757     0.200
     9.138    27.182     0.200
     9.242    23.731     0.200
     9.300    23.954     0.200
     9.351    25.081     0.200
     9.365    27.928     0.200
     9.374    28.796     0.200
     9.375    28.185     0.200
     9.375    28.685     0.200
     9.416    23.594     0.200
     9.382    25.046     0.200
     9.434    24.995     0.200
     9.434    25.893     0.200
     9.367    26.872     0.200
     9.428    27.024     0.200
     9.428    26.962     0.200
     9.430    26.925     0.200
     9.437    27.165     0.200
     9.491    25.414     0.200
     9.491    24.766     0.200
     9.452    28.129     0.200
     9.460    27.067     0.200
     9.517    24.871     0.200
     9.486    27.292     0.200
     9.534    24.022     0.200
     9.534    23.421     0.200
     9.489    28.133     0.200
     9.538    29.730     0.200
     9.538    26.535     0.200
     9.538    29.238     0.200
     9.561    24.366     0.200
     9.561    25.506     0.200
     9.561    24.873     0.200
     9.561    24.709     0.200
     9.535    27.340     0.200
     9.588    26.233     0.200
     9.588    26.858     0.200
     9.599    24.463     0.200
     9.537    26.650     0.200
     9.537    25.095     0.200
     9.537    26.033     0.200
     9.607    24.170     0.200
     9.607    23.772     0.200
     9.612    25.417     0.200
     9.612    25.659     0.200
     9.567    25.939     0.200
     9.567    28.033     0.200
     9.641    23.881     0.200
     9.641    23.779     0.200
     9.665    24.996     0.200
     9.682    26.089     0.200
     9.665    28.619     0.200
     9.685    28.299     0.200
     9.707    28.509     0.200
     9.802    29.499     0.200
     9.763    27.833     0.200
     9.821    25.579     0.200
     9.821    24.680     0.200
     9.771    27.410     0.200
     9.861    26.209     0.200
     9.854    25.531     0.200
     9.854    28.226     0.200
     9.903    25.435     0.200
     9.903    26.583     0.200
     9.903    27.162     0.200
     9.903    26.318     0.200
     9.889    26.472     0.200
     9.889    27.932     0.200
     9.957    26.217     0.200
     9.916    27.606     0.200
     9.968    27.810     0.200
     9.998    29.115     0.200
    10.019    28.058     0.200
    10.110    24.861     0.200
    10.121    27.376     0.200
    10.092    27.913     0.200
    10.178    26.806     0.200
    10.232    27.716     0.200
    10.232    26.989     0.200
    10.260    26.250     0.200
    10.221    28.123     0.200
    10.221    30.107     0.200
    10.273    29.908     0.200
    10.223    29.172     0.200
    10.273    27.599     0.200
    10.273    27.732     0.200
    10.224    26.490     0.200
    10.261    29.376     0.200
    10.261    27.074     0.200
    10.360    27.438     0.200
    10.343    28.579     0.200
    10.467    27.442     0.200
    10.493    28.228     0.200
    10.511    26.622     0.200
    10.603    27.243     0.200
    10.626    28.866     0.200
    10.600    30.587     0.200
    10.600    29.587     0.200
    10.646    25.943     0.200
    10.668    27.664     0.200
    10.668    28.945     0.200
    10.664    29.319     0.200
    10.692    28.411     0.200
    10.692    27.731     0.200
    10.643    28.759     0.200
    10.722    32.357     0.200
    10.689    29.833     0.200
    10.704    29.588     0.200
    10.783    30.595     0.200
    10.788    27.690     0.200
    10.788    28.893     0.200
    10.807    27.865     0.200
    10.799    32.386     0.200
    10.833    28.523     0.200
    10.843    28.800     0.200
    10.849    28.835     0.200
    10.851    25.890     0.200
    10.851    30.812     0.200
    10.899    29.070     0.200
    10.905    27.563     0.200
    10.922    29.825     0.200
    10.977    28.054     0.200
    11.057    27.952     0.200
    11.138    31.666     0.200
    11.082    29.800     0.200
    11.153    32.076     0.200
    11.214    29.320     0.200
    11.214    31.219     0.200
    11.247    29.636     0.200
    11.446    28.509     0.200
    11.448    31.787     0.200
    11.448    31.084     0.200
    11.448    30.483     0.200
    11.522    31.524     0.200
    11.530    31.921     0.200
    11.487    26.607     0.200
    11.650    32.885     0.200
    11.759    27.861     0.200
    11.753    32.106     0.200
    11.936    34.690     0.200
    12.076    32.260     0.200
    12.088    32.018     0.200
    12.141    32.396     0.200
    12.205    33.414     0.200
    12.212    32.372     0.200
    12.408    29.352     0.200
    12.441    33.300     0.200
    12.480    33.731     0.200
    12.519    32.797     0.200
    12.681    33.601     0.200
    12.808    33.422     0.200
    12.815    33.535     0.200
    12.869    31.801     0.200
    12.912    28.777     0.200
    12.921    31.917     0.200
    12.985    33.408     0.200
    13.207    32.760     0.200
    13.225    33.356     0.200
    13.239    33.581     0.200
    13.241    33.660     0.200
    13.250    33.556     0.200
    13.261    33.331     0.200
    13.266    33.368     0.200
    13.291    32.470     0.200
    13.297    32.263     0.200
    13.297    33.716     0.200
    13.297    32.872     0.200
    13.309    30.277     0.200
    13.309    33.417     0.200
    13.309    32.574     0.200
    13.309    33.574     0.200
    13.395    35.615     0.200
    13.395    34.084     0.200
    13.733    34.218     0.200
    13.728    30.298     0.200
    13.840    34.880     0.200
    13.861    32.133     0.200
    14.043    34.334     0.200
    14.011    37.865     0.200
    14.185    37.190     0.200
    14.302    34.684     0.200
    14.278    33.744     0.200
    14.278    38.127     0.200
    14.356    34.448     0.200
    14.417    36.362     0.200
    14.417    32.308     0.200
    14.383    38.134     0.200
    14.401    37.528     0.200
    14.401    36.926     0.200
    14.401    37.832     0.200
    14.407    38.057     0.200
    14.569    37.001     0.200
    14.664    34.809     0.200
    14.738    32.051     0.200
    14.738    36.497     0.200
    14.941    34.425     0.200
    14.932    36.327     0.200
    15.164    31.679     0.200
    15.244    38.490     0.200
    15.267    34.956     0.200
    15.320    33.056     0.200
    15.421    37.183     0.200
    16.060    37.445     0.200
    16.287    33.732     0.200
    16.698    38.818     0.200
    16.926    39.259     0.200
    16.933    39.380     0.200
    17.042    39.312     0.200
    17.084    38.611     0.200
    17.084    38.775     0.200
    17.345    36.399     0.200
    17.818    38.344     0.200
    18.134    38.437     0.200
    18.134    38.882     0.200
    18.554    40.210     0.200
    18.624    43.341     0.200
    18.648    40.647     0.200
    18.814    43.189     0.200
    18.941    41.718     0.200
    19.042    40.870     0.200
    19.293    39.310     0.200
    19.497    39.709     0.200
    19.674    39.611     0.200
    19.764    42.935     0.200
    20.035    41.781     0.200
    20.301    39.088     0.200
    20.283    40.005     0.200
    20.470    41.001     0.200
    20.476    40.629     0.200
    20.645    40.059     0.200
     1.484     8.269     0.200
     1.567     8.955     0.200
     1.577     8.910     0.200
     1.638     9.020     0.200
     1.726     9.315     0.200
     1.857     9.418     0.200
     1.953     9.873     0.200
     1.994     9.830     0.200
     2.371    11.152     0.200
     2.416    11.711     0.200
     2.468    10.970     0.200
     2.763    11.676     0.200
     2.920    13.238     0.200
     2.954    12.056     0.200
     2.954    12.353     0.200
     3.002    13.856     0.200
     3.069    13.505     0.200
     3.127    13.330     0.200
     3.193    14.389     0.200
     3.204    13.536     0.200
     3.272    13.440     0.200
     3.272    13.940     0.200
     3.282    13.009     0.200
     3.313    13.562     0.200
     3.367    14.515     0.200
     3.352    13.699     0.200
     3.352    13.503     0.200
     3.352    13.800     0.200
     3.379    15.086     0.200
     3.475    13.961     0.200
     3.515    14.506     0.200
     3.554    14.615     0.200
     3.615    13.541     0.200
     3.625    14.620     0.200
     3.673    14.358     0.200
     3.688    14.380     0.200
     3.772    16.903     0.200
     3.794    14.645     0.200
     3.791    15.553     0.200
     3.859    15.669     0.200
     3.905    16.054     0.200
     3.892    15.209     0.200
     3.900    15.117     0.200
     3.932    15.532     0.200
     3.932    16.430     0.200
     3.990    15.273     0.200
     3.995    15.227     0.200
     4.064    15.296     0.200
     4.064    15.992     0.200
     4.134    15.599     0.200
     4.379    17.118     0.200
     4.339    15.783     0.200
     4.379    15.519     0.200
     4.379    16.621     0.200
     4.392    15.970     0.200
     4.415    16.598     0.200
     4.591    14.792     0.200
     4.553    17.790     0.200
     4.669    15.705     0.200
     4.669    15.237     0.200
     4.754    15.410     0.200
     4.737    16.138     0.200
     4.785    15.335     0.200
     4.802    15.461     0.200
     4.814    15.525     0.200
     4.793    16.889     0.200
     4.786    16.877     0.200
     4.837    16.463     0.200
     4.860    16.574     0.200
     4.888    15.613     0.200
     4.891    18.187     0.200
     4.856    17.155     0.200
     4.909    16.537     0.200
     4.909    15.631     0.200
     4.918    18.236     0.200
     4.976    15.567     0.200
     5.014    15.980     0.200
     5.042    17.181     0.200
     5.052    17.673     0.200
     5.057    18.809     0.200
     5.126    16.158     0.200
     5.076    17.786     0.200
     5.175    17.306     0.200
     5.278    18.131     0.200
     5.340    18.054     0.200
     5.380    18.641     0.200
     5.406    18.229     0.200
     5.475    19.031     0.200
     5.476    18.113     0.200
     5.506    18.270     0.200
     5.513    20.658     0.200
     5.549    18.270     0.200
     5.700    19.004     0.200
     5.789    20.961     0.200
     5.786    17.990     0.200
     5.748    18.653     0.200
     5.797    17.870     0.200
     5.877    19.802     0.200
     5.908    19.440     0.200
     5.946    20.582     0.200
     5.959    20.029     0.200
     5.950    18.985     0.200
     5.963    20.011     0.200
     5.924    19.792     0.200
     5.947    19.121     0.200
     6.018    19.589     0.200
     6.106    21.386     0.200
     6.063    19.477     0.200
     6.061    19.797     0.200
     6.086    21.802     0.200
     6.130    20.088     0.200
     6.255    21.321     0.200
     6.311    20.875     0.200
     6.331    21.038     0.200
     6.354    20.765     0.200
     6.414    20.881     0.200
     6.484    21.653     0.200
     6.541    20.796     0.200
     6.792    21.465     0.200
     6.895    19.462     0.200
     6.915    19.422     0.200
     6.987    20.194     0.200
     6.978    22.595     0.200
     7.113    23.417     0.200
     7.200    19.800     0.200
     7.340    20.159     0.200
     7.873    21.640     0.200
     8.225    21.330     0.200
     8.456    22.541     0.200
     8.603    22.428     0.200
     9.223    23.498     0.200
     9.515    24.483     0.200
     1.435     8.052     0.200
     1.561     9.870     0.200
     1.546     9.154     0.200
     1.551     8.630     0.200
     1.618     8.959     0.200
     1.674     9.840     0.200
     1.674    10.621     0.200
     1.600     8.958     0.200
     1.662     9.977     0.200
     1.699     9.331     0.200
     1.706     9.209     0.200
     1.786     8.888     0.200
     1.869     9.186     0.200
     1.820     9.867     0.200
     2.344    12.010     0.200
     2.344    10.307     0.200
     2.450    11.194     0.200
     2.733    11.768     0.200
     2.917    12.924     0.200
     2.925    12.931     0.200
     2.925    12.337     0.200
     2.998    12.926     0.200
     3.016    13.190     0.200
     3.016    14.370     0.200
     3.035    12.547     0.200
     3.119    12.610     0.200
     3.095    12.752     0.200
     3.183    13.586     0.200
     3.173    12.737     0.200
     3.228    14.137     0.200
     3.238    13.382     0.200
     3.244    12.390     0.200
     3.286    14.122     0.200
     3.286    13.418     0.200
     3.319    13.500     0.200
     3.319    13.632     0.200
     3.319    14.023     0.200
     3.319    13.742     0.200
     3.373    13.805     0.200
     3.403    14.181     0.200
     3.410    14.796     0.200
     3.422    14.336     0.200
     3.511    13.686     0.200
     3.560    15.335     0.200
     3.590    14.195     0.200
     3.594    14.323     0.200
     3.684    13.481     0.200
     3.700    13.091     0.200
     3.661    14.044     0.200
     3.652    13.284     0.200
     3.652    14.541     0.200
     3.741    14.111     0.200
     3.766    12.594     0.200
     3.751    16.286     0.200
     3.803    15.345     0.200
     3.769    15.285     0.200
     3.756    15.074     0.200
     3.751    14.629     0.200
     3.831    15.167     0.200
     3.780    14.144     0.200
     3.780    14.449     0.200
     3.780    14.676     0.200
     3.780    14.551     0.200
     3.847    14.541     0.200
     3.896    15.093     0.200
     3.859    16.028     0.200
     3.868    15.324     0.200
     3.921    14.112     0.200
     3.863    14.986     0.200
     3.909    15.254     0.200
     3.909    15.051     0.200
     3.907    15.706     0.200
     4.004    15.903     0.200
     4.020    16.144     0.200
     4.027    14.903     0.200
     4.027    15.332     0.200
     4.032    14.858     0.200
     4.035    16.875     0.200
     4.077    14.901     0.200
     4.224    13.577     0.200
     4.249    14.083     0.200
     4.301    15.466     0.200
     4.301    15.653     0.200
     4.360    14.592     0.200
     4.360    14.092     0.200
     4.354    16.163     0.200
     4.354    15.851     0.200
     4.360    18.720     0.200
     4.418    16.108     0.200
     4.418    16.412     0.200
     4.432    16.524     0.200
     4.392    15.719     0.200
     4.431    14.368     0.200
     4.432    18.367     0.200
     4.515    17.014     0.200
     4.616    14.789     0.200
     4.639    16.381     0.200
     4.653    14.500     0.200
     4.684    15.222     0.200
     4.684    15.003     0.200
     4.684    15.464     0.200
     4.684    15.565     0.200
     4.625    17.042     0.200
     4.625    16.893     0.200
     4.625    17.245     0.200
     4.694    14.522     0.200
     4.713    15.465     0.200
     4.780    14.939     0.200
     4.780    15.689     0.200
     4.766    16.346     0.200
     4.814    14.837     0.200
     4.747    16.764     0.200
     4.816    16.316     0.200
     4.838    15.874     0.200
     4.849    15.470     0.200
     4.825    17.057     0.200
     4.879    15.890     0.200
     4.925    17.694     0.200
     4.898    16.999     0.200
     4.898    18.397     0.200
     4.879    17.828     0.200
     5.021    16.277     0.200
     5.013    17.127     0.200
     5.013    16.963     0.200
     5.018    18.308     0.200
     5.037    17.481     0.200
     5.160    18.442     0.200
     5.160    16.356     0.200
     5.199    16.146     0.200
     5.250    16.696     0.200
     5.245    17.653     0.200
     5.359    16.604     0.200
     5.359    17.659     0.200
     5.359    17.877     0.200
     5.351    17.620     0.200
     5.351    18.034     0.200
     5.346    18.178     0.200
     5.368    17.913     0.200
     5.440    16.551     0.200
     5.436    18.224     0.200
     5.439    17.695     0.200
     5.476    20.348     0.200
     5.468    18.053     0.200
     5.511    17.651     0.200
     5.543    18.082     0.200
     5.611    16.179     0.200
     5.671    17.303     0.200
     5.737    16.617     0.200
     5.711    18.521     0.200
     5.808    17.476     0.200
     5.768    18.549     0.200
     5.819    17.865     0.200
     5.819    18.599     0.200
     5.828    19.547     0.200
     5.801    19.857     0.200
     5.861    20.652     0.200
     5.869    16.770     0.200
     5.902    18.721     0.200
     5.902    20.377     0.200
     5.926    18.409     0.200
     5.885    19.089     0.200
     5.885    19.088     0.200
     5.916    19.229     0.200
     5.957    17.874     0.200
     5.975    18.394     0.200
     5.985    19.181     0.200
     5.975    17.735     0.200
     5.990    18.734     0.200
     6.034    18.352     0.200
     6.034    18.516     0.200
     6.034    19.000     0.200
     5.979    19.191     0.200
     5.990    17.178     0.200
     6.088    19.052     0.200
     6.024    18.795     0.200
     6.024    18.670     0.200
     6.022    19.587     0.200
     6.106    19.968     0.200
     6.047    21.494     0.200
     6.068    18.246     0.200
     6.133    19.366     0.200
     6.139    18.273     0.200
     6.152    21.247     0.200
     6.194    22.158     0.200
     6.184    20.516     0.200
     6.184    20.664     0.200
     6.137    20.145     0.200
     6.170    18.757     0.200
     6.222    18.552     0.200
     6.217    20.718     0.200
     6.242    20.325     0.200
     6.291    21.259     0.200
     6.350    19.766     0.200
     6.293    20.829     0.200
     6.368    19.900     0.200
     6.317    20.047     0.200
     6.330    18.693     0.200
     6.382    23.222     0.200
     6.395    20.724     0.200
     6.375    20.764     0.200
     6.395    20.437     0.200
     6.381    21.402     0.200
     6.460    21.139     0.200
     6.465    19.321     0.200
     6.465    19.774     0.200
     6.514    20.121     0.200
     6.514    20.598     0.200
     6.514    20.707     0.200
     6.529    20.314     0.200
     6.469    19.478     0.200
     6.560    21.210     0.200
     6.579    19.989     0.200
     6.555    21.064     0.200
     6.576    21.729     0.200
     6.605    21.338     0.200
     6.593    19.528     0.200
     6.603    21.211     0.200
     6.637    20.614     0.200
     6.759    20.464     0.200
     6.759    21.049     0.200
     6.715    22.006     0.200
     6.715    21.905     0.200
     6.696    21.325     0.200
     6.773    19.321     0.200
     6.773    23.110     0.200
     6.725    21.892     0.200
     6.756    21.614     0.200
     6.762    21.651     0.200
     6.826    19.969     0.200
     6.826    22.930     0.200
     6.754    21.245     0.200
     6.833    20.274     0.200
     6.844    20.198     0.200
     6.932    19.368     0.200
     6.953    19.227     0.200
     6.946    22.209     0.200
     7.001    19.059     0.200
     6.940    21.680     0.200
     6.949    20.369     0.200
     7.016    20.661     0.200
     7.063    19.594     0.200
     7.063    19.836     0.200
     7.063    19.305     0.200
     7.063    19.688     0.200
     7.057    20.226     0.200
     7.057    22.023     0.200
     7.057    23.906     0.200
     7.084    19.630     0.200
     7.047    20.123     0.200
     7.081    23.884     0.200
     7.152    23.104     0.200
     7.193    19.950     0.200
     7.207    25.389     0.200
     7.165    20.694     0.200
     7.165    21.248     0.200
     7.165    21.694     0.200
     7.238    21.696     0.200
     7.238    22.501     0.200
     7.229    20.500     0.200
     7.301    20.458     0.200
     7.301    23.966     0.200
     7.312    20.139     0.200
     7.312    21.178     0.200
     7.255    21.105     0.200
     7.357    19.748     0.200
     7.357    20.107     0.200
     7.300    21.174     0.200
     7.337    22.642     0.200
     7.401    24.412     0.200
     7.401    25.209     0.200
     7.367    22.499     0.200
     7.447    19.809     0.200
     7.447    20.653     0.200
     7.456    20.981     0.200
     7.455    21.661     0.200
     7.465    20.141     0.200
     7.465    20.321     0.200
     7.478    20.492     0.200
     7.478    20.804     0.200
     7.459    21.001     0.200
     7.459    23.767     0.200
     7.445    21.485     0.200
     7.530    20.253     0.200
     7.499    24.593     0.200
     7.577    20.746     0.200
     7.577    20.965     0.200
     7.577    23.777     0.200
     7.577    22.254     0.200
     7.529    20.804     0.200
     7.601    20.566     0.200
     7.618    21.211     0.200
     7.765    21.419     0.200
     7.746    24.472     0.200
     7.772    22.098     0.200
     7.784    20.533     0.200
     7.814    22.705     0.200
     7.751    22.306     0.200
     7.784    22.529     0.200
     7.890    22.967     0.200
     7.881    26.812     0.200
     7.868    23.855     0.200
     7.866    22.678     0.200
     7.876    22.751     0.200
     7.975    20.770     0.200
     7.975    22.301     0.200
     7.907    24.091     0.200
     7.931    24.324     0.200
     7.982    22.649     0.200
     7.933    22.287     0.200
     8.008    20.950     0.200
     8.021    22.454     0.200
     8.086    21.302     0.200
     8.041    22.291     0.200
     8.041    20.682     0.200
     8.054    22.178     0.200
     8.075    24.035     0.200
     8.152    20.545     0.200
     8.163    21.103     0.200
     8.163    21.650     0.200
     8.164    22.893     0.200
     8.164    23.089     0.200
     8.164    25.112     0.200
     8.164    23.386     0.200
     8.200    24.758     0.200
     8.248    22.812     0.200
     8.252    21.806     0.200
     8.252    23.415     0.200
     8.259    20.779     0.200
     8.218    25.210     0.200
     8.218    26.257     0.200
     8.264    21.923     0.200
     8.264    24.087     0.200
     8.264    22.119     0.200
     8.264    24.892     0.200
     8.264    22.119     0.200
     8.264    23.377     0.200
     8.225    24.682     0.200
     8.310    24.628     0.200
     8.329    23.825     0.200
     8.319    25.329     0.200
     8.354    23.174     0.200
     8.354    24.166     0.200
     8.381    21.793     0.200
     8.397    21.612     0.200
     8.397    21.799     0.200
     8.457    25.574     0.200
     8.457    26.254     0.200
     8.489    21.500     0.200
     8.488    27.103     0.200
     8.461    23.344     0.200
     8.482    25.241     0.200
     8.461    25.027     0.200
     8.461    24.269     0.200
     8.543    25.870     0.200
     8.582    26.115     0.200
     8.590    22.094     0.200
     8.637    21.773     0.200
     8.634    24.546     0.200
     8.619    27.288     0.200
     8.590    24.002     0.200
     8.649    26.703     0.200
     8.731    23.074     0.200
     8.747    23.740     0.200
     8.747    23.576     0.200
     8.752    22.952     0.200
     8.800    23.785     0.200
     8.807    29.095     0.200
     8.786    26.799     0.200
     8.769    24.035     0.200
     8.836    23.053     0.200
     8.836    23.967     0.200
     8.858    24.585     0.200
     8.824    24.677     0.200
     8.824    26.630     0.200
     8.824    26.786     0.200
     8.824    27.989     0.200
     8.869    25.759     0.200
     9.012    24.190     0.200
     9.052    24.352     0.200
     9.068    24.054     0.200
     9.068    23.265     0.200
     9.068    25.445     0.200
     9.074    23.245     0.200
     9.045    26.910     0.200
     9.069    26.225     0.200
     9.034    27.236     0.200
     9.063    25.291     0.200
     9.063    29.252     0.200
     9.099    23.510     0.200
     9.099    24.237     0.200
     9.083    27.329     0.200
     9.154    23.881     0.200
     9.123    27.163     0.200
     9.167    25.049     0.200
     9.260    22.905     0.200
     9.264    24.802     0.200
     9.315    23.158     0.200
     9.362    29.150     0.200
     9.362    26.906     0.200
     9.362    28.187     0.200
     9.403    23.520     0.200
     9.370    27.204     0.200
     9.432    23.087     0.200
     9.413    28.077     0.200
     9.413    28.022     0.200
     9.414    27.603     0.200
     9.453    22.843     0.200
     9.453    25.343     0.200
     9.421    28.218     0.200
     9.437    28.111     0.200
     9.503    25.154     0.200
     9.503    26.755     0.200
     9.471    27.720     0.200
     9.471    28.040     0.200
     9.530    26.325     0.200
     9.552    22.694     0.200
     9.567    24.766     0.200
     9.567    25.118     0.200
     9.567    25.219     0.200
     9.518    25.676     0.200
     9.615    24.162     0.200
     9.550    27.313     0.200
     9.625    23.539     0.200
     9.659    23.050     0.200
     9.695    27.096     0.200
     9.696    28.913     0.200
     9.839    24.546     0.200
     9.858    25.281     0.200
     9.858    28.226     0.200
     9.917    26.499     0.200
     9.917    26.741     0.200
     9.917    27.030     0.200
     9.870    26.798     0.200
     9.870    27.415     0.200
     9.870    27.930     0.200
     9.896    27.016     0.200
     9.951    27.452     0.200
    10.130    25.975     0.200
    10.100    27.318     0.200
    10.205    27.963     0.200
    10.227    30.312     0.200
    10.278    23.824     0.200
    10.206    26.806     0.200
    10.206    26.220     0.200
    10.371    27.140     0.200
    10.326    28.580     0.200
    10.588    30.998     0.200
    10.639    30.010     0.200
    10.682    28.757     0.200
    10.705    30.038     0.200
    10.822    27.579     0.200
    10.868    28.500     0.200
    10.913    29.009     0.200
    10.920    29.409     0.200
    10.991    29.059     0.200
    11.072    26.264     0.200
    11.062    29.553     0.200
    11.469    30.583     0.200
    11.777    29.323     0.200
    11.733    30.587     0.200
    11.733    31.830     0.200
    12.077    31.926     0.200
    12.204    34.139     0.200
    12.389    31.939     0.200
    12.805    35.834     0.200
    12.887    28.874     0.200
    13.199    35.730     0.200
    13.240    34.761     0.200
    13.252    35.717     0.200
    13.279    35.703     0.200
    13.286    33.279     0.200
    13.286    34.529     0.200
    13.298    32.887     0.200
    13.298    34.340     0.200
    13.298    35.075     0.200
    13.298    33.856     0.200
    13.298    34.973     0.200
    13.391    33.380     0.200
    13.391    34.544     0.200
    13.715    35.137     0.200
    13.991    37.173     0.200
    14.166    37.352     0.200
    14.356    31.732     0.200
    14.363    37.347     0.200
    14.367    37.307     0.200
    14.381    34.030     0.200
    14.381    37.038     0.200
    14.381    34.263     0.200
    14.381    36.888     0.200
    14.388    37.262     0.200
    14.436    34.536     0.200
    14.747    37.621     0.200
    14.928    35.907     0.200
    15.261    36.273     0.200
    15.313    33.586     0.200
    16.003    34.793     0.200
    16.267    35.562     0.200
    16.365    37.065     0.200
    17.635    36.013     0.200
    17.847    37.182     0.200
    17.945    38.675     0.200
    17.938    36.200     0.200
    17.960    35.535     0.200
    18.057    37.657     0.200
    18.256    39.422     0.200
    18.333    41.025     0.200
    18.500    40.974     0.200
    18.938    42.068     0.200
    19.099    40.985     0.200
    19.366    39.367     0.200
    19.479    40.744     0.200
    20.015    40.484     0.200
    20.452    41.187     0.200
    20.458    41.016     0.200
    20.621    40.221     0.200
    20.627    40.002     0.200
    20.627    40.846     0.200
     2.340    11.538     0.200
     3.315    14.261     0.200
     3.904    15.586     0.200
     4.031    15.607     0.200
     4.421    16.847     0.200
     4.387    17.348     0.200
     4.682    16.663     0.200
     4.709    16.094     0.200
     4.762    16.577     0.200
     4.821    16.984     0.200
     4.847    16.383     0.200
     5.016    18.406     0.200
     5.198    17.229     0.200
     5.241    18.383     0.200
     5.831    17.395     0.200
     5.911    19.858     0.200
     5.976    22.422     0.200
     5.985    20.496     0.200
     6.033    19.589     0.200
     6.353    18.305     0.200
     6.515    22.114     0.200
     6.934    20.122     0.200
     6.955    19.575     0.200
     8.490    21.872     0.200
     8.638    23.844     0.200
     2.336    12.007     0.200
     2.917    12.926     0.200
     3.030    13.005     0.200
     3.089    13.119     0.200
     3.166    13.418     0.200
     3.233    13.333     0.200
     3.278    13.717     0.200
     3.314    14.094     0.200
     3.314    13.493     0.200
     3.587    14.105     0.200
     3.653    14.342     0.200
     3.853    14.594     0.200
     3.862    14.697     0.200
     3.899    15.160     0.200
     4.028    15.761     0.200
     4.382    15.922     0.200
     4.418    17.307     0.200
     4.704    16.472     0.200
     4.758    17.844     0.200
     4.818    17.239     0.200
     4.836    16.848     0.200
     4.887    17.526     0.200
     5.011    17.495     0.200
     5.187    16.552     0.200
     5.240    18.321     0.200
     5.347    18.979     0.200
     5.343    17.208     0.200
     5.427    17.750     0.200
     5.761    19.138     0.200
     5.796    18.449     0.200
     5.826    21.278     0.200
     5.892    20.910     0.200
     5.913    20.139     0.200
     5.909    19.406     0.200
     5.944    19.051     0.200
     5.965    18.112     0.200
     5.974    20.339     0.200
     5.979    19.630     0.200
     6.022    19.710     0.200
     6.122    19.122     0.200
     6.126    18.910     0.200
     6.357    20.224     0.200
     6.349    20.175     0.200
     6.505    21.388     0.200
     6.575    20.235     0.200
     6.927    19.722     0.200
     6.948    20.081     0.200
     6.989    20.707     0.200
     7.235    22.941     0.200
     7.904    21.529     0.200
     8.251    21.676     0.200
     8.480    22.601     0.200
     8.629    22.168     0.200
     9.255    23.260     0.200
     9.307    24.446     0.200
     9.425    23.874     0.200
     9.546    24.066     0.200
     9.607    23.750     0.200
     9.620    24.199     0.200
     9.645    24.610     0.200
     9.653    24.112     0.200
     9.834    24.395     0.200
    10.135    27.285     0.200
     1.283     7.489     0.200
     1.347     7.652     0.200
     1.352     7.622     0.200
     1.349     8.647     0.200
     1.395     7.659     0.200
     1.390     7.783     0.200
     1.366     7.814     0.200
     1.513     9.396     0.200
     1.521     8.762     0.200
     1.602     9.451     0.200
     1.606     8.983     0.200
     1.596     8.928     0.200
     1.630     8.922     0.200
     1.639     8.909     0.200
     1.749     8.805     0.200
     1.957     9.385     0.200
     1.992     9.596     0.200
     2.091    10.230     0.200
     2.093    10.453     0.200
     2.145    10.484     0.200
     2.378    10.932     0.200
     2.406    11.499     0.200
     2.454    11.007     0.200
     2.510    11.710     0.200
     3.322    14.310     0.200
     3.473    15.351     0.200
     3.717    13.907     0.200
     3.872    15.399     0.200
     3.894    14.543     0.200
     4.635    14.647     0.200
     4.635    14.289     0.200
     4.801    14.791     0.200
     4.829    14.278     0.200
     5.149    15.219     0.200
     5.310    15.750     0.200
     5.758    15.994     0.200
     5.853    16.274     0.200
     5.876    16.340     0.200
     5.911    16.389     0.200
     5.927    16.986     0.200
     6.092    16.189     0.200
     6.545    20.506     0.200
     6.894    19.926     0.200
     6.915    19.584     0.200
     7.204    22.811     0.200
     8.214    22.220     0.200
     8.442    22.560     0.200
     8.592    23.113     0.200
     9.512    25.278     0.200
     1.463     9.009     0.200
     1.568    10.040     0.200
     1.534    10.363     0.200
     1.540     8.985     0.200
     1.574     9.081     0.200
     1.581     9.674     0.200
     1.622     9.413     0.200
     1.624     9.770     0.200
     1.651     9.642     0.200
     1.685     9.605     0.200
     1.722     9.906     0.200
     1.711    11.427     0.200
     1.729    10.542     0.200
     1.738     9.982     0.200
     1.791    10.440     0.200
     1.763     9.772     0.200
     1.779    10.017     0.200
     1.939    10.149     0.200
     1.977    10.196     0.200
     1.977     9.938     0.200
     2.166    10.695     0.200
     2.264    10.935     0.200
     2.347    11.772     0.200
     2.398    11.241     0.200
     2.739    12.403     0.200
     2.930    14.383     0.200
     3.045    14.232     0.200
     3.103    13.761     0.200
     3.265    14.273     0.200
     3.248    14.165     0.200
     3.289    15.183     0.200
     3.328    14.926     0.200
     3.362    15.926     0.200
     3.601    15.645     0.200
     3.750    16.609     0.200
     3.868    16.030     0.200
     3.875    16.142     0.200
     3.909    16.348     0.200
     4.040    17.717     0.200
     4.392    17.313     0.200
     4.530    18.294     0.200
     4.769    18.712     0.200
     4.831    17.687     0.200
     4.830    16.575     0.200
     5.030    17.843     0.200
     5.030    18.374     0.200
     5.176    18.471     0.200
     5.254    18.452     0.200
     5.809    20.683     0.200
     5.785    19.969     0.200
     5.879    21.425     0.200
     5.905    18.561     0.200
     5.923    19.849     0.200
     5.952    20.167     0.200
     5.940    19.556     0.200
     5.962    20.613     0.200
     6.110    21.410     0.200
     6.121    17.762     0.200
     6.251    21.313     0.200
     6.558    20.631     0.200
     6.910    18.826     0.200
     6.931    19.880     0.200
     7.217    23.040     0.200
     7.887    21.323     0.200
     8.236    21.653     0.200
     8.465    22.680     0.200
     8.613    22.146     0.200
     9.529    23.159     0.200
     9.636    24.808     0.200
     1.668    10.522     0.200
     1.725    10.131     0.200
     1.706     9.244     0.200
     2.345    10.725     0.200
     2.345    10.225     0.200
     2.734    11.879     0.200
     2.734    11.176     0.200
     2.913    12.894     0.200
     2.926    13.648     0.200
     3.240    13.375     0.200
     3.321    13.928     0.200
     3.321    14.233     0.200
     3.369    15.073     0.200
     3.507    15.358     0.200
     3.678    14.165     0.200
     3.760    12.809     0.200
     3.750    15.126     0.200
     3.750    14.524     0.200
     3.769    14.308     0.200
     3.908    15.180     0.200
     3.908    15.079     0.200
     4.036    16.889     0.200
     4.036    17.287     0.200
     4.391    17.044     0.200
     4.366    18.107     0.200
     4.519    17.755     0.200
     4.678    16.145     0.200
     4.713    15.890     0.200
     4.767    17.961     0.200
     4.843    16.187     0.200
     4.826    17.167     0.200
     5.192    16.764     0.200
     5.247    18.052     0.200
     5.353    18.328     0.200
     5.435    17.422     0.200
     5.801    18.100     0.200
     5.823    18.337     0.200
     5.896    20.675     0.200
     5.919    20.484     0.200
     5.917    19.336     0.200
     5.952    19.186     0.200
     5.978    19.823     0.200
     5.983    19.283     0.200
     6.028    19.862     0.200
     6.028    19.643     0.200
     6.099    20.455     0.200
     6.126    19.517     0.200
     6.133    18.822     0.200
     6.244    20.923     0.200
     6.345    19.542     0.200
     6.507    20.990     0.200
     6.573    19.878     0.200
     6.597    20.204     0.200
     6.926    19.463     0.200
     6.947    20.119     0.200
     6.995    19.552     0.200
     7.057    20.355     0.200
     7.225    22.269     0.200
     7.232    21.889     0.200
     7.351    20.501     0.200
     7.462    25.384     0.200
     7.903    21.759     0.200
     8.252    21.483     0.200
     8.482    22.408     0.200
     8.630    22.375     0.200
     8.824    25.331     0.200
     9.254    23.399     0.200
     9.426    24.391     0.200
     9.545    24.190     0.200
     9.608    24.560     0.200
     9.619    24.236     0.200
     9.652    24.146     0.200
    10.213    27.545     0.200
     1.562     9.774     0.200
     1.626     9.017     0.200
     1.615     9.273     0.200
     1.716     9.450     0.200
     1.722     9.936     0.200
     1.778     9.983     0.200
     1.808    10.432     0.200
     1.835     9.796     0.200
     1.931    10.008     0.200
     1.969    10.044     0.200
     2.020    12.458     0.200
     2.267    11.861     0.200
     2.344    11.423     0.200
     2.344    12.521     0.200
     2.405    12.394     0.200
     2.599    13.004     0.200
     2.735    12.258     0.200
     2.735    12.059     0.200
     2.907    13.356     0.200
     3.323    15.194     0.200
     3.323    14.291     0.200
     3.501    16.820     0.200
     3.748    16.838     0.200
     3.748    14.638     0.200
     3.762    15.785     0.200
     3.768    14.707     0.200
     3.789    15.159     0.200
     3.907    15.885     0.200
     3.907    15.284     0.200
     4.037    17.269     0.200
     4.037    16.769     0.200
     4.390    17.448     0.200
     4.408    16.838     0.200
     4.669    16.419     0.200
     4.712    17.692     0.200
     4.766    18.159     0.200
     4.834    16.365     0.200
     4.827    17.442     0.200
     5.023    17.955     0.200
     5.182    16.998     0.200
     5.249    19.019     0.200
     5.426    17.475     0.200
     5.770    19.846     0.200
     5.791    16.912     0.200
     5.799    19.500     0.200
     5.816    16.807     0.200
     5.886    18.398     0.200
     5.910    19.398     0.200
     5.918    19.806     0.200
     5.943    19.250     0.200
     5.959    19.154     0.200
     5.973    19.693     0.200
     6.090    19.168     0.200
     6.116    19.369     0.200
     6.125    19.178     0.200
     6.246    21.180     0.200
     6.498    20.505     0.200
     6.565    21.257     0.200
     6.601    20.140     0.200
     6.918    18.845     0.200
     6.938    19.806     0.200
     6.986    21.346     0.200
     7.048    21.002     0.200
     7.218    22.240     0.200
     7.225    22.666     0.200
     7.342    21.598     0.200
     7.895    21.943     0.200
     8.243    21.478     0.200
     8.472    22.405     0.200
     8.621    22.273     0.200
     8.824    27.222     0.200
     9.245    23.383     0.200
     9.417    23.982     0.200
     9.537    23.080     0.200
     9.611    25.416     0.200
     9.644    23.331     0.200
     9.825    24.321     0.200
     5.443    17.361     0.200
     5.614    17.406     0.200
     5.902    19.612     0.200
     6.093    19.105     0.200
     6.208    18.204     0.200
     6.584    22.393     0.200
     6.616    21.876     0.200
     6.655    20.358     0.200
     6.670    20.548     0.200
     6.702    22.046     0.200
     6.725    21.953     0.200
     6.790    20.399     0.200
     6.803    23.348     0.200
     6.907    19.531     0.200
     7.813    22.193     0.200
     1.637     9.816     0.200
     1.694    10.978     0.200
     1.781    10.035     0.200
     7.827    21.686     0.200
     1.792    10.414     0.200
     2.567    13.189     0.200
     5.453    17.652     0.200
     5.624    17.431     0.200
     5.627    19.186     0.200
     5.909    19.289     0.200
     6.102    19.959     0.200
     6.534    21.236     0.200
     6.621    22.977     0.200
     6.661    20.729     0.200
     6.679    21.162     0.200
     6.673    22.212     0.200
     6.737    21.302     0.200
     6.800    20.887     0.200
     6.789    20.893     0.200
     6.919    20.475     0.200
     7.822    21.688     0.200
     1.552     9.383     0.200
     1.635    11.000     0.200
     2.436    12.725     0.200
     2.863    12.767     0.200
     3.141    13.627     0.200
     3.172    13.165     0.200
     3.172    13.864     0.200
     3.357    13.998     0.200
     3.386    14.063     0.200
     3.509    14.323     0.200
     3.525    14.638     0.200
     3.525    14.341     0.200
     3.562    14.211     0.200
     3.586    14.434     0.200
     3.654    15.238     0.200
     3.654    14.636     0.200
     3.774    14.934     0.200
     3.994    17.071     0.200
     3.994    15.372     0.200
     4.007    16.219     0.200
     4.108    16.140     0.200
     4.108    16.437     0.200
     4.108    16.941     0.200
     4.141    15.660     0.200
     4.256    15.912     0.200
     4.288    16.143     0.200
     4.288    16.842     0.200
     4.455    16.891     0.200
     4.477    17.827     0.200
     4.546    17.428     0.200
     4.587    18.637     0.200
     4.744    17.117     0.200
     4.933    17.510     0.200
     4.965    16.838     0.200
     5.198    18.113     0.200
     5.219    18.273     0.200
     5.254    18.065     0.200
     5.454    17.973     0.200
     5.534    17.593     0.200
     5.570    19.183     0.200
     5.593    17.907     0.200
     5.625    17.517     0.200
     5.776    17.601     0.200
     5.776    19.078     0.200
     5.887    17.981     0.200
     5.887    19.110     0.200
     5.911    18.160     0.200
     5.970    19.805     0.200
     6.104    19.803     0.200
     6.176    18.611     0.200
     6.197    20.162     0.200
     6.220    18.839     0.200
     6.277    20.524     0.200
     6.310    19.436     0.200
     6.335    18.882     0.200
     6.536    21.001     0.200
     6.593    23.209     0.200
     6.623    21.663     0.200
     6.663    22.192     0.200
     6.675    21.188     0.200
     6.681    21.592     0.200
     6.709    21.731     0.200
     6.696    20.033     0.200
     6.737    21.640     0.200
     6.780    20.225     0.200
     6.801    21.075     0.200
     6.790    23.084     0.200
     6.811    20.380     0.200
     6.919    20.506     0.200
     7.301    21.125     0.200
     7.538    21.507     0.200
     7.823    22.080     0.200
     7.923    23.355     0.200
     8.116    22.263     0.200
     8.261    23.702     0.200
     9.167    25.092     0.200
     9.302    28.466     0.200
     9.852    28.206     0.200
     9.957    27.304     0.200
     5.789    17.519     0.200
     5.838    19.603     0.200
     6.765    21.114     0.200
     6.858    22.868     0.200
     7.000    20.578     0.200
     8.020    21.367     0.200
    19.290    40.286     0.200
     1.517     7.573     0.200
     1.545     7.257     0.200
     1.593     8.278     0.200
     1.593     8.398     0.200
     1.981     9.882     0.200
     1.987     9.807     0.200
     2.112     9.986     0.200
     2.251     9.993     0.200
     2.306    10.412     0.200
     2.357    10.180     0.200
     2.375    10.470     0.200
     2.580    11.732     0.200
     2.557    10.550     0.200
     2.635    11.137     0.200
     2.703    11.337     0.200
     2.707    12.899     0.200
     2.826    11.295     0.200
     2.826    11.682     0.200
     2.826    11.822     0.200
     2.833    11.823     0.200
     2.862    11.182     0.200
     2.922    12.319     0.200
     2.922    11.632     0.200
     2.922    11.991     0.200
     2.922    12.092     0.200
     2.922    12.201     0.200
     2.929    12.304     0.200
     3.204    13.142     0.200
     3.204    13.356     0.200
     3.302    13.953     0.200
     3.362    13.095     0.200
     3.426    13.008     0.200
     3.464    14.366     0.200
     3.513    12.555     0.200
     3.483    13.441     0.200
     3.570    11.830     0.200
     3.570    12.179     0.200
     3.579    13.524     0.200
     3.665    14.817     0.200
     3.690    13.099     0.200
     3.741    13.113     0.200
     3.762    14.415     0.200
     3.935    13.611     0.200
     3.978    14.058     0.200
     4.032    14.214     0.200
     4.054    13.828     0.200
     4.072    12.015     0.200
     4.122    15.829     0.200
     4.106    15.461     0.200
     4.223    15.887     0.200
     4.316    14.055     0.200
     4.370    14.495     0.200
     4.365    13.492     0.200
     4.541    13.816     0.200
     4.559    17.128     0.200
     4.624    15.024     0.200
     4.658    16.284     0.200
     4.734    14.500     0.200
     4.734    15.247     0.200
     4.749    16.204     0.200
     4.756    15.717     0.200
     4.824    16.132     0.200
     4.832    14.280     0.200
     4.853    14.216     0.200
     4.870    14.917     0.200
     4.915    14.364     0.200
     4.926    15.845     0.200
     4.980    15.542     0.200
     4.976    17.300     0.200
     4.976    14.916     0.200
     4.978    16.300     0.200
     5.030    14.660     0.200
     5.019    16.600     0.200
     5.353    15.588     0.200
     5.325    17.019     0.200
     5.435    16.196     0.200
     5.435    16.034     0.200
     5.467    16.664     0.200
     5.565    16.669     0.200
     5.623    17.677     0.200
     5.623    17.377     0.200
     5.644    18.008     0.200
     5.657    17.064     0.200
     5.814    16.887     0.200
     5.884    18.601     0.200
     5.917    17.346     0.200
     5.939    17.124     0.200
     5.922    17.489     0.200
     5.953    17.632     0.200
     5.968    19.466     0.200
     6.010    17.402     0.200
     6.064    18.242     0.200
     6.080    19.046     0.200
     6.089    17.605     0.200
     6.089    18.387     0.200
     6.121    17.619     0.200
     6.162    18.301     0.200
     6.184    18.384     0.200
     6.192    17.913     0.200
     6.327    18.639     0.200
     6.357    18.745     0.200
     6.381    18.529     0.200
     6.429    20.330     0.200
     6.570    19.025     0.200
     6.689    19.124     0.200
     6.749    19.546     0.200
     6.749    20.141     0.200
     6.769    21.209     0.200
     6.838    19.467     0.200
     7.007    23.702     0.200
     6.972    20.072     0.200
     7.048    19.132     0.200
     7.115    19.918     0.200
     7.133    19.343     0.200
     7.133    19.218     0.200
     7.219    22.818     0.200
     7.280    20.329     0.200
     7.360    21.940     0.200
     7.429    19.687     0.200
     7.429    19.887     0.200
     7.543    17.863     0.200
     7.539    20.223     0.200
     7.539    20.503     0.200
     7.630    21.131     0.200
     7.630    21.511     0.200
     7.673    20.546     0.200
     7.703    23.215     0.200
     7.870    22.879     0.200
     7.870    23.753     0.200
     8.050    22.128     0.200
     8.100    21.560     0.200
     8.197    21.623     0.200
     8.197    20.523     0.200
     8.218    20.354     0.200
     8.316    22.835     0.200
     8.311    24.635     0.200
     8.471    23.097     0.200
     8.471    25.364     0.200
     8.471    22.828     0.200
     8.616    25.713     0.200
     8.666    21.404     0.200
     8.761    23.744     0.200
     9.100    25.087     0.200
     9.639    24.295     0.200
     9.871    24.030     0.200
    13.970    34.214     0.200
    18.345    38.834     0.200
    18.374    38.858     0.200
    19.904    41.527     0.200
     1.471    10.164     0.200
     1.483     9.077     0.200
     1.494     9.475     0.200
     1.526     9.950     0.200
     1.606     9.479     0.200
     1.733    11.296     0.200
     1.851    11.910     0.200
     1.867    11.003     0.200
     1.895    10.967     0.200
     2.277    12.251     0.200
     2.283    11.979     0.200
     2.234    11.984     0.200
     2.482    12.830     0.200
     2.585    13.442     0.200
     2.698    12.575     0.200
     2.709    13.397     0.200
     3.041    13.178     0.200
     3.044    12.640     0.200
     3.044    13.140     0.200
     3.281    13.778     0.200
     3.370    14.042     0.200
     3.408    13.799     0.200
     3.478    15.840     0.200
     3.464    14.738     0.200
     3.464    14.338     0.200
     3.471    14.254     0.200
     3.574    14.361     0.200
     3.574    14.561     0.200
     3.574    14.801     0.200
     3.628    14.731     0.200
     3.670    15.052     0.200
     3.839    15.567     0.200
     3.839    16.666     0.200
     3.839    16.466     0.200
     3.887    16.304     0.200
     3.887    15.904     0.200
     3.902    16.369     0.200
     3.902    14.899     0.200
     3.952    16.152     0.200
     3.959    15.899     0.200
     3.959    16.099     0.200
     3.999    16.997     0.200
     3.999    15.698     0.200
     4.041    15.658     0.200
     4.119    17.200     0.200
     4.119    16.301     0.200
     4.149    15.450     0.200
     4.156    17.472     0.200
     4.156    16.272     0.200
     4.198    14.911     0.200
     4.238    16.421     0.200
     4.284    16.175     0.200
     4.284    16.475     0.200
     4.354    18.009     0.200
     4.315    17.125     0.200
     4.335    17.055     0.200
     4.367    17.008     0.200
     4.354    17.859     0.200
     4.606    16.812     0.200
     4.620    19.287     0.200
     4.669    16.978     0.200
     4.669    17.139     0.200
     4.659    18.860     0.200
     4.688    17.761     0.200
     4.765    16.957     0.200
     4.766    14.742     0.200
     4.766    16.142     0.200
     4.856    15.921     0.200
     5.002    15.982     0.200
     5.097    20.341     0.200
     5.137    17.142     0.200
     5.112    17.715     0.200
     5.134    17.208     0.200
     5.119    18.333     0.200
     5.168    16.813     0.200
     5.193    15.884     0.200
     5.229    17.072     0.200
     5.240    19.053     0.200
     5.273    17.031     0.200
     5.292    17.185     0.200
     5.307    19.038     0.200
     5.308    17.938     0.200
     5.324    17.473     0.200
     5.394    17.070     0.200
     5.463    17.419     0.200
     5.500    18.079     0.200
     5.568    18.011     0.200
     5.594    19.265     0.200
     5.618    17.166     0.200
     5.624    17.633     0.200
     5.624    18.333     0.200
     5.670    17.673     0.200
     5.738    18.730     0.200
     5.783    18.063     0.200
     5.906    18.489     0.200
     5.924    18.933     0.200
     6.173    19.232     0.200
     6.216    20.471     0.200
     6.279    22.085     0.200
     6.318    21.454     0.200
     6.353    19.440     0.200
     6.361    19.957     0.200
     6.360    20.942     0.200
     6.429    19.509     0.200
     6.481    20.896     0.200
     6.481    20.533     0.200
     6.496    22.750     0.200
     6.470    20.558     0.200
     6.588    20.383     0.200
     6.607    19.711     0.200
     6.723    20.110     0.200
     6.805    19.998     0.200
     6.839    20.288     0.200
     7.014    22.991     0.200
     7.134    21.009     0.200
     7.503    22.187     0.200
     7.795    23.593     0.200
     1.458     8.889     0.200
     1.654     9.233     0.200
     2.807    11.691     0.200
     2.817    11.980     0.200
     2.817    12.082     0.200
     3.009    12.840     0.200
     3.009    12.738     0.200
     3.067    13.353     0.200
     3.146    12.745     0.200
     3.160    13.669     0.200
     3.239    13.548     0.200
     3.258    13.328     0.200
     3.258    13.023     0.200
     3.357    13.672     0.200
     3.357    13.829     0.200
     3.382    15.075     0.200
     3.382    14.075     0.200
     3.407    13.605     0.200
     3.580    14.628     0.200
     3.580    13.769     0.200
     3.657    14.467     0.200
     3.653    14.345     0.200
     3.653    14.806     0.200
     3.755    15.030     0.200
     3.763    14.866     0.200
     3.893    14.926     0.200
     3.901    15.122     0.200
     3.929    13.755     0.200
     3.928    15.511     0.200
     3.934    15.835     0.200
     3.934    16.038     0.200
     4.116    16.317     0.200
     4.157    15.767     0.200
     4.157    16.423     0.200
     4.171    16.145     0.200
     4.171    15.044     0.200
     4.223    14.396     0.200
     4.235    15.627     0.200
     4.235    15.909     0.200
     4.468    17.415     0.200
     4.478    17.060     0.200
     4.494    16.339     0.200
     4.506    14.558     0.200
     4.553    17.286     0.200
     4.553    17.388     0.200
     4.620    16.371     0.200
     4.692    14.898     0.200
     4.800    18.000     0.200
     4.932    16.259     0.200
     4.932    15.673     0.200
     4.923    17.597     0.200
     4.930    17.787     0.200
     4.961    16.203     0.200
     5.047    16.025     0.200
     5.059    15.912     0.200
     5.065    17.711     0.200
     5.071    15.474     0.200
     5.095    15.960     0.200
     5.126    17.614     0.200
     5.149    18.612     0.200
     5.173    18.526     0.200
     5.199    17.972     0.200
     5.220    17.688     0.200
     5.220    18.071     0.200
     5.227    17.528     0.200
     5.289    17.785     0.200
     5.315    17.856     0.200
     5.364    19.061     0.200
     5.364    16.452     0.200
     5.352    17.384     0.200
     5.354    18.645     0.200
     5.360    18.340     0.200
     5.374    18.312     0.200
     5.441    16.860     0.200
     5.515    18.600     0.200
     5.535    16.988     0.200
     5.544    18.421     0.200
     5.582    17.872     0.200
     5.606    19.536     0.200
     5.606    18.974     0.200
     5.668    19.194     0.200
     5.685    17.118     0.200
     5.685    16.861     0.200
     5.690    18.070     0.200
     5.690    18.476     0.200
     5.719    18.771     0.200
     5.783    18.898     0.200
     5.883    19.510     0.200
     5.885    19.167     0.200
     5.899    17.873     0.200
     5.894    19.767     0.200
     5.911    19.399     0.200
     5.917    19.398     0.200
     5.921    20.586     0.200
     5.946    19.238     0.200
     5.980    21.146     0.200
     5.997    19.243     0.200
     5.997    18.588     0.200
     6.035    18.507     0.200
     6.052    18.433     0.200
     6.064    17.128     0.200
     6.088    24.034     0.200
     6.140    21.600     0.200
     6.158    21.124     0.200
     6.133    20.106     0.200
     6.133    20.278     0.200
     6.174    19.283     0.200
     6.162    19.241     0.200
     6.197    18.598     0.200
     6.204    21.653     0.200
     6.224    18.873     0.200
     6.232    20.489     0.200
     6.232    20.817     0.200
     6.260    18.797     0.200
     6.265    19.768     0.200
     6.282    19.004     0.200
     6.276    18.830     0.200
     6.266    20.238     0.200
     6.266    21.120     0.200
     6.324    18.650     0.200
     6.329    19.502     0.200
     6.343    21.082     0.200
     6.367    21.038     0.200
     6.382    18.659     0.200
     6.386    20.930     0.200
     6.415    21.291     0.200
     6.411    21.580     0.200
     6.425    19.359     0.200
     6.425    19.961     0.200
     6.561    19.331     0.200
     6.561    19.510     0.200
     6.578    19.088     0.200
     6.576    20.792     0.200
     6.582    19.804     0.200
     6.600    21.163     0.200
     6.608    21.429     0.200
     6.623    20.956     0.200
     6.623    21.464     0.200
     6.637    21.378     0.200
     6.660    20.781     0.200
     6.688    20.261     0.200
     6.701    20.483     0.200
     6.737    22.335     0.200
     6.737    20.061     0.200
     6.739    20.335     0.200
     6.746    20.996     0.200
     6.776    21.472     0.200
     6.862    21.174     0.200
     6.871    20.140     0.200
     6.866    21.257     0.200
     6.871    19.953     0.200
     6.909    19.870     0.200
     6.987    22.968     0.200
     6.997    19.656     0.200
     6.990    19.989     0.200
     6.998    21.103     0.200
     6.998    21.228     0.200
     7.037    21.124     0.200
     7.044    21.856     0.200
     7.079    21.027     0.200
     7.098    20.430     0.200
     7.158    21.734     0.200
     7.181    21.802     0.200
     7.249    22.681     0.200
     7.251    21.884     0.200
     7.255    21.688     0.200
     7.251    21.982     0.200
     7.268    20.937     0.200
     7.270    21.091     0.200
     7.277    24.100     0.200
     7.311    19.597     0.200
     7.378    24.974     0.200
     7.452    21.816     0.200
     7.484    20.673     0.200
     7.517    23.337     0.200
     7.535    21.918     0.200
     7.554    21.699     0.200
     7.605    22.541     0.200
     7.636    22.243     0.200
     7.694    21.533     0.200
     7.784    22.478     0.200
     7.818    20.439     0.200
     7.818    21.517     0.200
     8.017    24.340     0.200
     8.222    24.468     0.200
     8.292    25.580     0.200
     8.401    26.096     0.200
     8.401    23.307     0.200
     8.501    25.219     0.200
     8.692    24.209     0.200
     8.924    25.149     0.200
     8.924    26.329     0.200
     9.379    26.982     0.200
     9.815    24.708     0.200
    10.043    26.219     0.200
    18.161    39.034     0.200
    18.389    44.393     0.200
    20.321    42.003     0.200
     1.482    10.366     0.200
     1.483     9.858     0.200
     1.555     8.854     0.200
     1.580     9.552     0.200
     1.601     9.767     0.200
     1.690    10.433     0.200
     1.694    10.375     0.200
     1.697    11.067     0.200
     1.823    10.408     0.200
     1.916    11.002     0.200
     1.937    11.127     0.200
     4.388    16.591     0.200
     4.581    14.988     0.200
     5.140    16.344     0.200
     5.183    16.148     0.200
     5.739    17.629     0.200
     5.825    17.817     0.200
     5.837    18.917     0.200
     5.934    18.463     0.200
     5.951    18.118     0.200
     6.013    18.190     0.200
     6.899    20.293     0.200
     6.970    19.296     0.200
     7.073    22.025     0.200
     7.265    19.830     0.200
     7.635    26.102     0.200
     8.056    20.887     0.200
     1.619     9.025     0.200
     2.161     9.801     0.200
     2.313     9.889     0.200
     2.330    10.837     0.200
     2.367    10.164     0.200
     2.557    11.445     0.200
     2.747    11.543     0.200
     2.750    11.795     0.200
     2.791    11.593     0.200
     2.844    11.205     0.200
     3.035    12.862     0.200
     3.279    13.299     0.200
     3.734    14.187     0.200
     3.785    14.601     0.200
     3.928    14.992     0.200
     3.959    14.491     0.200
     4.221    16.315     0.200
     4.273    18.970     0.200
     4.374    16.716     0.200
     4.424    15.892     0.200
     4.595    17.652     0.200
     4.634    16.619     0.200
     4.682    17.145     0.200
     4.748    17.078     0.200
     4.893    15.205     0.200
     4.954    15.547     0.200
     5.060    18.066     0.200
     5.131    18.219     0.200
     5.145    15.864     0.200
     5.309    19.387     0.200
     5.362    15.384     0.200
     5.570    16.121     0.200
     5.816    16.494     0.200
     5.923    20.536     0.200
     6.094    17.678     0.200
     6.120    17.253     0.200
     6.278    18.017     0.200
     7.101    19.694     0.200
     7.130    24.159     0.200
     7.392    20.255     0.200
     9.266    26.271     0.200
     1.433     8.906     0.200
     1.440     8.998     0.200
     1.466     8.958     0.200
     1.543     9.382     0.200
     1.580     9.113     0.200
     1.595     9.024     0.200
     1.608     8.927     0.200
     1.616    10.482     0.200
     1.611     9.830     0.200
     1.613     9.594     0.200
     1.633     9.267     0.200
     1.658     9.437     0.200
     1.665     9.365     0.200
     1.682     9.087     0.200
     1.697     9.321     0.200
     1.718     9.978     0.200
     1.728     9.865     0.200
     1.828     9.861     0.200
     1.832     9.951     0.200
     1.832     9.576     0.200
     1.874    10.960     0.200
     1.874     9.733     0.200
     1.998    10.044     0.200
     2.006     9.898     0.200
     2.118     9.622     0.200
     2.261    11.315     0.200
     2.333    10.444     0.200
     2.349    10.115     0.200
     2.377    10.608     0.200
     2.549    11.054     0.200
     2.579    11.468     0.200
     2.667    11.826     0.200
     2.769    12.269     0.200
     2.907    11.833     0.200
     2.976    13.043     0.200
     3.147    12.616     0.200
     3.281    13.762     0.200
     3.281    13.551     0.200
     3.494    14.254     0.200
     3.494    14.098     0.200
     3.591    14.590     0.200
     3.591    13.973     0.200
     3.591    14.395     0.200
     3.621    14.623     0.200
     3.668    13.313     0.200
     3.769    14.503     0.200
     3.823    15.231     0.200
     3.830    16.081     0.200
     3.830    15.066     0.200
     3.830    15.284     0.200
     3.862    16.911     0.200
     3.872    13.692     0.200
     3.874    13.094     0.200
     3.907    14.578     0.200
     3.907    15.063     0.200
     3.913    15.550     0.200
     3.929    12.762     0.200
     3.997    14.939     0.200
     4.051    15.987     0.200
     4.077    16.223     0.200
     4.077    16.121     0.200
     4.090    14.969     0.200
     4.103    13.212     0.200
     4.180    18.939     0.200
     4.260    15.955     0.200
     4.273    15.504     0.200
     4.318    16.432     0.200
     4.318    15.791     0.200
     4.316    16.291     0.200
     4.348    14.583     0.200
     4.350    16.725     0.200
     4.350    15.850     0.200
     4.390    14.345     0.200
     4.390    13.869     0.200
     4.422    15.805     0.200
     4.414    16.866     0.200
     4.414    15.155     0.200
     4.414    15.975     0.200
     4.431    14.374     0.200
     4.575    14.460     0.200
     4.578    14.462     0.200
     4.578    14.329     0.200
     4.602    15.618     0.200
     4.606    15.515     0.200
     4.619    14.437     0.200
     4.652    15.065     0.200
     4.727    18.285     0.200
     4.727    17.972     0.200
     4.727    17.832     0.200
     4.733    17.056     0.200
     4.799    17.091     0.200
     4.850    16.841     0.200
     4.850    15.583     0.200
     4.850    16.052     0.200
     4.850    15.698     0.200
     4.850    15.346     0.200
     4.904    15.205     0.200
     4.923    14.959     0.200
     4.923    14.834     0.200
     4.960    16.493     0.200
     4.975    18.515     0.200
     5.025    16.173     0.200
     5.026    15.964     0.200
     5.042    16.764     0.200
     5.042    16.069     0.200
     5.062    18.170     0.200
     5.071    16.004     0.200
     5.102    18.041     0.200
     5.101    17.758     0.200
     5.321    16.370     0.200
     5.327    19.211     0.200
     5.379    16.938     0.200
     5.399    18.393     0.200
     5.454    17.347     0.200
     5.503    17.378     0.200
     5.503    16.863     0.200
     5.503    16.620     0.200
     5.534    19.172     0.200
     5.624    17.763     0.200
     5.624    16.786     0.200
     5.624    16.888     0.200
     5.725    17.954     0.200
     5.733    19.716     0.200
     5.732    19.475     0.200
     5.770    18.857     0.200
     5.879    17.858     0.200
     5.890    18.657     0.200
     5.890    18.478     0.200
     5.899    16.814     0.200
     5.940    17.716     0.200
     5.940    18.677     0.200
     5.961    19.993     0.200
     6.012    18.740     0.200
     6.012    18.935     0.200
     6.032    19.291     0.200
     6.061    20.179     0.200
     6.063    18.404     0.200
     6.063    18.536     0.200
     6.086    20.741     0.200
     6.090    18.782     0.200
     6.094    18.837     0.200
     6.121    19.590     0.200
     6.143    21.397     0.200
     6.143    22.826     0.200
     6.149    18.503     0.200
     6.171    18.539     0.200
     6.173    19.498     0.200
     6.197    19.816     0.200
     6.197    19.222     0.200
     6.197    19.519     0.200
     6.224    18.894     0.200
     6.224    18.644     0.200
     6.233    19.004     0.200
     6.233    19.371     0.200
     6.251    18.940     0.200
     6.267    19.447     0.200
     6.325    18.816     0.200
     6.288    20.303     0.200
     6.339    18.975     0.200
     6.339    19.615     0.200
     6.368    19.559     0.200
     6.401    18.487     0.200
     6.401    19.596     0.200
     6.410    20.676     0.200
     6.463    19.457     0.200
     6.493    22.613     0.200
     6.524    19.038     0.200
     6.542    21.339     0.200
     6.545    19.764     0.200
     6.560    20.525     0.200
     6.590    21.139     0.200
     6.590    20.373     0.200
     6.598    20.027     0.200
     6.630    19.554     0.200
     6.675    20.304     0.200
     6.675    20.086     0.200
     6.624    23.835     0.200
     6.718    21.357     0.200
     6.583    25.789     0.200
     6.746    20.162     0.200
     6.746    24.358     0.200
     6.759    21.292     0.200
     6.759    20.604     0.200
     6.781    21.144     0.200
     6.845    21.358     0.200
     6.845    19.756     0.200
     6.876    20.762     0.200
     6.911    23.291     0.200
     6.908    22.576     0.200
     6.918    19.857     0.200
     6.940    22.577     0.200
     6.939    20.111     0.200
     6.962    23.838     0.200
     6.968    20.868     0.200
     7.032    19.684     0.200
     7.084    22.218     0.200
     7.099    20.276     0.200
     7.112    22.084     0.200
     7.139    23.504     0.200
     7.137    23.622     0.200
     7.166    20.853     0.200
     7.173    22.263     0.200
     7.173    21.333     0.200
     7.173    21.716     0.200
     7.199    24.153     0.200
     7.199    23.473     0.200
     7.220    20.128     0.200
     7.220    19.753     0.200
     7.220    19.628     0.200
     7.220    19.800     0.200
     7.238    23.845     0.200
     7.238    22.790     0.200
     7.264    19.631     0.200
     7.274    22.135     0.200
     7.274    20.807     0.200
     7.297    22.088     0.200
     7.297    21.932     0.200
     7.488    19.812     0.200
     7.501    22.583     0.200
     7.501    20.942     0.200
     7.503    23.169     0.200
     7.503    22.427     0.200
     7.513    20.106     0.200
     7.527    20.363     0.200
     7.553    20.877     0.200
     7.576    21.861     0.200
     7.592    20.157     0.200
     7.592    19.790     0.200
     7.611    23.821     0.200
     7.658    21.717     0.200
     7.667    20.694     0.200
     7.705    24.289     0.200
     7.718    24.624     0.200
     7.718    24.116     0.200
     7.743    20.172     0.200
     7.746    23.836     0.200
     7.752    22.343     0.200
     7.767    23.378     0.200
     7.767    22.683     0.200
     7.767    21.738     0.200
     7.772    21.602     0.200
     7.789    21.989     0.200
     7.901    24.024     0.200
     7.916    21.901     0.200
     7.946    23.712     0.200
     7.963    25.863     0.200
     7.963    24.754     0.200
     7.972    24.659     0.200
     8.020    23.214     0.200
     8.017    22.218     0.200
     8.044    21.424     0.200
     8.044    21.228     0.200
     8.044    20.986     0.200
     8.096    24.347     0.200
     8.096    22.003     0.200
     8.096    21.777     0.200
     8.096    21.637     0.200
     8.111    21.827     0.200
     8.128    25.037     0.200
     8.159    24.371     0.200
     8.179    24.065     0.200
     8.179    22.823     0.200
     8.213    23.845     0.200
     8.212    24.444     0.200
     8.212    23.358     0.200
     8.212    23.850     0.200
     8.291    21.374     0.200
     8.291    20.819     0.200
     8.300    21.126     0.200
     8.308    23.628     0.200
     8.314    25.167     0.200
     8.327    24.149     0.200
     8.332    22.854     0.200
     8.362    24.549     0.200
     8.362    23.502     0.200
     8.362    23.901     0.200
     8.390    24.317     0.200
     8.390    24.466     0.200
     8.389    24.341     0.200
     8.389    22.036     0.200
     8.415    23.578     0.200
     8.425    25.371     0.200
     8.438    24.298     0.200
     8.449    21.736     0.200
     8.467    26.361     0.200
     8.520    23.030     0.200
     8.520    22.554     0.200
     8.531    24.534     0.200
     8.540    26.000     0.200
     8.545    21.662     0.200
     8.675    22.048     0.200
     8.693    26.540     0.200
     8.702    27.565     0.200
     8.768    23.404     0.200
     8.768    23.763     0.200
     8.892    24.249     0.200
     8.982    24.160     0.200
     9.027    27.621     0.200
     9.027    27.441     0.200
     9.029    27.343     0.200
     9.029    27.132     0.200
     9.029    24.405     0.200
     9.231    23.615     0.200
     9.246    24.184     0.200
     9.254    27.340     0.200
     9.254    27.027     0.200
     9.272    27.448     0.200
     9.272    25.448     0.200
     9.272    28.768     0.200
     9.304    27.207     0.200
     9.356    23.698     0.200
     9.359    27.406     0.200
     9.359    25.562     0.200
     9.437    24.411     0.200
     9.449    26.922     0.200
     9.460    24.085     0.200
     9.551    24.104     0.200
     9.551    24.229     0.200
     9.581    27.068     0.200
     9.598    27.012     0.200
     9.598    25.387     0.200
     9.611    24.529     0.200
     9.620    27.315     0.200
     9.648    24.191     0.200
     9.651    24.462     0.200
     9.677    27.706     0.200
     9.677    27.261     0.200
     9.677    27.456     0.200
     9.688    25.128     0.200
     9.683    26.334     0.200
     9.716    24.638     0.200
     9.721    25.542     0.200
     9.721    24.901     0.200
     9.760    25.934     0.200
     9.750    30.444     0.200
     9.750    29.952     0.200
     9.760    28.183     0.200
     9.816    25.828     0.200
     9.980    27.769     0.200
     9.980    26.222     0.200
     9.980    26.441     0.200
     9.980    26.847     0.200
    10.020    27.174     0.200
    10.103    26.821     0.200
    10.107    27.934     0.200
    10.151    27.623     0.200
    10.144    27.906     0.200
    10.219    28.457     0.200
    10.219    27.200     0.200
    10.236    29.230     0.200
    10.296    27.034     0.200
    10.328    29.715     0.200
    10.402    27.590     0.200
    10.405    29.534     0.200
    10.433    28.867     0.200
    10.433    27.765     0.200
    10.433    28.523     0.200
    10.604    29.417     0.200
    10.676    32.292     0.200
    10.705    30.451     0.200
    10.742    28.167     0.200
    10.742    27.589     0.200
    10.779    28.418     0.200
    10.869    29.939     0.200
    10.868    27.007     0.200
    10.877    28.652     0.200
    10.930    29.591     0.200
    10.973    28.382     0.200
    11.049    28.770     0.200
    11.095    29.144     0.200
    11.121    26.705     0.200
    11.361    32.800     0.200
    11.740    30.881     0.200
    11.854    36.440     0.200
    12.298    32.072     0.200
    12.786    33.586     0.200
    12.822    31.853     0.200
    12.876    32.623     0.200
    13.382    34.018     0.200
    13.451    34.108     0.200
    13.460    34.110     0.200
    13.464    34.157     0.200
    13.471    34.176     0.200
    13.495    34.205     0.200
    13.505    34.178     0.200
    13.507    33.862     0.200
    13.519    32.548     0.200
    13.519    34.220     0.200
    13.519    34.220     0.200
    13.519    33.423     0.200
    13.507    34.268     0.200
    13.532    34.264     0.200
    13.601    32.967     0.200
    13.612    34.273     0.200
    13.858    36.462     0.200
    14.119    34.213     0.200
    14.249    36.199     0.200
    14.290    35.263     0.200
    14.290    34.192     0.200
    14.516    36.687     0.200
    14.516    36.382     0.200
    14.516    38.608     0.200
    14.528    36.651     0.200
    14.610    35.482     0.200
    14.610    36.724     0.200
    15.137    37.120     0.200
    15.137    36.831     0.200
    15.531    34.308     0.200
    15.531    35.909     0.200
    16.080    38.896     0.200
    16.512    39.683     0.200
    16.789    39.516     0.200
    16.814    39.475     0.200
    18.006    38.574     0.200
    18.006    38.347     0.200
    18.014    39.186     0.200
    18.019    39.184     0.200
    18.281    39.056     0.200
    18.465    40.992     0.200
    18.465    40.601     0.200
    18.465    40.202     0.200
    18.568    40.361     0.200
    18.832    39.603     0.200
    19.068    40.569     0.200
    19.144    39.473     0.200
    19.209    40.419     0.200
    19.524    40.245     0.200
    19.524    39.847     0.200
    19.527    39.898     0.200
    19.674    41.635     0.200
    19.821    41.881     0.200
    19.943    43.353     0.200
    20.300    41.478     0.200
    20.300    40.251     0.200
    20.300    39.876     0.200
    20.320    42.497     0.200
    20.639    40.134     0.200
    20.806    39.878     0.200
    20.806    40.574     0.200
    20.951    40.530     0.200
     1.547     9.718     0.200
     1.550     9.648     0.200
     1.593     9.971     0.200
     1.589     9.840     0.200
     1.602     9.540     0.200
     1.629    11.370     0.200
     1.639    10.809     0.200
     1.625     9.492     0.200
     1.665    11.059     0.200
     1.667    11.280     0.200
     1.673    10.729     0.200
     1.673    10.089     0.200
     1.673    11.389     0.200
     1.696     9.495     0.200
     1.661     9.431     0.200
     1.679     9.681     0.200
     1.685     9.846     0.200
     1.688     9.982     0.200
     1.728    11.150     0.200
     1.728    11.791     0.200
     1.699     9.881     0.200
     1.707     9.826     0.200
     1.756    11.284     0.200
     1.760    11.362     0.200
     1.784    10.150     0.200
     1.807     9.845     0.200
     1.804    11.152     0.200
     1.805    11.175     0.200
     1.798    10.884     0.200
     1.798    11.334     0.200
     1.768    10.257     0.200
     1.791    10.459     0.200
     1.791    10.619     0.200
     1.822    10.323     0.200
     1.822     9.878     0.200
     1.822    10.118     0.200
     1.866    11.544     0.200
     1.866    10.736     0.200
     1.869    10.012     0.200
     1.869    10.182     0.200
     1.958    10.143     0.200
     1.970    10.535     0.200
     2.147     9.885     0.200
     2.226    10.287     0.200
     2.245    11.087     0.200
     2.349    11.010     0.200
     2.710    12.920     0.200
     2.770    13.228     0.200
     3.116    13.819     0.200
     3.159    13.209     0.200
     3.181    14.390     0.200
     3.177    13.921     0.200
     3.246    12.891     0.200
     3.246    13.541     0.200
     3.324    14.582     0.200
     3.324    14.454     0.200
     3.324    13.724     0.200
     3.324    13.584     0.200
     3.324    14.176     0.200
     3.376    14.327     0.200
     3.371    14.687     0.200
     3.426    14.665     0.200
     3.470    15.316     0.200
     3.467    14.807     0.200
     3.438    14.385     0.200
     3.527    15.278     0.200
     3.527    15.092     0.200
     3.584    15.791     0.200
     3.595    14.076     0.200
     3.629    15.280     0.200
     3.634    14.719     0.200
     3.686    14.565     0.200
     3.760    16.101     0.200
     3.754    15.738     0.200
     3.801    15.717     0.200
     3.784    14.832     0.200
     3.784    15.144     0.200
     3.780    16.144     0.200
     3.829    16.677     0.200
     3.845    15.677     0.200
     3.863    16.662     0.200
     3.857    15.607     0.200
     3.894    16.495     0.200
     3.912    16.429     0.200
     4.040    16.732     0.200
     3.960    13.873     0.200
     3.934    16.517     0.200
     3.978    15.525     0.200
     3.997    15.407     0.200
     4.019    17.222     0.200
     4.025    16.298     0.200
     4.004    15.861     0.200
     4.064    18.163     0.200
     4.124    14.728     0.200
     4.095    16.163     0.200
     4.147    17.321     0.200
     4.147    16.789     0.200
     4.169    16.864     0.200
     4.166    15.278     0.200
     4.145    17.838     0.200
     4.177    16.566     0.200
     4.177    16.763     0.200
     4.184    16.417     0.200
     4.222    16.733     0.200
     4.250    14.745     0.200
     4.250    15.175     0.200
     4.248    14.694     0.200
     4.283    16.857     0.200
     4.303    16.769     0.200
     4.303    16.107     0.200
     4.303    16.259     0.200
     4.309    14.978     0.200
     4.317    16.870     0.200
     4.317    17.107     0.200
     4.330    14.901     0.200
     4.373    15.402     0.200
     4.356    16.514     0.200
     4.396    15.108     0.200
     4.396    17.588     0.200
     4.358    20.664     0.200
     4.432    14.956     0.200
     4.410    18.172     0.200
     4.414    17.646     0.200
     4.407    18.786     0.200
     4.473    14.989     0.200
     4.498    17.845     0.200
     4.530    15.621     0.200
     4.519    17.569     0.200
     4.571    15.582     0.200
     4.615    15.959     0.200
     4.614    15.494     0.200
     4.616    16.247     0.200
     4.637    15.378     0.200
     4.637    17.463     0.200
     4.628    18.215     0.200
     4.686    16.337     0.200
     4.656    17.771     0.200
     4.656    17.367     0.200
     4.702    15.762     0.200
     4.726    16.765     0.200
     4.744    17.794     0.200
     4.808    15.667     0.200
     4.808    15.447     0.200
     4.814    16.083     0.200
     4.776    16.056     0.200
     4.812    17.644     0.200
     4.841    18.482     0.200
     4.851    15.660     0.200
     4.858    18.792     0.200
     4.882    18.793     0.200
     4.912    18.376     0.200
     5.025    18.248     0.200
     5.019    18.561     0.200
     5.021    19.211     0.200
     5.054    19.174     0.200
     5.059    18.297     0.200
     5.164    20.370     0.200
     5.199    16.434     0.200
     5.224    18.575     0.200
     5.289    18.892     0.200
     5.257    18.662     0.200
     5.271    19.657     0.200
     5.355    19.007     0.200
     5.371    18.698     0.200
     5.378    19.289     0.200
     5.443    18.158     0.200
     5.443    17.884     0.200
     5.440    19.186     0.200
     5.441    18.558     0.200
     5.470    18.724     0.200
     5.477    20.045     0.200
     5.492    18.604     0.200
     5.513    18.595     0.200
     5.518    18.917     0.200
     5.558    19.397     0.200
     5.548    20.634     0.200
     5.545    18.740     0.200
     5.575    19.001     0.200
     5.603    19.115     0.200
     5.674    19.571     0.200
     5.649    19.626     0.200
     5.481    20.983     0.200
     5.652    19.690     0.200
     5.652    18.950     0.200
     5.682    19.242     0.200
     5.738    19.064     0.200
     5.809    18.495     0.200
     5.819    18.447     0.200
     5.815    19.795     0.200
     5.860    23.726     0.200
     5.867    17.378     0.200
     5.850    20.849     0.200
     5.903    19.931     0.200
     5.888    20.236     0.200
     5.927    20.055     0.200
     5.960    20.564     0.200
     5.975    18.908     0.200
     5.985    20.313     0.200
     5.955    19.796     0.200
     5.990    20.152     0.200
     5.982    20.254     0.200
     6.036    19.603     0.200
     6.043    20.362     0.200
     6.028    20.628     0.200
     6.027    19.482     0.200
     6.027    19.731     0.200
     6.106    20.979     0.200
     6.105    19.940     0.200
     6.105    18.840     0.200
     6.133    20.024     0.200
     6.141    18.664     0.200
     6.188    21.728     0.200
     6.141    21.211     0.200
     6.188    19.644     0.200
     6.246    21.410     0.200
     6.246    21.291     0.200
     6.246    21.190     0.200
     6.338    20.372     0.200
     6.368    20.793     0.200
     6.514    23.625     0.200
     6.514    20.765     0.200
     6.559    22.976     0.200
     6.580    22.788     0.200
     6.594    23.066     0.200
     6.641    22.084     0.200
     6.729    22.253     0.200
     6.832    21.951     0.200
     6.855    20.338     0.200
     7.003    19.352     0.200
     7.054    26.106     0.200
     7.065    20.327     0.200
     7.065    20.522     0.200
     7.083    20.865     0.200
     7.146    24.106     0.200
     7.209    25.792     0.200
     7.209    21.433     0.200
     7.167    21.679     0.200
     7.304    24.739     0.200
     7.315    22.090     0.200
     7.315    22.329     0.200
     7.315    23.720     0.200
     7.359    20.590     0.200
     7.359    20.200     0.200
     7.455    24.733     0.200
     7.579    25.800     0.200
     7.626    21.979     0.200
     7.655    25.730     0.200
     7.742    26.515     0.200
     7.820    27.427     0.200
     7.926    25.726     0.200
     7.974    21.820     0.200
     8.045    22.382     0.200
     8.167    23.918     0.200
     8.223    26.063     0.200
     8.223    27.430     0.200
     8.250    23.117     0.200
     8.258    22.689     0.200
     8.361    25.906     0.200
     8.378    25.135     0.200
     8.397    22.843     0.200
     8.397    22.533     0.200
     8.497    25.919     0.200
     8.829    27.425     0.200
     8.829    28.277     0.200
     8.829    27.617     0.200
     8.829    25.098     0.200
     8.853    28.065     0.200
     8.966    27.645     0.200
     9.039    28.138     0.200
     9.367    29.018     0.200
     9.374    26.336     0.200
     9.417    28.612     0.200
     9.419    27.815     0.200
     9.475    28.354     0.200
     9.569    25.964     0.200
    10.208    28.562     0.200
    10.208    27.089     0.200
    11.736    30.669     0.200
    11.970    31.234     0.200
    12.709    32.394     0.200
    14.385    37.704     0.200
    14.432    37.826     0.200
    14.432    36.447     0.200
    14.931    35.821     0.200
    17.059    39.440     0.200
    17.361    39.613     0.200
    17.944    39.619     0.200
     3.895    15.642     0.200
     4.317    17.165     0.200
     3.969    15.758     0.200
     3.527    15.147     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.947    19.447     0.200
     3.207    26.014     0.200
     3.862    30.869     0.200
     4.020    29.031     0.200
     6.645    47.391     0.200
     3.028    19.138     0.200
     4.965    32.275     0.200
     4.258    30.565     0.200
     6.894    52.810     0.200
     7.132    53.025     0.200
     4.698    37.420     0.200
     5.454    40.973     0.200
     4.979    32.422     0.200
     5.472    36.766     0.200
     4.036    28.143     0.200
     4.193    29.806     0.200
     4.880    39.291     0.200
     4.806    38.665     0.200
     4.843    35.121     0.200
     5.104    38.187     0.200
     3.028    24.407     0.200
     4.096    31.955     0.200
     4.253    31.118     0.200
     3.405    22.013     0.200
     4.135    27.993     0.200
     4.293    31.155     0.200
     6.866    53.119     0.200
     3.080    25.281     0.200
     4.901    33.033     0.200
     7.352    58.427     0.200
     8.525    67.274     0.200
     4.711    35.500     0.200
     3.179    24.245     0.200
     4.957    34.501     0.200
     5.433    42.338     0.200
     6.465    50.791     0.200
     7.409    58.782     0.200
     4.791    33.044     0.200
     5.553    36.154     0.200
     3.745    23.012     0.200
     3.902    30.680     0.200
     4.700    35.067     0.200
     4.776    33.488     0.200
     8.622    69.096     0.200
     4.414    34.639     0.200
     4.969    36.853     0.200
     6.797    51.527     0.200
     2.932    26.318     0.200
     4.168    28.594     0.200
     4.320    29.320     0.200
     4.485    34.588     0.200
     4.620    34.722     0.200
     5.513    43.916     0.200
     3.643    29.953     0.200
     4.778    33.706     0.200
     3.753    23.954     0.200
     4.480    30.558     0.200
     4.996    33.143     0.200
     5.533    44.177     0.200
     6.790    50.802     0.200
     4.084    33.411     0.200
     6.017    47.531     0.200
     7.236    52.203     0.200
     5.636    45.508     0.200
     3.209    20.316     0.200
     2.721    17.999     0.200
     3.033    19.554     0.200
     4.164    25.666     0.200
     4.272    26.358     0.200
     4.447    31.313     0.200
     8.349    63.776     0.200
     3.728    27.549     0.200
     4.125    28.238     0.200
     6.021    38.720     0.200
     6.088    49.042     0.200
     6.354    44.931     0.200
     6.462    50.382     0.200
     4.159    28.807     0.200
     4.701    35.276     0.200
     3.253    20.521     0.200
     4.598    35.016     0.200
     4.265    30.306     0.200
     4.560    32.656     0.200
     3.091    27.171     0.200
     3.577    23.697     0.200
     4.515    36.581     0.200
     4.354    36.939     0.200
     4.896    32.019     0.200
     5.776    41.031     0.200
     4.344    33.822     0.200
     3.635    31.653     0.200
     4.355    33.260     0.200
     7.491    53.157     0.200
     4.331    32.212     0.200
     4.448    31.945     0.200
     5.881    40.618     0.200
     6.343    45.122     0.200
     4.360    30.925     0.200
     4.922    35.658     0.200
     7.031    49.144     0.200
     4.935    36.144     0.200
     4.521    31.382     0.200
     4.935    38.346     0.200
     6.873    52.133     0.200
     4.261    30.590     0.200
     4.348    31.497     0.200
     3.962    24.998     0.200
     4.341    34.086     0.200
     4.951    36.960     0.200
     5.160    40.017     0.200
     4.348    30.021     0.200
     4.520    35.408     0.200
     4.336    32.930     0.200
     5.946    43.140     0.200
     7.062    50.823     0.200
     9.390    66.154     0.200
     9.967    70.613     0.200
     4.921    35.193     0.200
     4.958    36.060     0.200
     4.915    36.388     0.200
     7.129    50.982     0.200
     7.483    52.238     0.200
     3.939    28.623     0.200
     4.358    32.967     0.200
     6.988    49.385     0.200
     3.196    20.557     0.200
     3.201    22.298     0.200
     7.505    52.832     0.200
     7.379    51.120     0.200
     7.471    51.938     0.200
     8.397    57.135     0.200
     8.807    59.855     0.200
     6.169    41.721     0.200
     6.596    44.736     0.200
     7.396    49.799     0.200
     8.394    57.251     0.200
     2.980    24.227     0.200
     3.464    28.471     0.200
     6.951    50.608     0.200
     2.613    16.408     0.200
     2.728    20.405     0.200
     4.647    31.896     0.200
     4.642    32.559     0.200
     7.288    53.087     0.200
     7.796    54.956     0.200
     3.909    27.568     0.200
     4.065    25.828     0.200
     4.109    24.985     0.200
     2.786    21.101     0.200
     9.718    67.895     0.200
     3.419    21.228     0.200
     7.331    51.585     0.200
     4.680    34.960     0.200
     5.809    38.194     0.200
     6.330    42.214     0.200
     6.560    44.028     0.200
     6.914    46.101     0.200
     6.935    45.256     0.200
     7.132    48.057     0.200
     7.219    48.141     0.200
     7.752    61.116     0.200
     7.893    53.376     0.200
     8.002    53.098     0.200
     8.005    59.969     0.200
     8.621    57.680     0.200
     8.814    67.221     0.200
     6.465    53.321     0.200
     8.807    66.196     0.200
     9.721    67.542     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.580     2.473     0.200
     3.207    15.514     0.200
     3.945    18.403     0.200
     4.678    22.848     0.200
     7.193    32.701     0.200
     7.220    32.689     0.200
     0.535     3.721     0.200
     0.531     4.574     0.200
     0.542     4.047     0.200
     0.690     4.919     0.200
     1.717    10.829     0.200
     1.855     9.223     0.200
     1.879    11.541     0.200
     0.450     3.723     0.200
     0.691     4.909     0.200
     0.866     5.365     0.200
     1.519     9.247     0.200
     1.591     8.300     0.200
     2.710    14.344     0.200
     3.555    15.990     0.200
     4.554    24.325     0.200
     4.759    21.940     0.200
     4.835    20.049     0.200
     4.952    23.684     0.200
     6.027    32.539     0.200
     6.379    26.836     0.200
     8.586    53.275     0.200
     0.665     3.641     0.200
     0.853     5.352     0.200
     2.466    14.233     0.200
     3.096    16.374     0.200
     4.162    19.442     0.200
     7.436    33.734     0.200
     0.773     3.943     0.200
     0.957     5.794     0.200
     2.140    12.787     0.200
     3.191    15.513     0.200
     4.416    22.727     0.200
     5.438    31.899     0.200
     6.186    32.069     0.200
     7.455    33.262     0.200
     0.870     6.886     0.200
     1.916    12.387     0.200
     3.177    15.665     0.200
     4.188    22.669     0.200
     5.962    30.459     0.200
     0.748     3.883     0.200
     1.077     7.045     0.200
     2.122    10.848     0.200
     3.174    17.073     0.200
     6.488    28.899     0.200
     7.721    33.510     0.200
     1.029     7.117     0.200
     1.431     8.428     0.200
     2.072    13.941     0.200
     2.187    12.604     0.200
     0.497     4.038     0.200
     0.686     4.738     0.200
     0.899     7.253     0.200
     2.974    14.532     0.200
     0.488     4.053     0.200
     0.825     6.124     0.200
     1.415     9.234     0.200
     1.656     9.417     0.200
     2.432    17.168     0.200
     2.905    16.849     0.200
     4.125    20.110     0.200
     5.673    33.041     0.200
     0.524     3.629     0.200
     0.930     7.398     0.200
     1.216     8.558     0.200
     1.267     7.969     0.200
     1.977    13.180     0.200
     0.615     4.077     0.200
     0.977     6.846     0.200
     1.259     8.561     0.200
     2.018    10.198     0.200
     2.127    12.427     0.200
     2.251    15.180     0.200
     3.260    18.405     0.200
     4.784    22.915     0.200
     0.527     4.073     0.200
     0.981     7.281     0.200
     1.406     8.320     0.200
     2.029    12.551     0.200
     2.173    13.367     0.200
     2.188    13.594     0.200
     3.186    16.440     0.200
     5.391    26.609     0.200
     5.848    31.483     0.200
     6.213    29.715     0.200
     6.778    36.131     0.200
     7.187    32.350     0.200
     0.503     3.767     0.200
     0.735     4.555     0.200
     1.780    11.757     0.200
     2.026    11.488     0.200
     2.425    16.537     0.200
     2.832    16.084     0.200
     3.449    16.378     0.200
     0.755     3.954     0.200
     0.966     5.589     0.200
     1.168     7.128     0.200
     2.156    12.103     0.200
     2.265    11.827     0.200
     2.402    11.429     0.200
     2.123    14.987     0.200
     3.208    18.327     0.200
     3.140    17.918     0.200
     4.274    18.390     0.200
     6.936    32.824     0.200
     8.432    45.363     0.200
     0.525     3.250     0.200
     0.553     3.921     0.200
     0.559     3.847     0.200
     0.706     6.636     0.200
     2.480    18.435     0.200
     3.862    20.297     0.200
     0.582     4.451     0.200
     0.726     3.566     0.200
     1.024     6.797     0.200
     2.070    11.089     0.200
     3.179    18.542     0.200
     6.116    27.870     0.200
     7.427    37.570     0.200
     8.331    40.019     0.200
     9.716    46.555     0.200
     0.663     4.347     0.200
     1.047     6.666     0.200
     2.086    14.236     0.200
     2.341    13.266     0.200
     3.138    17.962     0.200
     3.222    17.483     0.200
     5.014    24.674     0.200
     8.485    39.564     0.200
     9.798    49.140     0.200
     0.701     4.774     0.200
     1.070     6.465     0.200
     2.107    11.675     0.200
     2.366    13.444     0.200
     3.230    14.961     0.200
     3.725    16.684     0.200
     7.361    35.554     0.200
     0.218     2.879     0.200
     0.532     3.813     0.200
     0.696     4.892     0.200
     0.669     4.912     0.200
     1.664     8.301     0.200
     5.421    23.954     0.200
     5.455    31.063     0.200
     5.659    25.680     0.200
     9.821    44.107     0.200
     0.090     2.496     0.200
     0.408     2.494     0.200
     0.521     3.369     0.200
     0.804     6.365     0.200
     0.909     6.645     0.200
     1.205     8.982     0.200
     1.294     8.154     0.200
     1.443     9.911     0.200
     1.451     9.322     0.200
     2.236    13.153     0.200
     2.659    13.016     0.200
     3.674    17.173     0.200
     6.780    30.924     0.200
     6.780    30.627     0.200
     6.797    29.230     0.200
     8.143    36.019     0.200
     8.848    40.192     0.200
     8.848    44.896     0.200
    10.848    48.649     0.200
     0.093     2.250     0.200
     1.038     8.421     0.200
     0.955     6.393     0.200
     1.170     7.383     0.200
     1.289     7.497     0.200
     1.524     9.754     0.200
     1.771    11.372     0.200
     1.948    13.308     0.200
     1.911    12.735     0.200
     2.157    12.965     0.200
     2.343    13.691     0.200
     2.465    13.764     0.200
     2.759    13.643     0.200
     4.168    22.695     0.200
     4.485    23.490     0.200
     6.400    35.952     0.200
     6.598    33.144     0.200
     8.380    37.741     0.200
     0.108     1.295     0.200
     0.226     1.523     0.200
     0.497     3.255     0.200
     1.217     7.851     0.200
     1.282     8.090     0.200
     1.453     9.404     0.200
     4.432    19.534     0.200
     0.708     5.422     0.200
     1.260     8.084     0.200
     1.366     7.147     0.200
     1.499     9.391     0.200
     1.963    11.076     0.200
     2.025     9.950     0.200
     2.286    10.911     0.200
     2.624    12.463     0.200
     2.774    16.017     0.200
     3.522    16.487     0.200
     4.554    24.943     0.200
     5.343    28.130     0.200
     8.278    42.476     0.200
     0.377     3.470     0.200
     0.527     3.621     0.200
     0.760     6.205     0.200
     6.008    29.150     0.200
     0.747     5.128     0.200
     1.226     7.236     0.200
     1.521     7.696     0.200
     2.075    11.125     0.200
     2.199    11.890     0.200
     2.232    14.322     0.200
     2.340    11.741     0.200
     2.371    16.381     0.200
     3.747    17.925     0.200
     4.053    17.252     0.200
     4.053    23.752     0.200
     4.341    23.889     0.200
     6.154    28.334     0.200
     6.393    32.938     0.200
     6.541    28.712     0.200
     6.549    31.724     0.200
     6.549    36.420     0.200
     6.927    36.213     0.200
     8.471    37.196     0.200
     0.183     1.737     0.200
     0.307     2.984     0.200
     0.670     4.752     0.200
     0.923     5.796     0.200
     1.126     7.327     0.200
     1.142     8.739     0.200
     1.355     9.557     0.200
     1.371     8.768     0.200
     1.730     9.087     0.200
     1.821     9.316     0.200
     2.221    14.855     0.200
     2.747    15.804     0.200
     7.488    32.182     0.200
     0.709     6.175     0.200
     0.922     6.092     0.200
     1.168     7.724     0.200
     1.314     7.313     0.200
     1.587     8.231     0.200
     1.699     9.725     0.200
     1.788    11.083     0.200
     2.380    10.674     0.200
     2.554    13.146     0.200
     2.642    14.428     0.200
     3.736    17.549     0.200
     8.027    38.479     0.200
     0.205     2.494     0.200
     0.664     4.032     0.200
     1.077     8.710     0.200
     1.254     8.642     0.200
     1.475     9.360     0.200
     1.495     9.133     0.200
     1.494    10.442     0.200
     1.539     9.319     0.200
     1.918    13.904     0.200
     1.991    12.840     0.200
     2.015    12.864     0.200
     2.139    13.122     0.200
     2.173    14.713     0.200
     2.430    14.317     0.200
     4.220    23.533     0.200
     6.211    28.692     0.200
     0.600     4.425     0.200
     1.062     6.534     0.200
     1.077     7.568     0.200
     1.441     7.908     0.200
     1.531     8.466     0.200
     1.608     8.371     0.200
     1.872     9.083     0.200
     1.959    12.470     0.200
     1.961    10.046     0.200
     2.252    10.951     0.200
     2.907    13.607     0.200
     3.997    22.790     0.200
     6.483    29.379     0.200
     0.733     6.414     0.200
     1.122     9.080     0.200
     1.022     6.844     0.200
     1.189     9.098     0.200
     1.510     9.246     0.200
     1.767     9.946     0.200
     2.538    13.947     0.200
     6.722    33.222     0.200
     7.664    39.334     0.200
     0.707     3.893     0.200
     0.975     6.858     0.200
     1.079     8.132     0.200
     1.194     8.301     0.200
     1.401     8.484     0.200
     1.691     9.997     0.200
     1.706    11.032     0.200
     2.269    13.166     0.200
     2.539    11.808     0.200
     3.245    15.070     0.200
     4.392    23.891     0.200
     7.703    33.549     0.200
     1.296     8.079     0.200
     1.363     7.896     0.200
     1.455     8.423     0.200
     1.533    10.105     0.200
     1.666     9.158     0.200
     1.782    10.911     0.200
     1.913    12.085     0.200
     1.900    11.029     0.200
     2.159    12.002     0.200
     2.349    11.792     0.200
     2.438    12.858     0.200
     2.450    16.210     0.200
     2.692    13.282     0.200
     2.888    16.894     0.200
     3.677    21.090     0.200
     3.947    22.144     0.200
     4.172    25.011     0.200
     1.310     8.563     0.200
     1.441     8.138     0.200
     1.366     7.618     0.200
     1.680     8.653     0.200
     1.916    10.889     0.200
     2.442    12.756     0.200
     2.693    13.221     0.200
     5.052    24.699     0.200
     1.167     6.985     0.200
     1.371     9.139     0.200
     1.443     8.562     0.200
     1.367     7.059     0.200
     1.865    10.642     0.200
     2.383    11.403     0.200
     2.670    12.245     0.200
     4.272    22.659     0.200
     4.271    22.167     0.200
     4.447    24.813     0.200
     7.305    31.560     0.200
     0.349     2.929     0.200
     0.834     5.664     0.200
     1.652    10.220     0.200
     1.669    10.920     0.200
     1.904    12.180     0.200
     1.850    10.807     0.200
     1.864    10.143     0.200
     2.195    12.682     0.200
     5.624    32.772     0.200
     7.328    33.479     0.200
     0.332     3.046     0.200
     0.369     3.183     0.200
     0.628     4.200     0.200
     0.992     7.344     0.200
     1.414     8.421     0.200
     1.706     9.516     0.200
     1.962    11.630     0.200
     2.201    12.144     0.200
     2.190    12.967     0.200
     2.449    12.551     0.200
     7.538    35.753     0.200
     0.661     5.145     0.200
     1.096     6.761     0.200
     1.240     6.981     0.200
     3.234    19.118     0.200
     3.249    18.635     0.200
     6.026    30.630     0.200
     0.572     4.007     0.200
     1.052     6.012     0.200
     1.179     8.330     0.200
     1.484     8.065     0.200
     1.704     8.800     0.200
     1.727     8.828     0.200
     1.995    11.012     0.200
     4.914    28.742     0.200
     6.462    27.281     0.200
     6.462    35.382     0.200
     6.595    33.424     0.200
     7.017    34.906     0.200
     7.187    32.515     0.200
     0.525     4.610     0.200
     1.008     6.778     0.200
     1.154     8.269     0.200
     1.457     9.845     0.200
     1.751     8.805     0.200
     0.310     2.527     0.200
     0.459     4.498     0.200
     0.530     3.819     0.200
     0.546     4.333     0.200
     0.687     4.901     0.200
     0.962     7.815     0.200
     1.005     7.143     0.200
     1.538     8.696     0.200
     1.538     8.797     0.200
     1.788     9.777     0.200
     1.788     9.879     0.200
     2.462    13.099     0.200
     3.258    19.724     0.200
     3.344    18.140     0.200
     3.468    20.869     0.200
     4.338    22.116     0.200
     5.100    26.563     0.200
     7.774    37.422     0.200
     0.356     2.603     0.200
     0.683     4.885     0.200
     0.944     7.450     0.200
     1.350     9.303     0.200
     1.446     9.379     0.200
     2.140    13.087     0.200
     5.573    29.321     0.200
     7.852    40.228     0.200
     0.335     2.777     0.200
     0.472     4.931     0.200
     0.503     4.767     0.200
     0.591     4.374     0.200
     0.722     4.364     0.200
     0.692     5.731     0.200
     0.938     6.942     0.200
     1.038     7.197     0.200
     1.365     9.261     0.200
     1.505     9.327     0.200
     1.530     9.038     0.200
     2.261    12.404     0.200
     2.486    13.376     0.200
     3.482    18.955     0.200
     0.443     3.202     0.200
     1.227     8.658     0.200
     1.182     9.684     0.200
     1.250     9.884     0.200
     1.627     8.586     0.200
     1.202     7.051     0.200
     1.854    11.235     0.200
     2.245    11.173     0.200
     2.275    11.430     0.200
     2.374    11.373     0.200
     2.654    12.408     0.200
     4.112    17.495     0.200
     6.549    30.750     0.200
     6.560    28.528     0.200
     7.567    41.268     0.200
     0.128     3.830     0.200
     0.471     4.462     0.200
     0.602     5.323     0.200
     0.642     5.069     0.200
     1.235     6.145     0.200
     1.422     8.561     0.200
     1.478     8.103     0.200
     1.877    10.852     0.200
     2.262    10.463     0.200
     2.669    12.005     0.200
     3.701    21.066     0.200
     3.937    18.307     0.200
     4.230    22.694     0.200
     4.593    25.950     0.200
     6.326    27.235     0.200
     7.550    35.452     0.200
     0.162     1.677     0.200
     0.627     4.947     0.200
     0.685     4.670     0.200
     0.704     4.853     0.200
     0.786     5.197     0.200
     0.787     5.187     0.200
     0.821     6.285     0.200
     0.789     5.980     0.200
     0.895     5.728     0.200
     1.022    16.731     0.200
     1.011     8.284     0.200
     1.071     7.653     0.200
     1.152     6.570     0.200
     1.152     7.230     0.200
     1.158     7.679     0.200
     1.347     8.578     0.200
     1.515     8.682     0.200
     1.500    10.564     0.200
     1.957    10.533     0.200
     2.218    11.886     0.200
     2.414    13.153     0.200
     2.863    15.115     0.200
     3.243    15.471     0.200
     3.194    17.363     0.200
     3.317    17.329     0.200
     3.361    16.416     0.200
     0.570     5.031     0.200
     0.629     4.239     0.200
     0.655     4.042     0.200
     0.753     4.796     0.200
     0.727     4.495     0.200
     0.739     5.160     0.200
     0.780     5.479     0.200
     0.836     5.021     0.200
     1.291     8.317     0.200
     2.018    11.133     0.200
     2.301    12.124     0.200
     3.851    21.645     0.200
     0.190     1.730     0.200
     0.647     5.491     0.200
     0.731     4.708     0.200
     0.810     5.685     0.200
     0.847     4.953     0.200
     0.922     6.187     0.200
     0.928     7.114     0.200
     1.175     7.128     0.200
     1.514    10.173     0.200
     1.741     9.324     0.200
     2.041    11.530     0.200
     2.037    12.168     0.200
     5.711    27.791     0.200
     0.176     2.614     0.200
     0.187     2.693     0.200
     0.423     4.137     0.200
     0.522     4.384     0.200
     0.646     4.535     0.200
     0.669     4.661     0.200
     0.741     5.232     0.200
     0.834     5.238     0.200
     0.841     4.962     0.200
     0.935     5.857     0.200
     1.044     5.890     0.200
     1.190     6.688     0.200
     1.169     8.326     0.200
     1.236     6.952     0.200
     1.641     8.424     0.200
     1.661     8.494     0.200
     1.985    10.608     0.200
     2.105    10.706     0.200
     2.329    10.998     0.200
     2.394    11.934     0.200
     4.118    22.421     0.200
     4.997    23.765     0.200
     8.418    39.039     0.200
     0.187     2.807     0.200
     0.255     4.216     0.200
     0.415     3.756     0.200
     0.415     3.757     0.200
     0.686     4.983     0.200
     0.764     4.974     0.200
     0.780     5.592     0.200
     0.841     5.175     0.200
     1.006     6.152     0.200
     1.082     6.660     0.200
     1.192     7.085     0.200
     1.128     6.829     0.200
     1.281     8.048     0.200
     1.233     7.895     0.200
     1.384     7.443     0.200
     1.638    10.775     0.200
     1.923    11.056     0.200
     2.266    12.379     0.200
     2.429    11.751     0.200
     2.752    12.668     0.200
     2.755    13.851     0.200
     3.263    15.884     0.200
     7.762    38.907     0.200
     0.517     2.952     0.200
     0.499     3.581     0.200
     0.558     3.423     0.200
     0.732     4.938     0.200
     0.791     5.821     0.200
     0.792     6.844     0.200
     0.840     6.383     0.200
     1.040     6.755     0.200
     1.177     7.650     0.200
     1.293     8.689     0.200
     1.419     8.092     0.200
     3.922    18.381     0.200
     4.354    24.339     0.200
     0.448     3.783     0.200
     0.510     4.391     0.200
     0.520     3.967     0.200
     0.555     4.581     0.200
     0.743     5.463     0.200
     0.795     5.956     0.200
     0.793     5.877     0.200
     0.853     5.932     0.200
     1.052     6.747     0.200
     1.158     6.928     0.200
     1.189     7.270     0.200
     1.285     7.703     0.200
     1.431     9.195     0.200
     2.115    11.662     0.200
     2.142    12.335     0.200
     2.142    11.738     0.200
     2.522    12.542     0.200
     3.137    14.937     0.200
     3.300    16.441     0.200
     3.500    16.129     0.200
     5.776    33.629     0.200
     5.835    26.642     0.200
     6.875    29.411     0.200
     7.480    34.547     0.200
     8.284    36.656     0.200
     8.369    38.970     0.200
     8.441    39.635     0.200
     8.694    39.284     0.200
     9.190    43.585     0.200
     0.482     3.093     0.200
     0.485     3.152     0.200
     0.492     3.794     0.200
     0.759     6.160     0.200
     0.825     6.013     0.200
     0.850     6.140     0.200
     1.038     7.105     0.200
     1.192     6.730     0.200
     1.180     7.753     0.200
     1.418     8.508     0.200
     1.813    11.247     0.200
     2.139    11.394     0.200
     2.169    12.253     0.200
     2.917    13.440     0.200
     3.162    15.120     0.200
     3.209    14.416     0.200
     3.219    15.388     0.200
     3.267    15.006     0.200
     3.902    17.979     0.200
     4.863    26.467     0.200
     0.418     3.068     0.200
     0.528     4.046     0.200
     0.514     4.116     0.200
     0.546     3.830     0.200
     0.765     5.984     0.200
     0.750     5.108     0.200
     0.821     5.998     0.200
     0.842     6.659     0.200
     1.051     6.880     0.200
     1.269     9.371     0.200
     1.183     8.333     0.200
     1.429     9.542     0.200
     2.108    11.159     0.200
     2.131    12.499     0.200
     2.881    13.961     0.200
     3.128    14.760     0.200
     3.175    14.691     0.200
     3.219    15.156     0.200
     3.490    16.243     0.200
     3.932    18.939     0.200
     4.926    26.596     0.200
     7.491    38.157     0.200
     0.492     4.131     0.200
     0.505     4.611     0.200
     0.585     4.353     0.200
     0.735     5.152     0.200
     0.827     6.635     0.200
     0.862     5.823     0.200
     1.051     6.862     0.200
     1.183     6.827     0.200
     1.194     8.488     0.200
     1.304     8.098     0.200
     1.431     9.413     0.200
     1.907    10.304     0.200
     2.016    12.151     0.200
     2.126    11.835     0.200
     2.157    13.494     0.200
     2.321    13.306     0.200
     2.531    12.815     0.200
     2.904    14.003     0.200
     3.149    15.457     0.200
     3.208    15.410     0.200
     3.257    16.068     0.200
     3.350    15.621     0.200
     3.513    17.295     0.200
     6.589    31.562     0.200
     0.518     2.968     0.200
     0.752     5.695     0.200
     0.780     6.018     0.200
     0.810     5.794     0.200
     0.853     5.756     0.200
     1.058     6.721     0.200
     1.143     6.556     0.200
     1.192     7.515     0.200
     1.271     7.959     0.200
     1.436     7.914     0.200
     0.533     3.934     0.200
     0.514     4.123     0.200
     0.748     4.657     0.200
     0.806     6.590     0.200
     0.851     6.659     0.200
     1.147     6.402     0.200
     1.054     7.705     0.200
     1.276     7.901     0.200
     1.189     8.306     0.200
     2.110    11.240     0.200
     2.135    12.662     0.200
     2.884    13.663     0.200
     2.968    14.628     0.200
     3.131    14.719     0.200
     3.178    15.027     0.200
     3.182    15.454     0.200
     3.775    21.147     0.200
     4.141    18.040     0.200
     7.482    33.478     0.200
     0.502     4.075     0.200
     0.505     4.384     0.200
     0.573     4.149     0.200
     0.736     4.946     0.200
     0.776     6.973     0.200
     0.813     6.073     0.200
     0.856     5.671     0.200
     1.049     6.924     0.200
     1.174     6.554     0.200
     1.189     7.609     0.200
     1.429     9.727     0.200
     1.796    11.488     0.200
     2.016    11.877     0.200
     2.124    11.954     0.200
     2.153    13.201     0.200
     2.530    12.464     0.200
     2.901    14.044     0.200
     2.937    14.699     0.200
     3.146    15.289     0.200
     3.194    15.033     0.200
     3.203    16.170     0.200
     3.510    16.872     0.200
     3.744    22.433     0.200
     7.477    31.864     0.200
     0.458     3.434     0.200
     0.488     4.791     0.200
     0.505     4.193     0.200
     0.570     4.191     0.200
     0.721     5.825     0.200
     0.800     6.278     0.200
     0.779     6.215     0.200
     0.835     5.683     0.200
     1.031     7.581     0.200
     1.169     7.916     0.200
     1.410     9.674     0.200
     1.908     9.994     0.200
     2.001    12.272     0.200
     2.138    13.003     0.200
     4.282    22.135     0.200
     0.469     3.091     0.200
     0.492     3.249     0.200
     0.473     3.874     0.200
     0.583     3.829     0.200
     0.706     4.664     0.200
     0.767     5.879     0.200
     0.806     6.170     0.200
     0.824     5.005     0.200
     1.017     6.165     0.200
     1.157     7.962     0.200
     1.322     9.085     0.200
     1.396     7.602     0.200
     1.817    10.801     0.200
     1.986    11.448     0.200
     2.153    11.443     0.200
     2.180    11.999     0.200
     2.560    11.999     0.200
     2.929    13.310     0.200
     3.175    14.409     0.200
     3.222    14.951     0.200
     4.289    22.770     0.200
     0.421     2.652     0.200
     0.532     3.384     0.200
     0.543     3.821     0.200
     0.508     3.921     0.200
     0.765     4.899     0.200
     0.744     4.761     0.200
     0.817     6.064     0.200
     0.837     5.322     0.200
     1.045     6.500     0.200
     1.177     7.844     0.200
     1.423     9.012     0.200
     1.767     9.426     0.200
     2.114    10.792     0.200
     2.137    11.402     0.200
     2.022    11.209     0.200
     3.301    14.992     0.200
     3.496    15.118     0.200
     3.897    16.606     0.200
     4.007    17.930     0.200
     4.502    26.860     0.200
     4.922    28.857     0.200
     6.697    30.248     0.200
     6.697    35.646     0.200
     7.496    37.320     0.200
     9.208    39.945     0.200
     9.706    43.637     0.200
     9.706    51.035     0.200
     0.391     2.839     0.200
     0.501     3.629     0.200
     0.573     3.255     0.200
     0.528     3.889     0.200
     0.740     5.125     0.200
     0.766     4.490     0.200
     1.112     5.882     0.200
     1.248     7.152     0.200
     1.248     6.984     0.200
     1.188     7.596     0.200
     1.437     8.811     0.200
     1.577     9.062     0.200
     1.620     9.339     0.200
     1.739     9.148     0.200
     2.093    10.686     0.200
     2.113    11.079     0.200
     2.335    12.210     0.200
     2.863    13.352     0.200
     3.112    13.666     0.200
     3.311    14.372     0.200
     4.953    25.646     0.200
     7.491    31.821     0.200
     8.115    35.641     0.200
     9.205    43.128     0.200
     0.507     3.530     0.200
     0.568     4.791     0.200
     0.525     3.431     0.200
     0.842     5.798     0.200
     0.843     5.607     0.200
     1.059     7.338     0.200
     1.252     8.615     0.200
     1.186     8.054     0.200
     1.435     8.390     0.200
     2.096    10.700     0.200
     2.117    11.368     0.200
     3.161    14.696     0.200
     3.477    15.621     0.200
     4.057    17.050     0.200
     4.947    28.995     0.200
     7.492    32.001     0.200
     0.502     3.417     0.200
     0.537     3.509     0.200
     0.573     3.261     0.200
     0.747     5.748     0.200
     0.847     6.763     0.200
     0.855     6.671     0.200
     1.071     7.141     0.200
     1.109     5.959     0.200
     1.199     8.330     0.200
     1.242     8.915     0.200
     0.516     3.732     0.200
     0.547     4.497     0.200
     0.561     4.430     0.200
     0.771     6.186     0.200
     0.782     5.949     0.200
     0.833     7.212     0.200
     0.876     6.036     0.200
     1.085     7.429     0.200
     1.217     8.823     0.200
     1.463     9.499     0.200
     1.590    10.050     0.200
     1.738    12.030     0.200
     2.076    12.450     0.200
     2.101    14.138     0.200
     2.060    12.248     0.200
     2.850    14.405     0.200
     7.458    36.199     0.200
     0.509     3.607     0.200
     0.538     4.352     0.200
     0.566     4.040     0.200
     0.756     6.537     0.200
     0.774     5.609     0.200
     0.840     6.879     0.200
     0.860     7.268     0.200
     1.073     7.581     0.200
     1.203     8.918     0.200
     1.245     7.525     0.200
     1.451     9.057     0.200
     1.584     9.560     0.200
     2.107    13.577     0.200
     0.516     4.386     0.200
     0.560     4.578     0.200
     0.542     4.766     0.200
     0.768     5.596     0.200
     0.777     5.382     0.200
     0.833     6.624     0.200
     0.869     5.382     0.200
     1.079     7.133     0.200
     1.118     6.893     0.200
     1.246     7.324     0.200
     1.246     7.605     0.200
     1.211     7.589     0.200
     1.457     9.462     0.200
     2.081    11.954     0.200
     2.105    12.919     0.200
     4.006    20.997     0.200
     4.521    26.582     0.200
     5.141    24.547     0.200
     6.671    36.587     0.200
     7.464    34.430     0.200
     0.534     4.191     0.200
     0.550     4.129     0.200
     0.528     5.098     0.200
     0.766     5.325     0.200
     0.803     6.161     0.200
     0.878     5.486     0.200
     1.077     7.068     0.200
     1.215     9.202     0.200
     1.267     8.476     0.200
     1.456    10.240     0.200
     4.245    24.548     0.200
     7.455    34.590     0.200
     0.513     3.329     0.200
     0.522     3.888     0.200
     0.561     4.431     0.200
     0.751     5.211     0.200
     0.758     4.416     0.200
     0.843     6.892     0.200
     0.835     6.437     0.200
     1.056     6.765     0.200
     1.185     8.573     0.200
     1.434     8.771     0.200
     0.510     3.850     0.200
     0.567     3.730     0.200
     0.549     4.067     0.200
     0.785     5.438     0.200
     0.765     6.053     0.200
     0.839     6.924     0.200
     0.875     6.629     0.200
     1.086     7.034     0.200
     1.217     8.644     0.200
     1.238     9.456     0.200
     2.097    12.828     0.200
     7.459    32.566     0.200
     0.490     3.437     0.200
     0.540     3.623     0.200
     0.584     4.814     0.200
     0.734     6.032     0.200
     0.777     4.999     0.200
     0.859     6.066     0.200
     0.851     6.747     0.200
     1.071     6.249     0.200
     1.197     8.027     0.200
     1.447     8.234     0.200
     1.726    10.353     0.200
     2.081    10.816     0.200
     2.101    11.648     0.200
     2.851    13.155     0.200
     3.100    14.559     0.200
     3.185    14.473     0.200
     0.507     3.852     0.200
     0.529     3.718     0.200
     0.743     4.427     0.200
     0.761     5.984     0.200
     0.820     6.162     0.200
     1.043     7.343     0.200
     1.174     7.944     0.200
     1.275     7.379     0.200
     2.316    12.746     0.200
     7.500    31.507     0.200
     0.534     4.314     0.200
     0.530     5.277     0.200
     0.541     4.989     0.200
     0.782     5.890     0.200
     0.764     5.896     0.200
     0.814     7.114     0.200
     0.865     5.607     0.200
     1.136     6.766     0.200
     1.070     7.767     0.200
     1.262     7.720     0.200
     1.204     8.631     0.200
     1.448    10.139     0.200
     1.609     9.824     0.200
     1.623     9.876     0.200
     1.758     9.700     0.200
     1.951    10.806     0.200
     2.094    12.447     0.200
     2.120    13.543     0.200
     2.502    13.157     0.200
     2.869    15.146     0.200
     3.116    16.086     0.200
     3.168    15.445     0.200
     3.214    16.013     0.200
     3.479    17.782     0.200
     4.093    18.831     0.200
     9.180    47.390     0.200
     0.392     3.104     0.200
     0.499     3.944     0.200
     0.536     4.689     0.200
     0.575     4.240     0.200
     0.743     6.422     0.200
     0.773     5.642     0.200
     0.852     6.888     0.200
     0.849     6.431     0.200
     1.069     7.636     0.200
     1.196     8.742     0.200
     1.242     8.904     0.200
     1.446     9.680     0.200
     2.085    12.597     0.200
     2.106    13.683     0.200
     6.695    35.611     0.200
     9.196    46.021     0.200
     0.405     3.013     0.200
     0.516     3.773     0.200
     0.515     3.988     0.200
     0.558     3.400     0.200
     0.833     6.395     0.200
     0.836     6.911     0.200
     1.049     7.751     0.200
     1.178     8.766     0.200
     1.263     8.593     0.200
     1.426     8.722     0.200
     2.106    12.013     0.200
     4.298    22.962     0.200
     0.394     2.859     0.200
     0.498     3.773     0.200
     0.544     4.291     0.200
     0.747     6.187     0.200
     0.781     5.440     0.200
     0.850     5.759     0.200
     0.862     6.723     0.200
     1.078     7.480     0.200
     1.206     8.787     0.200
     4.278    23.658     0.200
     0.556     4.415     0.200
     0.518     3.899     0.200
     0.495     4.384     0.200
     0.787     7.041     0.200
     0.728     5.507     0.200
     0.793     6.249     0.200
     0.835     5.346     0.200
     1.035     7.388     0.200
     1.171     8.129     0.200
     1.414     9.529     0.200
     1.920    10.173     0.200
     2.130    11.843     0.200
     2.904    14.368     0.200
     2.962    15.305     0.200
     3.198    15.396     0.200
     3.747    22.168     0.200
     6.691    32.419     0.200
     7.498    38.395     0.200
     0.508     3.478     0.200
     0.492     4.317     0.200
     0.566     4.008     0.200
     0.724     5.123     0.200
     0.782     6.384     0.200
     0.798     6.387     0.200
     0.837     5.360     0.200
     1.034     7.170     0.200
     1.172     7.795     0.200
     1.302     7.633     0.200
     1.413     9.088     0.200
     2.134    11.292     0.200
     2.773    13.699     0.200
     2.951    14.640     0.200
     7.496    35.536     0.200
     0.541     5.229     0.200
     0.574     5.004     0.200
     0.748     7.065     0.200
     0.777     5.848     0.200
     0.847     6.249     0.200
     0.859     5.962     0.200
     1.107     7.210     0.200
     1.075     8.354     0.200
     1.239     8.405     0.200
     1.203     9.340     0.200
     1.452    10.266     0.200
     1.576    10.314     0.200
     1.732    11.494     0.200
     2.081    12.669     0.200
     2.102    13.595     0.200
     2.349    13.521     0.200
     2.491    13.418     0.200
     2.852    14.373     0.200
     3.004    15.667     0.200
     3.101    15.975     0.200
     3.147    15.459     0.200
     3.147    15.189     0.200
     3.190    15.335     0.200
     3.300    16.263     0.200
     3.462    16.434     0.200
     3.752    17.575     0.200
     4.026    20.312     0.200
     4.334    20.661     0.200
     6.889    29.745     0.200
     9.189    47.408     0.200
     0.515     3.904     0.200
     0.527     4.877     0.200
     0.560     4.457     0.200
     0.756     5.182     0.200
     0.763     6.072     0.200
     0.834     6.527     0.200
     0.850     5.395     0.200
     1.063     7.786     0.200
     1.193     8.792     0.200
     1.440     9.813     0.200
     1.590     9.153     0.200
     1.747    10.878     0.200
     2.094    12.017     0.200
     2.505    12.812     0.200
     3.930    18.098     0.200
     4.520    26.607     0.200
     6.690    31.284     0.200
     0.425     3.204     0.200
     0.531     4.013     0.200
     0.522     4.258     0.200
     0.544     3.768     0.200
     0.757     5.139     0.200
     0.774     7.253     0.200
     0.817     6.664     0.200
     0.854     6.348     0.200
     1.061     7.512     0.200
     1.194     8.552     0.200
     1.265     8.636     0.200
     1.439     9.150     0.200
     2.101    12.142     0.200
     2.333    13.122     0.200
     0.509     3.703     0.200
     0.461     4.255     0.200
     0.488     4.660     0.200
     0.615     4.523     0.200
     0.715     5.161     0.200
     0.733     6.972     0.200
     0.852     6.773     0.200
     0.858     5.498     0.200
     1.037     6.526     0.200
     1.214     7.470     0.200
     1.184     7.432     0.200
     1.332     9.009     0.200
     1.418     9.206     0.200
     1.690    10.523     0.200
     1.733    10.708     0.200
     1.833    11.391     0.200
     1.878    10.034     0.200
     2.149    11.777     0.200
     2.552    12.658     0.200
     2.845    15.795     0.200
     0.272     2.452     0.200
     0.401     2.871     0.200
     0.456     3.351     0.200
     0.514     3.597     0.200
     0.511     3.795     0.200
     0.520     3.418     0.200
     0.560     2.936     0.200
     0.561     4.169     0.200
     0.829     6.842     0.200
     0.836     5.955     0.200
     1.044     6.852     0.200
     1.127     5.991     0.200
     1.172     8.616     0.200
     1.265     8.924     0.200
     1.421     8.674     0.200
     2.130    11.788     0.200
     7.505    32.426     0.200
     0.425     3.458     0.200
     0.480     3.984     0.200
     0.533     4.281     0.200
     0.518     4.743     0.200
     0.548     3.930     0.200
     0.542     4.202     0.200
     0.581     4.604     0.200
     0.773     5.791     0.200
     0.753     5.303     0.200
     0.816     7.075     0.200
     0.849     5.194     0.200
     1.056     7.191     0.200
     1.189     8.242     0.200
     1.434     9.938     0.200
     2.031    12.044     0.200
     2.105    12.351     0.200
     2.129    13.024     0.200
     3.126    15.584     0.200
     3.173    15.613     0.200
     4.920    25.879     0.200
     6.622    30.414     0.200
     7.484    33.960     0.200
     0.253     2.861     0.200
     0.461     3.541     0.200
     0.502     4.087     0.200
     0.530     3.537     0.200
     0.541     3.385     0.200
     0.534     3.514     0.200
     0.562     4.416     0.200
     0.830     6.873     0.200
     0.816     5.808     0.200
     1.039     6.971     0.200
     1.170     7.536     0.200
     1.280     8.576     0.200
     1.417     8.820     0.200
     2.015    11.254     0.200
     7.503    35.566     0.200
     0.196     2.473     0.200
     0.463     3.790     0.200
     0.471     3.451     0.200
     0.472     3.069     0.200
     0.555     4.750     0.200
     0.556     3.450     0.200
     0.602     3.674     0.200
     0.747     6.139     0.200
     0.822     5.684     0.200
     0.823     6.869     0.200
     1.008     5.970     0.200
     1.151     7.714     0.200
     1.339     8.711     0.200
     1.388     8.557     0.200
     2.196    12.915     0.200
     2.278    12.835     0.200
     0.286     3.449     0.200
     0.385     2.954     0.200
     0.497     3.704     0.200
     0.457     3.779     0.200
     0.518     3.750     0.200
     0.523     4.598     0.200
     0.577     3.932     0.200
     0.567     4.663     0.200
     0.731     5.186     0.200
     0.852     5.670     0.200
     0.835     5.308     0.200
     1.111     6.103     0.200
     1.054     6.794     0.200
     1.180     8.588     0.200
     1.430     9.515     0.200
     1.739     9.085     0.200
     2.097    10.970     0.200
     2.116    12.320     0.200
     2.036    11.606     0.200
     2.328    12.735     0.200
     3.116    14.658     0.200
     3.162    14.770     0.200
     3.198    15.102     0.200
     3.315    14.947     0.200
     3.477    16.128     0.200
     3.763    16.704     0.200
     3.953    19.332     0.200
     4.042    18.279     0.200
     4.536    26.077     0.200
     6.713    34.775     0.200
     6.915    29.019     0.200
     7.501    32.583     0.200
     8.482    44.530     0.200
     0.297     3.151     0.200
     0.372     3.016     0.200
     0.465     3.623     0.200
     0.482     3.736     0.200
     0.521     3.631     0.200
     0.539     4.411     0.200
     0.577     4.542     0.200
     0.592     3.664     0.200
     0.722     6.523     0.200
     0.845     4.773     0.200
     0.867     7.098     0.200
     1.068     7.423     0.200
     1.191     8.835     0.200
     1.233     7.175     0.200
     1.443     9.412     0.200
     2.100    13.231     0.200
     2.342    13.546     0.200
     0.292     2.880     0.200
     0.487     3.515     0.200
     0.536     3.963     0.200
     0.523     3.269     0.200
     0.587     3.314     0.200
     0.577     4.118     0.200
     0.727     5.867     0.200
     0.862     6.427     0.200
     0.844     4.746     0.200
     1.066     6.817     0.200
     1.099     5.825     0.200
     1.190     8.086     0.200
     1.237     6.533     0.200
     1.442     8.741     0.200
     2.103    12.032     0.200
     2.340    12.528     0.200
     4.300    20.008     0.200
     4.358    25.133     0.200
     4.967    25.723     0.200
     0.431     3.461     0.200
     0.485     3.798     0.200
     0.537     4.147     0.200
     0.519     4.475     0.200
     0.554     3.863     0.200
     0.538     3.993     0.200
     0.585     4.711     0.200
     0.779     6.456     0.200
     0.811     7.180     0.200
     0.853     7.252     0.200
     1.058     7.381     0.200
     1.142     6.501     0.200
     1.192     9.147     0.200
     1.271     7.629     0.200
     1.436     9.185     0.200
     4.343    26.566     0.200
     7.480    34.255     0.200
     0.317     3.086     0.200
     0.472     3.430     0.200
     0.521     3.582     0.200
     0.559     4.135     0.200
     0.617     3.348     0.200
     0.705     6.617     0.200
     0.714     4.920     0.200
     0.799     5.955     0.200
     0.856     4.835     0.200
     0.891     6.770     0.200
     1.085     7.546     0.200
     1.205     7.912     0.200
     7.483    32.238     0.200
     0.316     2.681     0.200
     0.466     3.541     0.200
     0.455     3.315     0.200
     0.506     3.321     0.200
     0.542     3.869     0.200
     0.571     4.113     0.200
     0.609     3.300     0.200
     0.703     6.423     0.200
     0.722     4.479     0.200
     0.781     5.666     0.200
     0.838     6.398     0.200
     0.884     6.638     0.200
     1.067     7.594     0.200
     1.187     8.234     0.200
     1.226     8.389     0.200
     1.648     9.549     0.200
     1.712    10.385     0.200
     7.501    34.315     0.200
     0.261     2.802     0.200
     0.520     3.748     0.200
     0.467     3.434     0.200
     0.533     3.455     0.200
     0.515     3.907     0.200
     0.554     3.402     0.200
     0.571     4.110     0.200
     0.756     4.923     0.200
     0.752     4.868     0.200
     0.829     6.220     0.200
     0.839     4.966     0.200
     1.051     7.064     0.200
     1.181     7.360     0.200
     2.106    10.891     0.200
     2.128    12.119     0.200
     2.290    11.212     0.200
     2.878    13.304     0.200
     3.126    14.399     0.200
     3.215    14.953     0.200
     4.514    25.418     0.200
     4.934    26.111     0.200
     6.699    28.209     0.200
     7.495    31.928     0.200
     9.210    39.414     0.200
     0.285     2.895     0.200
     0.489     3.623     0.200
     0.544     3.803     0.200
     0.585     3.427     0.200
     0.589     4.122     0.200
     0.746     4.243     0.200
     0.859     6.300     0.200
     0.857     6.458     0.200
     1.097     5.978     0.200
     1.076     7.494     0.200
     1.202     8.487     0.200
     0.286     2.778     0.200
     0.491     3.516     0.200
     0.537     3.832     0.200
     0.581     4.032     0.200
     0.583     5.062     0.200
     0.748     4.104     0.200
     0.848     6.279     0.200
     0.858     6.069     0.200
     1.101     5.784     0.200
     1.068     7.600     0.200
     1.238     7.340     0.200
     1.194     8.417     0.200
     4.353    23.007     0.200
     4.962    25.898     0.200
     7.487    31.430     0.200
     0.300     2.996     0.200
     0.478     3.477     0.200
     0.544     4.146     0.200
     0.581     4.291     0.200
     0.597     5.530     0.200
     0.734     4.107     0.200
     0.782     5.286     0.200
     0.848     7.142     0.200
     0.871     7.526     0.200
     1.073     7.005     0.200
     1.089     5.810     0.200
     1.196     8.679     0.200
     1.228     6.842     0.200
     1.448     8.834     0.200
     2.056    11.629     0.200
     2.095    12.835     0.200
     2.347    13.055     0.200
     3.126    16.798     0.200
     0.297     2.774     0.200
     0.371     2.905     0.200
     0.471     3.822     0.200
     0.568     3.529     0.200
     0.604     4.935     0.200
     0.729     5.976     0.200
     0.727     6.635     0.200
     0.878     6.407     0.200
     1.099     7.093     0.200
     1.475     8.571     0.200
     1.684     9.190     0.200
     2.081    12.317     0.200
     0.054     2.288     0.200
     0.246     2.847     0.200
     0.424     2.869     0.200
     0.515     3.811     0.200
     0.533     3.603     0.200
     0.542     3.202     0.200
     0.750     4.770     0.200
     0.771     6.118     0.200
     0.789     4.315     0.200
     0.816     6.198     0.200
     0.846     4.846     0.200
     1.053     6.734     0.200
     1.140     5.917     0.200
     1.271     8.194     0.200
     2.028    11.752     0.200
     2.132    12.045     0.200
     0.269     3.006     0.200
     0.401     2.863     0.200
     0.511     3.682     0.200
     0.468     3.579     0.200
     0.523     4.145     0.200
     0.563     3.670     0.200
     0.767     4.291     0.200
     0.759     4.581     0.200
     0.842     4.713     0.200
     1.121     5.964     0.200
     1.057     7.010     0.200
     1.256     6.989     0.200
     1.185     7.510     0.200
     1.434     9.011     0.200
     2.098    10.856     0.200
     2.120    11.908     0.200
     2.036    11.086     0.200
     2.283    11.203     0.200
     2.870    13.653     0.200
     3.118    14.552     0.200
     3.164    14.218     0.200
     6.700    28.960     0.200
     6.700    35.861     0.200
     0.070     2.515     0.200
     0.277     3.201     0.200
     0.466     3.494     0.200
     0.525     4.297     0.200
     0.571     3.770     0.200
     0.741     4.780     0.200
     0.763     4.927     0.200
     0.845     6.361     0.200
     1.115     5.820     0.200
     1.058     6.876     0.200
     1.251     7.531     0.200
     1.435     9.083     0.200
     1.592     9.346     0.200
     2.095    10.875     0.200
     2.116    12.138     0.200
     2.039    11.238     0.200
     2.280    11.216     0.200
     2.332    12.214     0.200
     2.507    11.773     0.200
     2.841    13.479     0.200
     2.866    13.880     0.200
     3.115    14.374     0.200
     3.161    14.545     0.200
     3.314    14.670     0.200
     3.476    15.248     0.200
     3.887    17.667     0.200
     4.530    25.259     0.200
     4.950    28.756     0.200
     6.607    29.828     0.200
     6.607    34.625     0.200
     6.704    33.797     0.200
     6.906    30.740     0.200
     9.206    40.190     0.200
     9.205    42.105     0.200
     0.600     4.446     0.200
     0.685     4.757     0.200
     1.009     6.370     0.200
     1.059     7.190     0.200
     1.060     6.982     0.200
     1.275     7.571     0.200
     1.350     8.000     0.200
     1.380     8.445     0.200
     1.419     7.893     0.200
     2.209    10.871     0.200
     4.309    23.360     0.200
     4.325    25.678     0.200
     0.234     2.508     0.200
     0.434     2.166     0.200
     0.465     2.611     0.200
     0.527     4.589     0.200
     0.505     3.346     0.200
     0.804     6.350     0.200
     0.739     4.813     0.200
     0.852     4.491     0.200
     0.842     6.210     0.200
     0.944     6.923     0.200
     1.045     6.544     0.200
     1.229     7.487     0.200
     1.285     9.043     0.200
     1.189     7.063     0.200
     1.423     8.725     0.200
     1.779    10.272     0.200
     2.119    11.701     0.200
     2.144    11.609     0.200
     2.301    11.178     0.200
     2.894    13.467     0.200
     3.141    14.225     0.200
     3.187    14.502     0.200
     3.340    15.223     0.200
     4.229    19.573     0.200
     0.253     3.622     0.200
     0.400     3.611     0.200
     0.564     4.795     0.200
     0.743     6.004     0.200
     0.822     7.185     0.200
     0.903     6.337     0.200
     1.185     6.445     0.200
     1.273     7.023     0.200
     1.828     9.739     0.200
     2.149    10.495     0.200
     2.234    11.408     0.200
     0.030     1.266     0.200
     0.233     2.504     0.200
     0.444     3.441     0.200
     0.444     3.935     0.200
     0.452     3.641     0.200
     0.488     3.520     0.200
     0.464     3.702     0.200
     0.489     3.916     0.200
     0.518     3.179     0.200
     0.560     4.387     0.200
     0.813     5.127     0.200
     0.810     4.866     0.200
     0.793     5.970     0.200
     0.935     7.909     0.200
     1.029     6.413     0.200
     1.179     7.556     0.200
     1.164     7.229     0.200
     1.299     8.648     0.200
     1.407     8.994     0.200
     1.810     9.799     0.200
     4.216    21.190     0.200
     4.898    24.257     0.200
     0.155     3.868     0.200
     0.153     4.093     0.200
     0.318     3.064     0.200
     0.579     4.622     0.200
     0.762     5.580     0.200
     0.791     5.644     0.200
     0.819     5.822     0.200
     1.035     6.894     0.200
     1.152     6.633     0.200
     1.036     6.990     0.200
     1.210     7.858     0.200
     1.224     8.289     0.200
     1.164     6.991     0.200
     1.381     7.358     0.200
     0.074     1.789     0.200
     0.344     2.830     0.200
     0.418     4.173     0.200
     0.463     3.644     0.200
     0.533     3.626     0.200
     0.533     4.236     0.200
     0.543     3.109     0.200
     0.600     5.149     0.200
     0.782     6.021     0.200
     0.789     5.048     0.200
     0.816     6.426     0.200
     1.073     6.027     0.200
     1.207     7.663     0.200
     1.259     7.349     0.200
     1.627     8.861     0.200
     1.851     9.545     0.200
     0.337     2.498     0.200
     0.389     3.183     0.200
     0.440     3.299     0.200
     0.423     3.187     0.200
     0.494     4.464     0.200
     0.563     4.160     0.200
     0.547     3.841     0.200
     0.677     4.824     0.200
     0.656     5.172     0.200
     0.747     4.043     0.200
     0.747     5.504     0.200
     0.758     5.585     0.200
     0.735     5.449     0.200
     0.779     5.433     0.200
     0.753     4.840     0.200
     0.789     5.416     0.200
     0.791     4.893     0.200
     0.884     6.306     0.200
     0.959     6.138     0.200
     0.994     6.929     0.200
     1.054     7.632     0.200
     1.072     7.112     0.200
     1.173     7.635     0.200
     1.315     9.086     0.200
     1.417     8.987     0.200
     1.487    10.072     0.200
     1.944    11.333     0.200
     2.111    11.692     0.200
     2.230    12.103     0.200
     2.542    13.858     0.200
     2.573    13.100     0.200
     2.644    13.670     0.200
     2.986    14.279     0.200
     3.506    19.316     0.200
     8.168    37.404     0.200
     0.212     2.594     0.200
     0.277     3.528     0.200
     0.384     3.188     0.200
     0.393     3.576     0.200
     0.439     3.342     0.200
     0.435     3.694     0.200
     0.536     4.015     0.200
     0.524     3.851     0.200
     0.583     4.265     0.200
     0.583     4.857     0.200
     0.631     4.601     0.200
     0.678     4.459     0.200
     0.748     5.132     0.200
     0.764     5.248     0.200
     0.815     4.756     0.200
     0.844     5.711     0.200
     0.917     6.858     0.200
     0.922     5.904     0.200
     0.975     5.689     0.200
     0.955     7.017     0.200
     0.973     6.712     0.200
     0.998     7.912     0.200
     1.043     6.098     0.200
     1.084     6.619     0.200
     1.107     6.342     0.200
     1.192     6.755     0.200
     1.208     6.774     0.200
     1.314     7.227     0.200
     1.315     8.920     0.200
     1.446     8.586     0.200
     1.453     7.309     0.200
     1.458     8.045     0.200
     1.493     7.841     0.200
     1.772    11.186     0.200
     2.284    15.431     0.200
     2.509    13.863     0.200
     2.685    14.717     0.200
     2.775    16.554     0.200
     2.804    14.896     0.200
     2.922    16.177     0.200
     3.286    16.716     0.200
     3.349    17.969     0.200
     0.238     3.283     0.200
     0.245     2.904     0.200
     0.277     2.835     0.200
     0.363     3.926     0.200
     0.387     4.042     0.200
     0.393     4.170     0.200
     0.515     4.149     0.200
     0.599     4.869     0.200
     0.625     4.565     0.200
     0.652     5.351     0.200
     0.726     5.281     0.200
     0.772     5.351     0.200
     0.787     5.272     0.200
     0.778     5.582     0.200
     0.782     5.632     0.200
     0.861     5.710     0.200
     0.904     6.203     0.200
     0.972     5.618     0.200
     0.959     6.474     0.200
     1.009     5.983     0.200
     1.031     6.330     0.200
     1.011     6.769     0.200
     1.072     6.157     0.200
     1.153     6.298     0.200
     1.357     7.123     0.200
     1.472     8.285     0.200
     1.579     8.738     0.200
     1.691     9.935     0.200
     1.811     9.925     0.200
     1.881     9.802     0.200
     4.191    24.946     0.200
     9.029    41.182     0.200
     0.325     2.843     0.200
     0.351     2.131     0.200
     0.411     2.838     0.200
     0.401     2.849     0.200
     0.407     2.882     0.200
     0.483     3.689     0.200
     0.497     3.430     0.200
     0.548     3.435     0.200
     0.654     4.196     0.200
     0.743     5.264     0.200
     0.710     4.348     0.200
     0.742     5.673     0.200
     0.771     4.130     0.200
     0.822     5.539     0.200
     0.844     5.883     0.200
     0.863     5.357     0.200
     0.908     5.033     0.200
     0.911     6.203     0.200
     0.897     4.760     0.200
     0.940     5.862     0.200
     1.066     6.782     0.200
     1.128     7.264     0.200
     1.129     7.149     0.200
     1.124     5.807     0.200
     1.109     7.594     0.200
     1.127     7.180     0.200
     1.174     7.826     0.200
     1.190     7.941     0.200
     1.206     8.256     0.200
     1.234     8.027     0.200
     1.263     7.898     0.200
     1.298     7.489     0.200
     1.254     8.796     0.200
     1.298     7.888     0.200
     1.366     8.688     0.200
     1.356     8.811     0.200
     1.392     8.385     0.200
     1.387     8.941     0.200
     1.365     8.096     0.200
     1.393     7.769     0.200
     3.530    17.835     0.200
     3.786    18.350     0.200
     3.816    17.923     0.200
     0.075     2.488     0.200
     0.222     2.873     0.200
     0.304     3.019     0.200
     0.281     2.880     0.200
     0.305     2.800     0.200
     0.392     2.785     0.200
     0.425     3.191     0.200
     0.410     3.579     0.200
     0.448     3.127     0.200
     0.499     3.744     0.200
     0.467     3.512     0.200
     0.517     3.618     0.200
     0.530     4.077     0.200
     0.607     4.179     0.200
     0.576     3.242     0.200
     0.641     4.582     0.200
     0.696     4.637     0.200
     0.691     4.397     0.200
     0.754     4.458     0.200
     0.738     5.151     0.200
     0.755     4.448     0.200
     0.733     4.700     0.200
     0.818     5.419     0.200
     0.819     4.797     0.200
     0.842     6.239     0.200
     0.844     4.718     0.200
     0.913     5.108     0.200
     0.892     5.742     0.200
     0.945     5.933     0.200
     0.950     5.479     0.200
     1.012     6.147     0.200
     1.085     5.995     0.200
     1.109     6.013     0.200
     1.062     6.866     0.200
     1.139     7.274     0.200
     1.188     7.595     0.200
     1.246     6.717     0.200
     1.213     7.502     0.200
     1.239     8.002     0.200
     1.255     8.611     0.200
     1.346     7.251     0.200
     1.382     7.527     0.200
     1.737    10.797     0.200
     1.857    10.281     0.200
     2.043    10.921     0.200
     2.449    12.378     0.200
     2.739    13.696     0.200
     4.219    19.088     0.200
     0.143     4.223     0.200
     0.199     4.262     0.200
     0.268     4.059     0.200
     0.482     4.768     0.200
     0.707     5.640     0.200
     0.707     6.432     0.200
     0.726     5.913     0.200
     0.844     6.339     0.200
     0.823     5.989     0.200
     0.939     7.032     0.200
     0.964     7.345     0.200
     0.884     5.677     0.200
     1.129     7.214     0.200
     1.688     9.291     0.200
     6.942    34.979     0.200
     0.261     4.236     0.200
     0.296     4.415     0.200
     0.374     4.614     0.200
     0.310     4.456     0.200
     0.422     4.356     0.200
     0.532     5.970     0.200
     0.554     5.514     0.200
     0.562     5.018     0.200
     0.556     4.887     0.200
     0.672     5.430     0.200
     0.662     5.054     0.200
     0.623     5.108     0.200
     0.626     5.068     0.200
     0.654     5.442     0.200
     0.770     6.190     0.200
     0.761     5.702     0.200
     0.764     5.658     0.200
     0.803     5.299     0.200
     1.048     6.047     0.200
     4.380    21.843     0.200
     0.265     3.973     0.200
     0.299     4.182     0.200
     0.374     4.414     0.200
     0.417     4.200     0.200
     0.534     5.643     0.200
     0.557     5.268     0.200
     0.558     4.963     0.200
     0.550     4.957     0.200
     0.652     5.458     0.200
     0.616     4.878     0.200
     0.672     5.331     0.200
     0.658     4.897     0.200
     0.620     5.034     0.200
     0.772     6.056     0.200
     0.755     5.463     0.200
     0.758     5.826     0.200
     0.799     5.348     0.200
     0.844     6.321     0.200
     0.973     5.617     0.200
     1.043     5.902     0.200
     1.187     6.121     0.200
     1.373     8.147     0.200
     0.045     2.313     0.200
     0.167     2.977     0.200
     0.232     2.820     0.200
     0.244     2.585     0.200
     0.298     2.756     0.200
     0.328     2.599     0.200
     0.394     2.740     0.200
     0.382     3.477     0.200
     0.449     2.992     0.200
     0.457     3.095     0.200
     0.452     3.358     0.200
     0.525     3.511     0.200
     0.531     3.536     0.200
     0.678     4.123     0.200
     0.668     4.333     0.200
     0.663     4.292     0.200
     0.708     4.572     0.200
     0.817     5.996     0.200
     0.903     6.889     0.200
     0.921     5.483     0.200
     1.042     6.274     0.200
     1.109     7.588     0.200
     1.138     5.949     0.200
     1.173     7.841     0.200
     1.183     7.531     0.200
     1.210     8.012     0.200
     1.256     8.081     0.200
     1.276     8.743     0.200
     1.326     7.859     0.200
     1.376     8.373     0.200
     1.392     7.690     0.200
     1.398     9.025     0.200
     1.832    10.853     0.200
     1.887    10.505     0.200
     0.255     2.859     0.200
     0.298     3.657     0.200
     0.420     3.542     0.200
     0.539     4.248     0.200
     0.429     4.230     0.200
     0.454     4.338     0.200
     0.630     4.686     0.200
     0.675     4.757     0.200
     0.697     4.606     0.200
     0.742     5.380     0.200
     0.781     5.127     0.200
     0.819     4.684     0.200
     0.810     5.581     0.200
     0.875     5.430     0.200
     0.909     5.836     0.200
     0.897     5.376     0.200
     0.856     6.054     0.200
     0.934     5.633     0.200
     0.975     5.460     0.200
     0.960     6.036     0.200
     1.057     6.306     0.200
     1.109     6.099     0.200
     1.021     6.529     0.200
     1.030     6.823     0.200
     1.105     6.338     0.200
     1.144     6.787     0.200
     1.123     6.632     0.200
     1.257     6.764     0.200
     1.388     7.343     0.200
     1.514     8.165     0.200
     1.547     9.087     0.200
     1.547     9.287     0.200
     1.694     8.766     0.200
     1.997    13.831     0.200
     4.457    22.130     0.200
     0.218     2.939     0.200
     0.342     3.596     0.200
     0.366     3.815     0.200
     0.362     2.860     0.200
     0.532     3.883     0.200
     0.608     4.888     0.200
     0.604     4.603     0.200
     0.647     4.436     0.200
     0.747     5.276     0.200
     0.789     5.286     0.200
     0.780     5.589     0.200
     0.800     5.047     0.200
     0.870     5.536     0.200
     0.884     6.070     0.200
     0.939     5.929     0.200
     0.926     5.182     0.200
     0.980     7.051     0.200
     0.991     5.569     0.200
     1.008     5.930     0.200
     1.013     6.968     0.200
     1.009     5.418     0.200
     1.009     6.398     0.200
     1.051     6.223     0.200
     1.148     5.788     0.200
     1.148     6.778     0.200
     1.160     7.357     0.200
     1.154     7.215     0.200
     1.288     7.953     0.200
     1.283     7.720     0.200
     1.275     7.807     0.200
     1.349     8.740     0.200
     1.373     7.862     0.200
     1.370     7.995     0.200
     1.425     7.462     0.200
     1.601     9.108     0.200
     1.605     8.860     0.200
     1.592     8.510     0.200
     1.595     8.374     0.200
     1.698     9.572     0.200
     1.711    10.020     0.200
     1.751     9.156     0.200
     1.784     9.666     0.200
     1.759     8.966     0.200
     1.834    10.191     0.200
     1.829     9.046     0.200
     1.903     9.948     0.200
     1.926    13.216     0.200
     1.977    10.720     0.200
     2.017    10.444     0.200
     2.133    10.598     0.200
     2.410    11.559     0.200
     2.491    11.524     0.200
     2.608    12.153     0.200
     2.702    12.455     0.200
     2.905    13.181     0.200
     3.254    14.188     0.200
     0.053     2.104     0.200
     0.292     2.440     0.200
     0.376     2.529     0.200
     0.336     3.748     0.200
     0.314     3.108     0.200
     0.426     3.370     0.200
     0.476     4.068     0.200
     0.555     4.275     0.200
     0.598     3.938     0.200
     0.540     3.864     0.200
     0.542     4.481     0.200
     0.580     4.255     0.200
     0.664     4.420     0.200
     0.706     4.088     0.200
     0.749     4.866     0.200
     0.736     4.617     0.200
     0.803     5.054     0.200
     0.820     5.222     0.200
     0.825     5.258     0.200
     0.824     4.836     0.200
     0.789     5.815     0.200
     0.789     5.456     0.200
     0.821     5.047     0.200
     0.821     5.847     0.200
     0.832     5.865     0.200
     0.839     5.540     0.200
     0.898     5.365     0.200
     0.888     5.762     0.200
     0.888     5.192     0.200
     0.938     6.380     0.200
     0.938     6.880     0.200
     1.084     6.581     0.200
     1.084     6.711     0.200
     1.065     6.699     0.200
     1.150     6.488     0.200
     1.091     6.694     0.200
     1.091     7.084     0.200
     1.144     6.463     0.200
     1.133     7.301     0.200
     1.133     7.141     0.200
     1.144     7.675     0.200
     1.144     8.025     0.200
     1.229     7.185     0.200
     1.229     7.485     0.200
     1.222     6.871     0.200
     1.222     6.481     0.200
     1.210     7.202     0.200
     1.341     8.279     0.200
     1.341     7.799     0.200
     1.259     8.638     0.200
     1.270     8.493     0.200
     1.294     7.698     0.200
     1.351     8.611     0.200
     1.342     8.670     0.200
     1.382     9.137     0.200
     1.476     9.608     0.200
     1.498     9.840     0.200
     1.498     9.660     0.200
     1.422     9.235     0.200
     1.422     8.976     0.200
     1.829     9.578     0.200
     1.950    14.173     0.200
     1.996    13.036     0.200
     2.021    12.940     0.200
     2.152    12.512     0.200
     2.283    13.290     0.200
     2.322    13.427     0.200
     2.561    14.138     0.200
     2.575    14.978     0.200
     2.740    14.847     0.200
     3.041    16.642     0.200
     3.080    16.385     0.200
     3.174    17.581     0.200
     3.187    16.831     0.200
     3.552    18.081     0.200
     4.115    21.101     0.200
     4.052    21.891     0.200
     0.048     2.004     0.200
     0.291     2.668     0.200
     0.261     2.849     0.200
     0.370     2.759     0.200
     0.315     2.845     0.200
     0.343     3.891     0.200
     0.317     3.415     0.200
     0.423     3.099     0.200
     0.541     4.271     0.200
     0.484     4.187     0.200
     0.591     4.175     0.200
     0.551     3.923     0.200
     0.549     4.200     0.200
     0.583     3.982     0.200
     0.666     4.630     0.200
     0.703     4.298     0.200
     0.738     5.630     0.200
     0.733     4.300     0.200
     0.800     5.075     0.200
     0.798     5.146     0.200
     0.836     5.933     0.200
     0.845     5.357     0.200
     0.894     5.158     0.200
     0.835     5.418     0.200
     0.938     6.948     0.200
     0.902     6.261     0.200
     1.078     6.791     0.200
     1.066     7.075     0.200
     1.091     6.990     0.200
     1.131     7.346     0.200
     1.147     7.022     0.200
     1.210     7.435     0.200
     1.280     8.264     0.200
     1.350     8.571     0.200
     1.351     8.445     0.200
     1.430     9.527     0.200
     1.430     8.637     0.200
     1.647     8.981     0.200
     1.855     9.760     0.200
     2.426    13.802     0.200
     3.711    20.468     0.200
     0.039     2.062     0.200
     0.120     1.641     0.200
     0.299     2.603     0.200
     0.256     2.808     0.200
     0.266     3.261     0.200
     0.307     2.858     0.200
     0.375     2.730     0.200
     0.355     3.915     0.200
     0.318     3.414     0.200
     0.412     3.162     0.200
     0.530     4.283     0.200
     0.496     4.110     0.200
     0.594     4.283     0.200
     0.547     4.064     0.200
     0.564     3.781     0.200
     0.576     4.182     0.200
     0.676     4.533     0.200
     0.709     4.264     0.200
     0.735     6.021     0.200
     0.722     5.077     0.200
     0.806     7.102     0.200
     0.806     4.981     0.200
     0.840     5.698     0.200
     0.798     5.564     0.200
     0.842     5.263     0.200
     0.883     5.401     0.200
     0.846     5.188     0.200
     0.929     6.183     0.200
     0.912     5.624     0.200
     1.057     6.693     0.200
     1.120     7.299     0.200
     1.128     7.915     0.200
     1.155     6.528     0.200
     1.202     7.167     0.200
     1.333     8.112     0.200
     1.280     8.159     0.200
     1.351     8.437     0.200
     1.802     9.486     0.200
     1.856     9.543     0.200
     2.417    14.795     0.200
     3.698    21.342     0.200
     4.285    25.990     0.200
     5.058    24.577     0.200
     0.063     1.961     0.200
     0.173     2.955     0.200
     0.216     2.633     0.200
     0.225     2.666     0.200
     0.228     2.350     0.200
     0.291     2.665     0.200
     0.321     2.763     0.200
     0.429     3.031     0.200
     0.394     3.613     0.200
     0.451     3.347     0.200
     0.504     3.589     0.200
     0.513     3.458     0.200
     0.527     5.201     0.200
     0.559     4.138     0.200
     0.610     3.723     0.200
     0.607     3.874     0.200
     0.678     4.196     0.200
     0.671     3.977     0.200
     0.658     4.411     0.200
     0.675     4.461     0.200
     0.716     4.861     0.200
     0.692     4.575     0.200
     0.766     4.320     0.200
     0.802     4.775     0.200
     0.835     4.685     0.200
     0.813     5.178     0.200
     0.887     5.828     0.200
     0.906     7.282     0.200
     0.921     4.829     0.200
     0.928     5.591     0.200
     0.934     5.381     0.200
     1.028     5.524     0.200
     1.045     6.443     0.200
     1.098     5.692     0.200
     1.120     5.873     0.200
     1.139     5.971     0.200
     1.124     7.570     0.200
     1.183     6.809     0.200
     1.200     7.601     0.200
     1.238     8.293     0.200
     1.224     8.171     0.200
     1.259     6.581     0.200
     1.405     6.922     0.200
     4.203    20.482     0.200
     0.180     2.332     0.200
     0.387     2.874     0.200
     0.392     2.655     0.200
     0.378     3.035     0.200
     0.355     3.598     0.200
     0.421     3.466     0.200
     0.507     3.220     0.200
     0.467     3.597     0.200
     0.599     3.813     0.200
     0.569     3.987     0.200
     0.587     3.699     0.200
     0.651     4.002     0.200
     0.686     4.096     0.200
     0.746     4.256     0.200
     0.688     4.883     0.200
     0.791     4.389     0.200
     0.726     4.759     0.200
     0.837     4.992     0.200
     0.810     5.604     0.200
     0.924     5.712     0.200
     0.953     5.309     0.200
     1.014     5.530     0.200
     0.990     5.425     0.200
     0.974     5.825     0.200
     1.003     6.265     0.200
     1.025     7.334     0.200
     1.103     6.812     0.200
     1.134     6.072     0.200
     1.105     6.731     0.200
     1.130     6.667     0.200
     1.242     7.014     0.200
     1.245     8.196     0.200
     1.245     8.856     0.200
     1.245     8.696     0.200
     1.271     8.341     0.200
     1.361     7.592     0.200
     1.386     8.927     0.200
     1.386     7.622     0.200
     1.386     7.065     0.200
     1.406     7.721     0.200
     1.435     7.792     0.200
     1.867    10.921     0.200
     1.755    10.345     0.200
     1.855    14.426     0.200
     2.247    12.301     0.200
     2.281    13.094     0.200
     2.328    13.883     0.200
     2.391    12.441     0.200
     2.482    13.447     0.200
     2.483    12.851     0.200
     2.561    13.164     0.200
     2.528    14.531     0.200
     2.722    14.122     0.200
     2.828    14.409     0.200
     3.136    15.623     0.200
     4.664    21.036     0.200
     0.176     1.872     0.200
     0.186     2.462     0.200
     0.181     1.996     0.200
     0.300     2.363     0.200
     0.307     2.431     0.200
     0.397     2.958     0.200
     0.393     3.028     0.200
     0.364     2.288     0.200
     0.357     3.502     0.200
     0.385     3.229     0.200
     0.425     3.436     0.200
     0.504     3.249     0.200
     0.521     3.915     0.200
     0.536     4.820     0.200
     0.562     3.692     0.200
     0.606     3.783     0.200
     0.590     3.684     0.200
     0.655     4.045     0.200
     0.692     4.138     0.200
     0.683     4.595     0.200
     0.752     4.119     0.200
     0.723     4.496     0.200
     0.727     4.810     0.200
     0.796     4.615     0.200
     0.804     5.404     0.200
     0.844     5.997     0.200
     0.926     6.312     0.200
     0.986     5.734     0.200
     0.970     6.327     0.200
     0.998     6.583     0.200
     1.027     6.225     0.200
     1.135     6.784     0.200
     1.099     6.964     0.200
     1.132     7.873     0.200
     1.245     8.327     0.200
     1.251     8.809     0.200
     1.242     8.384     0.200
     1.267     8.475     0.200
     1.338     9.642     0.200
     1.389     7.973     0.200
     1.345     7.942     0.200
     1.739    10.881     0.200
     1.849    14.559     0.200
     1.848    11.235     0.200
     1.941    11.667     0.200
     1.999    12.418     0.200
     2.079    14.668     0.200
     2.189    13.460     0.200
     2.287    14.394     0.200
     2.364    13.574     0.200
     2.392    13.081     0.200
     2.392    14.307     0.200
     2.537    13.559     0.200
     2.579    14.618     0.200
     2.818    15.396     0.200
     3.314    19.817     0.200
     3.946    20.582     0.200
     3.946    22.800     0.200
     0.151     1.862     0.200
     0.196     2.361     0.200
     0.206     2.148     0.200
     0.284     2.214     0.200
     0.270     2.156     0.200
     0.375     2.953     0.200
     0.373     2.982     0.200
     0.331     2.803     0.200
     0.385     3.058     0.200
     0.379     3.485     0.200
     0.374     2.654     0.200
     0.441     3.541     0.200
     0.485     3.488     0.200
     0.486     3.586     0.200
     0.546     4.289     0.200
     0.608     3.823     0.200
     0.608     3.658     0.200
     0.631     3.971     0.200
     0.681     4.152     0.200
     0.735     4.184     0.200
     0.707     5.200     0.200
     0.837     5.308     0.200
     0.901     6.496     0.200
     0.969     5.859     0.200
     1.020     7.266     0.200
     1.048     7.320     0.200
     1.110     6.741     0.200
     1.118     7.255     0.200
     1.154     7.270     0.200
     1.221     8.133     0.200
     1.316     9.490     0.200
     1.718    13.886     0.200
     1.923    12.030     0.200
     2.100    14.870     0.200
     2.173    12.697     0.200
     2.869    15.016     0.200
     0.144     1.967     0.200
     0.201     2.323     0.200
     0.213     2.127     0.200
     0.265     2.262     0.200
     0.280     2.181     0.200
     0.337     2.786     0.200
     0.367     2.902     0.200
     0.371     2.873     0.200
     0.387     3.067     0.200
     0.376     2.703     0.200
     0.386     3.436     0.200
     0.447     3.488     0.200
     0.479     3.561     0.200
     0.492     3.532     0.200
     0.553     4.174     0.200
     0.610     3.672     0.200
     0.625     4.033     0.200
     0.615     3.656     0.200
     0.679     4.055     0.200
     0.731     4.188     0.200
     0.713     5.239     0.200
     0.768     4.653     0.200
     0.757     5.570     0.200
     0.754     5.289     0.200
     0.837     4.905     0.200
     0.894     6.508     0.200
     0.964     5.895     0.200
     1.026     7.092     0.200
     1.055     6.468     0.200
     1.103     6.605     0.200
     1.122     7.051     0.200
     1.161     7.462     0.200
     1.215     8.120     0.200
     1.263     7.110     0.200
     1.298     9.002     0.200
     1.332     8.358     0.200
     1.920    11.227     0.200
     1.925    11.999     0.200
     2.181    12.107     0.200
     2.373    13.051     0.200
     2.474    16.025     0.200
     2.842    16.038     0.200
     0.046     1.961     0.200
     0.099     2.006     0.200
     0.192     2.038     0.200
     0.174     2.155     0.200
     0.204     2.415     0.200
     0.328     2.353     0.200
     0.285     2.676     0.200
     0.336     2.484     0.200
     0.420     3.115     0.200
     0.358     3.642     0.200
     0.421     3.143     0.200
     0.409     3.176     0.200
     0.434     3.696     0.200
     0.442     3.079     0.200
     0.501     3.619     0.200
     0.440     3.630     0.200
     0.537     4.026     0.200
     0.511     4.377     0.200
     0.518     4.726     0.200
     0.604     5.524     0.200
     0.596     3.802     0.200
     0.629     3.863     0.200
     0.721     4.252     0.200
     0.661     4.584     0.200
     0.754     5.383     0.200
     0.705     4.845     0.200
     0.780     4.500     0.200
     0.820     4.726     0.200
     0.941     6.366     0.200
     0.979     5.586     0.200
     0.973     7.012     0.200
     1.028     7.021     0.200
     1.028     6.911     0.200
     1.072     6.975     0.200
     1.148     6.541     0.200
     1.130     7.466     0.200
     1.278     8.229     0.200
     1.313     9.012     0.200
     1.246     8.288     0.200
     1.459     7.679     0.200
     0.043     2.026     0.200
     0.186     1.875     0.200
     0.177     2.249     0.200
     0.198     2.441     0.200
     0.318     2.351     0.200
     0.293     2.802     0.200
     0.346     2.459     0.200
     0.358     3.563     0.200
     0.411     2.776     0.200
     0.411     3.010     0.200
     0.401     3.077     0.200
     0.431     3.603     0.200
     0.452     3.296     0.200
     0.448     3.442     0.200
     0.502     3.498     0.200
     0.515     4.301     0.200
     0.546     3.785     0.200
     0.594     3.666     0.200
     0.621     3.847     0.200
     0.669     4.510     0.200
     0.711     4.290     0.200
     0.711     5.075     0.200
     0.712     4.825     0.200
     0.759     5.383     0.200
     0.770     4.527     0.200
     0.811     4.522     0.200
     0.787     5.594     0.200
     0.935     5.797     0.200
     0.981     5.883     0.200
     1.143     6.402     0.200
     1.131     7.415     0.200
     1.268     8.976     0.200
     0.116     3.103     0.200
     0.139     2.561     0.200
     0.143     2.262     0.200
     0.230     2.774     0.200
     0.257     2.916     0.200
     0.334     2.829     0.200
     0.345     3.048     0.200
     0.371     3.993     0.200
     0.401     3.127     0.200
     0.445     3.544     0.200
     0.461     3.363     0.200
     0.480     3.160     0.200
     0.481     3.876     0.200
     0.528     3.820     0.200
     0.583     4.317     0.200
     0.610     4.914     0.200
     0.613     4.384     0.200
     0.663     5.346     0.200
     0.695     4.431     0.200
     0.729     5.025     0.200
     0.741     5.114     0.200
     0.767     5.225     0.200
     0.844     5.103     0.200
     0.853     5.146     0.200
     0.910     6.472     0.200
     0.938     6.137     0.200
     0.948     5.634     0.200
     1.016     7.061     0.200
     1.054     7.461     0.200
     1.056     7.793     0.200
     1.070     7.382     0.200
     1.103     7.564     0.200
     1.132     6.416     0.200
     1.139     8.013     0.200
     1.167     6.931     0.200
     1.180     8.651     0.200
     1.247     7.794     0.200
     1.257     8.096     0.200
     0.070     2.137     0.200
     0.117     2.460     0.200
     0.196     3.218     0.200
     0.321     3.206     0.200
     0.324     3.328     0.200
     0.351     3.236     0.200
     0.365     3.235     0.200
     0.362     3.613     0.200
     0.475     3.278     0.200
     0.495     3.792     0.200
     0.541     3.694     0.200
     0.546     3.564     0.200
     0.518     4.683     0.200
     0.580     3.790     0.200
     0.582     4.096     0.200
     0.613     4.242     0.200
     0.577     4.471     0.200
     0.581     3.790     0.200
     0.581     3.907     0.200
     0.641     4.485     0.200
     0.700     4.966     0.200
     0.722     4.351     0.200
     0.704     4.876     0.200
     0.703     5.204     0.200
     0.737     4.641     0.200
     0.737     4.430     0.200
     0.779     4.710     0.200
     0.798     4.882     0.200
     0.854     4.832     0.200
     0.854     5.019     0.200
     0.892     5.533     0.200
     0.943     5.295     0.200
     0.977     6.872     0.200
     0.993     6.394     0.200
     1.023     5.520     0.200
     1.031     5.922     0.200
     1.024     6.156     0.200
     1.089     6.388     0.200
     1.064     7.244     0.200
     1.177     6.411     0.200
     1.123     7.323     0.200
     1.215     6.532     0.200
     1.173     7.055     0.200
     1.244     6.704     0.200
     1.239     7.655     0.200
     1.295     7.733     0.200
     1.337     7.518     0.200
     1.370     7.467     0.200
     1.429     7.689     0.200
     1.407     8.194     0.200
     1.405     8.732     0.200
     1.493     7.617     0.200
     1.507     7.622     0.200
     1.522     8.075     0.200
     1.528     8.276     0.200
     1.535     8.174     0.200
     1.820    11.146     0.200
     1.694     8.803     0.200
     1.720     9.060     0.200
     1.995    11.483     0.200
     2.009    11.210     0.200
     2.158    11.787     0.200
     2.273    12.396     0.200
     2.369    12.242     0.200
     2.337    13.051     0.200
     2.388    12.656     0.200
     2.430    12.424     0.200
     2.578    13.526     0.200
     2.642    15.584     0.200
     2.703    13.975     0.200
     2.799    14.757     0.200
     2.864    14.439     0.200
     3.446    17.264     0.200
     0.182     2.371     0.200
     0.290     3.214     0.200
     0.356     3.230     0.200
     0.375     3.343     0.200
     0.419     4.099     0.200
     0.423     4.027     0.200
     0.418     3.815     0.200
     0.553     3.827     0.200
     0.603     4.680     0.200
     0.612     4.360     0.200
     0.612     4.284     0.200
     0.631     4.718     0.200
     0.680     4.691     0.200
     0.701     5.189     0.200
     0.739     4.312     0.200
     0.700     4.759     0.200
     0.743     5.587     0.200
     0.798     4.998     0.200
     0.826     4.787     0.200
     0.835     4.905     0.200
     0.834     5.846     0.200
     0.848     5.491     0.200
     0.903     5.336     0.200
     0.912     5.224     0.200
     0.939     6.743     0.200
     0.947     6.336     0.200
     1.016     5.697     0.200
     0.993     6.214     0.200
     1.014     6.528     0.200
     1.111     6.327     0.200
     1.074     7.179     0.200
     1.231     6.904     0.200
     1.558     8.502     0.200
     1.569     9.393     0.200
     1.639     9.074     0.200
     1.634     9.593     0.200
     1.732     9.120     0.200
     1.742     9.645     0.200
     1.757     9.608     0.200
     1.783     9.867     0.200
     1.804     9.470     0.200
     1.913    10.157     0.200
     2.366    13.260     0.200
     2.798    14.242     0.200
     4.129    22.616     0.200
     4.690    21.072     0.200
     5.040    23.193     0.200
     0.190     2.138     0.200
     0.290     3.078     0.200
     0.363     2.974     0.200
     0.431     3.778     0.200
     0.440     3.676     0.200
     0.419     3.913     0.200
     0.548     4.019     0.200
     0.605     4.194     0.200
     0.620     4.144     0.200
     0.623     3.984     0.200
     0.648     4.475     0.200
     0.695     4.395     0.200
     0.718     5.084     0.200
     0.714     5.281     0.200
     0.761     5.156     0.200
     0.812     5.026     0.200
     0.839     4.610     0.200
     0.865     5.126     0.200
     0.906     5.256     0.200
     0.920     5.336     0.200
     0.953     6.542     0.200
     0.958     6.528     0.200
     1.010     5.799     0.200
     1.031     6.538     0.200
     1.089     6.809     0.200
     1.109     6.259     0.200
     1.234     6.593     0.200
     1.257     7.526     0.200
     1.282     6.999     0.200
     1.294     7.455     0.200
     1.301     7.331     0.200
     1.407     8.748     0.200
     1.625     9.464     0.200
     1.738    10.932     0.200
     1.751    10.025     0.200
     1.782     9.558     0.200
     1.822     9.416     0.200
     1.907    10.663     0.200
     1.967    10.180     0.200
     2.069    12.501     0.200
     2.061    10.181     0.200
     2.097    10.592     0.200
     2.133    10.767     0.200
     2.362    12.538     0.200
     0.061     3.173     0.200
     0.186     2.902     0.200
     0.241     2.712     0.200
     0.223     2.690     0.200
     0.301     3.035     0.200
     0.314     2.924     0.200
     0.381     3.495     0.200
     0.423     2.958     0.200
     0.420     3.676     0.200
     0.476     3.312     0.200
     0.514     3.877     0.200
     0.524     3.985     0.200
     0.573     3.286     0.200
     0.569     3.704     0.200
     0.576     3.769     0.200
     0.604     3.880     0.200
     0.658     4.279     0.200
     0.616     4.245     0.200
     0.683     4.301     0.200
     0.736     4.788     0.200
     0.713     5.130     0.200
     0.726     4.768     0.200
     0.719     5.188     0.200
     0.728     5.211     0.200
     0.839     5.466     0.200
     0.913     5.989     0.200
     1.012     6.743     0.200
     1.305     7.878     0.200
     1.382     7.230     0.200
     0.039     1.407     0.200
     0.194     1.576     0.200
     0.239     2.759     0.200
     0.201     3.316     0.200
     0.250     1.749     0.200
     0.311     2.516     0.200
     0.332     2.387     0.200
     0.338     3.113     0.200
     0.355     2.619     0.200
     0.404     3.008     0.200
     0.399     3.447     0.200
     0.435     3.380     0.200
     0.421     4.196     0.200
     0.474     3.224     0.200
     0.480     4.015     0.200
     0.499     5.088     0.200
     0.510     3.184     0.200
     0.614     3.809     0.200
     0.698     4.586     0.200
     0.676     5.074     0.200
     0.724     4.658     0.200
     0.677     4.797     0.200
     0.722     4.322     0.200
     0.700     4.524     0.200
     0.746     4.844     0.200
     0.758     4.838     0.200
     0.816     6.019     0.200
     0.835     4.728     0.200
     0.852     5.910     0.200
     0.873     6.111     0.200
     0.852     5.226     0.200
     0.944     5.457     0.200
     0.936     6.042     0.200
     0.944     7.055     0.200
     0.964     7.223     0.200
     0.961     5.794     0.200
     1.030     5.827     0.200
     1.045     6.400     0.200
     1.048     6.086     0.200
     1.008     7.232     0.200
     1.075     6.455     0.200
     1.156     7.889     0.200
     1.161     8.089     0.200
     1.185     7.353     0.200
     1.214     7.197     0.200
     1.234     7.315     0.200
     1.234     6.940     0.200
     1.264     7.383     0.200
     1.235     8.481     0.200
     1.262     8.291     0.200
     1.262     8.494     0.200
     1.310     7.533     0.200
     1.332     8.055     0.200
     1.353     8.847     0.200
     1.357     7.628     0.200
     1.317     8.411     0.200
     1.380     9.289     0.200
     1.370     8.704     0.200
     1.421     9.000     0.200
     1.441     8.411     0.200
     1.463     8.354     0.200
     1.461     9.110     0.200
     1.503     8.142     0.200
     1.477    10.268     0.200
     1.496    10.002     0.200
     1.523     9.597     0.200
     1.592     9.792     0.200
     1.599     9.061     0.200
     1.560    10.026     0.200
     1.561     9.354     0.200
     1.560     9.077     0.200
     1.600    10.210     0.200
     1.607     9.612     0.200
     1.723     9.931     0.200
     1.723     9.424     0.200
     1.740     9.985     0.200
     1.891    12.203     0.200
     1.938    12.426     0.200
     2.123    12.042     0.200
     2.126    12.833     0.200
     2.104    12.363     0.200
     2.242    13.814     0.200
     2.328    12.969     0.200
     2.329    12.784     0.200
     2.331    13.104     0.200
     2.372    13.827     0.200
     2.372    13.257     0.200
     2.418    13.075     0.200
     2.511    13.659     0.200
     2.533    13.697     0.200
     2.651    14.037     0.200
     2.671    14.746     0.200
     2.754    15.132     0.200
     2.757    15.282     0.200
     2.857    15.235     0.200
     3.333    16.211     0.200
     4.332    25.407     0.200
     0.170     1.541     0.200
     0.222     2.009     0.200
     0.223     2.797     0.200
     0.249     2.467     0.200
     0.295     2.366     0.200
     0.304     2.535     0.200
     0.338     2.473     0.200
     0.333     2.841     0.200
     0.390     3.010     0.200
     0.453     3.063     0.200
     0.427     2.833     0.200
     0.453     2.991     0.200
     0.436     3.735     0.200
     0.479     3.780     0.200
     0.491     3.258     0.200
     0.506     4.853     0.200
     0.616     3.684     0.200
     0.669     4.486     0.200
     0.685     5.058     0.200
     0.733     4.506     0.200
     0.746     4.737     0.200
     0.757     4.521     0.200
     0.821     4.596     0.200
     0.849     4.990     0.200
     0.878     5.327     0.200
     0.901     6.799     0.200
     0.940     5.253     0.200
     0.945     6.107     0.200
     0.976     5.476     0.200
     0.990     6.578     0.200
     1.036     6.059     0.200
     1.011     7.868     0.200
     1.046     6.463     0.200
     1.240     7.617     0.200
     1.294     7.216     0.200
     1.278     8.288     0.200
     1.311     7.973     0.200
     1.885    11.157     0.200
     7.644    32.916     0.200
     0.031     1.682     0.200
     0.191     1.639     0.200
     0.244     1.950     0.200
     0.236     2.814     0.200
     0.209     3.357     0.200
     0.303     2.407     0.200
     0.324     2.506     0.200
     0.355     2.697     0.200
     0.342     2.959     0.200
     0.396     3.129     0.200
     0.465     3.130     0.200
     0.406     3.361     0.200
     0.435     3.359     0.200
     0.429     4.116     0.200
     0.509     3.276     0.200
     0.485     3.804     0.200
     0.506     5.009     0.200
     0.609     3.840     0.200
     0.691     4.646     0.200
     0.683     4.686     0.200
     0.751     4.607     0.200
     0.762     4.833     0.200
     0.827     5.049     0.200
     0.857     5.164     0.200
     0.860     5.768     0.200
     0.938     5.537     0.200
     0.879     7.097     0.200
     0.943     6.104     0.200
     0.972     6.793     0.200
     1.069     6.739     0.200
     1.270     8.526     0.200
     1.321     8.268     0.200
     0.044     1.515     0.200
     0.192     1.517     0.200
     0.251     1.866     0.200
     0.245     2.939     0.200
     0.316     2.464     0.200
     0.334     2.453     0.200
     0.332     2.864     0.200
     0.350     2.650     0.200
     0.397     3.524     0.200
     0.410     3.187     0.200
     0.415     4.273     0.200
     0.474     3.754     0.200
     0.479     3.196     0.200
     0.486     3.239     0.200
     0.493     5.023     0.200
     0.505     3.304     0.200
     0.621     4.249     0.200
     0.671     4.647     0.200
     0.699     4.676     0.200
     0.739     4.669     0.200
     0.751     4.687     0.200
     0.841     4.682     0.200
     0.846     4.995     0.200
     0.849     6.898     0.200
     0.950     5.849     0.200
     1.051     6.699     0.200
     1.081     7.402     0.200
     1.268     7.646     0.200
     0.032     1.757     0.200
     0.196     1.694     0.200
     0.233     2.785     0.200
     0.248     1.941     0.200
     0.303     2.434     0.200
     0.327     2.438     0.200
     0.345     2.917     0.200
     0.359     2.715     0.200
     0.396     3.146     0.200
     0.403     3.353     0.200
     0.431     3.335     0.200
     0.466     3.104     0.200
     0.429     4.119     0.200
     0.487     3.852     0.200
     0.514     3.256     0.200
     0.507     4.964     0.200
     0.607     3.904     0.200
     0.695     4.689     0.200
     0.714     4.370     0.200
     0.684     4.965     0.200
     0.685     4.620     0.200
     0.765     4.690     0.200
     0.827     4.617     0.200
     0.857     5.865     0.200
     0.859     5.588     0.200
     0.875     6.597     0.200
     0.936     5.392     0.200
     0.944     5.964     0.200
     0.952     6.837     0.200
     0.970     7.016     0.200
     0.969     5.390     0.200
     1.037     6.160     0.200
     1.040     6.015     0.200
     1.067     6.196     0.200
     1.183     7.138     0.200
     1.226     6.345     0.200
     1.226     7.767     0.200
     1.257     7.631     0.200
     1.302     7.177     0.200
     1.270     8.371     0.200
     1.325     7.838     0.200
     1.345     7.527     0.200
     1.349     7.602     0.200
     1.324     8.114     0.200
     1.433     8.301     0.200
     1.495     8.951     0.200
     1.584     9.577     0.200
     1.592     9.239     0.200
     1.568     9.011     0.200
     1.567     9.120     0.200
     1.615     9.513     0.200
     1.732     9.733     0.200
     1.865    11.029     0.200
     1.877    11.137     0.200
     1.884    11.042     0.200
     2.097    12.246     0.200
     2.470    13.540     0.200
     4.063    20.197     0.200
     4.846    23.393     0.200
     0.043     1.961     0.200
     0.169     3.032     0.200
     0.205     2.564     0.200
     0.246     2.597     0.200
     0.237     3.011     0.200
     0.328     2.926     0.200
     0.314     2.823     0.200
     0.381     3.813     0.200
     0.453     3.516     0.200
     0.454     3.628     0.200
     0.528     4.030     0.200
     0.535     3.842     0.200
     0.522     3.711     0.200
     0.520     3.731     0.200
     0.520     4.624     0.200
     0.557     4.499     0.200
     0.624     4.287     0.200
     0.633     4.109     0.200
     0.668     4.820     0.200
     0.662     4.889     0.200
     0.669     4.667     0.200
     0.663     4.734     0.200
     0.681     4.245     0.200
     0.709     5.049     0.200
     0.786     4.809     0.200
     0.797     5.025     0.200
     0.858     5.066     0.200
     0.907     6.410     0.200
     0.889     5.247     0.200
     0.944     5.299     0.200
     0.924     5.588     0.200
     0.973     5.641     0.200
     1.036     6.488     0.200
     1.117     6.430     0.200
     1.141     6.365     0.200
     1.108     7.471     0.200
     1.162     6.474     0.200
     1.181     7.617     0.200
     1.209     8.019     0.200
     1.234     8.054     0.200
     1.278     6.791     0.200
     1.330     7.965     0.200
     1.396     8.313     0.200
     1.427     7.422     0.200
     1.399     8.834     0.200
     1.433     8.212     0.200
     1.414     8.705     0.200
     1.478     7.981     0.200
     1.479     7.971     0.200
     1.528     9.219     0.200
     1.525     9.064     0.200
     1.529     9.161     0.200
     1.617     9.761     0.200
     1.579     9.238     0.200
     1.606     9.414     0.200
     1.626     9.844     0.200
     1.678     9.663     0.200
     1.735     9.598     0.200
     1.732    10.076     0.200
     1.732     9.764     0.200
     1.908    10.636     0.200
     2.424    13.669     0.200
     4.350    22.170     0.200
     0.033     1.882     0.200
     0.151     1.987     0.200
     0.193     1.780     0.200
     0.207     3.048     0.200
     0.236     2.698     0.200
     0.232     2.828     0.200
     0.246     2.090     0.200
     0.305     2.459     0.200
     0.327     2.646     0.200
     0.341     2.839     0.200
     0.355     2.708     0.200
     0.398     3.160     0.200
     0.404     3.093     0.200
     0.435     3.179     0.200
     0.468     3.160     0.200
     0.484     3.639     0.200
     0.504     4.761     0.200
     0.510     3.236     0.200
     0.610     3.715     0.200
     0.693     4.906     0.200
     0.682     4.455     0.200
     0.716     4.254     0.200
     0.721     4.532     0.200
     0.723     4.180     0.200
     0.714     3.970     0.200
     0.750     4.554     0.200
     0.829     4.674     0.200
     0.857     5.183     0.200
     0.856     5.208     0.200
     0.939     5.159     0.200
     0.941     5.650     0.200
     0.970     6.208     0.200
     0.967     5.086     0.200
     1.070     6.817     0.200
     1.162     7.606     0.200
     1.164     7.374     0.200
     1.268     8.024     0.200
     1.328     8.087     0.200
     1.320     7.950     0.200
     1.564     9.187     0.200
     1.613     9.193     0.200
     1.880    12.311     0.200
     2.529    14.165     0.200
     3.100    18.145     0.200
     3.861    22.490     0.200
     0.135     2.542     0.200
     0.257     2.941     0.200
     0.249     2.814     0.200
     0.194     2.662     0.200
     0.276     3.639     0.200
     0.330     3.269     0.200
     0.416     3.336     0.200
     0.501     3.416     0.200
     0.505     3.359     0.200
     0.463     4.038     0.200
     0.561     3.743     0.200
     0.557     3.600     0.200
     0.487     3.440     0.200
     0.589     4.124     0.200
     0.568     4.039     0.200
     0.598     4.569     0.200
     0.619     3.999     0.200
     0.569     3.995     0.200
     0.637     4.048     0.200
     0.615     5.459     0.200
     0.682     4.137     0.200
     0.665     4.845     0.200
     0.637     4.822     0.200
     0.771     4.630     0.200
     0.743     4.949     0.200
     0.795     4.772     0.200
     0.796     4.644     0.200
     0.764     5.555     0.200
     0.803     5.207     0.200
     0.887     5.082     0.200
     0.938     5.550     0.200
     0.895     5.267     0.200
     0.954     5.224     0.200
     0.988     5.536     0.200
     0.997     6.500     0.200
     0.995     6.080     0.200
     1.027     5.980     0.200
     1.086     5.948     0.200
     1.138     6.162     0.200
     1.182     6.282     0.200
     1.186     6.814     0.200
     1.165     7.473     0.200
     1.246     7.074     0.200
     1.270     7.051     0.200
     1.220     7.339     0.200
     1.332     7.212     0.200
     1.276     7.695     0.200
     1.436     7.175     0.200
     1.477     7.781     0.200
     1.599     9.706     0.200
     1.635    10.225     0.200
     1.682     9.663     0.200
     1.718    10.024     0.200
     1.909    10.592     0.200
     2.174    11.276     0.200
     2.430    12.310     0.200
     2.603    13.139     0.200
     3.452    20.515     0.200
     4.321    19.924     0.200
     0.173     2.662     0.200
     0.176     2.888     0.200
     0.234     2.507     0.200
     0.236     2.742     0.200
     0.304     3.015     0.200
     0.303     2.994     0.200
     0.312     4.106     0.200
     0.368     3.490     0.200
     0.372     2.807     0.200
     0.413     3.050     0.200
     0.429     3.594     0.200
     0.455     3.654     0.200
     0.474     3.330     0.200
     0.489     3.024     0.200
     0.501     3.907     0.200
     0.537     3.800     0.200
     0.563     3.644     0.200
     0.574     3.681     0.200
     0.575     3.784     0.200
     0.591     3.913     0.200
     0.620     3.932     0.200
     0.664     4.248     0.200
     0.678     4.254     0.200
     0.706     3.968     0.200
     0.721     4.996     0.200
     0.715     4.645     0.200
     0.723     4.475     0.200
     0.739     4.650     0.200
     0.786     5.659     0.200
     0.788     5.727     0.200
     0.797     6.235     0.200
     0.798     6.112     0.200
     0.808     6.138     0.200
     0.819     4.944     0.200
     0.811     5.744     0.200
     0.827     6.068     0.200
     0.909     6.253     0.200
     0.914     6.470     0.200
     0.925     6.840     0.200
     0.949     6.364     0.200
     0.964     5.316     0.200
     0.986     5.783     0.200
     1.031     6.609     0.200
     1.066     6.224     0.200
     1.165     6.827     0.200
     1.205     7.657     0.200
     1.307     7.994     0.200
     1.319     8.361     0.200
     1.350     8.347     0.200
     1.377     7.385     0.200
     1.625     9.814     0.200
     1.643     9.346     0.200
     1.669    10.299     0.200
     1.716     9.083     0.200
     1.737    10.789     0.200
     1.765     9.595     0.200
     1.872    10.335     0.200
     1.911    10.650     0.200
     2.001    11.087     0.200
     2.092    10.027     0.200
     2.096    10.863     0.200
     2.145    10.917     0.200
     2.303    11.480     0.200
     2.307    11.292     0.200
     2.326    12.119     0.200
     2.428    12.621     0.200
     2.512    11.886     0.200
     2.591    13.262     0.200
     2.697    12.479     0.200
     2.732    12.858     0.200
     2.738    14.019     0.200
     5.543    31.420     0.200
     0.061     3.136     0.200
     0.164     2.763     0.200
     0.184     2.966     0.200
     0.227     2.586     0.200
     0.238     2.741     0.200
     0.300     3.017     0.200
     0.311     2.915     0.200
     0.322     3.988     0.200
     0.373     2.774     0.200
     0.377     3.485     0.200
     0.422     3.665     0.200
     0.419     3.078     0.200
     0.474     3.304     0.200
     0.464     3.679     0.200
     0.486     3.116     0.200
     0.527     3.907     0.200
     0.510     3.891     0.200
     0.569     3.693     0.200
     0.575     3.745     0.200
     0.569     3.670     0.200
     0.601     3.834     0.200
     0.618     4.143     0.200
     0.659     4.242     0.200
     0.681     4.346     0.200
     0.735     4.403     0.200
     0.732     4.971     0.200
     0.721     4.865     0.200
     0.712     4.036     0.200
     0.724     4.845     0.200
     0.733     4.669     0.200
     0.812     5.097     0.200
     0.792     5.613     0.200
     0.795     6.079     0.200
     0.803     5.766     0.200
     0.805     6.167     0.200
     0.811     6.026     0.200
     0.814     5.772     0.200
     0.817     5.806     0.200
     0.836     5.743     0.200
     0.911     6.695     0.200
     0.958     5.347     0.200
     0.921     6.598     0.200
     1.158     6.406     0.200
     1.304     7.930     0.200
     1.273     8.485     0.200
     1.328     8.583     0.200
     1.356     8.138     0.200
     1.364     8.706     0.200
     1.378     8.234     0.200
     1.418     8.561     0.200
     1.430     9.204     0.200
     1.523     7.890     0.200
     1.478     8.966     0.200
     1.593    10.639     0.200
     1.579     9.992     0.200
     1.634    10.205     0.200
     1.711    10.774     0.200
     1.728    10.642     0.200
     1.818    10.820     0.200
     1.782    11.593     0.200
     1.864    10.518     0.200
     1.894    11.252     0.200
     1.903    10.775     0.200
     1.910    11.049     0.200
     1.942    10.895     0.200
     1.984    10.723     0.200
     1.993    11.247     0.200
     1.992    10.669     0.200
     2.421    12.963     0.200
     2.535    13.429     0.200
     2.722    14.017     0.200
     2.730    13.536     0.200
     2.853    14.297     0.200
     0.107     4.117     0.200
     0.107     4.388     0.200
     0.196     4.023     0.200
     0.182     4.364     0.200
     0.325     4.756     0.200
     0.503     5.018     0.200
     0.677     5.766     0.200
     0.669     5.562     0.200
     0.729     6.274     0.200
     0.702     5.470     0.200
     0.827     6.524     0.200
     0.785     5.825     0.200
     0.813     6.690     0.200
     0.914     6.675     0.200
     0.920     5.937     0.200
     0.861     5.964     0.200
     0.933     6.320     0.200
     0.922     6.295     0.200
     0.945     6.295     0.200
     0.959     6.003     0.200
     0.927     6.180     0.200
     0.999     6.023     0.200
     1.052     6.006     0.200
     1.089     6.227     0.200
     1.167     6.324     0.200
     1.459     8.889     0.200
     1.525     8.605     0.200
     1.529     8.919     0.200
     1.602     8.839     0.200
     1.737     9.731     0.200
     1.778     9.408     0.200
     1.828     9.896     0.200
     1.828     9.716     0.200
     1.837     9.156     0.200
     1.836     9.593     0.200
     1.879    10.328     0.200
     1.963    10.300     0.200
     2.005    10.830     0.200
     2.015    11.244     0.200
     2.030    10.458     0.200
     2.039    10.330     0.200
     2.085    10.153     0.200
     2.099    10.183     0.200
     2.107    10.339     0.200
     2.128    10.439     0.200
     2.142    10.662     0.200
     2.262    10.894     0.200
     2.384    11.196     0.200
     0.109     4.140     0.200
     0.256     3.861     0.200
     0.571     5.029     0.200
     0.686     5.806     0.200
     0.744     5.744     0.200
     0.779     6.374     0.200
     0.761     5.756     0.200
     0.815     6.983     0.200
     0.765     5.483     0.200
     0.858     5.845     0.200
     0.903     6.360     0.200
     0.847     5.821     0.200
     1.094     6.711     0.200
     1.197     6.942     0.200
     1.228     7.186     0.200
     1.294     7.637     0.200
     1.297     7.686     0.200
     1.408     7.678     0.200
     1.493     7.544     0.200
     1.627     8.349     0.200
     1.635     8.861     0.200
     1.625     9.027     0.200
     1.724     8.922     0.200
     1.990    10.093     0.200
     2.030    10.398     0.200
     2.370    10.739     0.200
     0.140     2.583     0.200
     0.207     2.548     0.200
     0.178     3.308     0.200
     0.223     2.308     0.200
     0.218     3.300     0.200
     0.255     3.511     0.200
     0.306     2.650     0.200
     0.301     3.026     0.200
     0.344     2.787     0.200
     0.396     3.826     0.200
     0.337     3.138     0.200
     0.347     2.722     0.200
     0.420     3.177     0.200
     0.365     3.435     0.200
     0.402     3.203     0.200
     0.415     3.224     0.200
     0.476     3.296     0.200
     0.441     3.227     0.200
     0.553     3.872     0.200
     0.575     4.422     0.200
     0.514     3.410     0.200
     0.559     4.517     0.200
     0.561     4.633     0.200
     0.571     4.671     0.200
     0.579     5.177     0.200
     0.624     3.899     0.200
     0.582     4.644     0.200
     0.564     3.912     0.200
     0.609     4.972     0.200
     0.689     3.910     0.200
     0.666     4.844     0.200
     0.751     4.889     0.200
     0.727     6.082     0.200
     0.751     6.101     0.200
     0.724     5.918     0.200
     0.786     5.999     0.200
     0.824     5.189     0.200
     0.854     5.922     0.200
     0.876     6.171     0.200
     0.918     6.232     0.200
     0.913     5.815     0.200
     0.967     6.560     0.200
     0.991     6.350     0.200
     1.046     7.154     0.200
     1.280     7.453     0.200
     1.222     7.799     0.200
     1.231     7.829     0.200
     1.328     8.246     0.200
     2.150    12.257     0.200
     2.466    12.474     0.200
     2.469    12.338     0.200
     2.671    12.990     0.200
     0.186     1.972     0.200
     0.231     2.605     0.200
     0.251     2.540     0.200
     0.330     3.950     0.200
     0.348     3.401     0.200
     0.454     3.556     0.200
     0.484     3.293     0.200
     0.534     3.439     0.200
     0.529     3.198     0.200
     0.535     3.784     0.200
     0.525     4.295     0.200
     0.531     3.563     0.200
     0.572     3.768     0.200
     0.623     3.962     0.200
     0.678     6.240     0.200
     0.678     3.861     0.200
     0.675     4.313     0.200
     0.675     5.834     0.200
     0.722     4.205     0.200
     0.722     4.076     0.200
     0.720     5.299     0.200
     0.807     4.874     0.200
     0.806     5.181     0.200
     0.834     5.021     0.200
     0.834     5.221     0.200
     0.882     4.881     0.200
     0.863     5.460     0.200
     0.930     5.229     0.200
     0.913     4.850     0.200
     1.030     5.434     0.200
     1.004     6.592     0.200
     1.273     6.660     0.200
     1.622     8.242     0.200
     1.766     8.850     0.200
     1.987    11.395     0.200
     2.449    11.788     0.200
     3.033    14.847     0.200
     3.372    17.272     0.200
     0.175     2.313     0.200
     0.206     2.440     0.200
     0.236     2.625     0.200
     0.260     2.469     0.200
     0.345     3.721     0.200
     0.360     3.396     0.200
     0.468     3.533     0.200
     0.489     3.347     0.200
     0.528     3.746     0.200
     0.538     3.822     0.200
     0.533     3.205     0.200
     0.544     3.497     0.200
     0.539     4.091     0.200
     0.566     3.698     0.200
     0.583     3.722     0.200
     0.633     3.987     0.200
     0.631     4.187     0.200
     0.668     3.927     0.200
     0.681     4.035     0.200
     0.681     3.894     0.200
     0.681     4.191     0.200
     0.690     4.193     0.200
     0.717     4.288     0.200
     0.690     5.443     0.200
     0.734     4.945     0.200
     0.811     5.421     0.200
     0.822     4.841     0.200
     0.819     5.000     0.200
     0.857     4.840     0.200
     0.854     5.024     0.200
     0.875     5.166     0.200
     0.849     4.871     0.200
     0.849     4.754     0.200
     0.878     5.367     0.200
     0.912     4.961     0.200
     0.920     5.514     0.200
     0.962     5.355     0.200
     0.943     5.170     0.200
     0.969     5.390     0.200
     1.023     5.629     0.200
     1.024     5.903     0.200
     1.010     5.597     0.200
     1.089     5.881     0.200
     1.118     5.966     0.200
     1.099     5.830     0.200
     1.145     5.955     0.200
     1.149     7.038     0.200
     1.168     6.371     0.200
     1.198     6.505     0.200
     1.201     6.519     0.200
     1.264     6.515     0.200
     1.264     6.702     0.200
     1.264     7.237     0.200
     1.315     7.939     0.200
     1.349     6.908     0.200
     1.361     7.152     0.200
     1.375     7.365     0.200
     1.351     8.638     0.200
     1.364     8.593     0.200
     1.391     8.749     0.200
     1.444     8.997     0.200
     1.470     8.050     0.200
     1.533     8.014     0.200
     1.533     8.586     0.200
     1.574     9.222     0.200
     1.577     8.452     0.200
     1.612     8.354     0.200
     1.581     9.179     0.200
     1.643     9.821     0.200
     1.850     9.935     0.200
     2.436    11.922     0.200
     3.405    19.994     0.200
     4.451    19.429     0.200
     0.189     1.835     0.200
     0.227     2.493     0.200
     0.185     2.274     0.200
     0.249     2.144     0.200
     0.341     3.245     0.200
     0.324     3.396     0.200
     0.479     3.180     0.200
     0.447     3.423     0.200
     0.535     3.386     0.200
     0.531     3.595     0.200
     0.524     3.396     0.200
     0.521     3.908     0.200
     0.531     2.765     0.200
     0.565     3.621     0.200
     0.617     3.869     0.200
     0.610     4.025     0.200
     0.659     3.726     0.200
     0.668     4.107     0.200
     0.721     3.966     0.200
     0.670     5.230     0.200
     0.680     3.250     0.200
     0.680     3.570     0.200
     0.680     3.383     0.200
     0.713     4.762     0.200
     0.804     4.740     0.200
     0.843     4.921     0.200
     0.852     4.630     0.200
     0.801     4.773     0.200
     0.809     4.824     0.200
     0.827     4.581     0.200
     0.827     5.034     0.200
     0.883     5.557     0.200
     0.911     4.714     0.200
     0.858     5.182     0.200
     0.932     5.199     0.200
     0.956     5.119     0.200
     0.949     5.219     0.200
     1.031     6.159     0.200
     1.015     6.012     0.200
     1.091     5.701     0.200
     1.059     8.211     0.200
     1.059     7.863     0.200
     1.059     8.007     0.200
     1.073     7.546     0.200
     1.129     5.556     0.200
     1.078     6.344     0.200
     1.111     8.152     0.200
     1.134     7.959     0.200
     1.141     7.991     0.200
     1.192     7.682     0.200
     1.211     5.997     0.200
     1.182     6.334     0.200
     1.274     6.221     0.200
     1.274     6.557     0.200
     1.225     7.108     0.200
     1.296     8.004     0.200
     1.355     7.619     0.200
     1.373     7.170     0.200
     1.384     7.852     0.200
     1.392     6.808     0.200
     1.335     7.846     0.200
     1.416     7.382     0.200
     1.447     7.306     0.200
     1.489     8.149     0.200
     1.542     9.537     0.200
     1.547    10.339     0.200
     1.550     8.347     0.200
     1.577    10.670     0.200
     1.577    10.058     0.200
     1.598     9.670     0.200
     1.554     8.369     0.200
     1.624     7.761     0.200
     1.624     8.815     0.200
     1.561     8.670     0.200
     1.632     9.277     0.200
     1.651    10.667     0.200
     1.658    10.201     0.200
     1.658    10.576     0.200
     1.745     9.898     0.200
     3.426    16.809     0.200
     4.430    19.731     0.200
     9.064    42.726     0.200
     0.171     2.099     0.200
     0.214     2.396     0.200
     0.200     2.474     0.200
     0.269     2.461     0.200
     0.341     3.362     0.200
     0.337     3.772     0.200
     0.467     3.230     0.200
     0.453     3.527     0.200
     0.515     3.411     0.200
     0.517     3.666     0.200
     0.525     3.389     0.200
     0.537     4.176     0.200
     0.562     3.675     0.200
     0.549     3.074     0.200
     0.611     3.813     0.200
     0.646     3.801     0.200
     0.619     4.253     0.200
     0.702     4.156     0.200
     0.674     4.237     0.200
     0.698     4.273     0.200
     0.725     4.957     0.200
     0.801     4.656     0.200
     0.836     4.656     0.200
     0.831     4.845     0.200
     0.863     4.841     0.200
     0.832     4.910     0.200
     0.818     4.966     0.200
     0.827     5.610     0.200
     0.893     4.848     0.200
     0.912     5.309     0.200
     0.873     5.404     0.200
     0.942     5.098     0.200
     0.934     5.075     0.200
     1.011     5.185     0.200
     1.016     5.568     0.200
     1.021     5.987     0.200
     1.072     5.754     0.200
     1.109     5.738     0.200
     1.092     6.633     0.200
     1.191     6.307     0.200
     1.255     6.567     0.200
     1.243     8.287     0.200
     1.335     7.040     0.200
     1.353     7.047     0.200
     1.365     7.277     0.200
     1.395     7.147     0.200
     1.354     8.375     0.200
     1.433     7.365     0.200
     1.523     7.815     0.200
     1.528    10.287     0.200
     2.371    13.058     0.200
     2.462    13.040     0.200
     2.620    13.097     0.200
     2.629    13.274     0.200
     2.684    13.655     0.200
     0.205     2.016     0.200
     0.178     2.448     0.200
     0.245     2.591     0.200
     0.231     2.218     0.200
     0.318     3.600     0.200
     0.349     3.408     0.200
     0.449     3.539     0.200
     0.495     3.370     0.200
     0.554     3.545     0.200
     0.549     3.759     0.200
     0.511     2.737     0.200
     0.530     3.522     0.200
     0.509     4.046     0.200
     0.574     3.753     0.200
     0.629     4.063     0.200
     0.607     4.116     0.200
     0.676     4.035     0.200
     0.660     3.339     0.200
     0.670     4.191     0.200
     0.660     5.668     0.200
     0.740     4.127     0.200
     0.707     4.893     0.200
     0.789     4.437     0.200
     0.813     4.934     0.200
     0.789     4.871     0.200
     0.859     5.120     0.200
     0.871     4.832     0.200
     0.829     4.654     0.200
     0.902     4.985     0.200
     0.848     5.297     0.200
     0.930     4.868     0.200
     0.949     5.283     0.200
     0.940     5.307     0.200
     1.050     5.444     0.200
     1.033     6.965     0.200
     1.110     5.736     0.200
     1.147     5.837     0.200
     1.209     8.044     0.200
     1.293     6.408     0.200
     1.293     6.619     0.200
     1.374     6.689     0.200
     1.390     7.135     0.200
     1.321     8.472     0.200
     1.412     7.109     0.200
     1.465     7.531     0.200
     1.501     7.543     0.200
     1.641     8.230     0.200
     1.820     9.664     0.200
     3.037    14.920     0.200
     3.016    15.534     0.200
     4.432    18.531     0.200
     0.179     2.606     0.200
     0.249     2.618     0.200
     0.353     3.606     0.200
     0.320     3.966     0.200
     0.207     2.270     0.200
     0.229     2.488     0.200
     0.451     3.702     0.200
     0.500     3.498     0.200
     0.533     3.630     0.200
     0.578     3.918     0.200
     0.509     4.117     0.200
     0.553     3.817     0.200
     0.609     4.373     0.200
     0.634     4.076     0.200
     0.557     3.768     0.200
     0.673     4.251     0.200
     0.680     4.038     0.200
     0.508     3.101     0.200
     0.709     5.206     0.200
     0.817     4.989     0.200
     0.744     4.336     0.200
     0.832     4.981     0.200
     0.657     3.915     0.200
     0.789     5.016     0.200
     0.849     5.426     0.200
     0.875     4.837     0.200
     0.786     5.051     0.200
     0.934     5.080     0.200
     0.962     5.870     0.200
     0.979     5.409     0.200
     0.905     5.093     0.200
     0.951     5.500     0.200
     0.978     5.374     0.200
     1.053     5.504     0.200
     0.199     2.125     0.200
     0.190     2.359     0.200
     0.236     2.342     0.200
     0.251     2.618     0.200
     0.331     3.610     0.200
     0.361     3.321     0.200
     0.462     3.456     0.200
     0.503     3.320     0.200
     0.510     3.013     0.200
     0.519     4.072     0.200
     0.552     3.587     0.200
     0.555     3.753     0.200
     0.586     3.670     0.200
     0.640     3.930     0.200
     0.659     4.050     0.200
     0.683     3.889     0.200
     0.683     4.162     0.200
     0.740     4.201     0.200
     0.720     5.068     0.200
     0.788     5.158     0.200
     0.799     4.896     0.200
     0.825     4.781     0.200
     0.842     4.868     0.200
     0.867     5.115     0.200
     0.859     5.284     0.200
     0.875     4.764     0.200
     0.899     4.989     0.200
     0.933     4.810     0.200
     0.944     5.368     0.200
     0.951     5.343     0.200
     0.980     5.406     0.200
     1.047     5.508     0.200
     1.075     7.933     0.200
     1.075     8.012     0.200
     1.089     7.409     0.200
     1.111     5.699     0.200
     1.142     5.859     0.200
     1.181     8.152     0.200
     1.221     6.394     0.200
     1.216     8.137     0.200
     1.243     8.123     0.200
     1.288     6.595     0.200
     0.089     2.863     0.200
     0.165     2.731     0.200
     0.128     2.634     0.200
     0.228     2.505     0.200
     0.270     2.742     0.200
     0.368     3.792     0.200
     0.383     3.304     0.200
     0.492     3.478     0.200
     0.524     3.981     0.200
     0.550     3.848     0.200
     0.533     3.885     0.200
     0.558     4.349     0.200
     0.604     3.798     0.200
     0.653     3.905     0.200
     0.682     3.884     0.200
     0.717     4.433     0.200
     0.680     5.194     0.200
     0.713     4.407     0.200
     0.757     5.450     0.200
     0.843     4.904     0.200
     0.810     5.085     0.200
     0.865     5.065     0.200
     0.837     5.118     0.200
     0.868     5.041     0.200
     0.870     5.414     0.200
     0.872     4.973     0.200
     0.910     5.906     0.200
     0.916     5.167     0.200
     0.898     5.473     0.200
     0.946     5.607     0.200
     0.972     5.586     0.200
     0.966     5.661     0.200
     0.990     5.712     0.200
     1.012     5.907     0.200
     1.036     7.327     0.200
     1.015     6.926     0.200
     1.022     6.319     0.200
     1.051     6.370     0.200
     1.090     6.061     0.200
     1.090     7.166     0.200
     1.110     6.367     0.200
     1.104     7.491     0.200
     1.104     7.428     0.200
     1.104     7.600     0.200
     1.118     7.095     0.200
     1.127     7.316     0.200
     1.187     6.972     0.200
     1.236     6.871     0.200
     1.256     7.328     0.200
     1.244     7.104     0.200
     1.253     8.242     0.200
     1.718     9.946     0.200
     1.711     9.738     0.200
     1.743     9.925     0.200
     1.827    10.105     0.200
     1.926    10.072     0.200
     1.931    10.265     0.200
     2.334    12.842     0.200
     2.879    14.187     0.200
     3.337    17.436     0.200
     3.637    18.343     0.200
     0.089     2.180     0.200
     0.113     2.419     0.200
     0.126     2.326     0.200
     0.199     2.712     0.200
     0.183     2.666     0.200
     0.238     3.232     0.200
     0.253     2.597     0.200
     0.339     4.044     0.200
     0.358     3.768     0.200
     0.464     3.921     0.200
     0.491     3.819     0.200
     0.541     3.963     0.200
     0.532     4.361     0.200
     0.541     4.329     0.200
     0.534     4.141     0.200
     0.527     3.316     0.200
     0.581     4.086     0.200
     0.626     4.610     0.200
     0.632     4.354     0.200
     0.670     4.388     0.200
     0.685     4.698     0.200
     0.683     5.921     0.200
     0.676     4.409     0.200
     0.728     5.681     0.200
     0.723     4.799     0.200
     0.812     5.240     0.200
     0.844     5.328     0.200
     0.805     5.563     0.200
     0.860     5.321     0.200
     0.871     5.642     0.200
     0.881     5.590     0.200
     0.918     5.547     0.200
     0.917     5.320     0.200
     0.937     6.133     0.200
     0.927     5.893     0.200
     0.962     5.664     0.200
     0.966     5.824     0.200
     0.984     5.864     0.200
     0.988     6.357     0.200
     1.022     6.364     0.200
     1.062     6.903     0.200
     1.076     7.230     0.200
     1.077     7.164     0.200
     1.090     8.042     0.200
     1.093     6.359     0.200
     1.094     6.388     0.200
     1.102     7.336     0.200
     1.125     6.495     0.200
     1.194     7.156     0.200
     1.217     7.326     0.200
     1.183     7.378     0.200
     1.228     7.250     0.200
     1.205     6.993     0.200
     1.232     8.485     0.200
     1.257     7.819     0.200
     1.271     7.427     0.200
     1.321     9.207     0.200
     1.344     8.762     0.200
     1.356     8.189     0.200
     1.368     7.805     0.200
     1.382     8.247     0.200
     1.397     7.665     0.200
     1.422     8.335     0.200
     1.408     7.817     0.200
     1.437     9.373     0.200
     1.457     8.271     0.200
     1.540     8.655     0.200
     1.619     8.858     0.200
     1.735     9.271     0.200
     1.785     9.694     0.200
     1.954    10.867     0.200
     1.963    11.534     0.200
     2.109    12.176     0.200
     2.113    11.241     0.200
     2.274    11.613     0.200
     2.264    11.917     0.200
     2.412    12.225     0.200
     2.531    13.362     0.200
     0.087     1.793     0.200
     0.120     1.894     0.200
     0.117     1.881     0.200
     0.199     2.140     0.200
     0.184     2.357     0.200
     0.243     2.603     0.200
     0.237     2.201     0.200
     0.324     3.659     0.200
     0.352     3.359     0.200
     0.453     3.522     0.200
     0.494     3.364     0.200
     0.515     3.180     0.200
     0.548     3.640     0.200
     0.516     4.028     0.200
     0.547     3.804     0.200
     0.577     3.779     0.200
     0.613     4.096     0.200
     0.631     4.000     0.200
     0.675     3.915     0.200
     0.665     3.956     0.200
     0.667     5.543     0.200
     0.675     4.189     0.200
     0.736     4.284     0.200
     0.714     5.327     0.200
     0.794     5.731     0.200
     0.796     4.862     0.200
     0.816     4.983     0.200
     0.834     4.879     0.200
     0.868     4.839     0.200
     0.896     5.043     0.200
     0.855     5.250     0.200
     0.927     4.942     0.200
     0.943     5.309     0.200
     0.923     5.709     0.200
     0.973     5.438     0.200
     0.946     5.283     0.200
     0.972     6.264     0.200
     1.031     7.153     0.200
     1.066     6.986     0.200
     1.067     7.556     0.200
     1.066     7.384     0.200
     1.106     5.952     0.200
     1.080     7.720     0.200
     1.077     6.779     0.200
     1.085     6.895     0.200
     1.141     7.619     0.200
     1.127     6.394     0.200
     1.144     7.533     0.200
     1.199     6.965     0.200
     1.221     6.421     0.200
     1.177     7.126     0.200
     1.201     7.088     0.200
     1.235     8.056     0.200
     1.215     8.138     0.200
     1.286     7.878     0.200
     1.240     8.555     0.200
     1.306     8.862     0.200
     1.327     8.479     0.200
     1.369     8.249     0.200
     1.384     7.457     0.200
     1.397     7.454     0.200
     1.408     8.179     0.200
     1.422     9.160     0.200
     1.463     8.070     0.200
     1.446     8.389     0.200
     1.551     8.912     0.200
     1.557     9.724     0.200
     1.555     9.080     0.200
     1.553     9.359     0.200
     1.593     9.626     0.200
     1.557     9.160     0.200
     1.635     8.812     0.200
     1.641     8.362     0.200
     1.606     9.003     0.200
     1.667     9.653     0.200
     3.914    21.005     0.200
     0.090     2.004     0.200
     0.114     2.238     0.200
     0.120     2.201     0.200
     0.190     2.491     0.200
     0.194     2.586     0.200
     0.242     2.912     0.200
     0.245     2.484     0.200
     0.334     3.870     0.200
     0.357     3.595     0.200
     0.461     3.757     0.200
     0.494     3.657     0.200
     0.521     3.150     0.200
     0.525     4.274     0.200
     0.541     3.980     0.200
     0.539     3.733     0.200
     0.545     4.112     0.200
     0.581     3.996     0.200
     0.634     4.261     0.200
     0.674     4.238     0.200
     0.670     4.023     0.200
     0.682     4.482     0.200
     0.730     4.584     0.200
     0.723     5.430     0.200
     0.799     5.483     0.200
     0.805     5.127     0.200
     0.841     4.846     0.200
     0.865     5.206     0.200
     0.865     5.527     0.200
     0.889     5.396     0.200
     0.923     5.160     0.200
     0.934     5.701     0.200
     0.932     5.580     0.200
     0.956     5.550     0.200
     0.995     5.290     0.200
     1.132     6.241     0.200
     1.190     9.022     0.200
     1.187     6.442     0.200
     1.212     6.778     0.200
     1.233     7.843     0.200
     1.224     8.476     0.200
     1.278     7.009     0.200
     1.337     8.615     0.200
     1.376     7.500     0.200
     1.415     7.548     0.200
     1.462     6.989     0.200
     1.547     8.339     0.200
     1.632     8.852     0.200
     0.068     1.686     0.200
     0.142     1.544     0.200
     0.148     2.076     0.200
     0.187     2.369     0.200
     0.207     2.215     0.200
     0.207     2.121     0.200
     0.249     2.036     0.200
     0.331     2.940     0.200
     0.326     3.994     0.200
     0.337     2.339     0.200
     0.332     3.192     0.200
     0.333     3.254     0.200
     0.340     3.283     0.200
     0.371     3.388     0.200
     0.364     2.698     0.200
     0.379     3.210     0.200
     0.353     3.286     0.200
     0.375     2.873     0.200
     0.464     4.288     0.200
     0.432     2.897     0.200
     0.443     3.084     0.200
     0.478     4.117     0.200
     0.491     3.794     0.200
     0.470     3.620     0.200
     0.477     3.368     0.200
     0.480     4.529     0.200
     0.516     3.577     0.200
     0.510     4.490     0.200
     0.512     4.320     0.200
     0.530     4.275     0.200
     0.514     4.183     0.200
     0.515     4.358     0.200
     0.530     4.163     0.200
     0.544     3.901     0.200
     0.600     4.973     0.200
     0.593     4.428     0.200
     0.587     3.652     0.200
     0.602     5.388     0.200
     0.080     1.417     0.200
     0.135     1.766     0.200
     0.133     2.237     0.200
     0.188     2.268     0.200
     0.198     2.306     0.200
     0.200     2.128     0.200
     0.237     2.156     0.200
     0.346     2.664     0.200
     0.328     3.899     0.200
     0.325     3.128     0.200
     0.325     3.094     0.200
     0.332     3.306     0.200
     0.345     3.142     0.200
     0.368     3.281     0.200
     0.352     2.752     0.200
     0.373     3.135     0.200
     0.365     3.024     0.200
     0.445     4.135     0.200
     0.451     2.940     0.200
     0.419     2.958     0.200
     0.477     3.945     0.200
     0.462     4.147     0.200
     0.506     3.504     0.200
     0.477     4.011     0.200
     0.464     3.444     0.200
     0.529     3.412     0.200
     0.522     4.655     0.200
     0.614     5.243     0.200
     0.575     3.831     0.200
     0.661     5.316     0.200
     0.637     4.696     0.200
     0.695     4.350     0.200
     0.714     4.972     0.200
     0.708     5.491     0.200
     0.705     4.155     0.200
     0.772     4.884     0.200
     0.788     4.762     0.200
     0.755     5.820     0.200
     0.848     4.931     0.200
     0.946     7.180     0.200
     1.029     7.889     0.200
     1.097     7.868     0.200
     1.098     7.680     0.200
     1.086     8.100     0.200
     1.492     9.729     0.200
     2.159    12.382     0.200
     2.582    12.500     0.200
     0.081     1.613     0.200
     0.141     2.388     0.200
     0.146     1.441     0.200
     0.200     2.221     0.200
     0.213     2.199     0.200
     0.193     2.393     0.200
     0.251     2.149     0.200
     0.339     3.760     0.200
     0.341     2.810     0.200
     0.341     2.278     0.200
     0.382     3.386     0.200
     0.366     2.804     0.200
     0.388     2.914     0.200
     0.380     2.849     0.200
     0.318     3.243     0.200
     0.318     3.446     0.200
     0.325     3.533     0.200
     0.339     3.478     0.200
     0.452     4.230     0.200
     0.433     3.006     0.200
     0.477     4.132     0.200
     0.490     3.813     0.200
     0.436     3.270     0.200
     0.478     3.454     0.200
     0.499     3.665     0.200
     0.536     4.609     0.200
     0.516     3.683     0.200
     0.516     4.515     0.200
     0.589     3.949     0.200
     0.612     5.124     0.200
     0.682     5.273     0.200
     0.697     5.887     0.200
     0.647     5.514     0.200
     0.716     4.726     0.200
     0.684     4.295     0.200
     0.717     4.291     0.200
     0.697     5.706     0.200
     0.778     6.675     0.200
     0.776     5.192     0.200
     0.859     5.811     0.200
     1.036     7.659     0.200
     1.106     8.094     0.200
     1.112     8.042     0.200
     1.096     7.467     0.200
     1.114     6.873     0.200
     1.216     7.097     0.200
     1.378     9.878     0.200
     1.399     7.205     0.200
     1.480     8.482     0.200
     1.584     8.922     0.200
     1.652    10.010     0.200
     2.131    11.752     0.200
     2.149    13.276     0.200
     2.572    13.488     0.200
     0.081     2.027     0.200
     0.148     1.377     0.200
     0.197     2.264     0.200
     0.209     2.302     0.200
     0.248     2.260     0.200
     0.342     2.866     0.200
     0.344     2.348     0.200
     0.319     3.369     0.200
     0.320     3.484     0.200
     0.337     3.963     0.200
     0.327     3.523     0.200
     0.340     3.478     0.200
     0.363     3.145     0.200
     0.363     2.876     0.200
     0.378     3.479     0.200
     0.376     2.961     0.200
     0.384     3.225     0.200
     0.440     3.276     0.200
     0.430     3.065     0.200
     0.477     4.210     0.200
     0.469     4.691     0.200
     0.473     4.456     0.200
     0.501     3.654     0.200
     0.486     4.144     0.200
     0.474     3.574     0.200
     0.519     3.682     0.200
     0.533     4.515     0.200
     0.585     3.740     0.200
     0.615     5.217     0.200
     0.629     4.237     0.200
     0.693     5.809     0.200
     0.781     5.980     0.200
     0.793     5.784     0.200
     0.875     7.122     0.200
     0.042     1.520     0.200
     0.082     1.617     0.200
     0.089     1.576     0.200
     0.090     1.403     0.200
     0.113     1.373     0.200
     0.135     1.864     0.200
     0.164     1.646     0.200
     0.169     2.047     0.200
     0.210     2.244     0.200
     0.250     2.522     0.200
     0.260     1.883     0.200
     0.261     2.449     0.200
     0.314     2.200     0.200
     0.312     2.842     0.200
     0.312     3.591     0.200
     0.321     3.567     0.200
     0.341     2.352     0.200
     0.359     2.509     0.200
     0.359     2.197     0.200
     0.354     2.875     0.200
     0.387     2.984     0.200
     0.406     3.018     0.200
     0.437     3.103     0.200
     0.543     3.953     0.200
     0.580     4.585     0.200
     0.587     3.263     0.200
     0.597     3.613     0.200
     0.595     4.572     0.200
     0.635     4.569     0.200
     0.643     5.198     0.200
     0.648     4.277     0.200
     0.111     3.327     0.200
     0.186     3.084     0.200
     0.203     3.246     0.200
     0.209     2.933     0.200
     0.242     2.882     0.200
     0.253     3.489     0.200
     0.306     3.153     0.200
     0.371     3.480     0.200
     0.384     3.694     0.200
     0.415     3.677     0.200
     0.384     4.001     0.200
     0.441     3.724     0.200
     0.473     3.861     0.200
     0.484     4.465     0.200
     0.554     4.506     0.200
     0.574     5.054     0.200
     0.649     4.811     0.200
     0.650     5.705     0.200
     0.672     4.806     0.200
     0.677     4.621     0.200
     0.681     4.994     0.200
     0.722     4.998     0.200
     0.746     4.885     0.200
     0.764     5.425     0.200
     0.803     4.800     0.200
     0.798     5.695     0.200
     0.839     5.720     0.200
     0.864     5.122     0.200
     0.887     5.208     0.200
     0.869     5.455     0.200
     0.888     5.297     0.200
     0.873     6.083     0.200
     0.888     5.669     0.200
     0.887     6.238     0.200
     0.902     5.565     0.200
     0.911     6.471     0.200
     0.948     5.949     0.200
     0.952     5.738     0.200
     0.948     5.649     0.200
     0.943     6.799     0.200
     0.972     5.655     0.200
     0.955     6.032     0.200
     0.962     6.201     0.200
     0.992     5.825     0.200
     1.010     5.868     0.200
     1.145     6.536     0.200
     1.593     8.608     0.200
     4.400    23.177     0.200
     0.030     1.701     0.200
     0.115     0.889     0.200
     0.183     2.375     0.200
     0.180     2.127     0.200
     0.195     1.364     0.200
     0.228     1.672     0.200
     0.221     3.184     0.200
     0.254     2.694     0.200
     0.338     2.577     0.200
     0.332     3.097     0.200
     0.353     2.322     0.200
     0.415     2.929     0.200
     0.383     4.451     0.200
     0.417     2.647     0.200
     0.458     3.688     0.200
     0.453     3.553     0.200
     0.450     4.173     0.200
     0.468     3.799     0.200
     0.471     3.849     0.200
     0.514     3.553     0.200
     0.518     3.992     0.200
     0.509     4.352     0.200
     0.545     3.742     0.200
     0.512     3.975     0.200
     0.544     4.030     0.200
     0.555     3.603     0.200
     0.566     4.254     0.200
     0.586     4.347     0.200
     0.569     4.490     0.200
     0.591     3.942     0.200
     0.587     4.003     0.200
     0.600     4.179     0.200
     0.605     4.031     0.200
     0.608     4.037     0.200
     0.659     4.689     0.200
     0.722     5.297     0.200
     0.746     5.255     0.200
     0.768     4.842     0.200
     0.748     3.552     0.200
     0.752     4.904     0.200
     0.804     4.756     0.200
     0.783     5.193     0.200
     0.816     6.072     0.200
     0.866     5.594     0.200
     0.861     6.454     0.200
     0.862     4.937     0.200
     0.845     5.491     0.200
     0.893     6.869     0.200
     0.869     6.338     0.200
     0.883     6.096     0.200
     0.936     5.153     0.200
     0.925     6.472     0.200
     0.942     6.938     0.200
     0.957     6.360     0.200
     0.982     6.814     0.200
     1.002     6.138     0.200
     1.087     7.246     0.200
     1.057     7.612     0.200
     1.057     6.686     0.200
     1.114     6.655     0.200
     1.120     7.183     0.200
     1.157     6.500     0.200
     1.156     7.435     0.200
     1.197     7.389     0.200
     1.211     8.579     0.200
     1.185     7.656     0.200
     1.298     7.325     0.200
     1.358     8.212     0.200
     1.349     9.935     0.200
     1.384     8.460     0.200
     1.399     8.731     0.200
     1.402     8.512     0.200
     1.961    11.703     0.200
     2.036    12.564     0.200
     2.152    12.986     0.200
     2.244    12.521     0.200
     2.359    14.072     0.200
     2.674    14.109     0.200
     0.070     2.955     0.200
     0.213     2.597     0.200
     0.225     2.621     0.200
     0.230     2.664     0.200
     0.234     2.522     0.200
     0.290     3.339     0.200
     0.314     2.883     0.200
     0.322     2.838     0.200
     0.324     2.009     0.200
     0.330     3.059     0.200
     0.337     2.969     0.200
     0.352     2.576     0.200
     0.370     2.810     0.200
     0.364     3.068     0.200
     0.416     3.302     0.200
     0.411     3.744     0.200
     0.435     2.962     0.200
     0.446     3.051     0.200
     0.462     3.547     0.200
     0.459     3.788     0.200
     0.485     3.262     0.200
     0.481     3.930     0.200
     0.515     3.213     0.200
     0.531     3.161     0.200
     0.524     3.420     0.200
     0.534     3.202     0.200
     0.535     2.651     0.200
     0.536     4.712     0.200
     0.570     3.802     0.200
     0.563     4.481     0.200
     0.580     3.408     0.200
     0.570     4.125     0.200
     0.600     3.907     0.200
     0.604     3.633     0.200
     0.619     3.489     0.200
     0.611     4.367     0.200
     0.658     4.102     0.200
     0.650     4.127     0.200
     0.659     3.948     0.200
     0.653     4.023     0.200
     0.654     4.295     0.200
     0.660     4.140     0.200
     0.664     4.780     0.200
     0.679     5.109     0.200
     0.710     4.444     0.200
     0.706     4.248     0.200
     0.698     4.327     0.200
     0.749     4.160     0.200
     0.755     4.413     0.200
     0.771     5.155     0.200
     0.780     5.331     0.200
     0.819     5.409     0.200
     0.821     4.655     0.200
     0.825     4.878     0.200
     0.829     5.164     0.200
     0.827     5.444     0.200
     0.830     5.720     0.200
     0.838     5.584     0.200
     0.856     4.687     0.200
     0.856     5.726     0.200
     1.355     7.346     0.200
     1.355     7.237     0.200
     2.664    14.266     0.200
     2.791    15.587     0.200
     4.116    20.108     0.200
     0.109     1.669     0.200
     0.135     1.477     0.200
     0.170     2.146     0.200
     0.170     1.840     0.200
     0.209     2.070     0.200
     0.241     2.323     0.200
     0.310     3.871     0.200
     0.344     2.292     0.200
     0.383     2.543     0.200
     0.406     2.251     0.200
     0.442     4.275     0.200
     0.448     2.354     0.200
     0.474     3.094     0.200
     0.475     2.553     0.200
     0.495     3.353     0.200
     0.497     2.595     0.200
     0.527     4.142     0.200
     0.538     4.129     0.200
     0.576     4.288     0.200
     0.588     3.517     0.200
     0.634     5.052     0.200
     0.676     4.600     0.200
     0.662     4.054     0.200
     0.673     4.230     0.200
     0.706     4.839     0.200
     0.741     4.747     0.200
     0.817     5.340     0.200
     0.827     5.544     0.200
     0.838     5.089     0.200
     0.838     7.116     0.200
     0.859     6.211     0.200
     0.856     6.679     0.200
     0.862     6.318     0.200
     0.864     4.607     0.200
     0.922     5.618     0.200
     0.933     5.660     0.200
     0.995     5.690     0.200
     1.021     5.658     0.200
     1.013     6.586     0.200
     1.032     5.728     0.200
     1.075     5.359     0.200
     1.205     8.313     0.200
     1.226     7.756     0.200
     1.213     8.474     0.200
     1.218     7.976     0.200
     1.332     8.647     0.200
     1.404     8.885     0.200
     0.102     1.970     0.200
     0.234     1.937     0.200
     0.296     2.617     0.200
     0.331     2.876     0.200
     0.340     2.311     0.200
     0.364     2.948     0.200
     0.404     3.127     0.200
     0.404     3.166     0.200
     0.409     3.193     0.200
     0.405     2.846     0.200
     0.424     2.994     0.200
     0.424     3.001     0.200
     0.462     3.127     0.200
     0.484     3.095     0.200
     0.500     3.505     0.200
     0.503     3.437     0.200
     0.509     3.345     0.200
     0.523     3.443     0.200
     0.550     3.991     0.200
     0.576     3.799     0.200
     0.588     3.938     0.200
     0.658     3.713     0.200
     0.691     3.642     0.200
     0.688     4.240     0.200
     0.708     5.031     0.200
     0.703     4.219     0.200
     0.712     4.280     0.200
     0.761     4.559     0.200
     0.772     4.595     0.200
     0.782     5.404     0.200
     0.841     4.104     0.200
     0.848     5.089     0.200
     0.860     5.378     0.200
     0.870     5.116     0.200
     0.907     7.284     0.200
     0.929     7.428     0.200
     0.931     7.527     0.200
     0.934     7.646     0.200
     0.942     7.524     0.200
     0.945     6.315     0.200
     0.946     7.253     0.200
     0.952     6.985     0.200
     0.967     5.027     0.200
     0.957     7.204     0.200
     0.967     5.118     0.200
     0.980     5.537     0.200
     0.991     5.976     0.200
     0.996     4.929     0.200
     1.000     7.218     0.200
     1.010     7.050     0.200
     1.008     5.075     0.200
     1.000     5.264     0.200
     1.017     4.679     0.200
     1.042     7.012     0.200
     1.048     6.151     0.200
     1.041     6.843     0.200
     1.045     6.792     0.200
     1.117     7.618     0.200
     0.169     2.854     0.200
     0.233     2.802     0.200
     0.226     2.987     0.200
     0.237     2.541     0.200
     0.242     2.807     0.200
     0.270     2.824     0.200
     0.262     2.579     0.200
     0.310     3.195     0.200
     0.339     3.094     0.200
     0.353     2.645     0.200
     0.397     3.101     0.200
     0.406     3.181     0.200
     0.413     2.991     0.200
     0.461     4.130     0.200
     0.499     3.260     0.200
     0.513     3.751     0.200
     0.518     3.477     0.200
     0.537     3.605     0.200
     0.533     3.837     0.200
     0.576     4.243     0.200
     0.581     4.464     0.200
     0.592     3.849     0.200
     0.607     5.576     0.200
     0.609     4.372     0.200
     0.632     3.753     0.200
     0.646     3.721     0.200
     0.654     3.858     0.200
     0.671     4.339     0.200
     0.678     4.010     0.200
     0.678     3.847     0.200
     0.679     5.170     0.200
     0.686     4.056     0.200
     0.692     3.871     0.200
     0.705     4.114     0.200
     0.705     4.109     0.200
     0.706     4.104     0.200
     0.711     4.302     0.200
     0.712     5.041     0.200
     0.727     4.212     0.200
     0.729     4.112     0.200
     0.735     4.911     0.200
     0.757     4.932     0.200
     0.776     4.502     0.200
     0.770     4.740     0.200
     0.780     4.235     0.200
     0.788     4.584     0.200
     0.803     4.710     0.200
     0.803     5.577     0.200
     0.803     4.515     0.200
     0.800     4.877     0.200
     0.819     4.396     0.200
     0.819     4.904     0.200
     0.834     4.562     0.200
     0.855     5.145     0.200
     0.849     5.438     0.200
     0.850     4.954     0.200
     0.857     4.654     0.200
     0.858     5.818     0.200
     0.859     5.768     0.200
     0.879     5.068     0.200
     0.873     5.793     0.200
     0.879     5.452     0.200
     0.921     5.829     0.200
     0.932     5.969     0.200
     0.937     6.903     0.200
     0.949     5.938     0.200
     0.950     5.261     0.200
     0.965     5.518     0.200
     0.996     5.890     0.200
     1.000     5.993     0.200
     1.018     5.389     0.200
     1.022     5.462     0.200
     1.014     6.513     0.200
     1.032     5.438     0.200
     1.027     6.922     0.200
     1.050     7.290     0.200
     1.073     6.282     0.200
     1.077     6.679     0.200
     1.084     7.010     0.200
     1.088     6.515     0.200
     1.089     6.247     0.200
     1.116     7.118     0.200
     1.144     5.928     0.200
     1.144     7.541     0.200
     1.149     6.970     0.200
     1.179     6.238     0.200
     1.179     6.097     0.200
     1.188     7.258     0.200
     1.195     6.832     0.200
     1.200     7.015     0.200
     1.252     6.870     0.200
     1.268     7.227     0.200
     1.260     7.774     0.200
     1.282     8.307     0.200
     1.289     6.626     0.200
     1.282     7.042     0.200
     1.288     8.122     0.200
     1.288     7.872     0.200
     1.291     7.355     0.200
     1.302     7.621     0.200
     1.311     6.942     0.200
     1.311     8.295     0.200
     1.322     8.630     0.200
     1.346     8.108     0.200
     1.382     7.078     0.200
     1.375     8.829     0.200
     1.394     7.126     0.200
     1.440     7.651     0.200
     1.453     7.983     0.200
     1.492     7.528     0.200
     1.542     8.094     0.200
     1.652     8.276     0.200
     1.652     8.503     0.200
     0.076     1.905     0.200
     0.076     2.035     0.200
     0.049     2.217     0.200
     0.094     2.248     0.200
     0.177     2.760     0.200
     0.231     2.570     0.200
     0.233     2.626     0.200
     0.240     2.868     0.200
     0.240     3.158     0.200
     0.317     3.046     0.200
     0.317     3.946     0.200
     0.345     3.662     0.200
     0.363     3.345     0.200
     0.412     3.625     0.200
     0.445     3.882     0.200
     0.474     3.674     0.200
     0.491     3.655     0.200
     0.515     3.411     0.200
     0.509     4.493     0.200
     0.551     3.751     0.200
     0.544     4.037     0.200
     0.568     3.893     0.200
     0.568     4.413     0.200
     0.567     3.594     0.200
     0.580     3.620     0.200
     0.570     4.039     0.200
     0.601     3.742     0.200
     0.605     4.581     0.200
     0.605     4.721     0.200
     0.625     4.268     0.200
     0.626     4.890     0.200
     0.664     4.108     0.200
     0.664     3.888     0.200
     0.664     4.458     0.200
     0.671     4.196     0.200
     0.675     4.003     0.200
     0.660     5.922     0.200
     0.667     4.579     0.200
     0.737     4.581     0.200
     0.737     4.431     0.200
     0.742     4.459     0.200
     0.706     5.324     0.200
     0.746     4.556     0.200
     0.750     4.624     0.200
     0.772     4.538     0.200
     0.784     5.116     0.200
     0.784     5.386     0.200
     0.793     4.946     0.200
     0.793     5.606     0.200
     0.789     5.332     0.200
     0.809     5.211     0.200
     0.826     5.203     0.200
     0.855     5.305     0.200
     0.866     5.020     0.200
     0.848     5.710     0.200
     0.899     5.249     0.200
     0.895     5.509     0.200
     0.927     5.088     0.200
     0.947     5.577     0.200
     0.905     6.444     0.200
     0.906     7.289     0.200
     0.915     5.775     0.200
     0.939     5.744     0.200
     0.971     5.554     0.200
     0.965     6.619     0.200
     0.981     5.347     0.200
     0.981     5.547     0.200
     0.996     5.728     0.200
     1.005     6.676     0.200
     1.000     6.385     0.200
     1.010     6.809     0.200
     1.010     7.159     0.200
     1.028     6.633     0.200
     1.041     6.422     0.200
     1.048     7.606     0.200
     1.058     8.269     0.200
     1.058     8.479     0.200
     1.058     7.678     0.200
     1.070     6.028     0.200
     1.070     6.258     0.200
     1.107     6.103     0.200
     1.107     6.234     0.200
     1.081     8.116     0.200
     1.144     6.245     0.200
     1.106     7.702     0.200
     1.119     6.717     0.200
     1.158     6.066     0.200
     1.158     6.436     0.200
     1.205     8.253     0.200
     1.206     7.011     0.200
     1.170     6.692     0.200
     1.170     6.872     0.200
     1.226     6.564     0.200
     1.226     6.695     0.200
     1.186     7.486     0.200
     1.193     7.274     0.200
     1.210     7.161     0.200
     1.233     6.825     0.200
     1.233     6.935     0.200
     1.233     7.897     0.200
     1.233     9.067     0.200
     1.248     8.614     0.200
     1.290     7.022     0.200
     1.263     8.784     0.200
     1.306     7.975     0.200
     1.306     8.405     0.200
     1.310     8.040     0.200
     1.310     9.540     0.200
     1.321     8.859     0.200
     1.321     9.020     0.200
     1.350     9.676     0.200
     1.371     7.139     0.200
     1.371     8.079     0.200
     1.348     8.614     0.200
     1.388     7.310     0.200
     1.408     9.189     0.200
     1.400     8.297     0.200
     1.380     8.940     0.200
     1.378     7.716     0.200
     1.378     8.246     0.200
     1.408     7.388     0.200
     1.427     9.004     0.200
     1.427     9.504     0.200
     1.461     7.740     0.200
     1.461     8.730     0.200
     1.497     8.572     0.200
     1.549    10.138     0.200
     1.556     9.139     0.200
     1.562     8.214     0.200
     1.558     8.243     0.200
     1.558    10.083     0.200
     1.577     8.060     0.200
     1.534     9.949     0.200
     1.535     9.523     0.200
     1.590     8.459     0.200
     1.545     9.782     0.200
     1.639     8.749     0.200
     1.760     9.492     0.200
     1.784     9.450     0.200
     1.812     9.315     0.200
     1.899    10.005     0.200
     1.899    10.685     0.200
     1.956    10.870     0.200
     1.959    12.120     0.200
     1.959    12.168     0.200
     1.976    11.060     0.200
     1.976    11.210     0.200
     1.985    11.317     0.200
     1.958    10.353     0.200
     1.958    10.480     0.200
     2.012    11.360     0.200
     1.970    11.315     0.200
     1.970    10.655     0.200
     1.970    10.985     0.200
     2.033    12.561     0.200
     2.059    11.666     0.200
     2.071    10.820     0.200
     2.130    12.644     0.200
     2.134    11.422     0.200
     2.134    11.932     0.200
     2.130    11.506     0.200
     2.130    12.346     0.200
     2.134    11.268     0.200
     2.189    11.488     0.200
     2.189    11.658     0.200
     2.143    11.462     0.200
     2.134    11.747     0.200
     2.134    12.247     0.200
     2.222    11.880     0.200
     2.263    12.104     0.200
     2.217    11.257     0.200
     2.217    11.437     0.200
     2.235    11.963     0.200
     2.235    12.213     0.200
     2.285    12.592     0.200
     2.242    12.300     0.200
     2.242    13.080     0.200
     2.251    11.955     0.200
     2.256    11.717     0.200
     2.309    11.913     0.200
     2.309    12.054     0.200
     2.307    12.224     0.200
     2.344    12.617     0.200
     2.300    11.505     0.200
     2.303    12.877     0.200
     2.294    11.638     0.200
     2.294    11.948     0.200
     2.371    12.729     0.200
     2.374    12.020     0.200
     2.374    12.210     0.200
     2.387    12.930     0.200
     2.387    13.500     0.200
     2.392    12.552     0.200
     2.420    12.352     0.200
     2.420    12.552     0.200
     2.425    12.120     0.200
     2.414    13.057     0.200
     2.414    13.246     0.200
     2.423    13.219     0.200
     2.433    13.143     0.200
     2.433    13.583     0.200
     2.436    13.685     0.200
     2.436    14.265     0.200
     2.449    12.628     0.200
     2.440    13.127     0.200
     2.496    13.153     0.200
     2.548    13.233     0.200
     2.553    13.287     0.200
     2.559    14.066     0.200
     2.559    14.556     0.200
     2.582    13.010     0.200
     2.612    12.722     0.200
     2.612    13.631     0.200
     2.601    13.927     0.200
     2.654    13.721     0.200
     2.654    13.981     0.200
     2.717    14.092     0.200
     2.728    14.366     0.200
     2.794    13.489     0.200
     2.773    14.043     0.200
     3.036    14.890     0.200
     3.118    15.052     0.200
     3.227    15.131     0.200
     3.316    15.907     0.200
     3.376    16.826     0.200
     3.376    15.887     0.200
     3.376    16.272     0.200
     3.402    16.972     0.200
     3.447    15.919     0.200
     3.426    15.409     0.200
     3.510    16.011     0.200
     3.494    15.720     0.200
     3.559    16.058     0.200
     3.604    16.146     0.200
     3.629    16.303     0.200
     3.711    16.684     0.200
     4.030    18.275     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     3.905    62.166     0.200
     4.020    60.531     0.200
     4.678    69.348     0.200
     4.749    71.915     0.200
     4.865    72.268     0.200
     4.933    73.481     0.200
     5.565    78.997     0.200
     6.748    97.195     0.200
     7.196    97.962     0.200
     8.074   107.717     0.200
     8.839   119.986     0.200
     8.872   122.404     0.200
     8.981   117.338     0.200
     9.113   123.598     0.200
     9.818   129.369     0.200
    10.284   138.926     0.200
     4.680    69.550     0.200
     4.797    71.189     0.200
     4.941    72.009     0.200
     5.111    72.219     0.200
     5.546    79.645     0.200
     8.080   112.576     0.200
     8.882   120.213     0.200
     8.910   120.387     0.200
     9.126   124.770     0.200
     9.244   123.796     0.200
     3.177    50.200     0.200
     4.002    58.565     0.200
     4.213    60.310     0.200
     4.952    67.184     0.200
     6.432    89.413     0.200
     7.099    94.623     0.200
     8.504   109.434     0.200
     8.843   112.874     0.200
     9.598   124.666     0.200
     9.805   124.949     0.200
     4.965    71.572     0.200
     5.085    74.459     0.200
     6.878    95.741     0.200
     7.020    99.090     0.200
     6.969    95.282     0.200
     7.109    98.439     0.200
     8.351   113.548     0.200
     8.449   113.803     0.200
     9.138   122.373     0.200
     9.275   122.170     0.200
     9.451   126.715     0.200
     9.571   127.022     0.200
    10.505   138.916     0.200
    11.877   156.300     0.200
     3.041    48.273     0.200
     3.300    54.543     0.200
     4.087    64.665     0.200
     4.670    69.760     0.200
     5.017    72.418     0.200
     5.197    74.614     0.200
     5.438    78.899     0.200
     5.885    80.075     0.200
     5.957    84.243     0.200
     7.059    97.877     0.200
     7.132   103.025     0.200
     8.395   115.292     0.200
     9.536   125.270     0.200
     9.661   126.811     0.200
    10.605   143.495     0.200
     8.184   105.530     0.200
     3.033    47.226     0.200
     3.597    57.641     0.200
     3.975    64.124     0.200
     4.241    61.129     0.200
     4.693    70.347     0.200
     5.010    73.546     0.200
     5.174    74.339     0.200
     5.241    73.452     0.200
     5.874    82.066     0.200
     7.057    98.860     0.200
     7.056    98.273     0.200
     7.273    99.742     0.200
     7.283   102.626     0.200
     7.456   106.604     0.200
     7.676   104.035     0.200
     8.391   114.697     0.200
     8.391   114.197     0.200
     9.170   122.600     0.200
     9.170   122.100     0.200
     9.326   124.884     0.200
     9.645   129.057     0.200
    10.027   138.104     0.200
    10.087   140.900     0.200
    10.566   140.515     0.200
    10.601   143.901     0.200
    20.013   267.070     0.200
    21.117   279.184     0.200
    22.087   287.857     0.200
     3.034    49.714     0.200
     4.921    74.395     0.200
     4.979    72.622     0.200
     5.833    81.554     0.200
     7.030   100.584     0.200
     8.363   115.029     0.200
     9.147   122.884     0.200
     9.597   128.827     0.200
     1.998    33.920     0.200
     3.821    59.448     0.200
     4.193    63.306     0.200
     4.880    71.791     0.200
     4.919    69.835     0.200
     4.923    74.283     0.200
     4.927    75.242     0.200
     5.178    73.215     0.200
     5.729    79.882     0.200
     5.766    83.447     0.200
     6.993    97.634     0.200
     8.318   114.169     0.200
     9.455   126.393     0.200
    10.057   133.878     0.200
     1.945    34.053     0.200
     3.056    49.086     0.200
     4.663    68.826     0.200
     4.806    70.165     0.200
     4.843    69.621     0.200
     4.876    74.846     0.200
     4.930    75.209     0.200
     5.104    73.085     0.200
     5.693    83.804     0.200
     6.919    99.005     0.200
     8.243   115.548     0.200
     8.243   115.247     0.200
     9.385   127.028     0.200
     9.981   131.269     0.200
    10.453   141.761     0.200
     0.930    22.398     0.200
     2.410    40.629     0.200
     3.127    48.754     0.200
     3.761    59.356     0.200
     3.950    59.148     0.200
     4.007    61.783     0.200
     4.811    73.601     0.200
     5.105    74.670     0.200
     5.725    80.939     0.200
     5.793    85.144     0.200
     6.921    98.986     0.200
     9.038   124.276     0.200
     9.070   125.408     0.200
     3.037    49.307     0.200
     4.945    71.438     0.200
     4.784    70.415     0.200
     5.187    74.213     0.200
     5.789    80.694     0.200
     6.866    94.119     0.200
     7.003    96.528     0.200
     8.334   112.996     0.200
     9.122   121.800     0.200
     9.254   122.853     0.200
    10.544   182.200     0.200
     0.981    23.281     0.200
     1.215    27.049     0.200
     2.844    46.836     0.200
     3.904    62.662     0.200
     3.965    60.761     0.200
     4.140    67.212     0.200
     4.689    70.701     0.200
     4.901    70.834     0.200
     5.132    75.831     0.200
     5.767    80.421     0.200
     6.793    95.953     0.200
     6.947    99.151     0.200
     7.613   112.382     0.200
     8.282   112.580     0.200
    10.044   133.011     0.200
     1.464    28.053     0.200
     1.780    34.359     0.200
     3.449    54.878     0.200
     3.732    59.578     0.200
     4.116    62.596     0.200
     4.352    68.342     0.200
     4.713    70.832     0.200
     4.852    70.506     0.200
     4.852    76.006     0.200
     4.965    72.185     0.200
     5.425    77.321     0.200
     5.545    78.226     0.200
     5.602    80.754     0.200
     6.674    92.253     0.200
     6.674    95.253     0.200
     8.108   111.514     0.200
     8.904   122.218     0.200
     1.112    24.281     0.200
     2.402    35.630     0.200
     2.695    42.716     0.200
     2.996    48.795     0.200
     5.052    71.812     0.200
     5.282    74.618     0.200
     8.432   115.363     0.200
     9.211   122.267     0.200
     9.211   121.767     0.200
     1.501    31.854     0.200
     4.711    72.800     0.200
     4.913    74.734     0.200
     5.576    83.803     0.200
     6.785    98.187     0.200
     8.110   113.730     0.200
     3.071    49.909     0.200
     3.523    53.124     0.200
     3.982    64.568     0.200
     4.088    63.539     0.200
     4.188    60.367     0.200
     4.703    70.353     0.200
     4.703    74.353     0.200
     4.957    70.501     0.200
     5.133    74.546     0.200
     5.189    75.084     0.200
     5.890    90.510     0.200
     7.004    99.504     0.200
     7.221   101.976     0.200
     7.242   101.730     0.200
     7.395   105.941     0.200
     7.409   102.782     0.200
     8.338   113.937     0.200
     9.119   122.820     0.200
     9.119   122.320     0.200
     9.591   127.610     0.200
    10.100   134.379     0.200
     2.723    44.412     0.200
     3.560    55.242     0.200
     3.723    59.542     0.200
     3.982    63.716     0.200
     4.185    67.140     0.200
     4.203    60.538     0.200
     4.360    66.201     0.200
     4.959    71.114     0.200
     5.014    71.074     0.200
     5.253    72.779     0.200
     5.916    84.540     0.200
     7.068    99.095     0.200
     7.323   103.127     0.200
     7.483   101.260     0.200
     8.400   113.552     0.200
     8.400   113.952     0.200
     9.798   134.440     0.200
    10.611   144.756     0.200
     1.070    23.465     0.200
     3.423    52.408     0.200
     4.208    61.848     0.200
     4.196    64.989     0.200
     5.047    70.255     0.200
     5.289    73.239     0.200
     7.104    98.554     0.200
     8.435   112.018     0.200
     3.770    58.627     0.200
     3.825    62.283     0.200
     3.983    64.532     0.200
     4.107    64.087     0.200
     4.414    70.814     0.200
     4.491    70.108     0.200
     4.700    71.368     0.200
     5.071    75.344     0.200
     5.512    80.389     0.200
     6.065    89.143     0.200
     6.348    90.539     0.200
     6.736    96.105     0.200
     6.854    97.735     0.200
     6.881    97.414     0.200
     7.652   104.813     0.200
     7.892   110.625     0.200
     8.192   114.119     0.200
     8.192   114.517     0.200
     8.252   114.414     0.200
     9.018   124.482     0.200
     9.018   123.982     0.200
     9.040   120.918     0.200
    11.867   165.228     0.200
     2.283    39.900     0.200
     2.659    44.516     0.200
     3.362    54.808     0.200
     3.679    55.115     0.200
     3.745    56.547     0.200
     3.745    59.346     0.200
     3.874    59.634     0.200
     4.157    64.240     0.200
     4.286    65.524     0.200
     4.302    66.050     0.200
     4.414    67.139     0.200
     4.638    69.623     0.200
     4.842    77.038     0.200
     5.315    79.821     0.200
     5.494    82.037     0.200
     5.489    80.386     0.200
     6.038    85.881     0.200
     6.427    94.040     0.200
     6.470    93.142     0.200
     6.646    94.593     0.200
     6.646    95.093     0.200
     6.780    96.924     0.200
     6.780    97.127     0.200
     7.060   101.662     0.200
     8.203   110.418     0.200
     8.360   115.483     0.200
     8.425   114.327     0.200
     8.536   113.432     0.200
     1.038    22.921     0.200
     1.170    24.883     0.200
     2.823    44.588     0.200
     3.006    47.551     0.200
     3.036    46.099     0.200
     3.240    52.121     0.200
     3.476    56.465     0.200
     3.623    53.861     0.200
     4.168    63.293     0.200
     4.206    62.654     0.200
     4.320    63.222     0.200
     4.485    66.389     0.200
     4.593    66.134     0.200
     4.989    70.415     0.200
     5.333    73.302     0.200
     5.273    73.895     0.200
     5.519    80.629     0.200
     5.556    76.699     0.200
     5.706    81.943     0.200
     5.706    84.243     0.200
     5.724    80.842     0.200
     5.910    80.570     0.200
     6.291    89.121     0.200
     6.627    90.199     0.200
     6.716    87.460     0.200
     7.640   102.376     0.200
     7.634   100.444     0.200
     8.380   112.741     0.200
     9.257   119.510     0.200
     9.959   130.113     0.200
    10.028   129.705     0.200
    10.234   132.103     0.200
    11.506   152.958     0.200
     3.213    54.060     0.200
     3.381    54.104     0.200
     3.422    53.620     0.200
     3.667    59.765     0.200
     3.760    59.675     0.200
     3.888    61.688     0.200
     4.118    60.594     0.200
     4.128    64.278     0.200
     4.302    69.349     0.200
     4.319    69.659     0.200
     5.328    79.383     0.200
     5.513    80.817     0.200
     5.979    78.778     0.200
     6.316    89.854     0.200
     6.633    94.147     0.200
     7.540   103.561     0.200
     8.381   112.745     0.200
     2.624    41.463     0.200
     2.957    43.572     0.200
     3.867    54.961     0.200
     4.156    57.479     0.200
     4.233    60.485     0.200
     4.841    69.585     0.200
     5.343    74.829     0.200
     5.970    82.509     0.200
     5.943    85.729     0.200
     6.214    85.164     0.200
     6.256    80.776     0.200
     6.305    90.509     0.200
     7.309    97.789     0.200
     7.553   101.041     0.200
     8.082   106.772     0.200
     8.278   109.476     0.200
     8.625   111.935     0.200
     8.800   113.784     0.200
     9.494   122.293     0.200
     9.563   124.487     0.200
     9.769   125.882     0.200
     9.884   126.931     0.200
    10.083   130.413     0.200
     3.631    55.593     0.200
     3.664    55.709     0.200
     4.049    61.119     0.200
     4.131    63.263     0.200
     4.557    67.292     0.200
     4.596    68.132     0.200
     4.610    63.776     0.200
     4.899    69.505     0.200
     4.918    70.182     0.200
     8.023   109.836     0.200
     8.845   118.244     0.200
     1.616    31.192     0.200
     3.457    54.706     0.200
     3.481    52.420     0.200
     4.053    60.752     0.200
     4.341    63.288     0.200
     4.480    66.261     0.200
     5.095    72.086     0.200
     5.533    81.271     0.200
     5.909    80.093     0.200
     6.154    85.631     0.200
     6.438    86.115     0.200
     7.494   101.486     0.200
     8.261    64.641     0.200
     8.261   109.641     0.200
     8.471   110.196     0.200
     8.814   113.191     0.200
     8.985   115.890     0.200
     9.280   121.744     0.200
     9.734   126.954     0.200
     9.942   128.527     0.200
    10.233   136.031     0.200
    11.247   149.890     0.200
     2.384    38.753     0.200
     3.283    51.255     0.200
     3.732    59.521     0.200
     3.833    58.441     0.200
     3.920    60.319     0.200
     4.084    63.911     0.200
     4.176    66.341     0.200
     4.380    64.853     0.200
     4.392    65.318     0.200
     4.374    68.527     0.200
     4.386    68.389     0.200
     4.766    67.158     0.200
     5.046    70.189     0.200
     7.488   103.682     0.200
     0.922    19.092     0.200
     3.061    48.431     0.200
     3.231    50.543     0.200
     3.299    51.150     0.200
     3.444    53.462     0.200
     3.550    54.222     0.200
     3.579    55.386     0.200
     4.053    60.351     0.200
     4.180    60.275     0.200
     4.124    62.223     0.200
     4.177    62.209     0.200
     4.367    60.891     0.200
     4.923    68.999     0.200
     6.017    84.531     0.200
     6.518    91.893     0.200
     6.591    92.040     0.200
     8.027   106.479     0.200
     8.027   109.479     0.200
     8.841   118.172     0.200
     1.077    26.710     0.200
     1.494    31.840     0.200
     1.539    31.217     0.200
     1.722    35.183     0.200
     3.005    49.115     0.200
     3.195    51.995     0.200
     3.203    51.100     0.200
     3.459    53.708     0.200
     3.471    55.280     0.200
     3.545    55.615     0.200
     3.940    61.096     0.200
     4.006    62.828     0.200
     4.089    62.462     0.200
     4.116    62.748     0.200
     4.339    67.646     0.200
     4.523    69.001     0.200
     4.544    67.156     0.200
     4.757    73.443     0.200
     5.092    76.353     0.200
     5.124    75.008     0.200
     5.373    81.584     0.200
     5.636    85.211     0.200
     5.864    84.647     0.200
     6.108    88.756     0.200
     6.136    90.967     0.200
     6.136    94.271     0.200
     6.211    92.591     0.200
     7.649   108.522     0.200
     8.649   117.342     0.200
     8.771   119.722     0.200
     1.062    22.737     0.200
     1.292    24.552     0.200
     2.350    38.001     0.200
     2.907    45.005     0.200
     3.058    48.949     0.200
     3.416    54.272     0.200
     3.598    56.937     0.200
     3.611    56.886     0.200
     3.927    56.096     0.200
     3.997    56.290     0.200
     4.013    60.104     0.200
     4.047    58.096     0.200
     4.220    61.182     0.200
     4.286    62.111     0.200
     4.375    65.870     0.200
     4.645    66.227     0.200
     4.922    67.990     0.200
     5.985    86.590     0.200
     6.067    85.728     0.200
     6.062    83.478     0.200
     6.227    87.365     0.200
     7.074    95.076     0.200
     7.158    95.103     0.200
     7.370    98.924     0.200
     8.151   107.303     0.200
     8.457   110.939     0.200
     8.630   112.017     0.200
     8.796   114.078     0.200
     9.140   119.863     0.200
     9.463   122.695     0.200
     9.536   122.139     0.200
     9.745   125.806     0.200
     9.829   127.122     0.200
     9.857   127.192     0.200
    10.049   131.660     0.200
     1.510    30.246     0.200
     1.767    33.946     0.200
     2.041    36.756     0.200
     2.039    36.877     0.200
     3.926    61.152     0.200
     4.344    66.674     0.200
     4.511    67.929     0.200
     4.588    69.228     0.200
     5.367    77.042     0.200
     6.299    94.866     0.200
     7.368   101.689     0.200
     7.664   105.334     0.200
     8.766   117.166     0.200
     8.943   119.207     0.200
     9.105   121.018     0.200
    10.038   134.523     0.200
     3.846    57.660     0.200
     4.313    64.305     0.200
     4.336    64.042     0.200
     4.392    63.087     0.200
     4.551    65.332     0.200
     5.733    84.332     0.200
     6.326    92.616     0.200
     7.407    99.704     0.200
     7.703   103.549     0.200
     8.476   112.026     0.200
     8.778   115.603     0.200
     9.116   118.956     0.200
    10.040   133.473     0.200
     1.296    26.181     0.200
     1.533    29.308     0.200
     1.666    31.260     0.200
     2.159    36.502     0.200
     2.241    35.556     0.200
     2.536    41.008     0.200
     2.609    40.660     0.200
     3.152    47.711     0.200
     3.673    55.548     0.200
     3.739    56.863     0.200
     3.716    55.043     0.200
     4.360    62.820     0.200
     4.481    64.516     0.200
     4.472    64.017     0.200
     5.661    81.134     0.200
     6.249    89.079     0.200
     6.331    91.520     0.200
     6.365    90.922     0.200
     6.508    92.649     0.200
     7.217    97.377     0.200
     7.506   100.211     0.200
     7.514    99.512     0.200
     8.540   115.844     0.200
     9.895   126.228     0.200
    10.164   133.389     0.200
    10.283   130.303     0.200
    10.488   134.012     0.200
     2.257    35.016     0.200
     2.527    38.566     0.200
     2.598    39.542     0.200
     3.016    46.753     0.200
     3.141    47.197     0.200
     3.170    47.457     0.200
     3.663    55.711     0.200
     4.350    61.494     0.200
     4.462    63.878     0.200
     6.241    90.420     0.200
     6.324    89.755     0.200
     6.324    91.755     0.200
     7.207    97.756     0.200
     7.572    98.490     0.200
     8.973   116.740     0.200
     9.166   117.785     0.200
     9.895   126.583     0.200
     9.959   127.527     0.200
    10.163   129.554     0.200
    10.163   131.655     0.200
     2.190    36.047     0.200
     2.381    37.619     0.200
     2.409    39.592     0.200
     2.636    41.044     0.200
     2.668    42.269     0.200
     2.724    42.315     0.200
     3.162    49.203     0.200
     3.269    49.559     0.200
     3.305    50.339     0.200
     3.754    54.402     0.200
     3.837    56.236     0.200
     4.272    60.358     0.200
     4.464    62.312     0.200
     4.447    62.813     0.200
     4.548    64.137     0.200
     5.353    73.734     0.200
     5.448    75.027     0.200
     5.533    76.536     0.200
     6.552    88.143     0.200
     6.868    92.655     0.200
     7.146    96.216     0.200
     7.555    97.940     0.200
     7.575    98.202     0.200
     9.185   116.917     0.200
     9.880   126.304     0.200
     9.950   126.389     0.200
    10.272   131.636     0.200
     3.012    48.143     0.200
     3.009    49.783     0.200
     3.269    51.051     0.200
     3.282    53.097     0.200
     3.354    52.859     0.200
     3.756    59.466     0.200
     3.770    60.207     0.200
     3.898    60.209     0.200
     3.926    60.278     0.200
     3.945    63.261     0.200
     4.506    66.911     0.200
     4.484    68.566     0.200
     4.606    68.332     0.200
     4.524    68.806     0.200
     4.945    72.814     0.200
     5.681    82.657     0.200
     5.935    84.533     0.200
     6.027    85.625     0.200
     6.218    89.435     0.200
     6.158    94.032     0.200
     6.242    91.253     0.200
     6.241    93.571     0.200
     6.553    90.608     0.200
     7.622   105.946     0.200
     8.427   114.055     0.200
     8.719   116.148     0.200
     8.855   117.059     0.200
     9.741   128.121     0.200
     0.992    23.344     0.200
     3.833    60.199     0.200
     3.997    61.181     0.200
     4.060    62.548     0.200
     4.215    64.333     0.200
     4.411    65.548     0.200
     4.716    70.990     0.200
     4.722    70.814     0.200
     5.247    76.750     0.200
     5.808    84.350     0.200
     5.997    85.356     0.200
     6.213    89.476     0.200
     6.275    90.396     0.200
     6.341    91.527     0.200
     6.442    93.283     0.200
     6.483    94.965     0.200
     7.538   104.253     0.200
     7.830   109.047     0.200
     8.663   117.826     0.200
     9.529   126.724     0.200
     1.240    24.382     0.200
     2.125    35.260     0.200
     3.173    51.424     0.200
     3.676    57.852     0.200
     3.718    58.468     0.200
     3.778    59.166     0.200
     4.907    72.095     0.200
     4.920    68.545     0.200
     6.026    83.530     0.200
     6.596    90.781     0.200
     8.947   118.045     0.200
     9.323   120.758     0.200
     2.314    39.678     0.200
     2.246    37.878     0.200
     2.431    41.219     0.200
     2.601    42.930     0.200
     3.512    53.102     0.200
     3.625    55.786     0.200
     3.912    57.928     0.200
     4.125    62.441     0.200
     4.078    64.787     0.200
     4.333    64.725     0.200
     4.245    61.446     0.200
     4.397    66.068     0.200
     5.505    80.645     0.200
     6.021    83.119     0.200
     6.088    90.542     0.200
     6.170    89.875     0.200
     6.184    90.017     0.200
     6.328    91.843     0.200
     6.573    94.979     0.200
     6.934   103.168     0.200
     7.187    98.015     0.200
     7.511   101.430     0.200
     7.482   100.271     0.200
     7.482   104.271     0.200
     8.169   108.460     0.200
     8.265   110.338     0.200
     8.351   109.625     0.200
     8.355   115.486     0.200
     8.338   105.782     0.200
     8.500   113.595     0.200
     8.540   113.123     0.200
     8.719   114.136     0.200
     8.879   117.675     0.200
     9.250   122.638     0.200
     9.603   127.123     0.200
     9.700   128.483     0.200
     9.813   130.267     0.200
     9.892   131.945     0.200
     9.923   132.584     0.200
    10.108   135.524     0.200
    10.411   138.196     0.200
    11.052   144.113     0.200
     1.154    24.965     0.200
     1.457    28.642     0.200
     3.646    55.885     0.200
     4.159    62.307     0.200
     4.356    64.807     0.200
     4.415    65.113     0.200
     4.655    71.922     0.200
     5.522    80.203     0.200
     6.096    90.104     0.200
     6.190    89.801     0.200
     8.492   113.246     0.200
     8.532   113.274     0.200
     8.714   116.148     0.200
     8.870   118.526     0.200
     9.506   127.407     0.200
     9.796   131.220     0.200
     4.669    71.556     0.200
     4.698    70.310     0.200
     4.786    71.987     0.200
     5.097    77.159     0.200
     5.099    74.153     0.200
     6.073    86.788     0.200
     6.199    88.802     0.200
     6.332    93.252     0.200
     6.316    89.997     0.200
     6.320    91.785     0.200
     6.459    94.659     0.200
     6.476    94.959     0.200
     6.474    97.585     0.200
     6.579    93.282     0.200
     6.834    98.386     0.200
     7.481   105.637     0.200
     7.774   107.422     0.200
     8.503   116.314     0.200
     8.594   118.350     0.200
     8.642   115.990     0.200
     8.875   121.964     0.200
     9.029   127.981     0.200
     9.491   127.880     0.200
     4.015    62.712     0.200
     4.225    63.751     0.200
     4.321    68.733     0.200
     4.733    70.826     0.200
     5.438    75.503     0.200
     6.309    95.335     0.200
     6.293    91.125     0.200
     6.377    93.735     0.200
     6.502    97.584     0.200
     6.520    98.173     0.200
     6.543    93.708     0.200
     7.560   103.934     0.200
     8.512   116.631     0.200
     8.883   122.199     0.200
     3.970    62.464     0.200
     4.171    63.816     0.200
     4.378    67.693     0.200
     4.687    70.387     0.200
     4.706    69.865     0.200
     5.124    77.792     0.200
     5.117    73.951     0.200
     5.883    83.336     0.200
     6.087    86.390     0.200
     6.220    85.720     0.200
     6.289    95.193     0.200
     6.361    95.052     0.200
     6.347    91.721     0.200
     6.371    96.338     0.200
     6.326    91.880     0.200
     6.499    93.847     0.200
     6.500    98.230     0.200
     7.519   104.239     0.200
     7.812   108.423     0.200
     8.103   112.822     0.200
     8.521   114.645     0.200
     8.634   116.828     0.200
     8.676   116.743     0.200
     8.894   121.600     0.200
     9.729   133.149     0.200
     1.113    26.084     0.200
     1.182    27.085     0.200
     3.273    54.582     0.200
     3.456    56.842     0.200
     3.473    57.641     0.200
     3.735    60.382     0.200
     3.814    61.960     0.200
     4.199    65.677     0.200
     4.358    68.516     0.200
     4.383    68.327     0.200
     4.572    70.820     0.200
     4.577    66.760     0.200
     5.651    80.922     0.200
     6.066    88.082     0.200
     7.680   108.045     0.200
     1.585    28.078     0.200
     2.175    36.593     0.200
     2.389    39.497     0.200
     2.369    38.130     0.200
     2.651    42.748     0.200
     2.630    41.688     0.200
     2.712    42.535     0.200
     3.141    48.718     0.200
     3.256    49.979     0.200
     3.289    50.397     0.200
     3.720    55.873     0.200
     3.801    56.513     0.200
     4.112    63.698     0.200
     4.412    64.086     0.200
     4.514    64.898     0.200
     4.265    64.306     0.200
     5.534    77.600     0.200
     5.627    82.011     0.200
     6.220    88.695     0.200
     6.273    90.774     0.200
     6.355    91.613     0.200
     6.475    88.114     0.200
     6.549    88.945     0.200
     6.560    89.927     0.200
     6.620    83.929     0.200
     7.092    90.110     0.200
     7.208    97.562     0.200
     7.229    97.417     0.200
     7.537    99.913     0.200
     7.558    99.081     0.200
     7.567   102.268     0.200
     7.614   100.514     0.200
     7.704   108.975     0.200
     8.213   107.432     0.200
     8.254   111.963     0.200
     8.487   109.240     0.200
     8.496   111.224     0.200
     8.661   115.006     0.200
     8.779   114.020     0.200
     8.896   121.361     0.200
     8.942   120.223     0.200
     8.978   114.310     0.200
     9.161   117.374     0.200
     9.374   122.984     0.200
     9.862   127.782     0.200
    10.137   129.778     0.200
    10.228   134.317     0.200
    10.253   131.128     0.200
    10.761   139.789     0.200
    13.124   166.023     0.200
    13.412   170.957     0.200
    13.484   172.119     0.200
     2.136    35.433     0.200
     2.331    37.450     0.200
     2.348    38.456     0.200
     2.594    39.584     0.200
     2.610    40.695     0.200
     2.673    40.962     0.200
     3.100    47.478     0.200
     3.217    48.110     0.200
     3.249    49.536     0.200
     3.704    54.530     0.200
     4.086    62.575     0.200
     4.395    63.368     0.200
     4.500    64.037     0.200
     5.510    77.050     0.200
     6.201    86.288     0.200
     6.266    88.635     0.200
     6.348    91.469     0.200
     6.497    90.538     0.200
     6.523    95.138     0.200
     6.627    82.123     0.200
     7.046    92.526     0.200
     7.572    97.687     0.200
     7.550   100.952     0.200
     9.166   116.289     0.200
     9.360   123.329     0.200
     9.876   126.601     0.200
    10.242   132.231     0.200
     2.632    43.184     0.200
     2.966    47.684     0.200
     3.506    54.514     0.200
     3.516    56.434     0.200
     3.595    57.111     0.200
     4.174    62.654     0.200
     4.250    62.873     0.200
     4.634    69.395     0.200
     5.967    89.332     0.200
     5.988    86.285     0.200
     6.071    90.223     0.200
     6.214    93.049     0.200
     6.325    92.926     0.200
     6.634    95.447     0.200
     7.031    94.200     0.200
     8.127   109.830     0.200
     8.430   112.991     0.200
     8.636   114.085     0.200
     8.810   117.249     0.200
     9.776   128.680     0.200
     9.891   132.638     0.200
     1.734    30.346     0.200
     2.450    40.691     0.200
     2.620    43.561     0.200
     2.664    42.850     0.200
     2.903    46.822     0.200
     2.948    46.077     0.200
     2.999    47.310     0.200
     3.362    53.015     0.200
     3.540    54.189     0.200
     3.555    54.651     0.200
     3.651    54.977     0.200
     4.082    58.245     0.200
     4.227    60.756     0.200
     4.299    62.911     0.200
     4.687    68.191     0.200
     5.408    76.864     0.200
     6.009    87.860     0.200
     6.041    84.184     0.200
     6.110    85.381     0.200
     6.110    88.677     0.200
     6.357    94.352     0.200
     7.082    93.692     0.200
     8.144   108.540     0.200
     8.666   115.347     0.200
     8.836   117.566     0.200
     9.792   127.707     0.200
     1.741    34.124     0.200
     2.608    44.703     0.200
     2.901    47.125     0.200
     2.942    49.302     0.200
     3.481    55.996     0.200
     3.491    56.945     0.200
     3.577    54.997     0.200
     3.952    60.071     0.200
     4.004    60.421     0.200
     4.159    65.309     0.200
     4.237    64.596     0.200
     4.618    70.253     0.200
     5.169    75.922     0.200
     5.697    83.161     0.200
     5.973    86.643     0.200
     5.973    88.043     0.200
     6.131    89.097     0.200
     6.631    94.762     0.200
     6.802    98.265     0.200
     7.182    99.224     0.200
     8.132   112.247     0.200
     8.431   114.858     0.200
     8.635   116.476     0.200
     8.811   118.914     0.200
     9.782   128.391     0.200
     9.898   130.139     0.200
     2.602    42.798     0.200
     2.855    47.084     0.200
     2.878    45.753     0.200
     2.940    47.383     0.200
     3.324    53.463     0.200
     3.483    54.413     0.200
     3.503    54.774     0.200
     4.131    60.367     0.200
     4.118    65.324     0.200
     4.293    63.276     0.200
     4.372    62.256     0.200
     4.752    70.520     0.200
     4.813    70.704     0.200
     4.868    70.658     0.200
     5.455    81.013     0.200
     5.482    79.298     0.200
     6.091    87.689     0.200
     6.106    86.511     0.200
     6.174    87.525     0.200
     6.194    88.286     0.200
     6.338    91.510     0.200
     6.446    92.074     0.200
     6.719    92.160     0.200
     6.711    92.456     0.200
     6.757    94.624     0.200
     6.944    94.135     0.200
     7.082    97.426     0.200
     7.120    98.381     0.200
     7.150    97.333     0.200
     7.150    96.732     0.200
     7.181    97.273     0.200
     7.280    97.621     0.200
     7.300   100.581     0.200
     7.318   101.868     0.200
     7.446   100.980     0.200
     7.560   104.172     0.200
     7.589   104.013     0.200
     7.604   102.428     0.200
     8.032   109.892     0.200
     8.216   109.497     0.200
     8.237   109.745     0.200
     8.259   109.790     0.200
     8.432   112.774     0.200
     8.548   113.621     0.200
     8.672   118.074     0.200
     8.756   115.386     0.200
     9.229   122.069     0.200
     9.229   122.569     0.200
     9.885   126.810     0.200
     9.971   129.306     0.200
     9.999   129.890     0.200
     1.192    23.882     0.200
     1.233    25.302     0.200
     1.287    25.265     0.200
     4.607    64.929     0.200
     4.703    66.503     0.200
     5.062    70.317     0.200
     5.734    79.471     0.200
     5.816    80.825     0.200
     6.416    87.818     0.200
     6.447    90.855     0.200
     6.555    91.102     0.200
     6.816    94.579     0.200
     7.124   100.654     0.200
     7.466    99.768     0.200
     7.762   102.907     0.200
     8.918   117.214     0.200
     9.298   120.184     0.200
    10.249   134.988     0.200
     2.781    45.471     0.200
     2.866    44.250     0.200
     2.958    47.346     0.200
     2.988    47.750     0.200
     3.239    50.927     0.200
     3.260    51.283     0.200
     3.327    52.031     0.200
     3.700    56.884     0.200
     3.759    59.285     0.200
     3.869    59.171     0.200
     3.888    59.047     0.200
     3.888    59.047     0.200
     4.055    61.347     0.200
     4.151    63.606     0.200
     4.148    60.956     0.200
     4.262    63.117     0.200
     4.280    64.607     0.200
     4.345    64.918     0.200
     4.354    63.799     0.200
     4.394    64.072     0.200
     4.471    65.348     0.200
     4.469    68.704     0.200
     4.818    70.026     0.200
     6.035    87.728     0.200
     6.120    89.027     0.200
     6.169    87.862     0.200
     6.640    96.963     0.200
     6.664    93.379     0.200
     7.028    96.140     0.200
     7.048    97.695     0.200
     7.492   100.516     0.200
     8.375   110.411     0.200
     8.706   113.850     0.200
     8.752   115.916     0.200
     9.356   122.968     0.200
     9.653   127.499     0.200
     2.853    46.718     0.200
     2.988    50.458     0.200
     3.237    54.334     0.200
     3.261    53.641     0.200
     3.326    54.731     0.200
     3.455    53.812     0.200
     3.697    59.889     0.200
     3.803    58.673     0.200
     3.868    61.583     0.200
     3.887    62.190     0.200
     3.887    62.190     0.200
     3.911    62.977     0.200
     3.959    58.800     0.200
     4.043    60.567     0.200
     4.192    62.613     0.200
     4.342    65.091     0.200
     4.463    69.352     0.200
     4.806    73.658     0.200
     5.254    77.288     0.200
     5.482    82.061     0.200
     5.559    83.161     0.200
     6.022    89.460     0.200
     6.104    90.296     0.200
     6.108    89.957     0.200
     6.156    90.394     0.200
     6.185    86.455     0.200
     6.251    92.184     0.200
     6.370    90.496     0.200
     6.405    92.293     0.200
     6.628    96.788     0.200
     6.673    93.262     0.200
     6.875    95.211     0.200
     7.186   100.979     0.200
     7.314   101.583     0.200
     7.480   103.148     0.200
     7.630   105.197     0.200
     7.693   104.806     0.200
     8.004   108.232     0.200
     8.093   111.395     0.200
     8.177   111.346     0.200
     8.284   113.758     0.200
     8.364   113.026     0.200
     8.386   112.075     0.200
     8.386   112.075     0.200
     8.441   117.835     0.200
     8.694   118.581     0.200
     8.741   116.931     0.200
     8.902   117.609     0.200
     9.221   122.826     0.200
     9.221   122.025     0.200
     9.347   126.762     0.200
     9.621   129.963     0.200
     9.643   129.798     0.200
     9.689   131.561     0.200
     9.718   130.333     0.200
     9.989   137.474     0.200
    10.033   141.497     0.200
    10.218   137.689     0.200
    10.931   144.375     0.200
    10.970   142.972     0.200
    11.179   147.278     0.200
    12.916   169.906     0.200
    14.359   193.063     0.200
    18.262   244.164     0.200
    18.464   247.248     0.200
    18.464   248.016     0.200
    18.789   247.647     0.200
    18.789   248.256     0.200
    18.789   248.994     0.200
    20.687   275.217     0.200
     2.746    45.745     0.200
     2.854    45.981     0.200
     2.923    48.258     0.200
     2.954    48.329     0.200
     3.204    51.460     0.200
     3.226    51.055     0.200
     3.293    52.212     0.200
     3.666    57.594     0.200
     3.835    59.153     0.200
     3.854    58.861     0.200
     3.854    58.861     0.200
     4.046    63.551     0.200
     4.133    62.644     0.200
     4.262    64.673     0.200
     4.329    64.644     0.200
     4.344    64.583     0.200
     4.387    65.315     0.200
     4.456    65.555     0.200
     4.497    69.035     0.200
     4.808    71.213     0.200
     4.863    73.268     0.200
     5.489    80.359     0.200
     5.887    83.009     0.200
     6.035    88.187     0.200
     6.118    88.522     0.200
     6.159    88.641     0.200
     6.196    85.604     0.200
     6.266    89.995     0.200
     6.552    88.457     0.200
     6.646    95.655     0.200
     6.961    97.382     0.200
     7.047    96.981     0.200
     7.068    96.737     0.200
     7.190    98.713     0.200
     7.484   102.177     0.200
     8.387   111.641     0.200
     8.764   115.941     0.200
     9.375   126.213     0.200
     9.670   127.662     0.200
     2.810    47.318     0.200
     2.868    46.471     0.200
     2.986    49.635     0.200
     3.018    49.690     0.200
     3.267    53.238     0.200
     3.289    52.589     0.200
     3.356    53.901     0.200
     3.727    59.209     0.200
     3.789    61.262     0.200
     3.898    60.764     0.200
     3.917    61.296     0.200
     3.917    61.296     0.200
     4.055    61.044     0.200
     4.153    62.441     0.200
     4.287    62.647     0.200
     4.355    65.451     0.200
     4.392    65.027     0.200
     4.440    68.565     0.200
     4.476    66.925     0.200
     4.819    69.843     0.200
     5.576    78.510     0.200
     6.026    87.957     0.200
     6.169    89.188     0.200
     7.197    98.087     0.200
     7.491   101.758     0.200
     8.298   110.538     0.200
     8.358   112.344     0.200
     8.703   119.616     0.200
     8.734   116.351     0.200
     9.631   130.181     0.200
     9.701   133.873     0.200
     2.748    45.748     0.200
     2.841    47.510     0.200
     2.923    48.768     0.200
     2.957    47.531     0.200
     3.205    52.128     0.200
     3.230    50.778     0.200
     3.295    51.790     0.200
     3.665    58.291     0.200
     3.837    59.003     0.200
     3.855    59.831     0.200
     3.855    59.831     0.200
     4.033    62.892     0.200
     4.121    64.377     0.200
     4.236    65.509     0.200
     4.317    65.793     0.200
     4.331    65.540     0.200
     4.374    66.109     0.200
     4.444    67.487     0.200
     4.489    69.767     0.200
     4.776    71.044     0.200
     4.795    71.802     0.200
     4.867    74.763     0.200
     5.476    79.955     0.200
     5.545    79.650     0.200
     6.022    89.285     0.200
     6.104    90.023     0.200
     6.109    90.265     0.200
     6.146    89.630     0.200
     6.252    91.492     0.200
     6.633    97.052     0.200
     6.655    92.098     0.200
     7.177    99.704     0.200
     7.471   103.168     0.200
     8.018   109.885     0.200
     8.093   109.613     0.200
     8.273   111.410     0.200
     8.374   113.431     0.200
     8.421   116.879     0.200
     8.687   118.382     0.200
     8.685   118.710     0.200
     8.751   117.031     0.200
     9.216   123.105     0.200
     9.216   122.406     0.200
     9.659   129.843     0.200
     9.681   130.980     0.200
     1.192    25.707     0.200
     2.855    44.718     0.200
     3.778    58.654     0.200
     4.043    62.550     0.200
     4.139    61.332     0.200
     4.337    64.017     0.200
     4.381    63.624     0.200
     4.806    70.455     0.200
     7.027    96.243     0.200
     7.480    99.459     0.200
     8.355   111.443     0.200
     8.731   114.651     0.200
     9.632   127.244     0.200
     1.147    25.019     0.200
     1.054    23.604     0.200
     1.189    26.541     0.200
     2.857    46.593     0.200
     2.793    46.303     0.200
     2.968    49.558     0.200
     3.001    48.380     0.200
     3.250    52.822     0.200
     3.274    51.378     0.200
     3.340    53.012     0.200
     3.710    59.075     0.200
     3.882    59.950     0.200
     3.900    60.456     0.200
     3.900    60.456     0.200
     4.046    61.685     0.200
     4.141    62.392     0.200
     4.167    63.072     0.200
     4.274    63.118     0.200
     4.383    64.938     0.200
     4.464    66.336     0.200
     4.809    69.677     0.200
     5.564    80.466     0.200
     6.159    88.916     0.200
     6.625    96.187     0.200
     7.482   100.181     0.200
     8.359   112.349     0.200
     8.736   116.556     0.200
     9.636   129.049     0.200
     9.712   129.754     0.200
     1.174    24.913     0.200
     1.298    28.870     0.200
     2.761    45.746     0.200
     2.849    46.957     0.200
     2.937    49.074     0.200
     2.970    48.267     0.200
     3.218    51.841     0.200
     3.243    50.721     0.200
     3.308    52.165     0.200
     3.437    52.717     0.200
     3.679    58.447     0.200
     3.744    58.433     0.200
     3.850    59.197     0.200
     3.868    59.124     0.200
     3.868    59.124     0.200
     4.040    62.263     0.200
     4.130    64.174     0.200
     4.136    64.964     0.200
     4.244    66.099     0.200
     4.261    63.608     0.200
     4.326    65.309     0.200
     4.338    65.795     0.200
     4.380    65.715     0.200
     4.453    66.921     0.200
     4.802    69.790     0.200
     5.481    80.366     0.200
     5.553    79.422     0.200
     6.111    88.009     0.200
     6.153    88.523     0.200
     6.633    96.112     0.200
     7.030    98.285     0.200
     7.051    98.440     0.200
     7.477   102.567     0.200
     8.014   109.597     0.200
     8.280   111.290     0.200
     8.372   111.216     0.200
     8.749   116.919     0.200
     9.654   130.060     0.200
     9.726   130.219     0.200
     2.771    47.476     0.200
     2.870    47.433     0.200
     2.949    49.958     0.200
     2.978    49.624     0.200
     3.229    53.513     0.200
     3.248    52.742     0.200
     3.316    54.160     0.200
     3.692    59.190     0.200
     3.747    59.984     0.200
     3.859    60.891     0.200
     3.878    61.079     0.200
     3.878    61.079     0.200
     4.151    64.592     0.200
     4.282    67.037     0.200
     4.359    68.035     0.200
     4.401    66.754     0.200
     4.481    69.217     0.200
     4.823    72.924     0.200
     6.174    87.958     0.200
     6.424    91.844     0.200
     2.880    46.110     0.200
     4.071    62.847     0.200
     4.160    61.566     0.200
     4.274    65.569     0.200
     4.356    64.243     0.200
     4.370    63.935     0.200
     4.483    65.086     0.200
     4.496    67.364     0.200
     4.833    70.923     0.200
     6.185    88.455     0.200
     8.402   110.878     0.200
     8.779   116.681     0.200
     1.045    24.031     0.200
     2.872    46.041     0.200
     2.808    46.657     0.200
     2.984    49.155     0.200
     3.015    48.943     0.200
     3.265    52.482     0.200
     3.286    52.201     0.200
     3.354    53.466     0.200
     3.481    55.477     0.200
     3.726    58.894     0.200
     3.824    56.614     0.200
     3.772    59.285     0.200
     3.936    60.902     0.200
     3.896    60.515     0.200
     3.915    60.862     0.200
     3.915    60.862     0.200
     4.060    60.611     0.200
     4.157    61.175     0.200
     4.304    68.377     0.200
     4.360    62.526     0.200
     4.445    66.431     0.200
     4.502    69.156     0.200
     4.688    66.897     0.200
     4.824    71.708     0.200
     4.961    71.101     0.200
     4.922    74.857     0.200
     4.994    70.759     0.200
     5.148    77.567     0.200
     5.282    76.713     0.200
     5.339    76.048     0.200
     5.496    78.858     0.200
     5.580    81.982     0.200
     5.724    80.168     0.200
     5.799    81.927     0.200
     6.031    88.413     0.200
     5.994    82.890     0.200
     6.114    88.453     0.200
     6.116    87.728     0.200
     6.064    85.677     0.200
     6.174    89.353     0.200
     6.259    92.357     0.200
     6.206    84.498     0.200
     6.339    89.177     0.200
     6.295    88.695     0.200
     6.388    89.853     0.200
     6.458    91.235     0.200
     6.633    95.098     0.200
     6.697    91.146     0.200
     6.790    99.566     0.200
     6.757    94.349     0.200
     6.881    95.062     0.200
     6.899    92.492     0.200
     7.010    96.189     0.200
     7.031    96.644     0.200
     7.029    96.410     0.200
     7.202    99.250     0.200
     7.325   101.082     0.200
     7.496   101.718     0.200
     7.715   103.000     0.200
     7.801   104.278     0.200
     7.973   105.110     0.200
     7.999   107.257     0.200
     8.183   109.438     0.200
     8.303   110.603     0.200
     8.364   111.195     0.200
     8.398   112.300     0.200
     8.465   117.615     0.200
     8.708   117.675     0.200
     8.709   123.764     0.200
     8.740   115.503     0.200
     8.940   118.847     0.200
     8.940   120.484     0.200
     9.235   121.633     0.200
     9.235   121.532     0.200
     9.339   124.017     0.200
     9.347   126.518     0.200
     9.592   126.661     0.200
     9.628   128.741     0.200
     9.637   127.534     0.200
     9.706   131.535     0.200
     9.716   125.713     0.200
     9.913   131.314     0.200
     9.995   134.426     0.200
     9.964   131.078     0.200
    10.345   139.550     0.200
    10.735   143.310     0.200
    10.932   141.919     0.200
    10.975   143.304     0.200
    10.955   148.772     0.200
    10.971   144.783     0.200
    11.180   144.831     0.200
    11.310   157.313     0.200
    11.465   158.181     0.200
    18.805   250.324     0.200
    20.762   271.007     0.200
     1.648    32.063     0.200
     2.871    46.117     0.200
     2.837    46.963     0.200
     3.011    49.591     0.200
     3.045    49.136     0.200
     3.294    52.619     0.200
     3.317    52.541     0.200
     3.383    53.325     0.200
     3.753    58.849     0.200
     3.816    60.018     0.200
     3.925    60.399     0.200
     3.944    60.814     0.200
     3.944    60.814     0.200
     4.013    59.989     0.200
     4.056    60.985     0.200
     4.159    63.420     0.200
     4.295    62.016     0.200
     4.357    65.167     0.200
     4.357    62.983     0.200
     4.391    63.505     0.200
     4.482    65.496     0.200
     4.821    70.384     0.200
     4.716    70.081     0.200
     5.025    72.147     0.200
     5.489    80.086     0.200
     5.581    80.313     0.200
     5.754    80.555     0.200
     6.019    89.606     0.200
     6.101    89.345     0.200
     6.102    89.431     0.200
     6.024    83.322     0.200
     6.171    88.634     0.200
     6.245    89.963     0.200
     6.324    88.181     0.200
     7.491   100.821     0.200
     8.343   110.783     0.200
     8.719   115.496     0.200
     9.226   121.374     0.200
     9.313   123.763     0.200
     9.612   125.569     0.200
     9.695   127.509     0.200
     9.887   131.068     0.200
     1.059    22.365     0.200
     1.647    30.984     0.200
     2.871    46.046     0.200
     2.831    44.497     0.200
     3.006    47.486     0.200
     3.039    46.890     0.200
     3.288    50.476     0.200
     3.311    49.960     0.200
     3.378    51.391     0.200
     3.748    56.724     0.200
     3.920    58.044     0.200
     3.938    58.348     0.200
     3.938    58.348     0.200
     4.057    60.550     0.200
     4.158    62.883     0.200
     4.271    63.108     0.200
     4.294    63.515     0.200
     4.357    64.260     0.200
     4.356    64.560     0.200
     4.391    63.381     0.200
     4.481    65.088     0.200
     4.420    68.051     0.200
     7.492   100.001     0.200
     8.346   111.330     0.200
     8.722   115.339     0.200
     9.617   127.204     0.200
     1.071    24.122     0.200
     1.199    26.670     0.200
     1.659    31.158     0.200
     2.859    45.861     0.200
     4.045    60.947     0.200
     4.147    61.840     0.200
     4.260    63.848     0.200
     8.334   111.990     0.200
     8.710   115.799     0.200
     1.217    26.854     0.200
     2.836    47.369     0.200
     3.802    63.170     0.200
     4.022    62.324     0.200
     4.123    63.503     0.200
     4.235    67.097     0.200
     4.258    63.342     0.200
     4.358    66.475     0.200
     4.445    66.590     0.200
     4.786    70.877     0.200
     6.136    89.623     0.200
     7.458   102.398     0.200
     8.266   112.667     0.200
     8.325   111.974     0.200
     8.702   115.382     0.200
     9.602   128.581     0.200
     1.203    26.898     0.200
     1.663    31.773     0.200
     2.824    47.482     0.200
     2.853    47.011     0.200
     2.996    50.107     0.200
     3.033    49.231     0.200
     3.279    53.315     0.200
     3.307    51.986     0.200
     3.371    53.558     0.200
     3.737    59.852     0.200
     3.808    61.938     0.200
     3.913    60.413     0.200
     3.930    61.512     0.200
     3.930    61.512     0.200
     4.039    61.941     0.200
     4.140    63.080     0.200
     4.253    63.977     0.200
     4.276    61.974     0.200
     4.338    66.769     0.200
     4.374    65.131     0.200
     4.463    66.956     0.200
     4.803    70.023     0.200
     5.473    81.110     0.200
     6.153    89.271     0.200
     7.474   102.152     0.200
     8.283   112.515     0.200
     8.334   109.717     0.200
     8.710   115.025     0.200
     9.607   127.559     0.200
     9.686   126.733     0.200
     1.118    26.573     0.200
     1.670    32.257     0.200
     2.842    47.222     0.200
     3.024    51.072     0.200
     3.361    55.632     0.200
     3.647    55.580     0.200
     3.726    61.317     0.200
     3.795    59.731     0.200
     3.789    59.319     0.200
     3.911    63.021     0.200
     3.903    63.110     0.200
     3.920    63.345     0.200
     3.920    63.345     0.200
     3.984    60.052     0.200
     4.029    62.653     0.200
     4.129    62.427     0.200
     4.242    66.951     0.200
     4.327    66.419     0.200
     4.328    65.495     0.200
     4.365    65.804     0.200
     4.521    68.679     0.200
     4.715    69.536     0.200
     4.793    71.109     0.200
     4.935    74.947     0.200
     5.014    71.406     0.200
     5.289    76.563     0.200
     5.464    79.779     0.200
     5.742    80.995     0.200
     5.998    88.946     0.200
     6.016    83.513     0.200
     6.080    88.787     0.200
     6.082    88.164     0.200
     6.081    84.680     0.200
     6.143    89.456     0.200
     6.225    90.590     0.200
     6.598    96.933     0.200
     6.781    92.511     0.200
     7.170    99.462     0.200
     7.464   103.032     0.200
     7.688   105.562     0.200
     7.967   109.962     0.200
     8.272   111.301     0.200
     8.331   112.021     0.200
     8.676   116.794     0.200
     8.707   115.229     0.200
     8.920   121.421     0.200
     9.202   123.156     0.200
     9.276   128.455     0.200
     9.308   126.012     0.200
     9.336   123.208     0.200
     9.559   125.587     0.200
     9.594   128.276     0.200
     9.606   128.136     0.200
     9.674   130.448     0.200
     9.683   127.934     0.200
     9.883   132.801     0.200
     9.946   134.954     0.200
    10.179   136.349     0.200
    10.328   139.549     0.200
    10.939   149.096     0.200
    10.950   146.520     0.200
     2.829    47.807     0.200
     4.018    62.937     0.200
     4.112    64.701     0.200
     4.226    65.395     0.200
     4.309    66.420     0.200
     4.435    67.192     0.200
     4.781    71.796     0.200
     6.131    90.932     0.200
     7.455   103.891     0.200
     8.342   112.839     0.200
     8.719   118.040     0.200
     9.328   127.535     0.200
     9.623   130.383     0.200
     2.870    46.199     0.200
     4.056    61.059     0.200
     4.156    62.605     0.200
     4.269    62.555     0.200
     4.354    63.085     0.200
     4.391    65.645     0.200
     4.479    65.302     0.200
     4.820    70.040     0.200
     6.170    88.982     0.200
     7.983   108.628     0.200
     8.350   110.848     0.200
     8.726   115.457     0.200
     9.322   126.101     0.200
     9.621   128.307     0.200
     1.217    26.956     0.200
     2.838    46.677     0.200
     4.024    62.251     0.200
     4.125    63.085     0.200
     4.238    64.591     0.200
     4.323    66.766     0.200
     4.448    66.282     0.200
     4.415    69.592     0.200
     4.788    70.638     0.200
     5.458    81.217     0.200
     6.138    89.088     0.200
     7.459   101.566     0.200
     8.323   110.090     0.200
     8.699   117.494     0.200
     9.300   127.183     0.200
     9.598   128.607     0.200
     0.851    19.848     0.200
     1.100    23.707     0.200
     2.866    45.214     0.200
     2.845    46.388     0.200
     3.054    48.171     0.200
     3.302    52.986     0.200
     3.327    50.731     0.200
     3.392    52.718     0.200
     3.760    59.436     0.200
     3.814    58.378     0.200
     3.827    59.125     0.200
     3.934    59.728     0.200
     3.952    60.372     0.200
     3.952    60.372     0.200
     4.050    61.768     0.200
     4.155    62.118     0.200
     4.267    62.918     0.200
     4.292    59.593     0.200
     4.350    64.044     0.200
     4.353    64.615     0.200
     4.384    65.023     0.200
     4.403    65.708     0.200
     4.477    64.504     0.200
     4.815    71.593     0.200
     4.912    68.195     0.200
     4.963    75.261     0.200
     5.320    75.303     0.200
     5.482    79.312     0.200
     5.576    79.103     0.200
     6.010    88.249     0.200
     6.092    87.790     0.200
     6.093    87.884     0.200
     6.164    88.548     0.200
     6.236    89.111     0.200
     6.972    94.117     0.200
     6.993    95.270     0.200
     7.191    97.263     0.200
     7.485   102.742     0.200
     7.963   107.061     0.200
     8.026   106.022     0.200
     8.062   107.896     0.200
     8.295   110.581     0.200
     8.331   109.256     0.200
     8.379   109.802     0.200
     8.476   112.674     0.200
     8.694   117.824     0.200
     8.708   113.563     0.200
     8.927   127.324     0.200
     9.218   120.507     0.200
     9.218   119.804     0.200
     9.301   122.139     0.200
     9.600   125.744     0.200
     9.683   126.179     0.200
     9.874   130.445     0.200
    10.169   134.712     0.200
     4.064    60.975     0.200
     4.275    65.904     0.200
     4.443    66.284     0.200
     4.828    71.293     0.200
     6.034    89.112     0.200
     6.119    86.727     0.200
     6.178    88.536     0.200
     7.032    93.876     0.200
     7.500   100.407     0.200
     8.365   109.911     0.200
     8.741   114.120     0.200
     9.638   125.462     0.200
     2.797    48.976     0.200
     2.970    51.659     0.200
     3.007    51.682     0.200
     3.253    55.107     0.200
     3.281    54.192     0.200
     3.344    55.701     0.200
     3.711    61.122     0.200
     3.771    60.510     0.200
     3.783    61.872     0.200
     3.886    62.756     0.200
     3.903    62.965     0.200
     3.903    62.965     0.200
     3.971    64.861     0.200
     4.129    64.405     0.200
     4.331    66.582     0.200
     4.326    66.511     0.200
     4.369    66.330     0.200
     4.441    65.795     0.200
     4.795    72.656     0.200
     5.272    78.151     0.200
     5.552    78.932     0.200
     6.091    89.135     0.200
     6.146    90.198     0.200
     6.996    95.176     0.200
     7.017    95.132     0.200
     7.468   103.264     0.200
     8.275   111.452     0.200
     8.344   111.348     0.200
     8.681   119.414     0.200
     8.720   116.253     0.200
     9.324   124.905     0.200
     9.621   127.338     0.200
     1.196    26.742     0.200
     2.836    47.938     0.200
     2.863    47.480     0.200
     3.009    50.942     0.200
     3.044    50.003     0.200
     3.292    53.903     0.200
     3.317    52.979     0.200
     3.382    54.738     0.200
     3.750    60.406     0.200
     3.817    60.394     0.200
     3.925    61.261     0.200
     3.942    61.524     0.200
     3.942    61.524     0.200
     4.010    62.467     0.200
     4.048    62.460     0.200
     4.263    66.877     0.200
     4.348    64.768     0.200
     4.382    65.699     0.200
     4.473    67.425     0.200
     4.813    71.878     0.200
     5.573    82.503     0.200
     6.162    89.929     0.200
     7.483   102.414     0.200
     8.293   115.267     0.200
     8.336   110.166     0.200
     8.712   113.876     0.200
     9.606   127.038     0.200
     9.687   127.990     0.200
     1.049    23.509     0.200
     1.178    26.066     0.200
     1.426    28.882     0.200
     1.638    32.437     0.200
     2.876    46.668     0.200
     4.063    61.955     0.200
     7.021    97.084     0.200
     8.357   110.995     0.200
     8.733   115.406     0.200
     9.328   126.855     0.200
     9.627   129.063     0.200
     1.078    25.128     0.200
     1.206    26.658     0.200
     1.666    33.009     0.200
     2.853    46.857     0.200
     4.038    61.657     0.200
     4.141    63.434     0.200
     4.254    63.943     0.200
     4.338    65.053     0.200
     4.464    66.850     0.200
     4.803    68.536     0.200
     6.152    89.485     0.200
     7.473   101.572     0.200
     8.283   110.623     0.200
     8.327   112.101     0.200
     8.683   117.950     0.200
     8.704   116.109     0.200
     9.599   129.159     0.200
     9.679   130.124     0.200
     2.872    47.363     0.200
     2.784    47.207     0.200
     2.962    50.547     0.200
     2.991    49.197     0.200
     3.242    53.357     0.200
     3.262    51.982     0.200
     3.330    54.003     0.200
     3.704    60.078     0.200
     3.872    60.813     0.200
     3.892    61.295     0.200
     3.892    61.295     0.200
     4.061    61.895     0.200
     4.154    64.233     0.200
     4.268    64.638     0.200
     4.286    64.279     0.200
     4.351    66.122     0.200
     4.360    66.454     0.200
     4.400    65.849     0.200
     4.477    66.825     0.200
     4.468    66.855     0.200
     4.824    72.806     0.200
     6.175    89.136     0.200
     6.691    92.419     0.200
     7.030    98.064     0.200
     7.051    98.117     0.200
     7.498   102.793     0.200
     8.303   111.207     0.200
     8.379   112.413     0.200
     8.712   117.630     0.200
     8.756   116.323     0.200
     9.239   124.176     0.200
     9.358   127.189     0.200
     9.656   128.818     0.200
     9.732   129.623     0.200
     2.773    46.019     0.200
     2.868    46.822     0.200
     2.951    49.069     0.200
     2.980    47.798     0.200
     3.232    52.099     0.200
     3.251    50.651     0.200
     3.319    52.346     0.200
     3.694    58.545     0.200
     3.861    59.281     0.200
     3.881    59.819     0.200
     3.881    59.819     0.200
     4.150    62.681     0.200
     4.143    64.466     0.200
     4.281    63.353     0.200
     4.357    65.665     0.200
     4.398    64.985     0.200
     4.477    65.865     0.200
     4.821    70.354     0.200
     4.949    70.323     0.200
     6.172    88.487     0.200
     7.036    97.302     0.200
     7.057    97.660     0.200
     7.496   101.638     0.200
     8.300   111.156     0.200
     8.383   112.889     0.200
     8.760   116.493     0.200
     9.662   130.062     0.200
     2.855    47.999     0.200
     2.832    48.961     0.200
     3.004    52.057     0.200
     3.041    50.790     0.200
     3.288    55.163     0.200
     3.315    52.976     0.200
     3.379    54.687     0.200
     3.745    61.582     0.200
     3.803    60.855     0.200
     3.816    60.210     0.200
     3.921    61.882     0.200
     3.938    62.901     0.200
     3.938    62.901     0.200
     4.004    60.602     0.200
     4.026    66.752     0.200
     4.208    65.837     0.200
     4.341    65.086     0.200
     4.375    66.184     0.200
     4.411    65.364     0.200
     4.695    69.564     0.200
     4.805    72.867     0.200
     4.951    78.160     0.200
     5.027    75.017     0.200
     5.307    78.427     0.200
     5.565    83.694     0.200
     6.086    91.312     0.200
     6.088    90.897     0.200
     6.028    87.457     0.200
     6.155    91.216     0.200
     6.231    92.426     0.200
     6.330    92.887     0.200
     6.602    96.396     0.200
     6.889    93.946     0.200
     6.975    95.737     0.200
     6.996    96.893     0.200
     7.475   103.201     0.200
     7.703   108.710     0.200
     7.964   109.698     0.200
     8.060   110.384     0.200
     8.285   110.955     0.200
     8.331   111.520     0.200
     8.372   111.335     0.200
     8.372   111.335     0.200
     8.686   117.678     0.200
     8.707   115.430     0.200
     9.211   122.749     0.200
     9.211   122.249     0.200
     9.304   124.865     0.200
     9.599   127.817     0.200
     9.602   127.779     0.200
     9.683   128.242     0.200
     9.878   132.663     0.200
    10.173   134.721     0.200
    10.900   142.734     0.200
     2.862    47.704     0.200
     2.821    46.222     0.200
     2.995    49.839     0.200
     3.029    47.908     0.200
     3.277    52.603     0.200
     3.302    50.507     0.200
     3.367    52.403     0.200
     3.736    59.238     0.200
     3.910    59.666     0.200
     3.928    60.036     0.200
     3.928    60.036     0.200
     3.997    62.670     0.200
     4.194    66.413     0.200
     4.348    65.021     0.200
     4.384    65.604     0.200
     4.520    68.008     0.200
     4.812    72.304     0.200
     4.938    74.631     0.200
     5.012    73.645     0.200
     5.295    77.612     0.200
     5.571    83.551     0.200
     6.097    91.103     0.200
     6.099    88.483     0.200
     6.162    88.350     0.200
     6.242    91.711     0.200
     7.484   101.527     0.200
     7.979   107.848     0.200
     8.072   110.554     0.200
     8.344   112.780     0.200
     8.695   118.495     0.200
     8.721   115.488     0.200
     9.220   121.859     0.200
     9.220   121.659     0.200
     9.617   128.827     0.200
     9.693   135.144     0.200
     1.194    26.962     0.200
     1.653    32.372     0.200
     2.803    47.739     0.200
     2.856    46.977     0.200
     2.977    49.155     0.200
     3.012    50.433     0.200
     3.260    52.950     0.200
     3.285    54.415     0.200
     3.350    54.527     0.200
     3.719    58.343     0.200
     3.786    58.923     0.200
     3.892    61.533     0.200
     3.910    61.121     0.200
     3.910    61.121     0.200
     4.380    64.787     0.200
     4.807    69.707     0.200
     4.922    70.775     0.200
     6.100    90.410     0.200
     6.157    88.148     0.200
     8.351   112.049     0.200
     8.727   116.058     0.200
     9.626   128.964     0.200
     1.184    26.955     0.200
     2.719    45.507     0.200
     2.845    47.732     0.200
     2.896    47.699     0.200
     2.927    47.479     0.200
     3.177    51.359     0.200
     3.200    51.209     0.200
     3.266    52.195     0.200
     3.639    57.128     0.200
     3.808    58.867     0.200
     3.827    58.920     0.200
     3.827    58.920     0.200
     3.886    61.008     0.200
     4.093    62.762     0.200
     4.249    64.052     0.200
     4.336    65.031     0.200
     4.382    65.596     0.200
     4.520    68.287     0.200
     4.799    70.820     0.200
     5.545    79.522     0.200
     5.946    85.038     0.200
     6.118    87.430     0.200
     6.124    90.857     0.200
     6.151    89.848     0.200
     6.268    94.387     0.200
     7.062    96.018     0.200
     7.083    98.173     0.200
     7.478   102.269     0.200
     8.277   110.840     0.200
     8.396   112.151     0.200
     8.394   110.073     0.200
     8.394   110.073     0.200
     8.416   116.108     0.200
     8.695   119.854     0.200
     8.684   122.390     0.200
     8.773   118.350     0.200
     9.226   123.366     0.200
     9.390   125.849     0.200
     9.684   128.119     0.200
     9.751   129.336     0.200
     1.265    25.713     0.200
     1.632    31.836     0.200
     2.828    45.106     0.200
     2.883    45.712     0.200
     3.005    47.560     0.200
     3.035    47.511     0.200
     3.286    51.259     0.200
     3.305    50.794     0.200
     3.374    51.695     0.200
     3.747    57.259     0.200
     3.916    59.005     0.200
     3.936    58.977     0.200
     3.936    58.977     0.200
     4.369    62.018     0.200
     4.405    64.206     0.200
     6.035    88.881     0.200
     6.183    88.847     0.200
     6.262    88.133     0.200
     6.632    97.708     0.200
     7.023    97.550     0.200
     7.505   100.426     0.200
     8.360   111.943     0.200
     8.736   116.253     0.200
     9.630   127.626     0.200
     2.803    46.355     0.200
     2.860    47.512     0.200
     2.978    49.615     0.200
     3.011    48.244     0.200
     3.260    52.452     0.200
     3.284    50.916     0.200
     3.350    52.638     0.200
     3.719    59.012     0.200
     3.892    59.631     0.200
     3.910    60.039     0.200
     3.910    60.039     0.200
     4.279    63.165     0.200
     4.347    65.567     0.200
     4.385    65.929     0.200
     4.811    68.952     0.200
     5.567    83.126     0.200
     6.020    90.042     0.200
     6.102    91.480     0.200
     6.161    91.092     0.200
     6.248    91.681     0.200
     7.484   101.859     0.200
     8.355   111.097     0.200
     8.731   116.004     0.200
     9.630   127.613     0.200
     1.145    25.170     0.200
     1.938    33.895     0.200
     2.530    42.627     0.200
     2.808    45.216     0.200
     2.879    45.816     0.200
     2.985    48.167     0.200
     3.015    47.238     0.200
     3.266    51.429     0.200
     3.285    50.254     0.200
     3.354    51.762     0.200
     3.728    57.544     0.200
     3.896    58.619     0.200
     3.916    59.039     0.200
     3.916    59.039     0.200
     4.366    64.773     0.200
     4.404    64.032     0.200
     4.830    73.553     0.200
     6.181    90.795     0.200
     6.639    96.351     0.200
     7.036    96.212     0.200
     8.370   111.847     0.200
     8.746   115.854     0.200
     9.643   129.096     0.200
     9.722   128.370     0.200
     2.743    44.765     0.200
     2.881    46.151     0.200
     2.924    47.133     0.200
     2.948    47.070     0.200
     3.203    50.377     0.200
     3.217    50.471     0.200
     3.287    51.511     0.200
     3.668    56.221     0.200
     3.830    58.465     0.200
     3.851    58.601     0.200
     3.851    58.601     0.200
     4.372    64.138     0.200
     4.416    65.325     0.200
     7.512   101.191     0.200
     8.415   109.348     0.200
     8.792   115.653     0.200
     9.769   128.351     0.200
     2.881    46.704     0.200
     2.843    47.454     0.200
     3.019    50.573     0.200
     3.051    49.661     0.200
     3.301    53.606     0.200
     3.322    52.473     0.200
     3.389    53.735     0.200
     3.761    59.898     0.200
     3.932    60.893     0.200
     3.951    61.453     0.200
     3.951    61.453     0.200
     4.022    63.158     0.200
     4.042    64.623     0.200
     4.213    64.854     0.200
     4.366    64.663     0.200
     4.400    65.070     0.200
     4.536    68.378     0.200
     4.630    70.181     0.200
     4.680    68.102     0.200
     4.831    70.142     0.200
     4.958    75.158     0.200
     5.180    76.806     0.200
     5.318    76.662     0.200
     5.498    78.454     0.200
     5.591    78.565     0.200
     6.110    88.017     0.200
     6.180    89.393     0.200
     6.253    91.448     0.200
     6.622    95.838     0.200
     6.713    92.376     0.200
     6.915    94.616     0.200
     7.501   101.384     0.200
     7.729   107.241     0.200
     7.978   107.913     0.200
     8.079   110.231     0.200
     8.311   110.131     0.200
     8.348   111.398     0.200
     8.482   115.233     0.200
     8.710   117.568     0.200
     8.724   114.510     0.200
     9.235   122.241     0.200
     9.235   121.843     0.200
     9.315   123.406     0.200
     9.616   127.303     0.200
     9.621   125.643     0.200
     9.680   127.647     0.200
     9.889   131.114     0.200
    19.617   261.982     0.200
     2.856    47.700     0.200
     2.874    46.887     0.200
     3.030    51.258     0.200
     3.064    49.511     0.200
     3.312    53.773     0.200
     3.336    51.737     0.200
     3.402    53.604     0.200
     3.771    60.659     0.200
     3.945    60.616     0.200
     3.963    61.662     0.200
     3.963    61.662     0.200
     4.391    64.980     0.200
     4.823    71.237     0.200
     5.488    78.370     0.200
     5.586    78.536     0.200
     6.015    87.927     0.200
     6.097    90.768     0.200
     6.240    92.698     0.200
     6.608    95.903     0.200
     7.492   102.385     0.200
     8.333   111.478     0.200
     8.708   115.490     0.200
     8.701   119.279     0.200
     9.599   127.696     0.200
     1.066    24.277     0.200
     1.190    26.435     0.200
     2.851    45.840     0.200
     3.025    49.276     0.200
     3.059    48.010     0.200
     3.307    52.270     0.200
     3.331    50.497     0.200
     3.397    52.324     0.200
     3.766    58.887     0.200
     3.828    57.884     0.200
     3.939    59.456     0.200
     3.958    59.893     0.200
     3.958    59.893     0.200
     4.057    61.629     0.200
     4.162    62.692     0.200
     4.300    62.807     0.200
     4.358    64.432     0.200
     4.361    64.896     0.200
     4.391    63.549     0.200
     5.488    76.638     0.200
     6.098    89.022     0.200
     6.172    88.966     0.200
     6.610    94.349     0.200
     6.974    95.100     0.200
     6.995    95.255     0.200
     7.492    99.960     0.200
     8.335   111.216     0.200
     8.711   113.829     0.200
     9.603   126.825     0.200
     1.192    26.847     0.200
     1.651    32.951     0.200
     2.797    46.633     0.200
     2.855    47.353     0.200
     2.972    49.346     0.200
     3.006    49.018     0.200
     3.254    52.523     0.200
     3.279    52.154     0.200
     3.344    53.454     0.200
     3.713    58.502     0.200
     3.886    60.427     0.200
     3.904    60.306     0.200
     3.904    60.306     0.200
     4.171    65.567     0.200
     4.343    65.066     0.200
     4.381    65.621     0.200
     4.446    67.158     0.200
     5.960    84.294     0.200
     6.100    88.759     0.200
     6.103    89.627     0.200
     6.157    86.490     0.200
     6.929    99.984     0.200
     7.007    97.776     0.200
     7.026    96.054     0.200
     7.480   102.256     0.200
     8.286   110.246     0.200
     8.354   111.151     0.200
     8.731   114.856     0.200
     2.877    46.264     0.200
     2.869    46.661     0.200
     3.050    49.303     0.200
     3.087    48.340     0.200
     3.333    52.237     0.200
     3.360    51.177     0.200
     3.424    52.849     0.200
     3.790    58.701     0.200
     3.966    59.633     0.200
     3.984    60.198     0.200
     4.371    66.057     0.200
     4.381    65.237     0.200
     5.478    79.344     0.200
     6.165    86.424     0.200
     6.591    96.657     0.200
     6.947    95.292     0.200
     6.968    96.148     0.200
     7.190    98.460     0.200
     7.483   102.238     0.200
     7.940   107.212     0.200
     8.312   111.065     0.200
     8.688   114.079     0.200
     9.577   127.209     0.200
     1.067    23.902     0.200
     2.885    45.851     0.200
     2.875    45.747     0.200
     3.049    48.517     0.200
     3.082    47.619     0.200
     3.332    52.023     0.200
     3.353    50.409     0.200
     3.421    52.080     0.200
     3.791    58.065     0.200
     3.963    59.122     0.200
     3.982    59.586     0.200
     4.399    63.214     0.200
     4.833    70.250     0.200
     6.182    87.208     0.200
     7.501   100.713     0.200
     2.872    45.309     0.200
     2.818    45.507     0.200
     2.994    48.329     0.200
     3.026    47.614     0.200
     3.276    51.449     0.200
     3.298    50.838     0.200
     3.365    52.157     0.200
     3.736    57.883     0.200
     3.783    57.242     0.200
     3.907    59.094     0.200
     3.926    59.288     0.200
     4.189    64.302     0.200
     4.359    62.525     0.200
     4.395    64.501     0.200
     4.433    66.652     0.200
     4.514    67.215     0.200
     4.934    72.815     0.200
     5.156    73.919     0.200
     5.293    75.264     0.200
     5.929    84.800     0.200
     5.961    80.933     0.200
     6.109    86.993     0.200
     6.111    88.176     0.200
     6.169    84.197     0.200
     6.173    89.454     0.200
     6.214    89.666     0.200
     6.520    85.506     0.200
     6.626    91.662     0.200
     6.643    92.073     0.200
     6.657    94.502     0.200
     6.699    91.413     0.200
     6.902    95.338     0.200
     6.931    97.005     0.200
     7.001    95.893     0.200
     7.022    96.844     0.200
     7.201    97.655     0.200
     7.495   100.529     0.200
     7.717   104.203     0.200
     8.303   109.102     0.200
     8.356   110.171     0.200
     8.468   117.776     0.200
     8.732   113.780     0.200
     8.722   118.499     0.200
     9.232   121.155     0.200
     9.232   120.655     0.200
     9.329   122.815     0.200
     9.628   126.733     0.200
     9.708   128.493     0.200
     9.903   131.716     0.200
     1.076    23.765     0.200
     4.219    64.586     0.200
     4.378    63.434     0.200
     4.401    66.169     0.200
     4.809    69.701     0.200
     6.087    87.786     0.200
     6.159    88.253     0.200
     6.298    87.023     0.200
     6.969    94.200     0.200
     6.990    94.255     0.200
     7.479   102.145     0.200
     8.289   109.987     0.200
     8.327   110.049     0.200
     8.703   113.561     0.200
     9.297   123.028     0.200
     9.597   125.634     0.200
     1.068    24.680     0.200
     1.194    26.108     0.200
     2.845    46.265     0.200
     3.019    48.866     0.200
     3.302    52.087     0.200
     3.326    51.543     0.200
     3.392    52.896     0.200
     3.760    58.127     0.200
     3.934    59.759     0.200
     3.952    59.979     0.200
     4.218    63.384     0.200
     4.353    64.007     0.200
     4.386    63.418     0.200
     4.818    69.487     0.200
     4.878    69.787     0.200
     5.484    78.604     0.200
     5.579    76.800     0.200
     6.013    87.340     0.200
     6.096    88.272     0.200
     6.095    87.380     0.200
     6.167    88.039     0.200
     6.239    91.002     0.200
     6.608    89.794     0.200
     6.608    96.692     0.200
     6.975    94.811     0.200
     6.996    94.966     0.200
     7.265    98.921     0.200
     7.487   100.830     0.200
     7.965   106.154     0.200
     8.298   108.973     0.200
     8.334   109.346     0.200
     8.710   113.658     0.200
     9.221   120.694     0.200
     9.303   122.538     0.200
     9.603   126.241     0.200
     1.073    22.195     0.200
     2.859    47.321     0.200
     2.871    46.087     0.200
     3.032    50.526     0.200
     3.067    49.106     0.200
     3.315    53.346     0.200
     3.340    51.838     0.200
     3.406    53.441     0.200
     3.773    59.919     0.200
     3.948    60.525     0.200
     3.965    61.227     0.200
     4.392    65.103     0.200
     4.355    64.629     0.200
     4.387    64.256     0.200
     4.820    68.708     0.200
     5.000    71.409     0.200
     5.485    78.449     0.200
     5.583    78.001     0.200
     6.010    86.814     0.200
     6.092    88.053     0.200
     6.169    87.464     0.200
     6.236    91.383     0.200
     6.965    95.266     0.200
     6.986    95.422     0.200
     7.488   102.063     0.200
     7.957   106.798     0.200
     8.300   110.291     0.200
     8.328   109.870     0.200
     8.703   114.384     0.200
     6.276    84.341     0.200
     6.322    87.205     0.200
     7.461   101.707     0.200
     8.303   109.084     0.200
     8.541   110.605     0.200
     8.679   112.294     0.200
     1.053    23.327     0.200
     1.431    27.517     0.200
     2.863    45.274     0.200
     4.388    64.817     0.200
     4.814    72.535     0.200
     4.968    70.743     0.200
     5.487    82.579     0.200
     5.571    82.412     0.200
     6.108    89.641     0.200
     6.165    90.878     0.200
     6.251    92.165     0.200
     7.006    96.960     0.200
     7.027    97.020     0.200
     7.487   101.648     0.200
     8.357   111.086     0.200
     8.593   113.642     0.200
     8.734   114.896     0.200
     9.632   126.513     0.200
     2.870    46.038     0.200
     4.392    64.796     0.200
     4.707    69.089     0.200
     4.984    71.279     0.200
     4.943    74.662     0.200
     5.015    73.141     0.200
     7.013    96.101     0.200
     7.198    97.945     0.200
     7.198    98.227     0.200
     7.492   102.317     0.200
     8.300   110.880     0.200
     8.349   111.416     0.200
     8.390   110.837     0.200
     8.586   112.849     0.200
     8.725   115.426     0.200
     9.228   120.755     0.200
     9.228   120.155     0.200
     9.321   123.574     0.200
     9.620   127.183     0.200
     1.435    27.083     0.200
     2.873    46.630     0.200
     2.835    46.838     0.200
     3.010    48.896     0.200
     3.043    49.661     0.200
     3.292    52.472     0.200
     3.314    53.221     0.200
     3.381    53.725     0.200
     3.751    58.012     0.200
     3.827    58.153     0.200
     3.800    58.285     0.200
     3.923    61.084     0.200
     3.942    60.500     0.200
     4.058    62.347     0.200
     4.012    62.738     0.200
     4.297    61.187     0.200
     4.358    64.768     0.200
     4.393    64.865     0.200
     4.417    67.579     0.200
     4.530    68.060     0.200
     4.713    70.288     0.200
     4.823    71.048     0.200
     4.875    69.830     0.200
     4.860    70.595     0.200
     4.950    74.057     0.200
     5.022    73.203     0.200
     5.170    73.838     0.200
     5.294    75.051     0.200
     5.348    73.558     0.200
     5.491    79.046     0.200
     5.583    80.578     0.200
     5.752    80.926     0.200
     5.921    82.935     0.200
     5.950    82.198     0.200
     6.021    87.757     0.200
     6.105    88.086     0.200
     6.104    87.899     0.200
     6.021    85.340     0.200
     6.172    89.496     0.200
     6.092    84.595     0.200
     6.248    91.016     0.200
     6.316    89.821     0.200
     6.361    89.192     0.200
     6.321    89.361     0.200
     6.486    91.236     0.200
     6.618    95.491     0.200
     6.607    96.727     0.200
     6.660    93.807     0.200
     6.704    89.996     0.200
     6.783    94.646     0.200
     6.906    93.440     0.200
     6.988    95.584     0.200
     7.009    96.038     0.200
     7.199    98.025     0.200
     7.493   101.882     0.200
     7.720   104.098     0.200
     7.978   106.231     0.200
     8.040   106.603     0.200
     8.076   111.685     0.200
     8.303   110.136     0.200
     8.346   109.433     0.200
     8.390   111.219     0.200
     8.390   111.219     0.200
     8.472   115.655     0.200
     8.583   111.762     0.200
     8.703   116.458     0.200
     8.722   113.743     0.200
     9.212   125.127     0.200
     9.229   122.232     0.200
     9.229   122.131     0.200
     9.316   122.911     0.200
     9.615   126.116     0.200
     9.681   127.851     0.200
     9.697   125.960     0.200
     9.718   127.018     0.200
     9.890   130.314     0.200
    10.184   135.178     0.200
    10.806   145.126     0.200
    10.916   139.541     0.200
    11.163   142.860     0.200
    18.397   241.835     0.200
     1.009    21.870     0.200
     1.059    24.090     0.200
     1.060    22.982     0.200
     1.419    28.592     0.200
     2.753    45.556     0.200
     2.780    45.925     0.200
     2.810    43.493     0.200
     3.152    50.691     0.200
     3.296    52.411     0.200
     3.319    51.992     0.200
     3.704    55.634     0.200
     4.199    61.853     0.200
     4.309    63.360     0.200
     4.764    66.251     0.200
     5.440    78.360     0.200
     5.520    78.937     0.200
     6.118    87.049     0.200
     6.160    86.360     0.200
     6.852    95.091     0.200
     7.464   103.541     0.200
     7.451   100.397     0.200
     8.666   113.918     0.200
     8.863   117.014     0.200
     9.048   119.265     0.200
    10.028   130.028     0.200
     2.865    46.416     0.200
     2.790    45.645     0.200
     2.966    47.936     0.200
     3.049    49.105     0.200
     3.248    51.713     0.200
     3.269    52.270     0.200
     3.335    52.819     0.200
     3.336    52.501     0.200
     3.464    52.007     0.200
     3.709    57.546     0.200
     3.769    59.752     0.200
     3.878    60.262     0.200
     3.897    58.832     0.200
     3.919    62.103     0.200
     3.989    63.749     0.200
     4.353    64.563     0.200
     4.392    65.076     0.200
     4.487    67.471     0.200
     4.817    67.217     0.200
     4.847    69.566     0.200
     4.817    70.726     0.200
     4.963    70.915     0.200
     4.906    74.486     0.200
     5.265    75.289     0.200
     5.492    78.139     0.200
     5.572    76.814     0.200
     5.893    82.261     0.200
     6.113    86.697     0.200
     6.116    87.261     0.200
     6.168    86.756     0.200
     6.224    90.445     0.200
     6.220    87.046     0.200
     6.259    89.489     0.200
     6.306    89.441     0.200
     6.401    90.531     0.200
     6.635    94.809     0.200
     6.686    91.304     0.200
     6.888    94.452     0.200
     7.019    96.719     0.200
     7.040    95.876     0.200
     7.050    96.559     0.200
     7.197    98.048     0.200
     7.197    98.359     0.200
     7.167    98.292     0.200
     7.316   100.851     0.200
     7.491   101.816     0.200
     7.580    99.779     0.200
     7.706   103.484     0.200
     7.879   106.589     0.200
     8.006   106.603     0.200
     8.093   108.584     0.200
     8.259   112.151     0.200
     8.296   110.016     0.200
     8.369   109.872     0.200
     8.454   114.877     0.200
     8.603   112.732     0.200
     8.704   116.658     0.200
     8.745   115.777     0.200
     9.074   123.446     0.200
     9.231   120.005     0.200
     9.231   120.905     0.200
     9.348   124.548     0.200
     9.645   127.774     0.200
     9.722   126.882     0.200
     0.822    18.982     0.200
     1.177    24.742     0.200
     1.412    27.594     0.200
     1.949    31.564     0.200
     2.560    41.002     0.200
     3.794    54.221     0.200
     3.794    56.166     0.200
     4.138    59.191     0.200
     4.519    62.244     0.200
     5.227    71.770     0.200
     5.873    79.731     0.200
     5.945    81.687     0.200
     5.969    82.324     0.200
     6.078    82.449     0.200
     6.112    83.947     0.200
     6.539    90.167     0.200
     6.569    88.909     0.200
     6.795    90.680     0.200
     7.113    95.559     0.200
     7.134    96.127     0.200
     7.456    98.460     0.200
     8.056   103.864     0.200
     8.346   108.083     0.200
     8.546   112.939     0.200
     8.727   112.133     0.200
     9.437   122.547     0.200
     9.713   125.926     0.200
     9.707   124.193     0.200
     9.825   126.817     0.200
    10.029   130.133     0.200
    10.343   133.863     0.200
     3.262    54.919     0.200
     3.331    55.925     0.200
     3.707    60.735     0.200
     3.874    62.932     0.200
     3.894    62.960     0.200
     4.367    66.114     0.200
     4.470    65.949     0.200
     4.454    67.359     0.200
     4.735    68.924     0.200
     4.831    72.841     0.200
     4.898    73.858     0.200
     4.971    72.303     0.200
     5.507    81.048     0.200
     6.046    90.556     0.200
     6.129    90.498     0.200
     6.182    90.277     0.200
     6.275    93.387     0.200
     6.651    96.407     0.200
     7.211    98.491     0.200
     7.505   102.332     0.200
     8.022   109.006     0.200
     8.385   111.870     0.200
     8.619   115.431     0.200
     8.761   117.574     0.200
     1.036    23.490     0.200
     2.811    44.485     0.200
     4.074    58.105     0.200
     4.239    59.340     0.200
     4.423    64.064     0.200
     4.789    68.448     0.200
     4.948    68.567     0.200
     5.266    73.016     0.200
     5.644    79.407     0.200
     6.060    82.817     0.200
     6.180    84.620     0.200
     6.557    89.158     0.200
     6.625    91.070     0.200
     7.047    94.831     0.200
     7.271    97.219     0.200
     7.582    99.791     0.200
     7.602   100.457     0.200
     7.933   105.996     0.200
     8.513   111.229     0.200
     8.775   115.266     0.200
     8.959   117.519     0.200
     9.158   119.296     0.200
     9.903   126.603     0.200
    10.167   131.526     0.200
    10.148   132.754     0.200
    10.289   131.804     0.200
    10.499   136.545     0.200
    10.817   139.339     0.200
     1.635    32.664     0.200
     2.398    39.077     0.200
     3.792    59.807     0.200
     4.366    65.501     0.200
     4.730    69.886     0.200
     4.792    71.924     0.200
     5.549    81.397     0.200
     6.002    87.201     0.200
     6.085    88.141     0.200
     6.088    88.008     0.200
     6.143    89.566     0.200
     6.231    90.036     0.200
     6.606    94.659     0.200
     7.171    98.765     0.200
     7.465   102.533     0.200
     8.340   108.919     0.200
     8.575   112.383     0.200
     8.717   112.726     0.200
     9.509   122.377     0.200
     9.693   124.227     0.200
     3.045    49.059     0.200
     3.332    53.227     0.200
     3.584    57.250     0.200
     3.550    55.704     0.200
     3.573    56.479     0.200
     3.702    58.074     0.200
     3.823    59.466     0.200
     3.846    59.582     0.200
     3.960    61.480     0.200
     4.393    65.256     0.200
     4.327    65.975     0.200
     4.391    66.653     0.200
     4.447    67.279     0.200
     4.699    69.314     0.200
     5.060    74.970     0.200
     5.115    74.103     0.200
     5.519    81.315     0.200
     5.729    81.870     0.200
     5.959    81.782     0.200
     5.988    85.773     0.200
     6.028    84.181     0.200
     6.144    90.224     0.200
     6.305    90.651     0.200
     6.361    85.892     0.200
     6.378    88.698     0.200
     6.601    94.690     0.200
     6.862    98.943     0.200
     7.235    99.792     0.200
     7.876   108.410     0.200
     8.115   110.419     0.200
     8.168   111.607     0.200
     0.886    19.329     0.200
     1.115    23.749     0.200
     1.234    26.361     0.200
     1.453    28.106     0.200
     1.458    30.147     0.200
     1.614    31.425     0.200
     2.023    34.958     0.200
     2.439    38.604     0.200
     4.732    67.841     0.200
     5.017    70.762     0.200
     5.092    72.241     0.200
     5.765    81.960     0.200
     5.844    81.353     0.200
     6.446    89.843     0.200
     7.651   102.777     0.200
     7.792   105.030     0.200
     8.938   116.861     0.200
     9.318   121.631     0.200
     0.861    19.116     0.200
     0.904    20.406     0.200
     0.959    21.670     0.200
     1.009    21.584     0.200
     1.031    20.728     0.200
     1.011    21.269     0.200
     1.072    22.555     0.200
     1.154    24.392     0.200
     1.196    23.398     0.200
     2.691    42.185     0.200
     2.982    45.759     0.200
     3.091    48.598     0.200
     3.199    51.483     0.200
     3.391    53.540     0.200
     3.597    53.800     0.200
     3.706    57.279     0.200
     4.056    57.828     0.200
     4.191    61.750     0.200
     4.280    62.213     0.200
     4.371    59.790     0.200
     4.429    63.020     0.200
     4.429    63.755     0.200
     4.464    61.948     0.200
     4.564    65.922     0.200
     4.562    62.423     0.200
     4.648    67.981     0.200
     5.330    72.467     0.200
     5.392    78.666     0.200
     6.003    85.234     0.200
     6.003    82.203     0.200
     6.021    87.135     0.200
     6.104    86.537     0.200
     6.130    88.562     0.200
     6.274    89.623     0.200
     6.320    90.161     0.200
     6.386    86.730     0.200
     6.403    89.238     0.200
     6.706    94.822     0.200
     6.706    92.799     0.200
     6.962    92.418     0.200
     6.991    93.880     0.200
     7.049    93.592     0.200
     7.049    94.654     0.200
     7.284    96.458     0.200
     7.304    96.620     0.200
     7.346    96.836     0.200
     8.107   106.957     0.200
     8.139   110.477     0.200
     8.186   105.725     0.200
     8.228   107.641     0.200
     8.517   111.265     0.200
     8.716   113.345     0.200
     8.763   113.096     0.200
     8.899   115.314     0.200
     9.140   118.099     0.200
     9.608   124.441     0.200
     9.879   127.465     0.200
     9.885   127.705     0.200
     9.880   128.719     0.200
     9.974   128.967     0.200
     9.997   128.798     0.200
    10.512   135.682     0.200
     3.059    48.235     0.200
     3.423    54.984     0.200
     3.621    57.574     0.200
     3.666    58.502     0.200
     3.816    56.876     0.200
     3.857    61.525     0.200
     3.894    62.352     0.200
     3.958    61.695     0.200
     3.994    62.634     0.200
     4.061    61.539     0.200
     4.367    67.696     0.200
     4.503    69.118     0.200
     4.536    69.993     0.200
     5.219    77.640     0.200
     5.325    76.367     0.200
     5.402    78.160     0.200
     5.812    84.832     0.200
     5.882    81.892     0.200
     6.014    85.139     0.200
     6.038    83.462     0.200
     6.239    89.886     0.200
     6.295    90.891     0.200
     6.320    91.628     0.200
     6.437    91.893     0.200
     6.554    93.653     0.200
     6.740    97.831     0.200
     7.557   103.169     0.200
     7.847   108.957     0.200
     7.920   107.711     0.200
     1.857    31.984     0.200
     2.817    44.482     0.200
     2.839    46.930     0.200
     2.872    45.386     0.200
     3.014    49.290     0.200
     3.098    50.805     0.200
     3.296    53.098     0.200
     3.319    53.329     0.200
     3.381    54.605     0.200
     3.385    54.148     0.200
     3.385    54.148     0.200
     3.755    58.638     0.200
     3.928    61.421     0.200
     3.946    61.106     0.200
     3.946    61.106     0.200
     4.057    60.916     0.200
     4.057    61.018     0.200
     4.160    61.714     0.200
     4.357    64.515     0.200
     4.391    64.720     0.200
     4.498    65.069     0.200
     4.821    68.284     0.200
     4.867    71.065     0.200
     5.010    71.752     0.200
     5.022    71.459     0.200
     5.320    75.917     0.200
     5.489    77.411     0.200
     5.582    76.079     0.200
     6.119    84.750     0.200
     6.171    87.667     0.200
     6.193    86.083     0.200
     6.202    85.516     0.200
     6.245    88.389     0.200
     6.281    86.927     0.200
     6.281    87.001     0.200
     6.478    92.032     0.200
     6.616    86.949     0.200
     6.906    93.170     0.200
     6.983    91.769     0.200
     7.004    91.922     0.200
     7.068    96.672     0.200
     7.198    98.893     0.200
     7.198    98.377     0.200
     7.273    95.275     0.200
     7.372    99.728     0.200
     7.491   101.332     0.200
     7.973   103.315     0.200
     8.050   104.713     0.200
     8.301   109.781     0.200
     8.308   112.407     0.200
     8.342   107.716     0.200
     8.472   113.486     0.200
     8.579   110.839     0.200
     8.718   112.523     0.200
     9.205   126.235     0.200
     9.311   120.198     0.200
     9.508   122.301     0.200
     9.611   123.701     0.200
     9.693   124.740     0.200
     9.713   124.605     0.200
     9.885   126.800     0.200
     0.707    17.635     0.200
     0.844    18.140     0.200
     0.884    18.677     0.200
     2.575    42.342     0.200
     2.754    41.579     0.200
     3.170    50.296     0.200
     3.190    50.462     0.200
     3.190    50.462     0.200
     4.360    61.609     0.200
     4.362    61.254     0.200
     4.702    67.382     0.200
     4.982    70.648     0.200
     5.361    75.276     0.200
     6.036    84.401     0.200
     6.055    83.831     0.200
     6.136    85.579     0.200
     6.279    87.554     0.200
     6.396    88.864     0.200
     6.470    89.820     0.200
     6.553    88.818     0.200
     6.848    93.608     0.200
     6.940    90.397     0.200
     6.942    91.178     0.200
     7.107    94.346     0.200
     7.165    92.068     0.200
     7.404    98.080     0.200
     7.478    97.317     0.200
     7.499    97.383     0.200
     8.412   108.519     0.200
     8.681   111.281     0.200
     8.869   113.489     0.200
     9.064   115.315     0.200
     9.612   128.622     0.200
     9.800   124.620     0.200
     9.883   127.056     0.200
    10.066   128.222     0.200
    10.186   129.914     0.200
     0.672    15.731     0.200
     0.662    15.554     0.200
     0.695    16.662     0.200
     0.770    17.991     0.200
     0.761    17.100     0.200
     0.764    16.955     0.200
     0.840    19.570     0.200
     1.032    21.830     0.200
     1.045    21.986     0.200
     1.524    26.792     0.200
     2.339    37.981     0.200
     2.576    40.809     0.200
     2.569    41.299     0.200
     2.748    43.104     0.200
     2.779    43.644     0.200
     2.826    44.196     0.200
     2.863    44.564     0.200
     2.863    44.564     0.200
     2.965    45.574     0.200
     3.197    47.266     0.200
     3.331    50.105     0.200
     3.409    51.598     0.200
     3.455    51.556     0.200
     3.455    51.556     0.200
     3.923    57.732     0.200
     4.199    59.498     0.200
     4.344    62.176     0.200
     4.669    70.186     0.200
     5.038    67.688     0.200
     5.056    71.751     0.200
     5.165    74.399     0.200
     5.311    76.183     0.200
     5.800    83.324     0.200
     6.419    89.052     0.200
     6.410    87.263     0.200
     6.472    85.053     0.200
     6.502    91.111     0.200
     6.530    90.324     0.200
     6.542    90.830     0.200
     6.691    91.594     0.200
     6.710    94.470     0.200
     6.909    97.255     0.200
     6.982    91.391     0.200
     7.085    96.941     0.200
     7.092    99.513     0.200
     7.226    94.149     0.200
     7.344    98.467     0.200
     7.457    99.249     0.200
     7.457    99.796     0.200
     7.577    98.859     0.200
     7.597    99.118     0.200
     7.754   104.091     0.200
     7.885   101.958     0.200
     7.873   104.905     0.200
     8.105   102.993     0.200
     8.546   109.943     0.200
     8.554   116.157     0.200
     8.559   112.891     0.200
     8.779   109.424     0.200
     8.870   114.262     0.200
     9.083   117.083     0.200
     9.250   118.532     0.200
     9.904   126.999     0.200
     9.925   127.046     0.200
    10.054   128.543     0.200
    10.191   130.445     0.200
    10.232   130.569     0.200
    10.269   131.030     0.200
    10.301   131.468     0.200
    10.485   133.918     0.200
    10.786   137.704     0.200
    11.415   144.958     0.200
    11.672   148.062     0.200
     0.649    14.600     0.200
     0.772    17.462     0.200
     0.755    16.862     0.200
     0.758    17.029     0.200
     0.844    19.719     0.200
     0.925    20.778     0.200
     0.941    20.787     0.200
     0.953    20.055     0.200
     1.028    21.677     0.200
     1.039    21.851     0.200
     2.863    44.157     0.200
     3.653    56.040     0.200
     4.205    59.420     0.200
     5.041    67.444     0.200
     6.425    89.978     0.200
     6.416    88.823     0.200
     6.476    85.197     0.200
     6.986    91.142     0.200
     7.231    94.491     0.200
     7.582    98.998     0.200
     7.602    99.257     0.200
     7.760   104.213     0.200
     7.796   101.090     0.200
     7.890   102.496     0.200
     8.552   110.680     0.200
     8.876   114.690     0.200
     9.089   117.411     0.200
     9.256   119.362     0.200
     9.909   127.134     0.200
    10.196   130.781     0.200
    10.275   131.571     0.200
    11.421   145.782     0.200
     1.223    24.960     0.200
     1.398    27.923     0.200
     2.929    46.091     0.200
     2.998    49.150     0.200
     3.077    50.222     0.200
     3.148    51.099     0.200
     3.236    52.272     0.200
     3.273    52.542     0.200
     3.278    52.476     0.200
     3.296    52.773     0.200
     3.365    53.763     0.200
     3.365    53.763     0.200
     3.366    53.848     0.200
     3.740    57.884     0.200
     3.907    60.634     0.200
     3.927    60.799     0.200
     3.927    60.799     0.200
     3.964    59.430     0.200
     5.030    73.199     0.200
     5.343    77.416     0.200
     5.509    80.150     0.200
     5.596    80.590     0.200
     6.107    87.902     0.200
     6.125    88.797     0.200
     6.188    87.103     0.200
     6.270    89.716     0.200
     6.294    88.907     0.200
     6.503    92.472     0.200
     6.641    93.472     0.200
     7.510   101.192     0.200
     8.002   107.541     0.200
     8.370   111.657     0.200
     8.607   113.288     0.200
     8.746   114.963     0.200
     9.426   124.628     0.200
     9.537   124.939     0.200
     9.640   128.730     0.200
     9.872   132.126     0.200
     1.985    30.749     0.200
     2.664    42.928     0.200
     2.710    42.767     0.200
     3.215    51.421     0.200
     3.296    53.272     0.200
     3.474    55.591     0.200
     3.488    55.531     0.200
     3.488    55.531     0.200
     3.627    54.017     0.200
     3.737    53.046     0.200
     4.126    60.750     0.200
     4.141    60.498     0.200
     4.428    62.998     0.200
     4.549    66.133     0.200
     4.786    66.184     0.200
     4.761    69.825     0.200
     4.913    71.208     0.200
     5.285    75.558     0.200
     5.400    76.722     0.200
     6.012    86.679     0.200
     6.060    86.017     0.200
     6.125    88.562     0.200
     6.166    83.084     0.200
     6.260    90.487     0.200
     6.502    92.460     0.200
     6.682    92.361     0.200
     6.895    91.870     0.200
     7.067    93.961     0.200
     7.052    96.345     0.200
     7.225    96.227     0.200
     7.245    95.989     0.200
     7.363    98.108     0.200
     7.480    99.731     0.200
     8.133   106.822     0.200
     8.177   107.516     0.200
     8.479   111.084     0.200
     8.685   113.488     0.200
     8.860   115.543     0.200
     9.534   123.878     0.200
     9.550   123.994     0.200
     9.670   125.692     0.200
     9.826   127.868     0.200
     2.701    43.272     0.200
     2.810    46.501     0.200
     2.817    46.711     0.200
     2.817    46.711     0.200
     3.099    50.526     0.200
     3.183    51.143     0.200
     3.358    54.102     0.200
     3.372    53.938     0.200
     3.372    53.938     0.200
     3.603    54.537     0.200
     3.677    55.639     0.200
     3.802    56.713     0.200
     3.929    58.337     0.200
     4.657    69.809     0.200
     4.915    74.308     0.200
     4.893    67.687     0.200
     5.303    76.790     0.200
     6.012    86.860     0.200
     6.027    86.786     0.200
     6.036    86.869     0.200
     6.119    89.155     0.200
     6.161    88.955     0.200
     6.261    83.916     0.200
     6.289    90.835     0.200
     6.533    94.469     0.200
     6.723    97.531     0.200
     6.749    90.631     0.200
     6.808    90.743     0.200
     7.305    97.738     0.200
     7.325    98.501     0.200
     7.355    97.954     0.200
     8.249   109.527     0.200
     8.536   112.769     0.200
     8.734   116.061     0.200
     8.918   117.817     0.200
     9.590   125.671     0.200
     9.629   126.021     0.200
     9.732   127.917     0.200
     9.900   128.955     0.200
     9.995   130.150     0.200
    10.221   132.015     0.200
     1.351    27.921     0.200
     1.342    27.370     0.200
     1.656    32.603     0.200
     1.638    33.077     0.200
     2.426    40.539     0.200
     2.648    42.819     0.200
     2.956    47.827     0.200
     3.003    49.799     0.200
     3.443    54.148     0.200
     3.443    54.248     0.200
     3.443    53.718     0.200
     3.698    58.167     0.200
     3.698    55.807     0.200
     3.780    62.216     0.200
     3.922    63.459     0.200
     3.922    58.179     0.200
     3.925    63.223     0.200
     3.988    64.487     0.200
     4.043    65.250     0.200
     4.328    67.280     0.200
     4.407    68.171     0.200
     4.611    68.046     0.200
     4.659    69.555     0.200
     4.623    69.827     0.200
     4.718    68.226     0.200
     4.740    69.499     0.200
     4.808    70.143     0.200
     4.873    72.140     0.200
     4.870    72.285     0.200
     4.922    73.711     0.200
     5.184    75.285     0.200
     5.456    81.125     0.200
     5.497    82.330     0.200
     5.453    80.248     0.200
     5.532    82.461     0.200
     5.840    84.893     0.200
     5.826    83.539     0.200
     6.011    87.816     0.200
     6.045    86.593     0.200
     6.175    85.465     0.200
     6.535    95.345     0.200
     6.603    90.269     0.200
     6.587    96.811     0.200
     6.632    94.832     0.200
     6.669    93.474     0.200
     6.692    96.286     0.200
     6.688    95.832     0.200
     6.757    98.255     0.200
     6.723    95.894     0.200
     6.977    94.905     0.200
     6.999   100.171     0.200
     6.988    99.684     0.200
     7.112   101.857     0.200
     7.379   100.320     0.200
     7.400   100.670     0.200
     7.379    99.614     0.200
     7.471   101.938     0.200
     7.540   104.539     0.200
     7.588   106.841     0.200
     7.629   103.792     0.200
     7.709   105.802     0.200
     7.717   104.766     0.200
     7.717   104.766     0.200
     7.813   106.648     0.200
     7.947   109.786     0.200
     8.011   108.834     0.200
     8.210   110.115     0.200
     8.210   111.419     0.200
     8.386   112.858     0.200
     8.397   112.335     0.200
     8.685   115.974     0.200
     8.807   117.355     0.200
     8.786   122.094     0.200
     8.962   121.383     0.200
     9.060   119.996     0.200
     9.224   124.188     0.200
     9.706   128.564     0.200
     9.772   127.680     0.200
     9.958   131.419     0.200
    10.024   132.850     0.200
    10.149   134.285     0.200
    10.221   140.648     0.200
    18.428   243.873     0.200
     1.855    39.360     0.200
     2.662    41.609     0.200
     3.184    53.547     0.200
     3.391    53.299     0.200
     3.408    54.129     0.200
     3.385    56.508     0.200
     3.432    57.058     0.200
     3.457    56.971     0.200
     3.573    58.616     0.200
     3.794    62.036     0.200
     3.934    61.601     0.200
     3.939    62.842     0.200
     4.002    63.809     0.200
     4.057    64.971     0.200
     4.148    66.007     0.200
     4.254    66.763     0.200
     4.337    65.892     0.200
     4.426    66.089     0.200
     4.418    64.579     0.200
     4.651    66.434     0.200
     5.190    75.421     0.200
     5.344    77.979     0.200
     5.466    81.585     0.200
     5.506    82.798     0.200
     5.538    79.856     0.200
     5.845    85.138     0.200
     6.017    86.424     0.200
     6.092    86.507     0.200
     6.169    84.721     0.200
     6.539    94.044     0.200
     6.596    90.036     0.200
     6.624    90.105     0.200
     6.589    97.674     0.200
     6.582    90.702     0.200
     6.693    95.630     0.200
     6.695    94.936     0.200
     6.760    96.835     0.200
     6.787    94.507     0.200
     6.972    94.248     0.200
     6.990   100.443     0.200
     7.114   102.715     0.200
     7.396   100.398     0.200
     7.464   100.102     0.200
     7.624   102.938     0.200
     7.724   104.085     0.200
     8.018   109.338     0.200
     8.394   112.151     0.200
     8.806   117.946     0.200
     9.777   132.142     0.200
     1.428    30.637     0.200
     1.748    32.298     0.200
     3.404    53.170     0.200
     3.394    56.195     0.200
     3.441    57.044     0.200
     3.464    54.871     0.200
     3.464    57.172     0.200
     3.583    58.990     0.200
     3.802    61.926     0.200
     3.949    63.618     0.200
     4.009    63.911     0.200
     4.065    64.763     0.200
     4.159    63.467     0.200
     4.349    65.982     0.200
     4.438    66.167     0.200
     4.652    65.108     0.200
     4.776    71.703     0.200
     4.756    68.855     0.200
     5.518    82.341     0.200
     5.856    85.174     0.200
     6.598    88.898     0.200
     6.626    89.473     0.200
     6.702    96.404     0.200
     6.708    96.838     0.200
     6.800    96.547     0.200
     7.467   100.061     0.200
     7.737   105.291     0.200
     7.838   105.835     0.200
     8.031   109.684     0.200
     8.814   116.041     0.200
     9.069   118.964     0.200
    10.027   131.091     0.200
    10.118   131.919     0.200
     1.750    34.870     0.200
     2.285    38.715     0.200
     2.288    38.838     0.200
     2.819    45.280     0.200
     2.839    47.147     0.200
     3.016    49.182     0.200
     3.097    50.239     0.200
     3.167    51.116     0.200
     3.255    52.399     0.200
     3.293    53.154     0.200
     3.297    52.401     0.200
     3.316    53.082     0.200
     3.385    52.979     0.200
     3.385    53.780     0.200
     3.384    53.885     0.200
     3.674    57.401     0.200
     3.758    58.619     0.200
     3.841    57.973     0.200
     3.927    60.648     0.200
     3.947    61.022     0.200
     4.021    61.858     0.200
     4.125    60.032     0.200
     4.258    63.083     0.200
     4.366    65.124     0.200
     4.503    66.527     0.200
     4.706    70.655     0.200
     5.005    72.691     0.200
     5.027    73.201     0.200
     5.020    74.097     0.200
     5.310    77.874     0.200
     5.506    80.774     0.200
     5.641    83.043     0.200
     6.036    86.407     0.200
     6.098    88.463     0.200
     6.119    86.032     0.200
     6.118    87.659     0.200
     6.188    86.983     0.200
     6.218    87.475     0.200
     6.262    90.181     0.200
     6.297    87.368     0.200
     6.495    93.782     0.200
     6.631    94.302     0.200
     7.215    98.508     0.200
     7.508   101.853     0.200
     2.312    38.961     0.200
     2.633    41.897     0.200
     2.635    43.230     0.200
     2.678    43.257     0.200
     2.823    43.652     0.200
     2.882    46.512     0.200
     2.976    49.077     0.200
     3.024    49.661     0.200
     3.182    48.342     0.200
     3.181    50.203     0.200
     3.185    51.353     0.200
     3.383    53.642     0.200
     3.430    54.494     0.200
     3.549    52.681     0.200
     3.514    55.113     0.200
     3.611    56.979     0.200
     3.617    56.821     0.200
     3.625    56.723     0.200
     3.656    56.765     0.200
     3.722    56.989     0.200
     3.722    57.790     0.200
     3.757    57.880     0.200
     3.922    62.560     0.200
     4.029    62.013     0.200
     4.064    63.806     0.200
     4.148    63.503     0.200
     4.164    62.802     0.200
     4.130    62.832     0.200
     4.235    64.205     0.200
     4.261    64.504     0.200
     4.267    64.832     0.200
     4.295    66.257     0.200
     4.298    64.763     0.200
     4.348    68.518     0.200
     4.438    64.127     0.200
     4.490    66.829     0.200
     4.495    67.271     0.200
     4.495    69.740     0.200
     4.649    68.754     0.200
     4.738    69.439     0.200
     5.114    74.195     0.200
     5.268    78.230     0.200
     5.261    75.333     0.200
     5.299    78.742     0.200
     5.742    80.013     0.200
     5.905    85.895     0.200
     6.173    84.287     0.200
     6.204    86.328     0.200
     6.209    90.511     0.200
     6.233    91.100     0.200
     6.276    91.982     0.200
     6.291    91.933     0.200
     6.418    95.167     0.200
     6.457    93.442     0.200
     6.545    89.743     0.200
     6.558    91.446     0.200
     6.609    95.454     0.200
     6.643    96.102     0.200
     6.745    96.954     0.200
     6.951    94.807     0.200
     6.973    95.455     0.200
     7.040    95.467     0.200
     7.055    94.791     0.200
     7.197    97.538     0.200
     7.220    97.730     0.200
     7.423   102.301     0.200
     7.471   101.816     0.200
     7.746   107.034     0.200
     7.763   106.036     0.200
     7.880   111.361     0.200
     7.954   105.709     0.200
     7.977   107.839     0.200
     8.055   107.485     0.200
     8.255   110.688     0.200
     8.406   112.826     0.200
     8.524   115.748     0.200
     8.672   116.421     0.200
     8.777   116.194     0.200
     9.274   123.005     0.200
     9.277   123.859     0.200
     9.462   125.507     0.200
     9.548   127.102     0.200
     9.600   127.999     0.200
     9.641   127.316     0.200
     9.690   127.845     0.200
     9.743   128.727     0.200
     9.834   130.357     0.200
    10.112   134.023     0.200
    10.208   135.701     0.200
    10.204   135.894     0.200
    10.303   135.587     0.200
    10.607   140.141     0.200
    10.633   138.841     0.200
    10.757   150.394     0.200
    11.001   144.148     0.200
    11.236   146.697     0.200
    11.757   153.923     0.200
    11.721   161.137     0.200
    12.574   164.984     0.200
    12.865   166.393     0.200
    12.908   167.988     0.200
    13.877   179.785     0.200
    14.127   182.457     0.200
    14.350   187.264     0.200
    15.786   210.707     0.200
    15.841   212.066     0.200
    20.867   274.602     0.200
     1.027    23.116     0.200
     1.132    24.896     0.200
     2.317    39.309     0.200
     2.428    39.458     0.200
     2.640    41.436     0.200
     2.642    43.328     0.200
     2.682    43.216     0.200
     2.826    46.102     0.200
     2.982    48.986     0.200
     3.027    47.128     0.200
     3.189    50.043     0.200
     3.187    50.514     0.200
     3.386    52.892     0.200
     3.432    53.356     0.200
     3.516    54.371     0.200
     3.556    52.143     0.200
     3.614    55.640     0.200
     3.618    55.991     0.200
     3.626    55.797     0.200
     3.658    56.124     0.200
     3.724    56.858     0.200
     3.760    57.627     0.200
     4.031    60.671     0.200
     4.133    61.880     0.200
     4.237    64.158     0.200
     4.289    65.094     0.200
     4.268    64.196     0.200
     4.301    64.524     0.200
     4.648    67.999     0.200
     5.275    77.923     0.200
     6.176    83.534     0.200
     6.207    86.379     0.200
     6.216    91.268     0.200
     6.239    91.656     0.200
     6.463    92.517     0.200
     6.616    96.152     0.200
     6.649    96.943     0.200
     6.956    94.833     0.200
     7.478   102.579     0.200
     7.752   106.747     0.200
     7.769   107.143     0.200
     7.982   105.564     0.200
     8.412   111.238     0.200
     8.678   114.436     0.200
     9.695   126.370     0.200
     2.639    42.578     0.200
     2.646    44.252     0.200
     2.845    45.218     0.200
     2.989    48.354     0.200
     3.047    48.574     0.200
     3.186    50.730     0.200
     3.746    55.687     0.200
     3.746    56.015     0.200
     4.424    63.866     0.200
     4.760    69.151     0.200
     5.263    74.177     0.200
     6.243    86.733     0.200
     6.362    87.849     0.200
     7.471   100.023     0.200
     1.161    24.767     0.200
     2.435    38.518     0.200
     2.640    42.499     0.200
     2.648    43.213     0.200
     2.992    48.156     0.200
     3.054    47.256     0.200
     3.210    48.758     0.200
     3.216    51.396     0.200
     3.286    52.525     0.200
     3.412    54.002     0.200
     3.461    54.532     0.200
     3.544    55.957     0.200
     3.641    57.228     0.200
     3.648    56.956     0.200
     3.656    57.152     0.200
     3.685    57.316     0.200
     3.753    56.731     0.200
     3.753    58.630     0.200
     3.785    59.146     0.200
     3.918    59.203     0.200
     3.952    58.196     0.200
     4.058    62.256     0.200
     4.096    60.924     0.200
     4.158    62.998     0.200
     4.297    65.274     0.200
     4.328    65.512     0.200
     4.430    65.329     0.200
     4.519    66.381     0.200
     4.766    67.905     0.200
     5.117    76.114     0.200
     5.267    77.088     0.200
     5.303    78.237     0.200
     5.528    80.220     0.200
     5.707    81.757     0.200
     5.911    85.367     0.200
     6.046    88.847     0.200
     6.201    90.077     0.200
     6.222    90.383     0.200
     6.250    86.586     0.200
     6.267    92.517     0.200
     6.283    91.687     0.200
     6.369    87.496     0.200
     6.409    93.965     0.200
     6.458    93.345     0.200
     6.633    96.924     0.200
     6.732    98.261     0.200
     7.012    92.383     0.200
     7.762   105.031     0.200
     7.759   103.268     0.200
     8.389   107.923     0.200
     8.657   112.399     0.200
     1.788    31.020     0.200
     2.391    40.071     0.200
     2.694    43.383     0.200
     2.791    43.059     0.200
     3.030    48.736     0.200
     3.225    48.211     0.200
     3.214    50.592     0.200
     3.187    50.846     0.200
     3.283    49.846     0.200
     3.293    51.242     0.200
     3.430    54.014     0.200
     3.516    55.108     0.200
     3.583    54.742     0.200
     3.615    56.053     0.200
     3.615    56.260     0.200
     3.621    56.688     0.200
     3.660    57.333     0.200
     3.722    57.165     0.200
     3.722    57.505     0.200
     3.924    59.802     0.200
     4.137    63.163     0.200
     4.180    62.522     0.200
     4.255    62.583     0.200
     4.267    64.547     0.200
     4.301    65.050     0.200
     4.492    66.656     0.200
     4.896    67.131     0.200
     5.062    75.575     0.200
     5.115    72.602     0.200
     5.245    76.033     0.200
     5.331    78.947     0.200
     5.768    80.535     0.200
     6.196    84.635     0.200
     6.226    85.286     0.200
     6.244    91.394     0.200
     6.311    91.749     0.200
     6.350    90.632     0.200
     6.304    87.425     0.200
     6.490    91.445     0.200
     6.490    91.922     0.200
     6.572    89.542     0.200
     6.621    92.042     0.200
     6.980    94.782     0.200
     7.002    94.929     0.200
     7.064    96.408     0.200
     7.224    97.138     0.200
     7.288    97.488     0.200
     7.700   109.686     0.200
     7.772   105.538     0.200
     7.796   105.357     0.200
     7.819   106.193     0.200
     7.830   110.766     0.200
     7.979   106.824     0.200
     8.007   106.896     0.200
     8.086   107.978     0.200
     8.278   110.638     0.200
     8.439   112.258     0.200
     8.603   118.841     0.200
     8.706   115.444     0.200
     8.686   118.077     0.200
     8.810   116.528     0.200
     8.743   118.905     0.200
     9.133   130.362     0.200
     9.293   122.890     0.200
    10.002   133.719     0.200
     3.029    48.183     0.200
     3.188    50.871     0.200
     3.431    53.932     0.200
     3.517    55.734     0.200
     3.615    56.383     0.200
     3.616    56.772     0.200
     3.623    56.993     0.200
     3.660    57.167     0.200
     3.723    57.924     0.200
     4.136    62.905     0.200
     4.171    62.034     0.200
     4.249    63.592     0.200
     4.268    64.967     0.200
     4.301    65.577     0.200
     5.760    81.659     0.200
     5.765    83.550     0.200
     6.219    86.401     0.200
     6.340    90.771     0.200
     6.481    93.210     0.200
     6.564    90.972     0.200
     6.971    97.618     0.200
     6.993    98.466     0.200
     7.216   100.367     0.200
     7.280    97.710     0.200
     7.280    98.111     0.200
     7.765   106.850     0.200
     7.787   105.499     0.200
     7.971   109.049     0.200
    10.185   133.292     0.200
     4.852    67.297     0.200
     7.963   106.584     0.200
     8.890   116.769     0.200
     9.266   121.284     0.200
     2.726    44.815     0.200
     2.726    45.917     0.200
     2.905    46.727     0.200
     2.905    48.227     0.200
     2.984    49.504     0.200
     3.054    50.182     0.200
     3.142    51.759     0.200
     3.185    50.459     0.200
     3.185    52.158     0.200
     3.204    51.236     0.200
     3.204    51.837     0.200
     3.274    52.815     0.200
     3.271    53.050     0.200
     3.648    58.056     0.200
     3.648    57.857     0.200
     3.771    59.223     0.200
     3.804    59.216     0.200
     3.814    59.919     0.200
     3.834    60.386     0.200
     3.881    61.782     0.200
     3.904    58.942     0.200
     3.967    57.057     0.200
     4.034    60.003     0.200
     4.098    60.787     0.200
     4.383    65.074     0.200
     4.676    70.047     0.200
     4.717    69.780     0.200
     4.814    72.209     0.200
     4.840    73.340     0.200
     4.933    72.759     0.200
     4.973    72.105     0.200
     5.017    73.793     0.200
     5.343    78.924     0.200
     5.327    78.059     0.200
     5.498    79.560     0.200
     5.560    78.298     0.200
     5.560    78.552     0.200
     5.642    81.381     0.200
     5.879    84.920     0.200
     6.123    88.409     0.200
     6.131    88.484     0.200
     6.137    86.931     0.200
     6.166    87.140     0.200
     6.166    87.496     0.200
     6.254    91.481     0.200
     6.187    87.920     0.200
     6.256    88.041     0.200
     6.280    92.512     0.200
     6.515    94.389     0.200
     6.530    93.027     0.200
     6.555    92.228     0.200
     6.662    96.660     0.200
     6.665    90.940     0.200
     6.866    92.994     0.200
     7.197    98.636     0.200
     7.197    99.057     0.200
     7.270    93.389     0.200
     7.289   100.160     0.200
     7.319   101.113     0.200
     7.367    96.049     0.200
     7.426   101.158     0.200
     7.492   101.996     0.200
     7.585   103.285     0.200
     7.690   103.080     0.200
     7.690   103.986     0.200
     8.012   107.522     0.200
     8.089   105.126     0.200
     8.123   112.531     0.200
     8.271   112.899     0.200
     8.291   111.165     0.200
     8.406   109.030     0.200
     8.636   113.638     0.200
     8.641   124.182     0.200
     8.783   114.027     0.200
     9.462   121.205     0.200
     9.692   124.825     0.200
     9.702   132.404     0.200
     9.762   124.805     0.200
     9.797   126.796     0.200
     9.798   124.578     0.200
    10.069   132.816     0.200
    10.415   131.878     0.200
    10.415   131.682     0.200
    10.969   138.714     0.200
    11.219   142.399     0.200
    19.526   258.751     0.200
     0.834    18.877     0.200
     0.944    20.754     0.200
     0.939    20.684     0.200
     0.947    20.688     0.200
     1.016    22.724     0.200
     0.993    21.312     0.200
     1.014    21.406     0.200
     1.626    28.799     0.200
     1.899    31.246     0.200
     1.955    33.635     0.200
     2.059    34.401     0.200
     2.114    35.109     0.200
     2.168    35.681     0.200
     2.235    36.111     0.200
     2.366    37.416     0.200
     3.269    52.947     0.200
     3.364    54.042     0.200
     3.519    56.134     0.200
     3.541    56.379     0.200
     3.977    58.600     0.200
     4.163    60.533     0.200
     4.435    63.446     0.200
     4.777    69.393     0.200
     4.789    65.311     0.200
     4.916    68.514     0.200
     5.016    70.925     0.200
     5.382    76.659     0.200
     5.485    76.171     0.200
     5.503    78.789     0.200
     6.105    86.950     0.200
     6.132    84.963     0.200
     6.172    88.151     0.200
     6.188    87.474     0.200
     6.206    87.657     0.200
     6.211    87.882     0.200
     6.350    91.272     0.200
     6.369    90.526     0.200
     6.591    93.967     0.200
     6.719    90.794     0.200
     6.745    92.385     0.200
     6.764    93.579     0.200
     6.931    93.216     0.200
     7.092    94.837     0.200
     7.174    96.181     0.200
     7.162    96.017     0.200
     7.271    97.656     0.200
     7.291    97.315     0.200
     7.470    99.630     0.200
     7.517   100.084     0.200
     7.591    99.716     0.200
     8.232   108.832     0.200
     8.549   112.235     0.200
     8.761   115.465     0.200
     8.929   116.401     0.200
     9.597   124.605     0.200
     9.604   125.520     0.200
     9.735   126.699     0.200
     9.879   128.612     0.200
     9.876   128.951     0.200
     9.963   130.137     0.200
     9.991   130.406     0.200
    10.182   132.279     0.200
     1.257    25.257     0.200
     1.407    27.670     0.200
     1.481    28.920     0.200
     1.488    29.732     0.200
     4.383    65.516     0.200
     4.760    70.172     0.200
     4.899    72.494     0.200
     5.000    75.404     0.200
     5.366    76.682     0.200
     5.467    80.532     0.200
     5.486    80.579     0.200
     6.090    87.948     0.200
     6.115    89.343     0.200
     6.186    85.194     0.200
     7.512    99.010     0.200
     8.223   109.119     0.200
     8.538   111.348     0.200
     8.748   115.787     0.200
     8.917   115.914     0.200
     9.870   128.298     0.200
     1.989    33.634     0.200
     2.199    36.329     0.200
     2.431    40.362     0.200
     2.483    39.753     0.200
     2.705    42.898     0.200
     3.056    47.191     0.200
     3.245    48.974     0.200
     4.300    62.653     0.200
     5.084    73.039     0.200
     5.121    72.402     0.200
     5.127    72.632     0.200
     5.215    74.004     0.200
     5.251    73.882     0.200
     5.280    74.342     0.200
     5.443    76.545     0.200
     5.692    81.337     0.200
     5.825    82.587     0.200
     6.003    84.607     0.200
     6.138    86.631     0.200
     6.138    86.537     0.200
     6.426    87.588     0.200
     7.394    96.990     0.200
     7.498   101.367     0.200
     7.688   103.738     0.200
     9.942   130.076     0.200
     2.075    36.858     0.200
     2.240    36.922     0.200
     2.455    40.304     0.200
     2.471    40.670     0.200
     2.632    43.603     0.200
     2.684    43.570     0.200
     2.785    45.018     0.200
     2.997    49.637     0.200
     3.028    48.049     0.200
     3.010    49.900     0.200
     3.099    48.155     0.200
     3.212    50.355     0.200
     3.197    52.304     0.200
     3.261    53.059     0.200
     3.338    54.157     0.200
     3.415    52.949     0.200
     3.429    52.712     0.200
     3.431    55.284     0.200
     3.452    55.533     0.200
     3.468    55.553     0.200
     3.474    55.879     0.200
     3.515    53.726     0.200
     3.551    56.482     0.200
     3.551    56.881     0.200
     3.568    57.075     0.200
     3.708    59.046     0.200
     3.787    57.241     0.200
     3.849    60.604     0.200
     3.929    61.469     0.200
     3.929    61.172     0.200
     3.942    61.617     0.200
     4.119    60.569     0.200
     4.095    63.738     0.200
     4.120    64.032     0.200
     4.353    64.503     0.200
     4.397    64.763     0.200
     4.471    65.287     0.200
     4.502    67.271     0.200
     4.550    68.326     0.200
     4.729    68.226     0.200
     4.775    69.317     0.200
     4.970    74.692     0.200
     4.970    74.544     0.200
     5.052    74.467     0.200
     5.082    74.916     0.200
     5.141    75.648     0.200
     5.146    76.037     0.200
     5.190    72.144     0.200
     5.222    75.082     0.200
     5.429    80.042     0.200
     5.496    79.192     0.200
     5.617    82.246     0.200
     5.617    82.512     0.200
     5.746    82.476     0.200
     5.915    83.499     0.200
     6.037    84.465     0.200
     6.116    90.094     0.200
     6.159    90.724     0.200
     6.191    89.642     0.200
     6.184    89.639     0.200
     6.163    87.097     0.200
     6.198    90.458     0.200
     6.261    89.726     0.200
     6.281    91.223     0.200
     6.317    90.685     0.200
     6.317    90.935     0.200
     6.334    93.264     0.200
     6.448    92.635     0.200
     6.460    90.530     0.200
     6.562    94.838     0.200
     6.682    95.488     0.200
     6.773    96.984     0.200
     6.797    95.105     0.200
     6.941    97.724     0.200
     6.990    98.545     0.200
     7.085    99.035     0.200
     7.126   105.360     0.200
     7.248   101.333     0.200
     7.286   100.397     0.200
     7.337   101.702     0.200
     7.337   102.045     0.200
     7.562   105.179     0.200
     7.624   105.141     0.200
     7.630   105.277     0.200
     8.377   114.067     0.200
     8.452   113.485     0.200
     8.629   116.625     0.200
     8.667   117.468     0.200
     8.750   117.909     0.200
     9.433   126.038     0.200
     9.608   129.993     0.200
     9.661   130.779     0.200
     9.721   130.276     0.200
     9.762   129.598     0.200
     9.786   131.326     0.200
     9.862   132.830     0.200
    11.201   148.811     0.200
     2.263    37.708     0.200
     2.478    40.218     0.200
     2.490    40.158     0.200
     2.660    44.211     0.200
     2.712    44.396     0.200
     2.811    43.896     0.200
     3.121    47.986     0.200
     3.229    48.617     0.200
     3.441    52.331     0.200
     3.435    52.254     0.200
     3.529    53.046     0.200
     3.578    55.170     0.200
     4.139    59.966     0.200
     4.333    62.156     0.200
     4.376    64.708     0.200
     4.492    64.950     0.200
     4.578    64.702     0.200
     4.986    73.497     0.200
     5.155    74.971     0.200
     5.164    75.613     0.200
     5.439    79.626     0.200
     5.765    83.335     0.200
     5.784    78.523     0.200
     6.124    90.012     0.200
     6.164    88.958     0.200
     6.197    89.380     0.200
     6.206    90.119     0.200
     6.190    85.280     0.200
     6.265    83.617     0.200
     6.263    88.563     0.200
     6.332    90.247     0.200
     6.340    91.643     0.200
     6.467    92.231     0.200
     6.486    90.726     0.200
     6.571    87.645     0.200
     6.568    94.630     0.200
     6.960    92.500     0.200
     7.301   100.019     0.200
     7.352    98.026     0.200
     7.585   106.308     0.200
     7.644   104.916     0.200
     8.375   111.391     0.200
     8.629   113.222     0.200
     8.748   115.035     0.200
     2.120    36.339     0.200
     2.242    37.464     0.200
     2.457    41.026     0.200
     2.472    39.825     0.200
     2.639    43.233     0.200
     2.690    45.171     0.200
     2.789    45.935     0.200
     3.028    47.248     0.200
     3.212    50.054     0.200
     3.427    50.928     0.200
     3.416    52.898     0.200
     3.513    52.538     0.200
     3.787    56.692     0.200
     3.937    61.303     0.200
     4.120    61.280     0.200
     4.216    63.051     0.200
     4.315    61.591     0.200
     4.355    64.558     0.200
     4.557    66.073     0.200
     4.698    69.921     0.200
     4.970    74.333     0.200
     5.059    73.415     0.200
     5.140    77.032     0.200
     5.146    75.231     0.200
     5.426    79.094     0.200
     5.790    81.781     0.200
     5.746    83.665     0.200
     6.187    90.832     0.200
     6.256    86.900     0.200
     6.330    91.767     0.200
     6.316    90.279     0.200
     6.449    88.847     0.200
     6.962    95.305     0.200
     7.285   100.534     0.200
     7.336   101.287     0.200
     7.629   106.021     0.200
     8.371   112.661     0.200
     8.624   115.014     0.200
     8.745   116.701     0.200
     9.601   127.803     0.200
     2.074    36.943     0.200
     2.116    36.115     0.200
     2.243    37.557     0.200
     2.458    40.782     0.200
     2.475    41.049     0.200
     2.631    43.453     0.200
     2.685    44.516     0.200
     3.103    48.519     0.200
     3.217    49.410     0.200
     3.418    52.303     0.200
     3.434    52.248     0.200
     3.520    52.547     0.200
     4.123    61.231     0.200
     4.356    64.553     0.200
     4.475    65.515     0.200
     4.733    69.041     0.200
     5.151    75.866     0.200
     5.435    79.935     0.200
     6.322    89.704     0.200
     6.452    91.187     0.200
     7.243    95.550     0.200
     7.291   103.191     0.200
     7.343   100.391     0.200
     7.564   105.895     0.200
     7.635   105.974     0.200
     8.383   110.342     0.200
     8.757   114.786     0.200
     2.116    36.668     0.200
     2.238    37.479     0.200
     2.453    40.471     0.200
     2.467    40.940     0.200
     2.635    44.338     0.200
     2.686    45.089     0.200
     2.784    45.475     0.200
     3.024    47.231     0.200
     3.002    46.526     0.200
     3.096    49.491     0.200
     3.208    49.563     0.200
     3.411    51.986     0.200
     3.423    52.481     0.200
     3.509    52.872     0.200
     3.556    55.157     0.200
     3.782    55.992     0.200
     3.985    60.642     0.200
     4.116    61.157     0.200
     4.212    62.101     0.200
     4.316    64.791     0.200
     4.310    62.864     0.200
     4.350    64.292     0.200
     4.468    65.229     0.200
     4.553    66.417     0.200
     4.661    69.795     0.200
     4.726    68.778     0.200
     4.966    73.372     0.200
     5.136    77.172     0.200
     5.142    75.156     0.200
     5.423    79.091     0.200
     5.484    78.449     0.200
     5.742    84.724     0.200
     5.790    81.989     0.200
     5.920    82.966     0.200
     6.110    88.241     0.200
     6.152    89.337     0.200
     6.184    90.299     0.200
     6.191    89.394     0.200
     6.168    85.776     0.200
     6.253    87.554     0.200
     6.312    90.725     0.200
     6.327    91.780     0.200
     6.444    91.772     0.200
     6.466    90.973     0.200
     6.556    93.808     0.200
     6.982    97.279     0.200
     7.082    98.505     0.200
     7.126   104.270     0.200
     7.281   101.984     0.200
     7.332   100.144     0.200
     7.560   104.731     0.200
     7.625   106.071     0.200
     8.369   113.695     0.200
     8.742   118.530     0.200
     9.425   125.768     0.200
     9.600   128.922     0.200
     9.755   126.423     0.200
     3.361    52.833     0.200
     4.108    62.356     0.200
     4.392    62.032     0.200
     4.443    64.047     0.200
     4.987    73.139     0.200
     4.994    71.655     0.200
     5.296    75.883     0.200
     5.342    78.492     0.200
     5.508    81.998     0.200
     5.488    83.711     0.200
     5.883    81.550     0.200
     6.042    89.543     0.200
     6.107    90.643     0.200
     6.124    92.086     0.200
     6.186    89.088     0.200
     6.229    90.641     0.200
     6.269    93.804     0.200
     6.343    87.783     0.200
     6.388    87.954     0.200
     6.502    94.863     0.200
     6.641    95.978     0.200
     6.648    91.523     0.200
     7.014    95.144     0.200
     7.035    95.800     0.200
     7.154    97.518     0.200
     7.214    98.558     0.200
     7.342   101.320     0.200
     7.374   101.442     0.200
     7.508   102.778     0.200
     8.371   110.315     0.200
     8.607   112.752     0.200
     8.747   114.526     0.200
     9.642   126.582     0.200
     9.875   130.664     0.200
    10.122   132.618     0.200
     2.241    37.132     0.200
     2.456    40.425     0.200
     2.471    40.070     0.200
     2.484    41.142     0.200
     2.637    44.065     0.200
     2.688    44.778     0.200
     2.769    42.790     0.200
     2.787    44.859     0.200
     3.028    47.180     0.200
     3.015    49.139     0.200
     3.100    48.151     0.200
     3.212    49.426     0.200
     3.202    51.556     0.200
     3.267    52.304     0.200
     3.344    53.303     0.200
     3.415    52.894     0.200
     3.427    51.203     0.200
     3.436    54.529     0.200
     3.458    54.773     0.200
     3.474    54.991     0.200
     3.513    52.825     0.200
     3.549    53.796     0.200
     3.556    56.122     0.200
     3.563    51.835     0.200
     3.573    56.227     0.200
     3.854    59.844     0.200
     3.940    61.430     0.200
     4.119    61.682     0.200
     4.126    63.280     0.200
     4.216    65.211     0.200
     4.317    63.041     0.200
     4.354    64.918     0.200
     4.472    65.458     0.200
     4.542    66.732     0.200
     4.775    69.618     0.200
     4.969    72.938     0.200
     5.140    74.546     0.200
     5.146    75.430     0.200
     5.427    78.754     0.200
     5.746    82.721     0.200
     6.113    89.818     0.200
     6.156    88.650     0.200
     6.188    89.701     0.200
     6.195    88.299     0.200
     6.257    89.665     0.200
     6.315    89.194     0.200
     6.448    90.992     0.200
     7.285   100.413     0.200
     7.336   102.639     0.200
     7.629   104.699     0.200
     8.372   112.922     0.200
     8.625   115.379     0.200
     8.746   116.664     0.200
     2.346    38.573     0.200
     2.922    47.999     0.200
     3.023    49.322     0.200
     3.086    49.682     0.200
     3.167    51.234     0.200
     3.209    52.053     0.200
     3.223    51.484     0.200
     3.254    52.322     0.200
     3.286    53.151     0.200
     3.308    52.495     0.200
     3.588    56.529     0.200
     3.661    57.577     0.200
     3.723    57.046     0.200
     3.810    57.219     0.200
     3.849    59.481     0.200
     3.862    59.536     0.200
     4.013    60.243     0.200
     4.304    62.775     0.200
     4.726    68.797     0.200
     4.889    69.179     0.200
     5.403    75.700     0.200
     5.479    77.306     0.200
     5.863    76.879     0.200
     5.969    84.779     0.200
     6.077    85.267     0.200
     6.178    87.484     0.200
     6.177    85.668     0.200
     6.616    85.686     0.200
     6.595    88.831     0.200
     6.797    92.078     0.200
     6.972    89.833     0.200
     6.993    90.191     0.200
     7.043    95.500     0.200
     7.106    94.243     0.200
     7.275    93.497     0.200
     7.260    97.673     0.200
     7.350    99.027     0.200
     7.952   101.900     0.200
     8.205   108.355     0.200
     8.200   111.602     0.200
     8.303   107.398     0.200
     8.391   112.971     0.200
     8.533   108.915     0.200
     8.681   110.698     0.200
     9.300   118.165     0.200
     9.359   118.972     0.200
     9.476   120.316     0.200
     9.593   121.651     0.200
     9.665   122.706     0.200
     9.658   122.387     0.200
     9.699   122.811     0.200
     9.696   123.142     0.200
    10.166   133.880     0.200
     2.438    39.481     0.200
     2.779    45.702     0.200
     2.781    44.179     0.200
     2.987    47.880     0.200
     3.022    48.567     0.200
     3.108    49.264     0.200
     3.207    48.898     0.200
     3.314    52.261     0.200
     3.365    52.461     0.200
     3.624    55.939     0.200
     3.627    57.002     0.200
     3.858    59.106     0.200
     3.893    59.498     0.200
     3.898    56.339     0.200
     4.025    57.664     0.200
     4.090    57.694     0.200
     4.307    60.765     0.200
     4.343    61.047     0.200
     4.849    68.646     0.200
     5.226    76.358     0.200
     5.547    79.996     0.200
     5.931    80.014     0.200
     6.249    87.449     0.200
     6.316    89.145     0.200
     6.331    90.027     0.200
     6.334    91.157     0.200
     6.376    89.345     0.200
     6.463    89.106     0.200
     6.477    93.064     0.200
     7.342    99.853     0.200
     8.576   111.845     0.200
     8.815   113.453     0.200
     8.952   116.358     0.200
     9.741   123.155     0.200
     2.434    39.235     0.200
     2.779    43.418     0.200
     2.778    44.828     0.200
     2.984    49.021     0.200
     3.106    50.593     0.200
     3.206    51.925     0.200
     3.207    51.917     0.200
     3.217    52.097     0.200
     3.313    52.982     0.200
     3.362    54.107     0.200
     3.619    56.503     0.200
     3.623    57.171     0.200
     3.733    58.673     0.200
     3.857    60.429     0.200
     3.893    56.809     0.200
     3.891    60.329     0.200
     4.021    57.117     0.200
     4.088    58.331     0.200
     4.340    61.792     0.200
     4.502    63.605     0.200
     4.509    63.821     0.200
     4.583    62.261     0.200
     4.820    68.693     0.200
     4.846    67.690     0.200
     4.854    68.992     0.200
     5.069    70.788     0.200
     5.216    75.109     0.200
     5.374    74.230     0.200
     5.397    74.055     0.200
     5.537    79.036     0.200
     6.240    87.612     0.200
     6.262    89.143     0.200
     6.307    88.212     0.200
     6.325    90.133     0.200
     6.366    89.220     0.200
     6.454    89.094     0.200
     6.538    86.050     0.200
     7.059    94.369     0.200
     7.218    95.802     0.200
     7.332    99.072     0.200
     7.358    96.272     0.200
     7.398    99.409     0.200
     7.478    97.573     0.200
     7.502   101.401     0.200
     7.692   102.973     0.200
     8.193   107.830     0.200
     8.492   114.438     0.200
     8.568   112.552     0.200
     8.807   114.766     0.200
     8.944   116.870     0.200
     9.526   124.477     0.200
     9.624   125.031     0.200
     9.732   126.868     0.200
     9.829   126.739     0.200
     9.890   129.118     0.200
     9.919   128.696     0.200
     9.930   128.361     0.200
     0.702    15.409     0.200
     0.785    16.945     0.200
     0.914    19.815     0.200
     0.933    20.519     0.200
     0.922    20.264     0.200
     0.927    18.990     0.200
     1.081    21.953     0.200
     2.111    35.469     0.200
     2.303    37.634     0.200
     2.369    38.758     0.200
     2.440    39.535     0.200
     2.531    40.668     0.200
     2.567    41.246     0.200
     2.598    41.788     0.200
     2.656    42.308     0.200
     2.680    42.230     0.200
     2.949    45.787     0.200
     3.051    46.897     0.200
     3.198    49.077     0.200
     3.221    49.220     0.200
     3.898    54.926     0.200
     3.854    56.753     0.200
     4.803    70.959     0.200
     5.007    69.771     0.200
     5.415    75.466     0.200
     5.497    74.577     0.200
     6.024    82.490     0.200
     6.068    82.225     0.200
     6.083    83.344     0.200
     6.155    85.935     0.200
     6.222    86.398     0.200
     6.294    87.871     0.200
     6.441    85.332     0.200
     6.600    88.677     0.200
     6.661    90.195     0.200
     6.862    92.521     0.200
     6.989    92.045     0.200
     6.979    94.462     0.200
     7.035    92.501     0.200
     7.135    94.783     0.200
     7.135    94.115     0.200
     7.161    94.238     0.200
     7.216    96.994     0.200
     7.432    96.475     0.200
     7.498    98.605     0.200
     7.472    98.331     0.200
     7.561    99.114     0.200
     7.774   101.380     0.200
     7.822   102.218     0.200
     8.014   107.678     0.200
     8.174   106.609     0.200
     8.415   109.502     0.200
     8.619   111.915     0.200
     8.690   113.194     0.200
     8.686   112.241     0.200
     8.880   115.472     0.200
     9.009   116.665     0.200
     9.072   117.833     0.200
     9.743   125.906     0.200
     9.695   123.239     0.200
     9.800   126.437     0.200
     9.890   127.689     0.200
    10.060   129.705     0.200
    10.068   129.814     0.200
    10.091   130.039     0.200
    10.102   129.818     0.200
    10.166   130.565     0.200
    10.187   131.217     0.200
    10.394   133.607     0.200
    10.433   134.348     0.200
    10.709   137.629     0.200
    10.896   139.951     0.200
    11.211   143.775     0.200
    11.476   146.983     0.200
    12.355   157.624     0.200
    13.055   166.252     0.200
    13.343   169.796     0.200
    13.419   170.609     0.200
    14.427   182.840     0.200
    14.906   188.848     0.200
     0.744    16.154     0.200
     0.765    16.602     0.200
     0.858    19.025     0.200
     0.903    20.650     0.200
     0.847    18.752     0.200
     0.965    20.767     0.200
     0.952    20.125     0.200
     1.232    22.103     0.200
     1.449    25.000     0.200
     1.717    28.727     0.200
     1.728    28.510     0.200
     1.872    30.180     0.200
     1.938    31.922     0.200
     1.898    30.717     0.200
     2.079    32.770     0.200
     2.247    37.239     0.200
     2.574    39.283     0.200
     2.738    43.049     0.200
     2.869    43.358     0.200
     3.066    45.899     0.200
     3.093    47.257     0.200
     3.481    51.001     0.200
     3.480    50.087     0.200
     3.836    55.466     0.200
     3.875    55.769     0.200
     3.992    55.206     0.200
     4.117    57.784     0.200
     4.360    61.213     0.200
     4.366    61.139     0.200
     4.815    67.346     0.200
     4.925    66.354     0.200
     5.100    70.666     0.200
     5.171    69.389     0.200
     5.466    74.008     0.200
     5.515    76.127     0.200
     5.591    76.021     0.200
     5.917    81.090     0.200
     6.113    83.612     0.200
     6.138    81.968     0.200
     6.167    82.954     0.200
     6.257    88.408     0.200
     6.340    88.441     0.200
     6.374    88.038     0.200
     6.400    87.680     0.200
     6.518    89.054     0.200
     6.547    85.829     0.200
     6.765    92.439     0.200
     6.969    94.249     0.200
     7.021    93.595     0.200
     7.091    92.287     0.200
     7.221    95.157     0.200
     7.269    94.502     0.200
     7.518    97.502     0.200
     7.588    98.284     0.200
     7.608    98.648     0.200
     7.879   101.990     0.200
     7.931   102.582     0.200
     8.526   109.635     0.200
     8.800   112.836     0.200
     8.989   114.829     0.200
     9.183   117.474     0.200
     9.853   125.750     0.200
     9.911   126.277     0.200
    10.179   129.348     0.200
    10.277   131.205     0.200
    10.298   130.954     0.200
    10.504   133.553     0.200
    10.819   137.482     0.200
     2.672    42.661     0.200
     2.929    47.270     0.200
     3.162    49.760     0.200
     3.257    51.145     0.200
     3.332    52.276     0.200
     3.452    53.477     0.200
     3.915    59.268     0.200
     3.997    60.812     0.200
     4.045    61.046     0.200
     6.529    91.771     0.200
     6.604    93.242     0.200
     6.669    94.915     0.200
     7.635   102.669     0.200
     7.929   108.827     0.200
     1.975    34.326     0.200
     2.781    46.666     0.200
     2.936    48.658     0.200
     3.050    50.332     0.200
     3.108    50.951     0.200
     3.186    51.948     0.200
     3.253    52.664     0.200
     3.297    53.653     0.200
     3.287    51.564     0.200
     3.334    53.625     0.200
     3.607    57.134     0.200
     3.672    58.277     0.200
     3.754    56.921     0.200
     3.873    60.926     0.200
     3.882    60.730     0.200
     4.366    61.275     0.200
     4.533    69.457     0.200
     4.673    69.970     0.200
     4.672    68.208     0.200
     4.767    68.399     0.200
     4.839    72.380     0.200
     4.866    70.852     0.200
     4.898    72.569     0.200
     4.924    72.550     0.200
     5.032    73.508     0.200
     5.057    73.317     0.200
     5.184    76.491     0.200
     5.287    75.827     0.200
     5.346    77.472     0.200
     5.365    77.113     0.200
     5.388    77.747     0.200
     5.399    77.619     0.200
     5.458    77.630     0.200
     5.488    77.286     0.200
     5.562    79.917     0.200
     5.571    78.409     0.200
     5.730    80.657     0.200
     5.793    83.605     0.200
     5.769    81.905     0.200
     5.818    81.794     0.200
     5.887    86.634     0.200
     5.913    85.565     0.200
     5.904    83.927     0.200
     5.958    87.869     0.200
     5.969    86.489     0.200
     5.973    87.083     0.200
     6.023    85.822     0.200
     6.074    88.036     0.200
     6.088    87.618     0.200
     6.117    88.348     0.200
     6.131    85.818     0.200
     6.351    91.318     0.200
     6.497    92.277     0.200
     6.742    97.711     0.200
     6.756    94.182     0.200
     7.052    96.854     0.200
     7.052    96.936     0.200
     7.226    99.296     0.200
     7.296    99.983     0.200
     7.304    99.486     0.200
     7.345    99.505     0.200
     7.434   100.178     0.200
     7.569   103.095     0.200
     7.569   104.091     0.200
     7.614   102.177     0.200
     7.745   107.840     0.200
     8.076   108.183     0.200
     8.139   107.515     0.200
     8.158   111.920     0.200
     8.558   114.854     0.200
     9.532   123.085     0.200
     9.555   126.720     0.200
     9.899   136.028     0.200
    10.226   137.066     0.200
    10.803   137.049     0.200
    10.829   143.081     0.200
    10.973   146.110     0.200
    11.053   139.236     0.200
    16.694   223.511     0.200
     1.066    23.598     0.200
     1.080    24.371     0.200
     1.080    24.141     0.200
     1.118    25.630     0.200
     1.099    24.986     0.200
     1.149    25.608     0.200
     1.161    23.587     0.200
     1.168    24.140     0.200
     1.198    26.630     0.200
     1.223    26.224     0.200
     1.239    26.627     0.200
     1.315    27.079     0.200
     1.351    27.841     0.200
     1.533    31.069     0.200
     1.574    30.550     0.200
     2.932    48.820     0.200
     3.106    51.187     0.200
     3.252    53.184     0.200
     3.291    53.625     0.200
     3.331    52.958     0.200
     3.331    54.551     0.200
     3.603    57.685     0.200
     3.666    55.451     0.200
     3.776    59.078     0.200
     3.800    56.042     0.200
     3.800    57.885     0.200
     3.871    61.063     0.200
     3.878    60.876     0.200
     3.910    59.206     0.200
     4.380    66.384     0.200
     4.444    62.919     0.200
     4.536    69.264     0.200
     4.658    70.398     0.200
     4.648    69.328     0.200
     4.851    71.237     0.200
     4.834    69.720     0.200
     5.020    72.051     0.200
     5.035    72.701     0.200
     5.035    72.373     0.200
     5.169    75.941     0.200
     5.257    75.486     0.200
     5.331    77.657     0.200
     5.331    77.501     0.200
     5.358    75.107     0.200
     5.417    76.794     0.200
     5.417    76.575     0.200
     5.614    78.815     0.200
     5.779    83.593     0.200
     5.802    77.719     0.200
     5.819    81.181     0.200
     5.873    84.694     0.200
     5.873    86.616     0.200
     5.898    84.938     0.200
     5.926    82.880     0.200
     5.955    85.913     0.200
     5.959    86.320     0.200
     6.008    85.767     0.200
     6.008    85.915     0.200
     6.075    85.647     0.200
     6.103    87.851     0.200
     6.116    85.556     0.200
     6.337    89.449     0.200
     6.429    92.589     0.200
     6.448    90.183     0.200
     6.483    92.213     0.200
     6.498    92.610     0.200
     6.540    89.213     0.200
     6.728    97.952     0.200
     6.903    93.368     0.200
     6.905    95.259     0.200
     6.924    91.430     0.200
     6.975    95.526     0.200
     7.037    96.868     0.200
     7.037    96.579     0.200
     7.126    93.174     0.200
     7.211    96.782     0.200
     7.213   100.165     0.200
     7.282   102.056     0.200
     7.290    99.861     0.200
     7.331    99.789     0.200
     7.419   100.367     0.200
     7.425   101.597     0.200
     7.499   101.580     0.200
     7.554   102.770     0.200
     7.554   101.895     0.200
     7.599   104.160     0.200
     7.733   106.096     0.200
     7.797   107.544     0.200
     7.880   103.570     0.200
     7.995   103.837     0.200
     8.138   108.963     0.200
     8.144   109.994     0.200
     8.229   107.104     0.200
     8.332   113.104     0.200
     8.458   110.428     0.200
     8.606   112.301     0.200
     8.796   116.988     0.200
     9.231   119.304     0.200
     9.285   120.577     0.200
     9.402   121.308     0.200
     9.522   123.304     0.200
     9.584   123.884     0.200
     9.597   124.345     0.200
     9.629   124.554     0.200
     9.795   129.922     0.200
     9.811   126.440     0.200
     9.887   132.185     0.200
    10.111   129.634     0.200
    10.249   132.132     0.200
    10.265   131.735     0.200
    10.236   136.684     0.200
    10.476   139.812     0.200
    10.652   135.928     0.200
    10.675   144.177     0.200
    10.716   135.680     0.200
    10.791   137.906     0.200
    10.816   143.266     0.200
    10.882   146.882     0.200
    10.961   143.894     0.200
    11.041   141.184     0.200
    11.444   145.082     0.200
    11.750   150.614     0.200
    11.934   153.267     0.200
    12.507   159.576     0.200
    12.796   163.201     0.200
    12.858   163.877     0.200
    13.850   179.099     0.200
    14.119   175.761     0.200
    14.327   180.932     0.200
    15.300   206.550     0.200
    17.914   230.174     0.200
    20.469   269.058     0.200
     2.360    39.248     0.200
     2.941    48.659     0.200
     2.941    47.862     0.200
     3.054    49.448     0.200
     3.113    50.964     0.200
     3.190    51.660     0.200
     3.256    52.889     0.200
     3.302    52.256     0.200
     3.337    52.341     0.200
     3.337    53.841     0.200
     3.611    57.339     0.200
     3.677    57.278     0.200
     3.877    60.441     0.200
     3.886    60.635     0.200
     3.923    58.702     0.200
     4.009    62.679     0.200
     4.052    60.298     0.200
     4.398    61.361     0.200
     4.372    64.163     0.200
     4.406    64.566     0.200
     4.535    68.862     0.200
     4.728    67.810     0.200
     4.872    71.445     0.200
     4.842    69.176     0.200
     5.034    72.143     0.200
     5.266    74.738     0.200
     5.264    74.660     0.200
     5.367    76.152     0.200
     5.496    82.122     0.200
     5.627    77.728     0.200
     5.750    80.789     0.200
     5.799    85.823     0.200
     5.809    78.397     0.200
     5.785    80.973     0.200
     5.892    84.632     0.200
     5.920    86.246     0.200
     5.974    89.101     0.200
     5.978    87.365     0.200
     5.933    82.742     0.200
     6.030    85.696     0.200
     6.030    85.509     0.200
     6.080    87.377     0.200
     6.092    85.075     0.200
     6.122    87.849     0.200
     6.138    87.374     0.200
     6.255    90.554     0.200
     6.330    84.612     0.200
     6.260    85.132     0.200
     6.356    93.489     0.200
     6.447    92.026     0.200
     6.469    90.402     0.200
     6.501    93.742     0.200
     6.501    93.375     0.200
     6.515    92.908     0.200
     6.560    86.426     0.200
     6.561    89.916     0.200
     6.746    94.506     0.200
     6.914    90.499     0.200
     6.926    94.963     0.200
     7.002    97.473     0.200
     6.997    97.033     0.200
     6.997    96.885     0.200
     7.058    96.799     0.200
     7.058    95.331     0.200
     7.132    94.159     0.200
     7.179    99.622     0.200
     7.219    95.540     0.200
     7.233    99.775     0.200
     7.303   101.463     0.200
     7.311   100.069     0.200
     7.311    98.304     0.200
     7.352    99.494     0.200
     7.352   100.588     0.200
     7.405   102.320     0.200
     7.441   100.918     0.200
     7.440    99.623     0.200
     7.451   100.633     0.200
     7.386   100.695     0.200
     7.515   100.420     0.200
     7.576   100.697     0.200
     7.620   103.761     0.200
     7.752   104.515     0.200
     7.893   103.782     0.200
     8.002   103.700     0.200
     8.005   108.664     0.200
     8.165   112.299     0.200
     8.244   107.685     0.200
     8.353   112.906     0.200
     8.474   110.394     0.200
     8.464   106.812     0.200
     8.621   112.477     0.200
     8.903   121.362     0.200
     9.242   119.536     0.200
     9.300   119.954     0.200
     9.416   121.297     0.200
     9.434   123.096     0.200
     9.534   123.421     0.200
     9.599   124.064     0.200
     9.607   123.170     0.200
     9.641   123.779     0.200
     9.665   129.192     0.200
     9.903   134.888     0.200
     9.903   134.248     0.200
    10.260   130.453     0.200
    10.236   143.338     0.200
    10.224   134.389     0.200
    10.626   141.280     0.200
    10.668   137.367     0.200
    10.664   143.054     0.200
    10.692   145.309     0.200
    10.807   138.568     0.200
    10.849   143.382     0.200
    10.899   142.227     0.200
    10.977   144.366     0.200
    11.057   141.257     0.200
    11.446   147.813     0.200
    11.759   149.861     0.200
    12.519   157.891     0.200
    12.808   161.515     0.200
    12.869   162.707     0.200
    14.129   178.099     0.200
    16.698   221.216     0.200
    17.931   231.080     0.200
    18.519   238.967     0.200
    18.891   249.627     0.200
    19.104   252.248     0.200
    19.112   253.050     0.200
    19.296   252.798     0.200
    20.062   264.857     0.200
    20.476   268.699     0.200
    20.476   268.129     0.200
    20.658   270.599     0.200
    22.584   291.580     0.200
     3.069    50.208     0.200
     3.127    50.932     0.200
     3.204    51.638     0.200
     3.272    53.042     0.200
     3.313    52.960     0.200
     3.352    53.402     0.200
     3.352    53.902     0.200
     3.625    57.019     0.200
     3.688    57.880     0.200
     3.892    60.506     0.200
     3.900    60.617     0.200
     3.932    59.235     0.200
     4.064    61.695     0.200
     4.379    63.019     0.200
     4.415    65.098     0.200
     4.553    68.759     0.200
     4.793    70.194     0.200
     4.856    70.757     0.200
     5.042    72.783     0.200
     5.278    75.631     0.200
     5.430    76.714     0.200
     5.513    82.439     0.200
     5.797    82.471     0.200
     5.877    86.607     0.200
     5.946    85.536     0.200
     5.959    86.131     0.200
     5.947    83.325     0.200
     6.019    85.727     0.200
     6.484    92.669     0.200
     6.895    93.860     0.200
     6.915    95.024     0.200
     6.987    95.288     0.200
     7.304    98.887     0.200
     7.340    99.565     0.200
     7.873   106.140     0.200
     8.456   113.541     0.200
     8.603   113.233     0.200
     9.223   121.998     0.200
     9.281   123.709     0.200
     9.515   125.585     0.200
     9.580   126.822     0.200
     2.344    38.205     0.200
     2.925    48.134     0.200
     3.035    50.047     0.200
     3.095    50.548     0.200
     3.173    51.839     0.200
     3.238    52.585     0.200
     3.286    52.918     0.200
     3.319    50.234     0.200
     3.319    53.429     0.200
     3.594    56.823     0.200
     3.661    57.645     0.200
     3.868    60.519     0.200
     3.909    57.754     0.200
     4.035    58.071     0.200
     4.360    60.889     0.200
     4.515    68.405     0.200
     4.684    67.300     0.200
     4.713    65.559     0.200
     4.766    67.846     0.200
     4.879    73.335     0.200
     4.898    68.702     0.200
     5.021    70.379     0.200
     5.250    73.696     0.200
     5.245    74.950     0.200
     5.359    76.073     0.200
     5.359    76.315     0.200
     5.351    73.722     0.200
     5.476    82.598     0.200
     5.808    83.648     0.200
     5.768    78.651     0.200
     5.902    86.268     0.200
     5.902    85.635     0.200
     5.926    85.464     0.200
     5.916    81.932     0.200
     5.975    88.730     0.200
     5.985    86.494     0.200
     5.990    87.445     0.200
     6.034    83.414     0.200
     6.034    85.282     0.200
     6.088    86.903     0.200
     6.106    86.382     0.200
     6.133    90.054     0.200
     6.139    88.101     0.200
     6.266    90.597     0.200
     6.368    93.634     0.200
     6.460    92.256     0.200
     6.465    91.821     0.200
     6.514    95.035     0.200
     6.529    92.213     0.200
     6.560    88.913     0.200
     6.925    93.558     0.200
     6.953    92.125     0.200
     7.001    95.059     0.200
     7.063    95.250     0.200
     7.063    96.438     0.200
     7.229    98.000     0.200
     7.312    98.233     0.200
     7.357   100.107     0.200
     7.447    99.207     0.200
     7.456   102.583     0.200
     7.465   100.727     0.200
     7.530   100.956     0.200
     7.625   101.286     0.200
     7.746   106.370     0.200
     7.910   103.661     0.200
     8.152   106.764     0.200
     8.164   111.190     0.200
     8.259   107.881     0.200
     8.397   111.479     0.200
     8.457   107.473     0.200
     8.489   111.000     0.200
     8.637   112.476     0.200
     9.068   127.366     0.200
     9.260   119.499     0.200
     9.315   120.854     0.200
     9.432   122.087     0.200
     9.552   123.397     0.200
     9.615   124.264     0.200
     9.659   124.846     0.200
     9.917   136.960     0.200
    10.139   130.238     0.200
    10.278   132.027     0.200
    10.206   133.197     0.200
    10.705   143.085     0.200
    10.822   139.079     0.200
    11.072   141.162     0.200
    15.313   202.859     0.200
     2.340    37.241     0.200
     3.315    50.964     0.200
     3.904    58.484     0.200
     4.031    58.802     0.200
     4.387    63.348     0.200
     4.682    69.178     0.200
     4.762    67.671     0.200
     5.902    90.066     0.200
     5.911    82.256     0.200
     5.976    88.656     0.200
     5.990    87.273     0.200
     5.985    89.902     0.200
     6.033    84.987     0.200
     6.133    90.366     0.200
     6.368    94.727     0.200
     6.515    97.091     0.200
     6.934    94.622     0.200
     6.955    94.677     0.200
     8.260   112.249     0.200
     8.490   114.575     0.200
     8.638   114.438     0.200
     9.554   126.053     0.200
     2.336    38.507     0.200
     2.917    47.723     0.200
     3.030    48.903     0.200
     3.089    49.720     0.200
     3.166    50.816     0.200
     3.233    51.240     0.200
     3.278    52.217     0.200
     3.314    50.797     0.200
     3.314    52.493     0.200
     3.587    55.901     0.200
     3.653    56.740     0.200
     3.853    59.000     0.200
     3.862    59.299     0.200
     3.899    59.363     0.200
     4.028    60.464     0.200
     4.382    65.422     0.200
     4.671    66.042     0.200
     4.704    69.472     0.200
     4.758    69.039     0.200
     4.818    70.434     0.200
     4.836    69.645     0.200
     4.867    70.774     0.200
     5.347    76.284     0.200
     5.796    83.464     0.200
     5.892    86.316     0.200
     5.913    85.248     0.200
     5.909    82.507     0.200
     5.944    83.090     0.200
     5.965    85.878     0.200
     5.974    86.214     0.200
     5.979    86.161     0.200
     6.022    84.890     0.200
     6.122    87.223     0.200
     6.126    85.184     0.200
     6.357    93.138     0.200
     6.505    92.685     0.200
     6.927    96.027     0.200
     6.948    96.785     0.200
     7.904   107.029     0.200
     8.251   109.269     0.200
     8.480   113.405     0.200
     8.629   113.770     0.200
     9.255   123.862     0.200
     9.307   121.047     0.200
     9.425   123.773     0.200
     9.546   126.863     0.200
     9.607   126.851     0.200
     9.620   127.293     0.200
     9.645   124.110     0.200
     9.653   127.112     0.200
     9.834   130.700     0.200
    10.135   134.386     0.200
     1.521    28.132     0.200
     4.635    68.788     0.200
     4.801    69.485     0.200
     4.829    71.345     0.200
     5.310    75.913     0.200
     5.758    83.620     0.200
     5.798    79.422     0.200
     5.853    83.894     0.200
     5.876    84.443     0.200
     5.927    85.878     0.200
     5.935    86.855     0.200
     5.940    87.461     0.200
     5.985    86.459     0.200
     6.084    86.869     0.200
     6.092    87.367     0.200
     6.319    90.240     0.200
     6.466    91.764     0.200
     6.894    93.026     0.200
     6.915    92.684     0.200
     7.204    96.011     0.200
     8.214   108.420     0.200
     8.442   111.360     0.200
     8.592   113.013     0.200
     9.222   120.663     0.200
     9.270   121.496     0.200
     9.389   123.012     0.200
     9.512   125.278     0.200
    12.848   165.941     0.200
     1.977    32.555     0.200
     2.739    44.801     0.200
     2.930    49.383     0.200
     3.045    50.130     0.200
     3.103    51.261     0.200
     3.265    49.726     0.200
     3.248    52.665     0.200
     3.289    53.878     0.200
     3.328    53.824     0.200
     3.601    57.348     0.200
     3.868    60.436     0.200
     3.875    60.642     0.200
     3.909    62.746     0.200
     4.530    68.200     0.200
     4.664    71.017     0.200
     4.831    71.687     0.200
     4.830    71.958     0.200
     4.858    71.327     0.200
     5.030    73.069     0.200
     5.254    77.054     0.200
     5.338    76.895     0.200
     5.422    76.662     0.200
     5.785    83.922     0.200
     5.879    87.363     0.200
     5.905    86.537     0.200
     5.923    84.849     0.200
     5.952    87.799     0.200
     5.962    86.566     0.200
     5.967    86.129     0.200
     6.110    91.433     0.200
     6.121    86.512     0.200
     6.491    94.027     0.200
     6.910    93.021     0.200
     8.236   109.856     0.200
     8.465   113.477     0.200
     8.613   113.951     0.200
     9.238   123.059     0.200
     9.529   124.760     0.200
     9.636   126.706     0.200
     9.802   127.777     0.200
     1.235    26.626     0.200
     1.215    26.310     0.200
     1.327    29.127     0.200
     3.321    52.327     0.200
     4.519    68.154     0.200
     4.678    68.496     0.200
     4.826    70.964     0.200
     4.873    70.512     0.200
     5.018    73.233     0.200
     5.192    77.435     0.200
     5.247    75.450     0.200
     5.353    76.867     0.200
     5.353    79.735     0.200
     5.435    76.273     0.200
     5.823    84.236     0.200
     5.896    85.347     0.200
     5.919    86.031     0.200
     5.917    83.531     0.200
     5.952    82.897     0.200
     5.968    87.303     0.200
     5.978    87.073     0.200
     6.028    85.658     0.200
     6.099    87.415     0.200
     6.133    85.572     0.200
     6.361    93.027     0.200
     6.507    93.053     0.200
     6.947    96.424     0.200
     6.995    95.255     0.200
     7.057    95.355     0.200
     7.225    99.269     0.200
     7.351    98.103     0.200
     7.903   107.955     0.200
     8.252   110.483     0.200
     8.482   113.603     0.200
     8.630   114.875     0.200
     9.254   124.899     0.200
     9.426   124.891     0.200
     9.545   128.597     0.200
     9.608   129.263     0.200
     9.619   128.932     0.200
     9.652   128.146     0.200
     2.735    44.758     0.200
     3.323    52.694     0.200
     3.789    57.858     0.200
     3.907    61.585     0.200
     4.408    63.038     0.200
     4.669    66.520     0.200
     4.766    70.358     0.200
     4.834    70.017     0.200
     4.827    71.040     0.200
     4.863    70.978     0.200
     5.023    73.158     0.200
     5.249    75.816     0.200
     5.426    76.635     0.200
     5.770    81.846     0.200
     5.791    83.701     0.200
     5.816    79.705     0.200
     5.886    85.168     0.200
     5.910    85.820     0.200
     5.918    84.208     0.200
     5.943    84.887     0.200
     5.968    86.050     0.200
     5.973    86.252     0.200
     6.019    85.453     0.200
     6.090    86.918     0.200
     6.116    87.279     0.200
     6.125    85.745     0.200
     6.246    87.083     0.200
     6.498    93.435     0.200
     6.565    88.359     0.200
     6.918    92.049     0.200
     6.938    93.404     0.200
     6.986    95.147     0.200
     7.048    96.155     0.200
     7.218    99.541     0.200
     7.225    95.564     0.200
     7.342   100.196     0.200
     7.609   103.675     0.200
     8.243   110.177     0.200
     8.621   115.073     0.200
     9.245   120.680     0.200
     9.417   123.583     0.200
     9.537   125.482     0.200
     9.611   127.318     0.200
     9.825   128.719     0.200
     5.443    77.781     0.200
     5.614    80.891     0.200
     5.902    85.323     0.200
     6.093    88.429     0.200
     6.208    86.507     0.200
     6.584    96.575     0.200
     6.616    93.898     0.200
     6.655    96.278     0.200
     6.670    95.416     0.200
     6.702    98.315     0.200
     6.725    94.109     0.200
     6.790    96.057     0.200
     6.907    96.779     0.200
     7.813   107.683     0.200
     7.827   106.552     0.200
     5.624    81.113     0.200
     5.627    80.600     0.200
     5.909    85.726     0.200
     6.102    85.910     0.200
     6.219    85.514     0.200
     6.534    93.993     0.200
     6.591    96.084     0.200
     6.621    95.573     0.200
     6.661    96.079     0.200
     6.679    93.271     0.200
     6.673    97.724     0.200
     6.737    92.761     0.200
     6.800    96.074     0.200
     6.919    95.501     0.200
     7.822   107.362     0.200
     2.863    46.966     0.200
     3.141    50.127     0.200
     3.172    51.064     0.200
     3.357    52.998     0.200
     3.386    53.263     0.200
     3.509    54.725     0.200
     3.525    54.939     0.200
     3.586    55.638     0.200
     3.654    57.136     0.200
     3.654    56.437     0.200
     3.774    57.934     0.200
     3.994    61.169     0.200
     3.994    60.669     0.200
     4.108    63.839     0.200
     4.141    62.558     0.200
     4.256    63.912     0.200
     4.288    65.541     0.200
     4.455    67.590     0.200
     4.477    68.128     0.200
     4.546    67.826     0.200
     4.587    70.617     0.200
     4.744    70.714     0.200
     4.933    72.709     0.200
     4.965    72.541     0.200
     5.198    76.113     0.200
     5.254    77.366     0.200
     5.454    79.879     0.200
     5.534    80.991     0.200
     5.570    81.280     0.200
     5.593    79.606     0.200
     5.625    81.478     0.200
     5.776    83.176     0.200
     5.911    85.574     0.200
     5.970    84.403     0.200
     6.104    86.205     0.200
     6.176    86.510     0.200
     6.197    87.861     0.200
     6.220    87.284     0.200
     6.277    89.426     0.200
     6.536    93.845     0.200
     6.593    97.142     0.200
     6.623    93.717     0.200
     6.663    94.739     0.200
     6.681    95.127     0.200
     6.709    98.090     0.200
     6.737    94.886     0.200
     6.801    94.513     0.200
     6.919    96.030     0.200
     7.538   102.207     0.200
     7.823   107.537     0.200
     8.116   110.263     0.200
     9.852   131.007     0.200
     5.634    80.399     0.200
     5.789    81.873     0.200
     6.987   100.127     0.200
     7.000    98.789     0.200
     8.020   110.253     0.200
     2.375    38.669     0.200
     2.635    42.238     0.200
     2.703    42.837     0.200
     2.791    43.411     0.200
     2.833    45.223     0.200
     2.862    44.981     0.200
     2.922    45.991     0.200
     2.929    46.904     0.200
     3.211    49.018     0.200
     3.302    50.053     0.200
     3.464    51.566     0.200
     3.483    52.441     0.200
     3.690    54.959     0.200
     4.734    67.411     0.200
     4.870    68.743     0.200
     4.980    70.671     0.200
     5.353    75.872     0.200
     5.435    74.532     0.200
     5.467    77.150     0.200
     5.917    81.386     0.200
     5.939    82.151     0.200
     6.010    83.492     0.200
     6.080    86.428     0.200
     6.089    83.848     0.200
     6.121    84.495     0.200
     6.162    86.672     0.200
     6.184    87.954     0.200
     6.192    86.201     0.200
     6.327    89.090     0.200
     6.357    88.475     0.200
     6.570    91.469     0.200
     6.689    90.624     0.200
     6.749    93.595     0.200
     7.048    93.933     0.200
     7.133    95.631     0.200
     7.280    96.329     0.200
     7.429    99.288     0.200
     7.481   100.887     0.200
     7.539    99.272     0.200
     7.539   100.803     0.200
     7.673   102.246     0.200
     7.738   105.887     0.200
     8.100   110.560     0.200
     8.316   111.235     0.200
     9.639   127.295     0.200
     9.871   126.992     0.200
     2.698    44.275     0.200
     3.041    50.778     0.200
     3.044    49.841     0.200
     3.281    53.477     0.200
     3.370    54.642     0.200
     3.464    56.238     0.200
     3.471    55.354     0.200
     3.574    56.061     0.200
     3.574    57.661     0.200
     3.574    58.081     0.200
     3.628    57.731     0.200
     3.670    58.632     0.200
     3.839    58.266     0.200
     3.887    60.304     0.200
     3.887    61.804     0.200
     3.999    61.897     0.200
     3.999    62.997     0.200
     4.119    62.100     0.200
     4.119    63.801     0.200
     4.149    63.050     0.200
     4.143    65.759     0.200
     4.156    65.172     0.200
     4.198    63.271     0.200
     4.284    63.375     0.200
     4.367    65.508     0.200
     4.354    65.259     0.200
     4.606    68.612     0.200
     4.620    71.147     0.200
     4.765    69.858     0.200
     4.766    70.342     0.200
     5.112    73.815     0.200
     5.134    76.449     0.200
     5.119    75.033     0.200
     5.307    78.350     0.200
     5.500    78.779     0.200
     5.906    86.166     0.200
     6.216    91.766     0.200
     6.279    92.295     0.200
     6.318    92.528     0.200
     6.353    92.691     0.200
     6.361    94.988     0.200
     6.360    93.047     0.200
     6.429    93.896     0.200
     6.481    93.386     0.200
     6.496    95.902     0.200
     6.470    88.958     0.200
     6.588    92.283     0.200
     6.607    94.358     0.200
     6.723    96.090     0.200
     6.805    96.726     0.200
     6.839   100.290     0.200
     7.503   105.111     0.200
     7.795   107.093     0.200
     3.009    49.434     0.200
     3.067    50.158     0.200
     3.146    50.643     0.200
     3.239    52.244     0.200
     3.258    52.226     0.200
     3.357    53.571     0.200
     3.382    53.380     0.200
     3.657    57.772     0.200
     3.755    58.226     0.200
     3.901    59.825     0.200
     3.929    59.247     0.200
     3.928    61.011     0.200
     4.468    67.025     0.200
     4.932    74.673     0.200
     5.126    74.371     0.200
     5.441    78.439     0.200
     5.535    80.823     0.200
     5.606    80.982     0.200
     5.685    82.603     0.200
     6.052    85.581     0.200
     6.140    88.873     0.200
     6.204    90.286     0.200
     6.224    89.013     0.200
     6.324    87.814     0.200
     6.382    91.026     0.200
     6.737    95.858     0.200
     6.796    93.035     0.200
     6.997    95.523     0.200
     7.098   101.016     0.200
     7.311    98.011     0.200
     7.452   103.074     0.200
     7.818   103.384     0.200
    10.043   132.063     0.200
     4.388    66.278     0.200
     5.140    75.367     0.200
     5.951    85.946     0.200
     6.013    88.401     0.200
     6.899    93.293     0.200
     6.970    95.546     0.200
     7.265    97.729     0.200
     7.523   100.911     0.200
     2.313    37.178     0.200
     2.367    38.429     0.200
     2.750    44.529     0.200
     2.844    44.400     0.200
     3.928    59.367     0.200
     4.374    67.356     0.200
     4.424    67.454     0.200
     4.595    69.199     0.200
     4.634    70.384     0.200
     4.682    70.989     0.200
     4.893    72.104     0.200
     5.060    75.051     0.200
     5.145    74.981     0.200
     5.309    79.848     0.200
     5.570    78.879     0.200
     5.816    84.423     0.200
     5.881    83.756     0.200
     5.923    85.364     0.200
     6.094    86.241     0.200
     6.278    89.173     0.200
     7.065    99.258     0.200
     7.101    97.522     0.200
     1.179    24.058     0.200
     2.118    36.028     0.200
     2.333    39.436     0.200
     3.872    59.864     0.200
     4.850    68.857     0.200
     5.025    71.274     0.200
     5.026    74.566     0.200
     5.062    75.639     0.200
     5.454    76.980     0.200
     5.503    79.183     0.200
     5.624    78.646     0.200
     5.624    77.755     0.200
     5.940    84.653     0.200
     6.012    87.747     0.200
     6.063    89.146     0.200
     6.090    86.743     0.200
     6.094    88.782     0.200
     6.149    85.253     0.200
     6.173    87.083     0.200
     6.197    88.394     0.200
     6.197    87.496     0.200
     6.233    88.543     0.200
     6.325    87.918     0.200
     6.368    92.872     0.200
     6.463    92.496     0.200
     6.524    91.928     0.200
     6.545    94.163     0.200
     6.590    95.467     0.200
     6.675    92.883     0.200
     6.759    91.604     0.200
     6.939    96.509     0.200
     7.032    96.246     0.200
     7.125    97.128     0.200
     7.166    95.353     0.200
     7.220    98.339     0.200
     7.220    98.753     0.200
     7.501   101.544     0.200
     7.503   104.028     0.200
     7.513   100.809     0.200
     7.592   102.399     0.200
     7.658   102.413     0.200
     7.767   103.558     0.200
     7.767   103.738     0.200
     7.789   103.090     0.200
     7.916   108.104     0.200
     7.963   108.254     0.200
     8.017   108.124     0.200
     8.291   109.187     0.200
     8.300   110.727     0.200
     8.332   110.354     0.200
     8.362   113.002     0.200
     8.531   114.730     0.200
     8.545   114.972     0.200
     8.545   115.662     0.200
     8.675   114.751     0.200
     8.982   118.863     0.200
     9.029   126.257     0.200
     9.246   122.380     0.200
     9.356   125.002     0.200
     9.460   125.288     0.200
     9.551   126.729     0.200
     9.648   127.598     0.200
     9.688   126.027     0.200
     9.721   129.542     0.200
     9.980   136.019     0.200
    10.219   134.551     0.200
    10.779   146.558     0.200
    10.973   147.421     0.200
    11.121   144.002     0.200
    15.531   207.495     0.200
    16.920   226.344     0.200
    18.510   245.266     0.200
    18.510   243.572     0.200
    18.568   237.814     0.200
    19.066   252.286     0.200
     1.263    26.260     0.200
     1.602    31.120     0.200
     3.025    48.799     0.200
     3.426    56.197     0.200
     3.527    53.929     0.200
     3.629    56.751     0.200
     3.686    57.035     0.200
     4.169    64.714     0.200
     4.373    64.302     0.200
     4.530    65.239     0.200
     4.616    65.787     0.200
     4.694    67.948     0.200
     4.880    71.391     0.200
     4.912    72.864     0.200
     5.289    76.311     0.200
     5.809    83.202     0.200
     5.903    85.161     0.200
     5.927    86.314     0.200
     5.975    87.696     0.200
     5.985    87.578     0.200
     5.990    87.409     0.200
     6.036    86.111     0.200
     6.141    87.344     0.200
     6.368    91.092     0.200
     6.514    92.564     0.200
     7.065    96.777     0.200
     7.209   100.192     0.200
     7.304   105.439     0.200
     7.315   101.608     0.200
     7.315   101.820     0.200
     7.359    99.800     0.200
     7.579   102.675     0.200
     7.626   104.779     0.200
     8.837   127.950     0.200
    10.208   134.287     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     7.220   148.689     0.200
     8.761   175.702     0.200
     3.177    63.700     0.200
     3.096    69.374     0.200
     3.191    71.013     0.200
     3.125    63.685     0.200
    10.090   204.509     0.200
    10.160   206.690     0.200
     6.569   131.379     0.200
     3.150    64.661     0.200
     3.655    71.066     0.200
     3.543    76.694     0.200
     4.919   100.136     0.200
     3.240    64.332     0.200
     3.260    64.206     0.200
     3.186    62.741     0.200
     4.346    87.529     0.200
     4.379    85.854     0.200
    10.136   209.167     0.200
     5.455   111.063     0.200
     5.764   121.452     0.200
     3.126    59.568     0.200
     4.361    87.659     0.200
     2.932    66.318     0.200
     3.907    72.739     0.200
     4.320    84.222     0.200
     4.620    97.422     0.200
     6.400   126.151     0.200
     3.925    80.663     0.200
     6.017   122.429     0.200
     9.856   200.259     0.200
     4.624    96.978     0.200
     4.117    79.054     0.200
     4.272    84.358     0.200
     6.585   135.163     0.200
     3.249    64.335     0.200
     3.765    79.648     0.200
     4.125    80.441     0.200
     4.655   104.762     0.200
     6.184   129.712     0.200
     7.482   155.771     0.200
     8.640   177.261     0.200
     5.260   111.252     0.200
     5.485   110.076     0.200
     3.602    77.639     0.200
     2.508    52.312     0.200
     4.285    83.128     0.200
     5.559   117.161     0.200
     7.693   154.243     0.200
     9.187   178.819     0.200
     4.808    99.412     0.200
     5.489   113.660     0.200
     4.819    97.644     0.200
     5.576   111.612     0.200
     3.733    80.198     0.200
     4.795    99.302     0.200
     5.476   114.357     0.200
     4.809    98.677     0.200
     6.680   139.046     0.200
     4.802    96.884     0.200
     5.481   113.663     0.200
     4.299    86.631     0.200
     5.799   119.626     0.200
     9.209   177.135     0.200
     9.226   188.073     0.200
     4.325    87.562     0.200
     6.873   133.332     0.200
     4.334    87.161     0.200
     7.703   154.529     0.200
     3.930    82.898     0.200
     9.241   186.574     0.200
     3.953    83.301     0.200
     7.729   155.291     0.200
     8.928   182.704     0.200
     9.221   179.812     0.200
     4.294    79.892     0.200
     7.720   154.922     0.200
     4.407    94.888     0.200
     2.531    48.092     0.200
     8.718   168.422     0.200
     9.612   198.622     0.200
     4.838   103.538     0.200
     2.887    60.158     0.200
     7.400   146.270     0.200
     5.689   118.547     0.200
     6.031   127.560     0.200
     6.182   123.815     0.200
     8.011   157.452     0.200
     8.848   171.730     0.200
     2.666    54.070     0.200
     9.992   203.262     0.200
     9.702   194.404     0.200
     9.708   188.712     0.200
     9.745   188.981     0.200
     4.369    88.379     0.200
     7.052   138.049     0.200
     8.834   180.341     0.200
     9.555   193.720     0.200
     6.448   126.683     0.200
     8.796   133.887     0.200
     9.540   191.801     0.200
     3.262    62.660     0.200
     3.770    74.223     0.200
     3.800    80.915     0.200
     3.926    78.403     0.200
     4.398    85.658     0.200
     4.846   102.669     0.200
     5.809   110.694     0.200
     5.957   126.174     0.200
     6.330   121.315     0.200
     6.560   124.231     0.200
     6.935   131.358     0.200
     7.132   136.854     0.200
     7.219   137.438     0.200
     7.752   117.515     0.200
     8.002   153.301     0.200
     8.244   156.583     0.200
     8.474   160.496     0.200
     8.464   223.414     0.200
     8.621   163.782     0.200
     8.814   135.221     0.200
     9.242   175.731     0.200
     9.300   176.954     0.200
     9.434   181.799     0.200
     9.561   190.608     0.200
     9.599   182.963     0.200
     9.607   183.069     0.200
     9.641   183.678     0.200
    10.788   208.893     0.200
    10.807   207.169     0.200
    11.446   221.212     0.200
     6.560   136.609     0.200
     9.567   194.618     0.200
     9.639   195.296     0.200
     9.815   197.708     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.580    12.172     0.200
     2.947    51.049     0.200
     3.862    66.869     0.200
     0.542    12.547     0.200
     2.943    52.030     0.200
     4.941    90.210     0.200
     8.882   156.213     0.200
     0.450    10.223     0.200
     0.691    14.409     0.200
     2.042    38.145     0.200
     2.499    44.314     0.200
     4.196    71.042     0.200
    10.562   187.752     0.200
     3.631    64.487     0.200
     2.135    40.628     0.200
     8.845   148.813     0.200
    10.281   214.061     0.200
     3.322    55.245     0.200
     4.111    69.437     0.200
     4.398    71.292     0.200
     4.895    86.495     0.200
     6.525   105.474     0.200
     9.756   171.761     0.200
    10.601   181.901     0.200
     0.899    20.253     0.200
     2.992    52.326     0.200
     4.125    72.110     0.200
     4.193    67.819     0.200
     0.615    15.077     0.200
     3.405    57.013     0.200
     7.352   122.427     0.200
     2.026    42.887     0.200
     2.212    39.814     0.200
    10.318   172.723     0.200
     0.664    16.019     0.200
     2.265    43.327     0.200
     3.617    62.354     0.200
     6.936   117.824     0.200
     7.314   121.408     0.200
     2.170    44.551     0.200
     2.070    39.089     0.200
     2.787    48.612     0.200
     3.326    56.027     0.200
     3.222    57.582     0.200
     3.399    57.518     0.200
     9.798   164.339     0.200
     0.701    16.774     0.200
     2.192    41.873     0.200
     5.888   107.245     0.200
     9.222   155.833     0.200
     2.022    37.128     0.200
     3.012    55.064     0.200
     3.745    68.012     0.200
     5.970   106.053     0.200
     7.335   132.619     0.200
     7.997   141.393     0.200
     0.090     3.496     0.200
     1.225    25.247     0.200
     1.294    25.951     0.200
     2.134    45.138     0.200
     2.236    41.950     0.200
     3.197    57.740     0.200
     5.494    90.639     0.200
     0.093     4.450     0.200
     1.289    24.497     0.200
     2.168    44.238     0.200
     2.343    45.191     0.200
     2.311    43.562     0.200
     2.465    44.764     0.200
     2.759    47.343     0.200
     4.168    71.793     0.200
     1.453    29.103     0.200
     1.260    26.084     0.200
     3.522    57.987     0.200
     0.377     9.571     0.200
     0.760    16.604     0.200
     1.226    23.736     0.200
     2.232    48.494     0.200
     2.254    51.277     0.200
     3.753    63.251     0.200
     3.753    68.852     0.200
     4.480    78.058     0.200
     9.182   153.895     0.200
     0.670    15.752     0.200
     1.862    34.520     0.200
     0.205     5.689     0.200
     1.254    25.642     0.200
     1.710    31.327     0.200
     1.918    35.107     0.200
     2.015    41.966     0.200
     0.600    13.425     0.200
     1.531    28.966     0.200
     1.453    30.468     0.200
     2.508    43.563     0.200
     2.675    45.314     0.200
     2.722    46.059     0.200
     2.959    48.995     0.200
     3.008    49.533     0.200
     0.733    16.914     0.200
     1.189    25.898     0.200
     0.707    15.190     0.200
     1.886    36.930     0.200
     1.363    24.396     0.200
     1.913    34.382     0.200
     1.366    24.817     0.200
     9.321   163.483     0.200
     0.349     9.429     0.200
     0.834    17.766     0.200
     9.832   163.660     0.200
     0.332     9.746     0.200
     0.628    14.800     0.200
     3.833    65.199     0.200
     0.661    15.344     0.200
     1.437    27.281     0.200
     1.459    27.025     0.200
     2.664    45.172     0.200
     2.825    46.988     0.200
     2.921    48.270     0.200
     3.029    49.704     0.200
     3.160    51.582     0.200
     0.572    13.703     0.200
     1.052    21.809     0.200
     1.179    23.830     0.200
     1.619    29.186     0.200
     1.727    30.828     0.200
     1.995    35.606     0.200
     4.655    82.262     0.200
     6.021   103.822     0.200
     9.693   165.177     0.200
     0.310     9.027     0.200
     6.671   112.993     0.200
     6.834   122.386     0.200
     0.683    15.682     0.200
     0.335     9.378     0.200
     0.722    17.164     0.200
     1.738    32.295     0.200
     3.100    55.603     0.200
     7.567   123.768     0.200
     8.565   142.802     0.200
     0.162     3.279     0.200
     0.627    13.549     0.200
     0.685    14.670     0.200
     0.704    15.853     0.200
     0.786    17.799     0.200
     0.787    17.187     0.200
     0.895    19.228     0.200
     2.414    42.794     0.200
     2.863    49.775     0.200
     3.317    57.806     0.200
     0.570    12.828     0.200
     0.629    13.239     0.200
     0.739    14.961     0.200
     1.575    31.008     0.200
     0.190     3.930     0.200
     0.647    15.291     0.200
     0.731    15.508     0.200
     0.922    20.987     0.200
     2.390    42.856     0.200
     2.551    46.727     0.200
     2.837    49.192     0.200
     3.290    55.777     0.200
     0.176     5.517     0.200
     0.522    11.384     0.200
     0.669    15.161     0.200
     0.834    16.738     0.200
     0.935    19.459     0.200
     2.394    40.979     0.200
     2.578    44.084     0.200
     4.118    75.722     0.200
     4.515    72.081     0.200
     0.187     6.807     0.200
     0.255     8.911     0.200
     0.764    15.372     0.200
     0.780    16.592     0.200
     1.082    21.660     0.200
     2.441    46.562     0.200
     2.673    46.271     0.200
     3.333    57.250     0.200
     3.382    59.356     0.200
     0.517    11.622     0.200
     0.499    11.982     0.200
     0.558    13.343     0.200
     0.732    16.808     0.200
     0.791    16.121     0.200
     0.840    19.423     0.200
     1.040    22.074     0.200
     0.448    10.514     0.200
     0.510    11.231     0.200
     1.189    24.919     0.200
     2.780    48.148     0.200
     2.955    51.045     0.200
     4.897    90.088     0.200
     5.776   105.629     0.200
     6.673   119.762     0.200
     6.875   123.309     0.200
     9.689   168.561     0.200
     0.482    10.862     0.200
     0.485    11.441     0.200
     0.722    16.973     0.200
     0.759    16.961     0.200
     0.418     9.708     0.200
     0.528    11.878     0.200
     0.514    12.186     0.200
     0.546    12.643     0.200
     1.269    25.320     0.200
     9.701   163.873     0.200
     0.585    12.653     0.200
     0.735    17.504     0.200
     0.862    18.335     0.200
     9.681   170.980     0.200
     0.518    12.370     0.200
     0.752    16.336     0.200
     0.810    18.095     0.200
     0.533    12.700     0.200
     0.806    18.489     0.200
     3.775    64.748     0.200
     0.502    11.864     0.200
     0.573    12.876     0.200
     0.813    18.854     0.200
     1.049    22.229     0.200
     0.458     9.524     0.200
     0.488    11.994     0.200
     0.505    12.451     0.200
     0.570    12.230     0.200
     0.721    17.396     0.200
     0.800    17.708     0.200
     0.779    18.817     0.200
     0.835    19.011     0.200
     1.031    22.652     0.200
     1.169    24.197     0.200
     0.469    10.450     0.200
     0.492    10.999     0.200
     0.583    12.649     0.200
     1.017    21.185     0.200
     0.421    10.152     0.200
     4.007    64.649     0.200
     4.502    80.457     0.200
     5.799   101.024     0.200
     6.899   113.492     0.200
     9.706   161.535     0.200
     0.391     8.717     0.200
     0.501    11.719     0.200
     0.573    12.177     0.200
     0.528    12.861     0.200
     0.766    16.822     0.200
     0.568    12.053     0.200
     0.525    12.154     0.200
     0.842    16.997     0.200
     0.502    10.585     0.200
     0.573    11.562     0.200
     0.847    18.763     0.200
     0.561    13.090     0.200
     0.771    18.365     0.200
     0.782    18.758     0.200
     1.463    28.960     0.200
     1.676    31.530     0.200
     0.509    11.107     0.200
     0.538    12.953     0.200
     0.566    14.540     0.200
     0.756    17.927     0.200
     0.774    18.507     0.200
     0.840    19.777     0.200
     0.516    12.026     0.200
     0.560    11.809     0.200
     0.777    17.261     0.200
     0.869    19.444     0.200
     1.079    21.942     0.200
     2.814    49.029     0.200
     2.986    51.627     0.200
     4.006    68.735     0.200
     4.521    79.679     0.200
     4.935    86.947     0.200
     9.172   153.900     0.200
     9.674   164.448     0.200
     0.534    13.590     0.200
     0.550    12.527     0.200
     0.528    12.207     0.200
     0.766    18.216     0.200
     0.878    18.326     0.200
     0.800    19.454     0.200
     0.513    11.297     0.200
     0.522    12.138     0.200
     0.561    12.642     0.200
     1.185    24.213     0.200
     1.645    29.509     0.200
     0.567    12.574     0.200
     0.549    13.160     0.200
     0.785    18.493     0.200
     0.839    18.322     0.200
     0.490    10.156     0.200
     0.584    13.986     0.200
     0.859    18.464     0.200
     3.019    49.786     0.200
     3.940    63.587     0.200
     9.694   162.258     0.200
     0.507    10.982     0.200
     0.529    12.058     0.200
     0.820    17.962     0.200
     1.174    24.183     0.200
     1.634    29.320     0.200
     3.788    61.832     0.200
     0.530    13.817     0.200
     0.541    14.329     0.200
     0.782    16.950     0.200
     0.764    18.596     0.200
     0.865    19.427     0.200
     0.392     8.553     0.200
     0.499    11.703     0.200
     0.575    14.140     0.200
     0.743    16.541     0.200
     0.852    19.218     0.200
     0.849    18.931     0.200
     9.218   153.967     0.200
     0.405     9.193     0.200
     0.516    11.441     0.200
     0.558    12.220     0.200
     0.752    17.255     0.200
     0.833    18.493     0.200
     0.394     8.898     0.200
     0.498    11.714     0.200
     0.850    19.259     0.200
     0.556    11.876     0.200
     0.518    13.392     0.200
     0.495    11.697     0.200
     0.787    18.010     0.200
     0.728    16.046     0.200
     0.793    17.850     0.200
     1.035    23.466     0.200
     0.492    11.841     0.200
     0.566    13.523     0.200
     0.724    16.405     0.200
     0.782    17.587     0.200
     0.837    18.813     0.200
     0.541    12.579     0.200
     0.574    13.294     0.200
     0.777    17.388     0.200
     1.075    22.964     0.200
     4.951    92.560     0.200
     9.685   161.719     0.200
     0.560    14.446     0.200
     0.756    17.472     0.200
     0.834    19.027     0.200
     3.802    63.890     0.200
     4.520    79.307     0.200
     0.425     9.864     0.200
     0.531    12.544     0.200
     0.544    12.256     0.200
     0.757    16.870     0.200
     0.817    18.863     0.200
     0.854    18.348     0.200
     1.061    22.602     0.200
     0.509    10.742     0.200
     0.461    12.224     0.200
     6.651   109.520     0.200
     9.688   160.079     0.200
     0.272     6.011     0.200
     0.401     9.070     0.200
     0.456    10.722     0.200
     0.514    11.476     0.200
     0.560    11.807     0.200
     0.561    11.419     0.200
     0.744    16.801     0.200
     0.829    18.100     0.200
     0.836    18.056     0.200
     1.127    21.959     0.200
     1.954    34.473     0.200
     0.425     8.626     0.200
     0.480    10.023     0.200
     0.533    11.870     0.200
     0.518    13.654     0.200
     0.548    10.618     0.200
     0.542    12.523     0.200
     0.581    11.835     0.200
     0.773    17.951     0.200
     0.816    18.774     0.200
     6.622   114.715     0.200
     7.484   122.460     0.200
     0.253     6.666     0.200
     0.461     9.815     0.200
     0.502    10.837     0.200
     0.530    11.076     0.200
     0.534    11.866     0.200
     0.562    11.541     0.200
     0.816    17.003     0.200
     1.039    21.799     0.200
     0.196     5.231     0.200
     0.471    10.412     0.200
     0.472    11.069     0.200
     0.556    13.708     0.200
     0.602    13.229     0.200
     4.536    78.378     0.200
     9.710   162.302     0.200
     0.372     7.965     0.200
     0.465    10.416     0.200
     0.482    11.396     0.200
     0.521    11.451     0.200
     0.592    13.863     0.200
     0.845    19.753     0.200
     0.867    18.598     0.200
     0.487    11.046     0.200
     0.536    11.902     0.200
     0.523    11.639     0.200
     0.587    12.504     0.200
     0.862    18.028     0.200
     0.431     9.601     0.200
     0.485    10.848     0.200
     0.537    12.117     0.200
     0.554    11.992     0.200
     0.538    13.024     0.200
     0.811    18.780     0.200
     1.058    24.160     0.200
     0.317     7.656     0.200
     0.472    10.165     0.200
     0.457    10.950     0.200
     0.521    12.097     0.200
     0.617    14.254     0.200
     0.799    18.478     0.200
     0.891    19.668     0.200
     0.316     8.681     0.200
     0.466    10.963     0.200
     0.455     9.905     0.200
     0.506    10.180     0.200
     4.315    73.092     0.200
     0.261     7.771     0.200
     0.467    11.301     0.200
     0.533    12.643     0.200
     0.839    18.466     0.200
     6.699   118.811     0.200
     6.901   113.456     0.200
     9.207   151.148     0.200
     0.285     6.685     0.200
     0.585    12.427     0.200
     0.859    18.630     0.200
     1.202    24.447     0.200
     0.286     6.398     0.200
     0.491    10.745     0.200
     0.537    12.232     0.200
     0.583    12.972     0.200
     0.858    18.679     0.200
     0.478    11.247     0.200
     0.544    13.007     0.200
     0.597    14.030     0.200
     0.782    17.565     0.200
     0.297     7.184     0.200
     0.371     8.475     0.200
     0.604    14.825     0.200
     0.878    19.837     0.200
     1.099    24.194     0.200
     0.054     3.483     0.200
     0.246     6.448     0.200
     0.424     9.369     0.200
     0.515    12.311     0.200
     0.533    12.306     0.200
     0.542    12.397     0.200
     0.759    17.182     0.200
     0.070     3.913     0.200
     6.704   141.398     0.200
     6.906   123.240     0.200
     9.703   163.100     0.200
     0.366     7.582     0.200
     0.600    14.845     0.200
     2.209    39.051     0.200
     2.403    41.628     0.200
     2.465    42.087     0.200
     2.674    44.840     0.200
     2.688    45.500     0.200
     0.234     7.008     0.200
     0.548    13.142     0.200
     0.505    11.545     0.200
     0.739    16.414     0.200
     2.397    41.917     0.200
     0.253     8.122     0.200
     0.400    10.408     0.200
     0.564    13.193     0.200
     0.743    15.903     0.200
     0.903    18.033     0.200
     1.185    21.843     0.200
     0.030     2.867     0.200
     0.444    11.043     0.200
     0.444    11.537     0.200
     0.488    10.617     0.200
     0.464    10.803     0.200
     0.518    11.679     0.200
     0.560    14.286     0.200
     0.793    18.368     0.200
     2.786    48.961     0.200
     2.964    51.395     0.200
     3.043    52.615     0.200
     3.245    55.753     0.200
     3.333    56.299     0.200
     0.155     6.267     0.200
     0.762    15.281     0.200
     0.819    16.921     0.200
     1.224    23.490     0.200
     1.655    30.280     0.200
     1.655    30.569     0.200
     1.988    34.672     0.200
     0.074     3.789     0.200
     0.418    11.372     0.200
     0.543    12.609     0.200
     1.073    23.227     0.200
     1.627    30.563     0.200
     2.136    41.528     0.200
     2.398    42.696     0.200
     0.440    10.892     0.200
     0.563    12.261     0.200
     0.393     9.076     0.200
     0.435    10.295     0.200
     0.536    13.413     0.200
     0.583    13.569     0.200
     0.583    12.654     0.200
     0.678    14.256     0.200
     0.729    15.354     0.200
     0.748    16.828     0.200
     0.815    17.756     0.200
     0.973    20.814     0.200
     1.084    22.814     0.200
     3.286    57.076     0.200
     3.400    57.565     0.200
     0.238     7.384     0.200
     0.363     9.926     0.200
     0.515    10.844     0.200
     0.599    14.369     0.200
     0.625    13.065     0.200
     0.726    15.383     0.200
     0.772    16.953     0.200
     0.787    17.170     0.200
     0.782    16.937     0.200
     2.260    39.383     0.200
     2.287    41.025     0.200
     2.457    42.501     0.200
     2.553    43.621     0.200
     2.739    46.220     0.200
     2.792    47.035     0.200
     2.826    46.671     0.200
     2.837    46.719     0.200
     9.029   153.541     0.200
     0.127     4.147     0.200
     0.177     4.260     0.200
     0.325     8.437     0.200
     0.351     8.334     0.200
     0.407     9.281     0.200
     0.075     5.090     0.200
     0.222     6.975     0.200
     0.304     9.019     0.200
     0.305     8.097     0.200
     0.392     9.082     0.200
     0.425     9.894     0.200
     0.410    10.375     0.200
     0.448     8.830     0.200
     0.499    11.837     0.200
     0.467    10.809     0.200
     0.696    14.637     0.200
     0.691    15.693     0.200
     0.842    18.536     0.200
     1.640    31.515     0.200
     2.442    42.208     0.200
     0.143     7.923     0.200
     0.199     8.660     0.200
     2.081    36.300     0.200
     2.269    39.210     0.200
     2.342    39.460     0.200
     2.543    42.717     0.200
     2.628    43.420     0.200
     2.628    43.420     0.200
     2.645    44.022     0.200
     0.261     9.135     0.200
     0.296     9.915     0.200
     0.374     9.614     0.200
     0.422    11.454     0.200
     0.532    13.470     0.200
     0.554    13.815     0.200
     0.562    13.115     0.200
     0.556    13.789     0.200
     0.623    14.409     0.200
     0.623    14.108     0.200
     0.626    13.971     0.200
     0.654    14.840     0.200
     0.803    16.998     0.200
     2.059    38.047     0.200
     2.863    48.462     0.200
     0.265     8.879     0.200
     0.299     9.682     0.200
     0.313    10.024     0.200
     0.374    11.516     0.200
     0.417    11.700     0.200
     0.534    13.339     0.200
     0.557    13.471     0.200
     0.558    14.057     0.200
     0.550    13.152     0.200
     0.616    14.284     0.200
     0.672    15.433     0.200
     0.658    14.998     0.200
     0.620    13.636     0.200
     0.697    15.543     0.200
     0.799    16.950     0.200
     0.833    17.448     0.200
     1.278    24.259     0.200
     0.045     5.313     0.200
     0.167     7.079     0.200
     0.232     7.422     0.200
     0.244     7.788     0.200
     0.298     8.155     0.200
     0.328     8.005     0.200
     0.394     8.935     0.200
     0.382     9.977     0.200
     0.449     9.891     0.200
     0.663    14.893     0.200
     0.708    15.768     0.200
     0.817    17.801     0.200
     0.921    19.584     0.200
     1.183    23.726     0.200
     2.820    47.127     0.200
     0.255     7.459     0.200
     0.298     8.857     0.200
     0.420     9.642     0.200
     0.539    12.448     0.200
     0.429    11.730     0.200
     0.454    11.638     0.200
     0.630    13.386     0.200
     0.697    15.306     0.200
     0.742    16.780     0.200
     0.781    16.827     0.200
     0.819    17.484     0.200
     0.810    17.281     0.200
     0.875    17.630     0.200
     0.856    18.654     0.200
     0.934    19.233     0.200
     1.344    24.751     0.200
     2.384    41.518     0.200
     2.649    45.524     0.200
     2.712    45.793     0.200
     2.795    47.325     0.200
     2.837    47.433     0.200
     2.851    47.870     0.200
     2.885    48.669     0.200
     2.934    48.301     0.200
     2.934    48.301     0.200
     0.218     6.939     0.200
     0.342     9.296     0.200
     0.366    10.115     0.200
     0.362     8.660     0.200
     0.532    10.583     0.200
     0.604    13.543     0.200
     0.747    15.476     0.200
     0.747    16.456     0.200
     0.789    17.316     0.200
     0.780    16.089     0.200
     0.780    17.040     0.200
     0.800    17.347     0.200
     0.870    18.336     0.200
     0.980    20.651     0.200
     2.267    39.729     0.200
     2.440    42.219     0.200
     2.533    43.532     0.200
     2.595    43.903     0.200
     2.627    44.530     0.200
     2.679    45.328     0.200
     2.721    45.434     0.200
     2.735    45.672     0.200
     2.771    46.255     0.200
     0.053     4.804     0.200
     0.256     7.742     0.200
     0.336     9.008     0.200
     0.314     8.458     0.200
     0.306     8.953     0.200
     0.426    10.160     0.200
     0.476    11.568     0.200
     0.540    12.523     0.200
     1.422    27.836     0.200
     2.927    51.669     0.200
     3.147    54.202     0.200
     3.170    54.028     0.200
     3.254    55.755     0.200
     3.306    55.848     0.200
     3.317    56.213     0.200
     3.371    56.689     0.200
     3.418    56.938     0.200
     3.443    57.748     0.200
     0.048     3.894     0.200
     0.116     3.153     0.200
     0.291     7.518     0.200
     0.261     7.769     0.200
     0.254     7.950     0.200
     0.370     8.889     0.200
     0.315     8.135     0.200
     0.343     9.710     0.200
     0.317     9.345     0.200
     0.423     9.479     0.200
     0.484    10.967     0.200
     0.551    12.683     0.200
     1.351    27.245     0.200
     2.662    48.139     0.200
     2.941    50.790     0.200
     2.970    52.146     0.200
     3.161    53.926     0.200
     3.268    55.576     0.200
     3.319    55.676     0.200
     3.331    56.138     0.200
     3.457    58.071     0.200
     0.039     3.751     0.200
     0.120     4.202     0.200
     0.312     8.259     0.200
     0.299     7.412     0.200
     0.256     7.709     0.200
     0.307     8.317     0.200
     0.375     7.930     0.200
     0.318     8.985     0.200
     0.412     9.193     0.200
     0.496    11.312     0.200
     0.564    12.820     0.200
     1.351    27.036     0.200
     2.417    42.994     0.200
     2.949    51.182     0.200
     3.168    54.227     0.200
     3.194    53.624     0.200
     3.276    55.370     0.200
     3.325    55.695     0.200
     3.338    56.247     0.200
     3.464    58.072     0.200
     0.063     5.829     0.200
     0.173     6.654     0.200
     0.216     7.363     0.200
     0.228     6.811     0.200
     0.291     7.486     0.200
     0.321     8.431     0.200
     0.429     9.570     0.200
     0.394    10.484     0.200
     0.451    10.621     0.200
     0.504    11.890     0.200
     0.513    11.485     0.200
     0.766    16.039     0.200
     2.069    36.042     0.200
     2.446    42.032     0.200
     2.493    43.547     0.200
     2.603    44.930     0.200
     2.897    48.670     0.200
     0.180     6.300     0.200
     0.289     6.986     0.200
     0.421    10.247     0.200
     0.507    10.759     0.200
     0.587    13.289     0.200
     0.990    19.156     0.200
     1.130    22.589     0.200
     1.851    35.198     0.200
     2.421    41.238     0.200
     9.968   169.601     0.200
    10.060   175.221     0.200
     0.176     5.560     0.200
     0.186     6.227     0.200
     0.181     6.200     0.200
     0.285     6.890     0.200
     0.300     7.465     0.200
     0.307     8.087     0.200
     0.385     8.698     0.200
     0.463    10.914     0.200
     0.521    11.571     0.200
     2.852    51.817     0.200
     2.887    48.890     0.200
     0.151     5.158     0.200
     0.196     6.205     0.200
     0.206     6.148     0.200
     0.284     7.097     0.200
     0.375     9.227     0.200
     0.385     9.605     0.200
     0.608    12.533     0.200
     1.872    35.947     0.200
     2.900    48.379     0.200
     0.144     5.045     0.200
     0.201     5.135     0.200
     0.213     6.229     0.200
     0.265     7.223     0.200
     0.337     9.028     0.200
     0.371     8.779     0.200
     0.387     9.708     0.200
     0.376     9.007     0.200
     0.679    15.391     0.200
     1.055    21.999     0.200
     1.993    36.057     0.200
     2.334    39.790     0.200
     0.046     4.211     0.200
     0.099     4.176     0.200
     0.192     5.717     0.200
     0.192     6.128     0.200
     0.174     5.976     0.200
     0.174     6.116     0.200
     0.204     6.436     0.200
     0.204     6.735     0.200
     0.285     7.926     0.200
     0.336     8.254     0.200
     0.336     7.244     0.200
     0.440    10.669     0.200
     0.780    15.641     0.200
     1.028    20.771     0.200
     1.742    33.613     0.200
     0.043     4.645     0.200
     0.186     6.064     0.200
     0.177     5.929     0.200
     0.198     7.123     0.200
     0.318     8.011     0.200
     0.293     7.991     0.200
     1.835    36.792     0.200
     0.139     5.932     0.200
     0.143     5.512     0.200
     0.230     7.555     0.200
     0.257     7.906     0.200
     0.334     8.839     0.200
     0.345     8.748     0.200
     0.371     9.122     0.200
     0.401     9.505     0.200
     0.445    10.445     0.200
     0.461    10.982     0.200
     0.480    10.749     0.200
     0.481    11.395     0.200
     0.528    11.971     0.200
     0.610    14.215     0.200
     0.729    15.596     0.200
     0.070     4.457     0.200
     0.117     5.480     0.200
     0.324     7.906     0.200
     0.351     8.493     0.200
     0.365     8.536     0.200
     0.475    10.805     0.200
     0.495    11.160     0.200
     0.541    11.495     0.200
     0.613    13.211     0.200
     0.681    15.371     0.200
     0.704    15.236     0.200
     2.162    45.395     0.200
     2.337    42.250     0.200
     9.702   166.404     0.200
     0.182     6.070     0.200
     0.290     8.155     0.200
     0.356     9.289     0.200
     0.375     9.401     0.200
     0.423    10.777     0.200
     0.418    10.678     0.200
     0.603    13.469     0.200
     0.612    14.238     0.200
     0.631    15.108     0.200
     0.680    15.121     0.200
     0.701    16.439     0.200
     0.700    16.110     0.200
     0.743    17.118     0.200
     0.848    18.581     0.200
     0.903    18.653     0.200
     0.912    18.282     0.200
     2.432    42.425     0.200
     2.618    44.750     0.200
     2.689    45.724     0.200
     2.760    46.489     0.200
     2.851    47.537     0.200
     2.885    48.136     0.200
     2.894    48.129     0.200
     2.911    48.432     0.200
     2.977    49.268     0.200
     2.992    49.390     0.200
     0.290     8.317     0.200
     0.359    10.007     0.200
     0.431    10.540     0.200
     0.440    10.508     0.200
     0.419    11.081     0.200
     0.605    13.194     0.200
     0.620    13.073     0.200
     0.623    13.597     0.200
     0.648    13.917     0.200
     0.695    14.836     0.200
     0.714    15.602     0.200
     0.761    16.085     0.200
     0.865    18.317     0.200
     0.906    19.049     0.200
     0.920    18.895     0.200
     0.953    19.893     0.200
     0.958    20.188     0.200
     1.010    20.420     0.200
     1.109    22.271     0.200
     1.301    25.311     0.200
     1.633    31.468     0.200
     1.625    32.292     0.200
     2.069    39.528     0.200
     2.061    37.341     0.200
     2.133    37.935     0.200
     0.061     6.032     0.200
     0.186     6.210     0.200
     0.241     6.700     0.200
     0.223     7.230     0.200
     0.301     8.226     0.200
     0.314     7.154     0.200
     0.381     9.308     0.200
     0.423     9.958     0.200
     0.420    10.063     0.200
     0.476    10.652     0.200
     0.514    10.741     0.200
     0.524    11.766     0.200
     0.569    12.622     0.200
     0.604    12.900     0.200
     0.658    13.662     0.200
     0.726    15.166     0.200
     0.719    16.407     0.200
     0.728    16.223     0.200
     0.039     3.165     0.200
     0.194     5.451     0.200
     0.239     7.634     0.200
     0.250     6.499     0.200
     0.311     7.594     0.200
     0.332     7.051     0.200
     0.338     7.668     0.200
     0.355     8.384     0.200
     0.404     9.312     0.200
     0.399    10.768     0.200
     0.421    11.008     0.200
     0.480    12.015     0.200
     0.510    10.598     0.200
     0.614    13.754     0.200
     0.724    16.564     0.200
     0.852    19.098     0.200
     1.262    25.384     0.200
     1.975    38.231     0.200
     0.029     3.261     0.200
     0.170     4.845     0.200
     0.222     6.345     0.200
     0.249     7.006     0.200
     0.295     7.382     0.200
     0.304     7.777     0.200
     0.338     8.473     0.200
     0.333     8.138     0.200
     0.390     9.244     0.200
     0.427     9.849     0.200
     0.453     9.734     0.200
     0.616    12.942     0.200
     0.733    15.677     0.200
     0.878    18.616     0.200
     0.990    20.070     0.200
     2.103    37.192     0.200
     2.142    37.216     0.200
     0.031     3.392     0.200
     0.244     6.600     0.200
     0.236     7.594     0.200
     0.303     8.017     0.200
     0.324     8.366     0.200
     0.355     8.507     0.200
     0.342     8.759     0.200
     0.406    10.411     0.200
     0.609    13.740     0.200
     2.081    37.065     0.200
     0.044     3.398     0.200
     0.192     4.486     0.200
     0.251     5.546     0.200
     0.245     7.744     0.200
     0.316     7.862     0.200
     0.334     8.109     0.200
     0.397    10.712     0.200
     0.410     9.305     0.200
     0.621    13.460     0.200
     0.032     3.585     0.200
     0.196     5.272     0.200
     0.233     7.339     0.200
     0.248     6.464     0.200
     0.303     7.223     0.200
     0.327     8.039     0.200
     0.345     8.527     0.200
     0.359     8.762     0.200
     0.396     8.834     0.200
     0.403    10.353     0.200
     0.607    13.474     0.200
     0.857    18.451     0.200
     2.077    36.837     0.200
     0.043     3.900     0.200
     0.169     5.573     0.200
     0.205     6.714     0.200
     0.246     6.717     0.200
     0.237     7.050     0.200
     0.314     7.753     0.200
     0.381     9.662     0.200
     0.453    10.615     0.200
     0.454    11.096     0.200
     0.528    11.649     0.200
     0.535    12.053     0.200
     0.522    11.810     0.200
     0.520    11.430     0.200
     0.520    12.134     0.200
     0.557    12.999     0.200
     0.624    13.017     0.200
     0.633    13.609     0.200
     0.668    14.099     0.200
     0.669    14.697     0.200
     0.663    14.634     0.200
     0.681    14.995     0.200
     0.709    16.219     0.200
     0.786    15.908     0.200
     0.889    18.526     0.200
     0.944    18.988     0.200
     1.181    23.717     0.200
     1.732    31.637     0.200
     2.887    49.254     0.200
     3.414    62.452     0.200
     0.033     3.843     0.200
     0.151     5.366     0.200
     0.193     5.378     0.200
     0.236     7.866     0.200
     0.246     6.852     0.200
     0.305     7.568     0.200
     0.327     8.025     0.200
     0.341     8.839     0.200
     0.355     8.676     0.200
     0.404    10.315     0.200
     0.682    15.666     0.200
     2.079    37.325     0.200
     2.118    37.065     0.200
     3.530    60.223     0.200
     0.135     5.847     0.200
     0.257     7.784     0.200
     0.249     7.611     0.200
     0.194     6.755     0.200
     0.330     9.402     0.200
     0.416    10.258     0.200
     0.501    10.963     0.200
     0.463    10.342     0.200
     0.561    12.774     0.200
     0.557    13.084     0.200
     0.487    11.495     0.200
     0.589    13.273     0.200
     0.568    12.695     0.200
     0.637    14.525     0.200
     0.771    16.021     0.200
     0.743    16.613     0.200
     0.764    17.188     0.200
     0.887    17.707     0.200
     2.758    46.311     0.200
     0.065     5.768     0.200
     0.173     6.756     0.200
     0.176     6.685     0.200
     0.234     7.038     0.200
     0.236     7.367     0.200
     0.304     8.515     0.200
     0.303     8.455     0.200
     0.368     9.990     0.200
     0.372     8.979     0.200
     0.455    11.318     0.200
     0.474    10.892     0.200
     0.489    10.259     0.200
     0.501    11.789     0.200
     0.574    12.478     0.200
     0.591    13.069     0.200
     0.620    13.159     0.200
     0.664    14.513     0.200
     0.721    16.019     0.200
     0.061     6.503     0.200
     0.164     6.833     0.200
     0.184     7.075     0.200
     0.227     7.195     0.200
     0.238     7.256     0.200
     0.300     8.837     0.200
     0.311     8.415     0.200
     0.373     9.282     0.200
     0.377     9.047     0.200
     0.419    10.250     0.200
     0.474    11.109     0.200
     0.464    10.929     0.200
     0.486    10.569     0.200
     0.527    11.383     0.200
     0.510    10.993     0.200
     0.569    12.497     0.200
     0.575    13.035     0.200
     0.601    12.732     0.200
     0.618    13.425     0.200
     0.712    14.435     0.200
     0.958    19.855     0.200
     0.921    19.676     0.200
     0.107     7.737     0.200
     0.196     7.813     0.200
     0.182     8.374     0.200
     0.325    10.406     0.200
     0.503    12.838     0.200
     0.669    14.992     0.200
     0.920    18.567     0.200
     0.861    17.454     0.200
     1.401    25.594     0.200
     2.656    45.868     0.200
     0.571    13.769     0.200
     0.761    16.055     0.200
     1.001    21.652     0.200
     1.003    21.928     0.200
     1.036    21.996     0.200
     0.082     4.909     0.200
     0.140     6.143     0.200
     0.207     6.578     0.200
     0.218     6.940     0.200
     0.306     7.650     0.200
     0.301     8.786     0.200
     0.344     8.347     0.200
     0.396     9.676     0.200
     0.337     8.838     0.200
     0.347     9.002     0.200
     0.420    10.127     0.200
     0.365    10.065     0.200
     0.402     9.943     0.200
     0.415    10.574     0.200
     0.476    11.386     0.200
     0.514    12.620     0.200
     0.689    15.140     0.200
     0.186     6.101     0.200
     0.231     7.495     0.200
     0.251     7.493     0.200
     0.454    10.458     0.200
     0.484    11.102     0.200
     0.534    12.389     0.200
     0.535    12.483     0.200
     0.678    15.549     0.200
     0.722    14.846     0.200
     0.913    18.307     0.200
     1.840    32.313     0.200
     9.555   157.720     0.200
     0.175     5.805     0.200
     0.206     6.847     0.200
     0.236     7.250     0.200
     0.260     7.196     0.200
     0.360     9.575     0.200
     0.468    10.619     0.200
     0.489    10.816     0.200
     0.528    11.355     0.200
     0.538    12.322     0.200
     0.533    11.033     0.200
     0.544    11.427     0.200
     0.566    12.417     0.200
     0.583    12.425     0.200
     0.631    13.585     0.200
     0.681    13.980     0.200
     0.681    14.840     0.200
     0.690    14.256     0.200
     0.717    14.655     0.200
     0.811    16.960     0.200
     0.912    18.304     0.200
     1.984    36.390     0.200
     2.349    41.020     0.200
     3.048    51.058     0.200
     3.182    53.203     0.200
     7.733   132.393     0.200
     9.042   187.797     0.200
     9.540   161.801     0.200
     0.189     5.945     0.200
     0.227     7.439     0.200
     0.185     6.274     0.200
     0.249     6.495     0.200
     0.341     9.706     0.200
     0.324     9.006     0.200
     0.447    10.767     0.200
     0.535    12.949     0.200
     0.531    12.392     0.200
     0.524    11.677     0.200
     0.531    11.788     0.200
     0.565    12.996     0.200
     0.610    13.752     0.200
     0.721    14.895     0.200
     0.721    14.677     0.200
     0.680    14.109     0.200
     0.680    14.930     0.200
     0.827    18.096     0.200
     1.837    33.753     0.200
     1.974    36.699     0.200
     4.373    74.628     0.200
     8.005   142.164     0.200
     9.561   158.608     0.200
     0.171     5.505     0.200
     0.214     6.568     0.200
     0.200     6.412     0.200
     0.269     7.242     0.200
     0.341     8.682     0.200
     0.467    10.387     0.200
     0.453    10.831     0.200
     0.525    11.654     0.200
     0.562    12.152     0.200
     0.549    12.355     0.200
     0.619    13.800     0.200
     2.371    40.957     0.200
     2.954    49.556     0.200
     0.205     5.547     0.200
     0.178     6.471     0.200
     0.245     7.919     0.200
     0.231     6.671     0.200
     0.318     9.334     0.200
     0.349     9.408     0.200
     0.449    10.930     0.200
     0.495    11.088     0.200
     0.549    12.618     0.200
     0.574    12.612     0.200
     0.660    14.121     0.200
     0.740    15.697     0.200
     7.746   134.769     0.200
     9.567   161.618     0.200
     0.179     6.387     0.200
     0.249     6.993     0.200
     0.353     9.371     0.200
     0.320     9.474     0.200
     0.207     7.067     0.200
     0.229     6.879     0.200
     0.451    10.616     0.200
     0.500    11.162     0.200
     0.533    11.981     0.200
     0.509    11.601     0.200
     0.557    12.401     0.200
     0.508    10.366     0.200
     0.190     6.218     0.200
     0.236     6.717     0.200
     0.251     7.439     0.200
     0.331    10.180     0.200
     0.361     9.946     0.200
     0.462    10.776     0.200
     0.503    10.898     0.200
     0.510    10.708     0.200
     0.552    11.837     0.200
     0.555    12.394     0.200
     0.659    13.972     0.200
     0.740    15.130     0.200
     0.788    17.268     0.200
     0.859    18.034     0.200
     0.875    17.256     0.200
     0.933    18.482     0.200
     0.089     6.143     0.200
     0.128     6.204     0.200
     0.228     6.825     0.200
     0.270     7.532     0.200
     0.368    10.292     0.200
     0.383     9.214     0.200
     0.492    10.938     0.200
     0.524    12.061     0.200
     0.550    12.068     0.200
     0.533    11.565     0.200
     0.655    13.241     0.200
     0.680    14.444     0.200
     0.713    14.757     0.200
     0.810    16.725     0.200
     0.837    17.208     0.200
     0.910    18.556     0.200
     0.972    19.336     0.200
     0.966    19.211     0.200
     0.990    19.332     0.200
     1.121    21.904     0.200
     1.256    24.028     0.200
     0.089     4.625     0.200
     0.113     5.513     0.200
     0.126     5.467     0.200
     0.199     6.040     0.200
     0.183     5.940     0.200
     0.253     7.121     0.200
     0.339     8.911     0.200
     0.358     8.393     0.200
     0.464    11.351     0.200
     0.491    11.351     0.200
     0.541    12.057     0.200
     0.541    12.797     0.200
     0.534    12.430     0.200
     0.527    10.987     0.200
     0.581    12.586     0.200
     0.685    14.769     0.200
     0.723    14.635     0.200
     0.860    17.790     0.200
     0.871    18.908     0.200
     0.962    20.640     0.200
     0.988    20.232     0.200
     1.022    21.536     0.200
     1.232    24.289     0.200
     1.344    26.981     0.200
     1.437    28.490     0.200
     1.624    29.012     0.200
     0.087     4.269     0.200
     0.120     4.886     0.200
     0.117     4.818     0.200
     0.199     5.265     0.200
     0.184     6.239     0.200
     0.243     6.954     0.200
     0.237     6.623     0.200
     0.324     8.800     0.200
     0.453    10.897     0.200
     0.494    11.020     0.200
     0.515    11.336     0.200
     0.548    11.593     0.200
     0.516    11.770     0.200
     0.547    11.703     0.200
     0.675    14.095     0.200
     0.665    13.917     0.200
     0.675    14.485     0.200
     0.736    14.503     0.200
     0.714    15.913     0.200
     0.794    17.255     0.200
     0.796    17.104     0.200
     0.859    18.441     0.200
     0.868    17.261     0.200
     0.896    17.832     0.200
     0.855    18.109     0.200
     0.927    18.270     0.200
     0.943    19.348     0.200
     0.973    18.735     0.200
     0.946    19.846     0.200
     0.090     4.613     0.200
     0.114     5.348     0.200
     0.120     5.240     0.200
     0.190     5.608     0.200
     0.194     5.644     0.200
     0.242     7.224     0.200
     0.245     6.914     0.200
     0.357    10.255     0.200
     0.461    10.866     0.200
     0.494    11.337     0.200
     0.521    10.740     0.200
     0.541    12.238     0.200
     0.545    12.772     0.200
     0.068     4.147     0.200
     0.142     4.365     0.200
     0.134     4.989     0.200
     0.148     5.466     0.200
     0.187     5.859     0.200
     0.207     6.176     0.200
     0.249     6.455     0.200
     0.331     8.430     0.200
     0.337     8.239     0.200
     0.332     8.442     0.200
     0.333     9.094     0.200
     0.371     9.788     0.200
     0.364     8.368     0.200
     0.379     9.251     0.200
     0.353     9.337     0.200
     0.375     8.742     0.200
     0.464    10.788     0.200
     0.432     9.436     0.200
     0.443     9.754     0.200
     0.478    10.438     0.200
     0.491    11.234     0.200
     0.477    11.318     0.200
     0.516    11.997     0.200
     0.600    14.063     0.200
     0.080     3.577     0.200
     0.135     4.994     0.200
     0.133     4.946     0.200
     0.188     5.008     0.200
     0.198     5.755     0.200
     0.346     8.114     0.200
     0.351     8.472     0.200
     0.325     8.819     0.200
     0.325     9.014     0.200
     0.332     8.954     0.200
     0.345     9.362     0.200
     0.368     8.931     0.200
     0.352     8.521     0.200
     0.373     9.417     0.200
     0.365     9.004     0.200
     0.451     9.960     0.200
     0.419     9.369     0.200
     0.462    11.436     0.200
     0.529    11.293     0.200
     0.081     3.873     0.200
     0.141     5.199     0.200
     0.200     5.529     0.200
     0.122     5.387     0.200
     0.213     5.709     0.200
     0.251     6.659     0.200
     0.341     7.902     0.200
     0.366     8.574     0.200
     0.388     9.205     0.200
     0.380     8.790     0.200
     0.318     8.724     0.200
     0.318     8.687     0.200
     0.325     8.594     0.200
     0.339     9.029     0.200
     0.433     9.545     0.200
     0.436     9.820     0.200
     0.478    10.415     0.200
     0.081     4.906     0.200
     0.125     5.115     0.200
     0.148     4.748     0.200
     0.197     5.885     0.200
     0.209     6.662     0.200
     0.248     6.592     0.200
     0.302     8.150     0.200
     0.344     7.766     0.200
     0.319     9.850     0.200
     0.320     8.746     0.200
     0.327     9.460     0.200
     0.363     9.824     0.200
     0.363     9.165     0.200
     0.378    10.197     0.200
     0.376     9.551     0.200
     0.384     9.897     0.200
     0.440    10.346     0.200
     0.430     9.764     0.200
     0.474    12.453     0.200
     0.042     3.420     0.200
     0.082     3.896     0.200
     0.090     3.563     0.200
     0.095     3.844     0.200
     0.113     3.533     0.200
     0.135     4.424     0.200
     0.169     5.687     0.200
     0.210     6.634     0.200
     0.250     7.633     0.200
     0.261     6.609     0.200
     0.314     7.589     0.200
     0.312     8.931     0.200
     0.341     7.782     0.200
     0.387     9.535     0.200
     0.470    11.074     0.200
     3.448    62.365     0.200
     0.111     6.888     0.200
     0.156     6.866     0.200
     0.186     7.314     0.200
     0.203     7.716     0.200
     0.209     7.443     0.200
     0.242     7.262     0.200
     0.253     7.808     0.200
     0.253     8.239     0.200
     0.384    10.410     0.200
     0.441    10.144     0.200
     0.574    14.084     0.200
     0.677    14.391     0.200
     0.746    15.885     0.200
     0.749    17.142     0.200
     0.764    16.766     0.200
     1.010    20.168     0.200
     1.517    29.469     0.200
     2.557    45.250     0.200
     3.204    54.173     0.200
     0.030     3.321     0.200
     0.115     2.829     0.200
     0.183     5.825     0.200
     0.180     4.967     0.200
     0.195     5.394     0.200
     0.228     5.412     0.200
     0.332     8.897     0.200
     0.353     8.942     0.200
     0.514    11.863     0.200
     0.512    12.796     0.200
     0.070     6.228     0.200
     0.213     6.871     0.200
     0.225     6.425     0.200
     0.230     7.070     0.200
     0.234     6.819     0.200
     0.290     8.558     0.200
     0.314     8.586     0.200
     0.322     8.596     0.200
     0.324     7.571     0.200
     0.330     9.004     0.200
     0.337     9.024     0.200
     0.352     7.943     0.200
     0.370     8.724     0.200
     0.364     9.099     0.200
     0.416    10.598     0.200
     0.411    11.158     0.200
     0.435     9.470     0.200
     0.446    10.543     0.200
     0.462    10.360     0.200
     0.459    11.467     0.200
     0.485    10.793     0.200
     0.515    10.838     0.200
     0.531    12.153     0.200
     0.524    11.232     0.200
     0.534    11.124     0.200
     0.535    10.401     0.200
     0.570    12.497     0.200
     0.563    13.817     0.200
     0.580    11.783     0.200
     0.570    13.601     0.200
     0.600    13.454     0.200
     0.611    14.226     0.200
     0.658    13.868     0.200
     0.650    14.525     0.200
     0.653    13.836     0.200
     0.654    14.928     0.200
     0.679    15.031     0.200
     0.710    16.069     0.200
     0.706    15.427     0.200
     0.698    15.108     0.200
     0.771    16.553     0.200
     0.819    17.753     0.200
     0.821    16.265     0.200
     0.825    17.940     0.200
     0.829    18.171     0.200
     2.817    47.082     0.200
     9.815   170.708     0.200
     0.135     4.602     0.200
     0.170     5.701     0.200
     0.170     4.918     0.200
     0.209     6.265     0.200
     0.241     6.995     0.200
     0.344     8.596     0.200
     0.383     8.645     0.200
     0.406     8.673     0.200
     0.442    10.377     0.200
     0.474    11.078     0.200
     0.102     4.923     0.200
     0.234     5.679     0.200
     0.296     7.961     0.200
     0.315     7.635     0.200
     0.331     8.048     0.200
     0.340     7.850     0.200
     0.364     8.769     0.200
     0.404    10.197     0.200
     0.404     9.807     0.200
     0.409    10.045     0.200
     0.405     9.292     0.200
     0.424     9.971     0.200
     0.424    10.072     0.200
     0.462    10.619     0.200
     0.484    10.563     0.200
     0.500    10.473     0.200
     0.503    11.437     0.200
     0.509    11.274     0.200
     0.523    12.013     0.200
     0.588    13.157     0.200
     0.658    13.635     0.200
     0.691    14.048     0.200
     1.117    23.157     0.200
     2.330    41.017     0.200
     0.169     6.900     0.200
     0.233     7.966     0.200
     0.226     8.143     0.200
     0.237     7.424     0.200
     0.242     7.760     0.200
     0.270     7.933     0.200
     0.262     6.931     0.200
     0.310     8.969     0.200
     0.339     8.930     0.200
     0.353     8.067     0.200
     0.397     9.952     0.200
     0.406    10.040     0.200
     0.413     9.460     0.200
     0.461    11.607     0.200
     0.513    12.103     0.200
     0.518    11.336     0.200
     0.537    12.324     0.200
     0.533    12.563     0.200
     0.632    13.253     0.200
     0.646    13.143     0.200
     0.654    13.553     0.200
     0.678    14.174     0.200
     0.705    15.161     0.200
     0.705    15.054     0.200
     0.706    14.745     0.200
     0.803    16.796     0.200
     0.803    18.186     0.200
     1.288    25.083     0.200
     1.998    38.872     0.200
     2.667    44.865     0.200
     3.281    56.411     0.200
     4.180    68.752     0.200
     9.721   166.542     0.200
     0.076     4.285     0.200
     0.049     4.907     0.200
     0.094     5.078     0.200
     0.094     5.298     0.200
     0.177     6.320     0.200
     0.177     6.090     0.200
     0.231     6.890     0.200
     0.231     6.260     0.200
     0.233     7.356     0.200
     0.240     6.978     0.200
     0.317     9.686     0.200
     0.317     8.526     0.200
     0.317     8.686     0.200
     0.345     9.852     0.200
     0.363     8.345     0.200
     0.363     7.955     0.200
     0.412    10.075     0.200
     0.445    11.282     0.200
     0.474    11.404     0.200
     0.491    11.054     0.200
     0.515    11.070     0.200
     0.515    11.790     0.200
     0.509    13.343     0.200
     0.509    12.393     0.200
     0.551    12.151     0.200
     0.544    12.427     0.200
     0.568    13.453     0.200
     0.568    12.013     0.200
     0.570    12.829     0.200
     0.605    13.721     0.200
     0.626    14.870     0.200
     0.664    13.868     0.200
     0.664    14.328     0.200
     0.737    15.341     0.200
     0.737    15.181     0.200
     0.746    15.976     0.200
     0.750    15.634     0.200
     0.793    17.316     0.200
     1.822    32.586     0.200
     1.899    37.575     0.200
     1.958    36.482     0.200
     2.559    47.356     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
