#!/bin/bash
gmt begin larino1.84_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance larino1.84'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6  0.000
  0.6 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.900    18.364
     1.000    19.738
     1.100    21.112
     1.200    22.486
     1.300    23.860
     1.400    25.233
     1.500    26.607
     1.600    27.981
     1.700    29.355
     1.800    30.729
     1.900    32.102
     2.000    33.476
     2.100    34.850
     2.200    36.224
     2.300    37.598
     2.400    38.971
     2.500    40.345
     2.600    41.719
     2.700    43.093
     2.800    44.466
     2.900    45.840
     3.000    47.214
     3.100    48.588
     3.200    49.962
     3.300    51.335
     3.400    52.709
     3.500    54.082
     3.600    55.456
     3.700    56.829
     3.800    58.202
     3.900    59.575
     4.000    60.949
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    53.456 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.301
     0.200     4.655
     0.300     6.253
     0.400     7.882
     0.500     9.512
     0.600    11.143
     0.700    12.774
     0.800    14.405
     0.900    16.036
     1.000    17.668
     1.200    20.930
     1.300    22.561
     1.400    24.192
     1.500    25.823
     1.600    27.454
     1.700    29.085
     1.800    30.716
     1.900    32.347
     2.000    33.978
     2.100    35.609
     2.200    37.240
     2.300    38.872
     2.400    40.503
     2.500    42.134
     2.600    43.765
     2.700    45.396
     2.800    47.027
     2.900    48.658
     3.000    50.288
     3.100    51.919
     3.200    53.550
     3.300    55.180
     3.400    56.811
     3.500    58.442
     3.600    60.072
     3.700    61.703
     3.800    63.333
     3.900    64.964
     4.000    66.594
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    59.072 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.900    32.272
     1.000    34.673
     1.100    37.074
     1.200    39.475
     1.300    41.876
     1.400    44.277
     1.500    46.679
     1.600    49.080
     1.700    51.481
     1.800    53.882
     1.900    56.283
     2.000    58.684
     2.100    61.086
     2.200    63.487
     2.300    65.888
     2.400    68.289
     2.500    70.690
     2.600    73.091
     2.700    75.493
     2.800    77.894
     2.900    80.295
     3.000    82.696
     3.100    85.097
     3.200    87.498
     3.300    89.900
     3.400    92.301
     3.500    94.702
     3.600    97.102
     3.700    99.503
     3.800   101.903
     3.900   104.303
     4.000   106.704
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    95.102 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.972
     0.200     8.411
     0.300    11.226
     0.400    14.067
     0.500    16.910
     0.600    19.754
     0.700    22.597
     0.800    25.442
     0.900    28.286
     1.000    31.130
     1.100    33.973
     1.200    36.817
     1.300    39.661
     1.400    42.505
     1.500    45.349
     1.600    48.193
     1.700    51.037
     1.800    53.881
     1.900    56.725
     2.000    59.568
     2.100    62.412
     2.200    65.256
     2.300    68.100
     2.400    70.944
     2.500    73.788
     2.600    76.632
     2.700    79.476
     2.800    82.320
     2.900    85.163
     3.000    88.006
     3.100    90.849
     3.200    93.693
     3.300    96.536
     3.400    99.379
     3.500   102.222
     3.600   105.066
     3.700   107.909
     3.800   110.752
     3.900   113.594
     4.000   116.437
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   104.066 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    22.615
     1.200    23.988
     1.300    25.362
     1.400    26.736
     1.500    28.110
     1.600    29.484
     1.700    30.857
     1.800    32.231
     1.900    33.605
     2.000    34.979
     2.100    36.352
     2.200    37.726
     2.300    39.100
     2.400    40.474
     2.500    41.847
     2.600    43.221
     2.700    44.595
     2.800    45.969
     2.900    47.343
     3.000    48.716
     3.100    50.090
     3.200    51.464
     3.300    52.838
     3.400    54.211
     3.500    55.585
     3.600    56.959
     3.700    58.332
     3.800    59.705
     3.900    61.079
     4.000    62.452
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.985
     0.200     3.868
     0.300     5.773
     0.400     7.684
     0.500     9.597
     0.600    11.512
     0.700    13.427
     0.800    15.342
     0.900    17.119
     1.000    18.750
     1.100    20.381
     1.200    22.013
     1.300    23.644
     1.400    25.275
     1.500    26.906
     1.600    28.538
     1.700    30.169
     1.800    31.800
     1.900    33.432
     2.000    35.063
     2.100    36.694
     2.200    38.325
     2.300    39.957
     2.400    41.588
     2.500    43.219
     2.600    44.850
     2.700    46.482
     2.800    48.113
     2.900    49.744
     3.000    51.374
     3.100    53.005
     3.200    54.636
     3.300    56.267
     3.400    57.898
     3.500    59.528
     3.600    61.159
     3.700    62.790
     3.800    64.421
     3.900    66.051
     4.000    67.682
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.100    39.888
     1.200    42.289
     1.300    44.690
     1.400    47.091
     1.500    49.493
     1.600    51.894
     1.700    54.295
     1.800    56.696
     1.900    59.097
     2.000    61.498
     2.100    63.899
     2.200    66.301
     2.300    68.702
     2.400    71.103
     2.500    73.504
     2.600    75.905
     2.700    78.306
     2.800    80.707
     2.900    83.109
     3.000    85.510
     3.100    87.911
     3.200    90.312
     3.300    92.713
     3.400    95.114
     3.500    97.515
     3.600    99.916
     3.700   102.317
     3.800   104.717
     3.900   107.118
     4.000   109.518
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.598
     0.200     7.011
     0.300    10.464
     0.400    13.928
     0.500    17.395
     0.600    20.865
     0.700    24.336
     0.800    27.589
     0.900    30.433
     1.000    33.277
     1.100    36.121
     1.200    38.966
     1.300    41.810
     1.400    44.654
     1.500    47.498
     1.600    50.343
     1.700    53.187
     1.800    56.031
     1.900    58.875
     2.000    61.720
     2.100    64.564
     2.200    67.408
     2.300    70.253
     2.400    73.097
     2.500    75.941
     2.600    78.785
     2.700    81.628
     2.800    84.473
     2.900    87.316
     3.000    90.160
     3.100    93.003
     3.200    95.847
     3.300    98.690
     3.400   101.534
     3.500   104.377
     3.600   107.221
     3.700   110.064
     3.800   112.907
     3.900   115.750
     4.000   118.593
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    12.567
     0.700    13.941
     0.800    15.315
     0.900    16.689
     1.000    18.062
     1.100    19.436
     1.200    20.810
     1.300    22.184
     1.400    23.557
     1.500    24.931
     1.600    26.305
     1.700    27.679
     1.800    29.052
     1.900    30.426
     2.000    31.800
     2.100    33.174
     2.200    34.548
     2.300    35.921
     2.400    37.295
     2.500    38.669
     2.600    40.043
     2.700    41.416
     2.800    42.790
     2.900    44.164
     3.000    45.538
     3.100    46.911
     3.200    48.285
     3.300    49.658
     3.400    51.032
     3.500    52.405
     3.600    53.778
     3.700    55.152
     3.800    56.525
     3.900    57.898
     4.000    59.271
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     6.076
     0.200     6.779
     0.300     7.809
     0.400     9.049
     0.500    10.419
     0.600    11.871
     0.700    13.374
     0.800    14.911
     0.900    16.470
     1.000    18.045
     1.100    19.631
     1.200    21.224
     1.300    22.824
     1.400    24.429
     1.500    26.036
     1.600    27.647
     1.700    29.260
     1.800    30.876
     1.900    32.492
     2.000    34.110
     2.100    35.729
     2.200    37.348
     2.300    38.969
     2.400    40.590
     2.500    42.212
     2.600    43.834
     2.700    45.457
     2.800    47.080
     2.900    48.704
     3.000    50.328
     3.100    51.952
     3.200    53.576
     3.300    55.200
     3.400    56.825
     3.500    58.450
     3.600    60.075
     3.700    61.700
     3.800    63.325
     3.900    64.951
     4.000    66.576
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.600    22.164
     0.700    24.565
     0.800    26.966
     0.900    29.368
     1.000    31.769
     1.100    34.170
     1.200    36.571
     1.300    38.972
     1.400    41.373
     1.500    43.774
     1.600    46.176
     1.700    48.577
     1.800    50.978
     1.900    53.379
     2.000    55.780
     2.100    58.181
     2.200    60.582
     2.300    62.984
     2.400    65.385
     2.500    67.786
     2.600    70.187
     2.700    72.588
     2.800    74.989
     2.900    77.390
     3.000    79.792
     3.100    82.193
     3.200    84.594
     3.300    86.994
     3.400    89.395
     3.500    91.795
     3.600    94.195
     3.700    96.596
     3.800    98.996
     3.900   101.397
     4.000   103.797
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100    10.778
     0.200    12.021
     0.300    13.836
     0.400    16.019
     0.500    18.427
     0.600    20.973
     0.700    23.605
     0.800    26.293
     0.900    29.017
     1.000    31.767
     1.100    34.536
     1.200    37.317
     1.300    40.108
     1.400    42.908
     1.500    45.712
     1.600    48.522
     1.700    51.335
     1.800    54.152
     1.900    56.971
     2.000    59.792
     2.100    62.615
     2.200    65.440
     2.300    68.266
     2.400    71.093
     2.500    73.921
     2.600    76.750
     2.700    79.580
     2.800    82.410
     2.900    85.240
     3.000    88.072
     3.100    90.904
     3.200    93.736
     3.300    96.568
     3.400    99.402
     3.500   102.235
     3.600   105.068
     3.700   107.901
     3.800   110.735
     3.900   113.569
     4.000   116.403
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     3.002   109.484     0.150
     3.086   110.586     0.150
     3.054   109.742     0.150
     3.135   110.641     0.150
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.897    30.941     0.200
     2.932    43.941     0.200
     3.434    55.141     0.200
     3.459    54.340     0.200
     3.634    56.543     0.200
     3.743    58.941     0.200
     3.905    60.941     0.200
     4.020    59.441     0.200
     4.127    64.941     0.200
     4.840    71.543     0.200
     4.865    74.043     0.200
     4.933    73.441     0.200
     5.565    82.840     0.200
     6.371    95.941     0.200
     6.646    97.742     0.200
     6.655    96.441     0.200
     6.645    96.941     0.200
     6.717    96.941     0.200
     6.748    98.441     0.200
     6.748   100.941     0.200
     6.855    99.340     0.200
     7.193   106.641     0.200
     7.220   106.941     0.200
     7.332   106.043     0.200
     7.426   109.941     0.200
     7.537   112.941     0.200
     7.916   115.941     0.200
     7.949   115.641     0.200
     8.074   115.441     0.200
     8.385   124.941     0.200
     8.839   127.941     0.200
     8.872   127.941     0.200
     8.981   128.340     0.200
     9.058   132.941     0.200
     9.113   130.941     0.200
     9.145   131.043     0.200
     9.266   132.742     0.200
     9.781   139.141     0.200
     9.818   140.941     0.200
     9.818   143.941     0.200
    10.284   145.941     0.200
    10.464   152.340     0.200
    20.292   279.941     0.200
     2.769    46.869     0.200
     2.943    48.369     0.200
     4.389    67.969     0.200
     4.680    70.770     0.200
     4.797    71.869     0.200
     4.941    76.069     0.200
     4.917    75.469     0.200
     4.917    76.469     0.200
     5.111    75.869     0.200
     5.546    82.669     0.200
     5.721    86.469     0.200
     6.424    96.369     0.200
     6.614    96.669     0.200
     6.675    97.469     0.200
     6.756   100.969     0.200
     6.778   100.270     0.200
     6.813    99.869     0.200
     7.861   115.869     0.200
     7.967   115.869     0.200
     8.080   115.770     0.200
     8.168   118.869     0.200
     8.882   127.770     0.200
     8.978   129.469     0.200
     9.126   131.869     0.200
     9.106   134.869     0.200
     9.244   133.069     0.200
     9.790   139.469     0.200
     9.818   140.869     0.200
    10.290   148.569     0.200
     1.260    21.473     0.200
     1.457    24.172     0.200
     1.719    26.973     0.200
     2.042    33.273     0.200
     2.176    33.672     0.200
     3.177    50.473     0.200
     3.923    61.672     0.200
     4.002    58.773     0.200
     4.172    64.273     0.200
     4.213    62.273     0.200
     5.109    74.473     0.200
     5.451    80.273     0.200
     5.874    85.973     0.200
     6.330    93.473     0.200
     6.585    98.273     0.200
     6.805   101.273     0.200
     7.099   100.973     0.200
     7.365   104.973     0.200
     7.476   106.473     0.200
     8.403   118.473     0.200
     8.504   118.672     0.200
     8.586   120.973     0.200
     8.670   122.371     0.200
     8.843   124.773     0.200
     9.598   134.371     0.200
     9.805   137.273     0.200
     9.893   138.273     0.200
     9.919   138.473     0.200
     2.154    35.008     0.200
     3.513    52.508     0.200
     3.981    62.609     0.200
     3.979    63.211     0.200
     4.319    66.008     0.200
     4.196    67.508     0.200
     4.766    73.008     0.200
     4.965    73.109     0.200
     5.085    73.906     0.200
     5.532    84.008     0.200
     5.812    85.008     0.200
     5.871    86.508     0.200
     5.865    90.805     0.200
     6.440    95.008     0.200
     6.878   101.008     0.200
     7.020   102.211     0.200
     6.947    99.609     0.200
     6.969    99.609     0.200
     7.066   105.406     0.200
     7.109   102.305     0.200
     7.146   106.008     0.200
     8.351   119.508     0.200
     8.449   119.211     0.200
     9.138   130.211     0.200
     9.144   131.008     0.200
     9.237   131.406     0.200
     9.275   132.211     0.200
     9.451   134.609     0.200
     9.571   136.711     0.200
    10.052   143.008     0.200
    10.107   147.008     0.200
    10.505   150.008     0.200
    10.562   150.008     0.200
    11.877   169.211     0.200
    19.317   265.305     0.200
    20.505   279.008     0.200
     1.603    28.758     0.200
     2.264    37.258     0.200
     2.568    42.359     0.200
     3.041    48.258     0.200
     3.125    52.758     0.200
     3.300    52.758     0.200
     3.401    55.258     0.200
     3.574    54.961     0.200
     3.631    57.859     0.200
     3.892    60.758     0.200
     3.953    62.156     0.200
     4.084    63.055     0.200
     4.087    65.156     0.200
     4.670    70.758     0.200
     5.197    76.461     0.200
     5.428    80.758     0.200
     6.545    96.258     0.200
     6.894    99.258     0.200
     7.080   102.555     0.200
     7.059   103.359     0.200
     7.035   104.258     0.200
     7.220   104.156     0.200
     7.237   105.258     0.200
     8.395   120.258     0.200
     8.395   122.461     0.200
     8.481   122.258     0.200
     8.988   131.258     0.200
     9.172   131.758     0.200
     9.233   132.258     0.200
     9.327   133.055     0.200
     9.461   137.258     0.200
     9.484   136.461     0.200
     9.661   136.656     0.200
    10.026   149.258     0.200
    10.018   144.258     0.200
    10.160   145.258     0.200
    11.422   164.258     0.200
    20.508   281.258     0.200
     2.378    37.539     0.200
     3.191    51.242     0.200
     3.363    53.836     0.200
     3.474    54.039     0.200
     3.780    59.641     0.200
     3.818    58.742     0.200
     3.858    59.938     0.200
     4.070    62.242     0.200
     4.031    63.039     0.200
     4.594    70.039     0.200
     4.628    72.539     0.200
     4.698    70.438     0.200
     4.919    74.039     0.200
     5.690    83.539     0.200
     5.722    85.539     0.200
     6.363    95.039     0.200
     6.569    97.039     0.200
     6.734    99.539     0.200
     7.011   101.539     0.200
     8.070   116.641     0.200
     8.184   122.039     0.200
     8.425   120.742     0.200
     8.299   120.141     0.200
     8.845   128.539     0.200
     9.699   143.039     0.200
     9.764   140.242     0.200
     9.842   142.539     0.200
    19.023   263.539     0.200
    20.067   273.836     0.200
     2.137    35.116     0.200
     2.549    40.616     0.200
     2.639    41.517     0.200
     2.691    42.416     0.200
     3.033    48.116     0.200
     3.150    51.416     0.200
     3.322    53.116     0.200
     3.326    53.116     0.200
     3.425    53.716     0.200
     3.597    55.416     0.200
     3.655    59.716     0.200
     3.905    60.816     0.200
     3.975    61.017     0.200
     4.109    63.716     0.200
     4.693    71.616     0.200
     4.948    74.216     0.200
     5.174    76.416     0.200
     5.241    77.116     0.200
     5.454    79.616     0.200
     5.452    80.916     0.200
     5.550    83.416     0.200
     5.579    84.116     0.200
     5.874    85.616     0.200
     5.943    89.916     0.200
     5.942    87.116     0.200
     5.954    93.616     0.200
     6.166    90.616     0.200
     6.225    93.616     0.200
     6.525    97.616     0.200
     6.856   101.616     0.200
     6.896    98.616     0.200
     6.896   102.616     0.200
     7.035   101.716     0.200
     7.057   102.017     0.200
     7.056   102.116     0.200
     7.056   103.616     0.200
     7.113   104.216     0.200
     7.198   103.916     0.200
     7.140   106.616     0.200
     7.273   107.616     0.200
     7.327   110.316     0.200
     7.456   108.116     0.200
     7.445   111.616     0.200
     7.572   111.616     0.200
     7.779   111.616     0.200
     8.391   120.616     0.200
     8.352   123.116     0.200
     8.493   120.816     0.200
     8.403   122.616     0.200
     8.403   123.116     0.200
     8.416   124.616     0.200
     8.490   122.616     0.200
     8.419   122.216     0.200
     8.599   130.616     0.200
     8.668   130.616     0.200
     9.008   131.616     0.200
     9.170   131.116     0.200
     9.218   132.116     0.200
     9.257   133.616     0.200
     9.311   132.517     0.200
     9.209   135.616     0.200
     9.326   133.816     0.200
     9.340   133.816     0.200
     9.425   133.616     0.200
     9.362   135.216     0.200
     9.645   137.116     0.200
     9.485   139.616     0.200
     9.508   138.716     0.200
     9.668   138.616     0.200
     9.756   142.716     0.200
    10.027   144.616     0.200
    10.087   143.416     0.200
    10.154   147.616     0.200
    10.040   143.616     0.200
    10.296   152.616     0.200
    10.350   147.616     0.200
    10.566   152.116     0.200
    10.601   150.716     0.200
    10.699   158.116     0.200
    11.370   164.616     0.200
    11.446   166.416     0.200
    11.949   172.116     0.200
    11.985   173.116     0.200
    12.277   178.616     0.200
    12.619   181.616     0.200
    12.717   181.816     0.200
    13.290   193.616     0.200
    15.614   221.616     0.200
    15.999   223.616     0.200
    18.218   249.616     0.200
    18.983   262.216     0.200
    19.348   265.116     0.200
    19.436   268.116     0.200
    20.013   274.517     0.200
    20.513   280.616     0.200
    20.636   281.116     0.200
     1.208    22.626     0.200
     2.496    40.626     0.200
     3.034    48.626     0.200
     3.202    53.526     0.200
     3.361    53.626     0.200
     3.471    55.826     0.200
     3.637    56.626     0.200
     3.709    60.226     0.200
     3.949    61.826     0.200
     4.190    64.126     0.200
     4.157    64.626     0.200
     4.163    66.626     0.200
     4.736    72.526     0.200
     4.921    75.426     0.200
     5.119    76.926     0.200
     5.215    77.426     0.200
     5.500    81.626     0.200
     5.833    85.626     0.200
     5.896    86.826     0.200
     5.893    89.626     0.200
     6.471    98.626     0.200
     7.030   102.626     0.200
     6.980   102.526     0.200
     7.002   102.726     0.200
     7.143   105.626     0.200
     7.440   108.626     0.200
     8.363   119.626     0.200
     8.463   121.126     0.200
     8.492   124.626     0.200
     8.471   123.526     0.200
     9.038   130.626     0.200
     9.147   131.626     0.200
     9.263   133.326     0.200
     9.597   137.226     0.200
    10.009   144.626     0.200
    10.062   144.326     0.200
    19.491   272.626     0.200
    20.365   277.226     0.200
     1.924    33.039     0.200
     1.998    33.039     0.200
     2.328    37.738     0.200
     2.394    40.637     0.200
     3.406    55.238     0.200
     3.543    55.938     0.200
     3.668    59.238     0.200
     3.821    58.738     0.200
     3.911    62.340     0.200
     4.142    64.238     0.200
     4.202    64.637     0.200
     4.357    66.938     0.200
     4.366    67.738     0.200
     4.663    68.738     0.200
     4.880    75.238     0.200
     4.919    73.539     0.200
     4.923    73.738     0.200
     4.927    74.738     0.200
     5.178    78.238     0.200
     5.596    82.539     0.200
     5.729    84.738     0.200
     5.766    85.238     0.200
     5.699    86.238     0.200
     6.327    92.238     0.200
     6.621    98.238     0.200
     6.789    99.340     0.200
     6.809    99.137     0.200
     6.889   100.238     0.200
     6.950   101.637     0.200
     6.993   102.238     0.200
     7.441   112.738     0.200
     7.309   108.238     0.200
     8.318   118.938     0.200
     8.675   126.137     0.200
     9.118   130.938     0.200
    10.026   144.738     0.200
    10.057   145.238     0.200
     1.854    32.945     0.200
     1.945    32.547     0.200
     2.264    37.945     0.200
     2.432    40.945     0.200
     2.841    46.945     0.200
     3.056    49.746     0.200
     4.374    67.945     0.200
     4.663    68.746     0.200
     4.806    75.246     0.200
     4.843    73.047     0.200
     4.876    73.645     0.200
     4.930    75.145     0.200
     5.104    76.746     0.200
     5.654    84.246     0.200
     5.713    84.848     0.200
     6.297    93.746     0.200
     6.737    98.445     0.200
     6.759    99.246     0.200
     6.900   101.547     0.200
     6.919   101.746     0.200
     6.919   103.746     0.200
     7.135   105.746     0.200
     7.200   104.746     0.200
     7.372   112.547     0.200
     7.998   114.746     0.200
     8.243   118.746     0.200
     8.243   118.848     0.200
     8.304   123.547     0.200
     8.503   124.746     0.200
     8.702   126.445     0.200
     8.961   130.746     0.200
     9.045   130.746     0.200
     9.174   135.547     0.200
     9.385   134.445     0.200
     9.832   142.746     0.200
     9.933   144.746     0.200
     9.952   143.348     0.200
     9.981   144.246     0.200
    19.224   266.445     0.200
    20.251   277.145     0.200
     2.117    35.250     0.200
     2.243    38.547     0.200
     2.410    39.750     0.200
     3.127    49.250     0.200
     3.240    53.250     0.200
     3.347    54.250     0.200
     3.481    55.750     0.200
     3.626    56.453     0.200
     3.761    60.250     0.200
     3.950    61.750     0.200
     4.007    62.047     0.200
     4.175    65.047     0.200
     4.193    67.047     0.200
     4.734    72.750     0.200
     4.811    72.750     0.200
     4.868    71.648     0.200
     5.056    75.453     0.200
     5.105    75.547     0.200
     5.514    81.453     0.200
     5.725    83.750     0.200
     5.793    85.750     0.200
     6.137    90.750     0.200
     6.778    97.750     0.200
     6.921   100.852     0.200
     6.921   102.750     0.200
     7.661   112.750     0.200
     7.806   112.750     0.200
     8.253   117.750     0.200
     8.352   119.148     0.200
     8.505   123.047     0.200
     9.000   130.750     0.200
     9.038   130.250     0.200
     9.953   140.648     0.200
     1.486    26.250     0.200
     2.439    38.949     0.200
     3.037    47.750     0.200
     3.682    57.150     0.200
     3.768    61.150     0.200
     3.998    62.250     0.200
     4.062    63.551     0.200
     4.211    65.551     0.200
     4.804    68.250     0.200
     4.893    73.750     0.200
     4.945    72.750     0.200
     4.784    73.250     0.200
     5.059    74.250     0.200
     5.187    77.051     0.200
     5.553    82.250     0.200
     5.789    84.250     0.200
     5.846    86.250     0.200
     6.866    99.250     0.200
     7.003   101.250     0.200
     7.003   103.250     0.200
     7.703   113.250     0.200
     8.334   118.949     0.200
     8.495   124.250     0.200
     9.122   131.250     0.200
     9.072   130.750     0.200
     9.254   132.750     0.200
    10.087   143.750     0.200
    10.544   150.250     0.200
    19.301   264.449     0.200
    20.153   274.150     0.200
     2.188    36.227     0.200
     2.263    38.828     0.200
     2.464    40.227     0.200
     2.844    46.227     0.200
     3.124    51.727     0.200
     3.306    54.125     0.200
     3.433    54.227     0.200
     3.584    56.527     0.200
     3.706    60.227     0.200
     3.904    61.727     0.200
     3.965    61.727     0.200
     4.125    64.926     0.200
     4.140    65.328     0.200
     4.689    72.227     0.200
     4.839    73.527     0.200
     4.901    72.527     0.200
     4.900    69.227     0.200
     5.112    75.727     0.200
     5.132    76.426     0.200
     5.465    82.027     0.200
     5.767    84.727     0.200
     5.841    86.227     0.200
     6.113    90.227     0.200
     6.793    99.227     0.200
     6.947   101.227     0.200
     6.947   103.227     0.200
     7.016   103.227     0.200
     7.049   108.227     0.200
     7.765   112.227     0.200
     8.282   118.527     0.200
     8.299   126.227     0.200
     8.381   120.125     0.200
     8.383   120.727     0.200
     8.403   124.227     0.200
     8.451   123.527     0.200
     8.969   132.227     0.200
     9.062   131.227     0.200
     9.118   133.227     0.200
     9.196   136.227     0.200
     9.531   138.227     0.200
     9.628   141.227     0.200
     9.662   141.227     0.200
     9.922   144.227     0.200
     9.979   143.027     0.200
    10.492   150.227     0.200
    19.241   265.227     0.200
    20.415   278.227     0.200
     1.464    27.133     0.200
     1.621    28.133     0.200
     1.927    33.133     0.200
     2.212    36.332     0.200
     2.425    39.234     0.200
     3.015    49.133     0.200
     3.409    54.832     0.200
     3.617    56.633     0.200
     3.732    58.531     0.200
     3.899    61.633     0.200
     3.942    62.734     0.200
     4.075    63.531     0.200
     4.116    63.633     0.200
     4.320    66.434     0.200
     4.352    68.832     0.200
     4.713    69.832     0.200
     4.852    75.133     0.200
     4.965    75.633     0.200
     5.425    80.133     0.200
     5.545    81.934     0.200
     5.602    83.133     0.200
     5.653    84.531     0.200
     6.471    95.734     0.200
     6.674    96.133     0.200
     6.781    99.133     0.200
     7.987   116.133     0.200
     8.108   115.934     0.200
     8.200   117.531     0.200
     8.355   124.133     0.200
     8.876   126.633     0.200
     8.904   127.832     0.200
     9.016   129.133     0.200
     9.788   142.133     0.200
     9.814   139.633     0.200
     9.853   141.633     0.200
    10.318   146.133     0.200
    19.084   263.832     0.200
    19.929   272.434     0.200
     1.377    23.764     0.200
     1.573    25.764     0.200
     2.123    34.764     0.200
     2.579    40.564     0.200
     2.996    47.264     0.200
     3.617    52.764     0.200
     3.333    53.963     0.200
     3.426    54.064     0.200
     3.606    54.764     0.200
     3.640    56.963     0.200
     3.984    61.164     0.200
     4.107    63.664     0.200
     4.105    64.963     0.200
     4.699    70.264     0.200
     4.699    73.164     0.200
     5.052    74.064     0.200
     5.194    75.764     0.200
     5.282    77.064     0.200
     5.452    80.164     0.200
     5.913    85.264     0.200
     5.977    89.764     0.200
     5.979    87.064     0.200
     6.840    99.264     0.200
     6.936    99.764     0.200
     7.097   102.264     0.200
     7.154   105.863     0.200
     7.092   101.764     0.200
     7.314   107.764     0.200
     7.038   103.264     0.200
     7.932   115.363     0.200
     7.724   115.764     0.200
     7.788   112.764     0.200
     8.432   119.764     0.200
     8.534   121.764     0.200
     8.645   122.463     0.200
     8.525   123.764     0.200
     8.682   126.764     0.200
     9.254   131.264     0.200
     9.211   130.764     0.200
     9.027   130.764     0.200
     9.020   132.764     0.200
     9.298   132.764     0.200
     9.242   134.764     0.200
     9.301   135.764     0.200
     9.245   134.764     0.200
     9.364   134.764     0.200
     9.830   140.564     0.200
     9.687   137.764     0.200
     9.687   138.264     0.200
     9.850   144.764     0.200
    10.067   145.764     0.200
    10.128   143.264     0.200
    10.128   141.764     0.200
    10.195   144.264     0.200
    10.053   143.764     0.200
    10.311   148.764     0.200
    10.642   150.764     0.200
    10.873   157.764     0.200
    11.366   160.764     0.200
    11.793   168.363     0.200
    16.033   222.764     0.200
    19.135   265.764     0.200
    19.411   269.764     0.200
    20.249   275.363     0.200
     1.501    28.372     0.200
     2.170    35.872     0.200
     2.480    41.372     0.200
     3.467    57.172     0.200
     3.510    56.072     0.200
     3.678    57.672     0.200
     3.793    58.772     0.200
     3.997    62.972     0.200
     4.177    64.772     0.200
     4.412    70.572     0.200
     4.913    76.472     0.200
     4.970    76.372     0.200
     5.142    77.372     0.200
     5.353    79.272     0.200
     5.474    80.872     0.200
     5.527    81.872     0.200
     5.576    83.372     0.200
     5.714    85.072     0.200
     6.480    97.372     0.200
     6.785    99.872     0.200
     6.808   102.972     0.200
     8.110   117.572     0.200
     8.199   118.472     0.200
     8.847   128.872     0.200
     8.912   128.372     0.200
     9.057   130.372     0.200
     9.114   134.372     0.200
     9.802   142.372     0.200
     9.848   143.372     0.200
     2.198    35.742     0.200
     2.787    46.141     0.200
     3.071    49.242     0.200
     3.326    52.945     0.200
     3.523    54.445     0.200
     3.441    55.539     0.200
     3.602    56.344     0.200
     3.690    60.844     0.200
     3.917    60.844     0.200
     3.982    62.039     0.200
     4.188    66.742     0.200
     4.128    64.344     0.200
     4.137    66.445     0.200
     4.346    69.039     0.200
     4.703    72.242     0.200
     4.957    73.539     0.200
     5.133    75.344     0.200
     5.189    78.039     0.200
     5.399    79.344     0.200
     5.433    81.242     0.200
     5.471    81.242     0.200
     5.623    81.445     0.200
     5.701    85.844     0.200
     5.819    85.242     0.200
     5.890    90.242     0.200
     5.888    86.742     0.200
     6.476    97.742     0.200
     6.991   100.742     0.200
     7.015   101.039     0.200
     7.004   102.539     0.200
     7.059   105.742     0.200
     7.155   103.445     0.200
     7.221   107.242     0.200
     7.836   114.641     0.200
     7.784   114.242     0.200
     8.338   118.945     0.200
     8.439   120.445     0.200
     8.455   123.242     0.200
     8.447   122.641     0.200
     9.044   131.242     0.200
     9.000   132.242     0.200
     9.000   133.242     0.200
     9.119   130.945     0.200
     9.045   132.242     0.200
     9.206   132.242     0.200
     9.257   132.742     0.200
     9.179   135.641     0.200
     9.271   133.344     0.200
     9.271   133.641     0.200
     9.227   137.242     0.200
     9.370   133.539     0.200
     9.591   137.344     0.200
     9.660   141.242     0.200
     9.825   145.242     0.200
     9.979   145.242     0.200
    10.035   143.445     0.200
    10.100   145.242     0.200
    10.480   149.945     0.200
    10.510   152.945     0.200
    10.370   150.242     0.200
    10.549   151.242     0.200
    11.474   168.141     0.200
    12.082   177.039     0.200
    12.514   180.039     0.200
    12.737   182.242     0.200
    19.482   269.242     0.200
    19.654   269.445     0.200
    19.988   275.242     0.200
    20.156   274.641     0.200
    20.470   280.039     0.200
    20.644   282.242     0.200
     2.086    35.584     0.200
     2.185    34.784     0.200
     2.504    40.084     0.200
     2.624    41.184     0.200
     2.679    42.284     0.200
     3.399    53.684     0.200
     3.502    55.084     0.200
     3.982    61.184     0.200
     4.052    61.984     0.200
     4.185    65.084     0.200
     4.185    66.984     0.200
     4.203    64.584     0.200
     4.360    67.084     0.200
     4.770    72.084     0.200
     4.959    74.584     0.200
     5.014    73.984     0.200
     5.253    77.884     0.200
     5.453    79.484     0.200
     5.518    82.584     0.200
     5.673    82.484     0.200
     5.860    86.084     0.200
     5.916    87.584     0.200
     5.907    88.584     0.200
     6.234    91.584     0.200
     6.786    99.584     0.200
     7.068   102.584     0.200
     7.068   104.584     0.200
     7.115   105.584     0.200
     7.323   105.584     0.200
     7.316   110.384     0.200
     7.682   112.584     0.200
     7.798   114.584     0.200
     7.885   114.284     0.200
     8.400   119.884     0.200
     8.400   119.984     0.200
     8.499   120.284     0.200
     9.081   133.584     0.200
     9.186   130.084     0.200
     9.188   132.584     0.200
     9.310   135.584     0.200
     9.273   132.584     0.200
     9.320   133.584     0.200
     9.398   134.084     0.200
     9.741   140.584     0.200
     9.798   142.984     0.200
    10.051   145.084     0.200
    10.101   143.584     0.200
    10.156   146.584     0.200
    10.611   149.584     0.200
    11.922   171.884     0.200
    19.365   265.584     0.200
    19.492   268.584     0.200
    20.403   277.184     0.200
     2.519    39.957     0.200
     2.588    40.457     0.200
     2.644    41.656     0.200
     3.423    53.656     0.200
     3.519    55.057     0.200
     3.697    58.258     0.200
     4.002    60.656     0.200
     4.075    61.857     0.200
     4.208    63.957     0.200
     4.200    64.258     0.200
     4.196    66.457     0.200
     4.379    63.457     0.200
     4.791    71.957     0.200
     4.994    75.156     0.200
     5.047    72.758     0.200
     5.289    76.857     0.200
     5.486    80.758     0.200
     5.545    81.457     0.200
     5.704    81.857     0.200
     5.888    85.156     0.200
     5.940    86.957     0.200
     6.267    92.457     0.200
     6.962   100.457     0.200
     7.104   102.057     0.200
     7.879   113.457     0.200
     8.435   119.258     0.200
     8.532   120.957     0.200
     8.577   123.457     0.200
     9.111   133.457     0.200
     9.222   131.156     0.200
    10.136   143.457     0.200
    19.401   265.957     0.200
     1.652    29.719     0.200
     1.751    31.117     0.200
     1.966    32.320     0.200
     2.027    35.219     0.200
     2.049    35.918     0.200
     2.935    46.719     0.200
     3.012    50.918     0.200
     3.200    50.719     0.200
     3.745    59.320     0.200
     3.770    59.520     0.200
     3.825    60.418     0.200
     3.983    63.418     0.200
     4.107    63.617     0.200
     4.222    66.617     0.200
     4.255    67.719     0.200
     4.414    68.918     0.200
     4.446    69.020     0.200
     4.491    69.020     0.200
     4.700    73.617     0.200
     4.767    74.117     0.200
     4.776    72.219     0.200
     5.071    76.719     0.200
     5.189    79.020     0.200
     5.378    79.320     0.200
     5.510    82.219     0.200
     5.512    81.418     0.200
     5.520    84.219     0.200
     5.764    84.520     0.200
     5.970    89.719     0.200
     6.065    91.520     0.200
     6.348    95.117     0.200
     6.650    94.719     0.200
     6.626    98.918     0.200
     6.772   104.719     0.200
     6.862   100.820     0.200
     6.791   100.617     0.200
     6.854    99.719     0.200
     6.881   101.617     0.200
     6.984   103.117     0.200
     7.092   105.117     0.200
     7.154   106.219     0.200
     7.239   109.719     0.200
     7.335   107.219     0.200
     7.404   108.020     0.200
     7.382   109.219     0.200
     7.393   108.719     0.200
     7.576   112.820     0.200
     7.777   117.719     0.200
     7.905   116.719     0.200
     7.997   121.719     0.200
     8.192   118.719     0.200
     8.252   121.117     0.200
     8.264   118.820     0.200
     8.267   123.719     0.200
     8.282   120.719     0.200
     8.529   125.117     0.200
     8.622   126.719     0.200
     8.760   127.719     0.200
     8.749   128.719     0.200
     8.981   129.219     0.200
     9.018   129.719     0.200
     9.018   129.820     0.200
     9.040   130.320     0.200
     9.101   130.719     0.200
     9.129   136.020     0.200
     9.360   139.719     0.200
     9.400   139.219     0.200
     9.423   140.719     0.200
     9.705   141.418     0.200
     9.666   144.820     0.200
     9.897   141.219     0.200
     9.897   143.719     0.200
     9.915   141.918     0.200
     9.942   143.219     0.200
     9.917   145.719     0.200
    10.078   149.719     0.200
    10.091   146.820     0.200
    10.206   149.020     0.200
    10.263   151.219     0.200
    10.398   149.520     0.200
    10.790   157.918     0.200
    10.920   157.918     0.200
    11.305   165.719     0.200
    11.504   168.020     0.200
    11.951   173.320     0.200
    12.136   172.418     0.200
    12.645   184.918     0.200
    13.900   198.219     0.200
    14.437   207.117     0.200
    17.543   244.719     0.200
    18.555   259.219     0.200
    18.699   261.020     0.200
    18.748   259.820     0.200
    18.808   265.219     0.200
    18.807   260.617     0.200
    18.858   263.918     0.200
    19.021   263.918     0.200
    19.003   263.219     0.200
    19.003   266.820     0.200
    19.262   270.117     0.200
    19.373   268.020     0.200
    19.564   269.320     0.200
    19.546   269.117     0.200
    19.621   271.117     0.200
    19.678   273.719     0.200
    20.014   274.117     0.200
    20.266   278.719     0.200
     1.978    34.047     0.200
     2.283    37.547     0.200
     2.370    39.250     0.200
     2.664    45.047     0.200
     3.132    50.445     0.200
     3.362    53.648     0.200
     3.679    57.844     0.200
     3.745    58.945     0.200
     3.874    61.750     0.200
     4.099    62.047     0.200
     4.107    65.344     0.200
     4.180    63.648     0.200
     4.157    64.750     0.200
     4.166    64.047     0.200
     4.286    66.844     0.200
     4.302    68.445     0.200
     4.399    69.750     0.200
     4.332    66.750     0.200
     4.412    66.250     0.200
     4.414    68.148     0.200
     4.591    72.547     0.200
     4.638    72.547     0.200
     4.828    74.547     0.200
     4.827    72.148     0.200
     4.849    76.547     0.200
     4.846    73.547     0.200
     4.842    72.547     0.200
     4.885    74.547     0.200
     4.969    77.047     0.200
     5.091    76.047     0.200
     5.315    80.945     0.200
     5.435    82.344     0.200
     5.494    81.250     0.200
     5.494    84.344     0.200
     5.489    82.945     0.200
     5.727    85.844     0.200
     5.776    87.547     0.200
     5.888    88.750     0.200
     5.999    88.945     0.200
     5.996    90.148     0.200
     6.038    89.047     0.200
     6.105    90.547     0.200
     6.173    91.344     0.200
     6.107    91.047     0.200
     6.179    91.547     0.200
     6.219    91.648     0.200
     6.219    93.047     0.200
     6.187    92.047     0.200
     6.297    93.945     0.200
     6.295    93.250     0.200
     6.427    96.250     0.200
     6.470    97.047     0.200
     6.450    96.047     0.200
     6.646    97.844     0.200
     6.646    98.250     0.200
     6.660    99.844     0.200
     6.612    99.047     0.200
     6.662    99.047     0.200
     6.738   100.047     0.200
     6.780   103.047     0.200
     6.797   102.250     0.200
     6.850   100.047     0.200
     6.887   101.844     0.200
     6.841   101.047     0.200
     6.976   103.547     0.200
     7.034   104.047     0.200
     7.060   104.547     0.200
     7.230   106.344     0.200
     7.191   107.547     0.200
     7.287   107.945     0.200
     7.414   108.148     0.200
     7.520   109.250     0.200
     7.747   115.047     0.200
     8.143   118.047     0.200
     8.152   120.547     0.200
     8.283   121.047     0.200
     8.352   122.750     0.200
     8.294   122.047     0.200
     8.360   120.844     0.200
     8.425   121.148     0.200
     8.536   123.047     0.200
     8.586   128.047     0.200
     8.852   128.344     0.200
     8.848   131.047     0.200
     8.869   131.047     0.200
     8.924   130.547     0.200
     9.212   133.047     0.200
     9.249   133.047     0.200
     9.263   136.047     0.200
     9.313   135.844     0.200
     9.724   140.047     0.200
     9.909   145.047     0.200
     9.909   144.047     0.200
    10.848   159.844     0.200
    11.460   166.047     0.200
    11.669   168.047     0.200
    18.532   257.750     0.200
    19.530   268.445     0.200
    19.935   273.047     0.200
     1.371    25.234     0.200
     1.483    26.637     0.200
     1.659    29.035     0.200
     2.125    34.535     0.200
     2.311    37.535     0.200
     2.354    38.035     0.200
     2.448    42.336     0.200
     2.656    42.535     0.200
     2.823    45.035     0.200
     3.006    47.734     0.200
     3.049    47.734     0.200
     3.036    48.035     0.200
     3.109    50.137     0.200
     3.201    51.035     0.200
     3.476    54.535     0.200
     3.444    54.234     0.200
     3.437    53.535     0.200
     3.623    57.137     0.200
     3.987    63.035     0.200
     3.874    60.836     0.200
     3.907    61.434     0.200
     3.923    60.535     0.200
     4.206    63.535     0.200
     4.206    64.934     0.200
     4.320    64.234     0.200
     4.485    67.637     0.200
     4.543    69.535     0.200
     4.593    68.137     0.200
     4.620    69.434     0.200
     4.685    71.535     0.200
     5.054    75.035     0.200
     4.989    74.637     0.200
     5.266    79.535     0.200
     5.333    78.336     0.200
     5.406    79.336     0.200
     5.273    78.934     0.200
     5.368    78.535     0.200
     5.328    79.637     0.200
     5.519    81.035     0.200
     5.474    80.934     0.200
     5.556    83.535     0.200
     5.706    83.535     0.200
     5.761    85.535     0.200
     5.724    84.836     0.200
     5.854    86.434     0.200
     5.910    87.535     0.200
     6.140    90.035     0.200
     6.113    91.535     0.200
     6.291    92.535     0.200
     6.194    90.637     0.200
     6.271    92.535     0.200
     6.419    94.234     0.200
     6.484    95.637     0.200
     6.627    95.035     0.200
     6.667    97.836     0.200
     6.628    96.535     0.200
     6.716    97.035     0.200
     7.171   104.535     0.200
     7.191   105.535     0.200
     7.640   109.535     0.200
     7.634   109.934     0.200
     7.770   111.836     0.200
     7.803   113.137     0.200
     8.273   123.035     0.200
     8.380   121.535     0.200
     8.309   120.035     0.200
     8.837   126.637     0.200
     8.916   126.637     0.200
     8.927   131.035     0.200
     9.072   129.637     0.200
     9.257   131.434     0.200
     9.959   140.934     0.200
    10.028   141.336     0.200
    10.234   144.336     0.200
    10.325   145.535     0.200
    10.548   150.336     0.200
    11.506   164.934     0.200
    18.508   256.035     0.200
     1.912    34.557     0.200
     1.984    33.557     0.200
     2.148    37.557     0.200
     3.133    53.557     0.200
     3.134    50.557     0.200
     3.213    52.557     0.200
     3.381    53.857     0.200
     3.422    53.756     0.200
     3.680    58.557     0.200
     3.667    58.057     0.200
     3.760    59.057     0.200
     3.888    63.357     0.200
     4.070    63.957     0.200
     4.175    62.957     0.200
     4.118    63.457     0.200
     4.128    63.656     0.200
     4.167    65.057     0.200
     4.180    65.357     0.200
     4.302    68.156     0.200
     4.319    68.057     0.200
     4.338    67.457     0.200
     4.343    68.357     0.200
     4.405    68.857     0.200
     4.432    67.557     0.200
     4.435    67.656     0.200
     4.580    71.156     0.200
     4.641    74.357     0.200
     4.842    72.057     0.200
     4.857    73.756     0.200
     4.862    75.357     0.200
     4.894    75.156     0.200
     4.976    77.557     0.200
     5.328    80.557     0.200
     5.511    84.057     0.200
     5.744    86.057     0.200
     5.901    87.557     0.200
     6.008    89.957     0.200
     6.198    94.357     0.200
     6.198    91.557     0.200
     6.240    92.557     0.200
     6.316    93.256     0.200
     6.481    96.557     0.200
     6.633    97.557     0.200
     7.540   108.557     0.200
     7.604   112.057     0.200
     1.754    28.084     0.200
     2.044    33.584     0.200
     2.267    36.484     0.200
     2.468    37.584     0.200
     2.533    40.885     0.200
     2.633    40.783     0.200
     2.852    45.084     0.200
     2.957    46.584     0.200
     3.011    47.084     0.200
     3.107    48.385     0.200
     3.147    48.385     0.200
     3.445    52.084     0.200
     3.506    55.084     0.200
     3.461    53.283     0.200
     3.685    55.584     0.200
     3.867    58.484     0.200
     3.825    58.584     0.200
     3.927    58.684     0.200
     3.948    57.184     0.200
     3.891    58.084     0.200
     4.078    61.385     0.200
     4.156    62.184     0.200
     4.059    61.684     0.200
     4.233    62.385     0.200
     4.183    63.684     0.200
     4.841    71.283     0.200
     5.065    73.885     0.200
     5.343    78.084     0.200
     5.457    80.084     0.200
     5.515    81.385     0.200
     5.598    80.584     0.200
     5.503    80.684     0.200
     5.730    83.484     0.200
     5.727    83.584     0.200
     5.712    83.684     0.200
     5.824    85.283     0.200
     5.855    85.084     0.200
     5.970    87.084     0.200
     5.943    87.283     0.200
     5.881    87.084     0.200
     6.041    89.885     0.200
     6.165    88.783     0.200
     6.214    90.684     0.200
     6.256    89.885     0.200
     6.305    91.984     0.200
     6.287    93.084     0.200
     6.601    96.084     0.200
     6.686    98.084     0.200
     6.660    96.283     0.200
     6.725    95.283     0.200
     6.787    99.084     0.200
     6.826   100.184     0.200
     7.062   101.385     0.200
     7.169   101.684     0.200
     7.309   104.584     0.200
     7.338   105.885     0.200
     7.493   108.084     0.200
     7.594   108.684     0.200
     8.461   119.084     0.200
     8.470   125.084     0.200
     8.625   121.484     0.200
     8.800   123.684     0.200
     9.494   133.084     0.200
     9.563   133.283     0.200
     9.769   136.283     0.200
     9.860   137.885     0.200
     9.884   138.283     0.200
    10.083   140.885     0.200
     1.535    26.969     0.200
     1.672    28.469     0.200
     1.735    30.469     0.200
     1.934    31.766     0.200
     2.677    43.469     0.200
     2.740    42.969     0.200
     3.189    49.469     0.200
     3.144    48.969     0.200
     3.317    51.469     0.200
     3.377    52.469     0.200
     3.631    56.266     0.200
     3.664    57.172     0.200
     3.727    58.969     0.200
     3.736    58.266     0.200
     3.925    60.969     0.200
     4.131    63.969     0.200
     4.209    65.469     0.200
     4.221    65.266     0.200
     4.258    64.867     0.200
     4.260    66.070     0.200
     4.376    67.367     0.200
     4.557    67.867     0.200
     4.596    68.969     0.200
     4.899    73.570     0.200
     4.918    72.570     0.200
     5.149    77.469     0.200
     5.355    79.969     0.200
     5.447    81.469     0.200
     5.463    82.969     0.200
     5.995    88.969     0.200
     6.008    89.570     0.200
     6.413    92.672     0.200
     6.699    98.867     0.200
     6.753    97.469     0.200
     7.284   107.469     0.200
     8.023   115.469     0.200
     8.964   127.570     0.200
     1.616    28.047     0.200
     2.043    33.047     0.200
     2.155    34.047     0.200
     2.450    39.047     0.200
     2.542    40.047     0.200
     2.585    40.945     0.200
     3.039    49.047     0.200
     3.317    51.547     0.200
     3.457    54.547     0.200
     3.481    55.047     0.200
     3.466    54.047     0.200
     3.689    57.547     0.200
     3.753    57.750     0.200
     3.929    61.844     0.200
     4.074    63.250     0.200
     4.092    63.547     0.200
     4.138    61.648     0.200
     4.138    61.750     0.200
     4.170    62.750     0.200
     4.218    66.250     0.200
     4.245    64.547     0.200
     4.341    65.445     0.200
     4.480    69.547     0.200
     4.879    72.445     0.200
     4.957    75.148     0.200
     5.095    75.047     0.200
     5.208    76.547     0.200
     5.251    77.547     0.200
     5.316    80.047     0.200
     5.363    79.648     0.200
     5.533    81.648     0.200
     5.630    83.047     0.200
     5.781    84.250     0.200
     5.850    85.844     0.200
     5.887    87.250     0.200
     5.909    87.047     0.200
     5.923    86.945     0.200
     5.958    88.359     0.200
     6.097    90.344     0.200
     6.155    90.648     0.200
     6.154    90.047     0.200
     6.203    92.047     0.200
     6.232    92.844     0.200
     6.242    91.945     0.200
     6.259    93.344     0.200
     6.344    91.547     0.200
     6.402    94.344     0.200
     6.438    93.445     0.200
     6.455    95.844     0.200
     6.530    97.047     0.200
     6.541    95.047     0.200
     6.656    94.914     0.200
     6.688    97.391     0.200
     6.735    98.844     0.200
     6.780    99.148     0.200
     6.788   100.344     0.200
     6.874   101.844     0.200
     6.903   100.547     0.200
     6.918   102.547     0.200
     7.016   103.648     0.200
     7.060   102.695     0.200
     7.080    99.930     0.200
     7.238   104.445     0.200
     7.335   105.648     0.200
     7.356   105.750     0.200
     7.494   108.250     0.200
     7.511   109.250     0.200
     7.605   111.844     0.200
     7.609   109.047     0.200
     7.624   110.547     0.200
     8.261   119.047     0.200
     8.646   122.648     0.200
     8.814   126.047     0.200
     8.985   127.250     0.200
     9.111   133.047     0.200
     9.280   135.047     0.200
     9.661   136.344     0.200
     9.734   137.250     0.200
     9.942   139.547     0.200
    10.027   141.344     0.200
    10.252   147.047     0.200
    11.247   162.750     0.200
     1.826    31.070     0.200
     1.946    32.969     0.200
     2.079    34.570     0.200
     2.247    36.367     0.200
     2.325    39.070     0.200
     2.404    38.672     0.200
     2.384    38.570     0.200
     2.577    42.570     0.200
     2.842    45.867     0.200
     2.879    46.773     0.200
     3.232    51.570     0.200
     3.283    51.570     0.200
     3.585    55.570     0.200
     3.732    59.070     0.200
     3.833    59.570     0.200
     3.920    62.570     0.200
     3.981    61.672     0.200
     4.064    60.867     0.200
     4.176    65.570     0.200
     4.380    65.969     0.200
     4.392    69.570     0.200
     4.374    68.070     0.200
     4.386    68.570     0.200
     4.435    66.969     0.200
     4.771    71.570     0.200
     4.766    71.570     0.200
     4.807    72.570     0.200
     4.983    76.367     0.200
     5.046    74.469     0.200
     5.456    81.969     0.200
     5.938    88.070     0.200
     6.073    90.469     0.200
     6.193    92.773     0.200
     6.284    94.273     0.200
     7.488   108.773     0.200
     8.350   119.570     0.200
     1.670    27.352     0.200
     1.582    26.652     0.200
     1.668    27.852     0.200
     1.862    30.551     0.200
     2.000    32.352     0.200
     1.903    32.152     0.200
     2.084    36.051     0.200
     2.188    34.953     0.200
     2.485    38.852     0.200
     2.716    41.152     0.200
     2.655    41.953     0.200
     2.997    45.953     0.200
     3.032    49.152     0.200
     3.061    46.754     0.200
     3.231    48.852     0.200
     3.299    49.754     0.200
     3.542    53.152     0.200
     3.444    52.551     0.200
     3.550    53.852     0.200
     3.579    54.352     0.200
     3.648    57.852     0.200
     3.835    58.754     0.200
     4.053    60.453     0.200
     4.180    60.551     0.200
     4.124    61.453     0.200
     4.246    63.652     0.200
     4.177    62.254     0.200
     4.281    62.652     0.200
     4.542    67.453     0.200
     4.595    70.152     0.200
     4.618    67.051     0.200
     4.542    68.254     0.200
     4.833    71.152     0.200
     4.896    73.152     0.200
     4.923    72.551     0.200
     5.060    75.852     0.200
     5.400    78.352     0.200
     5.635    80.652     0.200
     5.917    85.652     0.200
     6.017    88.152     0.200
     6.017    89.551     0.200
     6.071    89.152     0.200
     6.492    93.652     0.200
     6.518    93.152     0.200
     6.518    96.152     0.200
     6.591    96.254     0.200
     6.657    96.254     0.200
     6.711    99.352     0.200
     7.292   105.352     0.200
     8.027   114.953     0.200
     8.107   115.754     0.200
     9.009   127.551     0.200
    10.235   144.551     0.200
     1.710    30.180     0.200
     1.722    30.578     0.200
     2.024    34.484     0.200
     2.143    36.281     0.200
     2.122    36.484     0.200
     2.349    40.383     0.200
     2.561    41.078     0.200
     2.764    44.883     0.200
     2.872    47.078     0.200
     3.005    49.484     0.200
     3.158    51.383     0.200
     3.198    51.383     0.200
     3.195    52.078     0.200
     3.203    51.883     0.200
     3.459    55.484     0.200
     3.471    56.180     0.200
     3.545    56.883     0.200
     3.608    57.781     0.200
     3.805    59.383     0.200
     3.790    62.883     0.200
     3.923    60.984     0.200
     3.917    60.781     0.200
     3.940    62.680     0.200
     4.006    62.883     0.200
     4.089    64.484     0.200
     4.116    64.883     0.200
     4.237    65.484     0.200
     4.236    65.781     0.200
     4.339    67.484     0.200
     4.338    68.281     0.200
     4.411    69.781     0.200
     4.486    69.883     0.200
     4.523    70.281     0.200
     4.544    70.781     0.200
     4.642    72.578     0.200
     4.757    73.844     0.200
     5.023    75.180     0.200
     5.092    76.984     0.200
     5.124    79.641     0.200
     5.252    78.078     0.200
     5.566    82.984     0.200
     5.636    84.781     0.200
     5.815    87.781     0.200
     5.864    88.484     0.200
     5.951    90.281     0.200
     6.108    92.602     0.200
     6.136    94.281     0.200
     6.211    93.781     0.200
     6.260    92.078     0.200
     6.212    93.641     0.200
     6.298    93.680     0.200
     6.375    97.000     0.200
     6.433    95.578     0.200
     6.598    98.242     0.200
     6.738   100.562     0.200
     6.988   101.484     0.200
     7.010   102.484     0.200
     7.034   104.523     0.200
     7.159   106.320     0.200
     7.649   112.281     0.200
     8.437   122.680     0.200
     8.649   124.383     0.200
     8.771   127.781     0.200
     1.292    23.328     0.200
     1.453    24.430     0.200
     1.880    30.930     0.200
     1.732    28.727     0.200
     1.784    28.133     0.200
     2.350    37.531     0.200
     2.227    36.531     0.200
     2.350    38.727     0.200
     2.508    39.531     0.200
     2.499    41.031     0.200
     2.675    42.031     0.200
     2.661    41.328     0.200
     2.722    42.633     0.200
     2.722    42.328     0.200
     2.985    46.828     0.200
     2.959    46.430     0.200
     3.008    46.633     0.200
     3.216    50.727     0.200
     3.058    47.633     0.200
     3.270    51.820     0.200
     3.199    48.930     0.200
     3.163    51.281     0.200
     3.416    53.930     0.200
     3.368    52.828     0.200
     3.651    55.930     0.200
     3.521    53.930     0.200
     3.598    56.828     0.200
     3.611    56.930     0.200
     3.927    60.828     0.200
     3.927    61.430     0.200
     3.997    58.930     0.200
     3.830    58.031     0.200
     4.013    61.328     0.200
     4.047    61.133     0.200
     4.090    61.531     0.200
     3.943    59.930     0.200
     4.220    63.430     0.200
     4.286    64.227     0.200
     4.082    62.430     0.200
     4.127    63.031     0.200
     4.375    66.633     0.200
     4.671    70.430     0.200
     4.739    70.031     0.200
     4.645    70.133     0.200
     4.922    71.531     0.200
     5.056    73.227     0.200
     5.064    74.031     0.200
     5.119    76.930     0.200
     5.188    77.930     0.200
     5.688    83.633     0.200
     5.520    81.430     0.200
     5.845    85.930     0.200
     5.775    84.828     0.200
     5.985    88.031     0.200
     5.874    87.430     0.200
     6.067    88.930     0.200
     6.062    89.633     0.200
     6.083    89.227     0.200
     6.100    92.531     0.200
     5.979    88.430     0.200
     6.215    90.828     0.200
     6.227    91.328     0.200
     6.247    89.727     0.200
     6.457    92.328     0.200
     6.541    96.531     0.200
     6.374    93.430     0.200
     6.596    96.633     0.200
     6.688    98.328     0.200
     6.708    95.633     0.200
     6.724    97.828     0.200
     6.988   103.391     0.200
     7.042   100.828     0.200
     7.074   101.328     0.200
     7.137   101.727     0.200
     7.158   102.031     0.200
     7.370   105.430     0.200
     7.595   109.430     0.200
     8.457   119.031     0.200
     8.630   121.930     0.200
     8.583   126.430     0.200
     8.796   123.727     0.200
     9.463   132.930     0.200
     9.536   133.633     0.200
     9.745   136.531     0.200
     9.829   137.328     0.200
     9.857   137.930     0.200
    10.049   141.227     0.200
    19.369   263.430     0.200
     1.699    31.270     0.200
     1.700    30.969     0.200
     1.740    32.270     0.200
     2.041    34.969     0.200
     2.202    38.070     0.200
     2.039    36.270     0.200
     2.185    39.770     0.200
     2.381    39.670     0.200
     2.856    48.740     0.200
     3.280    53.070     0.200
     3.341    52.969     0.200
     3.517    57.369     0.200
     3.568    57.869     0.200
     3.416    57.270     0.200
     3.535    56.770     0.200
     3.699    59.170     0.200
     3.926    61.869     0.200
     4.069    64.969     0.200
     4.204    67.270     0.200
     4.344    67.570     0.200
     4.335    68.869     0.200
     4.257    66.590     0.200
     4.511    69.270     0.200
     4.588    70.270     0.200
     4.588    71.469     0.200
     4.511    71.770     0.200
     4.557    71.129     0.200
     5.367    80.270     0.200
     5.375    80.170     0.200
     5.411    82.469     0.200
     5.555    84.549     0.200
     5.735    87.770     0.200
     5.876    89.770     0.200
     5.860    89.369     0.200
     6.299    97.270     0.200
     6.223    93.770     0.200
     6.454    94.969     0.200
     6.478    96.969     0.200
     6.959   103.770     0.200
     7.368   107.469     0.200
     7.368   106.369     0.200
     7.664   111.270     0.200
     8.943   128.969     0.200
     9.105   130.670     0.200
    10.038   143.270     0.200
     1.677    28.539     0.200
     1.886    31.539     0.200
     2.013    33.039     0.200
     2.029    32.938     0.200
     2.009    34.438     0.200
     2.158    35.938     0.200
     2.388    37.836     0.200
     2.383    40.141     0.200
     2.823    47.195     0.200
     3.227    49.234     0.200
     3.283    51.438     0.200
     3.287    51.039     0.200
     3.373    53.641     0.200
     3.573    54.938     0.200
     3.496    54.641     0.200
     3.846    57.141     0.200
     3.819    59.438     0.200
     3.970    60.539     0.200
     4.098    63.039     0.200
     4.336    63.938     0.200
     4.267    64.758     0.200
     4.551    67.734     0.200
     4.550    69.938     0.200
     4.624    68.734     0.200
     5.320    79.297     0.200
     5.397    77.938     0.200
     5.388    78.438     0.200
     5.405    80.539     0.200
     5.568    84.039     0.200
     5.733    84.641     0.200
     6.326    94.938     0.200
     7.407   105.836     0.200
     7.407   105.734     0.200
     7.703   109.438     0.200
     8.778   124.734     0.200
     8.958   126.938     0.200
     9.116   128.938     0.200
    10.040   143.539     0.200
    18.653   258.734     0.200
     2.038    34.703     0.200
     2.069    34.305     0.200
     2.241    36.500     0.200
     2.281    39.000     0.200
     2.278    37.406     0.200
     2.359    38.703     0.200
     2.542    42.203     0.200
     2.577    42.102     0.200
     2.609    42.500     0.200
     2.746    44.203     0.200
     2.730    44.102     0.200
     2.995    47.953     0.200
     3.030    49.203     0.200
     3.040    49.500     0.200
     3.049    49.703     0.200
     3.152    51.102     0.200
     3.294    52.203     0.200
     3.411    53.805     0.200
     3.628    57.602     0.200
     3.638    55.906     0.200
     3.687    58.000     0.200
     3.673    57.102     0.200
     3.739    58.500     0.200
     3.716    57.406     0.200
     3.776    59.203     0.200
     4.037    62.500     0.200
     4.048    63.203     0.200
     4.117    63.102     0.200
     4.278    66.102     0.200
     4.375    67.500     0.200
     4.360    66.703     0.200
     4.481    68.102     0.200
     4.472    67.500     0.200
     4.868    72.102     0.200
     5.152    77.805     0.200
     5.230    77.102     0.200
     5.290    77.805     0.200
     5.299    78.805     0.200
     5.327    80.203     0.200
     5.431    80.203     0.200
     5.544    83.406     0.200
     5.661    85.406     0.200
     6.138    90.602     0.200
     6.249    92.000     0.200
     6.331    93.703     0.200
     6.365    94.102     0.200
     6.387    95.203     0.200
     6.508    96.703     0.200
     6.530    97.203     0.200
     6.634    96.203     0.200
     6.857   101.203     0.200
     7.047   104.000     0.200
     7.072   104.406     0.200
     7.200   107.203     0.200
     7.217   104.906     0.200
     7.217   104.305     0.200
     7.454   107.305     0.200
     7.506   111.102     0.200
     7.514   109.203     0.200
     7.572   108.000     0.200
     7.592   108.906     0.200
     8.828   126.000     0.200
     8.977   128.305     0.200
     9.895   140.102     0.200
     9.960   140.500     0.200
    10.164   143.602     0.200
    10.164   145.000     0.200
    10.261   146.305     0.200
    10.283   145.000     0.200
    10.488   147.203     0.200
     1.792    31.945     0.200
     2.057    34.754     0.200
     2.171    36.652     0.200
     2.265    39.152     0.200
     2.257    37.754     0.200
     2.529    42.953     0.200
     2.527    41.652     0.200
     2.598    43.152     0.200
     3.016    49.953     0.200
     3.006    49.152     0.200
     3.141    50.953     0.200
     3.170    51.555     0.200
     3.686    57.754     0.200
     3.663    56.953     0.200
     3.728    58.855     0.200
     3.728    57.055     0.200
     3.770    59.152     0.200
     4.025    62.754     0.200
     4.104    62.555     0.200
     4.350    66.254     0.200
     4.462    67.055     0.200
     4.273    65.254     0.200
     5.224    76.652     0.200
     5.427    79.855     0.200
     5.544    83.152     0.200
     5.295    78.754     0.200
     5.660    84.953     0.200
     6.022    88.855     0.200
     6.241    92.453     0.200
     6.324    93.855     0.200
     6.546    94.953     0.200
     6.572    97.152     0.200
     6.631    96.254     0.200
     7.043   104.453     0.200
     7.207   104.355     0.200
     7.207   103.855     0.200
     7.502   110.652     0.200
     7.572   109.055     0.200
     7.731   112.754     0.200
     8.973   128.855     0.200
     9.166   130.754     0.200
     9.895   139.754     0.200
    10.163   144.754     0.200
    10.488   148.953     0.200
    19.144   263.555     0.200
     1.550    25.906     0.200
     1.705    29.207     0.200
     2.072    34.605     0.200
     2.190    35.207     0.200
     2.381    38.207     0.200
     2.409    38.406     0.200
     2.748    43.309     0.200
     2.636    42.008     0.200
     2.668    42.906     0.200
     2.724    43.508     0.200
     2.905    46.688     0.200
     3.089    46.605     0.200
     3.301    51.508     0.200
     3.162    49.809     0.200
     3.398    52.508     0.200
     3.269    51.707     0.200
     3.305    51.809     0.200
     3.623    56.406     0.200
     3.680    56.809     0.200
     3.519    53.707     0.200
     3.614    55.605     0.200
     3.754    56.105     0.200
     3.661    56.406     0.200
     3.837    58.309     0.200
     3.850    59.605     0.200
     4.104    62.727     0.200
     4.226    63.207     0.200
     4.272    63.406     0.200
     4.464    66.707     0.200
     4.447    66.605     0.200
     4.346    66.129     0.200
     4.384    66.707     0.200
     4.548    67.105     0.200
     4.768    72.406     0.200
     5.070    76.285     0.200
     5.115    75.906     0.200
     5.353    77.707     0.200
     5.448    79.406     0.200
     5.533    82.508     0.200
     5.356    79.508     0.200
     5.401    81.707     0.200
     5.694    85.258     0.200
     6.082    88.707     0.200
     6.189    90.309     0.200
     6.417    94.809     0.200
     6.552    94.309     0.200
     6.596    96.207     0.200
     6.642    95.508     0.200
     6.569    96.406     0.200
     6.868    97.707     0.200
     6.963   102.207     0.200
     7.016   101.906     0.200
     7.068   103.406     0.200
     7.146   104.906     0.200
     7.305   105.508     0.200
     7.305   105.406     0.200
     7.450   107.008     0.200
     7.522   109.707     0.200
     7.555   107.008     0.200
     7.575   107.508     0.200
     7.725   111.508     0.200
     7.971   114.406     0.200
     8.686   122.008     0.200
     8.845   125.105     0.200
     8.922   126.508     0.200
     9.004   127.309     0.200
     9.185   129.508     0.200
     9.880   138.406     0.200
     9.950   139.406     0.200
    10.246   143.906     0.200
    10.272   143.605     0.200
    10.468   146.707     0.200
    11.209   157.508     0.200
    20.757   281.105     0.200
     1.975    34.598     0.200
     2.244    39.598     0.200
     2.416    40.898     0.200
     2.722    45.000     0.200
     2.814    46.598     0.200
     2.996    50.098     0.200
     3.012    49.098     0.200
     3.009    50.098     0.200
     3.247    53.500     0.200
     3.269    53.098     0.200
     3.282    53.898     0.200
     3.354    54.398     0.200
     3.641    56.199     0.200
     3.733    59.598     0.200
     3.756    61.000     0.200
     3.770    58.797     0.200
     3.898    62.000     0.200
     3.926    62.598     0.200
     3.945    61.797     0.200
     4.070    64.898     0.200
     4.157    65.398     0.200
     4.330    67.398     0.200
     4.459    70.398     0.200
     4.407    67.500     0.200
     4.484    71.797     0.200
     4.606    71.797     0.200
     4.524    69.598     0.200
     4.910    76.598     0.200
     4.903    75.898     0.200
     4.945    76.320     0.200
     5.062    75.898     0.200
     5.141    77.598     0.200
     5.349    82.598     0.200
     5.528    84.598     0.200
     5.624    85.797     0.200
     5.681    86.000     0.200
     5.765    87.199     0.200
     5.907    91.199     0.200
     5.963    89.199     0.200
     5.935    89.438     0.200
     6.027    89.359     0.200
     6.218    94.238     0.200
     6.158    95.098     0.200
     6.242    94.199     0.200
     6.241    95.000     0.200
     6.416    94.598     0.200
     6.458    97.000     0.200
     6.592    98.898     0.200
     6.553    97.520     0.200
     6.736   100.898     0.200
     6.980   103.039     0.200
     7.110   102.398     0.200
     7.131   103.098     0.200
     7.393   108.398     0.200
     7.328   106.797     0.200
     7.622   111.398     0.200
     8.479   122.898     0.200
     8.719   124.199     0.200
     8.855   125.598     0.200
     2.112    35.525     0.200
     2.361    38.625     0.200
     2.955    47.926     0.200
     3.000    47.926     0.200
     3.204    50.727     0.200
     3.258    52.926     0.200
     3.254    52.125     0.200
     3.410    53.926     0.200
     3.350    53.025     0.200
     3.471    55.926     0.200
     3.632    56.426     0.200
     3.678    57.426     0.200
     3.833    58.926     0.200
     3.902    63.525     0.200
     3.997    63.525     0.200
     4.060    63.125     0.200
     4.158    64.326     0.200
     4.215    64.727     0.200
     4.282    65.625     0.200
     4.262    64.227     0.200
     4.327    68.926     0.200
     4.716    73.525     0.200
     4.722    72.125     0.200
     4.776    73.727     0.200
     5.144    76.326     0.200
     5.247    79.986     0.200
     5.259    80.426     0.200
     5.408    80.727     0.200
     5.808    88.826     0.200
     5.780    85.625     0.200
     5.997    89.465     0.200
     6.070    91.025     0.200
     6.096    90.426     0.200
     6.201    93.826     0.200
     6.213    93.906     0.200
     6.205    90.525     0.200
     6.234    90.727     0.200
     6.275    94.727     0.200
     6.303    94.426     0.200
     6.341    94.625     0.200
     6.372    93.326     0.200
     6.442    97.865     0.200
     6.459    96.525     0.200
     6.483    96.826     0.200
     6.495    97.025     0.200
     6.587    98.727     0.200
     6.736    99.926     0.200
     6.730   100.066     0.200
     6.879   102.266     0.200
     7.238   107.625     0.200
     7.511   112.025     0.200
     7.538   109.227     0.200
     7.538   108.426     0.200
     7.640   111.625     0.200
     7.830   113.426     0.200
     7.898   115.326     0.200
     8.503   123.625     0.200
     8.671   125.625     0.200
     8.732   126.326     0.200
     8.892   132.426     0.200
     9.529   137.625     0.200
    14.128   199.025     0.200
     1.437    25.756     0.200
     1.459    23.857     0.200
     1.741    29.156     0.200
     1.832    29.756     0.200
     2.125    32.756     0.200
     2.295    37.156     0.200
     2.292    37.357     0.200
     2.664    42.156     0.200
     2.710    43.656     0.200
     2.825    44.457     0.200
     2.881    44.256     0.200
     2.921    45.656     0.200
     3.029    47.057     0.200
     3.060    48.756     0.200
     3.160    49.256     0.200
     3.173    49.457     0.200
     3.195    49.756     0.200
     3.421    54.557     0.200
     3.463    53.957     0.200
     3.676    56.357     0.200
     3.715    57.457     0.200
     3.718    57.057     0.200
     3.778    57.756     0.200
     3.870    59.957     0.200
     4.178    63.986     0.200
     4.597    69.518     0.200
     4.855    74.557     0.200
     4.907    72.857     0.200
     4.920    73.656     0.200
     5.352    79.357     0.200
     5.458    81.057     0.200
     5.513    80.057     0.200
     5.560    82.297     0.200
     5.799    86.096     0.200
     6.399    93.457     0.200
     6.489    94.377     0.200
     6.628    95.736     0.200
     6.839    98.557     0.200
     6.873    99.656     0.200
     7.009   101.756     0.200
     7.439   109.557     0.200
     7.570   108.457     0.200
     7.591   108.756     0.200
     7.709   109.156     0.200
     8.005   114.557     0.200
     8.947   125.957     0.200
     9.323   130.256     0.200
     1.619    28.188     0.200
     1.881    31.984     0.200
     1.917    33.086     0.200
     2.314    38.688     0.200
     2.246    37.789     0.200
     2.431    39.688     0.200
     2.541    42.289     0.200
     2.601    41.688     0.200
     2.725    45.188     0.200
     2.747    45.383     0.200
     2.989    47.984     0.200
     3.054    48.984     0.200
     3.019    48.484     0.200
     3.055    48.398     0.200
     3.290    52.789     0.200
     3.342    54.086     0.200
     3.213    52.086     0.200
     3.556    57.586     0.200
     3.474    54.688     0.200
     3.512    55.289     0.200
     3.625    55.984     0.200
     3.580    56.289     0.200
     3.628    58.484     0.200
     3.765    59.086     0.200
     3.718    57.586     0.200
     3.718    57.586     0.200
     3.822    61.766     0.200
     3.854    60.484     0.200
     3.983    61.586     0.200
     3.912    61.086     0.200
     3.904    61.086     0.200
     4.106    61.883     0.200
     4.125    62.883     0.200
     4.078    62.984     0.200
     4.203    63.883     0.200
     4.296    65.945     0.200
     4.333    66.086     0.200
     4.245    65.188     0.200
     4.397    65.984     0.200
     4.425    68.133     0.200
     4.350    67.383     0.200
     4.376    67.586     0.200
     4.672    71.383     0.200
     4.692    71.688     0.200
     4.696    69.883     0.200
     4.636    71.086     0.200
     4.679    72.023     0.200
     4.655    71.586     0.200
     4.741    72.688     0.200
     4.762    73.086     0.200
     5.020    74.086     0.200
     5.150    76.289     0.200
     5.163    76.086     0.200
     5.186    78.984     0.200
     5.161    79.086     0.200
     5.505    82.188     0.200
     5.449    81.883     0.200
     5.465    81.789     0.200
     5.626    84.375     0.200
     5.672    82.789     0.200
     5.536    82.383     0.200
     5.702    85.289     0.200
     5.743    85.688     0.200
     5.749    85.789     0.200
     5.915    89.938     0.200
     5.773    87.984     0.200
     5.949    89.359     0.200
     5.957    90.930     0.200
     5.944    87.484     0.200
     6.061    92.383     0.200
     6.021    88.789     0.200
     5.951    87.789     0.200
     6.104    90.789     0.200
     6.088    90.586     0.200
     6.047    89.586     0.200
     6.151    92.586     0.200
     6.143    91.586     0.200
     6.001    90.086     0.200
     6.170    91.883     0.200
     6.184    91.883     0.200
     6.072    90.484     0.200
     6.227    90.188     0.200
     6.209    92.383     0.200
     6.234    94.727     0.200
     6.279    95.383     0.200
     6.304    94.875     0.200
     6.301    93.188     0.200
     6.326    91.984     0.200
     6.328    94.289     0.200
     6.365    93.883     0.200
     6.413    95.188     0.200
     6.452    96.383     0.200
     6.369    94.289     0.200
     6.378    95.086     0.200
     6.462    95.086     0.200
     6.527    94.086     0.200
     6.530    94.414     0.200
     6.540    96.914     0.200
     6.575    96.484     0.200
     6.579    96.609     0.200
     6.573    97.789     0.200
     6.573   100.789     0.200
     6.626    97.383     0.200
     6.595    97.086     0.200
     6.715    96.688     0.200
     6.756    99.383     0.200
     6.775   100.688     0.200
     6.782    97.883     0.200
     6.703   100.086     0.200
     6.852   100.586     0.200
     6.917   102.195     0.200
     6.945    98.953     0.200
     7.005   104.984     0.200
     7.044   103.789     0.200
     7.017   102.188     0.200
     7.113   103.383     0.200
     7.199   103.789     0.200
     7.200   107.086     0.200
     7.187   104.383     0.200
     7.187   104.086     0.200
     7.220   104.289     0.200
     7.218   105.484     0.200
     7.088   103.383     0.200
     7.242   108.289     0.200
     7.110   105.086     0.200
     7.256   105.789     0.200
     7.383   108.188     0.200
     7.511   110.383     0.200
     7.482   107.984     0.200
     7.528   109.289     0.200
     7.586   109.586     0.200
     7.543   111.086     0.200
     7.692   111.188     0.200
     7.625   111.086     0.200
     7.636   111.086     0.200
     7.695   111.586     0.200
     7.779   113.086     0.200
     7.935   114.023     0.200
     7.811   114.586     0.200
     7.994   114.883     0.200
     8.169   116.883     0.200
     8.296   120.086     0.200
     8.265   119.086     0.200
     8.386   119.586     0.200
     8.308   124.086     0.200
     8.429   119.688     0.200
     8.500   120.688     0.200
     8.540   121.383     0.200
     8.511   125.586     0.200
     8.631   123.289     0.200
     8.685   124.484     0.200
     8.719   124.188     0.200
     8.640   128.086     0.200
     8.879   125.688     0.200
     8.884   127.984     0.200
     8.921   129.383     0.200
     8.785   128.086     0.200
     8.908   132.586     0.200
     9.137   134.086     0.200
     9.207   130.883     0.200
     9.250   132.289     0.200
     9.381   133.383     0.200
     9.289   133.086     0.200
     9.526   134.984     0.200
     9.454   136.086     0.200
     9.603   135.883     0.200
     9.700   139.289     0.200
     9.693   138.086     0.200
     9.729   140.086     0.200
     9.740   139.484     0.200
     9.790   141.688     0.200
     9.813   138.586     0.200
     9.892   139.984     0.200
     9.796   141.086     0.200
     9.923   140.484     0.200
    10.097   145.789     0.200
    10.108   143.688     0.200
    10.004   143.086     0.200
    10.156   145.289     0.200
    10.411   147.586     0.200
    10.397   151.883     0.200
    11.052   157.289     0.200
    11.306   161.086     0.200
    11.203   165.586     0.200
    11.458   165.086     0.200
    12.050   171.484     0.200
    12.799   179.883     0.200
    13.088   184.086     0.200
    14.694   208.688     0.200
    20.238   277.984     0.200
     1.600    28.141     0.200
     1.915    33.242     0.200
     1.963    34.242     0.200
     2.238    38.039     0.200
     2.296    38.141     0.200
     2.422    39.742     0.200
     2.591    43.242     0.200
     2.625    43.039     0.200
     2.777    46.438     0.200
     2.796    45.344     0.200
     2.981    47.641     0.200
     3.038    49.242     0.200
     3.065    49.039     0.200
     3.277    53.242     0.200
     3.506    57.742     0.200
     3.678    58.141     0.200
     3.646    55.742     0.200
     3.794    58.641     0.200
     3.960    61.938     0.200
     4.356    66.141     0.200
     4.356    68.742     0.200
     4.415    68.438     0.200
     4.655    71.242     0.200
     4.791    73.141     0.200
     5.022    74.242     0.200
     5.143    76.242     0.200
     5.169    78.938     0.200
     5.175    76.039     0.200
     5.466    81.938     0.200
     5.522    82.742     0.200
     5.663    82.844     0.200
     5.785    85.742     0.200
     5.800    88.141     0.200
     6.075    89.844     0.200
     6.096    90.742     0.200
     6.190    92.344     0.200
     6.215    90.938     0.200
     6.408    95.141     0.200
     6.510    94.844     0.200
     6.543    96.844     0.200
     6.592    97.438     0.200
     6.723    99.438     0.200
     6.827   100.141     0.200
     7.178   103.844     0.200
     7.199   104.641     0.200
     7.208   103.938     0.200
     7.486   109.344     0.200
     7.503   107.641     0.200
     8.153   116.141     0.200
     8.492   120.938     0.200
     8.532   121.844     0.200
     8.714   124.242     0.200
     8.870   126.242     0.200
     9.506   134.844     0.200
     9.584   135.242     0.200
     9.796   138.742     0.200
     9.872   140.141     0.200
     1.978    33.938     0.200
     2.214    37.344     0.200
     2.813    46.844     0.200
     2.898    46.438     0.200
     3.036    49.539     0.200
     3.226    52.344     0.200
     3.242    52.438     0.200
     3.289    52.234     0.200
     3.468    55.438     0.200
     3.510    56.641     0.200
     3.570    56.938     0.200
     3.766    61.242     0.200
     3.930    60.938     0.200
     4.016    63.742     0.200
     3.991    64.039     0.200
     4.115    65.039     0.200
     4.150    65.344     0.200
     4.193    67.141     0.200
     4.530    70.141     0.200
     4.583    67.844     0.200
     4.647    73.438     0.200
     4.669    71.438     0.200
     4.669    73.438     0.200
     4.624    72.641     0.200
     4.667    74.641     0.200
     4.698    73.422     0.200
     4.786    72.844     0.200
     5.015    78.141     0.200
     5.097    79.938     0.200
     5.099    78.602     0.200
     5.179    78.141     0.200
     5.260    79.438     0.200
     5.376    80.938     0.200
     5.443    82.141     0.200
     5.526    85.539     0.200
     5.489    85.141     0.200
     5.586    85.039     0.200
     5.597    85.164     0.200
     5.574    85.141     0.200
     5.698    86.438     0.200
     5.759    87.383     0.200
     5.771    87.961     0.200
     5.883    87.242     0.200
     5.846    88.383     0.200
     5.941    90.141     0.200
     6.040    91.750     0.200
     5.998    92.938     0.200
     6.068    91.242     0.200
     6.109    92.797     0.200
     6.073    92.461     0.200
     6.215    93.539     0.200
     6.199    93.539     0.200
     6.258    95.641     0.200
     6.274    95.648     0.200
     6.310    93.438     0.200
     6.319    92.539     0.200
     6.331    95.539     0.200
     6.332    95.742     0.200
     6.340    95.242     0.200
     6.352    93.039     0.200
     6.359    96.312     0.200
     6.317    96.141     0.200
     6.316    94.539     0.200
     6.320    96.898     0.200
     6.425    97.117     0.200
     6.453    97.844     0.200
     6.459    96.344     0.200
     6.476    97.742     0.200
     6.474    97.539     0.200
     6.489    95.344     0.200
     6.468    97.344     0.200
     6.468    97.141     0.200
     6.579    99.062     0.200
     6.678    99.641     0.200
     6.671   101.938     0.200
     6.756   101.969     0.200
     6.724   100.641     0.200
     6.805   102.539     0.200
     6.799   102.141     0.200
     6.890   106.039     0.200
     6.967   104.141     0.200
     7.075   104.344     0.200
     7.096   105.438     0.200
     7.166   107.141     0.200
     7.331   111.141     0.200
     7.379   110.938     0.200
     7.481   108.641     0.200
     7.506   111.641     0.200
     7.538   112.641     0.200
     7.538   112.141     0.200
     7.745   113.742     0.200
     7.774   112.742     0.200
     7.851   115.539     0.200
     7.943   118.641     0.200
     8.026   119.641     0.200
     8.091   117.641     0.200
     8.092   119.039     0.200
     8.106   118.438     0.200
     8.106   118.141     0.200
     8.148   122.141     0.200
     8.503   122.242     0.200
     8.642   126.141     0.200
     8.722   132.438     0.200
     8.829   133.141     0.200
     8.875   128.039     0.200
     8.941   134.141     0.200
     9.029   133.242     0.200
     9.160   136.242     0.200
     9.426   134.438     0.200
     9.422   138.141     0.200
     9.491   137.844     0.200
     9.493   139.141     0.200
     9.515   141.641     0.200
     9.719   140.242     0.200
     9.867   141.742     0.200
     9.981   144.141     0.200
    10.244   151.039     0.200
    11.587   167.141     0.200
    14.282   202.039     0.200
    18.576   258.242     0.200
    19.785   271.742     0.200
    20.714   284.039     0.200
    20.878   284.844     0.200
     1.473    27.156     0.200
     1.761    31.758     0.200
     1.907    34.461     0.200
     2.053    34.359     0.200
     2.249    38.258     0.200
     2.490    42.258     0.200
     2.874    46.859     0.200
     2.869    46.156     0.200
     4.015    64.359     0.200
     4.225    66.961     0.200
     4.321    66.961     0.200
     4.442    70.562     0.200
     4.733    74.359     0.200
     4.745    74.062     0.200
     4.758    73.797     0.200
     5.182    77.359     0.200
     5.190    80.281     0.200
     5.838    86.859     0.200
     5.941    89.156     0.200
     6.041    91.359     0.200
     6.155    93.039     0.200
     6.264    93.156     0.200
     6.309    96.961     0.200
     6.293    93.461     0.200
     6.377    96.156     0.200
     6.383    97.602     0.200
     6.431    96.461     0.200
     6.502    98.461     0.200
     6.520    99.859     0.200
     6.543    97.656     0.200
     6.673    99.641     0.200
     6.644    99.562     0.200
     6.706    97.359     0.200
     7.295   108.062     0.200
     7.560   110.258     0.200
     7.852   114.859     0.200
     8.080   117.461     0.200
     8.883   128.656     0.200
     1.794    31.688     0.200
     1.881    33.688     0.200
     1.988    34.188     0.200
     2.259    37.688     0.200
     2.818    46.889     0.200
     2.872    48.789     0.200
     3.070    50.089     0.200
     3.258    52.789     0.200
     3.281    53.389     0.200
     3.280    52.789     0.200
     3.454    55.289     0.200
     3.496    55.989     0.200
     3.546    57.188     0.200
     3.602    57.589     0.200
     3.927    63.289     0.200
     3.970    63.989     0.200
     4.029    62.889     0.200
     4.029    64.589     0.200
     4.171    64.489     0.200
     4.148    65.589     0.200
     4.171    67.089     0.200
     4.185    66.188     0.200
     4.378    66.989     0.200
     4.574    70.489     0.200
     4.649    70.089     0.200
     4.644    72.589     0.200
     4.687    73.589     0.200
     4.706    71.889     0.200
     4.706    73.688     0.200
     4.703    73.469     0.200
     4.897    74.259     0.200
     5.124    79.089     0.200
     5.124    80.589     0.200
     5.117    78.909     0.200
     5.170    77.789     0.200
     5.410    82.188     0.200
     5.485    81.589     0.200
     5.592    84.789     0.200
     5.883    87.289     0.200
     5.866    88.789     0.200
     5.963    91.089     0.200
     6.096    91.489     0.200
     6.087    92.099     0.200
     6.220    93.188     0.200
     6.289    96.188     0.200
     6.278    96.239     0.200
     6.315    92.489     0.200
     6.361    96.188     0.200
     6.347    93.089     0.200
     6.334    94.909     0.200
     6.326    97.069     0.200
     6.499    96.289     0.200
     6.500    98.389     0.200
     6.484    95.188     0.200
     6.498    97.589     0.200
     6.619    97.089     0.200
     6.599    98.949     0.200
     6.682   100.688     0.200
     6.746   100.309     0.200
     6.824   101.889     0.200
     6.896   107.108     0.200
     7.015   104.549     0.200
     7.105   105.688     0.200
     7.150   106.589     0.200
     7.195   107.589     0.200
     7.335   108.289     0.200
     7.519   109.989     0.200
     7.551   111.089     0.200
     7.812   114.089     0.200
     7.888   116.389     0.200
     8.093   118.889     0.200
     8.103   119.089     0.200
     8.521   121.089     0.200
     8.634   125.789     0.200
     8.662   128.589     0.200
     8.676   123.789     0.200
     8.894   127.889     0.200
     9.199   135.089     0.200
     9.526   139.188     0.200
     9.532   138.489     0.200
    14.261   201.589     0.200
    19.823   273.389     0.200
     1.520    27.574     0.200
     2.012    35.273     0.200
     2.053    35.974     0.200
     2.149    37.374     0.200
     2.266    38.474     0.200
     2.265    37.273     0.200
     2.333    37.974     0.200
     2.766    45.674     0.200
     2.816    45.674     0.200
     3.099    49.574     0.200
     3.273    52.374     0.200
     3.456    54.773     0.200
     3.473    55.273     0.200
     3.649    58.273     0.200
     3.735    58.674     0.200
     3.814    60.074     0.200
     4.094    64.174     0.200
     4.099    63.674     0.200
     4.182    66.174     0.200
     4.199    64.974     0.200
     4.358    67.773     0.200
     4.383    67.773     0.200
     4.572    71.874     0.200
     4.577    72.374     0.200
     4.905    76.374     0.200
     4.966    74.374     0.200
     4.973    76.974     0.200
     5.244    79.474     0.200
     5.602    83.874     0.200
     5.651    87.374     0.200
     6.034    89.474     0.200
     6.066    90.273     0.200
     6.203    92.674     0.200
     6.217    92.574     0.200
     6.405    94.074     0.200
     6.477    97.654     0.200
     7.057   103.174     0.200
     7.417   109.174     0.200
     7.680   112.674     0.200
     8.545   123.174     0.200
     1.383    25.711     0.200
     1.445    25.977     0.200
     1.386    23.680     0.200
     1.585    26.781     0.200
     1.738    30.375     0.200
     2.175    35.078     0.200
     2.107    35.875     0.200
     2.389    38.078     0.200
     2.369    37.875     0.200
     2.265    36.680     0.200
     2.726    43.180     0.200
     2.651    42.180     0.200
     2.630    41.180     0.200
     2.712    42.578     0.200
     3.278    51.688     0.200
     2.939    46.281     0.200
     3.141    50.180     0.200
     3.118    49.281     0.200
     3.100    49.281     0.200
     3.256    51.680     0.200
     3.289    52.375     0.200
     3.603    56.875     0.200
     3.720    56.281     0.200
     3.801    58.078     0.200
     3.590    54.875     0.200
     3.530    55.078     0.200
     3.546    54.406     0.200
     3.561    53.680     0.200
     3.649    55.672     0.200
     3.677    56.875     0.200
     3.718    59.281     0.200
     4.131    61.875     0.200
     3.865    60.117     0.200
     4.239    62.922     0.200
     3.951    61.258     0.200
     4.259    64.180     0.200
     4.333    66.281     0.200
     4.412    65.875     0.200
     4.435    66.281     0.200
     4.446    66.977     0.200
     4.120    63.000     0.200
     4.514    66.875     0.200
     4.265    65.078     0.200
     4.350    65.961     0.200
     4.404    68.117     0.200
     4.397    67.078     0.200
     4.634    70.078     0.200
     4.554    70.680     0.200
     4.889    71.781     0.200
     4.948    73.078     0.200
     4.991    72.977     0.200
     4.653    70.977     0.200
     4.695    70.680     0.200
     4.775    72.578     0.200
     5.081    76.078     0.200
     5.241    76.477     0.200
     5.321    77.578     0.200
     5.072    75.438     0.200
     5.423    79.680     0.200
     5.137    76.578     0.200
     5.514    82.672     0.200
     5.534    81.078     0.200
     5.627    82.680     0.200
     5.640    83.297     0.200
     5.363    79.961     0.200
     5.408    80.602     0.200
     5.491    82.578     0.200
     5.416    82.078     0.200
     5.559    81.641     0.200
     5.619    84.078     0.200
     5.973    87.055     0.200
     6.052    88.680     0.200
     5.707    85.555     0.200
     6.061    89.297     0.200
     6.095    89.477     0.200
     5.806    86.039     0.200
     6.173    91.188     0.200
     6.220    90.977     0.200
     5.934    87.195     0.200
     6.273    91.680     0.200
     5.985    88.875     0.200
     5.978    88.078     0.200
     6.285    92.141     0.200
     6.308    92.680     0.200
     6.339    92.781     0.200
     6.355    93.281     0.200
     6.390    94.281     0.200
     6.475    96.281     0.200
     6.528    95.680     0.200
     6.571    96.180     0.200
     6.320    94.078     0.200
     6.282    91.797     0.200
     6.620    95.375     0.200
     6.598    96.695     0.200
     6.664    97.875     0.200
     6.664    98.680     0.200
     6.668    97.500     0.200
     6.384    93.281     0.200
     6.849    97.680     0.200
     6.851    97.422     0.200
     6.899    99.266     0.200
     6.591    97.578     0.200
     6.954   101.281     0.200
     6.718    99.078     0.200
     7.026   100.875     0.200
     7.043   103.477     0.200
     6.710    98.477     0.200
     7.009   102.875     0.200
     7.092   101.078     0.200
     7.175   104.781     0.200
     7.185   103.680     0.200
     7.137   104.680     0.200
     7.208   103.875     0.200
     7.229   107.781     0.200
     7.269   103.680     0.200
     7.281   101.461     0.200
     7.310   106.180     0.200
     7.385   109.977     0.200
     7.430   106.375     0.200
     7.477   107.578     0.200
     7.497   108.477     0.200
     7.250   104.578     0.200
     7.186   104.875     0.200
     7.537   107.180     0.200
     7.563   109.180     0.200
     7.558   107.578     0.200
     7.567   108.578     0.200
     7.242   105.977     0.200
     7.575   113.781     0.200
     7.614   110.180     0.200
     7.624   113.477     0.200
     7.694   110.375     0.200
     7.706   111.781     0.200
     7.704   110.781     0.200
     7.677   115.281     0.200
     7.721   111.781     0.200
     7.790   112.781     0.200
     7.819   114.281     0.200
     7.795   116.078     0.200
     7.869   114.180     0.200
     7.899   111.578     0.200
     7.901   113.477     0.200
     7.867   117.375     0.200
     7.691   113.078     0.200
     7.945   113.977     0.200
     8.066   115.867     0.200
     8.076   117.078     0.200
     8.157   118.078     0.200
     8.213   117.078     0.200
     8.254   118.078     0.200
     8.314   118.578     0.200
     8.351   118.781     0.200
     8.336   123.578     0.200
     8.487   120.281     0.200
     8.499   120.977     0.200
     8.496   121.477     0.200
     8.309   122.180     0.200
     8.661   123.078     0.200
     8.660   124.375     0.200
     8.759   123.477     0.200
     8.779   124.180     0.200
     8.896   126.578     0.200
     8.942   127.680     0.200
     8.978   127.977     0.200
     9.061   129.977     0.200
     9.036   131.477     0.200
     9.158   131.078     0.200
     9.161   129.578     0.200
     9.374   132.680     0.200
     9.139   131.078     0.200
     9.731   137.281     0.200
     9.737   137.977     0.200
     9.862   138.281     0.200
     9.963   142.055     0.200
     9.963   142.375     0.200
    10.024   143.828     0.200
    10.137   141.875     0.200
    10.115   146.078     0.200
    10.228   142.875     0.200
    10.253   143.375     0.200
    10.451   146.281     0.200
    10.468   149.578     0.200
    10.761   151.781     0.200
    11.571   162.180     0.200
    12.405   173.781     0.200
    13.124   185.281     0.200
    13.412   187.977     0.200
    13.484   189.875     0.200
    14.487   202.977     0.200
    19.389   265.078     0.200
    19.545   266.781     0.200
     1.374    23.056     0.200
     1.751    29.855     0.200
     2.124    35.176     0.200
     2.307    37.155     0.200
     2.136    34.056     0.200
     2.399    38.556     0.200
     2.253    35.956     0.200
     2.331    36.556     0.200
     2.348    37.355     0.200
     2.735    42.556     0.200
     2.594    40.855     0.200
     2.610    41.355     0.200
     2.673    42.355     0.200
     2.957    47.985     0.200
     3.100    48.956     0.200
     3.079    47.256     0.200
     3.286    51.056     0.200
     3.217    51.056     0.200
     3.249    51.456     0.200
     3.614    55.956     0.200
     3.509    53.556     0.200
     3.704    55.956     0.200
     3.662    56.355     0.200
     3.985    60.355     0.200
     4.227    62.256     0.200
     4.104    62.235     0.200
     4.350    65.655     0.200
     4.230    65.056     0.200
     4.461    66.355     0.200
     4.395    66.056     0.200
     4.322    65.516     0.200
     4.500    66.456     0.200
     4.378    66.556     0.200
     4.883    71.056     0.200
     4.750    71.556     0.200
     4.979    72.756     0.200
     5.109    75.855     0.200
     5.042    73.926     0.200
     5.239    76.155     0.200
     5.129    75.556     0.200
     5.312    77.456     0.200
     5.428    79.036     0.200
     5.527    82.155     0.200
     5.338    79.155     0.200
     5.377    78.956     0.200
     5.510    80.355     0.200
     5.399    81.256     0.200
     5.614    82.456     0.200
     5.457    81.556     0.200
     5.582    82.556     0.200
     5.688    84.636     0.200
     5.776    84.596     0.200
     6.113    88.956     0.200
     5.902    85.836     0.200
     5.951    87.756     0.200
     6.201    90.556     0.200
     6.266    92.655     0.200
     6.348    93.355     0.200
     6.391    94.155     0.200
     6.449    95.855     0.200
     6.256    91.235     0.200
     6.497    95.256     0.200
     6.283    92.556     0.200
     6.511    98.256     0.200
     6.540    96.355     0.200
     6.523    96.155     0.200
     6.578    99.756     0.200
     6.356    93.075     0.200
     6.575    95.456     0.200
     6.627    94.956     0.200
     6.665    99.155     0.200
     6.829   100.405     0.200
     6.849   101.056     0.200
     6.860    97.655     0.200
     6.684    98.556     0.200
     6.978   103.256     0.200
     7.034   103.355     0.200
     7.046   102.956     0.200
     7.102   101.056     0.200
     7.162   105.155     0.200
     7.226   103.256     0.200
     7.440   105.756     0.200
     7.502   108.056     0.200
     7.552   106.355     0.200
     7.572   107.155     0.200
     7.572   108.056     0.200
     7.550   108.056     0.200
     7.588   109.756     0.200
     7.717   110.056     0.200
     7.717   110.655     0.200
     7.887   113.256     0.200
     7.946   113.155     0.200
     8.129   117.256     0.200
     8.498   119.655     0.200
     8.503   120.456     0.200
     8.680   123.956     0.200
     8.665   122.355     0.200
     8.784   123.456     0.200
     8.899   125.855     0.200
     8.944   126.655     0.200
     8.979   125.855     0.200
     9.059   130.956     0.200
     9.166   128.056     0.200
     9.360   135.456     0.200
     9.876   137.756     0.200
    10.142   146.355     0.200
    10.149   140.956     0.200
    10.242   142.655     0.200
    10.266   142.456     0.200
    10.467   145.756     0.200
     2.370    39.168     0.200
     2.632    43.039     0.200
     2.966    47.887     0.200
     3.506    55.379     0.200
     3.516    56.578     0.200
     3.595    56.766     0.200
     3.872    60.496     0.200
     4.250    64.766     0.200
     4.634    70.066     0.200
     4.916    73.297     0.200
     5.031    75.238     0.200
     5.152    79.238     0.200
     5.360    82.969     0.200
     5.779    87.367     0.200
     5.967    90.266     0.200
     5.988    88.566     0.200
     6.071    90.867     0.200
     6.118    91.469     0.200
     6.214    94.469     0.200
     6.325    94.539     0.200
     6.488    94.887     0.200
     6.602    97.668     0.200
     6.634    99.066     0.200
     6.659    98.066     0.200
     7.031   101.672     0.200
     7.175   104.168     0.200
     7.507   109.469     0.200
     8.127   116.668     0.200
     8.430   119.469     0.200
     8.636   123.867     0.200
     8.810   126.066     0.200
     9.776   139.367     0.200
    20.614   282.719     0.200
     1.497    26.980     0.200
     1.575    26.082     0.200
     1.892    31.883     0.200
     2.392    38.184     0.200
     2.450    39.961     0.200
     2.620    43.082     0.200
     2.664    42.461     0.200
     2.903    47.012     0.200
     2.948    46.641     0.200
     3.033    48.582     0.200
     2.999    47.402     0.200
     3.369    53.980     0.200
     3.362    53.660     0.200
     3.540    55.660     0.200
     3.555    55.754     0.200
     3.651    57.281     0.200
     4.082    62.582     0.200
     4.227    62.082     0.200
     4.199    63.684     0.200
     4.299    64.480     0.200
     4.585    71.082     0.200
     4.687    68.980     0.200
     5.408    81.980     0.200
     5.480    81.883     0.200
     6.041    87.980     0.200
     6.357    94.270     0.200
     7.082   101.258     0.200
     7.187   103.883     0.200
     7.513   107.383     0.200
     8.144   115.883     0.200
     8.666   123.184     0.200
    20.674   279.730     0.200
     1.489    27.443     0.200
     1.892    33.343     0.200
     2.299    39.143     0.200
     2.373    39.243     0.200
     2.385    40.543     0.200
     2.390    40.183     0.200
     2.551    43.303     0.200
     2.608    42.723     0.200
     2.837    47.283     0.200
     2.926    47.743     0.200
     2.901    46.483     0.200
     2.942    47.223     0.200
     3.024    49.943     0.200
     3.206    52.343     0.200
     3.248    53.543     0.200
     3.304    54.143     0.200
     3.290    54.233     0.200
     3.481    55.583     0.200
     3.491    56.103     0.200
     3.577    57.343     0.200
     3.887    61.243     0.200
     3.952    60.713     0.200
     4.004    62.343     0.200
     4.091    64.443     0.200
     4.032    64.243     0.200
     4.159    63.943     0.200
     4.167    66.743     0.200
     4.538    71.243     0.200
     4.618    70.343     0.200
     4.703    71.143     0.200
     4.673    72.243     0.200
     4.748    74.243     0.200
     4.911    73.243     0.200
     5.075    75.643     0.200
     5.159    79.043     0.200
     5.169    78.343     0.200
     5.491    83.243     0.200
     5.697    85.943     0.200
     5.769    88.243     0.200
     5.973    89.443     0.200
     6.058    91.243     0.200
     6.131    92.643     0.200
     6.616    99.043     0.200
     6.631    99.743     0.200
     6.675   100.943     0.200
     6.802   103.043     0.200
     7.182   105.043     0.200
     7.312   107.243     0.200
     8.132   117.743     0.200
     8.431   121.043     0.200
     8.635   124.043     0.200
     8.811   127.243     0.200
     9.782   139.043     0.200
     9.898   140.643     0.200
     1.905    32.574     0.200
     1.956    33.773     0.200
     2.128    35.574     0.200
     2.251    37.773     0.200
     2.485    40.074     0.200
     2.394    39.074     0.200
     2.394    39.074     0.200
     2.578    42.422     0.200
     2.519    40.273     0.200
     2.602    41.965     0.200
     2.855    46.422     0.200
     2.878    45.703     0.200
     3.040    48.074     0.200
     2.940    46.793     0.200
     3.126    49.473     0.200
     3.355    53.273     0.200
     3.409    53.375     0.200
     3.324    53.043     0.200
     3.382    53.773     0.200
     3.538    54.773     0.200
     3.483    54.672     0.200
     3.503    55.312     0.200
     3.602    56.973     0.200
     3.632    55.074     0.200
     3.753    57.172     0.200
     4.071    63.172     0.200
     4.087    61.074     0.200
     3.938    61.273     0.200
     4.131    62.672     0.200
     4.118    64.473     0.200
     4.293    65.172     0.200
     4.372    65.574     0.200
     4.446    66.402     0.200
     4.555    67.445     0.200
     4.574    67.973     0.200
     4.515    70.273     0.200
     4.703    69.395     0.200
     4.715    69.945     0.200
     4.721    69.793     0.200
     4.712    70.473     0.200
     4.752    70.875     0.200
     4.772    70.715     0.200
     4.795    70.773     0.200
     4.662    71.273     0.200
     4.813    72.875     0.200
     4.868    73.672     0.200
     4.994    73.145     0.200
     5.020    73.844     0.200
     5.039    74.273     0.200
     5.155    75.672     0.200
     5.194    76.574     0.200
     5.260    79.375     0.200
     5.268    77.754     0.200
     5.455    80.574     0.200
     5.482    81.375     0.200
     5.403    80.773     0.200
     5.382    79.875     0.200
     5.679    86.672     0.200
     5.868    86.172     0.200
     6.071    90.473     0.200
     6.091    89.973     0.200
     6.106    90.074     0.200
     6.161    92.574     0.200
     6.175    91.574     0.200
     6.174    91.273     0.200
     6.194    91.672     0.200
     6.207    91.875     0.200
     6.338    93.375     0.200
     6.381    92.672     0.200
     6.381    96.473     0.200
     6.446    95.102     0.200
     6.513    95.574     0.200
     6.558    98.172     0.200
     6.686    99.574     0.200
     6.740   100.574     0.200
     6.757    99.672     0.200
     6.817   100.672     0.200
     6.817   100.773     0.200
     6.868   103.074     0.200
     6.944   100.672     0.200
     6.836   101.773     0.200
     7.082   103.973     0.200
     7.082   104.375     0.200
     7.120   104.172     0.200
     7.150   102.973     0.200
     7.150   103.160     0.200
     7.181   103.273     0.200
     7.181   103.672     0.200
     7.266   105.473     0.200
     7.280   105.074     0.200
     7.300   104.273     0.200
     7.318   105.875     0.200
     7.446   107.574     0.200
     7.560   109.484     0.200
     7.589   109.773     0.200
     7.604   110.875     0.200
     7.726   111.184     0.200
     7.855   113.742     0.200
     8.032   114.953     0.200
     8.216   117.273     0.200
     8.237   117.672     0.200
     8.259   116.973     0.200
     8.118   118.875     0.200
     8.394   121.074     0.200
     8.432   119.773     0.200
     8.548   121.172     0.200
     8.493   124.734     0.200
     8.672   123.172     0.200
     8.722   124.773     0.200
     8.756   124.375     0.200
     9.071   134.273     0.200
     9.229   131.172     0.200
     9.256   130.875     0.200
     9.656   138.273     0.200
     9.816   140.562     0.200
     9.885   138.672     0.200
     9.971   140.473     0.200
     9.999   140.672     0.200
    10.192   143.574     0.200
     1.325    23.492     0.200
     1.287    22.594     0.200
     1.447    24.992     0.200
     1.553    27.391     0.200
     1.791    29.992     0.200
     1.914    32.891     0.200
     2.047    34.594     0.200
     2.162    35.289     0.200
     2.343    37.992     0.200
     2.441    40.055     0.200
     2.788    44.930     0.200
     2.744    44.594     0.200
     2.854    44.094     0.200
     3.074    47.461     0.200
     3.333    52.203     0.200
     3.382    53.648     0.200
     3.346    51.891     0.200
     3.489    54.445     0.200
     3.450    53.500     0.200
     3.511    53.680     0.200
     3.721    58.555     0.200
     3.775    59.055     0.200
     3.815    59.633     0.200
     3.845    59.992     0.200
     4.302    65.492     0.200
     4.549    69.711     0.200
     4.607    69.094     0.200
     4.703    69.391     0.200
     5.062    74.492     0.200
     5.112    76.594     0.200
     5.177    75.211     0.200
     5.153    77.492     0.200
     5.564    81.992     0.200
     5.623    85.148     0.200
     5.734    83.594     0.200
     5.816    84.992     0.200
     6.416    92.992     0.200
     6.447    94.094     0.200
     6.530    95.289     0.200
     6.541    96.391     0.200
     6.555    95.594     0.200
     6.816    99.867     0.200
     7.007   101.891     0.200
     7.055   103.195     0.200
     7.124   103.891     0.200
     7.186   105.695     0.200
     7.291   107.594     0.200
     7.466   106.445     0.200
     7.638   110.391     0.200
     7.658   111.492     0.200
     7.762   111.992     0.200
     7.862   116.391     0.200
     7.951   117.492     0.200
     8.603   121.594     0.200
     8.918   126.992     0.200
     9.298   130.891     0.200
    10.360   147.195     0.200
    10.547   150.195     0.200
     1.635    28.281     0.200
     1.633    28.882     0.200
     1.647    28.151     0.200
     1.677    28.852     0.200
     1.788    30.621     0.200
     1.921    31.102     0.200
     2.012    34.012     0.200
     2.126    35.182     0.200
     2.534    40.691     0.200
     2.781    44.861     0.200
     2.787    43.251     0.200
     2.866    44.932     0.200
     2.958    47.562     0.200
     2.988    47.861     0.200
     3.239    51.371     0.200
     3.260    51.802     0.200
     3.327    52.401     0.200
     3.700    57.342     0.200
     3.759    60.151     0.200
     3.869    60.411     0.200
     3.888    60.361     0.200
     3.888    60.361     0.200
     4.055    61.251     0.200
     4.151    63.951     0.200
     4.148    64.021     0.200
     4.262    64.241     0.200
     4.280    64.951     0.200
     4.345    65.281     0.200
     4.354    66.151     0.200
     4.394    67.352     0.200
     4.471    66.812     0.200
     4.469    67.451     0.200
     4.818    71.951     0.200
     5.902    86.651     0.200
     6.035    90.251     0.200
     6.120    91.052     0.200
     6.169    90.552     0.200
     6.365    92.552     0.200
     6.411    93.552     0.200
     6.640    99.052     0.200
     6.664    97.052     0.200
     7.028   101.052     0.200
     7.048   101.352     0.200
     7.221   104.951     0.200
     7.322   106.251     0.200
     7.492   106.552     0.200
     8.014   114.852     0.200
     8.100   116.451     0.200
     8.375   118.751     0.200
     8.752   122.251     0.200
     8.752   123.852     0.200
     9.653   136.352     0.200
     1.630    29.227     0.200
     1.644    29.336     0.200
     1.673    29.738     0.200
     1.647    29.117     0.200
     1.781    31.516     0.200
     1.928    32.195     0.200
     2.023    35.168     0.200
     2.023    35.035     0.200
     2.324    39.598     0.200
     2.780    45.195     0.200
     2.795    45.195     0.200
     2.853    46.117     0.200
     2.891    47.488     0.200
     2.891    47.238     0.200
     2.955    47.746     0.200
     2.988    48.188     0.200
     3.137    51.035     0.200
     3.111    49.938     0.200
     3.142    50.465     0.200
     3.184    51.238     0.200
     3.191    51.426     0.200
     3.237    52.426     0.200
     3.237    51.988     0.200
     3.261    52.297     0.200
     3.272    52.637     0.200
     3.337    54.148     0.200
     3.326    53.258     0.200
     3.455    55.637     0.200
     3.506    55.938     0.200
     3.536    55.785     0.200
     3.697    59.535     0.200
     3.734    59.477     0.200
     3.740    59.016     0.200
     3.750    60.438     0.200
     3.753    58.766     0.200
     3.762    59.637     0.200
     3.796    60.625     0.200
     3.796    59.637     0.200
     3.774    59.977     0.200
     3.774    59.836     0.200
     3.803    59.516     0.200
     3.821    60.535     0.200
     3.868    61.547     0.200
     3.901    62.988     0.200
     3.887    61.898     0.200
     3.887    61.898     0.200
     3.911    61.938     0.200
     3.937    61.496     0.200
     3.937    60.637     0.200
     3.959    61.875     0.200
     3.977    64.117     0.200
     4.043    62.777     0.200
     4.082    62.188     0.200
     4.073    64.508     0.200
     4.115    65.008     0.200
     4.136    64.207     0.200
     4.172    64.367     0.200
     4.192    64.836     0.200
     4.206    67.137     0.200
     4.256    67.727     0.200
     4.250    65.656     0.200
     4.227    65.637     0.200
     4.268    65.637     0.200
     4.268    65.738     0.200
     4.285    67.637     0.200
     4.333    67.027     0.200
     4.324    69.336     0.200
     4.342    67.316     0.200
     4.342    66.535     0.200
     4.370    68.445     0.200
     4.382    66.238     0.200
     4.382    67.438     0.200
     4.463    68.336     0.200
     4.463    68.836     0.200
     4.459    68.176     0.200
     4.454    70.188     0.200
     4.497    71.047     0.200
     4.481    70.137     0.200
     4.553    68.398     0.200
     4.556    68.285     0.200
     4.565    71.336     0.200
     4.576    68.828     0.200
     4.649    69.516     0.200
     4.649    70.035     0.200
     4.646    72.918     0.200
     4.680    69.898     0.200
     4.686    70.348     0.200
     4.736    70.938     0.200
     4.735    71.059     0.200
     4.745    70.625     0.200
     4.788    71.008     0.200
     4.788    71.238     0.200
     4.806    73.238     0.200
     4.805    73.617     0.200
     4.824    72.785     0.200
     4.866    73.137     0.200
     4.925    73.277     0.200
     4.897    76.035     0.200
     4.931    73.727     0.200
     4.985    74.016     0.200
     4.971    76.566     0.200
     5.000    74.926     0.200
     5.000    75.035     0.200
     4.974    76.137     0.200
     5.022    74.758     0.200
     5.022    75.438     0.200
     5.040    75.656     0.200
     5.040    75.836     0.200
     5.066    75.625     0.200
     5.117    76.215     0.200
     5.117    77.535     0.200
     5.200    77.867     0.200
     5.254    80.348     0.200
     5.330    80.637     0.200
     5.388    82.637     0.200
     5.440    82.488     0.200
     5.451    82.438     0.200
     5.482    82.637     0.200
     5.482    82.535     0.200
     5.505    83.746     0.200
     5.559    82.836     0.200
     5.599    85.168     0.200
     5.621    84.637     0.200
     5.703    86.035     0.200
     5.752    88.195     0.200
     5.754    87.156     0.200
     5.771    86.098     0.200
     5.796    86.238     0.200
     5.776    86.938     0.200
     5.855    89.238     0.200
     5.857    87.438     0.200
     5.867    87.035     0.200
     5.895    88.637     0.200
     5.895    89.938     0.200
     5.903    89.836     0.200
     5.932    88.535     0.200
     5.944    90.535     0.200
     5.970    87.137     0.200
     5.975    89.637     0.200
     5.976    91.637     0.200
     6.022    90.137     0.200
     6.032    92.578     0.200
     6.072    92.535     0.200
     6.041    90.637     0.200
     6.076    88.785     0.200
     6.099    92.637     0.200
     6.099    92.836     0.200
     6.102    93.348     0.200
     6.102    92.348     0.200
     6.104    91.535     0.200
     6.108    91.836     0.200
     6.124    92.637     0.200
     6.156    91.938     0.200
     6.185    91.637     0.200
     6.218    92.336     0.200
     6.238    94.738     0.200
     6.251    93.738     0.200
     6.255    94.457     0.200
     6.255    94.336     0.200
     6.247    92.535     0.200
     6.243    94.637     0.200
     6.281    94.637     0.200
     6.342    96.027     0.200
     6.358    94.938     0.200
     6.360    93.008     0.200
     6.363    92.836     0.200
     6.370    94.836     0.200
     6.389    95.086     0.200
     6.405    95.336     0.200
     6.405    95.438     0.200
     6.431    92.848     0.200
     6.482    96.938     0.200
     6.529    94.938     0.200
     6.531    94.828     0.200
     6.532    99.637     0.200
     6.554    95.535     0.200
     6.625    95.336     0.200
     6.625    95.738     0.200
     6.628    98.535     0.200
     6.640    98.035     0.200
     6.619    97.637     0.200
     6.656    99.238     0.200
     6.656   100.938     0.200
     6.673    98.137     0.200
     6.725   100.648     0.200
     6.766    97.559     0.200
     6.786   100.035     0.200
     6.787   101.938     0.200
     6.786   100.637     0.200
     6.854   101.637     0.200
     6.875   101.547     0.200
     6.875   100.637     0.200
     6.909   101.836     0.200
     6.939   100.836     0.200
     6.947   101.535     0.200
     6.950   101.238     0.200
     6.945   103.637     0.200
     6.987   104.738     0.200
     6.988   105.137     0.200
     6.992   101.938     0.200
     7.018   102.438     0.200
     7.018   101.938     0.200
     7.039   102.836     0.200
     7.083   103.238     0.200
     7.083   103.738     0.200
     7.084   106.836     0.200
     7.127   104.035     0.200
     7.153   104.875     0.200
     7.153   108.535     0.200
     7.153   108.035     0.200
     7.181   104.637     0.200
     7.189   107.336     0.200
     7.186   104.938     0.200
     7.199   104.938     0.200
     7.214   107.637     0.200
     7.218   105.836     0.200
     7.230   106.637     0.200
     7.234   106.438     0.200
     7.234   105.535     0.200
     7.234   106.238     0.200
     7.266   108.836     0.200
     7.278   109.438     0.200
     7.314   109.137     0.200
     7.314   110.438     0.200
     7.308   106.637     0.200
     7.329   109.637     0.200
     7.360   107.535     0.200
     7.457   111.637     0.200
     7.480   108.637     0.200
     7.532   111.738     0.200
     7.567   110.906     0.200
     7.569   109.637     0.200
     7.576   109.535     0.200
     7.576   110.137     0.200
     7.620   109.637     0.200
     7.630   110.777     0.200
     7.693   114.211     0.200
     7.722   111.988     0.200
     7.745   113.637     0.200
     7.796   113.059     0.200
     7.801   112.215     0.200
     7.801   112.938     0.200
     7.859   113.938     0.200
     7.873   113.035     0.200
     7.888   113.035     0.200
     7.878   115.637     0.200
     7.972   115.535     0.200
     7.948   117.938     0.200
     8.004   115.836     0.200
     7.987   118.137     0.200
     8.019   117.137     0.200
     8.061   116.137     0.200
     8.061   115.566     0.200
     8.087   117.438     0.200
     8.087   117.238     0.200
     8.093   119.035     0.200
     8.093   120.637     0.200
     8.125   117.246     0.200
     8.177   120.637     0.200
     8.254   118.438     0.200
     8.254   118.156     0.200
     8.254   118.836     0.200
     8.257   120.035     0.200
     8.274   118.438     0.200
     8.278   121.738     0.200
     8.284   119.738     0.200
     8.364   119.637     0.200
     8.364   120.637     0.200
     8.369   122.637     0.200
     8.355   122.637     0.200
     8.386   121.738     0.200
     8.386   121.738     0.200
     8.442   123.637     0.200
     8.441   123.637     0.200
     8.435   122.637     0.200
     8.506   121.836     0.200
     8.506   121.578     0.200
     8.506   122.336     0.200
     8.533   127.035     0.200
     8.565   123.535     0.200
     8.565   123.059     0.200
     8.572   127.238     0.200
     8.669   126.637     0.200
     8.685   125.336     0.200
     8.694   126.938     0.200
     8.700   127.938     0.200
     8.741   125.035     0.200
     8.741   125.535     0.200
     8.727   127.637     0.200
     8.816   127.836     0.200
     8.816   127.246     0.200
     8.816   128.938     0.200
     8.864   131.656     0.200
     8.864   131.836     0.200
     8.902   128.188     0.200
     8.920   129.137     0.200
     8.960   129.648     0.200
     8.971   130.738     0.200
     9.013   131.637     0.200
     9.069   129.535     0.200
     9.067   136.836     0.200
     9.137   134.738     0.200
     9.171   135.336     0.200
     9.171   134.637     0.200
     9.169   134.336     0.200
     9.190   132.438     0.200
     9.190   133.035     0.200
     9.190   135.035     0.200
     9.187   135.438     0.200
     9.221   131.836     0.200
     9.313   137.156     0.200
     9.313   135.938     0.200
     9.347   133.637     0.200
     9.373   137.285     0.200
     9.446   136.637     0.200
     9.502   137.438     0.200
     9.502   138.035     0.200
     9.504   137.738     0.200
     9.504   138.336     0.200
     9.537   137.836     0.200
     9.544   138.938     0.200
     9.621   138.836     0.200
     9.622   142.836     0.200
     9.622   141.137     0.200
     9.643   137.738     0.200
     9.643   139.535     0.200
     9.624   140.137     0.200
     9.689   139.637     0.200
     9.699   141.535     0.200
     9.712   138.535     0.200
     9.718   139.035     0.200
     9.796   142.137     0.200
     9.922   142.035     0.200
     9.922   143.035     0.200
     9.897   144.836     0.200
     9.967   145.035     0.200
     9.937   144.035     0.200
     9.985   143.828     0.200
     9.989   145.727     0.200
     9.976   145.637     0.200
     9.983   145.637     0.200
    10.033   147.977     0.200
    10.044   146.637     0.200
    10.218   147.035     0.200
    10.296   148.637     0.200
    10.314   151.637     0.200
    10.360   152.035     0.200
    10.368   149.246     0.200
    10.490   151.828     0.200
    10.578   151.637     0.200
    10.678   155.328     0.200
    10.666   155.238     0.200
    10.731   155.836     0.200
    10.806   158.836     0.200
    10.806   159.637     0.200
    10.803   156.078     0.200
    10.847   157.836     0.200
    10.852   156.238     0.200
    10.872   155.258     0.200
    10.879   156.336     0.200
    10.892   156.637     0.200
    10.931   156.738     0.200
    10.970   158.105     0.200
    10.978   158.816     0.200
    10.991   158.316     0.200
    11.051   160.535     0.200
    11.179   160.535     0.200
    11.159   162.637     0.200
    11.280   162.637     0.200
    11.316   163.535     0.200
    11.390   165.836     0.200
    11.487   164.215     0.200
    11.509   165.938     0.200
    11.509   167.137     0.200
    11.580   168.035     0.200
    11.686   168.105     0.200
    11.666   169.137     0.200
    11.825   171.738     0.200
    11.854   170.336     0.200
    11.944   172.988     0.200
    12.224   173.648     0.200
    12.234   176.656     0.200
    12.324   177.195     0.200
    12.381   179.637     0.200
    12.635   185.336     0.200
    12.648   185.836     0.200
    12.890   184.926     0.200
    12.916   184.637     0.200
    12.922   185.148     0.200
    12.942   186.168     0.200
    12.997   188.617     0.200
    12.991   187.938     0.200
    13.273   190.438     0.200
    13.356   191.836     0.200
    13.415   192.035     0.200
    13.495   193.035     0.200
    13.495   193.355     0.200
    13.652   196.035     0.200
    13.839   196.996     0.200
    13.963   197.336     0.200
    13.963   199.238     0.200
    14.001   201.176     0.200
    14.032   202.547     0.200
    14.081   197.238     0.200
    14.228   201.438     0.200
    14.359   204.637     0.200
    14.384   207.035     0.200
    14.452   205.625     0.200
    14.452   205.848     0.200
    14.760   210.477     0.200
    14.774   209.828     0.200
    14.915   211.238     0.200
    15.027   214.105     0.200
    15.218   215.238     0.200
    15.408   215.637     0.200
    15.553   220.637     0.200
    15.594   221.238     0.200
    15.947   224.137     0.200
    15.944   223.945     0.200
    16.126   225.945     0.200
    16.244   223.066     0.200
    16.310   229.777     0.200
    16.381   230.098     0.200
    16.425   227.488     0.200
    16.475   231.617     0.200
    16.699   233.336     0.200
    16.853   234.078     0.200
    16.972   237.566     0.200
    18.262   252.348     0.200
    18.413   260.598     0.200
    18.430   256.551     0.200
    18.464   256.066     0.200
    18.464   257.125     0.200
    18.464   255.895     0.200
    18.520   257.707     0.200
    18.518   257.137     0.200
    18.645   259.938     0.200
    18.691   262.406     0.200
    18.740   260.238     0.200
    18.777   261.137     0.200
    18.789   260.488     0.200
    18.789   261.508     0.200
    18.956   262.438     0.200
    19.013   263.238     0.200
    19.015   263.828     0.200
    19.123   264.367     0.200
    19.256   265.738     0.200
    19.318   265.496     0.200
    19.408   267.438     0.200
    19.488   267.938     0.200
    19.488   267.938     0.200
    19.624   273.906     0.200
    19.708   272.938     0.200
    19.774   271.336     0.200
    19.917   273.438     0.200
    20.096   278.637     0.200
    20.186   275.938     0.200
    20.186   277.414     0.200
    20.212   277.137     0.200
    20.331   278.938     0.200
    20.409   278.336     0.200
    20.409   278.438     0.200
    20.417   279.438     0.200
    20.451   278.938     0.200
    20.471   279.668     0.200
    20.471   281.035     0.200
    20.643   281.637     0.200
    20.734   282.637     0.200
     1.665    29.176     0.200
     1.637    28.445     0.200
     1.897    31.305     0.200
     2.003    34.375     0.200
     2.307    39.176     0.200
     2.544    41.547     0.200
     2.746    44.234     0.200
     2.854    45.195     0.200
     2.923    47.727     0.200
     2.954    47.656     0.200
     3.098    50.727     0.200
     3.204    51.387     0.200
     3.226    50.945     0.200
     3.293    52.035     0.200
     3.666    58.285     0.200
     3.732    58.156     0.200
     3.747    57.906     0.200
     3.835    60.395     0.200
     3.854    60.695     0.200
     3.854    60.695     0.200
     3.964    61.785     0.200
     4.046    61.527     0.200
     4.089    61.645     0.200
     4.133    63.195     0.200
     4.248    64.594     0.200
     4.262    65.516     0.200
     4.329    65.926     0.200
     4.344    65.984     0.200
     4.387    65.715     0.200
     4.456    67.426     0.200
     4.497    69.016     0.200
     4.808    72.117     0.200
     4.832    71.734     0.200
     4.947    73.387     0.200
     5.127    75.555     0.200
     5.489    82.215     0.200
     5.927    89.117     0.200
     5.951    88.816     0.200
     5.994    87.016     0.200
     6.035    90.516     0.200
     6.101    89.156     0.200
     6.118    90.715     0.200
     6.123    90.617     0.200
     6.159    91.117     0.200
     6.196    91.316     0.200
     6.237    94.215     0.200
     6.266    92.914     0.200
     6.391    95.016     0.200
     6.438    94.016     0.200
     6.552    95.117     0.200
     6.646    98.117     0.200
     6.670    98.816     0.200
     6.686    99.117     0.200
     6.961   102.117     0.200
     7.015   102.617     0.200
     7.043   103.215     0.200
     7.047   102.117     0.200
     7.068   104.016     0.200
     7.190   104.215     0.200
     7.207   105.617     0.200
     7.484   107.414     0.200
     8.030   115.816     0.200
     8.387   119.715     0.200
     8.764   124.715     0.200
     8.834   130.836     0.200
     9.375   133.117     0.200
    20.882   285.277     0.200
     1.604    28.699     0.200
     1.617    28.777     0.200
     1.642    29.289     0.200
     1.762    31.379     0.200
     1.839    31.930     0.200
     1.947    32.488     0.200
     2.028    35.129     0.200
     2.324    39.328     0.200
     2.517    41.438     0.200
     2.810    45.879     0.200
     2.868    46.039     0.200
     2.812    45.020     0.200
     2.986    48.758     0.200
     3.018    48.629     0.200
     3.177    51.180     0.200
     3.108    51.277     0.200
     3.267    52.129     0.200
     3.328    53.477     0.200
     3.289    52.387     0.200
     3.356    53.309     0.200
     3.727    59.590     0.200
     3.733    58.816     0.200
     3.744    58.539     0.200
     3.755    60.148     0.200
     3.789    60.078     0.200
     3.898    61.566     0.200
     3.917    61.988     0.200
     3.917    61.988     0.200
     3.989    62.938     0.200
     4.055    64.457     0.200
     4.153    62.316     0.200
     4.245    67.258     0.200
     4.287    66.180     0.200
     4.245    66.078     0.200
     4.351    66.500     0.200
     4.355    68.277     0.200
     4.392    67.277     0.200
     4.301    68.898     0.200
     4.440    68.180     0.200
     4.476    68.559     0.200
     4.714    69.840     0.200
     4.819    72.879     0.200
     4.931    73.227     0.200
     5.017    74.688     0.200
     5.124    76.117     0.200
     5.284    79.680     0.200
     5.412    82.078     0.200
     5.576    82.578     0.200
     5.803    86.578     0.200
     5.876    88.977     0.200
     6.026    91.379     0.200
     6.067    88.406     0.200
     6.169    91.680     0.200
     6.239    93.797     0.200
     6.337    94.879     0.200
     6.383    93.879     0.200
     6.640    97.578     0.200
     6.693   101.078     0.200
     7.005   101.777     0.200
     7.026   101.977     0.200
     7.179   106.879     0.200
     7.197   104.477     0.200
     7.194   106.379     0.200
     7.297   108.379     0.200
     7.491   108.680     0.200
     7.993   115.180     0.200
     8.075   116.777     0.200
     8.298   120.500     0.200
     8.358   119.578     0.200
     8.421   123.379     0.200
     8.368   122.578     0.200
     8.734   123.977     0.200
     9.203   134.379     0.200
     9.631   137.578     0.200
     9.701   139.078     0.200
     9.698   138.379     0.200
     9.970   143.398     0.200
    10.580   151.117     0.200
    14.213   201.180     0.200
     1.659    29.828     0.200
     1.650    29.605     0.200
     1.804    32.398     0.200
     2.748    45.277     0.200
     2.775    45.438     0.200
     2.841    46.016     0.200
     2.923    47.578     0.200
     2.957    48.156     0.200
     3.155    52.738     0.200
     3.205    52.117     0.200
     3.230    51.559     0.200
     3.295    53.129     0.200
     3.512    55.867     0.200
     3.665    59.516     0.200
     3.733    60.559     0.200
     3.745    59.605     0.200
     3.761    58.926     0.200
     3.837    61.035     0.200
     3.855    61.656     0.200
     3.855    61.656     0.200
     4.033    62.496     0.200
     4.075    62.398     0.200
     4.129    65.879     0.200
     4.121    64.898     0.200
     4.236    65.738     0.200
     4.270    68.605     0.200
     4.207    65.957     0.200
     4.317    66.906     0.200
     4.331    67.156     0.200
     4.374    66.656     0.200
     4.444    68.277     0.200
     4.489    68.957     0.200
     4.654    72.059     0.200
     4.776    70.535     0.200
     4.795    72.855     0.200
     4.867    75.957     0.200
     4.933    74.078     0.200
     4.946    76.848     0.200
     4.949    76.758     0.200
     5.030    76.117     0.200
     5.114    76.527     0.200
     5.312    80.797     0.200
     5.476    82.957     0.200
     5.545    82.957     0.200
     5.605    84.957     0.200
     5.674    85.156     0.200
     5.776    87.508     0.200
     5.747    86.957     0.200
     5.917    88.758     0.200
     5.950    89.836     0.200
     5.954    91.457     0.200
     6.022    90.758     0.200
     6.088    89.637     0.200
     6.104    91.559     0.200
     6.109    91.957     0.200
     6.094    91.957     0.200
     6.146    91.758     0.200
     6.252    93.855     0.200
     6.212    93.758     0.200
     6.259    95.477     0.200
     6.381    94.355     0.200
     6.429    95.355     0.200
     6.633    99.059     0.200
     6.675    99.059     0.200
     6.762   101.457     0.200
     6.914   103.957     0.200
     7.035   102.656     0.200
     7.056   103.156     0.200
     7.177   105.156     0.200
     7.237   108.258     0.200
     7.334   109.355     0.200
     7.284   107.277     0.200
     7.322   108.957     0.200
     7.471   108.758     0.200
     8.018   115.758     0.200
     8.093   118.758     0.200
     8.114   118.059     0.200
     8.260   121.316     0.200
     8.275   120.957     0.200
     8.374   120.059     0.200
     8.751   125.258     0.200
     9.363   133.156     0.200
     9.659   138.059     0.200
     9.681   137.957     0.200
     9.940   141.957     0.200
    10.549   152.367     0.200
    10.938   154.656     0.200
     1.651    27.957     0.200
     1.767    29.656     0.200
     1.943    31.008     0.200
     2.031    34.176     0.200
     2.106    35.188     0.200
     2.131    36.598     0.200
     2.330    38.707     0.200
     2.514    39.965     0.200
     2.855    44.324     0.200
     2.880    45.816     0.200
     3.127    49.887     0.200
     3.173    50.836     0.200
     3.778    59.547     0.200
     4.337    65.324     0.200
     4.381    67.645     0.200
     4.448    66.547     0.200
     4.806    71.246     0.200
     5.881    85.645     0.200
     6.343    92.848     0.200
     6.389    92.746     0.200
     7.006   100.746     0.200
     7.027   100.945     0.200
     7.480   109.246     0.200
     7.993   114.145     0.200
     8.355   117.547     0.200
     8.731   122.848     0.200
     9.334   131.348     0.200
     9.632   135.645     0.200
     9.909   140.547     0.200
     1.433    25.594     0.200
     1.618    29.156     0.200
     1.648    29.117     0.200
     1.771    31.477     0.200
     1.938    31.984     0.200
     2.027    34.859     0.200
     2.326    40.016     0.200
     2.518    41.328     0.200
     2.857    45.477     0.200
     2.793    45.938     0.200
     2.805    44.797     0.200
     3.001    48.336     0.200
     3.112    49.547     0.200
     3.250    53.008     0.200
     3.274    52.141     0.200
     3.340    53.047     0.200
     3.710    59.703     0.200
     3.740    58.648     0.200
     3.882    61.539     0.200
     3.900    61.719     0.200
     3.900    61.719     0.200
     4.167    64.695     0.200
     4.274    67.500     0.200
     4.338    65.688     0.200
     4.383    67.297     0.200
     4.464    68.109     0.200
     4.452    68.000     0.200
     4.809    72.000     0.200
     4.928    73.109     0.200
     5.118    76.703     0.200
     5.564    82.398     0.200
     5.885    88.398     0.200
     6.159    90.594     0.200
     6.347    93.898     0.200
     6.394    93.695     0.200
     6.625    98.297     0.200
     6.647    98.695     0.200
     8.359   118.898     0.200
     8.736   124.094     0.200
     9.338   133.094     0.200
     9.636   137.398     0.200
     9.712   138.094     0.200
    10.209   146.594     0.200
    11.497   165.594     0.200
     1.648    28.969     0.200
     1.662    30.125     0.200
     1.646    29.492     0.200
     1.914    32.258     0.200
     2.319    39.969     0.200
     2.761    45.594     0.200
     2.849    45.742     0.200
     2.782    44.984     0.200
     2.970    48.625     0.200
     3.108    49.914     0.200
     3.218    52.508     0.200
     3.243    52.125     0.200
     3.308    53.602     0.200
     3.437    55.328     0.200
     3.679    59.906     0.200
     3.741    59.094     0.200
     3.755    58.914     0.200
     3.850    61.297     0.200
     3.868    61.828     0.200
     3.868    61.828     0.200
     4.130    64.188     0.200
     4.136    64.625     0.200
     4.261    67.523     0.200
     4.213    65.625     0.200
     4.326    66.602     0.200
     4.380    66.828     0.200
     4.453    67.992     0.200
     4.480    69.125     0.200
     4.802    72.523     0.200
     4.824    73.406     0.200
     4.935    73.836     0.200
     5.029    75.469     0.200
     4.956    76.125     0.200
     5.118    75.477     0.200
     5.481    82.625     0.200
     5.609    84.625     0.200
     5.776    87.781     0.200
     5.910    89.023     0.200
     5.961    90.625     0.200
     6.086    88.992     0.200
     6.111    91.523     0.200
     6.153    91.227     0.200
     6.371    92.938     0.200
     6.373    94.625     0.200
     6.420    95.125     0.200
     6.633    98.328     0.200
     6.669    99.328     0.200
     7.030   102.227     0.200
     7.051   102.828     0.200
     7.327   109.227     0.200
     7.477   108.625     0.200
     8.014   116.227     0.200
     8.372   120.023     0.200
     8.344   123.625     0.200
     8.749   124.922     0.200
     9.654   138.523     0.200
     9.726   139.727     0.200
    10.375   150.227     0.200
    10.869   156.523     0.200
     1.645    29.500     0.200
     1.627    29.531     0.200
     1.801    32.020     0.200
     2.545    42.500     0.200
     2.774    45.820     0.200
     2.771    45.121     0.200
     2.870    45.988     0.200
     2.913    47.871     0.200
     2.949    47.871     0.200
     2.978    48.109     0.200
     3.090    50.449     0.200
     3.229    51.801     0.200
     3.248    51.711     0.200
     3.316    53.102     0.200
     3.692    58.148     0.200
     3.720    59.082     0.200
     3.734    58.539     0.200
     3.747    60.512     0.200
     3.859    60.059     0.200
     3.878    60.469     0.200
     4.348    66.730     0.200
     4.359    69.910     0.200
     4.401    67.512     0.200
     4.481    68.711     0.200
     4.474    67.820     0.200
     4.823    73.109     0.200
     4.884    73.910     0.200
     4.952    74.648     0.200
     5.915    89.012     0.200
     6.174    92.109     0.200
     6.377    95.012     0.200
     6.424    95.012     0.200
     6.677    97.211     0.200
     7.040   102.809     0.200
     8.026   116.309     0.200
     8.387   120.012     0.200
     8.763   126.309     0.200
     9.368   133.711     0.200
     1.614    28.551     0.200
     1.659    29.078     0.200
     2.880    45.070     0.200
     4.071    61.930     0.200
     4.274    64.711     0.200
     4.356    65.711     0.200
     4.496    68.531     0.200
     4.833    72.230     0.200
     6.185    91.129     0.200
     6.392    94.230     0.200
     6.439    94.328     0.200
     6.693    97.328     0.200
     7.056   102.230     0.200
     7.077   102.230     0.200
     7.249   105.531     0.200
     7.509   106.430     0.200
     8.402   119.031     0.200
     8.476   123.730     0.200
    10.255   145.930     0.200
    10.884   155.328     0.200
     1.608    27.641     0.200
     1.621    28.199     0.200
     1.651    28.500     0.200
     1.637    28.551     0.200
     1.833    31.480     0.200
     1.942    32.090     0.200
     2.022    34.699     0.200
     2.318    38.770     0.200
     2.523    41.051     0.200
     2.872    45.000     0.200
     2.808    44.129     0.200
     2.887    46.539     0.200
     2.807    44.742     0.200
     2.984    46.582     0.200
     3.015    46.922     0.200
     3.134    50.301     0.200
     3.181    50.602     0.200
     3.183    50.012     0.200
     3.102    49.062     0.200
     3.102    48.602     0.200
     3.123    49.820     0.200
     3.334    53.391     0.200
     3.245    50.941     0.200
     3.481    55.402     0.200
     3.491    54.652     0.200
     3.491    54.199     0.200
     3.521    54.922     0.200
     3.632    58.000     0.200
     3.726    57.180     0.200
     3.787    58.402     0.200
     3.824    58.641     0.200
     3.772    58.301     0.200
     3.785    57.102     0.200
     3.728    57.301     0.200
     3.738    57.301     0.200
     3.751    58.902     0.200
     3.798    59.301     0.200
     3.936    60.801     0.200
     3.931    61.039     0.200
     3.931    60.902     0.200
     3.896    59.582     0.200
     3.915    60.449     0.200
     3.915    60.449     0.200
     3.989    61.902     0.200
     4.060    62.012     0.200
     4.096    61.492     0.200
     4.110    64.660     0.200
     4.157    62.961     0.200
     4.046    62.301     0.200
     4.181    63.191     0.200
     4.215    63.902     0.200
     4.239    65.641     0.200
     4.178    65.301     0.200
     4.251    66.602     0.200
     4.291    64.500     0.200
     4.163    67.441     0.200
     4.304    65.109     0.200
     4.355    65.680     0.200
     4.240    65.301     0.200
     4.360    66.320     0.200
     4.364    67.992     0.200
     4.397    65.902     0.200
     4.299    66.801     0.200
     4.298    68.230     0.200
     4.480    67.180     0.200
     4.445    67.602     0.200
     4.492    69.223     0.200
     4.568    68.051     0.200
     4.570    68.000     0.200
     4.559    69.941     0.200
     4.583    67.461     0.200
     4.436    68.832     0.200
     4.502    69.402     0.200
     4.513    72.961     0.200
     4.658    69.109     0.200
     4.693    69.191     0.200
     4.693    69.602     0.200
     4.698    69.680     0.200
     4.583    70.902     0.200
     4.583    70.500     0.200
     4.746    70.152     0.200
     4.747    70.199     0.200
     4.747    70.602     0.200
     4.627    71.480     0.200
     4.627    71.602     0.200
     4.800    70.480     0.200
     4.800    70.801     0.200
     4.688    71.441     0.200
     4.715    68.730     0.200
     4.824    72.402     0.200
     4.838    71.660     0.200
     4.880    72.531     0.200
     4.835    72.910     0.200
     4.937    72.879     0.200
     4.961    73.652     0.200
     4.922    75.102     0.200
     5.013    73.801     0.200
     5.013    74.500     0.200
     5.023    74.461     0.200
     5.052    74.480     0.200
     5.077    74.629     0.200
     4.994    75.922     0.200
     5.100    77.820     0.200
     5.129    75.859     0.200
     5.148    77.441     0.200
     5.282    79.750     0.200
     5.431    82.223     0.200
     5.339    80.242     0.200
     5.355    81.230     0.200
     5.496    81.602     0.200
     5.407    82.301     0.200
     5.494    82.590     0.200
     5.494    82.730     0.200
     5.580    81.902     0.200
     5.587    84.391     0.200
     5.628    83.801     0.200
     5.741    87.020     0.200
     5.742    87.129     0.200
     5.774    85.391     0.200
     5.805    85.500     0.200
     5.724    85.441     0.200
     5.842    88.102     0.200
     5.870    86.402     0.200
     5.799    86.000     0.200
     5.881    88.000     0.200
     5.889    89.902     0.200
     5.935    87.801     0.200
     5.931    89.699     0.200
     5.969    86.699     0.200
     5.963    89.500     0.200
     6.031    89.699     0.200
     6.020    91.012     0.200
     6.073    87.840     0.200
     6.059    91.301     0.200
     5.994    89.121     0.200
     5.988    90.801     0.200
     6.114    90.602     0.200
     6.116    90.500     0.200
     6.090    92.242     0.200
     6.090    91.012     0.200
     6.064    89.312     0.200
     6.174    90.801     0.200
     6.176    91.102     0.200
     6.221    92.000     0.200
     6.149    92.301     0.200
     6.224    93.102     0.200
     6.259    92.602     0.200
     6.244    92.762     0.200
     6.244    93.000     0.200
     6.206    91.402     0.200
     6.277    92.102     0.200
     6.331    94.699     0.200
     6.270    93.301     0.200
     6.355    91.812     0.200
     6.358    92.039     0.200
     6.342    93.402     0.200
     6.388    93.699     0.200
     6.339    93.570     0.200
     6.379    93.570     0.200
     6.295    94.199     0.200
     6.388    94.102     0.200
     6.424    92.141     0.200
     6.509    97.102     0.200
     6.528    95.000     0.200
     6.522    94.191     0.200
     6.458    95.039     0.200
     6.458    95.301     0.200
     6.550    94.199     0.200
     6.633    97.902     0.200
     6.642    97.602     0.200
     6.650    98.000     0.200
     6.645    97.801     0.200
     6.589    96.961     0.200
     6.697    96.602     0.200
     6.697    98.301     0.200
     6.622    97.301     0.200
     6.643    98.301     0.200
     6.715   100.332     0.200
     6.759    97.051     0.200
     6.790    99.500     0.200
     6.771   101.902     0.200
     6.845   101.340     0.200
     6.757    99.191     0.200
     6.881   100.902     0.200
     6.899   100.500     0.200
     6.910   100.902     0.200
     6.939   101.000     0.200
     6.957   101.199     0.200
     6.946   100.602     0.200
     6.991   101.402     0.200
     6.973   105.102     0.200
     6.970   103.801     0.200
     6.917   100.723     0.200
     6.917   100.902     0.200
     7.015   101.500     0.200
     7.015   101.902     0.200
     7.010   101.699     0.200
     7.010   101.301     0.200
     6.972   103.301     0.200
     7.031   101.801     0.200
     7.082   102.500     0.200
     7.082   102.602     0.200
     7.069   107.000     0.200
     7.029   102.641     0.200
     7.129   104.102     0.200
     7.129   104.402     0.200
     7.177   104.500     0.200
     7.181   104.102     0.200
     7.181   105.301     0.200
     7.202   104.500     0.200
     7.196   105.102     0.200
     7.172   106.500     0.200
     7.082   104.301     0.200
     7.213   105.500     0.200
     7.199   106.902     0.200
     7.225   106.301     0.200
     7.225   106.402     0.200
     7.236   106.102     0.200
     7.229   105.801     0.200
     7.250   108.199     0.200
     7.303   108.000     0.200
     7.355   106.902     0.200
     7.325   106.199     0.200
     7.354   108.301     0.200
     7.376   108.301     0.200
     7.441   110.801     0.200
     7.496   108.199     0.200
     7.572   109.652     0.200
     7.584   108.699     0.200
     7.578   109.199     0.200
     7.620   109.402     0.200
     7.617   110.000     0.200
     7.638   109.859     0.200
     7.715   113.680     0.200
     7.726   112.000     0.200
     7.680   113.301     0.200
     7.801   112.180     0.200
     7.800   111.480     0.200
     7.800   112.301     0.200
     7.758   113.301     0.200
     7.875   112.199     0.200
     7.973   114.020     0.200
     7.903   114.301     0.200
     7.999   114.801     0.200
     7.999   114.102     0.200
     7.916   119.301     0.200
     7.947   114.359     0.200
     7.973   116.801     0.200
     8.059   115.602     0.200
     8.059   115.062     0.200
     8.091   115.902     0.200
     8.080   118.602     0.200
     8.080   118.402     0.200
     8.131   116.781     0.200
     8.183   117.699     0.200
     8.255   118.301     0.200
     8.255   117.750     0.200
     8.255   118.402     0.200
     8.259   119.301     0.200
     8.218   123.102     0.200
     8.288   117.699     0.200
     8.303   118.801     0.200
     8.302   121.371     0.200
     8.364   119.000     0.200
     8.364   120.199     0.200
     8.387   120.301     0.200
     8.398   121.301     0.200
     8.398   121.301     0.200
     8.334   122.301     0.200
     8.426   122.402     0.200
     8.465   123.500     0.200
     8.362   122.301     0.200
     8.507   121.699     0.200
     8.507   120.902     0.200
     8.507   121.402     0.200
     8.458   122.680     0.200
     8.567   122.402     0.200
     8.567   121.742     0.200
     8.567   122.699     0.200
     8.477   125.301     0.200
     8.563   126.699     0.200
     8.563   126.902     0.200
     8.601   126.801     0.200
     8.708   124.602     0.200
     8.709   127.801     0.200
     8.699   127.301     0.200
     8.721   127.699     0.200
     8.726   126.500     0.200
     8.740   123.801     0.200
     8.740   122.699     0.200
     8.749   127.102     0.200
     8.660   127.301     0.200
     8.820   126.602     0.200
     8.820   125.980     0.200
     8.820   128.199     0.200
     8.909   129.000     0.200
     8.894   131.402     0.200
     8.894   131.160     0.200
     8.940   131.891     0.200
     8.940   127.570     0.200
     8.930   129.301     0.200
     9.068   128.902     0.200
     9.032   131.301     0.200
     9.195   134.102     0.200
     9.208   131.402     0.200
     9.209   132.902     0.200
     9.209   135.301     0.200
     9.167   134.602     0.200
     9.167   135.199     0.200
     9.235   131.801     0.200
     9.231   138.301     0.200
     9.288   132.711     0.200
     9.288   133.805     0.200
     9.288   134.902     0.200
     9.339   132.699     0.200
     9.339   132.301     0.200
     9.347   133.832     0.200
     9.484   136.102     0.200
     9.484   136.301     0.200
     9.459   136.301     0.200
     9.592   136.199     0.200
     9.628   137.402     0.200
     9.637   136.902     0.200
     9.637   135.902     0.200
     9.637   138.199     0.200
     9.651   142.500     0.200
     9.706   139.301     0.200
     9.704   137.699     0.200
     9.704   137.801     0.200
     9.716   138.102     0.200
     9.631   139.301     0.200
     9.913   141.500     0.200
     9.913   140.801     0.200
     9.995   145.602     0.200
     9.964   142.512     0.200
     9.964   144.352     0.200
    10.031   143.949     0.200
    10.039   146.711     0.200
    10.005   145.699     0.200
    10.011   144.102     0.200
    10.208   148.301     0.200
    10.208   147.102     0.200
    10.264   148.402     0.200
    10.264   149.699     0.200
    10.347   148.000     0.200
    10.345   147.879     0.200
    10.495   151.289     0.200
    10.587   151.301     0.200
    10.735   154.371     0.200
    10.791   155.500     0.200
    10.791   156.000     0.200
    10.833   155.402     0.200
    10.851   154.449     0.200
    10.851   154.562     0.200
    10.856   154.602     0.200
    10.932   156.301     0.200
    10.919   156.402     0.200
    10.975   157.062     0.200
    10.914   156.301     0.200
    10.955   155.520     0.200
    10.971   159.992     0.200
    10.971   156.371     0.200
    10.971   157.484     0.200
    11.058   159.402     0.200
    11.180   159.402     0.200
    11.183   160.301     0.200
    11.310   161.801     0.200
    11.359   165.801     0.200
    11.465   165.191     0.200
    11.490   166.801     0.200
    11.490   166.000     0.200
    11.598   168.000     0.200
    11.662   165.199     0.200
    11.843   169.602     0.200
    11.888   174.301     0.200
    11.918   168.652     0.200
    11.918   170.539     0.200
    12.205   173.141     0.200
    12.205   175.500     0.200
    12.163   179.301     0.200
    12.209   175.199     0.200
    12.335   179.301     0.200
    12.345   176.602     0.200
    12.345   176.301     0.200
    12.910   183.500     0.200
    12.916   181.051     0.200
    12.916   182.930     0.200
    12.970   185.852     0.200
    12.970   184.965     0.200
    13.014   187.301     0.200
    13.096   183.223     0.200
    13.096   187.320     0.200
    13.096   186.844     0.200
    13.435   193.199     0.200
    13.522   192.199     0.200
    13.627   195.840     0.200
    13.627   191.668     0.200
    13.824   198.301     0.200
    13.865   197.301     0.200
    13.954   196.602     0.200
    13.974   199.262     0.200
    13.974   196.707     0.200
    14.023   197.926     0.200
    14.023   198.301     0.200
    14.056   201.301     0.200
    14.219   200.102     0.200
    14.331   205.457     0.200
    14.366   204.902     0.200
    14.388   201.301     0.200
    14.428   202.871     0.200
    14.428   204.516     0.200
    14.551   203.160     0.200
    14.551   206.672     0.200
    14.551   204.887     0.200
    14.734   205.859     0.200
    14.734   208.402     0.200
    14.750   207.242     0.200
    14.896   210.672     0.200
    15.070   211.652     0.200
    15.070   213.625     0.200
    15.232   215.699     0.200
    15.303   213.902     0.200
    15.303   215.395     0.200
    15.330   215.133     0.200
    15.305   212.902     0.200
    15.375   215.879     0.200
    15.344   213.602     0.200
    15.436   215.301     0.200
    15.574   217.840     0.200
    15.709   219.340     0.200
    15.729   219.473     0.200
    15.917   222.172     0.200
    15.924   224.152     0.200
    15.936   223.301     0.200
    15.936   223.797     0.200
    15.946   223.602     0.200
    15.960   222.000     0.200
    16.129   226.160     0.200
    16.106   226.852     0.200
    16.124   226.199     0.200
    16.311   229.000     0.200
    16.438   228.801     0.200
    16.622   232.371     0.200
    16.727   233.801     0.200
    16.739   233.293     0.200
    17.375   241.301     0.200
    17.827   246.879     0.200
    18.278   251.551     0.200
    18.545   257.352     0.200
    18.620   258.102     0.200
    18.770   261.570     0.200
    18.714   260.301     0.200
    18.821   260.199     0.200
    18.755   258.500     0.200
    18.893   263.281     0.200
    18.791   258.801     0.200
    18.913   260.332     0.200
    18.805   260.199     0.200
    18.805   261.531     0.200
    19.057   262.699     0.200
    19.076   263.371     0.200
    19.126   264.410     0.200
    19.026   262.000     0.200
    19.142   264.270     0.200
    19.229   263.801     0.200
    19.360   265.641     0.200
    19.521   268.301     0.200
    19.770   272.301     0.200
    19.911   274.699     0.200
    19.985   272.242     0.200
    20.121   276.301     0.200
    20.205   279.020     0.200
    20.092   274.602     0.200
    20.197   275.301     0.200
    20.222   276.301     0.200
    20.342   277.699     0.200
    20.478   278.000     0.200
    20.428   277.902     0.200
    20.499   279.410     0.200
    20.499   279.602     0.200
    20.679   281.102     0.200
    20.654   281.500     0.200
    20.716   281.301     0.200
    20.762   282.301     0.200
    20.872   284.242     0.200
     1.648    28.727     0.200
     1.859    31.375     0.200
     2.041    34.406     0.200
     2.504    40.676     0.200
     2.871    45.727     0.200
     2.837    44.887     0.200
     3.011    48.035     0.200
     3.045    47.938     0.200
     3.158    50.176     0.200
     3.157    49.848     0.200
     3.197    50.555     0.200
     3.116    49.156     0.200
     3.124    48.668     0.200
     3.294    51.945     0.200
     3.317    51.855     0.200
     3.383    53.305     0.200
     3.473    55.215     0.200
     3.499    54.016     0.200
     3.527    55.016     0.200
     3.662    57.848     0.200
     3.753    58.918     0.200
     3.761    59.395     0.200
     3.816    58.746     0.200
     3.737    58.117     0.200
     3.745    57.918     0.200
     3.747    58.836     0.200
     3.906    60.105     0.200
     3.795    59.574     0.200
     3.925    61.016     0.200
     3.944    61.637     0.200
     3.944    61.637     0.200
     4.013    61.484     0.200
     4.056    61.625     0.200
     4.159    64.258     0.200
     4.033    62.547     0.200
     4.213    65.074     0.200
     4.272    65.418     0.200
     4.295    65.348     0.200
     4.357    66.156     0.200
     4.357    65.977     0.200
     4.338    66.695     0.200
     4.391    65.445     0.200
     4.290    67.715     0.200
     4.482    67.668     0.200
     4.414    67.145     0.200
     4.467    69.047     0.200
     4.562    67.395     0.200
     4.534    69.855     0.200
     4.440    69.047     0.200
     4.685    68.758     0.200
     4.689    69.188     0.200
     4.735    69.617     0.200
     4.791    70.168     0.200
     4.821    71.746     0.200
     4.688    69.246     0.200
     4.716    71.586     0.200
     4.873    72.008     0.200
     4.922    72.605     0.200
     5.004    73.605     0.200
     5.003    73.887     0.200
     5.043    74.035     0.200
     5.066    73.887     0.200
     5.025    75.387     0.200
     5.119    75.375     0.200
     5.405    81.297     0.200
     5.366    80.508     0.200
     5.489    81.645     0.200
     5.343    81.516     0.200
     5.467    81.836     0.200
     5.558    83.996     0.200
     5.713    86.516     0.200
     5.756    85.246     0.200
     5.754    84.984     0.200
     5.830    86.246     0.200
     5.853    87.145     0.200
     5.947    86.145     0.200
     6.019    89.848     0.200
     5.992    90.125     0.200
     6.051    87.727     0.200
     6.101    90.547     0.200
     6.102    90.246     0.200
     6.062    91.117     0.200
     6.062    91.207     0.200
     6.024    89.625     0.200
     6.171    90.945     0.200
     6.156    90.746     0.200
     6.203    92.547     0.200
     6.180    91.746     0.200
     6.245    92.047     0.200
     6.303    93.816     0.200
     6.334    91.207     0.200
     6.313    93.047     0.200
     6.300    93.746     0.200
     6.352    93.188     0.200
     6.358    93.246     0.200
     6.324    93.785     0.200
     6.400    91.566     0.200
     6.506    94.246     0.200
     6.496    93.457     0.200
     6.616    97.746     0.200
     6.624    97.945     0.200
     6.618    97.746     0.200
     6.688    98.234     0.200
     6.674    97.746     0.200
     6.733    96.516     0.200
     6.772   100.945     0.200
     6.786    99.227     0.200
     6.890   100.848     0.200
     6.918   100.945     0.200
     6.970   100.547     0.200
     6.992   101.246     0.200
     6.985   100.848     0.200
     7.006   101.246     0.200
     7.062   102.445     0.200
     7.111   103.645     0.200
     7.154   103.945     0.200
     7.195   102.746     0.200
     7.174   104.246     0.200
     7.189   105.047     0.200
     7.170   106.848     0.200
     7.204   105.445     0.200
     7.275   107.848     0.200
     7.331   106.348     0.200
     7.407   108.746     0.200
     7.491   107.246     0.200
     7.560   108.547     0.200
     7.594   109.547     0.200
     7.719   111.836     0.200
     7.975   114.348     0.200
     8.052   117.746     0.200
     8.307   120.918     0.200
     8.343   118.348     0.200
     8.363   121.746     0.200
     8.397   122.445     0.200
     8.719   123.547     0.200
     8.920   130.188     0.200
     9.210   134.746     0.200
     9.313   131.945     0.200
     9.454   135.945     0.200
     9.612   135.945     0.200
     9.678   136.945     0.200
     9.695   137.348     0.200
     9.887   140.547     0.200
    10.012   143.516     0.200
    10.181   144.746     0.200
    10.600   148.945     0.200
    10.913   152.848     0.200
    12.885   181.246     0.200
    18.480   254.797     0.200
    19.501   266.625     0.200
    20.224   276.125     0.200
     1.582    27.328     0.200
     1.647    28.340     0.200
     1.966    31.648     0.200
     2.038    34.691     0.200
     2.332    39.301     0.200
     2.507    40.539     0.200
     2.871    45.371     0.200
     2.867    46.531     0.200
     2.831    45.508     0.200
     2.830    44.340     0.200
     3.006    48.398     0.200
     3.039    48.391     0.200
     3.116    50.039     0.200
     3.161    49.910     0.200
     3.114    49.719     0.200
     3.288    51.961     0.200
     3.311    52.148     0.200
     3.378    53.059     0.200
     3.748    58.840     0.200
     3.736    58.230     0.200
     3.920    61.000     0.200
     3.938    61.359     0.200
     3.938    61.359     0.200
     4.090    63.930     0.200
     4.294    66.031     0.200
     4.357    67.930     0.200
     4.356    65.500     0.200
     4.391    67.230     0.200
     4.292    67.852     0.200
     4.420    67.031     0.200
     4.924    72.258     0.200
     5.006    73.961     0.200
     5.121    76.602     0.200
     5.759    84.820     0.200
     5.921    87.828     0.200
     5.921    87.930     0.200
     5.950    85.531     0.200
     5.950    85.730     0.200
     6.055    87.238     0.200
     6.206    92.230     0.200
     6.318    92.328     0.200
     6.364    93.031     0.200
     6.510    93.828     0.200
     6.921   101.031     0.200
     6.989   100.430     0.200
     7.010   101.230     0.200
     7.158   104.129     0.200
     7.280   107.730     0.200
     7.979   114.531     0.200
     8.346   118.129     0.200
     8.722   123.531     0.200
     9.891   140.531     0.200
    10.767   155.730     0.200
    11.821   167.629     0.200
     1.448    25.238     0.200
     1.659    28.801     0.200
     1.734    30.398     0.200
     1.975    31.828     0.200
     2.050    34.871     0.200
     2.495    41.480     0.200
     2.840    45.301     0.200
     2.859    44.668     0.200
     3.104    50.059     0.200
     4.412    67.250     0.200
     4.912    72.590     0.200
     5.849    86.551     0.200
     6.310    92.551     0.200
     6.978   101.148     0.200
     6.999   101.551     0.200
     7.270   105.250     0.200
     8.334   118.348     0.200
     8.710   123.551     0.200
     9.307   132.348     0.200
     9.881   140.648     0.200
     1.676    29.684     0.200
     1.972    32.926     0.200
     2.358    40.543     0.200
     2.836    45.715     0.200
     2.838    45.895     0.200
     3.142    52.156     0.200
     3.767    59.695     0.200
     3.802    62.535     0.200
     4.022    63.523     0.200
     4.123    64.523     0.200
     4.258    66.336     0.200
     4.320    66.266     0.200
     4.358    67.234     0.200
     4.421    68.035     0.200
     4.786    72.633     0.200
     4.897    73.625     0.200
     6.136    91.836     0.200
     6.315    94.434     0.200
     6.362    93.836     0.200
     6.976   101.133     0.200
     7.171   104.633     0.200
     7.458   108.035     0.200
     8.325   119.133     0.200
     8.702   124.434     0.200
     9.602   137.434     0.200
     9.670   137.734     0.200
     9.880   142.035     0.200
    13.921   196.633     0.200
     1.663    29.246     0.200
     1.739    30.824     0.200
     1.971    32.637     0.200
     2.051    35.316     0.200
     2.084    35.965     0.200
     2.347    40.137     0.200
     2.494    42.227     0.200
     2.824    46.426     0.200
     2.857    47.625     0.200
     2.853    45.555     0.200
     2.836    45.875     0.200
     2.996    49.047     0.200
     3.033    49.184     0.200
     3.105    51.773     0.200
     3.279    52.844     0.200
     3.307    52.625     0.200
     3.371    53.637     0.200
     3.737    60.414     0.200
     3.752    60.406     0.200
     3.808    62.773     0.200
     3.913    62.066     0.200
     3.930    62.316     0.200
     3.930    62.316     0.200
     4.039    62.797     0.200
     4.140    64.145     0.200
     4.253    65.137     0.200
     4.276    66.273     0.200
     4.338    66.203     0.200
     4.374    67.074     0.200
     4.418    67.676     0.200
     4.463    67.477     0.200
     4.803    72.375     0.200
     4.909    73.414     0.200
     5.104    75.465     0.200
     5.473    82.375     0.200
     5.853    86.977     0.200
     6.153    91.477     0.200
     6.314    93.477     0.200
     6.361    93.273     0.200
     6.616    97.676     0.200
     6.981   102.676     0.200
     7.001   103.176     0.200
     7.474   108.074     0.200
     8.334   120.574     0.200
     8.710   126.176     0.200
     9.607   138.773     0.200
     9.674   138.574     0.200
     9.686   138.977     0.200
     1.591    28.238     0.200
     1.605    28.738     0.200
     1.634    28.840     0.200
     1.670    29.418     0.200
     1.741    31.059     0.200
     1.864    32.301     0.200
     1.969    33.027     0.200
     2.055    35.750     0.200
     2.352    40.320     0.200
     2.490    41.539     0.200
     2.814    45.918     0.200
     2.842    45.738     0.200
     2.855    47.148     0.200
     2.835    45.891     0.200
     2.986    48.211     0.200
     3.024    48.949     0.200
     3.102    50.520     0.200
     3.148    51.078     0.200
     3.152    50.660     0.200
     3.136    49.828     0.200
     3.153    49.629     0.200
     3.197    51.609     0.200
     3.269    52.410     0.200
     3.301    53.910     0.200
     3.299    52.848     0.200
     3.267    51.668     0.200
     3.361    53.520     0.200
     3.464    56.230     0.200
     3.524    55.289     0.200
     3.553    55.578     0.200
     3.647    58.539     0.200
     3.726    59.340     0.200
     3.757    60.211     0.200
     3.795    59.410     0.200
     3.789    59.539     0.200
     3.761    59.320     0.200
     3.801    60.340     0.200
     3.771    59.039     0.200
     3.778    59.910     0.200
     3.865    62.699     0.200
     3.826    60.789     0.200
     3.911    62.539     0.200
     3.899    61.277     0.200
     3.903    61.891     0.200
     3.920    61.938     0.200
     3.920    61.938     0.200
     3.984    62.711     0.200
     4.029    62.379     0.200
     4.063    61.789     0.200
     4.078    64.277     0.200
     4.066    63.379     0.200
     4.129    64.461     0.200
     4.147    63.449     0.200
     4.208    66.020     0.200
     4.219    67.309     0.200
     4.242    65.551     0.200
     4.264    65.840     0.200
     4.327    66.527     0.200
     4.328    67.609     0.200
     4.333    68.449     0.200
     4.325    68.539     0.200
     4.365    66.141     0.200
     4.322    69.039     0.200
     4.451    68.051     0.200
     4.423    67.840     0.200
     4.460    70.250     0.200
     4.468    69.020     0.200
     4.535    68.117     0.200
     4.537    68.410     0.200
     4.528    70.730     0.200
     4.521    70.141     0.200
     4.549    68.219     0.200
     4.624    69.289     0.200
     4.660    69.480     0.200
     4.665    70.039     0.200
     4.713    70.520     0.200
     4.714    70.508     0.200
     4.657    72.027     0.200
     4.715    73.160     0.200
     4.714    69.641     0.200
     4.767    70.848     0.200
     4.793    72.641     0.200
     4.805    72.250     0.200
     4.848    72.910     0.200
     4.903    73.301     0.200
     4.935    76.938     0.200
     4.980    74.410     0.200
     4.989    75.008     0.200
     5.019    74.809     0.200
     5.014    77.039     0.200
     5.043    74.988     0.200
     5.096    76.258     0.200
     5.289    80.230     0.200
     5.369    81.480     0.200
     5.401    81.848     0.200
     5.376    81.949     0.200
     5.464    81.539     0.200
     5.466    82.629     0.200
     5.466    83.320     0.200
     5.551    82.738     0.200
     5.559    85.379     0.200
     5.559    84.789     0.200
     5.712    87.238     0.200
     5.740    86.027     0.200
     5.742    86.398     0.200
     5.771    85.840     0.200
     5.815    87.539     0.200
     5.815    87.238     0.200
     5.836    87.039     0.200
     5.855    87.840     0.200
     5.901    88.438     0.200
     5.904    89.641     0.200
     5.936    86.738     0.200
     5.998    89.938     0.200
     5.992    90.840     0.200
     6.016    90.078     0.200
     6.041    88.418     0.200
     6.032    90.938     0.200
     6.059    91.141     0.200
     6.062    92.148     0.200
     6.080    91.141     0.200
     6.082    90.840     0.200
     6.081    90.801     0.200
     6.143    91.641     0.200
     6.142    91.141     0.200
     6.162    93.539     0.200
     6.187    93.238     0.200
     6.198    92.738     0.200
     6.225    92.840     0.200
     6.216    93.898     0.200
     6.225    92.359     0.200
     6.269    92.141     0.200
     6.279    94.039     0.200
     6.302    94.598     0.200
     6.323    92.148     0.200
     6.326    91.777     0.200
     6.317    93.340     0.200
     6.321    95.160     0.200
     6.350    93.488     0.200
     6.364    93.938     0.200
     6.476    96.359     0.200
     6.495    95.141     0.200
     6.492    94.488     0.200
     6.518    94.348     0.200
     6.598    98.641     0.200
     6.609    98.340     0.200
     6.616    97.738     0.200
     6.617    98.539     0.200
     6.671   100.340     0.200
     6.658    99.539     0.200
     6.686    99.801     0.200
     6.728    97.098     0.200
     6.747   100.238     0.200
     6.781   100.398     0.200
     6.815   101.488     0.200
     6.873   101.938     0.200
     6.876   101.840     0.200
     6.905   100.738     0.200
     6.914   100.738     0.200
     6.958   101.438     0.200
     6.948   104.938     0.200
     6.947   103.539     0.200
     6.939   101.918     0.200
     6.947   102.641     0.200
     6.982   101.641     0.200
     6.980   101.641     0.200
     6.982   104.039     0.200
     7.001   102.039     0.200
     7.049   103.141     0.200
     7.044   105.938     0.200
     7.095   104.141     0.200
     7.145   104.539     0.200
     7.162   104.828     0.200
     7.162   106.438     0.200
     7.153   105.238     0.200
     7.170   104.641     0.200
     7.148   105.438     0.200
     7.163   104.938     0.200
     7.181   105.738     0.200
     7.174   106.738     0.200
     7.193   106.539     0.200
     7.197   105.840     0.200
     7.226   106.938     0.200
     7.275   108.738     0.200
     7.323   107.238     0.200
     7.349   108.078     0.200
     7.390   109.539     0.200
     7.464   108.340     0.200
     7.469   109.141     0.200
     7.532   109.438     0.200
     7.544   109.340     0.200
     7.587   109.539     0.200
     7.584   110.039     0.200
     7.688   112.879     0.200
     7.692   111.340     0.200
     7.767   111.738     0.200
     7.853   112.938     0.200
     7.967   115.340     0.200
     7.967   116.039     0.200
     8.026   115.641     0.200
     8.057   116.238     0.200
     8.053   118.738     0.200
     8.221   118.039     0.200
     8.272   119.840     0.200
     8.275   121.730     0.200
     8.331   118.840     0.200
     8.341   123.039     0.200
     8.364   120.840     0.200
     8.364   120.840     0.200
     8.401   122.840     0.200
     8.440   124.840     0.200
     8.473   121.738     0.200
     8.533   122.539     0.200
     8.684   129.938     0.200
     8.693   127.938     0.200
     8.707   124.539     0.200
     8.893   131.000     0.200
     8.920   130.699     0.200
     9.035   129.039     0.200
     9.151   131.238     0.200
     9.172   137.840     0.200
     9.180   136.039     0.200
     9.202   132.641     0.200
     9.276   134.809     0.200
     9.308   132.738     0.200
     9.336   136.777     0.200
     9.462   135.039     0.200
     9.559   136.438     0.200
     9.594   137.840     0.200
     9.606   136.738     0.200
     9.633   141.719     0.200
     9.674   139.340     0.200
     9.674   137.938     0.200
     9.683   138.238     0.200
     9.883   141.438     0.200
     9.946   145.949     0.200
     9.997   144.730     0.200
     9.996   143.000     0.200
    10.179   145.641     0.200
    10.328   150.508     0.200
    10.604   151.711     0.200
    10.950   158.617     0.200
    11.146   157.238     0.200
    11.647   168.590     0.200
    11.647   169.953     0.200
    11.815   167.840     0.200
    11.908   173.289     0.200
    11.908   171.863     0.200
    12.183   175.180     0.200
    12.196   176.020     0.200
    12.196   176.281     0.200
    12.879   181.738     0.200
    12.905   187.148     0.200
    12.905   185.883     0.200
    12.961   187.559     0.200
    12.961   188.855     0.200
    13.499   192.348     0.200
    13.615   197.359     0.200
    13.964   202.211     0.200
    14.414   205.961     0.200
    14.414   204.578     0.200
    15.984   223.859     0.200
    18.452   256.820     0.200
    18.471   256.879     0.200
    18.607   258.039     0.200
    19.303   267.117     0.200
    19.473   268.238     0.200
    19.473   267.918     0.200
     1.766    32.125     0.200
     1.944    34.008     0.200
     2.093    37.395     0.200
     2.499    42.145     0.200
     2.829    46.164     0.200
     4.018    63.195     0.200
     4.309    67.117     0.200
     4.452    68.785     0.200
     4.435    69.145     0.200
     4.781    72.887     0.200
     5.880    88.785     0.200
     6.131    92.188     0.200
     6.344    94.586     0.200
     6.392    94.887     0.200
     6.639    99.086     0.200
     6.999   102.887     0.200
     7.200   108.188     0.200
     7.455   110.484     0.200
     7.983   116.086     0.200
     8.076   118.688     0.200
     8.342   119.688     0.200
     8.719   125.086     0.200
     9.328   134.086     0.200
     1.645    29.047     0.200
     1.749    30.914     0.200
     1.960    31.938     0.200
     2.035    34.609     0.200
     2.100    35.977     0.200
     2.330    39.648     0.200
     2.510    41.289     0.200
     2.870    44.844     0.200
     4.354    65.695     0.200
     4.391    66.484     0.200
     4.426    67.484     0.200
     4.479    67.141     0.200
     4.820    71.789     0.200
     4.926    72.984     0.200
     5.864    86.891     0.200
     6.170    91.086     0.200
     6.324    93.188     0.200
     6.370    93.289     0.200
     6.628    97.391     0.200
     6.994   101.586     0.200
     7.015   101.688     0.200
     7.181   106.586     0.200
     7.983   113.586     0.200
     8.350   118.391     0.200
     8.726   123.086     0.200
     9.322   132.484     0.200
     1.464    25.984     0.200
     1.584    27.586     0.200
     1.677    29.523     0.200
     1.733    31.258     0.200
     1.976    33.320     0.200
     2.063    36.016     0.200
     2.073    35.617     0.200
     2.359    40.391     0.200
     2.482    40.984     0.200
     2.838    46.000     0.200
     2.847    46.711     0.200
     3.094    50.984     0.200
     3.143    51.664     0.200
     3.144    52.375     0.200
     4.238    65.406     0.200
     4.323    66.156     0.200
     4.448    68.289     0.200
     4.415    67.414     0.200
     4.788    72.414     0.200
     4.896    73.070     0.200
     5.090    75.484     0.200
     5.458    82.016     0.200
     5.828    86.719     0.200
     5.847    87.719     0.200
     5.894    88.820     0.200
     5.928    86.414     0.200
     6.138    91.516     0.200
     6.180    94.219     0.200
     6.310    94.016     0.200
     6.356    93.719     0.200
     6.487    94.719     0.200
     6.609    99.016     0.200
     6.609    98.117     0.200
     6.898   101.617     0.200
     6.950   101.914     0.200
     6.975   103.117     0.200
     6.972   101.516     0.200
     6.993   101.719     0.200
     7.267   107.617     0.200
     7.959   115.320     0.200
     8.323   117.516     0.200
     8.699   123.820     0.200
     9.598   136.617     0.200
     1.657    28.711     0.200
     1.983    31.922     0.200
     2.053    34.484     0.200
     2.493    40.383     0.200
     2.345    38.633     0.200
     2.866    44.562     0.200
     2.845    45.109     0.200
     3.019    48.445     0.200
     3.054    48.125     0.200
     3.146    50.672     0.200
     3.144    50.266     0.200
     3.125    48.750     0.200
     3.299    52.820     0.200
     3.302    52.164     0.200
     3.327    51.273     0.200
     3.392    53.305     0.200
     3.760    59.477     0.200
     3.863    61.406     0.200
     3.751    58.727     0.200
     3.745    57.945     0.200
     3.753    57.766     0.200
     3.827    62.180     0.200
     3.940    60.984     0.200
     3.934    60.922     0.200
     3.952    61.625     0.200
     3.952    61.625     0.200
     4.050    61.062     0.200
     4.019    62.445     0.200
     4.081    60.703     0.200
     4.074    63.602     0.200
     4.155    62.289     0.200
     4.201    64.625     0.200
     4.215    66.273     0.200
     4.267    63.977     0.200
     4.292    64.281     0.200
     4.326    66.594     0.200
     4.350    65.336     0.200
     4.353    64.961     0.200
     4.384    64.883     0.200
     4.292    67.625     0.200
     4.403    67.086     0.200
     4.455    68.906     0.200
     4.477    66.555     0.200
     4.521    69.391     0.200
     4.544    69.180     0.200
     4.681    69.852     0.200
     4.815    71.383     0.200
     4.822    71.055     0.200
     4.912    72.180     0.200
     4.992    73.820     0.200
     4.963    75.180     0.200
     5.111    74.516     0.200
     5.320    79.383     0.200
     5.482    80.383     0.200
     5.576    81.180     0.200
     5.746    84.227     0.200
     5.840    85.781     0.200
     5.841    86.984     0.200
     5.907    87.883     0.200
     5.935    85.586     0.200
     5.841    86.586     0.200
     6.010    89.383     0.200
     6.039    87.930     0.200
     6.092    89.781     0.200
     6.093    90.086     0.200
     6.145    89.883     0.200
     6.164    90.484     0.200
     6.192    92.086     0.200
     6.236    91.680     0.200
     6.190    91.383     0.200
     6.301    92.484     0.200
     6.346    93.281     0.200
     6.309    93.383     0.200
     6.495    93.883     0.200
     6.619    97.281     0.200
     6.606    97.086     0.200
     6.730   100.484     0.200
     6.684    97.883     0.200
     6.879   100.883     0.200
     6.907   100.586     0.200
     6.958   101.281     0.200
     6.972   100.586     0.200
     6.980   102.484     0.200
     6.993   101.086     0.200
     7.050   103.086     0.200
     7.012   103.383     0.200
     7.142   103.680     0.200
     7.162   103.883     0.200
     7.158   105.484     0.200
     7.177   104.781     0.200
     7.191   103.180     0.200
     7.192   105.586     0.200
     7.195   104.516     0.200
     7.263   107.680     0.200
     7.319   106.086     0.200
     7.485   107.086     0.200
     7.715   113.242     0.200
     7.963   113.883     0.200
     8.026   114.281     0.200
     8.040   115.781     0.200
     8.062   116.281     0.200
     8.295   118.086     0.200
     8.304   121.664     0.200
     8.331   117.586     0.200
     8.385   120.883     0.200
     8.476   120.281     0.200
     8.694   124.484     0.200
     8.708   123.086     0.200
     8.927   130.766     0.200
     9.036   127.883     0.200
     9.198   130.281     0.200
     9.206   134.086     0.200
     9.218   130.484     0.200
     9.301   131.586     0.200
     9.442   135.484     0.200
     9.600   135.680     0.200
     9.666   136.984     0.200
     9.683   136.883     0.200
     9.694   137.984     0.200
     9.874   140.180     0.200
    10.307   146.180     0.200
    10.791   153.484     0.200
    11.447   163.086     0.200
    13.916   194.383     0.200
    18.474   256.109     0.200
    19.494   266.383     0.200
    19.494   266.133     0.200
     1.421    24.913     0.200
     1.605    27.963     0.200
     1.634    28.684     0.200
     1.648    29.333     0.200
     1.766    31.014     0.200
     1.943    31.623     0.200
     2.020    34.653     0.200
     2.115    35.463     0.200
     2.138    37.073     0.200
     2.525    41.383     0.200
     2.887    47.063     0.200
     3.099    49.573     0.200
     3.136    50.293     0.200
     3.497    56.573     0.200
     3.788    62.233     0.200
     4.064    63.133     0.200
     4.359    66.073     0.200
     4.443    67.934     0.200
     4.828    72.233     0.200
     4.939    73.383     0.200
     5.025    74.503     0.200
     5.881    85.833     0.200
     6.034    90.733     0.200
     6.119    90.333     0.200
     6.178    90.833     0.200
     6.341    92.233     0.200
     6.387    94.133     0.200
     6.645    95.633     0.200
     7.011   100.733     0.200
     7.032   101.333     0.200
     7.198   104.434     0.200
     7.303   105.833     0.200
     7.500   109.033     0.200
     7.999   113.934     0.200
     8.365   119.033     0.200
     8.741   123.833     0.200
     9.339   131.934     0.200
     9.638   135.633     0.200
     9.704   136.833     0.200
     1.652    29.318     0.200
     1.663    30.188     0.200
     1.848    33.089     0.200
     2.043    36.099     0.200
     2.342    40.469     0.200
     2.797    46.519     0.200
     2.818    46.398     0.200
     2.970    49.459     0.200
     3.007    49.278     0.200
     3.127    50.269     0.200
     3.151    51.398     0.200
     3.253    53.229     0.200
     3.281    52.979     0.200
     3.344    54.288     0.200
     3.519    56.148     0.200
     3.711    60.259     0.200
     3.755    59.658     0.200
     3.780    60.509     0.200
     3.766    59.738     0.200
     3.771    60.219     0.200
     3.783    61.019     0.200
     3.886    62.129     0.200
     3.903    62.278     0.200
     3.903    62.278     0.200
     4.032    63.068     0.200
     4.069    62.759     0.200
     4.129    63.639     0.200
     4.242    65.688     0.200
     4.263    65.019     0.200
     4.331    67.238     0.200
     4.326    67.368     0.200
     4.369    67.019     0.200
     4.326    69.618     0.200
     4.441    68.419     0.200
     4.452    68.288     0.200
     4.503    71.019     0.200
     4.795    73.318     0.200
     4.811    72.719     0.200
     4.913    74.078     0.200
     5.002    76.479     0.200
     4.917    76.919     0.200
     5.103    76.629     0.200
     5.272    81.118     0.200
     5.552    83.219     0.200
     5.752    87.929     0.200
     5.832    89.618     0.200
     5.872    90.219     0.200
     5.797    87.719     0.200
     6.091    92.219     0.200
     6.146    92.419     0.200
     6.234    95.019     0.200
     6.335    93.818     0.200
     6.382    94.719     0.200
     6.633    97.919     0.200
     6.996   103.219     0.200
     7.017   103.118     0.200
     7.174   105.219     0.200
     7.191   108.419     0.200
     7.155   106.118     0.200
     7.291   107.019     0.200
     7.468   108.318     0.200
     7.687   114.019     0.200
     7.982   116.719     0.200
     8.070   118.318     0.200
     8.275   120.318     0.200
     8.344   120.618     0.200
     8.419   122.818     0.200
     8.681   127.818     0.200
     8.720   125.519     0.200
     9.180   134.219     0.200
     9.324   134.419     0.200
     9.621   138.118     0.200
     9.689   139.318     0.200
     9.678   139.818     0.200
     9.697   138.919     0.200
     9.900   141.719     0.200
    10.830   155.519     0.200
    19.477   269.019     0.200
    19.477   268.618     0.200
    20.887   284.669     0.200
     1.575    28.150     0.200
     1.588    28.141     0.200
     1.618    28.541     0.200
     1.656    29.240     0.200
     1.734    30.961     0.200
     1.975    33.602     0.200
     2.049    36.002     0.200
     2.496    41.691     0.200
     2.836    46.621     0.200
     2.856    47.852     0.200
     2.840    47.592     0.200
     2.863    45.762     0.200
     3.009    49.561     0.200
     3.044    49.811     0.200
     3.105    52.070     0.200
     3.124    52.531     0.200
     3.192    52.611     0.200
     3.292    54.041     0.200
     3.317    53.461     0.200
     3.382    54.121     0.200
     3.745    58.521     0.200
     3.755    59.711     0.200
     3.754    58.932     0.200
     3.750    60.861     0.200
     3.817    61.740     0.200
     3.925    62.391     0.200
     3.942    62.990     0.200
     3.942    62.990     0.200
     4.010    63.740     0.200
     4.048    62.451     0.200
     4.151    63.740     0.200
     4.263    64.990     0.200
     4.288    68.141     0.200
     4.298    68.842     0.200
     4.348    66.682     0.200
     4.349    66.141     0.200
     4.382    66.941     0.200
     4.411    67.541     0.200
     4.473    68.111     0.200
     4.535    70.541     0.200
     4.822    73.092     0.200
     4.914    74.021     0.200
     4.954    75.541     0.200
     4.996    76.061     0.200
     5.111    76.461     0.200
     5.573    82.842     0.200
     5.848    87.740     0.200
     6.162    91.842     0.200
     6.309    93.541     0.200
     6.354    93.842     0.200
     6.612    98.041     0.200
     6.695   100.740     0.200
     6.978   101.941     0.200
     6.999   102.141     0.200
     7.166   104.941     0.200
     7.270   108.041     0.200
     7.483   108.541     0.200
     7.968   115.441     0.200
     8.047   117.740     0.200
     8.336   118.641     0.200
     8.392   122.041     0.200
     8.712   123.941     0.200
     9.450   135.842     0.200
     9.606   138.342     0.200
     1.638    28.824     0.200
     1.754    31.316     0.200
     1.955    32.137     0.200
     2.028    34.637     0.200
     2.323    39.375     0.200
     2.517    41.336     0.200
     2.876    45.297     0.200
     4.063    64.664     0.200
     4.430    67.617     0.200
     5.869    88.414     0.200
     6.374    94.117     0.200
     6.633    96.914     0.200
     7.000   101.617     0.200
     7.021   101.816     0.200
     7.989   115.215     0.200
     8.357   118.215     0.200
     8.733   122.715     0.200
     1.455    26.223     0.200
     1.574    28.012     0.200
     1.666    29.121     0.200
     1.729    30.922     0.200
     1.980    32.812     0.200
     2.057    36.000     0.200
     2.352    40.562     0.200
     2.488    40.660     0.200
     2.853    45.781     0.200
     3.144    50.812     0.200
     4.038    61.941     0.200
     4.254    65.020     0.200
     4.408    67.582     0.200
     4.464    69.621     0.200
     4.803    72.883     0.200
     4.904    73.461     0.200
     5.843    87.781     0.200
     5.901    88.480     0.200
     6.140    91.281     0.200
     6.152    91.383     0.200
     6.186    92.383     0.200
     6.351    93.680     0.200
     6.607    98.781     0.200
     6.614    98.480     0.200
     6.874   101.781     0.200
     6.902   102.480     0.200
     6.972   101.281     0.200
     6.977   103.582     0.200
     6.993   102.082     0.200
     7.161   106.883     0.200
     7.473   108.980     0.200
     7.961   114.781     0.200
     8.042   118.281     0.200
     8.327   118.781     0.200
     8.704   124.383     0.200
     9.599   137.082     0.200
     1.632    29.305     0.200
     1.645    29.297     0.200
     1.675    30.102     0.200
     1.630    29.242     0.200
     1.789    31.711     0.200
     1.814    32.086     0.200
     2.008    35.461     0.200
     2.537    42.055     0.200
     2.872    46.039     0.200
     2.784    46.602     0.200
     2.786    45.500     0.200
     2.991    48.766     0.200
     3.094    49.891     0.200
     3.242    52.711     0.200
     3.262    52.430     0.200
     3.330    53.695     0.200
     3.704    60.195     0.200
     3.722    58.945     0.200
     3.735    58.570     0.200
     3.872    61.609     0.200
     3.892    62.055     0.200
     3.892    62.055     0.200
     4.061    62.539     0.200
     4.100    63.031     0.200
     4.154    64.672     0.200
     4.268    66.031     0.200
     4.286    65.695     0.200
     4.351    67.156     0.200
     4.400    67.000     0.200
     4.400    69.398     0.200
     4.477    68.711     0.200
     4.468    69.297     0.200
     4.824    73.297     0.200
     4.843    73.492     0.200
     4.947    74.000     0.200
     4.898    75.602     0.200
     5.037    75.938     0.200
     5.135    77.039     0.200
     5.883    88.297     0.200
     5.775    86.398     0.200
     5.903    89.500     0.200
     5.948    89.695     0.200
     5.985    87.695     0.200
     6.090    89.859     0.200
     6.175    91.797     0.200
     6.190    92.398     0.200
     6.234    93.602     0.200
     6.125    92.398     0.200
     6.365    94.500     0.200
     6.245    94.398     0.200
     6.411    95.000     0.200
     6.543    96.000     0.200
     6.666    99.195     0.200
     6.618    98.898     0.200
     7.007   103.195     0.200
     7.030   101.000     0.200
     6.948   103.898     0.200
     7.195   106.102     0.200
     7.169   106.867     0.200
     7.222   108.602     0.200
     7.324   108.000     0.200
     7.352   109.398     0.200
     7.498   109.398     0.200
     8.017   115.898     0.200
     8.141   115.781     0.200
     8.296   124.695     0.200
     8.379   120.000     0.200
     8.310   122.398     0.200
     8.756   125.000     0.200
     8.872   132.195     0.200
     9.358   134.000     0.200
     9.656   138.195     0.200
     9.637   142.125     0.200
     9.732   139.297     0.200
     9.946   142.891     0.200
    11.864   169.195     0.200
     1.642    28.992     0.200
     1.655    29.117     0.200
     1.685    29.516     0.200
     1.630    28.914     0.200
     1.797    31.875     0.200
     1.912    32.336     0.200
     2.004    34.609     0.200
     2.541    41.789     0.200
     2.868    45.836     0.200
     2.778    45.414     0.200
     2.909    47.672     0.200
     2.980    48.578     0.200
     3.156    51.625     0.200
     3.093    49.328     0.200
     3.208    52.289     0.200
     3.232    52.648     0.200
     3.254    53.336     0.200
     3.251    51.953     0.200
     3.319    53.312     0.200
     3.489    53.875     0.200
     3.694    59.492     0.200
     3.818    59.062     0.200
     3.723    58.375     0.200
     3.737    58.453     0.200
     3.762    59.797     0.200
     3.861    61.094     0.200
     3.881    61.492     0.200
     3.881    61.492     0.200
     4.059    62.062     0.200
     4.150    63.492     0.200
     4.143    65.117     0.200
     4.281    67.516     0.200
     4.347    66.766     0.200
     4.398    66.719     0.200
     4.473    67.844     0.200
     4.477    68.719     0.200
     4.438    68.336     0.200
     4.821    72.719     0.200
     4.842    72.883     0.200
     4.949    73.406     0.200
     5.041    75.305     0.200
     5.135    76.469     0.200
     5.789    87.688     0.200
     5.911    89.016     0.200
     6.172    91.414     0.200
     6.374    94.617     0.200
     6.420    95.016     0.200
     6.673    99.312     0.200
     7.331   108.516     0.200
     7.496   108.617     0.200
     8.022   114.812     0.200
     8.383   120.016     0.200
     8.760   124.719     0.200
    20.902   283.766     0.200
     1.590    28.740     0.200
     1.619    29.040     0.200
     1.663    29.840     0.200
     1.868    32.850     0.200
     1.977    33.639     0.200
     2.855    46.479     0.200
     2.832    46.959     0.200
     2.842    46.340     0.200
     3.041    50.340     0.200
     3.130    50.110     0.200
     3.140    51.209     0.200
     3.288    54.119     0.200
     3.315    53.520     0.200
     3.379    54.719     0.200
     3.514    56.000     0.200
     3.745    61.479     0.200
     3.715    58.830     0.200
     3.752    59.449     0.200
     3.763    60.409     0.200
     3.761    59.580     0.200
     3.803    60.340     0.200
     3.816    60.540     0.200
     3.896    62.250     0.200
     3.927    63.040     0.200
     3.921    62.979     0.200
     3.938    63.669     0.200
     3.938    63.669     0.200
     4.004    63.369     0.200
     4.073    62.760     0.200
     4.076    65.159     0.200
     4.048    61.429     0.200
     4.208    66.939     0.200
     4.329    68.280     0.200
     4.341    67.340     0.200
     4.275    66.740     0.200
     4.375    67.139     0.200
     4.411    68.540     0.200
     4.457    70.310     0.200
     4.524    70.869     0.200
     4.456    70.050     0.200
     4.534    70.740     0.200
     4.695    70.449     0.200
     4.805    73.040     0.200
     4.815    73.100     0.200
     4.723    73.709     0.200
     4.908    74.040     0.200
     4.991    75.570     0.200
     4.951    76.639     0.200
     5.065    78.369     0.200
     5.104    76.790     0.200
     5.027    77.679     0.200
     5.020    77.740     0.200
     5.307    81.119     0.200
     5.396    82.310     0.200
     5.459    83.790     0.200
     5.375    82.280     0.200
     5.440    83.740     0.200
     5.552    85.699     0.200
     5.565    83.340     0.200
     5.658    86.740     0.200
     5.705    87.850     0.200
     5.706    87.979     0.200
     5.743    86.750     0.200
     5.663    85.740     0.200
     5.777    86.840     0.200
     5.838    87.840     0.200
     5.846    88.240     0.200
     5.904    89.139     0.200
     5.830    87.740     0.200
     5.935    87.340     0.200
     5.985    91.909     0.200
     6.040    89.209     0.200
     6.055    92.649     0.200
     6.055    92.110     0.200
     6.086    91.740     0.200
     6.088    91.939     0.200
     6.028    90.800     0.200
     6.024    92.240     0.200
     6.144    92.139     0.200
     6.155    92.540     0.200
     6.095    91.560     0.200
     6.189    93.939     0.200
     6.209    94.479     0.200
     6.231    94.139     0.200
     6.178    93.740     0.200
     6.295    95.240     0.200
     6.239    93.000     0.200
     6.308    94.139     0.200
     6.320    92.619     0.200
     6.323    92.840     0.200
     6.344    95.240     0.200
     6.354    94.639     0.200
     6.296    95.240     0.200
     6.390    93.560     0.200
     6.330    96.280     0.200
     6.494    95.840     0.200
     6.485   101.139     0.200
     6.516    95.040     0.200
     6.490    97.080     0.200
     6.602    98.840     0.200
     6.611    99.540     0.200
     6.617    99.040     0.200
     6.610    99.340     0.200
     6.680   100.219     0.200
     6.724    98.010     0.200
     6.655    99.240     0.200
     6.673   100.240     0.200
     6.758   102.040     0.200
     6.877   102.139     0.200
     6.791   100.879     0.200
     6.889   104.139     0.200
     6.906   101.639     0.200
     6.911   102.040     0.200
     6.837   102.240     0.200
     6.958   102.240     0.200
     6.975   102.439     0.200
     6.981   102.540     0.200
     6.996   102.639     0.200
     6.951   102.679     0.200
     7.049   103.939     0.200
     6.999   105.240     0.200
     7.098   105.040     0.200
     7.062   104.520     0.200
     7.143   105.439     0.200
     7.162   105.540     0.200
     7.164   107.439     0.200
     7.194   106.939     0.200
     7.180   106.119     0.200
     7.117   106.740     0.200
     7.233   109.040     0.200
     7.268   108.939     0.200
     7.321   108.040     0.200
     7.475   109.240     0.200
     7.406   110.740     0.200
     7.487   111.740     0.200
     7.533   110.540     0.200
     7.587   110.340     0.200
     7.695   113.939     0.200
     7.703   114.679     0.200
     7.767   113.240     0.200
     7.793   115.240     0.200
     7.964   116.240     0.200
     7.932   116.240     0.200
     8.025   116.040     0.200
     8.045   118.139     0.200
     8.060   117.439     0.200
     7.980   116.679     0.200
     8.029   120.240     0.200
     8.222   118.439     0.200
     8.285   120.340     0.200
     8.291   123.209     0.200
     8.331   119.740     0.200
     8.372   122.040     0.200
     8.372   122.040     0.200
     8.391   123.240     0.200
     8.456   126.439     0.200
     8.474   121.939     0.200
     8.397   124.240     0.200
     8.535   122.740     0.200
     8.686   125.939     0.200
     8.695   127.139     0.200
     8.707   125.340     0.200
     8.707   130.540     0.200
     8.718   126.639     0.200
     8.789   128.240     0.200
     8.912   133.199     0.200
     9.035   129.439     0.200
     9.189   132.040     0.200
     9.194   133.540     0.200
     9.194   137.740     0.200
     9.189   136.040     0.200
     9.211   132.340     0.200
     9.260   135.399     0.200
     9.304   133.639     0.200
     9.319   136.290     0.200
     9.450   137.540     0.200
     9.599   138.740     0.200
     9.602   137.540     0.200
     9.669   138.939     0.200
     9.652   144.439     0.200
     9.683   139.139     0.200
     9.685   139.740     0.200
     9.666   140.740     0.200
     9.839   143.439     0.200
     9.878   142.340     0.200
     9.999   143.240     0.200
    10.173   147.439     0.200
    10.800   156.240     0.200
    11.147   158.840     0.200
    11.326   163.740     0.200
    12.172   171.949     0.200
    12.875   183.340     0.200
    13.517   194.010     0.200
    14.398   206.000     0.200
    14.398   203.177     0.200
    15.994   226.800     0.200
    16.918   238.129     0.200
    18.464   256.221     0.200
    18.480   260.330     0.200
    19.315   266.330     0.200
    19.595   269.439     0.200
    20.232   280.439     0.200
     1.604    28.160     0.200
     1.633    28.560     0.200
     1.652    29.420     0.200
     1.854    32.370     0.200
     1.962    33.060     0.200
     2.040    35.590     0.200
     2.336    40.180     0.200
     2.862    46.640     0.200
     2.821    46.550     0.200
     2.827    45.779     0.200
     3.029    49.189     0.200
     3.162    51.370     0.200
     3.119    50.000     0.200
     3.277    53.300     0.200
     3.302    52.550     0.200
     3.367    54.010     0.200
     3.505    55.279     0.200
     3.736    60.819     0.200
     3.743    58.649     0.200
     3.759    59.720     0.200
     3.752    58.970     0.200
     3.802    62.260     0.200
     3.806    60.080     0.200
     3.910    62.109     0.200
     3.928    62.649     0.200
     3.928    62.649     0.200
     3.997    63.189     0.200
     4.194    66.359     0.200
     4.284    65.760     0.200
     4.348    66.859     0.200
     4.260    66.260     0.200
     4.384    66.460     0.200
     4.426    68.160     0.200
     4.448    69.750     0.200
     4.520    71.060     0.200
     4.812    72.260     0.200
     4.824    72.399     0.200
     4.920    73.740     0.200
     4.938    78.060     0.200
     5.004    75.500     0.200
     5.005    76.760     0.200
     5.114    76.189     0.200
     5.295    80.910     0.200
     5.571    82.660     0.200
     5.648    85.260     0.200
     5.756    86.410     0.200
     5.789    86.260     0.200
     5.851    87.560     0.200
     5.862    87.960     0.200
     5.816    87.260     0.200
     5.917    89.660     0.200
     5.949    87.160     0.200
     6.054    89.660     0.200
     6.097    92.160     0.200
     6.099    91.560     0.200
     6.157    91.960     0.200
     6.162    91.460     0.200
     6.202    93.859     0.200
     6.242    93.859     0.200
     6.283    93.960     0.200
     6.323    93.359     0.200
     6.335    93.470     0.200
     6.369    93.760     0.200
     6.508    95.859     0.200
     6.625    98.859     0.200
     6.690   100.060     0.200
     6.891   101.960     0.200
     6.919   102.760     0.200
     6.972   102.460     0.200
     6.990   101.760     0.200
     6.995   104.060     0.200
     7.011   102.660     0.200
     7.179   107.260     0.200
     7.283   108.859     0.200
     7.484   108.359     0.200
     7.979   114.760     0.200
     8.072   118.760     0.200
     8.292   119.359     0.200
     8.344   119.260     0.200
     8.406   123.359     0.200
     8.721   124.859     0.200
     9.196   132.260     0.200
     9.220   131.760     0.200
     9.319   133.359     0.200
     9.617   137.460     0.200
     9.684   137.960     0.200
     9.693   139.260     0.200
    10.839   154.260     0.200
     1.653    29.051     0.200
     1.760    31.262     0.200
     1.949    32.113     0.200
     2.035    35.133     0.200
     2.125    34.840     0.200
     2.510    41.711     0.200
     2.803    46.371     0.200
     2.856    45.461     0.200
     2.875    47.031     0.200
     2.977    48.652     0.200
     3.012    49.582     0.200
     3.122    51.773     0.200
     3.260    52.340     0.200
     3.350    53.922     0.200
     3.719    58.773     0.200
     3.786    62.102     0.200
     3.892    62.051     0.200
     3.910    61.922     0.200
     3.910    61.922     0.200
     4.275    65.203     0.200
     4.314    68.973     0.200
     4.380    66.000     0.200
     4.440    68.000     0.200
     4.807    72.301     0.200
     5.113    76.340     0.200
     5.874    88.203     0.200
     6.100    92.102     0.200
     6.157    91.301     0.200
     6.336    94.102     0.200
     6.383    94.203     0.200
     6.636    98.703     0.200
     7.000   101.301     0.200
     7.193   107.301     0.200
     7.987   115.102     0.200
     8.351   118.902     0.200
     8.727   124.203     0.200
     9.328   132.602     0.200
     9.479   136.801     0.200
     1.704    29.734     0.200
     1.639    29.273     0.200
     1.996    35.070     0.200
     2.304    39.969     0.200
     2.719    44.883     0.200
     2.747    45.211     0.200
     2.896    47.648     0.200
     2.927    47.930     0.200
     3.177    51.414     0.200
     3.200    51.758     0.200
     3.266    52.648     0.200
     3.639    58.414     0.200
     3.690    59.234     0.200
     3.808    60.602     0.200
     3.827    60.930     0.200
     3.827    60.930     0.200
     3.886    62.234     0.200
     4.093    64.828     0.200
     4.249    66.430     0.200
     4.336    68.031     0.200
     4.382    66.734     0.200
     4.520    69.234     0.200
     4.799    73.234     0.200
     5.545    82.633     0.200
     5.894    88.328     0.200
     5.946    89.133     0.200
     6.005    87.828     0.200
     6.118    92.633     0.200
     6.124    92.133     0.200
     6.151    91.828     0.200
     6.204    92.430     0.200
     6.243    94.430     0.200
     6.268    94.430     0.200
     6.411    95.133     0.200
     6.459    95.234     0.200
     6.561    96.133     0.200
     6.651   100.328     0.200
     6.666   100.234     0.200
     6.678    99.633     0.200
     6.651    97.133     0.200
     6.703    99.930     0.200
     6.970   103.133     0.200
     7.025   103.734     0.200
     7.062   102.734     0.200
     7.083   103.234     0.200
     7.114   104.828     0.200
     7.219   106.734     0.200
     7.266   106.633     0.200
     7.362   107.234     0.200
     7.478   108.133     0.200
     7.656   111.328     0.200
     8.043   115.930     0.200
     8.142   117.633     0.200
     8.277   119.328     0.200
     8.396   120.328     0.200
     8.495   122.430     0.200
     8.773   125.430     0.200
     9.226   133.133     0.200
     9.390   133.930     0.200
     9.684   139.133     0.200
     9.688   139.133     0.200
     9.751   139.531     0.200
     9.755   139.234     0.200
     9.967   142.031     0.200
    10.265   147.734     0.200
    10.411   148.430     0.200
    11.209   158.234     0.200
    12.957   182.734     0.200
     1.590    28.539     0.200
     1.632    28.469     0.200
     1.723    30.098     0.200
     1.755    30.559     0.200
     1.954    31.699     0.200
     2.024    34.398     0.200
     2.110    35.367     0.200
     2.521    40.828     0.200
     2.828    45.789     0.200
     2.881    46.699     0.200
     2.883    45.086     0.200
     3.005    48.977     0.200
     3.035    48.906     0.200
     3.130    50.770     0.200
     3.174    50.609     0.200
     3.175    51.078     0.200
     3.286    52.859     0.200
     3.305    52.738     0.200
     3.374    53.656     0.200
     3.747    59.418     0.200
     3.916    61.270     0.200
     3.936    61.777     0.200
     3.936    61.777     0.200
     4.251    65.406     0.200
     4.369    68.207     0.200
     4.405    68.406     0.200
     4.430    67.508     0.200
     4.938    72.469     0.200
     4.998    75.508     0.200
     5.636    84.008     0.200
     6.000    90.008     0.200
     6.035    91.609     0.200
     6.117    91.609     0.200
     6.183    91.707     0.200
     6.262    91.809     0.200
     6.329    92.109     0.200
     6.374    92.508     0.200
     6.632    99.809     0.200
     7.002   100.508     0.200
     7.023   100.809     0.200
     7.992   113.707     0.200
     8.360   118.309     0.200
     8.413   120.609     0.200
     8.736   123.406     0.200
     9.330   131.809     0.200
     9.630   136.109     0.200
     1.608    28.438     0.200
     1.648    29.695     0.200
     1.763    31.719     0.200
     1.946    33.059     0.200
     2.329    40.098     0.200
     2.514    41.887     0.200
     2.803    47.277     0.200
     2.812    46.367     0.200
     2.879    47.906     0.200
     2.860    46.238     0.200
     2.978    50.285     0.200
     3.011    49.586     0.200
     3.113    50.988     0.200
     3.176    52.008     0.200
     3.260    53.977     0.200
     3.284    53.398     0.200
     3.350    54.426     0.200
     3.719    60.867     0.200
     3.740    58.848     0.200
     3.892    62.168     0.200
     3.910    62.816     0.200
     3.910    62.816     0.200
     4.279    68.398     0.200
     4.385    66.996     0.200
     4.443    68.898     0.200
     4.811    73.398     0.200
     4.926    73.977     0.200
     5.014    75.559     0.200
     5.877    87.598     0.200
     6.020    92.797     0.200
     6.102    93.398     0.200
     6.105    92.398     0.200
     6.161    91.898     0.200
     6.339    93.695     0.200
     6.385    94.496     0.200
     6.640    98.496     0.200
     7.004   101.797     0.200
     7.025   102.695     0.200
     7.298   106.398     0.200
     7.484   109.797     0.200
     8.075   117.398     0.200
     8.355   120.898     0.200
     8.731   125.098     0.200
    20.903   285.926     0.200
     1.630    28.625     0.200
     1.610    27.664     0.200
     1.735    30.297     0.200
     1.771    30.422     0.200
     1.938    31.828     0.200
     2.120    34.836     0.200
     2.142    36.836     0.200
     2.312    38.758     0.200
     2.530    40.719     0.200
     2.802    44.406     0.200
     2.808    45.398     0.200
     2.879    45.703     0.200
     2.892    46.938     0.200
     2.985    48.555     0.200
     3.015    48.172     0.200
     3.140    50.875     0.200
     3.188    50.742     0.200
     3.266    52.227     0.200
     3.285    51.734     0.200
     3.354    53.086     0.200
     3.721    58.867     0.200
     3.728    58.805     0.200
     3.896    60.727     0.200
     3.916    61.008     0.200
     3.916    61.008     0.200
     4.404    68.023     0.200
     4.448    67.523     0.200
     4.944    72.281     0.200
     5.136    76.703     0.200
     5.797    86.328     0.200
     5.886    87.227     0.200
     6.181    91.727     0.200
     6.346    93.422     0.200
     6.392    93.828     0.200
     6.639   100.422     0.200
     6.650    97.227     0.200
     7.016   101.625     0.200
     7.036   101.727     0.200
     7.203   104.523     0.200
     7.503   110.227     0.200
     8.004   114.727     0.200
     8.370   118.422     0.200
     8.746   123.422     0.200
     9.344   132.727     0.200
     9.643   136.227     0.200
     1.608    28.336     0.200
     1.787    30.977     0.200
     1.835    31.828     0.200
     1.875    31.344     0.200
     1.974    33.016     0.200
     2.167    36.555     0.200
     2.572    41.883     0.200
     2.743    44.398     0.200
     2.881    45.312     0.200
     2.924    47.273     0.200
     2.948    47.359     0.200
     3.203    50.625     0.200
     3.217    51.023     0.200
     3.287    51.703     0.200
     3.668    57.555     0.200
     3.830    59.828     0.200
     3.851    59.695     0.200
     3.851    59.695     0.200
     4.416    66.258     0.200
     4.515    68.453     0.200
     6.710    97.758     0.200
     7.072   102.656     0.200
     8.057   115.453     0.200
     8.792   124.359     0.200
     1.573    27.578     0.200
     1.586    28.016     0.200
     1.617    28.516     0.200
     1.709    29.387     0.200
     1.640    29.156     0.200
     1.857    32.129     0.200
     1.970    32.809     0.200
     2.510    41.176     0.200
     2.867    46.605     0.200
     2.881    45.578     0.200
     2.843    45.629     0.200
     2.834    45.488     0.200
     3.019    49.129     0.200
     3.051    48.676     0.200
     3.159    50.246     0.200
     3.108    49.867     0.200
     3.301    52.836     0.200
     3.322    52.156     0.200
     3.389    53.656     0.200
     3.490    55.219     0.200
     3.761    59.457     0.200
     3.737    59.438     0.200
     3.784    59.996     0.200
     3.909    61.496     0.200
     3.932    61.355     0.200
     3.951    62.008     0.200
     3.951    62.008     0.200
     4.066    62.578     0.200
     4.022    63.559     0.200
     4.090    65.016     0.200
     4.098    61.887     0.200
     4.169    64.559     0.200
     4.231    67.129     0.200
     4.154    65.195     0.200
     4.282    65.168     0.200
     4.213    65.516     0.200
     4.306    65.719     0.200
     4.341    67.457     0.200
     4.267    66.016     0.200
     4.366    66.578     0.200
     4.368    66.195     0.200
     4.400    65.918     0.200
     4.400    68.617     0.200
     4.413    67.617     0.200
     4.471    69.797     0.200
     4.492    67.867     0.200
     4.536    69.469     0.200
     4.536    70.016     0.200
     4.630    72.016     0.200
     4.680    68.688     0.200
     4.831    72.918     0.200
     4.839    72.207     0.200
     5.009    74.695     0.200
     4.958    75.816     0.200
     5.076    77.906     0.200
     5.015    76.617     0.200
     5.128    75.695     0.200
     5.180    77.816     0.200
     5.318    80.297     0.200
     5.407    82.648     0.200
     5.468    84.148     0.200
     5.468    82.879     0.200
     5.498    82.918     0.200
     5.439    82.617     0.200
     5.559    83.418     0.200
     5.591    82.418     0.200
     5.665    84.777     0.200
     5.714    87.289     0.200
     5.714    86.227     0.200
     5.651    84.617     0.200
     5.763    85.727     0.200
     5.800    85.918     0.200
     5.814    87.816     0.200
     5.853    87.418     0.200
     5.904    89.316     0.200
     5.834    86.918     0.200
     5.935    89.719     0.200
     5.993    90.398     0.200
     6.031    90.418     0.200
     6.055    88.039     0.200
     6.063    90.719     0.200
     6.063    91.355     0.200
     6.110    90.918     0.200
     6.109    91.418     0.200
     6.016    91.117     0.200
     6.180    92.016     0.200
     6.195    92.316     0.200
     6.218    93.816     0.200
     6.253    93.516     0.200
     6.184    92.617     0.200
     6.304    93.988     0.200
     6.312    93.316     0.200
     6.337    91.648     0.200
     6.354    93.586     0.200
     6.309    93.719     0.200
     6.358    93.719     0.200
     6.306    94.117     0.200
     6.622    98.219     0.200
     6.619    97.918     0.200
     6.690   100.695     0.200
     6.713   101.719     0.200
     6.736    97.648     0.200
     6.655    97.617     0.200
     6.741   100.117     0.200
     6.678    98.617     0.200
     6.833   100.617     0.200
     6.915   103.516     0.200
     6.939   102.516     0.200
     6.944   103.316     0.200
     6.987   101.516     0.200
     7.008   101.516     0.200
     7.040   104.219     0.200
     7.008   104.117     0.200
     7.170   106.117     0.200
     7.205   109.367     0.200
     7.205   106.117     0.200
     7.243   108.016     0.200
     7.277   107.816     0.200
     7.411   109.219     0.200
     7.390   109.617     0.200
     7.412   109.117     0.200
     7.497   110.617     0.200
     7.501   108.219     0.200
     7.729   115.078     0.200
     7.786   113.918     0.200
     7.978   114.816     0.200
     7.938   115.617     0.200
     8.053   117.316     0.200
     8.009   117.617     0.200
     8.311   121.219     0.200
     8.317   121.047     0.200
     8.348   118.816     0.200
     8.396   121.918     0.200
     8.370   123.117     0.200
     8.482   125.117     0.200
     8.710   126.516     0.200
     8.724   123.918     0.200
     8.734   129.918     0.200
     8.789   127.617     0.200
     8.928   132.258     0.200
     8.955   129.617     0.200
     9.065   131.617     0.200
     9.221   134.316     0.200
     9.235   133.219     0.200
     9.315   132.816     0.200
     9.452   135.816     0.200
     9.487   136.617     0.200
     9.616   136.316     0.200
     9.621   137.617     0.200
     9.680   138.016     0.200
     9.710   140.617     0.200
     9.889   140.918     0.200
    10.762   153.816     0.200
    10.801   154.918     0.200
    10.949   156.617     0.200
    11.457   164.219     0.200
    12.379   177.617     0.200
    14.393   200.988     0.200
    18.490   255.789     0.200
    19.510   267.719     0.200
    19.510   267.289     0.200
    20.223   276.316     0.200
    20.467   279.816     0.200
     1.652    29.738     0.200
     1.722    30.918     0.200
     1.987    32.746     0.200
     2.051    35.430     0.200
     2.082    36.496     0.200
     2.495    41.547     0.200
     2.851    46.996     0.200
     2.856    46.707     0.200
     2.874    45.777     0.200
     3.030    49.719     0.200
     3.064    49.258     0.200
     3.143    51.867     0.200
     3.312    53.609     0.200
     3.336    52.609     0.200
     3.402    54.297     0.200
     3.739    59.609     0.200
     3.771    60.777     0.200
     3.945    62.348     0.200
     3.963    62.727     0.200
     3.963    62.727     0.200
     4.058    61.988     0.200
     4.164    64.379     0.200
     4.276    64.898     0.200
     4.362    66.219     0.200
     4.396    67.719     0.200
     4.391    67.418     0.200
     4.391    66.418     0.200
     4.823    72.816     0.200
     4.829    72.227     0.200
     4.916    74.066     0.200
     4.972    75.418     0.200
     5.488    82.617     0.200
     5.586    82.418     0.200
     5.836    87.020     0.200
     6.015    89.816     0.200
     6.097    92.617     0.200
     6.296    92.520     0.200
     6.341    93.219     0.200
     6.602    96.117     0.200
     6.608   100.117     0.200
     6.971   101.719     0.200
     7.492   108.219     0.200
     7.962   114.219     0.200
     8.333   117.719     0.200
     8.708   124.020     0.200
     9.684   137.418     0.200
     1.563    27.299     0.200
     1.576    27.389     0.200
     1.651    28.889     0.200
     1.727    30.458     0.200
     1.983    32.089     0.200
     2.049    34.868     0.200
     2.497    40.648     0.200
     2.851    46.068     0.200
     3.025    48.929     0.200
     3.059    48.629     0.200
     3.104    50.408     0.200
     3.120    49.629     0.200
     3.146    50.339     0.200
     3.122    50.599     0.200
     3.307    52.889     0.200
     3.331    51.958     0.200
     3.397    53.759     0.200
     3.766    59.729     0.200
     3.739    58.458     0.200
     3.746    58.148     0.200
     3.828    58.528     0.200
     3.939    61.358     0.200
     3.958    61.919     0.200
     3.958    61.919     0.200
     4.057    63.488     0.200
     4.275    64.479     0.200
     4.361    65.759     0.200
     4.391    66.389     0.200
     4.401    67.089     0.200
     4.485    68.799     0.200
     4.822    72.188     0.200
     4.917    73.198     0.200
     4.996    74.049     0.200
     5.844    86.788     0.200
     5.841    86.988     0.200
     6.172    92.188     0.200
     6.300    92.288     0.200
     6.346    93.089     0.200
     6.610   100.389     0.200
     6.606    95.988     0.200
     6.974   100.988     0.200
     6.995   100.788     0.200
     7.492   108.988     0.200
     8.335   118.389     0.200
     8.711   123.288     0.200
     9.303   132.089     0.200
     9.603   136.389     0.200
     9.686   136.089     0.200
     1.651    29.587     0.200
     1.766    31.587     0.200
     1.944    32.438     0.200
     2.032    35.547     0.200
     2.105    36.037     0.200
     2.797    46.117     0.200
     2.855    46.587     0.200
     2.972    48.827     0.200
     3.006    48.887     0.200
     3.254    52.697     0.200
     3.279    52.737     0.200
     3.344    53.847     0.200
     3.713    59.337     0.200
     3.886    61.287     0.200
     3.904    61.688     0.200
     3.904    61.688     0.200
     4.171    65.447     0.200
     4.381    68.947     0.200
     4.446    68.147     0.200
     5.563    83.447     0.200
     5.880    87.347     0.200
     5.924    89.347     0.200
     5.960    87.347     0.200
     6.100    91.047     0.200
     6.157    93.347     0.200
     6.342    93.647     0.200
     6.388    94.447     0.200
     6.621   100.047     0.200
     6.642    97.047     0.200
     6.929   102.347     0.200
     6.982   102.847     0.200
     7.005   102.047     0.200
     7.007   103.847     0.200
     7.026   102.447     0.200
     7.170   106.547     0.200
     7.992   114.847     0.200
     8.354   119.447     0.200
     8.731   124.547     0.200
     9.333   133.047     0.200
     9.631   137.147     0.200
     9.699   137.647     0.200
     1.460    26.594     0.200
     1.667    29.102     0.200
     1.698    30.844     0.200
     2.062    35.727     0.200
     2.877    47.078     0.200
     2.869    45.391     0.200
     3.050    50.094     0.200
     3.087    49.672     0.200
     3.333    53.812     0.200
     3.360    53.492     0.200
     3.424    54.609     0.200
     3.790    60.562     0.200
     3.826    59.102     0.200
     3.966    62.281     0.200
     3.984    62.859     0.200
     4.050    62.500     0.200
     4.252    66.570     0.200
     4.301    66.969     0.200
     4.371    67.469     0.200
     4.381    66.867     0.200
     4.381    68.773     0.200
     4.816    72.469     0.200
     5.006    75.273     0.200
     5.478    82.672     0.200
     5.582    82.172     0.200
     5.812    87.273     0.200
     6.000    91.867     0.200
     6.082    91.773     0.200
     6.165    91.570     0.200
     6.271    93.273     0.200
     6.316    93.367     0.200
     6.578    97.867     0.200
     6.591    99.773     0.200
     6.947   102.070     0.200
     6.968   101.969     0.200
     7.190   104.172     0.200
     7.236   107.469     0.200
     7.483   108.070     0.200
     7.940   114.469     0.200
     8.012   116.469     0.200
     8.312   119.070     0.200
     8.688   124.070     0.200
     9.577   136.867     0.200
     1.441    25.293     0.200
     1.998    32.523     0.200
     2.053    34.992     0.200
     2.885    44.871     0.200
     2.875    45.840     0.200
     3.049    48.863     0.200
     3.082    48.621     0.200
     3.332    52.391     0.200
     3.353    52.121     0.200
     3.421    53.512     0.200
     3.791    59.410     0.200
     3.963    60.992     0.200
     3.982    61.453     0.200
     4.399    66.051     0.200
     4.567    69.852     0.200
     4.833    71.551     0.200
     5.018    74.750     0.200
     5.865    86.852     0.200
     6.182    90.852     0.200
     6.337    93.352     0.200
     7.501   107.953     0.200
    12.724   179.852     0.200
     1.428    25.367     0.200
     1.609    27.891     0.200
     1.640    28.891     0.200
     1.757    29.969     0.200
     1.641    28.461     0.200
     1.952    31.734     0.200
     2.029    34.570     0.200
     2.516    41.023     0.200
     2.872    45.414     0.200
     2.818    45.992     0.200
     2.994    48.641     0.200
     3.026    48.883     0.200
     3.172    50.883     0.200
     3.276    52.734     0.200
     3.298    52.734     0.200
     3.365    53.367     0.200
     3.736    59.617     0.200
     3.731    58.250     0.200
     3.741    58.094     0.200
     3.783    58.391     0.200
     3.907    61.719     0.200
     3.926    61.742     0.200
     4.189    64.891     0.200
     4.293    65.789     0.200
     4.250    65.391     0.200
     4.395    66.594     0.200
     4.433    68.094     0.200
     4.310    67.289     0.200
     4.514    68.188     0.200
     4.823    72.391     0.200
     4.698    71.852     0.200
     5.016    74.391     0.200
     4.982    74.992     0.200
     4.934    75.289     0.200
     5.005    75.891     0.200
     4.996    75.891     0.200
     5.285    78.094     0.200
     5.293    79.812     0.200
     5.349    80.367     0.200
     5.494    84.391     0.200
     5.418    81.391     0.200
     5.581    81.992     0.200
     5.768    85.828     0.200
     5.637    83.891     0.200
     5.863    86.688     0.200
     5.871    87.789     0.200
     5.929    88.094     0.200
     5.810    86.094     0.200
     5.961    86.289     0.200
     6.109    91.289     0.200
     6.111    90.992     0.200
     5.999    90.391     0.200
     6.005    88.492     0.200
     6.169    90.789     0.200
     6.173    91.289     0.200
     6.075    89.969     0.200
     6.214    92.688     0.200
     6.183    92.789     0.200
     6.254    92.688     0.200
     6.237    91.492     0.200
     6.160    91.391     0.200
     6.331    92.891     0.200
     6.377    93.789     0.200
     6.281    93.188     0.200
     6.306    94.250     0.200
     6.520    94.594     0.200
     6.613    93.789     0.200
     6.626    99.188     0.200
     6.636    98.391     0.200
     6.635    98.594     0.200
     6.643    97.688     0.200
     6.699    97.891     0.200
     6.654    97.891     0.200
     6.902   101.188     0.200
     6.768    98.891     0.200
     6.931   101.289     0.200
     6.813   100.891     0.200
     6.983   100.891     0.200
     7.001   101.492     0.200
     7.006   102.289     0.200
     7.022   101.992     0.200
     6.983   103.391     0.200
     7.169   104.188     0.200
     7.188   104.594     0.200
     7.189   104.391     0.200
     7.204   105.891     0.200
     7.216   105.391     0.200
     7.201   104.289     0.200
     7.091   104.391     0.200
     7.293   108.094     0.200
     7.495   108.289     0.200
     7.613   108.688     0.200
     7.990   114.891     0.200
     8.004   117.391     0.200
     8.303   120.789     0.200
     8.356   118.789     0.200
     8.468   124.688     0.200
     8.706   125.891     0.200
     8.732   123.992     0.200
     8.722   128.789     0.200
     9.210   134.789     0.200
     9.232   133.289     0.200
     9.329   131.891     0.200
     9.628   136.688     0.200
     9.694   137.492     0.200
     9.708   137.992     0.200
     9.704   138.391     0.200
     9.903   140.992     0.200
    18.482   257.125     0.200
    20.207   275.992     0.200
     1.453    25.415     0.200
     2.860    45.045     0.200
     4.219    65.425     0.200
     4.287    67.425     0.200
     4.378    67.125     0.200
     4.401    67.825     0.200
     4.809    72.125     0.200
     6.087    90.625     0.200
     6.159    90.925     0.200
     6.298    92.125     0.200
     6.344    93.025     0.200
     6.602    96.125     0.200
     6.969   100.225     0.200
     6.990   100.625     0.200
     7.155   103.325     0.200
     7.959   114.525     0.200
     8.327   117.625     0.200
     8.703   123.325     0.200
     9.297   131.925     0.200
     9.597   136.725     0.200
     1.444    25.548     0.200
     2.868    44.888     0.200
     2.845    45.817     0.200
     3.019    47.668     0.200
     3.302    51.407     0.200
     3.326    51.947     0.200
     3.392    52.748     0.200
     3.521    53.407     0.200
     3.760    58.777     0.200
     3.823    59.208     0.200
     3.934    60.478     0.200
     3.952    60.768     0.200
     4.218    65.407     0.200
     4.294    67.107     0.200
     4.386    65.808     0.200
     4.404    67.708     0.200
     4.818    71.808     0.200
     4.878    72.708     0.200
     5.296    79.107     0.200
     5.484    81.508     0.200
     5.579    81.208     0.200
     5.843    85.008     0.200
     6.013    89.607     0.200
     6.096    90.508     0.200
     6.095    90.308     0.200
     6.167    90.907     0.200
     6.239    92.907     0.200
     6.189    91.808     0.200
     6.348    93.308     0.200
     6.309    93.808     0.200
     6.608    97.607     0.200
     6.608    98.008     0.200
     6.975   100.808     0.200
     6.996   100.808     0.200
     7.011   103.808     0.200
     7.160   103.407     0.200
     7.265   107.607     0.200
     7.487   108.208     0.200
     7.965   114.107     0.200
     8.334   118.107     0.200
     8.387   120.907     0.200
     8.710   123.407     0.200
     9.201   134.308     0.200
     9.303   131.708     0.200
     9.603   136.107     0.200
     9.668   136.907     0.200
     9.877   140.308     0.200
     1.657    29.123     0.200
     1.717    30.363     0.200
     1.992    32.723     0.200
     2.077    35.854     0.200
     2.490    40.854     0.200
     2.846    46.863     0.200
     2.859    46.184     0.200
     2.871    45.693     0.200
     3.032    49.014     0.200
     3.067    48.543     0.200
     3.096    51.354     0.200
     3.176    52.094     0.200
     3.315    52.643     0.200
     3.340    51.943     0.200
     3.406    53.863     0.200
     3.456    56.793     0.200
     3.743    59.863     0.200
     3.773    59.834     0.200
     3.948    61.312     0.200
     3.965    61.943     0.200
     4.161    63.482     0.200
     4.284    68.303     0.200
     4.299    67.953     0.200
     4.392    67.254     0.200
     4.355    67.953     0.200
     4.387    66.152     0.200
     4.820    72.453     0.200
     4.825    72.393     0.200
     5.000    75.254     0.200
     5.048    76.652     0.200
     5.112    75.354     0.200
     5.485    82.354     0.200
     5.583    82.354     0.200
     5.831    86.453     0.200
     5.837    86.754     0.200
     5.905    87.854     0.200
     5.930    86.354     0.200
     6.010    90.854     0.200
     6.092    92.053     0.200
     6.169    91.453     0.200
     6.190    91.453     0.200
     6.236    94.953     0.200
     6.336    93.254     0.200
     6.491    94.854     0.200
     6.597    97.254     0.200
     6.603   100.254     0.200
     6.903   101.453     0.200
     6.954   101.652     0.200
     6.965   101.254     0.200
     6.986   100.953     0.200
     7.148   106.354     0.200
     7.255   105.354     0.200
     7.488   107.754     0.200
     7.957   114.152     0.200
     8.328   118.254     0.200
     8.703   123.453     0.200
     1.700    30.730     0.200
     2.009    33.398     0.200
     2.053    35.621     0.200
     2.072    37.191     0.200
     2.465    40.789     0.200
     2.874    47.250     0.200
     3.072    51.191     0.200
     3.118    51.789     0.200
     4.379    67.180     0.200
     6.276    90.379     0.200
     6.322    93.281     0.200
     7.236   106.781     0.200
     7.461   110.078     0.200
     7.934   113.281     0.200
     8.013   116.180     0.200
     8.303   118.480     0.200
     8.541   121.680     0.200
     8.679   123.379     0.200
     1.645    28.719     0.200
     1.765    31.023     0.200
     1.945    31.719     0.200
     2.108    35.719     0.200
     2.291    38.117     0.200
     2.326    39.617     0.200
     2.517    41.117     0.200
     2.810    45.117     0.200
     2.863    44.602     0.200
     2.881    47.320     0.200
     3.132    50.219     0.200
     3.736    58.617     0.200
     3.747    57.922     0.200
     3.761    59.219     0.200
     4.388    66.617     0.200
     4.444    67.617     0.200
     4.814    72.219     0.200
     4.920    75.320     0.200
     4.968    74.219     0.200
     5.487    82.320     0.200
     5.571    81.922     0.200
     5.798    85.523     0.200
     6.108    91.922     0.200
     6.165    91.023     0.200
     6.251    93.719     0.200
     6.340    92.820     0.200
     6.386    93.820     0.200
     6.642    96.422     0.200
     7.197   106.617     0.200
     7.299   105.820     0.200
     7.487   107.922     0.200
     8.357   118.820     0.200
     8.593   122.320     0.200
     8.734   123.219     0.200
     1.600    28.045     0.200
     1.646    28.745     0.200
     1.747    29.545     0.200
     1.962    32.245     0.200
     2.509    40.845     0.200
     2.870    45.265     0.200
     2.826    44.944     0.200
     3.164    50.645     0.200
     3.113    49.545     0.200
     3.125    50.245     0.200
     3.501    54.345     0.200
     3.497    54.045     0.200
     3.735    58.045     0.200
     3.744    58.444     0.200
     3.793    58.345     0.200
     4.093    64.255     0.200
     4.270    64.814     0.200
     4.293    67.345     0.200
     4.259    65.444     0.200
     4.355    66.095     0.200
     4.392    66.245     0.200
     4.424    67.545     0.200
     4.523    69.245     0.200
     4.725    72.135     0.200
     4.697    69.404     0.200
     4.707    71.625     0.200
     4.821    72.345     0.200
     4.832    72.795     0.200
     4.870    73.045     0.200
     4.926    72.995     0.200
     4.993    76.404     0.200
     5.009    74.234     0.200
     4.984    75.145     0.200
     4.943    74.845     0.200
     5.006    76.645     0.200
     5.121    76.225     0.200
     5.288    78.045     0.200
     5.358    80.585     0.200
     5.490    81.845     0.200
     5.428    82.345     0.200
     5.580    81.944     0.200
     5.646    84.545     0.200
     5.761    85.875     0.200
     5.744    85.265     0.200
     5.872    86.944     0.200
     5.820    86.545     0.200
     6.022    90.145     0.200
     6.057    87.645     0.200
     6.008    90.845     0.200
     6.015    89.625     0.200
     6.104    91.145     0.200
     6.170    91.345     0.200
     6.249    93.444     0.200
     6.239    91.845     0.200
     6.322    92.944     0.200
     6.368    93.645     0.200
     6.315    94.345     0.200
     6.620    99.444     0.200
     6.626    97.045     0.200
     6.643    97.845     0.200
     6.992   101.845     0.200
     7.013   101.645     0.200
     7.179   103.645     0.200
     7.100   105.345     0.200
     7.198   104.645     0.200
     7.198   104.357     0.200
     7.189   105.375     0.200
     7.189   104.845     0.200
     7.284   104.645     0.200
     7.492   108.145     0.200
     7.982   114.845     0.200
     8.012   117.845     0.200
     8.119   118.734     0.200
     8.304   118.654     0.200
     8.349   118.545     0.200
     8.406   121.845     0.200
     8.380   122.944     0.200
     8.586   122.245     0.200
     8.725   123.944     0.200
     8.911   131.104     0.200
     9.228   133.245     0.200
     9.321   132.845     0.200
     9.660   139.614     0.200
     9.701   137.645     0.200
     9.895   141.045     0.200
    10.592   152.455     0.200
    14.400   202.045     0.200
    15.007   209.465     0.200
     1.623    27.629     0.200
     1.742    29.629     0.200
     1.646    28.930     0.200
     1.968    32.527     0.200
     2.873    45.508     0.200
     2.835    45.547     0.200
     2.832    45.227     0.200
     3.010    47.938     0.200
     3.043    48.316     0.200
     3.200    51.430     0.200
     3.122    50.027     0.200
     3.113    49.629     0.200
     3.292    51.949     0.200
     3.314    51.848     0.200
     3.381    53.367     0.200
     3.497    54.898     0.200
     3.764    59.297     0.200
     3.660    56.930     0.200
     3.746    59.098     0.200
     3.751    58.527     0.200
     3.735    58.379     0.200
     3.743    58.309     0.200
     3.827    58.840     0.200
     3.909    61.066     0.200
     3.800    60.527     0.200
     3.813    57.828     0.200
     3.944    60.578     0.200
     3.923    61.750     0.200
     3.942    60.949     0.200
     4.058    62.066     0.200
     4.089    64.809     0.200
     4.012    63.156     0.200
     4.216    65.617     0.200
     4.230    66.738     0.200
     4.281    67.348     0.200
     4.297    65.430     0.200
     4.358    66.629     0.200
     4.265    65.328     0.200
     4.393    65.629     0.200
     4.417    67.430     0.200
     4.470    68.707     0.200
     4.530    69.828     0.200
     4.690    68.867     0.200
     4.627    71.566     0.200
     4.713    71.930     0.200
     4.823    72.328     0.200
     4.832    72.316     0.200
     4.924    72.777     0.200
     4.875    73.430     0.200
     4.860    72.988     0.200
     4.989    76.617     0.200
     5.006    74.406     0.200
     4.990    74.629     0.200
     4.950    75.430     0.200
     5.077    77.098     0.200
     5.122    75.617     0.200
     5.012    76.328     0.200
     5.022    76.047     0.200
     5.170    76.906     0.200
     5.223    80.227     0.200
     5.294    78.828     0.200
     5.408    80.809     0.200
     5.470    83.547     0.200
     5.491    82.129     0.200
     5.523    82.039     0.200
     5.434    82.328     0.200
     5.583    82.227     0.200
     5.668    83.277     0.200
     5.717    85.617     0.200
     5.716    85.500     0.200
     5.759    85.648     0.200
     5.651    84.328     0.200
     5.795    85.430     0.200
     5.854    86.328     0.200
     5.752    85.168     0.200
     5.906    88.629     0.200
     5.921    87.828     0.200
     5.827    86.828     0.200
     5.950    86.227     0.200
     6.021    89.629     0.200
     6.054    87.809     0.200
     6.105    90.328     0.200
     6.104    90.629     0.200
     6.014    91.328     0.200
     6.021    89.328     0.200
     6.159    91.129     0.200
     6.172    91.328     0.200
     6.092    89.930     0.200
     6.206    92.727     0.200
     6.248    92.328     0.200
     6.177    92.328     0.200
     6.244    92.129     0.200
     6.306    92.539     0.200
     6.316    92.430     0.200
     6.337    91.047     0.200
     6.355    92.906     0.200
     6.361    93.430     0.200
     6.297    94.129     0.200
     6.321    94.250     0.200
     6.499    93.770     0.200
     6.569    94.387     0.200
     6.486    95.328     0.200
     6.621    98.227     0.200
     6.618    98.129     0.200
     6.627    97.629     0.200
     6.633    97.930     0.200
     6.607    97.629     0.200
     6.691    95.867     0.200
     6.617    97.129     0.200
     6.736    94.629     0.200
     6.704    98.027     0.200
     6.704   101.629     0.200
     6.745    99.129     0.200
     6.775   100.828     0.200
     6.671    98.828     0.200
     6.893   101.430     0.200
     6.783    99.289     0.200
     6.906   103.328     0.200
     6.943   101.930     0.200
     6.829   100.828     0.200
     6.947   104.328     0.200
     6.973   102.129     0.200
     6.988   101.930     0.200
     7.009   102.430     0.200
     7.043   103.629     0.200
     7.065   103.328     0.200
     6.945   101.328     0.200
     7.000   104.129     0.200
     7.113   104.129     0.200
     7.157   103.930     0.200
     7.173   105.828     0.200
     7.057   103.250     0.200
     7.177   104.629     0.200
     7.203   105.629     0.200
     7.207   106.629     0.200
     7.199   104.242     0.200
     7.104   104.828     0.200
     7.195   105.328     0.200
     7.278   107.430     0.200
     7.334   106.527     0.200
     7.334   106.629     0.200
     7.352   106.566     0.200
     7.493   108.227     0.200
     7.548   109.328     0.200
     7.597   109.629     0.200
     7.602   108.828     0.200
     7.720   112.336     0.200
     7.782   112.430     0.200
     7.833   113.129     0.200
     7.859   112.727     0.200
     7.783   113.328     0.200
     7.960   114.430     0.200
     7.978   114.727     0.200
     8.040   115.328     0.200
     8.055   118.027     0.200
     8.076   115.930     0.200
     7.975   114.770     0.200
     8.001   115.828     0.200
     8.017   118.328     0.200
     8.237   117.227     0.200
     8.303   118.930     0.200
     8.346   118.629     0.200
     8.400   122.129     0.200
     8.390   122.527     0.200
     8.390   122.527     0.200
     8.490   120.930     0.200
     8.384   123.328     0.200
     8.472   123.430     0.200
     8.550   121.828     0.200
     8.583   122.328     0.200
     8.703   125.727     0.200
     8.722   123.828     0.200
     8.725   128.430     0.200
     8.919   131.348     0.200
     9.050   128.328     0.200
     9.133   135.527     0.200
     9.157   130.227     0.200
     9.206   132.828     0.200
     9.212   132.727     0.200
     9.229   132.227     0.200
     9.260   134.367     0.200
     9.316   132.727     0.200
     9.319   135.219     0.200
     9.457   137.629     0.200
     9.615   136.629     0.200
     9.681   137.727     0.200
     9.697   138.527     0.200
     9.718   138.328     0.200
     9.703   138.828     0.200
     9.848   142.328     0.200
     9.890   141.527     0.200
    10.038   143.828     0.200
    10.184   145.727     0.200
    10.322   149.430     0.200
    10.627   154.340     0.200
    10.765   154.629     0.200
    10.806   155.930     0.200
    10.916   154.527     0.200
    11.163   157.727     0.200
    11.462   165.629     0.200
    11.634   166.277     0.200
    11.890   170.109     0.200
    11.954   171.727     0.200
    12.598   177.328     0.200
    12.888   181.629     0.200
    12.888   185.000     0.200
    12.945   183.328     0.200
    13.599   194.609     0.200
    13.931   196.828     0.200
    14.400   202.000     0.200
    14.400   200.770     0.200
    14.414   206.328     0.200
    18.397   254.727     0.200
    18.482   255.523     0.200
    19.503   267.227     0.200
    19.503   267.203     0.200
    20.221   276.879     0.200
    20.456   280.727     0.200
     1.495    24.951     0.200
     1.673    28.150     0.200
     1.847    31.650     0.200
     2.212    37.350     0.200
     2.374    37.850     0.200
     2.469    39.451     0.200
     2.465    39.500     0.200
     2.615    41.150     0.200
     2.674    43.291     0.200
     2.688    42.131     0.200
     2.753    44.170     0.200
     2.780    45.070     0.200
     2.810    42.871     0.200
     2.831    44.250     0.200
     3.152    50.291     0.200
     3.271    51.250     0.200
     3.296    51.451     0.200
     3.319    52.281     0.200
     3.493    54.750     0.200
     3.550    55.650     0.200
     3.704    56.400     0.200
     3.705    57.551     0.200
     3.783    57.551     0.200
     4.102    61.750     0.200
     4.144    62.451     0.200
     4.199    62.820     0.200
     4.309    65.951     0.200
     4.407    65.051     0.200
     4.494    68.750     0.200
     4.499    68.250     0.200
     4.764    70.350     0.200
     4.882    70.850     0.200
     4.997    75.150     0.200
     5.214    78.051     0.200
     5.249    77.350     0.200
     5.406    80.650     0.200
     5.440    79.451     0.200
     5.520    80.350     0.200
     5.520    83.051     0.200
     5.833    86.250     0.200
     6.013    88.250     0.200
     6.118    89.051     0.200
     6.160    89.451     0.200
     6.378    92.551     0.200
     6.852    99.150     0.200
     6.861    99.350     0.200
     7.106   101.350     0.200
     7.431   106.051     0.200
     7.464   107.650     0.200
     7.451   106.350     0.200
     7.601   110.951     0.200
     7.767   111.750     0.200
     8.377   118.451     0.200
     8.666   122.850     0.200
     8.863   125.750     0.200
     9.048   128.250     0.200
    10.028   141.650     0.200
     1.638    28.334     0.200
     1.930    31.334     0.200
     2.018    34.334     0.200
     2.397    38.734     0.200
     2.527    41.234     0.200
     2.865    44.914     0.200
     2.790    44.615     0.200
     2.796    44.734     0.200
     2.966    47.334     0.200
     3.049    49.523     0.200
     3.192    50.434     0.200
     3.103    49.334     0.200
     3.130    49.334     0.200
     3.248    51.574     0.200
     3.269    51.885     0.200
     3.335    52.785     0.200
     3.336    52.635     0.200
     3.464    55.334     0.200
     3.495    54.004     0.200
     3.709    57.674     0.200
     3.796    60.324     0.200
     3.816    59.205     0.200
     3.756    58.734     0.200
     3.769    60.734     0.200
     3.731    58.004     0.200
     3.743    58.004     0.200
     3.939    62.004     0.200
     3.878    60.764     0.200
     3.897    62.184     0.200
     3.919    61.434     0.200
     4.054    62.205     0.200
     3.989    64.023     0.200
     4.117    64.645     0.200
     4.118    63.975     0.200
     4.149    63.654     0.200
     4.353    66.484     0.200
     4.392    66.035     0.200
     4.229    65.234     0.200
     4.287    65.635     0.200
     4.442    68.215     0.200
     4.487    69.734     0.200
     4.653    69.615     0.200
     4.728    71.535     0.200
     4.817    71.834     0.200
     4.676    71.424     0.200
     4.847    72.434     0.200
     4.938    73.135     0.200
     4.963    74.234     0.200
     4.906    75.234     0.200
     5.127    75.564     0.200
     4.979    75.734     0.200
     4.973    75.734     0.200
     5.265    77.934     0.200
     5.492    81.934     0.200
     5.330    79.934     0.200
     5.393    81.734     0.200
     5.572    82.635     0.200
     5.620    83.734     0.200
     5.708    85.375     0.200
     5.853    88.234     0.200
     5.893    87.834     0.200
     6.113    90.934     0.200
     6.116    90.934     0.200
     5.980    89.064     0.200
     5.977    90.234     0.200
     6.168    90.834     0.200
     6.048    90.654     0.200
     6.224    92.410     0.200
     6.220    91.135     0.200
     6.259    93.334     0.200
     6.132    91.734     0.200
     6.306    92.434     0.200
     6.355    92.834     0.200
     6.252    92.934     0.200
     6.401    93.434     0.200
     6.283    94.295     0.200
     6.443    95.334     0.200
     6.635    98.635     0.200
     6.656    98.035     0.200
     6.686    98.135     0.200
     6.573    96.535     0.200
     6.607    97.234     0.200
     6.627    98.734     0.200
     6.784   100.234     0.200
     6.888   103.334     0.200
     6.743    99.734     0.200
     6.789   100.734     0.200
     7.019   101.734     0.200
     7.040   102.635     0.200
     7.050   103.035     0.200
     6.955   103.535     0.200
     7.014   102.615     0.200
     7.197   104.535     0.200
     7.197   104.248     0.200
     7.167   103.934     0.200
     7.212   106.934     0.200
     7.074   104.734     0.200
     7.313   107.934     0.200
     7.316   106.635     0.200
     7.491   107.734     0.200
     7.360   109.234     0.200
     7.580   108.934     0.200
     7.706   113.146     0.200
     7.879   114.234     0.200
     7.875   114.234     0.200
     8.006   116.135     0.200
     8.065   115.834     0.200
     8.093   116.635     0.200
     8.091   117.234     0.200
     7.985   117.734     0.200
     8.259   118.234     0.200
     8.296   120.834     0.200
     8.291   123.773     0.200
     8.369   118.734     0.200
     8.316   121.734     0.200
     8.439   122.535     0.200
     8.511   121.535     0.200
     8.354   122.234     0.200
     8.570   123.434     0.200
     8.603   122.234     0.200
     8.564   125.234     0.200
     8.704   125.734     0.200
     8.745   123.834     0.200
     8.876   130.424     0.200
     8.876   130.834     0.200
     9.074   129.135     0.200
     9.202   132.535     0.200
     9.200   137.135     0.200
     9.231   132.035     0.200
     9.498   137.434     0.200
     9.645   138.734     0.200
     9.713   139.535     0.200
     9.722   137.635     0.200
     9.886   142.535     0.200
     9.923   140.535     0.200
    10.117   146.164     0.200
    10.367   146.635     0.200
    14.445   203.799     0.200
    18.476   255.227     0.200
    19.499   267.734     0.200
    19.499   268.049     0.200
    20.186   277.127     0.200
     1.177    21.570     0.200
     1.240    22.773     0.200
     1.412    26.273     0.200
     1.437    25.875     0.200
     1.469    27.172     0.200
     1.463    24.773     0.200
     1.649    27.070     0.200
     1.816    29.070     0.200
     1.949    31.312     0.200
     1.893    31.172     0.200
     2.293    36.977     0.200
     2.509    40.172     0.200
     2.560    40.297     0.200
     3.794    57.555     0.200
     3.923    60.586     0.200
     3.974    59.875     0.200
     4.138    62.570     0.200
     4.519    67.477     0.200
     5.640    82.875     0.200
     5.863    86.977     0.200
     5.873    86.570     0.200
     5.945    88.172     0.200
     5.969    88.570     0.200
     6.112    90.672     0.200
     6.539    96.773     0.200
     6.569    93.875     0.200
     6.795    96.273     0.200
     7.113   100.977     0.200
     7.212   104.773     0.200
     7.412   104.977     0.200
     7.456   105.672     0.200
     8.056   114.375     0.200
     8.346   118.773     0.200
     8.546   122.070     0.200
     8.727   123.570     0.200
     9.437   132.273     0.200
     9.707   137.172     0.200
     9.803   138.172     0.200
     9.825   138.172     0.200
    10.029   140.773     0.200
    10.343   145.672     0.200
     1.623    28.918     0.200
     1.917    31.816     0.200
     2.786    45.840     0.200
     2.878    47.680     0.200
     2.964    48.777     0.200
     3.043    49.648     0.200
     3.245    52.918     0.200
     3.262    52.727     0.200
     3.333    53.688     0.200
     3.331    53.719     0.200
     3.707    59.578     0.200
     3.828    59.289     0.200
     3.874    61.379     0.200
     3.894    61.719     0.200
     4.119    62.930     0.200
     4.367    66.777     0.200
     4.470    68.617     0.200
     4.454    68.520     0.200
     4.735    71.148     0.200
     4.831    73.418     0.200
     4.898    77.418     0.200
     4.971    75.219     0.200
     5.507    83.816     0.200
     6.046    90.117     0.200
     6.129    92.117     0.200
     6.182    92.020     0.200
     6.240    93.469     0.200
     6.275    94.520     0.200
     6.414    94.020     0.200
     6.651    99.418     0.200
     6.670    98.020     0.200
     7.034   103.418     0.200
     7.055   103.418     0.200
     7.225   104.719     0.200
     7.211   105.055     0.200
     7.328   107.020     0.200
     7.358   108.617     0.200
     8.022   116.617     0.200
     8.105   117.617     0.200
     8.385   121.316     0.200
     8.452   121.617     0.200
     8.619   123.219     0.200
     8.761   126.219     0.200
     8.875   130.434     0.200
     9.510   135.816     0.200
    14.354   204.566     0.200
     1.520    26.574     0.200
     1.594    27.775     0.200
     1.540    26.275     0.200
     1.655    29.256     0.200
     1.988    33.875     0.200
     2.811    44.535     0.200
     4.074    62.275     0.200
     4.239    65.154     0.200
     4.304    65.375     0.200
     4.423    66.176     0.200
     4.789    71.895     0.200
     4.948    73.805     0.200
     5.266    79.006     0.200
     5.644    84.535     0.200
     6.060    89.145     0.200
     6.105    89.975     0.200
     6.180    91.176     0.200
     6.557    96.375     0.200
     6.625    96.936     0.200
     6.934   102.176     0.200
     7.047   103.676     0.200
     7.108   103.475     0.200
     7.271   104.074     0.200
     7.582   107.676     0.200
     7.602   107.574     0.200
     7.593   109.074     0.200
     7.933   113.574     0.200
     8.513   120.176     0.200
     8.775   124.074     0.200
     8.959   127.176     0.200
     9.158   128.475     0.200
     9.903   138.875     0.200
    10.167   142.074     0.200
    10.148   143.275     0.200
    10.289   144.275     0.200
    10.499   147.475     0.200
    10.817   151.875     0.200
    13.520   189.275     0.200
     1.666    29.150     0.200
     1.635    29.750     0.200
     1.613    29.250     0.200
     1.709    29.850     0.200
     1.755    31.451     0.200
     2.046    34.951     0.200
     2.136    35.650     0.200
     2.091    36.451     0.200
     2.273    38.650     0.200
     2.398    41.131     0.200
     2.499    41.750     0.200
     2.922    47.420     0.200
     3.792    59.061     0.200
     4.091    63.840     0.200
     4.081    62.871     0.200
     4.211    64.650     0.200
     4.366    65.850     0.200
     4.626    69.311     0.200
     4.730    69.420     0.200
     4.792    72.250     0.200
     4.909    73.650     0.200
     4.917    74.061     0.200
     5.549    82.350     0.200
     6.002    88.650     0.200
     6.085    89.551     0.200
     6.088    89.850     0.200
     6.143    90.750     0.200
     6.231    92.250     0.200
     6.332    90.951     0.200
     6.379    91.551     0.200
     6.606    96.951     0.200
     6.630    94.750     0.200
     6.993   100.150     0.200
     7.014   100.551     0.200
     7.171   104.551     0.200
     7.465   108.350     0.200
     7.553   109.551     0.200
     7.979   113.650     0.200
     8.340   119.350     0.200
     8.575   122.951     0.200
     8.717   124.451     0.200
     9.321   131.451     0.200
     9.686   136.350     0.200
     9.722   136.850     0.200
     9.896   138.850     0.200
     1.486    26.328     0.200
     1.590    28.125     0.200
     1.642    29.625     0.200
     1.746    30.930     0.200
     1.763    31.227     0.200
     1.809    31.523     0.200
     1.810    31.727     0.200
     2.485    41.023     0.200
     2.508    41.508     0.200
     2.830    46.727     0.200
     3.045    48.703     0.200
     3.332    52.727     0.200
     3.360    52.930     0.200
     3.584    55.984     0.200
     3.550    56.766     0.200
     3.573    56.500     0.200
     3.702    58.719     0.200
     3.823    59.836     0.200
     3.846    60.414     0.200
     3.960    61.633     0.200
     4.247    66.328     0.200
     4.393    66.727     0.200
     4.327    67.688     0.200
     4.391    68.883     0.200
     4.447    69.570     0.200
     4.614    72.320     0.200
     4.636    71.094     0.200
     4.771    74.125     0.200
     5.054    77.727     0.200
     5.060    76.625     0.200
     5.084    76.648     0.200
     5.115    77.094     0.200
     5.259    80.484     0.200
     5.283    81.773     0.200
     5.311    81.227     0.200
     5.441    82.070     0.200
     5.519    83.227     0.200
     5.729    85.023     0.200
     5.959    88.328     0.200
     5.988    89.945     0.200
     6.028    88.523     0.200
     6.144    91.625     0.200
     6.305    92.430     0.200
     6.361    93.023     0.200
     6.378    93.523     0.200
     6.356    94.797     0.200
     6.439    95.820     0.200
     6.601    97.828     0.200
     6.679    99.500     0.200
     6.792    99.023     0.200
     6.862   101.523     0.200
     7.018   106.523     0.200
     7.227   104.727     0.200
     7.235   105.523     0.200
     7.249   105.227     0.200
     7.246   106.984     0.200
     7.437   107.430     0.200
     7.437   112.523     0.200
     7.443   108.523     0.200
     7.876   113.523     0.200
     7.876   114.023     0.200
     7.932   113.828     0.200
     8.115   118.727     0.200
     8.175   117.023     0.200
     8.168   118.430     0.200
     8.276   118.430     0.200
     8.742   123.727     0.200
     9.023   129.023     0.200
     9.046   130.430     0.200
    10.373   149.227     0.200
    10.394   151.227     0.200
    12.475   176.359     0.200
    14.657   207.523     0.200
    16.016   224.758     0.200
    18.484   257.828     0.200
    18.613   260.930     0.200
    20.179   275.625     0.200
     1.614    27.961     0.200
     1.667    30.062     0.200
     1.849    30.367     0.200
     1.940    32.367     0.200
     2.439    40.266     0.200
     2.558    42.664     0.200
     2.711    43.461     0.200
     4.732    69.961     0.200
     5.017    73.742     0.200
     5.114    76.867     0.200
     5.844    85.211     0.200
     7.013   101.562     0.200
     7.651   110.164     0.200
     7.792   111.266     0.200
     8.618   122.867     0.200
     8.938   127.461     0.200
     9.147   129.766     0.200
     9.318   133.062     0.200
     1.155    20.164     0.200
     1.281    22.164     0.200
     1.292    23.461     0.200
     1.301    22.461     0.200
     1.309    22.859     0.200
     1.405    24.258     0.200
     1.388    23.664     0.200
     1.428    23.859     0.200
     1.523    25.258     0.200
     1.598    26.359     0.200
     1.624    27.664     0.200
     1.624    26.438     0.200
     1.624    27.164     0.200
     1.719    28.961     0.200
     1.764    28.562     0.200
     1.819    29.961     0.200
     1.930    31.164     0.200
     1.980    33.164     0.200
     2.151    35.258     0.200
     2.155    34.758     0.200
     2.245    36.164     0.200
     2.260    36.359     0.200
     2.287    36.633     0.200
     2.321    37.258     0.200
     2.403    39.359     0.200
     2.466    39.164     0.200
     2.457    39.078     0.200
     2.523    39.664     0.200
     2.553    40.648     0.200
     2.581    41.859     0.200
     2.616    40.961     0.200
     2.691    42.062     0.200
     2.739    43.359     0.200
     2.792    43.500     0.200
     2.834    44.562     0.200
     2.826    44.781     0.200
     2.837    45.055     0.200
     2.885    46.164     0.200
     2.900    44.859     0.200
     3.017    47.359     0.200
     3.011    47.664     0.200
     3.091    47.258     0.200
     3.199    49.750     0.200
     3.344    52.664     0.200
     3.318    51.312     0.200
     3.378    53.312     0.200
     3.391    53.711     0.200
     3.475    53.164     0.200
     3.531    55.258     0.200
     3.566    54.664     0.200
     3.597    55.258     0.200
     3.654    56.664     0.200
     3.659    57.062     0.200
     3.706    55.859     0.200
     3.721    57.758     0.200
     3.857    57.961     0.200
     3.924    60.258     0.200
     3.976    61.258     0.200
     4.000    59.359     0.200
     4.063    61.164     0.200
     4.056    61.680     0.200
     4.056    61.859     0.200
     4.113    64.258     0.200
     4.190    63.164     0.200
     4.191    62.961     0.200
     4.280    63.258     0.200
     4.372    65.258     0.200
     4.375    65.664     0.200
     4.371    65.984     0.200
     4.429    67.867     0.200
     4.429    67.648     0.200
     4.445    65.859     0.200
     4.464    66.852     0.200
     4.506    71.742     0.200
     4.537    67.000     0.200
     4.553    69.062     0.200
     4.564    66.961     0.200
     4.568    68.039     0.200
     4.562    68.773     0.200
     4.648    69.102     0.200
     4.738    71.961     0.200
     4.732    69.898     0.200
     4.821    72.258     0.200
     4.983    72.758     0.200
     5.027    76.164     0.200
     5.076    74.062     0.200
     5.082    76.664     0.200
     5.170    75.461     0.200
     5.339    78.281     0.200
     5.339    78.164     0.200
     5.330    78.312     0.200
     5.392    79.602     0.200
     5.487    79.664     0.200
     5.504    80.258     0.200
     5.658    84.664     0.200
     5.698    81.961     0.200
     5.772    84.562     0.200
     5.800    84.664     0.200
     5.759    85.961     0.200
     5.759    86.062     0.200
     5.867    86.164     0.200
     5.854    85.758     0.200
     6.003    88.086     0.200
     6.003    87.758     0.200
     6.021    88.117     0.200
     6.023    87.320     0.200
     6.104    89.234     0.200
     6.130    89.711     0.200
     6.151    88.164     0.200
     6.161    91.164     0.200
     6.239    89.359     0.200
     6.274    91.641     0.200
     6.320    93.562     0.200
     6.320    92.258     0.200
     6.353    92.562     0.200
     6.386    94.164     0.200
     6.403    92.258     0.200
     6.463    95.461     0.200
     6.706    97.523     0.200
     6.706    98.062     0.200
     6.726    95.359     0.200
     6.785    97.859     0.200
     6.889   101.461     0.200
     6.962    99.461     0.200
     6.991   101.758     0.200
     7.049   101.062     0.200
     7.049   101.422     0.200
     7.105   105.859     0.200
     7.284   102.461     0.200
     7.304   103.461     0.200
     7.346   105.562     0.200
     7.449   106.758     0.200
     7.438   107.172     0.200
     7.464   105.562     0.200
     7.571   107.758     0.200
     7.623   107.758     0.200
     7.730   111.461     0.200
     7.765   115.664     0.200
     7.818   114.414     0.200
     7.992   113.461     0.200
     8.107   116.961     0.200
     8.178   115.664     0.200
     8.186   115.758     0.200
     8.228   115.961     0.200
     8.235   116.961     0.200
     8.368   123.547     0.200
     8.368   121.664     0.200
     8.399   118.664     0.200
     8.419   118.961     0.200
     8.415   118.359     0.200
     8.517   120.562     0.200
     8.590   121.664     0.200
     8.635   122.359     0.200
     8.681   123.664     0.200
     8.716   122.859     0.200
     8.806   125.258     0.200
     8.899   124.961     0.200
     9.140   129.359     0.200
     9.134   130.258     0.200
     9.227   130.062     0.200
     9.608   134.961     0.200
     9.879   137.859     0.200
     9.885   139.664     0.200
     9.898   138.859     0.200
     9.880   143.594     0.200
     9.974   139.664     0.200
     9.997   139.461     0.200
    10.199   142.164     0.200
    10.512   147.164     0.200
    13.910   197.562     0.200
    13.910   199.461     0.200
    19.115   262.758     0.200
    19.978   273.062     0.200
    20.579   278.562     0.200
     1.397    24.828     0.200
     1.521    26.227     0.200
     1.569    27.727     0.200
     1.577    27.727     0.200
     1.557    28.133     0.200
     1.560    27.227     0.200
     1.699    30.133     0.200
     1.729    30.328     0.200
     1.811    31.531     0.200
     1.802    30.328     0.200
     1.849    30.828     0.200
     1.949    32.727     0.200
     1.946    32.133     0.200
     2.048    33.531     0.200
     2.099    35.633     0.200
     2.162    37.227     0.200
     2.242    36.328     0.200
     2.202    37.031     0.200
     2.206    36.430     0.200
     2.293    37.828     0.200
     2.293    38.328     0.200
     2.317    39.227     0.200
     2.503    40.227     0.200
     2.541    40.727     0.200
     2.542    41.828     0.200
     2.966    49.328     0.200
     3.059    48.328     0.200
     3.304    53.328     0.200
     3.306    51.391     0.200
     3.423    53.258     0.200
     3.621    56.352     0.200
     3.666    57.328     0.200
     3.857    60.141     0.200
     3.862    58.328     0.200
     3.894    60.430     0.200
     3.887    58.727     0.200
     3.958    61.312     0.200
     3.994    62.180     0.200
     4.061    61.727     0.200
     4.081    60.828     0.200
     4.367    67.812     0.200
     4.503    70.227     0.200
     4.536    70.227     0.200
     4.636    71.008     0.200
     4.739    73.227     0.200
     5.119    77.023     0.200
     5.167    77.133     0.200
     5.219    77.914     0.200
     5.325    81.133     0.200
     5.402    82.008     0.200
     5.395    80.227     0.200
     5.462    81.531     0.200
     5.478    81.102     0.200
     5.575    83.031     0.200
     5.581    82.367     0.200
     5.599    81.930     0.200
     5.641    83.531     0.200
     5.632    83.828     0.200
     5.786    86.031     0.200
     5.799    86.430     0.200
     5.812    85.922     0.200
     5.886    88.680     0.200
     5.918    87.727     0.200
     6.014    87.930     0.200
     6.032    88.406     0.200
     6.038    87.930     0.200
     6.237    91.328     0.200
     6.239    91.445     0.200
     6.295    91.859     0.200
     6.320    92.773     0.200
     6.420    95.531     0.200
     6.438    94.430     0.200
     6.437    94.211     0.200
     6.554    95.961     0.200
     6.667   100.031     0.200
     6.722   100.727     0.200
     6.740    98.648     0.200
     6.735    98.000     0.200
     6.858   102.133     0.200
     6.886   101.328     0.200
     6.924   100.828     0.200
     7.068   106.133     0.200
     7.108   104.031     0.200
     7.446   109.227     0.200
     7.486   107.727     0.200
     7.557   109.070     0.200
     7.577   110.328     0.200
     7.814   114.227     0.200
     7.847   114.031     0.200
     7.920   115.430     0.200
     7.920   115.531     0.200
     8.053   116.133     0.200
     8.094   116.328     0.200
     8.465   122.727     0.200
     8.637   122.930     0.200
     8.722   124.031     0.200
     8.803   130.031     0.200
     9.094   129.328     0.200
     9.169   129.727     0.200
     9.504   135.031     0.200
     9.519   139.531     0.200
     9.532   133.828     0.200
     9.572   137.531     0.200
     9.587   135.727     0.200
    10.104   147.828     0.200
    13.905   196.695     0.200
     1.393    25.562     0.200
     1.396    25.656     0.200
     1.420    25.359     0.200
     1.499    26.461     0.200
     1.574    27.562     0.200
     1.586    27.961     0.200
     1.587    28.062     0.200
     1.557    26.859     0.200
     1.554    26.656     0.200
     1.618    28.359     0.200
     1.589    27.562     0.200
     1.637    28.062     0.200
     1.640    27.859     0.200
     1.656    28.562     0.200
     1.704    29.062     0.200
     1.769    29.758     0.200
     1.803    30.656     0.200
     1.857    31.758     0.200
     1.861    31.062     0.200
     1.919    31.758     0.200
     2.064    32.461     0.200
     2.137    35.758     0.200
     2.154    35.156     0.200
     2.442    40.312     0.200
     2.658    42.359     0.200
     2.817    44.961     0.200
     2.817    44.758     0.200
     2.862    46.062     0.200
     2.839    45.961     0.200
     2.872    45.133     0.200
     2.914    46.961     0.200
     2.914    46.859     0.200
     3.014    48.258     0.200
     3.012    49.062     0.200
     3.111    50.461     0.200
     3.098    49.258     0.200
     3.155    49.258     0.200
     3.116    49.156     0.200
     3.124    49.961     0.200
     3.187    49.656     0.200
     3.204    49.961     0.200
     3.309    52.961     0.200
     3.296    51.859     0.200
     3.319    51.562     0.200
     3.310    53.062     0.200
     3.381    53.258     0.200
     3.385    53.359     0.200
     3.385    53.359     0.200
     3.472    55.758     0.200
     3.465    53.656     0.200
     3.468    54.562     0.200
     3.512    55.258     0.200
     3.673    58.359     0.200
     3.755    58.461     0.200
     3.737    58.062     0.200
     3.745    58.062     0.200
     3.766    58.562     0.200
     3.794    59.758     0.200
     3.805    58.758     0.200
     3.805    58.859     0.200
     3.844    59.461     0.200
     3.944    62.031     0.200
     3.928    60.859     0.200
     3.946    61.258     0.200
     3.946    61.258     0.200
     3.967    62.656     0.200
     4.015    63.062     0.200
     4.057    62.117     0.200
     4.084    63.062     0.200
     4.089    61.258     0.200
     4.123    62.961     0.200
     4.160    63.562     0.200
     4.270    64.898     0.200
     4.270    65.062     0.200
     4.357    65.859     0.200
     4.391    65.758     0.200
     4.412    67.562     0.200
     4.498    68.562     0.200
     4.498    68.461     0.200
     4.536    69.156     0.200
     4.536    69.031     0.200
     4.686    69.156     0.200
     4.686    69.258     0.200
     4.718    71.359     0.200
     4.821    71.641     0.200
     4.867    72.461     0.200
     4.838    72.758     0.200
     4.877    72.758     0.200
     4.864    73.258     0.200
     4.942    74.758     0.200
     4.942    74.648     0.200
     4.955    74.797     0.200
     5.010    74.195     0.200
     5.022    74.562     0.200
     5.022    73.859     0.200
     5.017    75.930     0.200
     5.027    75.859     0.200
     5.087    73.859     0.200
     5.119    75.258     0.200
     5.229    80.062     0.200
     5.295    78.258     0.200
     5.320    78.578     0.200
     5.314    79.461     0.200
     5.368    80.156     0.200
     5.439    81.891     0.200
     5.489    81.695     0.200
     5.510    80.461     0.200
     5.582    81.820     0.200
     5.670    84.062     0.200
     5.655    83.992     0.200
     5.755    85.156     0.200
     5.757    85.461     0.200
     5.851    87.859     0.200
     5.819    86.562     0.200
     5.832    85.469     0.200
     5.872    87.758     0.200
     6.018    88.625     0.200
     6.019    90.156     0.200
     6.027    89.258     0.200
     6.081    90.242     0.200
     6.101    89.562     0.200
     6.097    89.859     0.200
     6.171    90.633     0.200
     6.193    91.062     0.200
     6.202    89.977     0.200
     6.245    92.195     0.200
     6.239    91.461     0.200
     6.281    91.750     0.200
     6.281    91.688     0.200
     6.311    92.156     0.200
     6.269    93.367     0.200
     6.301    92.656     0.200
     6.301    93.156     0.200
     6.356    93.258     0.200
     6.302    93.562     0.200
     6.302    94.062     0.200
     6.326    94.156     0.200
     6.347    92.758     0.200
     6.478    95.477     0.200
     6.491    95.156     0.200
     6.615    97.734     0.200
     6.616    93.562     0.200
     6.655    97.469     0.200
     6.816    99.961     0.200
     6.789    99.562     0.200
     6.797   100.008     0.200
     6.834    99.852     0.200
     6.876   102.062     0.200
     6.865   101.156     0.200
     6.983   100.758     0.200
     6.950   100.656     0.200
     7.004   100.156     0.200
     6.962   102.141     0.200
     6.962   102.359     0.200
     7.062   102.461     0.200
     7.109   103.992     0.200
     7.198   103.812     0.200
     7.198   103.547     0.200
     7.193   104.656     0.200
     7.273   104.461     0.200
     7.259   105.359     0.200
     7.263   106.961     0.200
     7.338   106.859     0.200
     7.327   109.484     0.200
     7.372   107.062     0.200
     7.357   106.961     0.200
     7.491   107.758     0.200
     7.621   112.562     0.200
     7.719   112.664     0.200
     7.726   112.461     0.200
     7.788   113.461     0.200
     7.973   112.562     0.200
     7.980   114.758     0.200
     8.050   113.062     0.200
     8.065   115.828     0.200
     8.065   116.758     0.200
     8.075   115.969     0.200
     8.301   119.859     0.200
     8.342   118.258     0.200
     8.319   122.961     0.200
     8.395   118.258     0.200
     8.486   120.562     0.200
     8.579   121.156     0.200
     8.701   125.562     0.200
     8.718   123.258     0.200
     8.922   131.148     0.200
     8.922   131.258     0.200
     8.941   132.062     0.200
     9.065   130.258     0.200
     9.311   130.461     0.200
     9.508   133.859     0.200
     9.489   134.461     0.200
     9.489   134.617     0.200
     9.611   134.859     0.200
     9.676   135.062     0.200
     9.713   136.562     0.200
     9.658   140.680     0.200
     9.885   138.156     0.200
    10.153   146.242     0.200
    10.598   150.758     0.200
    11.089   158.359     0.200
     0.960    17.789     0.200
     0.983    19.289     0.200
     0.946    17.090     0.200
     0.996    18.988     0.200
     0.956    17.188     0.200
     1.062    18.988     0.200
     1.180    20.988     0.200
     1.110    19.289     0.200
     1.158    19.988     0.200
     1.183    20.789     0.200
     1.243    21.891     0.200
     1.131    19.688     0.200
     1.205    20.488     0.200
     1.263    22.289     0.200
     1.157    20.090     0.200
     1.244    21.590     0.200
     1.415    24.188     0.200
     1.381    23.590     0.200
     1.384    23.789     0.200
     1.376    23.188     0.200
     1.495    25.590     0.200
     1.449    23.988     0.200
     1.538    26.391     0.200
     1.459    24.289     0.200
     1.502    24.891     0.200
     1.623    26.891     0.200
     1.621    26.891     0.200
     1.566    25.289     0.200
     1.616    26.188     0.200
     1.601    26.391     0.200
     1.625    26.289     0.200
     1.638    26.391     0.200
     1.783    29.289     0.200
     1.709    27.391     0.200
     1.705    27.391     0.200
     1.763    28.188     0.200
     1.878    31.688     0.200
     1.768    28.789     0.200
     1.840    29.988     0.200
     1.931    31.590     0.200
     2.100    34.688     0.200
     2.165    35.289     0.200
     2.198    35.391     0.200
     2.081    33.688     0.200
     2.314    35.891     0.200
     2.269    36.789     0.200
     2.411    38.391     0.200
     2.424    37.789     0.200
     2.342    37.391     0.200
     2.510    39.090     0.200
     2.646    40.789     0.200
     2.543    40.590     0.200
     2.575    40.289     0.200
     2.628    41.391     0.200
     2.628    41.391     0.200
     2.645    41.891     0.200
     2.777    43.688     0.200
     2.754    41.980     0.200
     2.910    44.590     0.200
     2.808    44.188     0.200
     2.984    45.488     0.200
     2.934    45.988     0.200
     3.076    48.391     0.200
     3.017    47.590     0.200
     3.170    48.891     0.200
     3.059    48.289     0.200
     3.099    47.859     0.200
     3.170    49.188     0.200
     3.316    50.488     0.200
     3.190    49.590     0.200
     3.190    49.590     0.200
     3.283    49.391     0.200
     3.507    53.090     0.200
     3.530    53.891     0.200
     3.474    53.688     0.200
     3.629    54.438     0.200
     3.738    56.391     0.200
     3.786    57.391     0.200
     3.786    58.488     0.200
     3.769    56.789     0.200
     3.838    58.469     0.200
     4.023    60.090     0.200
     3.938    58.590     0.200
     3.971    60.688     0.200
     4.111    63.090     0.200
     4.104    61.590     0.200
     4.129    62.688     0.200
     4.254    63.590     0.200
     4.121    61.668     0.200
     4.177    62.688     0.200
     4.212    61.820     0.200
     4.246    63.488     0.200
     4.246    62.391     0.200
     4.387    64.988     0.200
     4.389    63.090     0.200
     4.360    63.488     0.200
     4.362    63.770     0.200
     4.345    65.090     0.200
     4.567    67.270     0.200
     4.536    70.410     0.200
     4.556    68.188     0.200
     4.702    69.109     0.200
     4.745    69.090     0.200
     4.628    70.590     0.200
     4.816    70.328     0.200
     4.782    68.688     0.200
     4.785    71.391     0.200
     4.982    72.477     0.200
     5.089    75.289     0.200
     5.119    73.590     0.200
     5.223    76.590     0.200
     5.111    74.551     0.200
     5.225    76.391     0.200
     5.266    78.051     0.200
     5.266    78.188     0.200
     5.361    77.828     0.200
     5.473    79.074     0.200
     5.381    78.488     0.200
     5.642    80.891     0.200
     5.639    81.289     0.200
     5.547    82.391     0.200
     5.624    83.980     0.200
     5.868    83.789     0.200
     5.750    85.391     0.200
     5.750    84.891     0.200
     5.800    85.391     0.200
     5.821    86.270     0.200
     6.036    86.938     0.200
     6.036    86.984     0.200
     6.055    87.535     0.200
     5.973    86.891     0.200
     5.983    88.188     0.200
     5.988    88.789     0.200
     6.136    88.078     0.200
     6.219    89.301     0.200
     6.156    90.918     0.200
     6.279    89.977     0.200
     6.396    91.336     0.200
     6.287    90.688     0.200
     6.450    94.391     0.200
     6.470    93.570     0.200
     6.514    93.789     0.200
     6.390    93.188     0.200
     6.390    92.688     0.200
     6.397    93.820     0.200
     6.553    93.590     0.200
     6.677    96.688     0.200
     6.848    98.715     0.200
     6.729    97.469     0.200
     6.729    96.988     0.200
     6.789    97.367     0.200
     6.940   100.988     0.200
     7.001   101.789     0.200
     6.942   100.688     0.200
     7.107   102.258     0.200
     7.107   101.188     0.200
     7.217   104.289     0.200
     7.404   105.617     0.200
     7.375   109.391     0.200
     7.356   106.289     0.200
     7.438   106.891     0.200
     7.571   109.590     0.200
     7.587   111.188     0.200
     7.946   117.465     0.200
     7.959   114.789     0.200
     8.062   120.988     0.200
     8.186   119.398     0.200
     8.186   120.434     0.200
     8.384   123.891     0.200
     8.681   120.391     0.200
     8.810   128.930     0.200
     9.064   125.789     0.200
     9.074   131.090     0.200
     9.800   135.891     0.200
     9.700   135.816     0.200
    10.066   138.988     0.200
    10.166   140.488     0.200
    10.186   140.289     0.200
    12.783   178.090     0.200
    17.965   246.688     0.200
    19.377   264.297     0.200
     1.032    18.875     0.200
     0.958    17.375     0.200
     1.045    19.277     0.200
     1.116    20.375     0.200
     1.032    18.578     0.200
     1.045    18.578     0.200
     1.099    19.477     0.200
     1.216    20.875     0.200
     1.248    21.078     0.200
     1.309    22.477     0.200
     1.341    22.277     0.200
     1.524    25.277     0.200
     1.535    25.777     0.200
     1.599    26.477     0.200
     1.856    31.277     0.200
     2.059    33.977     0.200
     2.339    37.578     0.200
     2.488    39.875     0.200
     2.576    40.578     0.200
     2.569    40.578     0.200
     2.748    43.078     0.200
     2.779    43.277     0.200
     2.826    44.176     0.200
     2.863    45.375     0.200
     2.965    45.875     0.200
     3.197    49.578     0.200
     3.331    51.578     0.200
     3.433    53.176     0.200
     3.409    52.578     0.200
     3.455    52.875     0.200
     3.455    52.875     0.200
     3.651    56.676     0.200
     3.654    55.477     0.200
     3.669    56.977     0.200
     3.934    60.277     0.200
     3.923    60.227     0.200
     3.995    60.477     0.200
     4.101    61.977     0.200
     4.127    62.477     0.200
     4.127    62.578     0.200
     4.127    61.977     0.200
     4.199    61.457     0.200
     4.175    63.375     0.200
     4.255    65.375     0.200
     4.344    67.875     0.200
     4.383    64.875     0.200
     4.407    63.777     0.200
     4.476    64.578     0.200
     4.394    66.477     0.200
     4.408    66.676     0.200
     4.419    66.477     0.200
     4.442    65.277     0.200
     4.444    66.477     0.200
     4.669    69.578     0.200
     4.756    70.578     0.200
     4.757    70.578     0.200
     4.787    71.875     0.200
     4.815    72.477     0.200
     5.027    74.875     0.200
     5.056    73.867     0.200
     5.072    74.777     0.200
     5.072    74.977     0.200
     5.165    75.777     0.200
     5.183    75.531     0.200
     5.145    76.176     0.200
     5.182    75.578     0.200
     5.182    75.875     0.200
     5.166    77.176     0.200
     5.166    76.777     0.200
     5.213    76.477     0.200
     5.233    78.078     0.200
     5.231    78.316     0.200
     5.311    77.523     0.200
     5.247    78.277     0.200
     5.247    78.176     0.200
     5.401    81.375     0.200
     5.402    79.977     0.200
     5.492    80.578     0.200
     5.572    83.676     0.200
     5.601    83.777     0.200
     5.691    82.441     0.200
     5.673    83.977     0.200
     5.739    83.078     0.200
     5.704    84.676     0.200
     5.728    84.977     0.200
     5.800    84.293     0.200
     5.753    85.875     0.200
     5.753    85.176     0.200
     5.879    86.176     0.200
     5.882    87.078     0.200
     5.889    87.176     0.200
     5.889    86.977     0.200
     5.900    87.578     0.200
     6.001    87.176     0.200
     5.985    87.277     0.200
     5.985    87.977     0.200
     5.966    87.375     0.200
     6.035    88.375     0.200
     6.051    89.277     0.200
     6.085    89.676     0.200
     6.107    90.176     0.200
     6.147    90.477     0.200
     6.207    90.078     0.200
     6.160    90.676     0.200
     6.205    89.777     0.200
     6.162    89.875     0.200
     6.208    90.578     0.200
     6.286    92.578     0.200
     6.293    92.777     0.200
     6.326    91.477     0.200
     6.335    92.777     0.200
     6.340    92.375     0.200
     6.419    93.297     0.200
     6.410    93.008     0.200
     6.419    92.699     0.200
     6.472    92.676     0.200
     6.502    94.660     0.200
     6.523    95.051     0.200
     6.530    94.594     0.200
     6.542    94.477     0.200
     6.495    94.375     0.200
     6.527    94.875     0.200
     6.667    96.809     0.200
     6.691    97.516     0.200
     6.621    95.477     0.200
     6.710    96.676     0.200
     6.668    97.777     0.200
     6.720    97.875     0.200
     6.731    96.977     0.200
     6.799    98.477     0.200
     6.909   100.277     0.200
     6.982    98.875     0.200
     7.085   103.305     0.200
     7.092   101.477     0.200
     7.092   102.777     0.200
     7.092   101.078     0.200
     7.119   102.477     0.200
     7.092   102.777     0.200
     7.120   102.977     0.200
     7.226   102.277     0.200
     7.344   105.777     0.200
     7.338   107.977     0.200
     7.457   106.078     0.200
     7.457   106.352     0.200
     7.577   106.777     0.200
     7.575   111.926     0.200
     7.597   106.578     0.200
     7.628   109.578     0.200
     7.754   110.375     0.200
     7.754   110.477     0.200
     7.792   109.777     0.200
     7.827   110.543     0.200
     7.827   112.078     0.200
     7.885   111.176     0.200
     7.808   112.875     0.200
     7.873   111.277     0.200
     7.835   113.578     0.200
     7.901   114.578     0.200
     8.105   118.176     0.200
     8.243   119.176     0.200
     8.375   119.875     0.200
     8.375   119.477     0.200
     8.357   121.176     0.200
     8.424   119.277     0.200
     8.441   121.477     0.200
     8.511   120.375     0.200
     8.546   120.578     0.200
     8.554   121.977     0.200
     8.493   124.469     0.200
     8.493   123.375     0.200
     8.540   123.578     0.200
     8.562   126.375     0.200
     8.562   126.477     0.200
     8.594   120.777     0.200
     8.604   122.578     0.200
     8.667   121.777     0.200
     8.779   127.676     0.200
     8.870   123.277     0.200
     8.836   128.875     0.200
     8.872   126.477     0.200
     8.872   127.078     0.200
     9.020   126.676     0.200
     8.998   127.676     0.200
     9.083   127.875     0.200
     9.092   131.977     0.200
     9.124   129.777     0.200
     9.148   131.176     0.200
     9.170   133.375     0.200
     9.250   129.477     0.200
     9.337   134.477     0.200
     9.436   133.777     0.200
     9.547   134.078     0.200
     9.565   134.207     0.200
     9.904   138.676     0.200
     9.828   140.676     0.200
     9.925   137.277     0.200
     9.963   140.477     0.200
    10.054   140.277     0.200
    10.078   140.875     0.200
    10.191   142.078     0.200
    10.232   142.977     0.200
    10.269   143.375     0.200
    10.301   143.578     0.200
    10.485   146.176     0.200
    10.786   150.477     0.200
    10.920   151.977     0.200
    11.415   158.977     0.200
    11.672   162.477     0.200
    13.156   185.727     0.200
    13.808   196.977     0.200
    14.992   212.402     0.200
    15.002   207.477     0.200
    18.368   253.277     0.200
    18.530   255.277     0.200
    20.166   274.352     0.200
    20.500   278.477     0.200
     0.941    17.672     0.200
     0.953    17.375     0.200
     1.035    18.672     0.200
     1.028    18.375     0.200
     1.119    20.172     0.200
     1.093    19.273     0.200
     1.194    21.570     0.200
     1.184    20.477     0.200
     1.242    20.875     0.200
     1.278    21.977     0.200
     1.295    21.977     0.200
     1.361    22.977     0.200
     1.380    23.875     0.200
     1.350    22.477     0.200
     1.367    22.875     0.200
     1.447    24.875     0.200
     1.438    24.172     0.200
     1.541    25.977     0.200
     1.518    25.273     0.200
     1.572    26.773     0.200
     1.594    26.375     0.200
     1.872    30.977     0.200
     2.019    33.875     0.200
     2.034    33.672     0.200
     2.062    34.477     0.200
     3.653    56.570     0.200
     3.649    55.477     0.200
     3.670    57.773     0.200
     3.936    60.773     0.200
     3.990    60.672     0.200
     4.096    62.070     0.200
     4.130    62.375     0.200
     4.205    61.336     0.200
     4.252    65.070     0.200
     4.405    66.672     0.200
     4.419    66.672     0.200
     4.444    65.172     0.200
     4.446    67.070     0.200
     4.787    72.375     0.200
     5.062    74.227     0.200
     5.066    74.875     0.200
     5.161    76.875     0.200
     5.243    78.273     0.200
     5.396    81.375     0.200
     5.489    81.672     0.200
     5.568    83.773     0.200
     5.698    82.289     0.200
     5.668    83.875     0.200
     5.700    85.070     0.200
     5.745    82.367     0.200
     5.723    85.375     0.200
     5.877    87.070     0.200
     5.883    86.875     0.200
     5.896    87.773     0.200
     6.032    88.273     0.200
     6.047    89.477     0.200
     6.102    90.273     0.200
     6.142    90.570     0.200
     6.155    91.070     0.200
     6.159    89.570     0.200
     6.288    93.070     0.200
     6.322    91.875     0.200
     6.336    93.070     0.200
     6.416    92.906     0.200
     6.425    92.953     0.200
     6.476    91.672     0.200
     6.508    94.789     0.200
     6.521    94.875     0.200
     6.616    95.477     0.200
     6.663    97.875     0.200
     6.716    97.977     0.200
     6.727    97.875     0.200
     6.739    98.672     0.200
     6.986    98.570     0.200
     7.091   103.133     0.200
     7.115   102.977     0.200
     7.133   103.477     0.200
     7.131   104.070     0.200
     7.231   102.273     0.200
     7.282   105.875     0.200
     7.602   107.273     0.200
     7.760   110.375     0.200
     7.796   109.773     0.200
     7.890   112.070     0.200
     8.552   120.477     0.200
     8.876   124.570     0.200
     9.089   127.570     0.200
     9.256   129.977     0.200
     9.909   138.570     0.200
     9.931   139.172     0.200
    10.196   142.070     0.200
    10.275   143.570     0.200
    11.421   159.477     0.200
     1.424    25.133     0.200
     1.423    25.633     0.200
     1.413    25.336     0.200
     1.478    26.734     0.200
     1.528    28.234     0.200
     1.528    26.633     0.200
     1.527    26.336     0.200
     1.563    27.430     0.200
     1.614    27.930     0.200
     1.607    27.430     0.200
     1.625    28.734     0.200
     1.610    27.633     0.200
     1.644    28.836     0.200
     1.627    27.633     0.200
     1.678    29.031     0.200
     1.734    29.133     0.200
     1.774    30.633     0.200
     1.889    31.234     0.200
     2.020    33.531     0.200
     2.073    34.031     0.200
     2.124    36.031     0.200
     2.167    35.430     0.200
     2.228    36.336     0.200
     2.379    39.336     0.200
     2.800    44.734     0.200
     2.820    45.031     0.200
     2.929    47.086     0.200
     2.998    47.633     0.200
     3.077    48.930     0.200
     3.148    49.633     0.200
     3.236    50.531     0.200
     3.273    51.531     0.200
     3.278    51.430     0.200
     3.296    51.836     0.200
     3.365    52.633     0.200
     3.365    52.633     0.200
     3.366    53.031     0.200
     3.514    55.234     0.200
     3.740    57.734     0.200
     3.907    60.531     0.200
     3.927    61.234     0.200
     3.927    61.234     0.200
     3.964    60.766     0.200
     4.004    62.336     0.200
     4.004    61.930     0.200
     4.074    64.336     0.200
     4.173    63.336     0.200
     4.348    66.633     0.200
     4.374    66.930     0.200
     4.440    67.633     0.200
     4.469    70.031     0.200
     4.469    66.930     0.200
     4.486    67.234     0.200
     4.807    72.336     0.200
     4.838    71.922     0.200
     4.887    72.336     0.200
     5.004    74.086     0.200
     5.030    75.742     0.200
     5.343    80.406     0.200
     5.420    82.734     0.200
     5.596    81.742     0.200
     5.880    87.133     0.200
     5.972    88.734     0.200
     6.107    92.016     0.200
     6.125    91.367     0.200
     6.188    90.820     0.200
     6.270    92.039     0.200
     6.294    91.391     0.200
     6.340    93.430     0.200
     6.385    93.531     0.200
     6.503    96.656     0.200
     6.641    99.414     0.200
     7.510   107.930     0.200
     8.002   115.031     0.200
     8.370   118.930     0.200
     8.607   122.430     0.200
     8.746   123.836     0.200
     9.426   133.734     0.200
     9.706   137.336     0.200
     1.256    22.438     0.200
     1.169    20.638     0.200
     1.260    21.938     0.200
     1.313    22.738     0.200
     1.344    23.038     0.200
     1.392    24.438     0.200
     1.337    23.138     0.200
     1.503    25.538     0.200
     1.671    27.938     0.200
     1.757    28.838     0.200
     1.826    30.138     0.200
     1.972    31.138     0.200
     1.985    31.268     0.200
     1.985    34.038     0.200
     2.358    37.938     0.200
     2.384    38.538     0.200
     2.664    43.348     0.200
     2.710    42.308     0.200
     2.649    42.838     0.200
     2.712    43.338     0.200
     2.795    44.838     0.200
     2.837    44.938     0.200
     2.851    45.538     0.200
     2.893    45.938     0.200
     2.885    45.538     0.200
     2.934    46.238     0.200
     2.934    46.238     0.200
     3.158    50.738     0.200
     3.215    51.338     0.200
     3.296    51.838     0.200
     3.426    52.638     0.200
     3.474    54.938     0.200
     3.488    54.738     0.200
     3.488    54.738     0.200
     3.564    56.438     0.200
     3.627    55.338     0.200
     3.737    57.318     0.200
     3.921    58.238     0.200
     3.948    59.438     0.200
     3.904    60.838     0.200
     3.973    60.138     0.200
     3.990    60.638     0.200
     4.040    61.038     0.200
     4.046    61.138     0.200
     4.126    61.058     0.200
     4.210    62.838     0.200
     4.141    64.288     0.200
     4.326    65.738     0.200
     4.366    65.638     0.200
     4.406    67.038     0.200
     4.428    67.618     0.200
     4.433    67.138     0.200
     4.447    67.038     0.200
     4.522    68.548     0.200
     4.523    69.138     0.200
     4.549    72.038     0.200
     4.596    67.438     0.200
     4.669    69.338     0.200
     4.700    71.238     0.200
     4.786    71.438     0.200
     4.668    71.438     0.200
     4.761    70.308     0.200
     4.709    71.238     0.200
     4.806    71.238     0.200
     4.913    72.638     0.200
     4.923    75.038     0.200
     5.077    75.938     0.200
     5.285    77.238     0.200
     5.373    78.838     0.200
     5.400    79.338     0.200
     5.396    80.438     0.200
     5.444    80.438     0.200
     5.517    82.138     0.200
     5.545    83.038     0.200
     5.729    86.338     0.200
     6.012    88.238     0.200
     6.012    88.398     0.200
     6.024    88.138     0.200
     5.983    89.738     0.200
     6.060    88.338     0.200
     6.095    89.538     0.200
     6.125    89.338     0.200
     6.166    90.138     0.200
     6.071    90.438     0.200
     6.260    92.238     0.200
     6.175    92.138     0.200
     6.241    93.038     0.200
     6.248    92.138     0.200
     6.502    95.038     0.200
     6.649    97.438     0.200
     6.682    98.038     0.200
     6.706    98.038     0.200
     6.643    98.138     0.200
     6.895    99.738     0.200
     7.067   101.413     0.200
     7.052   103.338     0.200
     7.225   102.738     0.200
     7.245   102.638     0.200
     7.363   105.338     0.200
     7.496   108.738     0.200
     7.480   109.348     0.200
     7.556   108.938     0.200
     7.734   114.813     0.200
     8.049   114.938     0.200
     8.177   115.738     0.200
     8.349   119.438     0.200
     8.479   119.838     0.200
     8.601   121.538     0.200
     8.685   122.438     0.200
     8.860   123.338     0.200
     9.534   135.138     0.200
     9.550   134.138     0.200
     9.670   136.238     0.200
     9.826   137.338     0.200
     9.844   139.638     0.200
     9.916   138.838     0.200
     9.941   139.838     0.200
    10.138   142.638     0.200
    20.635   281.288     0.200
     1.426    24.588     0.200
     1.455    24.888     0.200
     1.501    27.488     0.200
     1.494    26.988     0.200
     1.469    25.288     0.200
     1.516    25.888     0.200
     1.647    28.988     0.200
     1.646    27.088     0.200
     1.739    28.888     0.200
     1.766    28.988     0.200
     1.874    30.888     0.200
     1.903    31.188     0.200
     1.910    30.888     0.200
     1.922    31.488     0.200
     2.118    34.388     0.200
     2.242    36.288     0.200
     2.265    36.588     0.200
     2.267    37.188     0.200
     2.440    39.388     0.200
     2.486    39.688     0.200
     2.533    40.588     0.200
     2.540    40.688     0.200
     2.540    40.688     0.200
     2.595    41.588     0.200
     2.627    42.488     0.200
     2.622    41.588     0.200
     2.671    42.988     0.200
     2.679    43.288     0.200
     2.701    42.388     0.200
     2.702    42.588     0.200
     2.721    43.788     0.200
     2.725    43.488     0.200
     2.735    44.088     0.200
     2.745    43.388     0.200
     2.771    44.088     0.200
     2.810    44.588     0.200
     2.817    44.788     0.200
     2.817    44.788     0.200
     2.837    44.688     0.200
     2.845    45.138     0.200
     2.879    46.088     0.200
     2.986    47.688     0.200
     2.992    47.488     0.200
     3.087    49.388     0.200
     3.099    49.188     0.200
     3.145    49.288     0.200
     3.183    50.288     0.200
     3.254    51.188     0.200
     3.323    51.088     0.200
     3.358    52.788     0.200
     3.365    52.988     0.200
     3.372    52.988     0.200
     3.372    52.988     0.200
     3.456    54.588     0.200
     3.603    55.388     0.200
     3.709    57.088     0.200
     3.802    56.788     0.200
     3.915    58.888     0.200
     3.920    59.688     0.200
     3.929    59.588     0.200
     3.934    60.188     0.200
     3.909    60.288     0.200
     4.012    59.688     0.200
     4.163    64.788     0.200
     4.200    63.288     0.200
     4.242    64.988     0.200
     4.293    66.788     0.200
     4.306    63.888     0.200
     4.299    65.588     0.200
     4.331    66.688     0.200
     4.350    66.188     0.200
     4.423    68.588     0.200
     4.571    67.188     0.200
     4.571    68.168     0.200
     4.540    69.288     0.200
     4.642    68.788     0.200
     4.657    69.218     0.200
     4.665    68.988     0.200
     4.696    69.088     0.200
     4.744    71.188     0.200
     4.764    69.788     0.200
     4.785    71.083     0.200
     4.804    70.288     0.200
     4.915    72.867     0.200
     5.064    76.288     0.200
     5.281    79.588     0.200
     5.303    77.918     0.200
     5.345    78.571     0.200
     5.404    79.511     0.200
     5.536    82.188     0.200
     5.901    88.688     0.200
     5.930    88.588     0.200
     6.012    87.143     0.200
     6.027    88.313     0.200
     5.991    89.888     0.200
     6.036    89.354     0.200
     6.119    90.132     0.200
     6.161    90.181     0.200
     6.261    89.688     0.200
     6.289    91.404     0.200
     6.394    94.788     0.200
     6.533    95.680     0.200
     6.565    97.488     0.200
     6.723    99.044     0.200
     6.749    96.488     0.200
     6.808    97.388     0.200
     6.989   103.388     0.200
     7.305   105.188     0.200
     7.325   105.188     0.200
     7.355   105.388     0.200
     7.358   107.688     0.200
     7.645   109.288     0.200
     8.249   116.988     0.200
     8.536   120.988     0.200
     8.734   124.388     0.200
     8.918   126.388     0.200
     9.629   135.388     0.200
     9.732   137.188     0.200
     9.904   139.488     0.200
     9.900   139.388     0.200
     9.995   140.388     0.200
    10.221   143.688     0.200
    10.640   149.988     0.200
     1.448    25.727     0.200
     1.520    27.027     0.200
     1.656    30.347     0.200
     1.656    30.127     0.200
     1.588    29.367     0.200
     1.638    28.427     0.200
     1.674    30.377     0.200
     1.759    31.727     0.200
     1.774    30.827     0.200
     1.764    31.927     0.200
     1.764    31.237     0.200
     1.741    30.027     0.200
     1.867    32.627     0.200
     1.845    31.527     0.200
     1.877    32.027     0.200
     1.975    34.427     0.200
     2.152    37.287     0.200
     2.391    40.527     0.200
     2.426    41.227     0.200
     2.426    40.027     0.200
     2.607    42.627     0.200
     2.648    43.327     0.200
     2.648    43.607     0.200
     2.648    42.327     0.200
     2.887    45.717     0.200
     2.964    48.827     0.200
     2.927    47.827     0.200
     2.956    47.527     0.200
     2.956    47.727     0.200
     3.003    47.487     0.200
     3.081    49.327     0.200
     3.147    50.827     0.200
     3.170    50.927     0.200
     3.170    51.127     0.200
     3.216    51.227     0.200
     3.258    53.627     0.200
     3.254    52.327     0.200
     3.306    53.427     0.200
     3.317    53.527     0.200
     3.317    53.027     0.200
     3.383    52.437     0.200
     3.398    53.407     0.200
     3.371    53.927     0.200
     3.418    54.827     0.200
     3.443    54.427     0.200
     3.443    54.727     0.200
     3.443    55.027     0.200
     3.443    54.657     0.200
     3.523    57.327     0.200
     3.511    56.727     0.200
     3.559    57.127     0.200
     3.559    57.527     0.200
     3.721    61.707     0.200
     3.698    58.127     0.200
     3.698    57.827     0.200
     3.698    57.037     0.200
     3.835    61.427     0.200
     3.843    62.727     0.200
     3.780    60.427     0.200
     3.795    59.277     0.200
     3.923    61.827     0.200
     3.922    62.027     0.200
     3.922    60.667     0.200
     3.925    62.527     0.200
     4.001    64.127     0.200
     3.969    61.827     0.200
     4.021    64.427     0.200
     3.988    63.527     0.200
     4.073    64.027     0.200
     4.043    64.427     0.200
     4.052    62.927     0.200
     4.159    63.127     0.200
     4.134    63.827     0.200
     4.134    63.227     0.200
     4.149    64.427     0.200
     4.149    64.187     0.200
     4.218    68.127     0.200
     4.215    68.827     0.200
     4.240    65.627     0.200
     4.240    65.827     0.200
     4.262    66.327     0.200
     4.328    66.447     0.200
     4.318    67.127     0.200
     4.449    67.407     0.200
     4.407    68.627     0.200
     4.419    68.027     0.200
     4.448    69.127     0.200
     4.588    68.127     0.200
     4.574    69.427     0.200
     4.529    69.727     0.200
     4.611    68.947     0.200
     4.659    70.327     0.200
     4.659    70.827     0.200
     4.682    73.027     0.200
     4.718    71.927     0.200
     4.718    71.807     0.200
     4.718    71.627     0.200
     4.753    71.927     0.200
     4.740    72.817     0.200
     4.744    73.027     0.200
     4.796    74.527     0.200
     4.808    74.727     0.200
     4.808    74.137     0.200
     4.873    72.847     0.200
     4.870    74.617     0.200
     4.922    75.527     0.200
     4.983    76.427     0.200
     5.006    75.727     0.200
     5.033    75.227     0.200
     5.038    76.327     0.200
     5.068    77.227     0.200
     5.095    77.427     0.200
     5.184    79.037     0.200
     5.244    80.127     0.200
     5.275    79.927     0.200
     5.337    79.112     0.200
     5.326    79.327     0.200
     5.326    79.227     0.200
     5.428    80.927     0.200
     5.361    80.827     0.200
     5.456    81.167     0.200
     5.449    79.927     0.200
     5.434    82.827     0.200
     5.497    81.047     0.200
     5.453    84.497     0.200
     5.532    83.008     0.200
     5.486    83.327     0.200
     5.572    82.627     0.200
     5.542    82.827     0.200
     5.626    84.027     0.200
     5.658    85.727     0.200
     5.718    87.327     0.200
     5.735    85.827     0.200
     5.735    85.627     0.200
     5.846    86.727     0.200
     5.840    86.062     0.200
     5.826    87.657     0.200
     5.826    87.527     0.200
     5.865    89.127     0.200
     5.946    89.127     0.200
     5.900    87.027     0.200
     5.909    89.727     0.200
     5.941    90.827     0.200
     6.011    91.092     0.200
     5.988    89.327     0.200
     6.011    90.927     0.200
     6.083    89.192     0.200
     6.045    91.457     0.200
     6.045    91.327     0.200
     6.066    91.227     0.200
     6.175    89.827     0.200
     6.121    92.727     0.200
     6.128    92.527     0.200
     6.133    92.227     0.200
     6.153    92.827     0.200
     6.155    92.927     0.200
     6.249    93.327     0.200
     6.189    93.527     0.200
     6.193    91.427     0.200
     6.313    94.227     0.200
     6.313    93.917     0.200
     6.313    94.727     0.200
     6.349    94.927     0.200
     6.358    94.327     0.200
     6.370    95.527     0.200
     6.371    95.327     0.200
     6.447    96.527     0.200
     6.535   100.643     0.200
     6.489    96.527     0.200
     6.603    96.627     0.200
     6.514    96.527     0.200
     6.587    97.506     0.200
     6.632    97.327     0.200
     6.548    97.227     0.200
     6.617    99.795     0.200
     6.556    98.527     0.200
     6.568    99.227     0.200
     6.602    97.827     0.200
     6.590    97.827     0.200
     6.669    99.747     0.200
     6.605    98.327     0.200
     6.692    99.619     0.200
     6.688    98.227     0.200
     6.673    99.927     0.200
     6.757   101.157     0.200
     6.707    99.727     0.200
     6.723   100.007     0.200
     6.732   100.427     0.200
     6.778    98.731     0.200
     6.791   100.327     0.200
     6.815   100.827     0.200
     6.977   105.727     0.200
     6.895   102.727     0.200
     6.999   104.857     0.200
     6.999   106.827     0.200
     6.988   103.615     0.200
     6.937   102.827     0.200
     7.006   104.327     0.200
     7.112   106.155     0.200
     7.191   107.447     0.200
     7.117   104.127     0.200
     7.379   107.527     0.200
     7.379   107.827     0.200
     7.471   108.527     0.200
     7.385   109.027     0.200
     7.465   111.577     0.200
     7.441   111.027     0.200
     7.434   109.227     0.200
     7.629   112.427     0.200
     7.548   110.327     0.200
     7.601   114.027     0.200
     7.601   110.957     0.200
     7.591   111.727     0.200
     7.643   113.127     0.200
     7.709   110.797     0.200
     7.717   111.387     0.200
     7.717   111.373     0.200
     7.708   115.227     0.200
     7.813   115.027     0.200
     7.915   114.327     0.200
     7.888   115.227     0.200
     7.914   118.527     0.200
     7.947   115.327     0.200
     8.011   114.987     0.200
     8.011   114.827     0.200
     7.978   117.627     0.200
     7.979   115.927     0.200
     7.997   118.127     0.200
     8.083   118.827     0.200
     8.084   119.127     0.200
     8.210   118.847     0.200
     8.210   117.627     0.200
     8.202   121.527     0.200
     8.288   124.427     0.200
     8.386   119.927     0.200
     8.397   120.627     0.200
     8.328   122.527     0.200
     8.382   122.087     0.200
     8.382   121.927     0.200
     8.414   123.127     0.200
     8.411   124.527     0.200
     8.495   125.827     0.200
     8.565   124.627     0.200
     8.685   124.427     0.200
     8.659   126.527     0.200
     8.736   125.427     0.200
     8.807   126.827     0.200
     8.786   130.427     0.200
     8.786   127.127     0.200
     8.815   125.727     0.200
     8.796   128.827     0.200
     8.908   131.077     0.200
     8.865   129.027     0.200
     8.962   128.167     0.200
     8.965   132.027     0.200
     9.060   129.627     0.200
     8.983   130.927     0.200
     8.989   131.727     0.200
     8.991   130.727     0.200
     9.053   133.837     0.200
     9.082   132.027     0.200
     9.087   134.277     0.200
     9.087   133.027     0.200
     9.097   131.427     0.200
     9.224   132.527     0.200
     9.179   134.027     0.200
     9.256   136.127     0.200
     9.266   133.427     0.200
     9.355   134.527     0.200
     9.333   136.827     0.200
     9.401   138.027     0.200
     9.395   135.527     0.200
     9.405   135.427     0.200
     9.435   136.527     0.200
     9.438   136.427     0.200
     9.443   136.527     0.200
     9.462   137.127     0.200
     9.496   137.227     0.200
     9.496   136.807     0.200
     9.706   138.127     0.200
     9.709   141.437     0.200
     9.722   138.837     0.200
     9.686   141.427     0.200
     9.742   142.627     0.200
     9.753   142.177     0.200
     9.763   143.397     0.200
     9.772   140.420     0.200
     9.772   141.527     0.200
     9.772   140.187     0.200
     9.958   141.327     0.200
    10.024   142.327     0.200
    10.149   144.327     0.200
    10.221   145.827     0.200
    10.221   146.927     0.200
    10.265   146.027     0.200
    10.184   147.927     0.200
    10.224   146.327     0.200
    10.410   151.327     0.200
    10.410   150.487     0.200
    10.416   150.227     0.200
    10.722   156.627     0.200
    10.877   157.827     0.200
    11.790   170.327     0.200
    13.730   194.792     0.200
    13.730   194.797     0.200
    14.297   203.597     0.200
    14.297   205.397     0.200
    14.297   203.594     0.200
    14.498   203.531     0.200
    18.200   252.202     0.200
    18.522   258.452     0.200
    18.843   261.727     0.200
    18.995   262.702     0.200
    19.695   272.827     0.200
    19.715   272.490     0.200
    19.981   277.017     0.200
    20.060   277.997     0.200
    20.052   275.367     0.200
    20.124   276.587     0.200
    20.193   280.347     0.200
    20.272   278.637     0.200
    20.569   281.197     0.200
    20.569   281.027     0.200
    20.576   281.802     0.200
    20.630   283.327     0.200
    20.814   288.627     0.200
     1.460    27.110     0.200
     1.528    26.870     0.200
     1.675    30.021     0.200
     1.749    30.710     0.200
     1.886    33.410     0.200
     1.984    35.110     0.200
     2.426    41.610     0.200
     2.426    40.670     0.200
     2.661    42.790     0.200
     2.662    43.610     0.200
     2.662    42.660     0.200
     2.941    47.910     0.200
     2.941    47.210     0.200
     2.970    47.510     0.200
     2.970    47.311     0.200
     3.161    50.610     0.200
     3.184    51.010     0.200
     3.184    50.510     0.200
     3.268    52.410     0.200
     3.319    52.910     0.200
     3.331    53.311     0.200
     3.391    52.351     0.200
     3.385    54.010     0.200
     3.432    55.010     0.200
     3.457    54.910     0.200
     3.457    54.610     0.200
     3.457    55.110     0.200
     3.457    55.510     0.200
     3.573    57.311     0.200
     3.573    56.710     0.200
     3.710    59.210     0.200
     3.794    60.510     0.200
     3.934    60.910     0.200
     3.934    61.710     0.200
     3.939    62.510     0.200
     3.977    62.311     0.200
     4.002    63.510     0.200
     4.057    64.510     0.200
     4.166    65.610     0.200
     4.148    64.010     0.200
     4.161    65.811     0.200
     4.254    65.610     0.200
     4.276    66.410     0.200
     4.337    66.460     0.200
     4.326    67.311     0.200
     4.426    67.950     0.200
     4.427    68.410     0.200
     4.418    69.260     0.200
     4.458    68.490     0.200
     4.581    70.510     0.200
     4.651    70.210     0.200
     4.543    70.010     0.200
     4.668    71.910     0.200
     4.692    73.410     0.200
     4.732    72.010     0.200
     4.732    71.710     0.200
     4.752    73.430     0.200
     4.820    74.930     0.200
     4.880    75.210     0.200
     4.881    74.610     0.200
     4.935    74.960     0.200
     5.020    75.610     0.200
     5.047    75.910     0.200
     5.052    76.311     0.200
     5.190    78.800     0.200
     5.254    81.010     0.200
     5.280    79.510     0.200
     5.344    79.775     0.200
     5.339    79.311     0.200
     5.375    81.410     0.200
     5.440    82.710     0.200
     5.466    84.460     0.200
     5.506    81.372     0.200
     5.538    83.277     0.200
     5.726    87.811     0.200
     5.747    87.610     0.200
     5.747    87.420     0.200
     5.845    87.789     0.200
     5.914    87.311     0.200
     5.949    90.110     0.200
     6.017    92.034     0.200
     6.018    91.311     0.200
     6.053    91.610     0.200
     6.169    90.110     0.200
     6.080    91.710     0.200
     6.128    94.110     0.200
     6.134    92.910     0.200
     6.326    95.010     0.200
     6.378    95.811     0.200
     6.596    95.311     0.200
     6.624    96.010     0.200
     6.589    99.441     0.200
     6.563    98.610     0.200
     6.557    97.210     0.200
     6.621   100.036     0.200
     6.582    96.410     0.200
     6.693    97.785     0.200
     6.695   100.080     0.200
     6.787   100.617     0.200
     6.986   105.835     0.200
     6.972   101.210     0.200
     6.990   105.076     0.200
     7.114   107.327     0.200
     7.396   106.410     0.200
     7.464   107.710     0.200
     7.624   109.610     0.200
     7.724   110.860     0.200
     8.018   116.410     0.200
     8.002   117.710     0.200
     8.380   120.210     0.200
     8.394   120.610     0.200
     8.509   126.410     0.200
     8.806   126.311     0.200
     9.060   129.311     0.200
     9.101   134.630     0.200
     9.777   141.541     0.200
     9.777   141.410     0.200
    10.198   147.910     0.200
    20.744   283.686     0.200
     1.428    25.900     0.200
     1.428    25.291     0.200
     1.526    27.201     0.200
     1.584    29.301     0.200
     1.661    30.002     0.200
     1.667    29.912     0.200
     1.679    29.061     0.200
     1.761    32.061     0.200
     1.748    30.602     0.200
     1.884    32.400     0.200
     1.984    34.900     0.200
     2.673    43.230     0.200
     2.949    47.900     0.200
     2.949    47.502     0.200
     3.168    51.201     0.200
     3.194    51.102     0.200
     3.194    50.900     0.200
     3.276    52.701     0.200
     3.325    53.102     0.200
     3.338    53.801     0.200
     3.338    52.502     0.200
     3.404    52.490     0.200
     3.421    53.451     0.200
     3.394    54.102     0.200
     3.441    55.701     0.200
     3.464    55.801     0.200
     3.464    55.801     0.200
     3.583    57.201     0.200
     3.583    56.602     0.200
     3.714    59.002     0.200
     3.802    60.801     0.200
     3.947    62.502     0.200
     3.947    61.301     0.200
     3.949    62.900     0.200
     4.009    63.900     0.200
     4.065    64.602     0.200
     4.159    64.002     0.200
     4.265    66.201     0.200
     4.265    65.602     0.200
     4.349    66.752     0.200
     4.438    67.832     0.200
     4.422    69.271     0.200
     4.471    67.662     0.200
     4.594    71.701     0.200
     4.652    72.102     0.200
     4.681    70.502     0.200
     4.776    73.881     0.200
     4.743    71.900     0.200
     4.743    71.602     0.200
     4.756    73.521     0.200
     4.823    75.271     0.200
     4.893    75.201     0.200
     5.276    79.201     0.200
     5.351    78.602     0.200
     5.382    81.301     0.200
     5.437    81.701     0.200
     5.471    84.311     0.200
     5.518    81.320     0.200
     5.584    83.602     0.200
     5.663    85.900     0.200
     5.724    87.801     0.200
     5.751    87.721     0.200
     5.856    87.062     0.200
     5.837    86.900     0.200
     5.946    90.002     0.200
     6.003    89.602     0.200
     6.015    90.502     0.200
     6.052    91.301     0.200
     6.052    91.900     0.200
     6.125    91.602     0.200
     6.159    93.502     0.200
     6.193    92.801     0.200
     6.374    95.701     0.200
     6.452    97.002     0.200
     6.502    95.801     0.200
     6.598    94.701     0.200
     6.599    99.229     0.200
     6.560    98.602     0.200
     6.557    97.102     0.200
     6.593    98.602     0.200
     6.702    99.328     0.200
     6.708   100.225     0.200
     6.800    99.197     0.200
     6.790    99.801     0.200
     6.974   106.426     0.200
     7.467   106.502     0.200
     7.737   111.166     0.200
     7.838   114.801     0.200
     7.940   119.400     0.200
     8.031   115.400     0.200
     8.226   122.701     0.200
     8.518   126.201     0.200
     8.518   125.502     0.200
     8.814   124.900     0.200
     9.110   133.021     0.200
     9.110   134.002     0.200
     9.184   134.301     0.200
     9.742   138.002     0.200
     9.710   142.002     0.200
     9.773   143.193     0.200
     9.773   143.400     0.200
     9.766   143.602     0.200
     9.779   144.400     0.200
    10.027   141.002     0.200
    10.118   142.400     0.200
    10.206   148.102     0.200
    13.904   200.201     0.200
    19.964   274.201     0.200
    20.589   281.400     0.200
    20.650   283.102     0.200
    20.751   283.400     0.200
     1.409    24.977     0.200
     1.405    25.496     0.200
     1.402    24.988     0.200
     1.421    25.738     0.200
     1.517    27.508     0.200
     1.538    26.996     0.200
     1.544    26.738     0.200
     1.572    27.688     0.200
     1.620    28.117     0.200
     1.631    28.547     0.200
     1.622    28.309     0.200
     1.627    28.176     0.200
     1.646    28.379     0.200
     1.687    28.887     0.200
     1.719    29.656     0.200
     1.752    29.848     0.200
     1.750    29.742     0.200
     1.907    31.746     0.200
     1.925    32.469     0.200
     2.037    33.578     0.200
     2.069    33.828     0.200
     2.246    37.176     0.200
     2.285    37.188     0.200
     2.288    37.277     0.200
     2.323    37.105     0.200
     2.446    41.379     0.200
     2.446    41.277     0.200
     2.493    40.488     0.200
     2.603    42.617     0.200
     2.819    45.379     0.200
     2.819    44.676     0.200
     2.839    44.879     0.200
     2.839    45.477     0.200
     2.897    47.078     0.200
     2.897    47.246     0.200
     2.888    45.676     0.200
     2.934    47.207     0.200
     3.016    48.277     0.200
     3.016    48.078     0.200
     3.097    48.977     0.200
     3.167    49.777     0.200
     3.202    51.477     0.200
     3.255    50.879     0.200
     3.293    51.578     0.200
     3.293    51.777     0.200
     3.324    51.238     0.200
     3.297    51.676     0.200
     3.316    52.078     0.200
     3.385    53.879     0.200
     3.385    53.277     0.200
     3.385    53.387     0.200
     3.385    52.879     0.200
     3.384    53.879     0.200
     3.384    53.176     0.200
     3.524    55.379     0.200
     3.524    55.906     0.200
     3.658    56.578     0.200
     3.674    57.176     0.200
     3.758    59.176     0.200
     3.799    59.078     0.200
     3.841    59.168     0.200
     3.873    61.176     0.200
     3.875    60.379     0.200
     3.927    60.379     0.200
     3.947    60.977     0.200
     3.967    61.258     0.200
     4.021    62.277     0.200
     4.021    62.977     0.200
     4.073    61.676     0.200
     4.125    63.676     0.200
     4.160    63.777     0.200
     4.176    63.477     0.200
     4.179    63.777     0.200
     4.206    64.977     0.200
     4.258    65.379     0.200
     4.319    65.977     0.200
     4.373    66.277     0.200
     4.421    67.879     0.200
     4.366    67.379     0.200
     4.484    69.676     0.200
     4.484    69.078     0.200
     4.503    69.277     0.200
     4.503    68.578     0.200
     4.706    71.578     0.200
     4.838    72.309     0.200
     4.824    73.277     0.200
     4.867    74.176     0.200
     4.906    73.977     0.200
     5.005    74.098     0.200
     5.027    74.895     0.200
     5.020    76.379     0.200
     5.030    76.277     0.200
     5.030    75.676     0.200
     5.250    80.277     0.200
     5.291    79.777     0.200
     5.313    80.078     0.200
     5.310    78.676     0.200
     5.310    78.875     0.200
     5.337    79.809     0.200
     5.313    80.379     0.200
     5.447    81.777     0.200
     5.439    82.078     0.200
     5.506    82.359     0.200
     5.598    82.145     0.200
     5.641    84.277     0.200
     5.862    84.379     0.200
     5.828    84.859     0.200
     5.858    87.879     0.200
     6.036    91.242     0.200
     6.098    92.031     0.200
     6.119    91.344     0.200
     6.118    91.355     0.200
     6.188    91.531     0.200
     6.218    92.418     0.200
     6.262    94.262     0.200
     6.297    92.199     0.200
     6.366    91.777     0.200
     6.308    92.887     0.200
     6.495    97.414     0.200
     6.629    95.078     0.200
     6.631    99.750     0.200
     7.018   101.578     0.200
     7.215   104.629     0.200
     7.286   104.977     0.200
     7.317   109.051     0.200
     7.385   107.477     0.200
     7.508   108.176     0.200
     7.988   113.676     0.200
     8.357   118.879     0.200
     8.596   122.777     0.200
     8.733   124.879     0.200
     8.926   133.547     0.200
     9.625   136.176     0.200
    20.938   285.051     0.200
     1.347    23.707     0.200
     1.495    26.805     0.200
     1.608    28.156     0.200
     1.734    29.855     0.200
     1.687    28.484     0.200
     1.691    29.098     0.200
     1.709    29.164     0.200
     1.762    29.625     0.200
     1.857    31.305     0.200
     1.843    31.125     0.200
     1.851    31.035     0.200
     1.851    30.914     0.200
     1.934    33.047     0.200
     1.938    32.938     0.200
     1.962    31.824     0.200
     1.984    33.746     0.200
     1.993    33.777     0.200
     1.949    32.188     0.200
     2.056    34.336     0.200
     2.077    33.547     0.200
     2.084    35.984     0.200
     2.176    36.656     0.200
     2.182    36.426     0.200
     2.192    36.836     0.200
     2.165    35.426     0.200
     2.244    37.277     0.200
     2.182    35.824     0.200
     2.281    38.066     0.200
     2.316    37.926     0.200
     2.328    37.367     0.200
     2.328    37.477     0.200
     2.312    37.215     0.200
     2.358    38.504     0.200
     2.358    38.145     0.200
     2.305    37.527     0.200
     2.386    40.145     0.200
     2.393    39.254     0.200
     2.419    39.355     0.200
     2.421    39.305     0.200
     2.494    40.117     0.200
     2.504    40.207     0.200
     2.532    41.754     0.200
     2.565    42.547     0.200
     2.573    42.734     0.200
     2.521    39.875     0.200
     2.528    40.754     0.200
     2.633    42.227     0.200
     2.635    42.125     0.200
     2.677    43.387     0.200
     2.694    42.105     0.200
     2.657    43.137     0.200
     2.779    44.945     0.200
     2.790    45.707     0.200
     2.823    45.285     0.200
     2.823    45.027     0.200
     2.823    43.824     0.200
     2.828    45.176     0.200
     2.824    47.426     0.200
     2.824    46.914     0.200
     2.858    44.676     0.200
     2.858    45.125     0.200
     2.882    45.777     0.200
     2.976    47.766     0.200
     3.021    46.074     0.200
     3.021    46.824     0.200
     2.974    48.766     0.200
     3.052    49.047     0.200
     2.990    46.664     0.200
     3.024    48.496     0.200
     3.038    47.215     0.200
     3.109    48.895     0.200
     3.154    49.496     0.200
     3.166    50.426     0.200
     3.194    49.777     0.200
     3.194    50.625     0.200
     3.182    49.855     0.200
     3.181    50.227     0.200
     3.185    49.824     0.200
     3.185    49.426     0.200
     3.185    49.625     0.200
     3.276    51.445     0.200
     3.229    50.227     0.200
     3.274    52.047     0.200
     3.276    48.395     0.200
     3.309    52.875     0.200
     3.318    51.797     0.200
     3.315    51.996     0.200
     3.338    51.605     0.200
     3.375    52.715     0.200
     3.383    53.027     0.200
     3.383    52.824     0.200
     3.383    52.527     0.200
     3.380    56.125     0.200
     3.430    53.227     0.200
     3.509    55.637     0.200
     3.509    56.598     0.200
     3.469    53.535     0.200
     3.549    55.457     0.200
     3.514    54.324     0.200
     3.583    55.566     0.200
     3.582    57.125     0.200
     3.566    55.477     0.200
     3.608    55.938     0.200
     3.608    56.777     0.200
     3.611    55.527     0.200
     3.617    56.125     0.200
     3.617    55.824     0.200
     3.625    56.324     0.200
     3.625    55.527     0.200
     3.636    58.945     0.200
     3.707    58.746     0.200
     3.656    57.527     0.200
     3.656    56.527     0.200
     3.722    57.324     0.200
     3.722    57.953     0.200
     3.722    57.688     0.200
     3.722    58.246     0.200
     3.722    57.027     0.200
     3.757    58.727     0.200
     3.757    58.227     0.200
     3.755    59.676     0.200
     3.767    61.324     0.200
     3.864    59.945     0.200
     3.900    60.625     0.200
     3.900    60.934     0.200
     3.900    60.297     0.200
     3.900    61.145     0.200
     3.938    58.605     0.200
     3.930    60.195     0.200
     3.930    59.426     0.200
     3.911    62.891     0.200
     3.931    62.195     0.200
     3.922    61.625     0.200
     4.080    62.535     0.200
     4.029    62.227     0.200
     4.089    62.336     0.200
     4.064    62.125     0.200
     4.064    62.527     0.200
     4.064    63.324     0.200
     4.064    62.957     0.200
     4.064    63.188     0.200
     4.148    62.664     0.200
     4.114    63.754     0.200
     4.114    63.617     0.200
     4.164    62.336     0.200
     4.130    65.125     0.200
     4.130    63.426     0.200
     4.138    63.996     0.200
     4.212    64.867     0.200
     4.167    66.945     0.200
     4.235    63.824     0.200
     4.215    64.855     0.200
     4.282    65.215     0.200
     4.253    64.426     0.200
     4.261    65.027     0.200
     4.261    64.027     0.200
     4.270    64.426     0.200
     4.248    67.305     0.200
     4.313    64.734     0.200
     4.267    65.727     0.200
     4.319    62.957     0.200
     4.295    66.375     0.200
     4.298    65.727     0.200
     4.344    65.027     0.200
     4.302    67.586     0.200
     4.348    66.824     0.200
     4.348    67.355     0.200
     4.403    66.227     0.200
     4.403    67.426     0.200
     4.438    65.004     0.200
     4.457    67.586     0.200
     4.457    66.516     0.200
     4.396    66.527     0.200
     4.473    70.414     0.200
     4.489    67.324     0.200
     4.490    67.727     0.200
     4.475    67.926     0.200
     4.475    69.527     0.200
     4.475    68.754     0.200
     4.495    68.727     0.200
     4.495    68.324     0.200
     4.495    69.066     0.200
     4.535    67.824     0.200
     4.567    69.188     0.200
     4.567    69.426     0.200
     4.641    69.805     0.200
     4.649    69.777     0.200
     4.649    69.227     0.200
     4.649    69.664     0.200
     4.664    71.965     0.200
     4.738    71.027     0.200
     4.783    73.125     0.200
     4.883    71.438     0.200
     4.873    72.824     0.200
     4.873    73.027     0.200
     4.915    74.406     0.200
     4.885    73.027     0.200
     4.885    73.324     0.200
     4.950    74.195     0.200
     4.984    73.164     0.200
     5.074    76.207     0.200
     5.103    76.176     0.200
     5.103    76.016     0.200
     5.114    76.188     0.200
     5.084    78.027     0.200
     5.178    81.195     0.200
     5.190    76.465     0.200
     5.198    77.887     0.200
     5.215    76.234     0.200
     5.166    78.727     0.200
     5.205    77.426     0.200
     5.205    79.727     0.200
     5.268    78.621     0.200
     5.241    77.727     0.200
     5.261    78.324     0.200
     5.299    78.039     0.200
     5.255    79.027     0.200
     5.258    78.527     0.200
     5.258    79.926     0.200
     5.362    81.004     0.200
     5.420    79.324     0.200
     5.420    79.426     0.200
     5.394    82.625     0.200
     5.395    81.324     0.200
     5.468    80.996     0.200
     5.415    81.324     0.200
     5.439    83.027     0.200
     5.534    82.246     0.200
     5.501    82.926     0.200
     5.566    81.227     0.200
     5.650    83.426     0.200
     5.646    85.125     0.200
     5.713    84.926     0.200
     5.742    84.727     0.200
     5.740    85.926     0.200
     5.740    85.375     0.200
     5.707    84.527     0.200
     5.801    85.324     0.200
     5.905    86.168     0.200
     5.866    88.125     0.200
     5.873    87.125     0.200
     5.973    90.324     0.200
     6.039    90.074     0.200
     6.031    86.020     0.200
     6.005    88.926     0.200
     6.005    89.125     0.200
     6.039    90.527     0.200
     6.126    91.727     0.200
     6.093    89.027     0.200
     6.089    91.227     0.200
     6.100    90.227     0.200
     6.173    90.027     0.200
     6.204    89.926     0.200
     6.182    91.957     0.200
     6.209    91.621     0.200
     6.146    93.125     0.200
     6.225    94.926     0.200
     6.233    91.578     0.200
     6.221    90.824     0.200
     6.278    92.984     0.200
     6.276    92.605     0.200
     6.291    93.148     0.200
     6.230    92.324     0.200
     6.230    92.426     0.200
     6.316    94.527     0.200
     6.285    93.172     0.200
     6.294    92.574     0.200
     6.339    93.824     0.200
     6.332    95.324     0.200
     6.342    95.027     0.200
     6.358    93.324     0.200
     6.358    93.527     0.200
     6.418    95.141     0.200
     6.457    95.082     0.200
     6.442    96.027     0.200
     6.476    96.426     0.200
     6.470    96.625     0.200
     6.470    96.324     0.200
     6.475    94.727     0.200
     6.475    94.926     0.200
     6.545    97.027     0.200
     6.558    97.934     0.200
     6.552    98.227     0.200
     6.609    95.984     0.200
     6.561    97.227     0.200
     6.643    97.797     0.200
     6.582    96.227     0.200
     6.585    98.426     0.200
     6.586    98.324     0.200
     6.619    99.324     0.200
     6.624    97.926     0.200
     6.624    97.625     0.200
     6.717    99.324     0.200
     6.665    99.324     0.200
     6.696    97.727     0.200
     6.696    97.375     0.200
     6.745    99.324     0.200
     6.760    99.324     0.200
     6.747    98.324     0.200
     6.739    98.727     0.200
     6.739    99.426     0.200
     6.802   102.125     0.200
     6.803   101.027     0.200
     6.859   101.191     0.200
     6.906   101.227     0.200
     6.882   100.527     0.200
     6.930   102.477     0.200
     6.930   102.035     0.200
     6.980   101.926     0.200
     6.958   101.625     0.200
     6.964   101.824     0.200
     7.040   102.727     0.200
     7.007   102.824     0.200
     7.055   103.926     0.200
     7.069   104.027     0.200
     7.140   104.426     0.200
     7.126   103.438     0.200
     7.173   105.285     0.200
     7.197   107.727     0.200
     7.158   103.926     0.200
     7.158   104.727     0.200
     7.154   106.324     0.200
     7.189   106.027     0.200
     7.220   109.949     0.200
     7.207   106.824     0.200
     7.259   104.426     0.200
     7.221   105.426     0.200
     7.253   105.828     0.200
     7.233   105.926     0.200
     7.292   106.027     0.200
     7.292   105.527     0.200
     7.322   107.926     0.200
     7.423   107.926     0.200
     7.471   108.227     0.200
     7.471   107.938     0.200
     7.471   107.477     0.200
     7.495   110.027     0.200
     7.533   109.426     0.200
     7.583   110.426     0.200
     7.583   111.062     0.200
     7.583   112.000     0.200
     7.588   110.324     0.200
     7.588   111.207     0.200
     7.590   110.227     0.200
     7.662   110.324     0.200
     7.670   112.527     0.200
     7.690   112.824     0.200
     7.746   112.324     0.200
     7.763   111.926     0.200
     7.763   111.227     0.200
     7.763   112.297     0.200
     7.788   113.125     0.200
     7.788   112.324     0.200
     7.770   114.176     0.200
     7.777   114.621     0.200
     7.831   112.926     0.200
     7.880   112.625     0.200
     7.818   114.227     0.200
     7.898   117.277     0.200
     7.859   115.625     0.200
     7.891   116.203     0.200
     7.934   114.027     0.200
     7.954   115.727     0.200
     7.959   116.824     0.200
     8.011   118.961     0.200
     8.019   118.324     0.200
     8.019   118.781     0.200
     8.055   115.523     0.200
     8.055   115.852     0.200
     8.084   116.625     0.200
     8.021   117.125     0.200
     8.188   117.824     0.200
     8.208   120.625     0.200
     8.255   118.324     0.200
     8.264   119.125     0.200
     8.305   118.824     0.200
     8.299   120.125     0.200
     8.259   118.227     0.200
     8.306   122.227     0.200
     8.323   121.820     0.200
     8.406   120.227     0.200
     8.345   120.426     0.200
     8.402   123.734     0.200
     8.415   123.426     0.200
     8.409   123.426     0.200
     8.455   123.824     0.200
     8.443   122.824     0.200
     8.524   121.926     0.200
     8.519   124.324     0.200
     8.570   122.125     0.200
     8.596   123.027     0.200
     8.604   122.297     0.200
     8.604   122.324     0.200
     8.641   123.227     0.200
     8.600   126.855     0.200
     8.614   125.848     0.200
     8.672   123.324     0.200
     8.656   125.727     0.200
     8.656   127.562     0.200
     8.656   125.527     0.200
     8.678   124.824     0.200
     8.698   127.727     0.200
     8.698   127.285     0.200
     8.777   125.027     0.200
     8.754   126.824     0.200
     8.832   127.527     0.200
     8.829   127.426     0.200
     8.848   129.293     0.200
     8.844   128.727     0.200
     8.952   128.727     0.200
     8.920   129.680     0.200
     8.997   132.027     0.200
     9.010   131.926     0.200
     9.018   131.926     0.200
     9.051   130.426     0.200
     9.072   133.426     0.200
     9.121   131.625     0.200
     9.093   133.742     0.200
     9.137   130.625     0.200
     9.138   133.762     0.200
     9.179   131.324     0.200
     9.161   133.070     0.200
     9.157   131.227     0.200
     9.245   132.625     0.200
     9.220   135.086     0.200
     9.274   132.125     0.200
     9.262   132.227     0.200
     9.237   134.145     0.200
     9.271   134.227     0.200
     9.299   136.527     0.200
     9.299   135.465     0.200
     9.299   136.410     0.200
     9.328   135.824     0.200
     9.336   136.027     0.200
     9.462   134.625     0.200
     9.462   134.824     0.200
     9.443   138.039     0.200
     9.489   135.055     0.200
     9.489   136.004     0.200
     9.536   137.625     0.200
     9.600   137.824     0.200
     9.577   140.027     0.200
     9.577   139.176     0.200
     9.566   138.926     0.200
     9.570   139.164     0.200
     9.641   138.227     0.200
     9.609   138.324     0.200
     9.609   139.059     0.200
     9.724   139.727     0.200
     9.774   140.426     0.200
     9.740   141.105     0.200
     9.755   140.027     0.200
     9.834   141.324     0.200
     9.800   142.762     0.200
     9.821   142.652     0.200
     9.878   143.926     0.200
     9.878   144.691     0.200
     9.885   144.727     0.200
     9.893   143.324     0.200
     9.968   142.926     0.200
     9.968   142.574     0.200
     9.949   143.824     0.200
     9.949   144.199     0.200
     9.928   144.387     0.200
     9.942   144.824     0.200
     9.979   144.625     0.200
    10.029   145.512     0.200
    10.060   146.926     0.200
    10.060   147.855     0.200
    10.112   145.227     0.200
    10.114   145.027     0.200
    10.124   149.164     0.200
    10.208   145.824     0.200
    10.163   147.680     0.200
    10.180   146.992     0.200
    10.218   147.426     0.200
    10.225   148.074     0.200
    10.204   148.203     0.200
    10.303   148.527     0.200
    10.274   149.633     0.200
    10.314   150.262     0.200
    10.381   148.727     0.200
    10.389   150.562     0.200
    10.393   150.727     0.200
    10.515   152.320     0.200
    10.607   151.125     0.200
    10.631   153.805     0.200
    10.678   153.824     0.200
    10.678   154.031     0.200
    10.757   156.727     0.200
    10.747   154.613     0.200
    10.763   155.848     0.200
    10.926   155.445     0.200
    11.001   159.227     0.200
    11.046   158.145     0.200
    11.094   160.285     0.200
    11.067   159.262     0.200
    11.176   158.645     0.200
    11.236   161.027     0.200
    11.258   161.625     0.200
    11.308   164.824     0.200
    11.482   164.426     0.200
    11.523   163.727     0.200
    11.687   167.867     0.200
    11.735   167.926     0.200
    11.757   167.926     0.200
    11.721   167.926     0.200
    11.942   171.324     0.200
    12.028   174.324     0.200
    12.574   178.426     0.200
    12.853   185.324     0.200
    12.908   182.426     0.200
    12.863   187.527     0.200
    13.810   195.926     0.200
    13.822   195.152     0.200
    13.822   194.625     0.200
    13.822   195.027     0.200
    13.877   195.824     0.200
    13.907   197.527     0.200
    13.907   197.047     0.200
    14.006   196.926     0.200
    14.082   197.527     0.200
    14.127   199.227     0.200
    14.122   198.105     0.200
    14.123   199.375     0.200
    14.350   201.727     0.200
    14.442   203.125     0.200
    14.414   203.848     0.200
    14.497   207.215     0.200
    14.673   208.926     0.200
    14.673   209.406     0.200
    14.673   209.039     0.200
    14.770   209.926     0.200
    15.433   216.816     0.200
    15.442   217.164     0.200
    15.578   220.695     0.200
    15.786   219.926     0.200
    15.841   221.926     0.200
    15.968   224.324     0.200
    16.122   225.566     0.200
    16.160   226.824     0.200
    16.309   227.477     0.200
    16.659   233.926     0.200
    16.810   234.066     0.200
    16.837   235.727     0.200
    16.877   236.527     0.200
    17.050   236.617     0.200
    17.435   242.887     0.200
    17.591   244.996     0.200
    18.134   251.137     0.200
    18.364   253.676     0.200
    18.528   256.125     0.200
    18.553   257.047     0.200
    18.626   258.750     0.200
    18.770   258.688     0.200
    18.733   259.027     0.200
    18.956   264.227     0.200
    19.157   268.727     0.200
    19.451   266.656     0.200
    19.451   267.625     0.200
    19.778   271.047     0.200
    19.793   271.395     0.200
    19.818   271.574     0.200
    19.792   270.926     0.200
    20.312   278.336     0.200
    20.312   279.625     0.200
    20.866   284.824     0.200
    20.858   283.527     0.200
    20.867   285.113     0.200
    20.867   283.727     0.200
    20.874   288.270     0.200
     1.467    27.453     0.200
     1.485    26.742     0.200
     1.497    25.703     0.200
     1.614    29.859     0.200
     1.607    27.820     0.200
     1.685    28.867     0.200
     1.687    28.891     0.200
     1.704    30.102     0.200
     1.809    31.461     0.200
     1.841    31.211     0.200
     2.053    34.797     0.200
     2.130    33.867     0.200
     2.163    35.812     0.200
     2.317    37.258     0.200
     2.302    38.008     0.200
     2.428    39.070     0.200
     2.510    41.453     0.200
     2.640    41.469     0.200
     2.642    41.469     0.200
     2.682    42.188     0.200
     2.818    47.008     0.200
     2.826    44.352     0.200
     2.826    45.312     0.200
     2.826    46.211     0.200
     2.847    47.500     0.200
     2.887    45.438     0.200
     2.982    47.477     0.200
     3.027    47.992     0.200
     3.189    49.398     0.200
     3.183    50.008     0.200
     3.187    49.508     0.200
     3.281    52.047     0.200
     3.386    52.906     0.200
     3.386    53.109     0.200
     3.432    53.109     0.200
     3.516    54.312     0.200
     3.588    57.109     0.200
     3.614    55.812     0.200
     3.618    56.008     0.200
     3.618    56.109     0.200
     3.626    55.906     0.200
     3.658    56.812     0.200
     3.724    57.609     0.200
     3.724    57.609     0.200
     3.760    58.812     0.200
     3.904    62.156     0.200
     3.906    60.508     0.200
     3.906    60.781     0.200
     3.937    60.508     0.200
     4.031    61.906     0.200
     4.064    62.312     0.200
     4.064    62.938     0.200
     4.115    63.680     0.200
     4.155    63.547     0.200
     4.133    64.008     0.200
     4.237    63.508     0.200
     4.256    65.109     0.200
     4.265    64.406     0.200
     4.289    65.148     0.200
     4.268    65.406     0.200
     4.301    65.711     0.200
     4.350    66.609     0.200
     4.393    67.109     0.200
     4.407    67.609     0.200
     4.495    68.211     0.200
     4.495    68.812     0.200
     4.541    68.148     0.200
     4.648    69.961     0.200
     4.656    70.508     0.200
     4.656    70.703     0.200
     4.877    73.312     0.200
     4.889    73.711     0.200
     4.957    74.281     0.200
     5.083    78.312     0.200
     5.121    76.031     0.200
     5.203    80.109     0.200
     5.275    79.570     0.200
     5.257    79.508     0.200
     5.306    78.750     0.200
     5.424    79.609     0.200
     5.541    82.602     0.200
     5.644    85.406     0.200
     5.694    83.125     0.200
     5.746    84.812     0.200
     5.747    86.633     0.200
     5.911    86.617     0.200
     6.004    89.008     0.200
     6.037    87.172     0.200
     6.176    90.008     0.200
     6.143    93.312     0.200
     6.207    90.109     0.200
     6.239    91.492     0.200
     6.229    92.906     0.200
     6.282    93.617     0.200
     6.297    93.578     0.200
     6.297    92.719     0.200
     6.330    95.906     0.200
     6.358    93.711     0.200
     6.425    95.992     0.200
     6.463    95.266     0.200
     6.438    96.406     0.200
     6.467    97.406     0.200
     6.549    94.711     0.200
     6.548    98.609     0.200
     6.557    97.906     0.200
     6.616    96.414     0.200
     6.649    98.047     0.200
     6.625    98.109     0.200
     6.751   100.266     0.200
     6.800   101.211     0.200
     6.881   101.109     0.200
     6.925   102.836     0.200
     6.956   100.406     0.200
     6.977   101.008     0.200
     6.962   102.312     0.200
     7.043   101.406     0.200
     7.069   104.406     0.200
     7.201   108.211     0.200
     7.192   106.031     0.200
     7.265   106.211     0.200
     7.257   105.836     0.200
     7.478   107.812     0.200
     7.589   112.312     0.200
     7.589   108.164     0.200
     7.592   110.828     0.200
     7.713   112.312     0.200
     7.752   112.906     0.200
     7.769   111.609     0.200
     7.795   114.711     0.200
     7.779   113.430     0.200
     7.895   116.016     0.200
     7.982   114.109     0.200
     8.062   115.680     0.200
     8.062   115.812     0.200
     8.258   118.906     0.200
     8.279   123.109     0.200
     8.306   119.906     0.200
     8.412   120.109     0.200
     8.531   122.211     0.200
     8.525   122.008     0.200
     8.615   125.422     0.200
     8.678   123.711     0.200
     8.663   127.133     0.200
     8.663   127.312     0.200
     8.701   127.328     0.200
     8.783   125.711     0.200
     8.839   127.812     0.200
     8.853   128.156     0.200
     9.141   132.984     0.200
     9.162   131.656     0.200
     9.269   132.812     0.200
     9.302   134.703     0.200
     9.302   137.375     0.200
     9.695   136.406     0.200
     9.882   143.648     0.200
     9.896   142.844     0.200
    10.200   148.914     0.200
    10.395   150.180     0.200
    14.123   198.938     0.200
    14.673   207.812     0.200
    18.623   260.031     0.200
     1.505    26.953     0.200
     1.785    30.492     0.200
     1.866    31.797     0.200
     1.872    32.133     0.200
     1.971    33.203     0.200
     2.188    37.297     0.200
     2.329    37.383     0.200
     2.432    38.438     0.200
     2.639    41.234     0.200
     2.696    42.727     0.200
     2.845    44.914     0.200
     2.845    45.594     0.200
     2.845    45.398     0.200
     2.900    45.852     0.200
     2.989    46.922     0.200
     3.047    48.414     0.200
     3.186    49.203     0.200
     3.203    50.695     0.200
     3.203    50.594     0.200
     3.209    49.898     0.200
     3.283    51.914     0.200
     3.406    53.195     0.200
     3.596    57.297     0.200
     3.641    56.492     0.200
     3.746    58.094     0.200
     3.746    57.898     0.200
     3.779    59.094     0.200
     3.914    60.797     0.200
     3.914    60.398     0.200
     3.914    59.781     0.200
     4.088    63.023     0.200
     4.154    62.898     0.200
     4.138    64.383     0.200
     4.274    65.492     0.200
     4.280    65.195     0.200
     4.280    65.398     0.200
     4.345    66.297     0.200
     4.345    66.398     0.200
     4.424    67.594     0.200
     4.424    67.992     0.200
     4.494    67.594     0.200
     4.512    69.594     0.200
     4.545    67.766     0.200
     4.760    72.195     0.200
     4.906    73.992     0.200
     5.117    76.875     0.200
     5.226    78.297     0.200
     5.268    78.055     0.200
     5.263    78.695     0.200
     5.302    78.133     0.200
     5.284    79.297     0.200
     5.438    79.992     0.200
     5.530    82.414     0.200
     5.673    84.898     0.200
     5.909    86.492     0.200
     5.909    86.609     0.200
     6.102    90.297     0.200
     6.203    91.773     0.200
     6.225    90.922     0.200
     6.269    91.102     0.200
     6.243    91.992     0.200
     6.315    92.609     0.200
     6.362    94.492     0.200
     6.458    94.953     0.200
     6.614    95.539     0.200
     6.648    98.336     0.200
     6.716    97.500     0.200
     6.914   103.922     0.200
     7.274   105.586     0.200
     7.471   107.617     0.200
     7.757   113.492     0.200
     9.321   134.469     0.200
     1.373    25.758     0.200
     1.377    25.180     0.200
     1.510    26.680     0.200
     1.519    25.891     0.200
     1.632    28.641     0.200
     1.713    27.758     0.200
     1.717    29.680     0.200
     1.791    30.719     0.200
     1.874    31.820     0.200
     1.879    31.719     0.200
     2.085    35.133     0.200
     2.194    37.219     0.200
     2.334    37.820     0.200
     2.333    38.922     0.200
     2.435    38.742     0.200
     2.552    43.102     0.200
     2.640    41.672     0.200
     2.648    41.758     0.200
     2.701    42.609     0.200
     2.846    42.320     0.200
     2.851    45.141     0.200
     2.851    45.320     0.200
     2.851    45.539     0.200
     2.905    45.609     0.200
     2.992    47.398     0.200
     3.054    48.203     0.200
     3.187    49.562     0.200
     3.210    50.422     0.200
     3.210    50.523     0.200
     3.216    50.023     0.200
     3.286    51.812     0.200
     3.412    53.422     0.200
     3.412    53.023     0.200
     3.461    53.820     0.200
     3.547    54.633     0.200
     3.544    54.719     0.200
     3.600    57.219     0.200
     3.641    56.523     0.200
     3.648    56.320     0.200
     3.648    56.422     0.200
     3.656    56.023     0.200
     3.685    56.820     0.200
     3.753    58.023     0.200
     3.753    57.922     0.200
     3.753    58.023     0.200
     3.785    58.820     0.200
     3.785    58.719     0.200
     3.918    61.023     0.200
     3.918    60.875     0.200
     3.918    61.453     0.200
     4.058    62.820     0.200
     4.096    62.922     0.200
     4.096    63.148     0.200
     4.155    63.164     0.200
     4.146    64.109     0.200
     4.158    63.422     0.200
     4.206    64.117     0.200
     4.281    65.617     0.200
     4.286    64.523     0.200
     4.286    64.719     0.200
     4.297    66.117     0.200
     4.328    66.422     0.200
     4.346    66.523     0.200
     4.430    67.523     0.200
     4.430    67.820     0.200
     4.496    67.617     0.200
     4.519    68.922     0.200
     4.548    68.344     0.200
     4.651    70.422     0.200
     4.651    70.711     0.200
     4.766    71.719     0.200
     4.912    74.117     0.200
     4.912    73.922     0.200
     5.117    76.094     0.200
     5.224    76.328     0.200
     5.232    78.023     0.200
     5.267    78.219     0.200
     5.269    78.922     0.200
     5.303    78.172     0.200
     5.291    79.023     0.200
     5.443    80.422     0.200
     5.528    82.422     0.200
     5.680    84.617     0.200
     5.707    82.414     0.200
     5.716    85.422     0.200
     5.738    84.438     0.200
     5.784    85.648     0.200
     5.830    85.523     0.200
     5.911    86.359     0.200
     6.046    88.406     0.200
     6.109    90.422     0.200
     6.145    89.820     0.200
     6.195    89.414     0.200
     6.201    92.367     0.200
     6.222    93.391     0.200
     6.250    92.023     0.200
     6.267    91.344     0.200
     6.283    93.719     0.200
     6.321    92.820     0.200
     6.369    94.320     0.200
     6.458    94.945     0.200
     6.520    96.719     0.200
     6.616    94.898     0.200
     6.633    99.266     0.200
     6.655    97.422     0.200
     6.655    98.180     0.200
     6.732    98.180     0.200
     6.721    97.523     0.200
     6.721    98.023     0.200
     6.909   102.570     0.200
     7.012   103.320     0.200
     7.172   106.117     0.200
     7.280   106.094     0.200
     7.471   107.797     0.200
     7.762   111.117     0.200
     7.759   113.023     0.200
     8.042   117.586     0.200
     8.300   120.117     0.200
     8.657   122.117     0.200
     8.665   126.602     0.200
     8.726   125.797     0.200
     8.760   122.820     0.200
     9.165   131.820     0.200
     9.327   136.094     0.200
     9.327   134.883     0.200
     9.902   142.805     0.200
     1.788    31.221     0.200
     1.742    30.041     0.200
     1.828    31.041     0.200
     2.144    36.541     0.200
     2.283    38.041     0.200
     2.332    37.551     0.200
     2.391    39.281     0.200
     2.375    39.242     0.200
     2.449    39.162     0.200
     2.664    41.271     0.200
     2.663    42.291     0.200
     2.694    42.811     0.200
     2.791    44.551     0.200
     2.832    45.072     0.200
     2.832    44.791     0.200
     2.832    44.941     0.200
     2.914    48.402     0.200
     3.000    47.182     0.200
     3.030    48.422     0.200
     3.182    49.230     0.200
     3.225    51.262     0.200
     3.214    49.951     0.200
     3.186    49.941     0.200
     3.187    49.641     0.200
     3.187    49.742     0.200
     3.303    52.291     0.200
     3.283    51.701     0.200
     3.293    50.221     0.200
     3.389    53.041     0.200
     3.430    53.242     0.200
     3.516    54.742     0.200
     3.583    55.711     0.200
     3.579    56.230     0.200
     3.605    57.441     0.200
     3.615    56.041     0.200
     3.615    56.041     0.200
     3.621    56.242     0.200
     3.699    57.742     0.200
     3.660    56.441     0.200
     3.722    57.711     0.200
     3.722    57.441     0.200
     3.722    57.541     0.200
     3.765    59.041     0.200
     3.877    62.941     0.200
     3.901    61.701     0.200
     3.945    63.182     0.200
     3.956    58.922     0.200
     3.924    60.582     0.200
     3.924    60.381     0.200
     3.963    60.381     0.200
     3.963    59.441     0.200
     4.137    63.441     0.200
     4.180    63.102     0.200
     4.198    62.922     0.200
     4.255    63.541     0.200
     4.262    64.842     0.200
     4.274    64.342     0.200
     4.267    64.842     0.200
     4.290    63.541     0.200
     4.313    65.271     0.200
     4.301    65.342     0.200
     4.377    66.242     0.200
     4.414    67.441     0.200
     4.492    67.141     0.200
     4.520    67.041     0.200
     4.562    68.262     0.200
     4.597    68.941     0.200
     4.671    69.652     0.200
     4.682    70.711     0.200
     4.682    70.242     0.200
     4.721    70.172     0.200
     4.772    73.322     0.200
     4.896    72.451     0.200
     4.887    72.541     0.200
     4.896    73.242     0.200
     4.967    74.682     0.200
     4.979    73.951     0.200
     5.115    75.631     0.200
     5.147    77.174     0.200
     5.147    76.682     0.200
     5.224    76.961     0.200
     5.233    77.871     0.200
     5.245    79.941     0.200
     5.302    79.154     0.200
     5.331    78.637     0.200
     5.370    78.641     0.200
     5.436    79.041     0.200
     5.569    82.570     0.200
     5.680    84.621     0.200
     5.712    83.541     0.200
     5.768    84.541     0.200
     5.774    86.379     0.200
     5.774    85.100     0.200
     5.847    86.201     0.200
     5.795    88.822     0.200
     5.936    86.957     0.200
     5.936    86.580     0.200
     5.994    89.041     0.200
     6.073    90.381     0.200
     6.090    89.811     0.200
     6.196    89.842     0.200
     6.226    90.041     0.200
     6.244    93.658     0.200
     6.244    93.484     0.200
     6.267    92.559     0.200
     6.214    92.842     0.200
     6.311    93.254     0.200
     6.325    93.969     0.200
     6.350    94.008     0.200
     6.304    92.779     0.200
     6.453    95.225     0.200
     6.488    95.461     0.200
     6.490    95.932     0.200
     6.490    95.709     0.200
     6.449    96.541     0.200
     6.449    97.041     0.200
     6.469    96.342     0.200
     6.572    98.541     0.200
     6.568    96.242     0.200
     6.640    96.305     0.200
     6.677    99.088     0.200
     6.621    98.041     0.200
     6.621    97.762     0.200
     6.621    98.342     0.200
     6.710    98.141     0.200
     6.764   100.994     0.200
     6.779   102.047     0.200
     6.779   101.484     0.200
     6.789    99.770     0.200
     6.865   101.443     0.200
     6.910   102.516     0.200
     6.910   103.441     0.200
     7.002   101.342     0.200
     6.950   102.541     0.200
     7.048   105.418     0.200
     7.064   102.342     0.200
     7.085   102.541     0.200
     7.127   105.441     0.200
     7.224   108.742     0.200
     7.196   106.342     0.200
     7.264   106.041     0.200
     7.288   104.141     0.200
     7.319   107.941     0.200
     7.452   108.641     0.200
     7.505   108.572     0.200
     7.505   108.422     0.200
     7.505   107.842     0.200
     7.514   110.041     0.200
     7.607   109.842     0.200
     7.600   110.742     0.200
     7.684   113.342     0.200
     7.689   113.041     0.200
     7.772   112.641     0.200
     7.796   112.141     0.200
     7.796   111.742     0.200
     7.773   114.084     0.200
     7.778   114.688     0.200
     7.819   113.541     0.200
     7.830   113.541     0.200
     7.865   113.900     0.200
     7.979   113.941     0.200
     7.966   115.742     0.200
     8.035   117.941     0.200
     8.086   118.441     0.200
     8.086   117.262     0.200
     8.086   116.242     0.200
     8.222   119.441     0.200
     8.278   118.641     0.200
     8.215   118.842     0.200
     8.215   118.541     0.200
     8.297   121.141     0.200
     8.328   120.764     0.200
     8.335   120.941     0.200
     8.439   120.342     0.200
     8.411   123.271     0.200
     8.469   123.342     0.200
     8.545   123.842     0.200
     8.629   123.141     0.200
     8.612   124.939     0.200
     8.631   126.342     0.200
     8.706   123.842     0.200
     8.686   126.641     0.200
     8.686   126.342     0.200
     8.686   125.471     0.200
     8.706   126.842     0.200
     8.810   125.242     0.200
     8.743   126.242     0.200
     8.743   126.541     0.200
     8.863   126.742     0.200
     8.956   130.041     0.200
     9.035   132.842     0.200
     9.082   131.441     0.200
     9.107   131.951     0.200
     9.133   132.941     0.200
     9.125   130.842     0.200
     9.148   132.719     0.200
     9.143   131.641     0.200
     9.161   132.562     0.200
     9.203   132.541     0.200
     9.225   134.344     0.200
     9.293   131.541     0.200
     9.277   133.242     0.200
     9.294   132.141     0.200
     9.307   135.541     0.200
     9.307   135.086     0.200
     9.307   135.301     0.200
     9.297   135.742     0.200
     9.358   136.041     0.200
     9.358   134.541     0.200
     9.453   137.457     0.200
     9.522   135.391     0.200
     9.567   139.742     0.200
     9.604   139.342     0.200
     9.586   139.041     0.200
     9.748   138.041     0.200
     9.759   139.842     0.200
     9.794   141.242     0.200
     9.892   143.941     0.200
     9.900   143.531     0.200
     9.901   142.842     0.200
     9.957   143.541     0.200
     9.957   144.742     0.200
    10.002   143.441     0.200
    10.002   142.881     0.200
     9.950   141.641     0.200
    10.041   145.518     0.200
    10.177   147.121     0.200
    10.396   150.141     0.200
    10.680   153.641     0.200
    10.680   153.451     0.200
    10.751   154.773     0.200
    10.778   156.941     0.200
    12.329   176.742     0.200
    13.064   186.842     0.200
    13.839   194.941     0.200
    13.839   195.344     0.200
    14.133   199.266     0.200
    14.662   208.541     0.200
    18.168   251.473     0.200
    18.605   259.617     0.200
    18.796   259.242     0.200
    20.875   286.541     0.200
    20.937   285.842     0.200
     1.749    30.373     0.200
     1.833    31.072     0.200
     2.151    36.072     0.200
     2.290    37.873     0.200
     2.327    37.523     0.200
     2.382    39.172     0.200
     2.442    39.193     0.200
     2.656    41.842     0.200
     2.656    42.012     0.200
     2.690    42.643     0.200
     2.831    45.342     0.200
     2.831    44.672     0.200
     2.994    47.363     0.200
     3.029    48.293     0.200
     3.185    49.973     0.200
     3.188    49.873     0.200
     3.205    50.184     0.200
     3.296    52.363     0.200
     3.389    52.973     0.200
     3.431    53.273     0.200
     3.517    54.773     0.200
     3.599    57.072     0.200
     3.615    56.172     0.200
     3.616    55.572     0.200
     3.616    56.273     0.200
     3.623    56.072     0.200
     3.660    56.973     0.200
     3.723    57.572     0.200
     3.723    57.473     0.200
     3.764    58.973     0.200
     3.918    60.572     0.200
     3.954    62.273     0.200
     4.136    63.172     0.200
     4.171    63.283     0.200
     4.249    64.072     0.200
     4.261    64.973     0.200
     4.271    64.572     0.200
     4.268    65.373     0.200
     4.301    65.773     0.200
     4.301    66.072     0.200
     4.368    66.072     0.200
     4.412    67.373     0.200
     4.511    67.873     0.200
     4.673    70.572     0.200
     4.776    73.293     0.200
     4.884    72.473     0.200
     4.894    73.373     0.200
     5.138    77.084     0.200
     5.252    79.383     0.200
     5.293    78.615     0.200
     5.322    77.916     0.200
     5.432    79.473     0.200
     5.559    83.545     0.200
     5.706    83.172     0.200
     5.760    85.672     0.200
     5.765    86.850     0.200
     5.798    88.902     0.200
     5.928    86.877     0.200
     6.094    89.863     0.200
     6.188    90.273     0.200
     6.219    90.373     0.200
     6.234    94.537     0.200
     6.257    94.041     0.200
     6.302    92.994     0.200
     6.340    94.365     0.200
     6.481    94.393     0.200
     6.472    96.473     0.200
     6.564    96.373     0.200
     6.632    96.357     0.200
     6.623    98.338     0.200
     6.623    98.473     0.200
     6.707    97.934     0.200
     6.787    99.387     0.200
     6.915   102.373     0.200
     6.971   102.273     0.200
     6.954   102.672     0.200
     6.993   102.273     0.200
     7.262   106.018     0.200
     7.280   105.072     0.200
     7.495   107.998     0.200
     7.692   113.072     0.200
     7.765   112.572     0.200
     7.787   111.572     0.200
     7.822   114.072     0.200
     7.971   115.172     0.200
     8.031   117.383     0.200
     8.614   125.715     0.200
     8.678   127.494     0.200
     8.678   125.873     0.200
     8.705   127.453     0.200
     9.104   132.680     0.200
     9.146   133.168     0.200
     9.162   133.361     0.200
     9.305   135.443     0.200
     9.305   135.662     0.200
     9.451   136.916     0.200
     9.889   143.539     0.200
     9.992   143.973     0.200
    10.038   145.303     0.200
    14.129   199.422     0.200
    14.667   207.430     0.200
     1.438    25.018     0.200
     1.470    25.428     0.200
     1.473    27.168     0.200
     1.543    27.098     0.200
     1.605    28.318     0.200
     1.613    28.898     0.200
     4.852    73.818     0.200
     5.276    78.232     0.200
     5.837    85.883     0.200
     5.982    88.635     0.200
     6.342    94.918     0.200
     6.546    98.680     0.200
     6.628    97.193     0.200
     6.630    97.074     0.200
     6.684    98.605     0.200
     6.782   100.117     0.200
     6.817   101.318     0.200
     7.014   103.488     0.200
     7.647   113.617     0.200
     7.963   113.719     0.200
     8.512   120.818     0.200
     8.890   125.617     0.200
     9.128   128.918     0.200
     9.266   130.719     0.200
    10.241   143.518     0.200
     1.465    26.023     0.200
     1.521    26.484     0.200
     1.556    28.316     0.200
     1.514    26.395     0.200
     1.553    27.164     0.200
     1.554    27.324     0.200
     1.562    27.504     0.200
     1.648    29.297     0.200
     1.626    28.414     0.200
     1.688    30.254     0.200
     1.695    28.816     0.200
     1.653    28.727     0.200
     1.701    30.566     0.200
     1.665    28.773     0.200
     1.680    29.102     0.200
     1.781    31.434     0.200
     1.781    31.766     0.200
     1.736    29.836     0.200
     1.825    31.613     0.200
     1.824    31.074     0.200
     1.929    32.715     0.200
     2.124    35.797     0.200
     2.102    35.613     0.200
     2.107    35.125     0.200
     2.162    35.926     0.200
     2.337    38.797     0.200
     2.337    37.926     0.200
     2.388    40.047     0.200
     2.440    40.766     0.200
     2.522    41.395     0.200
     2.524    40.637     0.200
     2.524    41.934     0.200
     2.531    41.996     0.200
     2.544    41.375     0.200
     2.562    41.875     0.200
     2.566    42.234     0.200
     2.596    43.016     0.200
     2.672    44.055     0.200
     2.707    43.625     0.200
     2.707    43.426     0.200
     2.752    44.965     0.200
     2.726    44.324     0.200
     2.726    43.727     0.200
     2.867    46.641     0.200
     2.867    46.414     0.200
     2.937    47.406     0.200
     2.905    46.523     0.200
     2.905    46.125     0.200
     2.949    47.055     0.200
     2.984    47.727     0.200
     3.054    48.727     0.200
     3.141    50.176     0.200
     3.111    49.176     0.200
     3.182    52.004     0.200
     3.142    49.926     0.200
     3.185    50.324     0.200
     3.185    50.727     0.200
     3.236    50.566     0.200
     3.236    50.266     0.200
     3.241    51.477     0.200
     3.204    50.824     0.200
     3.296    51.703     0.200
     3.296    53.895     0.200
     3.274    51.426     0.200
     3.274    52.227     0.200
     3.271    52.727     0.200
     3.271    51.875     0.200
     3.271    52.984     0.200
     3.271    51.625     0.200
     3.271    51.727     0.200
     3.324    52.953     0.200
     3.326    53.023     0.200
     3.446    55.023     0.200
     3.446    54.824     0.200
     3.461    53.746     0.200
     3.526    55.305     0.200
     3.637    55.824     0.200
     3.642    56.453     0.200
     3.648    57.324     0.200
     3.648    56.727     0.200
     3.657    57.734     0.200
     3.706    59.086     0.200
     3.678    58.547     0.200
     3.731    58.566     0.200
     3.691    58.484     0.200
     3.691    57.926     0.200
     3.691    57.625     0.200
     3.748    60.285     0.200
     3.766    59.227     0.200
     3.771    58.523     0.200
     3.771    58.227     0.200
     3.804    58.965     0.200
     3.814    59.324     0.200
     3.834    59.727     0.200
     3.834    60.926     0.200
     3.830    59.516     0.200
     3.881    60.895     0.200
     3.881    61.055     0.200
     3.904    59.137     0.200
     3.946    63.125     0.200
     3.914    61.324     0.200
     3.914    60.727     0.200
     3.967    62.035     0.200
     4.034    62.523     0.200
     4.034    63.246     0.200
     4.000    64.625     0.200
     4.015    63.734     0.200
     4.015    64.016     0.200
     4.014    63.324     0.200
     4.014    62.824     0.200
     4.053    61.426     0.200
     4.098    61.926     0.200
     4.136    62.727     0.200
     4.166    64.203     0.200
     4.171    64.215     0.200
     4.171    64.355     0.200
     4.187    64.227     0.200
     4.187    64.023     0.200
     4.181    66.184     0.200
     4.173    64.336     0.200
     4.196    68.125     0.200
     4.262    64.914     0.200
     4.242    68.426     0.200
     4.288    64.773     0.200
     4.309    66.445     0.200
     4.320    68.605     0.200
     4.351    65.727     0.200
     4.351    66.406     0.200
     4.337    69.387     0.200
     4.372    65.863     0.200
     4.372    65.734     0.200
     4.384    67.824     0.200
     4.388    65.785     0.200
     4.383    67.824     0.200
     4.383    66.125     0.200
     4.396    68.125     0.200
     4.396    66.727     0.200
     4.396    66.934     0.200
     4.423    68.746     0.200
     4.423    68.625     0.200
     4.521    68.523     0.200
     4.521    69.324     0.200
     4.521    68.086     0.200
     4.575    70.535     0.200
     4.597    65.496     0.200
     4.597    70.664     0.200
     4.607    73.754     0.200
     4.621    70.324     0.200
     4.676    69.906     0.200
     4.712    69.934     0.200
     4.717    71.727     0.200
     4.757    70.984     0.200
     4.775    72.586     0.200
     4.775    75.203     0.200
     4.757    72.324     0.200
     4.794    71.656     0.200
     4.794    71.203     0.200
     4.814    72.332     0.200
     4.794    72.523     0.200
     4.838    71.895     0.200
     4.838    71.664     0.200
     4.832    72.586     0.200
     4.843    71.875     0.200
     4.850    71.965     0.200
     4.840    74.727     0.200
     4.939    74.125     0.200
     4.955    74.375     0.200
     4.962    73.824     0.200
     4.962    74.203     0.200
     4.933    73.625     0.200
     4.933    73.023     0.200
     4.916    75.324     0.200
     4.973    74.254     0.200
     5.017    75.133     0.200
     5.064    77.836     0.200
     5.066    77.785     0.200
     5.060    75.105     0.200
     5.071    75.727     0.200
     5.071    75.363     0.200
     5.139    75.625     0.200
     5.139    76.605     0.200
     5.143    75.945     0.200
     5.145    78.523     0.200
     5.206    79.285     0.200
     5.343    79.094     0.200
     5.327    79.426     0.200
     5.412    80.004     0.200
     5.416    81.434     0.200
     5.481    81.785     0.200
     5.502    82.953     0.200
     5.498    81.621     0.200
     5.498    82.125     0.200
     5.498    81.727     0.200
     5.560    82.309     0.200
     5.560    82.137     0.200
     5.560    82.535     0.200
     5.576    81.824     0.200
     5.638    83.797     0.200
     5.667    83.816     0.200
     5.642    84.227     0.200
     5.806    87.336     0.200
     5.813    86.164     0.200
     5.768    87.016     0.200
     5.805    86.215     0.200
     5.850    87.984     0.200
     5.909    89.324     0.200
     5.879    88.523     0.200
     5.950    87.926     0.200
     5.967    89.016     0.200
     5.967    88.684     0.200
     5.918    88.426     0.200
     6.014    87.574     0.200
     5.983    89.125     0.200
     6.085    91.023     0.200
     6.120    89.266     0.200
     6.123    90.430     0.200
     6.131    91.422     0.200
     6.137    90.746     0.200
     6.166    91.445     0.200
     6.206    92.426     0.200
     6.206    92.906     0.200
     6.206    92.625     0.200
     6.254    92.523     0.200
     6.254    93.844     0.200
     6.187    92.824     0.200
     6.256    92.223     0.200
     6.226    94.023     0.200
     6.280    93.070     0.200
     6.319    94.824     0.200
     6.292    93.617     0.200
     6.378    94.625     0.200
     6.461    94.625     0.200
     6.479    93.184     0.200
     6.515    96.027     0.200
     6.509    96.125     0.200
     6.571    95.453     0.200
     6.555    97.227     0.200
     6.555    97.125     0.200
     6.662    99.172     0.200
     6.662    99.039     0.200
     6.671    96.887     0.200
     6.677    99.816     0.200
     6.665    97.523     0.200
     6.709    98.824     0.200
     6.706   100.406     0.200
     6.764   100.270     0.200
     6.866    99.023     0.200
     6.841   100.125     0.200
     6.906   101.824     0.200
     6.907   100.891     0.200
     6.980   102.984     0.200
     7.068   103.324     0.200
     7.068   103.926     0.200
     7.026   102.125     0.200
     7.089   103.727     0.200
     7.089   103.324     0.200
     7.098   104.926     0.200
     7.131   102.426     0.200
     7.197   103.961     0.200
     7.197   104.477     0.200
     7.197   104.375     0.200
     7.227   106.004     0.200
     7.270   106.824     0.200
     7.289   106.727     0.200
     7.272   108.125     0.200
     7.319   107.324     0.200
     7.367   108.523     0.200
     7.367   109.926     0.200
     7.404   108.625     0.200
     7.407   111.949     0.200
     7.407   108.375     0.200
     7.426   109.227     0.200
     7.403   110.660     0.200
     7.492   107.926     0.200
     7.492   108.375     0.200
     7.531   111.832     0.200
     7.531   112.926     0.200
     7.585   109.324     0.200
     7.585   108.637     0.200
     7.613   110.227     0.200
     7.690   112.469     0.200
     7.690   114.191     0.200
     7.690   112.227     0.200
     7.819   116.227     0.200
     7.917   116.898     0.200
     8.012   114.926     0.200
     8.051   115.625     0.200
     8.051   116.426     0.200
     8.089   119.926     0.200
     8.123   116.023     0.200
     8.123   116.777     0.200
     8.147   118.523     0.200
     8.147   119.426     0.200
     8.156   116.523     0.200
     8.213   120.973     0.200
     8.213   122.023     0.200
     8.271   121.246     0.200
     8.271   120.324     0.200
     8.271   120.125     0.200
     8.292   118.090     0.200
     8.291   118.824     0.200
     8.381   121.125     0.200
     8.406   119.727     0.200
     8.406   119.926     0.200
     8.377   121.625     0.200
     8.498   123.523     0.200
     8.545   122.227     0.200
     8.525   127.824     0.200
     8.636   123.426     0.200
     8.636   123.324     0.200
     8.641   127.023     0.200
     8.650   127.352     0.200
     8.699   127.125     0.200
     8.709   124.523     0.200
     8.783   124.727     0.200
     8.816   130.121     0.200
     8.816   129.504     0.200
     8.918   130.023     0.200
     9.187   134.727     0.200
     9.199   130.945     0.200
     9.240   132.227     0.200
     9.240   130.766     0.200
     9.397   133.227     0.200
     9.397   133.523     0.200
     9.389   137.117     0.200
     9.396   137.477     0.200
     9.392   134.926     0.200
     9.409   137.238     0.200
     9.462   135.926     0.200
     9.465   136.926     0.200
     9.465   138.426     0.200
     9.559   137.523     0.200
     9.539   139.391     0.200
     9.577   135.625     0.200
     9.651   137.727     0.200
     9.651   137.598     0.200
     9.692   137.523     0.200
     9.692   137.824     0.200
     9.702   138.727     0.200
     9.702   138.414     0.200
     9.761   138.523     0.200
     9.762   138.625     0.200
     9.762   139.523     0.200
     9.740   139.992     0.200
     9.740   139.227     0.200
     9.797   138.727     0.200
     9.798   139.523     0.200
     9.943   144.023     0.200
     9.943   143.324     0.200
     9.973   142.426     0.200
    10.069   143.930     0.200
    10.185   148.047     0.200
    10.271   148.023     0.200
    10.301   149.270     0.200
    10.415   149.926     0.200
    10.415   149.824     0.200
    10.861   155.426     0.200
    10.969   158.426     0.200
    11.219   160.625     0.200
    11.219   161.523     0.200
    11.566   164.125     0.200
    13.337   189.824     0.200
    14.280   201.926     0.200
    14.299   201.625     0.200
    14.299   204.375     0.200
    14.510   205.875     0.200
    18.347   252.426     0.200
    18.471   255.395     0.200
    19.499   267.125     0.200
    20.417   280.324     0.200
    20.584   280.602     0.200
    20.584   281.023     0.200
     1.262    22.074     0.200
     1.272    22.184     0.200
     1.300    22.414     0.200
     1.276    22.281     0.200
     1.412    25.332     0.200
     1.448    24.652     0.200
     1.495    25.805     0.200
     1.479    25.723     0.200
     1.510    25.812     0.200
     1.528    25.902     0.200
     1.588    26.633     0.200
     1.626    27.793     0.200
     1.621    27.484     0.200
     1.616    27.164     0.200
     1.630    27.434     0.200
     1.658    28.395     0.200
     1.815    29.125     0.200
     1.806    30.613     0.200
     1.899    31.004     0.200
     1.955    32.094     0.200
     2.031    33.113     0.200
     2.059    33.992     0.200
     2.114    34.164     0.200
     2.117    34.875     0.200
     2.168    35.832     0.200
     2.235    35.543     0.200
     2.417    38.004     0.200
     2.432    38.703     0.200
     2.432    39.703     0.200
     2.618    42.102     0.200
     2.618    42.203     0.200
     2.689    43.203     0.200
     2.760    44.102     0.200
     2.851    45.402     0.200
     2.885    45.902     0.200
     2.894    46.004     0.200
     2.936    48.004     0.200
     2.911    45.602     0.200
     2.977    47.457     0.200
     2.977    47.203     0.200
     2.992    47.305     0.200
     3.266    51.602     0.200
     3.269    51.203     0.200
     3.364    52.504     0.200
     3.397    53.242     0.200
     3.435    55.402     0.200
     3.513    54.602     0.200
     3.519    54.805     0.200
     3.541    55.004     0.200
     3.643    56.504     0.200
     3.807    59.102     0.200
     3.902    57.805     0.200
     3.977    59.262     0.200
     3.949    60.203     0.200
     4.028    62.902     0.200
     3.996    61.305     0.200
     3.996    61.555     0.200
     4.059    61.504     0.200
     4.125    62.805     0.200
     4.163    62.824     0.200
     4.144    64.293     0.200
     4.230    62.484     0.200
     4.344    69.152     0.200
     4.399    65.723     0.200
     4.394    66.703     0.200
     4.435    66.094     0.200
     4.509    69.602     0.200
     4.642    70.004     0.200
     4.732    69.934     0.200
     4.777    70.258     0.200
     4.789    72.203     0.200
     4.812    74.102     0.200
     4.916    72.344     0.200
     4.901    74.805     0.200
     5.016    74.152     0.200
     5.028    75.402     0.200
     5.043    75.305     0.200
     5.112    78.375     0.200
     5.132    76.504     0.200
     5.220    77.504     0.200
     5.231    77.305     0.200
     5.247    78.004     0.200
     5.382    78.473     0.200
     5.386    79.805     0.200
     5.426    80.102     0.200
     5.503    80.715     0.200
     5.520    82.504     0.200
     5.637    82.504     0.200
     5.653    84.004     0.200
     5.675    84.703     0.200
     5.692    85.703     0.200
     5.892    86.875     0.200
     5.950    90.656     0.200
     5.942    89.203     0.200
     5.982    88.805     0.200
     5.988    89.203     0.200
     6.017    90.531     0.200
     6.105    90.926     0.200
     6.132    89.340     0.200
     6.172    89.562     0.200
     6.188    91.121     0.200
     6.206    91.039     0.200
     6.211    90.312     0.200
     6.170    92.004     0.200
     6.197    91.602     0.200
     6.199    93.402     0.200
     6.350    93.375     0.200
     6.369    93.547     0.200
     6.411    94.902     0.200
     6.430    93.902     0.200
     6.473    96.703     0.200
     6.494    96.168     0.200
     6.477    95.402     0.200
     6.591    96.156     0.200
     6.745   100.203     0.200
     6.764    98.883     0.200
     6.841    99.805     0.200
     6.931    99.203     0.200
     6.931   103.402     0.200
     6.938   100.504     0.200
     7.092   101.602     0.200
     7.174   102.727     0.200
     7.162   104.102     0.200
     7.271   104.602     0.200
     7.291   104.504     0.200
     7.285   110.031     0.200
     7.470   106.504     0.200
     7.591   108.305     0.200
     7.637   112.930     0.200
     7.638   113.293     0.200
     7.933   116.789     0.200
     8.107   118.703     0.200
     8.137   118.504     0.200
     8.232   116.305     0.200
     8.549   120.504     0.200
     8.534   124.008     0.200
     8.550   123.305     0.200
     8.761   124.203     0.200
     8.929   126.004     0.200
     9.102   134.395     0.200
     9.184   133.184     0.200
     9.597   134.902     0.200
     9.604   135.004     0.200
     9.735   137.004     0.200
     9.879   139.602     0.200
     9.876   140.734     0.200
     9.963   140.504     0.200
     9.991   140.602     0.200
    10.182   143.602     0.200
     1.465    25.160     0.200
     1.481    26.289     0.200
     1.488    27.340     0.200
     1.550    26.891     0.200
     2.273    37.059     0.200
     2.442    39.621     0.200
     4.383    65.211     0.200
     4.717    69.781     0.200
     4.760    70.504     0.200
     4.788    71.980     0.200
     4.865    71.051     0.200
     4.899    72.258     0.200
     4.956    72.180     0.200
     5.000    75.059     0.200
     5.193    76.418     0.200
     5.257    76.121     0.200
     5.366    79.156     0.200
     5.486    81.457     0.200
     5.519    80.668     0.200
     5.673    83.301     0.200
     5.730    83.801     0.200
     5.869    86.770     0.200
     6.090    89.945     0.200
     6.115    89.438     0.200
     6.173    91.160     0.200
     6.197    91.105     0.200
     7.512   112.680     0.200
     8.223   115.980     0.200
     8.538   120.180     0.200
     8.748   124.180     0.200
     8.917   125.980     0.200
     9.870   138.781     0.200
     0.923    17.344     0.200
     1.017    18.902     0.200
     1.044    19.262     0.200
     1.212    22.012     0.200
     1.234    22.863     0.200
     1.723    29.254     0.200
     1.989    32.484     0.200
     2.199    34.652     0.200
     2.431    39.562     0.200
     2.431    39.434     0.200
     2.483    38.664     0.200
     2.705    43.004     0.200
     2.775    44.262     0.200
     2.776    44.062     0.200
     2.981    46.961     0.200
     3.056    46.863     0.200
     3.205    49.961     0.200
     3.245    49.391     0.200
     3.311    51.461     0.200
     3.359    52.961     0.200
     3.615    57.762     0.200
     3.771    58.562     0.200
     3.861    59.461     0.200
     3.890    59.262     0.200
     4.018    61.562     0.200
     4.075    62.863     0.200
     4.141    64.062     0.200
     4.300    64.973     0.200
     4.393    68.312     0.200
     4.499    67.262     0.200
     4.715    72.863     0.200
     4.742    70.164     0.200
     5.084    77.762     0.200
     5.100    77.262     0.200
     5.121    77.562     0.200
     5.127    77.562     0.200
     5.215    78.863     0.200
     5.273    79.664     0.200
     5.280    79.762     0.200
     5.443    81.562     0.200
     5.480    82.562     0.200
     5.692    85.562     0.200
     5.825    87.562     0.200
     6.003    90.461     0.200
     6.138    91.961     0.200
     6.138    91.961     0.200
     6.509    96.961     0.200
     7.394   105.227     0.200
     7.498   110.262     0.200
     9.942   143.328     0.200
     1.664    29.898     0.200
     1.793    31.461     0.200
     1.792    31.664     0.200
     1.873    33.594     0.200
     1.884    32.758     0.200
     1.891    32.438     0.200
     1.975    33.602     0.200
     2.075    34.781     0.200
     2.115    35.414     0.200
     2.240    36.938     0.200
     2.242    36.977     0.200
     2.277    38.602     0.200
     2.455    39.664     0.200
     2.471    39.617     0.200
     2.480    41.000     0.200
     2.531    42.211     0.200
     2.632    43.461     0.200
     2.696    45.039     0.200
     2.684    43.508     0.200
     2.785    44.508     0.200
     2.837    46.750     0.200
     2.857    48.188     0.200
     2.857    47.977     0.200
     2.948    48.141     0.200
     2.997    48.422     0.200
     2.997    48.617     0.200
     3.028    47.672     0.200
     3.010    48.422     0.200
     3.010    48.820     0.200
     3.076    49.219     0.200
     3.076    48.852     0.200
     3.035    49.500     0.200
     3.099    49.492     0.200
     3.190    51.469     0.200
     3.201    52.102     0.200
     3.212    50.250     0.200
     3.197    52.117     0.200
     3.197    51.422     0.200
     3.260    53.570     0.200
     3.261    52.219     0.200
     3.250    51.227     0.200
     3.250    51.891     0.200
     3.338    53.320     0.200
     3.389    55.820     0.200
     3.415    53.641     0.200
     3.429    53.727     0.200
     3.413    53.914     0.200
     3.431    54.617     0.200
     3.482    56.383     0.200
     3.452    54.820     0.200
     3.452    54.922     0.200
     3.468    55.117     0.200
     3.474    55.219     0.200
     3.515    55.031     0.200
     3.551    56.477     0.200
     3.551    56.617     0.200
     3.551    57.133     0.200
     3.551    56.297     0.200
     3.551    56.320     0.200
     3.568    57.820     0.200
     3.568    56.523     0.200
     3.708    58.117     0.200
     3.708    60.844     0.200
     3.708    60.023     0.200
     3.755    60.617     0.200
     3.787    59.133     0.200
     3.783    60.711     0.200
     3.844    60.523     0.200
     3.823    61.062     0.200
     3.823    59.641     0.200
     3.849    60.422     0.200
     3.892    63.523     0.200
     3.929    62.391     0.200
     3.929    62.617     0.200
     3.929    61.477     0.200
     3.929    61.922     0.200
     3.942    61.719     0.200
     4.062    63.117     0.200
     4.059    66.172     0.200
     4.119    63.250     0.200
     4.095    63.820     0.200
     4.120    64.219     0.200
     4.128    65.633     0.200
     4.202    65.023     0.200
     4.209    65.320     0.200
     4.209    66.117     0.200
     4.323    66.523     0.200
     4.327    66.219     0.200
     4.306    67.523     0.200
     4.315    67.773     0.200
     4.353    67.203     0.200
     4.391    65.781     0.200
     4.397    67.719     0.200
     4.418    67.492     0.200
     4.395    67.922     0.200
     4.395    68.062     0.200
     4.471    68.242     0.200
     4.505    68.922     0.200
     4.505    69.289     0.200
     4.502    65.500     0.200
     4.502    66.719     0.200
     4.550    70.023     0.200
     4.677    71.078     0.200
     4.654    72.289     0.200
     4.692    71.820     0.200
     4.692    71.922     0.200
     4.692    71.117     0.200
     4.729    71.961     0.200
     4.725    73.617     0.200
     4.725    73.898     0.200
     4.732    73.719     0.200
     4.775    71.891     0.200
     4.805    71.461     0.200
     4.775    73.523     0.200
     4.857    73.930     0.200
     4.970    74.844     0.200
     4.970    75.109     0.200
     5.002    74.023     0.200
     5.012    75.797     0.200
     4.976    77.422     0.200
     5.012    76.320     0.200
     5.043    76.438     0.200
     5.058    76.867     0.200
     5.058    75.453     0.200
     5.052    76.820     0.200
     5.082    77.523     0.200
     5.115    79.391     0.200
     5.101    78.141     0.200
     5.140    76.562     0.200
     5.141    78.148     0.200
     5.146    76.703     0.200
     5.137    78.719     0.200
     5.137    78.242     0.200
     5.190    78.422     0.200
     5.222    78.273     0.200
     5.222    78.117     0.200
     5.222    78.422     0.200
     5.268    79.281     0.200
     5.343    82.320     0.200
     5.429    80.695     0.200
     5.496    83.008     0.200
     5.496    81.820     0.200
     5.537    84.219     0.200
     5.617    85.867     0.200
     5.617    85.695     0.200
     5.746    85.266     0.200
     5.746    85.375     0.200
     5.798    86.617     0.200
     5.771    87.422     0.200
     5.876    87.719     0.200
     5.915    88.617     0.200
     5.949    89.820     0.200
     5.962    89.258     0.200
     6.001    88.242     0.200
     6.037    90.117     0.200
     6.055    91.023     0.200
     6.116    92.250     0.200
     6.116    92.445     0.200
     6.075    92.922     0.200
     6.101    90.945     0.200
     6.159    93.844     0.200
     6.191    93.109     0.200
     6.184    92.719     0.200
     6.163    92.523     0.200
     6.198    92.938     0.200
     6.237    91.820     0.200
     6.261    93.117     0.200
     6.281    92.617     0.200
     6.294    93.516     0.200
     6.317    93.891     0.200
     6.317    93.750     0.200
     6.334    96.203     0.200
     6.309    96.023     0.200
     6.383    96.422     0.200
     6.392    95.531     0.200
     6.448    94.422     0.200
     6.460    96.867     0.200
     6.460    95.609     0.200
     6.460    96.320     0.200
     6.500    96.023     0.200
     6.562    98.320     0.200
     6.582    99.117     0.200
     6.557    98.055     0.200
     6.588    97.602     0.200
     6.678   100.242     0.200
     6.682    99.102     0.200
     6.773   100.023     0.200
     6.790   101.047     0.200
     6.797   100.922     0.200
     6.941   102.016     0.200
     6.990   103.523     0.200
     7.059   104.430     0.200
     7.085   106.219     0.200
     7.106   106.117     0.200
     7.126   106.922     0.200
     7.126   106.281     0.200
     7.165   105.891     0.200
     7.124   105.383     0.200
     7.237   110.523     0.200
     7.286   106.320     0.200
     7.337   106.508     0.200
     7.337   105.992     0.200
     7.337   105.664     0.200
     7.392   108.977     0.200
     7.392   107.000     0.200
     7.392   109.219     0.200
     7.392   108.719     0.200
     7.562   111.117     0.200
     7.613   110.898     0.200
     7.624   113.523     0.200
     7.635   111.547     0.200
     7.630   109.922     0.200
     7.630   109.500     0.200
     7.626   112.719     0.200
     7.707   111.867     0.200
     7.699   113.766     0.200
     7.821   115.438     0.200
     7.890   116.383     0.200
     7.890   114.867     0.200
     7.890   116.117     0.200
     7.977   116.523     0.200
     8.004   118.023     0.200
     8.081   121.117     0.200
     8.133   118.883     0.200
     8.133   117.477     0.200
     8.161   118.523     0.200
     8.140   120.023     0.200
     8.188   121.008     0.200
     8.250   120.398     0.200
     8.327   122.023     0.200
     8.334   123.922     0.200
     8.377   121.023     0.200
     8.452   123.219     0.200
     8.485   124.922     0.200
     8.485   124.422     0.200
     8.485   122.828     0.200
     8.499   121.688     0.200
     8.498   123.008     0.200
     8.530   122.133     0.200
     8.508   125.008     0.200
     8.629   123.523     0.200
     8.619   124.609     0.200
     8.667   126.922     0.200
     8.750   126.219     0.200
     8.741   127.289     0.200
     8.792   130.422     0.200
     8.891   129.922     0.200
     8.896   130.375     0.200
     8.946   131.344     0.200
     8.972   130.641     0.200
     9.007   129.703     0.200
     9.086   131.922     0.200
     9.105   132.023     0.200
     9.111   133.516     0.200
     9.111   131.703     0.200
     9.251   135.570     0.200
     9.347   133.688     0.200
     9.350   135.320     0.200
     9.433   135.922     0.200
     9.531   137.117     0.200
     9.608   138.523     0.200
     9.661   139.523     0.200
     9.681   141.617     0.200
     9.721   139.617     0.200
     9.703   141.320     0.200
     9.762   140.523     0.200
     9.760   142.117     0.200
     9.786   141.320     0.200
     9.838   140.820     0.200
     9.838   140.438     0.200
     9.862   142.820     0.200
     9.866   142.367     0.200
    10.004   145.812     0.200
    10.148   147.023     0.200
    10.172   147.648     0.200
    10.265   149.023     0.200
    13.625   193.680     0.200
    13.625   193.414     0.200
    13.625   192.859     0.200
    14.259   202.117     0.200
    14.261   201.961     0.200
    14.261   202.711     0.200
    14.540   205.953     0.200
    14.540   208.023     0.200
    14.540   204.109     0.200
    14.580   205.000     0.200
    15.259   213.961     0.200
    15.350   215.953     0.200
    16.418   229.102     0.200
    17.975   249.477     0.200
    18.550   260.086     0.200
    18.629   258.086     0.200
    19.641   269.117     0.200
    19.810   271.367     0.200
    20.065   276.445     0.200
    20.264   278.594     0.200
    20.863   283.367     0.200
     1.070    19.938     0.200
     1.168    21.516     0.200
     1.228    24.328     0.200
     1.244    23.156     0.200
     1.369    25.406     0.200
     1.435    25.992     0.200
     1.497    27.281     0.200
     1.522    27.508     0.200
     1.554    27.578     0.200
     1.556    27.016     0.200
     1.562    28.164     0.200
     1.622    28.102     0.200
     1.903    32.266     0.200
     2.103    35.734     0.200
     2.142    34.797     0.200
     2.263    36.758     0.200
     2.330    39.172     0.200
     2.478    39.375     0.200
     2.490    38.867     0.200
     2.660    43.195     0.200
     2.712    43.312     0.200
     2.811    44.484     0.200
     3.025    47.227     0.200
     3.025    47.422     0.200
     3.046    47.055     0.200
     3.121    48.656     0.200
     3.229    49.227     0.200
     3.415    56.328     0.200
     3.441    52.914     0.200
     3.435    52.898     0.200
     3.478    54.328     0.200
     3.529    53.781     0.200
     3.578    55.727     0.200
     3.578    56.023     0.200
     3.734    59.922     0.200
     3.734    58.023     0.200
     3.868    61.727     0.200
     3.952    61.922     0.200
     4.090    62.727     0.200
     4.139    63.281     0.200
     4.218    65.023     0.200
     4.238    65.422     0.200
     4.238    64.023     0.200
     4.305    66.328     0.200
     4.346    66.023     0.200
     4.333    65.523     0.200
     4.376    65.328     0.200
     4.492    68.297     0.200
     4.521    70.422     0.200
     4.578    68.727     0.200
     4.720    71.227     0.200
     4.720    71.625     0.200
     4.986    74.180     0.200
     5.041    75.422     0.200
     5.109    76.523     0.200
     5.250    77.523     0.200
     5.522    81.625     0.200
     5.784    86.828     0.200
     5.941    87.523     0.200
     6.197    93.508     0.200
     6.190    92.227     0.200
     6.265    92.227     0.200
     6.263    93.359     0.200
     6.332    93.898     0.200
     6.467    95.328     0.200
     6.486    96.227     0.200
     6.571    98.227     0.200
     7.301   105.625     0.200
     7.352   105.969     0.200
     7.585   111.125     0.200
     7.644   111.828     0.200
     7.910   113.773     0.200
     8.629   122.328     0.200
     9.760   141.828     0.200
     1.022    19.540     0.200
     0.969    18.710     0.200
     1.014    19.750     0.200
     1.164    22.050     0.200
     1.228    22.950     0.200
     1.228    23.120     0.200
     1.346    24.730     0.200
     1.615    28.280     0.200
     1.786    30.540     0.200
     1.898    32.380     0.200
     1.982    33.770     0.200
     2.081    34.780     0.200
     2.120    35.030     0.200
     2.242    36.010     0.200
     2.457    39.160     0.200
     2.472    38.990     0.200
     2.639    42.950     0.200
     2.690    43.100     0.200
     3.028    46.850     0.200
     3.005    48.350     0.200
     3.005    48.050     0.200
     3.017    48.450     0.200
     3.212    49.580     0.200
     3.392    56.350     0.200
     3.427    52.100     0.200
     3.416    52.980     0.200
     3.460    53.850     0.200
     3.513    53.420     0.200
     3.559    56.050     0.200
     3.559    56.250     0.200
     3.712    60.050     0.200
     3.712    60.350     0.200
     3.787    57.610     0.200
     3.847    61.750     0.200
     3.937    62.950     0.200
     4.068    62.850     0.200
     4.120    62.480     0.200
     4.201    65.650     0.200
     4.216    65.650     0.200
     4.216    66.050     0.200
     4.315    66.650     0.200
     4.327    65.450     0.200
     4.313    66.850     0.200
     4.355    66.060     0.200
     4.557    70.250     0.200
     4.698    71.250     0.200
     4.698    71.550     0.200
     4.970    74.607     0.200
     5.019    75.750     0.200
     5.059    76.550     0.200
     5.089    76.450     0.200
     5.228    77.550     0.200
     5.500    82.150     0.200
     5.923    87.850     0.200
     6.187    92.877     0.200
     6.273    91.650     0.200
     6.316    93.250     0.200
     6.449    94.017     0.200
     6.575    99.850     0.200
     6.962   101.650     0.200
     7.230   108.950     0.200
     7.336   106.225     0.200
     7.564   110.750     0.200
     7.629   111.550     0.200
     8.371   120.250     0.200
     8.624   123.750     0.200
     8.745   125.250     0.200
     9.427   133.750     0.200
     0.961    18.945     0.200
     1.002    19.227     0.200
     1.150    21.984     0.200
     1.241    24.078     0.200
     2.074    35.836     0.200
     2.116    35.602     0.200
     2.243    37.586     0.200
     2.458    40.031     0.200
     2.475    39.523     0.200
     2.631    43.328     0.200
     2.685    43.602     0.200
     2.995    48.172     0.200
     2.995    48.477     0.200
     3.007    48.375     0.200
     3.033    47.531     0.200
     3.103    49.203     0.200
     3.217    49.906     0.200
     3.391    56.078     0.200
     3.418    53.812     0.200
     3.434    52.914     0.200
     3.449    54.578     0.200
     3.520    53.922     0.200
     3.548    55.977     0.200
     3.548    56.172     0.200
     3.710    60.172     0.200
     3.710    60.375     0.200
     3.846    60.672     0.200
     4.060    63.273     0.200
     4.123    63.906     0.200
     4.207    65.172     0.200
     4.209    65.578     0.200
     4.209    65.977     0.200
     4.304    66.875     0.200
     4.329    66.172     0.200
     4.331    66.578     0.200
     4.356    66.742     0.200
     4.475    67.914     0.200
     4.548    69.773     0.200
     4.691    71.578     0.200
     4.733    72.086     0.200
     4.975    75.344     0.200
     5.079    76.273     0.200
     5.147    79.367     0.200
     5.151    75.938     0.200
     5.476    82.172     0.200
     5.498    82.578     0.200
     5.623    86.094     0.200
     5.750    85.367     0.200
     6.122    94.406     0.200
     6.165    90.914     0.200
     6.197    92.609     0.200
     6.204    93.297     0.200
     6.267    94.047     0.200
     6.287    95.078     0.200
     6.322    94.641     0.200
     6.340    94.062     0.200
     6.452    94.578     0.200
     6.588    98.977     0.200
     7.111   105.977     0.200
     7.243   108.578     0.200
     7.343   106.125     0.200
     7.564   111.875     0.200
     7.635   112.078     0.200
     1.016    19.312     0.200
     1.164    21.930     0.200
     1.168    21.633     0.200
     1.243    23.156     0.200
     1.504    27.680     0.200
     1.530    27.789     0.200
     1.801    31.055     0.200
     1.801    31.297     0.200
     1.899    32.617     0.200
     1.986    34.336     0.200
     1.946    34.312     0.200
     1.982    33.617     0.200
     2.038    34.164     0.200
     2.077    35.859     0.200
     2.116    36.312     0.200
     2.119    35.828     0.200
     2.116    34.844     0.200
     2.238    35.883     0.200
     2.249    37.367     0.200
     2.321    39.445     0.200
     2.321    38.812     0.200
     2.285    39.594     0.200
     2.410    39.828     0.200
     2.453    39.125     0.200
     2.467    39.086     0.200
     2.503    40.867     0.200
     2.523    41.148     0.200
     2.525    41.945     0.200
     2.549    42.227     0.200
     2.635    43.312     0.200
     2.686    42.938     0.200
     2.784    44.695     0.200
     2.870    47.484     0.200
     2.865    45.336     0.200
     3.024    47.086     0.200
     3.002    48.156     0.200
     3.002    48.258     0.200
     3.014    48.156     0.200
     3.068    48.773     0.200
     3.096    49.133     0.200
     3.208    49.586     0.200
     3.201    51.258     0.200
     3.388    54.555     0.200
     3.411    52.883     0.200
     3.423    52.500     0.200
     3.458    53.953     0.200
     3.509    53.445     0.200
     3.556    55.320     0.200
     3.556    55.859     0.200
     3.556    56.305     0.200
     3.707    58.859     0.200
     3.707    59.055     0.200
     3.782    58.484     0.200
     3.842    62.156     0.200
     3.936    59.953     0.200
     4.065    63.055     0.200
     4.116    62.680     0.200
     4.212    65.555     0.200
     4.212    65.656     0.200
     4.316    66.258     0.200
     4.323    65.453     0.200
     4.310    67.453     0.200
     4.350    65.430     0.200
     4.468    68.117     0.200
     4.500    67.953     0.200
     4.553    69.656     0.200
     4.661    72.914     0.200
     4.695    71.453     0.200
     4.695    71.859     0.200
     4.695    70.953     0.200
     4.726    70.438     0.200
     4.733    72.359     0.200
     4.966    74.422     0.200
     5.004    75.367     0.200
     4.984    77.359     0.200
     5.015    75.953     0.200
     5.055    75.555     0.200
     5.086    76.453     0.200
     5.133    76.734     0.200
     5.136    77.242     0.200
     5.142    75.883     0.200
     5.144    78.258     0.200
     5.189    78.680     0.200
     5.223    78.664     0.200
     5.223    76.555     0.200
     5.223    77.758     0.200
     5.423    80.148     0.200
     5.484    82.359     0.200
     5.561    81.906     0.200
     5.561    83.914     0.200
     5.611    84.148     0.200
     5.706    85.828     0.200
     5.742    84.578     0.200
     5.790    86.156     0.200
     5.883    87.453     0.200
     5.920    88.359     0.200
     6.042    90.055     0.200
     6.110    92.148     0.200
     6.104    91.133     0.200
     6.152    91.641     0.200
     6.184    93.172     0.200
     6.253    92.008     0.200
     6.273    91.758     0.200
     6.312    93.734     0.200
     6.327    94.859     0.200
     6.444    94.172     0.200
     6.502    95.688     0.200
     6.556    96.828     0.200
     6.591    97.289     0.200
     6.961   102.656     0.200
     6.982   102.555     0.200
     7.062   103.461     0.200
     7.098   104.758     0.200
     7.126   107.406     0.200
     7.229   106.156     0.200
     7.281   107.258     0.200
     7.332   105.703     0.200
     7.391   108.820     0.200
     7.391   108.945     0.200
     7.560   110.859     0.200
     7.625   111.656     0.200
     7.887   115.125     0.200
     7.996   115.055     0.200
     8.319   120.359     0.200
     8.369   120.555     0.200
     8.482   125.297     0.200
     8.664   127.359     0.200
     8.742   125.656     0.200
     8.887   130.859     0.200
     9.101   133.156     0.200
     9.114   134.625     0.200
     9.357   133.656     0.200
     9.425   135.453     0.200
     9.523   135.758     0.200
     9.600   136.859     0.200
     9.755   139.859     0.200
    13.626   193.844     0.200
    14.254   201.609     0.200
    18.557   260.477     0.200
     0.989    18.682     0.200
     1.022    19.182     0.200
     1.773    30.830     0.200
     1.870    31.881     0.200
     1.830    31.131     0.200
     1.888    32.221     0.200
     1.864    31.660     0.200
     1.908    32.311     0.200
     1.887    31.740     0.200
     2.014    34.721     0.200
     2.060    34.051     0.200
     2.095    35.012     0.200
     2.120    35.660     0.200
     2.125    35.682     0.200
     2.124    36.041     0.200
     2.240    37.070     0.200
     2.276    37.320     0.200
     2.270    37.590     0.200
     2.305    38.070     0.200
     2.318    37.250     0.200
     2.424    39.602     0.200
     2.424    39.021     0.200
     2.475    40.311     0.200
     2.528    41.021     0.200
     2.560    41.521     0.200
     2.590    42.531     0.200
     2.597    41.621     0.200
     2.632    42.740     0.200
     2.635    43.090     0.200
     2.650    43.031     0.200
     2.796    44.701     0.200
     2.815    44.602     0.200
     2.885    45.580     0.200
     2.887    48.018     0.200
     2.926    47.611     0.200
     2.994    48.701     0.200
     3.072    48.410     0.200
     3.188    52.201     0.200
     3.173    50.160     0.200
     3.249    51.490     0.200
     3.327    50.352     0.200
     3.362    53.801     0.200
     3.361    52.771     0.200
     3.396    52.221     0.200
     3.406    53.250     0.200
     3.510    56.000     0.200
     3.510    54.561     0.200
     3.600    57.541     0.200
     3.657    56.900     0.200
     3.652    57.000     0.200
     3.853    60.201     0.200
     3.916    59.201     0.200
     4.000    62.701     0.200
     4.072    61.801     0.200
     4.170    63.201     0.200
     4.169    63.580     0.200
     4.207    67.701     0.200
     4.238    65.500     0.200
     4.238    66.031     0.200
     4.304    66.250     0.200
     4.298    66.500     0.200
     4.341    66.471     0.200
     4.372    68.602     0.200
     4.443    68.400     0.200
     4.482    69.500     0.200
     4.482    68.830     0.200
     4.506    70.000     0.200
     4.600    69.131     0.200
     4.600    71.900     0.200
     4.686    71.801     0.200
     4.836    71.971     0.200
     4.836    73.062     0.200
     4.874    73.420     0.200
     4.946    73.590     0.200
     4.949    73.201     0.200
     4.987    77.900     0.200
     4.987    74.789     0.200
     5.002    74.945     0.200
     4.994    74.803     0.200
     4.985    75.801     0.200
     5.028    76.162     0.200
     5.012    76.766     0.200
     5.012    73.102     0.200
     4.997    76.400     0.200
     5.040    75.730     0.200
     5.115    75.740     0.200
     5.228    80.602     0.200
     5.296    78.602     0.200
     5.385    79.852     0.200
     5.408    83.102     0.200
     5.508    83.449     0.200
     5.488    84.762     0.200
     5.593    83.145     0.200
     5.624    84.900     0.200
     5.638    85.301     0.200
     5.818    86.156     0.200
     5.883    87.201     0.200
     5.841    88.301     0.200
     5.987    91.102     0.200
     6.042    92.643     0.200
     6.107    91.814     0.200
     6.124    92.674     0.200
     6.186    91.906     0.200
     6.161    93.602     0.200
     6.229    93.500     0.200
     6.269    94.693     0.200
     6.228    94.301     0.200
     6.291    92.686     0.200
     6.288    94.598     0.200
     6.276    93.082     0.200
     6.276    94.080     0.200
     6.294    94.801     0.200
     6.343    93.602     0.200
     6.307    95.102     0.200
     6.388    93.500     0.200
     6.379    96.010     0.200
     6.641   100.018     0.200
     6.648    97.900     0.200
     6.681   100.301     0.200
     6.718   100.617     0.200
     6.849   101.598     0.200
     7.014   102.102     0.200
     7.035   102.301     0.200
     7.154   103.500     0.200
     7.200   108.602     0.200
     7.214   104.977     0.200
     7.305   106.500     0.200
     7.342   107.602     0.200
     7.333   110.525     0.200
     7.374   108.500     0.200
     7.508   108.500     0.200
     7.490   111.193     0.200
     7.611   112.955     0.200
     8.004   115.801     0.200
     8.301   121.691     0.200
     8.371   120.301     0.200
     8.607   123.602     0.200
     8.747   125.500     0.200
     8.904   129.027     0.200
     8.904   128.621     0.200
     9.470   138.693     0.200
     9.496   137.949     0.200
     9.552   137.930     0.200
    10.122   146.580     0.200
    19.517   268.512     0.200
     1.024    19.348     0.200
     1.037    19.527     0.200
     1.013    19.117     0.200
     1.240    22.625     0.200
     1.304    24.016     0.200
     1.500    27.266     0.200
     1.527    27.906     0.200
     1.646    29.145     0.200
     1.798    30.996     0.200
     1.980    33.066     0.200
     2.079    35.336     0.200
     2.118    35.066     0.200
     2.118    35.305     0.200
     2.241    36.598     0.200
     2.456    38.855     0.200
     2.471    38.836     0.200
     2.484    40.027     0.200
     2.637    42.027     0.200
     2.637    42.984     0.200
     2.637    42.227     0.200
     2.688    42.566     0.200
     2.769    43.566     0.200
     2.787    44.305     0.200
     3.002    47.824     0.200
     3.028    46.977     0.200
     3.015    47.227     0.200
     3.015    48.125     0.200
     3.100    48.504     0.200
     3.138    50.027     0.200
     3.212    49.527     0.200
     3.202    50.426     0.200
     3.202    50.926     0.200
     3.267    51.824     0.200
     3.344    52.625     0.200
     3.391    55.426     0.200
     3.415    52.246     0.200
     3.427    51.867     0.200
     3.436    54.227     0.200
     3.458    54.027     0.200
     3.458    54.426     0.200
     3.474    54.727     0.200
     3.513    52.785     0.200
     3.549    54.035     0.200
     3.556    55.727     0.200
     3.556    55.926     0.200
     3.573    56.125     0.200
     3.710    59.824     0.200
     3.854    59.926     0.200
     4.031    59.324     0.200
     4.066    61.727     0.200
     4.119    62.016     0.200
     4.126    63.727     0.200
     4.201    63.426     0.200
     4.214    65.324     0.200
     4.317    66.324     0.200
     4.327    64.926     0.200
     4.354    66.227     0.200
     4.472    67.484     0.200
     4.497    67.305     0.200
     4.542    68.805     0.200
     4.660    72.395     0.200
     4.696    71.227     0.200
     4.696    71.367     0.200
     4.775    70.617     0.200
     5.146    77.152     0.200
     5.192    78.637     0.200
     5.454    82.645     0.200
     5.498    81.926     0.200
     5.498    82.938     0.200
     5.661    86.566     0.200
     5.792    86.027     0.200
     6.237    92.324     0.200
     6.257    93.035     0.200
     6.275    92.824     0.200
     6.315    91.797     0.200
     6.448    95.215     0.200
     7.123   105.652     0.200
     7.336   105.398     0.200
     7.563   110.926     0.200
     7.629   111.625     0.200
     8.625   123.527     0.200
     8.746   126.027     0.200
     1.040    20.281     0.200
     1.016    19.180     0.200
     1.020    19.195     0.200
     1.030    19.430     0.200
     1.038    19.469     0.200
     1.044    19.352     0.200
     1.407    24.352     0.200
     1.441    24.602     0.200
     1.489    25.258     0.200
     1.502    25.930     0.200
     1.543    26.930     0.200
     1.616    27.117     0.200
     1.654    27.797     0.200
     1.663    28.117     0.200
     1.724    29.070     0.200
     1.767    29.336     0.200
     1.828    31.258     0.200
     1.779    29.578     0.200
     1.777    29.461     0.200
     1.823    30.016     0.200
     1.839    30.711     0.200
     1.875    30.977     0.200
     1.926    32.117     0.200
     1.917    31.531     0.200
     2.171    35.016     0.200
     2.234    36.625     0.200
     2.347    38.617     0.200
     2.347    38.992     0.200
     2.346    36.297     0.200
     2.346    36.055     0.200
     2.346    36.492     0.200
     2.374    38.156     0.200
     2.398    38.195     0.200
     2.459    39.641     0.200
     2.464    40.102     0.200
     2.477    41.250     0.200
     2.698    44.258     0.200
     2.729    42.898     0.200
     2.773    42.805     0.200
     2.758    43.898     0.200
     2.758    44.000     0.200
     2.811    44.867     0.200
     2.823    45.398     0.200
     2.961    45.688     0.200
     2.922    47.000     0.200
     2.922    46.102     0.200
     3.040    48.445     0.200
     3.080    49.688     0.200
     3.023    47.898     0.200
     3.078    49.500     0.200
     3.086    48.695     0.200
     3.134    48.625     0.200
     3.224    51.070     0.200
     3.167    49.898     0.200
     3.225    49.000     0.200
     3.209    50.695     0.200
     3.223    50.398     0.200
     3.223    50.695     0.200
     3.254    50.797     0.200
     3.286    51.695     0.200
     3.308    51.961     0.200
     3.308    51.102     0.200
     3.308    51.695     0.200
     3.399    53.195     0.200
     3.399    53.695     0.200
     3.547    54.305     0.200
     3.541    54.695     0.200
     3.588    56.500     0.200
     3.661    57.102     0.200
     3.723    57.000     0.200
     3.810    57.289     0.200
     3.772    57.797     0.200
     3.822    57.195     0.200
     3.848    59.305     0.200
     3.849    59.297     0.200
     3.862    60.102     0.200
     3.914    59.602     0.200
     4.013    60.695     0.200
     4.054    61.008     0.200
     4.190    62.508     0.200
     4.293    63.930     0.200
     4.304    64.641     0.200
     4.446    67.297     0.200
     4.397    65.297     0.200
     4.485    66.422     0.200
     4.661    69.055     0.200
     4.679    71.461     0.200
     4.726    70.500     0.200
     4.726    70.180     0.200
     4.759    70.492     0.200
     4.853    71.188     0.200
     4.859    71.148     0.200
     4.860    72.547     0.200
     4.889    72.328     0.200
     4.882    75.891     0.200
     4.923    73.391     0.200
     4.968    73.492     0.200
     4.962    73.375     0.200
     5.052    74.102     0.200
     5.147    76.242     0.200
     5.185    79.797     0.200
     5.244    77.211     0.200
     5.313    78.227     0.200
     5.347    80.172     0.200
     5.479    80.117     0.200
     5.703    84.055     0.200
     5.863    87.000     0.200
     5.806    85.703     0.200
     5.890    90.273     0.200
     5.948    88.656     0.200
     5.969    87.734     0.200
     6.021    90.219     0.200
     5.994    87.547     0.200
     6.030    90.023     0.200
     6.035    90.492     0.200
     6.019    90.102     0.200
     6.151    90.695     0.200
     6.178    91.875     0.200
     6.177    89.742     0.200
     6.229    92.914     0.200
     6.296    92.938     0.200
     6.381    93.797     0.200
     6.496    95.797     0.200
     6.559    98.477     0.200
     6.616    98.102     0.200
     6.595    99.898     0.200
     6.762    99.062     0.200
     6.797   100.102     0.200
     6.972    99.000     0.200
     6.993    98.898     0.200
     7.043   101.297     0.200
     7.106   102.422     0.200
     7.185   105.398     0.200
     7.275   107.500     0.200
     7.260   105.398     0.200
     7.350   105.102     0.200
     7.400   106.398     0.200
     7.439   111.148     0.200
     7.614   110.945     0.200
     7.614   109.195     0.200
     8.221   118.625     0.200
     8.303   117.102     0.200
     8.681   122.602     0.200
     8.826   127.008     0.200
     9.856   142.695     0.200
     9.878   137.195     0.200
    10.177   146.898     0.200
    10.166   144.555     0.200
    18.384   255.000     0.200
     1.005    18.820     0.200
     1.007    19.164     0.200
     1.162    21.469     0.200
     1.198    22.180     0.200
     1.244    23.109     0.200
     1.264    23.531     0.200
     1.295    23.992     0.200
     1.304    23.883     0.200
     1.303    24.289     0.200
     1.355    24.430     0.200
     1.370    24.273     0.200
     1.411    25.109     0.200
     1.469    25.859     0.200
     1.574    27.953     0.200
     1.572    27.852     0.200
     1.999    32.703     0.200
     2.146    34.453     0.200
     2.438    39.188     0.200
     2.779    44.328     0.200
     2.781    43.734     0.200
     2.987    47.133     0.200
     3.022    47.133     0.200
     3.108    48.531     0.200
     3.207    50.234     0.200
     3.314    52.680     0.200
     3.314    51.930     0.200
     3.365    53.031     0.200
     3.477    55.281     0.200
     3.624    57.133     0.200
     3.627    57.930     0.200
     3.858    60.734     0.200
     3.893    61.133     0.200
     3.898    60.828     0.200
     4.013    61.102     0.200
     4.013    60.828     0.200
     4.025    62.234     0.200
     4.090    61.734     0.200
     4.343    65.734     0.200
     4.506    68.094     0.200
     4.587    69.328     0.200
     4.824    72.234     0.200
     4.849    72.930     0.200
     4.856    72.531     0.200
     5.024    74.641     0.200
     5.035    74.203     0.200
     5.034    74.742     0.200
     5.075    75.531     0.200
     5.180    76.781     0.200
     5.183    75.438     0.200
     5.247    77.938     0.200
     5.323    78.398     0.200
     5.594    82.484     0.200
     5.707    85.922     0.200
     5.820    86.234     0.200
     5.931    88.031     0.200
     6.249    93.156     0.200
     6.316    94.352     0.200
     6.331    94.414     0.200
     6.334    92.156     0.200
     6.376    93.203     0.200
     6.477    96.625     0.200
     6.543    95.531     0.200
     8.576   120.734     0.200
     8.815   125.328     0.200
     8.952   126.031     0.200
     9.741   136.234     0.200
     0.930    18.273     0.200
     0.935    18.641     0.200
     0.954    18.219     0.200
     1.011    18.922     0.200
     1.015    19.164     0.200
     1.040    19.562     0.200
     1.236    23.172     0.200
     1.208    22.422     0.200
     1.214    23.164     0.200
     1.290    24.219     0.200
     1.297    23.914     0.200
     1.566    28.070     0.200
     1.568    27.523     0.200
     1.552    27.398     0.200
     1.682    28.695     0.200
     1.650    28.398     0.200
     1.760    30.148     0.200
     1.722    29.219     0.200
     1.993    32.859     0.200
     2.109    35.070     0.200
     2.295    37.914     0.200
     2.299    38.234     0.200
     2.305    37.492     0.200
     2.397    40.539     0.200
     2.434    39.141     0.200
     2.504    40.914     0.200
     2.560    42.312     0.200
     2.680    43.992     0.200
     2.724    43.930     0.200
     2.779    43.742     0.200
     2.779    44.039     0.200
     2.778    43.641     0.200
     2.778    43.539     0.200
     2.954    48.336     0.200
     2.984    47.141     0.200
     3.022    48.242     0.200
     3.021    47.445     0.200
     3.106    48.539     0.200
     3.184    50.539     0.200
     3.206    50.242     0.200
     3.207    49.539     0.200
     3.207    50.039     0.200
     3.217    50.539     0.200
     3.293    51.242     0.200
     3.313    51.445     0.200
     3.362    53.242     0.200
     3.362    53.344     0.200
     3.529    55.953     0.200
     3.619    56.539     0.200
     3.623    56.641     0.200
     3.733    58.344     0.200
     3.777    58.242     0.200
     3.873    59.969     0.200
     3.857    60.641     0.200
     3.864    59.141     0.200
     3.893    60.742     0.200
     3.893    60.539     0.200
     3.891    61.344     0.200
     4.004    60.445     0.200
     4.021    62.242     0.200
     4.021    62.039     0.200
     4.042    61.742     0.200
     4.103    60.039     0.200
     4.088    63.539     0.200
     4.088    64.344     0.200
     4.254    64.344     0.200
     4.334    64.742     0.200
     4.340    65.945     0.200
     4.393    68.445     0.200
     4.502    68.141     0.200
     4.502    68.242     0.200
     4.509    69.844     0.200
     4.583    69.641     0.200
     4.820    72.445     0.200
     4.846    72.844     0.200
     4.854    72.539     0.200
     5.015    74.125     0.200
     5.015    73.445     0.200
     5.069    75.039     0.200
     5.173    75.797     0.200
     5.216    78.836     0.200
     5.240    78.141     0.200
     5.374    79.742     0.200
     5.397    79.242     0.200
     5.399    82.820     0.200
     5.537    81.133     0.200
     5.697    83.867     0.200
     5.668    83.641     0.200
     5.759    83.930     0.200
     5.817    85.344     0.200
     5.930    88.039     0.200
     6.046    90.344     0.200
     6.240    93.805     0.200
     6.262    92.750     0.200
     6.265    92.828     0.200
     6.307    92.508     0.200
     6.325    93.070     0.200
     6.366    93.891     0.200
     6.454    93.797     0.200
     6.468    96.148     0.200
     6.538    96.242     0.200
     6.841   101.289     0.200
     7.332   107.445     0.200
     7.358   108.844     0.200
     7.398   106.039     0.200
     7.478   109.844     0.200
     7.502   108.742     0.200
     8.568   120.641     0.200
     8.807   123.844     0.200
     8.944   125.742     0.200
     9.526   134.141     0.200
     9.624   134.742     0.200
     9.829   137.445     0.200
     9.890   139.242     0.200
     9.930   139.242     0.200
     9.958   139.242     0.200
     1.024    18.193     0.200
     1.081    19.044     0.200
     1.143    19.903     0.200
     1.153    20.394     0.200
     1.196    22.504     0.200
     1.142    20.204     0.200
     1.232    21.443     0.200
     1.224    21.063     0.200
     1.213    21.124     0.200
     1.356    23.704     0.200
     1.354    23.104     0.200
     1.410    23.974     0.200
     1.413    23.613     0.200
     1.439    24.004     0.200
     1.440    23.974     0.200
     1.447    24.474     0.200
     1.450    24.464     0.200
     1.401    23.761     0.200
     1.460    24.174     0.200
     1.460    24.313     0.200
     1.449    24.474     0.200
     1.485    25.034     0.200
     1.534    25.063     0.200
     1.588    26.264     0.200
     1.580    25.744     0.200
     1.577    26.514     0.200
     1.592    25.813     0.200
     1.692    28.323     0.200
     1.678    27.483     0.200
     1.701    27.744     0.200
     1.676    27.113     0.200
     1.728    27.754     0.200
     1.796    28.604     0.200
     1.753    28.604     0.200
     1.905    30.794     0.200
     1.865    30.523     0.200
     1.868    31.204     0.200
     1.919    31.233     0.200
     1.993    33.004     0.200
     1.997    32.844     0.200
     1.943    31.834     0.200
     2.005    31.804     0.200
     1.975    32.983     0.200
     2.029    32.514     0.200
     2.108    34.354     0.200
     2.132    33.844     0.200
     2.155    35.394     0.200
     2.164    34.983     0.200
     2.099    33.903     0.200
     2.179    35.823     0.200
     2.111    34.104     0.200
     2.111    34.204     0.200
     2.194    35.764     0.200
     2.194    36.044     0.200
     2.199    35.863     0.200
     2.202    35.994     0.200
     2.207    36.124     0.200
     2.193    34.204     0.200
     2.194    35.403     0.200
     2.305    37.134     0.200
     2.241    36.874     0.200
     2.323    36.674     0.200
     2.366    38.294     0.200
     2.303    36.604     0.200
     2.303    36.903     0.200
     2.333    36.644     0.200
     2.408    39.184     0.200
     2.428    38.304     0.200
     2.369    38.004     0.200
     2.455    38.863     0.200
     2.434    39.403     0.200
     2.482    39.624     0.200
     2.487    38.604     0.200
     2.511    39.724     0.200
     2.440    38.903     0.200
     2.551    41.304     0.200
     2.503    39.983     0.200
     2.519    40.704     0.200
     2.531    40.104     0.200
     2.649    41.403     0.200
     2.567    41.004     0.200
     2.567    40.804     0.200
     2.664    42.863     0.200
     2.598    40.903     0.200
     2.667    42.724     0.200
     2.699    42.764     0.200
     2.707    42.684     0.200
     2.680    42.403     0.200
     2.656    42.308     0.200
     2.656    41.464     0.200
     2.656    42.004     0.200
     2.680    42.604     0.200
     2.680    42.104     0.200
     2.732    44.204     0.200
     2.775    43.974     0.200
     2.788    43.483     0.200
     2.780    42.834     0.200
     2.798    44.164     0.200
     2.715    42.284     0.200
     2.816    44.693     0.200
     2.834    43.983     0.200
     2.783    43.670     0.200
     2.783    44.344     0.200
     2.783    43.994     0.200
     2.871    45.063     0.200
     2.875    45.813     0.200
     2.891    46.063     0.200
     2.904    45.464     0.200
     2.912    45.224     0.200
     2.929    46.084     0.200
     2.936    46.014     0.200
     2.974    47.874     0.200
     3.025    47.214     0.200
     2.949    45.903     0.200
     3.019    46.784     0.200
     3.076    48.464     0.200
     3.067    48.384     0.200
     3.067    46.504     0.200
     3.051    47.204     0.200
     3.167    49.284     0.200
     3.169    49.164     0.200
     3.169    49.744     0.200
     3.192    50.744     0.200
     3.116    48.426     0.200
     3.116    48.184     0.200
     3.220    50.594     0.200
     3.183    48.804     0.200
     3.198    49.403     0.200
     3.226    50.104     0.200
     3.259    50.604     0.200
     3.221    49.704     0.200
     3.316    51.204     0.200
     3.251    49.054     0.200
     3.339    51.704     0.200
     3.381    50.323     0.200
     3.381    50.544     0.200
     3.385    50.384     0.200
     3.342    51.403     0.200
     3.454    53.414     0.200
     3.408    53.504     0.200
     3.508    53.964     0.200
     3.482    52.504     0.200
     3.500    54.504     0.200
     3.587    54.044     0.200
     3.598    53.804     0.200
     3.673    56.184     0.200
     3.654    56.664     0.200
     3.662    54.804     0.200
     3.703    56.134     0.200
     3.712    54.894     0.200
     3.724    56.903     0.200
     3.751    56.113     0.200
     3.760    57.184     0.200
     3.737    57.124     0.200
     3.820    57.523     0.200
     3.770    56.313     0.200
     3.823    59.104     0.200
     3.898    57.573     0.200
     3.898    56.903     0.200
     3.880    58.384     0.200
     3.880    59.104     0.200
     3.854    59.823     0.200
     3.971    59.004     0.200
     3.997    58.903     0.200
     4.029    61.874     0.200
     4.048    60.613     0.200
     3.982    61.504     0.200
     3.982    61.244     0.200
     4.112    60.184     0.200
     4.036    61.804     0.200
     4.235    64.863     0.200
     4.386    65.474     0.200
     4.386    65.454     0.200
     4.406    64.684     0.200
     4.359    65.804     0.200
     4.359    65.434     0.200
     4.417    67.753     0.200
     4.417    66.004     0.200
     4.444    67.304     0.200
     4.499    70.704     0.200
     4.592    66.943     0.200
     4.730    69.360     0.200
     4.730    69.204     0.200
     4.730    69.682     0.200
     4.706    71.504     0.200
     4.746    69.054     0.200
     4.786    69.943     0.200
     4.816    70.294     0.200
     4.848    70.624     0.200
     4.846    71.162     0.200
     4.865    70.664     0.200
     4.795    73.204     0.200
     4.803    74.374     0.200
     4.810    72.004     0.200
     4.905    71.063     0.200
     4.919    71.394     0.200
     4.919    71.193     0.200
     4.909    73.104     0.200
     5.007    73.244     0.200
     5.042    72.264     0.200
     5.042    72.764     0.200
     5.053    72.504     0.200
     5.088    73.744     0.200
     5.106    74.304     0.200
     5.134    74.403     0.200
     5.170    74.934     0.200
     5.206    75.664     0.200
     5.228    77.646     0.200
     5.218    77.004     0.200
     5.341    77.594     0.200
     5.261    77.804     0.200
     5.272    78.504     0.200
     5.378    77.744     0.200
     5.397    77.794     0.200
     5.393    78.654     0.200
     5.415    78.735     0.200
     5.357    79.704     0.200
     5.384    81.017     0.200
     5.383    79.104     0.200
     5.400    78.304     0.200
     5.497    80.303     0.200
     5.464    81.704     0.200
     5.469    81.104     0.200
     5.470    83.304     0.200
     5.574    83.156     0.200
     5.661    84.170     0.200
     5.709    85.582     0.200
     5.754    85.704     0.200
     5.851    85.815     0.200
     5.820    86.704     0.200
     6.024    87.520     0.200
     5.963    88.104     0.200
     6.068    88.305     0.200
     6.083    88.705     0.200
     6.155    89.430     0.200
     6.155    89.549     0.200
     6.090    91.004     0.200
     6.110    91.716     0.200
     6.185    89.193     0.200
     6.238    90.868     0.200
     6.245    90.568     0.200
     6.192    91.541     0.200
     6.270    90.987     0.200
     6.294    91.291     0.200
     6.211    92.004     0.200
     6.414    93.083     0.200
     6.406    93.304     0.200
     6.441    95.004     0.200
     6.481    93.146     0.200
     6.600    95.403     0.200
     6.661    96.692     0.200
     6.664    98.004     0.200
     6.671    96.434     0.200
     6.693    98.504     0.200
     6.781    98.776     0.200
     6.862    99.515     0.200
     6.989   101.304     0.200
     6.979   101.504     0.200
     7.035   100.903     0.200
     7.075   101.507     0.200
     7.135   102.151     0.200
     7.135   102.104     0.200
     7.126   104.204     0.200
     7.161   102.204     0.200
     7.142   105.886     0.200
     7.216   104.304     0.200
     7.341   104.884     0.200
     7.327   108.015     0.200
     7.432   106.004     0.200
     7.498   106.304     0.200
     7.472   107.924     0.200
     7.472   108.104     0.200
     7.574   108.193     0.200
     7.561   107.883     0.200
     7.622   112.382     0.200
     7.636   111.403     0.200
     7.774   115.004     0.200
     7.822   111.903     0.200
     7.908   116.504     0.200
     7.908   116.344     0.200
     7.893   115.753     0.200
     8.014   116.504     0.200
     8.068   118.250     0.200
     8.092   117.186     0.200
     8.174   115.704     0.200
     8.221   119.954     0.200
     8.288   116.637     0.200
     8.335   117.414     0.200
     8.335   117.607     0.200
     8.415   119.104     0.200
     8.450   119.233     0.200
     8.501   121.903     0.200
     8.517   120.315     0.200
     8.528   125.014     0.200
     8.619   121.903     0.200
     8.690   123.104     0.200
     8.686   123.104     0.200
     8.801   123.794     0.200
     8.741   127.019     0.200
     8.836   124.914     0.200
     8.880   125.704     0.200
     8.847   128.946     0.200
     8.872   129.353     0.200
     9.009   127.104     0.200
     9.072   127.903     0.200
     9.639   136.804     0.200
     9.743   137.204     0.200
     9.691   139.567     0.200
     9.695   136.932     0.200
     9.695   139.233     0.200
     9.800   137.903     0.200
     9.890   139.304     0.200
    10.060   141.504     0.200
    10.068   140.704     0.200
    10.091   141.903     0.200
    10.166   141.804     0.200
    10.187   142.903     0.200
    10.394   145.903     0.200
    10.433   146.504     0.200
    10.709   150.604     0.200
    11.211   157.704     0.200
    11.476   160.903     0.200
    13.343   186.403     0.200
    13.419   187.204     0.200
    13.711   195.354     0.200
    15.598   215.544     0.200
    17.185   236.403     0.200
    18.312   252.107     0.200
    19.968   272.528     0.200
     0.965    17.545     0.200
     0.996    18.185     0.200
     0.995    18.524     0.200
     0.952    17.774     0.200
     1.001    17.654     0.200
     1.074    18.574     0.200
     1.036    18.454     0.200
     1.141    19.305     0.200
     1.232    20.614     0.200
     1.257    21.595     0.200
     1.274    22.335     0.200
     1.297    22.055     0.200
     1.370    22.595     0.200
     1.449    24.034     0.200
     1.449    23.604     0.200
     1.339    22.665     0.200
     1.411    23.274     0.200
     1.380    23.234     0.200
     1.465    24.314     0.200
     1.483    25.234     0.200
     1.525    25.015     0.200
     1.638    26.805     0.200
     1.691    27.824     0.200
     1.606    26.335     0.200
     1.717    28.135     0.200
     1.669    26.994     0.200
     1.728    28.024     0.200
     1.728    27.534     0.200
     1.752    28.494     0.200
     1.872    29.385     0.200
     1.795    29.255     0.200
     1.982    31.895     0.200
     1.938    31.635     0.200
     1.898    31.225     0.200
     1.909    31.885     0.200
     1.943    30.984     0.200
     2.079    32.555     0.200
     2.104    32.545     0.200
     2.053    33.034     0.200
     2.051    32.835     0.200
     2.235    36.135     0.200
     2.264    36.475     0.200
     2.275    36.515     0.200
     2.289    36.835     0.200
     2.303    36.994     0.200
     2.247    35.604     0.200
     2.157    35.284     0.200
     2.391    38.204     0.200
     2.261    35.935     0.200
     2.416    38.265     0.200
     2.259    35.704     0.200
     2.518    40.064     0.200
     2.539    39.404     0.200
     2.464    39.234     0.200
     2.566    39.965     0.200
     2.432    39.244     0.200
     2.574    39.574     0.200
     2.621    40.994     0.200
     2.493    39.534     0.200
     2.761    42.654     0.200
     2.774    43.774     0.200
     2.738    43.415     0.200
     2.733    43.135     0.200
     2.604    40.244     0.200
     2.818    43.654     0.200
     2.770    43.534     0.200
     2.869    44.005     0.200
     2.974    45.585     0.200
     3.020    47.295     0.200
     3.023    46.475     0.200
     3.058    47.555     0.200
     3.066    46.595     0.200
     3.102    47.265     0.200
     3.093    47.515     0.200
     3.107    47.935     0.200
     3.107    48.274     0.200
     3.021    47.034     0.200
     3.032    47.135     0.200
     3.265    50.335     0.200
     3.276    50.284     0.200
     3.154    48.835     0.200
     3.216    50.435     0.200
     3.307    50.635     0.200
     3.426    52.135     0.200
     3.320    51.034     0.200
     3.481    51.574     0.200
     3.481    51.385     0.200
     3.480    51.944     0.200
     3.363    52.935     0.200
     3.364    52.425     0.200
     3.413    52.734     0.200
     3.534    52.795     0.200
     3.741    56.135     0.200
     3.814    57.574     0.200
     3.627    56.034     0.200
     3.820    57.524     0.200
     3.661    54.534     0.200
     3.836    58.125     0.200
     3.798    57.135     0.200
     3.875    57.954     0.200
     3.992    57.935     0.200
     3.992    58.484     0.200
     4.086    59.835     0.200
     4.135    62.145     0.200
     4.117    61.465     0.200
     4.360    64.225     0.200
     4.366    64.725     0.200
     4.480    65.274     0.200
     4.502    65.555     0.200
     4.416    64.034     0.200
     4.335    65.635     0.200
     4.815    70.892     0.200
     4.815    70.734     0.200
     4.699    70.234     0.200
     4.724    70.335     0.200
     4.745    70.335     0.200
     4.925    71.905     0.200
     4.797    70.935     0.200
     4.834    71.534     0.200
     4.892    72.034     0.200
     5.100    74.732     0.200
     4.946    73.034     0.200
     4.959    73.335     0.200
     4.959    73.034     0.200
     5.107    75.135     0.200
     5.150    75.635     0.200
     5.466    79.871     0.200
     5.515    79.883     0.200
     5.360    81.435     0.200
     5.591    81.282     0.200
     5.518    82.435     0.200
     5.618    83.734     0.200
     5.710    84.835     0.200
     5.917    86.318     0.200
     5.812    85.935     0.200
     6.113    89.393     0.200
     6.138    89.271     0.200
     6.167    89.223     0.200
     6.069    88.135     0.200
     6.257    90.609     0.200
     6.100    89.935     0.200
     6.340    92.187     0.200
     6.374    92.066     0.200
     6.400    93.027     0.200
     6.285    92.335     0.200
     6.518    94.642     0.200
     6.547    96.335     0.200
     6.765    98.154     0.200
     6.969   101.727     0.200
     7.021   101.135     0.200
     7.221   102.354     0.200
     7.269   102.635     0.200
     7.518   107.135     0.200
     7.588   106.835     0.200
     7.608   107.335     0.200
     7.879   110.835     0.200
     7.931   111.534     0.200
     8.526   119.435     0.200
     8.800   122.935     0.200
     9.183   128.135     0.200
     9.853   137.034     0.200
    10.001   139.234     0.200
    10.202   142.534     0.200
    10.277   143.335     0.200
    10.298   143.635     0.200
    10.504   146.234     0.200
    10.819   150.635     0.200
     1.026    19.696     0.200
     1.144    21.576     0.200
     1.179    22.266     0.200
     1.314    24.496     0.200
     1.298    24.046     0.200
     1.388    26.166     0.200
     1.440    26.586     0.200
     1.462    26.546     0.200
     1.490    26.516     0.200
     1.602    27.796     0.200
     1.588    27.786     0.200
     1.697    29.526     0.200
     1.943    33.286     0.200
     2.112    34.736     0.200
     2.234    35.836     0.200
     2.234    35.956     0.200
     2.456    38.266     0.200
     2.563    40.666     0.200
     2.630    41.856     0.200
     2.630    42.456     0.200
     2.630    41.656     0.200
     2.672    41.526     0.200
     2.734    42.676     0.200
     2.776    43.696     0.200
     2.796    45.016     0.200
     2.929    46.256     0.200
     2.929    47.056     0.200
     2.959    46.356     0.200
     2.950    47.156     0.200
     2.950    46.956     0.200
     3.035    47.106     0.200
     3.126    49.556     0.200
     3.162    49.956     0.200
     3.162    50.056     0.200
     3.156    50.256     0.200
     3.257    51.556     0.200
     3.304    50.806     0.200
     3.328    51.976     0.200
     3.332    52.756     0.200
     3.435    53.556     0.200
     3.452    54.556     0.200
     3.452    53.956     0.200
     3.539    55.756     0.200
     3.656    55.876     0.200
     3.743    56.626     0.200
     3.734    59.256     0.200
     3.816    57.466     0.200
     3.867    59.556     0.200
     3.867    59.856     0.200
     3.915    60.756     0.200
     3.994    61.416     0.200
     3.997    62.856     0.200
     4.077    63.926     0.200
     4.045    62.856     0.200
     4.057    62.256     0.200
     4.111    61.166     0.200
     4.107    62.506     0.200
     4.221    65.256     0.200
     4.221    64.756     0.200
     4.252    64.456     0.200
     4.258    65.556     0.200
     4.258    66.256     0.200
     4.336    64.856     0.200
     4.493    68.356     0.200
     4.520    68.156     0.200
     4.556    67.826     0.200
     4.584    69.356     0.200
     4.693    70.026     0.200
     4.710    69.996     0.200
     4.700    70.956     0.200
     4.700    70.856     0.200
     4.725    70.056     0.200
     4.725    69.356     0.200
     4.967    73.796     0.200
     4.999    73.456     0.200
     5.009    74.856     0.200
     5.016    75.356     0.200
     5.029    75.956     0.200
     5.256    77.356     0.200
     5.293    78.556     0.200
     5.293    78.156     0.200
     5.373    80.756     0.200
     5.419    79.257     0.200
     5.448    79.860     0.200
     5.493    81.956     0.200
     5.561    82.856     0.200
     5.753    83.650     0.200
     6.008    87.383     0.200
     6.369    92.486     0.200
     6.447    93.875     0.200
     6.498    94.730     0.200
     6.496    95.215     0.200
     6.526    95.233     0.200
     6.529    96.106     0.200
     6.604    96.506     0.200
     6.607    96.487     0.200
     6.669    96.547     0.200
     6.704    96.917     0.200
     7.032   105.231     0.200
     7.574   111.056     0.200
     7.635   108.356     0.200
     7.753   113.056     0.200
     7.929   115.156     0.200
     9.850   141.835     0.200
     1.849    31.375     0.200
     1.840    31.582     0.200
     1.975    33.465     0.200
     1.987    33.977     0.200
     2.355    38.727     0.200
     2.746    44.426     0.200
     2.781    44.727     0.200
     2.781    44.828     0.200
     2.804    46.426     0.200
     2.815    46.125     0.200
     2.915    47.328     0.200
     2.936    47.027     0.200
     2.979    48.426     0.200
     3.053    50.727     0.200
     3.050    48.828     0.200
     3.033    50.598     0.200
     3.033    49.406     0.200
     3.087    50.945     0.200
     3.100    48.688     0.200
     3.108    49.727     0.200
     3.141    49.625     0.200
     3.163    51.137     0.200
     3.186    51.027     0.200
     3.209    52.176     0.200
     3.253    51.926     0.200
     3.253    51.625     0.200
     3.253    52.027     0.200
     3.263    52.586     0.200
     3.263    51.316     0.200
     3.297    52.926     0.200
     3.287    51.828     0.200
     3.334    52.340     0.200
     3.334    52.965     0.200
     3.372    53.625     0.200
     3.509    55.926     0.200
     3.541    56.938     0.200
     3.571    56.738     0.200
     3.607    57.426     0.200
     3.675    57.137     0.200
     3.672    58.426     0.200
     3.666    58.055     0.200
     3.666    58.336     0.200
     3.754    57.426     0.200
     3.758    59.828     0.200
     3.758    60.027     0.200
     3.784    61.348     0.200
     3.778    59.828     0.200
     3.796    58.426     0.200
     3.772    58.906     0.200
     3.770    61.035     0.200
     3.770    57.996     0.200
     3.770    59.668     0.200
     3.811    60.305     0.200
     3.828    60.105     0.200
     3.877    61.438     0.200
     3.873    61.926     0.200
     3.882    61.926     0.200
     3.909    61.035     0.200
     3.909    60.926     0.200
     3.917    62.227     0.200
     3.917    61.328     0.200
     3.917    61.828     0.200
     3.922    62.078     0.200
     4.001    63.445     0.200
     4.008    62.465     0.200
     4.008    62.738     0.200
     4.013    62.668     0.200
     4.047    64.328     0.200
     4.047    64.227     0.200
     4.152    64.555     0.200
     4.206    62.207     0.200
     4.235    63.855     0.200
     4.235    63.477     0.200
     4.279    66.125     0.200
     4.366    68.227     0.200
     4.366    67.227     0.200
     4.400    68.625     0.200
     4.418    66.176     0.200
     4.399    67.527     0.200
     4.399    68.668     0.200
     4.373    67.707     0.200
     4.373    67.527     0.200
     4.369    70.625     0.200
     4.459    66.875     0.200
     4.437    69.988     0.200
     4.437    70.238     0.200
     4.533    70.527     0.200
     4.599    68.508     0.200
     4.673    70.816     0.200
     4.673    70.625     0.200
     4.673    70.938     0.200
     4.679    69.727     0.200
     4.626    71.648     0.200
     4.672    72.418     0.200
     4.672    71.727     0.200
     4.672    72.027     0.200
     4.722    71.727     0.200
     4.761    70.758     0.200
     4.777    73.328     0.200
     4.797    71.668     0.200
     4.803    72.098     0.200
     4.770    71.578     0.200
     4.770    71.785     0.200
     4.767    73.457     0.200
     4.767    72.828     0.200
     4.767    72.727     0.200
     4.833    73.336     0.200
     4.839    72.695     0.200
     4.838    73.727     0.200
     4.866    73.477     0.200
     4.905    73.668     0.200
     4.903    74.828     0.200
     4.903    75.027     0.200
     4.903    74.695     0.200
     4.898    75.727     0.200
     4.898    76.027     0.200
     4.924    74.926     0.200
     4.924    75.465     0.200
     5.028    76.426     0.200
     5.032    77.176     0.200
     5.032    76.426     0.200
     5.032    76.625     0.200
     5.037    77.625     0.200
     5.037    78.027     0.200
     5.097    76.617     0.200
     5.057    76.625     0.200
     5.160    78.867     0.200
     5.184    77.375     0.200
     5.260    79.328     0.200
     5.287    81.125     0.200
     5.346    80.824     0.200
     5.346    81.336     0.200
     5.362    80.992     0.200
     5.362    80.426     0.200
     5.365    81.426     0.200
     5.432    80.484     0.200
     5.388    81.625     0.200
     5.388    81.328     0.200
     5.416    81.926     0.200
     5.399    81.527     0.200
     5.399    81.426     0.200
     5.458    82.227     0.200
     5.488    82.727     0.200
     5.488    82.625     0.200
     5.562    83.426     0.200
     5.562    84.027     0.200
     5.571    83.828     0.200
     5.621    83.727     0.200
     5.667    84.938     0.200
     5.680    85.328     0.200
     5.713    85.527     0.200
     5.730    85.926     0.200
     5.730    85.727     0.200
     5.777    84.625     0.200
     5.793    86.242     0.200
     5.780    86.527     0.200
     5.801    85.715     0.200
     5.801    87.047     0.200
     5.769    86.125     0.200
     5.769    86.426     0.200
     5.809    87.227     0.200
     5.810    87.895     0.200
     5.818    87.027     0.200
     5.818    86.875     0.200
     5.850    85.418     0.200
     5.887    88.629     0.200
     5.913    88.926     0.200
     5.904    88.527     0.200
     5.950    88.332     0.200
     5.929    88.527     0.200
     5.958    88.523     0.200
     5.969    89.242     0.200
     5.973    89.023     0.200
     6.023    89.789     0.200
     6.023    89.988     0.200
     6.074    90.707     0.200
     6.074    89.918     0.200
     6.043    89.828     0.200
     6.088    90.461     0.200
     6.042    90.625     0.200
     6.088    89.375     0.200
     6.088    90.168     0.200
     6.067    92.926     0.200
     6.117    91.223     0.200
     6.131    90.566     0.200
     6.190    94.023     0.200
     6.236    94.125     0.200
     6.300    94.941     0.200
     6.331    93.027     0.200
     6.351    94.750     0.200
     6.312    95.125     0.200
     6.336    94.926     0.200
     6.395    95.727     0.200
     6.497    96.051     0.200
     6.497    97.086     0.200
     6.559    96.727     0.200
     6.561    98.980     0.200
     6.553    97.527     0.200
     6.610   100.258     0.200
     6.742    99.910     0.200
     6.742    98.648     0.200
     6.756    99.426     0.200
     6.716    99.727     0.200
     6.754    98.855     0.200
     6.754    99.496     0.200
     6.764   101.105     0.200
     6.779   101.328     0.200
     6.814   100.676     0.200
     6.774   100.625     0.200
     6.863   101.027     0.200
     6.913   101.227     0.200
     6.933   100.625     0.200
     6.990   102.125     0.200
     6.959   103.426     0.200
     7.052   101.828     0.200
     7.052   102.734     0.200
     7.052   102.875     0.200
     7.052   102.488     0.200
     7.052   102.953     0.200
     7.056   102.805     0.200
     7.065   103.277     0.200
     7.132   107.328     0.200
     7.107   105.227     0.200
     7.218   106.426     0.200
     7.218   107.688     0.200
     7.226   105.727     0.200
     7.296   107.027     0.200
     7.304   106.828     0.200
     7.274   106.527     0.200
     7.345   106.156     0.200
     7.345   106.008     0.200
     7.318   106.828     0.200
     7.337   106.926     0.200
     7.410   109.625     0.200
     7.434   107.402     0.200
     7.447   108.297     0.200
     7.457   111.375     0.200
     7.464   109.426     0.200
     7.569   110.727     0.200
     7.569   109.898     0.200
     7.569   111.207     0.200
     7.614   110.328     0.200
     7.657   114.562     0.200
     7.745   117.625     0.200
     7.746   112.305     0.200
     7.765   112.426     0.200
     7.891   113.926     0.200
     7.896   116.227     0.200
     7.957   114.496     0.200
     7.927   117.227     0.200
     7.991   114.438     0.200
     7.998   117.527     0.200
     8.002   115.828     0.200
     7.980   115.828     0.200
     8.076   115.727     0.200
     8.076   117.027     0.200
     8.058   117.426     0.200
     8.058   117.527     0.200
     8.072   116.426     0.200
     8.153   117.047     0.200
     8.158   116.465     0.200
     8.158   121.148     0.200
     8.233   118.625     0.200
     8.241   117.926     0.200
     8.228   121.473     0.200
     8.228   122.176     0.200
     8.249   118.867     0.200
     8.250   118.875     0.200
     8.250   118.926     0.200
     8.239   120.980     0.200
     8.362   120.828     0.200
     8.379   120.008     0.200
     8.379   119.727     0.200
     8.471   121.527     0.200
     8.478   123.125     0.200
     8.558   123.277     0.200
     8.618   123.125     0.200
     8.658   126.906     0.200
     8.734   126.918     0.200
     8.762   127.895     0.200
     8.801   130.527     0.200
     8.834   130.855     0.200
     8.834   128.578     0.200
     8.834   130.996     0.200
     8.834   130.625     0.200
     8.885   129.328     0.200
     8.885   129.445     0.200
     8.890   130.426     0.200
     8.963   132.070     0.200
     9.057   130.258     0.200
     9.085   130.035     0.200
     9.078   131.027     0.200
     9.240   132.227     0.200
     9.297   133.426     0.200
     9.368   138.594     0.200
     9.414   134.027     0.200
     9.422   137.938     0.200
     9.424   137.277     0.200
     9.480   137.277     0.200
     9.480   138.695     0.200
     9.532   136.125     0.200
     9.532   135.648     0.200
     9.555   135.348     0.200
     9.555   137.227     0.200
     9.555   136.996     0.200
     9.537   136.727     0.200
     9.537   137.465     0.200
     9.596   137.625     0.200
     9.606   136.926     0.200
     9.569   138.328     0.200
     9.634   138.027     0.200
     9.639   138.125     0.200
     9.802   140.125     0.200
     9.819   140.426     0.200
     9.862   142.137     0.200
     9.915   143.266     0.200
     9.963   143.387     0.200
    10.120   144.828     0.200
    10.216   148.879     0.200
    10.258   146.727     0.200
    10.226   146.328     0.200
    10.226   146.988     0.200
    10.226   145.891     0.200
    10.338   149.285     0.200
    10.702   153.957     0.200
    10.803   155.527     0.200
    10.848   154.285     0.200
    11.053   158.828     0.200
    11.081   159.508     0.200
    11.442   165.965     0.200
    11.753   167.328     0.200
    11.753   169.625     0.200
    12.406   176.965     0.200
    13.302   190.828     0.200
    14.009   201.316     0.200
    14.182   202.926     0.200
    14.398   204.035     0.200
    14.398   206.125     0.200
    14.399   203.906     0.200
    14.399   206.277     0.200
    14.420   205.297     0.200
    15.313   216.258     0.200
    16.694   232.625     0.200
    17.073   238.535     0.200
    18.332   253.883     0.200
    18.519   259.625     0.200
    18.583   261.625     0.200
    19.354   266.051     0.200
    19.482   268.125     0.200
    20.035   275.926     0.200
    20.284   277.926     0.200
    20.466   281.125     0.200
    20.472   279.328     0.200
    20.641   282.027     0.200
     1.066    20.453     0.200
     1.080    20.562     0.200
     1.080    20.531     0.200
     1.131    21.141     0.200
     1.175    21.875     0.200
     1.153    21.359     0.200
     1.154    21.352     0.200
     1.161    21.352     0.200
     1.168    21.430     0.200
     1.223    22.703     0.200
     1.239    22.906     0.200
     1.328    24.039     0.200
     1.756    30.016     0.200
     1.842    31.562     0.200
     1.850    31.305     0.200
     1.984    33.555     0.200
     2.349    38.633     0.200
     2.349    38.336     0.200
     2.741    44.031     0.200
     2.902    47.531     0.200
     2.932    46.633     0.200
     2.968    48.000     0.200
     3.048    48.336     0.200
     3.046    48.539     0.200
     3.046    48.977     0.200
     3.046    49.430     0.200
     3.094    49.305     0.200
     3.106    49.234     0.200
     3.153    50.844     0.200
     3.198    51.883     0.200
     3.182    50.234     0.200
     3.252    51.836     0.200
     3.252    51.336     0.200
     3.272    51.133     0.200
     3.272    52.516     0.200
     3.291    52.430     0.200
     3.331    52.609     0.200
     3.331    52.836     0.200
     3.331    53.141     0.200
     3.360    53.633     0.200
     3.373    54.312     0.200
     3.379    54.602     0.200
     3.496    55.234     0.200
     3.530    56.992     0.200
     3.561    56.430     0.200
     3.603    56.930     0.200
     3.660    56.891     0.200
     3.660    56.734     0.200
     3.675    56.836     0.200
     3.666    58.133     0.200
     3.681    56.031     0.200
     3.681    57.195     0.200
     3.739    56.781     0.200
     3.732    60.930     0.200
     3.750    59.031     0.200
     3.773    61.023     0.200
     3.772    58.734     0.200
     3.772    59.305     0.200
     3.772    58.656     0.200
     3.802    60.492     0.200
     3.776    58.789     0.200
     3.776    59.633     0.200
     3.776    59.375     0.200
     3.818    59.914     0.200
     3.800    58.305     0.200
     3.800    58.625     0.200
     3.800    59.430     0.200
     3.800    59.055     0.200
     3.867    61.125     0.200
     3.871    61.836     0.200
     3.894    59.930     0.200
     3.878    61.836     0.200
     3.910    61.031     0.200
     3.921    61.945     0.200
     3.974    62.430     0.200
     3.991    63.211     0.200
     3.998    62.055     0.200
     3.998    62.492     0.200
     4.003    62.336     0.200
     4.056    62.734     0.200
     4.042    63.531     0.200
     4.042    63.336     0.200
     4.132    63.133     0.200
     4.193    63.180     0.200
     4.220    63.594     0.200
     4.220    63.375     0.200
     4.328    66.289     0.200
     4.328    66.500     0.200
     4.396    67.836     0.200
     4.396    68.531     0.200
     4.402    68.125     0.200
     4.403    66.164     0.200
     4.393    67.031     0.200
     4.380    67.250     0.200
     4.380    67.734     0.200
     4.380    67.086     0.200
     4.444    66.664     0.200
     4.451    70.070     0.200
     4.536    70.766     0.200
     4.585    68.562     0.200
     4.611    70.852     0.200
     4.658    69.906     0.200
     4.658    69.734     0.200
     4.658    70.570     0.200
     4.664    69.172     0.200
     4.648    72.266     0.200
     4.648    72.523     0.200
     4.648    72.133     0.200
     4.648    72.406     0.200
     4.678    69.727     0.200
     4.678    69.836     0.200
     4.715    71.031     0.200
     4.747    70.445     0.200
     4.783    71.336     0.200
     4.788    71.766     0.200
     4.770    72.234     0.200
     4.776    71.031     0.200
     4.776    71.242     0.200
     4.774    73.094     0.200
     4.774    72.234     0.200
     4.774    72.133     0.200
     4.819    73.344     0.200
     4.824    72.156     0.200
     4.851    72.711     0.200
     4.834    73.531     0.200
     4.894    73.430     0.200
     4.894    72.633     0.200
     4.894    74.133     0.200
     4.903    75.930     0.200
     5.020    74.836     0.200
     5.035    76.781     0.200
     5.035    76.430     0.200
     5.035    76.633     0.200
     5.042    78.031     0.200
     5.064    77.031     0.200
     5.148    78.328     0.200
     5.148    77.633     0.200
     5.148    77.141     0.200
     5.169    76.945     0.200
     5.253    77.336     0.200
     5.257    79.234     0.200
     5.293    81.336     0.200
     5.331    79.281     0.200
     5.331    80.719     0.200
     5.331    79.594     0.200
     5.358    80.234     0.200
     5.358    79.609     0.200
     5.374    81.234     0.200
     5.417    80.273     0.200
     5.397    81.484     0.200
     5.459    82.930     0.200
     5.467    82.031     0.200
     5.497    82.633     0.200
     5.540    83.031     0.200
     5.572    83.430     0.200
     5.614    81.633     0.200
     5.653    83.836     0.200
     5.653    84.172     0.200
     5.736    85.031     0.200
     5.740    85.531     0.200
     5.779    85.289     0.200
     5.788    86.516     0.200
     5.775    85.633     0.200
     5.802    88.031     0.200
     5.802    85.906     0.200
     5.819    86.930     0.200
     5.873    86.742     0.200
     5.873    87.703     0.200
     5.873    87.242     0.200
     5.898    87.172     0.200
     5.935    87.648     0.200
     5.910    88.734     0.200
     5.945    86.953     0.200
     5.926    88.836     0.200
     5.914    88.531     0.200
     5.955    88.773     0.200
     5.954    88.133     0.200
     5.959    88.500     0.200
     6.008    89.047     0.200
     6.008    89.734     0.200
     6.008    89.539     0.200
     6.004    89.930     0.200
     6.059    89.836     0.200
     6.059    89.562     0.200
     6.075    89.883     0.200
     6.047    90.320     0.200
     6.047    90.133     0.200
     6.050    90.734     0.200
     6.103    90.609     0.200
     6.074    92.930     0.200
     6.088    90.234     0.200
     6.116    90.102     0.200
     6.127    94.914     0.200
     6.132    92.234     0.200
     6.168    94.633     0.200
     6.181    93.742     0.200
     6.181    90.992     0.200
     6.154    92.734     0.200
     6.200    91.531     0.200
     6.243    92.133     0.200
     6.270    94.234     0.200
     6.255    93.734     0.200
     6.293    93.312     0.200
     6.326    94.133     0.200
     6.337    93.328     0.200
     6.320    94.930     0.200
     6.368    96.633     0.200
     6.351    93.531     0.200
     6.346    94.531     0.200
     6.381    95.023     0.200
     6.374    95.305     0.200
     6.401    95.242     0.200
     6.429    95.164     0.200
     6.403    95.633     0.200
     6.448    95.633     0.200
     6.448    95.930     0.200
     6.483    95.078     0.200
     6.483    96.039     0.200
     6.498    96.859     0.200
     6.489    96.531     0.200
     6.540    96.430     0.200
     6.540    96.906     0.200
     6.551    96.734     0.200
     6.551    97.234     0.200
     6.552    95.703     0.200
     6.600    97.172     0.200
     6.612    97.133     0.200
     6.612    97.031     0.200
     6.654    99.031     0.200
     6.728    98.641     0.200
     6.719    99.734     0.200
     6.745    98.961     0.200
     6.745   100.789     0.200
     6.802   100.102     0.200
     6.903    99.836     0.200
     6.903    99.531     0.200
     6.905   101.234     0.200
     6.924    99.430     0.200
     6.924   100.234     0.200
     6.975   101.430     0.200
     6.985   102.070     0.200
     6.959   104.031     0.200
     7.037   102.078     0.200
     7.037   102.180     0.200
     7.037   102.055     0.200
     7.043   102.484     0.200
     7.043   103.594     0.200
     7.043   104.273     0.200
     7.054   102.945     0.200
     7.080   103.742     0.200
     7.162   104.633     0.200
     7.182   107.859     0.200
     7.211   107.234     0.200
     7.211   106.734     0.200
     7.211   107.695     0.200
     7.213   105.836     0.200
     7.195   105.336     0.200
     7.195   105.914     0.200
     7.282   107.234     0.200
     7.290   105.930     0.200
     7.290   106.141     0.200
     7.331   106.156     0.200
     7.331   106.031     0.200
     7.337   108.164     0.200
     7.388   106.781     0.200
     7.352   109.133     0.200
     7.403   109.258     0.200
     7.403   109.445     0.200
     7.419   106.797     0.200
     7.425   106.172     0.200
     7.384   109.336     0.200
     7.434   107.375     0.200
     7.434   107.234     0.200
     7.454   107.930     0.200
     7.454   108.344     0.200
     7.480   108.336     0.200
     7.468   109.258     0.200
     7.499   107.945     0.200
     7.494   110.492     0.200
     7.494   111.492     0.200
     7.554   109.430     0.200
     7.554   109.844     0.200
     7.589   110.359     0.200
     7.599   110.234     0.200
     7.647   113.227     0.200
     7.735   112.102     0.200
     7.733   115.531     0.200
     7.733   116.875     0.200
     7.743   112.164     0.200
     7.753   111.555     0.200
     7.786   112.727     0.200
     7.773   115.531     0.200
     7.846   116.867     0.200
     7.861   113.359     0.200
     7.870   116.586     0.200
     7.880   112.430     0.200
     7.880   113.133     0.200
     7.875   115.797     0.200
     7.875   116.195     0.200
     7.924   117.727     0.200
     7.924   117.891     0.200
     7.944   114.211     0.200
     7.953   115.062     0.200
     7.939   116.867     0.200
     7.978   114.641     0.200
     7.978   116.320     0.200
     7.995   117.133     0.200
     7.995   116.734     0.200
     7.990   119.734     0.200
     8.002   118.234     0.200
     8.061   116.234     0.200
     8.060   117.156     0.200
     8.060   117.727     0.200
     8.124   115.539     0.200
     8.138   116.836     0.200
     8.144   118.375     0.200
     8.144   119.133     0.200
     8.171   118.172     0.200
     8.222   119.133     0.200
     8.225   119.109     0.200
     8.225   120.031     0.200
     8.229   117.633     0.200
     8.229   116.734     0.200
     8.235   117.266     0.200
     8.235   117.133     0.200
     8.235   118.789     0.200
     8.235   116.859     0.200
     8.235   118.805     0.200
     8.235   117.141     0.200
     8.235   116.836     0.200
     8.221   122.320     0.200
     8.221   122.492     0.200
     8.281   119.375     0.200
     8.309   121.094     0.200
     8.311   122.156     0.200
     8.332   120.930     0.200
     8.332   121.727     0.200
     8.352   119.156     0.200
     8.335   122.930     0.200
     8.308   122.234     0.200
     8.367   119.672     0.200
     8.367   119.875     0.200
     8.435   124.133     0.200
     8.458   120.836     0.200
     8.467   125.070     0.200
     8.467   124.695     0.200
     8.473   123.242     0.200
     8.473   127.461     0.200
     8.479   123.203     0.200
     8.490   123.719     0.200
     8.490   124.172     0.200
     8.533   124.930     0.200
     8.559   125.836     0.200
     8.559   125.945     0.200
     8.569   124.430     0.200
     8.566   127.633     0.200
     8.606   123.133     0.200
     8.611   126.531     0.200
     8.614   126.930     0.200
     8.678   124.633     0.200
     8.678   124.492     0.200
     8.684   127.531     0.200
     8.692   125.133     0.200
     8.692   125.391     0.200
     8.707   124.133     0.200
     8.719   124.305     0.200
     8.719   124.977     0.200
     8.744   126.836     0.200
     8.756   126.531     0.200
     8.776   126.430     0.200
     8.796   130.430     0.200
     8.809   126.633     0.200
     8.809   126.789     0.200
     8.792   128.383     0.200
     8.792   129.094     0.200
     8.830   126.477     0.200
     8.828   129.875     0.200
     8.828   129.727     0.200
     8.828   130.711     0.200
     8.863   126.633     0.200
     8.885   129.359     0.200
     8.937   129.633     0.200
     9.042   128.602     0.200
     9.042   129.086     0.200
     9.042   129.344     0.200
     9.046   131.273     0.200
     9.046   131.430     0.200
     9.046   132.164     0.200
     9.046   133.570     0.200
     9.046   131.484     0.200
     9.046   133.133     0.200
     9.046   134.195     0.200
     9.039   132.234     0.200
     9.041   132.031     0.200
     9.038   132.930     0.200
     9.071   128.977     0.200
     9.071   128.844     0.200
     9.085   133.812     0.200
     9.109   133.031     0.200
     9.126   134.430     0.200
     9.231   130.633     0.200
     9.231   131.031     0.200
     9.285   131.531     0.200
     9.354   137.430     0.200
     9.354   137.930     0.200
     9.359   138.227     0.200
     9.359   137.641     0.200
     9.366   137.711     0.200
     9.402   133.234     0.200
     9.416   137.492     0.200
     9.416   136.836     0.200
     9.430   135.234     0.200
     9.430   136.711     0.200
     9.418   137.000     0.200
     9.473   135.250     0.200
     9.474   138.125     0.200
     9.474   138.555     0.200
     9.483   138.430     0.200
     9.499   135.805     0.200
     9.522   134.031     0.200
     9.522   134.430     0.200
     9.519   139.531     0.200
     9.540   136.453     0.200
     9.540   137.031     0.200
     9.540   136.109     0.200
     9.568   138.289     0.200
     9.545   137.430     0.200
     9.584   136.430     0.200
     9.591   136.422     0.200
     9.591   138.375     0.200
     9.597   136.031     0.200
     9.597   135.633     0.200
     9.579   137.672     0.200
     9.629   136.234     0.200
     9.629   136.133     0.200
     9.665   139.500     0.200
     9.657   141.430     0.200
     9.655   141.836     0.200
     9.672   141.508     0.200
     9.672   141.641     0.200
     9.690   142.234     0.200
     9.763   141.281     0.200
     9.795   143.031     0.200
     9.811   137.836     0.200
     9.887   141.680     0.200
     9.887   141.000     0.200
     9.887   142.047     0.200
     9.887   142.734     0.200
     9.887   141.430     0.200
     9.875   140.172     0.200
     9.875   143.086     0.200
     9.898   143.445     0.200
     9.898   143.203     0.200
     9.898   143.781     0.200
     9.981   143.734     0.200
     9.958   144.062     0.200
     9.986   145.734     0.200
     9.986   145.844     0.200
    10.010   144.914     0.200
    10.072   145.133     0.200
    10.111   142.133     0.200
    10.108   145.289     0.200
    10.214   146.117     0.200
    10.214   147.289     0.200
    10.217   150.031     0.200
    10.249   143.734     0.200
    10.253   146.562     0.200
    10.265   150.336     0.200
    10.236   146.086     0.200
    10.236   145.094     0.200
    10.341   147.414     0.200
    10.333   148.773     0.200
    10.446   149.930     0.200
    10.446   151.383     0.200
    10.476   150.602     0.200
    10.584   153.734     0.200
    10.608   153.391     0.200
    10.652   152.461     0.200
    10.652   153.531     0.200
    10.675   153.883     0.200
    10.675   152.477     0.200
    10.679   154.570     0.200
    10.716   157.531     0.200
    10.716   157.031     0.200
    10.785   154.531     0.200
    10.791   153.930     0.200
    10.791   154.531     0.200
    10.816   154.992     0.200
    10.826   155.641     0.200
    10.831   153.914     0.200
    10.838   153.164     0.200
    10.838   157.383     0.200
    10.882   156.594     0.200
    10.889   155.055     0.200
    10.903   156.898     0.200
    10.903   157.273     0.200
    10.961   156.953     0.200
    10.953   159.336     0.200
    11.041   154.531     0.200
    11.041   156.031     0.200
    11.101   160.930     0.200
    11.118   161.445     0.200
    11.163   159.570     0.200
    11.201   160.836     0.200
    11.234   161.133     0.200
    11.434   165.047     0.200
    11.434   164.234     0.200
    11.444   166.133     0.200
    11.502   163.023     0.200
    11.502   165.680     0.200
    11.496   163.164     0.200
    11.750   165.531     0.200
    11.750   166.734     0.200
    11.754   167.633     0.200
    11.760   166.625     0.200
    11.760   166.859     0.200
    11.934   172.336     0.200
    12.057   172.836     0.200
    12.071   172.930     0.200
    12.123   172.930     0.200
    12.194   174.133     0.200
    12.407   178.289     0.200
    12.424   177.633     0.200
    12.460   177.688     0.200
    12.507   179.633     0.200
    12.507   176.531     0.200
    12.796   178.734     0.200
    12.798   182.734     0.200
    12.858   179.430     0.200
    13.191   187.133     0.200
    13.194   187.336     0.200
    13.268   188.234     0.200
    13.273   188.336     0.200
    13.280   187.164     0.200
    13.280   188.750     0.200
    13.280   188.992     0.200
    13.292   187.719     0.200
    13.292   188.430     0.200
    13.292   188.531     0.200
    13.374   190.094     0.200
    13.850   192.531     0.200
    14.327   203.234     0.200
    14.327   202.133     0.200
    14.348   203.930     0.200
    14.382   205.633     0.200
    14.386   205.836     0.200
    14.400   206.031     0.200
    14.400   205.625     0.200
    14.420   203.430     0.200
    14.642   209.836     0.200
    14.911   211.406     0.200
    15.247   214.695     0.200
    15.300   215.430     0.200
    15.406   216.695     0.200
    16.020   223.086     0.200
    16.286   229.172     0.200
    17.353   242.289     0.200
    17.348   242.531     0.200
    17.914   248.703     0.200
    17.923   247.844     0.200
    18.112   249.633     0.200
    18.317   252.727     0.200
    18.609   260.234     0.200
    18.621   257.594     0.200
    18.920   263.734     0.200
    19.477   267.930     0.200
    20.041   275.305     0.200
    20.469   280.125     0.200
    20.469   279.430     0.200
    20.638   281.234     0.200
    20.677   283.234     0.200
     1.618    27.789     0.200
     1.673    29.820     0.200
     1.769    29.289     0.200
     1.769    29.391     0.200
     1.710    29.234     0.200
     1.722    29.328     0.200
     1.850    31.648     0.200
     1.837    30.898     0.200
     1.974    32.750     0.200
     2.360    38.188     0.200
     2.360    37.789     0.200
     2.456    39.930     0.200
     2.750    43.586     0.200
     2.922    47.086     0.200
     2.981    48.508     0.200
     2.941    46.188     0.200
     3.028    48.289     0.200
     3.028    48.844     0.200
     3.028    49.086     0.200
     3.054    48.391     0.200
     3.165    50.836     0.200
     3.113    49.188     0.200
     3.212    51.664     0.200
     3.190    50.289     0.200
     3.256    51.289     0.200
     3.256    51.391     0.200
     3.262    50.539     0.200
     3.262    51.016     0.200
     3.302    51.984     0.200
     3.302    52.086     0.200
     3.387    54.211     0.200
     3.337    51.977     0.200
     3.337    52.188     0.200
     3.337    52.484     0.200
     3.337    52.984     0.200
     3.337    52.695     0.200
     3.394    54.828     0.200
     3.379    53.289     0.200
     3.516    54.789     0.200
     3.544    56.719     0.200
     3.573    56.430     0.200
     3.611    56.391     0.200
     3.682    56.531     0.200
     3.682    56.391     0.200
     3.660    55.844     0.200
     3.660    57.086     0.200
     3.677    57.391     0.200
     3.760    56.445     0.200
     3.750    58.984     0.200
     3.786    60.094     0.200
     3.786    60.781     0.200
     3.764    58.586     0.200
     3.813    59.656     0.200
     3.830    59.617     0.200
     3.784    59.586     0.200
     3.775    58.758     0.200
     3.775    59.336     0.200
     3.770    59.047     0.200
     3.770    59.891     0.200
     3.770    60.016     0.200
     3.800    58.789     0.200
     3.800    59.164     0.200
     3.800    59.289     0.200
     3.878    60.680     0.200
     3.916    59.086     0.200
     3.877    61.086     0.200
     3.886    60.984     0.200
     3.923    60.789     0.200
     3.923    60.484     0.200
     3.969    60.141     0.200
     3.926    61.508     0.200
     3.989    62.977     0.200
     4.003    63.336     0.200
     4.009    61.961     0.200
     4.009    62.195     0.200
     4.015    62.125     0.200
     4.073    61.695     0.200
     4.078    62.406     0.200
     4.052    63.586     0.200
     4.052    62.984     0.200
     4.210    62.719     0.200
     4.241    62.984     0.200
     4.241    63.891     0.200
     4.320    65.688     0.200
     4.320    65.891     0.200
     4.398    67.188     0.200
     4.398    67.789     0.200
     4.372    65.586     0.200
     4.372    65.188     0.200
     4.415    67.781     0.200
     4.362    69.953     0.200
     4.424    65.781     0.200
     4.373    66.695     0.200
     4.373    67.289     0.200
     4.406    66.789     0.200
     4.430    70.266     0.200
     4.535    70.438     0.200
     4.604    68.258     0.200
     4.621    70.977     0.200
     4.684    68.961     0.200
     4.680    69.906     0.200
     4.680    69.586     0.200
     4.680    70.336     0.200
     4.680    70.750     0.200
     4.699    69.898     0.200
     4.645    70.938     0.200
     4.645    71.969     0.200
     4.645    71.477     0.200
     4.767    70.117     0.200
     4.728    70.789     0.200
     4.765    70.477     0.200
     4.765    70.898     0.200
     4.802    71.031     0.200
     4.809    71.969     0.200
     4.782    72.891     0.200
     4.766    72.188     0.200
     4.846    72.078     0.200
     4.840    72.969     0.200
     4.872    72.641     0.200
     4.842    73.484     0.200
     4.910    73.289     0.200
     4.910    72.688     0.200
     4.899    75.484     0.200
     5.034    74.586     0.200
     5.033    76.195     0.200
     5.033    76.625     0.200
     5.037    77.789     0.200
     5.056    76.891     0.200
     5.189    76.664     0.200
     5.167    78.633     0.200
     5.167    76.281     0.200
     5.266    78.984     0.200
     5.264    79.086     0.200
     5.352    79.055     0.200
     5.352    80.195     0.200
     5.352    79.750     0.200
     5.367    79.789     0.200
     5.367    80.461     0.200
     5.364    80.789     0.200
     5.438    80.047     0.200
     5.387    80.984     0.200
     5.456    82.789     0.200
     5.457    81.586     0.200
     5.486    82.586     0.200
     5.496    84.297     0.200
     5.529    82.688     0.200
     5.560    83.188     0.200
     5.627    82.086     0.200
     5.674    83.586     0.200
     5.750    83.586     0.200
     5.728    85.289     0.200
     5.799    85.453     0.200
     5.806    86.078     0.200
     5.806    86.375     0.200
     5.809    86.891     0.200
     5.785    88.102     0.200
     5.785    85.484     0.200
     5.841    87.969     0.200
     5.853    85.211     0.200
     5.815    87.477     0.200
     5.892    87.250     0.200
     5.892    88.109     0.200
     5.892    87.445     0.200
     5.920    87.344     0.200
     5.963    88.094     0.200
     5.957    87.508     0.200
     5.904    88.484     0.200
     5.902    87.891     0.200
     5.974    88.648     0.200
     5.978    88.695     0.200
     5.933    88.484     0.200
     5.976    88.000     0.200
     6.030    88.914     0.200
     6.030    89.406     0.200
     6.030    89.648     0.200
     5.992    91.250     0.200
     5.992    88.297     0.200
     5.999    89.484     0.200
     6.080    89.680     0.200
     6.092    90.227     0.200
     6.044    88.867     0.200
     6.044    89.984     0.200
     6.041    90.188     0.200
     6.122    90.914     0.200
     6.133    92.914     0.200
     6.066    92.484     0.200
     6.088    90.188     0.200
     6.138    89.969     0.200
     6.175    93.766     0.200
     6.196    92.836     0.200
     6.196    91.094     0.200
     6.156    92.289     0.200
     6.188    90.789     0.200
     6.236    94.086     0.200
     6.242    91.891     0.200
     6.330    93.289     0.200
     6.260    93.391     0.200
     6.306    93.984     0.200
     6.356    93.891     0.200
     6.311    94.484     0.200
     6.335    94.789     0.200
     6.388    95.086     0.200
     6.350    93.484     0.200
     6.393    96.234     0.200
     6.447    95.508     0.200
     6.412    95.852     0.200
     6.394    95.586     0.200
     6.469    95.891     0.200
     6.501    95.742     0.200
     6.501    96.141     0.200
     6.515    96.859     0.200
     6.488    95.891     0.200
     6.560    96.984     0.200
     6.561    96.789     0.200
     6.561    96.914     0.200
     6.567    97.539     0.200
     6.611   100.266     0.200
     6.593    98.984     0.200
     6.616    98.641     0.200
     6.664   101.586     0.200
     6.621    98.688     0.200
     6.699   101.555     0.200
     6.656    98.789     0.200
     6.746    98.656     0.200
     6.746    98.797     0.200
     6.755    98.797     0.200
     6.755   100.477     0.200
     6.730   100.188     0.200
     6.730   100.086     0.200
     6.715    99.984     0.200
     6.742    99.688     0.200
     6.770   101.195     0.200
     6.818    99.555     0.200
     6.816   101.242     0.200
     6.816   101.031     0.200
     6.772   100.391     0.200
     6.781   101.188     0.200
     6.914   100.789     0.200
     6.914   100.289     0.200
     6.863   100.688     0.200
     6.935   100.891     0.200
     6.935   100.789     0.200
     7.002   102.992     0.200
     6.997   101.289     0.200
     6.964   103.586     0.200
     6.958   102.688     0.200
     6.969   102.086     0.200
     7.058   101.695     0.200
     7.058   102.438     0.200
     7.058   101.977     0.200
     7.058   101.711     0.200
     7.068   102.680     0.200
     7.063   102.578     0.200
     7.063   104.031     0.200
     7.067   102.891     0.200
     7.132   106.289     0.200
     7.095   107.797     0.200
     7.179   104.773     0.200
     7.187   108.570     0.200
     7.219   107.289     0.200
     7.219   106.789     0.200
     7.219   107.484     0.200
     7.183   105.039     0.200
     7.183   105.711     0.200
     7.233   104.789     0.200
     7.233   105.359     0.200
     7.303   106.391     0.200
     7.303   107.188     0.200
     7.303   107.547     0.200
     7.311   106.086     0.200
     7.311   107.445     0.200
     7.272   105.688     0.200
     7.352   105.570     0.200
     7.352   105.984     0.200
     7.352   105.703     0.200
     7.320   106.891     0.200
     7.347   108.680     0.200
     7.405   109.039     0.200
     7.336   107.789     0.200
     7.441   107.680     0.200
     7.440   106.359     0.200
     7.440   107.031     0.200
     7.356   108.484     0.200
     7.445   106.125     0.200
     7.451   107.344     0.200
     7.451   107.484     0.200
     7.416   110.359     0.200
     7.386   108.984     0.200
     7.476   108.688     0.200
     7.476   108.094     0.200
     7.450   110.000     0.200
     7.450   111.336     0.200
     7.500   108.742     0.200
     7.515   108.156     0.200
     7.493   112.398     0.200
     7.464   108.891     0.200
     7.510   111.969     0.200
     7.510   112.898     0.200
     7.588   110.586     0.200
     7.576   109.086     0.200
     7.576   111.633     0.200
     7.576   111.258     0.200
     7.576   110.578     0.200
     7.548   108.984     0.200
     7.609   108.781     0.200
     7.620   109.984     0.200
     7.768   111.859     0.200
     7.763   110.531     0.200
     7.752   115.688     0.200
     7.752   115.328     0.200
     7.758   115.289     0.200
     7.806   111.469     0.200
     7.818   116.984     0.200
     7.771   112.984     0.200
     7.823   116.273     0.200
     7.802   113.688     0.200
     7.882   112.430     0.200
     7.893   113.289     0.200
     7.863   117.094     0.200
     7.836   114.289     0.200
     7.889   115.711     0.200
     7.885   116.125     0.200
     7.885   116.297     0.200
     7.885   114.688     0.200
     7.961   114.094     0.200
     7.961   114.383     0.200
     7.895   114.984     0.200
     7.973   113.578     0.200
     7.936   117.688     0.200
     7.936   118.148     0.200
     7.953   116.906     0.200
     7.926   115.891     0.200
     7.996   113.641     0.200
     7.996   115.578     0.200
     7.996   114.680     0.200
     7.948   117.180     0.200
     8.002   116.891     0.200
     8.002   117.391     0.200
     7.975   119.188     0.200
     7.959   117.109     0.200
     7.959   117.289     0.200
     7.987   118.188     0.200
     7.973   118.016     0.200
     7.952   115.586     0.200
     8.005   116.984     0.200
     8.082   116.484     0.200
     8.061   115.305     0.200
     8.061   117.484     0.200
     8.061   117.039     0.200
     8.073   116.586     0.200
     8.145   115.711     0.200
     8.092   118.688     0.200
     8.159   117.391     0.200
     8.159   117.219     0.200
     8.159   117.039     0.200
     8.165   117.977     0.200
     8.165   118.391     0.200
     8.165   119.586     0.200
     8.165   119.203     0.200
     8.165   118.789     0.200
     8.191   118.078     0.200
     8.164   120.570     0.200
     8.233   120.086     0.200
     8.244   117.289     0.200
     8.244   117.984     0.200
     8.244   119.391     0.200
     8.255   116.820     0.200
     8.255   118.461     0.200
     8.255   118.695     0.200
     8.255   116.695     0.200
     8.255   118.711     0.200
     8.255   120.320     0.200
     8.255   116.688     0.200
     8.234   121.547     0.200
     8.234   121.188     0.200
     8.243   120.977     0.200
     8.302   119.578     0.200
     8.331   121.742     0.200
     8.320   123.984     0.200
     8.329   121.961     0.200
     8.353   121.789     0.200
     8.353   121.578     0.200
     8.373   119.070     0.200
     8.383   119.438     0.200
     8.383   119.688     0.200
     8.315   121.391     0.200
     8.391   123.500     0.200
     8.474   121.188     0.200
     8.453   123.688     0.200
     8.464   124.688     0.200
     8.464   124.055     0.200
     8.493   126.977     0.200
     8.493   125.188     0.200
     8.484   125.172     0.200
     8.485   124.352     0.200
     8.478   122.789     0.200
     8.478   124.180     0.200
     8.499   124.344     0.200
     8.551   125.789     0.200
     8.551   125.391     0.200
     8.521   124.727     0.200
     8.581   127.195     0.200
     8.581   125.984     0.200
     8.621   122.586     0.200
     8.591   126.430     0.200
     8.628   127.586     0.200
     8.632   127.188     0.200
     8.609   124.742     0.200
     8.676   127.797     0.200
     8.663   127.281     0.200
     8.699   125.297     0.200
     8.714   125.484     0.200
     8.714   125.297     0.200
     8.702   128.289     0.200
     8.728   124.688     0.200
     8.740   126.516     0.200
     8.740   125.680     0.200
     8.749   126.086     0.200
     8.777   128.289     0.200
     8.830   125.891     0.200
     8.830   126.648     0.200
     8.814   131.586     0.200
     8.814   131.344     0.200
     8.802   128.234     0.200
     8.802   129.000     0.200
     8.788   126.789     0.200
     8.851   127.633     0.200
     8.840   128.148     0.200
     8.840   128.961     0.200
     8.840   129.938     0.200
     8.840   130.086     0.200
     8.903   126.945     0.200
     8.903   129.445     0.200
     8.908   127.047     0.200
     8.881   130.492     0.200
     8.888   128.789     0.200
     8.888   129.016     0.200
     8.888   128.984     0.200
     8.936   129.289     0.200
     8.969   131.438     0.200
     9.064   129.875     0.200
     9.064   130.109     0.200
     9.068   132.961     0.200
     9.068   132.688     0.200
     9.066   133.789     0.200
     9.066   130.234     0.200
     9.066   133.648     0.200
     9.059   132.789     0.200
     9.056   132.391     0.200
     9.091   128.297     0.200
     9.091   128.750     0.200
     9.050   132.844     0.200
     9.098   133.555     0.200
     9.079   131.188     0.200
     9.120   133.734     0.200
     9.120   133.188     0.200
     9.138   133.820     0.200
     9.242   131.586     0.200
     9.300   132.484     0.200
     9.351   134.211     0.200
     9.365   137.219     0.200
     9.374   138.195     0.200
     9.375   137.586     0.200
     9.375   138.086     0.200
     9.416   133.484     0.200
     9.382   134.531     0.200
     9.434   135.086     0.200
     9.434   135.984     0.200
     9.367   136.188     0.200
     9.428   137.047     0.200
     9.428   136.984     0.200
     9.430   136.969     0.200
     9.437   137.289     0.200
     9.491   136.180     0.200
     9.491   135.531     0.200
     9.452   138.430     0.200
     9.460   137.461     0.200
     9.517   135.938     0.200
     9.486   137.992     0.200
     9.534   135.289     0.200
     9.534   134.688     0.200
     9.489   138.867     0.200
     9.538   141.039     0.200
     9.538   137.844     0.200
     9.538   140.547     0.200
     9.561   135.945     0.200
     9.561   137.086     0.200
     9.561   136.453     0.200
     9.561   136.289     0.200
     9.535   138.617     0.200
     9.588   138.125     0.200
     9.588   138.750     0.200
     9.599   136.484     0.200
     9.537   137.945     0.200
     9.537   136.391     0.200
     9.537   137.328     0.200
     9.607   136.289     0.200
     9.607   135.891     0.200
     9.612   137.586     0.200
     9.612   137.828     0.200
     9.567   137.586     0.200
     9.567   139.680     0.200
     9.641   136.391     0.200
     9.641   136.289     0.200
     9.665   137.789     0.200
     9.682   139.078     0.200
     9.665   141.414     0.200
     9.685   141.328     0.200
     9.707   141.789     0.200
     9.802   143.891     0.200
     9.763   141.766     0.200
     9.821   140.188     0.200
     9.821   139.289     0.200
     9.771   141.438     0.200
     9.861   141.289     0.200
     9.854   140.531     0.200
     9.854   143.227     0.200
     9.903   141.008     0.200
     9.903   142.156     0.200
     9.903   142.734     0.200
     9.903   141.891     0.200
     9.889   141.875     0.200
     9.889   143.336     0.200
     9.957   142.414     0.200
     9.916   143.328     0.200
     9.968   144.133     0.200
     9.998   145.797     0.200
    10.019   144.984     0.200
    10.110   142.844     0.200
    10.121   145.484     0.200
    10.092   145.688     0.200
    10.178   145.586     0.200
    10.232   147.125     0.200
    10.232   146.398     0.200
    10.260   145.984     0.200
    10.221   147.406     0.200
    10.221   149.391     0.200
    10.273   149.789     0.200
    10.223   148.469     0.200
    10.273   147.484     0.200
    10.273   147.617     0.200
    10.224   145.805     0.200
    10.261   149.125     0.200
    10.261   146.820     0.200
    10.360   148.336     0.200
    10.343   149.281     0.200
    10.467   149.586     0.200
    10.493   150.680     0.200
    10.511   149.289     0.200
    10.603   150.984     0.200
    10.626   152.867     0.200
    10.600   154.289     0.200
    10.600   153.289     0.200
    10.646   150.188     0.200
    10.668   152.164     0.200
    10.668   153.445     0.200
    10.664   153.773     0.200
    10.692   153.188     0.200
    10.692   152.508     0.200
    10.643   152.969     0.200
    10.722   157.484     0.200
    10.689   154.578     0.200
    10.704   154.508     0.200
    10.783   156.438     0.200
    10.788   153.586     0.200
    10.788   154.789     0.200
    10.807   153.984     0.200
    10.799   158.406     0.200
    10.833   154.945     0.200
    10.843   155.344     0.200
    10.849   155.438     0.200
    10.851   152.516     0.200
    10.851   157.438     0.200
    10.899   156.258     0.200
    10.905   154.828     0.200
    10.922   157.281     0.200
    10.977   156.156     0.200
    11.057   156.984     0.200
    11.138   161.648     0.200
    11.082   159.125     0.200
    11.153   162.227     0.200
    11.214   160.188     0.200
    11.214   162.086     0.200
    11.247   160.891     0.200
    11.446   162.086     0.200
    11.448   165.391     0.200
    11.448   164.688     0.200
    11.448   164.086     0.200
    11.522   165.984     0.200
    11.530   166.477     0.200
    11.487   160.664     0.200
    11.650   168.836     0.200
    11.759   165.086     0.200
    11.753   169.258     0.200
    11.936   173.984     0.200
    12.076   173.188     0.200
    12.088   173.086     0.200
    12.141   174.086     0.200
    12.205   175.852     0.200
    12.212   174.891     0.200
    12.408   174.156     0.200
    12.441   178.484     0.200
    12.480   179.375     0.200
    12.519   178.891     0.200
    12.681   181.586     0.200
    12.808   182.891     0.200
    12.815   183.086     0.200
    12.869   181.984     0.200
    12.912   179.461     0.200
    12.921   182.703     0.200
    12.985   184.938     0.200
    13.207   186.891     0.200
    13.225   187.688     0.200
    13.239   188.086     0.200
    13.241   188.188     0.200
    13.250   188.188     0.200
    13.261   188.086     0.200
    13.266   188.188     0.200
    13.291   187.578     0.200
    13.297   187.438     0.200
    13.297   188.891     0.200
    13.297   188.047     0.200
    13.309   185.594     0.200
    13.309   188.734     0.200
    13.309   187.891     0.200
    13.309   188.891     0.200
    13.395   191.930     0.200
    13.395   190.398     0.200
    13.733   194.477     0.200
    13.728   190.500     0.200
    13.840   196.398     0.200
    13.861   193.891     0.200
    14.043   198.211     0.200
    14.011   201.375     0.200
    14.185   202.727     0.200
    14.302   201.594     0.200
    14.278   200.367     0.200
    14.278   204.750     0.200
    14.356   201.984     0.200
    14.417   204.609     0.200
    14.417   200.555     0.200
    14.383   205.984     0.200
    14.401   205.586     0.200
    14.401   204.984     0.200
    14.401   205.891     0.200
    14.407   206.188     0.200
    14.569   207.016     0.200
    14.664   205.938     0.200
    14.738   204.039     0.200
    14.738   208.484     0.200
    14.941   208.781     0.200
    14.932   210.578     0.200
    15.164   208.641     0.200
    15.244   216.391     0.200
    15.267   213.117     0.200
    15.320   211.836     0.200
    15.421   217.148     0.200
    16.060   224.859     0.200
    16.287   223.797     0.200
    16.698   233.688     0.200
    16.926   236.781     0.200
    16.933   236.984     0.200
    17.042   238.188     0.200
    17.084   237.977     0.200
    17.084   238.141     0.200
    17.345   238.820     0.200
    17.818   246.281     0.200
    18.134   250.055     0.200
    18.134   250.500     0.200
    18.554   256.734     0.200
    18.624   260.688     0.200
    18.648   258.266     0.200
    18.814   262.750     0.200
    18.941   262.758     0.200
    19.042   263.086     0.200
    19.293   264.461     0.200
    19.497   267.234     0.200
    19.674   269.211     0.200
    19.764   273.586     0.200
    20.035   275.586     0.200
    20.301   276.000     0.200
    20.283   276.711     0.200
    20.470   279.891     0.200
    20.476   279.586     0.200
    20.645   280.984     0.200
     1.484    25.586     0.200
     1.567    27.242     0.200
     1.577    27.312     0.200
     1.638    28.133     0.200
     1.726    29.461     0.200
     1.857    31.086     0.200
     1.953    32.664     0.200
     1.994    33.094     0.200
     2.371    38.820     0.200
     2.416    39.906     0.200
     2.468    39.773     0.200
     2.763    43.922     0.200
     2.920    47.320     0.200
     2.954    46.523     0.200
     2.954    46.820     0.200
     3.002    48.891     0.200
     3.069    49.320     0.200
     3.127    49.820     0.200
     3.193    51.656     0.200
     3.204    50.922     0.200
     3.272    51.625     0.200
     3.272    52.125     0.200
     3.282    51.305     0.200
     3.313    52.227     0.200
     3.367    53.812     0.200
     3.352    52.820     0.200
     3.352    52.625     0.200
     3.352    52.922     0.200
     3.379    54.523     0.200
     3.475    54.516     0.200
     3.515    55.523     0.200
     3.554    56.086     0.200
     3.615    55.727     0.200
     3.625    56.922     0.200
     3.673    57.227     0.200
     3.688    57.422     0.200
     3.772    60.922     0.200
     3.794    58.922     0.200
     3.791    59.797     0.200
     3.859    60.703     0.200
     3.905    61.625     0.200
     3.892    60.625     0.200
     3.900    60.625     0.200
     3.932    61.422     0.200
     3.932    62.320     0.200
     3.990    61.836     0.200
     3.995    61.852     0.200
     4.064    62.727     0.200
     4.064    63.422     0.200
     4.134    63.844     0.200
     4.379    68.227     0.200
     4.339    66.422     0.200
     4.379    66.625     0.200
     4.379    67.727     0.200
     4.392    67.227     0.200
     4.415    68.125     0.200
     4.591    68.367     0.200
     4.553    70.922     0.200
     4.669    70.195     0.200
     4.669    69.727     0.200
     4.754    70.891     0.200
     4.737    71.422     0.200
     4.785    71.180     0.200
     4.802    71.500     0.200
     4.814    71.703     0.200
     4.793    72.820     0.200
     4.786    72.727     0.200
     4.837    72.906     0.200
     4.860    73.289     0.200
     4.888    72.656     0.200
     4.891    75.266     0.200
     4.856    73.820     0.200
     4.909    73.820     0.200
     4.909    72.914     0.200
     4.918    75.625     0.200
     4.976    73.641     0.200
     5.014    74.492     0.200
     5.042    76.023     0.200
     5.052    76.625     0.200
     5.057    77.820     0.200
     5.126    75.984     0.200
     5.076    77.023     0.200
     5.175    77.695     0.200
     5.278    79.727     0.200
     5.340    80.367     0.200
     5.380    81.422     0.200
     5.406    81.320     0.200
     5.475    82.922     0.200
     5.476    82.023     0.200
     5.506    82.523     0.200
     5.513    84.992     0.200
     5.549    83.023     0.200
     5.700    85.523     0.200
     5.789    88.523     0.200
     5.786    85.508     0.200
     5.748    85.727     0.200
     5.797    85.523     0.200
     5.877    88.383     0.200
     5.908    88.383     0.200
     5.946    89.977     0.200
     5.959    89.570     0.200
     5.950    88.422     0.200
     5.963    89.594     0.200
     5.924    88.922     0.200
     5.947    88.523     0.200
     6.018    89.820     0.200
     6.106    92.641     0.200
     6.063    90.227     0.200
     6.061    90.523     0.200
     6.086    92.820     0.200
     6.130    91.625     0.200
     6.255    94.320     0.200
     6.311    94.523     0.200
     6.331    94.922     0.200
     6.354    94.922     0.200
     6.414    95.727     0.200
     6.484    97.320     0.200
     6.541    97.125     0.200
     6.792   100.727     0.200
     6.895    99.922     0.200
     6.915   100.125     0.200
     6.987   101.727     0.200
     6.978   104.023     0.200
     7.113   106.422     0.200
     7.200   103.820     0.200
     7.340   105.820     0.200
     7.873   113.523     0.200
     8.225   117.320     0.200
     8.456   121.227     0.200
     8.603   122.820     0.200
     9.223   131.125     0.200
     9.515   135.523     0.200
     1.435    24.805     0.200
     1.561    28.086     0.200
     1.546    27.195     0.200
     1.551    26.727     0.200
     1.618    27.836     0.200
     1.674    29.375     0.200
     1.674    30.156     0.200
     1.600    27.633     0.200
     1.662    29.367     0.200
     1.699    29.164     0.200
     1.706    29.117     0.200
     1.786    29.727     0.200
     1.869    30.992     0.200
     1.820    31.109     0.200
     2.344    39.367     0.200
     2.344    37.664     0.200
     2.450    39.789     0.200
     2.733    43.664     0.200
     2.917    46.969     0.200
     2.925    47.062     0.200
     2.925    46.469     0.200
     2.998    47.914     0.200
     3.016    48.383     0.200
     3.016    49.562     0.200
     3.035    47.969     0.200
     3.119    49.008     0.200
     3.095    48.867     0.200
     3.183    50.727     0.200
     3.173    49.766     0.200
     3.228    51.812     0.200
     3.238    51.164     0.200
     3.244    50.242     0.200
     3.286    52.469     0.200
     3.286    51.766     0.200
     3.319    52.234     0.200
     3.319    52.367     0.200
     3.319    52.758     0.200
     3.319    52.477     0.200
     3.373    53.164     0.200
     3.403    53.898     0.200
     3.410    54.586     0.200
     3.422    54.266     0.200
     3.511    54.664     0.200
     3.560    56.883     0.200
     3.590    56.094     0.200
     3.594    56.266     0.200
     3.684    56.469     0.200
     3.700    56.273     0.200
     3.661    56.766     0.200
     3.652    55.906     0.200
     3.652    57.164     0.200
     3.741    57.766     0.200
     3.766    56.547     0.200
     3.751    60.062     0.200
     3.803    59.727     0.200
     3.769    59.266     0.200
     3.756    58.906     0.200
     3.751    58.398     0.200
     3.831    59.875     0.200
     3.780    58.258     0.200
     3.780    58.562     0.200
     3.780    58.789     0.200
     3.780    58.664     0.200
     3.847    59.438     0.200
     3.896    60.562     0.200
     3.859    61.062     0.200
     3.868    60.469     0.200
     3.921    59.867     0.200
     3.863    60.062     0.200
     3.909    60.867     0.200
     3.909    60.664     0.200
     3.907    61.305     0.200
     4.004    62.633     0.200
     4.020    63.062     0.200
     4.027    61.898     0.200
     4.027    62.328     0.200
     4.032    61.914     0.200
     4.035    63.969     0.200
     4.077    62.484     0.200
     4.224    62.867     0.200
     4.249    63.664     0.200
     4.301    65.656     0.200
     4.301    65.844     0.200
     4.360    65.469     0.200
     4.360    64.969     0.200
     4.354    66.969     0.200
     4.354    66.656     0.200
     4.360    69.602     0.200
     4.418    67.664     0.200
     4.418    67.969     0.200
     4.432    68.242     0.200
     4.392    66.969     0.200
     4.431    66.078     0.200
     4.432    70.094     0.200
     4.515    69.703     0.200
     4.616    68.656     0.200
     4.639    70.523     0.200
     4.653    68.797     0.200
     4.684    69.883     0.200
     4.684    69.664     0.200
     4.684    70.125     0.200
     4.684    70.227     0.200
     4.625    71.016     0.200
     4.625    70.867     0.200
     4.625    71.219     0.200
     4.694    69.297     0.200
     4.713    70.469     0.200
     4.780    70.727     0.200
     4.780    71.477     0.200
     4.766    71.969     0.200
     4.814    71.016     0.200
     4.747    72.164     0.200
     4.816    72.523     0.200
     4.838    72.336     0.200
     4.849    72.055     0.200
     4.825    73.367     0.200
     4.879    72.828     0.200
     4.925    75.164     0.200
     4.898    74.164     0.200
     4.898    75.562     0.200
     4.879    74.766     0.200
     5.021    74.867     0.200
     5.013    75.633     0.200
     5.013    75.469     0.200
     5.018    76.867     0.200
     5.037    76.266     0.200
     5.160    78.664     0.200
     5.160    76.578     0.200
     5.199    76.812     0.200
     5.250    77.969     0.200
     5.245    78.867     0.200
     5.359    79.148     0.200
     5.359    80.203     0.200
     5.359    80.422     0.200
     5.351    80.062     0.200
     5.351    80.477     0.200
     5.346    80.562     0.200
     5.368    80.562     0.200
     5.440    80.039     0.200
     5.436    81.664     0.200
     5.439    81.164     0.200
     5.476    84.258     0.200
     5.468    81.867     0.200
     5.511    81.969     0.200
     5.543    82.766     0.200
     5.611    81.664     0.200
     5.671    83.484     0.200
     5.737    83.562     0.200
     5.711    85.164     0.200
     5.808    85.250     0.200
     5.768    85.867     0.200
     5.819    85.773     0.200
     5.819    86.508     0.200
     5.828    87.562     0.200
     5.801    87.555     0.200
     5.861    89.047     0.200
     5.869    85.258     0.200
     5.902    87.602     0.200
     5.902    89.258     0.200
     5.926    87.562     0.200
     5.885    87.766     0.200
     5.885    87.766     0.200
     5.916    88.266     0.200
     5.957    87.391     0.200
     5.975    88.125     0.200
     5.985    89.023     0.200
     5.975    87.469     0.200
     5.990    88.633     0.200
     6.034    88.773     0.200
     6.034    88.938     0.200
     6.034    89.422     0.200
     5.979    88.969     0.200
     5.990    87.078     0.200
     6.088    90.094     0.200
     6.024    89.094     0.200
     6.024    88.969     0.200
     6.022    89.867     0.200
     6.106    91.227     0.200
     6.047    92.062     0.200
     6.068    89.062     0.200
     6.133    90.938     0.200
     6.139    89.914     0.200
     6.152    93.047     0.200
     6.194    94.445     0.200
     6.184    92.680     0.200
     6.184    92.828     0.200
     6.137    91.766     0.200
     6.170    90.766     0.200
     6.222    91.164     0.200
     6.217    93.266     0.200
     6.242    93.164     0.200
     6.291    94.680     0.200
     6.350    93.867     0.200
     6.293    94.266     0.200
     6.368    94.211     0.200
     6.317    93.766     0.200
     6.330    92.562     0.200
     6.382    97.703     0.200
     6.395    95.359     0.200
     6.375    95.164     0.200
     6.395    95.062     0.200
     6.381    95.867     0.200
     6.460    96.523     0.200
     6.465    94.766     0.200
     6.465    95.219     0.200
     6.514    96.141     0.200
     6.514    96.617     0.200
     6.514    96.727     0.200
     6.529    96.508     0.200
     6.469    94.969     0.200
     6.560    97.766     0.200
     6.579    96.766     0.200
     6.555    97.555     0.200
     6.576    98.469     0.200
     6.605    98.414     0.200
     6.593    96.469     0.200
     6.603    98.266     0.200
     6.637    98.062     0.200
     6.759    99.336     0.200
     6.759    99.922     0.200
     6.715   100.367     0.200
     6.715   100.266     0.200
     6.696    99.469     0.200
     6.773    98.367     0.200
     6.773   102.156     0.200
     6.725   100.367     0.200
     6.756   100.453     0.200
     6.762   100.562     0.200
     6.826    99.633     0.200
     6.826   102.594     0.200
     6.754   100.062     0.200
     6.833   100.016     0.200
     6.844   100.062     0.200
     6.932   100.266     0.200
     6.953   100.367     0.200
     6.946   103.266     0.200
     7.001   100.766     0.200
     6.940   102.664     0.200
     6.949   101.469     0.200
     7.016   102.539     0.200
     7.063   102.023     0.200
     7.063   102.266     0.200
     7.063   101.734     0.200
     7.063   102.117     0.200
     7.057   102.578     0.200
     7.057   104.375     0.200
     7.057   106.258     0.200
     7.084   102.305     0.200
     7.047   102.367     0.200
     7.081   106.523     0.200
     7.152   106.562     0.200
     7.193   103.891     0.200
     7.207   109.492     0.200
     7.165   104.312     0.200
     7.165   104.867     0.200
     7.165   105.312     0.200
     7.238   106.164     0.200
     7.238   106.969     0.200
     7.229   104.867     0.200
     7.301   105.664     0.200
     7.301   109.172     0.200
     7.312   105.469     0.200
     7.312   106.508     0.200
     7.255   105.766     0.200
     7.357   105.609     0.200
     7.357   105.969     0.200
     7.300   106.367     0.200
     7.337   108.266     0.200
     7.401   110.781     0.200
     7.401   111.578     0.200
     7.367   108.469     0.200
     7.447   106.711     0.200
     7.447   107.555     0.200
     7.456   107.992     0.200
     7.455   108.656     0.200
     7.465   107.258     0.200
     7.465   107.438     0.200
     7.478   107.766     0.200
     7.478   108.078     0.200
     7.459   108.047     0.200
     7.459   110.812     0.200
     7.445   108.367     0.200
     7.530   108.125     0.200
     7.499   112.102     0.200
     7.577   109.164     0.200
     7.577   109.383     0.200
     7.577   112.195     0.200
     7.577   110.672     0.200
     7.529   108.664     0.200
     7.601   109.266     0.200
     7.618   110.109     0.200
     7.765   112.039     0.200
     7.746   114.867     0.200
     7.772   112.797     0.200
     7.784   111.367     0.200
     7.814   113.898     0.200
     7.751   112.766     0.200
     7.784   113.367     0.200
     7.890   115.047     0.200
     7.881   118.789     0.200
     7.868   115.680     0.200
     7.866   114.469     0.200
     7.876   114.664     0.200
     7.975   113.836     0.200
     7.975   115.367     0.200
     7.907   116.367     0.200
     7.931   116.883     0.200
     7.982   115.797     0.200
     7.933   114.867     0.200
     8.008   114.406     0.200
     8.021   116.062     0.200
     8.086   115.664     0.200
     8.041   116.133     0.200
     8.041   114.523     0.200
     8.054   116.164     0.200
     8.075   118.266     0.200
     8.152   115.680     0.200
     8.163   116.367     0.200
     8.163   116.914     0.200
     8.164   118.172     0.200
     8.164   118.367     0.200
     8.164   120.391     0.200
     8.164   118.664     0.200
     8.200   120.453     0.200
     8.248   119.062     0.200
     8.252   118.109     0.200
     8.252   119.719     0.200
     8.259   117.164     0.200
     8.218   121.117     0.200
     8.218   122.164     0.200
     8.264   118.359     0.200
     8.264   120.523     0.200
     8.264   118.562     0.200
     8.264   121.336     0.200
     8.264   118.562     0.200
     8.264   119.820     0.200
     8.225   120.664     0.200
     8.310   121.609     0.200
     8.329   121.023     0.200
     8.319   122.414     0.200
     8.354   120.664     0.200
     8.354   121.656     0.200
     8.381   119.594     0.200
     8.397   119.609     0.200
     8.397   119.797     0.200
     8.457   124.266     0.200
     8.457   124.945     0.200
     8.489   120.562     0.200
     8.488   126.156     0.200
     8.461   122.078     0.200
     8.482   124.227     0.200
     8.461   123.766     0.200
     8.461   123.008     0.200
     8.543   125.562     0.200
     8.582   126.266     0.200
     8.590   122.344     0.200
     8.637   122.562     0.200
     8.634   125.305     0.200
     8.619   127.867     0.200
     8.590   124.242     0.200
     8.649   127.633     0.200
     8.731   124.969     0.200
     8.747   125.820     0.200
     8.747   125.656     0.200
     8.752   125.086     0.200
     8.800   126.484     0.200
     8.807   131.867     0.200
     8.786   129.328     0.200
     8.769   126.367     0.200
     8.836   126.164     0.200
     8.836   127.078     0.200
     8.858   127.961     0.200
     8.824   127.656     0.200
     8.824   129.609     0.200
     8.824   129.766     0.200
     8.824   130.969     0.200
     8.869   129.258     0.200
     9.012   129.359     0.200
     9.052   129.984     0.200
     9.068   129.883     0.200
     9.068   129.094     0.200
     9.068   131.273     0.200
     9.074   129.133     0.200
     9.045   132.469     0.200
     9.069   132.062     0.200
     9.034   132.664     0.200
     9.063   131.055     0.200
     9.063   135.016     0.200
     9.099   129.695     0.200
     9.099   130.422     0.200
     9.083   133.328     0.200
     9.154   130.703     0.200
     9.123   133.625     0.200
     9.167   132.023     0.200
     9.260   130.969     0.200
     9.264   132.914     0.200
     9.315   131.867     0.200
     9.362   138.406     0.200
     9.362   136.164     0.200
     9.362   137.445     0.200
     9.403   133.258     0.200
     9.370   136.547     0.200
     9.432   133.164     0.200
     9.413   137.922     0.200
     9.413   137.867     0.200
     9.414   137.469     0.200
     9.453   133.164     0.200
     9.453   135.664     0.200
     9.421   138.164     0.200
     9.437   138.242     0.200
     9.503   136.055     0.200
     9.503   137.656     0.200
     9.471   138.242     0.200
     9.471   138.562     0.200
     9.530   137.539     0.200
     9.552   134.164     0.200
     9.567   136.414     0.200
     9.567   136.766     0.200
     9.567   136.867     0.200
     9.518   136.750     0.200
     9.615   136.367     0.200
     9.550   138.758     0.200
     9.625   135.867     0.200
     9.659   135.766     0.200
     9.695   140.242     0.200
     9.696   142.062     0.200
     9.839   139.367     0.200
     9.858   140.328     0.200
     9.858   143.273     0.200
     9.917   142.234     0.200
     9.917   142.477     0.200
     9.917   142.766     0.200
     9.870   141.984     0.200
     9.870   142.602     0.200
     9.870   143.117     0.200
     9.896   142.508     0.200
     9.951   143.578     0.200
    10.130   144.188     0.200
    10.100   145.180     0.200
    10.205   147.055     0.200
    10.227   149.664     0.200
    10.278   143.766     0.200
    10.206   145.914     0.200
    10.206   145.328     0.200
    10.371   148.164     0.200
    10.326   149.086     0.200
    10.588   154.562     0.200
    10.639   154.164     0.200
    10.682   153.422     0.200
    10.705   154.969     0.200
    10.822   153.867     0.200
    10.868   155.328     0.200
    10.913   156.359     0.200
    10.920   156.844     0.200
    10.991   157.328     0.200
    11.072   155.469     0.200
    11.062   158.648     0.200
    11.469   164.422     0.200
    11.777   166.766     0.200
    11.733   167.516     0.200
    11.733   168.758     0.200
    12.077   172.867     0.200
    12.204   176.562     0.200
    12.389   176.516     0.200
    12.805   185.266     0.200
    12.887   179.266     0.200
    13.199   189.766     0.200
    13.240   189.266     0.200
    13.252   190.367     0.200
    13.279   190.664     0.200
    13.286   188.328     0.200
    13.286   189.578     0.200
    13.298   188.078     0.200
    13.298   189.531     0.200
    13.298   190.266     0.200
    13.298   189.047     0.200
    13.298   190.164     0.200
    13.391   189.648     0.200
    13.391   190.812     0.200
    13.715   195.188     0.200
    13.991   200.453     0.200
    14.166   202.664     0.200
    14.356   199.266     0.200
    14.363   204.969     0.200
    14.367   204.969     0.200
    14.381   201.859     0.200
    14.381   204.867     0.200
    14.381   202.094     0.200
    14.381   204.719     0.200
    14.388   205.164     0.200
    14.436   203.008     0.200
    14.747   209.719     0.200
    14.928   210.117     0.200
    15.261   214.367     0.200
    15.313   212.289     0.200
    16.003   221.547     0.200
    16.267   225.398     0.200
    16.365   228.047     0.200
    17.635   241.812     0.200
    17.847   245.453     0.200
    17.945   248.094     0.200
    17.938   245.539     0.200
    17.960   245.125     0.200
    18.057   248.383     0.200
    18.256   252.469     0.200
    18.333   254.969     0.200
    18.500   256.867     0.200
    18.938   263.078     0.200
    19.099   263.867     0.200
    19.366   265.367     0.200
    19.479   268.062     0.200
    20.015   274.062     0.200
    20.452   279.867     0.200
    20.458   279.766     0.200
    20.621   280.867     0.200
    20.627   280.719     0.200
    20.627   281.562     0.200
     2.340    38.844     0.200
     3.315    52.945     0.200
     3.904    61.148     0.200
     4.031    62.648     0.200
     4.421    68.445     0.200
     4.387    68.547     0.200
     4.682    71.305     0.200
     4.709    71.047     0.200
     4.762    72.148     0.200
     4.821    73.242     0.200
     4.847    72.945     0.200
     5.016    76.945     0.200
     5.198    77.891     0.200
     5.241    79.547     0.200
     5.831    85.445     0.200
     5.911    88.844     0.200
     5.976    92.156     0.200
     5.985    90.336     0.200
     6.033    89.992     0.200
     6.353    92.445     0.200
     6.515    98.141     0.200
     6.934   101.047     0.200
     6.955   100.742     0.200
     8.490   120.945     0.200
     8.638   124.648     0.200
     2.336    39.266     0.200
     2.917    46.969     0.200
     3.030    48.367     0.200
     3.089    49.164     0.200
     3.166    50.367     0.200
     3.233    51.062     0.200
     3.278    51.969     0.200
     3.314    52.766     0.200
     3.314    52.164     0.200
     3.587    55.969     0.200
     3.653    56.969     0.200
     3.853    59.562     0.200
     3.862    59.766     0.200
     3.899    60.664     0.200
     4.028    62.766     0.200
     4.382    67.062     0.200
     4.418    68.867     0.200
     4.704    71.367     0.200
     4.758    73.367     0.200
     4.818    73.469     0.200
     4.836    73.281     0.200
     4.887    74.562     0.200
     5.011    75.969     0.200
     5.187    77.086     0.200
     5.240    79.469     0.200
     5.347    81.383     0.200
     5.343    79.562     0.200
     5.427    81.086     0.200
     5.761    86.367     0.200
     5.796    86.086     0.200
     5.826    89.266     0.200
     5.892    89.664     0.200
     5.913    89.148     0.200
     5.909    88.367     0.200
     5.944    88.414     0.200
     5.965    87.727     0.200
     5.974    90.055     0.200
     5.979    89.406     0.200
     6.022    89.984     0.200
     6.122    90.570     0.200
     6.126    90.398     0.200
     6.357    94.414     0.200
     6.349    94.266     0.200
     6.505    97.297     0.200
     6.575    96.969     0.200
     6.927   100.562     0.200
     6.948   101.164     0.200
     6.989   102.266     0.200
     7.235   107.367     0.200
     7.904   113.766     0.200
     8.251   117.969     0.200
     8.480   121.562     0.200
     8.629   122.867     0.200
     9.255   131.266     0.200
     9.307   133.062     0.200
     9.425   133.867     0.200
     9.546   135.469     0.200
     9.607   135.867     0.200
     9.620   136.469     0.200
     9.645   137.164     0.200
     9.653   136.766     0.200
     9.834   139.164     0.200
    10.135   145.562     0.200
     1.283    22.461     0.200
     1.347    23.371     0.200
     1.352    23.401     0.200
     1.349    24.391     0.200
     1.395    23.941     0.200
     1.390    24.001     0.200
     1.366    23.761     0.200
     1.513    27.051     0.200
     1.521    26.511     0.200
     1.602    28.141     0.200
     1.606    27.721     0.200
     1.596    27.551     0.200
     1.630    27.941     0.200
     1.639    28.031     0.200
     1.749    29.221     0.200
     1.957    32.221     0.200
     1.992    32.841     0.200
     2.091    34.631     0.200
     2.093    34.881     0.200
     2.145    35.511     0.200
     2.378    38.681     0.200
     2.406    39.581     0.200
     2.454    39.651     0.200
     2.510    41.001     0.200
     3.322    53.081     0.200
     3.473    55.881     0.200
     3.717    57.281     0.200
     3.872    60.581     0.200
     3.894    59.981     0.200
     4.635    68.739     0.200
     4.635    68.381     0.200
     4.801    70.817     0.200
     4.829    70.636     0.200
     5.149    75.304     0.200
     5.310    77.714     0.200
     5.758    83.186     0.200
     5.853    84.577     0.200
     5.876    84.915     0.200
     5.911    85.376     0.200
     5.927    86.150     0.200
     6.092    87.288     0.200
     6.545    96.881     0.200
     6.894   100.381     0.200
     6.915   100.281     0.200
     7.204   106.881     0.200
     8.214   118.081     0.200
     8.442   121.081     0.200
     8.592   123.381     0.200
     9.512   136.281     0.200
     1.463    26.078     0.200
     1.568    28.336     0.200
     1.534    28.266     0.200
     1.540    26.961     0.200
     1.574    27.445     0.200
     1.581    28.125     0.200
     1.622    28.344     0.200
     1.624    28.727     0.200
     1.651    28.906     0.200
     1.685    29.266     0.200
     1.722    30.008     0.200
     1.711    31.391     0.200
     1.729    30.719     0.200
     1.738    30.266     0.200
     1.791    31.344     0.200
     1.763    30.344     0.200
     1.779    30.773     0.200
     1.939    32.773     0.200
     1.977    33.266     0.200
     1.977    33.008     0.200
     2.166    35.977     0.200
     2.264    37.359     0.200
     2.347    39.164     0.200
     2.398    39.227     0.200
     2.739    44.367     0.200
     2.930    48.570     0.200
     3.045    49.766     0.200
     3.103    49.969     0.200
     3.265    52.375     0.200
     3.248    52.070     0.200
     3.289    53.570     0.200
     3.328    53.766     0.200
     3.362    55.164     0.200
     3.601    57.664     0.200
     3.750    60.367     0.200
     3.868    61.164     0.200
     3.875    61.367     0.200
     3.909    61.969     0.200
     4.040    64.867     0.200
     4.392    68.570     0.200
     4.530    71.164     0.200
     4.769    74.367     0.200
     4.831    74.070     0.200
     4.830    72.938     0.200
     5.030    76.539     0.200
     5.030    77.070     0.200
     5.176    78.875     0.200
     5.254    79.766     0.200
     5.809    88.469     0.200
     5.785    87.484     0.200
     5.879    90.039     0.200
     5.905    87.469     0.200
     5.923    88.969     0.200
     5.952    89.625     0.200
     5.940    88.875     0.200
     5.962    90.188     0.200
     6.110    92.711     0.200
     6.121    89.195     0.200
     6.251    94.266     0.200
     6.558    97.164     0.200
     6.910    99.469     0.200
     6.931   100.766     0.200
     7.217   107.266     0.200
     7.887   113.367     0.200
     8.236   117.766     0.200
     8.465   121.469     0.200
     8.613   122.664     0.200
     9.529   134.367     0.200
     9.636   137.266     0.200
     1.668    29.992     0.200
     1.725    30.266     0.200
     1.706    29.156     0.200
     2.345    38.086     0.200
     2.345    37.586     0.200
     2.734    43.789     0.200
     2.734    43.086     0.200
     2.913    46.891     0.200
     2.926    47.789     0.200
     3.240    51.188     0.200
     3.321    52.688     0.200
     3.321    52.992     0.200
     3.369    54.391     0.200
     3.507    56.289     0.200
     3.678    57.086     0.200
     3.760    56.688     0.200
     3.750    58.891     0.200
     3.750    58.289     0.200
     3.769    58.289     0.200
     3.908    60.789     0.200
     3.908    60.688     0.200
     4.036    63.992     0.200
     4.036    64.391     0.200
     4.391    68.289     0.200
     4.366    69.055     0.200
     4.519    70.492     0.200
     4.678    70.734     0.200
     4.713    70.891     0.200
     4.767    73.586     0.200
     4.843    72.703     0.200
     4.826    73.492     0.200
     5.192    77.352     0.200
     5.247    79.289     0.200
     5.353    80.797     0.200
     5.435    80.844     0.200
     5.801    85.797     0.200
     5.823    86.289     0.200
     5.896    89.477     0.200
     5.919    89.562     0.200
     5.917    88.391     0.200
     5.952    88.641     0.200
     5.978    89.586     0.200
     5.983    89.102     0.200
     6.028    90.211     0.200
     6.028    89.992     0.200
     6.099    91.633     0.200
     6.126    91.008     0.200
     6.133    90.398     0.200
     6.244    93.789     0.200
     6.345    93.586     0.200
     6.507    96.930     0.200
     6.573    96.586     0.200
     6.597    97.188     0.200
     6.926   100.289     0.200
     6.947   101.188     0.200
     6.995   101.188     0.200
     7.057   102.711     0.200
     7.225   106.586     0.200
     7.232   106.289     0.200
     7.351   106.289     0.200
     7.462   112.461     0.200
     7.903   113.992     0.200
     8.252   117.789     0.200
     8.482   121.391     0.200
     8.630   123.086     0.200
     8.824   128.312     0.200
     9.254   131.391     0.200
     9.426   134.391     0.200
     9.545   135.586     0.200
     9.608   136.688     0.200
     9.619   136.492     0.200
     9.652   136.789     0.200
    10.213   146.727     0.200
     1.562    28.004     0.200
     1.626    27.996     0.200
     1.615    28.117     0.200
     1.716    29.477     0.200
     1.722    30.027     0.200
     1.778    30.734     0.200
     1.808    31.535     0.200
     1.835    31.215     0.200
     1.931    32.547     0.200
     1.969    33.027     0.200
     2.020    36.027     0.200
     2.267    38.316     0.200
     2.344    38.777     0.200
     2.344    39.875     0.200
     2.405    40.465     0.200
     2.599    43.336     0.200
     2.735    44.176     0.200
     2.735    43.977     0.200
     2.907    47.277     0.200
     3.323    53.977     0.200
     3.323    53.074     0.200
     3.501    57.676     0.200
     3.748    60.574     0.200
     3.748    58.375     0.200
     3.762    59.688     0.200
     3.768    58.676     0.200
     3.789    59.375     0.200
     3.907    61.477     0.200
     3.907    60.875     0.200
     4.037    64.375     0.200
     4.037    63.875     0.200
     4.390    68.676     0.200
     4.408    68.277     0.200
     4.669    70.902     0.200
     4.712    72.676     0.200
     4.766    73.777     0.200
     4.834    72.777     0.200
     4.827    73.777     0.200
     5.023    76.574     0.200
     5.182    77.473     0.200
     5.249    80.277     0.200
     5.426    80.797     0.200
     5.770    87.176     0.200
     5.791    84.496     0.200
     5.799    87.176     0.200
     5.816    84.676     0.200
     5.886    87.086     0.200
     5.910    88.367     0.200
     5.918    88.875     0.200
     5.943    88.609     0.200
     5.959    88.691     0.200
     5.973    89.398     0.200
     6.090    90.234     0.200
     6.116    90.746     0.200
     6.125    90.656     0.200
     6.246    94.074     0.200
     6.498    96.332     0.200
     6.565    97.875     0.200
     6.601    97.176     0.200
     6.918    99.574     0.200
     6.938   100.777     0.200
     6.986   102.875     0.200
     7.048   103.250     0.200
     7.218   106.477     0.200
     7.225   106.977     0.200
     7.342   107.277     0.200
     7.895   114.074     0.200
     8.243   117.676     0.200
     8.472   121.277     0.200
     8.621   122.875     0.200
     8.824   130.195     0.200
     9.245   131.277     0.200
     9.417   133.875     0.200
     9.537   134.375     0.200
     9.611   137.574     0.200
     9.644   135.875     0.200
     9.825   138.977     0.200
     5.443    80.875     0.200
     5.614    82.918     0.200
     5.902    88.488     0.200
     6.093    90.215     0.200
     6.208    90.652     0.200
     6.584    99.232     0.200
     6.616    99.082     0.200
     6.655    98.020     0.200
     6.670    98.389     0.200
     6.702   100.258     0.200
     6.725   100.432     0.200
     6.790    99.641     0.200
     6.803   102.742     0.200
     6.907   100.139     0.200
     7.813   113.367     0.200
     1.637    28.922     0.200
     1.694    30.752     0.200
     1.781    30.822     0.200
     7.827   113.033     0.200
     1.792    31.330     0.200
     2.567    43.141     0.200
     5.453    81.283     0.200
     5.624    83.066     0.200
     5.627    84.848     0.200
     5.909    88.250     0.200
     6.102    91.168     0.200
     6.534    97.486     0.200
     6.621   100.242     0.200
     6.661    98.459     0.200
     6.679    99.107     0.200
     6.673   100.080     0.200
     6.737    99.918     0.200
     6.800   100.242     0.200
     6.789   100.119     0.200
     6.919   101.215     0.200
     7.822   112.971     0.200
     1.552    27.492     0.200
     1.635    30.078     0.200
     2.436    41.148     0.200
     2.863    46.180     0.200
     3.141    50.277     0.200
     3.172    50.180     0.200
     3.172    50.879     0.200
     3.357    53.180     0.200
     3.386    53.578     0.200
     3.509    55.277     0.200
     3.525    55.777     0.200
     3.525    55.480     0.200
     3.562    55.777     0.200
     3.586    56.277     0.200
     3.654    57.879     0.200
     3.654    57.277     0.200
     3.774    58.980     0.200
     3.994    63.680     0.200
     3.994    61.980     0.200
     4.007    62.980     0.200
     4.108    64.078     0.200
     4.108    64.375     0.200
     4.108    64.879     0.200
     4.141    63.980     0.200
     4.256    65.578     0.200
     4.288    66.180     0.200
     4.288    66.879     0.200
     4.455    68.879     0.200
     4.477    70.078     0.200
     4.546    70.480     0.200
     4.587    72.168     0.200
     4.744    72.480     0.200
     4.933    75.078     0.200
     4.965    74.777     0.200
     5.198    78.777     0.200
     5.219    79.180     0.200
     5.254    79.379     0.200
     5.454    81.617     0.200
     5.534    82.180     0.200
     5.570    84.180     0.200
     5.593    83.180     0.200
     5.625    83.164     0.200
     5.776    85.004     0.200
     5.776    86.480     0.200
     5.887    86.680     0.200
     5.887    87.809     0.200
     5.911    87.145     0.200
     5.970    89.480     0.200
     6.104    91.031     0.200
     6.176    90.680     0.200
     6.197    92.480     0.200
     6.220    91.426     0.200
     6.277    93.777     0.200
     6.310    93.078     0.200
     6.335    92.812     0.200
     6.536    97.273     0.200
     6.593   100.148     0.200
     6.623    98.957     0.200
     6.663    99.949     0.200
     6.675    99.082     0.200
     6.681    99.555     0.200
     6.709   100.020     0.200
     6.696    98.180     0.200
     6.737   100.262     0.200
     6.780    99.352     0.200
     6.801   100.445     0.200
     6.790   102.328     0.200
     6.811    99.859     0.200
     6.919   101.254     0.200
     7.301   106.332     0.200
     7.538   109.480     0.200
     7.823   113.379     0.200
     7.923   115.820     0.200
     8.116   116.980     0.200
     8.261   120.109     0.200
     9.167   132.066     0.200
     9.302   137.023     0.200
     9.852   143.180     0.200
     9.957   143.508     0.200
     5.789    85.074     0.200
     5.838    87.734     0.200
     6.765   100.064     0.200
     6.858   102.904     0.200
     7.000   102.264     0.200
     8.020   114.955     0.200
    19.290   265.398     0.200
     1.517    25.277     0.200
     1.545    25.286     0.200
     1.593    26.866     0.200
     1.593    26.986     0.200
     1.981    33.006     0.200
     1.987    32.996     0.200
     2.112    34.636     0.200
     2.251    36.267     0.200
     2.306    37.326     0.200
     2.357    37.687     0.200
     2.375    38.187     0.200
     2.580    41.846     0.200
     2.557    40.386     0.200
     2.635    41.886     0.200
     2.703    42.886     0.200
     2.707    44.486     0.200
     2.826    44.270     0.200
     2.826    44.656     0.200
     2.826    44.796     0.200
     2.833    44.886     0.200
     2.862    44.586     0.200
     2.922    46.414     0.200
     2.922    45.727     0.200
     2.922    46.086     0.200
     2.922    46.187     0.200
     2.922    46.296     0.200
     2.929    46.486     0.200
     3.204    50.532     0.200
     3.204    50.746     0.200
     3.302    52.486     0.200
     3.362    52.326     0.200
     3.426    52.986     0.200
     3.464    54.786     0.200
     3.513    53.556     0.200
     3.483    54.086     0.200
     3.570    53.496     0.200
     3.570    53.846     0.200
     3.579    55.286     0.200
     3.665    57.586     0.200
     3.690    56.156     0.200
     3.741    56.767     0.200
     3.762    58.316     0.200
     3.935    59.536     0.200
     3.978    60.486     0.200
     4.032    61.267     0.200
     4.054    61.136     0.200
     4.072    59.536     0.200
     4.122    63.937     0.200
     4.106    63.376     0.200
     4.223    65.166     0.200
     4.316    64.426     0.200
     4.370    65.496     0.200
     4.365    64.437     0.200
     4.541    66.806     0.200
     4.559    70.326     0.200
     4.624    68.986     0.200
     4.658    70.646     0.200
     4.734    69.749     0.200
     4.734    70.496     0.200
     4.749    71.626     0.200
     4.756    71.216     0.200
     4.824    72.426     0.200
     4.832    70.666     0.200
     4.853    70.846     0.200
     4.870    71.746     0.200
     4.915    71.727     0.200
     4.926    73.326     0.200
     4.980    73.653     0.200
     4.976    75.370     0.200
     4.976    72.986     0.200
     4.978    74.388     0.200
     5.030    73.356     0.200
     5.019    75.176     0.200
     5.353    78.060     0.200
     5.325    79.156     0.200
     5.435    79.626     0.200
     5.435    79.464     0.200
     5.467    80.464     0.200
     5.565    81.616     0.200
     5.623    83.296     0.200
     5.623    82.996     0.200
     5.644    83.877     0.200
     5.657    83.086     0.200
     5.814    84.736     0.200
     5.884    87.269     0.200
     5.917    86.401     0.200
     5.939    86.430     0.200
     5.922    86.596     0.200
     5.953    87.098     0.200
     5.968    89.116     0.200
     6.010    87.541     0.200
     6.064    89.006     0.200
     6.080    89.996     0.200
     6.089    88.664     0.200
     6.089    89.446     0.200
     6.121    89.052     0.200
     6.162    90.216     0.200
     6.184    90.550     0.200
     6.192    90.173     0.200
     6.327    92.479     0.200
     6.357    92.926     0.200
     6.381    92.996     0.200
     6.429    95.359     0.200
     6.570    95.691     0.200
     6.689    97.187     0.200
     6.749    98.301     0.200
     6.749    98.896     0.200
     6.769   100.204     0.200
     6.838    99.267     0.200
     7.007   105.477     0.200
     6.972   101.433     0.200
     7.048   101.386     0.200
     7.115   102.956     0.200
     7.133   102.586     0.200
     7.133   102.461     0.200
     7.219   107.061     0.200
     7.280   105.286     0.200
     7.360   107.837     0.200
     7.429   106.386     0.200
     7.429   106.586     0.200
     7.543   105.886     0.200
     7.539   108.206     0.200
     7.539   108.486     0.200
     7.630   110.176     0.200
     7.630   110.556     0.200
     7.673   110.086     0.200
     7.703   113.111     0.200
     7.870   114.722     0.200
     7.870   115.596     0.200
     8.050   116.066     0.200
     8.100   116.086     0.200
     8.197   117.286     0.200
     8.197   116.187     0.200
     8.218   116.256     0.200
     8.316   119.886     0.200
     8.311   121.624     0.200
     8.471   121.955     0.200
     8.471   124.223     0.200
     8.471   121.687     0.200
     8.616   126.265     0.200
     8.666   122.536     0.200
     8.761   125.986     0.200
     9.100   131.287     0.200
     9.639   136.786     0.200
     9.871   139.225     0.200
    13.970   197.248     0.200
    18.345   252.916     0.200
    18.374   253.281     0.200
    19.904   273.812     0.200
     1.471    27.327     0.200
     1.483    26.387     0.200
     1.494    26.906     0.200
     1.526    27.757     0.200
     1.606    28.227     0.200
     1.733    31.517     0.200
     1.851    33.507     0.200
     1.867    32.787     0.200
     1.895    33.077     0.200
     2.277    38.827     0.200
     2.283    38.617     0.200
     2.234    38.057     0.200
     2.482    41.797     0.200
     2.585    43.607     0.200
     2.698    44.067     0.200
     2.709    45.007     0.200
     3.041    48.667     0.200
     3.044    48.167     0.200
     3.044    48.667     0.200
     3.281    52.067     0.200
     3.370    53.367     0.200
     3.408    53.567     0.200
     3.478    56.427     0.200
     3.464    55.167     0.200
     3.464    54.767     0.200
     3.471    54.767     0.200
     3.574    56.067     0.200
     3.574    56.267     0.200
     3.574    56.507     0.200
     3.628    57.067     0.200
     3.670    57.877     0.200
     3.839    60.367     0.200
     3.839    61.467     0.200
     3.839    61.267     0.200
     3.887    61.667     0.200
     3.887    61.267     0.200
     3.902    61.906     0.200
     3.902    60.437     0.200
     3.952    62.267     0.200
     3.959    62.097     0.200
     3.959    62.297     0.200
     3.999    63.667     0.200
     3.999    62.367     0.200
     4.041    62.817     0.200
     4.119    65.267     0.200
     4.119    64.367     0.200
     4.149    63.867     0.200
     4.156    65.967     0.200
     4.156    64.767     0.200
     4.198    63.906     0.200
     4.238    65.877     0.200
     4.284    66.167     0.200
     4.284    66.467     0.200
     4.354    68.817     0.200
     4.315    67.477     0.200
     4.335    67.646     0.200
     4.367    67.967     0.200
     4.354    68.667     0.200
     4.606    70.567     0.200
     4.620    73.207     0.200
     4.669    71.467     0.200
     4.669    71.627     0.200
     4.659    73.227     0.200
     4.688    72.467     0.200
     4.765    72.567     0.200
     4.766    70.367     0.200
     4.766    71.767     0.200
     4.856    72.587     0.200
     5.002    74.357     0.200
     5.097    79.827     0.200
     5.137    77.087     0.200
     5.112    77.367     0.200
     5.134    77.124     0.200
     5.119    78.067     0.200
     5.168    77.127     0.200
     5.193    76.487     0.200
     5.229    78.097     0.200
     5.240    80.207     0.200
     5.273    78.567     0.200
     5.292    78.947     0.200
     5.307    80.973     0.200
     5.308    79.885     0.200
     5.324    79.607     0.200
     5.394    80.017     0.200
     5.463    81.177     0.200
     5.500    82.267     0.200
     5.568    82.987     0.200
     5.594    84.546     0.200
     5.618    82.727     0.200
     5.624    83.267     0.200
     5.624    83.967     0.200
     5.670    83.847     0.200
     5.738    85.695     0.200
     5.783    85.549     0.200
     5.906    87.411     0.200
     5.924    88.067     0.200
     6.173    91.267     0.200
     6.216    93.017     0.200
     6.279    95.365     0.200
     6.318    95.190     0.200
     6.353    93.577     0.200
     6.361    94.192     0.200
     6.360    95.160     0.200
     6.429    94.532     0.200
     6.481    96.530     0.200
     6.481    96.167     0.200
     6.496    98.553     0.200
     6.470    96.066     0.200
     6.588    97.267     0.200
     6.607    96.813     0.200
     6.723    98.571     0.200
     6.805    99.410     0.200
     6.839   100.095     0.200
     7.014   104.842     0.200
     7.134   104.267     0.200
     7.503   109.742     0.200
     7.795   114.566     0.200
     1.458    25.898     0.200
     1.654    28.539     0.200
     2.807    44.453     0.200
     2.817    44.852     0.200
     2.817    44.953     0.200
     3.009    47.953     0.200
     3.009    47.852     0.200
     3.067    49.148     0.200
     3.146    49.453     0.200
     3.160    50.547     0.200
     3.239    51.352     0.200
     3.258    51.352     0.200
     3.258    51.047     0.200
     3.357    52.852     0.200
     3.357    53.008     0.200
     3.382    54.547     0.200
     3.382    53.547     0.200
     3.407    53.359     0.200
     3.580    56.406     0.200
     3.580    55.547     0.200
     3.657    57.148     0.200
     3.653    56.977     0.200
     3.653    57.438     0.200
     3.755    58.852     0.200
     3.763    58.781     0.200
     3.893    60.352     0.200
     3.901    60.648     0.200
     3.929    59.602     0.200
     3.928    61.352     0.200
     3.934    61.750     0.200
     3.934    61.953     0.200
     4.116    64.352     0.200
     4.157    64.281     0.200
     4.157    64.938     0.200
     4.171    64.820     0.200
     4.171    63.719     0.200
     4.223    63.680     0.200
     4.235    65.047     0.200
     4.235    65.328     0.200
     4.468    69.562     0.200
     4.478    69.312     0.200
     4.494    68.789     0.200
     4.506    67.148     0.200
     4.553    70.422     0.200
     4.553    70.523     0.200
     4.620    70.281     0.200
     4.692    69.656     0.200
     4.800    74.016     0.200
     4.932    73.812     0.200
     4.932    73.227     0.200
     4.923    75.047     0.200
     4.930    75.320     0.200
     4.961    74.102     0.200
     5.047    74.930     0.200
     5.059    74.953     0.200
     5.065    76.820     0.200
     5.071    74.648     0.200
     5.095    75.422     0.200
     5.126    77.438     0.200
     5.149    78.695     0.200
     5.173    78.891     0.200
     5.199    78.641     0.200
     5.220    78.609     0.200
     5.220    78.992     0.200
     5.227    78.523     0.200
     5.289    79.508     0.200
     5.315    79.883     0.200
     5.364    81.656     0.200
     5.364    79.047     0.200
     5.352    79.844     0.200
     5.354    81.125     0.200
     5.360    80.891     0.200
     5.374    81.031     0.200
     5.441    80.352     0.200
     5.515    82.961     0.200
     5.535    81.578     0.200
     5.544    83.125     0.200
     5.582    83.008     0.200
     5.606    84.961     0.200
     5.606    84.398     0.200
     5.668    85.336     0.200
     5.685    83.461     0.200
     5.685    83.203     0.200
     5.690    84.477     0.200
     5.690    84.883     0.200
     5.719    85.516     0.200
     5.783    86.383     0.200
     5.883    88.164     0.200
     5.885    87.844     0.200
     5.899    86.711     0.200
     5.894    88.547     0.200
     5.911    88.383     0.200
     5.917    88.453     0.200
     5.921    89.680     0.200
     5.946    88.633     0.200
     5.980    90.930     0.200
     5.997    89.227     0.200
     5.997    88.578     0.200
     6.035    88.938     0.200
     6.052    89.062     0.200
     6.064    87.898     0.200
     6.088    95.078     0.200
     6.140    93.258     0.200
     6.158    92.992     0.200
     6.133    91.680     0.200
     6.133    91.852     0.200
     6.174    91.328     0.200
     6.162    91.148     0.200
     6.197    90.922     0.200
     6.204    94.055     0.200
     6.224    91.508     0.200
     6.232    93.211     0.200
     6.232    93.539     0.200
     6.260    91.852     0.200
     6.265    92.883     0.200
     6.282    92.320     0.200
     6.276    92.070     0.200
     6.266    93.367     0.200
     6.266    94.250     0.200
     6.324    92.453     0.200
     6.329    93.359     0.200
     6.343    95.109     0.200
     6.367    95.344     0.200
     6.382    93.141     0.200
     6.386    95.453     0.200
     6.415    96.148     0.200
     6.411    96.391     0.200
     6.425    94.336     0.200
     6.425    94.938     0.200
     6.561    95.898     0.200
     6.561    96.078     0.200
     6.578    95.852     0.200
     6.576    97.539     0.200
     6.582    96.617     0.200
     6.600    98.188     0.200
     6.608    98.547     0.200
     6.623    98.242     0.200
     6.623    98.750     0.200
     6.637    98.836     0.200
     6.660    98.500     0.200
     6.688    98.312     0.200
     6.701    98.688     0.200
     6.737   100.961     0.200
     6.737    98.688     0.200
     6.739    98.984     0.200
     6.746    99.727     0.200
     6.776   100.547     0.200
     6.862   101.250     0.200
     6.871   100.328     0.200
     6.866   101.383     0.200
     6.871   100.141     0.200
     6.909   100.492     0.200
     6.987   104.508     0.200
     6.997   101.312     0.200
     6.990   101.562     0.200
     6.998   102.766     0.200
     6.998   102.891     0.200
     7.037   103.250     0.200
     7.044   104.062     0.200
     7.079   103.641     0.200
     7.098   103.266     0.200
     7.158   105.266     0.200
     7.181   105.609     0.200
     7.249   107.281     0.200
     7.251   106.508     0.200
     7.255   106.359     0.200
     7.251   106.602     0.200
     7.268   105.750     0.200
     7.270   105.930     0.200
     7.277   109.023     0.200
     7.311   104.922     0.200
     7.378   111.070     0.200
     7.452   108.781     0.200
     7.484   108.016     0.200
     7.517   111.062     0.200
     7.535   109.852     0.200
     7.554   109.852     0.200
     7.605   111.297     0.200
     7.636   111.359     0.200
     7.694   111.320     0.200
     7.784   113.320     0.200
     7.818   111.672     0.200
     7.818   112.750     0.200
     8.017   117.898     0.200
     8.222   120.422     0.200
     8.292   122.344     0.200
     8.401   124.141     0.200
     8.401   121.352     0.200
     8.501   124.430     0.200
     8.692   125.641     0.200
     8.924   129.297     0.200
     8.924   130.477     0.200
     9.379   136.438     0.200
     9.815   139.250     0.200
    10.043   143.422     0.200
    18.161   250.969     0.200
    18.389   258.992     0.200
    20.321   279.148     0.200
     1.482    27.656     0.200
     1.483    27.164     0.200
     1.555    27.000     0.200
     1.580    27.984     0.200
     1.601    28.445     0.200
     1.690    30.156     0.200
     1.694    30.148     0.200
     1.697    30.875     0.200
     1.823    31.688     0.200
     1.916    33.359     0.200
     1.937    33.734     0.200
     4.388    67.797     0.200
     4.581    68.453     0.200
     5.140    76.328     0.200
     5.183    76.633     0.200
     5.739    84.602     0.200
     5.825    85.789     0.200
     5.837    87.039     0.200
     5.934    87.719     0.200
     5.951    87.562     0.200
     6.013    88.367     0.200
     6.899   100.805     0.200
     6.970   100.633     0.200
     7.073   104.570     0.200
     7.265   104.609     0.200
     7.635   115.203     0.200
     8.056   114.906     0.200
     1.619    27.922     0.200
     2.161    35.016     0.200
     2.313    36.883     0.200
     2.330    38.031     0.200
     2.367    37.781     0.200
     2.557    41.281     0.200
     2.747    43.602     0.200
     2.750    43.891     0.200
     2.791    44.164     0.200
     2.844    44.391     0.200
     3.035    48.281     0.200
     3.279    51.562     0.200
     3.734    57.758     0.200
     3.785    58.773     0.200
     3.928    60.836     0.200
     3.959    60.688     0.200
     4.221    65.578     0.200
     4.273    68.836     0.200
     4.374    67.758     0.200
     4.424    67.523     0.200
     4.595    71.273     0.200
     4.634    70.695     0.200
     4.682    71.789     0.200
     4.748    72.484     0.200
     4.893    72.312     0.200
     4.954    73.359     0.200
     5.060    77.117     0.200
     5.131    78.102     0.200
     5.145    75.906     0.200
     5.309    81.344     0.200
     5.362    77.961     0.200
     5.570    81.117     0.200
     5.816    84.367     0.200
     5.923    89.656     0.200
     6.094    88.797     0.200
     6.120    88.672     0.200
     6.278    91.281     0.200
     7.101   102.562     0.200
     7.130   107.367     0.200
     7.392   106.516     0.200
     9.266   134.406     0.200
     1.433    25.625     0.200
     1.440    25.805     0.200
     1.466    26.062     0.200
     1.543    27.391     0.200
     1.580    27.555     0.200
     1.595    27.641     0.200
     1.608    27.688     0.200
     1.616    29.344     0.200
     1.611    28.625     0.200
     1.613    28.414     0.200
     1.633    28.328     0.200
     1.658    28.781     0.200
     1.665    28.797     0.200
     1.682    28.711     0.200
     1.697    29.125     0.200
     1.718    30.031     0.200
     1.728    30.031     0.200
     1.828    31.195     0.200
     1.832    31.328     0.200
     1.832    30.953     0.200
     1.874    32.828     0.200
     1.874    31.602     0.200
     1.998    33.359     0.200
     2.006    33.305     0.200
     2.118    34.336     0.200
     2.261    37.703     0.200
     2.333    37.664     0.200
     2.349    37.523     0.200
     2.377    38.344     0.200
     2.549    40.797     0.200
     2.579    41.562     0.200
     2.667    42.945     0.200
     2.769    44.578     0.200
     2.907    45.758     0.200
     2.976    47.773     0.200
     3.147    49.336     0.200
     3.281    52.047     0.200
     3.281    51.836     0.200
     3.494    55.031     0.200
     3.494    54.875     0.200
     3.591    56.492     0.200
     3.591    55.875     0.200
     3.591    56.297     0.200
     3.621    56.883     0.200
     3.668    56.117     0.200
     3.769    58.492     0.200
     3.823    59.844     0.200
     3.830    60.781     0.200
     3.830    59.766     0.200
     3.830    59.984     0.200
     3.862    61.984     0.200
     3.872    58.883     0.200
     3.874    58.305     0.200
     3.907    60.172     0.200
     3.907    60.656     0.200
     3.913    61.219     0.200
     3.929    58.617     0.200
     3.997    61.578     0.200
     4.051    63.266     0.200
     4.077    63.797     0.200
     4.077    63.695     0.200
     4.090    62.703     0.200
     4.103    61.094     0.200
     4.180    67.719     0.200
     4.260    65.664     0.200
     4.273    65.375     0.200
     4.318    66.828     0.200
     4.318    66.188     0.200
     4.316    66.656     0.200
     4.348    65.328     0.200
     4.350    67.492     0.200
     4.350    66.617     0.200
     4.390    65.578     0.200
     4.390    65.102     0.200
     4.422    67.414     0.200
     4.414    68.375     0.200
     4.414    66.664     0.200
     4.414    67.484     0.200
     4.431    66.086     0.200
     4.575    67.852     0.200
     4.578    67.891     0.200
     4.578    67.758     0.200
     4.602    69.328     0.200
     4.606    69.266     0.200
     4.619    68.336     0.200
     4.652    69.352     0.200
     4.727    73.445     0.200
     4.727    73.133     0.200
     4.727    72.992     0.200
     4.733    72.289     0.200
     4.799    73.094     0.200
     4.850    73.445     0.200
     4.850    72.188     0.200
     4.850    72.656     0.200
     4.850    72.297     0.200
     4.850    71.945     0.200
     4.904    72.438     0.200
     4.923    72.406     0.200
     4.923    72.281     0.200
     4.960    74.375     0.200
     4.975    76.570     0.200
     5.025    74.812     0.200
     5.026    74.617     0.200
     5.042    75.602     0.200
     5.042    74.906     0.200
     5.062    77.242     0.200
     5.071    75.188     0.200
     5.102    77.578     0.200
     5.101    77.289     0.200
     5.321    78.461     0.200
     5.327    81.383     0.200
     5.379    79.711     0.200
     5.399    81.398     0.200
     5.454    81.000     0.200
     5.503    81.594     0.200
     5.503    81.078     0.200
     5.503    80.836     0.200
     5.534    83.758     0.200
     5.624    83.391     0.200
     5.624    82.414     0.200
     5.624    82.516     0.200
     5.725    84.766     0.200
     5.733    86.617     0.200
     5.732    86.367     0.200
     5.770    86.188     0.200
     5.879    86.461     0.200
     5.890    87.391     0.200
     5.890    87.211     0.200
     5.899    85.656     0.200
     5.940    87.031     0.200
     5.940    87.992     0.200
     5.961    89.555     0.200
     6.012    88.898     0.200
     6.012    89.094     0.200
     6.032    89.688     0.200
     6.061    90.914     0.200
     6.063    89.156     0.200
     6.063    89.289     0.200
     6.086    91.766     0.200
     6.090    89.852     0.200
     6.094    89.953     0.200
     6.121    91.023     0.200
     6.143    93.086     0.200
     6.143    94.516     0.200
     6.149    90.266     0.200
     6.171    90.555     0.200
     6.173    91.531     0.200
     6.197    92.141     0.200
     6.197    91.547     0.200
     6.197    91.844     0.200
     6.224    91.531     0.200
     6.224    91.281     0.200
     6.233    91.742     0.200
     6.233    92.109     0.200
     6.251    91.891     0.200
     6.267    92.586     0.200
     6.325    92.633     0.200
     6.288    93.688     0.200
     6.339    92.945     0.200
     6.339    93.586     0.200
     6.368    93.875     0.200
     6.401    93.188     0.200
     6.401    94.297     0.200
     6.410    95.484     0.200
     6.463    94.883     0.200
     6.493    98.383     0.200
     6.524    95.172     0.200
     6.542    97.688     0.200
     6.545    96.148     0.200
     6.560    97.086     0.200
     6.590    98.047     0.200
     6.590    97.281     0.200
     6.598    97.023     0.200
     6.630    96.922     0.200
     6.675    98.203     0.200
     6.675    97.984     0.200
     6.624   101.141     0.200
     6.718    99.750     0.200
     6.583   102.617     0.200
     6.746    98.883     0.200
     6.746   103.078     0.200
     6.759   100.172     0.200
     6.759    99.484     0.200
     6.781   100.281     0.200
     6.845   101.242     0.200
     6.845    99.641     0.200
     6.876   101.008     0.200
     6.911   103.938     0.200
     6.908   103.188     0.200
     6.918   100.586     0.200
     6.940   103.562     0.200
     6.939   101.086     0.200
     6.962   105.086     0.200
     6.968   102.188     0.200
     7.032   101.750     0.200
     7.084   104.883     0.200
     7.099   103.125     0.200
     7.112   105.086     0.200
     7.139   106.812     0.200
     7.137   106.914     0.200
     7.166   104.484     0.200
     7.173   105.977     0.200
     7.173   105.047     0.200
     7.173   105.430     0.200
     7.199   108.164     0.200
     7.199   107.484     0.200
     7.220   104.383     0.200
     7.220   104.008     0.200
     7.220   103.883     0.200
     7.220   104.055     0.200
     7.238   108.312     0.200
     7.238   107.258     0.200
     7.264   104.406     0.200
     7.274   107.023     0.200
     7.274   105.695     0.200
     7.297   107.242     0.200
     7.297   107.086     0.200
     7.488   107.195     0.200
     7.501   110.125     0.200
     7.501   108.484     0.200
     7.503   110.727     0.200
     7.503   109.984     0.200
     7.513   107.781     0.200
     7.527   108.203     0.200
     7.553   109.023     0.200
     7.576   110.273     0.200
     7.592   108.758     0.200
     7.592   108.391     0.200
     7.611   112.641     0.200
     7.658   111.086     0.200
     7.667   110.164     0.200
     7.705   114.203     0.200
     7.718   114.695     0.200
     7.718   114.188     0.200
     7.743   110.531     0.200
     7.746   114.227     0.200
     7.752   112.812     0.200
     7.767   114.023     0.200
     7.767   113.328     0.200
     7.767   112.383     0.200
     7.772   112.297     0.200
     7.789   112.883     0.200
     7.901   116.227     0.200
     7.916   114.281     0.200
     7.946   116.438     0.200
     7.963   118.797     0.200
     7.963   117.688     0.200
     7.972   117.688     0.200
     8.020   116.805     0.200
     8.017   115.781     0.200
     8.044   115.297     0.200
     8.044   115.102     0.200
     8.044   114.859     0.200
     8.096   118.828     0.200
     8.096   116.484     0.200
     8.096   116.258     0.200
     8.096   116.117     0.200
     8.111   116.477     0.200
     8.128   119.891     0.200
     8.159   119.586     0.200
     8.179   119.516     0.200
     8.179   118.273     0.200
     8.213   119.688     0.200
     8.212   120.281     0.200
     8.212   119.195     0.200
     8.212   119.688     0.200
     8.291   118.133     0.200
     8.291   117.578     0.200
     8.300   117.984     0.200
     8.308   120.586     0.200
     8.314   122.188     0.200
     8.327   121.328     0.200
     8.332   120.086     0.200
     8.362   122.133     0.200
     8.362   121.086     0.200
     8.362   121.484     0.200
     8.390   122.227     0.200
     8.390   122.375     0.200
     8.389   122.242     0.200
     8.389   119.938     0.200
     8.415   121.781     0.200
     8.425   123.688     0.200
     8.438   122.766     0.200
     8.449   120.336     0.200
     8.467   125.172     0.200
     8.520   122.453     0.200
     8.520   121.977     0.200
     8.531   124.086     0.200
     8.540   125.664     0.200
     8.545   121.383     0.200
     8.675   123.281     0.200
     8.693   127.992     0.200
     8.702   129.117     0.200
     8.768   125.727     0.200
     8.768   126.086     0.200
     8.892   128.023     0.200
     8.982   128.984     0.200
     9.027   132.961     0.200
     9.027   132.781     0.200
     9.029   132.711     0.200
     9.029   132.500     0.200
     9.029   129.773     0.200
     9.231   131.344     0.200
     9.246   132.086     0.200
     9.254   135.336     0.200
     9.254   135.023     0.200
     9.272   135.656     0.200
     9.272   133.656     0.200
     9.272   136.977     0.200
     9.304   135.781     0.200
     9.356   132.883     0.200
     9.359   136.625     0.200
     9.359   134.781     0.200
     9.437   134.547     0.200
     9.449   137.188     0.200
     9.460   134.484     0.200
     9.551   135.562     0.200
     9.551   135.688     0.200
     9.581   138.875     0.200
     9.598   139.023     0.200
     9.598   137.398     0.200
     9.611   136.688     0.200
     9.620   139.586     0.200
     9.648   136.781     0.200
     9.651   137.086     0.200
     9.677   140.633     0.200
     9.677   140.188     0.200
     9.677   140.383     0.200
     9.688   138.188     0.200
     9.683   139.336     0.200
     9.716   138.023     0.200
     9.721   138.984     0.200
     9.721   138.344     0.200
     9.760   139.828     0.200
     9.750   144.227     0.200
     9.750   143.734     0.200
     9.760   142.086     0.200
     9.816   140.383     0.200
     9.980   144.234     0.200
     9.980   142.688     0.200
     9.980   142.906     0.200
     9.980   143.312     0.200
    10.020   144.102     0.200
    10.103   144.727     0.200
    10.107   145.883     0.200
    10.151   146.086     0.200
    10.144   146.281     0.200
    10.219   147.719     0.200
    10.219   146.461     0.200
    10.236   148.688     0.200
    10.296   147.188     0.200
    10.328   150.242     0.200
    10.402   148.984     0.200
    10.405   150.961     0.200
    10.433   150.625     0.200
    10.433   149.523     0.200
    10.433   150.281     0.200
    10.604   153.164     0.200
    10.676   156.883     0.200
    10.705   155.383     0.200
    10.742   153.531     0.200
    10.742   152.953     0.200
    10.779   154.203     0.200
    10.869   156.781     0.200
    10.868   153.836     0.200
    10.877   155.586     0.200
    10.930   157.141     0.200
    10.973   156.438     0.200
    11.049   157.711     0.200
    11.095   158.625     0.200
    11.121   156.484     0.200
    11.361   165.383     0.200
    11.740   167.883     0.200
    11.854   174.781     0.200
    12.298   175.586     0.200
    12.786   182.797     0.200
    12.822   181.484     0.200
    12.876   182.883     0.200
    13.382   190.188     0.200
    13.451   191.086     0.200
    13.460   191.188     0.200
    13.464   191.281     0.200
    13.471   191.383     0.200
    13.495   191.688     0.200
    13.505   191.781     0.200
    13.507   191.484     0.200
    13.519   190.312     0.200
    13.519   191.984     0.200
    13.519   191.984     0.200
    13.519   191.188     0.200
    13.507   191.891     0.200
    13.532   192.188     0.200
    13.601   191.695     0.200
    13.612   193.125     0.200
    13.858   198.188     0.200
    14.119   198.984     0.200
    14.249   202.484     0.200
    14.290   202.031     0.200
    14.290   200.961     0.200
    14.516   206.086     0.200
    14.516   205.781     0.200
    14.516   208.008     0.200
    14.528   206.188     0.200
    14.610   205.984     0.200
    14.610   207.227     0.200
    15.137   213.773     0.200
    15.137   213.484     0.200
    15.531   215.555     0.200
    15.531   217.156     0.200
    16.080   226.547     0.200
    16.512   232.375     0.200
    16.789   235.438     0.200
    16.814   235.695     0.200
    18.006   248.703     0.200
    18.006   248.477     0.200
    18.014   249.414     0.200
    18.019   249.461     0.200
    18.281   252.391     0.200
    18.465   256.477     0.200
    18.465   256.086     0.200
    18.465   255.688     0.200
    18.568   257.047     0.200
    18.832   259.375     0.200
    19.068   263.094     0.200
    19.144   262.883     0.200
    19.209   264.586     0.200
    19.524   268.086     0.200
    19.524   267.688     0.200
    19.527   267.773     0.200
    19.674   271.227     0.200
    19.821   273.188     0.200
    19.943   276.086     0.200
    20.300   278.383     0.200
    20.300   277.156     0.200
    20.300   276.781     0.200
    20.320   279.633     0.200
    20.639   280.992     0.200
    20.806   282.688     0.200
    20.806   283.383     0.200
    20.951   285.023     0.200
     1.547    27.770     0.200
     1.550    27.740     0.200
     1.593    28.560     0.200
     1.589    28.380     0.200
     1.602    28.240     0.200
     1.629    30.380     0.200
     1.639    29.940     0.200
     1.625    28.450     0.200
     1.665    30.490     0.200
     1.667    30.730     0.200
     1.673    30.250     0.200
     1.673    29.610     0.200
     1.673    30.910     0.200
     1.696    29.290     0.200
     1.661    28.820     0.200
     1.679    29.270     0.200
     1.685    29.510     0.200
     1.688    29.680     0.200
     1.728    31.320     0.200
     1.728    31.960     0.200
     1.699    29.710     0.200
     1.707    29.750     0.200
     1.756    31.780     0.200
     1.760    31.900     0.200
     1.784    30.970     0.200
     1.807    30.930     0.200
     1.804    32.200     0.200
     1.805    32.240     0.200
     1.798    31.870     0.200
     1.798    32.320     0.200
     1.768    30.890     0.200
     1.791    31.360     0.200
     1.791    31.520     0.200
     1.822    31.585     0.200
     1.822    31.140     0.200
     1.822    31.380     0.200
     1.866    33.320     0.200
     1.866    32.510     0.200
     1.869    31.820     0.200
     1.869    31.990     0.200
     1.958    32.990     0.200
     1.970    33.530     0.200
     2.147    34.940     0.200
     2.226    36.270     0.200
     2.245    37.280     0.200
     2.349    38.420     0.200
     2.710    44.550     0.200
     2.770    45.550     0.200
     3.116    50.180     0.200
     3.159    50.070     0.200
     3.181    51.510     0.200
     3.177    51.002     0.200
     3.246    50.770     0.200
     3.246    51.420     0.200
     3.324    53.368     0.200
     3.324    53.240     0.200
     3.324    52.510     0.200
     3.324    52.370     0.200
     3.324    52.962     0.200
     3.376    53.730     0.200
     3.371    54.030     0.200
     3.426    54.647     0.200
     3.470    55.810     0.200
     3.467    55.267     0.200
     3.438    54.510     0.200
     3.527    56.441     0.200
     3.527    56.255     0.200
     3.584    57.620     0.200
     3.595    56.030     0.200
     3.629    57.629     0.200
     3.634    57.124     0.200
     3.686    57.580     0.200
     3.760    59.982     0.200
     3.754    59.543     0.200
     3.801    60.080     0.200
     3.784    58.990     0.200
     3.784    59.302     0.200
     3.780    60.260     0.200
     3.829    61.360     0.200
     3.845    60.550     0.200
     3.863    61.748     0.200
     3.857    60.622     0.200
     3.894    61.940     0.200
     3.912    62.078     0.200
     4.040    63.878     0.200
     3.960    60.090     0.200
     3.934    62.430     0.200
     3.978    61.946     0.200
     3.997    62.048     0.200
     4.019    64.120     0.200
     4.025    63.270     0.200
     4.004    62.592     0.200
     4.064    65.590     0.200
     4.124    62.850     0.200
     4.095    63.950     0.200
     4.147    65.717     0.200
     4.147    65.185     0.200
     4.169    65.520     0.200
     4.166    63.900     0.200
     4.145    66.210     0.200
     4.177    65.309     0.200
     4.177    65.506     0.200
     4.184    65.241     0.200
     4.222    66.000     0.200
     4.250    64.340     0.200
     4.250    64.770     0.200
     4.248    64.270     0.200
     4.283    66.837     0.200
     4.303    66.990     0.200
     4.303    66.328     0.200
     4.303    66.479     0.200
     4.309    65.260     0.200
     4.317    67.245     0.200
     4.317    67.482     0.200
     4.330    65.430     0.200
     4.373    66.440     0.200
     4.356    67.352     0.200
     4.396    66.410     0.200
     4.396    68.890     0.200
     4.358    71.518     0.200
     4.432    66.680     0.200
     4.410    69.639     0.200
     4.414    69.160     0.200
     4.407    70.210     0.200
     4.473    67.190     0.200
     4.498    70.336     0.200
     4.530    68.490     0.200
     4.519    70.302     0.200
     4.571    68.930     0.200
     4.615    69.810     0.200
     4.614    69.340     0.200
     4.616    70.110     0.200
     4.637    69.490     0.200
     4.637    71.580     0.200
     4.628    72.229     0.200
     4.686    71.020     0.200
     4.656    72.102     0.200
     4.656    71.698     0.200
     4.702    70.630     0.200
     4.726    71.920     0.200
     4.744    73.155     0.200
     4.808    71.780     0.200
     4.808    71.560     0.200
     4.814    72.260     0.200
     4.776    71.790     0.200
     4.812    73.800     0.200
     4.841    74.980     0.200
     4.851    72.270     0.200
     4.858    75.490     0.200
     4.882    75.770     0.200
     4.912    75.702     0.200
     5.025    76.891     0.200
     5.019    77.129     0.200
     5.021    77.808     0.200
     5.054    78.148     0.200
     5.059    77.332     0.200
     5.164    80.636     0.200
     5.199    77.109     0.200
     5.224    79.540     0.200
     5.289    80.613     0.200
     5.257    80.016     0.200
     5.271    81.170     0.200
     5.355    81.502     0.200
     5.371    81.374     0.200
     5.378    82.053     0.200
     5.443    81.674     0.200
     5.443    81.400     0.200
     5.440    82.665     0.200
     5.441    82.053     0.200
     5.470    82.563     0.200
     5.477    83.955     0.200
     5.492    82.699     0.200
     5.513    82.937     0.200
     5.518    83.310     0.200
     5.558    84.261     0.200
     5.548    85.382     0.200
     5.545    83.446     0.200
     5.575    84.057     0.200
     5.603    84.499     0.200
     5.674    85.790     0.200
     5.649    85.552     0.200
     5.481    84.940     0.200
     5.652    85.654     0.200
     5.652    84.906     0.200
     5.682    85.552     0.200
     5.738    86.027     0.200
     5.809    86.280     0.200
     5.819    86.350     0.200
     5.815    87.658     0.200
     5.860    92.110     0.200
     5.867    85.850     0.200
     5.850    89.118     0.200
     5.903    88.816     0.200
     5.888    88.948     0.200
     5.927    89.225     0.200
     5.960    90.112     0.200
     5.975    88.637     0.200
     5.985    90.159     0.200
     5.955    89.288     0.200
     5.990    90.053     0.200
     5.982    90.069     0.200
     6.036    90.045     0.200
     6.043    90.880     0.200
     6.028    90.980     0.200
     6.027    89.820     0.200
     6.027    90.069     0.200
     6.106    92.230     0.200
     6.105    91.190     0.200
     6.105    90.090     0.200
     6.133    91.597     0.200
     6.141    90.334     0.200
     6.188    93.944     0.200
     6.141    92.880     0.200
     6.188    91.860     0.200
     6.246    94.300     0.200
     6.246    94.180     0.200
     6.246    94.080     0.200
     6.338    94.335     0.200
     6.368    95.105     0.200
     6.514    99.640     0.200
     6.514    96.780     0.200
     6.559    99.519     0.200
     6.580    99.580     0.200
     6.594   100.021     0.200
     6.641    99.580     0.200
     6.729   100.780     0.200
     6.832   101.680     0.200
     6.855   100.334     0.200
     7.003   101.080     0.200
     7.054   108.430     0.200
     7.065   102.775     0.200
     7.065   102.970     0.200
     7.083   103.520     0.200
     7.146   107.500     0.200
     7.209   109.920     0.200
     7.209   105.561     0.200
     7.167   105.320     0.200
     7.304   109.980     0.200
     7.315   107.450     0.200
     7.315   107.689     0.200
     7.315   109.080     0.200
     7.359   106.470     0.200
     7.359   106.080     0.200
     7.455   111.730     0.200
     7.579   114.249     0.200
     7.626   110.980     0.200
     7.655   115.068     0.200
     7.742   116.860     0.200
     7.820   118.680     0.200
     7.926   118.218     0.200
     7.974   114.880     0.200
     8.045   116.270     0.200
     8.167   119.230     0.200
     8.223   122.023     0.200
     8.223   123.390     0.200
     8.250   119.390     0.200
     8.258   119.060     0.200
     8.361   123.473     0.200
     8.378   122.910     0.200
     8.397   120.830     0.200
     8.397   120.520     0.200
     8.497   125.082     0.200
     8.829   130.458     0.200
     8.829   131.310     0.200
     8.829   130.649     0.200
     8.829   128.130     0.200
     8.853   131.379     0.200
     8.966   132.273     0.200
     9.039   133.619     0.200
     9.367   138.327     0.200
     9.374   135.730     0.200
     9.417   138.510     0.200
     9.419   137.733     0.200
     9.475   138.929     0.200
     9.569   137.630     0.200
    10.208   147.693     0.200
    10.208   146.220     0.200
    11.736   167.630     0.200
    11.970   170.920     0.200
    12.709   180.710     0.200
    14.385   205.580     0.200
    14.432   206.249     0.200
    14.432   204.870     0.200
    14.931   210.070     0.200
    17.059   238.520     0.200
    17.361   242.210     0.200
    17.944   249.030     0.200
     3.895    61.100     0.200
     4.317    67.540     0.200
     3.969    62.071     0.200
     3.527    56.312     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.947    53.840     0.200
     3.207    63.441     0.200
     3.862    75.941     0.200
     4.020    75.941     0.200
     6.645   124.941     0.200
     3.028    54.473     0.200
     4.965    90.211     0.200
     4.258    80.258     0.200
     6.894   133.258     0.200
     7.132   136.258     0.200
     4.698    92.242     0.200
     5.454   104.616     0.200
     4.979    90.526     0.200
     5.472   100.626     0.200
     4.036    75.238     0.200
     4.193    78.738     0.200
     4.880    96.238     0.200
     4.806    94.746     0.200
     4.843    91.645     0.200
     5.104    97.746     0.200
     3.028    59.750     0.200
     4.096    79.750     0.200
     4.253    80.750     0.200
     3.405    61.750     0.200
     4.135    76.250     0.200
     4.293    81.250     0.200
     6.866   133.250     0.200
     3.080    61.227     0.200
     4.901    90.227     0.200
     7.352   144.227     0.200
     8.525   166.764     0.200
     4.711    90.472     0.200
     3.179    61.344     0.200
     4.957    92.344     0.200
     5.433   105.742     0.200
     6.465   126.242     0.200
     7.409   145.242     0.200
     4.791    88.957     0.200
     5.553   100.957     0.200
     3.745    66.719     0.200
     3.902    76.219     0.200
     4.700    89.918     0.200
     4.776    89.219     0.200
     8.622   169.719     0.200
     4.414    86.148     0.200
     4.969    94.844     0.200
     6.797   130.844     0.200
     2.932    60.535     0.200
     4.168    77.234     0.200
     4.320    79.734     0.200
     4.485    86.934     0.200
     4.620    88.637     0.200
     5.513   108.256     0.200
     3.643    72.469     0.200
     4.778    89.469     0.200
     3.753    67.750     0.200
     4.480    82.844     0.200
     4.996    91.445     0.200
     5.533   108.750     0.200
     6.790   130.047     0.200
     4.084    81.070     0.200
     6.017   117.754     0.200
     7.236   136.652     0.200
     5.636   111.281     0.200
     3.209    57.770     0.200
     2.721    49.754     0.200
     3.033    54.953     0.200
     4.164    74.254     0.200
     4.272    76.207     0.200
     4.447    83.207     0.200
     8.349   161.207     0.200
     3.728    71.057     0.200
     4.125    76.383     0.200
     6.021   108.984     0.200
     6.088   120.086     0.200
     6.354   119.086     0.200
     6.462   125.789     0.200
     4.159    77.344     0.200
     4.701    90.141     0.200
     3.253    58.489     0.200
     4.598    88.674     0.200
     4.265    80.078     0.200
     4.560    85.867     0.200
     3.091    63.243     0.200
     3.577    65.443     0.200
     4.515    89.273     0.200
     4.354    87.751     0.200
     4.896    89.151     0.200
     5.776   108.438     0.200
     4.344    84.516     0.200
     3.635    74.078     0.200
     4.355    84.078     0.200
     7.491   140.578     0.200
     4.331    82.758     0.200
     4.448    83.848     0.200
     5.881   109.246     0.200
     6.343   119.145     0.200
     4.360    81.801     0.200
     4.922    93.102     0.200
     7.031   131.199     0.200
     4.935    93.734     0.200
     4.521    84.141     0.200
     4.935    95.938     0.200
     6.873   132.340     0.200
     4.261    80.320     0.200
     4.348    82.240     0.200
     3.962    71.240     0.200
     4.341    84.740     0.200
     4.951    94.740     0.200
     5.160   100.240     0.200
     4.348    80.760     0.200
     4.520    88.160     0.200
     4.336    83.531     0.200
     5.946   112.531     0.200
     7.062   133.234     0.200
     9.390   175.734     0.200
     9.967   186.930     0.200
     4.921    92.625     0.200
     4.958    93.918     0.200
     4.915    93.747     0.200
     7.129   134.172     0.200
     7.483   139.570     0.200
     3.939    74.595     0.200
     4.358    83.828     0.200
     6.988   130.930     0.200
     3.196    57.850     0.200
     3.201    59.650     0.200
     7.505   140.418     0.200
     7.379   137.227     0.200
     7.471   139.127     0.200
     8.397   155.127     0.200
     8.807   162.627     0.200
     6.169   113.710     0.200
     6.596   121.710     0.200
     7.396   136.110     0.200
     8.394   155.210     0.200
     2.980    59.002     0.200
     3.464    68.900     0.200
     6.951   131.727     0.200
     2.613    46.898     0.200
     2.728    52.242     0.200
     4.647    86.125     0.200
     4.642    86.727     0.200
     7.288   138.141     0.200
     7.796   145.941     0.200
     3.909    73.191     0.200
     4.065    73.270     0.200
     4.109    72.941     0.200
     2.786    53.609     0.200
     9.718   181.301     0.200
     3.419    61.125     0.200
     7.331   137.133     0.200
     4.680    89.570     0.200
     5.809   105.984     0.200
     6.330   116.086     0.200
     6.560   120.586     0.200
     6.914   126.789     0.200
     6.935   126.188     0.200
     7.132   131.289     0.200
     7.219   132.391     0.200
     7.752   151.586     0.200
     7.893   145.484     0.200
     8.002   146.484     0.200
     8.005   153.391     0.200
     8.621   158.289     0.200
     8.814   170.086     0.200
     6.465   128.766     0.200
     8.807   168.969     0.200
     9.721   180.984     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.580     9.242     0.200
     3.207    52.941     0.200
     3.945    64.441     0.200
     4.678    77.441     0.200
     7.193   116.641     0.200
     7.220   116.941     0.200
     0.535     9.969     0.200
     0.531    10.770     0.200
     0.542    10.369     0.200
     0.690    12.969     0.200
     1.717    30.869     0.200
     1.855    30.869     0.200
     1.879    33.469     0.200
     0.450     8.973     0.200
     0.691    12.973     0.200
     0.866    15.473     0.200
     1.519    26.973     0.200
     1.591    26.871     0.200
     2.710    45.973     0.200
     3.555    57.473     0.200
     4.554    77.473     0.200
     4.759    77.473     0.200
     4.835    76.473     0.200
     4.952    81.473     0.200
     6.027   102.871     0.200
     6.379   101.273     0.200
     8.586   153.473     0.200
     0.665    11.406     0.200
     0.853    15.305     0.200
     2.466    43.008     0.200
     3.096    52.508     0.200
     4.162    68.008     0.200
     7.436   120.508     0.200
     0.773    12.961     0.200
     0.957    16.961     0.200
     2.140    37.758     0.200
     3.191    52.758     0.200
     4.416    74.258     0.200
     5.438    95.359     0.200
     6.186   104.258     0.200
     7.455   120.258     0.200
     0.870    17.039     0.200
     1.916    34.742     0.200
     3.177    52.742     0.200
     4.188    71.539     0.200
     5.962   100.039     0.200
     0.748    12.616     0.200
     1.077    19.616     0.200
     2.122    35.616     0.200
     3.174    54.116     0.200
     6.488   104.616     0.200
     7.721   123.616     0.200
     1.029    19.126     0.200
     1.431    25.126     0.200
     2.072    38.126     0.200
     2.187    38.126     0.200
     0.497     9.840     0.200
     0.686    12.738     0.200
     0.899    17.738     0.200
     2.974    49.238     0.200
     0.488     9.746     0.200
     0.825    15.746     0.200
     1.415    25.746     0.200
     1.656    28.746     0.200
     2.432    45.547     0.200
     2.905    50.746     0.200
     4.125    68.246     0.200
     5.673    99.246     0.200
     0.524     9.750     0.200
     0.930    18.250     0.200
     1.216    22.750     0.200
     1.267    22.750     0.200
     1.977    36.250     0.200
     0.615    11.250     0.200
     0.977    18.250     0.200
     1.259    23.250     0.200
     2.018    33.750     0.200
     2.127    37.250     0.200
     2.251    41.449     0.200
     3.260    56.449     0.200
     4.784    78.750     0.200
     0.527    10.227     0.200
     0.981    18.727     0.200
     1.406    24.727     0.200
     2.029    36.227     0.200
     2.173    38.727     0.200
     2.188    39.125     0.200
     3.186    53.625     0.200
     5.391    89.527     0.200
     5.848    99.727     0.200
     6.213   102.227     0.200
     6.778   115.227     0.200
     7.187   116.227     0.200
     0.503     9.633     0.200
     0.735    13.133     0.200
     1.780    32.531     0.200
     2.026    35.133     0.200
     2.425    44.832     0.200
     2.832    49.133     0.200
     3.449    56.633     0.200
     0.755    12.764     0.200
     0.966    16.863     0.200
     1.168    20.764     0.200
     2.156    37.264     0.200
     2.265    38.264     0.200
     2.402    39.463     0.200
     2.123    39.764     0.200
     3.208    55.764     0.200
     3.140    54.564     0.200
     4.274    68.264     0.200
     6.936   113.764     0.200
     8.432   143.764     0.200
     0.525     9.372     0.200
     0.553    10.372     0.200
     0.559    10.372     0.200
     0.706    14.872     0.200
     2.480    47.372     0.200
     3.862    65.372     0.200
     0.582    11.242     0.200
     0.726    12.039     0.200
     1.024    18.742     0.200
     2.070    35.242     0.200
     3.179    55.641     0.200
     6.116    99.242     0.200
     7.427   124.242     0.200
     8.331   137.242     0.200
     9.716   159.945     0.200
     0.663    12.084     0.200
     1.047    18.884     0.200
     2.086    38.584     0.200
     2.341    40.584     0.200
     3.138    54.584     0.200
     3.222    55.084     0.200
     5.014    83.184     0.200
     8.485   138.584     0.200
     9.798   163.484     0.200
     0.701    12.957     0.200
     1.070    18.957     0.200
     2.107    36.258     0.200
     2.366    41.057     0.200
     3.230    52.656     0.200
     3.725    60.156     0.200
     7.361   121.457     0.200
     0.218     5.418     0.200
     0.532    10.020     0.200
     0.696    13.020     0.200
     0.669    12.719     0.200
     1.664    27.719     0.200
     5.421    87.219     0.200
     5.455    94.719     0.200
     5.659    91.719     0.200
     9.821   158.719     0.200
     0.090     3.547     0.200
     0.408     7.250     0.200
     0.521     9.445     0.200
     0.804    15.750     0.200
     0.909    17.250     0.200
     1.205    23.047     0.200
     1.294    23.250     0.200
     1.443    26.750     0.200
     1.451    26.250     0.200
     2.236    39.250     0.200
     2.659    44.047     0.200
     3.674    60.047     0.200
     6.780   110.047     0.200
     6.780   109.750     0.200
     6.797   108.547     0.200
     8.143   131.047     0.200
     8.848   143.445     0.200
     8.848   148.148     0.200
    10.848   175.250     0.200
     0.093     3.336     0.200
     1.038    20.535     0.200
     0.955    17.535     0.200
     1.170    21.035     0.200
     1.289    22.535     0.200
     1.524    27.535     0.200
     1.771    32.035     0.200
     1.948    36.035     0.200
     1.911    35.035     0.200
     2.157    38.137     0.200
     2.343    41.035     0.200
     2.465    42.535     0.200
     2.759    45.836     0.200
     4.168    71.336     0.200
     4.485    75.836     0.200
     6.400   110.637     0.200
     6.598   110.137     0.200
     8.380   135.535     0.200
     0.108     2.557     0.200
     0.226     4.156     0.200
     0.497     9.057     0.200
     1.217    22.057     0.200
     1.282    23.057     0.200
     1.453    26.357     0.200
     4.432    71.256     0.200
     0.708    13.684     0.200
     1.260    22.783     0.200
     1.366    23.084     0.200
     1.499    26.885     0.200
     1.963    33.984     0.200
     2.025    33.584     0.200
     2.286    37.584     0.200
     2.624    43.084     0.200
     2.774    48.385     0.200
     3.522    57.584     0.200
     4.554    78.084     0.200
     5.343    90.484     0.200
     8.278   139.084     0.200
     0.377     7.867     0.200
     0.527     9.766     0.200
     0.760    15.070     0.200
     6.008    99.266     0.200
     0.747    13.844     0.200
     1.226    21.547     0.200
     1.521    25.445     0.200
     2.075    35.344     0.200
     2.199    37.547     0.200
     2.232    40.367     0.200
     2.340    39.047     0.200
     2.371    44.047     0.200
     3.747    61.648     0.200
     4.053    64.547     0.200
     4.053    71.047     0.200
     4.341    74.547     0.200
     6.154   100.148     0.200
     6.393   107.547     0.200
     6.541   105.047     0.200
     6.549   108.148     0.200
     6.549   112.844     0.200
     6.927   117.047     0.200
     8.471   136.047     0.200
     0.183     3.867     0.200
     0.307     6.570     0.200
     0.670    12.570     0.200
     0.923    16.570     0.200
     1.126    20.469     0.200
     1.142    22.070     0.200
     1.355    25.367     0.200
     1.371    24.773     0.200
     1.730    29.273     0.200
     1.821    30.570     0.200
     2.221    40.773     0.200
     2.747    47.867     0.200
     7.488   119.570     0.200
     0.709    14.453     0.200
     0.922    16.852     0.200
     1.168    21.352     0.200
     1.314    22.652     0.200
     1.587    26.754     0.200
     1.699    29.551     0.200
     1.788    31.953     0.200
     2.380    38.453     0.200
     2.554    42.953     0.200
     2.642    45.262     0.200
     3.736    61.152     0.200
     8.027   132.152     0.200
     0.205     4.883     0.200
     0.664    11.781     0.200
     1.077    21.281     0.200
     1.254    23.281     0.200
     1.475    26.578     0.200
     1.495    26.578     0.200
     1.494    27.883     0.200
     1.539    27.281     0.200
     1.918    36.281     0.200
     1.991    36.078     0.200
     2.015    36.383     0.200
     2.139    38.078     0.200
     2.173    40.078     0.200
     2.430    42.680     0.200
     4.220    72.781     0.200
     6.211   101.180     0.200
     0.600    11.430     0.200
     1.062    18.930     0.200
     1.077    20.133     0.200
     1.441    24.727     0.200
     1.531    26.328     0.200
     1.608    27.133     0.200
     1.872    30.930     0.200
     1.959    35.328     0.200
     1.961    32.930     0.200
     2.252    37.227     0.200
     2.907    47.531     0.200
     3.997    69.430     0.200
     6.483   105.031     0.200
     0.733    14.969     0.200
     1.122    22.170     0.200
     1.022    18.770     0.200
     1.189    22.969     0.200
     1.510    26.869     0.200
     1.767    30.570     0.200
     2.538    43.570     0.200
     6.722   111.670     0.200
     7.664   128.770     0.200
     0.707    12.141     0.200
     0.975    18.234     0.200
     1.079    20.727     0.200
     1.194    22.234     0.200
     1.401    24.836     0.200
     1.691    29.734     0.200
     1.706    30.938     0.200
     2.269    39.641     0.200
     2.539    41.438     0.200
     3.245    52.938     0.200
     4.392    75.141     0.200
     7.703   123.438     0.200
     1.296    23.203     0.200
     1.363    23.805     0.200
     1.455    25.406     0.200
     1.533    28.000     0.200
     1.666    28.602     0.200
     1.782    31.703     0.200
     1.913    34.406     0.200
     1.900    33.203     0.200
     2.159    37.203     0.200
     2.349    39.203     0.200
     2.438    41.305     0.200
     2.450    44.805     0.200
     2.692    44.703     0.200
     2.888    50.602     0.200
     3.677    64.000     0.200
     3.947    68.203     0.200
     4.172    73.703     0.200
     1.310    23.855     0.200
     1.441    24.953     0.200
     1.366    23.555     0.200
     1.680    28.254     0.200
     1.916    33.254     0.200
     2.442    41.254     0.200
     2.693    44.652     0.200
     5.052    83.652     0.200
     1.167    20.605     0.200
     1.371    25.137     0.200
     1.443    25.406     0.200
     1.367    23.008     0.200
     1.865    32.406     0.200
     2.383    39.207     0.200
     2.670    43.406     0.200
     4.272    72.508     0.200
     4.271    72.008     0.200
     4.447    76.707     0.200
     7.305   116.809     0.200
     0.349     7.000     0.200
     0.834    15.398     0.200
     1.652    29.500     0.200
     1.669    30.398     0.200
     1.904    34.398     0.200
     1.850    32.398     0.200
     1.864    31.898     0.200
     2.195    38.297     0.200
     5.624    98.398     0.200
     7.328   119.000     0.200
     0.332     6.926     0.200
     0.369     7.486     0.200
     0.628    11.525     0.200
     0.992    18.926     0.200
     1.414    24.926     0.200
     1.706    29.426     0.200
     1.962    34.525     0.200
     2.201    37.826     0.200
     2.190    38.525     0.200
     2.449    41.125     0.200
     7.538   123.727     0.200
     0.661    12.857     0.200
     1.096    19.557     0.200
     1.240    21.457     0.200
     3.234    56.857     0.200
     3.249    56.557     0.200
     6.026   100.957     0.200
     0.572    10.688     0.200
     1.052    18.289     0.200
     1.179    22.086     0.200
     1.484    25.383     0.200
     1.704    28.688     0.200
     1.727    28.984     0.200
     1.995    34.289     0.200
     4.914    86.086     0.200
     6.462   102.688     0.200
     6.462   110.789     0.200
     6.595   110.383     0.200
     7.017   116.789     0.200
     7.187   116.383     0.200
     0.525    10.742     0.200
     1.008    18.539     0.200
     1.154    21.742     0.200
     1.457    26.844     0.200
     1.751    29.242     0.200
     0.310     6.141     0.200
     0.459     9.859     0.200
     0.530    10.000     0.200
     0.546    10.711     0.200
     0.687    12.914     0.200
     0.962    19.039     0.200
     1.005    18.867     0.200
     1.538    26.641     0.200
     1.538    26.742     0.200
     1.788    30.641     0.200
     1.788    30.742     0.200
     2.462    41.828     0.200
     3.258    57.742     0.200
     3.344    57.164     0.200
     3.468    61.344     0.200
     4.338    72.742     0.200
     5.100    86.078     0.200
     7.774   128.141     0.200
     0.356     6.758     0.200
     0.683    12.859     0.200
     0.944    18.461     0.200
     1.350    25.062     0.200
     1.446    26.258     0.200
     2.140    38.062     0.200
     5.573    94.359     0.200
     7.852   131.859     0.200
     0.335     6.688     0.200
     0.472    10.438     0.200
     0.503    10.639     0.200
     0.591    11.269     0.200
     0.722    12.789     0.200
     0.692    13.809     0.200
     0.938    17.889     0.200
     1.038    19.309     0.200
     1.365    25.188     0.200
     1.505    26.889     0.200
     1.530    26.889     0.200
     2.261    38.789     0.200
     2.486    42.389     0.200
     3.482    59.589     0.200
     0.443     8.374     0.200
     1.227    22.974     0.200
     1.182    23.474     0.200
     1.250    24.474     0.200
     1.627    27.574     0.200
     1.202    21.078     0.200
     1.854    32.875     0.200
     2.245    37.375     0.200
     2.275    37.977     0.200
     2.374    39.078     0.200
     2.654    43.375     0.200
     4.112    65.477     0.200
     6.549   107.180     0.200
     6.560   105.078     0.200
     7.567   129.578     0.200
     0.128     5.325     0.200
     0.471     9.956     0.200
     0.602    12.346     0.200
     0.642    12.565     0.200
     1.235    20.556     0.200
     1.422    25.155     0.200
     1.478    25.355     0.200
     1.877    32.756     0.200
     2.262    36.855     0.200
     2.669    43.155     0.200
     3.701    64.256     0.200
     3.937    64.256     0.200
     4.230    72.056     0.200
     4.593    79.556     0.200
     6.326   101.056     0.200
     7.550   123.556     0.200
     0.162     3.566     0.200
     0.627    12.266     0.200
     0.685    12.668     0.200
     0.704    13.066     0.200
     0.786    14.367     0.200
     0.787    14.367     0.200
     0.821    15.867     0.200
     0.789    15.188     0.200
     0.895    16.168     0.200
     1.022    28.656     0.200
     1.011    20.086     0.200
     1.071    20.156     0.200
     1.152    20.008     0.200
     1.152    20.668     0.200
     1.158    21.188     0.200
     1.347    24.297     0.200
     1.515    26.367     0.200
     1.500    28.066     0.200
     1.957    33.367     0.200
     2.218    37.766     0.200
     2.414    41.328     0.200
     2.863    48.527     0.200
     3.243    53.316     0.200
     3.194    54.637     0.200
     3.317    56.039     0.200
     3.361    55.637     0.200
     0.570    11.684     0.200
     0.629    11.582     0.200
     0.655    11.684     0.200
     0.753    13.582     0.200
     0.727    12.980     0.200
     0.739    13.781     0.200
     0.780    14.582     0.200
     0.836    14.781     0.200
     1.291    23.383     0.200
     2.018    34.684     0.200
     2.301    38.980     0.200
     3.851    66.582     0.200
     0.190     3.943     0.200
     0.647    13.043     0.200
     0.731    13.243     0.200
     0.810    15.143     0.200
     0.847    14.843     0.200
     0.922    16.943     0.200
     0.928    17.943     0.200
     1.175    20.843     0.200
     1.514    27.843     0.200
     1.741    29.643     0.200
     2.041    35.343     0.200
     2.037    35.943     0.200
     5.711    94.443     0.200
     0.176     4.672     0.200
     0.187     4.875     0.200
     0.423     9.074     0.200
     0.522    10.473     0.200
     0.646    12.074     0.200
     0.669    12.473     0.200
     0.741    13.875     0.200
     0.834    14.973     0.200
     0.841    14.773     0.200
     0.935    16.773     0.200
     1.044    18.074     0.200
     1.190    20.574     0.200
     1.169    21.973     0.200
     1.236    21.375     0.200
     1.641    27.574     0.200
     1.661    27.875     0.200
     1.985    33.773     0.200
     2.105    35.273     0.200
     2.329    38.172     0.200
     2.394    39.875     0.200
     4.118    70.473     0.200
     4.997    82.074     0.200
     8.418   137.273     0.200
     0.187     4.992     0.200
     0.255     7.195     0.200
     0.415     8.594     0.200
     0.415     8.594     0.200
     0.686    12.992     0.200
     0.764    13.891     0.200
     0.780    14.695     0.200
     0.841    14.992     0.200
     1.006    17.891     0.200
     1.082    19.289     0.200
     1.192    20.992     0.200
     1.128    19.992     0.200
     1.281    22.992     0.200
     1.233    22.289     0.200
     1.384    23.594     0.200
     1.638    29.891     0.200
     1.923    33.492     0.200
     2.266    38.820     0.200
     2.429    40.094     0.200
     2.752    44.789     0.200
     2.755    46.000     0.200
     3.263    53.969     0.200
     7.762   129.492     0.200
     0.517     8.981     0.200
     0.499     9.401     0.200
     0.558     9.932     0.200
     0.732    13.481     0.200
     0.791    15.052     0.200
     0.792    16.081     0.200
     0.840    16.191     0.200
     1.040    18.892     0.200
     1.177    21.382     0.200
     1.293    23.781     0.200
     1.419    24.651     0.200
     3.922    64.151     0.200
     4.354    75.151     0.200
     0.448     9.016     0.200
     0.510    10.348     0.200
     0.520    10.035     0.200
     0.555    11.059     0.200
     0.743    14.137     0.200
     0.795    15.238     0.200
     0.793    15.137     0.200
     0.853    15.887     0.200
     1.052    19.027     0.200
     1.158    20.445     0.200
     1.189    21.148     0.200
     1.285    22.695     0.200
     1.431    25.898     0.200
     2.115    36.348     0.200
     2.142    37.336     0.200
     2.142    36.738     0.200
     2.522    41.977     0.200
     3.137    51.547     0.200
     3.300    54.957     0.200
     3.500    56.977     0.200
     5.776   101.035     0.200
     5.835    94.738     0.200
     6.875   109.637     0.200
     7.480   121.836     0.200
     8.284   133.336     0.200
     8.369   136.637     0.200
     8.441   138.137     0.200
     8.694   140.738     0.200
     9.190   150.836     0.200
     0.482     8.715     0.200
     0.485     8.816     0.200
     0.492     9.535     0.200
     0.759    15.016     0.200
     0.825    15.645     0.200
     0.850    16.055     0.200
     1.038    19.215     0.200
     1.192    20.637     0.200
     1.180    21.527     0.200
     1.418    25.055     0.200
     1.813    32.406     0.200
     2.139    36.355     0.200
     2.169    37.566     0.200
     2.917    47.477     0.200
     3.162    52.016     0.200
     3.209    51.867     0.200
     3.219    52.957     0.200
     3.267    53.137     0.200
     3.902    63.516     0.200
     4.863    83.215     0.200
     0.418     7.949     0.200
     0.528    10.207     0.200
     0.514    10.117     0.200
     0.546    10.207     0.200
     0.765    14.906     0.200
     0.750    13.859     0.200
     0.821    15.578     0.200
     0.842    16.488     0.200
     1.051    19.148     0.200
     1.269    24.180     0.200
     1.183    22.137     0.200
     1.429    26.219     0.200
     2.108    35.758     0.200
     2.131    37.367     0.200
     2.881    47.578     0.200
     3.128    51.270     0.200
     3.175    51.738     0.200
     3.219    52.727     0.200
     3.490    56.977     0.200
     3.932    64.828     0.200
     4.926    84.078     0.200
     7.491   125.578     0.200
     0.492     9.867     0.200
     0.505    10.508     0.200
     0.585    11.176     0.200
     0.735    13.727     0.200
     0.827    16.285     0.200
     0.862    15.887     0.200
     1.051    19.129     0.200
     1.183    20.637     0.200
     1.194    22.418     0.200
     1.304    23.316     0.200
     1.431    26.117     0.200
     1.907    32.559     0.200
     2.016    35.676     0.200
     2.126    36.648     0.200
     2.157    38.668     0.200
     2.321    40.387     0.200
     2.531    42.348     0.200
     2.904    47.898     0.200
     3.149    52.207     0.200
     3.208    52.848     0.200
     3.257    54.078     0.200
     3.350    54.719     0.200
     3.513    58.297     0.200
     6.589   108.457     0.200
     0.518     9.016     0.200
     0.752    14.477     0.200
     0.780    15.125     0.200
     0.810    15.246     0.200
     0.853    15.715     0.200
     1.058    19.066     0.200
     1.143    19.895     0.200
     1.192    21.426     0.200
     1.271    22.797     0.200
     1.436    24.676     0.200
     0.533    10.148     0.200
     0.514    10.125     0.200
     0.748    13.391     0.200
     0.806    16.000     0.200
     0.851    16.586     0.200
     1.147    19.789     0.200
     1.054    20.008     0.200
     1.276    22.789     0.200
     1.189    22.180     0.200
     2.110    35.859     0.200
     2.135    37.578     0.200
     2.884    47.320     0.200
     2.968    49.266     0.200
     3.131    51.258     0.200
     3.178    52.109     0.200
     3.182    52.594     0.200
     3.775    65.195     0.200
     4.141    66.367     0.200
     7.482   120.797     0.200
     0.502     9.938     0.200
     0.505    10.273     0.200
     0.573    10.836     0.200
     0.736    13.531     0.200
     0.776    16.023     0.200
     0.813    15.562     0.200
     0.856    15.656     0.200
     1.049    19.164     0.200
     1.174    20.258     0.200
     1.189    21.484     0.200
     1.429    26.398     0.200
     1.796    32.445     0.200
     2.016    35.406     0.200
     2.124    36.742     0.200
     2.153    38.328     0.200
     2.530    41.984     0.200
     2.901    47.898     0.200
     2.937    48.969     0.200
     3.146    52.008     0.200
     3.194    52.305     0.200
     3.203    53.547     0.200
     3.510    57.836     0.200
     3.744    66.125     0.200
     7.477   119.125     0.200
     0.458     8.781     0.200
     0.488    10.488     0.200
     0.505    10.082     0.200
     0.570    10.840     0.200
     0.721    14.238     0.200
     0.800    15.609     0.200
     0.779    15.309     0.200
     0.835    15.422     0.200
     1.031    19.609     0.200
     1.169    21.559     0.200
     1.410    26.129     0.200
     1.908    32.262     0.200
     2.001    35.621     0.200
     2.138    37.949     0.200
     4.282    72.109     0.200
     0.469     8.559     0.200
     0.492     8.988     0.200
     0.473     9.398     0.200
     0.583    10.629     0.200
     0.706    12.898     0.200
     0.767    14.828     0.200
     0.806    15.578     0.200
     0.824    14.621     0.200
     1.017    18.031     0.200
     1.157    21.461     0.200
     1.322    24.508     0.200
     1.396    23.898     0.200
     1.817    32.000     0.200
     1.986    34.621     0.200
     2.153    36.570     0.200
     2.180    37.441     0.200
     2.560    41.871     0.200
     2.929    47.488     0.200
     3.175    51.461     0.200
     3.222    52.551     0.200
     4.289    72.828     0.200
     0.421     7.562     0.200
     0.532     9.590     0.200
     0.543    10.152     0.200
     0.508     9.852     0.200
     0.765    13.832     0.200
     0.744    13.441     0.200
     0.817    15.602     0.200
     0.837    15.090     0.200
     1.045    18.699     0.200
     1.177    21.582     0.200
     1.423    25.621     0.200
     1.767    30.051     0.200
     2.114    35.461     0.200
     2.137    36.340     0.200
     2.022    34.801     0.200
     3.301    53.520     0.200
     3.496    55.922     0.200
     3.897    62.090     0.200
     4.007    64.691     0.200
     4.502    79.402     0.200
     4.922    86.301     0.200
     6.697   108.402     0.200
     6.697   113.801     0.200
     7.496   124.801     0.200
     9.208   147.402     0.200
     9.706   156.902     0.200
     9.706   164.301     0.200
     0.391     7.406     0.200
     0.501     9.477     0.200
     0.573     9.945     0.200
     0.528    10.055     0.200
     0.740    13.758     0.200
     0.766    13.426     0.200
     1.112    18.855     0.200
     1.248    21.715     0.200
     1.248    21.547     0.200
     1.188    21.457     0.200
     1.437    25.586     0.200
     1.577    27.465     0.200
     1.620    28.246     0.200
     1.739    29.438     0.200
     2.093    35.105     0.200
     2.113    35.734     0.200
     2.335    39.457     0.200
     2.863    46.766     0.200
     3.112    49.984     0.200
     3.311    53.008     0.200
     4.953    83.445     0.200
     7.491   119.246     0.200
     8.115   130.348     0.200
     9.205   150.547     0.200
     0.507     9.441     0.200
     0.568    11.418     0.200
     0.525     9.559     0.200
     0.842    15.629     0.200
     0.843    15.441     0.200
     1.059    19.691     0.200
     1.252    23.230     0.200
     1.186    21.898     0.200
     1.435    25.141     0.200
     2.096    35.160     0.200
     2.117    36.070     0.200
     3.161    51.590     0.200
     3.477    56.199     0.200
     4.057    64.391     0.200
     4.947    86.730     0.200
     7.492   119.430     0.200
     0.502     9.270     0.200
     0.537     9.777     0.200
     0.573     9.949     0.200
     0.747    14.461     0.200
     0.847    16.648     0.200
     0.855    16.648     0.200
     1.071    19.641     0.200
     1.109    18.898     0.200
     1.199    22.320     0.200
     1.242    23.410     0.200
     0.516     9.754     0.200
     0.547    10.883     0.200
     0.561    10.973     0.200
     0.771    15.184     0.200
     0.782    15.074     0.200
     0.833    16.934     0.200
     0.876    16.254     0.200
     1.085    20.094     0.200
     1.217    23.023     0.200
     1.463    26.574     0.200
     1.590    28.605     0.200
     1.738    32.312     0.200
     2.076    36.676     0.200
     2.101    38.656     0.200
     2.060    36.293     0.200
     2.850    47.664     0.200
     7.458   123.234     0.200
     0.509     9.547     0.200
     0.538    10.625     0.200
     0.566    10.645     0.200
     0.756    15.363     0.200
     0.774    14.637     0.200
     0.840    16.676     0.200
     0.860    17.305     0.200
     1.073    20.105     0.200
     1.203    22.953     0.200
     1.245    22.055     0.200
     1.451    25.984     0.200
     1.584    28.047     0.200
     2.107    38.164     0.200
     0.516    10.410     0.200
     0.560    11.109     0.200
     0.542    11.090     0.200
     0.768    14.559     0.200
     0.777    14.449     0.200
     0.833    16.340     0.200
     0.869    15.527     0.200
     1.079    19.730     0.200
     1.118    19.938     0.200
     1.246    21.859     0.200
     1.246    22.141     0.200
     1.211    21.719     0.200
     1.457    26.469     0.200
     2.081    36.238     0.200
     2.105    37.488     0.200
     4.006    67.750     0.200
     4.521    79.340     0.200
     5.141    84.539     0.200
     6.671   114.438     0.200
     7.464   121.539     0.200
     0.534    10.426     0.200
     0.550    10.547     0.200
     0.528    11.258     0.200
     0.766    14.266     0.200
     0.803    15.535     0.200
     0.878    15.734     0.200
     1.077    19.637     0.200
     1.215    23.375     0.200
     1.267    23.266     0.200
     1.456    27.234     0.200
     4.245    74.086     0.200
     7.455   121.586     0.200
     0.513     9.320     0.200
     0.522     9.977     0.200
     0.561    10.977     0.200
     0.751    13.977     0.200
     0.758    13.266     0.200
     0.843    16.727     0.200
     0.835    16.188     0.200
     1.056    19.094     0.200
     1.185    22.406     0.200
     1.434    25.500     0.200
     0.510     9.797     0.200
     0.567    10.344     0.200
     0.549    10.477     0.200
     0.785    14.594     0.200
     0.765    14.977     0.200
     0.839    16.719     0.200
     0.875    16.836     0.200
     1.086    19.711     0.200
     1.217    22.844     0.200
     1.238    23.898     0.200
     2.097    37.305     0.200
     7.459   119.617     0.200
     0.490     9.156     0.200
     0.540     9.922     0.200
     0.584    11.633     0.200
     0.734    14.594     0.200
     0.777    14.070     0.200
     0.859    16.086     0.200
     0.851    16.680     0.200
     1.071    18.750     0.200
     1.197    21.992     0.200
     1.447    25.125     0.200
     1.726    30.500     0.200
     2.081    35.102     0.200
     2.101    36.164     0.200
     2.851    46.430     0.200
     3.100    50.742     0.200
     3.185    51.641     0.200
     0.507     9.764     0.200
     0.529     9.894     0.200
     0.743    13.093     0.200
     0.761    14.863     0.200
     0.820    15.733     0.200
     1.043    19.514     0.200
     1.174    21.644     0.200
     1.275    22.253     0.200
     2.316    39.773     0.200
     7.500   119.033     0.200
     0.534    10.549     0.200
     0.530    11.459     0.200
     0.541    11.309     0.200
     0.782    15.019     0.200
     0.764    14.809     0.200
     0.814    16.618     0.200
     0.865    15.698     0.200
     1.136    20.019     0.200
     1.070    20.249     0.200
     1.262    22.448     0.200
     1.204    22.679     0.200
     1.448    27.038     0.200
     1.609    28.599     0.200
     1.623    28.818     0.200
     1.758    30.219     0.200
     1.951    33.578     0.200
     2.094    36.889     0.200
     2.120    38.288     0.200
     2.502    42.358     0.200
     2.869    48.629     0.200
     3.116    52.448     0.200
     3.168    52.419     0.200
     3.214    53.519     0.200
     3.479    58.379     0.200
     4.093    66.599     0.200
     9.180   154.519     0.200
     0.392     7.682     0.200
     0.499     9.771     0.200
     0.536    10.941     0.200
     0.575    10.951     0.200
     0.743    15.092     0.200
     0.773    14.660     0.200
     0.852    16.830     0.200
     0.849    16.342     0.200
     1.069    20.111     0.200
     1.196    22.701     0.200
     1.242    23.400     0.200
     1.446    26.551     0.200
     2.085    36.932     0.200
     2.106    38.262     0.200
     6.695   113.740     0.200
     9.196   153.342     0.200
     0.405     7.734     0.200
     0.516     9.797     0.200
     0.515     9.996     0.200
     0.558     9.914     0.200
     0.833    16.117     0.200
     0.836    16.664     0.200
     1.049    19.996     0.200
     1.178    22.516     0.200
     1.263    23.336     0.200
     1.426    25.367     0.200
     2.106    36.594     0.200
     4.298    73.117     0.200
     0.394     7.461     0.200
     0.498     9.590     0.200
     0.544    10.641     0.200
     0.747    14.910     0.200
     0.781    14.551     0.200
     0.850    15.680     0.200
     0.862    16.781     0.200
     1.078    20.062     0.200
     1.206    22.859     0.200
     4.278    73.582     0.200
     0.556    10.906     0.200
     0.518     9.945     0.200
     0.495    10.156     0.200
     0.787    16.227     0.200
     0.728    14.008     0.200
     0.793    15.500     0.200
     0.835    15.086     0.200
     1.035    19.469     0.200
     1.171    21.797     0.200
     1.414    26.031     0.200
     1.920    32.578     0.200
     2.130    36.695     0.200
     2.904    48.258     0.200
     2.962    49.867     0.200
     3.198    52.711     0.200
     3.747    65.898     0.200
     6.691   110.500     0.200
     7.498   125.898     0.200
     0.508     9.406     0.200
     0.492    10.055     0.200
     0.566    10.617     0.200
     0.724    13.578     0.200
     0.782    15.516     0.200
     0.798    15.695     0.200
     0.837    15.125     0.200
     1.034    19.234     0.200
     1.172    21.469     0.200
     1.302    22.828     0.200
     1.413    25.578     0.200
     2.134    36.195     0.200
     2.773    46.062     0.200
     2.951    49.078     0.200
     7.496   123.016     0.200
     0.541    11.540     0.200
     0.574    11.699     0.200
     0.748    15.800     0.200
     0.777    14.919     0.200
     0.847    16.139     0.200
     0.859    15.990     0.200
     1.107    20.129     0.200
     1.075    20.899     0.200
     1.239    22.869     0.200
     1.203    23.379     0.200
     1.452    27.209     0.200
     1.576    28.709     0.200
     1.732    31.709     0.200
     2.081    36.949     0.200
     2.102    38.129     0.200
     2.349    40.929     0.200
     2.491    42.490     0.200
     2.852    47.659     0.200
     3.004    50.729     0.200
     3.101    52.159     0.200
     3.147    52.179     0.200
     3.147    51.919     0.200
     3.190    52.560     0.200
     3.300    54.770     0.200
     3.462    56.840     0.200
     3.752    61.360     0.200
     4.026    67.290     0.200
     4.334    71.240     0.200
     6.889   110.139     0.200
     9.189   154.639     0.200
     0.515     9.910     0.200
     0.527    11.029     0.200
     0.560    10.990     0.200
     0.756    14.010     0.200
     0.763    14.979     0.200
     0.834    16.260     0.200
     0.850    15.319     0.200
     1.063    20.189     0.200
     1.193    22.710     0.200
     1.440    26.620     0.200
     1.590    27.710     0.200
     1.747    31.270     0.200
     2.094    36.460     0.200
     2.505    42.040     0.200
     3.930    63.960     0.200
     4.520    79.359     0.200
     6.690   109.359     0.200
     0.425     8.160     0.200
     0.531    10.211     0.200
     0.522    10.352     0.200
     0.544    10.113     0.200
     0.757    13.973     0.200
     0.774    16.281     0.200
     0.817    16.203     0.200
     0.854    16.312     0.200
     1.061    19.891     0.200
     1.194    22.480     0.200
     1.265    23.402     0.200
     1.439    25.941     0.200
     2.101    36.660     0.200
     2.333    40.352     0.200
     0.509     9.641     0.200
     0.461     9.633     0.200
     0.488    10.359     0.200
     0.615    11.703     0.200
     0.715    13.500     0.200
     0.733    15.531     0.200
     0.852    16.719     0.200
     0.858    15.508     0.200
     1.037    18.625     0.200
     1.214    21.633     0.200
     1.184    21.250     0.200
     1.332    24.555     0.200
     1.418    25.750     0.200
     1.690    30.242     0.200
     1.733    30.930     0.200
     1.833    32.781     0.200
     1.878    31.953     0.200
     2.149    36.859     0.200
     2.552    42.438     0.200
     2.845    48.992     0.200
     0.272     5.629     0.200
     0.401     7.547     0.200
     0.456     8.668     0.200
     0.514     9.598     0.200
     0.511     9.758     0.200
     0.520     9.488     0.200
     0.560     9.477     0.200
     0.561    10.719     0.200
     0.829    16.520     0.200
     0.836    15.707     0.200
     1.044    19.039     0.200
     1.127    19.148     0.200
     1.172    22.297     0.200
     1.265    23.688     0.200
     1.421    25.258     0.200
     2.130    36.648     0.200
     7.505   120.008     0.200
     0.425     8.418     0.200
     0.480     9.586     0.200
     0.533    10.496     0.200
     0.518    10.785     0.200
     0.548    10.328     0.200
     0.542    10.527     0.200
     0.581    11.387     0.200
     0.773    14.809     0.200
     0.753    14.086     0.200
     0.816    16.598     0.200
     0.849    15.105     0.200
     1.056    19.516     0.200
     1.189    22.117     0.200
     1.434    26.676     0.200
     2.031    35.746     0.200
     2.105    36.918     0.200
     2.129    37.875     0.200
     3.126    52.066     0.200
     3.173    52.637     0.200
     4.920    83.297     0.200
     6.622   107.695     0.200
     7.484   121.297     0.200
     0.253     5.812     0.200
     0.461     8.922     0.200
     0.502     9.945     0.200
     0.530     9.727     0.200
     0.541     9.695     0.200
     0.534     9.742     0.200
     0.562    10.977     0.200
     0.830    16.562     0.200
     0.816    15.328     0.200
     1.039    19.094     0.200
     1.170    21.195     0.200
     1.280    23.508     0.200
     1.417    25.352     0.200
     2.015    34.773     0.200
     7.503   123.125     0.200
     0.196     4.766     0.200
     0.463     9.188     0.200
     0.471     8.945     0.200
     0.472     8.578     0.200
     0.555    11.227     0.200
     0.556     9.938     0.200
     0.602    10.703     0.200
     0.747    14.859     0.200
     0.822    15.273     0.200
     0.823    16.477     0.200
     1.008    17.734     0.200
     1.151    21.148     0.200
     1.339    24.336     0.200
     1.388    24.758     0.200
     2.196    38.539     0.200
     2.278    39.414     0.200
     0.286     6.789     0.200
     0.385     7.445     0.200
     0.497     9.508     0.200
     0.457     9.117     0.200
     0.518     9.789     0.200
     0.523    10.707     0.200
     0.577    10.668     0.200
     0.567    11.277     0.200
     0.731    13.719     0.200
     0.852    15.617     0.200
     0.835    15.047     0.200
     1.111    19.066     0.200
     1.054    19.098     0.200
     1.180    22.355     0.200
     1.430    26.207     0.200
     1.739    29.379     0.200
     2.097    35.445     0.200
     2.116    37.016     0.200
     2.036    35.367     0.200
     2.328    39.906     0.200
     3.116    51.027     0.200
     3.162    51.668     0.200
     3.198    52.426     0.200
     3.315    53.629     0.200
     3.477    56.707     0.200
     3.763    60.617     0.200
     3.953    65.469     0.200
     4.042    65.445     0.200
     4.536    79.016     0.200
     6.713   113.117     0.200
     6.915   109.719     0.200
     7.501   120.117     0.200
     8.482   143.516     0.200
     0.297     6.617     0.200
     0.372     7.359     0.200
     0.465     9.047     0.200
     0.482     9.359     0.200
     0.521     9.707     0.200
     0.539    10.699     0.200
     0.577    11.277     0.200
     0.592    10.578     0.200
     0.722    14.949     0.200
     0.845    14.629     0.200
     0.867    17.219     0.200
     1.068    19.887     0.200
     1.191    22.738     0.200
     1.233    21.566     0.200
     1.443    26.258     0.200
     2.100    37.738     0.200
     2.342    40.879     0.200
     0.292     6.288     0.200
     0.487     9.198     0.200
     0.536    10.219     0.200
     0.523     9.368     0.200
     0.587    10.169     0.200
     0.577    10.849     0.200
     0.727    14.349     0.200
     0.862    16.488     0.200
     0.844    14.599     0.200
     1.066    19.259     0.200
     1.099    18.648     0.200
     1.190    21.979     0.200
     1.237    20.969     0.200
     1.442    25.568     0.200
     2.103    36.578     0.200
     2.340    39.839     0.200
     4.300    70.188     0.200
     4.358    75.988     0.200
     4.967    83.688     0.200
     0.431     8.487     0.200
     0.485     9.457     0.200
     0.537    10.417     0.200
     0.519    10.527     0.200
     0.554    10.327     0.200
     0.538    10.267     0.200
     0.585    11.537     0.200
     0.779    15.547     0.200
     0.811    16.647     0.200
     0.853    17.207     0.200
     1.058    19.728     0.200
     1.142    19.827     0.200
     1.192    23.057     0.200
     1.271    22.457     0.200
     1.436    25.947     0.200
     4.343    77.247     0.200
     7.480   121.547     0.200
     0.317     6.789     0.200
     0.472     8.938     0.200
     0.521     9.664     0.200
     0.559    10.664     0.200
     0.617    10.547     0.200
     0.705    14.844     0.200
     0.714    13.250     0.200
     0.799    15.273     0.200
     0.856    14.820     0.200
     0.891    17.172     0.200
     1.085    20.211     0.200
     1.205    21.977     0.200
     7.483   119.570     0.200
     0.316     6.371     0.200
     0.466     8.980     0.200
     0.455     8.621     0.200
     0.506     9.230     0.200
     0.542    10.191     0.200
     0.571    10.773     0.200
     0.609    10.402     0.200
     0.703    14.621     0.200
     0.722    12.910     0.200
     0.781    14.781     0.200
     0.838    16.172     0.200
     0.884    16.953     0.200
     1.067    20.043     0.200
     1.187    22.082     0.200
     1.226    22.691     0.200
     1.648    28.781     0.200
     1.712    30.363     0.200
     7.501   121.852     0.200
     0.261     5.852     0.200
     0.520     9.820     0.200
     0.467     8.883     0.200
     0.533     9.672     0.200
     0.515     9.922     0.200
     0.554     9.867     0.200
     0.571    10.773     0.200
     0.756    13.742     0.200
     0.752    13.641     0.200
     0.829    15.891     0.200
     0.839    14.758     0.200
     1.051    19.328     0.200
     1.181    21.141     0.200
     2.106    35.469     0.200
     2.128    36.953     0.200
     2.290    37.938     0.200
     2.878    46.891     0.200
     3.126    50.883     0.200
     3.215    52.469     0.200
     4.514    78.094     0.200
     4.934    83.688     0.200
     6.699   106.391     0.200
     7.495   119.391     0.200
     9.210   146.891     0.200
     0.285     6.215     0.200
     0.489     9.335     0.200
     0.544    10.155     0.200
     0.585    10.255     0.200
     0.589    10.995     0.200
     0.746    12.945     0.200
     0.859    16.325     0.200
     0.857    16.455     0.200
     1.097    18.785     0.200
     1.076    20.055     0.200
     1.202    22.515     0.200
     0.286     6.117     0.200
     0.491     9.248     0.200
     0.537    10.098     0.200
     0.581    10.808     0.200
     0.583    11.867     0.200
     0.748    12.827     0.200
     0.848    16.178     0.200
     0.858    16.077     0.200
     1.101    18.638     0.200
     1.068    20.067     0.200
     1.238    21.788     0.200
     1.194    22.348     0.200
     4.353    73.808     0.200
     4.962    83.808     0.200
     7.487   118.808     0.200
     0.300     6.492     0.200
     0.478     9.053     0.200
     0.544    10.492     0.200
     0.581    11.072     0.200
     0.597    12.492     0.200
     0.734    12.674     0.200
     0.782    14.414     0.200
     0.848    17.043     0.200
     0.871    17.693     0.200
     1.073    19.523     0.200
     1.089    18.523     0.200
     1.196    22.633     0.200
     1.228    21.174     0.200
     1.448    25.732     0.200
     2.056    35.623     0.200
     2.095    37.283     0.200
     2.347    40.443     0.200
     3.126    53.273     0.200
     0.297     6.238     0.200
     0.371     7.238     0.200
     0.471     9.320     0.200
     0.568    10.160     0.200
     0.604    11.988     0.200
     0.729    14.488     0.200
     0.727    15.121     0.200
     0.878    16.648     0.200
     1.099    19.918     0.200
     1.475    25.781     0.200
     1.684    28.840     0.200
     2.081    36.602     0.200
     0.054     2.922     0.200
     0.246     5.719     0.200
     0.424     7.820     0.200
     0.515     9.820     0.200
     0.533     9.820     0.200
     0.542     9.523     0.200
     0.750    13.523     0.200
     0.771    15.117     0.200
     0.789    13.523     0.200
     0.816    15.719     0.200
     0.846    14.719     0.200
     1.053    19.023     0.200
     1.140    19.219     0.200
     1.271    23.023     0.200
     2.028    35.422     0.200
     2.132    36.922     0.200
     0.269     6.145     0.200
     0.401     7.545     0.200
     0.511     9.645     0.200
     0.468     9.045     0.200
     0.523    10.245     0.200
     0.563    10.245     0.200
     0.767    13.245     0.200
     0.759    13.444     0.200
     0.842    14.545     0.200
     1.121    19.045     0.200
     1.057    19.345     0.200
     1.256    21.645     0.200
     1.185    21.345     0.200
     1.434    25.745     0.200
     2.098    35.345     0.200
     2.120    36.645     0.200
     2.036    34.845     0.200
     2.283    37.845     0.200
     2.870    47.145     0.200
     3.118    50.944     0.200
     3.164    51.145     0.200
     6.700   107.145     0.200
     6.700   114.045     0.200
     0.070     3.328     0.200
     0.277     6.430     0.200
     0.466     8.930     0.200
     0.525    10.430     0.200
     0.571    10.430     0.200
     0.741    13.430     0.200
     0.763    13.828     0.200
     0.845    16.227     0.200
     1.115    18.828     0.200
     1.058    19.227     0.200
     1.251    22.129     0.200
     1.435    25.828     0.200
     1.592    27.930     0.200
     2.095    35.328     0.200
     2.116    36.828     0.200
     2.039    35.027     0.200
     2.280    37.828     0.200
     2.332    39.430     0.200
     2.507    41.027     0.200
     2.841    46.629     0.200
     2.866    47.328     0.200
     3.115    50.727     0.200
     3.161    51.430     0.200
     3.314    53.340     0.200
     3.476    55.816     0.200
     3.887    63.027     0.200
     4.530    78.129     0.200
     4.950    86.527     0.200
     6.607   106.930     0.200
     6.607   111.727     0.200
     6.704   112.027     0.200
     6.906   111.328     0.200
     9.206   147.629     0.200
     9.205   149.527     0.200
     0.600    11.451     0.200
     0.685    12.750     0.200
     1.009    18.150     0.200
     1.059    19.551     0.200
     1.060    19.350     0.200
     1.275    22.451     0.200
     1.350    23.750     0.200
     1.380    24.551     0.200
     1.419    24.451     0.200
     2.209    36.650     0.200
     4.309    73.650     0.200
     4.325    76.150     0.200
     0.234     5.234     0.200
     0.434     7.234     0.200
     0.465     8.035     0.200
     0.527    10.734     0.200
     0.505     9.234     0.200
     0.804    15.734     0.200
     0.739    13.434     0.200
     0.852    14.434     0.200
     0.842    16.035     0.200
     0.944    17.934     0.200
     1.045    18.734     0.200
     1.229    21.834     0.200
     1.285    24.035     0.200
     1.189    20.934     0.200
     1.423    25.334     0.200
     1.779    31.035     0.200
     2.119    36.434     0.200
     2.144    36.635     0.200
     2.301    38.035     0.200
     2.894    47.234     0.200
     3.141    50.875     0.200
     3.187    51.695     0.200
     3.340    54.205     0.200
     4.229    68.924     0.200
     0.253     6.570     0.200
     0.400     8.273     0.200
     0.564    11.375     0.200
     0.743    14.672     0.200
     0.822    16.773     0.200
     0.903    16.875     0.200
     1.185    20.273     0.200
     1.273    21.875     0.200
     1.828    31.070     0.200
     2.149    35.570     0.200
     2.234    37.477     0.200
     0.030     1.617     0.200
     0.233     5.219     0.200
     0.444     8.617     0.200
     0.444     9.117     0.200
     0.452     8.918     0.200
     0.488     9.219     0.200
     0.464     9.117     0.200
     0.489     9.617     0.200
     0.518     9.219     0.200
     0.560    10.918     0.200
     0.813    14.617     0.200
     0.810    14.316     0.200
     0.793    15.219     0.200
     0.935    18.816     0.200
     1.029    18.418     0.200
     1.179    21.316     0.200
     1.164    20.816     0.200
     1.299    23.809     0.200
     1.407    25.418     0.200
     1.810    30.918     0.200
     4.216    70.395     0.200
     4.898    81.418     0.200
     0.155     5.676     0.200
     0.153     5.875     0.200
     0.318     6.775     0.200
     0.579    11.375     0.200
     0.762    14.475     0.200
     0.791    14.875     0.200
     0.819    15.375     0.200
     1.035    18.975     0.200
     1.152    20.074     0.200
     1.036    19.074     0.200
     1.210    21.975     0.200
     1.224    22.574     0.200
     1.164    20.574     0.200
     1.381    23.475     0.200
     0.074     2.650     0.200
     0.344     6.850     0.200
     0.418     9.051     0.200
     0.463     9.051     0.200
     0.533     9.850     0.200
     0.533    10.451     0.200
     0.543     9.451     0.200
     0.600    12.150     0.200
     0.782    15.150     0.200
     0.789    14.250     0.200
     0.816    15.951     0.200
     1.073    18.551     0.200
     1.207    21.750     0.200
     1.259    22.041     0.200
     1.627    27.850     0.200
     1.851    31.150     0.200
     0.337     6.430     0.200
     0.389     7.727     0.200
     0.440     8.430     0.200
     0.423     8.125     0.200
     0.494    10.227     0.200
     0.563    10.727     0.200
     0.547    10.227     0.200
     0.677    12.727     0.200
     0.656    12.828     0.200
     0.747    12.766     0.200
     0.747    14.227     0.200
     0.758    14.430     0.200
     0.735    14.023     0.200
     0.779    14.523     0.200
     0.753    13.625     0.200
     0.789    14.625     0.200
     0.791    14.125     0.200
     0.884    16.625     0.200
     0.959    17.328     0.200
     0.994    18.523     0.200
     1.054    19.930     0.200
     1.072    19.625     0.200
     1.173    21.328     0.200
     1.315    24.430     0.200
     1.417    25.523     0.200
     1.487    27.430     0.200
     1.944    34.023     0.200
     2.111    36.328     0.200
     2.230    38.125     0.200
     2.542    43.523     0.200
     2.573    43.125     0.200
     2.644    44.523     0.200
     2.986    49.125     0.200
     3.506    60.227     0.200
     8.168   132.727     0.200
     0.212     5.062     0.200
     0.277     6.766     0.200
     0.384     7.664     0.200
     0.393     8.164     0.200
     0.439     8.461     0.200
     0.435     8.766     0.200
     0.536    10.266     0.200
     0.524     9.961     0.200
     0.583    11.062     0.200
     0.583    11.664     0.200
     0.631    11.961     0.200
     0.678    12.367     0.200
     0.748    13.867     0.200
     0.764    14.164     0.200
     0.815    14.266     0.200
     0.844    15.562     0.200
     0.917    17.562     0.200
     0.922    16.664     0.200
     0.975    17.062     0.200
     0.955    18.164     0.200
     0.973    18.062     0.200
     0.998    19.562     0.200
     1.043    18.266     0.200
     1.084    19.266     0.200
     1.107    19.266     0.200
     1.192    20.664     0.200
     1.208    20.867     0.200
     1.314    22.562     0.200
     1.315    24.266     0.200
     1.446    25.461     0.200
     1.453    24.266     0.200
     1.458    25.062     0.200
     1.493    25.266     0.200
     1.772    31.867     0.200
     2.284    42.086     0.200
     2.509    43.141     0.200
     2.685    46.047     0.200
     2.775    48.938     0.200
     2.804    47.617     0.200
     2.922    50.273     0.200
     3.286    55.062     0.200
     3.349    57.055     0.200
     0.238     6.062     0.200
     0.245     5.758     0.200
     0.277     6.062     0.200
     0.363     8.164     0.200
     0.387     8.562     0.200
     0.393     8.758     0.200
     0.515    10.164     0.200
     0.599    11.859     0.200
     0.625    11.859     0.200
     0.652    12.961     0.200
     0.726    13.758     0.200
     0.772    14.359     0.200
     0.787    14.461     0.200
     0.778    14.664     0.200
     0.782    14.758     0.200
     0.861    15.758     0.200
     0.904    16.758     0.200
     0.972    16.961     0.200
     0.959    17.664     0.200
     1.009    17.758     0.200
     1.031    18.359     0.200
     1.011    18.562     0.200
     1.072    18.664     0.200
     1.153    19.758     0.200
     1.357    22.961     0.200
     1.472    25.461     0.200
     1.579    27.164     0.200
     1.691    29.664     0.200
     1.811    31.062     0.200
     1.881    31.758     0.200
     4.191    73.859     0.200
     9.029   146.555     0.200
     0.325     6.633     0.200
     0.351     6.227     0.200
     0.411     7.633     0.200
     0.401     7.531     0.200
     0.407     7.633     0.200
     0.483     9.328     0.200
     0.497     9.227     0.200
     0.548     9.828     0.200
     0.654    11.828     0.200
     0.743    13.930     0.200
     0.710    12.633     0.200
     0.742    14.328     0.200
     0.771    13.133     0.200
     0.822    15.133     0.200
     0.844    15.727     0.200
     0.863    15.430     0.200
     0.908    15.633     0.200
     0.911    16.828     0.200
     0.897    15.227     0.200
     0.940    16.828     0.200
     1.066    19.227     0.200
     1.128    20.430     0.200
     1.129    20.328     0.200
     1.124    18.930     0.200
     1.109    20.531     0.200
     1.127    20.328     0.200
     1.174    21.531     0.200
     1.190    21.828     0.200
     1.206    22.328     0.200
     1.234    22.430     0.200
     1.263    22.633     0.200
     1.298    22.633     0.200
     1.254    23.430     0.200
     1.298    23.031     0.200
     1.366    24.633     0.200
     1.356    24.633     0.200
     1.392    24.633     0.200
     1.387    25.133     0.200
     1.365    24.031     0.200
     1.393    24.031     0.200
     3.530    59.031     0.200
     3.786    62.531     0.200
     3.816    62.461     0.200
     0.075     3.359     0.200
     0.222     5.461     0.200
     0.304     6.562     0.200
     0.281     6.156     0.200
     0.305     6.359     0.200
     0.392     7.359     0.200
     0.425     8.156     0.200
     0.410     8.359     0.200
     0.448     8.359     0.200
     0.499     9.562     0.200
     0.467     8.961     0.200
     0.517     9.656     0.200
     0.530    10.258     0.200
     0.607    11.258     0.200
     0.576     9.961     0.200
     0.641    12.062     0.200
     0.696    12.758     0.200
     0.691    12.461     0.200
     0.754    13.258     0.200
     0.738    13.758     0.200
     0.755    13.258     0.200
     0.733    13.258     0.200
     0.818    14.961     0.200
     0.819    14.359     0.200
     0.842    16.062     0.200
     0.844    14.562     0.200
     0.913    15.758     0.200
     0.892    16.156     0.200
     0.945    16.961     0.200
     0.950    16.562     0.200
     1.012    17.961     0.200
     1.085    18.656     0.200
     1.109    18.961     0.200
     1.062    19.258     0.200
     1.139    20.562     0.200
     1.188    21.461     0.200
     1.246    21.258     0.200
     1.213    21.656     0.200
     1.239    22.461     0.200
     1.255    23.258     0.200
     1.346    22.961     0.200
     1.382    23.656     0.200
     1.737    31.062     0.200
     1.857    31.953     0.200
     2.043    34.758     0.200
     2.449    40.961     0.200
     2.739    45.656     0.200
     4.219    68.320     0.200
     0.143     5.891     0.200
     0.199     6.590     0.200
     0.268     7.188     0.200
     0.482    10.391     0.200
     0.707    13.891     0.200
     0.707    14.688     0.200
     0.726    14.391     0.200
     0.844    16.188     0.200
     0.823    15.590     0.200
     0.939    17.988     0.200
     0.964    18.590     0.200
     0.884    15.988     0.200
     1.129    20.391     0.200
     1.688    28.988     0.200
     6.942   115.988     0.200
     0.261     7.277     0.200
     0.296     7.875     0.200
     0.374     8.977     0.200
     0.310     8.078     0.200
     0.422     9.277     0.200
     0.532    12.176     0.200
     0.554    11.977     0.200
     0.562    11.578     0.200
     0.556    11.375     0.200
     0.672    13.277     0.200
     0.662    12.777     0.200
     0.623    12.375     0.200
     0.626    12.375     0.200
     0.654    13.078     0.200
     0.770    15.176     0.200
     0.761    14.578     0.200
     0.764    14.578     0.200
     0.803    14.676     0.200
     1.048    18.277     0.200
     4.380    72.957     0.200
     0.265     7.070     0.200
     0.299     7.672     0.200
     0.374     8.773     0.200
     0.417     9.070     0.200
     0.534    11.875     0.200
     0.557    11.773     0.200
     0.558    11.477     0.200
     0.550    11.375     0.200
     0.652    13.070     0.200
     0.616    12.070     0.200
     0.672    13.172     0.200
     0.658    12.570     0.200
     0.620    12.273     0.200
     0.772    15.070     0.200
     0.755    14.273     0.200
     0.758    14.672     0.200
     0.799    14.672     0.200
     0.844    16.172     0.200
     0.973    16.977     0.200
     1.043    18.070     0.200
     1.187    19.977     0.200
     1.373    24.172     0.200
     0.045     2.836     0.200
     0.167     4.930     0.200
     0.232     5.531     0.200
     0.244     5.430     0.200
     0.298     6.234     0.200
     0.328     6.430     0.200
     0.394     7.336     0.200
     0.382     7.930     0.200
     0.449     8.234     0.200
     0.457     8.430     0.200
     0.452     8.633     0.200
     0.525     9.633     0.200
     0.531     9.734     0.200
     0.678    12.031     0.200
     0.668    12.133     0.200
     0.663    12.031     0.200
     0.708    12.836     0.200
     0.817    15.531     0.200
     0.903    17.430     0.200
     0.921    16.234     0.200
     1.042    18.430     0.200
     1.109    20.531     0.200
     1.138    19.234     0.200
     1.173    21.531     0.200
     1.183    21.336     0.200
     1.210    22.133     0.200
     1.256    22.734     0.200
     1.276    23.633     0.200
     1.326    23.336     0.200
     1.376    24.430     0.200
     1.392    23.930     0.200
     1.398    25.336     0.200
     1.832    32.234     0.200
     1.887    32.531     0.200
     0.255     5.838     0.200
     0.298     7.138     0.200
     0.420     8.438     0.200
     0.539    10.538     0.200
     0.429     9.238     0.200
     0.454     9.638     0.200
     0.630    12.038     0.200
     0.675    12.638     0.200
     0.697    12.738     0.200
     0.742    14.038     0.200
     0.781    14.238     0.200
     0.819    14.238     0.200
     0.810    15.038     0.200
     0.875    15.638     0.200
     0.909    16.438     0.200
     0.897    15.838     0.200
     0.856    16.038     0.200
     0.934    16.538     0.200
     0.975    16.838     0.200
     0.960    17.238     0.200
     1.057    18.638     0.200
     1.109    19.038     0.200
     1.021    18.438     0.200
     1.030    18.838     0.200
     1.105    19.238     0.200
     1.144    20.138     0.200
     1.123    19.738     0.200
     1.257    21.438     0.200
     1.388    23.538     0.200
     1.514    25.838     0.200
     1.547    27.138     0.200
     1.547    27.338     0.200
     1.694    28.538     0.200
     1.997    37.138     0.200
     4.457    74.138     0.200
     0.218     5.488     0.200
     0.342     7.588     0.200
     0.366     8.088     0.200
     0.362     7.088     0.200
     0.532    10.088     0.200
     0.608    11.988     0.200
     0.604    11.648     0.200
     0.647    11.988     0.200
     0.747    13.988     0.200
     0.789    14.488     0.200
     0.780    14.688     0.200
     0.800    14.388     0.200
     0.870    15.688     0.200
     0.884    16.388     0.200
     0.939    16.888     0.200
     0.926    15.988     0.200
     0.980    18.488     0.200
     0.991    17.138     0.200
     1.008    17.688     0.200
     1.013    18.788     0.200
     1.009    17.188     0.200
     1.009    18.168     0.200
     1.051    18.488     0.200
     1.148    19.188     0.200
     1.148    20.178     0.200
     1.160    20.888     0.200
     1.154    20.688     0.200
     1.288    22.988     0.200
     1.283    22.688     0.200
     1.275    22.688     0.200
     1.349    24.488     0.200
     1.373    23.888     0.200
     1.370    23.988     0.200
     1.425    24.088     0.200
     1.601    27.788     0.200
     1.605    27.588     0.200
     1.592    27.088     0.200
     1.595    26.988     0.200
     1.698    29.388     0.200
     1.711    29.988     0.200
     1.751    29.588     0.200
     1.784    30.488     0.200
     1.759    29.488     0.200
     1.834    31.588     0.200
     1.829    30.388     0.200
     1.903    32.158     0.200
     1.926    35.688     0.200
     1.977    33.788     0.200
     2.017    33.988     0.200
     2.133    35.488     0.200
     2.410    39.688     0.200
     2.491    40.588     0.200
     2.608    42.588     0.200
     2.702    43.988     0.200
     2.905    47.088     0.200
     3.254    52.168     0.200
     0.053     2.727     0.200
     0.292     5.847     0.200
     0.376     6.917     0.200
     0.336     7.667     0.200
     0.314     6.777     0.200
     0.426     8.337     0.200
     0.476     9.627     0.200
     0.555    10.747     0.200
     0.598    10.917     0.200
     0.540    10.167     0.200
     0.542    10.807     0.200
     0.580    11.027     0.200
     0.664    12.167     0.200
     0.706    12.327     0.200
     0.749    13.607     0.200
     0.736    13.207     0.200
     0.803    14.427     0.200
     0.820    14.797     0.200
     0.825    14.887     0.200
     0.824    14.447     0.200
     0.789    15.027     0.200
     0.789    14.667     0.200
     0.821    14.627     0.200
     0.821    15.427     0.200
     0.832    15.577     0.200
     0.839    15.327     0.200
     0.898    15.847     0.200
     0.888    16.127     0.200
     0.888    15.557     0.200
     0.938    17.327     0.200
     0.938    17.827     0.200
     1.084    19.227     0.200
     1.084    19.357     0.200
     1.065    19.127     0.200
     1.150    19.907     0.200
     1.091    19.427     0.200
     1.091    19.817     0.200
     1.144    19.817     0.200
     1.133    20.527     0.200
     1.133    20.367     0.200
     1.144    21.027     0.200
     1.144    21.377     0.200
     1.229    21.527     0.200
     1.229    21.827     0.200
     1.222    21.127     0.200
     1.222    20.737     0.200
     1.210    21.327     0.200
     1.341    23.927     0.200
     1.341    23.447     0.200
     1.259    23.327     0.200
     1.270    23.317     0.200
     1.294    22.797     0.200
     1.351    24.377     0.200
     1.342    24.327     0.200
     1.382    25.267     0.200
     1.476    26.837     0.200
     1.498    27.327     0.200
     1.498    27.147     0.200
     1.422    25.827     0.200
     1.422    25.567     0.200
     1.829    30.927     0.200
     1.950    36.927     0.200
     1.996    36.327     0.200
     2.021    36.527     0.200
     2.152    37.627     0.200
     2.283    39.927     0.200
     2.322    40.527     0.200
     2.561    44.027     0.200
     2.575    45.027     0.200
     2.740    46.827     0.200
     3.041    52.127     0.200
     3.080    52.327     0.200
     3.174    54.627     0.200
     3.187    54.027     0.200
     3.552    59.527     0.200
     4.115    69.127     0.200
     4.052    69.177     0.200
     0.048     2.570     0.200
     0.291     6.061     0.200
     0.261     5.891     0.200
     0.370     7.080     0.200
     0.315     6.521     0.200
     0.343     7.891     0.200
     0.317     7.110     0.200
     0.423     8.030     0.200
     0.541    10.580     0.200
     0.484     9.830     0.200
     0.591    11.070     0.200
     0.551    10.351     0.200
     0.549    10.610     0.200
     0.583    10.780     0.200
     0.666    12.400     0.200
     0.703    12.500     0.200
     0.738    14.240     0.200
     0.733    12.851     0.200
     0.800    14.410     0.200
     0.798    14.460     0.200
     0.836    15.690     0.200
     0.845    15.220     0.200
     0.894    15.590     0.200
     0.835    15.160     0.200
     0.938    17.891     0.200
     0.902    16.790     0.200
     1.078    19.370     0.200
     1.066    19.510     0.200
     1.091    19.720     0.200
     1.131    20.540     0.200
     1.147    20.410     0.200
     1.210    21.561     0.200
     1.280    23.200     0.200
     1.350    24.320     0.200
     1.351    24.210     0.200
     1.430    26.210     0.200
     1.430    25.320     0.200
     1.647    28.200     0.200
     1.855    31.410     0.200
     2.426    42.110     0.200
     3.711    63.780     0.200
     0.039     2.512     0.200
     0.120     3.041     0.200
     0.299     6.092     0.200
     0.256     5.801     0.200
     0.266     6.361     0.200
     0.307     6.441     0.200
     0.375     7.102     0.200
     0.355     8.061     0.200
     0.318     7.131     0.200
     0.412     7.971     0.200
     0.530    10.471     0.200
     0.496     9.900     0.200
     0.594    11.211     0.200
     0.547    10.451     0.200
     0.564    10.361     0.200
     0.576    10.900     0.200
     0.676    12.422     0.200
     0.709    12.541     0.200
     0.735    14.602     0.200
     0.722    13.502     0.200
     0.806    16.502     0.200
     0.806    14.391     0.200
     0.840    15.502     0.200
     0.798    14.871     0.200
     0.842    15.092     0.200
     0.883    15.701     0.200
     0.846    15.061     0.200
     0.929    17.021     0.200
     0.912    16.271     0.200
     1.057    19.031     0.200
     1.120    20.371     0.200
     1.128    21.082     0.200
     1.155    20.012     0.200
     1.202    21.191     0.200
     1.333    23.672     0.200
     1.280    23.102     0.200
     1.351    24.201     0.200
     1.802    30.512     0.200
     1.856    31.201     0.200
     2.417    43.002     0.200
     3.698    64.502     0.200
     4.285    76.002     0.200
     5.058    83.602     0.200
     0.063     2.699     0.200
     0.173     4.977     0.200
     0.216     5.148     0.200
     0.225     5.297     0.200
     0.228     5.016     0.200
     0.291     6.059     0.200
     0.321     6.508     0.200
     0.429     8.039     0.200
     0.394     8.207     0.200
     0.451     8.605     0.200
     0.504     9.477     0.200
     0.513     9.449     0.200
     0.527    11.355     0.200
     0.559    10.656     0.200
     0.610    10.836     0.200
     0.607    10.957     0.200
     0.678    12.105     0.200
     0.671    11.809     0.200
     0.658    12.086     0.200
     0.675    12.336     0.200
     0.716    13.219     0.200
     0.692    12.656     0.200
     0.766    13.258     0.200
     0.802    14.137     0.200
     0.835    14.426     0.200
     0.813    14.668     0.200
     0.887    16.176     0.200
     0.906    17.855     0.200
     0.921    15.578     0.200
     0.928    16.418     0.200
     0.934    16.277     0.200
     1.028    17.516     0.200
     1.045    18.637     0.200
     1.098    18.508     0.200
     1.120    18.938     0.200
     1.139    19.258     0.200
     1.124    20.688     0.200
     1.183    20.617     0.200
     1.200    21.605     0.200
     1.238    22.738     0.200
     1.224    22.449     0.200
     1.259    21.277     0.200
     1.405    23.316     0.200
     4.203    69.527     0.200
     0.180     4.438     0.200
     0.387     7.395     0.200
     0.392     7.234     0.200
     0.378     7.445     0.200
     0.355     7.746     0.200
     0.421     8.375     0.200
     0.507     9.137     0.200
     0.467     9.047     0.200
     0.599    10.805     0.200
     0.569    10.625     0.200
     0.587    10.547     0.200
     0.651    11.598     0.200
     0.686    12.098     0.200
     0.746    12.965     0.200
     0.688    12.906     0.200
     0.791    13.625     0.200
     0.726    13.234     0.200
     0.837    14.766     0.200
     0.810    15.055     0.200
     0.924    16.496     0.200
     0.953    16.426     0.200
     1.014    17.367     0.200
     0.990    16.977     0.200
     0.974    17.188     0.200
     1.003    17.965     0.200
     1.025    19.297     0.200
     1.103    19.688     0.200
     1.134    19.305     0.200
     1.105    19.625     0.200
     1.130    19.855     0.200
     1.242    21.504     0.200
     1.245    22.727     0.200
     1.245    23.387     0.200
     1.245    23.227     0.200
     1.271    23.176     0.200
     1.361    23.477     0.200
     1.386    25.105     0.200
     1.386    23.797     0.200
     1.386    23.234     0.200
     1.406    24.125     0.200
     1.435    24.535     0.200
     1.867    32.707     0.200
     1.755    30.824     0.200
     1.855    36.074     0.200
     2.247    38.527     0.200
     2.281    39.715     0.200
     2.328    41.047     0.200
     2.391    40.348     0.200
     2.482    42.414     0.200
     2.483    41.824     0.200
     2.561    43.047     0.200
     2.528    44.035     0.200
     2.722    45.887     0.200
     2.828    47.406     0.200
     3.136    52.215     0.200
     4.664    75.465     0.200
     0.176     3.930     0.200
     0.186     4.633     0.200
     0.181     4.109     0.200
     0.300     5.867     0.200
     0.307     6.016     0.200
     0.397     7.586     0.200
     0.393     7.617     0.200
     0.364     6.531     0.200
     0.357     7.672     0.200
     0.385     7.719     0.200
     0.425     8.391     0.200
     0.504     9.133     0.200
     0.521    10.000     0.200
     0.536    11.078     0.200
     0.562    10.250     0.200
     0.606    10.852     0.200
     0.590    10.570     0.200
     0.655    11.688     0.200
     0.692    12.219     0.200
     0.683    12.570     0.200
     0.752    12.898     0.200
     0.723    12.938     0.200
     0.727    13.289     0.200
     0.796    13.906     0.200
     0.804    14.789     0.200
     0.844    15.852     0.200
     0.926    17.117     0.200
     0.986    17.242     0.200
     0.970    17.648     0.200
     0.998    18.227     0.200
     1.027    18.211     0.200
     1.135    20.031     0.200
     1.099    19.789     0.200
     1.132    21.078     0.200
     1.245    22.859     0.200
     1.251    23.406     0.200
     1.242    22.883     0.200
     1.267    23.266     0.200
     1.338    25.258     0.200
     1.389    24.180     0.200
     1.345    23.641     0.200
     1.739    31.180     0.200
     1.849    36.141     0.200
     1.848    32.797     0.200
     1.941    34.312     0.200
     1.999    35.742     0.200
     2.079    38.930     0.200
     2.189    39.000     0.200
     2.287    41.086     0.200
     2.364    41.156     0.200
     2.392    41.000     0.200
     2.392    42.227     0.200
     2.537    43.172     0.200
     2.579    44.719     0.200
     2.818    48.281     0.200
     3.314    58.492     0.200
     3.946    66.633     0.200
     3.946    68.852     0.200
     0.151     3.625     0.200
     0.196     4.648     0.200
     0.206     4.547     0.200
     0.284     5.523     0.200
     0.270     5.305     0.200
     0.375     7.328     0.200
     0.373     7.336     0.200
     0.331     6.664     0.200
     0.385     7.547     0.200
     0.379     7.906     0.200
     0.374     7.023     0.200
     0.441     8.688     0.200
     0.485     9.148     0.200
     0.486     9.258     0.200
     0.546    10.664     0.200
     0.608    10.914     0.200
     0.608    10.758     0.200
     0.631    11.336     0.200
     0.681    12.094     0.200
     0.735    12.758     0.200
     0.707    13.453     0.200
     0.837    15.078     0.200
     0.901    17.008     0.200
     0.969    17.172     0.200
     1.020    19.172     0.200
     1.048    19.555     0.200
     1.110    19.695     0.200
     1.118    20.297     0.200
     1.154    20.734     0.200
     1.221    22.383     0.200
     1.316    24.852     0.200
     1.718    33.938     0.200
     1.923    34.477     0.200
     2.100    39.375     0.200
     2.173    38.055     0.200
     2.869    48.492     0.200
     0.144     3.648     0.200
     0.201     4.664     0.200
     0.213     4.609     0.200
     0.265     5.352     0.200
     0.280     5.453     0.200
     0.337     6.719     0.200
     0.367     7.188     0.200
     0.371     7.203     0.200
     0.387     7.578     0.200
     0.376     7.094     0.200
     0.386     7.938     0.200
     0.447     8.703     0.200
     0.479     9.148     0.200
     0.492     9.273     0.200
     0.553    10.633     0.200
     0.610    10.789     0.200
     0.625    11.328     0.200
     0.615    10.828     0.200
     0.679    11.977     0.200
     0.731    12.719     0.200
     0.713    13.562     0.200
     0.768    13.617     0.200
     0.757    14.398     0.200
     0.754    14.094     0.200
     0.837    14.672     0.200
     0.894    16.938     0.200
     0.964    17.141     0.200
     1.026    19.062     0.200
     1.055    18.781     0.200
     1.103    19.477     0.200
     1.122    20.141     0.200
     1.161    21.008     0.200
     1.215    22.297     0.200
     1.263    21.852     0.200
     1.298    24.148     0.200
     1.332    23.898     0.200
     1.920    33.633     0.200
     1.925    34.461     0.200
     2.181    37.562     0.200
     2.373    40.750     0.200
     2.474    44.891     0.200
     2.842    49.203     0.200
     0.046     2.502     0.200
     0.099     3.162     0.200
     0.192     4.281     0.200
     0.174     4.191     0.200
     0.204     4.801     0.200
     0.328     6.182     0.200
     0.285     6.002     0.200
     0.336     6.402     0.200
     0.420     8.012     0.200
     0.358     7.822     0.200
     0.421     8.051     0.200
     0.409     7.951     0.200
     0.434     8.762     0.200
     0.442     8.242     0.200
     0.501     9.471     0.200
     0.440     8.762     0.200
     0.537    10.291     0.200
     0.511    10.342     0.200
     0.518    10.771     0.200
     0.604    12.572     0.200
     0.596    10.762     0.200
     0.629    11.201     0.200
     0.721    12.662     0.200
     0.661    12.301     0.200
     0.754    14.182     0.200
     0.705    13.072     0.200
     0.780    13.602     0.200
     0.820    14.301     0.200
     0.941    17.352     0.200
     0.979    17.012     0.200
     0.973    18.371     0.200
     1.028    19.012     0.200
     1.028    18.902     0.200
     1.072    19.480     0.200
     1.148    19.941     0.200
     1.130    20.652     0.200
     1.278    23.141     0.200
     1.313    24.332     0.200
     1.246    22.832     0.200
     1.459    24.711     0.200
     0.043     2.533     0.200
     0.186     4.043     0.200
     0.177     4.312     0.200
     0.198     4.752     0.200
     0.318     6.062     0.200
     0.293     6.223     0.200
     0.346     6.492     0.200
     0.358     7.742     0.200
     0.411     7.572     0.200
     0.411     7.803     0.200
     0.401     7.752     0.200
     0.431     8.633     0.200
     0.452     8.572     0.200
     0.448     8.672     0.200
     0.502     9.354     0.200
     0.515    10.312     0.200
     0.546    10.152     0.200
     0.594    10.604     0.200
     0.621    11.092     0.200
     0.669    12.322     0.200
     0.711    12.582     0.200
     0.711    13.373     0.200
     0.712    13.133     0.200
     0.759    14.242     0.200
     0.770    13.512     0.200
     0.811    13.992     0.200
     0.787    14.783     0.200
     0.935    16.713     0.200
     0.981    17.332     0.200
     1.143    19.742     0.200
     1.131    20.613     0.200
     1.268    23.773     0.200
     0.116     4.457     0.200
     0.139     4.188     0.200
     0.143     3.928     0.200
     0.230     5.457     0.200
     0.257     5.918     0.200
     0.334     6.729     0.200
     0.345     7.078     0.200
     0.371     8.318     0.200
     0.401     7.809     0.200
     0.445     8.738     0.200
     0.461     8.738     0.200
     0.480     8.758     0.200
     0.481     9.488     0.200
     0.528     9.979     0.200
     0.583    11.117     0.200
     0.610    12.037     0.200
     0.613    11.537     0.200
     0.663    13.088     0.200
     0.695    12.537     0.200
     0.729    13.527     0.200
     0.741    13.758     0.200
     0.767    14.178     0.200
     0.844    14.957     0.200
     0.853    15.098     0.200
     0.910    17.088     0.200
     0.938    17.088     0.200
     0.948    16.697     0.200
     1.016    18.918     0.200
     1.054    19.758     0.200
     1.056    20.117     0.200
     1.070    19.867     0.200
     1.103    20.438     0.200
     1.132    19.629     0.200
     1.139    21.309     0.200
     1.167    20.549     0.200
     1.180    22.428     0.200
     1.247    22.348     0.200
     1.257    22.768     0.200
     0.070     2.953     0.200
     0.117     3.824     0.200
     0.196     5.504     0.200
     0.321     6.953     0.200
     0.324     7.105     0.200
     0.351     7.336     0.200
     0.365     7.496     0.200
     0.362     7.836     0.200
     0.475     8.816     0.200
     0.495     9.566     0.200
     0.541    10.004     0.200
     0.546     9.934     0.200
     0.518    10.727     0.200
     0.580    10.555     0.200
     0.582    10.887     0.200
     0.613    11.395     0.200
     0.577    11.203     0.200
     0.581    10.566     0.200
     0.581    10.684     0.200
     0.641    11.965     0.200
     0.700    13.137     0.200
     0.722    12.773     0.200
     0.704    13.094     0.200
     0.703    13.406     0.200
     0.737    13.246     0.200
     0.737    13.035     0.200
     0.779    13.797     0.200
     0.798    14.195     0.200
     0.854    14.797     0.200
     0.854    14.984     0.200
     0.892    15.945     0.200
     0.943    16.297     0.200
     0.977    18.273     0.200
     0.993    17.984     0.200
     1.023    17.453     0.200
     1.031    17.953     0.200
     1.024    18.105     0.200
     1.089    19.094     0.200
     1.064    19.656     0.200
     1.177    20.145     0.200
     1.123    20.434     0.200
     1.215    20.715     0.200
     1.173    20.746     0.200
     1.244    21.227     0.200
     1.239    22.113     0.200
     1.295    22.844     0.200
     1.337    23.125     0.200
     1.370    23.453     0.200
     1.429    24.363     0.200
     1.407    24.613     0.200
     1.405    25.125     0.200
     1.493    25.035     0.200
     1.507    25.203     0.200
     1.522    25.836     0.200
     1.528    26.113     0.200
     1.535    26.086     0.200
     1.820    32.387     0.200
     1.694    28.566     0.200
     1.720    29.137     0.200
     1.995    34.766     0.200
     2.009    34.656     0.200
     2.158    36.977     0.200
     2.273    38.926     0.200
     2.369    39.887     0.200
     2.337    40.324     0.200
     2.388    40.523     0.200
     2.430    40.785     0.200
     2.578    43.613     0.200
     2.642    46.414     0.200
     2.703    45.523     0.200
     2.799    47.426     0.200
     2.864    47.863     0.200
     3.446    57.484     0.200
     0.182     4.492     0.200
     0.290     6.602     0.200
     0.356     7.383     0.200
     0.375     7.723     0.200
     0.419     8.992     0.200
     0.423     8.965     0.200
     0.418     8.691     0.200
     0.553    10.281     0.200
     0.603    11.715     0.200
     0.612    11.504     0.200
     0.612    11.422     0.200
     0.631    12.082     0.200
     0.680    12.625     0.200
     0.701    13.375     0.200
     0.739    12.941     0.200
     0.700    12.922     0.200
     0.743    14.262     0.200
     0.798    14.312     0.200
     0.826    14.422     0.200
     0.835    14.645     0.200
     0.834    15.582     0.200
     0.848    15.383     0.200
     0.903    15.875     0.200
     0.912    15.863     0.200
     0.939    17.703     0.200
     0.947    17.383     0.200
     1.016    17.555     0.200
     0.993    17.805     0.200
     1.014    18.363     0.200
     1.111    19.293     0.200
     1.074    19.715     0.200
     1.231    21.273     0.200
     1.558    26.684     0.200
     1.569    27.703     0.200
     1.639    28.203     0.200
     1.634    28.664     0.200
     1.732    29.332     0.200
     1.742    29.973     0.200
     1.757    30.113     0.200
     1.783    30.672     0.200
     1.804    30.523     0.200
     1.913    32.484     0.200
     2.366    40.875     0.200
     2.798    46.891     0.200
     4.129    70.805     0.200
     4.690    75.805     0.200
     5.040    82.004     0.200
     0.190     4.352     0.200
     0.290     6.461     0.200
     0.363     7.211     0.200
     0.431     8.809     0.200
     0.440     8.809     0.200
     0.419     8.801     0.200
     0.548    10.418     0.200
     0.605    11.250     0.200
     0.620    11.379     0.200
     0.623    11.258     0.200
     0.648    12.039     0.200
     0.695    12.500     0.200
     0.718    13.461     0.200
     0.714    13.609     0.200
     0.761    14.031     0.200
     0.812    14.500     0.200
     0.839    14.398     0.200
     0.865    15.219     0.200
     0.906    15.828     0.200
     0.920    16.070     0.200
     0.953    17.668     0.200
     0.958    17.711     0.200
     1.010    17.590     0.200
     1.031    18.570     0.200
     1.089    19.520     0.200
     1.109    19.199     0.200
     1.234    20.988     0.200
     1.257    22.199     0.200
     1.282    21.961     0.200
     1.294    22.551     0.200
     1.301    22.508     0.200
     1.407    25.168     0.200
     1.625    28.430     0.200
     1.738    31.219     0.200
     1.751    30.461     0.200
     1.782    30.359     0.200
     1.822    30.680     0.200
     1.907    32.918     0.200
     1.967    33.141     0.200
     2.069    36.641     0.200
     2.061    34.238     0.200
     2.097    35.059     0.200
     2.133    35.660     0.200
     2.362    40.102     0.200
     0.061     3.883     0.200
     0.186     5.074     0.200
     0.241     5.523     0.200
     0.223     5.293     0.200
     0.301     6.543     0.200
     0.314     6.594     0.200
     0.381     7.941     0.200
     0.423     7.891     0.200
     0.420     8.574     0.200
     0.476     8.863     0.200
     0.514     9.871     0.200
     0.524    10.102     0.200
     0.573     9.973     0.200
     0.569    10.344     0.200
     0.576    10.492     0.200
     0.604    10.934     0.200
     0.658    11.961     0.200
     0.616    11.434     0.200
     0.683    12.273     0.200
     0.736    13.371     0.200
     0.713    13.453     0.200
     0.726    13.242     0.200
     0.719    13.574     0.200
     0.728    13.711     0.200
     0.839    15.262     0.200
     0.913    16.641     0.200
     1.012    18.551     0.200
     1.305    23.102     0.200
     1.382    23.363     0.200
     0.039     1.859     0.200
     0.194     3.844     0.200
     0.239     5.547     0.200
     0.201     5.664     0.200
     0.250     4.672     0.200
     0.311     6.141     0.200
     0.332     6.258     0.200
     0.338     7.062     0.200
     0.355     6.758     0.200
     0.404     7.719     0.200
     0.399     8.102     0.200
     0.435     8.461     0.200
     0.421     9.109     0.200
     0.474     8.750     0.200
     0.480     9.617     0.200
     0.499    10.914     0.200
     0.510     9.133     0.200
     0.614    10.977     0.200
     0.698    12.727     0.200
     0.676    12.961     0.200
     0.724    13.102     0.200
     0.677    12.703     0.200
     0.722    12.742     0.200
     0.700    12.688     0.200
     0.746    13.547     0.200
     0.758    13.680     0.200
     0.816    15.547     0.200
     0.835    14.469     0.200
     0.852    15.852     0.200
     0.873    16.297     0.200
     0.852    15.172     0.200
     0.944    16.469     0.200
     0.936    16.969     0.200
     0.944    18.070     0.200
     0.964    18.477     0.200
     0.961    17.008     0.200
     1.030    17.852     0.200
     1.045    18.594     0.200
     1.048    18.320     0.200
     1.008    19.000     0.200
     1.075    19.000     0.200
     1.156    21.383     0.200
     1.161    21.633     0.200
     1.185    21.180     0.200
     1.214    21.359     0.200
     1.234    21.719     0.200
     1.234    21.344     0.200
     1.264    22.133     0.200
     1.235    22.891     0.200
     1.262    23.023     0.200
     1.262    23.227     0.200
     1.310    22.820     0.200
     1.332    23.602     0.200
     1.353    24.641     0.200
     1.357    23.461     0.200
     1.317    23.781     0.200
     1.380    25.398     0.200
     1.370    24.688     0.200
     1.421    25.578     0.200
     1.441    25.227     0.200
     1.463    25.430     0.200
     1.461    26.164     0.200
     1.503    25.680     0.200
     1.477    27.500     0.200
     1.496    27.461     0.200
     1.523    27.367     0.200
     1.592    28.367     0.200
     1.599    27.727     0.200
     1.560    28.227     0.200
     1.561    27.570     0.200
     1.560    27.281     0.200
     1.600    28.883     0.200
     1.607    28.367     0.200
     1.723    30.039     0.200
     1.723    29.531     0.200
     1.740    30.289     0.200
     1.891    34.273     0.200
     1.938    35.047     0.200
     2.123    36.820     0.200
     2.126    37.648     0.200
     2.104    36.914     0.200
     2.242    39.977     0.200
     2.328    40.141     0.200
     2.329    39.961     0.200
     2.331    40.312     0.200
     2.372    41.508     0.200
     2.372    40.938     0.200
     2.418    41.289     0.200
     2.511    42.961     0.200
     2.533    43.258     0.200
     2.651    44.977     0.200
     2.671    45.914     0.200
     2.754    47.273     0.200
     2.757    47.461     0.200
     2.857    48.578     0.200
     3.333    55.109     0.200
     4.332    75.961     0.200
     0.170     3.523     0.200
     0.222     4.602     0.200
     0.223     5.398     0.200
     0.249     5.375     0.200
     0.295     5.812     0.200
     0.304     6.086     0.200
     0.338     6.422     0.200
     0.333     6.727     0.200
     0.390     7.562     0.200
     0.453     8.352     0.200
     0.427     7.812     0.200
     0.453     8.281     0.200
     0.436     8.828     0.200
     0.479     9.367     0.200
     0.491     8.992     0.200
     0.506    10.758     0.200
     0.616    10.867     0.200
     0.669    12.297     0.200
     0.685    13.055     0.200
     0.733    13.055     0.200
     0.746    13.445     0.200
     0.757    13.352     0.200
     0.821    14.172     0.200
     0.849    14.898     0.200
     0.878    15.578     0.200
     0.901    17.312     0.200
     0.940    16.227     0.200
     0.945    17.133     0.200
     0.976    16.867     0.200
     0.990    18.133     0.200
     1.036    18.148     0.200
     1.011    19.664     0.200
     1.046    18.664     0.200
     1.240    22.094     0.200
     1.294    22.312     0.200
     1.278    23.203     0.200
     1.311    23.273     0.200
     1.885    33.156     0.200
     7.644   122.125     0.200
     0.031     2.040     0.200
     0.191     3.870     0.200
     0.244     4.800     0.200
     0.236     5.570     0.200
     0.209     5.800     0.200
     0.303     5.940     0.200
     0.324     6.290     0.200
     0.355     6.840     0.200
     0.342     6.950     0.200
     0.396     7.750     0.200
     0.465     8.560     0.200
     0.406     8.100     0.200
     0.435     8.440     0.200
     0.429     9.120     0.200
     0.509     9.220     0.200
     0.485     9.460     0.200
     0.506    10.910     0.200
     0.609    10.950     0.200
     0.691    12.710     0.200
     0.683    12.660     0.200
     0.751    13.370     0.200
     0.762    13.730     0.200
     0.827    14.700     0.200
     0.857    15.160     0.200
     0.860    15.800     0.200
     0.938    16.480     0.200
     0.879    17.350     0.200
     0.943    17.110     0.200
     0.972    18.140     0.200
     1.069    19.210     0.200
     1.270    23.350     0.200
     1.321    23.680     0.200
     0.044     2.031     0.200
     0.192     3.758     0.200
     0.251     4.797     0.200
     0.245     5.797     0.200
     0.316     6.156     0.200
     0.334     6.352     0.200
     0.332     6.742     0.200
     0.350     6.734     0.200
     0.397     8.156     0.200
     0.410     7.969     0.200
     0.415     9.117     0.200
     0.474     9.281     0.200
     0.479     8.781     0.200
     0.486     8.906     0.200
     0.493    10.773     0.200
     0.505     9.203     0.200
     0.621    11.492     0.200
     0.671    12.477     0.200
     0.699    12.828     0.200
     0.739    13.297     0.200
     0.751    13.453     0.200
     0.841    14.492     0.200
     0.846    14.867     0.200
     0.849    16.805     0.200
     0.950    16.938     0.200
     1.051    18.969     0.200
     1.081    20.023     0.200
     1.268    22.445     0.200
     0.032     2.125     0.200
     0.196     3.977     0.200
     0.233     5.500     0.200
     0.248     4.836     0.200
     0.303     5.969     0.200
     0.327     6.258     0.200
     0.345     6.945     0.200
     0.359     6.906     0.200
     0.396     7.766     0.200
     0.403     8.055     0.200
     0.431     8.367     0.200
     0.466     8.547     0.200
     0.429     9.125     0.200
     0.487     9.539     0.200
     0.514     9.250     0.200
     0.507    10.883     0.200
     0.607    10.984     0.200
     0.695    12.797     0.200
     0.714    12.703     0.200
     0.684    12.945     0.200
     0.685    12.617     0.200
     0.765    13.617     0.200
     0.827    14.266     0.200
     0.857    15.867     0.200
     0.859    15.617     0.200
     0.875    16.805     0.200
     0.936    16.312     0.200
     0.944    16.984     0.200
     0.952    17.945     0.200
     0.970    18.336     0.200
     0.969    16.695     0.200
     1.037    18.266     0.200
     1.040    18.156     0.200
     1.067    18.648     0.200
     1.183    20.938     0.200
     1.226    20.656     0.200
     1.226    22.078     0.200
     1.257    22.305     0.200
     1.302    22.375     0.200
     1.270    23.195     0.200
     1.325    23.297     0.200
     1.345    23.227     0.200
     1.349    23.344     0.200
     1.324    23.562     0.200
     1.433    25.023     0.200
     1.495    26.398     0.200
     1.584    28.062     0.200
     1.592    27.812     0.200
     1.568    27.305     0.200
     1.567    27.406     0.200
     1.615    28.359     0.200
     1.732    29.945     0.200
     1.865    32.797     0.200
     1.877    33.039     0.200
     1.884    33.023     0.200
     2.097    36.719     0.200
     2.470    42.359     0.200
     4.063    67.609     0.200
     4.846    79.945     0.200
     0.043     2.461     0.200
     0.169     5.000     0.200
     0.205     4.951     0.200
     0.246     5.471     0.200
     0.237     5.771     0.200
     0.328     6.750     0.200
     0.314     6.490     0.200
     0.381     8.262     0.200
     0.453     8.801     0.200
     0.454     8.932     0.200
     0.528    10.191     0.200
     0.535    10.090     0.200
     0.522     9.801     0.200
     0.520     9.801     0.200
     0.520    10.691     0.200
     0.557    11.000     0.200
     0.624    11.570     0.200
     0.633    11.500     0.200
     0.668    12.621     0.200
     0.662    12.611     0.200
     0.669    12.471     0.200
     0.663    12.471     0.200
     0.681    12.191     0.200
     0.709    13.320     0.200
     0.786    13.980     0.200
     0.797    14.320     0.200
     0.858    15.080     0.200
     0.907    17.000     0.200
     0.889    15.621     0.200
     0.944    16.311     0.200
     0.924    16.371     0.200
     0.973    17.000     0.200
     1.036    18.580     0.200
     1.117    19.461     0.200
     1.141    19.682     0.200
     1.108    20.400     0.200
     1.162    20.031     0.200
     1.181    21.400     0.200
     1.209    22.131     0.200
     1.234    22.451     0.200
     1.278    21.701     0.200
     1.330    23.480     0.200
     1.396    24.602     0.200
     1.427    24.080     0.200
     1.399    25.160     0.200
     1.433    24.932     0.200
     1.414    25.201     0.200
     1.478    25.230     0.200
     1.479    25.230     0.200
     1.528    27.051     0.200
     1.525    26.861     0.200
     1.529    27.000     0.200
     1.617    28.631     0.200
     1.579    27.660     0.200
     1.606    28.160     0.200
     1.626    28.820     0.200
     1.678    29.250     0.200
     1.735    29.840     0.200
     1.732    30.293     0.200
     1.732    29.980     0.200
     1.908    32.900     0.200
     2.424    41.961     0.200
     4.350    72.932     0.200
     0.033     2.266     0.200
     0.151     3.746     0.200
     0.193     4.027     0.200
     0.207     5.465     0.200
     0.236     5.457     0.200
     0.232     5.535     0.200
     0.246     4.965     0.200
     0.305     6.016     0.200
     0.327     6.457     0.200
     0.341     6.824     0.200
     0.355     6.855     0.200
     0.398     7.805     0.200
     0.404     7.805     0.200
     0.435     8.254     0.200
     0.468     8.617     0.200
     0.484     9.285     0.200
     0.504    10.645     0.200
     0.510     9.188     0.200
     0.610    10.836     0.200
     0.693    12.996     0.200
     0.682    12.414     0.200
     0.716    12.605     0.200
     0.721    12.945     0.200
     0.723    12.617     0.200
     0.714    12.297     0.200
     0.750    13.305     0.200
     0.829    14.348     0.200
     0.857    15.188     0.200
     0.856    15.195     0.200
     0.939    16.117     0.200
     0.941    16.637     0.200
     0.970    17.527     0.200
     0.967    16.367     0.200
     1.070    19.305     0.200
     1.162    21.164     0.200
     1.164    20.957     0.200
     1.268    22.824     0.200
     1.328    23.586     0.200
     1.320    23.355     0.200
     1.564    27.438     0.200
     1.613    28.016     0.200
     1.880    34.254     0.200
     2.529    43.676     0.200
     3.100    54.316     0.200
     3.861    67.547     0.200
     0.135     4.117     0.200
     0.257     5.945     0.200
     0.249     5.719     0.200
     0.194     4.922     0.200
     0.276     6.859     0.200
     0.330     7.125     0.200
     0.416     8.188     0.200
     0.501     9.258     0.200
     0.505     9.250     0.200
     0.463     9.445     0.200
     0.561    10.289     0.200
     0.557    10.102     0.200
     0.487     9.125     0.200
     0.589    11.000     0.200
     0.568    10.672     0.200
     0.598    11.547     0.200
     0.619    11.227     0.200
     0.569    10.641     0.200
     0.637    11.477     0.200
     0.615    12.641     0.200
     0.682    12.102     0.200
     0.665    12.602     0.200
     0.637    12.258     0.200
     0.771    13.625     0.200
     0.743    13.625     0.200
     0.795    14.055     0.200
     0.796    13.930     0.200
     0.764    14.477     0.200
     0.803    14.578     0.200
     0.887    15.430     0.200
     0.938    16.500     0.200
     0.895    15.711     0.200
     0.954    16.352     0.200
     0.988    17.070     0.200
     0.997    18.141     0.200
     0.995    17.695     0.200
     1.027    17.961     0.200
     1.086    18.617     0.200
     1.138    19.445     0.200
     1.182    20.078     0.200
     1.186    20.656     0.200
     1.165    21.070     0.200
     1.246    21.609     0.200
     1.270    21.867     0.200
     1.220    21.578     0.200
     1.332    22.758     0.200
     1.276    22.586     0.200
     1.436    23.938     0.200
     1.477    25.016     0.200
     1.599    28.367     0.200
     1.635    29.305     0.200
     1.682    29.297     0.200
     1.718    30.070     0.200
     1.909    32.875     0.200
     2.174    36.641     0.200
     2.430    40.672     0.200
     2.603    43.516     0.200
     3.452    60.797     0.200
     4.321    70.352     0.200
     0.173     4.680     0.200
     0.176     4.938     0.200
     0.234     5.242     0.200
     0.236     5.500     0.200
     0.304     6.562     0.200
     0.303     6.531     0.200
     0.312     7.750     0.200
     0.368     7.781     0.200
     0.372     7.148     0.200
     0.413     7.875     0.200
     0.429     8.602     0.200
     0.455     8.969     0.200
     0.474     8.859     0.200
     0.489     8.734     0.200
     0.501     9.750     0.200
     0.537    10.062     0.200
     0.563    10.211     0.200
     0.574    10.375     0.200
     0.575    10.500     0.200
     0.591    10.812     0.200
     0.620    11.172     0.200
     0.664    11.992     0.200
     0.678    12.172     0.200
     0.706    12.203     0.200
     0.721    13.414     0.200
     0.715    12.992     0.200
     0.723    12.914     0.200
     0.739    13.273     0.200
     0.786    14.828     0.200
     0.788    14.922     0.200
     0.797    15.531     0.200
     0.798    15.430     0.200
     0.808    15.562     0.200
     0.819    14.508     0.200
     0.811    15.203     0.200
     0.827    15.719     0.200
     0.909    16.859     0.200
     0.914    17.133     0.200
     0.925    17.633     0.200
     0.949    17.438     0.200
     0.964    16.570     0.200
     0.986    17.289     0.200
     1.031    18.641     0.200
     1.066    18.664     0.200
     1.165    20.422     0.200
     1.205    21.719     0.200
     1.307    23.242     0.200
     1.319    23.758     0.200
     1.350    24.102     0.200
     1.377    23.453     0.200
     1.625    28.773     0.200
     1.643    28.523     0.200
     1.669    29.773     0.200
     1.716    29.109     0.200
     1.737    31.055     0.200
     1.765    30.188     0.200
     1.872    32.180     0.200
     1.911    32.953     0.200
     2.001    34.438     0.200
     2.092    34.438     0.200
     2.096    35.320     0.200
     2.145    35.953     0.200
     2.303    38.359     0.200
     2.307    38.219     0.200
     2.326    39.258     0.200
     2.428    40.961     0.200
     2.512    41.203     0.200
     2.591    43.500     0.200
     2.697    43.953     0.200
     2.732    44.742     0.200
     2.738    45.969     0.200
     5.543    96.109     0.200
     0.061     3.844     0.200
     0.164     4.672     0.200
     0.184     5.109     0.200
     0.227     5.234     0.200
     0.238     5.523     0.200
     0.300     6.523     0.200
     0.311     6.539     0.200
     0.322     7.742     0.200
     0.373     7.133     0.200
     0.377     7.883     0.200
     0.422     8.586     0.200
     0.419     7.969     0.200
     0.474     8.836     0.200
     0.464     9.094     0.200
     0.486     8.789     0.200
     0.527    10.062     0.200
     0.510     9.844     0.200
     0.569    10.336     0.200
     0.575    10.453     0.200
     0.569    10.312     0.200
     0.601    10.844     0.200
     0.618    11.359     0.200
     0.659    11.930     0.200
     0.681    12.289     0.200
     0.735    12.984     0.200
     0.732    13.516     0.200
     0.721    13.273     0.200
     0.712    12.344     0.200
     0.724    13.289     0.200
     0.733    13.219     0.200
     0.812    14.570     0.200
     0.792    14.859     0.200
     0.795    15.352     0.200
     0.803    15.141     0.200
     0.805    15.562     0.200
     0.811    15.484     0.200
     0.814    15.273     0.200
     0.817    15.344     0.200
     0.836    15.500     0.200
     0.911    17.320     0.200
     0.958    16.523     0.200
     0.921    17.344     0.200
     1.158    19.914     0.200
     1.304    23.148     0.200
     1.273    23.336     0.200
     1.328    24.086     0.200
     1.356    23.961     0.200
     1.364    24.625     0.200
     1.378    24.320     0.200
     1.418    25.109     0.200
     1.430    25.891     0.200
     1.523    25.664     0.200
     1.478    26.219     0.200
     1.593    29.234     0.200
     1.579    28.414     0.200
     1.634    29.273     0.200
     1.711    30.742     0.200
     1.728    30.805     0.200
     1.818    32.039     0.200
     1.782    32.391     0.200
     1.864    32.266     0.200
     1.894    33.359     0.200
     1.903    32.984     0.200
     1.910    33.344     0.200
     1.942    33.555     0.200
     1.984    33.875     0.200
     1.993    34.500     0.200
     1.992    33.914     0.200
     2.421    41.211     0.200
     2.535    43.016     0.200
     2.722    45.781     0.200
     2.730    45.391     0.200
     2.853    47.594     0.200
     0.107     5.363     0.200
     0.107     5.634     0.200
     0.196     6.313     0.200
     0.182     6.494     0.200
     0.325     8.554     0.200
     0.503    10.884     0.200
     0.677    13.664     0.200
     0.669    13.374     0.200
     0.729    14.784     0.200
     0.702    13.664     0.200
     0.827    16.174     0.200
     0.785    14.983     0.200
     0.813    16.184     0.200
     0.914    17.344     0.200
     0.920    16.674     0.200
     0.861    16.014     0.200
     0.933    17.204     0.200
     0.922    17.054     0.200
     0.945    17.323     0.200
     0.959    17.193     0.200
     0.927    16.994     0.200
     0.999    17.684     0.200
     1.052    18.284     0.200
     1.089    18.934     0.200
     1.167    19.943     0.200
     1.459    25.914     0.200
     1.525    26.403     0.200
     1.529    26.764     0.200
     1.602    27.534     0.200
     1.737    30.004     0.200
     1.778    30.153     0.200
     1.828    31.224     0.200
     1.828    31.044     0.200
     1.837    30.594     0.200
     1.836    31.014     0.200
     1.879    32.254     0.200
     1.963    33.204     0.200
     2.005    34.224     0.200
     2.015    34.754     0.200
     2.030    34.153     0.200
     2.039    34.124     0.200
     2.085    34.483     0.200
     2.099    34.684     0.200
     2.107    34.934     0.200
     2.128    35.273     0.200
     2.142    35.653     0.200
     2.262    37.294     0.200
     2.384    39.014     0.200
     0.109     5.415     0.200
     0.256     6.845     0.200
     0.571    11.694     0.200
     0.686    13.814     0.200
     0.744    14.425     0.200
     0.779    15.465     0.200
     0.761    14.635     0.200
     0.815    16.494     0.200
     0.765    14.415     0.200
     0.858    15.854     0.200
     0.903    16.895     0.200
     0.847    15.704     0.200
     1.094    19.475     0.200
     1.197    20.915     0.200
     1.228    21.515     0.200
     1.294    22.734     0.200
     1.297    22.824     0.200
     1.408    24.104     0.200
     1.493    24.965     0.200
     1.627    27.335     0.200
     1.635    27.944     0.200
     1.625    27.994     0.200
     1.724    29.045     0.200
     1.990    33.314     0.200
     2.030    34.085     0.200
     2.370    38.395     0.200
     0.140     4.216     0.200
     0.207     4.966     0.200
     0.178     5.386     0.200
     0.223     4.916     0.200
     0.218     5.846     0.200
     0.255     6.486     0.200
     0.306     6.216     0.200
     0.301     6.536     0.200
     0.344     6.796     0.200
     0.396     8.446     0.200
     0.337     7.076     0.200
     0.347     6.766     0.200
     0.420     8.076     0.200
     0.365     7.696     0.200
     0.402     7.896     0.200
     0.415     8.066     0.200
     0.476     8.856     0.200
     0.441     8.376     0.200
     0.553    10.326     0.200
     0.575    11.136     0.200
     0.514     9.406     0.200
     0.559    11.046     0.200
     0.561    11.176     0.200
     0.571    11.336     0.200
     0.579    11.936     0.200
     0.624    11.186     0.200
     0.582    11.436     0.200
     0.564    10.496     0.200
     0.609    12.076     0.200
     0.689    11.956     0.200
     0.666    12.616     0.200
     0.751    13.656     0.200
     0.727    14.566     0.200
     0.751    14.866     0.200
     0.724    14.366     0.200
     0.786    15.176     0.200
     0.824    14.806     0.200
     0.854    15.886     0.200
     0.876    16.396     0.200
     0.918    16.946     0.200
     0.913    16.466     0.200
     0.967    17.846     0.200
     0.991    17.916     0.200
     1.046    19.366     0.200
     1.280    22.396     0.200
     1.222    22.056     0.200
     1.231    22.196     0.200
     1.328    23.746     0.200
     2.150    37.346     0.200
     2.466    41.256     0.200
     2.469    41.146     0.200
     2.671    44.166     0.200
     0.186     4.148     0.200
     0.231     5.305     0.200
     0.251     5.465     0.200
     0.330     7.805     0.200
     0.348     7.465     0.200
     0.454     8.855     0.200
     0.484     8.938     0.200
     0.534     9.676     0.200
     0.529     9.375     0.200
     0.535    10.027     0.200
     0.525    10.426     0.200
     0.531     9.758     0.200
     0.572    10.438     0.200
     0.623    11.238     0.200
     0.678    14.156     0.200
     0.678    11.777     0.200
     0.675    12.195     0.200
     0.675    13.715     0.200
     0.722    12.625     0.200
     0.722    12.496     0.200
     0.720    13.695     0.200
     0.807    14.297     0.200
     0.806    14.586     0.200
     0.834    14.758     0.200
     0.834    14.957     0.200
     0.882    15.176     0.200
     0.863    15.535     0.200
     0.930    16.078     0.200
     0.913    15.508     0.200
     1.030    17.457     0.200
     1.004    18.305     0.200
     1.273    21.516     0.200
     1.622    27.168     0.200
     1.766    29.465     0.200
     1.987    34.578     0.200
     2.449    40.367     0.200
     3.033    50.238     0.200
     3.372    56.625     0.200
     0.175     4.359     0.200
     0.206     4.844     0.200
     0.236     5.375     0.200
     0.260     5.500     0.200
     0.345     7.750     0.200
     0.360     7.602     0.200
     0.468     9.000     0.200
     0.489     9.055     0.200
     0.528     9.906     0.200
     0.538    10.102     0.200
     0.533     9.422     0.200
     0.544     9.844     0.200
     0.539    10.383     0.200
     0.566    10.305     0.200
     0.583    10.523     0.200
     0.633    11.375     0.200
     0.631    11.555     0.200
     0.668    11.727     0.200
     0.681    11.984     0.200
     0.681    11.844     0.200
     0.681    12.141     0.200
     0.690    12.242     0.200
     0.717    12.656     0.200
     0.690    13.492     0.200
     0.734    13.516     0.200
     0.811    14.883     0.200
     0.822    14.430     0.200
     0.819    14.562     0.200
     0.857    14.836     0.200
     0.854    14.984     0.200
     0.875    15.375     0.200
     0.849    14.773     0.200
     0.849    14.656     0.200
     0.878    15.609     0.200
     0.912    15.602     0.200
     0.920    16.250     0.200
     0.962    16.586     0.200
     0.943    16.180     0.200
     0.969    16.695     0.200
     1.023    17.570     0.200
     1.024    17.852     0.200
     1.010    17.383     0.200
     1.089    18.586     0.200
     1.118    19.016     0.200
     1.099    18.656     0.200
     1.145    19.320     0.200
     1.149    20.445     0.200
     1.168    20.000     0.200
     1.198    20.484     0.200
     1.201    20.531     0.200
     1.264    21.266     0.200
     1.264    21.453     0.200
     1.264    21.984     0.200
     1.315    23.281     0.200
     1.349    22.656     0.200
     1.361    23.039     0.200
     1.375    23.414     0.200
     1.351    24.406     0.200
     1.364    24.516     0.200
     1.391    24.984     0.200
     1.444    25.852     0.200
     1.470    25.203     0.200
     1.533    25.906     0.200
     1.533    26.477     0.200
     1.574    27.594     0.200
     1.577    26.859     0.200
     1.612    27.164     0.200
     1.581    27.625     0.200
     1.643    29.000     0.200
     1.850    31.523     0.200
     2.436    40.352     0.200
     3.405    59.734     0.200
     4.451    71.375     0.200
     0.189     4.047     0.200
     0.227     5.141     0.200
     0.185     4.438     0.200
     0.249     5.055     0.200
     0.341     7.227     0.200
     0.324     7.180     0.200
     0.479     8.766     0.200
     0.447     8.641     0.200
     0.535     9.625     0.200
     0.531     9.789     0.200
     0.524     9.508     0.200
     0.521     9.984     0.200
     0.531     8.961     0.200
     0.565    10.211     0.200
     0.617    11.070     0.200
     0.610    11.141     0.200
     0.659    11.414     0.200
     0.668    11.906     0.200
     0.721    12.375     0.200
     0.670    13.047     0.200
     0.680    11.188     0.200
     0.680    11.508     0.200
     0.680    11.320     0.200
     0.713    13.086     0.200
     0.804    14.117     0.200
     0.843    14.758     0.200
     0.852    14.570     0.200
     0.801    14.125     0.200
     0.809    14.266     0.200
     0.827    14.234     0.200
     0.827    14.688     0.200
     0.883    15.859     0.200
     0.911    15.344     0.200
     0.858    15.195     0.200
     0.932    16.070     0.200
     0.956    16.281     0.200
     0.949    16.289     0.200
     1.031    18.188     0.200
     1.015    17.859     0.200
     1.091    18.430     0.200
     1.059    20.570     0.200
     1.059    20.227     0.200
     1.059    20.367     0.200
     1.073    20.070     0.200
     1.129    18.727     0.200
     1.078    18.930     0.200
     1.111    21.117     0.200
     1.134    21.195     0.200
     1.141    21.305     0.200
     1.192    21.594     0.200
     1.211    20.125     0.200
     1.182    20.125     0.200
     1.274    21.094     0.200
     1.274    21.430     0.200
     1.225    21.398     0.200
     1.296    23.125     0.200
     1.355    23.430     0.200
     1.373    23.188     0.200
     1.384    24.008     0.200
     1.392    23.055     0.200
     1.335    23.430     0.200
     1.416    23.906     0.200
     1.447    24.195     0.200
     1.489    25.531     0.200
     1.542    27.531     0.200
     1.547    28.391     0.200
     1.550    26.438     0.200
     1.577    29.070     0.200
     1.577    28.461     0.200
     1.598    28.320     0.200
     1.554    26.500     0.200
     1.624    26.711     0.200
     1.624    27.766     0.200
     1.561    26.891     0.200
     1.632    28.320     0.200
     1.651    29.938     0.200
     1.658    29.555     0.200
     1.658    29.930     0.200
     1.745    30.266     0.200
     3.426    56.789     0.200
     4.430    71.430     0.200
     9.064   148.500     0.200
     0.171     4.094     0.200
     0.214     4.891     0.200
     0.200     4.805     0.200
     0.269     5.602     0.200
     0.341     7.336     0.200
     0.337     7.703     0.200
     0.467     8.680     0.200
     0.453     8.812     0.200
     0.515     9.422     0.200
     0.517     9.695     0.200
     0.525     9.516     0.200
     0.537    10.445     0.200
     0.562    10.234     0.200
     0.549     9.484     0.200
     0.611    10.945     0.200
     0.646    11.344     0.200
     0.619    11.477     0.200
     0.702    12.344     0.200
     0.674    12.102     0.200
     0.698    12.422     0.200
     0.725    13.422     0.200
     0.801    14.000     0.200
     0.836    14.414     0.200
     0.831    14.547     0.200
     0.863    14.914     0.200
     0.832    14.625     0.200
     0.818    14.516     0.200
     0.827    15.266     0.200
     0.893    15.273     0.200
     0.912    15.953     0.200
     0.873    15.594     0.200
     0.942    16.086     0.200
     0.934    15.977     0.200
     1.011    16.984     0.200
     1.016    17.422     0.200
     1.021    17.906     0.200
     1.072    18.266     0.200
     1.109    18.680     0.200
     1.092    19.375     0.200
     1.191    20.211     0.200
     1.255    21.211     0.200
     1.243    22.797     0.200
     1.335    22.625     0.200
     1.353    22.836     0.200
     1.365    23.203     0.200
     1.395    23.422     0.200
     1.354    24.172     0.200
     1.433    24.086     0.200
     1.523    25.586     0.200
     1.528    28.117     0.200
     2.371    40.727     0.200
     2.462    41.773     0.200
     2.620    43.672     0.200
     2.629    43.953     0.200
     2.684    44.977     0.200
     0.205     4.414     0.200
     0.178     4.523     0.200
     0.245     5.445     0.200
     0.231     4.914     0.200
     0.318     7.312     0.200
     0.349     7.484     0.200
     0.449     8.773     0.200
     0.495     9.148     0.200
     0.554    10.008     0.200
     0.549    10.164     0.200
     0.511     8.703     0.200
     0.530     9.703     0.200
     0.509     9.984     0.200
     0.574    10.453     0.200
     0.629    11.406     0.200
     0.607    11.203     0.200
     0.676    11.922     0.200
     0.660    11.047     0.200
     0.670    12.008     0.200
     0.660    13.375     0.200
     0.740    12.766     0.200
     0.707    13.148     0.200
     0.789    13.648     0.200
     0.813    14.422     0.200
     0.789    14.078     0.200
     0.859    15.148     0.200
     0.871    14.992     0.200
     0.829    14.328     0.200
     0.902    15.508     0.200
     0.848    15.195     0.200
     0.930    15.727     0.200
     0.949    16.359     0.200
     0.940    16.273     0.200
     1.050    17.695     0.200
     1.033    19.016     0.200
     1.110    18.695     0.200
     1.147    19.219     0.200
     1.209    22.148     0.200
     1.293    21.492     0.200
     1.293    21.703     0.200
     1.374    22.727     0.200
     1.390    23.359     0.200
     1.321    23.883     0.200
     1.412    23.586     0.200
     1.465    24.633     0.200
     1.501    25.062     0.200
     1.641    27.383     0.200
     1.820    30.906     0.200
     3.037    50.367     0.200
     3.016    50.727     0.200
     4.432    70.258     0.200
     0.179     4.695     0.200
     0.249     5.523     0.200
     0.353     7.727     0.200
     0.320     7.695     0.200
     0.207     4.688     0.200
     0.229     5.156     0.200
     0.451     8.969     0.200
     0.500     9.328     0.200
     0.533     9.852     0.200
     0.578    10.664     0.200
     0.509    10.055     0.200
     0.553    10.273     0.200
     0.609    11.484     0.200
     0.634    11.469     0.200
     0.557    10.266     0.200
     0.673    12.102     0.200
     0.680    11.977     0.200
     0.508     9.023     0.200
     0.709    13.477     0.200
     0.817    14.523     0.200
     0.744    13.016     0.200
     0.832    14.688     0.200
     0.657    11.578     0.200
     0.789    14.219     0.200
     0.849    15.328     0.200
     0.875    15.047     0.200
     0.786    14.219     0.200
     0.934    15.984     0.200
     0.962    17.102     0.200
     0.979    16.836     0.200
     0.905    15.648     0.200
     0.951    16.602     0.200
     0.978    16.789     0.200
     1.053    17.789     0.200
     0.199     4.445     0.200
     0.190     4.578     0.200
     0.236     5.094     0.200
     0.251     5.547     0.200
     0.331     7.469     0.200
     0.361     7.539     0.200
     0.462     8.844     0.200
     0.503     9.188     0.200
     0.510     8.969     0.200
     0.519    10.133     0.200
     0.552    10.023     0.200
     0.555    10.227     0.200
     0.586    10.508     0.200
     0.640    11.398     0.200
     0.659    11.742     0.200
     0.683    11.859     0.200
     0.683    12.133     0.200
     0.740    12.836     0.200
     0.720    13.469     0.200
     0.788    14.359     0.200
     0.799    14.219     0.200
     0.825    14.406     0.200
     0.842    14.695     0.200
     0.867    15.234     0.200
     0.859    15.312     0.200
     0.875    14.977     0.200
     0.899    15.477     0.200
     0.933    15.695     0.200
     0.944    16.383     0.200
     0.951    16.445     0.200
     0.980    16.844     0.200
     1.047    17.727     0.200
     1.075    20.477     0.200
     1.075    20.555     0.200
     1.089    20.117     0.200
     1.111    18.664     0.200
     1.142    19.188     0.200
     1.181    21.938     0.200
     1.221    20.648     0.200
     1.216    22.328     0.200
     1.243    22.625     0.200
     1.288    21.625     0.200
     0.089     3.901     0.200
     0.165     4.651     0.200
     0.128     4.131     0.200
     0.228     5.161     0.200
     0.270     5.891     0.200
     0.368     8.081     0.200
     0.383     7.771     0.200
     0.492     9.221     0.200
     0.524    10.101     0.200
     0.550    10.261     0.200
     0.533    10.101     0.200
     0.558    10.861     0.200
     0.604    10.851     0.200
     0.653    11.521     0.200
     0.682    11.841     0.200
     0.717    12.801     0.200
     0.680    13.131     0.200
     0.713    12.731     0.200
     0.757    14.281     0.200
     0.843    14.741     0.200
     0.810    14.541     0.200
     0.865    15.161     0.200
     0.837    14.891     0.200
     0.868    15.171     0.200
     0.870    15.561     0.200
     0.872    15.151     0.200
     0.910    16.531     0.200
     0.916    15.861     0.200
     0.898    15.951     0.200
     0.946    16.641     0.200
     0.972    16.931     0.200
     0.966    16.931     0.200
     0.990    17.261     0.200
     1.012    17.711     0.200
     1.036    19.421     0.200
     1.015    18.771     0.200
     1.022    18.251     0.200
     1.051    18.631     0.200
     1.090    18.781     0.200
     1.090    19.881     0.200
     1.110    19.321     0.200
     1.104    20.371     0.200
     1.104    20.311     0.200
     1.104    20.481     0.200
     1.118    20.141     0.200
     1.127    20.471     0.200
     1.187    20.821     0.200
     1.236    21.291     0.200
     1.256    21.981     0.200
     1.244    21.621     0.200
     1.253    22.861     0.200
     1.718    29.991     0.200
     1.711    29.701     0.200
     1.743    30.271     0.200
     1.827    31.431     0.200
     1.926    32.551     0.200
     1.931    32.801     0.200
     2.334    40.081     0.200
     2.879    47.781     0.200
     3.337    56.381     0.200
     3.637    60.781     0.200
     0.089     3.219     0.200
     0.113     3.734     0.200
     0.126     3.797     0.200
     0.199     5.039     0.200
     0.183     4.797     0.200
     0.238     6.008     0.200
     0.253     5.547     0.200
     0.339     8.000     0.200
     0.358     7.945     0.200
     0.464     9.336     0.200
     0.491     9.547     0.200
     0.541    10.273     0.200
     0.532    10.570     0.200
     0.541    10.641     0.200
     0.534    10.375     0.200
     0.527     9.469     0.200
     0.581    10.867     0.200
     0.626    11.914     0.200
     0.632    11.734     0.200
     0.670    12.211     0.200
     0.685    12.695     0.200
     0.683    13.891     0.200
     0.676    12.297     0.200
     0.728    14.180     0.200
     0.723    13.234     0.200
     0.812    14.719     0.200
     0.844    15.180     0.200
     0.805    14.961     0.200
     0.860    15.359     0.200
     0.871    15.805     0.200
     0.881    15.875     0.200
     0.918    16.258     0.200
     0.917    16.016     0.200
     0.937    17.070     0.200
     0.927    16.711     0.200
     0.962    16.891     0.200
     0.966    17.094     0.200
     0.984    17.344     0.200
     0.988    17.891     0.200
     1.022    18.297     0.200
     1.062    19.297     0.200
     1.076    19.789     0.200
     1.077    19.727     0.200
     1.090    20.766     0.200
     1.093    19.109     0.200
     1.094    19.156     0.200
     1.102    20.195     0.200
     1.125    19.625     0.200
     1.194    21.086     0.200
     1.217    21.523     0.200
     1.183    21.180     0.200
     1.228    21.586     0.200
     1.205    21.055     0.200
     1.232    22.859     0.200
     1.257    22.484     0.200
     1.271    22.258     0.200
     1.321    24.625     0.200
     1.344    24.445     0.200
     1.356    24.008     0.200
     1.368    23.773     0.200
     1.382    24.375     0.200
     1.397    23.969     0.200
     1.422    24.930     0.200
     1.408    24.250     0.200
     1.437    26.148     0.200
     1.457    25.273     0.200
     1.540    26.625     0.200
     1.619    27.750     0.200
     1.735    29.523     0.200
     1.785    30.523     0.200
     1.954    33.664     0.200
     1.963    34.438     0.200
     2.109    36.789     0.200
     2.113    35.898     0.200
     2.274    38.148     0.200
     2.264    38.336     0.200
     2.412    40.375     0.200
     2.531    42.898     0.200
     0.087     2.812     0.200
     0.120     3.297     0.200
     0.117     3.250     0.200
     0.199     4.461     0.200
     0.184     4.508     0.200
     0.243     5.438     0.200
     0.237     4.969     0.200
     0.324     7.445     0.200
     0.352     7.469     0.200
     0.453     8.812     0.200
     0.494     9.133     0.200
     0.515     9.195     0.200
     0.548    10.039     0.200
     0.516    10.047     0.200
     0.547    10.188     0.200
     0.577    10.508     0.200
     0.613    11.250     0.200
     0.631    11.359     0.200
     0.675    11.789     0.200
     0.665    11.711     0.200
     0.667    13.328     0.200
     0.675    12.062     0.200
     0.736    12.867     0.200
     0.714    13.656     0.200
     0.794    14.992     0.200
     0.796    14.148     0.200
     0.816    14.500     0.200
     0.834    14.609     0.200
     0.868    14.969     0.200
     0.896    15.500     0.200
     0.855    15.227     0.200
     0.927    15.758     0.200
     0.943    16.312     0.200
     0.923    16.477     0.200
     0.973    16.789     0.200
     0.946    16.328     0.200
     0.972    17.609     0.200
     1.031    19.188     0.200
     1.066    19.430     0.200
     1.067    20.008     0.200
     1.066    19.828     0.200
     1.106    18.859     0.200
     1.080    20.328     0.200
     1.077    19.352     0.200
     1.085    19.562     0.200
     1.141    20.930     0.200
     1.127    19.547     0.200
     1.144    20.883     0.200
     1.199    20.961     0.200
     1.221    20.672     0.200
     1.177    20.867     0.200
     1.201    21.102     0.200
     1.235    22.469     0.200
     1.215    22.320     0.200
     1.286    22.891     0.200
     1.240    23.031     0.200
     1.306    24.102     0.200
     1.327    23.969     0.200
     1.369    24.227     0.200
     1.384    23.609     0.200
     1.397    23.758     0.200
     1.408    24.609     0.200
     1.422    25.750     0.200
     1.463    25.148     0.200
     1.446    25.266     0.200
     1.551    27.008     0.200
     1.557    27.891     0.200
     1.555    27.227     0.200
     1.553    27.477     0.200
     1.593    28.211     0.200
     1.557    27.336     0.200
     1.635    27.891     0.200
     1.641    27.508     0.200
     1.606    27.750     0.200
     1.667    29.109     0.200
     3.914    66.688     0.200
     0.090     3.055     0.200
     0.114     3.566     0.200
     0.120     3.605     0.200
     0.190     4.707     0.200
     0.194     4.848     0.200
     0.242     5.734     0.200
     0.245     5.348     0.200
     0.334     7.766     0.200
     0.357     7.766     0.200
     0.461     9.137     0.200
     0.494     9.426     0.200
     0.521     9.227     0.200
     0.525    10.406     0.200
     0.541    10.297     0.200
     0.539    10.027     0.200
     0.545    10.477     0.200
     0.581    10.777     0.200
     0.634    11.656     0.200
     0.674    12.105     0.200
     0.670    11.836     0.200
     0.682    12.445     0.200
     0.730    13.098     0.200
     0.723    13.867     0.200
     0.799    14.805     0.200
     0.805    14.527     0.200
     0.841    14.664     0.200
     0.865    15.305     0.200
     0.865    15.617     0.200
     0.889    15.766     0.200
     0.923    15.926     0.200
     0.934    16.605     0.200
     0.932    16.457     0.200
     0.956    16.707     0.200
     0.995    16.906     0.200
     1.132    19.457     0.200
     1.190    22.906     0.200
     1.187    20.297     0.200
     1.212    20.926     0.200
     1.233    22.234     0.200
     1.224    22.766     0.200
     1.278    21.926     0.200
     1.337    24.215     0.200
     1.376    23.555     0.200
     1.415    24.066     0.200
     1.462    24.047     0.200
     1.547    26.395     0.200
     1.632    27.895     0.200
     0.068     2.477     0.200
     0.142     3.207     0.200
     0.148     3.807     0.200
     0.187     4.547     0.200
     0.207     4.627     0.200
     0.207     4.537     0.200
     0.249     4.938     0.200
     0.331     6.807     0.200
     0.326     7.797     0.200
     0.337     6.268     0.200
     0.332     7.066     0.200
     0.333     7.137     0.200
     0.340     7.248     0.200
     0.371     7.717     0.200
     0.364     6.947     0.200
     0.379     7.627     0.200
     0.353     7.406     0.200
     0.375     7.248     0.200
     0.464     9.707     0.200
     0.432     7.938     0.200
     0.443     8.248     0.200
     0.478     9.697     0.200
     0.491     9.527     0.200
     0.470     9.107     0.200
     0.477     8.938     0.200
     0.480    10.127     0.200
     0.516     9.598     0.200
     0.510    10.447     0.200
     0.512    10.297     0.200
     0.530    10.457     0.200
     0.514    10.178     0.200
     0.515    10.367     0.200
     0.530    10.348     0.200
     0.544    10.248     0.200
     0.600    11.977     0.200
     0.593    11.348     0.200
     0.587    10.508     0.200
     0.602    12.418     0.200
     0.080     2.354     0.200
     0.135     3.344     0.200
     0.133     3.793     0.200
     0.188     4.463     0.200
     0.198     4.613     0.200
     0.200     4.463     0.200
     0.237     4.922     0.200
     0.346     6.703     0.200
     0.328     7.732     0.200
     0.325     6.922     0.200
     0.325     6.893     0.200
     0.332     7.184     0.200
     0.345     7.172     0.200
     0.368     7.572     0.200
     0.352     6.863     0.200
     0.373     7.492     0.200
     0.365     7.283     0.200
     0.445     9.332     0.200
     0.451     8.203     0.200
     0.419     7.854     0.200
     0.477     9.514     0.200
     0.462     9.543     0.200
     0.506     9.412     0.200
     0.477     9.572     0.200
     0.464     8.863     0.200
     0.529     9.582     0.200
     0.522    10.742     0.200
     0.614    12.402     0.200
     0.575    10.543     0.200
     0.661    13.033     0.200
     0.637    12.133     0.200
     0.695    12.463     0.200
     0.714    13.303     0.200
     0.708    13.752     0.200
     0.705    12.383     0.200
     0.772    13.893     0.200
     0.788    13.953     0.200
     0.755    14.633     0.200
     0.848    14.822     0.200
     0.946    18.223     0.200
     1.029    19.893     0.200
     1.097    20.672     0.200
     1.098    20.492     0.200
     1.086    20.773     0.200
     1.492    27.143     0.200
     2.159    37.572     0.200
     2.582    42.633     0.200
     0.081     2.561     0.200
     0.141     4.039     0.200
     0.146     3.141     0.200
     0.200     4.551     0.200
     0.213     4.680     0.200
     0.193     4.641     0.200
     0.251     5.080     0.200
     0.339     7.721     0.200
     0.341     6.789     0.200
     0.341     6.260     0.200
     0.382     7.840     0.200
     0.366     7.080     0.200
     0.388     7.439     0.200
     0.380     7.279     0.200
     0.318     6.949     0.200
     0.318     7.160     0.200
     0.325     7.330     0.200
     0.339     7.430     0.200
     0.452     9.510     0.200
     0.433     8.061     0.200
     0.477     9.699     0.200
     0.490     9.529     0.200
     0.436     8.359     0.200
     0.478     9.029     0.200
     0.499     9.490     0.200
     0.536    10.869     0.200
     0.516     9.699     0.200
     0.516    10.539     0.200
     0.589    10.820     0.200
     0.612    12.270     0.200
     0.682    13.230     0.200
     0.697    14.020     0.200
     0.647    13.061     0.200
     0.716    13.080     0.200
     0.684    12.279     0.200
     0.717    12.660     0.200
     0.697    13.840     0.200
     0.778    15.750     0.200
     0.776    14.250     0.200
     0.859    15.830     0.200
     1.036    19.750     0.200
     1.106    21.000     0.200
     1.112    21.020     0.200
     1.096    20.260     0.200
     1.114    19.869     0.200
     1.216    21.289     0.200
     1.378    25.959     0.200
     1.399    23.529     0.200
     1.480    25.760     0.200
     1.584    27.410     0.200
     1.652    29.289     0.200
     2.131    36.619     0.200
     2.149    38.350     0.200
     2.572    43.500     0.200
     0.081     2.969     0.200
     0.148     3.109     0.200
     0.197     4.559     0.200
     0.209     4.738     0.200
     0.248     5.148     0.200
     0.342     6.859     0.200
     0.344     6.359     0.200
     0.319     7.098     0.200
     0.320     7.219     0.200
     0.337     7.891     0.200
     0.327     7.340     0.200
     0.340     7.449     0.200
     0.363     7.379     0.200
     0.363     7.109     0.200
     0.378     7.891     0.200
     0.376     7.348     0.200
     0.384     7.707     0.200
     0.440     8.410     0.200
     0.430     8.078     0.200
     0.477     9.777     0.200
     0.469    10.160     0.200
     0.473     9.980     0.200
     0.501     9.500     0.200
     0.486     9.820     0.200
     0.474     9.109     0.200
     0.519     9.738     0.200
     0.533    10.730     0.200
     0.585    10.570     0.200
     0.615    12.391     0.200
     0.629    11.578     0.200
     0.693    13.898     0.200
     0.781    15.098     0.200
     0.793    15.039     0.200
     0.875    17.328     0.200
     0.042     2.004     0.200
     0.082     2.574     0.200
     0.089     2.615     0.200
     0.090     2.455     0.200
     0.113     2.693     0.200
     0.135     3.443     0.200
     0.164     3.555     0.200
     0.169     4.014     0.200
     0.210     4.693     0.200
     0.250     5.434     0.200
     0.260     4.914     0.200
     0.261     5.494     0.200
     0.314     5.865     0.200
     0.312     6.484     0.200
     0.312     7.234     0.200
     0.321     7.314     0.200
     0.341     6.334     0.200
     0.359     6.693     0.200
     0.359     6.385     0.200
     0.354     7.004     0.200
     0.387     7.504     0.200
     0.406     7.754     0.200
     0.437     8.205     0.200
     0.543    10.295     0.200
     0.580    11.354     0.200
     0.587    10.115     0.200
     0.597    10.584     0.200
     0.595    11.514     0.200
     0.635    11.984     0.200
     0.643    12.705     0.200
     0.648    11.844     0.200
     0.111     4.626     0.200
     0.186     5.256     0.200
     0.203     5.616     0.200
     0.209     5.376     0.200
     0.242     5.706     0.200
     0.253     6.437     0.200
     0.306     6.727     0.200
     0.371     7.806     0.200
     0.384     8.176     0.200
     0.415     8.517     0.200
     0.384     8.477     0.200
     0.441     8.866     0.200
     0.473     9.386     0.200
     0.484    10.116     0.200
     0.554    10.977     0.200
     0.574    11.756     0.200
     0.649    12.386     0.200
     0.650    13.296     0.200
     0.672    12.646     0.200
     0.677    12.517     0.200
     0.681    12.937     0.200
     0.722    13.426     0.200
     0.746    13.586     0.200
     0.764    14.346     0.200
     0.803    14.176     0.200
     0.798    15.006     0.200
     0.839    15.506     0.200
     0.864    15.206     0.200
     0.887    15.556     0.200
     0.869    15.596     0.200
     0.888    15.656     0.200
     0.873    16.267     0.200
     0.888    16.026     0.200
     0.887    16.586     0.200
     0.902    16.096     0.200
     0.911    17.106     0.200
     0.948    17.017     0.200
     0.952    16.846     0.200
     0.948    16.716     0.200
     0.943    17.806     0.200
     0.972    16.996     0.200
     0.955    17.176     0.200
     0.962    17.426     0.200
     0.992    17.406     0.200
     1.010    17.656     0.200
     1.145    19.896     0.200
     1.593    27.196     0.200
     4.400    74.524     0.200
     0.030     2.047     0.200
     0.115     2.227     0.200
     0.183     4.517     0.200
     0.180     4.227     0.200
     0.195     3.637     0.200
     0.228     4.327     0.200
     0.221     5.767     0.200
     0.254     5.656     0.200
     0.338     6.527     0.200
     0.332     6.967     0.200
     0.353     6.447     0.200
     0.415     7.777     0.200
     0.383     8.917     0.200
     0.417     7.517     0.200
     0.458     9.037     0.200
     0.453     8.837     0.200
     0.450     9.427     0.200
     0.468     9.257     0.200
     0.471     9.347     0.200
     0.514     9.557     0.200
     0.518    10.037     0.200
     0.509    10.287     0.200
     0.545    10.107     0.200
     0.512     9.947     0.200
     0.544    10.377     0.200
     0.555    10.077     0.200
     0.566    10.857     0.200
     0.586    11.187     0.200
     0.569    11.127     0.200
     0.591    10.837     0.200
     0.587    10.857     0.200
     0.600    11.187     0.200
     0.605    11.087     0.200
     0.608    11.137     0.200
     0.659    12.377     0.200
     0.722    13.717     0.200
     0.746    13.967     0.200
     0.768    13.807     0.200
     0.748    12.287     0.200
     0.752    13.677     0.200
     0.804    14.137     0.200
     0.783    14.327     0.200
     0.816    15.597     0.200
     0.866    15.697     0.200
     0.861    16.497     0.200
     0.862    14.997     0.200
     0.845    15.347     0.200
     0.893    17.287     0.200
     0.869    16.477     0.200
     0.883    16.406     0.200
     0.936    16.077     0.200
     0.925    17.267     0.200
     0.942    17.927     0.200
     0.957    17.527     0.200
     0.982    18.277     0.200
     1.002    17.837     0.200
     1.087    19.937     0.200
     1.057    19.947     0.200
     1.057    19.027     0.200
     1.114    19.656     0.200
     1.120    20.257     0.200
     1.157    19.997     0.200
     1.156    20.927     0.200
     1.197    21.357     0.200
     1.211    22.707     0.200
     1.185    21.487     0.200
     1.298    22.467     0.200
     1.358    24.057     0.200
     1.349    25.677     0.200
     1.384    24.617     0.200
     1.399    25.057     0.200
     1.402    24.877     0.200
     1.961    34.587     0.200
     2.036    36.327     0.200
     2.152    38.097     0.200
     2.244    38.707     0.200
     2.359    41.607     0.200
     2.674    45.317     0.200
     0.070     3.773     0.200
     0.213     5.078     0.200
     0.225     5.242     0.200
     0.230     5.344     0.200
     0.234     5.250     0.200
     0.290     6.719     0.200
     0.314     6.547     0.200
     0.322     6.594     0.200
     0.324     5.789     0.200
     0.330     6.906     0.200
     0.337     6.898     0.200
     0.352     6.680     0.200
     0.370     7.133     0.200
     0.364     7.320     0.200
     0.416     8.156     0.200
     0.411     8.539     0.200
     0.435     8.039     0.200
     0.446     8.258     0.200
     0.462     8.938     0.200
     0.459     9.148     0.200
     0.485     8.922     0.200
     0.481     9.547     0.200
     0.515     9.227     0.200
     0.531     9.359     0.200
     0.524     9.539     0.200
     0.534     9.430     0.200
     0.535     8.898     0.200
     0.536    10.969     0.200
     0.570    10.453     0.200
     0.563    11.047     0.200
     0.580    10.172     0.200
     0.570    10.773     0.200
     0.600    10.906     0.200
     0.604    10.680     0.200
     0.619    10.711     0.200
     0.611    11.492     0.200
     0.658    11.781     0.200
     0.650    11.711     0.200
     0.659    11.633     0.200
     0.653    11.641     0.200
     0.654    11.930     0.200
     0.660    11.844     0.200
     0.664    12.531     0.200
     0.679    13.031     0.200
     0.710    12.727     0.200
     0.706    12.492     0.200
     0.698    12.469     0.200
     0.749    12.906     0.200
     0.755    13.219     0.200
     0.771    14.148     0.200
     0.780    14.430     0.200
     0.819    14.969     0.200
     0.821    14.242     0.200
     0.825    14.508     0.200
     0.829    14.844     0.200
     0.827    15.094     0.200
     0.830    15.406     0.200
     0.838    15.359     0.200
     0.856    14.680     0.200
     0.856    15.711     0.200
     1.355    23.156     0.200
     1.355    23.047     0.200
     2.664    45.352     0.200
     2.791    48.156     0.200
     4.116    68.141     0.200
     0.109     2.945     0.200
     0.135     3.055     0.200
     0.170     4.133     0.200
     0.170     3.828     0.200
     0.209     4.508     0.200
     0.241     5.133     0.200
     0.310     7.484     0.200
     0.344     6.305     0.200
     0.383     7.008     0.200
     0.406     6.984     0.200
     0.442     9.438     0.200
     0.448     7.586     0.200
     0.474     8.625     0.200
     0.475     8.094     0.200
     0.495     9.125     0.200
     0.497     8.398     0.200
     0.527    10.289     0.200
     0.538    10.406     0.200
     0.576    11.008     0.200
     0.588    10.383     0.200
     0.634    12.453     0.200
     0.676    12.484     0.200
     0.662    11.773     0.200
     0.673    12.078     0.200
     0.706    13.078     0.200
     0.741    13.398     0.200
     0.817    14.875     0.200
     0.827    15.195     0.200
     0.838    14.867     0.200
     0.838    16.898     0.200
     0.859    16.234     0.200
     0.856    16.664     0.200
     0.862    16.375     0.200
     0.864    14.688     0.200
     0.922    16.383     0.200
     0.933    16.547     0.200
     0.995    17.297     0.200
     1.021    17.578     0.200
     1.013    18.406     0.200
     1.032    17.766     0.200
     1.075    17.906     0.200
     1.205    22.375     0.200
     1.226    22.062     0.200
     1.213    22.625     0.200
     1.218    22.195     0.200
     1.332    24.188     0.200
     1.404    25.266     0.200
     0.102     3.164     0.200
     0.234     4.672     0.200
     0.296     6.070     0.200
     0.331     6.742     0.200
     0.340     6.273     0.200
     0.364     7.195     0.200
     0.404     7.844     0.200
     0.404     7.875     0.200
     0.409     7.961     0.200
     0.405     7.570     0.200
     0.424     7.938     0.200
     0.424     7.945     0.200
     0.462     8.523     0.200
     0.484     8.742     0.200
     0.500     9.344     0.200
     0.503     9.312     0.200
     0.509     9.281     0.200
     0.523     9.547     0.200
     0.550    10.414     0.200
     0.576    10.523     0.200
     0.588    10.797     0.200
     0.658    11.391     0.200
     0.691    11.711     0.200
     0.688    12.273     0.200
     0.708    13.297     0.200
     0.703    12.422     0.200
     0.712    12.594     0.200
     0.761    13.445     0.200
     0.772    13.602     0.200
     0.782    14.531     0.200
     0.841    13.914     0.200
     0.848    14.984     0.200
     0.860    15.414     0.200
     0.870    15.273     0.200
     0.907    17.867     0.200
     0.929    18.266     0.200
     0.931    18.391     0.200
     0.934    18.547     0.200
     0.942    18.516     0.200
     0.945    17.344     0.200
     0.946    18.297     0.200
     0.952    18.094     0.200
     0.967    16.312     0.200
     0.957    18.375     0.200
     0.967    16.406     0.200
     0.980    16.977     0.200
     0.991    17.547     0.200
     0.996    16.555     0.200
     1.000    18.891     0.200
     1.010    18.836     0.200
     1.008    16.844     0.200
     1.000    16.938     0.200
     1.017    16.547     0.200
     1.042    19.172     0.200
     1.048    18.383     0.200
     1.041    18.992     0.200
     1.045    18.992     0.200
     1.117    20.656     0.200
     0.169     4.828     0.200
     0.233     5.523     0.200
     0.226     5.625     0.200
     0.237     5.305     0.200
     0.242     5.633     0.200
     0.270     5.977     0.200
     0.262     5.633     0.200
     0.310     6.812     0.200
     0.339     7.047     0.200
     0.353     6.766     0.200
     0.397     7.734     0.200
     0.406     7.922     0.200
     0.413     7.812     0.200
     0.461     9.508     0.200
     0.499     9.086     0.200
     0.513     9.734     0.200
     0.518     9.523     0.200
     0.537     9.867     0.200
     0.533    10.055     0.200
     0.576    10.961     0.200
     0.581    11.242     0.200
     0.592    10.758     0.200
     0.607    12.664     0.200
     0.609    11.484     0.200
     0.632    11.133     0.200
     0.646    11.266     0.200
     0.654    11.492     0.200
     0.671    12.164     0.200
     0.678    11.922     0.200
     0.678    11.758     0.200
     0.679    13.094     0.200
     0.686    12.062     0.200
     0.692    11.945     0.200
     0.705    12.336     0.200
     0.705    12.336     0.200
     0.706    12.344     0.200
     0.711    12.602     0.200
     0.712    13.352     0.200
     0.727    12.695     0.200
     0.729    12.617     0.200
     0.735    13.484     0.200
     0.757    13.766     0.200
     0.776    13.555     0.200
     0.770    13.727     0.200
     0.780    13.344     0.200
     0.788    13.781     0.200
     0.803    14.078     0.200
     0.803    14.945     0.200
     0.803    13.883     0.200
     0.800    14.211     0.200
     0.819    13.953     0.200
     0.819    14.461     0.200
     0.834    14.297     0.200
     0.855    15.125     0.200
     0.849    15.344     0.200
     0.850    14.867     0.200
     0.857    14.656     0.200
     0.858    15.828     0.200
     0.859    15.797     0.200
     0.879    15.328     0.200
     0.873    15.984     0.200
     0.879    15.711     0.200
     0.921    16.578     0.200
     0.932    16.844     0.200
     0.937    17.836     0.200
     0.949    17.008     0.200
     0.950    16.344     0.200
     0.965    16.781     0.200
     0.996    17.516     0.200
     1.000    17.664     0.200
     1.018    17.266     0.200
     1.022    17.391     0.200
     1.014    18.352     0.200
     1.032    17.484     0.200
     1.027    18.906     0.200
     1.050    19.547     0.200
     1.073    18.805     0.200
     1.077    19.242     0.200
     1.084    19.656     0.200
     1.088    19.211     0.200
     1.089    18.953     0.200
     1.116    20.141     0.200
     1.144    19.281     0.200
     1.144    20.891     0.200
     1.149    20.383     0.200
     1.179    19.992     0.200
     1.179    19.852     0.200
     1.188    21.117     0.200
     1.195    20.781     0.200
     1.200    21.023     0.200
     1.252    21.484     0.200
     1.268    22.023     0.200
     1.260    22.477     0.200
     1.282    23.266     0.200
     1.289    21.672     0.200
     1.282    22.008     0.200
     1.288    23.156     0.200
     1.288    22.906     0.200
     1.291    22.422     0.200
     1.302    22.812     0.200
     1.311    22.242     0.200
     1.311    23.594     0.200
     1.322    24.062     0.200
     1.346    23.812     0.200
     1.382    23.211     0.200
     1.375    24.875     0.200
     1.394    23.391     0.200
     1.440    24.461     0.200
     1.453    24.945     0.200
     1.492    24.945     0.200
     1.542    26.086     0.200
     1.652    27.555     0.200
     1.652    27.781     0.200
     0.076     2.790     0.200
     0.076     2.920     0.200
     0.049     2.790     0.200
     0.094     3.350     0.200
     0.177     4.820     0.200
     0.231     5.260     0.200
     0.233     5.350     0.200
     0.240     5.670     0.200
     0.240     5.960     0.200
     0.317     6.740     0.200
     0.317     7.640     0.200
     0.345     7.690     0.200
     0.363     7.580     0.200
     0.412     8.430     0.200
     0.445     9.080     0.200
     0.474     9.200     0.200
     0.491     9.380     0.200
     0.515     9.420     0.200
     0.509    10.430     0.200
     0.551    10.180     0.200
     0.544    10.390     0.200
     0.568    10.520     0.200
     0.568    11.040     0.200
     0.567    10.210     0.200
     0.580    10.390     0.200
     0.570    10.690     0.200
     0.601    10.760     0.200
     0.605    11.640     0.200
     0.605    11.780     0.200
     0.625    11.560     0.200
     0.626    12.200     0.200
     0.664    11.860     0.200
     0.664    11.640     0.200
     0.664    12.210     0.200
     0.671    12.030     0.200
     0.675    11.880     0.200
     0.660    13.620     0.200
     0.667    12.360     0.200
     0.737    13.180     0.200
     0.737    13.030     0.200
     0.742    13.120     0.200
     0.706    13.560     0.200
     0.746    13.260     0.200
     0.750    13.370     0.200
     0.772    13.550     0.200
     0.784    14.270     0.200
     0.784    14.540     0.200
     0.793    14.200     0.200
     0.793    14.860     0.200
     0.789    14.540     0.200
     0.809    14.650     0.200
     0.826    14.840     0.200
     0.855    15.280     0.200
     0.866    15.130     0.200
     0.848    15.600     0.200
     0.899    15.740     0.200
     0.895    15.950     0.200
     0.927    15.900     0.200
     0.947    16.630     0.200
     0.905    17.010     0.200
     0.906    17.860     0.200
     0.915    16.450     0.200
     0.939    16.700     0.200
     0.971    16.880     0.200
     0.965    17.880     0.200
     0.981    16.800     0.200
     0.981    17.000     0.200
     0.996    17.350     0.200
     1.005    18.400     0.200
     1.000    18.050     0.200
     1.010    18.600     0.200
     1.010    18.950     0.200
     1.028    18.630     0.200
     1.041    18.570     0.200
     1.048    19.840     0.200
     1.058    20.610     0.200
     1.058    20.820     0.200
     1.058    20.030     0.200
     1.070    18.510     0.200
     1.070    18.740     0.200
     1.107    19.020     0.200
     1.107    19.150     0.200
     1.081    20.730     0.200
     1.144    19.600     0.200
     1.106    20.610     0.200
     1.119    19.780     0.200
     1.158    19.580     0.200
     1.158    19.950     0.200
     1.205    22.320     0.200
     1.206    21.090     0.200
     1.170    20.350     0.200
     1.170    20.530     0.200
     1.226    20.870     0.200
     1.226    21.000     0.200
     1.186    21.330     0.200
     1.193    21.200     0.200
     1.210    21.280     0.200
     1.233    21.210     0.200
     1.233    21.320     0.200
     1.233    22.290     0.200
     1.233    23.460     0.200
     1.248    23.180     0.200
     1.290    22.080     0.200
     1.263    23.519     0.200
     1.306    23.210     0.200
     1.306    23.640     0.200
     1.310    23.330     0.200
     1.310    24.830     0.200
     1.321    24.280     0.200
     1.321    24.440     0.200
     1.350    25.430     0.200
     1.371    23.140     0.200
     1.371    24.080     0.200
     1.348    24.350     0.200
     1.388    23.510     0.200
     1.408    25.620     0.200
     1.400    24.640     0.200
     1.380    25.040     0.200
     1.378    23.800     0.200
     1.378    24.330     0.200
     1.408    23.820     0.200
     1.427    25.660     0.200
     1.427    26.160     0.200
     1.461    24.790     0.200
     1.461    25.780     0.200
     1.497    26.040     0.200
     1.549    28.210     0.200
     1.556    27.300     0.200
     1.562    26.440     0.200
     1.558    26.430     0.200
     1.558    28.270     0.200
     1.577    26.460     0.200
     1.534    27.850     0.200
     1.535    27.440     0.200
     1.590    27.010     0.200
     1.545    27.810     0.200
     1.639    27.880     0.200
     1.760    30.030     0.200
     1.784    30.270     0.200
     1.812    30.460     0.200
     1.899    32.160     0.200
     1.899    32.840     0.200
     1.956    33.690     0.200
     1.959    34.980     0.200
     1.959    35.030     0.200
     1.976    34.120     0.200
     1.976    34.270     0.200
     1.985    34.480     0.200
     1.958    33.200     0.200
     1.958    33.328     0.200
     2.012    34.840     0.200
     1.970    34.310     0.200
     1.970    33.650     0.200
     1.970    33.980     0.200
     2.033    36.280     0.200
     2.059    35.690     0.200
     2.071    34.990     0.200
     2.130    37.500     0.200
     2.134    36.330     0.200
     2.134    36.840     0.200
     2.130    36.360     0.200
     2.130    37.200     0.200
     2.134    36.170     0.200
     2.189    37.030     0.200
     2.189    37.200     0.200
     2.143    36.470     0.200
     2.134    36.650     0.200
     2.134    37.150     0.200
     2.222    37.810     0.200
     2.263    38.510     0.200
     2.217    37.130     0.200
     2.217    37.310     0.200
     2.235    38.050     0.200
     2.235    38.300     0.200
     2.285    39.260     0.200
     2.242    38.460     0.200
     2.242    39.240     0.200
     2.251    38.220     0.200
     2.256    38.040     0.200
     2.309    38.860     0.200
     2.309    39.000     0.200
     2.307    39.150     0.200
     2.344    39.970     0.200
     2.300    38.350     0.200
     2.303    39.750     0.200
     2.294    38.410     0.200
     2.294    38.720     0.200
     2.371    40.400     0.200
     2.374    39.730     0.200
     2.374    39.920     0.200
     2.387    40.780     0.200
     2.387    41.350     0.200
     2.392    40.470     0.200
     2.420    40.590     0.200
     2.420    40.790     0.200
     2.425    40.420     0.200
     2.414    41.230     0.200
     2.414    41.420     0.200
     2.423    41.500     0.200
     2.433    41.540     0.200
     2.433    41.980     0.200
     2.436    42.110     0.200
     2.436    42.690     0.200
     2.449    41.210     0.200
     2.440    41.600     0.200
     2.496    42.280     0.200
     2.548    42.970     0.200
     2.553    43.080     0.200
     2.559    43.930     0.200
     2.559    44.420     0.200
     2.582    43.140     0.200
     2.612    43.200     0.200
     2.612    44.110     0.200
     2.601    44.280     0.200
     2.654    44.690     0.200
     2.654    44.950     0.200
     2.717    45.800     0.200
     2.728    46.200     0.200
     2.794    46.090     0.200
     2.773    46.400     0.200
     3.036    50.320     0.200
     3.118    51.440     0.200
     3.227    52.790     0.200
     3.316    54.610     0.200
     3.376    56.229     0.200
     3.376    55.290     0.200
     3.376    55.675     0.200
     3.402    56.670     0.200
     3.447    56.150     0.200
     3.426    55.391     0.200
     3.510    56.970     0.200
     3.494    56.490     0.200
     3.559    57.590     0.200
     3.604    58.200     0.200
     3.629    58.652     0.200
     3.711    59.990     0.200
     4.030    65.310     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     3.905   107.742     0.200
     4.020   107.441     0.200
     4.678   123.941     0.200
     4.749   127.340     0.200
     4.865   129.043     0.200
     4.933   131.043     0.200
     5.565   143.941     0.200
     6.748   175.941     0.200
     7.196   181.941     0.200
     8.074   201.941     0.200
     8.839   223.141     0.200
     8.872   225.941     0.200
     8.981   222.141     0.200
     9.113   229.941     0.200
     9.818   243.941     0.200
    10.284   258.941     0.200
     4.680   124.169     0.200
     4.797   127.169     0.200
     4.941   129.669     0.200
     5.111   131.869     0.200
     5.546   144.369     0.200
     8.080   206.869     0.200
     8.882   223.869     0.200
     8.910   224.369     0.200
     9.126   231.270     0.200
     9.244   231.669     0.200
     3.177    87.273     0.200
     4.002   105.273     0.200
     4.213   109.473     0.200
     4.952   124.973     0.200
     6.432   164.473     0.200
     7.099   177.473     0.200
     8.504   208.672     0.200
     8.843   216.074     0.200
     9.598   236.672     0.200
     9.805   239.371     0.200
     4.965   129.508     0.200
     5.085   133.805     0.200
     6.878   176.008     0.200
     7.020   181.008     0.200
     6.969   176.609     0.200
     7.109   181.406     0.200
     8.351   211.008     0.200
     8.449   212.406     0.200
     9.138   229.008     0.200
     9.275   230.406     0.200
     9.451   237.008     0.200
     9.571   238.711     0.200
    10.505   261.508     0.200
    11.877   294.906     0.200
     3.041    83.758     0.200
     3.300    93.055     0.200
     4.087   112.359     0.200
     4.670   124.258     0.200
     5.017   130.961     0.200
     5.197   135.258     0.200
     5.438   142.359     0.200
     5.885   148.758     0.200
     5.957   153.758     0.200
     7.059   180.258     0.200
     7.132   186.258     0.200
     8.395   213.258     0.200
     9.536   236.555     0.200
     9.661   239.555     0.200
    10.605   267.258     0.200
     8.184   201.039     0.200
     3.033    82.616     0.200
     3.597    99.616     0.200
     3.975   110.517     0.200
     4.241   110.616     0.200
     4.693   125.116     0.200
     5.010   132.017     0.200
     5.174   134.716     0.200
     5.241   134.616     0.200
     5.874   150.616     0.200
     7.057   181.216     0.200
     7.056   180.616     0.200
     7.273   184.616     0.200
     7.283   187.616     0.200
     7.456   193.616     0.200
     7.676   193.616     0.200
     8.391   212.616     0.200
     8.391   212.116     0.200
     9.170   229.616     0.200
     9.170   229.116     0.200
     9.326   233.716     0.200
     9.645   241.616     0.200
    10.027   255.116     0.200
    10.087   258.616     0.200
    10.566   263.816     0.200
    10.601   267.616     0.200
    20.013   500.616     0.200
    21.117   525.616     0.200
    22.087   545.616     0.200
     3.034    85.126     0.200
     4.921   131.826     0.200
     4.979   130.726     0.200
     5.833   149.626     0.200
     7.030   182.626     0.200
     8.363   212.626     0.200
     9.147   229.626     0.200
     9.597   240.826     0.200
     1.998    57.238     0.200
     3.821   104.039     0.200
     4.193   112.238     0.200
     4.880   128.738     0.200
     4.919   127.238     0.200
     4.923   131.738     0.200
     4.927   132.738     0.200
     5.178   133.637     0.200
     5.729   146.738     0.200
     5.766   150.738     0.200
     6.993   179.238     0.200
     8.318   211.238     0.200
     9.455   236.738     0.200
    10.057   251.238     0.200
     1.945    56.746     0.200
     3.056    84.746     0.200
     4.663   123.246     0.200
     4.806   126.246     0.200
     4.843   126.145     0.200
     4.876   131.746     0.200
     4.930   132.746     0.200
     5.104   132.645     0.200
     5.693   150.246     0.200
     6.919   179.746     0.200
     8.243   211.746     0.200
     8.243   211.445     0.200
     9.385   236.547     0.200
     9.981   247.746     0.200
    10.453   263.746     0.200
     0.930    33.250     0.200
     2.410    68.750     0.200
     3.127    85.250     0.200
     3.761   103.250     0.200
     3.950   105.250     0.200
     4.007   108.547     0.200
     4.811   129.750     0.200
     5.105   134.250     0.200
     5.725   147.750     0.200
     5.793   152.750     0.200
     6.921   179.750     0.200
     9.038   229.750     0.200
     9.070   231.250     0.200
     3.037    84.750     0.200
     4.945   129.150     0.200
     4.784   126.250     0.200
     5.187   134.750     0.200
     5.789   148.250     0.200
     6.866   174.250     0.200
     7.003   178.250     0.200
     8.334   210.250     0.200
     9.122   228.250     0.200
     9.254   230.850     0.200
    10.544   305.250     0.200
     0.981    34.727     0.200
     1.215    41.227     0.200
     2.844    80.027     0.200
     3.904   108.227     0.200
     3.965   107.027     0.200
     4.140   115.527     0.200
     4.689   125.426     0.200
     4.901   128.027     0.200
     5.132   135.727     0.200
     5.767   147.727     0.200
     6.793   175.227     0.200
     6.947   180.227     0.200
     7.613   201.227     0.200
     8.282   209.227     0.200
    10.044   250.227     0.200
     1.464    45.133     0.200
     1.780    55.133     0.200
     3.449    95.133     0.200
     3.732   103.133     0.200
     4.116   110.633     0.200
     4.352   119.133     0.200
     4.713   125.832     0.200
     4.852   127.133     0.200
     4.852   132.633     0.200
     4.965   130.133     0.200
     5.425   140.633     0.200
     5.545   142.934     0.200
     5.602   146.133     0.200
     6.674   170.133     0.200
     6.674   173.133     0.200
     8.108   206.133     0.200
     8.904   226.133     0.200
     1.112    37.264     0.200
     2.402    63.664     0.200
     2.695    74.164     0.200
     2.996    83.764     0.200
     5.052   130.764     0.200
     5.282   136.264     0.200
     8.432   213.764     0.200
     9.211   229.764     0.200
     9.211   229.264     0.200
     1.501    49.372     0.200
     4.711   127.772     0.200
     4.913   132.072     0.200
     5.576   148.872     0.200
     6.785   177.372     0.200
     8.110   208.372     0.200
     3.071    85.742     0.200
     3.523    94.242     0.200
     3.982   111.039     0.200
     4.088   111.242     0.200
     4.188   109.242     0.200
     4.703   125.242     0.200
     4.703   129.242     0.200
     4.957   128.344     0.200
     5.133   134.445     0.200
     5.189   135.641     0.200
     5.890   159.242     0.200
     7.004   181.242     0.200
     7.221   186.242     0.200
     7.242   186.242     0.200
     7.395   192.242     0.200
     7.409   189.242     0.200
     8.338   211.242     0.200
     9.119   229.242     0.200
     9.119   228.742     0.200
     9.591   239.539     0.200
    10.100   252.242     0.200
     2.723    76.184     0.200
     3.560    96.784     0.200
     3.723   102.984     0.200
     3.982   110.184     0.200
     4.185   115.984     0.200
     4.203   109.584     0.200
     4.360   117.084     0.200
     4.959   128.984     0.200
     5.014   129.584     0.200
     5.253   134.084     0.200
     5.916   153.584     0.200
     7.068   181.584     0.200
     7.323   188.584     0.200
     7.483   188.584     0.200
     8.400   211.584     0.200
     8.400   211.984     0.200
     9.798   248.784     0.200
    10.611   268.584     0.200
     1.070    35.957     0.200
     3.423    92.357     0.200
     4.208   110.957     0.200
     4.196   113.957     0.200
     5.047   129.156     0.200
     5.289   134.957     0.200
     7.104   181.457     0.200
     8.435   210.457     0.200
     3.770   102.617     0.200
     3.825   106.918     0.200
     3.983   111.020     0.200
     4.107   112.020     0.200
     4.414   122.320     0.200
     4.491   122.520     0.200
     4.700   126.219     0.200
     5.071   134.520     0.200
     5.512   144.719     0.200
     6.065   159.918     0.200
     6.348   164.617     0.200
     6.736   174.719     0.200
     6.854   177.719     0.200
     6.881   177.719     0.200
     7.652   194.117     0.200
     7.892   202.719     0.200
     8.192   209.719     0.200
     8.192   210.117     0.200
     8.252   210.719     0.200
     9.018   229.719     0.200
     9.018   229.219     0.200
     9.040   226.418     0.200
    11.867   303.719     0.200
     2.283    66.547     0.200
     2.659    75.547     0.200
     3.362    94.047     0.200
     3.679    98.047     0.200
     3.745   100.250     0.200
     3.745   103.047     0.200
     3.874   104.844     0.200
     4.157   112.750     0.200
     4.286   115.547     0.200
     4.302   116.250     0.200
     4.414   118.648     0.200
     4.638   123.750     0.200
     4.842   133.547     0.200
     5.315   141.844     0.200
     5.494   146.148     0.200
     5.489   144.445     0.200
     6.038   156.344     0.200
     6.427   169.047     0.200
     6.470   168.648     0.200
     6.646   172.148     0.200
     6.646   172.648     0.200
     6.780   176.047     0.200
     6.780   176.250     0.200
     7.060   184.047     0.200
     8.203   206.148     0.200
     8.360   213.047     0.200
     8.425   212.648     0.200
     8.536   213.047     0.200
     1.038    35.035     0.200
     1.170    38.535     0.200
     2.823    77.535     0.200
     3.006    82.637     0.200
     3.036    81.535     0.200
     3.240    89.934     0.200
     3.476    97.035     0.200
     3.623    96.137     0.200
     4.168   111.934     0.200
     4.206   111.734     0.200
     4.320   113.637     0.200
     4.485   118.734     0.200
     4.593   119.734     0.200
     4.989   128.637     0.200
     5.333   135.535     0.200
     5.273   135.434     0.200
     5.519   145.035     0.200
     5.556   141.535     0.200
     5.706   148.535     0.200
     5.706   150.836     0.200
     5.724   147.637     0.200
     5.910   149.535     0.200
     6.291   162.535     0.200
     6.627   167.535     0.200
     6.716   165.836     0.200
     7.640   191.535     0.200
     7.634   189.535     0.200
     8.380   210.535     0.200
     9.257   227.535     0.200
     9.959   246.336     0.200
    10.028   246.734     0.200
    10.234   251.535     0.200
    11.506   287.234     0.200
     3.213    91.557     0.200
     3.381    93.557     0.200
     3.422    93.557     0.200
     3.667   102.557     0.200
     3.760   103.557     0.200
     3.888   107.057     0.200
     4.118   108.656     0.200
     4.128   112.457     0.200
     4.302   119.557     0.200
     4.319   120.057     0.200
     5.328   141.557     0.200
     5.513   145.156     0.200
     5.979   148.557     0.200
     6.316   163.557     0.200
     6.633   171.557     0.200
     7.540   191.557     0.200
     8.381   210.557     0.200
     2.624    72.084     0.200
     2.957    78.084     0.200
     3.867   100.084     0.200
     4.156   105.984     0.200
     4.233   109.885     0.200
     4.841   126.084     0.200
     5.343   137.184     0.200
     5.970   152.184     0.200
     5.943   155.084     0.200
     6.214   157.684     0.200
     6.256   153.783     0.200
     6.305   164.084     0.200
     7.309   183.084     0.200
     7.553   189.184     0.200
     8.082   201.084     0.200
     8.278   206.084     0.200
     8.625   212.584     0.200
     8.800   216.484     0.200
     9.494   233.084     0.200
     9.563   236.084     0.200
     9.769   239.885     0.200
     9.884   242.283     0.200
    10.083   248.084     0.200
     3.631    97.969     0.200
     3.664    98.469     0.200
     4.049   108.367     0.200
     4.131   111.469     0.200
     4.557   120.469     0.200
     4.596   121.766     0.200
     4.610   117.570     0.200
     4.899   126.672     0.200
     4.918   127.570     0.200
     8.023   203.469     0.200
     8.845   221.469     0.200
     1.616    50.047     0.200
     3.457    95.047     0.200
     3.481    93.047     0.200
     4.053   108.047     0.200
     4.341   113.945     0.200
     4.480   118.547     0.200
     5.095   131.547     0.200
     5.533   145.844     0.200
     5.909   149.047     0.200
     6.154   157.445     0.200
     6.438   161.250     0.200
     7.494   188.945     0.200
     8.261   161.047     0.200
     8.261   206.047     0.200
     8.471   209.047     0.200
     8.814   216.047     0.200
     8.985   220.750     0.200
     9.280   230.047     0.200
     9.734   240.547     0.200
     9.942   244.547     0.200
    10.233   255.445     0.200
    11.247   281.148     0.200
     2.384    66.570     0.200
     3.283    89.570     0.200
     3.732   103.070     0.200
     3.833   103.172     0.200
     3.920   106.070     0.200
     4.084   111.570     0.200
     4.176   115.070     0.200
     4.380   115.969     0.200
     4.392   116.570     0.200
     4.374   119.570     0.200
     4.386   119.570     0.200
     4.766   122.773     0.200
     5.046   129.070     0.200
     7.488   191.070     0.200
     0.922    29.852     0.200
     3.061    84.152     0.200
     3.231    88.254     0.200
     3.299    89.652     0.200
     3.444    93.652     0.200
     3.550    95.652     0.200
     3.579    97.152     0.200
     4.053   107.652     0.200
     4.180   109.051     0.200
     4.124   110.352     0.200
     4.177   110.953     0.200
     4.367   111.852     0.200
     4.923   126.453     0.200
     6.017   154.754     0.200
     6.518   167.953     0.200
     6.591   168.953     0.200
     8.027   200.152     0.200
     8.027   203.152     0.200
     8.841   221.352     0.200
     1.077    39.281     0.200
     1.494    49.281     0.200
     1.539    49.180     0.200
     1.722    55.281     0.200
     3.005    84.180     0.200
     3.195    89.281     0.200
     3.203    88.484     0.200
     3.459    94.078     0.200
     3.471    95.781     0.200
     3.545    96.984     0.200
     3.940   107.078     0.200
     4.006   109.578     0.200
     4.089   110.180     0.200
     4.116   110.781     0.200
     4.339   118.281     0.200
     4.523   121.781     0.200
     4.544   120.180     0.200
     4.757   128.961     0.200
     5.092   135.781     0.200
     5.124   134.805     0.200
     5.373   144.281     0.200
     5.636   150.984     0.200
     5.864   153.078     0.200
     6.108   160.039     0.200
     6.136   162.578     0.200
     6.136   165.883     0.200
     6.211   165.078     0.200
     7.649   197.781     0.200
     8.649   218.281     0.200
     8.771   222.078     0.200
     1.062    35.133     0.200
     1.292    39.633     0.200
     2.350    65.430     0.200
     2.907    78.930     0.200
     3.058    84.633     0.200
     3.416    94.133     0.200
     3.598    98.930     0.200
     3.611    99.031     0.200
     3.927   101.930     0.200
     3.997   102.930     0.200
     4.013   106.930     0.200
     4.047   105.328     0.200
     4.220   110.430     0.200
     4.286   112.133     0.200
     4.375   116.930     0.200
     4.645   120.430     0.200
     4.922   125.430     0.200
     5.985   156.430     0.200
     6.067   156.531     0.200
     6.062   154.227     0.200
     6.227   160.031     0.200
     7.074   177.633     0.200
     7.158   178.633     0.200
     7.370   184.930     0.200
     8.151   202.430     0.200
     8.457   209.633     0.200
     8.630   212.727     0.200
     8.796   216.727     0.200
     9.140   226.531     0.200
     9.463   233.133     0.200
     9.536   233.430     0.200
     9.745   239.531     0.200
     9.829   241.828     0.200
     9.857   242.227     0.200
    10.049   248.930     0.200
     1.510    47.869     0.200
     1.767    54.570     0.200
     2.041    60.570     0.200
     2.039    60.670     0.200
     3.926   106.969     0.200
     4.344   117.369     0.200
     4.511   120.570     0.200
     4.588   122.770     0.200
     5.367   139.670     0.200
     6.299   168.369     0.200
     7.368   187.670     0.200
     7.664   194.770     0.200
     8.766   219.469     0.200
     8.943   223.570     0.200
     9.105   227.270     0.200
    10.038   251.670     0.200
     3.846   102.539     0.200
     4.313   114.641     0.200
     4.336   114.641     0.200
     4.392   114.336     0.200
     4.551   118.438     0.200
     5.733   151.234     0.200
     6.326   166.438     0.200
     7.407   186.141     0.200
     7.703   193.438     0.200
     8.476   210.938     0.200
     8.778   218.039     0.200
     9.116   225.336     0.200
    10.040   250.641     0.200
     1.296    41.305     0.200
     1.533    47.203     0.200
     1.666    50.703     0.200
     2.159    61.703     0.200
     2.241    61.703     0.200
     2.536    70.602     0.200
     2.609    71.102     0.200
     3.152    84.500     0.200
     3.673    98.406     0.200
     3.739   100.500     0.200
     3.716    98.406     0.200
     4.360   113.703     0.200
     4.481   116.805     0.200
     4.472   116.203     0.200
     5.661   147.203     0.200
     6.249   162.000     0.200
     6.331   165.406     0.200
     6.365   165.203     0.200
     6.508   168.602     0.200
     7.217   181.602     0.200
     7.506   187.805     0.200
     7.514   187.203     0.200
     8.540   215.500     0.200
     9.895   241.703     0.200
    10.164   252.000     0.200
    10.283   250.305     0.200
    10.488   256.406     0.200
     2.257    61.355     0.200
     2.527    68.055     0.200
     2.598    69.855     0.200
     3.016    81.953     0.200
     3.141    83.855     0.200
     3.170    84.453     0.200
     3.663    98.453     0.200
     4.350   112.254     0.200
     4.462   115.953     0.200
     6.241   163.254     0.200
     6.324   163.555     0.200
     6.324   165.555     0.200
     7.207   181.855     0.200
     7.572   186.855     0.200
     8.973   221.453     0.200
     9.166   224.754     0.200
     9.895   242.055     0.200
     9.959   243.754     0.200
    10.163   248.152     0.200
    10.163   250.254     0.200
     2.190    61.605     0.200
     2.381    65.406     0.200
     2.409    67.707     0.200
     2.636    71.809     0.200
     2.668    73.406     0.200
     2.724    74.105     0.200
     3.162    86.105     0.200
     3.269    87.707     0.200
     3.305    88.906     0.200
     3.754    98.207     0.200
     3.837   101.008     0.200
     4.272   110.207     0.200
     4.464   114.406     0.200
     4.447   114.707     0.200
     4.548   117.207     0.200
     5.353   136.207     0.200
     5.448   138.605     0.200
     5.533   141.105     0.200
     6.552   164.605     0.200
     6.868   172.809     0.200
     7.146   179.605     0.200
     7.555   186.105     0.200
     7.575   186.605     0.200
     9.185   224.105     0.200
     9.880   241.605     0.200
     9.950   242.508     0.200
    10.272   251.508     0.200
     3.012    83.297     0.200
     3.009    84.898     0.200
     3.269    89.199     0.200
     3.282    91.398     0.200
     3.354    92.000     0.200
     3.756   103.297     0.200
     3.770   104.199     0.200
     3.898   105.699     0.200
     3.926   106.098     0.200
     3.945   109.297     0.200
     4.506   119.500     0.200
     4.484   120.898     0.200
     4.606   122.078     0.200
     4.524   121.598     0.200
     4.945   130.520     0.200
     5.681   148.957     0.200
     5.935   153.797     0.200
     6.027   155.957     0.200
     6.218   162.000     0.200
     6.158   165.898     0.200
     6.242   164.098     0.200
     6.241   166.398     0.200
     6.553   167.078     0.200
     7.622   194.898     0.200
     8.427   212.398     0.200
     8.719   217.898     0.200
     8.855   220.398     0.200
     9.741   241.797     0.200
     0.992    34.926     0.200
     3.833   104.926     0.200
     3.997   107.826     0.200
     4.060   109.926     0.200
     4.215   113.525     0.200
     4.411   117.025     0.200
     4.716   126.025     0.200
     4.722   125.926     0.200
     5.247   137.986     0.200
     5.808   152.125     0.200
     5.997   155.346     0.200
     6.213   161.986     0.200
     6.275   163.625     0.200
     6.341   165.525     0.200
     6.442   168.465     0.200
     6.483   170.625     0.200
     7.538   192.227     0.200
     7.830   200.426     0.200
     8.663   218.926     0.200
     9.529   237.926     0.200
     1.240    38.857     0.200
     2.125    60.057     0.200
     3.173    88.457     0.200
     3.676   100.756     0.200
     3.718   101.857     0.200
     3.778   103.256     0.200
     4.907   129.357     0.200
     4.920   125.957     0.200
     6.026   153.857     0.200
     6.596   167.756     0.200
     8.947   222.457     0.200
     9.323   229.557     0.200
     2.314    66.688     0.200
     2.246    64.086     0.200
     2.431    69.586     0.200
     2.601    73.289     0.200
     3.512    94.086     0.200
     3.625    98.086     0.200
     3.912   103.586     0.200
     4.125   110.586     0.200
     4.078   112.383     0.200
     4.333   115.289     0.200
     4.245   110.984     0.200
     4.397   117.383     0.200
     5.505   144.883     0.200
     6.021   153.383     0.200
     6.088   161.586     0.200
     6.170   161.883     0.200
     6.184   162.188     0.200
     6.328   165.688     0.200
     6.573   171.688     0.200
     6.934   184.086     0.200
     7.187   181.883     0.200
     7.511   189.086     0.200
     7.482   187.586     0.200
     7.482   191.586     0.200
     8.169   203.789     0.200
     8.265   206.789     0.200
     8.351   207.086     0.200
     8.355   212.984     0.200
     8.338   203.086     0.200
     8.500   212.789     0.200
     8.540   212.789     0.200
     8.719   215.883     0.200
     8.879   221.289     0.200
     9.250   230.586     0.200
     9.603   239.188     0.200
     9.700   241.688     0.200
     9.813   244.789     0.200
     9.892   247.383     0.200
     9.923   248.383     0.200
    10.108   253.484     0.200
    10.411   259.688     0.200
    11.052   273.086     0.200
     1.154    38.438     0.200
     1.457    45.641     0.200
     3.646    98.438     0.200
     4.159   110.844     0.200
     4.356   115.641     0.200
     4.415   116.641     0.200
     4.655   126.242     0.200
     5.522   144.641     0.200
     6.096   161.242     0.200
     6.190   162.039     0.200
     8.492   212.344     0.200
     8.532   212.844     0.200
     8.714   217.844     0.200
     8.870   222.039     0.200
     9.506   238.344     0.200
     9.796   245.539     0.200
     4.669   126.039     0.200
     4.698   125.141     0.200
     4.786   127.844     0.200
     5.097   136.641     0.200
     5.099   133.664     0.200
     6.073   157.664     0.200
     6.199   161.141     0.200
     6.332   167.141     0.200
     6.316   163.703     0.200
     6.320   165.539     0.200
     6.459   170.039     0.200
     6.476   170.539     0.200
     6.474   173.141     0.200
     6.579   170.062     0.200
     6.834   178.141     0.200
     7.481   192.938     0.200
     7.774   198.141     0.200
     8.503   215.539     0.200
     8.594   218.641     0.200
     8.642   216.844     0.200
     8.875   225.539     0.200
     9.029   233.344     0.200
     9.491   238.641     0.200
     4.015   109.562     0.200
     4.225   113.062     0.200
     4.321   119.156     0.200
     4.733   126.062     0.200
     5.438   138.961     0.200
     6.309   168.961     0.200
     6.293   164.562     0.200
     6.377   168.156     0.200
     6.502   173.461     0.200
     6.520   174.258     0.200
     6.543   170.062     0.200
     7.560   192.156     0.200
     8.512   215.961     0.200
     8.883   225.859     0.200
     3.970   108.789     0.200
     4.171   112.489     0.200
     4.378   118.789     0.200
     4.687   125.089     0.200
     4.706   124.789     0.200
     5.124   137.589     0.200
     5.117   133.669     0.200
     5.883   151.989     0.200
     6.087   157.429     0.200
     6.220   158.309     0.200
     6.289   168.589     0.200
     6.361   169.289     0.200
     6.347   165.789     0.200
     6.371   170.688     0.200
     6.326   165.709     0.200
     6.499   169.688     0.200
     6.500   174.089     0.200
     7.519   191.989     0.200
     7.812   199.589     0.200
     8.103   207.389     0.200
     8.521   214.089     0.200
     8.634   217.589     0.200
     8.676   217.989     0.200
     8.894   225.389     0.200
     9.729   246.688     0.200
     1.113    39.074     0.200
     1.182    40.874     0.200
     3.273    92.773     0.200
     3.456    97.174     0.200
     3.473    98.174     0.200
     3.735   103.974     0.200
     3.814   106.474     0.200
     4.199   114.674     0.200
     4.358   119.374     0.200
     4.383   119.474     0.200
     4.572   124.174     0.200
     4.577   120.174     0.200
     5.651   146.874     0.200
     6.066   158.874     0.200
     7.680   197.674     0.200
     1.585    46.578     0.200
     2.175    61.977     0.200
     2.389    67.375     0.200
     2.369    65.781     0.200
     2.651    73.680     0.200
     2.630    72.375     0.200
     2.712    74.180     0.200
     3.141    85.375     0.200
     3.256    87.977     0.200
     3.289    88.781     0.200
     3.720    99.281     0.200
     3.801   100.875     0.200
     4.112   111.680     0.200
     4.412   115.578     0.200
     4.514   117.578     0.200
     4.265   114.078     0.200
     5.534   142.180     0.200
     5.627   147.680     0.200
     6.220   161.281     0.200
     6.273   163.977     0.200
     6.355   165.781     0.200
     6.475   163.680     0.200
     6.549   165.375     0.200
     6.560   166.477     0.200
     6.620   161.180     0.200
     7.092   172.875     0.200
     7.208   181.680     0.200
     7.229   181.781     0.200
     7.537   187.875     0.200
     7.558   187.281     0.200
     7.567   190.578     0.200
     7.614   189.375     0.200
     7.704   198.875     0.200
     8.213   203.281     0.200
     8.254   208.281     0.200
     8.487   208.281     0.200
     8.496   210.375     0.200
     8.661   216.078     0.200
     8.779   216.477     0.200
     8.896   225.180     0.200
     8.942   224.578     0.200
     8.978   219.078     0.200
     9.161   224.281     0.200
     9.374   232.375     0.200
     9.862   242.875     0.200
    10.137   248.078     0.200
    10.228   253.680     0.200
    10.253   250.781     0.200
    10.761   265.375     0.200
    13.124   319.180     0.200
    13.412   327.477     0.200
    13.484   329.477     0.200
     2.136    60.355     0.200
     2.331    64.655     0.200
     2.348    65.855     0.200
     2.594    69.855     0.200
     2.610    71.155     0.200
     2.673    72.155     0.200
     3.100    83.655     0.200
     3.217    85.655     0.200
     3.249    87.456     0.200
     3.704    97.756     0.200
     4.086   110.256     0.200
     4.395   114.655     0.200
     4.500   116.556     0.200
     5.510   141.355     0.200
     6.201   158.655     0.200
     6.266   161.756     0.200
     6.348   165.556     0.200
     6.497   166.355     0.200
     6.523   171.256     0.200
     6.627   159.456     0.200
     7.046   174.756     0.200
     7.572   186.056     0.200
     7.550   189.056     0.200
     9.166   223.256     0.200
     9.360   232.556     0.200
     9.876   241.855     0.200
    10.242   251.756     0.200
     2.632    73.898     0.200
     2.966    82.297     0.200
     3.506    95.426     0.200
     3.516    97.469     0.200
     3.595    99.066     0.200
     4.174   111.367     0.200
     4.250   112.469     0.200
     4.634   123.469     0.200
     5.967   158.969     0.200
     5.988   156.168     0.200
     6.071   161.066     0.200
     6.214   165.566     0.200
     6.325   166.742     0.200
     6.634   172.867     0.200
     7.031   176.246     0.200
     8.127   204.668     0.200
     8.430   211.367     0.200
     8.636   214.867     0.200
     8.810   220.066     0.200
     9.776   242.766     0.200
     9.891   248.066     0.200
     1.734    50.582     0.200
     2.450    69.281     0.200
     2.620    74.141     0.200
     2.664    73.934     0.200
     2.903    80.703     0.200
     2.948    80.480     0.200
     2.999    82.312     0.200
     3.362    92.254     0.200
     3.540    95.504     0.200
     3.555    96.133     0.200
     3.651    97.582     0.200
     4.082   105.883     0.200
     4.227   110.082     0.200
     4.299   113.082     0.200
     4.687   122.883     0.200
     5.408   139.980     0.200
     6.009   157.980     0.200
     6.041   154.684     0.200
     6.110   156.684     0.200
     6.110   159.980     0.200
     6.357   168.535     0.200
     7.082   176.344     0.200
     8.144   203.582     0.200
     8.666   216.480     0.200
     8.836   220.684     0.200
     9.792   241.980     0.200
     1.741    54.443     0.200
     2.608    75.143     0.200
     2.901    80.983     0.200
     2.942    83.633     0.200
     3.481    96.623     0.200
     3.491    97.683     0.200
     3.577    96.743     0.200
     3.952   106.193     0.200
     4.004   107.143     0.200
     4.159   113.843     0.200
     4.237   114.043     0.200
     4.618   124.143     0.200
     5.169   136.243     0.200
     5.697   149.643     0.200
     5.973   156.343     0.200
     5.973   157.743     0.200
     6.131   160.643     0.200
     6.631   172.143     0.200
     6.802   177.643     0.200
     7.182   183.043     0.200
     8.132   207.143     0.200
     8.431   213.243     0.200
     8.635   217.243     0.200
     8.811   221.743     0.200
     9.782   242.543     0.200
     9.898   245.643     0.200
     2.602    73.164     0.200
     2.855    80.402     0.200
     2.878    79.344     0.200
     2.940    81.695     0.200
     3.324    92.254     0.200
     3.483    95.055     0.200
     3.503    95.652     0.200
     4.131   108.574     0.200
     4.118   113.375     0.200
     4.293   113.375     0.200
     4.372   113.273     0.200
     4.752   125.973     0.200
     4.813   126.875     0.200
     4.868   127.473     0.200
     5.455   144.672     0.200
     5.482   143.273     0.200
     6.091   158.773     0.200
     6.106   157.773     0.200
     6.174   159.574     0.200
     6.194   160.574     0.200
     6.338   165.473     0.200
     6.446   167.305     0.200
     6.719   170.574     0.200
     6.711   170.773     0.200
     6.757   173.473     0.200
     6.944   175.172     0.200
     7.082   180.074     0.200
     7.120   181.473     0.200
     7.150   180.773     0.200
     7.150   180.172     0.200
     7.181   181.074     0.200
     7.280   182.574     0.200
     7.300   185.773     0.200
     7.318   187.273     0.200
     7.446   187.875     0.200
     7.560   192.398     0.200
     7.589   192.574     0.200
     7.604   191.172     0.200
     8.032   203.625     0.200
     8.216   205.375     0.200
     8.237   205.875     0.200
     8.259   206.172     0.200
     8.432   211.172     0.200
     8.548   213.375     0.200
     8.672   219.273     0.200
     8.756   217.574     0.200
     9.229   229.773     0.200
     9.229   230.273     0.200
     9.885   242.172     0.200
     9.971   245.672     0.200
     9.999   246.574     0.200
     1.192    37.789     0.200
     1.233    39.695     0.200
     1.287    40.289     0.200
     4.607   118.695     0.200
     4.703   121.391     0.200
     5.062   129.391     0.200
     5.734   146.391     0.200
     5.816   148.695     0.200
     6.416   162.695     0.200
     6.447   166.094     0.200
     6.555   167.594     0.200
     6.816   174.117     0.200
     7.124   183.789     0.200
     7.466   186.891     0.200
     7.762   193.492     0.200
     8.918   221.289     0.200
     9.298   228.695     0.200
    10.249   254.594     0.200
     2.781    77.921     0.200
     2.866    77.691     0.200
     2.958    81.861     0.200
     2.988    82.621     0.200
     3.239    88.722     0.200
     3.260    89.321     0.200
     3.327    90.852     0.200
     3.700   100.062     0.200
     3.759   103.151     0.200
     3.869   104.321     0.200
     3.888   104.421     0.200
     3.888   104.421     0.200
     4.055   108.671     0.200
     4.151   112.052     0.200
     4.148   109.361     0.200
     4.262   112.852     0.200
     4.280   114.552     0.200
     4.345   115.621     0.200
     4.354   114.611     0.200
     4.394   115.352     0.200
     4.471   117.521     0.200
     4.469   120.852     0.200
     4.818   126.251     0.200
     6.035   158.151     0.200
     6.120   160.451     0.200
     6.169   159.852     0.200
     6.640   174.451     0.200
     6.664   171.151     0.200
     7.028   178.151     0.200
     7.048   179.951     0.200
     7.492   187.951     0.200
     8.375   208.151     0.200
     8.706   215.451     0.200
     8.752   218.052     0.200
     9.356   232.151     0.200
     9.653   240.151     0.200
     2.853    80.016     0.200
     2.988    85.328     0.200
     3.237    92.105     0.200
     3.261    91.695     0.200
     3.326    93.547     0.200
     3.455    94.137     0.200
     3.697   103.027     0.200
     3.803   103.059     0.200
     3.868   106.727     0.200
     3.887   107.547     0.200
     3.887   107.547     0.200
     3.911   108.617     0.200
     3.959   104.996     0.200
     4.043   107.746     0.200
     4.192   111.535     0.200
     4.342   115.758     0.200
     4.463   121.438     0.200
     4.806   129.738     0.200
     5.254   138.605     0.200
     5.482   146.035     0.200
     5.559   148.035     0.200
     6.022   159.738     0.200
     6.104   161.535     0.200
     6.108   161.238     0.200
     6.156   162.238     0.200
     6.185   158.637     0.200
     6.251   165.137     0.200
     6.370   164.836     0.200
     6.405   167.035     0.200
     6.628   174.137     0.200
     6.673   171.137     0.200
     6.875   175.438     0.200
     7.186   184.836     0.200
     7.314   186.938     0.200
     7.480   190.438     0.200
     7.630   194.238     0.200
     7.693   194.582     0.200
     8.004   201.637     0.200
     8.093   205.836     0.200
     8.177   206.777     0.200
     8.284   210.438     0.200
     8.364   210.637     0.200
     8.386   209.938     0.200
     8.386   209.938     0.200
     8.441   216.336     0.200
     8.694   220.035     0.200
     8.741   218.938     0.200
     8.902   221.496     0.200
     9.221   230.438     0.200
     9.221   229.637     0.200
     9.347   235.836     0.200
     9.621   242.238     0.200
     9.643   242.336     0.200
     9.689   244.637     0.200
     9.718   243.738     0.200
     9.989   254.047     0.200
    10.033   258.578     0.200
    10.218   256.938     0.200
    10.931   271.938     0.200
    10.970   270.996     0.200
    11.179   277.738     0.200
    12.916   320.637     0.200
    14.359   360.637     0.200
    18.262   457.285     0.200
    18.464   462.727     0.200
    18.464   463.492     0.200
    18.789   466.918     0.200
    18.789   467.527     0.200
    18.789   468.266     0.200
    20.687   516.637     0.200
     2.746    77.797     0.200
     2.854    79.285     0.200
     2.923    82.375     0.200
     2.954    82.805     0.200
     3.204    88.855     0.200
     3.226    88.707     0.200
     3.293    90.637     0.200
     3.666   100.375     0.200
     3.835   103.906     0.200
     3.854   103.836     0.200
     3.854   103.836     0.200
     4.046   110.766     0.200
     4.133   110.875     0.200
     4.262   114.414     0.200
     4.329   115.164     0.200
     4.344   115.277     0.200
     4.387   116.516     0.200
     4.456   117.555     0.200
     4.497   121.516     0.200
     4.808   127.316     0.200
     4.863   130.016     0.200
     5.489   144.414     0.200
     5.887   151.715     0.200
     6.035   158.617     0.200
     6.118   159.914     0.200
     6.159   160.516     0.200
     6.196   157.914     0.200
     6.266   163.117     0.200
     6.552   164.914     0.200
     6.646   173.215     0.200
     6.961   178.617     0.200
     7.047   179.215     0.200
     7.068   179.215     0.200
     7.190   182.617     0.200
     7.484   189.516     0.200
     8.387   209.516     0.200
     8.764   218.215     0.200
     9.375   235.617     0.200
     9.670   240.516     0.200
     2.810    80.109     0.200
     2.868    79.938     0.200
     2.986    84.477     0.200
     3.018    84.906     0.200
     3.267    91.367     0.200
     3.289    90.977     0.200
     3.356    93.066     0.200
     3.727   102.707     0.200
     3.789   105.477     0.200
     3.898   106.258     0.200
     3.917   107.008     0.200
     3.917   107.008     0.200
     4.055   108.367     0.200
     4.153   110.906     0.200
     4.287   112.680     0.200
     4.355   116.270     0.200
     4.392   116.277     0.200
     4.440   120.379     0.200
     4.476   119.156     0.200
     4.819   126.078     0.200
     5.576   143.578     0.200
     6.026   158.277     0.200
     6.169   161.180     0.200
     7.197   182.078     0.200
     7.491   189.180     0.200
     8.298   207.379     0.200
     8.358   209.879     0.200
     8.703   221.180     0.200
     8.734   218.277     0.200
     9.631   242.578     0.200
     9.701   247.078     0.200
     2.748    77.816     0.200
     2.841    80.668     0.200
     2.923    82.879     0.200
     2.957    82.035     0.200
     3.205    89.527     0.200
     3.230    88.477     0.200
     3.295    90.238     0.200
     3.665   101.059     0.200
     3.837   103.777     0.200
     3.855   104.816     0.200
     3.855   104.816     0.200
     4.033   109.957     0.200
     4.121   112.469     0.200
     4.236   114.938     0.200
     4.317   116.176     0.200
     4.331   116.086     0.200
     4.374   117.156     0.200
     4.444   119.348     0.200
     4.489   122.156     0.200
     4.776   126.785     0.200
     4.795   127.758     0.200
     4.867   131.559     0.200
     5.476   143.855     0.200
     5.545   144.355     0.200
     6.022   159.559     0.200
     6.104   161.258     0.200
     6.109   161.559     0.200
     6.146   161.355     0.200
     6.252   164.457     0.200
     6.633   174.457     0.200
     6.655   169.758     0.200
     7.177   183.457     0.200
     7.471   190.355     0.200
     8.018   203.457     0.200
     8.093   204.059     0.200
     8.273   207.957     0.200
     8.374   211.156     0.200
     8.421   215.156     0.200
     8.687   219.758     0.200
     8.685   220.059     0.200
     8.751   219.156     0.200
     9.216   230.656     0.200
     9.216   229.957     0.200
     9.659   242.559     0.200
     9.681   243.957     0.200
     1.192    39.617     0.200
     2.855    78.035     0.200
     3.778   102.746     0.200
     4.043   109.734     0.200
     4.139   109.637     0.200
     4.337   114.625     0.200
     4.381   114.746     0.200
     4.806   126.547     0.200
     7.027   178.246     0.200
     7.480   186.746     0.200
     8.355   208.945     0.200
     8.731   216.547     0.200
     9.632   239.645     0.200
     1.147    38.406     0.200
     1.054    35.906     0.200
     1.189    40.414     0.200
     2.857    79.938     0.200
     2.793    78.898     0.200
     2.968    84.195     0.200
     3.001    83.406     0.200
     3.250    90.750     0.200
     3.274    89.586     0.200
     3.340    91.984     0.200
     3.710   102.367     0.200
     3.882   105.250     0.200
     3.900   105.969     0.200
     3.900   105.969     0.200
     4.046   108.898     0.200
     4.141   110.719     0.200
     4.167   111.695     0.200
     4.274   113.000     0.200
     4.383   116.094     0.200
     4.464   118.430     0.200
     4.809   125.797     0.200
     5.564   145.398     0.200
     6.159   160.797     0.200
     6.625   173.500     0.200
     7.482   187.500     0.200
     8.359   209.898     0.200
     8.736   218.500     0.200
     9.636   241.500     0.200
     9.712   243.094     0.200
     1.174    38.617     0.200
     1.298    44.016     0.200
     2.761    77.969     0.200
     2.849    80.203     0.200
     2.937    83.344     0.200
     2.970    82.922     0.200
     3.218    89.398     0.200
     3.243    88.562     0.200
     3.308    90.766     0.200
     3.437    92.828     0.200
     3.679   101.375     0.200
     3.744   102.125     0.200
     3.850   104.125     0.200
     3.868   104.266     0.200
     3.868   104.266     0.200
     4.040   109.406     0.200
     4.130   112.367     0.200
     4.136   113.227     0.200
     4.244   115.625     0.200
     4.261   113.328     0.200
     4.326   115.797     0.200
     4.338   116.422     0.200
     4.380   116.828     0.200
     4.453   118.883     0.200
     4.802   125.828     0.200
     5.481   144.328     0.200
     5.553   144.227     0.200
     6.111   159.328     0.200
     6.153   160.328     0.200
     6.633   173.523     0.200
     7.030   180.328     0.200
     7.051   180.727     0.200
     7.477   189.828     0.200
     8.014   203.125     0.200
     8.280   207.922     0.200
     8.372   208.922     0.200
     8.749   219.023     0.200
     9.654   242.727     0.200
     9.726   243.727     0.200
     2.771    79.809     0.200
     2.870    80.930     0.200
     2.949    84.371     0.200
     2.978    84.371     0.200
     3.229    91.199     0.200
     3.248    90.648     0.200
     3.316    92.859     0.200
     3.692   102.270     0.200
     3.747   103.711     0.200
     3.859   105.922     0.200
     3.878   106.340     0.200
     3.878   106.340     0.200
     4.151   113.039     0.200
     4.282   117.012     0.200
     4.359   118.910     0.200
     4.401   118.109     0.200
     4.481   121.512     0.200
     4.823   129.211     0.200
     6.174   160.012     0.200
     6.424   166.809     0.200
     2.880    79.719     0.200
     4.071   110.359     0.200
     4.160   110.109     0.200
     4.274   115.449     0.200
     4.356   115.078     0.200
     4.370   114.930     0.200
     4.483   117.398     0.200
     4.496   119.828     0.200
     4.833   127.328     0.200
     6.185   160.629     0.200
     8.402   208.930     0.200
     8.779   219.129     0.200
     1.045    36.230     0.200
     2.872    79.562     0.200
     2.808    79.422     0.200
     2.984    83.980     0.200
     3.015    84.129     0.200
     3.265    90.590     0.200
     3.286    90.551     0.200
     3.354    92.602     0.200
     3.481    96.102     0.200
     3.726   102.379     0.200
     3.824   101.242     0.200
     3.772   103.301     0.200
     3.936   106.832     0.200
     3.896   105.980     0.200
     3.915   106.551     0.200
     3.915   106.551     0.200
     4.060   107.992     0.200
     4.157   109.691     0.200
     4.304   118.609     0.200
     4.360   113.402     0.200
     4.445   118.301     0.200
     4.502   121.699     0.200
     4.688   121.602     0.200
     4.824   128.000     0.200
     4.961   128.992     0.200
     4.922   132.301     0.200
     4.994   129.039     0.200
     5.148   137.641     0.200
     5.282   138.352     0.200
     5.339   138.359     0.200
     5.496   143.000     0.200
     5.580   147.102     0.200
     5.724   146.961     0.200
     5.799   149.602     0.200
     6.031   158.801     0.200
     5.994   152.840     0.200
     6.114   159.801     0.200
     6.116   159.102     0.200
     6.064   156.441     0.200
     6.174   161.402     0.200
     6.259   165.402     0.200
     6.206   156.922     0.200
     6.339   163.152     0.200
     6.295   162.160     0.200
     6.388   164.402     0.200
     6.458   166.602     0.200
     6.633   172.500     0.200
     6.697   169.301     0.200
     6.790   178.801     0.200
     6.757   173.199     0.200
     6.881   175.359     0.200
     6.899   173.000     0.200
     7.010   178.000     0.200
     7.031   178.699     0.200
     7.029   178.441     0.200
     7.202   183.301     0.200
     7.325   186.562     0.200
     7.496   189.199     0.200
     7.715   193.039     0.200
     7.801   195.320     0.200
     7.973   198.160     0.200
     7.999   200.602     0.200
     8.183   204.930     0.200
     8.303   207.500     0.200
     8.364   208.801     0.200
     8.398   210.301     0.200
     8.465   216.402     0.200
     8.708   219.301     0.200
     8.709   225.402     0.200
     8.740   217.500     0.200
     8.940   223.180     0.200
     8.940   224.816     0.200
     9.235   229.402     0.200
     9.235   229.301     0.200
     9.339   233.000     0.200
     9.347   235.598     0.200
     9.592   238.602     0.200
     9.628   241.102     0.200
     9.637   240.000     0.200
     9.706   244.801     0.200
     9.716   239.102     0.200
     9.913   247.000     0.200
     9.995   251.062     0.200
     9.964   247.359     0.200
    10.345   260.277     0.200
    10.735   268.590     0.200
    10.932   269.500     0.200
    10.975   271.379     0.200
    10.955   276.613     0.200
    10.971   272.812     0.200
    11.180   275.301     0.200
    11.310   289.301     0.200
    11.465   291.980     0.200
    18.805   469.781     0.200
    20.762   513.301     0.200
     1.648    51.297     0.200
     2.871    79.625     0.200
     2.837    80.066     0.200
     3.011    84.734     0.200
     3.045    84.668     0.200
     3.294    91.055     0.200
     3.317    91.246     0.200
     3.383    92.805     0.200
     3.753   102.645     0.200
     3.816   104.547     0.200
     3.925   106.207     0.200
     3.944   106.836     0.200
     3.944   106.836     0.200
     4.013   106.824     0.200
     4.056   108.324     0.200
     4.159   111.957     0.200
     4.295   112.145     0.200
     4.357   116.016     0.200
     4.357   113.824     0.200
     4.391   114.746     0.200
     4.482   117.797     0.200
     4.821   126.645     0.200
     4.716   125.117     0.200
     5.025   130.785     0.200
     5.489   144.145     0.200
     5.581   145.445     0.200
     5.754   147.707     0.200
     6.019   159.848     0.200
     6.101   160.547     0.200
     6.102   160.645     0.200
     6.024   153.625     0.200
     6.171   160.645     0.200
     6.245   162.848     0.200
     6.324   161.984     0.200
     7.491   188.246     0.200
     8.343   208.145     0.200
     8.719   217.246     0.200
     9.226   229.047     0.200
     9.313   232.445     0.200
     9.612   237.746     0.200
     9.695   240.645     0.200
     9.887   246.445     0.200
     1.059    34.719     0.200
     1.647    50.199     0.200
     2.871    79.551     0.200
     2.831    77.539     0.200
     3.006    82.570     0.200
     3.039    82.359     0.200
     3.288    88.852     0.200
     3.311    88.602     0.200
     3.378    90.809     0.200
     3.748   100.461     0.200
     3.920   103.789     0.200
     3.938   104.309     0.200
     3.938   104.309     0.200
     4.057   107.891     0.200
     4.158   111.410     0.200
     4.271   112.949     0.200
     4.294   113.629     0.200
     4.357   115.102     0.200
     4.356   115.398     0.200
     4.391   114.629     0.200
     4.481   117.379     0.200
     4.420   119.629     0.200
     7.492   187.430     0.200
     8.346   208.730     0.200
     8.722   217.129     0.200
     9.617   239.430     0.200
     1.071    36.621     0.200
     1.199    40.660     0.200
     1.659    50.520     0.200
     2.859    79.230     0.200
     4.045   108.148     0.200
     4.147   110.238     0.200
     4.260   113.559     0.200
     8.334   209.250     0.200
     8.710   217.449     0.200
     1.217    41.055     0.200
     2.836    80.465     0.200
     3.802   107.535     0.200
     4.022   109.266     0.200
     4.123   111.613     0.200
     4.235   116.523     0.200
     4.258   113.035     0.200
     4.358   117.336     0.200
     4.445   118.465     0.200
     4.786   126.734     0.200
     6.136   161.234     0.200
     7.458   189.434     0.200
     8.266   209.133     0.200
     8.325   209.133     0.200
     8.702   216.934     0.200
     9.602   240.633     0.200
     1.203    40.934     0.200
     1.663    51.176     0.200
     2.824    80.434     0.200
     2.853    80.305     0.200
     2.996    85.074     0.200
     3.033    84.625     0.200
     3.279    91.586     0.200
     3.307    90.574     0.200
     3.371    92.895     0.200
     3.737   103.465     0.200
     3.808   106.375     0.200
     3.913   106.074     0.200
     3.930   107.375     0.200
     3.930   107.375     0.200
     4.039   109.074     0.200
     4.140   111.395     0.200
     4.253   113.605     0.200
     4.276   111.875     0.200
     4.338   117.395     0.200
     4.374   116.176     0.200
     4.463   119.035     0.200
     4.803   126.074     0.200
     5.473   144.977     0.200
     6.153   161.074     0.200
     7.474   189.375     0.200
     8.283   209.176     0.200
     8.334   206.977     0.200
     8.710   216.676     0.200
     9.607   239.676     0.200
     9.686   239.773     0.200
     1.118    39.617     0.200
     1.670    51.750     0.200
     2.842    80.391     0.200
     3.024    86.359     0.200
     3.361    94.859     0.200
     3.647    98.141     0.200
     3.726   104.801     0.200
     3.795   104.020     0.200
     3.789   103.539     0.200
     3.911   108.660     0.200
     3.903   108.660     0.200
     3.920   109.090     0.200
     3.920   109.090     0.200
     3.984   106.551     0.200
     4.029   109.668     0.200
     4.129   110.609     0.200
     4.242   116.449     0.200
     4.327   116.910     0.200
     4.328   116.008     0.200
     4.365   116.738     0.200
     4.521   121.438     0.200
     4.715   124.559     0.200
     4.793   127.039     0.200
     4.935   132.539     0.200
     5.014   129.918     0.200
     5.289   138.289     0.200
     5.464   143.539     0.200
     5.742   148.000     0.200
     5.998   158.938     0.200
     6.016   153.719     0.200
     6.080   159.738     0.200
     6.082   159.141     0.200
     6.081   155.641     0.200
     6.143   161.141     0.200
     6.225   163.238     0.200
     6.598   173.938     0.200
     6.781   171.641     0.200
     7.170   183.141     0.200
     7.464   190.141     0.200
     7.688   195.277     0.200
     7.967   202.938     0.200
     8.272   207.840     0.200
     8.331   209.238     0.200
     8.676   218.039     0.200
     8.707   216.840     0.200
     8.920   225.520     0.200
     9.202   230.539     0.200
     9.276   236.711     0.200
     9.308   234.641     0.200
     9.336   232.156     0.200
     9.559   237.141     0.200
     9.594   240.238     0.200
     9.606   240.238     0.200
     9.674   243.340     0.200
     9.683   240.938     0.200
     9.883   248.141     0.200
     9.946   251.020     0.200
    10.179   255.141     0.200
    10.328   260.078     0.200
    10.939   276.750     0.200
    10.950   274.309     0.200
     2.829    80.816     0.200
     4.018   109.824     0.200
     4.112   112.688     0.200
     4.226   114.707     0.200
     4.309   116.707     0.200
     4.435   118.945     0.200
     4.781   127.586     0.200
     6.131   162.484     0.200
     7.455   190.887     0.200
     8.342   210.188     0.200
     8.719   219.785     0.200
     9.328   236.387     0.200
     9.623   242.688     0.200
     2.870    79.688     0.200
     4.056   108.391     0.200
     4.156   111.109     0.200
     4.269   112.375     0.200
     4.354   113.898     0.200
     4.391   116.891     0.200
     4.479   117.570     0.200
     4.820   126.289     0.200
     6.170   160.984     0.200
     7.983   201.789     0.200
     8.350   208.289     0.200
     8.726   217.289     0.200
     9.322   234.891     0.200
     9.621   240.586     0.200
     1.217    41.156     0.200
     2.838    79.797     0.200
     4.024   109.211     0.200
     4.125   111.227     0.200
     4.238   114.047     0.200
     4.323   117.219     0.200
     4.448   118.188     0.200
     4.415   121.117     0.200
     4.788   126.516     0.200
     5.458   144.914     0.200
     6.138   160.719     0.200
     7.459   188.617     0.200
     8.323   207.219     0.200
     8.699   219.016     0.200
     9.300   235.719     0.200
     9.598   240.617     0.200
     0.851    29.781     0.200
     1.100    36.539     0.200
     2.866    78.656     0.200
     2.845    79.594     0.200
     3.054    83.812     0.200
     3.302    91.516     0.200
     3.327    89.555     0.200
     3.392    92.305     0.200
     3.760   103.312     0.200
     3.814   102.883     0.200
     3.827   103.781     0.200
     3.934   105.641     0.200
     3.952   106.492     0.200
     3.952   106.492     0.200
     4.050   109.031     0.200
     4.155   110.602     0.200
     4.267   112.711     0.200
     4.292   109.680     0.200
     4.350   114.812     0.200
     4.353   115.414     0.200
     4.384   116.180     0.200
     4.403   117.086     0.200
     4.477   116.750     0.200
     4.815   127.781     0.200
     4.912   125.516     0.200
     4.963   133.180     0.200
     5.320   137.391     0.200
     5.482   143.281     0.200
     5.576   144.180     0.200
     6.010   158.383     0.200
     6.092   158.883     0.200
     6.093   158.984     0.200
     6.164   160.484     0.200
     6.236   161.883     0.200
     6.972   175.484     0.200
     6.993   176.883     0.200
     7.191   181.180     0.200
     7.485   190.086     0.200
     7.963   199.984     0.200
     8.026   199.680     0.200
     8.062   201.984     0.200
     8.295   207.383     0.200
     8.331   206.484     0.200
     8.379   207.586     0.200
     8.476   211.586     0.200
     8.694   219.281     0.200
     8.708   215.180     0.200
     8.927   231.500     0.200
     9.218   228.086     0.200
     9.218   227.383     0.200
     9.301   230.680     0.200
     9.600   237.781     0.200
     9.683   239.180     0.200
     9.874   245.680     0.200
    10.169   253.383     0.200
     4.064   108.403     0.200
     4.275   115.793     0.200
     4.443   118.133     0.200
     4.828   127.633     0.200
     6.034   159.533     0.200
     6.119   158.133     0.200
     6.178   160.633     0.200
     7.032   175.934     0.200
     7.500   187.934     0.200
     8.365   207.533     0.200
     8.741   216.133     0.200
     9.638   237.934     0.200
     2.797    81.618     0.200
     2.970    86.318     0.200
     3.007    86.769     0.200
     3.253    93.068     0.200
     3.281    92.479     0.200
     3.344    94.729     0.200
     3.711   104.429     0.200
     3.771   104.519     0.200
     3.783   106.019     0.200
     3.886   108.108     0.200
     3.903   108.519     0.200
     3.903   108.519     0.200
     3.971   111.198     0.200
     4.129   112.589     0.200
     4.331   117.129     0.200
     4.326   116.999     0.200
     4.369   117.318     0.200
     4.441   117.618     0.200
     4.795   128.618     0.200
     5.272   139.679     0.200
     5.552   143.719     0.200
     6.091   160.219     0.200
     6.146   161.919     0.200
     6.996   176.818     0.200
     7.017   177.019     0.200
     7.468   190.419     0.200
     8.275   208.019     0.200
     8.344   208.719     0.200
     8.681   220.719     0.200
     8.720   218.019     0.200
     9.324   233.719     0.200
     9.621   239.618     0.200
     1.196    40.701     0.200
     2.836    81.031     0.200
     2.863    80.891     0.200
     3.009    86.061     0.200
     3.044    85.531     0.200
     3.292    92.320     0.200
     3.317    91.691     0.200
     3.382    94.211     0.200
     3.750   104.172     0.200
     3.817   104.941     0.200
     3.925   107.061     0.200
     3.942   107.531     0.200
     3.942   107.531     0.200
     4.010   109.262     0.200
     4.048   109.701     0.200
     4.263   116.631     0.200
     4.348   115.512     0.200
     4.382   116.842     0.200
     4.473   119.631     0.200
     4.813   128.041     0.200
     5.573   147.541     0.200
     6.162   161.842     0.200
     7.483   189.740     0.200
     8.293   212.041     0.200
     8.336   207.441     0.200
     8.712   215.541     0.200
     9.606   239.141     0.200
     9.687   241.041     0.200
     1.049    35.754     0.200
     1.178    39.816     0.200
     1.426    45.527     0.200
     1.638    51.555     0.200
     2.876    80.234     0.200
     4.063   109.367     0.200
     7.021   179.016     0.200
     8.357   208.516     0.200
     8.733   217.316     0.200
     9.328   235.715     0.200
     9.627   241.414     0.200
     1.078    37.711     0.200
     1.206    40.730     0.200
     1.666    52.453     0.200
     2.853    80.152     0.200
     4.038   108.781     0.200
     4.141   111.762     0.200
     4.254   113.582     0.200
     4.338   115.680     0.200
     4.464   118.941     0.200
     4.803   124.582     0.200
     6.152   161.281     0.200
     7.473   188.781     0.200
     8.283   207.281     0.200
     8.327   209.281     0.200
     8.683   219.281     0.200
     8.704   217.680     0.200
     9.599   241.180     0.200
     9.679   243.082     0.200
     2.872    80.875     0.200
     2.784    79.695     0.200
     2.962    85.109     0.200
     2.991    84.102     0.200
     3.242    91.195     0.200
     3.262    90.047     0.200
     3.330    92.859     0.200
     3.704   103.305     0.200
     3.872   106.000     0.200
     3.892   106.711     0.200
     3.892   106.711     0.200
     4.061   109.289     0.200
     4.154   112.711     0.200
     4.268   114.445     0.200
     4.286   114.297     0.200
     4.351   116.898     0.200
     4.360   117.336     0.200
     4.400   117.195     0.200
     4.477   119.070     0.200
     4.468   119.000     0.200
     4.824   129.102     0.200
     6.175   161.195     0.200
     6.691   170.500     0.200
     7.030   180.102     0.200
     7.051   180.398     0.200
     7.498   190.297     0.200
     8.303   208.102     0.200
     8.379   210.195     0.200
     8.712   219.297     0.200
     8.756   218.500     0.200
     9.239   232.000     0.200
     9.358   236.398     0.200
     9.656   241.500     0.200
     9.732   243.195     0.200
     2.773    78.383     0.200
     2.868    80.297     0.200
     2.951    83.508     0.200
     2.980    82.578     0.200
     3.232    89.812     0.200
     3.251    88.594     0.200
     3.319    91.078     0.200
     3.694   101.648     0.200
     3.861   104.344     0.200
     3.881   105.109     0.200
     3.881   105.109     0.200
     4.150   111.109     0.200
     4.143   112.812     0.200
     4.281   113.312     0.200
     4.357   116.516     0.200
     4.398   116.312     0.200
     4.477   118.117     0.200
     4.821   126.617     0.200
     4.949   128.078     0.200
     6.172   160.516     0.200
     7.036   179.414     0.200
     7.057   180.016     0.200
     7.496   189.117     0.200
     8.300   208.016     0.200
     8.383   210.719     0.200
     8.760   218.719     0.200
     9.662   242.812     0.200
     2.855    81.320     0.200
     2.832    82.010     0.200
     3.004    87.119     0.200
     3.041    86.280     0.200
     3.288    93.530     0.200
     3.315    91.659     0.200
     3.379    94.119     0.200
     3.745   105.290     0.200
     3.803   105.240     0.200
     3.816   104.740     0.200
     3.921   107.639     0.200
     3.938   108.860     0.200
     3.938   108.860     0.200
     4.004   107.330     0.200
     4.026   113.729     0.200
     4.208   114.939     0.200
     4.341   115.740     0.200
     4.375   117.240     0.200
     4.411   116.840     0.200
     4.695   124.360     0.200
     4.805   128.939     0.200
     4.951   135.939     0.200
     5.027   133.679     0.200
     5.307   140.360     0.200
     5.565   148.639     0.200
     6.086   162.340     0.200
     6.088   161.939     0.200
     6.028   157.800     0.200
     6.155   163.040     0.200
     6.231   165.139     0.200
     6.330   166.760     0.200
     6.602   173.439     0.200
     6.889   174.340     0.200
     6.975   177.139     0.200
     6.996   178.540     0.200
     7.475   190.439     0.200
     7.703   198.600     0.200
     7.964   202.639     0.200
     8.060   204.439     0.200
     8.285   207.639     0.200
     8.331   208.740     0.200
     8.372   209.040     0.200
     8.372   209.040     0.200
     8.686   219.040     0.200
     8.707   217.040     0.200
     9.211   230.240     0.200
     9.211   229.740     0.200
     9.304   233.439     0.200
     9.599   239.840     0.200
     9.602   239.840     0.200
     9.683   241.240     0.200
     9.878   247.939     0.200
    10.173   253.439     0.200
    10.900   269.939     0.200
     2.862    81.100     0.200
     2.821    79.140     0.200
     2.995    84.790     0.200
     3.029    83.260     0.200
     3.277    90.850     0.200
     3.302    89.040     0.200
     3.367    91.700     0.200
     3.736   102.840     0.200
     3.910   105.290     0.200
     3.928   105.870     0.200
     3.928   105.870     0.200
     3.997   109.310     0.200
     4.194   115.359     0.200
     4.348   115.760     0.200
     4.384   116.760     0.200
     4.520   120.760     0.200
     4.812   128.460     0.200
     4.938   132.260     0.200
     5.012   132.140     0.200
     5.295   139.410     0.200
     5.571   148.560     0.200
     6.097   162.260     0.200
     6.099   159.660     0.200
     6.162   160.260     0.200
     6.242   164.560     0.200
     7.484   188.859     0.200
     7.979   200.960     0.200
     8.072   204.760     0.200
     8.344   210.160     0.200
     8.695   219.960     0.200
     8.721   217.260     0.200
     9.220   229.460     0.200
     9.220   229.260     0.200
     9.617   241.060     0.200
     9.693   248.260     0.200
     1.194    40.891     0.200
     1.653    51.660     0.200
     2.803    80.453     0.200
     2.856    80.301     0.200
     2.977    83.902     0.200
     3.012    85.582     0.200
     3.260    90.992     0.200
     3.285    92.750     0.200
     3.350    93.621     0.200
     3.719   101.742     0.200
     3.786   103.102     0.200
     3.892   106.953     0.200
     3.910   106.750     0.200
     3.910   106.750     0.200
     4.380   115.902     0.200
     4.807   125.801     0.200
     4.922   128.211     0.200
     6.100   161.602     0.200
     6.157   160.000     0.200
     8.351   209.500     0.200
     8.727   217.902     0.200
     9.626   241.301     0.200
     1.184    40.773     0.200
     2.719    77.242     0.200
     2.845    80.930     0.200
     2.896    81.500     0.200
     2.927    81.641     0.200
     3.177    88.438     0.200
     3.200    88.555     0.200
     3.266    90.305     0.200
     3.639    99.594     0.200
     3.808   103.305     0.200
     3.827   103.578     0.200
     3.827   103.578     0.200
     3.886   106.359     0.200
     4.093   110.531     0.200
     4.249   113.633     0.200
     4.336   115.633     0.200
     4.382   116.734     0.200
     4.520   121.031     0.200
     4.799   126.828     0.200
     5.545   144.234     0.200
     5.946   154.430     0.200
     6.118   158.828     0.200
     6.124   162.328     0.200
     6.151   161.633     0.200
     6.268   167.531     0.200
     7.062   178.430     0.200
     7.083   180.828     0.200
     7.478   189.531     0.200
     8.277   207.430     0.200
     8.396   210.133     0.200
     8.394   208.031     0.200
     8.394   208.031     0.200
     8.416   214.328     0.200
     8.695   221.328     0.200
     8.684   223.734     0.200
     8.773   220.734     0.200
     9.226   231.031     0.200
     9.390   235.430     0.200
     9.684   241.133     0.200
     9.751   243.133     0.200
     1.265    40.477     0.200
     1.632    50.887     0.200
     2.828    78.109     0.200
     2.883    79.359     0.200
     3.005    82.629     0.200
     3.035    82.930     0.200
     3.286    89.609     0.200
     3.305    89.367     0.200
     3.374    91.066     0.200
     3.747   100.988     0.200
     3.916   104.707     0.200
     3.936   104.906     0.200
     3.936   104.906     0.200
     4.369   113.008     0.200
     4.405   115.609     0.200
     6.035   159.309     0.200
     6.183   161.008     0.200
     6.262   161.207     0.200
     6.632   175.109     0.200
     7.023   179.508     0.200
     7.505   188.008     0.200
     8.360   209.508     0.200
     8.736   218.207     0.200
     9.630   240.008     0.200
     2.803    79.066     0.200
     2.860    80.887     0.200
     2.978    84.367     0.200
     3.011    83.387     0.200
     3.260    90.496     0.200
     3.284    89.238     0.200
     3.350    91.727     0.200
     3.719   102.418     0.200
     3.892   105.047     0.200
     3.910   105.668     0.200
     3.910   105.668     0.200
     4.279   113.098     0.200
     4.347   116.297     0.200
     4.385   117.098     0.200
     4.811   125.098     0.200
     5.567   148.098     0.200
     6.020   160.297     0.200
     6.102   162.695     0.200
     6.161   162.996     0.200
     6.248   164.598     0.200
     7.484   189.195     0.200
     8.355   208.598     0.200
     8.731   217.898     0.200
     9.630   239.996     0.200
     1.145    38.531     0.200
     1.938    56.508     0.200
     2.530    72.148     0.200
     2.808    77.984     0.200
     2.879    79.414     0.200
     2.985    83.008     0.200
     3.015    82.422     0.200
     3.266    89.547     0.200
     3.285    88.594     0.200
     3.354    90.898     0.200
     3.728   101.047     0.200
     3.896   104.086     0.200
     3.916   104.734     0.200
     3.916   104.734     0.200
     4.366   115.727     0.200
     4.404   115.422     0.200
     4.830   129.922     0.200
     6.181   162.922     0.200
     6.639   173.828     0.200
     7.036   178.328     0.200
     8.370   209.523     0.200
     8.746   217.922     0.200
     9.643   241.625     0.200
     9.722   241.828     0.200
     2.743    76.773     0.200
     2.881    79.773     0.200
     2.924    81.258     0.200
     2.948    81.477     0.200
     3.203    87.758     0.200
     3.217    88.016     0.200
     3.287    89.875     0.200
     3.668    99.023     0.200
     3.830   103.164     0.200
     3.851   103.547     0.200
     3.851   103.547     0.200
     4.372   115.156     0.200
     4.416   116.859     0.200
     7.512   188.859     0.200
     8.415   207.555     0.200
     8.792   218.258     0.200
     9.769   242.359     0.200
     2.881    80.328     0.200
     2.843    80.637     0.200
     3.019    85.809     0.200
     3.051    85.266     0.200
     3.301    92.129     0.200
     3.322    91.238     0.200
     3.389    93.289     0.200
     3.761   103.789     0.200
     3.932   106.777     0.200
     3.951   107.559     0.200
     3.951   107.559     0.200
     4.022   110.098     0.200
     4.042   111.789     0.200
     4.213   114.016     0.200
     4.366   115.617     0.200
     4.400   116.418     0.200
     4.536   121.316     0.200
     4.630   124.219     0.200
     4.680   122.719     0.200
     4.831   126.516     0.200
     4.958   133.016     0.200
     5.180   137.258     0.200
     5.318   138.719     0.200
     5.498   142.617     0.200
     5.591   143.816     0.200
     6.110   159.316     0.200
     6.180   161.516     0.200
     6.253   164.418     0.200
     6.622   173.117     0.200
     6.713   170.719     0.200
     6.915   175.316     0.200
     7.501   188.918     0.200
     7.729   197.438     0.200
     7.978   201.016     0.200
     8.079   204.516     0.200
     8.311   207.117     0.200
     8.348   208.816     0.200
     8.482   214.219     0.200
     8.710   219.219     0.200
     8.724   216.316     0.200
     9.235   230.016     0.200
     9.235   229.617     0.200
     9.315   232.117     0.200
     9.616   239.516     0.200
     9.621   237.918     0.200
     9.680   240.617     0.200
     9.889   246.516     0.200
    19.617   490.918     0.200
     2.856    81.027     0.200
     2.874    80.430     0.200
     3.030    86.617     0.200
     3.064    85.270     0.200
     3.312    92.430     0.200
     3.336    90.668     0.200
     3.402    93.309     0.200
     3.771   104.668     0.200
     3.945   106.648     0.200
     3.963   107.906     0.200
     3.963   107.906     0.200
     4.391   116.219     0.200
     4.823   127.520     0.200
     5.488   142.418     0.200
     5.586   143.719     0.200
     6.015   158.117     0.200
     6.097   161.918     0.200
     6.240   165.520     0.200
     6.608   173.020     0.200
     7.492   189.816     0.200
     8.333   208.719     0.200
     8.708   217.117     0.200
     8.701   220.816     0.200
     9.599   239.719     0.200
     1.066    36.719     0.200
     1.190    40.328     0.200
     2.851    79.108     0.200
     3.025    84.578     0.200
     3.059    83.708     0.200
     3.307    90.868     0.200
     3.331    89.368     0.200
     3.397    91.969     0.200
     3.766   102.839     0.200
     3.828   102.559     0.200
     3.939   105.429     0.200
     3.958   106.078     0.200
     3.958   106.078     0.200
     4.057   108.979     0.200
     4.162   111.269     0.200
     4.300   112.988     0.200
     4.358   115.288     0.200
     4.361   115.788     0.200
     4.391   114.788     0.200
     5.488   140.688     0.200
     6.098   160.188     0.200
     6.172   160.988     0.200
     6.610   171.488     0.200
     6.974   176.488     0.200
     6.995   176.889     0.200
     7.492   187.389     0.200
     8.335   208.488     0.200
     8.711   215.488     0.200
     9.603   238.889     0.200
     1.192    40.757     0.200
     1.651    52.217     0.200
     2.797    79.277     0.200
     2.855    80.677     0.200
     2.972    84.027     0.200
     3.006    84.097     0.200
     3.254    90.497     0.200
     3.279    90.417     0.200
     3.344    92.478     0.200
     3.713   101.837     0.200
     3.886   105.777     0.200
     3.904   105.867     0.200
     3.904   105.867     0.200
     4.171   114.247     0.200
     4.343   115.747     0.200
     4.381   116.747     0.200
     4.446   119.047     0.200
     5.960   153.847     0.200
     6.100   159.946     0.200
     6.103   160.847     0.200
     6.157   158.347     0.200
     6.929   180.847     0.200
     7.007   179.548     0.200
     7.026   178.048     0.200
     7.480   189.548     0.200
     8.286   206.946     0.200
     8.354   208.647     0.200
     8.731   216.747     0.200
     2.877    79.844     0.200
     2.869    80.141     0.200
     3.050    84.891     0.200
     3.087    84.359     0.200
     3.333    91.133     0.200
     3.360    90.383     0.200
     3.424    92.812     0.200
     3.790   102.930     0.200
     3.966   105.922     0.200
     3.984   106.688     0.200
     4.371   117.070     0.200
     4.381   116.367     0.200
     5.478   143.273     0.200
     6.165   158.367     0.200
     6.591   173.570     0.200
     6.947   176.367     0.200
     6.968   177.469     0.200
     7.190   182.367     0.200
     7.483   189.570     0.200
     7.940   199.867     0.200
     8.312   208.070     0.200
     8.688   215.469     0.200
     9.577   238.969     0.200
     1.067    36.352     0.200
     2.885    79.523     0.200
     2.875    79.293     0.200
     3.049    84.102     0.200
     3.082    83.590     0.200
     3.332    90.902     0.200
     3.353    89.543     0.200
     3.421    92.000     0.200
     3.791   102.301     0.200
     3.963   105.371     0.200
     3.982   106.051     0.200
     4.399   114.551     0.200
     4.833   126.652     0.200
     6.182   159.352     0.200
     7.501   188.250     0.200
     2.872    78.828     0.200
     2.818    78.398     0.200
     2.994    83.273     0.200
     3.026    82.930     0.200
     3.276    89.680     0.200
     3.298    89.320     0.200
     3.365    91.422     0.200
     3.736   101.484     0.200
     3.783   101.391     0.200
     3.907   104.688     0.200
     3.926   105.102     0.200
     4.189   113.188     0.200
     4.359   113.391     0.200
     4.395   115.789     0.200
     4.433   118.391     0.200
     4.514   119.891     0.200
     4.934   130.391     0.200
     5.156   134.094     0.200
     5.293   137.031     0.200
     5.929   153.992     0.200
     5.961   150.492     0.200
     6.109   158.289     0.200
     6.111   159.492     0.200
     6.169   156.188     0.200
     6.173   161.492     0.200
     6.214   162.188     0.200
     6.520   161.594     0.200
     6.626   168.992     0.200
     6.643   169.594     0.200
     6.657   172.188     0.200
     6.699   169.594     0.200
     6.902   175.891     0.200
     6.931   177.891     0.200
     7.001   177.594     0.200
     7.022   178.789     0.200
     7.201   181.688     0.200
     7.495   187.992     0.200
     7.717   194.258     0.200
     8.303   205.992     0.200
     8.356   207.688     0.200
     8.468   216.594     0.200
     8.732   215.688     0.200
     8.722   220.289     0.200
     9.232   228.891     0.200
     9.232   228.391     0.200
     9.329   231.688     0.200
     9.628   239.094     0.200
     9.708   241.789     0.200
     9.903   247.289     0.200
     1.076    36.325     0.200
     4.219   113.825     0.200
     4.378   114.525     0.200
     4.401   117.525     0.200
     4.809   125.825     0.200
     6.087   158.825     0.200
     6.159   160.125     0.200
     6.298   160.525     0.200
     6.969   175.525     0.200
     6.990   175.825     0.200
     7.479   189.425     0.200
     8.289   206.725     0.200
     8.327   207.225     0.200
     8.703   215.125     0.200
     9.297   231.525     0.200
     9.597   237.625     0.200
     1.068    37.147     0.200
     1.194    40.038     0.200
     2.845    79.468     0.200
     3.019    84.098     0.200
     3.302    90.617     0.200
     3.326    90.357     0.200
     3.392    92.478     0.200
     3.760   102.008     0.200
     3.934   105.668     0.200
     3.952   106.098     0.200
     4.218   112.607     0.200
     4.353   114.808     0.200
     4.386   114.607     0.200
     4.818   125.708     0.200
     4.878   126.708     0.200
     5.484   142.607     0.200
     5.579   141.907     0.200
     6.013   157.508     0.200
     6.096   159.407     0.200
     6.095   158.508     0.200
     6.167   160.008     0.200
     6.239   163.808     0.200
     6.608   166.907     0.200
     6.608   173.808     0.200
     6.975   176.208     0.200
     6.996   176.607     0.200
     7.265   183.708     0.200
     7.487   188.208     0.200
     7.965   199.107     0.200
     8.298   205.808     0.200
     8.334   206.607     0.200
     8.710   215.308     0.200
     9.221   228.308     0.200
     9.303   231.107     0.200
     9.603   238.308     0.200
     1.073    34.713     0.200
     2.859    80.684     0.200
     2.871    79.594     0.200
     3.032    85.914     0.200
     3.067    84.902     0.200
     3.315    92.033     0.200
     3.340    90.812     0.200
     3.406    93.184     0.200
     3.773   103.953     0.200
     3.948   106.594     0.200
     3.965   107.504     0.200
     4.392   116.354     0.200
     4.355   115.453     0.200
     4.387   115.453     0.200
     4.820   124.953     0.200
     5.000   129.754     0.200
     5.485   142.453     0.200
     5.583   143.152     0.200
     6.010   156.953     0.200
     6.092   159.152     0.200
     6.169   159.453     0.200
     6.236   164.152     0.200
     6.965   176.553     0.200
     6.986   176.953     0.200
     7.488   189.453     0.200
     7.957   199.652     0.200
     8.300   207.152     0.200
     8.328   207.053     0.200
     8.703   215.953     0.200
     6.276   157.578     0.200
     6.322   160.980     0.200
     7.461   188.781     0.200
     8.303   205.980     0.200
     8.541   210.281     0.200
     8.679   213.578     0.200
     1.053    35.617     0.200
     1.431    44.219     0.200
     2.863    78.688     0.200
     4.388   116.023     0.200
     4.814   128.719     0.200
     4.968   128.719     0.200
     5.487   146.617     0.200
     5.571   147.422     0.200
     6.108   160.922     0.200
     6.165   162.820     0.200
     6.251   165.117     0.200
     7.006   178.719     0.200
     7.027   179.023     0.200
     7.487   189.023     0.200
     8.357   208.617     0.200
     8.593   213.922     0.200
     8.734   216.820     0.200
     9.632   238.922     0.200
     2.870    79.535     0.200
     4.392   116.045     0.200
     4.707   124.024     0.200
     4.984   129.444     0.200
     4.943   132.345     0.200
     5.015   131.665     0.200
     7.013   177.944     0.200
     7.198   181.944     0.200
     7.198   182.227     0.200
     7.492   189.745     0.200
     8.300   207.745     0.200
     8.349   208.845     0.200
     8.390   208.745     0.200
     8.586   213.045     0.200
     8.725   217.245     0.200
     9.228   228.444     0.200
     9.228   227.845     0.200
     9.321   232.345     0.200
     9.620   239.444     0.200
     1.435    43.828     0.200
     2.873    80.156     0.200
     2.835    79.918     0.200
     3.010    84.020     0.200
     3.043    85.168     0.200
     3.292    90.887     0.200
     3.314    91.898     0.200
     3.381    93.180     0.200
     3.751   101.789     0.200
     3.827   102.809     0.200
     3.800   102.629     0.200
     3.923   106.867     0.200
     3.942   106.500     0.200
     4.058   109.707     0.200
     4.012   109.559     0.200
     4.297   111.328     0.200
     4.358   115.629     0.200
     4.393   116.129     0.200
     4.417   119.129     0.200
     4.530   120.930     0.200
     4.713   125.289     0.200
     4.823   127.328     0.200
     4.875   126.727     0.200
     4.860   127.309     0.200
     4.950   131.828     0.200
     5.022   131.809     0.200
     5.170   134.168     0.200
     5.294   136.828     0.200
     5.348   135.969     0.200
     5.491   143.129     0.200
     5.583   145.727     0.200
     5.752   148.047     0.200
     5.921   152.027     0.200
     5.950   151.629     0.200
     6.021   158.027     0.200
     6.105   159.328     0.200
     6.104   159.129     0.200
     6.021   155.609     0.200
     6.172   161.527     0.200
     6.092   155.688     0.200
     6.248   163.930     0.200
     6.316   163.527     0.200
     6.361   163.430     0.200
     6.321   163.129     0.200
     6.486   166.930     0.200
     6.618   172.727     0.200
     6.607   173.828     0.200
     6.660   171.527     0.200
     6.704   168.227     0.200
     6.783   173.809     0.200
     6.906   174.027     0.200
     6.988   177.129     0.200
     7.009   177.828     0.200
     7.199   182.043     0.200
     7.493   189.328     0.200
     7.720   194.188     0.200
     7.978   199.328     0.200
     8.040   200.430     0.200
     8.076   205.930     0.200
     8.303   207.027     0.200
     8.346   206.828     0.200
     8.390   209.129     0.200
     8.390   209.129     0.200
     8.472   214.527     0.200
     8.583   211.930     0.200
     8.703   218.027     0.200
     8.722   215.527     0.200
     9.212   232.629     0.200
     9.229   229.930     0.200
     9.229   229.828     0.200
     9.316   231.629     0.200
     9.615   238.328     0.200
     9.681   240.828     0.200
     9.697   239.129     0.200
     9.718   240.430     0.200
     9.890   245.727     0.200
    10.184   254.027     0.200
    10.806   271.227     0.200
    10.916   266.930     0.200
    11.163   273.129     0.200
    18.397   456.527     0.200
     1.009    33.650     0.200
     1.059    36.451     0.200
     1.060    35.350     0.200
     1.419    45.150     0.200
     2.753    77.680     0.200
     2.780    78.371     0.200
     2.810    76.291     0.200
     3.152    87.471     0.200
     3.296    90.871     0.200
     3.319    90.730     0.200
     3.704    98.861     0.200
     4.199   110.861     0.200
     4.309   113.650     0.200
     4.764   121.850     0.200
     5.440   141.850     0.200
     5.520   143.350     0.200
     6.118   158.451     0.200
     6.160   158.250     0.200
     6.852   175.051     0.200
     7.464   190.650     0.200
     7.451   187.350     0.200
     8.666   215.051     0.200
     8.863   220.451     0.200
     9.048   224.850     0.200
    10.028   247.051     0.200
     2.865    79.854     0.200
     2.790    78.205     0.200
     2.966    82.555     0.200
     3.049    84.684     0.200
     3.248    89.615     0.200
     3.269    90.424     0.200
     3.335    91.734     0.200
     3.336    91.434     0.200
     3.464    92.434     0.200
     3.709   100.824     0.200
     3.769   103.734     0.200
     3.878   105.523     0.200
     3.897   104.314     0.200
     3.919   107.834     0.200
     3.989   110.305     0.200
     4.353   115.365     0.200
     4.392   116.334     0.200
     4.487   119.834     0.200
     4.817   123.434     0.200
     4.847   126.135     0.200
     4.817   126.945     0.200
     4.963   128.834     0.200
     4.906   131.734     0.200
     5.265   136.734     0.200
     5.492   142.234     0.200
     5.572   141.834     0.200
     5.893   151.035     0.200
     6.113   158.035     0.200
     6.116   158.635     0.200
     6.168   158.734     0.200
     6.224   163.076     0.200
     6.220   159.635     0.200
     6.259   162.535     0.200
     6.306   163.035     0.200
     6.401   165.234     0.200
     6.635   172.234     0.200
     6.686   169.334     0.200
     6.888   174.834     0.200
     7.019   178.635     0.200
     7.040   178.035     0.200
     7.050   178.834     0.200
     7.197   182.035     0.200
     7.197   182.346     0.200
     7.167   181.934     0.200
     7.316   186.234     0.200
     7.491   189.234     0.200
     7.580   188.234     0.200
     7.706   193.412     0.200
     7.879   198.535     0.200
     8.006   200.035     0.200
     8.093   203.035     0.200
     8.259   208.535     0.200
     8.296   206.834     0.200
     8.369   207.535     0.200
     8.454   213.535     0.200
     8.603   213.135     0.200
     8.704   218.234     0.200
     8.745   217.834     0.200
     9.074   229.334     0.200
     9.231   227.734     0.200
     9.231   228.635     0.200
     9.348   233.635     0.200
     9.645   240.334     0.200
     9.722   240.334     0.200
     0.822    28.570     0.200
     1.177    38.477     0.200
     1.412    44.070     0.200
     1.949    54.305     0.200
     2.560    70.875     0.200
     3.794    98.500     0.200
     3.794   100.445     0.200
     4.138   107.477     0.200
     4.519   114.977     0.200
     5.227   132.773     0.200
     5.873   148.273     0.200
     5.945   151.070     0.200
     5.969   151.977     0.200
     6.078   153.375     0.200
     6.112   155.273     0.200
     6.539   166.477     0.200
     6.569   165.570     0.200
     6.795   169.977     0.200
     7.113   178.570     0.200
     7.134   179.375     0.200
     7.456   185.477     0.200
     8.056   197.875     0.200
     8.346   205.477     0.200
     8.546   212.672     0.200
     8.727   213.977     0.200
     9.437   232.672     0.200
     9.713   239.273     0.200
     9.707   237.477     0.200
     9.825   241.477     0.200
    10.029   247.172     0.200
    10.343   254.570     0.200
     3.262    92.988     0.200
     3.331    94.797     0.200
     3.707   103.996     0.200
     3.874   108.137     0.200
     3.894   108.398     0.200
     4.367   117.078     0.200
     4.470   118.117     0.200
     4.454   119.340     0.200
     4.735   124.180     0.200
     4.831   129.219     0.200
     4.898   131.020     0.200
     4.971   130.316     0.200
     5.507   145.316     0.200
     6.046   161.117     0.200
     6.129   162.020     0.200
     6.182   162.418     0.200
     6.275   166.617     0.200
     6.651   174.020     0.200
     7.211   182.645     0.200
     7.505   189.918     0.200
     8.022   202.617     0.200
     8.385   209.719     0.200
     8.619   216.020     0.200
     8.761   219.816     0.200
     1.036    35.574     0.200
     2.811    77.295     0.200
     4.074   105.645     0.200
     4.239   108.805     0.200
     4.423   115.676     0.200
     4.789   124.336     0.200
     4.948   126.314     0.200
     5.266   134.465     0.200
     5.644   145.275     0.200
     6.060   153.535     0.200
     6.180   156.744     0.200
     6.557   165.676     0.200
     6.625   168.385     0.200
     7.047   177.074     0.200
     7.271   182.074     0.200
     7.582   188.275     0.200
     7.602   189.176     0.200
     7.933   198.574     0.200
     8.513   210.574     0.200
     8.775   217.676     0.200
     8.959   222.074     0.200
     9.158   226.176     0.200
     9.903   242.176     0.200
    10.167   250.176     0.200
    10.148   251.176     0.200
    10.289   251.875     0.200
    10.499   259.074     0.200
    10.817   265.574     0.200
     1.635    51.750     0.200
     2.398    67.061     0.200
     3.792   104.061     0.200
     4.366   116.451     0.200
     4.730   125.080     0.200
     4.792   127.850     0.200
     5.549   146.150     0.200
     6.002   157.250     0.200
     6.085   159.150     0.200
     6.088   159.051     0.200
     6.143   161.250     0.200
     6.231   162.750     0.200
     6.606   171.750     0.200
     7.171   182.451     0.200
     7.465   189.650     0.200
     8.340   206.250     0.200
     8.575   212.451     0.200
     8.717   214.451     0.200
     9.509   233.350     0.200
     9.693   237.350     0.200
     3.045    84.594     0.200
     3.332    92.109     0.200
     3.584    99.078     0.200
     3.550    97.133     0.200
     3.573    98.180     0.200
     3.702   101.273     0.200
     3.823   104.078     0.200
     3.846   104.469     0.200
     3.960   107.695     0.200
     4.393   116.523     0.200
     4.327   116.477     0.200
     4.391   117.898     0.200
     4.447   119.180     0.200
     4.699   124.156     0.200
     5.060   134.023     0.200
     5.115   133.797     0.200
     5.519   145.727     0.200
     5.729   148.727     0.200
     5.959   151.328     0.200
     5.988   155.648     0.200
     6.028   154.523     0.200
     6.144   161.930     0.200
     6.305   164.227     0.200
     6.361   160.125     0.200
     6.378   163.125     0.200
     6.601   171.727     0.200
     6.862   179.023     0.200
     7.235   184.227     0.200
     7.876   200.328     0.200
     8.115   205.125     0.200
     8.168   206.930     0.200
     0.886    29.664     0.200
     1.115    36.766     0.200
     1.234    40.766     0.200
     1.453    45.062     0.200
     1.458    47.164     0.200
     1.614    50.266     0.200
     2.023    58.570     0.200
     2.439    67.062     0.200
     4.732   123.062     0.200
     5.017   129.312     0.200
     5.092   131.664     0.200
     5.765   149.242     0.200
     5.844   149.555     0.200
     6.446   165.070     0.200
     7.651   192.062     0.200
     7.792   195.961     0.200
     8.938   221.164     0.200
     9.318   230.367     0.200
     0.861    29.164     0.200
     0.904    30.961     0.200
     0.959    32.859     0.200
     1.009    33.359     0.200
     1.031    32.758     0.200
     1.011    33.062     0.200
     1.072    35.062     0.200
     1.154    37.859     0.200
     1.196    37.359     0.200
     2.691    73.594     0.200
     2.982    80.562     0.200
     3.091    84.664     0.200
     3.199    88.820     0.200
     3.391    93.109     0.200
     3.597    95.773     0.200
     3.706   100.531     0.200
     4.056   105.164     0.200
     4.191   110.664     0.200
     4.280   112.164     0.200
     4.371   110.805     0.200
     4.429   114.703     0.200
     4.429   115.438     0.200
     4.464   114.039     0.200
     4.564   119.188     0.200
     4.562   115.664     0.200
     4.648   122.227     0.200
     5.330   134.672     0.200
     5.392   141.594     0.200
     6.003   155.289     0.200
     6.003   152.258     0.200
     6.021   157.406     0.200
     6.104   157.773     0.200
     6.130   160.102     0.200
     6.274   162.836     0.200
     6.320   163.914     0.200
     6.386   161.258     0.200
     6.403   163.961     0.200
     6.706   173.086     0.200
     6.706   171.062     0.200
     6.962   173.664     0.200
     6.991   175.461     0.200
     7.049   175.859     0.200
     7.049   176.922     0.200
     7.284   181.461     0.200
     7.304   181.859     0.200
     7.346   182.562     0.200
     8.107   201.562     0.200
     8.139   205.461     0.200
     8.186   201.258     0.200
     8.228   203.664     0.200
     8.517   210.664     0.200
     8.716   215.062     0.200
     8.763   215.359     0.200
     8.899   219.164     0.200
     9.140   224.758     0.200
     9.608   236.562     0.200
     9.879   242.758     0.200
     9.885   243.062     0.200
     9.880   244.016     0.200
     9.974   245.359     0.200
     9.997   245.461     0.200
    10.512   258.359     0.200
     3.059    83.930     0.200
     3.423    94.930     0.200
     3.621    99.828     0.200
     3.666   101.289     0.200
     3.816   101.414     0.200
     3.857   106.531     0.200
     3.894   107.789     0.200
     3.958   107.891     0.200
     3.994   109.242     0.200
     4.061   108.930     0.200
     4.367   118.656     0.200
     4.503   121.672     0.200
     4.536   122.930     0.200
     5.219   138.547     0.200
     5.325   138.508     0.200
     5.402   141.203     0.200
     5.812   152.664     0.200
     5.882   150.531     0.200
     6.014   155.328     0.200
     6.038   153.930     0.200
     6.239   162.695     0.200
     6.295   164.352     0.200
     6.320   165.383     0.200
     6.437   167.008     0.200
     6.554   170.133     0.200
     6.740   176.484     0.200
     7.557   191.359     0.200
     7.847   200.531     0.200
     7.920   200.133     0.200
     1.857    53.656     0.200
     2.817    77.359     0.200
     2.839    80.062     0.200
     2.872    78.898     0.200
     3.014    84.461     0.200
     3.098    86.961     0.200
     3.296    91.562     0.200
     3.319    92.062     0.200
     3.381    94.062     0.200
     3.385    93.656     0.200
     3.385    93.656     0.200
     3.755   102.461     0.200
     3.928   107.258     0.200
     3.946   107.156     0.200
     3.946   107.156     0.200
     4.057   108.258     0.200
     4.057   108.359     0.200
     4.160   110.258     0.200
     4.357   115.359     0.200
     4.391   115.961     0.200
     4.498   117.562     0.200
     4.821   124.547     0.200
     4.867   127.859     0.200
     5.010   130.219     0.200
     5.022   130.062     0.200
     5.320   138.000     0.200
     5.489   141.469     0.200
     5.582   141.219     0.200
     6.119   156.156     0.200
     6.171   159.680     0.200
     6.193   158.359     0.200
     6.202   157.891     0.200
     6.245   161.266     0.200
     6.281   160.227     0.200
     6.281   160.297     0.200
     6.478   167.625     0.200
     6.616   164.156     0.200
     6.906   173.758     0.200
     6.983   173.258     0.200
     7.004   173.656     0.200
     7.068   179.156     0.200
     7.198   182.891     0.200
     7.198   182.375     0.200
     7.273   180.156     0.200
     7.372   185.758     0.200
     7.491   188.758     0.200
     7.973   196.359     0.200
     8.050   198.656     0.200
     8.301   206.656     0.200
     8.308   209.359     0.200
     8.342   205.062     0.200
     8.472   212.359     0.200
     8.579   210.961     0.200
     8.718   214.258     0.200
     9.205   233.656     0.200
     9.311   228.859     0.200
     9.508   233.258     0.200
     9.611   235.859     0.200
     9.693   237.859     0.200
     9.713   237.961     0.200
     9.885   242.156     0.200
     0.707    25.891     0.200
     0.844    27.988     0.200
     0.884    28.988     0.200
     2.575    72.391     0.200
     2.754    73.719     0.200
     3.170    87.289     0.200
     3.190    87.688     0.200
     3.190    87.688     0.200
     4.360   112.488     0.200
     4.362   112.160     0.200
     4.702   122.254     0.200
     4.982   128.793     0.200
     5.361   137.840     0.200
     6.036   154.840     0.200
     6.055   154.492     0.200
     6.136   157.188     0.200
     6.279   160.824     0.200
     6.396   163.508     0.200
     6.470   165.320     0.200
     6.553   165.289     0.200
     6.848   173.523     0.200
     6.940   171.391     0.200
     6.942   172.188     0.200
     7.107   177.289     0.200
     7.165   175.688     0.200
     7.404   184.488     0.200
     7.478   184.590     0.200
     7.499   184.891     0.200
     8.412   206.688     0.200
     8.681   212.590     0.200
     8.869   216.988     0.200
     9.064   221.090     0.200
     9.612   240.789     0.200
     9.800   238.988     0.200
     9.883   242.391     0.200
    10.066   245.688     0.200
    10.186   248.789     0.200
     0.672    23.578     0.200
     0.662    23.277     0.200
     0.695    24.777     0.200
     0.770    26.977     0.200
     0.761    25.977     0.200
     0.764    25.875     0.200
     0.840    29.375     0.200
     1.032    33.875     0.200
     1.045    34.176     0.200
     1.524    44.578     0.200
     2.339    65.277     0.200
     2.576    70.875     0.200
     2.569    71.277     0.200
     2.748    75.176     0.200
     2.779    76.078     0.200
     2.826    77.176     0.200
     2.863    77.977     0.200
     2.863    77.977     0.200
     2.965    80.176     0.200
     3.197    84.578     0.200
     3.331    88.977     0.200
     3.409    91.375     0.200
     3.455    91.875     0.200
     3.455    91.875     0.200
     3.923   103.508     0.200
     4.199   108.496     0.200
     4.344   112.875     0.200
     4.669   124.676     0.200
     5.038   126.477     0.200
     5.056   130.750     0.200
     5.165   134.676     0.200
     5.311   138.168     0.200
     5.800   151.008     0.200
     6.419   163.961     0.200
     6.410   162.070     0.200
     6.472   160.578     0.200
     6.502   166.984     0.200
     6.530   166.531     0.200
     6.542   167.176     0.200
     6.691   169.676     0.200
     6.710   172.777     0.200
     6.909   177.879     0.200
     6.982   172.875     0.200
     7.085   179.625     0.200
     7.092   182.277     0.200
     7.226   178.477     0.200
     7.344   184.176     0.200
     7.457   186.277     0.200
     7.457   186.824     0.200
     7.577   187.277     0.200
     7.597   187.777     0.200
     7.754   194.578     0.200
     7.885   193.977     0.200
     7.873   196.777     0.200
     8.105   197.578     0.200
     8.546   209.676     0.200
     8.554   215.977     0.200
     8.559   212.777     0.200
     8.779   211.875     0.200
     8.870   217.777     0.200
     9.083   223.078     0.200
     9.250   226.477     0.200
     9.904   242.578     0.200
     9.925   242.875     0.200
    10.054   245.875     0.200
    10.191   249.375     0.200
    10.232   249.977     0.200
    10.269   250.875     0.200
    10.301   251.676     0.200
    10.485   256.277     0.200
    10.786   263.578     0.200
    11.415   278.176     0.200
    11.672   284.277     0.200
     0.649    22.172     0.200
     0.772    26.477     0.200
     0.755    25.672     0.200
     0.758    25.875     0.200
     0.844    29.570     0.200
     0.925    31.570     0.200
     0.941    31.773     0.200
     0.953    31.172     0.200
     1.028    33.672     0.200
     1.039    33.977     0.200
     2.863    77.570     0.200
     3.653    98.672     0.200
     4.205   108.492     0.200
     5.041   126.273     0.200
     6.425   164.961     0.200
     6.416   163.703     0.200
     6.476   160.773     0.200
     6.986   172.672     0.200
     7.231   178.875     0.200
     7.582   187.477     0.200
     7.602   187.977     0.200
     7.760   194.773     0.200
     7.796   192.070     0.200
     7.890   194.570     0.200
     8.552   210.477     0.200
     8.876   218.273     0.200
     9.089   223.477     0.200
     9.256   227.375     0.200
     9.909   242.773     0.200
    10.196   249.773     0.200
    10.275   251.477     0.200
    11.421   279.070     0.200
     1.223    39.234     0.200
     1.398    44.234     0.200
     2.929    80.273     0.200
     2.998    84.133     0.200
     3.077    86.133     0.200
     3.148    87.836     0.200
     3.236    90.031     0.200
     3.273    90.734     0.200
     3.278    90.734     0.200
     3.296    91.234     0.200
     3.365    93.031     0.200
     3.365    93.031     0.200
     3.366    93.133     0.200
     3.740   101.531     0.200
     3.907   106.234     0.200
     3.927   106.633     0.200
     3.927   106.633     0.200
     3.964   105.695     0.200
     5.030   131.898     0.200
     5.343   139.766     0.200
     5.509   144.445     0.200
     5.596   145.891     0.200
     6.107   159.172     0.200
     6.125   160.273     0.200
     6.188   159.320     0.200
     6.270   162.883     0.200
     6.294   162.359     0.200
     6.503   168.359     0.200
     6.641   170.977     0.200
     7.510   188.836     0.200
     8.002   200.930     0.200
     8.370   209.336     0.200
     8.607   213.734     0.200
     8.746   217.031     0.200
     9.426   234.633     0.200
     9.537   236.234     0.200
     9.640   241.234     0.200
     9.872   247.336     0.200
     1.985    53.918     0.200
     2.664    74.018     0.200
     2.710    74.398     0.200
     3.215    88.938     0.200
     3.296    91.738     0.200
     3.474    96.138     0.200
     3.488    96.238     0.200
     3.488    96.238     0.200
     3.627    96.338     0.200
     3.737    96.658     0.200
     4.126   108.898     0.200
     4.141   108.828     0.200
     4.428   114.678     0.200
     4.549   119.218     0.200
     4.786   122.038     0.200
     4.761   125.388     0.200
     4.913   128.538     0.200
     5.285   137.238     0.200
     5.400   139.738     0.200
     6.012   156.838     0.200
     6.060   156.738     0.200
     6.125   160.038     0.200
     6.166   155.038     0.200
     6.260   163.538     0.200
     6.502   168.338     0.200
     6.682   170.338     0.200
     6.895   172.338     0.200
     7.067   176.436     0.200
     7.052   178.638     0.200
     7.225   180.538     0.200
     7.245   180.538     0.200
     7.363   184.038     0.200
     7.480   187.023     0.200
     8.133   201.738     0.200
     8.177   202.938     0.200
     8.479   210.038     0.200
     8.685   214.838     0.200
     8.860   218.938     0.200
     9.534   235.138     0.200
     9.550   235.438     0.200
     9.670   238.538     0.200
     9.826   242.538     0.200
     2.701    74.788     0.200
     2.810    79.288     0.200
     2.817    79.588     0.200
     2.817    79.588     0.200
     3.099    86.688     0.200
     3.183    88.288     0.200
     3.358    93.288     0.200
     3.372    93.288     0.200
     3.372    93.288     0.200
     3.603    96.588     0.200
     3.677    98.548     0.200
     3.802   101.088     0.200
     3.929   104.188     0.200
     4.657   124.155     0.200
     4.915   131.663     0.200
     4.893   124.788     0.200
     5.303   138.678     0.200
     6.012   157.015     0.200
     6.027   157.125     0.200
     6.036   157.309     0.200
     6.119   160.560     0.200
     6.161   160.854     0.200
     6.261   156.988     0.200
     6.289   164.226     0.200
     6.533   170.713     0.200
     6.723   175.992     0.200
     6.749   169.388     0.200
     6.808   170.188     0.200
     7.305   182.988     0.200
     7.325   183.988     0.200
     7.355   183.788     0.200
     8.249   205.788     0.200
     8.536   212.388     0.200
     8.734   217.988     0.200
     8.918   221.888     0.200
     9.590   237.588     0.200
     9.629   238.388     0.200
     9.732   241.488     0.200
     9.900   244.488     0.200
     9.995   246.788     0.200
    10.221   251.288     0.200
     1.351    43.687     0.200
     1.342    43.027     0.200
     1.656    51.927     0.200
     1.638    52.187     0.200
     2.426    68.847     0.200
     2.648    73.727     0.200
     2.956    82.327     0.200
     3.003    84.847     0.200
     3.443    94.327     0.200
     3.443    94.427     0.200
     3.443    93.897     0.200
     3.698   101.327     0.200
     3.698    98.967     0.200
     3.780   106.327     0.200
     3.922   109.227     0.200
     3.922   103.947     0.200
     3.925   109.027     0.200
     3.988   111.027     0.200
     4.043   112.427     0.200
     4.328   117.787     0.200
     4.407   119.597     0.200
     4.611   121.857     0.200
     4.659   123.927     0.200
     4.623   123.777     0.200
     4.718   123.287     0.200
     4.740   124.817     0.200
     4.808   126.257     0.200
     4.873   129.007     0.200
     4.870   129.117     0.200
     4.922   131.147     0.200
     5.184   135.777     0.200
     5.456   144.797     0.200
     5.497   146.483     0.200
     5.453   143.887     0.200
     5.532   147.018     0.200
     5.840   153.050     0.200
     5.826   151.527     0.200
     6.011   157.969     0.200
     6.045   157.137     0.200
     6.175   157.527     0.200
     6.535   171.608     0.200
     6.603   167.327     0.200
     6.587   173.677     0.200
     6.632   172.227     0.200
     6.669   171.297     0.200
     6.692   174.381     0.200
     6.688   173.878     0.200
     6.757   177.110     0.200
     6.723   174.347     0.200
     6.977   176.327     0.200
     6.999   181.852     0.200
     6.988   181.229     0.200
     7.112   184.857     0.200
     7.379   186.427     0.200
     7.400   187.027     0.200
     7.379   185.727     0.200
     7.471   189.127     0.200
     7.540   192.527     0.200
     7.588   195.397     0.200
     7.629   192.827     0.200
     7.709   195.767     0.200
     7.717   194.827     0.200
     7.717   194.827     0.200
     7.813   197.827     0.200
     7.947   202.527     0.200
     8.011   202.327     0.200
     8.210   205.922     0.200
     8.210   207.227     0.200
     8.386   210.727     0.200
     8.397   210.327     0.200
     8.685   217.327     0.200
     8.807   220.127     0.200
     8.786   224.627     0.200
     8.962   225.967     0.200
     9.060   225.727     0.200
     9.224   231.827     0.200
     9.706   241.827     0.200
     9.772   241.720     0.200
     9.958   247.627     0.200
    10.024   249.827     0.200
    10.149   252.727     0.200
    10.221   259.927     0.200
    18.428   458.927     0.200
     1.855    61.010     0.200
     2.662    72.680     0.200
     3.184    90.710     0.200
     3.391    92.870     0.200
     3.408    93.900     0.200
     3.385    96.010     0.200
     3.432    97.110     0.200
     3.457    97.311     0.200
     3.573   100.311     0.200
     3.794   106.311     0.200
     3.934   107.510     0.200
     3.939   108.811     0.200
     4.002   110.510     0.200
     4.057   112.311     0.200
     4.148   114.410     0.200
     4.254   116.410     0.200
     4.337   116.500     0.200
     4.426   117.740     0.200
     4.418   116.141     0.200
     4.651   120.710     0.200
     5.190   135.990     0.200
     5.344   140.345     0.200
     5.466   145.370     0.200
     5.506   147.048     0.200
     5.538   144.484     0.200
     5.845   153.347     0.200
     6.017   156.646     0.200
     6.092   157.600     0.200
     6.169   156.710     0.200
     6.539   170.350     0.200
     6.596   167.010     0.200
     6.624   167.410     0.200
     6.589   174.566     0.200
     6.582   167.510     0.200
     6.693   173.735     0.200
     6.695   173.067     0.200
     6.760   175.726     0.200
     6.787   173.716     0.200
     6.972   175.610     0.200
     6.990   182.020     0.200
     7.114   185.732     0.200
     7.396   186.710     0.200
     7.464   187.210     0.200
     7.624   191.910     0.200
     7.724   194.226     0.200
     8.018   202.910     0.200
     8.394   210.110     0.200
     8.806   220.710     0.200
     9.777   246.241     0.200
     1.428    47.301     0.200
     1.748    52.701     0.200
     3.404    92.891     0.200
     3.394    95.801     0.200
     3.441    97.201     0.200
     3.464    95.301     0.200
     3.464    97.602     0.200
     3.583   100.801     0.200
     3.802   106.301     0.200
     3.949   109.701     0.200
     4.009   110.701     0.200
     4.065   112.201     0.200
     4.159   112.002     0.200
     4.349   116.740     0.200
     4.438   117.961     0.200
     4.652   119.400     0.200
     4.776   127.441     0.200
     4.756   124.361     0.200
     5.518   146.740     0.200
     5.856   153.516     0.200
     6.598   165.900     0.200
     6.626   166.801     0.200
     6.702   174.619     0.200
     6.708   175.115     0.200
     6.800   175.908     0.200
     7.467   187.201     0.200
     7.737   195.576     0.200
     7.838   197.301     0.200
     8.031   203.400     0.200
     8.814   218.900     0.200
     9.069   224.801     0.200
    10.027   248.102     0.200
    10.118   250.002     0.200
     1.750    55.293     0.200
     2.285    65.379     0.200
     2.288    65.539     0.200
     2.819    78.176     0.200
     2.839    80.277     0.200
     3.016    84.379     0.200
     3.097    86.379     0.200
     3.167    88.078     0.200
     3.255    90.379     0.200
     3.293    91.578     0.200
     3.297    90.879     0.200
     3.316    91.777     0.200
     3.385    92.477     0.200
     3.385    93.277     0.200
     3.384    93.379     0.200
     3.674   100.277     0.200
     3.758   102.477     0.200
     3.841   102.797     0.200
     3.927   106.477     0.200
     3.947   107.078     0.200
     4.021   108.777     0.200
     4.125   108.176     0.200
     4.258   112.777     0.200
     4.366   116.078     0.200
     4.503   119.078     0.200
     4.706   125.578     0.200
     5.005   131.098     0.200
     5.027   131.867     0.200
     5.020   132.676     0.200
     5.310   139.844     0.200
     5.506   145.031     0.200
     5.641   148.879     0.200
     6.036   156.844     0.200
     6.098   159.629     0.200
     6.119   157.438     0.200
     6.118   159.055     0.200
     6.188   159.191     0.200
     6.218   160.043     0.200
     6.262   163.258     0.200
     6.297   160.852     0.200
     6.495   169.574     0.200
     6.631   171.691     0.200
     7.215   182.703     0.200
     7.508   189.477     0.200
     2.312    65.945     0.200
     2.633    72.625     0.200
     2.635    73.984     0.200
     2.678    74.504     0.200
     2.823    76.598     0.200
     2.882    80.145     0.200
     2.976    83.805     0.200
     3.024    84.957     0.200
     3.182    85.477     0.200
     3.181    87.324     0.200
     3.185    88.527     0.200
     3.383    93.125     0.200
     3.430    94.527     0.200
     3.549    94.098     0.200
     3.514    96.125     0.200
     3.611    99.125     0.200
     3.617    99.027     0.200
     3.625    99.027     0.200
     3.656    99.426     0.200
     3.722   100.426     0.200
     3.722   101.227     0.200
     3.757   101.727     0.200
     3.922   108.324     0.200
     4.029   109.027     0.200
     4.064   111.234     0.200
     4.148   111.914     0.200
     4.164   111.395     0.200
     4.130   111.027     0.200
     4.235   113.625     0.200
     4.261   114.227     0.200
     4.267   114.625     0.200
     4.295   116.375     0.200
     4.298   114.926     0.200
     4.348   119.254     0.200
     4.438   115.914     0.200
     4.490   119.227     0.200
     4.495   119.727     0.200
     4.495   122.195     0.200
     4.649   123.004     0.200
     4.738   124.727     0.200
     5.114   133.879     0.200
     5.268   139.711     0.200
     5.261   136.727     0.200
     5.299   140.578     0.200
     5.742   147.027     0.200
     5.905   154.801     0.200
     6.173   156.324     0.200
     6.204   158.727     0.200
     6.209   162.969     0.200
     6.233   163.836     0.200
     6.276   165.219     0.200
     6.291   165.344     0.200
     6.418   170.066     0.200
     6.457   168.789     0.200
     6.545   166.125     0.200
     6.558   167.973     0.200
     6.609   172.582     0.200
     6.643   173.621     0.200
     6.745   175.668     0.200
     6.951   175.926     0.200
     6.973   176.824     0.200
     7.040   177.625     0.200
     7.055   177.125     0.200
     7.197   181.527     0.200
     7.220   181.988     0.200
     7.423   188.926     0.200
     7.471   189.000     0.200
     7.746   197.426     0.200
     7.763   196.625     0.200
     7.880   203.324     0.200
     7.954   198.527     0.200
     7.977   200.926     0.200
     8.055   201.488     0.200
     8.255   207.027     0.200
     8.406   210.926     0.200
     8.524   215.227     0.200
     8.672   217.625     0.200
     8.777   218.625     0.200
     9.274   231.227     0.200
     9.277   232.125     0.200
     9.462   235.926     0.200
     9.548   238.527     0.200
     9.600   240.027     0.200
     9.641   239.824     0.200
     9.690   240.926     0.200
     9.743   242.426     0.200
     9.834   245.125     0.200
    10.112   252.027     0.200
    10.208   254.824     0.200
    10.204   254.973     0.200
    10.303   255.824     0.200
    10.607   263.926     0.200
    10.633   262.926     0.200
    10.757   275.926     0.200
    11.001   272.527     0.200
    11.236   277.824     0.200
    11.757   291.125     0.200
    11.721   297.926     0.200
    12.574   311.727     0.200
    12.865   316.527     0.200
    12.908   318.625     0.200
    13.877   341.727     0.200
    14.127   347.324     0.200
    14.350   354.727     0.200
    15.786   394.926     0.200
    15.841   396.926     0.200
    20.867   518.125     0.200
     1.027    35.102     0.200
     1.132    38.102     0.200
     2.317    66.352     0.200
     2.428    67.789     0.200
     2.640    72.242     0.200
     2.642    74.156     0.200
     2.682    74.516     0.200
     2.826    79.086     0.200
     2.982    83.781     0.200
     3.027    82.453     0.200
     3.189    87.258     0.200
     3.187    87.711     0.200
     3.386    92.406     0.200
     3.432    93.406     0.200
     3.516    95.406     0.200
     3.556    93.641     0.200
     3.614    97.812     0.200
     3.618    98.211     0.200
     3.626    98.109     0.200
     3.658    98.812     0.200
     3.724   100.312     0.200
     3.760   101.508     0.200
     4.031   107.711     0.200
     4.133   110.109     0.200
     4.237   113.609     0.200
     4.289   115.148     0.200
     4.268   114.008     0.200
     4.301   114.711     0.200
     4.648   122.242     0.200
     5.275   139.484     0.200
     6.176   155.609     0.200
     6.207   158.812     0.200
     6.216   163.805     0.200
     6.239   164.469     0.200
     6.463   167.945     0.200
     6.616   173.359     0.200
     6.649   174.539     0.200
     6.956   176.008     0.200
     7.478   189.844     0.200
     7.752   197.211     0.200
     7.769   197.812     0.200
     7.982   198.711     0.200
     8.412   209.406     0.200
     8.678   215.711     0.200
     9.695   239.508     0.200
     2.639    73.375     0.200
     2.646    75.125     0.200
     2.845    78.414     0.200
     2.989    83.234     0.200
     3.047    84.133     0.200
     3.186    87.914     0.200
     3.746    99.398     0.200
     3.746    99.727     0.200
     4.424   115.492     0.200
     4.760   124.695     0.200
     5.263   135.594     0.200
     6.243   159.594     0.200
     6.362   162.094     0.200
     7.471   187.211     0.200
     1.161    38.312     0.200
     2.435    66.930     0.200
     2.640    73.312     0.200
     2.648    74.117     0.200
     2.992    83.078     0.200
     3.054    82.891     0.200
     3.210    86.219     0.200
     3.216    88.922     0.200
     3.286    90.867     0.200
     3.412    93.820     0.200
     3.461    94.922     0.200
     3.544    97.320     0.200
     3.641    99.719     0.200
     3.648    99.523     0.200
     3.656    99.820     0.200
     3.685   100.320     0.200
     3.753   100.523     0.200
     3.753   102.422     0.200
     3.785   103.320     0.200
     3.918   104.922     0.200
     3.952   104.312     0.200
     4.058   109.617     0.200
     4.096   108.719     0.200
     4.158   111.523     0.200
     4.297   115.422     0.200
     4.328   116.023     0.200
     4.430   117.023     0.200
     4.519   119.117     0.200
     4.766   123.523     0.200
     5.117   135.828     0.200
     5.267   138.555     0.200
     5.303   140.125     0.200
     5.528   144.734     0.200
     5.707   148.352     0.200
     5.911   154.344     0.200
     6.046   159.398     0.200
     6.201   162.445     0.200
     6.222   162.992     0.200
     6.250   159.523     0.200
     6.267   165.648     0.200
     6.283   165.008     0.200
     6.369   161.820     0.200
     6.409   168.758     0.200
     6.458   168.711     0.200
     6.633   174.328     0.200
     6.732   176.828     0.200
     7.012   174.219     0.200
     7.762   195.617     0.200
     7.759   193.820     0.200
     8.389   205.820     0.200
     8.657   213.422     0.200
     1.788    51.891     0.200
     2.391    67.971     0.200
     2.694    74.822     0.200
     2.791    75.631     0.200
     3.030    84.092     0.200
     3.225    85.842     0.200
     3.214    88.102     0.200
     3.187    88.041     0.200
     3.283    88.162     0.200
     3.293    89.672     0.200
     3.430    94.041     0.200
     3.516    96.141     0.200
     3.583    96.561     0.200
     3.615    98.242     0.200
     3.615    98.441     0.200
     3.621    98.941     0.200
     3.660   100.041     0.200
     3.722   100.602     0.200
     3.722   100.941     0.200
     3.924   105.592     0.200
     4.137   111.441     0.200
     4.180   111.301     0.200
     4.255   112.242     0.200
     4.267   114.342     0.200
     4.301   115.242     0.200
     4.492   119.072     0.200
     4.896   124.262     0.200
     5.062   134.652     0.200
     5.115   132.291     0.200
     5.245   137.242     0.200
     5.331   141.160     0.200
     5.768   147.842     0.200
     6.196   156.941     0.200
     6.226   157.941     0.200
     6.244   164.260     0.200
     6.311   165.393     0.200
     6.350   164.734     0.200
     6.304   160.996     0.200
     6.490   167.184     0.200
     6.490   167.660     0.200
     6.572   166.242     0.200
     6.621   169.311     0.200
     6.980   176.242     0.200
     7.002   176.641     0.200
     7.064   178.842     0.200
     7.224   181.441     0.200
     7.288   182.541     0.200
     7.700   199.541     0.200
     7.772   196.242     0.200
     7.796   196.342     0.200
     7.819   197.441     0.200
     7.830   202.141     0.200
     7.979   199.941     0.200
     8.007   200.342     0.200
     8.086   202.342     0.200
     8.278   207.242     0.200
     8.439   210.742     0.200
     8.603   219.242     0.200
     8.706   217.041     0.200
     8.686   219.441     0.200
     8.810   219.342     0.200
     8.743   220.941     0.200
     9.133   236.941     0.200
     9.293   231.342     0.200
    10.002   250.441     0.200
     3.029    83.533     0.200
     3.188    88.072     0.200
     3.431    93.973     0.200
     3.517    96.773     0.200
     3.615    98.572     0.200
     3.616    98.973     0.200
     3.623    99.273     0.200
     3.660    99.873     0.200
     3.723   101.373     0.200
     4.136   111.172     0.200
     4.171   110.713     0.200
     4.249   113.172     0.200
     4.268   114.773     0.200
     4.301   115.773     0.200
     5.760   148.873     0.200
     5.765   150.824     0.200
     6.219   158.973     0.200
     6.340   164.756     0.200
     6.481   168.840     0.200
     6.564   167.572     0.200
     6.971   178.973     0.200
     6.993   180.072     0.200
     7.216   184.572     0.200
     7.280   182.672     0.200
     7.280   183.072     0.200
     7.765   197.473     0.200
     7.787   196.373     0.200
     7.971   202.072     0.200
    10.185   252.152     0.200
     4.852   123.918     0.200
     7.963   199.518     0.200
     8.890   220.518     0.200
     9.266   229.418     0.200
     2.726    76.625     0.200
     2.726    77.727     0.200
     2.905    80.625     0.200
     2.905    82.125     0.200
     2.984    84.324     0.200
     3.054    85.824     0.200
     3.142    88.426     0.200
     3.185    87.625     0.200
     3.185    89.324     0.200
     3.204    88.625     0.200
     3.204    89.227     0.200
     3.274    91.023     0.200
     3.271    91.227     0.200
     3.648   100.625     0.200
     3.648   100.426     0.200
     3.771   103.227     0.200
     3.804   103.613     0.200
     3.814   104.426     0.200
     3.834   105.125     0.200
     3.881   107.078     0.200
     3.904   104.496     0.200
     3.967   103.355     0.200
     4.034   107.078     0.200
     4.098   108.613     0.200
     4.383   116.227     0.200
     4.676   124.613     0.200
     4.717   124.824     0.200
     4.814   128.387     0.200
     4.840   129.824     0.200
     4.933   130.324     0.200
     4.973   130.145     0.200
     5.017   132.340     0.200
     5.343   141.273     0.200
     5.327   140.227     0.200
     5.498   143.727     0.200
     5.560   143.184     0.200
     5.560   143.438     0.200
     5.642   147.227     0.200
     5.879   153.523     0.200
     6.123   159.867     0.200
     6.131   160.031     0.200
     6.137   158.547     0.200
     6.166   159.094     0.200
     6.166   159.449     0.200
     6.254   164.469     0.200
     6.187   160.125     0.200
     6.256   161.051     0.200
     6.280   165.801     0.200
     6.515   170.422     0.200
     6.530   169.227     0.200
     6.555   168.727     0.200
     6.662   174.410     0.200
     6.665   168.727     0.200
     6.866   173.125     0.200
     7.197   182.629     0.200
     7.197   183.051     0.200
     7.270   178.227     0.200
     7.289   185.227     0.200
     7.319   186.523     0.200
     7.367   182.023     0.200
     7.426   187.824     0.200
     7.492   189.426     0.200
     7.585   191.797     0.200
     7.690   192.820     0.200
     7.690   193.727     0.200
     8.012   201.023     0.200
     8.089   199.523     0.200
     8.123   207.328     0.200
     8.271   209.426     0.200
     8.291   207.926     0.200
     8.406   207.125     0.200
     8.636   214.426     0.200
     8.641   225.023     0.200
     8.783   216.523     0.200
     9.462   231.625     0.200
     9.692   237.926     0.200
     9.702   245.625     0.200
     9.762   238.727     0.200
     9.797   241.125     0.200
     9.798   238.926     0.200
    10.069   250.316     0.200
    10.415   253.426     0.200
    10.415   253.227     0.200
    10.969   266.727     0.200
    11.219   273.324     0.200
    19.526   486.625     0.200
     0.834    28.613     0.200
     0.944    31.773     0.200
     0.939    31.645     0.200
     0.947    31.734     0.200
     1.016    34.582     0.200
     0.993    32.902     0.200
     1.014    33.242     0.200
     1.626    47.773     0.200
     1.899    53.402     0.200
     1.955    56.453     0.200
     2.059    58.434     0.200
     2.114    59.781     0.200
     2.168    60.984     0.200
     2.235    62.191     0.200
     2.366    65.031     0.200
     3.269    91.102     0.200
     3.364    93.305     0.200
     3.519    97.203     0.200
     3.541    97.703     0.200
     3.977   105.012     0.200
     4.163   109.113     0.200
     4.435   115.203     0.200
     4.777   125.141     0.200
     4.789   121.203     0.200
     4.916   125.883     0.200
     5.016   129.461     0.200
     5.382   139.465     0.200
     5.485   140.176     0.200
     5.503   143.004     0.200
     6.105   158.195     0.200
     6.132   156.520     0.200
     6.172   160.176     0.200
     6.188   159.684     0.200
     6.206   160.086     0.200
     6.211   160.359     0.200
     6.350   165.375     0.200
     6.369   164.852     0.200
     6.591   170.883     0.200
     6.719   169.203     0.200
     6.745   171.102     0.200
     6.764   172.516     0.200
     6.931   174.102     0.200
     7.092   177.602     0.200
     7.174   179.902     0.200
     7.162   179.602     0.200
     7.271   182.504     0.200
     7.291   182.402     0.200
     7.470   186.805     0.200
     7.517   187.805     0.200
     7.591   188.305     0.200
     8.232   204.902     0.200
     8.549   212.004     0.200
     8.761   217.703     0.200
     8.929   220.602     0.200
     9.597   236.602     0.200
     9.604   237.602     0.200
     9.735   240.305     0.200
     9.879   243.902     0.200
     9.876   244.207     0.200
     9.963   246.402     0.200
     9.991   247.004     0.200
    10.182   251.102     0.200
     1.257    39.930     0.200
     1.407    44.090     0.200
     1.481    46.199     0.200
     1.488    47.102     0.200
     4.383   116.668     0.200
     4.760   125.723     0.200
     4.899   129.664     0.200
     5.000   133.750     0.200
     5.366   139.309     0.200
     5.467   144.336     0.200
     5.486   144.605     0.200
     6.090   159.020     0.200
     6.115   160.703     0.200
     6.186   157.379     0.200
     7.512   186.680     0.200
     8.223   205.078     0.200
     8.538   210.980     0.200
     8.748   217.879     0.200
     8.917   219.980     0.200
     9.870   243.480     0.200
     1.989    56.844     0.200
     2.199    61.992     0.200
     2.431    68.734     0.200
     2.483    68.734     0.200
     2.705    74.461     0.200
     3.056    82.852     0.200
     3.245    86.844     0.200
     4.300   112.832     0.200
     5.084   132.363     0.200
     5.121   132.164     0.200
     5.127   132.461     0.200
     5.215   134.863     0.200
     5.251   135.164     0.200
     5.280   135.961     0.200
     5.443   140.062     0.200
     5.692   147.762     0.200
     5.825   150.562     0.200
     6.003   154.664     0.200
     6.138   158.262     0.200
     6.138   158.164     0.200
     6.426   162.578     0.200
     7.394   183.277     0.200
     7.498   188.863     0.200
     7.688   193.461     0.200
     9.942   246.094     0.200
     2.075    61.070     0.200
     2.240    63.062     0.200
     2.455    68.953     0.200
     2.471    69.508     0.200
     2.632    74.320     0.200
     2.684    74.898     0.200
     2.785    77.523     0.200
     2.997    84.617     0.200
     3.028    83.391     0.200
     3.010    85.023     0.200
     3.099    84.320     0.200
     3.212    87.844     0.200
     3.197    89.617     0.200
     3.261    91.117     0.200
     3.338    93.117     0.200
     3.415    92.797     0.200
     3.429    92.727     0.200
     3.431    95.320     0.200
     3.452    95.820     0.200
     3.468    96.023     0.200
     3.474    96.422     0.200
     3.515    94.742     0.200
     3.551    97.922     0.200
     3.551    98.320     0.200
     3.568    98.719     0.200
     3.708   102.320     0.200
     3.787   101.438     0.200
     3.849   105.523     0.200
     3.929   107.320     0.200
     3.929   107.023     0.200
     3.942   107.617     0.200
     4.119   108.641     0.200
     4.095   111.523     0.200
     4.120   112.117     0.200
     4.353   115.297     0.200
     4.397   116.070     0.200
     4.471   117.469     0.200
     4.502   119.812     0.200
     4.550   121.422     0.200
     4.729   123.414     0.200
     4.775   125.039     0.200
     4.970   132.695     0.200
     4.970   132.547     0.200
     5.052   133.422     0.200
     5.082   134.219     0.200
     5.141   135.648     0.200
     5.146   136.094     0.200
     5.190   132.711     0.200
     5.222   136.023     0.200
     5.429   143.398     0.200
     5.496   143.328     0.200
     5.617   147.797     0.200
     5.617   148.062     0.200
     5.746   149.531     0.200
     5.915   152.523     0.200
     6.037   154.922     0.200
     6.116   161.469     0.200
     6.159   162.602     0.200
     6.191   161.891     0.200
     6.184   161.805     0.200
     6.163   159.023     0.200
     6.198   162.789     0.200
     6.261   162.789     0.200
     6.281   164.523     0.200
     6.317   164.398     0.200
     6.317   164.648     0.200
     6.334   167.180     0.200
     6.448   167.883     0.200
     6.460   165.922     0.200
     6.562   171.422     0.200
     6.682   173.469     0.200
     6.773   176.023     0.200
     6.797   174.422     0.200
     6.941   178.727     0.200
     6.990   180.117     0.200
     7.085   181.719     0.200
     7.126   188.523     0.200
     7.248   185.922     0.200
     7.286   185.422     0.200
     7.337   187.328     0.200
     7.337   187.672     0.200
     7.562   193.422     0.200
     7.624   194.117     0.200
     7.630   194.320     0.200
     8.377   211.820     0.200
     8.452   212.117     0.200
     8.629   217.320     0.200
     8.667   218.617     0.200
     8.750   220.023     0.200
     9.433   236.117     0.200
     9.608   242.117     0.200
     9.661   243.523     0.200
     9.721   243.719     0.200
     9.762   243.523     0.200
     9.786   245.523     0.200
     9.862   247.922     0.200
    11.201   279.523     0.200
     2.263    64.117     0.200
     2.478    69.133     0.200
     2.490    69.219     0.200
     2.660    75.258     0.200
     2.712    76.047     0.200
     2.811    76.695     0.200
     3.121    84.406     0.200
     3.229    86.305     0.200
     3.441    92.484     0.200
     3.435    92.344     0.200
     3.529    94.227     0.200
     3.578    96.922     0.200
     4.139   108.266     0.200
     4.333   112.727     0.200
     4.376   115.773     0.200
     4.492   117.375     0.200
     4.578   118.125     0.200
     4.986   131.688     0.200
     5.155   135.125     0.200
     5.164   135.875     0.200
     5.439   143.094     0.200
     5.765   150.609     0.200
     5.784   146.023     0.200
     6.124   161.477     0.200
     6.164   160.891     0.200
     6.197   161.703     0.200
     6.206   162.539     0.200
     6.190   157.523     0.200
     6.265   156.727     0.200
     6.263   161.648     0.200
     6.332   164.141     0.200
     6.340   165.633     0.200
     6.467   167.703     0.200
     6.486   166.422     0.200
     6.571   164.328     0.200
     6.568   171.281     0.200
     6.960   173.727     0.200
     7.301   185.227     0.200
     7.352   183.820     0.200
     7.585   194.828     0.200
     7.644   194.125     0.200
     8.375   209.125     0.200
     8.629   213.922     0.200
     8.748   217.125     0.200
     2.120    61.080     0.200
     2.242    63.630     0.200
     2.457    69.700     0.200
     2.472    68.670     0.200
     2.639    74.030     0.200
     2.690    76.560     0.200
     2.789    78.480     0.200
     3.028    82.590     0.200
     3.212    87.540     0.200
     3.427    90.920     0.200
     3.416    92.760     0.200
     3.513    93.540     0.200
     3.787   100.880     0.200
     3.937   107.250     0.200
     4.120   109.360     0.200
     4.216   112.250     0.200
     4.315   111.950     0.200
     4.355   115.380     0.200
     4.557   119.250     0.200
     4.698   124.750     0.200
     4.970   132.329     0.200
     5.059   132.450     0.200
     5.140   137.015     0.200
     5.146   135.287     0.200
     5.426   142.419     0.200
     5.790   149.350     0.200
     5.746   150.725     0.200
     6.187   163.039     0.200
     6.256   159.908     0.200
     6.330   165.641     0.200
     6.316   163.983     0.200
     6.449   164.102     0.200
     6.962   176.550     0.200
     7.285   185.550     0.200
     7.336   186.900     0.200
     7.629   195.050     0.200
     8.371   210.350     0.200
     8.624   215.650     0.200
     8.745   218.750     0.200
     9.601   239.850     0.200
     2.074    61.148     0.200
     2.116    60.812     0.200
     2.243    63.734     0.200
     2.458    69.469     0.200
     2.475    69.938     0.200
     2.631    74.156     0.200
     2.685    75.852     0.200
     3.103    84.727     0.200
     3.217    86.953     0.200
     3.418    92.195     0.200
     3.434    92.328     0.200
     3.520    93.625     0.200
     4.123   109.352     0.200
     4.356   115.383     0.200
     4.475   117.742     0.200
     4.733   124.273     0.200
     5.151   135.977     0.200
     5.435   143.359     0.200
     6.322   163.477     0.200
     6.452   166.484     0.200
     7.243   180.078     0.200
     7.291   188.273     0.200
     7.343   186.078     0.200
     7.564   194.172     0.200
     7.635   195.078     0.200
     8.383   208.172     0.200
     8.757   216.977     0.200
     2.116    61.359     0.200
     2.238    63.594     0.200
     2.453    69.094     0.200
     2.467    69.734     0.200
     2.635    75.094     0.200
     2.686    76.430     0.200
     2.784    77.969     0.200
     3.024    82.523     0.200
     3.002    81.555     0.200
     3.096    85.625     0.200
     3.208    87.000     0.200
     3.411    91.797     0.200
     3.423    92.430     0.200
     3.509    93.828     0.200
     3.556    96.656     0.200
     3.782   100.133     0.200
     3.985   107.148     0.200
     4.116   109.188     0.200
     4.212   111.258     0.200
     4.316   115.156     0.200
     4.310   113.156     0.200
     4.350   115.062     0.200
     4.468   117.375     0.200
     4.553   119.555     0.200
     4.661   124.188     0.200
     4.726   123.930     0.200
     4.966   131.320     0.200
     5.136   137.109     0.200
     5.142   135.164     0.200
     5.423   142.375     0.200
     5.484   142.453     0.200
     5.742   151.734     0.200
     5.790   149.555     0.200
     5.920   152.055     0.200
     6.110   159.539     0.200
     6.152   161.133     0.200
     6.184   162.469     0.200
     6.191   161.648     0.200
     6.168   157.758     0.200
     6.253   160.531     0.200
     6.312   164.383     0.200
     6.327   165.617     0.200
     6.444   166.977     0.200
     6.466   166.430     0.200
     6.556   170.312     0.200
     6.982   178.758     0.200
     7.082   181.156     0.200
     7.126   187.430     0.200
     7.281   186.953     0.200
     7.332   185.711     0.200
     7.560   192.953     0.200
     7.625   195.055     0.200
     8.369   211.359     0.200
     8.742   220.555     0.200
     9.425   235.758     0.200
     9.600   240.953     0.200
     9.755   240.258     0.200
     3.361    92.055     0.200
     4.108   110.291     0.200
     4.392   113.291     0.200
     4.443   115.900     0.200
     4.987   131.340     0.200
     4.994   129.932     0.200
     5.296   137.688     0.200
     5.342   140.828     0.200
     5.508   146.275     0.200
     5.488   147.762     0.200
     5.883   150.201     0.200
     6.042   160.049     0.200
     6.107   161.908     0.200
     6.124   163.553     0.200
     6.186   161.281     0.200
     6.229   163.334     0.200
     6.269   166.963     0.200
     6.343   161.801     0.200
     6.388   162.500     0.200
     6.502   170.744     0.200
     6.641   173.480     0.200
     6.648   169.102     0.200
     7.014   177.000     0.200
     7.035   177.900     0.200
     7.154   181.000     0.200
     7.214   182.750     0.200
     7.342   187.000     0.200
     7.374   187.500     0.200
     7.508   190.400     0.200
     8.371   208.000     0.200
     8.607   213.201     0.200
     8.747   216.602     0.200
     9.642   239.102     0.200
     9.875   245.900     0.200
    10.122   250.742     0.200
     2.241    63.285     0.200
     2.456    69.086     0.200
     2.471    68.906     0.200
     2.484    70.125     0.200
     2.637    74.836     0.200
     2.688    76.145     0.200
     2.769    75.105     0.200
     2.787    77.387     0.200
     3.028    82.516     0.200
     3.015    84.324     0.200
     3.100    84.324     0.200
     3.212    86.906     0.200
     3.202    88.926     0.200
     3.267    90.426     0.200
     3.344    92.324     0.200
     3.415    92.746     0.200
     3.427    91.195     0.200
     3.436    94.625     0.200
     3.458    95.125     0.200
     3.474    95.527     0.200
     3.513    93.824     0.200
     3.549    95.215     0.200
     3.556    97.625     0.200
     3.563    93.414     0.200
     3.573    97.926     0.200
     3.854   104.824     0.200
     3.940   107.414     0.200
     4.119   109.754     0.200
     4.126   111.426     0.200
     4.216   114.414     0.200
     4.317   113.426     0.200
     4.354   115.727     0.200
     4.472   117.645     0.200
     4.542   119.734     0.200
     4.775   125.348     0.200
     4.969   130.930     0.200
     5.140   134.527     0.200
     5.146   135.480     0.200
     5.427   142.082     0.200
     5.746   149.773     0.200
     6.113   161.160     0.200
     6.156   160.488     0.200
     6.188   161.914     0.200
     6.195   160.598     0.200
     6.257   162.684     0.200
     6.315   162.895     0.200
     6.448   166.238     0.200
     7.285   185.426     0.200
     7.336   188.250     0.200
     7.629   193.727     0.200
     8.372   210.625     0.200
     8.625   216.027     0.200
     8.746   218.727     0.200
     2.346    65.945     0.200
     2.922    82.102     0.200
     3.023    84.602     0.200
     3.086    85.695     0.200
     3.167    88.195     0.200
     3.209    89.500     0.200
     3.223    89.102     0.200
     3.254    90.297     0.200
     3.286    91.500     0.200
     3.308    91.102     0.200
     3.588    98.398     0.200
     3.661   100.297     0.200
     3.723   100.492     0.200
     3.810   101.680     0.200
     3.849   104.398     0.200
     3.862   104.602     0.200
     4.013   107.078     0.200
     4.304   113.000     0.200
     4.726   123.945     0.200
     4.889   126.234     0.200
     5.403   138.758     0.200
     5.479   141.250     0.200
     5.863   145.297     0.200
     5.969   154.438     0.200
     6.077   156.180     0.200
     6.178   159.586     0.200
     6.177   157.758     0.200
     6.616   162.898     0.200
     6.595   165.797     0.200
     6.797   171.398     0.200
     6.972   171.195     0.200
     6.993   171.797     0.200
     7.043   177.695     0.200
     7.106   177.172     0.200
     7.275   178.398     0.200
     7.260   182.398     0.200
     7.350   184.797     0.200
     7.952   194.695     0.200
     8.205   204.102     0.200
     8.200   207.297     0.200
     8.303   204.297     0.200
     8.391   210.898     0.200
     8.533   208.500     0.200
     8.681   212.000     0.200
     9.300   226.695     0.200
     9.359   228.195     0.200
     9.476   230.898     0.200
     9.593   233.602     0.200
     9.665   235.500     0.200
     9.658   235.102     0.200
     9.699   236.000     0.200
     9.696   236.297     0.200
    10.166   252.516     0.200
     2.438    67.930     0.200
     2.779    78.133     0.200
     2.781    76.633     0.200
     2.987    82.734     0.200
     3.022    83.828     0.200
     3.108    85.531     0.200
     3.207    86.328     0.200
     3.314    90.930     0.200
     3.365    91.734     0.200
     3.624    98.234     0.200
     3.627    99.328     0.200
     3.858   104.133     0.200
     3.893   104.930     0.200
     3.898   101.828     0.200
     4.025   104.633     0.200
     4.090   105.430     0.200
     4.307   111.023     0.200
     4.343   111.734     0.200
     4.849   125.234     0.200
     5.226   137.344     0.200
     5.547   144.727     0.200
     5.931   149.234     0.200
     6.249   160.375     0.200
     6.316   162.852     0.200
     6.331   163.914     0.200
     6.334   165.078     0.200
     6.376   163.750     0.200
     6.463   164.531     0.200
     6.477   168.656     0.200
     7.342   185.531     0.200
     8.576   211.930     0.200
     8.815   216.328     0.200
     8.952   220.828     0.200
     9.741   236.828     0.200
     2.434    67.641     0.200
     2.779    75.844     0.200
     2.778    77.242     0.200
     2.984    83.844     0.200
     3.106    86.844     0.200
     3.206    89.344     0.200
     3.207    89.344     0.200
     3.217    89.641     0.200
     3.313    91.641     0.200
     3.362    93.344     0.200
     3.619    98.742     0.200
     3.623    99.445     0.200
     3.733   102.242     0.200
     3.857   105.445     0.200
     3.893   102.242     0.200
     3.891   105.742     0.200
     4.021   104.039     0.200
     4.088   106.039     0.200
     4.340   112.445     0.200
     4.502   116.141     0.200
     4.509   116.445     0.200
     4.583   115.742     0.200
     4.820   124.945     0.200
     4.846   124.242     0.200
     4.854   125.641     0.200
     5.069   129.945     0.200
     5.216   135.984     0.200
     5.374   136.945     0.200
     5.397   137.039     0.200
     5.537   143.656     0.200
     6.240   160.430     0.200
     6.262   162.219     0.200
     6.307   161.812     0.200
     6.325   163.945     0.200
     6.366   163.516     0.200
     6.454   164.414     0.200
     6.538   162.344     0.200
     7.059   176.742     0.200
     7.218   180.039     0.200
     7.332   184.641     0.200
     7.358   182.141     0.200
     7.398   185.742     0.200
     7.478   184.844     0.200
     7.502   188.945     0.200
     7.692   192.742     0.200
     8.193   203.445     0.200
     8.492   213.539     0.200
     8.568   212.539     0.200
     8.807   217.539     0.200
     8.944   221.242     0.200
     9.526   235.641     0.200
     9.624   237.344     0.200
     9.732   240.445     0.200
     9.829   241.445     0.200
     9.890   244.539     0.200
     9.919   244.445     0.200
     9.930   244.242     0.200
     0.702    23.604     0.200
     0.785    26.104     0.200
     0.914    30.483     0.200
     0.933    31.403     0.200
     0.922    31.023     0.200
     0.927    29.804     0.200
     1.081    34.563     0.200
     2.111    60.104     0.200
     2.303    64.504     0.200
     2.369    66.403     0.200
     2.440    68.004     0.200
     2.531    70.204     0.200
     2.567    71.204     0.200
     2.598    72.104     0.200
     2.656    73.304     0.200
     2.680    73.504     0.200
     2.949    80.204     0.200
     3.051    82.504     0.200
     3.198    86.403     0.200
     3.221    86.804     0.200
     3.898   100.414     0.200
     3.854   101.724     0.200
     4.803   127.014     0.200
     5.007   128.202     0.200
     5.415   138.661     0.200
     5.497   138.732     0.200
     6.024   152.790     0.200
     6.068   153.042     0.200
     6.083   154.334     0.200
     6.155   157.764     0.200
     6.222   159.004     0.200
     6.294   161.319     0.200
     6.441   160.504     0.200
     6.600   165.704     0.200
     6.661   167.923     0.200
     6.862   172.596     0.200
     6.989   173.604     0.200
     6.979   175.903     0.200
     7.035   174.604     0.200
     7.135   178.047     0.200
     7.135   177.379     0.200
     7.161   177.804     0.200
     7.216   181.204     0.200
     7.432   183.204     0.200
     7.498   186.104     0.200
     7.472   185.523     0.200
     7.561   187.352     0.200
     7.774   192.104     0.200
     7.822   193.504     0.200
     8.014   201.204     0.200
     8.174   202.004     0.200
     8.415   207.704     0.200
     8.619   212.504     0.200
     8.690   214.604     0.200
     8.686   213.604     0.200
     8.880   219.104     0.200
     9.009   221.804     0.200
     9.072   223.704     0.200
     9.743   239.604     0.200
     9.695   236.382     0.200
     9.800   240.804     0.200
     9.890   243.104     0.200
    10.060   247.104     0.200
    10.068   247.304     0.200
    10.091   247.804     0.200
    10.102   247.704     0.200
    10.166   249.204     0.200
    10.187   250.104     0.200
    10.394   254.903     0.200
    10.433   256.104     0.200
    10.709   262.604     0.200
    10.896   267.104     0.200
    11.211   274.604     0.200
    11.476   280.903     0.200
    12.355   301.804     0.200
    13.055   318.604     0.200
    13.343   325.504     0.200
    13.419   327.204     0.200
    14.427   351.204     0.200
    14.906   362.804     0.200
     0.744    24.835     0.200
     0.765    25.534     0.200
     0.858    29.034     0.200
     0.903    31.185     0.200
     0.847    28.635     0.200
     0.965    32.034     0.200
     0.952    31.234     0.200
     1.232    36.484     0.200
     1.449    41.915     0.200
     1.717    48.765     0.200
     1.728    48.675     0.200
     1.872    52.024     0.200
     1.938    54.534     0.200
     1.898    52.864     0.200
     2.079    57.034     0.200
     2.247    63.465     0.200
     2.574    69.324     0.200
     2.738    75.005     0.200
     2.869    76.845     0.200
     3.066    81.685     0.200
     3.093    83.354     0.200
     3.481    91.625     0.200
     3.480    90.704     0.200
     3.836   100.234     0.200
     3.875   100.984     0.200
     3.992   101.795     0.200
     4.117   105.824     0.200
     4.360   112.095     0.200
     4.366   112.095     0.200
     4.815   123.535     0.200
     4.925   123.832     0.200
     5.100   130.181     0.200
     5.171   129.734     0.200
     5.466   137.798     0.200
     5.515   140.487     0.200
     5.591   141.266     0.200
     5.917   150.140     0.200
     6.113   154.953     0.200
     6.138   153.602     0.200
     6.167   154.926     0.200
     6.257   161.429     0.200
     6.340   162.427     0.200
     6.374   162.427     0.200
     6.400   162.367     0.200
     6.518   165.114     0.200
     6.547   162.234     0.200
     6.765   171.387     0.200
     6.969   175.578     0.200
     7.021   175.534     0.200
     7.091   175.034     0.200
     7.221   179.423     0.200
     7.269   179.335     0.200
     7.518   185.234     0.200
     7.588   186.835     0.200
     7.608   187.435     0.200
     7.879   193.935     0.200
     7.931   195.135     0.200
     8.526   209.135     0.200
     8.800   215.534     0.200
     8.989   219.734     0.200
     9.183   224.635     0.200
     9.853   240.734     0.200
     9.911   241.935     0.200
    10.179   248.135     0.200
    10.277   251.135     0.200
    10.298   251.135     0.200
    10.504   256.135     0.200
    10.819   263.734     0.200
     2.672    73.846     0.200
     2.929    81.456     0.200
     3.162    86.656     0.200
     3.257    89.156     0.200
     3.332    91.156     0.200
     3.452    93.756     0.200
     3.915   104.956     0.200
     3.997   107.456     0.200
     4.045   108.256     0.200
     6.529   167.968     0.200
     6.604   170.306     0.200
     6.669   172.741     0.200
     7.635   191.768     0.200
     7.929   201.356     0.200
     1.975    57.375     0.200
     2.781    79.125     0.200
     2.936    82.926     0.200
     3.050    85.926     0.200
     3.108    87.227     0.200
     3.186    89.125     0.200
     3.253    90.625     0.200
     3.297    92.125     0.200
     3.287    89.926     0.200
     3.334    92.527     0.200
     3.607    99.227     0.200
     3.672   101.125     0.200
     3.754   100.727     0.200
     3.873   106.125     0.200
     3.882   106.027     0.200
     4.366   112.227     0.200
     4.533   122.355     0.200
     4.673   124.504     0.200
     4.672   122.727     0.200
     4.767   124.027     0.200
     4.839   128.852     0.200
     4.866   127.641     0.200
     4.898   129.727     0.200
     4.924   130.016     0.200
     5.032   132.227     0.200
     5.057   132.328     0.200
     5.184   136.984     0.200
     5.287   137.527     0.200
     5.346   139.863     0.200
     5.365   139.727     0.200
     5.388   140.625     0.200
     5.399   140.625     0.200
     5.458   141.328     0.200
     5.488   141.328     0.200
     5.562   144.828     0.200
     5.571   143.426     0.200
     5.730   147.527     0.200
     5.793   151.215     0.200
     5.769   149.227     0.200
     5.818   149.688     0.200
     5.887   155.332     0.200
     5.913   154.574     0.200
     5.904   152.828     0.200
     5.958   157.402     0.200
     5.969   156.148     0.200
     5.973   156.793     0.200
     6.023   156.113     0.200
     6.074   158.918     0.200
     6.088   158.668     0.200
     6.117   159.730     0.200
     6.131   157.363     0.200
     6.351   165.438     0.200
     6.497   168.094     0.200
     6.742   176.387     0.200
     6.756   173.027     0.200
     7.052   179.145     0.200
     7.052   179.227     0.200
     7.226   183.625     0.200
     7.296   185.125     0.200
     7.304   184.727     0.200
     7.345   185.227     0.200
     7.434   186.930     0.200
     7.569   191.426     0.200
     7.569   192.422     0.200
     7.614   191.027     0.200
     7.745   198.227     0.200
     8.076   202.426     0.200
     8.139   202.492     0.200
     8.158   207.125     0.200
     8.558   214.727     0.200
     9.532   234.328     0.200
     9.555   238.227     0.200
     9.899   251.555     0.200
    10.226   256.402     0.200
    10.803   263.125     0.200
    10.829   269.457     0.200
    10.973   274.168     0.200
    11.053   268.227     0.200
    16.694   418.328     0.200
     1.066    36.039     0.200
     1.080    36.977     0.200
     1.080    36.750     0.200
     1.118    38.680     0.200
     1.099    37.812     0.200
     1.149    39.016     0.200
     1.161    37.133     0.200
     1.168    37.766     0.200
     1.198    40.609     0.200
     1.223    40.500     0.200
     1.239    41.086     0.200
     1.315    42.422     0.200
     1.351    43.609     0.200
     1.533    48.961     0.200
     1.574    48.922     0.200
     2.932    83.031     0.200
     3.106    87.430     0.200
     3.252    91.133     0.200
     3.291    92.031     0.200
     3.331    91.836     0.200
     3.331    93.430     0.200
     3.603    99.734     0.200
     3.666    98.234     0.200
     3.776   103.141     0.200
     3.800   100.391     0.200
     3.800   102.234     0.200
     3.871   106.234     0.200
     3.878   106.133     0.200
     3.910   104.836     0.200
     4.380   117.500     0.200
     4.444   114.781     0.200
     4.536   122.195     0.200
     4.658   124.758     0.200
     4.648   123.570     0.200
     4.851   127.852     0.200
     4.834   126.133     0.200
     5.020   130.633     0.200
     5.035   131.461     0.200
     5.035   131.133     0.200
     5.169   136.266     0.200
     5.257   136.836     0.200
     5.331   139.875     0.200
     5.331   139.719     0.200
     5.358   137.633     0.200
     5.417   140.008     0.200
     5.417   139.789     0.200
     5.614   144.336     0.200
     5.779   151.031     0.200
     5.802   145.430     0.200
     5.819   149.094     0.200
     5.873   153.227     0.200
     5.873   155.148     0.200
     5.898   153.773     0.200
     5.926   152.031     0.200
     5.955   155.406     0.200
     5.959   155.867     0.200
     6.008   155.883     0.200
     6.008   156.031     0.200
     6.075   156.547     0.200
     6.103   159.070     0.200
     6.116   156.930     0.200
     6.337   163.406     0.200
     6.429   167.617     0.200
     6.448   165.430     0.200
     6.483   167.875     0.200
     6.498   168.445     0.200
     6.540   165.531     0.200
     6.728   176.469     0.200
     6.903   173.930     0.200
     6.905   175.836     0.200
     6.924   172.234     0.200
     6.975   176.930     0.200
     7.037   178.984     0.200
     7.037   178.695     0.200
     7.126   176.336     0.200
     7.211   180.930     0.200
     7.213   184.336     0.200
     7.282   187.031     0.200
     7.290   184.930     0.200
     7.331   185.336     0.200
     7.419   186.945     0.200
     7.425   188.250     0.200
     7.499   189.094     0.200
     7.554   190.930     0.200
     7.554   190.055     0.200
     7.599   192.836     0.200
     7.733   196.336     0.200
     7.797   198.531     0.200
     7.880   195.531     0.200
     7.995   197.133     0.200
     8.138   203.930     0.200
     8.144   205.031     0.200
     8.229   203.133     0.200
     8.332   210.336     0.200
     8.458   209.133     0.200
     8.606   212.734     0.200
     8.796   219.633     0.200
     9.231   227.031     0.200
     9.285   228.930     0.200
     9.402   231.031     0.200
     9.522   234.430     0.200
     9.584   235.734     0.200
     9.597   236.336     0.200
     9.629   236.930     0.200
     9.795   244.234     0.200
     9.811   240.930     0.200
     9.887   247.562     0.200
    10.111   247.633     0.200
    10.249   251.734     0.200
    10.265   251.531     0.200
    10.236   256.133     0.200
    10.476   262.062     0.200
    10.652   260.234     0.200
    10.675   268.750     0.200
    10.716   260.734     0.200
    10.791   263.836     0.200
    10.816   269.492     0.200
    10.882   273.875     0.200
    10.961   271.805     0.200
    11.041   270.031     0.200
    11.444   278.633     0.200
    11.750   287.734     0.200
    11.934   292.531     0.200
    12.507   305.531     0.200
    12.796   312.531     0.200
    12.858   313.930     0.200
    13.850   340.734     0.200
    14.119   340.531     0.200
    14.327   348.133     0.200
    15.300   385.102     0.200
    17.914   439.234     0.200
    20.469   507.930     0.200
     2.360    66.789     0.200
     2.941    82.984     0.200
     2.941    82.188     0.200
     3.054    85.086     0.200
     3.113    87.289     0.200
     3.190    88.891     0.200
     3.256    90.891     0.200
     3.302    90.789     0.200
     3.337    91.289     0.200
     3.337    92.789     0.200
     3.611    99.484     0.200
     3.677   100.188     0.200
     3.877   105.688     0.200
     3.886   105.984     0.200
     3.923   104.484     0.200
     4.009   109.469     0.200
     4.052   107.586     0.200
     4.398   112.688     0.200
     4.372   115.188     0.200
     4.406   115.984     0.200
     4.535   121.781     0.200
     4.728   122.984     0.200
     4.872   128.305     0.200
     4.842   125.688     0.200
     5.034   130.891     0.200
     5.266   136.188     0.200
     5.264   136.086     0.200
     5.367   138.789     0.200
     5.496   146.258     0.200
     5.627   143.391     0.200
     5.750   147.891     0.200
     5.799   153.500     0.200
     5.809   146.188     0.200
     5.785   148.484     0.200
     5.892   153.391     0.200
     5.920   155.328     0.200
     5.974   158.820     0.200
     5.978   157.133     0.200
     5.933   151.984     0.200
     6.030   156.062     0.200
     6.030   155.875     0.200
     6.080   158.328     0.200
     6.092   156.172     0.200
     6.122   159.289     0.200
     6.138   159.000     0.200
     6.255   163.547     0.200
     6.330   158.484     0.200
     6.260   158.188     0.200
     6.356   167.664     0.200
     6.447   167.266     0.200
     6.469   165.891     0.200
     6.501   169.609     0.200
     6.501   169.242     0.200
     6.515   168.938     0.200
     6.560   162.984     0.200
     6.561   166.484     0.200
     6.746   173.234     0.200
     6.914   171.188     0.200
     6.926   175.789     0.200
     7.002   179.188     0.200
     6.997   178.688     0.200
     6.997   178.539     0.200
     7.058   179.164     0.200
     7.058   177.695     0.200
     7.132   177.391     0.200
     7.179   183.406     0.200
     7.219   179.789     0.200
     7.233   184.188     0.200
     7.303   186.688     0.200
     7.311   185.391     0.200
     7.311   183.625     0.200
     7.352   185.289     0.200
     7.352   186.383     0.200
     7.405   188.734     0.200
     7.441   187.758     0.200
     7.440   186.445     0.200
     7.451   187.586     0.200
     7.386   186.891     0.200
     7.515   188.125     0.200
     7.576   189.109     0.200
     7.620   192.688     0.200
     7.752   194.984     0.200
     7.893   195.891     0.200
     8.002   197.086     0.200
     8.005   202.086     0.200
     8.165   207.586     0.200
     8.244   203.891     0.200
     8.353   210.391     0.200
     8.474   209.289     0.200
     8.464   205.586     0.200
     8.621   213.086     0.200
     8.903   225.258     0.200
     9.242   227.391     0.200
     9.300   228.484     0.200
     9.416   231.188     0.200
     9.434   233.188     0.200
     9.534   234.688     0.200
     9.599   236.086     0.200
     9.607   235.289     0.200
     9.641   236.289     0.200
     9.665   241.984     0.200
     9.903   250.461     0.200
     9.903   249.820     0.200
    10.260   250.188     0.200
    10.236   262.789     0.200
    10.224   253.703     0.200
    10.626   265.281     0.200
    10.668   261.867     0.200
    10.664   267.508     0.200
    10.692   270.086     0.200
    10.807   264.688     0.200
    10.849   269.984     0.200
    10.899   269.414     0.200
    10.977   272.469     0.200
    11.057   270.289     0.200
    11.446   281.391     0.200
    11.759   287.086     0.200
    12.519   303.984     0.200
    12.808   310.984     0.200
    12.869   312.891     0.200
    14.129   342.984     0.200
    16.698   416.086     0.200
    17.931   440.336     0.200
    18.519   455.086     0.200
    18.891   470.086     0.200
    19.104   475.188     0.200
    19.112   476.086     0.200
    19.296   477.984     0.200
    20.062   498.977     0.200
    20.476   507.656     0.200
    20.476   507.086     0.200
    20.658   511.680     0.200
    22.584   555.133     0.200
     3.069    86.023     0.200
     3.127    87.422     0.200
     3.204    89.023     0.200
     3.272    91.227     0.200
     3.313    91.625     0.200
     3.352    92.523     0.200
     3.352    93.023     0.200
     3.625    99.320     0.200
     3.688   100.922     0.200
     3.892   105.922     0.200
     3.900   106.125     0.200
     3.932   105.125     0.200
     4.064   109.125     0.200
     4.379   114.125     0.200
     4.415   116.625     0.200
     4.553   121.891     0.200
     4.793   126.125     0.200
     4.856   127.422     0.200
     5.042   131.625     0.200
     5.278   137.227     0.200
     5.430   140.086     0.200
     5.513   146.773     0.200
     5.797   150.125     0.200
     5.877   155.188     0.200
     5.946   154.930     0.200
     5.959   155.672     0.200
     5.947   152.727     0.200
     6.019   155.969     0.200
     6.484   168.336     0.200
     6.895   174.320     0.200
     6.915   175.727     0.200
     6.987   176.820     0.200
     7.304   184.125     0.200
     7.340   185.227     0.200
     7.873   198.023     0.200
     8.456   212.227     0.200
     8.603   213.625     0.200
     9.223   229.625     0.200
     9.281   232.023     0.200
     9.515   236.625     0.200
     9.580   238.625     0.200
     2.344    65.562     0.200
     2.925    82.266     0.200
     3.035    85.469     0.200
     3.095    86.664     0.200
     3.173    88.867     0.200
     3.238    90.367     0.200
     3.286    91.266     0.200
     3.319    88.969     0.200
     3.319    92.164     0.200
     3.594    98.766     0.200
     3.661   100.367     0.200
     3.868   105.664     0.200
     3.909   103.367     0.200
     4.035   105.164     0.200
     4.360   111.766     0.200
     4.515   121.094     0.200
     4.684   121.961     0.200
     4.713   120.562     0.200
     4.766   123.469     0.200
     4.879   130.273     0.200
     4.898   125.867     0.200
     5.021   128.969     0.200
     5.250   134.969     0.200
     5.245   136.164     0.200
     5.359   138.617     0.200
     5.359   138.859     0.200
     5.351   136.164     0.200
     5.476   146.508     0.200
     5.808   151.422     0.200
     5.768   145.969     0.200
     5.902   155.148     0.200
     5.902   154.516     0.200
     5.926   154.617     0.200
     5.916   150.969     0.200
     5.975   158.461     0.200
     5.985   156.336     0.200
     5.990   157.344     0.200
     6.034   153.836     0.200
     6.034   155.703     0.200
     6.088   157.945     0.200
     6.106   157.641     0.200
     6.133   161.625     0.200
     6.139   159.742     0.200
     6.266   163.719     0.200
     6.368   167.945     0.200
     6.460   167.641     0.200
     6.465   167.266     0.200
     6.514   171.055     0.200
     6.529   168.406     0.200
     6.560   165.469     0.200
     6.925   174.367     0.200
     6.953   173.266     0.200
     7.001   176.766     0.200
     7.063   177.680     0.200
     7.063   178.867     0.200
     7.229   182.367     0.200
     7.312   183.562     0.200
     7.357   185.969     0.200
     7.447   186.109     0.200
     7.456   189.594     0.200
     7.465   187.844     0.200
     7.530   188.828     0.200
     7.625   190.266     0.200
     7.746   196.766     0.200
     7.910   195.969     0.200
     8.152   201.898     0.200
     8.164   206.469     0.200
     8.259   204.266     0.200
     8.397   209.477     0.200
     8.457   206.164     0.200
     8.489   210.062     0.200
     8.637   213.266     0.200
     9.068   233.195     0.200
     9.260   227.562     0.200
     9.315   229.562     0.200
     9.432   232.164     0.200
     9.552   234.867     0.200
     9.615   236.469     0.200
     9.659   237.562     0.200
     9.917   252.695     0.200
    10.139   248.562     0.200
    10.278   251.969     0.200
    10.206   252.305     0.200
    10.705   268.016     0.200
    10.822   265.367     0.200
    11.072   270.367     0.200
    15.313   381.562     0.200
     2.340    64.547     0.200
     3.315    89.648     0.200
     3.904   104.047     0.200
     4.031   105.844     0.200
     4.387   114.547     0.200
     4.682   123.820     0.200
     4.762   123.242     0.200
     5.902   158.945     0.200
     5.911   151.242     0.200
     5.976   158.391     0.200
     5.990   157.172     0.200
     5.985   159.742     0.200
     6.033   155.391     0.200
     6.133   161.938     0.200
     6.368   169.039     0.200
     6.515   173.117     0.200
     6.934   175.547     0.200
     6.955   175.844     0.200
     8.260   208.648     0.200
     8.490   213.648     0.200
     8.638   215.242     0.200
     9.554   237.547     0.200
     2.336    65.766     0.200
     2.917    81.766     0.200
     3.030    84.266     0.200
     3.089    85.766     0.200
     3.166    87.766     0.200
     3.233    88.969     0.200
     3.278    90.469     0.200
     3.314    89.469     0.200
     3.314    91.164     0.200
     3.587    97.766     0.200
     3.653    99.367     0.200
     3.853   103.969     0.200
     3.862   104.367     0.200
     3.899   104.867     0.200
     4.028   107.469     0.200
     4.382   116.562     0.200
     4.671   120.555     0.200
     4.704   124.367     0.200
     4.758   124.562     0.200
     4.818   126.664     0.200
     4.836   126.078     0.200
     4.867   127.570     0.200
     5.347   138.688     0.200
     5.796   151.102     0.200
     5.892   155.070     0.200
     5.913   154.258     0.200
     5.909   151.469     0.200
     5.944   152.453     0.200
     5.965   155.492     0.200
     5.974   155.930     0.200
     5.979   155.938     0.200
     6.022   155.164     0.200
     6.122   158.672     0.200
     6.126   156.672     0.200
     6.357   167.328     0.200
     6.505   168.594     0.200
     6.927   176.867     0.200
     6.948   177.867     0.200
     7.904   199.266     0.200
     8.251   205.562     0.200
     8.480   212.367     0.200
     8.629   214.469     0.200
     9.255   231.867     0.200
     9.307   229.664     0.200
     9.425   233.766     0.200
     9.546   238.266     0.200
     9.607   238.969     0.200
     9.620   239.562     0.200
     9.645   236.664     0.200
     9.653   239.766     0.200
     9.834   245.469     0.200
    10.135   252.664     0.200
     1.521    45.881     0.200
     4.635   122.880     0.200
     4.801   125.511     0.200
     4.829   127.703     0.200
     5.310   137.877     0.200
     5.758   150.812     0.200
     5.798   147.081     0.200
     5.853   152.197     0.200
     5.876   153.018     0.200
     5.927   155.042     0.200
     5.935   156.119     0.200
     5.940   156.786     0.200
     5.985   156.309     0.200
     6.084   157.866     0.200
     6.092   158.466     0.200
     6.319   163.979     0.200
     6.466   167.225     0.200
     6.894   173.481     0.200
     6.915   173.381     0.200
     7.204   180.081     0.200
     8.214   204.281     0.200
     8.442   209.881     0.200
     8.592   213.281     0.200
     9.222   228.281     0.200
     9.270   229.681     0.200
     9.389   232.581     0.200
     9.512   236.281     0.200
    12.848   315.881     0.200
     1.977    55.625     0.200
     2.739    76.766     0.200
     2.930    83.570     0.200
     3.045    85.664     0.200
     3.103    87.469     0.200
     3.265    87.828     0.200
     3.248    90.570     0.200
     3.289    92.266     0.200
     3.328    92.664     0.200
     3.601    99.367     0.200
     3.868   105.570     0.200
     3.875   105.867     0.200
     3.909   108.367     0.200
     4.530   121.070     0.200
     4.664   125.445     0.200
     4.831   128.070     0.200
     4.830   128.320     0.200
     4.858   128.016     0.200
     5.030   131.766     0.200
     5.254   138.367     0.200
     5.338   139.188     0.200
     5.422   139.938     0.200
     5.785   151.438     0.200
     5.879   155.977     0.200
     5.905   155.445     0.200
     5.923   153.969     0.200
     5.952   157.258     0.200
     5.962   156.141     0.200
     5.967   155.758     0.200
     6.110   162.734     0.200
     6.121   157.945     0.200
     6.491   169.773     0.200
     6.910   173.664     0.200
     8.236   205.969     0.200
     8.465   212.266     0.200
     8.613   214.469     0.200
     9.238   230.867     0.200
     9.529   235.969     0.200
     9.636   239.164     0.200
     9.802   242.164     0.200
     1.235    41.039     0.200
     1.215    40.492     0.200
     1.327    44.617     0.200
     3.321    91.086     0.200
     4.519   120.891     0.200
     4.678   123.086     0.200
     4.826   127.289     0.200
     4.873   127.375     0.200
     5.018   131.789     0.200
     5.192   138.023     0.200
     5.247   136.688     0.200
     5.353   139.336     0.200
     5.353   142.203     0.200
     5.435   139.695     0.200
     5.823   152.188     0.200
     5.896   154.148     0.200
     5.919   155.109     0.200
     5.917   152.586     0.200
     5.952   152.352     0.200
     5.968   156.953     0.200
     5.978   156.836     0.200
     6.028   156.008     0.200
     6.099   158.594     0.200
     6.133   157.148     0.200
     6.361   167.258     0.200
     6.507   168.992     0.200
     6.947   177.492     0.200
     6.995   176.891     0.200
     7.057   177.711     0.200
     7.225   183.586     0.200
     7.351   183.891     0.200
     7.903   200.188     0.200
     8.252   206.789     0.200
     8.482   212.586     0.200
     8.630   215.586     0.200
     9.254   232.891     0.200
     9.426   234.891     0.200
     9.545   239.992     0.200
     9.608   241.391     0.200
     9.619   241.188     0.200
     9.652   240.789     0.200
     2.735    76.676     0.200
     3.323    91.477     0.200
     3.789   102.074     0.200
     3.907   107.176     0.200
     4.408   114.477     0.200
     4.669   121.004     0.200
     4.766   125.977     0.200
     4.834   126.430     0.200
     4.827   127.375     0.200
     4.863   127.730     0.200
     5.023   131.777     0.200
     5.249   137.074     0.200
     5.426   139.957     0.200
     5.770   149.176     0.200
     5.791   151.285     0.200
     5.816   147.574     0.200
     5.886   153.855     0.200
     5.910   154.789     0.200
     5.918   153.277     0.200
     5.943   154.246     0.200
     5.968   155.699     0.200
     5.973   155.957     0.200
     6.019   155.695     0.200
     6.090   157.984     0.200
     6.116   158.656     0.200
     6.125   157.223     0.200
     6.246   159.977     0.200
     6.498   169.262     0.200
     6.565   164.977     0.200
     6.918   172.777     0.200
     6.938   174.375     0.200
     6.986   176.676     0.200
     7.048   178.402     0.200
     7.218   183.777     0.200
     7.225   179.875     0.200
     7.342   185.875     0.200
     7.609   192.477     0.200
     8.243   206.375     0.200
     8.621   215.676     0.200
     9.245   228.574     0.200
     9.417   233.477     0.200
     9.537   236.777     0.200
     9.611   239.477     0.200
     9.825   243.375     0.200
     5.443   141.295     0.200
     5.614   146.402     0.200
     5.902   154.199     0.200
     6.093   159.539     0.200
     6.208   158.955     0.200
     6.584   173.414     0.200
     6.616   171.104     0.200
     6.655   173.939     0.200
     6.670   173.256     0.200
     6.702   176.527     0.200
     6.725   172.588     0.200
     6.790   175.299     0.200
     6.907   177.387     0.200
     7.813   198.857     0.200
     7.827   197.898     0.200
     5.624   146.748     0.200
     5.627   146.262     0.200
     5.909   154.688     0.200
     6.102   157.119     0.200
     6.219   158.092     0.200
     6.534   170.244     0.200
     6.591   172.998     0.200
     6.621   172.838     0.200
     6.661   173.809     0.200
     6.679   171.217     0.200
     6.673   175.592     0.200
     6.737   171.377     0.200
     6.800   175.430     0.200
     6.919   176.240     0.200
     7.822   198.645     0.200
     2.863    80.379     0.200
     3.141    86.777     0.200
     3.172    88.078     0.200
     3.357    92.180     0.200
     3.386    92.777     0.200
     3.509    95.680     0.200
     3.525    96.078     0.200
     3.586    97.480     0.200
     3.654    99.777     0.200
     3.654    99.078     0.200
     3.774   101.980     0.200
     3.994   107.777     0.200
     3.994   107.277     0.200
     4.108   111.777     0.200
     4.141   110.879     0.200
     4.256   113.578     0.200
     4.288   115.578     0.200
     4.455   119.578     0.200
     4.477   120.379     0.200
     4.546   120.879     0.200
     4.587   124.148     0.200
     4.744   126.078     0.200
     4.933   130.277     0.200
     4.965   130.480     0.200
     5.198   136.777     0.200
     5.254   138.680     0.200
     5.454   143.523     0.200
     5.534   145.578     0.200
     5.570   146.277     0.200
     5.593   144.879     0.200
     5.625   147.125     0.200
     5.776   150.578     0.200
     5.911   154.559     0.200
     5.970   154.078     0.200
     6.104   157.434     0.200
     6.176   158.578     0.200
     6.197   160.180     0.200
     6.220   159.871     0.200
     6.277   162.680     0.200
     6.536   170.117     0.200
     6.593   174.082     0.200
     6.623   171.012     0.200
     6.663   172.496     0.200
     6.681   173.090     0.200
     6.709   176.379     0.200
     6.737   173.508     0.200
     6.801   173.883     0.200
     6.919   176.777     0.200
     7.538   190.180     0.200
     7.823   198.836     0.200
     8.116   204.980     0.200
     9.852   245.980     0.200
     5.634   146.152     0.200
     5.789   149.428     0.200
     6.987   181.664     0.200
     7.000   180.475     0.200
     8.020   203.842     0.200
     2.375    66.386     0.200
     2.635    72.986     0.200
     2.703    74.386     0.200
     2.791    75.986     0.200
     2.833    78.286     0.200
     2.862    78.386     0.200
     2.922    80.086     0.200
     2.929    81.086     0.200
     3.211    86.486     0.200
     3.302    88.586     0.200
     3.464    91.986     0.200
     3.483    93.086     0.200
     3.690    98.017     0.200
     4.734   122.659     0.200
     4.870   125.572     0.200
     4.980   128.783     0.200
     5.353   138.344     0.200
     5.435   137.962     0.200
     5.467   140.950     0.200
     5.917   150.441     0.200
     5.939   151.457     0.200
     6.010   153.631     0.200
     6.080   157.378     0.200
     6.089   154.907     0.200
     6.121   155.928     0.200
     6.162   158.587     0.200
     6.184   160.120     0.200
     6.192   158.461     0.200
     6.327   162.930     0.200
     6.357   162.656     0.200
     6.570   168.136     0.200
     6.689   168.687     0.200
     6.749   172.350     0.200
     7.048   176.187     0.200
     7.133   178.874     0.200
     7.280   181.286     0.200
     7.429   185.986     0.200
     7.481   188.187     0.200
     7.539   187.256     0.200
     7.539   188.786     0.200
     7.673   191.786     0.200
     7.738   196.187     0.200
     8.100   205.086     0.200
     8.316   208.286     0.200
     9.639   239.786     0.200
     9.871   242.187     0.200
     2.698    75.767     0.200
     3.041    86.267     0.200
     3.044    85.367     0.200
     3.281    91.767     0.200
     3.370    93.967     0.200
     3.464    96.667     0.200
     3.471    95.867     0.200
     3.574    97.767     0.200
     3.574    99.367     0.200
     3.574    99.787     0.200
     3.628   100.066     0.200
     3.670   101.457     0.200
     3.839   103.066     0.200
     3.887   105.667     0.200
     3.887   107.167     0.200
     3.999   108.566     0.200
     3.999   109.667     0.200
     4.119   110.167     0.200
     4.119   111.867     0.200
     4.149   111.467     0.200
     4.143   114.106     0.200
     4.156   113.667     0.200
     4.198   112.267     0.200
     4.284   113.367     0.200
     4.367   116.467     0.200
     4.354   116.066     0.200
     4.606   122.367     0.200
     4.620   125.066     0.200
     4.765   125.467     0.200
     4.766   125.967     0.200
     5.112   133.467     0.200
     5.134   136.365     0.200
     5.119   134.767     0.200
     5.307   140.285     0.200
     5.500   142.967     0.200
     5.906   155.088     0.200
     6.216   164.312     0.200
     6.279   165.575     0.200
     6.318   166.265     0.200
     6.353   166.828     0.200
     6.361   169.224     0.200
     6.360   167.265     0.200
     6.429   168.918     0.200
     6.481   169.020     0.200
     6.496   171.705     0.200
     6.470   164.467     0.200
     6.588   169.167     0.200
     6.607   171.460     0.200
     6.723   174.551     0.200
     6.805   176.138     0.200
     6.839   180.097     0.200
     7.503   192.667     0.200
     7.795   198.066     0.200
     3.009    84.547     0.200
     3.067    85.953     0.200
     3.146    87.352     0.200
     3.239    90.047     0.200
     3.258    90.250     0.200
     3.357    92.750     0.200
     3.382    92.852     0.200
     3.657   100.453     0.200
     3.755   102.047     0.200
     3.901   105.352     0.200
     3.929   105.094     0.200
     3.928   106.852     0.200
     4.468   119.172     0.200
     4.932   132.227     0.200
     5.126   134.195     0.200
     5.441   141.930     0.200
     5.535   145.414     0.200
     5.606   146.406     0.200
     5.685   148.945     0.200
     6.052   156.211     0.200
     6.140   160.531     0.200
     6.204   162.688     0.200
     6.224   161.648     0.200
     6.324   161.617     0.200
     6.382   165.508     0.200
     6.737   174.484     0.200
     6.796   172.344     0.200
     6.997   177.180     0.200
     7.098   183.852     0.200
     7.311   183.336     0.200
     7.452   190.039     0.200
     7.818   194.617     0.200
    10.043   249.266     0.200
     4.388   117.484     0.200
     5.140   135.352     0.200
     5.951   155.391     0.200
     6.013   158.578     0.200
     6.899   173.805     0.200
     6.970   176.883     0.200
     7.265   182.508     0.200
     7.523   188.703     0.200
     2.313    64.172     0.200
     2.367    66.047     0.200
     2.750    76.625     0.200
     2.844    77.586     0.200
     3.928   105.211     0.200
     4.374   118.398     0.200
     4.424   119.086     0.200
     4.595   122.820     0.200
     4.634   124.461     0.200
     4.682   125.633     0.200
     4.893   129.211     0.200
     5.060   134.102     0.200
     5.145   135.023     0.200
     5.309   141.805     0.200
     5.570   143.875     0.200
     5.816   152.297     0.200
     5.881   152.391     0.200
     5.923   154.484     0.200
     6.094   157.359     0.200
     6.278   162.438     0.200
     7.065   181.711     0.200
     7.101   180.391     0.200
     1.179    37.812     0.200
     2.118    60.742     0.200
     2.333    66.656     0.200
     3.872   105.055     0.200
     4.850   125.461     0.200
     5.025   129.914     0.200
     5.026   133.219     0.200
     5.062   134.711     0.200
     5.454   140.633     0.200
     5.503   143.398     0.200
     5.624   144.273     0.200
     5.624   143.383     0.200
     5.940   153.969     0.200
     6.012   157.906     0.200
     6.063   159.898     0.200
     6.090   157.812     0.200
     6.094   159.898     0.200
     6.149   157.016     0.200
     6.173   159.117     0.200
     6.197   160.719     0.200
     6.197   159.820     0.200
     6.233   161.281     0.200
     6.325   161.734     0.200
     6.368   167.188     0.200
     6.463   167.922     0.200
     6.524   168.062     0.200
     6.545   170.547     0.200
     6.590   172.375     0.200
     6.675   170.781     0.200
     6.759   170.484     0.200
     6.939   177.484     0.200
     7.032   178.312     0.200
     7.125   180.281     0.200
     7.166   178.984     0.200
     7.220   182.594     0.200
     7.220   183.008     0.200
     7.501   189.086     0.200
     7.503   191.586     0.200
     7.513   188.484     0.200
     7.592   191.000     0.200
     7.658   191.781     0.200
     7.767   194.203     0.200
     7.767   194.383     0.200
     7.789   193.984     0.200
     7.916   200.484     0.200
     7.963   201.188     0.200
     8.017   201.688     0.200
     8.291   205.945     0.200
     8.300   207.586     0.200
     8.332   207.586     0.200
     8.362   210.586     0.200
     8.531   214.281     0.200
     8.545   214.688     0.200
     8.545   215.383     0.200
     8.675   215.984     0.200
     8.982   223.688     0.200
     9.029   231.625     0.200
     9.246   230.281     0.200
     9.356   234.188     0.200
     9.460   235.688     0.200
     9.551   238.188     0.200
     9.648   240.188     0.200
     9.688   239.086     0.200
     9.721   242.984     0.200
     9.980   252.484     0.200
    10.219   253.812     0.200
    10.779   272.344     0.200
    10.973   275.477     0.200
    11.121   273.781     0.200
    15.531   388.742     0.200
    16.920   423.797     0.200
    18.510   461.273     0.200
    18.510   459.586     0.200
    18.568   454.500     0.200
    19.066   474.781     0.200
     1.263    40.995     0.200
     1.602    49.820     0.200
     3.025    84.100     0.200
     3.426    96.179     0.200
     3.527    95.092     0.200
     3.629    99.100     0.200
     3.686   100.050     0.200
     4.169   113.370     0.200
     4.373   115.340     0.200
     4.530   118.100     0.200
     4.616   119.650     0.200
     4.694   122.730     0.200
     4.880   128.344     0.200
     4.912   130.190     0.200
     5.289   138.032     0.200
     5.809   150.987     0.200
     5.903   154.046     0.200
     5.927   155.484     0.200
     5.975   157.425     0.200
     5.985   157.425     0.200
     5.990   157.310     0.200
     6.036   156.553     0.200
     6.141   159.014     0.200
     6.368   165.404     0.200
     6.514   168.579     0.200
     7.065   179.225     0.200
     7.209   184.320     0.200
     7.304   190.680     0.200
     7.315   186.968     0.200
     7.315   187.180     0.200
     7.359   185.680     0.200
     7.579   191.124     0.200
     7.626   193.780     0.200
     8.837   231.080     0.200
    10.208   253.418     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.580    18.941     0.200
     2.947    85.441     0.200
     3.862   111.941     0.200
     0.542    18.869     0.200
     2.943    86.369     0.200
     4.941   147.869     0.200
     8.882   259.869     0.200
     0.450    15.473     0.200
     0.691    22.473     0.200
     2.042    61.973     0.200
     2.499    73.473     0.200
     4.196   120.008     0.200
    10.562   311.008     0.200
     3.631   106.859     0.200
     2.135    65.539     0.200
     8.845   252.039     0.200
    10.281   334.039     0.200
     3.322    94.017     0.200
     4.111   117.416     0.200
     4.398   122.616     0.200
     4.895   143.616     0.200
     6.525   181.616     0.200
     9.756   285.616     0.200
    10.601   305.616     0.200
     0.899    30.738     0.200
     2.992    87.238     0.200
     4.125   120.246     0.200
     4.193   116.750     0.200
     0.615    22.250     0.200
     3.405    96.750     0.200
     7.352   208.227     0.200
     2.026    66.531     0.200
     2.212    65.633     0.200
    10.318   293.133     0.200
     0.664    23.764     0.200
     2.265    69.764     0.200
     3.617   104.564     0.200
     6.936   198.764     0.200
     7.314   206.764     0.200
     2.170    69.872     0.200
     2.070    63.242     0.200
     2.787    81.141     0.200
     3.326    94.844     0.200
     3.222    95.184     0.200
     3.399    97.184     0.200
     9.798   278.684     0.200
     0.701    24.957     0.200
     2.192    67.457     0.200
     5.888   175.957     0.200
     9.222   263.457     0.200
     2.022    60.719     0.200
     3.012    90.219     0.200
     3.745   111.719     0.200
     5.970   175.719     0.200
     7.335   218.219     0.200
     7.997   234.719     0.200
     0.090     4.547     0.200
     1.225    39.547     0.200
     1.294    41.047     0.200
     2.134    70.047     0.200
     2.236    68.047     0.200
     3.197    95.047     0.200
     5.494   154.750     0.200
     0.093     5.535     0.200
     1.289    39.535     0.200
     2.168    69.535     0.200
     2.343    72.535     0.200
     2.311    70.535     0.200
     2.465    73.535     0.200
     2.759    79.535     0.200
     4.168   120.434     0.200
     1.453    46.057     0.200
     1.260    40.783     0.200
     3.522    99.084     0.200
     0.377    13.969     0.200
     0.760    25.469     0.200
     1.226    38.047     0.200
     2.232    74.539     0.200
     2.254    77.578     0.200
     3.753   107.047     0.200
     3.753   112.648     0.200
     4.480   130.344     0.200
     9.182   261.047     0.200
     0.670    23.570     0.200
     1.862    56.254     0.200
     0.205     8.078     0.200
     1.254    40.281     0.200
     1.710    51.281     0.200
     1.918    57.484     0.200
     2.015    65.484     0.200
     0.600    20.430     0.200
     1.531    46.828     0.200
     1.453    47.430     0.200
     2.508    72.828     0.200
     2.675    76.531     0.200
     2.722    77.828     0.200
     2.959    83.531     0.200
     3.008    84.633     0.200
     0.733    25.469     0.200
     1.189    39.770     0.200
     0.707    23.438     0.200
     1.886    58.938     0.200
     1.363    40.305     0.200
     1.913    56.703     0.200
     1.366    40.754     0.200
     9.321   272.254     0.200
     0.349    13.500     0.200
     0.834    27.500     0.200
     9.832   278.398     0.200
     0.332    13.625     0.200
     0.628    22.125     0.200
     3.833   109.926     0.200
     0.661    23.057     0.200
     1.437    44.057     0.200
     1.459    44.057     0.200
     2.664    76.256     0.200
     2.825    79.957     0.200
     2.921    82.357     0.200
     3.029    85.057     0.200
     3.160    88.457     0.200
     0.572    20.383     0.200
     1.052    34.086     0.200
     1.179    37.586     0.200
     1.619    48.086     0.200
     1.727    50.984     0.200
     1.995    58.883     0.200
     4.655   136.586     0.200
     6.021   174.086     0.200
     9.693   278.289     0.200
     0.310    12.641     0.200
     6.671   190.844     0.200
     6.834   202.141     0.200
     0.683    23.656     0.200
     0.335    13.289     0.200
     0.722    25.589     0.200
     1.738    52.578     0.200
     3.100    91.781     0.200
     7.567   212.078     0.200
     8.565   242.756     0.200
     0.162     5.168     0.200
     0.627    20.867     0.200
     0.685    22.668     0.200
     0.704    24.066     0.200
     0.786    26.969     0.200
     0.787    26.367     0.200
     0.895    29.668     0.200
     2.414    70.969     0.200
     2.863    83.188     0.200
     3.317    96.516     0.200
     0.570    19.480     0.200
     0.629    20.582     0.200
     0.739    23.582     0.200
     1.575    49.383     0.200
     0.190     6.143     0.200
     0.647    22.843     0.200
     0.731    24.043     0.200
     0.922    31.743     0.200
     2.390    70.743     0.200
     2.551    76.493     0.200
     2.837    82.303     0.200
     3.290    94.173     0.200
     0.176     7.574     0.200
     0.522    17.473     0.200
     0.669    22.973     0.200
     0.834    26.473     0.200
     0.935    30.375     0.200
     2.394    68.922     0.200
     2.578    74.172     0.200
     4.118   123.773     0.200
     4.515   124.773     0.200
     0.187     8.992     0.200
     0.255    11.891     0.200
     0.764    24.289     0.200
     0.780    25.695     0.200
     1.082    34.289     0.200
     2.441    75.055     0.200
     2.673    77.469     0.200
     3.333    96.148     0.200
     3.382    98.820     0.200
     0.517    17.651     0.200
     0.499    17.802     0.200
     0.558    19.852     0.200
     0.732    25.352     0.200
     0.791    25.352     0.200
     0.840    29.231     0.200
     1.040    34.211     0.200
     0.448    15.746     0.200
     0.510    17.188     0.200
     1.189    38.797     0.200
     2.780    80.586     0.200
     2.955    85.527     0.200
     4.897   147.238     0.200
     5.776   173.035     0.200
     6.673   197.637     0.200
     6.875   203.535     0.200
     9.689   281.637     0.200
     0.482    16.484     0.200
     0.485    17.105     0.200
     0.722    25.395     0.200
     0.759    25.816     0.200
     0.418    14.590     0.200
     0.528    18.039     0.200
     0.514    18.188     0.200
     0.546    19.020     0.200
     1.269    40.129     0.200
     9.701   277.078     0.200
     0.585    19.477     0.200
     0.735    26.078     0.200
     0.862    28.398     0.200
     9.681   283.957     0.200
     0.518    18.418     0.200
     0.752    25.117     0.200
     0.810    27.547     0.200
     0.533    18.914     0.200
     0.806    27.898     0.200
     3.775   108.797     0.200
     0.502    17.727     0.200
     0.573    19.562     0.200
     0.813    28.344     0.200
     1.049    34.469     0.200
     0.458    14.871     0.200
     0.488    17.691     0.200
     0.505    18.340     0.200
     0.570    18.879     0.200
     0.721    25.809     0.200
     0.800    27.039     0.200
     0.779    27.910     0.200
     0.835    28.750     0.200
     1.031    34.680     0.200
     1.169    37.840     0.200
     0.469    15.918     0.200
     0.492    16.738     0.200
     0.583    19.449     0.200
     1.017    33.051     0.200
     0.421    15.062     0.200
     4.007   111.410     0.200
     4.502   133.000     0.200
     5.799   168.699     0.200
     6.899   194.000     0.200
     9.706   274.801     0.200
     0.391    13.285     0.200
     0.501    17.566     0.200
     0.573    18.867     0.200
     0.528    19.027     0.200
     0.766    25.758     0.200
     0.568    18.680     0.200
     0.525    18.281     0.200
     0.842    26.828     0.200
     0.502    16.438     0.200
     0.573    18.250     0.200
     0.847    28.648     0.200
     0.561    19.633     0.200
     0.771    27.363     0.200
     0.782    27.883     0.200
     1.463    46.035     0.200
     1.676    51.094     0.200
     0.509    17.047     0.200
     0.538    19.227     0.200
     0.566    21.145     0.200
     0.756    26.754     0.200
     0.774    27.535     0.200
     0.840    29.574     0.200
     0.516    18.051     0.200
     0.560    18.340     0.200
     0.777    26.328     0.200
     0.869    29.590     0.200
     1.079    34.539     0.200
     2.814    81.867     0.200
     2.986    86.469     0.200
     4.006   115.488     0.200
     4.521   132.438     0.200
     4.935   144.539     0.200
     9.172   260.938     0.200
     9.674   277.340     0.200
     0.534    19.824     0.200
     0.550    18.945     0.200
     0.528    18.367     0.200
     0.766    27.156     0.200
     0.878    28.574     0.200
     0.800    28.785     0.200
     0.513    17.289     0.200
     0.522    18.227     0.200
     0.561    19.188     0.200
     1.185    38.047     0.200
     1.645    48.711     0.200
     0.567    19.188     0.200
     0.549    19.570     0.200
     0.785    27.648     0.200
     0.839    28.117     0.200
     0.490    15.875     0.200
     0.584    20.805     0.200
     0.859    28.484     0.200
     3.019    85.016     0.200
     3.940   109.570     0.200
     9.694   275.383     0.200
     0.507    16.894     0.200
     0.529    18.233     0.200
     0.820    27.533     0.200
     1.174    37.883     0.200
     1.634    48.383     0.200
     3.788   106.033     0.200
     0.530    19.999     0.200
     0.541    20.648     0.200
     0.782    26.078     0.200
     0.764    27.509     0.200
     0.865    29.519     0.200
     0.392    13.131     0.200
     0.499    17.531     0.200
     0.575    20.852     0.200
     0.743    25.211     0.200
     0.852    29.160     0.200
     0.849    28.842     0.200
     9.218   261.541     0.200
     0.405    13.914     0.200
     0.516    17.465     0.200
     0.558    18.734     0.200
     0.752    26.027     0.200
     0.833    28.215     0.200
     0.394    13.500     0.200
     0.498    17.531     0.200
     0.850    29.180     0.200
     0.556    18.367     0.200
     0.518    19.438     0.200
     0.495    17.469     0.200
     0.787    27.195     0.200
     0.728    24.547     0.200
     0.793    27.102     0.200
     1.035    35.547     0.200
     0.492    17.578     0.200
     0.566    20.133     0.200
     0.724    24.859     0.200
     0.782    26.719     0.200
     0.837    28.578     0.200
     0.541    18.889     0.200
     0.574    19.990     0.200
     0.777    26.459     0.200
     1.075    35.510     0.200
     4.951   150.340     0.200
     9.685   274.740     0.200
     0.560    20.979     0.200
     0.756    26.300     0.200
     0.834    28.760     0.200
     3.802   108.260     0.200
     4.520   132.060     0.200
     0.425    14.820     0.200
     0.531    18.742     0.200
     0.544    18.602     0.200
     0.757    25.703     0.200
     0.817    28.402     0.200
     0.854    28.312     0.200
     1.061    34.980     0.200
     0.509    16.680     0.200
     0.461    17.602     0.200
     6.651   187.133     0.200
     9.688   273.133     0.200
     0.272     9.188     0.200
     0.401    13.746     0.200
     0.456    16.039     0.200
     0.514    17.477     0.200
     0.560    18.348     0.200
     0.561    17.969     0.200
     0.744    25.488     0.200
     0.829    27.777     0.200
     0.836    27.809     0.200
     1.127    35.117     0.200
     1.954    57.277     0.200
     0.425    13.586     0.200
     0.480    15.625     0.200
     0.533    18.086     0.200
     0.518    19.695     0.200
     0.548    17.016     0.200
     0.542    18.848     0.200
     0.581    18.617     0.200
     0.773    26.969     0.200
     0.816    28.297     0.200
     6.622   191.996     0.200
     7.484   209.797     0.200
     0.253     9.617     0.200
     0.461    15.195     0.200
     0.502    16.695     0.200
     0.530    17.266     0.200
     0.534    18.094     0.200
     0.562    18.102     0.200
     0.816    26.523     0.200
     1.039    33.922     0.200
     0.196     7.523     0.200
     0.471    15.906     0.200
     0.472    16.578     0.200
     0.556    20.195     0.200
     0.602    20.258     0.200
     4.536   131.316     0.200
     9.710   275.617     0.200
     0.372    12.309     0.200
     0.465    15.840     0.200
     0.482    17.020     0.200
     0.521    17.527     0.200
     0.592    20.777     0.200
     0.845    29.609     0.200
     0.867    28.719     0.200
     0.487    16.729     0.200
     0.536    18.158     0.200
     0.523    17.738     0.200
     0.587    19.358     0.200
     0.862    28.089     0.200
     0.431    14.627     0.200
     0.485    16.507     0.200
     0.537    18.387     0.200
     0.554    18.457     0.200
     0.538    19.297     0.200
     0.811    28.247     0.200
     1.058    36.507     0.200
     0.317    11.359     0.200
     0.472    15.672     0.200
     0.457    16.289     0.200
     0.521    18.180     0.200
     0.617    21.453     0.200
     0.799    27.797     0.200
     0.891    30.070     0.200
     0.316    12.371     0.200
     0.466    16.402     0.200
     0.455    15.211     0.200
     0.506    16.090     0.200
     4.315   123.453     0.200
     0.261    10.820     0.200
     0.467    16.750     0.200
     0.533    18.859     0.200
     0.839    28.258     0.200
     6.699   196.992     0.200
     6.901   193.992     0.200
     9.207   258.594     0.200
     0.285    10.005     0.200
     0.585    19.255     0.200
     0.859    28.655     0.200
     1.202    38.475     0.200
     0.286     9.737     0.200
     0.491    16.478     0.200
     0.537    18.498     0.200
     0.583    19.777     0.200
     0.858    28.688     0.200
     0.478    16.822     0.200
     0.544    19.354     0.200
     0.597    20.992     0.200
     0.782    26.693     0.200
     0.297    10.648     0.200
     0.371    12.809     0.200
     0.604    21.879     0.200
     0.878    30.078     0.200
     1.099    37.020     0.200
     0.054     4.117     0.200
     0.246     9.320     0.200
     0.424    14.320     0.200
     0.515    18.320     0.200
     0.533    18.523     0.200
     0.542    18.719     0.200
     0.759    26.045     0.200
     0.070     4.727     0.200
     6.704   219.629     0.200
     6.906   203.828     0.200
     9.703   276.328     0.200
     0.366    11.850     0.200
     0.600    21.850     0.200
     2.209    64.830     0.200
     2.403    69.670     0.200
     2.465    70.850     0.200
     2.674    76.051     0.200
     2.688    76.871     0.200
     0.234     9.734     0.200
     0.548    19.535     0.200
     0.505    17.434     0.200
     0.739    25.035     0.200
     2.397    69.885     0.200
     0.253    11.070     0.200
     0.400    15.070     0.200
     0.564    19.773     0.200
     0.743    24.570     0.200
     0.903    28.570     0.200
     1.185    35.672     0.200
     0.030     3.219     0.200
     0.444    16.219     0.200
     0.444    16.719     0.200
     0.488    16.316     0.200
     0.464    16.219     0.200
     0.518    17.719     0.200
     0.560    20.816     0.200
     0.793    27.617     0.200
     2.786    81.469     0.200
     2.964    85.988     0.200
     3.043    88.129     0.200
     3.245    93.617     0.200
     3.333    95.199     0.200
     0.155     8.074     0.200
     0.762    24.176     0.200
     0.819    26.475     0.200
     1.224    37.775     0.200
     1.655    49.596     0.200
     1.655    49.885     0.200
     1.988    57.875     0.200
     0.074     4.650     0.200
     0.418    16.250     0.200
     0.543    18.951     0.200
     1.073    35.750     0.200
     1.627    49.551     0.200
     2.136    66.451     0.200
     2.398    70.680     0.200
     0.440    16.023     0.200
     0.563    18.828     0.200
     0.393    13.664     0.200
     0.435    15.367     0.200
     0.536    19.664     0.200
     0.583    20.367     0.200
     0.583    19.461     0.200
     0.678    22.164     0.200
     0.729    23.867     0.200
     0.748    25.562     0.200
     0.815    27.266     0.200
     0.973    32.164     0.200
     1.084    35.461     0.200
     3.286    95.422     0.200
     3.400    97.242     0.200
     0.238    10.164     0.200
     0.363    14.164     0.200
     0.515    16.859     0.200
     0.599    21.359     0.200
     0.625    20.359     0.200
     0.726    23.859     0.200
     0.772    25.961     0.200
     0.787    26.359     0.200
     0.782    26.062     0.200
     2.260    65.758     0.200
     2.287    67.711     0.200
     2.457    71.172     0.200
     2.553    73.414     0.200
     2.739    78.188     0.200
     2.792    79.617     0.200
     2.826    79.648     0.200
     2.837    79.828     0.200
     9.029   258.914     0.200
     0.127     5.633     0.200
     0.177     6.328     0.200
     0.325    12.227     0.200
     0.351    12.430     0.200
     0.407    14.031     0.200
     0.075     5.961     0.200
     0.222     9.562     0.200
     0.304    12.562     0.200
     0.305    11.656     0.200
     0.392    13.656     0.200
     0.425    14.859     0.200
     0.410    15.156     0.200
     0.448    14.062     0.200
     0.499    17.656     0.200
     0.467    16.258     0.200
     0.696    22.758     0.200
     0.691    23.758     0.200
     0.842    28.359     0.200
     1.640    50.656     0.200
     2.442    70.711     0.200
     0.143     9.590     0.200
     0.199    10.988     0.200
     2.081    60.590     0.200
     2.269    65.688     0.200
     2.342    66.789     0.200
     2.543    72.391     0.200
     2.628    74.090     0.200
     2.628    74.090     0.200
     2.645    74.891     0.200
     0.261    12.176     0.200
     0.296    13.375     0.200
     0.374    13.977     0.200
     0.422    16.375     0.200
     0.532    19.676     0.200
     0.554    20.277     0.200
     0.562    19.676     0.200
     0.556    20.277     0.200
     0.623    21.676     0.200
     0.623    21.375     0.200
     0.626    21.277     0.200
     0.654    22.477     0.200
     0.803    26.375     0.200
     2.059    62.078     0.200
     2.863    81.875     0.200
     0.265    11.977     0.200
     0.299    13.172     0.200
     0.313    13.672     0.200
     0.374    15.875     0.200
     0.417    16.570     0.200
     0.534    19.570     0.200
     0.557    19.977     0.200
     0.558    20.570     0.200
     0.550    19.570     0.200
     0.616    21.477     0.200
     0.672    23.273     0.200
     0.658    22.672     0.200
     0.620    20.875     0.200
     0.697    23.672     0.200
     0.799    26.273     0.200
     0.833    27.172     0.200
     1.278    39.172     0.200
     0.045     5.836     0.200
     0.167     9.031     0.200
     0.232    10.133     0.200
     0.244    10.633     0.200
     0.298    11.633     0.200
     0.328    11.836     0.200
     0.394    13.531     0.200
     0.382    14.430     0.200
     0.449    15.133     0.200
     0.663    22.633     0.200
     0.708    24.031     0.200
     0.817    27.336     0.200
     0.921    30.336     0.200
     1.183    37.531     0.200
     2.820    80.031     0.200
     0.255    10.438     0.200
     0.298    12.338     0.200
     0.420    14.538     0.200
     0.539    18.738     0.200
     0.429    16.738     0.200
     0.454    16.938     0.200
     0.630    20.738     0.200
     0.697    23.438     0.200
     0.742    25.438     0.200
     0.781    25.938     0.200
     0.819    27.038     0.200
     0.810    26.738     0.200
     0.875    27.838     0.200
     0.856    28.638     0.200
     0.934    30.138     0.200
     1.344    40.438     0.200
     2.384    69.338     0.200
     2.649    76.438     0.200
     2.712    77.438     0.200
     2.795    79.938     0.200
     2.837    80.538     0.200
     2.851    81.138     0.200
     2.885    82.338     0.200
     2.934    82.538     0.200
     2.934    82.538     0.200
     0.218     9.488     0.200
     0.342    13.288     0.200
     0.366    14.388     0.200
     0.362    12.888     0.200
     0.532    16.788     0.200
     0.604    20.588     0.200
     0.747    24.188     0.200
     0.747    25.168     0.200
     0.789    26.518     0.200
     0.780    25.188     0.200
     0.780    26.138     0.200
     0.800    26.688     0.200
     0.870    28.488     0.200
     0.980    32.088     0.200
     2.267    66.188     0.200
     2.440    70.688     0.200
     2.533    73.088     0.200
     2.595    74.188     0.200
     2.627    75.188     0.200
     2.679    76.588     0.200
     2.721    77.188     0.200
     2.735    77.588     0.200
     2.771    78.588     0.200
     0.053     5.427     0.200
     0.256    10.727     0.200
     0.336    12.927     0.200
     0.314    12.127     0.200
     0.306    12.527     0.200
     0.426    15.127     0.200
     0.476    17.127     0.200
     0.540    18.827     0.200
     1.422    44.427     0.200
     2.927    85.827     0.200
     3.147    90.927     0.200
     3.170    91.027     0.200
     3.254    93.727     0.200
     3.306    94.427     0.200
     3.317    94.927     0.200
     3.371    96.027     0.200
     3.418    96.827     0.200
     3.443    97.927     0.200
     0.048     4.460     0.200
     0.116     4.510     0.200
     0.291    10.910     0.200
     0.261    10.811     0.200
     0.254    10.910     0.200
     0.370    13.210     0.200
     0.315    11.811     0.200
     0.343    13.710     0.200
     0.317    13.040     0.200
     0.423    14.410     0.200
     0.484    16.610     0.200
     0.551    19.110     0.200
     1.351    43.010     0.200
     2.662    79.210     0.200
     2.941    85.110     0.200
     2.970    86.811     0.200
     3.161    90.811     0.200
     3.268    93.710     0.200
     3.319    94.410     0.200
     3.331    95.010     0.200
     3.457    98.410     0.200
     0.039     4.201     0.200
     0.120     5.602     0.200
     0.312    11.900     0.200
     0.299    10.900     0.200
     0.256    10.701     0.200
     0.307    11.900     0.200
     0.375    12.301     0.200
     0.318    12.701     0.200
     0.412    14.002     0.200
     0.496    17.102     0.200
     0.564    19.400     0.200
     1.351    42.801     0.200
     2.417    71.201     0.200
     2.949    85.602     0.200
     3.168    91.201     0.200
     3.194    90.900     0.200
     3.276    93.602     0.200
     3.325    94.502     0.200
     3.338    95.201     0.200
     3.464    98.502     0.200
     0.063     6.566     0.200
     0.173     8.676     0.200
     0.216     9.879     0.200
     0.228     9.477     0.200
     0.291    10.879     0.200
     0.321    12.176     0.200
     0.429    14.578     0.200
     0.394    15.078     0.200
     0.451    15.879     0.200
     0.504    17.777     0.200
     0.513    17.477     0.200
     0.766    24.977     0.200
     2.069    60.188     0.200
     2.446    70.578     0.200
     2.493    72.637     0.200
     2.603    75.309     0.200
     2.897    82.477     0.200
     0.180     8.406     0.200
     0.289    10.355     0.200
     0.421    15.156     0.200
     0.507    16.676     0.200
     0.587    20.137     0.200
     0.990    30.707     0.200
     1.130    35.777     0.200
     1.851    56.797     0.200
     2.421    69.496     0.200
     9.968   285.926     0.200
    10.060   292.617     0.200
     0.176     7.617     0.200
     0.186     8.398     0.200
     0.181     8.312     0.200
     0.285    10.211     0.200
     0.300    10.969     0.200
     0.307    11.672     0.200
     0.385    13.188     0.200
     0.463    16.312     0.200
     0.521    17.656     0.200
     2.852    85.102     0.200
     2.887    82.578     0.200
     0.151     6.922     0.200
     0.196     8.492     0.200
     0.206     8.547     0.200
     0.284    10.406     0.200
     0.375    13.602     0.200
     0.385    14.094     0.200
     0.608    19.633     0.200
     1.872    57.797     0.200
     2.900    82.219     0.200
     0.144     6.727     0.200
     0.201     7.477     0.200
     0.213     8.711     0.200
     0.265    10.312     0.200
     0.337    12.961     0.200
     0.371    13.109     0.200
     0.387    14.219     0.200
     0.376    13.398     0.200
     0.679    23.312     0.200
     1.055    34.312     0.200
     1.993    59.312     0.200
     2.334    67.023     0.200
     0.046     4.752     0.200
     0.099     5.332     0.200
     0.192     7.961     0.200
     0.192     8.371     0.200
     0.174     8.012     0.200
     0.174     8.152     0.200
     0.204     8.822     0.200
     0.204     9.121     0.200
     0.285    11.252     0.200
     0.336    12.172     0.200
     0.336    11.162     0.200
     0.440    15.801     0.200
     0.780    24.742     0.200
     1.028    32.762     0.200
     1.742    53.941     0.200
     0.043     5.152     0.200
     0.186     8.232     0.200
     0.177     7.992     0.200
     0.198     9.434     0.200
     0.318    11.723     0.200
     0.293    11.412     0.200
     1.835    58.211     0.200
     0.139     7.559     0.200
     0.143     7.178     0.200
     0.230    10.238     0.200
     0.257    10.908     0.200
     0.334    12.738     0.200
     0.345    12.777     0.200
     0.371    13.447     0.200
     0.401    14.188     0.200
     0.445    15.639     0.200
     0.461    16.357     0.200
     0.480    16.348     0.200
     0.481    17.008     0.200
     0.528    18.129     0.200
     0.610    21.338     0.200
     0.729    24.098     0.200
     0.070     5.273     0.200
     0.117     6.844     0.200
     0.324    11.684     0.200
     0.351    12.594     0.200
     0.365    12.797     0.200
     0.475    16.344     0.200
     0.495    16.934     0.200
     0.541    17.805     0.200
     0.613    20.363     0.200
     0.681    23.316     0.200
     0.704    23.453     0.200
     2.162    70.625     0.200
     2.337    69.523     0.200
     9.702   279.625     0.200
     0.182     8.191     0.200
     0.290    11.543     0.200
     0.356    13.441     0.200
     0.375    13.781     0.200
     0.423    15.715     0.200
     0.418    15.555     0.200
     0.603    20.504     0.200
     0.612    21.375     0.200
     0.631    22.473     0.200
     0.680    23.055     0.200
     0.701    24.625     0.200
     0.700    24.273     0.200
     0.743    25.793     0.200
     0.848    28.473     0.200
     0.903    29.191     0.200
     0.912    28.922     0.200
     2.432    70.805     0.200
     2.618    75.305     0.200
     2.689    77.102     0.200
     2.760    78.703     0.200
     2.851    80.805     0.200
     2.885    81.805     0.200
     2.894    81.902     0.200
     2.911    82.402     0.200
     2.977    84.004     0.200
     2.992    84.305     0.200
     0.290    11.699     0.200
     0.359    14.191     0.200
     0.431    15.570     0.200
     0.440    15.641     0.200
     0.419    15.969     0.200
     0.605    20.250     0.200
     0.620    20.309     0.200
     0.623    20.871     0.200
     0.648    21.480     0.200
     0.695    22.941     0.200
     0.714    23.930     0.200
     0.761    24.961     0.200
     0.865    28.410     0.200
     0.906    29.621     0.200
     0.920    29.629     0.200
     0.953    31.020     0.200
     0.958    31.371     0.200
     1.010    32.211     0.200
     1.109    35.211     0.200
     1.301    40.488     0.200
     1.633    50.520     0.200
     1.625    51.258     0.200
     2.069    63.668     0.200
     2.061    61.398     0.200
     2.133    62.828     0.200
     0.061     6.742     0.200
     0.186     8.383     0.200
     0.241     9.512     0.200
     0.223     9.832     0.200
     0.301    11.734     0.200
     0.314    10.824     0.200
     0.381    13.754     0.200
     0.423    14.891     0.200
     0.420    14.961     0.200
     0.476    16.203     0.200
     0.514    16.734     0.200
     0.524    17.883     0.200
     0.569    19.262     0.200
     0.604    19.953     0.200
     0.658    21.344     0.200
     0.726    23.641     0.200
     0.719    24.793     0.200
     0.728    24.723     0.200
     0.039     3.617     0.200
     0.194     7.719     0.200
     0.239    10.422     0.200
     0.250     9.422     0.200
     0.311    11.219     0.200
     0.332    10.922     0.200
     0.338    11.617     0.200
     0.355    12.523     0.200
     0.404    14.023     0.200
     0.399    15.422     0.200
     0.421    15.922     0.200
     0.480    17.617     0.200
     0.510    16.547     0.200
     0.614    20.922     0.200
     0.724    25.008     0.200
     0.852    29.039     0.200
     1.262    40.117     0.200
     1.975    61.273     0.200
     0.029     3.594     0.200
     0.170     6.828     0.200
     0.222     8.938     0.200
     0.249     9.914     0.200
     0.295    10.828     0.200
     0.304    11.328     0.200
     0.338    12.422     0.200
     0.333    12.023     0.200
     0.390    13.797     0.200
     0.427    14.828     0.200
     0.453    15.023     0.200
     0.616    20.125     0.200
     0.733    24.227     0.200
     0.878    28.867     0.200
     0.990    31.625     0.200
     2.103    61.734     0.200
     2.142    62.219     0.200
     0.031     3.750     0.200
     0.244     9.450     0.200
     0.236    10.350     0.200
     0.303    11.550     0.200
     0.324    12.150     0.200
     0.355    12.650     0.200
     0.342    12.750     0.200
     0.406    15.150     0.200
     0.609    20.850     0.200
     2.081    61.350     0.200
     0.044     3.914     0.200
     0.192     6.727     0.200
     0.251     8.477     0.200
     0.245    10.602     0.200
     0.316    11.555     0.200
     0.334    12.008     0.200
     0.397    15.344     0.200
     0.410    14.086     0.200
     0.621    20.703     0.200
     0.032     3.953     0.200
     0.196     7.555     0.200
     0.233    10.055     0.200
     0.248     9.359     0.200
     0.303    10.758     0.200
     0.327    11.859     0.200
     0.345    12.555     0.200
     0.359    12.953     0.200
     0.396    13.453     0.200
     0.403    15.055     0.200
     0.607    20.555     0.200
     0.857    28.453     0.200
     2.077    61.078     0.200
     0.043     4.400     0.200
     0.169     7.541     0.200
     0.205     9.102     0.200
     0.246     9.590     0.200
     0.237     9.811     0.200
     0.314    11.420     0.200
     0.381    14.111     0.200
     0.453    15.900     0.200
     0.454    16.400     0.200
     0.528    17.811     0.200
     0.535    18.301     0.200
     0.522    17.900     0.200
     0.520    17.500     0.200
     0.520    18.201     0.200
     0.557    19.500     0.200
     0.624    20.301     0.200
     0.633    21.000     0.200
     0.668    21.900     0.200
     0.669    22.500     0.200
     0.663    22.371     0.200
     0.681    22.941     0.200
     0.709    24.490     0.200
     0.786    25.080     0.200
     0.889    28.900     0.200
     0.944    30.000     0.200
     1.181    37.500     0.200
     1.732    51.854     0.200
     2.887    82.945     0.200
     3.414   102.291     0.200
     0.033     4.227     0.200
     0.151     7.125     0.200
     0.193     7.625     0.200
     0.236    10.625     0.200
     0.246     9.727     0.200
     0.305    11.125     0.200
     0.327    11.836     0.200
     0.341    12.824     0.200
     0.355    12.824     0.200
     0.404    15.027     0.200
     0.682    23.625     0.200
     2.079    61.586     0.200
     2.118    61.785     0.200
     3.530   101.414     0.200
     0.135     7.422     0.200
     0.257    10.789     0.200
     0.249    10.516     0.200
     0.194     9.016     0.200
     0.330    13.258     0.200
     0.416    15.109     0.200
     0.501    16.805     0.200
     0.463    15.750     0.200
     0.561    19.320     0.200
     0.557    19.586     0.200
     0.487    17.180     0.200
     0.589    20.148     0.200
     0.568    19.328     0.200
     0.637    21.961     0.200
     0.771    25.016     0.200
     0.743    25.289     0.200
     0.764    26.109     0.200
     0.887    28.055     0.200
     2.758    78.500     0.200
     0.065     6.523     0.200
     0.173     8.773     0.200
     0.176     8.734     0.200
     0.234     9.773     0.200
     0.236    10.125     0.200
     0.304    12.062     0.200
     0.303    11.992     0.200
     0.368    14.281     0.200
     0.372    13.320     0.200
     0.455    16.633     0.200
     0.474    16.422     0.200
     0.489    15.969     0.200
     0.501    17.633     0.200
     0.574    19.172     0.200
     0.591    19.969     0.200
     0.620    20.398     0.200
     0.664    22.258     0.200
     0.721    24.438     0.200
     0.061     7.211     0.200
     0.164     8.742     0.200
     0.184     9.219     0.200
     0.227     9.844     0.200
     0.238    10.039     0.200
     0.300    12.344     0.200
     0.311    12.039     0.200
     0.373    13.641     0.200
     0.377    13.445     0.200
     0.419    15.141     0.200
     0.474    16.641     0.200
     0.464    16.344     0.200
     0.486    16.242     0.200
     0.527    17.539     0.200
     0.510    16.945     0.200
     0.569    19.141     0.200
     0.575    19.742     0.200
     0.601    19.742     0.200
     0.618    20.641     0.200
     0.712    22.742     0.200
     0.958    31.031     0.200
     0.921    30.422     0.200
     0.107     8.983     0.200
     0.196    10.104     0.200
     0.182    10.504     0.200
     0.325    14.204     0.200
     0.503    18.704     0.200
     0.669    22.804     0.200
     0.920    29.304     0.200
     0.861    27.504     0.200
     1.401    41.946     0.200
     2.656    76.864     0.200
     0.571    20.435     0.200
     0.761    24.935     0.200
     1.001    33.335     0.200
     1.003    33.635     0.200
     1.036    34.085     0.200
     0.082     5.866     0.200
     0.140     7.776     0.200
     0.207     8.996     0.200
     0.218     9.486     0.200
     0.306    11.216     0.200
     0.301    12.296     0.200
     0.344    12.356     0.200
     0.396    14.296     0.200
     0.337    12.776     0.200
     0.347    13.046     0.200
     0.420    15.026     0.200
     0.365    14.326     0.200
     0.402    14.636     0.200
     0.415    15.416     0.200
     0.476    16.946     0.200
     0.514    18.616     0.200
     0.689    23.186     0.200
     0.186     8.277     0.200
     0.231    10.195     0.200
     0.251    10.418     0.200
     0.454    15.758     0.200
     0.484    16.746     0.200
     0.534    18.625     0.200
     0.535    18.727     0.200
     0.678    23.465     0.200
     0.722    23.266     0.200
     0.913    28.965     0.200
     1.840    53.781     0.200
     9.555   269.227     0.200
     0.175     7.852     0.200
     0.206     9.250     0.200
     0.236    10.000     0.200
     0.260    10.227     0.200
     0.360    13.781     0.200
     0.468    16.086     0.200
     0.489    16.523     0.200
     0.528    17.516     0.200
     0.538    18.602     0.200
     0.533    17.250     0.200
     0.544    17.773     0.200
     0.566    19.023     0.200
     0.583    19.227     0.200
     0.631    20.953     0.200
     0.681    21.930     0.200
     0.681    22.789     0.200
     0.690    22.305     0.200
     0.717    23.023     0.200
     0.811    26.422     0.200
     0.912    28.945     0.200
     1.984    59.539     0.200
     2.349    68.430     0.200
     3.048    86.633     0.200
     3.182    90.336     0.200
     7.733   222.633     0.200
     9.042   293.320     0.200
     9.540   273.133     0.200
     0.189     8.156     0.200
     0.227    10.086     0.200
     0.185     8.438     0.200
     0.249     9.406     0.200
     0.341    13.688     0.200
     0.324    12.789     0.200
     0.447    15.984     0.200
     0.535    19.188     0.200
     0.531    18.586     0.200
     0.524    17.789     0.200
     0.531    17.984     0.200
     0.565    19.586     0.200
     0.610    20.867     0.200
     0.721    23.305     0.200
     0.721    23.086     0.200
     0.680    22.047     0.200
     0.680    22.867     0.200
     0.827    27.750     0.200
     1.837    55.195     0.200
     1.974    59.734     0.200
     4.373   125.656     0.200
     8.005   235.586     0.200
     9.561   270.188     0.200
     0.171     7.500     0.200
     0.214     9.062     0.200
     0.200     8.742     0.200
     0.269    10.383     0.200
     0.341    12.656     0.200
     0.467    15.836     0.200
     0.453    16.117     0.200
     0.525    17.781     0.200
     0.562    18.711     0.200
     0.549    18.766     0.200
     0.619    21.023     0.200
     2.371    68.625     0.200
     2.954    84.023     0.200
     0.205     7.945     0.200
     0.178     8.547     0.200
     0.245    10.773     0.200
     0.231     9.367     0.200
     0.318    13.047     0.200
     0.349    13.484     0.200
     0.449    16.164     0.200
     0.495    16.867     0.200
     0.549    19.023     0.200
     0.574    19.312     0.200
     0.660    21.828     0.200
     0.740    24.336     0.200
     7.746   225.164     0.200
     9.567   273.266     0.200
     0.179     8.477     0.200
     0.249     9.898     0.200
     0.353    13.492     0.200
     0.320    13.203     0.200
     0.207     9.484     0.200
     0.229     9.547     0.200
     0.451    15.883     0.200
     0.500    16.992     0.200
     0.533    18.203     0.200
     0.509    17.539     0.200
     0.557    18.898     0.200
     0.508    16.289     0.200
     0.190     8.438     0.200
     0.236     9.469     0.200
     0.251    10.367     0.200
     0.331    14.039     0.200
     0.361    14.164     0.200
     0.462    16.164     0.200
     0.503    16.766     0.200
     0.510    16.664     0.200
     0.552    18.273     0.200
     0.555    18.867     0.200
     0.659    21.664     0.200
     0.740    23.766     0.200
     0.788    26.469     0.200
     0.859    28.062     0.200
     0.875    27.469     0.200
     0.933    29.367     0.200
     0.089     7.181     0.200
     0.128     7.701     0.200
     0.228     9.481     0.200
     0.270    10.681     0.200
     0.368    14.581     0.200
     0.383    13.681     0.200
     0.492    16.681     0.200
     0.524    18.181     0.200
     0.550    18.481     0.200
     0.533    17.781     0.200
     0.655    20.881     0.200
     0.680    22.381     0.200
     0.713    23.081     0.200
     0.810    26.181     0.200
     0.837    26.981     0.200
     0.910    29.181     0.200
     0.972    30.681     0.200
     0.966    30.481     0.200
     0.990    30.881     0.200
     1.121    34.981     0.200
     1.256    38.681     0.200
     0.089     5.664     0.200
     0.113     6.828     0.200
     0.126     6.938     0.200
     0.199     8.367     0.200
     0.183     8.070     0.200
     0.253    10.070     0.200
     0.339    12.867     0.200
     0.358    12.570     0.200
     0.464    16.766     0.200
     0.491    17.078     0.200
     0.541    18.367     0.200
     0.541    19.109     0.200
     0.534    18.664     0.200
     0.527    17.141     0.200
     0.581    19.367     0.200
     0.685    22.766     0.200
     0.723    23.070     0.200
     0.860    27.828     0.200
     0.871    29.070     0.200
     0.962    31.867     0.200
     0.988    31.766     0.200
     1.022    33.469     0.200
     1.232    38.664     0.200
     1.344    42.664     0.200
     1.437    45.266     0.200
     1.624    47.969     0.200
     0.087     5.289     0.200
     0.120     6.289     0.200
     0.117     6.188     0.200
     0.199     7.586     0.200
     0.184     8.391     0.200
     0.243     9.789     0.200
     0.237     9.391     0.200
     0.324    12.586     0.200
     0.453    16.188     0.200
     0.494    16.789     0.200
     0.515    17.352     0.200
     0.548    17.992     0.200
     0.516    17.789     0.200
     0.547    18.086     0.200
     0.675    21.969     0.200
     0.665    21.672     0.200
     0.675    22.359     0.200
     0.736    23.086     0.200
     0.714    24.242     0.200
     0.794    26.516     0.200
     0.796    26.391     0.200
     0.859    28.461     0.200
     0.868    27.391     0.200
     0.896    28.289     0.200
     0.855    28.086     0.200
     0.927    29.086     0.200
     0.943    30.352     0.200
     0.973    30.086     0.200
     0.946    30.891     0.200
     0.090     5.664     0.200
     0.114     6.676     0.200
     0.120     6.645     0.200
     0.190     7.824     0.200
     0.194     7.906     0.200
     0.242    10.047     0.200
     0.245     9.777     0.200
     0.357    14.426     0.200
     0.461    16.246     0.200
     0.494    17.105     0.200
     0.521    16.816     0.200
     0.541    18.555     0.200
     0.545    19.137     0.200
     0.068     4.938     0.200
     0.142     6.027     0.200
     0.134     6.557     0.200
     0.148     7.197     0.200
     0.187     8.037     0.200
     0.207     8.588     0.200
     0.249     9.357     0.200
     0.331    12.297     0.200
     0.337    12.168     0.200
     0.332    12.316     0.200
     0.333    12.977     0.200
     0.371    14.117     0.200
     0.364    12.617     0.200
     0.379    13.668     0.200
     0.353    13.457     0.200
     0.375    13.117     0.200
     0.464    16.207     0.200
     0.432    14.477     0.200
     0.443    14.918     0.200
     0.478    16.018     0.200
     0.491    16.967     0.200
     0.477    16.887     0.200
     0.516    18.018     0.200
     0.600    21.066     0.200
     0.080     4.514     0.200
     0.135     6.572     0.200
     0.133     6.502     0.200
     0.188     7.203     0.200
     0.198     8.062     0.200
     0.346    12.152     0.200
     0.351    12.572     0.200
     0.325    12.613     0.200
     0.325    12.812     0.200
     0.332    12.832     0.200
     0.345    13.393     0.200
     0.368    13.223     0.200
     0.352    12.633     0.200
     0.373    13.773     0.200
     0.365    13.264     0.200
     0.451    15.223     0.200
     0.419    14.264     0.200
     0.462    16.832     0.200
     0.529    17.463     0.200
     0.081     4.820     0.200
     0.141     6.850     0.200
     0.200     7.859     0.200
     0.122     6.811     0.200
     0.213     8.189     0.200
     0.251     9.590     0.200
     0.341    11.881     0.200
     0.366    12.850     0.200
     0.388    13.730     0.200
     0.380    13.221     0.200
     0.318    12.430     0.200
     0.318    12.400     0.200
     0.325    12.391     0.200
     0.339    12.980     0.200
     0.433    14.600     0.200
     0.436    14.910     0.200
     0.478    15.990     0.200
     0.081     5.848     0.200
     0.125     6.578     0.200
     0.148     6.480     0.200
     0.197     8.180     0.200
     0.209     9.098     0.200
     0.248     9.480     0.200
     0.302    11.680     0.200
     0.344    11.777     0.200
     0.319    13.578     0.200
     0.320    12.480     0.200
     0.327    13.277     0.200
     0.363    14.059     0.200
     0.363    13.398     0.200
     0.378    14.609     0.200
     0.376    13.938     0.200
     0.384    14.379     0.200
     0.440    15.480     0.200
     0.430    14.777     0.200
     0.474    17.988     0.200
     0.042     3.904     0.200
     0.082     4.854     0.200
     0.090     4.615     0.200
     0.095     4.955     0.200
     0.113     4.854     0.200
     0.135     6.004     0.200
     0.169     7.654     0.200
     0.210     9.084     0.200
     0.250    10.545     0.200
     0.261     9.654     0.200
     0.314    11.254     0.200
     0.312    12.574     0.200
     0.341    11.764     0.200
     0.387    14.055     0.200
     0.470    16.555     0.200
     3.448   102.604     0.200
     0.111     8.187     0.200
     0.156     8.687     0.200
     0.186     9.486     0.200
     0.203    10.086     0.200
     0.209     9.886     0.200
     0.242    10.086     0.200
     0.253    10.756     0.200
     0.253    11.187     0.200
     0.384    14.886     0.200
     0.441    15.286     0.200
     0.574    20.786     0.200
     0.677    22.286     0.200
     0.746    24.586     0.200
     0.749    25.886     0.200
     0.764    25.687     0.200
     1.010    31.956     0.200
     1.517    47.174     0.200
     2.557    75.086     0.200
     3.204    91.563     0.200
     0.030     3.667     0.200
     0.115     4.167     0.200
     0.183     7.967     0.200
     0.180     7.067     0.200
     0.195     7.667     0.200
     0.228     8.067     0.200
     0.332    12.767     0.200
     0.353    13.067     0.200
     0.514    17.867     0.200
     0.512    18.767     0.200
     0.070     7.047     0.200
     0.213     9.352     0.200
     0.225     9.047     0.200
     0.230     9.750     0.200
     0.234     9.547     0.200
     0.290    11.938     0.200
     0.314    12.250     0.200
     0.322    12.352     0.200
     0.324    11.352     0.200
     0.330    12.852     0.200
     0.337    12.953     0.200
     0.352    12.047     0.200
     0.370    13.047     0.200
     0.364    13.352     0.200
     0.416    15.453     0.200
     0.411    15.953     0.200
     0.435    14.547     0.200
     0.446    15.750     0.200
     0.462    15.750     0.200
     0.459    16.828     0.200
     0.485    16.453     0.200
     0.515    16.852     0.200
     0.531    18.352     0.200
     0.524    17.352     0.200
     0.534    17.352     0.200
     0.535    16.648     0.200
     0.570    19.148     0.200
     0.563    20.383     0.200
     0.580    18.547     0.200
     0.570    20.250     0.200
     0.600    20.453     0.200
     0.611    21.352     0.200
     0.658    21.547     0.200
     0.650    22.109     0.200
     0.653    21.453     0.200
     0.654    22.562     0.200
     0.679    22.953     0.200
     0.710    24.352     0.200
     0.706    23.672     0.200
     0.698    23.250     0.200
     0.771    25.547     0.200
     0.819    27.312     0.200
     0.821    25.852     0.200
     0.825    27.570     0.200
     0.829    27.852     0.200
     2.817    79.953     0.200
     9.815   285.250     0.200
     0.135     6.180     0.200
     0.170     7.688     0.200
     0.170     6.906     0.200
     0.209     8.703     0.200
     0.241     9.805     0.200
     0.344    12.609     0.200
     0.383    13.109     0.200
     0.406    13.406     0.200
     0.442    15.539     0.200
     0.474    16.609     0.200
     0.102     6.117     0.200
     0.234     8.414     0.200
     0.296    11.414     0.200
     0.315    11.312     0.200
     0.331    11.914     0.200
     0.340    11.812     0.200
     0.364    13.016     0.200
     0.404    14.914     0.200
     0.404    14.516     0.200
     0.409    14.812     0.200
     0.405    14.016     0.200
     0.424    14.914     0.200
     0.424    15.016     0.200
     0.462    16.016     0.200
     0.484    16.211     0.200
     0.500    16.312     0.200
     0.503    17.312     0.200
     0.509    17.211     0.200
     0.523    18.117     0.200
     0.588    20.016     0.200
     0.658    21.312     0.200
     0.691    22.117     0.200
     1.117    36.195     0.200
     2.330    68.211     0.200
     0.169     8.875     0.200
     0.233    10.688     0.200
     0.226    10.781     0.200
     0.237    10.188     0.200
     0.242    10.586     0.200
     0.270    11.086     0.200
     0.262     9.984     0.200
     0.310    12.586     0.200
     0.339    12.883     0.200
     0.353    12.188     0.200
     0.397    14.586     0.200
     0.406    14.781     0.200
     0.413    14.281     0.200
     0.461    16.984     0.200
     0.513    18.086     0.200
     0.518    17.383     0.200
     0.537    18.586     0.200
     0.533    18.781     0.200
     0.632    20.633     0.200
     0.646    20.688     0.200
     0.654    21.188     0.200
     0.678    22.086     0.200
     0.705    23.383     0.200
     0.705    23.281     0.200
     0.706    22.984     0.200
     0.803    26.164     0.200
     0.803    27.555     0.200
     1.288    40.117     0.200
     1.998    62.188     0.200
     2.667    75.984     0.200
     3.281    94.695     0.200
     4.180   117.531     0.200
     9.721   279.984     0.200
     0.076     5.170     0.200
     0.049     5.480     0.200
     0.094     6.180     0.200
     0.094     6.400     0.200
     0.177     8.380     0.200
     0.177     8.150     0.200
     0.231     9.580     0.200
     0.231     8.950     0.200
     0.233    10.080     0.200
     0.240     9.780     0.200
     0.317    13.380     0.200
     0.317    12.220     0.200
     0.317    12.380     0.200
     0.345    13.880     0.200
     0.363    12.580     0.200
     0.363    12.190     0.200
     0.412    14.880     0.200
     0.445    16.480     0.200
     0.474    16.930     0.200
     0.491    16.780     0.200
     0.515    17.080     0.200
     0.515    17.800     0.200
     0.509    19.280     0.200
     0.509    18.330     0.200
     0.551    18.580     0.200
     0.544    18.780     0.200
     0.568    20.080     0.200
     0.568    18.640     0.200
     0.570    19.480     0.200
     0.605    20.780     0.200
     0.626    22.180     0.200
     0.664    21.620     0.200
     0.664    22.080     0.200
     0.737    23.940     0.200
     0.737    23.780     0.200
     0.746    24.680     0.200
     0.750    24.380     0.200
     0.793    26.570     0.200
     1.822    53.848     0.200
     1.899    59.730     0.200
     1.958    59.330     0.200
     2.559    77.220     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     7.220   232.941     0.200
     8.761   277.941     0.200
     3.177   100.773     0.200
     3.096   105.508     0.200
     3.191   108.258     0.200
     3.125   100.156     0.200
    10.090   322.258     0.200
    10.160   325.258     0.200
     6.569   208.039     0.200
     3.150   101.416     0.200
     3.655   113.716     0.200
     3.543   118.039     0.200
     4.919   157.539     0.200
     3.240   102.148     0.200
     3.260   102.250     0.200
     3.186    99.926     0.200
     4.346   138.242     0.200
     4.379   136.957     0.200
    10.136   327.457     0.200
     5.455   174.719     0.200
     5.764   188.719     0.200
     3.126    96.047     0.200
     4.361   138.547     0.200
     2.932   100.535     0.200
     3.907   118.336     0.200
     4.320   134.637     0.200
     4.620   151.336     0.200
     6.400   200.836     0.200
     3.925   126.469     0.200
     6.017   192.652     0.200
     9.856   315.281     0.200
     4.624   150.938     0.200
     4.117   127.102     0.200
     4.272   134.207     0.200
     6.585   212.008     0.200
     3.249   102.256     0.200
     3.765   123.586     0.200
     4.125   128.586     0.200
     4.655   159.086     0.200
     6.184   201.883     0.200
     7.482   243.086     0.200
     8.640   278.086     0.200
     5.260   172.641     0.200
     5.485   174.089     0.200
     3.602   119.672     0.200
     2.508    81.586     0.200
     4.285   133.137     0.200
     5.559   182.035     0.200
     7.693   244.020     0.200
     9.187   286.035     0.200
     4.808   155.516     0.200
     5.489   177.715     0.200
     4.819   153.879     0.200
     5.576   176.680     0.200
     3.733   123.758     0.200
     4.795   155.258     0.200
     5.476   178.258     0.200
     4.809   154.797     0.200
     6.680   217.000     0.200
     4.802   152.922     0.200
     5.481   177.625     0.200
     4.299   136.801     0.200
     5.799   187.301     0.200
     9.209   284.602     0.200
     9.226   295.746     0.200
     4.325   138.039     0.200
     6.873   213.539     0.200
     4.334   137.740     0.200
     7.703   244.419     0.200
     3.930   128.760     0.200
     9.241   294.422     0.200
     3.953   129.438     0.200
     7.729   245.488     0.200
     8.928   286.898     0.200
     9.221   287.418     0.200
     4.294   130.008     0.200
     7.720   245.012     0.200
     4.407   146.316     0.200
     2.531    77.625     0.200
     8.718   270.156     0.200
     9.612   310.789     0.200
     4.838   160.000     0.200
     2.887    93.847     0.200
     7.400   232.627     0.200
     5.689   184.934     0.200
     6.031   197.945     0.200
     6.182   195.957     0.200
     8.011   250.945     0.200
     8.848   274.984     0.200
     2.666    85.188     0.200
     9.992   319.873     0.200
     9.702   307.625     0.200
     9.708   302.000     0.200
     9.745   302.701     0.200
     4.369   139.363     0.200
     7.052   220.340     0.200
     8.834   283.438     0.200
     9.555   305.227     0.200
     6.448   201.930     0.200
     8.796   236.531     0.200
     9.540   303.133     0.200
     3.262   100.727     0.200
     3.770   118.219     0.200
     3.800   125.258     0.200
     3.926   124.219     0.200
     4.398   136.984     0.200
     4.846   159.219     0.200
     5.809   178.484     0.200
     5.957   195.688     0.200
     6.330   195.188     0.200
     6.560   200.789     0.200
     6.935   212.289     0.200
     7.132   220.086     0.200
     7.219   221.688     0.200
     7.752   207.984     0.200
     8.002   246.688     0.200
     8.244   252.789     0.200
     8.474   259.391     0.200
     8.464   322.188     0.200
     8.621   264.391     0.200
     8.814   238.086     0.200
     9.242   283.586     0.200
     9.300   285.484     0.200
     9.434   291.891     0.200
     9.561   302.188     0.200
     9.599   294.984     0.200
     9.607   295.188     0.200
     9.641   296.188     0.200
    10.788   334.789     0.200
    10.807   333.289     0.200
    11.446   354.789     0.200
     6.560   213.164     0.200
     9.567   306.266     0.200
     9.639   307.786     0.200
     9.815   312.250     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.580    18.941     0.200
     2.947    85.441     0.200
     3.862   111.941     0.200
     0.542    18.869     0.200
     2.943    86.369     0.200
     4.941   147.869     0.200
     8.882   259.869     0.200
     0.450    15.473     0.200
     0.691    22.473     0.200
     2.042    61.973     0.200
     2.499    73.473     0.200
     4.196   120.008     0.200
    10.562   311.008     0.200
     3.631   106.859     0.200
     2.135    65.539     0.200
     8.845   252.039     0.200
    10.281   334.039     0.200
     3.322    94.017     0.200
     4.111   117.416     0.200
     4.398   122.616     0.200
     4.895   143.616     0.200
     6.525   181.616     0.200
     9.756   285.616     0.200
    10.601   305.616     0.200
     0.899    30.738     0.200
     2.992    87.238     0.200
     4.125   120.246     0.200
     4.193   116.750     0.200
     0.615    22.250     0.200
     3.405    96.750     0.200
     7.352   208.227     0.200
     2.026    66.531     0.200
     2.212    65.633     0.200
    10.318   293.133     0.200
     0.664    23.764     0.200
     2.265    69.764     0.200
     3.617   104.564     0.200
     6.936   198.764     0.200
     7.314   206.764     0.200
     2.170    69.872     0.200
     2.070    63.242     0.200
     2.787    81.141     0.200
     3.326    94.844     0.200
     3.222    95.184     0.200
     3.399    97.184     0.200
     9.798   278.684     0.200
     0.701    24.957     0.200
     2.192    67.457     0.200
     5.888   175.957     0.200
     9.222   263.457     0.200
     2.022    60.719     0.200
     3.012    90.219     0.200
     3.745   111.719     0.200
     5.970   175.719     0.200
     7.335   218.219     0.200
     7.997   234.719     0.200
     0.090     4.547     0.200
     1.225    39.547     0.200
     1.294    41.047     0.200
     2.134    70.047     0.200
     2.236    68.047     0.200
     3.197    95.047     0.200
     5.494   154.750     0.200
     0.093     5.535     0.200
     1.289    39.535     0.200
     2.168    69.535     0.200
     2.343    72.535     0.200
     2.311    70.535     0.200
     2.465    73.535     0.200
     2.759    79.535     0.200
     4.168   120.434     0.200
     1.453    46.057     0.200
     1.260    40.783     0.200
     3.522    99.084     0.200
     0.377    13.969     0.200
     0.760    25.469     0.200
     1.226    38.047     0.200
     2.232    74.539     0.200
     2.254    77.578     0.200
     3.753   107.047     0.200
     3.753   112.648     0.200
     4.480   130.344     0.200
     9.182   261.047     0.200
     0.670    23.570     0.200
     1.862    56.254     0.200
     0.205     8.078     0.200
     1.254    40.281     0.200
     1.710    51.281     0.200
     1.918    57.484     0.200
     2.015    65.484     0.200
     0.600    20.430     0.200
     1.531    46.828     0.200
     1.453    47.430     0.200
     2.508    72.828     0.200
     2.675    76.531     0.200
     2.722    77.828     0.200
     2.959    83.531     0.200
     3.008    84.633     0.200
     0.733    25.469     0.200
     1.189    39.770     0.200
     0.707    23.438     0.200
     1.886    58.938     0.200
     1.363    40.305     0.200
     1.913    56.703     0.200
     1.366    40.754     0.200
     9.321   272.254     0.200
     0.349    13.500     0.200
     0.834    27.500     0.200
     9.832   278.398     0.200
     0.332    13.625     0.200
     0.628    22.125     0.200
     3.833   109.926     0.200
     0.661    23.057     0.200
     1.437    44.057     0.200
     1.459    44.057     0.200
     2.664    76.256     0.200
     2.825    79.957     0.200
     2.921    82.357     0.200
     3.029    85.057     0.200
     3.160    88.457     0.200
     0.572    20.383     0.200
     1.052    34.086     0.200
     1.179    37.586     0.200
     1.619    48.086     0.200
     1.727    50.984     0.200
     1.995    58.883     0.200
     4.655   136.586     0.200
     6.021   174.086     0.200
     9.693   278.289     0.200
     0.310    12.641     0.200
     6.671   190.844     0.200
     6.834   202.141     0.200
     0.683    23.656     0.200
     0.335    13.289     0.200
     0.722    25.589     0.200
     1.738    52.578     0.200
     3.100    91.781     0.200
     7.567   212.078     0.200
     8.565   242.756     0.200
     0.162     5.168     0.200
     0.627    20.867     0.200
     0.685    22.668     0.200
     0.704    24.066     0.200
     0.786    26.969     0.200
     0.787    26.367     0.200
     0.895    29.668     0.200
     2.414    70.969     0.200
     2.863    83.188     0.200
     3.317    96.516     0.200
     0.570    19.480     0.200
     0.629    20.582     0.200
     0.739    23.582     0.200
     1.575    49.383     0.200
     0.190     6.143     0.200
     0.647    22.843     0.200
     0.731    24.043     0.200
     0.922    31.743     0.200
     2.390    70.743     0.200
     2.551    76.493     0.200
     2.837    82.303     0.200
     3.290    94.173     0.200
     0.176     7.574     0.200
     0.522    17.473     0.200
     0.669    22.973     0.200
     0.834    26.473     0.200
     0.935    30.375     0.200
     2.394    68.922     0.200
     2.578    74.172     0.200
     4.118   123.773     0.200
     4.515   124.773     0.200
     0.187     8.992     0.200
     0.255    11.891     0.200
     0.764    24.289     0.200
     0.780    25.695     0.200
     1.082    34.289     0.200
     2.441    75.055     0.200
     2.673    77.469     0.200
     3.333    96.148     0.200
     3.382    98.820     0.200
     0.517    17.651     0.200
     0.499    17.802     0.200
     0.558    19.852     0.200
     0.732    25.352     0.200
     0.791    25.352     0.200
     0.840    29.231     0.200
     1.040    34.211     0.200
     0.448    15.746     0.200
     0.510    17.188     0.200
     1.189    38.797     0.200
     2.780    80.586     0.200
     2.955    85.527     0.200
     4.897   147.238     0.200
     5.776   173.035     0.200
     6.673   197.637     0.200
     6.875   203.535     0.200
     9.689   281.637     0.200
     0.482    16.484     0.200
     0.485    17.105     0.200
     0.722    25.395     0.200
     0.759    25.816     0.200
     0.418    14.590     0.200
     0.528    18.039     0.200
     0.514    18.188     0.200
     0.546    19.020     0.200
     1.269    40.129     0.200
     9.701   277.078     0.200
     0.585    19.477     0.200
     0.735    26.078     0.200
     0.862    28.398     0.200
     9.681   283.957     0.200
     0.518    18.418     0.200
     0.752    25.117     0.200
     0.810    27.547     0.200
     0.533    18.914     0.200
     0.806    27.898     0.200
     3.775   108.797     0.200
     0.502    17.727     0.200
     0.573    19.562     0.200
     0.813    28.344     0.200
     1.049    34.469     0.200
     0.458    14.871     0.200
     0.488    17.691     0.200
     0.505    18.340     0.200
     0.570    18.879     0.200
     0.721    25.809     0.200
     0.800    27.039     0.200
     0.779    27.910     0.200
     0.835    28.750     0.200
     1.031    34.680     0.200
     1.169    37.840     0.200
     0.469    15.918     0.200
     0.492    16.738     0.200
     0.583    19.449     0.200
     1.017    33.051     0.200
     0.421    15.062     0.200
     4.007   111.410     0.200
     4.502   133.000     0.200
     5.799   168.699     0.200
     6.899   194.000     0.200
     9.706   274.801     0.200
     0.391    13.285     0.200
     0.501    17.566     0.200
     0.573    18.867     0.200
     0.528    19.027     0.200
     0.766    25.758     0.200
     0.568    18.680     0.200
     0.525    18.281     0.200
     0.842    26.828     0.200
     0.502    16.438     0.200
     0.573    18.250     0.200
     0.847    28.648     0.200
     0.561    19.633     0.200
     0.771    27.363     0.200
     0.782    27.883     0.200
     1.463    46.035     0.200
     1.676    51.094     0.200
     0.509    17.047     0.200
     0.538    19.227     0.200
     0.566    21.145     0.200
     0.756    26.754     0.200
     0.774    27.535     0.200
     0.840    29.574     0.200
     0.516    18.051     0.200
     0.560    18.340     0.200
     0.777    26.328     0.200
     0.869    29.590     0.200
     1.079    34.539     0.200
     2.814    81.867     0.200
     2.986    86.469     0.200
     4.006   115.488     0.200
     4.521   132.438     0.200
     4.935   144.539     0.200
     9.172   260.938     0.200
     9.674   277.340     0.200
     0.534    19.824     0.200
     0.550    18.945     0.200
     0.528    18.367     0.200
     0.766    27.156     0.200
     0.878    28.574     0.200
     0.800    28.785     0.200
     0.513    17.289     0.200
     0.522    18.227     0.200
     0.561    19.188     0.200
     1.185    38.047     0.200
     1.645    48.711     0.200
     0.567    19.188     0.200
     0.549    19.570     0.200
     0.785    27.648     0.200
     0.839    28.117     0.200
     0.490    15.875     0.200
     0.584    20.805     0.200
     0.859    28.484     0.200
     3.019    85.016     0.200
     3.940   109.570     0.200
     9.694   275.383     0.200
     0.507    16.894     0.200
     0.529    18.233     0.200
     0.820    27.533     0.200
     1.174    37.883     0.200
     1.634    48.383     0.200
     3.788   106.033     0.200
     0.530    19.999     0.200
     0.541    20.648     0.200
     0.782    26.078     0.200
     0.764    27.509     0.200
     0.865    29.519     0.200
     0.392    13.131     0.200
     0.499    17.531     0.200
     0.575    20.852     0.200
     0.743    25.211     0.200
     0.852    29.160     0.200
     0.849    28.842     0.200
     9.218   261.541     0.200
     0.405    13.914     0.200
     0.516    17.465     0.200
     0.558    18.734     0.200
     0.752    26.027     0.200
     0.833    28.215     0.200
     0.394    13.500     0.200
     0.498    17.531     0.200
     0.850    29.180     0.200
     0.556    18.367     0.200
     0.518    19.438     0.200
     0.495    17.469     0.200
     0.787    27.195     0.200
     0.728    24.547     0.200
     0.793    27.102     0.200
     1.035    35.547     0.200
     0.492    17.578     0.200
     0.566    20.133     0.200
     0.724    24.859     0.200
     0.782    26.719     0.200
     0.837    28.578     0.200
     0.541    18.889     0.200
     0.574    19.990     0.200
     0.777    26.459     0.200
     1.075    35.510     0.200
     4.951   150.340     0.200
     9.685   274.740     0.200
     0.560    20.979     0.200
     0.756    26.300     0.200
     0.834    28.760     0.200
     3.802   108.260     0.200
     4.520   132.060     0.200
     0.425    14.820     0.200
     0.531    18.742     0.200
     0.544    18.602     0.200
     0.757    25.703     0.200
     0.817    28.402     0.200
     0.854    28.312     0.200
     1.061    34.980     0.200
     0.509    16.680     0.200
     0.461    17.602     0.200
     6.651   187.133     0.200
     9.688   273.133     0.200
     0.272     9.188     0.200
     0.401    13.746     0.200
     0.456    16.039     0.200
     0.514    17.477     0.200
     0.560    18.348     0.200
     0.561    17.969     0.200
     0.744    25.488     0.200
     0.829    27.777     0.200
     0.836    27.809     0.200
     1.127    35.117     0.200
     1.954    57.277     0.200
     0.425    13.586     0.200
     0.480    15.625     0.200
     0.533    18.086     0.200
     0.518    19.695     0.200
     0.548    17.016     0.200
     0.542    18.848     0.200
     0.581    18.617     0.200
     0.773    26.969     0.200
     0.816    28.297     0.200
     6.622   191.996     0.200
     7.484   209.797     0.200
     0.253     9.617     0.200
     0.461    15.195     0.200
     0.502    16.695     0.200
     0.530    17.266     0.200
     0.534    18.094     0.200
     0.562    18.102     0.200
     0.816    26.523     0.200
     1.039    33.922     0.200
     0.196     7.523     0.200
     0.471    15.906     0.200
     0.472    16.578     0.200
     0.556    20.195     0.200
     0.602    20.258     0.200
     4.536   131.316     0.200
     9.710   275.617     0.200
     0.372    12.309     0.200
     0.465    15.840     0.200
     0.482    17.020     0.200
     0.521    17.527     0.200
     0.592    20.777     0.200
     0.845    29.609     0.200
     0.867    28.719     0.200
     0.487    16.729     0.200
     0.536    18.158     0.200
     0.523    17.738     0.200
     0.587    19.358     0.200
     0.862    28.089     0.200
     0.431    14.627     0.200
     0.485    16.507     0.200
     0.537    18.387     0.200
     0.554    18.457     0.200
     0.538    19.297     0.200
     0.811    28.247     0.200
     1.058    36.507     0.200
     0.317    11.359     0.200
     0.472    15.672     0.200
     0.457    16.289     0.200
     0.521    18.180     0.200
     0.617    21.453     0.200
     0.799    27.797     0.200
     0.891    30.070     0.200
     0.316    12.371     0.200
     0.466    16.402     0.200
     0.455    15.211     0.200
     0.506    16.090     0.200
     4.315   123.453     0.200
     0.261    10.820     0.200
     0.467    16.750     0.200
     0.533    18.859     0.200
     0.839    28.258     0.200
     6.699   196.992     0.200
     6.901   193.992     0.200
     9.207   258.594     0.200
     0.285    10.005     0.200
     0.585    19.255     0.200
     0.859    28.655     0.200
     1.202    38.475     0.200
     0.286     9.737     0.200
     0.491    16.478     0.200
     0.537    18.498     0.200
     0.583    19.777     0.200
     0.858    28.688     0.200
     0.478    16.822     0.200
     0.544    19.354     0.200
     0.597    20.992     0.200
     0.782    26.693     0.200
     0.297    10.648     0.200
     0.371    12.809     0.200
     0.604    21.879     0.200
     0.878    30.078     0.200
     1.099    37.020     0.200
     0.054     4.117     0.200
     0.246     9.320     0.200
     0.424    14.320     0.200
     0.515    18.320     0.200
     0.533    18.523     0.200
     0.542    18.719     0.200
     0.759    26.045     0.200
     0.070     4.727     0.200
     6.704   219.629     0.200
     6.906   203.828     0.200
     9.703   276.328     0.200
     0.366    11.850     0.200
     0.600    21.850     0.200
     2.209    64.830     0.200
     2.403    69.670     0.200
     2.465    70.850     0.200
     2.674    76.051     0.200
     2.688    76.871     0.200
     0.234     9.734     0.200
     0.548    19.535     0.200
     0.505    17.434     0.200
     0.739    25.035     0.200
     2.397    69.885     0.200
     0.253    11.070     0.200
     0.400    15.070     0.200
     0.564    19.773     0.200
     0.743    24.570     0.200
     0.903    28.570     0.200
     1.185    35.672     0.200
     0.030     3.219     0.200
     0.444    16.219     0.200
     0.444    16.719     0.200
     0.488    16.316     0.200
     0.464    16.219     0.200
     0.518    17.719     0.200
     0.560    20.816     0.200
     0.793    27.617     0.200
     2.786    81.469     0.200
     2.964    85.988     0.200
     3.043    88.129     0.200
     3.245    93.617     0.200
     3.333    95.199     0.200
     0.155     8.074     0.200
     0.762    24.176     0.200
     0.819    26.475     0.200
     1.224    37.775     0.200
     1.655    49.596     0.200
     1.655    49.885     0.200
     1.988    57.875     0.200
     0.074     4.650     0.200
     0.418    16.250     0.200
     0.543    18.951     0.200
     1.073    35.750     0.200
     1.627    49.551     0.200
     2.136    66.451     0.200
     2.398    70.680     0.200
     0.440    16.023     0.200
     0.563    18.828     0.200
     0.393    13.664     0.200
     0.435    15.367     0.200
     0.536    19.664     0.200
     0.583    20.367     0.200
     0.583    19.461     0.200
     0.678    22.164     0.200
     0.729    23.867     0.200
     0.748    25.562     0.200
     0.815    27.266     0.200
     0.973    32.164     0.200
     1.084    35.461     0.200
     3.286    95.422     0.200
     3.400    97.242     0.200
     0.238    10.164     0.200
     0.363    14.164     0.200
     0.515    16.859     0.200
     0.599    21.359     0.200
     0.625    20.359     0.200
     0.726    23.859     0.200
     0.772    25.961     0.200
     0.787    26.359     0.200
     0.782    26.062     0.200
     2.260    65.758     0.200
     2.287    67.711     0.200
     2.457    71.172     0.200
     2.553    73.414     0.200
     2.739    78.188     0.200
     2.792    79.617     0.200
     2.826    79.648     0.200
     2.837    79.828     0.200
     9.029   258.914     0.200
     0.127     5.633     0.200
     0.177     6.328     0.200
     0.325    12.227     0.200
     0.351    12.430     0.200
     0.407    14.031     0.200
     0.075     5.961     0.200
     0.222     9.562     0.200
     0.304    12.562     0.200
     0.305    11.656     0.200
     0.392    13.656     0.200
     0.425    14.859     0.200
     0.410    15.156     0.200
     0.448    14.062     0.200
     0.499    17.656     0.200
     0.467    16.258     0.200
     0.696    22.758     0.200
     0.691    23.758     0.200
     0.842    28.359     0.200
     1.640    50.656     0.200
     2.442    70.711     0.200
     0.143     9.590     0.200
     0.199    10.988     0.200
     2.081    60.590     0.200
     2.269    65.688     0.200
     2.342    66.789     0.200
     2.543    72.391     0.200
     2.628    74.090     0.200
     2.628    74.090     0.200
     2.645    74.891     0.200
     0.261    12.176     0.200
     0.296    13.375     0.200
     0.374    13.977     0.200
     0.422    16.375     0.200
     0.532    19.676     0.200
     0.554    20.277     0.200
     0.562    19.676     0.200
     0.556    20.277     0.200
     0.623    21.676     0.200
     0.623    21.375     0.200
     0.626    21.277     0.200
     0.654    22.477     0.200
     0.803    26.375     0.200
     2.059    62.078     0.200
     2.863    81.875     0.200
     0.265    11.977     0.200
     0.299    13.172     0.200
     0.313    13.672     0.200
     0.374    15.875     0.200
     0.417    16.570     0.200
     0.534    19.570     0.200
     0.557    19.977     0.200
     0.558    20.570     0.200
     0.550    19.570     0.200
     0.616    21.477     0.200
     0.672    23.273     0.200
     0.658    22.672     0.200
     0.620    20.875     0.200
     0.697    23.672     0.200
     0.799    26.273     0.200
     0.833    27.172     0.200
     1.278    39.172     0.200
     0.045     5.836     0.200
     0.167     9.031     0.200
     0.232    10.133     0.200
     0.244    10.633     0.200
     0.298    11.633     0.200
     0.328    11.836     0.200
     0.394    13.531     0.200
     0.382    14.430     0.200
     0.449    15.133     0.200
     0.663    22.633     0.200
     0.708    24.031     0.200
     0.817    27.336     0.200
     0.921    30.336     0.200
     1.183    37.531     0.200
     2.820    80.031     0.200
     0.255    10.438     0.200
     0.298    12.338     0.200
     0.420    14.538     0.200
     0.539    18.738     0.200
     0.429    16.738     0.200
     0.454    16.938     0.200
     0.630    20.738     0.200
     0.697    23.438     0.200
     0.742    25.438     0.200
     0.781    25.938     0.200
     0.819    27.038     0.200
     0.810    26.738     0.200
     0.875    27.838     0.200
     0.856    28.638     0.200
     0.934    30.138     0.200
     1.344    40.438     0.200
     2.384    69.338     0.200
     2.649    76.438     0.200
     2.712    77.438     0.200
     2.795    79.938     0.200
     2.837    80.538     0.200
     2.851    81.138     0.200
     2.885    82.338     0.200
     2.934    82.538     0.200
     2.934    82.538     0.200
     0.218     9.488     0.200
     0.342    13.288     0.200
     0.366    14.388     0.200
     0.362    12.888     0.200
     0.532    16.788     0.200
     0.604    20.588     0.200
     0.747    24.188     0.200
     0.747    25.168     0.200
     0.789    26.518     0.200
     0.780    25.188     0.200
     0.780    26.138     0.200
     0.800    26.688     0.200
     0.870    28.488     0.200
     0.980    32.088     0.200
     2.267    66.188     0.200
     2.440    70.688     0.200
     2.533    73.088     0.200
     2.595    74.188     0.200
     2.627    75.188     0.200
     2.679    76.588     0.200
     2.721    77.188     0.200
     2.735    77.588     0.200
     2.771    78.588     0.200
     0.053     5.427     0.200
     0.256    10.727     0.200
     0.336    12.927     0.200
     0.314    12.127     0.200
     0.306    12.527     0.200
     0.426    15.127     0.200
     0.476    17.127     0.200
     0.540    18.827     0.200
     1.422    44.427     0.200
     2.927    85.827     0.200
     3.147    90.927     0.200
     3.170    91.027     0.200
     3.254    93.727     0.200
     3.306    94.427     0.200
     3.317    94.927     0.200
     3.371    96.027     0.200
     3.418    96.827     0.200
     3.443    97.927     0.200
     0.048     4.460     0.200
     0.116     4.510     0.200
     0.291    10.910     0.200
     0.261    10.811     0.200
     0.254    10.910     0.200
     0.370    13.210     0.200
     0.315    11.811     0.200
     0.343    13.710     0.200
     0.317    13.040     0.200
     0.423    14.410     0.200
     0.484    16.610     0.200
     0.551    19.110     0.200
     1.351    43.010     0.200
     2.662    79.210     0.200
     2.941    85.110     0.200
     2.970    86.811     0.200
     3.161    90.811     0.200
     3.268    93.710     0.200
     3.319    94.410     0.200
     3.331    95.010     0.200
     3.457    98.410     0.200
     0.039     4.201     0.200
     0.120     5.602     0.200
     0.312    11.900     0.200
     0.299    10.900     0.200
     0.256    10.701     0.200
     0.307    11.900     0.200
     0.375    12.301     0.200
     0.318    12.701     0.200
     0.412    14.002     0.200
     0.496    17.102     0.200
     0.564    19.400     0.200
     1.351    42.801     0.200
     2.417    71.201     0.200
     2.949    85.602     0.200
     3.168    91.201     0.200
     3.194    90.900     0.200
     3.276    93.602     0.200
     3.325    94.502     0.200
     3.338    95.201     0.200
     3.464    98.502     0.200
     0.063     6.566     0.200
     0.173     8.676     0.200
     0.216     9.879     0.200
     0.228     9.477     0.200
     0.291    10.879     0.200
     0.321    12.176     0.200
     0.429    14.578     0.200
     0.394    15.078     0.200
     0.451    15.879     0.200
     0.504    17.777     0.200
     0.513    17.477     0.200
     0.766    24.977     0.200
     2.069    60.188     0.200
     2.446    70.578     0.200
     2.493    72.637     0.200
     2.603    75.309     0.200
     2.897    82.477     0.200
     0.180     8.406     0.200
     0.289    10.355     0.200
     0.421    15.156     0.200
     0.507    16.676     0.200
     0.587    20.137     0.200
     0.990    30.707     0.200
     1.130    35.777     0.200
     1.851    56.797     0.200
     2.421    69.496     0.200
     9.968   285.926     0.200
    10.060   292.617     0.200
     0.176     7.617     0.200
     0.186     8.398     0.200
     0.181     8.312     0.200
     0.285    10.211     0.200
     0.300    10.969     0.200
     0.307    11.672     0.200
     0.385    13.188     0.200
     0.463    16.312     0.200
     0.521    17.656     0.200
     2.852    85.102     0.200
     2.887    82.578     0.200
     0.151     6.922     0.200
     0.196     8.492     0.200
     0.206     8.547     0.200
     0.284    10.406     0.200
     0.375    13.602     0.200
     0.385    14.094     0.200
     0.608    19.633     0.200
     1.872    57.797     0.200
     2.900    82.219     0.200
     0.144     6.727     0.200
     0.201     7.477     0.200
     0.213     8.711     0.200
     0.265    10.312     0.200
     0.337    12.961     0.200
     0.371    13.109     0.200
     0.387    14.219     0.200
     0.376    13.398     0.200
     0.679    23.312     0.200
     1.055    34.312     0.200
     1.993    59.312     0.200
     2.334    67.023     0.200
     0.046     4.752     0.200
     0.099     5.332     0.200
     0.192     7.961     0.200
     0.192     8.371     0.200
     0.174     8.012     0.200
     0.174     8.152     0.200
     0.204     8.822     0.200
     0.204     9.121     0.200
     0.285    11.252     0.200
     0.336    12.172     0.200
     0.336    11.162     0.200
     0.440    15.801     0.200
     0.780    24.742     0.200
     1.028    32.762     0.200
     1.742    53.941     0.200
     0.043     5.152     0.200
     0.186     8.232     0.200
     0.177     7.992     0.200
     0.198     9.434     0.200
     0.318    11.723     0.200
     0.293    11.412     0.200
     1.835    58.211     0.200
     0.139     7.559     0.200
     0.143     7.178     0.200
     0.230    10.238     0.200
     0.257    10.908     0.200
     0.334    12.738     0.200
     0.345    12.777     0.200
     0.371    13.447     0.200
     0.401    14.188     0.200
     0.445    15.639     0.200
     0.461    16.357     0.200
     0.480    16.348     0.200
     0.481    17.008     0.200
     0.528    18.129     0.200
     0.610    21.338     0.200
     0.729    24.098     0.200
     0.070     5.273     0.200
     0.117     6.844     0.200
     0.324    11.684     0.200
     0.351    12.594     0.200
     0.365    12.797     0.200
     0.475    16.344     0.200
     0.495    16.934     0.200
     0.541    17.805     0.200
     0.613    20.363     0.200
     0.681    23.316     0.200
     0.704    23.453     0.200
     2.162    70.625     0.200
     2.337    69.523     0.200
     9.702   279.625     0.200
     0.182     8.191     0.200
     0.290    11.543     0.200
     0.356    13.441     0.200
     0.375    13.781     0.200
     0.423    15.715     0.200
     0.418    15.555     0.200
     0.603    20.504     0.200
     0.612    21.375     0.200
     0.631    22.473     0.200
     0.680    23.055     0.200
     0.701    24.625     0.200
     0.700    24.273     0.200
     0.743    25.793     0.200
     0.848    28.473     0.200
     0.903    29.191     0.200
     0.912    28.922     0.200
     2.432    70.805     0.200
     2.618    75.305     0.200
     2.689    77.102     0.200
     2.760    78.703     0.200
     2.851    80.805     0.200
     2.885    81.805     0.200
     2.894    81.902     0.200
     2.911    82.402     0.200
     2.977    84.004     0.200
     2.992    84.305     0.200
     0.290    11.699     0.200
     0.359    14.191     0.200
     0.431    15.570     0.200
     0.440    15.641     0.200
     0.419    15.969     0.200
     0.605    20.250     0.200
     0.620    20.309     0.200
     0.623    20.871     0.200
     0.648    21.480     0.200
     0.695    22.941     0.200
     0.714    23.930     0.200
     0.761    24.961     0.200
     0.865    28.410     0.200
     0.906    29.621     0.200
     0.920    29.629     0.200
     0.953    31.020     0.200
     0.958    31.371     0.200
     1.010    32.211     0.200
     1.109    35.211     0.200
     1.301    40.488     0.200
     1.633    50.520     0.200
     1.625    51.258     0.200
     2.069    63.668     0.200
     2.061    61.398     0.200
     2.133    62.828     0.200
     0.061     6.742     0.200
     0.186     8.383     0.200
     0.241     9.512     0.200
     0.223     9.832     0.200
     0.301    11.734     0.200
     0.314    10.824     0.200
     0.381    13.754     0.200
     0.423    14.891     0.200
     0.420    14.961     0.200
     0.476    16.203     0.200
     0.514    16.734     0.200
     0.524    17.883     0.200
     0.569    19.262     0.200
     0.604    19.953     0.200
     0.658    21.344     0.200
     0.726    23.641     0.200
     0.719    24.793     0.200
     0.728    24.723     0.200
     0.039     3.617     0.200
     0.194     7.719     0.200
     0.239    10.422     0.200
     0.250     9.422     0.200
     0.311    11.219     0.200
     0.332    10.922     0.200
     0.338    11.617     0.200
     0.355    12.523     0.200
     0.404    14.023     0.200
     0.399    15.422     0.200
     0.421    15.922     0.200
     0.480    17.617     0.200
     0.510    16.547     0.200
     0.614    20.922     0.200
     0.724    25.008     0.200
     0.852    29.039     0.200
     1.262    40.117     0.200
     1.975    61.273     0.200
     0.029     3.594     0.200
     0.170     6.828     0.200
     0.222     8.938     0.200
     0.249     9.914     0.200
     0.295    10.828     0.200
     0.304    11.328     0.200
     0.338    12.422     0.200
     0.333    12.023     0.200
     0.390    13.797     0.200
     0.427    14.828     0.200
     0.453    15.023     0.200
     0.616    20.125     0.200
     0.733    24.227     0.200
     0.878    28.867     0.200
     0.990    31.625     0.200
     2.103    61.734     0.200
     2.142    62.219     0.200
     0.031     3.750     0.200
     0.244     9.450     0.200
     0.236    10.350     0.200
     0.303    11.550     0.200
     0.324    12.150     0.200
     0.355    12.650     0.200
     0.342    12.750     0.200
     0.406    15.150     0.200
     0.609    20.850     0.200
     2.081    61.350     0.200
     0.044     3.914     0.200
     0.192     6.727     0.200
     0.251     8.477     0.200
     0.245    10.602     0.200
     0.316    11.555     0.200
     0.334    12.008     0.200
     0.397    15.344     0.200
     0.410    14.086     0.200
     0.621    20.703     0.200
     0.032     3.953     0.200
     0.196     7.555     0.200
     0.233    10.055     0.200
     0.248     9.359     0.200
     0.303    10.758     0.200
     0.327    11.859     0.200
     0.345    12.555     0.200
     0.359    12.953     0.200
     0.396    13.453     0.200
     0.403    15.055     0.200
     0.607    20.555     0.200
     0.857    28.453     0.200
     2.077    61.078     0.200
     0.043     4.400     0.200
     0.169     7.541     0.200
     0.205     9.102     0.200
     0.246     9.590     0.200
     0.237     9.811     0.200
     0.314    11.420     0.200
     0.381    14.111     0.200
     0.453    15.900     0.200
     0.454    16.400     0.200
     0.528    17.811     0.200
     0.535    18.301     0.200
     0.522    17.900     0.200
     0.520    17.500     0.200
     0.520    18.201     0.200
     0.557    19.500     0.200
     0.624    20.301     0.200
     0.633    21.000     0.200
     0.668    21.900     0.200
     0.669    22.500     0.200
     0.663    22.371     0.200
     0.681    22.941     0.200
     0.709    24.490     0.200
     0.786    25.080     0.200
     0.889    28.900     0.200
     0.944    30.000     0.200
     1.181    37.500     0.200
     1.732    51.854     0.200
     2.887    82.945     0.200
     3.414   102.291     0.200
     0.033     4.227     0.200
     0.151     7.125     0.200
     0.193     7.625     0.200
     0.236    10.625     0.200
     0.246     9.727     0.200
     0.305    11.125     0.200
     0.327    11.836     0.200
     0.341    12.824     0.200
     0.355    12.824     0.200
     0.404    15.027     0.200
     0.682    23.625     0.200
     2.079    61.586     0.200
     2.118    61.785     0.200
     3.530   101.414     0.200
     0.135     7.422     0.200
     0.257    10.789     0.200
     0.249    10.516     0.200
     0.194     9.016     0.200
     0.330    13.258     0.200
     0.416    15.109     0.200
     0.501    16.805     0.200
     0.463    15.750     0.200
     0.561    19.320     0.200
     0.557    19.586     0.200
     0.487    17.180     0.200
     0.589    20.148     0.200
     0.568    19.328     0.200
     0.637    21.961     0.200
     0.771    25.016     0.200
     0.743    25.289     0.200
     0.764    26.109     0.200
     0.887    28.055     0.200
     2.758    78.500     0.200
     0.065     6.523     0.200
     0.173     8.773     0.200
     0.176     8.734     0.200
     0.234     9.773     0.200
     0.236    10.125     0.200
     0.304    12.062     0.200
     0.303    11.992     0.200
     0.368    14.281     0.200
     0.372    13.320     0.200
     0.455    16.633     0.200
     0.474    16.422     0.200
     0.489    15.969     0.200
     0.501    17.633     0.200
     0.574    19.172     0.200
     0.591    19.969     0.200
     0.620    20.398     0.200
     0.664    22.258     0.200
     0.721    24.438     0.200
     0.061     7.211     0.200
     0.164     8.742     0.200
     0.184     9.219     0.200
     0.227     9.844     0.200
     0.238    10.039     0.200
     0.300    12.344     0.200
     0.311    12.039     0.200
     0.373    13.641     0.200
     0.377    13.445     0.200
     0.419    15.141     0.200
     0.474    16.641     0.200
     0.464    16.344     0.200
     0.486    16.242     0.200
     0.527    17.539     0.200
     0.510    16.945     0.200
     0.569    19.141     0.200
     0.575    19.742     0.200
     0.601    19.742     0.200
     0.618    20.641     0.200
     0.712    22.742     0.200
     0.958    31.031     0.200
     0.921    30.422     0.200
     0.107     8.983     0.200
     0.196    10.104     0.200
     0.182    10.504     0.200
     0.325    14.204     0.200
     0.503    18.704     0.200
     0.669    22.804     0.200
     0.920    29.304     0.200
     0.861    27.504     0.200
     1.401    41.946     0.200
     2.656    76.864     0.200
     0.571    20.435     0.200
     0.761    24.935     0.200
     1.001    33.335     0.200
     1.003    33.635     0.200
     1.036    34.085     0.200
     0.082     5.866     0.200
     0.140     7.776     0.200
     0.207     8.996     0.200
     0.218     9.486     0.200
     0.306    11.216     0.200
     0.301    12.296     0.200
     0.344    12.356     0.200
     0.396    14.296     0.200
     0.337    12.776     0.200
     0.347    13.046     0.200
     0.420    15.026     0.200
     0.365    14.326     0.200
     0.402    14.636     0.200
     0.415    15.416     0.200
     0.476    16.946     0.200
     0.514    18.616     0.200
     0.689    23.186     0.200
     0.186     8.277     0.200
     0.231    10.195     0.200
     0.251    10.418     0.200
     0.454    15.758     0.200
     0.484    16.746     0.200
     0.534    18.625     0.200
     0.535    18.727     0.200
     0.678    23.465     0.200
     0.722    23.266     0.200
     0.913    28.965     0.200
     1.840    53.781     0.200
     9.555   269.227     0.200
     0.175     7.852     0.200
     0.206     9.250     0.200
     0.236    10.000     0.200
     0.260    10.227     0.200
     0.360    13.781     0.200
     0.468    16.086     0.200
     0.489    16.523     0.200
     0.528    17.516     0.200
     0.538    18.602     0.200
     0.533    17.250     0.200
     0.544    17.773     0.200
     0.566    19.023     0.200
     0.583    19.227     0.200
     0.631    20.953     0.200
     0.681    21.930     0.200
     0.681    22.789     0.200
     0.690    22.305     0.200
     0.717    23.023     0.200
     0.811    26.422     0.200
     0.912    28.945     0.200
     1.984    59.539     0.200
     2.349    68.430     0.200
     3.048    86.633     0.200
     3.182    90.336     0.200
     7.733   222.633     0.200
     9.042   293.320     0.200
     9.540   273.133     0.200
     0.189     8.156     0.200
     0.227    10.086     0.200
     0.185     8.438     0.200
     0.249     9.406     0.200
     0.341    13.688     0.200
     0.324    12.789     0.200
     0.447    15.984     0.200
     0.535    19.188     0.200
     0.531    18.586     0.200
     0.524    17.789     0.200
     0.531    17.984     0.200
     0.565    19.586     0.200
     0.610    20.867     0.200
     0.721    23.305     0.200
     0.721    23.086     0.200
     0.680    22.047     0.200
     0.680    22.867     0.200
     0.827    27.750     0.200
     1.837    55.195     0.200
     1.974    59.734     0.200
     4.373   125.656     0.200
     8.005   235.586     0.200
     9.561   270.188     0.200
     0.171     7.500     0.200
     0.214     9.062     0.200
     0.200     8.742     0.200
     0.269    10.383     0.200
     0.341    12.656     0.200
     0.467    15.836     0.200
     0.453    16.117     0.200
     0.525    17.781     0.200
     0.562    18.711     0.200
     0.549    18.766     0.200
     0.619    21.023     0.200
     2.371    68.625     0.200
     2.954    84.023     0.200
     0.205     7.945     0.200
     0.178     8.547     0.200
     0.245    10.773     0.200
     0.231     9.367     0.200
     0.318    13.047     0.200
     0.349    13.484     0.200
     0.449    16.164     0.200
     0.495    16.867     0.200
     0.549    19.023     0.200
     0.574    19.312     0.200
     0.660    21.828     0.200
     0.740    24.336     0.200
     7.746   225.164     0.200
     9.567   273.266     0.200
     0.179     8.477     0.200
     0.249     9.898     0.200
     0.353    13.492     0.200
     0.320    13.203     0.200
     0.207     9.484     0.200
     0.229     9.547     0.200
     0.451    15.883     0.200
     0.500    16.992     0.200
     0.533    18.203     0.200
     0.509    17.539     0.200
     0.557    18.898     0.200
     0.508    16.289     0.200
     0.190     8.438     0.200
     0.236     9.469     0.200
     0.251    10.367     0.200
     0.331    14.039     0.200
     0.361    14.164     0.200
     0.462    16.164     0.200
     0.503    16.766     0.200
     0.510    16.664     0.200
     0.552    18.273     0.200
     0.555    18.867     0.200
     0.659    21.664     0.200
     0.740    23.766     0.200
     0.788    26.469     0.200
     0.859    28.062     0.200
     0.875    27.469     0.200
     0.933    29.367     0.200
     0.089     7.181     0.200
     0.128     7.701     0.200
     0.228     9.481     0.200
     0.270    10.681     0.200
     0.368    14.581     0.200
     0.383    13.681     0.200
     0.492    16.681     0.200
     0.524    18.181     0.200
     0.550    18.481     0.200
     0.533    17.781     0.200
     0.655    20.881     0.200
     0.680    22.381     0.200
     0.713    23.081     0.200
     0.810    26.181     0.200
     0.837    26.981     0.200
     0.910    29.181     0.200
     0.972    30.681     0.200
     0.966    30.481     0.200
     0.990    30.881     0.200
     1.121    34.981     0.200
     1.256    38.681     0.200
     0.089     5.664     0.200
     0.113     6.828     0.200
     0.126     6.938     0.200
     0.199     8.367     0.200
     0.183     8.070     0.200
     0.253    10.070     0.200
     0.339    12.867     0.200
     0.358    12.570     0.200
     0.464    16.766     0.200
     0.491    17.078     0.200
     0.541    18.367     0.200
     0.541    19.109     0.200
     0.534    18.664     0.200
     0.527    17.141     0.200
     0.581    19.367     0.200
     0.685    22.766     0.200
     0.723    23.070     0.200
     0.860    27.828     0.200
     0.871    29.070     0.200
     0.962    31.867     0.200
     0.988    31.766     0.200
     1.022    33.469     0.200
     1.232    38.664     0.200
     1.344    42.664     0.200
     1.437    45.266     0.200
     1.624    47.969     0.200
     0.087     5.289     0.200
     0.120     6.289     0.200
     0.117     6.188     0.200
     0.199     7.586     0.200
     0.184     8.391     0.200
     0.243     9.789     0.200
     0.237     9.391     0.200
     0.324    12.586     0.200
     0.453    16.188     0.200
     0.494    16.789     0.200
     0.515    17.352     0.200
     0.548    17.992     0.200
     0.516    17.789     0.200
     0.547    18.086     0.200
     0.675    21.969     0.200
     0.665    21.672     0.200
     0.675    22.359     0.200
     0.736    23.086     0.200
     0.714    24.242     0.200
     0.794    26.516     0.200
     0.796    26.391     0.200
     0.859    28.461     0.200
     0.868    27.391     0.200
     0.896    28.289     0.200
     0.855    28.086     0.200
     0.927    29.086     0.200
     0.943    30.352     0.200
     0.973    30.086     0.200
     0.946    30.891     0.200
     0.090     5.664     0.200
     0.114     6.676     0.200
     0.120     6.645     0.200
     0.190     7.824     0.200
     0.194     7.906     0.200
     0.242    10.047     0.200
     0.245     9.777     0.200
     0.357    14.426     0.200
     0.461    16.246     0.200
     0.494    17.105     0.200
     0.521    16.816     0.200
     0.541    18.555     0.200
     0.545    19.137     0.200
     0.068     4.938     0.200
     0.142     6.027     0.200
     0.134     6.557     0.200
     0.148     7.197     0.200
     0.187     8.037     0.200
     0.207     8.588     0.200
     0.249     9.357     0.200
     0.331    12.297     0.200
     0.337    12.168     0.200
     0.332    12.316     0.200
     0.333    12.977     0.200
     0.371    14.117     0.200
     0.364    12.617     0.200
     0.379    13.668     0.200
     0.353    13.457     0.200
     0.375    13.117     0.200
     0.464    16.207     0.200
     0.432    14.477     0.200
     0.443    14.918     0.200
     0.478    16.018     0.200
     0.491    16.967     0.200
     0.477    16.887     0.200
     0.516    18.018     0.200
     0.600    21.066     0.200
     0.080     4.514     0.200
     0.135     6.572     0.200
     0.133     6.502     0.200
     0.188     7.203     0.200
     0.198     8.062     0.200
     0.346    12.152     0.200
     0.351    12.572     0.200
     0.325    12.613     0.200
     0.325    12.812     0.200
     0.332    12.832     0.200
     0.345    13.393     0.200
     0.368    13.223     0.200
     0.352    12.633     0.200
     0.373    13.773     0.200
     0.365    13.264     0.200
     0.451    15.223     0.200
     0.419    14.264     0.200
     0.462    16.832     0.200
     0.529    17.463     0.200
     0.081     4.820     0.200
     0.141     6.850     0.200
     0.200     7.859     0.200
     0.122     6.811     0.200
     0.213     8.189     0.200
     0.251     9.590     0.200
     0.341    11.881     0.200
     0.366    12.850     0.200
     0.388    13.730     0.200
     0.380    13.221     0.200
     0.318    12.430     0.200
     0.318    12.400     0.200
     0.325    12.391     0.200
     0.339    12.980     0.200
     0.433    14.600     0.200
     0.436    14.910     0.200
     0.478    15.990     0.200
     0.081     5.848     0.200
     0.125     6.578     0.200
     0.148     6.480     0.200
     0.197     8.180     0.200
     0.209     9.098     0.200
     0.248     9.480     0.200
     0.302    11.680     0.200
     0.344    11.777     0.200
     0.319    13.578     0.200
     0.320    12.480     0.200
     0.327    13.277     0.200
     0.363    14.059     0.200
     0.363    13.398     0.200
     0.378    14.609     0.200
     0.376    13.938     0.200
     0.384    14.379     0.200
     0.440    15.480     0.200
     0.430    14.777     0.200
     0.474    17.988     0.200
     0.042     3.904     0.200
     0.082     4.854     0.200
     0.090     4.615     0.200
     0.095     4.955     0.200
     0.113     4.854     0.200
     0.135     6.004     0.200
     0.169     7.654     0.200
     0.210     9.084     0.200
     0.250    10.545     0.200
     0.261     9.654     0.200
     0.314    11.254     0.200
     0.312    12.574     0.200
     0.341    11.764     0.200
     0.387    14.055     0.200
     0.470    16.555     0.200
     3.448   102.604     0.200
     0.111     8.187     0.200
     0.156     8.687     0.200
     0.186     9.486     0.200
     0.203    10.086     0.200
     0.209     9.886     0.200
     0.242    10.086     0.200
     0.253    10.756     0.200
     0.253    11.187     0.200
     0.384    14.886     0.200
     0.441    15.286     0.200
     0.574    20.786     0.200
     0.677    22.286     0.200
     0.746    24.586     0.200
     0.749    25.886     0.200
     0.764    25.687     0.200
     1.010    31.956     0.200
     1.517    47.174     0.200
     2.557    75.086     0.200
     3.204    91.563     0.200
     0.030     3.667     0.200
     0.115     4.167     0.200
     0.183     7.967     0.200
     0.180     7.067     0.200
     0.195     7.667     0.200
     0.228     8.067     0.200
     0.332    12.767     0.200
     0.353    13.067     0.200
     0.514    17.867     0.200
     0.512    18.767     0.200
     0.070     7.047     0.200
     0.213     9.352     0.200
     0.225     9.047     0.200
     0.230     9.750     0.200
     0.234     9.547     0.200
     0.290    11.938     0.200
     0.314    12.250     0.200
     0.322    12.352     0.200
     0.324    11.352     0.200
     0.330    12.852     0.200
     0.337    12.953     0.200
     0.352    12.047     0.200
     0.370    13.047     0.200
     0.364    13.352     0.200
     0.416    15.453     0.200
     0.411    15.953     0.200
     0.435    14.547     0.200
     0.446    15.750     0.200
     0.462    15.750     0.200
     0.459    16.828     0.200
     0.485    16.453     0.200
     0.515    16.852     0.200
     0.531    18.352     0.200
     0.524    17.352     0.200
     0.534    17.352     0.200
     0.535    16.648     0.200
     0.570    19.148     0.200
     0.563    20.383     0.200
     0.580    18.547     0.200
     0.570    20.250     0.200
     0.600    20.453     0.200
     0.611    21.352     0.200
     0.658    21.547     0.200
     0.650    22.109     0.200
     0.653    21.453     0.200
     0.654    22.562     0.200
     0.679    22.953     0.200
     0.710    24.352     0.200
     0.706    23.672     0.200
     0.698    23.250     0.200
     0.771    25.547     0.200
     0.819    27.312     0.200
     0.821    25.852     0.200
     0.825    27.570     0.200
     0.829    27.852     0.200
     2.817    79.953     0.200
     9.815   285.250     0.200
     0.135     6.180     0.200
     0.170     7.688     0.200
     0.170     6.906     0.200
     0.209     8.703     0.200
     0.241     9.805     0.200
     0.344    12.609     0.200
     0.383    13.109     0.200
     0.406    13.406     0.200
     0.442    15.539     0.200
     0.474    16.609     0.200
     0.102     6.117     0.200
     0.234     8.414     0.200
     0.296    11.414     0.200
     0.315    11.312     0.200
     0.331    11.914     0.200
     0.340    11.812     0.200
     0.364    13.016     0.200
     0.404    14.914     0.200
     0.404    14.516     0.200
     0.409    14.812     0.200
     0.405    14.016     0.200
     0.424    14.914     0.200
     0.424    15.016     0.200
     0.462    16.016     0.200
     0.484    16.211     0.200
     0.500    16.312     0.200
     0.503    17.312     0.200
     0.509    17.211     0.200
     0.523    18.117     0.200
     0.588    20.016     0.200
     0.658    21.312     0.200
     0.691    22.117     0.200
     1.117    36.195     0.200
     2.330    68.211     0.200
     0.169     8.875     0.200
     0.233    10.688     0.200
     0.226    10.781     0.200
     0.237    10.188     0.200
     0.242    10.586     0.200
     0.270    11.086     0.200
     0.262     9.984     0.200
     0.310    12.586     0.200
     0.339    12.883     0.200
     0.353    12.188     0.200
     0.397    14.586     0.200
     0.406    14.781     0.200
     0.413    14.281     0.200
     0.461    16.984     0.200
     0.513    18.086     0.200
     0.518    17.383     0.200
     0.537    18.586     0.200
     0.533    18.781     0.200
     0.632    20.633     0.200
     0.646    20.688     0.200
     0.654    21.188     0.200
     0.678    22.086     0.200
     0.705    23.383     0.200
     0.705    23.281     0.200
     0.706    22.984     0.200
     0.803    26.164     0.200
     0.803    27.555     0.200
     1.288    40.117     0.200
     1.998    62.188     0.200
     2.667    75.984     0.200
     3.281    94.695     0.200
     4.180   117.531     0.200
     9.721   279.984     0.200
     0.076     5.170     0.200
     0.049     5.480     0.200
     0.094     6.180     0.200
     0.094     6.400     0.200
     0.177     8.380     0.200
     0.177     8.150     0.200
     0.231     9.580     0.200
     0.231     8.950     0.200
     0.233    10.080     0.200
     0.240     9.780     0.200
     0.317    13.380     0.200
     0.317    12.220     0.200
     0.317    12.380     0.200
     0.345    13.880     0.200
     0.363    12.580     0.200
     0.363    12.190     0.200
     0.412    14.880     0.200
     0.445    16.480     0.200
     0.474    16.930     0.200
     0.491    16.780     0.200
     0.515    17.080     0.200
     0.515    17.800     0.200
     0.509    19.280     0.200
     0.509    18.330     0.200
     0.551    18.580     0.200
     0.544    18.780     0.200
     0.568    20.080     0.200
     0.568    18.640     0.200
     0.570    19.480     0.200
     0.605    20.780     0.200
     0.626    22.180     0.200
     0.664    21.620     0.200
     0.664    22.080     0.200
     0.737    23.940     0.200
     0.737    23.780     0.200
     0.746    24.680     0.200
     0.750    24.380     0.200
     0.793    26.570     0.200
     1.822    53.848     0.200
     1.899    59.730     0.200
     1.958    59.330     0.200
     2.559    77.220     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
