#!/bin/bash
gmt begin larino1.84_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source larino1.84'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.6 -10.0
  0.6 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.580    -1.810     0.200
     0.535    -0.380     0.200
     0.531     0.513     0.200
     0.542    -0.081     0.200
     0.690    -0.311     0.200
     0.450    -0.379     0.200
     0.691    -0.121     0.200
     0.866    -0.371     0.200
     0.665    -1.037     0.200
     0.853    -0.222     0.200
     0.773    -1.234     0.200
     0.957    -0.263     0.200
     0.870     1.407     0.200
     0.748    -1.003     0.200
     0.497     0.051     0.200
     0.686    -0.069     0.200
     0.899     1.373     0.200
     0.488     0.281     0.200
     0.825     0.227     0.200
     0.524    -0.250     0.200
     0.930     1.553     0.200
     0.615    -0.144     0.200
     0.977     0.864     0.200
     0.527    -0.000     0.200
     0.981     1.020     0.200
     0.503    -0.101     0.200
     0.735    -0.475     0.200
     0.755    -1.079     0.200
     0.966    -0.412     0.200
     0.525    -0.815     0.200
     0.553    -0.332     0.200
     0.559    -0.476     0.200
     0.706     1.382     0.200
     0.582     0.214     0.200
     0.726    -1.394     0.200
     0.663    -0.087     0.200
     0.701     0.008     0.200
     0.218     1.049     0.200
     0.532    -0.245     0.200
     0.696    -0.397     0.200
     0.669    -0.169     0.200
     0.090     1.239     0.200
     0.408    -0.701     0.200
     0.521    -0.629     0.200
     0.804     0.591     0.200
     0.909     0.421     0.200
     0.093    -0.406     0.200
     0.955     0.594     0.200
     0.108    -0.020     0.200
     0.226    -0.429     0.200
     0.497    -0.571     0.200
     0.708     0.284     0.200
     0.377     0.211     0.200
     0.527    -0.239     0.200
     0.760     1.236     0.200
     0.747     0.193     0.200
     0.183    -0.276     0.200
     0.307     0.289     0.200
     0.670    -0.047     0.200
     0.923    -0.182     0.200
     0.709     1.013     0.200
     0.922     0.072     0.200
     0.205     0.871     0.200
     0.664    -0.973     0.200
     0.600    -0.166     0.200
     0.733     0.868     0.200
     0.707    -0.958     0.200
     0.975     0.840     0.200
     0.349     0.237     0.200
     0.834    -0.530     0.200
     0.332     0.332     0.200
     0.369     0.223     0.200
     0.628    -0.617     0.200
     0.992     0.782     0.200
     0.661     0.385     0.200
     0.572    -0.088     0.200
     0.525     0.642     0.200
     0.310     0.169     0.200
     0.459     1.031     0.200
     0.530    -0.173     0.200
     0.546     0.221     0.200
     0.687    -0.261     0.200
     0.962     0.853     0.200
     0.356    -0.100     0.200
     0.683    -0.254     0.200
     0.944     0.573     0.200
     0.335     0.230     0.200
     0.472     1.371     0.200
     0.503     0.972     0.200
     0.591    -0.070     0.200
     0.722    -1.064     0.200
     0.692     0.528     0.200
     0.938     0.091     0.200
     0.443    -0.223     0.200
     0.128    -0.374     0.200
     0.471     0.273     0.200
     0.602     0.656     0.200
     0.642     0.274     0.200
     0.162    -0.090     0.200
     0.627     0.261     0.200
     0.685    -0.301     0.200
     0.704    -0.197     0.200
     0.786    -0.248     0.200
     0.787    -0.230     0.200
     0.821     0.691     0.200
     0.789     0.562     0.200
     0.895    -0.218     0.200
     0.570     0.853     0.200
     0.629    -0.212     0.200
     0.655    -0.514     0.200
     0.753    -0.213     0.200
     0.727    -0.364     0.200
     0.739     0.258     0.200
     0.780     0.364     0.200
     0.836    -0.360     0.200
     0.190     0.042     0.200
     0.647     0.553     0.200
     0.731    -0.741     0.200
     0.810    -0.145     0.200
     0.847    -1.035     0.200
     0.922    -0.156     0.200
     0.928     0.755     0.200
     0.176     0.095     0.200
     0.187     0.115     0.200
     0.423     0.687     0.200
     0.522     0.512     0.200
     0.646     0.082     0.200
     0.669     0.136     0.200
     0.741     0.363     0.200
     0.834    -0.072     0.200
     0.841    -0.390     0.200
     0.935     0.059     0.200
     0.187    -0.145     0.200
     0.255     1.149     0.200
     0.415     0.218     0.200
     0.415     0.240     0.200
     0.686     0.298     0.200
     0.764    -0.076     0.200
     0.780     0.489     0.200
     0.841    -0.211     0.200
     0.517    -0.909     0.200
     0.499    -0.207     0.200
     0.558    -0.658     0.200
     0.732     0.114     0.200
     0.791     0.690     0.200
     0.792     1.717     0.200
     0.840     1.039     0.200
     0.448     0.228     0.200
     0.510     0.398     0.200
     0.520    -0.092     0.200
     0.555     0.258     0.200
     0.743     0.166     0.200
     0.795     0.388     0.200
     0.793     0.311     0.200
     0.853     0.104     0.200
     0.482    -0.657     0.200
     0.485    -0.599     0.200
     0.492     0.005     0.200
     0.759     1.115     0.200
     0.825     0.666     0.200
     0.850     0.689     0.200
     0.418    -0.316     0.200
     0.528    -0.115     0.200
     0.514     0.063     0.200
     0.546    -0.475     0.200
     0.765     0.648     0.200
     0.750    -0.129     0.200
     0.821     0.396     0.200
     0.842     0.972     0.200
     0.492     0.357     0.200
     0.505     0.735     0.200
     0.585    -0.112     0.200
     0.735    -0.375     0.200
     0.827     0.649     0.200
     0.862    -0.318     0.200
     0.518    -0.959     0.200
     0.752     0.749     0.200
     0.780     0.916     0.200
     0.810     0.550     0.200
     0.853     0.330     0.200
     0.533    -0.216     0.200
     0.514     0.051     0.200
     0.748    -0.483     0.200
     0.806     1.145     0.200
     0.851     1.023     0.200
     0.502     0.171     0.200
     0.505     0.463     0.200
     0.573    -0.277     0.200
     0.736    -0.405     0.200
     0.776     1.400     0.200
     0.813     0.332     0.200
     0.856    -0.260     0.200
     0.458    -0.127     0.200
     0.488     1.015     0.200
     0.505     0.301     0.200
     0.570    -0.186     0.200
     0.721     0.452     0.200
     0.800     0.510     0.200
     0.779     0.535     0.200
     0.835    -0.240     0.200
     0.469    -0.549     0.200
     0.492    -0.480     0.200
     0.473     0.220     0.200
     0.583    -0.348     0.200
     0.706    -0.027     0.200
     0.767     0.869     0.200
     0.806     0.985     0.200
     0.824    -0.253     0.200
     0.421    -0.738     0.200
     0.532    -0.537     0.200
     0.543    -0.114     0.200
     0.508     0.138     0.200
     0.765    -0.084     0.200
     0.744    -0.093     0.200
     0.817     0.835     0.200
     0.837     0.015     0.200
     0.391    -0.495     0.200
     0.501    -0.199     0.200
     0.573    -0.860     0.200
     0.528    -0.031     0.200
     0.740     0.235     0.200
     0.766    -0.488     0.200
     0.507    -0.322     0.200
     0.568     0.701     0.200
     0.525    -0.475     0.200
     0.842     0.431     0.200
     0.843     0.254     0.200
     0.502    -0.354     0.200
     0.537    -0.399     0.200
     0.573    -0.807     0.200
     0.747     0.857     0.200
     0.847     1.399     0.200
     0.855     1.284     0.200
     0.516    -0.229     0.200
     0.547     0.315     0.200
     0.561     0.151     0.200
     0.771     0.460     0.200
     0.782     0.202     0.200
     0.833     1.192     0.200
     0.876    -0.168     0.200
     0.509    -0.356     0.200
     0.538     0.192     0.200
     0.566    -0.324     0.200
     0.756     1.059     0.200
     0.774     0.081     0.200
     0.840     1.009     0.200
     0.860     1.318     0.200
     0.516     0.341     0.200
     0.560     0.233     0.200
     0.542     0.547     0.200
     0.768     0.155     0.200
     0.777    -0.070     0.200
     0.833     0.878     0.200
     0.869    -0.522     0.200
     0.534     0.166     0.200
     0.550    -0.017     0.200
     0.528     1.121     0.200
     0.766    -0.431     0.200
     0.803     0.124     0.200
     0.878    -1.091     0.200
     0.513    -0.500     0.200
     0.522     0.049     0.200
     0.561     0.416     0.200
     0.751     0.296     0.200
     0.758    -0.501     0.200
     0.843     1.561     0.200
     0.835     1.126     0.200
     0.510    -0.148     0.200
     0.567    -0.666     0.200
     0.549    -0.206     0.200
     0.785    -0.050     0.200
     0.765     0.628     0.200
     0.839     1.145     0.200
     0.875     0.701     0.200
     0.490    -0.399     0.200
     0.540    -0.396     0.200
     0.584     0.607     0.200
     0.734     1.141     0.200
     0.777    -0.060     0.200
     0.859     0.601     0.200
     0.851     1.331     0.200
     0.507     0.084     0.200
     0.529    -0.183     0.200
     0.743    -0.417     0.200
     0.761     1.025     0.200
     0.820     0.921     0.200
     0.534     0.285     0.200
     0.530     1.285     0.200
     0.541     0.911     0.200
     0.782     0.010     0.200
     0.764     0.158     0.200
     0.814     0.992     0.200
     0.865    -0.908     0.200
     0.392     0.047     0.200
     0.499     0.104     0.200
     0.536     0.590     0.200
     0.575    -0.146     0.200
     0.743     0.827     0.200
     0.773    -0.062     0.200
     0.852     0.795     0.200
     0.849     0.336     0.200
     0.405    -0.369     0.200
     0.516    -0.246     0.200
     0.515     0.003     0.200
     0.558    -0.779     0.200
     0.833     0.916     0.200
     0.836     1.434     0.200
     0.394    -0.318     0.200
     0.498    -0.145     0.200
     0.544     0.056     0.200
     0.747     0.842     0.200
     0.781    -0.030     0.200
     0.850    -0.069     0.200
     0.862     0.855     0.200
     0.556     0.158     0.200
     0.518    -0.068     0.200
     0.495     0.587     0.200
     0.787     1.240     0.200
     0.728     0.008     0.200
     0.793     0.416     0.200
     0.835    -0.667     0.200
     0.508    -0.528     0.200
     0.492     0.424     0.200
     0.566    -0.424     0.200
     0.724     0.004     0.200
     0.782     0.960     0.200
     0.798     0.899     0.200
     0.837    -0.303     0.200
     0.541     1.144     0.200
     0.574     0.674     0.200
     0.748     1.429     0.200
     0.777     0.001     0.200
     0.847    -0.109     0.200
     0.859    -0.436     0.200
     0.515    -0.072     0.200
     0.527     0.818     0.200
     0.560     0.161     0.200
     0.756    -0.387     0.200
     0.763     0.501     0.200
     0.834     0.593     0.200
     0.850    -0.601     0.200
     0.425    -0.185     0.200
     0.531    -0.138     0.200
     0.522     0.181     0.200
     0.544    -0.462     0.200
     0.757    -0.220     0.200
     0.774     1.785     0.200
     0.817     0.987     0.200
     0.854     0.517     0.200
     0.509    -0.225     0.200
     0.461     0.680     0.200
     0.488     0.884     0.200
     0.615    -0.187     0.200
     0.715    -0.182     0.200
     0.733     1.504     0.200
     0.852     0.760     0.200
     0.858    -0.532     0.200
     0.272    -0.230     0.200
     0.401    -0.427     0.200
     0.456    -0.180     0.200
     0.514    -0.242     0.200
     0.511    -0.001     0.200
     0.520    -0.439     0.200
     0.560    -1.081     0.200
     0.561     0.144     0.200
     0.829     1.571     0.200
     0.836     0.640     0.200
     0.425     0.213     0.200
     0.480     0.336     0.200
     0.533     0.237     0.200
     0.518     0.815     0.200
     0.548    -0.228     0.200
     0.542     0.095     0.200
     0.581     0.206     0.200
     0.773    -0.035     0.200
     0.753    -0.369     0.200
     0.816     0.954     0.200
     0.849    -1.068     0.200
     0.253     0.294     0.200
     0.461    -0.007     0.200
     0.502     0.340     0.200
     0.530    -0.361     0.200
     0.541    -0.536     0.200
     0.534    -0.408     0.200
     0.562     0.393     0.200
     0.830     1.600     0.200
     0.816     0.587     0.200
     0.196    -0.004     0.200
     0.463     0.204     0.200
     0.471    -0.163     0.200
     0.472    -0.555     0.200
     0.555     0.744     0.200
     0.556    -0.581     0.200
     0.602    -0.581     0.200
     0.747     1.228     0.200
     0.822     0.443     0.200
     0.823     1.613     0.200
     0.286     0.851     0.200
     0.385    -0.298     0.200
     0.497    -0.227     0.200
     0.457     0.071     0.200
     0.518    -0.266     0.200
     0.523     0.574     0.200
     0.577    -0.336     0.200
     0.567     0.441     0.200
     0.731     0.187     0.200
     0.852     0.102     0.200
     0.835    -0.163     0.200
     0.297     0.660     0.200
     0.372    -0.007     0.200
     0.465    -0.041     0.200
     0.482    -0.064     0.200
     0.521    -0.442     0.200
     0.539     0.214     0.200
     0.577     0.069     0.200
     0.592    -0.944     0.200
     0.722     1.295     0.200
     0.845    -1.016     0.200
     0.867     1.190     0.200
     0.292     0.139     0.200
     0.487    -0.191     0.200
     0.536     0.058     0.200
     0.523    -0.593     0.200
     0.587    -0.823     0.200
     0.577     0.027     0.200
     0.727     1.066     0.200
     0.862     0.992     0.200
     0.844    -0.593     0.200
     0.431     0.099     0.200
     0.485     0.050     0.200
     0.537     0.007     0.200
     0.519     0.479     0.200
     0.554    -0.397     0.200
     0.538    -0.140     0.200
     0.585     0.231     0.200
     0.779     0.784     0.200
     0.811     1.351     0.200
     0.853     1.244     0.200
     0.317     0.355     0.200
     0.472    -0.357     0.200
     0.521    -0.541     0.200
     0.559    -0.147     0.200
     0.617    -1.194     0.200
     0.705     1.649     0.200
     0.714    -0.084     0.200
     0.799     0.582     0.200
     0.856    -0.825     0.200
     0.891     0.930     0.200
     0.316    -0.354     0.200
     0.466    -0.162     0.200
     0.455    -0.298     0.200
     0.506    -0.546     0.200
     0.542    -0.134     0.200
     0.571    -0.014     0.200
     0.609    -0.993     0.200
     0.703     1.688     0.200
     0.722    -0.340     0.200
     0.781     0.605     0.200
     0.838     1.057     0.200
     0.884     1.071     0.200
     0.261     0.164     0.200
     0.520    -0.120     0.200
     0.467    -0.149     0.200
     0.533    -0.459     0.200
     0.515     0.091     0.200
     0.554    -0.585     0.200
     0.571     0.041     0.200
     0.756    -0.016     0.200
     0.752    -0.022     0.200
     0.829     0.938     0.200
     0.839    -0.350     0.200
     0.285     0.198     0.200
     0.489    -0.092     0.200
     0.544    -0.138     0.200
     0.585    -0.697     0.200
     0.589    -0.023     0.200
     0.746    -0.639     0.200
     0.859     0.880     0.200
     0.857     1.064     0.200
     0.286    -0.097     0.200
     0.491    -0.269     0.200
     0.537    -0.127     0.200
     0.581    -0.119     0.200
     0.583     0.902     0.200
     0.748    -0.816     0.200
     0.848     0.900     0.200
     0.858     0.632     0.200
     0.300     0.317     0.200
     0.478    -0.363     0.200
     0.544     0.027     0.200
     0.581     0.002     0.200
     0.597     1.173     0.200
     0.734    -0.901     0.200
     0.782     0.079     0.200
     0.848     1.606     0.200
     0.871     1.870     0.200
     0.297     0.283     0.200
     0.371    -0.113     0.200
     0.471     0.098     0.200
     0.568    -0.880     0.200
     0.604     0.270     0.200
     0.729     0.714     0.200
     0.727     1.389     0.200
     0.878     0.452     0.200
     0.054     0.078     0.200
     0.246     0.328     0.200
     0.424    -0.523     0.200
     0.515     0.006     0.200
     0.533    -0.313     0.200
     0.542    -0.720     0.200
     0.750    -0.107     0.200
     0.771     1.113     0.200
     0.789    -0.768     0.200
     0.816     0.979     0.200
     0.846    -0.499     0.200
     0.269     0.381     0.200
     0.401    -0.422     0.200
     0.511    -0.133     0.200
     0.468    -0.000     0.200
     0.523     0.304     0.200
     0.563    -0.353     0.200
     0.767    -0.691     0.200
     0.759    -0.340     0.200
     0.842    -0.615     0.200
     0.070     0.238     0.200
     0.277     0.529     0.200
     0.466    -0.076     0.200
     0.525     0.441     0.200
     0.571    -0.290     0.200
     0.741    -0.087     0.200
     0.763    -0.011     0.200
     0.845     1.003     0.200
     0.600     0.007     0.200
     0.685    -0.013     0.200
     0.234     0.048     0.200
     0.434    -1.287     0.200
     0.465    -0.937     0.200
     0.527     0.736     0.200
     0.505    -0.411     0.200
     0.804     1.198     0.200
     0.739    -0.012     0.200
     0.852    -0.828     0.200
     0.842     0.884     0.200
     0.944     1.133     0.200
     0.253     0.381     0.200
     0.400    -0.024     0.200
     0.564     0.523     0.200
     0.743     0.995     0.200
     0.822     1.807     0.200
     0.903     0.641     0.200
     0.030    -0.095     0.200
     0.233     0.486     0.200
     0.444    -0.045     0.200
     0.444     0.440     0.200
     0.452     0.104     0.200
     0.488    -0.292     0.200
     0.464     0.075     0.200
     0.489     0.110     0.200
     0.518    -0.834     0.200
     0.560     0.068     0.200
     0.813    -0.609     0.200
     0.810    -0.872     0.200
     0.793     0.318     0.200
     0.935     1.619     0.200
     0.155     0.754     0.200
     0.153     0.973     0.200
     0.318    -0.196     0.200
     0.579     0.417     0.200
     0.762     0.533     0.200
     0.791     0.488     0.200
     0.819     0.538     0.200
     0.074     0.095     0.200
     0.344    -0.110     0.200
     0.418     0.741     0.200
     0.463    -0.100     0.200
     0.533    -0.534     0.200
     0.533     0.051     0.200
     0.543    -1.093     0.200
     0.600     0.683     0.200
     0.782     0.693     0.200
     0.789    -0.303     0.200
     0.816     0.935     0.200
     0.337    -0.276     0.200
     0.389     0.046     0.200
     0.440    -0.199     0.200
     0.423    -0.187     0.200
     0.494     0.586     0.200
     0.563    -0.220     0.200
     0.547    -0.423     0.200
     0.677    -0.211     0.200
     0.656     0.262     0.200
     0.747    -1.315     0.200
     0.747     0.146     0.200
     0.758     0.173     0.200
     0.735     0.202     0.200
     0.779    -0.043     0.200
     0.753    -0.518     0.200
     0.789    -0.093     0.200
     0.791    -0.640     0.200
     0.884     0.331     0.200
     0.959    -0.140     0.200
     0.994     0.474     0.200
     0.212     0.103     0.200
     0.277     0.768     0.200
     0.384    -0.005     0.200
     0.393     0.321     0.200
     0.439    -0.142     0.200
     0.435     0.213     0.200
     0.536     0.065     0.200
     0.524     0.036     0.200
     0.583     0.101     0.200
     0.583     0.742     0.200
     0.631     0.281     0.200
     0.678    -0.127     0.200
     0.748     0.244     0.200
     0.764     0.264     0.200
     0.815    -0.494     0.200
     0.844     0.341     0.200
     0.917     1.188     0.200
     0.922     0.228     0.200
     0.975    -0.252     0.200
     0.955     1.224     0.200
     0.973     0.792     0.200
     0.998     1.822     0.200
     0.238    -0.336     0.200
     0.245    -0.664     0.200
     0.277    -0.707     0.200
     0.363     0.157     0.200
     0.387     0.221     0.200
     0.393     0.331     0.200
     0.515    -0.023     0.200
     0.599     0.314     0.200
     0.625    -0.029     0.200
     0.652     0.626     0.200
     0.726     0.257     0.200
     0.772     0.096     0.200
     0.787    -0.035     0.200
     0.778     0.354     0.200
     0.782     0.345     0.200
     0.861     0.117     0.200
     0.904     0.373     0.200
     0.972    -0.497     0.200
     0.959     0.403     0.200
     0.325    -0.092     0.200
     0.351    -0.938     0.200
     0.411    -0.502     0.200
     0.401    -0.459     0.200
     0.407    -0.450     0.200
     0.483     0.041     0.200
     0.497    -0.296     0.200
     0.548    -0.517     0.200
     0.654    -0.227     0.200
     0.743     0.368     0.200
     0.710    -0.394     0.200
     0.742     0.824     0.200
     0.771    -0.843     0.200
     0.822     0.308     0.200
     0.844     0.515     0.200
     0.863    -0.083     0.200
     0.908    -0.646     0.200
     0.911     0.540     0.200
     0.897    -0.780     0.200
     0.940     0.122     0.200
     0.075    -0.425     0.200
     0.222     0.015     0.200
     0.304     0.010     0.200
     0.281    -0.036     0.200
     0.305    -0.261     0.200
     0.392    -0.616     0.200
     0.425    -0.339     0.200
     0.410     0.104     0.200
     0.448    -0.492     0.200
     0.499    -0.099     0.200
     0.467    -0.154     0.200
     0.517    -0.291     0.200
     0.530     0.128     0.200
     0.607    -0.125     0.200
     0.576    -0.904     0.200
     0.641     0.174     0.200
     0.696    -0.083     0.200
     0.691    -0.296     0.200
     0.754    -0.523     0.200
     0.738     0.258     0.200
     0.755    -0.519     0.200
     0.733    -0.200     0.200
     0.818     0.151     0.200
     0.819    -0.479     0.200
     0.842     0.866     0.200
     0.844    -0.650     0.200
     0.913    -0.605     0.200
     0.892     0.182     0.200
     0.945     0.054     0.200
     0.950    -0.413     0.200
     0.143    -0.593     0.200
     0.199    -0.321     0.200
     0.268    -0.349     0.200
     0.482     0.200     0.200
     0.707     0.373     0.200
     0.707     1.090     0.200
     0.726     0.544     0.200
     0.844     0.552     0.200
     0.823     0.235     0.200
     0.939     0.849     0.200
     0.964     1.020     0.200
     0.884    -0.286     0.200
     0.261     0.098     0.200
     0.296     0.292     0.200
     0.374     0.400     0.200
     0.310     0.336     0.200
     0.422     0.074     0.200
     0.532     1.443     0.200
     0.554     0.933     0.200
     0.562     0.332     0.200
     0.556     0.217     0.200
     0.672     0.417     0.200
     0.662     0.046     0.200
     0.623     0.285     0.200
     0.626     0.216     0.200
     0.654     0.500     0.200
     0.770     0.758     0.200
     0.761     0.348     0.200
     0.764     0.281     0.200
     0.803    -0.284     0.200
     0.265    -0.058     0.200
     0.299     0.158     0.200
     0.374     0.286     0.200
     0.417     0.004     0.200
     0.534     1.171     0.200
     0.557     0.734     0.200
     0.558     0.349     0.200
     0.550     0.365     0.200
     0.652     0.583     0.200
     0.616     0.129     0.200
     0.672     0.368     0.200
     0.658    -0.047     0.200
     0.620     0.254     0.200
     0.772     0.655     0.200
     0.755     0.173     0.200
     0.758     0.515     0.200
     0.799    -0.178     0.200
     0.844     0.670     0.200
     0.973    -0.582     0.200
     0.045    -0.504     0.200
     0.167     0.437     0.200
     0.232     0.091     0.200
     0.244    -0.132     0.200
     0.298    -0.174     0.200
     0.328    -0.405     0.200
     0.394    -0.598     0.200
     0.382     0.190     0.200
     0.449    -0.581     0.200
     0.457    -0.507     0.200
     0.452    -0.190     0.200
     0.525    -0.402     0.200
     0.531    -0.391     0.200
     0.678    -0.465     0.200
     0.668    -0.169     0.200
     0.663    -0.245     0.200
     0.708    -0.188     0.200
     0.817     0.757     0.200
     0.903     1.296     0.200
     0.921    -0.262     0.200
     0.255    -0.370     0.200
     0.298     0.253     0.200
     0.420    -0.134     0.200
     0.539     0.119     0.200
     0.429     0.464     0.200
     0.454     0.489     0.200
     0.630     0.165     0.200
     0.675     0.004     0.200
     0.697    -0.223     0.200
     0.742     0.353     0.200
     0.781    -0.038     0.200
     0.819    -0.692     0.200
     0.810     0.279     0.200
     0.875    -0.187     0.200
     0.909     0.086     0.200
     0.897    -0.332     0.200
     0.856     0.510     0.200
     0.934    -0.252     0.200
     0.975    -0.591     0.200
     0.960     0.046     0.200
     0.218    -0.083     0.200
     0.342     0.292     0.200
     0.366     0.437     0.200
     0.362    -0.430     0.200
     0.532    -0.101     0.200
     0.608     0.560     0.200
     0.604     0.241     0.200
     0.647    -0.056     0.200
     0.747     0.325     0.200
     0.789     0.108     0.200
     0.780     0.462     0.200
     0.800    -0.171     0.200
     0.870     0.033     0.200
     0.884     0.495     0.200
     0.939     0.139     0.200
     0.926    -0.620     0.200
     0.980     1.042     0.200
     0.991    -0.523     0.200
     0.053     0.477     0.200
     0.292    -0.107     0.200
     0.376    -0.578     0.200
     0.336     0.937     0.200
     0.314     0.417     0.200
     0.426    -0.082     0.200
     0.476     0.294     0.200
     0.555    -0.070     0.200
     0.598    -0.626     0.200
     0.540    -0.356     0.200
     0.542     0.216     0.200
     0.580    -0.209     0.200
     0.664    -0.431     0.200
     0.706    -0.991     0.200
     0.749    -0.336     0.200
     0.736    -0.611     0.200
     0.803    -0.478     0.200
     0.820    -0.333     0.200
     0.825    -0.359     0.200
     0.824    -0.740     0.200
     0.789     0.395     0.200
     0.789     0.035     0.200
     0.821    -0.566     0.200
     0.821     0.234     0.200
     0.832     0.286     0.200
     0.839    -0.130     0.200
     0.898    -0.586     0.200
     0.888    -0.157     0.200
     0.888    -0.727     0.200
     0.938     0.220     0.200
     0.938     0.720     0.200
     0.048     0.517     0.200
     0.291     0.186     0.200
     0.261     0.547     0.200
     0.370    -0.263     0.200
     0.315     0.202     0.200
     0.343     1.081     0.200
     0.317     0.761     0.200
     0.423    -0.290     0.200
     0.541     0.063     0.200
     0.484     0.396     0.200
     0.591    -0.446     0.200
     0.551    -0.343     0.200
     0.549    -0.087     0.200
     0.583    -0.529     0.200
     0.666    -0.320     0.200
     0.703    -0.856     0.200
     0.738     0.390     0.200
     0.733    -1.002     0.200
     0.800    -0.531     0.200
     0.798    -0.404     0.200
     0.836     0.247     0.200
     0.845    -0.434     0.200
     0.894    -0.863     0.200
     0.835    -0.349     0.200
     0.938     0.700     0.200
     0.902     0.187     0.200
     0.039     0.376     0.200
     0.120     0.001     0.200
     0.299     0.012     0.200
     0.256     0.468     0.200
     0.266     0.866     0.200
     0.307     0.214     0.200
     0.375    -0.367     0.200
     0.355     0.973     0.200
     0.318     0.696     0.200
     0.412    -0.197     0.200
     0.530     0.119     0.200
     0.496     0.197     0.200
     0.594    -0.259     0.200
     0.547    -0.291     0.200
     0.564    -0.563     0.200
     0.576    -0.260     0.200
     0.676    -0.374     0.200
     0.709    -0.830     0.200
     0.735     0.882     0.200
     0.722    -0.086     0.200
     0.806     1.616     0.200
     0.806    -0.565     0.200
     0.840     0.045     0.200
     0.798     0.106     0.200
     0.842    -0.424     0.200
     0.883    -0.478     0.200
     0.846    -0.541     0.200
     0.929     0.066     0.200
     0.912    -0.408     0.200
     0.063    -0.341     0.200
     0.173     0.653     0.200
     0.216     0.140     0.200
     0.225     0.177     0.200
     0.228    -0.102     0.200
     0.291    -0.128     0.200
     0.321    -0.125     0.200
     0.429    -0.405     0.200
     0.394     0.332     0.200
     0.451    -0.152     0.200
     0.504    -0.198     0.200
     0.513    -0.355     0.200
     0.527     1.339     0.200
     0.559     0.131     0.200
     0.610    -0.536     0.200
     0.607    -0.370     0.200
     0.678    -0.337     0.200
     0.671    -0.560     0.200
     0.658    -0.021     0.200
     0.675    -0.108     0.200
     0.716     0.082     0.200
     0.692    -0.083     0.200
     0.766    -0.675     0.200
     0.802    -0.385     0.200
     0.835    -0.625     0.200
     0.813    -0.034     0.200
     0.887     0.325     0.200
     0.906     1.665     0.200
     0.921    -0.894     0.200
     0.928    -0.180     0.200
     0.934    -0.410     0.200
     0.180    -0.203     0.200
     0.387    -0.404     0.200
     0.392    -0.630     0.200
     0.378    -0.167     0.200
     0.355     0.506     0.200
     0.421     0.097     0.200
     0.507    -0.539     0.200
     0.467    -0.007     0.200
     0.599    -0.376     0.200
     0.569    -0.080     0.200
     0.587    -0.406     0.200
     0.651    -0.468     0.200
     0.686    -0.523     0.200
     0.746    -0.658     0.200
     0.688     0.226     0.200
     0.791    -0.741     0.200
     0.726    -0.060     0.200
     0.837    -0.281     0.200
     0.810     0.373     0.200
     0.924     0.009     0.200
     0.953    -0.542     0.200
     0.990    -0.540     0.200
     0.974    -0.157     0.200
     0.176    -0.629     0.200
     0.186    -0.083     0.200
     0.181    -0.521     0.200
     0.300    -0.541     0.200
     0.307    -0.462     0.200
     0.397    -0.345     0.200
     0.393    -0.276     0.200
     0.364    -0.861     0.200
     0.357     0.402     0.200
     0.385    -0.002     0.200
     0.425     0.049     0.200
     0.504    -0.497     0.200
     0.521     0.024     0.200
     0.536     0.900     0.200
     0.562    -0.344     0.200
     0.606    -0.436     0.200
     0.590    -0.435     0.200
     0.655    -0.443     0.200
     0.692    -0.512     0.200
     0.683    -0.043     0.200
     0.752    -0.823     0.200
     0.723    -0.309     0.200
     0.727    -0.008     0.200
     0.796    -0.536     0.200
     0.804     0.198     0.200
     0.844     0.692     0.200
     0.926     0.600     0.200
     0.986    -0.215     0.200
     0.970     0.362     0.200
     0.998     0.535     0.200
     0.151    -0.610     0.200
     0.196    -0.205     0.200
     0.206    -0.423     0.200
     0.284    -0.624     0.200
     0.270    -0.569     0.200
     0.375    -0.270     0.200
     0.373    -0.217     0.200
     0.331    -0.190     0.200
     0.385    -0.173     0.200
     0.379     0.290     0.200
     0.374    -0.543     0.200
     0.441     0.080     0.200
     0.485    -0.172     0.200
     0.486    -0.104     0.200
     0.546     0.284     0.200
     0.608    -0.404     0.200
     0.608    -0.545     0.200
     0.631    -0.407     0.200
     0.681    -0.443     0.200
     0.735    -0.676     0.200
     0.707     0.454     0.200
     0.837     0.036     0.200
     0.901     0.902     0.200
     0.969    -0.013     0.200
     0.144    -0.708     0.200
     0.201    -0.415     0.200
     0.213    -0.614     0.200
     0.265    -0.554     0.200
     0.280    -0.751     0.200
     0.337    -0.308     0.200
     0.367    -0.337     0.200
     0.371    -0.399     0.200
     0.387    -0.231     0.200
     0.376    -0.565     0.200
     0.386     0.152     0.200
     0.447    -0.044     0.200
     0.479    -0.109     0.200
     0.492    -0.223     0.200
     0.553     0.105     0.200
     0.610    -0.593     0.200
     0.625    -0.343     0.200
     0.615    -0.602     0.200
     0.679    -0.554     0.200
     0.731    -0.675     0.200
     0.713     0.443     0.200
     0.768    -0.387     0.200
     0.757     0.664     0.200
     0.754     0.323     0.200
     0.837    -0.381     0.200
     0.894     0.931     0.200
     0.964     0.038     0.200
     0.046    -0.838     0.200
     0.099    -0.472     0.200
     0.192    -0.495     0.200
     0.174    -0.351     0.200
     0.204    -0.171     0.200
     0.328    -0.666     0.200
     0.285    -0.128     0.200
     0.336    -0.544     0.200
     0.420    -0.291     0.200
     0.358     0.538     0.200
     0.421    -0.283     0.200
     0.409    -0.165     0.200
     0.434     0.267     0.200
     0.442    -0.362     0.200
     0.501    -0.116     0.200
     0.440     0.150     0.200
     0.537     0.105     0.200
     0.511     0.534     0.200
     0.518     0.890     0.200
     0.604     1.351     0.200
     0.596    -0.347     0.200
     0.629    -0.462     0.200
     0.721    -0.528     0.200
     0.661     0.050     0.200
     0.754     0.507     0.200
     0.705     0.125     0.200
     0.780    -0.569     0.200
     0.820    -0.538     0.200
     0.941     0.583     0.200
     0.979    -0.330     0.200
     0.973     1.077     0.200
     0.043    -0.793     0.200
     0.186    -0.644     0.200
     0.177    -0.261     0.200
     0.198    -0.129     0.200
     0.318    -0.625     0.200
     0.293    -0.034     0.200
     0.346    -0.612     0.200
     0.358     0.459     0.200
     0.411    -0.592     0.200
     0.411    -0.371     0.200
     0.401    -0.226     0.200
     0.431     0.188     0.200
     0.452    -0.189     0.200
     0.448    -0.076     0.200
     0.502    -0.238     0.200
     0.515     0.439     0.200
     0.546    -0.175     0.200
     0.594    -0.474     0.200
     0.621    -0.441     0.200
     0.669    -0.062     0.200
     0.711    -0.444     0.200
     0.711     0.328     0.200
     0.712     0.074     0.200
     0.759     0.484     0.200
     0.770    -0.496     0.200
     0.811    -0.700     0.200
     0.787     0.466     0.200
     0.935     0.042     0.200
     0.981    -0.042     0.200
     0.116     0.649     0.200
     0.139     0.060     0.200
     0.143    -0.219     0.200
     0.230     0.112     0.200
     0.257     0.210     0.200
     0.334    -0.208     0.200
     0.345    -0.006     0.200
     0.371     0.835     0.200
     0.401    -0.225     0.200
     0.445     0.019     0.200
     0.461    -0.164     0.200
     0.480    -0.554     0.200
     0.481     0.234     0.200
     0.528    -0.058     0.200
     0.583     0.149     0.200
     0.610     0.670     0.200
     0.613     0.082     0.200
     0.663     0.817     0.200
     0.695    -0.223     0.200
     0.729     0.222     0.200
     0.741     0.255     0.200
     0.767     0.202     0.200
     0.844    -0.218     0.200
     0.853    -0.262     0.200
     0.910     0.798     0.200
     0.938     0.353     0.200
     0.948    -0.217     0.200
     0.070     0.140     0.200
     0.117     0.518     0.200
     0.196     0.998     0.200
     0.321     0.309     0.200
     0.324     0.389     0.200
     0.351     0.163     0.200
     0.365     0.049     0.200
     0.362     0.437     0.200
     0.475    -0.463     0.200
     0.495     0.001     0.200
     0.541    -0.346     0.200
     0.546    -0.495     0.200
     0.518     0.777     0.200
     0.580    -0.423     0.200
     0.582    -0.061     0.200
     0.613    -0.135     0.200
     0.577     0.292     0.200
     0.581    -0.437     0.200
     0.581    -0.320     0.200
     0.641    -0.015     0.200
     0.700     0.248     0.200
     0.722    -0.517     0.200
     0.704     0.066     0.200
     0.703     0.415     0.200
     0.737    -0.292     0.200
     0.737    -0.503     0.200
     0.779    -0.381     0.200
     0.798    -0.347     0.200
     0.854    -0.661     0.200
     0.854    -0.473     0.200
     0.892    -0.153     0.200
     0.943    -0.605     0.200
     0.977     0.837     0.200
     0.993     0.308     0.200
     0.182    -0.726     0.200
     0.290    -0.095     0.200
     0.356    -0.180     0.200
     0.375    -0.103     0.200
     0.419     0.463     0.200
     0.423     0.318     0.200
     0.418     0.142     0.200
     0.553    -0.320     0.200
     0.603     0.307     0.200
     0.612    -0.093     0.200
     0.612    -0.151     0.200
     0.631     0.197     0.200
     0.680    -0.008     0.200
     0.701     0.389     0.200
     0.739    -0.693     0.200
     0.700     0.012     0.200
     0.743     0.562     0.200
     0.798    -0.248     0.200
     0.826    -0.584     0.200
     0.835    -0.512     0.200
     0.834     0.416     0.200
     0.848     0.022     0.200
     0.903    -0.389     0.200
     0.912    -0.524     0.200
     0.939     0.903     0.200
     0.947     0.448     0.200
     0.993     0.062     0.200
     0.190    -0.752     0.200
     0.290    -0.079     0.200
     0.363    -0.344     0.200
     0.431     0.193     0.200
     0.440     0.001     0.200
     0.419     0.335     0.200
     0.548    -0.042     0.200
     0.605    -0.128     0.200
     0.620    -0.285     0.200
     0.623    -0.445     0.200
     0.648    -0.066     0.200
     0.695    -0.320     0.200
     0.718     0.259     0.200
     0.714     0.519     0.200
     0.761     0.098     0.200
     0.812    -0.242     0.200
     0.839    -0.789     0.200
     0.865    -0.384     0.200
     0.906    -0.449     0.200
     0.920    -0.416     0.200
     0.953     0.668     0.200
     0.958     0.618     0.200
     0.061     0.435     0.200
     0.186     0.268     0.200
     0.241    -0.025     0.200
     0.223     0.088     0.200
     0.301     0.079     0.200
     0.314    -0.039     0.200
     0.381     0.251     0.200
     0.423    -0.488     0.200
     0.420     0.266     0.200
     0.476    -0.373     0.200
     0.514     0.004     0.200
     0.524     0.125     0.200
     0.573    -0.823     0.200
     0.569    -0.408     0.200
     0.576    -0.362     0.200
     0.604    -0.387     0.200
     0.658    -0.243     0.200
     0.616    -0.083     0.200
     0.683    -0.277     0.200
     0.736    -0.073     0.200
     0.713     0.430     0.200
     0.726    -0.078     0.200
     0.719     0.396     0.200
     0.728     0.446     0.200
     0.839     0.144     0.200
     0.913     0.353     0.200
     0.039    -0.178     0.200
     0.194    -0.334     0.200
     0.239     0.619     0.200
     0.201     1.407     0.200
     0.250    -0.479     0.200
     0.311    -0.102     0.200
     0.332    -0.363     0.200
     0.338     0.328     0.200
     0.355    -0.289     0.200
     0.404    -0.243     0.200
     0.399     0.265     0.200
     0.435    -0.072     0.200
     0.421     0.821     0.200
     0.474    -0.511     0.200
     0.480     0.241     0.200
     0.499     1.176     0.200
     0.510    -0.807     0.200
     0.614    -0.917     0.200
     0.698    -0.489     0.200
     0.676     0.051     0.200
     0.724    -0.529     0.200
     0.677    -0.250     0.200
     0.722    -0.913     0.200
     0.700    -0.607     0.200
     0.746    -0.503     0.200
     0.758    -0.550     0.200
     0.816     0.406     0.200
     0.835    -1.043     0.200
     0.852     0.064     0.200
     0.873     0.243     0.200
     0.852    -0.643     0.200
     0.944    -0.812     0.200
     0.936    -0.210     0.200
     0.944     0.797     0.200
     0.964     0.860     0.200
     0.961    -0.486     0.200
     0.170    -0.894     0.200
     0.222    -0.548     0.200
     0.223     0.279     0.200
     0.249    -0.158     0.200
     0.295    -0.481     0.200
     0.304    -0.337     0.200
     0.338    -0.553     0.200
     0.333    -0.133     0.200
     0.390    -0.260     0.200
     0.453    -0.480     0.200
     0.427    -0.525     0.200
     0.453    -0.517     0.200
     0.436     0.246     0.200
     0.479     0.135     0.200
     0.491    -0.453     0.200
     0.506     1.083     0.200
     0.616    -0.603     0.200
     0.669    -0.013     0.200
     0.685     0.436     0.200
     0.733    -0.277     0.200
     0.746    -0.165     0.200
     0.757    -0.418     0.200
     0.821    -0.663     0.200
     0.849    -0.418     0.200
     0.878    -0.197     0.200
     0.901     1.248     0.200
     0.940    -0.553     0.200
     0.945     0.264     0.200
     0.976    -0.427     0.200
     0.990     0.543     0.200
     0.031    -0.445     0.200
     0.191    -0.516     0.200
     0.244    -0.453     0.200
     0.236     0.475     0.200
     0.209     1.165     0.200
     0.303    -0.336     0.200
     0.324    -0.360     0.200
     0.355    -0.365     0.200
     0.342    -0.004     0.200
     0.396    -0.208     0.200
     0.465    -0.638     0.200
     0.406     0.001     0.200
     0.435    -0.214     0.200
     0.429     0.558     0.200
     0.509    -0.688     0.200
     0.485    -0.038     0.200
     0.506     1.071     0.200
     0.609    -0.592     0.200
     0.691    -0.129     0.200
     0.683    -0.118     0.200
     0.751    -0.493     0.200
     0.762    -0.308     0.200
     0.827    -0.416     0.200
     0.857    -0.455     0.200
     0.860     0.155     0.200
     0.938    -0.434     0.200
     0.879     1.472     0.200
     0.943     0.092     0.200
     0.972     0.663     0.200
     0.044    -0.046     0.200
     0.192    -0.381     0.200
     0.251    -0.366     0.200
     0.245     0.763     0.200
     0.316    -0.192     0.200
     0.334    -0.313     0.200
     0.332     0.121     0.200
     0.350    -0.226     0.200
     0.397     0.355     0.200
     0.410    -0.105     0.200
     0.415     0.940     0.200
     0.474     0.025     0.200
     0.479    -0.574     0.200
     0.486    -0.567     0.200
     0.493     1.158     0.200
     0.505    -0.656     0.200
     0.621    -0.507     0.200
     0.671    -0.370     0.200
     0.699    -0.404     0.200
     0.739    -0.647     0.200
     0.751    -0.672     0.200
     0.841    -1.117     0.200
     0.846    -0.845     0.200
     0.849     1.065     0.200
     0.950    -0.450     0.200
     0.032    -0.365     0.200
     0.196    -0.481     0.200
     0.233     0.465     0.200
     0.248    -0.483     0.200
     0.303    -0.310     0.200
     0.327    -0.447     0.200
     0.345    -0.066     0.200
     0.359    -0.374     0.200
     0.396    -0.188     0.200
     0.403     0.014     0.200
     0.431    -0.209     0.200
     0.466    -0.669     0.200
     0.429     0.560     0.200
     0.487    -0.002     0.200
     0.514    -0.728     0.200
     0.507     1.018     0.200
     0.607    -0.517     0.200
     0.695    -0.102     0.200
     0.714    -0.559     0.200
     0.684     0.175     0.200
     0.685    -0.193     0.200
     0.765    -0.463     0.200
     0.827    -0.847     0.200
     0.857     0.265     0.200
     0.859    -0.044     0.200
     0.875     0.991     0.200
     0.936    -0.570     0.200
     0.944    -0.055     0.200
     0.952     0.813     0.200
     0.970     0.898     0.200
     0.969    -0.657     0.200
     0.043     0.179     0.200
     0.169     1.118     0.200
     0.205     0.511     0.200
     0.246     0.279     0.200
     0.237     0.718     0.200
     0.328     0.119     0.200
     0.314     0.096     0.200
     0.381     0.622     0.200
     0.453    -0.157     0.200
     0.454    -0.039     0.200
     0.528    -0.134     0.200
     0.535    -0.340     0.200
     0.522    -0.413     0.200
     0.520    -0.369     0.200
     0.520     0.529     0.200
     0.557     0.231     0.200
     0.624    -0.305     0.200
     0.633    -0.528     0.200
     0.668     0.069     0.200
     0.662     0.181     0.200
     0.669    -0.149     0.200
     0.663    -0.050     0.200
     0.681    -0.607     0.200
     0.709     0.037     0.200
     0.786    -0.549     0.200
     0.797    -0.377     0.200
     0.858    -0.622     0.200
     0.907     0.541     0.200
     0.889    -0.519     0.200
     0.944    -0.798     0.200
     0.924    -0.435     0.200
     0.973    -0.585     0.200
     0.033    -0.708     0.200
     0.151    -0.310     0.200
     0.193    -0.636     0.200
     0.207     0.639     0.200
     0.236     0.165     0.200
     0.232     0.338     0.200
     0.246    -0.511     0.200
     0.305    -0.406     0.200
     0.327    -0.304     0.200
     0.341    -0.156     0.200
     0.355    -0.379     0.200
     0.398    -0.134     0.200
     0.404    -0.151     0.200
     0.435    -0.235     0.200
     0.468    -0.441     0.200
     0.484    -0.021     0.200
     0.504     1.006     0.200
     0.510    -0.554     0.200
     0.610    -0.544     0.200
     0.693     0.301     0.200
     0.682    -0.165     0.200
     0.716    -0.505     0.200
     0.721    -0.194     0.200
     0.723    -0.616     0.200
     0.714    -0.760     0.200
     0.750    -0.363     0.200
     0.829    -0.622     0.200
     0.857    -0.240     0.200
     0.856    -0.229     0.200
     0.939    -0.639     0.200
     0.941    -0.177     0.200
     0.970     0.268     0.200
     0.967    -0.771     0.200
     0.135    -0.419     0.200
     0.257    -0.099     0.200
     0.249    -0.186     0.200
     0.194    -0.230     0.200
     0.276     0.572     0.200
     0.330    -0.010     0.200
     0.416    -0.227     0.200
     0.501    -0.496     0.200
     0.505    -0.578     0.200
     0.463     0.268     0.200
     0.561    -0.426     0.200
     0.557    -0.544     0.200
     0.487    -0.389     0.200
     0.589    -0.146     0.200
     0.568    -0.122     0.200
     0.598     0.309     0.200
     0.619    -0.406     0.200
     0.569    -0.129     0.200
     0.637    -0.438     0.200
     0.615     1.087     0.200
     0.682    -0.547     0.200
     0.665     0.255     0.200
     0.637     0.323     0.200
     0.771    -0.460     0.200
     0.743    -0.015     0.200
     0.795    -0.375     0.200
     0.796    -0.539     0.200
     0.764     0.496     0.200
     0.803    -0.042     0.200
     0.887    -0.527     0.200
     0.938    -0.298     0.200
     0.895    -0.380     0.200
     0.954    -0.701     0.200
     0.988    -0.484     0.200
     0.997     0.436     0.200
     0.995    -0.044     0.200
     0.173    -0.248     0.200
     0.176    -0.118     0.200
     0.234    -0.422     0.200
     0.236    -0.283     0.200
     0.304    -0.179     0.200
     0.303    -0.147     0.200
     0.312     0.930     0.200
     0.368     0.133     0.200
     0.372    -0.608     0.200
     0.413    -0.498     0.200
     0.429     0.010     0.200
     0.455    -0.064     0.200
     0.474    -0.461     0.200
     0.489    -0.810     0.200
     0.501    -0.014     0.200
     0.537    -0.209     0.200
     0.563    -0.505     0.200
     0.574    -0.537     0.200
     0.575    -0.428     0.200
     0.591    -0.374     0.200
     0.620    -0.491     0.200
     0.664    -0.367     0.200
     0.678    -0.367     0.200
     0.706    -0.757     0.200
     0.721     0.132     0.200
     0.715    -0.211     0.200
     0.723    -0.425     0.200
     0.739    -0.220     0.200
     0.786     0.508     0.200
     0.788     0.559     0.200
     0.797     1.012     0.200
     0.798     0.881     0.200
     0.808     0.909     0.200
     0.819    -0.349     0.200
     0.811     0.506     0.200
     0.827     0.756     0.200
     0.909     0.594     0.200
     0.914     0.780     0.200
     0.925     1.124     0.200
     0.949     0.549     0.200
     0.964    -0.650     0.200
     0.986    -0.277     0.200
     0.061    -0.157     0.200
     0.164    -0.162     0.200
     0.184    -0.049     0.200
     0.227    -0.340     0.200
     0.238    -0.296     0.200
     0.300    -0.175     0.200
     0.311    -0.253     0.200
     0.322     0.778     0.200
     0.373    -0.650     0.200
     0.377     0.090     0.200
     0.422     0.105     0.200
     0.419    -0.497     0.200
     0.474    -0.491     0.200
     0.464    -0.077     0.200
     0.486    -0.709     0.200
     0.527    -0.066     0.200
     0.510    -0.072     0.200
     0.569    -0.510     0.200
     0.575    -0.466     0.200
     0.569    -0.510     0.200
     0.601    -0.497     0.200
     0.618    -0.273     0.200
     0.659    -0.354     0.200
     0.681    -0.288     0.200
     0.735    -0.517     0.200
     0.732     0.130     0.200
     0.721     0.003     0.200
     0.712    -0.719     0.200
     0.724    -0.050     0.200
     0.733    -0.275     0.200
     0.812    -0.162     0.200
     0.792     0.430     0.200
     0.795     0.879     0.200
     0.803     0.510     0.200
     0.805     0.904     0.200
     0.811     0.786     0.200
     0.814     0.510     0.200
     0.817     0.535     0.200
     0.836     0.388     0.200
     0.911     1.026     0.200
     0.958    -0.589     0.200
     0.921     0.873     0.200
     0.107    -0.352     0.200
     0.107    -0.081     0.200
     0.196    -0.048     0.200
     0.182     0.227     0.200
     0.325     0.812     0.200
     0.503     0.684     0.200
     0.677     0.805     0.200
     0.669     0.556     0.200
     0.729     1.097     0.200
     0.702     0.431     0.200
     0.827     0.962     0.200
     0.785     0.386     0.200
     0.813     1.162     0.200
     0.914     0.732     0.200
     0.920    -0.055     0.200
     0.861     0.242     0.200
     0.933     0.259     0.200
     0.922     0.273     0.200
     0.945     0.219     0.200
     0.959    -0.125     0.200
     0.927     0.199     0.200
     0.999    -0.307     0.200
     0.109    -0.867     0.200
     0.256    -0.573     0.200
     0.571     0.235     0.200
     0.686     0.538     0.200
     0.744     0.343     0.200
     0.779     0.829     0.200
     0.761     0.236     0.200
     0.815     1.287     0.200
     0.765    -0.025     0.200
     0.858    -0.066     0.200
     0.903     0.274     0.200
     0.847     0.018     0.200
     0.140    -0.192     0.200
     0.207    -0.277     0.200
     0.178     0.542     0.200
     0.223    -0.541     0.200
     0.218     0.435     0.200
     0.255     0.634     0.200
     0.306    -0.437     0.200
     0.301    -0.013     0.200
     0.344    -0.400     0.200
     0.396     0.473     0.200
     0.337    -0.064     0.200
     0.347    -0.490     0.200
     0.420    -0.326     0.200
     0.365     0.149     0.200
     0.402    -0.228     0.200
     0.415    -0.244     0.200
     0.476    -0.372     0.200
     0.441    -0.406     0.200
     0.553    -0.152     0.200
     0.575     0.274     0.200
     0.514    -0.523     0.200
     0.559     0.414     0.200
     0.561     0.517     0.200
     0.571     0.493     0.200
     0.579     1.012     0.200
     0.624    -0.500     0.200
     0.582     0.467     0.200
     0.564    -0.224     0.200
     0.609     0.658     0.200
     0.689    -0.757     0.200
     0.666     0.290     0.200
     0.751    -0.069     0.200
     0.727     1.299     0.200
     0.751     1.212     0.200
     0.724     1.089     0.200
     0.786     0.922     0.200
     0.824    -0.126     0.200
     0.854     0.527     0.200
     0.876     0.617     0.200
     0.918     0.575     0.200
     0.913     0.129     0.200
     0.967     0.667     0.200
     0.991     0.311     0.200
     0.186    -0.106     0.200
     0.231     0.292     0.200
     0.251     0.158     0.200
     0.330     1.064     0.200
     0.348     0.373     0.200
     0.454    -0.165     0.200
     0.484    -0.573     0.200
     0.534    -0.645     0.200
     0.529    -0.855     0.200
     0.535    -0.322     0.200
     0.525     0.226     0.200
     0.531    -0.529     0.200
     0.572    -0.500     0.200
     0.623    -0.539     0.200
     0.678     1.470     0.200
     0.678    -0.909     0.200
     0.675    -0.433     0.200
     0.675     1.108     0.200
     0.722    -0.763     0.200
     0.722    -0.892     0.200
     0.720     0.367     0.200
     0.807    -0.490     0.200
     0.806    -0.175     0.200
     0.834    -0.451     0.200
     0.834    -0.252     0.200
     0.882    -0.832     0.200
     0.863    -0.180     0.200
     0.930    -0.729     0.200
     0.913    -1.015     0.200
     0.175     0.077     0.200
     0.206     0.095     0.200
     0.236     0.122     0.200
     0.260    -0.101     0.200
     0.345     0.720     0.200
     0.360     0.277     0.200
     0.468    -0.074     0.200
     0.489    -0.364     0.200
     0.528    -0.128     0.200
     0.538    -0.118     0.200
     0.533    -0.683     0.200
     0.544    -0.475     0.200
     0.539     0.138     0.200
     0.566    -0.295     0.200
     0.583    -0.418     0.200
     0.633    -0.378     0.200
     0.631    -0.149     0.200
     0.668    -0.602     0.200
     0.681    -0.569     0.200
     0.681    -0.710     0.200
     0.681    -0.413     0.200
     0.690    -0.440     0.200
     0.717    -0.480     0.200
     0.690     0.830     0.200
     0.734     0.124     0.200
     0.811     0.222     0.200
     0.822    -0.359     0.200
     0.819    -0.239     0.200
     0.857    -0.571     0.200
     0.854    -0.341     0.200
     0.875    -0.333     0.200
     0.849    -0.488     0.200
     0.849    -0.605     0.200
     0.878    -0.160     0.200
     0.912    -0.718     0.200
     0.920    -0.219     0.200
     0.962    -0.497     0.200
     0.943    -0.641     0.200
     0.969    -0.542     0.200
     0.189    -0.646     0.200
     0.227    -0.109     0.200
     0.185    -0.191     0.200
     0.249    -0.482     0.200
     0.341     0.165     0.200
     0.324     0.439     0.200
     0.479    -0.506     0.200
     0.447    -0.111     0.200
     0.535    -0.538     0.200
     0.531    -0.332     0.200
     0.524    -0.503     0.200
     0.521     0.021     0.200
     0.531    -1.135     0.200
     0.565    -0.452     0.200
     0.617    -0.437     0.200
     0.610    -0.225     0.200
     0.659    -0.773     0.200
     0.668    -0.440     0.200
     0.721    -0.829     0.200
     0.670     0.696     0.200
     0.680    -1.362     0.200
     0.680    -1.042     0.200
     0.680    -1.229     0.200
     0.713     0.028     0.200
     0.804    -0.385     0.200
     0.843    -0.403     0.200
     0.852    -0.767     0.200
     0.801    -0.392     0.200
     0.809    -0.376     0.200
     0.827    -0.688     0.200
     0.827    -0.234     0.200
     0.883     0.014     0.200
     0.911    -0.969     0.200
     0.858    -0.261     0.200
     0.932    -0.595     0.200
     0.956    -0.711     0.200
     0.949    -0.626     0.200
     0.171    -0.189     0.200
     0.214    -0.048     0.200
     0.200     0.106     0.200
     0.269    -0.166     0.200
     0.341     0.328     0.200
     0.337     0.804     0.200
     0.467    -0.381     0.200
     0.453    -0.012     0.200
     0.515    -0.406     0.200
     0.517    -0.178     0.200
     0.525    -0.499     0.200
     0.537     0.230     0.200
     0.562    -0.371     0.200
     0.549    -0.894     0.200
     0.611    -0.454     0.200
     0.646    -0.629     0.200
     0.619    -0.027     0.200
     0.702    -0.541     0.200
     0.674    -0.324     0.200
     0.698    -0.413     0.200
     0.725     0.176     0.200
     0.801    -0.448     0.200
     0.836    -0.661     0.200
     0.831    -0.419     0.200
     0.863    -0.605     0.200
     0.832    -0.376     0.200
     0.818    -0.270     0.200
     0.827     0.332     0.200
     0.893    -0.747     0.200
     0.912    -0.389     0.200
     0.873    -0.102     0.200
     0.942    -0.657     0.200
     0.934    -0.695     0.200
     0.205    -0.578     0.200
     0.178    -0.087     0.200
     0.245    -0.129     0.200
     0.231    -0.408     0.200
     0.318     0.629     0.200
     0.349     0.260     0.200
     0.449    -0.022     0.200
     0.495    -0.409     0.200
     0.554    -0.481     0.200
     0.549    -0.264     0.200
     0.511    -1.088     0.200
     0.530    -0.419     0.200
     0.509     0.196     0.200
     0.574    -0.377     0.200
     0.629    -0.311     0.200
     0.607    -0.134     0.200
     0.676    -0.552     0.200
     0.660    -1.192     0.200
     0.670    -0.373     0.200
     0.660     1.168     0.200
     0.740    -0.768     0.200
     0.707     0.178     0.200
     0.789    -0.680     0.200
     0.813    -0.242     0.200
     0.789    -0.244     0.200
     0.859    -0.286     0.200
     0.871    -0.659     0.200
     0.829    -0.629     0.200
     0.902    -0.653     0.200
     0.848    -0.107     0.200
     0.930    -0.911     0.200
     0.949    -0.598     0.200
     0.940    -0.502     0.200
     0.179     0.565     0.200
     0.249     0.210     0.200
     0.353     0.546     0.200
     0.320     1.148     0.200
     0.207     0.095     0.200
     0.229     0.228     0.200
     0.451    -0.006     0.200
     0.500    -0.442     0.200
     0.533    -0.473     0.200
     0.578    -0.381     0.200
     0.509     0.125     0.200
     0.553    -0.373     0.200
     0.609    -0.041     0.200
     0.634    -0.472     0.200
     0.557    -0.421     0.200
     0.673    -0.483     0.200
     0.680    -0.727     0.200
     0.508    -0.851     0.200
     0.709     0.324     0.200
     0.817    -0.370     0.200
     0.744    -0.735     0.200
     0.832    -0.480     0.200
     0.657    -0.755     0.200
     0.789    -0.261     0.200
     0.849    -0.145     0.200
     0.875    -0.839     0.200
     0.786    -0.212     0.200
     0.934    -0.884     0.200
     0.962    -0.199     0.200
     0.979    -0.701     0.200
     0.905    -0.724     0.200
     0.951    -0.559     0.200
     0.978    -0.717     0.200
     0.199    -0.198     0.200
     0.190     0.076     0.200
     0.236    -0.118     0.200
     0.251     0.045     0.200
     0.331     0.676     0.200
     0.361     0.197     0.200
     0.462    -0.120     0.200
     0.503    -0.455     0.200
     0.510    -0.772     0.200
     0.519     0.212     0.200
     0.552    -0.396     0.200
     0.555    -0.265     0.200
     0.586    -0.484     0.200
     0.640    -0.467     0.200
     0.659    -0.451     0.200
     0.683    -0.709     0.200
     0.683    -0.440     0.200
     0.740    -0.673     0.200
     0.720     0.315     0.200
     0.788     0.063     0.200
     0.799    -0.248     0.200
     0.825    -0.434     0.200
     0.842    -0.461     0.200
     0.867    -0.313     0.200
     0.859    -0.158     0.200
     0.875    -0.733     0.200
     0.899    -0.620     0.200
     0.933    -0.966     0.200
     0.944    -0.475     0.200
     0.951    -0.507     0.200
     0.980    -0.528     0.200
     0.089     0.051     0.200
     0.165     0.007     0.200
     0.128    -0.090     0.200
     0.228    -0.284     0.200
     0.270    -0.128     0.200
     0.368     0.542     0.200
     0.383    -0.058     0.200
     0.492    -0.326     0.200
     0.524     0.046     0.200
     0.550    -0.218     0.200
     0.533    -0.078     0.200
     0.558     0.239     0.200
     0.604    -0.503     0.200
     0.653    -0.606     0.200
     0.682    -0.758     0.200
     0.717    -0.380     0.200
     0.680     0.545     0.200
     0.713    -0.383     0.200
     0.757     0.483     0.200
     0.843    -0.430     0.200
     0.810    -0.149     0.200
     0.865    -0.420     0.200
     0.837    -0.242     0.200
     0.868    -0.424     0.200
     0.870    -0.094     0.200
     0.872    -0.529     0.200
     0.910     0.185     0.200
     0.916    -0.564     0.200
     0.898    -0.180     0.200
     0.946    -0.244     0.200
     0.972    -0.338     0.200
     0.966    -0.282     0.200
     0.990    -0.343     0.200
     0.089     0.742     0.200
     0.113     0.958     0.200
     0.126     0.806     0.200
     0.199     0.823     0.200
     0.183     0.866     0.200
     0.238     1.099     0.200
     0.253     0.401     0.200
     0.339     1.259     0.200
     0.358     0.831     0.200
     0.464     0.252     0.200
     0.491    -0.043     0.200
     0.541    -0.259     0.200
     0.532     0.200     0.200
     0.541     0.107     0.200
     0.534    -0.026     0.200
     0.527    -0.799     0.200
     0.581    -0.422     0.200
     0.626    -0.151     0.200
     0.632    -0.459     0.200
     0.670    -0.602     0.200
     0.685    -0.365     0.200
     0.683     0.889     0.200
     0.676    -0.621     0.200
     0.728     0.439     0.200
     0.723    -0.445     0.200
     0.812    -0.417     0.200
     0.844    -0.461     0.200
     0.805    -0.062     0.200
     0.860    -0.557     0.200
     0.871    -0.303     0.200
     0.881    -0.390     0.200
     0.918    -0.597     0.200
     0.917    -0.831     0.200
     0.937    -0.100     0.200
     0.927    -0.323     0.200
     0.962    -0.687     0.200
     0.966    -0.492     0.200
     0.984    -0.575     0.200
     0.988    -0.118     0.200
     0.087    -0.184     0.200
     0.120    -0.054     0.200
     0.117    -0.078     0.200
     0.199    -0.087     0.200
     0.184     0.197     0.200
     0.243     0.148     0.200
     0.237    -0.184     0.200
     0.324     0.748     0.200
     0.352     0.245     0.200
     0.453    -0.106     0.200
     0.494    -0.462     0.200
     0.515    -0.719     0.200
     0.548    -0.419     0.200
     0.516     0.094     0.200
     0.547    -0.267     0.200
     0.577    -0.422     0.200
     0.613    -0.245     0.200
     0.631    -0.445     0.200
     0.675    -0.734     0.200
     0.665    -0.661     0.200
     0.667     0.944     0.200
     0.675    -0.465     0.200
     0.736    -0.659     0.200
     0.714     0.513     0.200
     0.794     0.522     0.200
     0.796    -0.358     0.200
     0.816    -0.279     0.200
     0.834    -0.501     0.200
     0.868    -0.715     0.200
     0.896    -0.644     0.200
     0.855    -0.261     0.200
     0.927    -0.896     0.200
     0.943    -0.620     0.200
     0.923    -0.097     0.200
     0.973    -0.551     0.200
     0.946    -0.634     0.200
     0.972     0.223     0.200
     0.090     0.306     0.200
     0.114     0.547     0.200
     0.120     0.481     0.200
     0.190     0.486     0.200
     0.194     0.568     0.200
     0.242     0.618     0.200
     0.245     0.205     0.200
     0.334     1.020     0.200
     0.357     0.563     0.200
     0.461     0.032     0.200
     0.494    -0.348     0.200
     0.521    -0.953     0.200
     0.525     0.114     0.200
     0.541    -0.227     0.200
     0.539    -0.489     0.200
     0.545    -0.133     0.200
     0.581    -0.407     0.200
     0.634    -0.378     0.200
     0.674    -0.590     0.200
     0.670    -0.797     0.200
     0.682    -0.387     0.200
     0.730    -0.512     0.200
     0.723     0.391     0.200
     0.799     0.069     0.200
     0.805    -0.318     0.200
     0.841    -0.750     0.200
     0.865    -0.516     0.200
     0.865    -0.209     0.200
     0.889    -0.437     0.200
     0.923    -0.839     0.200
     0.934    -0.369     0.200
     0.932    -0.448     0.200
     0.956    -0.593     0.200
     0.995    -0.971     0.200
     0.068     0.308     0.200
     0.142    -0.100     0.200
     0.148     0.445     0.200
     0.187     0.530     0.200
     0.207     0.280     0.200
     0.207     0.208     0.200
     0.249    -0.179     0.200
     0.331     0.189     0.200
     0.326     1.291     0.200
     0.337    -0.455     0.200
     0.332     0.436     0.200
     0.333     0.491     0.200
     0.340     0.463     0.200
     0.371     0.373     0.200
     0.364    -0.294     0.200
     0.379     0.129     0.200
     0.353     0.400     0.200
     0.375    -0.169     0.200
     0.464     0.630     0.200
     0.432    -0.558     0.200
     0.443    -0.415     0.200
     0.478     0.347     0.200
     0.491    -0.074     0.200
     0.470    -0.094     0.200
     0.477    -0.400     0.200
     0.480     0.777     0.200
     0.516    -0.460     0.200
     0.510     0.512     0.200
     0.512     0.331     0.200
     0.530     0.148     0.200
     0.514     0.188     0.200
     0.515     0.351     0.200
     0.530     0.050     0.200
     0.544    -0.313     0.200
     0.600     0.350     0.200
     0.593    -0.139     0.200
     0.587    -0.906     0.200
     0.602     0.672     0.200
     0.080    -0.909     0.200
     0.135    -0.589     0.200
     0.133    -0.078     0.200
     0.188    -0.160     0.200
     0.198    -0.124     0.200
     0.200    -0.272     0.200
     0.237    -0.450     0.200
     0.346    -0.397     0.200
     0.328     0.937     0.200
     0.325     0.157     0.200
     0.325     0.115     0.200
     0.332     0.281     0.200
     0.345     0.107     0.200
     0.368     0.134     0.200
     0.352    -0.379     0.200
     0.373    -0.068     0.200
     0.365    -0.111     0.200
     0.445     0.605     0.200
     0.451    -0.550     0.200
     0.419    -0.466     0.200
     0.477     0.320     0.200
     0.462     0.553     0.200
     0.506    -0.302     0.200
     0.477     0.353     0.200
     0.464    -0.169     0.200
     0.529    -0.478     0.200
     0.522     0.822     0.200
     0.614     1.002     0.200
     0.575    -0.294     0.200
     0.661     0.854     0.200
     0.637     0.322     0.200
     0.695    -0.324     0.200
     0.714     0.288     0.200
     0.708     0.835     0.200
     0.705    -0.575     0.200
     0.772    -0.132     0.200
     0.788    -0.342     0.200
     0.755     0.935     0.200
     0.848    -0.429     0.200
     0.946     1.367     0.200
     0.081     0.098     0.200
     0.141     0.689     0.200
     0.146    -0.316     0.200
     0.200     0.234     0.200
     0.213     0.158     0.200
     0.193     0.487     0.200
     0.251    -0.146     0.200
     0.339     0.917     0.200
     0.341    -0.054     0.200
     0.341    -0.596     0.200
     0.382     0.255     0.200
     0.366    -0.250     0.200
     0.388    -0.274     0.200
     0.380    -0.270     0.200
     0.318     0.531     0.200
     0.318     0.726     0.200
     0.325     0.758     0.200
     0.339     0.641     0.200
     0.452     0.598     0.200
     0.433    -0.498     0.200
     0.477     0.349     0.200
     0.490    -0.075     0.200
     0.436    -0.221     0.200
     0.478    -0.354     0.200
     0.499    -0.293     0.200
     0.536     0.402     0.200
     0.516    -0.384     0.200
     0.516     0.470     0.200
     0.589    -0.593     0.200
     0.612     0.534     0.200
     0.682     0.292     0.200
     0.697     0.869     0.200
     0.647     0.766     0.200
     0.716    -0.322     0.200
     0.684    -0.682     0.200
     0.717    -0.848     0.200
     0.697     0.746     0.200
     0.778     1.243     0.200
     0.776    -0.214     0.200
     0.859     0.044     0.200
     0.081     0.376     0.200
     0.148    -0.493     0.200
     0.197     0.209     0.200
     0.209     0.203     0.200
     0.248    -0.084     0.200
     0.342    -0.060     0.200
     0.344    -0.597     0.200
     0.319     0.589     0.200
     0.320     0.695     0.200
     0.337     1.086     0.200
     0.327     0.680     0.200
     0.340     0.578     0.200
     0.363     0.084     0.200
     0.363    -0.207     0.200
     0.378     0.324     0.200
     0.376    -0.180     0.200
     0.384     0.014     0.200
     0.440    -0.281     0.200
     0.430    -0.459     0.200
     0.477     0.390     0.200
     0.469     0.948     0.200
     0.473     0.644     0.200
     0.501    -0.388     0.200
     0.486     0.242     0.200
     0.474    -0.248     0.200
     0.519    -0.424     0.200
     0.533     0.369     0.200
     0.585    -0.695     0.200
     0.615     0.634     0.200
     0.629    -0.378     0.200
     0.693     0.898     0.200
     0.781     0.641     0.200
     0.793     0.380     0.200
     0.875     1.362     0.200
     0.042     0.061     0.200
     0.082     0.260     0.200
     0.089     0.210     0.200
     0.090     0.033     0.200
     0.113    -0.093     0.200
     0.135     0.385     0.200
     0.164    -0.019     0.200
     0.169     0.351     0.200
     0.210     0.337     0.200
     0.250     0.385     0.200
     0.260    -0.352     0.200
     0.261     0.227     0.200
     0.314    -0.376     0.200
     0.312     0.267     0.200
     0.312     1.027     0.200
     0.321     0.936     0.200
     0.341    -0.416     0.200
     0.359    -0.379     0.200
     0.359    -0.688     0.200
     0.354     0.047     0.200
     0.387    -0.117     0.200
     0.406    -0.194     0.200
     0.437    -0.338     0.200
     0.543    -0.255     0.200
     0.580     0.135     0.200
     0.587    -1.259     0.200
     0.597    -0.968     0.200
     0.595    -0.010     0.200
     0.635    -0.365     0.200
     0.643     0.273     0.200
     0.648    -0.628     0.200
     0.111    -0.395     0.200
     0.186    -0.408     0.200
     0.203    -0.238     0.200
     0.209    -0.480     0.200
     0.242    -0.523     0.200
     0.253    -0.034     0.200
     0.306    -0.313     0.200
     0.371    -0.179     0.200
     0.384     0.006     0.200
     0.415    -0.101     0.200
     0.384     0.252     0.200
     0.441    -0.141     0.200
     0.473    -0.125     0.200
     0.484     0.441     0.200
     0.554     0.283     0.200
     0.574     0.741     0.200
     0.649     0.141     0.200
     0.650     1.028     0.200
     0.672     0.003     0.200
     0.677    -0.187     0.200
     0.681     0.166     0.200
     0.722     0.068     0.200
     0.746    -0.183     0.200
     0.764     0.270     0.200
     0.803    -0.562     0.200
     0.798     0.353     0.200
     0.839     0.298     0.200
     0.864    -0.486     0.200
     0.887    -0.508     0.200
     0.869    -0.176     0.200
     0.888    -0.418     0.200
     0.873     0.415     0.200
     0.888     0.000     0.200
     0.887     0.526     0.200
     0.902    -0.213     0.200
     0.911     0.687     0.200
     0.948    -0.021     0.200
     0.952    -0.267     0.200
     0.948    -0.329     0.200
     0.943     0.851     0.200
     0.972    -0.422     0.200
     0.955     0.048     0.200
     0.962     0.201     0.200
     0.992    -0.390     0.200
     0.030     0.091     0.200
     0.115    -0.675     0.200
     0.183     0.524     0.200
     0.180     0.329     0.200
     0.195    -0.535     0.200
     0.228    -0.417     0.200
     0.221     1.159     0.200
     0.254     0.492     0.200
     0.338    -0.218     0.200
     0.332     0.356     0.200
     0.353    -0.572     0.200
     0.415    -0.379     0.200
     0.383     1.361     0.200
     0.417    -0.697     0.200
     0.458     0.074     0.200
     0.453    -0.020     0.200
     0.450     0.607     0.200
     0.468     0.120     0.200
     0.471     0.155     0.200
     0.514    -0.479     0.200
     0.518    -0.049     0.200
     0.509     0.370     0.200
     0.545    -0.507     0.200
     0.512    -0.006     0.200
     0.544    -0.216     0.200
     0.555    -0.716     0.200
     0.566    -0.129     0.200
     0.586    -0.204     0.200
     0.569     0.070     0.200
     0.591    -0.684     0.200
     0.587    -0.531     0.200
     0.600    -0.492     0.200
     0.605    -0.589     0.200
     0.608    -0.659     0.200
     0.659    -0.222     0.200
     0.722     0.094     0.200
     0.746    -0.106     0.200
     0.768    -0.598     0.200
     0.748    -1.744     0.200
     0.752    -0.451     0.200
     0.804    -0.860     0.200
     0.783    -0.332     0.200
     0.816     0.407     0.200
     0.866    -0.259     0.200
     0.861     0.644     0.200
     0.862    -0.953     0.200
     0.845    -0.327     0.200
     0.893     0.900     0.200
     0.869     0.445     0.200
     0.883     0.102     0.200
     0.936    -1.089     0.200
     0.925     0.306     0.200
     0.942     0.703     0.200
     0.957     0.111     0.200
     0.982     0.369     0.200
     0.070     0.398     0.200
     0.213     0.091     0.200
     0.225     0.046     0.200
     0.230     0.009     0.200
     0.234    -0.129     0.200
     0.290     0.468     0.200
     0.314    -0.032     0.200
     0.322    -0.102     0.200
     0.324    -0.922     0.200
     0.330     0.092     0.200
     0.337     0.005     0.200
     0.352    -0.551     0.200
     0.370    -0.310     0.200
     0.364    -0.070     0.200
     0.416    -0.108     0.200
     0.411     0.386     0.200
     0.435    -0.520     0.200
     0.446    -0.479     0.200
     0.462     0.018     0.200
     0.459     0.219     0.200
     0.485    -0.454     0.200
     0.481     0.275     0.200
     0.515    -0.615     0.200
     0.531    -0.703     0.200
     0.524    -0.461     0.200
     0.534    -0.701     0.200
     0.535    -1.224     0.200
     0.536     0.803     0.200
     0.570    -0.304     0.200
     0.563     0.431     0.200
     0.580    -0.713     0.200
     0.570     0.028     0.200
     0.600    -0.284     0.200
     0.604    -0.605     0.200
     0.619    -0.766     0.200
     0.611     0.065     0.200
     0.658    -0.408     0.200
     0.650    -0.310     0.200
     0.659    -0.549     0.200
     0.653    -0.453     0.200
     0.654    -0.170     0.200
     0.660    -0.324     0.200
     0.664     0.291     0.200
     0.679     0.502     0.200
     0.710    -0.226     0.200
     0.706    -0.467     0.200
     0.698    -0.358     0.200
     0.749    -0.764     0.200
     0.755    -0.574     0.200
     0.771     0.132     0.200
     0.780     0.300     0.200
     0.819     0.207     0.200
     0.821    -0.628     0.200
     0.825    -0.425     0.200
     0.829    -0.150     0.200
     0.827     0.162     0.200
     0.830     0.418     0.200
     0.838     0.249     0.200
     0.856    -0.735     0.200
     0.856     0.320     0.200
     0.109    -0.532     0.200
     0.135    -0.718     0.200
     0.170    -0.139     0.200
     0.170    -0.444     0.200
     0.209    -0.345     0.200
     0.241    -0.181     0.200
     0.310     1.080     0.200
     0.344    -0.673     0.200
     0.383    -0.602     0.200
     0.406    -1.051     0.200
     0.442     0.819     0.200
     0.448    -1.111     0.200
     0.474    -0.464     0.200
     0.475    -1.062     0.200
     0.495    -0.316     0.200
     0.497    -1.130     0.200
     0.527     0.248     0.200
     0.538     0.182     0.200
     0.576     0.163     0.200
     0.588    -0.585     0.200
     0.634     0.716     0.200
     0.676     0.026     0.200
     0.662    -0.443     0.200
     0.673    -0.335     0.200
     0.706     0.204     0.200
     0.741    -0.100     0.200
     0.817     0.135     0.200
     0.827     0.306     0.200
     0.838    -0.237     0.200
     0.838     1.866     0.200
     0.859     0.821     0.200
     0.856     1.314     0.200
     0.862     0.924     0.200
     0.864    -0.844     0.200
     0.922    -0.117     0.200
     0.933    -0.133     0.200
     0.995    -0.366     0.200
     0.102    -0.445     0.200
     0.234    -0.654     0.200
     0.296    -0.215     0.200
     0.331    -0.134     0.200
     0.340    -0.715     0.200
     0.364    -0.199     0.200
     0.404    -0.156     0.200
     0.404    -0.115     0.200
     0.409    -0.109     0.200
     0.405    -0.482     0.200
     0.424    -0.384     0.200
     0.424    -0.381     0.200
     0.462    -0.422     0.200
     0.484    -0.608     0.200
     0.500    -0.214     0.200
     0.503    -0.301     0.200
     0.509    -0.409     0.200
     0.523    -0.380     0.200
     0.550     0.029     0.200
     0.576    -0.256     0.200
     0.588    -0.235     0.200
     0.658    -0.712     0.200
     0.691    -0.947     0.200
     0.688    -0.403     0.200
     0.708     0.275     0.200
     0.703    -0.471     0.200
     0.712    -0.456     0.200
     0.761    -0.400     0.200
     0.772    -0.398     0.200
     0.782     0.318     0.200
     0.841    -1.165     0.200
     0.848    -0.205     0.200
     0.860    -0.064     0.200
     0.870    -0.349     0.200
     0.907     1.696     0.200
     0.929     1.745     0.200
     0.931     1.832     0.200
     0.934     1.897     0.200
     0.942     1.692     0.200
     0.945     0.468     0.200
     0.946     1.420     0.200
     0.952     1.202     0.200
     0.967    -0.881     0.200
     0.957     1.348     0.200
     0.967    -0.799     0.200
     0.980    -0.456     0.200
     0.991    -0.045     0.200
     0.996    -1.078     0.200
     0.169     0.501     0.200
     0.233     0.256     0.200
     0.226     0.458     0.200
     0.237    -0.080     0.200
     0.242     0.220     0.200
     0.270     0.135     0.200
     0.262    -0.120     0.200
     0.310     0.342     0.200
     0.339     0.136     0.200
     0.353    -0.450     0.200
     0.397    -0.201     0.200
     0.406    -0.093     0.200
     0.413    -0.368     0.200
     0.461     0.529     0.200
     0.499    -0.495     0.200
     0.513     0.008     0.200
     0.518    -0.300     0.200
     0.537    -0.318     0.200
     0.533    -0.006     0.200
     0.576     0.151     0.200
     0.581     0.341     0.200
     0.592    -0.292     0.200
     0.607     1.405     0.200
     0.609     0.139     0.200
     0.632    -0.609     0.200
     0.646    -0.747     0.200
     0.654    -0.601     0.200
     0.671    -0.182     0.200
     0.678    -0.581     0.200
     0.678    -0.685     0.200
     0.679     0.611     0.200
     0.686    -0.543     0.200
     0.692    -0.717     0.200
     0.705    -0.554     0.200
     0.705    -0.560     0.200
     0.706    -0.572     0.200
     0.711    -0.397     0.200
     0.712     0.310     0.200
     0.727    -0.601     0.200
     0.729    -0.690     0.200
     0.735     0.060     0.200
     0.757    -0.038     0.200
     0.776    -0.468     0.200
     0.770    -0.245     0.200
     0.780    -0.761     0.200
     0.788    -0.512     0.200
     0.803    -0.463     0.200
     0.803     0.404     0.200
     0.803    -0.658     0.200
     0.800    -0.256     0.200
     0.819    -0.856     0.200
     0.819    -0.285     0.200
     0.834    -0.749     0.200
     0.855    -0.200     0.200
     0.849     0.052     0.200
     0.850    -0.415     0.200
     0.857    -0.762     0.200
     0.858     0.423     0.200
     0.859     0.319     0.200
     0.879    -0.455     0.200
     0.873     0.326     0.200
     0.879    -0.069     0.200
     0.921     0.194     0.200
     0.932     0.238     0.200
     0.937     1.192     0.200
     0.949     0.141     0.200
     0.950    -0.614     0.200
     0.965    -0.428     0.200
     0.996    -0.193     0.200
     0.076     0.347     0.200
     0.076     0.477     0.200
     0.049     0.610     0.200
     0.094     0.685     0.200
     0.177     0.913     0.200
     0.231     0.440     0.200
     0.233     0.486     0.200
     0.240     0.655     0.200
     0.240     0.945     0.200
     0.317     0.362     0.200
     0.317     1.262     0.200
     0.345     0.762     0.200
     0.363     0.326     0.200
     0.412     0.322     0.200
     0.445     0.306     0.200
     0.474    -0.067     0.200
     0.491    -0.242     0.200
     0.515    -0.648     0.200
     0.509     0.465     0.200
     0.551    -0.590     0.200
     0.544    -0.294     0.200
     0.568    -0.469     0.200
     0.568     0.051     0.200
     0.567    -0.806     0.200
     0.580    -0.804     0.200
     0.570    -0.401     0.200
     0.601    -0.824     0.200
     0.605     0.007     0.200
     0.605     0.147     0.200
     0.625    -0.419     0.200
     0.626     0.202     0.200
     0.664    -0.778     0.200
     0.664    -0.998     0.200
     0.664    -0.427     0.200
     0.671    -0.708     0.200
     0.675    -0.860     0.200
     0.660     1.088     0.200
     0.667    -0.308     0.200
     0.737    -0.638     0.200
     0.737    -0.789     0.200
     0.742    -0.738     0.200
     0.706     0.276     0.200
     0.746    -0.659     0.200
     0.750    -0.609     0.200
     0.772    -0.868     0.200
     0.784    -0.277     0.200
     0.784    -0.007     0.200
     0.793    -0.532     0.200
     0.793     0.128     0.200
     0.789    -0.127     0.200
     0.809    -0.290     0.200
     0.826    -0.411     0.200
     0.855    -0.426     0.200
     0.866    -0.797     0.200
     0.848    -0.037     0.200
     0.899    -0.722     0.200
     0.895    -0.437     0.200
     0.927    -1.020     0.200
     0.947    -0.643     0.200
     0.905     0.437     0.200
     0.906     1.331     0.200
     0.915    -0.264     0.200
     0.939    -0.409     0.200
     0.971    -0.696     0.200
     0.965     0.342     0.200
     0.981    -0.939     0.200
     0.981    -0.739     0.200
     0.996    -0.689     0.200
     1.000    -0.089     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.960     0.158     0.200
     0.983     1.395     0.200
     0.946    -0.354     0.200
     0.996     0.929     0.200
     0.956    -0.306     0.200
     0.958    -0.384     0.200
     0.941     0.010     0.200
     0.953    -0.388     0.200
     0.923    -1.115     0.200
     0.969    -0.902     0.200
     0.961    -1.015     0.200
     0.989    -1.339     0.200
     0.930     0.063     0.200
     0.935     0.378     0.200
     0.954    -0.304     0.200
     0.965    -0.129     0.200
     0.996     0.117     0.200
     0.995     0.422     0.200
     0.952     0.312     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.580    -0.682     0.200
     0.542    -0.072     0.200
     0.450    -1.099     0.200
     0.691    -0.634     0.200
     0.899     1.836     0.200
     0.615     2.060     0.200
     0.664     1.971     0.200
     0.701     2.068     0.200
     0.090     0.401     0.200
     0.093    -1.177     0.200
     0.377     0.327     0.200
     0.760     1.041     0.200
     0.670     1.198     0.200
     0.205     0.767     0.200
     0.600    -0.063     0.200
     0.733     0.198     0.200
     0.707     0.307     0.200
     0.349     1.186     0.200
     0.834    -0.798     0.200
     0.332     1.665     0.200
     0.628     0.416     0.200
     0.661     1.022     0.200
     0.572     1.292     0.200
     0.310     1.746     0.200
     0.683    -0.178     0.200
     0.335     1.509     0.200
     0.722     0.414     0.200
     0.162    -1.447     0.200
     0.627    -0.460     0.200
     0.685    -0.337     0.200
     0.704     0.546     0.200
     0.786     1.095     0.200
     0.787     0.516     0.200
     0.895     0.706     0.200
     0.570     0.299     0.200
     0.629    -0.277     0.200
     0.739    -0.305     0.200
     0.190    -0.910     0.200
     0.647     0.409     0.200
     0.731    -0.799     0.200
     0.922     1.473     0.200
     0.176    -0.644     0.200
     0.522    -0.199     0.200
     0.669     1.150     0.200
     0.834    -0.066     0.200
     0.935     0.931     0.200
     0.187    -0.182     0.200
     0.255     1.113     0.200
     0.764    -0.364     0.200
     0.780     0.621     0.200
     0.517     0.102     0.200
     0.499     0.747     0.200
     0.558     1.091     0.200
     0.732     1.732     0.200
     0.791     0.008     0.200
     0.840     2.506     0.200
     0.448    -0.203     0.200
     0.510    -0.872     0.200
     0.482    -0.184     0.200
     0.485     0.356     0.200
     0.722     1.943     0.200
     0.759     1.254     0.200
     0.418    -0.400     0.200
     0.528    -0.509     0.200
     0.514     0.071     0.200
     0.546    -0.003     0.200
     0.585    -1.048     0.200
     0.735     1.002     0.200
     0.862    -0.339     0.200
     0.518     0.730     0.200
     0.752     0.873     0.200
     0.810     1.623     0.200
     0.533     0.466     0.200
     0.806     1.628     0.200
     0.502    -0.002     0.200
     0.573    -0.625     0.200
     0.813     1.352     0.200
     0.458    -1.311     0.200
     0.488     0.487     0.200
     0.505     0.579     0.200
     0.570    -1.164     0.200
     0.721     1.305     0.200
     0.800     0.253     0.200
     0.779     1.695     0.200
     0.835     0.982     0.200
     0.469    -0.263     0.200
     0.492    -0.076     0.200
     0.583     0.012     0.200
     0.421     0.286     0.200
     0.391    -0.781     0.200
     0.501     0.403     0.200
     0.573    -0.279     0.200
     0.528     1.139     0.200
     0.766     1.186     0.200
     0.568    -0.312     0.200
     0.525     0.485     0.200
     0.842     0.026     0.200
     0.502    -0.644     0.200
     0.573    -0.815     0.200
     0.847     1.755     0.200
     0.561    -0.021     0.200
     0.771     1.211     0.200
     0.782     1.464     0.200
     0.509    -0.947     0.200
     0.538     0.283     0.200
     0.566     1.234     0.200
     0.756     1.377     0.200
     0.774     1.712     0.200
     0.840     1.823     0.200
     0.516    -0.239     0.200
     0.560    -1.237     0.200
     0.777     0.589     0.200
     0.869     1.189     0.200
     0.534     1.170     0.200
     0.550    -0.289     0.200
     0.528    -0.059     0.200
     0.766     0.472     0.200
     0.878    -1.330     0.200
     0.800     1.095     0.200
     0.513    -0.136     0.200
     0.522     0.608     0.200
     0.561     0.465     0.200
     0.567    -0.591     0.200
     0.549     0.279     0.200
     0.785     1.693     0.200
     0.839     0.550     0.200
     0.490    -1.072     0.200
     0.584     1.279     0.200
     0.859     1.183     0.200
     0.507    -0.293     0.200
     0.529     0.362     0.200
     0.820     1.402     0.200
     0.530     1.500     0.200
     0.541     1.750     0.200
     0.782    -1.109     0.200
     0.764     0.913     0.200
     0.865    -0.004     0.200
     0.392    -0.742     0.200
     0.499    -0.050     0.200
     0.575     0.699     0.200
     0.743    -0.141     0.200
     0.852     0.719     0.200
     0.849     0.455     0.200
     0.405    -0.738     0.200
     0.516    -0.391     0.200
     0.558    -0.265     0.200
     0.752     1.544     0.200
     0.833     1.362     0.200
     0.394    -0.612     0.200
     0.498    -0.150     0.200
     0.850     1.307     0.200
     0.556    -1.176     0.200
     0.518     1.252     0.200
     0.495     0.085     0.200
     0.787     0.585     0.200
     0.728    -0.351     0.200
     0.793     0.322     0.200
     0.492     0.104     0.200
     0.566     0.492     0.200
     0.724     0.791     0.200
     0.782     0.947     0.200
     0.837     1.283     0.200
     0.541    -0.007     0.200
     0.574    -0.043     0.200
     0.777    -0.366     0.200
     0.560     1.317     0.200
     0.756     0.740     0.200
     0.834     0.987     0.200
     0.425    -0.324     0.200
     0.531    -0.075     0.200
     0.544    -0.523     0.200
     0.757     0.533     0.200
     0.817     1.458     0.200
     0.854     0.354     0.200
     0.509    -1.242     0.200
     0.461     1.346     0.200
     0.272    -1.330     0.200
     0.401    -0.461     0.200
     0.456     0.302     0.200
     0.514     0.020     0.200
     0.560    -0.371     0.200
     0.561    -0.779     0.200
     0.744     1.515     0.200
     0.829     1.405     0.200
     0.836     1.233     0.200
     0.425    -1.337     0.200
     0.480    -1.182     0.200
     0.533    -0.584     0.200
     0.518     1.574     0.200
     0.548    -2.184     0.200
     0.542    -0.105     0.200
     0.581    -1.698     0.200
     0.773     0.410     0.200
     0.816     0.499     0.200
     0.253    -0.314     0.200
     0.461    -0.684     0.200
     0.502    -0.362     0.200
     0.530    -0.627     0.200
     0.534     0.093     0.200
     0.562    -0.662     0.200
     0.816     0.516     0.200
     0.196    -1.049     0.200
     0.471    -0.282     0.200
     0.472     0.348     0.200
     0.556     1.553     0.200
     0.602     0.283     0.200
     0.372    -1.052     0.200
     0.465    -0.649     0.200
     0.482    -0.095     0.200
     0.521    -0.903     0.200
     0.592     0.267     0.200
     0.845     1.914     0.200
     0.867     0.358     0.200
     0.487     0.056     0.200
     0.536     0.132     0.200
     0.523     0.066     0.200
     0.587    -0.117     0.200
     0.862     0.765     0.200
     0.431    -0.611     0.200
     0.485    -0.572     0.200
     0.537    -0.537     0.200
     0.554    -1.030     0.200
     0.538     0.402     0.200
     0.811     1.120     0.200
     0.317    -0.292     0.200
     0.472    -1.047     0.200
     0.457    -0.076     0.200
     0.521     0.016     0.200
     0.617     0.606     0.200
     0.799     1.802     0.200
     0.891     1.382     0.200
     0.316     0.365     0.200
     0.466     0.173     0.200
     0.455    -0.638     0.200
     0.506    -1.250     0.200
     0.261     0.605     0.200
     0.467     0.691     0.200
     0.533     0.891     0.200
     0.839     1.608     0.200
     0.285    -0.806     0.200
     0.585    -0.151     0.200
     0.859     1.420     0.200
     0.286    -1.376     0.200
     0.491    -0.409     0.200
     0.537     0.368     0.200
     0.583     0.353     0.200
     0.858     1.454     0.200
     0.478     0.060     0.200
     0.544     0.753     0.200
     0.597     0.901     0.200
     0.782     1.342     0.200
     0.297    -0.140     0.200
     0.371    -0.523     0.200
     0.604     1.028     0.200
     0.878     1.424     0.200
     0.054    -1.028     0.200
     0.246    -0.398     0.200
     0.424    -0.534     0.200
     0.515     0.898     0.200
     0.533     0.552     0.200
     0.542     0.547     0.200
     0.759     1.696     0.200
     0.070    -0.854     0.200
     0.366    -2.057     0.200
     0.600     1.608     0.200
     0.234     0.371     0.200
     0.548     1.137     0.200
     0.505     0.307     0.200
     0.739     1.277     0.200
     0.253     0.044     0.200
     0.400     0.337     0.200
     0.564     0.568     0.200
     0.743     0.426     0.200
     0.903    -0.041     0.200
     0.030     0.125     0.200
     0.444     0.490     0.200
     0.444     0.957     0.200
     0.488    -0.960     0.200
     0.464    -0.192     0.200
     0.518    -0.529     0.200
     0.560     1.119     0.200
     0.793     1.201     0.200
     0.155    -0.705     0.200
     0.762    -0.434     0.200
     0.819     0.298     0.200
     0.074     0.028     0.200
     0.418     1.187     0.200
     0.543     0.191     0.200
     0.440     0.361     0.200
     0.563    -0.894     0.200
     0.393    -0.317     0.200
     0.435     0.157     0.200
     0.536     1.581     0.200
     0.583     0.956     0.200
     0.583     0.106     0.200
     0.678     0.076     0.200
     0.729     0.350     0.200
     0.748     1.498     0.200
     0.815     1.234     0.200
     0.973     1.740     0.200
     0.238    -1.200     0.200
     0.363    -0.038     0.200
     0.515    -1.182     0.200
     0.599     0.955     0.200
     0.625    -0.658     0.200
     0.726     0.027     0.200
     0.772     0.805     0.200
     0.787     0.795     0.200
     0.782     0.644     0.200
     0.127    -0.964     0.200
     0.177    -1.536     0.200
     0.325     0.196     0.200
     0.351    -0.366     0.200
     0.407    -0.364     0.200
     0.075    -0.822     0.200
     0.222    -0.164     0.200
     0.304     0.864     0.200
     0.305    -0.151     0.200
     0.392    -0.527     0.200
     0.425    -0.237     0.200
     0.410     0.482     0.200
     0.448    -1.660     0.200
     0.499     0.519     0.200
     0.467     0.066     0.200
     0.696     0.071     0.200
     0.691     1.216     0.200
     0.842     1.560     0.200
     0.143    -1.893     0.200
     0.199    -1.250     0.200
     0.261    -0.546     0.200
     0.296    -0.058     0.200
     0.374    -1.202     0.200
     0.422     0.090     0.200
     0.532     0.698     0.200
     0.554     0.753     0.200
     0.562    -0.189     0.200
     0.556     0.568     0.200
     0.623     0.320     0.200
     0.623     0.019     0.200
     0.626    -0.195     0.200
     0.654     0.268     0.200
     0.803     0.018     0.200
     0.265    -0.657     0.200
     0.299    -0.145     0.200
     0.313     0.075     0.200
     0.374     0.848     0.200
     0.417     0.524     0.200
     0.534     0.639     0.200
     0.557     0.455     0.200
     0.558     0.910     0.200
     0.550     0.118     0.200
     0.616     0.377     0.200
     0.672     0.667     0.200
     0.658     0.400     0.200
     0.620    -0.356     0.200
     0.697     0.350     0.200
     0.799     0.107     0.200
     0.833     0.088     0.200
     0.045    -0.166     0.200
     0.167     0.970     0.200
     0.232     0.399     0.200
     0.244     0.673     0.200
     0.298     0.183     0.200
     0.328    -0.374     0.200
     0.394    -0.592     0.200
     0.382     0.648     0.200
     0.449    -0.532     0.200
     0.663     0.925     0.200
     0.708     1.025     0.200
     0.817     1.272     0.200
     0.921     1.274     0.200
     0.255    -0.625     0.200
     0.298     0.098     0.200
     0.420    -0.684     0.200
     0.539     0.281     0.200
     0.429     1.174     0.200
     0.454     0.715     0.200
     0.630    -0.258     0.200
     0.697     0.547     0.200
     0.742     1.283     0.200
     0.781     0.745     0.200
     0.819     0.714     0.200
     0.810     0.703     0.200
     0.875    -0.050     0.200
     0.856     1.272     0.200
     0.934     0.567     0.200
     0.218    -0.447     0.200
     0.342     0.306     0.200
     0.366     0.780     0.200
     0.362    -0.502     0.200
     0.532    -1.279     0.200
     0.604     0.410     0.200
     0.747     0.062     0.200
     0.747     1.042     0.200
     0.789     1.149     0.200
     0.780     0.086     0.200
     0.780     1.036     0.200
     0.800     1.003     0.200
     0.870     0.884     0.200
     0.980     1.362     0.200
     0.053     1.366     0.200
     0.256     1.172     0.200
     0.336     0.736     0.200
     0.314     0.624     0.200
     0.306     1.295     0.200
     0.426    -0.150     0.200
     0.476     0.202     0.200
     0.540     0.046     0.200
     0.048     0.755     0.200
     0.116    -0.677     0.200
     0.291     0.284     0.200
     0.261     1.177     0.200
     0.254     1.509     0.200
     0.370    -0.109     0.200
     0.315     0.369     0.200
     0.343     1.367     0.200
     0.317     1.542     0.200
     0.423    -0.699     0.200
     0.484    -0.501     0.200
     0.551    -0.150     0.200
     0.039     0.346     0.200
     0.120     0.113     0.200
     0.312     0.488     0.200
     0.299    -0.086     0.200
     0.256     1.124     0.200
     0.307     0.641     0.200
     0.375    -1.234     0.200
     0.318     1.061     0.200
     0.412    -0.814     0.200
     0.496    -0.459     0.200
     0.564    -0.056     0.200
     0.063     1.077     0.200
     0.173     0.879     0.200
     0.216     0.876     0.200
     0.228     0.251     0.200
     0.291    -0.208     0.200
     0.321     0.298     0.200
     0.429    -0.447     0.200
     0.394     1.047     0.200
     0.451     0.298     0.200
     0.504     0.606     0.200
     0.513     0.076     0.200
     0.766     0.380     0.200
     0.180     0.085     0.200
     0.289    -0.691     0.200
     0.421     0.412     0.200
     0.507    -0.509     0.200
     0.587     0.720     0.200
     0.990    -0.157     0.200
     0.176    -0.565     0.200
     0.186    -0.058     0.200
     0.181     0.005     0.200
     0.285    -0.721     0.200
     0.300    -0.486     0.200
     0.307     0.084     0.200
     0.385    -0.577     0.200
     0.463     0.344     0.200
     0.521    -0.036     0.200
     0.151    -0.682     0.200
     0.196    -0.208     0.200
     0.206    -0.365     0.200
     0.284    -0.589     0.200
     0.375     0.061     0.200
     0.385     0.330     0.200
     0.608    -0.396     0.200
     0.144    -1.076     0.200
     0.201    -1.607     0.200
     0.213    -0.632     0.200
     0.265    -0.253     0.200
     0.337     0.424     0.200
     0.371    -0.427     0.200
     0.387     0.310     0.200
     0.376    -0.244     0.200
     0.679     1.160     0.200
     0.046    -1.241     0.200
     0.099    -1.201     0.200
     0.192    -0.607     0.200
     0.192    -0.197     0.200
     0.174    -0.139     0.200
     0.174     0.001     0.200
     0.204    -0.090     0.200
     0.204     0.209     0.200
     0.285     0.275     0.200
     0.336    -0.235     0.200
     0.336    -1.245     0.200
     0.440     0.481     0.200
     0.780    -0.268     0.200
     0.043    -0.816     0.200
     0.186    -0.178     0.200
     0.177    -0.214     0.200
     0.198     0.684     0.200
     0.318    -0.225     0.200
     0.293     0.212     0.200
     0.139     0.154     0.200
     0.143    -0.265     0.200
     0.230     0.664     0.200
     0.257     0.679     0.200
     0.334     0.354     0.200
     0.345     0.126     0.200
     0.371     0.094     0.200
     0.401    -0.112     0.200
     0.445     0.135     0.200
     0.461     0.517     0.200
     0.480    -0.182     0.200
     0.481     0.559     0.200
     0.528     0.321     0.200
     0.610     1.206     0.200
     0.729     0.590     0.200
     0.070     0.184     0.200
     0.117     0.854     0.200
     0.324    -0.400     0.200
     0.351    -0.320     0.200
     0.365    -0.569     0.200
     0.475    -0.158     0.200
     0.495    -0.078     0.200
     0.541    -0.566     0.200
     0.613    -0.064     0.200
     0.681     0.983     0.200
     0.704     0.416     0.200
     0.182    -1.124     0.200
     0.290    -0.369     0.200
     0.356    -0.012     0.200
     0.375    -0.139     0.200
     0.423     0.374     0.200
     0.418     0.380     0.200
     0.603     0.318     0.200
     0.612     0.906     0.200
     0.631     1.460     0.200
     0.680     0.728     0.200
     0.701     1.683     0.200
     0.700     1.455     0.200
     0.743     1.615     0.200
     0.848     1.392     0.200
     0.903     0.537     0.200
     0.912     0.048     0.200
     0.290     0.051     0.200
     0.359     0.901     0.200
     0.431     0.261     0.200
     0.440     0.007     0.200
     0.419     0.932     0.200
     0.605     0.111     0.200
     0.620    -0.319     0.200
     0.623     0.171     0.200
     0.648     0.080     0.200
     0.695     0.285     0.200
     0.714     0.792     0.200
     0.761     0.372     0.200
     0.865     0.905     0.200
     0.906     0.941     0.200
     0.920     0.581     0.200
     0.953     1.069     0.200
     0.958     1.260     0.200
     0.061     0.549     0.200
     0.186    -0.224     0.200
     0.241    -0.418     0.200
     0.223     0.491     0.200
     0.301     0.191     0.200
     0.314    -1.028     0.200
     0.381     0.048     0.200
     0.423    -0.014     0.200
     0.420     0.174     0.200
     0.476    -0.199     0.200
     0.514    -0.764     0.200
     0.524     0.177     0.200
     0.569     0.216     0.200
     0.604    -0.086     0.200
     0.658    -0.234     0.200
     0.726     0.118     0.200
     0.719     1.513     0.200
     0.728     1.274     0.200
     0.039    -0.050     0.200
     0.194     0.223     0.200
     0.239     1.533     0.200
     0.250     0.138     0.200
     0.311    -0.082     0.200
     0.332    -1.075     0.200
     0.338    -0.588     0.200
     0.355    -0.253     0.200
     0.404    -0.425     0.200
     0.399     1.216     0.200
     0.421     0.875     0.200
     0.480     0.600     0.200
     0.510    -1.497     0.200
     0.614    -0.231     0.200
     0.724     0.814     0.200
     0.852     1.101     0.200
     0.029    -1.982     0.200
     0.170    -1.105     0.200
     0.222    -0.307     0.200
     0.249    -0.019     0.200
     0.295    -0.435     0.200
     0.304    -0.166     0.200
     0.338    -0.038     0.200
     0.333    -0.242     0.200
     0.390    -0.141     0.200
     0.427    -0.029     0.200
     0.453    -0.629     0.200
     0.616    -0.181     0.200
     0.733     0.663     0.200
     0.878     1.060     0.200
     0.990     0.651     0.200
     0.031    -0.730     0.200
     0.244    -0.011     0.200
     0.236     1.155     0.200
     0.303     0.255     0.200
     0.324     0.146     0.200
     0.355    -0.377     0.200
     0.342     0.172     0.200
     0.406     0.541     0.200
     0.609     0.375     0.200
     0.044     0.175     0.200
     0.192    -0.701     0.200
     0.251    -0.830     0.200
     0.245     1.516     0.200
     0.316     0.059     0.200
     0.334    -0.069     0.200
     0.397     1.202     0.200
     0.410    -0.567     0.200
     0.621    -0.634     0.200
     0.032    -0.535     0.200
     0.196    -0.471     0.200
     0.233     0.967     0.200
     0.248    -0.219     0.200
     0.303    -0.543     0.200
     0.327    -0.247     0.200
     0.345    -0.129     0.200
     0.359    -0.212     0.200
     0.396    -0.979     0.200
     0.403     0.536     0.200
     0.607     0.151     0.200
     0.857     0.904     0.200
     0.043     0.273     0.200
     0.169     0.529     0.200
     0.205     1.060     0.200
     0.246     0.229     0.200
     0.237     0.727     0.200
     0.314    -0.145     0.200
     0.381     0.275     0.200
     0.453    -0.332     0.200
     0.454     0.176     0.200
     0.528    -0.559     0.200
     0.535    -0.255     0.200
     0.522    -0.279     0.200
     0.520    -0.607     0.200
     0.520     0.106     0.200
     0.557     0.349     0.200
     0.624    -0.776     0.200
     0.633    -0.344     0.200
     0.668    -0.369     0.200
     0.669     0.129     0.200
     0.663     0.172     0.200
     0.681     0.254     0.200
     0.709     0.965     0.200
     0.786    -0.621     0.200
     0.889     0.372     0.200
     0.944    -0.196     0.200
     0.033    -1.128     0.200
     0.151    -0.179     0.200
     0.193    -0.763     0.200
     0.236     1.105     0.200
     0.246    -0.110     0.200
     0.305    -0.371     0.200
     0.327    -0.256     0.200
     0.341     0.343     0.200
     0.355    -0.094     0.200
     0.404     0.835     0.200
     0.682     1.392     0.200
     0.135    -0.689     0.200
     0.257     0.008     0.200
     0.249    -0.023     0.200
     0.194    -0.195     0.200
     0.330     0.561     0.200
     0.416     0.161     0.200
     0.501    -0.486     0.200
     0.463    -0.530     0.200
     0.561     0.349     0.200
     0.557     0.733     0.200
     0.487     0.301     0.200
     0.589     0.418     0.200
     0.568     0.208     0.200
     0.637     0.858     0.200
     0.771     0.159     0.200
     0.743     1.208     0.200
     0.764     1.435     0.200
     0.887    -0.068     0.200
     0.065    -0.644     0.200
     0.173    -0.035     0.200
     0.176    -0.285     0.200
     0.234    -0.347     0.200
     0.236    -0.187     0.200
     0.304     0.059     0.200
     0.303     0.090     0.200
     0.368     0.672     0.200
     0.372    -0.469     0.200
     0.455     0.601     0.200
     0.474    -0.114     0.200
     0.489    -0.964     0.200
     0.501     0.326     0.200
     0.574    -0.145     0.200
     0.591     0.170     0.200
     0.620    -0.229     0.200
     0.664     0.415     0.200
     0.721     0.982     0.200
     0.061     0.057     0.200
     0.164     0.102     0.200
     0.184     0.018     0.200
     0.227    -0.117     0.200
     0.238    -0.337     0.200
     0.300     0.418     0.200
     0.311    -0.064     0.200
     0.373    -0.195     0.200
     0.377    -0.418     0.200
     0.419     0.103     0.200
     0.474     0.094     0.200
     0.464     0.070     0.200
     0.486    -0.608     0.200
     0.527    -0.420     0.200
     0.510    -0.626     0.200
     0.569    -0.060     0.200
     0.575     0.409     0.200
     0.601    -0.326     0.200
     0.618     0.066     0.200
     0.712    -0.347     0.200
     0.958     0.894     0.200
     0.921     1.393     0.200
     0.107    -1.156     0.200
     0.196    -1.183     0.200
     0.182    -0.612     0.200
     0.325     0.472     0.200
     0.503     0.650     0.200
     0.669     0.185     0.200
     0.920    -0.153     0.200
     0.861    -0.288     0.200
     0.571     0.186     0.200
     0.761    -0.443     0.200
     0.082    -1.084     0.200
     0.140    -0.114     0.200
     0.207    -0.373     0.200
     0.218    -0.176     0.200
     0.306    -0.643     0.200
     0.301     0.613     0.200
     0.344    -0.467     0.200
     0.396     0.100     0.200
     0.337     0.061     0.200
     0.347     0.121     0.200
     0.420     0.090     0.200
     0.365     0.890     0.200
     0.402     0.188     0.200
     0.415     0.638     0.200
     0.476     0.547     0.200
     0.514     1.018     0.200
     0.689     0.716     0.200
     0.186     0.586     0.200
     0.231     1.147     0.200
     0.251     0.808     0.200
     0.454    -0.318     0.200
     0.484    -0.183     0.200
     0.534     0.280     0.200
     0.535     0.336     0.200
     0.678     0.999     0.200
     0.722    -0.424     0.200
     0.913    -0.189     0.200
     0.175     0.106     0.200
     0.206     0.659     0.200
     0.236     0.530     0.200
     0.260     0.138     0.200
     0.360     0.708     0.200
     0.468    -0.041     0.200
     0.489    -0.202     0.200
     0.528    -0.287     0.200
     0.538     0.480     0.200
     0.533    -0.679     0.200
     0.544    -0.519     0.200
     0.566     0.220     0.200
     0.583    -0.156     0.200
     0.631     0.235     0.200
     0.681    -0.261     0.200
     0.681     0.599     0.200
     0.690    -0.113     0.200
     0.717    -0.184     0.200
     0.811     0.556     0.200
     0.912     0.189     0.200
     0.189    -0.275     0.200
     0.227     0.669     0.200
     0.185     0.118     0.200
     0.249    -0.534     0.200
     0.341     1.086     0.200
     0.324     0.737     0.200
     0.447     0.424     0.200
     0.535     1.162     0.200
     0.531     0.640     0.200
     0.524     0.036     0.200
     0.531     0.074     0.200
     0.565     0.692     0.200
     0.610     0.740     0.200
     0.721    -0.020     0.200
     0.721    -0.239     0.200
     0.680    -0.135     0.200
     0.680     0.685     0.200
     0.827     1.425     0.200
     0.171    -0.225     0.200
     0.214     0.170     0.200
     0.200     0.270     0.200
     0.269     0.012     0.200
     0.341     0.138     0.200
     0.467    -0.265     0.200
     0.453     0.427     0.200
     0.525     0.019     0.200
     0.562    -0.084     0.200
     0.549     0.361     0.200
     0.619     0.654     0.200
     0.205    -1.008     0.200
     0.178     0.271     0.200
     0.245     0.792     0.200
     0.231    -0.181     0.200
     0.318     1.104     0.200
     0.349     0.605     0.200
     0.449     0.531     0.200
     0.495    -0.095     0.200
     0.549     0.542     0.200
     0.574     0.129     0.200
     0.660     0.188     0.200
     0.740     0.438     0.200
     0.179     1.007     0.200
     0.249     0.311     0.200
     0.353     0.517     0.200
     0.320     1.368     0.200
     0.207     1.184     0.200
     0.229     0.621     0.200
     0.451    -0.114     0.200
     0.500    -0.389     0.200
     0.533    -0.143     0.200
     0.509    -0.117     0.200
     0.557    -0.085     0.200
     0.508    -1.280     0.200
     0.190     0.294     0.200
     0.236     0.059     0.200
     0.251     0.463     0.200
     0.331     1.881     0.200
     0.361     1.062     0.200
     0.462     0.231     0.200
     0.503    -0.350     0.200
     0.510    -0.628     0.200
     0.552    -0.202     0.200
     0.555     0.272     0.200
     0.659     0.101     0.200
     0.740    -0.091     0.200
     0.788     1.238     0.200
     0.859     0.789     0.200
     0.875    -0.227     0.200
     0.933     0.015     0.200
     0.089     0.276     0.200
     0.128     0.135     0.200
     0.228    -0.261     0.200
     0.270    -0.083     0.200
     0.368     1.149     0.200
     0.383    -0.247     0.200
     0.492    -0.258     0.200
     0.524     0.352     0.200
     0.550    -0.084     0.200
     0.533    -0.267     0.200
     0.655    -0.587     0.200
     0.680     0.138     0.200
     0.713    -0.085     0.200
     0.810     0.266     0.200
     0.837     0.295     0.200
     0.910     0.386     0.200
     0.972     0.256     0.200
     0.966     0.165     0.200
     0.990    -0.115     0.200
     0.089     1.190     0.200
     0.113     1.801     0.200
     0.126     1.527     0.200
     0.199     0.753     0.200
     0.183     0.973     0.200
     0.253     0.749     0.200
     0.339     0.649     0.200
     0.358    -0.331     0.200
     0.464     0.274     0.200
     0.491    -0.338     0.200
     0.541    -0.731     0.200
     0.541     0.014     0.200
     0.534    -0.212     0.200
     0.527    -1.498     0.200
     0.581    -0.858     0.200
     0.685    -0.419     0.200
     0.723    -1.193     0.200
     0.860    -0.336     0.200
     0.871     0.577     0.200
     0.962     0.806     0.200
     0.988    -0.047     0.200
     0.087    -0.130     0.200
     0.120     0.220     0.200
     0.117     0.163     0.200
     0.199    -0.637     0.200
     0.184     0.593     0.200
     0.243     0.239     0.200
     0.237     0.059     0.200
     0.324     0.491     0.200
     0.453     0.312     0.200
     0.494    -0.264     0.200
     0.515    -0.265     0.200
     0.548    -0.571     0.200
     0.516     0.114     0.200
     0.547    -0.466     0.200
     0.675    -0.194     0.200
     0.665    -0.222     0.200
     0.675     0.190     0.200
     0.736    -0.823     0.200
     0.714     0.994     0.200
     0.794     0.960     0.200
     0.796     0.772     0.200
     0.859     1.105     0.200
     0.868    -0.281     0.200
     0.896    -0.184     0.200
     0.855     0.761     0.200
     0.927    -0.275     0.200
     0.943     0.510     0.200
     0.973    -0.487     0.200
     0.946     0.990     0.200
     0.090     0.695     0.200
     0.114     1.207     0.200
     0.120     0.989     0.200
     0.190     0.197     0.200
     0.194     0.169     0.200
     0.242     0.820     0.200
     0.245     0.465     0.200
     0.357     1.393     0.200
     0.461    -0.205     0.200
     0.494    -0.304     0.200
     0.521    -1.307     0.200
     0.541    -0.167     0.200
     0.545     0.271     0.200
     0.068     1.010     0.200
     0.142     0.076     0.200
     0.134     0.851     0.200
     0.148     1.126     0.200
     0.187     0.800     0.200
     0.207     0.743     0.200
     0.249     0.134     0.200
     0.331     0.307     0.200
     0.337    -0.015     0.200
     0.332     0.302     0.200
     0.333     0.934     0.200
     0.371     0.800     0.200
     0.364    -0.518     0.200
     0.379     0.066     0.200
     0.353     0.755     0.200
     0.375    -0.335     0.200
     0.464    -0.261     0.200
     0.432    -0.952     0.200
     0.443    -0.794     0.200
     0.478    -0.961     0.200
     0.491    -0.472     0.200
     0.477    -0.072     0.200
     0.516    -0.244     0.200
     0.600     0.369     0.200
     0.080    -1.373     0.200
     0.135    -0.503     0.200
     0.133    -0.471     0.200
     0.188    -1.109     0.200
     0.198    -0.462     0.200
     0.346    -0.526     0.200
     0.351    -0.278     0.200
     0.325     0.523     0.200
     0.325     0.702     0.200
     0.332     0.506     0.200
     0.345     0.770     0.200
     0.368    -0.049     0.200
     0.352    -0.283     0.200
     0.373     0.296     0.200
     0.365     0.068     0.200
     0.451    -0.354     0.200
     0.419    -0.537     0.200
     0.462     0.855     0.200
     0.529    -0.383     0.200
     0.081     0.359     0.200
     0.141     0.797     0.200
     0.200     0.075     0.200
     0.122     1.242     0.200
     0.213     0.023     0.200
     0.251     0.196     0.200
     0.341    -0.510     0.200
     0.366    -0.432     0.200
     0.388    -0.254     0.200
     0.380    -0.462     0.200
     0.318     0.820     0.200
     0.318     0.764     0.200
     0.325     0.503     0.200
     0.339     0.686     0.200
     0.433    -0.932     0.200
     0.436    -0.648     0.200
     0.478    -1.042     0.200
     0.081     1.151     0.200
     0.125     0.714     0.200
     0.148    -0.013     0.200
     0.197     0.332     0.200
     0.209     0.904     0.200
     0.248     0.067     0.200
     0.302     0.486     0.200
     0.344    -0.801     0.200
     0.319     1.819     0.200
     0.320     0.698     0.200
     0.327     1.249     0.200
     0.363     0.853     0.200
     0.363     0.163     0.200
     0.378     0.904     0.200
     0.376     0.304     0.200
     0.384     0.445     0.200
     0.440    -0.276     0.200
     0.430    -0.702     0.200
     0.474     1.140     0.200
     0.042     0.417     0.200
     0.082     0.689     0.200
     0.090     0.257     0.200
     0.095     0.473     0.200
     0.113    -0.144     0.200
     0.135     0.481     0.200
     0.169     1.089     0.200
     0.210     1.247     0.200
     0.250     1.409     0.200
     0.261     0.124     0.200
     0.314    -0.060     0.200
     0.312     1.322     0.200
     0.341    -0.481     0.200
     0.387     0.213     0.200
     0.470    -0.076     0.200
     0.111    -0.750     0.200
     0.156    -0.794     0.200
     0.186    -0.591     0.200
     0.203    -0.327     0.200
     0.209    -0.541     0.200
     0.242    -1.002     0.200
     0.253    -0.740     0.200
     0.253    -0.309     0.200
     0.384     0.297     0.200
     0.441    -0.689     0.200
     0.574     1.284     0.200
     0.677    -0.150     0.200
     0.746     0.283     0.200
     0.749     1.455     0.200
     0.764     0.848     0.200
     0.030     0.143     0.200
     0.115    -1.052     0.200
     0.183     0.798     0.200
     0.180     0.039     0.200
     0.195     0.167     0.200
     0.228    -0.448     0.200
     0.332     0.787     0.200
     0.353     0.343     0.200
     0.514    -0.362     0.200
     0.512     0.728     0.200
     0.070     0.976     0.200
     0.213     0.388     0.200
     0.225    -0.281     0.200
     0.230     0.193     0.200
     0.234    -0.093     0.200
     0.290     0.761     0.200
     0.314     0.482     0.200
     0.322     0.378     0.200
     0.324    -0.654     0.200
     0.330     0.667     0.200
     0.337     0.621     0.200
     0.352    -0.850     0.200
     0.370    -0.244     0.200
     0.364     0.164     0.200
     0.416     0.748     0.200
     0.411     1.435     0.200
     0.435    -0.676     0.200
     0.446     0.217     0.200
     0.462    -0.121     0.200
     0.459     0.952     0.200
     0.485    -0.193     0.200
     0.515    -0.614     0.200
     0.531     0.490     0.200
     0.524    -0.388     0.200
     0.534    -0.621     0.200
     0.535    -1.318     0.200
     0.570     0.092     0.200
     0.563     1.568     0.200
     0.580    -0.738     0.200
     0.570     1.211     0.200
     0.600     0.629     0.200
     0.611     1.130     0.200
     0.658    -0.007     0.200
     0.650     0.839     0.200
     0.653     0.063     0.200
     0.654     1.157     0.200
     0.679     0.807     0.200
     0.710     1.447     0.200
     0.706     0.770     0.200
     0.698     0.583     0.200
     0.771     0.805     0.200
     0.819     1.259     0.200
     0.821    -0.373     0.200
     0.825     1.238     0.200
     0.829     1.409     0.200
     0.135    -0.635     0.200
     0.170    -0.019     0.200
     0.170    -0.800     0.200
     0.209    -0.040     0.200
     0.241     0.231     0.200
     0.344     0.123     0.200
     0.383    -0.480     0.200
     0.406    -0.912     0.200
     0.442     0.200     0.200
     0.474     0.438     0.200
     0.102    -0.370     0.200
     0.234    -1.145     0.200
     0.296     0.161     0.200
     0.315    -0.538     0.200
     0.331    -0.368     0.200
     0.340    -0.672     0.200
     0.364    -0.176     0.200
     0.404     0.654     0.200
     0.404     0.273     0.200
     0.409     0.430     0.200
     0.405    -0.326     0.200
     0.424     0.093     0.200
     0.424     0.188     0.200
     0.462     0.105     0.200
     0.484    -0.392     0.200
     0.500    -0.667     0.200
     0.503     0.236     0.200
     0.509    -0.002     0.200
     0.523     0.493     0.200
     0.588     0.478     0.200
     0.658    -0.110     0.200
     0.691    -0.271     0.200
     0.169     1.084     0.200
     0.233     1.220     0.200
     0.226     1.494     0.200
     0.237     0.530     0.200
     0.242     0.864     0.200
     0.270     0.603     0.200
     0.262    -0.330     0.200
     0.310     0.997     0.200
     0.339     0.517     0.200
     0.353    -0.692     0.200
     0.397     0.451     0.200
     0.406     0.489     0.200
     0.413    -0.285     0.200
     0.461     1.032     0.200
     0.513     0.804     0.200
     0.518    -0.066     0.200
     0.537     0.522     0.200
     0.533     0.918     0.200
     0.632    -0.147     0.200
     0.646    -0.555     0.200
     0.654    -0.206     0.200
     0.678    -0.017     0.200
     0.705     0.593     0.200
     0.705     0.481     0.200
     0.706     0.151     0.200
     0.803     0.509     0.200
     0.803     1.899     0.200
     0.076     0.753     0.200
     0.049     1.540     0.200
     0.094     1.362     0.200
     0.094     1.582     0.200
     0.177     1.319     0.200
     0.177     1.089     0.200
     0.231     0.862     0.200
     0.231     0.232     0.200
     0.233     1.274     0.200
     0.240     0.749     0.200
     0.317     1.832     0.200
     0.317     0.672     0.200
     0.317     0.832     0.200
     0.345     1.335     0.200
     0.363    -0.563     0.200
     0.363    -0.953     0.200
     0.412     0.186     0.200
     0.445     0.561     0.200
     0.474     0.133     0.200
     0.491    -0.704     0.200
     0.515    -1.059     0.200
     0.515    -0.339     0.200
     0.509     1.266     0.200
     0.509     0.317     0.200
     0.551    -0.593     0.200
     0.544    -0.237     0.200
     0.568     0.511     0.200
     0.568    -0.929     0.200
     0.570    -0.250     0.200
     0.605     0.098     0.200
     0.626     0.866     0.200
     0.664    -0.804     0.200
     0.664    -0.344     0.200
     0.737    -0.544     0.200
     0.737    -0.704     0.200
     0.746     0.009     0.200
     0.750    -0.396     0.200
     0.793     0.493     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.930    -0.249     0.200
     0.981    -0.443     0.200
     0.922    -0.584     0.200
     0.992    -1.119     0.200
     0.851    -0.562     0.200
     0.822    -0.566     0.200
     0.886    -2.150     0.200
     0.861    -0.434     0.200
     0.904     0.223     0.200
     0.959     0.809     0.200
     0.707     0.975     0.200
     0.844    -0.094     0.200
     0.884    -0.071     0.200
     0.672    -0.815     0.200
     0.662    -0.917     0.200
     0.695    -0.230     0.200
     0.770     0.145     0.200
     0.761    -0.537     0.200
     0.764    -0.745     0.200
     0.840     0.932     0.200
     0.649    -1.778     0.200
     0.772    -0.551     0.200
     0.755    -0.842     0.200
     0.758    -0.729     0.200
     0.844     0.896     0.200
     0.925     0.951     0.200
     0.941     0.717     0.200
     0.953    -0.061     0.200
     0.834    -0.993     0.200
     0.944    -0.403     0.200
     0.939    -0.357     0.200
     0.947    -0.477     0.200
     0.993    -0.537     0.200
     0.702    -1.557     0.200
     0.785    -1.182     0.200
     0.914     0.136     0.200
     0.933     0.537     0.200
     0.922     0.409     0.200
     0.927    -0.804     0.200
     0.744    -0.829     0.200
     0.765    -0.688     0.200
     0.858     0.502     0.200
     0.903     1.577     0.200
     0.847     0.488     0.200
     0.965     0.954     0.200
     0.952     0.527     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.040
 0.60   -0.040
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 0.60    0.1
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.6)
     0.050     7.000   Pg = red x; average =  -0.0 (solid red line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
EOF
gmt end
