#!/bin/bash
gmt begin larino1.84_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic larino1.84'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.471
   135.500     1.553
   136.000     1.638
   136.500     1.726
   137.000     1.818
   137.500     1.913
   138.000     2.011
   138.500     2.112
   139.000     2.218
   139.500     2.327
   140.000     2.439
   140.500     2.556
   141.000     2.677
   141.500     2.803
   142.000     2.933
   142.500     3.068
   143.000     3.208
   143.500     3.354
   144.000     3.504
   144.500     3.661
   145.000     3.823
   145.500     3.991
   146.000     4.166
   146.500     4.348
   147.000     4.536
   147.500     4.732
   148.000     4.935
   148.500     5.146
   149.000     5.365
   149.500     5.594
   150.000     5.832
   150.500     6.080
   151.000     6.339
   151.500     6.607
   152.000     6.886
   152.500     7.175
   153.000     7.474
   153.500     7.783
   154.000     8.103
   154.500     8.435
   155.000     8.777
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.677
   145.500     0.288
   146.000     1.315
   146.500     2.385
   147.000     3.490
   147.500     4.624
   148.000     5.785
   148.500     6.972
   149.000     8.182
   149.500     9.415
   150.000    10.670
   150.500    11.946
   151.000    13.243
   151.500    14.560
   152.000    15.895
   152.500    17.249
   153.000    18.620
   153.500    20.010
   154.000    21.417
   154.500    22.841
   155.000    24.283
   155.500    25.741
   156.000    27.217
   156.500    28.709
   157.000    30.218
   157.500    31.744
   158.000    33.286
   158.500    34.845
   159.000    36.420
   159.500    38.012
   160.000    39.620
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.681
   145.500     0.084
   146.000     0.776
   146.500     1.417
   147.000     2.016
   147.500     2.575
   148.000     3.099
   148.500     3.591
   149.000     4.057
   149.500     4.503
   150.000     4.933
   150.500     5.350
   151.000     5.756
   151.500     6.153
   152.000     6.542
   152.500     6.923
   153.000     7.298
   153.500     7.670
   154.000     8.038
   154.500     8.405
   155.000     8.769
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   148.991    -5.017     0.200
   141.569    -2.925     0.200
   149.506    -4.575     0.200
   149.602    -4.227     0.200
   152.402    -3.427     0.200
   152.562    -3.466     0.200
   152.592    -5.710     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   149.056     9.065     0.200
   149.504    12.266     0.200
   149.599    12.410     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   136.808     1.848     0.200
   152.399    10.811     0.200
   152.560    11.870     0.200
   152.589    11.326     0.200
   149.086     6.071     0.200
   137.102     2.148     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
