#!/bin/bash
gmt begin larino1.84_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P larino1.84'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.695
    79.000     8.521
    80.000     7.431
    81.000     6.428
    82.000     5.510
    83.000     4.676
    84.000     3.926
    85.000     3.264
    86.000     2.687
    87.000     2.188
    88.000     1.793
    89.000     1.494
    90.000     1.237
    91.000     1.011
    92.000     0.810
    93.000     0.628
    94.000     0.463
    95.000     0.318
    96.000     0.198
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    22.931     0.200     0.200
    24.261    -0.777     0.200
    22.948    -0.214     0.200
    24.284    -0.972     0.200
    20.354     0.505     0.200
    22.832    -0.692     0.200
    20.393    -0.072     0.200
    22.836     1.814     0.200
    24.477     0.562     0.200
    36.350    -0.286     0.200
    38.773     1.996     0.200
    51.241    -0.050     0.200
    22.518     4.102     0.200
    22.864     1.232     0.200
    24.160    -0.302     0.200
    26.974    -0.831     0.200
    14.850    10.374     0.200
    20.390    -0.657     0.200
    21.120    -0.356     0.200
    21.515     4.400     0.200
    22.841     1.256     0.200
    23.191     0.659     0.200
    23.380     2.572     0.200
    23.928     2.387     0.200
    23.992     2.807     0.200
    24.482     0.331     0.200
    27.197     1.739     0.200
    31.896     1.068     0.200
    33.095     0.562     0.200
    33.095     0.763     0.200
    33.088     0.623     0.200
    33.088     0.923     0.200
    36.353     1.610     0.200
    36.354     0.602     0.200
    37.121     6.268     0.200
    37.269     1.611     0.200
    38.877     0.051     0.200
    38.760     1.828     0.200
    38.932     0.986     0.200
    38.932     0.586     0.200
    41.587     1.585     0.200
    41.587     2.185     0.200
    42.370     2.191     0.200
    42.462     2.447     0.200
    42.767     1.966     0.200
    43.036     2.783     0.200
    43.036     2.984     0.200
    43.384     1.976     0.200
    43.384     2.876     0.200
    45.025     0.821     0.200
    45.025     1.321     0.200
    45.067     2.493     0.200
    45.060     2.545     0.200
    46.441     1.634     0.200
    47.915     0.341     0.200
    51.265    -0.896     0.200
    58.537    -1.027     0.200
    58.537    -0.527     0.200
    58.787     2.234     0.200
    58.787     2.734     0.200
    59.096     2.084     0.200
    59.264     1.925     0.200
    61.901     1.931     0.200
    69.481     1.022     0.200
    73.092     1.281     0.200
    73.177     0.580     0.200
    73.777     0.145     0.200
    73.777     0.645     0.200
    81.832     1.297     0.200
    81.958     0.334     0.200
    83.066    -1.642     0.200
    83.357    -0.645     0.200
    36.378     0.286     0.200
    36.379     0.479     0.200
    20.092    -0.213     0.200
    20.092     0.087     0.200
    22.793     3.441     0.200
    20.255    -1.139     0.200
    18.990    -0.127     0.200
    23.088     0.585     0.200
    73.182     0.601     0.200
    20.551     0.105     0.200
    21.156     1.568     0.200
    21.119     4.267     0.200
    22.880     0.372     0.200
    23.231     0.665     0.200
    24.521     1.383     0.200
    27.238     1.088     0.200
    31.920    -0.726     0.200
    31.920    -0.026     0.200
    36.313     0.185     0.200
    38.729     0.925     0.200
    41.593     2.983     0.200
    41.593     3.583     0.200
    42.371     2.631     0.200
    42.470     2.829     0.200
    43.041     2.195     0.200
    43.041     2.496     0.200
    43.394     3.340     0.200
    43.394     4.141     0.200
    44.827     3.853     0.200
    44.827     4.254     0.200
    45.850     3.744     0.200
    47.937     1.435     0.200
    47.937     1.835     0.200
    58.834     0.395     0.200
    59.056     1.855     0.200
    59.223     2.700     0.200
    61.860     0.707     0.200
    69.521     1.093     0.200
    73.179     1.194     0.200
    83.521     0.057     0.200
    22.976    -1.318     0.200
    18.227     3.595     0.200
    18.227     3.993     0.200
    20.644     3.200     0.200
    21.083     0.245     0.200
    21.131     4.128     0.200
    22.798    -0.095     0.200
    23.144    -1.649     0.200
    24.013     5.782     0.200
    24.440    -1.108     0.200
    33.104     3.646     0.200
    38.823     0.661     0.200
    38.788     3.157     0.200
    42.468     3.550     0.200
    42.468     3.949     0.200
    42.722     2.488     0.200
    43.387     3.107     0.200
    43.387     3.505     0.200
    46.409     3.043     0.200
    47.902    -0.604     0.200
    47.902    -0.307     0.200
    58.499    -1.616     0.200
    73.192     2.521     0.200
    83.012     0.470     0.200
    83.552     0.480     0.200
    94.901     4.873     0.200
    98.812    -0.327     0.200
    16.051     3.587     0.200
    20.550    -0.217     0.200
    20.930    -1.335     0.200
    22.877    -0.161     0.200
    23.218    -0.060     0.200
    24.519    -1.035     0.200
    31.964     0.441     0.200
    36.340    -0.411     0.200
    38.703     2.280     0.200
    42.799     3.673     0.200
    20.438     0.142     0.200
    23.256     0.921     0.200
    36.304     1.481     0.200
    17.543     1.715     0.200
    18.970    -0.515     0.200
    19.194    -0.582     0.200
    19.597     0.109     0.200
    20.521    -1.056     0.200
    21.151     2.133     0.200
    21.151     2.934     0.200
    21.663     4.228     0.200
    23.119    -0.567     0.200
    24.196     4.683     0.200
    24.196     5.484     0.200
    24.488     0.615     0.200
    24.567     2.293     0.200
    26.462     4.099     0.200
    27.110    -0.743     0.200
    30.198     1.666     0.200
    32.225    -0.101     0.200
    32.225     0.399     0.200
    33.421     0.437     0.200
    33.463     2.067     0.200
    35.270     1.216     0.200
    36.547     0.765     0.200
    36.547     0.970     0.200
    38.558     0.431     0.200
    40.584    -1.453     0.200
    40.584    -0.953     0.200
    42.125    -0.108     0.200
    42.125     0.494     0.200
    42.732     5.949     0.200
    42.925     1.380     0.200
    42.969     4.026     0.200
    42.969     4.526     0.200
    45.312     4.238     0.200
    45.312     4.839     0.200
    45.428     1.018     0.200
    45.543     2.002     0.200
    45.537     1.454     0.200
    46.595     3.109     0.200
    48.276    -0.467     0.200
    51.047     1.414     0.200
    51.829    -0.946     0.200
    58.610     0.121     0.200
    58.811     0.720     0.200
    59.135     1.473     0.200
    59.135     1.673     0.200
    59.168     0.242     0.200
    59.210    -1.047     0.200
    59.447    -0.683     0.200
    60.730     0.508     0.200
    60.947    -0.963     0.200
    60.947    -0.463     0.200
    62.177     0.728     0.200
    64.865    -1.044     0.200
    64.865    -0.243     0.200
    68.454     0.040     0.200
    69.106    -0.026     0.200
    69.133     0.506     0.200
    70.402     0.990     0.200
    71.076    -1.115     0.200
    71.076    -0.216     0.200
    72.910    -0.512     0.200
    73.568     1.000     0.200
    73.727    -0.333     0.200
    73.727    -0.536     0.200
    76.894     2.049     0.200
    81.057    -0.985     0.200
    82.603     1.474     0.200
    82.900     2.126     0.200
    83.946    -1.060     0.200
    91.374     2.099     0.200
    18.365     0.555     0.200
    21.738     4.295     0.200
    22.256    -1.244     0.200
    22.488    -0.612     0.200
    23.899    -1.128     0.200
    26.656     1.827     0.200
    37.224    -0.316     0.200
    58.380     0.013     0.200
    58.408    -0.379     0.200
    58.624    -0.287     0.200
    68.448    -0.533     0.200
    21.790    -0.356     0.200
    23.432    -1.312     0.200
    19.305    -1.424     0.200
    21.939    -2.152     0.200
    23.581    -0.404     0.200
    37.259    -0.054     0.200
    18.610    -3.255     0.200
    20.965     0.403     0.200
    36.303     2.940     0.200
    58.642     1.907     0.200
    18.409    -1.455     0.200
    18.417    -2.751     0.200
    20.632    -1.048     0.200
    28.264    -2.266     0.200
    36.528     7.258     0.200
    89.897     1.330     0.200
    20.618    -0.784     0.200
    28.251    -1.845     0.200
    36.428     3.347     0.200
    82.560     1.912     0.200
    89.899     2.508     0.200
    96.189     7.220     0.200
    18.194     0.355     0.200
    19.519     0.160     0.200
    68.766    -1.374     0.200
    70.320    -1.172     0.200
    18.170     0.404     0.200
    19.156    -0.267     0.200
    19.384    -1.264     0.200
    19.384    -2.163     0.200
    19.482    -0.532     0.200
    19.482    -0.532     0.200
    20.800    -1.176     0.200
    21.218     5.916     0.200
    21.460    -1.090     0.200
    28.376    -2.282     0.200
    31.370    -0.985     0.200
    36.518    -1.477     0.200
    39.214    -0.156     0.200
    45.328     0.728     0.200
    45.328     0.931     0.200
    46.430     1.239     0.200
    53.482     3.220     0.200
    53.559     2.955     0.200
    53.827     2.511     0.200
    54.736     1.591     0.200
    55.075     0.856     0.200
    55.886     1.864     0.200
    56.318     1.788     0.200
    58.553     2.671     0.200
    58.787     1.044     0.200
    72.903     1.308     0.200
    73.362     3.789     0.200
    89.565     2.934     0.200
    19.461    -0.349     0.200
    19.904    -0.487     0.200
    20.098    -0.205     0.200
    21.235    -0.125     0.200
    21.689     2.200     0.200
    21.893    -2.089     0.200
    31.898    -0.419     0.200
    33.092     0.321     0.200
    36.219    -0.822     0.200
    38.709    -0.732     0.200
    43.659     0.247     0.200
    45.857    -0.086     0.200
    46.187    -0.090     0.200
    46.959     0.455     0.200
    53.018    -0.983     0.200
    58.816     1.464     0.200
    59.041    -1.094     0.200
    59.067     0.222     0.200
    62.229    -0.343     0.200
    68.761    -1.902     0.200
    68.761    -2.004     0.200
    70.396    -2.308     0.200
    71.289    -0.636     0.200
    72.492     0.641     0.200
    74.861    -1.177     0.200
    80.630    -0.740     0.200
    80.675    -0.184     0.200
    82.301    -0.589     0.200
    21.345     0.820     0.200
    19.500    -0.820     0.200
    20.172    -1.560     0.200
    21.280    -0.454     0.200
    38.663     0.501     0.200
    53.032    -1.932     0.200
    68.790    -1.540     0.200
    70.326    -0.824     0.200
    82.320    -1.043     0.200
    89.484     0.605     0.200
    18.202     1.504     0.200
    18.415     0.757     0.200
    18.415     1.359     0.200
    18.483     2.407     0.200
    19.154    -1.746     0.200
    19.545    -0.333     0.200
    19.595    -1.178     0.200
    20.722    -0.427     0.200
    21.385    -0.874     0.200
    36.464     0.709     0.200
    45.522     0.155     0.200
    46.142     1.363     0.200
    53.365     0.199     0.200
    58.337     1.279     0.200
    72.978     0.592     0.200
    18.080     1.609     0.200
    19.322    -0.306     0.200
    21.275    -1.784     0.200
    36.679     1.503     0.200
    68.475     0.058     0.200
    36.626     3.264     0.200
    58.299    -0.090     0.200
    68.518     0.357     0.200
    18.393     1.446     0.200
    19.439    -0.064     0.200
    20.711    -0.619     0.200
    82.315     0.810     0.200
    89.631     2.225     0.200
    20.920    -0.839     0.200
    36.264    -0.278     0.200
    82.684    -0.919     0.200
    14.081    12.055     0.200
    14.155     4.142     0.200
    14.358     3.524     0.200
    14.578     4.692     0.200
    14.985     5.804     0.200
    15.054     3.163     0.200
    15.098     4.806     0.200
    15.198     4.614     0.200
    15.329     3.774     0.200
    15.329     4.774     0.200
    15.402     4.374     0.200
    15.402     5.124     0.200
    15.548     5.206     0.200
    15.947     1.618     0.200
    15.962     3.088     0.200
    16.239     7.657     0.200
    16.330     1.744     0.200
    16.400     7.511     0.200
    16.649     4.979     0.200
    16.787     3.487     0.200
    16.852     1.003     0.200
    16.943     4.729     0.200
    16.972     1.768     0.200
    17.044     1.559     0.200
    17.111     5.115     0.200
    17.116     1.603     0.200
    17.172     0.759     0.200
    17.184     1.198     0.200
    17.336     1.654     0.200
    17.378     1.896     0.200
    17.378     3.388     0.200
    17.355     1.367     0.200
    17.712     3.538     0.200
    17.724     3.225     0.200
    17.743     1.348     0.200
    17.795     4.109     0.200
    17.796     2.598     0.200
    17.810     4.118     0.200
    17.844     2.707     0.200
    17.941     0.284     0.200
    18.006     4.658     0.200
    18.065     0.287     0.200
    18.065     1.877     0.200
    18.065    -0.052     0.200
    18.262     1.060     0.200
    18.286     1.455     0.200
    18.325     4.791     0.200
    18.331     3.455     0.200
    18.388     1.828     0.200
    18.461    -0.787     0.200
    18.789     1.295     0.200
    18.873    -0.917     0.200
    18.908    -0.365     0.200
    18.964    -4.009     0.200
    19.053    -0.210     0.200
    19.149    -0.442     0.200
    19.170    -1.371     0.200
    19.361    -0.560     0.200
    19.559    -0.531     0.200
    19.559    -1.129     0.200
    19.755    -0.673     0.200
    19.752     0.362     0.200
    20.471     0.638     0.200
    20.687     0.491     0.200
    20.891    -0.513     0.200
    20.891    -0.212     0.200
    21.459     4.158     0.200
    21.549    -0.606     0.200
    22.925     3.009     0.200
    24.062     1.277     0.200
    24.512     2.589     0.200
    26.161     2.696     0.200
    26.194     2.542     0.200
    26.217     1.593     0.200
    27.032     2.233     0.200
    27.719     1.651     0.200
    27.801     3.038     0.200
    28.068     1.241     0.200
    28.273     2.313     0.200
    28.331    -0.188     0.200
    28.438     0.019     0.200
    28.438    -0.762     0.200
    28.560     2.258     0.200
    28.637     1.491     0.200
    28.718     1.940     0.200
    28.810    -0.455     0.200
    28.955     1.678     0.200
    29.130     2.212     0.200
    29.359     2.664     0.200
    29.727     1.828     0.200
    30.284     0.941     0.200
    31.289     2.406     0.200
    31.289     2.180     0.200
    31.566    -0.118     0.200
    32.759     0.603     0.200
    33.157     0.422     0.200
    33.157     0.781     0.200
    34.074     3.512     0.200
    37.503     0.344     0.200
    37.503     0.922     0.200
    37.932     2.091     0.200
    38.262     1.196     0.200
    38.262     1.306     0.200
    38.402     0.184     0.200
    38.402     0.726     0.200
    39.060     0.248     0.200
    39.149     2.167     0.200
    39.296     2.433     0.200
    39.534     1.547     0.200
    40.448     1.751     0.200
    43.389     2.018     0.200
    43.750     0.805     0.200
    43.750     0.375     0.200
    45.529     0.404     0.200
    45.559     4.465     0.200
    46.632     0.835     0.200
    47.208     0.960     0.200
    47.204     2.926     0.200
    48.511     0.708     0.200
    48.643     3.592     0.200
    48.886     4.437     0.200
    48.919     4.474     0.200
    49.898     0.998     0.200
    50.230     0.476     0.200
    50.823     0.195     0.200
    50.799     3.904     0.200
    51.532     0.470     0.200
    52.917    -0.401     0.200
    53.375     5.503     0.200
    53.852     1.955     0.200
    54.707     1.542     0.200
    54.707     2.253     0.200
    54.848     1.247     0.200
    54.848     1.439     0.200
    55.137     0.875     0.200
    55.137     1.765     0.200
    55.856     1.630     0.200
    56.561     1.455     0.200
    56.611     2.194     0.200
    56.665     4.242     0.200
    56.802    -0.759     0.200
    57.397     1.025     0.200
    57.836     0.238     0.200
    57.961     1.163     0.200
    57.989     0.966     0.200
    58.071     2.183     0.200
    58.071     1.445     0.200
    58.148     4.549     0.200
    58.205     1.950     0.200
    58.363     1.542     0.200
    58.487     1.575     0.200
    59.044     0.502     0.200
    60.232    -0.789     0.200
    60.519     1.183     0.200
    61.050     2.197     0.200
    61.216     2.114     0.200
    61.216     1.762     0.200
    61.511     0.652     0.200
    61.688    -0.061     0.200
    61.897     1.287     0.200
    61.897     1.061     0.200
    61.897     1.909     0.200
    61.934     1.761     0.200
    62.007     0.275     0.200
    62.136     0.209     0.200
    62.429     1.160     0.200
    63.259     2.745     0.200
    64.104    -0.159     0.200
    64.679     0.723     0.200
    65.606     0.855     0.200
    66.045     2.722     0.200
    67.121     0.401     0.200
    67.121     1.549     0.200
    67.778     0.189     0.200
    67.778    -0.241     0.200
    67.967     1.804     0.200
    67.967     1.190     0.200
    68.063     0.415     0.200
    68.475     4.616     0.200
    68.475     1.315     0.200
    68.475     2.116     0.200
    68.535     0.987     0.200
    68.535     0.241     0.200
    68.537     3.425     0.200
    69.417     1.757     0.200
    69.596    -0.417     0.200
    69.642    -0.170     0.200
    69.904     0.253     0.200
    69.904     0.093     0.200
    70.011     5.100     0.200
    70.260     0.544     0.200
    70.984     2.354     0.200
    70.995     0.586     0.200
    71.599     1.944     0.200
    71.803     4.707     0.200
    71.803     4.605     0.200
    71.813     4.331     0.200
    71.813     0.917     0.200
    72.181    -0.271     0.200
    72.194     1.780     0.200
    72.194     1.959     0.200
    72.232    -0.105     0.200
    72.232     2.735     0.200
    72.219     1.411     0.200
    72.359     0.553     0.200
    72.359     2.072     0.200
    72.721     1.819     0.200
    72.897     2.171     0.200
    72.899     1.612     0.200
    73.604     0.990     0.200
    73.705     0.825     0.200
    73.811    -0.318     0.200
    74.121     0.902     0.200
    74.157     1.458     0.200
    74.524     1.321     0.200
    74.836     2.514     0.200
    74.864     3.153     0.200
    75.455     1.457     0.200
    75.455     2.246     0.200
    75.737     2.632     0.200
    75.961    -0.757     0.200
    75.961    -0.347     0.200
    76.029     1.612     0.200
    76.029     0.963     0.200
    76.095    -0.763     0.200
    76.083    -3.146     0.200
    76.238     0.208     0.200
    76.238     0.771     0.200
    76.255     1.177     0.200
    76.623     1.990     0.200
    76.701    -0.230     0.200
    76.760     3.818     0.200
    76.914     0.248     0.200
    77.228     0.082     0.200
    77.247    -0.525     0.200
    77.412     1.259     0.200
    77.412     2.650     0.200
    77.684    -0.629     0.200
    78.522     1.019     0.200
    78.522     1.679     0.200
    78.658     3.430     0.200
    78.832     0.225     0.200
    79.013     0.438     0.200
    79.727     0.654     0.200
    79.727     1.084     0.200
    80.046     1.336     0.200
    80.214     0.788     0.200
    80.214     1.249     0.200
    80.300     0.998     0.200
    80.324     0.354     0.200
    80.347     0.533     0.200
    80.347     1.732     0.200
    80.473     0.556     0.200
    80.593     4.709     0.200
    80.759     1.489     0.200
    80.767     6.476     0.200
    80.822     0.486     0.200
    80.844     1.225     0.200
    80.894     1.347     0.200
    80.894     0.410     0.200
    80.894     1.499     0.200
    80.961     5.944     0.200
    81.124     1.575     0.200
    81.158     5.194     0.200
    81.291     2.276     0.200
    81.319     1.797     0.200
    81.366     2.188     0.200
    81.625     1.116     0.200
    81.625     1.717     0.200
    81.978     1.557     0.200
    82.154     0.833     0.200
    82.229     0.530     0.200
    82.328    -0.227     0.200
    82.544     1.492     0.200
    82.544     1.992     0.200
    82.624     0.783     0.200
    82.624     1.572     0.200
    82.812    -0.214     0.200
    82.855     1.094     0.200
    83.275     0.482     0.200
    83.275     2.201     0.200
    83.325     0.804     0.200
    83.325     1.543     0.200
    83.360     1.174     0.200
    83.539    -0.277     0.200
    83.663     1.093     0.200
    83.758     0.965     0.200
    83.885     0.499     0.200
    83.885     1.871     0.200
    83.932    -0.282     0.200
    83.985     0.488     0.200
    84.046     1.188     0.200
    84.302     0.955     0.200
    84.515     1.338     0.200
    84.564     1.594     0.200
    84.564     3.414     0.200
    84.731     1.003     0.200
    84.767     2.090     0.200
    84.792     1.299     0.200
    84.792     2.267     0.200
    84.797     0.620     0.200
    85.295     1.232     0.200
    85.338     1.881     0.200
    85.681     1.770     0.200
    86.304     0.877     0.200
    86.304     1.936     0.200
    86.315     1.411     0.200
    86.315     3.083     0.200
    86.458     0.498     0.200
    86.458     4.478     0.200
    86.458     0.677     0.200
    86.458     0.779     0.200
    86.460     1.231     0.200
    86.679     1.236     0.200
    86.679     2.396     0.200
    86.736     1.340     0.200
    86.736     2.020     0.200
    87.121     2.399     0.200
    87.379     1.365     0.200
    87.453     1.019     0.200
    87.455     1.022     0.200
    87.494     5.232     0.200
    87.550    -0.179     0.200
    87.635     0.983     0.200
    88.739     1.394     0.200
    89.204     0.216     0.200
    89.399     1.042     0.200
    89.399     2.221     0.200
    89.399     2.045     0.200
    89.435     0.542     0.200
    89.435     2.553     0.200
    89.490     0.865     0.200
    89.490     1.794     0.200
    89.557     1.859     0.200
    89.882     0.731     0.200
    89.882     1.462     0.200
    90.109     0.600     0.200
    90.222     0.607     0.200
    90.570     0.773     0.200
    90.769     1.940     0.200
    90.769     1.537     0.200
    90.769     2.127     0.200
    90.986     1.299     0.200
    90.986     1.619     0.200
    92.730     0.728     0.200
    92.730     2.048     0.200
    47.178     0.987     0.200
    73.570     4.381     0.200
    14.331     4.258     0.200
    14.734     3.056     0.200
    14.896     4.493     0.200
    15.027     3.182     0.200
    15.070     4.354     0.200
    15.354     6.053     0.200
    15.303     4.122     0.200
    15.375     3.275     0.200
    15.574     6.748     0.200
    15.649     3.914     0.200
    15.709     6.163     0.200
    15.735     2.651     0.200
    15.944     4.173     0.200
    15.971     4.413     0.200
    15.974     1.722     0.200
    15.924     5.583     0.200
    15.936     5.076     0.200
    16.106     3.218     0.200
    16.160     8.195     0.200
    16.236     1.457     0.200
    16.239     2.116     0.200
    16.311     6.607     0.200
    16.311     4.845     0.200
    16.311     1.421     0.200
    16.361     6.224     0.200
    16.361     1.291     0.200
    16.422     3.338     0.200
    16.477     4.884     0.200
    16.622     2.548     0.200
    16.850     2.523     0.200
    16.854     5.751     0.200
    16.922     1.172     0.200
    16.949     2.623     0.200
    17.021     2.021     0.200
    17.111     2.220     0.200
    17.091     3.352     0.200
    17.096     1.334     0.200
    17.150     0.708     0.200
    17.339     1.793     0.200
    17.359     4.724     0.200
    17.359     1.392     0.200
    17.705     0.526     0.200
    17.666     1.405     0.200
    17.699     0.561     0.200
    17.718     1.846     0.200
    17.773     2.270     0.200
    17.771     3.194     0.200
    17.819     2.302     0.200
    17.925     4.656     0.200
    17.944     0.055     0.200
    18.067     1.320     0.200
    18.067     2.019     0.200
    18.230     1.749     0.200
    18.278     2.352     0.200
    18.312    -0.421     0.200
    18.254     0.358     0.200
    18.364     2.230     0.200
    18.321     0.041     0.200
    18.448     3.239     0.200
    18.468     0.946     0.200
    18.483    -0.943     0.200
    18.483    -0.271     0.200
    18.430     3.606     0.200
    18.384     1.212     0.200
    18.513     2.044     0.200
    18.438     2.725     0.200
    18.523     2.443     0.200
    18.445    -1.450     0.200
    18.533    -0.624     0.200
    18.635    -0.846     0.200
    18.805     1.792     0.200
    18.805     1.952     0.200
    18.970    -0.620     0.200
    19.029    -0.538     0.200
    19.200    -1.152     0.200
    19.128    -0.362     0.200
    19.161    -0.819     0.200
    19.269     0.203     0.200
    19.391    -0.237     0.200
    19.505    -0.087     0.200
    19.505    -0.485     0.200
    19.421    -0.369     0.200
    19.589    -0.100     0.200
    19.589    -0.901     0.200
    19.662     0.120     0.200
    19.780    -0.183     0.200
    19.763    -0.101     0.200
    19.785     0.157     0.200
    20.229     0.325     0.200
    20.197     0.671     0.200
    20.197     0.948     0.200
    20.394    -0.156     0.200
    20.430     0.166     0.200
    20.438    -0.852     0.200
    20.581    -0.190     0.200
    20.810     0.172     0.200
    20.758     1.389     0.200
    20.916    -0.421     0.200
    21.177     0.902     0.200
    21.265     0.428     0.200
    21.362     0.941     0.200
    21.486     3.529     0.200
    21.574    -0.008     0.200
    23.876    -0.298     0.200
    24.089    -0.249     0.200
    24.531     2.457     0.200
    24.531     2.597     0.200
    26.166     0.078     0.200
    26.189     4.419     0.200
    26.189    -0.031     0.200
    26.509     2.017     0.200
    27.003     3.141     0.200
    27.003     0.001     0.200
    27.003     1.950     0.200
    27.741     0.238     0.200
    27.826     0.845     0.200
    28.089    -0.022     0.200
    28.245     1.677     0.200
    28.355     1.323     0.200
    28.460    -0.920     0.200
    28.509     1.135     0.200
    28.532     1.139     0.200
    28.833     0.976     0.200
    28.736     1.434     0.200
    28.736     3.961     0.200
    28.904     4.717     0.200
    28.904     1.440     0.200
    29.148     0.874     0.200
    29.376     1.890     0.200
    30.256     0.634     0.200
    31.302     0.362     0.200
    31.596    -0.579     0.200
    31.596     0.542     0.200
    32.789     0.876     0.200
    33.183    -0.226     0.200
    34.353     2.056     0.200
    37.533     0.384     0.200
    37.533     1.712     0.200
    37.946     1.118     0.200
    38.293     1.490     0.200
    38.293     1.099     0.200
    38.433     0.798     0.200
    39.120     2.056     0.200
    39.267     1.224     0.200
    39.505     1.139     0.200
    40.477     2.167     0.200
    43.418     1.542     0.200
    43.780     0.723     0.200
    45.559     0.427     0.200
    45.588     3.703     0.200
    47.238     1.142     0.200
    47.238     1.294     0.200
    47.200     4.937     0.200
    47.200     1.628     0.200
    48.538     1.172     0.200
    49.924     0.769     0.200
    50.823     1.635     0.200
    51.324    -0.501     0.200
    51.558     2.722     0.200
    52.914    -0.825     0.200
    54.731     2.510     0.200
    54.870    -0.125     0.200
    54.870     0.273     0.200
    55.148     1.025     0.200
    55.877     0.361     0.200
    56.587     1.450     0.200
    56.689     4.612     0.200
    57.424     0.823     0.200
    57.653     4.689     0.200
    57.862     0.740     0.200
    57.987     1.265     0.200
    58.015     0.665     0.200
    58.102     1.738     0.200
    58.232     0.751     0.200
    58.390     1.242     0.200
    58.518     2.152     0.200
    59.066    -0.261     0.200
    60.262    -0.298     0.200
    60.605    -0.085     0.200
    60.605     1.356     0.200
    60.541     4.163     0.200
    61.104     0.294     0.200
    61.071     4.744     0.200
    61.243     2.219     0.200
    61.928     1.971     0.200
    61.928     1.838     0.200
    61.964     2.253     0.200
    62.127     0.748     0.200
    62.453     0.080     0.200
    62.453     4.580     0.200
    63.072     0.950     0.200
    63.285    -2.848     0.200
    64.144    -0.215     0.200
    64.144    -0.426     0.200
    64.131     0.462     0.200
    65.635     1.666     0.200
    66.072     3.349     0.200
    66.140     2.813     0.200
    66.463     1.843     0.200
    67.792     0.225     0.200
    67.792     0.404     0.200
    67.772     0.636     0.200
    67.997     1.044     0.200
    68.055     3.164     0.200
    68.498     0.973     0.200
    68.544     0.178     0.200
    68.544     0.491     0.200
    68.568     1.842     0.200
    69.446     1.883     0.200
    69.594     0.134     0.200
    69.634     0.222     0.200
    69.907     0.881     0.200
    70.260     0.430     0.200
    70.337     1.709     0.200
    71.014     3.780     0.200
    71.025     0.913     0.200
    71.144     1.513     0.200
    71.337     1.488     0.200
    71.578     1.698     0.200
    71.833     1.635     0.200
    71.843     0.834     0.200
    72.211     2.308     0.200
    72.221     3.171     0.200
    72.339     1.332     0.200
    72.747     1.675     0.200
    72.913     2.087     0.200
    72.915     1.279     0.200
    73.065     1.336     0.200
    73.631     0.904     0.200
    73.841     1.423     0.200
    74.137     1.141     0.200
    74.137     1.790     0.200
    74.186     1.404     0.200
    74.554     1.561     0.200
    74.866     4.552     0.200
    74.894     5.093     0.200
    75.183     0.362     0.200
    75.183     0.522     0.200
    75.428     1.812     0.200
    75.472     2.289     0.200
    76.040     2.768     0.200
    76.113    -2.500     0.200
    76.254     1.138     0.200
    76.271     2.000     0.200
    76.639     2.819     0.200
    76.692     3.070     0.200
    76.789     2.167     0.200
    76.931     1.313     0.200
    77.219     0.145     0.200
    77.264     2.396     0.200
    77.428     1.038     0.200
    77.700     1.769     0.200
    78.522     1.122     0.200
    78.522     1.301     0.200
    78.824     3.007     0.200
    79.018     0.673     0.200
    79.720     0.482     0.200
    79.720     1.244     0.200
    80.049     1.412     0.200
    80.211     0.617     0.200
    80.337     1.738     0.200
    80.363     3.505     0.200
    80.353     1.020     0.200
    80.353     1.442     0.200
    80.476     0.642     0.200
    80.620     4.288     0.200
    80.762     1.618     0.200
    80.825     0.790     0.200
    80.798     4.240     0.200
    80.847     1.637     0.200
    80.899     1.167     0.200
    81.125     3.498     0.200
    81.186     1.367     0.200
    81.293     2.558     0.200
    81.368     2.173     0.200
    81.289     0.518     0.200
    81.630     1.315     0.200
    81.630     1.515     0.200
    81.662     2.844     0.200
    81.822     2.252     0.200
    81.981     1.696     0.200
    82.155     0.954     0.200
    82.220     1.893     0.200
    82.234     1.086     0.200
    82.274     2.253     0.200
    82.334     2.925     0.200
    82.543     1.664     0.200
    82.619     1.058     0.200
    82.619     1.328     0.200
    82.819     1.795     0.200
    82.857     1.471     0.200
    83.164     1.872     0.200
    83.321     2.180     0.200
    83.330     0.756     0.200
    83.365     0.826     0.200
    83.545     1.435     0.200
    83.666     1.765     0.200
    83.841     1.830     0.200
    83.890    -0.660     0.200
    83.986     1.310     0.200
    84.044     1.315     0.200
    84.303     1.106     0.200
    84.392     1.563     0.200
    84.520     2.246     0.200
    84.570     1.778     0.200
    84.625     0.606     0.200
    84.732     1.140     0.200
    84.766     2.096     0.200
    84.792     0.604     0.200
    84.798     1.237     0.200
    85.283     0.331     0.200
    85.294     1.195     0.200
    85.337     2.221     0.200
    85.682     1.617     0.200
    86.298     2.072     0.200
    86.318     2.630     0.200
    86.318     2.802     0.200
    86.488     0.911     0.200
    86.488     1.462     0.200
    86.490     1.164     0.200
    86.676     1.591     0.200
    86.676     2.041     0.200
    86.736     1.826     0.200
    86.736     1.947     0.200
    87.126     3.134     0.200
    87.376     1.805     0.200
    87.457     1.722     0.200
    87.453     1.785     0.200
    87.548     1.456     0.200
    87.631     1.778     0.200
    87.871     0.590     0.200
    88.534     0.343     0.200
    88.534     0.624     0.200
    88.738     1.424     0.200
    89.207     0.968     0.200
    89.394     2.183     0.200
    89.438     2.552     0.200
    89.462     1.314     0.200
    89.493     1.118     0.200
    89.559     1.436     0.200
    90.113     1.027     0.200
    90.225     1.305     0.200
    90.543     2.054     0.200
    90.572     2.680     0.200
    90.772     1.846     0.200
    90.984     1.272     0.200
    92.715     4.814     0.200
    19.501    -0.268     0.200
    20.922     0.262     0.200
    37.557     1.688     0.200
    39.490     1.074     0.200
    47.264     1.561     0.200
    72.909     1.500     0.200
    73.661     3.853     0.200
    82.135     0.451     0.200
    14.321     4.335     0.200
    14.321     5.077     0.200
    14.543     5.026     0.200
    15.062     4.779     0.200
    15.292     4.486     0.200
    15.292     5.431     0.200
    15.365     4.321     0.200
    15.365     5.751     0.200
    15.908     3.117     0.200
    15.908     4.617     0.200
    15.925     3.604     0.200
    15.925     4.671     0.200
    16.613     3.997     0.200
    16.729     3.096     0.200
    16.932     3.464     0.200
    17.071     2.021     0.200
    17.132     3.159     0.200
    17.687     4.131     0.200
    17.687     2.721     0.200
    17.706     3.613     0.200
    20.226     1.667     0.200
    20.890    -0.054     0.200
    21.548    -0.793     0.200
    26.999     2.930     0.200
    28.432     0.288     0.200
    31.587    -0.651     0.200
    37.527     1.063     0.200
    38.287     0.660     0.200
    38.427     1.786     0.200
    39.523     2.646     0.200
    47.236     2.292     0.200
    47.234     1.550     0.200
    50.791    -0.217     0.200
    52.882    -1.410     0.200
    64.642    -2.208     0.200
    67.759     0.262     0.200
    67.759    -0.266     0.200
    68.510    -0.672     0.200
    70.226    -0.724     0.200
    72.180     1.190     0.200
    72.882     0.964     0.200
    73.641    -0.115     0.200
    81.111    -0.375     0.200
    81.947     0.862     0.200
    82.121    -0.093     0.200
    85.304     1.152     0.200
    89.362     0.945     0.200
    89.525     1.123     0.200
    17.730     4.892     0.200
    20.236    -0.738     0.200
    20.920    -0.014     0.200
    47.270     1.171     0.200
    67.777     0.493     0.200
    73.670     0.960     0.200
    82.123     0.740     0.200
    18.303     4.307     0.200
    20.908    -0.097     0.200
    47.216     0.685     0.200
    73.607    -0.156     0.200
    47.206     1.505     0.200
    15.275     6.167     0.200
    15.348     5.771     0.200
    15.893     4.678     0.200
    15.908     4.225     0.200
    19.485    -0.285     0.200
    20.232     0.443     0.200
    20.907    -0.534     0.200
    28.447     0.073     0.200
    31.607    -0.501     0.200
    37.547     0.871     0.200
    38.307     0.096     0.200
    38.307     2.006     0.200
    38.446     1.960     0.200
    39.118     2.293     0.200
    39.266     0.154     0.200
    39.504     0.072     0.200
    46.675     3.187     0.200
    47.255     0.772     0.200
    47.231     4.680     0.200
    64.638    -2.026     0.200
    70.227    -0.774     0.200
    82.122    -0.142     0.200
    73.628     3.400     0.200
    18.475    -0.572     0.200
    19.617    -0.963     0.200
    20.933    -0.860     0.200
    21.591    -0.344     0.200
    28.473     1.528     0.200
    31.627     0.772     0.200
    38.326     1.108     0.200
    39.094     0.570     0.200
    39.242     0.731     0.200
    39.479     0.248     0.200
    45.591     3.864     0.200
    46.695     0.497     0.200
    47.272     0.888     0.200
    68.538     0.179     0.200
    82.140    -1.835     0.200
    89.372     0.181     0.200
    20.918    -0.306     0.200
    38.302     1.289     0.200
    47.247     0.484     0.200
    73.642    -0.169     0.200
    20.919     0.500     0.200
    37.548     1.526     0.200
    38.308     0.653     0.200
    47.255     0.576     0.200
    19.223    -1.111     0.200
    19.332    -1.632     0.200
    19.607    -0.211     0.200
    19.787    -0.977     0.200
    20.456    -2.460     0.200
    20.923    -0.094     0.200
    21.514     5.618     0.200
    21.581    -0.800     0.200
    28.363    -0.672     0.200
    28.464    -0.339     0.200
    31.617    -0.754     0.200
    31.617    -1.266     0.200
    39.104     3.556     0.200
    39.252     1.221     0.200
    39.490     0.738     0.200
    45.581     3.328     0.200
    46.684     0.539     0.200
    47.262     0.891     0.200
    51.923     4.995     0.200
    52.894    -1.386     0.200
    56.814     0.005     0.200
    57.452     1.397     0.200
    58.418     1.716     0.200
    58.785    -0.146     0.200
    59.484     0.013     0.200
    60.279    -1.049     0.200
    61.270     2.299     0.200
    67.111     5.027     0.200
    68.533     0.121     0.200
    72.911     0.986     0.200
    73.659     1.304     0.200
    74.574     2.008     0.200
    76.132     1.153     0.200
    84.024     0.337     0.200
    89.372     2.023     0.200
    19.573    -0.478     0.200
    20.904    -0.102     0.200
    28.451     0.053     0.200
    38.275     2.369     0.200
    39.134     3.158     0.200
    39.282     1.223     0.200
    39.520     0.239     0.200
    47.220     0.438     0.200
    68.543     0.646     0.200
    70.264     1.506     0.200
    82.159     0.234     0.200
    89.401     3.215     0.200
    20.915    -1.311     0.200
    47.219     0.045     0.200
    72.924     1.028     0.200
    73.607     3.745     0.200
    89.417     1.526     0.200
    19.421     0.302     0.200
    20.179    -0.402     0.200
    20.967     2.455     0.200
    21.665    -0.564     0.200
    32.280     0.090     0.200
    39.004     0.249     0.200
    47.835    -0.276     0.200
    52.481     2.592     0.200
    62.233     0.204     0.200
    69.083     0.860     0.200
    73.569     1.393     0.200
    76.822    -0.946     0.200
    18.019     1.856     0.200
    19.334     0.534     0.200
    20.579     0.249     0.200
    21.241    -1.266     0.200
    23.017     0.110     0.200
    46.154     1.889     0.200
    46.713     1.333     0.200
    61.058     2.108     0.200
    21.432    -0.890     0.200
    30.088     1.686     0.200
    47.881     0.283     0.200
    68.708    -0.937     0.200
    30.651     2.047     0.200
    47.266     1.293     0.200
    20.543     0.162     0.200
    28.168    -0.583     0.200
    30.947     0.294     0.200
    30.947    -0.327     0.200
    31.157     0.322     0.200
    44.900     1.363     0.200
    46.008     0.767     0.200
    46.532     0.772     0.200
    59.675    -0.673     0.200
    60.902     1.739     0.200
    67.883     0.476     0.200
    68.623     1.078     0.200
    70.546     1.382     0.200
    70.695     1.349     0.200
    72.909     1.381     0.200
    76.081    -0.632     0.200
    79.799     1.515     0.200
    82.419     1.881     0.200
    89.796     3.065     0.200
    89.789     2.084     0.200
    18.685    -1.739     0.200
    19.372     0.717     0.200
    19.618     1.309     0.200
    19.740     0.404     0.200
    19.740    -0.046     0.200
    20.945    -0.063     0.200
    20.946     0.224     0.200
    26.140    -0.132     0.200
    28.562    -0.374     0.200
    30.758     0.802     0.200
    31.304     1.994     0.200
    37.945     1.342     0.200
    43.414     0.513     0.200
    46.354     1.239     0.200
    46.837     1.382     0.200
    61.247     2.051     0.200
    68.212     3.234     0.200
    68.925     1.280     0.200
    70.339     1.318     0.200
    80.026     1.499     0.200
    80.026     1.499     0.200
    89.942     2.266     0.200
    18.428     0.110     0.200
    18.793    -1.008     0.200
    19.880     0.843     0.200
    19.938    -0.137     0.200
    20.020    -0.165     0.200
    20.020    -0.167     0.200
    20.731     1.903     0.200
    20.791    -2.000     0.200
    21.250     2.147     0.200
    21.388     0.283     0.200
    21.388     0.278     0.200
    21.401     4.094     0.200
    21.530     4.535     0.200
    22.566     1.139     0.200
    22.566     1.418     0.200
    22.566     3.068     0.200
    27.582     1.142     0.200
    28.955    -2.230     0.200
    28.955    -2.225     0.200
    30.236     0.719     0.200
    30.240     0.681     0.200
    31.890    -0.181     0.200
    31.890    -0.031     0.200
    32.291     1.125     0.200
    33.085     1.088     0.200
    33.181     0.728     0.200
    33.181     2.153     0.200
    38.538     1.851     0.200
    38.642     1.111     0.200
    38.604     1.360     0.200
    43.973     1.011     0.200
    44.008     1.610     0.200
    45.679     2.662     0.200
    46.943     0.994     0.200
    46.944     2.787     0.200
    46.944     0.982     0.200
    46.944     1.337     0.200
    47.430     1.047     0.200
    47.430     1.077     0.200
    47.430     1.077     0.200
    47.444     1.087     0.200
    49.724     1.868     0.200
    52.076     3.561     0.200
    58.393     2.884     0.200
    61.836     1.446     0.200
    61.837     1.466     0.200
    61.837     1.466     0.200
    62.146     1.292     0.200
    62.200     2.519     0.200
    68.806     3.004     0.200
    70.092     1.030     0.200
    71.726     2.613     0.200
    73.430     1.826     0.200
    73.647    -0.005     0.200
    77.937     0.400     0.200
    78.901     2.551     0.200
    80.615     0.320     0.200
    80.615     0.320     0.200
    80.615     0.318     0.200
    82.604     1.786     0.200
    84.268     0.535     0.200
    84.466     3.237     0.200
    87.893    -0.457     0.200
    14.309     8.669     0.200
    21.399     0.235     0.200
    30.227     2.113     0.200
    47.444     0.671     0.200
    61.851     1.073     0.200
    14.312    10.077     0.200
    18.448     0.068     0.200
    20.039    -0.363     0.200
    20.039     0.702     0.200
    21.412     1.020     0.200
    28.978    -1.176     0.200
    31.915     0.323     0.200
    38.562     1.201     0.200
    43.479     0.776     0.200
    44.032     3.962     0.200
    46.969     1.099     0.200
    47.453     0.745     0.200
    49.748     1.559     0.200
    61.862     1.324     0.200
    62.225     2.938     0.200
    14.407     8.717     0.200
    19.518     0.137     0.200
    30.638     1.332     0.200
    31.627     2.238     0.200
    39.003     1.454     0.200
    68.547     1.979     0.200
    72.926     0.830     0.200
    73.661     4.316     0.200
    14.941     8.355     0.200
    15.380     3.221     0.200
    15.536     4.547     0.200
    15.588     4.798     0.200
    15.870     3.123     0.200
    15.956     2.967     0.200
    15.979     3.590     0.200
    16.202     3.015     0.200
    16.430     2.320     0.200
    16.543     3.999     0.200
    16.580     3.679     0.200
    16.669     2.805     0.200
    16.704     4.469     0.200
    16.731     2.831     0.200
    16.759     3.272     0.200
    16.838     2.957     0.200
    17.006     1.633     0.200
    17.105     2.630     0.200
    17.358     3.674     0.200
    17.406     5.549     0.200
    17.460     2.795     0.200
    17.475     2.613     0.200
    17.482     1.434     0.200
    17.500     3.100     0.200
    17.591     3.974     0.200
    17.756     1.840     0.200
    17.806     4.510     0.200
    18.321     1.282     0.200
    18.769     0.349     0.200
    18.769     0.200     0.200
    19.600     0.880     0.200
    19.594    -1.187     0.200
    19.604    -1.304     0.200
    19.773     0.451     0.200
    19.773     0.713     0.200
    19.949     0.788     0.200
    19.996    -0.682     0.200
    20.007    -0.692     0.200
    20.007     0.703     0.200
    20.007     0.340     0.200
    20.038     0.141     0.200
    20.012     0.746     0.200
    20.133     1.532     0.200
    20.488    -0.333     0.200
    20.519    -0.108     0.200
    20.856    -1.707     0.200
    21.033     0.720     0.200
    21.032     2.084     0.200
    21.032     3.162     0.200
    21.122    -0.584     0.200
    21.157     2.837     0.200
    21.280     0.749     0.200
    21.281     0.169     0.200
    21.844     3.660     0.200
    22.222     1.928     0.200
    22.463     2.165     0.200
    22.912     3.092     0.200
    22.912     2.701     0.200
    22.912     3.990     0.200
    23.180     2.673     0.200
    23.557     3.398     0.200
    23.715     3.450     0.200
    23.758     1.459     0.200
    23.982     4.114     0.200
    24.139     1.978     0.200
    24.516     4.237     0.200
    24.521     3.888     0.200
    24.620     1.691     0.200
    24.857     5.532     0.200
    25.901     3.454     0.200
    26.304     4.305     0.200
    26.583     3.787     0.200
    27.599     0.051     0.200
    28.794     0.153     0.200
    30.269    -0.423     0.200
    30.269     1.675     0.200
    31.445     1.061     0.200
    31.445     2.749     0.200
    32.016     0.730     0.200
    32.016     1.398     0.200
    32.016     1.828     0.200
    32.511     1.587     0.200
    32.511     0.786     0.200
    33.209     1.381     0.200
    33.520     1.746     0.200
    33.520     1.757     0.200
    36.906     0.626     0.200
    37.511     2.752     0.200
    37.700     0.161     0.200
    37.739     2.159     0.200
    37.770     1.826     0.200
    37.920     2.155     0.200
    38.174     0.475     0.200
    38.193     2.004     0.200
    38.210     1.326     0.200
    38.239     1.031     0.200
    38.622     1.445     0.200
    38.622     0.344     0.200
    38.711     2.065     0.200
    38.709     1.279     0.200
    38.709     0.658     0.200
    38.859     2.419     0.200
    39.096     0.434     0.200
    40.112     1.373     0.200
    40.112    -1.127     0.200
    40.864     0.856     0.200
    40.864     1.395     0.200
    40.864     1.356     0.200
    41.095     0.553     0.200
    41.389     0.616     0.200
    42.966     2.078     0.200
    43.090    -0.032     0.200
    43.090    -0.231     0.200
    43.281    -1.191     0.200
    43.583     3.611     0.200
    43.613     1.238     0.200
    43.787     1.842     0.200
    43.787     2.447     0.200
    43.787     2.994     0.200
    43.787     1.647     0.200
    43.845     4.881     0.200
    43.940     7.281     0.200
    44.096     6.347     0.200
    44.194     1.481     0.200
    44.194     1.051     0.200
    44.330     1.395     0.200
    44.456     1.087     0.200
    44.505     2.733     0.200
    44.641     1.474     0.200
    45.266     1.053     0.200
    45.373     0.775     0.200
    45.676     0.217     0.200
    45.965     3.501     0.200
    46.092     2.203     0.200
    46.092     1.750     0.200
    46.341     1.188     0.200
    46.386     1.509     0.200
    46.730     0.849     0.200
    46.981     2.330     0.200
    47.314     2.311     0.200
    47.091     1.627     0.200
    47.104     4.272     0.200
    47.437     1.674     0.200
    47.437     0.924     0.200
    47.645     0.558     0.200
    47.645     0.437     0.200
    47.645     0.285     0.200
    49.076    -0.139     0.200
    52.302     2.490     0.200
    52.906    -1.039     0.200
    53.420    -0.733     0.200
    55.082    -0.574     0.200
    55.338    -1.026     0.200
    55.476    -1.215     0.200
    56.834    -1.214     0.200
    56.945    -0.668     0.200
    56.945    -1.830     0.200
    56.933     0.983     0.200
    57.061     3.169     0.200
    57.308    -0.810     0.200
    57.308    -0.986     0.200
    57.378    -0.882     0.200
    57.387    -0.136     0.200
    57.387    -0.531     0.200
    57.523    -0.448     0.200
    58.018    -0.406     0.200
    58.062    -0.594     0.200
    58.242     1.167     0.200
    58.389    -0.367     0.200
    58.522     3.312     0.200
    58.566    -0.084     0.200
    58.598    -0.317     0.200
    58.566     0.904     0.200
    58.598     0.075     0.200
    58.578     0.418     0.200
    58.644    -0.267     0.200
    58.937     0.820     0.200
    59.092     0.289     0.200
    59.142    -1.147     0.200
    59.177    -0.552     0.200
    59.177    -0.652     0.200
    59.178    -0.488     0.200
    59.255    -0.222     0.200
    59.482    -0.658     0.200
    59.679    -0.667     0.200
    59.683    -0.393     0.200
    59.759     0.088     0.200
    59.784     0.242     0.200
    59.803    -0.365     0.200
    59.882     0.006     0.200
    60.241    -0.577     0.200
    60.278    -0.710     0.200
    60.319    -0.517     0.200
    60.344    -0.186     0.200
    60.345    -0.475     0.200
    60.379     0.025     0.200
    60.400     0.744     0.200
    60.437     0.685     0.200
    60.527     0.228     0.200
    60.678    -0.154     0.200
    60.841     0.042     0.200
    60.859    -0.674     0.200
    60.972     0.425     0.200
    61.018    -0.053     0.200
    61.069    -0.188     0.200
    61.075    -0.099     0.200
    61.086    -0.145     0.200
    61.182    -0.411     0.200
    61.238    -0.763     0.200
    61.253    -0.101     0.200
    61.374    -0.090     0.200
    61.406    -0.151     0.200
    61.527    -0.527     0.200
    61.548    -0.393     0.200
    61.575    -0.327     0.200
    61.610     2.478     0.200
    61.823    -0.229     0.200
    61.876    -1.425     0.200
    61.889     0.616     0.200
    61.920     0.710     0.200
    61.955     0.532     0.200
    61.964     0.109     0.200
    61.969     0.373     0.200
    61.986     1.893     0.200
    62.067    -0.033     0.200
    62.174    -0.409     0.200
    62.347     1.178     0.200
    62.369     0.426     0.200
    62.524    -0.201     0.200
    62.538     0.456     0.200
    62.606     0.174     0.200
    62.693     0.705     0.200
    62.981    -0.097     0.200
    62.994     0.341     0.200
    63.061     0.616     0.200
    63.107     0.632     0.200
    63.136     0.541     0.200
    63.213    -0.598     0.200
    63.327     0.117     0.200
    63.467     0.127     0.200
    63.471     0.174     0.200
    63.478    -0.283     0.200
    63.502    -0.110     0.200
    63.541     0.177     0.200
    63.573    -0.224     0.200
    63.606     0.047     0.200
    63.652    -0.015     0.200
    63.704     0.112     0.200
    63.747     0.584     0.200
    63.852    -0.009     0.200
    64.055     0.013     0.200
    64.060    -1.385     0.200
    64.071     0.318     0.200
    64.119     0.390     0.200
    64.124     0.460     0.200
    64.124     0.349     0.200
    64.138     0.137     0.200
    64.160     0.393     0.200
    64.297     0.243     0.200
    64.397     0.462     0.200
    64.546     0.030     0.200
    64.661     0.038     0.200
    64.675     0.054     0.200
    64.695     0.406     0.200
    64.695    -0.523     0.200
    64.769     0.070     0.200
    64.796    -0.142     0.200
    64.876     0.396     0.200
    65.114     0.165     0.200
    65.132    -0.159     0.200
    65.155    -0.643     0.200
    65.225     0.459     0.200
    65.295    -0.010     0.200
    65.312     0.374     0.200
    65.312     0.011     0.200
    65.333     0.105     0.200
    65.333    -1.516     0.200
    65.428    -0.243     0.200
    65.560     0.511     0.200
    65.622    -0.300     0.200
    65.628     0.132     0.200
    65.645    -0.159     0.200
    65.867     0.125     0.200
    65.885     0.313     0.200
    65.885    -0.925     0.200
    65.904    -0.121     0.200
    66.056    -0.150     0.200
    66.154     0.310     0.200
    66.183     0.354     0.200
    66.183    -0.662     0.200
    66.228    -0.499     0.200
    66.253    -0.026     0.200
    66.267    -0.104     0.200
    66.277     0.579     0.200
    66.281    -0.087     0.200
    66.467     0.143     0.200
    66.631     0.074     0.200
    66.686    -0.058     0.200
    66.784    -0.025     0.200
    66.784     0.109     0.200
    66.818    -0.217     0.200
    66.890    -0.035     0.200
    66.866     1.561     0.200
    66.921     0.529     0.200
    66.872     0.923     0.200
    67.024     0.327     0.200
    67.105     0.405     0.200
    67.132     0.283     0.200
    67.300     0.216     0.200
    67.313     0.410     0.200
    67.430     0.034     0.200
    67.442    -0.136     0.200
    67.443     2.332     0.200
    67.443     0.500     0.200
    67.601     0.823     0.200
    67.716     0.195     0.200
    67.716    -0.755     0.200
    67.797    -0.366     0.200
    67.912     0.111     0.200
    67.920     0.162     0.200
    67.972     0.144     0.200
    67.995     0.243     0.200
    68.031     0.321     0.200
    68.048    -0.308     0.200
    68.085    -0.457     0.200
    68.194    -0.201     0.200
    67.616     3.399     0.200
    68.396    -0.052     0.200
    68.421    -0.131     0.200
    68.428    -0.225     0.200
    68.429     0.395     0.200
    68.472     0.453     0.200
    68.510     0.491     0.200
    68.524     0.647     0.200
    68.603     0.361     0.200
    68.602     0.382     0.200
    68.701    -0.360     0.200
    68.735     0.115     0.200
    68.769     0.185     0.200
    68.781    -0.086     0.200
    68.784    -0.232     0.200
    68.846     3.397     0.200
    68.897    -0.019     0.200
    68.934     0.473     0.200
    68.964     0.205     0.200
    68.988     0.395     0.200
    68.983     1.241     0.200
    69.035    -0.192     0.200
    69.071     0.603     0.200
    69.167     0.585     0.200
    69.174     0.390     0.200
    69.242    -0.071     0.200
    69.293     0.195     0.200
    69.388    -0.665     0.200
    69.401     0.217     0.200
    69.406    -0.080     0.200
    69.413     0.343     0.200
    69.495    -0.169     0.200
    69.502     0.227     0.200
    69.558     0.164     0.200
    69.566    -0.323     0.200
    69.567     0.177     0.200
    69.602    -0.404     0.200
    69.648     0.371     0.200
    69.640    -0.640     0.200
    69.640     1.673     0.200
    69.787    -0.117     0.200
    69.836    -0.373     0.200
    69.849    -0.096     0.200
    69.873    -0.685     0.200
    69.838     0.954     0.200
    69.894    -0.171     0.200
    69.989     0.327     0.200
    70.006    -0.206     0.200
    70.069    -0.528     0.200
    70.080    -0.604     0.200
    70.284     0.252     0.200
    70.296    -0.159     0.200
    70.296    -0.929     0.200
    70.300    -0.645     0.200
    70.300    -0.540     0.200
    70.337    -0.046     0.200
    70.414    -0.267     0.200
    70.418    -0.288     0.200
    70.367     0.914     0.200
    70.367     0.390     0.200
    70.443    -0.363     0.200
    70.508    -0.381     0.200
    70.522    -0.627     0.200
    70.583    -0.588     0.200
    70.614    -0.225     0.200
    70.616     0.200     0.200
    70.714     1.295     0.200
    70.753     0.596     0.200
    70.866    -0.141     0.200
    71.098     0.558     0.200
    71.114    -0.604     0.200
    71.148     0.154     0.200
    71.182    -0.017     0.200
    71.246     0.777     0.200
    71.297     0.439     0.200
    71.585     0.173     0.200
    71.590    -0.125     0.200
    71.833     0.658     0.200
    71.948    -0.554     0.200
    72.041     0.173     0.200
    72.049    -0.001     0.200
    72.098    -0.263     0.200
    72.151    -0.737     0.200
    72.158     0.026     0.200
    72.166    -0.447     0.200
    72.238    -0.139     0.200
    72.254     0.276     0.200
    72.250     0.823     0.200
    72.353     0.816     0.200
    72.487     0.550     0.200
    72.576     0.614     0.200
    72.646     0.045     0.200
    72.669    -0.139     0.200
    72.623     1.600     0.200
    72.689     0.256     0.200
    72.713    -0.231     0.200
    72.789     0.407     0.200
    72.824     0.337     0.200
    72.929     0.886     0.200
    73.067    -0.226     0.200
    73.072     0.176     0.200
    73.125    -0.284     0.200
    73.148     0.428     0.200
    73.165     1.388     0.200
    73.166     0.981     0.200
    73.294     0.597     0.200
    73.299     0.505     0.200
    73.325    -0.045     0.200
    73.383     1.362     0.200
    73.404     6.979     0.200
    73.524     0.131     0.200
    73.583     0.593     0.200
    73.595     0.648     0.200
    73.593     0.687     0.200
    73.611     0.604     0.200
    73.703     1.250     0.200
    73.791     1.002     0.200
    73.811     0.818     0.200
    73.760     4.484     0.200
    73.883     0.867     0.200
    73.978     1.518     0.200
    74.111    -0.469     0.200
    74.135     0.258     0.200
    74.147    -0.292     0.200
    74.186    -0.339     0.200
    74.238     0.333     0.200
    74.250     0.967     0.200
    74.257     0.378     0.200
    74.356     0.956     0.200
    74.572     4.145     0.200
    74.702    -0.207     0.200
    74.787     0.628     0.200
    74.796     0.738     0.200
    74.806     0.114     0.200
    74.867     0.697     0.200
    74.898     0.412     0.200
    74.974     1.316     0.200
    75.071    -0.184     0.200
    75.071    -0.703     0.200
    75.109     0.265     0.200
    75.168    -3.698     0.200
    75.370     0.286     0.200
    75.374    -0.044     0.200
    75.434     0.043     0.200
    75.508     0.735     0.200
    75.769    -0.428     0.200
    75.811     0.070     0.200
    75.887     0.208     0.200
    75.905     0.125     0.200
    76.073     2.417     0.200
    76.087    -0.010     0.200
    76.186     1.804     0.200
    76.210     1.810     0.200
    76.308     0.469     0.200
    76.356     0.236     0.200
    76.506     0.859     0.200
    76.570     0.935     0.200
    76.597    -0.328     0.200
    76.610     0.049     0.200
    76.793     0.996     0.200
    77.025     1.110     0.200
    77.062     1.185     0.200
    77.143    -0.060     0.200
    77.502    -0.000     0.200
    77.676     0.541     0.200
    77.996     0.265     0.200
    78.021     1.763     0.200
    78.021     1.411     0.200
    78.218     0.058     0.200
    78.273    -0.277     0.200
    78.434     0.419     0.200
    79.100     0.116     0.200
    79.253     0.130     0.200
    79.339    -0.045     0.200
    79.661    -0.136     0.200
    79.879     0.117     0.200
    80.028     0.909     0.200
    80.247    -0.108     0.200
    80.313     0.407     0.200
    80.595     0.117     0.200
    80.667     0.176     0.200
    80.764     4.409     0.200
    80.750     2.730     0.200
    80.859     0.465     0.200
    80.882     2.479     0.200
    80.911     0.650     0.200
    81.003     0.728     0.200
    81.399     0.245     0.200
    81.605     0.621     0.200
    81.902     1.452     0.200
    82.204     0.223     0.200
    82.204     0.437     0.200
    82.331     1.558     0.200
    82.561     1.443     0.200
    82.583     1.263     0.200
    82.953     0.961     0.200
    83.613     0.579     0.200
    83.765    -0.183     0.200
    83.787     0.618     0.200
    83.886     0.080     0.200
    83.936     1.008     0.200
    83.983     0.850     0.200
    84.052     0.762     0.200
    84.052     1.196     0.200
    84.222     0.966     0.200
    84.444     0.750     0.200
    84.601     0.357     0.200
    84.617     1.105     0.200
    84.701     0.305     0.200
    84.737     1.414     0.200
    84.862     0.687     0.200
    85.111    -0.360     0.200
    85.401     0.308     0.200
    85.734     0.793     0.200
    85.849    -0.247     0.200
    85.997     1.343     0.200
    86.245     0.764     0.200
    86.250     1.092     0.200
    86.676     0.952     0.200
    86.744     0.710     0.200
    86.755     1.000     0.200
    86.910     0.219     0.200
    87.014     1.133     0.200
    88.065     0.285     0.200
    88.258     0.521     0.200
    88.490     0.503     0.200
    88.553     1.133     0.200
    88.763     0.469     0.200
    89.232     1.240     0.200
    89.286     0.415     0.200
    89.353     1.305     0.200
    89.513     1.375     0.200
    89.629     0.969     0.200
    90.003     0.880     0.200
    90.992     1.215     0.200
    91.185     1.530     0.200
    91.236     1.648     0.200
    91.434     1.011     0.200
    91.546     0.879     0.200
    91.699     1.026     0.200
    91.715     1.004     0.200
    91.802     0.410     0.200
    92.008     0.516     0.200
    92.440     1.436     0.200
    92.775     0.901     0.200
    93.345     1.800     0.200
    19.780     0.137     0.200
    21.286    -0.630     0.200
    30.263     1.342     0.200
    32.020     1.891     0.200
    47.648    -0.348     0.200
    68.708    -0.182     0.200
    30.257     1.536     0.200
    21.290    -0.090     0.200
    30.253     1.909     0.200
    62.011     0.026     0.200
    18.804    -0.260     0.200
    19.485     0.597     0.200
    19.634     0.483     0.200
    19.808    -0.506     0.200
    19.808     0.086     0.200
    19.812    -0.110     0.200
    19.852     0.670     0.200
    20.026     0.618     0.200
    20.072     0.053     0.200
    20.875    -2.298     0.200
    20.867     2.192     0.200
    21.031     2.440     0.200
    21.309    -0.452     0.200
    21.310     0.880     0.200
    21.841     3.306     0.200
    22.906     3.285     0.200
    22.906     2.805     0.200
    27.621    -1.835     0.200
    28.825     1.610     0.200
    30.243     0.636     0.200
    30.243     1.267     0.200
    31.234     1.350     0.200
    32.031     1.814     0.200
    32.031     1.283     0.200
    33.514     1.312     0.200
    38.600     0.709     0.200
    38.600     0.885     0.200
    38.688     1.269     0.200
    38.720     0.901     0.200
    38.787     0.727     0.200
    38.837     1.024     0.200
    39.074     0.938     0.200
    43.790     3.538     0.200
    43.790     2.833     0.200
    43.790     2.618     0.200
    44.171     1.635     0.200
    44.204     3.616     0.200
    44.204     2.157     0.200
    45.966     5.512     0.200
    47.104     1.508     0.200
    47.652     2.515     0.200
    47.652     0.415     0.200
    52.309     1.257     0.200
    52.937    -1.668     0.200
    52.937    -0.654     0.200
    58.536     3.822     0.200
    61.999     0.780     0.200
    62.360     0.002     0.200
    62.376     3.696     0.200
    66.872     1.837     0.200
    68.736    -0.306     0.200
    68.994     1.990     0.200
    69.842    -0.151     0.200
    70.329     0.558     0.200
    70.329    -0.516     0.200
    70.332     0.287     0.200
    72.900     0.960     0.200
    73.317     2.125     0.200
    73.962     0.827     0.200
    74.902     1.162     0.200
    75.542     0.467     0.200
    80.347     1.252     0.200
    80.700     1.774     0.200
    80.786     2.307     0.200
    82.237     1.079     0.200
    83.920     0.222     0.200
    89.383     0.503     0.200
    21.033     2.580     0.200
    21.301     0.163     0.200
    30.250     1.068     0.200
    47.651     0.506     0.200
    61.996     0.813     0.200
    68.726    -0.579     0.200
    18.093     0.828     0.200
    19.499    -0.117     0.200
    19.526    -0.218     0.200
    20.881    -0.421     0.200
    20.882    -0.489     0.200
    22.500    -0.006     0.200
    24.304    -1.538     0.200
    24.480     0.655     0.200
    27.372     0.375     0.200
    28.435    -1.046     0.200
    28.807    -1.324     0.200
    30.712     0.805     0.200
    30.712     0.344     0.200
    31.527    -0.086     0.200
    31.527    -0.383     0.200
    38.219     1.079     0.200
    38.219     1.450     0.200
    43.318     2.800     0.200
    43.705     0.580     0.200
    43.705    -0.131     0.200
    44.372    -0.569     0.200
    45.359    -1.436     0.200
    45.506     2.003     0.200
    45.639     0.447     0.200
    46.057     1.850     0.200
    46.600     1.151     0.200
    47.160     0.897     0.200
    47.160     1.299     0.200
    49.415     1.298     0.200
    57.821     1.473     0.200
    61.496     1.772     0.200
    61.857     2.117     0.200
    61.886     1.718     0.200
    64.009     0.400     0.200
    67.796    -0.081     0.200
    68.562    -0.440     0.200
    70.301     0.014     0.200
    70.301    -0.139     0.200
    72.639     1.693     0.200
    72.784    -1.870     0.200
    72.912     0.678     0.200
    73.054     1.966     0.200
    73.548     1.069     0.200
    82.193    -0.171     0.200
    83.826     1.623     0.200
    89.447     2.479     0.200
    89.594     2.516     0.200
    92.031     2.836     0.200
    20.746    -0.172     0.200
    47.246    -0.395     0.200
    19.318    -0.484     0.200
    19.469    -2.848     0.200
    19.641     0.025     0.200
    19.646    -3.401     0.200
    19.662    -3.403     0.200
    19.684    -3.402     0.200
    19.816    -1.273     0.200
    21.105    -0.408     0.200
    21.146    -3.385     0.200
    21.375    -3.519     0.200
    21.777    -1.643     0.200
    22.761     2.615     0.200
    24.569    -0.370     0.200
    24.776     1.156     0.200
    26.700    -1.313     0.200
    30.457     1.230     0.200
    30.457     0.129     0.200
    31.035     0.012     0.200
    31.819     0.499     0.200
    31.819    -1.642     0.200
    32.667    -4.210     0.200
    33.365     1.377     0.200
    33.365    -1.194     0.200
    33.365    -0.913     0.200
    37.811    -2.016     0.200
    38.581     0.847     0.200
    38.816     1.287     0.200
    38.816     0.740     0.200
    39.053     0.555     0.200
    39.290     0.969     0.200
    40.685    -1.148     0.200
    42.259    -0.750     0.200
    43.967     0.510     0.200
    44.001    -1.086     0.200
    45.901     1.022     0.200
    45.901    -1.384     0.200
    46.894    -0.837     0.200
    46.894     0.694     0.200
    47.156    -0.889     0.200
    51.281    -0.731     0.200
    58.060     0.368     0.200
    62.181    -0.413     0.200
    68.620    -0.113     0.200
    68.620    -0.668     0.200
    68.789    -1.461     0.200
    70.897     1.362     0.200
    72.696     1.022     0.200
    72.752     0.779     0.200
    73.041     0.654     0.200
    74.744     0.344     0.200
    74.980    -1.683     0.200
    78.908     1.139     0.200
    80.263    -0.734     0.200
    80.553     1.153     0.200
    82.174     0.502     0.200
    83.836    -0.571     0.200
    83.891    -0.280     0.200
    84.041    -0.123     0.200
    84.723    -0.971     0.200
    85.491    -0.828     0.200
    14.563     7.332     0.200
    21.127     0.001     0.200
    30.454     0.699     0.200
    47.462     0.740     0.200
    21.108     0.327     0.200
    47.454     1.555     0.200
    21.102     0.290     0.200
    30.458     1.420     0.200
    47.459     0.748     0.200
    61.792     0.981     0.200
    68.614    -1.019     0.200
    82.166     1.055     0.200
    20.929     0.358     0.200
    30.651     1.659     0.200
    47.248    -0.274     0.200
    68.554     0.088     0.200
    47.460     1.055     0.200
    14.360     9.330     0.200
    17.990     3.032     0.200
    20.814     0.959     0.200
    47.168     2.314     0.200
    21.070    -1.517     0.200
    47.249     1.605     0.200
    14.427     4.305     0.200
    14.906     4.122     0.200
    19.406    -0.445     0.200
    20.304    -0.688     0.200
    20.580    -0.468     0.200
    23.911     0.648     0.200
    28.202    -1.001     0.200
    30.985     0.672     0.200
    30.985     0.103     0.200
    31.119    -0.405     0.200
    31.432    -0.086     0.200
    32.488     0.717     0.200
    36.433     0.414     0.200
    37.648    -0.097     0.200
    37.714     1.780     0.200
    39.785     1.193     0.200
    39.785    -0.047     0.200
    46.567     1.375     0.200
    46.567    -0.472     0.200
    51.222     3.043     0.200
    67.919    -0.143     0.200
    68.645     1.010     0.200
    82.432     1.607     0.200
    19.486    -0.145     0.200
    20.627    -0.225     0.200
    47.425     0.479     0.200
    16.284     2.093     0.200
    17.874     1.845     0.200
    17.927     1.816     0.200
    18.252     0.023     0.200
    18.347     1.418     0.200
    18.494     3.706     0.200
    18.920     3.499     0.200
    19.112    -0.265     0.200
    19.354     0.024     0.200
    19.378    -1.449     0.200
    19.395    -0.359     0.200
    19.494     0.975     0.200
    19.622    -0.629     0.200
    20.097     3.701     0.200
    20.284     3.179     0.200
    20.536     3.251     0.200
    20.774    -0.006     0.200
    20.774    -0.463     0.200
    20.776    -0.277     0.200
    20.802     1.930     0.200
    20.994     1.390     0.200
    21.165    -0.058     0.200
    21.822    -1.115     0.200
    22.581     3.798     0.200
    24.475     0.953     0.200
    28.215     0.189     0.200
    28.313     0.504     0.200
    30.793     2.031     0.200
    31.504    -0.247     0.200
    31.504     0.632     0.200
    31.504     1.663     0.200
    31.504     0.175     0.200
    32.045     0.488     0.200
    38.214     0.436     0.200
    38.281     2.275     0.200
    39.151     0.850     0.200
    39.151     0.381     0.200
    39.151     0.577     0.200
    42.616     0.713     0.200
    43.356     0.503     0.200
    43.356     2.843     0.200
    43.356     3.554     0.200
    43.674     1.023     0.200
    43.707    -0.199     0.200
    43.707     2.313     0.200
    43.707     2.621     0.200
    45.392     1.980     0.200
    46.128     0.917     0.200
    46.585     1.690     0.200
    46.967    -2.175     0.200
    47.174     0.013     0.200
    47.174     2.732     0.200
    47.174    -0.397     0.200
    47.174     1.635     0.200
    52.799    -0.865     0.200
    52.799     1.029     0.200
    55.001    -0.874     0.200
    55.001     0.247     0.200
    68.211     0.196     0.200
    68.354     2.851     0.200
    68.400     0.466     0.200
    68.467    -0.339     0.200
    68.491     0.295     0.200
    70.659     1.909     0.200
    72.764     0.807     0.200
    73.618     0.848     0.200
    74.457    -0.209     0.200
    80.240     2.047     0.200
    82.027     0.642     0.200
    83.660     0.009     0.200
    89.287     1.539     0.200
    14.119     6.129     0.200
    14.911     6.000     0.200
    14.911     3.031     0.200
    14.912     5.814     0.200
    15.068     6.863     0.200
    15.223     6.588     0.200
    15.326     5.077     0.200
    15.430     4.103     0.200
    15.585     4.451     0.200
    15.772     4.179     0.200
    15.852     4.062     0.200
    16.089     6.531     0.200
    16.323     3.839     0.200
    16.490     4.229     0.200
    16.707     3.414     0.200
    16.926     4.383     0.200
    16.932     4.607     0.200
    17.000     4.816     0.200
    17.067     2.893     0.200
    17.123     3.310     0.200
    17.152     3.550     0.200
    17.797     1.635     0.200
    17.797     2.729     0.200
    17.879     1.572     0.200
    17.923     1.875     0.200
    18.070     6.079     0.200
    18.110     1.224     0.200
    18.143     3.074     0.200
    18.144     3.952     0.200
    18.223     1.898     0.200
    18.223     1.148     0.200
    18.239     1.909     0.200
    18.239     2.565     0.200
    18.344     0.821     0.200
    18.494     4.053     0.200
    18.526    -0.132     0.200
    18.920     3.264     0.200
    18.921     4.534     0.200
    19.089     0.014     0.200
    19.097     0.128     0.200
    19.120    -0.659     0.200
    19.169     0.559     0.200
    19.305    -0.535     0.200
    19.339    -0.021     0.200
    19.339    -0.974     0.200
    19.471    -0.570     0.200
    19.471    -0.367     0.200
    19.471     0.195     0.200
    19.501     0.415     0.200
    19.653    -0.074     0.200
    20.105     3.654     0.200
    20.293     1.126     0.200
    20.293     2.626     0.200
    20.319    -1.812     0.200
    20.331     0.763     0.200
    20.463     1.923     0.200
    20.469    -0.083     0.200
    20.469     2.526     0.200
    20.550     1.510     0.200
    20.620     1.023     0.200
    20.638     1.508     0.200
    20.760    -0.342     0.200
    20.761    -0.629     0.200
    20.800     3.216     0.200
    20.812     2.037     0.200
    21.163    -0.445     0.200
    21.210     0.531     0.200
    21.234     2.041     0.200
    21.422     4.439     0.200
    21.501     6.059     0.200
    21.720     1.526     0.200
    21.808    -0.980     0.200
    22.566     2.477     0.200
    22.580     0.927     0.200
    22.580     1.856     0.200
    22.580     1.067     0.200
    22.580     1.599     0.200
    23.229     1.641     0.200
    24.112     0.680     0.200
    24.467     0.339     0.200
    25.386     2.409     0.200
    27.319     0.115     0.200
    27.670     0.465     0.200
    28.201     0.698     0.200
    28.201     0.128     0.200
    28.298    -1.635     0.200
    30.806     0.581     0.200
    31.387     1.904     0.200
    31.387     3.123     0.200
    31.495    -0.088     0.200
    31.495    -0.244     0.200
    31.495     0.272     0.200
    32.038     0.421     0.200
    32.687     0.699     0.200
    34.193     2.089     0.200
    36.442     0.195     0.200
    37.207     0.137     0.200
    37.323     2.276     0.200
    37.637     1.761     0.200
    37.693     1.506     0.200
    37.740     1.727     0.200
    38.018     0.160     0.200
    38.018     1.566     0.200
    38.037     1.274     0.200
    38.068     1.331     0.200
    38.206     1.393     0.200
    38.206     1.151     0.200
    38.273     0.712     0.200
    38.744     1.948     0.200
    39.163     0.687     0.200
    39.163    -0.281     0.200
    39.722     2.702     0.200
    39.791     0.669     0.200
    40.292     1.520     0.200
    40.431     2.209     0.200
    40.431     1.576     0.200
    40.670     5.901     0.200
    40.890     0.579     0.200
    40.999     0.711     0.200
    40.999     2.484     0.200
    41.673     0.685     0.200
    41.706     1.296     0.200
    41.706     3.015     0.200
    42.615     1.086     0.200
    42.615     2.735     0.200
    42.753     1.341     0.200
    43.351     1.131     0.200
    43.351     2.803     0.200
    43.351     3.163     0.200
    43.386    -0.213     0.200
    43.666     0.010     0.200
    43.699    -0.160     0.200
    43.699     2.793     0.200
    43.699     0.902     0.200
    45.549     2.421     0.200
    46.101     1.021     0.200
    46.126     1.181     0.200
    46.126     3.111     0.200
    46.530     1.499     0.200
    46.576     0.329     0.200
    46.576     0.454     0.200
    46.576     0.633     0.200
    46.960     1.067     0.200
    47.168     1.009     0.200
    47.168     0.970     0.200
    49.406     1.330     0.200
    51.004     0.731     0.200
    51.833     5.010     0.200
    52.788     0.257     0.200
    52.788     0.070     0.200
    55.440     1.080     0.200
    57.343     0.673     0.200
    61.214     1.068     0.200
    61.473     1.294     0.200
    61.832     2.251     0.200
    61.897     3.916     0.200
    64.006     0.470     0.200
    68.115     0.227     0.200
    68.196     0.350     0.200
    68.386     0.841     0.200
    70.123    -0.626     0.200
    70.123     1.421     0.200
    70.656     1.462     0.200
    70.772    -0.318     0.200
    70.959     4.119     0.200
    70.996     2.492     0.200
    71.514     0.596     0.200
    71.591     1.130     0.200
    72.472     1.469     0.200
    72.749     0.887     0.200
    73.616     1.600     0.200
    73.616     1.366     0.200
    73.616     2.444     0.200
    73.719     0.044     0.200
    73.778     1.100     0.200
    74.940     0.518     0.200
    74.940     0.878     0.200
    75.840    -0.909     0.200
    77.487    -0.523     0.200
    77.999    -0.110     0.200
    78.611     0.010     0.200
    80.223     3.721     0.200
    80.231     0.728     0.200
    82.015     1.179     0.200
    83.845     0.948     0.200
    83.845     2.370     0.200
    84.235     1.026     0.200
    86.378     1.526     0.200
    86.548     0.666     0.200
    89.276     1.606     0.200
    89.415     1.126     0.200
    14.129     5.013     0.200
    14.338     4.166     0.200
    14.664     6.547     0.200
    14.738     4.426     0.200
    14.934     5.794     0.200
    14.934     4.435     0.200
    14.932     4.673     0.200
    15.322     6.049     0.200
    15.320     4.600     0.200
    15.347     5.656     0.200
    15.451     4.645     0.200
    15.605     4.338     0.200
    15.664     3.579     0.200
    15.793     4.037     0.200
    15.873     4.338     0.200
    16.036     4.110     0.200
    16.036     4.258     0.200
    16.068     4.594     0.200
    16.070     6.165     0.200
    16.022     2.171     0.200
    16.089     5.557     0.200
    16.132     4.689     0.200
    16.215     4.569     0.200
    16.287     4.225     0.200
    16.351     4.925     0.200
    16.397     5.721     0.200
    16.432     2.181     0.200
    16.511     4.251     0.200
    16.511     3.665     0.200
    16.729     3.279     0.200
    16.890     3.881     0.200
    16.926     4.938     0.200
    16.926     4.430     0.200
    16.937     2.236     0.200
    17.055     2.606     0.200
    17.003     4.227     0.200
    17.123     4.158     0.200
    17.075     5.703     0.200
    17.149     4.244     0.200
    17.201     5.385     0.200
    17.253     2.009     0.200
    17.267     3.131     0.200
    17.345     1.986     0.200
    17.345     2.775     0.200
    17.366     2.353     0.200
    17.422     4.862     0.200
    17.715     3.804     0.200
    17.761     3.633     0.200
    17.762     1.523     0.200
    17.761     5.320     0.200
    17.818     2.510     0.200
    17.826     3.273     0.200
    17.878     2.228     0.200
    17.869     1.977     0.200
    17.894     4.445     0.200
    17.931     0.486     0.200
    17.919     1.982     0.200
    17.940     0.667     0.200
    17.940     1.846     0.200
    17.940     2.503     0.200
    18.031     2.409     0.200
    18.068     3.549     0.200
    18.077     2.841     0.200
    18.101     2.872     0.200
    18.077     4.650     0.200
    18.134    -0.189     0.200
    18.131     1.988     0.200
    18.137     2.209     0.200
    18.140     3.570     0.200
    18.140     1.156     0.200
    18.146     2.736     0.200
    18.238     2.073     0.200
    18.238     0.112     0.200
    18.238     3.261     0.200
    18.261     1.335     0.200
    18.259     1.512     0.200
    18.259     0.606     0.200
    18.339     2.997     0.200
    18.339    -0.604     0.200
    18.370     0.704     0.200
    18.351     1.706     0.200
    18.403    -0.925     0.200
    18.497     5.039     0.200
    18.519    -2.068     0.200
    18.642    -0.569     0.200
    18.756     3.262     0.200
    18.802    -0.282     0.200
    18.862     2.596     0.200
    18.891     0.472     0.200
    18.941     1.112     0.200
    18.923     4.161     0.200
    19.036    -0.673     0.200
    19.104    -2.766     0.200
    19.112    -3.053     0.200
    19.111    -0.240     0.200
    19.191    -3.625     0.200
    19.191     1.008     0.200
    19.177     3.129     0.200
    19.296    -1.071     0.200
    19.326     0.093     0.200
    19.361     0.420     0.200
    19.361     0.170     0.200
    19.472    -0.481     0.200
    19.489    -2.168     0.200
    19.489    -1.160     0.200
    19.489    -1.277     0.200
    19.489    -0.465     0.200
    19.494     0.731     0.200
    19.551     3.191     0.200
    19.639     3.316     0.200
    20.062     0.299     0.200
    20.096     1.733     0.200
    20.204    -0.406     0.200
    20.283     2.357     0.200
    20.337    -1.322     0.200
    20.431     4.132     0.200
    20.476    -0.471     0.200
    20.476     0.661     0.200
    20.476     1.169     0.200
    20.535     1.033     0.200
    20.529    -0.313     0.200
    20.529     5.288     0.200
    20.658     0.564     0.200
    20.665     0.871     0.200
    20.635    -0.852     0.200
    20.645     1.365     0.200
    20.781    -1.169     0.200
    20.781    -0.114     0.200
    20.783    -0.807     0.200
    20.801     2.132     0.200
    20.805     3.395     0.200
    21.170     3.462     0.200
    21.218     0.422     0.200
    21.231     1.149     0.200
    21.425     3.921     0.200
    21.505     3.852     0.200
    21.623     1.909     0.200
    21.741     1.583     0.200
    21.829    -0.719     0.200
    22.568     3.340     0.200
    22.584     1.246     0.200
    22.584     1.668     0.200
    22.584     2.980     0.200
    22.584     2.238     0.200
    22.798     0.494     0.200
    23.250     1.703     0.200
    24.071    -2.442     0.200
    24.133     2.789     0.200
    24.163     1.917     0.200
    24.481     0.218     0.200
    24.570     2.543     0.200
    24.735     0.866     0.200
    25.408     2.928     0.200
    25.604    -0.350     0.200
    26.155    -0.209     0.200
    26.365     0.335     0.200
    26.443     3.097     0.200
    27.336    -0.235     0.200
    27.600     0.122     0.200
    27.692     2.583     0.200
    27.946     0.401     0.200
    28.222    -0.525     0.200
    28.222     0.264     0.200
    28.320     0.482     0.200
    28.320    -1.635     0.200
    28.320    -0.088     0.200
    29.325     1.075     0.200
    30.786     0.108     0.200
    30.786     1.968     0.200
    31.380     0.019     0.200
    31.380     2.847     0.200
    31.380     3.519     0.200
    31.380     3.394     0.200
    31.511    -0.511     0.200
    31.511    -0.065     0.200
    31.511     0.130     0.200
    32.050    -1.373     0.200
    32.703     1.073     0.200
    33.684     2.015     0.200
    34.266     2.306     0.200
    36.213     2.214     0.200
    36.464     0.732     0.200
    37.056     1.891     0.200
    37.321     0.942     0.200
    37.321     1.575     0.200
    37.361     1.963     0.200
    37.509     1.640     0.200
    37.570     2.397     0.200
    37.570     1.756     0.200
    37.594     0.733     0.200
    37.689     1.827     0.200
    37.730     1.635     0.200
    37.802    -0.024     0.200
    37.802     2.015     0.200
    37.874     1.636     0.200
    38.018     3.801     0.200
    38.015     1.792     0.200
    38.015     1.542     0.200
    38.033     1.266     0.200
    38.033     1.672     0.200
    38.065     1.113     0.200
    38.065     1.597     0.200
    38.220     0.940     0.200
    38.220     1.245     0.200
    38.220     1.659     0.200
    38.221     1.208     0.200
    38.221     1.888     0.200
    38.287     1.111     0.200
    38.628     2.201     0.200
    38.741     0.606     0.200
    38.741     1.919     0.200
    39.104     6.125     0.200
    39.144     2.422     0.200
    39.219     1.931     0.200
    39.381     3.015     0.200
    39.618     3.037     0.200
    39.640     1.818     0.200
    39.729     3.664     0.200
    39.810    -0.261     0.200
    39.810     3.544     0.200
    39.992     1.333     0.200
    39.992     1.232     0.200
    40.074     2.364     0.200
    40.441     0.832     0.200
    40.495     1.929     0.200
    40.592     1.977     0.200
    40.676     3.402     0.200
    40.827     4.050     0.200
    40.897     0.536     0.200
    40.897     3.053     0.200
    40.960     2.213     0.200
    41.006     3.199     0.200
    41.102     2.837     0.200
    41.330     2.829     0.200
    41.411     3.893     0.200
    41.439     2.596     0.200
    41.681    -0.092     0.200
    41.713     4.532     0.200
    41.733     2.612     0.200
    41.774     1.344     0.200
    42.043     2.101     0.200
    42.109     1.698     0.200
    42.281     1.306     0.200
    42.434     0.784     0.200
    42.620    -0.134     0.200
    42.620     3.483     0.200
    42.864    -1.427     0.200
    42.864     1.471     0.200
    42.855     2.932     0.200
    42.978     3.159     0.200
    43.152     2.584     0.200
    43.361     3.225     0.200
    43.361     0.483     0.200
    43.361     2.139     0.200
    43.361     3.343     0.200
    43.415     2.815     0.200
    43.668     4.026     0.200
    43.680     0.449     0.200
    43.713     3.200     0.200
    43.713     0.309     0.200
    43.713     1.270     0.200
    44.025     4.698     0.200
    44.203     1.423     0.200
    44.347     1.256     0.200
    44.796     0.992     0.200
    44.830     1.361     0.200
    44.830     1.260     0.200
    44.938     1.247     0.200
    45.426     1.571     0.200
    45.558     1.279     0.200
    45.884     1.287     0.200
    45.904     1.351     0.200
    45.904     1.249     0.200
    45.946     1.437     0.200
    46.131     4.064     0.200
    46.131     3.462     0.200
    46.292     1.536     0.200
    46.592     0.384     0.200
    46.592     1.337     0.200
    46.874     1.387     0.200
    46.972    -2.104     0.200
    46.972     1.349     0.200
    47.167     2.987     0.200
    47.180     1.034     0.200
    47.180     1.190     0.200
    48.605     1.280     0.200
    49.420     0.753     0.200
    51.845     5.953     0.200
    52.802     0.648     0.200
    58.144     4.767     0.200
    58.373    -2.130     0.200
    59.093     0.675     0.200
    60.510    -1.608     0.200
    63.054    -1.575     0.200
    63.221     2.016     0.200
    66.173     0.599     0.200
    66.988     2.585     0.200
    67.250     3.505     0.200
    67.649     0.517     0.200
    67.741    -1.702     0.200
    67.803     1.168     0.200
    67.803     0.418     0.200
    68.107     1.007     0.200
    68.136     3.128     0.200
    68.217     0.684     0.200
    68.231     0.758     0.200
    68.231     2.266     0.200
    68.295     1.380     0.200
    68.321    -0.040     0.200
    68.361    -0.054     0.200
    68.361    -0.319     0.200
    68.367     0.657     0.200
    68.405     0.803     0.200
    68.450     4.194     0.200
    68.473     1.743     0.200
    68.497    -0.170     0.200
    68.592     5.313     0.200
    68.672     3.458     0.200
    68.882     3.035     0.200
    68.998     2.544     0.200
    69.033     1.664     0.200
    69.033     3.594     0.200
    69.063     1.788     0.200
    69.094     0.397     0.200
    69.217     4.001     0.200
    69.234     0.316     0.200
    69.234     2.691     0.200
    69.256     1.312     0.200
    69.305     3.629     0.200
    69.385     3.754     0.200
    69.478     2.115     0.200
    69.591     2.314     0.200
    69.616     3.484     0.200
    69.645     3.469     0.200
    69.699     0.682     0.200
    69.699     1.284     0.200
    69.729     4.330     0.200
    69.802     3.017     0.200
    69.809     3.545     0.200
    69.869     1.164     0.200
    69.869     3.891     0.200
    69.901     0.573     0.200
    69.901     2.159     0.200
    69.928     3.046     0.200
    70.006     3.890     0.200
    70.027     2.578     0.200
    70.139     1.722     0.200
    70.189     1.535     0.200
    70.189     1.277     0.200
    70.201    -0.312     0.200
    70.217     2.685     0.200
    70.315     1.737     0.200
    70.321     2.603     0.200
    70.425     2.586     0.200
    70.542     2.590     0.200
    70.672     2.594     0.200
    70.664     1.057     0.200
    70.736     3.915     0.200
    70.750     1.727     0.200
    70.785     2.581     0.200
    70.751    -0.044     0.200
    70.872     3.169     0.200
    70.910     2.591     0.200
    70.941     3.492     0.200
    71.019     3.021     0.200
    71.074     2.326     0.200
    71.111     2.617     0.200
    71.166     1.370     0.200
    71.166     3.463     0.200
    71.209     3.456     0.200
    71.265     1.302     0.200
    71.265     3.044     0.200
    71.345     5.573     0.200
    71.386     4.328     0.200
    71.517     1.533     0.200
    71.517     3.463     0.200
    71.534     3.493     0.200
    71.612     3.367     0.200
    71.817     4.442     0.200
    71.825     2.609     0.200
    71.831     2.600     0.200
    71.898     4.459     0.200
    71.995     3.137     0.200
    72.071     2.613     0.200
    72.071     4.934     0.200
    72.078     4.343     0.200
    72.156     1.542     0.200
    72.177     4.444     0.200
    72.400     3.514     0.200
    72.410     3.600     0.200
    72.416     3.031     0.200
    72.489     3.635     0.200
    72.551     1.091     0.200
    72.644    -0.158     0.200
    72.650     2.680     0.200
    72.713     4.010     0.200
    72.723     1.908     0.200
    72.738     4.953     0.200
    72.758     3.586     0.200
    72.762     4.444     0.200
    72.796     1.275     0.200
    72.946     4.773     0.200
    73.089     4.769     0.200
    73.130     2.609     0.200
    73.161     1.553     0.200
    73.161     3.475     0.200
    73.165     2.639     0.200
    73.207     2.182     0.200
    73.388     4.737     0.200
    73.509     5.212     0.200
    73.562     5.767     0.200
    73.589     3.486     0.200
    73.790     1.683     0.200
    73.799     4.369     0.200
    73.815     3.329     0.200
    73.846     4.338     0.200
    73.876     4.382     0.200
    73.975     1.309     0.200
    73.975     5.333     0.200
    74.041     4.915     0.200
    74.099     4.488     0.200
    74.113     5.409     0.200
    74.246     5.771     0.200
    74.307     4.393     0.200
    74.360     5.359     0.200
    74.474     2.126     0.200
    74.479     3.410     0.200
    74.464     1.137     0.200
    74.566     3.956     0.200
    74.593     0.885     0.200
    74.784     1.923     0.200
    74.784     4.462     0.200
    74.823     3.070     0.200
    74.833     4.461     0.200
    74.867     5.407     0.200
    74.904     5.960     0.200
    74.904     2.219     0.200
    74.940     1.183     0.200
    74.954    -0.657     0.200
    74.954     0.460     0.200
    74.997     4.479     0.200
    75.029     3.527     0.200
    75.180     3.956     0.200
    75.250     5.735     0.200
    75.270     4.716     0.200
    75.572     5.804     0.200
    75.658     5.842     0.200
    75.655     3.925     0.200
    75.701    -0.606     0.200
    75.729     5.819     0.200
    75.734     5.269     0.200
    75.765     6.161     0.200
    75.815     5.365     0.200
    75.852    -0.383     0.200
    75.898     4.438     0.200
    75.910     5.826     0.200
    75.930     5.854     0.200
    75.953     1.316     0.200
    76.003     3.520     0.200
    76.003     4.911     0.200
    76.049     1.852     0.200
    76.073     3.925     0.200
    76.179     2.097     0.200
    76.189     1.438     0.200
    76.190     2.643     0.200
    76.216     2.889     0.200
    76.236     3.930     0.200
    76.249     3.600     0.200
    76.303     4.102     0.200
    76.394     3.976     0.200
    76.392     3.942     0.200
    76.360    -1.073     0.200
    76.451    -0.378     0.200
    76.584     4.502     0.200
    76.601     3.963     0.200
    76.627     4.120     0.200
    76.648     4.531     0.200
    76.664     0.354     0.200
    76.664     2.745     0.200
    76.744     2.747     0.200
    76.751     2.630     0.200
    76.780     2.365     0.200
    77.034     5.307     0.200
    77.338     2.632     0.200
    77.603     1.323     0.200
    77.922     3.079     0.200
    78.624    -1.216     0.200
    78.807    -0.597     0.200
    78.807    -0.308     0.200
    79.620     1.273     0.200
    80.192    -0.420     0.200
    80.269     0.230     0.200
    80.766     0.560     0.200
    81.757     3.659     0.200
    81.865     1.792     0.200
    82.031     1.404     0.200
    82.031     1.257     0.200
    82.513     2.553     0.200
    82.732     2.812     0.200
    83.538     3.114     0.200
    83.538     4.794     0.200
    83.821     1.477     0.200
    83.862     2.621     0.200
    83.801    -2.460     0.200
    83.928     2.423     0.200
    84.379    -1.924     0.200
    84.605     2.318     0.200
    84.689    -2.973     0.200
    86.562     1.394     0.200
    87.103    -0.428     0.200
    88.308     3.234     0.200
    88.465     1.183     0.200
    88.619     1.917     0.200
    89.125     1.137     0.200
    89.289     1.478     0.200
    89.289     2.853     0.200
    89.432     2.503     0.200
    90.869     1.691     0.200
    90.869     1.543     0.200
    92.608     2.317     0.200
    92.611     3.735     0.200
    93.184     2.761     0.200
    14.928     6.671     0.200
    14.928     4.311     0.200
    15.313     5.351     0.200
    15.445     5.251     0.200
    16.267     7.167     0.200
    16.510     3.756     0.200
    16.510     4.139     0.200
    17.816     2.172     0.200
    17.816     3.149     0.200
    17.885     1.361     0.200
    17.954     1.306     0.200
    18.057     6.202     0.200
    18.133     1.425     0.200
    18.254     0.314     0.200
    18.256     1.710     0.200
    18.343    -1.743     0.200
    18.477     4.071     0.200
    18.843     5.276     0.200
    18.903     6.508     0.200
    19.041    -1.151     0.200
    19.090    -0.400     0.200
    19.092    -0.112     0.200
    19.196    -0.919     0.200
    19.158     1.558     0.200
    19.283     1.087     0.200
    19.325     0.462     0.200
    19.366    -0.419     0.200
    19.370    -0.442     0.200
    19.389     0.161     0.200
    19.406    -1.155     0.200
    19.479    -0.006     0.200
    19.479     0.408     0.200
    19.481    -0.474     0.200
    19.540    -0.193     0.200
    19.475     0.658     0.200
    19.633    -0.186     0.200
    19.620     3.759     0.200
    20.077     3.249     0.200
    20.265     2.153     0.200
    20.265     3.333     0.200
    20.328     0.900     0.200
    20.458     0.856     0.200
    20.465     1.896     0.200
    20.534     3.851     0.200
    20.780    -1.375     0.200
    20.780    -0.500     0.200
    20.780     0.000     0.200
    20.781    -1.005     0.200
    20.818     2.676     0.200
    20.977    -0.782     0.200
    21.230     1.654     0.200
    21.219     1.162     0.200
    21.406     4.106     0.200
    21.817     0.666     0.200
    22.548     5.823     0.200
    22.565     0.786     0.200
    23.247     3.411     0.200
    24.053    -2.149     0.200
    24.467     1.368     0.200
    25.406     2.919     0.200
    27.326     0.686     0.200
    28.321    -0.372     0.200
    28.321    -0.474     0.200
    28.321     2.198     0.200
    30.792     1.402     0.200
    31.499    -0.448     0.200
    32.035    -0.483     0.200
    32.035    -0.249     0.200
    36.463    -0.279     0.200
    36.464    -0.886     0.200
    36.465    -0.642     0.200
    36.467    -0.392     0.200
    36.467    -0.404     0.200
    37.995     0.621     0.200
    38.207     0.655     0.200
    38.207     1.295     0.200
    38.274     1.482     0.200
    39.151     0.266     0.200
    39.821     0.807     0.200
    40.424     1.643     0.200
    40.424     0.791     0.200
    40.424     2.002     0.200
    41.695     1.912     0.200
    43.344     4.212     0.200
    43.379     0.780     0.200
    43.666     1.594     0.200
    43.699     0.133     0.200
    43.699     4.157     0.200
    45.540     5.854     0.200
    46.579     0.594     0.200
    46.579    -0.008     0.200
    46.579     1.000     0.200
    46.957     0.164     0.200
    47.165     0.528     0.200
    47.165     0.637     0.200
    47.165     1.137     0.200
    47.165     2.590     0.200
    49.406     1.595     0.200
    51.033    -0.051     0.200
    61.475     1.946     0.200
    61.475     0.555     0.200
    61.475     1.735     0.200
    61.541     0.302     0.200
    61.835     2.011     0.200
    61.998     0.547     0.200
    63.861    -0.693     0.200
    67.221    -0.975     0.200
    67.431    -0.138     0.200
    67.905     0.096     0.200
    68.361     3.627     0.200
    68.483    -0.140     0.200
    70.647     1.904     0.200
    70.876     1.640     0.200
    70.915     1.185     0.200
    72.422     1.625     0.200
    72.776     0.959     0.200
    73.603     1.208     0.200
    73.603     2.411     0.200
    74.480     1.371     0.200
    78.610    -0.792     0.200
    82.046     1.556     0.200
    89.306     1.463     0.200
    20.775    -1.611     0.200
    38.273    -0.215     0.200
    14.389     8.207     0.200
    20.767    -1.177     0.200
    21.541    -1.413     0.200
    47.634     2.301     0.200
    21.553    -0.352     0.200
    21.553     0.225     0.200
    38.820     1.596     0.200
    47.645    -0.010     0.200
    21.642     0.642     0.200
    47.482     0.688     0.200
    69.356     1.766     0.200
    14.846     6.163     0.200
    19.422     0.279     0.200
    20.233     1.408     0.200
    20.688    -0.422     0.200
    20.689    -0.890     0.200
    46.274     0.973     0.200
    46.817     1.858     0.200
    46.817     1.712     0.200
    48.447     0.831     0.200
    54.004     0.446     0.200
    61.169     2.039     0.200
    63.168     0.893     0.200
    64.098     0.283     0.200
    68.159     1.621     0.200
    68.583     0.653     0.200
    68.587     0.541     0.200
    69.143     0.102     0.200
    70.415     0.362     0.200
    72.209     2.078     0.200
    72.848     1.394     0.200
    73.887     2.241     0.200
    89.630     2.146     0.200
    95.995     6.332     0.200
    38.657     1.350     0.200
    47.515     1.326     0.200
    14.352     5.585     0.200
    18.590    -1.007     0.200
    19.614    -0.147     0.200
    20.670     1.479     0.200
    21.012    -0.469     0.200
    38.403     0.698     0.200
    47.270     1.122     0.200
    73.625     3.188     0.200
    20.634    -0.687     0.200
    47.600     0.785     0.200
    14.224    10.964     0.200
    14.468     8.584     0.200
    14.516     4.421     0.200
    14.677     6.573     0.200
    14.834     8.642     0.200
    15.137     4.774     0.200
    15.477     6.105     0.200
    15.481     5.722     0.200
    15.531     4.961     0.200
    15.660     3.691     0.200
    16.710     1.602     0.200
    16.814     4.501     0.200
    16.814     5.407     0.200
    16.832     5.673     0.200
    16.885     1.973     0.200
    16.911     1.752     0.200
    16.920     5.960     0.200
    16.959     5.203     0.200
    17.014     4.246     0.200
    17.015     3.516     0.200
    17.218     2.438     0.200
    17.218     1.258     0.200
    17.218     3.578     0.200
    17.601     4.507     0.200
    17.632     2.004     0.200
    17.638     4.232     0.200
    17.688     1.873     0.200
    17.780     2.121     0.200
    17.940     5.050     0.200
    18.281     1.713     0.200
    18.465    -0.416     0.200
    18.510    -0.979     0.200
    18.510     0.210     0.200
    19.066     0.213     0.200
    19.144     0.409     0.200
    19.305    -0.816     0.200
    19.314    -1.815     0.200
    19.381     0.661     0.200
    19.500    -0.142     0.200
    19.524     0.714     0.200
    19.525    -0.252     0.200
    19.674     0.114     0.200
    19.698     0.026     0.200
    19.700    -0.274     0.200
    19.700    -0.610     0.200
    19.700    -1.509     0.200
    19.700    -1.032     0.200
    19.699    -0.628     0.200
    19.867    -0.250     0.200
    20.320     1.292     0.200
    20.549    -2.869     0.200
    20.575     1.167     0.200
    20.632    -0.269     0.200
    20.639     0.363     0.200
    20.639     1.457     0.200
    20.702     1.075     0.200
    20.806     1.444     0.200
    20.835    -0.367     0.200
    20.855     0.412     0.200
    20.928     1.434     0.200
    20.982     0.024     0.200
    20.982    -0.523     0.200
    21.428    -0.023     0.200
    21.744     0.402     0.200
    22.167     0.538     0.200
    22.297    -0.164     0.200
    22.337     1.339     0.200
    22.722     1.874     0.200
    22.722     1.397     0.200
    22.722     1.530     0.200
    22.967     1.667     0.200
    23.196     0.658     0.200
    23.455     0.941     0.200
    23.480     1.193     0.200
    24.216    -0.436     0.200
    24.230    -3.951     0.200
    24.328    -2.456     0.200
    24.653     0.547     0.200
    24.682     0.530     0.200
    26.741    -0.205     0.200
    27.547     0.220     0.200
    27.892    -2.061     0.200
    28.510     0.532     0.200
    28.510     0.103     0.200
    31.614    -0.654     0.200
    32.241    -0.070     0.200
    32.241     0.140     0.200
    32.910     0.996     0.200
    36.640     0.344     0.200
    37.948     0.987     0.200
    37.948     0.385     0.200
    38.093     0.960     0.200
    38.488     1.283     0.200
    38.932     1.088     0.200
    38.932     0.705     0.200
    40.616     0.811     0.200
    41.563     1.014     0.200
    42.053     1.301     0.200
    42.765     1.263     0.200
    42.934     0.216     0.200
    42.949     0.896     0.200
    43.538     0.890     0.200
    43.538     1.960     0.200
    43.878     0.896     0.200
    43.911     0.114     0.200
    43.911     0.857     0.200
    44.125     0.546     0.200
    44.591     1.356     0.200
    44.909     1.112     0.200
    45.578     1.255     0.200
    45.586     2.697     0.200
    45.578     2.060     0.200
    45.783     0.118     0.200
    45.783    -0.077     0.200
    46.160     1.001     0.200
    46.280     1.027     0.200
    46.290     1.545     0.200
    46.723     0.292     0.200
    46.796     0.475     0.200
    46.796     0.577     0.200
    46.796    -0.595     0.200
    46.796     0.475     0.200
    47.164     0.070     0.200
    47.245     1.669     0.200
    47.372     1.280     0.200
    47.372     0.780     0.200
    47.372     1.030     0.200
    47.372     0.358     0.200
    49.619     1.371     0.200
    52.034     1.682     0.200
    52.837     0.473     0.200
    52.837     0.270     0.200
    53.905    -0.196     0.200
    55.308    -0.577     0.200
    55.454    -0.379     0.200
    56.295     1.018     0.200
    56.727     1.338     0.200
    56.765     1.770     0.200
    56.926     2.121     0.200
    57.564     0.614     0.200
    57.938     1.894     0.200
    57.938     0.573     0.200
    58.128     0.862     0.200
    58.223     0.551     0.200
    58.223     2.090     0.200
    58.299    -0.735     0.200
    58.531     1.647     0.200
    58.728     0.043     0.200
    58.898     1.285     0.200
    59.194     1.053     0.200
    59.597     0.653     0.200
    60.189     0.879     0.200
    60.230     1.204     0.200
    61.692     1.447     0.200
    61.692     0.759     0.200
    61.695     1.352     0.200
    62.023     1.942     0.200
    62.052     0.649     0.200
    63.927    -0.016     0.200
    64.237    -0.197     0.200
    64.237     0.248     0.200
    66.599     1.659     0.200
    67.738     0.365     0.200
    67.911     0.161     0.200
    67.937     0.873     0.200
    68.520    -0.522     0.200
    68.520     0.056     0.200
    68.555     1.200     0.200
    68.789     5.946     0.200
    69.858    -0.029     0.200
    69.858     0.729     0.200
    70.103     0.400     0.200
    70.196     1.128     0.200
    70.196     0.621     0.200
    70.196     1.449     0.200
    70.411     1.735     0.200
    70.600     0.834     0.200
    70.600     0.287     0.200
    70.880     0.190     0.200
    71.039     1.043     0.200
    71.160     1.574     0.200
    71.226     0.678     0.200
    71.867     3.516     0.200
    72.639     0.962     0.200
    72.827     1.682     0.200
    72.926     1.297     0.200
    73.359     0.863     0.200
    73.771     0.415     0.200
    73.771     0.829     0.200
    73.771     2.712     0.200
    73.791     1.896     0.200
    73.871     0.721     0.200
    73.938    -0.056     0.200
    73.949     0.571     0.200
    74.339     1.192     0.200
    74.629     1.388     0.200
    74.673     1.955     0.200
    74.947     0.870     0.200
    74.995     0.334     0.200
    75.836     1.763     0.200
    76.161     0.582     0.200
    77.705     1.717     0.200
    77.715    -0.334     0.200
    77.715    -0.139     0.200
    77.715     0.454     0.200
    77.715     0.040     0.200
    79.693     0.744     0.200
    79.724     1.705     0.200
    79.788     0.404     0.200
    80.175     1.351     0.200
    80.440     1.740     0.200
    80.454    -0.137     0.200
    80.454     1.660     0.200
    80.453     0.669     0.200
    80.454     1.457     0.200
    80.453     0.419     0.200
    80.670     1.068     0.200
    80.794     1.052     0.200
    81.258     1.125     0.200
    82.095     0.771     0.200
    82.095     1.123     0.200
    82.474     1.187     0.200
    83.748     1.284     0.200
    83.927     1.284     0.200
    83.972     1.705     0.200
    84.600     0.946     0.200
    85.445     0.797     0.200
    86.605     2.001     0.200
    86.605     1.102     0.200
    90.912     1.681     0.200
    18.345     1.106     0.200
    18.906     1.953     0.200
    19.201    -0.453     0.200
    19.368     0.024     0.200
    19.623    -0.516     0.200
    20.107    -0.236     0.200
    20.465     0.292     0.200
    20.631     0.457     0.200
    20.783    -0.267     0.200
    20.783     0.023     0.200
    20.813     0.005     0.200
    21.587     0.324     0.200
    22.799     1.351     0.200
    31.400     0.131     0.200
    37.998     0.309     0.200
    38.278     0.995     0.200
    40.428     1.397     0.200
    46.584     0.768     0.200
    47.170     1.785     0.200
    47.170     0.820     0.200
    58.512     0.910     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   111.655     0.089     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    20.636   248.884     0.200
    21.120   247.644     0.200
    73.133    24.062     0.200
    37.932   140.091     0.200
    43.389   106.018     0.200
    64.116    38.062     0.200
    65.606    32.554     0.200
    68.537    28.425     0.200
    72.219    19.911     0.200
    76.083     9.354     0.200
    80.324     5.956     0.200
    81.158    10.194     0.200
    43.418   107.542     0.200
    45.588   100.203     0.200
    59.066    54.138     0.200
    64.144    37.976     0.200
    68.568    26.541     0.200
    73.841    16.622     0.200
    76.113    10.301     0.200
    81.186     6.766     0.200
    51.923    75.995     0.200
    79.799     9.413     0.200
    19.773   257.385     0.200
    23.180   232.575     0.200
    28.794   189.637     0.200
    32.016   166.629     0.200
    80.764     9.409     0.200
    20.760   249.408     0.200
    28.298   192.662     0.200
    64.006    38.189     0.200
    20.781   248.956     0.200
    28.320   192.716     0.200
    31.511   172.036     0.200
    51.845    74.156     0.200
    68.361    25.681     0.200
    20.780   248.547     0.200
    28.321   192.378     0.200
    31.499   171.372     0.200
    68.361    28.330     0.200
    36.640   143.594     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
