#!/bin/bash
gmt begin larino1.84_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times larino1.84'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.034
    25.500   327.577
    26.000   332.108
    26.500   336.628
    27.000   341.136
    27.500   345.627
    28.000   350.098
    28.500   354.553
    29.000   358.998
    29.500   363.434
    30.000   367.862
    30.500   372.283
    31.000   376.695
    31.500   381.100
    32.000   385.497
    32.500   389.884
    33.000   394.261
    33.500   398.625
    34.000   402.974
    34.500   407.309
    35.000   411.629
    35.500   415.933
    36.000   420.223
    36.500   424.497
    37.000   428.756
    37.500   432.999
    38.000   437.226
    38.500   441.437
    39.000   445.632
    39.500   449.810
    40.000   453.970
    40.500   458.113
    41.000   462.240
    41.500   466.349
    42.000   470.442
    42.500   474.517
    43.000   478.574
    43.500   482.615
    44.000   486.637
    44.500   490.641
    45.000   494.628
    45.500   498.597
    46.000   502.548
    46.500   506.481
    47.000   510.395
    47.500   514.292
    48.000   518.171
    48.500   522.031
    49.000   525.873
    49.500   529.697
    50.000   533.503
    50.500   537.291
    51.000   541.060
    51.500   544.811
    52.000   548.544
    52.500   552.259
    53.000   555.956
    53.500   559.635
    54.000   563.297
    54.500   566.940
    55.000   570.564
    55.500   574.170
    56.000   577.758
    56.500   581.327
    57.000   584.878
    57.500   588.410
    58.000   591.925
    58.500   595.422
    59.000   598.900
    59.500   602.360
    60.000   605.802
    60.500   609.225
    61.000   612.630
    61.500   616.016
    62.000   619.385
    62.500   622.735
    63.000   626.067
    63.500   629.381
    64.000   632.678
    64.500   635.956
    65.000   639.217
    65.500   642.460
    66.000   645.685
    66.500   648.891
    67.000   652.080
    67.500   655.250
    68.000   658.403
    68.500   661.537
    69.000   664.653
    69.500   667.750
    70.000   670.830
    70.500   673.892
    71.000   676.935
    71.500   679.960
    72.000   682.968
    72.500   685.957
    73.000   688.927
    73.500   691.879
    74.000   694.812
    74.500   697.727
    75.000   700.623
    75.500   703.500
    76.000   706.359
    76.500   709.200
    77.000   712.022
    77.500   714.827
    78.000   717.614
    78.500   720.382
    79.000   723.132
    79.500   725.864
    80.000   728.577
    80.500   731.272
    81.000   733.946
    81.500   736.602
    82.000   739.238
    82.500   741.856
    83.000   744.455
    83.500   747.035
    84.000   749.596
    84.500   752.136
    85.000   754.655
    85.500   757.155
    86.000   759.637
    86.500   762.100
    87.000   764.546
    87.500   766.969
    88.000   769.357
    88.500   771.723
    89.000   774.077
    89.500   776.422
    90.000   778.760
    90.500   781.091
    91.000   783.416
    91.500   785.735
    92.000   788.050
    92.500   790.360
    93.000   792.667
    93.500   794.971
    94.000   797.271
    94.500   799.567
    95.000   801.857
    95.500   804.141
    96.000   806.419
    96.500   808.690
    97.000   810.956
    97.500   813.214
    98.000   815.465
    98.500   817.709
    99.000   819.946
    99.500   822.174
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.169
   116.000  1122.131
   116.500  1123.093
   117.000  1124.055
   117.500  1125.017
   118.000  1125.979
   118.500  1126.941
   119.000  1127.902
   119.500  1128.864
   120.000  1129.825
   120.500  1130.786
   121.000  1131.747
   121.500  1132.707
   122.000  1133.668
   122.500  1134.627
   123.000  1135.587
   123.500  1136.546
   124.000  1137.505
   124.500  1138.463
   125.000  1139.421
   125.500  1140.378
   126.000  1141.334
   126.500  1142.290
   127.000  1143.245
   127.500  1144.200
   128.000  1145.153
   128.500  1146.106
   129.000  1147.058
   129.500  1148.009
   130.000  1148.959
   130.500  1149.908
   131.000  1150.855
   131.500  1151.802
   132.000  1152.747
   132.500  1153.690
   133.000  1154.632
   133.500  1155.573
   134.000  1156.512
   134.500  1157.449
   135.000  1158.384
   135.500  1159.317
   136.000  1160.248
   136.500  1161.177
   137.000  1162.104
   137.500  1163.027
   138.000  1163.949
   138.500  1164.868
   139.000  1165.783
   139.500  1166.696
   140.000  1167.605
   140.500  1168.512
   141.000  1169.414
   141.500  1170.313
   142.000  1171.207
   142.500  1172.098
   143.000  1172.984
   143.500  1173.865
   144.000  1174.741
   144.500  1175.612
   145.000  1176.478
   145.500  1177.338
   146.000  1178.192
   146.500  1179.039
   147.000  1179.880
   147.500  1180.714
   148.000  1181.541
   148.500  1182.361
   149.000  1183.172
   149.500  1183.974
   150.000  1184.768
   150.500  1185.551
   151.000  1186.324
   151.500  1187.088
   152.000  1187.841
   152.500  1188.584
   153.000  1189.318
   153.500  1190.041
   154.000  1190.753
   154.500  1191.454
   155.000  1192.145
   155.500  1192.823
   156.000  1193.491
   156.500  1194.146
   157.000  1194.790
   157.500  1195.421
   158.000  1196.040
   158.500  1196.647
   159.000  1197.241
   159.500  1197.822
   160.000  1198.391
   160.500  1198.946
   161.000  1199.489
   161.500  1200.018
   162.000  1200.534
   162.500  1201.037
   163.000  1201.526
   163.500  1202.002
   164.000  1202.464
   164.500  1202.913
   165.000  1203.347
   165.500  1203.768
   166.000  1204.175
   166.500  1204.568
   167.000  1204.947
   167.500  1205.312
   168.000  1205.663
   168.500  1206.000
   169.000  1206.323
   169.500  1206.631
   170.000  1206.926
   170.500  1207.206
   171.000  1207.472
   171.500  1207.724
   172.000  1207.962
   172.500  1208.185
   173.000  1208.394
   173.500  1208.588
   174.000  1208.769
   174.500  1208.934
   175.000  1209.086
   175.500  1209.223
   176.000  1209.345
   176.500  1209.454
   177.000  1209.547
   177.500  1209.627
   178.000  1209.692
   178.500  1209.742
   179.000  1209.778
   179.500  1209.800
   180.000  1209.807
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.106
     1.000   992.114
     1.500   992.128
     2.000   992.148
     2.500   992.173
     3.000   992.204
     3.500   992.240
     4.000   992.282
     4.500   992.330
     5.000   992.383
     5.500   992.442
     6.000   992.506
     6.500   992.576
     7.000   992.651
     7.500   992.732
     8.000   992.819
     8.500   992.911
     9.000   993.009
     9.500   993.112
    10.000   993.221
    10.500   993.336
    11.000   993.456
    11.500   993.581
    12.000   993.712
    12.500   993.849
    13.000   993.991
    13.500   994.139
    14.000   994.292
    14.500   994.451
    15.000   994.615
    15.500   994.785
    16.000   994.960
    16.500   995.141
    17.000   995.327
    17.500   995.519
    18.000   995.716
    18.500   995.919
    19.000   996.127
    19.500   996.341
    20.000   996.560
    20.500   996.784
    21.000   997.014
    21.500   997.250
    22.000   997.491
    22.500   997.737
    23.000   997.988
    23.500   998.245
    24.000   998.508
    24.500   998.776
    25.000   999.049
    25.500   999.327
    26.000   999.611
    26.500   999.900
    27.000  1000.195
    27.500  1000.494
    28.000  1000.800
    28.500  1001.110
    29.000  1001.426
    29.500  1001.747
    30.000  1002.073
    30.500  1002.404
    31.000  1002.741
    31.500  1003.083
    32.000  1003.430
    32.500  1003.783
    33.000  1004.140
    33.500  1004.503
    34.000  1004.871
    34.500  1005.244
    35.000  1005.622
    35.500  1006.006
    36.000  1006.394
    36.500  1006.788
    37.000  1007.187
    37.500  1007.591
    38.000  1007.999
    38.500  1008.413
    39.000  1008.832
    39.500  1009.256
    40.000  1009.685
    40.500  1010.119
    41.000  1010.558
    41.500  1011.002
    42.000  1011.451
    42.500  1011.905
    43.000  1012.364
    43.500  1012.828
    44.000  1013.296
    44.500  1013.770
    45.000  1014.248
    45.500  1014.731
    46.000  1015.219
    46.500  1015.712
    47.000  1016.210
    47.500  1016.712
    48.000  1017.219
    48.500  1017.731
    49.000  1018.248
    49.500  1018.769
    50.000  1019.295
    50.500  1019.826
    51.000  1020.362
    51.500  1020.902
    52.000  1021.447
    52.500  1021.996
    53.000  1022.550
    53.500  1023.108
    54.000  1023.672
    54.500  1024.239
    55.000  1024.811
    55.500  1025.388
    56.000  1025.969
    56.500  1026.555
    57.000  1027.145
    57.500  1027.740
    58.000  1028.339
    58.500  1028.942
    59.000  1029.549
    59.500  1030.162
    60.000  1030.778
    60.500  1031.399
    61.000  1032.024
    61.500  1032.653
    62.000  1033.287
    62.500  1033.925
    63.000  1034.567
    63.500  1035.213
    64.000  1035.863
    64.500  1036.518
    65.000  1037.177
    65.500  1037.840
    66.000  1038.507
    66.500  1039.178
    67.000  1039.853
    67.500  1040.532
    68.000  1041.215
    68.500  1041.902
    69.000  1042.594
    69.500  1043.289
    70.000  1043.988
    70.500  1044.691
    71.000  1045.398
    71.500  1046.108
    72.000  1046.823
    72.500  1047.541
    73.000  1048.264
    73.500  1048.990
    74.000  1049.719
    74.500  1050.453
    75.000  1051.190
    75.500  1051.931
    76.000  1052.676
    76.500  1053.424
    77.000  1054.176
    77.500  1054.932
    78.000  1055.691
    78.500  1056.453
    79.000  1057.220
    79.500  1057.989
    80.000  1058.763
    80.500  1059.539
    81.000  1060.320
    81.500  1061.103
    82.000  1061.890
    82.500  1062.681
    83.000  1063.474
    83.500  1064.272
    84.000  1065.072
    84.500  1065.876
    85.000  1066.683
    85.500  1067.493
    86.000  1068.307
    86.500  1069.123
    87.000  1069.943
    87.500  1070.766
    88.000  1071.593
    88.500  1072.422
    89.000  1073.254
    89.500  1074.090
    90.000  1074.928
    90.500  1075.770
    91.000  1076.614
    91.500  1077.462
    92.000  1078.312
    92.500  1079.166
    93.000  1080.022
    93.500  1080.881
    94.000  1081.743
    94.500  1082.608
    95.000  1083.475
    95.500  1084.346
    96.000  1085.219
    96.500  1086.095
    97.000  1086.974
    97.500  1087.855
    98.000  1088.739
    98.500  1089.625
    99.000  1090.515
    99.500  1091.406
   100.000  1092.301
   100.500  1093.198
   101.000  1094.097
   101.500  1094.999
   102.000  1095.904
   102.500  1096.810
   103.000  1097.720
   103.500  1098.631
   104.000  1099.545
   104.500  1100.462
   105.000  1101.380
   105.500  1102.302
   106.000  1103.225
   106.500  1104.150
   107.000  1105.078
   107.500  1106.008
   108.000  1106.941
   108.500  1107.875
   109.000  1108.811
   109.500  1109.750
   110.000  1110.691
   110.500  1111.633
   111.000  1112.578
   111.500  1113.525
   112.000  1114.474
   112.500  1115.424
   113.000  1116.377
   113.500  1117.332
   114.000  1118.288
   114.500  1119.247
   115.000  1120.207
   115.500  1121.169
   116.000  1122.133
   116.500  1123.098
   117.000  1124.066
   117.500  1125.035
   118.000  1126.005
   118.500  1126.978
   119.000  1127.952
   119.500  1128.928
   120.000  1129.905
   120.500  1130.884
   121.000  1131.865
   121.500  1132.847
   122.000  1133.830
   122.500  1134.815
   123.000  1135.802
   123.500  1136.790
   124.000  1137.779
   124.500  1138.770
   125.000  1139.762
   125.500  1140.755
   126.000  1141.750
   126.500  1142.746
   127.000  1143.743
   127.500  1144.742
   128.000  1145.742
   128.500  1146.743
   129.000  1147.745
   129.500  1148.748
   130.000  1149.753
   130.500  1150.758
   131.000  1151.765
   131.500  1152.773
   132.000  1153.781
   132.500  1154.791
   133.000  1155.802
   133.500  1156.814
   134.000  1157.827
   134.500  1158.840
   135.000  1159.855
   135.500  1160.870
   136.000  1161.886
   136.500  1162.904
   137.000  1163.922
   137.500  1164.940
   138.000  1165.960
   138.500  1166.980
   139.000  1168.001
   139.500  1169.022
   140.000  1170.045
   140.500  1171.068
   141.000  1172.091
   141.500  1173.116
   142.000  1174.140
   142.500  1175.166
   143.000  1176.192
   143.500  1177.218
   144.000  1178.245
   144.500  1179.273
   145.000  1180.301
   145.500  1181.329
   146.000  1182.358
   146.500  1183.387
   147.000  1184.416
   147.500  1185.446
   148.000  1186.476
   148.500  1187.507
   149.000  1188.537
   149.500  1189.568
   150.000  1190.600
   150.500  1191.631
   151.000  1192.663
   151.500  1193.695
   152.000  1194.727
   152.500  1195.759
   153.000  1196.792
   153.500  1197.824
   154.000  1198.856
   154.500  1199.889
   155.000  1200.922
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.801
   145.500  1177.625
   146.000  1179.507
   146.500  1181.424
   147.000  1183.370
   147.500  1185.338
   148.000  1187.327
   148.500  1189.333
   149.000  1191.354
   149.500  1193.390
   150.000  1195.438
   150.500  1197.497
   151.000  1199.568
   151.500  1201.647
   152.000  1203.736
   152.500  1205.833
   153.000  1207.938
   153.500  1210.050
   154.000  1212.170
   154.500  1214.296
   155.000  1216.427
   155.500  1218.565
   156.000  1220.708
   156.500  1222.855
   157.000  1225.008
   157.500  1227.165
   158.000  1229.326
   158.500  1231.492
   159.000  1233.661
   159.500  1235.834
   160.000  1238.010
   160.500  1240.190
   161.000  1242.373
   161.500  1244.558
   162.000  1246.746
   162.500  1248.937
   163.000  1251.130
   163.500  1253.326
   164.000  1255.523
   164.500  1257.723
   165.000  1259.925
   165.500  1262.128
   166.000  1264.333
   166.500  1266.540
   167.000  1268.748
   167.500  1270.958
   168.000  1273.169
   168.500  1275.381
   169.000  1277.594
   169.500  1279.809
   170.000  1282.024
   170.500  1284.241
   171.000  1286.458
   171.500  1288.676
   172.000  1290.895
   172.500  1293.114
   173.000  1295.334
   173.500  1297.555
   174.000  1299.776
   174.500  1301.997
   175.000  1304.219
   175.500  1306.441
   176.000  1308.663
   176.500  1310.886
   177.000  1313.108
   177.500  1315.331
   178.000  1317.554
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.797
   145.500  1177.421
   146.000  1178.967
   146.500  1180.456
   147.000  1181.895
   147.500  1183.289
   148.000  1184.641
   148.500  1185.952
   149.000  1187.229
   149.500  1188.477
   150.000  1189.700
   150.500  1190.901
   151.000  1192.080
   151.500  1193.241
   152.000  1194.383
   152.500  1195.507
   153.000  1196.616
   153.500  1197.710
   154.000  1198.791
   154.500  1199.859
   155.000  1200.914
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   508.981
     1.000   509.017
     1.500   509.078
     2.000   509.162
     2.500   509.270
     3.000   509.402
     3.500   509.558
     4.000   509.737
     4.500   509.941
     5.000   510.169
     5.500   510.420
     6.000   510.695
     6.500   510.994
     7.000   511.316
     7.500   511.662
     8.000   512.032
     8.500   512.425
     9.000   512.841
     9.500   513.281
    10.000   513.743
    10.500   514.229
    11.000   514.738
    11.500   515.270
    12.000   515.824
    12.500   516.402
    13.000   517.002
    13.500   517.624
    14.000   518.269
    14.500   518.936
    15.000   519.625
    15.500   520.337
    16.000   521.070
    16.500   521.825
    17.000   522.601
    17.500   523.399
    18.000   524.219
    18.500   525.060
    19.000   525.921
    19.500   526.804
    20.000   527.707
    20.500   528.631
    21.000   529.576
    21.500   530.541
    22.000   531.526
    22.500   532.531
    23.000   533.555
    23.500   534.600
    24.000   535.664
    24.500   536.747
    25.000   537.849
    25.500   538.971
    26.000   540.111
    26.500   541.269
    27.000   542.447
    27.500   543.642
    28.000   544.856
    28.500   546.087
    29.000   547.336
    29.500   548.603
    30.000   549.887
    30.500   551.189
    31.000   552.507
    31.500   553.842
    32.000   555.194
    32.500   556.562
    33.000   557.946
    33.500   559.347
    34.000   560.763
    34.500   562.195
    35.000   563.643
    35.500   565.106
    36.000   566.584
    36.500   568.077
    37.000   569.585
    37.500   571.107
    38.000   572.644
    38.500   574.195
    39.000   575.759
    39.500   577.338
    40.000   578.931
    40.500   580.537
    41.000   582.156
    41.500   583.788
    42.000   585.433
    42.500   587.091
    43.000   588.762
    43.500   590.444
    44.000   592.139
    44.500   593.847
    45.000   595.565
    45.500   597.296
    46.000   599.038
    46.500   600.791
    47.000   602.556
    47.500   604.331
    48.000   606.118
    48.500   607.915
    49.000   609.722
    49.500   611.540
    50.000   613.367
    50.500   615.205
    51.000   617.052
    51.500   618.910
    52.000   620.776
    52.500   622.652
    53.000   624.537
    53.500   626.431
    54.000   628.334
    54.500   630.245
    55.000   632.166
    55.500   634.094
    56.000   636.031
    56.500   637.975
    57.000   639.928
    57.500   641.888
    58.000   643.856
    58.500   645.832
    59.000   647.814
    59.500   649.804
    60.000   651.801
    60.500   653.805
    61.000   655.816
    61.500   657.833
    62.000   659.857
    62.500   661.887
    63.000   663.923
    63.500   665.966
    64.000   668.014
    64.500   670.069
    65.000   672.129
    65.500   674.194
    66.000   676.265
    66.500   678.342
    67.000   680.423
    67.500   682.510
    68.000   684.602
    68.500   686.698
    69.000   688.799
    69.500   690.905
    70.000   693.016
    70.500   695.130
    71.000   697.250
    71.500   699.373
    72.000   701.500
    72.500   703.631
    73.000   705.767
    73.500   707.905
    74.000   710.048
    74.500   712.194
    75.000   714.344
    75.500   716.497
    76.000   718.653
    76.500   720.812
    77.000   722.975
    77.500   725.140
    78.000   727.308
    78.500   729.480
    79.000   731.653
    79.500   733.830
    80.000   736.009
    80.500   738.190
    81.000   740.374
    81.500   742.560
    82.000   744.748
    82.500   746.938
    83.000   749.131
    83.500   751.325
    84.000   753.521
    84.500   755.719
    85.000   757.919
    85.500   760.121
    86.000   762.324
    86.500   764.528
    87.000   766.734
    87.500   768.942
    88.000   771.150
    88.500   773.360
    89.000   775.571
    89.500   777.783
    90.000   779.997
    90.500   782.211
    91.000   784.426
    91.500   786.642
    92.000   788.859
    92.500   791.077
    93.000   793.295
    93.500   795.514
    94.000   797.734
    94.500   799.954
    95.000   802.175
    95.500   804.396
    96.000   806.617
    96.500   808.839
    97.000   811.061
    97.500   813.284
    98.000   815.506
    98.500   817.729
    99.000   819.951
    99.500   822.174
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   418.929
    29.000   424.487
    29.500   430.044
    30.000   435.600
    30.500   441.155
    31.000   446.708
    31.500   452.260
    32.000   457.810
    32.500   463.357
    33.000   468.901
    33.500   474.442
    34.000   479.979
    34.500   485.512
    35.000   491.041
    35.500   496.564
    36.000   502.082
    36.500   507.593
    37.000   513.098
    37.500   518.596
    38.000   524.086
    38.500   529.568
    39.000   535.041
    39.500   540.504
    40.000   545.958
    40.500   551.401
    41.000   556.832
    41.500   562.252
    42.000   567.660
    42.500   573.054
    43.000   578.435
    43.500   583.803
    44.000   589.156
    44.500   594.494
    45.000   599.817
    45.500   605.124
    46.000   610.414
    46.500   615.688
    47.000   620.946
    47.500   625.656
    48.000   630.227
    48.500   634.793
    49.000   639.354
    49.500   643.910
    50.000   648.461
    50.500   653.008
    51.000   657.548
    51.500   662.083
    52.000   666.613
    52.500   671.137
    53.000   675.655
    53.500   680.167
    54.000   684.672
    54.500   689.169
    55.000   693.657
    55.500   698.134
    56.000   702.602
    56.500   707.061
    57.000   711.515
    57.500   715.963
    58.000   720.406
    58.500   724.844
    59.000   729.279
    59.500   733.709
    60.000   738.136
    60.500   742.559
    61.000   746.978
    61.500   751.393
    62.000   755.805
    62.500   760.212
    63.000   764.616
    63.500   769.016
    64.000   773.411
    64.500   777.801
    65.000   782.187
    65.500   786.567
    66.000   790.941
    66.500   795.310
    67.000   799.671
    67.500   804.025
    68.000   808.373
    68.500   812.712
    69.000   817.044
    69.500   821.369
    70.000   825.686
    70.500   829.995
    71.000   834.297
    71.500   838.592
    72.000   842.879
    72.500   847.158
    73.000   851.429
    73.500   855.693
    74.000   859.949
    74.500   864.197
    75.000   868.438
    75.500   872.670
    76.000   876.894
    76.500   881.111
    77.000   885.319
    77.500   889.518
    78.000   893.710
    78.500   897.893
    79.000   902.067
    79.500   906.233
    80.000   910.391
    80.500   914.540
    81.000   918.680
    81.500   922.812
    82.000   926.935
    82.500   931.050
    83.000   935.156
    83.500   939.254
    84.000   943.343
    84.500   947.424
    85.000   951.496
    85.500   955.559
    86.000   959.613
    86.500   963.659
    87.000   967.696
    87.500   971.724
    88.000   975.743
    88.500   979.753
    89.000   983.755
    89.500   987.747
    90.000   991.730
    90.500   995.705
    91.000   999.670
    91.500  1003.627
    92.000  1007.574
    92.500  1011.513
    93.000  1015.442
    93.500  1019.363
    94.000  1023.274
    94.500  1027.176
    95.000  1031.070
    95.500  1034.954
    96.000  1038.829
    96.500  1042.695
    97.000  1046.552
    97.500  1050.400
    98.000  1054.239
    98.500  1058.069
    99.000  1061.889
    99.500  1065.701
   100.000  1069.503
   100.500  1073.296
   101.000  1077.080
   101.500  1080.855
   102.000  1084.621
   102.500  1088.377
   103.000  1092.125
   103.500  1095.863
   104.000  1099.593
   104.500  1103.313
   105.000  1107.025
   105.500  1110.728
   106.000  1114.422
   106.500  1118.107
   107.000  1121.783
   107.500  1125.450
   108.000  1129.108
   108.500  1132.756
   109.000  1136.396
   109.500  1140.026
   110.000  1143.647
   110.500  1147.259
   111.000  1150.861
   111.500  1154.454
   112.000  1158.038
   112.500  1161.613
   113.000  1165.178
   113.500  1168.735
   114.000  1172.282
   114.500  1175.821
   115.000  1179.350
   115.500  1182.870
   116.000  1186.381
   116.500  1189.883
   117.000  1193.376
   117.500  1196.860
   118.000  1200.335
   118.500  1203.800
   119.000  1207.257
   119.500  1210.704
   120.000  1214.142
   120.500  1217.571
   121.000  1220.991
   121.500  1224.401
   122.000  1227.802
   122.500  1231.194
   123.000  1234.577
   123.500  1237.951
   124.000  1241.316
   124.500  1244.672
   125.000  1248.018
   125.500  1251.356
   126.000  1254.685
   126.500  1258.004
   127.000  1261.315
   127.500  1264.617
   128.000  1267.910
   128.500  1271.194
   129.000  1274.469
   129.500  1277.735
   130.000  1280.992
   130.500  1284.241
   131.000  1287.480
   131.500  1290.710
   132.000  1293.931
   132.500  1297.143
   133.000  1300.346
   133.500  1303.540
   134.000  1306.725
   134.500  1309.901
   135.000  1313.068
   135.500  1316.226
   136.000  1319.374
   136.500  1322.514
   137.000  1325.644
   137.500  1328.766
   138.000  1331.878
   138.500  1334.981
   139.000  1338.075
   139.500  1341.161
   140.000  1344.236
   140.500  1347.303
   141.000  1350.361
   141.500  1353.410
   142.000  1356.450
   142.500  1359.480
   143.000  1362.502
   143.500  1365.515
   144.000  1368.518
   144.500  1371.513
   145.000  1374.498
   145.500  1377.474
   146.000  1380.441
   146.500  1383.398
   147.000  1386.346
   147.500  1389.285
   148.000  1392.215
   148.500  1395.135
   149.000  1398.045
   149.500  1400.947
   150.000  1403.839
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   824.397
   100.500   826.620
   101.000   828.843
   101.500   831.066
   102.000   833.288
   102.500   835.511
   103.000   837.734
   103.500   839.957
   104.000   842.180
   104.500   844.403
   105.000   846.625
   105.500   848.848
   106.000   851.071
   106.500   853.294
   107.000   855.517
   107.500   857.740
   108.000   859.963
   108.500   862.185
   109.000   864.408
   109.500   866.631
   110.000   868.854
   110.500   871.077
   111.000   873.299
   111.500   875.522
   112.000   877.745
   112.500   879.968
   113.000   882.191
   113.500   884.414
   114.000   886.637
   114.500   888.859
   115.000   891.082
   115.500   893.305
   116.000   895.528
   116.500   897.751
   117.000   899.974
   117.500   902.196
   118.000   904.419
   118.500   906.642
   119.000   908.865
   119.500   911.088
   120.000   913.311
   120.500   915.533
   121.000   917.756
   121.500   919.979
   122.000   922.202
   122.500   924.425
   123.000   926.648
   123.500   928.870
   124.000   931.093
   124.500   933.316
   125.000   935.539
   125.500   937.762
   126.000   939.985
   126.500   942.207
   127.000   944.430
   127.500   946.653
   128.000   948.876
   128.500   951.099
   129.000   953.322
   129.500   955.544
   130.000   957.767
   130.500   959.990
   131.000   962.213
   131.500   964.436
   132.000   966.659
   132.500   968.881
   133.000   971.104
   133.500   973.327
   134.000   975.550
   134.500   977.773
   135.000   979.996
   135.500   982.218
   136.000   984.441
   136.500   986.664
   137.000   988.887
   137.500   991.110
   138.000   993.333
   138.500   995.555
   139.000   997.778
   139.500  1000.001
   140.000  1002.224
   140.500  1004.447
   141.000  1006.670
   141.500  1008.892
   142.000  1011.115
   142.500  1013.338
   143.000  1015.561
   143.500  1017.784
   144.000  1020.007
   144.500  1022.229
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   384.443
    15.000   394.682
    15.500   404.916
    16.000   415.143
    16.500   425.360
    17.000   435.562
    17.500   445.746
    18.000   455.906
    18.500   466.037
    19.000   476.135
    19.500   486.193
    20.000   496.204
    20.500   506.164
    21.000   516.065
    21.500   525.904
    22.000   535.674
    22.500   545.372
    23.000   553.957
    23.500   562.098
    24.000   570.206
    24.500   578.280
    25.000   586.310
    25.500   594.259
    26.000   602.170
    26.500   610.070
    27.000   617.961
    27.500   625.844
    28.000   633.721
    28.500   641.591
    29.000   649.455
    29.500   657.312
    30.000   665.161
    30.500   673.003
    31.000   680.834
    31.500   688.654
    32.000   696.462
    32.500   704.255
    33.000   712.033
    33.500   719.793
    34.000   727.536
    34.500   735.261
    35.000   742.966
    35.500   750.652
    36.000   758.318
    36.500   765.964
    37.000   773.590
    37.500   781.195
    38.000   788.779
    38.500   796.342
    39.000   803.882
    39.500   811.400
    40.000   818.895
    40.500   826.367
    41.000   833.815
    41.500   841.240
    42.000   848.641
    42.500   856.018
    43.000   863.370
    43.500   870.698
    44.000   878.001
    44.500   885.279
    45.000   892.532
    45.500   899.760
    46.000   906.962
    46.500   914.138
    47.000   921.288
    47.500   928.412
    48.000   935.509
    48.500   942.580
    49.000   949.623
    49.500   956.639
    50.000   963.628
    50.500   970.591
    51.000   977.526
    51.500   984.433
    52.000   991.313
    52.500   998.165
    53.000  1004.990
    53.500  1011.789
    54.000  1018.563
    54.500  1025.310
    55.000  1032.030
    55.500  1038.723
    56.000  1045.389
    56.500  1052.026
    57.000  1058.637
    57.500  1065.218
    58.000  1071.772
    58.500  1078.298
    59.000  1084.796
    59.500  1091.266
    60.000  1097.709
    60.500  1104.125
    61.000  1110.512
    61.500  1116.871
    62.000  1123.202
    62.500  1129.505
    63.000  1135.779
    63.500  1142.025
    64.000  1148.242
    64.500  1154.431
    65.000  1160.592
    65.500  1166.724
    66.000  1172.829
    66.500  1178.905
    67.000  1184.952
    67.500  1190.971
    68.000  1196.962
    68.500  1202.924
    69.000  1208.857
    69.500  1214.762
    70.000  1220.638
    70.500  1226.485
    71.000  1232.303
    71.500  1238.093
    72.000  1243.853
    72.500  1249.584
    73.000  1255.286
    73.500  1260.957
    74.000  1266.598
    74.500  1272.209
    75.000  1277.791
    75.500  1283.343
    76.000  1288.865
    76.500  1294.359
    77.000  1299.823
    77.500  1305.257
    78.000  1310.660
    78.500  1316.033
    79.000  1321.376
    79.500  1326.690
    80.000  1331.975
    80.500  1337.230
    81.000  1342.455
    81.500  1347.648
    82.000  1352.810
    82.500  1357.940
    83.000  1363.038
    83.500  1368.104
    84.000  1373.140
    84.500  1378.145
    85.000  1383.118
    85.500  1388.060
    86.000  1392.971
    86.500  1397.849
    87.000  1402.695
    87.500  1407.509
    88.000  1412.290
    88.500  1417.037
    89.000  1421.751
    89.500  1426.432
    90.000  1431.079
    90.500  1435.693
    91.000  1440.272
    91.500  1444.818
    92.000  1449.330
    92.500  1453.808
    93.000  1458.252
    93.500  1462.662
    94.000  1467.047
    94.500  1471.415
    95.000  1475.769
    95.500  1480.112
    96.000  1484.444
    96.500  1488.762
    97.000  1493.063
    97.500  1497.345
    98.000  1501.606
    98.500  1505.848
    99.000  1510.070
    99.500  1514.273
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   719.193
     1.000   719.240
     1.500   719.318
     2.000   719.427
     2.500   719.567
     3.000   719.738
     3.500   719.940
     4.000   720.173
     4.500   720.437
     5.000   720.732
     5.500   721.057
     6.000   721.414
     6.500   721.801
     7.000   722.218
     7.500   722.666
     8.000   723.144
     8.500   723.652
     9.000   724.190
     9.500   724.759
    10.000   725.357
    10.500   725.984
    11.000   726.642
    11.500   727.328
    12.000   728.044
    12.500   728.789
    13.000   729.562
    13.500   730.364
    14.000   731.195
    14.500   732.054
    15.000   732.941
    15.500   733.856
    16.000   734.798
    16.500   735.768
    17.000   736.765
    17.500   737.789
    18.000   738.840
    18.500   739.917
    19.000   741.021
    19.500   742.151
    20.000   743.306
    20.500   744.487
    21.000   745.693
    21.500   746.924
    22.000   748.180
    22.500   749.460
    23.000   750.765
    23.500   752.093
    24.000   753.445
    24.500   754.820
    25.000   756.218
    25.500   757.639
    26.000   759.083
    26.500   760.548
    27.000   762.035
    27.500   763.544
    28.000   765.074
    28.500   766.625
    29.000   768.197
    29.500   769.788
    30.000   771.400
    30.500   773.031
    31.000   774.682
    31.500   776.352
    32.000   778.040
    32.500   779.746
    33.000   781.471
    33.500   783.213
    34.000   784.973
    34.500   786.749
    35.000   788.543
    35.500   790.352
    36.000   792.178
    36.500   794.019
    37.000   795.876
    37.500   797.747
    38.000   799.634
    38.500   801.534
    39.000   803.449
    39.500   805.377
    40.000   807.319
    40.500   809.273
    41.000   811.241
    41.500   813.220
    42.000   815.212
    42.500   817.215
    43.000   819.230
    43.500   821.255
    44.000   823.291
    44.500   825.338
    45.000   827.394
    45.500   829.461
    46.000   831.536
    46.500   833.621
    47.000   835.714
    47.500   837.816
    48.000   839.926
    48.500   842.043
    49.000   844.168
    49.500   846.300
    50.000   848.439
    50.500   850.585
    51.000   852.737
    51.500   854.894
    52.000   857.058
    52.500   859.226
    53.000   861.400
    53.500   863.579
    54.000   865.762
    54.500   867.949
    55.000   870.141
    55.500   872.336
    56.000   874.534
    56.500   876.736
    57.000   878.941
    57.500   881.148
    58.000   883.358
    58.500   885.570
    59.000   887.784
    59.500   890.000
    60.000   892.217
    60.500   894.436
    61.000   896.656
    61.500   898.877
    62.000   901.099
    62.500   903.321
    63.000   905.543
    63.500   907.766
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   931.247
     1.000   931.314
     1.500   931.425
     2.000   931.580
     2.500   931.779
     3.000   932.022
     3.500   932.310
     4.000   932.641
     4.500   933.017
     5.000   933.437
     5.500   933.901
     6.000   934.408
     6.500   934.959
     7.000   935.554
     7.500   936.192
     8.000   936.873
     8.500   937.598
     9.000   938.366
     9.500   939.177
    10.000   940.030
    10.500   940.927
    11.000   941.865
    11.500   942.846
    12.000   943.870
    12.500   944.935
    13.000   946.042
    13.500   947.190
    14.000   948.380
    14.500   949.611
    15.000   950.883
    15.500   952.195
    16.000   953.548
    16.500   954.941
    17.000   956.374
    17.500   957.847
    18.000   959.360
    18.500   960.911
    19.000   962.502
    19.500   964.131
    20.000   965.799
    20.500   967.505
    21.000   969.249
    21.500   971.030
    22.000   972.849
    22.500   974.704
    23.000   976.596
    23.500   978.525
    24.000   980.490
    24.500   982.490
    25.000   984.527
    25.500   986.598
    26.000   988.704
    26.500   990.845
    27.000   993.019
    27.500   995.228
    28.000   997.471
    28.500   999.746
    29.000  1002.055
    29.500  1004.396
    30.000  1006.769
    30.500  1009.174
    31.000  1011.611
    31.500  1014.080
    32.000  1016.579
    32.500  1019.108
    33.000  1021.668
    33.500  1024.258
    34.000  1026.878
    34.500  1029.526
    35.000  1032.204
    35.500  1034.910
    36.000  1037.645
    36.500  1040.407
    37.000  1043.197
    37.500  1046.014
    38.000  1048.858
    38.500  1051.729
    39.000  1054.626
    39.500  1057.548
    40.000  1060.497
    40.500  1063.470
    41.000  1066.468
    41.500  1069.491
    42.000  1072.538
    42.500  1075.609
    43.000  1078.704
    43.500  1081.822
    44.000  1084.963
    44.500  1088.126
    45.000  1091.312
    45.500  1094.519
    46.000  1097.749
    46.500  1100.999
    47.000  1104.271
    47.500  1107.563
    48.000  1110.876
    48.500  1114.209
    49.000  1117.561
    49.500  1120.933
    50.000  1124.325
    50.500  1127.735
    51.000  1131.163
    51.500  1134.610
    52.000  1138.075
    52.500  1141.558
    53.000  1145.058
    53.500  1148.575
    54.000  1152.109
    54.500  1155.660
    55.000  1159.227
    55.500  1162.810
    56.000  1166.408
    56.500  1170.022
    57.000  1173.651
    57.500  1177.295
    58.000  1180.954
    58.500  1184.627
    59.000  1188.315
    59.500  1192.016
    60.000  1195.730
    60.500  1199.458
    61.000  1203.199
    61.500  1206.953
    62.000  1210.720
    62.500  1214.499
    63.000  1218.290
    63.500  1222.093
    64.000  1225.907
    64.500  1229.733
    65.000  1233.570
    65.500  1237.419
    66.000  1241.277
    66.500  1245.147
    67.000  1249.026
    67.500  1252.916
    68.000  1256.815
    68.500  1260.724
    69.000  1264.642
    69.500  1268.570
    70.000  1272.506
    70.500  1276.452
    71.000  1280.405
    71.500  1284.367
    72.000  1288.338
    72.500  1292.316
    73.000  1296.302
    73.500  1300.296
    74.000  1304.297
    74.500  1308.305
    75.000  1312.320
    75.500  1316.342
    76.000  1320.370
    76.500  1324.406
    77.000  1328.447
    77.500  1332.494
    78.000  1336.547
    78.500  1340.606
    79.000  1344.671
    79.500  1348.741
    80.000  1352.816
    80.500  1356.897
    81.000  1360.982
    81.500  1365.072
    82.000  1369.167
    82.500  1373.266
    83.000  1377.369
    83.500  1381.476
    84.000  1385.588
    84.500  1389.703
    85.000  1393.822
    85.500  1397.945
    86.000  1402.071
    86.500  1406.200
    87.000  1410.332
    87.500  1414.467
    88.000  1418.605
    88.500  1422.746
    89.000  1426.890
    89.500  1431.036
    90.000  1435.184
    90.500  1439.334
    91.000  1443.487
    91.500  1447.641
    92.000  1451.797
    92.500  1455.955
    93.000  1460.115
    93.500  1464.276
    94.000  1468.438
    94.500  1472.602
    95.000  1476.767
    95.500  1480.933
    96.000  1485.099
    96.500  1489.267
    97.000  1493.435
    97.500  1497.604
    98.000  1501.773
    98.500  1505.943
    99.000  1510.113
    99.500  1514.283
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   772.398
    29.500   782.637
    30.000   792.875
    30.500   803.111
    31.000   813.345
    31.500   823.575
    32.000   833.801
    32.500   844.022
    33.000   854.237
    33.500   864.445
    34.000   874.645
    34.500   884.836
    35.000   895.017
    35.500   905.187
    36.000   915.344
    36.500   925.486
    37.000   935.614
    37.500   945.725
    38.000   955.818
    38.500   965.671
    39.000   975.943
    39.500   985.972
    40.000   995.977
    40.500  1005.956
    41.000  1015.908
    41.500  1025.832
    42.000  1035.725
    42.500  1045.587
    43.000  1055.417
    43.500  1065.212
    44.000  1074.973
    44.500  1084.697
    45.000  1094.384
    45.500  1103.670
    46.000  1111.839
    46.500  1119.992
    47.000  1128.127
    47.500  1136.246
    48.000  1144.348
    48.500  1152.434
    49.000  1160.503
    49.500  1168.551
    50.000  1176.572
    50.500  1184.555
    51.000  1192.484
    51.500  1200.400
    52.000  1208.308
    52.500  1216.211
    53.000  1224.109
    53.500  1232.003
    54.000  1239.893
    54.500  1247.778
    55.000  1255.661
    55.500  1263.540
    56.000  1271.415
    56.500  1279.288
    57.000  1287.157
    57.500  1295.022
    58.000  1302.885
    58.500  1310.744
    59.000  1318.600
    59.500  1326.452
    60.000  1334.300
    60.500  1342.144
    61.000  1349.984
    61.500  1357.819
    62.000  1365.649
    62.500  1373.473
    63.000  1381.291
    63.500  1389.102
    64.000  1396.908
    64.500  1404.706
    65.000  1412.497
    65.500  1420.280
    66.000  1428.054
    66.500  1435.821
    67.000  1443.578
    67.500  1451.327
    68.000  1459.067
    68.500  1466.798
    69.000  1474.519
    69.500  1482.231
    70.000  1489.933
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     1.744    30.941     0.150
     1.744    54.941     0.150
     1.897    37.941     0.150
     1.897    56.441     0.150
     1.897    62.441     0.150
     3.207   114.141     0.150
     4.339    61.141     0.150
     4.678    67.441     0.150
     4.749    86.742     0.150
     6.645   104.941     0.150
     6.645   158.941     0.150
     7.193   148.641     0.150
     7.196   109.941     0.150
     7.196   254.941     0.150
     7.220   148.941     0.150
     7.220   186.941     0.150
     7.437   109.742     0.150
     8.074   277.941     0.150
     8.688   122.941     0.150
     8.761   313.941     0.150
     8.761   315.941     0.150
     8.872   292.941     0.150
     9.058   237.941     0.150
     9.714   137.941     0.150
     9.781   148.043     0.150
     9.781   256.941     0.150
     9.781   331.941     0.150
    11.571   287.043     0.150
     0.535    21.569     0.150
     1.717    59.869     0.150
     1.855    58.869     0.150
     1.879    64.369     0.150
     2.769  3027.869     0.150
     3.992    47.869     0.150
     3.992    94.869     0.150
     4.941   137.069     0.150
     4.917   123.869     0.150
     5.461    90.869     0.150
     6.675   173.369     0.150
     6.756   179.869     0.150
     7.214   112.869     0.150
     7.214   128.869     0.150
     7.214   197.869     0.150
     7.214   253.869     0.150
     8.978   223.770     0.150
     9.106   146.869     0.150
     9.790   258.869     0.150
     9.762   139.869     0.150
    10.290   278.869     0.150
    10.290   351.869     0.150
    20.316   272.869     0.150
     1.519    50.973     0.150
     1.970    36.473     0.150
     1.970    58.473     0.150
     2.042    36.172     0.150
     2.499    22.473     0.150
     2.710   105.973     0.150
     3.177    59.371     0.150
     3.555    70.473     0.150
     3.923   106.773     0.150
     4.002   135.871     0.150
     4.002   148.473     0.150
     5.877    90.473     0.150
     5.877   108.473     0.150
     5.877   155.473     0.150
     5.877   178.473     0.150
     6.027   149.473     0.150
     6.432   106.473     0.150
     6.432   210.473     0.150
     6.448   115.473     0.150
     6.448   206.473     0.150
     8.138   126.973     0.150
     8.138   220.473     0.150
     8.138   278.473     0.150
     8.403   149.473     0.150
     8.586   153.473     0.150
     9.056   142.074     0.150
     9.056   298.473     0.150
     9.145   146.473     0.150
     1.003    20.008     0.150
     1.673    25.008     0.150
     2.044    38.008     0.150
     4.319   118.008     0.150
     5.489    65.508     0.150
     6.088    86.508     0.150
     9.237   232.805     0.150
    10.052   244.008     0.150
    10.084   146.109     0.150
    10.183   256.211     0.150
    10.447   150.508     0.150
    10.562   311.008     0.150
    24.474   324.008     0.150
     1.094    22.258     0.150
     1.094    38.758     0.150
     1.104    26.258     0.150
     1.104    44.758     0.150
     1.140    24.258     0.150
     1.356    21.258     0.150
     2.140    71.258     0.150
     3.125    69.359     0.150
     3.591    49.555     0.150
     3.591    90.258     0.150
     3.881    70.461     0.150
     4.416   147.258     0.150
     5.017    78.859     0.150
     5.245    81.656     0.150
     5.245   134.258     0.150
     5.438    95.359     0.150
     5.885    84.055     0.150
     5.960   106.258     0.150
     5.957    85.758     0.150
     6.877    99.758     0.150
     6.894   206.258     0.150
     6.894   220.258     0.150
     7.059   107.258     0.150
     7.132   113.258     0.150
     7.132   157.258     0.150
     8.395   125.258     0.150
     8.395   230.258     0.150
     8.336   128.258     0.150
     8.481   170.258     0.150
     8.481   267.258     0.150
     8.481   290.258     0.150
     9.172   143.258     0.150
     9.172   199.258     0.150
     9.172   242.258     0.150
     9.327   232.461     0.150
     9.333   139.359     0.150
     9.536   134.055     0.150
     9.648   136.258     0.150
    10.090   142.258     0.150
    10.090   254.258     0.150
    10.275   160.258     0.150
    10.605   155.258     0.150
    10.605   205.258     0.150
    10.605   296.258     0.150
    10.605   349.258     0.150
    19.414   272.258     0.150
     0.809    13.242     0.150
     0.838     9.539     0.150
     0.870    35.539     0.150
     1.111    14.039     0.150
     1.355    23.039     0.150
     1.387    15.039     0.150
     1.916    72.039     0.150
     2.214    37.242     0.150
     2.214    40.742     0.150
     2.135    40.539     0.150
     2.378    83.039     0.150
     4.188   143.039     0.150
     4.628   127.039     0.150
     4.698   128.641     0.150
     4.919   133.039     0.150
     5.592    83.742     0.150
     5.592   148.039     0.150
     6.569   115.039     0.150
     6.569   156.039     0.150
     6.734   102.039     0.150
     6.734   179.039     0.150
     6.703   107.039     0.150
     8.070   209.039     0.150
     8.184   153.039     0.150
     8.184   319.039     0.150
     8.810   111.039     0.150
     8.845   138.039     0.150
     8.845   219.039     0.150
     9.764   263.039     0.150
     9.842   195.039     0.150
     9.842   334.039     0.150
    10.281   157.039     0.150
    10.281   157.039     0.150
    10.281   291.039     0.150
    10.281   334.039     0.150
     0.937    17.716     0.150
     1.077    35.616     0.150
     1.164    22.616     0.150
     1.122    21.616     0.150
     1.122    41.616     0.150
     1.381    23.116     0.150
     2.242    35.616     0.150
     2.242    59.616     0.150
     2.137    42.116     0.150
     3.174   111.616     0.150
     4.241    68.116     0.150
     4.111    66.416     0.150
     4.398    70.616     0.150
     4.398    89.116     0.150
     4.398   122.616     0.150
     4.398   153.616     0.150
     4.895    86.116     0.150
     5.010    73.517     0.150
     5.010    95.316     0.150
     5.010   169.616     0.150
     5.454   180.116     0.150
     5.942   150.116     0.150
     6.168    94.616     0.150
     6.525   181.616     0.150
     6.488   196.616     0.150
     6.896   123.616     0.150
     6.896   207.616     0.150
     7.219   106.616     0.150
     7.140   114.616     0.150
     7.140   158.616     0.150
     7.140   229.616     0.150
     7.058   104.916     0.150
     7.283   109.616     0.150
     7.456   150.616     0.150
     7.780   121.616     0.150
     8.326   119.116     0.150
     8.391   120.616     0.150
     8.339   120.616     0.150
     8.490   156.616     0.150
     8.490   203.616     0.150
     8.490   269.616     0.150
     9.030   140.116     0.150
     9.170   141.616     0.150
     9.170   247.616     0.150
     9.170   131.116     0.150
     9.311   232.916     0.150
     9.209   248.616     0.150
     9.209   135.616     0.150
     9.209   248.616     0.150
     9.756   149.216     0.150
     9.756   149.216     0.150
     9.756   285.616     0.150
     9.756   285.616     0.150
     9.756   285.616     0.150
     9.756   285.616     0.150
     9.756   142.716     0.150
    10.087   334.616     0.150
    10.087   143.416     0.150
    10.087   258.616     0.150
    10.167   146.517     0.150
    10.154   147.616     0.150
    10.154   147.616     0.150
    10.154   147.616     0.150
    10.268   143.916     0.150
    10.296   144.616     0.150
    10.488   151.616     0.150
    10.530   152.416     0.150
    10.601   158.616     0.150
    10.601   150.716     0.150
    10.601   267.616     0.150
    10.841   162.616     0.150
    10.841   162.616     0.150
    11.473   153.616     0.150
    11.473   153.616     0.150
    11.949   179.216     0.150
    11.949   297.017     0.150
    12.569   187.316     0.150
    12.619   194.116     0.150
    13.478   204.616     0.150
    13.318   195.616     0.150
    13.876   206.017     0.150
    18.218   249.616     0.150
    18.218   465.616     0.150
    19.095   270.816     0.150
    19.436   474.616     0.150
    20.013   274.517     0.150
    20.013   308.616     0.150
    20.013   500.616     0.150
    20.636   281.116     0.150
    20.869   268.616     0.150
    20.869   268.616     0.150
    20.869   319.616     0.150
    21.120   283.616     0.150
    21.117   285.616     0.150
    21.117   285.616     0.150
    21.117   525.616     0.150
    22.087   303.616     0.150
    22.087   303.616     0.150
    23.631   312.416     0.150
    23.631     2.000     0.150
    23.631   312.416     0.150
    23.631     2.000     0.150
    23.631   570.416     0.150
    23.928   315.616     0.150
    24.482   331.616     0.150
    27.300   347.616     0.150
    31.896   385.616     0.150
    33.095   724.616     0.150
    33.095   724.616     0.150
    40.075   450.616     0.150
    40.075   450.616     0.150
    42.462   476.616     0.150
    42.767   478.616     0.150
    46.441   507.616     0.150
    47.915   517.816     0.150
    58.875   601.616     0.150
    64.706   632.616     0.150
    64.706   633.017     0.150
     1.029    27.626     0.150
     1.173    23.626     0.150
     1.173    42.626     0.150
     2.187    64.126     0.150
     3.361    84.626     0.150
     4.163   116.426     0.150
     4.921    94.426     0.150
     4.979    73.326     0.150
     4.979   109.026     0.150
     5.215   133.626     0.150
     5.472   193.626     0.150
     8.492   132.626     0.150
     8.492   151.626     0.150
     8.492   181.626     0.150
     9.147   139.626     0.150
     9.263   233.026     0.150
     9.291   121.826     0.150
    10.062   251.626     0.150
    10.122   149.626     0.150
    19.325   269.826     0.150
     0.718    12.738     0.150
     0.686    21.738     0.150
     1.342    29.238     0.150
     1.342    47.238     0.150
     1.633    27.238     0.150
     1.924    64.039     0.150
     2.328    82.238     0.150
     2.394    46.438     0.150
     2.394    79.340     0.150
     2.974   104.238     0.150
     2.992    50.738     0.150
     3.406   104.137     0.150
     4.919    95.438     0.150
     6.889   119.238     0.150
     6.889   182.238     0.150
     6.889   250.238     0.150
     7.441   152.238     0.150
     9.123   128.238     0.150
     9.123   228.539     0.150
     9.118   225.238     0.150
     9.118   251.238     0.150
     9.455   131.738     0.150
    10.026   261.238     0.150
    10.057   199.238     0.150
    10.057   336.238     0.150
    20.325   279.539     0.150
    36.418   428.738     0.150
     0.651    12.246     0.150
     0.640    21.746     0.150
     1.405    27.746     0.150
     1.405    54.746     0.150
     1.837    37.246     0.150
     2.112    47.746     0.150
     2.264    81.746     0.150
     2.432    71.348     0.150
     2.432    80.246     0.150
     2.905   101.746     0.150
     4.125   158.746     0.150
     4.843    93.445     0.150
     5.654   144.246     0.150
     5.673    99.246     0.150
     5.693    86.246     0.150
     6.943   106.246     0.150
     7.135   114.746     0.150
     7.135   125.746     0.150
     7.135   175.746     0.150
     7.372   126.746     0.150
     7.372   142.746     0.150
     7.372   256.746     0.150
     7.860   116.746     0.150
     8.503   134.746     0.150
     8.503   147.746     0.150
     8.503   224.746     0.150
     9.052   229.246     0.150
     9.045   224.746     0.150
     9.952   259.746     0.150
    10.453   151.945     0.150
    10.453   274.746     0.150
    10.453   307.746     0.150
    10.453   340.746     0.150
     0.524    21.750     0.150
     1.267    56.750     0.150
     1.761    33.250     0.150
     1.977    67.750     0.150
     2.243    73.352     0.150
     3.028   106.750     0.150
     4.193   116.750     0.150
     4.253   152.250     0.150
     4.734   130.453     0.150
     4.811    93.750     0.150
     4.868    95.953     0.150
     4.868   131.352     0.150
     5.411    96.047     0.150
     6.778   117.750     0.150
     6.778   187.750     0.150
     6.778   238.750     0.150
     8.253   211.750     0.150
     9.659   130.750     0.150
     9.953   329.750     0.150
     1.230    24.250     0.150
     2.018    68.750     0.150
     2.251    75.449     0.150
     2.789    63.949     0.150
     3.523    57.750     0.150
     4.293   155.250     0.150
     4.219    68.551     0.150
     4.945    96.750     0.150
     6.866   160.250     0.150
     8.495   133.250     0.150
     8.495   200.250     0.150
     8.495   275.250     0.150
     9.122   139.250     0.150
     9.122   292.250     0.150
     9.731   131.250     0.150
     9.991   151.250     0.150
    10.035   146.250     0.150
    10.035   343.250     0.150
    10.035   604.250     0.150
    10.544   255.250     0.150
    10.544   293.250     0.150
    10.544   305.250     0.150
    10.544   350.250     0.150
     0.527    22.227     0.150
     1.168    24.227     0.150
     1.215    23.227     0.150
     2.263    84.328     0.150
     2.464    91.227     0.150
     3.080   115.227     0.150
     3.306   100.727     0.150
     3.584   102.227     0.150
     4.148    75.227     0.150
     4.305    70.227     0.150
     4.305    90.727     0.150
     4.305   160.227     0.150
     4.839 -1069.773     0.150
     4.901   159.828     0.150
     5.391   183.027     0.150
     5.841   157.227     0.150
     6.213   226.227     0.150
     6.793   146.227     0.150
     6.793   210.227     0.150
     7.049   135.227     0.150
     7.049   161.227     0.150
     7.049   229.227     0.150
     7.127   112.227     0.150
     7.121   107.727     0.150
     7.121   186.727     0.150
     7.187   147.227     0.150
     7.352   115.227     0.150
     7.613   113.227     0.150
     8.403   155.227     0.150
     8.403   229.227     0.150
     8.403   280.227     0.150
     9.062   226.227     0.150
     9.062   246.227     0.150
     9.174   139.227     0.150
     9.323   134.727     0.150
     9.979   331.227     0.150
    10.016   146.727     0.150
    10.044   151.227     0.150
    10.044   206.227     0.150
    10.044   351.227     0.150
    10.492   288.227     0.150
    10.492   351.227     0.150
    19.510   264.727     0.150
    19.510   472.227     0.150
    20.099   279.426     0.150
    24.384   320.227     0.150
     0.503    20.633     0.150
     0.735    29.133     0.150
     1.358    23.133     0.150
     1.927    56.133     0.150
     2.026    66.531     0.150
     2.425    79.434     0.150
     2.832   104.133     0.150
     5.425   182.133     0.150
     6.674   249.133     0.150
     7.225   110.133     0.150
     8.355   127.133     0.150
     8.355   158.133     0.150
     8.355   175.133     0.150
     8.904  2070.133     0.150
     9.814   261.133     0.150
     0.664    12.764     0.150
     1.112    21.764     0.150
     1.090    20.764     0.150
     1.090    42.764     0.150
     2.156    60.764     0.150
     2.123    75.764     0.150
     2.579    49.264     0.150
     2.579    72.764     0.150
     2.695    40.664     0.150
     3.140   101.963     0.150
     3.333    94.064     0.150
     3.606   117.764     0.150
     3.640   114.963     0.150
     4.431   118.764     0.150
     4.105   116.463     0.150
     5.052    93.164     0.150
     5.052   153.664     0.150
     5.282    99.764     0.150
     5.282   158.764     0.150
     5.977   164.764     0.150
     5.979   109.764     0.150
     6.553   101.264     0.150
     6.553   180.764     0.150
     6.883   105.264     0.150
     6.936   122.764     0.150
     7.097   104.764     0.150
     7.252   112.764     0.150
     7.092   122.764     0.150
     7.314   127.764     0.150
     7.314   129.764     0.150
     7.606   113.764     0.150
     8.432   143.764     0.150
     8.432   237.764     0.150
     8.432   245.764     0.150
     8.432   119.764     0.150
     8.432   214.164     0.150
     8.378   129.264     0.150
     8.358   127.764     0.150
     8.430   128.764     0.150
     8.430   129.264     0.150
     8.525   155.764     0.150
     8.411   118.764     0.150
     9.211   160.764     0.150
     9.211   130.764     0.150
     9.027   127.264     0.150
     9.378   130.664     0.150
     9.461   132.764     0.150
     9.242   134.764     0.150
     9.793   145.064     0.150
    10.195   144.264     0.150
    10.195   144.264     0.150
    10.195   144.264     0.150
    10.873   268.764     0.150
    10.873   157.764     0.150
    10.873   268.764     0.150
    11.493   171.764     0.150
    11.493   171.764     0.150
    16.957   246.764     0.150
    16.957   435.764     0.150
    20.551   286.764     0.150
    20.643   297.264     0.150
    20.643   304.363     0.150
    20.643   311.264     0.150
    21.156   284.764     0.150
    21.156   307.764     0.150
    21.119   287.064     0.150
    27.339   357.764     0.150
    38.729   945.863     0.150
    42.470   475.764     0.150
    45.044   495.764     0.150
    45.044   495.863     0.150
    45.850   503.764     0.150
    58.573   590.764     0.150
    64.739   657.463     0.150
    73.133   679.963     0.150
    80.879   738.764     0.150
     0.553    23.872     0.150
     0.706    12.872     0.150
     0.706    29.872     0.150
     0.706    29.872     0.150
     1.419    24.372     0.150
     1.679    30.372     0.150
     1.745    33.372     0.150
     1.745    46.472     0.150
     1.875    34.372     0.150
     2.002    21.572     0.150
     2.480    47.372     0.150
     4.381    66.772     0.150
     4.711    73.872     0.150
     4.711   172.372     0.150
     4.913    99.572     0.150
     4.913   140.872     0.150
     4.913   154.372     0.150
     4.970   133.872     0.150
     5.474   188.872     0.150
     5.527   147.372     0.150
     6.454    96.872     0.150
     7.242    95.372     0.150
     7.242   170.372     0.150
     8.912   236.372     0.150
     8.912   299.372     0.150
     9.819   138.372     0.150
     9.819   260.372     0.150
     9.819   334.372     0.150
    10.320   164.372     0.150
    10.320   164.372     0.150
    22.976     2.400     0.150
     0.582    23.242     0.150
     0.888    16.742     0.150
     1.024    39.242     0.150
     1.024    20.742     0.150
     1.024    39.242     0.150
     1.177    20.242     0.150
     1.174    23.242     0.150
     1.174    43.242     0.150
     1.404    26.242     0.150
     2.499    39.742     0.150
     2.499    65.742     0.150
     2.787    62.141     0.150
     3.179   112.844     0.150
     3.917   112.844     0.150
     4.088    66.039     0.150
     4.346    86.242     0.150
     4.346   160.742     0.150
     4.703    75.742     0.150
     5.433   185.742     0.150
     6.745    98.945     0.150
     6.808   106.742     0.150
     7.004   122.242     0.150
     7.167   107.742     0.150
     7.242   111.242     0.150
     7.395   243.242     0.150
     7.409   107.242     0.150
     7.409   245.242     0.150
     7.621   111.242     0.150
     8.338   130.242     0.150
     8.338   298.242     0.150
     8.331   129.242     0.150
     8.331   287.242     0.150
     8.455   152.242     0.150
     8.455   185.242     0.150
     8.455   264.242     0.150
     8.667   109.242     0.150
     9.119   139.242     0.150
     9.119   242.242     0.150
     9.119   131.039     0.150
     9.257   232.445     0.150
     9.179   135.641     0.150
     9.271   133.641     0.150
     9.716   149.945     0.150
     9.716   201.539     0.150
     9.716   226.242     0.150
     9.716   657.945     0.150
     9.716   673.141     0.150
     9.716   673.141     0.150
     9.716   673.141     0.150
     9.716   673.141     0.150
     9.716   149.945     0.150
     9.979   262.242     0.150
    10.035   267.242     0.150
    10.035   340.242     0.150
    10.117   144.844     0.150
    10.100   252.242     0.150
    10.100   145.242     0.150
    10.100   252.242     0.150
    10.549   198.242     0.150
    10.549   243.242     0.150
    10.549   290.242     0.150
    10.549   351.242     0.150
    10.549   361.242     0.150
    10.549   370.242     0.150
    11.463   176.242     0.150
    11.463   176.242     0.150
    11.894   175.641     0.150
    11.894   180.242     0.150
    11.930   182.242     0.150
    12.514   184.445     0.150
    12.514   194.445     0.150
    12.564   192.742     0.150
    19.482   476.242     0.150
    19.988   275.242     0.150
    20.470   280.039     0.150
    20.644     9.594     0.150
    21.083   284.242     0.150
    22.105   304.242     0.150
    23.396   291.242     0.150
    33.104   399.242     0.150
    42.722   479.242     0.150
    42.722    16.000     0.150
    46.409   509.242     0.150
    58.499   594.242     0.150
     0.663    25.584     0.150
     1.047    38.584     0.150
     1.164    23.084     0.150
     1.164    42.084     0.150
     2.086    72.784     0.150
     2.185    40.584     0.150
     2.185    75.784     0.150
     2.504    48.584     0.150
     2.504    86.584     0.150
     2.723    40.884     0.150
     2.723    90.184     0.150
     3.138   118.584     0.150
     2.988    47.584     0.150
     3.560    65.584     0.150
     3.723    60.884     0.150
     4.052   110.984     0.150
     4.170    62.184     0.150
     4.170   107.184     0.150
     4.770  3666.584     0.150
     5.014   169.084     0.150
     5.518   186.184     0.150
     5.529    80.584     0.150
     5.758    90.484     0.150
     5.860   147.084     0.150
     6.925   106.584     0.150
     6.925   151.584     0.150
     6.925   181.584     0.150
     6.925   289.584     0.150
     7.180   113.584     0.150
     7.483   104.584     0.150
     8.412   114.584     0.150
     8.400   130.584     0.150
     9.081   183.584     0.150
     9.186   136.584     0.150
     9.186   235.584     0.150
     9.186   130.084     0.150
     9.186   235.084     0.150
     9.324   131.384     0.150
     9.324   229.084     0.150
     9.798   278.684     0.150
     9.798   142.984     0.150
    10.051   277.584     0.150
    10.101   266.184     0.150
    10.101   353.284     0.150
    10.101   353.284     0.150
    10.101   143.584     0.150
    10.101   266.184     0.150
    10.156   146.584     0.150
    10.156   146.584     0.150
    10.156   146.584     0.150
    10.156   146.584     0.150
    10.611   263.584     0.150
    10.611   277.584     0.150
    10.611   296.584     0.150
    10.611   353.584     0.150
    20.930    11.000     0.150
    20.930   280.584     0.150
    20.930    11.000     0.150
     1.150    23.457     0.150
     1.150    42.457     0.150
     2.107    60.758     0.150
     2.192    34.457     0.150
     2.192    47.957     0.150
     2.192    74.656     0.150
     2.210    38.156     0.150
     2.519    47.957     0.150
     4.791   122.457     0.150
     5.047    95.758     0.150
     5.047   173.258     0.150
     5.553   187.057     0.150
     5.888   175.957     0.150
     7.104   104.457     0.150
     7.699   110.457     0.150
     8.577   160.457     0.150
     9.421   133.957     0.150
    10.136   264.457     0.150
    10.189   213.457     0.150
     0.451     8.918     0.150
     0.855    18.219     0.150
     0.855    31.719     0.150
     1.664    55.719     0.150
     1.669    32.719     0.150
     1.669    64.719     0.150
     2.022    33.719     0.150
     2.022    39.219     0.150
     3.200   128.719     0.150
     3.395    39.320     0.150
     3.745    78.719     0.150
     3.745   108.719     0.150
     3.902    65.020     0.150
     4.222   110.918     0.150
     4.446   124.520     0.150
     4.776    73.320     0.150
     4.776   130.520     0.150
     4.776   160.719     0.150
     4.776   169.719     0.150
     4.956    78.117     0.150
     4.956   144.219     0.150
     6.065   163.320     0.150
     6.438    95.219     0.150
     6.711   101.219     0.150
     6.736    94.719     0.150
     6.736    94.719     0.150
     6.854    99.719     0.150
     6.854   177.719     0.150
     7.092   158.719     0.150
     7.092   189.719     0.150
     7.239   184.719     0.150
     7.239   109.719     0.150
     7.239   184.719     0.150
     7.335   218.219     0.150
     7.335   239.117     0.150
     7.335   239.117     0.150
     7.335   239.117     0.150
     7.404   201.520     0.150
     7.382   250.719     0.150
     7.393   186.719     0.150
     7.393   211.719     0.150
     7.652   113.820     0.150
     7.777   234.719     0.150
     7.892   116.219     0.150
     8.192   328.719     0.150
     8.192   118.719     0.150
     8.162   118.719     0.150
     8.622   130.719     0.150
     8.622   137.719     0.150
     8.936   131.117     0.150
     9.018   138.719     0.150
     9.018   273.719     0.150
     9.129   123.719     0.150
     9.360   142.617     0.150
     9.400   248.719     0.150
     9.400   139.219     0.150
     9.400   248.719     0.150
     9.536   136.320     0.150
     9.666   263.719     0.150
     9.821   148.320     0.150
     9.821   158.719     0.150
     9.821   158.719     0.150
     9.821   175.418     0.150
     9.821   310.719     0.150
     9.821   326.719     0.150
     9.821   326.719     0.150
     9.821   326.719     0.150
     9.821   326.719     0.150
     9.821   148.320     0.150
     9.897   141.219     0.150
     9.897   141.219     0.150
     9.897   141.219     0.150
     9.897   141.219     0.150
     9.897   150.719     0.150
     9.897   141.219     0.150
     9.915   261.320     0.150
     9.915   141.918     0.150
     9.915   261.320     0.150
    10.078   151.219     0.150
    10.398   357.719     0.150
    10.398   149.520     0.150
    10.692   158.719     0.150
    10.748   161.719     0.150
    11.042   163.719     0.150
    11.042   163.719     0.150
    11.348   181.719     0.150
    11.867   174.719     0.150
    11.867   174.719     0.150
    11.867   303.719     0.150
    12.136   192.719     0.150
    12.258   191.719     0.150
    12.258   202.719     0.150
    13.951   204.719     0.150
    14.260   206.719     0.150
    16.155   229.719     0.150
    17.543   426.719     0.150
    18.548   261.918     0.150
    18.741   476.719     0.150
    18.741   271.719     0.150
    18.741   476.719     0.150
    20.266   289.719     0.150
    20.266   278.719     0.150
    20.266    11.000     0.150
    20.521   289.219     0.150
    21.118   286.719     0.150
    21.118     9.000     0.150
    21.118   286.719     0.150
    21.118     9.000     0.150
    21.118   313.719     0.150
    21.151   321.719     0.150
    21.213   280.219     0.150
    21.213     9.500     0.150
    21.213   280.219     0.150
    21.213     9.500     0.150
    21.213   572.719     0.150
    21.663   295.320     0.150
    22.845   298.418     0.150
    23.934   312.719     0.150
    23.934   312.719     0.150
    23.934   577.719     0.150
    24.196   351.918     0.150
    24.196   579.918     0.150
    24.196   592.320     0.150
    27.268   339.719     0.150
    33.421   399.719     0.150
    33.421     8.000     0.150
    33.421   489.719     0.150
    38.141   428.820     0.150
    42.732   483.719     0.150
    42.732     9.000     0.150
    43.869   467.719     0.150
    45.428   499.719     0.150
    46.595   511.719     0.150
    46.595    13.000     0.150
    48.276   521.219     0.150
    51.309   530.719     0.150
    58.610   597.719     0.150
    82.603   739.020     0.150
     0.245     5.047     0.150
     0.408    12.547     0.150
     1.008    17.648     0.150
     1.008    32.547     0.150
     1.225    21.547     0.150
     1.242    17.047     0.150
     1.242    35.047     0.150
     1.205    42.047     0.150
     1.443    51.047     0.150
     1.451    50.047     0.150
     1.978    66.047     0.150
     2.134    37.047     0.150
     2.134    70.047     0.150
     2.283    43.047     0.150
     2.283    78.047     0.150
     3.126    48.047     0.150
     3.132    91.047     0.150
     3.197    53.750     0.150
     3.674   103.547     0.150
     3.645    57.250     0.150
     3.745    56.250     0.150
     4.107    81.250     0.150
     4.107   115.648     0.150
     4.166   112.844     0.150
     4.361    69.844     0.150
     4.361    78.047     0.150
     4.361   131.047     0.150
     4.328    67.344     0.150
     4.328   114.344     0.150
     4.493    67.047     0.150
     4.827   129.547     0.150
     4.969   129.047     0.150
     5.091   137.547     0.150
     5.494   103.844     0.150
     5.494   106.844     0.150
     5.494   150.250     0.150
     5.494   154.750     0.150
     6.105   160.547     0.150
     6.050    93.047     0.150
     6.219   158.047     0.150
     6.295   213.047     0.150
     6.386    97.648     0.150
     6.386   169.844     0.150
     6.362    94.148     0.150
     6.450   106.047     0.150
     6.660   174.547     0.150
     6.585    96.047     0.150
     6.701    99.945     0.150
     6.662   174.047     0.150
     6.662    99.047     0.150
     6.662   174.047     0.150
     6.738   108.047     0.150
     6.738   118.047     0.150
     6.738   216.047     0.150
     6.780   235.344     0.150
     6.797   108.547     0.150
     6.797   209.547     0.150
     6.850   215.547     0.150
     6.956   106.648     0.150
     8.143   206.047     0.150
     8.143   285.047     0.150
     8.203   117.047     0.150
     8.262   119.250     0.150
     8.360   120.844     0.150
     8.360   213.047     0.150
     8.441   120.047     0.150
     9.146   143.047     0.150
     9.212   133.047     0.150
     9.249   246.047     0.150
     9.249   292.047     0.150
     9.249   322.047     0.150
     9.724   229.047     0.150
     9.724   323.047     0.150
     9.865   152.547     0.150
     9.865   173.445     0.150
    10.848   165.547     0.150
    10.848   282.148     0.150
    19.935   273.047     0.150
    21.738   296.047     0.150
    22.256   296.047     0.150
     1.133    21.234     0.150
     1.948    64.535     0.150
     1.911    65.535     0.150
     2.125    64.535     0.150
     2.168    37.535     0.150
     2.168    69.535     0.150
     2.354    71.535     0.150
     2.322    46.535     0.150
     2.561    42.535     0.150
     2.561    79.035     0.150
     2.656    80.035     0.150
     3.119    50.336     0.150
     3.049    84.234     0.150
     3.201    96.535     0.150
     3.226    52.637     0.150
     3.987   139.535     0.150
     3.874   103.336     0.150
     4.168    81.535     0.150
     4.168   125.836     0.150
     4.320    86.035     0.150
     4.485   167.434     0.150
     4.593   206.535     0.150
     5.040    75.035     0.150
     5.368   177.535     0.150
     5.706   107.934     0.150
     5.706   111.035     0.150
     5.706   112.535     0.150
     5.706   196.234     0.150
     5.761    96.535     0.150
     6.251    91.137     0.150
     6.400   110.637     0.150
     6.400   214.035     0.150
     6.484   155.535     0.150
     6.598   201.035     0.150
     6.598   220.137     0.150
     6.614   113.535     0.150
     6.614   159.535     0.150
     7.640   234.535     0.150
     8.380   176.535     0.150
     8.380   228.535     0.150
     8.659   138.535     0.150
     8.916   219.336     0.150
     9.452   141.535     0.150
     9.452   239.535     0.150
     9.452   313.535     0.150
     9.452   141.535     0.150
     9.452   239.535     0.150
     9.452   313.535     0.150
    11.506   174.535     0.150
     2.068    41.557     0.150
     2.068    76.557     0.150
     2.287    39.057     0.150
     2.668    42.557     0.150
     3.768    70.656     0.150
     4.118   149.057     0.150
     4.128    79.857     0.150
     4.435    90.057     0.150
     4.435   111.057     0.150
     5.513    86.057     0.150
     5.513   116.357     0.150
     5.513   149.357     0.150
     5.513   178.857     0.150
     5.767    87.557     0.150
     5.979    87.557     0.150
     6.240   159.557     0.150
     6.820   107.557     0.150
     6.820   145.457     0.150
     6.873    97.957     0.150
     7.540   240.557     0.150
     8.381   133.557     0.150
     9.231   155.557     0.150
     9.270   151.557     0.150
     9.270   246.557     0.150
     9.270   318.557     0.150
     0.897    16.084     0.150
     2.095    33.984     0.150
     2.468    52.084     0.150
     3.506    90.084     0.150
     3.867    70.885     0.150
     3.927   113.084     0.150
     5.124    75.184     0.150
     5.124   107.584     0.150
     5.855   141.584     0.150
     6.254   143.885     0.150
     6.413    85.084     0.150
     7.541   110.084     0.150
     7.553   107.885     0.150
     8.082   125.084     0.150
     8.461   208.484     0.150
     8.943   146.084     0.150
     9.000   138.084     0.150
     9.000   222.084     0.150
     9.000   242.084     0.150
     9.000   253.084     0.150
     9.000   297.084     0.150
     9.090   149.084     0.150
     9.090   229.084     0.150
     9.090   149.084     0.150
     9.090   229.084     0.150
    11.059   271.783     0.150
     3.188    49.266     0.150
     4.027    62.766     0.150
     4.049    65.367     0.150
     4.610    64.969     0.150
     4.610   155.570     0.150
     5.616    98.969     0.150
     5.962    81.469     0.150
     6.008   117.570     0.150
     6.008   150.469     0.150
     7.055   109.867     0.150
     7.131   100.469     0.150
     8.023   124.469     0.150
     8.845   129.969     0.150
     8.845   288.469     0.150
     9.067   130.867     0.150
     1.586    28.547     0.150
     1.605    25.445     0.150
     1.727    32.398     0.150
     1.727    59.594     0.150
     2.148    35.969     0.150
     2.148    67.375     0.150
     2.232    74.539     0.150
     2.254    42.273     0.150
     2.254    77.578     0.150
     2.371    77.047     0.150
     3.194    47.047     0.150
     3.182    49.047     0.150
     3.252    56.750     0.150
     3.340    49.148     0.150
     3.589    54.047     0.150
     3.718    60.047     0.150
     3.738    53.148     0.150
     3.753    97.648     0.150
     4.092    78.047     0.150
     4.092   114.844     0.150
     4.125    61.445     0.150
     4.184    63.547     0.150
     4.170   121.250     0.150
     4.480   139.047     0.150
     4.773    85.047     0.150
     4.773   149.547     0.150
     5.533   167.047     0.150
     5.781    84.047     0.150
     6.017    89.047     0.150
     6.393   206.250     0.150
     6.393   218.344     0.150
     6.393   107.547     0.150
     6.393   206.250     0.150
     6.393   218.344     0.150
     6.541   124.945     0.150
     6.541   163.047     0.150
     6.549   112.844     0.150
     6.549   142.547     0.150
     6.549   221.750     0.150
     6.600    96.547     0.150
     6.853    97.016     0.150
     6.936   104.047     0.150
     6.927   105.648     0.150
     7.187   102.547     0.150
     7.453   104.047     0.150
     7.462   113.047     0.150
     7.784   113.148     0.150
     8.163   143.547     0.150
     8.163   143.547     0.150
     8.261   126.047     0.150
     8.261   161.047     0.150
     8.481   127.047     0.150
     8.471   169.047     0.150
     8.646   212.547     0.150
     9.182   140.047     0.150
     9.182   232.047     0.150
     9.182   301.047     0.150
     9.280   291.047     0.150
     9.280   308.047     0.150
     9.280   135.047     0.150
     9.280   230.047     0.150
     9.280   291.047     0.150
     9.280   308.047     0.150
     9.661   236.445     0.150
    10.233   149.750     0.150
    68.653   668.344     0.150
     0.307    13.570     0.150
     1.219    20.367     0.150
     1.219    39.969     0.150
     2.452    42.570     0.150
     2.844    45.070     0.150
     3.777    55.969     0.150
     3.981   110.969     0.150
     5.409    75.570     0.150
     5.457   100.469     0.150
     5.457   147.273     0.150
     7.488   164.273     0.150
     7.488   182.070     0.150
     0.565     8.254     0.150
     0.565    16.551     0.150
     0.709    24.852     0.150
     1.168    37.754     0.150
     1.558    26.152     0.150
     1.850    31.793     0.150
     2.380    85.551     0.150
     2.375    34.754     0.150
     3.241    49.152     0.150
     3.226    51.652     0.150
     3.507    52.051     0.150
     3.933    57.754     0.150
     4.068    59.852     0.150
     4.134    66.051     0.150
     4.367    67.152     0.150
     4.367   145.254     0.150
     4.287    62.254     0.150
     4.542   113.754     0.150
     4.595   122.652     0.150
     4.757    73.152     0.150
     4.833   117.152     0.150
     4.896   128.652     0.150
     5.329    76.953     0.150
     5.872    83.152     0.150
     6.017   121.852     0.150
     6.017   181.652     0.150
     6.017   442.051     0.150
     6.017   445.754     0.150
     6.017   454.152     0.150
     6.518   161.453     0.150
     6.518   444.852     0.150
     6.518   454.852     0.150
     6.591   160.352     0.150
     7.236   185.652     0.150
     8.786   126.352     0.150
     8.786   219.453     0.150
     8.841   121.152     0.150
     8.841   150.152     0.150
     9.009   226.152     0.150
     9.119   131.453     0.150
     9.119   227.852     0.150
     9.749   139.152     0.150
     9.749   251.652     0.150
    10.235   265.652     0.150
    10.235   301.652     0.150
    10.235   144.551     0.150
    10.235   265.652     0.150
    10.235   301.652     0.150
     0.664    23.383     0.150
     1.028    17.781     0.150
     1.495    45.180     0.150
     1.995    41.680     0.150
     1.995    71.484     0.150
     2.173    75.180     0.150
     2.257    38.078     0.150
     2.899    46.281     0.150
     3.414    56.883     0.150
     3.657    55.484     0.150
     3.761    57.281     0.150
     3.948    58.680     0.150
     3.948   103.680     0.150
     4.121    62.383     0.150
     4.220    84.281     0.150
     4.220   118.680     0.150
     4.486   116.078     0.150
     4.544    72.680     0.150
     5.092    82.781     0.150
     5.636    88.078     0.150
     5.636   117.484     0.150
     7.649   167.781     0.150
     8.437   216.781     0.150
     9.856   339.281     0.150
     9.856   315.281     0.150
     9.856   339.281     0.150
     1.608    53.531     0.150
     3.491    45.430     0.150
     3.491    70.430     0.150
     3.651    67.430     0.150
     3.651   100.430     0.150
     3.651   126.031     0.150
     3.693    58.328     0.150
     3.927    72.930     0.150
     3.927   252.430     0.150
     3.746    59.328     0.150
     3.997    65.133     0.150
     3.997    80.531     0.150
     3.997   126.531     0.150
     4.286    82.227     0.150
     5.539    76.227     0.150
     5.761    84.828     0.150
     5.985   107.531     0.150
     5.985   137.828     0.150
     5.985   150.727     0.150
     6.083   138.430     0.150
     6.083   148.531     0.150
     7.370   235.430     0.150
     8.151   118.930     0.150
     8.151   125.430     0.150
     8.151   220.227     0.150
     8.322   125.430     0.150
     9.580   257.430     0.150
     9.580   273.828     0.150
     1.022    34.770     0.150
     2.381    69.869     0.150
     3.270    47.369     0.150
     3.546    58.969     0.150
     3.865    46.469     0.150
     4.257    83.730     0.150
     4.557    91.469     0.150
     5.290    83.350     0.150
     6.299    90.469     0.150
     6.563    93.969     0.150
     7.422   112.570     0.150
     7.422   194.070     0.150
     7.443   111.369     0.150
     7.664   233.270     0.150
     8.766   128.070     0.150
    11.293   160.670     0.150
    19.330   262.570     0.150
    20.914   280.770     0.150
     0.975    33.039     0.150
     1.401    45.734     0.150
     1.520    25.039     0.150
     1.822    28.539     0.150
     2.189    33.836     0.150
     3.523    53.641     0.150
     3.590    56.938     0.150
     3.717    53.938     0.150
     4.190    67.039     0.150
     4.313    77.039     0.150
     4.267    80.219     0.150
     4.584    66.461     0.150
     4.990    70.938     0.150
     5.577    81.219     0.150
     5.667    85.375     0.150
     5.873    85.820     0.150
     6.326   153.438     0.150
     7.703   237.938     0.150
     8.476   283.438     0.150
     9.913   282.938     0.150
     1.488    28.234     0.150
     1.782    51.805     0.150
     2.069    57.000     0.150
     2.278    62.203     0.150
     2.542    69.000     0.150
     2.536    42.500     0.150
     3.030    80.602     0.150
     3.187    50.703     0.150
     3.617    57.453     0.150
     4.201    63.305     0.150
     4.172    85.000     0.150
     5.851    88.500     0.150
     7.015   104.203     0.150
     7.217   121.203     0.150
     7.514   118.203     0.150
     7.514   209.203     0.150
     7.514   234.203     0.150
     7.572   180.500     0.150
     7.592   180.406     0.150
     8.828   217.805     0.150
     8.977   218.305     0.150
     9.170   127.703     0.150
     9.170   223.305     0.150
     9.960   240.805     0.150
    10.164   246.500     0.150
    15.175   373.703     0.150
    19.155   260.602     0.150
    36.528   431.805     0.150
     1.441    53.453     0.150
     1.542    28.953     0.150
     2.057    55.855     0.150
     2.265    63.453     0.150
     2.744    43.953     0.150
     2.529    69.453     0.150
     2.881    54.754     0.150
     3.047    57.254     0.150
     3.627    57.453     0.150
     3.630    58.414     0.150
     3.651    55.152     0.150
     4.104   114.652     0.150
     4.350    85.254     0.150
     4.164    85.254     0.150
     6.241   154.055     0.150
     6.358    96.254     0.150
     6.358   155.355     0.150
     7.452   110.152     0.150
     7.504   116.754     0.150
     7.504   130.254     0.150
     7.504   231.754     0.150
     9.321   236.254     0.150
     9.321   272.254     0.150
     9.321   306.254     0.150
     9.710   302.254     0.150
     9.710   302.254     0.150
     9.959   139.254     0.150
    10.163   135.355     0.150
    18.405   259.555     0.150
     1.585    26.008     0.150
     1.585    57.207     0.150
     2.262    37.508     0.150
     3.704    44.809     0.150
     3.990    64.207     0.150
     4.226   113.809     0.150
     4.272   102.508     0.150
     5.144    82.207     0.150
     6.398   111.809     0.150
     6.585   103.207     0.150
     6.585   119.605     0.150
     7.305   180.605     0.150
     7.602   120.207     0.150
     7.602   139.707     0.150
     7.602   187.707     0.150
     7.602   204.207     0.150
     7.602   217.707     0.150
     8.349   161.207     0.150
     8.845   215.508     0.150
     9.004   218.008     0.150
     9.407   141.207     0.150
     9.407   246.207     0.150
     9.407   321.207     0.150
     9.407   141.207     0.150
     9.407   246.207     0.150
     9.407   321.207     0.150
    10.157   145.508     0.150
    68.801   662.008     0.150
    68.801   662.309     0.150
     1.050    18.398     0.150
     1.050    32.398     0.150
     1.371    26.797     0.150
     1.509    25.898     0.150
     1.975    67.398     0.150
     2.814    79.000     0.150
     3.600    55.398     0.150
     3.467    51.398     0.150
     4.221    53.199     0.150
     4.506    67.297     0.150
     4.543    67.398     0.150
     4.524   116.398     0.150
     5.624   144.500     0.150
     6.810   109.898     0.150
     6.810   231.797     0.150
     7.622   218.898     0.150
     7.622   284.398     0.150
     8.479   210.098     0.150
     8.427   132.398     0.150
     8.427   162.398     0.150
     8.427   227.398     0.150
     9.832   278.398     0.150
     9.832   329.398     0.150
     9.832   346.398     0.150
     1.302    25.826     0.150
     3.204    84.625     0.150
     3.224    50.025     0.150
     3.410    90.525     0.150
     3.632    94.727     0.150
     3.678    96.326     0.150
     3.737    58.025     0.150
     3.737    97.525     0.150
     4.158   108.727     0.150
     4.282   110.926     0.150
     4.411    68.227     0.150
     4.411   159.326     0.150
     4.706    62.125     0.150
     4.706   173.926     0.150
     4.716    78.426     0.150
     4.831    72.727     0.150
     5.808   184.826     0.150
     6.267    93.826     0.150
     6.459   176.727     0.150
     6.776    96.926     0.150
     7.119   108.227     0.150
     7.119   230.727     0.150
     7.142   106.266     0.150
     7.538   113.727     0.150
     7.830   118.926     0.150
     8.028   119.227     0.150
     8.663   130.926     0.150
     8.663   171.727     0.150
     8.671   206.625     0.150
     8.851   132.727     0.150
     9.529   137.625     0.150
     9.529   237.926     0.150
    10.035   147.926     0.150
    10.035   258.926     0.150
    10.035   147.926     0.150
    10.035   258.926     0.150
    21.343   285.227     0.150
    73.233   691.025     0.150
     1.096    37.457     0.150
     4.495    71.557     0.150
     4.644    63.057     0.150
     5.478    85.557     0.150
     6.596    88.156     0.150
     6.596    91.857     0.150
     6.596   154.756     0.150
     8.005   124.557     0.150
     8.005   180.057     0.150
     8.005   211.057     0.150
     9.184   127.457     0.150
     1.484    45.086     0.150
     1.917    56.586     0.150
     2.541   133.586     0.150
     2.725   138.984     0.150
     2.747   138.484     0.150
     3.002   144.688     0.150
     3.019   144.289     0.150
     3.086   146.688     0.150
     3.470   116.688     0.150
     3.470   157.086     0.150
     3.628   160.383     0.150
     3.650   118.883     0.150
     3.650   161.188     0.150
     4.203   114.188     0.150
     4.245    69.086     0.150
     4.245   145.383     0.150
     4.245   163.586     0.150
     4.692   126.086     0.150
     4.655    75.086     0.150
     4.655    89.586     0.150
     4.655   104.586     0.150
     4.655   119.586     0.150
     4.655   158.086     0.150
     4.655   163.586     0.150
     4.914    86.086     0.150
     5.094    75.555     0.150
     5.294    82.844     0.150
     5.505   107.586     0.150
     5.505   191.984     0.150
     6.021    91.688     0.150
     6.021    93.586     0.150
     6.021   114.484     0.150
     6.021   158.484     0.150
     6.021   185.688     0.150
     6.021   207.484     0.150
     6.021   394.789     0.150
     6.088   203.188     0.150
     6.170   203.484     0.150
     6.328   202.383     0.150
     6.365   158.484     0.150
     6.354   137.086     0.150
     6.354   177.086     0.150
     6.354   207.086     0.150
     6.354   217.086     0.150
     6.354   119.086     0.150
     6.354   137.086     0.150
     6.354   177.086     0.150
     6.354   207.086     0.150
     6.354   217.086     0.150
     6.328    83.484     0.150
     6.462   194.688     0.150
     6.573   219.883     0.150
     6.595   156.789     0.150
     6.595   201.188     0.150
     6.595   249.086     0.150
     6.934   109.086     0.150
     7.187   107.086     0.150
     7.187   107.883     0.150
     7.187   109.188     0.150
     7.187   122.188     0.150
     7.187   131.586     0.150
     7.187   141.586     0.150
     7.482   131.086     0.150
     7.482   173.086     0.150
     7.482   208.586     0.150
     7.482   107.984     0.150
     7.482   191.586     0.150
     8.265   258.789     0.150
     8.265   550.086     0.150
     8.265   569.586     0.150
     8.265   579.883     0.150
     8.265   119.086     0.150
     8.265   206.789     0.150
     8.355   131.289     0.150
     8.355   155.586     0.150
     8.355   252.086     0.150
     8.429   207.188     0.150
     8.465   129.086     0.150
     8.511   125.586     0.150
     9.137   225.086     0.150
     9.250   132.289     0.150
     9.250   230.586     0.150
     9.526   239.883     0.150
     9.693   192.086     0.150
     9.693   239.086     0.150
     9.693   313.086     0.150
     9.693   138.086     0.150
     9.693   192.086     0.150
     9.693   239.086     0.150
     9.693   278.289     0.150
     9.693   313.086     0.150
    18.205   247.586     0.150
    21.218   291.086     0.150
    67.800   658.289     0.150
     0.971    20.172     0.150
     1.751    60.344     0.150
     1.915    55.641     0.150
     2.238    63.938     0.150
     2.591   134.344     0.150
     2.777   140.141     0.150
     2.796   138.438     0.150
     3.054   146.242     0.150
     3.065   144.039     0.150
     3.135   146.938     0.150
     3.522   117.242     0.150
     3.522   157.844     0.150
     3.554    58.141     0.150
     3.678   160.242     0.150
     3.701   118.844     0.150
     3.701   161.438     0.150
     3.936    64.141     0.150
     5.197    81.141     0.150
     5.522   191.438     0.150
     6.096   202.641     0.150
     7.503   187.641     0.150
     0.722    12.242     0.150
     0.722     5.344     0.150
     1.350    22.641     0.150
     1.514    26.141     0.150
     1.514    26.242     0.150
     1.894    32.641     0.150
     2.148    36.742     0.150
     2.244    31.242     0.150
     3.036    82.438     0.150
     3.226    86.742     0.150
     3.242    88.438     0.150
     3.468    92.539     0.150
     3.510    94.438     0.150
     3.570    95.438     0.150
     3.991   106.641     0.150
     4.128    60.039     0.150
     4.128   109.039     0.150
     4.115   108.641     0.150
     4.150   109.938     0.150
     4.362    68.438     0.150
     4.386    66.438     0.150
     4.386   121.039     0.150
     4.386    66.438     0.150
     4.386   121.039     0.150
     4.336    70.742     0.150
     4.606    68.141     0.150
     4.606   115.242     0.150
     4.647   127.039     0.150
     4.865    76.539     0.150
     5.141    76.344     0.150
     5.097   128.141     0.150
     5.097   132.141     0.150
     5.097   139.141     0.150
     5.097   142.641     0.150
     5.097    72.641     0.150
     5.097   136.641     0.150
     5.487    86.242     0.150
     5.846   151.383     0.150
     6.258   160.641     0.150
     6.258   169.742     0.150
     6.258   194.742     0.150
     6.258    95.641     0.150
     6.258   169.742     0.150
     6.332    95.742     0.150
     6.332   167.141     0.150
     6.340   171.039     0.150
     6.340    95.242     0.150
     6.340   171.039     0.150
     6.352   167.141     0.150
     6.450    96.539     0.150
     6.474    97.539     0.150
     6.474   173.141     0.150
     6.834   116.141     0.150
     6.834   120.141     0.150
     6.834   135.141     0.150
     6.834   142.141     0.150
     6.834   152.141     0.150
     6.834   162.141     0.150
     6.920   102.742     0.150
     6.920   185.242     0.150
     6.967   121.344     0.150
     7.014   104.539     0.150
     7.299   110.039     0.150
     7.774   137.141     0.150
     7.774   155.641     0.150
     7.774   163.641     0.150
     7.774   236.641     0.150
     8.064   119.641     0.150
     8.484   132.641     0.150
     8.594   127.641     0.150
     8.594   231.742     0.150
     8.594   294.641     0.150
     8.642   126.141     0.150
     8.642   216.844     0.150
     9.028   127.141     0.150
     9.028   136.141     0.150
     9.402   138.242     0.150
     9.407   144.141     0.150
     9.491   137.844     0.150
     9.491   238.641     0.150
     9.491   137.844     0.150
     9.491   238.641     0.150
     9.493   254.742     0.150
     9.493   139.141     0.150
     9.493   254.742     0.150
     9.515   267.141     0.150
     9.519   144.141     0.150
     9.766   142.242     0.150
     9.812   142.141     0.150
     9.812   248.938     0.150
     9.981   282.141     0.150
     9.981   144.141     0.150
     9.981   282.141     0.150
     9.981   144.141     0.150
    10.515   137.141     0.150
    11.587   167.141     0.150
    19.904   272.141     0.150
    20.714   284.039     0.150
    20.714   511.242     0.150
    20.755   290.141     0.150
    20.755   316.141     0.150
    20.755   290.141     0.150
    20.755   316.141     0.150
    21.689   294.141     0.150
    21.689   316.141     0.150
    38.945   451.500     0.150
    45.814   501.641     0.150
    58.816   601.141     0.150
    66.724   655.438     0.150
    66.724     6.703     0.150
    66.724   655.344     0.150
    66.724     6.797     0.150
    71.289     7.398     0.150
    72.492   688.641     0.150
    73.185   690.938     0.150
    73.185   701.242     0.150
     0.944    35.758     0.150
     2.341    38.156     0.150
     2.341    68.562     0.150
     3.043    46.461     0.150
     3.272    51.961     0.150
     3.435    53.156     0.150
     4.004    66.359     0.150
     4.257    64.359     0.150
     4.710    76.961     0.150
     4.719    70.359     0.150
     4.745    95.359     0.150
     5.206    84.359     0.150
     5.438    79.859     0.150
     6.391    99.062     0.150
     6.391   172.562     0.150
     7.852   123.359     0.150
     7.852   178.359     0.150
     7.852   193.859     0.150
     7.852   204.859     0.150
    10.058   276.359     0.150
    19.540   269.562     0.150
    38.584   458.258     0.150
     0.938    34.389     0.150
     2.129    36.188     0.150
     3.070    82.289     0.150
     3.258    86.089     0.150
     3.280    88.289     0.150
     3.496    92.188     0.150
     3.546    94.489     0.150
     3.602    94.589     0.150
     3.857    59.389     0.150
     4.029   106.688     0.150
     4.148   108.389     0.150
     4.185   109.289     0.150
     4.574   109.089     0.150
     4.649   110.089     0.150
     4.703   127.549     0.150
     5.124   130.089     0.150
     5.866   150.949     0.150
     6.289   111.889     0.150
     6.289   149.789     0.150
     6.371    98.489     0.150
     6.489    88.089     0.150
     6.966   106.489     0.150
     7.059   105.089     0.150
     7.083   106.188     0.150
     7.563   111.589     0.150
     7.812   123.789     0.150
     7.812   138.089     0.150
     7.812   190.589     0.150
     9.417   133.989     0.150
     9.526   247.089     0.150
     9.526   287.089     0.150
     9.526   139.188     0.150
     9.526   247.089     0.150
     9.526   287.089     0.150
     9.532   147.188     0.150
     9.532   255.688     0.150
    10.019   148.089     0.150
    10.019   257.089     0.150
    10.019   266.089     0.150
    10.019   280.089     0.150
    10.019   309.089     0.150
    10.019   148.089     0.150
    10.019   257.089     0.150
    10.019   266.089     0.150
    10.019   280.089     0.150
    10.019   309.089     0.150
    73.222   689.389     0.150
     0.222     2.974     0.150
     0.443    18.174     0.150
     1.113    18.674     0.150
     2.265    64.374     0.150
     2.379    39.374     0.150
     3.928    81.374     0.150
     4.572    88.474     0.150
     4.607    73.574     0.150
     4.966    75.974     0.150
     4.984    77.574     0.150
     5.383    83.614     0.150
     6.127    94.494     0.150
     6.360    97.773     0.150
     6.599   100.813     0.150
     6.607   101.254     0.150
     6.860   103.414     0.150
     7.680   108.174     0.150
     7.680   121.674     0.150
     8.275   121.474     0.150
     8.545   218.174     0.150
    19.690   274.773     0.150
    20.100   293.374     0.150
    21.895   305.074     0.150
     2.263    37.555     0.150
     3.801    96.078     0.150
     4.191    65.875     0.150
     4.191   114.281     0.150
     3.963    60.281     0.150
     4.412    85.875     0.150
     4.265    75.078     0.150
     4.265   135.078     0.150
     4.265   148.078     0.150
     4.265   161.078     0.150
     6.052    88.680     0.150
     6.052    88.680     0.150
     6.222   103.078     0.150
     6.222   120.078     0.150
     6.390    94.281     0.150
     6.390    94.281     0.150
     6.528   172.078     0.150
     6.571    96.180     0.150
     6.571    96.180     0.150
     6.549    93.281     0.150
     6.549   100.578     0.150
     6.549   161.180     0.150
     6.549   173.180     0.150
     6.549   207.781     0.150
     6.549   251.477     0.150
     6.560   182.477     0.150
     6.620    95.375     0.150
     6.620    95.375     0.150
     6.620   161.180     0.150
     6.620   161.180     0.150
     6.664    97.875     0.150
     6.664    97.875     0.150
     6.811    99.250     0.150
     6.929    98.445     0.150
     7.043   103.477     0.150
     7.043   103.477     0.150
     7.057    99.508     0.150
     7.092   101.078     0.150
     7.092   101.078     0.150
     7.092   172.875     0.150
     7.092   172.875     0.150
     7.175   104.781     0.150
     7.175   178.078     0.150
     7.175   178.078     0.150
     7.185   103.680     0.150
     7.185   103.680     0.150
     7.229   107.781     0.150
     7.229   181.781     0.150
     7.310   106.180     0.150
     7.430   106.375     0.150
     7.430   106.375     0.150
     7.477   107.578     0.150
     7.497   108.477     0.150
     7.497   108.477     0.150
     7.563   109.180     0.150
     7.563   109.180     0.150
     7.567   117.078     0.150
     7.567   125.078     0.150
     7.567   129.578     0.150
     7.567   212.078     0.150
     7.305   107.117     0.150
     7.385   110.281     0.150
     7.706   111.781     0.150
     7.706   111.781     0.150
     7.721   111.781     0.150
     7.790   112.781     0.150
     7.790   112.781     0.150
     7.490   112.078     0.150
     7.899   111.578     0.150
     7.899   111.578     0.150
     7.901   113.477     0.150
     7.901   113.477     0.150
     7.945   113.977     0.150
     7.945   113.977     0.150
     8.213   117.078     0.150
     8.213   117.078     0.150
     8.213   203.281     0.150
     8.213   203.281     0.150
     8.254   118.078     0.150
     8.254   118.078     0.150
     8.254   208.281     0.150
     8.254   208.281     0.150
     8.314   223.078     0.150
     8.314   277.078     0.150
     8.351   118.781     0.150
     8.351   118.781     0.150
     8.499   120.977     0.150
     8.499   120.977     0.150
     8.397   126.078     0.150
     8.759   123.477     0.150
     8.958   142.875     0.150
     9.135   142.078     0.150
     9.135   249.578     0.150
     9.241   140.078     0.150
     9.241   240.078     0.150
     9.241   305.875     0.150
     9.374   309.078     0.150
     9.374   132.680     0.150
     9.374   232.375     0.150
     9.374   309.078     0.150
     9.489   134.375     0.150
     9.963   142.375     0.150
    10.024   143.781     0.150
    10.024   143.781     0.150
    15.087   213.781     0.150
     1.613    25.956     0.150
     1.751    50.556     0.150
     2.296    37.155     0.150
     3.088    50.556     0.150
     3.587    56.666     0.150
     3.672    58.306     0.150
     4.086    64.556     0.150
     4.165    65.456     0.150
     4.165   111.655     0.150
     4.395    85.056     0.150
     5.614   140.655     0.150
     6.045    90.956     0.150
     7.102   169.056     0.150
     7.552   184.056     0.150
     7.550   212.556     0.150
     8.293   210.556     0.150
     8.293   222.355     0.150
     8.498   206.355     0.150
     8.565   135.155     0.150
     8.565   227.456     0.150
     8.784   213.556     0.150
     8.899   227.756     0.150
     8.979   218.155     0.150
     9.360   135.456     0.150
     9.360   233.155     0.150
     9.494   134.756     0.150
    10.149   246.355     0.150
    10.266   248.855     0.150
     0.826    16.066     0.150
     1.022    28.656     0.150
     1.176    23.266     0.150
     1.515    43.867     0.150
     1.747    28.887     0.150
     2.029    34.566     0.150
     2.291    42.836     0.150
     2.375    38.266     0.150
     2.577    45.766     0.150
     2.577    78.586     0.150
     2.923    45.219     0.150
     2.923    77.836     0.150
     3.595    66.566     0.150
     4.040    62.367     0.150
     4.758    72.367     0.150
     5.360   145.566     0.150
    19.322   262.867     0.150
     0.753    26.582     0.150
     1.122    21.582     0.150
     1.129    22.184     0.150
     1.734    27.980     0.150
     2.330    36.082     0.150
     3.651    67.281     0.150
     4.227    77.082     0.150
     4.199    63.684     0.150
     4.299    81.383     0.150
     4.585    71.082     0.150
     5.480    81.883     0.150
     6.009    94.383     0.150
     6.009   161.480     0.150
     6.110    95.383     0.150
     6.118    86.480     0.150
     6.653    91.082     0.150
     8.456   213.281     0.150
     9.589   140.781     0.150
     0.713    12.943     0.150
     0.713    25.143     0.150
     0.804    16.443     0.150
     0.804    30.743     0.150
     1.203    23.643     0.150
     1.489    52.443     0.150
     3.809    63.243     0.150
     3.952    76.453     0.150
     3.952    84.123     0.150
     4.167    66.743     0.150
     4.237    68.043     0.150
     4.538    74.743     0.150
     7.312   199.243     0.150
     7.312   232.243     0.150
     3.382    61.273     0.150
     3.945    60.172     0.150
     4.118    76.375     0.150
     4.118   130.973     0.150
     4.118   164.273     0.150
     4.583    81.574     0.150
     4.515    92.773     0.150
     4.515   124.773     0.150
     4.515   138.273     0.150
     4.515   154.074     0.150
     4.515   163.773     0.150
     4.515   172.273     0.150
     4.752   159.672     0.150
     4.837    69.973     0.150
     4.773    79.773     0.150
     4.773   134.273     0.150
     4.868    72.852     0.150
     5.455   179.074     0.150
     6.207   160.773     0.150
     6.246    90.773     0.150
     6.513   218.773     0.150
     6.513    95.574     0.150
     6.719    97.973     0.150
     6.711   117.875     0.150
     6.846   174.273     0.150
     8.216   161.672     0.150
     8.216   220.875     0.150
     8.216   264.172     0.150
     8.418   226.172     0.150
     8.684   215.574     0.150
     9.071   250.273     0.150
     9.071   299.875     0.150
     9.229   131.172     0.150
     9.656   148.574     0.150
     9.656   252.574     0.150
     9.656   318.473     0.150
    14.831   215.172     0.150
    72.865   687.672     0.150
     0.415    12.891     0.150
     0.415    13.695     0.150
     0.746    16.555     0.150
     0.888    16.289     0.150
     1.809    31.289     0.150
     2.266    73.031     0.150
     2.508    43.781     0.150
     2.695    43.594     0.150
     2.673    41.484     0.150
     2.755    85.625     0.150
     2.788    83.414     0.150
     3.263    99.133     0.150
     4.302    83.492     0.150
     4.607    83.695     0.150
     5.112   138.789     0.150
     6.225    89.992     0.150
     6.530   166.492     0.150
     6.962   101.852     0.150
     7.638   195.992     0.150
     7.658   196.094     0.150
     7.762   213.992     0.150
     8.603   218.391     0.150
    10.249   147.289     0.150
    10.360   259.391     0.150
     0.517     8.951     0.150
     0.517    17.651     0.150
     0.499     9.451     0.150
     0.499    17.852     0.150
     0.558     9.951     0.150
     0.558    19.852     0.150
     0.732    13.451     0.150
     0.732    25.352     0.150
     0.792    28.661     0.150
     0.792    16.052     0.150
     0.792    28.651     0.150
     0.840    16.151     0.150
     0.840    29.251     0.150
     1.040    18.852     0.150
     1.040    34.251     0.150
     1.177    21.352     0.150
     1.164    21.531     0.150
     1.164    21.552     0.150
     1.293    23.751     0.150
     1.635    28.251     0.150
     1.633    28.852     0.150
     1.788    30.651     0.150
     1.921    31.151     0.150
     2.012    34.052     0.150
     2.126    35.151     0.150
     2.534    40.651     0.150
     4.354    87.751     0.150
     4.354   114.611     0.150
     4.394   142.451     0.150
     4.394   150.951     0.150
     5.773    94.552     0.150
     6.684   165.951     0.150
     6.684   165.951     0.150
     7.492   110.151     0.150
     7.492   249.151     0.150
     7.492   106.552     0.150
     7.492   110.151     0.150
     7.492   187.951     0.150
     7.492   249.151     0.150
     8.297   204.852     0.150
     9.653   129.151     0.150
     9.653   136.352     0.150
     9.653   240.151     0.150
     0.448     9.035     0.150
     0.448    15.738     0.150
     0.510    10.336     0.150
     0.510    17.137     0.150
     0.555    11.035     0.150
     0.853    15.938     0.150
     1.052    19.035     0.150
     1.158    20.438     0.150
     1.189    21.137     0.150
     1.189    38.836     0.150
     1.189    21.238     0.150
     1.285    22.738     0.150
     1.431    25.938     0.150
     1.630    29.238     0.150
     1.647    29.137     0.150
     1.781    31.535     0.150
     1.928    32.238     0.150
     1.928    32.137     0.150
     2.023    35.137     0.150
     2.115    36.336     0.150
     2.324    39.637     0.150
     2.522    41.938     0.150
     2.795    45.238     0.150
     2.795    45.137     0.150
     2.891    47.438     0.150
     3.137    51.535     0.150
     3.142    50.438     0.150
     3.191    51.438     0.150
     3.237    52.438     0.150
     3.337    54.137     0.150
     3.536    55.836     0.150
     3.740    58.938     0.150
     3.750   105.637     0.150
     3.977   136.578     0.150
     4.082    62.137     0.150
     4.136   109.105     0.150
     4.246    65.566     0.150
     4.481    81.336     0.150
     4.481   123.836     0.150
     4.481   143.836     0.150
     4.579    70.137     0.150
     4.686    70.438     0.150
     4.806   159.535     0.150
     4.806    73.238     0.150
     4.806   129.738     0.150
     4.806   159.535     0.150
     4.805   132.176     0.150
     4.925    73.238     0.150
     4.897    87.836     0.150
     4.897   135.438     0.150
     4.897   157.137     0.150
     4.897   210.637     0.150
     4.931    73.738     0.150
     5.117   132.098     0.150
     5.482   180.738     0.150
     5.482    82.637     0.150
     5.482   146.035     0.150
     5.482   180.738     0.150
     5.559    82.836     0.150
     5.559   148.035     0.150
     5.559   182.035     0.150
     5.776   101.035     0.150
     5.776   151.637     0.150
     5.776   173.035     0.150
     5.776   184.137     0.150
     5.776   206.137     0.150
     6.175    91.137     0.150
     6.358   166.637     0.150
     6.358    96.438     0.150
     6.649    97.535     0.150
     6.649    97.535     0.150
     6.673   119.035     0.150
     6.673   214.637     0.150
     6.673   214.637     0.150
     6.673   250.637     0.150
     6.875   109.637     0.150
     6.875   159.438     0.150
     6.950   101.238     0.150
     7.018   103.938     0.150
     7.039   105.438     0.150
     7.153    96.938     0.150
     7.153   108.535     0.150
     7.352   110.637     0.150
     7.480   198.137     0.150
     7.480   108.637     0.150
     7.480   198.137     0.150
     7.564   109.238     0.150
     7.693   114.215     0.150
     7.693   194.578     0.150
     7.693   244.016     0.150
     8.004   115.836     0.150
     8.004   159.637     0.150
     8.004   201.637     0.150
     8.004   117.535     0.150
     8.125   117.238     0.150
     8.284   258.137     0.150
     8.284   119.738     0.150
     8.284   210.438     0.150
     8.369   125.637     0.150
     8.369   200.637     0.150
     8.441   123.637     0.150
     8.441   216.336     0.150
     8.533   126.996     0.150
     8.572   127.277     0.150
     8.669   126.637     0.150
     8.685   133.535     0.150
     8.685   231.137     0.150
     8.685   240.836     0.150
     8.685   258.535     0.150
     8.685   284.738     0.150
     8.685   125.336     0.150
     8.685   231.137     0.150
     8.694   126.938     0.150
     8.694   220.035     0.150
     8.694   127.035     0.150
     8.864   280.535     0.150
     8.864   131.848     0.150
     8.864   131.637     0.150
     9.137   134.758     0.150
     9.169   142.035     0.150
     9.169   149.637     0.150
     9.169   237.938     0.150
     9.169   262.035     0.150
     9.169   134.336     0.150
     9.169   237.938     0.150
     9.190   139.035     0.150
     9.190   216.637     0.150
     9.190   252.035     0.150
     9.190   306.637     0.150
     9.190   135.035     0.150
     9.187   142.238     0.150
     9.187   228.137     0.150
     9.187   135.438     0.150
     9.187   228.137     0.150
     9.221   131.836     0.150
     9.221   131.836     0.150
     9.221   230.438     0.150
     9.347   133.637     0.150
     9.347   183.238     0.150
     9.347   235.836     0.150
     9.347   135.535     0.150
     9.622   250.137     0.150
     9.689   270.637     0.150
     9.689   318.637     0.150
     9.689   139.637     0.150
     9.689   146.637     0.150
     9.689   244.637     0.150
     9.689   258.637     0.150
     9.689   270.637     0.150
     9.689   281.637     0.150
     9.689   318.637     0.150
     9.689   139.637     0.150
     9.689   244.637     0.150
     9.712   141.035     0.150
    10.678   155.238     0.150
    10.970   165.035     0.150
    10.970   158.137     0.150
    11.333   170.637     0.150
    11.333   301.938     0.150
    11.333   170.637     0.150
    11.653   166.938     0.150
    11.653   170.375     0.150
    11.653   175.445     0.150
    11.653   184.457     0.150
    11.653   303.367     0.150
    12.224   173.637     0.150
    12.234   176.637     0.150
    12.324   178.035     0.150
    12.916   179.137     0.150
    13.415   349.438     0.150
    13.415   590.836     0.150
    13.415   192.035     0.150
    13.415   349.438     0.150
    13.415   590.836     0.150
    13.415   192.035     0.150
    13.415   349.438     0.150
    13.495   368.535     0.150
    13.495   193.336     0.150
    13.939   190.438     0.150
    14.001   201.137     0.150
    14.051   202.676     0.150
    14.051   202.637     0.150
    14.081   380.137     0.150
    14.081   197.238     0.150
    14.081   211.535     0.150
    14.081   380.137     0.150
    14.081   197.238     0.150
    14.359   204.637     0.150
    14.359   360.637     0.150
    14.452   370.199     0.150
    14.760   210.438     0.150
    15.098   215.938     0.150
    15.218   399.238     0.150
    15.218   215.238     0.150
    15.218   399.238     0.150
    15.218   215.238     0.150
    15.408   382.637     0.150
    15.962   227.637     0.150
    16.145   228.637     0.150
    16.381   230.035     0.150
    16.649   238.336     0.150
    17.044   265.637     0.150
    18.065   250.977     0.150
    18.065   250.938     0.150
    18.342   263.035     0.150
    18.342   467.035     0.150
    18.430   256.547     0.150
    18.430   466.477     0.150
    18.464   255.898     0.150
    18.464   463.488     0.150
    18.464   255.938     0.150
    18.464   463.535     0.150
    18.591   264.348     0.150
    18.591   478.035     0.150
    18.591   264.336     0.150
    18.591   478.035     0.150
    18.789   260.777     0.150
    19.013   462.438     0.150
    19.015   263.836     0.150
    19.170   472.238     0.150
    19.488   267.938     0.150
    19.559   267.406     0.150
    19.559   485.137     0.150
    20.186   501.809     0.150
    20.186   275.887     0.150
    20.409   298.637     0.150
    20.409   535.836     0.150
    20.734   285.637     0.150
    20.734   551.637     0.150
    20.734   282.637     0.150
    20.734   285.637     0.150
    20.734   299.637     0.150
    20.734   513.637     0.150
    20.734   551.637     0.150
    20.891   281.836     0.150
    21.459   314.637     0.150
    21.459   292.637     0.150
    21.459   292.637     0.150
    21.459   314.637     0.150
    21.459   526.637     0.150
    22.925   307.117     0.150
    22.925   548.957     0.150
    24.062   365.637     0.150
    24.062   316.637     0.150
    24.062   343.637     0.150
    24.062   365.637     0.150
    24.062   570.137     0.150
    24.062   618.137     0.150
    24.512   322.059     0.150
    27.719   350.117     0.150
    27.801   408.535     0.150
    28.068   352.828     0.150
    28.438   354.898     0.150
    28.438   354.938     0.150
    28.637   365.867     0.150
    28.718   367.336     0.150
    28.955   368.445     0.150
    29.130   372.836     0.150
    29.322   364.336     0.150
    29.359   372.637     0.150
    31.566   380.035     0.150
    31.566   386.438     0.150
    32.759   843.637     0.150
    36.588   428.520     0.150
    36.588   428.516     0.150
    38.262   438.738     0.150
    38.262     0.211     0.150
    39.060   447.238     0.150
    43.091   484.637     0.150
    43.091   884.637     0.150
    43.091  1090.637     0.150
    44.844   500.637     0.150
    44.844   500.637     0.150
    44.844   900.637     0.150
    45.559     3.199     0.150
    45.559     7.000     0.150
    45.559   914.938     0.150
    46.632   509.238     0.150
    47.208   513.938     0.150
    47.204   515.828     0.150
    48.886   963.246     0.150
    50.230   977.387     0.150
    52.917   555.867     0.150
    58.071   595.535     0.150
    58.148   725.238     0.150
    59.044   600.637     0.150
    60.519  1709.207     0.150
    61.050  1117.848     0.150
    61.216  1210.637     0.150
    61.216   616.836     0.150
    61.934     7.000     0.150
    61.934    10.500     0.150
    63.259   619.328     0.150
    63.259  1047.059     0.150
    63.259  1113.508     0.150
    63.616   626.309     0.150
    64.116   637.938     0.150
    64.116   638.637     0.150
    64.116   783.137     0.150
    64.116  1569.938     0.150
    64.116   638.637     0.150
    64.116   672.438     0.150
    64.116   783.137     0.150
    64.116  1152.336     0.150
    64.116  1166.535     0.150
    64.116  1406.137     0.150
    64.116  1569.938     0.150
    65.606   644.938     0.150
    65.606   676.637     0.150
    65.606   788.637     0.150
    65.606  1177.637     0.150
    66.434   649.137     0.150
    66.434   649.137     0.150
    66.434     4.000     0.150
    66.434     6.301     0.150
    66.434   796.137     0.150
    66.434  1176.137     0.150
    66.434  1433.137     0.150
    67.778   652.938     0.150
    67.778   657.738     0.150
    67.778   658.137     0.150
    67.967   660.938     0.150
    68.475   666.938     0.150
    68.535   663.637     0.150
    68.537     7.500     0.150
    70.011   665.137     0.150
    70.260   673.906     0.150
    71.599   689.137     0.150
    71.803  1239.137     0.150
    71.813     3.418     0.150
    71.813   687.137     0.150
    72.181   684.738     0.150
    72.232   685.238     0.150
    72.219     4.000     0.150
    72.219   691.254     0.150
    72.219   691.258     0.150
    72.219   686.738     0.150
    72.219     3.898     0.150
    72.219   705.137     0.150
    72.219   954.637     0.150
    72.219  1286.137     0.150
    72.721   690.035     0.150
    72.721   851.137     0.150
    72.721  1255.238     0.150
    72.899   690.887     0.150
    72.899   690.938     0.150
    73.604   850.332     0.150
    73.604   694.426     0.150
    73.604   850.328     0.150
    73.604   694.438     0.150
    73.811   865.137     0.150
    74.121   697.336     0.150
    74.524     7.301     0.150
    77.228   715.238     0.150
    80.324   731.637     0.150
    80.324   737.238     0.150
    80.324   915.637     0.150
    80.324  1340.637     0.150
    80.324  1348.637     0.150
    80.593  1402.238     0.150
    80.767   740.137     0.150
    80.767  1355.938     0.150
    81.158     7.000     0.150
    81.319   738.398     0.150
    81.319   738.438     0.150
    82.154   741.836     0.150
    84.515   754.535     0.150
    85.681   763.738     0.150
    86.460   764.098     0.150
    86.460   764.137     0.150
    87.121   768.535     0.150
    89.399   778.965     0.150
    89.557   779.516     0.150
   124.821  1140.316     0.150
   124.821  1244.316     0.150
   124.821  1140.336     0.150
   136.808  1155.938     0.150
   136.808  1155.836     0.150
   136.808  1164.586     0.150
   149.056  1193.316     0.150
     0.482     8.715     0.150
     0.482    16.516     0.150
     0.485     8.816     0.150
     0.485    17.117     0.150
     0.492     9.516     0.150
     0.722    14.605     0.150
     0.722    14.617     0.150
     0.722    25.414     0.150
     0.825    28.875     0.150
     0.825    15.617     0.150
     0.825    28.914     0.150
     0.850    16.016     0.150
     1.192    20.617     0.150
     1.180    21.516     0.150
     1.315    22.105     0.150
     1.315    22.215     0.150
     1.418    25.016     0.150
     1.665    29.215     0.150
     1.637    28.414     0.150
     1.813    32.414     0.150
     1.897    31.316     0.150
     2.003    34.414     0.150
     2.139    36.316     0.150
     2.169    37.516     0.150
     2.307    39.215     0.150
     2.544    41.516     0.150
     2.917    47.516     0.150
     3.098    50.715     0.150
     3.209    51.914     0.150
     3.219    52.914     0.150
     3.267    53.117     0.150
     3.732    58.117     0.150
     3.747    57.914     0.150
     3.964    61.816     0.150
     4.089    61.617     0.150
     4.808    72.117     0.150
     4.808   127.316     0.150
     4.808   155.516     0.150
     4.832    71.715     0.150
     4.947    73.414     0.150
     5.489    82.215     0.150
     5.489   144.414     0.150
     5.489   177.715     0.150
     5.741    87.617     0.150
     7.484   117.816     0.150
    20.882   285.277     0.150
    47.178   513.047     0.150
     0.418     7.977     0.150
     0.418    14.578     0.150
     0.528    10.180     0.150
     0.528    18.078     0.150
     0.514    10.078     0.150
     0.514    18.180     0.150
     0.546    10.180     0.150
     0.546    18.977     0.150
     0.765    14.879     0.150
     0.750    27.207     0.150
     0.750    13.879     0.150
     0.750    27.180     0.150
     0.842    16.477     0.150
     1.051    19.180     0.150
     1.136    21.449     0.150
     1.136    21.477     0.150
     1.269    21.828     0.150
     1.183    22.180     0.150
     1.429    26.180     0.150
     1.604    28.680     0.150
     1.642    29.277     0.150
     1.839    31.977     0.150
     1.947    32.477     0.150
     2.108    35.777     0.150
     2.028    35.078     0.150
     2.131    37.379     0.150
     2.324    39.379     0.150
     2.517    41.477     0.150
     2.812    44.977     0.150
     3.128    51.277     0.150
     3.175    51.777     0.150
     3.219    52.777     0.150
     3.635   128.078     0.150
     3.989   134.797     0.150
     4.351   114.117     0.150
     4.819    72.879     0.150
     4.819   126.078     0.150
     4.819   153.879     0.150
     4.833    75.727     0.150
     4.991    72.078     0.150
     5.576    82.578     0.150
     5.576   143.578     0.150
     5.576   176.680     0.150
     6.693   117.277     0.150
     6.693   182.977     0.150
     6.693   194.180     0.150
     6.693   224.277     0.150
     9.203   244.379     0.150
     9.203   306.777     0.150
     9.701   317.078     0.150
     9.701   139.078     0.150
     9.701   247.078     0.150
     9.701   277.078     0.150
     9.701   302.078     0.150
     9.701   317.078     0.150
    15.965   215.398     0.150
     0.492     9.855     0.150
     0.505    10.457     0.150
     0.585    11.156     0.150
     0.585    19.457     0.150
     0.735    13.758     0.150
     0.735    26.059     0.150
     0.764    16.059     0.150
     0.827    16.258     0.150
     0.862    15.855     0.150
     0.862    28.355     0.150
     1.051    19.156     0.150
     1.183    20.656     0.150
     1.194    22.457     0.150
     1.304    22.656     0.150
     1.431    26.156     0.150
     1.659    29.855     0.150
     1.650    29.559     0.150
     1.804    32.355     0.150
     2.016    35.656     0.150
     2.126    36.656     0.150
     2.157    38.656     0.150
     2.321    40.355     0.150
     2.531    42.355     0.150
     2.775    45.457     0.150
     2.904    47.855     0.150
     3.149    52.258     0.150
     3.155    52.758     0.150
     3.208    52.855     0.150
     3.257    54.059     0.150
     3.350    54.758     0.150
     3.513    58.258     0.150
     3.512    55.855     0.150
     3.745    59.656     0.150
     3.761    58.957     0.150
     4.075    62.355     0.150
     4.795    72.855     0.150
     4.795   127.758     0.150
     4.795   155.258     0.150
     5.476    82.957     0.150
     5.476   143.855     0.150
     5.476   178.258     0.150
     6.158    95.195     0.150
     6.568   100.277     0.150
     6.716   100.797     0.150
     7.129    98.809     0.150
     7.471   124.957     0.150
     7.471   211.957     0.150
     7.471   108.758     0.150
     7.471   124.957     0.150
     7.471   190.355     0.150
     7.471   211.957     0.150
     9.180   138.957     0.150
     9.180   231.355     0.150
     9.216   128.559     0.150
     9.216   128.559     0.150
     9.216   128.559     0.150
     9.216   230.656     0.150
     9.681   283.957     0.150
     9.681   321.957     0.150
     9.681   137.957     0.150
     9.681   243.957     0.150
     9.681   258.957     0.150
     9.681   283.957     0.150
     9.681   321.957     0.150
    19.479   269.855     0.150
     0.518     9.047     0.150
     0.518    18.445     0.150
     0.752    14.445     0.150
     0.752    25.145     0.150
     0.780    27.395     0.150
     0.780    15.145     0.150
     0.780    27.445     0.150
     0.853    29.848     0.150
     0.853    15.746     0.150
     0.853    29.848     0.150
     1.058    35.035     0.150
     1.058    19.047     0.150
     1.058    35.047     0.150
     1.143    19.848     0.150
     1.192    21.445     0.150
     1.192    39.645     0.150
     1.271    22.746     0.150
     1.436    24.645     0.150
     1.651    27.945     0.150
     1.767    29.645     0.150
     1.943    31.047     0.150
     2.031    34.145     0.150
     2.106    35.145     0.150
     2.131    36.547     0.150
     2.330    38.746     0.150
     2.514    39.945     0.150
     2.880    45.848     0.150
     3.127    49.848     0.150
     3.173    50.848     0.150
     4.139    66.297     0.150
     4.253    66.938     0.150
     0.533    10.195     0.150
     0.533    18.898     0.150
     0.514    20.289     0.150
     0.514    10.094     0.150
     0.514    20.297     0.150
     0.748    28.047     0.150
     0.748    13.398     0.150
     0.748    28.094     0.150
     0.851    30.914     0.150
     0.851    16.594     0.150
     0.851    30.898     0.150
     1.147    19.797     0.150
     1.147    38.398     0.150
     1.054    20.000     0.150
     1.054    35.898     0.150
     1.276    22.797     0.150
     1.189    22.195     0.150
     1.189    40.398     0.150
     1.618    29.195     0.150
     1.648    29.094     0.150
     1.771    31.500     0.150
     1.938    32.000     0.150
     2.110    35.898     0.150
     2.135    37.594     0.150
     2.027    34.898     0.150
     2.326    40.000     0.150
     2.518    41.297     0.150
     2.884    47.297     0.150
     3.131    51.297     0.150
     3.178    52.094     0.150
     3.112    49.594     0.150
     3.740    58.695     0.150
     4.255    67.586     0.150
     4.383    94.594     0.150
     4.809    72.000     0.150
     4.809   125.797     0.150
     4.809   154.797     0.150
     4.928    73.094     0.150
     4.910    71.094     0.150
     5.118    76.695     0.150
     7.482   106.297     0.150
     7.482   106.297     0.150
     7.482   120.797     0.150
     7.482   187.500     0.150
     9.222   313.195     0.150
     9.692   316.797     0.150
     0.502     9.922     0.150
     0.502    17.727     0.150
     0.505    10.328     0.150
     0.573    10.828     0.150
     0.573    19.523     0.150
     0.736    13.523     0.150
     0.813    15.523     0.150
     0.813    28.328     0.150
     0.856    15.625     0.150
     1.049    19.125     0.150
     1.049    34.422     0.150
     1.174    20.227     0.150
     1.174    38.625     0.150
     1.189    40.383     0.150
     1.189    21.523     0.150
     1.189    40.422     0.150
     1.298    22.766     0.150
     1.298    22.727     0.150
     1.298    44.023     0.150
     1.429    26.422     0.150
     1.648    28.922     0.150
     1.646    29.523     0.150
     1.796    32.422     0.150
     1.914    32.227     0.150
     2.016    35.422     0.150
     2.124    36.727     0.150
     2.319    39.922     0.150
     2.530    42.023     0.150
     2.782    45.023     0.150
     2.901    47.922     0.150
     3.146    52.023     0.150
     3.194    52.328     0.150
     3.108    49.922     0.150
     3.203    53.523     0.150
     3.510    57.828     0.150
     3.741    59.125     0.150
     3.755    58.922     0.150
     4.802    72.523     0.150
     4.802   125.828     0.150
     4.802   152.922     0.150
     4.824    73.422     0.150
     4.935    73.828     0.150
     4.879    77.922     0.150
     5.481    82.625     0.150
     5.481   144.328     0.150
     5.481   177.625     0.150
     5.553    81.422     0.150
     7.477   119.125     0.150
     7.477   167.125     0.150
     7.477   108.625     0.150
     7.477   119.125     0.150
     7.477   167.125     0.150
     7.477   189.828     0.150
     8.692   216.023     0.150
     0.458     8.809     0.150
     0.458    14.910     0.150
     0.488    10.512     0.150
     0.488    17.711     0.150
     0.505    10.109     0.150
     0.505    18.309     0.150
     0.570    10.809     0.150
     0.570    18.910     0.150
     0.721    14.211     0.150
     0.721    25.809     0.150
     0.800    15.609     0.150
     0.800    27.012     0.150
     0.835    15.410     0.150
     0.835    28.711     0.150
     1.031    19.609     0.150
     1.031    34.711     0.150
     1.177    20.211     0.150
     1.169    21.609     0.150
     1.169    37.809     0.150
     1.306    22.941     0.150
     1.306    22.910     0.150
     1.410    26.109     0.150
     1.645    29.512     0.150
     1.627    29.512     0.150
     1.801    32.012     0.150
     1.908    32.211     0.150
     2.001    35.609     0.150
     2.138    37.910     0.150
     2.545    42.512     0.150
     2.774    45.809     0.150
     2.913    47.910     0.150
     3.090    50.410     0.150
     3.720    59.109     0.150
     3.734    58.512     0.150
     3.878    60.469     0.150
     4.061   105.082     0.150
     4.282  1220.711     0.150
     4.401    88.309     0.150
     4.474   120.852     0.150
     4.844    75.441     0.150
     4.844    75.410     0.150
     4.952    74.609     0.150
     5.138    79.359     0.150
     5.138    79.410     0.150
     5.761    85.309     0.150
     7.498   244.910     0.150
     0.469     8.531     0.150
     0.469    15.930     0.150
     0.492     9.031     0.150
     0.492    16.730     0.150
     0.473     9.430     0.150
     0.583    10.629     0.150
     0.583    19.430     0.150
     0.706    12.930     0.150
     0.767    26.531     0.150
     0.806    15.531     0.150
     0.824    28.250     0.150
     0.824    14.629     0.150
     0.824    28.230     0.150
     1.017    18.031     0.150
     1.017    33.031     0.150
     1.192    21.719     0.150
     1.192    21.730     0.150
     1.157    21.430     0.150
     1.322    44.352     0.150
     1.322    24.531     0.150
     1.322    44.328     0.150
     1.396    23.930     0.150
     1.614    28.531     0.150
     1.659    29.031     0.150
     1.817    32.031     0.150
     1.986    34.629     0.150
     2.153    36.531     0.150
     2.180    37.430     0.150
     2.560    41.828     0.150
     2.929    47.531     0.150
     3.175    51.430     0.150
     3.222    52.531     0.150
     4.370    77.531     0.150
     7.509   106.430     0.150
     9.253   280.930     0.150
     0.421     7.602     0.150
     0.421    15.102     0.150
     0.532     9.602     0.150
     0.543    20.832     0.150
     0.543    10.199     0.150
     0.543    20.801     0.150
     0.508    19.012     0.150
     0.508     9.902     0.150
     0.508    19.000     0.150
     0.765    26.871     0.150
     0.765    13.801     0.150
     0.765    26.902     0.150
     0.744    13.402     0.150
     0.837    29.840     0.150
     0.837    15.102     0.150
     0.837    29.801     0.150
     1.141    19.152     0.150
     1.141    19.199     0.150
     1.045    18.699     0.150
     1.045    36.199     0.150
     1.275    21.223     0.150
     1.275    21.402     0.150
     1.275    21.199     0.150
     1.177    21.602     0.150
     1.423    25.602     0.150
     1.608    27.602     0.150
     1.637    28.602     0.150
     1.767    30.102     0.150
     1.833    31.500     0.150
     1.942    32.102     0.150
     2.114    35.500     0.150
     2.137    36.301     0.150
     2.318    38.801     0.150
     2.523    41.102     0.150
     2.887    46.500     0.150
     2.807    44.699     0.150
     3.183    50.000     0.150
     3.102    49.102     0.150
     3.123    49.801     0.150
     3.301    53.500     0.150
     3.265    50.441     0.150
     3.334    53.402     0.150
     3.286    50.340     0.150
     3.245    50.902     0.150
     3.354    51.879     0.150
     3.496    56.000     0.150
     3.521    55.000     0.150
     3.897    62.180     0.150
     3.989   110.859     0.150
     4.007   111.410     0.150
     4.060    62.012     0.150
     4.060   107.992     0.150
     4.046    60.371     0.150
     4.251    66.699     0.150
     4.304    65.109     0.150
     4.304   118.609     0.150
     4.360    66.320     0.150
     4.360    81.801     0.150
     4.360   113.402     0.150
     4.480    67.180     0.150
     4.436    68.801     0.150
     4.502    79.402     0.150
     4.502    88.102     0.150
     4.502   143.801     0.150
     4.658    69.199     0.150
     4.698    70.301     0.150
     4.688    71.402     0.150
     4.835   129.852     0.150
     4.961    73.652     0.150
     4.961   128.992     0.150
     4.922    86.301     0.150
     4.922   148.102     0.150
     4.922   158.301     0.150
     4.922   207.301     0.150
     5.023    74.402     0.150
     5.494    82.699     0.150
     5.587    84.473     0.150
     5.774    85.402     0.150
     5.724    85.402     0.150
     5.863    86.102     0.150
     5.799    90.602     0.150
     5.799   102.301     0.150
     5.799   183.801     0.150
     5.865    92.102     0.150
     5.994    89.102     0.150
     6.064    89.301     0.150
     6.176    90.301     0.150
     6.388   175.902     0.150
     6.388    93.699     0.150
     6.388   175.902     0.150
     6.589    96.902     0.150
     6.697   103.500     0.150
     6.697   201.301     0.150
     6.697   230.199     0.150
     6.899   107.000     0.150
     6.899   133.000     0.150
     6.899   143.102     0.150
     6.899   194.000     0.150
     6.899   240.699     0.150
     6.899   173.000     0.150
     6.899   194.000     0.150
     6.899   240.699     0.150
     6.910   101.000     0.150
     6.939   181.500     0.150
     7.031   101.801     0.150
     7.031   178.699     0.150
     7.029   102.602     0.150
     7.496   144.301     0.150
     7.496   108.199     0.150
     7.496   124.801     0.150
     7.496   144.301     0.150
     7.496   189.199     0.150
     7.496   108.199     0.150
     7.496   189.199     0.150
     7.565   108.402     0.150
     7.715   240.879     0.150
     7.715   113.676     0.150
     7.715   193.035     0.150
     7.715   240.875     0.150
     7.994   117.801     0.150
     8.131   116.801     0.150
     8.303   121.902     0.150
     8.303   159.199     0.150
     8.303   118.801     0.150
     8.303   207.500     0.150
     8.387   123.301     0.150
     8.387   165.301     0.150
     8.387   211.301     0.150
     8.398   210.301     0.150
     8.458   122.602     0.150
     8.601   126.832     0.150
     8.709   136.102     0.150
     8.709   239.602     0.150
     8.709   256.500     0.150
     8.709   283.500     0.150
     8.709   127.801     0.150
     8.709   225.402     0.150
     8.699   223.301     0.150
     8.894   131.371     0.150
     8.894   131.301     0.150
     8.940   127.570     0.150
     9.195   143.602     0.150
     9.195   160.602     0.150
     9.195   240.199     0.150
     9.195   254.402     0.150
     9.195   134.102     0.150
     9.195   240.199     0.150
     9.208   137.500     0.150
     9.208   232.500     0.150
     9.208   250.000     0.150
     9.208   303.301     0.150
     9.208   131.402     0.150
     9.208   232.500     0.150
     9.209   227.301     0.150
     9.209   132.902     0.150
     9.209   227.301     0.150
     9.167   134.680     0.150
     9.235   131.801     0.150
     9.235   131.801     0.150
     9.235   229.402     0.150
     9.339   133.699     0.150
     9.347   231.281     0.150
     9.347   133.828     0.150
     9.651   143.902     0.150
     9.651   152.602     0.150
     9.651   258.500     0.150
     9.706   144.301     0.150
     9.706   315.301     0.150
     9.706   139.301     0.150
     9.706   144.301     0.150
     9.706   164.301     0.150
     9.706   244.801     0.150
     9.706   315.301     0.150
     9.706   323.301     0.150
     9.706   333.301     0.150
     9.706   139.301     0.150
     9.706   244.801     0.150
     9.964   247.355     0.150
    10.031   144.000     0.150
    10.208   258.199     0.150
    10.343   149.301     0.150
    10.343   272.301     0.150
    10.833   274.000     0.150
    10.975   161.641     0.150
    10.955   269.332     0.150
    10.955   155.523     0.150
    10.971   278.164     0.150
    11.359   167.699     0.150
    11.660   168.652     0.150
    11.660   186.531     0.150
    12.205   173.145     0.150
    12.209   172.379     0.150
    12.209   172.375     0.150
    12.431   190.301     0.150
    12.643   197.301     0.150
    12.970   181.531     0.150
    13.435   342.902     0.150
    13.522   196.402     0.150
    13.627   190.840     0.150
    13.627   195.801     0.150
    13.974   195.379     0.150
    13.974   199.199     0.150
    14.023   195.762     0.150
    14.331   200.320     0.150
    14.388   357.301     0.150
    14.388   201.301     0.150
    14.388   357.301     0.150
    14.428   202.871     0.150
    14.428   368.363     0.150
    14.750   207.246     0.150
    14.896   210.668     0.150
    15.070   216.402     0.150
    15.232   240.699     0.150
    15.232   392.000     0.150
    15.232   215.699     0.150
    15.232   392.000     0.150
    15.303   219.199     0.150
    15.375   219.285     0.150
    15.436   381.301     0.150
    15.924   224.156     0.150
    15.936   228.402     0.150
    16.361   230.125     0.150
    16.622   232.367     0.150
    17.096   239.457     0.150
    17.359   242.793     0.150
    17.359   246.102     0.150
    17.699   246.176     0.150
    18.067   251.500     0.150
    18.278   251.602     0.150
    18.370   265.902     0.150
    18.459   247.801     0.150
    18.483   254.133     0.150
    18.513   257.449     0.150
    18.445   253.215     0.150
    18.445   464.715     0.150
    18.567   256.180     0.150
    18.567   256.199     0.150
    18.567   464.699     0.150
    18.871   250.801     0.150
    18.962   252.301     0.150
    19.029   260.500     0.150
    19.028   259.500     0.150
    19.200   478.199     0.150
    19.505   266.199     0.150
    19.505   265.801     0.150
    19.505   483.547     0.150
    19.589   482.801     0.150
    20.478   290.602     0.150
    20.716   307.301     0.150
    20.762   282.301     0.150
    20.762   513.301     0.150
    20.762   541.301     0.150
    20.916   281.199     0.150
    20.916   281.199     0.150
    20.916   509.324     0.150
    24.089   572.301     0.150
    24.089   314.301     0.150
    24.089   572.301     0.150
    24.531   321.180     0.150
    26.166   333.500     0.150
    27.741   347.910     0.150
    27.741   347.910     0.150
    28.245   357.770     0.150
    28.245   353.770     0.150
    28.355   640.402     0.150
    28.460   353.090     0.150
    28.904   359.395     0.150
    29.148   366.570     0.150
    29.340   363.652     0.150
    30.256   375.840     0.150
    30.256   370.570     0.150
    31.217   369.699     0.150
    31.217   431.699     0.150
    32.080   853.301     0.150
    32.789   393.102     0.150
    32.789   709.301     0.150
    37.946   437.699     0.150
    38.433   441.402     0.150
    43.780   485.371     0.150
    43.780   485.301     0.150
    44.873   496.301     0.150
    45.588     5.199     0.150
    45.588     7.801     0.150
    47.200   513.391     0.150
    49.556   538.301     0.150
    50.823   548.980     0.150
    51.558   982.609     0.150
    51.898   554.801     0.150
    51.898     4.500     0.150
    51.898   561.801     0.150
    51.898   554.801     0.150
    51.898     4.500     0.150
    51.898   561.801     0.150
    51.898   673.602     0.150
    51.898   995.301     0.150
    51.898  1001.801     0.150
    51.898  1209.801     0.150
    52.914   554.301     0.150
    53.873   556.410     0.150
    54.731   575.750     0.150
    54.870   577.242     0.150
    55.148   572.402     0.150
    57.862   591.500     0.150
    58.102   594.199     0.150
    58.178   583.801     0.150
    58.178   718.102     0.150
    59.066   603.402     0.150
    59.066   598.902     0.150
    59.066   604.801     0.150
    60.541   631.473     0.150
    60.541  1711.520     0.150
    61.071  1101.723     0.150
    61.071  1896.801     0.150
    61.243  1145.199     0.150
    61.243  1202.301     0.150
    61.243   616.301     0.150
    61.243   755.500     0.150
    61.243  1113.602     0.150
    61.243  1202.301     0.150
    61.928   620.500     0.150
    61.964   625.199     0.150
    61.964     7.301     0.150
    61.964   621.199     0.150
    61.964   625.199     0.150
    61.964     7.301     0.150
    61.964   760.402     0.150
    61.964  1125.500     0.150
    61.964  1133.500     0.150
    63.072  1591.301     0.150
    63.072  2095.301     0.150
    63.285  1094.020     0.150
    64.144   769.500     0.150
    64.144  1142.500     0.150
    64.144  1217.199     0.150
    64.144  1565.602     0.150
    66.072  1339.301     0.150
    66.463   655.301     0.150
    66.463     7.000     0.150
    66.463   650.301     0.150
    66.463   655.301     0.150
    66.463     7.000     0.150
    66.463   798.301     0.150
    66.463  1177.301     0.150
    66.463  1434.301     0.150
    67.997   659.227     0.150
    67.997   807.328     0.150
    68.544   679.000     0.150
    68.544   661.797     0.150
    68.568   674.402     0.150
    68.568    15.301     0.150
    68.568  1218.199     0.150
    68.568   663.602     0.150
    68.568   674.402     0.150
    68.568    15.301     0.150
    68.568   688.301     0.150
    68.568   819.199     0.150
    68.568  1199.199     0.150
    68.568  1218.199     0.150
    69.446  1226.902     0.150
    69.446   669.102     0.150
    69.446   826.500     0.150
    69.446  1213.102     0.150
    69.446  1226.902     0.150
    69.446  1484.500     0.150
    69.980   662.301     0.150
    70.337   680.402     0.150
    71.025   690.301     0.150
    71.025   677.801     0.150
    71.025   690.301     0.150
    71.578   681.902     0.150
    71.833   683.402     0.150
    71.833  1243.402     0.150
    71.843   682.660     0.150
    72.211   686.402     0.150
    72.221   687.199     0.150
    72.247   685.801     0.150
    72.247   685.801     0.150
    72.247   850.199     0.150
    72.247  1245.301     0.150
    72.247  1528.199     0.150
    72.339   686.102     0.150
    72.747   855.199     0.150
    73.631   693.402     0.150
    73.631   693.352     0.150
    73.841   970.301     0.150
    74.186  1284.000     0.150
    74.186   697.102     0.150
    74.186   862.301     0.150
    74.186  1268.801     0.150
    74.186  1284.000     0.150
    74.554   702.699     0.150
    74.554   699.402     0.150
    74.554   702.699     0.150
    74.554  1270.500     0.150
    74.894   704.902     0.150
    74.894  1277.402     0.150
    75.472   705.402     0.150
    76.113   704.301     0.150
    76.113   717.102     0.150
    76.113  1286.402     0.150
    76.113  1317.902     0.150
    76.254   708.801     0.150
    77.428   715.199     0.150
    78.688   726.801     0.150
    80.211   730.102     0.150
    80.363   733.801     0.150
    80.620  1029.199     0.150
    80.798   736.902     0.150
    80.798  1340.902     0.150
    80.899   734.301     0.150
    80.990   740.699     0.150
    80.990   740.699     0.150
    80.990  1344.199     0.150
    81.125   737.902     0.150
    82.155   740.801     0.150
    82.543   743.500     0.150
    83.330   746.699     0.150
    83.890   748.102     0.150
    84.392   753.000     0.150
    84.520   754.301     0.150
    84.570   754.102     0.150
    84.625   753.102     0.150
    84.766   755.402     0.150
    84.792   754.000     0.150
    85.682   759.500     0.150
    86.298   763.000     0.150
    86.488   762.801     0.150
    86.488   763.301     0.150
    86.490   763.012     0.150
    87.126   768.102     0.150
    89.394   777.902     0.150
    89.438   778.500     0.150
    89.462   777.402     0.150
    89.559   777.926     0.150
    90.984   784.402     0.150
   124.846  1138.059     0.150
   124.846  1243.586     0.150
   136.829  1161.152     0.150
   149.022  1199.977     0.150
   149.086  1189.172     0.150
     0.391     7.445     0.150
     0.391    13.246     0.150
     0.501     9.445     0.150
     0.501    17.547     0.150
     0.573     9.945     0.150
     0.573    18.848     0.150
     0.528    10.047     0.150
     0.528    19.047     0.150
     0.740    27.637     0.150
     0.740    13.746     0.150
     0.740    27.645     0.150
     0.766    13.445     0.150
     0.766    25.746     0.150
     1.112    18.848     0.150
     1.188    21.445     0.150
     1.437    25.547     0.150
     1.577    27.445     0.150
     1.739    29.445     0.150
     1.648    28.746     0.150
     1.648    51.246     0.150
     1.859    31.348     0.150
     2.093    35.145     0.150
     2.113    35.746     0.150
     2.041    34.445     0.150
     2.335    39.445     0.150
     2.504    40.645     0.150
     2.863    46.746     0.150
     3.112    49.945     0.150
     3.158    50.145     0.150
     3.197    50.547     0.150
     3.116    49.145     0.150
     3.124    48.645     0.150
     3.311    53.047     0.150
     3.473    55.246     0.150
     3.499    54.047     0.150
     3.527    55.047     0.150
     3.662    99.746     0.150
     3.737    58.145     0.150
     3.745    57.945     0.150
     4.089    63.348     0.150
     4.561    67.207     0.150
     4.533    67.445     0.150
     4.533   161.246     0.150
     4.738    69.586     0.150
     4.953   134.145     0.150
     4.953   140.746     0.150
     4.953   150.746     0.150
     4.953   159.246     0.150
     4.953   179.246     0.150
     5.366   141.867     0.150
     5.581    79.547     0.150
     6.095    88.266     0.150
     6.299    96.645     0.150
     6.616   167.348     0.150
     7.491   119.246     0.150
     7.491   215.246     0.150
     7.491   107.246     0.150
     7.491   119.246     0.150
     7.491   188.246     0.150
     7.491   215.246     0.150
     7.719   111.836     0.150
     8.301   123.746     0.150
     9.205   136.047     0.150
     9.205   142.848     0.150
     9.205   239.645     0.150
     9.205   304.945     0.150
     9.226   229.047     0.150
    18.480   254.801     0.150
    19.501   265.547     0.150
    19.501   266.621     0.150
    20.224   276.121     0.150
    20.922   281.523     0.150
    31.618   373.805     0.150
    38.316   441.875     0.150
    68.531   658.535     0.150
    68.531   658.535     0.150
    73.661   695.980     0.150
    89.369   773.715     0.150
    89.369   773.723     0.150
     0.507    20.211     0.150
     0.507     9.430     0.150
     0.507    20.230     0.150
     0.568    11.430     0.150
     0.568    18.730     0.150
     0.525     9.531     0.150
     0.525    18.328     0.150
     0.745    15.918     0.150
     0.745    26.641     0.150
     0.745    15.930     0.150
     0.745    26.629     0.150
     0.762    15.168     0.150
     0.762    26.781     0.150
     0.762    15.129     0.150
     0.762    26.828     0.150
     0.843    30.391     0.150
     0.843    15.430     0.150
     0.843    30.430     0.150
     1.117    19.961     0.150
     1.117    19.930     0.150
     1.059    19.730     0.150
     1.059    34.730     0.150
     1.186    38.660     0.150
     1.186    21.930     0.150
     1.186    38.629     0.150
     1.435    25.129     0.150
     1.595    29.629     0.150
     1.647    28.328     0.150
     1.647    50.230     0.150
     1.966    31.629     0.150
     2.096    35.129     0.150
     2.117    36.031     0.150
     2.038    34.730     0.150
     2.332    39.328     0.150
     2.507    40.531     0.150
     2.830    44.328     0.150
     3.116    50.031     0.150
     3.161    51.629     0.150
     3.161    49.930     0.150
     3.114    49.730     0.150
     3.314    52.250     0.150
     3.314    52.230     0.150
     3.477    56.230     0.150
     4.158    65.328     0.150
     4.294   691.328     0.150
     4.292    67.828     0.150
     4.481    69.219     0.150
     4.831    74.770     0.150
     4.924    72.230     0.150
     4.947    86.730     0.150
     4.947    93.129     0.150
     5.854    87.531     0.150
     7.492   109.930     0.150
     0.502     9.250     0.150
     0.502    16.449     0.150
     0.537    20.148     0.150
     0.537     9.750     0.150
     0.537    20.148     0.150
     0.573     9.949     0.150
     0.573    18.250     0.150
     0.747    27.621     0.150
     0.747    14.449     0.150
     0.747    27.648     0.150
     0.774    15.371     0.150
     0.774    27.578     0.150
     0.774    15.348     0.150
     0.774    27.551     0.150
     0.855    30.020     0.150
     0.855    16.648     0.150
     0.855    30.051     0.150
     1.071    19.648     0.150
     1.071    36.648     0.150
     1.109    18.949     0.150
     1.199    22.348     0.150
     1.199    40.648     0.150
     1.242    23.449     0.150
     1.448    25.250     0.150
     1.659    28.750     0.150
     1.659    50.551     0.150
     1.734    30.449     0.150
     1.975    31.848     0.150
     2.050    34.848     0.150
     2.495    41.449     0.150
     2.840    45.348     0.150
     3.104    50.051     0.150
     4.260    68.969     0.150
     4.912    72.551     0.150
     0.516     9.734     0.150
     0.547    10.836     0.150
     0.561    10.934     0.150
     0.561    19.633     0.150
     0.771    15.133     0.150
     0.771    27.336     0.150
     0.782    15.035     0.150
     0.782    27.836     0.150
     0.833    30.234     0.150
     0.876    31.305     0.150
     0.876    16.234     0.150
     0.876    31.336     0.150
     1.085    36.934     0.150
     1.085    20.133     0.150
     1.085    36.934     0.150
     1.217    23.035     0.150
     1.217    41.035     0.150
     1.463    26.535     0.150
     1.463    46.035     0.150
     1.590    28.633     0.150
     1.738    32.336     0.150
     1.676    29.734     0.150
     1.676    51.133     0.150
     2.076    36.633     0.150
     1.972    32.934     0.150
     2.101    38.633     0.150
     2.060    36.336     0.150
     2.358    40.535     0.150
     2.485    43.453     0.150
     2.485    43.434     0.150
     2.850    47.633     0.150
     2.838    45.934     0.150
     3.097    52.805     0.150
     3.097    52.836     0.150
     3.144    52.734     0.150
     3.142    52.133     0.150
     3.767    59.734     0.150
     4.235    68.723     0.150
     4.897    73.633     0.150
     7.458   108.035     0.150
     7.458   123.234     0.150
     7.458   189.434     0.150
     0.509     9.574     0.150
     0.509    17.074     0.150
     0.538    10.676     0.150
     0.538    19.176     0.150
     0.566    10.676     0.150
     0.566    21.176     0.150
     0.756    15.375     0.150
     0.756    26.773     0.150
     0.774    14.676     0.150
     0.774    27.574     0.150
     0.860    17.273     0.150
     1.073    20.074     0.150
     1.114    18.773     0.150
     1.203    22.977     0.150
     1.203    40.977     0.150
     1.245    22.074     0.150
     1.451    25.977     0.150
     1.584    28.074     0.150
     1.663    29.273     0.150
     1.663    51.176     0.150
     1.739    30.875     0.150
     1.971    32.676     0.150
     2.051    35.273     0.150
     2.084    35.977     0.150
     2.107    38.176     0.150
     2.347    40.176     0.150
     2.494    42.273     0.150
     2.857    47.676     0.150
     3.151    53.586     0.150
     3.151    53.574     0.150
     3.752    60.375     0.150
     4.909    73.375     0.150
     5.104    75.477     0.150
     7.474   115.375     0.150
     7.474   108.074     0.150
     7.474   115.375     0.150
     7.474   189.375     0.150
     0.516    10.438     0.150
     0.516    18.039     0.150
     0.560    11.141     0.150
     0.560    18.340     0.150
     0.542    11.039     0.150
     0.768    28.891     0.150
     0.768    14.539     0.150
     0.768    28.840     0.150
     0.777    14.438     0.150
     0.777    26.340     0.150
     0.869    15.539     0.150
     0.869    29.539     0.150
     1.079    19.738     0.150
     1.079    34.539     0.150
     1.118    19.938     0.150
     1.118    39.641     0.150
     1.211    21.738     0.150
     1.457    26.438     0.150
     1.670    29.438     0.150
     1.670    51.738     0.150
     1.741    31.039     0.150
     1.864    32.340     0.150
     1.969    33.039     0.150
     2.055    35.738     0.150
     2.105    37.438     0.150
     2.352    40.340     0.150
     2.855    47.141     0.150
     2.835    45.938     0.150
     3.102    50.539     0.150
     3.148    51.039     0.150
     3.152    50.641     0.150
     3.136    49.840     0.150
     3.153    49.641     0.150
     3.197    51.641     0.150
     3.269    93.449     0.150
     3.299    93.020     0.150
     3.267    51.641     0.150
     3.801   107.539     0.150
     4.029    62.379     0.150
     4.029   109.668     0.150
     4.264   117.039     0.150
     4.451   120.309     0.150
     4.451    68.051     0.150
     4.451   120.309     0.150
     4.521   140.938     0.150
     4.521   162.539     0.150
     4.935    79.539     0.150
     4.935    88.641     0.150
     4.935   151.340     0.150
     4.935   160.039     0.150
     4.935   180.039     0.150
     6.321   161.879     0.150
     6.671   168.738     0.150
     6.671   173.539     0.150
     6.671   168.738     0.150
     6.671   173.539     0.150
     6.873   170.340     0.150
     6.914   182.840     0.150
     7.464   129.539     0.150
     7.688   248.879     0.150
     7.688   112.883     0.150
     7.688   195.281     0.150
     7.688   248.883     0.150
     8.272   130.340     0.150
     8.272   283.238     0.150
     8.440   132.039     0.150
     8.676   127.641     0.150
     8.676   137.539     0.150
     8.684   138.141     0.150
     8.684   292.840     0.150
     8.893   234.578     0.150
     8.920   130.695     0.150
     8.920   225.516     0.150
     9.172   264.738     0.150
     9.177   135.938     0.150
     9.177   143.340     0.150
     9.177   242.238     0.150
     9.177   272.438     0.150
     9.177   311.141     0.150
     9.180   139.340     0.150
     9.180   248.738     0.150
     9.180   305.039     0.150
     9.202   132.641     0.150
     9.202   230.539     0.150
     9.202   132.641     0.150
     9.202   230.539     0.150
     9.276   134.809     0.150
     9.276   236.703     0.150
     9.336   238.898     0.150
     9.336   136.773     0.150
     9.674   321.938     0.150
     9.674   139.340     0.150
     9.674   150.539     0.150
     9.674   243.340     0.150
     9.674   321.938     0.150
     9.946   145.945     0.150
     9.946   251.020     0.150
    10.328   150.512     0.150
    10.328   260.082     0.150
    10.832   157.449     0.150
    10.832   157.449     0.150
    10.899   153.438     0.150
    10.950   158.613     0.150
    10.950   274.312     0.150
    11.468   161.340     0.150
    12.183   175.180     0.150
    13.615   197.363     0.150
    13.964   202.215     0.150
    14.414   205.957     0.150
    15.062   219.273     0.150
    15.292     6.852     0.150
    16.613   236.934     0.150
    18.452   256.820     0.150
    18.471   256.879     0.150
    19.473   267.914     0.150
    20.226   276.738     0.150
    47.236   515.441     0.150
    47.234   514.676     0.150
    64.642   635.613     0.150
    68.510   661.871     0.150
    68.510     7.348     0.150
    81.111   735.113     0.150
    81.111     8.301     0.150
    82.121   740.738     0.150
    82.121     7.527     0.150
    89.525   778.625     0.150
     0.534    10.387     0.150
     0.534    19.785     0.150
     0.550    10.586     0.150
     0.550    18.984     0.150
     0.528    11.285     0.150
     0.528    18.387     0.150
     0.766    14.285     0.150
     0.766    27.188     0.150
     0.803    15.586     0.150
     0.878    15.785     0.150
     0.878    28.586     0.150
     0.800    17.484     0.150
     1.077    19.688     0.150
     1.215    23.387     0.150
     1.267    23.285     0.150
     1.456    27.188     0.150
     1.766    32.086     0.150
     1.944    33.984     0.150
     2.093    37.387     0.150
     2.499    42.188     0.150
     4.452   123.188     0.150
     6.392   168.984     0.150
     7.455   274.387     0.150
     7.455   110.484     0.150
     7.455   121.586     0.150
     7.455   190.887     0.150
     7.455   274.387     0.150
     0.513     9.289     0.150
     0.513    17.289     0.150
     0.522     9.984     0.150
     0.522    18.188     0.150
     0.561    10.984     0.150
     0.561    19.188     0.150
     0.751    13.984     0.150
     0.758    27.156     0.150
     0.758    13.289     0.150
     0.758    27.188     0.150
     0.843    28.961     0.150
     0.843    16.688     0.150
     0.843    28.984     0.150
     0.835    28.586     0.150
     1.056    19.086     0.150
     1.123    18.758     0.150
     1.123    18.789     0.150
     1.185    22.391     0.150
     1.185    38.086     0.150
     1.258    21.250     0.150
     1.258    21.289     0.150
     1.434    25.484     0.150
     1.645    29.086     0.150
     1.645    48.688     0.150
     1.749    30.891     0.150
     1.960    31.984     0.150
     2.035    34.586     0.150
     2.100    35.984     0.150
     2.330    39.688     0.150
     4.292    75.984     0.150
     4.426   121.188     0.150
     6.370   168.188     0.150
     0.510     9.820     0.150
     0.567    10.320     0.150
     0.567    19.219     0.150
     0.549    10.516     0.150
     0.549    19.617     0.150
     0.785    14.617     0.150
     0.785    27.617     0.150
     0.765    28.234     0.150
     0.765    15.016     0.150
     0.765    28.219     0.150
     0.875    30.914     0.150
     0.875    16.820     0.150
     0.875    30.914     0.150
     1.086    37.117     0.150
     1.086    19.719     0.150
     1.086    37.117     0.150
     1.110    19.578     0.150
     1.110    37.836     0.150
     1.110    19.617     0.150
     1.110    37.820     0.150
     1.217    22.820     0.150
     1.217    41.117     0.150
     1.238    23.914     0.150
     1.464    26.016     0.150
     1.584    27.617     0.150
     1.677    29.516     0.150
     1.733    31.219     0.150
     2.097    37.320     0.150
     2.359    40.414     0.150
     2.482    41.016     0.150
     2.847    46.719     0.150
     3.094    51.016     0.150
     3.143    51.617     0.150
     3.144    52.414     0.150
     4.896    73.016     0.150
     5.090    75.516     0.150
     6.356   167.516     0.150
     6.993   185.719     0.150
     7.459    99.617     0.150
     0.490     9.180     0.150
     0.490    15.883     0.150
     0.540    20.375     0.150
     0.540     9.883     0.150
     0.540    20.383     0.150
     0.584    11.680     0.150
     0.584    20.781     0.150
     0.734    26.820     0.150
     0.734    14.586     0.150
     0.734    26.781     0.150
     0.777    28.672     0.150
     0.777    14.086     0.150
     0.777    28.680     0.150
     0.851    16.680     0.150
     0.851    29.781     0.150
     1.100    18.539     0.150
     1.100    18.586     0.150
     1.100    36.586     0.150
     1.071    37.742     0.150
     1.071    18.781     0.150
     1.071    37.781     0.150
     1.236    20.680     0.150
     1.236    21.086     0.150
     1.197    40.359     0.150
     1.197    21.984     0.150
     1.197    40.383     0.150
     1.447    47.781     0.150
     1.447    25.086     0.150
     1.447    47.781     0.150
     1.566    29.055     0.150
     1.566    29.086     0.150
     1.726    30.484     0.150
     1.657    28.680     0.150
     2.081    35.086     0.150
     2.101    36.180     0.150
     1.983    31.883     0.150
     2.345    38.680     0.150
     2.851    46.383     0.150
     3.100    50.781     0.150
     3.146    50.680     0.150
     3.144    50.281     0.150
     3.185    51.680     0.150
     3.125    48.781     0.150
     3.299    52.781     0.150
     3.863    61.383     0.150
     3.751    58.680     0.150
     3.745    57.984     0.150
     3.753    57.781     0.150
     3.814    60.883     0.150
     3.940   109.570     0.150
     4.050    61.062     0.150
     4.050   109.031     0.150
     4.019   111.820     0.150
     4.081    60.680     0.150
     6.301   162.383     0.150
     6.730    94.281     0.150
     7.485   116.383     0.150
     7.485   137.383     0.150
     7.485   107.086     0.150
     7.485   116.383     0.150
     7.485   137.383     0.150
     7.485   190.086     0.150
     7.715   199.242     0.150
     7.715   113.250     0.150
     7.715   199.250     0.150
     8.469   218.484     0.150
     8.469   218.484     0.150
     8.927   130.766     0.150
     8.927   231.500     0.150
     9.198   138.586     0.150
     9.198   233.281     0.150
     9.198   320.484     0.150
     9.218   130.484     0.150
     9.218   130.484     0.150
     9.218   228.086     0.150
     9.694   339.781     0.150
     9.694   137.984     0.150
    18.474   256.117     0.150
    20.236   272.859     0.150
    47.228   509.445     0.150
    47.228   509.445     0.150
    67.777   656.508     0.150
    73.670   692.859     0.150
     0.507     9.733     0.150
     0.507    16.934     0.150
     0.529     9.934     0.150
     0.529    18.233     0.150
     0.743    27.033     0.150
     0.743    13.133     0.150
     0.743    27.033     0.150
     0.761    28.264     0.150
     0.761    14.833     0.150
     0.761    28.233     0.150
     0.943    18.033     0.150
     1.043    19.533     0.150
     1.140    21.323     0.150
     1.140    21.333     0.150
     1.174    21.633     0.150
     1.174    37.833     0.150
     1.275    22.233     0.150
     1.421    24.934     0.150
     1.605    27.934     0.150
     1.634    28.733     0.150
     1.634    48.333     0.150
     1.766    31.033     0.150
     1.943    31.633     0.150
     2.020    34.633     0.150
     2.115    35.434     0.150
     2.138    63.693     0.150
     2.138    37.033     0.150
     2.138    63.733     0.150
     2.316    39.733     0.150
     2.525    41.333     0.150
     2.887    47.033     0.150
     3.099    49.533     0.150
     3.136    50.333     0.150
     3.497    56.533     0.150
     3.724    59.434     0.150
     4.162    65.793     0.150
     4.275    67.724     0.150
     4.485    70.033     0.150
     4.485   120.104     0.150
     4.939    73.434     0.150
     5.025    74.533     0.150
     7.500   119.033     0.150
     7.500   147.033     0.150
     7.500   109.033     0.150
     7.500   119.033     0.150
     7.500   147.033     0.150
     7.500   187.934     0.150
     9.339   172.633     0.150
     0.534    20.629     0.150
     0.534    10.519     0.150
     0.534    20.618     0.150
     0.530    11.419     0.150
     0.530    20.019     0.150
     0.541    11.318     0.150
     0.541    20.618     0.150
     0.782    15.019     0.150
     0.782    26.118     0.150
     0.764    14.818     0.150
     0.764    27.519     0.150
     0.814    27.318     0.150
     0.865    15.719     0.150
     0.865    29.519     0.150
     1.136    39.249     0.150
     1.136    20.019     0.150
     1.136    39.219     0.150
     1.070    20.219     0.150
     1.262    22.419     0.150
     1.204    41.288     0.150
     1.204    22.719     0.150
     1.204    41.318     0.150
     1.448    27.019     0.150
     1.609    28.618     0.150
     1.663    30.219     0.150
     1.848    33.118     0.150
     1.951    33.618     0.150
     2.094    36.919     0.150
     2.120    38.318     0.150
     2.043    36.118     0.150
     2.342    40.519     0.150
     2.502    42.318     0.150
     2.869    48.618     0.150
     2.818    46.419     0.150
     3.116    52.419     0.150
     3.127    50.318     0.150
     3.151    51.419     0.150
     3.479    58.419     0.150
     3.519    56.118     0.150
     4.032   104.519     0.150
     3.971    64.719     0.150
     6.055    91.148     0.150
     6.234   156.019     0.150
     7.468   118.019     0.150
     7.468   221.019     0.150
     8.878   136.118     0.150
     8.878   136.117     0.150
     9.180   247.818     0.150
     9.180   300.618     0.150
     9.180   321.919     0.150
     9.180  1456.818     0.150
     9.180  1474.519     0.150
     9.180  1498.219     0.150
     9.678   202.019     0.150
    47.221   518.818     0.150
     0.392     7.641     0.150
     0.392    13.141     0.150
     0.499     9.740     0.150
     0.499    17.541     0.150
     0.536    20.730     0.150
     0.536    10.941     0.150
     0.536    20.740     0.150
     0.575    10.941     0.150
     0.575    20.842     0.150
     0.743    15.041     0.150
     0.743    25.240     0.150
     0.773    28.320     0.150
     0.773    14.641     0.150
     0.773    28.342     0.150
     0.852    16.842     0.150
     0.852    29.141     0.150
     1.069    20.141     0.150
     1.108    21.762     0.150
     1.108    21.740     0.150
     1.196    22.740     0.150
     1.196    40.740     0.150
     1.242    23.441     0.150
     1.446    26.541     0.150
     1.575    28.141     0.150
     1.734    30.941     0.150
     1.975    33.641     0.150
     2.049    36.041     0.150
     2.085    36.941     0.150
     2.106    38.240     0.150
     2.343    35.611     0.150
     2.343    35.641     0.150
     2.496    41.641     0.150
     2.856    47.842     0.150
     2.840    47.541     0.150
     3.105    52.041     0.150
     3.124    52.541     0.150
     3.192    52.641     0.150
     3.304    55.752     0.150
     3.304    55.740     0.150
     3.745    58.541     0.150
     3.755    59.740     0.150
     3.754    58.941     0.150
     4.288   109.041     0.150
     4.813    71.641     0.150
     5.831    86.041     0.150
     6.695  1110.641     0.150
     7.483   117.842     0.150
     7.483  2035.541     0.150
     9.196   139.842     0.150
     9.196   244.441     0.150
     9.196   324.740     0.150
     9.218   147.541     0.150
     9.218   325.541     0.150
     0.405     7.715     0.150
     0.405    13.914     0.150
     0.516     9.816     0.150
     0.516    17.516     0.150
     0.515    10.016     0.150
     0.558     9.914     0.150
     0.558    18.715     0.150
     0.750    15.957     0.150
     0.750    15.914     0.150
     0.752    15.766     0.150
     0.752    15.816     0.150
     0.752    26.016     0.150
     0.836    30.105     0.150
     0.836    16.617     0.150
     0.836    30.117     0.150
     1.049    20.016     0.150
     1.049    35.715     0.150
     1.128    19.477     0.150
     1.128    19.516     0.150
     1.178    22.516     0.150
     1.178    39.816     0.150
     1.263    23.316     0.150
     1.426    25.414     0.150
     1.426    45.516     0.150
     1.638    28.816     0.150
     1.638    51.516     0.150
     1.955    32.117     0.150
     2.028    34.617     0.150
     2.106    36.617     0.150
     2.323    39.414     0.150
     2.517    41.316     0.150
     4.430   122.215     0.150
     6.374   167.617     0.150
     0.394     7.480     0.150
     0.394    13.480     0.150
     0.498     9.582     0.150
     0.498    17.582     0.150
     0.544    21.453     0.150
     0.544    10.680     0.150
     0.544    21.480     0.150
     0.747    27.012     0.150
     0.747    14.883     0.150
     0.747    26.980     0.150
     0.781    28.242     0.150
     0.781    14.582     0.150
     0.781    28.281     0.150
     0.862    30.770     0.150
     0.862    16.781     0.150
     0.862    30.781     0.150
     1.104    19.160     0.150
     1.104    19.180     0.150
     1.078    20.082     0.150
     1.078    37.680     0.150
     1.236    21.602     0.150
     1.236    21.582     0.150
     1.206    22.883     0.150
     1.206    40.781     0.150
     1.455    26.180     0.150
     1.574    27.980     0.150
     1.666    29.082     0.150
     1.666    52.480     0.150
     1.729    30.883     0.150
     1.980    32.781     0.150
     2.057    35.980     0.150
     2.352    40.582     0.150
     2.488    40.680     0.150
     3.144    50.781     0.150
     4.141    67.000     0.150
     4.338    62.383     0.150
     4.339    64.961     0.150
     4.408   121.680     0.150
     4.904    73.480     0.150
     6.351   168.883     0.150
     7.473   118.781     0.150
     9.300   134.582     0.150
     9.300   236.781     0.150
     0.556    10.898     0.150
     0.556    18.398     0.150
     0.518    10.000     0.150
     0.518    19.398     0.150
     0.495    10.195     0.150
     0.495    17.500     0.150
     0.787    16.195     0.150
     0.787    27.195     0.150
     0.728    14.000     0.150
     0.728    24.500     0.150
     0.835    15.102     0.150
     1.165    20.242     0.150
     1.165    20.195     0.150
     1.035    19.500     0.150
     1.035    35.602     0.150
     1.295    22.469     0.150
     1.295    22.695     0.150
     1.414    26.000     0.150
     1.632    29.297     0.150
     1.630    29.195     0.150
     1.789    31.695     0.150
     1.814    32.102     0.150
     1.920    32.602     0.150
     2.008    35.500     0.150
     2.537    42.102     0.150
     2.904    48.297     0.150
     3.198    52.695     0.150
     3.094    49.898     0.150
     3.722    58.898     0.150
     3.735    58.602     0.150
     4.100    63.000     0.150
     4.360    79.398     0.150
     4.843    73.500     0.150
     5.037    75.898     0.150
     5.135    77.000     0.150
     6.691   223.500     0.150
     6.691  1980.297     0.150
     6.691   170.500     0.150
     7.051   101.195     0.150
     7.498   116.898     0.150
     7.498  1388.398     0.150
     7.498   109.398     0.150
     7.498   116.898     0.150
     7.498   125.898     0.150
     7.498   190.297     0.150
     8.017   149.797     0.150
     8.303   126.000     0.150
     8.872   132.195     0.150
     9.239   255.102     0.150
     9.239   316.398     0.150
     9.708   318.398     0.150
    20.908   282.875     0.150
     0.508     9.414     0.150
     0.492    10.016     0.150
     0.492    17.617     0.150
     0.566    10.617     0.150
     0.566    20.117     0.150
     0.724    13.617     0.150
     0.724    24.812     0.150
     0.798    28.859     0.150
     0.798    15.719     0.150
     0.798    28.812     0.150
     0.837    15.117     0.150
     0.837    28.617     0.150
     1.034    19.219     0.150
     1.172    21.516     0.150
     1.302    22.812     0.150
     1.413    25.617     0.150
     1.642    29.016     0.150
     1.797    31.914     0.150
     1.912    32.312     0.150
     2.004    34.617     0.150
     2.134    36.219     0.150
     2.541    41.812     0.150
     2.909    47.719     0.150
     3.818    97.273     0.150
     4.059    83.758     0.150
     4.357    70.516     0.150
     4.398    70.016     0.150
     4.468    67.516     0.150
     4.887    71.812     0.150
     7.496   198.016     0.150
     7.496   108.617     0.150
     7.496   123.016     0.150
     7.496   189.117     0.150
     7.496   198.016     0.150
     8.300   125.312     0.150
    19.504   276.367     0.150
    47.206   514.258     0.150
     0.501    10.629     0.150
     0.501    20.260     0.150
     0.501    10.639     0.150
     0.501    20.240     0.150
     0.541    11.540     0.150
     0.541    18.939     0.150
     0.574    11.740     0.150
     0.574    20.040     0.150
     0.748    27.790     0.150
     0.748    15.840     0.150
     0.748    27.840     0.150
     0.777    14.939     0.150
     0.777    26.439     0.150
     0.847    27.939     0.150
     0.859    16.040     0.150
     1.107    20.139     0.150
     1.075    20.939     0.150
     1.075    35.540     0.150
     1.239    36.659     0.150
     1.239    22.939     0.150
     1.203    23.340     0.150
     1.452    27.240     0.150
     1.576    28.740     0.150
     1.732    31.740     0.150
     1.868    32.840     0.150
     2.081    36.939     0.150
     2.102    38.139     0.150
     2.349    40.939     0.150
     2.491    42.540     0.150
     2.852    47.639     0.150
     3.101    52.139     0.150
     3.147    52.139     0.150
     3.147    51.939     0.150
     3.190    52.540     0.150
     3.130    50.139     0.150
     3.140    51.240     0.150
     3.300    54.740     0.150
     3.514    56.040     0.150
     4.951   150.340     0.150
     4.951   164.740     0.150
     4.951   196.740     0.150
     4.951    76.639     0.150
     4.951   135.939     0.150
     5.160   159.740     0.150
     5.396    82.340     0.150
     5.459    83.840     0.150
     5.375   144.399     0.150
     5.552    85.639     0.150
     5.705    87.840     0.150
     5.985    91.939     0.150
     6.055    92.639     0.150
     6.487    97.080     0.150
     6.687    97.040     0.150
     6.687   224.639     0.150
     6.724    98.040     0.150
     6.889   110.139     0.150
     6.889   174.340     0.150
     6.889   183.740     0.150
     7.475   109.240     0.150
     7.475   118.840     0.150
     7.475   118.840     0.150
     7.475   138.240     0.150
     7.475   138.240     0.150
     7.475   190.439     0.150
     7.475   229.240     0.150
     7.475   229.240     0.150
     7.475   109.240     0.150
     7.475   118.840     0.150
     7.475   138.240     0.150
     7.475   190.439     0.150
     7.475   229.240     0.150
     7.703   114.684     0.150
     7.703   198.604     0.150
     7.703   244.419     0.150
     8.101   121.129     0.150
     8.285   131.139     0.150
     8.285   275.639     0.150
     8.456   133.540     0.150
     8.912   133.198     0.150
     9.189   232.639     0.150
     9.189   318.240     0.150
     9.189   132.040     0.150
     9.189   232.639     0.150
     9.194   230.439     0.150
     9.194   302.340     0.150
     9.194   133.540     0.150
     9.194   230.439     0.150
     9.189   247.439     0.150
     9.211   132.340     0.150
     9.211   132.340     0.150
     9.211   230.240     0.150
     9.685   328.740     0.150
     9.685   139.740     0.150
     9.685   241.439     0.150
     9.685   274.740     0.150
     9.685   328.740     0.150
    12.180   174.580     0.150
    15.045   220.600     0.150
    18.480   260.327     0.150
    19.485   267.615     0.150
    20.232   280.440     0.150
    20.444   269.240     0.150
    20.523   286.840     0.150
    28.447   355.952     0.150
    31.607   388.840     0.150
    37.547   436.139     0.150
    38.446   444.740     0.150
    39.504   456.840     0.150
    47.231   518.728     0.150
    70.227   673.365     0.150
    73.658   699.990     0.150
    73.658   699.991     0.150
     0.515    16.390     0.150
     0.515     9.960     0.150
     0.515    16.359     0.150
     0.527    20.870     0.150
     0.527    11.060     0.150
     0.527    20.859     0.150
     0.560    10.960     0.150
     0.560    20.960     0.150
     0.756    14.060     0.150
     0.756    26.260     0.150
     0.763    27.750     0.150
     0.763    14.960     0.150
     0.763    27.760     0.150
     0.850    31.390     0.150
     0.850    15.359     0.150
     0.850    31.359     0.150
     1.122    19.439     0.150
     1.122    19.460     0.150
     1.063    20.160     0.150
     1.254    21.520     0.150
     1.254    21.560     0.150
     1.193    22.760     0.150
     1.440    26.660     0.150
     1.590    27.760     0.150
     1.652    29.460     0.150
     1.747    31.260     0.150
     1.854    32.359     0.150
     2.040    35.560     0.150
     2.336    40.160     0.150
     2.505    42.060     0.150
     2.827    45.760     0.150
     2.995    49.910     0.150
     3.162    51.359     0.150
     3.119    49.960     0.150
     3.505    55.260     0.150
     3.743    58.660     0.150
     3.759    59.760     0.150
     3.752    58.960     0.150
     3.806    60.060     0.150
     4.284   118.859     0.150
     4.448    69.760     0.150
     4.520   143.260     0.150
     4.824    72.359     0.150
     5.012    73.740     0.150
     5.360    73.979     0.150
     6.013    86.779     0.150
     6.081    89.420     0.150
     6.315    88.580     0.150
     6.315   160.899     0.150
     6.690   202.160     0.150
     6.690   202.160     0.150
     6.776    96.260     0.150
     7.180   109.859     0.150
     7.484   117.260     0.150
     7.484   238.760     0.150
     7.484   108.359     0.150
     7.484   117.260     0.150
     7.484   188.859     0.150
     8.292   119.359     0.150
     8.292   204.960     0.150
     8.292   204.960     0.150
     8.292   119.359     0.150
     8.292   204.960     0.150
     9.196   174.160     0.150
     9.196   223.660     0.150
     9.220   131.760     0.150
     9.220   131.760     0.150
     9.220   229.460     0.150
     0.425     8.203     0.150
     0.425    14.801     0.150
     0.531    10.203     0.150
     0.531    18.703     0.150
     0.522    20.352     0.150
     0.522    10.402     0.150
     0.522    20.402     0.150
     0.544    10.102     0.150
     0.544    18.602     0.150
     0.757    14.000     0.150
     0.757    25.703     0.150
     0.774    27.711     0.150
     0.774    16.301     0.150
     0.774    27.703     0.150
     0.854    16.301     0.150
     0.854    28.301     0.150
     1.061    19.902     0.150
     1.061    35.000     0.150
     1.136    19.602     0.150
     1.194    22.500     0.150
     1.194    40.902     0.150
     1.439    25.902     0.150
     1.653    29.102     0.150
     1.653    51.703     0.150
     1.760    31.301     0.150
     1.949    32.102     0.150
     2.035    35.102     0.150
     2.101    36.703     0.150
     2.125    34.801     0.150
     2.333    40.402     0.150
     2.510    41.703     0.150
     2.875    47.000     0.150
     3.122    51.801     0.150
     3.285    53.621     0.150
     3.744    60.391     0.150
     3.744    60.402     0.150
     4.314    69.000     0.150
     4.922    75.430     0.150
     4.922    75.402     0.150
     4.922   128.203     0.150
     5.113    76.301     0.150
     0.509     9.633     0.150
     0.509    16.734     0.150
     0.461     9.633     0.150
     0.461    17.633     0.150
     0.488    10.328     0.150
     0.615    11.734     0.150
     0.715    26.852     0.150
     0.715    13.531     0.150
     0.715    26.828     0.150
     0.852    16.734     0.150
     0.858    31.125     0.150
     0.858    15.531     0.150
     0.858    31.133     0.150
     1.037    18.633     0.150
     1.184    21.234     0.150
     1.184    40.734     0.150
     1.332    24.531     0.150
     1.418    25.734     0.150
     1.690    30.234     0.150
     1.639    29.234     0.150
     1.833    32.828     0.150
     1.878    31.930     0.150
     1.996    35.031     0.150
     2.149    36.828     0.150
     2.304    39.930     0.150
     2.552    42.430     0.150
     2.747    45.234     0.150
     4.422    67.531     0.150
     6.651   177.328     0.150
     6.651   164.234     0.150
     6.651   187.133     0.150
     6.651   210.828     0.150
     8.416   214.328     0.150
     8.695   221.328     0.150
     8.684   223.734     0.150
     9.226   133.133     0.150
     9.226   231.031     0.150
     9.226   133.133     0.150
     9.226   231.031     0.150
     9.688   261.031     0.150
     9.688   327.531     0.150
     9.688   139.133     0.150
     9.688   261.031     0.150
     9.688   261.031     0.150
     9.688   273.133     0.150
     9.688   327.531     0.150
    21.525   291.734     0.150
     0.272     5.609     0.150
     0.272     9.207     0.150
     0.401     7.508     0.150
     0.401    13.707     0.150
     0.456     8.707     0.150
     0.456    16.008     0.150
     0.514     9.609     0.150
     0.514    17.508     0.150
     0.511    19.527     0.150
     0.511     9.809     0.150
     0.511    19.508     0.150
     0.520     9.508     0.150
     0.560     9.508     0.150
     0.560    18.309     0.150
     0.561    10.707     0.150
     0.561    18.008     0.150
     0.744    15.699     0.150
     0.744    15.707     0.150
     0.744    25.508     0.150
     0.748    15.637     0.150
     0.748    26.297     0.150
     0.748    15.609     0.150
     0.748    26.309     0.150
     0.829    16.508     0.150
     0.829    27.809     0.150
     1.044    35.168     0.150
     1.044    19.008     0.150
     1.044    35.207     0.150
     1.127    19.109     0.150
     1.127    35.109     0.150
     1.172    39.098     0.150
     1.172    22.309     0.150
     1.172    39.109     0.150
     1.265    23.707     0.150
     1.265    40.508     0.150
     1.421    42.598     0.150
     1.421    25.309     0.150
     1.421    42.609     0.150
     1.590    28.508     0.150
     1.632    28.508     0.150
     1.632    50.906     0.150
     1.723    30.109     0.150
     1.755    30.508     0.150
     1.954    31.707     0.150
     1.954    57.309     0.150
     2.024    34.406     0.150
     2.110    35.406     0.150
     2.130    36.609     0.150
     2.318    37.527     0.150
     2.318    37.508     0.150
     2.521    40.809     0.150
     2.881    46.707     0.150
     3.130    50.809     0.150
     3.175    51.109     0.150
     4.305    69.508     0.150
     4.305   116.707     0.150
     4.834    73.609     0.150
     4.938    72.508     0.150
     5.422    79.008     0.150
     5.592    85.207     0.150
     6.117   164.508     0.150
     7.505   111.008     0.150
     7.505   208.508     0.150
     7.505   111.008     0.150
     7.505   120.008     0.150
     7.505   188.008     0.150
     7.505   208.508     0.150
     9.241   310.508     0.150
     9.712   134.609     0.150
     0.245     6.648     0.150
     0.245    11.238     0.150
     0.245     6.598     0.150
     0.245    11.195     0.150
     0.425     8.398     0.150
     0.425    13.598     0.150
     0.480     9.598     0.150
     0.480    15.598     0.150
     0.533    10.496     0.150
     0.533    18.098     0.150
     0.518    10.797     0.150
     0.518    19.695     0.150
     0.548    10.297     0.150
     0.548    16.996     0.150
     0.542    10.496     0.150
     0.542    18.797     0.150
     0.581    11.398     0.150
     0.581    18.598     0.150
     0.773    14.797     0.150
     0.773    26.996     0.150
     0.753    14.098     0.150
     0.849    15.098     0.150
     1.056    36.348     0.150
     1.056    19.496     0.150
     1.056    36.398     0.150
     1.139    19.898     0.150
     1.189    22.098     0.150
     1.269    22.547     0.150
     1.269    22.598     0.150
     1.434    26.695     0.150
     1.608    28.398     0.150
     1.763    31.695     0.150
     1.946    33.098     0.150
     2.031    35.695     0.150
     2.105    36.898     0.150
     2.129    37.898     0.150
     2.514    41.898     0.150
     2.812    46.398     0.150
     2.879    47.898     0.150
     3.126    52.098     0.150
     3.113    50.996     0.150
     3.173    52.598     0.150
     3.176    51.996     0.150
     3.751    57.996     0.150
     4.347    70.297     0.150
     4.347    87.797     0.150
     4.347    90.797     0.150
     4.385    70.195     0.150
     5.567    84.496     0.150
     5.798    92.297     0.150
     6.105   163.996     0.150
     6.248    96.898     0.150
     7.484   209.797     0.150
     7.484   109.797     0.150
     7.484   121.297     0.150
     7.484   189.195     0.150
     7.484   209.797     0.150
     8.291   207.496     0.150
     9.223   310.297     0.150
    20.903   285.922     0.150
    46.654   504.945     0.150
    47.231   508.477     0.150
    47.231   508.473     0.150
     0.253     5.828     0.150
     0.253     9.625     0.150
     0.461     8.922     0.150
     0.461    15.227     0.150
     0.502     9.922     0.150
     0.502    16.727     0.150
     0.530     9.727     0.150
     0.530    17.227     0.150
     0.541     9.727     0.150
     0.534     9.727     0.150
     0.534    18.125     0.150
     0.562    11.023     0.150
     0.562    18.125     0.150
     0.764    16.469     0.150
     0.764    16.422     0.150
     0.830    16.523     0.150
     1.039    19.125     0.150
     1.039    33.922     0.150
     1.170    39.047     0.150
     1.170    21.227     0.150
     1.170    39.023     0.150
     1.145    19.297     0.150
     1.145    19.328     0.150
     1.145    38.523     0.150
     1.280    23.523     0.150
     1.417    25.328     0.150
     1.610    27.625     0.150
     1.735    30.328     0.150
     1.938    31.828     0.150
     1.938    56.523     0.150
     2.015    34.828     0.150
     2.120    34.828     0.150
     2.142    36.828     0.150
     2.312    38.727     0.150
     2.530    40.727     0.150
     2.530    72.125     0.150
     2.802    44.422     0.150
     2.892    46.922     0.150
     3.140    50.922     0.150
     3.188    50.727     0.150
     3.721    58.828     0.150
     3.732    59.312     0.150
     3.732    59.328     0.150
     4.366    70.125     0.150
     4.830    74.523     0.150
     4.944    72.328     0.150
     5.136    76.727     0.150
     5.586    85.023     0.150
     5.586   149.023     0.150
     6.120    93.727     0.150
     6.120   164.328     0.150
     7.503   186.625     0.150
     7.503   110.227     0.150
     7.503   186.625     0.150
     7.503   110.227     0.150
     7.503   123.125     0.150
     7.503   186.625     0.150
     0.196     4.758     0.150
     0.196     7.555     0.150
     0.463     9.156     0.150
     0.471     8.953     0.150
     0.471    15.953     0.150
     0.472     8.555     0.150
     0.472    16.555     0.150
     0.555    11.258     0.150
     0.556     9.953     0.150
     0.556    20.156     0.150
     0.602    10.656     0.150
     0.602    20.258     0.150
     0.747    26.859     0.150
     0.822    15.258     0.150
     0.823    16.453     0.150
     1.008    17.758     0.150
     1.151    21.156     0.150
     1.211    22.266     0.150
     1.211    22.258     0.150
     1.339    24.359     0.150
     1.608    28.359     0.150
     1.787    30.953     0.150
     1.835    31.859     0.150
     1.875    31.359     0.150
     1.974    33.055     0.150
     2.196    38.555     0.150
     2.278    39.453     0.150
     2.572    41.859     0.150
     4.372    70.453     0.150
     4.853    79.656     0.150
     7.268   102.953     0.150
     7.512   111.555     0.150
     0.286     6.816     0.150
     0.385     7.418     0.150
     0.497     9.516     0.150
     0.518     9.816     0.150
     0.523    10.719     0.150
     0.577    10.719     0.150
     0.567    11.316     0.150
     0.835    15.016     0.150
     1.111    19.016     0.150
     1.054    19.117     0.150
     1.250    21.277     0.150
     1.250    20.816     0.150
     1.180    22.316     0.150
     1.430    26.219     0.150
     1.573    27.617     0.150
     1.709    29.418     0.150
     1.739    29.418     0.150
     1.640    29.117     0.150
     1.857    32.117     0.150
     1.970    32.816     0.150
     2.097    35.418     0.150
     2.036    35.418     0.150
     2.328    39.918     0.150
     2.510    41.219     0.150
     2.867    46.617     0.150
     2.834    45.516     0.150
     3.159    50.219     0.150
     3.108    49.918     0.150
     3.736    59.066     0.150
     4.366    66.578     0.150
     4.366    86.617     0.150
     4.366   115.617     0.150
     4.536    74.816     0.150
     4.536   160.219     0.150
     4.958    87.617     0.150
     4.958   159.617     0.150
     4.958   174.117     0.150
     4.958   182.617     0.150
     4.958   196.117     0.150
     6.109   163.719     0.150
     6.358   164.918     0.150
     6.403    92.906     0.150
     6.498    97.938     0.150
     6.713    95.918     0.150
     6.713   113.117     0.150
     6.713   170.719     0.150
     6.713   240.617     0.150
     6.915   105.516     0.150
     6.915   109.719     0.150
     6.915   115.918     0.150
     6.915   136.617     0.150
     6.915   178.219     0.150
     6.915   103.516     0.150
     6.915   105.516     0.150
     6.915   109.719     0.150
     6.915   115.918     0.150
     6.915   136.617     0.150
     6.915   175.316     0.150
     6.915   178.219     0.150
     7.501   138.117     0.150
     7.501   155.617     0.150
     7.501   205.918     0.150
     7.501   108.219     0.150
     7.501   120.117     0.150
     7.501   138.117     0.150
     7.501   155.617     0.150
     7.501   188.918     0.150
     7.501   205.918     0.150
     7.729   115.074     0.150
     7.729   197.441     0.150
     7.729   245.488     0.150
     8.079   114.016     0.150
     8.018   139.617     0.150
     8.311   223.016     0.150
     9.221   246.617     0.150
     9.235   133.219     0.150
     9.235   133.219     0.150
     9.235   230.016     0.150
     9.710   241.617     0.150
     9.710   322.617     0.150
     9.710   140.617     0.150
     9.710   151.516     0.150
     9.710   191.617     0.150
     9.710   241.617     0.150
     9.710   322.617     0.150
    11.344   161.617     0.150
    14.393   200.984     0.150
    18.475   254.980     0.150
    19.510   267.285     0.150
    21.522   296.617     0.150
    21.522   306.617     0.150
    28.473   356.270     0.150
    32.820   395.719     0.150
    61.279   621.727     0.150
    68.538   662.414     0.150
    82.140   738.594     0.150
    89.372   776.469     0.150
     0.372     7.316     0.150
     0.372    12.316     0.150
     0.465     9.020     0.150
     0.465    15.816     0.150
     0.482     9.316     0.150
     0.482    17.020     0.150
     0.521     9.719     0.150
     0.521    17.520     0.150
     0.539    20.430     0.150
     0.539    10.719     0.150
     0.539    20.418     0.150
     0.577    11.316     0.150
     0.592    10.617     0.150
     0.592    20.816     0.150
     0.722    14.918     0.150
     0.845    14.617     0.150
     0.845    29.617     0.150
     1.068    19.918     0.150
     1.191    22.719     0.150
     1.233    21.520     0.150
     1.443    26.219     0.150
     1.652    29.719     0.150
     1.987    32.719     0.150
     2.051    35.418     0.150
     2.082    36.520     0.150
     2.100    37.719     0.150
     2.342    40.918     0.150
     2.495    41.520     0.150
     2.851    47.020     0.150
     3.143    51.816     0.150
     3.739    59.617     0.150
     4.391   116.219     0.150
     4.829    72.219     0.150
     4.916    74.020     0.150
     6.240    96.816     0.150
     7.492   116.918     0.150
     7.492   179.918     0.150
     0.487     9.188     0.150
     0.487    16.688     0.150
     0.536    10.188     0.150
     0.536    18.188     0.150
     0.523     9.389     0.150
     0.523    17.688     0.150
     0.587    10.188     0.150
     0.587    19.389     0.150
     0.577    10.889     0.150
     0.727    26.578     0.150
     0.727    14.389     0.150
     0.727    26.589     0.150
     0.844    29.979     0.150
     0.844    14.589     0.150
     0.844    29.988     0.150
     1.066    19.288     0.150
     1.066    36.688     0.150
     1.099    18.688     0.150
     1.190    21.988     0.150
     1.190    40.288     0.150
     1.237    20.988     0.150
     1.442    25.589     0.150
     1.563    27.288     0.150
     1.727    30.488     0.150
     2.049    34.889     0.150
     2.103    36.589     0.150
     2.340    39.889     0.150
     2.497    40.688     0.150
     3.104    50.389     0.150
     3.120    49.589     0.150
     3.146    50.389     0.150
     3.122    50.589     0.150
     3.739    58.488     0.150
     3.746    58.188     0.150
     4.162    66.708     0.150
     4.275   117.658     0.150
     4.300   471.288     0.150
     4.485   114.198     0.150
     4.822   122.688     0.150
     4.917    73.188     0.150
     4.996    74.089     0.150
     5.488    85.188     0.150
     6.098    92.788     0.150
     7.492   135.188     0.150
     0.431     8.447     0.150
     0.431    14.647     0.150
     0.485     9.447     0.150
     0.485    16.547     0.150
     0.537    10.447     0.150
     0.537    18.347     0.150
     0.519    20.228     0.150
     0.519    10.547     0.150
     0.519    20.247     0.150
     0.554    10.347     0.150
     0.554    18.447     0.150
     0.538    10.247     0.150
     0.538    19.347     0.150
     0.585    11.547     0.150
     0.853    30.867     0.150
     0.853    17.247     0.150
     0.853    30.847     0.150
     1.058    19.747     0.150
     1.058    36.547     0.150
     1.142    19.847     0.150
     1.192    23.047     0.150
     1.192    40.747     0.150
     1.271    22.447     0.150
     1.651    29.547     0.150
     1.651    52.247     0.150
     1.766    31.547     0.150
     1.944    32.447     0.150
     2.105    36.047     0.150
     4.807    74.647     0.150
     4.807   120.547     0.150
     5.563   139.847     0.150
     6.103    94.447     0.150
     6.621   169.747     0.150
     6.982   180.946     0.150
     7.480   111.547     0.150
     8.693   226.647     0.150
     9.219   312.247     0.150
     0.317     6.773     0.150
     0.317    11.367     0.150
     0.472     8.969     0.150
     0.472    15.672     0.150
     0.457     9.570     0.150
     0.457     9.570     0.150
     0.457    16.273     0.150
     0.521     9.672     0.150
     0.521    18.172     0.150
     0.559    10.672     0.150
     0.617    10.570     0.150
     0.617    21.469     0.150
     0.705    14.867     0.150
     0.714    13.273     0.150
     0.799    15.273     0.150
     0.799    27.773     0.150
     0.856    14.867     0.150
     1.085    20.172     0.150
     1.069    21.094     0.150
     1.069    21.070     0.150
     1.205    21.969     0.150
     1.210    23.531     0.150
     1.210    23.570     0.150
     1.460    26.570     0.150
     1.667    29.070     0.150
     1.698    30.867     0.150
     2.062    35.773     0.150
     4.252    79.969     0.150
     4.301   120.969     0.150
     4.351    77.672     0.150
     4.351   146.070     0.150
     4.351    77.672     0.150
     4.351   146.070     0.150
     4.381    84.570     0.150
     7.483   211.570     0.150
     0.316     6.352     0.150
     0.316    12.352     0.150
     0.466     8.953     0.150
     0.466    16.352     0.150
     0.455     8.652     0.150
     0.455    15.250     0.150
     0.506     9.250     0.150
     0.506    16.051     0.150
     0.542    10.152     0.150
     0.571    10.750     0.150
     0.609    10.453     0.150
     0.703    14.652     0.150
     0.722    12.953     0.150
     0.781    27.953     0.150
     0.781    14.750     0.150
     0.781    27.953     0.150
     0.838    16.152     0.150
     1.067    20.051     0.150
     1.067    36.352     0.150
     1.187    22.051     0.150
     1.226    22.652     0.150
     1.441    25.250     0.150
     1.648    28.750     0.150
     1.712    30.352     0.150
     1.998    32.551     0.150
     2.053    34.953     0.150
     4.315    68.051     0.150
     4.368    79.453     0.150
     4.368   148.852     0.150
     4.368    79.453     0.150
     4.368    98.352     0.150
     4.368   148.852     0.150
     4.399    90.051     0.150
     4.989    89.352     0.150
     6.216    89.852     0.150
     6.710    96.852     0.150
     7.443   113.852     0.150
     7.501   116.352     0.150
     7.501   137.852     0.150
     7.501   107.953     0.150
     7.501   116.352     0.150
     7.501   121.852     0.150
     7.501   137.852     0.150
     7.501   188.250     0.150
     0.261     5.891     0.150
     0.261    10.789     0.150
     0.520     9.789     0.150
     0.467     8.891     0.150
     0.467    16.789     0.150
     0.533     9.688     0.150
     0.533    18.891     0.150
     0.515     9.891     0.150
     0.554     9.891     0.150
     0.571    10.789     0.150
     0.756    13.789     0.150
     0.752    13.688     0.150
     0.839    14.789     0.150
     0.839    28.289     0.150
     1.051    19.289     0.150
     1.181    21.188     0.150
     1.428    25.391     0.150
     1.757    29.992     0.150
     1.641    28.492     0.150
     1.952    31.688     0.150
     2.106    35.492     0.150
     2.128    36.992     0.150
     2.029    34.594     0.150
     2.290    37.891     0.150
     2.516    40.992     0.150
     3.126    50.891     0.150
     3.172    50.891     0.150
     3.215    52.492     0.150
     3.731    58.289     0.150
     4.189    64.891     0.150
     4.189   113.188     0.150
     4.293   120.094     0.150
     4.359    69.688     0.150
     4.514    74.188     0.150
     4.934   149.391     0.150
     4.934   170.891     0.150
     4.934   187.391     0.150
     4.934    75.289     0.150
     4.934    83.688     0.150
     4.934   130.391     0.150
     4.934   149.391     0.150
     4.934   170.891     0.150
     4.934   187.391     0.150
     5.156    90.922     0.150
     5.494   146.094     0.150
     5.768    85.789     0.150
     5.863   147.492     0.150
     5.871   154.992     0.150
     6.254   158.094     0.150
     6.613   161.594     0.150
     6.657   105.391     0.150
     6.699   110.992     0.150
     6.699   189.188     0.150
     6.937    98.992     0.150
     6.901   106.188     0.150
     6.901   120.094     0.150
     6.901   170.594     0.150
     6.901   193.992     0.150
     6.901   241.289     0.150
     6.901   106.188     0.150
     6.901   120.094     0.150
     6.901   170.594     0.150
     6.901   193.992     0.150
     6.901   241.289     0.150
     6.983   171.789     0.150
     7.495   157.391     0.150
     7.495   108.289     0.150
     7.495   119.391     0.150
     7.495   157.391     0.150
     7.495   187.992     0.150
     7.388   105.391     0.150
     7.717   115.367     0.150
     7.717   115.367     0.150
     7.717   194.258     0.150
     8.303   223.789     0.150
     8.706   213.992     0.150
     9.207   128.492     0.150
     9.207   258.594     0.150
     9.207   306.391     0.150
     9.210   146.891     0.150
     9.210   243.391     0.150
     9.210   299.891     0.150
     9.232   133.289     0.150
     9.232   133.289     0.150
     9.232   228.891     0.150
     9.704   292.391     0.150
     9.704   320.391     0.150
    18.482   257.133     0.150
    19.504   270.188     0.150
    19.504   270.789     0.150
    19.504   270.789     0.150
    20.207   275.992     0.150
    21.576   286.094     0.150
    47.247   512.609     0.150
     0.285     6.225     0.150
     0.285    10.025     0.150
     0.489     9.325     0.150
     0.544    20.355     0.150
     0.544    10.125     0.150
     0.544    20.325     0.150
     0.585    10.225     0.150
     0.585    19.225     0.150
     0.589    11.025     0.150
     0.746    23.525     0.150
     0.746    12.925     0.150
     0.746    23.525     0.150
     0.782    15.375     0.150
     0.782    27.785     0.150
     0.782    15.425     0.150
     0.782    27.825     0.150
     0.859    16.325     0.150
     0.859    28.625     0.150
     0.857    30.515     0.150
     0.857    16.425     0.150
     0.857    30.525     0.150
     1.097    18.825     0.150
     1.076    20.025     0.150
     1.076    36.325     0.150
     1.202    22.525     0.150
     1.202    38.525     0.150
     1.453    25.425     0.150
     7.479   112.525     0.150
     0.286     6.107     0.150
     0.286     9.708     0.150
     0.491     9.208     0.150
     0.491    16.508     0.150
     0.537    10.107     0.150
     0.537    18.508     0.150
     0.583    11.907     0.150
     0.583    19.808     0.150
     0.748    12.808     0.150
     0.775    15.288     0.150
     0.775    27.397     0.150
     0.775    15.308     0.150
     0.775    27.407     0.150
     0.848    29.668     0.150
     0.848    16.208     0.150
     0.848    29.708     0.150
     0.858    16.107     0.150
     0.858    28.708     0.150
     1.101    18.607     0.150
     1.068    20.107     0.150
     1.068    37.107     0.150
     1.238    21.808     0.150
     1.194    22.308     0.150
     1.194    40.008     0.150
     1.444    25.508     0.150
     2.868    73.478     0.150
     3.812    44.308     0.150
     4.353    73.808     0.150
     4.353   114.808     0.150
     4.962    91.808     0.150
     5.840    92.508     0.150
     5.840   103.107     0.150
     6.683    92.808     0.150
     7.487   118.808     0.150
     7.487   108.208     0.150
     7.487   188.208     0.150
     8.697   221.208     0.150
     9.201   210.907     0.150
     9.201   240.607     0.150
     9.221   306.808     0.150
     0.300     6.453     0.150
     0.478     9.053     0.150
     0.478    16.854     0.150
     0.544    10.453     0.150
     0.544    19.354     0.150
     0.581    11.053     0.150
     0.597    12.453     0.150
     0.597    20.953     0.150
     0.734    12.652     0.150
     0.782    14.453     0.150
     0.782    26.652     0.150
     0.848    17.053     0.150
     0.871    31.062     0.150
     0.871    17.652     0.150
     0.871    31.053     0.150
     1.073    19.553     0.150
     1.073    34.754     0.150
     1.089    18.553     0.150
     1.196    22.652     0.150
     1.228    21.152     0.150
     1.448    25.754     0.150
     1.657    29.152     0.150
     1.717    30.354     0.150
     1.992    32.754     0.150
     2.056    35.652     0.150
     2.095    37.254     0.150
     2.263    39.613     0.150
     2.263    39.652     0.150
     2.347    40.453     0.150
     2.846    46.854     0.150
     2.856    48.053     0.150
     3.126    53.254     0.150
     3.176    52.053     0.150
     3.294    44.783     0.150
     3.294    44.754     0.150
     3.456    56.754     0.150
     3.743    59.854     0.150
     4.069    66.553     0.150
     4.284    68.254     0.150
     4.299   112.754     0.150
     4.968    78.232     0.150
     5.744    90.863     0.150
     6.346    96.754     0.150
     6.603   176.053     0.150
     7.488   115.453     0.150
     7.488   155.453     0.150
     7.488   107.754     0.150
     7.488   189.453     0.150
     8.697   215.152     0.150
     9.221   305.453     0.150
     0.297     6.281     0.150
     0.297    10.680     0.150
     0.371     7.281     0.150
     0.371    12.781     0.150
     0.471     9.281     0.150
     0.568    10.180     0.150
     0.604    11.980     0.150
     0.604    21.879     0.150
     0.729    14.480     0.150
     0.727    15.078     0.150
     0.878    16.680     0.150
     0.878    30.078     0.150
     1.099    19.879     0.150
     1.099    36.980     0.150
     1.075    20.789     0.150
     1.075    20.781     0.150
     1.208    24.090     0.150
     1.208    24.078     0.150
     1.684    28.879     0.150
     1.700    30.680     0.150
     2.009    33.379     0.150
     2.081    36.578     0.150
     2.053    35.578     0.150
     2.072    37.180     0.150
     2.238    39.219     0.150
     2.238    39.180     0.150
     2.465    40.781     0.150
     2.874    47.281     0.150
     3.072    51.180     0.150
     3.118    51.781     0.150
     4.379   112.781     0.150
     4.360    68.980     0.150
     0.054     2.883     0.150
     0.054     4.164     0.150
     0.246     5.711     0.150
     0.246     9.344     0.150
     0.424     7.812     0.150
     0.424    14.359     0.150
     0.515     9.773     0.150
     0.515    18.273     0.150
     0.533     9.852     0.150
     0.533    18.469     0.150
     0.542     9.539     0.150
     0.542    18.711     0.150
     0.750    26.219     0.150
     0.750    13.492     0.150
     0.750    26.258     0.150
     0.771    15.109     0.150
     0.789    13.539     0.150
     0.816    28.219     0.150
     0.816    15.758     0.150
     0.816    28.242     0.150
     1.053    18.977     0.150
     1.053    35.648     0.150
     1.140    19.250     0.150
     1.271    22.977     0.150
     1.431    26.922     0.150
     1.431    26.883     0.150
     1.431    44.172     0.150
     1.645    28.703     0.150
     1.765    30.977     0.150
     1.945    31.750     0.150
     2.028    35.383     0.150
     2.108    35.750     0.150
     2.132    36.867     0.150
     2.326    39.633     0.150
     2.517    41.102     0.150
     2.810    45.102     0.150
     2.881    47.344     0.150
     3.736    58.602     0.150
     3.747    57.914     0.150
     3.761    59.188     0.150
     7.006    99.523     0.150
     7.027    99.617     0.150
     9.226   227.320     0.150
     9.226   299.320     0.150
     9.226   319.320     0.150
     0.269     6.185     0.150
     0.511     9.654     0.150
     0.468     9.085     0.150
     0.523    10.234     0.150
     0.563    10.225     0.150
     0.767    13.285     0.150
     0.759    13.495     0.150
     0.759    26.064     0.150
     0.842    26.545     0.150
     0.842    14.575     0.150
     0.842    26.505     0.150
     1.057    19.305     0.150
     1.256    21.635     0.150
     1.434    25.715     0.150
     1.646    28.715     0.150
     1.747    29.535     0.150
     1.962    32.205     0.150
     2.120    36.654     0.150
     2.036    34.864     0.150
     2.283    37.814     0.150
     2.509    40.895     0.150
     2.870    47.194     0.150
     2.826    44.975     0.150
     3.118    50.904     0.150
     3.164    51.114     0.150
     3.164    50.604     0.150
     3.113    49.524     0.150
     3.125    50.274     0.150
     3.497    54.015     0.150
     3.744    58.435     0.150
     3.956    64.845     0.150
     4.293   115.045     0.150
     4.392    69.645     0.150
     4.821   111.845     0.150
     5.015    75.185     0.150
     5.490   129.645     0.150
     5.580   130.944     0.150
     6.022   145.045     0.150
     6.106    92.645     0.150
     6.106   149.245     0.150
     6.104   146.944     0.150
     6.249   151.944     0.150
     6.620   161.444     0.150
     6.700   173.845     0.150
     6.700   222.045     0.150
     6.700   107.145     0.150
     6.700   114.045     0.150
     6.700   173.845     0.150
     6.700   222.045     0.150
     6.777   100.825     0.150
     8.300   122.444     0.150
     9.228   133.245     0.150
     9.228   133.245     0.150
     9.228   228.444     0.150
    19.501   271.645     0.150
    19.501   269.576     0.150
    68.534   666.239     0.150
    73.651   698.045     0.150
     0.070     3.328     0.150
     0.070     4.770     0.150
     0.277     6.457     0.150
     0.466     8.977     0.150
     0.525    10.438     0.150
     0.571    10.418     0.150
     0.760    16.027     0.150
     0.760    15.977     0.150
     0.741    13.457     0.150
     0.845    16.250     0.150
     1.115    18.816     0.150
     1.058    19.250     0.150
     1.251    20.918     0.150
     1.435    25.879     0.150
     1.435    43.797     0.150
     1.709    31.129     0.150
     1.709    31.090     0.150
     1.742    29.598     0.150
     1.646    28.887     0.150
     1.968    32.500     0.150
     2.095    35.379     0.150
     2.039    35.066     0.150
     2.507    40.977     0.150
     2.841    46.637     0.150
     2.866    47.309     0.150
     3.115    50.680     0.150
     3.161    51.418     0.150
     3.200    51.379     0.150
     3.122    50.000     0.150
     3.113    49.680     0.150
     3.660    91.629     0.150
     3.813    98.828     0.150
     4.091    63.789     0.150
     4.358    66.629     0.150
     4.358   115.629     0.150
     4.530    80.930     0.150
     4.990   130.129     0.150
     4.950   135.328     0.150
     4.950   135.828     0.150
     5.348    73.289     0.150
     5.561    82.289     0.150
     5.854   150.527     0.150
     6.509    93.328     0.150
     6.607    99.930     0.150
     6.607   238.027     0.150
     6.607   173.828     0.150
     6.607   238.027     0.150
     6.660    94.828     0.150
     6.704   219.629     0.150
     6.704   168.227     0.150
     6.704   219.629     0.150
     6.650    89.328     0.150
     6.925   101.629     0.150
     6.906   203.828     0.150
     6.906   174.027     0.150
     6.906   203.828     0.150
     7.493   118.828     0.150
     7.493   206.328     0.150
     7.493   108.227     0.150
     7.493   189.328     0.150
     7.493   108.227     0.150
     7.493   189.328     0.150
     7.404   106.328     0.150
     8.472   123.430     0.150
     8.472   214.527     0.150
     8.486   120.887     0.150
     8.725   230.727     0.150
     9.206   188.129     0.150
     9.206   240.027     0.150
     9.206   132.828     0.150
     9.206   240.027     0.150
     9.212   140.727     0.150
     9.212   278.129     0.150
     9.212   132.727     0.150
     9.212   232.629     0.150
     9.229   132.227     0.150
     9.229   132.227     0.150
     9.229   229.930     0.150
     9.205   141.527     0.150
     9.205   256.828     0.150
     9.205   141.527     0.150
     9.703   241.828     0.150
     9.703   321.828     0.150
     9.703   330.828     0.150
     9.703   138.828     0.150
     9.703   142.629     0.150
     9.703   241.828     0.150
     9.703   321.828     0.150
    14.400   202.004     0.150
    20.456   293.930     0.150
    20.456   494.430     0.150
    20.526   284.930     0.150
    20.923   281.754     0.150
    22.610   308.328     0.150
    37.556   438.777     0.150
    38.315   443.227     0.150
    38.455   446.527     0.150
    47.262   513.305     0.150
    47.262     5.223     0.150
    51.923     5.000     0.150
    51.923     7.000     0.150
    51.923   736.930     0.150
    52.894   553.754     0.150
    58.122   598.527     0.150
    58.539   601.430     0.150
    61.270   620.707     0.150
    68.504   666.949     0.150
    68.504   666.930     0.150
    68.533   661.824     0.150
    68.533     3.449     0.150
    72.274   689.027     0.150
     0.144     2.451     0.150
     0.249     3.650     0.150
     0.249     3.660     0.150
     0.366     5.951     0.150
     0.366     5.980     0.150
     0.366    11.820     0.150
     0.579    10.051     0.150
     0.600    11.400     0.150
     0.600    21.820     0.150
     0.685    25.250     0.150
     0.685    12.791     0.150
     0.685    25.260     0.150
     1.059    19.510     0.150
     1.059    36.480     0.150
     1.060    19.350     0.150
     1.060    35.391     0.150
     1.275    42.150     0.150
     1.275    22.451     0.150
     1.275    42.160     0.150
     1.350    23.740     0.150
     1.380    24.500     0.150
     1.419    24.471     0.150
     1.419    45.170     0.150
     1.495    24.961     0.150
     1.692    29.551     0.150
     1.692    29.561     0.150
     1.673    28.131     0.150
     1.847    31.680     0.150
     2.212    37.320     0.150
     2.403    39.420     0.150
     2.374    37.891     0.150
     2.469    39.420     0.150
     2.615    41.180     0.150
     3.196    99.150     0.150
     3.201   109.650     0.150
     3.271    51.221     0.150
     3.493    54.711     0.150
     3.705    57.541     0.150
     4.102   102.451     0.150
     4.407    94.951     0.150
     4.494    68.781     0.150
     4.626    67.051     0.150
     4.882    70.830     0.150
     5.406    80.660     0.150
     6.013    88.260     0.150
     6.468   170.551     0.150
     6.468   206.650     0.150
     0.234     5.184     0.150
     0.234     9.734     0.150
     0.434     7.205     0.150
     0.548     9.234     0.150
     0.548     9.225     0.150
     0.548    19.574     0.150
     0.490     7.535     0.150
     0.490     7.523     0.150
     0.527    10.705     0.150
     0.505     9.273     0.150
     0.505    17.414     0.150
     0.804    15.705     0.150
     0.739    13.455     0.150
     0.739    25.014     0.150
     0.852    14.455     0.150
     0.842    16.004     0.150
     0.944    17.914     0.150
     1.155    22.434     0.150
     1.285    24.064     0.150
     1.423    25.305     0.150
     1.473    26.035     0.150
     1.779    31.004     0.150
     1.638    28.305     0.150
     1.930    31.375     0.150
     2.119    36.465     0.150
     2.144    36.604     0.150
     2.018    34.314     0.150
     2.301    37.984     0.150
     2.527    41.184     0.150
     2.894    47.205     0.150
     2.796    44.725     0.150
     3.103    49.314     0.150
     3.130    49.314     0.150
     4.092    63.504     0.150
     4.229    68.922     0.150
     4.487    73.334     0.150
     4.817    70.404     0.150
     4.906   139.234     0.150
     6.191    89.814     0.150
     6.557    98.035     0.150
     6.903    98.615     0.150
     7.167   103.934     0.150
     7.167   181.934     0.150
     7.491   107.734     0.150
     7.491   189.234     0.150
     7.491   107.734     0.150
     7.491   112.234     0.150
     7.491   128.734     0.150
     7.491   189.234     0.150
     8.065   204.535     0.150
     8.454   128.635     0.150
     8.713   130.734     0.150
     8.713   215.934     0.150
     8.713   130.734     0.150
     9.202   240.334     0.150
     9.202   132.535     0.150
     9.202   142.635     0.150
     9.202   226.035     0.150
     9.202   240.334     0.150
     9.200   225.035     0.150
     9.231   132.035     0.150
     9.231   132.035     0.150
     9.231   228.635     0.150
     9.348   134.434     0.150
     9.525   143.234     0.150
     9.701   141.734     0.150
     9.701   239.734     0.150
     9.701   266.734     0.150
     9.701   324.734     0.150
     9.749   140.635     0.150
    11.184   171.035     0.150
    20.481   282.234     0.150
    21.562   292.234     0.150
    43.400   487.734     0.150
     0.253     6.523     0.150
     0.253    11.047     0.150
     0.400     8.250     0.150
     0.400    15.047     0.150
     0.564    11.375     0.150
     0.564    19.773     0.150
     0.743    14.656     0.150
     0.743    24.625     0.150
     0.822    16.812     0.150
     0.822    28.531     0.150
     0.903    16.883     0.150
     0.903    28.594     0.150
     0.936    17.977     0.150
     0.936    17.961     0.150
     1.061    19.570     0.150
     1.061    36.070     0.150
     1.061    19.562     0.150
     1.061    36.102     0.150
     1.177    21.586     0.150
     1.177    38.453     0.150
     1.185    20.234     0.150
     1.185    35.695     0.150
     1.240    22.797     0.150
     1.273    21.906     0.150
     1.437    25.852     0.150
     1.469    27.164     0.150
     1.463    24.734     0.150
     1.649    27.031     0.150
     1.828    31.125     0.150
     1.816    29.031     0.150
     1.893    31.164     0.150
     2.149    35.523     0.150
     2.234    37.422     0.150
     2.293    37.016     0.150
     2.509    40.180     0.150
     3.479    54.547     0.150
     4.724    68.672     0.150
     5.227    77.977     0.150
     5.863   148.570     0.150
     7.212   120.773     0.150
     0.030     1.566     0.150
     0.030     3.246     0.150
     0.233     5.207     0.150
     0.444     8.609     0.150
     0.444    16.227     0.150
     0.444     9.129     0.150
     0.444    16.738     0.150
     0.452    17.617     0.150
     0.488     9.219     0.150
     0.488    16.340     0.150
     0.464     9.117     0.150
     0.464    16.246     0.150
     0.489    18.520     0.150
     0.489     9.629     0.150
     0.489    18.527     0.150
     0.518     9.199     0.150
     0.518    17.719     0.150
     0.560    10.957     0.150
     0.560    20.840     0.150
     0.813    14.598     0.150
     0.810    14.289     0.150
     0.851    17.520     0.150
     0.851    17.539     0.150
     0.793    15.207     0.150
     0.793    27.617     0.150
     0.935    18.828     0.150
     1.029    18.387     0.150
     1.407    25.430     0.150
     1.623    28.887     0.150
     1.810    30.887     0.150
     1.917    31.777     0.150
     4.216    70.387     0.150
     4.407    65.316     0.150
     4.898    88.918     0.150
     4.898    77.418     0.150
     4.898    88.918     0.150
     4.898   131.020     0.150
     4.954    77.090     0.150
     7.505   111.418     0.150
     7.505   111.418     0.150
     7.505   140.418     0.150
     7.505   189.918     0.150
     8.310   126.918     0.150
     8.875   130.430     0.150
     9.246   287.418     0.150
    19.514   270.418     0.150
    19.514   265.883     0.150
    20.915   281.438     0.150
    89.417   778.688     0.150
     0.153     5.885     0.150
     0.318     6.805     0.150
     0.579    11.355     0.150
     0.762    14.506     0.150
     0.762    24.176     0.150
     0.791    24.975     0.150
     0.791    14.904     0.150
     0.791    24.945     0.150
     0.791    14.875     0.150
     1.028    19.875     0.150
     1.028    19.926     0.150
     1.152    20.115     0.150
     1.210    21.984     0.150
     1.224    22.574     0.150
     1.224    37.744     0.150
     1.257    22.676     0.150
     1.257    22.725     0.150
     1.381    23.465     0.150
     1.371    25.375     0.150
     1.371    25.414     0.150
     1.486    27.475     0.150
     1.486    27.465     0.150
     1.594    27.744     0.150
     1.655    29.176     0.150
     1.655    49.574     0.150
     1.655    49.875     0.150
     2.811    44.475     0.150
     2.811    77.275     0.150
     4.074    62.275     0.150
     4.074    62.275     0.150
     4.074   105.676     0.150
     4.239    65.154     0.150
     4.789    71.895     0.150
     4.789   124.375     0.150
     4.948    73.805     0.150
     5.195    79.574     0.150
     5.266    79.006     0.150
     5.644    84.535     0.150
     6.060    89.145     0.150
     6.180    91.176     0.150
     6.625    96.936     0.150
     7.582   188.275     0.150
     7.602   189.176     0.150
     9.279   303.875     0.150
     0.074     2.631     0.150
     0.074     4.670     0.150
     0.418     9.031     0.150
     0.418    16.211     0.150
     0.463    16.650     0.150
     0.463     9.090     0.150
     0.463    16.600     0.150
     0.533     9.891     0.150
     0.533     9.850     0.150
     0.533    19.350     0.150
     0.533    10.490     0.150
     0.533    19.330     0.150
     0.543     9.480     0.150
     0.543    18.961     0.150
     0.600    12.100     0.150
     0.767    12.750     0.150
     0.767    12.721     0.150
     0.767    12.750     0.150
     0.782    15.189     0.150
     0.782    15.150     0.150
     0.789    14.270     0.150
     0.808    29.150     0.150
     0.816    28.750     0.150
     0.816    15.930     0.150
     0.816    28.760     0.150
     1.073    18.531     0.150
     1.073    35.740     0.150
     1.133    20.451     0.150
     1.133    20.439     0.150
     1.133    20.451     0.150
     1.207    21.711     0.150
     1.207    21.750     0.150
     1.259    22.051     0.150
     1.666    29.131     0.150
     1.666    29.150     0.150
     1.613    29.211     0.150
     1.709    29.881     0.150
     1.755    31.410     0.150
     1.851    31.111     0.150
     1.851    31.150     0.150
     2.046    34.961     0.150
     2.046    34.951     0.150
     2.091    36.439     0.150
     2.398    41.051     0.150
     2.398    67.051     0.150
     2.398    70.650     0.150
     2.499    41.730     0.150
     2.922    47.451     0.150
     4.438    64.551     0.150
     4.438   108.150     0.150
     4.730    69.451     0.150
     4.730   125.051     0.150
     6.332   153.750     0.150
     6.379   154.650     0.150
     6.993   171.150     0.150
     7.014   172.750     0.150
     7.188   100.750     0.150
     7.288   103.150     0.150
     7.288   176.850     0.150
     8.067   113.750     0.150
     0.407     8.227     0.150
     0.407    16.023     0.150
     0.469     9.828     0.150
     0.747    12.727     0.150
     0.747    14.227     0.150
     0.834    17.023     0.150
     1.098    20.125     0.150
     1.113    20.328     0.150
     1.318    24.125     0.150
     1.306    25.227     0.150
     1.664    32.328     0.150
     1.755    33.430     0.150
     1.946    33.125     0.150
     2.508    41.523     0.150
     2.677    43.727     0.150
     2.759    45.625     0.150
     3.045    48.625     0.150
     3.045    84.523     0.150
     3.584    55.930     0.150
     4.636    71.094     0.150
     4.699    73.383     0.150
     5.054   121.727     0.150
     5.060    79.430     0.150
     5.060    91.523     0.150
     5.283    81.727     0.150
     5.311   100.727     0.150
     6.331    96.680     0.150
     6.331   166.609     0.150
     7.018   106.523     0.150
     7.087   105.648     0.150
     7.876   113.992     0.150
     7.876   200.359     0.150
     8.175   122.523     0.150
     8.168   118.430     0.150
     8.168   206.930     0.150
     8.168   118.430     0.150
     8.168   206.930     0.150
     9.046   130.406     0.150
     9.046   130.430     0.150
    10.373   149.227     0.150
    10.394   151.250     0.150
    10.394   151.227     0.150
    11.079   163.023     0.150
    20.179   275.625     0.150
    20.967   285.625     0.150
    21.665   290.078     0.150
    32.280   388.906     0.150
    47.835   517.555     0.150
    73.569   694.578     0.150
     0.285     6.867     0.150
     0.285    11.961     0.150
     0.729    13.766     0.150
     0.764    25.461     0.150
     0.844    28.867     0.150
     0.886    16.961     0.150
     0.917    31.766     0.150
     0.955    32.367     0.150
     1.010    18.266     0.150
     1.010    33.867     0.150
     1.096    19.367     0.150
     1.115    20.266     0.150
     1.234    21.961     0.150
     1.277    22.062     0.150
     1.277    40.562     0.150
     1.352    22.961     0.150
     1.526    29.062     0.150
     1.813    31.961     0.150
     1.932    36.867     0.150
     1.932    36.320     0.150
     1.932    36.867     0.150
     1.932    64.570     0.150
     2.023    33.023     0.150
     2.023    32.961     0.150
     2.023    58.562     0.150
     2.150    34.961     0.150
     2.284    70.258     0.150
     2.439    40.266     0.150
     2.439    67.086     0.150
     2.509    75.570     0.150
     2.531    45.805     0.150
     2.685    79.453     0.150
     2.775    83.203     0.150
     2.804    82.953     0.150
     2.872    44.766     0.150
     2.922    87.875     0.150
     3.093    47.867     0.150
     3.138    47.945     0.150
     3.138    84.406     0.150
     3.138    47.867     0.150
     3.138    84.367     0.150
     3.349    95.062     0.150
     3.419    51.664     0.150
     3.400    56.203     0.150
     4.031    60.961     0.150
     4.031   105.836     0.150
     5.092    74.977     0.150
     5.167    75.812     0.150
     5.167   131.695     0.150
     5.167    75.766     0.150
     5.167   131.664     0.150
     5.427    78.867     0.150
     5.765    83.719     0.150
     6.446    93.586     0.150
     7.651   110.164     0.150
     7.651   192.062     0.150
     8.938   127.461     0.150
     8.938   221.164     0.150
     9.318   133.062     0.150
     9.318   230.367     0.150
     0.972    31.258     0.150
     1.154    20.258     0.150
     1.153    37.859     0.150
     1.196    19.758     0.150
     1.624    26.461     0.150
     1.641    28.859     0.150
     2.982    80.562     0.150
     2.982    75.758     0.150
     3.318    84.562     0.150
     3.318    51.258     0.150
     3.378    94.117     0.150
     3.391    53.664     0.150
     4.056   103.289     0.150
     4.056   103.258     0.150
     4.429    67.562     0.150
     4.429   115.359     0.150
     4.464    66.867     0.150
     4.464    66.859     0.150
     4.464   113.961     0.150
     4.512    67.359     0.150
     4.506    71.742     0.150
     4.627    68.461     0.150
     4.648    69.062     0.150
     4.648    69.062     0.150
     4.648   122.258     0.150
     4.858    73.562     0.150
     4.858    73.570     0.150
     5.000    74.539     0.150
     5.000   128.055     0.150
     5.000    74.461     0.150
     5.000   127.961     0.150
     5.339   140.602     0.150
     5.330    78.258     0.150
     5.330   134.664     0.150
     5.772    84.531     0.150
     6.003   155.289     0.150
     6.003    88.062     0.150
     6.021   157.406     0.150
     6.021    88.062     0.150
     6.021    88.117     0.150
     6.021   157.398     0.150
     6.021    88.164     0.150
     6.021   157.359     0.150
     6.104   157.773     0.150
     6.104    89.258     0.150
     6.130    89.664     0.150
     6.130   160.062     0.150
     6.274   162.836     0.150
     6.274    91.664     0.150
     6.962    99.461     0.150
     6.962   173.664     0.150
     7.105   105.852     0.150
     7.765   115.633     0.150
     7.992   184.062     0.150
     8.149   123.562     0.150
     8.149   203.164     0.150
     8.228   115.961     0.150
     8.228   203.664     0.150
     8.368   123.562     0.150
     8.368   121.641     0.150
     8.481   132.562     0.150
     8.517   120.562     0.150
     8.517   210.664     0.150
     8.716   122.859     0.150
     8.716   215.062     0.150
     8.899   124.961     0.150
     8.899   219.164     0.150
     9.029   137.984     0.150
     9.029   242.461     0.150
     9.140   127.562     0.150
     9.140   129.359     0.150
     9.140   224.758     0.150
     9.555   137.461     0.150
     9.555   176.461     0.150
     9.555   233.461     0.150
     9.555   260.461     0.150
     9.555   308.461     0.150
     9.555   137.461     0.150
     9.555   233.461     0.150
     9.555   308.461     0.150
     9.555   137.461     0.150
     9.555   233.461     0.150
     9.608   134.961     0.150
     9.608   236.562     0.150
     9.879   137.859     0.150
     9.879   242.758     0.150
     9.885   139.664     0.150
     9.885   243.062     0.150
     9.880   243.961     0.150
     9.997   139.461     0.150
     9.997   245.461     0.150
    10.512   147.164     0.150
    10.512   258.359     0.150
    13.910   199.461     0.150
    19.115   262.758     0.150
    19.978   273.062     0.150
    20.579   276.734     0.150
    20.579   278.562     0.150
     0.127     2.633     0.150
     0.145     4.133     0.150
     0.177     3.328     0.150
     0.744    12.133     0.150
     0.818    16.328     0.150
     1.139    21.133     0.150
     1.174    19.828     0.150
     1.597    27.031     0.150
     1.679    31.828     0.150
     1.875    31.031     0.150
     2.847    44.633     0.150
     3.816    62.461     0.150
     3.816   101.422     0.150
     3.887    64.633     0.150
     3.994    62.133     0.150
     3.994   109.227     0.150
     4.061    61.727     0.150
     4.061   108.930     0.150
     4.739    94.133     0.150
     4.739   126.727     0.150
     4.999    80.492     0.150
     4.999    80.492     0.150
     5.325    81.133     0.150
     5.325   138.508     0.150
     5.325    81.133     0.150
     5.325   138.430     0.150
     5.402    82.008     0.150
     5.402   141.203     0.150
     5.402    81.930     0.150
     5.402   141.133     0.150
     5.661    84.430     0.150
     5.882    89.328     0.150
     6.321    95.133     0.150
     6.609    92.930     0.150
     6.722   178.305     0.150
     6.868   103.727     0.150
     7.920   200.133     0.150
     0.517    18.656     0.150
     0.641    23.258     0.150
     0.829    15.258     0.150
     0.850    14.961     0.150
     1.303    25.062     0.150
     1.656    53.258     0.150
     1.857    53.680     0.150
     2.442    40.258     0.150
     2.442    70.656     0.150
     2.503    38.359     0.150
     2.630    39.859     0.150
     2.670    41.961     0.150
     2.872    45.062     0.150
     2.872    78.859     0.150
     2.914    46.883     0.150
     3.944    61.961     0.150
     4.057    62.156     0.150
     4.084    63.016     0.150
     4.089    61.250     0.150
     4.270    64.898     0.150
     4.536    68.961     0.150
     4.686    69.219     0.150
     4.942    74.562     0.150
     5.017    75.930     0.150
     5.295    78.289     0.150
     5.439    81.891     0.150
     5.517    82.133     0.150
     5.517    82.062     0.150
     5.655    84.062     0.150
     5.655    83.992     0.150
     5.991    89.859     0.150
     6.019    90.156     0.150
     6.193    91.102     0.150
     6.193   158.320     0.150
     6.245    92.961     0.150
     6.284    89.961     0.150
     6.284   157.859     0.150
     6.269    93.367     0.150
     6.301    93.180     0.150
     6.302    94.070     0.150
     6.655    97.562     0.150
     6.655    97.469     0.150
     6.816    99.969     0.150
     6.797   100.008     0.150
     6.834    99.852     0.150
     6.865   101.188     0.150
     6.962   102.141     0.150
     7.109   103.992     0.150
     7.198   103.562     0.150
     7.198   182.359     0.150
     7.196   113.758     0.150
     7.338   183.758     0.150
     7.621   112.578     0.150
     7.788   113.461     0.150
     7.973   112.562     0.150
     7.973   196.359     0.150
     8.050   113.062     0.150
     8.050   198.656     0.150
     8.065   115.828     0.150
     8.075   115.969     0.150
     8.342   118.258     0.150
     8.342   205.062     0.150
     8.486   120.516     0.150
     8.579   121.156     0.150
     8.579   210.961     0.150
     8.595   120.062     0.150
     8.718   123.258     0.150
     8.718   214.258     0.150
     8.718   123.258     0.150
     8.718   214.258     0.150
     8.718   270.156     0.150
     9.205   155.062     0.150
     9.205   276.758     0.150
     9.311   130.461     0.150
     9.311   228.859     0.150
     9.508   133.859     0.150
     9.508   233.258     0.150
     9.489   134.617     0.150
     9.611   134.859     0.150
     9.611   235.859     0.150
     9.693   135.359     0.150
     9.693   135.359     0.150
     9.693   237.859     0.150
     9.713   136.562     0.150
     9.713   237.961     0.150
     9.658   140.680     0.150
     9.885   138.156     0.150
     9.885   242.156     0.150
    10.153   248.438     0.150
    30.651   374.883     0.150
    73.663   697.680     0.150
     0.143     5.891     0.150
     0.199     6.590     0.150
     0.199    10.988     0.150
     0.217     6.188     0.150
     0.726    14.391     0.150
     0.823    15.590     0.150
     0.955    18.391     0.150
     0.884    15.988     0.150
     0.884    28.988     0.150
     0.960    17.789     0.150
     0.946    17.090     0.150
     0.996    18.988     0.150
     0.956    17.188     0.150
     1.086    19.891     0.150
     1.086    19.891     0.150
     1.062    18.988     0.150
     1.129    20.391     0.150
     1.180    20.988     0.150
     1.176    21.289     0.150
     1.176    21.289     0.150
     1.110    19.289     0.150
     1.158    19.988     0.150
     1.183    20.789     0.150
     1.243    21.891     0.150
     1.205    20.488     0.150
     1.263    22.289     0.150
     1.157    20.090     0.150
     1.362    24.789     0.150
     1.362    24.789     0.150
     1.415    24.188     0.150
     1.381    23.590     0.150
     1.384    23.789     0.150
     1.495    25.590     0.150
     1.449    23.988     0.150
     1.538    26.391     0.150
     1.623    26.891     0.150
     1.621    26.891     0.150
     1.688    28.988     0.150
     1.783    29.289     0.150
     1.791    30.488     0.150
     1.791    30.488     0.150
     1.839    31.141     0.150
     1.839    31.090     0.150
     1.839    31.090     0.150
     1.878    31.688     0.150
     1.886    30.688     0.150
     1.931    31.590     0.150
     2.081    33.688     0.150
     2.081    60.590     0.150
     2.269    36.789     0.150
     2.269    65.688     0.150
     2.342    37.391     0.150
     2.342    66.789     0.150
     2.543    40.590     0.150
     2.543    72.391     0.150
     2.575    40.289     0.150
     2.575    72.391     0.150
     2.628    41.391     0.150
     2.628    74.090     0.150
     2.645    41.891     0.150
     2.645    74.891     0.150
     2.754    41.988     0.150
     2.754    73.688     0.150
     2.808    44.168     0.150
     3.017    83.688     0.150
     3.017    47.590     0.150
     3.017    83.688     0.150
     3.059    82.188     0.150
     3.059    48.289     0.150
     3.059    82.188     0.150
     3.099    47.891     0.150
     3.170    49.188     0.150
     3.170    87.289     0.150
     3.190    49.590     0.150
     3.190    87.688     0.150
     3.306    52.391     0.150
     3.629    54.488     0.150
     3.738    56.391     0.150
     3.786    57.391     0.150
     3.769    56.789     0.150
     3.838    58.391     0.150
     3.971    60.688     0.150
     4.121    61.590     0.150
     4.177    62.688     0.150
     4.212    61.789     0.150
     4.246    62.391     0.150
     4.246    63.488     0.150
     4.360    63.488     0.150
     4.360   112.488     0.150
     4.362    63.789     0.150
     4.362   112.188     0.150
     4.345    65.090     0.150
     4.567    67.289     0.150
     4.569    65.688     0.150
     4.536    70.410     0.150
     4.536    70.391     0.150
     4.702    69.090     0.150
     4.702   122.289     0.150
     4.628    70.590     0.150
     4.816    70.289     0.150
     4.781    73.480     0.150
     4.781    73.488     0.150
     4.781    73.488     0.150
     4.785    71.391     0.150
     4.928    72.188     0.150
     4.982    72.488     0.150
     4.982   128.789     0.150
     5.015    73.090     0.150
     5.089   126.289     0.150
     5.089    70.988     0.150
     5.089   126.289     0.150
     5.089    70.988     0.150
     5.089    75.289     0.150
     5.089   126.289     0.150
     5.111    74.488     0.150
     5.225    76.430     0.150
     5.225    76.391     0.150
     5.266    78.090     0.150
     5.361    77.789     0.150
     5.361   137.789     0.150
     5.473    79.090     0.150
     5.381    78.488     0.150
     5.547    82.391     0.150
     5.624    83.988     0.150
     5.624    83.988     0.150
     5.750    85.359     0.150
     5.750    85.391     0.150
     5.922    83.590     0.150
     5.800    85.430     0.150
     5.800    85.391     0.150
     5.821    86.289     0.150
     6.036    86.891     0.150
     6.036   154.891     0.150
     6.036    86.988     0.150
     6.055    87.488     0.150
     6.055   154.488     0.150
     5.973    86.891     0.150
     5.983    88.188     0.150
     5.988    88.789     0.150
     6.136    88.090     0.150
     6.136   157.188     0.150
     6.219    89.289     0.150
     6.156    90.891     0.150
     6.156    90.891     0.150
     6.279    89.988     0.150
     6.279   160.789     0.150
     6.167    88.188     0.150
     6.167    88.188     0.150
     6.396    91.289     0.150
     6.396   163.488     0.150
     6.287    90.688     0.150
     6.371    99.789     0.150
     6.371    99.789     0.150
     6.450    89.590     0.150
     6.450    89.590     0.150
     6.470    93.590     0.150
     6.470   165.289     0.150
     6.514    93.789     0.150
     6.390    93.199     0.150
     6.390    93.188     0.150
     6.397    93.789     0.150
     6.553    93.590     0.150
     6.553   165.289     0.150
     6.691   103.488     0.150
     6.691    92.789     0.150
     6.721   104.988     0.150
     6.721   104.988     0.150
     6.677    96.730     0.150
     6.677    96.688     0.150
     6.848    98.688     0.150
     6.848   173.488     0.150
     6.729    97.488     0.150
     6.789    97.391     0.150
     6.940    96.090     0.150
     6.940   100.988     0.150
     6.940   171.391     0.150
     6.940    96.090     0.150
     7.001    96.891     0.150
     7.001    96.891     0.150
     6.935   106.289     0.150
     6.935   167.789     0.150
     6.935   106.289     0.150
     6.935   167.789     0.150
     6.942   107.891     0.150
     6.942   100.688     0.150
     6.942   107.891     0.150
     6.942   115.988     0.150
     6.942   172.188     0.150
     6.942   100.688     0.150
     7.107   102.289     0.150
     7.107   102.289     0.150
     7.107   101.203     0.150
     7.107   177.309     0.150
     7.107   101.188     0.150
     7.165    99.090     0.150
     7.165    99.090     0.150
     7.217   104.328     0.150
     7.217   104.289     0.150
     7.404   105.590     0.150
     7.404   105.590     0.150
     7.478   108.891     0.150
     7.356   106.309     0.150
     7.356   106.289     0.150
     7.499   108.891     0.150
     7.571   109.641     0.150
     7.571   109.590     0.150
     7.587   111.188     0.150
     7.784   107.590     0.150
     7.784   107.590     0.150
     7.827   108.789     0.150
     7.827   108.789     0.150
     7.959   114.770     0.150
     7.959   114.789     0.150
     8.062   120.988     0.150
     8.186   119.391     0.150
     8.186   119.391     0.150
     8.412   116.688     0.150
     8.412   116.688     0.150
     8.681   120.391     0.150
     8.869   122.789     0.150
     8.869   122.789     0.150
     8.810   128.891     0.150
     9.019   124.391     0.150
     9.019   124.391     0.150
     9.064   125.789     0.150
     9.074   157.688     0.150
     9.074   239.289     0.150
     9.074   288.488     0.150
     9.074   131.090     0.150
     9.074   157.688     0.150
     9.074   239.289     0.150
     9.074   288.488     0.150
     9.218   137.289     0.150
     9.612   143.789     0.150
     9.612   268.789     0.150
     9.612   143.789     0.150
     9.612   151.789     0.150
     9.612   268.789     0.150
     9.612   310.789     0.150
     9.612   310.789     0.150
     9.800   135.891     0.150
     9.700   233.258     0.150
     9.700   135.789     0.150
    10.066   138.988     0.150
    10.166   140.488     0.150
    10.186   140.289     0.150
    12.783   178.133     0.150
    12.783   178.090     0.150
    17.965   246.688     0.150
    19.377   267.988     0.150
    19.377   267.988     0.150
    19.377   264.289     0.150
    20.543   275.340     0.150
    20.543   275.391     0.150
    28.168   348.188     0.150
    28.168   348.215     0.150
    28.168   348.188     0.150
    30.947   675.891     0.150
    30.947   373.688     0.150
    44.900   492.289     0.150
    46.008   500.488     0.150
    46.008   500.465     0.150
    46.008   500.488     0.150
    46.532   504.637     0.150
    59.675   599.891     0.150
    60.902   610.730     0.150
    60.902   610.688     0.150
    68.623   660.336     0.150
    68.623   660.289     0.150
    70.546   672.488     0.150
    70.695   673.391     0.150
    70.695   673.363     0.150
    70.695   673.391     0.150
    72.909   686.688     0.150
    72.909   686.688     0.150
    79.799   725.891     0.150
    79.799   733.789     0.150
    82.419   740.188     0.150
    89.796   777.688     0.150
    89.796   777.715     0.150
    89.796   777.688     0.150
    89.789   776.688     0.150
     0.261     7.277     0.150
     0.261    12.176     0.150
     0.261     7.277     0.150
     0.261    12.215     0.150
     0.296     7.875     0.150
     0.296    13.375     0.150
     0.296     7.848     0.150
     0.296    13.355     0.150
     0.422     9.277     0.150
     0.422    16.375     0.150
     0.554    21.477     0.150
     0.554    11.977     0.150
     0.554    12.008     0.150
     0.554    20.328     0.150
     0.562    11.578     0.150
     0.562    19.676     0.150
     0.556    11.375     0.150
     0.556    20.277     0.150
     0.672    13.277     0.150
     0.662    12.777     0.150
     0.662    23.277     0.150
     0.623    12.375     0.150
     0.623    21.676     0.150
     0.623    12.285     0.150
     0.623    21.418     0.150
     0.695    14.078     0.150
     0.695    14.078     0.150
     0.626    12.375     0.150
     0.626    21.277     0.150
     0.770    15.176     0.150
     0.761    14.578     0.150
     0.761    25.977     0.150
     0.764    14.578     0.150
     0.764    25.875     0.150
     0.832    15.676     0.150
     0.832    15.676     0.150
     0.840    16.578     0.150
     0.840    16.578     0.150
     0.803    14.676     0.150
     0.803    26.375     0.150
     1.032    34.078     0.150
     1.032    18.875     0.150
     0.958    31.777     0.150
     0.958    17.375     0.150
     0.958    31.777     0.150
     1.045    19.277     0.150
     1.048    18.277     0.150
     1.116    20.375     0.150
     1.099    19.477     0.150
     1.216    20.875     0.150
     1.248    21.078     0.150
     1.309    22.477     0.150
     1.341    22.277     0.150
     1.524    25.328     0.150
     1.524    44.547     0.150
     1.856    53.078     0.150
     1.856    31.277     0.150
     1.856    53.078     0.150
     1.856    31.266     0.150
     1.856    53.086     0.150
     2.059    33.977     0.150
     2.059    62.078     0.150
     2.339    37.578     0.150
     2.339    65.277     0.150
     2.488    39.875     0.150
     2.488    39.875     0.150
     2.576    40.578     0.150
     2.576    70.875     0.150
     2.569    40.578     0.150
     2.569    71.277     0.150
     2.748    43.078     0.150
     2.748    75.176     0.150
     2.779    43.277     0.150
     2.779    76.078     0.150
     2.826    44.176     0.150
     2.826    77.176     0.150
     2.863    45.375     0.150
     2.863    46.078     0.150
     2.863    46.078     0.150
     2.863    43.578     0.150
     2.863    46.078     0.150
     2.863    46.078     0.150
     2.863    46.078     0.150
     2.965    45.875     0.150
     2.965    80.176     0.150
     3.197    49.578     0.150
     3.197    49.617     0.150
     3.197    84.527     0.150
     3.331    51.578     0.150
     3.331    88.977     0.150
     3.433    53.176     0.150
     3.651    56.676     0.150
     3.654    55.477     0.150
     3.654    55.477     0.150
     3.934    60.277     0.150
     3.923    60.176     0.150
     3.923   103.477     0.150
     3.995    60.477     0.150
     4.101    61.977     0.150
     4.101    61.977     0.150
     4.101    61.977     0.150
     4.127    62.477     0.150
     4.199    61.477     0.150
     4.199   108.477     0.150
     4.175    63.375     0.150
     4.344    67.836     0.150
     4.344   112.867     0.150
     4.407    63.777     0.150
     4.407    63.727     0.150
     4.394    66.477     0.150
     4.394    66.477     0.150
     4.394    66.477     0.150
     4.394    66.477     0.150
     4.408    66.578     0.150
     4.408    66.676     0.150
     4.408    66.676     0.150
     4.408    66.676     0.150
     4.419    66.477     0.150
     4.442    65.277     0.150
     4.444    66.477     0.150
     4.669    69.535     0.150
     4.674    67.777     0.150
     4.803    70.578     0.150
     4.815    72.477     0.150
     4.815    72.477     0.150
     4.815    72.477     0.150
     4.815    72.477     0.150
     5.038    71.977     0.150
     5.038    71.977     0.150
     5.038   126.477     0.150
     5.056    73.875     0.150
     5.056   130.777     0.150
     5.072    74.777     0.150
     5.072    74.777     0.150
     5.072    74.777     0.150
     5.165    75.785     0.150
     5.165   134.727     0.150
     5.183    75.578     0.150
     5.182    75.578     0.150
     5.182    75.875     0.150
     5.182    75.875     0.150
     5.166    76.777     0.150
     5.213    76.477     0.150
     5.233    78.078     0.150
     5.231    78.277     0.150
     5.311    77.477     0.150
     5.311   138.176     0.150
     5.402    79.977     0.150
     5.402    79.977     0.150
     5.402    79.977     0.150
     5.402    79.977     0.150
     5.492    80.578     0.150
     5.492    80.578     0.150
     5.492    80.578     0.150
     5.492    80.578     0.150
     5.572    83.676     0.150
     5.691   150.305     0.150
     5.691    82.477     0.150
     5.673    83.977     0.150
     5.673    83.977     0.150
     5.739    83.164     0.150
     5.739    83.078     0.150
     5.704    84.676     0.150
     5.704    84.676     0.150
     5.704    84.676     0.150
     5.800    84.277     0.150
     5.800   150.977     0.150
     5.753    85.875     0.150
     5.753    85.875     0.150
     5.753    85.875     0.150
     5.879    86.176     0.150
     5.879    86.176     0.150
     5.879    86.176     0.150
     5.882    87.078     0.150
     5.882    87.078     0.150
     5.900    87.578     0.150
     6.001    87.176     0.150
     5.985    87.277     0.150
     5.966    87.375     0.150
     5.966    87.375     0.150
     6.035    88.375     0.150
     6.035    88.375     0.150
     6.035    88.375     0.150
     6.051    89.277     0.150
     6.051    89.277     0.150
     6.107    90.176     0.150
     6.107    90.176     0.150
     6.207    90.078     0.150
     6.205    89.777     0.150
     6.162    89.875     0.150
     6.162    89.875     0.150
     6.208    90.578     0.150
     6.208    90.578     0.150
     6.208    90.578     0.150
     6.293    92.777     0.150
     6.326    91.477     0.150
     6.326    91.477     0.150
     6.326    91.477     0.150
     6.335    92.777     0.150
     6.335    92.777     0.150
     6.340    92.375     0.150
     6.340    92.375     0.150
     6.419    93.277     0.150
     6.419   163.977     0.150
     6.410    92.977     0.150
     6.410   162.078     0.150
     6.419    92.676     0.150
     6.472    92.676     0.150
     6.502    94.676     0.150
     6.502   166.977     0.150
     6.450    95.777     0.150
     6.523    95.078     0.150
     6.530    94.578     0.150
     6.530   166.578     0.150
     6.542    94.477     0.150
     6.542   167.176     0.150
     6.527    94.875     0.150
     6.527    94.875     0.150
     6.667    96.777     0.150
     6.621    95.477     0.150
     6.621    95.477     0.150
     6.621    95.477     0.150
     6.710    96.648     0.150
     6.710   172.797     0.150
     6.668    97.777     0.150
     6.731    96.977     0.150
     6.731    96.977     0.150
     6.909   100.277     0.150
     6.909   177.875     0.150
     6.982    98.875     0.150
     7.085   103.277     0.150
     7.085   179.578     0.150
     7.092   101.477     0.150
     7.092   182.277     0.150
     7.092   101.465     0.150
     7.092   182.316     0.150
     7.119   175.477     0.150
     7.119   102.477     0.150
     7.119   102.477     0.150
     7.119   175.477     0.150
     7.226   102.277     0.150
     7.344   105.777     0.150
     7.344   105.777     0.150
     7.344   184.176     0.150
     7.457   106.078     0.150
     7.577   106.777     0.150
     7.597   106.578     0.150
     7.754   110.375     0.150
     7.754   194.578     0.150
     7.754   197.477     0.150
     7.754   110.508     0.150
     7.754   197.426     0.150
     7.792   109.777     0.150
     7.885   111.176     0.150
     7.808   112.875     0.150
     7.873   111.277     0.150
     8.105   118.176     0.150
     8.105   118.176     0.150
     8.375   215.277     0.150
     8.375   119.875     0.150
     8.375   215.277     0.150
     8.375   119.867     0.150
     8.375   215.285     0.150
     8.424   119.277     0.150
     8.511   120.375     0.150
     8.511   120.375     0.150
     8.546   120.578     0.150
     8.554   121.977     0.150
     8.554   215.977     0.150
     8.554   121.926     0.150
     8.554   216.008     0.150
     8.493   124.477     0.150
     8.493   124.477     0.150
     8.540   123.578     0.150
     8.594   120.777     0.150
     8.604   122.578     0.150
     8.604   122.578     0.150
     8.667   121.777     0.150
     8.779   127.676     0.150
     8.779   127.676     0.150
     8.870   123.277     0.150
     8.836   128.875     0.150
     8.854   124.777     0.150
     8.854   124.777     0.150
     8.854   124.777     0.150
     8.872   126.477     0.150
     9.020   126.676     0.150
     8.998   127.676     0.150
     8.998   127.676     0.150
     9.083   127.875     0.150
     9.250   129.477     0.150
     9.436   133.777     0.150
     9.547   134.078     0.150
     9.565   232.645     0.150
     9.904   138.676     0.150
     9.828   140.676     0.150
     9.828   140.715     0.150
     9.925   137.277     0.150
     9.963   140.477     0.150
     9.963   140.477     0.150
     9.963   198.477     0.150
     9.963   252.477     0.150
     9.963   279.477     0.150
     9.963   320.477     0.150
    10.054   140.277     0.150
    10.078   140.875     0.150
    10.191   142.078     0.150
    10.232   142.977     0.150
    10.269   143.375     0.150
    10.301   143.578     0.150
    10.485   146.176     0.150
    10.786   150.477     0.150
    10.920   151.977     0.150
    11.415   158.977     0.150
    11.672   162.477     0.150
    13.808   355.477     0.150
    15.002   207.477     0.150
    18.368   253.277     0.150
    19.372   483.477     0.150
    19.372   263.477     0.150
    19.372   483.477     0.150
    19.740   267.176     0.150
    20.500   278.426     0.150
    20.946   280.047     0.150
    26.140   330.777     0.150
    31.304   689.078     0.150
    31.304   793.578     0.150
    31.304   378.875     0.150
    37.945   435.578     0.150
    43.414   479.875     0.150
    43.414   479.836     0.150
    80.026   727.477     0.150
    80.026   727.477     0.150
    80.026   727.477     0.150
     0.265     7.070     0.150
     0.265    11.977     0.150
     0.299     7.672     0.150
     0.299    13.172     0.150
     0.417     9.070     0.150
     0.417    16.570     0.150
     0.534    11.875     0.150
     0.534    19.570     0.150
     0.557    11.773     0.150
     0.557    19.977     0.150
     0.558    11.477     0.150
     0.558    20.570     0.150
     0.550    11.375     0.150
     0.550    19.570     0.150
     0.616    12.070     0.150
     0.616    21.477     0.150
     0.672    13.172     0.150
     0.672    23.273     0.150
     0.658    12.570     0.150
     0.658    22.672     0.150
     0.620    12.273     0.150
     0.620    20.875     0.150
     0.697    13.773     0.150
     0.697    13.773     0.150
     0.697    23.672     0.150
     0.649    12.477     0.150
     0.772    15.070     0.150
     0.772    26.477     0.150
     0.755    14.273     0.150
     0.755    25.672     0.150
     0.758    14.672     0.150
     0.758    25.875     0.150
     0.799    14.672     0.150
     0.799    26.273     0.150
     0.833    15.672     0.150
     0.833    15.672     0.150
     0.833    27.172     0.150
     0.844    16.172     0.150
     0.844    29.570     0.150
     0.925    17.570     0.150
     0.925    17.570     0.150
     0.925    31.570     0.150
     0.941    17.672     0.150
     0.941    31.773     0.150
     0.973    16.977     0.150
     0.953    17.375     0.150
     0.953    31.172     0.150
     1.035    34.070     0.150
     1.035    18.672     0.150
     1.035    34.070     0.150
     1.043    18.070     0.150
     1.119    20.172     0.150
     1.093    19.273     0.150
     1.194    21.570     0.150
     1.207    22.273     0.150
     1.207    22.273     0.150
     1.187    19.977     0.150
     1.184    20.477     0.150
     1.242    20.875     0.150
     1.278    21.977     0.150
     1.278    39.172     0.150
     1.295    21.977     0.150
     1.361    22.977     0.150
     1.373    24.172     0.150
     1.380    23.875     0.150
     1.367    22.875     0.150
     1.447    24.875     0.150
     1.438    24.172     0.150
     1.541    25.977     0.150
     1.518    25.273     0.150
     1.530    24.070     0.150
     1.572    26.773     0.150
     1.872    30.977     0.150
     2.019    33.875     0.150
     2.034    33.672     0.150
     2.062    34.477     0.150
     3.653    56.570     0.150
     3.653    98.672     0.150
     3.936    60.773     0.150
     3.936    60.773     0.150
     4.130    62.375     0.150
     4.419    66.672     0.150
     4.444    65.172     0.150
     4.446    67.070     0.150
     4.787    72.375     0.150
     5.041    72.477     0.150
     5.041    72.477     0.150
     5.041   126.273     0.150
     5.062    74.273     0.150
     5.698    82.273     0.150
     5.745    82.375     0.150
     6.425   164.977     0.150
     6.416    92.875     0.150
     6.416   163.672     0.150
     6.425    92.977     0.150
     6.476    91.672     0.150
     6.476   160.773     0.150
     6.508    94.773     0.150
     6.986    98.570     0.150
     6.986   172.672     0.150
     7.091   103.172     0.150
     7.231   102.273     0.150
     7.231   178.875     0.150
     7.582   105.977     0.150
     7.582   105.977     0.150
     7.582   187.477     0.150
     7.602   107.273     0.150
     7.602   187.977     0.150
     7.760   110.375     0.150
     7.796   109.773     0.150
     7.796   192.070     0.150
     7.890   112.070     0.150
     7.890   194.570     0.150
     8.552   120.477     0.150
     8.552   210.477     0.150
     8.876   124.570     0.150
     8.876   218.273     0.150
     9.089   127.570     0.150
     9.089   223.477     0.150
     9.256   129.977     0.150
     9.256   227.375     0.150
     9.909   138.570     0.150
     9.909   242.773     0.150
     9.931   139.172     0.150
    10.196   142.070     0.150
    10.196   249.773     0.150
    10.275   143.570     0.150
    10.275   251.477     0.150
    11.421   159.477     0.150
    11.421   279.070     0.150
     0.045     2.836     0.150
     0.045     5.836     0.150
     0.167     4.930     0.150
     0.167     9.031     0.150
     0.232     5.531     0.150
     0.232    10.133     0.150
     0.244     5.430     0.150
     0.244    10.633     0.150
     0.298     6.234     0.150
     0.298    11.633     0.150
     0.328     6.430     0.150
     0.328    11.836     0.150
     0.394     7.336     0.150
     0.394    13.531     0.150
     0.449     8.234     0.150
     0.449    15.133     0.150
     0.457     8.430     0.150
     0.452     8.633     0.150
     0.525     9.633     0.150
     0.531     9.734     0.150
     0.678    12.031     0.150
     0.668    12.133     0.150
     0.663    12.031     0.150
     0.663    22.633     0.150
     0.708    12.836     0.150
     0.708    24.031     0.150
     0.788    15.336     0.150
     0.788    15.336     0.150
     0.903    17.430     0.150
     0.921    16.234     0.150
     0.921    30.336     0.150
     1.042    18.430     0.150
     1.109    20.531     0.150
     1.138    19.234     0.150
     1.158    21.336     0.150
     1.158    21.336     0.150
     1.173    21.531     0.150
     1.183    21.336     0.150
     1.183    37.531     0.150
     1.210    22.133     0.150
     1.223    22.336     0.150
     1.256    22.734     0.150
     1.326    23.336     0.150
     1.330    25.234     0.150
     1.330    25.234     0.150
     1.376    24.430     0.150
     1.392    23.930     0.150
     1.398    25.336     0.150
     1.398    44.234     0.150
     1.424    25.133     0.150
     1.423    25.633     0.150
     1.413    25.336     0.150
     1.478    26.734     0.150
     1.528    28.234     0.150
     1.528    26.633     0.150
     1.527    26.336     0.150
     1.563    27.430     0.150
     1.614    27.930     0.150
     1.607    27.430     0.150
     1.625    28.734     0.150
     1.644    28.836     0.150
     1.627    49.336     0.150
     1.678    29.031     0.150
     1.734    29.133     0.150
     1.774    30.633     0.150
     1.832    32.234     0.150
     1.887    32.531     0.150
     1.889    31.234     0.150
     2.124    36.031     0.150
     2.379    39.336     0.150
     2.820    45.031     0.150
     2.820    80.031     0.150
     2.929    47.031     0.150
     2.929    80.234     0.150
     2.998    47.633     0.150
     2.998    84.133     0.150
     3.077    48.930     0.150
     3.077    86.133     0.150
     3.148    49.633     0.150
     3.148    87.836     0.150
     3.236    50.531     0.150
     3.236    90.031     0.150
     3.273    51.531     0.150
     3.273    90.734     0.150
     3.278    51.430     0.150
     3.278    90.734     0.150
     3.296    51.836     0.150
     3.296    91.234     0.150
     3.366    53.031     0.150
     3.366    93.133     0.150
     3.740    57.734     0.150
     3.740   101.531     0.150
     3.964    60.734     0.150
     3.964   105.633     0.150
     4.348    66.633     0.150
     4.440    67.633     0.150
     4.486    67.234     0.150
     4.807    72.336     0.150
     4.838    71.930     0.150
     4.849    70.633     0.150
     4.849    70.633     0.150
     4.887    72.336     0.150
     5.004   134.680     0.150
     5.004    74.133     0.150
     5.004   134.633     0.150
     5.030    75.734     0.150
     5.030   131.930     0.150
     5.343    80.430     0.150
     5.343   139.734     0.150
     5.420    82.734     0.150
     5.509   144.430     0.150
     5.596    81.734     0.150
     5.596   145.930     0.150
     5.839    84.531     0.150
     5.839    84.531     0.150
     5.880    87.133     0.150
     5.972    88.734     0.150
     6.107    92.031     0.150
     6.107   159.133     0.150
     6.125    91.336     0.150
     6.125   160.234     0.150
     6.188    90.836     0.150
     6.188   159.336     0.150
     6.270    92.031     0.150
     6.270   162.930     0.150
     6.294    91.430     0.150
     6.294   162.336     0.150
     6.340    93.430     0.150
     6.385    93.531     0.150
     6.503    96.633     0.150
     6.503   168.336     0.150
     6.641    99.430     0.150
     6.641   170.930     0.150
     8.002   115.031     0.150
     8.370   118.930     0.150
     8.607   122.430     0.150
     8.746   123.836     0.150
     9.426   133.734     0.150
     9.706   137.336     0.150
     0.255     5.838     0.150
     0.255    10.438     0.150
     0.298     7.138     0.150
     0.298    12.338     0.150
     0.420     8.438     0.150
     0.420    14.538     0.150
     0.539    10.538     0.150
     0.539    18.738     0.150
     0.429     9.238     0.150
     0.429    16.738     0.150
     0.630    12.038     0.150
     0.630    20.738     0.150
     0.675    12.638     0.150
     0.697    12.738     0.150
     0.697    23.438     0.150
     0.742    14.038     0.150
     0.742    25.438     0.150
     0.781    14.238     0.150
     0.781    25.938     0.150
     0.819    14.238     0.150
     0.819    27.038     0.150
     0.810    15.038     0.150
     0.810    26.738     0.150
     0.875    15.638     0.150
     0.875    27.838     0.150
     0.909    16.438     0.150
     0.897    15.838     0.150
     0.856    16.038     0.150
     0.856    28.638     0.150
     0.934    16.538     0.150
     0.934    30.138     0.150
     0.975    16.838     0.150
     0.939    17.638     0.150
     0.939    17.638     0.150
     0.960    17.238     0.150
     1.057    18.638     0.150
     1.043    18.738     0.150
     1.043    18.738     0.150
     1.109    19.038     0.150
     1.021    18.438     0.150
     1.030    18.838     0.150
     1.105    19.238     0.150
     1.144    20.138     0.150
     1.123    19.738     0.150
     1.256    22.438     0.150
     1.257    21.438     0.150
     1.169    20.638     0.150
     1.260    21.938     0.150
     1.313    22.738     0.150
     1.344    23.038     0.150
     1.344    40.438     0.150
     1.392    24.438     0.150
     1.337    23.138     0.150
     1.388    23.538     0.150
     1.364    26.138     0.150
     1.364    46.438     0.150
     1.514    25.838     0.150
     1.425    27.038     0.150
     1.425    47.438     0.150
     1.547    27.138     0.150
     1.503    25.538     0.150
     1.694    28.538     0.150
     1.671    27.938     0.150
     1.985    53.838     0.150
     2.384    38.538     0.150
     2.384    69.338     0.150
     2.664    43.338     0.150
     2.664    73.938     0.150
     2.710    42.238     0.150
     2.710    74.338     0.150
     2.649    42.838     0.150
     2.649    76.438     0.150
     2.712    43.338     0.150
     2.712    77.438     0.150
     2.795    44.838     0.150
     2.795    79.938     0.150
     2.837    44.938     0.150
     2.837    80.538     0.150
     2.851    45.538     0.150
     2.851    81.138     0.150
     2.893    45.938     0.150
     2.885    45.538     0.150
     2.885    82.338     0.150
     3.215    51.338     0.150
     3.215    88.938     0.150
     3.296    51.838     0.150
     3.296    91.738     0.150
     3.474    54.938     0.150
     3.474    96.138     0.150
     3.627    55.338     0.150
     3.627    96.338     0.150
     3.737    57.238     0.150
     3.737    96.638     0.150
     3.990    60.638     0.150
     4.126    61.038     0.150
     4.126   108.938     0.150
     4.326    65.738     0.150
     4.433    67.138     0.150
     4.523    69.138     0.150
     4.669    69.366     0.150
     4.645    73.738     0.150
     4.645    73.738     0.150
     4.786    71.438     0.150
     4.786   122.038     0.150
     4.668    71.438     0.150
     4.761    70.338     0.150
     4.761   125.338     0.150
     4.709    71.238     0.150
     4.806    71.209     0.150
     4.913    72.686     0.150
     4.913   128.532     0.150
     4.923    75.038     0.150
     5.077    75.938     0.150
     5.285    77.256     0.150
     5.285   137.232     0.150
     5.373    78.886     0.150
     5.400    79.288     0.150
     5.400   139.739     0.150
     5.444    80.438     0.150
     5.517    82.138     0.150
     5.535    83.238     0.150
     5.545    83.038     0.150
     5.729    86.338     0.150
     6.012   156.855     0.150
     6.024    88.146     0.150
     5.983    89.738     0.150
     6.060    88.354     0.150
     6.060   156.768     0.150
     6.095    89.551     0.150
     6.125    89.321     0.150
     6.125   159.992     0.150
     6.166    90.138     0.150
     6.071    90.438     0.150
     6.260    92.274     0.150
     6.260   163.497     0.150
     6.175    92.138     0.150
     6.241    93.038     0.150
     6.248    92.138     0.150
     6.502    95.020     0.150
     6.502   168.311     0.150
     6.649    97.438     0.150
     6.682    97.993     0.150
     6.682   170.303     0.150
     6.706    98.038     0.150
     6.643    98.138     0.150
     6.895    99.738     0.150
     7.225   102.738     0.150
     7.245   102.638     0.150
     7.363   105.338     0.150
     7.496   108.738     0.150
     7.556   108.938     0.150
     8.049   114.938     0.150
     8.177   115.738     0.150
     8.349   119.438     0.150
     8.479   119.838     0.150
     8.601   121.538     0.150
     8.685   122.438     0.150
     9.534   135.138     0.150
     9.550   134.138     0.150
     9.670   136.238     0.150
     9.826   137.338     0.150
     9.844   139.638     0.150
     9.916   138.838     0.150
     9.941   139.838     0.150
    10.138   142.638     0.150
     0.218     5.488     0.150
     0.218     9.488     0.150
     0.342     7.608     0.150
     0.342    13.318     0.150
     0.362     7.058     0.150
     0.362    12.878     0.150
     0.532    10.108     0.150
     0.532    16.828     0.150
     0.608    12.018     0.150
     0.647    11.978     0.150
     0.747    13.948     0.150
     0.789    14.478     0.150
     0.780    14.648     0.150
     0.800    14.388     0.150
     0.800    26.678     0.150
     0.870    15.698     0.150
     0.870    28.498     0.150
     0.884    16.368     0.150
     0.939    16.888     0.150
     0.926    16.038     0.150
     0.952    17.988     0.150
     0.952    18.008     0.150
     0.980    18.488     0.150
     0.980    32.078     0.150
     0.991    16.188     0.150
     1.016    18.388     0.150
     1.016    18.378     0.150
     1.008    17.738     0.150
     1.013    18.768     0.150
     1.051    18.538     0.150
     1.135    20.288     0.150
     1.135    20.318     0.150
     1.160    20.838     0.150
     1.173    20.688     0.150
     1.173    20.688     0.150
     1.154    20.688     0.150
     1.288    42.688     0.150
     1.283    22.668     0.150
     1.275    22.708     0.150
     1.349    24.488     0.150
     1.373    23.928     0.150
     1.370    44.888     0.150
     1.426    24.598     0.150
     1.425    24.088     0.150
     1.455    24.878     0.150
     1.501    27.478     0.150
     1.494    26.998     0.150
     1.469    25.318     0.150
     1.516    25.888     0.150
     1.601    27.778     0.150
     1.594    27.988     0.150
     1.594    27.988     0.150
     1.605    27.588     0.150
     1.592    27.088     0.150
     1.595    26.938     0.150
     1.646    27.108     0.150
     1.698    29.348     0.150
     1.711    29.988     0.150
     1.739    28.908     0.150
     1.784    30.538     0.150
     1.766    28.958     0.150
     1.834    31.588     0.150
     1.874    31.988     0.150
     1.874    31.988     0.150
     1.829    30.418     0.150
     1.922    31.528     0.150
     1.977    33.808     0.150
     2.017    33.948     0.150
     2.133    35.458     0.150
     2.118    34.408     0.150
     2.265    36.568     0.150
     2.267    37.188     0.150
     2.267    66.188     0.150
     2.410    39.718     0.150
     2.440    39.388     0.150
     2.440    70.688     0.150
     2.486    39.708     0.150
     2.491    40.588     0.150
     2.533    40.588     0.150
     2.533    73.088     0.150
     2.540    40.678     0.150
     2.540    40.728     0.150
     2.595    41.588     0.150
     2.595    74.188     0.150
     2.622    41.598     0.150
     2.608    42.568     0.150
     2.671    42.988     0.150
     2.679    43.288     0.150
     2.679    76.588     0.150
     2.702    42.598     0.150
     2.702    43.988     0.150
     2.721    43.788     0.150
     2.721    77.188     0.150
     2.725    43.468     0.150
     2.735    44.088     0.150
     2.735    77.588     0.150
     2.738    44.388     0.150
     2.738    44.378     0.150
     2.745    43.408     0.150
     2.771    44.088     0.150
     2.771    78.588     0.150
     2.810    44.588     0.150
     2.810    79.288     0.150
     2.837    44.658     0.150
     2.905    47.088     0.150
     2.986    47.678     0.150
     2.992    47.498     0.150
     3.099    49.188     0.150
     3.099    86.688     0.150
     3.145    49.328     0.150
     3.183    50.288     0.150
     3.183    88.288     0.150
     3.254    52.858     0.150
     3.254    82.878     0.150
     3.254    52.888     0.150
     3.358    52.788     0.150
     3.358    93.288     0.150
     3.365    52.998     0.150
     3.603    55.358     0.150
     3.677    59.748     0.150
     3.677    59.788     0.150
     3.677    98.588     0.150
     3.934    60.098     0.150
     3.939    65.188     0.150
     3.937    61.988     0.150
     4.012    59.698     0.150
     4.200    63.288     0.150
     4.257    65.988     0.150
     4.306    63.878     0.150
     4.299    65.598     0.150
     4.642    68.788     0.150
     4.657    69.188     0.150
     4.657   124.188     0.150
     4.665    68.948     0.150
     4.696    69.108     0.150
     4.764    69.808     0.150
     4.785   129.178     0.150
     4.785    71.088     0.150
     4.785   129.188     0.150
     4.804    70.308     0.150
     4.915    72.888     0.150
     4.915   131.688     0.150
     4.893    71.388     0.150
     4.893    71.388     0.150
     4.893   124.788     0.150
     5.303    77.888     0.150
     5.303   138.688     0.150
     5.345    78.588     0.150
     5.404    79.488     0.150
     6.012    87.188     0.150
     6.012   156.988     0.150
     6.027    88.288     0.150
     6.027   157.088     0.150
     6.036    89.388     0.150
     6.036   157.288     0.150
     6.119    90.088     0.150
     6.119   160.588     0.150
     6.161    90.188     0.150
     6.161   160.888     0.150
     6.261    89.688     0.150
     6.289    91.388     0.150
     6.289   164.188     0.150
     6.533    95.688     0.150
     6.533   170.688     0.150
     6.723    99.088     0.150
     6.723   175.988     0.150
     6.749    96.488     0.150
     6.808    97.388     0.150
     7.305   105.188     0.150
     7.325   105.188     0.150
     7.645   109.288     0.150
     8.249   116.988     0.150
     8.536   120.988     0.150
     8.734   124.388     0.150
     8.918   126.388     0.150
     9.629   135.388     0.150
     9.732   137.188     0.150
     9.904   139.488     0.150
     9.900   139.388     0.150
     9.995   140.388     0.150
    10.221   143.688     0.150
    10.640   149.988     0.150
     0.053     2.777     0.150
     0.123     1.827     0.150
     0.123     1.897     0.150
     0.123     4.227     0.150
     0.292     9.627     0.150
     0.240     6.237     0.150
     0.256     6.117     0.150
     0.376    11.627     0.150
     0.306     7.297     0.150
     0.476     9.627     0.150
     0.580    11.037     0.150
     0.706    12.257     0.150
     0.803    14.107     0.150
     0.839    15.337     0.150
     1.065    19.127     0.150
     1.144    24.327     0.150
     1.210    21.237     0.150
     1.259    23.257     0.150
     1.385    24.827     0.150
     1.385    24.737     0.150
     1.351    24.387     0.150
     1.443    26.427     0.150
     1.443    26.037     0.150
     1.476    27.427     0.150
     1.448    49.727     0.150
     1.507    26.927     0.150
     1.520    27.087     0.150
     1.656    30.327     0.150
     1.656    51.927     0.150
     1.656    30.347     0.150
     1.588    30.027     0.150
     1.588    30.027     0.150
     1.638    27.357     0.150
     1.806    35.427     0.150
     1.741    57.527     0.150
     1.892    33.577     0.150
     1.845    61.227     0.150
     1.877    64.327     0.150
     1.975    69.527     0.150
     2.382    42.227     0.150
     2.426    40.027     0.150
     2.607    42.627     0.150
     2.666    44.027     0.150
     2.927    47.827     0.150
     3.081    49.327     0.150
     3.216    51.227     0.150
     3.305    57.227     0.150
     3.443    54.727     0.150
     3.443    54.627     0.150
     3.443    93.927     0.150
     3.567    60.127     0.150
     3.511    56.727     0.150
     3.511    56.727     0.150
     3.559   100.527     0.150
     3.698    59.627     0.150
     3.698    58.227     0.150
     3.698    58.247     0.150
     3.698    58.227     0.150
     3.698    98.927     0.150
     3.698   136.087     0.150
     3.795   139.277     0.150
     3.922    60.627     0.150
     3.969    61.827     0.150
     4.052    62.927     0.150
     4.052   144.447     0.150
     4.149    64.427     0.150
     4.149    64.427     0.150
     4.149   145.317     0.150
     4.419    68.027     0.150
     4.419    68.027     0.150
     4.448    69.127     0.150
     4.611    68.927     0.150
     4.611   121.827     0.150
     4.623    69.307     0.150
     4.705    70.527     0.150
     4.744    73.027     0.150
     4.744    73.027     0.150
     4.808    74.727     0.150
     4.873    72.827     0.150
     4.870    74.627     0.150
     4.870    74.627     0.150
     4.870   129.127     0.150
     4.922    75.437     0.150
     4.983    76.427     0.150
     5.244    80.127     0.150
     5.275    79.927     0.150
     5.275    79.927     0.150
     5.353    86.027     0.150
     5.428    80.927     0.150
     5.640    86.927     0.150
     5.626    84.027     0.150
     5.626    84.027     0.150
     5.718    87.327     0.150
     5.735    85.627     0.150
     5.735    85.667     0.150
     5.735    85.627     0.150
     5.826    87.627     0.150
     5.826   151.527     0.150
     5.909    89.727     0.150
     5.988    89.327     0.150
     5.988    89.327     0.150
     6.083   161.235     0.150
     6.045    91.427     0.150
     6.045   157.127     0.150
     6.153    92.827     0.150
     6.189    93.527     0.150
     6.193    91.427     0.150
     6.233    94.927     0.150
     6.313    93.927     0.150
     6.349    94.927     0.150
     6.358    94.327     0.150
     6.358    94.327     0.150
     6.371    95.327     0.150
     6.383    97.827     0.150
     6.383    97.827     0.150
     6.447    96.527     0.150
     6.489    96.527     0.150
     6.489    96.527     0.150
     6.514    96.527     0.150
     6.514    96.527     0.150
     6.548    97.227     0.150
     6.556    98.527     0.150
     6.602   165.227     0.150
     6.590    97.827     0.150
     6.673    99.927     0.150
     6.707    99.727     0.150
     6.791   100.327     0.150
     6.895   102.727     0.150
     6.999   181.847     0.150
     6.937   102.827     0.150
     7.191   107.427     0.150
     7.117   104.127     0.150
     7.400   111.127     0.150
     7.379   107.827     0.150
     7.379   185.727     0.150
     7.385   109.027     0.150
     7.540   112.327     0.150
     7.540   112.327     0.150
     7.540   192.527     0.150
     7.588   112.957     0.150
     7.548   110.327     0.150
     7.601   110.927     0.150
     7.591   111.727     0.150
     7.643   113.127     0.150
     7.717   111.427     0.150
     7.717   194.827     0.150
     7.813   115.027     0.150
     7.813   197.827     0.150
     7.888   115.227     0.150
     8.011   114.827     0.150
     8.011   202.327     0.150
     7.979   115.927     0.150
     7.997   118.127     0.150
     8.288   124.427     0.150
     8.382   122.127     0.150
     8.414   123.127     0.150
     8.564   126.137     0.150
     8.564   126.127     0.150
     8.565   124.627     0.150
     8.736   125.427     0.150
     8.815   125.727     0.150
     8.865   129.027     0.150
     8.962   128.127     0.150
     8.962   225.927     0.150
     8.983   130.927     0.150
     9.053   133.827     0.150
     9.224   132.527     0.150
     9.224   231.827     0.150
     9.266   133.427     0.150
     9.266   133.427     0.150
     9.355   134.527     0.150
     9.435   136.527     0.150
     9.438   136.427     0.150
     9.462   137.127     0.150
     9.709   141.427     0.150
     9.722   254.857     0.150
     9.749   142.927     0.150
     9.772   240.777     0.150
     9.958   183.927     0.150
    10.048   144.327     0.150
    10.048   144.327     0.150
    10.221   155.927     0.150
    10.221   268.927     0.150
    10.221   346.927     0.150
    10.221   146.927     0.150
    10.221   259.927     0.150
    10.224   146.327     0.150
    10.410   150.527     0.150
    13.730   194.827     0.150
    19.880   480.002     0.150
    21.388   287.827     0.150
    21.390   290.847     0.150
    21.401   291.827     0.150
    28.298   361.327     0.150
    31.890   444.927     0.150
    38.538   444.327     0.150
    38.642   444.477     0.150
    44.008   489.027     0.150
    47.430   515.527     0.150
    47.430   515.547     0.150
    47.430   515.527     0.150
    62.146     5.000     0.150
    62.146     8.000     0.150
    62.200   624.027     0.150
    66.636   650.927     0.150
    66.636     5.500     0.150
    66.636     8.500     0.150
    71.726   684.727     0.150
    80.615   733.027     0.150
    82.972   749.677     0.150
    82.972   749.727     0.150
    84.268   752.327     0.150
    87.893   769.227     0.150
     0.116     2.021     0.150
     0.254     6.391     0.150
     0.819    16.110     0.150
     1.217    22.280     0.150
     1.265    22.680     0.150
     1.430    48.110     0.150
     1.460    49.311     0.150
     1.654    30.811     0.150
     1.886    63.710     0.150
     1.984    67.510     0.150
     2.662    42.710     0.150
     2.951    47.490     0.150
     3.331    53.311     0.150
     3.457    99.510     0.150
     3.710    59.110     0.150
     4.148    64.010     0.150
     4.254    65.010     0.150
     4.820   120.230     0.150
     5.052   136.710     0.150
     5.339    76.910     0.150
     5.836    86.610     0.150
     6.092    91.405     0.150
     6.539   100.747     0.150
     6.621   176.676     0.150
     6.760   103.254     0.150
     0.312     6.490     0.150
     0.824    15.391     0.150
     1.082    19.871     0.150
     1.222    22.951     0.150
     1.661    31.301     0.150
     1.899    34.301     0.150
     1.856    62.801     0.150
     1.884    68.002     0.150
     1.984    69.701     0.150
     2.673    66.400     0.150
     2.673    40.900     0.150
     2.980    43.502     0.150
     3.464    55.701     0.150
     4.159    76.201     0.150
     4.422   115.781     0.150
     4.552    63.900     0.150
     4.652    68.002     0.150
     4.986    75.602     0.150
     5.062    79.602     0.150
     5.097    76.102     0.150
     5.255    82.102     0.150
     5.630    83.102     0.150
     6.157    92.201     0.150
     6.626    94.801     0.150
     6.599   175.461     0.150
     7.838   114.801     0.150
     7.838   197.301     0.150
     7.940   119.400     0.150
     8.031   115.400     0.150
     8.031   203.400     0.150
     9.069   128.002     0.150
     9.773   247.457     0.150
    10.431   152.801     0.150
    10.431   152.701     0.150
    20.039   273.701     0.150
    21.549   279.602     0.150
    31.915   801.502     0.150
     1.773    31.488     0.150
     1.750    29.719     0.150
     1.925    56.598     0.150
     3.524    57.977     0.150
     4.206   110.676     0.150
     4.872    74.477     0.150
     5.218    79.176     0.150
     5.337   138.645     0.150
     5.313    85.879     0.150
     5.828   192.867     0.150
     6.920   171.477     0.150
     7.385   181.176     0.150
     7.988   193.176     0.150
     8.357   202.777     0.150
     8.596   208.578     0.150
     8.733   211.777     0.150
     9.625   232.578     0.150
    47.270   517.137     0.150
     0.175     3.754     0.150
     0.175     7.516     0.150
     0.181     4.176     0.150
     0.181     8.664     0.150
     0.294     5.617     0.150
     0.289     5.207     0.150
     0.311     6.254     0.150
     0.370     6.664     0.150
     0.370     6.867     0.150
     0.686    21.535     0.150
     0.746    14.336     0.150
     1.245    20.727     0.150
     1.280    26.445     0.150
     1.271    24.254     0.150
     1.472    28.504     0.150
     1.645    31.145     0.150
     1.755    31.484     0.150
     1.898    36.848     0.150
     2.388    37.645     0.150
     2.419    41.965     0.150
     2.613    43.098     0.150
     2.678    42.875     0.150
     2.678    43.375     0.150
     2.814    45.574     0.150
     2.880    50.367     0.150
     2.824    47.434     0.150
     2.824    46.965     0.150
     2.969    42.477     0.150
     2.974    49.984     0.150
     3.181    50.227     0.150
     3.315    51.965     0.150
     3.417    53.004     0.150
     3.667    54.406     0.150
     3.722    57.324     0.150
     3.722    85.270     0.150
     3.931    60.824     0.150
     3.922    61.676     0.150
     3.922   108.387     0.150
     4.064    62.859     0.150
     4.064    63.297     0.150
     4.114   111.938     0.150
     4.114   111.914     0.150
     4.235    63.824     0.150
     4.235   113.625     0.150
     4.235    63.824     0.150
     4.235   113.625     0.150
     4.396    68.395     0.150
     4.537    67.855     0.150
     4.475   123.598     0.150
     4.627    69.746     0.150
     5.027    75.066     0.150
     5.027    74.547     0.150
     5.258    79.945     0.150
     5.341    80.215     0.150
     5.534   146.973     0.150
     5.650    89.125     0.150
     5.689    80.012     0.150
     5.689   152.988     0.150
     5.742    90.227     0.150
     5.742    84.727     0.150
     5.742   147.027     0.150
     5.742    84.727     0.150
     5.742    90.227     0.150
     5.742   147.027     0.150
     6.173    90.027     0.150
     6.173   156.324     0.150
     6.173    90.027     0.150
     6.173   156.324     0.150
     6.204    95.727     0.150
     6.204    89.926     0.150
     6.204   158.727     0.150
     6.204    89.926     0.150
     6.204    95.727     0.150
     6.204   158.727     0.150
     6.243    93.527     0.150
     6.230    92.438     0.150
     6.470    96.336     0.150
     6.545   100.824     0.150
     6.545    97.027     0.150
     6.545   166.125     0.150
     6.545    97.027     0.150
     6.545   100.824     0.150
     6.545   166.125     0.150
     6.620    98.227     0.150
     6.624    97.961     0.150
     6.624    97.617     0.150
     6.707   100.625     0.150
     6.760    99.305     0.150
     6.951   104.324     0.150
     6.951   220.426     0.150
     6.951   104.324     0.150
     6.951   175.926     0.150
     6.951   104.324     0.150
     6.951   131.727     0.150
     6.951   175.926     0.150
     6.973   104.125     0.150
     6.973   104.125     0.150
     6.973   176.824     0.150
     6.973   104.125     0.150
     6.973   176.824     0.150
     6.980   101.926     0.150
     7.040   102.727     0.150
     7.040   177.625     0.150
     7.055   103.926     0.150
     7.055   177.125     0.150
     7.131   106.824     0.150
     7.197   107.727     0.150
     7.197   181.527     0.150
     7.197   107.727     0.150
     7.197   181.527     0.150
     7.189   106.086     0.150
     7.259   104.426     0.150
     7.328   110.426     0.150
     7.423   107.926     0.150
     7.423   188.926     0.150
     7.538   110.727     0.150
     7.583   204.020     0.150
     7.583   110.375     0.150
     7.662   202.027     0.150
     7.706   196.027     0.150
     7.697   111.824     0.150
     7.746   112.324     0.150
     7.746   197.426     0.150
     7.827   115.125     0.150
     7.934   114.027     0.150
     7.954   115.727     0.150
     7.954   198.527     0.150
     7.954   115.727     0.150
     7.954   198.527     0.150
     7.977   116.426     0.150
     7.977   148.125     0.150
     7.977   252.027     0.150
     7.977   116.426     0.150
     7.977   200.926     0.150
     7.977   116.426     0.150
     7.977   148.125     0.150
     7.977   200.926     0.150
     7.910   116.527     0.150
     8.055   115.426     0.150
     8.075   116.527     0.150
     8.188   117.797     0.150
     8.255   118.324     0.150
     8.255   207.027     0.150
     8.223   118.527     0.150
     8.406   120.227     0.150
     8.406   210.926     0.150
     8.406   120.227     0.150
     8.406   210.926     0.150
     8.455   123.879     0.150
     8.524   121.926     0.150
     8.524   215.227     0.150
     8.519   124.324     0.150
     8.570   122.074     0.150
     8.596   123.027     0.150
     8.672   123.324     0.150
     8.672   217.625     0.150
     8.672   123.324     0.150
     8.672   217.625     0.150
     8.656   125.777     0.150
     8.678   124.824     0.150
     8.777   125.027     0.150
     8.777   218.625     0.150
     8.777   125.027     0.150
     8.777   218.625     0.150
     8.754   126.867     0.150
     8.832   127.527     0.150
     8.829   127.426     0.150
     8.848   126.969     0.150
     8.848   232.004     0.150
     8.952   128.727     0.150
     8.997   132.102     0.150
     9.010   131.957     0.150
     9.010   131.957     0.150
     9.051   130.426     0.150
     9.112   128.926     0.150
     9.112   231.926     0.150
     9.137   130.625     0.150
     9.179   131.324     0.150
     9.274   231.227     0.150
     9.277   134.824     0.150
     9.277   134.824     0.150
     9.277   232.125     0.150
     9.277   134.824     0.150
     9.277   232.125     0.150
     9.299   136.516     0.150
     9.328   135.824     0.150
     9.336   136.027     0.150
     9.462   134.625     0.150
     9.462   235.926     0.150
     9.489   235.547     0.150
     9.489   250.547     0.150
     9.489   135.027     0.150
     9.489   250.527     0.150
     9.548   136.926     0.150
     9.548   136.926     0.150
     9.548   238.527     0.150
     9.536   137.598     0.150
     9.536   137.598     0.150
     9.600   137.824     0.150
     9.600   240.027     0.150
     9.600   137.824     0.150
     9.600   240.027     0.150
     9.577   140.047     0.150
     9.577   140.047     0.150
     9.577   262.426     0.150
     9.577   262.426     0.150
     9.566   138.871     0.150
     9.641   138.227     0.150
     9.641   239.824     0.150
     9.641   138.227     0.150
     9.641   239.824     0.150
     9.690   138.824     0.150
     9.690   138.824     0.150
     9.690   240.926     0.150
     9.690   138.824     0.150
     9.690   240.926     0.150
     9.724   247.027     0.150
     9.724   139.727     0.150
     9.724   247.027     0.150
     9.724   139.727     0.150
     9.724   247.027     0.150
     9.743   139.926     0.150
     9.743   139.926     0.150
     9.743   242.426     0.150
     9.834   141.324     0.150
     9.834   245.125     0.150
     9.834   141.324     0.150
     9.834   245.125     0.150
     9.893   143.422     0.150
     9.968   142.926     0.150
     9.968   242.926     0.150
     9.968   276.926     0.150
     9.968   312.926     0.150
     9.968   324.926     0.150
     9.968   330.926     0.150
     9.968   330.926     0.150
     9.962   185.059     0.150
    10.060   147.855     0.150
    10.060   292.617     0.150
    10.060   146.957     0.150
    10.112   145.227     0.150
    10.112   252.027     0.150
    10.112   145.227     0.150
    10.112   252.027     0.150
    10.114   144.984     0.150
    10.114   145.027     0.150
    10.208   145.824     0.150
    10.208   254.824     0.150
    10.208   145.824     0.150
    10.208   254.824     0.150
    10.303   194.727     0.150
    10.303   148.527     0.150
    10.303   194.727     0.150
    10.303   255.824     0.150
    10.393   150.824     0.150
    10.607   157.426     0.150
    10.607   151.125     0.150
    10.607   263.926     0.150
    10.607   151.125     0.150
    10.607   157.426     0.150
    10.607   263.926     0.150
    10.633   151.426     0.150
    10.633   157.727     0.150
    10.633   197.824     0.150
    10.633   151.426     0.150
    10.633   262.926     0.150
    10.633   151.426     0.150
    10.633   157.727     0.150
    10.633   197.824     0.150
    10.633   262.926     0.150
    10.678   154.031     0.150
    10.678   153.785     0.150
    10.926   188.766     0.150
    10.926   206.336     0.150
    11.001   159.227     0.150
    11.001   272.527     0.150
    11.001   159.227     0.150
    11.001   272.527     0.150
    11.046   164.984     0.150
    11.046   192.457     0.150
    11.046   209.316     0.150
    11.094   193.105     0.150
    11.094   212.617     0.150
    11.236   161.027     0.150
    11.236   277.824     0.150
    11.236   161.027     0.150
    11.236   277.824     0.150
    11.258   281.625     0.150
    11.258   161.625     0.150
    11.258   281.625     0.150
    11.258   161.625     0.150
    11.258   281.625     0.150
    11.308   164.867     0.150
    11.308   164.867     0.150
    11.735   292.727     0.150
    11.735   167.926     0.150
    11.735   292.727     0.150
    11.735   167.926     0.150
    11.735   292.727     0.150
    11.757   167.926     0.150
    11.757   291.125     0.150
    11.757   167.926     0.150
    11.757   291.125     0.150
    11.721   325.926     0.150
    11.721   167.926     0.150
    11.721   297.926     0.150
    11.942   171.336     0.150
    12.028   174.316     0.150
    12.028   174.316     0.150
    12.574   178.426     0.150
    12.574   311.727     0.150
    12.574   178.426     0.150
    12.574   311.727     0.150
    12.865   177.625     0.150
    12.865   177.625     0.150
    12.865   177.625     0.150
    12.865   316.527     0.150
    12.908   239.426     0.150
    12.908   182.426     0.150
    12.908   318.625     0.150
    12.908   182.426     0.150
    12.908   239.426     0.150
    12.908   318.625     0.150
    12.863   187.527     0.150
    13.877   195.824     0.150
    13.877   341.727     0.150
    13.877   195.824     0.150
    13.877   341.727     0.150
    13.907   197.047     0.150
    13.907   197.547     0.150
    14.006   196.926     0.150
    14.127   199.227     0.150
    14.127   347.324     0.150
    14.127   199.227     0.150
    14.127   347.324     0.150
    14.350   267.824     0.150
    14.350   201.727     0.150
    14.350   354.727     0.150
    14.350   201.727     0.150
    14.350   267.824     0.150
    14.350   354.727     0.150
    14.442   203.105     0.150
    15.841   221.926     0.150
    15.841   396.926     0.150
    15.968   413.766     0.150
    17.105   432.824     0.150
    19.128   270.027     0.150
    19.727   278.027     0.150
    20.012   272.457     0.150
    20.142   279.312     0.150
    20.142   279.625     0.150
    20.340   267.324     0.150
    20.856   533.027     0.150
    21.095   291.625     0.150
    24.452   321.527     0.150
    27.854   350.691     0.150
    28.189   343.227     0.150
    31.445   382.984     0.150
    33.209   720.324     0.150
    38.174   438.824     0.150
    40.112   455.926     0.150
    40.864   462.164     0.150
    43.090   478.891     0.150
    44.456   497.547     0.150
    44.641   492.824     0.150
    45.266   497.426     0.150
    45.373   497.926     0.150
    45.676   499.824     0.150
    46.341   506.027     0.150
    46.386   506.727     0.150
    46.730   508.727     0.150
    47.314   514.727     0.150
    49.076   525.926     0.150
    52.906   553.895     0.150
    55.082   570.207     0.150
    55.338   571.637     0.150
    58.333   594.625     0.150
    58.739   596.824     0.150
    62.369     5.000     0.150
    62.369     7.500     0.150
    64.060   631.355     0.150
    66.866     4.801     0.150
    66.866     7.301     0.150
    66.872   651.816     0.150
    68.983     3.301     0.150
    69.989   670.754     0.150
    70.296   671.406     0.150
    72.886   687.828     0.150
    73.165   690.875     0.150
    73.283   691.145     0.150
    73.524   691.797     0.150
    73.978   858.910     0.150
    74.702   698.285     0.150
    74.753   699.746     0.150
    76.073   708.848     0.150
    76.506   709.688     0.150
    76.597   709.098     0.150
    78.555   720.469     0.150
    80.595   731.555     0.150
    83.886   748.746     0.150
     0.285     5.242     0.150
     0.463     8.266     0.150
     0.956    21.766     0.150
     1.019    19.898     0.150
     1.098    21.398     0.150
     1.110    22.477     0.150
     1.286    25.242     0.150
     1.392    25.680     0.150
     1.501    28.266     0.150
     1.652    31.453     0.150
     1.687    30.820     0.150
     1.761    32.359     0.150
     1.730    34.836     0.150
     1.849    36.141     0.150
     1.848    32.430     0.150
     1.944    36.477     0.150
     2.183    39.180     0.150
     2.394    40.742     0.150
     2.820    42.312     0.150
     3.556    57.102     0.150
     3.673    60.242     0.150
     3.724    57.664     0.150
     4.064    62.859     0.150
     4.115   112.102     0.150
     4.155   113.102     0.150
     5.121   137.492     0.150
     5.436    83.508     0.150
     5.541   147.625     0.150
     5.911   156.359     0.150
     6.037    91.109     0.150
     6.086    92.008     0.150
     6.216    89.828     0.150
     6.625    98.031     0.150
    10.200   258.766     0.150
     0.774    14.484     0.150
     0.748    12.125     0.150
     0.749    14.867     0.150
     0.825    16.516     0.150
     1.095    22.156     0.150
     1.231    24.195     0.150
     1.260    24.352     0.150
     1.292    25.953     0.150
     1.376    26.672     0.150
     1.483    28.719     0.150
     1.488    29.062     0.150
     1.515    30.445     0.150
     1.627    32.664     0.150
     1.718    33.938     0.150
     1.710    29.883     0.150
     1.712    31.422     0.150
     1.749    34.039     0.150
     2.845    78.492     0.150
     2.845    45.594     0.150
     2.845    45.672     0.150
     2.837    48.266     0.150
     3.746    57.805     0.150
     4.906    73.898     0.150
     5.134    73.352     0.150
     5.438    79.992     0.150
     6.285    90.023     0.150
     6.411    91.500     0.150
     6.635    95.445     0.150
     8.720   124.344     0.150
    47.667   518.289     0.150
     0.280    10.109     0.150
     0.755    16.883     0.150
     0.829    16.414     0.150
     0.925    18.438     0.150
     0.991    18.328     0.150
     1.001    20.273     0.150
     1.075    21.242     0.150
     1.092    22.531     0.150
     1.227    23.523     0.150
     1.262    24.367     0.150
     1.493    28.352     0.150
     1.637    31.930     0.150
     1.855    34.953     0.150
     1.739    31.398     0.150
     1.718    30.539     0.150
     2.865    48.938     0.150
     3.216    50.117     0.150
     3.753    58.086     0.150
     3.918    61.117     0.150
     4.206    60.320     0.150
     4.206   107.422     0.150
     5.716    81.320     0.150
     6.175    87.617     0.150
     6.175   153.320     0.150
     6.409    92.281     0.150
     6.520    91.922     0.150
     6.616   173.281     0.150
     7.012    99.023     0.150
     7.471   183.172     0.150
     7.600   105.414     0.150
     7.600   190.352     0.150
     7.955   116.617     0.150
     8.063   113.789     0.150
     8.389   116.922     0.150
     8.389   122.219     0.150
     8.430   121.891     0.150
     8.657   126.719     0.150
     8.760   128.117     0.150
     8.869   125.414     0.150
    14.705   217.219     0.150
    47.673   518.375     0.150
     0.336     6.451     0.150
     0.702    13.521     0.150
     0.780    13.641     0.150
     0.973    18.371     0.150
     0.973    18.371     0.150
     1.138    21.641     0.150
     1.278    23.121     0.150
     1.278    38.502     0.150
     1.246    42.730     0.150
     2.283    76.342     0.150
     2.332    67.822     0.150
     2.648    43.682     0.150
     3.615    56.041     0.150
     3.722    57.742     0.150
     3.924    60.641     0.150
     5.062    75.412     0.150
     5.245    79.961     0.150
     5.245   137.281     0.150
     5.249    75.752     0.150
     5.569   147.520     0.150
     6.214    92.871     0.150
     6.488   170.795     0.150
     6.449    96.561     0.150
     6.621    98.051     0.150
     6.621    98.012     0.150
     6.710    98.162     0.150
     6.910   176.766     0.150
     6.980   105.141     0.150
     7.085   102.541     0.150
     7.127   105.402     0.150
     7.204   107.621     0.150
     7.196   106.340     0.150
     7.264   105.994     0.150
     7.288   104.141     0.150
     7.288   182.541     0.150
     7.288   187.342     0.150
     7.452   108.641     0.150
     7.505   182.080     0.150
     7.607   109.842     0.150
     7.600   110.750     0.150
     7.772   112.641     0.150
     7.772   196.242     0.150
     7.796   112.162     0.150
     7.979   119.041     0.150
     7.966   115.742     0.150
     8.007   119.441     0.150
     8.035   117.891     0.150
     8.086   118.434     0.150
     8.222   124.326     0.150
     8.222   119.402     0.150
     8.297   121.141     0.150
     8.469   123.385     0.150
     8.545   123.842     0.150
     8.603   124.041     0.150
     8.603   124.061     0.150
     8.603   219.271     0.150
     8.629   123.141     0.150
     8.631   126.375     0.150
     8.686   126.656     0.150
     8.706   126.836     0.150
     8.810   130.441     0.150
     8.743   126.271     0.150
     8.743   220.891     0.150
     8.863   126.742     0.150
     9.035   132.811     0.150
     9.082   131.441     0.150
     9.307   135.516     0.150
     9.358   136.041     0.150
     9.522   240.861     0.150
     9.522   299.941     0.150
     9.522   135.441     0.150
     9.522   240.842     0.150
     9.567   139.695     0.150
     9.604   139.299     0.150
     9.892   143.938     0.150
     9.901   142.857     0.150
     9.957   143.521     0.150
    10.002   143.441     0.150
    10.002   148.441     0.150
    10.002   250.441     0.150
    10.002   272.441     0.150
    10.002   313.441     0.150
    10.002   326.441     0.150
    10.002   339.441     0.150
    10.173   146.695     0.150
    10.396   150.102     0.150
    10.680   153.672     0.150
    10.778   279.742     0.150
    17.105   233.541     0.150
    17.105   420.342     0.150
    20.026   295.842     0.150
    21.096   292.742     0.150
    38.600   442.611     0.150
    38.688   443.941     0.150
    38.688   443.941     0.150
    38.720   443.861     0.150
    38.837   444.941     0.150
    39.074   446.842     0.150
    45.966   913.242     0.150
    52.309     5.100     0.150
    52.309   671.742     0.150
    62.376     5.799     0.150
    62.376     8.500     0.150
    66.872     4.199     0.150
    66.872     7.299     0.150
    68.053   657.742     0.150
    68.053   657.721     0.150
    70.329   673.002     0.150
    73.199   689.842     0.150
    83.920   749.002     0.150
     1.835    35.016     0.150
     2.690    73.523     0.150
     3.188    49.973     0.150
     6.564   101.773     0.150
     6.623   162.088     0.150
     7.216   110.873     0.150
     7.495   185.061     0.150
     7.998   116.873     0.150
     7.998   204.172     0.150
     8.696   125.672     0.150
     8.696   220.873     0.150
     8.800   132.473     0.150
     8.800   223.273     0.150
     9.992   275.973     0.150
    10.185   149.016     0.150
     0.574    11.068     0.150
     0.681    12.719     0.150
     0.821    16.107     0.150
     1.189    22.107     0.150
     1.255    23.658     0.150
     1.269    23.758     0.150
     8.549   126.719     0.150
     0.681    13.234     0.150
     1.337    22.523     0.150
     1.337    23.074     0.150
     1.554    50.926     0.150
     1.680    29.035     0.150
     2.107    69.523     0.150
     2.162    70.625     0.150
     2.292    40.613     0.150
     2.337    37.934     0.150
     2.446    41.145     0.150
     2.731    45.086     0.150
     2.726    43.727     0.150
     2.905    46.426     0.150
     3.204    50.727     0.150
     3.271    51.824     0.150
     3.271    51.773     0.150
     3.373    55.074     0.150
     3.691    57.594     0.150
     3.780    60.363     0.150
     3.967    62.086     0.150
     4.098    61.887     0.150
     4.098    55.945     0.150
     4.166    64.234     0.150
     4.169    58.184     0.150
     4.187    64.203     0.150
     4.303    66.875     0.150
     4.337    57.613     0.150
     4.396    66.785     0.150
     4.521   123.727     0.150
     4.814    72.277     0.150
     4.794   127.926     0.150
     4.962    73.855     0.150
     4.916    75.344     0.150
     5.002    60.305     0.150
     5.066    77.785     0.150
     5.950   146.625     0.150
     5.918    88.465     0.150
     6.166    91.469     0.150
     6.254    92.586     0.150
     6.254    93.863     0.150
     6.187    92.766     0.150
     6.226    93.977     0.150
     6.461   158.426     0.150
     6.555   168.727     0.150
     6.665    97.523     0.150
     6.665   168.727     0.150
     6.709   164.324     0.150
     6.866    99.023     0.150
     6.866   173.125     0.150
     7.068   173.023     0.150
     7.089   174.227     0.150
     7.131   102.406     0.150
     7.319   107.227     0.150
     7.319   186.523     0.150
     7.426   111.523     0.150
     7.492   108.023     0.150
     7.819   116.227     0.150
     8.051   197.824     0.150
     8.089   119.926     0.150
     8.089   199.523     0.150
     8.123   116.004     0.150
     8.147   199.125     0.150
     8.156   116.477     0.150
     8.271   120.113     0.150
     8.291   118.824     0.150
     8.291   207.926     0.150
     8.381   121.113     0.150
     8.377   121.613     0.150
     8.498   207.227     0.150
     8.545   122.195     0.150
     8.525   127.824     0.150
     8.525   132.324     0.150
     8.699   127.125     0.150
     8.709   124.523     0.150
     8.831   128.125     0.150
     8.835   128.426     0.150
     8.835   128.426     0.150
     9.199   157.125     0.150
     9.199   196.523     0.150
     9.199   241.426     0.150
     9.199   130.926     0.150
     9.199   241.426     0.150
     9.397   228.824     0.150
     9.389   137.023     0.150
     9.409   137.227     0.150
     9.577   231.426     0.150
     9.702   256.625     0.150
     9.702   138.727     0.150
     9.702   245.625     0.150
     9.761   238.023     0.150
     9.943   241.824     0.150
     9.973   243.023     0.150
    10.069   143.977     0.150
    10.213   150.227     0.150
    10.271   250.426     0.150
    10.969   158.523     0.150
    14.299   204.324     0.150
    20.377   288.625     0.150
    20.377   495.324     0.150
    21.915   294.926     0.150
    24.304   315.426     0.150
    28.807   356.184     0.150
    43.318   484.316     0.150
    44.372   489.355     0.150
    45.359   496.285     0.150
    45.506   602.426     0.150
    46.057   505.156     0.150
    47.160   512.754     0.150
    61.886     4.301     0.150
    61.886     7.000     0.150
    64.009   633.465     0.150
    67.796   657.316     0.150
    74.489   693.754     0.150
    75.719   701.805     0.150
    83.826   750.613     0.150
     0.835    27.652     0.150
     0.944    17.234     0.150
     1.049    19.125     0.150
     1.231    38.973     0.150
     1.510    25.715     0.150
     2.885    45.902     0.150
     2.977    47.504     0.150
     2.977    47.473     0.150
     2.992    49.703     0.150
     3.409    51.160     0.150
     3.490    55.602     0.150
     4.690    74.910     0.150
     5.040    80.156     0.150
     5.100    75.504     0.150
     5.432    83.352     0.150
     5.485    81.355     0.150
     5.533    84.367     0.150
     6.191    94.102     0.150
     6.719   101.305     0.150
     6.745   290.102     0.150
     6.944   107.922     0.150
     7.517   112.402     0.150
     7.591   113.703     0.150
     7.745   111.004     0.150
     8.761   129.703     0.150
     9.102   136.781     0.150
     9.597   140.602     0.150
     9.879   145.305     0.150
    10.182   149.402     0.150
    30.896   378.320     0.150
     0.359     7.789     0.150
     0.835    14.469     0.150
     0.851    16.449     0.150
     0.959    17.539     0.150
     1.021    18.289     0.150
     1.060    18.961     0.150
     1.060    33.820     0.150
     1.522    27.449     0.150
     1.522    48.660     0.150
     1.550    48.941     0.150
     1.633    29.289     0.150
     1.725    30.719     0.150
     2.189    36.859     0.150
     2.249    40.449     0.150
     2.944    48.031     0.150
     4.788   121.379     0.150
     5.284    93.879     0.150
     5.467    82.195     0.150
     6.186    94.578     0.150
     6.924    98.180     0.150
     0.810    14.984     0.150
     0.982    17.812     0.150
     1.456    27.863     0.150
     3.289    48.762     0.150
     4.847    64.254     0.150
     5.251    79.262     0.150
     5.398    81.824     0.150
     6.426    89.520     0.150
     6.426    89.562     0.150
     7.688   108.062     0.150
    21.066   279.543     0.150
     0.510     9.062     0.150
     0.852    29.570     0.150
     0.852    15.344     0.150
     0.852    15.523     0.150
     0.852    29.250     0.150
     0.964    33.242     0.150
     1.262    40.211     0.150
     1.723    30.500     0.150
     1.793    31.422     0.150
     1.975    33.680     0.150
     2.012    36.008     0.150
     2.115    60.172     0.150
     2.434    38.398     0.150
     2.477    45.008     0.150
     2.480    70.188     0.150
     2.556    43.164     0.150
     3.551    57.117     0.150
     3.929    61.430     0.150
     4.082    61.719     0.150
     4.059    74.023     0.150
     4.106    64.391     0.150
     4.128   115.242     0.150
     4.323   119.719     0.150
     4.504    66.609     0.150
     4.692    71.922     0.150
     4.732    71.289     0.150
     4.775    73.547     0.150
     4.923    72.312     0.150
     5.002    76.117     0.150
     5.074    78.344     0.150
     5.084    77.023     0.150
     5.137    78.703     0.150
     5.496    82.922     0.150
     5.479    88.422     0.150
     5.798   154.820     0.150
     5.962    89.320     0.150
     6.582   103.117     0.150
     6.582   171.719     0.150
     6.682    99.141     0.150
     6.969   103.320     0.150
     6.969   108.023     0.150
     6.969   180.523     0.150
     6.990   109.219     0.150
     7.248   110.117     0.150
     7.337   104.938     0.150
     7.814   121.141     0.150
     7.977   203.922     0.150
     8.004   207.023     0.150
     8.212   119.820     0.150
     8.327   215.023     0.150
     8.377   126.922     0.150
     8.485   219.422     0.150
     9.111   133.594     0.150
     9.297   134.523     0.150
     9.297   236.523     0.150
     9.317   136.672     0.150
     9.364   144.320     0.150
     9.364   238.922     0.150
     9.394   135.180     0.150
     9.531   241.023     0.150
     9.661   144.320     0.150
     9.704   140.219     0.150
     9.704   245.117     0.150
     9.762   180.422     0.150
     9.838   226.820     0.150
     9.838   264.820     0.150
     9.838   306.820     0.150
     9.862   147.820     0.150
    10.148   256.922     0.150
    10.172   257.047     0.150
    13.723   192.664     0.150
    19.647   265.367     0.150
    19.810   266.602     0.150
    19.907   268.539     0.150
    21.105   278.891     0.150
    21.106   279.328     0.150
    22.761   298.938     0.150
    24.569   579.523     0.150
    31.384   378.320     0.150
    32.322   385.133     0.150
    32.322   385.852     0.150
    38.514   441.359     0.150
    38.904   446.617     0.150
    41.606   453.820     0.150
    46.894   509.641     0.150
    62.181     4.203     0.150
    62.181     7.203     0.150
    80.877   734.367     0.150
     0.029     1.781     0.150
     0.223     9.938     0.150
     0.793    16.445     0.150
     0.793    29.336     0.150
     1.343    25.383     0.150
     2.558    42.547     0.150
     3.046    81.969     0.150
     3.037    46.625     0.150
     4.305   109.523     0.150
     4.676    74.422     0.150
     5.155    79.727     0.150
     5.164    77.984     0.150
     5.439    83.039     0.150
     5.765    87.453     0.150
     6.164    94.617     0.150
     6.960   103.922     0.150
     7.091   100.523     0.150
     7.226   102.828     0.150
     7.971   117.625     0.150
     8.375   122.523     0.150
     8.748   127.422     0.150
    24.804   324.328     0.150
     0.950    20.590     0.150
     1.041    18.710     0.150
     1.242    24.350     0.150
     2.789    43.820     0.150
     3.757    76.350     0.150
     5.146    78.318     0.150
     5.426    83.009     0.150
     5.790    83.350     0.150
     5.746    87.263     0.150
     6.256    90.408     0.150
     6.983   106.050     0.150
    21.106   285.775     0.150
    24.782   325.500     0.150
     0.937    20.703     0.150
     0.961    32.914     0.150
     1.228    24.305     0.150
     1.316    24.969     0.150
     3.033    82.633     0.150
     4.329   109.172     0.150
     4.691    71.672     0.150
     5.011    74.172     0.150
     5.050    75.172     0.150
     5.435    83.344     0.150
     5.804    82.672     0.150
     6.267   166.383     0.150
     6.287    89.172     0.150
     6.287   157.078     0.150
     6.975    99.172     0.150
     6.975   104.078     0.150
     6.996   105.273     0.150
     8.383   122.273     0.150
     9.537   133.273     0.150
     0.714    23.156     0.150
     0.810    16.398     0.150
     1.023    18.898     0.150
     1.260    24.703     0.150
     1.374    26.367     0.150
     1.377    25.578     0.150
     1.656    29.977     0.150
     1.801    52.273     0.150
     3.556    93.984     0.150
     3.556    55.859     0.150
     4.197    61.555     0.150
     4.661    74.727     0.150
     4.798    73.555     0.150
     4.995    73.109     0.150
     5.040    78.125     0.150
     5.484    87.859     0.150
     5.968    83.500     0.150
     6.168    89.953     0.150
     6.466    94.898     0.150
     6.574   100.859     0.150
     6.961   179.055     0.150
     7.887   202.148     0.150
     8.215   118.875     0.150
     8.447   215.859     0.150
     8.664   221.258     0.150
     0.917    18.611     0.150
     1.963    32.961     0.150
     2.639    42.531     0.150
     3.361    52.801     0.150
     3.361    52.000     0.150
     3.657    50.701     0.150
     3.836    63.121     0.150
     4.506   123.041     0.150
     5.296    78.682     0.150
     5.342    82.049     0.150
     5.593   148.982     0.150
     5.634    85.891     0.150
     6.291   166.275     0.150
     6.429    97.602     0.150
     7.305   111.201     0.150
     8.082   121.900     0.150
     9.642   142.801     0.150
     9.718   143.301     0.150
     9.718   239.301     0.150
     9.718   319.301     0.150
     9.718   319.301     0.150
    14.384   207.123     0.150
     0.734    14.676     0.150
     0.750    15.336     0.150
     0.811    17.098     0.150
     1.229    25.824     0.150
     1.348    26.105     0.150
     1.374    25.867     0.150
     1.595    30.145     0.150
     1.653    29.426     0.150
     2.100    38.598     0.150
     2.526    45.598     0.150
     2.640    39.848     0.150
     3.573    56.125     0.150
     3.989    63.047     0.150
     3.989   109.414     0.150
     4.317    69.027     0.150
     4.969    76.012     0.150
     5.140    78.969     0.150
     5.226    74.324     0.150
     5.427    84.488     0.150
     5.746    87.613     0.150
     7.526   110.625     0.150
     8.372   120.926     0.150
     8.625   129.324     0.150
    21.105   285.527     0.150
     1.251    24.180     0.150
     1.335    24.000     0.150
     1.453    26.859     0.150
     1.779    64.602     0.150
     1.779    29.570     0.150
     2.571    39.891     0.150
     2.970    45.000     0.150
     3.225    49.055     0.150
     3.286    51.602     0.150
     3.308    51.961     0.150
     3.723    56.945     0.150
     3.963    63.297     0.150
     4.446    63.195     0.150
     4.446   110.398     0.150
     4.913    68.055     0.150
     5.185    70.578     0.150
     5.244   134.430     0.150
     6.012    90.969     0.150
     6.077    85.570     0.150
     6.151   154.609     0.150
     6.195    87.117     0.150
     6.381   156.602     0.150
     6.616    92.898     0.150
     6.619    92.812     0.150
     6.972   103.695     0.150
     6.993   103.297     0.150
     7.083   111.625     0.150
     7.275   102.195     0.150
     7.400   134.398     0.150
     7.614   184.422     0.150
     7.952   111.000     0.150
     7.952   116.000     0.150
     8.303   121.102     0.150
     8.533   118.695     0.150
     8.533   123.797     0.150
     8.681   126.500     0.150
     8.826   123.344     0.150
     8.959   138.031     0.150
     9.300   128.797     0.150
     9.300   134.797     0.150
     9.359   136.602     0.150
     9.476   138.398     0.150
     9.593   133.000     0.150
     9.593   139.000     0.150
     9.665   134.102     0.150
     9.665   139.195     0.150
     9.658   140.695     0.150
     9.699   134.500     0.150
     9.699   140.102     0.150
     9.696   142.000     0.150
     9.878   142.898     0.150
    14.186   195.500     0.150
    30.764   378.047     0.150
     0.065     3.680     0.150
     0.739    14.375     0.150
     0.804    16.539     0.150
     1.094    20.062     0.150
     1.420    25.789     0.150
     1.677    29.711     0.150
     2.438    39.234     0.150
     4.506    68.031     0.150
     4.587   114.430     0.150
     5.042    74.711     0.150
     5.155    76.484     0.150
     5.341    78.930     0.150
     5.536    98.273     0.150
     5.547    83.141     0.150
     5.768    86.203     0.150
     5.781   101.164     0.150
     6.463    96.062     0.150
     6.543   160.328     0.150
     8.201   118.930     0.150
     8.201   199.531     0.150
     1.063    18.992     0.150
     1.056    21.469     0.150
     1.167    20.609     0.150
     1.669    29.773     0.150
     2.434    39.141     0.150
     2.583    43.172     0.150
     2.655    44.141     0.150
     2.984    47.141     0.150
     3.619    56.445     0.150
     4.509    64.539     0.150
     4.583    66.242     0.150
     5.069    69.641     0.150
     5.240   132.844     0.150
     5.930   148.344     0.150
     7.218   101.945     0.150
     8.193   118.844     0.150
     9.732   142.141     0.150
     9.919   142.344     0.150
     9.958   145.141     0.150
     0.107     8.323     0.150
     0.911    17.664     0.150
     1.218    22.034     0.150
     1.224    21.724     0.150
     1.335    24.054     0.150
     1.398    25.113     0.150
     1.398    25.144     0.150
     1.410    24.063     0.150
     1.401    23.764     0.150
     1.543    27.313     0.150
     1.773    31.144     0.150
     1.753    28.604     0.150
     1.865    30.534     0.150
     2.164    35.634     0.150
     2.305    37.204     0.150
     2.656    42.273     0.150
     2.656    42.204     0.150
     2.715    43.844     0.150
     2.977    46.894     0.150
     3.076    48.874     0.150
     3.116    48.403     0.150
     3.191    59.004     0.150
     3.139    44.504     0.150
     3.598    57.764     0.150
     3.713    56.834     0.150
     3.790    56.464     0.150
     4.242    66.004     0.150
     4.592    66.874     0.150
     4.757    73.294     0.150
     4.822    74.529     0.150
     4.946    71.704     0.150
     5.074    77.804     0.150
     5.134    74.464     0.150
     5.218    76.934     0.150
     5.341    77.594     0.150
     5.393    78.752     0.150
     5.383    78.264     0.150
     5.497    80.254     0.150
     5.574    83.104     0.150
     6.083    88.638     0.150
     6.222    93.903     0.150
     6.481   161.721     0.150
     6.781   170.369     0.150
     6.862    99.502     0.150
     7.432   102.664     0.150
     7.472   189.004     0.150
     7.739   122.204     0.150
     8.221   119.999     0.150
     8.221   116.704     0.150
     8.847   125.044     0.150
     9.639   185.804     0.150
     9.639   228.804     0.150
     9.639   279.804     0.150
     9.639   309.804     0.150
    10.102   147.903     0.150
    10.896   158.903     0.150
    12.355   178.304     0.150
    13.055   187.804     0.150
    19.801   264.934     0.150
     0.109     8.734     0.150
     0.256    11.295     0.150
     0.686    22.734     0.150
     1.003    19.494     0.150
     1.246    22.055     0.150
     1.291    22.935     0.150
     1.409    25.154     0.150
     1.474    24.885     0.150
     1.984    32.295     0.150
     2.070    33.364     0.150
     2.409    38.465     0.150
     3.021    46.965     0.150
     3.661    54.475     0.150
     3.837    51.034     0.150
     5.171    78.234     0.150
     7.091   104.734     0.150
     7.913   109.234     0.150
     8.727   127.835     0.150
     8.989   131.335     0.150
     9.911   143.734     0.150
    10.179   147.435     0.150
    31.096   372.313     0.150
    46.527   502.147     0.150
     0.082     3.236     0.150
     0.223     8.896     0.150
     0.532    10.216     0.150
     0.722    14.386     0.150
     1.010    18.216     0.150
     1.068    19.386     0.150
     1.364    25.356     0.150
     1.805    32.276     0.150
     2.630    66.656     0.150
     2.950    74.456     0.150
     3.332    53.056     0.150
     3.452    86.456     0.150
     3.452    54.476     0.150
     3.452    54.456     0.150
     3.867    98.156     0.150
     4.221   103.656     0.150
     4.258   104.856     0.150
     4.374    67.746     0.150
     4.520   110.556     0.150
     4.700   115.456     0.150
     5.009   122.256     0.150
     5.029   122.856     0.150
     5.256    76.657     0.150
     6.074    89.456     0.150
     7.024    99.731     0.150
     9.850   247.898     0.150
     0.348    14.496     0.150
     0.664    11.258     0.150
     0.678    11.758     0.150
     0.722    23.328     0.150
     0.834    30.918     0.150
     1.655    28.547     0.150
     1.840    31.516     0.150
     2.746    70.926     0.150
     2.746    44.426     0.150
     2.936    47.125     0.150
     3.253    82.926     0.150
     3.297    52.828     0.150
     3.334    53.027     0.150
     3.334    84.328     0.150
     3.334    52.926     0.150
     3.334    53.125     0.150
     3.334    53.188     0.150
     3.607    91.125     0.150
     3.607    57.328     0.150
     3.770    58.027     0.150
     3.917    99.828     0.150
     3.922    59.777     0.150
     4.279   107.328     0.150
     4.400   112.027     0.150
     4.399   108.328     0.150
     4.413    67.297     0.150
     4.373   114.727     0.150
     4.373    67.535     0.150
     4.533   112.625     0.150
     4.533    70.555     0.150
     4.693    69.406     0.150
     4.777   120.426     0.150
     4.797    71.625     0.150
     4.838   120.328     0.150
    48.352    72.887     0.150
     4.924   120.828     0.150
     5.032    77.227     0.150
     5.032    76.488     0.150
     5.032   124.328     0.150
     5.032    76.527     0.150
     5.057    79.828     0.150
     5.160    81.137     0.150
     5.365    81.328     0.150
     5.432   144.980     0.150
     5.432    80.488     0.150
     5.388    81.527     0.150
     5.621   138.828     0.150
     5.713   139.328     0.150
     5.809   141.926     0.150
     5.818   143.125     0.150
     5.904    88.625     0.150
     5.950   157.242     0.150
     6.043    89.805     0.150
     6.043    89.828     0.150
     6.190    93.926     0.150
     6.190    93.887     0.150
     6.331   153.828     0.150
     6.559   159.828     0.150
     6.756    99.426     0.150
     6.756   173.027     0.150
     6.756    99.477     0.150
     6.754    98.828     0.150
     6.913   168.328     0.150
     6.933   168.625     0.150
     6.990   102.125     0.150
     7.056   102.828     0.150
     7.132   173.527     0.150
     7.218   175.527     0.150
     7.226   105.727     0.150
     7.226   183.625     0.150
     7.226   105.785     0.150
     7.345   106.227     0.150
     7.345   106.227     0.150
     7.345   185.227     0.150
     7.434   107.477     0.150
     7.569   238.320     0.150
     7.745   117.625     0.150
     7.745   198.227     0.150
     7.891   191.625     0.150
     7.957   114.527     0.150
     7.957   112.367     0.150
     7.991   114.426     0.150
     7.998   117.527     0.150
     8.076   115.727     0.150
     8.076   202.426     0.150
     8.058   117.488     0.150
     8.139   117.203     0.150
     8.158   124.781     0.150
     8.158   124.727     0.150
     8.233   118.625     0.150
     8.241   200.027     0.150
     8.228   121.426     0.150
     8.249   118.828     0.150
     8.379   120.027     0.150
     8.471   205.926     0.150
     8.478   123.035     0.150
     8.478   123.027     0.150
     8.618   209.027     0.150
     8.801   130.527     0.150
     9.057   226.875     0.150
     9.057   301.547     0.150
     9.057   130.227     0.150
     9.057   226.828     0.150
     9.044   131.844     0.150
     9.092   133.277     0.150
     9.240   223.727     0.150
     9.297   225.625     0.150
     9.368   138.527     0.150
     9.414   228.027     0.150
     9.424   137.227     0.150
     9.480   137.227     0.150
     9.555   269.227     0.150
     9.555   137.227     0.150
     9.555   238.227     0.150
     9.596   232.426     0.150
     9.606   232.426     0.150
     9.569   138.266     0.150
     9.634   233.227     0.150
     9.639   233.328     0.150
     9.819   237.625     0.150
     9.899   139.637     0.150
     9.899   138.297     0.150
     9.899   261.906     0.150
     9.899   139.625     0.150
     9.963   143.328     0.150
    10.120   244.727     0.150
    10.216   148.828     0.150
    10.258   248.027     0.150
    10.829   143.777     0.150
    11.442   165.926     0.150
    11.753   167.328     0.150
    13.302   191.426     0.150
    15.313   216.258     0.150
    15.313   216.258     0.150
    15.313   232.957     0.150
    15.313   387.508     0.150
    15.313   414.566     0.150
    15.313   216.227     0.150
    15.313   387.426     0.150
    18.252   257.027     0.150
    20.774   280.625     0.150
    21.165   284.828     0.150
    27.330   348.027     0.150
    38.214   441.828     0.150
    38.214   441.738     0.150
    42.616   476.625     0.150
    46.128   504.926     0.150
    46.967   508.426     0.150
    55.001   570.125     0.150
    57.726   593.926     0.150
    74.457     7.000     0.150
    83.660   748.328     0.150
     0.345    14.055     0.150
     0.717    12.703     0.150
     0.717    22.953     0.150
     0.857    28.039     0.150
     1.145    39.633     0.150
     1.349    45.336     0.150
     1.444    47.500     0.150
     1.559    28.672     0.150
     1.612    27.133     0.150
     1.617    27.352     0.150
     2.932    46.633     0.150
     3.046    49.492     0.150
     3.291    52.430     0.150
     3.331    52.930     0.150
     3.331    52.844     0.150
     3.331    52.836     0.150
     3.773    58.820     0.150
     3.772   101.945     0.150
     3.776    58.836     0.150
     3.800    59.336     0.150
     3.800    59.031     0.150
     3.800    59.133     0.150
     3.800    59.430     0.150
     3.910    61.031     0.150
     3.921    60.875     0.150
     4.056    62.773     0.150
     4.328    66.336     0.150
     4.396   111.734     0.150
     4.396    68.555     0.150
     4.658    70.570     0.150
     4.658    70.492     0.150
     4.641    73.211     0.150
     4.648    72.234     0.150
     4.783    71.336     0.150
    48.337    72.859     0.150
     4.894    73.438     0.150
     5.035    76.773     0.150
     5.035    76.836     0.150
     5.331    80.719     0.150
     5.331   139.719     0.150
     5.417    80.352     0.150
     5.417    80.352     0.150
     5.417   139.789     0.150
     5.417    80.391     0.150
     5.397    81.430     0.150
     5.788    86.570     0.150
     5.835    91.562     0.150
     5.838    85.477     0.150
     5.873    87.703     0.150
     5.873   155.148     0.150
     5.954    88.102     0.150
     6.008    89.734     0.150
     6.008   156.031     0.150
     6.059   159.508     0.150
     6.059    89.836     0.150
     6.059   159.508     0.150
     6.047    90.336     0.150
     6.168    94.664     0.150
     6.181    93.734     0.150
     6.368    96.703     0.150
     6.374    95.234     0.150
     6.374    95.336     0.150
     6.429    95.164     0.150
     6.429   167.617     0.150
     6.448    95.633     0.150
     6.448   165.430     0.150
     6.483    96.039     0.150
     6.483    96.039     0.150
     6.498    96.859     0.150
     6.498   168.445     0.150
     6.540    96.430     0.150
     6.540   165.531     0.150
     6.540   167.734     0.150
     6.551   160.734     0.150
     6.604   102.633     0.150
     6.728    98.641     0.150
     6.728   176.469     0.150
     6.728    98.641     0.150
     6.719    99.734     0.150
     6.745    98.930     0.150
     6.975   101.430     0.150
     6.975   176.930     0.150
     6.985   102.070     0.150
     7.037   102.078     0.150
     7.037   178.984     0.150
     7.043   103.531     0.150
     7.126   107.836     0.150
     7.162   104.633     0.150
     7.213   105.836     0.150
     7.213   184.336     0.150
     7.213   105.930     0.150
     7.282   107.227     0.150
     7.331   106.031     0.150
     7.331   185.336     0.150
     7.331   106.031     0.150
     7.388   106.781     0.150
     7.419   106.797     0.150
     7.419   186.945     0.150
     7.419   106.727     0.150
     7.425   188.250     0.150
     7.434   107.375     0.150
     7.434   107.305     0.150
     7.454   107.930     0.150
     7.480   108.336     0.150
     7.499   107.945     0.150
     7.499   189.094     0.150
     7.494   110.430     0.150
     7.554   109.352     0.150
     7.554   109.391     0.150
     7.733   115.531     0.150
     7.733   196.336     0.150
     7.944   114.227     0.150
     7.944   114.234     0.150
     7.944   114.227     0.150
     7.938   117.898     0.150
     7.938   117.836     0.150
     7.978   114.633     0.150
     8.061   116.234     0.150
     8.061   116.281     0.150
     8.124   115.539     0.150
     8.138   116.836     0.150
     8.138   203.930     0.150
     8.138   116.836     0.150
     8.144   118.336     0.150
     8.144   118.367     0.150
     8.144   118.336     0.150
     8.222   119.133     0.150
     8.225   119.133     0.150
     8.235   117.234     0.150
     8.235   117.133     0.150
     8.235   117.141     0.150
     8.221   122.234     0.150
     8.221   122.234     0.150
     8.332   120.930     0.150
     8.332   210.336     0.150
     8.352   119.156     0.150
     8.357   123.836     0.150
     8.367   119.633     0.150
     8.367   119.875     0.150
     8.367   119.781     0.150
     8.467   125.031     0.150
     8.479   123.234     0.150
     8.678   124.633     0.150
     8.692   125.133     0.150
     8.719   124.305     0.150
     8.756   126.531     0.150
     8.776   126.430     0.150
     8.796   130.430     0.150
     8.796   219.633     0.150
     8.796   130.492     0.150
     8.830   126.477     0.150
     8.828   129.930     0.150
     8.863   126.633     0.150
     9.042   225.805     0.150
     9.042   293.320     0.150
     9.042   129.086     0.150
     9.046   131.531     0.150
     9.071   128.977     0.150
     9.359   137.633     0.150
     9.430   231.930     0.150
     9.418   136.930     0.150
     9.473   135.250     0.150
     9.473   135.227     0.150
     9.474   138.031     0.150
     9.499   135.805     0.150
     9.540   232.133     0.150
     9.540   136.406     0.150
     9.540   137.031     0.150
     9.540   136.406     0.150
     9.591   136.422     0.150
     9.665   139.500     0.150
     9.672   141.531     0.150
     9.887   262.305     0.150
     9.887   142.047     0.150
     9.958   144.031     0.150
    10.083   147.914     0.150
    10.214   146.117     0.150
    10.217   267.531     0.150
    10.341   147.414     0.150
    10.446   149.930     0.150
    10.584   153.734     0.150
    10.679   154.531     0.150
    10.785   264.930     0.150
    10.889   270.227     0.150
    10.903   156.898     0.150
    11.085   161.016     0.150
    11.201   160.836     0.150
    11.234   161.133     0.150
    11.234   162.531     0.150
    11.434   165.031     0.150
    11.502   163.023     0.150
    11.505   163.891     0.150
    11.760   166.633     0.150
    12.460   177.688     0.150
    13.280   187.133     0.150
    13.374   194.477     0.150
    13.374   194.227     0.150
    13.374   190.133     0.150
    13.374   194.414     0.150
    14.011   196.375     0.150
    14.119   197.031     0.150
    14.182   201.094     0.150
    14.348   363.531     0.150
    15.300   215.430     0.150
    15.300   215.430     0.150
    15.300   215.430     0.150
    15.300   385.031     0.150
    17.923   247.836     0.150
    17.923   250.539     0.150
    18.526   452.523     0.150
    18.869   266.789     0.150
    20.293   492.484     0.150
    20.469   277.031     0.150
    20.550   279.430     0.150
    20.550   283.781     0.150
    21.234   287.430     0.150
    21.720   293.836     0.150
    22.580   301.531     0.150
    24.064   310.633     0.150
    24.112   315.820     0.150
    28.201   352.734     0.150
    31.387   382.133     0.150
    31.387   385.523     0.150
    31.495   449.836     0.150
    31.495   791.336     0.150
    34.193   406.836     0.150
    37.207   430.734     0.150
    38.206   440.539     0.150
    39.163   447.836     0.150
    39.791   453.031     0.150
    40.431   459.836     0.150
    40.431   459.234     0.150
    40.999   463.031     0.150
    41.673   468.531     0.150
    42.615   476.633     0.150
    42.753   478.031     0.150
    43.386   481.633     0.150
    43.386   481.555     0.150
    44.829   494.586     0.150
    44.829   494.633     0.150
    45.549     8.398     0.150
    46.101   504.531     0.150
    46.126   504.836     0.150
    46.960   511.234     0.150
    47.168   512.836     0.150
    61.214   615.234     0.150
    61.897     6.695     0.150
    64.006   635.531     0.150
    64.006   775.430     0.150
    64.006   867.031     0.150
    64.006  1153.234     0.150
    68.386   664.836     0.150
    68.483   658.031     0.150
    70.186   675.734     0.150
    70.959     3.000     0.150
    74.447   695.930     0.150
    75.840   704.633     0.150
    75.840   706.125     0.150
    79.608   723.680     0.150
    82.410   747.000     0.150
    82.716   748.602     0.150
    89.276   777.133     0.150
   126.731  1145.547     0.150
     0.479    16.984     0.150
     0.721    12.398     0.150
     0.922    16.969     0.150
     1.414    26.047     0.150
     1.542    28.711     0.150
     1.837    30.977     0.150
     2.941    46.188     0.150
     2.941    46.188     0.150
     3.028    49.094     0.150
     3.337    52.484     0.150
     3.660    57.094     0.150
     3.760    56.484     0.150
     3.775   102.828     0.150
     3.770    58.984     0.150
     3.770    59.086     0.150
     3.800    58.836     0.150
     3.800    58.789     0.150
     3.800    59.336     0.150
     3.926    61.500     0.150
     4.009    60.422     0.150
     4.320    65.984     0.150
     4.398    69.086     0.150
     4.398    67.844     0.150
     4.373    67.328     0.150
     4.680    70.336     0.150
     4.699    68.195     0.150
     4.645    71.891     0.150
     4.645    70.984     0.150
     4.802    70.984     0.150
    48.359    72.586     0.150
     5.033    76.188     0.150
     5.033    76.188     0.150
     5.189   138.383     0.150
     5.352    80.195     0.150
     5.438    80.016     0.150
     5.438    80.016     0.150
     5.438    80.094     0.150
     5.674    83.641     0.150
     5.809    89.289     0.150
     5.892    88.109     0.150
     6.030    89.406     0.150
     6.030   155.875     0.150
     6.080    89.680     0.150
     6.080   158.328     0.150
     6.080    89.766     0.150
     6.044    88.891     0.150
     6.196    92.789     0.150
     6.255   163.547     0.150
     6.330    98.086     0.150
     6.447    95.508     0.150
     6.447   167.266     0.150
     6.469    95.891     0.150
     6.469   130.289     0.150
     6.469   165.891     0.150
     6.469   193.789     0.150
     6.469    95.969     0.150
     6.501    96.141     0.150
     6.501   169.242     0.150
     6.501    96.195     0.150
     6.515    96.859     0.150
     6.515   168.938     0.150
     6.561    96.789     0.150
     6.561   135.789     0.150
     6.561   166.484     0.150
     6.561   235.789     0.150
     6.746    98.656     0.150
     6.746   173.234     0.150
     6.755    98.789     0.150
     6.816   101.242     0.150
     6.914   211.984     0.150
     6.935   169.586     0.150
     6.926   102.688     0.150
     7.002   102.992     0.150
     7.002   179.188     0.150
     6.997   101.289     0.150
     6.997   178.688     0.150
     7.058   101.750     0.150
     7.058   101.750     0.150
     7.058   179.164     0.150
     7.063   102.586     0.150
     7.179   104.773     0.150
     7.179   183.406     0.150
     7.183   105.086     0.150
     7.233   104.789     0.150
     7.233   184.188     0.150
     7.303   107.188     0.150
     7.303   186.688     0.150
     7.311   183.625     0.150
     7.352   105.586     0.150
     7.352   105.789     0.150
     7.352   105.703     0.150
     7.352   186.383     0.150
     7.405   109.039     0.150
     7.405   188.734     0.150
     7.441   107.680     0.150
     7.441   187.758     0.150
     7.440   106.359     0.150
     7.440   186.445     0.150
     7.451   107.344     0.150
     7.451   187.586     0.150
     7.416   110.398     0.150
     7.476   108.688     0.150
     7.500   108.742     0.150
     7.515   108.156     0.150
     7.515   188.125     0.150
     7.510   111.891     0.150
     7.576   109.031     0.150
     7.576   111.258     0.150
     7.748   112.461     0.150
     7.752   115.688     0.150
     7.752   194.984     0.150
     7.823   116.188     0.150
     7.893   241.984     0.150
     7.961   114.086     0.150
     7.961   114.383     0.150
     7.953   116.891     0.150
     7.996   113.688     0.150
     7.996   115.578     0.150
     8.005   116.984     0.150
     8.005   202.086     0.150
     8.005   235.586     0.150
     8.145   115.711     0.150
     8.159   117.391     0.150
     8.159   117.219     0.150
     8.165   117.984     0.150
     8.165   119.203     0.150
     8.164   120.484     0.150
     8.244   150.586     0.150
     8.244   119.391     0.150
     8.255   116.789     0.150
     8.255   118.461     0.150
     8.255   120.320     0.150
     8.234   121.586     0.150
     8.234   121.648     0.150
     8.331   121.742     0.150
     8.331   121.797     0.150
     8.353   121.789     0.150
     8.353   210.391     0.150
     8.373   119.070     0.150
     8.383   119.484     0.150
     8.464   124.688     0.150
     8.464   175.586     0.150
     8.493   125.234     0.150
     8.484   125.086     0.150
     8.484   126.594     0.150
     8.480   120.727     0.150
     8.480   120.688     0.150
     8.581   127.195     0.150
     8.581   126.000     0.150
     8.676   127.797     0.150
     8.714   125.484     0.150
     8.740   126.516     0.150
     8.777   128.289     0.150
     8.814   131.586     0.150
     8.851   127.633     0.150
     8.840   129.891     0.150
     8.840   130.164     0.150
     8.936   129.289     0.150
     9.064   174.164     0.150
     9.064   241.656     0.150
     9.064   299.500     0.150
     9.064   130.109     0.150
     9.064   129.844     0.150
     9.068   132.711     0.150
     9.066   130.289     0.150
     9.091   128.297     0.150
     9.120   133.688     0.150
     9.242   169.586     0.150
     9.300   170.484     0.150
     9.375   134.344     0.150
     9.416   172.586     0.150
     9.416   288.289     0.150
     9.434   174.086     0.150
     9.430   136.891     0.150
     9.491   136.180     0.150
     9.517   135.938     0.150
     9.486   137.984     0.150
     9.486   137.984     0.150
     9.486   138.078     0.150
     9.534   174.188     0.150
     9.534   291.688     0.150
     9.538   137.891     0.150
     9.561   232.188     0.150
     9.561   137.086     0.150
     9.561   136.453     0.150
     9.561   136.320     0.150
     9.535   138.586     0.150
     9.588   138.125     0.150
     9.599   174.484     0.150
     9.607   175.688     0.150
     9.612   137.586     0.150
     9.641   176.188     0.150
     9.682   139.078     0.150
     9.685   141.289     0.150
     9.685   141.250     0.150
     9.821   179.484     0.150
     9.821   239.891     0.150
     9.903   140.914     0.150
     9.903   140.984     0.150
     9.903   142.734     0.150
     9.968   144.086     0.150
    10.121   185.188     0.150
    10.121   246.688     0.150
    10.232   147.125     0.150
    10.260   187.086     0.150
    10.236   147.391     0.150
    10.273   147.484     0.150
    10.224   143.289     0.150
    10.224   251.578     0.150
    10.224   145.828     0.150
    10.261   144.359     0.150
    10.261   144.391     0.150
    10.360   148.336     0.150
    10.689   154.484     0.150
    10.788   159.586     0.150
    10.788   198.789     0.150
    10.788   265.586     0.150
    10.807   158.484     0.150
    10.833   264.430     0.150
    10.905   268.805     0.150
    11.057   202.984     0.150
    11.057   339.586     0.150
    11.214   290.188     0.150
    11.214   160.188     0.150
    11.214   290.188     0.150
    11.247   292.188     0.150
    11.247   160.891     0.150
    11.247   292.188     0.150
    11.446   168.391     0.150
    11.446   211.086     0.150
    11.524   163.875     0.150
    11.759   172.586     0.150
    11.759   170.930     0.150
    11.753   164.086     0.150
    11.753   164.086     0.150
    13.297   184.859     0.150
    13.297   184.891     0.150
    13.309   184.266     0.150
    13.395   186.898     0.150
    13.395   194.688     0.150
    13.395   186.891     0.150
    13.734   190.227     0.150
    13.734   190.188     0.150
    13.861   337.086     0.150
    14.401   200.805     0.150
    14.401   200.445     0.150
    14.932   206.516     0.150
    15.320   211.836     0.150
    15.320   211.836     0.150
    15.320   226.461     0.150
    15.320   379.250     0.150
    15.320   393.141     0.150
    15.320   405.797     0.150
    15.320   211.789     0.150
    15.320   379.188     0.150
    16.022   219.016     0.150
    16.132   230.375     0.150
    17.002   240.188     0.150
    17.940   249.086     0.150
    17.940   251.000     0.150
    18.134   250.086     0.150
    18.140   252.086     0.150
    18.140   455.289     0.150
    18.554   256.688     0.150
    18.554   465.391     0.150
    18.648   258.289     0.150
    18.648   467.984     0.150
    19.361   264.984     0.150
    19.493   264.289     0.150
    19.493   472.289     0.150
    20.283   488.086     0.150
    20.337   497.289     0.150
    20.476   281.086     0.150
    20.476   279.648     0.150
    20.529   276.984     0.150
    20.685   272.484     0.150
    22.584   302.250     0.150
    24.133   317.625     0.150
    24.388   318.641     0.150
    25.985   322.984     0.150
    27.946   354.156     0.150
    28.222   355.391     0.150
    28.320   815.266     0.150
    28.320   350.984     0.150
    29.393   367.758     0.150
    31.380   379.688     0.150
    31.511   438.891     0.150
    31.511   687.391     0.150
    31.511   381.000     0.150
    32.703   704.688     0.150
    37.689   436.086     0.150
    38.015   436.086     0.150
    38.015   438.758     0.150
    38.015   438.758     0.150
    38.015   784.039     0.150
    38.220   442.344     0.150
    39.232   451.391     0.150
    39.219   449.047     0.150
    39.810   451.789     0.150
    40.441   458.086     0.150
    40.495   459.656     0.150
    41.681   467.391     0.150
    42.281   473.688     0.150
    42.434   478.688     0.150
    42.620   474.984     0.150
    42.864   475.688     0.150
    43.361   484.281     0.150
    43.361   484.281     0.150
    43.361   484.445     0.150
    43.713   482.070     0.150
    43.713   487.180     0.150
    44.203   489.289     0.150
    44.796   493.586     0.150
    44.938   494.984     0.150
    45.558     4.500     0.150
    45.884   502.484     0.150
    45.946   503.188     0.150
    46.131   507.289     0.150
    46.292   505.984     0.150
    46.592   504.555     0.150
    46.874   510.391     0.150
    46.972   507.688     0.150
    47.180   510.195     0.150
    47.180   509.586     0.150
    48.605   523.688     0.150
    52.802   554.859     0.150
    61.221   617.297     0.150
    68.217   661.984     0.150
    68.497     7.203     0.150
    69.256     4.500     0.150
    69.256     5.797     0.150
    72.490   691.359     0.150
    72.492   689.047     0.150
    72.769   693.047     0.150
    72.770   689.125     0.150
    72.878   692.797     0.150
    73.992   699.977     0.150
    74.954   700.508     0.150
    75.005   706.812     0.150
    75.282   708.555     0.150
    75.574   709.367     0.150
    75.681   709.867     0.150
    75.852   706.328     0.150
    75.852   704.789     0.150
    75.852   708.180     0.150
    75.848   711.672     0.150
    78.624     7.102     0.150
    79.620   730.156     0.150
    80.720   735.602     0.150
    82.425   746.078     0.150
    82.513   745.539     0.150
    87.103   764.289     0.150
    90.869   784.086     0.150
    90.869   786.000     0.150
     0.831    15.125     0.150
     3.313    52.227     0.150
     5.384    80.727     0.150
     5.430    82.266     0.150
     0.660    11.133     0.150
     0.740    12.797     0.150
     0.829    14.422     0.150
     1.071    20.547     0.150
     1.206    23.562     0.150
     1.641    27.148     0.150
     2.925    46.469     0.150
     2.925    82.266     0.150
     3.016    48.398     0.150
     3.238    51.164     0.150
     3.319    52.266     0.150
     3.319    93.758     0.150
     3.319    52.266     0.150
     3.684    55.867     0.150
     3.652    57.172     0.150
     3.766    56.562     0.150
     3.751    58.469     0.150
     3.751    58.367     0.150
     3.751    58.555     0.150
     3.780   104.609     0.150
     3.780    58.766     0.150
     4.035    63.969     0.150
     4.249    65.789     0.150
     4.301    65.664     0.150
     4.418    68.023     0.150
     4.625    71.062     0.150
     4.776    71.195     0.150
     4.814    71.062     0.150
     4.825   124.164     0.150
    48.362    73.812     0.150
     5.013    75.664     0.150
     5.199   137.477     0.150
     5.440    80.039     0.150
     5.440    80.125     0.150
     5.902    89.227     0.150
     5.975    87.477     0.150
     6.024    89.062     0.150
     6.184    92.664     0.150
     6.465    94.766     0.150
     6.465   167.266     0.150
     6.465   188.367     0.150
     6.560    97.766     0.150
     6.560   165.469     0.150
     6.560   101.938     0.150
     6.630   102.445     0.150
     6.773    98.367     0.150
     6.925   102.164     0.150
     7.001   100.766     0.150
     7.001   176.766     0.150
     7.057   104.367     0.150
     7.238   107.008     0.150
     7.229   104.867     0.150
     7.229   182.367     0.150
     7.229   104.906     0.150
     7.357   105.664     0.150
     7.478   107.766     0.150
     7.499   112.062     0.150
     7.499   112.078     0.150
     7.577   112.164     0.150
     7.746   114.867     0.150
     7.746   196.766     0.150
     7.868   116.977     0.150
     7.921   119.875     0.150
     7.975   113.867     0.150
     8.008   114.367     0.150
     8.086   115.664     0.150
     8.086   118.117     0.150
     8.163   116.367     0.150
     8.164   120.367     0.150
     8.248   119.062     0.150
     8.252   118.062     0.150
     8.218   121.062     0.150
     8.218   122.227     0.150
     8.264   118.367     0.150
     8.354   126.164     0.150
     8.397   119.562     0.150
     8.397   119.664     0.150
     8.457   124.266     0.150
     8.457   162.469     0.150
     8.473   126.172     0.150
     8.461   122.164     0.150
     8.461   122.062     0.150
     8.582   126.273     0.150
     8.703   129.625     0.150
     8.716   127.172     0.150
     8.807   131.867     0.150
     8.807   132.492     0.150
     8.824   129.766     0.150
     8.824   131.047     0.150
     9.068   140.422     0.150
     9.068   300.445     0.150
     9.069   132.156     0.150
     9.063   131.062     0.150
     9.362   137.367     0.150
     9.414   137.469     0.150
     9.471   138.164     0.150
     9.471   138.633     0.150
     9.567   236.266     0.150
     9.567   136.766     0.150
     9.567   136.711     0.150
     9.567   136.945     0.150
     9.518   136.664     0.150
     9.598   142.125     0.150
     9.671   142.477     0.150
     9.917   142.266     0.150
     9.951   143.562     0.150
    10.139   141.562     0.150
    10.205   146.969     0.150
    10.292   143.664     0.150
    10.682   266.086     0.150
    10.822   161.469     0.150
    10.847   156.188     0.150
    10.857   159.172     0.150
    10.920   270.109     0.150
    11.733   167.562     0.150
    12.536   174.664     0.150
    12.706   179.844     0.150
    12.706   179.867     0.150
    12.825   177.062     0.150
    13.286   188.367     0.150
    13.391   189.664     0.150
    13.715   195.164     0.150
    14.147   197.664     0.150
    15.313   212.289     0.150
    15.313   212.289     0.150
    15.313   228.086     0.150
    15.313   395.523     0.150
    15.313   408.172     0.150
    15.313   212.266     0.150
    15.313   381.562     0.150
    17.635   241.867     0.150
    17.954   249.766     0.150
    18.938   263.055     0.150
    19.366   262.188     0.150
    20.265   490.242     0.150
    20.328   299.969     0.150
    20.458   281.625     0.150
    20.534   276.203     0.150
    20.534   276.164     0.150
    21.219   285.766     0.150
    22.565   299.766     0.150
    31.499   383.664     0.150
    31.499   695.164     0.150
    31.499   800.164     0.150
    32.691   395.367     0.150
    36.467   422.766     0.150
    39.821   452.766     0.150
    40.424   458.664     0.150
    40.424   457.766     0.150
    40.424   458.969     0.150
    43.379   481.969     0.150
    43.666   587.367     0.150
    46.579   510.664     0.150
    46.957   509.766     0.150
    47.165   513.969     0.150
    61.894   623.562     0.150
    63.861   630.562     0.150
    68.361   910.766     0.150
    68.483     3.797     0.150
    68.483     6.297     0.150
     4.821   124.945     0.150
     5.241   134.742     0.150
     5.990    91.695     0.150
     6.133    96.781     0.150
     6.368    96.898     0.150
     0.199     7.227     0.150
     1.039    20.953     0.150
     1.197    24.086     0.150
     4.671    71.469     0.150
     4.867    77.852     0.150
     5.187   133.078     0.150
     5.427   137.711     0.150
     6.927   104.469     0.150
     6.948   105.766     0.150
     7.150   108.664     0.150
     7.345   108.562     0.150
     9.653   142.664     0.150
     0.655    11.511     0.150
     0.710    12.181     0.150
     1.121    20.471     0.150
     1.170    21.361     0.150
     2.729    45.481     0.150
     3.244    52.481     0.150
     3.756    60.081     0.150
     4.029    64.981     0.150
     5.149   132.990     0.150
     5.393    77.887     0.150
     5.935    85.803     0.150
     5.940    85.771     0.150
     5.985    86.125     0.150
     6.084    87.544     0.150
     6.319    90.957     0.150
     6.466    92.805     0.150
     7.189   107.181     0.150
     7.189   187.081     0.150
     7.189  1980.681     0.150
     7.869   114.481     0.150
    12.848   186.881     0.150
     0.676    10.727     0.150
     0.676    18.375     0.150
     0.820    15.289     0.150
     0.855    16.820     0.150
     1.142    21.430     0.150
     3.767    58.227     0.150
     3.917    60.258     0.150
     4.040   111.664     0.150
     4.664    68.945     0.150
     4.768    71.906     0.150
     4.858    75.727     0.150
     5.176   131.883     0.150
     5.338    85.406     0.150
     5.967    91.281     0.150
     6.491   101.305     0.150
     6.931   171.570     0.150
     7.887   194.570     0.150
     9.238   129.664     0.150
     9.592   142.367     0.150
     9.802   145.664     0.150
     0.859    15.820     0.150
     0.923    30.633     0.150
     1.007    19.289     0.150
     1.052    18.250     0.150
     1.424    25.586     0.150
     1.432    26.469     0.150
     3.286    50.492     0.150
     4.519    70.445     0.150
     4.519   120.812     0.150
     4.678    69.289     0.150
     4.843   123.641     0.150
     4.873    75.695     0.150
     5.968    85.594     0.150
     6.126   155.375     0.150
     6.361    91.406     0.150
     6.573   100.992     0.150
     6.573   169.688     0.150
     6.926   105.391     0.150
     6.947   105.789     0.150
     7.146   108.586     0.150
     7.232   185.086     0.150
     7.618   112.891     0.150
     7.618   188.492     0.150
     8.157   198.789     0.150
     8.824   215.008     0.150
     9.833   145.891     0.150
    10.213   257.328     0.150
    10.272   256.688     0.150
     0.334    14.297     0.150
     0.820    15.125     0.150
     1.030    20.477     0.150
     1.088    20.914     0.150
     1.548    28.996     0.150
     3.363    56.977     0.150
     3.363    56.375     0.150
     4.356    72.074     0.150
     4.669    70.875     0.150
     4.893    69.875     0.150
     5.182   131.871     0.150
     5.959   152.367     0.150
     9.299   138.277     0.150
     0.134     3.457     0.150
     0.157     3.082     0.150
     0.157     5.713     0.150
     0.237     9.203     0.150
     0.351     6.123     0.150
     0.620    11.184     0.150
     0.821    16.623     0.150
     0.818    16.582     0.150
     0.927    18.422     0.150
     0.945    19.402     0.150
     1.022    18.992     0.150
     1.055    19.543     0.150
     1.079    20.354     0.150
     1.147    21.322     0.150
     1.175    21.662     0.150
     1.219    22.793     0.150
     1.324    25.434     0.150
     1.378    25.162     0.150
    21.554   290.832     0.150
    47.638   521.707     0.150
     0.146     6.250     0.150
     0.122     3.459     0.150
     0.932    17.330     0.150
     1.009    19.449     0.150
     1.041    19.990     0.150
     1.070    20.500     0.150
     1.136    21.730     0.150
     1.162    21.070     0.150
     1.367    24.900     0.150
     1.430    26.430     0.150
     1.492    28.119     0.150
     1.708    31.721     0.150
     2.173    38.561     0.150
     5.453   137.188     0.150
     6.219    93.111     0.150
     6.591   101.053     0.150
    47.648   519.613     0.150
     0.125     3.430     0.150
     0.302     6.070     0.150
     0.340    15.078     0.150
     0.473    22.930     0.150
     0.533    26.070     0.150
     0.585    24.730     0.150
     0.604    13.539     0.150
     0.615    26.867     0.150
     0.629    26.379     0.150
     0.693    27.957     0.150
     0.696    15.898     0.150
     0.767    17.738     0.150
     0.767    32.969     0.150
     0.790    17.391     0.150
     0.790    31.629     0.150
     0.793    31.539     0.150
     0.875    36.090     0.150
     0.943    20.320     0.150
     0.943    36.750     0.150
     0.986    20.707     0.150
     0.986    41.070     0.150
     3.654    56.137     0.150
     4.256    67.680     0.150
     5.219   137.879     0.150
     5.612    99.480     0.150
     5.921    90.988     0.150
     6.675   171.406     0.150
     8.125   117.195     0.150
     8.392   125.277     0.150
     8.392   219.578     0.150
     8.418   120.855     0.150
     8.935   237.277     0.150
    14.475   208.680     0.150
     0.089     5.055     0.150
     0.095     2.684     0.150
     0.359    11.955     0.150
     0.479     8.514     0.150
     0.470     8.555     0.150
     0.521     9.975     0.150
     0.529    10.205     0.150
     0.645    11.314     0.150
     3.448    56.518     0.150
     5.634    82.828     0.150
     6.987   100.916     0.150
     9.518   245.279     0.150
     0.156     4.906     0.150
     0.253     6.437     0.150
     0.306    11.886     0.150
     0.384    13.536     0.150
     0.749    14.576     0.150
     1.010    17.696     0.150
     1.517    25.376     0.150
     2.557    40.386     0.150
     2.791    42.886     0.150
     3.204    50.466     0.150
     3.204    50.586     0.150
     3.211    52.486     0.150
     3.935    59.626     0.150
     4.756    71.286     0.150
     5.435    79.596     0.150
     5.467    80.496     0.150
     7.703   192.562     0.150
     9.639   285.786     0.150
    30.960   381.252     0.150
     0.417    14.067     0.150
     0.600    11.337     0.150
    95.697    10.967     0.150
     1.109    20.567     0.150
     1.368    26.317     0.150
     1.368    26.367     0.150
     1.499    28.507     0.150
     1.539    28.547     0.150
     1.575    29.677     0.150
     1.895    34.377     0.150
     2.084    33.617     0.150
     2.698    44.087     0.150
     3.464    93.867     0.150
     3.574    55.267     0.150
     3.574    56.537     0.150
     3.959   109.657     0.150
     4.149    63.967     0.150
     4.143    64.717     0.150
     4.198   106.167     0.150
     4.198   114.146     0.150
     4.198    63.867     0.150
     4.354    68.667     0.150
     5.594   145.587     0.150
     5.878    89.547     0.150
     5.906    88.867     0.150
    21.255   289.062     0.150
    95.851    12.398     0.150
    95.851    23.148     0.150
     0.760    13.227     0.150
     0.816    15.633     0.150
     3.357    52.852     0.150
     3.929    74.953     0.150
     4.316    69.328     0.150
     4.678    70.703     0.150
     4.953    77.172     0.150
     5.020    76.656     0.150
     5.063    78.852     0.150
     5.946    89.648     0.150
     6.035    91.172     0.150
     6.223    94.766     0.150
     6.282    94.859     0.150
     6.688    98.258     0.150
     6.701    98.719     0.150
     6.762   106.242     0.150
     7.311   108.750     0.150
     8.411   125.062     0.150
     8.431   123.297     0.150
     9.815   242.250     0.150
     9.815   320.250     0.150
    14.451   207.523     0.150
     0.109     5.977     0.150
     0.605    11.266     0.150
     0.719    12.375     0.150
     0.811    14.812     0.150
     0.823    15.383     0.150
     0.992    19.344     0.150
     1.037    20.430     0.150
     1.071    20.547     0.150
     1.239    22.688     0.150
     1.277    23.484     0.150
     1.313    24.273     0.150
     4.581   125.266     0.150
     8.223   202.008     0.150
     0.315     6.070     0.150
     0.380     6.984     0.150
     0.494     8.914     0.150
     0.557     9.797     0.150
     0.737    16.164     0.150
     0.830    16.070     0.150
     0.875    18.367     0.150
     0.916    18.445     0.150
     0.917    18.461     0.150
     0.999    19.727     0.150
     1.015    20.203     0.150
     1.038    19.875     0.150
     4.221   114.578     0.150
     4.758    69.867     0.150
     5.881    85.781     0.150
     5.898    85.625     0.150
     7.392   189.812     0.150
     0.632    11.188     0.150
     0.678    11.984     0.150
    95.686    14.586     0.150
     1.179    19.625     0.150
     1.179    19.984     0.150
     2.083    35.984     0.150
     2.667    42.953     0.150
     3.494    55.047     0.150
     3.494    55.086     0.150
     3.830    59.773     0.150
     3.907    60.188     0.150
     4.103    61.086     0.150
     4.180    67.727     0.150
     4.273    66.906     0.150
     4.318   118.086     0.150
     4.350    66.625     0.150
     4.414    67.555     0.150
     4.799    73.172     0.150
     4.904    72.484     0.150
     4.975    76.523     0.150
     5.321   140.703     0.150
     5.899    85.633     0.150
     6.090    89.820     0.150
     6.090   157.742     0.150
     6.121    90.984     0.150
     6.171    90.586     0.150
     6.224   159.609     0.150
     6.267   163.984     0.150
     6.401    93.164     0.150
     6.463    94.883     0.150
     6.590    97.250     0.150
     6.675    97.992     0.150
     6.675   170.742     0.150
     6.746    98.891     0.150
     6.759    99.508     0.150
     6.759   170.531     0.150
     6.765   100.086     0.150
     6.962   105.656     0.150
     6.962   178.781     0.150
     6.962   105.062     0.150
     6.962   178.812     0.150
     7.125   104.586     0.150
     7.125   104.547     0.150
     7.125   180.297     0.150
     7.166   104.484     0.150
     7.166   178.984     0.150
     7.274   105.688     0.150
     7.513   107.781     0.150
     7.513   188.484     0.150
     7.587   108.312     0.150
     7.658   111.086     0.150
     7.658   191.781     0.150
     7.963   117.688     0.150
     7.963   201.211     0.150
     8.044   115.086     0.150
     8.096   116.484     0.150
     8.213   119.688     0.150
     8.212   119.188     0.150
     8.332   120.086     0.150
     8.332   207.586     0.150
     8.389   119.984     0.150
     8.449   120.375     0.150
     8.449   120.383     0.150
     8.531   124.086     0.150
     8.531   214.281     0.150
     8.702   129.086     0.150
     8.702   129.211     0.150
     8.768   218.688     0.150
     8.768   126.086     0.150
     8.768   218.688     0.150
     8.982   128.984     0.150
     8.982   223.688     0.150
     9.027   132.781     0.150
     9.254   134.984     0.150
     9.272   136.984     0.150
     9.359   239.883     0.150
     9.651   242.688     0.150
    69.388   139.031     0.150
     9.721   138.984     0.150
     9.721   242.984     0.150
     9.721   305.984     0.150
     9.721   139.078     0.150
     9.750   143.781     0.150
     9.816   249.383     0.150
     9.980   142.688     0.150
    10.107   257.281     0.150
    10.433   149.484     0.150
    10.705   272.086     0.150
   103.029   155.188     0.150
    10.877   270.688     0.150
    12.786   182.781     0.150
    13.507   191.445     0.150
    13.507   191.984     0.150
    13.601   191.688     0.150
    14.117   199.477     0.150
    14.610   205.945     0.150
    14.610   207.281     0.150
    15.137   213.781     0.150
    15.531   215.555     0.150
    15.531   232.578     0.150
    15.531   215.484     0.150
    15.531   388.688     0.150
    15.993   232.852     0.150
    16.920   423.797     0.150
    18.319   247.273     0.150
    18.006   248.484     0.150
    18.014   249.383     0.150
    18.568   454.500     0.150
    20.300   484.781     0.150
    20.320   276.484     0.150
    20.982   281.781     0.150
    21.934   292.008     0.150
    22.722   302.883     0.150
    28.510   546.477     0.150
    28.510   354.586     0.150
    31.614   381.281     0.150
    38.932   445.586     0.150
    40.616   459.688     0.150
    83.937   462.961     0.150
    41.563   467.703     0.150
    42.053   471.992     0.150
    42.765   477.781     0.150
    42.934   478.086     0.150
    43.538   484.688     0.150
    44.591   492.586     0.150
    45.586     4.703     0.150
    45.578   500.281     0.150
    45.783   500.586     0.150
    46.160   504.586     0.150
    46.290   506.188     0.150
    46.280   505.531     0.150
    46.723   508.281     0.150
    47.164   511.586     0.150
    52.034     8.000     0.150
    61.692   617.883     0.150
    63.927   631.938     0.150
    68.520   660.984     0.150
    69.858   669.688     0.150
    70.196   672.883     0.150
    70.600   674.602     0.150
    36.119   676.562     0.150
    19.460   686.508     0.150
    72.827   688.656     0.150
    72.827   689.383     0.150
    73.771   694.055     0.150
    74.673     3.797     0.150
    80.453   731.484     0.150
    80.794   733.688     0.150
    82.474   742.688     0.150
    83.748   749.383     0.150
    84.600   753.383     0.150
    86.605   763.484     0.150
   124.985  1140.984     0.150
     0.076     2.820     0.150
     0.076     2.920     0.150
     0.049     2.840     0.150
     0.049     2.840     0.150
     0.049     2.840     0.150
     0.094     3.400     0.150
     0.094     3.400     0.150
     0.094     3.400     0.150
     0.177     4.820     0.150
     0.177     4.820     0.150
     0.231     5.300     0.150
     0.231     5.350     0.150
     0.233     5.440     0.150
     0.233     5.480     0.150
     0.233     5.510     0.150
     0.240     5.740     0.150
     0.240     5.960     0.150
     0.317     7.730     0.150
     0.317     7.960     0.150
     0.345     7.690     0.150
     0.345     7.690     0.150
     0.363     7.630     0.150
     0.363     7.630     0.150
     0.363     7.630     0.150
     0.412     8.530     0.150
     0.445     9.090     0.150
     0.445     9.240     0.150
     0.445     9.240     0.150
     0.474    17.880     0.150
     0.474     9.220     0.150
     0.474     9.220     0.150
     0.474     9.220     0.150
    48.364     9.180     0.150
    48.364    17.880     0.150
    48.364     9.200     0.150
    48.364     9.200     0.150
    48.364     9.200     0.150
    48.364    17.090     0.150
     0.491     9.380     0.150
     0.491     9.380     0.150
     0.491     9.400     0.150
     0.515     9.420     0.150
     0.515     9.420     0.150
     0.515     9.450     0.150
     0.515    17.800     0.150
     0.509    10.430     0.150
     0.509    10.430     0.150
     0.551     9.170     0.150
     0.551     9.170     0.150
     0.551    10.260     0.150
     0.544    10.390     0.150
     0.544    10.390     0.150
     0.544    10.400     0.150
     0.568    10.570     0.150
     0.568    10.570     0.150
     0.580    10.400     0.150
     0.580    10.400     0.150
     0.580    10.400     0.150
     0.570    10.690     0.150
     0.570    10.690     0.150
     0.605    11.780     0.150
     0.605    11.780     0.150
     0.625    11.560     0.150
     0.625    11.560     0.150
     0.664    11.640     0.150
     0.664    11.820     0.150
     0.664    12.261     0.150
     0.664    20.265     0.150
     0.671    12.040     0.150
     0.671    12.040     0.150
     0.671    12.040     0.150
     0.667    22.980     0.150
     0.667    12.420     0.150
     0.667    12.420     0.150
     0.667    12.420     0.150
     0.737    13.040     0.150
     0.737    13.260     0.150
     0.737    13.260     0.150
     0.706    13.590     0.150
     0.706    13.590     0.150
     0.706    13.590     0.150
     0.772    24.680     0.150
     0.784    14.540     0.150
     0.784    14.540     0.150
     0.793    14.200     0.150
     0.793    14.200     0.150
     0.793    26.570     0.150
     0.793    26.570     0.150
     0.789    14.560     0.150
     0.789    14.560     0.150
     0.789    14.560     0.150
     0.808    14.380     0.150
     0.809    16.810     0.150
     0.809    16.810     0.150
     0.809    16.810     0.150
     0.826    14.910     0.150
     0.826    17.030     0.150
     0.826    17.030     0.150
     0.826    17.030     0.150
     0.855    15.290     0.150
     0.855    15.350     0.150
     0.855    15.350     0.150
     0.866    15.130     0.150
     0.866    15.130     0.150
     0.866    15.170     0.150
     0.848    15.620     0.150
     0.848    15.620     0.150
     0.848    15.620     0.150
     0.899    15.750     0.150
     0.899    15.750     0.150
     0.899    15.750     0.150
     0.947    16.640     0.150
     0.947    16.640     0.150
     0.947    16.640     0.150
     0.939    16.700     0.150
     0.939    16.700     0.150
     0.971    21.310     0.150
     0.971    21.310     0.150
     0.971    21.310     0.150
    48.364    19.610     0.150
     0.981    16.800     0.150
     0.981    16.800     0.150
     1.000    20.610     0.150
     1.000    20.610     0.150
     1.000    20.610     0.150
     1.010    18.950     0.150
     1.010    18.950     0.150
     1.041    18.610     0.150
     1.041    18.610     0.150
     1.041    18.610     0.150
     1.048    20.730     0.150
     1.048    20.730     0.150
     1.048    20.730     0.150
     1.058    20.820     0.150
     1.058    20.820     0.150
     1.058    21.150     0.150
     1.058    21.150     0.150
     1.058    21.150     0.150
     1.070    18.740     0.150
     1.070    18.740     0.150
     1.107    19.150     0.150
     1.107    19.150     0.150
     1.081    21.330     0.150
     1.081    21.330     0.150
     1.081    21.330     0.150
     1.144    23.460     0.150
     1.144    23.460     0.150
     1.144    23.460     0.150
     1.158    19.950     0.150
     1.158    19.950     0.150
     1.205    22.410     0.150
     1.205    22.410     0.150
     1.205    24.440     0.150
     1.206    20.770     0.150
     1.206    21.080     0.150
     1.170    20.530     0.150
     1.170    20.530     0.150
     1.226    20.870     0.150
     1.226    20.870     0.150
     1.186    23.690     0.150
     1.186    23.690     0.150
     1.186    23.690     0.150
     1.193    23.140     0.150
     1.193    23.140     0.150
     1.193    23.140     0.150
     1.210    21.300     0.150
     1.210    21.300     0.150
     1.210    21.300     0.150
     1.233    21.320     0.150
     1.233    21.320     0.150
     1.233    23.460     0.150
     1.233    23.460     0.150
     1.290    24.500     0.150
     1.290    24.500     0.150
     1.290    24.500     0.150
     1.263    21.550     0.150
     1.263    21.740     0.150
     1.263    21.740     0.150
     1.263    21.740     0.150
     1.306    23.640     0.150
     1.306    23.640     0.150
     1.310    24.830     0.150
     1.310    24.830     0.150
     1.321    24.280     0.150
     1.321    24.280     0.150
     1.371    23.140     0.150
     1.371    23.140     0.150
     1.348    25.150     0.150
     1.348    25.150     0.150
     1.348    25.150     0.150
     1.388    23.540     0.150
     1.388    23.540     0.150
     1.388    23.540     0.150
     1.408    27.560     0.150
     1.408    27.560     0.150
     1.408    27.560     0.150
     1.378    24.330     0.150
     1.378    24.330     0.150
     1.408    23.820     0.150
     1.408    23.820     0.150
     1.427    26.160     0.150
     1.427    26.160     0.150
     1.461    25.780     0.150
     1.461    25.780     0.150
     1.497    26.070     0.150
     1.497    26.070     0.150
     1.497    26.070     0.150
     1.549    29.740     0.150
     1.549    29.740     0.150
     1.549    29.740     0.150
     1.556    29.220     0.150
     1.556    29.220     0.150
     1.556    29.220     0.150
     1.562    26.520     0.150
     1.562    26.520     0.150
     1.562    26.520     0.150
     1.558    28.270     0.150
     1.558    28.270     0.150
     1.545    27.880     0.150
     1.545    27.880     0.150
     1.545    27.880     0.150
     1.550    27.750     0.150
     1.550    27.750     0.150
     1.550    27.750     0.150
     1.593    28.560     0.150
     1.593    28.560     0.150
    48.364    27.770     0.150
     1.589    27.690     0.150
     1.589    27.690     0.150
     1.589    27.690     0.150
     1.602    28.240     0.150
     1.602    28.240     0.150
     1.602    28.260     0.150
     1.602    49.820     0.150
     1.602    49.820     0.150
     1.639    27.880     0.150
     1.639    27.880     0.150
     1.639    53.660     0.150
     1.639    53.660     0.150
     1.639    53.660     0.150
     1.645    28.020     0.150
     1.667    30.730     0.150
     1.667    30.730     0.150
     1.673    30.910     0.150
     1.673    30.910     0.150
     1.661    28.820     0.150
     1.661    28.820     0.150
     1.661    28.840     0.150
     1.679    29.300     0.150
     1.679    29.300     0.150
     1.679    29.300     0.150
     1.728    31.960     0.150
     1.728    31.960     0.150
     1.699    29.790     0.150
     1.699    29.790     0.150
     1.699    29.790     0.150
     1.707    29.820     0.150
     1.707    29.820     0.150
     1.707    29.820     0.150
     1.760    31.900     0.150
     1.760    31.900     0.150
     1.784    30.270     0.150
     1.784    30.270     0.150
     1.798    32.320     0.150
     1.798    32.320     0.150
     1.768    30.890     0.150
     1.768    30.890     0.150
     1.791    31.520     0.150
     1.791    31.520     0.150
     1.812    30.460     0.150
     1.812    30.460     0.150
     1.822    31.520     0.150
     1.822    31.430     0.150
     1.822    31.430     0.150
     1.822    31.430     0.150
     1.866    31.560     0.150
     1.866    33.320     0.150
     1.866    33.320     0.150
     1.866    33.920     0.150
     1.866    33.920     0.150
     1.866    33.920     0.150
     1.899    32.840     0.150
     1.899    32.840     0.150
     1.899    59.730     0.150
     1.899    59.730     0.150
     1.884    32.380     0.150
     1.884    32.460     0.150
     1.884    32.460     0.150
     1.884    32.460     0.150
     1.869    31.990     0.150
     1.869    31.990     0.150
     1.959    35.030     0.150
     1.959    35.030     0.150
     1.976    34.270     0.150
     1.976    34.270     0.150
     1.958    32.990     0.150
     1.958    32.990     0.150
     1.958    59.330     0.150
     1.958    59.330     0.150
     1.970    33.980     0.150
     1.970    33.980     0.150
     2.033    36.280     0.150
     2.033    36.280     0.150
     2.130    37.500     0.150
     2.130    37.500     0.150
     2.134    36.840     0.150
     2.134    36.840     0.150
     2.117    36.570     0.150
     2.130    37.200     0.150
     2.130    37.200     0.150
     2.189    37.200     0.150
     2.189    37.200     0.150
     2.134    37.150     0.150
     2.134    37.150     0.150
     2.222    37.830     0.150
     2.222    37.830     0.150
     2.222    37.830     0.150
     2.217    37.310     0.150
     2.217    37.310     0.150
     2.235    38.300     0.150
     2.235    38.300     0.150
     2.245    37.320     0.150
     2.245    37.320     0.150
     2.245    37.320     0.150
     2.242    39.240     0.150
     2.242    39.240     0.150
     2.251    38.220     0.150
     2.251    38.220     0.150
     2.309    38.860     0.150
     2.309    38.860     0.150
     2.307    39.230     0.150
     2.307    39.230     0.150
     2.307    39.230     0.150
     2.349    38.420     0.150
     2.349    38.420     0.150
     2.294    38.720     0.150
     2.294    38.720     0.150
     2.374    39.920     0.150
     2.374    39.920     0.150
     2.387    41.350     0.150
     2.387    41.350     0.150
     2.420    40.790     0.150
     2.420    40.790     0.150
     2.414    41.420     0.150
     2.414    41.420     0.150
     2.433    41.980     0.150
     2.433    41.980     0.150
     2.436    42.690     0.150
     2.436    42.690     0.150
     2.449    41.230     0.150
     2.449    41.230     0.150
     2.449    41.230     0.150
     2.454    42.440     0.150
     2.443    40.380     0.150
     2.443    41.240     0.150
     2.443    41.240     0.150
     2.443    41.240     0.150
     2.553    43.150     0.150
     2.553    43.150     0.150
     2.553    43.150     0.150
     2.559    44.420     0.150
     2.559    44.420     0.150
     2.559    77.220     0.150
     2.559    77.220     0.150
     2.612    44.110     0.150
     2.612    44.110     0.150
     2.654    44.950     0.150
     2.654    44.950     0.150
    48.364    44.980     0.150
    48.364    45.880     0.150
    48.364    45.880     0.150
    48.364    45.880     0.150
     2.728    46.200     0.150
     2.728    46.200     0.150
     2.794    46.090     0.150
     2.794    46.090     0.150
    48.364    44.827     0.150
    48.364    79.234     0.150
     2.773    46.400     0.150
     2.773    46.400     0.150
     2.770    45.550     0.150
     2.770    45.550     0.150
     3.036    50.320     0.150
     3.036    50.320     0.150
     3.025    84.100     0.150
     3.025    84.100     0.150
     3.116    50.180     0.150
     3.116    50.180     0.150
     3.118    51.440     0.150
     3.118    51.440     0.150
     3.181    51.510     0.150
     3.181    51.510     0.150
     3.146    58.460     0.150
     3.146    58.460     0.150
     3.146    58.460     0.150
     3.227    52.790     0.150
     3.227    52.790     0.150
     3.246    51.420     0.150
     3.246    51.420     0.150
     3.246    51.329     0.150
     3.316    54.610     0.150
     3.316    54.610     0.150
     3.324    52.370     0.150
     3.324    52.370     0.150
     3.376    55.380     0.150
     3.376    55.380     0.150
     3.376    55.380     0.150
     3.402    56.670     0.150
     3.402    56.670     0.150
     3.371    54.030     0.150
     3.371    54.030     0.150
    48.364    54.596     0.150
     3.447    56.150     0.150
     3.447    56.150     0.150
     3.470    55.810     0.150
     3.470    55.810     0.150
     3.510    56.970     0.150
     3.510    56.970     0.150
     3.438    54.510     0.150
     3.438    54.510     0.150
     3.494    56.490     0.150
     3.494    56.490     0.150
     3.559    57.590     0.150
     3.559    57.590     0.150
     3.604    58.200     0.150
     3.604    58.200     0.150
     3.584    57.620     0.150
     3.584    57.620     0.150
     3.595    56.030     0.150
     3.595    56.030     0.150
     3.634    57.129     0.150
     3.686    58.400     0.150
     3.686    58.400     0.150
     3.686    58.400     0.150
     3.686   100.050     0.150
     3.686   100.050     0.150
     3.711    59.990     0.150
     3.711    59.990     0.150
     3.780    60.260     0.150
     3.780    60.260     0.150
     3.829    61.360     0.150
     3.829    61.360     0.150
     3.845    60.550     0.150
     3.845    60.550     0.150
    48.364    62.190     0.150
     3.857    60.683     0.150
     3.894    61.940     0.150
     3.894    61.940     0.150
     3.887    62.660     0.150
     3.887    62.660     0.150
     3.887    62.660     0.150
     3.934    62.430     0.150
     3.934    62.430     0.150
     4.019    64.120     0.150
     4.019    64.120     0.150
     3.997    62.071     0.150
     4.025    63.270     0.150
     4.025    63.270     0.150
     4.030    65.310     0.150
     4.030    65.310     0.150
     4.064    65.590     0.150
     4.064    65.590     0.150
     4.124    62.850     0.150
     4.124    62.850     0.150
     4.095    63.906     0.150
     4.169    65.520     0.150
     4.169    65.520     0.150
     4.169   113.370     0.150
     4.169   113.370     0.150
     4.166    63.900     0.150
     4.166    63.900     0.150
     4.145    66.210     0.150
     4.145    66.210     0.150
     4.184    65.244     0.150
     4.222    66.000     0.150
     4.222    66.000     0.150
    48.364    63.190     0.150
    48.364    63.190     0.150
    48.364    63.190     0.150
     4.250    66.340     0.150
     4.250    64.770     0.150
     4.250    64.770     0.150
     4.248    64.270     0.150
     4.248    64.270     0.150
     4.303    66.360     0.150
     4.303    66.360     0.150
     4.303    66.360     0.150
     4.309    65.260     0.150
     4.309    65.260     0.150
     4.330    65.430     0.150
     4.330    65.430     0.150
     4.373    66.440     0.150
     4.373    66.440     0.150
     4.373   115.340     0.150
     4.373   115.340     0.150
     4.396    68.890     0.150
     4.396    68.890     0.150
     4.358    66.230     0.150
     4.432    69.480     0.150
     4.432    66.680     0.150
     4.432    66.680     0.150
     4.414    69.160     0.150
     4.414    69.160     0.150
     4.407    70.210     0.150
     4.407    70.210     0.150
     4.530    68.490     0.150
     4.530    68.490     0.150
     4.530    68.910     0.150
     4.530    68.910     0.150
     4.530    68.910     0.150
     4.530   118.100     0.150
     4.530   118.100     0.150
     4.571    68.930     0.150
     4.571    68.930     0.150
     4.615    69.810     0.150
     4.615    69.810     0.150
     4.614    69.340     0.150
     4.614    69.340     0.150
     4.616    70.110     0.150
     4.616    70.110     0.150
     4.616   119.650     0.150
     4.616   119.650     0.150
     4.637    69.490     0.150
     4.637    69.490     0.150
     4.686    71.940     0.150
     4.694    69.100     0.150
     4.694    69.100     0.150
     4.694    69.100     0.150
     4.694   122.730     0.150
     4.694   122.730     0.150
     4.702    70.630     0.150
     4.702    70.630     0.150
     4.707    76.440     0.150
     4.707    70.570     0.150
     4.776    71.730     0.150
     4.818    76.540     0.150
     4.880    71.922     0.150
     4.882    75.764     0.150
     4.912    75.660     0.150
     5.164    80.540     0.150
     5.199   135.690     0.150
     5.348    81.476     0.150
     5.443    85.040     0.150
     5.867    85.800     0.150
     5.978    91.620     0.150
     6.036    92.790     0.150
     6.089    92.180     0.150
     6.089    89.770     0.150
     6.106   154.540     0.150
     6.188    96.190     0.150
     6.351    94.550     0.150
     6.758   104.390     0.150
     7.003   173.280     0.150
     7.065   106.780     0.150
     7.359   109.170     0.150
     7.448   111.690     0.150
     7.464   111.480     0.150
     7.481   111.040     0.150
     7.503   116.590     0.150
     7.579   196.880     0.150
     7.579   114.250     0.150
     7.926   120.890     0.150
     8.167   124.880     0.150
     8.837   132.780     0.150
     9.100   135.190     0.150
    69.509   138.240     0.150
    20.018   279.930     0.150
    20.791   287.550     0.150
    61.480   619.560     0.150
    48.364    59.323     0.150
    48.364    60.775     0.150
    48.364    57.104     0.150
    48.364    65.358     0.150
    48.364    64.304     0.150
    48.364    60.626     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.580     9.242     0.150
     0.580    18.941     0.150
     1.897    30.941     0.150
     2.932    43.941     0.150
     2.947    53.840     0.150
     2.947    85.441     0.150
     3.207    52.941     0.150
     3.207    63.441     0.150
     3.434    55.141     0.150
     3.459    54.340     0.150
     3.634    56.543     0.150
     3.743    58.941     0.150
     3.862    75.941     0.150
     3.862   111.941     0.150
     3.905    60.941     0.150
     3.905   107.742     0.150
     3.945    64.441     0.150
     4.020    59.441     0.150
     4.020    75.941     0.150
     4.020   107.441     0.150
     4.127    64.941     0.150
     4.678    77.441     0.150
     4.678   123.941     0.150
     4.749   127.340     0.150
     4.840    71.543     0.150
     4.865    74.043     0.150
     4.865   129.043     0.150
     4.933    73.441     0.150
     4.933   131.043     0.150
     5.565    82.840     0.150
     5.565   143.941     0.150
     6.371    95.941     0.150
     6.646    97.742     0.150
     6.655    96.441     0.150
     6.645    96.941     0.150
     6.645   124.941     0.150
     6.717    96.941     0.150
     6.748    98.441     0.150
     6.748   100.941     0.150
     6.748   175.941     0.150
     6.855    99.340     0.150
     7.193   106.641     0.150
     7.193   116.641     0.150
     7.196   181.941     0.150
     7.220   106.941     0.150
     7.220   116.941     0.150
     7.220   232.941     0.150
     7.332   106.043     0.150
     7.426   109.941     0.150
     7.537   112.941     0.150
     7.916   115.941     0.150
     7.949   115.641     0.150
     8.074   115.441     0.150
     8.074   201.941     0.150
     8.385   124.941     0.150
     8.761   277.941     0.150
     8.839   127.941     0.150
     8.839   223.141     0.150
     8.872   127.941     0.150
     8.872   225.941     0.150
     8.981   128.340     0.150
     8.981   222.141     0.150
     9.058   132.941     0.150
     9.113   130.941     0.150
     9.113   229.941     0.150
     9.145   131.043     0.150
     9.266   132.742     0.150
     9.781   139.141     0.150
     9.818   140.941     0.150
     9.818   143.941     0.150
     9.818   243.941     0.150
    10.284   145.941     0.150
    10.284   258.941     0.150
    10.464   152.340     0.150
    20.292   279.941     0.150
    22.931   303.941     0.150
    24.261   315.941     0.150
     0.535     9.969     0.150
     0.531    10.770     0.150
     0.542    10.369     0.150
     0.542    18.869     0.150
     0.690    12.969     0.150
     1.717    30.869     0.150
     1.855    30.869     0.150
     1.879    33.469     0.150
     2.769    46.869     0.150
     2.943    48.369     0.150
     2.943    86.369     0.150
     4.389    67.969     0.150
     4.680    70.770     0.150
     4.680   124.169     0.150
     4.797    71.869     0.150
     4.797   127.169     0.150
     4.941    76.069     0.150
     4.941   129.669     0.150
     4.941   147.869     0.150
     4.917    75.469     0.150
     4.917    76.469     0.150
     5.111    75.869     0.150
     5.111   131.869     0.150
     5.546    82.669     0.150
     5.546   144.369     0.150
     5.721    86.469     0.150
     6.424    96.369     0.150
     6.614    96.669     0.150
     6.675    97.469     0.150
     6.756   100.969     0.150
     6.778   100.270     0.150
     6.813    99.869     0.150
     7.861   115.869     0.150
     7.967   115.869     0.150
     8.080   115.770     0.150
     8.080   206.869     0.150
     8.168   118.869     0.150
     8.882   127.770     0.150
     8.882   223.869     0.150
     8.882   259.869     0.150
     8.910   224.369     0.150
     8.978   129.469     0.150
     9.126   131.869     0.150
     9.126   231.270     0.150
     9.106   134.869     0.150
     9.244   133.069     0.150
     9.244   231.669     0.150
     9.790   139.469     0.150
     9.818   140.869     0.150
    10.290   148.569     0.150
    22.948   304.569     0.150
    24.284   316.869     0.150
     0.450     8.973     0.150
     0.450    15.473     0.150
     0.691    12.973     0.150
     0.691    22.473     0.150
     0.866    15.473     0.150
     1.260    21.473     0.150
     1.457    24.172     0.150
     1.519    26.973     0.150
     1.591    26.871     0.150
     1.719    26.973     0.150
     2.042    33.273     0.150
     2.042    61.973     0.150
     2.176    33.672     0.150
     2.499    73.473     0.150
     2.710    45.973     0.150
     3.028    54.473     0.150
     3.177    50.473     0.150
     3.177    87.273     0.150
     3.177   100.773     0.150
     3.555    57.473     0.150
     3.923    61.672     0.150
     4.002    58.773     0.150
     4.002   105.273     0.150
     4.172    64.273     0.150
     4.213    62.273     0.150
     4.213   109.473     0.150
     4.554    77.473     0.150
     4.759    77.473     0.150
     4.835    76.473     0.150
     4.952    81.473     0.150
     4.952   124.973     0.150
     5.109    74.473     0.150
     5.451    80.273     0.150
     5.874    85.973     0.150
     6.027   102.871     0.150
     6.330    93.473     0.150
     6.379   101.273     0.150
     6.432   164.473     0.150
     6.585    98.273     0.150
     6.805   101.273     0.150
     7.099   100.973     0.150
     7.099   177.473     0.150
     7.365   104.973     0.150
     7.476   106.473     0.150
     8.403   118.473     0.150
     8.504   118.672     0.150
     8.504   208.672     0.150
     8.586   120.973     0.150
     8.670   122.371     0.150
     8.843   124.773     0.150
     8.843   216.074     0.150
     9.598   134.371     0.150
     9.598   236.672     0.150
     9.805   137.273     0.150
     9.805   239.371     0.150
     9.893   138.273     0.150
     9.919   138.473     0.150
     0.665    11.406     0.150
     0.853    15.305     0.150
     2.154    35.008     0.150
     2.466    43.008     0.150
     3.096    52.508     0.150
     3.096   105.508     0.150
     3.513    52.508     0.150
     3.981    62.609     0.150
     3.979    63.211     0.150
     4.162    68.008     0.150
     4.319    66.008     0.150
     4.196    67.508     0.150
     4.196   120.008     0.150
     4.766    73.008     0.150
     4.965    73.109     0.150
     4.965    90.211     0.150
     4.965   129.508     0.150
     5.085    73.906     0.150
     5.085   133.805     0.150
     5.532    84.008     0.150
     5.812    85.008     0.150
     5.871    86.508     0.150
     5.865    90.805     0.150
     6.440    95.008     0.150
     6.878   101.008     0.150
     6.878   176.008     0.150
     7.020   102.211     0.150
     7.020   181.008     0.150
     6.947    99.609     0.150
     6.969    99.609     0.150
     6.969   176.609     0.150
     7.066   105.406     0.150
     7.109   102.305     0.150
     7.109   181.406     0.150
     7.436   120.508     0.150
     7.146   106.008     0.150
     8.351   119.508     0.150
     8.351   211.008     0.150
     8.449   119.211     0.150
     8.449   212.406     0.150
     9.138   130.211     0.150
     9.138   229.008     0.150
     9.144   131.008     0.150
     9.237   131.406     0.150
     9.275   132.211     0.150
     9.275   230.406     0.150
     9.451   134.609     0.150
     9.451   237.008     0.150
     9.571   136.711     0.150
     9.571   238.711     0.150
    10.052   143.008     0.150
    10.107   147.008     0.150
    10.505   150.008     0.150
    10.505   261.508     0.150
    10.562   150.008     0.150
    11.877   169.211     0.150
    11.877   294.906     0.150
    19.317   265.305     0.150
    20.354   276.609     0.150
    20.505   279.008     0.150
    22.832   302.008     0.150
     0.773    12.961     0.150
     0.957    16.961     0.150
     1.603    28.758     0.150
     2.140    37.758     0.150
     2.264    37.258     0.150
     2.568    42.359     0.150
     3.041    48.258     0.150
     3.041    83.758     0.150
     3.191    52.758     0.150
     3.191   108.258     0.150
     3.125    52.758     0.150
     3.125   100.156     0.150
     3.300    52.758     0.150
     3.300    93.055     0.150
     3.401    55.258     0.150
     3.574    54.961     0.150
     3.631    57.859     0.150
     3.631   106.859     0.150
     3.892    60.758     0.150
     3.953    62.156     0.150
     4.084    63.055     0.150
     4.087    65.156     0.150
     4.087   112.359     0.150
     4.258    80.258     0.150
     4.416    74.258     0.150
     4.670    70.758     0.150
     4.670   124.258     0.150
     5.017   130.961     0.150
     5.197    76.461     0.150
     5.197   135.258     0.150
     5.438   142.359     0.150
     5.428    80.758     0.150
     5.885   148.758     0.150
     5.957   153.758     0.150
     6.186   104.258     0.150
     6.545    96.258     0.150
     6.894    99.258     0.150
     6.894   133.258     0.150
     7.080   102.555     0.150
     7.059   103.359     0.150
     7.059   180.258     0.150
     7.132   136.258     0.150
     7.132   186.258     0.150
     7.035   104.258     0.150
     7.220   104.156     0.150
     7.237   105.258     0.150
     7.455   120.258     0.150
     8.395   120.258     0.150
     8.395   213.258     0.150
     8.395   122.461     0.150
     8.481   122.258     0.150
     8.988   131.258     0.150
     9.172   131.758     0.150
     9.233   132.258     0.150
     9.327   133.055     0.150
     9.536   236.555     0.150
     9.461   137.258     0.150
     9.484   136.461     0.150
     9.661   136.656     0.150
     9.661   239.555     0.150
    10.026   149.258     0.150
    10.090   322.258     0.150
    10.018   144.258     0.150
    10.160   145.258     0.150
    10.160   325.258     0.150
    10.605   267.258     0.150
    11.422   164.258     0.150
    20.393   276.461     0.150
    20.508   281.258     0.150
    22.836   304.555     0.150
    24.477   319.258     0.150
    36.350   423.359     0.150
    38.773   446.156     0.150
    51.241   543.258     0.150
     0.870    17.039     0.150
     1.916    34.742     0.150
     2.135    65.539     0.150
     2.378    37.539     0.150
     3.177    52.742     0.150
     3.191    51.242     0.150
     3.363    53.836     0.150
     3.474    54.039     0.150
     3.780    59.641     0.150
     3.818    58.742     0.150
     3.858    59.938     0.150
     4.070    62.242     0.150
     4.031    63.039     0.150
     4.188    71.539     0.150
     4.594    70.039     0.150
     4.628    72.539     0.150
     4.698    70.438     0.150
     4.698    92.242     0.150
     4.919    74.039     0.150
     5.690    83.539     0.150
     5.722    85.539     0.150
     5.962   100.039     0.150
     6.363    95.039     0.150
     6.569    97.039     0.150
     6.569   208.039     0.150
     6.734    99.539     0.150
     7.011   101.539     0.150
     8.070   116.641     0.150
     8.184   122.039     0.150
     8.184   201.039     0.150
     8.425   120.742     0.150
     8.299   120.141     0.150
     8.845   128.539     0.150
     8.845   252.039     0.150
     9.699   143.039     0.150
     9.764   140.242     0.150
     9.842   142.539     0.150
    19.023   263.539     0.150
    20.067   273.836     0.150
    22.518   303.039     0.150
    22.864   303.836     0.150
    24.160   315.039     0.150
    26.974   340.039     0.150
     0.748    12.616     0.150
     1.077    19.616     0.150
     2.122    35.616     0.150
     2.137    35.116     0.150
     2.549    40.616     0.150
     2.639    41.517     0.150
     2.691    42.416     0.150
     3.174    54.116     0.150
     3.033    48.116     0.150
     3.033    82.616     0.150
     3.150    51.416     0.150
     3.150   101.416     0.150
     3.322    53.116     0.150
     3.322    94.017     0.150
     3.326    53.116     0.150
     3.425    53.716     0.150
     3.597    55.416     0.150
     3.597    99.616     0.150
     3.655    59.716     0.150
     3.655   113.716     0.150
     3.905    60.816     0.150
     3.975    61.017     0.150
     3.975   110.517     0.150
     4.241   110.616     0.150
     4.109    63.716     0.150
     4.111   117.416     0.150
     4.693    71.616     0.150
     4.693   125.116     0.150
     4.895   143.616     0.150
     4.948    74.216     0.150
     5.010   132.017     0.150
     5.174    76.416     0.150
     5.174   134.716     0.150
     5.241    77.116     0.150
     5.241   134.616     0.150
     5.454    79.616     0.150
     5.454   104.616     0.150
     5.452    80.916     0.150
     5.550    83.416     0.150
     5.579    84.116     0.150
     5.874    85.616     0.150
     5.874   150.616     0.150
     5.943    89.916     0.150
     5.942    87.116     0.150
     5.954    93.616     0.150
     6.166    90.616     0.150
     6.225    93.616     0.150
     6.525    97.616     0.150
     6.488   104.616     0.150
     6.856   101.616     0.150
     6.896    98.616     0.150
     6.896   102.616     0.150
     7.035   101.716     0.150
     7.057   102.017     0.150
     7.057   181.216     0.150
     7.056   102.116     0.150
     7.056   103.616     0.150
     7.056   180.616     0.150
     7.113   104.216     0.150
     7.198   103.916     0.150
     7.140   106.616     0.150
     7.273   107.616     0.150
     7.273   184.616     0.150
     7.327   110.316     0.150
     7.283   187.616     0.150
     7.456   108.116     0.150
     7.456   193.616     0.150
     7.445   111.616     0.150
     7.676   193.616     0.150
     7.572   111.616     0.150
     7.721   123.616     0.150
     7.779   111.616     0.150
     8.391   120.616     0.150
     8.391   212.616     0.150
     8.391   212.116     0.150
     8.352   123.116     0.150
     8.493   120.816     0.150
     8.403   122.616     0.150
     8.403   123.116     0.150
     8.416   124.616     0.150
     8.490   122.616     0.150
     8.419   122.216     0.150
     8.599   130.616     0.150
     8.668   130.616     0.150
     9.008   131.616     0.150
     9.170   131.116     0.150
     9.170   229.616     0.150
     9.170   229.116     0.150
     9.218   132.116     0.150
     9.257   133.616     0.150
     9.311   132.517     0.150
     9.209   135.616     0.150
     9.326   133.816     0.150
     9.326   233.716     0.150
     9.340   133.816     0.150
     9.425   133.616     0.150
     9.362   135.216     0.150
     9.645   137.116     0.150
     9.645   241.616     0.150
     9.485   139.616     0.150
     9.508   138.716     0.150
     9.668   138.616     0.150
     9.756   142.716     0.150
    10.027   144.616     0.150
    10.027   255.116     0.150
    10.087   143.416     0.150
    10.087   258.616     0.150
    10.154   147.616     0.150
    10.040   143.616     0.150
    10.296   152.616     0.150
    10.350   147.616     0.150
    10.566   152.116     0.150
    10.566   263.816     0.150
    10.601   150.716     0.150
    10.601   267.616     0.150
    10.601   305.616     0.150
    10.699   158.116     0.150
    11.370   164.616     0.150
    11.446   166.416     0.150
    11.949   172.116     0.150
    11.985   173.116     0.150
    12.277   178.616     0.150
    12.619   181.616     0.150
    12.717   181.816     0.150
    13.290   193.616     0.150
    14.850   219.616     0.150
    15.614   221.616     0.150
    15.999   223.616     0.150
    18.218   249.616     0.150
    18.218   465.616     0.150
    18.983   262.216     0.150
    19.348   265.116     0.150
    19.436   268.116     0.150
    20.013   274.517     0.150
    20.013   500.616     0.150
    20.013   287.616     0.150
    20.390   275.416     0.150
    20.513   280.616     0.150
    20.513   526.616     0.150
    20.636   281.116     0.150
    20.636   527.616     0.150
    20.869   299.616     0.150
    21.120   283.616     0.150
    21.120   531.616     0.150
    21.117   525.616     0.150
    21.515   292.616     0.150
    22.087   545.616     0.150
    22.841   303.616     0.150
    23.191   306.716     0.150
    23.380   310.616     0.150
    23.380   565.616     0.150
    23.631   570.416     0.150
    23.928   315.616     0.150
    23.992   316.616     0.150
    24.482   318.616     0.150
    24.482   584.616     0.150
    27.197   344.616     0.150
    31.896   385.616     0.150
    33.095   395.616     0.150
    33.095   395.816     0.150
    33.088   395.616     0.150
    33.088   395.916     0.150
    36.353   424.816     0.150
    36.354   423.816     0.150
    37.121   436.017     0.150
    37.269   432.616     0.150
    38.877   444.616     0.150
    38.760   445.416     0.150
    38.932   446.017     0.150
    38.932   445.616     0.150
    41.587   468.616     0.150
    41.587   469.216     0.150
    42.370   475.616     0.150
    42.462   476.616     0.150
    42.767   478.616     0.150
    43.036   481.616     0.150
    43.036   481.816     0.150
    43.384   483.616     0.150
    43.384   484.517     0.150
    45.025   495.616     0.150
    45.025   496.116     0.150
    45.067   497.616     0.150
    45.060   497.616     0.150
    46.441   507.616     0.150
    46.441   619.616     0.150
    47.915   517.816     0.150
    51.265   542.116     0.150
    58.537   594.616     0.150
    58.537     4.500     0.150
    58.537   595.116     0.150
    58.537     4.000     0.150
    58.787   599.616     0.150
    58.787   600.116     0.150
    59.096   601.616     0.150
    59.264   602.616     0.150
    61.901   620.616     0.150
    69.481   668.616     0.150
    73.092   690.716     0.150
    73.177   690.517     0.150
    73.777   693.616     0.150
    73.777   694.116     0.150
    81.832   739.616     0.150
    81.958   739.316     0.150
    83.066   743.116     0.150
    83.357   745.616     0.150
     1.029    19.126     0.150
     1.208    22.626     0.150
     1.431    25.126     0.150
     2.072    38.126     0.150
     2.187    38.126     0.150
     2.496    40.626     0.150
     3.034    48.626     0.150
     3.034    85.126     0.150
     3.202    53.526     0.150
     3.361    53.626     0.150
     3.471    55.826     0.150
     3.637    56.626     0.150
     3.709    60.226     0.150
     3.949    61.826     0.150
     4.190    64.126     0.150
     4.157    64.626     0.150
     4.163    66.626     0.150
     4.736    72.526     0.150
     4.921    75.426     0.150
     4.921   131.826     0.150
     4.979    90.526     0.150
     4.979   130.726     0.150
     5.119    76.926     0.150
     5.215    77.426     0.150
     5.472   100.626     0.150
     5.500    81.626     0.150
     5.833    85.626     0.150
     5.833   149.626     0.150
     5.896    86.826     0.150
     5.893    89.626     0.150
     6.471    98.626     0.150
     7.030   102.626     0.150
     7.030   182.626     0.150
     6.980   102.526     0.150
     7.002   102.726     0.150
     7.143   105.626     0.150
     7.440   108.626     0.150
     8.363   119.626     0.150
     8.363   212.626     0.150
     8.463   121.126     0.150
     8.492   124.626     0.150
     8.471   123.526     0.150
     9.038   130.626     0.150
     9.147   131.626     0.150
     9.147   229.626     0.150
     9.263   133.326     0.150
     9.597   137.226     0.150
     9.597   240.826     0.150
    10.009   144.626     0.150
    10.062   144.326     0.150
    19.491   272.626     0.150
    20.365   277.226     0.150
    36.378   424.326     0.150
    36.379   424.526     0.150
     0.497     9.840     0.150
     0.686    12.738     0.150
     0.899    17.738     0.150
     0.899    30.738     0.150
     1.924    33.039     0.150
     1.998    33.039     0.150
     1.998    57.238     0.150
     2.328    37.738     0.150
     2.394    40.637     0.150
     2.974    49.238     0.150
     2.992    87.238     0.150
     3.406    55.238     0.150
     3.543    55.938     0.150
     3.543   118.039     0.150
     3.668    59.238     0.150
     3.821    58.738     0.150
     3.821   104.039     0.150
     4.036    75.238     0.150
     3.911    62.340     0.150
     4.193    78.738     0.150
     4.193   112.238     0.150
     4.142    64.238     0.150
     4.202    64.637     0.150
     4.357    66.938     0.150
     4.366    67.738     0.150
     4.663    68.738     0.150
     4.880    75.238     0.150
     4.880    96.238     0.150
     4.880   128.738     0.150
     4.919    73.539     0.150
     4.919   127.238     0.150
     4.919   157.539     0.150
     4.923    73.738     0.150
     4.923   131.738     0.150
     4.927    74.738     0.150
     4.927   132.738     0.150
     5.178    78.238     0.150
     5.178   133.637     0.150
     5.596    82.539     0.150
     5.729    84.738     0.150
     5.729   146.738     0.150
     5.766    85.238     0.150
     5.766   150.738     0.150
     5.699    86.238     0.150
     6.327    92.238     0.150
     6.621    98.238     0.150
     6.789    99.340     0.150
     6.809    99.137     0.150
     6.889   100.238     0.150
     6.950   101.637     0.150
     6.993   102.238     0.150
     6.993   179.238     0.150
     7.441   112.738     0.150
     7.309   108.238     0.150
     8.318   118.938     0.150
     8.318   211.238     0.150
     8.675   126.137     0.150
     9.118   130.938     0.150
     9.455   236.738     0.150
    10.026   144.738     0.150
    10.057   145.238     0.150
    10.057   251.238     0.150
     0.488     9.746     0.150
     0.825    15.746     0.150
     1.415    25.746     0.150
     1.656    28.746     0.150
     1.854    32.945     0.150
     1.945    32.547     0.150
     1.945    56.746     0.150
     2.264    37.945     0.150
     2.432    40.945     0.150
     2.432    45.547     0.150
     2.905    50.746     0.150
     2.841    46.945     0.150
     3.056    49.746     0.150
     3.056    84.746     0.150
     4.125    68.246     0.150
     4.125   120.246     0.150
     4.374    67.945     0.150
     4.663    68.746     0.150
     4.663   123.246     0.150
     4.806    75.246     0.150
     4.806    94.746     0.150
     4.806   126.246     0.150
     4.843    73.047     0.150
     4.843    91.645     0.150
     4.843   126.145     0.150
     4.876    73.645     0.150
     4.876   131.746     0.150
     4.930    75.145     0.150
     4.930   132.746     0.150
     5.104    76.746     0.150
     5.104    97.746     0.150
     5.104   132.645     0.150
     5.654    84.246     0.150
     5.693   150.246     0.150
     5.713    84.848     0.150
     6.297    93.746     0.150
     6.737    98.445     0.150
     6.759    99.246     0.150
     6.900   101.547     0.150
     6.919   101.746     0.150
     6.919   103.746     0.150
     6.919   179.746     0.150
     7.135   105.746     0.150
     7.200   104.746     0.150
     7.372   112.547     0.150
     7.998   114.746     0.150
     8.243   118.746     0.150
     8.243   211.746     0.150
     8.243   118.848     0.150
     8.243   211.445     0.150
     8.304   123.547     0.150
     8.503   124.746     0.150
     8.702   126.445     0.150
     8.961   130.746     0.150
     9.045   130.746     0.150
     9.174   135.547     0.150
     9.385   134.445     0.150
     9.385   236.547     0.150
     9.832   142.746     0.150
     9.933   144.746     0.150
     9.952   143.348     0.150
     9.981   144.246     0.150
     9.981   247.746     0.150
    10.453   263.746     0.150
    19.224   266.445     0.150
    20.092   273.746     0.150
    20.092   274.047     0.150
    20.251   277.145     0.150
    22.793   306.445     0.150
     0.524     9.750     0.150
     0.930    18.250     0.150
     0.930    33.250     0.150
     1.216    22.750     0.150
     1.267    22.750     0.150
     1.977    36.250     0.150
     2.117    35.250     0.150
     2.243    38.547     0.150
     2.410    39.750     0.150
     2.410    68.750     0.150
     3.028    59.750     0.150
     3.127    49.250     0.150
     3.127    85.250     0.150
     3.240    53.250     0.150
     3.240   102.148     0.150
     3.347    54.250     0.150
     3.481    55.750     0.150
     3.626    56.453     0.150
     3.761    60.250     0.150
     3.761   103.250     0.150
     3.950    61.750     0.150
     3.950   105.250     0.150
     4.007    62.047     0.150
     4.007   108.547     0.150
     4.096    79.750     0.150
     4.175    65.047     0.150
     4.193    67.047     0.150
     4.253    80.750     0.150
     4.734    72.750     0.150
     4.811    72.750     0.150
     4.811   129.750     0.150
     4.868    71.648     0.150
     5.056    75.453     0.150
     5.105    75.547     0.150
     5.105   134.250     0.150
     5.514    81.453     0.150
     5.725    83.750     0.150
     5.725   147.750     0.150
     5.793    85.750     0.150
     5.793   152.750     0.150
     6.137    90.750     0.150
     6.778    97.750     0.150
     6.921   100.852     0.150
     6.921   102.750     0.150
     6.921   179.750     0.150
     7.661   112.750     0.150
     7.806   112.750     0.150
     8.253   117.750     0.150
     8.352   119.148     0.150
     8.505   123.047     0.150
     9.000   130.750     0.150
     9.038   130.250     0.150
     9.038   229.750     0.150
     9.070   231.250     0.150
     9.953   140.648     0.150
    20.255   273.750     0.150
     0.615    11.250     0.150
     0.615    22.250     0.150
     0.977    18.250     0.150
     1.259    23.250     0.150
     1.486    26.250     0.150
     2.018    33.750     0.150
     2.127    37.250     0.150
     2.439    38.949     0.150
     2.251    41.449     0.150
     3.037    47.750     0.150
     3.037    84.750     0.150
     3.260    56.449     0.150
     3.260   102.250     0.150
     3.405    61.750     0.150
     3.405    96.750     0.150
     3.682    57.150     0.150
     3.768    61.150     0.150
     4.135    76.250     0.150
     3.998    62.250     0.150
     4.293    81.250     0.150
     4.062    63.551     0.150
     4.211    65.551     0.150
     4.804    68.250     0.150
     4.893    73.750     0.150
     4.945    72.750     0.150
     4.945   129.150     0.150
     4.784    73.250     0.150
     4.784    78.750     0.150
     4.784   126.250     0.150
     5.059    74.250     0.150
     5.187    77.051     0.150
     5.187   134.750     0.150
     5.553    82.250     0.150
     5.789    84.250     0.150
     5.789   148.250     0.150
     5.846    86.250     0.150
     6.866    99.250     0.150
     6.866   133.250     0.150
     6.866   174.250     0.150
     7.003   101.250     0.150
     7.003   103.250     0.150
     7.003   178.250     0.150
     7.703   113.250     0.150
     8.334   118.949     0.150
     8.334   210.250     0.150
     8.495   124.250     0.150
     9.122   131.250     0.150
     9.122   228.250     0.150
     9.072   130.750     0.150
     9.254   132.750     0.150
     9.254   230.850     0.150
    10.087   143.750     0.150
    10.544   150.250     0.150
    19.301   264.449     0.150
    20.153   274.150     0.150
     0.527    10.227     0.150
     0.981    18.727     0.150
     0.981    34.727     0.150
     1.215    41.227     0.150
     1.406    24.727     0.150
     2.029    36.227     0.150
     2.173    38.727     0.150
     2.188    36.227     0.150
     2.188    39.125     0.150
     2.263    38.828     0.150
     2.464    40.227     0.150
     2.844    46.227     0.150
     2.844    80.027     0.150
     3.080    61.227     0.150
     3.124    51.727     0.150
     3.186    53.625     0.150
     3.186    99.926     0.150
     3.306    54.125     0.150
     3.433    54.227     0.150
     3.584    56.527     0.150
     3.706    60.227     0.150
     3.904    61.727     0.150
     3.904   108.227     0.150
     3.965    61.727     0.150
     3.965   107.027     0.150
     4.125    64.926     0.150
     4.140    65.328     0.150
     4.140   115.527     0.150
     4.689    72.227     0.150
     4.689   125.426     0.150
     4.839    73.527     0.150
     4.901    72.527     0.150
     4.901    90.227     0.150
     4.901   128.027     0.150
     4.900    69.227     0.150
     5.112    75.727     0.150
     5.132    76.426     0.150
     5.132   135.727     0.150
     5.391    89.527     0.150
     5.465    82.027     0.150
     5.767    84.727     0.150
     5.767   147.727     0.150
     5.841    86.227     0.150
     5.848    99.727     0.150
     6.113    90.227     0.150
     6.213   102.227     0.150
     6.778   115.227     0.150
     6.793    99.227     0.150
     6.793   175.227     0.150
     6.947   101.227     0.150
     6.947   103.227     0.150
     6.947   180.227     0.150
     7.016   103.227     0.150
     7.049   108.227     0.150
     7.187   116.227     0.150
     7.352   144.227     0.150
     7.352   208.227     0.150
     7.613   201.227     0.150
     7.765   112.227     0.150
     8.282   118.527     0.150
     8.282   209.227     0.150
     8.299   126.227     0.150
     8.381   120.125     0.150
     8.383   120.727     0.150
     8.403   124.227     0.150
     8.451   123.527     0.150
     8.969   132.227     0.150
     9.062   131.227     0.150
     9.118   133.227     0.150
     9.196   136.227     0.150
     9.531   138.227     0.150
     9.628   141.227     0.150
     9.662   141.227     0.150
     9.922   144.227     0.150
     9.979   143.027     0.150
    10.044   250.227     0.150
    10.492   150.227     0.150
    18.990   261.227     0.150
    19.241   265.227     0.150
    20.415   278.227     0.150
    23.088   306.125     0.150
    73.182   691.227     0.150
     0.503     9.633     0.150
     0.735    13.133     0.150
     1.464    27.133     0.150
     1.464    45.133     0.150
     1.621    28.133     0.150
     1.780    32.531     0.150
     1.780    55.133     0.150
     1.927    33.133     0.150
     2.026    35.133     0.150
     2.212    36.332     0.150
     2.212    65.633     0.150
     2.425    39.234     0.150
     2.425    44.832     0.150
     2.832    49.133     0.150
     3.015    49.133     0.150
     3.409    54.832     0.150
     3.449    56.633     0.150
     3.449    95.133     0.150
     3.617    56.633     0.150
     3.732    58.531     0.150
     3.732   103.133     0.150
     3.899    61.633     0.150
     3.942    62.734     0.150
     4.075    63.531     0.150
     4.116    63.633     0.150
     4.116   110.633     0.150
     4.320    66.434     0.150
     4.352    68.832     0.150
     4.352   119.133     0.150
     4.713    69.832     0.150
     4.713   125.832     0.150
     4.852    75.133     0.150
     4.852   127.133     0.150
     4.852   132.633     0.150
     4.965    75.633     0.150
     4.965   130.133     0.150
     5.425    80.133     0.150
     5.425   140.633     0.150
     5.545    81.934     0.150
     5.545   142.934     0.150
     5.602    83.133     0.150
     5.602   146.133     0.150
     5.653    84.531     0.150
     6.471    95.734     0.150
     6.674    96.133     0.150
     6.674   170.133     0.150
     6.674   173.133     0.150
     6.781    99.133     0.150
     7.987   116.133     0.150
     8.108   115.934     0.150
     8.108   206.133     0.150
     8.200   117.531     0.150
     8.355   124.133     0.150
     8.876   126.633     0.150
     8.904   127.832     0.150
     8.904   226.133     0.150
     9.016   129.133     0.150
     9.788   142.133     0.150
     9.814   139.633     0.150
     9.853   141.633     0.150
    10.318   146.133     0.150
    10.318   293.133     0.150
    19.084   263.832     0.150
    19.929   272.434     0.150
     0.755    12.764     0.150
     0.664    23.764     0.150
     0.966    16.863     0.150
     1.112    37.264     0.150
     1.168    20.764     0.150
     1.377    23.764     0.150
     1.573    25.764     0.150
     2.156    37.264     0.150
     2.265    38.264     0.150
     2.265    69.764     0.150
     2.402    39.463     0.150
     2.402    63.664     0.150
     2.123    34.764     0.150
     2.123    39.764     0.150
     2.579    40.564     0.150
     2.695    74.164     0.150
     2.996    47.264     0.150
     2.996    83.764     0.150
     3.208    55.764     0.150
     3.140    54.564     0.150
     3.617    52.764     0.150
     3.617   104.564     0.150
     3.333    53.963     0.150
     3.426    54.064     0.150
     3.606    54.764     0.150
     3.640    56.963     0.150
     4.274    68.264     0.150
     3.984    61.164     0.150
     4.107    63.664     0.150
     4.105    64.963     0.150
     4.699    70.264     0.150
     4.699    73.164     0.150
     5.052    74.064     0.150
     5.052   130.764     0.150
     5.194    75.764     0.150
     5.282    77.064     0.150
     5.282   136.264     0.150
     5.452    80.164     0.150
     5.913    85.264     0.150
     5.977    89.764     0.150
     5.979    87.064     0.150
     6.840    99.264     0.150
     6.936    99.764     0.150
     6.936   113.764     0.150
     6.936   198.764     0.150
     7.097   102.264     0.150
     7.154   105.863     0.150
     7.092   101.764     0.150
     7.314   107.764     0.150
     7.314   206.764     0.150
     7.038   103.264     0.150
     7.932   115.363     0.150
     7.724   115.764     0.150
     7.788   112.764     0.150
     8.432   119.764     0.150
     8.432   213.764     0.150
     8.534   121.764     0.150
     8.645   122.463     0.150
     8.525   123.764     0.150
     8.525   166.764     0.150
     8.682   126.764     0.150
     9.254   131.264     0.150
     9.211   130.764     0.150
     9.211   229.764     0.150
     9.211   229.264     0.150
     9.027   130.764     0.150
     9.020   132.764     0.150
     9.298   132.764     0.150
     9.242   134.764     0.150
     9.301   135.764     0.150
     9.245   134.764     0.150
     9.364   134.764     0.150
     9.830   140.564     0.150
     9.687   137.764     0.150
     9.687   138.264     0.150
     9.850   144.764     0.150
    10.067   145.764     0.150
    10.128   143.264     0.150
    10.128   141.764     0.150
    10.195   144.264     0.150
    10.053   143.764     0.150
    10.311   148.764     0.150
    10.642   150.764     0.150
    10.873   157.764     0.150
    11.366   160.764     0.150
    11.793   168.363     0.150
    16.033   222.764     0.150
    19.135   265.764     0.150
    19.411   269.764     0.150
    19.411   492.764     0.150
    20.249   275.363     0.150
    20.551   276.764     0.150
    21.156   284.764     0.150
    21.156   542.764     0.150
    21.119   287.064     0.150
    22.880   301.963     0.150
    23.231   305.963     0.150
    24.521   318.764     0.150
    27.238   343.064     0.150
    31.920   382.764     0.150
    31.920   383.463     0.150
    36.313   421.764     0.150
    38.729   442.963     0.150
    41.593   468.764     0.150
    41.593   469.363     0.150
    42.371   474.764     0.150
    42.470   475.764     0.150
    43.041   479.764     0.150
    43.041   480.064     0.150
    43.394   483.764     0.150
    43.394     5.000     0.150
    43.394   484.564     0.150
    43.394     4.199     0.150
    44.827   495.764     0.150
    44.827   496.164     0.150
    45.850   503.764     0.150
    47.937   517.764     0.150
    47.937   518.164     0.150
    58.834   596.764     0.150
    59.056   599.764     0.150
    59.223   601.764     0.150
    61.860   617.764     0.150
    69.521   667.564     0.150
    73.133   712.363     0.150
    73.179   689.764     0.150
    83.521   745.764     0.150
    83.521  1368.764     0.150
   124.497  1137.264     0.150
     0.525     9.372     0.150
     0.553    10.372     0.150
     0.559    10.372     0.150
     0.706    14.872     0.150
     1.501    28.372     0.150
     1.501    49.372     0.150
     2.170    35.872     0.150
     2.170    69.872     0.150
     2.480    41.372     0.150
     3.467    57.172     0.150
     3.510    56.072     0.150
     3.678    57.672     0.150
     3.793    58.772     0.150
     3.862    65.372     0.150
     3.997    62.972     0.150
     4.177    64.772     0.150
     4.412    70.572     0.150
     4.711    90.472     0.150
     4.711   127.772     0.150
     4.913    76.472     0.150
     4.913   132.072     0.150
     4.970    76.372     0.150
     5.142    77.372     0.150
     5.353    79.272     0.150
     5.474    80.872     0.150
     5.527    81.872     0.150
     5.576    83.372     0.150
     5.576   148.872     0.150
     5.714    85.072     0.150
     6.480    97.372     0.150
     6.785    99.872     0.150
     6.785   177.372     0.150
     6.808   102.972     0.150
     8.110   117.572     0.150
     8.110   208.372     0.150
     8.199   118.472     0.150
     8.847   128.872     0.150
     8.912   128.372     0.150
     9.057   130.372     0.150
     9.114   134.372     0.150
     9.802   142.372     0.150
     9.848   143.372     0.150
    22.976   303.472     0.150
     0.582    11.242     0.150
     0.726    12.039     0.150
     1.024    18.742     0.150
     2.070    35.242     0.150
     2.070    63.242     0.150
     2.198    35.742     0.150
     2.787    46.141     0.150
     2.787    81.141     0.150
     3.071    49.242     0.150
     3.071    85.742     0.150
     3.179    55.641     0.150
     3.179    61.344     0.150
     3.326    52.945     0.150
     3.326    94.844     0.150
     3.523    54.445     0.150
     3.523    94.242     0.150
     3.441    55.539     0.150
     3.602    56.344     0.150
     3.690    60.844     0.150
     3.917    60.844     0.150
     3.982    62.039     0.150
     3.982   111.039     0.150
     4.088   111.242     0.150
     4.188    66.742     0.150
     4.188   109.242     0.150
     4.128    64.344     0.150
     4.137    66.445     0.150
     4.346    69.039     0.150
     4.346   138.242     0.150
     4.703    72.242     0.150
     4.703   125.242     0.150
     4.703   129.242     0.150
     4.957    73.539     0.150
     4.957    92.344     0.150
     4.957   128.344     0.150
     5.133    75.344     0.150
     5.133   134.445     0.150
     5.189    78.039     0.150
     5.189   135.641     0.150
     5.399    79.344     0.150
     5.433    81.242     0.150
     5.433   105.742     0.150
     5.471    81.242     0.150
     5.623    81.445     0.150
     5.701    85.844     0.150
     5.819    85.242     0.150
     5.890    90.242     0.150
     5.890   159.242     0.150
     5.888    86.742     0.150
     6.116    99.242     0.150
     6.476    97.742     0.150
     6.465   126.242     0.150
     6.991   100.742     0.150
     7.015   101.039     0.150
     7.004   102.539     0.150
     7.004   181.242     0.150
     7.059   105.742     0.150
     7.155   103.445     0.150
     7.221   107.242     0.150
     7.221   186.242     0.150
     7.242   186.242     0.150
     7.395   192.242     0.150
     7.409   145.242     0.150
     7.409   189.242     0.150
     7.427   124.242     0.150
     7.836   114.641     0.150
     7.784   114.242     0.150
     8.338   118.945     0.150
     8.338   211.242     0.150
     8.331   137.242     0.150
     8.439   120.445     0.150
     8.455   123.242     0.150
     8.447   122.641     0.150
     9.044   131.242     0.150
     9.000   132.242     0.150
     9.000   133.242     0.150
     9.119   130.945     0.150
     9.119   229.242     0.150
     9.119   228.742     0.150
     9.045   132.242     0.150
     9.206   132.242     0.150
     9.257   132.742     0.150
     9.179   135.641     0.150
     9.271   133.344     0.150
     9.271   133.641     0.150
     9.227   137.242     0.150
     9.370   133.539     0.150
     9.591   137.344     0.150
     9.591   239.539     0.150
     9.716   159.945     0.150
     9.660   141.242     0.150
     9.825   145.242     0.150
     9.979   145.242     0.150
    10.035   143.445     0.150
    10.100   145.242     0.150
    10.100   252.242     0.150
    10.480   149.945     0.150
    10.510   152.945     0.150
    10.370   150.242     0.150
    10.549   151.242     0.150
    11.474   168.141     0.150
    12.082   177.039     0.150
    12.514   180.039     0.150
    12.737   182.242     0.150
    18.227   256.242     0.150
    18.227   256.641     0.150
    19.482   269.242     0.150
    19.654   269.445     0.150
    19.988   275.242     0.150
    20.156   274.641     0.150
    20.470   280.039     0.150
    20.644   282.242     0.150
    20.644   292.039     0.150
    20.644   282.445     0.150
    21.083   284.242     0.150
    21.131   288.641     0.150
    22.798   302.242     0.150
    23.144   304.344     0.150
    24.013   320.242     0.150
    24.440   317.242     0.150
    33.104   399.242     0.150
    33.104  1023.242     0.150
    38.823   445.242     0.150
    38.788   447.445     0.150
    42.468   478.242     0.150
    42.468   478.641     0.150
    42.722   479.242     0.150
    42.722    16.000     0.150
    43.387   485.242     0.150
    43.387    16.297     0.150
    43.387   485.641     0.150
    43.387    15.898     0.150
    46.409   509.242     0.150
    47.902   517.242     0.150
    47.902   517.539     0.150
    58.499   594.242     0.150
    73.192   693.039     0.150
    83.012   745.445     0.150
    83.552   748.242     0.150
    83.552  1372.445     0.150
    94.901   806.742     0.150
    98.812   819.242     0.150
   124.523  1140.242     0.150
   124.532  1137.742     0.150
     0.663    12.084     0.150
     1.047    18.884     0.150
     2.086    35.584     0.150
     2.086    38.584     0.150
     2.185    34.784     0.150
     2.341    40.584     0.150
     2.504    40.084     0.150
     2.624    41.184     0.150
     2.679    42.284     0.150
     2.723    76.184     0.150
     3.138    54.584     0.150
     3.222    55.084     0.150
     3.222    95.184     0.150
     3.399    53.684     0.150
     3.399    97.184     0.150
     3.502    55.084     0.150
     3.560    96.784     0.150
     3.723   102.984     0.150
     3.982    61.184     0.150
     3.982   110.184     0.150
     4.052    61.984     0.150
     4.185    65.084     0.150
     4.185    66.984     0.150
     4.185   115.984     0.150
     4.203    64.584     0.150
     4.203   109.584     0.150
     4.360    67.084     0.150
     4.360   117.084     0.150
     4.770    72.084     0.150
     4.959    74.584     0.150
     4.959   128.984     0.150
     5.014    73.984     0.150
     5.014    83.184     0.150
     5.014   129.584     0.150
     5.253    77.884     0.150
     5.253   134.084     0.150
     5.453    79.484     0.150
     5.518    82.584     0.150
     5.673    82.484     0.150
     5.860    86.084     0.150
     5.916    87.584     0.150
     5.916   153.584     0.150
     5.907    88.584     0.150
     6.234    91.584     0.150
     6.786    99.584     0.150
     7.068   102.584     0.150
     7.068   104.584     0.150
     7.068   181.584     0.150
     7.115   105.584     0.150
     7.323   105.584     0.150
     7.323   188.584     0.150
     7.316   110.384     0.150
     7.483   188.584     0.150
     7.682   112.584     0.150
     7.798   114.584     0.150
     7.885   114.284     0.150
     8.400   119.884     0.150
     8.400   211.584     0.150
     8.400   119.984     0.150
     8.400   211.984     0.150
     8.485   138.584     0.150
     8.499   120.284     0.150
     9.081   133.584     0.150
     9.186   130.084     0.150
     9.188   132.584     0.150
     9.310   135.584     0.150
     9.273   132.584     0.150
     9.320   133.584     0.150
     9.398   134.084     0.150
     9.741   140.584     0.150
     9.798   142.984     0.150
     9.798   163.484     0.150
     9.798   248.784     0.150
     9.798   278.684     0.150
    10.051   145.084     0.150
    10.101   143.584     0.150
    10.156   146.584     0.150
    10.611   149.584     0.150
    10.611   268.584     0.150
    11.922   171.884     0.150
    16.051   228.584     0.150
    19.365   265.584     0.150
    19.492   268.584     0.150
    20.403   277.184     0.150
    20.550   277.584     0.150
    20.930   280.584     0.150
    22.877   302.584     0.150
    23.218   306.284     0.150
    24.519   317.584     0.150
    31.964   385.584     0.150
    36.340   422.684     0.150
    38.703   445.384     0.150
    42.799   480.584     0.150
    42.799     7.000     0.150
     0.701    12.957     0.150
     0.701    24.957     0.150
     1.070    18.957     0.150
     1.070    35.957     0.150
     2.107    36.258     0.150
     2.192    67.457     0.150
     2.366    41.057     0.150
     2.519    39.957     0.150
     2.588    40.457     0.150
     2.644    41.656     0.150
     3.230    52.656     0.150
     3.423    53.656     0.150
     3.423    92.357     0.150
     3.519    55.057     0.150
     3.697    58.258     0.150
     3.725    60.156     0.150
     4.002    60.656     0.150
     4.075    61.857     0.150
     4.208    63.957     0.150
     4.208   110.957     0.150
     4.200    64.258     0.150
     4.196    66.457     0.150
     4.196   113.957     0.150
     4.379    63.457     0.150
     4.379   136.957     0.150
     4.791    71.957     0.150
     4.791    88.957     0.150
     4.994    75.156     0.150
     5.047    72.758     0.150
     5.047   129.156     0.150
     5.289    76.857     0.150
     5.289   134.957     0.150
     5.486    80.758     0.150
     5.553   100.957     0.150
     5.545    81.457     0.150
     5.704    81.857     0.150
     5.888    85.156     0.150
     5.940    86.957     0.150
     6.267    92.457     0.150
     6.962   100.457     0.150
     7.104   102.057     0.150
     7.104   181.457     0.150
     7.361   121.457     0.150
     7.879   113.457     0.150
     8.435   119.258     0.150
     8.435   210.457     0.150
     8.532   120.957     0.150
     8.577   123.457     0.150
     9.111   133.457     0.150
     9.222   131.156     0.150
     9.222   263.457     0.150
    10.136   143.457     0.150
    10.136   327.457     0.150
    19.401   265.957     0.150
    20.438   275.457     0.150
    23.256   306.357     0.150
    36.304   422.857     0.150
     0.218     5.418     0.150
     0.532    10.020     0.150
     0.696    13.020     0.150
     0.669    12.719     0.150
     1.652    29.719     0.150
     1.664    27.719     0.150
     1.751    31.117     0.150
     2.022    60.719     0.150
     1.966    32.320     0.150
     2.027    35.219     0.150
     2.049    35.918     0.150
     2.935    46.719     0.150
     3.012    50.918     0.150
     3.012    90.219     0.150
     3.200    50.719     0.150
     3.745    66.719     0.150
     3.745   111.719     0.150
     3.745    59.320     0.150
     3.770    59.520     0.150
     3.770   102.617     0.150
     3.902    76.219     0.150
     3.825    60.418     0.150
     3.825   106.918     0.150
     3.983    63.418     0.150
     3.983   111.020     0.150
     4.107    63.617     0.150
     4.107   112.020     0.150
     4.222    66.617     0.150
     4.255    67.719     0.150
     4.414    68.918     0.150
     4.414   122.320     0.150
     4.446    69.020     0.150
     4.491    69.020     0.150
     4.491   122.520     0.150
     4.700    73.617     0.150
     4.700    89.918     0.150
     4.700   126.219     0.150
     4.767    74.117     0.150
     4.776    72.219     0.150
     4.776    89.219     0.150
     5.071    76.719     0.150
     5.071   134.520     0.150
     5.189    79.020     0.150
     5.378    79.320     0.150
     5.421    87.219     0.150
     5.455    94.719     0.150
     5.455   174.719     0.150
     5.510    82.219     0.150
     5.512    81.418     0.150
     5.512   144.719     0.150
     5.520    84.219     0.150
     5.659    91.719     0.150
     5.764    84.520     0.150
     5.764   188.719     0.150
     5.970    89.719     0.150
     5.970   175.719     0.150
     6.065    91.520     0.150
     6.065   159.918     0.150
     6.348    95.117     0.150
     6.348   164.617     0.150
     6.650    94.719     0.150
     6.626    98.918     0.150
     6.772   104.719     0.150
     6.736   174.719     0.150
     6.862   100.820     0.150
     6.791   100.617     0.150
     6.854    99.719     0.150
     6.854   177.719     0.150
     6.881   101.617     0.150
     6.881   177.719     0.150
     6.984   103.117     0.150
     7.092   105.117     0.150
     7.154   106.219     0.150
     7.239   109.719     0.150
     7.335   107.219     0.150
     7.404   108.020     0.150
     7.382   109.219     0.150
     7.393   108.719     0.150
     7.576   112.820     0.150
     7.652   194.117     0.150
     7.777   117.719     0.150
     7.892   202.719     0.150
     7.905   116.719     0.150
     7.997   121.719     0.150
     7.997   234.719     0.150
     8.192   118.719     0.150
     8.192   209.719     0.150
     8.192   210.117     0.150
     8.252   121.117     0.150
     8.252   210.719     0.150
     8.264   118.820     0.150
     8.267   123.719     0.150
     8.282   120.719     0.150
     8.529   125.117     0.150
     8.622   126.719     0.150
     8.622   169.719     0.150
     8.760   127.719     0.150
     8.749   128.719     0.150
     8.981   129.219     0.150
     9.018   129.719     0.150
     9.018   229.719     0.150
     9.018   129.820     0.150
     9.018   229.219     0.150
     9.040   130.320     0.150
     9.040   226.418     0.150
     9.101   130.719     0.150
     9.129   136.020     0.150
     9.360   139.719     0.150
     9.400   139.219     0.150
     9.423   140.719     0.150
     9.705   141.418     0.150
     9.666   144.820     0.150
     9.821   158.719     0.150
     9.897   141.219     0.150
     9.897   143.719     0.150
     9.915   141.918     0.150
     9.942   143.219     0.150
     9.917   145.719     0.150
    10.078   149.719     0.150
    10.091   146.820     0.150
    10.206   149.020     0.150
    10.263   151.219     0.150
    10.398   149.520     0.150
    10.790   157.918     0.150
    10.920   157.918     0.150
    11.305   165.719     0.150
    11.504   168.020     0.150
    11.504   420.719     0.150
    11.867   303.719     0.150
    11.951   173.320     0.150
    12.136   172.418     0.150
    12.645   184.918     0.150
    13.900   198.219     0.150
    14.437   207.117     0.150
    17.543   244.719     0.150
    17.543   246.719     0.150
    18.555   259.219     0.150
    18.699   261.020     0.150
    18.748   259.820     0.150
    18.808   265.219     0.150
    18.807   260.617     0.150
    18.741   271.719     0.150
    18.858   263.918     0.150
    18.970   261.320     0.150
    19.021   263.918     0.150
    19.003   263.219     0.150
    19.003   266.820     0.150
    19.194   263.719     0.150
    19.262   270.117     0.150
    19.373   268.020     0.150
    19.564   269.320     0.150
    19.546   269.117     0.150
    19.597   268.820     0.150
    19.621   271.117     0.150
    19.678   273.719     0.150
    20.014   274.117     0.150
    20.266   278.719     0.150
    20.521   277.719     0.150
    21.151   287.719     0.150
    21.151   288.520     0.150
    21.151   305.719     0.150
    21.663   295.320     0.150
    23.119   306.020     0.150
    23.934   577.719     0.150
    24.196   321.719     0.150
    24.196   579.918     0.150
    24.196   322.520     0.150
    24.488   320.320     0.150
    24.488   582.719     0.150
    24.567   322.719     0.150
    26.462   341.719     0.150
    27.110   342.719     0.150
    30.198   372.617     0.150
    32.225   388.719     0.150
    32.225    15.000     0.150
    32.225   389.219     0.150
    32.225    14.500     0.150
    33.421   399.719     0.150
    33.421     8.000     0.150
    33.463   401.719     0.150
    35.270   416.520     0.150
    36.547   427.020     0.150
    36.547   427.219     0.150
    38.558   443.719     0.150
    40.584   458.719     0.150
    40.584   459.219     0.150
    42.125   472.719     0.150
    42.125   473.320     0.150
    42.732   483.719     0.150
    42.732     9.000     0.150
    42.925   480.719     0.150
    42.969   483.719     0.150
    42.969   484.219     0.150
    45.312   502.719     0.150
    45.312   503.320     0.150
    45.428   500.418     0.150
    45.543   502.320     0.150
    45.537   501.719     0.150
    46.595   511.719     0.150
    46.595    13.000     0.150
    46.595   620.719     0.150
    48.276   521.219     0.150
    51.047   544.219     0.150
    51.829   547.719     0.150
    58.610   597.719     0.150
    58.811   599.719     0.150
    59.135   602.719     0.150
    59.135   602.918     0.150
    59.168   601.719     0.150
    59.210   600.719     0.150
    59.210     4.500     0.150
    59.447   602.719     0.150
    60.730   612.719     0.150
    60.947   612.719     0.150
    60.947   613.219     0.150
    62.177   622.719     0.150
    64.865   638.719     0.150
    64.865   639.520     0.150
    68.454   662.719     0.150
    69.106   666.719     0.150
    69.133   667.418     0.150
    70.402   675.719     0.150
    71.076   677.719     0.150
    71.076   678.617     0.150
    72.910   689.320     0.150
    73.568   694.719     0.150
    73.727   694.320     0.150
    73.727   694.117     0.150
    76.894   714.918     0.150
    81.057   734.719     0.150
    82.603   745.320     0.150
    82.603    19.301     0.150
    82.900   747.520     0.150
    83.946   749.719     0.150
    91.374   788.719     0.150
     0.090     3.547     0.150
     0.090     4.547     0.150
     0.408     7.250     0.150
     0.521     9.445     0.150
     0.804    15.750     0.150
     0.909    17.250     0.150
     1.225    39.547     0.150
     1.205    23.047     0.150
     1.294    23.250     0.150
     1.294    41.047     0.150
     1.443    26.750     0.150
     1.451    26.250     0.150
     1.978    34.047     0.150
     2.236    39.250     0.150
     2.236    68.047     0.150
     2.283    37.547     0.150
     2.283    66.547     0.150
     2.370    39.250     0.150
     2.659    44.047     0.150
     2.659    75.547     0.150
     2.664    45.047     0.150
     3.126    96.047     0.150
     3.132    50.445     0.150
     3.197    95.047     0.150
     3.362    53.648     0.150
     3.362    94.047     0.150
     3.674    60.047     0.150
     3.679    57.844     0.150
     3.679    98.047     0.150
     3.745   100.250     0.150
     3.745    58.945     0.150
     3.745   103.047     0.150
     3.874    61.750     0.150
     3.874   104.844     0.150
     4.099    62.047     0.150
     4.107    65.344     0.150
     4.180    63.648     0.150
     4.157    64.750     0.150
     4.157   112.750     0.150
     4.166    64.047     0.150
     4.286    66.844     0.150
     4.286   115.547     0.150
     4.302    68.445     0.150
     4.302   116.250     0.150
     4.399    69.750     0.150
     4.361   138.547     0.150
     4.332    66.750     0.150
     4.412    66.250     0.150
     4.414    68.148     0.150
     4.414    86.148     0.150
     4.414   118.648     0.150
     4.591    72.547     0.150
     4.638    72.547     0.150
     4.638   123.750     0.150
     4.828    74.547     0.150
     4.827    72.148     0.150
     4.849    76.547     0.150
     4.846    73.547     0.150
     4.842    72.547     0.150
     4.842   133.547     0.150
     4.885    74.547     0.150
     4.969    77.047     0.150
     4.969    94.844     0.150
     5.091    76.047     0.150
     5.315    80.945     0.150
     5.315   141.844     0.150
     5.435    82.344     0.150
     5.494    81.250     0.150
     5.494    84.344     0.150
     5.494   146.148     0.150
     5.489    82.945     0.150
     5.489   144.445     0.150
     5.727    85.844     0.150
     5.776    87.547     0.150
     5.888    88.750     0.150
     5.999    88.945     0.150
     5.996    90.148     0.150
     6.038    89.047     0.150
     6.038   156.344     0.150
     6.105    90.547     0.150
     6.173    91.344     0.150
     6.107    91.047     0.150
     6.179    91.547     0.150
     6.219    91.648     0.150
     6.219    93.047     0.150
     6.187    92.047     0.150
     6.297    93.945     0.150
     6.295    93.250     0.150
     6.427    96.250     0.150
     6.427   169.047     0.150
     6.470    97.047     0.150
     6.470   168.648     0.150
     6.450    96.047     0.150
     6.646    97.844     0.150
     6.646    98.250     0.150
     6.646   172.148     0.150
     6.646   172.648     0.150
     6.660    99.844     0.150
     6.612    99.047     0.150
     6.662    99.047     0.150
     6.738   100.047     0.150
     6.780   103.047     0.150
     6.780   110.047     0.150
     6.780   176.047     0.150
     6.780   109.750     0.150
     6.780   176.250     0.150
     6.797   102.250     0.150
     6.797   130.844     0.150
     6.850   100.047     0.150
     6.887   101.844     0.150
     6.841   101.047     0.150
     6.976   103.547     0.150
     7.034   104.047     0.150
     7.060   104.547     0.150
     7.060   184.047     0.150
     7.230   106.344     0.150
     7.191   107.547     0.150
     7.287   107.945     0.150
     7.414   108.148     0.150
     7.520   109.250     0.150
     7.747   115.047     0.150
     8.143   118.047     0.150
     8.143   131.047     0.150
     8.203   206.148     0.150
     8.152   120.547     0.150
     8.283   121.047     0.150
     8.352   122.750     0.150
     8.294   122.047     0.150
     8.360   120.844     0.150
     8.360   213.047     0.150
     8.425   121.148     0.150
     8.425   212.648     0.150
     8.536   123.047     0.150
     8.536   213.047     0.150
     8.586   128.047     0.150
     8.852   128.344     0.150
     8.848   131.047     0.150
     8.848   143.445     0.150
     8.848   148.148     0.150
     8.869   131.047     0.150
     8.924   130.547     0.150
     9.212   133.047     0.150
     9.249   133.047     0.150
     9.263   136.047     0.150
     9.313   135.844     0.150
     9.724   140.047     0.150
     9.909   145.047     0.150
     9.909   144.047     0.150
    10.848   159.844     0.150
    10.848   175.250     0.150
    11.460   166.047     0.150
    11.669   168.047     0.150
    18.365   255.547     0.150
    18.532   257.750     0.150
    19.530   268.445     0.150
    19.935   273.047     0.150
    19.935   285.047     0.150
    21.738   296.047     0.150
    22.256   296.047     0.150
    22.488   299.148     0.150
    23.899   313.047     0.150
    26.656   341.047     0.150
    37.224   431.547     0.150
    37.224    13.000     0.150
    58.380   595.844     0.150
    58.408   595.648     0.150
    58.624   597.250     0.150
    68.448   661.945     0.150
     0.093     3.336     0.150
     0.093     5.535     0.150
     1.038    20.535     0.150
     1.038    35.035     0.150
     0.955    17.535     0.150
     1.170    21.035     0.150
     1.170    38.535     0.150
     1.289    22.535     0.150
     1.289    39.535     0.150
     1.371    25.234     0.150
     1.483    26.637     0.150
     1.524    27.535     0.150
     1.659    29.035     0.150
     1.771    32.035     0.150
     1.948    36.035     0.150
     1.911    35.035     0.150
     2.125    34.535     0.150
     2.157    38.137     0.150
     2.343    41.035     0.150
     2.343    72.535     0.150
     2.311    37.535     0.150
     2.311    70.535     0.150
     2.354    38.035     0.150
     2.465    42.535     0.150
     2.465    73.535     0.150
     2.448    42.336     0.150
     2.656    42.535     0.150
     2.823    45.035     0.150
     2.823    77.535     0.150
     2.759    45.836     0.150
     2.759    79.535     0.150
     2.932    60.535     0.150
     2.932   100.535     0.150
     3.006    47.734     0.150
     3.006    82.637     0.150
     3.049    47.734     0.150
     3.036    48.035     0.150
     3.036    81.535     0.150
     3.109    50.137     0.150
     3.240    89.934     0.150
     3.201    51.035     0.150
     3.476    54.535     0.150
     3.476    97.035     0.150
     3.444    54.234     0.150
     3.437    53.535     0.150
     3.623    57.137     0.150
     3.623    96.137     0.150
     3.987    63.035     0.150
     3.874    60.836     0.150
     3.907    61.434     0.150
     3.907   118.336     0.150
     3.923    60.535     0.150
     4.168    71.336     0.150
     4.168    77.234     0.150
     4.168   111.934     0.150
     4.168   120.434     0.150
     4.206    63.535     0.150
     4.206    64.934     0.150
     4.206   111.734     0.150
     4.320    64.234     0.150
     4.320    79.734     0.150
     4.320   113.637     0.150
     4.320   134.637     0.150
     4.485    67.637     0.150
     4.485    75.836     0.150
     4.485    86.934     0.150
     4.485   118.734     0.150
     4.543    69.535     0.150
     4.593    68.137     0.150
     4.593   119.734     0.150
     4.620    69.434     0.150
     4.620    88.637     0.150
     4.620   151.336     0.150
     4.685    71.535     0.150
     5.054    75.035     0.150
     4.989    74.637     0.150
     4.989   128.637     0.150
     5.266    79.535     0.150
     5.333    78.336     0.150
     5.333   135.535     0.150
     5.406    79.336     0.150
     5.273    78.934     0.150
     5.273   135.434     0.150
     5.368    78.535     0.150
     5.328    79.637     0.150
     5.519    81.035     0.150
     5.519   145.035     0.150
     5.474    80.934     0.150
     5.556    83.535     0.150
     5.556   141.535     0.150
     5.706    83.535     0.150
     5.706   148.535     0.150
     5.706   150.836     0.150
     5.761    85.535     0.150
     5.724    84.836     0.150
     5.724   147.637     0.150
     5.854    86.434     0.150
     5.910    87.535     0.150
     5.910   149.535     0.150
     6.140    90.035     0.150
     6.113    91.535     0.150
     6.291    92.535     0.150
     6.291   162.535     0.150
     6.194    90.637     0.150
     6.271    92.535     0.150
     6.400   200.836     0.150
     6.419    94.234     0.150
     6.484    95.637     0.150
     6.598   110.137     0.150
     6.627    95.035     0.150
     6.627   167.535     0.150
     6.667    97.836     0.150
     6.628    96.535     0.150
     6.716    97.035     0.150
     6.716   165.836     0.150
     7.171   104.535     0.150
     7.191   105.535     0.150
     7.640   109.535     0.150
     7.640   191.535     0.150
     7.634   109.934     0.150
     7.634   189.535     0.150
     7.770   111.836     0.150
     7.803   113.137     0.150
     8.273   123.035     0.150
     8.380   121.535     0.150
     8.380   135.535     0.150
     8.380   210.535     0.150
     8.309   120.035     0.150
     8.837   126.637     0.150
     8.916   126.637     0.150
     8.927   131.035     0.150
     9.072   129.637     0.150
     9.257   131.434     0.150
     9.257   227.535     0.150
     9.959   140.934     0.150
     9.959   246.336     0.150
    10.028   141.336     0.150
    10.028   246.734     0.150
    10.234   144.336     0.150
    10.234   251.535     0.150
    10.325   145.535     0.150
    10.548   150.336     0.150
    11.506   164.934     0.150
    11.506   287.234     0.150
    18.508   256.035     0.150
     0.108     2.557     0.150
     0.226     4.156     0.150
     0.497     9.057     0.150
     1.217    22.057     0.150
     1.282    23.057     0.150
     1.453    26.357     0.150
     1.453    46.057     0.150
     1.912    34.557     0.150
     1.984    33.557     0.150
     2.148    37.557     0.150
     3.133    53.557     0.150
     3.134    50.557     0.150
     3.213    52.557     0.150
     3.213    91.557     0.150
     3.381    53.857     0.150
     3.381    93.557     0.150
     3.422    53.756     0.150
     3.422    93.557     0.150
     3.680    58.557     0.150
     3.667    58.057     0.150
     3.667   102.557     0.150
     3.760    59.057     0.150
     3.760   103.557     0.150
     3.888    63.357     0.150
     3.888   107.057     0.150
     4.070    63.957     0.150
     4.175    62.957     0.150
     4.118    63.457     0.150
     4.118   108.656     0.150
     4.128    63.656     0.150
     4.128   112.457     0.150
     4.167    65.057     0.150
     4.180    65.357     0.150
     4.302    68.156     0.150
     4.302   119.557     0.150
     4.319    68.057     0.150
     4.319   120.057     0.150
     4.338    67.457     0.150
     4.343    68.357     0.150
     4.405    68.857     0.150
     4.432    67.557     0.150
     4.432    71.256     0.150
     4.435    67.656     0.150
     4.580    71.156     0.150
     4.641    74.357     0.150
     4.842    72.057     0.150
     4.857    73.756     0.150
     4.862    75.357     0.150
     4.894    75.156     0.150
     4.976    77.557     0.150
     5.328    80.557     0.150
     5.328   141.557     0.150
     5.513   108.256     0.150
     5.513   145.156     0.150
     5.511    84.057     0.150
     5.744    86.057     0.150
     5.901    87.557     0.150
     5.979   148.557     0.150
     6.008    89.957     0.150
     6.198    94.357     0.150
     6.198    91.557     0.150
     6.240    92.557     0.150
     6.316    93.256     0.150
     6.316   163.557     0.150
     6.481    96.557     0.150
     6.633    97.557     0.150
     6.633   171.557     0.150
     7.540   108.557     0.150
     7.540   191.557     0.150
     7.604   112.057     0.150
     8.381   210.557     0.150
     0.708    13.684     0.150
     1.260    22.783     0.150
     1.260    40.783     0.150
     1.366    23.084     0.150
     1.499    26.885     0.150
     1.754    28.084     0.150
     1.963    33.984     0.150
     2.025    33.584     0.150
     2.044    33.584     0.150
     2.286    37.584     0.150
     2.267    36.484     0.150
     2.468    37.584     0.150
     2.533    40.885     0.150
     2.624    43.084     0.150
     2.624    72.084     0.150
     2.633    40.783     0.150
     2.852    45.084     0.150
     2.774    48.385     0.150
     2.957    46.584     0.150
     2.957    78.084     0.150
     3.011    47.084     0.150
     3.107    48.385     0.150
     3.147    48.385     0.150
     3.445    52.084     0.150
     3.522    57.584     0.150
     3.522    99.084     0.150
     3.506    55.084     0.150
     3.461    53.283     0.150
     3.685    55.584     0.150
     3.867    58.484     0.150
     3.867   100.084     0.150
     3.825    58.584     0.150
     3.927    58.684     0.150
     3.948    57.184     0.150
     3.891    58.084     0.150
     4.078    61.385     0.150
     4.156    62.184     0.150
     4.156   105.984     0.150
     4.059    61.684     0.150
     4.233    62.385     0.150
     4.233   109.885     0.150
     4.183    63.684     0.150
     4.554    78.084     0.150
     4.841    71.283     0.150
     4.841   126.084     0.150
     5.065    73.885     0.150
     5.343    78.084     0.150
     5.343    90.484     0.150
     5.343   137.184     0.150
     5.457    80.084     0.150
     5.515    81.385     0.150
     5.598    80.584     0.150
     5.503    80.684     0.150
     5.730    83.484     0.150
     5.727    83.584     0.150
     5.712    83.684     0.150
     5.824    85.283     0.150
     5.855    85.084     0.150
     5.970    87.084     0.150
     5.970   152.184     0.150
     5.943    87.283     0.150
     5.943   155.084     0.150
     5.881    87.084     0.150
     6.041    89.885     0.150
     6.165    88.783     0.150
     6.214    90.684     0.150
     6.214   157.684     0.150
     6.256    89.885     0.150
     6.256   153.783     0.150
     6.305    91.984     0.150
     6.305   164.084     0.150
     6.287    93.084     0.150
     6.601    96.084     0.150
     6.686    98.084     0.150
     6.660    96.283     0.150
     6.725    95.283     0.150
     6.787    99.084     0.150
     6.826   100.184     0.150
     7.062   101.385     0.150
     7.169   101.684     0.150
     7.309   104.584     0.150
     7.309   183.084     0.150
     7.338   105.885     0.150
     7.493   108.084     0.150
     7.594   108.684     0.150
     7.553   189.184     0.150
     8.082   201.084     0.150
     8.278   139.084     0.150
     8.278   206.084     0.150
     8.461   119.084     0.150
     8.470   125.084     0.150
     8.625   121.484     0.150
     8.625   212.584     0.150
     8.800   123.684     0.150
     8.800   216.484     0.150
     9.494   133.084     0.150
     9.494   233.084     0.150
     9.563   133.283     0.150
     9.563   236.084     0.150
     9.769   136.283     0.150
     9.769   239.885     0.150
     9.860   137.885     0.150
     9.884   138.283     0.150
     9.884   242.283     0.150
    10.083   140.885     0.150
    10.083   248.084     0.150
    21.790   288.684     0.150
    23.432   305.084     0.150
     0.377     7.867     0.150
     0.377    13.969     0.150
     0.527     9.766     0.150
     0.760    15.070     0.150
     0.760    25.469     0.150
     1.535    26.969     0.150
     1.672    28.469     0.150
     1.735    30.469     0.150
     1.934    31.766     0.150
     2.677    43.469     0.150
     2.740    42.969     0.150
     3.189    49.469     0.150
     3.144    48.969     0.150
     3.317    51.469     0.150
     3.377    52.469     0.150
     3.643    72.469     0.150
     3.631    56.266     0.150
     3.631    97.969     0.150
     3.664    57.172     0.150
     3.664    98.469     0.150
     3.727    58.969     0.150
     3.736    58.266     0.150
     3.925    60.969     0.150
     3.925   126.469     0.150
     4.049   108.367     0.150
     4.131    63.969     0.150
     4.131   111.469     0.150
     4.209    65.469     0.150
     4.221    65.266     0.150
     4.258    64.867     0.150
     4.260    66.070     0.150
     4.376    67.367     0.150
     4.557    67.867     0.150
     4.557   120.469     0.150
     4.596    68.969     0.150
     4.596   121.766     0.150
     4.610   117.570     0.150
     4.778    89.469     0.150
     4.899    73.570     0.150
     4.899   126.672     0.150
     4.918    72.570     0.150
     4.918   127.570     0.150
     5.149    77.469     0.150
     5.355    79.969     0.150
     5.447    81.469     0.150
     5.463    82.969     0.150
     5.995    88.969     0.150
     6.008    89.570     0.150
     6.008    99.266     0.150
     6.413    92.672     0.150
     6.699    98.867     0.150
     6.753    97.469     0.150
     7.284   107.469     0.150
     8.023   115.469     0.150
     8.023   203.469     0.150
     8.845   221.469     0.150
     8.964   127.570     0.150
     0.747    13.844     0.150
     1.226    21.547     0.150
     1.226    38.047     0.150
     1.521    25.445     0.150
     1.616    28.047     0.150
     1.616    50.047     0.150
     2.043    33.047     0.150
     2.075    35.344     0.150
     2.155    34.047     0.150
     2.199    37.547     0.150
     2.232    40.367     0.150
     2.340    39.047     0.150
     2.371    44.047     0.150
     2.450    39.047     0.150
     2.542    40.047     0.150
     2.585    40.945     0.150
     3.039    49.047     0.150
     3.317    51.547     0.150
     3.457    54.547     0.150
     3.457    95.047     0.150
     3.481    55.047     0.150
     3.481    93.047     0.150
     3.466    54.047     0.150
     3.689    57.547     0.150
     3.747    61.648     0.150
     3.753    57.750     0.150
     3.753    67.750     0.150
     3.753   107.047     0.150
     3.753   112.648     0.150
     3.929    61.844     0.150
     4.074    63.250     0.150
     4.053    64.547     0.150
     4.053    71.047     0.150
     4.053   108.047     0.150
     4.092    63.547     0.150
     4.138    61.648     0.150
     4.138    61.750     0.150
     4.170    62.750     0.150
     4.218    66.250     0.150
     4.245    64.547     0.150
     4.341    65.445     0.150
     4.341    74.547     0.150
     4.341   113.945     0.150
     4.480    69.547     0.150
     4.480    82.844     0.150
     4.480   118.547     0.150
     4.480   130.344     0.150
     4.879    72.445     0.150
     4.957    75.148     0.150
     4.996    91.445     0.150
     5.095    75.047     0.150
     5.095   131.547     0.150
     5.208    76.547     0.150
     5.251    77.547     0.150
     5.316    80.047     0.150
     5.363    79.648     0.150
     5.533    81.648     0.150
     5.533   108.750     0.150
     5.533   145.844     0.150
     5.630    83.047     0.150
     5.781    84.250     0.150
     5.850    85.844     0.150
     5.887    87.250     0.150
     5.909    87.047     0.150
     5.909   149.047     0.150
     5.923    86.945     0.150
     5.958    88.359     0.150
     6.097    90.344     0.150
     6.155    90.648     0.150
     6.154    90.047     0.150
     6.154   100.148     0.150
     6.154   157.445     0.150
     6.203    92.047     0.150
     6.232    92.844     0.150
     6.242    91.945     0.150
     6.259    93.344     0.150
     6.344    91.547     0.150
     6.393   107.547     0.150
     6.402    94.344     0.150
     6.438    93.445     0.150
     6.438   161.250     0.150
     6.455    95.844     0.150
     6.530    97.047     0.150
     6.541    95.047     0.150
     6.541   105.047     0.150
     6.549   108.148     0.150
     6.656    94.914     0.150
     6.688    97.391     0.150
     6.735    98.844     0.150
     6.780    99.148     0.150
     6.790   130.047     0.150
     6.788   100.344     0.150
     6.874   101.844     0.150
     6.903   100.547     0.150
     6.918   102.547     0.150
     6.927   117.047     0.150
     7.016   103.648     0.150
     7.060   102.695     0.150
     7.080    99.930     0.150
     7.238   104.445     0.150
     7.335   105.648     0.150
     7.356   105.750     0.150
     7.494   108.250     0.150
     7.494   188.945     0.150
     7.511   109.250     0.150
     7.605   111.844     0.150
     7.609   109.047     0.150
     7.624   110.547     0.150
     8.261   119.047     0.150
     8.261   206.047     0.150
     8.471   136.047     0.150
     8.471   209.047     0.150
     8.646   122.648     0.150
     8.814   126.047     0.150
     8.814   216.047     0.150
     8.985   127.250     0.150
     8.985   220.750     0.150
     9.111   133.047     0.150
     9.182   261.047     0.150
     9.280   135.047     0.150
     9.280   230.047     0.150
     9.661   136.344     0.150
     9.734   137.250     0.150
     9.734   240.547     0.150
     9.942   139.547     0.150
     9.942   244.547     0.150
    10.027   141.344     0.150
    10.233   255.445     0.150
    10.252   147.047     0.150
    11.247   281.148     0.150
    11.247   162.750     0.150
    19.305   262.250     0.150
    21.939   290.047     0.150
    23.581   309.047     0.150
    37.259   430.250     0.150
     0.183     3.867     0.150
     0.307     6.570     0.150
     0.670    12.570     0.150
     0.670    23.570     0.150
     0.923    16.570     0.150
     1.126    20.469     0.150
     1.142    22.070     0.150
     1.355    25.367     0.150
     1.371    24.773     0.150
     1.730    29.273     0.150
     1.821    30.570     0.150
     1.826    31.070     0.150
     1.946    32.969     0.150
     2.079    34.570     0.150
     2.221    40.773     0.150
     2.247    36.367     0.150
     2.325    39.070     0.150
     2.404    38.672     0.150
     2.384    38.570     0.150
     2.384    66.570     0.150
     2.577    42.570     0.150
     2.747    47.867     0.150
     2.842    45.867     0.150
     2.879    46.773     0.150
     3.232    51.570     0.150
     3.283    51.570     0.150
     3.283    89.570     0.150
     3.585    55.570     0.150
     3.732    59.070     0.150
     3.732   103.070     0.150
     3.833    59.570     0.150
     3.833   103.172     0.150
     3.920    62.570     0.150
     3.920   106.070     0.150
     3.981    61.672     0.150
     4.064    60.867     0.150
     4.084    81.070     0.150
     4.084   111.570     0.150
     4.176    65.570     0.150
     4.176   115.070     0.150
     4.380    65.969     0.150
     4.380   115.969     0.150
     4.392    69.570     0.150
     4.392   116.570     0.150
     4.374    68.070     0.150
     4.374   119.570     0.150
     4.386    68.570     0.150
     4.386   119.570     0.150
     4.435    66.969     0.150
     4.771    71.570     0.150
     4.766    71.570     0.150
     4.766   122.773     0.150
     4.807    72.570     0.150
     4.983    76.367     0.150
     5.046    74.469     0.150
     5.046   129.070     0.150
     5.456    81.969     0.150
     5.938    88.070     0.150
     6.073    90.469     0.150
     6.193    92.773     0.150
     6.284    94.273     0.150
     7.488   108.773     0.150
     7.488   119.570     0.150
     7.488   191.070     0.150
     8.350   119.570     0.150
     0.709    14.453     0.150
     0.922    16.852     0.150
     0.922    29.852     0.150
     1.168    21.352     0.150
     1.314    22.652     0.150
     1.587    26.754     0.150
     1.670    27.352     0.150
     1.582    26.652     0.150
     1.699    29.551     0.150
     1.668    27.852     0.150
     1.862    30.551     0.150
     1.862    56.254     0.150
     1.788    31.953     0.150
     2.000    32.352     0.150
     1.903    32.152     0.150
     2.084    36.051     0.150
     2.188    34.953     0.150
     2.380    38.453     0.150
     2.485    38.852     0.150
     2.554    42.953     0.150
     2.716    41.152     0.150
     2.642    45.262     0.150
     2.655    41.953     0.150
     2.997    45.953     0.150
     3.032    49.152     0.150
     3.061    46.754     0.150
     3.061    84.152     0.150
     3.231    48.852     0.150
     3.231    88.254     0.150
     3.299    49.754     0.150
     3.299    89.652     0.150
     3.542    53.152     0.150
     3.444    52.551     0.150
     3.444    93.652     0.150
     3.550    53.852     0.150
     3.550    95.652     0.150
     3.579    54.352     0.150
     3.579    97.152     0.150
     3.648    57.852     0.150
     3.736    61.152     0.150
     3.835    58.754     0.150
     4.053    60.453     0.150
     4.053   107.652     0.150
     4.180    60.551     0.150
     4.180   109.051     0.150
     4.124    61.453     0.150
     4.124   110.352     0.150
     4.246    63.652     0.150
     4.177    62.254     0.150
     4.177   110.953     0.150
     4.281    62.652     0.150
     4.367   111.852     0.150
     4.542    67.453     0.150
     4.595    70.152     0.150
     4.618    67.051     0.150
     4.542    68.254     0.150
     4.833    71.152     0.150
     4.896    73.152     0.150
     4.923    72.551     0.150
     4.923   126.453     0.150
     5.060    75.852     0.150
     5.400    78.352     0.150
     5.635    80.652     0.150
     5.917    85.652     0.150
     6.017    88.152     0.150
     6.017    89.551     0.150
     6.017   117.754     0.150
     6.017   154.754     0.150
     6.017   192.652     0.150
     6.071    89.152     0.150
     6.492    93.652     0.150
     6.518    93.152     0.150
     6.518    96.152     0.150
     6.518   167.953     0.150
     6.591    96.254     0.150
     6.591   168.953     0.150
     6.657    96.254     0.150
     6.711    99.352     0.150
     7.236   136.652     0.150
     7.292   105.352     0.150
     8.027   114.953     0.150
     8.027   132.152     0.150
     8.027   200.152     0.150
     8.027   203.152     0.150
     8.107   115.754     0.150
     8.841   221.352     0.150
     9.009   127.551     0.150
    10.235   144.551     0.150
     0.205     4.883     0.150
     0.205     8.078     0.150
     0.664    11.781     0.150
     1.077    21.281     0.150
     1.077    39.281     0.150
     1.254    23.281     0.150
     1.254    40.281     0.150
     1.475    26.578     0.150
     1.495    26.578     0.150
     1.494    27.883     0.150
     1.494    49.281     0.150
     1.539    27.281     0.150
     1.539    49.180     0.150
     1.710    30.180     0.150
     1.710    51.281     0.150
     1.722    30.578     0.150
     1.722    55.281     0.150
     1.918    36.281     0.150
     1.918    57.484     0.150
     1.991    36.078     0.150
     2.015    36.383     0.150
     2.015    65.484     0.150
     2.024    34.484     0.150
     2.143    36.281     0.150
     2.139    38.078     0.150
     2.122    36.484     0.150
     2.173    40.078     0.150
     2.349    40.383     0.150
     2.430    42.680     0.150
     2.561    41.078     0.150
     2.764    44.883     0.150
     2.872    47.078     0.150
     3.005    49.484     0.150
     3.005    84.180     0.150
     3.158    51.383     0.150
     3.198    51.383     0.150
     3.195    52.078     0.150
     3.195    89.281     0.150
     3.203    51.883     0.150
     3.203    88.484     0.150
     3.459    55.484     0.150
     3.459    94.078     0.150
     3.471    56.180     0.150
     3.471    95.781     0.150
     3.545    56.883     0.150
     3.545    96.984     0.150
     3.608    57.781     0.150
     3.805    59.383     0.150
     3.790    62.883     0.150
     3.923    60.984     0.150
     3.917    60.781     0.150
     3.940    62.680     0.150
     3.940   107.078     0.150
     4.006    62.883     0.150
     4.006   109.578     0.150
     4.089    64.484     0.150
     4.089   110.180     0.150
     4.116    64.883     0.150
     4.116   110.781     0.150
     4.220    72.781     0.150
     4.237    65.484     0.150
     4.236    65.781     0.150
     4.339    67.484     0.150
     4.339   118.281     0.150
     4.338    68.281     0.150
     4.411    69.781     0.150
     4.486    69.883     0.150
     4.523    70.281     0.150
     4.523   121.781     0.150
     4.544    70.781     0.150
     4.544   120.180     0.150
     4.642    72.578     0.150
     4.757    73.844     0.150
     4.757   128.961     0.150
     5.023    75.180     0.150
     5.092    76.984     0.150
     5.092   135.781     0.150
     5.124    79.641     0.150
     5.124   134.805     0.150
     5.252    78.078     0.150
     5.373   144.281     0.150
     5.566    82.984     0.150
     5.636    84.781     0.150
     5.636   111.281     0.150
     5.636   150.984     0.150
     5.815    87.781     0.150
     5.864    88.484     0.150
     5.864   153.078     0.150
     5.951    90.281     0.150
     6.108    92.602     0.150
     6.108   160.039     0.150
     6.136    94.281     0.150
     6.136   162.578     0.150
     6.136   165.883     0.150
     6.211    93.781     0.150
     6.211   101.180     0.150
     6.211   165.078     0.150
     6.260    92.078     0.150
     6.212    93.641     0.150
     6.298    93.680     0.150
     6.375    97.000     0.150
     6.433    95.578     0.150
     6.598    98.242     0.150
     6.738   100.562     0.150
     6.988   101.484     0.150
     7.010   102.484     0.150
     7.034   104.523     0.150
     7.159   106.320     0.150
     7.649   112.281     0.150
     7.649   197.781     0.150
     8.437   122.680     0.150
     8.649   124.383     0.150
     8.649   218.281     0.150
     8.771   127.781     0.150
     8.771   222.078     0.150
     9.856   315.281     0.150
     0.600    11.430     0.150
     0.600    20.430     0.150
     1.062    18.930     0.150
     1.062    35.133     0.150
     1.077    20.133     0.150
     1.441    24.727     0.150
     1.292    23.328     0.150
     1.292    39.633     0.150
     1.531    26.328     0.150
     1.531    46.828     0.150
     1.453    24.430     0.150
     1.453    47.430     0.150
     1.608    27.133     0.150
     1.872    30.930     0.150
     1.880    30.930     0.150
     1.732    28.727     0.150
     1.959    35.328     0.150
     1.961    32.930     0.150
     1.784    28.133     0.150
     2.252    37.227     0.150
     2.350    37.531     0.150
     2.227    36.531     0.150
     2.350    38.727     0.150
     2.350    65.430     0.150
     2.508    39.531     0.150
     2.508    72.828     0.150
     2.499    41.031     0.150
     2.675    42.031     0.150
     2.675    76.531     0.150
     2.661    41.328     0.150
     2.722    42.633     0.150
     2.722    77.828     0.150
     2.907    47.531     0.150
     2.907    78.930     0.150
     2.722    42.328     0.150
     2.985    46.828     0.150
     2.959    46.430     0.150
     2.959    83.531     0.150
     3.008    46.633     0.150
     3.008    84.633     0.150
     3.216    50.727     0.150
     3.058    47.633     0.150
     3.058    84.633     0.150
     3.270    51.820     0.150
     3.199    48.930     0.150
     3.163    51.281     0.150
     3.416    53.930     0.150
     3.416    94.133     0.150
     3.368    52.828     0.150
     3.651    55.930     0.150
     3.521    53.930     0.150
     3.598    56.828     0.150
     3.598    98.930     0.150
     3.611    56.930     0.150
     3.611    99.031     0.150
     3.927    60.828     0.150
     3.927    61.430     0.150
     3.927   101.930     0.150
     3.997    58.930     0.150
     3.997    69.430     0.150
     3.997   102.930     0.150
     3.830    58.031     0.150
     4.013    61.328     0.150
     4.013   106.930     0.150
     4.047    61.133     0.150
     4.047   105.328     0.150
     4.090    61.531     0.150
     3.943    59.930     0.150
     4.220    63.430     0.150
     4.220   110.430     0.150
     4.286    64.227     0.150
     4.286   112.133     0.150
     4.082    62.430     0.150
     4.127    63.031     0.150
     4.375    66.633     0.150
     4.375   116.930     0.150
     4.671    70.430     0.150
     4.739    70.031     0.150
     4.645    70.133     0.150
     4.645   120.430     0.150
     4.922    71.531     0.150
     4.922   125.430     0.150
     5.056    73.227     0.150
     5.064    74.031     0.150
     5.119    76.930     0.150
     5.188    77.930     0.150
     5.688    83.633     0.150
     5.520    81.430     0.150
     5.845    85.930     0.150
     5.775    84.828     0.150
     5.985    88.031     0.150
     5.985   156.430     0.150
     5.874    87.430     0.150
     6.067    88.930     0.150
     6.067   156.531     0.150
     6.062    89.633     0.150
     6.062   154.227     0.150
     6.083    89.227     0.150
     6.100    92.531     0.150
     5.979    88.430     0.150
     6.215    90.828     0.150
     6.227    91.328     0.150
     6.227   160.031     0.150
     6.247    89.727     0.150
     6.457    92.328     0.150
     6.483   105.031     0.150
     6.541    96.531     0.150
     6.374    93.430     0.150
     6.596    96.633     0.150
     6.688    98.328     0.150
     6.708    95.633     0.150
     6.724    97.828     0.150
     6.988   103.391     0.150
     7.042   100.828     0.150
     7.074   101.328     0.150
     7.074   177.633     0.150
     7.137   101.727     0.150
     7.158   102.031     0.150
     7.158   178.633     0.150
     7.370   105.430     0.150
     7.370   184.930     0.150
     7.595   109.430     0.150
     8.151   202.430     0.150
     8.457   119.031     0.150
     8.457   209.633     0.150
     8.630   121.930     0.150
     8.630   212.727     0.150
     8.583   126.430     0.150
     8.796   123.727     0.150
     8.796   216.727     0.150
     9.140   226.531     0.150
     9.463   132.930     0.150
     9.463   233.133     0.150
     9.536   133.633     0.150
     9.536   233.430     0.150
     9.745   136.531     0.150
     9.745   239.531     0.150
     9.829   137.328     0.150
     9.829   241.828     0.150
     9.857   137.930     0.150
     9.857   242.227     0.150
    10.049   141.227     0.150
    10.049   248.930     0.150
    19.369   263.430     0.150
     0.733    14.969     0.150
     0.733    25.469     0.150
     1.122    22.170     0.150
     1.022    18.770     0.150
     1.189    22.969     0.150
     1.189    39.770     0.150
     1.510    26.869     0.150
     1.510    47.869     0.150
     1.699    31.270     0.150
     1.767    30.570     0.150
     1.767    54.570     0.150
     1.700    30.969     0.150
     1.740    32.270     0.150
     2.041    34.969     0.150
     2.041    60.570     0.150
     2.202    38.070     0.150
     2.039    36.270     0.150
     2.039    60.670     0.150
     2.185    39.770     0.150
     2.538    43.570     0.150
     2.381    39.670     0.150
     2.856    48.740     0.150
     3.280    53.070     0.150
     3.209    57.770     0.150
     3.341    52.969     0.150
     3.517    57.369     0.150
     3.568    57.869     0.150
     3.416    57.270     0.150
     3.535    56.770     0.150
     3.699    59.170     0.150
     3.926    61.869     0.150
     3.926   106.969     0.150
     4.069    64.969     0.150
     4.204    67.270     0.150
     4.344    67.570     0.150
     4.344   117.369     0.150
     4.335    68.869     0.150
     4.257    66.590     0.150
     4.511    69.270     0.150
     4.511   120.570     0.150
     4.588    70.270     0.150
     4.588    71.469     0.150
     4.588   122.770     0.150
     4.511    71.770     0.150
     4.557    71.129     0.150
     5.367    80.270     0.150
     5.367   139.670     0.150
     5.375    80.170     0.150
     5.411    82.469     0.150
     5.555    84.549     0.150
     5.735    87.770     0.150
     5.876    89.770     0.150
     5.860    89.369     0.150
     6.299    97.270     0.150
     6.299   168.369     0.150
     6.223    93.770     0.150
     6.454    94.969     0.150
     6.478    96.969     0.150
     6.722   111.670     0.150
     6.959   103.770     0.150
     7.368   107.469     0.150
     7.368   106.369     0.150
     7.368   187.670     0.150
     7.664   111.270     0.150
     7.664   128.770     0.150
     7.664   194.770     0.150
     8.766   219.469     0.150
     8.943   128.969     0.150
     8.943   223.570     0.150
     9.105   130.670     0.150
     9.105   227.270     0.150
    10.038   143.270     0.150
    10.038   251.670     0.150
    18.610   254.770     0.150
     0.707    12.141     0.150
     0.707    23.438     0.150
     0.975    18.234     0.150
     1.079    20.727     0.150
     1.194    22.234     0.150
     1.401    24.836     0.150
     1.691    29.734     0.150
     1.677    28.539     0.150
     1.706    30.938     0.150
     1.886    31.539     0.150
     1.886    58.938     0.150
     2.013    33.039     0.150
     2.029    32.938     0.150
     2.009    34.438     0.150
     2.158    35.938     0.150
     2.269    39.641     0.150
     2.388    37.836     0.150
     2.383    40.141     0.150
     2.539    41.438     0.150
     2.823    47.195     0.150
     3.227    49.234     0.150
     3.283    51.438     0.150
     3.245    52.938     0.150
     3.287    51.039     0.150
     3.373    53.641     0.150
     3.573    54.938     0.150
     3.496    54.641     0.150
     3.846    57.141     0.150
     3.846   102.539     0.150
     3.819    59.438     0.150
     3.970    60.539     0.150
     4.098    63.039     0.150
     4.313   114.641     0.150
     4.336    63.938     0.150
     4.336   114.641     0.150
     4.267    64.758     0.150
     4.392    75.141     0.150
     4.392   114.336     0.150
     4.551    67.734     0.150
     4.551   118.438     0.150
     4.550    69.938     0.150
     4.624    68.734     0.150
     4.624   150.938     0.150
     5.320    79.297     0.150
     5.397    77.938     0.150
     5.388    78.438     0.150
     5.405    80.539     0.150
     5.568    84.039     0.150
     5.733    84.641     0.150
     5.733   151.234     0.150
     6.326    94.938     0.150
     6.326   166.438     0.150
     7.407   105.836     0.150
     7.407   105.734     0.150
     7.407   186.141     0.150
     7.703   109.438     0.150
     7.703   123.438     0.150
     7.703   193.438     0.150
     8.476   210.938     0.150
     8.778   124.734     0.150
     8.778   218.039     0.150
     8.958   126.938     0.150
     9.116   128.938     0.150
     9.116   225.336     0.150
    10.040   143.539     0.150
    10.040   250.641     0.150
    18.653   258.734     0.150
    20.965   281.539     0.150
    36.303   424.438     0.150
    58.642   596.938     0.150
     1.296    23.203     0.150
     1.296    41.305     0.150
     1.363    23.805     0.150
     1.363    40.305     0.150
     1.455    25.406     0.150
     1.533    28.000     0.150
     1.533    47.203     0.150
     1.666    28.602     0.150
     1.666    50.703     0.150
     1.782    31.703     0.150
     1.913    34.406     0.150
     1.913    56.703     0.150
     1.900    33.203     0.150
     2.038    34.703     0.150
     2.069    34.305     0.150
     2.159    37.203     0.150
     2.159    61.703     0.150
     2.241    36.500     0.150
     2.241    61.703     0.150
     2.281    39.000     0.150
     2.278    37.406     0.150
     2.349    39.203     0.150
     2.359    38.703     0.150
     2.438    41.305     0.150
     2.450    44.805     0.150
     2.542    42.203     0.150
     2.536    70.602     0.150
     2.577    42.102     0.150
     2.609    42.500     0.150
     2.609    71.102     0.150
     2.692    44.703     0.150
     2.746    44.203     0.150
     2.730    44.102     0.150
     2.888    50.602     0.150
     2.995    47.953     0.150
     3.030    49.203     0.150
     3.040    49.500     0.150
     3.049    49.703     0.150
     3.152    51.102     0.150
     3.152    84.500     0.150
     3.294    52.203     0.150
     3.411    53.805     0.150
     3.628    57.602     0.150
     3.638    55.906     0.150
     3.687    58.000     0.150
     3.673    57.102     0.150
     3.673    98.406     0.150
     3.677    64.000     0.150
     3.739    58.500     0.150
     3.739   100.500     0.150
     3.716    57.406     0.150
     3.716    98.406     0.150
     3.776    59.203     0.150
     3.947    68.203     0.150
     4.037    62.500     0.150
     4.048    63.203     0.150
     4.117    63.102     0.150
     4.117   127.102     0.150
     4.172    73.703     0.150
     4.278    66.102     0.150
     4.375    67.500     0.150
     4.360    66.703     0.150
     4.360   113.703     0.150
     4.481    68.102     0.150
     4.481   116.805     0.150
     4.472    67.500     0.150
     4.472   116.203     0.150
     4.868    72.102     0.150
     5.152    77.805     0.150
     5.230    77.102     0.150
     5.290    77.805     0.150
     5.299    78.805     0.150
     5.327    80.203     0.150
     5.431    80.203     0.150
     5.544    83.406     0.150
     5.661    85.406     0.150
     5.661   147.203     0.150
     6.138    90.602     0.150
     6.249    92.000     0.150
     6.249   162.000     0.150
     6.331    93.703     0.150
     6.331   165.406     0.150
     6.365    94.102     0.150
     6.365   165.203     0.150
     6.387    95.203     0.150
     6.508    96.703     0.150
     6.508   168.602     0.150
     6.530    97.203     0.150
     6.634    96.203     0.150
     6.857   101.203     0.150
     7.047   104.000     0.150
     7.072   104.406     0.150
     7.200   107.203     0.150
     7.217   104.906     0.150
     7.217   104.305     0.150
     7.217   181.602     0.150
     7.454   107.305     0.150
     7.506   111.102     0.150
     7.506   187.805     0.150
     7.514   109.203     0.150
     7.514   187.203     0.150
     7.572   108.000     0.150
     7.592   108.906     0.150
     8.540   215.500     0.150
     8.828   126.000     0.150
     8.977   128.305     0.150
     9.895   140.102     0.150
     9.895   241.703     0.150
     9.960   140.500     0.150
    10.164   143.602     0.150
    10.164   145.000     0.150
    10.164   252.000     0.150
    10.261   146.305     0.150
    10.283   145.000     0.150
    10.283   250.305     0.150
    10.488   147.203     0.150
    10.488   256.406     0.150
    18.409   252.805     0.150
    18.417   251.602     0.150
    20.632   277.500     0.150
    28.264   350.000     0.150
    89.897   779.406     0.150
     1.310    23.855     0.150
     1.441    24.953     0.150
     1.366    23.555     0.150
     1.366    40.754     0.150
     1.680    28.254     0.150
     1.916    33.254     0.150
     1.792    31.945     0.150
     2.057    34.754     0.150
     2.171    36.652     0.150
     2.442    41.254     0.150
     2.265    39.152     0.150
     2.257    37.754     0.150
     2.257    61.355     0.150
     2.693    44.652     0.150
     2.529    42.953     0.150
     2.527    41.652     0.150
     2.527    68.055     0.150
     2.598    43.152     0.150
     2.598    69.855     0.150
     2.721    49.754     0.150
     3.016    49.953     0.150
     3.016    81.953     0.150
     3.006    49.152     0.150
     3.033    54.953     0.150
     3.141    50.953     0.150
     3.141    83.855     0.150
     3.170    51.555     0.150
     3.170    84.453     0.150
     3.686    57.754     0.150
     3.663    56.953     0.150
     3.663    98.453     0.150
     3.728    58.855     0.150
     3.728    57.055     0.150
     3.770    59.152     0.150
     4.025    62.754     0.150
     4.104    62.555     0.150
     4.350    66.254     0.150
     4.350   112.254     0.150
     4.164    74.254     0.150
     4.462    67.055     0.150
     4.462   115.953     0.150
     4.273    65.254     0.150
     5.224    76.652     0.150
     5.052    83.652     0.150
     5.427    79.855     0.150
     5.544    83.152     0.150
     5.295    78.754     0.150
     5.660    84.953     0.150
     6.022    88.855     0.150
     6.241    92.453     0.150
     6.241   163.254     0.150
     6.324    93.855     0.150
     6.324   163.555     0.150
     6.324   165.555     0.150
     6.546    94.953     0.150
     6.572    97.152     0.150
     6.631    96.254     0.150
     7.043   104.453     0.150
     7.207   104.355     0.150
     7.207   103.855     0.150
     7.207   181.855     0.150
     7.502   110.652     0.150
     7.572   109.055     0.150
     7.572   186.855     0.150
     7.731   112.754     0.150
     8.973   128.855     0.150
     8.973   221.453     0.150
     9.166   130.754     0.150
     9.166   224.754     0.150
     9.895   139.754     0.150
     9.895   242.055     0.150
     9.959   243.754     0.150
    10.163   144.754     0.150
    10.163   248.152     0.150
    10.163   250.254     0.150
    10.488   148.953     0.150
    19.144   263.555     0.150
    20.618   277.754     0.150
    28.251   350.453     0.150
     1.167    20.605     0.150
     1.371    25.137     0.150
     1.443    25.406     0.150
     1.367    23.008     0.150
     1.550    25.906     0.150
     1.705    29.207     0.150
     1.865    32.406     0.150
     2.072    34.605     0.150
     2.383    39.207     0.150
     2.190    35.207     0.150
     2.190    61.605     0.150
     2.381    38.207     0.150
     2.381    65.406     0.150
     2.409    38.406     0.150
     2.409    67.707     0.150
     2.670    43.406     0.150
     2.748    43.309     0.150
     2.636    42.008     0.150
     2.636    71.809     0.150
     2.668    42.906     0.150
     2.668    73.406     0.150
     2.724    43.508     0.150
     2.724    74.105     0.150
     2.905    46.688     0.150
     3.089    46.605     0.150
     3.301    51.508     0.150
     3.162    49.809     0.150
     3.162    86.105     0.150
     3.398    52.508     0.150
     3.269    51.707     0.150
     3.269    87.707     0.150
     3.305    51.809     0.150
     3.305    88.906     0.150
     3.623    56.406     0.150
     3.680    56.809     0.150
     3.519    53.707     0.150
     3.614    55.605     0.150
     3.754    56.105     0.150
     3.754    98.207     0.150
     3.661    56.406     0.150
     3.837    58.309     0.150
     3.837   101.008     0.150
     3.850    59.605     0.150
     4.104    62.727     0.150
     4.226    63.207     0.150
     4.272    63.406     0.150
     4.272    72.508     0.150
     4.272    76.207     0.150
     4.272   110.207     0.150
     4.272   134.207     0.150
     4.464    66.707     0.150
     4.464   114.406     0.150
     4.271    72.008     0.150
     4.447    66.605     0.150
     4.447    76.707     0.150
     4.447    83.207     0.150
     4.447   114.707     0.150
     4.346    66.129     0.150
     4.384    66.707     0.150
     4.548    67.105     0.150
     4.548   117.207     0.150
     4.768    72.406     0.150
     5.070    76.285     0.150
     5.115    75.906     0.150
     5.353    77.707     0.150
     5.353   136.207     0.150
     5.448    79.406     0.150
     5.448   138.605     0.150
     5.533    82.508     0.150
     5.533   141.105     0.150
     5.356    79.508     0.150
     5.401    81.707     0.150
     5.694    85.258     0.150
     6.082    88.707     0.150
     6.189    90.309     0.150
     6.417    94.809     0.150
     6.552    94.309     0.150
     6.552   164.605     0.150
     6.596    96.207     0.150
     6.642    95.508     0.150
     6.585   212.008     0.150
     6.569    96.406     0.150
     6.868    97.707     0.150
     6.868   172.809     0.150
     6.963   102.207     0.150
     7.016   101.906     0.150
     7.068   103.406     0.150
     7.146   104.906     0.150
     7.146   179.605     0.150
     7.305   105.508     0.150
     7.305   116.809     0.150
     7.305   105.406     0.150
     7.450   107.008     0.150
     7.522   109.707     0.150
     7.555   107.008     0.150
     7.555   186.105     0.150
     7.575   107.508     0.150
     7.575   186.605     0.150
     7.725   111.508     0.150
     7.971   114.406     0.150
     8.349   161.207     0.150
     8.686   122.008     0.150
     8.845   125.105     0.150
     8.922   126.508     0.150
     9.004   127.309     0.150
     9.185   129.508     0.150
     9.185   224.105     0.150
     9.880   138.406     0.150
     9.880   241.605     0.150
     9.950   139.406     0.150
     9.950   242.508     0.150
    10.246   143.906     0.150
    10.272   143.605     0.150
    10.272   251.508     0.150
    10.468   146.707     0.150
    11.209   157.508     0.150
    20.757   281.105     0.150
    36.428   425.516     0.150
    82.560   742.207     0.150
    89.899   778.906     0.150
    96.189   812.605     0.150
     0.349     7.000     0.150
     0.349    13.500     0.150
     0.834    15.398     0.150
     0.834    27.500     0.150
     1.652    29.500     0.150
     1.669    30.398     0.150
     1.904    34.398     0.150
     1.850    32.398     0.150
     1.864    31.898     0.150
     1.975    34.598     0.150
     2.195    38.297     0.150
     2.244    39.598     0.150
     2.416    40.898     0.150
     2.722    45.000     0.150
     2.814    46.598     0.150
     2.996    50.098     0.150
     3.012    49.098     0.150
     3.012    83.297     0.150
     3.009    50.098     0.150
     3.009    84.898     0.150
     3.247    53.500     0.150
     3.269    53.098     0.150
     3.269    89.199     0.150
     3.282    53.898     0.150
     3.282    91.398     0.150
     3.354    54.398     0.150
     3.354    92.000     0.150
     3.641    56.199     0.150
     3.733    59.598     0.150
     3.756    61.000     0.150
     3.756   103.297     0.150
     3.770    58.797     0.150
     3.770   104.199     0.150
     3.898    62.000     0.150
     3.898   105.699     0.150
     3.926    62.598     0.150
     3.926   106.098     0.150
     3.945    61.797     0.150
     3.945   109.297     0.150
     4.070    64.898     0.150
     4.157    65.398     0.150
     4.330    67.398     0.150
     4.506   119.500     0.150
     4.459    70.398     0.150
     4.407    67.500     0.150
     4.484    71.797     0.150
     4.484   120.898     0.150
     4.606    71.797     0.150
     4.606   122.078     0.150
     4.524    69.598     0.150
     4.524   121.598     0.150
     4.910    76.598     0.150
     4.903    75.898     0.150
     4.945    76.320     0.150
     4.945   130.520     0.150
     5.062    75.898     0.150
     5.141    77.598     0.150
     5.349    82.598     0.150
     5.528    84.598     0.150
     5.624    85.797     0.150
     5.624    98.398     0.150
     5.681    86.000     0.150
     5.681   148.957     0.150
     5.765    87.199     0.150
     5.907    91.199     0.150
     5.963    89.199     0.150
     5.935    89.438     0.150
     5.935   153.797     0.150
     6.027    89.359     0.150
     6.027   155.957     0.150
     6.218    94.238     0.150
     6.218   162.000     0.150
     6.158    95.098     0.150
     6.158   165.898     0.150
     6.242    94.199     0.150
     6.242   164.098     0.150
     6.241    95.000     0.150
     6.241   166.398     0.150
     6.416    94.598     0.150
     6.458    97.000     0.150
     6.592    98.898     0.150
     6.553    97.520     0.150
     6.553   167.078     0.150
     6.736   100.898     0.150
     6.980   103.039     0.150
     7.110   102.398     0.150
     7.131   103.098     0.150
     7.393   108.398     0.150
     7.328   106.797     0.150
     7.328   119.000     0.150
     7.622   111.398     0.150
     7.622   194.898     0.150
     8.479   122.898     0.150
     8.427   212.398     0.150
     8.719   124.199     0.150
     8.719   217.898     0.150
     8.855   125.598     0.150
     8.855   220.398     0.150
     9.741   241.797     0.150
     0.332     6.926     0.150
     0.332    13.625     0.150
     0.369     7.486     0.150
     0.628    11.525     0.150
     0.628    22.125     0.150
     0.992    18.926     0.150
     0.992    34.926     0.150
     1.414    24.926     0.150
     1.706    29.426     0.150
     1.962    34.525     0.150
     2.112    35.525     0.150
     2.201    37.826     0.150
     2.190    38.525     0.150
     2.361    38.625     0.150
     2.449    41.125     0.150
     2.955    47.926     0.150
     3.000    47.926     0.150
     3.204    50.727     0.150
     3.258    52.926     0.150
     3.254    52.125     0.150
     3.410    53.926     0.150
     3.350    53.025     0.150
     3.471    55.926     0.150
     3.632    56.426     0.150
     3.678    57.426     0.150
     3.833    58.926     0.150
     3.833   104.926     0.150
     3.833   109.926     0.150
     3.902    63.525     0.150
     3.997    63.525     0.150
     3.997   107.826     0.150
     4.060    63.125     0.150
     4.060   109.926     0.150
     4.158    64.326     0.150
     4.215    64.727     0.150
     4.215   113.525     0.150
     4.282    65.625     0.150
     4.262    64.227     0.150
     4.327    68.926     0.150
     4.411   117.025     0.150
     4.716    73.525     0.150
     4.716   126.025     0.150
     4.722    72.125     0.150
     4.722   125.926     0.150
     4.776    73.727     0.150
     5.144    76.326     0.150
     5.247    79.986     0.150
     5.247   137.986     0.150
     5.259    80.426     0.150
     5.408    80.727     0.150
     5.808    88.826     0.150
     5.808   152.125     0.150
     5.780    85.625     0.150
     5.997    89.465     0.150
     5.997   155.346     0.150
     6.070    91.025     0.150
     6.096    90.426     0.150
     6.201    93.826     0.150
     6.213    93.906     0.150
     6.213   161.986     0.150
     6.205    90.525     0.150
     6.234    90.727     0.150
     6.275    94.727     0.150
     6.275   163.625     0.150
     6.303    94.426     0.150
     6.341    94.625     0.150
     6.341   165.525     0.150
     6.372    93.326     0.150
     6.442    97.865     0.150
     6.442   168.465     0.150
     6.459    96.525     0.150
     6.483    96.826     0.150
     6.483   170.625     0.150
     6.495    97.025     0.150
     6.587    98.727     0.150
     6.736    99.926     0.150
     6.730   100.066     0.150
     6.879   102.266     0.150
     7.238   107.625     0.150
     7.511   112.025     0.150
     7.538   109.227     0.150
     7.538   123.727     0.150
     7.538   108.426     0.150
     7.538   192.227     0.150
     7.640   111.625     0.150
     7.830   113.426     0.150
     7.830   200.426     0.150
     7.898   115.326     0.150
     8.503   123.625     0.150
     8.663   218.926     0.150
     8.671   125.625     0.150
     8.732   126.326     0.150
     8.892   132.426     0.150
     9.529   137.625     0.150
     9.529   237.926     0.150
    14.128   199.025     0.150
    18.194   253.125     0.150
    19.519   267.727     0.150
    68.766   662.926     0.150
    70.320   672.727     0.150
     0.661    12.857     0.150
     0.661    23.057     0.150
     1.096    19.557     0.150
     1.240    21.457     0.150
     1.240    38.857     0.150
     1.437    25.756     0.150
     1.437    44.057     0.150
     1.459    23.857     0.150
     1.459    44.057     0.150
     1.741    29.156     0.150
     1.832    29.756     0.150
     2.125    32.756     0.150
     2.125    60.057     0.150
     2.295    37.156     0.150
     2.292    37.357     0.150
     2.664    42.156     0.150
     2.664    76.256     0.150
     2.710    43.656     0.150
     2.825    44.457     0.150
     2.825    79.957     0.150
     2.881    44.256     0.150
     2.921    45.656     0.150
     2.921    82.357     0.150
     3.029    47.057     0.150
     3.029    85.057     0.150
     3.060    48.756     0.150
     3.160    49.256     0.150
     3.160    88.457     0.150
     3.173    49.457     0.150
     3.173    88.457     0.150
     3.195    49.756     0.150
     3.234    56.857     0.150
     3.249    56.557     0.150
     3.249   102.256     0.150
     3.421    54.557     0.150
     3.463    53.957     0.150
     3.676    56.357     0.150
     3.676   100.756     0.150
     3.715    57.457     0.150
     3.718    57.057     0.150
     3.718   101.857     0.150
     3.728    71.057     0.150
     3.778    57.756     0.150
     3.778   103.256     0.150
     3.870    59.957     0.150
     4.178    63.986     0.150
     4.597    69.518     0.150
     4.855    74.557     0.150
     4.907    72.857     0.150
     4.907   129.357     0.150
     4.920    73.656     0.150
     4.920   125.957     0.150
     5.352    79.357     0.150
     5.458    81.057     0.150
     5.513    80.057     0.150
     5.560    82.297     0.150
     5.799    86.096     0.150
     6.026   100.957     0.150
     6.026   153.857     0.150
     6.399    93.457     0.150
     6.489    94.377     0.150
     6.596   167.756     0.150
     6.628    95.736     0.150
     6.839    98.557     0.150
     6.873    99.656     0.150
     7.009   101.756     0.150
     7.439   109.557     0.150
     7.570   108.457     0.150
     7.591   108.756     0.150
     7.709   109.156     0.150
     8.005   114.557     0.150
     8.947   125.957     0.150
     8.947   222.457     0.150
     9.323   130.256     0.150
     9.323   229.557     0.150
     0.572    10.688     0.150
     0.572    20.383     0.150
     1.052    18.289     0.150
     1.052    34.086     0.150
     1.179    22.086     0.150
     1.179    37.586     0.150
     1.484    25.383     0.150
     1.619    28.188     0.150
     1.619    48.086     0.150
     1.704    28.688     0.150
     1.727    28.984     0.150
     1.727    50.984     0.150
     1.881    31.984     0.150
     1.995    34.289     0.150
     1.995    58.883     0.150
     1.917    33.086     0.150
     2.314    38.688     0.150
     2.314    66.688     0.150
     2.246    37.789     0.150
     2.246    64.086     0.150
     2.431    39.688     0.150
     2.431    69.586     0.150
     2.541    42.289     0.150
     2.601    41.688     0.150
     2.601    73.289     0.150
     2.725    45.188     0.150
     2.747    45.383     0.150
     2.989    47.984     0.150
     3.054    48.984     0.150
     3.002   109.484     0.150
     3.019    48.484     0.150
     3.055    48.398     0.150
     3.086   110.586     0.150
     3.290    52.789     0.150
     3.342    54.086     0.150
     3.213    52.086     0.150
     3.556    57.586     0.150
     3.474    54.688     0.150
     3.512    55.289     0.150
     3.512    94.086     0.150
     3.625    55.984     0.150
     3.625    98.086     0.150
     3.580    56.289     0.150
     3.628    58.484     0.150
     3.765    59.086     0.150
     3.765   123.586     0.150
     3.718    57.586     0.150
     3.718    57.586     0.150
     3.822    61.766     0.150
     3.854    60.484     0.150
     3.983    61.586     0.150
     3.912    61.086     0.150
     3.912   103.586     0.150
     3.904    61.086     0.150
     4.106    61.883     0.150
     4.125    62.883     0.150
     4.125    76.383     0.150
     4.125   110.586     0.150
     4.125   128.586     0.150
     4.078    62.984     0.150
     4.078   112.383     0.150
     4.203    63.883     0.150
     4.296    65.945     0.150
     4.333    66.086     0.150
     4.333   115.289     0.150
     4.245    65.188     0.150
     4.245   110.984     0.150
     4.397    65.984     0.150
     4.397   117.383     0.150
     4.425    68.133     0.150
     4.350    67.383     0.150
     4.376    67.586     0.150
     4.672    71.383     0.150
     4.692    71.688     0.150
     4.696    69.883     0.150
     4.636    71.086     0.150
     4.679    72.023     0.150
     4.655    71.586     0.150
     4.655   136.586     0.150
     4.655   159.086     0.150
     4.741    72.688     0.150
     4.762    73.086     0.150
     5.020    74.086     0.150
     5.150    76.289     0.150
     5.163    76.086     0.150
     5.186    78.984     0.150
     5.161    79.086     0.150
     5.505    82.188     0.150
     5.505   144.883     0.150
     5.449    81.883     0.150
     5.465    81.789     0.150
     5.626    84.375     0.150
     5.672    82.789     0.150
     5.536    82.383     0.150
     5.702    85.289     0.150
     5.743    85.688     0.150
     5.749    85.789     0.150
     5.915    89.938     0.150
     5.773    87.984     0.150
     5.949    89.359     0.150
     5.957    90.930     0.150
     5.944    87.484     0.150
     6.061    92.383     0.150
     6.021    88.789     0.150
     6.021   108.984     0.150
     6.021   153.383     0.150
     6.021   174.086     0.150
     5.951    87.789     0.150
     6.104    90.789     0.150
     6.088    90.586     0.150
     6.088   120.086     0.150
     6.088   161.586     0.150
     6.047    89.586     0.150
     6.151    92.586     0.150
     6.143    91.586     0.150
     6.001    90.086     0.150
     6.170    91.883     0.150
     6.170   161.883     0.150
     6.184    91.883     0.150
     6.184   162.188     0.150
     6.184   201.883     0.150
     6.072    90.484     0.150
     6.227    90.188     0.150
     6.209    92.383     0.150
     6.234    94.727     0.150
     6.279    95.383     0.150
     6.304    94.875     0.150
     6.301    93.188     0.150
     6.326    91.984     0.150
     6.328    94.289     0.150
     6.328   165.688     0.150
     6.365    93.883     0.150
     6.413    95.188     0.150
     6.354   119.086     0.150
     6.452    96.383     0.150
     6.369    94.289     0.150
     6.378    95.086     0.150
     6.462    95.086     0.150
     6.462   102.688     0.150
     6.462   110.789     0.150
     6.462   125.789     0.150
     6.527    94.086     0.150
     6.530    94.414     0.150
     6.540    96.914     0.150
     6.575    96.484     0.150
     6.579    96.609     0.150
     6.573    97.789     0.150
     6.573   100.789     0.150
     6.573   171.688     0.150
     6.626    97.383     0.150
     6.595    97.086     0.150
     6.595   110.383     0.150
     6.715    96.688     0.150
     6.756    99.383     0.150
     6.775   100.688     0.150
     6.782    97.883     0.150
     6.703   100.086     0.150
     6.852   100.586     0.150
     6.917   102.195     0.150
     6.945    98.953     0.150
     7.005   104.984     0.150
     6.934   184.086     0.150
     7.044   103.789     0.150
     7.017   102.188     0.150
     7.017   116.789     0.150
     7.113   103.383     0.150
     7.199   103.789     0.150
     7.200   107.086     0.150
     7.187   104.383     0.150
     7.187   116.383     0.150
     7.187   104.086     0.150
     7.187   181.883     0.150
     7.220   104.289     0.150
     7.218   105.484     0.150
     7.088   103.383     0.150
     7.242   108.289     0.150
     7.110   105.086     0.150
     7.256   105.789     0.150
     7.383   108.188     0.150
     7.511   110.383     0.150
     7.511   189.086     0.150
     7.482   107.984     0.150
     7.482   187.586     0.150
     7.482   191.586     0.150
     7.482   243.086     0.150
     7.528   109.289     0.150
     7.586   109.586     0.150
     7.543   111.086     0.150
     7.692   111.188     0.150
     7.625   111.086     0.150
     7.636   111.086     0.150
     7.695   111.586     0.150
     7.779   113.086     0.150
     7.935   114.023     0.150
     7.811   114.586     0.150
     7.994   114.883     0.150
     8.169   116.883     0.150
     8.169   203.789     0.150
     8.296   120.086     0.150
     8.265   119.086     0.150
     8.265   206.789     0.150
     8.351   207.086     0.150
     8.386   119.586     0.150
     8.355   212.984     0.150
     8.308   124.086     0.150
     8.429   119.688     0.150
     8.338   203.086     0.150
     8.500   120.688     0.150
     8.500   212.789     0.150
     8.540   121.383     0.150
     8.540   212.789     0.150
     8.511   125.586     0.150
     8.631   123.289     0.150
     8.685   124.484     0.150
     8.719   124.188     0.150
     8.719   215.883     0.150
     8.640   128.086     0.150
     8.640   278.086     0.150
     8.879   125.688     0.150
     8.879   221.289     0.150
     8.884   127.984     0.150
     8.921   129.383     0.150
     8.785   128.086     0.150
     8.908   132.586     0.150
     9.137   134.086     0.150
     9.207   130.883     0.150
     9.250   132.289     0.150
     9.250   230.586     0.150
     9.381   133.383     0.150
     9.289   133.086     0.150
     9.526   134.984     0.150
     9.454   136.086     0.150
     9.603   135.883     0.150
     9.603   239.188     0.150
     9.700   139.289     0.150
     9.700   241.688     0.150
     9.693   138.086     0.150
     9.693   278.289     0.150
     9.729   140.086     0.150
     9.740   139.484     0.150
     9.790   141.688     0.150
     9.813   138.586     0.150
     9.813   244.789     0.150
     9.892   139.984     0.150
     9.892   247.383     0.150
     9.796   141.086     0.150
     9.923   140.484     0.150
     9.923   248.383     0.150
    10.097   145.789     0.150
    10.108   143.688     0.150
    10.108   253.484     0.150
    10.004   143.086     0.150
    10.156   145.289     0.150
    10.411   147.586     0.150
    10.411   259.688     0.150
    10.397   151.883     0.150
    11.052   157.289     0.150
    11.052   273.086     0.150
    11.306   161.086     0.150
    11.203   165.586     0.150
    11.458   165.086     0.150
    12.050   171.484     0.150
    12.799   179.883     0.150
    13.088   184.086     0.150
    14.694   208.688     0.150
    18.170   252.086     0.150
    19.156   262.484     0.150
    19.384   263.984     0.150
    19.384   263.086     0.150
    19.482   265.789     0.150
    19.482   265.789     0.150
    19.668   279.789     0.150
    20.238   277.984     0.150
    20.800   279.484     0.150
    21.218   291.086     0.150
    21.218   308.086     0.150
    21.460   286.688     0.150
    28.376   351.289     0.150
    31.370   379.086     0.150
    36.518   423.289     0.150
    39.214   447.383     0.150
    45.328   498.086     0.150
    45.328   498.289     0.150
    46.430   507.289     0.150
    53.482   562.844     0.150
    53.559   563.148     0.150
    53.827   564.664     0.150
    54.736   570.367     0.150
    55.075   572.086     0.150
    55.886   578.930     0.150
    56.318   581.945     0.150
    58.553   598.586     0.150
    58.787   598.586     0.150
    72.903   689.789     0.150
    73.362   694.984     0.150
    89.565   779.789     0.150
     0.525    10.742     0.150
     1.008    18.539     0.150
     1.154    21.742     0.150
     1.154    38.438     0.150
     1.457    26.844     0.150
     1.457    45.641     0.150
     1.600    28.141     0.150
     1.751    29.242     0.150
     1.915    33.242     0.150
     1.963    34.242     0.150
     2.238    38.039     0.150
     2.296    38.141     0.150
     2.422    39.742     0.150
     2.591    43.242     0.150
     2.625    43.039     0.150
     2.777    46.438     0.150
     2.796    45.344     0.150
     2.981    47.641     0.150
     3.038    49.242     0.150
     3.054   109.742     0.150
     3.065    49.039     0.150
     3.135   110.641     0.150
     3.277    53.242     0.150
     3.506    57.742     0.150
     3.678    58.141     0.150
     3.646    55.742     0.150
     3.646    98.438     0.150
     3.794    58.641     0.150
     3.960    61.938     0.150
     4.159    77.344     0.150
     4.159   110.844     0.150
     4.356    66.141     0.150
     4.356    68.742     0.150
     4.356   115.641     0.150
     4.415    68.438     0.150
     4.415   116.641     0.150
     4.655    71.242     0.150
     4.655   126.242     0.150
     4.701    90.141     0.150
     4.791    73.141     0.150
     5.022    74.242     0.150
     5.143    76.242     0.150
     5.169    78.938     0.150
     5.175    76.039     0.150
     5.466    81.938     0.150
     5.522    82.742     0.150
     5.522   144.641     0.150
     5.663    82.844     0.150
     5.785    85.742     0.150
     5.800    88.141     0.150
     6.075    89.844     0.150
     6.096    90.742     0.150
     6.096   161.242     0.150
     6.190    92.344     0.150
     6.190   162.039     0.150
     6.215    90.938     0.150
     6.408    95.141     0.150
     6.510    94.844     0.150
     6.543    96.844     0.150
     6.592    97.438     0.150
     6.723    99.438     0.150
     6.827   100.141     0.150
     7.178   103.844     0.150
     7.199   104.641     0.150
     7.208   103.938     0.150
     7.486   109.344     0.150
     7.503   107.641     0.150
     8.153   116.141     0.150
     8.492   120.938     0.150
     8.492   212.344     0.150
     8.532   121.844     0.150
     8.532   212.844     0.150
     8.714   124.242     0.150
     8.714   217.844     0.150
     8.870   126.242     0.150
     8.870   222.039     0.150
     9.506   134.844     0.150
     9.506   238.344     0.150
     9.584   135.242     0.150
     9.796   138.742     0.150
     9.796   245.539     0.150
     9.872   140.141     0.150
     0.310     6.141     0.150
     0.310    12.641     0.150
     0.459     9.859     0.150
     0.530    10.000     0.150
     0.546    10.711     0.150
     0.687    12.914     0.150
     0.962    19.039     0.150
     1.005    18.867     0.150
     1.538    26.641     0.150
     1.538    26.742     0.150
     1.788    30.641     0.150
     1.788    30.742     0.150
     1.978    33.938     0.150
     2.214    37.344     0.150
     2.462    41.828     0.150
     2.813    46.844     0.150
     2.898    46.438     0.150
     3.036    49.539     0.150
     3.226    52.344     0.150
     3.242    52.438     0.150
     3.258    57.742     0.150
     3.289    52.234     0.150
     3.344    57.164     0.150
     3.468    61.344     0.150
     3.468    55.438     0.150
     3.510    56.641     0.150
     3.570    56.938     0.150
     3.766    61.242     0.150
     3.930    60.938     0.150
     4.016    63.742     0.150
     3.991    64.039     0.150
     4.115    65.039     0.150
     4.150    65.344     0.150
     4.193    67.141     0.150
     4.338    72.742     0.150
     4.530    70.141     0.150
     4.583    67.844     0.150
     4.647    73.438     0.150
     4.669    71.438     0.150
     4.669    73.438     0.150
     4.669   126.039     0.150
     4.624    72.641     0.150
     4.667    74.641     0.150
     4.698    73.422     0.150
     4.698   125.141     0.150
     4.786    72.844     0.150
     4.786   127.844     0.150
     5.015    78.141     0.150
     5.100    86.078     0.150
     5.097    79.938     0.150
     5.097   136.641     0.150
     5.099    78.602     0.150
     5.099   133.664     0.150
     5.179    78.141     0.150
     5.260    79.438     0.150
     5.260   172.641     0.150
     5.376    80.938     0.150
     5.443    82.141     0.150
     5.526    85.539     0.150
     5.489    85.141     0.150
     5.586    85.039     0.150
     5.597    85.164     0.150
     5.574    85.141     0.150
     5.698    86.438     0.150
     5.759    87.383     0.150
     5.771    87.961     0.150
     5.883    87.242     0.150
     5.846    88.383     0.150
     5.941    90.141     0.150
     6.040    91.750     0.150
     5.998    92.938     0.150
     6.068    91.242     0.150
     6.109    92.797     0.150
     6.073    92.461     0.150
     6.073   157.664     0.150
     6.215    93.539     0.150
     6.199    93.539     0.150
     6.199   161.141     0.150
     6.258    95.641     0.150
     6.274    95.648     0.150
     6.310    93.438     0.150
     6.319    92.539     0.150
     6.331    95.539     0.150
     6.332    95.742     0.150
     6.332   167.141     0.150
     6.340    95.242     0.150
     6.352    93.039     0.150
     6.359    96.312     0.150
     6.317    96.141     0.150
     6.316    94.539     0.150
     6.316   163.703     0.150
     6.320    96.898     0.150
     6.320   165.539     0.150
     6.425    97.117     0.150
     6.453    97.844     0.150
     6.459    96.344     0.150
     6.459   170.039     0.150
     6.476    97.742     0.150
     6.476   170.539     0.150
     6.474    97.539     0.150
     6.474   173.141     0.150
     6.489    95.344     0.150
     6.468    97.344     0.150
     6.468    97.141     0.150
     6.579    99.062     0.150
     6.579   170.062     0.150
     6.678    99.641     0.150
     6.671   101.938     0.150
     6.671   190.844     0.150
     6.756   101.969     0.150
     6.724   100.641     0.150
     6.805   102.539     0.150
     6.799   102.141     0.150
     6.834   178.141     0.150
     6.834   202.141     0.150
     6.890   106.039     0.150
     6.967   104.141     0.150
     7.075   104.344     0.150
     7.096   105.438     0.150
     7.166   107.141     0.150
     7.331   111.141     0.150
     7.379   110.938     0.150
     7.481   108.641     0.150
     7.481   192.938     0.150
     7.506   111.641     0.150
     7.538   112.641     0.150
     7.538   112.141     0.150
     7.745   113.742     0.150
     7.774   112.742     0.150
     7.774   128.141     0.150
     7.774   198.141     0.150
     7.851   115.539     0.150
     7.943   118.641     0.150
     8.026   119.641     0.150
     8.091   117.641     0.150
     8.092   119.039     0.150
     8.106   118.438     0.150
     8.106   118.141     0.150
     8.148   122.141     0.150
     8.503   122.242     0.150
     8.503   215.539     0.150
     8.594   218.641     0.150
     8.642   126.141     0.150
     8.642   216.844     0.150
     8.722   132.438     0.150
     8.829   133.141     0.150
     8.875   128.039     0.150
     8.875   225.539     0.150
     8.941   134.141     0.150
     9.029   133.242     0.150
     9.029   233.344     0.150
     9.160   136.242     0.150
     9.426   134.438     0.150
     9.422   138.141     0.150
     9.491   137.844     0.150
     9.491   238.641     0.150
     9.493   139.141     0.150
     9.515   141.641     0.150
     9.719   140.242     0.150
     9.867   141.742     0.150
     9.981   144.141     0.150
    10.244   151.039     0.150
    11.587   167.141     0.150
    14.282   202.039     0.150
    18.576   258.242     0.150
    19.461   267.438     0.150
    19.785   271.742     0.150
    19.904   272.141     0.150
    20.098   274.539     0.150
    20.714   284.039     0.150
    20.714   511.242     0.150
    20.878   284.844     0.150
    21.235   286.938     0.150
    21.689   294.141     0.150
    21.689   316.141     0.150
    21.893   292.039     0.150
    31.898   386.141     0.150
    33.092   397.344     0.150
    36.219   423.242     0.150
    36.219    11.195     0.150
    38.709   444.438     0.150
    43.659   486.141     0.150
    45.857   503.344     0.150
    46.187   505.938     0.150
    46.959   512.539     0.150
    53.018   557.141     0.150
    58.816   601.141     0.150
    59.041   600.141     0.150
    59.067   601.641     0.150
    62.229   622.641     0.150
    68.761   663.344     0.150
    68.761    11.898     0.150
    68.761   663.242     0.150
    70.396   673.039     0.150
    71.289   680.141     0.150
    72.492   688.641     0.150
    74.861   700.742     0.150
    80.630   733.344     0.150
    80.675   734.141     0.150
    82.301   742.344     0.150
    82.301     9.500     0.150
   126.853  1145.242     0.150
     0.356     6.758     0.150
     0.683    12.859     0.150
     0.683    23.656     0.150
     0.944    18.461     0.150
     1.350    25.062     0.150
     1.446    26.258     0.150
     1.473    27.156     0.150
     1.761    31.758     0.150
     1.907    34.461     0.150
     2.053    34.359     0.150
     2.140    38.062     0.150
     2.249    38.258     0.150
     2.490    42.258     0.150
     2.874    46.859     0.150
     2.869    46.156     0.150
     4.015    64.359     0.150
     4.015   109.562     0.150
     4.225    66.961     0.150
     4.225   113.062     0.150
     4.321    66.961     0.150
     4.321   119.156     0.150
     4.442    70.562     0.150
     4.733    74.359     0.150
     4.733   126.062     0.150
     4.745    74.062     0.150
     4.758    73.797     0.150
     5.182    77.359     0.150
     5.190    80.281     0.150
     5.438   138.961     0.150
     5.573    94.359     0.150
     5.838    86.859     0.150
     5.941    89.156     0.150
     6.041    91.359     0.150
     6.155    93.039     0.150
     6.264    93.156     0.150
     6.309    96.961     0.150
     6.309   168.961     0.150
     6.293    93.461     0.150
     6.293   164.562     0.150
     6.377    96.156     0.150
     6.377   168.156     0.150
     6.383    97.602     0.150
     6.431    96.461     0.150
     6.502    98.461     0.150
     6.502   173.461     0.150
     6.520    99.859     0.150
     6.520   174.258     0.150
     6.543    97.656     0.150
     6.543   170.062     0.150
     6.673    99.641     0.150
     6.644    99.562     0.150
     6.706    97.359     0.150
     7.295   108.062     0.150
     7.560   110.258     0.150
     7.560   192.156     0.150
     7.852   114.859     0.150
     7.852   131.859     0.150
     8.080   117.461     0.150
     8.512   215.961     0.150
     8.883   128.656     0.150
     8.883   225.859     0.150
    21.345   289.062     0.150
     0.335     6.688     0.150
     0.335    13.289     0.150
     0.472    10.438     0.150
     0.503    10.639     0.150
     0.591    11.269     0.150
     0.722    12.789     0.150
     0.722    25.589     0.150
     0.692    13.809     0.150
     0.938    17.889     0.150
     1.038    19.309     0.150
     1.365    25.188     0.150
     1.505    26.889     0.150
     1.530    26.889     0.150
     1.794    31.688     0.150
     1.881    33.688     0.150
     1.988    34.188     0.150
     2.259    37.688     0.150
     2.261    38.789     0.150
     2.486    42.389     0.150
     2.818    46.889     0.150
     2.872    48.789     0.150
     3.070    50.089     0.150
     3.258    52.789     0.150
     3.281    53.389     0.150
     3.280    52.789     0.150
     3.253    58.489     0.150
     3.482    59.589     0.150
     3.454    55.289     0.150
     3.496    55.989     0.150
     3.546    57.188     0.150
     3.602    57.589     0.150
     3.927    63.289     0.150
     3.970    63.989     0.150
     3.970   108.789     0.150
     4.029    62.889     0.150
     4.029    64.589     0.150
     4.171    64.489     0.150
     4.171   112.489     0.150
     4.148    65.589     0.150
     4.171    67.089     0.150
     4.185    66.188     0.150
     4.378    66.989     0.150
     4.378   118.789     0.150
     4.574    70.489     0.150
     4.649    70.089     0.150
     4.644    72.589     0.150
     4.687    73.589     0.150
     4.687   125.089     0.150
     4.706    71.889     0.150
     4.706    73.688     0.150
     4.706   124.789     0.150
     4.703    73.469     0.150
     4.897    74.259     0.150
     5.124    79.089     0.150
     5.124    80.589     0.150
     5.124   137.589     0.150
     5.117    78.909     0.150
     5.117   133.669     0.150
     5.170    77.789     0.150
     5.410    82.188     0.150
     5.485    81.589     0.150
     5.485   174.089     0.150
     5.592    84.789     0.150
     5.883    87.289     0.150
     5.883   151.989     0.150
     5.866    88.789     0.150
     5.963    91.089     0.150
     6.096    91.489     0.150
     6.087    92.099     0.150
     6.087   157.429     0.150
     6.220    93.188     0.150
     6.220   158.309     0.150
     6.289    96.188     0.150
     6.289   168.589     0.150
     6.278    96.239     0.150
     6.315    92.489     0.150
     6.361    96.188     0.150
     6.361   169.289     0.150
     6.347    93.089     0.150
     6.347   165.789     0.150
     6.334    94.909     0.150
     6.371   170.688     0.150
     6.326    97.069     0.150
     6.326   165.709     0.150
     6.499    96.289     0.150
     6.499   169.688     0.150
     6.500    98.389     0.150
     6.500   174.089     0.150
     6.484    95.188     0.150
     6.498    97.589     0.150
     6.619    97.089     0.150
     6.599    98.949     0.150
     6.682   100.688     0.150
     6.746   100.309     0.150
     6.824   101.889     0.150
     6.896   107.108     0.150
     7.015   104.549     0.150
     7.105   105.688     0.150
     7.150   106.589     0.150
     7.195   107.589     0.150
     7.335   108.289     0.150
     7.519   109.989     0.150
     7.519   191.989     0.150
     7.551   111.089     0.150
     7.812   114.089     0.150
     7.812   199.589     0.150
     7.888   116.389     0.150
     8.093   118.889     0.150
     8.103   119.089     0.150
     8.103   207.389     0.150
     8.521   121.089     0.150
     8.521   214.089     0.150
     8.634   125.789     0.150
     8.634   217.589     0.150
     8.662   128.589     0.150
     8.676   123.789     0.150
     8.676   217.989     0.150
     8.894   127.889     0.150
     8.894   225.389     0.150
     9.199   135.089     0.150
     9.526   139.188     0.150
     9.532   138.489     0.150
     9.729   246.688     0.150
    14.261   201.589     0.150
    19.500   267.389     0.150
    19.823   273.389     0.150
    20.172   273.989     0.150
    21.280   287.089     0.150
    38.663   445.289     0.150
    53.032   556.289     0.150
    68.790   663.889     0.150
    70.326   674.089     0.150
    82.320   741.989     0.150
    89.484   779.089     0.150
     0.443     8.374     0.150
     1.113    39.074     0.150
     1.227    22.974     0.150
     1.182    23.474     0.150
     1.182    40.874     0.150
     1.250    24.474     0.150
     1.520    27.574     0.150
     1.627    27.574     0.150
     2.012    35.273     0.150
     2.053    35.974     0.150
     2.149    37.374     0.150
     2.266    38.474     0.150
     2.265    37.273     0.150
     2.333    37.974     0.150
     2.766    45.674     0.150
     2.816    45.674     0.150
     3.099    49.574     0.150
     3.273    52.374     0.150
     3.273    92.773     0.150
     3.456    54.773     0.150
     3.456    97.174     0.150
     3.473    55.273     0.150
     3.473    98.174     0.150
     3.649    58.273     0.150
     3.735    58.674     0.150
     3.735   103.974     0.150
     3.814    60.074     0.150
     3.814   106.474     0.150
     4.094    64.174     0.150
     4.099    63.674     0.150
     4.182    66.174     0.150
     4.199    64.974     0.150
     4.199   114.674     0.150
     4.358    67.773     0.150
     4.358   119.374     0.150
     4.383    67.773     0.150
     4.383   119.474     0.150
     4.572    71.874     0.150
     4.572   124.174     0.150
     4.577    72.374     0.150
     4.577   120.174     0.150
     4.598    88.674     0.150
     4.905    76.374     0.150
     4.966    74.374     0.150
     4.973    76.974     0.150
     5.244    79.474     0.150
     5.602    83.874     0.150
     5.651    87.374     0.150
     5.651   146.874     0.150
     6.034    89.474     0.150
     6.066    90.273     0.150
     6.066   158.874     0.150
     6.203    92.674     0.150
     6.217    92.574     0.150
     6.405    94.074     0.150
     6.477    97.654     0.150
     7.057   103.174     0.150
     7.417   109.174     0.150
     7.680   112.674     0.150
     7.680   197.674     0.150
     8.545   123.174     0.150
     1.202    21.078     0.150
     1.383    25.711     0.150
     1.445    25.977     0.150
     1.386    23.680     0.150
     1.854    32.875     0.150
     1.585    26.781     0.150
     1.585    46.578     0.150
     1.738    30.375     0.150
     1.738    52.578     0.150
     2.245    37.375     0.150
     2.275    37.977     0.150
     2.175    35.078     0.150
     2.175    61.977     0.150
     2.374    39.078     0.150
     2.107    35.875     0.150
     2.389    38.078     0.150
     2.389    67.375     0.150
     2.369    37.875     0.150
     2.369    65.781     0.150
     2.265    36.680     0.150
     2.654    43.375     0.150
     2.726    43.180     0.150
     2.651    42.180     0.150
     2.651    73.680     0.150
     2.630    41.180     0.150
     2.630    72.375     0.150
     2.712    42.578     0.150
     2.712    74.180     0.150
     3.278    51.688     0.150
     2.939    46.281     0.150
     3.141    50.180     0.150
     3.141    85.375     0.150
     3.118    49.281     0.150
     3.100    49.281     0.150
     3.100    91.781     0.150
     3.256    51.680     0.150
     3.256    87.977     0.150
     3.289    52.375     0.150
     3.289    88.781     0.150
     3.603    56.875     0.150
     3.720    56.281     0.150
     3.720    99.281     0.150
     3.801    58.078     0.150
     3.801   100.875     0.150
     3.590    54.875     0.150
     3.530    55.078     0.150
     3.546    54.406     0.150
     3.561    53.680     0.150
     3.649    55.672     0.150
     3.677    56.875     0.150
     3.718    59.281     0.150
     4.131    61.875     0.150
     4.112    65.477     0.150
     4.112   111.680     0.150
     3.865    60.117     0.150
     4.239    62.922     0.150
     3.951    61.258     0.150
     4.259    64.180     0.150
     4.333    66.281     0.150
     4.412    65.875     0.150
     4.412   115.578     0.150
     4.435    66.281     0.150
     4.446    66.977     0.150
     4.120    63.000     0.150
     4.514    66.875     0.150
     4.514   117.578     0.150
     4.265    65.078     0.150
     4.265    80.078     0.150
     4.265   114.078     0.150
     4.350    65.961     0.150
     4.404    68.117     0.150
     4.397    67.078     0.150
     4.634    70.078     0.150
     4.554    70.680     0.150
     4.889    71.781     0.150
     4.948    73.078     0.150
     4.991    72.977     0.150
     4.653    70.977     0.150
     4.695    70.680     0.150
     4.775    72.578     0.150
     5.081    76.078     0.150
     5.241    76.477     0.150
     5.321    77.578     0.150
     5.072    75.438     0.150
     5.423    79.680     0.150
     5.137    76.578     0.150
     5.514    82.672     0.150
     5.534    81.078     0.150
     5.534   142.180     0.150
     5.627    82.680     0.150
     5.627   147.680     0.150
     5.640    83.297     0.150
     5.363    79.961     0.150
     5.408    80.602     0.150
     5.491    82.578     0.150
     5.416    82.078     0.150
     5.559    81.641     0.150
     5.619    84.078     0.150
     5.973    87.055     0.150
     6.052    88.680     0.150
     5.707    85.555     0.150
     6.061    89.297     0.150
     6.095    89.477     0.150
     5.806    86.039     0.150
     6.173    91.188     0.150
     6.220    90.977     0.150
     6.220   161.281     0.150
     5.934    87.195     0.150
     6.273    91.680     0.150
     6.273   163.977     0.150
     5.985    88.875     0.150
     5.978    88.078     0.150
     6.285    92.141     0.150
     6.308    92.680     0.150
     6.339    92.781     0.150
     6.355    93.281     0.150
     6.355   165.781     0.150
     6.390    94.281     0.150
     6.475    96.281     0.150
     6.475   163.680     0.150
     6.528    95.680     0.150
     6.571    96.180     0.150
     6.320    94.078     0.150
     6.549   107.180     0.150
     6.549   165.375     0.150
     6.560   105.078     0.150
     6.560   166.477     0.150
     6.282    91.797     0.150
     6.620    95.375     0.150
     6.620   161.180     0.150
     6.598    96.695     0.150
     6.664    97.875     0.150
     6.664    98.680     0.150
     6.668    97.500     0.150
     6.384    93.281     0.150
     6.849    97.680     0.150
     6.851    97.422     0.150
     6.899    99.266     0.150
     6.591    97.578     0.150
     6.954   101.281     0.150
     6.718    99.078     0.150
     7.026   100.875     0.150
     7.043   103.477     0.150
     6.710    98.477     0.150
     7.009   102.875     0.150
     7.092   101.078     0.150
     7.092   172.875     0.150
     7.175   104.781     0.150
     7.185   103.680     0.150
     7.137   104.680     0.150
     7.208   103.875     0.150
     7.208   181.680     0.150
     7.229   107.781     0.150
     7.229   181.781     0.150
     7.269   103.680     0.150
     7.281   101.461     0.150
     7.310   106.180     0.150
     7.385   109.977     0.150
     7.430   106.375     0.150
     7.477   107.578     0.150
     7.497   108.477     0.150
     7.250   104.578     0.150
     7.186   104.875     0.150
     7.537   107.180     0.150
     7.537   187.875     0.150
     7.563   109.180     0.150
     7.558   107.578     0.150
     7.558   187.281     0.150
     7.567   108.578     0.150
     7.567   190.578     0.150
     7.242   105.977     0.150
     7.575   113.781     0.150
     7.614   110.180     0.150
     7.614   189.375     0.150
     7.624   113.477     0.150
     7.694   110.375     0.150
     7.706   111.781     0.150
     7.704   110.781     0.150
     7.704   198.875     0.150
     7.677   115.281     0.150
     7.721   111.781     0.150
     7.790   112.781     0.150
     7.819   114.281     0.150
     7.795   116.078     0.150
     7.869   114.180     0.150
     7.899   111.578     0.150
     7.901   113.477     0.150
     7.867   117.375     0.150
     7.691   113.078     0.150
     7.945   113.977     0.150
     8.066   115.867     0.150
     8.076   117.078     0.150
     8.157   118.078     0.150
     8.213   117.078     0.150
     8.213   203.281     0.150
     8.254   118.078     0.150
     8.254   208.281     0.150
     8.314   118.578     0.150
     8.351   118.781     0.150
     8.336   123.578     0.150
     8.487   120.281     0.150
     8.487   208.281     0.150
     8.499   120.977     0.150
     8.496   121.477     0.150
     8.496   210.375     0.150
     8.309   122.180     0.150
     8.661   123.078     0.150
     8.661   216.078     0.150
     8.660   124.375     0.150
     8.759   123.477     0.150
     8.779   124.180     0.150
     8.779   216.477     0.150
     8.896   126.578     0.150
     8.896   225.180     0.150
     8.942   127.680     0.150
     8.942   224.578     0.150
     8.978   127.977     0.150
     8.978   219.078     0.150
     9.061   129.977     0.150
     9.036   131.477     0.150
     9.158   131.078     0.150
     9.161   129.578     0.150
     9.161   224.281     0.150
     9.374   132.680     0.150
     9.374   232.375     0.150
     9.139   131.078     0.150
     9.731   137.281     0.150
     9.737   137.977     0.150
     9.862   138.281     0.150
     9.862   242.875     0.150
     9.963   142.055     0.150
     9.963   142.375     0.150
    10.024   143.828     0.150
    10.137   141.875     0.150
    10.137   248.078     0.150
    10.115   146.078     0.150
    10.228   142.875     0.150
    10.228   253.680     0.150
    10.253   143.375     0.150
    10.253   250.781     0.150
    10.451   146.281     0.150
    10.468   149.578     0.150
    10.761   151.781     0.150
    10.761   265.375     0.150
    11.571   162.180     0.150
    12.405   173.781     0.150
    13.124   185.281     0.150
    13.124   319.180     0.150
    13.412   187.977     0.150
    13.412   327.477     0.150
    13.484   189.875     0.150
    13.484   329.477     0.150
    14.487   202.977     0.150
    18.202   252.375     0.150
    18.415   254.078     0.150
    18.415   254.680     0.150
    18.483   256.477     0.150
    19.154   259.680     0.150
    19.389   265.078     0.150
    19.545   265.375     0.150
    19.545   266.781     0.150
    19.595   265.078     0.150
    20.722   278.078     0.150
    21.385   284.781     0.150
    36.464   423.578     0.150
    45.522   497.578     0.150
    46.142   503.680     0.150
    53.365   557.477     0.150
    58.337   594.180     0.150
    72.978   687.977     0.150
     0.128     5.325     0.150
     0.471     9.956     0.150
     0.602    12.346     0.150
     0.642    12.565     0.150
     1.235    20.556     0.150
     1.422    25.155     0.150
     1.478    25.355     0.150
     1.374    23.056     0.150
     1.877    32.756     0.150
     1.751    29.855     0.150
     2.262    36.855     0.150
     2.124    35.176     0.150
     2.307    37.155     0.150
     2.136    34.056     0.150
     2.136    60.355     0.150
     2.399    38.556     0.150
     2.253    35.956     0.150
     2.331    36.556     0.150
     2.331    64.655     0.150
     2.348    37.355     0.150
     2.348    65.855     0.150
     2.669    43.155     0.150
     2.735    42.556     0.150
     2.594    40.855     0.150
     2.594    69.855     0.150
     2.610    41.355     0.150
     2.610    71.155     0.150
     2.673    42.355     0.150
     2.673    72.155     0.150
     2.957    47.985     0.150
     3.100    48.956     0.150
     3.100    83.655     0.150
     3.079    47.256     0.150
     3.286    51.056     0.150
     3.217    51.056     0.150
     3.217    85.655     0.150
     3.249    51.456     0.150
     3.249    87.456     0.150
     3.614    55.956     0.150
     3.509    53.556     0.150
     3.704    55.956     0.150
     3.704    97.756     0.150
     3.662    56.355     0.150
     3.701    64.256     0.150
     3.985    60.355     0.150
     3.937    64.256     0.150
     4.086   110.256     0.150
     4.227    62.256     0.150
     4.104    62.235     0.150
     4.350    65.655     0.150
     4.230    65.056     0.150
     4.230    72.056     0.150
     4.461    66.355     0.150
     4.395    66.056     0.150
     4.395   114.655     0.150
     4.322    65.516     0.150
     4.500    66.456     0.150
     4.500   116.556     0.150
     4.378    66.556     0.150
     4.593    79.556     0.150
     4.883    71.056     0.150
     4.750    71.556     0.150
     4.979    72.756     0.150
     5.109    75.855     0.150
     5.042    73.926     0.150
     5.239    76.155     0.150
     5.129    75.556     0.150
     5.312    77.456     0.150
     5.428    79.036     0.150
     5.527    82.155     0.150
     5.338    79.155     0.150
     5.377    78.956     0.150
     5.510    80.355     0.150
     5.510   141.355     0.150
     5.399    81.256     0.150
     5.614    82.456     0.150
     5.457    81.556     0.150
     5.582    82.556     0.150
     5.688    84.636     0.150
     5.776    84.596     0.150
     6.113    88.956     0.150
     5.902    85.836     0.150
     5.951    87.756     0.150
     6.201    90.556     0.150
     6.201   158.655     0.150
     6.266    92.655     0.150
     6.266   161.756     0.150
     6.326   101.056     0.150
     6.348    93.355     0.150
     6.348   165.556     0.150
     6.391    94.155     0.150
     6.449    95.855     0.150
     6.256    91.235     0.150
     6.497    95.256     0.150
     6.497   166.355     0.150
     6.283    92.556     0.150
     6.511    98.256     0.150
     6.540    96.355     0.150
     6.523    96.155     0.150
     6.523   171.256     0.150
     6.578    99.756     0.150
     6.356    93.075     0.150
     6.575    95.456     0.150
     6.627    94.956     0.150
     6.627   159.456     0.150
     6.665    99.155     0.150
     6.829   100.405     0.150
     6.849   101.056     0.150
     6.860    97.655     0.150
     6.684    98.556     0.150
     6.978   103.256     0.150
     7.034   103.355     0.150
     7.046   102.956     0.150
     7.046   174.756     0.150
     7.102   101.056     0.150
     7.162   105.155     0.150
     7.226   103.256     0.150
     7.440   105.756     0.150
     7.502   108.056     0.150
     7.552   106.355     0.150
     7.572   107.155     0.150
     7.572   186.056     0.150
     7.572   108.056     0.150
     7.550   108.056     0.150
     7.550   123.556     0.150
     7.550   189.056     0.150
     7.588   109.756     0.150
     7.717   110.056     0.150
     7.717   110.655     0.150
     7.887   113.256     0.150
     7.946   113.155     0.150
     8.129   117.256     0.150
     8.498   119.655     0.150
     8.503   120.456     0.150
     8.565   242.756     0.150
     8.680   123.956     0.150
     8.665   122.355     0.150
     8.784   123.456     0.150
     8.899   125.855     0.150
     8.944   126.655     0.150
     8.979   125.855     0.150
     9.059   130.956     0.150
     9.166   128.056     0.150
     9.166   223.256     0.150
     9.360   135.456     0.150
     9.360   232.556     0.150
     9.876   137.756     0.150
     9.876   241.855     0.150
    10.142   146.355     0.150
    10.149   140.956     0.150
    10.242   142.655     0.150
    10.242   251.756     0.150
    10.266   142.456     0.150
    10.467   145.756     0.150
     0.162     3.566     0.150
     0.162     5.168     0.150
     0.627    12.266     0.150
     0.627    20.867     0.150
     0.685    12.668     0.150
     0.685    22.668     0.150
     0.704    13.066     0.150
     0.704    24.066     0.150
     0.786    14.367     0.150
     0.786    26.969     0.150
     0.787    14.367     0.150
     0.787    26.367     0.150
     0.821    15.867     0.150
     0.789    15.188     0.150
     0.895    16.168     0.150
     0.895    29.668     0.150
     1.011    20.086     0.150
     1.071    20.156     0.150
     1.152    20.008     0.150
     1.152    20.668     0.150
     1.158    21.188     0.150
     1.347    24.297     0.150
     1.515    26.367     0.150
     1.500    28.066     0.150
     1.957    33.367     0.150
     2.218    37.766     0.150
     2.370    39.168     0.150
     2.414    41.328     0.150
     2.414    70.969     0.150
     2.632    43.039     0.150
     2.632    73.898     0.150
     2.863    48.527     0.150
     2.863    83.188     0.150
     2.966    47.887     0.150
     2.966    82.297     0.150
     3.243    53.316     0.150
     3.194    54.637     0.150
     3.317    56.039     0.150
     3.317    96.516     0.150
     3.361    55.637     0.150
     3.506    55.379     0.150
     3.506    95.426     0.150
     3.516    56.578     0.150
     3.516    97.469     0.150
     3.595    56.766     0.150
     3.595    99.066     0.150
     3.872    60.496     0.150
     4.174   111.367     0.150
     4.250    64.766     0.150
     4.250   112.469     0.150
     4.560    85.867     0.150
     4.634    70.066     0.150
     4.634   123.469     0.150
     4.916    73.297     0.150
     5.031    75.238     0.150
     5.152    79.238     0.150
     5.360    82.969     0.150
     5.779    87.367     0.150
     5.967    90.266     0.150
     5.967   158.969     0.150
     5.988    88.566     0.150
     5.988   156.168     0.150
     6.071    90.867     0.150
     6.071   161.066     0.150
     6.118    91.469     0.150
     6.214    94.469     0.150
     6.214   165.566     0.150
     6.325    94.539     0.150
     6.325   166.742     0.150
     6.488    94.887     0.150
     6.602    97.668     0.150
     6.634    99.066     0.150
     6.634   172.867     0.150
     6.659    98.066     0.150
     7.031   101.672     0.150
     7.031   176.246     0.150
     7.175   104.168     0.150
     7.507   109.469     0.150
     8.127   116.668     0.150
     8.127   204.668     0.150
     8.430   119.469     0.150
     8.430   211.367     0.150
     8.636   123.867     0.150
     8.636   214.867     0.150
     8.810   126.066     0.150
     8.810   220.066     0.150
     9.776   139.367     0.150
     9.776   242.766     0.150
     9.891   248.066     0.150
    18.080   252.719     0.150
    19.322   264.824     0.150
    20.614   282.719     0.150
    21.275   284.566     0.150
    36.679   428.266     0.150
    68.475   662.219     0.150
     0.570    11.684     0.150
     0.570    19.480     0.150
     0.629    11.582     0.150
     0.629    20.582     0.150
     0.655    11.684     0.150
     0.753    13.582     0.150
     0.727    12.980     0.150
     0.739    13.781     0.150
     0.739    23.582     0.150
     0.780    14.582     0.150
     0.836    14.781     0.150
     1.291    23.383     0.150
     1.497    26.980     0.150
     1.575    26.082     0.150
     1.575    49.383     0.150
     1.734    50.582     0.150
     1.892    31.883     0.150
     2.018    34.684     0.150
     2.301    38.980     0.150
     2.392    38.184     0.150
     2.450    39.961     0.150
     2.450    69.281     0.150
     2.620    43.082     0.150
     2.620    74.141     0.150
     2.664    42.461     0.150
     2.664    73.934     0.150
     2.903    47.012     0.150
     2.903    80.703     0.150
     2.948    46.641     0.150
     2.948    80.480     0.150
     3.033    48.582     0.150
     2.999    47.402     0.150
     2.999    82.312     0.150
     3.369    53.980     0.150
     3.362    53.660     0.150
     3.362    92.254     0.150
     3.540    55.660     0.150
     3.540    95.504     0.150
     3.555    55.754     0.150
     3.555    96.133     0.150
     3.651    57.281     0.150
     3.651    97.582     0.150
     3.851    66.582     0.150
     4.082    62.582     0.150
     4.082   105.883     0.150
     4.227    62.082     0.150
     4.227   110.082     0.150
     4.199    63.684     0.150
     4.299    64.480     0.150
     4.299   113.082     0.150
     4.585    71.082     0.150
     4.687    68.980     0.150
     4.687   122.883     0.150
     5.408    81.980     0.150
     5.408   139.980     0.150
     5.480    81.883     0.150
     6.009   157.980     0.150
     6.041    87.980     0.150
     6.041   154.684     0.150
     6.110   156.684     0.150
     6.110   159.980     0.150
     6.357    94.270     0.150
     6.357   168.535     0.150
     7.082   101.258     0.150
     7.082   176.344     0.150
     7.187   103.883     0.150
     7.513   107.383     0.150
     8.144   115.883     0.150
     8.144   203.582     0.150
     8.666   123.184     0.150
     8.666   216.480     0.150
     8.836   220.684     0.150
     9.792   241.980     0.150
    20.674   279.730     0.150
    36.626   427.781     0.150
    58.299   592.828     0.150
    68.518   660.891     0.150
     0.190     3.943     0.150
     0.190     6.143     0.150
     0.647    13.043     0.150
     0.647    22.843     0.150
     0.731    13.243     0.150
     0.731    24.043     0.150
     0.810    15.143     0.150
     0.847    14.843     0.150
     0.922    16.943     0.150
     0.922    31.743     0.150
     0.928    17.943     0.150
     1.175    20.843     0.150
     1.514    27.843     0.150
     1.489    27.443     0.150
     1.741    29.643     0.150
     1.741    54.443     0.150
     1.892    33.343     0.150
     2.041    35.343     0.150
     2.037    35.943     0.150
     2.299    39.143     0.150
     2.373    39.243     0.150
     2.385    40.543     0.150
     2.390    40.183     0.150
     2.390    70.743     0.150
     2.551    43.303     0.150
     2.551    76.493     0.150
     2.608    42.723     0.150
     2.608    75.143     0.150
     2.837    47.283     0.150
     2.837    82.303     0.150
     2.926    47.743     0.150
     2.901    46.483     0.150
     2.901    80.983     0.150
     2.942    47.223     0.150
     2.942    83.633     0.150
     3.024    49.943     0.150
     3.091    63.243     0.150
     3.206    52.343     0.150
     3.248    53.543     0.150
     3.304    54.143     0.150
     3.290    54.233     0.150
     3.290    94.173     0.150
     3.481    55.583     0.150
     3.481    96.623     0.150
     3.491    56.103     0.150
     3.491    97.683     0.150
     3.577    57.343     0.150
     3.577    65.443     0.150
     3.577    96.743     0.150
     3.887    61.243     0.150
     3.952    60.713     0.150
     3.952   106.193     0.150
     4.004    62.343     0.150
     4.004   107.143     0.150
     4.091    64.443     0.150
     4.032    64.243     0.150
     4.159    63.943     0.150
     4.159   113.843     0.150
     4.167    66.743     0.150
     4.237   114.043     0.150
     4.538    71.243     0.150
     4.618    70.343     0.150
     4.618   124.143     0.150
     4.703    71.143     0.150
     4.673    72.243     0.150
     4.748    74.243     0.150
     4.911    73.243     0.150
     5.075    75.643     0.150
     5.159    79.043     0.150
     5.169    78.343     0.150
     5.169   136.243     0.150
     5.491    83.243     0.150
     5.697    85.943     0.150
     5.697   149.643     0.150
     5.711    94.443     0.150
     5.769    88.243     0.150
     5.973    89.443     0.150
     5.973   156.343     0.150
     5.973   157.743     0.150
     6.058    91.243     0.150
     6.131    92.643     0.150
     6.131   160.643     0.150
     6.616    99.043     0.150
     6.631    99.743     0.150
     6.631   172.143     0.150
     6.675   100.943     0.150
     6.802   103.043     0.150
     6.802   177.643     0.150
     7.182   105.043     0.150
     7.182   183.043     0.150
     7.312   107.243     0.150
     8.132   117.743     0.150
     8.132   207.143     0.150
     8.431   121.043     0.150
     8.431   213.243     0.150
     8.635   124.043     0.150
     8.635   217.243     0.150
     8.811   127.243     0.150
     8.811   221.743     0.150
     9.782   139.043     0.150
     9.782   242.543     0.150
     9.898   140.643     0.150
     9.898   245.643     0.150
     0.176     4.672     0.150
     0.176     7.574     0.150
     0.187     4.875     0.150
     0.423     9.074     0.150
     0.522    10.473     0.150
     0.522    17.473     0.150
     0.646    12.074     0.150
     0.669    12.473     0.150
     0.669    22.973     0.150
     0.741    13.875     0.150
     0.834    14.973     0.150
     0.834    26.473     0.150
     0.841    14.773     0.150
     0.935    16.773     0.150
     0.935    30.375     0.150
     1.044    18.074     0.150
     1.190    20.574     0.150
     1.169    21.973     0.150
     1.236    21.375     0.150
     1.641    27.574     0.150
     1.661    27.875     0.150
     1.985    33.773     0.150
     1.905    32.574     0.150
     1.956    33.773     0.150
     2.105    35.273     0.150
     2.128    35.574     0.150
     2.329    38.172     0.150
     2.394    39.875     0.150
     2.251    37.773     0.150
     2.485    40.074     0.150
     2.394    39.074     0.150
     2.394    68.922     0.150
     2.394    39.074     0.150
     2.578    42.422     0.150
     2.578    74.172     0.150
     2.519    40.273     0.150
     2.602    41.965     0.150
     2.602    73.164     0.150
     2.855    46.422     0.150
     2.855    80.402     0.150
     2.878    45.703     0.150
     2.878    79.344     0.150
     3.040    48.074     0.150
     2.940    46.793     0.150
     2.940    81.695     0.150
     3.126    49.473     0.150
     3.355    53.273     0.150
     3.409    53.375     0.150
     3.324    53.043     0.150
     3.324    92.254     0.150
     3.382    53.773     0.150
     3.538    54.773     0.150
     3.483    54.672     0.150
     3.483    95.055     0.150
     3.503    55.312     0.150
     3.503    95.652     0.150
     3.602    56.973     0.150
     3.602   119.672     0.150
     3.632    55.074     0.150
     3.753    57.172     0.150
     4.071    63.172     0.150
     4.087    61.074     0.150
     3.938    61.273     0.150
     4.131    62.672     0.150
     4.131   108.574     0.150
     4.118    64.473     0.150
     4.118    70.473     0.150
     4.118   113.375     0.150
     4.118   123.773     0.150
     4.293    65.172     0.150
     4.293   113.375     0.150
     4.372    65.574     0.150
     4.372   113.273     0.150
     4.446    66.402     0.150
     4.555    67.445     0.150
     4.574    67.973     0.150
     4.515    70.273     0.150
     4.515    89.273     0.150
     4.703    69.395     0.150
     4.715    69.945     0.150
     4.721    69.793     0.150
     4.712    70.473     0.150
     4.752    70.875     0.150
     4.752   125.973     0.150
     4.772    70.715     0.150
     4.795    70.773     0.150
     4.662    71.273     0.150
     4.813    72.875     0.150
     4.813   126.875     0.150
     4.868    73.672     0.150
     4.868   127.473     0.150
     4.994    73.145     0.150
     5.020    73.844     0.150
     5.039    74.273     0.150
     4.997    82.074     0.150
     5.155    75.672     0.150
     5.194    76.574     0.150
     5.260    79.375     0.150
     5.268    77.754     0.150
     5.455    80.574     0.150
     5.455   144.672     0.150
     5.482    81.375     0.150
     5.482   143.273     0.150
     5.403    80.773     0.150
     5.382    79.875     0.150
     5.679    86.672     0.150
     5.868    86.172     0.150
     6.071    90.473     0.150
     6.091    89.973     0.150
     6.091   158.773     0.150
     6.106    90.074     0.150
     6.106   157.773     0.150
     6.161    92.574     0.150
     6.175    91.574     0.150
     6.174    91.273     0.150
     6.174   159.574     0.150
     6.194    91.672     0.150
     6.194   160.574     0.150
     6.207    91.875     0.150
     6.338    93.375     0.150
     6.338   165.473     0.150
     6.381    92.672     0.150
     6.381    96.473     0.150
     6.446    95.102     0.150
     6.446   167.305     0.150
     6.513    95.574     0.150
     6.558    98.172     0.150
     6.686    99.574     0.150
     6.719   170.574     0.150
     6.711   170.773     0.150
     6.740   100.574     0.150
     6.757    99.672     0.150
     6.757   173.473     0.150
     6.817   100.672     0.150
     6.817   100.773     0.150
     6.868   103.074     0.150
     6.944   100.672     0.150
     6.944   175.172     0.150
     6.836   101.773     0.150
     7.082   103.973     0.150
     7.082   104.375     0.150
     7.082   180.074     0.150
     7.120   104.172     0.150
     7.120   181.473     0.150
     7.150   102.973     0.150
     7.150   180.773     0.150
     7.150   103.160     0.150
     7.150   180.172     0.150
     7.181   103.273     0.150
     7.181   103.672     0.150
     7.181   181.074     0.150
     7.266   105.473     0.150
     7.280   105.074     0.150
     7.280   182.574     0.150
     7.300   104.273     0.150
     7.300   185.773     0.150
     7.318   105.875     0.150
     7.318   187.273     0.150
     7.446   107.574     0.150
     7.446   187.875     0.150
     7.560   109.484     0.150
     7.560   192.398     0.150
     7.589   109.773     0.150
     7.589   192.574     0.150
     7.604   110.875     0.150
     7.604   191.172     0.150
     7.726   111.184     0.150
     7.855   113.742     0.150
     8.032   114.953     0.150
     8.032   203.625     0.150
     8.216   117.273     0.150
     8.216   205.375     0.150
     8.237   117.672     0.150
     8.237   205.875     0.150
     8.259   116.973     0.150
     8.259   206.172     0.150
     8.118   118.875     0.150
     8.394   121.074     0.150
     8.418   137.273     0.150
     8.432   119.773     0.150
     8.432   211.172     0.150
     8.548   121.172     0.150
     8.548   213.375     0.150
     8.493   124.734     0.150
     8.672   123.172     0.150
     8.672   219.273     0.150
     8.722   124.773     0.150
     8.756   124.375     0.150
     8.756   217.574     0.150
     9.071   134.273     0.150
     9.229   131.172     0.150
     9.229   229.773     0.150
     9.229   230.273     0.150
     9.256   130.875     0.150
     9.656   138.273     0.150
     9.816   140.562     0.150
     9.885   138.672     0.150
     9.885   242.172     0.150
     9.971   140.473     0.150
     9.971   245.672     0.150
     9.999   140.672     0.150
     9.999   246.574     0.150
    10.192   143.574     0.150
    18.393   255.246     0.150
    19.439   265.223     0.150
    20.711   278.500     0.150
    82.315   741.164     0.150
    89.631   778.723     0.150
     0.187     4.992     0.150
     0.187     8.992     0.150
     0.255     7.195     0.150
     0.255    11.891     0.150
     0.415     8.594     0.150
     0.415     8.594     0.150
     0.686    12.992     0.150
     0.764    13.891     0.150
     0.764    24.289     0.150
     0.780    14.695     0.150
     0.780    25.695     0.150
     0.841    14.992     0.150
     1.006    17.891     0.150
     1.082    19.289     0.150
     1.082    34.289     0.150
     1.192    20.992     0.150
     1.192    37.789     0.150
     1.128    19.992     0.150
     1.281    22.992     0.150
     1.233    22.289     0.150
     1.233    39.695     0.150
     1.325    23.492     0.150
     1.287    22.594     0.150
     1.287    40.289     0.150
     1.447    24.992     0.150
     1.384    23.594     0.150
     1.553    27.391     0.150
     1.638    29.891     0.150
     1.791    29.992     0.150
     1.923    33.492     0.150
     1.914    32.891     0.150
     2.047    34.594     0.150
     2.162    35.289     0.150
     2.266    38.820     0.150
     2.343    37.992     0.150
     2.429    40.094     0.150
     2.441    40.055     0.150
     2.441    75.055     0.150
     2.508    81.586     0.150
     2.673    77.469     0.150
     2.752    44.789     0.150
     2.755    46.000     0.150
     2.788    44.930     0.150
     2.744    44.594     0.150
     2.854    44.094     0.150
     3.074    47.461     0.150
     3.263    53.969     0.150
     3.333    52.203     0.150
     3.333    96.148     0.150
     3.382    53.648     0.150
     3.382    98.820     0.150
     3.346    51.891     0.150
     3.489    54.445     0.150
     3.450    53.500     0.150
     3.511    53.680     0.150
     3.721    58.555     0.150
     3.775    59.055     0.150
     3.815    59.633     0.150
     3.845    59.992     0.150
     4.302    65.492     0.150
     4.549    69.711     0.150
     4.607    69.094     0.150
     4.607   118.695     0.150
     4.703    69.391     0.150
     4.703   121.391     0.150
     5.062    74.492     0.150
     5.062   129.391     0.150
     5.112    76.594     0.150
     5.177    75.211     0.150
     5.153    77.492     0.150
     5.564    81.992     0.150
     5.623    85.148     0.150
     5.734    83.594     0.150
     5.734   146.391     0.150
     5.816    84.992     0.150
     5.816   148.695     0.150
     6.416    92.992     0.150
     6.416   162.695     0.150
     6.447    94.094     0.150
     6.447   166.094     0.150
     6.530    95.289     0.150
     6.541    96.391     0.150
     6.555    95.594     0.150
     6.555   167.594     0.150
     6.816    99.867     0.150
     6.816   174.117     0.150
     7.007   101.891     0.150
     7.055   103.195     0.150
     7.124   103.891     0.150
     7.124   183.789     0.150
     7.186   105.695     0.150
     7.291   107.594     0.150
     7.466   106.445     0.150
     7.466   186.891     0.150
     7.638   110.391     0.150
     7.658   111.492     0.150
     7.762   111.992     0.150
     7.762   129.492     0.150
     7.762   193.492     0.150
     7.862   116.391     0.150
     7.951   117.492     0.150
     8.603   121.594     0.150
     8.918   126.992     0.150
     8.918   221.289     0.150
     9.298   130.891     0.150
     9.298   228.695     0.150
    10.249   254.594     0.150
    10.360   147.195     0.150
    10.547   150.195     0.150
    20.920   280.047     0.150
    36.264   421.156     0.150
    82.684   740.758     0.150
     0.517     8.981     0.150
     0.517    17.651     0.150
     0.499     9.401     0.150
     0.499    17.802     0.150
     0.558     9.932     0.150
     0.558    19.852     0.150
     0.732    13.481     0.150
     0.732    25.352     0.150
     0.791    15.052     0.150
     0.791    25.352     0.150
     0.792    16.081     0.150
     0.840    16.191     0.150
     0.840    29.231     0.150
     1.040    18.892     0.150
     1.040    34.211     0.150
     1.177    21.382     0.150
     1.293    23.781     0.150
     1.419    24.651     0.150
     1.635    28.281     0.150
     1.633    28.882     0.150
     1.647    28.151     0.150
     1.677    28.852     0.150
     1.788    30.621     0.150
     1.921    31.102     0.150
     2.012    34.012     0.150
     2.126    35.182     0.150
     2.534    40.691     0.150
     2.781    44.861     0.150
     2.781    77.921     0.150
     2.787    43.251     0.150
     2.866    44.932     0.150
     2.866    77.691     0.150
     2.958    47.562     0.150
     2.958    81.861     0.150
     2.988    47.861     0.150
     2.988    82.621     0.150
     3.239    51.371     0.150
     3.239    88.722     0.150
     3.260    51.802     0.150
     3.260    89.321     0.150
     3.327    52.401     0.150
     3.327    90.852     0.150
     3.700    57.342     0.150
     3.700   100.062     0.150
     3.759    60.151     0.150
     3.759   103.151     0.150
     3.869    60.411     0.150
     3.869   104.321     0.150
     3.888    60.361     0.150
     3.888   104.421     0.150
     3.888    60.361     0.150
     3.888   104.421     0.150
     3.922    64.151     0.150
     4.055    61.251     0.150
     4.055   108.671     0.150
     4.151    63.951     0.150
     4.151   112.052     0.150
     4.148    64.021     0.150
     4.148   109.361     0.150
     4.262    64.241     0.150
     4.262   112.852     0.150
     4.280    64.951     0.150
     4.280   114.552     0.150
     4.345    65.281     0.150
     4.345   115.621     0.150
     4.354    75.151     0.150
     4.354    87.751     0.150
     4.354   114.611     0.150
     4.354    66.151     0.150
     4.394    67.352     0.150
     4.394   115.352     0.150
     4.471    66.812     0.150
     4.471   117.521     0.150
     4.469    67.451     0.150
     4.469   120.852     0.150
     4.818    71.951     0.150
     4.818   126.251     0.150
     4.896    89.151     0.150
     5.902    86.651     0.150
     6.035    90.251     0.150
     6.035   158.151     0.150
     6.120    91.052     0.150
     6.120   160.451     0.150
     6.169    90.552     0.150
     6.169   159.852     0.150
     6.365    92.552     0.150
     6.411    93.552     0.150
     6.640    99.052     0.150
     6.640   174.451     0.150
     6.664    97.052     0.150
     6.664   171.151     0.150
     7.028   101.052     0.150
     7.028   178.151     0.150
     7.048   101.352     0.150
     7.048   179.951     0.150
     7.221   104.951     0.150
     7.322   106.251     0.150
     7.492   106.552     0.150
     7.492   187.951     0.150
     8.014   114.852     0.150
     8.100   116.451     0.150
     8.375   118.751     0.150
     8.375   208.151     0.150
     8.706   215.451     0.150
     8.752   122.251     0.150
     8.752   123.852     0.150
     8.752   218.052     0.150
     9.356   232.151     0.150
     9.653   136.352     0.150
     9.653   240.151     0.150
     0.448     9.016     0.150
     0.448    15.746     0.150
     0.510    10.348     0.150
     0.510    17.188     0.150
     0.520    10.035     0.150
     0.555    11.059     0.150
     0.743    14.137     0.150
     0.795    15.238     0.150
     0.793    15.137     0.150
     0.853    15.887     0.150
     1.052    19.027     0.150
     1.158    20.445     0.150
     1.189    21.148     0.150
     1.189    38.797     0.150
     1.285    22.695     0.150
     1.431    25.898     0.150
     1.630    29.227     0.150
     1.644    29.336     0.150
     1.673    29.738     0.150
     1.647    29.117     0.150
     1.781    31.516     0.150
     1.928    32.195     0.150
     2.023    35.168     0.150
     2.023    35.035     0.150
     2.115    36.348     0.150
     2.142    37.336     0.150
     2.142    36.738     0.150
     2.324    39.598     0.150
     2.522    41.977     0.150
     2.780    45.195     0.150
     2.780    80.586     0.150
     2.795    45.195     0.150
     2.853    46.117     0.150
     2.853    80.016     0.150
     2.891    47.488     0.150
     2.891    47.238     0.150
     2.955    47.746     0.150
     2.955    85.527     0.150
     2.988    48.188     0.150
     2.988    85.328     0.150
     3.137    51.547     0.150
     3.137    51.035     0.150
     3.111    49.938     0.150
     3.142    50.465     0.150
     3.184    51.238     0.150
     3.191    51.426     0.150
     3.237    52.426     0.150
     3.237    51.988     0.150
     3.237    92.105     0.150
     3.261    52.297     0.150
     3.261    91.695     0.150
     3.272    52.637     0.150
     3.300    54.957     0.150
     3.337    54.148     0.150
     3.326    53.258     0.150
     3.326    93.547     0.150
     3.455    55.637     0.150
     3.455    94.137     0.150
     3.500    56.977     0.150
     3.506    55.938     0.150
     3.536    55.785     0.150
     3.697    59.535     0.150
     3.697   103.027     0.150
     3.734    59.477     0.150
     3.740    59.016     0.150
     3.750    60.438     0.150
     3.753    58.766     0.150
     3.762    59.637     0.150
     3.796    60.625     0.150
     3.796    59.637     0.150
     3.774    59.977     0.150
     3.774    59.836     0.150
     3.803    59.516     0.150
     3.803   103.059     0.150
     3.821    60.535     0.150
     3.868    61.547     0.150
     3.868   106.727     0.150
     3.901    62.988     0.150
     3.887    61.898     0.150
     3.887   107.547     0.150
     3.887    61.898     0.150
     3.887   107.547     0.150
     3.911    61.938     0.150
     3.911   108.617     0.150
     3.937    61.496     0.150
     3.937    60.637     0.150
     3.959    61.875     0.150
     3.959   104.996     0.150
     3.977    64.117     0.150
     4.043    62.777     0.150
     4.043   107.746     0.150
     4.082    62.188     0.150
     4.073    64.508     0.150
     4.115    65.008     0.150
     4.136    64.207     0.150
     4.172    64.367     0.150
     4.192    64.836     0.150
     4.192   111.535     0.150
     4.206    67.137     0.150
     4.256    67.727     0.150
     4.250    65.656     0.150
     4.227    65.637     0.150
     4.268    65.637     0.150
     4.268    65.738     0.150
     4.285    67.637     0.150
     4.285   133.137     0.150
     4.333    67.027     0.150
     4.324    69.336     0.150
     4.342    67.316     0.150
     4.342   115.758     0.150
     4.342    66.535     0.150
     4.370    68.445     0.150
     4.382    66.238     0.150
     4.382    67.438     0.150
     4.463    68.336     0.150
     4.463   121.438     0.150
     4.463    68.836     0.150
     4.459    68.176     0.150
     4.454    70.188     0.150
     4.497    71.047     0.150
     4.481    70.137     0.150
     4.553    68.398     0.150
     4.556    68.285     0.150
     4.565    71.336     0.150
     4.576    68.828     0.150
     4.649    69.516     0.150
     4.649    70.035     0.150
     4.646    72.918     0.150
     4.680    69.898     0.150
     4.686    70.348     0.150
     4.736    70.938     0.150
     4.735    71.059     0.150
     4.745    70.625     0.150
     4.788    71.008     0.150
     4.788    71.238     0.150
     4.806    73.238     0.150
     4.806   129.738     0.150
     4.805    73.617     0.150
     4.824    72.785     0.150
     4.866    73.137     0.150
     4.925    73.277     0.150
     4.897    76.035     0.150
     4.897   147.238     0.150
     4.931    73.727     0.150
     4.985    74.016     0.150
     4.971    76.566     0.150
     5.000    74.926     0.150
     5.000    75.035     0.150
     4.974    76.137     0.150
     5.022    74.758     0.150
     5.022    75.438     0.150
     5.040    75.656     0.150
     5.040    75.836     0.150
     5.066    75.625     0.150
     5.117    76.215     0.150
     5.117    77.535     0.150
     5.200    77.867     0.150
     5.254    80.348     0.150
     5.254   138.605     0.150
     5.330    80.637     0.150
     5.388    82.637     0.150
     5.440    82.488     0.150
     5.451    82.438     0.150
     5.482    82.637     0.150
     5.482   146.035     0.150
     5.482    82.535     0.150
     5.505    83.746     0.150
     5.559    82.836     0.150
     5.559   148.035     0.150
     5.559   182.035     0.150
     5.599    85.168     0.150
     5.621    84.637     0.150
     5.703    86.035     0.150
     5.752    88.195     0.150
     5.754    87.156     0.150
     5.771    86.098     0.150
     5.796    86.238     0.150
     5.776    86.938     0.150
     5.776   108.438     0.150
     5.855    89.238     0.150
     5.835    94.738     0.150
     5.857    87.438     0.150
     5.867    87.035     0.150
     5.895    88.637     0.150
     5.895    89.938     0.150
     5.903    89.836     0.150
     5.932    88.535     0.150
     5.944    90.535     0.150
     5.970    87.137     0.150
     5.975    89.637     0.150
     5.976    91.637     0.150
     6.022    90.137     0.150
     6.022   159.738     0.150
     6.032    92.578     0.150
     6.072    92.535     0.150
     6.041    90.637     0.150
     6.076    88.785     0.150
     6.099    92.637     0.150
     6.099    92.836     0.150
     6.102    93.348     0.150
     6.102    92.348     0.150
     6.104    91.535     0.150
     6.104   161.535     0.150
     6.108    91.836     0.150
     6.108   161.238     0.150
     6.124    92.637     0.150
     6.156    91.938     0.150
     6.156   162.238     0.150
     6.185    91.637     0.150
     6.185   158.637     0.150
     6.218    92.336     0.150
     6.238    94.738     0.150
     6.251    93.738     0.150
     6.251   165.137     0.150
     6.255    94.457     0.150
     6.255    94.336     0.150
     6.247    92.535     0.150
     6.243    94.637     0.150
     6.281    94.637     0.150
     6.342    96.027     0.150
     6.358    94.938     0.150
     6.360    93.008     0.150
     6.363    92.836     0.150
     6.370    94.836     0.150
     6.370   164.836     0.150
     6.389    95.086     0.150
     6.405    95.336     0.150
     6.405   167.035     0.150
     6.405    95.438     0.150
     6.431    92.848     0.150
     6.482    96.938     0.150
     6.529    94.938     0.150
     6.531    94.828     0.150
     6.532    99.637     0.150
     6.554    95.535     0.150
     6.625    95.336     0.150
     6.625    95.738     0.150
     6.628    98.535     0.150
     6.628   174.137     0.150
     6.640    98.035     0.150
     6.619    97.637     0.150
     6.656    99.238     0.150
     6.656   100.938     0.150
     6.673    98.137     0.150
     6.673   171.137     0.150
     6.673   197.637     0.150
     6.725   100.648     0.150
     6.766    97.559     0.150
     6.786   100.035     0.150
     6.787   101.938     0.150
     6.786   100.637     0.150
     6.854   101.637     0.150
     6.875   101.547     0.150
     6.875   100.637     0.150
     6.875   175.438     0.150
     6.875   203.535     0.150
     6.909   101.836     0.150
     6.939   100.836     0.150
     6.947   101.535     0.150
     6.950   101.238     0.150
     6.945   103.637     0.150
     6.987   104.738     0.150
     6.988   105.137     0.150
     6.992   101.938     0.150
     7.018   102.438     0.150
     7.018   101.938     0.150
     7.039   102.836     0.150
     7.083   103.238     0.150
     7.083   103.738     0.150
     7.084   106.836     0.150
     7.127   104.035     0.150
     7.153   104.875     0.150
     7.153   108.535     0.150
     7.153   108.035     0.150
     7.181   104.637     0.150
     7.189   107.336     0.150
     7.186   104.938     0.150
     7.186   184.836     0.150
     7.199   104.938     0.150
     7.214   107.637     0.150
     7.218   105.836     0.150
     7.230   106.637     0.150
     7.234   106.438     0.150
     7.234   105.535     0.150
     7.234   106.238     0.150
     7.266   108.836     0.150
     7.278   109.438     0.150
     7.314   109.137     0.150
     7.314   186.938     0.150
     7.314   110.438     0.150
     7.308   106.637     0.150
     7.329   109.637     0.150
     7.360   107.535     0.150
     7.457   111.637     0.150
     7.480   108.637     0.150
     7.480   121.836     0.150
     7.480   190.438     0.150
     7.532   111.738     0.150
     7.567   110.906     0.150
     7.569   109.637     0.150
     7.576   109.535     0.150
     7.576   110.137     0.150
     7.620   109.637     0.150
     7.630   110.777     0.150
     7.630   194.238     0.150
     7.693   114.211     0.150
     7.693   194.582     0.150
     7.693   244.020     0.150
     7.722   111.988     0.150
     7.745   113.637     0.150
     7.796   113.059     0.150
     7.801   112.215     0.150
     7.801   112.938     0.150
     7.859   113.938     0.150
     7.873   113.035     0.150
     7.888   113.035     0.150
     7.878   115.637     0.150
     7.972   115.535     0.150
     7.948   117.938     0.150
     8.004   115.836     0.150
     8.004   201.637     0.150
     7.987   118.137     0.150
     8.019   117.137     0.150
     8.061   116.137     0.150
     8.061   115.566     0.150
     8.087   117.438     0.150
     8.087   117.238     0.150
     8.093   119.035     0.150
     8.093   205.836     0.150
     8.093   120.637     0.150
     8.125   117.246     0.150
     8.177   120.637     0.150
     8.177   206.777     0.150
     8.254   118.438     0.150
     8.254   118.156     0.150
     8.254   118.836     0.150
     8.257   120.035     0.150
     8.274   118.438     0.150
     8.278   121.738     0.150
     8.284   119.738     0.150
     8.284   133.336     0.150
     8.284   210.438     0.150
     8.364   119.637     0.150
     8.364   210.637     0.150
     8.364   120.637     0.150
     8.369   122.637     0.150
     8.369   136.637     0.150
     8.355   122.637     0.150
     8.386   121.738     0.150
     8.386   209.938     0.150
     8.386   121.738     0.150
     8.386   209.938     0.150
     8.442   123.637     0.150
     8.441   123.637     0.150
     8.441   138.137     0.150
     8.441   216.336     0.150
     8.435   122.637     0.150
     8.506   121.836     0.150
     8.506   121.578     0.150
     8.506   122.336     0.150
     8.533   127.035     0.150
     8.565   123.535     0.150
     8.565   123.059     0.150
     8.572   127.238     0.150
     8.669   126.637     0.150
     8.685   125.336     0.150
     8.694   126.938     0.150
     8.694   140.738     0.150
     8.694   220.035     0.150
     8.700   127.938     0.150
     8.741   125.035     0.150
     8.741   218.938     0.150
     8.741   125.535     0.150
     8.727   127.637     0.150
     8.816   127.836     0.150
     8.816   127.246     0.150
     8.816   128.938     0.150
     8.864   131.656     0.150
     8.864   131.836     0.150
     8.902   128.188     0.150
     8.902   221.496     0.150
     8.920   129.137     0.150
     8.960   129.648     0.150
     8.971   130.738     0.150
     9.013   131.637     0.150
     9.069   129.535     0.150
     9.067   136.836     0.150
     9.137   134.738     0.150
     9.171   135.336     0.150
     9.171   134.637     0.150
     9.169   134.336     0.150
     9.190   132.438     0.150
     9.190   133.035     0.150
     9.190   135.035     0.150
     9.190   150.836     0.150
     9.187   135.438     0.150
     9.187   286.035     0.150
     9.221   131.836     0.150
     9.221   230.438     0.150
     9.221   229.637     0.150
     9.313   137.156     0.150
     9.313   135.938     0.150
     9.347   133.637     0.150
     9.347   235.836     0.150
     9.373   137.285     0.150
     9.446   136.637     0.150
     9.502   137.438     0.150
     9.502   138.035     0.150
     9.504   137.738     0.150
     9.504   138.336     0.150
     9.537   137.836     0.150
     9.544   138.938     0.150
     9.621   138.836     0.150
     9.621   242.238     0.150
     9.622   142.836     0.150
     9.622   141.137     0.150
     9.643   137.738     0.150
     9.643   242.336     0.150
     9.643   139.535     0.150
     9.624   140.137     0.150
     9.689   139.637     0.150
     9.689   244.637     0.150
     9.689   281.637     0.150
     9.699   141.535     0.150
     9.712   138.535     0.150
     9.718   139.035     0.150
     9.718   243.738     0.150
     9.796   142.137     0.150
     9.922   142.035     0.150
     9.922   143.035     0.150
     9.897   144.836     0.150
     9.967   145.035     0.150
     9.937   144.035     0.150
     9.985   143.828     0.150
     9.989   145.727     0.150
     9.989   254.047     0.150
     9.976   145.637     0.150
     9.983   145.637     0.150
    10.033   147.977     0.150
    10.033   258.578     0.150
    10.044   146.637     0.150
    10.218   147.035     0.150
    10.218   256.938     0.150
    10.296   148.637     0.150
    10.314   151.637     0.150
    10.360   152.035     0.150
    10.368   149.246     0.150
    10.490   151.828     0.150
    10.578   151.637     0.150
    10.678   155.328     0.150
    10.666   155.238     0.150
    10.731   155.836     0.150
    10.806   158.836     0.150
    10.806   159.637     0.150
    10.803   156.078     0.150
    10.847   157.836     0.150
    10.852   156.238     0.150
    10.872   155.258     0.150
    10.879   156.336     0.150
    10.892   156.637     0.150
    10.931   156.738     0.150
    10.931   271.938     0.150
    10.970   158.105     0.150
    10.970   270.996     0.150
    10.978   158.816     0.150
    10.991   158.316     0.150
    11.051   160.535     0.150
    11.179   160.535     0.150
    11.179   277.738     0.150
    11.159   162.637     0.150
    11.280   162.637     0.150
    11.316   163.535     0.150
    11.390   165.836     0.150
    11.487   164.215     0.150
    11.509   165.938     0.150
    11.509   167.137     0.150
    11.580   168.035     0.150
    11.686   168.105     0.150
    11.666   169.137     0.150
    11.825   171.738     0.150
    11.854   170.336     0.150
    11.944   172.988     0.150
    12.224   173.648     0.150
    12.234   176.656     0.150
    12.324   177.195     0.150
    12.381   179.637     0.150
    12.635   185.336     0.150
    12.648   185.836     0.150
    12.890   184.926     0.150
    12.916   184.637     0.150
    12.916   320.637     0.150
    12.922   185.148     0.150
    12.942   186.168     0.150
    12.997   188.617     0.150
    12.991   187.938     0.150
    13.273   190.438     0.150
    13.356   191.836     0.150
    13.415   192.035     0.150
    13.495   193.035     0.150
    13.495   193.355     0.150
    13.652   196.035     0.150
    13.839   196.996     0.150
    13.963   197.336     0.150
    13.963   199.238     0.150
    14.001   201.176     0.150
    14.032   202.547     0.150
    14.081   197.238     0.150
    14.081   211.535     0.150
    14.155   204.637     0.150
    14.228   201.438     0.150
    14.358   206.785     0.150
    14.359   204.637     0.150
    14.359   360.637     0.150
    14.384   207.035     0.150
    14.452   205.625     0.150
    14.452   205.848     0.150
    14.578   210.957     0.150
    14.760   210.477     0.150
    14.774   209.828     0.150
    14.915   211.238     0.150
    14.985   217.617     0.150
    15.027   214.105     0.150
    15.054   215.906     0.150
    15.098   218.125     0.150
    15.198   219.258     0.150
    15.218   215.238     0.150
    15.329   220.137     0.150
    15.329   221.137     0.150
    15.402   221.688     0.150
    15.402   222.438     0.150
    15.408   215.637     0.150
    15.548   224.438     0.150
    15.553   220.637     0.150
    15.594   221.238     0.150
    15.947   226.035     0.150
    15.947   224.137     0.150
    15.962   227.695     0.150
    15.944   223.945     0.150
    16.126   225.945     0.150
    16.244   223.066     0.150
    16.239   235.836     0.150
    16.310   229.777     0.150
    16.330   231.078     0.150
    16.381   230.098     0.150
    16.425   227.488     0.150
    16.400   237.738     0.150
    16.475   231.617     0.150
    16.649   238.375     0.150
    16.699   233.336     0.150
    16.787   238.637     0.150
    16.852   236.965     0.150
    16.853   234.078     0.150
    16.943   241.836     0.150
    16.972   239.238     0.150
    16.972   443.035     0.150
    16.972   237.566     0.150
    17.044   239.938     0.150
    17.111   244.336     0.150
    17.116   240.887     0.150
    17.172   240.738     0.150
    17.184   241.328     0.150
    17.336   243.688     0.150
    17.378   244.445     0.150
    17.378   245.938     0.150
    17.355   243.637     0.150
    17.434   249.836     0.150
    17.712   250.238     0.150
    17.724   250.078     0.150
    17.743   248.438     0.150
    17.795   251.836     0.150
    17.796   250.336     0.150
    17.810   252.035     0.150
    17.844   251.035     0.150
    17.941   249.816     0.150
    18.006   254.988     0.150
    18.065   251.336     0.150
    18.065   252.926     0.150
    18.065   250.996     0.150
    18.065   259.309     0.150
    18.262   457.285     0.150
    18.262   252.348     0.150
    18.262   254.535     0.150
    18.286   255.215     0.150
    18.325   259.035     0.150
    18.331   257.766     0.150
    18.342   263.035     0.150
    18.342   467.035     0.150
    18.388   256.836     0.150
    18.413   260.598     0.150
    18.461   255.035     0.150
    18.430   256.551     0.150
    18.430   466.477     0.150
    18.464   256.066     0.150
    18.464   462.727     0.150
    18.464   257.125     0.150
    18.464   255.895     0.150
    18.464   463.492     0.150
    18.520   257.707     0.150
    18.518   257.137     0.150
    18.591   478.035     0.150
    18.645   259.938     0.150
    18.691   262.406     0.150
    18.740   260.238     0.150
    18.777   261.137     0.150
    18.789   260.488     0.150
    18.789   260.727     0.150
    18.789   261.508     0.150
    18.789   466.918     0.150
    18.789   467.527     0.150
    18.789   468.266     0.150
    18.873   259.438     0.150
    18.908   260.367     0.150
    18.964   257.336     0.150
    18.956   262.438     0.150
    19.013   263.238     0.150
    19.015   263.828     0.150
    19.053   262.117     0.150
    19.123   264.367     0.150
    19.149   262.938     0.150
    19.170   262.238     0.150
    19.256   265.738     0.150
    19.318   265.496     0.150
    19.361   265.137     0.150
    19.408   267.438     0.150
    19.488   267.938     0.150
    19.488   267.938     0.150
    19.559   267.336     0.150
    19.559   266.738     0.150
    19.624   273.906     0.150
    19.708   272.938     0.150
    19.755   269.336     0.150
    19.752   270.336     0.150
    19.774   271.336     0.150
    19.917   273.438     0.150
    19.917   506.336     0.150
    20.096   278.637     0.150
    20.186   275.938     0.150
    20.186   277.414     0.150
    20.212   277.137     0.150
    20.331   278.938     0.150
    20.409   278.336     0.150
    20.409   504.535     0.150
    20.409   278.438     0.150
    20.417   279.438     0.150
    20.451   278.938     0.150
    20.451   293.336     0.150
    20.451   502.137     0.150
    20.451   533.238     0.150
    20.471   278.438     0.150
    20.471   279.668     0.150
    20.471   281.035     0.150
    20.643   281.637     0.150
    20.687   280.637     0.150
    20.687   299.637     0.150
    20.687   516.637     0.150
    20.734   282.637     0.150
    20.734   299.637     0.150
    20.734   513.637     0.150
    20.891   281.836     0.150
    20.891   282.137     0.150
    21.459   292.637     0.150
    21.459   526.637     0.150
    21.549   288.836     0.150
    22.925   307.117     0.150
    22.925   548.957     0.150
    24.062   316.637     0.150
    24.062   343.637     0.150
    24.062   570.137     0.150
    24.062   618.137     0.150
    24.512   322.059     0.150
    26.161   337.137     0.150
    26.194   337.285     0.150
    26.217   336.547     0.150
    27.032   344.535     0.150
    27.719   350.117     0.150
    27.801   352.238     0.150
    27.801   633.637     0.150
    28.068   352.828     0.150
    28.273   355.727     0.150
    28.331   353.738     0.150
    28.331   635.738     0.150
    28.438   354.898     0.150
    28.438   354.117     0.150
    28.560   358.227     0.150
    28.637   358.148     0.150
    28.718   359.316     0.150
    28.810   357.738     0.150
    28.955   361.156     0.150
    29.130   363.246     0.150
    29.359   365.727     0.150
    29.727   368.156     0.150
    30.284   372.195     0.150
    31.289   382.535     0.150
    31.289   382.309     0.150
    31.566   382.445     0.150
    31.566   696.336     0.150
    31.623   695.066     0.150
    32.759   393.637     0.150
    32.759   708.637     0.150
    33.157   396.938     0.150
    33.157   397.297     0.150
    34.074   408.016     0.150
    37.503   434.258     0.150
    37.503   434.836     0.150
    37.932   439.637     0.150
    37.932   577.637     0.150
    38.262   441.527     0.150
    38.262   441.637     0.150
    38.402   441.695     0.150
    38.402   442.238     0.150
    39.060   447.277     0.150
    39.149   449.938     0.150
    39.296   451.438     0.150
    39.534   452.535     0.150
    40.448   460.336     0.150
    43.389   484.637     0.150
    43.389     4.000     0.150
    43.389   588.637     0.150
    43.750   486.336     0.150
    43.750   485.906     0.150
    44.844   900.637     0.150
    45.529   500.137     0.150
    45.529   609.637     0.150
    45.529   902.637     0.150
    45.559   504.438     0.150
    45.559   907.637     0.150
    46.632   509.262     0.150
    47.208   513.887     0.150
    47.204   515.824     0.150
    48.511   523.738     0.150
    48.643   527.637     0.150
    48.643   947.637     0.150
    48.886   530.348     0.150
    48.919   530.637     0.150
    49.898   534.637     0.150
    50.230   536.637     0.150
    50.823   540.836     0.150
    50.799   544.367     0.150
    50.799   977.957     0.150
    51.532   546.438     0.150
    51.532   985.637     0.150
    52.917   555.863     0.150
    53.375   565.137     0.150
    53.852   565.086     0.150
    53.852  1021.117     0.150
    54.707   570.906     0.150
    54.707   571.617     0.150
    54.848   571.637     0.150
    54.848   571.828     0.150
    54.848     1.719     0.150
    55.137   573.348     0.150
    55.137   574.238     0.150
    55.856   579.277     0.150
    55.856     3.211     0.150
    56.561   584.137     0.150
    56.611   585.238     0.150
    56.611     3.098     0.150
    56.611   713.238     0.150
    56.665   587.668     0.150
    56.665  1050.598     0.150
    56.802   583.637     0.150
    57.397   589.637     0.150
    57.836   591.938     0.150
    57.961   593.738     0.150
    57.989   593.738     0.150
    58.071   595.535     0.150
    58.071   594.797     0.150
    58.148   598.438     0.150
    58.148  1068.336     0.150
    58.148  1081.438     0.150
    58.205   596.238     0.150
    58.363   596.938     0.150
    58.487   597.836     0.150
    59.044   600.637     0.150
    59.044  1084.637     0.150
    60.232   607.535     0.150
    60.519   611.465     0.150
    60.519  1103.176     0.150
    61.050   616.098     0.150
    61.216   617.137     0.150
    61.216   756.637     0.150
    61.216  1112.637     0.150
    61.216   616.785     0.150
    61.511   617.676     0.150
    61.688   618.156     0.150
    61.897   620.914     0.150
    61.897   620.688     0.150
    61.897   621.535     0.150
    61.934   621.637     0.150
    61.934   759.938     0.150
    61.934  1125.137     0.150
    61.934  1368.637     0.150
    62.007   620.637     0.150
    62.136   621.438     0.150
    62.429   624.355     0.150
    62.429     3.109     0.150
    63.259   631.465     0.150
    63.616  1141.227     0.150
    64.116   672.438     0.150
    64.116  1152.336     0.150
    64.116  1166.535     0.150
    64.116  1406.137     0.150
    64.104   634.137     0.150
    64.104  1148.637     0.150
    64.679   638.785     0.150
    65.606   644.938     0.150
    65.606   676.637     0.150
    65.606   788.637     0.150
    65.606  1177.637     0.150
    66.045   649.637     0.150
    66.434   796.137     0.150
    66.434  1176.137     0.150
    66.434  1433.137     0.150
    66.434  1184.137     0.150
    67.121   654.188     0.150
    67.121   655.336     0.150
    67.778   658.137     0.150
    67.778   657.707     0.150
    67.967   660.941     0.150
    67.967   660.328     0.150
    68.063   660.156     0.150
    68.475   666.938     0.150
    68.475   663.637     0.150
    68.475   664.438     0.150
    68.475     2.500     0.150
    68.535   663.684     0.150
    68.535   662.938     0.150
    68.537   666.137     0.150
    68.537   691.137     0.150
    68.537   821.137     0.150
    68.537  1204.137     0.150
    69.417   669.938     0.150
    69.417   825.938     0.150
    69.417  1216.637     0.150
    69.596   668.867     0.150
    69.642   669.398     0.150
    69.904   671.438     0.150
    69.904   671.277     0.150
    70.011   676.938     0.150
    70.260   673.910     0.150
    70.984   680.137     0.150
    70.984  1237.637     0.150
    70.995   678.438     0.150
    70.995  1230.637     0.150
    71.599   683.445     0.150
    71.803   687.438     0.150
    71.803  1239.137     0.150
    71.803   687.336     0.150
    71.813   687.121     0.150
    71.813   683.707     0.150
    72.181   684.727     0.150
    72.194   686.855     0.150
    72.194   687.035     0.150
    72.232   685.195     0.150
    72.232   688.035     0.150
    72.219   686.637     0.150
    72.219   705.137     0.150
    72.219   848.938     0.150
    72.219  1246.137     0.150
    72.219  1286.137     0.150
    72.219  1527.637     0.150
    72.219   848.836     0.150
    72.219  1246.035     0.150
    72.219  1252.238     0.150
    72.219  1527.535     0.150
    72.359   686.617     0.150
    72.359   688.137     0.150
    72.721   690.035     0.150
    72.721   851.137     0.150
    72.721  1255.238     0.150
    72.897   691.438     0.150
    72.899   690.887     0.150
    73.604   694.430     0.150
    73.705   694.855     0.150
    73.811   694.336     0.150
    74.121   697.367     0.150
    74.157   698.137     0.150
    74.157   868.637     0.150
    74.157  1271.438     0.150
    74.157  1278.637     0.150
    74.524   700.137     0.150
    74.524  1262.938     0.150
    74.524  1280.438     0.150
    74.524  1558.438     0.150
    74.836   703.137     0.150
    74.864   703.938     0.150
    75.455   705.648     0.150
    75.455   706.438     0.150
    75.737   708.438     0.150
    75.961   706.328     0.150
    75.961   706.738     0.150
    76.029   709.086     0.150
    76.029   708.438     0.150
    76.095   707.086     0.150
    76.083   704.637     0.150
    76.083   717.137     0.150
    76.083   874.438     0.150
    76.083  1287.438     0.150
    76.083  1319.137     0.150
    76.083  1579.637     0.150
    76.238   708.875     0.150
    76.238   709.438     0.150
    76.255   709.938     0.150
    76.623   712.836     0.150
    76.701   711.059     0.150
    76.760   715.438     0.150
    76.914   712.738     0.150
    77.228   714.336     0.150
    77.247   713.836     0.150
    77.412   716.547     0.150
    77.412   717.938     0.150
    77.684   716.176     0.150
    78.522   722.477     0.150
    78.522   723.137     0.150
    78.658   725.637     0.150
    78.658  1318.637     0.150
    78.658  1329.637     0.150
    78.832   723.387     0.150
    79.013   724.598     0.150
    79.727   728.707     0.150
    79.727   729.137     0.150
    80.046   731.117     0.150
    80.214   731.477     0.150
    80.214   731.938     0.150
    80.300   732.148     0.150
    80.324   731.637     0.150
    80.324   737.238     0.150
    80.324   915.637     0.150
    80.324  1340.637     0.150
    80.324  1348.637     0.150
    80.347   731.938     0.150
    80.347   733.137     0.150
    80.473   732.637     0.150
    80.593   737.438     0.150
    80.593  1341.035     0.150
    80.593  1656.836     0.150
    80.759   735.105     0.150
    80.767   740.137     0.150
    80.767  1341.637     0.150
    80.767  1355.938     0.150
    80.767  1341.535     0.150
    80.822   734.438     0.150
    80.844   735.297     0.150
    80.894   735.684     0.150
    80.894   734.746     0.150
    80.894   735.836     0.150
    80.961   740.637     0.150
    80.961  1350.637     0.150
    81.124   737.137     0.150
    81.158   740.938     0.150
    81.158   745.938     0.150
    81.158  1344.938     0.150
    81.158  1352.938     0.150
    81.158  1659.637     0.150
    81.291   738.727     0.150
    81.319   738.395     0.150
    81.366   739.035     0.150
    81.625   739.336     0.150
    81.625   739.938     0.150
    81.978   741.637     0.150
    82.154   741.836     0.150
    82.229   741.926     0.150
    82.328   741.688     0.150
    82.544   744.535     0.150
    82.544   745.035     0.150
    82.624   744.246     0.150
    82.624   745.035     0.150
    82.812   744.227     0.150
    82.855   745.758     0.150
    83.275   747.316     0.150
    83.275   749.035     0.150
    83.325   747.898     0.150
    83.325   748.637     0.150
    83.360   748.445     0.150
    83.539   747.918     0.150
    83.663   749.926     0.150
    83.758   750.281     0.150
    83.885   750.465     0.150
    83.885   751.836     0.150
    83.932   749.926     0.150
    83.985   750.965     0.150
    84.046   751.977     0.150
    84.302   753.047     0.150
    84.515   754.508     0.150
    84.564   755.016     0.150
    84.564   756.836     0.150
    84.731   755.266     0.150
    84.767   756.535     0.150
    84.792   755.867     0.150
    84.792   756.836     0.150
    84.797   755.215     0.150
    85.295   758.328     0.150
    85.338   759.188     0.150
    85.681   760.785     0.150
    86.304   762.977     0.150
    86.304   764.035     0.150
    86.315   763.566     0.150
    86.315   765.238     0.150
    86.458   763.355     0.150
    86.458   767.336     0.150
    86.458   763.535     0.150
    86.458  1395.637     0.150
    86.458   763.637     0.150
    86.458  1392.637     0.150
    86.460   764.098     0.150
    86.679   765.176     0.150
    86.679   766.336     0.150
    86.736   765.559     0.150
    86.736   766.238     0.150
    87.121   768.496     0.150
    87.379   768.715     0.150
    87.453   768.727     0.150
    87.455   768.738     0.150
    87.494   773.137     0.150
    87.550   767.996     0.150
    87.635   769.566     0.150
    88.739   775.207     0.150
    89.204   776.215     0.150
    89.399   777.957     0.150
    89.399   779.137     0.150
    89.399   778.961     0.150
    89.435   777.625     0.150
    89.435   779.637     0.150
    89.490   778.207     0.150
    89.490   779.137     0.150
    89.557   779.512     0.150
    89.882   779.906     0.150
    89.882   780.637     0.150
    90.109   780.836     0.150
    90.222   781.367     0.150
    90.570   783.156     0.150
    90.769   785.250     0.150
    90.769   784.848     0.150
    90.769   785.438     0.150
    90.986   785.617     0.150
    90.986   785.938     0.150
    92.730   793.117     0.150
    92.730   794.438     0.150
   124.821  1140.320     0.150
   124.821  1244.320     0.150
   126.690  1146.238     0.150
   126.692  1144.137     0.150
   126.692  1258.086     0.150
   131.518  1152.336     0.150
   133.737  1158.836     0.150
   136.808  1164.586     0.150
   148.991  1179.133     0.150
   149.056  1193.320     0.150
   149.504  1197.238     0.150
   149.599  1197.535     0.150
   152.399  1200.238     0.150
   152.560  1201.535     0.150
   152.589  1201.035     0.150
     0.482     8.715     0.150
     0.482    16.484     0.150
     0.485     8.816     0.150
     0.485    17.105     0.150
     0.492     9.535     0.150
     0.722    25.395     0.150
     0.759    15.016     0.150
     0.759    25.816     0.150
     0.825    15.645     0.150
     0.850    16.055     0.150
     1.038    19.215     0.150
     1.192    20.637     0.150
     1.180    21.527     0.150
     1.418    25.055     0.150
     1.665    29.176     0.150
     1.637    28.445     0.150
     1.813    32.406     0.150
     1.897    31.305     0.150
     2.003    34.375     0.150
     2.139    36.355     0.150
     2.169    37.566     0.150
     2.307    39.176     0.150
     2.544    41.547     0.150
     2.746    44.234     0.150
     2.746    77.797     0.150
     2.854    45.195     0.150
     2.854    79.285     0.150
     2.917    47.477     0.150
     2.923    47.727     0.150
     2.923    82.375     0.150
     2.954    47.656     0.150
     2.954    82.805     0.150
     3.162    52.016     0.150
     3.098    50.727     0.150
     3.209    51.867     0.150
     3.219    52.957     0.150
     3.267    53.137     0.150
     3.204    51.387     0.150
     3.204    88.855     0.150
     3.226    50.945     0.150
     3.226    88.707     0.150
     3.293    52.035     0.150
     3.293    90.637     0.150
     3.666    58.285     0.150
     3.666   100.375     0.150
     3.732    58.156     0.150
     3.747    57.906     0.150
     3.835    60.395     0.150
     3.835   103.906     0.150
     3.902    63.516     0.150
     3.854    60.695     0.150
     3.854   103.836     0.150
     3.854    60.695     0.150
     3.854   103.836     0.150
     3.964    61.785     0.150
     4.046    61.527     0.150
     4.046   110.766     0.150
     4.089    61.645     0.150
     4.133    63.195     0.150
     4.133   110.875     0.150
     4.248    64.594     0.150
     4.262    65.516     0.150
     4.262   114.414     0.150
     4.329    65.926     0.150
     4.329   115.164     0.150
     4.344    65.984     0.150
     4.344    84.516     0.150
     4.344   115.277     0.150
     4.387    65.715     0.150
     4.387   116.516     0.150
     4.456    67.426     0.150
     4.456   117.555     0.150
     4.497    69.016     0.150
     4.497   121.516     0.150
     4.808    72.117     0.150
     4.808   127.316     0.150
     4.808   155.516     0.150
     4.832    71.734     0.150
     4.947    73.387     0.150
     4.863    83.215     0.150
     4.863   130.016     0.150
     5.127    75.555     0.150
     5.489    82.215     0.150
     5.489   144.414     0.150
     5.489   177.715     0.150
     5.887   151.715     0.150
     5.927    89.117     0.150
     5.951    88.816     0.150
     5.994    87.016     0.150
     6.035    90.516     0.150
     6.035   158.617     0.150
     6.101    89.156     0.150
     6.118    90.715     0.150
     6.118   159.914     0.150
     6.123    90.617     0.150
     6.159    91.117     0.150
     6.159   160.516     0.150
     6.196    91.316     0.150
     6.196   157.914     0.150
     6.237    94.215     0.150
     6.266    92.914     0.150
     6.266   163.117     0.150
     6.391    95.016     0.150
     6.438    94.016     0.150
     6.552    95.117     0.150
     6.552   164.914     0.150
     6.646    98.117     0.150
     6.646   173.215     0.150
     6.670    98.816     0.150
     6.686    99.117     0.150
     6.961   102.117     0.150
     6.961   178.617     0.150
     7.015   102.617     0.150
     7.043   103.215     0.150
     7.047   102.117     0.150
     7.047   179.215     0.150
     7.068   104.016     0.150
     7.068   179.215     0.150
     7.190   104.215     0.150
     7.190   182.617     0.150
     7.207   105.617     0.150
     7.484   107.414     0.150
     7.484   189.516     0.150
     8.030   115.816     0.150
     8.387   119.715     0.150
     8.387   209.516     0.150
     8.764   124.715     0.150
     8.764   218.215     0.150
     8.834   130.836     0.150
     9.375   133.117     0.150
     9.375   235.617     0.150
     9.670   240.516     0.150
    20.882   285.277     0.150
    47.178   513.051     0.150
    73.570   696.965     0.150
     0.418     7.949     0.150
     0.418    14.590     0.150
     0.528    10.207     0.150
     0.528    18.039     0.150
     0.514    10.117     0.150
     0.514    18.188     0.150
     0.546    10.207     0.150
     0.546    19.020     0.150
     0.765    14.906     0.150
     0.750    13.859     0.150
     0.821    15.578     0.150
     0.842    16.488     0.150
     1.051    19.148     0.150
     1.269    40.129     0.150
     1.269    24.180     0.150
     1.183    22.137     0.150
     1.429    26.219     0.150
     1.604    28.699     0.150
     1.617    28.777     0.150
     1.642    29.289     0.150
     1.762    31.379     0.150
     1.839    31.930     0.150
     1.947    32.488     0.150
     2.108    35.758     0.150
     2.028    35.129     0.150
     2.131    37.367     0.150
     2.324    39.328     0.150
     2.517    41.438     0.150
     2.810    45.879     0.150
     2.810    80.109     0.150
     2.868    46.039     0.150
     2.868    79.938     0.150
     2.881    47.578     0.150
     2.812    45.020     0.150
     2.986    48.758     0.150
     2.986    84.477     0.150
     3.018    48.629     0.150
     3.018    84.906     0.150
     3.128    51.270     0.150
     3.175    51.738     0.150
     3.177    51.180     0.150
     3.108    51.277     0.150
     3.219    52.727     0.150
     3.267    52.129     0.150
     3.267    91.367     0.150
     3.328    53.477     0.150
     3.289    52.387     0.150
     3.289    90.977     0.150
     3.356    53.309     0.150
     3.356    93.066     0.150
     3.490    56.977     0.150
     3.635    74.078     0.150
     3.727    59.590     0.150
     3.727   102.707     0.150
     3.733    58.816     0.150
     3.744    58.539     0.150
     3.755    60.148     0.150
     3.789    60.078     0.150
     3.789   105.477     0.150
     3.932    64.828     0.150
     3.898    61.566     0.150
     3.898   106.258     0.150
     3.917    61.988     0.150
     3.917   107.008     0.150
     3.917    61.988     0.150
     3.917   107.008     0.150
     3.989    62.938     0.150
     4.055    64.457     0.150
     4.055   108.367     0.150
     4.153    62.316     0.150
     4.153   110.906     0.150
     4.245    67.258     0.150
     4.287    66.180     0.150
     4.287   112.680     0.150
     4.245    66.078     0.150
     4.351    66.500     0.150
     4.355    68.277     0.150
     4.355    84.078     0.150
     4.355   116.270     0.150
     4.392    67.277     0.150
     4.392   116.277     0.150
     4.301    68.898     0.150
     4.440    68.180     0.150
     4.440   120.379     0.150
     4.476    68.559     0.150
     4.476   119.156     0.150
     4.714    69.840     0.150
     4.819    72.879     0.150
     4.819   126.078     0.150
     4.819   153.879     0.150
     4.931    73.227     0.150
     4.926    84.078     0.150
     5.017    74.688     0.150
     5.124    76.117     0.150
     5.284    79.680     0.150
     5.412    82.078     0.150
     5.576    82.578     0.150
     5.576   143.578     0.150
     5.576   176.680     0.150
     5.803    86.578     0.150
     5.876    88.977     0.150
     6.026    91.379     0.150
     6.026   158.277     0.150
     6.067    88.406     0.150
     6.169    91.680     0.150
     6.169   161.180     0.150
     6.239    93.797     0.150
     6.337    94.879     0.150
     6.383    93.879     0.150
     6.640    97.578     0.150
     6.693   101.078     0.150
     7.005   101.777     0.150
     7.026   101.977     0.150
     7.179   106.879     0.150
     7.197   104.477     0.150
     7.197   182.078     0.150
     7.194   106.379     0.150
     7.297   108.379     0.150
     7.491   108.680     0.150
     7.491   125.578     0.150
     7.491   140.578     0.150
     7.491   189.180     0.150
     7.993   115.180     0.150
     8.075   116.777     0.150
     8.298   207.379     0.150
     8.298   120.500     0.150
     8.358   119.578     0.150
     8.358   209.879     0.150
     8.421   123.379     0.150
     8.368   122.578     0.150
     8.703   221.180     0.150
     8.734   123.977     0.150
     8.734   218.277     0.150
     9.203   134.379     0.150
     9.631   137.578     0.150
     9.631   242.578     0.150
     9.701   139.078     0.150
     9.701   247.078     0.150
     9.701   277.078     0.150
     9.698   138.379     0.150
     9.970   143.398     0.150
    10.580   151.117     0.150
    14.213   201.180     0.150
     0.492     9.867     0.150
     0.505    10.508     0.150
     0.585    11.176     0.150
     0.585    19.477     0.150
     0.735    13.727     0.150
     0.735    26.078     0.150
     0.827    16.285     0.150
     0.862    15.887     0.150
     0.862    28.398     0.150
     1.051    19.129     0.150
     1.183    20.637     0.150
     1.194    22.418     0.150
     1.304    23.316     0.150
     1.431    26.117     0.150
     1.659    29.828     0.150
     1.650    29.605     0.150
     1.804    32.398     0.150
     1.907    32.559     0.150
     2.016    35.676     0.150
     2.126    36.648     0.150
     2.157    38.668     0.150
     2.321    40.387     0.150
     2.531    42.348     0.150
     2.748    45.277     0.150
     2.748    77.816     0.150
     2.775    45.438     0.150
     2.841    46.016     0.150
     2.841    80.668     0.150
     2.904    47.898     0.150
     2.923    47.578     0.150
     2.923    82.879     0.150
     2.957    48.156     0.150
     2.957    82.035     0.150
     3.149    52.207     0.150
     3.155    52.738     0.150
     3.208    52.848     0.150
     3.257    54.078     0.150
     3.205    52.117     0.150
     3.205    89.527     0.150
     3.230    51.559     0.150
     3.230    88.477     0.150
     3.350    54.719     0.150
     3.295    53.129     0.150
     3.295    90.238     0.150
     3.513    58.297     0.150
     3.512    55.867     0.150
     3.665    59.516     0.150
     3.665   101.059     0.150
     3.733    60.559     0.150
     3.733   123.758     0.150
     3.745    59.605     0.150
     3.761    58.926     0.150
     3.837    61.035     0.150
     3.837   103.777     0.150
     3.855    61.656     0.150
     3.855   104.816     0.150
     3.855    61.656     0.150
     3.855   104.816     0.150
     4.033    62.496     0.150
     4.033   109.957     0.150
     4.075    62.398     0.150
     4.129    65.879     0.150
     4.121    64.898     0.150
     4.121   112.469     0.150
     4.236    65.738     0.150
     4.236   114.938     0.150
     4.270    68.605     0.150
     4.207    65.957     0.150
     4.317    66.906     0.150
     4.317   116.176     0.150
     4.331    67.156     0.150
     4.331    82.758     0.150
     4.331   116.086     0.150
     4.374    66.656     0.150
     4.374   117.156     0.150
     4.444    68.277     0.150
     4.444   119.348     0.150
     4.489    68.957     0.150
     4.489   122.156     0.150
     4.654    72.059     0.150
     4.776    70.535     0.150
     4.776   126.785     0.150
     4.795    72.855     0.150
     4.795   127.758     0.150
     4.795   155.258     0.150
     4.867    75.957     0.150
     4.867   131.559     0.150
     4.933    74.078     0.150
     4.946    76.848     0.150
     4.949    76.758     0.150
     5.030    76.117     0.150
     5.114    76.527     0.150
     5.312    80.797     0.150
     5.476    82.957     0.150
     5.476   143.855     0.150
     5.476   178.258     0.150
     5.545    82.957     0.150
     5.545   144.355     0.150
     5.605    84.957     0.150
     5.674    85.156     0.150
     5.776    87.508     0.150
     5.747    86.957     0.150
     5.917    88.758     0.150
     5.950    89.836     0.150
     5.954    91.457     0.150
     6.022    90.758     0.150
     6.022   159.559     0.150
     6.088    89.637     0.150
     6.104    91.559     0.150
     6.104   161.258     0.150
     6.109    91.957     0.150
     6.109   161.559     0.150
     6.094    91.957     0.150
     6.146    91.758     0.150
     6.146   161.355     0.150
     6.252    93.855     0.150
     6.252   164.457     0.150
     6.212    93.758     0.150
     6.259    95.477     0.150
     6.381    94.355     0.150
     6.429    95.355     0.150
     6.633    99.059     0.150
     6.633   174.457     0.150
     6.589   108.457     0.150
     6.675    99.059     0.150
     6.655   169.758     0.150
     6.762   101.457     0.150
     6.914   103.957     0.150
     7.035   102.656     0.150
     7.056   103.156     0.150
     7.177   105.156     0.150
     7.177   183.457     0.150
     7.237   108.258     0.150
     7.334   109.355     0.150
     7.284   107.277     0.150
     7.322   108.957     0.150
     7.471   108.758     0.150
     7.471   190.355     0.150
     8.018   115.758     0.150
     8.018   203.457     0.150
     8.093   118.758     0.150
     8.093   204.059     0.150
     8.114   118.059     0.150
     8.260   121.316     0.150
     8.273   207.957     0.150
     8.275   120.957     0.150
     8.374   120.059     0.150
     8.374   211.156     0.150
     8.421   215.156     0.150
     8.687   219.758     0.150
     8.685   220.059     0.150
     8.751   125.258     0.150
     8.751   219.156     0.150
     9.216   230.656     0.150
     9.216   229.957     0.150
     9.363   133.156     0.150
     9.659   138.059     0.150
     9.659   242.559     0.150
     9.681   137.957     0.150
     9.681   243.957     0.150
     9.940   141.957     0.150
    10.549   152.367     0.150
    10.938   154.656     0.150
     0.518     9.016     0.150
     0.518    18.418     0.150
     0.752    14.477     0.150
     0.752    25.117     0.150
     0.780    15.125     0.150
     0.810    15.246     0.150
     0.810    27.547     0.150
     0.853    15.715     0.150
     1.058    19.066     0.150
     1.143    19.895     0.150
     1.192    21.426     0.150
     1.192    39.617     0.150
     1.271    22.797     0.150
     1.436    24.676     0.150
     1.651    27.957     0.150
     1.767    29.656     0.150
     1.943    31.008     0.150
     2.031    34.176     0.150
     2.106    35.188     0.150
     2.131    36.598     0.150
     2.330    38.707     0.150
     2.514    39.965     0.150
     2.855    44.324     0.150
     2.855    78.035     0.150
     2.880    45.816     0.150
     3.127    49.887     0.150
     3.173    50.836     0.150
     3.778    59.547     0.150
     3.778   102.746     0.150
     4.043   109.734     0.150
     4.139   109.637     0.150
     4.337    65.324     0.150
     4.337   114.625     0.150
     4.381    67.645     0.150
     4.381   114.746     0.150
     4.448    66.547     0.150
     4.448    83.848     0.150
     4.806    71.246     0.150
     4.806   126.547     0.150
     5.881    85.645     0.150
     5.881   109.246     0.150
     6.343    92.848     0.150
     6.343   119.145     0.150
     6.389    92.746     0.150
     7.006   100.746     0.150
     7.027   100.945     0.150
     7.027   178.246     0.150
     7.480   109.246     0.150
     7.480   186.746     0.150
     7.993   114.145     0.150
     8.355   117.547     0.150
     8.355   208.945     0.150
     8.731   122.848     0.150
     8.731   216.547     0.150
     9.334   131.348     0.150
     9.632   135.645     0.150
     9.632   239.645     0.150
     9.909   140.547     0.150
     0.533    10.148     0.150
     0.533    18.914     0.150
     0.514    10.125     0.150
     0.748    13.391     0.150
     0.806    16.000     0.150
     0.806    27.898     0.150
     0.851    16.586     0.150
     1.147    19.789     0.150
     1.147    38.406     0.150
     1.054    20.008     0.150
     1.054    35.906     0.150
     1.276    22.789     0.150
     1.189    22.180     0.150
     1.189    40.414     0.150
     1.433    25.594     0.150
     1.618    29.156     0.150
     1.648    29.117     0.150
     1.771    31.477     0.150
     1.938    31.984     0.150
     2.110    35.859     0.150
     2.135    37.578     0.150
     2.027    34.859     0.150
     2.326    40.016     0.150
     2.518    41.328     0.150
     2.857    45.477     0.150
     2.857    79.938     0.150
     2.793    45.938     0.150
     2.793    78.898     0.150
     2.884    47.320     0.150
     2.805    44.797     0.150
     2.968    49.266     0.150
     2.968    84.195     0.150
     3.001    48.336     0.150
     3.001    83.406     0.150
     3.131    51.258     0.150
     3.178    52.109     0.150
     3.182    52.594     0.150
     3.112    49.547     0.150
     3.250    53.008     0.150
     3.250    90.750     0.150
     3.274    52.141     0.150
     3.274    89.586     0.150
     3.340    53.047     0.150
     3.340    91.984     0.150
     3.710    59.703     0.150
     3.710   102.367     0.150
     3.775    65.195     0.150
     3.775   108.797     0.150
     3.740    58.648     0.150
     3.882    61.539     0.150
     3.882   105.250     0.150
     3.900    61.719     0.150
     3.900   105.969     0.150
     3.900    61.719     0.150
     3.900   105.969     0.150
     4.046   108.898     0.150
     4.141    66.367     0.150
     4.141   110.719     0.150
     4.167    64.695     0.150
     4.167   111.695     0.150
     4.274    67.500     0.150
     4.274   113.000     0.150
     4.338    65.688     0.150
     4.383    67.297     0.150
     4.383   116.094     0.150
     4.464    68.109     0.150
     4.464   118.430     0.150
     4.452    68.000     0.150
     4.809    72.000     0.150
     4.809   125.797     0.150
     4.809   154.797     0.150
     4.928    73.109     0.150
     5.118    76.703     0.150
     5.564    82.398     0.150
     5.564   145.398     0.150
     5.885    88.398     0.150
     6.159    90.594     0.150
     6.159   160.797     0.150
     6.347    93.898     0.150
     6.394    93.695     0.150
     6.625    98.297     0.150
     6.625   173.500     0.150
     6.647    98.695     0.150
     6.680   217.000     0.150
     7.482   120.797     0.150
     7.482   187.500     0.150
     8.359   118.898     0.150
     8.359   209.898     0.150
     8.736   124.094     0.150
     8.736   218.500     0.150
     9.338   133.094     0.150
     9.636   137.398     0.150
     9.636   241.500     0.150
     9.712   138.094     0.150
     9.712   243.094     0.150
    10.209   146.594     0.150
    11.497   165.594     0.150
     0.502     9.938     0.150
     0.502    17.727     0.150
     0.505    10.273     0.150
     0.573    10.836     0.150
     0.573    19.562     0.150
     0.736    13.531     0.150
     0.776    16.023     0.150
     0.813    15.562     0.150
     0.813    28.344     0.150
     0.856    15.656     0.150
     1.049    19.164     0.150
     1.049    34.469     0.150
     1.174    20.258     0.150
     1.174    38.617     0.150
     1.189    21.484     0.150
     1.298    44.016     0.150
     1.429    26.398     0.150
     1.648    28.969     0.150
     1.662    30.125     0.150
     1.646    29.492     0.150
     1.796    32.445     0.150
     1.914    32.258     0.150
     2.016    35.406     0.150
     2.124    36.742     0.150
     2.153    38.328     0.150
     2.319    39.969     0.150
     2.530    41.984     0.150
     2.761    45.594     0.150
     2.761    77.969     0.150
     2.849    45.742     0.150
     2.849    80.203     0.150
     2.782    44.984     0.150
     2.901    47.898     0.150
     2.937    48.969     0.150
     2.937    83.344     0.150
     2.970    48.625     0.150
     2.970    82.922     0.150
     3.146    52.008     0.150
     3.194    52.305     0.150
     3.108    49.914     0.150
     3.203    53.547     0.150
     3.218    52.508     0.150
     3.218    89.398     0.150
     3.243    52.125     0.150
     3.243    88.562     0.150
     3.308    53.602     0.150
     3.308    90.766     0.150
     3.437    55.328     0.150
     3.437    92.828     0.150
     3.510    57.836     0.150
     3.679    59.906     0.150
     3.679   101.375     0.150
     3.744    66.125     0.150
     3.744   102.125     0.150
     3.741    59.094     0.150
     3.755    58.914     0.150
     3.850    61.297     0.150
     3.850   104.125     0.150
     3.868    61.828     0.150
     3.868   104.266     0.150
     3.868    61.828     0.150
     3.868   104.266     0.150
     4.040   109.406     0.150
     4.130    64.188     0.150
     4.130   112.367     0.150
     4.136    64.625     0.150
     4.136   113.227     0.150
     4.244   115.625     0.150
     4.261    67.523     0.150
     4.261   113.328     0.150
     4.213    65.625     0.150
     4.326    66.602     0.150
     4.326   115.797     0.150
     4.338   116.422     0.150
     4.380    66.828     0.150
     4.380   116.828     0.150
     4.453    67.992     0.150
     4.453   118.883     0.150
     4.480    69.125     0.150
     4.802    72.523     0.150
     4.802   125.828     0.150
     4.802   152.922     0.150
     4.824    73.406     0.150
     4.935    73.836     0.150
     5.029    75.469     0.150
     4.956    76.125     0.150
     5.118    75.477     0.150
     5.481    82.625     0.150
     5.481   144.328     0.150
     5.481   177.625     0.150
     5.553   144.227     0.150
     5.609    84.625     0.150
     5.776    87.781     0.150
     5.910    89.023     0.150
     5.961    90.625     0.150
     6.086    88.992     0.150
     6.111    91.523     0.150
     6.111   159.328     0.150
     6.153    91.227     0.150
     6.153   160.328     0.150
     6.371    92.938     0.150
     6.373    94.625     0.150
     6.420    95.125     0.150
     6.633    98.328     0.150
     6.633   173.523     0.150
     6.669    99.328     0.150
     7.030   102.227     0.150
     7.030   180.328     0.150
     7.051   102.828     0.150
     7.051   180.727     0.150
     7.327   109.227     0.150
     7.477   108.625     0.150
     7.477   189.828     0.150
     8.014   116.227     0.150
     8.014   203.125     0.150
     8.280   207.922     0.150
     8.372   120.023     0.150
     8.372   208.922     0.150
     8.344   123.625     0.150
     8.749   124.922     0.150
     8.749   219.023     0.150
     9.654   138.523     0.150
     9.654   242.727     0.150
     9.726   139.727     0.150
     9.726   243.727     0.150
    10.375   150.227     0.150
    10.869   156.523     0.150
     0.458     8.781     0.150
     0.458    14.871     0.150
     0.488    10.488     0.150
     0.488    17.691     0.150
     0.505    10.082     0.150
     0.505    18.340     0.150
     0.570    10.840     0.150
     0.570    18.879     0.150
     0.721    14.238     0.150
     0.721    25.809     0.150
     0.800    15.609     0.150
     0.800    27.039     0.150
     0.779    15.309     0.150
     0.779    27.910     0.150
     0.835    15.422     0.150
     0.835    28.750     0.150
     1.031    19.609     0.150
     1.031    34.680     0.150
     1.169    21.559     0.150
     1.169    37.840     0.150
     1.410    26.129     0.150
     1.645    29.500     0.150
     1.627    29.531     0.150
     1.801    32.020     0.150
     1.908    32.262     0.150
     2.001    35.621     0.150
     2.138    37.949     0.150
     2.545    42.500     0.150
     2.774    45.820     0.150
     2.771    45.121     0.150
     2.771    79.809     0.150
     2.870    45.988     0.150
     2.870    80.930     0.150
     2.913    47.871     0.150
     2.949    47.871     0.150
     2.949    84.371     0.150
     2.978    48.109     0.150
     2.978    84.371     0.150
     3.090    50.449     0.150
     3.229    51.801     0.150
     3.229    91.199     0.150
     3.248    51.711     0.150
     3.248    90.648     0.150
     3.316    53.102     0.150
     3.316    92.859     0.150
     3.692    58.148     0.150
     3.692   102.270     0.150
     3.720    59.082     0.150
     3.734    58.539     0.150
     3.747    60.512     0.150
     3.747   103.711     0.150
     3.859    60.059     0.150
     3.859   105.922     0.150
     3.878   106.340     0.150
     3.878    60.469     0.150
     3.878   106.340     0.150
     4.151   113.039     0.150
     4.282    72.109     0.150
     4.282   117.012     0.150
     4.348    66.730     0.150
     4.359    69.910     0.150
     4.359   118.910     0.150
     4.401    67.512     0.150
     4.401   118.109     0.150
     4.481    68.711     0.150
     4.481   121.512     0.150
     4.474    67.820     0.150
     4.823    73.109     0.150
     4.823   129.211     0.150
     4.884    73.910     0.150
     4.952    74.648     0.150
     5.915    89.012     0.150
     6.174    92.109     0.150
     6.174   160.012     0.150
     6.377    95.012     0.150
     6.424    95.012     0.150
     6.424   166.809     0.150
     6.677    97.211     0.150
     7.040   102.809     0.150
     8.026   116.309     0.150
     8.387   120.012     0.150
     8.763   126.309     0.150
     9.368   133.711     0.150
     0.469     8.559     0.150
     0.469    15.918     0.150
     0.492     8.988     0.150
     0.492    16.738     0.150
     0.473     9.398     0.150
     0.583    10.629     0.150
     0.583    19.449     0.150
     0.706    12.898     0.150
     0.767    14.828     0.150
     0.806    15.578     0.150
     0.824    14.621     0.150
     1.017    18.031     0.150
     1.017    33.051     0.150
     1.157    21.461     0.150
     1.322    24.508     0.150
     1.396    23.898     0.150
     1.614    28.551     0.150
     1.659    29.078     0.150
     1.817    32.000     0.150
     1.986    34.621     0.150
     2.153    36.570     0.150
     2.180    37.441     0.150
     2.560    41.871     0.150
     2.880    45.070     0.150
     2.880    79.719     0.150
     2.929    47.488     0.150
     3.175    51.461     0.150
     3.222    52.551     0.150
     4.071    61.930     0.150
     4.071   110.359     0.150
     4.160   110.109     0.150
     4.274    64.711     0.150
     4.274   115.449     0.150
     4.289    72.828     0.150
     4.356    65.711     0.150
     4.356   115.078     0.150
     4.370   114.930     0.150
     4.483   117.398     0.150
     4.496    68.531     0.150
     4.496   119.828     0.150
     4.833    72.230     0.150
     4.833   127.328     0.150
     6.185    91.129     0.150
     6.185   160.629     0.150
     6.392    94.230     0.150
     6.439    94.328     0.150
     6.693    97.328     0.150
     7.056   102.230     0.150
     7.077   102.230     0.150
     7.249   105.531     0.150
     7.509   106.430     0.150
     8.402   119.031     0.150
     8.402   208.930     0.150
     8.476   123.730     0.150
     8.779   219.129     0.150
    10.255   145.930     0.150
    10.884   155.328     0.150
     0.421     7.562     0.150
     0.421    15.062     0.150
     0.532     9.590     0.150
     0.543    10.152     0.150
     0.508     9.852     0.150
     0.765    13.832     0.150
     0.744    13.441     0.150
     0.817    15.602     0.150
     0.837    15.090     0.150
     1.045    18.699     0.150
     1.045    36.230     0.150
     1.177    21.582     0.150
     1.423    25.621     0.150
     1.608    27.641     0.150
     1.621    28.199     0.150
     1.651    28.500     0.150
     1.637    28.551     0.150
     1.767    30.051     0.150
     1.833    31.480     0.150
     1.942    32.090     0.150
     2.114    35.461     0.150
     2.137    36.340     0.150
     2.022    34.801     0.150
     2.022    34.699     0.150
     2.318    38.770     0.150
     2.523    41.051     0.150
     2.872    45.000     0.150
     2.872    79.562     0.150
     2.808    44.129     0.150
     2.808    79.422     0.150
     2.887    46.539     0.150
     2.807    44.742     0.150
     2.984    46.582     0.150
     2.984    83.980     0.150
     3.015    46.922     0.150
     3.015    84.129     0.150
     3.134    50.301     0.150
     3.181    50.602     0.150
     3.183    50.012     0.150
     3.102    49.062     0.150
     3.102    48.602     0.150
     3.123    49.820     0.150
     3.301    53.520     0.150
     3.265    90.590     0.150
     3.334    53.391     0.150
     3.286    90.551     0.150
     3.245    50.941     0.150
     3.354    92.602     0.150
     3.496    55.922     0.150
     3.481    55.402     0.150
     3.481    96.102     0.150
     3.491    54.652     0.150
     3.491    54.199     0.150
     3.521    54.922     0.150
     3.632    58.000     0.150
     3.726    57.180     0.150
     3.726   102.379     0.150
     3.787    58.402     0.150
     3.824    58.641     0.150
     3.824   101.242     0.150
     3.772    58.301     0.150
     3.772   103.301     0.150
     3.785    57.102     0.150
     3.728    57.301     0.150
     3.738    57.301     0.150
     3.751    58.902     0.150
     3.897    62.090     0.150
     3.798    59.301     0.150
     3.936    60.801     0.150
     3.936   106.832     0.150
     3.931    61.039     0.150
     3.931    60.902     0.150
     3.896    59.582     0.150
     3.896   105.980     0.150
     3.915    60.449     0.150
     3.915   106.551     0.150
     3.915    60.449     0.150
     3.915   106.551     0.150
     3.989    61.902     0.150
     4.007    64.691     0.150
     4.060    62.012     0.150
     4.060   107.992     0.150
     4.096    61.492     0.150
     4.110    64.660     0.150
     4.157    62.961     0.150
     4.157   109.691     0.150
     4.046    62.301     0.150
     4.181    63.191     0.150
     4.215    63.902     0.150
     4.239    65.641     0.150
     4.178    65.301     0.150
     4.251    66.602     0.150
     4.291    64.500     0.150
     4.163    67.441     0.150
     4.304    65.109     0.150
     4.304   118.609     0.150
     4.355    65.680     0.150
     4.240    65.301     0.150
     4.360    66.320     0.150
     4.360    81.801     0.150
     4.360   113.402     0.150
     4.364    67.992     0.150
     4.397    65.902     0.150
     4.299    66.801     0.150
     4.299   136.801     0.150
     4.298    68.230     0.150
     4.480    67.180     0.150
     4.445    67.602     0.150
     4.445   118.301     0.150
     4.492    69.223     0.150
     4.568    68.051     0.150
     4.570    68.000     0.150
     4.559    69.941     0.150
     4.583    67.461     0.150
     4.436    68.832     0.150
     4.502    69.402     0.150
     4.502   121.699     0.150
     4.502   133.000     0.150
     4.513    72.961     0.150
     4.658    69.109     0.150
     4.693    69.191     0.150
     4.693    69.602     0.150
     4.698    69.680     0.150
     4.583    70.902     0.150
     4.583    70.500     0.150
     4.746    70.152     0.150
     4.747    70.199     0.150
     4.747    70.602     0.150
     4.627    71.480     0.150
     4.627    71.602     0.150
     4.800    70.480     0.150
     4.800    70.801     0.150
     4.688    71.441     0.150
     4.688   121.602     0.150
     4.715    68.730     0.150
     4.824    72.402     0.150
     4.824   128.000     0.150
     4.838    71.660     0.150
     4.880    72.531     0.150
     4.835    72.910     0.150
     4.937    72.879     0.150
     4.961    73.652     0.150
     4.961   128.992     0.150
     4.922    75.102     0.150
     4.922    93.102     0.150
     4.922   132.301     0.150
     5.013    73.801     0.150
     5.013    74.500     0.150
     5.023    74.461     0.150
     5.052    74.480     0.150
     5.077    74.629     0.150
     4.994    75.922     0.150
     4.994   129.039     0.150
     5.100    77.820     0.150
     5.129    75.859     0.150
     5.148    77.441     0.150
     5.148   137.641     0.150
     5.282    79.750     0.150
     5.282   138.352     0.150
     5.431    82.223     0.150
     5.339    80.242     0.150
     5.339   138.359     0.150
     5.355    81.230     0.150
     5.496    81.602     0.150
     5.496   143.000     0.150
     5.407    82.301     0.150
     5.494    82.590     0.150
     5.494    82.730     0.150
     5.580    81.902     0.150
     5.580   147.102     0.150
     5.587    84.391     0.150
     5.628    83.801     0.150
     5.741    87.020     0.150
     5.742    87.129     0.150
     5.774    85.391     0.150
     5.805    85.500     0.150
     5.724    85.441     0.150
     5.724   146.961     0.150
     5.842    88.102     0.150
     5.870    86.402     0.150
     5.799    86.000     0.150
     5.799   149.602     0.150
     5.799   168.699     0.150
     5.799   187.301     0.150
     5.881    88.000     0.150
     5.889    89.902     0.150
     5.935    87.801     0.150
     5.931    89.699     0.150
     5.969    86.699     0.150
     5.963    89.500     0.150
     6.031    89.699     0.150
     6.031   158.801     0.150
     6.020    91.012     0.150
     6.073    87.840     0.150
     6.059    91.301     0.150
     5.994    89.121     0.150
     5.994   152.840     0.150
     5.988    90.801     0.150
     6.114    90.602     0.150
     6.114   159.801     0.150
     6.116    90.500     0.150
     6.116   159.102     0.150
     6.090    92.242     0.150
     6.090    91.012     0.150
     6.064    89.312     0.150
     6.064   156.441     0.150
     6.174    90.801     0.150
     6.174   161.402     0.150
     6.176    91.102     0.150
     6.221    92.000     0.150
     6.149    92.301     0.150
     6.224    93.102     0.150
     6.259    92.602     0.150
     6.259   165.402     0.150
     6.244    92.762     0.150
     6.244    93.000     0.150
     6.206    91.402     0.150
     6.206   156.922     0.150
     6.277    92.102     0.150
     6.331    94.699     0.150
     6.270    93.301     0.150
     6.355    91.812     0.150
     6.358    92.039     0.150
     6.342    93.402     0.150
     6.388    93.699     0.150
     6.339    93.570     0.150
     6.339   163.152     0.150
     6.379    93.570     0.150
     6.295    94.199     0.150
     6.295   162.160     0.150
     6.388    94.102     0.150
     6.388   164.402     0.150
     6.424    92.141     0.150
     6.509    97.102     0.150
     6.528    95.000     0.150
     6.522    94.191     0.150
     6.458    95.039     0.150
     6.458   166.602     0.150
     6.458    95.301     0.150
     6.550    94.199     0.150
     6.633    97.902     0.150
     6.633   172.500     0.150
     6.642    97.602     0.150
     6.650    98.000     0.150
     6.645    97.801     0.150
     6.589    96.961     0.150
     6.697    96.602     0.150
     6.697    98.301     0.150
     6.697   108.402     0.150
     6.697   113.801     0.150
     6.697   169.301     0.150
     6.622    97.301     0.150
     6.643    98.301     0.150
     6.715   100.332     0.150
     6.759    97.051     0.150
     6.790    99.500     0.150
     6.790   178.801     0.150
     6.771   101.902     0.150
     6.845   101.340     0.150
     6.757    99.191     0.150
     6.757   173.199     0.150
     6.881   100.902     0.150
     6.881   175.359     0.150
     6.899   100.500     0.150
     6.899   173.000     0.150
     6.910   100.902     0.150
     6.939   101.000     0.150
     6.957   101.199     0.150
     6.946   100.602     0.150
     6.991   101.402     0.150
     6.973   105.102     0.150
     6.970   103.801     0.150
     6.917   100.723     0.150
     6.917   100.902     0.150
     7.015   101.500     0.150
     7.015   101.902     0.150
     7.010   101.699     0.150
     7.010   178.000     0.150
     7.010   101.301     0.150
     6.972   103.301     0.150
     7.031   101.801     0.150
     7.031   178.699     0.150
     7.031   131.199     0.150
     7.082   102.500     0.150
     7.082   102.602     0.150
     7.069   107.000     0.150
     7.029   102.641     0.150
     7.029   178.441     0.150
     7.129   104.102     0.150
     7.129   104.402     0.150
     7.177   104.500     0.150
     7.181   104.102     0.150
     7.181   105.301     0.150
     7.202   104.500     0.150
     7.202   183.301     0.150
     7.196   105.102     0.150
     7.172   106.500     0.150
     7.082   104.301     0.150
     7.213   105.500     0.150
     7.199   106.902     0.150
     7.225   106.301     0.150
     7.225   106.402     0.150
     7.236   106.102     0.150
     7.229   105.801     0.150
     7.250   108.199     0.150
     7.303   108.000     0.150
     7.355   106.902     0.150
     7.325   106.199     0.150
     7.325   186.562     0.150
     7.354   108.301     0.150
     7.376   108.301     0.150
     7.441   110.801     0.150
     7.496   108.199     0.150
     7.496   124.801     0.150
     7.496   189.199     0.150
     7.572   109.652     0.150
     7.584   108.699     0.150
     7.578   109.199     0.150
     7.620   109.402     0.150
     7.617   110.000     0.150
     7.638   109.859     0.150
     7.715   113.680     0.150
     7.715   193.039     0.150
     7.726   112.000     0.150
     7.680   113.301     0.150
     7.801   112.180     0.150
     7.801   195.320     0.150
     7.800   111.480     0.150
     7.800   112.301     0.150
     7.758   113.301     0.150
     7.875   112.199     0.150
     7.973   114.020     0.150
     7.973   198.160     0.150
     7.903   114.301     0.150
     7.999   114.801     0.150
     7.999   200.602     0.150
     7.999   114.102     0.150
     7.916   119.301     0.150
     7.947   114.359     0.150
     7.973   116.801     0.150
     8.059   115.602     0.150
     8.059   115.062     0.150
     8.091   115.902     0.150
     8.080   118.602     0.150
     8.080   118.402     0.150
     8.131   116.781     0.150
     8.183   117.699     0.150
     8.183   204.930     0.150
     8.255   118.301     0.150
     8.255   117.750     0.150
     8.255   118.402     0.150
     8.259   119.301     0.150
     8.218   123.102     0.150
     8.288   117.699     0.150
     8.303   118.801     0.150
     8.303   207.500     0.150
     8.302   121.371     0.150
     8.364   119.000     0.150
     8.364   208.801     0.150
     8.364   120.199     0.150
     8.387   120.301     0.150
     8.398   121.301     0.150
     8.398   210.301     0.150
     8.398   121.301     0.150
     8.334   122.301     0.150
     8.426   122.402     0.150
     8.465   123.500     0.150
     8.465   216.402     0.150
     8.362   122.301     0.150
     8.507   121.699     0.150
     8.507   120.902     0.150
     8.507   121.402     0.150
     8.458   122.680     0.150
     8.567   122.402     0.150
     8.567   121.742     0.150
     8.567   122.699     0.150
     8.477   125.301     0.150
     8.563   126.699     0.150
     8.563   126.902     0.150
     8.601   126.801     0.150
     8.708   124.602     0.150
     8.708   219.301     0.150
     8.709   127.801     0.150
     8.709   225.402     0.150
     8.699   127.301     0.150
     8.721   127.699     0.150
     8.726   126.500     0.150
     8.740   123.801     0.150
     8.740   217.500     0.150
     8.740   122.699     0.150
     8.749   127.102     0.150
     8.660   127.301     0.150
     8.820   126.602     0.150
     8.820   125.980     0.150
     8.820   128.199     0.150
     8.909   129.000     0.150
     8.894   131.402     0.150
     8.894   131.160     0.150
     8.940   131.891     0.150
     8.940   127.570     0.150
     8.940   223.180     0.150
     8.940   224.816     0.150
     8.930   129.301     0.150
     9.068   128.902     0.150
     9.032   131.301     0.150
     9.195   134.102     0.150
     9.208   131.402     0.150
     9.208   147.402     0.150
     9.209   132.902     0.150
     9.209   135.301     0.150
     9.209   284.602     0.150
     9.167   134.602     0.150
     9.167   135.199     0.150
     9.235   131.801     0.150
     9.235   229.402     0.150
     9.235   229.301     0.150
     9.231   138.301     0.150
     9.288   132.711     0.150
     9.288   133.805     0.150
     9.288   134.902     0.150
     9.339   132.699     0.150
     9.339   233.000     0.150
     9.339   132.301     0.150
     9.347   133.832     0.150
     9.347   235.598     0.150
     9.484   136.102     0.150
     9.484   136.301     0.150
     9.459   136.301     0.150
     9.592   136.199     0.150
     9.592   238.602     0.150
     9.628   137.402     0.150
     9.628   241.102     0.150
     9.637   136.902     0.150
     9.637   240.000     0.150
     9.637   135.902     0.150
     9.637   138.199     0.150
     9.651   142.500     0.150
     9.706   139.301     0.150
     9.706   244.801     0.150
     9.706   156.902     0.150
     9.706   274.801     0.150
     9.704   137.699     0.150
     9.704   137.801     0.150
     9.716   138.102     0.150
     9.716   239.102     0.150
     9.631   139.301     0.150
     9.913   141.500     0.150
     9.913   247.000     0.150
     9.913   140.801     0.150
     9.995   145.602     0.150
     9.995   251.062     0.150
     9.964   142.512     0.150
     9.964   247.359     0.150
     9.964   144.352     0.150
    10.031   143.949     0.150
    10.039   146.711     0.150
    10.005   145.699     0.150
    10.011   144.102     0.150
    10.208   148.301     0.150
    10.208   147.102     0.150
    10.264   148.402     0.150
    10.264   149.699     0.150
    10.347   148.000     0.150
    10.345   147.879     0.150
    10.345   260.277     0.150
    10.495   151.289     0.150
    10.587   151.301     0.150
    10.735   154.371     0.150
    10.735   268.590     0.150
    10.791   155.500     0.150
    10.791   156.000     0.150
    10.833   155.402     0.150
    10.851   154.449     0.150
    10.851   154.562     0.150
    10.856   154.602     0.150
    10.932   156.301     0.150
    10.932   269.500     0.150
    10.919   156.402     0.150
    10.975   157.062     0.150
    10.975   271.379     0.150
    10.914   156.301     0.150
    10.955   155.520     0.150
    10.955   276.613     0.150
    10.971   159.992     0.150
    10.971   156.371     0.150
    10.971   272.812     0.150
    10.971   157.484     0.150
    11.058   159.402     0.150
    11.180   159.402     0.150
    11.180   275.301     0.150
    11.183   160.301     0.150
    11.310   161.801     0.150
    11.310   289.301     0.150
    11.359   165.801     0.150
    11.465   165.191     0.150
    11.465   291.980     0.150
    11.490   166.801     0.150
    11.490   166.000     0.150
    11.598   168.000     0.150
    11.662   165.199     0.150
    11.843   169.602     0.150
    11.888   174.301     0.150
    11.918   168.652     0.150
    11.918   170.539     0.150
    12.205   173.141     0.150
    12.205   175.500     0.150
    12.163   179.301     0.150
    12.209   175.199     0.150
    12.335   179.301     0.150
    12.345   176.602     0.150
    12.345   176.301     0.150
    12.910   183.500     0.150
    12.916   181.051     0.150
    12.916   182.930     0.150
    12.970   185.852     0.150
    12.970   184.965     0.150
    13.014   187.301     0.150
    13.096   183.223     0.150
    13.096   187.320     0.150
    13.096   186.844     0.150
    13.435   193.199     0.150
    13.522   192.199     0.150
    13.627   195.840     0.150
    13.627   191.668     0.150
    13.824   198.301     0.150
    13.865   197.301     0.150
    13.954   196.602     0.150
    13.974   199.262     0.150
    13.974   196.707     0.150
    14.023   197.926     0.150
    14.023   198.301     0.150
    14.056   201.301     0.150
    14.219   200.102     0.150
    14.331   206.312     0.150
    14.331   205.457     0.150
    14.366   204.902     0.150
    14.388   201.301     0.150
    14.428   202.871     0.150
    14.428   204.516     0.150
    14.551   203.160     0.150
    14.551   206.672     0.150
    14.551   204.887     0.150
    14.734   210.602     0.150
    14.734   205.859     0.150
    14.734   208.402     0.150
    14.750   207.242     0.150
    14.896   214.250     0.150
    14.896   210.672     0.150
    15.027   214.699     0.150
    15.070   216.441     0.150
    15.070   211.652     0.150
    15.070   213.625     0.150
    15.232   215.699     0.150
    15.354   221.859     0.150
    15.303   219.262     0.150
    15.303   213.902     0.150
    15.303   215.395     0.150
    15.330   215.133     0.150
    15.305   212.902     0.150
    15.375   215.879     0.150
    15.375   219.359     0.150
    15.344   213.602     0.150
    15.436   215.301     0.150
    15.574   217.840     0.150
    15.574   225.430     0.150
    15.649   223.570     0.150
    15.709   219.340     0.150
    15.709   226.609     0.150
    15.729   219.473     0.150
    15.735   223.430     0.150
    15.917   222.172     0.150
    15.944   227.660     0.150
    15.971   228.242     0.150
    15.974   225.590     0.150
    15.924   228.812     0.150
    15.924   224.152     0.150
    15.936   228.461     0.150
    15.936   223.301     0.150
    15.936   223.797     0.150
    15.946   223.602     0.150
    15.960   222.000     0.150
    16.129   226.160     0.150
    16.106   226.852     0.150
    16.106   228.785     0.150
    16.124   226.199     0.150
    16.160   234.461     0.150
    16.236   228.699     0.150
    16.239   229.391     0.150
    16.311   234.801     0.150
    16.311   233.039     0.150
    16.311   229.621     0.150
    16.311   229.000     0.150
    16.361   235.062     0.150
    16.361   230.129     0.150
    16.422   232.949     0.150
    16.477   235.191     0.150
    16.438   228.801     0.150
    16.622   232.371     0.150
    16.622   234.699     0.150
    16.727   233.801     0.150
    16.739   233.293     0.150
    16.850   237.551     0.150
    16.854   240.832     0.150
    16.922   237.102     0.150
    16.949   238.902     0.150
    16.949   427.699     0.150
    17.021   239.199     0.150
    17.111   240.520     0.150
    17.091   241.402     0.150
    17.096   239.449     0.150
    17.150   239.500     0.150
    17.339   242.941     0.150
    17.359   246.121     0.150
    17.359   242.789     0.150
    17.375   241.301     0.150
    17.705   246.223     0.150
    17.666   246.617     0.150
    17.699   246.180     0.150
    17.718   247.699     0.150
    17.773   248.801     0.150
    17.827   246.879     0.150
    17.771   249.699     0.150
    17.819   249.402     0.150
    17.925   253.062     0.150
    17.944   248.691     0.150
    18.067   251.473     0.150
    18.067   252.172     0.150
    18.230   253.902     0.150
    18.278   255.090     0.150
    18.278   463.262     0.150
    18.278   251.551     0.150
    18.312   252.730     0.150
    18.254   252.801     0.150
    18.364   256.000     0.150
    18.321   253.301     0.150
    18.448   257.930     0.150
    18.468   255.852     0.150
    18.483   254.129     0.150
    18.483   254.801     0.150
    18.430   258.102     0.150
    18.384   255.199     0.150
    18.513   257.449     0.150
    18.438   257.301     0.150
    18.523   257.961     0.150
    18.545   257.352     0.150
    18.445   253.211     0.150
    18.445   464.711     0.150
    18.567   464.691     0.150
    18.567   465.582     0.150
    18.533   255.000     0.150
    18.620   258.102     0.150
    18.635   255.902     0.150
    18.770   261.570     0.150
    18.714   260.301     0.150
    18.821   260.199     0.150
    18.755   258.500     0.150
    18.893   263.281     0.150
    18.791   258.801     0.150
    18.913   260.332     0.150
    18.805   260.199     0.150
    18.805   260.410     0.150
    18.805   260.570     0.150
    18.805   261.531     0.150
    18.805   469.781     0.150
    18.805   469.949     0.150
    18.805   470.121     0.150
    19.057   262.699     0.150
    19.076   263.371     0.150
    18.970   259.801     0.150
    19.126   264.410     0.150
    19.026   262.000     0.150
    19.029   260.531     0.150
    19.142   264.270     0.150
    19.200   261.801     0.150
    19.128   261.801     0.150
    19.161   261.699     0.150
    19.229   263.801     0.150
    19.360   265.641     0.150
    19.269   263.902     0.150
    19.391   264.801     0.150
    19.505   266.199     0.150
    19.505   265.801     0.150
    19.505   483.551     0.150
    19.421   265.000     0.150
    19.521   268.301     0.150
    19.589   267.102     0.150
    19.589   266.301     0.150
    19.662   268.121     0.150
    19.780   269.102     0.150
    19.763   269.000     0.150
    19.770   272.301     0.150
    19.785   269.500     0.150
    19.911   274.699     0.150
    19.911   507.301     0.150
    19.985   272.242     0.150
    20.121   276.301     0.150
    20.205   279.020     0.150
    20.092   274.602     0.150
    20.229   274.500     0.150
    20.197   275.301     0.150
    20.197   274.500     0.150
    20.197   274.777     0.150
    20.222   276.301     0.150
    20.394   275.820     0.150
    20.430   276.531     0.150
    20.438   275.602     0.150
    20.342   277.699     0.150
    20.478   278.000     0.150
    20.478   500.699     0.150
    20.428   277.902     0.150
    20.499   279.410     0.150
    20.499   279.602     0.150
    20.499   296.602     0.150
    20.499   506.902     0.150
    20.499   527.301     0.150
    20.581   277.812     0.150
    20.679   281.102     0.150
    20.654   281.500     0.150
    20.716   281.301     0.150
    20.810   280.652     0.150
    20.762   282.301     0.150
    20.762   513.301     0.150
    20.762   541.301     0.150
    20.758   281.301     0.150
    20.872   284.242     0.150
    20.916   281.199     0.150
    20.916   509.320     0.150
    21.177   285.340     0.150
    21.265   285.812     0.150
    21.362   287.379     0.150
    21.486   291.301     0.150
    21.486   525.301     0.150
    21.574   288.699     0.150
    23.876   312.301     0.150
    23.876   568.301     0.150
    24.089   314.301     0.150
    24.531   321.039     0.150
    24.531   321.180     0.150
    26.166   333.500     0.150
    26.189   338.051     0.150
    26.189   333.602     0.150
    26.509   338.539     0.150
    27.003   344.121     0.150
    27.003   340.980     0.150
    27.003   342.930     0.150
    27.741   347.832     0.150
    27.826   349.199     0.150
    28.089   350.680     0.150
    28.245   353.770     0.150
    28.355   354.402     0.150
    28.460   353.090     0.150
    28.509   355.582     0.150
    28.532   355.789     0.150
    28.833   358.301     0.150
    28.736   357.902     0.150
    28.736   360.430     0.150
    28.904   362.680     0.150
    28.904   359.402     0.150
    29.148   361.000     0.150
    29.376   364.039     0.150
    30.256   370.570     0.150
    31.217   678.102     0.150
    31.217   821.301     0.150
    31.302   379.531     0.150
    31.596   381.180     0.150
    31.596   382.301     0.150
    32.789   393.102     0.150
    32.789   709.301     0.150
    33.183   395.441     0.150
    34.353   407.902     0.150
    37.533   433.473     0.150
    37.533   434.801     0.150
    37.946   437.699     0.150
    38.293   440.992     0.150
    38.293   440.602     0.150
    38.433   441.480     0.150
    39.120   448.500     0.150
    39.267   448.902     0.150
    39.505   450.801     0.150
    40.477   459.902     0.150
    43.418   483.301     0.150
    43.418   589.301     0.150
    43.418  1075.301     0.150
    43.780   485.402     0.150
    44.873   897.301     0.150
    45.559   499.301     0.150
    45.559   605.301     0.150
    45.559   901.102     0.150
    45.588   502.801     0.150
    45.588   599.301     0.150
    45.588   609.500     0.150
    45.588   832.902     0.150
    45.588   905.301     0.150
    45.588  1095.301     0.150
    45.588  1100.602     0.150
    47.238   513.199     0.150
    47.238   513.352     0.150
    47.200   516.699     0.150
    47.200   513.391     0.150
    48.538   523.301     0.150
    49.924   533.500     0.150
    50.823   541.172     0.150
    51.324   542.801     0.150
    51.558   547.770     0.150
    51.898   673.602     0.150
    51.898   995.301     0.150
    51.898  1001.801     0.150
    51.898  1209.801     0.150
    52.914   554.301     0.150
    54.731   570.930     0.150
    54.870   569.301     0.150
    54.870   569.699     0.150
    55.148   572.461     0.150
    55.877   577.039     0.150
    56.587   583.199     0.150
    56.689   587.090     0.150
    56.689  1050.160     0.150
    57.424   588.500     0.150
    57.653   593.980     0.150
    57.653  1077.352     0.150
    57.862   591.500     0.150
    57.987   592.902     0.150
    58.015   592.500     0.150
    58.102   594.180     0.150
    58.232   594.102     0.150
    58.390   595.699     0.150
    58.518   597.500     0.150
    59.066   598.902     0.150
    59.066   653.301     0.150
    59.066  1085.301     0.150
    60.262   607.102     0.150
    60.605   609.660     0.150
    60.605   611.102     0.150
    60.541   613.473     0.150
    60.541  1102.199     0.150
    61.104   613.430     0.150
    61.071   617.660     0.150
    61.243   616.301     0.150
    61.243   755.500     0.150
    61.243  1113.602     0.150
    61.928   620.672     0.150
    61.928   620.539     0.150
    61.964   621.199     0.150
    61.964   760.402     0.150
    61.964  1125.500     0.150
    61.964  1133.500     0.150
    62.127   620.789     0.150
    62.453   622.301     0.150
    62.453   626.801     0.150
    63.072   627.301     0.150
    63.285   624.910     0.150
    64.144   633.211     0.150
    64.144   633.000     0.150
    64.144   671.402     0.150
    64.144  1162.000     0.150
    64.144  1402.402     0.150
    64.131   633.801     0.150
    64.131  1150.301     0.150
    65.635   644.801     0.150
    65.635  1171.301     0.150
    66.072   649.301     0.150
    66.140   649.199     0.150
    66.463   650.301     0.150
    66.463   798.301     0.150
    66.463  1177.301     0.150
    66.463  1434.301     0.150
    67.792   657.121     0.150
    67.792   657.301     0.150
    67.772   657.402     0.150
    67.997   659.230     0.150
    67.997   807.332     0.150
    68.055   661.711     0.150
    68.498   662.301     0.150
    68.544   661.789     0.150
    68.544   662.102     0.150
    68.568   663.602     0.150
    68.568   688.301     0.150
    68.568   819.199     0.150
    68.568  1199.199     0.150
    69.446   669.102     0.150
    69.446   826.500     0.150
    69.446  1213.102     0.150
    69.446  1484.500     0.150
    69.594   668.262     0.150
    69.634   668.602     0.150
    69.907   670.941     0.150
    70.260   672.652     0.150
    70.337   674.402     0.150
    70.337  1226.402     0.150
    71.014   680.602     0.150
    71.014  1238.801     0.150
    71.025   677.801     0.150
    71.144   679.121     0.150
    71.337   680.262     0.150
    71.578   681.930     0.150
    71.833   683.402     0.150
    71.833  1243.402     0.150
    71.843   682.660     0.150
    72.211   686.340     0.150
    72.221   687.262     0.150
    72.247   850.199     0.150
    72.247  1245.301     0.150
    72.247  1528.199     0.150
    72.339   686.129     0.150
    72.747   688.902     0.150
    72.747  1256.000     0.150
    72.747  1289.699     0.150
    72.913   690.301     0.150
    72.915   689.500     0.150
    73.065   690.449     0.150
    73.631   693.352     0.150
    73.841   695.102     0.150
    73.841   710.301     0.150
    74.137   696.551     0.150
    74.137   697.199     0.150
    74.186   697.102     0.150
    74.186   862.301     0.150
    74.186  1268.801     0.150
    74.554   699.402     0.150
    74.554  1270.500     0.150
    74.866   704.199     0.150
    74.894   704.902     0.150
    74.894  1277.402     0.150
    75.183   701.840     0.150
    75.183   702.000     0.150
    75.428   704.699     0.150
    75.472   705.430     0.150
    76.040   709.152     0.150
    76.113   704.301     0.150
    76.113   717.102     0.150
    76.113  1286.402     0.150
    76.113  1317.902     0.150
    76.254   708.742     0.150
    76.271   709.699     0.150
    76.639   712.602     0.150
    76.692   713.152     0.150
    76.789   712.801     0.150
    76.789   887.301     0.150
    76.931   712.742     0.150
    77.219   713.199     0.150
    77.264   715.699     0.150
    77.428   715.262     0.150
    77.700   717.512     0.150
    78.522   721.422     0.150
    78.522   721.602     0.150
    78.824   724.973     0.150
    79.018   723.699     0.150
    79.720   727.340     0.150
    79.720   728.102     0.150
    80.049   730.051     0.150
    80.211   730.129     0.150
    80.337   731.930     0.150
    80.363   733.840     0.150
    80.353   731.301     0.150
    80.353   731.723     0.150
    80.476   731.582     0.150
    80.620   736.000     0.150
    80.620  1341.801     0.150
    80.620  1391.102     0.150
    80.762   734.090     0.150
    80.825   733.602     0.150
    80.798   736.902     0.150
    80.798  1340.902     0.150
    80.847   734.562     0.150
    80.899   734.371     0.150
    80.990  1344.199     0.150
    81.125   737.910     0.150
    81.186   736.102     0.150
    81.186   741.500     0.150
    81.186   921.699     0.150
    81.186  1344.102     0.150
    81.186  1356.402     0.150
    81.293   737.859     0.150
    81.368   737.871     0.150
    81.289   735.797     0.150
    81.630   738.402     0.150
    81.630   738.602     0.150
    81.662   740.102     0.150
    81.822   740.352     0.150
    81.981   740.629     0.150
    82.155   740.801     0.150
    82.220   742.082     0.150
    82.234   741.352     0.150
    82.274   742.723     0.150
    82.334   743.711     0.150
    82.543   743.539     0.150
    82.619   743.332     0.150
    82.619   743.602     0.150
    82.819   745.109     0.150
    82.857   744.980     0.150
    83.164   746.973     0.150
    83.321   748.090     0.150
    83.330   746.711     0.150
    83.365   746.961     0.150
    83.545   748.500     0.150
    83.666   749.449     0.150
    83.841   750.410     0.150
    83.890   748.172     0.150
    83.986   750.629     0.150
    84.044   750.930     0.150
    84.303   752.039     0.150
    84.392   752.949     0.150
    84.520   754.281     0.150
    84.570   754.062     0.150
    84.625   753.172     0.150
    84.732   754.242     0.150
    84.766   755.371     0.150
    84.792   754.012     0.150
    84.798   754.672     0.150
    85.283   756.199     0.150
    85.294   757.121     0.150
    85.337   758.359     0.150
    85.682   759.473     0.150
    86.298   762.973     0.150
    86.318   763.629     0.150
    86.318   763.801     0.150
    86.488   762.750     0.150
    86.488   763.301     0.150
    86.488  1396.301     0.150
    86.488  1391.301     0.150
    86.490   763.012     0.150
    86.676   764.352     0.150
    86.676   764.801     0.150
    86.736   764.879     0.150
    86.736   765.000     0.150
    87.126   768.090     0.150
    87.376   767.973     0.150
    87.457   768.281     0.150
    87.453   768.320     0.150
    87.548   768.449     0.150
    87.631   769.172     0.150
    87.871   769.129     0.150
    88.534   772.020     0.150
    88.534   772.301     0.150
    88.738   774.062     0.150
    89.207   775.812     0.150
    89.394   777.902     0.150
    89.438   778.480     0.150
    89.462   777.352     0.150
    89.493   777.301     0.150
    89.559   777.930     0.150
    90.113   780.109     0.150
    90.225   780.910     0.150
    90.543   783.141     0.150
    90.572   783.902     0.150
    90.772   784.000     0.150
    90.984   784.410     0.150
    92.715   795.961     0.150
   124.846  1138.062     0.150
   124.846  1243.582     0.150
   126.713  1141.801     0.150
   126.715  1141.449     0.150
   126.715  1255.102     0.150
   131.499  1152.102     0.150
   141.569  1167.301     0.150
   149.086  1189.172     0.150
   149.506  1179.199     0.150
   149.602  1179.699     0.150
   152.402  1184.801     0.150
   152.562  1185.000     0.150
   152.592  1182.801     0.150
     0.391     7.406     0.150
     0.391    13.285     0.150
     0.501     9.477     0.150
     0.501    17.566     0.150
     0.573     9.945     0.150
     0.573    18.867     0.150
     0.528    10.055     0.150
     0.528    19.027     0.150
     0.740    13.758     0.150
     0.766    13.426     0.150
     0.766    25.758     0.150
     1.112    18.855     0.150
     1.248    21.715     0.150
     1.248    21.547     0.150
     1.188    21.457     0.150
     1.437    25.586     0.150
     1.577    27.465     0.150
     1.620    28.246     0.150
     1.739    29.438     0.150
     1.648    28.727     0.150
     1.648    51.297     0.150
     1.859    31.375     0.150
     2.093    35.105     0.150
     2.113    35.734     0.150
     2.041    34.406     0.150
     2.335    39.457     0.150
     2.504    40.676     0.150
     2.871    45.727     0.150
     2.871    79.625     0.150
     2.837    44.887     0.150
     2.837    80.066     0.150
     2.863    46.766     0.150
     3.011    48.035     0.150
     3.011    84.734     0.150
     3.045    47.938     0.150
     3.045    84.668     0.150
     3.112    49.984     0.150
     3.158    50.176     0.150
     3.157    49.848     0.150
     3.197    50.555     0.150
     3.116    49.156     0.150
     3.124    48.668     0.150
     3.294    51.945     0.150
     3.294    91.055     0.150
     3.311    53.008     0.150
     3.317    51.855     0.150
     3.317    91.246     0.150
     3.383    53.305     0.150
     3.383    92.805     0.150
     3.473    55.215     0.150
     3.499    54.016     0.150
     3.527    55.016     0.150
     3.662    57.848     0.150
     3.753    58.918     0.150
     3.753   102.645     0.150
     3.761    59.395     0.150
     3.816    58.746     0.150
     3.816   104.547     0.150
     3.737    58.117     0.150
     3.745    57.918     0.150
     3.747    58.836     0.150
     3.906    60.105     0.150
     3.795    59.574     0.150
     3.925    61.016     0.150
     3.925   106.207     0.150
     3.944    61.637     0.150
     3.944   106.836     0.150
     3.944    61.637     0.150
     3.944   106.836     0.150
     4.013    61.484     0.150
     4.013   106.824     0.150
     4.056    61.625     0.150
     4.056   108.324     0.150
     4.159    64.258     0.150
     4.159   111.957     0.150
     4.033    62.547     0.150
     4.213    65.074     0.150
     4.272    65.418     0.150
     4.295    65.348     0.150
     4.295   112.145     0.150
     4.357    66.156     0.150
     4.357   116.016     0.150
     4.357    65.977     0.150
     4.357   113.824     0.150
     4.338    66.695     0.150
     4.391    65.445     0.150
     4.391   114.746     0.150
     4.290    67.715     0.150
     4.482    67.668     0.150
     4.482   117.797     0.150
     4.414    67.145     0.150
     4.467    69.047     0.150
     4.562    67.395     0.150
     4.534    69.855     0.150
     4.440    69.047     0.150
     4.685    68.758     0.150
     4.689    69.188     0.150
     4.735    69.617     0.150
     4.791    70.168     0.150
     4.821    71.746     0.150
     4.821   126.645     0.150
     4.688    69.246     0.150
     4.716    71.586     0.150
     4.716   125.117     0.150
     4.873    72.008     0.150
     4.922    72.605     0.150
     5.004    73.605     0.150
     4.953    83.445     0.150
     5.003    73.887     0.150
     5.043    74.035     0.150
     5.066    73.887     0.150
     5.025    75.387     0.150
     5.025   130.785     0.150
     5.119    75.375     0.150
     5.405    81.297     0.150
     5.366    80.508     0.150
     5.489    81.645     0.150
     5.489   144.145     0.150
     5.343    81.516     0.150
     5.467    81.836     0.150
     5.581   145.445     0.150
     5.558    83.996     0.150
     5.713    86.516     0.150
     5.756    85.246     0.150
     5.754    84.984     0.150
     5.754   147.707     0.150
     5.830    86.246     0.150
     5.853    87.145     0.150
     5.947    86.145     0.150
     6.019    89.848     0.150
     6.019   159.848     0.150
     5.992    90.125     0.150
     6.051    87.727     0.150
     6.101    90.547     0.150
     6.101   160.547     0.150
     6.102    90.246     0.150
     6.102   160.645     0.150
     6.062    91.117     0.150
     6.062    91.207     0.150
     6.024    89.625     0.150
     6.024   153.625     0.150
     6.171    90.945     0.150
     6.171   160.645     0.150
     6.156    90.746     0.150
     6.203    92.547     0.150
     6.180    91.746     0.150
     6.245    92.047     0.150
     6.245   162.848     0.150
     6.303    93.816     0.150
     6.334    91.207     0.150
     6.313    93.047     0.150
     6.300    93.746     0.150
     6.352    93.188     0.150
     6.358    93.246     0.150
     6.324    93.785     0.150
     6.324   161.984     0.150
     6.400    91.566     0.150
     6.506    94.246     0.150
     6.496    93.457     0.150
     6.616    97.746     0.150
     6.624    97.945     0.150
     6.618    97.746     0.150
     6.688    98.234     0.150
     6.674    97.746     0.150
     6.733    96.516     0.150
     6.772   100.945     0.150
     6.786    99.227     0.150
     6.890   100.848     0.150
     6.918   100.945     0.150
     6.970   100.547     0.150
     6.992   101.246     0.150
     6.985   100.848     0.150
     7.006   101.246     0.150
     7.062   102.445     0.150
     7.111   103.645     0.150
     7.154   103.945     0.150
     7.195   102.746     0.150
     7.174   104.246     0.150
     7.189   105.047     0.150
     7.170   106.848     0.150
     7.204   105.445     0.150
     7.275   107.848     0.150
     7.331   106.348     0.150
     7.407   108.746     0.150
     7.491   107.246     0.150
     7.491   188.246     0.150
     7.560   108.547     0.150
     7.594   109.547     0.150
     7.719   111.836     0.150
     7.975   114.348     0.150
     8.052   117.746     0.150
     8.115   130.348     0.150
     8.307   120.918     0.150
     8.343   118.348     0.150
     8.343   208.145     0.150
     8.363   121.746     0.150
     8.397   122.445     0.150
     8.719   123.547     0.150
     8.719   217.246     0.150
     8.920   130.188     0.150
     9.205   150.547     0.150
     9.210   134.746     0.150
     9.226   229.047     0.150
     9.226   295.746     0.150
     9.313   131.945     0.150
     9.313   232.445     0.150
     9.454   135.945     0.150
     9.612   135.945     0.150
     9.612   237.746     0.150
     9.678   136.945     0.150
     9.695   137.348     0.150
     9.695   240.645     0.150
     9.887   140.547     0.150
     9.887   246.445     0.150
    10.012   143.516     0.150
    10.181   144.746     0.150
    10.600   148.945     0.150
    10.913   152.848     0.150
    12.885   181.246     0.150
    18.480   254.797     0.150
    19.501   265.547     0.150
    19.501   266.625     0.150
    20.224   276.125     0.150
    20.922   281.527     0.150
    37.557   434.516     0.150
    39.490   450.145     0.150
    47.264   513.348     0.150
    72.909   689.195     0.150
    73.661   695.984     0.150
    82.135   739.695     0.150
   113.751  1119.746     0.150
     0.507     9.441     0.150
     0.568    11.418     0.150
     0.568    18.680     0.150
     0.525     9.559     0.150
     0.525    18.281     0.150
     0.842    15.629     0.150
     0.842    26.828     0.150
     0.843    15.441     0.150
     1.059    19.691     0.150
     1.059    34.719     0.150
     1.252    23.230     0.150
     1.186    21.898     0.150
     1.435    25.141     0.150
     1.582    27.328     0.150
     1.647    28.340     0.150
     1.647    50.199     0.150
     1.966    31.648     0.150
     2.096    35.160     0.150
     2.117    36.070     0.150
     2.038    34.691     0.150
     2.332    39.301     0.150
     2.507    40.539     0.150
     2.871    45.371     0.150
     2.871    79.551     0.150
     2.867    46.531     0.150
     2.831    45.508     0.150
     2.831    77.539     0.150
     2.830    44.340     0.150
     3.006    48.398     0.150
     3.006    82.570     0.150
     3.039    48.391     0.150
     3.039    82.359     0.150
     3.116    50.039     0.150
     3.161    51.590     0.150
     3.161    49.910     0.150
     3.114    49.719     0.150
     3.288    51.961     0.150
     3.288    88.852     0.150
     3.311    52.148     0.150
     3.311    88.602     0.150
     3.378    53.059     0.150
     3.378    90.809     0.150
     3.477    56.199     0.150
     3.748    58.840     0.150
     3.748   100.461     0.150
     3.736    58.230     0.150
     3.920    61.000     0.150
     3.920   103.789     0.150
     3.938    61.359     0.150
     3.938   104.309     0.150
     3.938    61.359     0.150
     3.938   104.309     0.150
     4.057    64.391     0.150
     4.057   107.891     0.150
     4.090    63.930     0.150
     4.158   111.410     0.150
     4.271   112.949     0.150
     4.294    66.031     0.150
     4.294   113.629     0.150
     4.357    67.930     0.150
     4.357   115.102     0.150
     4.356    65.500     0.150
     4.356   115.398     0.150
     4.391    67.230     0.150
     4.391   114.629     0.150
     4.292    67.852     0.150
     4.481   117.379     0.150
     4.420    67.031     0.150
     4.420   119.629     0.150
     4.924    72.258     0.150
     5.006    73.961     0.150
     5.121    76.602     0.150
     5.759    84.820     0.150
     5.921    87.828     0.150
     5.921    87.930     0.150
     5.950    85.531     0.150
     5.950    85.730     0.150
     6.055    87.238     0.150
     6.206    92.230     0.150
     6.318    92.328     0.150
     6.364    93.031     0.150
     6.510    93.828     0.150
     6.921   101.031     0.150
     6.989   100.430     0.150
     7.010   101.230     0.150
     7.158   104.129     0.150
     7.280   107.730     0.150
     7.492   119.430     0.150
     7.492   187.430     0.150
     7.979   114.531     0.150
     8.346   118.129     0.150
     8.346   208.730     0.150
     8.722   123.531     0.150
     8.722   217.129     0.150
     9.617   239.430     0.150
     9.891   140.531     0.150
    10.767   155.730     0.150
    11.821   167.629     0.150
     0.502     9.270     0.150
     0.502    16.438     0.150
     0.537     9.777     0.150
     0.573     9.949     0.150
     0.573    18.250     0.150
     0.747    14.461     0.150
     0.847    16.648     0.150
     0.847    28.648     0.150
     0.855    16.648     0.150
     1.071    19.641     0.150
     1.071    36.621     0.150
     1.109    18.898     0.150
     1.199    22.320     0.150
     1.199    40.660     0.150
     1.242    23.410     0.150
     1.448    25.238     0.150
     1.659    28.801     0.150
     1.659    50.520     0.150
     1.734    30.398     0.150
     1.975    31.828     0.150
     2.050    34.871     0.150
     2.495    41.480     0.150
     2.840    45.301     0.150
     2.859    44.668     0.150
     2.859    79.230     0.150
     3.104    50.059     0.150
     4.045   108.148     0.150
     4.147   110.238     0.150
     4.260   113.559     0.150
     4.412    67.250     0.150
     4.912    72.590     0.150
     5.849    86.551     0.150
     6.310    92.551     0.150
     6.978   101.148     0.150
     6.999   101.551     0.150
     7.270   105.250     0.150
     8.334   118.348     0.150
     8.334   209.250     0.150
     8.710   123.551     0.150
     8.710   217.449     0.150
     9.307   132.348     0.150
     9.881   140.648     0.150
     0.516     9.754     0.150
     0.547    10.883     0.150
     0.561    10.973     0.150
     0.561    19.633     0.150
     0.771    15.184     0.150
     0.771    27.363     0.150
     0.782    15.074     0.150
     0.782    27.883     0.150
     0.833    16.934     0.150
     0.876    16.254     0.150
     1.085    20.094     0.150
     1.217    23.023     0.150
     1.217    41.055     0.150
     1.463    26.574     0.150
     1.463    46.035     0.150
     1.590    28.605     0.150
     1.738    32.312     0.150
     1.676    29.684     0.150
     1.676    51.094     0.150
     2.076    36.676     0.150
     1.972    32.926     0.150
     2.101    38.656     0.150
     2.060    36.293     0.150
     2.358    40.543     0.150
     2.850    47.664     0.150
     2.836    45.715     0.150
     2.836    80.465     0.150
     2.838    45.895     0.150
     3.142    52.156     0.150
     3.767    59.695     0.150
     3.802    62.535     0.150
     3.802   107.535     0.150
     4.022    63.523     0.150
     4.022   109.266     0.150
     4.123    64.523     0.150
     4.123   111.613     0.150
     4.235   116.523     0.150
     4.258    66.336     0.150
     4.258   113.035     0.150
     4.320    66.266     0.150
     4.358    67.234     0.150
     4.358   117.336     0.150
     4.421    68.035     0.150
     4.445   118.465     0.150
     4.786    72.633     0.150
     4.786   126.734     0.150
     4.897    73.625     0.150
     4.935    93.734     0.150
     6.136    91.836     0.150
     6.136   161.234     0.150
     6.315    94.434     0.150
     6.362    93.836     0.150
     6.976   101.133     0.150
     7.171   104.633     0.150
     7.458   108.035     0.150
     7.458   123.234     0.150
     7.458   189.434     0.150
     8.266   209.133     0.150
     8.325   119.133     0.150
     8.325   209.133     0.150
     8.702   124.434     0.150
     8.702   216.934     0.150
     9.602   137.434     0.150
     9.602   240.633     0.150
     9.670   137.734     0.150
     9.880   142.035     0.150
    13.921   196.633     0.150
     0.509     9.547     0.150
     0.509    17.047     0.150
     0.538    10.625     0.150
     0.538    19.227     0.150
     0.566    10.645     0.150
     0.566    21.145     0.150
     0.756    15.363     0.150
     0.756    26.754     0.150
     0.774    14.637     0.150
     0.774    27.535     0.150
     0.840    16.676     0.150
     0.840    29.574     0.150
     0.860    17.305     0.150
     1.073    20.105     0.150
     1.203    22.953     0.150
     1.203    40.934     0.150
     1.245    22.055     0.150
     1.451    25.984     0.150
     1.584    28.047     0.150
     1.663    29.246     0.150
     1.663    51.176     0.150
     1.739    30.824     0.150
     1.971    32.637     0.150
     2.051    35.316     0.150
     2.084    35.965     0.150
     2.107    38.164     0.150
     2.347    40.137     0.150
     2.494    42.227     0.150
     2.824    46.426     0.150
     2.824    80.434     0.150
     2.857    47.625     0.150
     2.853    45.555     0.150
     2.853    80.305     0.150
     2.836    45.875     0.150
     2.996    49.047     0.150
     2.996    85.074     0.150
     3.033    49.184     0.150
     3.033    84.625     0.150
     3.105    51.773     0.150
     3.279    52.844     0.150
     3.279    91.586     0.150
     3.307    52.625     0.150
     3.307    90.574     0.150
     3.371    53.637     0.150
     3.371    92.895     0.150
     3.737    60.414     0.150
     3.737   103.465     0.150
     3.752    60.406     0.150
     3.808    62.773     0.150
     3.808   106.375     0.150
     3.913    62.066     0.150
     3.913   106.074     0.150
     3.930    62.316     0.150
     3.930   107.375     0.150
     3.930    62.316     0.150
     3.930   107.375     0.150
     4.039    62.797     0.150
     4.039   109.074     0.150
     4.140    64.145     0.150
     4.140   111.395     0.150
     4.253    65.137     0.150
     4.253   113.605     0.150
     4.276    66.273     0.150
     4.276   111.875     0.150
     4.338    66.203     0.150
     4.338   117.395     0.150
     4.374    67.074     0.150
     4.374   116.176     0.150
     4.418    67.676     0.150
     4.463    67.477     0.150
     4.463   119.035     0.150
     4.803    72.375     0.150
     4.803   126.074     0.150
     4.909    73.414     0.150
     5.104    75.465     0.150
     5.473    82.375     0.150
     5.473   144.977     0.150
     5.853    86.977     0.150
     6.153    91.477     0.150
     6.153   161.074     0.150
     6.314    93.477     0.150
     6.361    93.273     0.150
     6.616    97.676     0.150
     6.981   102.676     0.150
     7.001   103.176     0.150
     7.474   108.074     0.150
     7.474   189.375     0.150
     8.283   209.176     0.150
     8.334   120.574     0.150
     8.334   206.977     0.150
     8.710   126.176     0.150
     8.710   216.676     0.150
     9.607   138.773     0.150
     9.607   239.676     0.150
     9.674   138.574     0.150
     9.686   138.977     0.150
     9.686   239.773     0.150
     0.516    10.410     0.150
     0.516    18.051     0.150
     0.560    11.109     0.150
     0.560    18.340     0.150
     0.542    11.090     0.150
     0.768    14.559     0.150
     0.777    14.449     0.150
     0.777    26.328     0.150
     0.833    16.340     0.150
     0.869    15.527     0.150
     0.869    29.590     0.150
     1.079    19.730     0.150
     1.079    34.539     0.150
     1.118    19.938     0.150
     1.118    39.617     0.150
     1.246    21.859     0.150
     1.246    22.141     0.150
     1.211    21.719     0.150
     1.457    26.469     0.150
     1.591    28.238     0.150
     1.605    28.738     0.150
     1.634    28.840     0.150
     1.670    29.418     0.150
     1.670    51.750     0.150
     1.741    31.059     0.150
     1.864    32.301     0.150
     1.969    33.027     0.150
     2.081    36.238     0.150
     2.055    35.750     0.150
     2.105    37.488     0.150
     2.352    40.320     0.150
     2.490    41.539     0.150
     2.814    45.918     0.150
     2.814    81.867     0.150
     2.842    45.738     0.150
     2.842    80.391     0.150
     2.855    47.148     0.150
     2.835    45.891     0.150
     2.986    48.211     0.150
     2.986    86.469     0.150
     3.024    48.949     0.150
     3.024    86.359     0.150
     3.102    50.520     0.150
     3.148    51.078     0.150
     3.152    50.660     0.150
     3.136    49.828     0.150
     3.153    49.629     0.150
     3.197    51.609     0.150
     3.269    52.410     0.150
     3.301    53.910     0.150
     3.299    52.848     0.150
     3.267    51.668     0.150
     3.361    53.520     0.150
     3.361    94.859     0.150
     3.464    56.230     0.150
     3.524    55.289     0.150
     3.553    55.578     0.150
     3.647    58.539     0.150
     3.647    98.141     0.150
     3.726    59.340     0.150
     3.726   104.801     0.150
     3.757    60.211     0.150
     3.795    59.410     0.150
     3.795   104.020     0.150
     3.789    59.539     0.150
     3.789   103.539     0.150
     3.761    59.320     0.150
     3.801    60.340     0.150
     3.771    59.039     0.150
     3.778    59.910     0.150
     3.865    62.699     0.150
     3.826    60.789     0.150
     3.911    62.539     0.150
     3.911   108.660     0.150
     3.899    61.277     0.150
     3.903    61.891     0.150
     3.903   108.660     0.150
     3.920    61.938     0.150
     3.920   109.090     0.150
     3.920    61.938     0.150
     3.920   109.090     0.150
     3.984    62.711     0.150
     3.984   106.551     0.150
     4.006    67.750     0.150
     4.006   115.488     0.150
     4.029    62.379     0.150
     4.029   109.668     0.150
     4.063    61.789     0.150
     4.078    64.277     0.150
     4.066    63.379     0.150
     4.129    64.461     0.150
     4.129   110.609     0.150
     4.147    63.449     0.150
     4.208    66.020     0.150
     4.219    67.309     0.150
     4.242    65.551     0.150
     4.242   116.449     0.150
     4.264    65.840     0.150
     4.327    66.527     0.150
     4.327   116.910     0.150
     4.328    67.609     0.150
     4.328   116.008     0.150
     4.333    68.449     0.150
     4.325    68.539     0.150
     4.325   138.039     0.150
     4.365    66.141     0.150
     4.365   116.738     0.150
     4.322    69.039     0.150
     4.451    68.051     0.150
     4.423    67.840     0.150
     4.460    70.250     0.150
     4.468    69.020     0.150
     4.535    68.117     0.150
     4.537    68.410     0.150
     4.528    70.730     0.150
     4.521    70.141     0.150
     4.521    79.340     0.150
     4.521    84.141     0.150
     4.521   121.438     0.150
     4.521   132.438     0.150
     4.549    68.219     0.150
     4.624    69.289     0.150
     4.660    69.480     0.150
     4.665    70.039     0.150
     4.713    70.520     0.150
     4.714    70.508     0.150
     4.657    72.027     0.150
     4.715    73.160     0.150
     4.715   124.559     0.150
     4.714    69.641     0.150
     4.767    70.848     0.150
     4.793    72.641     0.150
     4.793   127.039     0.150
     4.805    72.250     0.150
     4.848    72.910     0.150
     4.903    73.301     0.150
     4.935    76.938     0.150
     4.935    95.938     0.150
     4.935   132.539     0.150
     4.935   144.539     0.150
     4.980    74.410     0.150
     4.989    75.008     0.150
     5.019    74.809     0.150
     5.014    77.039     0.150
     5.014   129.918     0.150
     5.043    74.988     0.150
     5.096    76.258     0.150
     5.141    84.539     0.150
     5.289    80.230     0.150
     5.289   138.289     0.150
     5.369    81.480     0.150
     5.401    81.848     0.150
     5.376    81.949     0.150
     5.464    81.539     0.150
     5.464   143.539     0.150
     5.466    82.629     0.150
     5.466    83.320     0.150
     5.551    82.738     0.150
     5.559    85.379     0.150
     5.559    84.789     0.150
     5.712    87.238     0.150
     5.740    86.027     0.150
     5.742    86.398     0.150
     5.742   148.000     0.150
     5.771    85.840     0.150
     5.815    87.539     0.150
     5.815    87.238     0.150
     5.836    87.039     0.150
     5.855    87.840     0.150
     5.901    88.438     0.150
     5.904    89.641     0.150
     5.936    86.738     0.150
     5.998    89.938     0.150
     5.998   158.938     0.150
     5.992    90.840     0.150
     6.016    90.078     0.150
     6.016   153.719     0.150
     6.041    88.418     0.150
     6.032    90.938     0.150
     6.059    91.141     0.150
     6.062    92.148     0.150
     6.080    91.141     0.150
     6.080   159.738     0.150
     6.082    90.840     0.150
     6.082   159.141     0.150
     6.081    90.801     0.150
     6.081   155.641     0.150
     6.143    91.641     0.150
     6.143   161.141     0.150
     6.142    91.141     0.150
     6.162    93.539     0.150
     6.187    93.238     0.150
     6.198    92.738     0.150
     6.225    92.840     0.150
     6.225   163.238     0.150
     6.216    93.898     0.150
     6.225    92.359     0.150
     6.269    92.141     0.150
     6.279    94.039     0.150
     6.302    94.598     0.150
     6.323    92.148     0.150
     6.326    91.777     0.150
     6.317    93.340     0.150
     6.321    95.160     0.150
     6.350    93.488     0.150
     6.364    93.938     0.150
     6.476    96.359     0.150
     6.495    95.141     0.150
     6.492    94.488     0.150
     6.518    94.348     0.150
     6.598    98.641     0.150
     6.598   173.938     0.150
     6.609    98.340     0.150
     6.616    97.738     0.150
     6.617    98.539     0.150
     6.671   100.340     0.150
     6.671   114.438     0.150
     6.658    99.539     0.150
     6.686    99.801     0.150
     6.728    97.098     0.150
     6.747   100.238     0.150
     6.781   100.398     0.150
     6.781   171.641     0.150
     6.815   101.488     0.150
     6.873   101.938     0.150
     6.873   132.340     0.150
     6.873   213.539     0.150
     6.876   101.840     0.150
     6.905   100.738     0.150
     6.914   100.738     0.150
     6.958   101.438     0.150
     6.948   104.938     0.150
     6.947   103.539     0.150
     6.939   101.918     0.150
     6.947   102.641     0.150
     6.982   101.641     0.150
     6.980   101.641     0.150
     6.982   104.039     0.150
     7.001   102.039     0.150
     7.049   103.141     0.150
     7.044   105.938     0.150
     7.095   104.141     0.150
     7.145   104.539     0.150
     7.162   104.828     0.150
     7.162   106.438     0.150
     7.153   105.238     0.150
     7.170   104.641     0.150
     7.170   183.141     0.150
     7.148   105.438     0.150
     7.163   104.938     0.150
     7.181   105.738     0.150
     7.174   106.738     0.150
     7.193   106.539     0.150
     7.197   105.840     0.150
     7.226   106.938     0.150
     7.275   108.738     0.150
     7.323   107.238     0.150
     7.349   108.078     0.150
     7.390   109.539     0.150
     7.464   108.340     0.150
     7.464   121.539     0.150
     7.464   190.141     0.150
     7.469   109.141     0.150
     7.532   109.438     0.150
     7.544   109.340     0.150
     7.587   109.539     0.150
     7.584   110.039     0.150
     7.688   112.879     0.150
     7.688   195.277     0.150
     7.692   111.340     0.150
     7.767   111.738     0.150
     7.853   112.938     0.150
     7.967   115.340     0.150
     7.967   202.938     0.150
     7.967   116.039     0.150
     8.026   115.641     0.150
     8.057   116.238     0.150
     8.053   118.738     0.150
     8.221   118.039     0.150
     8.272   119.840     0.150
     8.272   207.840     0.150
     8.275   121.730     0.150
     8.331   118.840     0.150
     8.331   209.238     0.150
     8.341   123.039     0.150
     8.364   120.840     0.150
     8.364   120.840     0.150
     8.401   122.840     0.150
     8.440   124.840     0.150
     8.473   121.738     0.150
     8.533   122.539     0.150
     8.676   218.039     0.150
     8.684   129.938     0.150
     8.693   127.938     0.150
     8.707   124.539     0.150
     8.707   216.840     0.150
     8.893   131.000     0.150
     8.920   130.699     0.150
     8.920   225.520     0.150
     9.035   129.039     0.150
     9.151   131.238     0.150
     9.172   137.840     0.150
     9.172   260.938     0.150
     9.180   136.039     0.150
     9.202   132.641     0.150
     9.202   230.539     0.150
     9.276   134.809     0.150
     9.276   236.711     0.150
     9.308   132.738     0.150
     9.308   234.641     0.150
     9.336   136.777     0.150
     9.336   232.156     0.150
     9.462   135.039     0.150
     9.559   136.438     0.150
     9.559   237.141     0.150
     9.594   137.840     0.150
     9.594   240.238     0.150
     9.606   136.738     0.150
     9.606   240.238     0.150
     9.633   141.719     0.150
     9.674   139.340     0.150
     9.674   243.340     0.150
     9.674   277.340     0.150
     9.674   137.938     0.150
     9.683   138.238     0.150
     9.683   240.938     0.150
     9.883   141.438     0.150
     9.883   248.141     0.150
     9.946   145.949     0.150
     9.946   251.020     0.150
     9.997   144.730     0.150
     9.996   143.000     0.150
    10.179   145.641     0.150
    10.179   255.141     0.150
    10.328   150.508     0.150
    10.328   260.078     0.150
    10.604   151.711     0.150
    10.939   276.750     0.150
    10.950   158.617     0.150
    10.950   274.309     0.150
    11.146   157.238     0.150
    11.647   168.590     0.150
    11.647   169.953     0.150
    11.815   167.840     0.150
    11.908   173.289     0.150
    11.908   171.863     0.150
    12.183   175.180     0.150
    12.196   176.020     0.150
    12.196   176.281     0.150
    12.879   181.738     0.150
    12.905   187.148     0.150
    12.905   185.883     0.150
    12.961   187.559     0.150
    12.961   188.855     0.150
    13.499   192.348     0.150
    13.615   197.359     0.150
    13.964   202.211     0.150
    14.321   207.098     0.150
    14.321   207.840     0.150
    14.414   205.961     0.150
    14.414   204.578     0.150
    14.543   210.809     0.150
    15.062   217.629     0.150
    15.292   220.367     0.150
    15.292   221.312     0.150
    15.365   221.160     0.150
    15.365   222.590     0.150
    15.908   227.027     0.150
    15.908   228.527     0.150
    15.925   227.730     0.150
    15.925   228.797     0.150
    15.984   223.859     0.150
    16.613   236.938     0.150
    16.729   237.504     0.150
    16.932   240.438     0.150
    17.071   240.738     0.150
    17.132   242.641     0.150
    17.687   250.520     0.150
    17.687   249.109     0.150
    17.706   250.238     0.150
    18.452   256.820     0.150
    18.471   256.879     0.150
    18.607   258.039     0.150
    19.303   267.117     0.150
    19.473   268.238     0.150
    19.473   267.918     0.150
    20.226   276.801     0.150
    20.890   282.289     0.150
    21.548   288.641     0.150
    26.999   344.938     0.150
    28.432   355.117     0.150
    31.587   382.098     0.150
    37.527   435.188     0.150
    38.287   441.199     0.150
    38.427   443.500     0.150
    39.523   453.539     0.150
    47.236   515.438     0.150
    47.234   514.680     0.150
    50.791   540.188     0.150
    52.882   554.590     0.150
    64.642   635.609     0.150
    67.759   658.090     0.150
    67.759   657.562     0.150
    68.510   661.867     0.150
    68.510     7.352     0.150
    70.226   672.438     0.150
    72.180   686.180     0.150
    72.882   690.141     0.150
    72.882     8.699     0.150
    73.641   693.539     0.150
    73.641     7.000     0.150
    81.111   735.117     0.150
    81.111     8.301     0.150
    81.947   740.777     0.150
    82.121   740.738     0.150
    82.121     7.531     0.150
    85.304   758.289     0.150
    89.362   777.688     0.150
    89.362     6.453     0.150
    89.525   778.629     0.150
   126.731  1149.438     0.150
     0.534    10.426     0.150
     0.534    19.824     0.150
     0.550    10.547     0.150
     0.550    18.945     0.150
     0.528    11.258     0.150
     0.528    18.367     0.150
     0.766    14.266     0.150
     0.766    27.156     0.150
     0.803    15.535     0.150
     0.878    15.734     0.150
     0.878    28.574     0.150
     0.800    28.785     0.150
     1.077    19.637     0.150
     1.215    23.375     0.150
     1.267    23.266     0.150
     1.456    27.234     0.150
     1.766    32.125     0.150
     1.944    34.008     0.150
     2.093    37.395     0.150
     2.499    42.145     0.150
     2.829    46.164     0.150
     2.829    80.816     0.150
     4.018    63.195     0.150
     4.018   109.824     0.150
     4.112   112.688     0.150
     4.226   114.707     0.150
     4.245    74.086     0.150
     4.309    67.117     0.150
     4.309   116.707     0.150
     4.452    68.785     0.150
     4.435    69.145     0.150
     4.435   118.945     0.150
     4.781    72.887     0.150
     4.781   127.586     0.150
     5.880    88.785     0.150
     6.131    92.188     0.150
     6.131   162.484     0.150
     6.344    94.586     0.150
     6.392    94.887     0.150
     6.639    99.086     0.150
     6.999   102.887     0.150
     7.200   108.188     0.150
     7.455   110.484     0.150
     7.455   121.586     0.150
     7.455   190.887     0.150
     7.983   116.086     0.150
     8.076   118.688     0.150
     8.342   119.688     0.150
     8.342   210.188     0.150
     8.719   125.086     0.150
     8.719   219.785     0.150
     9.328   134.086     0.150
     9.328   236.387     0.150
     9.623   242.688     0.150
     0.513     9.320     0.150
     0.513    17.289     0.150
     0.522     9.977     0.150
     0.522    18.227     0.150
     0.561    10.977     0.150
     0.561    19.188     0.150
     0.751    13.977     0.150
     0.758    13.266     0.150
     0.843    16.727     0.150
     0.835    16.188     0.150
     1.056    19.094     0.150
     1.185    22.406     0.150
     1.185    38.047     0.150
     1.434    25.500     0.150
     1.645    29.047     0.150
     1.645    48.711     0.150
     1.749    30.914     0.150
     1.960    31.938     0.150
     2.035    34.609     0.150
     2.100    35.977     0.150
     2.330    39.648     0.150
     2.510    41.289     0.150
     2.870    44.844     0.150
     2.870    79.688     0.150
     4.056   108.391     0.150
     4.156   111.109     0.150
     4.269   112.375     0.150
     4.354    65.695     0.150
     4.354   113.898     0.150
     4.391    66.484     0.150
     4.391   116.891     0.150
     4.426    67.484     0.150
     4.479    67.141     0.150
     4.479   117.570     0.150
     4.820    71.789     0.150
     4.820   126.289     0.150
     4.926    72.984     0.150
     5.864    86.891     0.150
     6.170    91.086     0.150
     6.170   160.984     0.150
     6.324    93.188     0.150
     6.370    93.289     0.150
     6.628    97.391     0.150
     6.994   101.586     0.150
     7.015   101.688     0.150
     7.181   106.586     0.150
     7.983   113.586     0.150
     7.983   201.789     0.150
     8.350   118.391     0.150
     8.350   208.289     0.150
     8.726   123.086     0.150
     8.726   217.289     0.150
     9.322   132.484     0.150
     9.322   234.891     0.150
     9.621   240.586     0.150
     0.510     9.797     0.150
     0.567    10.344     0.150
     0.567    19.188     0.150
     0.549    10.477     0.150
     0.549    19.570     0.150
     0.785    14.594     0.150
     0.785    27.648     0.150
     0.765    14.977     0.150
     0.839    16.719     0.150
     0.839    28.117     0.150
     0.875    16.836     0.150
     1.086    19.711     0.150
     1.217    22.844     0.150
     1.217    41.156     0.150
     1.238    23.898     0.150
     1.464    25.984     0.150
     1.584    27.586     0.150
     1.677    29.523     0.150
     1.733    31.258     0.150
     1.976    33.320     0.150
     2.063    36.016     0.150
     2.073    35.617     0.150
     2.097    37.305     0.150
     2.359    40.391     0.150
     2.482    40.984     0.150
     2.838    46.000     0.150
     2.838    79.797     0.150
     2.847    46.711     0.150
     3.094    50.984     0.150
     3.143    51.664     0.150
     3.144    52.375     0.150
     4.024   109.211     0.150
     4.125   111.227     0.150
     4.238    65.406     0.150
     4.238   114.047     0.150
     4.261    80.320     0.150
     4.323    66.156     0.150
     4.323   117.219     0.150
     4.448    68.289     0.150
     4.448   118.188     0.150
     4.415    67.414     0.150
     4.415   121.117     0.150
     4.788    72.414     0.150
     4.788   126.516     0.150
     4.896    73.070     0.150
     5.090    75.484     0.150
     5.458    82.016     0.150
     5.458   144.914     0.150
     5.828    86.719     0.150
     5.847    87.719     0.150
     5.894    88.820     0.150
     5.928    86.414     0.150
     6.138    91.516     0.150
     6.138   160.719     0.150
     6.180    94.219     0.150
     6.310    94.016     0.150
     6.356    93.719     0.150
     6.487    94.719     0.150
     6.609    99.016     0.150
     6.609    98.117     0.150
     6.898   101.617     0.150
     6.950   101.914     0.150
     6.975   103.117     0.150
     6.972   101.516     0.150
     6.993   101.719     0.150
     7.267   107.617     0.150
     7.459   119.617     0.150
     7.459   188.617     0.150
     7.959   115.320     0.150
     8.323   117.516     0.150
     8.323   207.219     0.150
     8.699   123.820     0.150
     8.699   219.016     0.150
     9.300   235.719     0.150
     9.598   136.617     0.150
     9.598   240.617     0.150
     0.490     9.156     0.150
     0.490    15.875     0.150
     0.540     9.922     0.150
     0.584    11.633     0.150
     0.584    20.805     0.150
     0.734    14.594     0.150
     0.777    14.070     0.150
     0.859    16.086     0.150
     0.859    28.484     0.150
     0.851    16.680     0.150
     0.851    29.781     0.150
     1.100    36.539     0.150
     1.071    18.750     0.150
     1.197    21.992     0.150
     1.447    25.125     0.150
     1.726    30.500     0.150
     1.657    28.711     0.150
     2.081    35.102     0.150
     2.101    36.164     0.150
     1.983    31.922     0.150
     2.053    34.484     0.150
     2.493    40.383     0.150
     2.345    38.633     0.150
     2.851    46.430     0.150
     2.866    44.562     0.150
     2.866    78.656     0.150
     2.845    45.109     0.150
     2.845    79.594     0.150
     3.019    48.445     0.150
     3.019    85.016     0.150
     3.100    50.742     0.150
     3.054    48.125     0.150
     3.054    83.812     0.150
     3.146    50.672     0.150
     3.144    50.266     0.150
     3.185    51.641     0.150
     3.125    48.750     0.150
     3.299    52.820     0.150
     3.302    52.164     0.150
     3.302    91.516     0.150
     3.327    51.273     0.150
     3.327    89.555     0.150
     3.392    53.305     0.150
     3.392    92.305     0.150
     3.760    59.477     0.150
     3.760   103.312     0.150
     3.863    61.406     0.150
     3.751    58.727     0.150
     3.745    57.945     0.150
     3.753    57.766     0.150
     3.814   102.883     0.150
     3.827    62.180     0.150
     3.827   103.781     0.150
     3.940    60.984     0.150
     3.934    60.922     0.150
     3.934   105.641     0.150
     3.952    61.625     0.150
     3.952   106.492     0.150
     3.952    61.625     0.150
     3.952   106.492     0.150
     4.050    61.062     0.150
     4.050   109.031     0.150
     4.019    62.445     0.150
     4.081    60.703     0.150
     4.074    63.602     0.150
     4.155    62.289     0.150
     4.155   110.602     0.150
     4.201    64.625     0.150
     4.215    66.273     0.150
     4.267    63.977     0.150
     4.267   112.711     0.150
     4.292    64.281     0.150
     4.292   109.680     0.150
     4.326    66.594     0.150
     4.350    65.336     0.150
     4.350   114.812     0.150
     4.353    64.961     0.150
     4.353   115.414     0.150
     4.384    64.883     0.150
     4.384   116.180     0.150
     4.292    67.625     0.150
     4.403    67.086     0.150
     4.403   117.086     0.150
     4.455    68.906     0.150
     4.477    66.555     0.150
     4.477   116.750     0.150
     4.521    69.391     0.150
     4.544    69.180     0.150
     4.681    69.852     0.150
     4.815    71.383     0.150
     4.815   127.781     0.150
     4.822    71.055     0.150
     4.912    72.180     0.150
     4.912   125.516     0.150
     4.992    73.820     0.150
     4.963    75.180     0.150
     4.963   133.180     0.150
     5.111    74.516     0.150
     5.320    79.383     0.150
     5.320   137.391     0.150
     5.482    80.383     0.150
     5.482   143.281     0.150
     5.576    81.180     0.150
     5.576   144.180     0.150
     5.746    84.227     0.150
     5.840    85.781     0.150
     5.841    86.984     0.150
     5.907    87.883     0.150
     5.935    85.586     0.150
     5.841    86.586     0.150
     6.010    89.383     0.150
     6.010   158.383     0.150
     6.039    87.930     0.150
     6.092    89.781     0.150
     6.092   158.883     0.150
     6.093    90.086     0.150
     6.093   158.984     0.150
     6.145    89.883     0.150
     6.164    90.484     0.150
     6.164   160.484     0.150
     6.192    92.086     0.150
     6.236    91.680     0.150
     6.236   161.883     0.150
     6.190    91.383     0.150
     6.301    92.484     0.150
     6.346    93.281     0.150
     6.309    93.383     0.150
     6.495    93.883     0.150
     6.619    97.281     0.150
     6.606    97.086     0.150
     6.730   100.484     0.150
     6.684    97.883     0.150
     6.879   100.883     0.150
     6.907   100.586     0.150
     6.958   101.281     0.150
     6.972   100.586     0.150
     6.972   175.484     0.150
     6.980   102.484     0.150
     6.993   101.086     0.150
     6.993   176.883     0.150
     7.050   103.086     0.150
     7.012   103.383     0.150
     7.142   103.680     0.150
     7.162   103.883     0.150
     7.158   105.484     0.150
     7.177   104.781     0.150
     7.191   103.180     0.150
     7.191   181.180     0.150
     7.192   105.586     0.150
     7.195   104.516     0.150
     7.263   107.680     0.150
     7.319   106.086     0.150
     7.485   107.086     0.150
     7.485   190.086     0.150
     7.715   113.242     0.150
     7.963   113.883     0.150
     7.963   199.984     0.150
     8.026   114.281     0.150
     8.026   199.680     0.150
     8.040   115.781     0.150
     8.062   116.281     0.150
     8.062   201.984     0.150
     8.295   118.086     0.150
     8.295   207.383     0.150
     8.304   121.664     0.150
     8.331   117.586     0.150
     8.331   206.484     0.150
     8.379   207.586     0.150
     8.385   120.883     0.150
     8.476   120.281     0.150
     8.476   211.586     0.150
     8.694   124.484     0.150
     8.694   219.281     0.150
     8.708   123.086     0.150
     8.708   215.180     0.150
     8.927   130.766     0.150
     8.927   231.500     0.150
     9.036   127.883     0.150
     9.198   130.281     0.150
     9.206   134.086     0.150
     9.218   130.484     0.150
     9.218   228.086     0.150
     9.218   227.383     0.150
     9.301   131.586     0.150
     9.301   230.680     0.150
     9.442   135.484     0.150
     9.600   135.680     0.150
     9.600   237.781     0.150
     9.666   136.984     0.150
     9.683   136.883     0.150
     9.683   239.180     0.150
     9.694   137.984     0.150
     9.694   275.383     0.150
     9.874   140.180     0.150
     9.874   245.680     0.150
    10.169   253.383     0.150
    10.307   146.180     0.150
    10.791   153.484     0.150
    11.447   163.086     0.150
    13.916   194.383     0.150
    17.730   250.281     0.150
    18.474   256.109     0.150
    19.494   266.383     0.150
    19.494   266.133     0.150
    20.236   272.859     0.150
    20.920   280.984     0.150
    47.270   512.734     0.150
    67.777   656.516     0.150
    73.670   692.859     0.150
    82.123   739.633     0.150
     0.507     9.764     0.150
     0.507    16.894     0.150
     0.529     9.894     0.150
     0.529    18.233     0.150
     0.743    13.093     0.150
     0.761    14.863     0.150
     0.820    15.733     0.150
     0.820    27.533     0.150
     1.043    19.514     0.150
     1.174    21.644     0.150
     1.174    37.883     0.150
     1.275    22.253     0.150
     1.421    24.913     0.150
     1.605    27.963     0.150
     1.634    28.684     0.150
     1.634    48.383     0.150
     1.648    29.333     0.150
     1.766    31.014     0.150
     1.943    31.623     0.150
     2.020    34.653     0.150
     2.115    35.463     0.150
     2.138    37.073     0.150
     2.316    39.773     0.150
     2.525    41.383     0.150
     2.887    47.063     0.150
     3.099    49.573     0.150
     3.136    50.293     0.150
     3.497    56.573     0.150
     3.788    62.233     0.150
     3.788   106.033     0.150
     4.064    63.133     0.150
     4.064   108.403     0.150
     4.275   115.793     0.150
     4.359    66.073     0.150
     4.443    67.934     0.150
     4.443   118.133     0.150
     4.828    72.233     0.150
     4.828   127.633     0.150
     4.939    73.383     0.150
     5.025    74.503     0.150
     5.881    85.833     0.150
     6.034    90.733     0.150
     6.034   159.533     0.150
     6.119    90.333     0.150
     6.119   158.133     0.150
     6.178    90.833     0.150
     6.178   160.633     0.150
     6.341    92.233     0.150
     6.387    94.133     0.150
     6.645    95.633     0.150
     7.011   100.733     0.150
     7.032   101.333     0.150
     7.032   175.934     0.150
     7.198   104.434     0.150
     7.303   105.833     0.150
     7.500   109.033     0.150
     7.500   187.934     0.150
     7.999   113.934     0.150
     8.365   119.033     0.150
     8.365   207.533     0.150
     8.741   123.833     0.150
     8.741   216.133     0.150
     9.339   131.934     0.150
     9.638   135.633     0.150
     9.638   237.934     0.150
     9.704   136.833     0.150
     0.534    10.549     0.150
     0.530    11.459     0.150
     0.530    19.999     0.150
     0.541    11.309     0.150
     0.541    20.648     0.150
     0.782    15.019     0.150
     0.782    26.078     0.150
     0.764    14.809     0.150
     0.764    27.509     0.150
     0.814    16.618     0.150
     0.865    15.698     0.150
     0.865    29.519     0.150
     1.136    20.019     0.150
     1.070    20.249     0.150
     1.262    22.448     0.150
     1.204    22.679     0.150
     1.448    27.038     0.150
     1.609    28.599     0.150
     1.623    28.818     0.150
     1.652    29.318     0.150
     1.758    30.219     0.150
     1.663    30.188     0.150
     1.848    33.089     0.150
     1.951    33.578     0.150
     2.094    36.889     0.150
     2.120    38.288     0.150
     2.043    36.099     0.150
     2.342    40.469     0.150
     2.502    42.358     0.150
     2.869    48.629     0.150
     2.797    46.519     0.150
     2.797    81.618     0.150
     2.818    46.398     0.150
     2.970    49.459     0.150
     2.970    86.318     0.150
     3.116    52.448     0.150
     3.007    49.278     0.150
     3.007    86.769     0.150
     3.168    52.419     0.150
     3.214    53.519     0.150
     3.127    50.269     0.150
     3.151    51.398     0.150
     3.253    53.229     0.150
     3.253    93.068     0.150
     3.281    52.979     0.150
     3.281    92.479     0.150
     3.344    54.288     0.150
     3.344    94.729     0.150
     3.479    58.379     0.150
     3.519    56.148     0.150
     3.711    60.259     0.150
     3.711   104.429     0.150
     3.755    59.658     0.150
     3.780    60.509     0.150
     3.766    59.738     0.150
     3.771    60.219     0.150
     3.771   104.519     0.150
     3.783    61.019     0.150
     3.783   106.019     0.150
     3.886    62.129     0.150
     3.886   108.108     0.150
     3.903    62.278     0.150
     3.903   108.519     0.150
     3.903    62.278     0.150
     3.903   108.519     0.150
     4.032    63.068     0.150
     3.971   111.198     0.150
     4.069    62.759     0.150
     4.093    66.599     0.150
     4.129    63.639     0.150
     4.129   112.589     0.150
     4.242    65.688     0.150
     4.263    65.019     0.150
     4.331    67.238     0.150
     4.331   117.129     0.150
     4.326    67.368     0.150
     4.326   116.999     0.150
     4.369    67.019     0.150
     4.369   117.318     0.150
     4.326    69.618     0.150
     4.441    68.419     0.150
     4.441   117.618     0.150
     4.452    68.288     0.150
     4.503    71.019     0.150
     4.795    73.318     0.150
     4.795   128.618     0.150
     4.811    72.719     0.150
     4.913    74.078     0.150
     5.002    76.479     0.150
     4.917    76.919     0.150
     5.103    76.629     0.150
     5.272    81.118     0.150
     5.272   139.679     0.150
     5.552    83.219     0.150
     5.552   143.719     0.150
     5.752    87.929     0.150
     5.832    89.618     0.150
     5.872    90.219     0.150
     5.797    87.719     0.150
     6.091    92.219     0.150
     6.091   160.219     0.150
     6.146    92.419     0.150
     6.146   161.919     0.150
     6.234    95.019     0.150
     6.335    93.818     0.150
     6.382    94.719     0.150
     6.633    97.919     0.150
     6.996   103.219     0.150
     6.996   176.818     0.150
     7.017   103.118     0.150
     7.017   177.019     0.150
     7.174   105.219     0.150
     7.191   108.419     0.150
     7.155   106.118     0.150
     7.291   107.019     0.150
     7.468   108.318     0.150
     7.468   190.419     0.150
     7.687   114.019     0.150
     7.982   116.719     0.150
     8.070   118.318     0.150
     8.275   120.318     0.150
     8.275   208.019     0.150
     8.344   120.618     0.150
     8.344   208.719     0.150
     8.419   122.818     0.150
     8.681   127.818     0.150
     8.681   220.719     0.150
     8.720   125.519     0.150
     8.720   218.019     0.150
     9.180   134.219     0.150
     9.180   154.519     0.150
     9.324   134.419     0.150
     9.324   233.719     0.150
     9.621   138.118     0.150
     9.621   239.618     0.150
     9.689   139.318     0.150
     9.678   139.818     0.150
     9.697   138.919     0.150
     9.900   141.719     0.150
    10.830   155.519     0.150
    19.477   269.019     0.150
    19.477   268.618     0.150
    20.887   284.669     0.150
     0.392     7.682     0.150
     0.392    13.131     0.150
     0.499     9.771     0.150
     0.499    17.531     0.150
     0.536    10.941     0.150
     0.575    10.951     0.150
     0.575    20.852     0.150
     0.743    15.092     0.150
     0.743    25.211     0.150
     0.773    14.660     0.150
     0.852    16.830     0.150
     0.852    29.160     0.150
     0.849    16.342     0.150
     0.849    28.842     0.150
     1.069    20.111     0.150
     1.196    22.701     0.150
     1.196    40.701     0.150
     1.242    23.400     0.150
     1.446    26.551     0.150
     1.575    28.150     0.150
     1.588    28.141     0.150
     1.618    28.541     0.150
     1.656    29.240     0.150
     1.734    30.961     0.150
     1.975    33.602     0.150
     2.049    36.002     0.150
     2.085    36.932     0.150
     2.106    38.262     0.150
     2.496    41.691     0.150
     2.836    46.621     0.150
     2.836    81.031     0.150
     2.856    47.852     0.150
     2.840    47.592     0.150
     2.863    45.762     0.150
     2.863    80.891     0.150
     3.009    49.561     0.150
     3.009    86.061     0.150
     3.044    49.811     0.150
     3.044    85.531     0.150
     3.105    52.070     0.150
     3.124    52.531     0.150
     3.192    52.611     0.150
     3.292    54.041     0.150
     3.292    92.320     0.150
     3.317    53.461     0.150
     3.317    91.691     0.150
     3.382    54.121     0.150
     3.382    94.211     0.150
     3.745    58.521     0.150
     3.755    59.711     0.150
     3.754    58.932     0.150
     3.750    60.861     0.150
     3.750   104.172     0.150
     3.817    61.740     0.150
     3.817   104.941     0.150
     3.925    62.391     0.150
     3.925   107.061     0.150
     3.942    62.990     0.150
     3.942   107.531     0.150
     3.942    62.990     0.150
     3.942   107.531     0.150
     4.010    63.740     0.150
     4.010   109.262     0.150
     4.048    62.451     0.150
     4.048   109.701     0.150
     4.151    63.740     0.150
     4.263    64.990     0.150
     4.263   116.631     0.150
     4.288    68.141     0.150
     4.298    68.842     0.150
     4.348    66.682     0.150
     4.348    82.240     0.150
     4.348   115.512     0.150
     4.349    66.141     0.150
     4.382    66.941     0.150
     4.382   116.842     0.150
     4.411    67.541     0.150
     4.473    68.111     0.150
     4.473   119.631     0.150
     4.535    70.541     0.150
     4.813   128.041     0.150
     4.822    73.092     0.150
     4.914    74.021     0.150
     4.954    75.541     0.150
     4.996    76.061     0.150
     5.111    76.461     0.150
     5.573    82.842     0.150
     5.573   147.541     0.150
     5.848    87.740     0.150
     6.162    91.842     0.150
     6.162   161.842     0.150
     6.309    93.541     0.150
     6.354    93.842     0.150
     6.612    98.041     0.150
     6.695   100.740     0.150
     6.695   113.740     0.150
     6.978   101.941     0.150
     6.999   102.141     0.150
     7.166   104.941     0.150
     7.270   108.041     0.150
     7.483   108.541     0.150
     7.483   189.740     0.150
     7.968   115.441     0.150
     8.047   117.740     0.150
     8.293   212.041     0.150
     8.336   118.641     0.150
     8.336   207.441     0.150
     8.392   122.041     0.150
     8.712   123.941     0.150
     8.712   215.541     0.150
     9.196   153.342     0.150
     9.218   261.541     0.150
     9.450   135.842     0.150
     9.606   138.342     0.150
     9.606   239.141     0.150
     9.687   241.041     0.150
     0.405     7.734     0.150
     0.405    13.914     0.150
     0.516     9.797     0.150
     0.516    17.465     0.150
     0.515     9.996     0.150
     0.558     9.914     0.150
     0.558    18.734     0.150
     0.752    26.027     0.150
     0.833    16.117     0.150
     0.833    28.215     0.150
     0.836    16.664     0.150
     1.049    19.996     0.150
     1.049    35.754     0.150
     1.178    22.516     0.150
     1.178    39.816     0.150
     1.263    23.336     0.150
     1.426    25.367     0.150
     1.426    45.527     0.150
     1.638    28.824     0.150
     1.638    51.555     0.150
     1.754    31.316     0.150
     1.955    32.137     0.150
     2.028    34.637     0.150
     2.106    36.594     0.150
     2.323    39.375     0.150
     2.517    41.336     0.150
     2.876    45.297     0.150
     2.876    80.234     0.150
     4.063    64.664     0.150
     4.063   109.367     0.150
     4.298    73.117     0.150
     4.430    67.617     0.150
     5.869    88.414     0.150
     6.374    94.117     0.150
     6.633    96.914     0.150
     7.000   101.617     0.150
     7.021   101.816     0.150
     7.021   179.016     0.150
     7.989   115.215     0.150
     8.357   118.215     0.150
     8.357   208.516     0.150
     8.733   122.715     0.150
     8.733   217.316     0.150
     9.328   235.715     0.150
     9.627   241.414     0.150
     0.394     7.461     0.150
     0.394    13.500     0.150
     0.498     9.590     0.150
     0.498    17.531     0.150
     0.544    10.641     0.150
     0.747    14.910     0.150
     0.781    14.551     0.150
     0.850    15.680     0.150
     0.850    29.180     0.150
     0.862    16.781     0.150
     1.078    20.062     0.150
     1.078    37.711     0.150
     1.206    22.859     0.150
     1.206    40.730     0.150
     1.455    26.223     0.150
     1.574    28.012     0.150
     1.666    29.121     0.150
     1.666    52.453     0.150
     1.729    30.922     0.150
     1.980    32.812     0.150
     2.057    36.000     0.150
     2.352    40.562     0.150
     2.488    40.660     0.150
     2.853    45.781     0.150
     2.853    80.152     0.150
     3.144    50.812     0.150
     4.038    61.941     0.150
     4.038   108.781     0.150
     4.141   111.762     0.150
     4.254    65.020     0.150
     4.254   113.582     0.150
     4.278    73.582     0.150
     4.338   115.680     0.150
     4.408    67.582     0.150
     4.464    69.621     0.150
     4.464   118.941     0.150
     4.803    72.883     0.150
     4.803   124.582     0.150
     4.904    73.461     0.150
     5.843    87.781     0.150
     5.901    88.480     0.150
     6.140    91.281     0.150
     6.152    91.383     0.150
     6.152   161.281     0.150
     6.186    92.383     0.150
     6.351    93.680     0.150
     6.607    98.781     0.150
     6.614    98.480     0.150
     6.874   101.781     0.150
     6.902   102.480     0.150
     6.972   101.281     0.150
     6.977   103.582     0.150
     6.993   102.082     0.150
     7.161   106.883     0.150
     7.473   108.980     0.150
     7.473   188.781     0.150
     7.961   114.781     0.150
     8.042   118.281     0.150
     8.283   207.281     0.150
     8.327   118.781     0.150
     8.327   209.281     0.150
     8.683   219.281     0.150
     8.704   124.383     0.150
     8.704   217.680     0.150
     9.599   137.082     0.150
     9.599   241.180     0.150
     9.679   243.082     0.150
     0.556    10.906     0.150
     0.556    18.367     0.150
     0.518     9.945     0.150
     0.518    19.438     0.150
     0.495    10.156     0.150
     0.495    17.469     0.150
     0.787    16.227     0.150
     0.787    27.195     0.150
     0.728    14.008     0.150
     0.728    24.547     0.150
     0.793    15.500     0.150
     0.793    27.102     0.150
     0.835    15.086     0.150
     1.035    19.469     0.150
     1.035    35.547     0.150
     1.171    21.797     0.150
     1.414    26.031     0.150
     1.632    29.305     0.150
     1.645    29.297     0.150
     1.675    30.102     0.150
     1.630    29.242     0.150
     1.789    31.711     0.150
     1.814    32.086     0.150
     1.920    32.578     0.150
     2.130    36.695     0.150
     2.008    35.461     0.150
     2.537    42.055     0.150
     2.872    46.039     0.150
     2.872    80.875     0.150
     2.784    46.602     0.150
     2.784    79.695     0.150
     2.904    48.258     0.150
     2.786    45.500     0.150
     2.962    49.867     0.150
     2.962    85.109     0.150
     2.991    48.766     0.150
     2.991    84.102     0.150
     3.198    52.711     0.150
     3.094    49.891     0.150
     3.242    52.711     0.150
     3.242    91.195     0.150
     3.262    52.430     0.150
     3.262    90.047     0.150
     3.330    53.695     0.150
     3.330    92.859     0.150
     3.704    60.195     0.150
     3.704   103.305     0.150
     3.747    65.898     0.150
     3.722    58.945     0.150
     3.735    58.570     0.150
     3.872    61.609     0.150
     3.872   106.000     0.150
     3.892    62.055     0.150
     3.892   106.711     0.150
     3.892    62.055     0.150
     3.892   106.711     0.150
     4.061    62.539     0.150
     4.061   109.289     0.150
     4.100    63.031     0.150
     4.154    64.672     0.150
     4.154   112.711     0.150
     4.268    66.031     0.150
     4.268   114.445     0.150
     4.286    65.695     0.150
     4.286   114.297     0.150
     4.351    67.156     0.150
     4.351   116.898     0.150
     4.360   117.336     0.150
     4.400    67.000     0.150
     4.400    69.398     0.150
     4.400   117.195     0.150
     4.477    68.711     0.150
     4.477   119.070     0.150
     4.468    69.297     0.150
     4.468   119.000     0.150
     4.824    73.297     0.150
     4.824   129.102     0.150
     4.843    73.492     0.150
     4.947    74.000     0.150
     4.898    75.602     0.150
     5.037    75.938     0.150
     5.135    77.039     0.150
     5.883    88.297     0.150
     5.775    86.398     0.150
     5.903    89.500     0.150
     5.948    89.695     0.150
     5.985    87.695     0.150
     6.090    89.859     0.150
     6.175    91.797     0.150
     6.175   161.195     0.150
     6.190    92.398     0.150
     6.234    93.602     0.150
     6.125    92.398     0.150
     6.365    94.500     0.150
     6.245    94.398     0.150
     6.411    95.000     0.150
     6.543    96.000     0.150
     6.666    99.195     0.150
     6.691   110.500     0.150
     6.691   170.500     0.150
     6.618    98.898     0.150
     7.007   103.195     0.150
     7.030   101.000     0.150
     7.030   180.102     0.150
     7.051   180.398     0.150
     6.948   103.898     0.150
     7.195   106.102     0.150
     7.169   106.867     0.150
     7.222   108.602     0.150
     7.324   108.000     0.150
     7.352   109.398     0.150
     7.498   109.398     0.150
     7.498   125.898     0.150
     7.498   190.297     0.150
     8.017   115.898     0.150
     8.141   115.781     0.150
     8.303   208.102     0.150
     8.296   124.695     0.150
     8.379   120.000     0.150
     8.379   210.195     0.150
     8.310   122.398     0.150
     8.712   219.297     0.150
     8.756   125.000     0.150
     8.756   218.500     0.150
     8.872   132.195     0.150
     9.239   232.000     0.150
     9.358   134.000     0.150
     9.358   236.398     0.150
     9.656   138.195     0.150
     9.656   241.500     0.150
     9.637   142.125     0.150
     9.732   139.297     0.150
     9.732   243.195     0.150
     9.946   142.891     0.150
    11.864   169.195     0.150
    18.303   258.672     0.150
    20.908   282.867     0.150
    47.216   514.148     0.150
    73.607   693.789     0.150
     0.508     9.406     0.150
     0.492    10.055     0.150
     0.492    17.578     0.150
     0.566    10.617     0.150
     0.566    20.133     0.150
     0.724    13.578     0.150
     0.724    24.859     0.150
     0.782    15.516     0.150
     0.782    26.719     0.150
     0.798    15.695     0.150
     0.837    15.125     0.150
     0.837    28.578     0.150
     1.034    19.234     0.150
     1.172    21.469     0.150
     1.302    22.828     0.150
     1.413    25.578     0.150
     1.642    28.992     0.150
     1.655    29.117     0.150
     1.685    29.516     0.150
     1.630    28.914     0.150
     1.797    31.875     0.150
     1.912    32.336     0.150
     2.004    34.609     0.150
     2.134    36.195     0.150
     2.541    41.789     0.150
     2.773    46.062     0.150
     2.773    78.383     0.150
     2.868    45.836     0.150
     2.868    80.297     0.150
     2.778    45.414     0.150
     2.909    47.672     0.150
     2.951    49.078     0.150
     2.951    83.508     0.150
     2.980    48.578     0.150
     2.980    82.578     0.150
     3.156    51.625     0.150
     3.093    49.328     0.150
     3.208    52.289     0.150
     3.232    52.648     0.150
     3.232    89.812     0.150
     3.254    53.336     0.150
     3.251    51.953     0.150
     3.251    88.594     0.150
     3.319    53.312     0.150
     3.319    91.078     0.150
     3.489    53.875     0.150
     3.694    59.492     0.150
     3.694   101.648     0.150
     3.818    59.062     0.150
     3.723    58.375     0.150
     3.737    58.453     0.150
     3.762    59.797     0.150
     3.861    61.094     0.150
     3.861   104.344     0.150
     3.881    61.492     0.150
     3.881   105.109     0.150
     3.881    61.492     0.150
     3.881   105.109     0.150
     4.059    62.062     0.150
     4.150    63.492     0.150
     4.150   111.109     0.150
     4.143    65.117     0.150
     4.143   112.812     0.150
     4.281    67.516     0.150
     4.281   113.312     0.150
     4.347    66.766     0.150
     4.357   116.516     0.150
     4.398    66.719     0.150
     4.398   116.312     0.150
     4.473    67.844     0.150
     4.477    68.719     0.150
     4.477   118.117     0.150
     4.438    68.336     0.150
     4.821    72.719     0.150
     4.821   126.617     0.150
     4.842    72.883     0.150
     4.949    73.406     0.150
     4.949   128.078     0.150
     5.041    75.305     0.150
     5.135    76.469     0.150
     5.789    87.688     0.150
     5.911    89.016     0.150
     6.172    91.414     0.150
     6.172   160.516     0.150
     6.374    94.617     0.150
     6.420    95.016     0.150
     6.673    99.312     0.150
     7.036   179.414     0.150
     7.057   180.016     0.150
     7.331   108.516     0.150
     7.496   108.617     0.150
     7.496   123.016     0.150
     7.496   189.117     0.150
     8.022   114.812     0.150
     8.300   208.016     0.150
     8.383   120.016     0.150
     8.383   210.719     0.150
     8.760   124.719     0.150
     8.760   218.719     0.150
     9.662   242.812     0.150
    20.902   283.766     0.150
    47.206   514.258     0.150
     0.541    11.540     0.150
     0.541    18.889     0.150
     0.574    11.699     0.150
     0.574    19.990     0.150
     0.748    15.800     0.150
     0.777    14.919     0.150
     0.777    26.459     0.150
     0.847    16.139     0.150
     0.859    15.990     0.150
     1.107    20.129     0.150
     1.075    20.899     0.150
     1.075    35.510     0.150
     1.239    22.869     0.150
     1.203    23.379     0.150
     1.452    27.209     0.150
     1.576    28.709     0.150
     1.590    28.740     0.150
     1.619    29.040     0.150
     1.732    31.709     0.150
     1.663    29.840     0.150
     1.868    32.850     0.150
     1.977    33.639     0.150
     2.081    36.949     0.150
     2.102    38.129     0.150
     2.349    40.929     0.150
     2.491    42.490     0.150
     2.852    47.659     0.150
     2.855    46.479     0.150
     2.855    81.320     0.150
     2.832    46.959     0.150
     2.832    82.010     0.150
     2.842    46.340     0.150
     3.004    50.729     0.150
     3.004    87.119     0.150
     3.101    52.159     0.150
     3.041    50.340     0.150
     3.041    86.280     0.150
     3.147    52.179     0.150
     3.147    51.919     0.150
     3.190    52.560     0.150
     3.130    50.110     0.150
     3.140    51.209     0.150
     3.300    54.770     0.150
     3.288    54.119     0.150
     3.288    93.530     0.150
     3.315    53.520     0.150
     3.315    91.659     0.150
     3.379    54.719     0.150
     3.379    94.119     0.150
     3.462    56.840     0.150
     3.514    56.000     0.150
     3.752    61.360     0.150
     3.745    61.479     0.150
     3.745   105.290     0.150
     3.715    58.830     0.150
     3.752    59.449     0.150
     3.763    60.409     0.150
     3.761    59.580     0.150
     3.803    60.340     0.150
     3.803   105.240     0.150
     3.816    60.540     0.150
     3.816   104.740     0.150
     3.896    62.250     0.150
     3.927    63.040     0.150
     3.921    62.979     0.150
     3.921   107.639     0.150
     3.938    63.669     0.150
     3.938   108.860     0.150
     3.938    63.669     0.150
     3.938   108.860     0.150
     3.962    71.240     0.150
     4.004    63.369     0.150
     4.004   107.330     0.150
     4.073    62.760     0.150
     4.026    67.290     0.150
     4.026   113.729     0.150
     4.076    65.159     0.150
     4.048    61.429     0.150
     4.208    66.939     0.150
     4.208   114.939     0.150
     4.329    68.280     0.150
     4.341    67.340     0.150
     4.341    84.740     0.150
     4.341   115.740     0.150
     4.275    66.740     0.150
     4.375    67.139     0.150
     4.375   117.240     0.150
     4.334    71.240     0.150
     4.334   137.740     0.150
     4.411    68.540     0.150
     4.411   116.840     0.150
     4.457    70.310     0.150
     4.524    70.869     0.150
     4.456    70.050     0.150
     4.534    70.740     0.150
     4.695    70.449     0.150
     4.695   124.360     0.150
     4.805    73.040     0.150
     4.805   128.939     0.150
     4.815    73.100     0.150
     4.723    73.709     0.150
     4.908    74.040     0.150
     4.991    75.570     0.150
     4.951    76.639     0.150
     4.951    94.740     0.150
     4.951   135.939     0.150
     5.065    78.369     0.150
     5.104    76.790     0.150
     5.027    77.679     0.150
     5.027   133.679     0.150
     5.020    77.740     0.150
     5.160   100.240     0.150
     5.307    81.119     0.150
     5.307   140.360     0.150
     5.396    82.310     0.150
     5.459    83.790     0.150
     5.375    82.280     0.150
     5.440    83.740     0.150
     5.552    85.699     0.150
     5.565    83.340     0.150
     5.565   148.639     0.150
     5.658    86.740     0.150
     5.705    87.850     0.150
     5.706    87.979     0.150
     5.743    86.750     0.150
     5.663    85.740     0.150
     5.777    86.840     0.150
     5.838    87.840     0.150
     5.846    88.240     0.150
     5.904    89.139     0.150
     5.830    87.740     0.150
     5.935    87.340     0.150
     5.985    91.909     0.150
     6.040    89.209     0.150
     6.055    92.649     0.150
     6.055    92.110     0.150
     6.086    91.740     0.150
     6.086   162.340     0.150
     6.088    91.939     0.150
     6.088   161.939     0.150
     6.028    90.800     0.150
     6.028   157.800     0.150
     6.024    92.240     0.150
     6.144    92.139     0.150
     6.155    92.540     0.150
     6.155   163.040     0.150
     6.095    91.560     0.150
     6.189    93.939     0.150
     6.209    94.479     0.150
     6.231    94.139     0.150
     6.231   165.139     0.150
     6.178    93.740     0.150
     6.295    95.240     0.150
     6.239    93.000     0.150
     6.308    94.139     0.150
     6.320    92.619     0.150
     6.323    92.840     0.150
     6.344    95.240     0.150
     6.354    94.639     0.150
     6.296    95.240     0.150
     6.390    93.560     0.150
     6.330    96.280     0.150
     6.330   166.760     0.150
     6.494    95.840     0.150
     6.485   101.139     0.150
     6.516    95.040     0.150
     6.490    97.080     0.150
     6.602    98.840     0.150
     6.602   173.439     0.150
     6.611    99.540     0.150
     6.617    99.040     0.150
     6.610    99.340     0.150
     6.680   100.219     0.150
     6.724    98.010     0.150
     6.655    99.240     0.150
     6.673   100.240     0.150
     6.758   102.040     0.150
     6.877   102.139     0.150
     6.791   100.879     0.150
     6.889   104.139     0.150
     6.889   174.340     0.150
     6.906   101.639     0.150
     6.911   102.040     0.150
     6.837   102.240     0.150
     6.958   102.240     0.150
     6.975   102.439     0.150
     6.975   177.139     0.150
     6.981   102.540     0.150
     6.996   102.639     0.150
     6.996   178.540     0.150
     6.951   102.679     0.150
     7.049   103.939     0.150
     6.999   105.240     0.150
     7.098   105.040     0.150
     7.062   104.520     0.150
     7.143   105.439     0.150
     7.162   105.540     0.150
     7.164   107.439     0.150
     7.194   106.939     0.150
     7.180   106.119     0.150
     7.117   106.740     0.150
     7.233   109.040     0.150
     7.268   108.939     0.150
     7.321   108.040     0.150
     7.475   109.240     0.150
     7.475   190.439     0.150
     7.406   110.740     0.150
     7.487   111.740     0.150
     7.533   110.540     0.150
     7.587   110.340     0.150
     7.695   113.939     0.150
     7.703   114.679     0.150
     7.703   198.600     0.150
     7.703   244.419     0.150
     7.767   113.240     0.150
     7.793   115.240     0.150
     7.964   116.240     0.150
     7.964   202.639     0.150
     7.932   116.240     0.150
     8.025   116.040     0.150
     8.045   118.139     0.150
     8.060   117.439     0.150
     8.060   204.439     0.150
     7.980   116.679     0.150
     8.029   120.240     0.150
     8.222   118.439     0.150
     8.285   120.340     0.150
     8.285   207.639     0.150
     8.291   123.209     0.150
     8.331   119.740     0.150
     8.331   208.740     0.150
     8.372   122.040     0.150
     8.372   209.040     0.150
     8.372   122.040     0.150
     8.372   209.040     0.150
     8.391   123.240     0.150
     8.456   126.439     0.150
     8.474   121.939     0.150
     8.397   124.240     0.150
     8.535   122.740     0.150
     8.686   125.939     0.150
     8.686   219.040     0.150
     8.695   127.139     0.150
     8.707   125.340     0.150
     8.707   217.040     0.150
     8.707   130.540     0.150
     8.718   126.639     0.150
     8.789   128.240     0.150
     8.912   133.199     0.150
     9.035   129.439     0.150
     9.189   132.040     0.150
     9.189   154.639     0.150
     9.194   133.540     0.150
     9.194   137.740     0.150
     9.189   136.040     0.150
     9.211   132.340     0.150
     9.211   230.240     0.150
     9.211   229.740     0.150
     9.260   135.399     0.150
     9.304   133.639     0.150
     9.304   233.439     0.150
     9.319   136.290     0.150
     9.450   137.540     0.150
     9.599   138.740     0.150
     9.599   239.840     0.150
     9.602   137.540     0.150
     9.602   239.840     0.150
     9.669   138.939     0.150
     9.652   144.439     0.150
     9.683   139.139     0.150
     9.683   241.240     0.150
     9.685   139.740     0.150
     9.666   140.740     0.150
     9.839   143.439     0.150
     9.878   142.340     0.150
     9.878   247.939     0.150
     9.999   143.240     0.150
    10.173   147.439     0.150
    10.173   253.439     0.150
    10.800   156.240     0.150
    10.900   269.939     0.150
    11.147   158.840     0.150
    11.326   163.740     0.150
    12.172   171.949     0.150
    12.875   183.340     0.150
    13.517   194.010     0.150
    14.398   206.000     0.150
    14.398   203.177     0.150
    15.275   222.580     0.150
    15.348   223.139     0.150
    15.893   229.159     0.150
    15.908   228.899     0.150
    15.994   226.800     0.150
    16.918   238.129     0.150
    18.464   256.221     0.150
    18.480   260.330     0.150
    19.315   266.330     0.150
    19.485   267.619     0.150
    19.595   269.439     0.150
    20.232   280.439     0.150
    20.232   276.500     0.150
    20.907   282.840     0.150
    28.447   355.949     0.150
    31.607   383.340     0.150
    37.547   436.090     0.150
    38.307   441.729     0.150
    38.307   443.639     0.150
    38.446   444.770     0.150
    39.118   450.740     0.150
    39.266   449.840     0.150
    39.504   451.740     0.150
    46.675   512.889     0.150
    47.255   515.014     0.150
    47.231   518.729     0.150
    64.638   636.740     0.150
    70.227   673.369     0.150
    82.122   741.689     0.150
     0.515     9.910     0.150
     0.527    11.029     0.150
     0.560    10.990     0.150
     0.560    20.979     0.150
     0.756    14.010     0.150
     0.756    26.300     0.150
     0.763    14.979     0.150
     0.834    16.260     0.150
     0.834    28.760     0.150
     0.850    15.319     0.150
     1.063    20.189     0.150
     1.193    22.710     0.150
     1.440    26.620     0.150
     1.590    27.710     0.150
     1.604    28.160     0.150
     1.633    28.560     0.150
     1.652    29.420     0.150
     1.747    31.270     0.150
     1.854    32.370     0.150
     1.962    33.060     0.150
     2.094    36.460     0.150
     2.040    35.590     0.150
     2.336    40.180     0.150
     2.505    42.040     0.150
     2.862    46.640     0.150
     2.862    81.100     0.150
     2.821    46.550     0.150
     2.821    79.140     0.150
     2.827    45.779     0.150
     2.995    84.790     0.150
     3.029    49.189     0.150
     3.029    83.260     0.150
     3.162    51.370     0.150
     3.119    50.000     0.150
     3.277    53.300     0.150
     3.277    90.850     0.150
     3.302    52.550     0.150
     3.302    89.040     0.150
     3.367    54.010     0.150
     3.367    91.700     0.150
     3.505    55.279     0.150
     3.736    60.819     0.150
     3.736   102.840     0.150
     3.743    58.649     0.150
     3.759    59.720     0.150
     3.752    58.970     0.150
     3.802    62.260     0.150
     3.802   108.260     0.150
     3.806    60.080     0.150
     3.930    63.960     0.150
     3.930   128.760     0.150
     3.910    62.109     0.150
     3.910   105.290     0.150
     3.928    62.649     0.150
     3.928   105.870     0.150
     3.928    62.649     0.150
     3.928   105.870     0.150
     3.997    63.189     0.150
     3.997   109.310     0.150
     4.194    66.359     0.150
     4.194   115.359     0.150
     4.284    65.760     0.150
     4.348    66.859     0.150
     4.348    80.760     0.150
     4.348   115.760     0.150
     4.260    66.260     0.150
     4.384    66.460     0.150
     4.384   116.760     0.150
     4.426    68.160     0.150
     4.448    69.750     0.150
     4.520    71.060     0.150
     4.520    79.359     0.150
     4.520    88.160     0.150
     4.520   120.760     0.150
     4.520   132.060     0.150
     4.812    72.260     0.150
     4.812   128.460     0.150
     4.824    72.399     0.150
     4.920    73.740     0.150
     4.938    78.060     0.150
     4.938   132.260     0.150
     5.004    75.500     0.150
     5.012   132.140     0.150
     5.005    76.760     0.150
     5.114    76.189     0.150
     5.295    80.910     0.150
     5.295   139.410     0.150
     5.571    82.660     0.150
     5.571   148.560     0.150
     5.648    85.260     0.150
     5.756    86.410     0.150
     5.789    86.260     0.150
     5.851    87.560     0.150
     5.862    87.960     0.150
     5.816    87.260     0.150
     5.917    89.660     0.150
     5.949    87.160     0.150
     6.054    89.660     0.150
     6.097    92.160     0.150
     6.097   162.260     0.150
     6.099    91.560     0.150
     6.099   159.660     0.150
     6.157    91.960     0.150
     6.162    91.460     0.150
     6.162   160.260     0.150
     6.202    93.859     0.150
     6.242    93.859     0.150
     6.242   164.560     0.150
     6.283    93.960     0.150
     6.323    93.359     0.150
     6.335    93.470     0.150
     6.369    93.760     0.150
     6.508    95.859     0.150
     6.625    98.859     0.150
     6.690   100.060     0.150
     6.690   109.359     0.150
     6.891   101.960     0.150
     6.919   102.760     0.150
     6.972   102.460     0.150
     6.990   101.760     0.150
     6.995   104.060     0.150
     7.011   102.660     0.150
     7.179   107.260     0.150
     7.283   108.859     0.150
     7.484   108.359     0.150
     7.484   188.859     0.150
     7.979   114.760     0.150
     7.979   200.960     0.150
     8.072   118.760     0.150
     8.072   204.760     0.150
     8.292   119.359     0.150
     8.344   119.260     0.150
     8.344   210.160     0.150
     8.406   123.359     0.150
     8.695   219.960     0.150
     8.721   124.859     0.150
     8.721   217.260     0.150
     9.196   132.260     0.150
     9.220   131.760     0.150
     9.220   229.460     0.150
     9.220   229.260     0.150
     9.319   133.359     0.150
     9.617   137.460     0.150
     9.617   241.060     0.150
     9.684   137.960     0.150
     9.693   139.260     0.150
     9.693   248.260     0.150
    10.839   154.260     0.150
     0.425     8.160     0.150
     0.425    14.820     0.150
     0.531    10.211     0.150
     0.531    18.742     0.150
     0.522    10.352     0.150
     0.544    10.113     0.150
     0.544    18.602     0.150
     0.757    13.973     0.150
     0.757    25.703     0.150
     0.774    16.281     0.150
     0.817    16.203     0.150
     0.817    28.402     0.150
     0.854    16.312     0.150
     0.854    28.312     0.150
     1.061    19.891     0.150
     1.061    34.980     0.150
     1.194    22.480     0.150
     1.194    40.891     0.150
     1.265    23.402     0.150
     1.439    25.941     0.150
     1.653    29.051     0.150
     1.653    51.660     0.150
     1.760    31.262     0.150
     1.949    32.113     0.150
     2.035    35.133     0.150
     2.101    36.660     0.150
     2.125    34.840     0.150
     2.333    40.352     0.150
     2.510    41.711     0.150
     2.803    46.371     0.150
     2.803    80.453     0.150
     2.856    45.461     0.150
     2.856    80.301     0.150
     2.875    47.031     0.150
     2.977    48.652     0.150
     2.977    83.902     0.150
     3.012    49.582     0.150
     3.012    85.582     0.150
     3.122    51.773     0.150
     3.260    52.340     0.150
     3.260    90.992     0.150
     3.285    92.750     0.150
     3.350    53.922     0.150
     3.350    93.621     0.150
     3.719    58.773     0.150
     3.719   101.742     0.150
     3.786    62.102     0.150
     3.786   103.102     0.150
     3.892    62.051     0.150
     3.892   106.953     0.150
     3.910    61.922     0.150
     3.910   106.750     0.150
     3.910    61.922     0.150
     3.910   106.750     0.150
     4.275    65.203     0.150
     4.314    68.973     0.150
     4.380    66.000     0.150
     4.380   115.902     0.150
     4.440    68.000     0.150
     4.807    72.301     0.150
     4.807   125.801     0.150
     4.922   128.211     0.150
     5.113    76.340     0.150
     5.874    88.203     0.150
     6.100    92.102     0.150
     6.100   161.602     0.150
     6.157    91.301     0.150
     6.157   160.000     0.150
     6.336    94.102     0.150
     6.383    94.203     0.150
     6.636    98.703     0.150
     7.000   101.301     0.150
     7.193   107.301     0.150
     7.987   115.102     0.150
     8.351   118.902     0.150
     8.351   209.500     0.150
     8.727   124.203     0.150
     8.727   217.902     0.150
     9.328   132.602     0.150
     9.479   136.801     0.150
     9.626   241.301     0.150
     0.509     9.641     0.150
     0.509    16.680     0.150
     0.461     9.633     0.150
     0.461    17.602     0.150
     0.488    10.359     0.150
     0.615    11.703     0.150
     0.715    13.500     0.150
     0.733    15.531     0.150
     0.852    16.719     0.150
     0.858    15.508     0.150
     1.037    18.625     0.150
     1.214    21.633     0.150
     1.184    21.250     0.150
     1.184    40.773     0.150
     1.332    24.555     0.150
     1.418    25.750     0.150
     1.690    30.242     0.150
     1.704    29.734     0.150
     1.733    30.930     0.150
     1.639    29.273     0.150
     1.833    32.781     0.150
     1.878    31.953     0.150
     1.996    35.070     0.150
     2.149    36.859     0.150
     2.304    39.969     0.150
     2.552    42.438     0.150
     2.719    44.883     0.150
     2.719    77.242     0.150
     2.845    48.992     0.150
     2.845    80.930     0.150
     2.747    45.211     0.150
     2.896    47.648     0.150
     2.896    81.500     0.150
     2.927    47.930     0.150
     2.927    81.641     0.150
     3.177    51.414     0.150
     3.177    88.438     0.150
     3.200    51.758     0.150
     3.200    88.555     0.150
     3.266    52.648     0.150
     3.266    90.305     0.150
     3.639    58.414     0.150
     3.639    99.594     0.150
     3.690    59.234     0.150
     3.808    60.602     0.150
     3.808   103.305     0.150
     3.827    60.930     0.150
     3.827   103.578     0.150
     3.827    60.930     0.150
     3.827   103.578     0.150
     3.886    62.234     0.150
     3.886   106.359     0.150
     4.093    64.828     0.150
     4.093   110.531     0.150
     4.249    66.430     0.150
     4.249   113.633     0.150
     4.336    68.031     0.150
     4.336    83.531     0.150
     4.336   115.633     0.150
     4.382    66.734     0.150
     4.382   116.734     0.150
     4.520    69.234     0.150
     4.520   121.031     0.150
     4.799    73.234     0.150
     4.799   126.828     0.150
     5.545    82.633     0.150
     5.545   144.234     0.150
     5.894    88.328     0.150
     5.946    89.133     0.150
     5.946   112.531     0.150
     5.946   154.430     0.150
     6.005    87.828     0.150
     6.118    92.633     0.150
     6.118   158.828     0.150
     6.124    92.133     0.150
     6.124   162.328     0.150
     6.151    91.828     0.150
     6.151   161.633     0.150
     6.204    92.430     0.150
     6.243    94.430     0.150
     6.268    94.430     0.150
     6.268   167.531     0.150
     6.411    95.133     0.150
     6.459    95.234     0.150
     6.561    96.133     0.150
     6.651   100.328     0.150
     6.666   100.234     0.150
     6.678    99.633     0.150
     6.651    97.133     0.150
     6.703    99.930     0.150
     6.970   103.133     0.150
     7.025   103.734     0.150
     7.062   102.734     0.150
     7.062   133.234     0.150
     7.062   178.430     0.150
     7.083   103.234     0.150
     7.083   180.828     0.150
     7.114   104.828     0.150
     7.219   106.734     0.150
     7.266   106.633     0.150
     7.362   107.234     0.150
     7.478   108.133     0.150
     7.478   189.531     0.150
     7.656   111.328     0.150
     8.043   115.930     0.150
     8.142   117.633     0.150
     8.277   119.328     0.150
     8.277   207.430     0.150
     8.396   120.328     0.150
     8.396   210.133     0.150
     8.394   208.031     0.150
     8.394   208.031     0.150
     8.416   214.328     0.150
     8.495   122.430     0.150
     8.695   221.328     0.150
     8.684   223.734     0.150
     8.773   125.430     0.150
     8.773   220.734     0.150
     9.226   133.133     0.150
     9.226   231.031     0.150
     9.390   133.930     0.150
     9.390   175.734     0.150
     9.390   235.430     0.150
     9.684   139.133     0.150
     9.684   241.133     0.150
     9.688   139.133     0.150
     9.751   139.531     0.150
     9.751   243.133     0.150
     9.755   139.234     0.150
     9.967   142.031     0.150
     9.967   186.930     0.150
    10.265   147.734     0.150
    10.411   148.430     0.150
    11.209   158.234     0.150
    12.957   182.734     0.150
     0.272     5.629     0.150
     0.272     9.188     0.150
     0.401     7.547     0.150
     0.401    13.746     0.150
     0.456     8.668     0.150
     0.456    16.039     0.150
     0.514     9.598     0.150
     0.514    17.477     0.150
     0.511     9.758     0.150
     0.520     9.488     0.150
     0.560     9.477     0.150
     0.560    18.348     0.150
     0.561    10.719     0.150
     0.561    17.969     0.150
     0.744    25.488     0.150
     0.829    16.520     0.150
     0.829    27.777     0.150
     0.836    15.707     0.150
     0.836    27.809     0.150
     1.044    19.039     0.150
     1.127    19.148     0.150
     1.127    35.117     0.150
     1.172    22.297     0.150
     1.265    23.688     0.150
     1.265    40.477     0.150
     1.421    25.258     0.150
     1.590    28.539     0.150
     1.632    28.469     0.150
     1.632    50.887     0.150
     1.723    30.098     0.150
     1.755    30.559     0.150
     1.954    31.699     0.150
     1.954    57.277     0.150
     2.024    34.398     0.150
     2.110    35.367     0.150
     2.130    36.648     0.150
     2.521    40.828     0.150
     2.828    45.789     0.150
     2.828    78.109     0.150
     2.881    46.699     0.150
     2.883    45.086     0.150
     2.883    79.359     0.150
     3.005    48.977     0.150
     3.005    82.629     0.150
     3.035    48.906     0.150
     3.035    82.930     0.150
     3.130    50.770     0.150
     3.174    50.609     0.150
     3.175    51.078     0.150
     3.286    52.859     0.150
     3.286    89.609     0.150
     3.305    52.738     0.150
     3.305    89.367     0.150
     3.374    53.656     0.150
     3.374    91.066     0.150
     3.747    59.418     0.150
     3.747   100.988     0.150
     3.916    61.270     0.150
     3.916   104.707     0.150
     3.936    61.777     0.150
     3.936   104.906     0.150
     3.936    61.777     0.150
     3.936   104.906     0.150
     4.251    65.406     0.150
     4.369    68.207     0.150
     4.369   113.008     0.150
     4.405    68.406     0.150
     4.405   115.609     0.150
     4.430    67.508     0.150
     4.938    72.469     0.150
     4.998    75.508     0.150
     5.636    84.008     0.150
     6.000    90.008     0.150
     6.035    91.609     0.150
     6.035   159.309     0.150
     6.117    91.609     0.150
     6.183    91.707     0.150
     6.183   161.008     0.150
     6.262    91.809     0.150
     6.262   161.207     0.150
     6.329    92.109     0.150
     6.374    92.508     0.150
     6.632    99.809     0.150
     6.632   175.109     0.150
     7.002   100.508     0.150
     7.023   100.809     0.150
     7.023   179.508     0.150
     7.505   120.008     0.150
     7.505   188.008     0.150
     7.992   113.707     0.150
     8.360   118.309     0.150
     8.360   209.508     0.150
     8.413   120.609     0.150
     8.736   123.406     0.150
     8.736   218.207     0.150
     9.330   131.809     0.150
     9.630   136.109     0.150
     9.630   240.008     0.150
     0.425     8.418     0.150
     0.425    13.586     0.150
     0.480     9.586     0.150
     0.480    15.625     0.150
     0.533    10.496     0.150
     0.533    18.086     0.150
     0.518    10.785     0.150
     0.518    19.695     0.150
     0.548    10.328     0.150
     0.548    17.016     0.150
     0.542    10.527     0.150
     0.542    18.848     0.150
     0.581    11.387     0.150
     0.581    18.617     0.150
     0.773    14.809     0.150
     0.773    26.969     0.150
     0.753    14.086     0.150
     0.816    16.598     0.150
     0.816    28.297     0.150
     0.849    15.105     0.150
     1.056    19.516     0.150
     1.189    22.117     0.150
     1.434    26.676     0.150
     1.608    28.438     0.150
     1.648    29.695     0.150
     1.763    31.719     0.150
     1.946    33.059     0.150
     2.031    35.746     0.150
     2.105    36.918     0.150
     2.129    37.875     0.150
     2.329    40.098     0.150
     2.514    41.887     0.150
     2.803    47.277     0.150
     2.803    79.066     0.150
     2.812    46.367     0.150
     2.879    47.906     0.150
     2.860    46.238     0.150
     2.860    80.887     0.150
     2.978    50.285     0.150
     2.978    84.367     0.150
     3.011    49.586     0.150
     3.011    83.387     0.150
     3.126    52.066     0.150
     3.113    50.988     0.150
     3.173    52.637     0.150
     3.176    52.008     0.150
     3.260    53.977     0.150
     3.260    90.496     0.150
     3.284    53.398     0.150
     3.284    89.238     0.150
     3.350    54.426     0.150
     3.350    91.727     0.150
     3.719    60.867     0.150
     3.719   102.418     0.150
     3.740    58.848     0.150
     3.892    62.168     0.150
     3.892   105.047     0.150
     3.910    62.816     0.150
     3.910   105.668     0.150
     3.910    62.816     0.150
     3.910   105.668     0.150
     4.279    68.398     0.150
     4.279   113.098     0.150
     4.347   116.297     0.150
     4.385    66.996     0.150
     4.385   117.098     0.150
     4.443    68.898     0.150
     4.811    73.398     0.150
     4.811   125.098     0.150
     4.926    73.977     0.150
     4.920    83.297     0.150
     5.014    75.559     0.150
     5.567   148.098     0.150
     5.877    87.598     0.150
     6.020    92.797     0.150
     6.020   160.297     0.150
     6.102    93.398     0.150
     6.102   162.695     0.150
     6.105    92.398     0.150
     6.161    91.898     0.150
     6.161   162.996     0.150
     6.248   164.598     0.150
     6.339    93.695     0.150
     6.385    94.496     0.150
     6.622   107.695     0.150
     6.622   191.996     0.150
     6.640    98.496     0.150
     7.004   101.797     0.150
     7.025   102.695     0.150
     7.298   106.398     0.150
     7.484   109.797     0.150
     7.484   121.297     0.150
     7.484   189.195     0.150
     8.075   117.398     0.150
     8.355   120.898     0.150
     8.355   208.598     0.150
     8.731   125.098     0.150
     8.731   217.898     0.150
     9.630   239.996     0.150
    20.903   285.926     0.150
    73.628   697.797     0.150
     0.253     5.812     0.150
     0.253     9.617     0.150
     0.461     8.922     0.150
     0.461    15.195     0.150
     0.502     9.945     0.150
     0.502    16.695     0.150
     0.530     9.727     0.150
     0.530    17.266     0.150
     0.541     9.695     0.150
     0.534     9.742     0.150
     0.534    18.094     0.150
     0.562    10.977     0.150
     0.562    18.102     0.150
     0.830    16.562     0.150
     0.816    15.328     0.150
     0.816    26.523     0.150
     1.039    19.094     0.150
     1.039    33.922     0.150
     1.170    21.195     0.150
     1.145    38.531     0.150
     1.280    23.508     0.150
     1.417    25.352     0.150
     1.630    28.625     0.150
     1.610    27.664     0.150
     1.735    30.297     0.150
     1.771    30.422     0.150
     1.938    31.828     0.150
     1.938    56.508     0.150
     2.015    34.773     0.150
     2.120    34.836     0.150
     2.142    36.836     0.150
     2.312    38.758     0.150
     2.530    40.719     0.150
     2.530    72.148     0.150
     2.802    44.406     0.150
     2.808    45.398     0.150
     2.808    77.984     0.150
     2.879    45.703     0.150
     2.879    79.414     0.150
     2.892    46.938     0.150
     2.985    48.555     0.150
     2.985    83.008     0.150
     3.015    48.172     0.150
     3.015    82.422     0.150
     3.140    50.875     0.150
     3.188    50.742     0.150
     3.266    52.227     0.150
     3.266    89.547     0.150
     3.285    51.734     0.150
     3.285    88.594     0.150
     3.354    53.086     0.150
     3.354    90.898     0.150
     3.721    58.867     0.150
     3.728    58.805     0.150
     3.728   101.047     0.150
     3.896    60.727     0.150
     3.896   104.086     0.150
     3.916    61.008     0.150
     3.916   104.734     0.150
     3.916    61.008     0.150
     3.916   104.734     0.150
     4.366   115.727     0.150
     4.404    68.023     0.150
     4.404   115.422     0.150
     4.448    67.523     0.150
     4.830   129.922     0.150
     4.921    92.625     0.150
     4.944    72.281     0.150
     5.136    76.703     0.150
     5.797    86.328     0.150
     5.886    87.227     0.150
     6.181    91.727     0.150
     6.181   162.922     0.150
     6.346    93.422     0.150
     6.392    93.828     0.150
     6.639   100.422     0.150
     6.639   173.828     0.150
     6.650    97.227     0.150
     7.016   101.625     0.150
     7.036   101.727     0.150
     7.036   178.328     0.150
     7.203   104.523     0.150
     7.503   110.227     0.150
     7.503   123.125     0.150
     8.004   114.727     0.150
     8.370   118.422     0.150
     8.370   209.523     0.150
     8.746   123.422     0.150
     8.746   217.922     0.150
     9.241   294.422     0.150
     9.344   132.727     0.150
     9.643   136.227     0.150
     9.643   241.625     0.150
     9.722   241.828     0.150
     0.196     4.766     0.150
     0.196     7.523     0.150
     0.463     9.188     0.150
     0.471     8.945     0.150
     0.471    15.906     0.150
     0.472     8.578     0.150
     0.472    16.578     0.150
     0.555    11.227     0.150
     0.556     9.938     0.150
     0.556    20.195     0.150
     0.602    10.703     0.150
     0.602    20.258     0.150
     0.747    14.859     0.150
     0.822    15.273     0.150
     0.823    16.477     0.150
     1.008    17.734     0.150
     1.151    21.148     0.150
     1.339    24.336     0.150
     1.388    24.758     0.150
     1.608    28.336     0.150
     1.787    30.977     0.150
     1.835    31.828     0.150
     1.875    31.344     0.150
     1.974    33.016     0.150
     2.167    36.555     0.150
     2.196    38.539     0.150
     2.278    39.414     0.150
     2.572    41.883     0.150
     2.743    44.398     0.150
     2.743    76.773     0.150
     2.881    45.312     0.150
     2.881    79.773     0.150
     2.924    47.273     0.150
     2.924    81.258     0.150
     2.948    47.359     0.150
     2.948    81.477     0.150
     3.203    50.625     0.150
     3.203    87.758     0.150
     3.217    51.023     0.150
     3.217    88.016     0.150
     3.287    51.703     0.150
     3.287    89.875     0.150
     3.668    57.555     0.150
     3.668    99.023     0.150
     3.830    59.828     0.150
     3.830   103.164     0.150
     3.851    59.695     0.150
     3.851   103.547     0.150
     3.851    59.695     0.150
     3.851   103.547     0.150
     4.372   115.156     0.150
     4.416    66.258     0.150
     4.416   116.859     0.150
     4.515    68.453     0.150
     6.710    97.758     0.150
     7.072   102.656     0.150
     7.512   188.859     0.150
     8.057   115.453     0.150
     8.415   207.555     0.150
     8.792   124.359     0.150
     8.792   218.258     0.150
     9.769   242.359     0.150
     0.286     6.789     0.150
     0.385     7.445     0.150
     0.497     9.508     0.150
     0.457     9.117     0.150
     0.518     9.789     0.150
     0.523    10.707     0.150
     0.577    10.668     0.150
     0.567    11.277     0.150
     0.731    13.719     0.150
     0.852    15.617     0.150
     0.835    15.047     0.150
     1.111    19.066     0.150
     1.054    19.098     0.150
     1.180    22.355     0.150
     1.430    26.207     0.150
     1.573    27.578     0.150
     1.586    28.016     0.150
     1.617    28.516     0.150
     1.709    29.387     0.150
     1.739    29.379     0.150
     1.640    29.156     0.150
     1.857    32.129     0.150
     1.970    32.809     0.150
     2.097    35.445     0.150
     2.116    37.016     0.150
     2.036    35.367     0.150
     2.328    39.906     0.150
     2.510    41.176     0.150
     2.867    46.605     0.150
     2.881    45.578     0.150
     2.881    80.328     0.150
     2.843    45.629     0.150
     2.843    80.637     0.150
     2.834    45.488     0.150
     3.019    49.129     0.150
     3.019    85.809     0.150
     3.116    51.027     0.150
     3.051    48.676     0.150
     3.051    85.266     0.150
     3.159    50.246     0.150
     3.162    51.668     0.150
     3.198    52.426     0.150
     3.108    49.867     0.150
     3.315    53.629     0.150
     3.301    52.836     0.150
     3.301    92.129     0.150
     3.322    52.156     0.150
     3.322    91.238     0.150
     3.389    53.656     0.150
     3.389    93.289     0.150
     3.477    56.707     0.150
     3.490    55.219     0.150
     3.763    60.617     0.150
     3.761    59.457     0.150
     3.761   103.789     0.150
     3.737    59.438     0.150
     3.784    59.996     0.150
     3.909    61.496     0.150
     3.953    65.469     0.150
     3.953   129.438     0.150
     3.932    61.355     0.150
     3.932   106.777     0.150
     3.951    62.008     0.150
     3.951   107.559     0.150
     3.951    62.008     0.150
     3.951   107.559     0.150
     4.066    62.578     0.150
     4.022    63.559     0.150
     4.022   110.098     0.150
     4.090    65.016     0.150
     4.098    61.887     0.150
     4.042    65.445     0.150
     4.042   111.789     0.150
     4.169    64.559     0.150
     4.231    67.129     0.150
     4.154    65.195     0.150
     4.282    65.168     0.150
     4.213    65.516     0.150
     4.213   114.016     0.150
     4.306    65.719     0.150
     4.341    67.457     0.150
     4.267    66.016     0.150
     4.366    66.578     0.150
     4.366   115.617     0.150
     4.368    66.195     0.150
     4.400    65.918     0.150
     4.400    68.617     0.150
     4.400   116.418     0.150
     4.413    67.617     0.150
     4.471    69.797     0.150
     4.492    67.867     0.150
     4.536    69.469     0.150
     4.536    70.016     0.150
     4.536    79.016     0.150
     4.536   121.316     0.150
     4.536   131.316     0.150
     4.630    72.016     0.150
     4.630   124.219     0.150
     4.680    68.688     0.150
     4.680   122.719     0.150
     4.831    72.918     0.150
     4.831   126.516     0.150
     4.839    72.207     0.150
     5.009    74.695     0.150
     4.958    75.816     0.150
     4.958    93.918     0.150
     4.958   133.016     0.150
     5.076    77.906     0.150
     5.015    76.617     0.150
     5.128    75.695     0.150
     5.180    77.816     0.150
     5.180   137.258     0.150
     5.318    80.297     0.150
     5.318   138.719     0.150
     5.407    82.648     0.150
     5.468    84.148     0.150
     5.468    82.879     0.150
     5.498    82.918     0.150
     5.498   142.617     0.150
     5.439    82.617     0.150
     5.559    83.418     0.150
     5.591    82.418     0.150
     5.591   143.816     0.150
     5.665    84.777     0.150
     5.714    87.289     0.150
     5.714    86.227     0.150
     5.651    84.617     0.150
     5.763    85.727     0.150
     5.800    85.918     0.150
     5.814    87.816     0.150
     5.853    87.418     0.150
     5.904    89.316     0.150
     5.834    86.918     0.150
     5.935    89.719     0.150
     5.993    90.398     0.150
     6.031    90.418     0.150
     6.055    88.039     0.150
     6.063    90.719     0.150
     6.063    91.355     0.150
     6.110    90.918     0.150
     6.110   159.316     0.150
     6.109    91.418     0.150
     6.016    91.117     0.150
     6.180    92.016     0.150
     6.180   161.516     0.150
     6.195    92.316     0.150
     6.218    93.816     0.150
     6.253    93.516     0.150
     6.253   164.418     0.150
     6.184    92.617     0.150
     6.304    93.988     0.150
     6.312    93.316     0.150
     6.337    91.648     0.150
     6.354    93.586     0.150
     6.309    93.719     0.150
     6.358    93.719     0.150
     6.306    94.117     0.150
     6.622    98.219     0.150
     6.622   173.117     0.150
     6.619    97.918     0.150
     6.690   100.695     0.150
     6.713   113.117     0.150
     6.713   170.719     0.150
     6.713   101.719     0.150
     6.736    97.648     0.150
     6.655    97.617     0.150
     6.741   100.117     0.150
     6.678    98.617     0.150
     6.833   100.617     0.150
     6.915   103.516     0.150
     6.915   175.316     0.150
     6.939   102.516     0.150
     6.944   103.316     0.150
     6.987   101.516     0.150
     7.008   101.516     0.150
     7.040   104.219     0.150
     7.008   104.117     0.150
     7.170   106.117     0.150
     7.205   109.367     0.150
     7.205   106.117     0.150
     7.243   108.016     0.150
     7.277   107.816     0.150
     7.411   109.219     0.150
     7.390   109.617     0.150
     7.412   109.117     0.150
     7.497   110.617     0.150
     7.501   108.219     0.150
     7.501   120.117     0.150
     7.501   188.918     0.150
     7.729   115.078     0.150
     7.729   197.438     0.150
     7.729   245.488     0.150
     7.786   113.918     0.150
     7.978   114.816     0.150
     7.978   201.016     0.150
     7.938   115.617     0.150
     8.053   117.316     0.150
     8.079   204.516     0.150
     8.009   117.617     0.150
     8.311   121.219     0.150
     8.311   207.117     0.150
     8.317   121.047     0.150
     8.348   118.816     0.150
     8.348   208.816     0.150
     8.396   121.918     0.150
     8.370   123.117     0.150
     8.482   125.117     0.150
     8.482   143.516     0.150
     8.482   214.219     0.150
     8.710   126.516     0.150
     8.710   219.219     0.150
     8.724   123.918     0.150
     8.724   216.316     0.150
     8.734   129.918     0.150
     8.789   127.617     0.150
     8.928   132.258     0.150
     8.928   286.898     0.150
     8.955   129.617     0.150
     9.065   131.617     0.150
     9.221   134.316     0.150
     9.221   287.418     0.150
     9.235   133.219     0.150
     9.235   230.016     0.150
     9.235   229.617     0.150
     9.315   132.816     0.150
     9.315   232.117     0.150
     9.452   135.816     0.150
     9.487   136.617     0.150
     9.616   136.316     0.150
     9.616   239.516     0.150
     9.621   137.617     0.150
     9.621   237.918     0.150
     9.680   138.016     0.150
     9.680   240.617     0.150
     9.710   140.617     0.150
     9.710   275.617     0.150
     9.889   140.918     0.150
     9.889   246.516     0.150
    10.762   153.816     0.150
    10.801   154.918     0.150
    10.949   156.617     0.150
    11.457   164.219     0.150
    12.379   177.617     0.150
    14.393   200.988     0.150
    18.490   255.789     0.150
    18.475   254.977     0.150
    19.510   267.719     0.150
    19.510   267.289     0.150
    19.617   267.117     0.150
    19.617   490.918     0.150
    20.223   276.316     0.150
    20.467   279.816     0.150
    20.534   293.918     0.150
    20.933   281.516     0.150
    21.591   289.117     0.150
    28.473   356.266     0.150
    31.627   383.418     0.150
    38.326   441.508     0.150
    39.094   447.418     0.150
    39.242   448.816     0.150
    39.479   450.316     0.150
    45.591   503.617     0.150
    46.695   508.941     0.150
    47.272   513.844     0.150
    68.538   662.406     0.150
    82.140   738.598     0.150
    89.372   776.469     0.150
     0.297     6.617     0.150
     0.372     7.359     0.150
     0.372    12.309     0.150
     0.465     9.047     0.150
     0.465    15.840     0.150
     0.482     9.359     0.150
     0.482    17.020     0.150
     0.521     9.707     0.150
     0.521    17.527     0.150
     0.539    10.699     0.150
     0.577    11.277     0.150
     0.592    10.578     0.150
     0.592    20.777     0.150
     0.722    14.949     0.150
     0.845    14.629     0.150
     0.845    29.609     0.150
     0.867    17.219     0.150
     0.867    28.719     0.150
     1.068    19.887     0.150
     1.191    22.738     0.150
     1.233    21.566     0.150
     1.443    26.258     0.150
     1.652    29.738     0.150
     1.722    30.918     0.150
     1.987    32.746     0.150
     2.051    35.430     0.150
     2.082    36.496     0.150
     2.100    37.738     0.150
     2.342    40.879     0.150
     2.495    41.547     0.150
     2.851    46.996     0.150
     2.856    46.707     0.150
     2.856    81.027     0.150
     2.874    45.777     0.150
     2.874    80.430     0.150
     3.030    49.719     0.150
     3.030    86.617     0.150
     3.064    49.258     0.150
     3.064    85.270     0.150
     3.143    51.867     0.150
     3.312    53.609     0.150
     3.312    92.430     0.150
     3.336    52.609     0.150
     3.336    90.668     0.150
     3.402    54.297     0.150
     3.402    93.309     0.150
     3.739    59.609     0.150
     3.771    60.777     0.150
     3.771   104.668     0.150
     3.945    62.348     0.150
     3.945   106.648     0.150
     3.963    62.727     0.150
     3.963   107.906     0.150
     3.963    62.727     0.150
     3.963   107.906     0.150
     4.058    61.988     0.150
     4.164    64.379     0.150
     4.276    64.898     0.150
     4.362    66.219     0.150
     4.396    67.719     0.150
     4.391    67.418     0.150
     4.391   116.219     0.150
     4.391    66.418     0.150
     4.823    72.816     0.150
     4.823   127.520     0.150
     4.829    72.227     0.150
     4.916    74.066     0.150
     4.972    75.418     0.150
     5.488    82.617     0.150
     5.488   142.418     0.150
     5.586    82.418     0.150
     5.586   143.719     0.150
     5.836    87.020     0.150
     6.015    89.816     0.150
     6.015   158.117     0.150
     6.097    92.617     0.150
     6.097   161.918     0.150
     6.240   165.520     0.150
     6.296    92.520     0.150
     6.341    93.219     0.150
     6.602    96.117     0.150
     6.608   100.117     0.150
     6.608   173.020     0.150
     6.971   101.719     0.150
     7.492   108.219     0.150
     7.492   189.816     0.150
     7.962   114.219     0.150
     8.333   117.719     0.150
     8.333   208.719     0.150
     8.708   124.020     0.150
     8.708   217.117     0.150
     8.701   220.816     0.150
     9.599   239.719     0.150
     9.684   137.418     0.150
     0.292     6.288     0.150
     0.487     9.198     0.150
     0.487    16.729     0.150
     0.536    10.219     0.150
     0.536    18.158     0.150
     0.523     9.368     0.150
     0.523    17.738     0.150
     0.587    10.169     0.150
     0.587    19.358     0.150
     0.577    10.849     0.150
     0.727    14.349     0.150
     0.862    16.488     0.150
     0.862    28.089     0.150
     0.844    14.599     0.150
     1.066    19.259     0.150
     1.066    36.719     0.150
     1.099    18.648     0.150
     1.190    21.979     0.150
     1.190    40.328     0.150
     1.237    20.969     0.150
     1.442    25.568     0.150
     1.563    27.299     0.150
     1.576    27.389     0.150
     1.651    28.889     0.150
     1.727    30.458     0.150
     1.983    32.089     0.150
     2.049    34.868     0.150
     2.103    36.578     0.150
     2.340    39.839     0.150
     2.497    40.648     0.150
     2.851    46.068     0.150
     2.851    79.108     0.150
     3.025    48.929     0.150
     3.025    84.578     0.150
     3.059    48.629     0.150
     3.059    83.708     0.150
     3.104    50.408     0.150
     3.120    49.629     0.150
     3.146    50.339     0.150
     3.122    50.599     0.150
     3.307    52.889     0.150
     3.307    90.868     0.150
     3.331    51.958     0.150
     3.331    89.368     0.150
     3.397    53.759     0.150
     3.397    91.969     0.150
     3.766    59.729     0.150
     3.766   102.839     0.150
     3.739    58.458     0.150
     3.746    58.148     0.150
     3.828    58.528     0.150
     3.828   102.559     0.150
     3.939    61.358     0.150
     3.939   105.429     0.150
     3.958    61.919     0.150
     3.958   106.078     0.150
     3.958    61.919     0.150
     3.958   106.078     0.150
     4.057    63.488     0.150
     4.057   108.979     0.150
     4.162   111.269     0.150
     4.275    64.479     0.150
     4.300    70.188     0.150
     4.300   112.988     0.150
     4.358    75.988     0.150
     4.358   115.288     0.150
     4.361    65.759     0.150
     4.361   115.788     0.150
     4.391    66.389     0.150
     4.391   114.788     0.150
     4.401    67.089     0.150
     4.485    68.799     0.150
     4.822    72.188     0.150
     4.917    73.198     0.150
     4.967    83.688     0.150
     4.996    74.049     0.150
     5.488   140.688     0.150
     5.844    86.788     0.150
     5.841    86.988     0.150
     6.098   160.188     0.150
     6.172    92.188     0.150
     6.172   160.988     0.150
     6.300    92.288     0.150
     6.346    93.089     0.150
     6.610   100.389     0.150
     6.610   171.488     0.150
     6.606    95.988     0.150
     6.974   100.988     0.150
     6.974   176.488     0.150
     6.995   100.788     0.150
     6.995   176.889     0.150
     7.492   108.988     0.150
     7.492   187.389     0.150
     8.335   118.389     0.150
     8.335   208.488     0.150
     8.711   123.288     0.150
     8.711   215.488     0.150
     9.303   132.089     0.150
     9.603   136.389     0.150
     9.603   238.889     0.150
     9.686   136.089     0.150
     0.431     8.487     0.150
     0.431    14.627     0.150
     0.485     9.457     0.150
     0.485    16.507     0.150
     0.537    10.417     0.150
     0.537    18.387     0.150
     0.519    10.527     0.150
     0.554    10.327     0.150
     0.554    18.457     0.150
     0.538    10.267     0.150
     0.538    19.297     0.150
     0.585    11.537     0.150
     0.779    15.547     0.150
     0.811    16.647     0.150
     0.811    28.247     0.150
     0.853    17.207     0.150
     1.058    19.728     0.150
     1.058    36.507     0.150
     1.142    19.827     0.150
     1.192    23.057     0.150
     1.192    40.757     0.150
     1.271    22.457     0.150
     1.436    25.947     0.150
     1.651    29.587     0.150
     1.651    52.217     0.150
     1.766    31.587     0.150
     1.944    32.438     0.150
     2.032    35.547     0.150
     2.105    36.037     0.150
     2.797    46.117     0.150
     2.797    79.277     0.150
     2.855    46.587     0.150
     2.855    80.677     0.150
     2.972    48.827     0.150
     2.972    84.027     0.150
     3.006    48.887     0.150
     3.006    84.097     0.150
     3.254    52.697     0.150
     3.254    90.497     0.150
     3.279    52.737     0.150
     3.279    90.417     0.150
     3.344    53.847     0.150
     3.344    92.478     0.150
     3.713    59.337     0.150
     3.713   101.837     0.150
     3.886    61.287     0.150
     3.886   105.777     0.150
     3.904    61.688     0.150
     3.904   105.867     0.150
     3.904    61.688     0.150
     3.904   105.867     0.150
     4.171    65.447     0.150
     4.171   114.247     0.150
     4.343    77.247     0.150
     4.343   115.747     0.150
     4.381    68.947     0.150
     4.381   116.747     0.150
     4.446    68.147     0.150
     4.446   119.047     0.150
     4.915    93.747     0.150
     5.563    83.447     0.150
     5.880    87.347     0.150
     5.924    89.347     0.150
     5.960    87.347     0.150
     5.960   153.847     0.150
     6.100    91.047     0.150
     6.100   159.946     0.150
     6.103   160.847     0.150
     6.157    93.347     0.150
     6.157   158.347     0.150
     6.342    93.647     0.150
     6.388    94.447     0.150
     6.621   100.047     0.150
     6.642    97.047     0.150
     6.929   102.347     0.150
     6.929   180.847     0.150
     6.982   102.847     0.150
     7.005   102.047     0.150
     7.007   103.847     0.150
     7.007   179.548     0.150
     7.026   102.447     0.150
     7.026   178.048     0.150
     7.170   106.547     0.150
     7.480   121.547     0.150
     7.480   189.548     0.150
     7.992   114.847     0.150
     8.286   206.946     0.150
     8.354   119.447     0.150
     8.354   208.647     0.150
     8.731   124.547     0.150
     8.731   216.747     0.150
     9.333   133.047     0.150
     9.631   137.147     0.150
     9.699   137.647     0.150
     0.317     6.789     0.150
     0.317    11.359     0.150
     0.472     8.938     0.150
     0.472    15.672     0.150
     0.457    16.289     0.150
     0.521     9.664     0.150
     0.521    18.180     0.150
     0.559    10.664     0.150
     0.617    10.547     0.150
     0.617    21.453     0.150
     0.705    14.844     0.150
     0.714    13.250     0.150
     0.799    15.273     0.150
     0.799    27.797     0.150
     0.856    14.820     0.150
     0.891    17.172     0.150
     0.891    30.070     0.150
     1.085    20.211     0.150
     1.205    21.977     0.150
     1.460    26.594     0.150
     1.667    29.102     0.150
     1.698    30.844     0.150
     2.062    35.727     0.150
     2.877    47.078     0.150
     2.877    79.844     0.150
     2.869    45.391     0.150
     2.869    80.141     0.150
     3.050    50.094     0.150
     3.050    84.891     0.150
     3.087    49.672     0.150
     3.087    84.359     0.150
     3.333    53.812     0.150
     3.333    91.133     0.150
     3.360    53.492     0.150
     3.360    90.383     0.150
     3.424    54.609     0.150
     3.424    92.812     0.150
     3.790    60.562     0.150
     3.790   102.930     0.150
     3.826    59.102     0.150
     3.966    62.281     0.150
     3.966   105.922     0.150
     3.984    62.859     0.150
     3.984   106.688     0.150
     4.050    62.500     0.150
     4.252    66.570     0.150
     4.301    66.969     0.150
     4.371    67.469     0.150
     4.371   117.070     0.150
     4.381    66.867     0.150
     4.381    68.773     0.150
     4.381   116.367     0.150
     4.816    72.469     0.150
     5.006    75.273     0.150
     5.478    82.672     0.150
     5.478   143.273     0.150
     5.582    82.172     0.150
     5.812    87.273     0.150
     6.000    91.867     0.150
     6.082    91.773     0.150
     6.165    91.570     0.150
     6.165   158.367     0.150
     6.271    93.273     0.150
     6.316    93.367     0.150
     6.578    97.867     0.150
     6.591    99.773     0.150
     6.591   173.570     0.150
     6.947   102.070     0.150
     6.947   176.367     0.150
     6.968   101.969     0.150
     6.968   177.469     0.150
     7.129   134.172     0.150
     7.190   104.172     0.150
     7.190   182.367     0.150
     7.236   107.469     0.150
     7.483   108.070     0.150
     7.483   119.570     0.150
     7.483   139.570     0.150
     7.483   189.570     0.150
     7.940   114.469     0.150
     7.940   199.867     0.150
     8.012   116.469     0.150
     8.312   119.070     0.150
     8.312   208.070     0.150
     8.688   124.070     0.150
     8.688   215.469     0.150
     9.577   136.867     0.150
     9.577   238.969     0.150
     0.316     6.371     0.150
     0.316    12.371     0.150
     0.466     8.980     0.150
     0.466    16.402     0.150
     0.455     8.621     0.150
     0.455    15.211     0.150
     0.506     9.230     0.150
     0.506    16.090     0.150
     0.542    10.191     0.150
     0.571    10.773     0.150
     0.609    10.402     0.150
     0.703    14.621     0.150
     0.722    12.910     0.150
     0.781    14.781     0.150
     0.838    16.172     0.150
     0.884    16.953     0.150
     1.067    20.043     0.150
     1.067    36.352     0.150
     1.187    22.082     0.150
     1.226    22.691     0.150
     1.441    25.293     0.150
     1.648    28.781     0.150
     1.712    30.363     0.150
     1.998    32.523     0.150
     2.053    34.992     0.150
     2.885    44.871     0.150
     2.885    79.523     0.150
     2.875    45.840     0.150
     2.875    79.293     0.150
     3.049    48.863     0.150
     3.049    84.102     0.150
     3.082    48.621     0.150
     3.082    83.590     0.150
     3.332    52.391     0.150
     3.332    90.902     0.150
     3.353    52.121     0.150
     3.353    89.543     0.150
     3.421    53.512     0.150
     3.421    92.000     0.150
     3.791    59.410     0.150
     3.791   102.301     0.150
     3.963    60.992     0.150
     3.963   105.371     0.150
     3.982    61.453     0.150
     3.982   106.051     0.150
     4.315   123.453     0.150
     4.399    66.051     0.150
     4.399   114.551     0.150
     4.567    69.852     0.150
     4.833    71.551     0.150
     4.833   126.652     0.150
     5.018    74.750     0.150
     5.865    86.852     0.150
     6.182    90.852     0.150
     6.182   159.352     0.150
     6.337    93.352     0.150
     7.501   107.953     0.150
     7.501   121.852     0.150
     7.501   188.250     0.150
    12.724   179.852     0.150
     0.261     5.852     0.150
     0.261    10.820     0.150
     0.520     9.820     0.150
     0.467     8.883     0.150
     0.467    16.750     0.150
     0.533     9.672     0.150
     0.533    18.859     0.150
     0.515     9.922     0.150
     0.554     9.867     0.150
     0.571    10.773     0.150
     0.756    13.742     0.150
     0.752    13.641     0.150
     0.829    15.891     0.150
     0.839    14.758     0.150
     0.839    28.258     0.150
     1.051    19.328     0.150
     1.181    21.141     0.150
     1.428    25.367     0.150
     1.609    27.891     0.150
     1.640    28.891     0.150
     1.757    29.969     0.150
     1.641    28.461     0.150
     1.952    31.734     0.150
     2.106    35.469     0.150
     2.128    36.953     0.150
     2.029    34.570     0.150
     2.290    37.938     0.150
     2.516    41.023     0.150
     2.878    46.891     0.150
     2.872    45.414     0.150
     2.872    78.828     0.150
     2.818    45.992     0.150
     2.818    78.398     0.150
     2.994    48.641     0.150
     2.994    83.273     0.150
     3.126    50.883     0.150
     3.026    48.883     0.150
     3.026    82.930     0.150
     3.172    50.883     0.150
     3.215    52.469     0.150
     3.276    52.734     0.150
     3.276    89.680     0.150
     3.298    52.734     0.150
     3.298    89.320     0.150
     3.365    53.367     0.150
     3.365    91.422     0.150
     3.736    59.617     0.150
     3.736   101.484     0.150
     3.731    58.250     0.150
     3.741    58.094     0.150
     3.783    58.391     0.150
     3.783   101.391     0.150
     3.907    61.719     0.150
     3.907   104.688     0.150
     3.926    61.742     0.150
     3.926   105.102     0.150
     4.189    64.891     0.150
     4.189   113.188     0.150
     4.293    65.789     0.150
     4.359   113.391     0.150
     4.250    65.391     0.150
     4.395    66.594     0.150
     4.395   115.789     0.150
     4.433    68.094     0.150
     4.433   118.391     0.150
     4.310    67.289     0.150
     4.514    68.188     0.150
     4.514    78.094     0.150
     4.514   119.891     0.150
     4.823    72.391     0.150
     4.698    71.852     0.150
     5.016    74.391     0.150
     4.982    74.992     0.150
     4.934    75.289     0.150
     4.934    83.688     0.150
     4.934   130.391     0.150
     5.005    75.891     0.150
     4.996    75.891     0.150
     5.156   134.094     0.150
     5.285    78.094     0.150
     5.293    79.812     0.150
     5.293   137.031     0.150
     5.349    80.367     0.150
     5.494    84.391     0.150
     5.418    81.391     0.150
     5.581    81.992     0.150
     5.768    85.828     0.150
     5.637    83.891     0.150
     5.863    86.688     0.150
     5.871    87.789     0.150
     5.929    88.094     0.150
     5.929   153.992     0.150
     5.810    86.094     0.150
     5.961    86.289     0.150
     5.961   150.492     0.150
     6.109    91.289     0.150
     6.109   158.289     0.150
     6.111    90.992     0.150
     6.111   159.492     0.150
     5.999    90.391     0.150
     6.005    88.492     0.150
     6.169    90.789     0.150
     6.169   156.188     0.150
     6.173    91.289     0.150
     6.173   161.492     0.150
     6.075    89.969     0.150
     6.214    92.688     0.150
     6.214   162.188     0.150
     6.183    92.789     0.150
     6.254    92.688     0.150
     6.237    91.492     0.150
     6.160    91.391     0.150
     6.331    92.891     0.150
     6.377    93.789     0.150
     6.281    93.188     0.150
     6.306    94.250     0.150
     6.520    94.594     0.150
     6.520   161.594     0.150
     6.613    93.789     0.150
     6.626    99.188     0.150
     6.626   168.992     0.150
     6.636    98.391     0.150
     6.635    98.594     0.150
     6.643    97.688     0.150
     6.643   169.594     0.150
     6.657   172.188     0.150
     6.699    97.891     0.150
     6.699   106.391     0.150
     6.699   169.594     0.150
     6.699   196.992     0.150
     6.654    97.891     0.150
     6.902   101.188     0.150
     6.902   175.891     0.150
     6.768    98.891     0.150
     6.931   101.289     0.150
     6.931   177.891     0.150
     6.813   100.891     0.150
     6.983   100.891     0.150
     7.001   101.492     0.150
     7.001   177.594     0.150
     7.006   102.289     0.150
     7.022   101.992     0.150
     7.022   178.789     0.150
     6.983   103.391     0.150
     7.169   104.188     0.150
     7.188   104.594     0.150
     7.189   104.391     0.150
     7.204   105.891     0.150
     7.216   105.391     0.150
     7.201   104.289     0.150
     7.201   181.688     0.150
     7.091   104.391     0.150
     7.293   108.094     0.150
     7.495   108.289     0.150
     7.495   119.391     0.150
     7.495   187.992     0.150
     7.613   108.688     0.150
     7.717   194.258     0.150
     7.990   114.891     0.150
     8.004   117.391     0.150
     8.303   120.789     0.150
     8.303   205.992     0.150
     8.356   118.789     0.150
     8.356   207.688     0.150
     8.468   124.688     0.150
     8.468   216.594     0.150
     8.706   125.891     0.150
     8.732   123.992     0.150
     8.732   215.688     0.150
     8.722   128.789     0.150
     8.722   220.289     0.150
     9.210   134.789     0.150
     9.232   133.289     0.150
     9.232   228.891     0.150
     9.232   228.391     0.150
     9.329   131.891     0.150
     9.329   231.688     0.150
     9.628   136.688     0.150
     9.628   239.094     0.150
     9.694   137.492     0.150
     9.708   137.992     0.150
     9.708   241.789     0.150
     9.704   138.391     0.150
     9.903   140.992     0.150
     9.903   247.289     0.150
    18.482   257.125     0.150
    20.207   275.992     0.150
    20.918   281.344     0.150
    38.302   440.867     0.150
    47.247   512.617     0.150
    73.642   692.344     0.150
     0.285     6.215     0.150
     0.285    10.005     0.150
     0.489     9.335     0.150
     0.544    10.155     0.150
     0.585    10.255     0.150
     0.585    19.255     0.150
     0.589    10.995     0.150
     0.746    12.945     0.150
     0.859    16.325     0.150
     0.859    28.655     0.150
     0.857    16.455     0.150
     1.097    18.785     0.150
     1.076    20.055     0.150
     1.076    36.325     0.150
     1.202    22.515     0.150
     1.202    38.475     0.150
     1.453    25.415     0.150
     2.860    45.045     0.150
     4.219    65.425     0.150
     4.219   113.825     0.150
     4.287    67.425     0.150
     4.378    67.125     0.150
     4.378   114.525     0.150
     4.401    67.825     0.150
     4.401   117.525     0.150
     4.809    72.125     0.150
     4.809   125.825     0.150
     6.087    90.625     0.150
     6.087   158.825     0.150
     6.159    90.925     0.150
     6.159   160.125     0.150
     6.298    92.125     0.150
     6.298   160.525     0.150
     6.344    93.025     0.150
     6.602    96.125     0.150
     6.969   100.225     0.150
     6.969   175.525     0.150
     6.990   100.625     0.150
     6.990   175.825     0.150
     7.155   103.325     0.150
     7.479   189.425     0.150
     7.959   114.525     0.150
     8.289   206.725     0.150
     8.327   117.625     0.150
     8.327   207.225     0.150
     8.703   123.325     0.150
     8.703   215.125     0.150
     9.297   131.925     0.150
     9.297   231.525     0.150
     9.597   136.725     0.150
     9.597   237.625     0.150
     0.286     6.117     0.150
     0.286     9.737     0.150
     0.491     9.248     0.150
     0.491    16.478     0.150
     0.537    10.098     0.150
     0.537    18.498     0.150
     0.581    10.808     0.150
     0.583    11.867     0.150
     0.583    19.777     0.150
     0.748    12.827     0.150
     0.848    16.178     0.150
     0.858    16.077     0.150
     0.858    28.688     0.150
     1.101    18.638     0.150
     1.068    20.067     0.150
     1.068    37.147     0.150
     1.238    21.788     0.150
     1.194    22.348     0.150
     1.194    40.038     0.150
     1.444    25.548     0.150
     2.868    44.888     0.150
     2.845    45.817     0.150
     2.845    79.468     0.150
     3.019    47.668     0.150
     3.019    84.098     0.150
     3.302    51.407     0.150
     3.302    90.617     0.150
     3.326    51.947     0.150
     3.326    90.357     0.150
     3.392    52.748     0.150
     3.392    92.478     0.150
     3.521    53.407     0.150
     3.760    58.777     0.150
     3.760   102.008     0.150
     3.823    59.208     0.150
     3.934    60.478     0.150
     3.934   105.668     0.150
     3.952    60.768     0.150
     3.952   106.098     0.150
     4.218    65.407     0.150
     4.218   112.607     0.150
     4.294    67.107     0.150
     4.294   130.008     0.150
     4.353    73.808     0.150
     4.353   114.808     0.150
     4.386    65.808     0.150
     4.386   114.607     0.150
     4.404    67.708     0.150
     4.818    71.808     0.150
     4.818   125.708     0.150
     4.878    72.708     0.150
     4.878   126.708     0.150
     4.962    83.808     0.150
     5.296    79.107     0.150
     5.484    81.508     0.150
     5.484   142.607     0.150
     5.579    81.208     0.150
     5.579   141.907     0.150
     5.843    85.008     0.150
     6.013    89.607     0.150
     6.013   157.508     0.150
     6.096    90.508     0.150
     6.096   159.407     0.150
     6.095    90.308     0.150
     6.095   158.508     0.150
     6.167    90.907     0.150
     6.167   160.008     0.150
     6.239    92.907     0.150
     6.239   163.808     0.150
     6.189    91.808     0.150
     6.348    93.308     0.150
     6.309    93.808     0.150
     6.608    97.607     0.150
     6.608   166.907     0.150
     6.608    98.008     0.150
     6.608   173.808     0.150
     6.975   100.808     0.150
     6.975   176.208     0.150
     6.996   100.808     0.150
     6.996   176.607     0.150
     7.011   103.808     0.150
     7.160   103.407     0.150
     7.265   107.607     0.150
     7.265   183.708     0.150
     7.487   108.208     0.150
     7.487   188.208     0.150
     7.965   114.107     0.150
     7.965   199.107     0.150
     8.298   205.808     0.150
     8.334   118.107     0.150
     8.334   206.607     0.150
     8.387   120.907     0.150
     8.710   123.407     0.150
     8.710   215.308     0.150
     9.201   134.308     0.150
     9.221   228.308     0.150
     9.303   131.708     0.150
     9.303   231.107     0.150
     9.603   136.107     0.150
     9.603   238.308     0.150
     9.668   136.907     0.150
     9.877   140.308     0.150
     0.300     6.492     0.150
     0.478     9.053     0.150
     0.478    16.822     0.150
     0.544    10.492     0.150
     0.544    19.354     0.150
     0.581    11.072     0.150
     0.597    12.492     0.150
     0.597    20.992     0.150
     0.734    12.674     0.150
     0.782    14.414     0.150
     0.782    26.693     0.150
     0.848    17.043     0.150
     0.871    17.693     0.150
     1.073    19.523     0.150
     1.073    34.713     0.150
     1.089    18.523     0.150
     1.196    22.633     0.150
     1.228    21.174     0.150
     1.448    25.732     0.150
     1.657    29.123     0.150
     1.717    30.363     0.150
     1.992    32.723     0.150
     2.056    35.623     0.150
     2.077    35.854     0.150
     2.095    37.283     0.150
     2.347    40.443     0.150
     2.490    40.854     0.150
     2.846    46.863     0.150
     2.859    46.184     0.150
     2.859    80.684     0.150
     2.871    45.693     0.150
     2.871    79.594     0.150
     3.032    49.014     0.150
     3.032    85.914     0.150
     3.067    48.543     0.150
     3.067    84.902     0.150
     3.096    51.354     0.150
     3.126    53.273     0.150
     3.176    52.094     0.150
     3.315    52.643     0.150
     3.315    92.033     0.150
     3.340    51.943     0.150
     3.340    90.812     0.150
     3.406    53.863     0.150
     3.406    93.184     0.150
     3.456    56.793     0.150
     3.743    59.863     0.150
     3.773    59.834     0.150
     3.773   103.953     0.150
     3.948    61.312     0.150
     3.948   106.594     0.150
     3.965    61.943     0.150
     3.965   107.504     0.150
     4.161    63.482     0.150
     4.284    68.303     0.150
     4.299    67.953     0.150
     4.392    67.254     0.150
     4.392   116.354     0.150
     4.355    67.953     0.150
     4.355   115.453     0.150
     4.387    66.152     0.150
     4.387   115.453     0.150
     4.820    72.453     0.150
     4.820   124.953     0.150
     4.825    72.393     0.150
     5.000    75.254     0.150
     5.000   129.754     0.150
     5.048    76.652     0.150
     5.112    75.354     0.150
     5.485    82.354     0.150
     5.485   142.453     0.150
     5.583    82.354     0.150
     5.583   143.152     0.150
     5.831    86.453     0.150
     5.837    86.754     0.150
     5.905    87.854     0.150
     5.930    86.354     0.150
     6.010    90.854     0.150
     6.010   156.953     0.150
     6.092    92.053     0.150
     6.092   159.152     0.150
     6.169    91.453     0.150
     6.169   159.453     0.150
     6.190    91.453     0.150
     6.236    94.953     0.150
     6.236   164.152     0.150
     6.336    93.254     0.150
     6.491    94.854     0.150
     6.597    97.254     0.150
     6.603   100.254     0.150
     6.903   101.453     0.150
     6.954   101.652     0.150
     6.965   101.254     0.150
     6.965   176.553     0.150
     6.986   100.953     0.150
     6.986   176.953     0.150
     7.148   106.354     0.150
     7.255   105.354     0.150
     7.488   107.754     0.150
     7.488   189.453     0.150
     7.957   114.152     0.150
     7.957   199.652     0.150
     8.300   207.152     0.150
     8.328   118.254     0.150
     8.328   207.053     0.150
     8.703   123.453     0.150
     8.703   215.953     0.150
     0.297     6.238     0.150
     0.297    10.648     0.150
     0.371     7.238     0.150
     0.371    12.809     0.150
     0.471     9.320     0.150
     0.568    10.160     0.150
     0.604    11.988     0.150
     0.604    21.879     0.150
     0.729    14.488     0.150
     0.727    15.121     0.150
     0.878    16.648     0.150
     0.878    30.078     0.150
     1.099    19.918     0.150
     1.099    37.020     0.150
     1.475    25.781     0.150
     1.684    28.840     0.150
     1.700    30.730     0.150
     2.009    33.398     0.150
     2.081    36.602     0.150
     2.053    35.621     0.150
     2.072    37.191     0.150
     2.465    40.789     0.150
     2.874    47.250     0.150
     3.072    51.191     0.150
     3.118    51.789     0.150
     4.379    67.180     0.150
     6.276    90.379     0.150
     6.276   157.578     0.150
     6.322    93.281     0.150
     6.322   160.980     0.150
     7.236   106.781     0.150
     7.461   110.078     0.150
     7.461   188.781     0.150
     7.934   113.281     0.150
     8.013   116.180     0.150
     8.303   118.480     0.150
     8.303   205.980     0.150
     8.541   121.680     0.150
     8.541   210.281     0.150
     8.679   123.379     0.150
     8.679   213.578     0.150
     0.054     2.922     0.150
     0.054     4.117     0.150
     0.246     5.719     0.150
     0.246     9.320     0.150
     0.424     7.820     0.150
     0.424    14.320     0.150
     0.515     9.820     0.150
     0.515    18.320     0.150
     0.533     9.820     0.150
     0.533    18.523     0.150
     0.542     9.523     0.150
     0.542    18.719     0.150
     0.750    13.523     0.150
     0.771    15.117     0.150
     0.789    13.523     0.150
     0.816    15.719     0.150
     0.846    14.719     0.150
     1.053    19.023     0.150
     1.053    35.617     0.150
     1.140    19.219     0.150
     1.271    23.023     0.150
     1.431    44.219     0.150
     1.645    28.719     0.150
     1.765    31.023     0.150
     1.945    31.719     0.150
     2.028    35.422     0.150
     2.108    35.719     0.150
     2.132    36.922     0.150
     2.291    38.117     0.150
     2.326    39.617     0.150
     2.517    41.117     0.150
     2.810    45.117     0.150
     2.863    44.602     0.150
     2.863    78.688     0.150
     2.881    47.320     0.150
     3.132    50.219     0.150
     3.736    58.617     0.150
     3.747    57.922     0.150
     3.761    59.219     0.150
     4.388    66.617     0.150
     4.388   116.023     0.150
     4.444    67.617     0.150
     4.814    72.219     0.150
     4.814   128.719     0.150
     4.920    75.320     0.150
     4.968    74.219     0.150
     4.968   128.719     0.150
     5.487    82.320     0.150
     5.487   146.617     0.150
     5.571    81.922     0.150
     5.571   147.422     0.150
     5.798    85.523     0.150
     6.108    91.922     0.150
     6.108   160.922     0.150
     6.165    91.023     0.150
     6.165   162.820     0.150
     6.251    93.719     0.150
     6.251   165.117     0.150
     6.340    92.820     0.150
     6.386    93.820     0.150
     6.642    96.422     0.150
     7.006   178.719     0.150
     7.027   179.023     0.150
     7.197   106.617     0.150
     7.299   105.820     0.150
     7.487   107.922     0.150
     7.487   189.023     0.150
     8.357   118.820     0.150
     8.357   208.617     0.150
     8.593   122.320     0.150
     8.593   213.922     0.150
     8.734   123.219     0.150
     8.734   216.820     0.150
     9.632   238.922     0.150
     0.269     6.145     0.150
     0.401     7.545     0.150
     0.511     9.645     0.150
     0.468     9.045     0.150
     0.523    10.245     0.150
     0.563    10.245     0.150
     0.767    13.245     0.150
     0.759    13.444     0.150
     0.759    26.045     0.150
     0.842    14.545     0.150
     1.121    19.045     0.150
     1.057    19.345     0.150
     1.256    21.645     0.150
     1.185    21.345     0.150
     1.434    25.745     0.150
     1.600    28.045     0.150
     1.646    28.745     0.150
     1.747    29.545     0.150
     1.962    32.245     0.150
     2.098    35.345     0.150
     2.120    36.645     0.150
     2.036    34.845     0.150
     2.283    37.845     0.150
     2.509    40.845     0.150
     2.870    47.145     0.150
     2.870    45.265     0.150
     2.870    79.535     0.150
     2.826    44.944     0.150
     3.118    50.944     0.150
     3.164    51.145     0.150
     3.164    50.645     0.150
     3.113    49.545     0.150
     3.125    50.245     0.150
     3.501    54.345     0.150
     3.497    54.045     0.150
     3.735    58.045     0.150
     3.744    58.444     0.150
     3.793    58.345     0.150
     3.939    74.595     0.150
     4.093    64.255     0.150
     4.270    64.814     0.150
     4.293    67.345     0.150
     4.259    65.444     0.150
     4.355    66.095     0.150
     4.392    66.245     0.150
     4.392   116.045     0.150
     4.424    67.545     0.150
     4.523    69.245     0.150
     4.725    72.135     0.150
     4.697    69.404     0.150
     4.707    71.625     0.150
     4.707   124.024     0.150
     4.821    72.345     0.150
     4.832    72.795     0.150
     4.870    73.045     0.150
     4.926    72.995     0.150
     4.993    76.404     0.150
     5.009    74.234     0.150
     4.984    75.145     0.150
     4.984   129.444     0.150
     4.943    74.845     0.150
     4.943   132.345     0.150
     5.006    76.645     0.150
     5.015   131.665     0.150
     5.121    76.225     0.150
     5.288    78.045     0.150
     5.358    80.585     0.150
     5.490    81.845     0.150
     5.428    82.345     0.150
     5.580    81.944     0.150
     5.646    84.545     0.150
     5.761    85.875     0.150
     5.744    85.265     0.150
     5.872    86.944     0.150
     5.820    86.545     0.150
     6.022    90.145     0.150
     6.057    87.645     0.150
     6.008    90.845     0.150
     6.015    89.625     0.150
     6.104    91.145     0.150
     6.170    91.345     0.150
     6.249    93.444     0.150
     6.239    91.845     0.150
     6.322    92.944     0.150
     6.368    93.645     0.150
     6.315    94.345     0.150
     6.620    99.444     0.150
     6.626    97.045     0.150
     6.700   107.145     0.150
     6.700   114.045     0.150
     6.643    97.845     0.150
     6.992   101.845     0.150
     7.013   101.645     0.150
     7.013   177.944     0.150
     7.179   103.645     0.150
     7.100   105.345     0.150
     7.198   104.645     0.150
     7.198   181.944     0.150
     7.198   104.357     0.150
     7.198   182.227     0.150
     7.189   105.375     0.150
     7.189   104.845     0.150
     7.284   104.645     0.150
     7.492   108.145     0.150
     7.492   189.745     0.150
     7.982   114.845     0.150
     8.012   117.845     0.150
     8.119   118.734     0.150
     8.300   207.745     0.150
     8.304   118.654     0.150
     8.349   118.545     0.150
     8.349   208.845     0.150
     8.390   208.745     0.150
     8.406   121.845     0.150
     8.380   122.944     0.150
     8.586   122.245     0.150
     8.586   213.045     0.150
     8.725   123.944     0.150
     8.725   217.245     0.150
     8.911   131.104     0.150
     9.228   133.245     0.150
     9.228   228.444     0.150
     9.228   227.845     0.150
     9.321   132.845     0.150
     9.321   232.345     0.150
     9.620   239.444     0.150
     9.660   139.614     0.150
     9.701   137.645     0.150
     9.895   141.045     0.150
    10.592   152.455     0.150
    14.400   202.045     0.150
    15.007   209.465     0.150
    20.919   282.440     0.150
    37.548   435.055     0.150
    38.308   440.595     0.150
    47.255   513.080     0.150
     0.070     3.328     0.150
     0.070     4.727     0.150
     0.277     6.430     0.150
     0.466     8.930     0.150
     0.525    10.430     0.150
     0.571    10.430     0.150
     0.741    13.430     0.150
     0.763    13.828     0.150
     0.845    16.227     0.150
     1.115    18.828     0.150
     1.058    19.227     0.150
     1.251    22.129     0.150
     1.435    25.828     0.150
     1.435    43.828     0.150
     1.592    27.930     0.150
     1.623    27.629     0.150
     1.742    29.629     0.150
     1.646    28.930     0.150
     1.968    32.527     0.150
     2.095    35.328     0.150
     2.116    36.828     0.150
     2.039    35.027     0.150
     2.280    37.828     0.150
     2.332    39.430     0.150
     2.507    41.027     0.150
     2.841    46.629     0.150
     2.866    47.328     0.150
     2.873    45.508     0.150
     2.873    80.156     0.150
     2.835    45.547     0.150
     2.835    79.918     0.150
     2.832    45.227     0.150
     3.010    47.938     0.150
     3.010    84.020     0.150
     3.115    50.727     0.150
     3.043    48.316     0.150
     3.043    85.168     0.150
     3.161    51.430     0.150
     3.200    51.430     0.150
     3.122    50.027     0.150
     3.113    49.629     0.150
     3.314    53.340     0.150
     3.292    51.949     0.150
     3.292    90.887     0.150
     3.314    51.848     0.150
     3.314    91.898     0.150
     3.476    55.816     0.150
     3.381    53.367     0.150
     3.381    93.180     0.150
     3.497    54.898     0.150
     3.764    59.297     0.150
     3.660    56.930     0.150
     3.746    59.098     0.150
     3.751    58.527     0.150
     3.751   101.789     0.150
     3.735    58.379     0.150
     3.743    58.309     0.150
     3.827    58.840     0.150
     3.827   102.809     0.150
     3.887    63.027     0.150
     3.909    61.066     0.150
     3.800    60.527     0.150
     3.800   102.629     0.150
     3.813    57.828     0.150
     3.944    60.578     0.150
     3.923    61.750     0.150
     3.923   106.867     0.150
     3.942    60.949     0.150
     3.942   106.500     0.150
     4.058    62.066     0.150
     4.058   109.707     0.150
     4.089    64.809     0.150
     4.012    63.156     0.150
     4.012   109.559     0.150
     4.216    65.617     0.150
     4.230    66.738     0.150
     4.281    67.348     0.150
     4.297    65.430     0.150
     4.297   111.328     0.150
     4.358    66.629     0.150
     4.358   115.629     0.150
     4.358    83.828     0.150
     4.265    65.328     0.150
     4.393    65.629     0.150
     4.393   116.129     0.150
     4.417    67.430     0.150
     4.417   119.129     0.150
     4.470    68.707     0.150
     4.530    69.828     0.150
     4.530    78.129     0.150
     4.530   120.930     0.150
     4.690    68.867     0.150
     4.627    71.566     0.150
     4.713    71.930     0.150
     4.713   125.289     0.150
     4.823    72.328     0.150
     4.823   127.328     0.150
     4.832    72.316     0.150
     4.924    72.777     0.150
     4.875    73.430     0.150
     4.875   126.727     0.150
     4.860    72.988     0.150
     4.860   127.309     0.150
     4.989    76.617     0.150
     5.006    74.406     0.150
     4.990    74.629     0.150
     4.950    75.430     0.150
     4.950    86.527     0.150
     4.950   131.828     0.150
     5.077    77.098     0.150
     5.122    75.617     0.150
     5.012    76.328     0.150
     5.022    76.047     0.150
     5.022   131.809     0.150
     5.170    76.906     0.150
     5.170   134.168     0.150
     5.223    80.227     0.150
     5.294    78.828     0.150
     5.294   136.828     0.150
     5.408    80.809     0.150
     5.348   135.969     0.150
     5.470    83.547     0.150
     5.491    82.129     0.150
     5.491   143.129     0.150
     5.523    82.039     0.150
     5.434    82.328     0.150
     5.583    82.227     0.150
     5.583   145.727     0.150
     5.668    83.277     0.150
     5.717    85.617     0.150
     5.716    85.500     0.150
     5.759    85.648     0.150
     5.651    84.328     0.150
     5.795    85.430     0.150
     5.854    86.328     0.150
     5.752    85.168     0.150
     5.752   148.047     0.150
     5.906    88.629     0.150
     5.921    87.828     0.150
     5.921   152.027     0.150
     5.827    86.828     0.150
     5.950    86.227     0.150
     5.950   151.629     0.150
     6.021    89.629     0.150
     6.021   158.027     0.150
     6.054    87.809     0.150
     6.105    90.328     0.150
     6.105   159.328     0.150
     6.104    90.629     0.150
     6.104   159.129     0.150
     6.014    91.328     0.150
     6.021    89.328     0.150
     6.021   155.609     0.150
     6.159    91.129     0.150
     6.172    91.328     0.150
     6.172   161.527     0.150
     6.092    89.930     0.150
     6.092   155.688     0.150
     6.206    92.727     0.150
     6.248    92.328     0.150
     6.248   163.930     0.150
     6.177    92.328     0.150
     6.244    92.129     0.150
     6.306    92.539     0.150
     6.316    92.430     0.150
     6.316   163.527     0.150
     6.337    91.047     0.150
     6.355    92.906     0.150
     6.361    93.430     0.150
     6.361   163.430     0.150
     6.297    94.129     0.150
     6.321    94.250     0.150
     6.321   163.129     0.150
     6.499    93.770     0.150
     6.569    94.387     0.150
     6.486    95.328     0.150
     6.486   166.930     0.150
     6.621    98.227     0.150
     6.618    98.129     0.150
     6.618   172.727     0.150
     6.627    97.629     0.150
     6.633    97.930     0.150
     6.607    97.629     0.150
     6.607   106.930     0.150
     6.607   111.727     0.150
     6.607   173.828     0.150
     6.691    95.867     0.150
     6.660   171.527     0.150
     6.617    97.129     0.150
     6.736    94.629     0.150
     6.704    98.027     0.150
     6.704   101.629     0.150
     6.704   112.027     0.150
     6.704   168.227     0.150
     6.745    99.129     0.150
     6.775   100.828     0.150
     6.671    98.828     0.150
     6.893   101.430     0.150
     6.783    99.289     0.150
     6.783   173.809     0.150
     6.906   103.328     0.150
     6.906   111.328     0.150
     6.906   174.027     0.150
     6.943   101.930     0.150
     6.829   100.828     0.150
     6.947   104.328     0.150
     6.973   102.129     0.150
     6.988   101.930     0.150
     6.988   130.930     0.150
     6.988   177.129     0.150
     7.009   102.430     0.150
     7.009   177.828     0.150
     7.043   103.629     0.150
     7.065   103.328     0.150
     6.945   101.328     0.150
     7.000   104.129     0.150
     7.113   104.129     0.150
     7.157   103.930     0.150
     7.173   105.828     0.150
     7.057   103.250     0.150
     7.177   104.629     0.150
     7.203   105.629     0.150
     7.207   106.629     0.150
     7.199   104.242     0.150
     7.199   182.043     0.150
     7.104   104.828     0.150
     7.195   105.328     0.150
     7.278   107.430     0.150
     7.334   106.527     0.150
     7.334   106.629     0.150
     7.352   106.566     0.150
     7.493   108.227     0.150
     7.493   189.328     0.150
     7.548   109.328     0.150
     7.597   109.629     0.150
     7.602   108.828     0.150
     7.720   112.336     0.150
     7.720   194.188     0.150
     7.720   245.012     0.150
     7.782   112.430     0.150
     7.833   113.129     0.150
     7.859   112.727     0.150
     7.783   113.328     0.150
     7.960   114.430     0.150
     7.978   114.727     0.150
     7.978   199.328     0.150
     8.040   115.328     0.150
     8.040   200.430     0.150
     8.055   118.027     0.150
     8.076   115.930     0.150
     8.076   205.930     0.150
     7.975   114.770     0.150
     8.001   115.828     0.150
     8.017   118.328     0.150
     8.237   117.227     0.150
     8.303   118.930     0.150
     8.303   207.027     0.150
     8.346   118.629     0.150
     8.346   206.828     0.150
     8.400   122.129     0.150
     8.390   122.527     0.150
     8.390   209.129     0.150
     8.390   122.527     0.150
     8.390   209.129     0.150
     8.490   120.930     0.150
     8.384   123.328     0.150
     8.472   123.430     0.150
     8.472   214.527     0.150
     8.550   121.828     0.150
     8.583   122.328     0.150
     8.583   211.930     0.150
     8.703   125.727     0.150
     8.703   218.027     0.150
     8.722   123.828     0.150
     8.722   215.527     0.150
     8.725   128.430     0.150
     8.919   131.348     0.150
     9.050   128.328     0.150
     9.133   135.527     0.150
     9.157   130.227     0.150
     9.206   132.828     0.150
     9.206   147.629     0.150
     9.212   132.727     0.150
     9.212   232.629     0.150
     9.229   132.227     0.150
     9.229   229.930     0.150
     9.229   229.828     0.150
     9.205   149.527     0.150
     9.260   134.367     0.150
     9.316   132.727     0.150
     9.316   231.629     0.150
     9.319   135.219     0.150
     9.457   137.629     0.150
     9.615   136.629     0.150
     9.615   238.328     0.150
     9.681   137.727     0.150
     9.681   240.828     0.150
     9.697   138.527     0.150
     9.697   239.129     0.150
     9.718   138.328     0.150
     9.718   240.430     0.150
     9.703   138.828     0.150
     9.703   276.328     0.150
     9.848   142.328     0.150
     9.890   141.527     0.150
     9.890   245.727     0.150
    10.038   143.828     0.150
    10.184   145.727     0.150
    10.184   254.027     0.150
    10.322   149.430     0.150
    10.627   154.340     0.150
    10.765   154.629     0.150
    10.806   155.930     0.150
    10.806   271.227     0.150
    10.916   154.527     0.150
    10.916   266.930     0.150
    11.163   157.727     0.150
    11.163   273.129     0.150
    11.462   165.629     0.150
    11.634   166.277     0.150
    11.890   170.109     0.150
    11.954   171.727     0.150
    12.598   177.328     0.150
    12.888   181.629     0.150
    12.888   185.000     0.150
    12.945   183.328     0.150
    13.599   194.609     0.150
    13.931   196.828     0.150
    14.400   202.000     0.150
    14.400   200.770     0.150
    14.414   206.328     0.150
    18.397   254.727     0.150
    18.397   456.527     0.150
    18.482   255.523     0.150
    19.223   262.227     0.150
    19.332   262.906     0.150
    19.503   267.227     0.150
    19.503   267.203     0.150
    19.607   267.328     0.150
    19.787   268.527     0.150
    20.221   276.879     0.150
    20.456   274.328     0.150
    20.456   280.727     0.150
    20.923   281.750     0.150
    21.514   293.828     0.150
    21.514   529.828     0.150
    21.514   557.828     0.150
    21.581   288.129     0.150
    28.363   352.629     0.150
    28.363   636.430     0.150
    28.464   353.859     0.150
    31.617   381.340     0.150
    31.617   380.828     0.150
    39.104   450.027     0.150
    39.252   448.930     0.150
    39.490   450.430     0.150
    45.581   502.527     0.150
    46.684   508.430     0.150
    46.684     5.648     0.150
    47.262   513.297     0.150
    47.262     5.230     0.150
    51.923   552.930     0.150
    51.923   623.930     0.150
    51.923   672.430     0.150
    51.923   996.227     0.150
    51.923  1211.930     0.150
    52.894   553.750     0.150
    56.814   583.527     0.150
    57.452   589.430     0.150
    58.418   596.527     0.150
    58.785   597.227     0.150
    59.484   602.227     0.150
    60.279   606.629     0.150
    61.270   616.727     0.150
    67.111   657.777     0.150
    68.533   661.828     0.150
    68.533     3.441     0.150
    72.911   689.348     0.150
    73.659   694.078     0.150
    73.659     3.852     0.150
    74.574   700.129     0.150
    76.132   708.227     0.150
    84.024   750.020     0.150
    89.372   777.809     0.150
    89.372     5.219     0.150
   126.743  1142.180     0.150
   126.743  1147.379     0.150
     0.366    11.850     0.150
     0.600    11.451     0.150
     0.600    21.850     0.150
     0.685    12.750     0.150
     1.009    18.150     0.150
     1.009    33.650     0.150
     1.059    19.551     0.150
     1.059    36.451     0.150
     1.060    19.350     0.150
     1.060    35.350     0.150
     1.275    22.451     0.150
     1.350    23.750     0.150
     1.380    24.551     0.150
     1.419    24.451     0.150
     1.419    45.150     0.150
     1.495    24.951     0.150
     1.673    28.150     0.150
     1.847    31.650     0.150
     2.209    36.650     0.150
     2.209    64.830     0.150
     2.212    37.350     0.150
     2.403    69.670     0.150
     2.374    37.850     0.150
     2.469    39.451     0.150
     2.465    39.500     0.150
     2.465    70.850     0.150
     2.615    41.150     0.150
     2.674    43.291     0.150
     2.674    76.051     0.150
     2.688    42.131     0.150
     2.688    76.871     0.150
     2.753    44.170     0.150
     2.753    77.680     0.150
     2.780    45.070     0.150
     2.780    78.371     0.150
     2.810    42.871     0.150
     2.810    76.291     0.150
     2.831    44.250     0.150
     3.152    50.291     0.150
     3.152    87.471     0.150
     3.196    57.850     0.150
     3.201    59.650     0.150
     3.271    51.250     0.150
     3.296    51.451     0.150
     3.296    90.871     0.150
     3.319    52.281     0.150
     3.319    90.730     0.150
     3.493    54.750     0.150
     3.550    55.650     0.150
     3.704    56.400     0.150
     3.704    98.861     0.150
     3.705    57.551     0.150
     3.783    57.551     0.150
     4.102    61.750     0.150
     4.144    62.451     0.150
     4.199    62.820     0.150
     4.199   110.861     0.150
     4.309    65.951     0.150
     4.309    73.650     0.150
     4.309   113.650     0.150
     4.325    76.150     0.150
     4.407    65.051     0.150
     4.494    68.750     0.150
     4.499    68.250     0.150
     4.764    70.350     0.150
     4.764   121.850     0.150
     4.882    70.850     0.150
     4.997    75.150     0.150
     5.214    78.051     0.150
     5.249    77.350     0.150
     5.406    80.650     0.150
     5.440    79.451     0.150
     5.440   141.850     0.150
     5.520    80.350     0.150
     5.520   143.350     0.150
     5.520    83.051     0.150
     5.833    86.250     0.150
     6.013    88.250     0.150
     6.118    89.051     0.150
     6.118   158.451     0.150
     6.160    89.451     0.150
     6.160   158.250     0.150
     6.378    92.551     0.150
     6.852    99.150     0.150
     6.852   175.051     0.150
     6.861    99.350     0.150
     7.106   101.350     0.150
     7.431   106.051     0.150
     7.464   107.650     0.150
     7.464   190.650     0.150
     7.451   106.350     0.150
     7.451   187.350     0.150
     7.601   110.951     0.150
     7.767   111.750     0.150
     8.377   118.451     0.150
     8.666   122.850     0.150
     8.666   215.051     0.150
     8.863   125.750     0.150
     8.863   220.451     0.150
     9.048   128.250     0.150
     9.048   224.850     0.150
    10.028   141.650     0.150
    10.028   247.051     0.150
     0.234     5.234     0.150
     0.234     9.734     0.150
     0.434     7.234     0.150
     0.548    19.535     0.150
     0.465     8.035     0.150
     0.527    10.734     0.150
     0.505     9.234     0.150
     0.505    17.434     0.150
     0.804    15.734     0.150
     0.739    13.434     0.150
     0.739    25.035     0.150
     0.852    14.434     0.150
     0.842    16.035     0.150
     0.944    17.934     0.150
     1.045    18.734     0.150
     1.229    21.834     0.150
     1.285    24.035     0.150
     1.189    20.934     0.150
     1.423    25.334     0.150
     1.779    31.035     0.150
     1.638    28.334     0.150
     1.930    31.334     0.150
     2.119    36.434     0.150
     2.144    36.635     0.150
     2.018    34.334     0.150
     2.301    38.035     0.150
     2.397    38.734     0.150
     2.397    69.885     0.150
     2.527    41.234     0.150
     2.865    44.914     0.150
     2.865    79.854     0.150
     2.894    47.234     0.150
     2.790    44.615     0.150
     2.790    78.205     0.150
     2.796    44.734     0.150
     2.966    47.334     0.150
     2.966    82.555     0.150
     3.141    50.875     0.150
     3.049    49.523     0.150
     3.049    84.684     0.150
     3.187    51.695     0.150
     3.192    50.434     0.150
     3.103    49.334     0.150
     3.130    49.334     0.150
     3.340    54.205     0.150
     3.248    51.574     0.150
     3.248    89.615     0.150
     3.269    51.885     0.150
     3.269    90.424     0.150
     3.335    52.785     0.150
     3.335    91.734     0.150
     3.336    52.635     0.150
     3.336    91.434     0.150
     3.464    55.334     0.150
     3.464    92.434     0.150
     3.495    54.004     0.150
     3.709    57.674     0.150
     3.709   100.824     0.150
     3.796    60.324     0.150
     3.816    59.205     0.150
     3.756    58.734     0.150
     3.769    60.734     0.150
     3.769   103.734     0.150
     3.731    58.004     0.150
     3.743    58.004     0.150
     3.939    62.004     0.150
     3.878    60.764     0.150
     3.878   105.523     0.150
     3.897    62.184     0.150
     3.897   104.314     0.150
     3.919    61.434     0.150
     3.919   107.834     0.150
     4.054    62.205     0.150
     3.989    64.023     0.150
     3.989   110.305     0.150
     4.117    64.645     0.150
     4.118    63.975     0.150
     4.149    63.654     0.150
     4.353    66.484     0.150
     4.353   115.365     0.150
     4.392    66.035     0.150
     4.392   116.334     0.150
     4.229    65.234     0.150
     4.229    68.924     0.150
     4.287    65.635     0.150
     4.442    68.215     0.150
     4.487    69.734     0.150
     4.487   119.834     0.150
     4.653    69.615     0.150
     4.728    71.535     0.150
     4.817    71.834     0.150
     4.817   123.434     0.150
     4.676    71.424     0.150
     4.847    72.434     0.150
     4.847   126.135     0.150
     4.817   126.945     0.150
     4.938    73.135     0.150
     4.963    74.234     0.150
     4.963   128.834     0.150
     4.906    75.234     0.150
     4.906   131.734     0.150
     5.127    75.564     0.150
     4.979    75.734     0.150
     4.973    75.734     0.150
     5.265    77.934     0.150
     5.265   136.734     0.150
     5.492    81.934     0.150
     5.492   142.234     0.150
     5.330    79.934     0.150
     5.393    81.734     0.150
     5.572    82.635     0.150
     5.572   141.834     0.150
     5.620    83.734     0.150
     5.708    85.375     0.150
     5.853    88.234     0.150
     5.893    87.834     0.150
     5.893   151.035     0.150
     6.113    90.934     0.150
     6.113   158.035     0.150
     6.116    90.934     0.150
     6.116   158.635     0.150
     5.980    89.064     0.150
     5.977    90.234     0.150
     6.168    90.834     0.150
     6.168   158.734     0.150
     6.048    90.654     0.150
     6.224    92.410     0.150
     6.224   163.076     0.150
     6.220    91.135     0.150
     6.220   159.635     0.150
     6.259    93.334     0.150
     6.259   162.535     0.150
     6.132    91.734     0.150
     6.306    92.434     0.150
     6.306   163.035     0.150
     6.355    92.834     0.150
     6.252    92.934     0.150
     6.401    93.434     0.150
     6.401   165.234     0.150
     6.283    94.295     0.150
     6.443    95.334     0.150
     6.635    98.635     0.150
     6.635   172.234     0.150
     6.656    98.035     0.150
     6.686    98.135     0.150
     6.686   169.334     0.150
     6.573    96.535     0.150
     6.607    97.234     0.150
     6.627    98.734     0.150
     6.784   100.234     0.150
     6.888   103.334     0.150
     6.888   174.834     0.150
     6.743    99.734     0.150
     6.789   100.734     0.150
     7.019   101.734     0.150
     7.019   178.635     0.150
     7.040   102.635     0.150
     7.040   178.035     0.150
     7.050   103.035     0.150
     7.050   178.834     0.150
     6.955   103.535     0.150
     7.014   102.615     0.150
     7.197   104.535     0.150
     7.197   182.035     0.150
     7.197   104.248     0.150
     7.197   182.346     0.150
     7.167   103.934     0.150
     7.167   181.934     0.150
     7.212   106.934     0.150
     7.074   104.734     0.150
     7.313   107.934     0.150
     7.316   106.635     0.150
     7.316   186.234     0.150
     7.491   107.734     0.150
     7.491   189.234     0.150
     7.360   109.234     0.150
     7.580   108.934     0.150
     7.580   188.234     0.150
     7.706   113.146     0.150
     7.706   193.412     0.150
     7.879   114.234     0.150
     7.879   198.535     0.150
     7.875   114.234     0.150
     8.006   116.135     0.150
     8.006   200.035     0.150
     8.065   115.834     0.150
     8.093   116.635     0.150
     8.093   203.035     0.150
     8.091   117.234     0.150
     7.985   117.734     0.150
     8.259   118.234     0.150
     8.259   208.535     0.150
     8.296   120.834     0.150
     8.296   206.834     0.150
     8.291   123.773     0.150
     8.369   118.734     0.150
     8.369   207.535     0.150
     8.316   121.734     0.150
     8.439   122.535     0.150
     8.454   213.535     0.150
     8.511   121.535     0.150
     8.354   122.234     0.150
     8.570   123.434     0.150
     8.603   122.234     0.150
     8.603   213.135     0.150
     8.564   125.234     0.150
     8.704   125.734     0.150
     8.704   218.234     0.150
     8.745   123.834     0.150
     8.745   217.834     0.150
     8.876   130.424     0.150
     8.876   130.834     0.150
     9.074   129.135     0.150
     9.074   229.334     0.150
     9.202   132.535     0.150
     9.200   137.135     0.150
     9.231   132.035     0.150
     9.231   227.734     0.150
     9.231   228.635     0.150
     9.348   233.635     0.150
     9.498   137.434     0.150
     9.645   138.734     0.150
     9.645   240.334     0.150
     9.713   139.535     0.150
     9.722   137.635     0.150
     9.722   240.334     0.150
     9.886   142.535     0.150
     9.923   140.535     0.150
    10.117   146.164     0.150
    10.367   146.635     0.150
    14.445   203.799     0.150
    18.476   255.227     0.150
    19.499   267.734     0.150
    19.499   268.049     0.150
    19.573   266.834     0.150
    20.186   277.127     0.150
    20.904   281.682     0.150
    28.451   354.285     0.150
    38.275   442.035     0.150
    39.134   450.035     0.150
    39.282   449.334     0.150
    39.520   450.334     0.150
    47.220   512.674     0.150
    68.543   662.580     0.150
    70.264   674.084     0.150
    82.159   740.434     0.150
    89.401   779.305     0.150
     0.253     6.570     0.150
     0.253    11.070     0.150
     0.400     8.273     0.150
     0.400    15.070     0.150
     0.564    11.375     0.150
     0.564    19.773     0.150
     0.743    14.672     0.150
     0.743    24.570     0.150
     0.822    16.773     0.150
     0.822    28.570     0.150
     0.903    16.875     0.150
     0.903    28.570     0.150
     1.177    21.570     0.150
     1.177    38.477     0.150
     1.185    20.273     0.150
     1.185    35.672     0.150
     1.240    22.773     0.150
     1.273    21.875     0.150
     1.412    26.273     0.150
     1.412    44.070     0.150
     1.437    25.875     0.150
     1.469    27.172     0.150
     1.463    24.773     0.150
     1.649    27.070     0.150
     1.828    31.070     0.150
     1.816    29.070     0.150
     1.949    31.312     0.150
     1.949    54.305     0.150
     1.893    31.172     0.150
     2.149    35.570     0.150
     2.234    37.477     0.150
     2.293    36.977     0.150
     2.509    40.172     0.150
     2.560    40.297     0.150
     2.560    70.875     0.150
     3.794    57.555     0.150
     3.794    98.500     0.150
     3.794   100.445     0.150
     3.923    60.586     0.150
     3.974    59.875     0.150
     4.138    62.570     0.150
     4.138   107.477     0.150
     4.519    67.477     0.150
     4.519   114.977     0.150
     5.227   132.773     0.150
     5.640    82.875     0.150
     5.863    86.977     0.150
     5.873    86.570     0.150
     5.873   148.273     0.150
     5.945    88.172     0.150
     5.945   151.070     0.150
     5.969    88.570     0.150
     5.969   151.977     0.150
     6.078   153.375     0.150
     6.112    90.672     0.150
     6.112   155.273     0.150
     6.539    96.773     0.150
     6.539   166.477     0.150
     6.569    93.875     0.150
     6.569   165.570     0.150
     6.795    96.273     0.150
     6.795   169.977     0.150
     7.113   100.977     0.150
     7.113   178.570     0.150
     7.134   179.375     0.150
     7.212   104.773     0.150
     7.412   104.977     0.150
     7.456   105.672     0.150
     7.456   185.477     0.150
     8.056   114.375     0.150
     8.056   197.875     0.150
     8.346   118.773     0.150
     8.346   205.477     0.150
     8.546   122.070     0.150
     8.546   212.672     0.150
     8.727   123.570     0.150
     8.727   213.977     0.150
     9.437   132.273     0.150
     9.437   232.672     0.150
     9.713   239.273     0.150
     9.707   137.172     0.150
     9.707   237.477     0.150
     9.803   138.172     0.150
     9.825   138.172     0.150
     9.825   241.477     0.150
    10.029   140.773     0.150
    10.029   247.172     0.150
    10.343   145.672     0.150
    10.343   254.570     0.150
     0.030     1.617     0.150
     0.030     3.219     0.150
     0.233     5.219     0.150
     0.444     8.617     0.150
     0.444    16.219     0.150
     0.444     9.117     0.150
     0.444    16.719     0.150
     0.452     8.918     0.150
     0.488     9.219     0.150
     0.488    16.316     0.150
     0.464     9.117     0.150
     0.464    16.219     0.150
     0.489     9.617     0.150
     0.518     9.219     0.150
     0.518    17.719     0.150
     0.560    10.918     0.150
     0.560    20.816     0.150
     0.813    14.617     0.150
     0.810    14.316     0.150
     0.793    15.219     0.150
     0.793    27.617     0.150
     0.935    18.816     0.150
     1.029    18.418     0.150
     1.179    21.316     0.150
     1.164    20.816     0.150
     1.299    23.809     0.150
     1.407    25.418     0.150
     1.623    28.918     0.150
     1.810    30.918     0.150
     1.917    31.816     0.150
     2.786    45.840     0.150
     2.786    81.469     0.150
     2.878    47.680     0.150
     2.964    48.777     0.150
     2.964    85.988     0.150
     3.043    49.648     0.150
     3.043    88.129     0.150
     3.245    52.918     0.150
     3.245    93.617     0.150
     3.262    52.727     0.150
     3.262    92.988     0.150
     3.333    53.688     0.150
     3.333    95.199     0.150
     3.331    53.719     0.150
     3.331    94.797     0.150
     3.707    59.578     0.150
     3.707   103.996     0.150
     3.828    59.289     0.150
     3.874    61.379     0.150
     3.874   108.137     0.150
     3.894    61.719     0.150
     3.894   108.398     0.150
     4.119    62.930     0.150
     4.216    70.395     0.150
     4.367    66.777     0.150
     4.367   117.078     0.150
     4.407   146.316     0.150
     4.470    68.617     0.150
     4.470   118.117     0.150
     4.454    68.520     0.150
     4.454   119.340     0.150
     4.735    71.148     0.150
     4.735   124.180     0.150
     4.831    73.418     0.150
     4.831   129.219     0.150
     4.898    77.418     0.150
     4.898    81.418     0.150
     4.898   131.020     0.150
     4.971    75.219     0.150
     4.971   130.316     0.150
     5.507    83.816     0.150
     5.507   145.316     0.150
     6.046    90.117     0.150
     6.046   161.117     0.150
     6.129    92.117     0.150
     6.129   162.020     0.150
     6.182    92.020     0.150
     6.182   162.418     0.150
     6.240    93.469     0.150
     6.275    94.520     0.150
     6.275   166.617     0.150
     6.414    94.020     0.150
     6.651    99.418     0.150
     6.651   174.020     0.150
     6.670    98.020     0.150
     7.034   103.418     0.150
     7.055   103.418     0.150
     7.225   104.719     0.150
     7.211   105.055     0.150
     7.211   182.645     0.150
     7.328   107.020     0.150
     7.358   108.617     0.150
     7.505   140.418     0.150
     7.505   189.918     0.150
     8.022   116.617     0.150
     8.022   202.617     0.150
     8.105   117.617     0.150
     8.385   121.316     0.150
     8.385   209.719     0.150
     8.452   121.617     0.150
     8.619   123.219     0.150
     8.619   216.020     0.150
     8.761   126.219     0.150
     8.761   219.816     0.150
     8.875   130.434     0.150
     9.510   135.816     0.150
    14.354   204.566     0.150
    20.915   281.441     0.150
    47.219   513.219     0.150
    72.924   690.617     0.150
    73.607   697.367     0.150
    89.417   778.691     0.150
     0.155     5.676     0.150
     0.155     8.074     0.150
     0.153     5.875     0.150
     0.318     6.775     0.150
     0.579    11.375     0.150
     0.762    14.475     0.150
     0.762    24.176     0.150
     0.791    14.875     0.150
     0.819    15.375     0.150
     0.819    26.475     0.150
     1.035    18.975     0.150
     1.152    20.074     0.150
     1.036    35.574     0.150
     1.036    19.074     0.150
     1.210    21.975     0.150
     1.224    22.574     0.150
     1.224    37.775     0.150
     1.164    20.574     0.150
     1.381    23.475     0.150
     1.520    26.574     0.150
     1.594    27.775     0.150
     1.540    26.275     0.150
     1.655    29.256     0.150
     1.655    49.596     0.150
     1.655    49.885     0.150
     1.988    57.875     0.150
     1.988    33.875     0.150
     2.811    44.535     0.150
     2.811    77.295     0.150
     4.074    62.275     0.150
     4.074   105.645     0.150
     4.239    65.154     0.150
     4.239   108.805     0.150
     4.304    65.375     0.150
     4.423    66.176     0.150
     4.423   115.676     0.150
     4.789    71.895     0.150
     4.789   124.336     0.150
     4.948    73.805     0.150
     4.948   126.314     0.150
     5.266    79.006     0.150
     5.266   134.465     0.150
     5.644    84.535     0.150
     5.644   145.275     0.150
     6.060    89.145     0.150
     6.060   153.535     0.150
     6.105    89.975     0.150
     6.180    91.176     0.150
     6.180   156.744     0.150
     6.557    96.375     0.150
     6.557   165.676     0.150
     6.625    96.936     0.150
     6.625   168.385     0.150
     6.934   102.176     0.150
     7.047   103.676     0.150
     7.047   177.074     0.150
     7.108   103.475     0.150
     7.271   104.074     0.150
     7.271   182.074     0.150
     7.582   107.676     0.150
     7.582   188.275     0.150
     7.602   107.574     0.150
     7.602   189.176     0.150
     7.593   109.074     0.150
     7.933   113.574     0.150
     7.933   198.574     0.150
     8.513   120.176     0.150
     8.513   210.574     0.150
     8.775   124.074     0.150
     8.775   217.676     0.150
     8.959   127.176     0.150
     8.959   222.074     0.150
     9.158   128.475     0.150
     9.158   226.176     0.150
     9.903   138.875     0.150
     9.903   242.176     0.150
    10.167   142.074     0.150
    10.167   250.176     0.150
    10.148   143.275     0.150
    10.148   251.176     0.150
    10.289   144.275     0.150
    10.289   251.875     0.150
    10.499   147.475     0.150
    10.499   259.074     0.150
    10.817   151.875     0.150
    10.817   265.574     0.150
    13.520   189.275     0.150
    19.421   264.775     0.150
     0.074     2.650     0.150
     0.074     4.650     0.150
     0.344     6.850     0.150
     0.418     9.051     0.150
     0.418    16.250     0.150
     0.463     9.051     0.150
     0.533     9.850     0.150
     0.533    10.451     0.150
     0.543     9.451     0.150
     0.543    18.951     0.150
     0.600    12.150     0.150
     0.782    15.150     0.150
     0.789    14.250     0.150
     0.816    15.951     0.150
     1.073    18.551     0.150
     1.073    35.750     0.150
     1.207    21.750     0.150
     1.259    22.041     0.150
     1.627    27.850     0.150
     1.627    49.551     0.150
     1.666    29.150     0.150
     1.635    29.750     0.150
     1.635    51.750     0.150
     1.613    29.250     0.150
     1.709    29.850     0.150
     1.755    31.451     0.150
     1.851    31.150     0.150
     2.046    34.951     0.150
     2.136    35.650     0.150
     2.136    66.451     0.150
     2.091    36.451     0.150
     2.273    38.650     0.150
     2.398    41.131     0.150
     2.398    67.061     0.150
     2.398    70.680     0.150
     2.499    41.750     0.150
     2.922    47.420     0.150
     3.792    59.061     0.150
     3.792   104.061     0.150
     4.091    63.840     0.150
     4.081    62.871     0.150
     4.211    64.650     0.150
     4.366    65.850     0.150
     4.366   116.451     0.150
     4.626    69.311     0.150
     4.730    69.420     0.150
     4.730   125.080     0.150
     4.792    72.250     0.150
     4.792   127.850     0.150
     4.909    73.650     0.150
     4.917    74.061     0.150
     5.549    82.350     0.150
     5.549   146.150     0.150
     6.002    88.650     0.150
     6.002   157.250     0.150
     6.085    89.551     0.150
     6.085   159.150     0.150
     6.088    89.850     0.150
     6.088   159.051     0.150
     6.143    90.750     0.150
     6.143   161.250     0.150
     6.231    92.250     0.150
     6.231   162.750     0.150
     6.332    90.951     0.150
     6.379    91.551     0.150
     6.606    96.951     0.150
     6.606   171.750     0.150
     6.630    94.750     0.150
     6.993   100.150     0.150
     7.014   100.551     0.150
     7.171   104.551     0.150
     7.171   182.451     0.150
     7.465   108.350     0.150
     7.465   189.650     0.150
     7.553   109.551     0.150
     7.979   113.650     0.150
     8.340   119.350     0.150
     8.340   206.250     0.150
     8.575   122.951     0.150
     8.575   212.451     0.150
     8.717   124.451     0.150
     8.717   214.451     0.150
     9.321   131.451     0.150
     9.509   233.350     0.150
     9.686   136.350     0.150
     9.693   237.350     0.150
     9.722   136.850     0.150
     9.896   138.850     0.150
     0.337     6.430     0.150
     0.389     7.727     0.150
     0.440     8.430     0.150
     0.440    16.023     0.150
     0.423     8.125     0.150
     0.494    10.227     0.150
     0.563    10.727     0.150
     0.563    18.828     0.150
     0.547    10.227     0.150
     0.677    12.727     0.150
     0.656    12.828     0.150
     0.747    12.766     0.150
     0.747    14.227     0.150
     0.758    14.430     0.150
     0.735    14.023     0.150
     0.779    14.523     0.150
     0.753    13.625     0.150
     0.789    14.625     0.150
     0.791    14.125     0.150
     0.884    16.625     0.150
     0.959    17.328     0.150
     0.994    18.523     0.150
     1.054    19.930     0.150
     1.072    19.625     0.150
     1.173    21.328     0.150
     1.315    24.430     0.150
     1.417    25.523     0.150
     1.486    26.328     0.150
     1.487    27.430     0.150
     1.590    28.125     0.150
     1.642    29.625     0.150
     1.746    30.930     0.150
     1.763    31.227     0.150
     1.809    31.523     0.150
     1.810    31.727     0.150
     1.944    34.023     0.150
     2.111    36.328     0.150
     2.230    38.125     0.150
     2.485    41.023     0.150
     2.542    43.523     0.150
     2.508    41.508     0.150
     2.573    43.125     0.150
     2.644    44.523     0.150
     2.830    46.727     0.150
     2.986    49.125     0.150
     3.045    48.703     0.150
     3.045    84.594     0.150
     3.332    52.727     0.150
     3.332    92.109     0.150
     3.360    52.930     0.150
     3.506    60.227     0.150
     3.584    55.984     0.150
     3.584    99.078     0.150
     3.550    56.766     0.150
     3.550    97.133     0.150
     3.573    56.500     0.150
     3.573    98.180     0.150
     3.702    58.719     0.150
     3.702   101.273     0.150
     3.823    59.836     0.150
     3.823   104.078     0.150
     3.846    60.414     0.150
     3.846   104.469     0.150
     3.960    61.633     0.150
     3.960   107.695     0.150
     4.247    66.328     0.150
     4.393    66.727     0.150
     4.393   116.523     0.150
     4.327    67.688     0.150
     4.327   116.477     0.150
     4.391    68.883     0.150
     4.391   117.898     0.150
     4.447    69.570     0.150
     4.447   119.180     0.150
     4.614    72.320     0.150
     4.636    71.094     0.150
     4.699   124.156     0.150
     4.771    74.125     0.150
     5.054    77.727     0.150
     5.060    76.625     0.150
     5.060   134.023     0.150
     5.084    76.648     0.150
     5.115    77.094     0.150
     5.115   133.797     0.150
     5.259    80.484     0.150
     5.283    81.773     0.150
     5.311    81.227     0.150
     5.441    82.070     0.150
     5.519    83.227     0.150
     5.519   145.727     0.150
     5.729    85.023     0.150
     5.729   148.727     0.150
     5.959    88.328     0.150
     5.959   151.328     0.150
     5.988    89.945     0.150
     5.988   155.648     0.150
     6.028    88.523     0.150
     6.028   154.523     0.150
     6.144    91.625     0.150
     6.144   161.930     0.150
     6.305    92.430     0.150
     6.305   164.227     0.150
     6.361    93.023     0.150
     6.361   160.125     0.150
     6.378    93.523     0.150
     6.378   163.125     0.150
     6.356    94.797     0.150
     6.439    95.820     0.150
     6.601    97.828     0.150
     6.601   171.727     0.150
     6.679    99.500     0.150
     6.792    99.023     0.150
     6.862   101.523     0.150
     6.862   179.023     0.150
     7.018   106.523     0.150
     7.227   104.727     0.150
     7.235   105.523     0.150
     7.235   184.227     0.150
     7.249   105.227     0.150
     7.246   106.984     0.150
     7.437   107.430     0.150
     7.437   112.523     0.150
     7.443   108.523     0.150
     7.876   113.523     0.150
     7.876   114.023     0.150
     7.876   200.328     0.150
     7.932   113.828     0.150
     8.115   118.727     0.150
     8.115   205.125     0.150
     8.175   117.023     0.150
     8.168   118.430     0.150
     8.168   206.930     0.150
     8.168   132.727     0.150
     8.276   118.430     0.150
     8.742   123.727     0.150
     9.023   129.023     0.150
     9.046   130.430     0.150
    10.373   149.227     0.150
    10.394   151.227     0.150
    12.475   176.359     0.150
    14.657   207.523     0.150
    16.016   224.758     0.150
    18.484   257.828     0.150
    18.613   260.930     0.150
    20.179   275.625     0.150
    20.179   274.227     0.150
    20.967   285.625     0.150
    21.665   290.125     0.150
    32.280   388.930     0.150
    39.004   446.812     0.150
    47.835   517.523     0.150
    52.481   555.625     0.150
    62.233   622.086     0.150
    69.083   666.969     0.150
    73.569   694.625     0.150
    76.822   711.023     0.150
     0.212     5.062     0.150
     0.277     6.766     0.150
     0.384     7.664     0.150
     0.393     8.164     0.150
     0.393    13.664     0.150
     0.439     8.461     0.150
     0.435     8.766     0.150
     0.435    15.367     0.150
     0.536    10.266     0.150
     0.536    19.664     0.150
     0.524     9.961     0.150
     0.583    11.062     0.150
     0.583    20.367     0.150
     0.583    11.664     0.150
     0.583    19.461     0.150
     0.631    11.961     0.150
     0.678    12.367     0.150
     0.678    22.164     0.150
     0.729    23.867     0.150
     0.748    13.867     0.150
     0.748    25.562     0.150
     0.764    14.164     0.150
     0.815    14.266     0.150
     0.815    27.266     0.150
     0.844    15.562     0.150
     0.886    29.664     0.150
     0.917    17.562     0.150
     0.922    16.664     0.150
     0.975    17.062     0.150
     0.955    18.164     0.150
     0.973    18.062     0.150
     0.973    32.164     0.150
     0.998    19.562     0.150
     1.043    18.266     0.150
     1.084    19.266     0.150
     1.084    35.461     0.150
     1.107    19.266     0.150
     1.115    36.766     0.150
     1.192    20.664     0.150
     1.208    20.867     0.150
     1.234    40.766     0.150
     1.314    22.562     0.150
     1.315    24.266     0.150
     1.446    25.461     0.150
     1.453    24.266     0.150
     1.453    45.062     0.150
     1.458    25.062     0.150
     1.458    47.164     0.150
     1.493    25.266     0.150
     1.614    27.961     0.150
     1.614    50.266     0.150
     1.667    30.062     0.150
     1.772    31.867     0.150
     1.849    30.367     0.150
     1.940    32.367     0.150
     2.023    58.570     0.150
     2.284    42.086     0.150
     2.439    40.266     0.150
     2.439    67.062     0.150
     2.509    43.141     0.150
     2.558    42.664     0.150
     2.531    77.625     0.150
     2.685    46.047     0.150
     2.711    43.461     0.150
     2.775    48.938     0.150
     2.804    47.617     0.150
     2.922    50.273     0.150
     3.286    55.062     0.150
     3.286    95.422     0.150
     3.349    57.055     0.150
     3.400    97.242     0.150
     4.732    69.961     0.150
     4.732   123.062     0.150
     5.017    73.742     0.150
     5.017   129.312     0.150
     5.114    76.867     0.150
     5.092   131.664     0.150
     5.765   149.242     0.150
     5.844    85.211     0.150
     5.844   149.555     0.150
     6.446   165.070     0.150
     7.013   101.562     0.150
     7.651   110.164     0.150
     7.651   192.062     0.150
     7.792   111.266     0.150
     7.792   195.961     0.150
     8.618   122.867     0.150
     8.938   127.461     0.150
     8.938   221.164     0.150
     9.147   129.766     0.150
     9.318   133.062     0.150
     9.318   230.367     0.150
     0.238     6.062     0.150
     0.238    10.164     0.150
     0.245     5.758     0.150
     0.277     6.062     0.150
     0.363     8.164     0.150
     0.363    14.164     0.150
     0.387     8.562     0.150
     0.393     8.758     0.150
     0.515    10.164     0.150
     0.515    16.859     0.150
     0.599    11.859     0.150
     0.599    21.359     0.150
     0.625    11.859     0.150
     0.625    20.359     0.150
     0.652    12.961     0.150
     0.726    13.758     0.150
     0.726    23.859     0.150
     0.772    14.359     0.150
     0.772    25.961     0.150
     0.787    14.461     0.150
     0.787    26.359     0.150
     0.778    14.664     0.150
     0.782    14.758     0.150
     0.782    26.062     0.150
     0.861    15.758     0.150
     0.861    29.164     0.150
     0.904    16.758     0.150
     0.904    30.961     0.150
     0.972    16.961     0.150
     0.959    17.664     0.150
     0.959    32.859     0.150
     1.009    17.758     0.150
     1.009    33.359     0.150
     1.031    18.359     0.150
     1.031    32.758     0.150
     1.011    18.562     0.150
     1.011    33.062     0.150
     1.072    18.664     0.150
     1.072    35.062     0.150
     1.154    37.859     0.150
     1.155    20.164     0.150
     1.153    19.758     0.150
     1.196    37.359     0.150
     1.281    22.164     0.150
     1.292    23.461     0.150
     1.301    22.461     0.150
     1.309    22.859     0.150
     1.357    22.961     0.150
     1.405    24.258     0.150
     1.388    23.664     0.150
     1.428    23.859     0.150
     1.472    25.461     0.150
     1.523    25.258     0.150
     1.579    27.164     0.150
     1.598    26.359     0.150
     1.624    27.664     0.150
     1.624    26.438     0.150
     1.624    27.164     0.150
     1.691    29.664     0.150
     1.719    28.961     0.150
     1.764    28.562     0.150
     1.811    31.062     0.150
     1.819    29.961     0.150
     1.881    31.758     0.150
     1.930    31.164     0.150
     1.980    33.164     0.150
     2.151    35.258     0.150
     2.155    34.758     0.150
     2.245    36.164     0.150
     2.260    36.359     0.150
     2.260    65.758     0.150
     2.287    36.633     0.150
     2.287    67.711     0.150
     2.321    37.258     0.150
     2.403    39.359     0.150
     2.466    39.164     0.150
     2.457    39.078     0.150
     2.457    71.172     0.150
     2.523    39.664     0.150
     2.553    40.648     0.150
     2.553    73.414     0.150
     2.581    41.859     0.150
     2.616    40.961     0.150
     2.691    42.062     0.150
     2.691    73.594     0.150
     2.739    43.359     0.150
     2.739    78.188     0.150
     2.792    43.500     0.150
     2.792    79.617     0.150
     2.834    44.562     0.150
     2.826    44.781     0.150
     2.826    79.648     0.150
     2.837    45.055     0.150
     2.837    79.828     0.150
     2.885    46.164     0.150
     2.900    44.859     0.150
     2.982    80.562     0.150
     3.017    47.359     0.150
     3.011    47.664     0.150
     3.091    47.258     0.150
     3.091    84.664     0.150
     3.199    49.750     0.150
     3.199    88.820     0.150
     3.344    52.664     0.150
     3.318    51.312     0.150
     3.378    53.312     0.150
     3.391    53.711     0.150
     3.391    93.109     0.150
     3.475    53.164     0.150
     3.531    55.258     0.150
     3.566    54.664     0.150
     3.597    55.258     0.150
     3.597    95.773     0.150
     3.654    56.664     0.150
     3.659    57.062     0.150
     3.706    55.859     0.150
     3.706   100.531     0.150
     3.721    57.758     0.150
     3.857    57.961     0.150
     3.924    60.258     0.150
     3.976    61.258     0.150
     4.000    59.359     0.150
     4.063    61.164     0.150
     4.056    61.680     0.150
     4.056    61.859     0.150
     4.056   105.164     0.150
     4.113    64.258     0.150
     4.190    63.164     0.150
     4.191    62.961     0.150
     4.191    73.859     0.150
     4.191   110.664     0.150
     4.280    63.258     0.150
     4.280   112.164     0.150
     4.372    65.258     0.150
     4.375    65.664     0.150
     4.371    65.984     0.150
     4.371   110.805     0.150
     4.429    67.867     0.150
     4.429   114.703     0.150
     4.429    67.648     0.150
     4.429   115.438     0.150
     4.445    65.859     0.150
     4.464    66.852     0.150
     4.464   114.039     0.150
     4.506    71.742     0.150
     4.537    67.000     0.150
     4.553    69.062     0.150
     4.564    66.961     0.150
     4.564   119.188     0.150
     4.568    68.039     0.150
     4.562    68.773     0.150
     4.562   115.664     0.150
     4.648    69.102     0.150
     4.648   122.227     0.150
     4.738    71.961     0.150
     4.732    69.898     0.150
     4.821    72.258     0.150
     4.983    72.758     0.150
     5.027    76.164     0.150
     5.076    74.062     0.150
     5.082    76.664     0.150
     5.170    75.461     0.150
     5.339    78.281     0.150
     5.339    78.164     0.150
     5.330    78.312     0.150
     5.330   134.672     0.150
     5.392    79.602     0.150
     5.392   141.594     0.150
     5.487    79.664     0.150
     5.504    80.258     0.150
     5.658    84.664     0.150
     5.698    81.961     0.150
     5.772    84.562     0.150
     5.800    84.664     0.150
     5.759    85.961     0.150
     5.759    86.062     0.150
     5.867    86.164     0.150
     5.854    85.758     0.150
     6.003   155.289     0.150
     6.003    88.086     0.150
     6.003    87.758     0.150
     6.003   152.258     0.150
     6.021   157.406     0.150
     6.021    88.117     0.150
     6.023    87.320     0.150
     6.104   157.773     0.150
     6.104    89.234     0.150
     6.130    89.711     0.150
     6.130   160.102     0.150
     6.151    88.164     0.150
     6.161    91.164     0.150
     6.239    89.359     0.150
     6.274   162.836     0.150
     6.274    91.641     0.150
     6.320    93.562     0.150
     6.320    92.258     0.150
     6.320   163.914     0.150
     6.353    92.562     0.150
     6.386    94.164     0.150
     6.386   161.258     0.150
     6.403    92.258     0.150
     6.403   163.961     0.150
     6.463    95.461     0.150
     6.706    97.523     0.150
     6.706   173.086     0.150
     6.706    98.062     0.150
     6.706   171.062     0.150
     6.726    95.359     0.150
     6.785    97.859     0.150
     6.889   101.461     0.150
     6.962    99.461     0.150
     6.962   173.664     0.150
     6.991   101.758     0.150
     6.991   175.461     0.150
     7.049   101.062     0.150
     7.049   175.859     0.150
     7.049   101.422     0.150
     7.049   176.922     0.150
     7.105   105.859     0.150
     7.284   102.461     0.150
     7.284   181.461     0.150
     7.304   103.461     0.150
     7.304   181.859     0.150
     7.346   105.562     0.150
     7.346   182.562     0.150
     7.449   106.758     0.150
     7.438   107.172     0.150
     7.464   105.562     0.150
     7.571   107.758     0.150
     7.623   107.758     0.150
     7.730   111.461     0.150
     7.765   115.664     0.150
     7.818   114.414     0.150
     7.992   113.461     0.150
     8.107   116.961     0.150
     8.107   201.562     0.150
     8.139   205.461     0.150
     8.178   115.664     0.150
     8.186   115.758     0.150
     8.186   201.258     0.150
     8.228   115.961     0.150
     8.228   203.664     0.150
     8.235   116.961     0.150
     8.368   123.547     0.150
     8.368   121.664     0.150
     8.399   118.664     0.150
     8.419   118.961     0.150
     8.415   118.359     0.150
     8.517   120.562     0.150
     8.517   210.664     0.150
     8.590   121.664     0.150
     8.635   122.359     0.150
     8.681   123.664     0.150
     8.716   122.859     0.150
     8.716   215.062     0.150
     8.763   215.359     0.150
     8.806   125.258     0.150
     8.899   124.961     0.150
     8.899   219.164     0.150
     9.029   146.555     0.150
     9.029   258.914     0.150
     9.140   129.359     0.150
     9.140   224.758     0.150
     9.134   130.258     0.150
     9.227   130.062     0.150
     9.608   134.961     0.150
     9.608   236.562     0.150
     9.879   137.859     0.150
     9.879   242.758     0.150
     9.885   139.664     0.150
     9.885   243.062     0.150
     9.898   138.859     0.150
     9.880   143.594     0.150
     9.880   244.016     0.150
     9.974   139.664     0.150
     9.974   245.359     0.150
     9.997   139.461     0.150
     9.997   245.461     0.150
    10.199   142.164     0.150
    10.512   147.164     0.150
    10.512   258.359     0.150
    13.910   197.562     0.150
    13.910   199.461     0.150
    18.019   250.062     0.150
    19.115   262.758     0.150
    19.334   263.461     0.150
    19.978   273.062     0.150
    20.579   276.734     0.150
    20.579   278.562     0.150
    21.241   282.359     0.150
    23.017   302.664     0.150
    46.154   503.758     0.150
    46.713   507.586     0.150
    61.058   613.180     0.150
   126.238  1140.359     0.150
     0.127     5.633     0.150
     0.177     6.328     0.150
     0.325     6.633     0.150
     0.325    12.227     0.150
     0.351     6.227     0.150
     0.351    12.430     0.150
     0.411     7.633     0.150
     0.401     7.531     0.150
     0.407     7.633     0.150
     0.407    14.031     0.150
     0.483     9.328     0.150
     0.497     9.227     0.150
     0.548     9.828     0.150
     0.654    11.828     0.150
     0.743    13.930     0.150
     0.710    12.633     0.150
     0.742    14.328     0.150
     0.771    13.133     0.150
     0.822    15.133     0.150
     0.844    15.727     0.150
     0.863    15.430     0.150
     0.908    15.633     0.150
     0.911    16.828     0.150
     0.897    15.227     0.150
     0.940    16.828     0.150
     1.066    19.227     0.150
     1.128    20.430     0.150
     1.129    20.328     0.150
     1.124    18.930     0.150
     1.109    20.531     0.150
     1.127    20.328     0.150
     1.174    21.531     0.150
     1.190    21.828     0.150
     1.206    22.328     0.150
     1.234    22.430     0.150
     1.263    22.633     0.150
     1.298    22.633     0.150
     1.254    23.430     0.150
     1.298    23.031     0.150
     1.366    24.633     0.150
     1.356    24.633     0.150
     1.392    24.633     0.150
     1.387    25.133     0.150
     1.365    24.031     0.150
     1.397    24.828     0.150
     1.393    24.031     0.150
     1.521    26.227     0.150
     1.569    27.727     0.150
     1.577    27.727     0.150
     1.557    28.133     0.150
     1.560    27.227     0.150
     1.699    30.133     0.150
     1.729    30.328     0.150
     1.811    31.531     0.150
     1.802    30.328     0.150
     1.849    30.828     0.150
     1.949    32.727     0.150
     1.946    32.133     0.150
     2.048    33.531     0.150
     2.099    35.633     0.150
     2.162    37.227     0.150
     2.242    36.328     0.150
     2.202    37.031     0.150
     2.206    36.430     0.150
     2.293    37.828     0.150
     2.293    38.328     0.150
     2.317    39.227     0.150
     2.503    40.227     0.150
     2.541    40.727     0.150
     2.542    41.828     0.150
     2.966    49.328     0.150
     3.059    48.328     0.150
     3.059    83.930     0.150
     3.304    53.328     0.150
     3.306    51.391     0.150
     3.423    53.258     0.150
     3.423    94.930     0.150
     3.530    59.031     0.150
     3.621    56.352     0.150
     3.621    99.828     0.150
     3.666    57.328     0.150
     3.666   101.289     0.150
     3.786    62.531     0.150
     3.816    62.461     0.150
     3.816   101.414     0.150
     3.857    60.141     0.150
     3.857   106.531     0.150
     3.862    58.328     0.150
     3.894    60.430     0.150
     3.894   107.789     0.150
     3.887    58.727     0.150
     3.958    61.312     0.150
     3.958   107.891     0.150
     3.994    62.180     0.150
     3.994   109.242     0.150
     4.061    61.727     0.150
     4.061   108.930     0.150
     4.081    60.828     0.150
     4.367    67.812     0.150
     4.367   118.656     0.150
     4.503    70.227     0.150
     4.503   121.672     0.150
     4.536    70.227     0.150
     4.536   122.930     0.150
     4.636    71.008     0.150
     4.739    73.227     0.150
     5.119    77.023     0.150
     5.167    77.133     0.150
     5.219    77.914     0.150
     5.219   138.547     0.150
     5.325    81.133     0.150
     5.325   138.508     0.150
     5.402    82.008     0.150
     5.402   141.203     0.150
     5.395    80.227     0.150
     5.462    81.531     0.150
     5.478    81.102     0.150
     5.575    83.031     0.150
     5.581    82.367     0.150
     5.599    81.930     0.150
     5.641    83.531     0.150
     5.632    83.828     0.150
     5.786    86.031     0.150
     5.799    86.430     0.150
     5.812    85.922     0.150
     5.812   152.664     0.150
     5.886    88.680     0.150
     5.882   150.531     0.150
     5.918    87.727     0.150
     6.014    87.930     0.150
     6.014   155.328     0.150
     6.032    88.406     0.150
     6.038    87.930     0.150
     6.038   153.930     0.150
     6.237    91.328     0.150
     6.239    91.445     0.150
     6.239   162.695     0.150
     6.295    91.859     0.150
     6.295   164.352     0.150
     6.320    92.773     0.150
     6.320   165.383     0.150
     6.420    95.531     0.150
     6.438    94.430     0.150
     6.437    94.211     0.150
     6.437   167.008     0.150
     6.554    95.961     0.150
     6.554   170.133     0.150
     6.667   100.031     0.150
     6.722   100.727     0.150
     6.740    98.648     0.150
     6.740   176.484     0.150
     6.735    98.000     0.150
     6.858   102.133     0.150
     6.886   101.328     0.150
     6.924   100.828     0.150
     7.068   106.133     0.150
     7.108   104.031     0.150
     7.446   109.227     0.150
     7.486   107.727     0.150
     7.557   109.070     0.150
     7.557   191.359     0.150
     7.577   110.328     0.150
     7.814   114.227     0.150
     7.847   114.031     0.150
     7.847   200.531     0.150
     7.920   115.430     0.150
     7.920   200.133     0.150
     7.920   115.531     0.150
     8.053   116.133     0.150
     8.094   116.328     0.150
     8.465   122.727     0.150
     8.637   122.930     0.150
     8.722   124.031     0.150
     8.803   130.031     0.150
     9.094   129.328     0.150
     9.169   129.727     0.150
     9.504   135.031     0.150
     9.519   139.531     0.150
     9.532   133.828     0.150
     9.572   137.531     0.150
     9.587   135.727     0.150
    10.104   147.828     0.150
    13.905   196.695     0.150
    21.432   286.586     0.150
    30.088   370.445     0.150
    47.881   517.656     0.150
    68.708   662.023     0.150
     0.075     3.359     0.150
     0.075     5.961     0.150
     0.222     5.461     0.150
     0.222     9.562     0.150
     0.304     6.562     0.150
     0.304    12.562     0.150
     0.281     6.156     0.150
     0.305     6.359     0.150
     0.305    11.656     0.150
     0.392     7.359     0.150
     0.392    13.656     0.150
     0.425     8.156     0.150
     0.425    14.859     0.150
     0.410     8.359     0.150
     0.410    15.156     0.150
     0.448     8.359     0.150
     0.448    14.062     0.150
     0.499     9.562     0.150
     0.499    17.656     0.150
     0.467     8.961     0.150
     0.467    16.258     0.150
     0.517     9.656     0.150
     0.530    10.258     0.150
     0.607    11.258     0.150
     0.576     9.961     0.150
     0.641    12.062     0.150
     0.696    12.758     0.150
     0.696    22.758     0.150
     0.691    12.461     0.150
     0.691    23.758     0.150
     0.754    13.258     0.150
     0.738    13.758     0.150
     0.755    13.258     0.150
     0.733    13.258     0.150
     0.818    14.961     0.150
     0.819    14.359     0.150
     0.842    16.062     0.150
     0.842    28.359     0.150
     0.844    14.562     0.150
     0.913    15.758     0.150
     0.892    16.156     0.150
     0.945    16.961     0.150
     0.950    16.562     0.150
     1.012    17.961     0.150
     1.085    18.656     0.150
     1.109    18.961     0.150
     1.062    19.258     0.150
     1.139    20.562     0.150
     1.188    21.461     0.150
     1.246    21.258     0.150
     1.213    21.656     0.150
     1.239    22.461     0.150
     1.255    23.258     0.150
     1.346    22.961     0.150
     1.393    25.562     0.150
     1.396    25.656     0.150
     1.382    23.656     0.150
     1.420    25.359     0.150
     1.499    26.461     0.150
     1.574    27.562     0.150
     1.586    27.961     0.150
     1.587    28.062     0.150
     1.557    26.859     0.150
     1.554    26.656     0.150
     1.618    28.359     0.150
     1.589    27.562     0.150
     1.637    28.062     0.150
     1.640    27.859     0.150
     1.640    50.656     0.150
     1.656    28.562     0.150
     1.737    31.062     0.150
     1.704    29.062     0.150
     1.769    29.758     0.150
     1.803    30.656     0.150
     1.857    31.758     0.150
     1.857    53.656     0.150
     1.857    31.953     0.150
     1.861    31.062     0.150
     1.919    31.758     0.150
     2.064    32.461     0.150
     2.043    34.758     0.150
     2.137    35.758     0.150
     2.154    35.156     0.150
     2.449    40.961     0.150
     2.442    40.312     0.150
     2.442    70.711     0.150
     2.658    42.359     0.150
     2.739    45.656     0.150
     2.817    44.961     0.150
     2.817    44.758     0.150
     2.817    77.359     0.150
     2.862    46.062     0.150
     2.839    45.961     0.150
     2.839    80.062     0.150
     2.872    45.133     0.150
     2.872    78.898     0.150
     2.914    46.961     0.150
     2.914    46.859     0.150
     3.014    48.258     0.150
     3.014    84.461     0.150
     3.012    49.062     0.150
     3.111    50.461     0.150
     3.098    49.258     0.150
     3.098    86.961     0.150
     3.155    49.258     0.150
     3.116    49.156     0.150
     3.124    49.961     0.150
     3.187    49.656     0.150
     3.204    49.961     0.150
     3.309    52.961     0.150
     3.296    51.859     0.150
     3.296    91.562     0.150
     3.319    51.562     0.150
     3.319    92.062     0.150
     3.310    53.062     0.150
     3.381    53.258     0.150
     3.381    94.062     0.150
     3.385    53.359     0.150
     3.385    93.656     0.150
     3.385    53.359     0.150
     3.385    93.656     0.150
     3.472    55.758     0.150
     3.465    53.656     0.150
     3.468    54.562     0.150
     3.512    55.258     0.150
     3.673    58.359     0.150
     3.755    58.461     0.150
     3.755   102.461     0.150
     3.737    58.062     0.150
     3.745    58.062     0.150
     3.766    58.562     0.150
     3.794    59.758     0.150
     3.805    58.758     0.150
     3.805    58.859     0.150
     3.844    59.461     0.150
     3.944    62.031     0.150
     3.928    60.859     0.150
     3.928   107.258     0.150
     3.946    61.258     0.150
     3.946   107.156     0.150
     3.946    61.258     0.150
     3.946   107.156     0.150
     3.967    62.656     0.150
     4.015    63.062     0.150
     4.057    62.117     0.150
     4.057   108.258     0.150
     4.057   108.359     0.150
     4.084    63.062     0.150
     4.089    61.258     0.150
     4.123    62.961     0.150
     4.160    63.562     0.150
     4.160   110.258     0.150
     4.219    68.320     0.150
     4.270    64.898     0.150
     4.270    65.062     0.150
     4.357    65.859     0.150
     4.357   115.359     0.150
     4.391    65.758     0.150
     4.391   115.961     0.150
     4.412    67.562     0.150
     4.498    68.562     0.150
     4.498    68.461     0.150
     4.498   117.562     0.150
     4.536    69.156     0.150
     4.536    69.031     0.150
     4.686    69.156     0.150
     4.686    69.258     0.150
     4.718    71.359     0.150
     4.821    71.641     0.150
     4.821   124.547     0.150
     4.867    72.461     0.150
     4.867   127.859     0.150
     4.838    72.758     0.150
     4.877    72.758     0.150
     4.864    73.258     0.150
     4.942    74.758     0.150
     4.942    74.648     0.150
     4.955    74.797     0.150
     5.010    74.195     0.150
     5.010   130.219     0.150
     5.022    74.562     0.150
     5.022    73.859     0.150
     5.022   130.062     0.150
     5.017    75.930     0.150
     5.027    75.859     0.150
     5.087    73.859     0.150
     5.119    75.258     0.150
     5.229    80.062     0.150
     5.295    78.258     0.150
     5.320    78.578     0.150
     5.320   138.000     0.150
     5.314    79.461     0.150
     5.368    80.156     0.150
     5.439    81.891     0.150
     5.489    81.695     0.150
     5.489   141.469     0.150
     5.510    80.461     0.150
     5.582    81.820     0.150
     5.582   141.219     0.150
     5.670    84.062     0.150
     5.655    83.992     0.150
     5.755    85.156     0.150
     5.757    85.461     0.150
     5.851    87.859     0.150
     5.819    86.562     0.150
     5.832    85.469     0.150
     5.872    87.758     0.150
     6.018    88.625     0.150
     6.019    90.156     0.150
     6.027    89.258     0.150
     6.081    90.242     0.150
     6.101    89.562     0.150
     6.119   156.156     0.150
     6.097    89.859     0.150
     6.171    90.633     0.150
     6.171   159.680     0.150
     6.193    91.062     0.150
     6.193   158.359     0.150
     6.202    89.977     0.150
     6.202   157.891     0.150
     6.245    92.195     0.150
     6.245   161.266     0.150
     6.239    91.461     0.150
     6.281    91.750     0.150
     6.281   160.227     0.150
     6.281    91.688     0.150
     6.281   160.297     0.150
     6.311    92.156     0.150
     6.269    93.367     0.150
     6.301    92.656     0.150
     6.301    93.156     0.150
     6.356    93.258     0.150
     6.302    93.562     0.150
     6.302    94.062     0.150
     6.326    94.156     0.150
     6.347    92.758     0.150
     6.478    95.477     0.150
     6.478   167.625     0.150
     6.491    95.156     0.150
     6.615    97.734     0.150
     6.616    93.562     0.150
     6.616   164.156     0.150
     6.655    97.469     0.150
     6.816    99.961     0.150
     6.789    99.562     0.150
     6.797   100.008     0.150
     6.834    99.852     0.150
     6.876   102.062     0.150
     6.865   101.156     0.150
     6.906   173.758     0.150
     6.983   100.758     0.150
     6.983   173.258     0.150
     6.950   100.656     0.150
     7.004   100.156     0.150
     7.004   173.656     0.150
     6.962   102.141     0.150
     6.962   102.359     0.150
     7.068   179.156     0.150
     7.062   102.461     0.150
     7.109   103.992     0.150
     7.198   103.812     0.150
     7.198   182.891     0.150
     7.198   103.547     0.150
     7.198   182.375     0.150
     7.193   104.656     0.150
     7.273   104.461     0.150
     7.273   180.156     0.150
     7.259   105.359     0.150
     7.263   106.961     0.150
     7.338   106.859     0.150
     7.327   109.484     0.150
     7.372   107.062     0.150
     7.372   185.758     0.150
     7.357   106.961     0.150
     7.491   107.758     0.150
     7.491   188.758     0.150
     7.621   112.562     0.150
     7.719   112.664     0.150
     7.726   112.461     0.150
     7.788   113.461     0.150
     7.973   112.562     0.150
     7.973   196.359     0.150
     7.980   114.758     0.150
     8.050   113.062     0.150
     8.050   198.656     0.150
     8.065   115.828     0.150
     8.065   116.758     0.150
     8.075   115.969     0.150
     8.301   119.859     0.150
     8.301   206.656     0.150
     8.308   209.359     0.150
     8.342   118.258     0.150
     8.342   205.062     0.150
     8.319   122.961     0.150
     8.395   118.258     0.150
     8.472   212.359     0.150
     8.486   120.562     0.150
     8.579   121.156     0.150
     8.579   210.961     0.150
     8.701   125.562     0.150
     8.718   123.258     0.150
     8.718   214.258     0.150
     8.718   270.156     0.150
     8.922   131.148     0.150
     8.922   131.258     0.150
     8.941   132.062     0.150
     9.065   130.258     0.150
     9.205   233.656     0.150
     9.311   130.461     0.150
     9.311   228.859     0.150
     9.508   133.859     0.150
     9.508   233.258     0.150
     9.489   134.461     0.150
     9.489   134.617     0.150
     9.611   134.859     0.150
     9.611   235.859     0.150
     9.676   135.062     0.150
     9.693   237.859     0.150
     9.713   136.562     0.150
     9.713   237.961     0.150
     9.658   140.680     0.150
     9.885   138.156     0.150
     9.885   242.156     0.150
    10.153   146.242     0.150
    10.598   150.758     0.150
    11.089   158.359     0.150
    30.651   374.883     0.150
    47.266   512.961     0.150
     0.143     5.891     0.150
     0.143     9.590     0.150
     0.199     6.590     0.150
     0.199    10.988     0.150
     0.268     7.188     0.150
     0.482    10.391     0.150
     0.707    13.891     0.150
     0.707    14.688     0.150
     0.707    25.891     0.150
     0.726    14.391     0.150
     0.844    16.188     0.150
     0.844    27.988     0.150
     0.823    15.590     0.150
     0.939    17.988     0.150
     0.964    18.590     0.150
     0.884    15.988     0.150
     0.884    28.988     0.150
     0.960    17.789     0.150
     0.983    19.289     0.150
     0.946    17.090     0.150
     0.996    18.988     0.150
     0.956    17.188     0.150
     1.062    18.988     0.150
     1.129    20.391     0.150
     1.180    20.988     0.150
     1.110    19.289     0.150
     1.158    19.988     0.150
     1.183    20.789     0.150
     1.243    21.891     0.150
     1.131    19.688     0.150
     1.205    20.488     0.150
     1.263    22.289     0.150
     1.157    20.090     0.150
     1.244    21.590     0.150
     1.415    24.188     0.150
     1.381    23.590     0.150
     1.384    23.789     0.150
     1.376    23.188     0.150
     1.495    25.590     0.150
     1.449    23.988     0.150
     1.538    26.391     0.150
     1.459    24.289     0.150
     1.502    24.891     0.150
     1.623    26.891     0.150
     1.621    26.891     0.150
     1.566    25.289     0.150
     1.688    28.988     0.150
     1.616    26.188     0.150
     1.601    26.391     0.150
     1.625    26.289     0.150
     1.638    26.391     0.150
     1.783    29.289     0.150
     1.709    27.391     0.150
     1.705    27.391     0.150
     1.763    28.188     0.150
     1.878    31.688     0.150
     1.768    28.789     0.150
     1.840    29.988     0.150
     1.931    31.590     0.150
     2.100    34.688     0.150
     2.165    35.289     0.150
     2.198    35.391     0.150
     2.081    33.688     0.150
     2.081    60.590     0.150
     2.314    35.891     0.150
     2.269    36.789     0.150
     2.269    65.688     0.150
     2.411    38.391     0.150
     2.424    37.789     0.150
     2.342    37.391     0.150
     2.342    66.789     0.150
     2.510    39.090     0.150
     2.646    40.789     0.150
     2.543    40.590     0.150
     2.543    72.391     0.150
     2.575    40.289     0.150
     2.575    72.391     0.150
     2.628    41.391     0.150
     2.628    74.090     0.150
     2.628    41.391     0.150
     2.628    74.090     0.150
     2.645    41.891     0.150
     2.645    74.891     0.150
     2.777    43.688     0.150
     2.754    41.980     0.150
     2.754    73.719     0.150
     2.910    44.590     0.150
     2.808    44.188     0.150
     2.984    45.488     0.150
     2.934    45.988     0.150
     3.076    48.391     0.150
     3.017    47.590     0.150
     3.170    48.891     0.150
     3.059    48.289     0.150
     3.099    47.859     0.150
     3.170    49.188     0.150
     3.170    87.289     0.150
     3.316    50.488     0.150
     3.190    49.590     0.150
     3.190    87.688     0.150
     3.190    49.590     0.150
     3.190    87.688     0.150
     3.283    49.391     0.150
     3.507    53.090     0.150
     3.530    53.891     0.150
     3.474    53.688     0.150
     3.629    54.438     0.150
     3.738    56.391     0.150
     3.786    57.391     0.150
     3.786    58.488     0.150
     3.769    56.789     0.150
     3.838    58.469     0.150
     4.023    60.090     0.150
     3.938    58.590     0.150
     3.971    60.688     0.150
     4.111    63.090     0.150
     4.104    61.590     0.150
     4.129    62.688     0.150
     4.254    63.590     0.150
     4.121    61.668     0.150
     4.177    62.688     0.150
     4.212    61.820     0.150
     4.246    63.488     0.150
     4.246    62.391     0.150
     4.387    64.988     0.150
     4.389    63.090     0.150
     4.360    63.488     0.150
     4.360   112.488     0.150
     4.362    63.770     0.150
     4.362   112.160     0.150
     4.345    65.090     0.150
     4.567    67.270     0.150
     4.536    70.410     0.150
     4.556    68.188     0.150
     4.702    69.109     0.150
     4.702   122.254     0.150
     4.745    69.090     0.150
     4.628    70.590     0.150
     4.816    70.328     0.150
     4.782    68.688     0.150
     4.785    71.391     0.150
     4.982    72.477     0.150
     4.982   128.793     0.150
     5.089    75.289     0.150
     5.119    73.590     0.150
     5.223    76.590     0.150
     5.111    74.551     0.150
     5.225    76.391     0.150
     5.266    78.051     0.150
     5.266    78.188     0.150
     5.361    77.828     0.150
     5.361   137.840     0.150
     5.473    79.074     0.150
     5.381    78.488     0.150
     5.642    80.891     0.150
     5.639    81.289     0.150
     5.547    82.391     0.150
     5.624    83.980     0.150
     5.868    83.789     0.150
     5.750    85.391     0.150
     5.750    84.891     0.150
     5.800    85.391     0.150
     5.821    86.270     0.150
     6.036    86.938     0.150
     6.036   154.840     0.150
     6.036    86.984     0.150
     6.055    87.535     0.150
     6.055   154.492     0.150
     5.973    86.891     0.150
     5.983    88.188     0.150
     5.988    88.789     0.150
     6.136    88.078     0.150
     6.136   157.188     0.150
     6.219    89.301     0.150
     6.156    90.918     0.150
     6.279    89.977     0.150
     6.279   160.824     0.150
     6.396    91.336     0.150
     6.396   163.508     0.150
     6.287    90.688     0.150
     6.450    94.391     0.150
     6.470    93.570     0.150
     6.470   165.320     0.150
     6.514    93.789     0.150
     6.390    93.188     0.150
     6.390    92.688     0.150
     6.397    93.820     0.150
     6.553    93.590     0.150
     6.553   165.289     0.150
     6.677    96.688     0.150
     6.848    98.715     0.150
     6.848   173.523     0.150
     6.729    97.469     0.150
     6.729    96.988     0.150
     6.789    97.367     0.150
     6.940   100.988     0.150
     6.940   171.391     0.150
     7.001   101.789     0.150
     6.942   100.688     0.150
     6.942   115.988     0.150
     6.942   172.188     0.150
     7.107   102.258     0.150
     7.107   101.188     0.150
     7.107   177.289     0.150
     7.165   175.688     0.150
     7.217   104.289     0.150
     7.404   105.617     0.150
     7.404   184.488     0.150
     7.375   109.391     0.150
     7.478   184.590     0.150
     7.356   106.289     0.150
     7.438   106.891     0.150
     7.499   184.891     0.150
     7.571   109.590     0.150
     7.587   111.188     0.150
     7.946   117.465     0.150
     7.959   114.789     0.150
     8.062   120.988     0.150
     8.186   119.398     0.150
     8.186   120.434     0.150
     8.412   206.688     0.150
     8.384   123.891     0.150
     8.681   120.391     0.150
     8.681   212.590     0.150
     8.869   216.988     0.150
     8.810   128.930     0.150
     9.064   125.789     0.150
     9.064   221.090     0.150
     9.074   131.090     0.150
     9.612   310.789     0.150
     9.612   240.789     0.150
     9.800   135.891     0.150
     9.800   238.988     0.150
     9.700   135.816     0.150
     9.883   242.391     0.150
    10.066   138.988     0.150
    10.066   245.688     0.150
    10.166   140.488     0.150
    10.186   140.289     0.150
    10.186   248.789     0.150
    12.783   178.090     0.150
    17.965   246.688     0.150
    19.377   264.297     0.150
    20.543   275.391     0.150
    28.168   348.211     0.150
    30.947   373.711     0.150
    30.947   373.090     0.150
    30.947   433.391     0.150
    31.157   375.590     0.150
    44.900   492.289     0.150
    46.008   500.461     0.150
    46.532   504.590     0.150
    59.675   599.891     0.150
    60.902   610.688     0.150
    67.883   655.090     0.150
    67.883  1188.590     0.150
    68.623   660.328     0.150
    70.546   672.488     0.150
    70.695   673.359     0.150
    72.909   686.688     0.150
    76.081   703.090     0.150
    79.799   725.891     0.150
    79.799   733.789     0.150
    82.419   740.188     0.150
    89.796   777.711     0.150
    89.789   776.699     0.150
   124.138  1134.773     0.150
     0.261     7.277     0.150
     0.261    12.176     0.150
     0.296     7.875     0.150
     0.296    13.375     0.150
     0.374     8.977     0.150
     0.374    13.977     0.150
     0.310     8.078     0.150
     0.422     9.277     0.150
     0.422    16.375     0.150
     0.532    12.176     0.150
     0.532    19.676     0.150
     0.554    11.977     0.150
     0.554    20.277     0.150
     0.562    11.578     0.150
     0.562    19.676     0.150
     0.556    11.375     0.150
     0.556    20.277     0.150
     0.672    13.277     0.150
     0.672    23.578     0.150
     0.662    12.777     0.150
     0.662    23.277     0.150
     0.623    12.375     0.150
     0.623    21.676     0.150
     0.623    21.375     0.150
     0.695    24.777     0.150
     0.626    12.375     0.150
     0.626    21.277     0.150
     0.654    13.078     0.150
     0.654    22.477     0.150
     0.770    15.176     0.150
     0.770    26.977     0.150
     0.761    14.578     0.150
     0.761    25.977     0.150
     0.764    14.578     0.150
     0.764    25.875     0.150
     0.840    29.375     0.150
     0.803    14.676     0.150
     0.803    26.375     0.150
     1.032    18.875     0.150
     0.958    17.375     0.150
     1.045    19.277     0.150
     1.048    18.277     0.150
     1.116    20.375     0.150
     1.032    18.578     0.150
     1.032    33.875     0.150
     1.045    18.578     0.150
     1.045    34.176     0.150
     1.099    19.477     0.150
     1.216    20.875     0.150
     1.248    21.078     0.150
     1.309    22.477     0.150
     1.341    22.277     0.150
     1.524    25.277     0.150
     1.524    44.578     0.150
     1.535    25.777     0.150
     1.599    26.477     0.150
     1.856    31.277     0.150
     2.059    33.977     0.150
     2.059    62.078     0.150
     2.339    37.578     0.150
     2.339    65.277     0.150
     2.488    39.875     0.150
     2.576    40.578     0.150
     2.576    70.875     0.150
     2.569    40.578     0.150
     2.569    71.277     0.150
     2.748    43.078     0.150
     2.748    75.176     0.150
     2.779    43.277     0.150
     2.779    76.078     0.150
     2.826    44.176     0.150
     2.826    77.176     0.150
     2.863    45.375     0.150
     2.863    81.875     0.150
     2.863    77.977     0.150
     2.863    77.977     0.150
     2.965    45.875     0.150
     2.965    80.176     0.150
     3.197    49.578     0.150
     3.197    84.578     0.150
     3.331    51.578     0.150
     3.331    88.977     0.150
     3.433    53.176     0.150
     3.409    52.578     0.150
     3.409    91.375     0.150
     3.455    52.875     0.150
     3.455    91.875     0.150
     3.455    52.875     0.150
     3.455    91.875     0.150
     3.651    56.676     0.150
     3.654    55.477     0.150
     3.669    56.977     0.150
     3.934    60.277     0.150
     3.923    60.227     0.150
     3.923   103.508     0.150
     3.995    60.477     0.150
     4.101    61.977     0.150
     4.127    62.477     0.150
     4.127    62.578     0.150
     4.127    61.977     0.150
     4.199    61.457     0.150
     4.199   108.496     0.150
     4.175    63.375     0.150
     4.255    65.375     0.150
     4.344    67.875     0.150
     4.344   112.875     0.150
     4.383    64.875     0.150
     4.407    63.777     0.150
     4.380    72.957     0.150
     4.476    64.578     0.150
     4.394    66.477     0.150
     4.408    66.676     0.150
     4.419    66.477     0.150
     4.442    65.277     0.150
     4.444    66.477     0.150
     4.669    69.578     0.150
     4.669   124.676     0.150
     4.756    70.578     0.150
     4.757    70.578     0.150
     4.787    71.875     0.150
     4.815    72.477     0.150
     5.038   126.477     0.150
     5.027    74.875     0.150
     5.056    73.867     0.150
     5.056   130.750     0.150
     5.072    74.777     0.150
     5.072    74.977     0.150
     5.165    75.777     0.150
     5.165   134.676     0.150
     5.183    75.531     0.150
     5.145    76.176     0.150
     5.182    75.578     0.150
     5.182    75.875     0.150
     5.166    77.176     0.150
     5.166    76.777     0.150
     5.213    76.477     0.150
     5.233    78.078     0.150
     5.231    78.316     0.150
     5.311    77.523     0.150
     5.311   138.168     0.150
     5.247    78.277     0.150
     5.247    78.176     0.150
     5.401    81.375     0.150
     5.402    79.977     0.150
     5.492    80.578     0.150
     5.572    83.676     0.150
     5.601    83.777     0.150
     5.691    82.441     0.150
     5.673    83.977     0.150
     5.739    83.078     0.150
     5.704    84.676     0.150
     5.728    84.977     0.150
     5.800    84.293     0.150
     5.800   151.008     0.150
     5.753    85.875     0.150
     5.753    85.176     0.150
     5.879    86.176     0.150
     5.882    87.078     0.150
     5.889    87.176     0.150
     5.889    86.977     0.150
     5.900    87.578     0.150
     6.001    87.176     0.150
     5.985    87.277     0.150
     5.985    87.977     0.150
     5.966    87.375     0.150
     6.035    88.375     0.150
     6.051    89.277     0.150
     6.085    89.676     0.150
     6.107    90.176     0.150
     6.147    90.477     0.150
     6.207    90.078     0.150
     6.160    90.676     0.150
     6.205    89.777     0.150
     6.162    89.875     0.150
     6.208    90.578     0.150
     6.286    92.578     0.150
     6.293    92.777     0.150
     6.326    91.477     0.150
     6.335    92.777     0.150
     6.340    92.375     0.150
     6.419    93.297     0.150
     6.419   163.961     0.150
     6.410    93.008     0.150
     6.410   162.070     0.150
     6.419    92.699     0.150
     6.472    92.676     0.150
     6.472   160.578     0.150
     6.502    94.660     0.150
     6.502   166.984     0.150
     6.523    95.051     0.150
     6.530    94.594     0.150
     6.530   166.531     0.150
     6.542    94.477     0.150
     6.542   167.176     0.150
     6.495    94.375     0.150
     6.527    94.875     0.150
     6.667    96.809     0.150
     6.691    97.516     0.150
     6.691   169.676     0.150
     6.621    95.477     0.150
     6.710    96.676     0.150
     6.710   172.777     0.150
     6.668    97.777     0.150
     6.720    97.875     0.150
     6.731    96.977     0.150
     6.799    98.477     0.150
     6.909   100.277     0.150
     6.909   177.879     0.150
     6.982    98.875     0.150
     6.982   172.875     0.150
     7.085   103.305     0.150
     7.085   179.625     0.150
     7.092   101.477     0.150
     7.092   182.277     0.150
     7.092   102.777     0.150
     7.092   101.078     0.150
     7.119   102.477     0.150
     7.092   102.777     0.150
     7.120   102.977     0.150
     7.226   102.277     0.150
     7.226   178.477     0.150
     7.344   105.777     0.150
     7.344   184.176     0.150
     7.338   107.977     0.150
     7.457   106.078     0.150
     7.457   186.277     0.150
     7.457   106.352     0.150
     7.457   186.824     0.150
     7.577   106.777     0.150
     7.577   187.277     0.150
     7.575   111.926     0.150
     7.597   106.578     0.150
     7.597   187.777     0.150
     7.628   109.578     0.150
     7.754   110.375     0.150
     7.754   194.578     0.150
     7.754   110.477     0.150
     7.792   109.777     0.150
     7.827   110.543     0.150
     7.827   112.078     0.150
     7.885   111.176     0.150
     7.885   193.977     0.150
     7.808   112.875     0.150
     7.873   111.277     0.150
     7.873   196.777     0.150
     7.835   113.578     0.150
     7.901   114.578     0.150
     8.105   118.176     0.150
     8.105   197.578     0.150
     8.243   119.176     0.150
     8.375   119.875     0.150
     8.375   119.477     0.150
     8.357   121.176     0.150
     8.424   119.277     0.150
     8.441   121.477     0.150
     8.511   120.375     0.150
     8.546   120.578     0.150
     8.546   209.676     0.150
     8.554   121.977     0.150
     8.554   215.977     0.150
     8.493   124.469     0.150
     8.493   123.375     0.150
     8.559   212.777     0.150
     8.540   123.578     0.150
     8.562   126.375     0.150
     8.562   126.477     0.150
     8.594   120.777     0.150
     8.604   122.578     0.150
     8.667   121.777     0.150
     8.779   127.676     0.150
     8.779   211.875     0.150
     8.870   123.277     0.150
     8.870   217.777     0.150
     8.836   128.875     0.150
     8.872   126.477     0.150
     8.872   127.078     0.150
     9.020   126.676     0.150
     8.998   127.676     0.150
     9.083   127.875     0.150
     9.083   223.078     0.150
     9.092   131.977     0.150
     9.124   129.777     0.150
     9.148   131.176     0.150
     9.170   133.375     0.150
     9.250   129.477     0.150
     9.250   226.477     0.150
     9.337   134.477     0.150
     9.436   133.777     0.150
     9.547   134.078     0.150
     9.565   134.207     0.150
     9.904   138.676     0.150
     9.904   242.578     0.150
     9.828   140.676     0.150
     9.925   137.277     0.150
     9.925   242.875     0.150
     9.963   140.477     0.150
    10.054   140.277     0.150
    10.054   245.875     0.150
    10.078   140.875     0.150
    10.191   142.078     0.150
    10.191   249.375     0.150
    10.232   142.977     0.150
    10.232   249.977     0.150
    10.269   143.375     0.150
    10.269   250.875     0.150
    10.301   143.578     0.150
    10.301   251.676     0.150
    10.485   146.176     0.150
    10.485   256.277     0.150
    10.786   150.477     0.150
    10.786   263.578     0.150
    10.920   151.977     0.150
    11.415   158.977     0.150
    11.415   278.176     0.150
    11.672   162.477     0.150
    11.672   284.277     0.150
    13.156   185.727     0.150
    13.808   196.977     0.150
    14.992   212.402     0.150
    15.002   207.477     0.150
    18.368   253.277     0.150
    18.530   255.277     0.150
    18.685   253.484     0.150
    19.372   263.477     0.150
    19.618   266.750     0.150
    19.740   267.176     0.150
    19.740   266.727     0.150
    20.166   274.352     0.150
    20.500   278.477     0.150
    20.945   279.777     0.150
    20.946   280.078     0.150
    26.140   330.777     0.150
    28.562   352.250     0.150
    30.758   372.875     0.150
    31.304   378.875     0.150
    31.304   435.078     0.150
    37.945   435.578     0.150
    43.414   479.875     0.150
    46.354   503.996     0.150
    46.837   507.926     0.150
    61.247   613.695     0.150
    68.212   660.277     0.150
    68.925   662.773     0.150
    70.339   671.527     0.150
    80.026   727.477     0.150
    80.026   727.477     0.150
    89.942   777.977     0.150
   126.147  1140.391     0.150
     0.265     7.070     0.150
     0.265    11.977     0.150
     0.299     7.672     0.150
     0.299    13.172     0.150
     0.313    13.672     0.150
     0.374     8.773     0.150
     0.374    15.875     0.150
     0.417     9.070     0.150
     0.417    16.570     0.150
     0.534    11.875     0.150
     0.534    19.570     0.150
     0.557    11.773     0.150
     0.557    19.977     0.150
     0.558    11.477     0.150
     0.558    20.570     0.150
     0.550    11.375     0.150
     0.550    19.570     0.150
     0.652    13.070     0.150
     0.616    12.070     0.150
     0.616    21.477     0.150
     0.672    13.172     0.150
     0.672    23.273     0.150
     0.658    12.570     0.150
     0.658    22.672     0.150
     0.620    12.273     0.150
     0.620    20.875     0.150
     0.697    23.672     0.150
     0.649    22.172     0.150
     0.772    15.070     0.150
     0.772    26.477     0.150
     0.755    14.273     0.150
     0.755    25.672     0.150
     0.758    14.672     0.150
     0.758    25.875     0.150
     0.799    14.672     0.150
     0.799    26.273     0.150
     0.833    27.172     0.150
     0.844    16.172     0.150
     0.844    29.570     0.150
     0.925    31.570     0.150
     0.941    17.672     0.150
     0.941    31.773     0.150
     0.973    16.977     0.150
     0.953    17.375     0.150
     0.953    31.172     0.150
     1.035    18.672     0.150
     1.043    18.070     0.150
     1.028    18.375     0.150
     1.028    33.672     0.150
     1.039    33.977     0.150
     1.119    20.172     0.150
     1.093    19.273     0.150
     1.194    21.570     0.150
     1.187    19.977     0.150
     1.184    20.477     0.150
     1.242    20.875     0.150
     1.278    21.977     0.150
     1.278    39.172     0.150
     1.295    21.977     0.150
     1.361    22.977     0.150
     1.373    24.172     0.150
     1.380    23.875     0.150
     1.350    22.477     0.150
     1.367    22.875     0.150
     1.447    24.875     0.150
     1.438    24.172     0.150
     1.541    25.977     0.150
     1.518    25.273     0.150
     1.572    26.773     0.150
     1.594    26.375     0.150
     1.872    30.977     0.150
     2.019    33.875     0.150
     2.034    33.672     0.150
     2.062    34.477     0.150
     2.863    77.570     0.150
     3.653    56.570     0.150
     3.653    98.672     0.150
     3.649    55.477     0.150
     3.670    57.773     0.150
     3.936    60.773     0.150
     3.990    60.672     0.150
     4.096    62.070     0.150
     4.130    62.375     0.150
     4.205    61.336     0.150
     4.205   108.492     0.150
     4.252    65.070     0.150
     4.405    66.672     0.150
     4.419    66.672     0.150
     4.444    65.172     0.150
     4.446    67.070     0.150
     4.787    72.375     0.150
     5.041   126.273     0.150
     5.062    74.227     0.150
     5.066    74.875     0.150
     5.161    76.875     0.150
     5.243    78.273     0.150
     5.396    81.375     0.150
     5.489    81.672     0.150
     5.568    83.773     0.150
     5.698    82.289     0.150
     5.668    83.875     0.150
     5.700    85.070     0.150
     5.745    82.367     0.150
     5.723    85.375     0.150
     5.877    87.070     0.150
     5.883    86.875     0.150
     5.896    87.773     0.150
     6.032    88.273     0.150
     6.047    89.477     0.150
     6.102    90.273     0.150
     6.142    90.570     0.150
     6.155    91.070     0.150
     6.159    89.570     0.150
     6.288    93.070     0.150
     6.322    91.875     0.150
     6.336    93.070     0.150
     6.425   164.961     0.150
     6.416    92.906     0.150
     6.416   163.703     0.150
     6.425    92.953     0.150
     6.476    91.672     0.150
     6.476   160.773     0.150
     6.508    94.789     0.150
     6.521    94.875     0.150
     6.616    95.477     0.150
     6.663    97.875     0.150
     6.716    97.977     0.150
     6.727    97.875     0.150
     6.739    98.672     0.150
     6.986    98.570     0.150
     6.986   172.672     0.150
     7.091   103.133     0.150
     7.115   102.977     0.150
     7.133   103.477     0.150
     7.131   104.070     0.150
     7.231   102.273     0.150
     7.231   178.875     0.150
     7.282   105.875     0.150
     7.582   187.477     0.150
     7.602   107.273     0.150
     7.602   187.977     0.150
     7.760   110.375     0.150
     7.760   194.773     0.150
     7.796   109.773     0.150
     7.796   192.070     0.150
     7.890   112.070     0.150
     7.890   194.570     0.150
     8.552   120.477     0.150
     8.552   210.477     0.150
     8.876   124.570     0.150
     8.876   218.273     0.150
     9.089   127.570     0.150
     9.089   223.477     0.150
     9.256   129.977     0.150
     9.256   227.375     0.150
     9.909   138.570     0.150
     9.909   242.773     0.150
     9.931   139.172     0.150
    10.196   142.070     0.150
    10.196   249.773     0.150
    10.275   143.570     0.150
    10.275   251.477     0.150
    11.421   159.477     0.150
    11.421   279.070     0.150
     0.045     2.836     0.150
     0.045     5.836     0.150
     0.167     4.930     0.150
     0.167     9.031     0.150
     0.232     5.531     0.150
     0.232    10.133     0.150
     0.244     5.430     0.150
     0.244    10.633     0.150
     0.298     6.234     0.150
     0.298    11.633     0.150
     0.328     6.430     0.150
     0.328    11.836     0.150
     0.394     7.336     0.150
     0.394    13.531     0.150
     0.382     7.930     0.150
     0.382    14.430     0.150
     0.449     8.234     0.150
     0.449    15.133     0.150
     0.457     8.430     0.150
     0.452     8.633     0.150
     0.525     9.633     0.150
     0.531     9.734     0.150
     0.678    12.031     0.150
     0.668    12.133     0.150
     0.663    12.031     0.150
     0.663    22.633     0.150
     0.708    12.836     0.150
     0.708    24.031     0.150
     0.817    15.531     0.150
     0.817    27.336     0.150
     0.903    17.430     0.150
     0.921    16.234     0.150
     0.921    30.336     0.150
     1.042    18.430     0.150
     1.109    20.531     0.150
     1.138    19.234     0.150
     1.173    21.531     0.150
     1.183    21.336     0.150
     1.183    37.531     0.150
     1.210    22.133     0.150
     1.223    39.234     0.150
     1.256    22.734     0.150
     1.276    23.633     0.150
     1.326    23.336     0.150
     1.376    24.430     0.150
     1.392    23.930     0.150
     1.398    25.336     0.150
     1.398    44.234     0.150
     1.424    25.133     0.150
     1.423    25.633     0.150
     1.413    25.336     0.150
     1.478    26.734     0.150
     1.528    28.234     0.150
     1.528    26.633     0.150
     1.527    26.336     0.150
     1.563    27.430     0.150
     1.614    27.930     0.150
     1.607    27.430     0.150
     1.625    28.734     0.150
     1.610    27.633     0.150
     1.644    28.836     0.150
     1.627    27.633     0.150
     1.678    29.031     0.150
     1.734    29.133     0.150
     1.774    30.633     0.150
     1.832    32.234     0.150
     1.887    32.531     0.150
     1.889    31.234     0.150
     2.020    33.531     0.150
     2.073    34.031     0.150
     2.124    36.031     0.150
     2.167    35.430     0.150
     2.228    36.336     0.150
     2.379    39.336     0.150
     2.800    44.734     0.150
     2.820    45.031     0.150
     2.820    80.031     0.150
     2.929    47.086     0.150
     2.929    80.273     0.150
     2.998    47.633     0.150
     2.998    84.133     0.150
     3.077    48.930     0.150
     3.077    86.133     0.150
     3.148    49.633     0.150
     3.148    87.836     0.150
     3.236    50.531     0.150
     3.236    90.031     0.150
     3.273    51.531     0.150
     3.273    90.734     0.150
     3.278    51.430     0.150
     3.278    90.734     0.150
     3.296    51.836     0.150
     3.296    91.234     0.150
     3.365    52.633     0.150
     3.365    93.031     0.150
     3.365    52.633     0.150
     3.365    93.031     0.150
     3.366    53.031     0.150
     3.366    93.133     0.150
     3.514    55.234     0.150
     3.740    57.734     0.150
     3.740   101.531     0.150
     3.907    60.531     0.150
     3.907   106.234     0.150
     3.927    61.234     0.150
     3.927   106.633     0.150
     3.927    61.234     0.150
     3.927   106.633     0.150
     3.964    60.766     0.150
     3.964   105.695     0.150
     4.004    62.336     0.150
     4.004    61.930     0.150
     4.074    64.336     0.150
     4.173    63.336     0.150
     4.348    66.633     0.150
     4.374    66.930     0.150
     4.440    67.633     0.150
     4.469    70.031     0.150
     4.469    66.930     0.150
     4.486    67.234     0.150
     4.807    72.336     0.150
     4.838    71.922     0.150
     4.838   160.000     0.150
     4.887    72.336     0.150
     5.004    74.086     0.150
     5.030    75.742     0.150
     5.030   131.898     0.150
     5.343    80.406     0.150
     5.343   139.766     0.150
     5.420    82.734     0.150
     5.509   144.445     0.150
     5.596    81.742     0.150
     5.596   145.891     0.150
     5.880    87.133     0.150
     5.972    88.734     0.150
     6.107    92.016     0.150
     6.107   159.172     0.150
     6.125    91.367     0.150
     6.125   160.273     0.150
     6.188    90.820     0.150
     6.188   159.320     0.150
     6.270    92.039     0.150
     6.270   162.883     0.150
     6.294    91.391     0.150
     6.294   162.359     0.150
     6.340    93.430     0.150
     6.385    93.531     0.150
     6.503    96.656     0.150
     6.503   168.359     0.150
     6.641    99.414     0.150
     6.641   170.977     0.150
     7.510   107.930     0.150
     7.510   188.836     0.150
     8.002   115.031     0.150
     8.002   200.930     0.150
     8.370   118.930     0.150
     8.370   209.336     0.150
     8.607   122.430     0.150
     8.607   213.734     0.150
     8.746   123.836     0.150
     8.746   217.031     0.150
     9.426   133.734     0.150
     9.426   234.633     0.150
     9.537   236.234     0.150
     9.640   241.234     0.150
     9.706   137.336     0.150
     9.872   247.336     0.150
     0.255     5.838     0.150
     0.255    10.438     0.150
     0.298     7.138     0.150
     0.298    12.338     0.150
     0.420     8.438     0.150
     0.420    14.538     0.150
     0.539    10.538     0.150
     0.539    18.738     0.150
     0.429     9.238     0.150
     0.429    16.738     0.150
     0.454     9.638     0.150
     0.454    16.938     0.150
     0.630    12.038     0.150
     0.630    20.738     0.150
     0.675    12.638     0.150
     0.697    12.738     0.150
     0.697    23.438     0.150
     0.742    14.038     0.150
     0.742    25.438     0.150
     0.781    14.238     0.150
     0.781    25.938     0.150
     0.819    14.238     0.150
     0.819    27.038     0.150
     0.810    15.038     0.150
     0.810    26.738     0.150
     0.875    15.638     0.150
     0.875    27.838     0.150
     0.909    16.438     0.150
     0.897    15.838     0.150
     0.856    16.038     0.150
     0.856    28.638     0.150
     0.934    16.538     0.150
     0.934    30.138     0.150
     0.975    16.838     0.150
     0.960    17.238     0.150
     1.057    18.638     0.150
     1.109    19.038     0.150
     1.021    18.438     0.150
     1.030    18.838     0.150
     1.105    19.238     0.150
     1.144    20.138     0.150
     1.123    19.738     0.150
     1.256    22.438     0.150
     1.257    21.438     0.150
     1.169    20.638     0.150
     1.260    21.938     0.150
     1.313    22.738     0.150
     1.344    23.038     0.150
     1.344    40.438     0.150
     1.392    24.438     0.150
     1.337    23.138     0.150
     1.388    23.538     0.150
     1.514    25.838     0.150
     1.547    27.138     0.150
     1.547    27.338     0.150
     1.503    25.538     0.150
     1.694    28.538     0.150
     1.671    27.938     0.150
     1.757    28.838     0.150
     1.826    30.138     0.150
     1.972    31.138     0.150
     1.985    31.268     0.150
     1.985    53.918     0.150
     1.985    34.038     0.150
     1.997    37.138     0.150
     2.358    37.938     0.150
     2.384    38.538     0.150
     2.384    69.338     0.150
     2.664    43.348     0.150
     2.664    74.018     0.150
     2.710    42.308     0.150
     2.710    74.398     0.150
     2.649    42.838     0.150
     2.649    76.438     0.150
     2.712    43.338     0.150
     2.712    77.438     0.150
     2.795    44.838     0.150
     2.795    79.938     0.150
     2.837    44.938     0.150
     2.837    80.538     0.150
     2.851    45.538     0.150
     2.851    81.138     0.150
     2.893    45.938     0.150
     2.885    45.538     0.150
     2.885    82.338     0.150
     2.934    46.238     0.150
     2.934    82.538     0.150
     2.934    46.238     0.150
     2.934    82.538     0.150
     3.158    50.738     0.150
     3.215    51.338     0.150
     3.215    88.938     0.150
     3.296    51.838     0.150
     3.296    91.738     0.150
     3.426    52.638     0.150
     3.474    54.938     0.150
     3.474    96.138     0.150
     3.488    54.738     0.150
     3.488    96.238     0.150
     3.488    54.738     0.150
     3.488    96.238     0.150
     3.564    56.438     0.150
     3.627    55.338     0.150
     3.627    96.338     0.150
     3.737    57.318     0.150
     3.737    96.658     0.150
     3.921    58.238     0.150
     3.948    59.438     0.150
     3.904    60.838     0.150
     3.973    60.138     0.150
     3.990    60.638     0.150
     4.040    61.038     0.150
     4.046    61.138     0.150
     4.126    61.058     0.150
     4.126   108.898     0.150
     4.210    62.838     0.150
     4.141    64.288     0.150
     4.141   108.828     0.150
     4.326    65.738     0.150
     4.366    65.638     0.150
     4.406    67.038     0.150
     4.457    74.138     0.150
     4.428    67.618     0.150
     4.428   114.678     0.150
     4.433    67.138     0.150
     4.447    67.038     0.150
     4.522    68.548     0.150
     4.523    69.138     0.150
     4.549    72.038     0.150
     4.549   119.218     0.150
     4.596    67.438     0.150
     4.669    69.338     0.150
     4.700    71.238     0.150
     4.786    71.438     0.150
     4.786   122.038     0.150
     4.668    71.438     0.150
     4.761    70.308     0.150
     4.761   125.388     0.150
     4.709    71.238     0.150
     4.806    71.238     0.150
     4.913    72.638     0.150
     4.913   128.538     0.150
     4.923    75.038     0.150
     5.077    75.938     0.150
     5.285    77.238     0.150
     5.285   137.238     0.150
     5.373    78.838     0.150
     5.400    79.338     0.150
     5.400   139.738     0.150
     5.396    80.438     0.150
     5.444    80.438     0.150
     5.517    82.138     0.150
     5.545    83.038     0.150
     5.729    86.338     0.150
     6.012    88.238     0.150
     6.012   156.838     0.150
     6.012    88.398     0.150
     6.024    88.138     0.150
     5.983    89.738     0.150
     6.060    88.338     0.150
     6.060   156.738     0.150
     6.095    89.538     0.150
     6.125    89.338     0.150
     6.125   160.038     0.150
     6.166    90.138     0.150
     6.166   155.038     0.150
     6.071    90.438     0.150
     6.260    92.238     0.150
     6.260   163.538     0.150
     6.175    92.138     0.150
     6.241    93.038     0.150
     6.248    92.138     0.150
     6.502    95.038     0.150
     6.502   168.338     0.150
     6.649    97.438     0.150
     6.682    98.038     0.150
     6.682   170.338     0.150
     6.706    98.038     0.150
     6.643    98.138     0.150
     6.895    99.738     0.150
     6.895   172.338     0.150
     7.067   101.413     0.150
     7.067   176.436     0.150
     7.052   103.338     0.150
     7.052   178.638     0.150
     7.225   102.738     0.150
     7.225   180.538     0.150
     7.245   102.638     0.150
     7.245   180.538     0.150
     7.363   105.338     0.150
     7.363   184.038     0.150
     7.496   108.738     0.150
     7.480   109.348     0.150
     7.480   187.023     0.150
     7.556   108.938     0.150
     7.734   114.813     0.150
     8.049   114.938     0.150
     8.133   201.738     0.150
     8.177   115.738     0.150
     8.177   202.938     0.150
     8.349   119.438     0.150
     8.479   119.838     0.150
     8.479   210.038     0.150
     8.601   121.538     0.150
     8.685   122.438     0.150
     8.685   214.838     0.150
     8.860   123.338     0.150
     8.860   218.938     0.150
     9.534   135.138     0.150
     9.534   235.138     0.150
     9.550   134.138     0.150
     9.550   235.438     0.150
     9.670   136.238     0.150
     9.670   238.538     0.150
     9.826   137.338     0.150
     9.826   242.538     0.150
     9.844   139.638     0.150
     9.916   138.838     0.150
     9.941   139.838     0.150
    10.138   142.638     0.150
    20.635   281.288     0.150
     0.218     5.488     0.150
     0.218     9.488     0.150
     0.342     7.588     0.150
     0.342    13.288     0.150
     0.366     8.088     0.150
     0.366    14.388     0.150
     0.362     7.088     0.150
     0.362    12.888     0.150
     0.532    10.088     0.150
     0.532    16.788     0.150
     0.608    11.988     0.150
     0.604    11.648     0.150
     0.604    20.588     0.150
     0.647    11.988     0.150
     0.747    13.988     0.150
     0.747    24.188     0.150
     0.747    25.168     0.150
     0.789    14.488     0.150
     0.789    26.518     0.150
     0.780    14.688     0.150
     0.780    25.188     0.150
     0.780    26.138     0.150
     0.800    14.388     0.150
     0.800    26.688     0.150
     0.870    15.688     0.150
     0.870    28.488     0.150
     0.884    16.388     0.150
     0.939    16.888     0.150
     0.926    15.988     0.150
     0.980    18.488     0.150
     0.980    32.088     0.150
     0.991    17.138     0.150
     1.008    17.688     0.150
     1.013    18.788     0.150
     1.009    17.188     0.150
     1.009    18.168     0.150
     1.051    18.488     0.150
     1.148    19.188     0.150
     1.148    20.178     0.150
     1.160    20.888     0.150
     1.154    20.688     0.150
     1.288    22.988     0.150
     1.283    22.688     0.150
     1.275    22.688     0.150
     1.349    24.488     0.150
     1.373    23.888     0.150
     1.370    23.988     0.150
     1.426    24.588     0.150
     1.425    24.088     0.150
     1.455    24.888     0.150
     1.501    27.488     0.150
     1.494    26.988     0.150
     1.469    25.288     0.150
     1.516    25.888     0.150
     1.601    27.788     0.150
     1.605    27.588     0.150
     1.592    27.088     0.150
     1.595    26.988     0.150
     1.647    28.988     0.150
     1.646    27.088     0.150
     1.698    29.388     0.150
     1.711    29.988     0.150
     1.739    28.888     0.150
     1.751    29.588     0.150
     1.784    30.488     0.150
     1.759    29.488     0.150
     1.766    28.988     0.150
     1.834    31.588     0.150
     1.874    30.888     0.150
     1.829    30.388     0.150
     1.903    31.188     0.150
     1.903    32.158     0.150
     1.910    30.888     0.150
     1.926    35.688     0.150
     1.922    31.488     0.150
     1.977    33.788     0.150
     2.017    33.988     0.150
     2.133    35.488     0.150
     2.118    34.388     0.150
     2.242    36.288     0.150
     2.265    36.588     0.150
     2.267    37.188     0.150
     2.267    66.188     0.150
     2.410    39.688     0.150
     2.440    39.388     0.150
     2.440    70.688     0.150
     2.486    39.688     0.150
     2.491    40.588     0.150
     2.533    40.588     0.150
     2.533    73.088     0.150
     2.540    40.688     0.150
     2.540    40.688     0.150
     2.595    41.588     0.150
     2.595    74.188     0.150
     2.627    42.488     0.150
     2.627    75.188     0.150
     2.622    41.588     0.150
     2.608    42.588     0.150
     2.671    42.988     0.150
     2.679    43.288     0.150
     2.679    76.588     0.150
     2.701    42.388     0.150
     2.701    74.788     0.150
     2.702    42.588     0.150
     2.702    43.988     0.150
     2.721    43.788     0.150
     2.721    77.188     0.150
     2.725    43.488     0.150
     2.735    44.088     0.150
     2.735    77.588     0.150
     2.745    43.388     0.150
     2.771    44.088     0.150
     2.771    78.588     0.150
     2.810    44.588     0.150
     2.810    79.288     0.150
     2.817    44.788     0.150
     2.817    79.588     0.150
     2.817    44.788     0.150
     2.817    79.588     0.150
     2.837    44.688     0.150
     2.845    45.138     0.150
     2.905    47.088     0.150
     2.879    46.088     0.150
     2.986    47.688     0.150
     2.992    47.488     0.150
     3.087    49.388     0.150
     3.099    49.188     0.150
     3.099    86.688     0.150
     3.145    49.288     0.150
     3.183    50.288     0.150
     3.183    88.288     0.150
     3.254    51.188     0.150
     3.254    52.168     0.150
     3.323    51.088     0.150
     3.358    52.788     0.150
     3.358    93.288     0.150
     3.365    52.988     0.150
     3.372    52.988     0.150
     3.372    93.288     0.150
     3.372    52.988     0.150
     3.372    93.288     0.150
     3.456    54.588     0.150
     3.603    55.388     0.150
     3.603    96.588     0.150
     3.677    98.548     0.150
     3.709    57.088     0.150
     3.802    56.788     0.150
     3.802   101.088     0.150
     3.915    58.888     0.150
     3.920    59.688     0.150
     3.929    59.588     0.150
     3.929   104.188     0.150
     3.934    60.188     0.150
     3.909    60.288     0.150
     4.012    59.688     0.150
     4.163    64.788     0.150
     4.200    63.288     0.150
     4.242    64.988     0.150
     4.293    66.788     0.150
     4.306    63.888     0.150
     4.299    65.588     0.150
     4.331    66.688     0.150
     4.350    66.188     0.150
     4.423    68.588     0.150
     4.571    67.188     0.150
     4.571    68.168     0.150
     4.540    69.288     0.150
     4.642    68.788     0.150
     4.657    69.218     0.150
     4.657   124.155     0.150
     4.665    68.988     0.150
     4.696    69.088     0.150
     4.744    71.188     0.150
     4.764    69.788     0.150
     4.785    71.083     0.150
     4.804    70.288     0.150
     4.915    72.867     0.150
     4.915   131.663     0.150
     4.893   124.788     0.150
     5.064    76.288     0.150
     5.281    79.588     0.150
     5.303    77.918     0.150
     5.303   138.678     0.150
     5.345    78.571     0.150
     5.404    79.511     0.150
     5.536    82.188     0.150
     5.901    88.688     0.150
     5.930    88.588     0.150
     6.012    87.143     0.150
     6.012   157.015     0.150
     6.027    88.313     0.150
     6.027   157.125     0.150
     5.991    89.888     0.150
     6.036    89.354     0.150
     6.036   157.309     0.150
     6.119    90.132     0.150
     6.119   160.560     0.150
     6.161    90.181     0.150
     6.161   160.854     0.150
     6.261    89.688     0.150
     6.261   156.988     0.150
     6.289    91.404     0.150
     6.289   164.226     0.150
     6.394    94.788     0.150
     6.533    95.680     0.150
     6.533   170.713     0.150
     6.565    97.488     0.150
     6.723    99.044     0.150
     6.723   175.992     0.150
     6.749    96.488     0.150
     6.749   169.388     0.150
     6.808    97.388     0.150
     6.808   170.188     0.150
     6.989   103.388     0.150
     7.305   105.188     0.150
     7.305   182.988     0.150
     7.325   105.188     0.150
     7.325   183.988     0.150
     7.355   105.388     0.150
     7.355   183.788     0.150
     7.358   107.688     0.150
     7.645   109.288     0.150
     8.249   116.988     0.150
     8.249   205.788     0.150
     8.536   120.988     0.150
     8.536   212.388     0.150
     8.734   124.388     0.150
     8.734   217.988     0.150
     8.918   126.388     0.150
     8.918   221.888     0.150
     9.590   237.588     0.150
     9.629   135.388     0.150
     9.629   238.388     0.150
     9.732   137.188     0.150
     9.732   241.488     0.150
     9.904   139.488     0.150
     9.900   139.388     0.150
     9.900   244.488     0.150
     9.995   140.388     0.150
     9.995   246.788     0.150
    10.221   143.688     0.150
    10.221   251.288     0.150
    10.640   149.988     0.150
     0.053     2.727     0.150
     0.053     5.427     0.150
     0.292     5.847     0.150
     0.256    10.727     0.150
     0.376     6.917     0.150
     0.336     7.667     0.150
     0.336    12.927     0.150
     0.314     6.777     0.150
     0.314    12.127     0.150
     0.306    12.527     0.150
     0.426     8.337     0.150
     0.426    15.127     0.150
     0.476     9.627     0.150
     0.476    17.127     0.150
     0.555    10.747     0.150
     0.598    10.917     0.150
     0.540    10.167     0.150
     0.540    18.827     0.150
     0.542    10.807     0.150
     0.580    11.027     0.150
     0.664    12.167     0.150
     0.706    12.327     0.150
     0.749    13.607     0.150
     0.736    13.207     0.150
     0.803    14.427     0.150
     0.820    14.797     0.150
     0.825    14.887     0.150
     0.824    14.447     0.150
     0.789    15.027     0.150
     0.789    14.667     0.150
     0.821    14.627     0.150
     0.821    15.427     0.150
     0.832    15.577     0.150
     0.839    15.327     0.150
     0.898    15.847     0.150
     0.888    16.127     0.150
     0.888    15.557     0.150
     0.938    17.327     0.150
     0.938    17.827     0.150
     1.084    19.227     0.150
     1.084    19.357     0.150
     1.065    19.127     0.150
     1.150    19.907     0.150
     1.091    19.427     0.150
     1.091    19.817     0.150
     1.144    19.817     0.150
     1.133    20.527     0.150
     1.133    20.367     0.150
     1.144    21.027     0.150
     1.144    21.377     0.150
     1.229    21.527     0.150
     1.229    21.827     0.150
     1.222    21.127     0.150
     1.222    20.737     0.150
     1.210    21.327     0.150
     1.341    23.927     0.150
     1.341    23.447     0.150
     1.259    23.327     0.150
     1.270    23.317     0.150
     1.294    22.797     0.150
     1.351    24.377     0.150
     1.351    43.687     0.150
     1.342    24.327     0.150
     1.342    43.027     0.150
     1.382    25.267     0.150
     1.476    26.837     0.150
     1.498    27.327     0.150
     1.498    27.147     0.150
     1.422    25.827     0.150
     1.422    44.427     0.150
     1.422    25.567     0.150
     1.448    25.727     0.150
     1.520    27.027     0.150
     1.656    30.347     0.150
     1.656    51.927     0.150
     1.656    30.127     0.150
     1.588    29.367     0.150
     1.638    52.187     0.150
     1.638    28.427     0.150
     1.674    30.377     0.150
     1.759    31.727     0.150
     1.774    30.827     0.150
     1.764    31.927     0.150
     1.764    31.237     0.150
     1.829    30.927     0.150
     1.741    30.027     0.150
     1.867    32.627     0.150
     1.845    31.527     0.150
     1.950    36.927     0.150
     1.877    32.027     0.150
     1.996    36.327     0.150
     2.021    36.527     0.150
     1.975    34.427     0.150
     2.152    37.627     0.150
     2.152    37.287     0.150
     2.283    39.927     0.150
     2.322    40.527     0.150
     2.391    40.527     0.150
     2.426    41.227     0.150
     2.426    40.027     0.150
     2.426    68.847     0.150
     2.561    44.027     0.150
     2.575    45.027     0.150
     2.607    42.627     0.150
     2.648    43.327     0.150
     2.648    73.727     0.150
     2.648    43.607     0.150
     2.648    42.327     0.150
     2.740    46.827     0.150
     2.887    45.717     0.150
     2.887    93.847     0.150
     2.964    48.827     0.150
     2.927    47.827     0.150
     2.927    85.827     0.150
     2.956    47.527     0.150
     2.956    82.327     0.150
     2.956    47.727     0.150
     3.003    47.487     0.150
     3.003    84.847     0.150
     3.041    52.127     0.150
     3.080    52.327     0.150
     3.081    49.327     0.150
     3.174    54.627     0.150
     3.187    54.027     0.150
     3.147    50.827     0.150
     3.147    90.927     0.150
     3.170    50.927     0.150
     3.170    91.027     0.150
     3.170    51.127     0.150
     3.216    51.227     0.150
     3.258    53.627     0.150
     3.254    52.327     0.150
     3.254    93.727     0.150
     3.306    53.427     0.150
     3.306    94.427     0.150
     3.317    53.527     0.150
     3.317    94.927     0.150
     3.317    53.027     0.150
     3.383    52.437     0.150
     3.398    53.407     0.150
     3.371    53.927     0.150
     3.371    96.027     0.150
     3.418    54.827     0.150
     3.418    96.827     0.150
     3.443    54.427     0.150
     3.443    94.327     0.150
     3.443    54.727     0.150
     3.443    94.427     0.150
     3.443    55.027     0.150
     3.443    97.927     0.150
     3.443    54.657     0.150
     3.443    93.897     0.150
     3.523    57.327     0.150
     3.552    59.527     0.150
     3.511    56.727     0.150
     3.559    57.127     0.150
     3.559    57.527     0.150
     3.721    61.707     0.150
     3.698    58.127     0.150
     3.698   101.327     0.150
     3.698    98.967     0.150
     3.698    57.827     0.150
     3.698    57.037     0.150
     3.835    61.427     0.150
     3.843    62.727     0.150
     3.780    60.427     0.150
     3.780   106.327     0.150
     3.795    59.277     0.150
     3.923    61.827     0.150
     3.922    62.027     0.150
     3.922   109.227     0.150
     3.922    60.667     0.150
     3.922   103.947     0.150
     3.925    62.527     0.150
     3.925   109.027     0.150
     4.001    64.127     0.150
     3.969    61.827     0.150
     4.021    64.427     0.150
     3.988    63.527     0.150
     3.988   111.027     0.150
     4.073    64.027     0.150
     4.115    69.127     0.150
     4.043    64.427     0.150
     4.043   112.427     0.150
     4.052    62.927     0.150
     4.052    69.177     0.150
     4.159    63.127     0.150
     4.134    63.827     0.150
     4.134    63.227     0.150
     4.149    64.427     0.150
     4.149    64.187     0.150
     4.218    68.127     0.150
     4.215    68.827     0.150
     4.240    65.627     0.150
     4.240    65.827     0.150
     4.262    66.327     0.150
     4.328    66.447     0.150
     4.328   117.787     0.150
     4.318    67.127     0.150
     4.449    67.407     0.150
     4.407    68.627     0.150
     4.407   119.597     0.150
     4.419    68.027     0.150
     4.448    69.127     0.150
     4.588    68.127     0.150
     4.574    69.427     0.150
     4.529    69.727     0.150
     4.611    68.947     0.150
     4.611   121.857     0.150
     4.659    70.327     0.150
     4.659   123.927     0.150
     4.623   123.777     0.150
     4.659    70.827     0.150
     4.682    73.027     0.150
     4.718    71.927     0.150
     4.718    71.807     0.150
     4.718   123.287     0.150
     4.718    71.627     0.150
     4.753    71.927     0.150
     4.740    72.817     0.150
     4.740   124.817     0.150
     4.744    73.027     0.150
     4.796    74.527     0.150
     4.808    74.727     0.150
     4.808    74.137     0.150
     4.808   126.257     0.150
     4.873    72.847     0.150
     4.873   129.007     0.150
     4.870    74.617     0.150
     4.870   129.117     0.150
     4.922    75.527     0.150
     4.922   131.147     0.150
     4.983    76.427     0.150
     5.006    75.727     0.150
     5.033    75.227     0.150
     5.038    76.327     0.150
     5.068    77.227     0.150
     5.095    77.427     0.150
     5.184    79.037     0.150
     5.184   135.777     0.150
     5.244    80.127     0.150
     5.275    79.927     0.150
     5.337    79.112     0.150
     5.326    79.327     0.150
     5.326    79.227     0.150
     5.428    80.927     0.150
     5.361    80.827     0.150
     5.456    81.167     0.150
     5.456   144.797     0.150
     5.449    79.927     0.150
     5.434    82.827     0.150
     5.497    81.047     0.150
     5.497   146.483     0.150
     5.453    84.497     0.150
     5.453   143.887     0.150
     5.532    83.008     0.150
     5.532   147.018     0.150
     5.486    83.327     0.150
     5.572    82.627     0.150
     5.542    82.827     0.150
     5.626    84.027     0.150
     5.658    85.727     0.150
     5.718    87.327     0.150
     5.735    85.827     0.150
     5.735    85.627     0.150
     5.846    86.727     0.150
     5.840    86.062     0.150
     5.840   153.050     0.150
     5.826    87.657     0.150
     5.826   151.527     0.150
     5.826    87.527     0.150
     5.865    89.127     0.150
     5.946    89.127     0.150
     5.900    87.027     0.150
     5.909    89.727     0.150
     5.941    90.827     0.150
     6.011    91.092     0.150
     6.011   157.969     0.150
     5.988    89.327     0.150
     6.011    90.927     0.150
     6.083    89.192     0.150
     6.045    91.457     0.150
     6.045   157.137     0.150
     6.045    91.327     0.150
     6.066    91.227     0.150
     6.175    89.827     0.150
     6.175   157.527     0.150
     6.121    92.727     0.150
     6.128    92.527     0.150
     6.133    92.227     0.150
     6.153    92.827     0.150
     6.155    92.927     0.150
     6.249    93.327     0.150
     6.189    93.527     0.150
     6.193    91.427     0.150
     6.313    94.227     0.150
     6.313    93.917     0.150
     6.313    94.727     0.150
     6.349    94.927     0.150
     6.358    94.327     0.150
     6.370    95.527     0.150
     6.371    95.327     0.150
     6.447    96.527     0.150
     6.535   100.643     0.150
     6.535   171.608     0.150
     6.489    96.527     0.150
     6.603    96.627     0.150
     6.603   167.327     0.150
     6.514    96.527     0.150
     6.587    97.506     0.150
     6.587   173.677     0.150
     6.632    97.327     0.150
     6.632   172.227     0.150
     6.548    97.227     0.150
     6.617    99.795     0.150
     6.556    98.527     0.150
     6.568    99.227     0.150
     6.602    97.827     0.150
     6.590    97.827     0.150
     6.669    99.747     0.150
     6.669   171.297     0.150
     6.605    98.327     0.150
     6.692    99.619     0.150
     6.692   174.381     0.150
     6.688    98.227     0.150
     6.688   173.878     0.150
     6.673    99.927     0.150
     6.757   101.157     0.150
     6.757   177.110     0.150
     6.707    99.727     0.150
     6.723   100.007     0.150
     6.723   174.347     0.150
     6.732   100.427     0.150
     6.778    98.731     0.150
     6.791   100.327     0.150
     6.815   100.827     0.150
     6.977   105.727     0.150
     6.977   176.327     0.150
     6.895   102.727     0.150
     6.999   104.857     0.150
     6.999   181.852     0.150
     6.999   106.827     0.150
     6.988   103.615     0.150
     6.988   181.229     0.150
     6.937   102.827     0.150
     7.006   104.327     0.150
     7.112   106.155     0.150
     7.112   184.857     0.150
     7.191   107.447     0.150
     7.117   104.127     0.150
     7.379   107.527     0.150
     7.379   137.227     0.150
     7.379   186.427     0.150
     7.400   187.027     0.150
     7.400   232.627     0.150
     7.379   107.827     0.150
     7.379   185.727     0.150
     7.471   108.527     0.150
     7.471   139.127     0.150
     7.471   189.127     0.150
     7.385   109.027     0.150
     7.465   111.577     0.150
     7.441   111.027     0.150
     7.434   109.227     0.150
     7.540   192.527     0.150
     7.588   195.397     0.150
     7.629   112.427     0.150
     7.629   192.827     0.150
     7.548   110.327     0.150
     7.601   114.027     0.150
     7.601   110.957     0.150
     7.591   111.727     0.150
     7.643   113.127     0.150
     7.709   110.797     0.150
     7.709   195.767     0.150
     7.717   111.387     0.150
     7.717   194.827     0.150
     7.717   111.373     0.150
     7.717   194.827     0.150
     7.708   115.227     0.150
     7.813   115.027     0.150
     7.813   197.827     0.150
     7.915   114.327     0.150
     7.888   115.227     0.150
     7.914   118.527     0.150
     7.947   115.327     0.150
     7.947   202.527     0.150
     8.011   114.987     0.150
     8.011   114.827     0.150
     8.011   202.327     0.150
     7.978   117.627     0.150
     7.979   115.927     0.150
     7.997   118.127     0.150
     8.083   118.827     0.150
     8.084   119.127     0.150
     8.210   118.847     0.150
     8.210   205.922     0.150
     8.210   117.627     0.150
     8.210   207.227     0.150
     8.202   121.527     0.150
     8.288   124.427     0.150
     8.386   119.927     0.150
     8.386   210.727     0.150
     8.397   120.627     0.150
     8.397   155.127     0.150
     8.397   210.327     0.150
     8.328   122.527     0.150
     8.382   122.087     0.150
     8.382   121.927     0.150
     8.414   123.127     0.150
     8.411   124.527     0.150
     8.495   125.827     0.150
     8.565   124.627     0.150
     8.685   124.427     0.150
     8.685   217.327     0.150
     8.659   126.527     0.150
     8.736   125.427     0.150
     8.807   126.827     0.150
     8.807   162.627     0.150
     8.807   220.127     0.150
     8.786   130.427     0.150
     8.786   127.127     0.150
     8.786   224.627     0.150
     8.815   125.727     0.150
     8.796   128.827     0.150
     8.908   131.077     0.150
     8.865   129.027     0.150
     8.962   128.167     0.150
     8.962   225.967     0.150
     8.965   132.027     0.150
     9.060   129.627     0.150
     9.060   225.727     0.150
     8.983   130.927     0.150
     8.989   131.727     0.150
     8.991   130.727     0.150
     9.053   133.837     0.150
     9.082   132.027     0.150
     9.087   134.277     0.150
     9.087   133.027     0.150
     9.097   131.427     0.150
     9.224   132.527     0.150
     9.224   231.827     0.150
     9.179   134.027     0.150
     9.256   136.127     0.150
     9.266   133.427     0.150
     9.355   134.527     0.150
     9.333   136.827     0.150
     9.401   138.027     0.150
     9.395   135.527     0.150
     9.405   135.427     0.150
     9.435   136.527     0.150
     9.438   136.427     0.150
     9.443   136.527     0.150
     9.462   137.127     0.150
     9.496   137.227     0.150
     9.496   136.807     0.150
     9.706   138.127     0.150
     9.706   241.827     0.150
     9.709   141.437     0.150
     9.722   138.837     0.150
     9.686   141.427     0.150
     9.742   142.627     0.150
     9.753   142.177     0.150
     9.763   143.397     0.150
     9.772   140.420     0.150
     9.772   241.720     0.150
     9.772   141.527     0.150
     9.772   140.187     0.150
     9.958   141.327     0.150
     9.958   247.627     0.150
    10.024   142.327     0.150
    10.024   249.827     0.150
    10.149   144.327     0.150
    10.149   252.727     0.150
    10.221   145.827     0.150
    10.221   146.927     0.150
    10.221   259.927     0.150
    10.265   146.027     0.150
    10.184   147.927     0.150
    10.224   146.327     0.150
    10.410   151.327     0.150
    10.410   150.487     0.150
    10.416   150.227     0.150
    10.722   156.627     0.150
    10.877   157.827     0.150
    11.790   170.327     0.150
    13.730   194.792     0.150
    13.730   194.797     0.150
    14.297   203.597     0.150
    14.297   205.397     0.150
    14.297   203.594     0.150
    14.498   203.531     0.150
    18.200   252.202     0.150
    18.428   255.427     0.150
    18.428   458.927     0.150
    18.522   258.452     0.150
    18.793   258.327     0.150
    18.843   261.727     0.150
    18.995   262.702     0.150
    19.695   272.827     0.150
    19.715   272.490     0.150
    19.880   272.067     0.150
    19.981   277.017     0.150
    19.938   271.727     0.150
    20.020   272.587     0.150
    20.020   272.585     0.150
    20.060   277.997     0.150
    20.052   275.367     0.150
    20.124   276.587     0.150
    20.193   280.347     0.150
    20.272   278.637     0.150
    20.569   281.197     0.150
    20.569   281.027     0.150
    20.576   281.802     0.150
    20.630   283.327     0.150
    20.731   282.377     0.150
    20.791   279.127     0.150
    20.814   288.627     0.150
    21.250   288.227     0.150
    21.388   287.857     0.150
    21.388   287.852     0.150
    21.401   291.807     0.150
    21.530   293.627     0.150
    22.566   301.297     0.150
    22.566   301.577     0.150
    22.566   303.227     0.150
    27.582   348.227     0.150
    28.955   357.097     0.150
    28.955   357.102     0.150
    30.236   371.397     0.150
    30.240   371.394     0.150
    31.890   385.077     0.150
    31.890   385.227     0.150
    31.890   697.427     0.150
    32.291   389.907     0.150
    33.085   396.827     0.150
    33.181   397.302     0.150
    33.181   398.727     0.150
    38.538   444.347     0.150
    38.642   444.477     0.150
    38.604   444.415     0.150
    43.973   488.182     0.150
    44.008   489.057     0.150
    45.679   503.427     0.150
    45.679   610.727     0.150
    45.679   905.927     0.150
    45.679  1098.227     0.150
    46.943   511.697     0.150
    46.944   513.497     0.150
    46.944   511.692     0.150
    46.944   512.047     0.150
    47.430   515.547     0.150
    47.430   515.577     0.150
    47.430   515.577     0.150
    47.444   515.697     0.150
    49.724   534.027     0.150
    52.076   553.427     0.150
    58.393   598.327     0.150
    61.836   620.497     0.150
    61.837   620.527     0.150
    61.837   620.527     0.150
    62.146   622.427     0.150
    62.200   624.017     0.150
    66.636   797.927     0.150
    68.806   667.227     0.150
    70.092   673.202     0.150
    71.726   684.717     0.150
    73.430   694.077     0.150
    73.647   693.521     0.150
    77.937   718.452     0.150
    78.901   725.927     0.150
    80.615   732.997     0.150
    80.615   732.997     0.150
    80.615   732.995     0.150
    82.604   744.977     0.150
    84.268   752.287     0.150
    84.466   755.997     0.150
    87.893   769.187     0.150
   124.801  1139.607     0.150
   124.801  1139.611     0.150
   126.635  1143.495     0.150
     0.048     2.570     0.150
     0.048     4.460     0.150
     0.116     4.510     0.150
     0.291     6.061     0.150
     0.291    10.910     0.150
     0.261     5.891     0.150
     0.261    10.811     0.150
     0.254    10.910     0.150
     0.370     7.080     0.150
     0.370    13.210     0.150
     0.315     6.521     0.150
     0.315    11.811     0.150
     0.343     7.891     0.150
     0.343    13.710     0.150
     0.317     7.110     0.150
     0.317    13.040     0.150
     0.423     8.030     0.150
     0.423    14.410     0.150
     0.541    10.580     0.150
     0.484     9.830     0.150
     0.484    16.610     0.150
     0.591    11.070     0.150
     0.551    10.351     0.150
     0.551    19.110     0.150
     0.549    10.610     0.150
     0.583    10.780     0.150
     0.666    12.400     0.150
     0.703    12.500     0.150
     0.738    14.240     0.150
     0.733    12.851     0.150
     0.800    14.410     0.150
     0.798    14.460     0.150
     0.836    15.690     0.150
     0.845    15.220     0.150
     0.894    15.590     0.150
     0.835    15.160     0.150
     0.938    17.891     0.150
     0.902    16.790     0.150
     1.078    19.370     0.150
     1.066    19.510     0.150
     1.091    19.720     0.150
     1.131    20.540     0.150
     1.147    20.410     0.150
     1.210    21.561     0.150
     1.280    23.200     0.150
     1.350    24.320     0.150
     1.351    24.210     0.150
     1.351    43.010     0.150
     1.430    26.210     0.150
     1.430    25.320     0.150
     1.460    27.110     0.150
     1.528    26.870     0.150
     1.675    30.021     0.150
     1.647    28.200     0.150
     1.749    30.710     0.150
     1.855    31.410     0.150
     1.855    61.010     0.150
     1.886    33.410     0.150
     1.984    35.110     0.150
     2.426    41.610     0.150
     2.426    42.110     0.150
     2.426    40.670     0.150
     2.661    42.790     0.150
     2.662    43.610     0.150
     2.662    79.210     0.150
     2.662    42.660     0.150
     2.662    72.680     0.150
     2.941    47.910     0.150
     2.941    85.110     0.150
     2.941    47.210     0.150
     2.970    47.510     0.150
     2.970    86.811     0.150
     2.970    47.311     0.150
     3.161    50.610     0.150
     3.161    90.811     0.150
     3.184    51.010     0.150
     3.184    90.710     0.150
     3.184    50.510     0.150
     3.268    52.410     0.150
     3.268    93.710     0.150
     3.319    52.910     0.150
     3.319    94.410     0.150
     3.331    53.311     0.150
     3.331    95.010     0.150
     3.391    52.351     0.150
     3.391    92.870     0.150
     3.408    93.900     0.150
     3.385    54.010     0.150
     3.385    96.010     0.150
     3.432    55.010     0.150
     3.432    97.110     0.150
     3.457    54.910     0.150
     3.457    54.610     0.150
     3.457    97.311     0.150
     3.457    55.110     0.150
     3.457    55.510     0.150
     3.457    98.410     0.150
     3.573    57.311     0.150
     3.573   100.311     0.150
     3.573    56.710     0.150
     3.711    63.780     0.150
     3.710    59.210     0.150
     3.794    60.510     0.150
     3.794   106.311     0.150
     3.934    60.910     0.150
     3.934   107.510     0.150
     3.934    61.710     0.150
     3.939    62.510     0.150
     3.939   108.811     0.150
     3.977    62.311     0.150
     4.002    63.510     0.150
     4.002   110.510     0.150
     4.057    64.510     0.150
     4.057   112.311     0.150
     4.166    65.610     0.150
     4.148    64.010     0.150
     4.148   114.410     0.150
     4.161    65.811     0.150
     4.254    65.610     0.150
     4.254   116.410     0.150
     4.276    66.410     0.150
     4.337    66.460     0.150
     4.337   116.500     0.150
     4.326    67.311     0.150
     4.426    67.950     0.150
     4.426   117.740     0.150
     4.427    68.410     0.150
     4.418    69.260     0.150
     4.418   116.141     0.150
     4.458    68.490     0.150
     4.581    70.510     0.150
     4.651    70.210     0.150
     4.651   120.710     0.150
     4.543    70.010     0.150
     4.668    71.910     0.150
     4.692    73.410     0.150
     4.732    72.010     0.150
     4.732    71.710     0.150
     4.752    73.430     0.150
     4.820    74.930     0.150
     4.880    75.210     0.150
     4.881    74.610     0.150
     4.935    74.960     0.150
     5.020    75.610     0.150
     5.047    75.910     0.150
     5.052    76.311     0.150
     5.190    78.800     0.150
     5.190   135.990     0.150
     5.254    81.010     0.150
     5.280    79.510     0.150
     5.344    79.775     0.150
     5.344   140.345     0.150
     5.339    79.311     0.150
     5.375    81.410     0.150
     5.440    82.710     0.150
     5.466    84.460     0.150
     5.466   145.370     0.150
     5.506    81.372     0.150
     5.506   147.048     0.150
     5.538    83.277     0.150
     5.538   144.484     0.150
     5.726    87.811     0.150
     5.747    87.610     0.150
     5.747    87.420     0.150
     5.845    87.789     0.150
     5.845   153.347     0.150
     5.914    87.311     0.150
     5.949    90.110     0.150
     6.017    92.034     0.150
     6.017   156.646     0.150
     6.018    91.311     0.150
     6.053    91.610     0.150
     6.092   157.600     0.150
     6.169    90.110     0.150
     6.169   113.710     0.150
     6.169   156.710     0.150
     6.080    91.710     0.150
     6.128    94.110     0.150
     6.134    92.910     0.150
     6.326    95.010     0.150
     6.378    95.811     0.150
     6.539   170.350     0.150
     6.596    95.311     0.150
     6.596   121.710     0.150
     6.596   167.010     0.150
     6.624    96.010     0.150
     6.624   167.410     0.150
     6.589    99.441     0.150
     6.589   174.566     0.150
     6.563    98.610     0.150
     6.557    97.210     0.150
     6.621   100.036     0.150
     6.582    96.410     0.150
     6.582   167.510     0.150
     6.693    97.785     0.150
     6.693   173.735     0.150
     6.695   100.080     0.150
     6.695   173.067     0.150
     6.760   175.726     0.150
     6.787   100.617     0.150
     6.787   173.716     0.150
     6.986   105.835     0.150
     6.972   101.210     0.150
     6.972   175.610     0.150
     6.990   105.076     0.150
     6.990   182.020     0.150
     7.114   107.327     0.150
     7.114   185.732     0.150
     7.396   106.410     0.150
     7.396   136.110     0.150
     7.396   186.710     0.150
     7.464   107.710     0.150
     7.464   187.210     0.150
     7.624   109.610     0.150
     7.624   191.910     0.150
     7.724   110.860     0.150
     7.724   194.226     0.150
     8.018   116.410     0.150
     8.018   202.910     0.150
     8.002   117.710     0.150
     8.380   120.210     0.150
     8.394   120.610     0.150
     8.394   155.210     0.150
     8.394   210.110     0.150
     8.509   126.410     0.150
     8.806   126.311     0.150
     8.806   220.710     0.150
     9.060   129.311     0.150
     9.101   134.630     0.150
     9.777   141.541     0.150
     9.777   246.241     0.150
     9.777   141.410     0.150
    10.198   147.910     0.150
    14.309   211.266     0.150
    20.744   283.686     0.150
    21.399   288.067     0.150
    30.227   372.869     0.150
    47.444   515.438     0.150
    61.851   620.391     0.150
     0.039     2.512     0.150
     0.039     4.201     0.150
     0.120     3.041     0.150
     0.120     5.602     0.150
     0.312    11.900     0.150
     0.299     6.092     0.150
     0.299    10.900     0.150
     0.256     5.801     0.150
     0.256    10.701     0.150
     0.266     6.361     0.150
     0.307     6.441     0.150
     0.307    11.900     0.150
     0.375     7.102     0.150
     0.375    12.301     0.150
     0.355     8.061     0.150
     0.318     7.131     0.150
     0.318    12.701     0.150
     0.412     7.971     0.150
     0.412    14.002     0.150
     0.530    10.471     0.150
     0.496     9.900     0.150
     0.496    17.102     0.150
     0.594    11.211     0.150
     0.547    10.451     0.150
     0.564    10.361     0.150
     0.564    19.400     0.150
     0.576    10.900     0.150
     0.676    12.422     0.150
     0.709    12.541     0.150
     0.735    14.602     0.150
     0.722    13.502     0.150
     0.806    16.502     0.150
     0.806    14.391     0.150
     0.840    15.502     0.150
     0.798    14.871     0.150
     0.842    15.092     0.150
     0.883    15.701     0.150
     0.846    15.061     0.150
     0.929    17.021     0.150
     0.912    16.271     0.150
     1.057    19.031     0.150
     1.120    20.371     0.150
     1.128    21.082     0.150
     1.155    20.012     0.150
     1.202    21.191     0.150
     1.333    23.672     0.150
     1.280    23.102     0.150
     1.351    24.201     0.150
     1.351    42.801     0.150
     1.428    25.900     0.150
     1.428    47.301     0.150
     1.428    25.291     0.150
     1.526    27.201     0.150
     1.584    29.301     0.150
     1.661    30.002     0.150
     1.667    29.912     0.150
     1.679    29.061     0.150
     1.761    32.061     0.150
     1.748    30.602     0.150
     1.748    52.701     0.150
     1.802    30.512     0.150
     1.856    31.201     0.150
     1.884    32.400     0.150
     1.984    34.900     0.150
     2.417    43.002     0.150
     2.417    71.201     0.150
     2.673    43.230     0.150
     2.949    47.900     0.150
     2.949    85.602     0.150
     2.949    47.502     0.150
     2.980    59.002     0.150
     3.168    51.201     0.150
     3.168    91.201     0.150
     3.194    51.102     0.150
     3.194    90.900     0.150
     3.194    50.900     0.150
     3.276    52.701     0.150
     3.276    93.602     0.150
     3.325    53.102     0.150
     3.325    94.502     0.150
     3.338    53.801     0.150
     3.338    95.201     0.150
     3.338    52.502     0.150
     3.404    52.490     0.150
     3.404    92.891     0.150
     3.421    53.451     0.150
     3.394    54.102     0.150
     3.394    95.801     0.150
     3.441    55.701     0.150
     3.441    97.201     0.150
     3.464    68.900     0.150
     3.464    95.301     0.150
     3.464    55.801     0.150
     3.464    97.602     0.150
     3.464    55.801     0.150
     3.464    98.502     0.150
     3.583    57.201     0.150
     3.583   100.801     0.150
     3.583    56.602     0.150
     3.698    64.502     0.150
     3.714    59.002     0.150
     3.802    60.801     0.150
     3.802   106.301     0.150
     3.947    62.502     0.150
     3.947    61.301     0.150
     3.949    62.900     0.150
     3.949   109.701     0.150
     4.009    63.900     0.150
     4.009   110.701     0.150
     4.065    64.602     0.150
     4.065   112.201     0.150
     4.159   112.002     0.150
     4.159    64.002     0.150
     4.265    66.201     0.150
     4.265    65.602     0.150
     4.285    76.002     0.150
     4.349    66.752     0.150
     4.349   116.740     0.150
     4.438    67.832     0.150
     4.438   117.961     0.150
     4.422    69.271     0.150
     4.471    67.662     0.150
     4.594    71.701     0.150
     4.652    72.102     0.150
     4.652   119.400     0.150
     4.681    70.502     0.150
     4.776    73.881     0.150
     4.776   127.441     0.150
     4.743    71.900     0.150
     4.743    71.602     0.150
     4.756    73.521     0.150
     4.756   124.361     0.150
     4.823    75.271     0.150
     4.893    75.201     0.150
     5.058    83.602     0.150
     5.276    79.201     0.150
     5.351    78.602     0.150
     5.382    81.301     0.150
     5.437    81.701     0.150
     5.471    84.311     0.150
     5.518    81.320     0.150
     5.518   146.740     0.150
     5.584    83.602     0.150
     5.663    85.900     0.150
     5.724    87.801     0.150
     5.751    87.721     0.150
     5.856    87.062     0.150
     5.856   153.516     0.150
     5.837    86.900     0.150
     5.946    90.002     0.150
     6.003    89.602     0.150
     6.015    90.502     0.150
     6.052    91.301     0.150
     6.052    91.900     0.150
     6.125    91.602     0.150
     6.159    93.502     0.150
     6.193    92.801     0.150
     6.374    95.701     0.150
     6.452    97.002     0.150
     6.502    95.801     0.150
     6.598    94.701     0.150
     6.598   165.900     0.150
     6.626   166.801     0.150
     6.599    99.229     0.150
     6.560    98.602     0.150
     6.557    97.102     0.150
     6.593    98.602     0.150
     6.702    99.328     0.150
     6.702   174.619     0.150
     6.708   100.225     0.150
     6.708   175.115     0.150
     6.800    99.197     0.150
     6.800   175.908     0.150
     6.790    99.801     0.150
     6.974   106.426     0.150
     7.467   106.502     0.150
     7.467   187.201     0.150
     7.737   111.166     0.150
     7.737   195.576     0.150
     7.838   114.801     0.150
     7.838   197.301     0.150
     7.940   119.400     0.150
     8.031   115.400     0.150
     8.031   203.400     0.150
     8.226   122.701     0.150
     8.518   126.201     0.150
     8.518   125.502     0.150
     8.814   124.900     0.150
     8.814   218.900     0.150
     9.069   224.801     0.150
     9.110   133.021     0.150
     9.110   134.002     0.150
     9.184   134.301     0.150
     9.742   138.002     0.150
     9.710   142.002     0.150
     9.773   143.193     0.150
     9.773   143.400     0.150
     9.766   143.602     0.150
     9.779   144.400     0.150
    10.027   141.002     0.150
    10.027   248.102     0.150
    10.118   142.400     0.150
    10.118   250.002     0.150
    10.206   148.102     0.150
    13.904   200.201     0.150
    14.312   212.596     0.150
    18.448   255.602     0.150
    19.964   274.201     0.150
    20.039   272.602     0.150
    20.039   273.666     0.150
    20.589   281.400     0.150
    20.650   283.102     0.150
    20.751   283.400     0.150
    21.412   288.852     0.150
    28.978   358.352     0.150
    31.915   385.801     0.150
    31.915   447.400     0.150
    31.915   697.002     0.150
    38.562   443.900     0.150
    43.479   483.971     0.150
    44.032   491.602     0.150
    46.969   512.002     0.150
    47.453   515.426     0.150
    49.748   533.900     0.150
    61.862   620.551     0.150
    62.225   624.602     0.150
     0.063     2.699     0.150
     0.063     6.566     0.150
     0.173     4.977     0.150
     0.173     8.676     0.150
     0.216     5.148     0.150
     0.216     9.879     0.150
     0.225     5.297     0.150
     0.228     5.016     0.150
     0.228     9.477     0.150
     0.291     6.059     0.150
     0.291    10.879     0.150
     0.321     6.508     0.150
     0.321    12.176     0.150
     0.429     8.039     0.150
     0.429    14.578     0.150
     0.394     8.207     0.150
     0.394    15.078     0.150
     0.451     8.605     0.150
     0.451    15.879     0.150
     0.504     9.477     0.150
     0.504    17.777     0.150
     0.513     9.449     0.150
     0.513    17.477     0.150
     0.527    11.355     0.150
     0.559    10.656     0.150
     0.610    10.836     0.150
     0.607    10.957     0.150
     0.678    12.105     0.150
     0.671    11.809     0.150
     0.658    12.086     0.150
     0.675    12.336     0.150
     0.716    13.219     0.150
     0.692    12.656     0.150
     0.766    13.258     0.150
     0.766    24.977     0.150
     0.802    14.137     0.150
     0.835    14.426     0.150
     0.813    14.668     0.150
     0.887    16.176     0.150
     0.906    17.855     0.150
     0.921    15.578     0.150
     0.928    16.418     0.150
     0.934    16.277     0.150
     1.028    17.516     0.150
     1.045    18.637     0.150
     1.098    18.508     0.150
     1.120    18.938     0.150
     1.139    19.258     0.150
     1.124    20.688     0.150
     1.183    20.617     0.150
     1.200    21.605     0.150
     1.238    22.738     0.150
     1.224    22.449     0.150
     1.259    21.277     0.150
     1.409    24.977     0.150
     1.405    23.316     0.150
     1.405    25.496     0.150
     1.402    24.988     0.150
     1.421    25.738     0.150
     1.517    27.508     0.150
     1.538    26.996     0.150
     1.544    26.738     0.150
     1.572    27.688     0.150
     1.620    28.117     0.150
     1.631    28.547     0.150
     1.622    28.309     0.150
     1.627    28.176     0.150
     1.646    28.379     0.150
     1.687    28.887     0.150
     1.719    29.656     0.150
     1.752    29.848     0.150
     1.750    29.742     0.150
     1.750    55.293     0.150
     1.907    31.746     0.150
     1.925    32.469     0.150
     2.037    33.578     0.150
     2.069    33.828     0.150
     2.069    60.188     0.150
     2.246    37.176     0.150
     2.285    37.188     0.150
     2.285    65.379     0.150
     2.288    37.277     0.150
     2.288    65.539     0.150
     2.323    37.105     0.150
     2.446    41.379     0.150
     2.446    70.578     0.150
     2.446    41.277     0.150
     2.493    40.488     0.150
     2.493    72.637     0.150
     2.603    42.617     0.150
     2.603    75.309     0.150
     2.819    45.379     0.150
     2.819    78.176     0.150
     2.819    44.676     0.150
     2.839    44.879     0.150
     2.839    45.477     0.150
     2.839    80.277     0.150
     2.897    47.078     0.150
     2.897    82.477     0.150
     2.897    47.246     0.150
     2.888    45.676     0.150
     2.934    47.207     0.150
     3.016    48.277     0.150
     3.016    48.078     0.150
     3.016    84.379     0.150
     3.097    48.977     0.150
     3.097    86.379     0.150
     3.167    49.777     0.150
     3.167    88.078     0.150
     3.202    51.477     0.150
     3.255    50.879     0.150
     3.255    90.379     0.150
     3.293    51.578     0.150
     3.293    51.777     0.150
     3.293    91.578     0.150
     3.324    51.238     0.150
     3.297    51.676     0.150
     3.297    90.879     0.150
     3.316    52.078     0.150
     3.316    91.777     0.150
     3.385    53.879     0.150
     3.385    92.477     0.150
     3.385    53.277     0.150
     3.385    53.387     0.150
     3.385    52.879     0.150
     3.385    93.277     0.150
     3.384    53.879     0.150
     3.384    53.176     0.150
     3.384    93.379     0.150
     3.524    55.379     0.150
     3.524    55.906     0.150
     3.658    56.578     0.150
     3.674    57.176     0.150
     3.674   100.277     0.150
     3.758    59.176     0.150
     3.758   102.477     0.150
     3.799    59.078     0.150
     3.841    59.168     0.150
     3.841   102.797     0.150
     3.873    61.176     0.150
     3.875    60.379     0.150
     3.927    60.379     0.150
     3.927   106.477     0.150
     3.947    60.977     0.150
     3.947   107.078     0.150
     3.967    61.258     0.150
     4.021    62.277     0.150
     4.021   108.777     0.150
     4.021    62.977     0.150
     4.073    61.676     0.150
     4.125    63.676     0.150
     4.125   108.176     0.150
     4.203    69.527     0.150
     4.160    63.777     0.150
     4.176    63.477     0.150
     4.179    63.777     0.150
     4.206    64.977     0.150
     4.258    65.379     0.150
     4.258   112.777     0.150
     4.319    65.977     0.150
     4.373    66.277     0.150
     4.421    67.879     0.150
     4.366    67.379     0.150
     4.366   116.078     0.150
     4.484    69.676     0.150
     4.484    69.078     0.150
     4.503    69.277     0.150
     4.503   119.078     0.150
     4.503    68.578     0.150
     4.706    71.578     0.150
     4.706   125.578     0.150
     4.838    72.309     0.150
     4.824    73.277     0.150
     4.867    74.176     0.150
     4.906    73.977     0.150
     5.005    74.098     0.150
     5.005   131.098     0.150
     5.027    74.895     0.150
     5.027   131.867     0.150
     5.020    76.379     0.150
     5.020   132.676     0.150
     5.030    76.277     0.150
     5.030    75.676     0.150
     5.250    80.277     0.150
     5.291    79.777     0.150
     5.313    80.078     0.150
     5.310    78.676     0.150
     5.310    78.875     0.150
     5.310   139.844     0.150
     5.337    79.809     0.150
     5.313    80.379     0.150
     5.447    81.777     0.150
     5.439    82.078     0.150
     5.506    82.359     0.150
     5.506   145.031     0.150
     5.598    82.145     0.150
     5.641    84.277     0.150
     5.641   148.879     0.150
     5.862    84.379     0.150
     5.828    84.859     0.150
     5.858    87.879     0.150
     6.036    91.242     0.150
     6.036   156.844     0.150
     6.098    92.031     0.150
     6.098   159.629     0.150
     6.119    91.344     0.150
     6.119   157.438     0.150
     6.118    91.355     0.150
     6.118   159.055     0.150
     6.188    91.531     0.150
     6.188   159.191     0.150
     6.218    92.418     0.150
     6.218   160.043     0.150
     6.262    94.262     0.150
     6.262   163.258     0.150
     6.297    92.199     0.150
     6.297   160.852     0.150
     6.366    91.777     0.150
     6.308    92.887     0.150
     6.495    97.414     0.150
     6.495   169.574     0.150
     6.629    95.078     0.150
     6.631    99.750     0.150
     6.631   171.691     0.150
     7.018   101.578     0.150
     7.215   104.629     0.150
     7.215   182.703     0.150
     7.286   104.977     0.150
     7.317   109.051     0.150
     7.385   107.477     0.150
     7.508   108.176     0.150
     7.508   189.477     0.150
     7.988   113.676     0.150
     8.357   118.879     0.150
     8.596   122.777     0.150
     8.733   124.879     0.150
     8.926   133.547     0.150
     9.625   136.176     0.150
    14.407   211.926     0.150
    19.518   266.703     0.150
    20.938   285.051     0.150
    30.638   374.801     0.150
    31.627   384.422     0.150
    39.003   447.078     0.150
    68.547   663.773     0.150
    72.926   689.281     0.150
    73.661   697.105     0.150
     0.180     4.438     0.150
     0.180     8.406     0.150
     0.289    10.355     0.150
     0.387     7.395     0.150
     0.392     7.234     0.150
     0.378     7.445     0.150
     0.355     7.746     0.150
     0.421     8.375     0.150
     0.421    15.156     0.150
     0.507     9.137     0.150
     0.507    16.676     0.150
     0.467     9.047     0.150
     0.599    10.805     0.150
     0.569    10.625     0.150
     0.587    10.547     0.150
     0.587    20.137     0.150
     0.651    11.598     0.150
     0.686    12.098     0.150
     0.746    12.965     0.150
     0.688    12.906     0.150
     0.791    13.625     0.150
     0.726    13.234     0.150
     0.837    14.766     0.150
     0.810    15.055     0.150
     0.924    16.496     0.150
     0.953    16.426     0.150
     1.014    17.367     0.150
     0.990    16.977     0.150
     0.990    30.707     0.150
     0.974    17.188     0.150
     1.003    17.965     0.150
     1.025    19.297     0.150
     1.103    19.688     0.150
     1.134    19.305     0.150
     1.105    19.625     0.150
     1.130    19.855     0.150
     1.130    35.777     0.150
     1.242    21.504     0.150
     1.245    22.727     0.150
     1.245    23.387     0.150
     1.245    23.227     0.150
     1.271    23.176     0.150
     1.361    23.477     0.150
     1.386    25.105     0.150
     1.386    23.797     0.150
     1.386    23.234     0.150
     1.406    24.125     0.150
     1.347    23.707     0.150
     1.435    24.535     0.150
     1.495    26.805     0.150
     1.608    28.156     0.150
     1.867    32.707     0.150
     1.734    29.855     0.150
     1.755    30.824     0.150
     1.687    28.484     0.150
     1.691    29.098     0.150
     1.709    29.164     0.150
     1.762    29.625     0.150
     1.857    31.305     0.150
     1.843    31.125     0.150
     1.851    31.035     0.150
     1.851    56.797     0.150
     1.851    30.914     0.150
     1.855    36.074     0.150
     1.934    33.047     0.150
     1.938    32.938     0.150
     1.962    31.824     0.150
     1.984    33.746     0.150
     1.993    33.777     0.150
     1.949    32.188     0.150
     2.056    34.336     0.150
     2.077    33.547     0.150
     2.084    35.984     0.150
     2.176    36.656     0.150
     2.182    36.426     0.150
     2.192    36.836     0.150
     2.165    35.426     0.150
     2.244    37.277     0.150
     2.247    38.527     0.150
     2.182    35.824     0.150
     2.281    38.066     0.150
     2.281    39.715     0.150
     2.316    37.926     0.150
     2.328    41.047     0.150
     2.328    37.367     0.150
     2.328    37.477     0.150
     2.312    37.215     0.150
     2.312    65.945     0.150
     2.358    38.504     0.150
     2.358    38.145     0.150
     2.305    37.527     0.150
     2.386    40.145     0.150
     2.393    39.254     0.150
     2.391    40.348     0.150
     2.419    39.355     0.150
     2.421    39.305     0.150
     2.421    69.496     0.150
     2.482    42.414     0.150
     2.483    41.824     0.150
     2.494    40.117     0.150
     2.504    40.207     0.150
     2.532    41.754     0.150
     2.561    43.047     0.150
     2.565    42.547     0.150
     2.573    42.734     0.150
     2.521    39.875     0.150
     2.528    40.754     0.150
     2.528    44.035     0.150
     2.633    42.227     0.150
     2.633    72.625     0.150
     2.635    42.125     0.150
     2.635    73.984     0.150
     2.677    43.387     0.150
     2.694    42.105     0.150
     2.678    74.504     0.150
     2.657    43.137     0.150
     2.722    45.887     0.150
     2.779    44.945     0.150
     2.790    45.707     0.150
     2.823    45.285     0.150
     2.823    76.598     0.150
     2.823    45.027     0.150
     2.823    43.824     0.150
     2.828    45.176     0.150
     2.828    47.406     0.150
     2.824    47.426     0.150
     2.824    46.914     0.150
     2.858    44.676     0.150
     2.858    45.125     0.150
     2.882    45.777     0.150
     2.882    80.145     0.150
     2.976    47.766     0.150
     2.976    83.805     0.150
     3.021    46.074     0.150
     3.021    46.824     0.150
     2.974    48.766     0.150
     3.052    49.047     0.150
     2.990    46.664     0.150
     3.024    48.496     0.150
     3.024    84.957     0.150
     3.038    47.215     0.150
     3.109    48.895     0.150
     3.136    52.215     0.150
     3.154    49.496     0.150
     3.166    50.426     0.150
     3.194    49.777     0.150
     3.194    50.625     0.150
     3.182    49.855     0.150
     3.182    85.477     0.150
     3.181    50.227     0.150
     3.181    87.324     0.150
     3.185    49.824     0.150
     3.185    49.426     0.150
     3.185    49.625     0.150
     3.185    88.527     0.150
     3.276    51.445     0.150
     3.229    50.227     0.150
     3.274    52.047     0.150
     3.276    48.395     0.150
     3.309    52.875     0.150
     3.318    51.797     0.150
     3.315    51.996     0.150
     3.338    51.605     0.150
     3.375    52.715     0.150
     3.383    53.027     0.150
     3.383    52.824     0.150
     3.383    52.527     0.150
     3.383    93.125     0.150
     3.380    56.125     0.150
     3.430    53.227     0.150
     3.430    94.527     0.150
     3.509    55.637     0.150
     3.509    56.598     0.150
     3.469    53.535     0.150
     3.549    55.457     0.150
     3.549    94.098     0.150
     3.514    54.324     0.150
     3.514    96.125     0.150
     3.583    55.566     0.150
     3.582    57.125     0.150
     3.566    55.477     0.150
     3.608    55.938     0.150
     3.608    56.777     0.150
     3.611    55.527     0.150
     3.611    99.125     0.150
     3.617    56.125     0.150
     3.617    55.824     0.150
     3.617    99.027     0.150
     3.625    56.324     0.150
     3.625    55.527     0.150
     3.625    99.027     0.150
     3.636    58.945     0.150
     3.707    58.746     0.150
     3.656    57.527     0.150
     3.656    56.527     0.150
     3.656    99.426     0.150
     3.722    57.324     0.150
     3.722   100.426     0.150
     3.722    57.953     0.150
     3.722    57.688     0.150
     3.722    58.246     0.150
     3.722    57.027     0.150
     3.722   101.227     0.150
     3.757    58.727     0.150
     3.757    58.227     0.150
     3.757   101.727     0.150
     3.755    59.676     0.150
     3.767    61.324     0.150
     3.864    59.945     0.150
     3.900    60.625     0.150
     3.900    60.934     0.150
     3.900    60.297     0.150
     3.900    61.145     0.150
     3.938    58.605     0.150
     3.930    60.195     0.150
     3.930    59.426     0.150
     3.911    62.891     0.150
     3.931    62.195     0.150
     3.922    61.625     0.150
     3.922   108.324     0.150
     4.080    62.535     0.150
     4.029    62.227     0.150
     4.029   109.027     0.150
     4.089    62.336     0.150
     4.064    62.125     0.150
     4.064    62.527     0.150
     4.064    63.324     0.150
     4.064    62.957     0.150
     4.064   111.234     0.150
     4.064    63.188     0.150
     4.148    62.664     0.150
     4.148   111.914     0.150
     4.114    63.754     0.150
     4.114    63.617     0.150
     4.164    62.336     0.150
     4.164   111.395     0.150
     4.130    65.125     0.150
     4.130    63.426     0.150
     4.130   111.027     0.150
     4.138    63.996     0.150
     4.212    64.867     0.150
     4.167    66.945     0.150
     4.235    63.824     0.150
     4.235   113.625     0.150
     4.215    64.855     0.150
     4.282    65.215     0.150
     4.253    64.426     0.150
     4.261    65.027     0.150
     4.261   114.227     0.150
     4.261    64.027     0.150
     4.270    64.426     0.150
     4.248    67.305     0.150
     4.313    64.734     0.150
     4.267    65.727     0.150
     4.267   114.625     0.150
     4.319    62.957     0.150
     4.295    66.375     0.150
     4.295   116.375     0.150
     4.298    65.727     0.150
     4.298   114.926     0.150
     4.344    65.027     0.150
     4.302    67.586     0.150
     4.348    66.824     0.150
     4.348    67.355     0.150
     4.348   119.254     0.150
     4.403    66.227     0.150
     4.403    67.426     0.150
     4.438    65.004     0.150
     4.438   115.914     0.150
     4.457    67.586     0.150
     4.457    66.516     0.150
     4.396    66.527     0.150
     4.473    70.414     0.150
     4.489    67.324     0.150
     4.490    67.727     0.150
     4.490   119.227     0.150
     4.475    67.926     0.150
     4.475    69.527     0.150
     4.475    68.754     0.150
     4.495    68.727     0.150
     4.495    68.324     0.150
     4.495   119.727     0.150
     4.495    69.066     0.150
     4.495   122.195     0.150
     4.535    67.824     0.150
     4.567    69.188     0.150
     4.567    69.426     0.150
     4.641    69.805     0.150
     4.649    69.777     0.150
     4.649   123.004     0.150
     4.649    69.227     0.150
     4.649    69.664     0.150
     4.664    75.465     0.150
     4.664    71.965     0.150
     4.738    71.027     0.150
     4.738   124.727     0.150
     4.783    73.125     0.150
     4.883    71.438     0.150
     4.873    72.824     0.150
     4.873    73.027     0.150
     4.915    74.406     0.150
     4.885    73.027     0.150
     4.885    73.324     0.150
     4.950    74.195     0.150
     4.984    73.164     0.150
     5.074    76.207     0.150
     5.103    76.176     0.150
     5.103    76.016     0.150
     5.114    76.188     0.150
     5.114   133.879     0.150
     5.084    78.027     0.150
     5.178    81.195     0.150
     5.190    76.465     0.150
     5.198    77.887     0.150
     5.215    76.234     0.150
     5.166    78.727     0.150
     5.205    77.426     0.150
     5.205    79.727     0.150
     5.268    78.621     0.150
     5.268   139.711     0.150
     5.241    77.727     0.150
     5.261    78.324     0.150
     5.261   136.727     0.150
     5.299    78.039     0.150
     5.299   140.578     0.150
     5.255    79.027     0.150
     5.258    78.527     0.150
     5.258    79.926     0.150
     5.362    81.004     0.150
     5.420    79.324     0.150
     5.420    79.426     0.150
     5.394    82.625     0.150
     5.395    81.324     0.150
     5.468    80.996     0.150
     5.415    81.324     0.150
     5.439    83.027     0.150
     5.534    82.246     0.150
     5.501    82.926     0.150
     5.566    81.227     0.150
     5.650    83.426     0.150
     5.646    85.125     0.150
     5.713    84.926     0.150
     5.689   184.934     0.150
     5.742    84.727     0.150
     5.742   147.027     0.150
     5.740    85.926     0.150
     5.740    85.375     0.150
     5.707    84.527     0.150
     5.801    85.324     0.150
     5.905    86.168     0.150
     5.905   154.801     0.150
     5.866    88.125     0.150
     5.873    87.125     0.150
     5.973    90.324     0.150
     6.039    90.074     0.150
     6.031    86.020     0.150
     6.031   197.945     0.150
     6.005    88.926     0.150
     6.005    89.125     0.150
     6.039    90.527     0.150
     6.126    91.727     0.150
     6.093    89.027     0.150
     6.089    91.227     0.150
     6.100    90.227     0.150
     6.173    90.027     0.150
     6.173   156.324     0.150
     6.204    89.926     0.150
     6.204   158.727     0.150
     6.182    91.957     0.150
     6.182   195.957     0.150
     6.209    91.621     0.150
     6.209   162.969     0.150
     6.146    93.125     0.150
     6.225    94.926     0.150
     6.233    91.578     0.150
     6.233   163.836     0.150
     6.221    90.824     0.150
     6.278    92.984     0.150
     6.276    92.605     0.150
     6.276   165.219     0.150
     6.291    93.148     0.150
     6.291   165.344     0.150
     6.230    92.324     0.150
     6.230    92.426     0.150
     6.316    94.527     0.150
     6.285    93.172     0.150
     6.294    92.574     0.150
     6.339    93.824     0.150
     6.332    95.324     0.150
     6.342    95.027     0.150
     6.358    93.324     0.150
     6.358    93.527     0.150
     6.418    95.141     0.150
     6.418   170.066     0.150
     6.457    95.082     0.150
     6.457   168.789     0.150
     6.442    96.027     0.150
     6.476    96.426     0.150
     6.470    96.625     0.150
     6.470    96.324     0.150
     6.475    94.727     0.150
     6.475    94.926     0.150
     6.545    97.027     0.150
     6.545   166.125     0.150
     6.558    97.934     0.150
     6.558   167.973     0.150
     6.552    98.227     0.150
     6.609    95.984     0.150
     6.609   172.582     0.150
     6.561    97.227     0.150
     6.643    97.797     0.150
     6.643   173.621     0.150
     6.582    96.227     0.150
     6.585    98.426     0.150
     6.586    98.324     0.150
     6.619    99.324     0.150
     6.624    97.926     0.150
     6.624    97.625     0.150
     6.717    99.324     0.150
     6.665    99.324     0.150
     6.696    97.727     0.150
     6.696    97.375     0.150
     6.745    99.324     0.150
     6.745   175.668     0.150
     6.760    99.324     0.150
     6.747    98.324     0.150
     6.739    98.727     0.150
     6.739    99.426     0.150
     6.802   102.125     0.150
     6.803   101.027     0.150
     6.859   101.191     0.150
     6.906   101.227     0.150
     6.882   100.527     0.150
     6.951   131.727     0.150
     6.951   175.926     0.150
     6.930   102.477     0.150
     6.930   102.035     0.150
     6.973   176.824     0.150
     6.980   101.926     0.150
     6.958   101.625     0.150
     6.964   101.824     0.150
     7.040   102.727     0.150
     7.040   177.625     0.150
     7.007   102.824     0.150
     7.055   103.926     0.150
     7.055   177.125     0.150
     7.069   104.027     0.150
     7.140   104.426     0.150
     7.126   103.438     0.150
     7.173   105.285     0.150
     7.197   107.727     0.150
     7.197   181.527     0.150
     7.158   103.926     0.150
     7.158   104.727     0.150
     7.154   106.324     0.150
     7.189   106.027     0.150
     7.220   109.949     0.150
     7.220   181.988     0.150
     7.207   106.824     0.150
     7.259   104.426     0.150
     7.221   105.426     0.150
     7.253   105.828     0.150
     7.233   105.926     0.150
     7.292   106.027     0.150
     7.292   105.527     0.150
     7.322   107.926     0.150
     7.423   107.926     0.150
     7.423   188.926     0.150
     7.471   108.227     0.150
     7.471   107.938     0.150
     7.471   107.477     0.150
     7.471   189.000     0.150
     7.495   110.027     0.150
     7.533   109.426     0.150
     7.583   110.426     0.150
     7.583   111.062     0.150
     7.583   112.000     0.150
     7.588   110.324     0.150
     7.588   111.207     0.150
     7.590   110.227     0.150
     7.662   110.324     0.150
     7.670   112.527     0.150
     7.690   112.824     0.150
     7.746   112.324     0.150
     7.746   197.426     0.150
     7.763   111.926     0.150
     7.763   111.227     0.150
     7.763   196.625     0.150
     7.763   112.297     0.150
     7.788   113.125     0.150
     7.788   112.324     0.150
     7.770   114.176     0.150
     7.777   114.621     0.150
     7.831   112.926     0.150
     7.880   112.625     0.150
     7.880   203.324     0.150
     7.818   114.227     0.150
     7.898   117.277     0.150
     7.859   115.625     0.150
     7.891   116.203     0.150
     7.934   114.027     0.150
     7.954   115.727     0.150
     7.954   198.527     0.150
     7.977   200.926     0.150
     7.959   116.824     0.150
     8.011   118.961     0.150
     8.011   250.945     0.150
     8.019   118.324     0.150
     8.019   118.781     0.150
     8.055   115.523     0.150
     8.055   201.488     0.150
     8.055   115.852     0.150
     8.084   116.625     0.150
     8.021   117.125     0.150
     8.188   117.824     0.150
     8.208   120.625     0.150
     8.255   118.324     0.150
     8.255   207.027     0.150
     8.264   119.125     0.150
     8.305   118.824     0.150
     8.299   120.125     0.150
     8.259   118.227     0.150
     8.306   122.227     0.150
     8.323   121.820     0.150
     8.406   120.227     0.150
     8.406   210.926     0.150
     8.345   120.426     0.150
     8.402   123.734     0.150
     8.415   123.426     0.150
     8.409   123.426     0.150
     8.455   123.824     0.150
     8.443   122.824     0.150
     8.524   121.926     0.150
     8.524   215.227     0.150
     8.519   124.324     0.150
     8.570   122.125     0.150
     8.596   123.027     0.150
     8.604   122.297     0.150
     8.604   122.324     0.150
     8.641   123.227     0.150
     8.600   126.855     0.150
     8.614   125.848     0.150
     8.672   123.324     0.150
     8.672   217.625     0.150
     8.656   125.727     0.150
     8.656   127.562     0.150
     8.656   125.527     0.150
     8.678   124.824     0.150
     8.698   127.727     0.150
     8.698   127.285     0.150
     8.777   125.027     0.150
     8.777   218.625     0.150
     8.754   126.824     0.150
     8.832   127.527     0.150
     8.829   127.426     0.150
     8.848   129.293     0.150
     8.848   274.984     0.150
     8.844   128.727     0.150
     8.952   128.727     0.150
     8.920   129.680     0.150
     8.997   132.027     0.150
     9.010   131.926     0.150
     9.018   131.926     0.150
     9.051   130.426     0.150
     9.072   133.426     0.150
     9.121   131.625     0.150
     9.093   133.742     0.150
     9.137   130.625     0.150
     9.138   133.762     0.150
     9.179   131.324     0.150
     9.161   133.070     0.150
     9.157   131.227     0.150
     9.245   132.625     0.150
     9.220   135.086     0.150
     9.274   231.227     0.150
     9.274   132.125     0.150
     9.277   232.125     0.150
     9.262   132.227     0.150
     9.237   134.145     0.150
     9.271   134.227     0.150
     9.299   136.527     0.150
     9.299   135.465     0.150
     9.299   136.410     0.150
     9.328   135.824     0.150
     9.336   136.027     0.150
     9.462   134.625     0.150
     9.462   235.926     0.150
     9.462   134.824     0.150
     9.443   138.039     0.150
     9.489   135.055     0.150
     9.489   136.004     0.150
     9.548   238.527     0.150
     9.536   137.625     0.150
     9.600   137.824     0.150
     9.600   240.027     0.150
     9.577   140.027     0.150
     9.577   139.176     0.150
     9.566   138.926     0.150
     9.570   139.164     0.150
     9.641   138.227     0.150
     9.641   239.824     0.150
     9.609   138.324     0.150
     9.609   139.059     0.150
     9.690   240.926     0.150
     9.724   139.727     0.150
     9.743   242.426     0.150
     9.774   140.426     0.150
     9.740   141.105     0.150
     9.755   140.027     0.150
     9.834   141.324     0.150
     9.834   245.125     0.150
     9.800   142.762     0.150
     9.821   142.652     0.150
     9.878   143.926     0.150
     9.878   144.691     0.150
     9.885   144.727     0.150
     9.893   143.324     0.150
     9.968   142.926     0.150
     9.968   285.926     0.150
     9.968   142.574     0.150
     9.949   143.824     0.150
     9.949   144.199     0.150
     9.928   144.387     0.150
     9.942   144.824     0.150
     9.979   144.625     0.150
    10.029   145.512     0.150
    10.060   146.926     0.150
    10.060   147.855     0.150
    10.060   292.617     0.150
    10.112   145.227     0.150
    10.112   252.027     0.150
    10.114   145.027     0.150
    10.124   149.164     0.150
    10.208   145.824     0.150
    10.208   254.824     0.150
    10.163   147.680     0.150
    10.180   146.992     0.150
    10.218   147.426     0.150
    10.225   148.074     0.150
    10.204   148.203     0.150
    10.204   254.973     0.150
    10.303   148.527     0.150
    10.303   255.824     0.150
    10.274   149.633     0.150
    10.314   150.262     0.150
    10.381   148.727     0.150
    10.389   150.562     0.150
    10.393   150.727     0.150
    10.515   152.320     0.150
    10.607   151.125     0.150
    10.607   263.926     0.150
    10.633   262.926     0.150
    10.631   153.805     0.150
    10.678   153.824     0.150
    10.678   154.031     0.150
    10.757   156.727     0.150
    10.757   275.926     0.150
    10.747   154.613     0.150
    10.763   155.848     0.150
    10.926   155.445     0.150
    11.001   159.227     0.150
    11.001   272.527     0.150
    11.046   158.145     0.150
    11.094   160.285     0.150
    11.067   159.262     0.150
    11.176   158.645     0.150
    11.236   161.027     0.150
    11.236   277.824     0.150
    11.258   161.625     0.150
    11.308   164.824     0.150
    11.482   164.426     0.150
    11.523   163.727     0.150
    11.687   167.867     0.150
    11.735   167.926     0.150
    11.757   167.926     0.150
    11.757   291.125     0.150
    11.721   167.926     0.150
    11.721   297.926     0.150
    11.942   171.324     0.150
    12.028   174.324     0.150
    12.574   178.426     0.150
    12.574   311.727     0.150
    12.853   185.324     0.150
    12.865   316.527     0.150
    12.908   182.426     0.150
    12.908   318.625     0.150
    12.863   187.527     0.150
    13.810   195.926     0.150
    13.822   195.152     0.150
    13.822   194.625     0.150
    13.822   195.027     0.150
    13.877   195.824     0.150
    13.877   341.727     0.150
    13.907   197.527     0.150
    13.907   197.047     0.150
    14.006   196.926     0.150
    14.082   197.527     0.150
    14.127   199.227     0.150
    14.127   347.324     0.150
    14.122   198.105     0.150
    14.123   199.375     0.150
    14.350   201.727     0.150
    14.350   354.727     0.150
    14.442   203.125     0.150
    14.414   203.848     0.150
    14.497   207.215     0.150
    14.673   208.926     0.150
    14.673   209.406     0.150
    14.673   209.039     0.150
    14.770   209.926     0.150
    14.941   218.598     0.150
    14.941   402.035     0.150
    15.380   219.246     0.150
    15.433   216.816     0.150
    15.442   217.164     0.150
    15.442   403.707     0.150
    15.536   222.617     0.150
    15.588   223.535     0.150
    15.578   220.695     0.150
    15.786   219.926     0.150
    15.786   394.926     0.150
    15.870   225.527     0.150
    15.841   221.926     0.150
    15.841   396.926     0.150
    15.956   226.484     0.150
    15.968   224.324     0.150
    15.968   413.766     0.150
    15.979   227.395     0.150
    15.979   425.855     0.150
    16.122   225.566     0.150
    16.122   415.016     0.150
    16.160   226.824     0.150
    16.202   229.688     0.150
    16.309   227.477     0.150
    16.430   231.906     0.150
    16.430   431.086     0.150
    16.543   235.016     0.150
    16.580   235.176     0.150
    16.659   233.926     0.150
    16.669   235.426     0.150
    16.704   237.527     0.150
    16.731   236.227     0.150
    16.759   237.027     0.150
    16.810   234.066     0.150
    16.810   435.285     0.150
    16.838   237.707     0.150
    16.837   235.727     0.150
    16.877   236.527     0.150
    17.006   238.496     0.150
    17.050   236.617     0.150
    17.105   240.727     0.150
    17.358   244.926     0.150
    17.406   247.406     0.150
    17.406   445.125     0.150
    17.435   242.887     0.150
    17.460   245.324     0.150
    17.460   455.305     0.150
    17.475   245.324     0.150
    17.482   244.227     0.150
    17.500   246.125     0.150
    17.591   248.125     0.150
    17.591   244.996     0.150
    17.756   248.027     0.150
    17.806   251.324     0.150
    18.134   251.137     0.150
    18.321   254.414     0.150
    18.364   253.676     0.150
    18.528   256.125     0.150
    18.553   257.047     0.150
    18.626   258.750     0.150
    18.770   258.688     0.150
    18.733   259.027     0.150
    18.733   469.125     0.150
    18.769   258.426     0.150
    18.769   258.277     0.150
    18.956   264.227     0.150
    19.037   271.227     0.150
    19.157   268.727     0.150
    19.451   266.656     0.150
    19.451   267.625     0.150
    19.600   268.066     0.150
    19.594   265.926     0.150
    19.604   265.926     0.150
    19.604   480.227     0.150
    19.773   269.527     0.150
    19.773   269.789     0.150
    19.773   526.461     0.150
    19.778   271.047     0.150
    19.793   271.395     0.150
    19.818   271.574     0.150
    19.792   270.926     0.150
    19.949   271.777     0.150
    19.996   270.824     0.150
    19.996   494.527     0.150
    20.007   270.926     0.150
    20.007   495.027     0.150
    20.007   272.320     0.150
    20.007   271.957     0.150
    20.038   272.098     0.150
    20.012   272.426     0.150
    20.133   274.527     0.150
    20.312   278.336     0.150
    20.312   279.625     0.150
    20.488   276.516     0.150
    20.519   277.074     0.150
    20.856   279.125     0.150
    20.856   298.426     0.150
    20.856   512.125     0.150
    20.866   284.824     0.150
    20.858   283.527     0.150
    20.867   285.113     0.150
    20.867   283.727     0.150
    20.867   518.125     0.150
    20.874   288.270     0.150
    21.033   283.465     0.150
    21.032   284.824     0.150
    21.032   285.902     0.150
    21.122   283.125     0.150
    21.122   514.527     0.150
    21.157   286.926     0.150
    21.280   286.152     0.150
    21.281   285.586     0.150
    21.844   295.125     0.150
    22.222   297.426     0.150
    22.463   300.227     0.150
    22.912   305.918     0.150
    22.912   305.527     0.150
    22.912   306.816     0.150
    23.180   308.324     0.150
    23.180   333.824     0.150
    23.180   538.227     0.150
    23.180   562.926     0.150
    23.557   312.926     0.150
    23.715   314.426     0.150
    23.758   312.824     0.150
    23.982   317.527     0.150
    24.139   316.824     0.150
    24.516   322.527     0.150
    24.521   322.227     0.150
    24.620   320.926     0.150
    24.857   326.926     0.150
    25.901   334.324     0.150
    26.304   338.824     0.150
    26.583   340.824     0.150
    27.599   346.227     0.150
    28.794   356.980     0.150
    28.794   546.465     0.150
    30.269   369.477     0.150
    30.269   371.574     0.150
    31.445   381.340     0.150
    31.445   383.027     0.150
    32.016   386.027     0.150
    32.016   451.027     0.150
    32.016   551.926     0.150
    32.016   701.527     0.150
    32.016   806.227     0.150
    32.016   386.695     0.150
    32.016   387.125     0.150
    32.511   391.227     0.150
    32.511   390.426     0.150
    33.209   397.125     0.150
    33.520   400.203     0.150
    33.520   400.215     0.150
    36.906   428.238     0.150
    37.511   435.504     0.150
    37.700   434.508     0.150
    37.739   436.836     0.150
    37.770   436.762     0.150
    37.920   438.359     0.150
    38.174   438.824     0.150
    38.193   440.516     0.150
    38.210   439.980     0.150
    38.239   439.930     0.150
    38.622   443.566     0.150
    38.622   442.465     0.150
    38.711   444.926     0.150
    38.709   444.125     0.150
    38.709   443.504     0.150
    38.859   446.527     0.150
    39.096   446.527     0.150
    40.112   455.926     0.150
    40.112   453.426     0.150
    40.864   461.625     0.150
    40.864   462.164     0.150
    40.864   462.125     0.150
    41.095   463.227     0.150
    41.389   465.707     0.150
    42.966   480.027     0.150
    43.090   478.926     0.150
    43.090   478.727     0.150
    43.281   479.305     0.150
    43.583   486.547     0.150
    43.613   484.414     0.150
    43.787   486.422     0.150
    43.787   487.027     0.150
    43.787   487.574     0.150
    43.787   486.227     0.150
    43.845   489.926     0.150
    43.940   493.086     0.150
    44.096   493.406     0.150
    44.194   489.324     0.150
    44.194   488.895     0.150
    44.330   490.324     0.150
    44.456   491.027     0.150
    44.505   493.066     0.150
    44.641   492.895     0.150
    45.266   497.445     0.150
    45.373   498.016     0.150
    45.676   499.855     0.150
    45.965   505.426     0.150
    45.965   829.426     0.150
    46.092   505.125     0.150
    46.092   504.672     0.150
    46.341   506.066     0.150
    46.386   506.746     0.150
    46.730   508.785     0.150
    46.981   512.227     0.150
    47.314   514.805     0.150
    47.091   512.379     0.150
    47.091   624.453     0.150
    47.104   515.133     0.150
    47.437   515.125     0.150
    47.437   514.375     0.150
    47.645   515.625     0.150
    47.645   515.504     0.150
    47.645   515.352     0.150
    49.076   525.965     0.150
    52.302   552.926     0.150
    52.906   553.867     0.150
    53.420   557.957     0.150
    55.082   570.227     0.150
    55.338   571.625     0.150
    55.476   572.426     0.150
    56.834   582.129     0.150
    56.945   583.465     0.150
    56.945   582.305     0.150
    56.933   585.027     0.150
    57.061   588.125     0.150
    57.308   585.891     0.150
    57.308   585.715     0.150
    57.378   586.309     0.150
    57.387   587.121     0.150
    57.387   586.727     0.150
    57.523   587.766     0.150
    58.018   591.289     0.150
    58.062   591.406     0.150
    58.242   594.426     0.150
    58.389   593.922     0.150
    58.522   598.527     0.150
    58.522  1088.027     0.150
    58.566   595.441     0.150
    58.598   595.434     0.150
    58.566   596.426     0.150
    58.598   595.824     0.150
    58.578   596.027     0.150
    58.644   595.801     0.150
    58.937   598.926     0.150
    59.092   599.473     0.150
    59.142   598.383     0.150
    59.177   599.219     0.150
    59.177   599.117     0.150
    59.178   599.289     0.150
    59.255   600.090     0.150
    59.482   601.219     0.150
    59.679   602.566     0.150
    59.683   602.871     0.150
    59.759   603.875     0.150
    59.784   604.203     0.150
    59.803   603.727     0.150
    59.882   604.637     0.150
    60.241   606.520     0.150
    60.278   606.637     0.150
    60.319   607.109     0.150
    60.344   607.617     0.150
    60.345   607.336     0.150
    60.379   608.066     0.150
    60.400   608.926     0.150
    60.437   609.125     0.150
    60.527   609.277     0.150
    60.678   609.926     0.150
    60.841   611.234     0.150
    60.859   610.637     0.150
    60.972   612.508     0.150
    61.018   612.340     0.150
    61.069   612.551     0.150
    61.075   612.684     0.150
    61.086   612.707     0.150
    61.182   613.094     0.150
    61.238   613.121     0.150
    61.253   613.883     0.150
    61.374   614.719     0.150
    61.406   614.871     0.150
    61.527   615.312     0.150
    61.548   615.586     0.150
    61.575   615.840     0.150
    61.610   618.879     0.150
    61.823   617.609     0.150
    61.876   616.766     0.150
    61.889   618.895     0.150
    61.920   619.199     0.150
    61.955   619.254     0.150
    61.964   618.891     0.150
    61.969   619.188     0.150
    61.986   620.824     0.150
    62.067   619.441     0.150
    62.174   619.785     0.150
    62.347   622.527     0.150
    62.369   621.926     0.150
    62.524   622.332     0.150
    62.538   623.082     0.150
    62.606   623.258     0.150
    62.693   624.367     0.150
    62.981   625.484     0.150
    62.994   626.008     0.150
    63.061   626.727     0.150
    63.107   627.051     0.150
    63.136   627.148     0.150
    63.213   626.523     0.150
    63.327   627.996     0.150
    63.467   628.930     0.150
    63.471   629.004     0.150
    63.478   628.594     0.150
    63.502   628.926     0.150
    63.541   629.469     0.150
    63.573   629.277     0.150
    63.606   629.770     0.150
    63.652   630.012     0.150
    63.704   630.480     0.150
    63.747   631.238     0.150
    63.852   631.336     0.150
    64.055   632.691     0.150
    64.060   631.324     0.150
    64.071   633.102     0.150
    64.119   633.488     0.150
    64.124   633.590     0.150
    64.124   633.480     0.150
    64.138   633.363     0.150
    64.160   633.762     0.150
    64.297   634.512     0.150
    64.397   635.387     0.150
    64.546   635.926     0.150
    64.661   636.684     0.150
    64.675   636.793     0.150
    64.695   637.277     0.150
    64.695   636.348     0.150
    64.769   637.422     0.150
    64.796   637.387     0.150
    64.876   638.445     0.150
    65.114   639.766     0.150
    65.132   639.555     0.150
    65.155   639.223     0.150
    65.225   640.777     0.150
    65.295   640.762     0.150
    65.312   641.258     0.150
    65.312   640.895     0.150
    65.333   641.125     0.150
    65.333   639.504     0.150
    65.428   641.391     0.150
    65.560   642.996     0.150
    65.622   642.586     0.150
    65.628   643.059     0.150
    65.645   642.879     0.150
    65.867   644.594     0.150
    65.885   644.895     0.150
    65.885   643.656     0.150
    65.904   644.586     0.150
    66.056   645.531     0.150
    66.154   646.621     0.150
    66.183   646.852     0.150
    66.183   645.836     0.150
    66.228   646.285     0.150
    66.253   646.922     0.150
    66.267   646.934     0.150
    66.277   647.680     0.150
    66.281   647.039     0.150
    66.467   648.461     0.150
    66.631   649.438     0.150
    66.686   649.660     0.150
    66.784   650.316     0.150
    66.784   650.453     0.150
    66.818   650.340     0.150
    66.890   650.980     0.150
    66.866   652.426     0.150
    66.866  1443.727     0.150
    66.921   651.746     0.150
    66.872   651.824     0.150
    67.024   652.195     0.150
    67.105   652.793     0.150
    67.132   652.840     0.150
    67.300   653.836     0.150
    67.313   654.117     0.150
    67.430   654.480     0.150
    67.442   654.383     0.150
    67.443   656.859     0.150
    67.443   655.027     0.150
    67.601   656.348     0.150
    67.716   656.445     0.150
    67.716   655.496     0.150
    67.797   656.398     0.150
    67.912   657.598     0.150
    67.920   657.699     0.150
    67.972   658.008     0.150
    67.995   658.254     0.150
    68.031   658.559     0.150
    68.048   658.035     0.150
    68.085   658.117     0.150
    68.194   659.055     0.150
    67.616   659.020     0.150
    68.396   660.473     0.150
    68.421   660.551     0.150
    68.428   660.496     0.150
    68.429   661.125     0.150
    68.472   661.449     0.150
    68.510   661.727     0.150
    68.524   661.969     0.150
    68.603   662.180     0.150
    68.602   662.195     0.150
    68.701   662.070     0.150
    68.735   662.754     0.150
    68.769   663.039     0.150
    68.781   662.840     0.150
    68.784   662.715     0.150
    68.846   666.727     0.150
    68.897   663.633     0.150
    68.934   664.355     0.150
    68.964   664.273     0.150
    68.988   664.613     0.150
    68.983   665.426     0.150
    69.035   664.312     0.150
    69.071   665.332     0.150
    69.167   665.914     0.150
    69.174   665.758     0.150
    69.242   665.723     0.150
    69.293   666.301     0.150
    69.388   666.027     0.150
    69.401   666.992     0.150
    69.406   666.727     0.150
    69.413   667.195     0.150
    69.495   667.188     0.150
    69.502   667.629     0.150
    69.558   667.910     0.150
    69.566   667.473     0.150
    69.567   667.977     0.150
    69.602   667.613     0.150
    69.648   668.672     0.150
    69.640   667.613     0.150
    69.640   669.926     0.150
    69.787   669.043     0.150
    69.836   669.086     0.150
    69.849   669.445     0.150
    69.873   669.004     0.150
    69.838   670.426     0.150
    69.894   669.645     0.150
    69.989   670.727     0.150
    70.006   670.297     0.150
    70.069   670.359     0.150
    70.080   670.352     0.150
    70.284   672.457     0.150
    70.296   672.125     0.150
    70.296   671.355     0.150
    70.300   671.660     0.150
    70.300   671.766     0.150
    70.337   672.488     0.150
    70.414   672.738     0.150
    70.418   672.738     0.150
    70.367   673.629     0.150
    70.367   673.105     0.150
    70.443   672.820     0.150
    70.508   673.199     0.150
    70.522   673.035     0.150
    70.583   673.449     0.150
    70.614   673.996     0.150
    70.616   674.434     0.150
    70.714   676.125     0.150
    70.753   675.668     0.150
    70.866   675.617     0.150
    71.098   677.723     0.150
    71.114   676.660     0.150
    71.148   677.621     0.150
    71.182   677.656     0.150
    71.246   678.836     0.150
    71.297   678.809     0.150
    71.585   680.285     0.150
    71.590   680.016     0.150
    71.833   682.258     0.150
    71.948   681.738     0.150
    72.041   683.020     0.150
    72.049   682.898     0.150
    72.098   682.930     0.150
    72.151   682.770     0.150
    72.158   683.574     0.150
    72.166   683.148     0.150
    72.238   683.887     0.150
    72.254   684.402     0.150
    72.250   684.926     0.150
    72.353   685.531     0.150
    72.487   686.066     0.150
    72.576   686.660     0.150
    72.646   686.504     0.150
    72.669   686.461     0.150
    72.623   687.926     0.150
    72.689   686.973     0.150
    72.713   686.629     0.150
    72.789   687.719     0.150
    72.824   687.855     0.150
    72.929   689.027     0.150
    73.067   688.734     0.150
    73.072   689.164     0.150
    73.125   689.020     0.150
    73.148   689.863     0.150
    73.165   690.926     0.150
    73.166   690.527     0.150
    73.294   690.898     0.150
    73.299   690.836     0.150
    73.325   690.438     0.150
    73.383   692.188     0.150
    73.404   697.926     0.150
    73.524   691.785     0.150
    73.583   692.598     0.150
    73.595   692.719     0.150
    73.593   692.746     0.150
    73.611   692.773     0.150
    73.703   693.957     0.150
    73.791   694.227     0.150
    73.811   694.160     0.150
    73.760   697.527     0.150
    73.883   694.629     0.150
    73.978   695.836     0.150
    74.111   694.625     0.150
    74.135   695.496     0.150
    74.147   695.012     0.150
    74.186   695.195     0.150
    74.238   696.168     0.150
    74.250   696.875     0.150
    74.257   696.324     0.150
    74.356   697.480     0.150
    74.572   701.926     0.150
    74.702   698.324     0.150
    74.787   699.652     0.150
    74.796   699.816     0.150
    74.806   699.250     0.150
    74.867   700.188     0.150
    74.898   700.082     0.150
    74.974   701.426     0.150
    75.071   700.484     0.150
    75.071   699.965     0.150
    75.109   701.152     0.150
    75.168   697.527     0.150
    75.370   702.672     0.150
    75.374   702.367     0.150
    75.434   702.797     0.150
    75.508   703.914     0.150
    75.769   704.246     0.150
    75.811   704.984     0.150
    75.887   705.559     0.150
    75.905   705.574     0.150
    76.073   708.824     0.150
    76.087   706.477     0.150
    76.186   708.855     0.150
    76.210   708.996     0.150
    76.308   708.215     0.150
    76.356   708.254     0.150
    76.506   709.727     0.150
    76.570   710.164     0.150
    76.597   709.055     0.150
    76.610   709.504     0.150
    76.793   711.484     0.150
    77.025   712.906     0.150
    77.062   713.188     0.150
    77.143   712.398     0.150
    77.502   714.473     0.150
    77.676   715.984     0.150
    77.996   717.488     0.150
    78.021   719.125     0.150
    78.021   718.773     0.150
    78.218   718.516     0.150
    78.273   718.484     0.150
    78.434   720.070     0.150
    79.100   723.426     0.150
    79.253   724.281     0.150
    79.339   724.574     0.150
    79.661   726.234     0.150
    79.879   727.672     0.150
    80.028   729.270     0.150
    80.247   729.434     0.150
    80.313   730.305     0.150
    80.595   731.527     0.150
    80.667   731.977     0.150
    80.764   736.727     0.150
    80.764   741.727     0.150
    80.750   734.973     0.150
    80.859   733.289     0.150
    80.882   735.430     0.150
    80.911   733.754     0.150
    81.003   734.324     0.150
    81.399   735.941     0.150
    81.605   737.410     0.150
    81.902   739.805     0.150
    82.204   740.164     0.150
    82.204   740.379     0.150
    82.331   742.164     0.150
    82.561   743.250     0.150
    82.583   743.184     0.150
    82.953   744.805     0.150
    83.613   747.824     0.150
    83.765   747.840     0.150
    83.787   748.758     0.150
    83.886   748.727     0.150
    83.936   749.906     0.150
    83.983   749.988     0.150
    84.052   750.254     0.150
    84.052   750.688     0.150
    84.222   751.324     0.150
    84.444   752.234     0.150
    84.601   752.633     0.150
    84.617   753.465     0.150
    84.701   753.086     0.150
    84.737   754.375     0.150
    84.862   754.277     0.150
    85.111   754.484     0.150
    85.401   756.602     0.150
    85.734   758.742     0.150
    85.849   758.273     0.150
    85.997   760.594     0.150
    86.245   761.238     0.150
    86.250   761.594     0.150
    86.676   763.543     0.150
    86.744   763.637     0.150
    86.755   763.980     0.150
    86.910   763.953     0.150
    87.014   765.375     0.150
    88.065   769.578     0.150
    88.258   770.727     0.150
    88.490   771.809     0.150
    88.553   772.734     0.150
    88.763   773.059     0.150
    89.232   776.035     0.150
    89.286   775.461     0.150
    89.353   776.668     0.150
    89.513   777.484     0.150
    89.629   777.625     0.150
    90.003   779.281     0.150
    90.992   784.223     0.150
    91.185   785.434     0.150
    91.236   785.785     0.150
    91.434   786.066     0.150
    91.546   786.457     0.150
    91.699   787.309     0.150
    91.715   787.363     0.150
    91.802   787.172     0.150
    92.008   788.230     0.150
    92.440   791.148     0.150
    92.775   792.156     0.150
    93.345   795.684     0.150
   111.655   875.926     0.150
   111.655   880.227     0.150
   125.163  1139.277     0.150
   127.012  1142.977     0.150
   137.102  1164.059     0.150
     0.176     3.930     0.150
     0.176     7.617     0.150
     0.186     4.633     0.150
     0.186     8.398     0.150
     0.181     4.109     0.150
     0.181     8.312     0.150
     0.285    10.211     0.150
     0.300     5.867     0.150
     0.300    10.969     0.150
     0.307     6.016     0.150
     0.307    11.672     0.150
     0.397     7.586     0.150
     0.393     7.617     0.150
     0.364     6.531     0.150
     0.357     7.672     0.150
     0.385     7.719     0.150
     0.385    13.188     0.150
     0.425     8.391     0.150
     0.504     9.133     0.150
     0.463    16.312     0.150
     0.521    10.000     0.150
     0.521    17.656     0.150
     0.536    11.078     0.150
     0.562    10.250     0.150
     0.606    10.852     0.150
     0.590    10.570     0.150
     0.655    11.688     0.150
     0.692    12.219     0.150
     0.683    12.570     0.150
     0.752    12.898     0.150
     0.723    12.938     0.150
     0.727    13.289     0.150
     0.796    13.906     0.150
     0.804    14.789     0.150
     0.844    15.852     0.150
     0.926    17.117     0.150
     0.986    17.242     0.150
     0.970    17.648     0.150
     0.998    18.227     0.150
     1.027    18.211     0.150
     1.027    35.102     0.150
     1.135    20.031     0.150
     1.099    19.789     0.150
     1.132    21.078     0.150
     1.132    38.102     0.150
     1.245    22.859     0.150
     1.251    23.406     0.150
     1.242    22.883     0.150
     1.267    23.266     0.150
     1.338    25.258     0.150
     1.389    24.180     0.150
     1.345    23.641     0.150
     1.467    27.453     0.150
     1.485    26.742     0.150
     1.497    25.703     0.150
     1.614    29.859     0.150
     1.607    27.820     0.150
     1.685    28.867     0.150
     1.687    28.891     0.150
     1.739    31.180     0.150
     1.704    30.102     0.150
     1.809    31.461     0.150
     1.841    31.211     0.150
     1.848    32.797     0.150
     1.941    34.312     0.150
     1.999    35.742     0.150
     2.053    34.797     0.150
     2.079    38.930     0.150
     2.130    33.867     0.150
     2.189    39.000     0.150
     2.163    35.812     0.150
     2.287    41.086     0.150
     2.317    37.258     0.150
     2.317    66.352     0.150
     2.302    38.008     0.150
     2.364    41.156     0.150
     2.392    41.000     0.150
     2.392    42.227     0.150
     2.428    39.070     0.150
     2.428    67.789     0.150
     2.510    41.453     0.150
     2.537    43.172     0.150
     2.579    44.719     0.150
     2.613    46.898     0.150
     2.640    41.469     0.150
     2.640    72.242     0.150
     2.642    41.469     0.150
     2.642    74.156     0.150
     2.682    42.188     0.150
     2.682    74.516     0.150
     2.728    52.242     0.150
     2.818    47.008     0.150
     2.818    48.281     0.150
     2.826    44.352     0.150
     2.826    79.086     0.150
     2.826    45.312     0.150
     2.826    46.211     0.150
     2.852    85.102     0.150
     2.847    47.500     0.150
     2.887    45.438     0.150
     2.887    82.578     0.150
     2.982    47.477     0.150
     2.982    83.781     0.150
     3.027    47.992     0.150
     3.027    82.453     0.150
     3.189    49.398     0.150
     3.189    87.258     0.150
     3.183    50.008     0.150
     3.187    49.508     0.150
     3.187    87.711     0.150
     3.281    52.047     0.150
     3.314    58.492     0.150
     3.386    52.906     0.150
     3.386    53.109     0.150
     3.386    92.406     0.150
     3.432    53.109     0.150
     3.432    93.406     0.150
     3.516    54.312     0.150
     3.516    95.406     0.150
     3.556    93.641     0.150
     3.588    57.109     0.150
     3.614    55.812     0.150
     3.614    97.812     0.150
     3.618    56.008     0.150
     3.618    56.109     0.150
     3.618    98.211     0.150
     3.626    55.906     0.150
     3.626    98.109     0.150
     3.658    56.812     0.150
     3.658    98.812     0.150
     3.724    57.609     0.150
     3.724    57.609     0.150
     3.724   100.312     0.150
     3.760    58.812     0.150
     3.760   101.508     0.150
     3.904    62.156     0.150
     3.906    60.508     0.150
     3.906    60.781     0.150
     3.946    66.633     0.150
     3.946    68.852     0.150
     3.937    60.508     0.150
     4.031    61.906     0.150
     4.031   107.711     0.150
     4.064    62.312     0.150
     4.064    62.938     0.150
     4.115    63.680     0.150
     4.155    63.547     0.150
     4.133    64.008     0.150
     4.133   110.109     0.150
     4.237    63.508     0.150
     4.237   113.609     0.150
     4.256    65.109     0.150
     4.265    64.406     0.150
     4.289    65.148     0.150
     4.289   115.148     0.150
     4.268    65.406     0.150
     4.268   114.008     0.150
     4.301    65.711     0.150
     4.301   114.711     0.150
     4.350    66.609     0.150
     4.393    67.109     0.150
     4.407    67.609     0.150
     4.495    68.211     0.150
     4.495    68.812     0.150
     4.541    68.148     0.150
     4.648    69.961     0.150
     4.648   122.242     0.150
     4.656    70.508     0.150
     4.656    70.703     0.150
     4.877    73.312     0.150
     4.889    73.711     0.150
     4.957    74.281     0.150
     5.083    78.312     0.150
     5.121    76.031     0.150
     5.203    80.109     0.150
     5.275    79.570     0.150
     5.275   139.484     0.150
     5.257    79.508     0.150
     5.306    78.750     0.150
     5.424    79.609     0.150
     5.541    82.602     0.150
     5.644    85.406     0.150
     5.694    83.125     0.150
     5.746    84.812     0.150
     5.747    86.633     0.150
     5.911    86.617     0.150
     6.004    89.008     0.150
     6.037    87.172     0.150
     6.176    90.008     0.150
     6.176   155.609     0.150
     6.143    93.312     0.150
     6.207    90.109     0.150
     6.207   158.812     0.150
     6.216   163.805     0.150
     6.239    91.492     0.150
     6.239   164.469     0.150
     6.229    92.906     0.150
     6.282    93.617     0.150
     6.297    93.578     0.150
     6.297    92.719     0.150
     6.330    95.906     0.150
     6.358    93.711     0.150
     6.425    95.992     0.150
     6.463    95.266     0.150
     6.463   167.945     0.150
     6.438    96.406     0.150
     6.467    97.406     0.150
     6.549    94.711     0.150
     6.548    98.609     0.150
     6.557    97.906     0.150
     6.616    96.414     0.150
     6.616   173.359     0.150
     6.649    98.047     0.150
     6.649   174.539     0.150
     6.625    98.109     0.150
     6.751   100.266     0.150
     6.800   101.211     0.150
     6.881   101.109     0.150
     6.925   102.836     0.150
     6.956   100.406     0.150
     6.956   176.008     0.150
     6.977   101.008     0.150
     6.962   102.312     0.150
     7.043   101.406     0.150
     7.069   104.406     0.150
     7.201   108.211     0.150
     7.192   106.031     0.150
     7.265   106.211     0.150
     7.257   105.836     0.150
     7.478   107.812     0.150
     7.478   189.844     0.150
     7.589   112.312     0.150
     7.589   108.164     0.150
     7.592   110.828     0.150
     7.713   112.312     0.150
     7.752   112.906     0.150
     7.752   197.211     0.150
     7.769   111.609     0.150
     7.769   197.812     0.150
     7.795   114.711     0.150
     7.779   113.430     0.150
     7.895   116.016     0.150
     7.982   114.109     0.150
     7.982   198.711     0.150
     8.062   115.680     0.150
     8.062   115.812     0.150
     8.258   118.906     0.150
     8.279   123.109     0.150
     8.306   119.906     0.150
     8.412   120.109     0.150
     8.412   209.406     0.150
     8.531   122.211     0.150
     8.525   122.008     0.150
     8.615   125.422     0.150
     8.678   123.711     0.150
     8.678   215.711     0.150
     8.663   127.133     0.150
     8.663   127.312     0.150
     8.701   127.328     0.150
     8.783   125.711     0.150
     8.839   127.812     0.150
     8.853   128.156     0.150
     9.141   132.984     0.150
     9.162   131.656     0.150
     9.269   132.812     0.150
     9.302   134.703     0.150
     9.302   137.375     0.150
     9.695   136.406     0.150
     9.695   239.508     0.150
     9.882   143.648     0.150
     9.896   142.844     0.150
    10.200   148.914     0.150
    10.395   150.180     0.150
    14.123   198.938     0.150
    14.673   207.812     0.150
    18.623   260.031     0.150
    19.780   269.289     0.150
    21.286   284.844     0.150
    30.263   371.188     0.150
    32.020   387.227     0.150
    47.648   514.742     0.150
    68.708   662.289     0.150
     0.151     3.625     0.150
     0.151     6.922     0.150
     0.196     4.648     0.150
     0.196     8.492     0.150
     0.206     4.547     0.150
     0.206     8.547     0.150
     0.284     5.523     0.150
     0.284    10.406     0.150
     0.270     5.305     0.150
     0.375     7.328     0.150
     0.375    13.602     0.150
     0.373     7.336     0.150
     0.331     6.664     0.150
     0.385     7.547     0.150
     0.385    14.094     0.150
     0.379     7.906     0.150
     0.374     7.023     0.150
     0.441     8.688     0.150
     0.485     9.148     0.150
     0.486     9.258     0.150
     0.546    10.664     0.150
     0.608    10.914     0.150
     0.608    10.758     0.150
     0.608    19.633     0.150
     0.631    11.336     0.150
     0.681    12.094     0.150
     0.735    12.758     0.150
     0.707    13.453     0.150
     0.837    15.078     0.150
     0.901    17.008     0.150
     0.969    17.172     0.150
     1.020    19.172     0.150
     1.048    19.555     0.150
     1.110    19.695     0.150
     1.118    20.297     0.150
     1.154    20.734     0.150
     1.221    22.383     0.150
     1.316    24.852     0.150
     1.505    26.953     0.150
     1.785    30.492     0.150
     1.866    31.797     0.150
     1.872    32.133     0.150
     1.872    57.797     0.150
     1.923    34.477     0.150
     1.971    33.203     0.150
     2.100    39.375     0.150
     2.173    38.055     0.150
     2.188    37.297     0.150
     2.329    37.383     0.150
     2.432    38.438     0.150
     2.639    41.234     0.150
     2.639    73.375     0.150
     2.646    75.125     0.150
     2.696    42.727     0.150
     2.666    85.188     0.150
     2.869    48.492     0.150
     2.845    44.914     0.150
     2.845    78.414     0.150
     2.845    45.594     0.150
     2.845    45.398     0.150
     2.900    45.852     0.150
     2.900    82.219     0.150
     2.989    46.922     0.150
     2.989    83.234     0.150
     3.047    48.414     0.150
     3.047    84.133     0.150
     3.186    49.203     0.150
     3.186    87.914     0.150
     3.203    50.695     0.150
     3.203    50.594     0.150
     3.209    49.898     0.150
     3.283    51.914     0.150
     3.406    53.195     0.150
     3.596    57.297     0.150
     3.641    56.492     0.150
     3.746    58.094     0.150
     3.746    99.398     0.150
     3.746    57.898     0.150
     3.746    99.727     0.150
     3.779    59.094     0.150
     3.914    60.797     0.150
     3.914    60.398     0.150
     3.914    59.781     0.150
     4.088    63.023     0.150
     4.154    62.898     0.150
     4.138    64.383     0.150
     4.274    65.492     0.150
     4.280    65.195     0.150
     4.280    65.398     0.150
     4.345    66.297     0.150
     4.345    66.398     0.150
     4.424    67.594     0.150
     4.424   115.492     0.150
     4.424    67.992     0.150
     4.494    67.594     0.150
     4.512    69.594     0.150
     4.545    67.766     0.150
     4.647    86.125     0.150
     4.760    72.195     0.150
     4.760   124.695     0.150
     4.906    73.992     0.150
     5.117    76.875     0.150
     5.226    78.297     0.150
     5.268    78.055     0.150
     5.263    78.695     0.150
     5.263   135.594     0.150
     5.302    78.133     0.150
     5.284    79.297     0.150
     5.438    79.992     0.150
     5.530    82.414     0.150
     5.673    84.898     0.150
     5.909    86.492     0.150
     5.909    86.609     0.150
     6.102    90.297     0.150
     6.203    91.773     0.150
     6.225    90.922     0.150
     6.269    91.102     0.150
     6.243    91.992     0.150
     6.243   159.594     0.150
     6.315    92.609     0.150
     6.362    94.492     0.150
     6.362   162.094     0.150
     6.458    94.953     0.150
     6.614    95.539     0.150
     6.648    98.336     0.150
     6.716    97.500     0.150
     6.914   103.922     0.150
     7.274   105.586     0.150
     7.471   107.617     0.150
     7.471   187.211     0.150
     7.757   113.492     0.150
     9.321   134.469     0.150
    30.257   371.328     0.150
     0.144     3.648     0.150
     0.144     6.727     0.150
     0.201     4.664     0.150
     0.201     7.477     0.150
     0.213     4.609     0.150
     0.213     8.711     0.150
     0.265     5.352     0.150
     0.265    10.312     0.150
     0.280     5.453     0.150
     0.337     6.719     0.150
     0.337    12.961     0.150
     0.367     7.188     0.150
     0.371     7.203     0.150
     0.371    13.109     0.150
     0.387     7.578     0.150
     0.387    14.219     0.150
     0.376     7.094     0.150
     0.376    13.398     0.150
     0.386     7.938     0.150
     0.447     8.703     0.150
     0.479     9.148     0.150
     0.492     9.273     0.150
     0.553    10.633     0.150
     0.610    10.789     0.150
     0.625    11.328     0.150
     0.615    10.828     0.150
     0.679    11.977     0.150
     0.679    23.312     0.150
     0.731    12.719     0.150
     0.713    13.562     0.150
     0.768    13.617     0.150
     0.757    14.398     0.150
     0.754    14.094     0.150
     0.837    14.672     0.150
     0.894    16.938     0.150
     0.964    17.141     0.150
     1.026    19.062     0.150
     1.055    18.781     0.150
     1.055    34.312     0.150
     1.103    19.477     0.150
     1.122    20.141     0.150
     1.161    21.008     0.150
     1.161    38.312     0.150
     1.215    22.297     0.150
     1.263    21.852     0.150
     1.298    24.148     0.150
     1.332    23.898     0.150
     1.373    25.758     0.150
     1.377    25.180     0.150
     1.510    26.680     0.150
     1.519    25.891     0.150
     1.632    28.641     0.150
     1.713    27.758     0.150
     1.717    29.680     0.150
     1.791    30.719     0.150
     1.874    31.820     0.150
     1.879    31.719     0.150
     1.920    33.633     0.150
     1.925    34.461     0.150
     1.993    59.312     0.150
     2.085    35.133     0.150
     2.181    37.562     0.150
     2.194    37.219     0.150
     2.334    37.820     0.150
     2.334    67.023     0.150
     2.333    38.922     0.150
     2.373    40.750     0.150
     2.435    38.742     0.150
     2.435    66.930     0.150
     2.474    44.891     0.150
     2.552    43.102     0.150
     2.640    41.672     0.150
     2.640    73.312     0.150
     2.648    41.758     0.150
     2.648    74.117     0.150
     2.701    42.609     0.150
     2.846    42.320     0.150
     2.851    45.141     0.150
     2.851    45.320     0.150
     2.851    45.539     0.150
     2.842    49.203     0.150
     2.905    45.609     0.150
     2.992    47.398     0.150
     2.992    83.078     0.150
     3.054    48.203     0.150
     3.054    82.891     0.150
     3.187    49.562     0.150
     3.210    50.422     0.150
     3.210    86.219     0.150
     3.210    50.523     0.150
     3.216    50.023     0.150
     3.216    88.922     0.150
     3.286    51.812     0.150
     3.286    90.867     0.150
     3.412    53.422     0.150
     3.412    53.023     0.150
     3.412    93.820     0.150
     3.461    53.820     0.150
     3.461    94.922     0.150
     3.547    54.633     0.150
     3.544    54.719     0.150
     3.544    97.320     0.150
     3.600    57.219     0.150
     3.641    56.523     0.150
     3.641    99.719     0.150
     3.648    56.320     0.150
     3.648    56.422     0.150
     3.648    99.523     0.150
     3.656    56.023     0.150
     3.656    99.820     0.150
     3.685    56.820     0.150
     3.685   100.320     0.150
     3.753    58.023     0.150
     3.753   100.523     0.150
     3.753    57.922     0.150
     3.753    58.023     0.150
     3.753   102.422     0.150
     3.785    58.820     0.150
     3.785    58.719     0.150
     3.785   103.320     0.150
     3.918    61.023     0.150
     3.918   104.922     0.150
     3.918    60.875     0.150
     3.918    61.453     0.150
     3.952   104.312     0.150
     4.058    62.820     0.150
     4.058   109.617     0.150
     4.096    62.922     0.150
     4.096   108.719     0.150
     4.096    63.148     0.150
     4.155    63.164     0.150
     4.146    64.109     0.150
     4.158    63.422     0.150
     4.158   111.523     0.150
     4.206    64.117     0.150
     4.281    65.617     0.150
     4.286    64.523     0.150
     4.286    64.719     0.150
     4.297    66.117     0.150
     4.297   115.422     0.150
     4.328    66.422     0.150
     4.328   116.023     0.150
     4.346    66.523     0.150
     4.430    67.523     0.150
     4.430   117.023     0.150
     4.430    67.820     0.150
     4.496    67.617     0.150
     4.519    68.922     0.150
     4.519   119.117     0.150
     4.548    68.344     0.150
     4.642    86.727     0.150
     4.651    70.422     0.150
     4.651    70.711     0.150
     4.766    71.719     0.150
     4.766   123.523     0.150
     4.912    74.117     0.150
     4.912    73.922     0.150
     5.117    76.094     0.150
     5.117   135.828     0.150
     5.224    76.328     0.150
     5.232    78.023     0.150
     5.267    78.219     0.150
     5.267   138.555     0.150
     5.269    78.922     0.150
     5.303    78.172     0.150
     5.303   140.125     0.150
     5.291    79.023     0.150
     5.443    80.422     0.150
     5.528    82.422     0.150
     5.528   144.734     0.150
     5.680    84.617     0.150
     5.707    82.414     0.150
     5.707   148.352     0.150
     5.716    85.422     0.150
     5.738    84.438     0.150
     5.784    85.648     0.150
     5.830    85.523     0.150
     5.911    86.359     0.150
     5.911   154.344     0.150
     6.046    88.406     0.150
     6.046   159.398     0.150
     6.109    90.422     0.150
     6.145    89.820     0.150
     6.195    89.414     0.150
     6.201    92.367     0.150
     6.201   162.445     0.150
     6.222    93.391     0.150
     6.222   162.992     0.150
     6.250    92.023     0.150
     6.250   159.523     0.150
     6.267    91.344     0.150
     6.267   165.648     0.150
     6.283    93.719     0.150
     6.283   165.008     0.150
     6.321    92.820     0.150
     6.369    94.320     0.150
     6.369   161.820     0.150
     6.409   168.758     0.150
     6.458    94.945     0.150
     6.458   168.711     0.150
     6.520    96.719     0.150
     6.616    94.898     0.150
     6.633    99.266     0.150
     6.633   174.328     0.150
     6.655    97.422     0.150
     6.655    98.180     0.150
     6.732    98.180     0.150
     6.732   176.828     0.150
     6.721    97.523     0.150
     6.721    98.023     0.150
     6.909   102.570     0.150
     7.012   103.320     0.150
     7.012   174.219     0.150
     7.172   106.117     0.150
     7.280   106.094     0.150
     7.471   107.797     0.150
     7.762   111.117     0.150
     7.762   195.617     0.150
     7.759   113.023     0.150
     7.759   193.820     0.150
     8.042   117.586     0.150
     8.300   120.117     0.150
     8.389   205.820     0.150
     8.657   122.117     0.150
     8.657   213.422     0.150
     8.665   126.602     0.150
     8.726   125.797     0.150
     8.760   122.820     0.150
     9.165   131.820     0.150
     9.327   136.094     0.150
     9.327   134.883     0.150
     9.902   142.805     0.150
    21.290   285.141     0.150
    30.253   371.367     0.150
    62.011   618.805     0.150
     0.046     2.502     0.150
     0.046     4.752     0.150
     0.099     3.162     0.150
     0.099     5.332     0.150
     0.192     4.281     0.150
     0.192     7.961     0.150
     0.192     8.371     0.150
     0.174     4.191     0.150
     0.174     8.012     0.150
     0.174     8.152     0.150
     0.204     4.801     0.150
     0.204     8.822     0.150
     0.204     9.121     0.150
     0.328     6.182     0.150
     0.285     6.002     0.150
     0.285    11.252     0.150
     0.336     6.402     0.150
     0.336    12.172     0.150
     0.336    11.162     0.150
     0.420     8.012     0.150
     0.358     7.822     0.150
     0.421     8.051     0.150
     0.409     7.951     0.150
     0.434     8.762     0.150
     0.442     8.242     0.150
     0.501     9.471     0.150
     0.440     8.762     0.150
     0.440    15.801     0.150
     0.537    10.291     0.150
     0.511    10.342     0.150
     0.518    10.771     0.150
     0.604    12.572     0.150
     0.596    10.762     0.150
     0.629    11.201     0.150
     0.721    12.662     0.150
     0.661    12.301     0.150
     0.754    14.182     0.150
     0.705    13.072     0.150
     0.780    13.602     0.150
     0.780    24.742     0.150
     0.820    14.301     0.150
     0.941    17.352     0.150
     0.979    17.012     0.150
     0.973    18.371     0.150
     1.028    19.012     0.150
     1.028    18.902     0.150
     1.028    32.762     0.150
     1.072    19.480     0.150
     1.148    19.941     0.150
     1.130    20.652     0.150
     1.278    23.141     0.150
     1.313    24.332     0.150
     1.246    22.832     0.150
     1.459    24.711     0.150
     1.788    31.221     0.150
     1.788    51.891     0.150
     1.742    30.041     0.150
     1.742    53.941     0.150
     1.828    31.041     0.150
     2.144    36.541     0.150
     2.283    38.041     0.150
     2.332    37.551     0.150
     2.391    39.281     0.150
     2.391    67.971     0.150
     2.375    39.242     0.150
     2.449    39.162     0.150
     2.664    41.271     0.150
     2.663    42.291     0.150
     2.694    42.811     0.150
     2.694    74.822     0.150
     2.791    44.551     0.150
     2.791    75.631     0.150
     2.832    45.072     0.150
     2.832    44.791     0.150
     2.832    44.941     0.150
     2.914    48.402     0.150
     3.000    47.182     0.150
     3.030    48.422     0.150
     3.030    84.092     0.150
     3.182    49.230     0.150
     3.225    51.262     0.150
     3.225    85.842     0.150
     3.214    49.951     0.150
     3.214    88.102     0.150
     3.186    49.941     0.150
     3.187    49.641     0.150
     3.187    49.742     0.150
     3.187    88.041     0.150
     3.303    52.291     0.150
     3.283    51.701     0.150
     3.283    88.162     0.150
     3.293    50.221     0.150
     3.293    89.672     0.150
     3.389    53.041     0.150
     3.430    53.242     0.150
     3.430    94.041     0.150
     3.516    54.742     0.150
     3.516    96.141     0.150
     3.583    55.711     0.150
     3.583    96.561     0.150
     3.579    56.230     0.150
     3.605    57.441     0.150
     3.615    56.041     0.150
     3.615    98.242     0.150
     3.615    56.041     0.150
     3.615    98.441     0.150
     3.621    56.242     0.150
     3.621    98.941     0.150
     3.699    57.742     0.150
     3.660    56.441     0.150
     3.660   100.041     0.150
     3.722    57.711     0.150
     3.722    57.441     0.150
     3.722   100.602     0.150
     3.722    57.541     0.150
     3.722   100.941     0.150
     3.765    59.041     0.150
     3.877    62.941     0.150
     3.901    61.701     0.150
     3.945    63.182     0.150
     3.956    58.922     0.150
     3.924    60.582     0.150
     3.924    60.381     0.150
     3.924   105.592     0.150
     3.963    60.381     0.150
     3.963    59.441     0.150
     4.137    63.441     0.150
     4.137   111.441     0.150
     4.180    63.102     0.150
     4.180   111.301     0.150
     4.198    62.922     0.150
     4.255    63.541     0.150
     4.255   112.242     0.150
     4.262    64.842     0.150
     4.274    64.342     0.150
     4.267    64.842     0.150
     4.267   114.342     0.150
     4.290    63.541     0.150
     4.313    65.271     0.150
     4.301    65.342     0.150
     4.301   115.242     0.150
     4.377    66.242     0.150
     4.414    67.441     0.150
     4.492    67.141     0.150
     4.492   119.072     0.150
     4.520    67.041     0.150
     4.562    68.262     0.150
     4.597    68.941     0.150
     4.671    69.652     0.150
     4.682    70.711     0.150
     4.682    70.242     0.150
     4.721    70.172     0.150
     4.772    73.322     0.150
     4.896    72.451     0.150
     4.896   124.262     0.150
     4.887    72.541     0.150
     4.896    73.242     0.150
     4.967    74.682     0.150
     4.979    73.951     0.150
     5.062   134.652     0.150
     5.115    75.631     0.150
     5.115   132.291     0.150
     5.147    77.174     0.150
     5.147    76.682     0.150
     5.224    76.961     0.150
     5.233    77.871     0.150
     5.245    79.941     0.150
     5.245   137.242     0.150
     5.302    79.154     0.150
     5.331    78.637     0.150
     5.331   141.160     0.150
     5.370    78.641     0.150
     5.436    79.041     0.150
     5.569    82.570     0.150
     5.680    84.621     0.150
     5.712    83.541     0.150
     5.768    84.541     0.150
     5.768   147.842     0.150
     5.774    86.379     0.150
     5.774    85.100     0.150
     5.847    86.201     0.150
     5.795    88.822     0.150
     5.936    86.957     0.150
     5.936    86.580     0.150
     5.994    89.041     0.150
     6.073    90.381     0.150
     6.090    89.811     0.150
     6.196    89.842     0.150
     6.196   156.941     0.150
     6.226    90.041     0.150
     6.226   157.941     0.150
     6.244    93.658     0.150
     6.244    93.484     0.150
     6.244   164.260     0.150
     6.267    92.559     0.150
     6.214    92.842     0.150
     6.311    93.254     0.150
     6.311   165.393     0.150
     6.325    93.969     0.150
     6.350    94.008     0.150
     6.350   164.734     0.150
     6.304    92.779     0.150
     6.304   160.996     0.150
     6.453    95.225     0.150
     6.488    95.461     0.150
     6.490    95.932     0.150
     6.490   167.184     0.150
     6.490    95.709     0.150
     6.490   167.660     0.150
     6.449    96.541     0.150
     6.449    97.041     0.150
     6.469    96.342     0.150
     6.572    98.541     0.150
     6.572   166.242     0.150
     6.568    96.242     0.150
     6.640    96.305     0.150
     6.677    99.088     0.150
     6.621    98.041     0.150
     6.621    97.762     0.150
     6.621    98.342     0.150
     6.621   169.311     0.150
     6.710    98.141     0.150
     6.764   100.994     0.150
     6.779   102.047     0.150
     6.779   101.484     0.150
     6.789    99.770     0.150
     6.865   101.443     0.150
     6.910   102.516     0.150
     6.910   103.441     0.150
     6.980   176.242     0.150
     7.002   101.342     0.150
     7.002   176.641     0.150
     6.950   102.541     0.150
     7.048   105.418     0.150
     7.064   102.342     0.150
     7.064   178.842     0.150
     7.085   102.541     0.150
     7.127   105.441     0.150
     7.224   108.742     0.150
     7.224   181.441     0.150
     7.196   106.342     0.150
     7.264   106.041     0.150
     7.288   104.141     0.150
     7.288   182.541     0.150
     7.288   138.141     0.150
     7.319   107.941     0.150
     7.452   108.641     0.150
     7.505   108.572     0.150
     7.505   108.422     0.150
     7.505   107.842     0.150
     7.514   110.041     0.150
     7.607   109.842     0.150
     7.600   110.742     0.150
     7.700   199.541     0.150
     7.684   113.342     0.150
     7.689   113.041     0.150
     7.772   112.641     0.150
     7.772   196.242     0.150
     7.796   112.141     0.150
     7.796   111.742     0.150
     7.796   145.941     0.150
     7.796   196.342     0.150
     7.773   114.084     0.150
     7.778   114.688     0.150
     7.819   113.541     0.150
     7.819   197.441     0.150
     7.830   113.541     0.150
     7.830   202.141     0.150
     7.865   113.900     0.150
     7.979   113.941     0.150
     7.979   199.941     0.150
     7.966   115.742     0.150
     8.007   200.342     0.150
     8.035   117.941     0.150
     8.086   118.441     0.150
     8.086   117.262     0.150
     8.086   116.242     0.150
     8.086   202.342     0.150
     8.222   119.441     0.150
     8.278   118.641     0.150
     8.278   207.242     0.150
     8.215   118.842     0.150
     8.215   118.541     0.150
     8.297   121.141     0.150
     8.328   120.764     0.150
     8.335   120.941     0.150
     8.439   120.342     0.150
     8.439   210.742     0.150
     8.411   123.271     0.150
     8.469   123.342     0.150
     8.545   123.842     0.150
     8.603   219.242     0.150
     8.629   123.141     0.150
     8.612   124.939     0.150
     8.631   126.342     0.150
     8.706   123.842     0.150
     8.706   217.041     0.150
     8.686   126.641     0.150
     8.686   126.342     0.150
     8.686   219.441     0.150
     8.686   125.471     0.150
     8.706   126.842     0.150
     8.810   125.242     0.150
     8.810   219.342     0.150
     8.743   126.242     0.150
     8.743   220.941     0.150
     8.743   126.541     0.150
     8.863   126.742     0.150
     8.956   130.041     0.150
     9.035   132.842     0.150
     9.082   131.441     0.150
     9.107   131.951     0.150
     9.133   132.941     0.150
     9.133   236.941     0.150
     9.125   130.842     0.150
     9.148   132.719     0.150
     9.143   131.641     0.150
     9.161   132.562     0.150
     9.203   132.541     0.150
     9.225   134.344     0.150
     9.293   131.541     0.150
     9.293   231.342     0.150
     9.277   133.242     0.150
     9.294   132.141     0.150
     9.307   135.541     0.150
     9.307   135.086     0.150
     9.307   135.301     0.150
     9.297   135.742     0.150
     9.358   136.041     0.150
     9.358   134.541     0.150
     9.453   137.457     0.150
     9.522   135.391     0.150
     9.567   139.742     0.150
     9.604   139.342     0.150
     9.586   139.041     0.150
     9.748   138.041     0.150
     9.759   139.842     0.150
     9.794   141.242     0.150
     9.892   143.941     0.150
     9.900   143.531     0.150
     9.901   142.842     0.150
     9.957   143.541     0.150
     9.957   144.742     0.150
    10.002   143.441     0.150
    10.002   250.441     0.150
    10.002   142.881     0.150
     9.950   141.641     0.150
    10.041   145.518     0.150
    10.177   147.121     0.150
    10.396   150.141     0.150
    10.680   153.641     0.150
    10.680   153.451     0.150
    10.751   154.773     0.150
    10.778   156.941     0.150
    12.329   176.742     0.150
    13.064   186.842     0.150
    13.839   194.941     0.150
    13.839   195.344     0.150
    14.133   199.266     0.150
    14.662   208.541     0.150
    18.168   251.473     0.150
    18.605   259.617     0.150
    18.804   258.199     0.150
    18.796   259.242     0.150
    19.485   266.521     0.150
    19.634   268.041     0.150
    19.808   268.941     0.150
    19.808   269.533     0.150
    19.812   269.391     0.150
    19.852   270.602     0.150
    20.026   272.441     0.150
    20.072   272.381     0.150
    20.875   278.742     0.150
    20.875   286.541     0.150
    20.867   283.141     0.150
    20.937   285.842     0.150
    21.031   285.166     0.150
    21.309   285.266     0.150
    21.310   286.611     0.150
    21.841   294.742     0.150
    22.906   306.041     0.150
    22.906   305.561     0.150
    27.621   344.541     0.150
    28.825   358.717     0.150
    30.243   370.311     0.150
    30.243   370.941     0.150
    31.234   379.766     0.150
    32.031   387.242     0.150
    32.031   454.441     0.150
    32.031   702.342     0.150
    32.031   809.641     0.150
    32.031   386.711     0.150
    33.514   399.721     0.150
    38.600   442.641     0.150
    38.600   442.816     0.150
    38.688   443.941     0.150
    38.720   443.842     0.150
    38.787   444.229     0.150
    38.837   444.941     0.150
    39.074   446.842     0.150
    43.790   488.141     0.150
    43.790   487.436     0.150
    43.790   487.221     0.150
    44.171   489.291     0.150
    44.204   491.541     0.150
    44.204   490.082     0.150
    45.966   507.441     0.150
    45.966   909.742     0.150
    45.966  1100.742     0.150
    47.104   512.365     0.150
    47.652   517.641     0.150
    47.652   515.541     0.150
    52.309   551.742     0.150
    52.937   553.467     0.150
    52.937   554.480     0.150
    58.536   599.141     0.150
    61.999   619.801     0.150
    62.360   621.441     0.150
    62.376   625.242     0.150
    66.872   652.742     0.150
    66.872   802.041     0.150
    68.736   662.342     0.150
    68.994   666.242     0.150
    69.842   669.342     0.150
    70.329   673.041     0.150
    70.329   671.967     0.150
    70.332   672.791     0.150
    72.900   688.932     0.150
    73.317   692.561     0.150
    73.962   695.051     0.150
    74.902   700.852     0.150
    75.542   703.842     0.150
    80.347   731.332     0.150
    80.700   733.752     0.150
    80.786   734.742     0.150
    82.237   741.191     0.150
    83.920   749.041     0.150
    89.383   776.004     0.150
     0.043     2.533     0.150
     0.043     5.152     0.150
     0.186     4.043     0.150
     0.186     8.232     0.150
     0.177     4.312     0.150
     0.177     7.992     0.150
     0.198     4.752     0.150
     0.198     9.434     0.150
     0.318     6.062     0.150
     0.318    11.723     0.150
     0.293     6.223     0.150
     0.293    11.412     0.150
     0.346     6.492     0.150
     0.358     7.742     0.150
     0.411     7.572     0.150
     0.411