#!/bin/bash
gmt begin larino1.84_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-5/4/0/71
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya20f10+l'Counts' -BWeSn+t'Origin Time Mislocation larino1.84' << EOF
    -1.195
     1.211
    -2.129
    -0.180
     0.508
     0.469
     0.098
     0.643
     1.484
     1.277
     0.539
    -0.424
     0.441
     0.363
     1.021
    -0.439
     1.000
     2.512
    -0.635
     1.805
     1.172
    -0.254
     1.057
    -3.117
    -0.234
    -1.547
     0.367
    -1.473
    -0.016
     0.188
     0.938
    -0.703
    -0.406
     0.309
    -1.188
    -0.203
    -0.266
    -0.945
     0.883
    -0.250
     1.320
     0.867
     0.309
     1.164
     0.594
    -0.484
    -1.293
    -0.578
    -0.557
    -0.016
     0.188
    -1.549
     0.797
    -0.164
    -0.402
     0.082
    -0.359
    -0.125
    -0.539
    -0.191
    -0.469
    -0.539
    -1.395
    -1.715
    -0.250
    -0.844
    -0.023
     1.160
     0.688
    -0.508
     0.016
     0.188
    -0.066
    -0.480
     0.141
    -0.184
    -0.020
    -0.172
    -0.711
    -0.190
    -0.430
    -0.297
    -0.633
    -1.293
    -0.082
    -0.469
    -0.047
    -0.043
     0.117
    -0.812
    -0.752
    -0.133
    -0.059
    -0.328
    -1.275
    -1.692
    -0.947
    -0.121
    -0.383
    -0.824
    -0.781
    -2.152
    -0.756
    -1.117
    -0.043
     1.773
    -0.051
     0.367
    -0.734
    -0.172
    -0.602
    -0.828
    -0.223
     0.418
    -0.461
    -0.039
     0.039
    -1.012
     0.537
     0.041
     0.410
     0.676
    -0.734
     0.031
     0.070
     0.156
     0.102
     0.113
    -0.182
     0.465
    -0.035
    -0.148
    -0.738
    -0.008
    -0.297
     0.201
     0.023
     0.188
     0.078
     0.105
     0.156
    -0.242
    -0.258
    -0.306
    -0.825
    -0.204
     0.758
     0.320
    -0.836
    -1.086
    -0.117
     1.453
     2.469
    -0.988
     0.969
    -1.000
     0.492
     0.566
    -0.359
    -0.223
     0.500
     0.152
     0.207
     0.237
    -0.008
    -0.344
    -0.047
     0.555
    -0.669
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.121    62.728 Median =  -0.1 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.1  0.
 -0.1  61.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -4.800    67.272 Author: all ( 169 samples)
EOF
gmt end
