#!/bin/bash
gmt begin larino1.84_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-25/25/-25/25
gmt basemap $proj $reg -Bxa10f5+l'km' -Bya10f5+l'km' -BWeSn+t'Epicentral Mislocation larino1.84'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     8.089     8.089
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.713     0.395
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.426     4.885
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.887    -3.403
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.946    22.380
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.946    22.380 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.579     5.112
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.579     5.112 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.259    -1.809
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.259    -1.809 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.603     8.586
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.603     8.586 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.051    14.592
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.051    14.592 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.852    13.448
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.852    13.448 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.233     5.347
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.233     5.347 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.260    -3.878
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.907     4.558
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.907     4.558 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.888     1.993
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.293     8.403
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.293     8.403 14
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -22.872     5.703
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -22.872     5.703 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.077     2.208
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.358     5.403
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.358     5.403 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.751    13.760
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.751    13.760 18
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.328    18.783
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.328    18.783 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.978     2.217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.934     1.230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.508     8.682
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.508     8.682 22
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.012    -4.357
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.107     9.015
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.107     9.015 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.204    -2.722
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.126    -2.031
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.377    -1.296
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.395     5.031
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.044    -1.419
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.184    10.107
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.184    10.107 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.216    13.989
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.216    13.989 31
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     8.092
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.000     8.092 32
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.333     1.242
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.016     7.769
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.016     7.769 34
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.550     0.658
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.550     0.658 35
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.011   -13.760
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.011   -13.760 36
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.691     3.207
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.621     0.229
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.406     3.774
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.406     3.774 39
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.241    -4.602
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.940     2.556
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.679     5.064
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.138     3.953
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.356     2.780
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.460    18.339
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.460    18.339 45
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.545     1.763
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.545     1.763 46
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.997     6.296
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.435     2.521
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.013    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.763     7.117
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.763     7.117 50
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.626     5.383
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.979     0.911
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.592     0.995
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.629     4.316
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.696     5.548
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.479     1.622
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.853    -1.919
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.337     7.194
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.143     5.049
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.844    -0.553
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.060     3.427
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.589     8.177
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.589     8.177 62
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.196     9.742
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.196     9.742 63
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.678     9.695
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.678     9.695 64
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.642     1.443
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.891     3.974
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.516     1.062
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.520     3.286
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.181    -8.287
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.181    -8.287 69
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.825    -0.421
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.518     1.763
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.894     8.404
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.894     8.404 72
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.193    -1.279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.999     5.402
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.278     0.067
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.132     1.890
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.346     1.723
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.002     8.324
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.002     8.324 78
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.676     6.430
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.594     5.562
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.993     5.789
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.202     1.922
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.230     4.236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.439     0.331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.458     0.548
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.693    -2.134
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.247    -3.531
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.464     5.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.461    -3.279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.212     2.856
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.744    -0.533
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.063    -4.048
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.407    -0.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.950     5.950
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.950     5.950 94
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.723     4.531
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.522     1.873
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.010    -3.852
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.077    -6.800
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.417    -0.885
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.491     4.311
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.738     4.169
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.570     5.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.816     9.874
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.816     9.874 103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.110     7.895
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.724    -0.413
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.543   -11.306
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.543   -11.306 106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.321    -6.130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.292     0.527
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.355    -2.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.649     0.666
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.094    -2.850
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.917     2.544
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.652     2.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.007     1.248
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.672     0.321
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.442    -1.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.025     1.622
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.097     4.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.632    -0.098
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.557    -2.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.603    -1.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.654    -1.782
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.143     2.545
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.850     0.817
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.408     2.648
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.959     1.103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.082     1.405
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.911     0.201
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.082     0.031
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.573     1.736
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.017     1.604
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.768    -1.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.704    -1.824
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.675     2.143
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.224     0.313
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.940    -1.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.657    -0.729
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.858     1.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.809     1.809
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.193     1.236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.935    -0.172
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.255     0.784
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.203     1.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.700     2.499
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.068     6.117
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.068     6.117 145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.201     3.144
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.528     3.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.035     1.723
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.897     2.701
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.433     1.970
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.662     3.287
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.636   -11.886
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.636   -11.886 152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     1.919
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.395    -0.210
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.588    -2.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.130     2.538
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.622     0.541
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.783     2.562
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.313     3.573
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.035     2.145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.248     1.767
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.308    -0.604
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.167     0.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.109     0.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.212     0.997
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.700    -0.609
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.562     0.719
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.110     0.695
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000     3.116
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -2.619     2.303     0.000     1.500     1.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -23.500    23.500 Author: all ( 169 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -23.500   -23.500 Average =   3.5 km at 311.3 deg; median =    4.0 km
EOF
gmt end
