#!/bin/bash
gmt begin larino1.84_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-27/17/0/25
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya25f5+lCounts -BWeSn+t'Focal Depth Mislocation larino1.84' << EOF
    -0.000
     5.600
   -11.000
    -0.000
    -1.000
    -3.000
    -4.000
    -0.000
     2.000
     5.000
     5.400
    -5.000
    -0.000
    -0.000
    -1.100
    -4.500
    -1.100
    11.600
   -13.000
     9.500
    10.800
    -0.000
     2.000
   -22.000
   -10.000
    -3.600
    -2.000
   -19.600
     1.000
     1.000
     8.400
   -12.000
     6.000
     9.500
   -15.000
    -0.000
     3.000
   -20.000
     2.200
    -9.000
     9.000
     9.000
     9.000
     5.000
    -1.400
    -7.700
    -7.100
    -7.900
    -3.000
    -1.600
     4.400
   -16.700
     0.900
    -3.700
    -0.500
     5.100
   -12.000
     3.300
    -1.400
     2.000
    -1.700
    -7.300
   -10.000
   -15.800
    -5.000
     0.200
     1.000
     6.900
     7.000
    -6.000
    -0.000
    -2.500
    -6.000
     1.000
     3.000
    -3.000
    -0.000
     3.000
    -2.300
     1.000
     9.100
    -0.000
     0.400
   -11.400
     9.400
    -6.000
    -8.000
    -0.000
    -0.000
    -6.000
    -3.000
    -2.000
    -0.200
    -1.200
    -4.600
   -15.000
    -8.000
    -5.000
    -4.800
    -2.000
    -4.700
   -22.000
    -3.000
     4.500
    -2.100
    -7.200
    -2.100
     4.000
   -10.900
     1.500
    -1.900
    -4.200
    -7.600
    -7.300
     1.400
     0.300
    -1.200
   -10.000
    -0.400
     2.700
     2.400
    -2.700
   -11.000
    -1.700
    -3.400
    -5.700
    -4.300
    -0.100
     0.500
     0.600
     1.400
   -13.000
     6.900
     4.100
    -2.400
     0.100
     3.000
    -0.300
     6.400
    -2.200
    -2.200
    -4.400
     2.500
    -1.800
    -3.000
    -2.900
     0.800
    -3.500
    -7.500
    -4.000
    -5.100
    -3.000
     7.000
     6.500
     3.000
    -2.000
     6.900
     2.500
    -1.800
     6.500
     2.000
     1.600
    -3.200
     0.400
    -5.000
     1.700
     1.300
     0.800
     9.200
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -1.100    22.312 Median =  -1.1 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -1.1  0.
 -1.1  21.9
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -26.000    23.688 Author: all ( 169 samples)
EOF
gmt end
