#!/bin/bash
gmt begin larino1.84_dcal pdf,ps
proj=-JM16.0c+
reg=-R11.7/18.4/38.9/43.9
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration larino1.84'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
    14.398    40.827
    15.056    41.125
>
    14.398    40.827
    15.056    41.125
>
    14.379    41.387
    14.989    41.114
>
    14.398    40.827
    14.989    41.114
>
    15.551    41.450
    14.989    41.114
>
    15.551    41.450
    14.989    41.114
>
    15.551    41.450
    15.337    41.871
>
    15.551    41.450
    15.337    41.871
>
    14.398    40.827
    15.050    40.879
>
    14.398    40.827
    15.020    40.951
>
    15.551    41.450
    15.283    40.966
>
    15.551    41.450
    15.351    40.945
>
    15.551    41.450
    15.082    41.093
>
    14.398    40.827
    15.002    41.084
>
    15.551    41.450
    15.002    41.084
>
    14.379    41.387
    15.002    41.084
>
    15.551    41.450
    15.351    40.887
>
    14.398    40.827
    14.612    40.972
>
    13.971    41.191
    14.612    40.972
>
    14.458    41.659
    14.344    41.631
>
    14.458    41.659
    14.344    41.631
>
    13.810    41.709
    14.344    41.631
>
    13.971    41.191
    14.344    41.631
>
    15.949    41.707
    15.843    41.659
>
    15.949    41.707
    15.843    41.659
>
    14.458    41.659
    14.330    41.610
>
    14.379    41.387
    14.330    41.610
>
    13.971    41.191
    14.330    41.610
>
    14.398    40.827
    14.666    41.145
>
    14.398    40.827
    14.666    41.145
>
    13.971    41.191
    14.666    41.145
>
    14.458    41.659
    14.215    41.657
>
    13.810    41.709
    14.215    41.657
>
    14.458    41.659
    14.659    41.521
>
    14.458    41.659
    14.659    41.521
>
    14.458    41.659
    14.907    41.567
>
    14.458    41.659
    14.907    41.567
>
    14.458    41.659
    14.473    41.327
>
    14.458    41.659
    14.473    41.327
>
    13.985    41.301
    14.473    41.327
>
    14.458    41.659
    15.215    41.738
>
    14.458    41.659
    15.215    41.738
>
    14.458    41.659
    15.156    41.710
>
    14.458    41.659
    14.677    41.396
>
    14.458    41.659
    14.677    41.396
>
    15.268    41.282
    14.677    41.396
>
    13.985    41.301
    14.677    41.396
>
    15.161    41.805
    14.677    41.396
>
    14.458    41.659
    14.548    41.309
>
    14.458    41.659
    14.649    41.356
>
    14.458    41.659
    14.649    41.356
>
    15.268    41.282
    14.649    41.356
>
    13.985    41.301
    14.649    41.356
>
    15.161    41.805
    14.649    41.356
>
    13.810    41.709
    14.306    41.468
>
    15.949    41.707
    15.785    41.743
>
    15.161    41.805
    15.785    41.743
>
    15.161    41.805
    15.327    41.909
>
    15.161    41.805
    15.327    41.909
>
    15.268    41.282
    15.298    41.853
>
    15.268    41.282
    15.298    41.853
>
    15.161    41.805
    15.355    41.927
>
    15.161    41.805
    15.355    41.927
>
    15.161    41.805
    15.396    41.796
>
    15.161    41.805
    15.396    41.796
>
    15.586    41.674
    15.396    41.796
>
    15.949    41.707
    15.396    41.796
>
    15.268    41.282
    15.396    41.796
>
    15.268    41.282
    15.396    41.796
>
    15.586    41.674
    15.722    41.517
>
    15.586    41.674
    15.722    41.517
>
    15.949    41.707
    15.722    41.517
>
    15.949    41.707
    15.722    41.517
>
    15.268    41.282
    15.722    41.517
>
    15.517    41.132
    15.722    41.517
>
    15.586    41.674
    14.897    41.697
>
    15.586    41.674
    14.897    41.697
>
    15.268    41.282
    14.897    41.697
>
    15.268    41.282
    14.897    41.697
>
    14.153    41.703
    14.897    41.697
>
    14.153    41.703
    14.897    41.697
>
    14.319    41.585
    14.894    41.709
>
    14.319    41.585
    14.894    41.709
>
    15.268    41.282
    14.894    41.709
>
    15.268    41.282
    14.894    41.709
>
    15.586    41.674
    14.894    41.709
>
    14.153    41.703
    14.894    41.709
>
    14.319    41.585
    14.940    41.709
>
    14.319    41.585
    14.940    41.709
>
    15.586    41.674
    14.940    41.709
>
    15.586    41.674
    14.940    41.709
>
    15.268    41.282
    14.940    41.709
>
    14.319    41.585
    14.857    41.694
>
    14.319    41.585
    14.857    41.694
>
    14.153    41.703
    14.857    41.694
>
    14.153    41.703
    14.857    41.694
>
    15.268    41.282
    14.857    41.694
>
    15.268    41.282
    14.857    41.694
>
    15.586    41.674
    14.857    41.694
>
    15.586    41.674
    14.857    41.694
>
    15.586    41.674
    14.933    41.721
>
    15.268    41.282
    14.933    41.721
>
    14.153    41.703
    14.933    41.721
>
    14.153    41.703
    14.933    41.721
>
    15.268    41.282
    14.872    41.707
>
    15.268    41.282
    14.872    41.707
>
    15.586    41.674
    14.877    41.705
>
    15.586    41.674
    14.877    41.705
>
    15.268    41.282
    14.877    41.705
>
    15.586    41.674
    14.918    41.714
>
    15.586    41.674
    14.918    41.714
>
    15.268    41.282
    14.918    41.714
>
    14.153    41.703
    14.918    41.714
>
    14.153    41.703
    14.918    41.714
>
    14.319    41.585
    14.913    41.692
>
    14.319    41.585
    14.913    41.692
>
    15.268    41.282
    14.913    41.692
>
    15.268    41.282
    14.913    41.692
>
    15.586    41.674
    14.913    41.692
>
    15.586    41.674
    14.913    41.692
>
    14.153    41.703
    14.913    41.692
>
    14.153    41.703
    14.913    41.692
>
    14.319    41.585
    14.930    41.683
>
    14.319    41.585
    14.930    41.683
>
    15.586    41.674
    14.930    41.683
>
    15.586    41.674
    14.930    41.683
>
    15.268    41.282
    14.930    41.683
>
    14.153    41.703
    14.930    41.683
>
    14.153    41.703
    14.930    41.683
>
    14.319    41.585
    14.862    41.690
>
    14.319    41.585
    14.862    41.690
>
    14.153    41.703
    14.862    41.690
>
    15.586    41.674
    14.862    41.690
>
    15.268    41.282
    14.862    41.690
>
    14.319    41.585
    14.821    41.691
>
    14.319    41.585
    14.821    41.691
>
    14.153    41.703
    14.821    41.691
>
    14.153    41.703
    14.821    41.691
>
    15.586    41.674
    14.821    41.691
>
    15.586    41.674
    14.821    41.691
>
    15.268    41.282
    14.821    41.691
>
    15.268    41.282
    14.821    41.691
>
    14.153    41.703
    14.829    41.691
>
    15.586    41.674
    14.829    41.691
>
    15.586    41.674
    14.829    41.691
>
    15.268    41.282
    14.829    41.691
>
    15.268    41.282
    14.829    41.691
>
    14.153    41.703
    14.822    41.703
>
    14.153    41.703
    14.822    41.703
>
    15.268    41.282
    14.822    41.703
>
    15.586    41.674
    14.822    41.703
>
    15.586    41.674
    14.822    41.703
>
    14.153    41.703
    14.841    41.726
>
    15.268    41.282
    14.841    41.726
>
    15.586    41.674
    14.841    41.726
>
    15.586    41.674
    14.841    41.726
>
    14.153    41.703
    14.832    41.709
>
    14.153    41.703
    14.832    41.709
>
    15.268    41.282
    14.832    41.709
>
    15.268    41.282
    14.832    41.709
>
    15.586    41.674
    14.832    41.709
>
    15.586    41.674
    14.832    41.709
>
    14.153    41.703
    14.842    41.720
>
    14.153    41.703
    14.842    41.720
>
    15.586    41.674
    14.842    41.720
>
    15.586    41.674
    14.842    41.720
>
    15.268    41.282
    14.842    41.720
>
    15.268    41.282
    14.886    41.734
>
    15.268    41.282
    14.886    41.734
>
    14.153    41.703
    14.886    41.734
>
    14.153    41.703
    14.886    41.734
>
    15.586    41.674
    14.886    41.734
>
    15.586    41.674
    14.886    41.734
>
    14.153    41.703
    14.838    41.693
>
    14.153    41.703
    14.838    41.693
>
    15.268    41.282
    14.838    41.693
>
    15.268    41.282
    14.838    41.693
>
    15.586    41.674
    14.838    41.693
>
    15.586    41.674
    14.838    41.693
>
    14.153    41.703
    14.833    41.724
>
    15.586    41.674
    14.833    41.724
>
    15.586    41.674
    14.833    41.724
>
    15.268    41.282
    14.833    41.724
>
    15.268    41.282
    14.833    41.724
>
    14.153    41.703
    14.807    41.697
>
    14.153    41.703
    14.807    41.697
>
    15.268    41.282
    14.807    41.697
>
    15.586    41.674
    14.807    41.697
>
    15.586    41.674
    14.807    41.697
>
    15.268    41.282
    14.859    41.686
>
    15.268    41.282
    14.859    41.686
>
    14.153    41.703
    14.859    41.686
>
    14.153    41.703
    14.859    41.686
>
    14.153    41.703
    14.866    41.718
>
    15.268    41.282
    14.866    41.718
>
    15.268    41.282
    14.866    41.718
>
    15.586    41.674
    14.866    41.718
>
    15.586    41.674
    14.866    41.718
>
    14.319    41.585
    14.819    41.699
>
    14.319    41.585
    14.819    41.699
>
    14.153    41.703
    14.819    41.699
>
    14.153    41.703
    14.819    41.699
>
    15.268    41.282
    14.819    41.699
>
    15.586    41.674
    14.819    41.699
>
    15.586    41.674
    14.819    41.699
>
    14.319    41.585
    14.841    41.686
>
    14.319    41.585
    14.841    41.686
>
    14.153    41.703
    14.841    41.686
>
    14.153    41.703
    14.841    41.686
>
    15.268    41.282
    14.841    41.686
>
    15.586    41.674
    14.841    41.686
>
    15.586    41.674
    14.841    41.686
>
    14.319    41.585
    14.818    41.709
>
    14.319    41.585
    14.818    41.709
>
    14.153    41.703
    14.818    41.709
>
    14.153    41.703
    14.818    41.709
>
    15.268    41.282
    14.818    41.709
>
    14.153    41.703
    14.895    41.691
>
    14.153    41.703
    14.895    41.691
>
    15.586    41.674
    14.895    41.691
>
    15.586    41.674
    14.895    41.691
>
    15.268    41.282
    14.895    41.691
>
    15.268    41.282
    14.895    41.691
>
    15.586    41.674
    14.909    41.694
>
    15.268    41.282
    14.909    41.694
>
    15.268    41.282
    14.909    41.694
>
    14.153    41.703
    14.909    41.694
>
    14.153    41.703
    14.909    41.694
>
    15.268    41.282
    14.822    41.707
>
    15.268    41.282
    14.822    41.707
>
    15.586    41.674
    14.822    41.707
>
    15.586    41.674
    14.822    41.707
>
    14.153    41.703
    14.840    41.701
>
    15.268    41.282
    14.840    41.701
>
    15.586    41.674
    14.840    41.701
>
    15.586    41.674
    14.840    41.701
>
    14.319    41.585
    14.862    41.707
>
    14.319    41.585
    14.862    41.707
>
    14.153    41.703
    14.862    41.707
>
    14.153    41.703
    14.862    41.707
>
    15.268    41.282
    14.862    41.707
>
    15.586    41.674
    14.862    41.707
>
    15.586    41.674
    14.862    41.707
>
    14.319    41.585
    14.974    41.719
>
    14.319    41.585
    14.974    41.719
>
    15.586    41.674
    14.974    41.719
>
    15.586    41.674
    14.974    41.719
>
    15.268    41.282
    14.974    41.719
>
    15.161    41.805
    14.838    41.679
>
    15.161    41.805
    14.838    41.679
>
    14.319    41.585
    14.838    41.679
>
    14.319    41.585
    14.838    41.679
>
    14.811    41.223
    14.838    41.679
>
    14.811    41.223
    14.838    41.679
>
    14.153    41.703
    14.838    41.679
>
    14.153    41.703
    14.838    41.679
>
    15.268    41.282
    14.838    41.679
>
    14.630    41.182
    14.838    41.679
>
    15.586    41.674
    14.838    41.679
>
    15.586    41.674
    14.838    41.679
>
    14.973    41.126
    14.838    41.679
>
    14.973    41.126
    14.838    41.679
>
    14.319    41.585
    14.864    41.702
>
    14.319    41.585
    14.864    41.702
>
    14.811    41.223
    14.864    41.702
>
    14.811    41.223
    14.864    41.702
>
    14.153    41.703
    14.864    41.702
>
    14.153    41.703
    14.864    41.702
>
    15.268    41.282
    14.864    41.702
>
    15.268    41.282
    14.864    41.702
>
    14.630    41.182
    14.864    41.702
>
    14.630    41.182
    14.864    41.702
>
    15.586    41.674
    14.864    41.702
>
    15.586    41.674
    14.864    41.702
>
    14.973    41.126
    14.864    41.702
>
    14.973    41.126
    14.864    41.702
>
    15.161    41.805
    14.865    41.683
>
    15.161    41.805
    14.865    41.683
>
    14.811    41.223
    14.865    41.683
>
    14.811    41.223
    14.865    41.683
>
    15.268    41.282
    14.865    41.683
>
    15.268    41.282
    14.865    41.683
>
    14.630    41.182
    14.865    41.683
>
    14.630    41.182
    14.865    41.683
>
    15.586    41.674
    14.865    41.683
>
    14.153    41.703
    14.865    41.683
>
    14.153    41.703
    14.865    41.683
>
    14.973    41.126
    14.865    41.683
>
    14.973    41.126
    14.865    41.683
>
    15.161    41.805
    14.956    41.682
>
    15.161    41.805
    14.956    41.682
>
    15.268    41.282
    14.956    41.682
>
    14.811    41.223
    14.956    41.682
>
    14.811    41.223
    14.956    41.682
>
    15.586    41.674
    14.956    41.682
>
    15.586    41.674
    14.956    41.682
>
    14.973    41.126
    14.956    41.682
>
    14.630    41.182
    14.956    41.682
>
    14.630    41.182
    14.956    41.682
>
    15.161    41.805
    14.816    41.681
>
    14.319    41.585
    14.816    41.681
>
    14.153    41.703
    14.816    41.681
>
    14.811    41.223
    14.816    41.681
>
    14.630    41.182
    14.816    41.681
>
    15.268    41.282
    14.816    41.681
>
    15.586    41.674
    14.816    41.681
>
    14.973    41.126
    14.816    41.681
>
    15.161    41.805
    14.796    41.688
>
    14.319    41.585
    14.796    41.688
>
    14.319    41.585
    14.796    41.688
>
    14.811    41.223
    14.796    41.688
>
    14.811    41.223
    14.796    41.688
>
    14.153    41.703
    14.796    41.688
>
    14.153    41.703
    14.796    41.688
>
    14.630    41.182
    14.796    41.688
>
    14.630    41.182
    14.796    41.688
>
    15.268    41.282
    14.796    41.688
>
    14.973    41.126
    14.796    41.688
>
    15.586    41.674
    14.796    41.688
>
    15.586    41.674
    14.796    41.688
>
    15.161    41.805
    14.802    41.689
>
    14.153    41.703
    14.802    41.689
>
    14.153    41.703
    14.802    41.689
>
    15.268    41.282
    14.802    41.689
>
    15.268    41.282
    14.802    41.689
>
    14.630    41.182
    14.802    41.689
>
    14.630    41.182
    14.802    41.689
>
    15.586    41.674
    14.802    41.689
>
    15.586    41.674
    14.802    41.689
>
    14.973    41.126
    14.802    41.689
>
    14.319    41.585
    14.870    41.707
>
    14.319    41.585
    14.870    41.707
>
    14.811    41.223
    14.870    41.707
>
    14.811    41.223
    14.870    41.707
>
    14.153    41.703
    14.870    41.707
>
    14.153    41.703
    14.870    41.707
>
    15.268    41.282
    14.870    41.707
>
    14.630    41.182
    14.870    41.707
>
    14.630    41.182
    14.870    41.707
>
    15.586    41.674
    14.870    41.707
>
    15.586    41.674
    14.870    41.707
>
    14.973    41.126
    14.870    41.707
>
    15.161    41.805
    14.763    41.694
>
    15.161    41.805
    14.763    41.694
>
    14.811    41.223
    14.763    41.694
>
    14.811    41.223
    14.763    41.694
>
    14.153    41.703
    14.763    41.694
>
    14.630    41.182
    14.763    41.694
>
    14.630    41.182
    14.763    41.694
>
    15.268    41.282
    14.763    41.694
>
    15.161    41.805
    14.774    41.678
>
    15.161    41.805
    14.774    41.678
>
    14.153    41.703
    14.774    41.678
>
    14.153    41.703
    14.774    41.678
>
    14.811    41.223
    14.774    41.678
>
    14.811    41.223
    14.774    41.678
>
    14.630    41.182
    14.774    41.678
>
    14.630    41.182
    14.774    41.678
>
    15.268    41.282
    14.774    41.678
>
    14.973    41.126
    14.774    41.678
>
    15.161    41.805
    14.847    41.690
>
    15.161    41.805
    14.847    41.690
>
    14.153    41.703
    14.847    41.690
>
    14.811    41.223
    14.847    41.690
>
    14.811    41.223
    14.847    41.690
>
    14.630    41.182
    14.847    41.690
>
    14.630    41.182
    14.847    41.690
>
    15.268    41.282
    14.847    41.690
>
    15.586    41.674
    14.847    41.690
>
    14.973    41.126
    14.847    41.690
>
    15.161    41.805
    14.806    41.702
>
    15.161    41.805
    14.806    41.702
>
    14.153    41.703
    14.806    41.702
>
    15.268    41.282
    14.806    41.702
>
    15.586    41.674
    14.806    41.702
>
    15.586    41.674
    14.806    41.702
>
    14.973    41.126
    14.806    41.702
>
    15.161    41.805
    14.808    41.694
>
    15.161    41.805
    14.808    41.694
>
    14.153    41.703
    14.808    41.694
>
    14.153    41.703
    14.808    41.694
>
    15.268    41.282
    14.808    41.694
>
    15.268    41.282
    14.808    41.694
>
    14.973    41.126
    14.808    41.694
>
    15.586    41.674
    14.808    41.694
>
    15.586    41.674
    14.808    41.694
>
    15.161    41.805
    14.790    41.692
>
    14.153    41.703
    14.790    41.692
>
    14.153    41.703
    14.790    41.692
>
    15.268    41.282
    14.790    41.692
>
    15.268    41.282
    14.790    41.692
>
    14.973    41.126
    14.790    41.692
>
    15.586    41.674
    14.790    41.692
>
    15.586    41.674
    14.790    41.692
>
    15.161    41.805
    14.781    41.718
>
    15.161    41.805
    14.781    41.718
>
    14.319    41.585
    14.781    41.718
>
    14.319    41.585
    14.781    41.718
>
    14.153    41.703
    14.781    41.718
>
    15.268    41.282
    14.781    41.718
>
    14.905    41.654
    14.864    41.699
>
    14.905    41.654
    14.864    41.699
>
    15.161    41.805
    14.864    41.699
>
    15.161    41.805
    14.864    41.699
>
    14.319    41.585
    14.864    41.699
>
    14.319    41.585
    14.864    41.699
>
    15.268    41.282
    14.864    41.699
>
    15.268    41.282
    14.864    41.699
>
    14.153    41.703
    14.864    41.699
>
    14.153    41.703
    14.864    41.699
>
    15.586    41.674
    14.864    41.699
>
    15.586    41.674
    14.864    41.699
>
    15.161    41.805
    14.835    41.692
>
    14.319    41.585
    14.835    41.692
>
    14.153    41.703
    14.835    41.692
>
    14.811    41.223
    14.835    41.692
>
    15.268    41.282
    14.835    41.692
>
    15.586    41.674
    14.835    41.692
>
    14.905    41.654
    14.825    41.690
>
    14.905    41.654
    14.825    41.690
>
    15.161    41.805
    14.825    41.690
>
    14.811    41.223
    14.825    41.690
>
    15.268    41.282
    14.825    41.690
>
    15.586    41.674
    14.825    41.690
>
    15.161    41.805
    15.650    41.810
>
    15.161    41.805
    14.884    41.697
>
    15.161    41.805
    14.884    41.697
>
    14.305    41.723
    14.884    41.697
>
    14.153    41.703
    14.884    41.697
>
    14.833    41.233
    14.884    41.697
>
    15.586    41.674
    14.884    41.697
>
    15.268    41.282
    14.884    41.697
>
    15.268    41.282
    14.884    41.697
>
    15.161    41.805
    15.329    42.024
>
    15.161    41.805
    15.329    42.024
>
    15.586    41.674
    15.329    42.024
>
    15.586    41.674
    15.329    42.024
>
    15.953    41.708
    15.329    42.024
>
    15.953    41.708
    15.329    42.024
>
    14.905    41.654
    14.896    41.684
>
    14.905    41.654
    14.896    41.684
>
    15.161    41.805
    14.896    41.684
>
    14.319    41.585
    14.896    41.684
>
    14.319    41.585
    14.896    41.684
>
    14.305    41.723
    14.896    41.684
>
    14.305    41.723
    14.896    41.684
>
    14.833    41.233
    14.896    41.684
>
    14.379    41.387
    14.896    41.684
>
    14.379    41.387
    14.896    41.684
>
    14.811    41.223
    14.896    41.684
>
    14.811    41.223
    14.896    41.684
>
    15.268    41.282
    14.896    41.684
>
    15.586    41.674
    14.896    41.684
>
    15.586    41.674
    14.896    41.684
>
    14.973    41.126
    14.896    41.684
>
    14.973    41.126
    14.896    41.684
>
    15.942    41.705
    15.932    41.860
>
    15.942    41.705
    15.932    41.860
>
    15.953    41.708
    15.932    41.860
>
    15.586    41.674
    15.932    41.860
>
    15.161    41.805
    15.932    41.860
>
    14.905    41.654
    14.863    41.721
>
    14.905    41.654
    14.863    41.721
>
    14.706    41.397
    14.863    41.721
>
    14.305    41.723
    14.863    41.721
>
    14.305    41.723
    14.863    41.721
>
    14.254    41.642
    14.863    41.721
>
    15.268    41.282
    14.863    41.721
>
    14.153    41.703
    14.863    41.721
>
    15.586    41.674
    14.863    41.721
>
    15.586    41.674
    14.863    41.721
>
    14.973    41.126
    14.863    41.721
>
    14.811    41.223
    14.491    40.988
>
    14.973    41.126
    14.491    40.988
>
    14.706    41.397
    14.491    40.988
>
    14.706    41.397
    14.491    40.988
>
    15.024    40.861
    14.491    40.988
>
    13.985    41.301
    14.491    40.988
>
    14.594    41.546
    14.491    40.988
>
    14.594    41.546
    14.491    40.988
>
    15.209    40.925
    14.491    40.988
>
    15.586    41.674
    15.715    41.486
>
    15.942    41.705
    15.715    41.486
>
    15.517    41.132
    15.715    41.486
>
    15.268    41.282
    15.715    41.486
>
    15.268    41.282
    15.715    41.486
>
    15.365    41.135
    15.715    41.486
>
    15.158    41.370
    15.715    41.486
>
    15.158    41.370
    15.715    41.486
>
    15.616    40.955
    15.715    41.486
>
    15.616    40.955
    15.715    41.486
>
    15.161    41.805
    15.715    41.486
>
    15.237    41.028
    15.715    41.486
>
    15.237    41.028
    15.715    41.486
>
    16.274    41.082
    15.715    41.486
>
    16.274    41.082
    15.715    41.486
>
    15.744    41.755
    15.503    41.911
>
    15.744    41.755
    15.503    41.911
>
    15.586    41.674
    15.503    41.911
>
    15.161    41.805
    15.503    41.911
>
    15.910    41.712
    15.503    41.911
>
    15.910    41.712
    15.503    41.911
>
    15.942    41.705
    15.503    41.911
>
    15.953    41.708
    15.503    41.911
>
    14.905    41.654
    15.503    41.911
>
    14.905    41.654
    15.503    41.911
>
    15.158    41.370
    15.503    41.911
>
    15.158    41.370
    15.503    41.911
>
    14.234    41.415
    14.177    41.296
>
    14.379    41.387
    14.177    41.296
>
    14.018    41.598
    14.177    41.296
>
    14.018    41.598
    14.177    41.296
>
    14.254    41.642
    14.177    41.296
>
    14.254    41.642
    14.177    41.296
>
    14.706    41.397
    14.177    41.296
>
    14.594    41.546
    14.177    41.296
>
    14.153    41.703
    14.177    41.296
>
    14.153    41.703
    14.177    41.296
>
    14.811    41.223
    14.177    41.296
>
    13.810    41.709
    14.177    41.296
>
    14.550    41.767
    14.177    41.296
>
    14.905    41.654
    14.818    41.691
>
    14.905    41.654
    14.818    41.691
>
    14.594    41.546
    14.818    41.691
>
    14.594    41.546
    14.818    41.691
>
    14.669    41.974
    14.818    41.691
>
    14.669    41.974
    14.818    41.691
>
    15.161    41.805
    14.818    41.691
>
    14.706    41.397
    14.818    41.691
>
    14.706    41.397
    14.818    41.691
>
    14.529    41.364
    14.818    41.691
>
    14.529    41.364
    14.818    41.691
>
    14.254    41.642
    14.818    41.691
>
    14.254    41.642
    14.818    41.691
>
    15.158    41.370
    14.818    41.691
>
    15.158    41.370
    14.818    41.691
>
    14.379    41.387
    14.818    41.691
>
    14.379    41.387
    14.818    41.691
>
    14.153    41.703
    14.818    41.691
>
    14.153    41.703
    14.818    41.691
>
    14.811    41.223
    14.818    41.691
>
    14.811    41.223
    14.818    41.691
>
    14.234    41.415
    14.818    41.691
>
    15.268    41.282
    14.818    41.691
>
    15.586    41.674
    14.818    41.691
>
    15.744    41.755
    15.795    41.892
>
    15.744    41.755
    15.795    41.892
>
    15.910    41.712
    15.795    41.892
>
    15.910    41.712
    15.795    41.892
>
    15.586    41.674
    15.795    41.892
>
    15.161    41.805
    15.795    41.892
>
    15.744    41.755
    15.618    41.511
>
    15.744    41.755
    15.618    41.511
>
    15.910    41.712
    15.618    41.511
>
    15.910    41.712
    15.618    41.511
>
    15.158    41.370
    15.618    41.511
>
    15.158    41.370
    15.618    41.511
>
    15.942    41.705
    15.618    41.511
>
    15.365    41.135
    15.618    41.511
>
    15.365    41.135
    15.618    41.511
>
    14.910    41.513
    15.618    41.511
>
    14.910    41.513
    15.618    41.511
>
    14.905    41.654
    15.618    41.511
>
    14.905    41.654
    15.618    41.511
>
    15.237    41.028
    15.618    41.511
>
    15.237    41.028
    15.618    41.511
>
    15.616    40.955
    15.618    41.511
>
    15.616    40.955
    15.618    41.511
>
    15.744    41.755
    15.621    41.505
>
    15.744    41.755
    15.621    41.505
>
    15.910    41.712
    15.621    41.505
>
    15.910    41.712
    15.621    41.505
>
    15.942    41.705
    15.621    41.505
>
    15.158    41.370
    15.621    41.505
>
    15.158    41.370
    15.621    41.505
>
    15.365    41.135
    15.621    41.505
>
    15.365    41.135
    15.621    41.505
>
    14.910    41.513
    15.621    41.505
>
    14.910    41.513
    15.621    41.505
>
    14.905    41.654
    15.621    41.505
>
    14.905    41.654
    15.621    41.505
>
    15.237    41.028
    15.621    41.505
>
    15.237    41.028
    15.621    41.505
>
    15.616    40.955
    15.621    41.505
>
    15.616    40.955
    15.621    41.505
>
    14.905    41.654
    14.852    41.675
>
    14.905    41.654
    14.852    41.675
>
    14.910    41.513
    14.852    41.675
>
    14.910    41.513
    14.852    41.675
>
    14.594    41.546
    14.852    41.675
>
    14.594    41.546
    14.852    41.675
>
    14.550    41.767
    14.852    41.675
>
    14.550    41.767
    14.852    41.675
>
    14.706    41.397
    14.852    41.675
>
    14.706    41.397
    14.852    41.675
>
    14.669    41.974
    14.852    41.675
>
    14.669    41.974
    14.852    41.675
>
    14.529    41.364
    14.852    41.675
>
    14.529    41.364
    14.852    41.675
>
    15.158    41.370
    14.852    41.675
>
    15.158    41.370
    14.852    41.675
>
    14.254    41.642
    14.852    41.675
>
    14.254    41.642
    14.852    41.675
>
    14.379    41.387
    14.852    41.675
>
    14.811    41.223
    14.852    41.675
>
    14.153    41.703
    14.852    41.675
>
    14.234    41.415
    14.852    41.675
>
    15.127    41.706
    15.380    41.878
>
    15.127    41.706
    15.380    41.878
>
    15.744    41.755
    15.380    41.878
>
    15.744    41.755
    15.380    41.878
>
    14.905    41.654
    15.380    41.878
>
    14.905    41.654
    15.380    41.878
>
    14.669    41.974
    15.380    41.878
>
    14.669    41.974
    15.380    41.878
>
    15.910    41.712
    15.380    41.878
>
    15.910    41.712
    15.380    41.878
>
    15.942    41.705
    15.380    41.878
>
    15.942    41.705
    15.380    41.878
>
    15.744    41.755
    15.532    41.905
>
    15.744    41.755
    15.532    41.905
>
    15.910    41.712
    15.532    41.905
>
    15.910    41.712
    15.532    41.905
>
    15.942    41.705
    15.532    41.905
>
    15.942    41.705
    15.532    41.905
>
    15.127    41.706
    15.532    41.905
>
    15.127    41.706
    15.532    41.905
>
    14.905    41.654
    15.532    41.905
>
    14.905    41.654
    15.532    41.905
>
    14.973    41.126
    14.964    41.179
>
    14.973    41.126
    14.964    41.179
>
    14.706    41.397
    14.964    41.179
>
    15.237    41.028
    14.964    41.179
>
    14.529    41.364
    14.964    41.179
>
    14.910    41.513
    14.964    41.179
>
    14.910    41.513
    14.964    41.179
>
    15.209    40.925
    14.964    41.179
>
    15.209    40.925
    14.964    41.179
>
    15.365    41.135
    14.964    41.179
>
    15.168    40.783
    14.964    41.179
>
    15.168    40.783
    14.964    41.179
>
    14.905    41.654
    14.964    41.179
>
    14.905    41.654
    14.964    41.179
>
    14.398    40.827
    14.964    41.179
>
    14.234    41.415
    14.964    41.179
>
    15.127    41.706
    14.964    41.179
>
    15.127    41.706
    14.964    41.179
>
    15.616    40.955
    14.964    41.179
>
    15.489    40.756
    14.964    41.179
>
    14.973    41.126
    14.948    41.171
>
    14.973    41.126
    14.948    41.171
>
    14.811    41.223
    14.948    41.171
>
    14.706    41.397
    14.948    41.171
>
    14.706    41.397
    14.948    41.171
>
    15.237    41.028
    14.948    41.171
>
    15.237    41.028
    14.948    41.171
>
    15.158    41.370
    14.948    41.171
>
    14.529    41.364
    14.948    41.171
>
    14.529    41.364
    14.948    41.171
>
    15.209    40.925
    14.948    41.171
>
    15.209    40.925
    14.948    41.171
>
    14.910    41.513
    14.948    41.171
>
    14.910    41.513
    14.948    41.171
>
    15.365    41.135
    14.948    41.171
>
    15.365    41.135
    14.948    41.171
>
    15.168    40.783
    14.948    41.171
>
    15.168    40.783
    14.948    41.171
>
    14.398    40.827
    14.948    41.171
>
    14.905    41.654
    14.948    41.171
>
    14.905    41.654
    14.948    41.171
>
    14.234    41.415
    14.948    41.171
>
    15.127    41.706
    14.948    41.171
>
    15.127    41.706
    14.948    41.171
>
    15.616    40.955
    14.948    41.171
>
    15.489    40.756
    14.948    41.171
>
    14.973    41.126
    14.944    41.159
>
    14.973    41.126
    14.944    41.159
>
    14.811    41.223
    14.944    41.159
>
    14.811    41.223
    14.944    41.159
>
    14.568    41.031
    14.944    41.159
>
    14.706    41.397
    14.944    41.159
>
    14.706    41.397
    14.944    41.159
>
    15.237    41.028
    14.944    41.159
>
    15.237    41.028
    14.944    41.159
>
    15.158    41.370
    14.944    41.159
>
    15.209    40.925
    14.944    41.159
>
    15.209    40.925
    14.944    41.159
>
    14.529    41.364
    14.944    41.159
>
    14.529    41.364
    14.944    41.159
>
    14.910    41.513
    14.944    41.159
>
    15.365    41.135
    14.944    41.159
>
    15.365    41.135
    14.944    41.159
>
    15.168    40.783
    14.944    41.159
>
    15.168    40.783
    14.944    41.159
>
    14.398    40.827
    14.944    41.159
>
    14.905    41.654
    14.944    41.159
>
    14.905    41.654
    14.944    41.159
>
    14.234    41.415
    14.944    41.159
>
    15.616    40.955
    14.944    41.159
>
    15.127    41.706
    14.944    41.159
>
    15.127    41.706
    14.944    41.159
>
    15.489    40.756
    14.944    41.159
>
    14.905    41.654
    14.825    41.674
>
    14.905    41.654
    14.825    41.674
>
    14.910    41.513
    14.825    41.674
>
    14.910    41.513
    14.825    41.674
>
    14.594    41.546
    14.825    41.674
>
    14.594    41.546
    14.825    41.674
>
    14.550    41.767
    14.825    41.674
>
    15.127    41.706
    14.825    41.674
>
    15.127    41.706
    14.825    41.674
>
    14.706    41.397
    14.825    41.674
>
    14.706    41.397
    14.825    41.674
>
    14.669    41.974
    14.825    41.674
>
    14.669    41.974
    14.825    41.674
>
    14.254    41.642
    14.825    41.674
>
    14.254    41.642
    14.825    41.674
>
    15.158    41.370
    14.825    41.674
>
    15.158    41.370
    14.825    41.674
>
    14.811    41.223
    14.825    41.674
>
    14.811    41.223
    14.825    41.674
>
    14.153    41.703
    14.825    41.674
>
    14.153    41.703
    14.825    41.674
>
    14.234    41.415
    14.825    41.674
>
    14.234    41.415
    14.825    41.674
>
    15.133    41.200
    14.825    41.674
>
    14.973    41.126
    14.825    41.674
>
    14.594    41.546
    14.465    41.394
>
    14.594    41.546
    14.465    41.394
>
    14.180    41.200
    14.465    41.394
>
    14.153    41.703
    14.465    41.394
>
    14.018    41.598
    14.465    41.394
>
    14.550    41.767
    14.465    41.394
>
    14.910    41.513
    14.465    41.394
>
    14.905    41.654
    14.465    41.394
>
    14.905    41.654
    14.465    41.394
>
    13.878    41.146
    14.465    41.394
>
    13.878    41.146
    14.465    41.394
>
    14.973    41.126
    14.465    41.394
>
    14.669    41.974
    14.465    41.394
>
    14.398    40.827
    14.465    41.394
>
    15.127    41.706
    14.465    41.394
>
    15.127    41.706
    14.465    41.394
>
    14.234    41.415
    14.465    41.387
>
    14.234    41.415
    14.465    41.387
>
    14.594    41.546
    14.465    41.387
>
    14.594    41.546
    14.465    41.387
>
    14.706    41.397
    14.465    41.387
>
    14.706    41.397
    14.465    41.387
>
    14.180    41.200
    14.465    41.387
>
    14.254    41.642
    14.465    41.387
>
    14.254    41.642
    14.465    41.387
>
    14.811    41.223
    14.465    41.387
>
    14.811    41.223
    14.465    41.387
>
    14.018    41.598
    14.465    41.387
>
    14.153    41.703
    14.465    41.387
>
    14.568    41.031
    14.465    41.387
>
    14.910    41.513
    14.465    41.387
>
    14.550    41.767
    14.465    41.387
>
    14.550    41.767
    14.465    41.387
>
    14.905    41.654
    14.465    41.387
>
    13.878    41.146
    14.465    41.387
>
    14.973    41.126
    14.465    41.387
>
    15.158    41.370
    14.465    41.387
>
    15.158    41.370
    14.465    41.387
>
    15.133    41.200
    14.465    41.387
>
    14.398    40.827
    14.465    41.387
>
    15.127    41.706
    14.465    41.387
>
    14.234    41.415
    14.433    41.392
>
    14.234    41.415
    14.433    41.392
>
    14.594    41.546
    14.433    41.392
>
    14.594    41.546
    14.433    41.392
>
    14.706    41.397
    14.433    41.392
>
    14.706    41.397
    14.433    41.392
>
    14.254    41.642
    14.433    41.392
>
    14.254    41.642
    14.433    41.392
>
    14.180    41.200
    14.433    41.392
>
    14.153    41.703
    14.433    41.392
>
    14.153    41.703
    14.433    41.392
>
    14.018    41.598
    14.433    41.392
>
    14.811    41.223
    14.433    41.392
>
    14.550    41.767
    14.433    41.392
>
    14.550    41.767
    14.433    41.392
>
    14.910    41.513
    14.433    41.392
>
    14.568    41.031
    14.433    41.392
>
    14.905    41.654
    14.433    41.392
>
    13.878    41.146
    14.433    41.392
>
    14.973    41.126
    14.433    41.392
>
    15.158    41.370
    14.433    41.392
>
    14.234    41.415
    14.423    41.392
>
    14.234    41.415
    14.423    41.392
>
    14.594    41.546
    14.423    41.392
>
    14.594    41.546
    14.423    41.392
>
    14.706    41.397
    14.423    41.392
>
    14.706    41.397
    14.423    41.392
>
    14.180    41.200
    14.423    41.392
>
    14.180    41.200
    14.423    41.392
>
    14.254    41.642
    14.423    41.392
>
    14.811    41.223
    14.423    41.392
>
    14.811    41.223
    14.423    41.392
>
    14.018    41.598
    14.423    41.392
>
    14.153    41.703
    14.423    41.392
>
    14.153    41.703
    14.423    41.392
>
    14.550    41.767
    14.423    41.392
>
    14.550    41.767
    14.423    41.392
>
    14.568    41.031
    14.423    41.392
>
    14.568    41.031
    14.423    41.392
>
    14.910    41.513
    14.423    41.392
>
    14.905    41.654
    14.423    41.392
>
    13.878    41.146
    14.423    41.392
>
    14.973    41.126
    14.423    41.392
>
    15.158    41.370
    14.423    41.392
>
    14.417    41.360
    14.479    41.361
>
    14.417    41.360
    14.479    41.361
>
    14.497    41.262
    14.479    41.361
>
    14.497    41.262
    14.479    41.361
>
    14.234    41.415
    14.479    41.361
>
    14.234    41.415
    14.479    41.361
>
    14.234    41.415
    14.479    41.361
>
    14.706    41.397
    14.479    41.361
>
    14.706    41.397
    14.479    41.361
>
    14.706    41.397
    14.479    41.361
>
    14.594    41.546
    14.479    41.361
>
    14.594    41.546
    14.479    41.361
>
    14.594    41.546
    14.479    41.361
>
    14.254    41.642
    14.479    41.361
>
    14.811    41.223
    14.479    41.361
>
    14.811    41.223
    14.479    41.361
>
    14.568    41.031
    14.479    41.361
>
    14.568    41.031
    14.479    41.361
>
    14.568    41.031
    14.479    41.361
>
    14.018    41.598
    14.479    41.361
>
    14.910    41.513
    14.479    41.361
>
    14.153    41.703
    14.479    41.361
>
    14.550    41.767
    14.479    41.361
>
    14.905    41.654
    14.479    41.361
>
    14.545    40.920
    14.479    41.361
>
    13.878    41.146
    14.479    41.361
>
    14.973    41.126
    14.479    41.361
>
    14.973    41.126
    14.479    41.361
>
    14.398    40.827
    14.479    41.361
>
    15.158    41.370
    14.479    41.361
>
    15.133    41.200
    14.479    41.361
>
    15.127    41.706
    14.479    41.361
>
    14.417    41.360
    14.474    41.370
>
    14.417    41.360
    14.474    41.370
>
    14.234    41.415
    14.474    41.370
>
    14.234    41.415
    14.474    41.370
>
    14.706    41.397
    14.474    41.370
>
    14.706    41.397
    14.474    41.370
>
    14.594    41.546
    14.474    41.370
>
    14.594    41.546
    14.474    41.370
>
    14.254    41.642
    14.474    41.370
>
    14.254    41.642
    14.474    41.370
>
    14.811    41.223
    14.474    41.370
>
    14.811    41.223
    14.474    41.370
>
    14.568    41.031
    14.474    41.370
>
    14.910    41.513
    14.474    41.370
>
    14.018    41.598
    14.474    41.370
>
    14.153    41.703
    14.474    41.370
>
    14.550    41.767
    14.474    41.370
>
    14.905    41.654
    14.474    41.370
>
    14.545    40.920
    14.474    41.370
>
    14.973    41.126
    14.474    41.370
>
    13.878    41.146
    14.474    41.370
>
    15.158    41.370
    14.474    41.370
>
    14.398    40.827
    14.474    41.370
>
    15.127    41.706
    14.474    41.370
>
    15.133    41.200
    15.267    41.257
>
    15.158    41.370
    15.267    41.257
>
    15.158    41.370
    15.267    41.257
>
    15.365    41.135
    15.267    41.257
>
    15.365    41.135
    15.267    41.257
>
    15.237    41.028
    15.267    41.257
>
    15.237    41.028
    15.267    41.257
>
    14.973    41.126
    15.267    41.257
>
    14.973    41.126
    15.267    41.257
>
    15.209    40.925
    15.267    41.257
>
    15.209    40.925
    15.267    41.257
>
    14.811    41.223
    15.267    41.257
>
    14.811    41.223
    15.267    41.257
>
    14.910    41.513
    15.267    41.257
>
    14.910    41.513
    15.267    41.257
>
    15.616    40.955
    15.267    41.257
>
    15.616    40.955
    15.267    41.257
>
    14.706    41.397
    15.267    41.257
>
    14.706    41.397
    15.267    41.257
>
    15.127    41.706
    15.267    41.257
>
    15.127    41.706
    15.267    41.257
>
    15.168    40.783
    15.267    41.257
>
    15.168    40.783
    15.267    41.257
>
    14.905    41.654
    15.267    41.257
>
    14.905    41.654
    15.267    41.257
>
    15.489    40.756
    15.267    41.257
>
    15.489    40.756
    15.267    41.257
>
    14.594    41.546
    15.267    41.257
>
    14.905    41.654
    14.971    41.704
>
    14.905    41.654
    14.971    41.704
>
    15.127    41.706
    14.971    41.704
>
    15.127    41.706
    14.971    41.704
>
    14.910    41.513
    14.971    41.704
>
    14.550    41.767
    14.971    41.704
>
    14.594    41.546
    14.971    41.704
>
    14.594    41.546
    14.971    41.704
>
    14.669    41.974
    14.971    41.704
>
    14.669    41.974
    14.971    41.704
>
    14.706    41.397
    14.971    41.704
>
    14.706    41.397
    14.971    41.704
>
    15.158    41.370
    14.971    41.704
>
    14.529    41.364
    14.971    41.704
>
    14.529    41.364
    14.971    41.704
>
    14.811    41.223
    14.971    41.704
>
    14.811    41.223
    14.971    41.704
>
    14.254    41.642
    14.971    41.704
>
    14.254    41.642
    14.971    41.704
>
    14.379    41.387
    14.971    41.704
>
    15.133    41.200
    14.971    41.704
>
    14.630    41.183
    14.971    41.704
>
    15.511    42.124
    14.971    41.704
>
    14.973    41.126
    14.971    41.704
>
    15.744    41.755
    14.971    41.704
>
    15.744    41.755
    14.971    41.704
>
    15.127    41.706
    15.356    41.767
>
    15.127    41.706
    15.356    41.767
>
    15.744    41.755
    15.356    41.767
>
    15.744    41.755
    15.356    41.767
>
    14.905    41.654
    15.356    41.767
>
    14.905    41.654
    15.356    41.767
>
    15.511    42.124
    15.356    41.767
>
    15.511    42.124
    15.356    41.767
>
    14.910    41.513
    15.356    41.767
>
    15.158    41.370
    15.356    41.767
>
    15.158    41.370
    15.356    41.767
>
    15.910    41.712
    15.356    41.767
>
    15.910    41.712
    15.356    41.767
>
    14.669    41.974
    15.356    41.767
>
    15.127    41.706
    15.358    41.784
>
    15.744    41.755
    15.358    41.784
>
    15.744    41.755
    15.358    41.784
>
    14.905    41.654
    15.358    41.784
>
    15.511    42.124
    15.358    41.784
>
    14.910    41.513
    15.358    41.784
>
    14.910    41.513
    15.358    41.784
>
    15.158    41.370
    15.358    41.784
>
    15.158    41.370
    15.358    41.784
>
    15.910    41.712
    15.358    41.784
>
    15.910    41.712
    15.358    41.784
>
    14.669    41.974
    15.358    41.784
>
    14.910    41.513
    14.991    41.508
>
    14.910    41.513
    14.991    41.508
>
    15.158    41.370
    14.991    41.508
>
    15.158    41.370
    14.991    41.508
>
    14.706    41.397
    14.991    41.508
>
    14.706    41.397
    14.991    41.508
>
    15.127    41.706
    14.991    41.508
>
    15.127    41.706
    14.991    41.508
>
    14.594    41.546
    14.991    41.508
>
    14.594    41.546
    14.991    41.508
>
    14.811    41.223
    14.991    41.508
>
    14.811    41.223
    14.991    41.508
>
    14.973    41.126
    14.991    41.508
>
    14.973    41.126
    14.991    41.508
>
    14.630    41.183
    14.991    41.508
>
    14.630    41.183
    14.991    41.508
>
    14.550    41.767
    14.991    41.508
>
    14.550    41.767
    14.991    41.508
>
    14.379    41.387
    14.991    41.508
>
    14.379    41.387
    14.991    41.508
>
    15.237    41.028
    14.991    41.508
>
    15.237    41.028
    14.991    41.508
>
    14.669    41.974
    14.991    41.508
>
    14.669    41.974
    14.991    41.508
>
    14.568    41.031
    14.991    41.508
>
    14.254    41.642
    14.991    41.508
>
    14.254    41.642
    14.991    41.508
>
    14.234    41.415
    14.991    41.508
>
    14.594    41.546
    14.644    41.538
>
    14.594    41.546
    14.644    41.538
>
    14.529    41.364
    14.644    41.538
>
    14.529    41.364
    14.644    41.538
>
    14.550    41.767
    14.644    41.538
>
    14.550    41.767
    14.644    41.538
>
    14.910    41.513
    14.644    41.538
>
    14.379    41.387
    14.644    41.538
>
    14.379    41.387
    14.644    41.538
>
    14.254    41.642
    14.644    41.538
>
    14.254    41.642
    14.644    41.538
>
    14.234    41.415
    14.644    41.538
>
    14.234    41.415
    14.644    41.538
>
    14.811    41.223
    14.644    41.538
>
    14.811    41.223
    14.644    41.538
>
    14.630    41.183
    14.644    41.538
>
    14.630    41.183
    14.644    41.538
>
    14.153    41.703
    14.644    41.538
>
    14.153    41.703
    14.644    41.538
>
    15.127    41.706
    14.644    41.538
>
    15.127    41.706
    14.644    41.538
>
    14.669    41.974
    14.644    41.538
>
    15.158    41.370
    14.644    41.538
>
    15.158    41.370
    14.644    41.538
>
    14.018    41.598
    14.644    41.538
>
    14.973    41.126
    14.644    41.538
>
    14.973    41.126
    14.644    41.538
>
    15.133    41.200
    14.644    41.538
>
    14.568    41.031
    14.644    41.538
>
    14.568    41.031
    14.644    41.538
>
    14.594    41.546
    14.614    41.522
>
    14.529    41.364
    14.614    41.522
>
    14.529    41.364
    14.614    41.522
>
    14.379    41.387
    14.614    41.522
>
    14.379    41.387
    14.614    41.522
>
    14.910    41.513
    14.614    41.522
>
    14.550    41.767
    14.614    41.522
>
    14.550    41.767
    14.614    41.522
>
    14.254    41.642
    14.614    41.522
>
    14.254    41.642
    14.614    41.522
>
    14.234    41.415
    14.614    41.522
>
    14.234    41.415
    14.614    41.522
>
    14.630    41.183
    14.614    41.522
>
    14.630    41.183
    14.614    41.522
>
    14.811    41.223
    14.614    41.522
>
    14.811    41.223
    14.614    41.522
>
    14.153    41.703
    14.614    41.522
>
    14.153    41.703
    14.614    41.522
>
    14.018    41.598
    14.614    41.522
>
    15.127    41.706
    14.614    41.522
>
    15.127    41.706
    14.614    41.522
>
    14.669    41.974
    14.614    41.522
>
    14.669    41.974
    14.614    41.522
>
    15.158    41.370
    14.614    41.522
>
    14.973    41.126
    14.614    41.522
>
    14.568    41.031
    14.614    41.522
>
    15.133    41.200
    14.614    41.522
>
    14.594    41.546
    14.633    41.539
>
    14.594    41.546
    14.633    41.539
>
    14.529    41.364
    14.633    41.539
>
    14.379    41.387
    14.633    41.539
>
    14.379    41.387
    14.633    41.539
>
    14.550    41.767
    14.633    41.539
>
    14.550    41.767
    14.633    41.539
>
    14.910    41.513
    14.633    41.539
>
    14.254    41.642
    14.633    41.539
>
    14.254    41.642
    14.633    41.539
>
    14.234    41.415
    14.633    41.539
>
    14.234    41.415
    14.633    41.539
>
    14.630    41.183
    14.633    41.539
>
    14.630    41.183
    14.633    41.539
>
    14.811    41.223
    14.633    41.539
>
    14.811    41.223
    14.633    41.539
>
    14.153    41.703
    14.633    41.539
>
    14.018    41.598
    14.633    41.539
>
    15.127    41.706
    14.633    41.539
>
    15.127    41.706
    14.633    41.539
>
    14.669    41.974
    14.633    41.539
>
    15.158    41.370
    14.633    41.539
>
    14.568    41.031
    14.633    41.539
>
    14.973    41.126
    14.633    41.539
>
    15.133    41.200
    14.633    41.539
>
    14.594    41.546
    14.650    41.533
>
    14.594    41.546
    14.650    41.533
>
    14.529    41.364
    14.650    41.533
>
    14.529    41.364
    14.650    41.533
>
    14.379    41.387
    14.650    41.533
>
    14.379    41.387
    14.650    41.533
>
    14.550    41.767
    14.650    41.533
>
    14.550    41.767
    14.650    41.533
>
    14.254    41.642
    14.650    41.533
>
    14.254    41.642
    14.650    41.533
>
    14.234    41.415
    14.650    41.533
>
    14.234    41.415
    14.650    41.533
>
    14.811    41.223
    14.650    41.533
>
    14.630    41.183
    14.650    41.533
>
    15.127    41.706
    14.650    41.533
>
    15.127    41.706
    14.650    41.533
>
    14.153    41.703
    14.650    41.533
>
    14.153    41.703
    14.650    41.533
>
    15.158    41.370
    14.650    41.533
>
    14.973    41.126
    14.650    41.533
>
    14.018    41.598
    14.650    41.533
>
    14.180    41.200
    14.650    41.533
>
    15.133    41.200
    14.650    41.533
>
    14.568    41.031
    14.650    41.533
>
    14.594    41.546
    14.636    41.543
>
    14.594    41.546
    14.636    41.543
>
    14.529    41.364
    14.636    41.543
>
    14.529    41.364
    14.636    41.543
>
    14.550    41.767
    14.636    41.543
>
    14.550    41.767
    14.636    41.543
>
    14.379    41.387
    14.636    41.543
>
    14.379    41.387
    14.636    41.543
>
    14.254    41.642
    14.636    41.543
>
    14.254    41.642
    14.636    41.543
>
    14.234    41.415
    14.636    41.543
>
    14.234    41.415
    14.636    41.543
>
    14.811    41.223
    14.636    41.543
>
    14.811    41.223
    14.636    41.543
>
    14.630    41.183
    14.636    41.543
>
    14.630    41.183
    14.636    41.543
>
    14.153    41.703
    14.636    41.543
>
    14.153    41.703
    14.636    41.543
>
    15.127    41.706
    14.636    41.543
>
    15.127    41.706
    14.636    41.543
>
    14.669    41.974
    14.636    41.543
>
    14.018    41.598
    14.636    41.543
>
    15.158    41.370
    14.636    41.543
>
    14.973    41.126
    14.636    41.543
>
    14.568    41.031
    14.636    41.543
>
    15.133    41.200
    14.636    41.543
>
    14.905    41.654
    14.857    41.677
>
    14.905    41.654
    14.857    41.677
>
    14.910    41.513
    14.857    41.677
>
    14.910    41.513
    14.857    41.677
>
    15.127    41.706
    14.857    41.677
>
    15.127    41.706
    14.857    41.677
>
    14.550    41.767
    14.857    41.677
>
    14.550    41.767
    14.857    41.677
>
    14.594    41.546
    14.857    41.677
>
    14.594    41.546
    14.857    41.677
>
    14.669    41.974
    14.857    41.677
>
    14.536    41.475
    14.857    41.677
>
    14.536    41.475
    14.857    41.677
>
    15.158    41.370
    14.857    41.677
>
    15.158    41.370
    14.857    41.677
>
    14.254    41.642
    14.857    41.677
>
    14.254    41.642
    14.857    41.677
>
    14.811    41.223
    14.857    41.677
>
    14.811    41.223
    14.857    41.677
>
    14.153    41.703
    14.857    41.677
>
    14.153    41.703
    14.857    41.677
>
    14.234    41.415
    14.857    41.677
>
    14.234    41.415
    14.857    41.677
>
    14.630    41.183
    14.857    41.677
>
    14.630    41.183
    14.857    41.677
>
    15.543    41.757
    14.857    41.677
>
    15.543    41.757
    14.857    41.677
>
    15.133    41.200
    14.857    41.677
>
    15.133    41.200
    14.857    41.677
>
    14.973    41.126
    14.857    41.677
>
    14.973    41.126
    14.857    41.677
>
    14.594    41.546
    14.637    41.539
>
    14.594    41.546
    14.637    41.539
>
    14.706    41.397
    14.637    41.539
>
    14.706    41.397
    14.637    41.539
>
    14.529    41.364
    14.637    41.539
>
    14.529    41.364
    14.637    41.539
>
    14.910    41.513
    14.637    41.539
>
    14.550    41.767
    14.637    41.539
>
    14.550    41.767
    14.637    41.539
>
    14.905    41.654
    14.637    41.539
>
    14.379    41.387
    14.637    41.539
>
    14.379    41.387
    14.637    41.539
>
    14.254    41.642
    14.637    41.539
>
    14.254    41.642
    14.637    41.539
>
    14.234    41.415
    14.637    41.539
>
    14.234    41.415
    14.637    41.539
>
    14.811    41.223
    14.637    41.539
>
    14.811    41.223
    14.637    41.539
>
    14.630    41.183
    14.637    41.539
>
    14.630    41.183
    14.637    41.539
>
    14.153    41.703
    14.637    41.539
>
    15.127    41.706
    14.637    41.539
>
    15.127    41.706
    14.637    41.539
>
    14.669    41.974
    14.637    41.539
>
    14.018    41.598
    14.637    41.539
>
    14.973    41.126
    14.637    41.539
>
    15.133    41.200
    14.637    41.539
>
    14.568    41.031
    14.637    41.539
>
    14.905    41.654
    14.893    41.789
>
    14.905    41.654
    14.893    41.789
>
    14.550    41.767
    14.893    41.789
>
    14.550    41.767
    14.893    41.789
>
    14.669    41.974
    14.893    41.789
>
    14.669    41.974
    14.893    41.789
>
    15.127    41.706
    14.893    41.789
>
    15.127    41.706
    14.893    41.789
>
    14.910    41.513
    14.893    41.789
>
    14.594    41.546
    14.893    41.789
>
    14.594    41.546
    14.893    41.789
>
    14.706    41.397
    14.893    41.789
>
    14.706    41.397
    14.893    41.789
>
    14.254    41.642
    14.893    41.789
>
    14.254    41.642
    14.893    41.789
>
    14.529    41.364
    14.893    41.789
>
    15.158    41.370
    14.893    41.789
>
    15.158    41.370
    14.893    41.789
>
    14.153    41.703
    14.893    41.789
>
    14.153    41.703
    14.893    41.789
>
    14.379    41.387
    14.893    41.789
>
    14.379    41.387
    14.893    41.789
>
    15.543    41.757
    14.893    41.789
>
    15.543    41.757
    14.893    41.789
>
    14.183    42.047
    14.893    41.789
>
    14.183    42.047
    14.893    41.789
>
    14.811    41.223
    14.893    41.789
>
    14.811    41.223
    14.893    41.789
>
    14.347    42.227
    14.893    41.789
>
    15.511    42.124
    14.893    41.789
>
    14.910    41.513
    14.993    41.494
>
    14.905    41.654
    14.993    41.494
>
    14.905    41.654
    14.993    41.494
>
    15.158    41.370
    14.993    41.494
>
    15.158    41.370
    14.993    41.494
>
    15.127    41.706
    14.993    41.494
>
    15.127    41.706
    14.993    41.494
>
    14.706    41.397
    14.993    41.494
>
    14.706    41.397
    14.993    41.494
>
    14.594    41.546
    14.993    41.494
>
    14.594    41.546
    14.993    41.494
>
    14.811    41.223
    14.993    41.494
>
    14.811    41.223
    14.993    41.494
>
    15.133    41.200
    14.993    41.494
>
    14.973    41.126
    14.993    41.494
>
    14.973    41.126
    14.993    41.494
>
    14.529    41.364
    14.993    41.494
>
    14.529    41.364
    14.993    41.494
>
    14.630    41.183
    14.993    41.494
>
    14.550    41.767
    14.993    41.494
>
    15.365    41.135
    14.993    41.494
>
    15.365    41.135
    14.993    41.494
>
    14.379    41.387
    14.993    41.494
>
    14.379    41.387
    14.993    41.494
>
    15.543    41.757
    14.993    41.494
>
    15.543    41.757
    14.993    41.494
>
    15.237    41.028
    14.993    41.494
>
    15.237    41.028
    14.993    41.494
>
    14.669    41.974
    14.993    41.494
>
    14.568    41.031
    14.993    41.494
>
    14.254    41.642
    14.993    41.494
>
    14.254    41.642
    14.993    41.494
>
    14.234    41.415
    14.993    41.494
>
    15.209    40.925
    14.993    41.494
>
    15.209    40.925
    14.993    41.494
>
    14.910    41.513
    14.990    41.503
>
    14.910    41.513
    14.990    41.503
>
    14.905    41.654
    14.990    41.503
>
    14.905    41.654
    14.990    41.503
>
    15.158    41.370
    14.990    41.503
>
    15.158    41.370
    14.990    41.503
>
    15.127    41.706
    14.990    41.503
>
    15.127    41.706
    14.990    41.503
>
    14.706    41.397
    14.990    41.503
>
    14.706    41.397
    14.990    41.503
>
    14.594    41.546
    14.990    41.503
>
    14.594    41.546
    14.990    41.503
>
    14.811    41.223
    14.990    41.503
>
    14.811    41.223
    14.990    41.503
>
    15.133    41.200
    14.990    41.503
>
    14.529    41.364
    14.990    41.503
>
    14.529    41.364
    14.990    41.503
>
    14.973    41.126
    14.990    41.503
>
    14.973    41.126
    14.990    41.503
>
    14.550    41.767
    14.990    41.503
>
    14.630    41.183
    14.990    41.503
>
    14.630    41.183
    14.990    41.503
>
    14.379    41.387
    14.990    41.503
>
    14.379    41.387
    14.990    41.503
>
    15.365    41.135
    14.990    41.503
>
    15.365    41.135
    14.990    41.503
>
    15.543    41.757
    14.990    41.503
>
    15.543    41.757
    14.990    41.503
>
    14.669    41.974
    14.990    41.503
>
    14.669    41.974
    14.990    41.503
>
    15.237    41.028
    14.990    41.503
>
    15.237    41.028
    14.990    41.503
>
    14.254    41.642
    14.990    41.503
>
    14.254    41.642
    14.990    41.503
>
    14.234    41.415
    14.990    41.503
>
    14.234    41.415
    14.990    41.503
>
    14.568    41.031
    14.990    41.503
>
    15.744    41.755
    15.767    41.860
>
    15.744    41.755
    15.767    41.860
>
    15.744    41.755
    15.767    41.860
>
    15.543    41.757
    15.767    41.860
>
    15.543    41.757
    15.767    41.860
>
    15.910    41.712
    15.767    41.860
>
    15.910    41.712
    15.767    41.860
>
    15.511    42.124
    15.767    41.860
>
    15.511    42.124
    15.767    41.860
>
    15.127    41.706
    15.767    41.860
>
    15.127    41.706
    15.767    41.860
>
    15.744    41.755
    15.882    41.790
>
    15.543    41.757
    15.882    41.790
>
    15.127    41.706
    15.882    41.790
>
    15.127    41.706
    15.882    41.790
>
    14.811    41.223
    14.909    41.258
>
    14.973    41.126
    14.909    41.258
>
    14.973    41.126
    14.909    41.258
>
    14.706    41.397
    14.909    41.258
>
    14.706    41.397
    14.909    41.258
>
    15.133    41.200
    14.909    41.258
>
    14.630    41.183
    14.909    41.258
>
    15.158    41.370
    14.909    41.258
>
    15.158    41.370
    14.909    41.258
>
    14.910    41.513
    14.909    41.258
>
    14.529    41.364
    14.909    41.258
>
    14.529    41.364
    14.909    41.258
>
    15.229    41.078
    14.909    41.258
>
    15.229    41.078
    14.909    41.258
>
    14.568    41.031
    14.909    41.258
>
    14.568    41.031
    14.909    41.258
>
    14.905    41.654
    14.909    41.258
>
    14.905    41.654
    14.909    41.258
>
    15.237    41.028
    14.909    41.258
>
    15.237    41.028
    14.909    41.258
>
    15.003    40.918
    14.909    41.258
>
    15.003    40.918
    14.909    41.258
>
    14.379    41.387
    14.909    41.258
>
    14.379    41.387
    14.909    41.258
>
    15.365    41.135
    14.909    41.258
>
    15.365    41.135
    14.909    41.258
>
    15.209    40.925
    14.909    41.258
>
    15.209    40.925
    14.909    41.258
>
    15.180    40.897
    14.909    41.258
>
    15.180    40.897
    14.909    41.258
>
    15.127    41.706
    14.909    41.258
>
    15.127    41.706
    14.909    41.258
>
    15.122    40.847
    14.909    41.258
>
    14.180    41.200
    14.909    41.258
>
    14.550    41.767
    14.909    41.258
>
    15.168    40.783
    14.909    41.258
>
    15.168    40.783
    14.909    41.258
>
    14.424    40.836
    14.909    41.258
>
    14.430    40.830
    14.909    41.258
>
    14.422    40.821
    14.909    41.258
>
    14.398    40.827
    14.909    41.258
>
    14.424    40.806
    14.909    41.258
>
    15.193    40.736
    14.909    41.258
>
    14.669    41.974
    14.844    41.840
>
    14.669    41.974
    14.844    41.840
>
    14.550    41.767
    14.844    41.840
>
    14.550    41.767
    14.844    41.840
>
    15.127    41.706
    14.844    41.840
>
    15.127    41.706
    14.844    41.840
>
    14.910    41.513
    14.844    41.840
>
    14.594    41.546
    14.844    41.840
>
    14.706    41.397
    14.844    41.840
>
    14.706    41.397
    14.844    41.840
>
    14.254    41.642
    14.844    41.840
>
    14.254    41.642
    14.844    41.840
>
    14.183    42.047
    14.844    41.840
>
    14.183    42.047
    14.844    41.840
>
    15.543    41.757
    14.844    41.840
>
    14.153    41.703
    14.844    41.840
>
    14.153    41.703
    14.844    41.840
>
    15.158    41.370
    14.844    41.840
>
    14.529    41.364
    14.844    41.840
>
    14.379    41.387
    14.844    41.840
>
    14.669    41.974
    14.842    41.855
>
    14.669    41.974
    14.842    41.855
>
    14.905    41.654
    14.842    41.855
>
    14.905    41.654
    14.842    41.855
>
    14.550    41.767
    14.842    41.855
>
    14.550    41.767
    14.842    41.855
>
    15.127    41.706
    14.842    41.855
>
    15.127    41.706
    14.842    41.855
>
    14.910    41.513
    14.842    41.855
>
    14.594    41.546
    14.842    41.855
>
    14.594    41.546
    14.842    41.855
>
    14.706    41.397
    14.842    41.855
>
    14.706    41.397
    14.842    41.855
>
    14.254    41.642
    14.842    41.855
>
    14.254    41.642
    14.842    41.855
>
    14.183    42.047
    14.842    41.855
>
    14.183    42.047
    14.842    41.855
>
    14.153    41.703
    14.842    41.855
>
    14.153    41.703
    14.842    41.855
>
    15.543    41.757
    14.842    41.855
>
    15.543    41.757
    14.842    41.855
>
    14.529    41.364
    14.842    41.855
>
    14.529    41.364
    14.842    41.855
>
    15.158    41.370
    14.842    41.855
>
    15.511    42.124
    14.842    41.855
>
    15.511    42.124
    14.842    41.855
>
    14.379    41.387
    14.842    41.855
>
    14.379    41.387
    14.842    41.855
>
    14.669    41.974
    14.840    41.833
>
    14.669    41.974
    14.840    41.833
>
    14.550    41.767
    14.840    41.833
>
    14.550    41.767
    14.840    41.833
>
    14.905    41.654
    14.840    41.833
>
    14.905    41.654
    14.840    41.833
>
    15.127    41.706
    14.840    41.833
>
    15.127    41.706
    14.840    41.833
>
    14.594    41.546
    14.840    41.833
>
    14.594    41.546
    14.840    41.833
>
    14.910    41.513
    14.840    41.833
>
    14.910    41.513
    14.840    41.833
>
    14.254    41.642
    14.840    41.833
>
    14.706    41.397
    14.840    41.833
>
    14.706    41.397
    14.840    41.833
>
    14.183    42.047
    14.840    41.833
>
    14.183    42.047
    14.840    41.833
>
    14.153    41.703
    14.840    41.833
>
    14.153    41.703
    14.840    41.833
>
    14.529    41.364
    14.840    41.833
>
    14.529    41.364
    14.840    41.833
>
    15.158    41.370
    14.840    41.833
>
    15.543    41.757
    14.840    41.833
>
    15.543    41.757
    14.840    41.833
>
    14.379    41.387
    14.840    41.833
>
    14.379    41.387
    14.840    41.833
>
    14.669    41.974
    14.817    41.843
>
    14.669    41.974
    14.817    41.843
>
    14.550    41.767
    14.817    41.843
>
    14.550    41.767
    14.817    41.843
>
    14.905    41.654
    14.817    41.843
>
    14.905    41.654
    14.817    41.843
>
    15.127    41.706
    14.817    41.843
>
    15.127    41.706
    14.817    41.843
>
    14.594    41.546
    14.817    41.843
>
    14.594    41.546
    14.817    41.843
>
    14.910    41.513
    14.817    41.843
>
    14.254    41.642
    14.817    41.843
>
    14.254    41.642
    14.817    41.843
>
    14.706    41.397
    14.817    41.843
>
    14.706    41.397
    14.817    41.843
>
    14.183    42.047
    14.817    41.843
>
    14.153    41.703
    14.817    41.843
>
    14.529    41.364
    14.817    41.843
>
    14.529    41.364
    14.817    41.843
>
    15.158    41.370
    14.817    41.843
>
    14.379    41.387
    14.817    41.843
>
    14.379    41.387
    14.817    41.843
>
    15.543    41.757
    14.817    41.843
>
    15.543    41.757
    14.817    41.843
>
    14.669    41.974
    14.866    41.830
>
    14.669    41.974
    14.866    41.830
>
    14.905    41.654
    14.866    41.830
>
    14.905    41.654
    14.866    41.830
>
    14.550    41.767
    14.866    41.830
>
    14.550    41.767
    14.866    41.830
>
    15.127    41.706
    14.866    41.830
>
    15.127    41.706
    14.866    41.830
>
    14.910    41.513
    14.866    41.830
>
    14.910    41.513
    14.866    41.830
>
    14.594    41.546
    14.866    41.830
>
    14.594    41.546
    14.866    41.830
>
    14.706    41.397
    14.866    41.830
>
    14.706    41.397
    14.866    41.830
>
    14.254    41.642
    14.866    41.830
>
    14.254    41.642
    14.866    41.830
>
    14.183    42.047
    14.866    41.830
>
    14.153    41.703
    14.866    41.830
>
    14.153    41.703
    14.866    41.830
>
    15.543    41.757
    14.866    41.830
>
    14.529    41.364
    14.866    41.830
>
    15.158    41.370
    14.866    41.830
>
    14.379    41.387
    14.866    41.830
>
    14.379    41.387
    14.866    41.830
>
    14.905    41.654
    14.872    41.832
>
    14.905    41.654
    14.872    41.832
>
    14.550    41.767
    14.872    41.832
>
    14.550    41.767
    14.872    41.832
>
    14.594    41.546
    14.872    41.832
>
    14.594    41.546
    14.872    41.832
>
    14.910    41.513
    14.872    41.832
>
    14.910    41.513
    14.872    41.832
>
    14.669    41.974
    14.872    41.832
>
    14.669    41.974
    14.872    41.832
>
    15.127    41.706
    14.872    41.832
>
    15.127    41.706
    14.872    41.832
>
    14.706    41.397
    14.872    41.832
>
    14.706    41.397
    14.872    41.832
>
    14.254    41.642
    14.872    41.832
>
    14.254    41.642
    14.872    41.832
>
    14.529    41.364
    14.872    41.832
>
    14.529    41.364
    14.872    41.832
>
    14.379    41.387
    14.872    41.832
>
    15.158    41.370
    14.872    41.832
>
    15.158    41.370
    14.872    41.832
>
    14.153    41.703
    14.872    41.832
>
    14.183    42.047
    14.872    41.832
>
    14.183    42.047
    14.872    41.832
>
    15.543    41.757
    14.872    41.832
>
    15.543    41.757
    14.872    41.832
>
    14.669    41.974
    14.870    41.843
>
    14.905    41.654
    14.870    41.843
>
    14.905    41.654
    14.870    41.843
>
    15.127    41.706
    14.870    41.843
>
    15.127    41.706
    14.870    41.843
>
    14.550    41.767
    14.870    41.843
>
    14.550    41.767
    14.870    41.843
>
    14.910    41.513
    14.870    41.843
>
    14.910    41.513
    14.870    41.843
>
    14.594    41.546
    14.870    41.843
>
    14.594    41.546
    14.870    41.843
>
    14.706    41.397
    14.870    41.843
>
    14.706    41.397
    14.870    41.843
>
    14.254    41.642
    14.870    41.843
>
    14.254    41.642
    14.870    41.843
>
    15.543    41.757
    14.870    41.843
>
    15.543    41.757
    14.870    41.843
>
    15.158    41.370
    14.870    41.843
>
    14.183    42.047
    14.870    41.843
>
    14.183    42.047
    14.870    41.843
>
    14.153    41.703
    14.870    41.843
>
    14.153    41.703
    14.870    41.843
>
    14.379    41.387
    14.870    41.843
>
    14.926    41.946
    14.849    41.878
>
    14.926    41.946
    14.849    41.878
>
    14.669    41.974
    14.849    41.878
>
    15.017    41.852
    14.849    41.878
>
    15.017    41.852
    14.849    41.878
>
    14.905    41.654
    14.849    41.878
>
    14.905    41.654
    14.849    41.878
>
    15.127    41.706
    14.849    41.878
>
    15.127    41.706
    14.849    41.878
>
    14.910    41.513
    14.849    41.878
>
    14.910    41.513
    14.849    41.878
>
    14.594    41.546
    14.849    41.878
>
    14.594    41.546
    14.849    41.878
>
    14.706    41.397
    14.849    41.878
>
    14.706    41.397
    14.849    41.878
>
    14.183    42.047
    14.849    41.878
>
    14.183    42.047
    14.849    41.878
>
    14.153    41.703
    14.849    41.878
>
    14.153    41.703
    14.849    41.878
>
    15.543    41.757
    14.849    41.878
>
    15.543    41.757
    14.849    41.878
>
    15.158    41.370
    14.849    41.878
>
    14.768    41.784
    14.849    41.849
>
    14.768    41.784
    14.849    41.849
>
    14.926    41.946
    14.849    41.849
>
    14.926    41.946
    14.849    41.849
>
    15.017    41.852
    14.849    41.849
>
    15.017    41.852
    14.849    41.849
>
    14.905    41.654
    14.849    41.849
>
    14.905    41.654
    14.849    41.849
>
    14.669    41.974
    14.849    41.849
>
    14.669    41.974
    14.849    41.849
>
    14.550    41.767
    14.849    41.849
>
    15.127    41.706
    14.849    41.849
>
    15.127    41.706
    14.849    41.849
>
    14.910    41.513
    14.849    41.849
>
    14.910    41.513
    14.849    41.849
>
    14.594    41.546
    14.849    41.849
>
    14.594    41.546
    14.849    41.849
>
    14.706    41.397
    14.849    41.849
>
    14.706    41.397
    14.849    41.849
>
    14.254    41.642
    14.849    41.849
>
    14.254    41.642
    14.849    41.849
>
    14.529    41.364
    14.849    41.849
>
    14.529    41.364
    14.849    41.849
>
    15.158    41.370
    14.849    41.849
>
    14.153    41.703
    14.849    41.849
>
    14.153    41.703
    14.849    41.849
>
    14.183    42.047
    14.849    41.849
>
    14.183    42.047
    14.849    41.849
>
    15.543    41.757
    14.849    41.849
>
    15.543    41.757
    14.849    41.849
>
    14.379    41.387
    14.849    41.849
>
    14.379    41.387
    14.849    41.849
>
    14.768    41.784
    14.862    41.836
>
    14.768    41.784
    14.862    41.836
>
    14.926    41.946
    14.862    41.836
>
    14.926    41.946
    14.862    41.836
>
    15.017    41.852
    14.862    41.836
>
    15.017    41.852
    14.862    41.836
>
    14.669    41.974
    14.862    41.836
>
    14.669    41.974
    14.862    41.836
>
    14.905    41.654
    14.862    41.836
>
    14.905    41.654
    14.862    41.836
>
    14.550    41.767
    14.862    41.836
>
    14.550    41.767
    14.862    41.836
>
    15.127    41.706
    14.862    41.836
>
    15.127    41.706
    14.862    41.836
>
    14.910    41.513
    14.862    41.836
>
    14.910    41.513
    14.862    41.836
>
    14.594    41.546
    14.862    41.836
>
    14.706    41.397
    14.862    41.836
>
    14.706    41.397
    14.862    41.836
>
    14.254    41.642
    14.862    41.836
>
    14.254    41.642
    14.862    41.836
>
    15.543    41.757
    14.862    41.836
>
    15.543    41.757
    14.862    41.836
>
    14.183    42.047
    14.862    41.836
>
    14.183    42.047
    14.862    41.836
>
    15.158    41.370
    14.862    41.836
>
    15.158    41.370
    14.862    41.836
>
    14.153    41.703
    14.862    41.836
>
    14.153    41.703
    14.862    41.836
>
    14.379    41.387
    14.862    41.836
>
    14.768    41.784
    14.856    41.845
>
    14.768    41.784
    14.856    41.845
>
    14.926    41.946
    14.856    41.845
>
    14.926    41.946
    14.856    41.845
>
    15.017    41.852
    14.856    41.845
>
    15.017    41.852
    14.856    41.845
>
    14.669    41.974
    14.856    41.845
>
    14.669    41.974
    14.856    41.845
>
    14.905    41.654
    14.856    41.845
>
    14.905    41.654
    14.856    41.845
>
    14.550    41.767
    14.856    41.845
>
    14.550    41.767
    14.856    41.845
>
    15.127    41.706
    14.856    41.845
>
    15.127    41.706
    14.856    41.845
>
    14.910    41.513
    14.856    41.845
>
    14.594    41.546
    14.856    41.845
>
    14.594    41.546
    14.856    41.845
>
    14.706    41.397
    14.856    41.845
>
    14.706    41.397
    14.856    41.845
>
    14.254    41.642
    14.856    41.845
>
    14.254    41.642
    14.856    41.845
>
    15.543    41.757
    14.856    41.845
>
    15.543    41.757
    14.856    41.845
>
    15.158    41.370
    14.856    41.845
>
    14.183    42.047
    14.856    41.845
>
    14.183    42.047
    14.856    41.845
>
    14.529    41.364
    14.856    41.845
>
    14.153    41.703
    14.856    41.845
>
    14.153    41.703
    14.856    41.845
>
    14.379    41.387
    14.856    41.845
>
    14.772    41.130
    14.739    41.067
>
    14.772    41.130
    14.739    41.067
>
    14.630    41.183
    14.739    41.067
>
    14.630    41.183
    14.739    41.067
>
    14.568    41.031
    14.739    41.067
>
    14.787    40.923
    14.739    41.067
>
    14.787    40.923
    14.739    41.067
>
    14.973    41.126
    14.739    41.067
>
    14.973    41.126
    14.739    41.067
>
    14.991    40.986
    14.739    41.067
>
    14.991    40.986
    14.739    41.067
>
    14.545    40.920
    14.739    41.067
>
    15.003    40.918
    14.739    41.067
>
    15.003    40.918
    14.739    41.067
>
    14.706    41.397
    14.739    41.067
>
    14.706    41.397
    14.739    41.067
>
    15.133    41.200
    14.739    41.067
>
    14.529    41.364
    14.739    41.067
>
    14.529    41.364
    14.739    41.067
>
    14.424    40.836
    14.739    41.067
>
    14.424    40.836
    14.739    41.067
>
    14.430    40.830
    14.739    41.067
>
    14.430    40.830
    14.739    41.067
>
    14.431    40.819
    14.739    41.067
>
    15.229    41.078
    14.739    41.067
>
    15.229    41.078
    14.739    41.067
>
    15.122    40.847
    14.739    41.067
>
    15.122    40.847
    14.739    41.067
>
    15.237    41.028
    14.739    41.067
>
    15.237    41.028
    14.739    41.067
>
    14.424    40.806
    14.739    41.067
>
    14.424    40.806
    14.739    41.067
>
    15.180    40.897
    14.739    41.067
>
    15.180    40.897
    14.739    41.067
>
    14.910    41.513
    14.739    41.067
>
    14.910    41.513
    14.739    41.067
>
    15.168    40.783
    14.739    41.067
>
    15.168    40.783
    14.739    41.067
>
    14.180    41.200
    14.739    41.067
>
    14.180    41.200
    14.739    41.067
>
    15.365    41.135
    14.739    41.067
>
    15.365    41.135
    14.739    41.067
>
    14.594    41.546
    14.739    41.067
>
    14.594    41.546
    14.739    41.067
>
    15.333    40.930
    14.739    41.067
>
    15.193    40.736
    14.739    41.067
>
    15.193    40.736
    14.739    41.067
>
    14.182    40.838
    14.739    41.067
>
    14.234    41.415
    14.739    41.067
>
    14.234    41.415
    14.739    41.067
>
    14.144    40.827
    14.739    41.067
>
    14.140    40.829
    14.739    41.067
>
    15.404    40.903
    14.739    41.067
>
    14.145    40.819
    14.739    41.067
>
    14.142    40.820
    14.739    41.067
>
    14.119    40.821
    14.739    41.067
>
    14.090    40.833
    14.739    41.067
>
    13.971    41.191
    14.739    41.067
>
    15.330    40.687
    14.739    41.067
>
    14.772    41.130
    14.744    41.052
>
    14.772    41.130
    14.744    41.052
>
    14.568    41.031
    14.744    41.052
>
    14.568    41.031
    14.744    41.052
>
    14.787    40.923
    14.744    41.052
>
    14.787    40.923
    14.744    41.052
>
    14.973    41.126
    14.744    41.052
>
    14.973    41.126
    14.744    41.052
>
    14.991    40.986
    14.744    41.052
>
    14.991    40.986
    14.744    41.052
>
    14.545    40.920
    14.744    41.052
>
    15.003    40.918
    14.744    41.052
>
    14.706    41.397
    14.744    41.052
>
    14.706    41.397
    14.744    41.052
>
    15.133    41.200
    14.744    41.052
>
    14.529    41.364
    14.744    41.052
>
    14.424    40.836
    14.744    41.052
>
    14.424    40.836
    14.744    41.052
>
    14.430    40.830
    14.744    41.052
>
    14.430    40.830
    14.744    41.052
>
    14.431    40.819
    14.744    41.052
>
    14.431    40.819
    14.744    41.052
>
    14.424    40.806
    14.744    41.052
>
    14.424    40.806
    14.744    41.052
>
    15.229    41.078
    14.744    41.052
>
    15.229    41.078
    14.744    41.052
>
    15.122    40.847
    14.744    41.052
>
    15.122    40.847
    14.744    41.052
>
    15.237    41.028
    14.744    41.052
>
    15.237    41.028
    14.744    41.052
>
    15.180    40.897
    14.744    41.052
>
    15.180    40.897
    14.744    41.052
>
    15.158    41.370
    14.744    41.052
>
    14.180    41.200
    14.744    41.052
>
    14.180    41.200
    14.744    41.052
>
    15.168    40.783
    14.744    41.052
>
    15.168    40.783
    14.744    41.052
>
    14.910    41.513
    14.744    41.052
>
    15.333    40.930
    14.744    41.052
>
    15.333    40.930
    14.744    41.052
>
    14.594    41.546
    14.744    41.052
>
    15.365    41.135
    14.744    41.052
>
    15.193    40.736
    14.744    41.052
>
    14.234    41.415
    14.744    41.052
>
    14.234    41.415
    14.744    41.052
>
    15.404    40.903
    14.744    41.052
>
    15.330    40.687
    14.744    41.052
>
    14.772    41.130
    14.725    41.056
>
    14.772    41.130
    14.725    41.056
>
    14.787    40.923
    14.725    41.056
>
    14.787    40.923
    14.725    41.056
>
    14.630    41.183
    14.725    41.056
>
    14.973    41.126
    14.725    41.056
>
    14.973    41.126
    14.725    41.056
>
    14.568    41.031
    14.725    41.056
>
    14.991    40.986
    14.725    41.056
>
    14.991    40.986
    14.725    41.056
>
    14.545    40.920
    14.725    41.056
>
    15.003    40.918
    14.725    41.056
>
    15.003    40.918
    14.725    41.056
>
    15.133    41.200
    14.725    41.056
>
    14.706    41.397
    14.725    41.056
>
    14.706    41.397
    14.725    41.056
>
    14.529    41.364
    14.725    41.056
>
    15.229    41.078
    14.725    41.056
>
    15.122    40.847
    14.725    41.056
>
    15.122    40.847
    14.725    41.056
>
    15.237    41.028
    14.725    41.056
>
    15.237    41.028
    14.725    41.056
>
    15.180    40.897
    14.725    41.056
>
    15.180    40.897
    14.725    41.056
>
    14.424    40.836
    14.725    41.056
>
    14.424    40.836
    14.725    41.056
>
    14.430    40.830
    14.725    41.056
>
    14.430    40.830
    14.725    41.056
>
    14.431    40.819
    14.725    41.056
>
    14.431    40.819
    14.725    41.056
>
    14.424    40.806
    14.725    41.056
>
    14.424    40.806
    14.725    41.056
>
    15.158    41.370
    14.725    41.056
>
    15.168    40.783
    14.725    41.056
>
    15.168    40.783
    14.725    41.056
>
    14.910    41.513
    14.725    41.056
>
    15.365    41.135
    14.725    41.056
>
    14.180    41.200
    14.725    41.056
>
    14.180    41.200
    14.725    41.056
>
    15.193    40.736
    14.725    41.056
>
    15.193    40.736
    14.725    41.056
>
    14.594    41.546
    14.725    41.056
>
    15.404    40.903
    14.725    41.056
>
    14.234    41.415
    14.725    41.056
>
    14.119    40.821
    14.725    41.056
>
    15.330    40.687
    14.725    41.056
>
    14.772    41.130
    14.730    41.055
>
    14.772    41.130
    14.730    41.055
>
    14.568    41.031
    14.730    41.055
>
    14.630    41.183
    14.730    41.055
>
    14.630    41.183
    14.730    41.055
>
    14.973    41.126
    14.730    41.055
>
    14.973    41.126
    14.730    41.055
>
    14.991    40.986
    14.730    41.055
>
    14.991    40.986
    14.730    41.055
>
    15.003    40.918
    14.730    41.055
>
    15.003    40.918
    14.730    41.055
>
    15.007    40.837
    14.730    41.055
>
    14.706    41.397
    14.730    41.055
>
    14.529    41.364
    14.730    41.055
>
    14.529    41.364
    14.730    41.055
>
    14.424    40.836
    14.730    41.055
>
    14.424    40.836
    14.730    41.055
>
    14.430    40.830
    14.730    41.055
>
    14.430    40.830
    14.730    41.055
>
    15.133    41.200
    14.730    41.055
>
    14.431    40.819
    14.730    41.055
>
    14.431    40.819
    14.730    41.055
>
    14.424    40.806
    14.730    41.055
>
    15.180    40.930
    14.730    41.055
>
    15.180    40.930
    14.730    41.055
>
    15.122    40.847
    14.730    41.055
>
    15.122    40.847
    14.730    41.055
>
    15.229    41.078
    14.730    41.055
>
    15.229    41.078
    14.730    41.055
>
    15.180    40.897
    14.730    41.055
>
    15.180    40.897
    14.730    41.055
>
    15.237    41.028
    14.730    41.055
>
    15.237    41.028
    14.730    41.055
>
    14.180    41.200
    14.730    41.055
>
    14.180    41.200
    14.730    41.055
>
    15.168    40.783
    14.730    41.055
>
    15.168    40.783
    14.730    41.055
>
    14.910    41.513
    14.730    41.055
>
    14.182    40.838
    14.730    41.055
>
    15.333    40.930
    14.730    41.055
>
    14.594    41.546
    14.730    41.055
>
    15.365    41.135
    14.730    41.055
>
    15.193    40.736
    14.730    41.055
>
    15.193    40.736
    14.730    41.055
>
    14.234    41.415
    14.730    41.055
>
    15.404    40.903
    14.730    41.055
>
    15.330    40.687
    14.730    41.055
>
    15.122    40.847
    15.113    40.888
>
    15.122    40.847
    15.113    40.888
>
    15.209    40.925
    15.113    40.888
>
    15.209    40.925
    15.113    40.888
>
    15.003    40.918
    15.113    40.888
>
    15.176    40.964
    15.113    40.888
>
    15.176    40.964
    15.113    40.888
>
    15.007    40.837
    15.113    40.888
>
    15.168    40.783
    15.113    40.888
>
    15.168    40.783
    15.113    40.888
>
    14.991    40.986
    15.113    40.888
>
    14.991    40.986
    15.113    40.888
>
    15.193    40.736
    15.113    40.888
>
    15.237    41.028
    15.113    40.888
>
    15.237    41.028
    15.113    40.888
>
    15.229    41.078
    15.113    40.888
>
    15.229    41.078
    15.113    40.888
>
    14.787    40.923
    15.113    40.888
>
    14.787    40.923
    15.113    40.888
>
    15.330    40.687
    15.113    40.888
>
    14.973    41.126
    15.113    40.888
>
    14.973    41.126
    15.113    40.888
>
    15.489    40.756
    15.113    40.888
>
    15.489    40.756
    15.113    40.888
>
    15.365    41.135
    15.113    40.888
>
    15.133    41.200
    15.113    40.888
>
    15.133    41.200
    15.113    40.888
>
    15.536    40.875
    15.113    40.888
>
    15.243    40.561
    15.113    40.888
>
    15.243    40.561
    15.113    40.888
>
    15.511    40.695
    15.113    40.888
>
    15.307    40.560
    15.113    40.888
>
    14.772    41.130
    15.113    40.888
>
    15.616    40.955
    15.113    40.888
>
    15.616    40.955
    15.113    40.888
>
    14.811    41.223
    15.113    40.888
>
    14.568    41.031
    15.113    40.888
>
    14.630    41.183
    15.113    40.888
>
    15.651    40.530
    15.113    40.888
>
    15.807    40.646
    15.113    40.888
>
    15.303    40.318
    15.113    40.888
>
    15.817    41.158
    15.113    40.888
>
    14.706    41.397
    15.113    40.888
>
    15.543    41.757
    15.416    41.815
>
    15.543    41.757
    15.416    41.815
>
    15.581    41.720
    15.416    41.815
>
    15.594    41.686
    15.416    41.815
>
    15.594    41.686
    15.416    41.815
>
    15.650    41.712
    15.416    41.815
>
    15.650    41.712
    15.416    41.815
>
    15.603    41.659
    15.416    41.815
>
    15.603    41.659
    15.416    41.815
>
    15.127    41.706
    15.416    41.815
>
    15.127    41.706
    15.416    41.815
>
    15.744    41.755
    15.416    41.815
>
    15.744    41.755
    15.416    41.815
>
    15.744    41.755
    15.416    41.815
>
    15.335    41.515
    15.416    41.815
>
    14.920    41.807
    15.416    41.815
>
    14.918    41.912
    15.416    41.815
>
    14.905    41.654
    15.416    41.815
>
    15.910    41.712
    15.416    41.815
>
    15.910    41.712
    15.416    41.815
>
    14.837    41.902
    15.416    41.815
>
    14.837    41.902
    15.416    41.815
>
    14.789    41.886
    15.416    41.815
>
    14.910    41.513
    15.416    41.815
>
    14.932    42.236
    15.416    41.815
>
    16.179    41.881
    15.416    41.815
>
    16.179    41.881
    15.416    41.815
>
    14.706    41.397
    14.681    41.375
>
    14.706    41.397
    14.681    41.375
>
    14.529    41.364
    14.681    41.375
>
    14.529    41.364
    14.681    41.375
>
    14.594    41.546
    14.681    41.375
>
    14.594    41.546
    14.681    41.375
>
    14.811    41.223
    14.681    41.375
>
    14.811    41.223
    14.681    41.375
>
    14.630    41.183
    14.681    41.375
>
    14.630    41.183
    14.681    41.375
>
    14.379    41.387
    14.681    41.375
>
    14.379    41.387
    14.681    41.375
>
    14.910    41.513
    14.681    41.375
>
    14.772    41.130
    14.681    41.375
>
    14.234    41.415
    14.681    41.375
>
    14.973    41.126
    14.681    41.375
>
    14.973    41.126
    14.681    41.375
>
    14.568    41.031
    14.681    41.375
>
    14.568    41.031
    14.681    41.375
>
    14.180    41.200
    14.681    41.375
>
    15.133    41.200
    14.681    41.375
>
    14.254    41.642
    14.681    41.375
>
    14.787    40.923
    14.681    41.375
>
    14.991    40.986
    14.681    41.375
>
    15.265    41.279
    14.681    41.375
>
    14.920    41.807
    14.681    41.375
>
    15.127    41.706
    14.681    41.375
>
    14.153    41.703
    14.681    41.375
>
    14.153    41.703
    14.681    41.375
>
    14.789    41.886
    14.681    41.375
>
    15.229    41.078
    14.681    41.375
>
    14.018    41.598
    14.681    41.375
>
    15.335    41.515
    14.681    41.375
>
    15.335    41.515
    14.681    41.375
>
    15.237    41.028
    14.681    41.375
>
    15.176    40.964
    14.681    41.375
>
    14.918    41.912
    14.681    41.375
>
    14.431    40.819
    14.681    41.375
>
    15.365    41.135
    14.681    41.375
>
    15.007    40.837
    14.681    41.375
>
    15.169    41.834
    14.681    41.375
>
    14.910    41.513
    14.896    41.583
>
    14.910    41.513
    14.896    41.583
>
    15.127    41.706
    14.896    41.583
>
    15.127    41.706
    14.896    41.583
>
    14.920    41.807
    14.896    41.583
>
    14.920    41.807
    14.896    41.583
>
    14.594    41.546
    14.896    41.583
>
    14.594    41.546
    14.896    41.583
>
    14.706    41.397
    14.896    41.583
>
    14.706    41.397
    14.896    41.583
>
    15.158    41.370
    14.896    41.583
>
    15.158    41.370
    14.896    41.583
>
    14.789    41.886
    14.896    41.583
>
    14.789    41.886
    14.896    41.583
>
    14.837    41.902
    14.896    41.583
>
    14.837    41.902
    14.896    41.583
>
    15.169    41.834
    14.896    41.583
>
    15.169    41.834
    14.896    41.583
>
    14.918    41.912
    14.896    41.583
>
    14.918    41.912
    14.896    41.583
>
    15.335    41.515
    14.896    41.583
>
    15.335    41.515
    14.896    41.583
>
    14.529    41.364
    14.896    41.583
>
    14.529    41.364
    14.896    41.583
>
    15.370    41.688
    14.896    41.583
>
    15.370    41.688
    14.896    41.583
>
    14.811    41.223
    14.896    41.583
>
    14.811    41.223
    14.896    41.583
>
    14.387    41.749
    14.896    41.583
>
    14.387    41.749
    14.896    41.583
>
    15.265    41.279
    14.896    41.583
>
    15.265    41.279
    14.896    41.583
>
    14.379    41.387
    14.896    41.583
>
    14.379    41.387
    14.896    41.583
>
    14.630    41.183
    14.896    41.583
>
    14.630    41.183
    14.896    41.583
>
    14.772    41.130
    14.896    41.583
>
    14.772    41.130
    14.896    41.583
>
    14.973    41.126
    14.896    41.583
>
    14.973    41.126
    14.896    41.583
>
    14.254    41.642
    14.896    41.583
>
    14.254    41.642
    14.896    41.583
>
    15.044    41.114
    14.896    41.583
>
    15.543    41.757
    14.896    41.583
>
    15.543    41.757
    14.896    41.583
>
    15.581    41.720
    14.896    41.583
>
    15.581    41.720
    14.896    41.583
>
    14.234    41.415
    14.896    41.583
>
    14.234    41.415
    14.896    41.583
>
    15.594    41.686
    14.896    41.583
>
    15.594    41.686
    14.896    41.583
>
    15.603    41.659
    14.896    41.583
>
    15.603    41.659
    14.896    41.583
>
    15.164    41.085
    14.896    41.583
>
    14.153    41.703
    14.896    41.583
>
    14.153    41.703
    14.896    41.583
>
    15.229    41.078
    14.896    41.583
>
    15.229    41.078
    14.896    41.583
>
    15.650    41.712
    14.896    41.583
>
    15.650    41.712
    14.896    41.583
>
    15.365    41.135
    14.896    41.583
>
    15.365    41.135
    14.896    41.583
>
    14.991    40.986
    14.896    41.583
>
    14.991    40.986
    14.896    41.583
>
    14.918    41.912
    15.059    41.942
>
    15.169    41.834
    15.059    41.942
>
    15.169    41.834
    15.059    41.942
>
    14.920    41.807
    15.059    41.942
>
    14.920    41.807
    15.059    41.942
>
    14.837    41.902
    15.059    41.942
>
    14.837    41.902
    15.059    41.942
>
    14.789    41.886
    15.059    41.942
>
    14.789    41.886
    15.059    41.942
>
    15.127    41.706
    15.059    41.942
>
    15.127    41.706
    15.059    41.942
>
    14.932    42.236
    15.059    41.942
>
    15.370    41.688
    15.059    41.942
>
    15.370    41.688
    15.059    41.942
>
    15.511    42.124
    15.059    41.942
>
    15.511    42.124
    15.059    41.942
>
    15.543    41.757
    15.059    41.942
>
    15.543    41.757
    15.059    41.942
>
    14.910    41.513
    15.059    41.942
>
    14.910    41.513
    15.059    41.942
>
    15.581    41.720
    15.059    41.942
>
    15.335    41.515
    15.059    41.942
>
    15.335    41.515
    15.059    41.942
>
    15.594    41.686
    15.059    41.942
>
    15.603    41.659
    15.059    41.942
>
    15.650    41.712
    15.059    41.942
>
    14.594    41.546
    15.059    41.942
>
    14.387    41.749
    15.059    41.942
>
    15.158    41.370
    15.059    41.942
>
    15.719    41.621
    15.059    41.942
>
    14.387    41.749
    14.251    41.755
>
    14.387    41.749
    14.251    41.755
>
    14.018    41.598
    14.251    41.755
>
    14.018    41.598
    14.251    41.755
>
    14.183    42.047
    14.251    41.755
>
    14.183    42.047
    14.251    41.755
>
    13.830    41.776
    14.251    41.755
>
    14.594    41.546
    14.251    41.755
>
    14.594    41.546
    14.251    41.755
>
    14.234    41.415
    14.251    41.755
>
    14.234    41.415
    14.251    41.755
>
    13.905    42.012
    14.251    41.755
>
    13.905    42.012
    14.251    41.755
>
    13.917    42.073
    14.251    41.755
>
    13.917    42.073
    14.251    41.755
>
    13.909    42.068
    14.251    41.755
>
    13.909    42.068
    14.251    41.755
>
    13.927    42.085
    14.251    41.755
>
    13.927    42.085
    14.251    41.755
>
    13.712    41.717
    14.251    41.755
>
    13.712    41.717
    14.251    41.755
>
    14.789    41.886
    14.251    41.755
>
    14.789    41.886
    14.251    41.755
>
    13.817    41.483
    14.251    41.755
>
    13.817    41.483
    14.251    41.755
>
    14.837    41.902
    14.251    41.755
>
    14.837    41.902
    14.251    41.755
>
    13.622    41.871
    14.251    41.755
>
    13.622    41.871
    14.251    41.755
>
    14.905    41.654
    14.251    41.755
>
    14.905    41.654
    14.251    41.755
>
    14.920    41.807
    14.251    41.755
>
    14.920    41.807
    14.251    41.755
>
    13.587    41.647
    14.251    41.755
>
    13.587    41.647
    14.251    41.755
>
    14.918    41.912
    14.251    41.755
>
    14.918    41.912
    14.251    41.755
>
    14.910    41.513
    14.251    41.755
>
    13.558    41.505
    14.251    41.755
>
    13.779    42.226
    14.251    41.755
>
    13.779    42.226
    14.251    41.755
>
    14.905    41.654
    14.679    41.659
>
    14.905    41.654
    14.679    41.659
>
    14.920    41.807
    14.679    41.659
>
    14.920    41.807
    14.679    41.659
>
    14.910    41.513
    14.679    41.659
>
    14.910    41.513
    14.679    41.659
>
    14.387    41.749
    14.679    41.659
>
    14.387    41.749
    14.679    41.659
>
    14.789    41.886
    14.679    41.659
>
    14.789    41.886
    14.679    41.659
>
    14.837    41.902
    14.679    41.659
>
    14.837    41.902
    14.679    41.659
>
    14.706    41.397
    14.679    41.659
>
    14.706    41.397
    14.679    41.659
>
    14.918    41.912
    14.679    41.659
>
    14.918    41.912
    14.679    41.659
>
    15.127    41.706
    14.679    41.659
>
    15.127    41.706
    14.679    41.659
>
    14.379    41.387
    14.679    41.659
>
    14.379    41.387
    14.679    41.659
>
    14.153    41.703
    14.679    41.659
>
    14.153    41.703
    14.679    41.659
>
    15.169    41.834
    14.679    41.659
>
    15.169    41.834
    14.679    41.659
>
    14.234    41.415
    14.679    41.659
>
    14.234    41.415
    14.679    41.659
>
    15.158    41.370
    14.679    41.659
>
    15.158    41.370
    14.679    41.659
>
    14.018    41.598
    14.679    41.659
>
    15.335    41.515
    14.679    41.659
>
    15.335    41.515
    14.679    41.659
>
    15.370    41.688
    14.679    41.659
>
    15.370    41.688
    14.679    41.659
>
    14.183    42.047
    14.679    41.659
>
    14.183    42.047
    14.679    41.659
>
    14.772    41.130
    14.679    41.659
>
    14.772    41.130
    14.679    41.659
>
    14.973    41.126
    14.679    41.659
>
    15.265    41.279
    14.679    41.659
>
    14.180    41.200
    14.679    41.659
>
    14.837    41.902
    14.861    41.828
>
    14.837    41.902
    14.861    41.828
>
    14.837    41.902
    14.861    41.828
>
    14.920    41.807
    14.861    41.828
>
    14.920    41.807
    14.861    41.828
>
    14.918    41.912
    14.861    41.828
>
    14.918    41.912
    14.861    41.828
>
    14.918    41.912
    14.861    41.828
>
    14.905    41.654
    14.861    41.828
>
    14.905    41.654
    14.861    41.828
>
    14.905    41.654
    14.861    41.828
>
    15.169    41.834
    14.861    41.828
>
    15.169    41.834
    14.861    41.828
>
    15.169    41.834
    14.861    41.828
>
    15.127    41.706
    14.861    41.828
>
    15.127    41.706
    14.861    41.828
>
    14.550    41.767
    14.861    41.828
>
    14.550    41.767
    14.861    41.828
>
    14.550    41.767
    14.861    41.828
>
    14.910    41.513
    14.861    41.828
>
    14.910    41.513
    14.861    41.828
>
    14.910    41.513
    14.861    41.828
>
    14.910    41.513
    14.861    41.828
>
    14.910    41.513
    14.861    41.828
>
    14.594    41.546
    14.861    41.828
>
    14.594    41.546
    14.861    41.828
>
    14.387    41.749
    14.861    41.828
>
    14.387    41.749
    14.861    41.828
>
    14.387    41.749
    14.861    41.828
>
    14.932    42.236
    14.861    41.828
>
    14.932    42.236
    14.861    41.828
>
    14.706    41.397
    14.861    41.828
>
    14.706    41.397
    14.861    41.828
>
    15.335    41.515
    14.861    41.828
>
    15.335    41.515
    14.861    41.828
>
    14.254    41.642
    14.861    41.828
>
    14.254    41.642
    14.861    41.828
>
    15.543    41.757
    14.861    41.828
>
    15.543    41.757
    14.861    41.828
>
    15.543    41.757
    14.861    41.828
>
    15.158    41.370
    14.861    41.828
>
    15.158    41.370
    14.861    41.828
>
    15.158    41.370
    14.861    41.828
>
    14.183    42.047
    14.861    41.828
>
    14.183    42.047
    14.861    41.828
>
    14.153    41.703
    14.861    41.828
>
    14.153    41.703
    14.861    41.828
>
    15.511    42.124
    14.861    41.828
>
    15.511    42.124
    14.861    41.828
>
    15.511    42.124
    14.861    41.828
>
    15.511    42.124
    14.861    41.828
>
    15.594    41.686
    14.861    41.828
>
    15.603    41.659
    14.861    41.828
>
    14.379    41.387
    14.861    41.828
>
    14.379    41.387
    14.861    41.828
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
    14.398    40.827     0.300
    14.379    41.387     0.300
    15.551    41.450     0.300
    15.551    41.450     0.300
    14.398    40.827     0.300
    15.551    41.450     0.300
    13.971    41.191     0.300
    14.458    41.659     0.300
    13.810    41.709     0.300
    15.949    41.707     0.300
    13.985    41.301     0.300
    15.268    41.282     0.300
    15.161    41.805     0.300
    15.586    41.674     0.300
    15.517    41.132     0.300
    14.153    41.703     0.300
    14.319    41.585     0.300
    14.811    41.223     0.300
    14.630    41.182     0.300
    14.973    41.126     0.300
    14.905    41.654     0.300
    14.305    41.723     0.300
    14.833    41.233     0.300
    15.953    41.708     0.300
    15.942    41.705     0.300
    14.706    41.397     0.300
    14.254    41.642     0.300
    15.024    40.861     0.300
    14.594    41.546     0.300
    15.209    40.925     0.300
    15.365    41.135     0.300
    15.158    41.370     0.300
    15.616    40.955     0.300
    15.237    41.028     0.300
    16.274    41.082     0.300
    15.744    41.755     0.300
    15.910    41.712     0.300
    14.234    41.415     0.300
    14.018    41.598     0.300
    14.550    41.767     0.300
    14.669    41.974     0.300
    14.529    41.364     0.300
    14.910    41.513     0.300
    15.127    41.706     0.300
    15.168    40.783     0.300
    15.489    40.756     0.300
    14.568    41.031     0.300
    15.133    41.200     0.300
    14.180    41.200     0.300
    13.878    41.146     0.300
    14.417    41.360     0.300
    14.497    41.262     0.300
    14.545    40.920     0.300
    14.630    41.183     0.300
    15.511    42.124     0.300
    14.536    41.475     0.300
    15.543    41.757     0.300
    14.183    42.047     0.300
    14.347    42.227     0.300
    15.229    41.078     0.300
    15.003    40.918     0.300
    15.180    40.897     0.300
    15.122    40.847     0.300
    14.424    40.836     0.300
    14.430    40.830     0.300
    14.422    40.821     0.300
    14.424    40.806     0.300
    15.193    40.736     0.300
    14.926    41.946     0.300
    15.017    41.852     0.300
    14.768    41.784     0.300
    14.772    41.130     0.300
    14.787    40.923     0.300
    14.991    40.986     0.300
    14.431    40.819     0.300
    15.333    40.930     0.300
    14.182    40.838     0.300
    14.144    40.827     0.300
    14.140    40.829     0.300
    15.404    40.903     0.300
    14.145    40.819     0.300
    14.142    40.820     0.300
    14.119    40.821     0.300
    14.090    40.833     0.300
    15.330    40.687     0.300
    15.007    40.837     0.300
    15.180    40.930     0.300
    15.176    40.964     0.300
    15.536    40.875     0.300
    15.243    40.561     0.300
    15.511    40.695     0.300
    15.307    40.560     0.300
    15.651    40.530     0.300
    15.807    40.646     0.300
    15.303    40.318     0.300
    15.817    41.158     0.300
    15.581    41.720     0.300
    15.594    41.686     0.300
    15.650    41.712     0.300
    15.603    41.659     0.300
    15.335    41.515     0.300
    14.920    41.807     0.300
    14.918    41.912     0.300
    14.837    41.902     0.300
    14.789    41.886     0.300
    14.932    42.236     0.300
    16.179    41.881     0.300
    15.265    41.279     0.300
    15.169    41.834     0.300
    15.370    41.688     0.300
    14.387    41.749     0.300
    15.044    41.114     0.300
    15.164    41.085     0.300
    15.719    41.621     0.300
    13.830    41.776     0.300
    13.905    42.012     0.300
    13.917    42.073     0.300
    13.909    42.068     0.300
    13.927    42.085     0.300
    13.712    41.717     0.300
    13.817    41.483     0.300
    13.622    41.871     0.300
    13.587    41.647     0.300
    13.558    41.505     0.300
    13.779    42.226     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
    15.056    41.125     0.200
>
    14.989    41.114     0.200
>
    15.337    41.871     0.200
>
    15.274    40.868     0.200
>
    15.416    40.838     0.200
>
    15.411    41.165     0.200
>
    15.384    40.838     0.200
>
    15.317    40.859     0.200
>
    15.050    40.879     0.200
>
    15.020    40.951     0.200
>
    15.283    40.966     0.200
>
    15.243    40.881     0.200
>
    15.351    40.945     0.200
>
    15.082    41.093     0.200
>
    15.392    40.797     0.200
>
    15.002    41.084     0.200
>
    15.351    40.887     0.200
>
    15.286    40.818     0.200
>
    15.271    40.781     0.200
>
    14.612    40.972     0.200
>
    14.344    41.631     0.200
>
    15.843    41.659     0.200
>
    14.330    41.610     0.200
>
    15.334    41.927     0.200
>
    14.666    41.145     0.200
>
    15.448    41.753     0.200
>
    14.215    41.657     0.200
>
    14.785    41.150     0.200
>
    14.659    41.521     0.200
>
    15.218    41.852     0.200
>
    15.430    41.579     0.200
>
    15.386    41.534     0.200
>
    15.857    41.789     0.200
>
    15.867    41.802     0.200
>
    15.737    41.683     0.200
>
    14.907    41.567     0.200
>
    14.473    41.327     0.200
>
    15.328    41.222     0.200
>
    15.215    41.738     0.200
>
    15.156    41.710     0.200
>
    14.677    41.396     0.200
>
    14.548    41.309     0.200
>
    14.649    41.356     0.200
>
    14.306    41.468     0.200
>
    15.741    41.718     0.200
>
    15.785    41.743     0.200
>
    15.327    41.909     0.200
>
    15.298    41.853     0.200
>
    15.355    41.927     0.200
>
    15.396    41.796     0.200
>
    15.722    41.517     0.200
>
    14.897    41.697     0.200
>
    14.894    41.709     0.200
>
    14.940    41.709     0.200
>
    14.857    41.694     0.200
>
    14.933    41.721     0.200
>
    14.872    41.707     0.200
>
    14.877    41.705     0.200
>
    14.918    41.714     0.200
>
    14.913    41.692     0.200
>
    14.930    41.683     0.200
>
    14.862    41.690     0.200
>
    14.821    41.691     0.200
>
    14.829    41.691     0.200
>
    14.822    41.703     0.200
>
    14.841    41.726     0.200
>
    14.832    41.709     0.200
>
    14.842    41.720     0.200
>
    14.886    41.734     0.200
>
    14.838    41.693     0.200
>
    14.833    41.724     0.200
>
    14.807    41.697     0.200
>
    14.859    41.686     0.200
>
    14.866    41.718     0.200
>
    14.819    41.699     0.200
>
    14.841    41.686     0.200
>
    14.818    41.709     0.200
>
    14.895    41.691     0.200
>
    14.909    41.694     0.200
>
    14.822    41.707     0.200
>
    14.840    41.701     0.200
>
    14.862    41.707     0.200
>
    14.974    41.719     0.200
>
    14.838    41.679     0.200
>
    14.864    41.702     0.200
>
    14.865    41.683     0.200
>
    14.956    41.682     0.200
>
    14.816    41.681     0.200
>
    14.796    41.688     0.200
>
    14.802    41.689     0.200
>
    14.870    41.707     0.200
>
    14.763    41.694     0.200
>
    14.774    41.678     0.200
>
    14.847    41.690     0.200
>
    14.806    41.702     0.200
>
    14.808    41.694     0.200
>
    14.790    41.692     0.200
>
    14.781    41.718     0.200
>
    14.864    41.699     0.200
>
    14.835    41.692     0.200
>
    14.825    41.690     0.200
>
    15.650    41.810     0.200
>
    14.884    41.697     0.200
>
    15.329    42.024     0.200
>
    14.896    41.684     0.200
>
    15.932    41.860     0.200
>
    14.863    41.721     0.200
>
    14.491    40.988     0.200
>
    15.715    41.486     0.200
>
    15.503    41.911     0.200
>
    14.177    41.296     0.200
>
    14.818    41.691     0.200
>
    15.795    41.892     0.200
>
    15.618    41.511     0.200
>
    15.621    41.505     0.200
>
    14.852    41.675     0.200
>
    15.380    41.878     0.200
>
    15.532    41.905     0.200
>
    14.964    41.179     0.200
>
    14.948    41.171     0.200
>
    14.944    41.159     0.200
>
    14.825    41.674     0.200
>
    14.465    41.394     0.200
>
    14.465    41.387     0.200
>
    14.433    41.392     0.200
>
    14.423    41.392     0.200
>
    14.479    41.361     0.200
>
    14.474    41.370     0.200
>
    15.267    41.257     0.200
>
    14.971    41.704     0.200
>
    15.356    41.767     0.200
>
    15.358    41.784     0.200
>
    14.991    41.508     0.200
>
    14.644    41.538     0.200
>
    14.614    41.522     0.200
>
    14.633    41.539     0.200
>
    14.650    41.533     0.200
>
    14.636    41.543     0.200
>
    14.857    41.677     0.200
>
    14.637    41.539     0.200
>
    14.893    41.789     0.200
>
    14.993    41.494     0.200
>
    14.990    41.503     0.200
>
    15.767    41.860     0.200
>
    15.882    41.790     0.200
>
    14.909    41.258     0.200
>
    14.844    41.840     0.200
>
    14.842    41.855     0.200
>
    14.840    41.833     0.200
>
    14.817    41.843     0.200
>
    14.866    41.830     0.200
>
    14.872    41.832     0.200
>
    14.870    41.843     0.200
>
    14.849    41.878     0.200
>
    14.849    41.849     0.200
>
    14.862    41.836     0.200
>
    14.856    41.845     0.200
>
    14.739    41.067     0.200
>
    14.744    41.052     0.200
>
    14.725    41.056     0.200
>
    14.730    41.055     0.200
>
    15.113    40.888     0.200
>
    15.416    41.815     0.200
>
    14.681    41.375     0.200
>
    14.896    41.583     0.200
>
    15.059    41.942     0.200
>
    14.251    41.755     0.200
>
    14.679    41.659     0.200
>
    14.861    41.828     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
    14.986    41.553     0.000   222.000   222.000
    14.986    41.553     0.000   444.000   444.000
EOF
gmt end
