#!/bin/bash
gmt begin larino1.84_base pdf,ps
proj=-JM16.0c+
reg=-R14.1/16.0/40.7/42.1
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map larino1.84'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    15.056    41.125 1
    14.989    41.114 2
    15.337    41.871 3
    15.274    40.868 4
    15.416    40.838 5
    15.411    41.165 6
    15.384    40.838 7
    15.317    40.859 8
    15.050    40.879 9
    15.020    40.951 10
    15.283    40.966 11
    15.243    40.881 12
    15.351    40.945 13
    15.082    41.093 14
    15.392    40.797 15
    15.002    41.084 16
    15.351    40.887 17
    15.286    40.818 18
    15.271    40.781 19
    14.612    40.972 20
    14.344    41.631 21
    15.843    41.659 22
    14.330    41.610 23
    15.334    41.927 24
    14.666    41.145 25
    15.448    41.753 26
    14.215    41.657 27
    14.785    41.150 28
    14.659    41.521 29
    15.218    41.852 30
    15.430    41.579 31
    15.386    41.534 32
    15.857    41.789 33
    15.867    41.802 34
    15.737    41.683 35
    14.907    41.567 36
    14.473    41.327 37
    15.328    41.222 38
    15.215    41.738 39
    15.156    41.710 40
    14.677    41.396 41
    14.548    41.309 42
    14.649    41.356 43
    14.306    41.468 44
    15.741    41.718 45
    15.785    41.743 46
    15.327    41.909 47
    15.298    41.853 48
    15.355    41.927 49
    15.396    41.796 50
    15.722    41.517 51
    14.897    41.697 52
    14.894    41.709 53
    14.940    41.709 54
    14.857    41.694 55
    14.933    41.721 56
    14.872    41.707 57
    14.877    41.705 58
    14.918    41.714 59
    14.913    41.692 60
    14.930    41.683 61
    14.862    41.690 62
    14.821    41.691 63
    14.829    41.691 64
    14.822    41.703 65
    14.841    41.726 66
    14.832    41.709 67
    14.842    41.720 68
    14.886    41.734 69
    14.838    41.693 70
    14.833    41.724 71
    14.807    41.697 72
    14.859    41.686 73
    14.866    41.718 74
    14.819    41.699 75
    14.841    41.686 76
    14.818    41.709 77
    14.895    41.691 78
    14.909    41.694 79
    14.822    41.707 80
    14.840    41.701 81
    14.862    41.707 82
    14.974    41.719 83
    14.838    41.679 84
    14.864    41.702 85
    14.865    41.683 86
    14.956    41.682 87
    14.816    41.681 88
    14.796    41.688 89
    14.802    41.689 90
    14.870    41.707 91
    14.763    41.694 92
    14.774    41.678 93
    14.847    41.690 94
    14.806    41.702 95
    14.808    41.694 96
    14.790    41.692 97
    14.781    41.718 98
    14.864    41.699 99
    14.835    41.692 100
    14.825    41.690 101
    15.650    41.810 102
    14.884    41.697 103
    15.329    42.024 104
    14.896    41.684 105
    15.932    41.860 106
    14.863    41.721 107
    14.491    40.988 108
    15.715    41.486 109
    15.503    41.911 110
    14.177    41.296 111
    14.818    41.691 112
    15.795    41.892 113
    15.618    41.511 114
    15.621    41.505 115
    14.852    41.675 116
    15.380    41.878 117
    15.532    41.905 118
    14.964    41.179 119
    14.948    41.171 120
    14.944    41.159 121
    14.825    41.674 122
    14.465    41.394 123
    14.465    41.387 124
    14.433    41.392 125
    14.423    41.392 126
    14.479    41.361 127
    14.474    41.370 128
    15.267    41.257 129
    14.971    41.704 130
    15.356    41.767 131
    15.358    41.784 132
    14.991    41.508 133
    14.644    41.538 134
    14.614    41.522 135
    14.633    41.539 136
    14.650    41.533 137
    14.636    41.543 138
    14.857    41.677 139
    14.637    41.539 140
    14.893    41.789 141
    14.993    41.494 142
    14.990    41.503 143
    15.767    41.860 144
    15.882    41.790 145
    14.909    41.258 146
    14.844    41.840 147
    14.842    41.855 148
    14.840    41.833 149
    14.817    41.843 150
    14.866    41.830 151
    14.872    41.832 152
    14.870    41.843 153
    14.849    41.878 154
    14.849    41.849 155
    14.862    41.836 156
    14.856    41.845 157
    14.739    41.067 158
    14.744    41.052 159
    14.725    41.056 160
    14.730    41.055 161
    15.113    40.888 162
    15.416    41.815 163
    14.681    41.375 164
    14.896    41.583 165
    15.059    41.942 166
    14.251    41.755 167
    14.679    41.659 168
    14.861    41.828 169
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    15.036    41.129
    15.056    41.125
>
    14.925    41.158
    14.989    41.114
>
    15.360    41.840
    15.337    41.871
>
    15.226    41.069
    15.274    40.868
>
    15.327    40.884
    15.416    40.838
>
    15.533    41.150
    15.411    41.165
>
    15.258    40.915
    15.384    40.838
>
    15.293    40.990
    15.317    40.859
>
    14.969    41.000
    15.050    40.879
>
    14.923    41.000
    15.020    40.951
>
    15.267    40.931
    15.283    40.966
>
    15.066    40.922
    15.243    40.881
>
    15.340    40.963
    15.351    40.945
>
    15.086    41.169
    15.082    41.093
>
    15.121    40.849
    15.392    40.797
>
    15.003    41.104
    15.002    41.084
>
    15.240    40.936
    15.351    40.887
>
    15.412    40.943
    15.286    40.818
>
    15.266    40.950
    15.271    40.781
>
    14.553    40.992
    14.612    40.972
>
    14.285    41.641
    14.344    41.631
>
    15.802    41.737
    15.843    41.659
>
    14.270    41.570
    14.330    41.610
>
    15.321    42.008
    15.334    41.927
>
    14.640    41.120
    14.666    41.145
>
    15.461    41.735
    15.448    41.753
>
    14.174    41.645
    14.215    41.657
>
    14.721    41.195
    14.785    41.150
>
    14.623    41.508
    14.659    41.521
>
    15.120    41.943
    15.218    41.852
>
    15.403    41.705
    15.430    41.579
>
    15.386    41.607
    15.386    41.534
>
    15.805    41.801
    15.857    41.789
>
    15.699    41.873
    15.867    41.802
>
    15.587    41.689
    15.737    41.683
>
    14.822    41.443
    14.907    41.567
>
    14.505    41.355
    14.473    41.327
>
    15.297    41.224
    15.328    41.222
>
    15.126    41.772
    15.215    41.738
>
    15.159    41.669
    15.156    41.710
>
    14.642    41.419
    14.677    41.396
>
    14.592    41.355
    14.548    41.309
>
    14.648    41.391
    14.649    41.356
>
    14.290    41.493
    14.306    41.468
>
    15.603    41.883
    15.741    41.718
>
    15.634    41.758
    15.785    41.743
>
    15.315    41.965
    15.327    41.909
>
    15.268    41.875
    15.298    41.853
>
    15.307    41.927
    15.355    41.927
>
    15.327    41.860
    15.396    41.796
>
    15.691    41.565
    15.722    41.517
>
    14.933    41.705
    14.897    41.697
>
    14.875    41.718
    14.894    41.709
>
    14.884    41.747
    14.940    41.709
>
    14.837    41.744
    14.857    41.694
>
    14.891    41.736
    14.933    41.721
>
    14.894    41.690
    14.872    41.707
>
    14.849    41.770
    14.877    41.705
>
    14.892    41.759
    14.918    41.714
>
    14.879    41.687
    14.913    41.692
>
    14.929    41.713
    14.930    41.683
>
    14.843    41.763
    14.862    41.690
>
    14.835    41.779
    14.821    41.691
>
    14.821    41.779
    14.829    41.691
>
    14.830    41.716
    14.822    41.703
>
    14.770    41.762
    14.841    41.726
>
    14.814    41.719
    14.832    41.709
>
    14.848    41.750
    14.842    41.720
>
    14.848    41.659
    14.886    41.734
>
    14.816    41.689
    14.838    41.693
>
    14.863    41.740
    14.833    41.724
>
    14.771    41.772
    14.807    41.697
>
    14.873    41.674
    14.859    41.686
>
    14.793    41.766
    14.866    41.718
>
    14.804    41.700
    14.819    41.699
>
    14.840    41.703
    14.841    41.686
>
    14.802    41.725
    14.818    41.709
>
    14.835    41.765
    14.895    41.691
>
    14.901    41.752
    14.909    41.694
>
    14.791    41.757
    14.822    41.707
>
    14.816    41.753
    14.840    41.701
>
    14.864    41.724
    14.862    41.707
>
    14.911    41.757
    14.974    41.719
>
    14.833    41.682
    14.838    41.679
>
    14.822    41.707
    14.864    41.702
>
    14.873    41.664
    14.865    41.683
>
    14.959    41.650
    14.956    41.682
>
    14.774    41.727
    14.816    41.681
>
    14.790    41.659
    14.796    41.688
>
    14.817    41.715
    14.802    41.689
>
    14.837    41.702
    14.870    41.707
>
    14.788    41.658
    14.763    41.694
>
    14.745    41.671
    14.774    41.678
>
    14.775    41.743
    14.847    41.690
>
    14.773    41.743
    14.806    41.702
>
    14.766    41.711
    14.808    41.694
>
    14.754    41.657
    14.790    41.692
>
    14.795    41.657
    14.781    41.718
>
    14.847    41.691
    14.864    41.699
>
    14.793    41.731
    14.835    41.692
>
    14.756    41.727
    14.825    41.690
>
    15.657    41.859
    15.650    41.810
>
    14.825    41.786
    14.884    41.697
>
    15.316    42.096
    15.329    42.024
>
    14.839    41.680
    14.896    41.684
>
    15.805    41.758
    15.932    41.860
>
    14.867    41.666
    14.863    41.721
>
    14.440    40.993
    14.491    40.988
>
    15.699    41.467
    15.715    41.486
>
    15.483    41.917
    15.503    41.911
>
    14.190    41.270
    14.177    41.296
>
    14.795    41.714
    14.818    41.691
>
    15.703    41.911
    15.795    41.892
>
    15.558    41.523
    15.618    41.511
>
    15.577    41.509
    15.621    41.505
>
    14.823    41.664
    14.852    41.675
>
    15.296    41.893
    15.380    41.878
>
    15.545    41.942
    15.532    41.905
>
    14.897    41.179
    14.964    41.179
>
    14.870    41.149
    14.948    41.171
>
    14.878    41.145
    14.944    41.159
>
    14.781    41.659
    14.825    41.674
>
    14.427    41.417
    14.465    41.394
>
    14.432    41.395
    14.465    41.387
>
    14.416    41.416
    14.433    41.392
>
    14.412    41.402
    14.423    41.392
>
    14.430    41.373
    14.479    41.361
>
    14.451    41.372
    14.474    41.370
>
    15.267    41.257
    15.267    41.257
>
    14.940    41.720
    14.971    41.704
>
    15.320    41.781
    15.356    41.767
>
    15.337    41.774
    15.358    41.784
>
    14.958    41.491
    14.991    41.508
>
    14.624    41.557
    14.644    41.538
>
    14.587    41.525
    14.614    41.522
>
    14.574    41.527
    14.633    41.539
>
    14.642    41.527
    14.650    41.533
>
    14.613    41.556
    14.636    41.543
>
    14.835    41.693
    14.857    41.677
>
    14.622    41.550
    14.637    41.539
>
    14.834    41.787
    14.893    41.789
>
    14.996    41.501
    14.993    41.494
>
    14.964    41.521
    14.990    41.503
>
    15.710    41.883
    15.767    41.860
>
    15.773    41.845
    15.882    41.790
>
    14.883    41.286
    14.909    41.258
>
    14.838    41.870
    14.844    41.840
>
    14.830    41.870
    14.842    41.855
>
    14.805    41.858
    14.840    41.833
>
    14.788    41.861
    14.817    41.843
>
    14.834    41.860
    14.866    41.830
>
    14.767    41.725
    14.872    41.832
>
    14.870    41.860
    14.870    41.843
>
    14.820    41.876
    14.849    41.878
>
    14.829    41.822
    14.849    41.849
>
    14.848    41.859
    14.862    41.836
>
    14.849    41.850
    14.856    41.845
>
    14.748    41.090
    14.739    41.067
>
    14.740    41.084
    14.744    41.052
>
    14.774    41.076
    14.725    41.056
>
    14.727    41.071
    14.730    41.055
>
    15.117    40.882
    15.113    40.888
>
    15.390    41.819
    15.416    41.815
>
    14.656    41.375
    14.681    41.375
>
    14.899    41.591
    14.896    41.583
>
    15.068    41.936
    15.059    41.942
>
    14.257    41.762
    14.251    41.755
>
    14.678    41.665
    14.679    41.659
>
    14.861    41.856
    14.861    41.828
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    15.049    41.123
    15.056    41.125
>
    14.988    41.112
    14.989    41.114
>
    15.336    41.870
    15.337    41.871
>
    15.259    40.872
    15.274    40.868
>
    15.413    40.839
    15.416    40.838
>
    15.397    41.166
    15.411    41.165
>
    15.353    40.820
    15.384    40.838
>
    15.313    40.857
    15.317    40.859
>
    15.052    40.880
    15.050    40.879
>
    15.024    40.946
    15.020    40.951
>
    15.282    40.968
    15.283    40.966
>
    15.233    40.881
    15.243    40.881
>
    15.335    40.944
    15.351    40.945
>
    15.079    41.089
    15.082    41.093
>
    15.390    40.795
    15.392    40.797
>
    15.003    41.085
    15.002    41.084
>
    15.341    40.885
    15.351    40.887
>
    15.291    40.819
    15.286    40.818
>
    15.264    40.779
    15.271    40.781
>
    14.615    40.973
    14.612    40.972
>
    14.343    41.630
    14.344    41.631
>
    15.858    41.669
    15.843    41.659
>
    14.330    41.610
    14.330    41.610
>
    15.332    41.926
    15.334    41.927
>
    14.668    41.146
    14.666    41.145
>
    15.449    41.753
    15.448    41.753
>
    14.213    41.654
    14.215    41.657
>
    14.786    41.151
    14.785    41.150
>
    14.658    41.520
    14.659    41.521
>
    15.216    41.851
    15.218    41.852
>
    15.429    41.579
    15.430    41.579
>
    15.386    41.535
    15.386    41.534
>
    15.857    41.789
    15.857    41.789
>
    15.866    41.800
    15.867    41.802
>
    15.737    41.682
    15.737    41.683
>
    14.904    41.563
    14.907    41.567
>
    14.466    41.322
    14.473    41.327
>
    15.327    41.221
    15.328    41.222
>
    15.214    41.738
    15.215    41.738
>
    15.157    41.711
    15.156    41.710
>
    14.675    41.395
    14.677    41.396
>
    14.552    41.314
    14.548    41.309
>
    14.648    41.357
    14.649    41.356
>
    14.306    41.467
    14.306    41.468
>
    15.742    41.718
    15.741    41.718
>
    15.785    41.742
    15.785    41.743
>
    15.326    41.909
    15.327    41.909
>
    15.296    41.852
    15.298    41.853
>
    15.356    41.929
    15.355    41.927
>
    15.396    41.795
    15.396    41.796
>
    15.724    41.517
    15.722    41.517
>
    14.898    41.697
    14.897    41.697
>
    14.894    41.710
    14.894    41.709
>
    14.939    41.709
    14.940    41.709
>
    14.857    41.694
    14.857    41.694
>
    14.932    41.721
    14.933    41.721
>
    14.871    41.708
    14.872    41.707
>
    14.876    41.705
    14.877    41.705
>
    14.918    41.714
    14.918    41.714
>
    14.913    41.691
    14.913    41.692
>
    14.930    41.682
    14.930    41.683
>
    14.863    41.690
    14.862    41.690
>
    14.820    41.690
    14.821    41.691
>
    14.829    41.691
    14.829    41.691
>
    14.822    41.703
    14.822    41.703
>
    14.841    41.726
    14.841    41.726
>
    14.832    41.709
    14.832    41.709
>
    14.841    41.719
    14.842    41.720
>
    14.885    41.733
    14.886    41.734
>
    14.838    41.693
    14.838    41.693
>
    14.832    41.724
    14.833    41.724
>
    14.807    41.697
    14.807    41.697
>
    14.858    41.685
    14.859    41.686
>
    14.865    41.718
    14.866    41.718
>
    14.819    41.700
    14.819    41.699
>
    14.841    41.686
    14.841    41.686
>
    14.819    41.709
    14.818    41.709
>
    14.895    41.690
    14.895    41.691
>
    14.909    41.694
    14.909    41.694
>
    14.822    41.707
    14.822    41.707
>
    14.839    41.700
    14.840    41.701
>
    14.861    41.707
    14.862    41.707
>
    14.973    41.718
    14.974    41.719
>
    14.838    41.679
    14.838    41.679
>
    14.863    41.703
    14.864    41.702
>
    14.865    41.684
    14.865    41.683
>
    14.955    41.681
    14.956    41.682
>
    14.815    41.680
    14.816    41.681
>
    14.795    41.688
    14.796    41.688
>
    14.802    41.688
    14.802    41.689
>
    14.870    41.707
    14.870    41.707
>
    14.763    41.694
    14.763    41.694
>
    14.773    41.677
    14.774    41.678
>
    14.847    41.690
    14.847    41.690
>
    14.805    41.703
    14.806    41.702
>
    14.808    41.694
    14.808    41.694
>
    14.789    41.693
    14.790    41.692
>
    14.781    41.717
    14.781    41.718
>
    14.864    41.699
    14.864    41.699
>
    14.834    41.692
    14.835    41.692
>
    14.825    41.689
    14.825    41.690
>
    15.648    41.808
    15.650    41.810
>
    14.884    41.698
    14.884    41.697
>
    15.328    42.024
    15.329    42.024
>
    14.895    41.683
    14.896    41.684
>
    15.931    41.860
    15.932    41.860
>
    14.862    41.721
    14.863    41.721
>
    14.491    40.988
    14.491    40.988
>
    15.715    41.486
    15.715    41.486
>
    15.503    41.911
    15.503    41.911
>
    14.177    41.295
    14.177    41.296
>
    14.818    41.691
    14.818    41.691
>
    15.795    41.892
    15.795    41.892
>
    15.618    41.511
    15.618    41.511
>
    15.621    41.506
    15.621    41.505
>
    14.852    41.675
    14.852    41.675
>
    15.380    41.878
    15.380    41.878
>
    15.531    41.905
    15.532    41.905
>
    14.964    41.179
    14.964    41.179
>
    14.948    41.171
    14.948    41.171
>
    14.944    41.158
    14.944    41.159
>
    14.825    41.675
    14.825    41.674
>
    14.464    41.393
    14.465    41.394
>
    14.466    41.387
    14.465    41.387
>
    14.432    41.392
    14.433    41.392
>
    14.422    41.391
    14.423    41.392
>
    14.479    41.361
    14.479    41.361
>
    14.473    41.370
    14.474    41.370
>
    15.266    41.257
    15.267    41.257
>
    14.971    41.704
    14.971    41.704
>
    15.356    41.767
    15.356    41.767
>
    15.358    41.783
    15.358    41.784
>
    14.991    41.508
    14.991    41.508
>
    14.644    41.538
    14.644    41.538
>
    14.614    41.522
    14.614    41.522
>
    14.634    41.538
    14.633    41.539
>
    14.651    41.533
    14.650    41.533
>
    14.636    41.543
    14.636    41.543
>
    14.856    41.677
    14.857    41.677
>
    14.637    41.539
    14.637    41.539
>
    14.893    41.789
    14.893    41.789
>
    14.992    41.494
    14.993    41.494
>
    14.990    41.503
    14.990    41.503
>
    15.767    41.860
    15.767    41.860
>
    15.882    41.789
    15.882    41.790
>
    14.909    41.258
    14.909    41.258
>
    14.844    41.840
    14.844    41.840
>
    14.842    41.855
    14.842    41.855
>
    14.840    41.833
    14.840    41.833
>
    14.817    41.843
    14.817    41.843
>
    14.866    41.830
    14.866    41.830
>
    14.871    41.832
    14.872    41.832
>
    14.870    41.843
    14.870    41.843
>
    14.849    41.878
    14.849    41.878
>
    14.848    41.849
    14.849    41.849
>
    14.862    41.836
    14.862    41.836
>
    14.856    41.845
    14.856    41.845
>
    14.739    41.067
    14.739    41.067
>
    14.744    41.053
    14.744    41.052
>
    14.726    41.056
    14.725    41.056
>
    14.730    41.055
    14.730    41.055
>
    15.113    40.888
    15.113    40.888
>
    15.415    41.815
    15.416    41.815
>
    14.681    41.375
    14.681    41.375
>
    14.896    41.583
    14.896    41.583
>
    15.059    41.942
    15.059    41.942
>
    14.250    41.755
    14.251    41.755
>
    14.679    41.658
    14.679    41.659
>
    14.861    41.828
    14.861    41.828
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    15.056    41.125     6.074     1.833     4.921
    14.989    41.114   -10.525     1.878     4.507
    15.337    41.871     4.070     3.013     4.327
    15.274    40.868   -71.772     2.726     7.889
    15.416    40.838   -67.556     2.889     6.197
    15.411    41.165    12.280     0.541     5.051
    15.384    40.838   -73.641     2.371     4.186
    15.317    40.859   -58.427     4.505     7.780
    15.050    40.879   -70.251     3.536     6.113
    15.020    40.951    80.205     3.354     4.284
    15.283    40.966   -46.771     4.368     7.357
    15.243    40.881   -79.401     3.377     4.234
    15.351    40.945   -18.120     2.841     4.446
    15.082    41.093   -51.950     2.939     5.277
    15.392    40.797   -35.671     2.026     2.687
    15.002    41.084   -75.874     2.848     6.144
    15.351    40.887   -71.329     2.544     3.239
    15.286    40.818   -60.156     2.382     3.222
    15.271    40.781   -87.618     3.529     4.380
    14.612    40.972   -57.681     2.544     4.526
    14.344    41.631   -46.692     1.579     3.437
    15.843    41.659   -64.122     1.703     3.280
    14.330    41.610   -14.354     2.498     3.892
    15.334    41.927   -55.093     2.011     3.995
    14.666    41.145   -47.309     3.237     4.677
    15.448    41.753   -57.952     2.375     3.753
    14.215    41.657   -44.117     3.065     5.201
    14.785    41.150   -34.847     2.452     5.172
    14.659    41.521   -51.243     2.519     4.825
    15.218    41.852   -58.537     1.469     2.789
    15.430    41.579   -40.336     2.291     3.883
    15.386    41.534   -36.216     3.154     6.067
    15.857    41.789   -45.709     2.154     3.586
    15.867    41.802   -51.908     3.159     5.786
    15.737    41.683   -53.870     1.566     3.168
    14.907    41.567   -55.239     2.595     5.321
    14.473    41.327   -56.461     2.527     5.182
    15.328    41.222   -35.636     2.491     4.090
    15.215    41.738   -44.827     1.136     1.834
    15.156    41.710   -48.036     2.159     4.112
    14.677    41.396   -52.535     1.671     3.439
    14.548    41.309   -47.587     3.103     7.476
    14.649    41.356   -57.151     2.197     5.023
    14.306    41.468   -55.401     3.754     6.892
    15.741    41.718   -44.308     1.159     1.982
    15.785    41.743   -60.173     1.750     3.235
    15.327    41.909    21.269     1.749     2.349
    15.298    41.853    40.601     2.094     3.200
    15.355    41.927   -67.497     2.131     2.692
    15.396    41.796   -33.236     1.304     1.650
    15.722    41.517   -73.054     2.205     2.559
    14.897    41.697   -58.444     2.199     2.869
    14.894    41.709   -55.865     0.869     1.149
    14.940    41.709   -53.390     1.383     1.951
    14.857    41.694   -53.940     1.375     1.820
    14.933    41.721   -54.741     1.258     1.888
    14.872    41.707   -39.529     2.634     4.935
    14.877    41.705   -59.410     1.548     2.223
    14.918    41.714   -66.150     1.488     2.098
    14.913    41.692   -66.545     2.102     2.741
    14.930    41.683   -39.468     2.181     2.936
    14.862    41.690   -55.834     0.812     1.190
    14.821    41.691   -53.695     1.124     1.707
    14.829    41.691   -54.701     1.845     2.809
    14.822    41.703   -55.895     2.412     3.958
    14.841    41.726   -27.927     1.427     2.547
    14.832    41.709   -55.679     1.976     2.617
    14.842    41.720   -56.981     0.953     1.459
    14.886    41.734   -47.586     2.315     3.023
    14.838    41.693   -27.537     1.762     3.424
    14.833    41.724   -40.312     1.965     3.127
    14.807    41.697   -59.406     1.322     2.005
    14.859    41.686   -33.781     1.586     3.351
    14.866    41.718   -56.856     1.641     2.344
    14.819    41.699   -70.669     1.900     2.362
    14.841    41.686   -57.726     2.432     3.901
    14.818    41.709   -43.447     1.994     2.638
    14.895    41.691   -64.169     1.373     1.966
    14.909    41.694   -65.238     1.516     1.904
    14.822    41.707   -59.441     1.024     1.603
    14.840    41.701   -42.750     1.524     1.897
    14.862    41.707   -69.597     1.722     2.307
    14.974    41.719   -65.732     1.593     2.253
    14.838    41.679   -58.144     1.962     2.335
    14.864    41.702   -29.074     2.187     2.571
    14.865    41.683   -31.057     1.973     2.248
    14.956    41.682    39.901     2.227     2.476
    14.816    41.681   -39.929     1.121     1.257
    14.796    41.688   -15.870     1.782     2.000
    14.802    41.689   -48.417     1.651     1.994
    14.870    41.707   -41.972     1.775     1.925
    14.763    41.694    -9.003     2.065     2.830
    14.774    41.678    18.224     2.119     2.438
    14.847    41.690   -43.222     1.220     1.789
    14.806    41.702   -61.405     2.147     3.042
    14.808    41.694   -73.835     2.023     2.645
    14.790    41.692   -42.877     1.783     2.526
    14.781    41.718   -76.997     3.496     6.019
    14.864    41.699   -50.691     1.927     2.425
    14.835    41.692   -42.625     1.275     2.015
    14.825    41.690   -50.954     0.971     1.475
    15.650    41.810   -58.508     2.151     2.610
    14.884    41.697   -51.433     1.241     1.623
    15.329    42.024   -28.481     2.640     4.681
    14.896    41.684    47.198     1.176     1.757
    15.932    41.860   -27.516     1.699     1.733
    14.863    41.721   -30.859     2.728     3.546
    14.491    40.988   -48.979     1.978     3.432
    15.715    41.486   -59.519     1.312     2.439
    15.503    41.911    66.127     0.954     1.165
    14.177    41.296   -49.352     1.880     3.169
    14.818    41.691   -81.416     1.055     1.185
    15.795    41.892   -89.748     1.225     1.476
    15.618    41.511   -49.530     1.015     1.332
    15.621    41.505   -75.385     1.282     1.983
    14.852    41.675    73.521     1.120     1.286
    15.380    41.878    74.305     0.909     1.349
    15.532    41.905    79.233     1.167     1.308
    14.964    41.179   -57.395     0.827     1.270
    14.948    41.171   -63.779     1.133     1.736
    14.944    41.159   -62.603     1.253     2.085
    14.825    41.674    69.835     0.972     1.107
    14.465    41.394   -61.754     0.855     1.106
    14.465    41.387   -57.814     1.195     1.534
    14.433    41.392   -62.629     1.336     1.558
    14.423    41.392   -78.176     1.414     1.569
    14.479    41.361   -57.884     1.039     1.375
    14.474    41.370   -61.142     1.266     1.702
    15.267    41.257   -44.842     1.565     2.622
    14.971    41.704    16.434     0.746     0.809
    15.356    41.767    65.000     0.775     1.109
    15.358    41.784    -5.845     1.648     2.181
    14.991    41.508    87.413     1.221     1.703
    14.644    41.538   -26.829     0.856     0.914
    14.614    41.522   -19.431     1.257     1.405
    14.633    41.539    -8.265     1.130     1.239
    14.650    41.533    17.038     1.313     1.425
    14.636    41.543   -28.673     0.889     1.025
    14.857    41.677   -63.484     0.929     0.943
    14.637    41.539    19.031     1.024     1.156
    14.893    41.789    30.240     1.032     1.153
    14.993    41.494    87.935     1.077     1.215
    14.990    41.503    72.853     1.049     1.179
    15.767    41.860    26.477     0.925     0.959
    15.882    41.790     2.605     1.018     1.083
    14.909    41.258   -36.012     1.102     1.137
    14.844    41.840   -16.318     0.814     0.883
    14.842    41.855    12.014     0.587     0.686
    14.840    41.833    10.409     0.650     0.716
    14.817    41.843    73.067     0.828     0.873
    14.866    41.830     0.892     0.746     0.788
    14.872    41.832   -61.561     1.761     1.848
    14.870    41.843    77.622     1.046     1.278
    14.849    41.878   -23.944     1.227     1.532
    14.849    41.849   -78.028     1.102     1.197
    14.862    41.836   -46.641     1.027     1.077
    14.856    41.845    47.090     1.258     1.317
    14.739    41.067   -57.958     0.918     1.237
    14.744    41.052    89.824     1.481     1.865
    14.725    41.056   -66.523     0.834     1.049
    14.730    41.055   -59.999     0.871     1.251
    15.113    40.888    89.311     1.714     1.858
    15.416    41.815    37.239     0.846     1.013
    14.681    41.375   -64.898     0.888     1.017
    14.896    41.583    75.832     0.723     0.843
    15.059    41.942   -56.622     1.365     1.949
    14.251    41.755   -80.861     1.065     1.271
    14.679    41.659   -22.437     0.646     0.721
    14.861    41.828   -33.530     0.770     0.872
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    14.148    40.733    37.094     0.812     0.966
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    14.170    40.733   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    14.148    40.733     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    14.148    40.733     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    14.148    40.688   5 km
EOF
gmt end
