#!/bin/bash
gmt begin kunar4.14_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases kunar4.14'
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -105.000 Indirect calibration: shifted hypocenters used
EOF
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.500     6.088
     2.000     2.210
     2.500    -1.668
     3.000    -5.546
     3.500    -9.426
     4.000   -13.306
     4.500   -17.187
     5.000   -21.070
     5.500   -24.956
     6.000   -28.842
     6.500   -32.731
     7.000   -36.623
     7.500   -40.517
     8.000   -44.413
     8.500   -48.314
     9.000   -52.217
     9.500   -56.123
    10.000   -60.035
    10.500   -63.950
    11.000   -67.868
    11.500   -71.792
    12.000   -75.720
    12.500   -79.653
    13.000   -83.591
    13.500   -87.535
    14.000   -91.484
    14.500   -95.439
    15.000   -99.400
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -80.591 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.922
     1.000     1.572
     1.500     0.500
     2.000    -0.572
     2.500    -1.644
     3.000    -2.716
     3.500    -3.791
     4.000    -4.868
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -7.868 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.627    -1.174     0.200
     5.751    -1.191     0.200
     2.817    -0.236     0.200
     8.132     3.261     0.200
     4.282    -0.815     0.200
     2.930    -0.048     0.200
     3.241     2.115     0.200
     5.670     8.099     0.200
     3.422     4.903     0.200
     2.982     1.299     0.200
     2.993    -0.385     0.200
     3.013     1.405     0.200
     2.956     1.521     0.200
     3.284     2.099     0.200
     3.842    -0.587     0.200
     6.558    -5.666     0.200
     2.980    -0.960     0.200
     2.967     1.035     0.200
     3.221     6.695     0.200
     8.280     5.636     0.200
     2.929    -2.923     0.200
     3.022    -1.538     0.200
     3.532    -2.705     0.200
     2.756     0.278     0.200
     2.626    -0.397     0.200
     5.740    -5.525     0.200
     3.649    -1.011     0.200
     3.875    -1.374     0.200
     5.354    -5.256     0.200
     3.629    -1.507     0.200
     8.957     1.589     0.200
     8.962     1.543     0.200
     4.505    -3.758     0.200
     4.546     1.238     0.200
     4.215     1.704     0.200
     9.059   -29.913     0.200
     8.676     0.304     0.200
    10.507    10.013     0.200
    15.158    10.032     0.200
    17.115     9.404     0.200
     3.988    -1.607     0.200
     8.428   -55.038     0.200
     8.589    -1.615     0.200
    15.060   -12.058     0.200
    17.031   -10.698     0.200
     4.211     0.162     0.200
     4.673     0.538     0.200
     5.593    -2.765     0.200
     5.941    -6.010     0.200
     8.450    -0.851     0.200
    14.893    -2.487     0.200
    16.896    -1.700     0.200
    18.273     4.615     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.341   -19.505     0.200
     4.197   -11.938     0.200
     5.523   -22.958     0.200
     5.801   -26.772     0.200
     5.957   -21.714     0.200
     6.110   -30.570     0.200
     6.568   -32.083     0.200
     6.574   -33.283     0.200
     7.488   -43.255     0.200
     7.503   -38.717     0.200
     7.628   -43.701     0.200
     8.420   -45.802     0.200
     8.532   -45.332     0.200
     9.790   -67.222     0.200
     9.646   -53.675     0.200
    17.725  -126.762     0.200
     4.285   -14.780     0.200
     6.146   -22.772     0.200
     8.132   -50.739     0.200
     8.627   -50.416     0.200
    12.400   -77.019     0.200
    18.577  -138.841     0.200
    20.229  -135.219     0.200
    22.150  -155.092     0.200
     5.694   -24.571     0.200
     5.831   -23.440     0.200
     6.120   -27.087     0.200
     7.475   -40.359     0.200
     7.802   -36.419     0.200
     8.084   -49.861     0.200
    18.555  -136.465     0.200
     4.075   -10.539     0.200
     6.246   -28.467     0.200
     7.790   -42.115     0.200
     8.338   -53.460     0.200
     3.125    -4.018     0.200
     4.055   -14.094     0.200
     5.743   -24.299     0.200
     6.518   -33.656     0.200
     7.505   -36.165     0.200
     8.122   -50.509     0.200
     8.310   -44.474     0.200
     9.589   -58.017     0.200
    12.555   -82.550     0.200
    14.077   -97.971     0.200
    14.077   -83.971     0.200
     4.267   -13.879     0.200
     5.868   -22.614     0.200
     8.144   -53.078     0.200
     8.885   -53.255     0.200
    10.145   -59.398     0.200
    10.132   -58.999     0.200
     4.168   -13.388     0.200
     4.170   -18.348     0.200
     4.281   -10.884     0.200
     4.281   -10.884     0.200
     4.377   -17.624     0.200
     5.336   -24.330     0.200
     5.770   -23.893     0.200
     6.303   -24.295     0.200
     7.690   -43.350     0.200
     8.072   -45.049     0.200
     8.812   -47.525     0.200
     9.993   -50.155     0.200
    10.071   -58.630     0.200
    10.084   -59.027     0.200
    11.346   -77.942     0.200
    15.794  -109.640     0.200
    18.583  -131.249     0.200
    19.278  -139.301     0.200
    19.719  -128.251     0.200
    19.756  -131.439     0.200
    19.867  -132.348     0.200
    21.362  -145.749     0.200
    21.401  -146.977     0.200
     4.030    -9.432     0.200
     5.311   -28.541     0.200
     5.746   -23.735     0.200
     6.594   -33.218     0.200
     7.732   -45.507     0.200
     8.095   -47.792     0.200
     8.270   -55.358     0.200
     8.827   -50.005     0.200
     9.102   -53.726     0.200
    10.014   -51.635     0.200
    10.035   -59.313     0.200
    10.093   -62.136     0.200
    10.306   -62.884     0.200
    10.306   -55.884     0.200
    10.490   -58.727     0.200
    14.312   -92.187     0.200
    17.333  -116.940     0.200
    17.564  -122.960     0.200
    18.185  -133.152     0.200
    18.605  -136.980     0.200
    21.357  -139.207     0.200
    21.637  -149.084     0.200
     3.869   -10.445     0.200
     4.144   -11.741     0.200
     4.149   -13.895     0.200
     4.246   -12.197     0.200
     5.730   -25.333     0.200
     6.329   -24.916     0.200
     8.299   -53.966     0.200
     8.849   -46.192     0.200
    18.619  -124.912     0.200
     3.946   -10.092     0.200
     4.097   -12.174     0.200
     4.123    -9.499     0.200
     4.233   -10.277     0.200
     5.376   -22.411     0.200
     5.722   -26.662     0.200
     6.275   -26.399     0.200
     6.558   -28.666     0.200
     8.284   -52.187     0.200
     8.789   -47.997     0.200
     9.108   -50.507     0.200
    10.490   -57.836     0.200
    14.322   -89.181     0.200
    18.631  -124.387     0.200
     4.117   -12.529     0.200
     4.141   -13.894     0.200
     4.141    -8.963     0.200
     4.249   -12.688     0.200
     4.486   -23.221     0.200
     5.324   -23.267     0.200
     5.395   -30.431     0.200
     5.736   -23.332     0.200
     6.298   -23.565     0.200
     8.081   -44.883     0.200
     8.813   -50.883     0.200
     9.102   -56.053     0.200
    10.488   -63.992     0.200
    12.170   -80.283     0.200
    16.191  -105.748     0.200
    19.820  -128.792     0.200
     3.852    -7.502     0.200
     3.862   -10.032     0.200
     4.180   -17.908     0.200
     3.956    -7.709     0.200
     4.009   -10.893     0.200
     4.132   -12.196     0.200
     4.132    -8.890     0.200
     4.241    -9.846     0.200
     6.569   -25.137     0.200
     8.069   -39.882     0.200
     8.280   -50.364     0.200
     8.801   -44.485     0.200
     9.716   -60.292     0.200
    11.370   -66.925     0.200
    15.049  -104.462     0.200
    17.253  -123.833     0.200
    18.623  -137.743     0.200
    23.257  -167.150     0.200
     3.277    -7.640     0.200
     3.638   -11.106     0.200
     3.843   -10.187     0.200
     3.838   -12.416     0.200
     4.150   -14.811     0.200
     3.999   -13.621     0.200
     4.119   -15.849     0.200
     4.123   -12.464     0.200
     4.609   -16.863     0.200
     5.370   -26.005     0.200
     6.370   -30.800     0.200
     7.710   -52.184     0.200
     8.264   -53.738     0.200
     8.760   -52.469     0.200
    10.021   -57.742     0.200
    10.524   -61.776     0.200
    16.126  -110.473     0.200
    17.601  -121.709     0.200
    18.627  -136.228     0.200
    18.627  -130.728     0.200
     2.333    -1.670     0.200
     5.215   -26.052     0.200
     7.503   -46.075     0.200
     8.021   -51.508     0.200
     9.288   -58.161     0.200
     9.490   -59.257     0.200
    17.012  -124.022     0.200
     2.516     0.198     0.200
     6.510   -31.435     0.200
     7.727   -42.716     0.200
     8.283   -51.334     0.200
     6.473   -31.802     0.200
     8.740   -49.973     0.200
    16.069  -109.308     0.200
     8.079   -50.022     0.200
     9.548   -44.591     0.200
    15.663   -99.427     0.200
    18.607  -137.767     0.200
     8.245   -52.719     0.200
     9.250   -59.591     0.200
    11.507   -83.116     0.200
    23.396  -168.418     0.200
     8.319   -54.595     0.200
     2.268    -0.951     0.200
     8.135   -52.444     0.200
    18.622  -129.863     0.200
     2.270     1.600     0.200
     8.121   -49.659     0.200
     2.344     6.978     0.200
     2.337     0.608     0.200
     3.271    -9.014     0.200
     6.259   -31.233     0.200
     8.186   -49.816     0.200
     9.954   -62.293     0.200
    18.647  -124.418     0.200
     2.368    -4.666     0.200
     6.688   -32.605     0.200
     8.046   -53.163     0.200
     2.327    -0.853     0.200
     3.083    -8.840     0.200
     6.556   -30.731     0.200
     8.864   -47.085     0.200
     9.311   -43.247     0.200
     2.354    -1.693     0.200
     3.973   -13.203     0.200
     4.927   -26.036     0.200
     5.440   -34.007     0.200
     6.092   -32.979     0.200
     6.426   -34.461     0.200
     8.012   -52.236     0.200
     8.253   -46.584     0.200
    11.090   -73.177     0.200
    12.596   -85.906     0.200
     4.268   -19.839     0.200
     5.010   -20.762     0.200
     5.151   -24.451     0.200
     5.222   -26.389     0.200
     6.038   -34.962     0.200
     6.394   -35.734     0.200
     6.733   -38.980     0.200
     6.653   -32.854     0.200
     7.817   -45.858     0.200
     8.343   -54.538     0.200
     8.587   -55.757     0.200
     8.932   -56.539     0.200
     8.856   -53.298     0.200
     9.800   -60.218     0.200
    11.344   -79.706     0.200
    11.344   -74.558     0.200
    12.930   -88.903     0.200
    13.059   -92.218     0.200
    18.651  -138.781     0.200
     2.245     0.511     0.200
     2.238    -0.427     0.200
     4.848   -27.166     0.200
     5.687   -28.788     0.200
     6.376   -31.622     0.200
     8.065   -51.967     0.200
     8.800   -54.511     0.200
     8.650   -47.196     0.200
     9.430   -50.417     0.200
    11.436   -78.770     0.200
    12.760   -89.265     0.200
    18.517  -125.486     0.200
    19.130  -130.932     0.200
    19.498  -134.916     0.200
     2.217     0.466     0.200
     4.828   -20.979     0.200
     6.008   -32.499     0.200
     6.356   -30.047     0.200
     8.048   -50.659     0.200
     8.308   -51.006     0.200
    11.433   -80.785     0.200
    11.433   -69.924     0.200
    11.433   -69.455     0.200
    12.746   -88.801     0.200
    17.548  -119.806     0.200
    18.504  -137.134     0.200
     6.343   -33.744     0.200
     8.047   -50.746     0.200
     8.309   -57.465     0.200
    15.831  -100.527     0.200
     3.872   -11.757     0.200
     4.999   -19.495     0.200
     5.606   -31.329     0.200
     6.949   -44.118     0.200
     7.108   -42.999     0.200
     7.515   -46.183     0.200
     7.847   -49.761     0.200
     8.957   -51.715     0.200
     9.348   -61.466     0.200
     9.241   -49.955     0.200
    12.395   -84.587     0.200
    12.395   -81.400     0.200
    12.395   -81.142     0.200
    12.837   -87.937     0.200
    13.497   -93.673     0.200
    14.096  -100.845     0.200
    14.305  -101.186     0.200
    14.859  -104.858     0.200
    17.982  -119.131     0.200
    18.112  -130.675     0.200
    18.792  -137.003     0.200
    19.038  -132.691     0.200
     8.962   -50.636     0.200
    14.877  -105.613     0.200
     3.151    -7.983     0.200
     4.818   -17.919     0.200
     7.145   -37.444     0.200
     7.851   -48.784     0.200
     8.148   -51.885     0.200
     8.146   -49.166     0.200
     8.243   -50.632     0.200
     8.393   -52.983     0.200
     8.393   -46.492     0.200
     8.393   -46.313     0.200
     8.758   -53.716     0.200
     8.696   -45.744     0.200
     9.606   -59.891     0.200
     9.682   -57.723     0.200
     9.661   -59.988     0.200
    12.749   -85.854     0.200
    16.230  -109.587     0.200
    18.477  -133.318     0.200
    18.513  -122.585     0.200
     6.129   -38.532     0.200
     6.467   -40.204     0.200
     7.074   -40.066     0.200
     7.790   -53.415     0.200
     8.082   -53.844     0.200
     8.178   -54.490     0.200
     8.328   -54.854     0.200
     8.611   -49.611     0.200
     8.611   -49.709     0.200
     8.699   -50.637     0.200
     8.914   -56.214     0.200
    12.694   -93.094     0.200
    16.196  -111.764     0.200
    16.732  -116.561     0.200
    16.732  -120.925     0.200
    18.426  -127.732     0.200
    18.500  -131.074     0.200
    18.540  -127.399     0.200
     5.588   -24.977     0.200
     6.805   -41.616     0.200
     7.841   -49.210     0.200
     8.029   -50.254     0.200
     8.192   -44.728     0.200
     8.302   -53.385     0.200
     8.249   -46.452     0.200
     8.249   -46.523     0.200
     8.359   -52.637     0.200
     8.406   -42.224     0.200
     8.873   -55.508     0.200
    12.763   -87.020     0.200
    12.802   -85.793     0.200
    13.377   -92.097     0.200
    13.942   -95.588     0.200
    13.968   -96.122     0.200
    14.185   -98.397     0.200
    14.347   -98.926     0.200
    14.713  -102.542     0.200
    16.595  -115.723     0.200
    18.279  -128.961     0.200
    18.279  -128.961     0.200
    18.279  -125.766     0.200
    18.583  -131.810     0.200
     3.525    -8.411     0.200
     5.855   -30.269     0.200
     7.872   -43.098     0.200
     8.008   -45.831     0.200
     8.429   -50.267     0.200
    16.476  -119.259     0.200
    18.167  -129.728     0.200
     7.000   -43.655     0.200
     7.759   -41.418     0.200
     7.867   -48.825     0.200
     8.112   -49.197     0.200
     8.141   -51.056     0.200
     8.283   -46.732     0.200
     8.371   -53.304     0.200
     8.395   -45.432     0.200
    16.608  -115.341     0.200
    18.286  -125.570     0.200
     4.671   -21.861     0.200
     6.245   -35.570     0.200
     6.854   -40.024     0.200
     7.870   -51.034     0.200
     8.112   -54.777     0.200
     8.734   -52.358     0.200
    16.920  -119.208     0.200
     2.766    -7.220     0.200
     4.348   -18.820     0.200
     4.765   -17.048     0.200
     5.093   -22.440     0.200
     5.620   -27.048     0.200
     6.067   -28.098     0.200
     6.768   -37.482     0.200
     7.142   -44.084     0.200
     8.254   -53.632     0.200
     8.672   -51.901     0.200
     8.900   -50.101     0.200
     8.900   -53.397     0.200
     8.950   -53.704     0.200
     9.129   -51.471     0.200
     9.129   -56.791     0.200
     9.344   -55.200     0.200
    16.745  -110.785     0.200
    18.468  -128.006     0.200
    18.821  -124.914     0.200
    18.854  -128.931     0.200
    19.604  -129.814     0.200
     2.753    -6.058     0.200
     4.331   -19.303     0.200
     4.745   -15.424     0.200
     5.076   -21.921     0.200
     5.603   -27.788     0.200
     6.047   -26.892     0.200
     6.428   -34.272     0.200
     6.748   -36.642     0.200
     7.813   -46.041     0.200
     8.929   -50.365     0.200
     8.976   -53.035     0.200
     9.154   -51.873     0.200
     9.154   -52.810     0.200
     9.369   -53.000     0.200
     9.818   -60.625     0.200
    16.758  -108.615     0.200
    16.821  -111.345     0.200
    18.883  -125.486     0.200
     0.829     5.046     0.200
     4.735   -26.704     0.200
     5.274   -30.639     0.200
     5.961   -37.471     0.200
     7.055   -46.305     0.200
     7.672   -56.873     0.200
     8.509   -54.467     0.200
    12.418   -96.135     0.200
     4.365   -19.329     0.200
     5.636   -27.553     0.200
     6.076   -31.483     0.200
     6.778   -36.356     0.200
     7.201   -46.955     0.200
     7.841   -45.366     0.200
     8.951   -50.753     0.200
     8.951   -50.905     0.200
     9.008   -51.518     0.200
     9.187   -51.808     0.200
     9.403   -47.540     0.200
     9.802   -57.462     0.200
     9.847   -68.121     0.200
     9.920   -60.333     0.200
    16.802  -112.100     0.200
    16.823  -116.472     0.200
    16.823  -116.396     0.200
    18.480  -126.011     0.200
    18.581  -122.892     0.200
    19.603  -129.578     0.200
     4.441   -17.463     0.200
     5.412   -25.982     0.200
     5.915   -29.895     0.200
     6.610   -37.562     0.200
     6.646   -43.165     0.200
     7.693   -46.024     0.200
     8.089   -44.790     0.200
     8.220   -52.866     0.200
     8.510   -50.746     0.200
     8.542   -49.870     0.200
     8.542   -50.739     0.200
     8.676   -50.219     0.200
     8.676   -48.971     0.200
     8.821   -54.936     0.200
     8.892   -47.667     0.200
     9.754   -60.103     0.200
    10.036   -58.450     0.200
    10.306   -62.062     0.200
    10.507   -62.254     0.200
    11.238   -66.507     0.200
    11.450   -79.259     0.200
    13.757   -88.309     0.200
    15.356  -112.151     0.200
    16.247  -107.346     0.200
    16.617  -117.014     0.200
    16.617  -119.328     0.200
    18.287  -128.236     0.200
    18.287  -125.234     0.200
    18.470  -125.550     0.200
    18.538  -123.501     0.200
     4.470   -18.412     0.200
     6.597   -37.876     0.200
     6.597   -37.676     0.200
     7.897   -53.391     0.200
     8.121   -46.304     0.200
     8.201   -53.531     0.200
     8.542   -52.732     0.200
     8.574   -52.342     0.200
     8.574   -51.824     0.200
     8.707   -49.960     0.200
     8.707   -52.312     0.200
    16.644  -117.142     0.200
    16.644  -118.842     0.200
    18.314  -129.836     0.200
    18.314  -131.366     0.200
     4.411   -17.493     0.200
     5.512   -32.276     0.200
     6.369   -37.756     0.200
     6.705   -40.235     0.200
     6.716   -46.770     0.200
     8.110   -45.231     0.200
     8.300   -53.963     0.200
     8.543   -49.724     0.200
     8.543   -46.183     0.200
     8.714   -48.765     0.200
     8.714   -47.908     0.200
     8.930   -45.939     0.200
     9.322   -56.200     0.200
    12.871   -90.875     0.200
    16.571  -112.748     0.200
    18.239  -129.713     0.200
     4.602   -19.197     0.200
     5.119   -23.967     0.200
     6.238   -40.556     0.200
     6.352   -35.606     0.200
     7.432   -43.685     0.200
     8.192   -45.325     0.200
     8.325   -59.187     0.200
     8.360   -50.686     0.200
     8.362   -45.924     0.200
     8.940   -54.230     0.200
    10.822   -67.087     0.200
    14.778   -97.287     0.200
    18.303  -135.479     0.200
     4.943   -23.763     0.200
     5.464   -26.522     0.200
     6.510   -42.724     0.200
     6.677   -37.129     0.200
     7.429   -38.847     0.200
     7.766   -46.341     0.200
     8.194   -43.886     0.200
     8.194   -43.775     0.200
     8.322   -52.873     0.200
     8.378   -48.008     0.200
     8.572   -55.896     0.200
     8.516   -48.243     0.200
     9.121   -50.763     0.200
    10.461   -61.456     0.200
    12.950   -88.447     0.200
    16.474  -117.963     0.200
    18.146  -127.330     0.200
    18.146  -128.743     0.200
     4.229   -25.514     0.200
     5.495   -29.354     0.200
     5.995   -30.902     0.200
     6.689   -43.483     0.200
     8.283   -56.441     0.200
     8.292   -57.295     0.200
     8.528   -49.435     0.200
     8.692   -50.592     0.200
     9.298   -51.237     0.200
    18.236  -128.515     0.200
    18.236  -129.547     0.200
     6.748   -44.854     0.200
     7.831   -53.077     0.200
     8.480   -47.299     0.200
     8.660   -48.460     0.200
     8.660   -45.304     0.200
     9.270   -50.519     0.200
    12.933   -94.182     0.200
    16.508  -116.304     0.200
    18.176  -128.189     0.200
     4.718   -20.399     0.200
     5.747   -30.560     0.200
     8.068   -53.894     0.200
     7.997   -44.934     0.200
     8.600   -49.738     0.200
     8.676   -50.579     0.200
     9.265   -51.697     0.200
    11.303   -76.979     0.200
    18.409  -125.596     0.200
     5.169   -21.098     0.200
     6.178   -30.396     0.200
     6.876   -38.258     0.200
     6.866   -46.390     0.200
     7.606   -40.247     0.200
     8.109   -42.150     0.200
     8.409   -53.304     0.200
     8.437   -49.665     0.200
     8.569   -45.223     0.200
     8.808   -48.967     0.200
     9.427   -53.700     0.200
    10.226   -55.662     0.200
    11.639   -78.648     0.200
    12.960   -89.324     0.200
    18.169  -125.029     0.200
     4.197   -17.089     0.200
     5.463   -26.326     0.200
     5.965   -29.029     0.200
     6.660   -37.173     0.200
     6.668   -39.078     0.200
     7.993   -42.189     0.200
     8.259   -52.696     0.200
     8.529   -47.391     0.200
     8.681   -48.910     0.200
     9.286   -47.607     0.200
    10.456   -61.389     0.200
    11.492   -76.999     0.200
    12.852   -90.300     0.200
    18.253  -127.546     0.200
     4.585   -21.898     0.200
     5.600   -29.941     0.200
     6.296   -36.337     0.200
     6.680   -44.123     0.200
     7.894   -52.831     0.200
     8.774   -48.405     0.200
     3.916   -13.814     0.200
     4.649   -19.243     0.200
     5.166   -23.464     0.200
     5.717   -28.079     0.200
     6.206   -37.303     0.200
     6.403   -34.452     0.200
     6.959   -40.471     0.200
     7.499   -45.628     0.200
     8.162   -52.555     0.200
     8.301   -48.902     0.200
     8.314   -47.445     0.200
     8.314   -44.844     0.200
     8.889   -54.741     0.200
     8.895   -49.806     0.200
     9.460   -61.307     0.200
    11.398   -77.802     0.200
    12.841   -87.967     0.200
    18.241  -125.809     0.200
     5.201   -23.353     0.200
     5.725   -29.353     0.200
     6.417   -35.056     0.200
     6.431   -38.241     0.200
     8.079   -50.696     0.200
     8.099   -50.839     0.200
     8.480   -47.407     0.200
     8.529   -50.158     0.200
     8.772   -56.106     0.200
     9.559   -62.109     0.200
    11.335   -77.579     0.200
    12.742   -87.051     0.200
    16.669  -114.587     0.200
     3.489   -11.315     0.200
     4.048   -18.397     0.200
     4.785   -21.033     0.200
     4.925   -22.740     0.200
     5.304   -26.592     0.200
     5.379   -24.907     0.200
     5.852   -24.249     0.200
     6.530   -37.391     0.200
     7.163   -42.226     0.200
     7.623   -45.569     0.200
     8.327   -50.242     0.200
     8.398   -51.915     0.200
     8.398   -47.835     0.200
     8.562   -54.457     0.200
     9.670   -65.422     0.200
    16.514  -116.649     0.200
    18.191  -127.841     0.200
    18.191  -128.218     0.200
     4.339   -24.553     0.200
     4.339   -24.858     0.200
     5.256   -29.164     0.200
     5.256   -26.531     0.200
     5.606   -32.982     0.200
     5.606   -32.732     0.200
     5.785   -31.765     0.200
     6.799   -43.252     0.200
     6.799   -43.572     0.200
     7.054   -52.871     0.200
     7.410   -48.096     0.200
     7.410   -47.908     0.200
     7.660   -55.263     0.200
     8.392   -58.583     0.200
     8.392   -58.036     0.200
     8.509   -51.186     0.200
     8.712   -52.476     0.200
     8.712   -49.359     0.200
     9.867   -69.409     0.200
    16.503  -115.356     0.200
    18.169  -127.557     0.200
     4.906   -25.974     0.200
     5.360   -27.163     0.200
     5.824   -27.756     0.200
     7.144   -43.815     0.200
     8.331   -44.776     0.200
     8.396   -43.775     0.200
     8.396   -46.319     0.200
     2.617    -5.557     0.200
     8.547   -47.471     0.200
     8.719   -51.176     0.200
     8.719   -48.590     0.200
    14.686  -107.395     0.200
    16.554  -121.005     0.200
     3.595    -9.316     0.200
     4.090   -16.262     0.200
     4.831   -20.495     0.200
     4.991   -22.077     0.200
     5.461   -30.177     0.200
     5.867   -30.315     0.200
     6.055   -26.982     0.200
     6.970   -42.141     0.200
     7.538   -39.955     0.200
     7.699   -44.967     0.200
     7.734   -44.895     0.200
     8.203   -52.814     0.200
     8.202   -51.833     0.200
     8.270   -51.179     0.200
     8.293   -52.700     0.200
     8.445   -53.788     0.200
     8.428   -55.679     0.200
     8.483   -47.840     0.200
     8.608   -52.613     0.200
     8.589   -47.912     0.200
     8.589   -46.381     0.200
     9.383   -56.478     0.200
     9.626   -61.876     0.200
     9.704   -64.628     0.200
     9.927   -60.317     0.200
    11.438   -78.639     0.200
    16.601  -114.278     0.200
    18.274  -126.672     0.200
    19.207  -127.482     0.200
     5.762   -27.438     0.200
     6.234   -30.590     0.200
     8.850   -51.187     0.200
    12.215   -86.690     0.200
    18.599  -134.819     0.200
    18.724  -129.703     0.200
     6.423   -29.807     0.200
     8.440   -48.399     0.200
     8.759   -53.620     0.200
    13.464   -93.399     0.200
    13.655   -94.560     0.200
    15.101  -107.174     0.200
    15.297  -108.800     0.200
    16.294  -107.704     0.200
    16.983  -122.850     0.200
    16.987  -122.362     0.200
    17.953  -125.119     0.200
    18.877  -129.233     0.200
    19.209  -131.101     0.200
    20.425  -140.571     0.200
     3.977   -16.967     0.200
     4.714   -18.455     0.200
     5.234   -24.318     0.200
     5.331   -24.826     0.200
     5.878   -23.839     0.200
     6.430   -32.437     0.200
     6.457   -34.007     0.200
     6.971   -37.554     0.200
     6.995   -40.110     0.200
     7.416   -44.799     0.200
     7.549   -42.836     0.200
     7.989   -49.206     0.200
     8.135   -51.028     0.200
     8.142   -51.519     0.200
     8.161   -51.407     0.200
     8.237   -51.971     0.200
     8.264   -50.421     0.200
     8.348   -52.056     0.200
     8.398   -44.150     0.200
     8.450   -49.780     0.200
     8.846   -56.548     0.200
     9.519   -59.746     0.200
     9.597   -62.018     0.200
    12.340   -85.094     0.200
    12.763   -88.315     0.200
    12.971   -89.385     0.200
    13.601   -94.673     0.200
    14.164   -99.604     0.200
    14.994  -106.993     0.200
    15.265   -93.594     0.200
    15.625   -98.962     0.200
    15.951  -106.872     0.200
    16.260  -117.367     0.200
    16.596  -116.926     0.200
    18.273  -124.697     0.200
    18.273  -128.682     0.200
    18.326  -120.644     0.200
    19.654  -130.857     0.200
     1.423     2.212     0.200
     2.328    -8.037     0.200
     2.328    -8.037     0.200
     1.423     2.212     0.200
     2.328    -8.037     0.200
     3.970   -14.986     0.200
     5.227   -25.138     0.200
     5.326   -23.913     0.200
     5.879   -26.322     0.200
     6.449   -35.170     0.200
     7.582   -44.990     0.200
     8.127   -51.390     0.200
     8.154   -52.408     0.200
     8.484   -50.977     0.200
     8.454   -47.462     0.200
     9.511   -61.301     0.200
    11.517   -80.387     0.200
    12.333   -86.207     0.200
    12.806   -87.467     0.200
    12.756   -89.526     0.200
    13.369   -96.660     0.200
    17.067  -123.962     0.200
    18.280  -127.783     0.200
     1.427     0.469     0.200
     2.321    -9.197     0.200
     2.321    -9.138     0.200
     3.993   -15.732     0.200
     4.730   -18.389     0.200
     4.874   -20.754     0.200
     5.250   -23.909     0.200
     5.879   -25.136     0.200
     6.473   -35.357     0.200
     7.451   -39.963     0.200
     7.565   -44.344     0.200
     7.605   -45.529     0.200
     7.655   -38.983     0.200
     8.177   -54.224     0.200
     8.343   -54.415     0.200
     8.388   -47.067     0.200
     8.507   -52.779     0.200
     8.445   -51.196     0.200
     8.445   -47.032     0.200
    10.965   -64.545     0.200
    11.539   -79.896     0.200
    12.356   -85.352     0.200
    12.827   -88.236     0.200
    13.580   -86.282     0.200
    16.582  -109.882     0.200
    18.259  -127.620     0.200
    18.259  -124.742     0.200
    18.317  -126.508     0.200
    18.578  -123.470     0.200
     1.410     1.093     0.200
     2.344    -9.483     0.200
     3.997   -16.989     0.200
     4.735   -19.344     0.200
     5.255   -24.546     0.200
     5.349   -24.397     0.200
     5.788   -27.101     0.200
     5.880   -24.690     0.200
     6.130   -34.885     0.200
     6.477   -33.961     0.200
     7.759   -45.981     0.200
     8.181   -52.633     0.200
     8.386   -43.369     0.200
     8.445   -48.440     0.200
     8.445   -49.214     0.200
     8.445   -44.738     0.200
     8.863   -54.514     0.200
     9.539   -64.267     0.200
    10.418   -68.452     0.200
    12.361   -83.819     0.200
    12.784   -86.833     0.200
    12.991   -87.705     0.200
    13.622   -93.192     0.200
    14.184   -97.022     0.200
    14.417  -100.009     0.200
    16.578  -112.682     0.200
    18.255  -126.012     0.200
    18.255  -123.274     0.200
     2.349    -7.429     0.200
     4.737   -21.929     0.200
     5.450   -26.616     0.200
     5.910   -25.904     0.200
     6.131   -41.342     0.200
     6.477   -37.817     0.200
     8.155   -50.278     0.200
     8.403   -52.435     0.200
     8.411   -49.530     0.200
     8.474   -47.972     0.200
     8.474   -48.175     0.200
     8.514   -56.065     0.200
    12.362   -84.940     0.200
    13.605   -90.826     0.200
    15.985  -103.311     0.200
    16.595  -114.274     0.200
    18.271  -128.552     0.200
    18.271  -130.841     0.200
     3.443    -8.852     0.200
     3.971   -16.800     0.200
     4.043   -16.739     0.200
     4.710   -21.076     0.200
     5.230   -26.790     0.200
     5.343   -25.920     0.200
     5.915   -26.075     0.200
     6.448   -36.181     0.200
     7.582   -45.877     0.200
     8.118   -54.524     0.200
     8.487   -53.347     0.200
     8.435   -53.766     0.200
     8.490   -51.557     0.200
     8.490   -49.131     0.200
     9.512   -63.122     0.200
     9.590   -65.525     0.200
    11.003   -64.951     0.200
    12.334   -85.640     0.200
    13.597   -96.389     0.200
    13.627   -88.304     0.200
    14.393  -103.205     0.200
    16.624  -115.237     0.200
    18.300  -126.972     0.200
    18.300  -129.130     0.200
     2.324    -8.459     0.200
     3.460   -10.422     0.200
     3.988   -15.582     0.200
     4.726   -18.331     0.200
     5.247   -24.603     0.200
     5.434   -24.828     0.200
     5.920   -27.169     0.200
     6.436   -35.696     0.200
     6.465   -35.761     0.200
     8.428   -48.733     0.200
     8.428   -43.268     0.200
     8.489   -54.738     0.200
     8.489   -46.499     0.200
    12.351   -86.313     0.200
    16.611  -117.626     0.200
    18.287  -131.452     0.200
    18.287  -126.226     0.200
     4.047   -14.348     0.200
     4.788   -17.418     0.200
     5.311   -22.749     0.200
     5.407   -28.236     0.200
     6.174   -32.198     0.200
     6.076   -28.601     0.200
     6.515   -34.217     0.200
     7.601   -43.099     0.200
     8.047   -48.209     0.200
     8.218   -50.559     0.200
     8.393   -52.165     0.200
     8.565   -50.362     0.200
     8.783   -56.366     0.200
     8.626   -54.288     0.200
     8.626   -51.355     0.200
     9.581   -59.537     0.200
    10.312   -70.368     0.200
    11.161   -68.698     0.200
    11.385   -75.391     0.200
    12.406   -87.255     0.200
    12.768   -89.682     0.200
    13.400   -92.247     0.200
    14.239  -101.952     0.200
    14.473  -103.984     0.200
    18.502  -126.677     0.200
    18.328  -126.329     0.200
    19.581  -130.699     0.200
    20.125  -135.546     0.200
    20.565  -141.003     0.200
     8.853   -53.015     0.200
     8.864   -57.833     0.200
     8.864   -54.738     0.200
    17.028  -114.323     0.200
     5.899   -32.152     0.200
     8.422   -45.022     0.200
     3.880   -10.465     0.200
     5.745   -28.940     0.200
     4.317   -19.027     0.200
     2.929    -9.965     0.200
     4.317   -19.027     0.200
     4.317   -19.027     0.200
     3.878   -16.855     0.200
     4.317   -19.027     0.200
     5.745   -28.940     0.200
     4.153   -17.342     0.200
     5.737   -28.863     0.200
     4.309   -18.932     0.200
     4.145   -17.284     0.200
     4.145   -17.284     0.200
     4.309   -18.969     0.200
     2.921    -9.914     0.200
     4.444   -21.254     0.200
     4.309   -18.969     0.200
     2.921    -9.914     0.200
     4.309   -18.969     0.200
     4.444   -21.254     0.200
     4.444   -21.254     0.200
     5.737   -28.884     0.200
     5.737   -28.884     0.200
     4.145   -17.284     0.200
     5.737   -28.884     0.200
     4.145   -17.284     0.200
     4.145   -17.284     0.200
     4.336   -19.191     0.200
     4.336   -19.191     0.200
     5.760   -29.065     0.200
     4.156   -17.397     0.200
     4.336   -19.191     0.200
     5.760   -29.065     0.200
     4.510   -21.721     0.200
     3.538   -12.295     0.200
     3.538   -12.295     0.200
     3.538   -12.295     0.200
     4.156   -17.397     0.200
     5.760   -29.065     0.200
     4.336   -19.191     0.200
     4.336   -19.191     0.200
     4.156   -17.397     0.200
     4.336   -19.191     0.200
     2.970   -10.286     0.200
     4.510   -21.721     0.200
     4.168   -11.636     0.200
     4.341   -19.210     0.200
     8.495   -47.926     0.200
     4.373   -19.484     0.200
     4.373   -19.484     0.200
     4.373   -19.484     0.200
     5.791   -29.313     0.200
     5.791   -29.313     0.200
     5.791   -29.313     0.200
     5.791   -29.313     0.200
     4.351   -19.154     0.200
     4.351   -19.139     0.200
     4.351   -19.107     0.200
     5.777   -29.131     0.200
     5.777   -29.131     0.200
     4.351   -19.279     0.200
     8.469   -43.753     0.200
     2.937   -10.024     0.200
     4.319   -18.886     0.200
     4.319   -18.863     0.200
     3.889   -16.936     0.200
     4.150   -17.173     0.200
     4.150   -17.163     0.200
     4.345   -19.260     0.200
     4.345   -19.240     0.200
     5.769   -29.113     0.200
     4.165   -17.439     0.200
     4.345   -19.230     0.200
     5.769   -29.103     0.200
     4.517   -21.529     0.200
     5.769   -29.275     0.200
     5.769   -29.263     0.200
     4.345   -19.232     0.200
     4.345   -19.256     0.200
     4.165   -17.460     0.200
     4.345   -19.256     0.200
     4.345   -19.256     0.200
     4.165   -17.460     0.200
     2.978   -10.345     0.200
     3.546   -12.356     0.200
     4.303   -18.999     0.200
     5.731   -28.860     0.200
     4.138   -17.203     0.200
     4.303   -19.030     0.200
     2.916   -10.018     0.200
     4.442   -21.431     0.200
     4.303   -19.022     0.200
     2.916   -10.010     0.200
     4.303   -19.011     0.200
     4.442   -21.411     0.200
     4.442   -21.411     0.200
     5.731   -28.899     0.200
     5.731   -28.899     0.200
     4.138   -17.278     0.200
     5.731   -28.879     0.200
     4.138   -17.258     0.200
     4.138   -17.248     0.200
     3.939    -8.296     0.200
     4.183   -13.136     0.200
     5.925   -31.274     0.200
     3.561   -12.798     0.200
     3.561   -12.788     0.200
     3.561   -12.777     0.200
     4.174   -17.677     0.200
     5.774   -29.219     0.200
     4.349   -19.294     0.200
     4.349   -19.294     0.200
     4.174   -17.647     0.200
     4.349   -19.284     0.200
     2.974   -10.051     0.200
     4.505   -21.165     0.200
     4.349   -19.130     0.200
     4.349   -19.299     0.200
     4.174   -17.659     0.200
     4.349   -19.289     0.200
     4.349   -19.289     0.200
     4.174   -17.649     0.200
     2.974   -10.128     0.200
     3.561   -12.726     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     8.132   -22.739     0.200
     3.284    -1.197     0.200
     5.831    -3.940     0.200
     5.670   -10.901     0.200
     3.422    -3.097     0.200
     5.868   -11.614     0.200
     1.033     3.092     0.200
     3.327    -2.933     0.200
     3.873    -6.974     0.200
     4.259    -9.212     0.200
     8.270    -8.358     0.200
     4.647    -7.202     0.200
     1.463     2.818     0.200
     3.304    -2.747     0.200
     4.350    -6.981     0.200
     4.610    -4.727     0.200
     1.437     2.670     0.200
     2.501    -2.032     0.200
     8.264   -21.738     0.200
     5.725   -11.717     0.200
     1.455     4.815     0.200
     2.471    -0.685     0.200
     2.356    -0.562     0.200
     2.105     1.549     0.200
     1.236     2.059     0.200
     4.056    -5.349     0.200
     4.062    -7.817     0.200
     4.764    -9.206     0.200
     1.140     2.253     0.200
     3.535    -6.582     0.200
     1.159     3.262     0.200
     1.266     3.817     0.200
     1.053     2.849     0.200
     3.479    -7.438     0.200
     1.645     2.363     0.200
     1.494     1.580     0.200
     1.031    -0.790     0.200
     1.314    -1.412     0.200
     1.468     0.970     0.200
     0.957    -0.699     0.200
     1.040    -0.917     0.200
     0.640     0.041     0.200
     1.423    -0.851     0.200
     1.427    -1.492     0.200
     3.429    -5.423     0.200
     3.450    -8.151     0.200
     3.454    -6.351     0.200
     1.389    -1.323     0.200
     2.351    -2.751     0.200
     1.406    -1.679     0.200
     2.324    -4.058     0.200
     1.391    -1.687     0.200
     1.267    -1.196     0.200
     3.565    -7.185     0.200
     1.379     2.688     0.200
     1.379     2.055     0.200
     1.329     3.973     0.200
     1.331     3.310     0.200
     1.259     3.800     0.200
     1.390     2.108     0.200
     1.292     2.602     0.200
     1.300     3.135     0.200
     1.310     4.279     0.200
     1.259     4.128     0.200
     1.277     1.919     0.200
EOF
gmt end
