#!/bin/bash
gmt begin kunar4.14_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional kunar4.14'
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     6.000     2.000 Indirect calibration: shifted hypocenters used
EOF
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    42.181
    14.500    41.904
    15.000    41.625
    15.500    41.344
    16.000    41.059
    16.500    40.769
    17.000    40.473
    17.500    40.168
    18.000    39.852
    18.500    39.524
    19.000    39.181
    19.500    38.822
    20.000    38.443
    20.500    38.043
    21.000    37.619
    21.500    37.170
    22.000    36.692
    22.500    36.184
    23.000    35.645
    23.500    35.073
    24.000    33.820
    24.500    32.547
    25.000    31.265
    25.500    29.973
    26.000    28.670
    26.500    27.355
    27.000    26.027
    27.500    24.683
    28.000    23.319
    28.500    21.939
    29.000    20.549
    29.500    19.150
    30.000    17.743
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    20.319 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    12.976
     2.000    13.898
     2.500    14.820
     3.000    15.742
     3.500    16.664
     4.000    17.585
     4.500    18.505
     5.000    19.424
     5.500    20.342
     6.000    21.260
     6.500    22.175
     7.000    23.090
     7.500    24.003
     8.000    24.914
     8.500    25.824
     9.000    26.732
     9.500    27.638
    10.000    28.541
    10.500    29.442
    11.000    30.341
    11.500    31.238
    12.000    32.131
    12.500    33.022
    13.000    33.910
    13.500    34.795
    14.000    35.677
    14.500    36.555
    15.000    37.430
    15.500    38.302
    16.000    39.170
    16.500    39.971
    17.000    40.424
    17.500    39.073
    18.000    39.415
    18.500    39.700
    19.000    39.927
    19.500    40.096
    20.000    40.206
    20.500    40.257
    21.000    40.249
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    30.910 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.791
     1.000     6.940
     1.500     9.630
     2.000    12.321
     2.500    15.012
     3.000    17.703
     3.500    20.392
     4.000    23.080
     4.500    25.768
     5.000    28.453
     5.500    31.138
     6.000    33.820
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.453 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.500    36.133
     2.000    42.270
     2.500    48.407
     3.000    54.544
     3.500    60.679
     4.000    66.814
     4.500    72.948
     5.000    79.080
     5.500    85.209
     6.000    91.338
     6.500    97.464
     7.000   103.587
     7.500   109.708
     8.000   115.827
     8.500   121.941
     9.000   128.053
     9.500   134.162
    10.000   140.265
    10.500   146.365
    11.000   152.462
    11.500   158.553
    12.000   164.640
    12.500   170.722
    13.000   176.799
    13.500   182.870
    14.000   188.936
    14.500   194.996
    15.000   201.050
    15.500   207.098
    16.000   213.138
    16.500   219.173
    17.000   225.201
    17.500   233.569
    18.000   239.839
    18.500   246.097
    19.000   252.342
    19.500   258.573
    20.000   264.791
    20.500   270.994
    21.000   277.182
    21.500   283.355
    22.000   289.512
    22.500   295.653
    23.000   301.778
    23.500   307.886
    24.000   313.977
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    64.814 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.937
     1.000    21.602
     1.500    30.545
     2.000    39.488
     2.500    48.431
     3.000    57.374
     3.500    66.314
     4.000    75.252
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    64.314 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    16.007   234.310     0.150
    16.007   336.310     0.150
    16.486   328.722     0.150
    16.916   237.706     0.150
    18.609   266.954     0.150
    21.617    66.847     0.150
    23.322   296.953     0.150
    23.050    70.122     0.150
    29.050   315.100     0.150
    16.281   231.050     0.150
    23.164   290.729     0.150
    21.855   276.866     0.150
    16.803   235.167     0.150
    17.796   256.281     0.150
    21.183   271.753     0.150
    23.119   287.157     0.150
    18.583   266.965     0.150
    18.583   743.266     0.150
    19.278   268.847     0.150
    19.717   259.732     0.150
    20.044   262.212     0.150
    20.557   254.928     0.150
    21.052   266.149     0.150
    21.685   276.762     0.150
    21.685   726.762     0.150
    21.727   275.270     0.150
    22.087   278.372     0.150
    22.308   283.486     0.150
    22.308   492.986     0.150
    22.750    63.338     0.150
    23.124   278.969     0.150
    23.124    63.969     0.150
    23.124   329.969     0.150
    23.207   292.005     0.150
    23.294   278.690     0.150
    25.094   298.975     0.150
    25.094   356.975     0.150
    27.170  -310.069     0.150
    27.170   308.757     0.150
    27.170   324.757     0.150
    27.170   447.757     0.150
    27.225   308.614     0.150
    28.143   307.892     0.150
    29.415   307.550     0.150
    29.755   316.582     0.150
    29.832   321.683     0.150
    14.312   211.483     0.150
    17.564    53.838     0.150
    17.564   249.838     0.150
    18.605   268.682     0.150
    19.351   258.879     0.150
    19.676   270.380     0.150
    19.821    43.493     0.150
    19.821    55.693     0.150
    19.999   259.411     0.150
    20.603   256.769     0.150
    21.010   268.619     0.150
    21.324   276.948     0.150
    22.326   276.762     0.150
    22.326   314.762     0.150
    22.326   485.762     0.150
    22.326   710.762     0.150
    23.082   288.437     0.150
    23.082    66.437     0.150
    23.193   287.144     0.150
    23.193    66.245     0.150
    23.277   289.658     0.150
    23.277    64.158     0.150
    25.110   300.768     0.150
    25.110   362.768     0.150
    25.110   462.768     0.150
    25.348   291.998     0.150
    25.348    75.998     0.150
    27.216  -313.110     0.150
    27.216    71.195     0.150
    27.216   303.195     0.150
    27.216   329.195     0.150
    27.777  -322.764     0.150
    27.777  -322.964     0.150
    28.594   318.611     0.150
    29.463   307.971     0.150
    29.535   321.133     0.150
    29.864   317.296     0.150
    29.864    77.296     0.150
    29.864   200.694     0.150
    29.864   405.296     0.150
    17.355   242.879     0.150
    19.780    60.873     0.150
    20.644   259.400     0.150
    21.772   280.232     0.150
    22.123   279.143     0.150
    23.188   287.310     0.150
    23.188    71.810     0.150
    14.322   213.680     0.150
    17.295   242.180     0.150
    19.822    45.889     0.150
    21.708   278.875     0.150
    22.063   280.031     0.150
    22.321   277.731     0.150
    22.321   316.231     0.150
    22.790   281.246     0.150
    23.248   293.907     0.150
    17.319   242.482     0.150
    21.006   274.351     0.150
    21.323   283.656     0.150
    22.087   277.233     0.150
    23.266   292.981     0.150
    23.266    66.981     0.150
    28.582   315.937     0.150
    17.307   238.634     0.150
    18.623   266.273     0.150
    19.822    49.386     0.150
    20.602   257.679     0.150
    21.720   279.626     0.150
    22.322   283.601     0.150
    23.172    69.585     0.150
    28.570    75.686     0.150
    17.265   235.949     0.150
    22.035    61.485     0.150
    22.035   277.087     0.150
    20.400   257.907     0.150
    20.581   258.759     0.150
    16.069    46.561     0.150
    16.069    52.061     0.150
    16.069   220.061     0.150
    16.069   229.061     0.150
    18.586   251.195     0.150
    20.208   254.259     0.150
    23.210    67.222     0.150
    18.281   246.302     0.150
    20.480   256.638     0.150
    23.185   290.371     0.150
    19.357   257.000     0.150
    20.389   254.459     0.150
    21.760   275.758     0.150
    22.407    65.410     0.150
    23.747   260.165     0.150
    28.532   213.932     0.150
    29.801   204.224     0.150
    29.809   316.959     0.150
    20.695   260.936     0.150
    21.835   279.839     0.150
    22.104    59.493     0.150
    23.165    68.310     0.150
    15.819   222.397     0.150
    16.306   230.210     0.150
    20.295   258.661     0.150
    20.746    55.396     0.150
    23.218   287.556     0.150
    23.347    61.042     0.150
    23.227   290.389     0.150
    23.332    65.170     0.150
    23.311    64.295     0.150
    29.686   424.790     0.150
    15.811    46.973     0.150
    17.063   241.156     0.150
    18.792    58.687     0.150
    18.886   251.675     0.150
    19.928   273.527     0.150
    20.320   258.851     0.150
    22.515   278.630     0.150
    22.542   271.918     0.150
    22.542   281.918     0.150
    23.694   291.476     0.150
    23.688    64.753     0.150
    23.688   288.448     0.150
    23.688   329.253     0.150
    23.778   285.493     0.150
    27.049   292.319     0.150
    28.414   215.695     0.150
    28.414   302.601     0.150
    28.414   388.101     0.150
    29.257    80.453     0.150
    29.257   315.453     0.150
    19.166   259.642     0.150
    20.507   265.595     0.150
    22.187   276.291     0.150
    25.457    71.427     0.150
    25.457   295.827     0.150
    25.457   357.127     0.150
    29.831   203.782     0.150
    16.196    45.452     0.150
    16.196   332.952     0.150
    18.426   265.335     0.150
    23.447    58.735     0.150
    23.447   276.536     0.150
    23.816   257.232     0.150
    18.583   260.399     0.150
    20.498   268.041     0.150
    21.349   271.062     0.150
    21.677   273.288     0.150
    22.595    65.268     0.150
    23.227   286.093     0.150
    15.644   813.017     0.150
    16.745    45.607     0.150
    16.745    52.607     0.150
    16.745   328.607     0.150
    17.557   790.653     0.150
    17.665   789.391     0.150
    22.616   282.191     0.150
    22.784   286.130     0.150
    23.247   292.017     0.150
    23.519   290.151     0.150
    23.580   293.343     0.150
    23.580   329.741     0.150
    24.365   299.178     0.150
    25.254   299.501     0.150
    25.254   350.400     0.150
    26.613   305.539     0.150
    27.108    70.164     0.150
    27.108   228.062     0.150
    27.108   308.562     0.150
    27.108   379.265     0.150
    27.656    73.672     0.150
    27.656   315.672     0.150
    27.656   381.875     0.150
    28.562    77.099     0.150
    28.562   217.701     0.150
    28.562   311.701     0.150
    28.562   318.201     0.150
    28.562   396.201     0.150
    28.562   438.802     0.150
    28.767   214.691     0.150
    29.139   210.565     0.150
    29.442   207.682     0.150
    29.442   208.034     0.150
    29.455   321.272     0.150
    29.743    78.416     0.150
    29.743   315.916     0.150
    29.743   408.814     0.150
    16.758    48.040     0.150
    16.758    55.438     0.150
    18.352   250.329     0.150
    18.455   249.921     0.150
    19.626   262.062     0.150
    22.641   282.781     0.150
    23.270   292.041     0.150
    23.550   293.777     0.150
    23.610   293.172     0.150
    23.610   329.868     0.150
    24.368   299.022     0.150
    24.368   304.420     0.150
    27.655   309.562     0.150
    27.655   318.062     0.150
    28.555    76.057     0.150
    28.555   217.260     0.150
    28.555   311.056     0.150
    28.555   317.158     0.150
    28.555   395.056     0.150
    28.778   214.789     0.150
    29.154   205.571     0.150
    29.460   206.345     0.150
    29.460   206.360     0.150
    29.731    84.044     0.150
    29.731   320.544     0.150
     7.201    23.486     0.150
     7.201    25.486     0.150
    16.802   244.945     0.150
    16.802   542.246     0.150
    16.802   758.746     0.150
    17.614   243.769     0.150
    17.722   242.721     0.150
    18.871   254.833     0.150
    18.903   255.881     0.150
    18.903   255.422     0.150
    22.401   283.509     0.150
    22.674   282.121     0.150
    23.246   286.442     0.150
    23.560   292.682     0.150
    23.618   290.603     0.150
    23.618   328.603     0.150
    24.414   303.416     0.150
    25.251   299.747     0.150
    28.598    77.291     0.150
    28.598   311.791     0.150
    28.598   396.791     0.150
    29.429   207.292     0.150
    29.768    78.628     0.150
    29.768   316.628     0.150
    29.768   410.929     0.150
    15.158   215.228     0.150
    16.247   223.091     0.150
    17.115   235.355     0.150
    17.223   234.109     0.150
    18.540   248.332     0.150
    18.540   252.332     0.150
    19.716   261.015     0.150
    19.879   259.964     0.150
    20.464   261.822     0.150
    20.499   266.790     0.150
    20.501   266.888     0.150
    20.576   257.076     0.150
    21.881   276.652     0.150
    21.881   274.795     0.150
    22.166   277.320     0.150
    22.166   316.520     0.150
    23.262   288.835     0.150
    23.361   287.381     0.150
    23.909   294.587     0.150
    23.909   300.987     0.150
    25.385    63.956     0.150
    25.385   295.057     0.150
    25.385   312.757     0.150
    27.222   306.518     0.150
    27.229    72.337     0.150
    27.229   304.437     0.150
    27.229   313.237     0.150
    27.229   379.937     0.150
    28.191    72.009     0.150
    28.191   308.609     0.150
    28.191   316.509     0.150
    29.076   207.813     0.150
    29.337    75.737     0.150
    29.337   316.737     0.150
    29.337   401.637     0.150
    29.448   312.837     0.150
    29.574   318.674     0.150
    29.647   204.215     0.150
    21.911   271.224     0.150
    21.915   271.179     0.150
    23.314    62.767     0.150
    23.314   277.167     0.150
    15.810    50.982     0.150
    23.287    57.118     0.150
    23.287   284.419     0.150
    23.456   289.051     0.150
    26.784    75.505     0.150
    23.193   292.550     0.150
    23.836   291.867     0.150
    27.308    75.162     0.150
    23.275   291.942     0.150
    23.275   325.741     0.150
    23.318    61.077     0.150
    23.318   284.577     0.150
    23.318   324.679     0.150
    16.221   220.651     0.150
    23.633    61.750     0.150
    23.633   284.250     0.150
    23.633   330.152     0.150
    23.366   280.137     0.150
    23.366   325.536     0.150
    23.209   287.109     0.150
    23.209   328.709     0.150
    23.320    59.830     0.150
    23.320   284.533     0.150
    26.007   296.971     0.150
    26.007   314.275     0.150
    19.800    43.458     0.150
    19.800    47.458     0.150
    20.425    49.750     0.150
    22.853   286.314     0.150
    24.318   303.516     0.150
    24.872   347.658     0.150
    28.939  -332.120     0.150
    14.893   213.213     0.150
    18.564   252.189     0.150
    19.320   259.619     0.150
    19.649    48.179     0.150
    19.649   254.077     0.150
    19.654   261.424     0.150
    19.863   257.685     0.150
    20.204   267.500     0.150
    20.658   270.699     0.150
    20.830   271.325     0.150
    21.332   279.040     0.150
    21.643   274.150     0.150
    23.187   296.124     0.150
    23.183   288.134     0.150
    23.289   293.144     0.150
    23.289    59.605     0.150
    23.289   289.605     0.150
    23.289   325.402     0.150
    23.308   290.109     0.150
    23.571   293.407     0.150
    23.507   290.754     0.150
    23.548   295.478     0.150
    24.202   292.625     0.150
    25.462   301.947     0.150
    25.541    67.221     0.150
    25.541   299.221     0.150
    25.861   299.584     0.150
    25.861   363.287     0.150
    26.940   307.295     0.150
    27.810   313.741     0.150
    27.789   314.417     0.150
    28.121   306.615     0.150
    28.295   439.435     0.150
    28.834   315.388     0.150
    29.209   315.306     0.150
    29.320   208.321     0.150
    29.320   430.454     0.150
    29.553   204.486     0.150
    29.553   427.111     0.150
    29.553   204.353     0.150
    29.553   425.400     0.150
    29.625   321.554     0.150
    29.625   433.859     0.150
    29.809   202.440     0.150
    29.809   315.924     0.150
    29.809   424.846     0.150
    29.809   202.307     0.150
    29.809   315.323     0.150
    29.722   316.024     0.150
    29.841   316.570     0.150
    18.557   250.768     0.150
    19.870   251.162     0.150
    23.296    58.885     0.150
    23.296   288.588     0.150
    23.296   321.787     0.150
    29.553   203.040     0.150
    29.802   201.905     0.150
    29.802   423.170     0.150
    23.276    64.104     0.150
    23.276   285.604     0.150
    18.363   246.316     0.150
    23.320    63.196     0.150
    23.320   287.396     0.150
    23.320   327.096     0.150
    23.310    62.486     0.150
    23.310   284.287     0.150
    23.499   287.777     0.150
    19.808   255.567     0.150
    23.452   286.833     0.150
    25.479   293.482     0.150
    25.479   358.482     0.150
    18.701   238.467     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    20.260    37.685     0.200
    21.617    40.847     0.200
    23.050    38.122     0.200
    26.697    32.565     0.200
    29.673    19.829     0.200
    17.553    43.206     0.200
    18.577    40.254     0.200
    19.491    39.591     0.200
    20.063    40.913     0.200
    20.229    40.972     0.200
    21.537    40.709     0.200
    21.869    40.839     0.200
    22.150    34.562     0.200
    23.164    36.729     0.200
    25.128    33.800     0.200
    29.581    19.833     0.200
    29.744    20.938     0.200
    29.736    21.024     0.200
    16.362    43.975     0.200
    18.555    39.382     0.200
    20.288    40.155     0.200
    20.298    40.035     0.200
    21.855    39.866     0.200
    23.279    36.253     0.200
    23.343    38.000     0.200
    25.117    34.795     0.200
    27.434    28.757     0.200
    28.239    26.569     0.200
    20.650    38.859     0.200
    21.939    39.319     0.200
    22.040    37.434     0.200
    27.739    27.123     0.200
    28.561    25.541     0.200
    14.077    45.984     0.200
    16.803    42.567     0.200
    17.796    42.281     0.200
    20.189    40.348     0.200
    21.183    37.852     0.200
    21.582    37.498     0.200
    21.727    44.401     0.200
    21.727    44.801     0.200
    22.018    40.011     0.200
    22.640    40.746     0.200
    23.000    38.549     0.200
    23.119    38.157     0.200
    25.288    33.844     0.200
    26.579    30.685     0.200
    27.132    29.329     0.200
    27.938    26.926     0.200
    29.216    24.008     0.200
    29.426    22.358     0.200
    16.196    42.886     0.200
    17.388    41.073     0.200
    21.747    40.612     0.200
    22.393    40.072     0.200
    22.694    36.561     0.200
    23.839    36.994     0.200
    24.997    33.681     0.200
    14.272    44.769     0.200
    15.665    44.013     0.200
    17.207    43.921     0.200
    17.370    44.113     0.200
    18.583    37.965     0.200
    19.330    40.544     0.200
    20.044    39.911     0.200
    21.052    41.149     0.200
    21.362    40.532     0.200
    21.401    40.080     0.200
    21.685    37.762     0.200
    21.844    37.903     0.200
    21.914    41.090     0.200
    22.087    36.270     0.200
    22.319    40.365     0.200
    22.308    36.986     0.200
    23.124    36.969     0.200
    23.207    36.005     0.200
    23.294    34.991     0.200
    23.294    35.690     0.200
    23.842    38.585     0.200
    23.995    34.909     0.200
    25.391    31.519     0.200
    25.391    32.320     0.200
    26.655    27.360     0.200
    27.170    28.757     0.200
    27.225    27.114     0.200
    28.143    25.392     0.200
    28.561    24.821     0.200
    29.415    21.550     0.200
    29.583    21.593     0.200
    29.577    19.861     0.200
    29.755    19.582     0.200
    29.755    19.480     0.200
    29.832    19.683     0.200
    29.832    20.283     0.200
    14.312    45.182     0.200
    15.617    45.549     0.200
    16.200    41.746     0.200
    17.326    45.610     0.200
    18.605    36.682     0.200
    18.605    38.682     0.200
    19.351    39.583     0.200
    19.999    39.411     0.200
    20.603    38.769     0.200
    21.010    40.119     0.200
    21.318    39.023     0.200
    21.324    39.948     0.200
    21.357    38.570     0.200
    21.637    40.302     0.200
    21.746    35.225     0.200
    21.862    37.279     0.200
    21.869    41.592     0.200
    22.101    37.584     0.200
    22.326    37.262     0.200
    23.082    35.937     0.200
    23.193    35.144     0.200
    23.193    35.343     0.200
    23.277    36.158     0.200
    23.887    36.047     0.200
    25.110    32.768     0.200
    25.348    33.998     0.200
    27.216    27.695     0.200
    27.183    27.584     0.200
    27.777    25.642     0.200
    27.777    25.841     0.200
    27.785    27.447     0.200
    28.191    24.413     0.200
    28.594    23.111     0.200
    29.463    19.971     0.200
    29.535    22.133     0.200
    29.535    22.133     0.200
    29.555    22.897     0.200
    29.800    20.039     0.200
    29.800    20.036     0.200
    29.864    20.296     0.200
    18.229    39.479     0.200
    19.378    39.973     0.200
    20.644    38.900     0.200
    21.772    36.431     0.200
    22.123    36.842     0.200
    22.369    37.269     0.200
    22.236    39.613     0.200
    23.188    35.709     0.200
    23.932    36.828     0.200
    27.262    27.664     0.200
    28.237    24.781     0.200
    28.632    23.380     0.200
    14.322    45.680     0.200
    18.631    36.789     0.200
    21.324    40.355     0.200
    21.890    38.250     0.200
    21.708    36.476     0.200
    22.063    37.734     0.200
    22.272    40.294     0.200
    22.321    37.731     0.200
    22.790    34.246     0.200
    23.162    36.907     0.200
    23.162    37.306     0.200
    23.248    36.907     0.200
    23.861    37.356     0.200
    23.986    35.299     0.200
    23.986    36.095     0.200
    25.140    33.831     0.200
    27.194    28.358     0.200
    28.176    26.002     0.200
    28.559    24.524     0.200
    15.972    43.104     0.200
    17.324    44.324     0.200
    18.616    37.248     0.200
    19.820    40.798     0.200
    21.006    41.351     0.200
    21.323    39.656     0.200
    21.873    38.732     0.200
    21.867    40.303     0.200
    22.087    36.733     0.200
    22.272    39.775     0.200
    22.262    37.697     0.200
    22.796    34.459     0.200
    23.078    36.272     0.200
    23.181    35.971     0.200
    23.181    36.671     0.200
    23.266    34.981     0.200
    23.266    35.782     0.200
    23.686    39.571     0.200
    23.879    37.528     0.200
    24.010    36.102     0.200
    25.344    30.725     0.200
    27.765    26.472     0.200
    28.582    23.937     0.200
    29.802    21.201     0.200
    29.851    20.126     0.200
    17.307    43.134     0.200
    17.307    43.236     0.200
    18.179    42.748     0.200
    18.623    39.773     0.200
    20.602    40.179     0.200
    21.881    40.643     0.200
    21.720    35.626     0.200
    21.720    36.329     0.200
    22.075    38.486     0.200
    22.322    38.601     0.200
    22.273    41.177     0.200
    23.078    37.785     0.200
    23.172    37.686     0.200
    23.257    36.691     0.200
    23.257    37.089     0.200
    23.689    40.849     0.200
    23.869    38.448     0.200
    25.131    34.828     0.200
    28.181    26.834     0.200
    28.570    24.686     0.200
    28.570    25.084     0.200
    29.457    22.833     0.200
    29.801    23.324     0.200
    16.349    41.945     0.200
    17.265    40.848     0.200
    18.138    39.366     0.200
    18.627    38.862     0.200
    20.567    38.219     0.200
    21.891    36.562     0.200
    22.035    35.884     0.200
    23.816    35.696     0.200
    25.142    32.624     0.200
    28.519    22.421     0.200
    20.400    39.407     0.200
    21.613    40.053     0.200
    20.581    40.259     0.200
    21.911    40.434     0.200
    23.818    38.590     0.200
    25.162    35.297     0.200
    18.586    36.195     0.200
    21.105    39.795     0.200
    21.435    38.940     0.200
    21.858    36.103     0.200
    23.176    34.623     0.200
    23.185    35.420     0.200
    23.277    34.444     0.200
    23.743    36.106     0.200
    25.112    32.035     0.200
    28.053    23.715     0.200
    28.466    22.198     0.200
    18.607    40.334     0.200
    20.208    41.259     0.200
    21.327    42.201     0.200
    21.925    39.414     0.200
    21.672    41.169     0.200
    21.710    40.724     0.200
    23.096    38.355     0.200
    23.329    39.337     0.200
    23.210    39.222     0.200
    23.395    38.067     0.200
    27.675    26.715     0.200
    28.066    26.354     0.200
    29.435    22.575     0.200
    18.667    38.294     0.200
    21.456    37.050     0.200
    21.950    36.692     0.200
    22.279    37.639     0.200
    23.185    35.075     0.200
    23.185    34.473     0.200
    23.396    34.404     0.200
    28.351    21.787     0.200
    21.892    38.634     0.200
    23.248    36.207     0.200
    23.546    41.465     0.200
    29.751    19.853     0.200
    23.651    35.635     0.200
    23.931    35.364     0.200
    21.506    38.304     0.200
    29.748    20.719     0.200
    15.855    42.454     0.200
    21.514    38.811     0.200
    23.192    38.535     0.200
    23.284    38.257     0.200
    23.540    39.471     0.200
    29.822    20.459     0.200
    21.953    34.906     0.200
    23.511    34.428     0.200
    15.671    42.019     0.200
    18.429    41.832     0.200
    18.429    38.332     0.200
    19.357    41.000     0.200
    21.701    39.349     0.200
    21.760    37.157     0.200
    21.826    38.190     0.200
    22.139    36.542     0.200
    22.407    39.410     0.200
    23.299    37.005     0.200
    23.342    37.695     0.200
    23.462    36.100     0.200
    23.538    38.213     0.200
    23.747    37.368     0.200
    27.056    28.651     0.200
    27.729    27.304     0.200
    28.007    26.059     0.200
    28.532    23.932     0.200
    29.801    19.521     0.200
    16.293    42.094     0.200
    22.002    37.371     0.200
    23.560    35.514     0.200
    23.879    37.361     0.200
    18.651    35.792     0.200
    21.835    35.238     0.200
    22.104    40.493     0.200
    22.129    34.196     0.200
    23.237    35.272     0.200
    23.245    34.077     0.200
    23.975    34.949     0.200
    28.661    21.772     0.200
    29.352    20.696     0.200
    15.894    43.519     0.200
    17.849    40.702     0.200
    18.517    38.410     0.200
    21.417    40.790     0.200
    21.606    37.104     0.200
    21.940    41.273     0.200
    21.940    41.785     0.200
    23.218    35.556     0.200
    23.347    36.042     0.200
    23.321    35.148     0.200
    23.535    36.156     0.200
    23.588    37.933     0.200
    23.627    34.282     0.200
    26.859    28.563     0.200
    27.493    26.767     0.200
    27.838    24.639     0.200
    28.296    23.691     0.200
    28.322    19.983     0.200
    28.998    22.254     0.200
    29.128    21.585     0.200
    29.576    20.348     0.200
    29.726    19.656     0.200
    17.829    39.993     0.200
    20.274    39.351     0.200
    21.437    38.470     0.200
    21.603    37.152     0.200
    21.922    36.825     0.200
    23.227    37.190     0.200
    23.517    37.005     0.200
    23.332    36.170     0.200
    23.608    40.051     0.200
    27.483    28.031     0.200
    29.705    20.192     0.200
    29.919    19.964     0.200
    16.325    43.821     0.200
    21.459    40.585     0.200
    21.877    36.022     0.200
    23.204    36.042     0.200
    23.311    35.295     0.200
    23.471    37.428     0.200
    23.622    36.465     0.200
    29.868    19.188     0.200
    17.581    41.156     0.200
    17.982    40.038     0.200
    19.038    40.088     0.200
    18.920    39.528     0.200
    19.538    39.270     0.200
    20.320    37.851     0.200
    20.180    40.210     0.200
    20.180    39.992     0.200
    20.298    40.643     0.200
    20.298    39.581     0.200
    20.440    38.709     0.200
    20.440    38.944     0.200
    21.424    40.502     0.200
    21.694    39.422     0.200
    22.515    36.029     0.200
    22.542    38.917     0.200
    23.694    35.179     0.200
    23.939    36.713     0.200
    23.688    35.753     0.200
    23.778    34.040     0.200
    23.778    33.595     0.200
    23.755    35.765     0.200
    25.591    31.340     0.200
    26.106    28.971     0.200
    26.821    26.540     0.200
    27.203    28.021     0.200
    27.049    27.920     0.200
    28.084    24.847     0.200
    28.110    24.008     0.200
    28.300    24.524     0.200
    28.414    23.101     0.200
    28.838    22.838     0.200
    29.257    21.555     0.200
    29.187    22.108     0.200
    29.301    21.690     0.200
    15.459    42.689     0.200
    17.592    41.802     0.200
    17.592    41.575     0.200
    18.001    40.969     0.200
    18.924    39.949     0.200
    19.543    40.289     0.200
    19.543    39.961     0.200
    21.407    38.936     0.200
    23.961    37.370     0.200
    23.777    34.140     0.200
    17.246    42.746     0.200
    18.106    41.017     0.200
    18.106    41.417     0.200
    19.166    41.145     0.200
    20.507    37.595     0.200
    21.216    43.223     0.200
    21.216    43.620     0.200
    21.881    38.560     0.200
    22.187    37.791     0.200
    23.433    37.449     0.200
    23.869    38.160     0.200
    25.457    32.027     0.200
    26.026    33.382     0.200
    27.182    29.198     0.200
    27.819    27.660     0.200
    28.628    24.822     0.200
    29.327    22.742     0.200
    29.831    21.086     0.200
    29.914    20.913     0.200
    29.717    23.011     0.200
    18.036    39.781     0.200
    18.426    35.335     0.200
    18.500    37.332     0.200
    18.500    37.594     0.200
    18.540    37.070     0.200
    18.540    37.664     0.200
    21.287    38.847     0.200
    21.287    39.160     0.200
    21.533    36.070     0.200
    21.879    35.586     0.200
    22.189    33.617     0.200
    22.369    36.814     0.200
    23.358    34.774     0.200
    23.447    33.633     0.200
    23.447    34.016     0.200
    23.503    34.088     0.200
    23.503    33.538     0.200
    23.556    33.270     0.200
    23.816    35.232     0.200
    26.097    27.309     0.200
    28.174    23.584     0.200
    28.598    22.225     0.200
    29.300    20.534     0.200
    29.788    18.135     0.200
    29.788    17.885     0.200
    29.794    17.862     0.200
    18.818    41.098     0.200
    20.498    41.142     0.200
    21.349    38.761     0.200
    21.677    37.890     0.200
    21.576    41.497     0.200
    23.245    40.091     0.200
    23.227    36.914     0.200
    23.705    38.018     0.200
    29.192    23.289     0.200
    17.919    40.566     0.200
    21.015    37.617     0.200
    28.838    21.214     0.200
    18.323    41.741     0.200
    21.609    38.478     0.200
    21.625    38.269     0.200
    21.625    38.288     0.200
    29.521    21.238     0.200
    15.152    41.689     0.200
    15.152    40.858     0.200
    21.917    36.046     0.200
    21.933    35.880     0.200
    23.726    33.837     0.200
    15.477    43.365     0.200
    17.653    44.059     0.200
    18.032    42.517     0.200
    18.051    44.300     0.200
    18.201    43.541     0.200
    18.468    40.398     0.200
    18.449    41.041     0.200
    18.449    41.416     0.200
    18.530    39.166     0.200
    18.759    40.780     0.200
    18.821    41.012     0.200
    18.821    40.270     0.200
    18.854    40.198     0.200
    18.854    40.346     0.200
    18.854    40.659     0.200
    18.943    37.463     0.200
    19.480    41.618     0.200
    19.833    41.827     0.200
    19.852    41.636     0.200
    19.972    41.557     0.200
    20.797    39.316     0.200
    20.957    42.547     0.200
    20.957    42.047     0.200
    21.246    41.178     0.200
    21.549    40.861     0.200
    21.684    41.778     0.200
    21.830    39.679     0.200
    21.823    42.180     0.200
    22.094    40.385     0.200
    22.098    41.370     0.200
    22.342    36.582     0.200
    22.345    39.581     0.200
    22.369    40.645     0.200
    22.481    38.559     0.200
    22.616    36.488     0.200
    22.578    41.729     0.200
    22.784    37.130     0.200
    23.041    37.919     0.200
    23.220    40.476     0.200
    23.225    39.842     0.200
    23.247    37.517     0.200
    23.317    39.886     0.200
    23.376    39.684     0.200
    23.443    38.798     0.200
    23.519    37.752     0.200
    23.502    40.134     0.200
    23.580    36.546     0.200
    23.580    36.241     0.200
    23.881    37.090     0.200
    24.177    38.620     0.200
    24.365    37.178     0.200
    24.395    36.566     0.200
    24.799    34.404     0.200
    24.815    32.745     0.200
    25.137    35.250     0.200
    25.254    32.298     0.200
    25.289    34.473     0.200
    25.727    32.983     0.200
    25.727    32.780     0.200
    25.946    33.020     0.200
    26.440    31.290     0.200
    26.613    29.938     0.200
    26.860    28.963     0.200
    26.896    28.736     0.200
    26.868    29.750     0.200
    27.108    28.062     0.200
    27.269    28.358     0.200
    27.295    28.870     0.200
    27.311    29.410     0.200
    27.656    27.070     0.200
    27.719    27.920     0.200
    27.870    26.877     0.200
    28.049    26.288     0.200
    28.254    25.287     0.200
    28.325    25.666     0.200
    28.562    25.498     0.200
    28.518    25.100     0.200
    28.566    25.226     0.200
    28.662    25.568     0.200
    28.767    24.238     0.200
    28.877    24.027     0.200
    29.139    22.667     0.200
    29.392    23.555     0.200
    29.442    21.924     0.200
    29.442    22.182     0.200
    29.455    22.272     0.200
    29.573    22.997     0.200
    29.602    21.919     0.200
    29.658    22.388     0.200
    29.743    22.314     0.200
    29.835    20.635     0.200
    29.843    21.070     0.200
    29.953    19.762     0.200
    29.953    20.949     0.200
    29.953    20.465     0.200
    29.953    20.567     0.200
    29.957    20.822     0.200
    29.957    21.025     0.200
    15.249    46.397     0.200
    15.319    46.121     0.200
    15.467    43.301     0.200
    17.690    42.560     0.200
    18.455    42.125     0.200
    18.479    40.860     0.200
    18.479    41.641     0.200
    18.560    41.824     0.200
    18.789    41.330     0.200
    18.851    41.402     0.200
    18.851    41.715     0.200
    18.883    41.532     0.200
    18.883    41.314     0.200
    19.626    39.062     0.200
    19.713    42.262     0.200
    19.836    42.237     0.200
    19.975    41.452     0.200
    20.976    41.612     0.200
    21.267    41.316     0.200
    21.815    39.276     0.200
    22.116    41.309     0.200
    22.119    41.741     0.200
    22.390    42.455     0.200
    22.366    36.988     0.200
    22.466    39.014     0.200
    22.641    36.781     0.200
    23.064    40.445     0.200
    23.270    38.736     0.200
    23.270    39.143     0.200
    23.550    37.676     0.200
    23.610    36.868     0.200
    23.610    36.469     0.200
    24.368    36.920     0.200
    25.744    33.467     0.200
    25.744    33.326     0.200
    26.641    30.705     0.200
    26.919    29.962     0.200
    27.282    29.058     0.200
    27.730    27.047     0.200
    27.897    27.743     0.200
    28.076    26.559     0.200
    28.342    26.051     0.200
    28.555    24.760     0.200
    28.778    24.758     0.200
    29.154    22.673     0.200
    29.460    22.282     0.200
    29.460    22.204     0.200
    29.478    23.994     0.200
    29.553    25.908     0.200
    29.851    20.934     0.200
    29.934    20.374     0.200
    16.964    38.387     0.200
    15.326    45.668     0.200
    15.999    43.522     0.200
    16.285    43.779     0.200
    16.515    43.800     0.200
    16.802    42.246     0.200
    18.480    41.162     0.200
    18.494    42.506     0.200
    18.581    40.905     0.200
    18.581    40.687     0.200
    18.871    41.538     0.200
    18.871    41.599     0.200
    18.903    41.389     0.200
    18.903    41.022     0.200
    19.014    41.734     0.200
    19.792    41.627     0.200
    19.931    41.565     0.200
    20.049    41.226     0.200
    20.263    39.813     0.200
    20.714    40.764     0.200
    20.813    39.639     0.200
    21.347    44.712     0.200
    21.771    39.353     0.200
    22.091    40.691     0.200
    22.364    41.568     0.200
    22.401    36.269     0.200
    22.401    36.609     0.200
    22.422    38.991     0.200
    22.674    36.323     0.200
    22.800    39.445     0.200
    23.040    39.051     0.200
    23.246    40.044     0.200
    23.246    40.544     0.200
    23.327    38.600     0.200
    23.560    37.682     0.200
    23.618    37.003     0.200
    23.618    37.404     0.200
    23.847    35.529     0.200
    24.185    35.091     0.200
    24.414    36.916     0.200
    25.251    34.147     0.200
    25.711    34.177     0.200
    25.845    34.168     0.200
    26.899    30.315     0.200
    27.008    31.076     0.200
    27.107    28.689     0.200
    27.170    29.144     0.200
    27.648    28.307     0.200
    27.665    29.981     0.200
    27.691    26.776     0.200
    27.708    28.197     0.200
    27.883    27.536     0.200
    28.062    26.742     0.200
    28.211    26.158     0.200
    28.211    27.099     0.200
    28.347    26.305     0.200
    28.598    25.592     0.200
    28.740    24.829     0.200
    29.429    22.893     0.200
    29.503    21.077     0.200
    29.768    22.128     0.200
    29.964    20.945     0.200
    29.964    22.746     0.200
    14.929    43.329     0.200
    14.929    41.578     0.200
    15.571    44.141     0.200
    15.746    44.936     0.200
    15.890    44.298     0.200
    15.965    43.888     0.200
    16.169    44.184     0.200
    16.247    41.991     0.200
    16.428    44.581     0.200
    17.501    40.791     0.200
    18.470    38.398     0.200
    18.470    39.361     0.200
    18.540    38.332     0.200
    18.504    38.159     0.200
    18.504    38.957     0.200
    18.504    39.557     0.200
    18.504    40.117     0.200
    19.123    38.829     0.200
    19.605    39.305     0.200
    19.716    36.515     0.200
    20.331    37.741     0.200
    20.464    38.592     0.200
    20.499    38.720     0.200
    20.501    39.268     0.200
    20.576    37.576     0.200
    21.145    41.234     0.200
    21.145    41.553     0.200
    21.145    41.404     0.200
    21.399    39.868     0.200
    21.498    40.616     0.200
    21.888    39.732     0.200
    21.881    35.852     0.200
    21.881    36.027     0.200
    22.048    40.196     0.200
    22.215    39.137     0.200
    22.166    36.820     0.200
    22.263    39.993     0.200
    22.329    37.304     0.200
    22.315    38.145     0.200
    22.508    39.031     0.200
    22.553    38.841     0.200
    22.610    37.038     0.200
    22.835    38.656     0.200
    22.941    38.541     0.200
    22.979    36.954     0.200
    23.126    39.093     0.200
    23.162    34.023     0.200
    23.159    35.537     0.200
    23.172    39.477     0.200
    23.298    37.746     0.200
    23.262    36.135     0.200
    23.361    35.881     0.200
    23.395    37.388     0.200
    23.398    37.808     0.200
    23.497    37.504     0.200
    23.523    38.375     0.200
    23.553    36.626     0.200
    23.614    36.788     0.200
    23.702    38.438     0.200
    23.631    35.131     0.200
    23.825    37.423     0.200
    23.909    35.787     0.200
    24.350    33.338     0.200
    24.350    32.437     0.200
    24.375    35.839     0.200
    24.996    34.441     0.200
    25.334    33.476     0.200
    25.385    30.057     0.200
    25.516    32.674     0.200
    25.700    32.261     0.200
    26.099    30.268     0.200
    26.142    32.099     0.200
    26.355    30.162     0.200
    26.464    30.421     0.200
    26.495    24.940     0.200
    26.591    26.983     0.200
    26.687    28.696     0.200
    26.694    29.456     0.200
    26.853    28.322     0.200
    27.124    26.946     0.200
    27.209    24.911     0.200
    27.222    25.918     0.200
    27.244    27.927     0.200
    27.284    25.302     0.200
    27.229    27.737     0.200
    27.303    26.582     0.200
    27.325    24.744     0.200
    27.464    25.910     0.200
    27.513    24.144     0.200
    27.534    27.653     0.200
    27.638    26.550     0.200
    27.640    27.207     0.200
    27.697    26.401     0.200
    27.867    22.095     0.200
    27.827    25.456     0.200
    27.988    25.580     0.200
    28.044    24.458     0.200
    28.053    23.318     0.200
    28.064    20.773     0.200
    28.042    23.048     0.200
    28.191    24.509     0.200
    28.543    20.936     0.200
    28.690    23.371     0.200
    28.641    22.664     0.200
    28.746    19.810     0.200
    28.769    21.570     0.200
    28.921    22.348     0.200
    29.076    22.038     0.200
    29.085    21.772     0.200
    29.337    20.427     0.200
    29.337    20.837     0.200
    29.448    20.837     0.200
    29.576    21.153     0.200
    29.574    20.174     0.200
    29.647    20.132     0.200
    29.647    20.415     0.200
    29.795    20.257     0.200
    29.769    19.109     0.200
    29.851    19.616     0.200
    29.859    18.329     0.200
    29.985    17.777     0.200
    30.019    17.864     0.200
    18.314    38.372     0.200
    18.502    38.699     0.200
    18.502    39.105     0.200
    18.536    38.254     0.200
    18.536    39.064     0.200
    21.911    35.866     0.200
    21.915    35.819     0.200
    23.172    35.391     0.200
    24.335    32.360     0.200
    29.655    19.860     0.200
    29.655    19.859     0.200
    29.873    18.751     0.200
    29.873    18.747     0.200
    29.975    17.038     0.200
    29.975    17.040     0.200
    17.256    40.036     0.200
    18.239    39.964     0.200
    18.470    39.127     0.200
    18.503    38.841     0.200
    18.503    39.103     0.200
    18.503    39.821     0.200
    21.044    41.649     0.200
    21.044    36.739     0.200
    21.924    36.464     0.200
    21.927    36.416     0.200
    22.132    38.557     0.200
    23.065    36.538     0.200
    23.078    40.518     0.200
    23.268    36.903     0.200
    23.314    35.356     0.200
    23.314    36.167     0.200
    23.314    35.548     0.200
    24.011    35.329     0.200
    29.545    20.148     0.200
    29.545    20.147     0.200
    29.545    20.546     0.200
    29.946    21.364     0.200
    18.303    37.982     0.200
    18.286    37.875     0.200
    18.286    37.285     0.200
    18.321    37.968     0.200
    19.241    38.633     0.200
    21.546    33.442     0.200
    21.546    35.917     0.200
    21.546    35.237     0.200
    22.495    37.061     0.200
    23.287    33.138     0.200
    23.287    33.518     0.200
    23.414    32.659     0.200
    23.414    32.134     0.200
    23.456    36.451     0.200
    23.613    31.114     0.200
    27.812    22.014     0.200
    28.211    22.353     0.200
    29.408    17.233     0.200
    29.693    15.998     0.200
    15.011    40.788     0.200
    16.130    40.902     0.200
    18.306    39.421     0.200
    21.723    35.731     0.200
    23.087    35.161     0.200
    23.193    34.900     0.200
    23.836    36.167     0.200
    29.461    21.331     0.200
    29.604    20.157     0.200
    29.739    18.735     0.200
    30.040    17.674     0.200
    16.303    41.593     0.200
    18.256    39.688     0.200
    18.455    39.089     0.200
    18.488    38.208     0.200
    18.488    39.349     0.200
    20.661    38.305     0.200
    21.900    34.404     0.200
    21.900    35.326     0.200
    21.900    35.310     0.200
    22.230    34.421     0.200
    23.306    34.280     0.200
    23.306    35.170     0.200
    24.045    30.948     0.200
    23.982    35.173     0.200
    27.308    26.866     0.200
    29.563    19.483     0.200
    29.909    18.781     0.200
    18.176    39.208     0.200
    18.406    39.110     0.200
    18.440    38.505     0.200
    20.713    35.302     0.200
    21.008    40.717     0.200
    21.870    35.391     0.200
    21.870    35.102     0.200
    22.370    33.734     0.200
    22.990    32.009     0.200
    23.021    35.925     0.200
    23.249    35.633     0.200
    23.249    34.484     0.200
    24.001    34.336     0.200
    29.510    19.891     0.200
    29.510    19.118     0.200
    29.910    17.921     0.200
    17.229    41.791     0.200
    18.409    38.492     0.200
    18.528    37.405     0.200
    21.316    36.698     0.200
    21.870    37.867     0.200
    21.870    36.437     0.200
    23.447    35.048     0.200
    16.502    43.993     0.200
    17.339    42.304     0.200
    17.339    43.715     0.200
    18.492    40.628     0.200
    20.865    40.070     0.200
    22.024    38.230     0.200
    22.024    36.974     0.200
    22.024    38.099     0.200
    22.024    37.650     0.200
    23.275    37.010     0.200
    23.275    36.641     0.200
    24.003    35.180     0.200
    24.003    35.655     0.200
    27.709    25.429     0.200
    29.362    23.055     0.200
    18.253    40.937     0.200
    18.457    40.479     0.200
    18.491    40.406     0.200
    18.491    40.613     0.200
    19.647    40.419     0.200
    21.094    42.537     0.200
    21.094    40.607     0.200
    21.888    36.742     0.200
    21.888    36.722     0.200
    21.888    37.093     0.200
    22.177    38.698     0.200
    22.457    34.313     0.200
    23.109    38.218     0.200
    23.109    37.843     0.200
    23.311    37.962     0.200
    23.318    35.776     0.200
    23.318    36.776     0.200
    23.318    36.546     0.200
    28.101    23.860     0.200
    29.595    22.222     0.200
    29.595    21.000     0.200
    29.883    19.761     0.200
    16.221    41.749     0.200
    17.905    39.885     0.200
    18.595    38.172     0.200
    18.595    39.262     0.200
    18.702    38.249     0.200
    18.737    38.859     0.200
    18.737    39.086     0.200
    19.691    39.446     0.200
    21.448    39.348     0.200
    21.448    37.641     0.200
    22.003    35.787     0.200
    22.003    35.548     0.200
    22.542    37.180     0.200
    23.476    36.179     0.200
    23.476    33.753     0.200
    23.540    34.626     0.200
    23.679    35.117     0.200
    23.633    33.820     0.200
    23.774    36.805     0.200
    24.489    31.460     0.200
    27.789    25.245     0.200
    28.120    21.587     0.200
    29.463    18.255     0.200
    29.678    18.497     0.200
    29.809    19.302     0.200
    29.809    18.994     0.200
    14.741    42.382     0.200
    18.263    40.719     0.200
    21.501    36.724     0.200
    21.501    37.295     0.200
    21.501    37.467     0.200
    23.225    36.379     0.200
    29.391    21.703     0.200
    14.965    43.131     0.200
    16.007    44.616     0.200
    18.443    41.641     0.200
    18.443    41.192     0.200
    21.360    42.847     0.200
    21.720    37.785     0.200
    21.720    37.785     0.200
    21.720    38.519     0.200
    23.366    37.137     0.200
    23.643    38.613     0.200
    27.801    26.481     0.200
    29.606    21.419     0.200
    29.606    22.720     0.200
    29.777    20.532     0.200
    16.950    42.212     0.200
    18.277    41.581     0.200
    19.327    39.817     0.200
    19.678    40.512     0.200
    20.446    38.166     0.200
    20.446    39.695     0.200
    21.595    37.652     0.200
    21.595    37.666     0.200
    21.595    37.341     0.200
    21.949    40.949     0.200
    23.148    37.915     0.200
    23.234    36.712     0.200
    23.209    36.670     0.200
    23.209    38.010     0.200
    23.588    36.986     0.200
    24.120    34.576     0.200
    26.864    29.084     0.200
    29.545    20.684     0.200
    29.545    22.065     0.200
    29.738    22.360     0.200
    29.878    19.826     0.200
    29.878    21.076     0.200
    18.169    39.445     0.200
    18.435    39.071     0.200
    18.456    39.061     0.200
    20.951    38.898     0.200
    21.925    36.072     0.200
    21.925    36.337     0.200
    22.973    36.182     0.200
    23.259    34.206     0.200
    24.040    35.075     0.200
    29.451    19.726     0.200
    29.985    17.440     0.200
    29.985    16.354     0.200
    14.851    42.789     0.200
    18.260    41.231     0.200
    21.592    38.594     0.200
    21.592    38.524     0.200
    23.253    37.817     0.200
    18.474    40.005     0.200
    18.496    40.157     0.200
    21.928    36.628     0.200
    21.928    35.753     0.200
    21.928    36.151     0.200
    23.066    37.650     0.200
    23.321    35.807     0.200
    23.321    35.698     0.200
    16.140    42.929     0.200
    17.931    44.422     0.200
    18.274    41.052     0.200
    18.411    39.740     0.200
    18.433    39.769     0.200
    19.529    40.374     0.200
    19.836    41.694     0.200
    20.083    40.713     0.200
    20.586    39.237     0.200
    20.512    38.466     0.200
    20.512    39.497     0.200
    21.206    40.677     0.200
    21.206    40.208     0.200
    21.206    36.662     0.200
    21.206    41.927     0.200
    21.206    42.107     0.200
    21.206    42.708     0.200
    21.866    41.455     0.200
    21.790    36.767     0.200
    21.790    36.736     0.200
    21.790    37.885     0.200
    21.790    37.002     0.200
    22.383    35.459     0.200
    23.205    35.979     0.200
    23.205    37.877     0.200
    23.205    39.275     0.200
    23.239    36.587     0.200
    23.226    36.840     0.200
    23.377    36.578     0.200
    23.406    34.132     0.200
    23.406    34.811     0.200
    23.406    38.804     0.200
    23.320    36.135     0.200
    23.320    35.213     0.200
    23.328    37.739     0.200
    23.425    36.306     0.200
    23.470    39.249     0.200
    23.764    37.856     0.200
    24.455    31.889     0.200
    25.012    33.793     0.200
    25.289    31.562     0.200
    25.360    32.758     0.200
    27.798    24.980     0.200
    29.711    20.830     0.200
    29.711    21.158     0.200
    29.711    21.054     0.200
    29.743    19.857     0.200
    29.743    20.177     0.200
    29.928    19.874     0.200
    15.269    40.532     0.200
    16.263    40.330     0.200
    17.406    41.597     0.200
    18.599    38.724     0.200
    18.724    39.024     0.200
    19.731    38.072     0.200
    20.308    35.962     0.200
    22.038    36.220     0.200
    22.038    35.919     0.200
    23.778    35.734     0.200
    24.446    31.098     0.200
    25.450    30.619     0.200
    25.833    29.552     0.200
    26.801    22.048     0.200
    26.801    25.568     0.200
    29.703    17.254     0.200
    29.703    18.098     0.200
    29.919    17.769     0.200
    29.852    17.673     0.200
    29.852    17.962     0.200
    16.577    42.361     0.200
    17.275    40.540     0.200
    18.355    38.504     0.200
    18.355    38.453     0.200
    18.376    38.769     0.200
    18.636    39.031     0.200
    18.877    37.251     0.200
    18.962    37.624     0.200
    19.209    37.347     0.200
    19.500    37.752     0.200
    19.929    37.445     0.200
    20.616    39.037     0.200
    20.616    38.022     0.200
    21.109    38.338     0.200
    21.109    37.565     0.200
    21.258    40.586     0.200
    21.981    35.843     0.200
    22.101    37.796     0.200
    22.650    36.886     0.200
    22.650    35.788     0.200
    22.650    36.187     0.200
    22.853    36.685     0.200
    22.853    34.736     0.200
    22.853    36.213     0.200
    22.853    36.013     0.200
    22.916    35.879     0.200
    23.024    35.617     0.200
    23.767    34.149     0.200
    23.902    34.161     0.200
    23.902    32.040     0.200
    24.318    34.715     0.200
    24.872    33.361     0.200
    27.428    23.694     0.200
    27.415    24.775     0.200
    27.497    24.923     0.200
    27.610    22.090     0.200
    27.593    24.703     0.200
    27.713    24.906     0.200
    27.764    25.602     0.200
    28.333    22.170     0.200
    28.939    21.595     0.200
    29.114    19.950     0.200
    29.115    21.184     0.200
    29.115    22.434     0.200
    29.617    18.322     0.200
    14.768    42.429     0.200
    14.893    42.289     0.200
    15.265    43.991     0.200
    15.919    44.249     0.200
    16.047    42.353     0.200
    16.266    43.759     0.200
    16.470    43.794     0.200
    16.729    43.425     0.200
    16.806    42.786     0.200
    16.808    43.464     0.200
    16.817    43.525     0.200
    17.008    43.396     0.200
    17.444    44.922     0.200
    17.708    43.403     0.200
    18.130    43.164     0.200
    18.295    41.360     0.200
    18.295    42.797     0.200
    18.305    42.523     0.200
    18.564    39.705     0.200
    18.564    40.299     0.200
    18.877    41.380     0.200
    19.068    41.358     0.200
    19.360    40.055     0.200
    19.471    40.536     0.200
    19.635    39.498     0.200
    19.669    39.996     0.200
    19.669    39.738     0.200
    19.920    39.952     0.200
    20.163    41.056     0.200
    20.289    39.715     0.200
    20.380    38.545     0.200
    20.317    41.249     0.200
    20.317    40.553     0.200
    20.526    40.617     0.200
    20.692    40.805     0.200
    20.767    39.699     0.200
    21.133    40.559     0.200
    21.332    39.931     0.200
    21.332    41.204     0.200
    21.332    41.939     0.200
    21.332    42.501     0.200
    21.332    38.165     0.200
    21.332    40.236     0.200
    21.392    40.469     0.200
    21.643    37.298     0.200
    21.643    37.361     0.200
    21.643    37.752     0.200
    21.838    38.578     0.200
    21.796    40.185     0.200
    22.021    39.492     0.200
    22.010    40.671     0.200
    22.357    40.205     0.200
    22.618    39.435     0.200
    22.647    40.389     0.200
    22.760    37.668     0.200
    23.019    40.039     0.200
    23.183    36.634     0.200
    23.248    36.181     0.200
    23.289    35.863     0.200
    23.289    35.558     0.200
    23.271    38.086     0.200
    23.308    36.414     0.200
    23.308    35.984     0.200
    23.308    36.086     0.200
    23.571    37.306     0.200
    23.507    37.208     0.200
    23.507    35.504     0.200
    23.507    37.801     0.200
    23.507    35.348     0.200
    23.507    36.348     0.200
    23.548    36.783     0.200
    24.202    34.180     0.200
    24.202    33.945     0.200
    24.648    33.487     0.200
    24.648    32.503     0.200
    24.648    34.292     0.200
    24.648    33.745     0.200
    25.107    33.880     0.200
    25.462    31.244     0.200
    25.524    34.809     0.200
    25.541    31.925     0.200
    25.861    32.186     0.200
    26.095    33.193     0.200
    26.219    32.956     0.200
    26.219    33.308     0.200
    26.662    28.240     0.200
    26.836    28.746     0.200
    26.916    27.918     0.200
    26.916    27.410     0.200
    26.940    29.396     0.200
    27.301    28.278     0.200
    27.368    26.891     0.200
    27.541    27.483     0.200
    27.810    27.342     0.200
    27.789    24.948     0.200
    27.789    24.386     0.200
    27.851    27.655     0.200
    27.947    23.738     0.200
    28.121    23.615     0.200
    28.164    27.707     0.200
    28.349    24.555     0.200
    28.295    25.115     0.200
    28.834    21.888     0.200
    29.048    23.781     0.200
    29.048    21.421     0.200
    29.048    23.390     0.200
    29.209    23.306     0.200
    29.320    22.173     0.200
    29.553    21.392     0.200
    29.553    20.150     0.200
    29.566    21.352     0.200
    29.591    21.919     0.200
    29.591    19.482     0.200
    29.625    20.859     0.200
    29.653    21.985     0.200
    29.809    18.753     0.200
    29.809    20.440     0.200
    29.809    20.151     0.200
    29.722    20.321     0.200
    29.828    18.791     0.200
    29.846    19.382     0.200
    29.840    20.444     0.200
    29.841    20.914     0.200
    29.841    20.235     0.200
    29.841    20.625     0.200
    29.841    21.133     0.200
    29.992    19.028     0.200
    29.992    19.981     0.200
    15.951    43.396     0.200
    17.008    40.937     0.200
    18.280    39.791     0.200
    18.557    38.366     0.200
    19.362    39.792     0.200
    21.339    38.668     0.200
    21.339    35.676     0.200
    21.646    36.612     0.200
    21.646    36.437     0.200
    23.190    35.920     0.200
    23.315    35.813     0.200
    23.296    34.115     0.200
    23.296    34.885     0.200
    23.296    35.588     0.200
    23.515    35.329     0.200
    23.569    37.300     0.200
    29.553    20.970     0.200
    29.553    19.939     0.200
    29.560    19.783     0.200
    29.565    19.719     0.200
    29.848    19.871     0.200
    29.802    18.366     0.200
    29.802    19.616     0.200
    29.802    18.366     0.200
    29.991    18.809     0.200
    29.991    20.048     0.200
    14.893    41.815     0.200
    15.956    42.532     0.200
    18.317    40.362     0.200
    18.338    40.724     0.200
    18.578    37.178     0.200
    19.360    39.407     0.200
    20.396    37.915     0.200
    21.316    38.322     0.200
    21.316    35.945     0.200
    21.316    41.576     0.200
    21.639    36.978     0.200
    22.083    40.452     0.200
    22.372    40.109     0.200
    22.744    39.109     0.200
    23.292    35.359     0.200
    23.292    36.222     0.200
    23.292    36.623     0.200
    23.329    40.389     0.200
    23.276    35.774     0.200
    23.276    36.206     0.200
    23.276    37.004     0.200
    23.491    36.792     0.200
    23.581    37.448     0.200
    24.187    33.575     0.200
    24.638    33.366     0.200
    24.638    31.266     0.200
    26.932    26.095     0.200
    27.775    24.702     0.200
    29.051    22.709     0.200
    29.558    19.989     0.200
    29.558    19.373     0.200
    29.708    21.225     0.200
    29.565    20.208     0.200
    29.571    20.144     0.200
    29.826    18.757     0.200
    29.826    21.067     0.200
    29.825    18.862     0.200
    29.825    19.676     0.200
    29.844    17.957     0.200
    29.997    20.103     0.200
    29.997    19.872     0.200
    18.314    42.039     0.200
    21.311    42.758     0.200
    21.311    38.834     0.200
    21.639    38.139     0.200
    23.287    37.511     0.200
    23.273    37.226     0.200
    23.584    38.293     0.200
    29.560    21.812     0.200
    29.560    21.582     0.200
    29.821    21.706     0.200
    29.830    21.717     0.200
    21.009    38.465     0.200
    21.669    37.089     0.200
    21.669    37.261     0.200
    23.287    37.747     0.200
    23.292    36.263     0.200
    23.607    37.038     0.200
    29.816    19.376     0.200
    29.832    19.989     0.200
    14.807    40.116     0.200
    15.986    42.190     0.200
    18.300    39.557     0.200
    18.363    39.221     0.200
    18.385    39.790     0.200
    19.399    39.263     0.200
    20.380    37.464     0.200
    20.380    38.214     0.200
    21.037    38.984     0.200
    21.334    39.651     0.200
    21.334    38.325     0.200
    21.334    38.881     0.200
    21.683    36.309     0.200
    22.247    37.448     0.200
    22.391    39.039     0.200
    22.768    36.243     0.200
    23.330    33.740     0.200
    23.315    36.329     0.200
    23.315    34.654     0.200
    23.315    35.954     0.200
    23.320    35.056     0.200
    23.320    35.496     0.200
    23.320    36.596     0.200
    23.516    36.869     0.200
    23.516    34.189     0.200
    23.597    36.866     0.200
    24.622    32.938     0.200
    24.622    32.528     0.200
    25.525    32.178     0.200
    27.817    24.915     0.200
    28.163    20.809     0.200
    29.606    19.398     0.200
    29.587    19.131     0.200
    29.587    20.111     0.200
    29.594    19.785     0.200
    29.712    20.341     0.200
    29.805    19.119     0.200
    29.775    20.016     0.200
    30.025    17.149     0.200
    30.025    19.149     0.200
    15.994    41.760     0.200
    18.287    39.707     0.200
    18.357    38.685     0.200
    18.379    39.230     0.200
    20.397    37.280     0.200
    21.020    39.652     0.200
    21.317    37.959     0.200
    21.317    40.600     0.200
    21.683    36.795     0.200
    21.683    36.092     0.200
    21.683    36.670     0.200
    23.206    35.592     0.200
    23.299    35.038     0.200
    23.299    35.612     0.200
    23.310    34.826     0.200
    23.310    35.287     0.200
    23.499    36.578     0.200
    23.610    36.085     0.200
    24.210    33.078     0.200
    24.327    29.693     0.200
    24.609    30.828     0.200
    26.928    28.062     0.200
    29.595    19.614     0.200
    29.825    18.801     0.200
    29.822    18.050     0.200
    30.034    17.910     0.200
    30.034    18.864     0.200
    15.087    40.158     0.200
    16.152    40.231     0.200
    17.177    39.907     0.200
    17.177    39.766     0.200
    18.502    37.930     0.200
    18.328    39.039     0.200
    18.328    37.890     0.200
    18.460    39.174     0.200
    18.481    39.245     0.200
    19.555    39.116     0.200
    19.808    36.067     0.200
    20.472    36.216     0.200
    21.247    40.230     0.200
    21.247    36.464     0.200
    21.247    37.910     0.200
    21.247    35.667     0.200
    21.825    35.200     0.200
    21.903    38.656     0.200
    22.317    39.376     0.200
    22.322    38.528     0.200
    22.944    38.204     0.200
    23.251    34.358     0.200
    23.251    35.483     0.200
    23.284    35.497     0.200
    23.278    34.464     0.200
    23.373    34.455     0.200
    23.373    33.853     0.200
    23.423    35.181     0.200
    23.452    36.044     0.200
    23.452    33.110     0.200
    23.757    35.774     0.200
    24.239    31.144     0.200
    24.225    32.618     0.200
    25.479    31.482     0.200
    27.500    25.595     0.200
    27.741    24.488     0.200
    27.939    22.971     0.200
    29.753    18.581     0.200
    29.885    16.713     0.200
    29.885    16.854     0.200
    29.751    18.928     0.200
    29.751    19.080     0.200
    29.751    18.029     0.200
    15.130    39.163     0.200
    17.423    39.447     0.200
    17.423    39.217     0.200
    17.423    37.547     0.200
    18.701    36.629     0.200
    18.781    37.058     0.200
    18.803    37.350     0.200
    18.803    36.919     0.200
    19.709    37.067     0.200
    20.249    35.958     0.200
    21.139    36.719     0.200
    21.297    35.293     0.200
    21.555    36.527     0.200
    21.555    37.307     0.200
    21.555    35.717     0.200
    22.042    33.421     0.200
    22.042    33.441     0.200
    23.039    33.312     0.200
    23.588    31.406     0.200
    23.685    34.669     0.200
    23.790    30.241     0.200
    23.790    30.931     0.200
    28.315    20.528     0.200
    29.355    15.598     0.200
    29.355    17.399     0.200
    29.359    17.327     0.200
    29.570    14.844     0.200
    17.915    40.649     0.200
    17.915    40.759     0.200
    19.329    41.117     0.200
    21.348    42.957     0.200
    21.348    41.660     0.200
    21.348    42.692     0.200
    21.348    42.512     0.200
    21.614    37.847     0.200
    21.614    37.784     0.200
    21.816    42.199     0.200
    21.912    38.278     0.200
    22.029    40.955     0.200
    22.397    40.710     0.200
    22.416    40.553     0.200
    23.033    40.239     0.200
    23.277    36.941     0.200
    23.277    36.675     0.200
    23.319    37.554     0.200
    23.505    39.769     0.200
    23.519    38.124     0.200
    23.519    38.421     0.200
    23.519    36.429     0.200
    23.519    37.187     0.200
    24.678    34.348     0.200
    24.678    34.731     0.200
    25.125    33.224     0.200
    25.125    33.388     0.200
    25.268    34.116     0.200
    25.540    34.658     0.200
    26.113    33.157     0.200
    26.236    33.409     0.200
    26.236    33.034     0.200
    26.236    33.933     0.200
    27.270    28.155     0.200
    27.380    28.168     0.200
    27.509    27.464     0.200
    27.684    28.420     0.200
    27.684    28.623     0.200
    27.684    28.724     0.200
    27.781    26.188     0.200
    27.870    27.544     0.200
    28.316    25.938     0.200
    28.538    24.074     0.200
    28.538    24.183     0.200
    28.619    24.342     0.200
    28.619    24.772     0.200
    28.811    24.560     0.200
    28.811    25.404     0.200
    28.797    25.326     0.200
    28.797    25.498     0.200
    28.797    26.233     0.200
    29.372    23.044     0.200
    29.576    20.932     0.200
    29.576    21.510     0.200
    29.576    21.268     0.200
    29.641    22.409     0.200
    29.671    22.924     0.200
    29.820    20.197     0.200
    29.820    19.924     0.200
    29.734    22.095     0.200
    29.775    22.628     0.200
    29.810    22.375     0.200
    29.959    21.162     0.200
    29.959    20.865     0.200
    20.293    40.684     0.200
    20.684    40.550     0.200
    20.941    40.411     0.200
    20.950    40.001     0.200
    21.107    40.333     0.200
    21.348    40.621     0.200
    21.614    38.323     0.200
    21.614    38.206     0.200
    21.700    39.015     0.200
    23.277    37.534     0.200
    24.678    33.442     0.200
    28.619    23.912     0.200
    28.811    22.958     0.200
    29.521    22.260     0.200
    29.641    19.924     0.200
    29.795    20.301     0.200
    29.795    20.005     0.200
    29.858    20.306     0.200
    29.858    20.548     0.200
    16.940    44.732     0.200
    21.354    43.294     0.200
    21.046    42.006     0.200
    21.354    40.826     0.200
    21.576    40.023     0.200
    23.252    38.058     0.200
    23.519    38.486     0.200
    24.709    33.134     0.200
    17.957    43.320     0.200
    18.201    42.923     0.200
    19.376    41.401     0.200
    21.314    43.986     0.200
    21.314    44.197     0.200
    21.655    38.566     0.200
    21.655    38.605     0.200
    21.951    38.849     0.200
    21.990    43.032     0.200
    22.368    41.283     0.200
    22.382    42.228     0.200
    23.002    41.617     0.200
    23.286    37.669     0.200
    23.286    37.520     0.200
    23.292    38.007     0.200
    23.491    38.175     0.200
    23.491    38.479     0.200
    23.491    38.284     0.200
    24.626    34.897     0.200
    25.316    34.180     0.200
    26.077    34.795     0.200
    26.200    34.918     0.200
    26.200    34.613     0.200
    27.319    29.513     0.200
    27.353    28.717     0.200
    27.559    28.711     0.200
    27.784    26.377     0.200
    27.831    29.319     0.200
    28.367    26.375     0.200
    28.570    25.445     0.200
    28.570    25.062     0.200
    28.655    25.818     0.200
    29.643    22.382     0.200
    29.608    21.988     0.200
    29.608    22.097     0.200
    29.706    22.547     0.200
    29.742    23.743     0.200
    29.823    22.786     0.200
    29.827    21.440     0.200
    29.855    21.267     0.200
    29.855    21.103     0.200
    30.012    21.483     0.200
    30.012    21.741     0.200
    29.823    22.833     0.200
    29.635    23.524     0.200
    30.012    21.585     0.200
    30.012    20.983     0.200
    18.352    41.848     0.200
    20.251    40.316     0.200
    20.642    40.689     0.200
    20.906    39.952     0.200
    20.909    39.175     0.200
    21.014    42.796     0.200
    21.314    42.705     0.200
    21.655    39.152     0.200
    21.655    39.355     0.200
    22.227    40.827     0.200
    23.322    39.837     0.200
    24.548    36.446     0.200
    24.626    34.233     0.200
    26.858    30.287     0.200
    27.179    29.036     0.200
    27.635    27.674     0.200
    29.855    19.931     0.200
    30.012    19.866     0.200
    17.957    43.127     0.200
    18.199    42.883     0.200
    21.313    43.896     0.200
    21.653    38.588     0.200
    23.284    37.475     0.200
    23.490    38.197     0.200
    24.627    34.890     0.200
    28.571    25.229     0.200
    28.656    25.839     0.200
    29.609    22.038     0.200
    29.856    21.272     0.200
    30.010    21.591     0.200
    29.822    22.828     0.200
    19.374    41.336     0.200
    21.313    43.708     0.200
    21.313    44.271     0.200
    21.653    39.143     0.200
    21.778    43.537     0.200
    21.949    38.388     0.200
    21.989    42.759     0.200
    22.367    42.007     0.200
    23.001    41.684     0.200
    23.290    38.631     0.200
    23.284    37.608     0.200
    23.327    41.608     0.200
    23.469    40.980     0.200
    23.490    39.142     0.200
    23.490    37.799     0.200
    23.490    38.658     0.200
    25.314    34.715     0.200
    25.505    36.353     0.200
    26.076    34.852     0.200
    27.317    29.547     0.200
    27.557    28.744     0.200
    27.782    26.315     0.200
    27.831    29.624     0.200
    28.366    26.400     0.200
    28.571    25.565     0.200
    28.656    25.660     0.200
    29.609    21.593     0.200
    29.609    22.233     0.200
    29.642    22.814     0.200
    29.634    23.909     0.200
    29.828    21.342     0.200
    29.856    21.421     0.200
    29.705    21.975     0.200
    29.822    22.812     0.200
    30.010    21.708     0.200
    30.010    21.310     0.200
    20.250    40.040     0.200
    20.906    39.696     0.200
    21.013    39.880     0.200
    21.066    39.826     0.200
    21.313    40.302     0.200
    22.226    40.534     0.200
    23.321    40.310     0.200
    23.490    36.541     0.200
    24.627    34.343     0.200
    27.178    28.747     0.200
    28.571    23.050     0.200
    28.656    22.941     0.200
    29.856    20.280     0.200
    30.010    19.732     0.200
    17.004    42.187     0.200
    19.367    41.614     0.200
    21.310    43.742     0.200
    21.310    44.452     0.200
    21.645    38.925     0.200
    21.941    38.777     0.200
    21.987    42.796     0.200
    22.378    42.653     0.200
    22.363    42.550     0.200
    22.997    41.961     0.200
    23.286    39.078     0.200
    23.276    38.091     0.200
    23.323    40.547     0.200
    23.486    39.748     0.200
    23.486    40.157     0.200
    25.502    36.083     0.200
    26.073    34.755     0.200
    26.196    35.414     0.200
    27.828    30.041     0.200
    27.774    26.900     0.200
    28.360    26.565     0.200
    29.613    21.546     0.200
    30.005    21.765     0.200
    30.005    21.165     0.200
    30.005    21.625     0.200
    30.005    20.965     0.200
    29.819    22.737     0.200
    18.341    41.863     0.200
    20.249    41.573     0.200
    20.640    39.479     0.200
    20.905    40.480     0.200
    20.907    40.120     0.200
    20.903    41.174     0.200
    21.009    40.932     0.200
    21.310    40.942     0.200
    21.645    38.374     0.200
    21.645    37.954     0.200
    22.222    39.644     0.200
    23.276    37.381     0.200
    23.317    38.618     0.200
    23.486    38.146     0.200
    24.544    36.377     0.200
    24.629    34.761     0.200
    25.450    33.288     0.200
    26.856    30.570     0.200
    26.874    29.748     0.200
    27.631    27.428     0.200
    28.575    24.299     0.200
    29.566    22.587     0.200
    29.831    22.158     0.200
    29.831    21.728     0.200
    29.819    22.017     0.200
    30.005    20.305     0.200
    17.056    43.745     0.200
    17.056    42.825     0.200
    18.373    42.372     0.200
    19.253    44.606     0.200
    19.432    41.710     0.200
    21.259    44.691     0.200
    21.702    39.023     0.200
    21.930    42.810     0.200
    21.994    39.710     0.200
    22.319    42.119     0.200
    22.949    41.403     0.200
    23.244    40.322     0.200
    23.287    38.627     0.200
    25.375    34.957     0.200
    26.020    34.555     0.200
    28.432    26.484     0.200
    28.623    24.406     0.200
    29.879    20.997     0.200
    29.767    23.005     0.200
    30.079    20.259     0.200
    17.056    42.466     0.200
    20.965    39.355     0.200
    21.702    39.193     0.200
    21.702    38.994     0.200
    23.287    37.418     0.200
    23.270    37.486     0.200
    24.492    34.316     0.200
    29.640    21.362     0.200
    29.767    20.515     0.200
    29.879    21.116     0.200
    15.315    34.813     0.200
    21.283    44.139     0.200
    21.283    44.428     0.200
    21.612    38.353     0.200
    21.751    43.743     0.200
    21.965    42.618     0.200
    22.968    41.859     0.200
    23.233    37.547     0.200
    23.454    37.841     0.200
    24.633    34.722     0.200
    25.475    36.535     0.200
    26.048    34.968     0.200
    26.171    34.498     0.200
    26.171    34.716     0.200
    28.604    24.274     0.200
    28.604    24.774     0.200
    28.684    24.822     0.200
    28.684    24.951     0.200
    29.641    21.672     0.200
    29.641    21.863     0.200
    29.606    23.818     0.200
    29.990    22.406     0.200
    29.990    21.687     0.200
    29.990    21.207     0.200
    29.793    23.045     0.200
    21.612    38.478     0.200
    21.906    37.747     0.200
    23.233    36.859     0.200
    23.254    38.010     0.200
    23.292    40.372     0.200
    23.454    36.181     0.200
    25.282    33.844     0.200
    27.315    27.924     0.200
    27.731    26.261     0.200
    28.340    25.958     0.200
    29.606    24.193     0.200
    29.793    23.001     0.200
    29.990    20.804     0.200
    29.641    21.273     0.200
    20.230    41.155     0.200
    20.621    40.170     0.200
    20.978    42.679     0.200
    21.612    38.478     0.200
    21.612    39.138     0.200
    23.233    38.629     0.200
    23.288    38.598     0.200
    23.454    38.482     0.200
    24.633    34.515     0.200
    26.859    29.934     0.200
    26.859    29.535     0.200
    27.153    29.744     0.200
    28.684    24.424     0.200
    29.551    22.748     0.200
    29.793    22.259     0.200
    29.860    20.650     0.200
    29.860    20.791     0.200
    18.308    42.722     0.200
    21.041    41.266     0.200
    21.592    38.909     0.200
    21.592    39.143     0.200
    23.260    38.506     0.200
    28.540    25.582     0.200
    17.048    43.166     0.200
    18.376    42.267     0.200
    19.284    43.068     0.200
    19.415    41.440     0.200
    21.291    44.101     0.200
    21.691    39.281     0.200
    21.754    43.702     0.200
    21.985    38.946     0.200
    22.350    40.785     0.200
    23.275    39.295     0.200
    23.299    37.909     0.200
    23.475    40.373     0.200
    23.475    40.219     0.200
    23.475    39.357     0.200
    25.356    34.306     0.200
    26.053    34.688     0.200
    27.792    27.578     0.200
    28.409    26.181     0.200
    28.591    24.206     0.200
    29.629    24.030     0.200
    29.629    23.039     0.200
    29.633    22.828     0.200
    29.610    24.023     0.200
    29.847    21.197     0.200
    29.800    22.751     0.200
    30.053    21.987     0.200
    20.996    41.311     0.200
    21.291    40.281     0.200
    23.301    39.094     0.200
    23.299    38.879     0.200
    23.475    36.838     0.200
    24.585    33.289     0.200
    28.591    23.857     0.200
    17.048    42.012     0.200
    18.378    42.380     0.200
    19.412    41.614     0.200
    19.293    42.910     0.200
    19.839    39.036     0.200
    21.300    42.583     0.200
    21.300    43.646     0.200
    21.690    38.313     0.200
    21.690    38.336     0.200
    21.985    38.493     0.200
    21.972    41.920     0.200
    22.359    40.929     0.200
    22.736    39.029     0.200
    22.990    41.243     0.200
    23.304    37.196     0.200
    23.283    37.940     0.200
    23.319    40.520     0.200
    23.456    39.903     0.200
    23.483    38.217     0.200
    23.483    38.405     0.200
    23.483    37.971     0.200
    24.592    34.917     0.200
    25.491    35.859     0.200
    26.184    34.026     0.200
    27.663    28.544     0.200
    27.798    26.255     0.200
    27.850    29.824     0.200
    27.814    28.757     0.200
    28.404    26.274     0.200
    28.582    24.372     0.200
    28.582    24.743     0.200
    28.670    25.271     0.200
    28.847    24.748     0.200
    28.775    24.794     0.200
    29.104    24.516     0.200
    29.304    23.701     0.200
    29.620    21.084     0.200
    29.620    21.490     0.200
    29.620    21.385     0.200
    29.572    22.954     0.200
    29.619    23.489     0.200
    29.698    22.478     0.200
    29.838    21.341     0.200
    29.869    20.891     0.200
    29.729    23.443     0.200
    29.741    22.611     0.200
    29.808    22.595     0.200
    30.048    21.089     0.200
    30.048    21.390     0.200
    20.621    41.382     0.200
    21.004    42.164     0.200
    21.300    42.814     0.200
    21.690    39.075     0.200
    21.690    38.575     0.200
    23.304    36.907     0.200
    23.483    37.584     0.200
    24.592    35.124     0.200
    25.436    34.730     0.200
    26.861    30.496     0.200
    27.161    29.129     0.200
    27.663    27.583     0.200
    27.703    29.322     0.200
    27.814    28.339     0.200
    28.339    27.005     0.200
    28.582    24.192     0.200
    28.670    24.619     0.200
    28.775    25.587     0.200
    28.847    24.318     0.200
    29.104    23.934     0.200
    29.304    23.572     0.200
    29.572    23.083     0.200
    29.838    21.282     0.200
    29.869    20.570     0.200
    29.808    22.603     0.200
    30.048    20.941     0.200
    20.929    42.940     0.200
    21.762    38.422     0.200
    21.762    38.649     0.200
    23.306    38.537     0.200
    28.662    23.628     0.200
    20.999    40.757     0.200
    21.294    41.656     0.200
    23.309    36.832     0.200
    23.305    39.028     0.200
    23.479    36.820     0.200
    24.580    34.062     0.200
    25.429    33.045     0.200
    26.854    29.200     0.200
    27.153    29.515     0.200
    28.588    24.317     0.200
    29.116    23.065     0.200
    29.876    20.185     0.200
    30.061    20.328     0.200
    15.882    45.954     0.200
    17.976    42.607     0.200
    18.193    43.126     0.200
    19.388    41.285     0.200
    21.296    43.819     0.200
    21.296    44.075     0.200
    21.664    38.533     0.200
    21.664    38.522     0.200
    21.959    37.783     0.200
    21.971    42.854     0.200
    22.352    41.897     0.200
    22.365    42.135     0.200
    22.728    39.905     0.200
    22.984    41.592     0.200
    23.282    37.396     0.200
    23.282    36.943     0.200
    23.275    37.817     0.200
    23.312    40.291     0.200
    23.475    38.181     0.200
    23.475    37.783     0.200
    23.475    38.743     0.200
    24.607    37.057     0.200
    25.329    33.651     0.200
    25.488    36.359     0.200
    26.058    34.718     0.200
    26.182    34.849     0.200
    26.182    34.199     0.200
    27.332    29.273     0.200
    27.573    28.164     0.200
    27.777    26.381     0.200
    27.813    29.667     0.200
    28.382    26.217     0.200
    28.588    24.856     0.200
    28.588    25.144     0.200
    29.081    24.400     0.200
    29.081    24.164     0.200
    29.081    24.674     0.200
    29.626    23.197     0.200
    29.626    22.709     0.200
    29.626    23.950     0.200
    29.616    23.678     0.200
    29.690    22.357     0.200
    29.873    21.068     0.200
    29.873    21.396     0.200
    29.805    22.716     0.200
    30.028    21.413     0.200
    30.028    20.913     0.200
    30.028    20.512     0.200
    30.028    21.672     0.200
    29.805    22.573     0.200
    20.623    39.505     0.200
    20.890    40.241     0.200
    20.997    41.460     0.200
    21.048    40.839     0.200
    21.296    43.395     0.200
    23.282    37.593     0.200
    23.304    39.508     0.200
    23.475    37.553     0.200
    24.530    37.903     0.200
    27.160    30.023     0.200
    27.684    26.886     0.200
    28.588    23.943     0.200
    28.673    24.198     0.200
    29.081    24.014     0.200
    29.527    22.706     0.200
    29.873    20.826     0.200
    17.064    42.779     0.200
    21.264    44.165     0.200
    21.725    43.534     0.200
    21.933    42.496     0.200
    22.332    42.481     0.200
    22.954    41.944     0.200
    23.450    39.494     0.200
    26.024    34.874     0.200
    26.147    35.068     0.200
    27.775    29.863     0.200
    28.618    25.260     0.200
    29.656    22.272     0.200
    29.660    22.231     0.200
    30.084    21.435     0.200
    17.064    43.319     0.200
    18.382    42.337     0.200
    19.258    43.913     0.200
    19.439    41.502     0.200
    21.709    38.701     0.200
    22.002    39.386     0.200
    22.325    42.122     0.200
    22.702    40.314     0.200
    23.295    38.293     0.200
    23.250    39.623     0.200
    23.285    41.309     0.200
    23.450    39.285     0.200
    27.785    25.405     0.200
    28.437    26.391     0.200
    29.656    22.662     0.200
    29.874    21.321     0.200
    29.771    23.223     0.200
    30.084    21.576     0.200
    20.190    41.216     0.200
    20.581    41.752     0.200
    20.844    41.040     0.200
    20.970    42.099     0.200
    21.008    42.013     0.200
    21.264    42.114     0.200
    21.600    39.949     0.200
    23.295    37.112     0.200
    23.275    39.755     0.200
    23.450    37.975     0.200
    24.552    34.574     0.200
    28.618    23.810     0.200
    17.000    42.302     0.200
    28.581    24.675     0.200
    29.619    22.562     0.200
    30.005    21.733     0.200
    15.332    41.772     0.200
    18.336    42.315     0.200
    19.365    41.107     0.200
    21.304    43.276     0.200
    21.642    38.832     0.200
    21.937    38.588     0.200
    22.357    41.789     0.200
    23.270    37.734     0.200
    23.280    39.417     0.200
    25.306    33.775     0.200
    27.309    29.398     0.200
    28.359    26.542     0.200
    29.813    22.370     0.200
    30.005    22.134     0.200
    17.000    42.732     0.200
    21.003    41.860     0.200
    23.270    38.203     0.200
    28.581    24.425     0.200
    17.071    42.999     0.200
    19.439    41.661     0.200
    21.287    43.801     0.200
    21.714    38.807     0.200
    21.747    42.660     0.200
    21.956    41.941     0.200
    22.008    38.575     0.200
    22.348    42.014     0.200
    22.726    39.906     0.200
    22.978    41.168     0.200
    23.274    38.714     0.200
    23.309    41.399     0.200
    23.314    36.938     0.200
    23.474    39.380     0.200
    23.474    39.184     0.200
    25.380    34.130     0.200
    25.477    36.343     0.200
    26.169    34.619     0.200
    27.383    29.353     0.200
    27.797    29.357     0.200
    27.805    26.334     0.200
    28.432    26.108     0.200
    28.595    24.918     0.200
    28.684    25.389     0.200
    28.767    25.204     0.200
    29.131    23.750     0.200
    29.131    24.961     0.200
    29.633    21.999     0.200
    29.633    22.288     0.200
    29.637    22.259     0.200
    29.851    21.357     0.200
    29.884    21.396     0.200
    29.794    22.719     0.200
    30.076    21.524     0.200
    30.076    21.625     0.200
    17.996    41.375     0.200
    18.396    41.762     0.200
    20.211    40.325     0.200
    20.602    40.659     0.200
    20.865    40.112     0.200
    20.871    40.767     0.200
    20.994    41.758     0.200
    21.030    40.753     0.200
    21.287    42.531     0.200
    21.622    40.941     0.200
    21.714    38.557     0.200
    22.470    39.976     0.200
    23.298    39.218     0.200
    23.314    37.638     0.200
    23.474    36.813     0.200
    24.566    34.724     0.200
    24.520    36.929     0.200
    26.914    29.858     0.200
    26.914    30.139     0.200
    27.144    29.644     0.200
    27.608    28.125     0.200
    28.114    26.583     0.200
    28.595    24.598     0.200
    28.684    24.846     0.200
    28.767    22.997     0.200
    29.131    23.582     0.200
    29.551    22.030     0.200
    29.638    22.716     0.200
    29.851    21.646     0.200
    29.794    22.083     0.200
    29.794    22.462     0.200
    29.884    21.216     0.200
    30.076    21.145     0.200
    17.059    42.770     0.200
    21.286    44.242     0.200
    21.957    42.486     0.200
    22.976    41.755     0.200
    24.573    34.159     0.200
    20.992    41.866     0.200
    21.286    41.722     0.200
    21.703    39.598     0.200
    21.703    39.278     0.200
    23.297    37.737     0.200
    23.305    38.101     0.200
    23.472    38.097     0.200
    24.573    35.049     0.200
    28.596    25.268     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     3.166    18.166     0.200
     4.341    17.453     0.200
     4.079    18.510     0.200
     4.197    21.134     0.200
     4.143    19.764     0.200
     5.523    22.665     0.200
     5.801    21.420     0.200
     5.751    23.002     0.200
     5.957    23.601     0.200
     6.110    23.813     0.200
     6.568    26.471     0.200
     6.574    24.397     0.200
     7.488    24.731     0.200
     7.503    25.561     0.200
     7.628    25.094     0.200
     8.420    28.854     0.200
     8.532    28.554     0.200
     9.270    27.933     0.200
     9.547    29.707     0.200
     9.790    24.869     0.200
     9.560    29.547     0.200
     9.646    30.543     0.200
     9.870    30.930     0.200
    12.488    32.378     0.200
    16.019    37.176     0.200
    16.486    40.722     0.200
    17.725    40.268     0.200
    20.164    41.801     0.200
     4.285    20.044     0.200
     6.146    24.326     0.200
     6.701    24.846     0.200
     8.132    22.146     0.200
     8.132    26.146     0.200
     8.627    29.375     0.200
     9.276    28.792     0.200
    10.545    30.989     0.200
    12.400    31.344     0.200
    16.357    36.158     0.200
    16.281    40.050     0.200
    19.966    42.048     0.200
     3.284    20.587     0.200
     4.179    21.143     0.200
     4.282    20.947     0.200
     5.694    21.470     0.200
     5.831    23.362     0.200
     6.120    24.495     0.200
     6.911    25.261     0.200
     6.704    25.674     0.200
     7.475    24.375     0.200
     7.802    25.861     0.200
     8.084    24.069     0.200
     8.590    29.665     0.200
     9.445    29.688     0.200
     9.720    31.479     0.200
     9.893    31.462     0.200
     9.808    31.460     0.200
    10.140    33.084     0.200
    10.616    29.028     0.200
    10.801    28.863     0.200
    12.468    32.409     0.200
    17.088    38.503     0.200
     2.930    19.646     0.200
     3.241    19.025     0.200
     4.075    20.586     0.200
     5.670    23.073     0.200
     6.246    24.948     0.200
     6.684    23.835     0.200
     7.790    27.028     0.200
     8.338    26.043     0.200
     8.766    28.539     0.200
     9.062    29.587     0.200
     9.990    30.262     0.200
    10.041    31.669     0.200
    10.053    31.524     0.200
    10.257    29.148     0.200
    17.273    42.267     0.200
     3.125    18.585     0.200
     4.055    19.334     0.200
     5.860    22.576     0.200
     5.860    23.076     0.200
     6.518    25.896     0.200
     7.505    26.070     0.200
     8.122    23.975     0.200
     8.310    27.979     0.200
     8.310    28.679     0.200
     9.419    30.037     0.200
     9.419    30.337     0.200
     9.589    28.054     0.200
     9.512    30.953     0.200
     9.525    30.803     0.200
    10.719    27.866     0.200
    10.719    28.366     0.200
    12.555    32.437     0.200
    12.555    32.937     0.200
    14.077    33.984     0.200
    15.537    37.138     0.200
    16.548    40.844     0.200
    16.606    38.172     0.200
    18.689    41.858     0.200
    20.163    44.655     0.200
    20.385    42.062     0.200
     3.422    17.454     0.200
     3.422    17.954     0.200
     4.267    19.595     0.200
     6.864    25.796     0.200
     6.864    25.296     0.200
     8.144    23.352     0.200
     8.131    26.508     0.200
     8.131    26.908     0.200
     8.885    27.709     0.200
     9.207    29.847     0.200
    10.061    32.982     0.200
    10.145    31.004     0.200
    10.132    31.451     0.200
    17.388    40.473     0.200
     3.080    12.582     0.200
     3.886    18.973     0.200
     4.168    19.491     0.200
     4.170    20.168     0.200
     4.281    20.366     0.200
     4.281    20.366     0.200
     4.365    19.891     0.200
     4.377    20.547     0.200
     5.336    19.553     0.200
     5.770    22.686     0.200
     6.303    23.964     0.200
     6.769    24.136     0.200
     7.690    25.583     0.200
     8.072    25.629     0.200
     8.072    26.129     0.200
     8.234    23.538     0.200
     8.812    28.486     0.200
     9.149    27.356     0.200
     9.549    27.389     0.200
     9.808    29.563     0.200
     9.993    31.007     0.200
    10.009    29.021     0.200
    10.009    29.521     0.200
    10.071    30.596     0.200
    10.084    30.450     0.200
    10.535    27.878     0.200
    10.535    28.378     0.200
    11.346    28.319     0.200
    12.216    31.262     0.200
    14.272    32.769     0.200
    15.794    36.211     0.200
    16.068    39.315     0.200
    16.299    37.614     0.200
    17.317    38.234     0.200
    18.137    40.568     0.200
    18.583    43.465     0.200
    19.278    42.847     0.200
    19.251    43.164     0.200
    19.717    45.732     0.200
    19.719    42.711     0.200
    19.756    42.274     0.200
    19.867    41.582     0.200
    20.357    40.254     0.200
    20.557    39.928     0.200
     3.278    14.148     0.200
     3.317    17.100     0.200
     3.317    17.401     0.200
     3.873    17.804     0.200
     4.030    18.081     0.200
     4.130    19.107     0.200
     4.152    18.351     0.200
     4.152    18.453     0.200
     4.259    20.100     0.200
     4.348    18.061     0.200
     4.348    18.662     0.200
     4.373    18.767     0.200
     4.373    19.166     0.200
     5.311    19.830     0.200
     6.312    23.142     0.200
     6.594    25.855     0.200
     6.760    23.914     0.200
     6.760    24.715     0.200
     7.732    24.171     0.200
     8.095    25.341     0.200
     8.095    25.740     0.200
     8.270    25.293     0.200
     8.827    28.796     0.200
     9.102    26.585     0.200
     9.760    28.904     0.200
    10.014    30.943     0.200
    10.035    30.693     0.200
    10.093    30.022     0.200
    10.093    30.522     0.200
    10.306    27.538     0.200
    10.306    28.038     0.200
    10.490    27.387     0.200
    10.490    27.688     0.200
    11.345    28.305     0.200
    14.312    33.983     0.200
    14.371    32.900     0.200
    14.405    32.599     0.200
    14.618    33.017     0.200
    15.965    39.494     0.200
    16.202    39.729     0.200
    16.311    37.852     0.200
    17.333    38.533     0.200
    17.564    37.838     0.200
    18.185    40.288     0.200
    19.203    44.203     0.200
    19.676    42.380     0.200
    19.709    43.898     0.200
    19.821    41.493     0.200
     2.575    15.066     0.200
     3.013    18.652     0.200
     3.869    18.556     0.200
     4.023    19.369     0.200
     4.023    20.068     0.200
     4.130    19.716     0.200
     4.144    18.456     0.200
     4.149    17.899     0.200
     4.149    18.700     0.200
     4.246    19.858     0.200
     4.341    19.050     0.200
     5.730    22.141     0.200
     6.329    23.454     0.200
     6.329    23.555     0.200
     6.628    25.959     0.200
     6.760    20.418     0.200
     6.760    20.918     0.200
     8.299    23.463     0.200
     8.124    25.509     0.200
     8.124    26.408     0.200
     8.849    28.048     0.200
     8.849    28.548     0.200
     9.059    25.596     0.200
     9.714    29.747     0.200
    10.067    30.827     0.200
    10.067    31.327     0.200
    10.121    31.902     0.200
    10.266    28.514     0.200
    10.266    29.014     0.200
    10.450    28.364     0.200
    14.345    34.407     0.200
    14.410    33.351     0.200
    14.444    32.350     0.200
    14.657    33.368     0.200
    15.045    32.738     0.200
    16.241    38.278     0.200
    17.355    40.777     0.200
    17.355    41.578     0.200
    18.619    44.028     0.200
     2.534    15.940     0.200
     2.956    19.118     0.200
     3.299    14.919     0.200
     3.284    19.086     0.200
     3.842    18.771     0.200
     3.946    21.258     0.200
     4.000    20.130     0.200
     4.097    19.997     0.200
     4.123    20.092     0.200
     4.123    19.494     0.200
     4.233    20.513     0.200
     4.339    20.579     0.200
     4.339    20.977     0.200
     4.598    21.551     0.200
     5.376    21.270     0.200
     5.722    22.644     0.200
     6.275    22.884     0.200
     6.558    26.683     0.200
     7.136    26.930     0.200
     8.284    23.537     0.200
     8.057    26.186     0.200
     8.057    26.584     0.200
     8.789    27.645     0.200
     8.789    28.442     0.200
     9.108    27.126     0.200
     9.774    29.940     0.200
     9.976    31.790     0.200
     9.998    31.531     0.200
     9.998    32.328     0.200
    10.055    31.869     0.200
    10.306    28.941     0.200
    10.490    28.788     0.200
    11.381    29.190     0.200
    14.322    33.680     0.200
    14.372    33.884     0.200
    14.406    33.297     0.200
    14.619    34.403     0.200
    15.057    33.991     0.200
    16.343    40.993     0.200
    16.168    38.527     0.200
    17.295    41.383     0.200
    17.295    41.781     0.200
    18.176    42.490     0.200
    19.822    43.491     0.200
    19.998    41.832     0.200
    20.601    40.295     0.200
     2.536    15.300     0.200
     2.980    18.119     0.200
     3.226    19.738     0.200
     3.304    18.832     0.200
     3.872    19.004     0.200
     4.018    18.603     0.200
     4.018    19.103     0.200
     4.117    19.442     0.200
     4.141    18.559     0.200
     4.141    19.172     0.200
     4.486    16.638     0.200
     4.337    18.884     0.200
     4.337    19.782     0.200
     4.360    19.808     0.200
     5.395    14.430     0.200
     5.736    22.454     0.200
     6.298    24.990     0.200
     6.581    25.689     0.200
     6.747    22.750     0.200
     6.747    23.250     0.200
     8.081    25.184     0.200
     8.081    25.383     0.200
     8.277    23.705     0.200
     8.813    28.643     0.200
     8.813    29.143     0.200
     9.102    28.068     0.200
     9.764    30.549     0.200
    10.000    30.787     0.200
    10.080    27.858     0.200
    10.022    29.531     0.200
    10.304    29.244     0.200
    12.170    30.473     0.200
    14.373    33.260     0.200
    14.407    33.466     0.200
    14.620    34.179     0.200
    16.191    37.049     0.200
    16.323    38.698     0.200
    17.319    39.380     0.200
    18.183    40.991     0.200
    19.337    39.825     0.200
    19.709    42.488     0.200
    19.997    41.124     0.200
     2.534    16.328     0.200
     2.899    16.171     0.200
     2.967    19.871     0.200
     3.292    15.680     0.200
     3.221    21.308     0.200
     3.294    19.859     0.200
     3.852    19.854     0.200
     4.180    18.820     0.200
     3.956    21.534     0.200
     4.009    20.211     0.200
     4.108    20.768     0.200
     4.132    20.078     0.200
     4.132    20.480     0.200
     4.241    21.005     0.200
     4.328    20.796     0.200
     4.350    20.944     0.200
     4.610    22.307     0.200
     4.610    22.909     0.200
     5.336    21.830     0.200
     5.729    23.243     0.200
     6.286    24.739     0.200
     6.286    25.036     0.200
     6.569    27.441     0.200
     6.737    24.475     0.200
     6.737    25.077     0.200
     7.736    25.614     0.200
     8.069    26.939     0.200
     8.069    27.236     0.200
     8.280    24.478     0.200
     8.801    29.600     0.200
     9.106    28.836     0.200
     9.716    27.318     0.200
     9.770    31.790     0.200
     9.988    31.542     0.200
     9.988    31.941     0.200
    10.010    30.286     0.200
    10.010    30.989     0.200
    10.067    31.621     0.200
    10.079    31.475     0.200
    10.490    29.681     0.200
    11.370    30.813     0.200
    14.319    36.300     0.200
    14.372    34.780     0.200
    14.406    34.089     0.200
    14.619    34.500     0.200
    15.049    35.976     0.200
    16.026    41.080     0.200
    16.179    37.896     0.200
    16.333    38.998     0.200
    17.253    38.754     0.200
    17.585    39.884     0.200
    19.712    45.065     0.200
    19.822    43.784     0.200
    20.402    42.014     0.200
     2.377    14.099     0.200
     2.501    14.952     0.200
     2.928    14.461     0.200
     2.929    17.650     0.200
     3.287    13.977     0.200
     3.277    17.494     0.200
     3.838    17.950     0.200
     4.150    16.807     0.200
     3.999    17.673     0.200
     4.119    18.162     0.200
     4.123    19.119     0.200
     4.325    18.862     0.200
     4.317    18.452     0.200
     4.609    19.450     0.200
     6.370    23.794     0.200
     6.519    25.157     0.200
     6.718    24.833     0.200
     7.710    19.856     0.200
     8.264    22.792     0.200
     8.760    28.001     0.200
     9.145    28.509     0.200
     9.687    26.884     0.200
     9.943    29.699     0.200
     9.962    28.982     0.200
     9.816    29.676     0.200
    10.021    30.987     0.200
    10.339    30.574     0.200
    10.524    29.021     0.200
    11.399    29.313     0.200
    13.779    32.034     0.200
    14.297    32.489     0.200
    14.341    32.879     0.200
    14.374    32.290     0.200
    14.587    33.502     0.200
    14.763    33.151     0.200
    15.844    36.831     0.200
    16.126    36.039     0.200
    17.601    38.834     0.200
     2.333    15.052     0.200
     2.671    14.496     0.200
     3.022    14.002     0.200
     3.532    18.050     0.200
     3.963    17.020     0.200
     7.503    21.712     0.200
     8.021    23.663     0.200
     8.632    25.247     0.200
     9.288    27.881     0.200
     9.490    26.527     0.200
    11.139    26.990     0.200
    13.596    32.113     0.200
    14.155    32.180     0.200
    14.192    32.653     0.200
     1.871    14.611     0.200
     2.516    16.886     0.200
     3.307    16.246     0.200
     5.394    24.988     0.200
     6.510    27.966     0.200
     7.727    26.263     0.200
     8.283    25.277     0.200
     9.133    30.362     0.200
    13.795    33.959     0.200
    14.356    35.006     0.200
    14.389    34.822     0.200
    14.603    35.329     0.200
    14.778    35.081     0.200
     6.473    25.550     0.200
     8.201    22.384     0.200
     8.740    27.493     0.200
    10.417    24.520     0.200
    13.703    31.380     0.200
    14.264    31.824     0.200
    14.297    31.645     0.200
    14.511    31.751     0.200
    14.686    32.108     0.200
    16.069    38.061     0.200
    16.325    39.574     0.200
    18.057    37.869     0.200
     2.181    15.729     0.200
     2.551    15.310     0.200
     3.218    15.530     0.200
     3.178    17.597     0.200
     5.798    23.924     0.200
     6.892    27.652     0.200
     8.079    24.300     0.200
     8.442    28.968     0.200
     9.548    30.656     0.200
    13.449    33.028     0.200
    14.013    33.944     0.200
    14.040    33.430     0.200
    14.257    33.903     0.200
    14.420    34.296     0.200
    15.663    37.899     0.200
    16.444    38.083     0.200
    17.725    41.731     0.200
     2.169    12.926     0.200
     2.471    13.009     0.200
     3.304    14.287     0.200
     7.656    20.999     0.200
     8.245    22.924     0.200
     9.250    26.691     0.200
     9.865    29.511     0.200
     9.878    29.364     0.200
    10.424    25.997     0.200
    10.424    26.497     0.200
    11.507    25.860     0.200
    12.445    29.075     0.200
    12.867    29.952     0.200
    13.076    30.836     0.200
    13.486    28.261     0.200
    13.704    31.022     0.200
    14.267    31.971     0.200
    14.298    31.536     0.200
    14.512    31.968     0.200
    14.683    32.014     0.200
    15.738    32.884     0.200
    16.361    34.752     0.200
    16.377    34.742     0.200
    18.281    38.302     0.200
    20.480    38.138     0.200
     2.590    15.092     0.200
     2.885    16.454     0.200
     3.321    14.755     0.200
     5.291    22.669     0.200
     8.319    24.035     0.200
     3.239    16.336     0.200
     5.693    22.708     0.200
     8.135    25.504     0.200
    12.921    31.253     0.200
    13.543    32.631     0.200
    14.107    32.214     0.200
    14.135    32.983     0.200
    14.351    33.324     0.200
    14.518    33.399     0.200
    14.884    34.591     0.200
    15.576    34.509     0.200
    16.193    35.572     0.200
    16.213    37.133     0.200
    18.622    45.128     0.200
     1.717    14.207     0.200
     2.273    15.712     0.200
     2.756    14.581     0.200
     7.577    23.215     0.200
    11.712    28.937     0.200
    12.130    29.885     0.200
    12.342    29.991     0.200
    12.966    30.963     0.200
    13.530    31.188     0.200
    13.559    31.765     0.200
    13.774    31.972     0.200
    13.943    32.303     0.200
    14.309    32.311     0.200
    15.000    32.852     0.200
    15.621    34.946     0.200
    15.638    34.261     0.200
     2.105    14.913     0.200
     2.270    14.380     0.200
     2.263    14.864     0.200
     2.476    15.380     0.200
     3.083    17.496     0.200
     5.661    23.307     0.200
     8.121    23.503     0.200
     9.880    26.927     0.200
     9.976    27.857     0.200
    10.217    28.317     0.200
    10.768    30.368     0.200
    11.161    29.314     0.200
    11.468    29.577     0.200
    12.286    30.502     0.200
    12.704    31.656     0.200
    13.540    31.948     0.200
    14.103    33.053     0.200
    14.132    33.121     0.200
    14.348    33.442     0.200
     2.344    15.828     0.200
     2.337    15.913     0.200
     8.186    25.652     0.200
     9.954    27.495     0.200
    10.049    27.920     0.200
    10.291    28.720     0.200
    11.234    29.636     0.200
    11.542    30.263     0.200
    12.360    31.065     0.200
    12.778    32.067     0.200
    13.615    33.063     0.200
    14.178    33.807     0.200
    14.207    33.747     0.200
    14.591    34.450     0.200
    15.648    34.934     0.200
    16.267    37.028     0.200
    16.286    38.509     0.200
    17.920    43.857     0.200
    18.647    43.076     0.200
     2.368    13.767     0.200
     2.362    13.540     0.200
     2.673    13.306     0.200
     3.044    11.983     0.200
     8.046    21.503     0.200
     3.083    15.116     0.200
     8.864    29.059     0.200
     9.311    28.244     0.200
     9.916    26.992     0.200
    10.002    26.604     0.200
    10.259    28.141     0.200
    10.521    32.123     0.200
    11.184    28.068     0.200
    11.508    29.512     0.200
    12.388    31.331     0.200
    12.953    32.023     0.200
    13.594    32.798     0.200
    14.155    33.791     0.200
    14.189    33.432     0.200
    14.402    34.207     0.200
    14.581    33.815     0.200
    14.945    34.327     0.200
    15.628    34.937     0.200
    16.129    39.472     0.200
    16.265    35.769     0.200
    16.272    36.460     0.200
    20.389    39.959     0.200
     2.354    14.961     0.200
     2.348    15.533     0.200
     2.621    16.142     0.200
     3.003    15.192     0.200
     4.056    16.898     0.200
     4.927    16.242     0.200
     5.440    17.952     0.200
     6.092    20.042     0.200
     6.426    22.246     0.200
     8.012    23.238     0.200
     8.253    25.322     0.200
     9.271    28.042     0.200
     9.918    26.485     0.200
     9.999    26.479     0.200
    10.265    27.872     0.200
    11.179    28.682     0.200
    11.512    28.883     0.200
    12.322    29.882     0.200
    12.596    30.786     0.200
    12.763    31.218     0.200
    12.954    31.712     0.200
    13.604    32.640     0.200
    14.201    33.555     0.200
    14.412    33.611     0.200
    14.598    33.547     0.200
    14.961    34.168     0.200
    15.639    34.152     0.200
    16.285    35.735     0.200
    16.287    36.417     0.200
    18.321    43.923     0.200
    20.413    40.014     0.200
     2.177    11.638     0.200
     2.354    11.973     0.200
     2.626    14.200     0.200
     4.268    16.642     0.200
     4.325    15.968     0.200
     5.010    18.482     0.200
     5.151    17.729     0.200
     5.222    16.301     0.200
     5.740    19.455     0.200
     6.394    19.730     0.200
     6.733    19.875     0.200
     7.817    23.719     0.200
     8.343    22.079     0.200
     8.587    24.339     0.200
     8.932    23.382     0.200
     8.856    27.093     0.200
     9.007    26.332     0.200
     9.800    28.078     0.200
    10.220    25.819     0.200
    10.305    25.979     0.200
    10.564    27.082     0.200
    11.344    26.008     0.200
    11.487    28.069     0.200
    11.813    28.913     0.200
    12.930    29.398     0.200
    13.059    30.503     0.200
    13.257    30.301     0.200
    13.899    31.677     0.200
    14.460    32.016     0.200
    14.495    31.650     0.200
    14.707    31.786     0.200
    14.887    32.151     0.200
    15.251    33.120     0.200
    15.934    32.878     0.200
    16.336    38.308     0.200
    16.578    35.219     0.200
    18.281    39.111     0.200
    20.452    38.275     0.200
    20.695    37.936     0.200
     2.021    14.224     0.200
     2.238    14.391     0.200
     2.376    13.771     0.200
     2.982    15.906     0.200
     3.142    15.031     0.200
     3.895    16.052     0.200
     4.848    18.233     0.200
     5.687    21.131     0.200
     6.376    20.093     0.200
     6.752    21.710     0.200
     7.469    22.338     0.200
     8.065    24.382     0.200
     8.435    26.339     0.200
     8.800    24.384     0.200
     8.650    27.560     0.200
     9.430    27.459     0.200
     9.852    26.103     0.200
     9.794    28.203     0.200
     9.945    26.173     0.200
    10.191    27.187     0.200
    11.129    27.575     0.200
    11.436    28.396     0.200
    11.441    28.217     0.200
    12.465    31.041     0.200
    12.680    30.648     0.200
    12.760    30.346     0.200
    12.889    30.774     0.200
    13.518    31.514     0.200
    14.080    32.065     0.200
    14.111    31.929     0.200
    14.326    32.245     0.200
    14.497    32.663     0.200
    14.862    33.002     0.200
    15.551    33.058     0.200
    15.819    34.897     0.200
    15.894    36.019     0.200
    16.306    39.710     0.200
    16.976    37.391     0.200
    17.556    38.622     0.200
    19.547    43.391     0.200
    20.028    45.779     0.200
    20.226    39.962     0.200
    20.295    38.661     0.200
    20.746    43.396     0.200
     2.009    14.512     0.200
     2.217    14.878     0.200
     2.981    16.868     0.200
     3.128    16.146     0.200
     3.649    17.373     0.200
     3.875    17.736     0.200
     4.612    19.437     0.200
     4.828    19.116     0.200
     6.008    19.840     0.200
     7.450    25.016     0.200
     8.048    24.536     0.200
     7.761    27.130     0.200
     8.308    26.200     0.200
     8.433    27.867     0.200
     8.648    28.128     0.200
     9.496    26.633     0.200
     9.832    26.886     0.200
     9.925    26.775     0.200
     9.790    28.206     0.200
    10.171    27.653     0.200
    10.630    34.407     0.200
    11.109    28.556     0.200
    11.421    29.020     0.200
    11.433    28.819     0.200
    12.660    30.924     0.200
    12.746    31.100     0.200
    13.497    31.788     0.200
    14.060    32.783     0.200
    14.091    32.445     0.200
    14.305    32.859     0.200
    14.842    33.979     0.200
    15.531    34.056     0.200
    16.155    34.774     0.200
    18.504    42.508     0.200
     2.200    14.661     0.200
     3.140    15.184     0.200
     3.629    16.580     0.200
     4.595    19.212     0.200
     6.343    20.307     0.200
    15.831    37.577     0.200
    16.985    40.113     0.200
    17.798    41.026     0.200
    18.521    42.196     0.200
    20.216    41.915     0.200
     2.275    13.835     0.200
     2.405    13.525     0.200
     2.815    13.231     0.200
     3.535    17.728     0.200
     4.999    19.642     0.200
     5.606    19.663     0.200
     7.108    20.842     0.200
     7.515    20.062     0.200
     7.847    21.411     0.200
     7.937    22.794     0.200
     8.384    24.689     0.200
     8.394    23.031     0.200
     8.350    26.504     0.200
     8.650    27.403     0.200
     8.739    27.479     0.200
     8.874    27.026     0.200
     8.957    26.434     0.200
     8.957    26.356     0.200
     9.026    27.699     0.200
     9.348    24.242     0.200
     9.170    28.675     0.200
     9.241    30.142     0.200
     9.431    28.785     0.200
     9.609    29.009     0.200
     9.617    29.327     0.200
    12.395    29.990     0.200
    12.654    30.807     0.200
    12.837    30.978     0.200
    13.120    29.870     0.200
    13.497    31.574     0.200
    13.680    31.565     0.200
    14.096    32.091     0.200
    14.305    32.647     0.200
    14.859    33.473     0.200
    14.939    30.002     0.200
    15.444    37.015     0.200
    15.444    39.282     0.200
    15.444    38.860     0.200
    15.690    33.179     0.200
    15.811    33.473     0.200
    17.063    37.961     0.200
    17.046    37.974     0.200
    17.581    37.773     0.200
    17.982    39.062     0.200
    18.112    37.614     0.200
    18.792    39.992     0.200
    18.886    40.753     0.200
    19.538    40.887     0.200
    19.538    40.278     0.200
     2.294    14.521     0.200
     2.825    13.833     0.200
     8.962    27.502     0.200
     8.962    27.611     0.200
    12.672    31.513     0.200
    12.853    31.799     0.200
    13.514    32.380     0.200
    14.113    32.692     0.200
    14.322    33.555     0.200
    14.877    34.376     0.200
    15.459    38.667     0.200
    15.459    38.292     0.200
    18.001    38.719     0.200
    18.891    40.954     0.200
     1.993    14.645     0.200
     2.438    15.561     0.200
     2.767    17.222     0.200
     3.151    16.135     0.200
     4.961    20.011     0.200
     6.200    22.356     0.200
     7.145    24.312     0.200
     7.418    23.334     0.200
     7.851    23.693     0.200
     7.980    24.757     0.200
     8.148    23.820     0.200
     8.013    27.527     0.200
     8.146    24.800     0.200
     8.243    25.270     0.200
     8.324    28.222     0.200
     8.426    28.383     0.200
     8.534    28.611     0.200
     8.758    25.704     0.200
     8.696    28.867     0.200
     8.696    29.191     0.200
     8.696    27.521     0.200
     8.847    29.416     0.200
     9.102    29.665     0.200
     9.293    30.064     0.200
     9.283    29.677     0.200
     9.606    28.810     0.200
     9.682    28.615     0.200
    12.749    32.644     0.200
    13.063    33.164     0.200
    13.707    33.743     0.200
    14.268    34.503     0.200
    14.303    33.789     0.200
    14.515    34.213     0.200
    15.061    35.152     0.200
    15.163    37.156     0.200
    15.163    37.157     0.200
    16.007    35.526     0.200
    16.188    38.990     0.200
    16.230    39.503     0.200
    18.477    44.280     0.200
    18.513    41.895     0.200
    18.547    42.064     0.200
    19.166    41.692     0.200
     2.182    11.298     0.200
     2.367    13.444     0.200
     2.748    12.697     0.200
     3.092    12.683     0.200
     4.747    17.068     0.200
     5.151    19.251     0.200
     6.129    18.836     0.200
     7.074    21.605     0.200
     7.790    20.221     0.200
     8.082    20.543     0.200
     8.082    21.895     0.200
     8.019    24.915     0.200
     8.178    21.765     0.200
     8.325    25.693     0.200
     8.423    25.513     0.200
     8.541    25.830     0.200
     8.706    21.761     0.200
     8.611    24.771     0.200
     8.611    24.771     0.200
     8.699    26.418     0.200
     8.699    26.105     0.200
     8.847    27.120     0.200
     8.914    26.836     0.200
     8.931    26.915     0.200
     9.104    26.994     0.200
     9.287    26.873     0.200
     9.290    27.460     0.200
     9.612    25.693     0.200
    11.215    26.037     0.200
    11.317    26.290     0.200
    12.694    28.569     0.200
    12.992    30.545     0.200
    13.636    30.926     0.200
    14.197    31.885     0.200
    14.232    31.972     0.200
    14.444    31.796     0.200
    14.853    34.155     0.200
    15.232    32.501     0.200
    15.150    34.965     0.200
    15.150    36.192     0.200
    16.196    35.749     0.200
    16.732    36.048     0.200
    18.239    37.120     0.200
    18.426    39.335     0.200
     2.115    15.080     0.200
     2.569    16.580     0.200
     3.208    17.825     0.200
     4.505    20.283     0.200
     5.588    24.048     0.200
     5.911    21.471     0.200
     6.805    23.490     0.200
     7.528    27.125     0.200
     7.841    23.700     0.200
     7.812    27.330     0.200
     7.888    26.919     0.200
     7.912    25.644     0.200
     8.029    23.562     0.200
     8.092    24.895     0.200
     8.055    28.400     0.200
     8.139    25.991     0.200
     8.192    28.141     0.200
     8.192    27.957     0.200
     8.302    25.928     0.200
     8.249    27.145     0.200
     8.249    27.099     0.200
     8.359    24.883     0.200
     8.328    29.988     0.200
     8.380    28.047     0.200
     8.406    28.956     0.200
     8.595    28.839     0.200
     8.760    28.601     0.200
     8.788    30.092     0.200
     8.873    27.147     0.200
    11.638    32.247     0.200
    12.763    32.418     0.200
    12.802    31.566     0.200
    13.241    31.235     0.200
    13.377    33.647     0.200
    13.942    34.161     0.200
    13.968    34.355     0.200
    14.185    34.422     0.200
    14.569    36.533     0.200
    14.581    36.427     0.200
    14.580    36.956     0.200
    14.580    36.406     0.200
    14.713    35.358     0.200
    15.917    37.397     0.200
    16.595    39.796     0.200
    16.752    37.379     0.200
    16.903    39.839     0.200
    17.643    40.763     0.200
    17.643    40.634     0.200
    17.860    39.524     0.200
    18.170    41.005     0.200
    18.170    40.829     0.200
    18.279    41.721     0.200
    18.279    41.729     0.200
    18.279    41.963     0.200
    18.583    42.899     0.200
    20.132    41.323     0.200
     2.084    13.920     0.200
     2.330    15.260     0.200
     4.546    17.293     0.200
     5.855    20.013     0.200
     7.872    24.431     0.200
     8.008    24.868     0.200
     8.429    26.355     0.200
    12.684    30.418     0.200
    13.279    30.575     0.200
    13.846    31.365     0.200
    13.866    32.628     0.200
    14.086    32.962     0.200
    14.230    38.255     0.200
    14.235    33.020     0.200
    14.603    33.326     0.200
    16.476    38.088     0.200
    16.434    38.602     0.200
    17.914    37.913     0.200
    18.167    40.783     0.200
    18.167    40.764     0.200
     1.460    11.041     0.200
     2.055    14.867     0.200
     2.289    15.236     0.200
     3.182    17.321     0.200
     4.683    19.297     0.200
     4.816    20.754     0.200
     7.000    24.478     0.200
     7.759    26.421     0.200
     7.759    26.761     0.200
     7.867    26.585     0.200
     8.059    27.143     0.200
     8.059    27.745     0.200
     8.283    27.335     0.200
     8.283    27.667     0.200
     8.395    26.851     0.200
     8.434    27.975     0.200
     9.019    29.596     0.200
     9.019    29.998     0.200
    12.940    32.243     0.200
    14.132    33.429     0.200
    14.163    33.370     0.200
    14.378    33.666     0.200
    14.549    34.864     0.200
    14.871    41.014     0.200
    14.914    34.504     0.200
    16.608    39.280     0.200
    18.286    41.133     0.200
    18.286    40.727     0.200
    18.286    41.129     0.200
     2.150    13.127     0.200
     2.887    14.325     0.200
     6.245    20.160     0.200
     6.854    23.741     0.200
     8.082    25.462     0.200
     8.607    27.697     0.200
     8.734    26.149     0.200
     9.328    27.963     0.200
    16.920    38.087     0.200
     3.188    15.213     0.200
     4.348    18.273     0.200
     4.765    20.403     0.200
     5.620    21.115     0.200
     6.067    22.615     0.200
     6.447    22.281     0.200
     6.768    23.385     0.200
     7.834    24.500     0.200
     8.254    22.693     0.200
     8.433    28.399     0.200
     8.672    23.808     0.200
     8.881    27.670     0.200
     8.900    27.611     0.200
     8.900    27.361     0.200
     8.950    28.270     0.200
     8.950    29.349     0.200
     9.129    28.185     0.200
     9.129    29.201     0.200
     9.129    28.693     0.200
     9.129    28.482     0.200
     9.288    29.120     0.200
     9.344    28.967     0.200
     9.409    28.920     0.200
     9.536    30.133     0.200
     9.708    30.427     0.200
     9.743    29.092     0.200
     9.743    29.202     0.200
     9.838    28.109     0.200
     9.911    29.854     0.200
    10.318    29.606     0.200
    10.513    31.141     0.200
    10.910    28.774     0.200
    12.667    31.484     0.200
    12.704    31.237     0.200
    13.123    32.665     0.200
    13.299    32.516     0.200
    14.041    33.261     0.200
    14.523    34.130     0.200
    14.566    33.826     0.200
    14.762    34.347     0.200
    14.774    33.997     0.200
    14.805    35.262     0.200
    14.971    33.909     0.200
    15.073    37.812     0.200
    15.256    33.434     0.200
    15.256    37.130     0.200
    15.264    39.390     0.200
    15.333    37.913     0.200
    15.644    38.203     0.200
    15.644    37.345     0.200
    15.758    40.093     0.200
    15.978    37.143     0.200
    16.002    35.376     0.200
    16.012    41.624     0.200
    16.015    41.468     0.200
    16.655    37.152     0.200
    16.664    36.544     0.200
    16.745    38.607     0.200
    16.791    39.693     0.200
    16.791    39.115     0.200
    17.233    38.111     0.200
    17.310    35.936     0.200
    17.557    40.223     0.200
    17.665    37.969     0.200
    17.665    38.438     0.200
    17.665    38.953     0.200
    17.665    39.164     0.200
    18.382    37.495     0.200
    18.421    43.931     0.200
    18.505    42.622     0.200
    19.327    42.663     0.200
    19.709    42.243     0.200
    20.252    44.757     0.200
    20.720    42.935     0.200
     1.990    14.176     0.200
     3.161    15.607     0.200
     4.331    18.453     0.200
     4.745    20.623     0.200
     5.603    20.873     0.200
     6.047    22.034     0.200
     6.428    22.483     0.200
     7.813    23.319     0.200
     7.813    24.811     0.200
     8.458    27.938     0.200
     8.904    28.126     0.200
     8.929    27.847     0.200
     8.976    27.955     0.200
     8.976    28.931     0.200
     9.154    28.474     0.200
     9.154    28.857     0.200
     9.154    30.279     0.200
     9.154    28.177     0.200
     9.313    30.081     0.200
     9.369    29.663     0.200
     9.431    29.187     0.200
     9.560    30.181     0.200
     9.733    30.086     0.200
     9.766    30.224     0.200
     9.766    29.630     0.200
     9.766    29.771     0.200
     9.818    27.324     0.200
     9.891    29.071     0.200
    10.535    32.039     0.200
    12.648    31.800     0.200
    12.675    31.398     0.200
    13.105    32.672     0.200
    13.280    32.824     0.200
    14.014    32.770     0.200
    14.505    33.934     0.200
    14.548    34.024     0.200
    14.743    34.150     0.200
    14.775    35.979     0.200
    14.756    34.198     0.200
    14.953    34.897     0.200
    15.227    33.944     0.200
    15.249    38.639     0.200
    15.319    37.441     0.200
    15.389    41.014     0.200
    15.467    40.426     0.200
    15.665    38.641     0.200
    15.665    38.791     0.200
    15.742    40.742     0.200
    15.742    39.938     0.200
    15.999    42.067     0.200
    16.001    41.163     0.200
    15.983    35.874     0.200
    16.637    36.848     0.200
    16.647    36.832     0.200
    16.758    41.040     0.200
    16.821    40.222     0.200
    16.821    40.151     0.200
    17.288    38.153     0.200
    17.582    39.400     0.200
    17.690    38.154     0.200
    17.690    39.412     0.200
    17.690    40.255     0.200
    18.352    38.829     0.200
    18.883    42.275     0.200
    18.883    42.032     0.200
    19.484    42.588     0.200
    20.741    43.834     0.200
    20.976    43.026     0.200
    20.976    43.760     0.200
     1.729    10.762     0.200
     1.821    10.579     0.200
     2.804    12.416     0.200
     3.479    12.239     0.200
     4.735    15.780     0.200
     5.961    16.916     0.200
     8.509    23.559     0.200
     8.624    22.741     0.200
    12.264    26.615     0.200
    12.472    27.082     0.200
    13.102    27.638     0.200
    13.664    28.374     0.200
    13.695    28.313     0.200
    13.910    28.609     0.200
    14.082    28.501     0.200
    14.447    29.541     0.200
    14.831    37.360     0.200
    14.831    32.983     0.200
    15.135    29.605     0.200
    15.761    30.904     0.200
    15.775    30.435     0.200
    16.964    36.520     0.200
    16.980    35.618     0.200
     1.645    14.522     0.200
     2.785    16.127     0.200
     3.177    16.447     0.200
     4.365    19.092     0.200
     5.636    20.414     0.200
     6.076    20.420     0.200
     6.459    21.151     0.200
     6.778    22.661     0.200
     7.841    26.220     0.200
     8.248    25.271     0.200
     8.491    27.239     0.200
     8.557    29.862     0.200
     8.640    29.799     0.200
     8.854    29.403     0.200
     8.921    27.417     0.200
     8.940    28.891     0.200
     8.951    28.055     0.200
     8.951    27.573     0.200
     9.008    28.806     0.200
     9.008    30.046     0.200
     9.187    28.612     0.200
     9.187    29.131     0.200
     9.338    29.950     0.200
     9.347    30.045     0.200
     9.403    30.796     0.200
     9.468    30.730     0.200
     9.477    29.828     0.200
     9.594    29.464     0.200
     9.766    30.757     0.200
     9.802    29.792     0.200
     9.802    29.540     0.200
     9.802    29.409     0.200
     9.920    28.861     0.200
    10.166    31.288     0.200
    10.517    31.893     0.200
    10.610    31.801     0.200
    10.860    28.814     0.200
    11.409    34.384     0.200
    12.373    33.929     0.200
    12.677    31.688     0.200
    12.680    32.436     0.200
    13.135    32.539     0.200
    13.260    36.581     0.200
    13.328    37.084     0.200
    13.309    33.014     0.200
    13.386    39.012     0.200
    13.979    33.690     0.200
    14.568    38.713     0.200
    14.535    34.401     0.200
    14.579    34.090     0.200
    14.667    41.862     0.200
    14.769    41.066     0.200
    14.776    36.029     0.200
    14.787    33.967     0.200
    14.995    40.634     0.200
    14.985    35.152     0.200
    15.055    41.835     0.200
    15.109    40.407     0.200
    15.234    34.094     0.200
    15.343    41.047     0.200
    15.346    35.737     0.200
    15.620    39.643     0.200
    15.704    38.198     0.200
    15.704    36.456     0.200
    15.704    38.437     0.200
    15.704    37.759     0.200
    15.704    39.009     0.200
    15.699    40.759     0.200
    15.955    41.872     0.200
    15.957    41.143     0.200
    15.938    38.890     0.200
    16.014    36.043     0.200
    16.668    37.608     0.200
    16.679    37.076     0.200
    16.802    38.746     0.200
    16.823    39.775     0.200
    16.823    39.521     0.200
    17.312    39.187     0.200
    17.614    40.591     0.200
    17.614    39.575     0.200
    17.722    39.905     0.200
    17.722    40.805     0.200
    17.722    39.542     0.200
    17.722    40.635     0.200
    18.353    38.344     0.200
    18.353    40.844     0.200
    18.903    42.497     0.200
    18.943    43.060     0.200
    19.441    42.583     0.200
    20.946    44.533     0.200
    20.946    43.556     0.200
    20.946    44.845     0.200
     4.441    19.016     0.200
     4.441    18.570     0.200
     5.412    19.605     0.200
     5.915    18.375     0.200
     6.610    20.866     0.200
     6.646    25.545     0.200
     7.693    21.706     0.200
     7.990    25.799     0.200
     8.089    25.708     0.200
     8.089    25.299     0.200
     8.220    22.175     0.200
     8.306    26.551     0.200
     8.412    26.867     0.200
     8.510    26.384     0.200
     8.510    26.634     0.200
     8.510    25.564     0.200
     8.542    26.286     0.200
     8.542    26.011     0.200
     8.542    25.711     0.200
     8.676    27.315     0.200
     8.676    26.891     0.200
     8.676    26.447     0.200
     8.676    27.057     0.200
     8.821    23.755     0.200
     8.829    27.613     0.200
     8.892    26.933     0.200
     8.930    28.002     0.200
     9.082    27.787     0.200
     9.261    28.213     0.200
     9.277    27.698     0.200
     9.277    27.434     0.200
     9.277    28.004     0.200
     9.754    25.470     0.200
    10.074    29.431     0.200
    10.036    30.175     0.200
    10.306    29.366     0.200
    10.506    28.694     0.200
    10.507    28.380     0.200
    11.275    26.076     0.200
    11.238    29.751     0.200
    11.238    30.352     0.200
    11.450    28.080     0.200
    12.815    30.253     0.200
    12.938    31.014     0.200
    13.134    31.622     0.200
    13.778    32.109     0.200
    13.757    34.199     0.200
    14.339    32.868     0.200
    14.374    32.457     0.200
    14.574    32.825     0.200
    14.586    32.879     0.200
    14.767    32.871     0.200
    15.031    35.858     0.200
    15.145    36.390     0.200
    15.158    37.336     0.200
    15.158    37.800     0.200
    15.158    35.427     0.200
    15.158    37.202     0.200
    15.356    34.053     0.200
    15.368    39.128     0.200
    15.618    38.601     0.200
    15.762    41.097     0.200
    15.813    34.564     0.200
    16.242    35.157     0.200
    16.242    38.837     0.200
    16.247    36.591     0.200
    16.451    35.114     0.200
    16.458    35.639     0.200
    16.617    37.214     0.200
    16.617    37.779     0.200
    16.617    37.769     0.200
    17.073    38.630     0.200
    17.115    36.326     0.200
    17.115    36.944     0.200
    17.206    39.156     0.200
    17.223    35.709     0.200
    17.223    37.579     0.200
    17.308    38.921     0.200
    18.170    38.553     0.200
    18.170    39.633     0.200
    18.287    38.649     0.200
    18.287    39.215     0.200
    18.538    40.675     0.200
    19.879    40.284     0.200
    19.923    40.513     0.200
    20.059    39.753     0.200
    20.878    40.054     0.200
     2.500    14.161     0.200
     3.197    14.028     0.200
     4.470    18.087     0.200
     5.902    19.556     0.200
     6.597    20.121     0.200
     7.897    22.549     0.200
     8.121    25.310     0.200
     8.542    26.654     0.200
     8.574    25.492     0.200
     8.574    24.988     0.200
     8.707    25.939     0.200
     8.707    26.615     0.200
     9.308    27.425     0.200
     9.742    25.842     0.200
    10.516    28.042     0.200
    12.928    30.663     0.200
    13.123    30.287     0.200
    13.768    31.455     0.200
    14.329    32.217     0.200
    14.364    31.900     0.200
    14.577    32.825     0.200
    14.758    32.605     0.200
    15.187    38.234     0.200
    15.187    36.923     0.200
    15.187    36.927     0.200
    15.187    38.023     0.200
    15.803    33.309     0.200
    16.443    34.941     0.200
    16.449    34.777     0.200
    16.644    36.972     0.200
    16.644    37.118     0.200
    17.146    39.193     0.200
    17.254    37.930     0.200
    18.314    39.763     0.200
    19.155    39.473     0.200
     2.610    14.077     0.200
     3.286    14.091     0.200
     4.411    18.027     0.200
     5.390    18.231     0.200
     5.512    19.397     0.200
     6.010    18.805     0.200
     6.369    19.412     0.200
     6.705    20.885     0.200
     8.110    25.511     0.200
     8.110    25.690     0.200
     8.300    25.280     0.200
     8.543    24.799     0.200
     8.543    25.037     0.200
     8.714    26.610     0.200
     8.714    28.028     0.200
     8.714    26.840     0.200
     8.930    29.926     0.200
     9.322    27.507     0.200
    10.406    28.506     0.200
    11.269    28.836     0.200
    11.302    31.896     0.200
    12.600    29.991     0.200
    12.871    31.297     0.200
    13.232    31.723     0.200
    13.878    32.281     0.200
    14.438    32.044     0.200
    14.474    32.225     0.200
    14.673    32.699     0.200
    14.686    32.851     0.200
    14.868    34.225     0.200
    15.232    34.380     0.200
    15.204    37.939     0.200
    15.217    37.729     0.200
    15.217    37.850     0.200
    15.217    38.271     0.200
    15.217    38.276     0.200
    15.217    39.551     0.200
    15.217    37.811     0.200
    15.913    34.134     0.200
    16.571    37.051     0.200
    16.571    37.811     0.200
    17.148    39.092     0.200
    17.296    39.117     0.200
    17.256    38.857     0.200
    18.239    40.466     0.200
    19.691    40.541     0.200
     2.051    11.551     0.200
     2.214    12.742     0.200
     3.161    13.194     0.200
     4.165    16.543     0.200
     4.283    17.542     0.200
     4.602    17.977     0.200
     5.119    17.345     0.200
     5.320    20.091     0.200
     6.352    19.078     0.200
     7.432    21.388     0.200
     7.432    23.503     0.200
     7.691    24.065     0.200
     7.985    24.657     0.200
     8.062    23.100     0.200
     8.070    24.321     0.200
     8.148    22.502     0.200
     8.216    24.957     0.200
     8.325    23.436     0.200
     8.360    23.464     0.200
     8.360    24.015     0.200
     8.360    24.115     0.200
     8.362    25.140     0.200
     8.362    25.295     0.200
     8.362    24.726     0.200
     8.362    25.396     0.200
     8.503    27.085     0.200
     8.767    25.733     0.200
     8.822    25.852     0.200
     8.859    26.600     0.200
     8.940    27.025     0.200
     8.940    25.635     0.200
     8.940    25.846     0.200
     8.955    26.485     0.200
     9.161    24.770     0.200
     9.161    25.268     0.200
     9.405    26.842     0.200
     9.515    26.727     0.200
     9.661    27.361     0.200
    10.139    27.191     0.200
    10.488    28.400     0.200
    10.562    27.166     0.200
    10.822    26.229     0.200
    10.822    27.082     0.200
    10.822    27.123     0.200
    10.851    28.346     0.200
    12.230    27.958     0.200
    12.860    29.205     0.200
    13.485    29.812     0.200
    14.048    30.541     0.200
    14.077    30.297     0.200
    14.293    30.685     0.200
    14.461    31.116     0.200
    14.654    33.477     0.200
    14.654    33.869     0.200
    14.778    36.989     0.200
    14.778    36.416     0.200
    14.778    33.410     0.200
    14.827    31.750     0.200
    15.518    31.784     0.200
    15.810    40.181     0.200
    16.138    32.950     0.200
    16.812    33.722     0.200
    16.920    38.462     0.200
    16.920    39.427     0.200
     1.494    12.104     0.200
     3.345    14.503     0.200
     4.943    18.250     0.200
     5.464    19.339     0.200
     5.985    20.891     0.200
     6.677    20.375     0.200
     7.429    23.709     0.200
     7.828    25.235     0.200
     8.194    25.769     0.200
     8.257    25.562     0.200
     8.322    23.819     0.200
     8.348    26.116     0.200
     8.378    25.072     0.200
     8.572    24.002     0.200
     8.516    26.263     0.200
     8.516    26.035     0.200
     8.923    26.771     0.200
     9.100    27.062     0.200
     9.121    27.201     0.200
     9.121    26.851     0.200
     9.307    26.835     0.200
     9.602    27.534     0.200
     9.725    27.963     0.200
     9.922    27.100     0.200
     9.871    28.099     0.200
    10.461    27.806     0.200
    10.461    27.128     0.200
    10.450    28.097     0.200
    11.096    28.653     0.200
    12.566    29.098     0.200
    12.950    29.795     0.200
    13.196    30.937     0.200
    13.832    31.319     0.200
    14.394    31.963     0.200
    14.426    32.282     0.200
    14.628    32.235     0.200
    14.640    32.388     0.200
    15.011    36.484     0.200
    15.180    33.487     0.200
    15.866    33.679     0.200
    16.496    35.629     0.200
    16.508    35.489     0.200
    16.474    36.728     0.200
    16.953    38.935     0.200
    17.286    36.500     0.200
    17.238    40.053     0.200
    18.146    38.869     0.200
    18.146    37.969     0.200
     2.598    13.042     0.200
     4.193    17.371     0.200
     4.427    18.013     0.200
     5.495    18.996     0.200
     5.506    18.981     0.200
     6.686    15.511     0.200
     8.001    24.767     0.200
     8.283    21.631     0.200
     8.528    24.542     0.200
     8.528    24.949     0.200
     8.528    24.949     0.200
     8.521    25.800     0.200
     8.692    25.820     0.200
     8.847    27.456     0.200
     8.891    26.311     0.200
     9.050    27.053     0.200
     9.098    27.475     0.200
     9.272    27.472     0.200
     9.298    27.803     0.200
    10.423    28.078     0.200
    12.871    29.697     0.200
    13.861    32.083     0.200
    14.422    32.145     0.200
    14.457    31.731     0.200
    14.669    32.059     0.200
    15.191    36.773     0.200
    15.191    38.585     0.200
    15.191    36.813     0.200
    16.303    38.726     0.200
    17.126    38.637     0.200
    17.126    37.895     0.200
    17.234    38.908     0.200
    17.234    39.416     0.200
    18.236    37.994     0.200
    18.236    38.244     0.200
     2.650    12.834     0.200
     4.137    17.836     0.200
     4.378    18.762     0.200
     5.010    20.123     0.200
     5.460    21.010     0.200
     6.648    19.407     0.200
     6.752    24.067     0.200
     7.831    22.013     0.200
     8.344    21.894     0.200
     8.447    24.294     0.200
     8.480    24.917     0.200
     8.480    24.800     0.200
     8.480    25.081     0.200
     8.660    25.811     0.200
     8.859    26.628     0.200
     9.270    28.235     0.200
    10.370    28.385     0.200
    12.641    29.601     0.200
    12.933    31.222     0.200
    13.076    30.833     0.200
    13.273    31.235     0.200
    13.916    30.928     0.200
    14.512    32.875     0.200
    14.724    31.497     0.200
    15.268    33.942     0.200
    15.171    36.657     0.200
    15.171    35.158     0.200
    15.171    38.049     0.200
    15.951    34.183     0.200
    16.508    36.995     0.200
    16.508    37.878     0.200
    16.508    37.581     0.200
    17.092    35.846     0.200
    18.176    40.013     0.200
     2.343    13.044     0.200
     4.323    17.891     0.200
     4.718    17.664     0.200
     8.068    21.469     0.200
     7.997    25.105     0.200
     8.600    25.055     0.200
     8.600    25.242     0.200
     8.600    24.976     0.200
     8.676    26.901     0.200
     8.676    26.620     0.200
     9.169    28.235     0.200
    11.303    27.179     0.200
    12.334    29.070     0.200
    12.768    30.405     0.200
    13.608    30.500     0.200
    14.403    31.920     0.200
    14.416    31.671     0.200
    14.596    32.967     0.200
    14.960    32.617     0.200
    15.121    39.497     0.200
    15.120    37.701     0.200
    15.120    39.147     0.200
    15.643    33.255     0.200
    16.280    34.609     0.200
    16.736    36.983     0.200
    17.121    36.948     0.200
    18.563    40.406     0.200
     2.804    16.257     0.200
     4.183    18.697     0.200
     4.467    20.411     0.200
     5.169    21.009     0.200
     5.139    20.118     0.200
     5.561    22.703     0.200
     6.876    22.689     0.200
     7.606    27.065     0.200
     8.109    27.180     0.200
     8.109    27.537     0.200
     8.437    26.740     0.200
     8.335    27.907     0.200
     8.569    27.222     0.200
     8.569    26.990     0.200
     8.569    26.531     0.200
     8.569    26.671     0.200
     8.943    28.046     0.200
     8.808    28.401     0.200
     8.808    28.942     0.200
     9.188    28.482     0.200
     9.427    29.994     0.200
     9.425    29.427     0.200
     9.667    29.940     0.200
     9.770    30.131     0.200
    10.137    30.666     0.200
    10.195    31.400     0.200
    11.639    33.303     0.200
    12.960    32.216     0.200
    15.043    41.586     0.200
    15.346    39.778     0.200
    15.346    39.579     0.200
    15.346    37.442     0.200
    16.506    40.116     0.200
    16.506    39.686     0.200
    17.231    39.827     0.200
    18.169    40.379     0.200
    18.169    42.162     0.200
    18.492    41.564     0.200
    18.524    41.335     0.200
    18.524    41.214     0.200
    18.524    42.284     0.200
     2.559    15.537     0.200
     4.203    17.615     0.200
     4.430    19.319     0.200
     5.506    22.549     0.200
     6.720    16.404     0.200
     6.660    21.918     0.200
     6.811    22.700     0.200
     7.334    24.918     0.200
     7.993    26.242     0.200
     8.259    24.018     0.200
     8.168    25.781     0.200
     8.529    26.430     0.200
     8.529    26.286     0.200
     8.529    26.563     0.200
     8.529    26.290     0.200
     8.855    25.194     0.200
     8.681    27.336     0.200
     8.681    26.386     0.200
     8.681    26.132     0.200
     8.881    28.558     0.200
     9.238    28.426     0.200
     9.255    29.361     0.200
     9.286    29.266     0.200
    10.109    30.965     0.200
    10.456    26.793     0.200
    10.456    29.633     0.200
    12.852    30.962     0.200
    15.000    34.596     0.200
    15.175    39.432     0.200
    15.174    39.434     0.200
    15.174    38.930     0.200
    16.278    40.640     0.200
    16.584    38.216     0.200
    16.584    38.235     0.200
    17.118    41.315     0.200
    17.226    40.605     0.200
    17.226    41.277     0.200
    18.253    40.206     0.200
     3.841    15.477     0.200
     4.585    18.034     0.200
     5.600    18.982     0.200
     5.739    22.111     0.200
     6.296    19.968     0.200
     7.221    23.394     0.200
     7.894    21.754     0.200
     8.144    25.767     0.200
     8.144    25.411     0.200
     8.515    23.261     0.200
     8.774    25.652     0.200
     8.774    25.562     0.200
     8.817    27.596     0.200
     8.817    27.026     0.200
     8.817    25.690     0.200
     9.131    27.986     0.200
     9.222    27.583     0.200
     9.397    29.266     0.200
     9.397    27.446     0.200
     9.409    28.001     0.200
    10.809    26.895     0.200
    10.809    27.931     0.200
    10.809    28.005     0.200
    10.809    28.032     0.200
    12.192    28.661     0.200
    12.632    30.030     0.200
    12.824    29.992     0.200
    13.473    31.112     0.200
    14.033    31.883     0.200
    14.070    31.750     0.200
    13.967    33.031     0.200
    14.269    31.829     0.200
    14.281    32.382     0.200
    14.466    32.424     0.200
    14.829    32.984     0.200
    15.107    36.065     0.200
    15.231    37.949     0.200
    15.231    36.160     0.200
    15.231    35.783     0.200
    15.231    36.228     0.200
    15.508    33.864     0.200
    16.155    34.414     0.200
    16.153    34.836     0.200
    16.923    36.855     0.200
    16.923    36.984     0.200
    16.923    36.785     0.200
    17.266    36.401     0.200
    17.374    36.820     0.200
    20.281    38.097     0.200
     3.916    17.031     0.200
     4.103    18.651     0.200
     4.147    17.704     0.200
     4.223    19.061     0.200
     4.649    19.406     0.200
     5.166    19.953     0.200
     5.262    21.391     0.200
     6.403    20.955     0.200
     6.720    23.573     0.200
     6.959    24.806     0.200
     7.161    20.701     0.200
     7.641    25.813     0.200
     7.743    24.058     0.200
     8.162    23.700     0.200
     8.166    28.019     0.200
     8.301    25.585     0.200
     8.301    25.561     0.200
     8.301    25.960     0.200
     8.314    26.525     0.200
     8.314    25.533     0.200
     8.314    27.674     0.200
     8.631    26.105     0.200
     8.895    28.459     0.200
     8.906    29.092     0.200
     9.460    26.161     0.200
    11.398    30.568     0.200
    14.741    38.413     0.200
    14.741    38.688     0.200
    14.741    37.071     0.200
    15.789    39.675     0.200
    16.561    38.943     0.200
    16.561    38.764     0.200
    16.561    39.037     0.200
    16.763    37.410     0.200
    16.870    40.599     0.200
    18.241    39.438     0.200
     2.296    15.436     0.200
     4.275    19.819     0.200
     4.393    20.580     0.200
     4.934    22.968     0.200
     5.201    21.433     0.200
     5.444    23.109     0.200
     5.725    22.656     0.200
     6.417    22.629     0.200
     7.853    27.309     0.200
     8.099    25.131     0.200
     8.377    28.167     0.200
     8.480    27.358     0.200
     8.480    27.026     0.200
     8.480    26.827     0.200
     8.529    28.383     0.200
     8.934    29.300     0.200
     8.934    28.296     0.200
     9.046    29.771     0.200
     9.115    30.092     0.200
     9.115    29.893     0.200
     9.120    28.849     0.200
    11.035    31.899     0.200
    12.742    32.750     0.200
    14.840    36.812     0.200
    14.965    38.327     0.200
    14.965    42.776     0.200
    14.965    38.078     0.200
    14.965    38.504     0.200
    16.669    40.382     0.200
    16.669    39.054     0.200
    16.976    37.986     0.200
    17.084    42.053     0.200
    17.084    41.756     0.200
    18.345    40.284     0.200
    18.345    41.445     0.200
    18.409    43.196     0.200
    18.409    40.946     0.200
     3.485    18.382     0.200
     3.489    18.198     0.200
     4.790    21.059     0.200
     5.304    21.889     0.200
     5.292    22.179     0.200
     5.379    22.504     0.200
     5.852    24.364     0.200
     6.706    24.423     0.200
     6.790    23.744     0.200
     7.100    25.637     0.200
     7.163    26.032     0.200
     7.623    26.734     0.200
     7.628    25.420     0.200
     8.025    26.758     0.200
     8.240    27.221     0.200
     8.327    26.342     0.200
     8.327    26.231     0.200
     8.327    26.291     0.200
     8.398    27.521     0.200
     8.398    27.623     0.200
     8.398    26.742     0.200
     8.398    26.877     0.200
     8.398    27.353     0.200
     8.562    26.582     0.200
     8.546    28.241     0.200
     8.635    27.939     0.200
     8.733    27.516     0.200
     8.733    27.365     0.200
     8.804    27.890     0.200
     8.914    28.384     0.200
     8.914    28.925     0.200
     8.986    28.139     0.200
     8.990    29.041     0.200
     9.291    28.025     0.200
     9.291    28.625     0.200
     9.670    27.548     0.200
    14.731    36.037     0.200
    14.858    35.969     0.200
    14.857    36.170     0.200
    14.857    37.020     0.200
    14.857    39.871     0.200
    16.514    39.077     0.200
    16.514    37.975     0.200
    16.514    38.667     0.200
    16.842    37.634     0.200
    16.950    41.962     0.200
    16.950    41.552     0.200
    18.191    40.870     0.200
    18.191    39.835     0.200
    18.255    40.192     0.200
     1.389    11.190     0.200
     4.149    17.227     0.200
     4.339    16.866     0.200
     5.054    18.892     0.200
     5.256    18.766     0.200
     5.493    20.869     0.200
     5.606    20.818     0.200
     5.606    19.060     0.200
     5.785    22.550     0.200
     5.785    19.479     0.200
     6.261    23.859     0.200
     7.054    18.839     0.200
     7.410    23.472     0.200
     7.410    24.113     0.200
     7.660    21.700     0.200
     8.392    24.252     0.200
     8.392    24.799     0.200
     8.225    23.150     0.200
     8.346    26.028     0.200
     8.509    24.573     0.200
     8.509    24.510     0.200
     8.534    27.590     0.200
     8.712    25.846     0.200
     8.712    26.339     0.200
     8.712    26.182     0.200
     8.858    25.818     0.200
     9.083    26.080     0.200
     9.309    26.916     0.200
     9.317    26.931     0.200
     9.867    27.677     0.200
     9.944    27.552     0.200
     9.710    26.697     0.200
    11.325    29.866     0.200
    15.105    35.429     0.200
    15.235    39.252     0.200
    15.234    35.980     0.200
    15.655    34.181     0.200
    16.375    39.823     0.200
    16.503    36.671     0.200
    16.503    35.436     0.200
    16.503    36.264     0.200
    17.141    39.232     0.200
    17.141    40.114     0.200
    17.249    39.532     0.200
    17.249    39.665     0.200
    18.169    36.797     0.200
     4.087    20.525     0.200
     4.243    21.184     0.200
     4.767    20.784     0.200
     5.285    21.919     0.200
     5.360    24.298     0.200
     5.296    21.656     0.200
     6.512    23.144     0.200
     7.081    25.321     0.200
     7.144    26.440     0.200
     8.331    27.484     0.200
     8.396    28.292     0.200
     8.396    27.716     0.200
     8.728    28.471     0.200
     8.906    26.568     0.200
     8.931    27.074     0.200
    15.313    34.983     0.200
    16.526    39.792     0.200
    16.526    40.231     0.200
    16.841    37.616     0.200
    16.948    38.325     0.200
    18.203    40.872     0.200
     2.617    13.169     0.200
     5.073    20.420     0.200
     5.527    21.088     0.200
     7.091    22.407     0.200
     8.214    24.279     0.200
     8.547    25.337     0.200
     8.547    24.735     0.200
     8.719    26.373     0.200
     8.719    27.405     0.200
     8.719    25.842     0.200
     9.079    25.138     0.200
     9.289    28.559     0.200
    13.038    30.704     0.200
    13.878    32.996     0.200
    14.438    33.560     0.200
    14.686    33.167     0.200
    15.222    39.461     0.200
    15.222    39.102     0.200
    16.574    37.907     0.200
    16.574    36.993     0.200
    16.574    37.829     0.200
    17.153    39.905     0.200
    17.261    39.886     0.200
    18.242    39.422     0.200
    18.242    40.516     0.200
     2.450    14.483     0.200
     2.450    15.256     0.200
     3.595    18.457     0.200
     4.090    17.457     0.200
     4.831    19.380     0.200
     4.991    19.259     0.200
     4.968    21.299     0.200
     4.968    22.901     0.200
     5.461    18.515     0.200
     5.453    21.844     0.200
     5.453    23.266     0.200
     5.867    21.414     0.200
     6.055    25.012     0.200
     6.861    21.367     0.200
     6.870    24.582     0.200
     6.975    23.457     0.200
     7.699    25.092     0.200
     7.734    25.124     0.200
     7.875    26.634     0.200
     8.203    23.236     0.200
     8.202    23.944     0.200
     8.293    25.002     0.200
     8.218    26.983     0.200
     8.445    24.420     0.200
     8.428    23.431     0.200
     8.427    27.332     0.200
     8.483    26.303     0.200
     8.483    25.483     0.200
     8.608    25.837     0.200
     8.589    26.511     0.200
     8.589    27.870     0.200
     8.589    27.557     0.200
     8.589    27.198     0.200
     8.589    28.143     0.200
     8.740    28.440     0.200
     8.835    27.516     0.200
     8.995    28.180     0.200
     9.117    27.081     0.200
     9.117    28.581     0.200
     9.140    27.721     0.200
     9.140    29.299     0.200
     9.176    28.480     0.200
     9.186    29.024     0.200
     9.383    28.527     0.200
     9.419    29.498     0.200
     9.495    28.191     0.200
     9.495    29.676     0.200
     9.531    28.982     0.200
     9.626    26.999     0.200
     9.704    27.001     0.200
     9.781    29.930     0.200
     9.874    29.877     0.200
     9.979    29.119     0.200
     9.927    30.327     0.200
     9.990    30.305     0.200
     9.990    29.219     0.200
     9.990    30.422     0.200
    10.298    30.605     0.200
    10.423    30.040     0.200
    10.778    30.896     0.200
    10.868    30.449     0.200
    11.137    30.691     0.200
    11.542    29.035     0.200
    12.003    32.810     0.200
    12.822    31.162     0.200
    13.720    32.265     0.200
    14.282    33.113     0.200
    14.315    32.822     0.200
    14.516    33.176     0.200
    14.933    36.017     0.200
    14.933    36.118     0.200
    15.060    38.738     0.200
    15.060    36.434     0.200
    15.060    39.137     0.200
    15.060    36.326     0.200
    15.060    36.138     0.200
    15.060    39.334     0.200
    15.395    35.595     0.200
    15.755    34.320     0.200
    16.388    35.528     0.200
    16.398    36.018     0.200
    16.601    38.945     0.200
    16.601    38.265     0.200
    16.601    37.914     0.200
    17.031    37.508     0.200
    17.031    40.375     0.200
    17.139    39.171     0.200
    17.139    42.014     0.200
    18.274    41.810     0.200
    19.207    42.931     0.200
    19.538    41.973     0.200
    19.836    44.491     0.200
    20.526    43.442     0.200
     2.251    12.758     0.200
     2.251    12.969     0.200
     5.257    21.480     0.200
     5.762    21.575     0.200
     5.762    21.907     0.200
     6.234    23.577     0.200
     7.176    23.407     0.200
     7.252    22.296     0.200
     8.075    25.781     0.200
     8.700    27.561     0.200
     8.796    25.567     0.200
     8.796    25.227     0.200
     8.850    26.962     0.200
     8.850    26.364     0.200
     8.850    26.802     0.200
     8.850    26.692     0.200
     9.167    26.746     0.200
     9.255    26.986     0.200
     9.310    27.420     0.200
     9.350    27.212     0.200
     9.432    28.419     0.200
     9.442    27.144     0.200
     9.654    29.917     0.200
    11.332    29.941     0.200
    12.215    28.376     0.200
    12.656    29.826     0.200
    13.498    31.604     0.200
    14.095    30.297     0.200
    14.095    31.239     0.200
    14.293    31.822     0.200
    14.306    31.878     0.200
    14.492    32.706     0.200
    14.855    32.367     0.200
    15.189    32.971     0.200
    15.189    33.522     0.200
    15.145    34.940     0.200
    15.269    36.471     0.200
    15.269    35.385     0.200
    15.269    38.135     0.200
    15.533    32.355     0.200
    16.928    36.829     0.200
    16.928    36.610     0.200
    17.298    37.592     0.200
    17.406    38.019     0.200
    17.406    37.085     0.200
    19.800    39.958     0.200
    20.308    37.629     0.200
     3.047    15.451     0.200
     4.673    18.126     0.200
     5.417    20.081     0.200
     5.448    21.993     0.200
     5.593    19.976     0.200
     6.430    21.508     0.200
     6.423    24.653     0.200
     6.793    20.234     0.200
     7.127    22.329     0.200
     7.469    24.253     0.200
     7.640    24.854     0.200
     7.867    26.149     0.200
     8.297    25.297     0.200
     8.334    25.041     0.200
     8.349    22.080     0.200
     8.440    25.413     0.200
     8.440    25.405     0.200
     8.655    23.185     0.200
     8.687    24.025     0.200
     8.690    24.917     0.200
     8.758    25.728     0.200
     8.776    24.150     0.200
     8.815    27.337     0.200
     8.817    29.121     0.200
     8.759    28.484     0.200
     8.759    28.379     0.200
     8.759    27.957     0.200
     8.759    26.687     0.200
     8.919    24.747     0.200
     8.987    28.492     0.200
     9.165    24.981     0.200
     9.192    25.735     0.200
     9.168    26.522     0.200
     9.167    28.675     0.200
     9.395    29.219     0.200
     9.435    27.506     0.200
     9.435    28.006     0.200
     9.448    27.360     0.200
     9.448    27.157     0.200
     9.537    29.111     0.200
     9.897    28.114     0.200
    10.037    28.375     0.200
    10.196    26.790     0.200
    10.228    28.151     0.200
    10.183    29.575     0.200
    10.310    28.897     0.200
    10.507    30.092     0.200
    10.725    29.457     0.200
    11.111    30.043     0.200
    11.094    30.647     0.200
    11.365    30.286     0.200
    11.458    29.394     0.200
    11.458    31.094     0.200
    12.247    32.893     0.200
    13.024    30.825     0.200
    13.190    31.375     0.200
    13.464    31.988     0.200
    13.539    33.225     0.200
    13.655    32.354     0.200
    14.305    32.373     0.200
    14.865    33.142     0.200
    14.902    33.801     0.200
    15.101    33.590     0.200
    15.297    34.196     0.200
    15.347    36.717     0.200
    15.347    39.518     0.200
    15.347    35.863     0.200
    15.347    35.379     0.200
    15.347    37.218     0.200
    16.294    37.716     0.200
    16.294    38.013     0.200
    16.294    36.795     0.200
    16.983    35.519     0.200
    16.987    36.176     0.200
    17.167    37.903     0.200
    17.275    40.001     0.200
    17.275    39.212     0.200
    17.953    39.299     0.200
    20.425    41.649     0.200
     3.977    17.514     0.200
     4.714    19.842     0.200
     4.851    20.058     0.200
     5.234    20.481     0.200
     5.331    21.988     0.200
     5.446    19.784     0.200
     5.878    24.892     0.200
     6.109    20.493     0.200
     6.430    23.262     0.200
     6.457    21.652     0.200
     6.773    24.182     0.200
     6.847    24.078     0.200
     6.995    22.480     0.200
     7.416    22.555     0.200
     7.421    24.673     0.200
     7.461    24.965     0.200
     7.549    24.033     0.200
     7.665    25.690     0.200
     7.704    26.913     0.200
     7.989    24.749     0.200
     8.044    23.709     0.200
     8.135    23.877     0.200
     8.142    23.893     0.200
     8.161    23.524     0.200
     8.211    25.394     0.200
     8.196    26.451     0.200
     8.237    24.401     0.200
     8.264    25.515     0.200
     8.296    27.688     0.200
     8.348    24.932     0.200
     8.392    24.632     0.200
     8.353    22.825     0.200
     8.409    25.934     0.200
     8.398    26.211     0.200
     8.398    25.172     0.200
     8.450    28.089     0.200
     8.450    27.284     0.200
     8.450    25.886     0.200
     8.450    27.159     0.200
     8.450    27.480     0.200
     8.491    25.616     0.200
     8.596    28.252     0.200
     8.676    28.254     0.200
     8.818    27.502     0.200
     8.855    28.500     0.200
     8.846    25.622     0.200
     8.944    28.747     0.200
     8.944    27.036     0.200
     8.973    26.367     0.200
     8.973    28.922     0.200
     8.973    27.461     0.200
     9.037    28.514     0.200
     9.039    28.870     0.200
     9.519    26.184     0.200
     9.597    27.291     0.200
     9.508    29.148     0.200
     9.622    29.068     0.200
     9.822    28.148     0.200
     9.768    29.316     0.200
     9.782    29.995     0.200
     9.818    27.406     0.200
     9.818    30.328     0.200
    10.255    29.845     0.200
    10.402    28.447     0.200
    10.608    30.310     0.200
    10.635    29.760     0.200
    10.701    30.822     0.200
    10.826    33.593     0.200
    10.958    30.305     0.200
    10.965    29.861     0.200
    10.965    30.939     0.200
    11.442    29.201     0.200
    11.845    29.694     0.200
    12.340    30.077     0.200
    12.362    31.832     0.200
    12.763    31.037     0.200
    12.813    31.815     0.200
    13.601    31.657     0.200
    13.588    33.970     0.200
    14.164    33.492     0.200
    14.195    32.871     0.200
    14.195    32.527     0.200
    14.183    39.325     0.200
    14.581    33.219     0.200
    14.772    35.175     0.200
    14.768    36.148     0.200
    14.893    36.375     0.200
    14.893    36.180     0.200
    14.893    36.244     0.200
    15.345    34.846     0.200
    15.341    36.398     0.200
    15.625    41.637     0.200
    15.662    40.518     0.200
    15.675    42.037     0.200
    15.683    41.594     0.200
    15.859    40.675     0.200
    15.951    36.834     0.200
    15.919    37.436     0.200
    15.919    40.210     0.200
    16.055    40.924     0.200
    16.126    39.234     0.200
    16.260    35.726     0.200
    16.275    35.054     0.200
    16.190    40.162     0.200
    16.190    42.084     0.200
    16.241    41.987     0.200
    16.266    39.634     0.200
    16.470    39.903     0.200
    16.546    41.631     0.200
    16.596    37.810     0.200
    16.596    38.053     0.200
    16.729    40.714     0.200
    16.817    40.454     0.200
    16.896    37.294     0.200
    16.896    39.552     0.200
    16.964    37.380     0.200
    17.004    36.943     0.200
    17.004    36.318     0.200
    17.004    37.654     0.200
    17.004    36.552     0.200
    17.074    38.247     0.200
    17.133    41.580     0.200
    17.413    37.633     0.200
    17.586    38.196     0.200
    18.273    40.094     0.200
    18.326    40.373     0.200
    18.326    39.233     0.200
    18.348    39.562     0.200
    18.794    43.613     0.200
    18.877    41.989     0.200
    19.140    40.014     0.200
    19.068    41.741     0.200
    19.320    41.416     0.200
    19.559    41.641     0.200
    19.649    40.874     0.200
    19.654    42.026     0.200
    19.654    42.222     0.200
    20.163    41.759     0.200
    20.204    41.102     0.200
    20.380    39.732     0.200
    20.384    41.290     0.200
    20.658    42.801     0.200
    20.830    41.310     0.200
     2.321    13.943     0.200
     3.970    16.492     0.200
     5.227    19.360     0.200
     5.879    23.738     0.200
     6.449    20.707     0.200
     7.582    25.132     0.200
     7.742    22.202     0.200
     7.706    25.935     0.200
     8.127    24.033     0.200
     8.154    23.176     0.200
     8.229    23.194     0.200
     8.300    26.614     0.200
     8.404    24.277     0.200
     8.484    23.874     0.200
     8.454    26.773     0.200
     8.599    27.454     0.200
     8.679    28.357     0.200
     8.839    25.806     0.200
     8.859    27.106     0.200
     8.946    27.467     0.200
     8.946    25.909     0.200
     8.976    25.702     0.200
     8.976    25.402     0.200
     9.044    28.071     0.200
     9.041    27.985     0.200
     9.511    25.491     0.200
    10.395    27.533     0.200
    11.436    28.457     0.200
    11.517    28.000     0.200
    12.333    29.224     0.200
    12.806    30.598     0.200
    12.756    30.783     0.200
    12.963    30.764     0.200
    13.369    30.526     0.200
    13.594    31.102     0.200
    14.157    31.941     0.200
    14.188    31.277     0.200
    14.390    32.120     0.200
    14.574    33.065     0.200
    14.770    35.373     0.200
    14.896    37.117     0.200
    14.896    37.414     0.200
    14.896    36.240     0.200
    14.896    37.708     0.200
    15.951    37.896     0.200
    16.603    37.336     0.200
    16.603    37.856     0.200
    16.900    36.374     0.200
    17.008    38.605     0.200
    17.008    37.468     0.200
    18.332    39.108     0.200
     1.427    10.413     0.200
     2.321    10.169     0.200
     2.344    14.282     0.200
     2.344    14.513     0.200
     3.993    17.130     0.200
     4.730    18.761     0.200
     4.874    19.170     0.200
     4.845    21.380     0.200
     5.154    19.243     0.200
     5.250    19.848     0.200
     5.353    21.681     0.200
     5.879    24.425     0.200
     6.473    21.000     0.200
     6.842    23.293     0.200
     7.420    23.869     0.200
     7.451    25.107     0.200
     7.451    27.038     0.200
     7.605    25.076     0.200
     7.655    26.787     0.200
     7.655    27.736     0.200
     8.177    23.175     0.200
     8.291    26.652     0.200
     8.343    22.084     0.200
     8.343    22.613     0.200
     8.388    25.780     0.200
     8.388    25.653     0.200
     8.507    26.934     0.200
     8.445    25.140     0.200
     8.445    26.538     0.200
     8.445    27.097     0.200
     8.445    25.878     0.200
     8.592    27.338     0.200
     8.674    27.469     0.200
     8.860    24.729     0.200
     8.851    27.548     0.200
     8.945    27.651     0.200
     8.945    26.901     0.200
     8.973    27.123     0.200
     8.973    27.422     0.200
     9.035    27.669     0.200
     9.034    28.298     0.200
     9.505    28.698     0.200
     9.621    29.084     0.200
     9.820    28.558     0.200
     9.767    30.029     0.200
    10.255    29.370     0.200
    10.361    30.183     0.200
    10.608    30.132     0.200
    10.629    29.700     0.200
    10.826    33.362     0.200
    10.965    30.430     0.200
    10.965    29.214     0.200
    11.539    28.508     0.200
    12.356    29.939     0.200
    12.827    30.878     0.200
    12.779    31.001     0.200
    12.987    31.181     0.200
    13.617    31.425     0.200
    13.580    32.997     0.200
    14.180    32.460     0.200
    14.211    32.758     0.200
    14.211    32.297     0.200
    14.413    32.642     0.200
    14.597    33.487     0.200
    14.767    35.656     0.200
    14.767    35.758     0.200
    14.893    36.137     0.200
    14.893    35.084     0.200
    14.893    36.678     0.200
    14.893    39.739     0.200
    15.333    39.125     0.200
    16.276    35.693     0.200
    16.291    35.220     0.200
    16.582    38.383     0.200
    16.582    37.799     0.200
    16.582    38.023     0.200
    16.891    36.119     0.200
    16.891    40.343     0.200
    16.999    41.138     0.200
    16.999    38.267     0.200
    16.999    39.507     0.200
    18.259    37.957     0.200
    18.259    39.967     0.200
    18.317    38.533     0.200
    20.396    39.896     0.200
     3.997    18.869     0.200
     4.735    20.490     0.200
     4.843    20.598     0.200
     5.255    20.846     0.200
     5.349    22.192     0.200
     5.788    23.657     0.200
     5.880    24.795     0.200
     6.130    21.121     0.200
     6.477    21.499     0.200
     7.420    24.008     0.200
     8.181    25.989     0.200
     8.290    27.506     0.200
     8.386    26.851     0.200
     8.445    27.461     0.200
     8.445    25.967     0.200
     8.445    27.768     0.200
     8.445    28.017     0.200
     8.592    29.114     0.200
     8.863    27.282     0.200
     8.850    28.327     0.200
     8.946    29.504     0.200
     9.034    28.509     0.200
     9.034    29.474     0.200
     9.539    28.185     0.200
    10.418    30.404     0.200
    10.966    31.385     0.200
    12.361    30.768     0.200
    12.784    31.530     0.200
    12.991    32.011     0.200
    13.622    32.552     0.200
    14.184    33.889     0.200
    14.215    32.506     0.200
    14.215    33.125     0.200
    14.417    33.870     0.200
    14.602    34.315     0.200
    14.767    36.774     0.200
    14.893    37.450     0.200
    14.893    40.375     0.200
    15.958    41.093     0.200
    16.281    36.322     0.200
    16.578    39.940     0.200
    16.578    39.487     0.200
    16.578    39.379     0.200
    16.891    37.382     0.200
    16.998    40.318     0.200
    18.255    40.984     0.200
     2.351    13.983     0.200
     4.871    18.922     0.200
     5.910    24.465     0.200
     6.869    22.580     0.200
     7.450    23.971     0.200
     8.318    26.955     0.200
     8.411    25.769     0.200
     8.411    25.113     0.200
     8.474    27.165     0.200
     8.474    26.501     0.200
     8.474    26.673     0.200
     8.474    27.032     0.200
     8.621    26.771     0.200
     8.879    27.739     0.200
     8.975    26.957     0.200
     9.003    27.115     0.200
     9.063    27.867     0.200
     9.063    28.827     0.200
     9.849    27.807     0.200
    10.996    30.034     0.200
    12.786    31.119     0.200
    13.605    32.101     0.200
    13.624    31.432     0.200
    14.187    32.777     0.200
    14.218    32.604     0.200
    14.420    32.555     0.200
    14.433    32.307     0.200
    14.606    32.982     0.200
    14.797    36.430     0.200
    14.923    36.202     0.200
    14.923    36.352     0.200
    14.923    38.977     0.200
    15.884    38.096     0.200
    15.985    41.582     0.200
    16.285    35.483     0.200
    16.595    38.331     0.200
    16.595    38.495     0.200
    16.919    36.591     0.200
    16.919    36.130     0.200
    17.027    35.576     0.200
    18.271    40.740     0.200
    18.271    39.272     0.200
    18.340    41.382     0.200
     2.324    13.634     0.200
     4.043    16.000     0.200
     4.710    18.416     0.200
     4.891    21.031     0.200
     5.230    18.944     0.200
     5.399    19.726     0.200
     5.915    23.412     0.200
     6.448    20.292     0.200
     6.812    22.734     0.200
     6.887    22.574     0.200
     7.195    23.556     0.200
     7.460    24.704     0.200
     8.336    26.057     0.200
     8.487    24.744     0.200
     8.435    24.854     0.200
     8.435    25.209     0.200
     8.490    25.402     0.200
     8.490    25.840     0.200
     8.490    26.412     0.200
     8.490    26.272     0.200
     8.490    25.987     0.200
     8.636    27.137     0.200
     8.895    27.032     0.200
     8.983    25.759     0.200
     8.983    27.359     0.200
     9.013    27.070     0.200
     9.013    25.089     0.200
     9.013    28.070     0.200
     9.077    27.866     0.200
     9.079    27.658     0.200
     9.349    26.492     0.200
     9.512    25.055     0.200
     9.747    27.554     0.200
     9.857    28.516     0.200
     9.857    27.136     0.200
    11.003    29.585     0.200
    11.003    30.810     0.200
    12.334    29.609     0.200
    12.759    30.148     0.200
    13.597    31.265     0.200
    13.627    32.534     0.200
    14.393    32.082     0.200
    14.579    32.010     0.200
    14.807    35.360     0.200
    14.944    33.551     0.200
    14.932    38.384     0.200
    14.932    38.184     0.200
    14.932    39.552     0.200
    14.932    37.286     0.200
    14.932    36.296     0.200
    14.932    39.386     0.200
    15.265    33.795     0.200
    15.265    33.335     0.200
    15.631    33.229     0.200
    16.259    35.105     0.200
    16.624    37.018     0.200
    16.624    36.613     0.200
    16.936    38.407     0.200
    16.936    40.227     0.200
    17.044    38.936     0.200
    17.044    40.846     0.200
    20.699    40.588     0.200
     2.341    13.817     0.200
     4.726    18.620     0.200
     4.887    20.997     0.200
     5.434    18.840     0.200
     5.920    24.018     0.200
     6.436    20.512     0.200
     6.465    20.008     0.200
     6.885    22.563     0.200
     7.746    25.477     0.200
     8.334    26.265     0.200
     8.428    25.072     0.200
     8.428    24.740     0.200
     8.428    25.252     0.200
     8.489    26.336     0.200
     8.489    25.164     0.200
     8.489    25.664     0.200
     8.489    25.895     0.200
     8.489    26.457     0.200
     8.635    27.883     0.200
     8.817    26.111     0.200
     8.894    27.004     0.200
     8.987    28.236     0.200
     8.987    26.794     0.200
     9.015    26.697     0.200
     9.015    26.400     0.200
     9.078    27.489     0.200
     9.077    27.904     0.200
     9.861    28.833     0.200
    11.007    30.252     0.200
    12.351    29.476     0.200
    12.776    30.213     0.200
    13.614    31.028     0.200
    14.176    31.769     0.200
    14.208    32.749     0.200
    14.410    32.647     0.200
    14.809    35.463     0.200
    14.935    36.015     0.200
    14.935    35.914     0.200
    14.961    32.813     0.200
    15.282    34.497     0.200
    15.648    33.093     0.200
    16.611    37.441     0.200
    16.611    37.000     0.200
    16.611    37.402     0.200
    16.934    37.013     0.200
    17.042    40.537     0.200
    17.042    39.205     0.200
    17.042    40.228     0.200
    18.287    39.243     0.200
     2.341    10.102     0.200
     2.410    12.001     0.200
     2.410    13.263     0.200
     5.011    19.207     0.200
     5.500    21.321     0.200
     5.500    19.809     0.200
     5.976    20.385     0.200
     6.076    23.111     0.200
     7.015    22.354     0.200
     7.310    22.842     0.200
     8.047    31.239     0.200
     7.851    25.104     0.200
     7.900    25.270     0.200
     8.218    31.655     0.200
     8.340    25.143     0.200
     8.467    26.058     0.200
     8.477    21.494     0.200
     8.626    26.264     0.200
     8.626    26.471     0.200
     8.626    25.943     0.200
     8.626    26.162     0.200
     8.776    27.049     0.200
     8.963    27.423     0.200
     9.032    26.869     0.200
     9.141    28.868     0.200
     9.220    27.342     0.200
     9.214    27.346     0.200
     9.694    27.191     0.200
     9.812    27.321     0.200
     9.901    29.374     0.200
     9.958    27.714     0.200
    10.014    31.555     0.200
    10.450    28.474     0.200
    10.610    27.681     0.200
    10.610    27.107     0.200
    10.804    29.345     0.200
    10.801    29.282     0.200
    10.895    29.378     0.200
    11.023    32.691     0.200
    11.161    29.370     0.200
    11.161    28.334     0.200
    13.678    30.301     0.200
    14.239    31.855     0.200
    14.486    31.370     0.200
    14.665    31.688     0.200
    14.961    35.094     0.200
    15.087    37.949     0.200
    15.087    37.061     0.200
    15.087    35.390     0.200
    15.355    32.882     0.200
    15.489    38.369     0.200
    16.348    33.842     0.200
    17.069    37.372     0.200
    17.069    39.122     0.200
    17.177    37.825     0.200
    17.177    37.543     0.200
    19.581    40.211     0.200
    19.821    39.406     0.200
    20.125    40.260     0.200
    20.565    39.826     0.200
     5.815    19.361     0.200
     5.815    18.880     0.200
     6.205    21.967     0.200
     6.346    19.232     0.200
     8.055    23.733     0.200
     8.853    22.954     0.200
     8.864    25.029     0.200
     8.864    24.838     0.200
     8.864    24.726     0.200
     9.166    24.341     0.200
     9.335    22.987     0.200
    10.916    23.835     0.200
    11.309    28.490     0.200
    13.962    28.866     0.200
    15.130    33.963     0.200
    15.253    34.826     0.200
    15.253    36.517     0.200
    17.028    34.484     0.200
    17.316    34.727     0.200
    19.694    36.746     0.200
     4.146    19.407     0.200
     4.146    20.118     0.200
     5.341    22.877     0.200
     5.899    22.649     0.200
     5.899    23.336     0.200
     7.673    27.170     0.200
     8.422    28.796     0.200
     8.422    27.702     0.200
     8.422    28.202     0.200
     8.621    29.024     0.200
    10.610    30.966     0.200
    10.934    30.706     0.200
    10.934    31.589     0.200
    14.737    36.805     0.200
    14.737    36.704     0.200
    14.737    36.509     0.200
    14.849    37.299     0.200
    14.863    37.441     0.200
    14.863    36.668     0.200
    15.250    35.010     0.200
    15.319    37.513     0.200
    15.951    37.749     0.200
    15.951    40.702     0.200
    16.977    38.964     0.200
    16.977    38.464     0.200
    16.977    37.206     0.200
    16.977    38.011     0.200
    18.202    41.277     0.200
    18.328    40.102     0.200
    18.328    40.501     0.200
     3.841    22.612     0.200
     4.146    19.970     0.200
     4.405    22.742     0.200
     4.827    23.102     0.200
     5.521    23.615     0.200
     6.752    24.170     0.200
     6.822    24.352     0.200
     7.133    25.388     0.200
     7.650    26.086     0.200
    14.863    37.333     0.200
    16.589    39.018     0.200
     4.146    16.204     0.200
     3.804    19.753     0.200
     4.121    19.263     0.200
     4.367    20.533     0.200
     4.792    21.889     0.200
     5.309    22.444     0.200
     5.878    22.555     0.200
     6.719    24.293     0.200
     6.785    24.379     0.200
     7.098    25.012     0.200
     7.613    26.438     0.200
     8.385    28.365     0.200
     8.346    28.122     0.200
     8.709    28.996     0.200
    16.568    40.499     0.200
    16.568    40.615     0.200
     4.155    21.199     0.200
     5.366    24.493     0.200
     5.903    22.533     0.200
     5.903    24.275     0.200
     6.046    25.365     0.200
     7.163    25.848     0.200
     7.720    28.265     0.200
     8.461    29.441     0.200
     8.461    29.245     0.200
     8.660    30.159     0.200
     8.790    29.398     0.200
    10.981    31.991     0.200
    14.783    37.846     0.200
    14.783    37.627     0.200
    14.909    37.516     0.200
    14.908    37.635     0.200
    15.284    36.202     0.200
    17.014    38.060     0.200
    17.014    38.333     0.200
    18.352    41.254     0.200
    14.783    37.408     0.200
    14.783    37.306     0.200
     3.880    19.894     0.200
     4.155    18.824     0.200
     4.452    20.237     0.200
     4.859    22.869     0.200
     5.366    22.071     0.200
     5.554    24.377     0.200
     5.903    24.111     0.200
     6.779    24.266     0.200
     6.857    24.980     0.200
     7.229    27.033     0.200
     8.402    28.123     0.200
     8.461    28.870     0.200
    16.591    40.105     0.200
    16.591    40.026     0.200
     4.319    16.960     0.200
     4.153    19.669     0.200
     4.153    21.145     0.200
     5.901    24.143     0.200
     8.459    28.996     0.200
    10.979    32.043     0.200
    14.781    37.523     0.200
    15.285    36.824     0.200
    17.012    37.997     0.200
    18.350    41.436     0.200
     5.901    22.869     0.200
     7.161    25.857     0.200
     7.688    27.573     0.200
     7.718    28.199     0.200
     8.459    27.519     0.200
     8.459    29.230     0.200
     8.788    29.655     0.200
    14.781    37.640     0.200
    14.781    38.077     0.200
    14.907    37.671     0.200
    15.285    37.457     0.200
    17.012    41.701     0.200
    18.350    41.194     0.200
     3.878    22.300     0.200
     4.153    20.708     0.200
     4.451    23.374     0.200
     5.552    24.253     0.200
     4.317    16.954     0.200
     3.558    16.093     0.200
     4.317    16.954     0.200
     4.145    20.056     0.200
     4.145    21.046     0.200
     4.849    24.020     0.200
     5.893    23.651     0.200
     6.036    25.169     0.200
     6.768    25.721     0.200
     7.153    25.692     0.200
     7.712    27.974     0.200
     7.680    27.073     0.200
     8.451    29.004     0.200
     8.451    29.264     0.200
     8.780    29.560     0.200
    14.774    37.418     0.200
    14.774    37.678     0.200
    14.900    38.749     0.200
    18.341    40.983     0.200
     3.871    22.317     0.200
     4.145    20.196     0.200
     4.444    22.138     0.200
     4.849    21.270     0.200
     5.356    22.036     0.200
     5.543    24.576     0.200
     6.768    24.761     0.200
     6.847    25.187     0.200
     7.153    25.171     0.200
     7.680    26.293     0.200
     8.391    27.511     0.200
     8.451    27.874     0.200
     8.980    30.222     0.200
     9.826    31.571     0.200
    10.973    32.247     0.200
    14.900    38.399     0.200
    16.581    40.415     0.200
    16.581    40.324     0.200
    17.004    38.717     0.200
     4.145    16.893     0.200
     4.156    19.782     0.200
     4.156    22.102     0.200
     4.893    24.043     0.200
     5.389    24.353     0.200
     5.897    25.470     0.200
     6.085    25.291     0.200
     6.804    25.568     0.200
     7.194    25.998     0.200
     7.734    27.156     0.200
     8.504    29.041     0.200
     8.840    29.305     0.200
    14.837    37.445     0.200
    14.963    39.060     0.200
    15.340    37.465     0.200
     3.925    22.854     0.200
     4.510    21.498     0.200
     4.893    23.713     0.200
     5.389    23.302     0.200
     5.897    21.540     0.200
     7.734    26.804     0.200
     8.422    27.414     0.200
     9.044    26.343     0.200
    11.039    32.353     0.200
    14.837    38.074     0.200
    14.963    38.240     0.200
    16.581    40.333     0.200
    16.581    40.332     0.200
    18.373    41.542     0.200
     4.156    16.899     0.200
     3.538    16.034     0.200
     4.102    20.952     0.200
     4.810    23.574     0.200
     5.314    24.191     0.200
     5.850    24.200     0.200
     6.727    25.731     0.200
     7.113    25.625     0.200
     7.645    27.098     0.200
     7.684    27.802     0.200
     8.416    28.934     0.200
     8.416    29.087     0.200
     8.926    29.615     0.200
     8.951    31.908     0.200
     9.799    31.535     0.200
    10.345    31.948     0.200
    10.946    31.587     0.200
    14.745    37.419     0.200
    14.745    37.657     0.200
    14.745    37.216     0.200
    14.871    39.201     0.200
    15.315    35.411     0.200
    16.968    38.283     0.200
    18.300    41.182     0.200
     4.102    20.823     0.200
     5.850    24.013     0.200
    18.300    40.631     0.200
     3.836    22.518     0.200
     4.102    20.702     0.200
     4.417    22.496     0.200
     4.810    23.363     0.200
     5.314    24.051     0.200
     5.505    24.556     0.200
     6.727    25.551     0.200
     7.187    26.940     0.200
     7.396    27.310     0.200
     8.349    28.029     0.200
     8.748    28.825     0.200
     8.926    29.365     0.200
     8.951    29.478     0.200
     9.799    30.856     0.200
    10.946    31.900     0.200
    14.745    37.817     0.200
    14.871    37.992     0.200
    16.538    41.096     0.200
    16.538    40.962     0.200
    16.968    39.427     0.200
    18.300    41.370     0.200
     4.102    16.800     0.200
     2.883    13.574     0.200
     3.819    21.041     0.200
     4.129    19.628     0.200
     4.384    20.305     0.200
     4.806    21.970     0.200
     5.321    23.640     0.200
     5.499    24.414     0.200
     5.884    24.672     0.200
     6.731    24.779     0.200
     6.800    24.662     0.200
     7.112    25.465     0.200
     7.164    26.650     0.200
     7.369    26.777     0.200
     7.628    26.328     0.200
     8.358    27.524     0.200
     8.400    28.241     0.200
    10.912    32.511     0.200
    14.715    37.090     0.200
    16.574    39.761     0.200
    16.574    40.676     0.200
    16.955    42.658     0.200
     3.556    16.114     0.200
     4.168    20.860     0.200
     4.168    19.169     0.200
     5.912    24.318     0.200
     7.759    27.798     0.200
     8.495    28.936     0.200
     8.495    28.776     0.200
    14.821    37.507     0.200
    14.947    39.277     0.200
     3.915    21.881     0.200
     4.168    20.329     0.200
     4.492    22.979     0.200
     5.912    23.179     0.200
     8.425    27.169     0.200
     8.495    28.145     0.200
     8.827    28.255     0.200
    14.947    38.437     0.200
    17.048    41.797     0.200
    18.376    41.548     0.200
     4.173    20.657     0.200
     5.918    23.695     0.200
     7.748    26.838     0.200
     8.495    28.824     0.200
    10.660    31.749     0.200
    10.676    31.063     0.200
    10.753    31.970     0.200
    11.018    31.777     0.200
    14.819    37.117     0.200
    14.819    37.523     0.200
    14.819    37.418     0.200
    14.945    37.310     0.200
    14.945    37.448     0.200
    15.299    36.860     0.200
    15.862    39.052     0.200
    17.048    37.707     0.200
    18.212    41.907     0.200
    18.378    40.985     0.200
     3.915    20.972     0.200
     4.173    20.266     0.200
     4.890    23.057     0.200
     5.585    24.198     0.200
     5.918    23.527     0.200
     6.807    25.540     0.200
     6.889    25.260     0.200
     7.193    25.499     0.200
     7.264    26.693     0.200
     7.472    26.811     0.200
     7.724    26.769     0.200
     8.428    27.520     0.200
     8.825    29.025     0.200
     9.025    28.860     0.200
     9.871    30.941     0.200
    14.945    37.249     0.200
    15.862    39.532     0.200
    16.604    38.800     0.200
    16.604    38.987     0.200
     3.566    14.316     0.200
     4.177    17.763     0.200
     4.579    19.141     0.200
     4.943    19.812     0.200
    15.030    38.708     0.200
    16.590    39.992     0.200
    16.590    40.219     0.200
     4.177    16.950     0.200
     4.900    22.884     0.200
     5.401    24.389     0.200
     6.815    26.084     0.200
     6.899    24.783     0.200
     7.202    25.729     0.200
     7.276    26.235     0.200
     7.483    26.483     0.200
     7.735    26.533     0.200
     8.505    27.618     0.200
     9.037    28.881     0.200
     9.883    30.530     0.200
    11.030    31.647     0.200
    14.831    37.541     0.200
    17.058    41.074     0.200
     5.121    18.983     0.200
     4.150    21.005     0.200
     4.864    23.878     0.200
     5.368    24.239     0.200
     5.896    24.262     0.200
     6.781    25.375     0.200
     7.698    27.207     0.200
     7.732    28.093     0.200
     8.469    29.069     0.200
     8.469    29.222     0.200
     9.735    31.156     0.200
    10.994    31.909     0.200
    14.794    37.393     0.200
    14.794    37.763     0.200
    14.794    37.193     0.200
    14.920    37.590     0.200
    15.302    36.052     0.200
    17.021    38.095     0.200
    17.021    37.800     0.200
    18.353    41.356     0.200
    18.353    40.661     0.200
     3.889    22.149     0.200
     4.864    23.547     0.200
     9.847    29.539     0.200
     3.549    16.404     0.200
     4.150    17.204     0.200
     4.165    20.827     0.200
     4.901    24.213     0.200
     5.398    24.136     0.200
     6.813    25.944     0.200
     7.203    26.076     0.200
     7.742    27.111     0.200
     7.783    28.007     0.200
     8.512    29.176     0.200
     9.898    31.620     0.200
    14.844    37.422     0.200
    14.844    37.222     0.200
    14.844    37.612     0.200
    15.336    38.385     0.200
     4.165    18.446     0.200
     5.905    24.237     0.200
     8.512    28.816     0.200
    14.970    38.449     0.200
     3.933    21.900     0.200
     4.165    20.267     0.200
     4.901    23.182     0.200
     7.203    26.616     0.200
     7.742    26.722     0.200
     9.898    30.560     0.200
    18.382    40.887     0.200
     4.165    16.944     0.200
     4.138    20.588     0.200
     6.763    25.739     0.200
     8.447    29.037     0.200
    14.771    37.634     0.200
    15.294    36.920     0.200
     4.138    19.399     0.200
     5.887    23.497     0.200
     8.447    28.416     0.200
    10.630    30.244     0.200
    10.705    32.163     0.200
    17.000    41.601     0.200
     3.867    22.908     0.200
     4.138    20.918     0.200
     4.442    23.399     0.200
     4.844    23.502     0.200
     5.539    24.957     0.200
     5.887    24.407     0.200
     6.842    25.374     0.200
     7.148    26.476     0.200
     7.216    27.472     0.200
     7.423    27.880     0.200
     7.676    27.183     0.200
     8.447    28.936     0.200
     8.777    28.844     0.200
    10.970    32.399     0.200
    14.771    38.054     0.200
     4.138    16.934     0.200
     4.303    16.712     0.200
     4.183    19.895     0.200
     4.183    20.766     0.200
     5.925    22.869     0.200
     7.784    28.071     0.200
     8.518    28.805     0.200
     8.518    29.215     0.200
     9.024    29.939     0.200
    10.780    32.117     0.200
    14.845    37.571     0.200
    14.845    37.782     0.200
    14.971    37.600     0.200
    15.313    37.169     0.200
    17.071    40.839     0.200
    18.396    41.441     0.200
     3.939    22.158     0.200
     4.183    20.465     0.200
     4.516    23.292     0.200
     4.911    22.940     0.200
     5.411    23.469     0.200
     5.606    24.299     0.200
     5.925    23.408     0.200
     6.825    24.953     0.200
     8.445    27.403     0.200
    11.045    31.950     0.200
    14.971    37.479     0.200
    16.610    38.875     0.200
    16.610    38.874     0.200
    17.071    38.178     0.200
     5.126    20.691     0.200
     4.174    22.190     0.200
     4.900    24.080     0.200
     5.400    24.571     0.200
     7.736    27.468     0.200
     8.507    29.576     0.200
     8.839    29.659     0.200
    14.834    38.138     0.200
     4.174    21.120     0.200
     4.505    22.137     0.200
     4.900    22.630     0.200
     5.400    23.121     0.200
     5.595    24.387     0.200
     5.917    24.333     0.200
     6.814    25.538     0.200
     6.900    25.308     0.200
     7.202    26.531     0.200
     7.278    26.977     0.200
     7.486    26.917     0.200
     7.736    26.048     0.200
     8.434    26.873     0.200
     8.507    28.576     0.200
     8.839    28.239     0.200
     9.040    27.611     0.200
    11.034    31.848     0.200
    14.834    36.888     0.200
    14.960    35.957     0.200
    16.602    39.776     0.200
    16.602    39.465     0.200
     3.561    16.012     0.200
     2.974    13.815     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.817    19.178     0.200
     8.132    57.146     0.200
     2.790    20.353     0.200
     4.282    30.947     0.200
     5.831    49.362     0.200
     6.120    48.495     0.200
     6.704    51.674     0.200
     6.010    44.704     0.200
     6.246    49.948     0.200
     6.684    51.835     0.200
     5.868    50.517     0.200
     7.126    56.649     0.200
     8.280    62.478     0.200
     8.264    60.792     0.200
     6.092    42.994     0.200
     2.766    18.583     0.200
     2.753    18.876     0.200
     5.274    35.791     0.200
     3.841    26.957     0.200
     4.211    26.944     0.200
    10.826    73.656     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.809     5.677     0.200
     7.628    41.094     0.200
     8.420    50.854     0.200
     8.532    46.554     0.200
     1.459     8.812     0.200
     2.914    17.240     0.200
     0.725     4.752     0.200
     0.912     6.269     0.200
     0.995     6.635     0.200
     1.136     6.886     0.200
     2.590    15.217     0.200
     5.670    35.672     0.200
     1.774    10.752     0.200
     1.235     8.086     0.200
     1.033     6.775     0.200
     2.982    19.027     0.200
     2.982    19.328     0.200
     1.456     9.707     0.200
     1.830    12.749     0.200
     2.121    12.649     0.200
     2.334    12.963     0.200
     2.993    17.572     0.200
     3.235    19.049     0.200
     1.492    10.400     0.200
     1.846    13.072     0.200
     2.140    13.134     0.200
     2.335    13.265     0.200
     1.463    10.335     0.200
     1.855    13.362     0.200
     2.144    13.486     0.200
     2.367    13.588     0.200
     1.077     6.929     0.200
     1.460     9.847     0.200
     1.840    13.018     0.200
     2.131    13.226     0.200
     1.461    10.549     0.200
     2.137    14.460     0.200
     1.437     9.663     0.200
     1.850    12.846     0.200
     2.136    12.605     0.200
     1.229     9.132     0.200
     1.575    11.692     0.200
     1.865    12.507     0.200
     2.104    12.827     0.200
     1.455    10.261     0.200
     2.156    14.777     0.200
     1.368     9.530     0.200
     2.091    11.891     0.200
     2.423    14.311     0.200
     6.473    32.550     0.200
     1.243     9.173     0.200
     1.400     9.502     0.200
     2.424    13.948     0.200
     1.510    10.298     0.200
     2.162    13.087     0.200
     2.356    12.227     0.200
     1.289     9.695     0.200
     2.130    14.288     0.200
     2.268    13.776     0.200
     0.758     6.292     0.200
     1.689    11.330     0.200
     1.274     9.405     0.200
     1.339    10.260     0.200
     2.496    16.056     0.200
     1.257     9.229     0.200
     1.885    10.406     0.200
     1.240     9.028     0.200
     1.935    13.617     0.200
     2.209    14.216     0.200
     2.327    15.349     0.200
     2.320    15.024     0.200
     1.236     9.312     0.200
     1.541     9.961     0.200
     1.219     8.385     0.200
     1.201     8.841     0.200
     2.372    14.574     0.200
     1.199     8.835     0.200
     1.140     8.082     0.200
     1.647    11.159     0.200
     1.838    11.640     0.200
     1.159     8.470     0.200
     1.656    12.068     0.200
     1.835    12.680     0.200
     2.397    14.521     0.200
     1.346    10.105     0.200
     2.215    15.864     0.200
     1.275     8.377     0.200
     1.205     8.900     0.200
     2.115    15.071     0.200
     1.343    10.166     0.200
     1.266     9.377     0.200
     1.053     8.033     0.200
     1.477     9.681     0.200
     1.742    11.383     0.200
     0.868     5.490     0.200
     1.623    11.576     0.200
     2.016    13.591     0.200
     0.887     5.648     0.200
     1.609    11.724     0.200
     2.747    16.338     0.200
     0.829     8.457     0.200
     0.859     5.404     0.200
     2.007    13.905     0.200
     1.152     6.957     0.200
     1.152     7.757     0.200
     1.418     9.857     0.200
     2.060    13.055     0.200
     2.507    14.744     0.200
     1.149     6.901     0.200
     1.405     9.936     0.200
     2.036    12.376     0.200
     1.042     7.071     0.200
     1.513     9.978     0.200
     2.121    13.284     0.200
     1.576     9.388     0.200
     2.193    12.343     0.200
     1.068     5.400     0.200
     1.031     6.268     0.200
     1.314     7.493     0.200
     0.839     5.967     0.200
     1.101     6.466     0.200
     1.468    10.171     0.200
     1.402     8.555     0.200
     1.562     9.852     0.200
     1.413     9.252     0.200
     1.319     9.455     0.200
     1.389     9.214     0.200
     2.398    13.535     0.200
     2.865    18.788     0.200
     0.957     5.649     0.200
     1.406    10.118     0.200
     1.040     6.234     0.200
     1.244     8.048     0.200
     1.244     8.587     0.200
     1.369     7.838     0.200
     1.369     8.139     0.200
     0.573     3.934     0.200
     0.640     4.348     0.200
     0.640     4.238     0.200
     4.764    28.069     0.200
     1.423     9.850     0.200
     1.423     9.553     0.200
     3.435    18.427     0.200
     7.461    40.621     0.200
     7.461    47.152     0.200
     7.665    41.815     0.200
     7.665    48.463     0.200
     8.353    48.755     0.200
     1.427     8.303     0.200
     2.321    11.763     0.200
     3.429    19.975     0.200
     1.339     8.558     0.200
     1.410     8.755     0.200
     1.406     9.266     0.200
     2.349    14.162     0.200
     1.389     9.285     0.200
     1.406     8.800     0.200
     2.324    12.724     0.200
     1.318     8.552     0.200
     1.391     8.559     0.200
     1.391     8.977     0.200
     2.341    13.489     0.200
     1.193     7.896     0.200
     1.267     8.056     0.200
     1.267     7.955     0.200
     1.379     9.612     0.200
     1.379     9.260     0.200
     1.404    10.265     0.200
     1.329     9.275     0.200
     4.489    24.928     0.200
     3.926    25.595     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.341    67.453     0.200
     4.197    72.134     0.200
     5.523    87.665     0.200
     5.801    89.420     0.200
     5.957    97.601     0.200
     6.110    91.813     0.200
     6.568    99.471     0.200
     6.574    98.397     0.200
     7.488   106.731     0.200
     7.503   111.561     0.200
     7.628   109.094     0.200
     8.420   122.854     0.200
     8.532   125.554     0.200
     9.790   128.869     0.200
     9.646   139.543     0.200
    17.725   228.268     0.200
     4.285    71.044     0.200
     6.146   100.326     0.200
     8.132   112.146     0.200
     8.627   122.375     0.200
    12.400   171.344     0.200
    18.577   233.254     0.200
    20.229   269.972     0.200
    22.150   288.562     0.200
     5.694    89.470     0.200
     5.831    93.362     0.200
     6.120    95.495     0.200
     7.475   109.375     0.200
     7.802   119.861     0.200
     8.084   112.069     0.200
    18.555   235.183     0.200
     4.075    71.086     0.200
     6.246    96.648     0.200
     7.790   113.928     0.200
     8.338   113.543     0.200
     3.125    58.585     0.200
     4.055    67.134     0.200
     5.743    90.736     0.200
     6.518    96.896     0.200
     7.505   114.170     0.200
     8.122   112.175     0.200
     8.310   121.979     0.200
     9.589   134.054     0.200
    12.555   168.937     0.200
    14.077   183.984     0.200
    14.077   197.984     0.200
     4.267    71.595     0.200
     5.868    94.918     0.200
     8.144   110.051     0.200
     8.885   124.709     0.200
    10.145   143.804     0.200
    10.132   143.951     0.200
     4.168    70.090     0.200
     4.170    65.168     0.200
     4.281    74.866     0.200
     4.281    74.866     0.200
     4.377    70.047     0.200
     5.336    82.553     0.200
     5.770    91.686     0.200
     6.303   101.964     0.200
     7.690   110.683     0.200
     8.072   116.629     0.200
     8.812   128.986     0.200
     9.993   150.007     0.200
    10.071   143.096     0.200
    10.084   142.950     0.200
    11.346   149.319     0.200
    15.794   206.711     0.200
    18.583   240.965     0.200
    19.278   246.847     0.200
    19.719   266.711     0.200
    19.756   264.274     0.200
    19.867   265.582     0.200
    21.362   282.131     0.200
    21.401   281.679     0.200
     4.030    71.280     0.200
     5.311    77.830     0.200
     5.746    91.353     0.200
     6.594    98.855     0.200
     7.732   109.370     0.200
     8.095   114.341     0.200
     8.270   110.293     0.200
     8.827   126.796     0.200
     9.102   128.585     0.200
    10.014   148.943     0.200
    10.035   141.693     0.200
    10.093   140.022     0.200
    10.306   143.538     0.200
    10.306   150.538     0.200
    10.490   151.387     0.200
    14.312   194.483     0.200
    17.333   230.232     0.200
    17.564   228.838     0.200
    18.185   231.089     0.200
    18.605   235.682     0.200
    21.357   288.570     0.200
    21.637   284.302     0.200
     3.869    67.056     0.200
     4.144    71.257     0.200
     4.149    69.200     0.200
     4.246    72.858     0.200
     5.730    89.442     0.200
     6.329   101.852     0.200
     8.299   112.263     0.200
     8.849   131.048     0.200
    18.619   248.028     0.200
     3.946    68.954     0.200
     4.097    69.895     0.200
     4.123    73.092     0.200
     4.233    74.513     0.200
     5.376    85.270     0.200
     5.722    87.940     0.200
     6.275    99.283     0.200
     6.558   102.683     0.200
     8.284   113.741     0.200
     8.789   128.044     0.200
     9.108   131.923     0.200
    10.490   152.288     0.200
    14.322   197.680     0.200
    18.631   248.789     0.200
     4.117    69.942     0.200
     4.141    69.059     0.200
     4.141    73.973     0.200
     4.249    72.411     0.200
     4.486    66.638     0.200
     5.324    83.365     0.200
     5.395    77.633     0.200
     5.736    91.556     0.200
     6.298   102.591     0.200
     8.081   116.985     0.200
     8.813   125.643     0.200
     9.102   126.267     0.200
    10.488   146.092     0.200
    12.170   163.473     0.200
    16.191   218.549     0.200
    19.820   268.197     0.200
     3.852    69.651     0.200
     3.862    67.327     0.200
     4.180    65.820     0.200
     3.956    71.534     0.200
     4.009    69.414     0.200
     4.132    70.578     0.200
     4.132    73.878     0.200
     4.241    75.106     0.200
     6.569   106.441     0.200
     8.069   121.736     0.200
     8.280   115.478     0.200
     8.801   131.795     0.200
     9.716   134.318     0.200
    11.370   160.813     0.200
    15.049   196.976     0.200
    17.253   221.754     0.200
    18.623   235.273     0.200
    23.257   298.691     0.200
     3.277    57.994     0.200
     3.638    61.773     0.200
     3.843    66.786     0.200
     3.838    64.450     0.200
     4.150    68.307     0.200
     3.999    66.470     0.200
     4.119    66.662     0.200
     4.123    70.119     0.200
     4.609    75.450     0.200
     5.370    81.563     0.200
     6.370    96.794     0.200
     7.710   102.254     0.200
     8.264   111.792     0.200
     8.760   123.001     0.200
    10.021   142.987     0.200
    10.524   149.021     0.200
    16.126   212.539     0.200
    17.601   230.834     0.200
    18.627   236.862     0.200
    18.627   242.362     0.200
     2.333    45.052     0.200
     5.215    78.411     0.200
     7.503   104.212     0.200
     8.021   109.163     0.200
     9.288   127.881     0.200
     9.490   130.824     0.200
    17.012   216.738     0.200
     2.516    50.585     0.200
     6.510    98.966     0.200
     7.727   112.064     0.200
     8.283   114.578     0.200
     6.473    97.851     0.200
     8.740   125.092     0.200
    16.069   212.561     0.200
     8.079   111.800     0.200
     9.548   146.656     0.200
    15.663   214.298     0.200
    18.607   234.936     0.200
     8.245   112.424     0.200
     9.250   125.691     0.200
    11.507   147.360     0.200
    23.396   300.208     0.200
     8.319   112.035     0.200
     2.268    44.475     0.200
     8.135   110.504     0.200
    18.622   243.128     0.200
     2.270    47.075     0.200
     8.121   113.003     0.200
     2.344    53.930     0.200
     2.337    47.413     0.200
     3.271    56.508     0.200
     6.259    94.139     0.200
     8.186   114.152     0.200
     9.954   137.077     0.200
    18.647   249.076     0.200
     2.368    42.767     0.200
     6.688   101.354     0.200
     8.046   108.003     0.200
     2.327    45.748     0.200
     3.083    52.917     0.200
     6.556   100.588     0.200
     8.864   130.458     0.200
     9.311   143.244     0.200
     2.354    45.461     0.200
     3.973    66.372     0.200
     4.927    72.642     0.200
     5.440    74.952     0.200
     6.092    89.042     0.200
     6.426    94.246     0.200
     8.012   108.238     0.200
     8.253   118.722     0.200
    11.090   148.948     0.200
    12.596   166.396     0.200
     4.268    65.642     0.200
     5.010    79.583     0.200
     5.151    78.729     0.200
     5.222    78.208     0.200
     6.038    85.981     0.200
     6.394    92.331     0.200
     6.733    95.875     0.200
     6.653   100.406     0.200
     7.817   110.719     0.200
     8.343   112.579     0.200
     8.587   116.237     0.200
     8.932   122.366     0.200
     8.856   124.093     0.200
     9.800   136.078     0.200
    11.344   147.524     0.200
    11.344   152.672     0.200
    12.930   170.094     0.200
    13.059   169.362     0.200
    18.651   234.792     0.200
     2.245    45.472     0.200
     2.238    44.391     0.200
     4.848    69.932     0.200
     5.687    85.131     0.200
     6.376    96.093     0.200
     8.065   109.581     0.200
     8.800   121.755     0.200
     8.650   126.060     0.200
     9.430   138.459     0.200
    11.436   150.295     0.200
    12.760   166.315     0.200
    18.517   245.410     0.200
    19.130   252.251     0.200
    19.498   255.637     0.200
     2.217    44.878     0.200
     4.828    75.716     0.200
     6.008    87.840     0.200
     6.356    97.273     0.200
     8.048   110.536     0.200
     8.308   115.401     0.200
    11.433   148.219     0.200
    11.433   159.080     0.200
    11.433   159.549     0.200
    12.746   166.498     0.200
    17.548   231.673     0.200
    18.504   233.508     0.200
     6.343    93.307     0.200
     8.047   110.427     0.200
     8.309   108.964     0.200
    15.831   216.577     0.200
     3.872    65.798     0.200
     4.999    80.642     0.200
     5.606    80.960     0.200
     6.949    95.075     0.200
     7.108    99.382     0.200
     7.515   104.335     0.200
     7.847   107.411     0.200
     8.957   127.692     0.200
     9.348   125.765     0.200
     9.241   135.142     0.200
    12.395   163.686     0.200
    12.395   166.873     0.200
    12.395   167.131     0.200
    12.837   169.181     0.200
    13.497   176.675     0.200
    14.096   181.489     0.200
    14.305   185.342     0.200
    14.859   192.778     0.200
    17.982   241.038     0.200
    18.112   232.114     0.200
    18.792   239.406     0.200
    19.038   248.635     0.200
     8.962   128.869     0.200
    14.877   192.376     0.200
     3.151    55.135     0.200
     4.818    78.583     0.200
     7.145   105.661     0.200
     7.851   108.462     0.200
     8.148   111.320     0.200
     8.146   113.989     0.200
     8.243   114.480     0.200
     8.393   115.125     0.200
     8.393   121.615     0.200
     8.393   121.795     0.200
     8.758   121.704     0.200
     8.696   128.445     0.200
     9.606   132.510     0.200
     9.682   136.215     0.200
     9.661   133.524     0.200
    12.749   169.514     0.200
    16.230   215.503     0.200
    18.477   236.780     0.200
    18.513   248.236     0.200
     6.129    84.235     0.200
     6.467    89.338     0.200
     7.074   101.616     0.200
     7.790   102.623     0.200
     8.082   108.043     0.200
     8.178   109.316     0.200
     8.328   111.962     0.200
     8.611   122.868     0.200
     8.611   122.771     0.200
     8.699   123.601     0.200
     8.914   122.336     0.200
    12.694   161.159     0.200
    16.196   212.651     0.200
    16.732   218.571     0.200
    16.732   214.208     0.200
    18.426   241.335     0.200
    18.500   239.473     0.200
    18.540   243.953     0.200
     5.588    86.947     0.200
     6.805    94.693     0.200
     7.841   107.837     0.200
     8.029   110.562     0.200
     8.192   119.352     0.200
     8.302   112.897     0.200
     8.249   118.767     0.200
     8.249   118.696     0.200
     8.359   114.789     0.200
     8.406   126.155     0.200
     8.873   122.225     0.200
    12.763   168.617     0.200
    12.802   170.637     0.200
    13.377   175.846     0.200
    13.942   183.661     0.200
    13.968   183.652     0.200
    14.185   185.722     0.200
    14.347   188.435     0.200
    14.713   192.159     0.200
    16.595   216.671     0.200
    18.279   237.171     0.200
    18.279   237.171     0.200
    18.279   240.366     0.200
    18.583   240.399     0.200
     3.525    62.202     0.200
     5.855    87.013     0.200
     7.872   114.571     0.200
     8.008   114.575     0.200
     8.429   118.562     0.200
    16.476   210.763     0.200
    18.167   234.158     0.200
     7.000    96.548     0.200
     7.759   113.988     0.200
     7.867   108.753     0.200
     8.112   113.286     0.200
     8.141   112.014     0.200
     8.283   119.167     0.200
     8.371   114.359     0.200
     8.395   122.719     0.200
    16.608   217.327     0.200
    18.286   240.700     0.200
     4.671    71.702     0.200
     6.245    89.511     0.200
     6.854    97.260     0.200
     7.870   106.607     0.200
     8.112   107.708     0.200
     8.734   122.583     0.200
    16.920   219.692     0.200
     2.766    48.177     0.200
     4.348    68.273     0.200
     4.765    78.403     0.200
     5.093    79.577     0.200
     5.620    85.513     0.200
     6.067    93.420     0.200
     6.768    98.081     0.200
     7.142    98.967     0.200
     8.254   111.693     0.200
     8.672   121.808     0.200
     8.900   128.158     0.200
     8.900   124.861     0.200
     8.950   125.567     0.200
     9.129   131.380     0.200
     9.129   126.060     0.200
     9.344   131.967     0.200
    16.745   224.607     0.200
    18.468   241.898     0.200
    18.821   252.075     0.200
    18.854   248.706     0.200
    19.604   262.844     0.200
     2.753    49.079     0.200
     4.331    67.453     0.200
     4.745    79.623     0.200
     5.076    79.759     0.200
     5.603    84.436     0.200
     6.047    94.229     0.200
     6.428    94.483     0.200
     6.748    98.528     0.200
     7.813   110.459     0.200
     8.929   128.480     0.200
     8.976   126.751     0.200
     9.154   131.474     0.200
     9.154   130.537     0.200
     9.369   134.663     0.200
     9.818   136.027     0.200
    16.758   227.040     0.200
    16.821   225.581     0.200
    18.883   252.743     0.200
     0.829    21.656     0.200
     4.735    68.131     0.200
     5.274    74.991     0.200
     5.961    81.935     0.200
     7.055    95.016     0.200
     7.672    96.800     0.200
     8.509   115.959     0.200
    12.418   152.590     0.200
     4.365    68.092     0.200
     5.636    85.334     0.200
     6.076    90.218     0.200
     6.778    99.401     0.200
     7.201    97.287     0.200
     7.841   111.690     0.200
     8.951   128.526     0.200
     8.951   128.374     0.200
     9.008   128.906     0.200
     9.187   132.211     0.200
     9.403   140.796     0.200
     9.802   138.866     0.200
     9.847   129.112     0.200
     9.920   138.361     0.200
    16.802   224.445     0.200
    16.823   220.494     0.200
    16.823   220.570     0.200
    18.480   244.148     0.200
    18.581   249.282     0.200
    19.603   263.063     0.200
     4.441    71.495     0.200
     5.412    82.415     0.200
     5.915    88.575     0.200
     6.610    94.826     0.200
     6.646    89.946     0.200
     7.693   108.076     0.200
     8.089   117.235     0.200
     8.220   111.775     0.200
     8.510   119.714     0.200
     8.542   121.231     0.200
     8.542   120.361     0.200
     8.676   123.568     0.200
     8.676   124.816     0.200
     8.821   121.755     0.200
     8.892   130.433     0.200
     9.754   135.270     0.200
    10.036   142.569     0.200
    10.306   144.375     0.200
    10.507   148.205     0.200
    11.238   158.589     0.200
    11.450   150.080     0.200
    13.757   187.245     0.200
    15.356   195.433     0.200
    16.247   218.091     0.200
    16.617   215.824     0.200
    16.617   213.509     0.200
    18.287   238.053     0.200
    18.287   241.055     0.200
    18.470   244.414     0.200
    18.538   247.825     0.200
     4.470    71.130     0.200
     6.597    94.271     0.200
     6.597    94.471     0.200
     7.897   104.779     0.200
     8.121   116.355     0.200
     8.201   110.731     0.200
     8.542   118.354     0.200
     8.574   119.390     0.200
     8.574   119.908     0.200
     8.707   124.444     0.200
     8.707   122.093     0.200
    16.644   216.238     0.200
    16.644   214.538     0.200
    18.314   236.987     0.200
    18.314   235.457     0.200
     4.411    70.861     0.200
     5.512    78.137     0.200
     6.369    89.812     0.200
     6.705    94.074     0.200
     6.716    87.758     0.200
     8.110   117.216     0.200
     8.300   112.280     0.200
     8.543   121.396     0.200
     8.543   124.937     0.200
     8.714   125.784     0.200
     8.714   126.641     0.200
     8.930   132.926     0.200
     9.322   130.524     0.200
    12.871   166.938     0.200
    16.571   219.174     0.200
    18.239   235.613     0.200
     4.602    72.977     0.200
     5.119    78.576     0.200
     6.238    84.386     0.200
     6.352    91.629     0.200
     7.432   105.179     0.200
     8.192   118.761     0.200
     8.325   107.565     0.200
     8.360   116.771     0.200
     8.362   121.566     0.200
     8.940   124.846     0.200
    10.822   149.684     0.200
    14.778   198.719     0.200
    18.303   231.133     0.200
     4.943    75.250     0.200
     5.464    82.929     0.200
     6.510    87.668     0.200
     6.677    96.615     0.200
     7.429   109.959     0.200
     7.766   109.210     0.200
     8.194   120.249     0.200
     8.194   120.359     0.200
     8.322   113.819     0.200
     8.378   119.795     0.200
     8.572   115.802     0.200
     8.516   122.338     0.200
     9.121   131.921     0.200
    10.461   148.081     0.200
    12.950   170.935     0.200
    16.474   212.020     0.200
    18.146   236.144     0.200
    18.146   234.731     0.200
     4.229    59.194     0.200
     5.495    80.715     0.200
     5.995    89.184     0.200
     6.689    90.491     0.200
     8.283   109.459     0.200
     8.292   108.784     0.200
     8.528   121.378     0.200
     8.692   123.500     0.200
     9.298   135.006     0.200
    18.236   236.759     0.200
    18.236   235.728     0.200
     6.748    90.302     0.200
     7.831   103.787     0.200
     8.480   122.550     0.200
     8.660   124.990     0.200
     8.660   128.146     0.200
     9.270   135.157     0.200
    12.933   164.863     0.200
    16.508   214.347     0.200
    18.176   235.872     0.200
     4.718    74.109     0.200
     5.747    84.551     0.200
     8.068   107.712     0.200
     7.997   115.246     0.200
     8.600   122.515     0.200
     8.676   123.198     0.200
     9.265   133.879     0.200
    11.303   149.421     0.200
    18.409   243.141     0.200
     5.169    82.429     0.200
     6.178    93.349     0.200
     6.876    99.458     0.200
     6.866    91.138     0.200
     7.606   112.108     0.200
     8.109   120.268     0.200
     8.409   115.125     0.200
     8.437   119.320     0.200
     8.569   126.421     0.200
     8.808   127.450     0.200
     9.427   135.131     0.200
    10.226   149.157     0.200
    11.639   154.473     0.200
    12.960   170.257     0.200
    18.169   238.904     0.200
     4.197    66.985     0.200
     5.463    83.103     0.200
     5.965    90.448     0.200
     6.660    96.227     0.200
     6.668    94.484     0.200
     7.993   117.902     0.200
     8.259   112.729     0.200
     8.529   123.454     0.200
     8.681   124.980     0.200
     9.286   138.391     0.200
    10.456   148.035     0.200
    11.492   153.193     0.200
    12.852   167.133     0.200
    18.253   238.062     0.200
     4.585    69.944     0.200
     5.600    82.224     0.200
     6.296    89.777     0.200
     6.680    89.685     0.200
     7.894   105.282     0.200
     8.774   127.336     0.200
     3.916    64.617     0.200
     4.649    73.883     0.200
     5.166    80.015     0.200
     5.717    86.427     0.200
     6.206    87.010     0.200
     6.403    93.790     0.200
     6.959    98.915     0.200
     7.499   104.569     0.200
     8.162   110.934     0.200
     8.301   117.374     0.200
     8.314   119.080     0.200
     8.314   121.681     0.200
     8.889   123.315     0.200
     8.895   128.365     0.200
     9.460   128.169     0.200
    11.398   150.505     0.200
    12.841   169.229     0.200
    18.241   239.563     0.200
     5.201    80.831     0.200
     5.725    85.328     0.200
     6.417    93.469     0.200
     6.431    90.571     0.200
     8.079   111.118     0.200
     8.099   111.381     0.200
     8.480   122.456     0.200
     8.529   120.680     0.200
     8.772   119.594     0.200
     9.559   129.352     0.200
    11.335   149.457     0.200
    12.742   168.179     0.200
    16.669   219.296     0.200
     3.489    58.576     0.200
     4.048    62.692     0.200
     4.785    74.814     0.200
     4.925    75.898     0.200
     5.304    79.649     0.200
     5.379    82.834     0.200
     5.852    92.966     0.200
     6.530    93.409     0.200
     7.163   101.253     0.200
     7.623   107.125     0.200
     8.327   116.547     0.200
     8.398   116.297     0.200
     8.398   120.377     0.200
     8.562   117.033     0.200
     9.670   128.268     0.200
    16.514   214.130     0.200
    18.191   236.520     0.200
    18.191   236.143     0.200
     4.339    62.366     0.200
     4.339    62.062     0.200
     5.256    76.110     0.200
     5.256    78.743     0.200
     5.606    79.310     0.200
     5.606    79.560     0.200
     5.785    84.112     0.200
     6.799    92.925     0.200
     6.799    92.605     0.200
     7.054    88.417     0.200
     7.410   100.324     0.200
     7.410   100.511     0.200
     7.660    98.169     0.200
     8.392   109.510     0.200
     8.392   110.057     0.200
     8.509   119.253     0.200
     8.712   122.026     0.200
     8.712   125.143     0.200
     9.867   128.232     0.200
    16.503   215.194     0.200
    18.169   236.367     0.200
     4.906    72.284     0.200
     5.360    80.198     0.200
     5.824    88.889     0.200
     7.144    99.280     0.200
     8.331   122.103     0.200
     8.396   124.391     0.200
     8.396   121.846     0.200
     2.617    46.864     0.200
     8.547   123.735     0.200
     8.719   123.467     0.200
     8.719   126.053     0.200
    14.686   186.769     0.200
    16.554   210.567     0.200
     3.595    62.684     0.200
     4.090    65.660     0.200
     4.831    76.270     0.200
     4.991    77.900     0.200
     5.461    79.202     0.200
     5.867    87.203     0.200
     6.055    94.309     0.200
     6.970    97.471     0.200
     7.538   111.026     0.200
     7.699   109.241     0.200
     7.734   110.022     0.200
     8.203   111.486     0.200
     8.202   112.444     0.200
     8.270   114.462     0.200
     8.293   113.408     0.200
     8.445   115.358     0.200
     8.428   113.126     0.200
     8.483   122.069     0.200
     8.608   119.814     0.200
     8.589   124.136     0.200
     8.589   125.667     0.200
     9.383   131.457     0.200
     9.626   130.936     0.200
     9.704   129.735     0.200
     9.927   138.530     0.200
    11.438   150.459     0.200
    16.601   218.242     0.200
    18.274   239.349     0.200
    19.207   257.236     0.200
     5.762    87.973     0.200
     6.234    94.277     0.200
     8.850   126.087     0.200
    12.215   157.978     0.200
    18.599   237.724     0.200
    18.724   245.349     0.200
     6.423    98.852     0.200
     8.440   120.659     0.200
     8.759   121.832     0.200
    13.464   176.285     0.200
    13.655   178.955     0.200
    15.101   195.289     0.200
    15.297   197.598     0.200
    16.294   218.658     0.200
    16.983   217.320     0.200
    16.987   217.879     0.200
    17.953   234.483     0.200
    18.877   248.869     0.200
    19.209   253.648     0.200
    20.425   268.547     0.200
     3.977    62.686     0.200
     4.714    75.975     0.200
     5.234    80.520     0.200
     5.331    81.957     0.200
     5.878    93.892     0.200
     6.430    96.364     0.200
     6.457    95.317     0.200
     6.971   102.067     0.200
     6.995    99.996     0.200
     7.416   103.734     0.200
     7.549   108.361     0.200
     7.989   110.820     0.200
     8.135   111.916     0.200
     8.142   111.573     0.200
     8.161   112.063     0.200
     8.237   113.010     0.200
     8.264   115.116     0.200
     8.348   115.151     0.200
     8.398   124.054     0.200
     8.450   119.464     0.200
     8.846   120.645     0.200
     9.519   130.911     0.200
     9.597   130.212     0.200
    12.340   162.077     0.200
    12.763   167.334     0.200
    12.971   170.415     0.200
    13.601   177.759     0.200
    14.164   184.094     0.200
    14.994   193.334     0.200
    15.265   212.163     0.200
    15.625   214.012     0.200
    15.951   212.631     0.200
    16.260   208.328     0.200
    16.596   215.490     0.200
    18.273   241.305     0.200
    18.273   237.320     0.200
    18.326   246.420     0.200
    19.654   262.816     0.200
     1.423    30.709     0.200
     2.328    38.591     0.200
     2.328    38.591     0.200
     1.423    30.709     0.200
     2.328    38.591     0.200
     3.970    64.524     0.200
     5.227    79.559     0.200
     5.326    82.765     0.200
     5.879    91.437     0.200
     6.449    94.007     0.200
     7.582   106.870     0.200
     8.127   111.400     0.200
     8.154   110.907     0.200
     8.484   118.964     0.200
     8.454   121.863     0.200
     9.511   129.210     0.200
    11.517   150.289     0.200
    12.333   160.821     0.200
    12.806   169.028     0.200
    12.756   165.982     0.200
    13.369   171.116     0.200
    17.067   217.881     0.200
    18.280   238.369     0.200
     1.427    29.053     0.200
     2.321    37.290     0.200
     2.321    37.349     0.200
     3.993    64.241     0.200
     4.730    76.361     0.200
     4.874    76.881     0.200
     5.250    81.248     0.200
     5.879    92.624     0.200
     6.473    94.289     0.200
     7.451   109.288     0.200
     7.565   107.176     0.200
     7.605   106.796     0.200
     7.655   114.338     0.200
     8.177   109.554     0.200
     8.343   112.693     0.200
     8.388   120.950     0.200
     8.507   117.623     0.200
     8.445   117.964     0.200
     8.445   122.128     0.200
    10.965   155.089     0.200
    11.539   151.227     0.200
    12.356   162.140     0.200
    12.827   168.698     0.200
    13.580   185.733     0.200
    16.582   222.256     0.200
    18.259   238.100     0.200
    18.259   240.979     0.200
    18.317   240.371     0.200
    18.578   248.649     0.200
     1.410    29.345     0.200
     2.344    37.464     0.200
     3.997    63.079     0.200
     4.735    75.500     0.200
     5.255    80.707     0.200
     5.349    82.751     0.200
     5.788    88.826     0.200
     5.880    93.094     0.200
     6.130    87.901     0.200
     6.477    95.779     0.200
     7.759   109.431     0.200
     8.181   111.229     0.200
     8.386   124.607     0.200
     8.445   120.711     0.200
     8.445   119.937     0.200
     8.445   124.413     0.200
     8.863   123.022     0.200
     9.539   126.805     0.200
    10.418   140.215     0.200
    12.361   163.768     0.200
    12.784   169.230     0.200
    12.991   172.511     0.200
    13.622   179.653     0.200
    14.184   187.089     0.200
    14.417   188.769     0.200
    16.578   219.382     0.200
    18.255   239.634     0.200
    18.255   242.371     0.200
     2.349    39.612     0.200
     4.737    72.953     0.200
     5.450    82.557     0.200
     5.910    92.465     0.200
     6.131    81.455     0.200
     6.477    91.915     0.200
     8.155   113.061     0.200
     8.403   115.885     0.200
     8.411   118.949     0.200
     8.474   121.759     0.200
     8.474   121.556     0.200
     8.514   114.475     0.200
    12.362   162.667     0.200
    13.605   181.687     0.200
    15.985   216.879     0.200
    16.595   218.120     0.200
    18.271   237.412     0.200
    18.271   235.123     0.200
     3.443    60.114     0.200
     3.971    62.736     0.200
     4.043    64.250     0.200
     4.710    73.256     0.200
     5.230    77.964     0.200
     5.343    81.096     0.200
     5.915    92.412     0.200
     6.448    92.982     0.200
     7.582   105.999     0.200
     8.118   108.073     0.200
     8.487   116.644     0.200
     8.435   115.188     0.200
     8.490   118.490     0.200
     8.490   120.917     0.200
     9.512   127.395     0.200
     9.590   126.561     0.200
    11.003   155.448     0.200
    12.334   161.409     0.200
    13.597   175.965     0.200
    13.627   184.646     0.200
    14.393   185.082     0.200
    16.624   217.743     0.200
    18.300   239.582     0.200
    18.300   237.423     0.200
     2.324    38.092     0.200
     3.460    58.873     0.200
     3.988    64.292     0.200
     4.726    76.339     0.200
     5.247    80.489     0.200
     5.434    84.020     0.200
     5.920    91.417     0.200
     6.436    93.212     0.200
     6.465    93.738     0.200
     8.428   120.084     0.200
     8.428   125.549     0.200
     8.489   115.289     0.200
     8.489   123.528     0.200
    12.351   161.073     0.200
    16.611   215.101     0.200
    18.287   234.844     0.200
    18.287   240.071     0.200
     4.047    66.708     0.200
     4.788    78.492     0.200
     5.311    83.625     0.200
     5.407    80.065     0.200
     6.174    91.471     0.200
     6.076    93.111     0.200
     6.515    96.273     0.200
     7.601   109.148     0.200
     8.047   112.966     0.200
     8.218   114.054     0.200
     8.393   115.940     0.200
     8.565   121.205     0.200
     8.783   119.555     0.200
     8.626   118.498     0.200
     8.626   121.432     0.200
     9.581   132.377     0.200
    10.312   136.182     0.200
    11.161   154.862     0.200
    11.385   152.650     0.200
    12.406   161.242     0.200
    12.768   166.053     0.200
    13.400   176.149     0.200
    14.239   183.254     0.200
    14.473   185.919     0.200
    18.502   243.923     0.200
    18.328   240.773     0.200
    19.581   261.511     0.200
    20.125   267.561     0.200
    20.565   270.923     0.200
     8.853   124.307     0.200
     8.864   119.722     0.200
     8.864   122.817     0.200
    17.028   226.749     0.200
     5.899    86.008     0.200
     8.422   123.679     0.200
     3.880    67.262     0.200
     5.745    86.139     0.200
     4.317    67.446     0.200
     2.929    48.697     0.200
     4.317    67.446     0.200
     4.317    67.446     0.200
     3.878    60.832     0.200
     4.317    67.446     0.200
     5.745    86.139     0.200
     4.153    65.840     0.200
     5.737    86.050     0.200
     4.309    67.374     0.200
     4.145    65.738     0.200
     4.145    65.738     0.200
     4.309    67.337     0.200
     2.921    48.585     0.200
     4.444    67.756     0.200
     4.309    67.337     0.200
     2.921    48.585     0.200
     4.309    67.337     0.200
     4.444    67.756     0.200
     4.444    67.756     0.200
     5.737    86.029     0.200
     5.737    86.029     0.200
     4.145    65.738     0.200
     5.737    86.029     0.200
     4.145    65.738     0.200
     4.145    65.738     0.200
     4.336    67.667     0.200
     4.336    67.667     0.200
     5.760    86.303     0.200
     4.156    65.849     0.200
     4.336    67.667     0.200
     5.760    86.303     0.200
     4.510    68.619     0.200
     3.538    58.567     0.200
     3.538    58.567     0.200
     3.538    58.567     0.200
     4.156    65.849     0.200
     5.760    86.303     0.200
     4.336    67.667     0.200
     4.336    67.667     0.200
     4.156    65.849     0.200
     4.336    67.667     0.200
     2.970    49.195     0.200
     4.510    68.619     0.200
     4.168    71.851     0.200
     4.341    67.741     0.200
     8.495   122.222     0.200
     4.373    68.098     0.200
     4.373    68.098     0.200
     4.373    68.098     0.200
     5.791    86.683     0.200
     5.791    86.683     0.200
     5.791    86.683     0.200
     5.791    86.683     0.200
     4.351    68.002     0.200
     4.351    68.017     0.200
     4.351    68.049     0.200
     5.777    86.577     0.200
     5.777    86.577     0.200
     4.351    67.877     0.200
     8.469   125.873     0.200
     2.937    48.803     0.200
     4.319    67.626     0.200
     4.319    67.650     0.200
     3.889    60.955     0.200
     4.150    65.959     0.200
     4.150    65.969     0.200
     4.345    67.775     0.200
     4.345    67.796     0.200
     5.769    86.432     0.200
     4.165    65.982     0.200
     4.345    67.805     0.200
     5.769    86.443     0.200
     4.517    68.938     0.200
     5.769    86.271     0.200
     5.769    86.283     0.200
     4.345    67.804     0.200
     4.345    67.780     0.200
     4.165    65.961     0.200
     4.345    67.780     0.200
     4.345    67.780     0.200
     4.165    65.961     0.200
     2.978    49.298     0.200
     3.546    58.666     0.200
     4.303    67.189     0.200
     5.731    85.931     0.200
     4.138    65.688     0.200
     4.303    67.158     0.200
     2.916    48.393     0.200
     4.442    67.535     0.200
     4.303    67.166     0.200
     2.916    48.400     0.200
     4.303    67.177     0.200
     4.442    67.555     0.200
     4.442    67.555     0.200
     5.731    85.892     0.200
     5.731    85.892     0.200
     4.138    65.614     0.200
     5.731    85.911     0.200
     4.138    65.633     0.200
     4.138    65.643     0.200
     3.939    70.600     0.200
     4.183    70.657     0.200
     5.925    87.408     0.200
     3.561    58.532     0.200
     3.561    58.542     0.200
     3.561    58.553     0.200
     4.174    65.928     0.200
     5.774    86.441     0.200
     4.349    67.824     0.200
     4.349    67.824     0.200
     4.174    65.957     0.200
     4.349    67.834     0.200
     2.974    49.520     0.200
     4.505    69.069     0.200
     4.349    67.988     0.200
     4.349    67.819     0.200
     4.174    65.946     0.200
     4.349    67.829     0.200
     4.349    67.829     0.200
     4.174    65.955     0.200
     2.974    49.442     0.200
     3.561    58.604     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.627    51.455     0.200
     5.751   114.002     0.200
     2.817    56.178     0.200
     8.132   166.146     0.200
     4.282    84.947     0.200
     2.930    58.646     0.200
     3.241    67.025     0.200
     5.670   121.672     0.200
     3.422    73.454     0.200
     2.982    61.027     0.200
     2.993    59.572     0.200
     3.013    61.753     0.200
     2.956    60.720     0.200
     3.284    67.883     0.200
     3.842    76.372     0.200
     6.558   125.683     0.200
     2.980    58.721     0.200
     2.967    60.472     0.200
     3.221    71.214     0.200
     8.280   171.478     0.200
     2.929    55.752     0.200
     3.022    59.002     0.200
     3.532    68.050     0.200
     2.756    55.479     0.200
     2.626    52.200     0.200
     5.740   109.455     0.200
     3.649    72.072     0.200
     3.875    76.236     0.200
     5.354   101.977     0.200
     3.629    71.180     0.200
     8.957   180.996     0.200
     8.962   181.048     0.200
     4.505    86.482     0.200
     4.546    92.293     0.200
     4.215    86.140     0.200
     9.059   151.544     0.200
     8.676   174.091     0.200
    10.507   220.472     0.200
    15.158   313.653     0.200
    17.115   352.215     0.200
     3.988    78.275     0.200
     8.428   113.767     0.200
     8.589   170.432     0.200
    15.060   289.584     0.200
    17.031   330.430     0.200
     4.211    84.514     0.200
     4.673    94.138     0.200
     5.593   109.269     0.200
     5.941   112.984     0.200
     8.450   168.394     0.200
    14.893   295.822     0.200
    16.896   336.724     0.200
    18.273   370.617     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     8.132   140.146     0.200
     3.284    64.587     0.200
     5.831   112.862     0.200
     5.670   102.672     0.200
     3.422    65.454     0.200
     5.868   105.918     0.200
     1.033    23.775     0.200
     3.327    63.702     0.200
     3.873    70.605     0.200
     4.259    76.100     0.200
     8.270   157.293     0.200
     4.647    85.881     0.200
     1.463    32.132     0.200
     3.304    63.434     0.200
     4.350    80.140     0.200
     4.610    87.604     0.200
     1.437    31.460     0.200
     2.501    48.053     0.200
     8.264   143.792     0.200
     5.725   102.960     0.200
     1.455    33.961     0.200
     2.471    48.806     0.200
     2.356    46.625     0.200
     2.105    43.710     0.200
     1.236    26.812     0.200
     4.056    75.898     0.200
     4.062    73.543     0.200
     4.764    86.212     0.200
     1.140    25.082     0.200
     3.535    64.228     0.200
     1.159    26.470     0.200
     1.266    29.177     0.200
     1.053    23.932     0.200
     3.479    62.239     0.200
     1.645    35.323     0.200
     1.494    31.504     0.200
     1.031    19.870     0.200
     1.314    24.908     0.200
     1.468    30.371     0.200
     0.957    18.462     0.200
     1.040    19.922     0.200
     0.640    12.867     0.200
     1.423    27.647     0.200
     1.427    27.092     0.200
     3.429    63.268     0.200
     3.450    60.947     0.200
     3.454    62.838     0.200
     1.389    26.496     0.200
     2.351    44.343     0.200
     1.406    26.480     0.200
     2.324    42.494     0.200
     1.391    26.169     0.200
     1.267    24.185     0.200
     3.565    64.214     0.200
     1.379    30.307     0.200
     1.379    29.674     0.200
     1.329    30.597     0.200
     1.331    29.960     0.200
     1.259    29.013     0.200
     1.390    29.950     0.200
     1.292    28.490     0.200
     1.300    29.183     0.200
     1.310    30.508     0.200
     1.259    29.347     0.200
     1.277    27.494     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
