#!/bin/bash
gmt begin kunar4.14_tt5s_local_KBU pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance kunar4.14'
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   100.000 Indirect calibration: shifted hypocenters used
EOF
# Station code
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   110.000 Single station: KBU  
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.200    26.427
     1.300    27.778
     1.400    29.129
     1.500    30.481
     1.600    31.832
     1.700    33.184
     1.800    34.535
     1.900    35.887
     2.000    37.238
     2.100    38.589
     2.200    39.941
     2.300    41.292
     2.400    42.644
     2.500    43.995
     2.600    45.347
     2.700    46.698
     2.800    48.049
     2.900    49.401
     3.000    50.752
     3.100    52.104
     3.200    53.455
     3.300    54.806
     3.400    56.158
     3.500    57.509
     3.600    58.860
     3.700    60.211
     3.800    61.563
     3.900    62.913
     4.000    64.265
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    56.860 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.232
     0.200     4.552
     0.300     6.153
     0.400     7.864
     0.500     9.626
     0.600    11.417
     0.700    13.225
     0.800    15.043
     0.900    16.868
     1.000    18.610
     1.100    20.315
     1.200    22.020
     1.300    23.725
     1.400    25.430
     1.500    27.135
     1.600    28.841
     1.700    30.546
     1.800    32.251
     1.900    33.956
     2.000    35.661
     2.100    37.366
     2.200    39.071
     2.300    40.777
     2.400    42.482
     2.500    44.187
     2.600    45.892
     2.700    47.597
     2.800    49.302
     2.900    51.008
     3.000    52.713
     3.100    54.418
     3.200    56.123
     3.300    57.828
     3.400    59.533
     3.500    61.237
     3.600    62.942
     3.700    64.646
     3.800    66.351
     3.900    68.056
     4.000    69.760
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.942 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.300    48.849
     1.400    51.243
     1.500    53.638
     1.600    56.032
     1.700    58.426
     1.800    60.821
     1.900    63.215
     2.000    65.610
     2.100    68.004
     2.200    70.398
     2.300    72.793
     2.400    75.187
     2.500    77.582
     2.600    79.976
     2.700    82.370
     2.800    84.765
     2.900    87.159
     3.000    89.554
     3.100    91.948
     3.200    94.342
     3.300    96.736
     3.400    99.130
     3.500   101.524
     3.600   103.918
     3.700   106.312
     3.800   108.706
     3.900   111.100
     4.000   113.494
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600   101.918 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.967
     0.200     8.404
     0.300    11.358
     0.400    14.518
     0.500    17.772
     0.600    21.078
     0.700    24.405
     0.800    27.361
     0.900    30.316
     1.000    33.272
     1.100    36.228
     1.200    39.183
     1.300    42.139
     1.400    45.094
     1.500    48.050
     1.600    51.005
     1.700    53.961
     1.800    56.917
     1.900    59.872
     2.000    62.828
     2.100    65.783
     2.200    68.739
     2.300    71.695
     2.400    74.650
     2.500    77.606
     2.600    80.561
     2.700    83.517
     2.800    86.473
     2.900    89.428
     3.000    92.384
     3.100    95.339
     3.200    98.295
     3.300   101.250
     3.400   104.205
     3.500   107.159
     3.600   110.114
     3.700   113.068
     3.800   116.023
     3.900   118.977
     4.000   121.932
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   109.114 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.400    30.598
     1.500    31.949
     1.600    33.301
     1.700    34.652
     1.800    36.004
     1.900    37.355
     2.000    38.706
     2.100    40.058
     2.200    41.409
     2.300    42.761
     2.400    44.112
     2.500    45.464
     2.600    46.815
     2.700    48.166
     2.800    49.518
     2.900    50.869
     3.000    52.221
     3.100    53.572
     3.200    54.924
     3.300    56.275
     3.400    57.626
     3.500    58.978
     3.600    60.329
     3.700    61.680
     3.800    63.031
     3.900    64.382
     4.000    65.733
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.919
     0.200     3.739
     0.300     5.581
     0.400     7.428
     0.500     9.278
     0.600    11.128
     0.700    12.979
     0.800    14.831
     0.900    16.683
     1.000    18.535
     1.100    20.387
     1.200    22.239
     1.300    24.091
     1.400    25.944
     1.500    27.796
     1.600    29.648
     1.700    31.381
     1.800    33.086
     1.900    34.791
     2.000    36.496
     2.100    38.201
     2.200    39.906
     2.300    41.611
     2.400    43.317
     2.500    45.022
     2.600    46.727
     2.700    48.432
     2.800    50.137
     2.900    51.842
     3.000    53.548
     3.100    55.253
     3.200    56.958
     3.300    58.663
     3.400    60.368
     3.500    62.073
     3.600    63.778
     3.700    65.483
     3.800    67.188
     3.900    68.893
     4.000    70.597
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.400    54.074
     1.500    56.468
     1.600    58.863
     1.700    61.257
     1.800    63.652
     1.900    66.046
     2.000    68.440
     2.100    70.835
     2.200    73.229
     2.300    75.624
     2.400    78.018
     2.500    80.412
     2.600    82.807
     2.700    85.201
     2.800    87.596
     2.900    89.990
     3.000    92.384
     3.100    94.779
     3.200    97.173
     3.300    99.568
     3.400   101.961
     3.500   104.356
     3.600   106.750
     3.700   109.144
     3.800   111.538
     3.900   113.932
     4.000   116.326
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.543
     0.200     6.903
     0.300    10.303
     0.400    13.713
     0.500    17.127
     0.600    20.544
     0.700    23.962
     0.800    27.380
     0.900    30.799
     1.000    34.218
     1.100    37.637
     1.200    41.057
     1.300    44.129
     1.400    47.085
     1.500    50.040
     1.600    52.996
     1.700    55.952
     1.800    58.907
     1.900    61.863
     2.000    64.818
     2.100    67.774
     2.200    70.730
     2.300    73.685
     2.400    76.641
     2.500    79.596
     2.600    82.552
     2.700    85.508
     2.800    88.463
     2.900    91.419
     3.000    94.374
     3.100    97.330
     3.200   100.286
     3.300   103.241
     3.400   106.196
     3.500   109.151
     3.600   112.106
     3.700   115.061
     3.800   118.015
     3.900   120.970
     4.000   123.924
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    17.286
     0.900    18.637
     1.000    19.989
     1.100    21.340
     1.200    22.692
     1.300    24.043
     1.400    25.394
     1.500    26.746
     1.600    28.097
     1.700    29.449
     1.800    30.800
     1.900    32.152
     2.000    33.503
     2.100    34.855
     2.200    36.206
     2.300    37.557
     2.400    38.909
     2.500    40.260
     2.600    41.612
     2.700    42.963
     2.800    44.314
     2.900    45.666
     3.000    47.017
     3.100    48.368
     3.200    49.719
     3.300    51.071
     3.400    52.422
     3.500    53.773
     3.600    55.124
     3.700    56.475
     3.800    57.826
     3.900    59.177
     4.000    60.528
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     8.892
     0.200     9.397
     0.300    10.181
     0.400    11.187
     0.500    12.359
     0.600    13.654
     0.700    15.040
     0.800    16.493
     0.900    17.996
     1.000    19.537
     1.100    21.107
     1.200    22.699
     1.300    24.309
     1.400    25.933
     1.500    27.568
     1.600    29.212
     1.700    30.864
     1.800    32.522
     1.900    34.184
     2.000    35.852
     2.100    37.522
     2.200    39.196
     2.300    40.873
     2.400    42.551
     2.500    44.232
     2.600    45.914
     2.700    47.598
     2.800    49.283
     2.900    50.969
     3.000    52.656
     3.100    54.344
     3.200    56.033
     3.300    57.723
     3.400    59.413
     3.500    61.104
     3.600    62.796
     3.700    64.487
     3.800    66.180
     3.900    67.872
     4.000    69.565
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    30.534
     0.900    32.929
     1.000    35.323
     1.100    37.717
     1.200    40.112
     1.300    42.506
     1.400    44.900
     1.500    47.295
     1.600    49.689
     1.700    52.084
     1.800    54.478
     1.900    56.872
     2.000    59.267
     2.100    61.661
     2.200    64.055
     2.300    66.450
     2.400    68.844
     2.500    71.239
     2.600    73.633
     2.700    76.028
     2.800    78.421
     2.900    80.815
     3.000    83.209
     3.100    85.603
     3.200    87.997
     3.300    90.392
     3.400    92.786
     3.500    95.179
     3.600    97.573
     3.700    99.967
     3.800   102.361
     3.900   104.754
     4.000   107.148
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100    15.796
     0.200    16.688
     0.300    18.076
     0.400    19.852
     0.500    21.920
     0.600    24.201
     0.700    26.639
     0.800    29.189
     0.900    31.823
     1.000    34.520
     1.100    37.263
     1.200    40.043
     1.300    42.851
     1.400    45.680
     1.500    48.526
     1.600    51.387
     1.700    54.258
     1.800    57.139
     1.900    60.028
     2.000    62.923
     2.100    65.824
     2.200    68.730
     2.300    71.639
     2.400    74.552
     2.500    77.468
     2.600    80.386
     2.700    83.307
     2.800    86.230
     2.900    89.154
     3.000    92.080
     3.100    95.008
     3.200    97.937
     3.300   100.867
     3.400   103.798
     3.500   106.729
     3.600   109.662
     3.700   112.596
     3.800   115.530
     3.900   118.464
     4.000   121.399
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.319    24.848     0.200
     0.573    10.621     0.200
     1.339    24.186     0.200
     1.318    23.938     0.200
     1.193    21.812     0.200
     1.379    25.703     0.200
     1.379    25.352     0.200
     1.404    26.648     0.200
     1.329    24.789     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.379    46.398     0.200
     1.379    45.766     0.200
     1.329    46.109     0.200
     1.331    45.487     0.200
     1.259    43.703     0.200
     1.390    46.172     0.200
     1.292    43.572     0.200
     1.300    44.359     0.200
     1.310    45.790     0.200
     1.259    44.040     0.200
     1.277    42.395     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.379    46.398     0.200
     1.379    45.766     0.200
     1.329    46.109     0.200
     1.331    45.487     0.200
     1.259    43.703     0.200
     1.390    46.172     0.200
     1.292    43.572     0.200
     1.300    44.359     0.200
     1.310    45.790     0.200
     1.259    44.040     0.200
     1.277    42.395     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
