#!/bin/bash
gmt begin kunar4.14_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance kunar4.14'
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.200   100.000 Indirect calibration: shifted hypocenters used
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.200    26.427
     1.300    27.778
     1.400    29.129
     1.500    30.481
     1.600    31.832
     1.700    33.184
     1.800    34.535
     1.900    35.887
     2.000    37.238
     2.100    38.589
     2.200    39.941
     2.300    41.292
     2.400    42.644
     2.500    43.995
     2.600    45.347
     2.700    46.698
     2.800    48.049
     2.900    49.401
     3.000    50.752
     3.100    52.104
     3.200    53.455
     3.300    54.806
     3.400    56.158
     3.500    57.509
     3.600    58.860
     3.700    60.211
     3.800    61.563
     3.900    62.913
     4.000    64.265
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    56.860 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.232
     0.200     4.552
     0.300     6.153
     0.400     7.864
     0.500     9.626
     0.600    11.417
     0.700    13.225
     0.800    15.043
     0.900    16.868
     1.000    18.610
     1.100    20.315
     1.200    22.020
     1.300    23.725
     1.400    25.430
     1.500    27.135
     1.600    28.841
     1.700    30.546
     1.800    32.251
     1.900    33.956
     2.000    35.661
     2.100    37.366
     2.200    39.071
     2.300    40.777
     2.400    42.482
     2.500    44.187
     2.600    45.892
     2.700    47.597
     2.800    49.302
     2.900    51.008
     3.000    52.713
     3.100    54.418
     3.200    56.123
     3.300    57.828
     3.400    59.533
     3.500    61.237
     3.600    62.942
     3.700    64.646
     3.800    66.351
     3.900    68.056
     4.000    69.760
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.942 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     1.300    48.849
     1.400    51.243
     1.500    53.638
     1.600    56.032
     1.700    58.426
     1.800    60.821
     1.900    63.215
     2.000    65.610
     2.100    68.004
     2.200    70.398
     2.300    72.793
     2.400    75.187
     2.500    77.582
     2.600    79.976
     2.700    82.370
     2.800    84.765
     2.900    87.159
     3.000    89.554
     3.100    91.948
     3.200    94.342
     3.300    96.736
     3.400    99.130
     3.500   101.524
     3.600   103.918
     3.700   106.312
     3.800   108.706
     3.900   111.100
     4.000   113.494
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600   101.918 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.967
     0.200     8.404
     0.300    11.358
     0.400    14.518
     0.500    17.772
     0.600    21.078
     0.700    24.405
     0.800    27.361
     0.900    30.316
     1.000    33.272
     1.100    36.228
     1.200    39.183
     1.300    42.139
     1.400    45.094
     1.500    48.050
     1.600    51.005
     1.700    53.961
     1.800    56.917
     1.900    59.872
     2.000    62.828
     2.100    65.783
     2.200    68.739
     2.300    71.695
     2.400    74.650
     2.500    77.606
     2.600    80.561
     2.700    83.517
     2.800    86.473
     2.900    89.428
     3.000    92.384
     3.100    95.339
     3.200    98.295
     3.300   101.250
     3.400   104.205
     3.500   107.159
     3.600   110.114
     3.700   113.068
     3.800   116.023
     3.900   118.977
     4.000   121.932
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   109.114 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.400    30.598
     1.500    31.949
     1.600    33.301
     1.700    34.652
     1.800    36.004
     1.900    37.355
     2.000    38.706
     2.100    40.058
     2.200    41.409
     2.300    42.761
     2.400    44.112
     2.500    45.464
     2.600    46.815
     2.700    48.166
     2.800    49.518
     2.900    50.869
     3.000    52.221
     3.100    53.572
     3.200    54.924
     3.300    56.275
     3.400    57.626
     3.500    58.978
     3.600    60.329
     3.700    61.680
     3.800    63.031
     3.900    64.382
     4.000    65.733
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.919
     0.200     3.739
     0.300     5.581
     0.400     7.428
     0.500     9.278
     0.600    11.128
     0.700    12.979
     0.800    14.831
     0.900    16.683
     1.000    18.535
     1.100    20.387
     1.200    22.239
     1.300    24.091
     1.400    25.944
     1.500    27.796
     1.600    29.648
     1.700    31.381
     1.800    33.086
     1.900    34.791
     2.000    36.496
     2.100    38.201
     2.200    39.906
     2.300    41.611
     2.400    43.317
     2.500    45.022
     2.600    46.727
     2.700    48.432
     2.800    50.137
     2.900    51.842
     3.000    53.548
     3.100    55.253
     3.200    56.958
     3.300    58.663
     3.400    60.368
     3.500    62.073
     3.600    63.778
     3.700    65.483
     3.800    67.188
     3.900    68.893
     4.000    70.597
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.400    54.074
     1.500    56.468
     1.600    58.863
     1.700    61.257
     1.800    63.652
     1.900    66.046
     2.000    68.440
     2.100    70.835
     2.200    73.229
     2.300    75.624
     2.400    78.018
     2.500    80.412
     2.600    82.807
     2.700    85.201
     2.800    87.596
     2.900    89.990
     3.000    92.384
     3.100    94.779
     3.200    97.173
     3.300    99.568
     3.400   101.961
     3.500   104.356
     3.600   106.750
     3.700   109.144
     3.800   111.538
     3.900   113.932
     4.000   116.326
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.543
     0.200     6.903
     0.300    10.303
     0.400    13.713
     0.500    17.127
     0.600    20.544
     0.700    23.962
     0.800    27.380
     0.900    30.799
     1.000    34.218
     1.100    37.637
     1.200    41.057
     1.300    44.129
     1.400    47.085
     1.500    50.040
     1.600    52.996
     1.700    55.952
     1.800    58.907
     1.900    61.863
     2.000    64.818
     2.100    67.774
     2.200    70.730
     2.300    73.685
     2.400    76.641
     2.500    79.596
     2.600    82.552
     2.700    85.508
     2.800    88.463
     2.900    91.419
     3.000    94.374
     3.100    97.330
     3.200   100.286
     3.300   103.241
     3.400   106.196
     3.500   109.151
     3.600   112.106
     3.700   115.061
     3.800   118.015
     3.900   120.970
     4.000   123.924
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    17.286
     0.900    18.637
     1.000    19.989
     1.100    21.340
     1.200    22.692
     1.300    24.043
     1.400    25.394
     1.500    26.746
     1.600    28.097
     1.700    29.449
     1.800    30.800
     1.900    32.152
     2.000    33.503
     2.100    34.855
     2.200    36.206
     2.300    37.557
     2.400    38.909
     2.500    40.260
     2.600    41.612
     2.700    42.963
     2.800    44.314
     2.900    45.666
     3.000    47.017
     3.100    48.368
     3.200    49.719
     3.300    51.071
     3.400    52.422
     3.500    53.773
     3.600    55.124
     3.700    56.475
     3.800    57.826
     3.900    59.177
     4.000    60.528
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100     8.892
     0.200     9.397
     0.300    10.181
     0.400    11.187
     0.500    12.359
     0.600    13.654
     0.700    15.040
     0.800    16.493
     0.900    17.996
     1.000    19.537
     1.100    21.107
     1.200    22.699
     1.300    24.309
     1.400    25.933
     1.500    27.568
     1.600    29.212
     1.700    30.864
     1.800    32.522
     1.900    34.184
     2.000    35.852
     2.100    37.522
     2.200    39.196
     2.300    40.873
     2.400    42.551
     2.500    44.232
     2.600    45.914
     2.700    47.598
     2.800    49.283
     2.900    50.969
     3.000    52.656
     3.100    54.344
     3.200    56.033
     3.300    57.723
     3.400    59.413
     3.500    61.104
     3.600    62.796
     3.700    64.487
     3.800    66.180
     3.900    67.872
     4.000    69.565
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    30.534
     0.900    32.929
     1.000    35.323
     1.100    37.717
     1.200    40.112
     1.300    42.506
     1.400    44.900
     1.500    47.295
     1.600    49.689
     1.700    52.084
     1.800    54.478
     1.900    56.872
     2.000    59.267
     2.100    61.661
     2.200    64.055
     2.300    66.450
     2.400    68.844
     2.500    71.239
     2.600    73.633
     2.700    76.028
     2.800    78.421
     2.900    80.815
     3.000    83.209
     3.100    85.603
     3.200    87.997
     3.300    90.392
     3.400    92.786
     3.500    95.179
     3.600    97.573
     3.700    99.967
     3.800   102.361
     3.900   104.754
     4.000   107.148
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
     0.100    15.796
     0.200    16.688
     0.300    18.076
     0.400    19.852
     0.500    21.920
     0.600    24.201
     0.700    26.639
     0.800    29.189
     0.900    31.823
     1.000    34.520
     1.100    37.263
     1.200    40.043
     1.300    42.851
     1.400    45.680
     1.500    48.526
     1.600    51.387
     1.700    54.258
     1.800    57.139
     1.900    60.028
     2.000    62.923
     2.100    65.824
     2.200    68.730
     2.300    71.639
     2.400    74.552
     2.500    77.468
     2.600    80.386
     2.700    83.307
     2.800    86.230
     2.900    89.154
     3.000    92.080
     3.100    95.008
     3.200    97.937
     3.300   100.867
     3.400   103.798
     3.500   106.729
     3.600   109.662
     3.700   112.596
     3.800   115.530
     3.900   118.464
     4.000   121.399
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     3.166    55.117     0.200
     4.341    68.117     0.200
     4.079    66.117     0.200
     4.197    70.117     0.200
     4.143    68.117     0.200
     5.523    87.117     0.200
     5.801    89.117     0.200
     5.751    90.117     0.200
     5.957    93.117     0.200
     6.110    95.117     0.200
     6.568   103.117     0.200
     6.574   101.117     0.200
     7.488   112.117     0.200
     7.503   113.117     0.200
     7.628   114.117     0.200
     8.420   127.117     0.200
     8.532   128.117     0.200
     9.270   136.117     0.200
     9.547   141.117     0.200
     9.790   139.117     0.200
     9.560   141.117     0.200
     9.646   143.117     0.200
     9.870   146.117     0.200
    12.488   178.117     0.200
    16.019   224.117     0.200
    16.486   233.117     0.200
    17.725   247.117     0.200
    20.164   277.117     0.200
     4.285    70.047     0.200
     6.146    96.047     0.200
     6.701   103.047     0.200
     8.132   117.047     0.200
     8.132   121.047     0.200
     8.627   130.047     0.200
     9.276   137.047     0.200
    10.545   154.047     0.200
    12.400   176.047     0.200
    16.357   227.047     0.200
    16.281   230.047     0.200
    19.966   275.047     0.200
     3.284    58.914     0.200
     4.179    69.914     0.200
     4.282    70.914     0.200
     5.694    87.914     0.200
     5.831    91.414     0.200
     6.120    95.914     0.200
     6.911   105.914     0.200
     6.704   103.914     0.200
     7.475   111.613     0.200
     7.802   116.914     0.200
     8.084   118.414     0.200
     8.590   129.914     0.200
     9.445   139.914     0.200
     9.720   144.914     0.200
     9.893   146.914     0.200
     9.808   145.914     0.200
    10.140   151.414     0.200
    10.616   152.914     0.200
    10.801   154.914     0.200
    12.468   177.914     0.200
    17.088   237.914     0.200
     2.930    53.843     0.200
     3.241    56.843     0.200
     4.075    68.143     0.200
     5.670    89.243     0.200
     6.246    97.843     0.200
     6.684   101.843     0.200
     7.790   117.942     0.200
     8.338   123.343     0.200
     8.766   130.843     0.200
     9.062   135.343     0.200
     9.990   146.843     0.200
    10.041   148.843     0.200
    10.053   148.843     0.200
    10.257   148.843     0.200
    17.273   243.843     0.200
     3.125    55.059     0.200
     4.055    66.659     0.200
     5.860    90.959     0.200
     5.860    91.459     0.200
     6.518   101.959     0.200
     7.505   113.659     0.200
     8.122   118.759     0.200
     8.310   124.959     0.200
     8.310   125.659     0.200
     9.419   139.959     0.200
     9.419   140.259     0.200
     9.589   139.959     0.200
     9.512   141.959     0.200
     9.525   141.959     0.200
    10.719   152.959     0.200
    10.719   153.459     0.200
    12.555   178.959     0.200
    12.555   179.459     0.200
    14.077   198.259     0.200
    15.537   218.459     0.200
    16.548   233.959     0.200
    16.606   231.959     0.200
    18.689   259.959     0.200
    20.163   279.959     0.200
    20.385   279.959     0.200
     3.422    57.395     0.200
     3.422    57.895     0.200
     4.267    69.395     0.200
     6.864   105.895     0.200
     6.864   105.395     0.200
     8.144   118.395     0.200
     8.131   121.395     0.200
     8.131   121.795     0.200
     8.885   131.395     0.200
     9.207   137.295     0.200
    10.061   150.395     0.200
    10.145   149.395     0.200
    10.132   149.695     0.200
    17.388   243.395     0.200
     3.080    48.525     0.200
     3.886    64.326     0.200
     4.168    68.127     0.200
     4.170    68.826     0.200
     4.281    70.326     0.200
     4.281    70.326     0.200
     4.365    70.826     0.200
     4.377    71.627     0.200
     5.336    81.826     0.200
     5.770    90.025     0.200
     6.303    97.525     0.200
     6.769   103.127     0.200
     7.690   115.326     0.200
     8.072   119.826     0.200
     8.072   120.326     0.200
     8.234   119.627     0.200
     8.812   131.326     0.200
     9.149   134.127     0.200
     9.549   138.826     0.200
     9.808   144.025     0.200
     9.993   147.627     0.200
    10.009   145.826     0.200
    10.009   146.326     0.200
    10.071   148.127     0.200
    10.084   148.127     0.200
    10.535   150.826     0.200
    10.535   151.326     0.200
    11.346   160.727     0.200
    12.216   173.826     0.200
    14.272   199.326     0.200
    15.794   220.525     0.200
    16.068   226.826     0.200
    16.299   227.826     0.200
    17.317   240.326     0.200
    18.137   252.227     0.200
    18.583   260.326     0.200
    19.278   267.826     0.200
    19.251   267.826     0.200
    19.717   275.826     0.200
    19.719   272.826     0.200
    19.756   272.826     0.200
    19.867   273.426     0.200
    20.357   277.826     0.200
    20.557   279.826     0.200
     3.278    52.406     0.200
     3.317    55.805     0.200
     3.317    56.105     0.200
     3.873    63.004     0.200
     4.030    65.105     0.200
     4.130    67.305     0.200
     4.152    66.805     0.200
     4.152    66.906     0.200
     4.259    69.805     0.200
     4.348    68.805     0.200
     4.348    69.406     0.200
     4.373    69.805     0.200
     4.373    70.203     0.200
     5.311    81.805     0.200
     6.312    96.805     0.200
     6.594   102.805     0.200
     6.760   102.805     0.200
     6.760   103.605     0.200
     7.732   114.406     0.200
     8.095   119.805     0.200
     8.095   120.203     0.200
     8.270   121.805     0.200
     8.827   131.805     0.200
     9.102   132.805     0.200
     9.760   142.805     0.200
    10.014   147.805     0.200
    10.035   147.805     0.200
    10.093   147.805     0.200
    10.093   148.305     0.200
    10.306   147.805     0.200
    10.306   148.305     0.200
    10.490   149.805     0.200
    10.490   150.105     0.200
    11.345   160.703     0.200
    14.312   201.004     0.200
    14.371   200.605     0.200
    14.405   200.703     0.200
    14.618   203.605     0.200
    15.965   225.805     0.200
    16.202   228.805     0.200
    16.311   228.203     0.200
    17.333   240.805     0.200
    17.564   242.805     0.200
    18.185   252.504     0.200
    19.203   268.305     0.200
    19.676   272.004     0.200
    19.709   273.906     0.200
    19.821   272.805     0.200
     2.575    45.113     0.200
     3.013    53.812     0.200
     3.869    63.711     0.200
     4.023    66.312     0.200
     4.023    67.012     0.200
     4.130    67.914     0.200
     4.144    66.812     0.200
     4.149    66.312     0.200
     4.149    67.113     0.200
     4.246    69.414     0.200
     4.341    69.711     0.200
     5.730    89.012     0.200
     6.329    97.312     0.200
     6.329    97.414     0.200
     6.628   103.312     0.200
     6.760    99.312     0.200
     6.760    99.812     0.200
     8.299   120.312     0.200
     8.124   120.312     0.200
     8.124   121.211     0.200
     8.849   131.312     0.200
     8.849   131.812     0.200
     9.059   131.312     0.200
     9.714   143.113     0.200
    10.067   148.312     0.200
    10.067   148.812     0.200
    10.121   150.012     0.200
    10.266   148.312     0.200
    10.266   148.812     0.200
    10.450   150.312     0.200
    14.345   201.812     0.200
    14.410   201.512     0.200
    14.444   200.914     0.200
    14.657   204.414     0.200
    15.045   208.312     0.200
    16.241   227.812     0.200
    17.355   243.312     0.200
    17.355   244.113     0.200
    18.619   261.312     0.200
     2.534    45.508     0.200
     2.956    53.609     0.200
     3.299    53.414     0.200
     3.284    57.414     0.200
     3.842    63.609     0.200
     3.946    67.312     0.200
     4.000    66.812     0.200
     4.097    67.812     0.200
     4.123    68.211     0.200
     4.123    67.609     0.200
     4.233    69.914     0.200
     4.339    71.211     0.200
     4.339    71.609     0.200
     4.598    75.211     0.200
     5.376    84.008     0.200
     5.722    89.414     0.200
     6.275    96.109     0.200
     6.558   103.211     0.200
     7.136   110.211     0.200
     8.284   120.211     0.200
     8.057   120.211     0.200
     8.057   120.609     0.200
     8.789   130.211     0.200
     8.789   131.008     0.200
     9.108   133.414     0.200
     9.774   144.008     0.200
     9.976   148.211     0.200
     9.998   148.211     0.200
     9.998   149.008     0.200
    10.055   149.211     0.200
    10.306   149.211     0.200
    10.490   151.211     0.200
    11.381   162.008     0.200
    14.322   200.812     0.200
    14.372   201.609     0.200
    14.406   201.414     0.200
    14.619   205.008     0.200
    15.057   209.711     0.200
    16.343   231.711     0.200
    16.168   227.211     0.200
    17.295   243.211     0.200
    17.295   243.609     0.200
    18.176   254.609     0.200
    19.822   274.812     0.200
    19.998   275.211     0.200
    20.601   280.711     0.200
     2.536    44.891     0.200
     2.980    52.891     0.200
     3.226    57.391     0.200
     3.304    57.391     0.200
     3.872    64.191     0.200
     4.018    65.492     0.200
     4.018    65.992     0.200
     4.117    67.492     0.200
     4.141    66.891     0.200
     4.141    67.492     0.200
     4.486    68.992     0.200
     4.337    69.492     0.200
     4.337    70.391     0.200
     4.360    70.691     0.200
     5.395    77.391     0.200
     5.736    89.391     0.200
     6.298    98.492     0.200
     6.581   102.492     0.200
     6.747   101.492     0.200
     6.747   101.992     0.200
     8.081   119.492     0.200
     8.081   119.691     0.200
     8.277   120.293     0.200
     8.813   131.492     0.200
     8.813   131.992     0.200
     9.102   134.293     0.200
     9.764   144.492     0.200
    10.000   147.492     0.200
    10.080   145.492     0.200
    10.022   146.492     0.200
    10.304   149.492     0.200
    12.170   172.492     0.200
    14.373   200.992     0.200
    14.407   201.594     0.200
    14.620   204.793     0.200
    16.191   225.992     0.200
    16.323   229.191     0.200
    17.319   241.492     0.200
    18.183   253.191     0.200
    19.337   265.492     0.200
    19.709   272.492     0.200
    19.997   274.492     0.200
     2.534    45.898     0.200
     2.899    50.000     0.200
     2.967    54.500     0.200
     3.292    54.102     0.200
     3.221    58.898     0.200
     3.294    58.305     0.200
     3.852    64.805     0.200
     4.180    67.602     0.200
     3.956    67.703     0.200
     4.009    67.000     0.200
     4.108    68.703     0.200
     4.132    68.305     0.200
     4.132    68.703     0.200
     4.241    70.500     0.200
     4.328    71.305     0.200
     4.350    71.703     0.200
     4.610    76.102     0.200
     4.610    76.703     0.200
     5.336    84.102     0.200
     5.729    90.102     0.200
     6.286    98.102     0.200
     6.286    98.398     0.200
     6.569   104.102     0.200
     6.737   103.102     0.200
     6.737   103.703     0.200
     7.736   115.898     0.200
     8.069   121.102     0.200
     8.069   121.398     0.200
     8.280   121.102     0.200
     8.801   132.305     0.200
     9.106   135.102     0.200
     9.716   140.703     0.200
     9.770   145.805     0.200
     9.988   148.102     0.200
     9.988   148.500     0.200
    10.010   147.102     0.200
    10.010   147.805     0.200
    10.067   149.102     0.200
    10.079   149.102     0.200
    10.490   152.102     0.200
    11.370   163.500     0.200
    14.319   203.398     0.200
    14.372   202.500     0.200
    14.406   202.203     0.200
    14.619   205.102     0.200
    15.049   211.602     0.200
    16.026   228.102     0.200
    16.179   226.703     0.200
    16.333   229.602     0.200
    17.253   240.102     0.200
    17.585   245.102     0.200
    19.712   275.102     0.200
    19.822   275.102     0.200
    20.402   280.102     0.200
     2.377    41.836     0.200
     2.501    44.133     0.200
     2.928    48.633     0.200
     2.929    51.836     0.200
     3.287    52.336     0.200
     3.277    55.734     0.200
     3.838    62.734     0.200
     4.150    65.234     0.200
     3.999    64.336     0.200
     4.119    66.234     0.200
     4.123    67.234     0.200
     4.325    69.336     0.200
     4.317    68.836     0.200
     4.609    73.234     0.200
     6.370    98.133     0.200
     6.519   101.234     0.200
     6.718   103.234     0.200
     7.710   109.836     0.200
     8.264   119.234     0.200
     8.760   130.234     0.200
     9.145   135.234     0.200
     9.687   139.938     0.200
     9.943   145.734     0.200
     9.962   145.234     0.200
     9.816   144.234     0.200
    10.021   147.938     0.200
    10.339   151.234     0.200
    10.524   151.836     0.200
    11.399   162.336     0.200
    13.779   192.836     0.200
    14.297   199.336     0.200
    14.341   200.234     0.200
    14.374   200.031     0.200
    14.587   203.734     0.200
    14.763   205.438     0.200
    15.844   221.734     0.200
    16.126   224.234     0.200
    17.601   244.234     0.200
     2.333    42.273     0.200
     2.671    45.672     0.200
     3.022    49.273     0.200
     3.532    59.273     0.200
     3.963    63.273     0.200
     7.503   109.273     0.200
     8.021   117.273     0.200
     8.632   125.977     0.200
     9.288   136.273     0.200
     9.490   137.273     0.200
    11.139   156.977     0.200
    13.596   190.773     0.200
    14.155   197.375     0.200
    14.192   198.273     0.200
     1.871    36.441     0.200
     2.516    46.242     0.200
     3.307    54.840     0.200
     5.394    87.941     0.200
     6.510   103.941     0.200
     7.727   116.441     0.200
     8.283   121.941     0.200
     9.133   136.941     0.200
    13.795   194.941     0.200
    14.356   202.543     0.200
    14.389   202.742     0.200
    14.603   205.742     0.200
    14.778   207.543     0.200
     6.473   101.090     0.200
     8.201   118.090     0.200
     8.740   129.490     0.200
    10.417   146.090     0.200
    13.703   191.289     0.200
    14.264   198.289     0.200
    14.297   198.490     0.200
    14.511   201.090     0.200
    14.686   203.490     0.200
    16.069   225.590     0.200
    16.325   230.090     0.200
    18.057   248.590     0.200
     2.181    41.184     0.200
     2.551    45.082     0.200
     3.218    53.082     0.200
     3.178    54.684     0.200
     5.798    91.582     0.200
     6.892   108.082     0.200
     8.079   118.582     0.200
     8.442   127.480     0.200
     9.548   142.082     0.200
    13.449   189.980     0.200
    14.013   197.480     0.200
    14.040   197.281     0.200
    14.257   200.281     0.200
    14.420   202.582     0.200
    15.663   220.684     0.200
    16.444   229.980     0.200
    17.725   248.582     0.200
     2.169    38.242     0.200
     2.471    41.844     0.200
     3.304    52.844     0.200
     7.656   110.344     0.200
     8.245   119.141     0.200
     9.250   134.641     0.200
     9.865   144.641     0.200
     9.878   144.641     0.200
    10.424   147.641     0.200
    10.424   148.141     0.200
    11.507   160.141     0.200
    12.445   174.312     0.200
    12.867   180.109     0.200
    13.076   183.430     0.200
    13.486   185.641     0.200
    13.704   190.953     0.200
    14.267   198.469     0.200
    14.298   198.391     0.200
    14.512   201.328     0.200
    14.683   203.367     0.200
    15.738   216.547     0.200
    16.361   225.688     0.200
    16.377   225.867     0.200
    18.281   251.641     0.200
    20.480   277.141     0.200
     2.590    45.316     0.200
     2.885    50.117     0.200
     3.321    53.516     0.200
     5.291    84.418     0.200
     8.319   121.117     0.200
     3.239    54.141     0.200
     5.693    89.141     0.200
     8.135   120.441     0.200
    12.921   182.043     0.200
    13.543   190.680     0.200
    14.107   196.840     0.200
    14.135   197.941     0.200
    14.351   200.801     0.200
    14.518   202.820     0.200
    14.884   208.281     0.200
    15.576   216.281     0.200
    16.193   224.543     0.200
    16.213   226.340     0.200
    18.622   262.441     0.200
     1.717    34.242     0.200
     2.273    42.242     0.200
     2.756    46.742     0.200
     7.577   111.641     0.200
    11.712   165.617     0.200
    12.130   171.438     0.200
    12.342   174.023     0.200
    12.966   182.281     0.200
    13.530   189.078     0.200
    13.559   190.000     0.200
    13.774   192.719     0.200
    13.943   195.023     0.200
    14.309   199.297     0.200
    15.000   207.898     0.200
    15.621   217.242     0.200
    15.638   216.758     0.200
     2.105    39.477     0.200
     2.270    40.875     0.200
     2.263    41.273     0.200
     2.476    44.273     0.200
     3.083    53.477     0.200
     5.661    89.375     0.200
     8.121   118.273     0.200
     9.880   142.227     0.200
     9.976   144.281     0.200
    10.217   147.547     0.200
    10.768   156.031     0.200
    11.161   159.562     0.200
    11.468   163.406     0.200
    12.286   173.883     0.200
    12.704   179.906     0.200
    13.540   189.961     0.200
    14.103   197.641     0.200
    14.132   198.047     0.200
    14.348   200.883     0.200
     2.344    43.184     0.200
     2.337    43.184     0.200
     8.186   121.184     0.200
     9.954   143.652     0.200
    10.049   145.195     0.200
    10.291   148.812     0.200
    11.234   160.734     0.200
    11.542   164.953     0.200
    12.360   175.305     0.200
    12.778   181.184     0.200
    13.615   191.945     0.200
    14.178   199.262     0.200
    14.207   199.543     0.200
    14.591   204.723     0.200
    15.648   217.543     0.200
    16.267   226.863     0.200
    16.286   228.562     0.200
    17.920   252.984     0.200
    18.647   260.684     0.200
     2.368    41.402     0.200
     2.362    41.102     0.200
     2.673    44.504     0.200
     3.044    47.504     0.200
     8.046   115.402     0.200
     3.083    51.098     0.200
     8.864   132.500     0.200
     9.311   136.898     0.200
     9.916   142.707     0.200
    10.002   143.328     0.200
    10.259   147.867     0.200
    10.521   154.898     0.200
    11.184   158.590     0.200
    11.508   163.809     0.200
    12.388   175.898     0.200
    12.953   183.180     0.200
    13.594   191.438     0.200
    14.155   198.977     0.200
    14.189   199.020     0.200
    14.402   202.277     0.200
    14.581   203.977     0.200
    14.945   208.738     0.200
    15.628   217.320     0.200
    16.129   227.699     0.200
    16.265   225.578     0.200
    16.272   226.359     0.200
    20.389   277.898     0.200
     2.354    42.434     0.200
     2.348    42.934     0.200
     2.621    46.734     0.200
     3.003    50.234     0.200
     4.056    64.234     0.200
     4.927    73.734     0.200
     5.440    81.434     0.200
     6.092    91.134     0.200
     6.426    97.234     0.200
     8.012   116.734     0.200
     8.253   121.634     0.200
     9.271   136.234     0.200
     9.918   142.224     0.200
     9.999   143.164     0.200
    10.265   147.664     0.200
    11.179   159.144     0.200
    11.512   163.224     0.200
    12.322   173.684     0.200
    12.596   177.784     0.200
    12.763   180.164     0.200
    12.954   182.884     0.200
    13.604   191.404     0.200
    14.201   199.284     0.200
    14.412   201.804     0.200
    14.598   203.904     0.200
    14.961   208.764     0.200
    15.639   216.664     0.200
    16.285   225.784     0.200
    16.287   226.484     0.200
    18.321   257.734     0.200
    20.413   278.234     0.200
     2.177    37.047     0.200
     2.354    39.445     0.200
     2.626    44.844     0.200
     4.268    66.445     0.200
     4.325    66.445     0.200
     5.010    76.945     0.200
     5.151    77.844     0.200
     5.222    77.242     0.200
     5.740    86.445     0.200
     6.394    94.344     0.200
     6.733    98.445     0.200
     7.817   114.945     0.200
     8.343   119.445     0.200
     8.587   124.547     0.200
     8.932   127.617     0.200
     8.856   130.445     0.200
     9.007   131.445     0.200
     9.800   142.445     0.200
    10.220   145.086     0.200
    10.305   146.242     0.200
    10.564   150.367     0.200
    11.344   158.398     0.200
    11.487   162.125     0.200
    11.813   166.766     0.200
    12.930   180.297     0.200
    13.059   182.906     0.200
    13.257   185.008     0.200
    13.899   193.883     0.200
    14.460   200.766     0.200
    14.495   200.805     0.200
    14.707   203.422     0.200
    14.887   205.883     0.200
    15.251   211.102     0.200
    15.934   218.828     0.200
    16.336   228.945     0.200
    16.578   228.688     0.200
    18.281   252.445     0.200
    20.452   276.945     0.200
    20.695   279.445     0.200
     2.021    37.805     0.200
     2.238    40.504     0.200
     2.376    41.504     0.200
     2.982    50.703     0.200
     3.142    51.703     0.200
     3.895    61.504     0.200
     4.848    74.805     0.200
     5.687    87.504     0.200
     6.376    94.504     0.200
     6.752   100.504     0.200
     7.469   109.504     0.200
     8.065   118.504     0.200
     8.435   124.773     0.200
     8.800   127.082     0.200
     8.650   128.504     0.200
     9.430   137.504     0.200
     9.852   141.074     0.200
     9.794   142.504     0.200
     9.945   142.234     0.200
    10.191   146.113     0.200
    11.129   157.453     0.200
    11.436   161.855     0.200
    11.441   161.734     0.200
    12.465   176.504     0.200
    12.680   178.625     0.200
    12.760   179.254     0.200
    12.889   181.184     0.200
    13.518   189.266     0.200
    14.080   196.383     0.200
    14.111   196.605     0.200
    14.326   199.426     0.200
    14.497   201.844     0.200
    14.862   206.445     0.200
    15.551   214.543     0.200
    15.819   219.504     0.200
    15.894   221.504     0.200
    16.306   230.004     0.200
    16.976   235.504     0.200
    17.556   243.504     0.200
    19.547   271.504     0.200
    20.028   279.504     0.200
    20.226   276.004     0.200
    20.295   275.504     0.200
    20.746   285.504     0.200
     2.009    37.953     0.200
     2.217    40.754     0.200
     2.981    51.652     0.200
     3.128    52.652     0.200
     3.649    59.953     0.200
     3.875    62.953     0.200
     4.612    73.254     0.200
     4.828    75.453     0.200
     6.008    89.953     0.200
     7.450   111.953     0.200
     8.048   118.453     0.200
     7.761   117.703     0.200
     8.308   123.152     0.200
     8.433   126.283     0.200
     8.648   129.053     0.200
     9.496   137.453     0.200
     9.832   141.623     0.200
     9.925   142.604     0.200
     9.790   142.453     0.200
    10.171   146.344     0.200
    10.630   158.453     0.200
    11.109   158.203     0.200
    11.421   162.303     0.200
    11.433   162.242     0.200
    12.660   178.664     0.200
    12.746   179.844     0.200
    13.497   189.303     0.200
    14.060   196.863     0.200
    14.091   196.883     0.200
    14.305   199.803     0.200
    14.842   207.184     0.200
    15.531   215.303     0.200
    16.155   223.303     0.200
    18.504   258.453     0.200
     2.200    40.330     0.200
     3.140    51.830     0.200
     3.629    58.930     0.200
     4.595    72.830     0.200
     6.343    94.330     0.200
    15.831   222.330     0.200
    16.985   238.330     0.200
    17.798   248.730     0.200
    18.521   258.330     0.200
    20.216   277.830     0.200
     2.275    40.383     0.200
     2.405    41.586     0.200
     2.815    46.086     0.200
     3.535    58.984     0.200
     4.999    77.984     0.200
     5.606    85.086     0.200
     7.108   103.797     0.200
     7.515   107.758     0.200
     7.847   112.984     0.200
     7.937   115.414     0.200
     8.384   122.531     0.200
     8.394   120.984     0.200
     8.350   123.953     0.200
     8.650   128.352     0.200
     8.739   129.461     0.200
     8.874   130.586     0.200
     8.957   130.961     0.200
     8.957   130.883     0.200
     9.026   133.031     0.200
     9.348   133.328     0.200
     9.170   135.688     0.200
     9.241   137.984     0.200
     9.431   138.844     0.200
     9.609   141.141     0.200
     9.617   141.555     0.200
    12.395   174.641     0.200
    12.654   178.484     0.200
    12.837   180.781     0.200
    13.120   182.984     0.200
    13.497   189.086     0.200
    13.680   191.211     0.200
    14.096   196.586     0.200
    14.305   199.586     0.200
    14.859   206.883     0.200
    14.939   204.336     0.200
    15.444   217.242     0.200
    15.444   219.508     0.200
    15.444   219.086     0.200
    15.690   216.281     0.200
    15.811   217.984     0.200
    17.063   237.086     0.200
    17.046   236.898     0.200
    17.581   242.945     0.200
    17.982   248.906     0.200
    18.112   248.984     0.200
    18.792   259.297     0.200
    18.886   261.148     0.200
    19.538   268.891     0.200
    19.538   268.281     0.200
     2.294    41.297     0.200
     2.825    46.797     0.200
     8.962   132.086     0.200
     8.962   132.195     0.200
    12.672   179.391     0.200
    12.853   181.797     0.200
    13.514   190.094     0.200
    14.113   197.391     0.200
    14.322   200.695     0.200
    14.877   207.992     0.200
    15.459   219.070     0.200
    15.459   218.695     0.200
    18.001   248.797     0.200
    18.891   261.406     0.200
     1.993    37.908     0.200
     2.438    44.008     0.200
     2.767    49.508     0.200
     3.151    52.908     0.200
     4.961    77.908     0.200
     6.200    94.708     0.200
     7.145   107.688     0.200
     7.418   109.898     0.200
     7.851   115.309     0.200
     7.980   117.889     0.200
     8.148   118.908     0.200
     8.013   121.038     0.200
     8.146   119.858     0.200
     8.243   121.468     0.200
     8.324   125.368     0.200
     8.426   126.718     0.200
     8.534   128.208     0.200
     8.758   127.908     0.200
     8.696   130.354     0.200
     8.696   130.678     0.200
     8.696   129.008     0.200
     8.847   132.658     0.200
     9.102   135.889     0.200
     9.293   138.508     0.200
     9.283   138.008     0.200
     9.606   140.908     0.200
     9.682   141.608     0.200
    12.749   181.428     0.200
    13.063   185.608     0.200
    13.707   193.708     0.200
    14.268   201.008     0.200
    14.303   200.708     0.200
    14.515   203.608     0.200
    15.061   210.908     0.200
    15.163   214.108     0.200
    15.163   214.108     0.200
    16.007   222.328     0.200
    16.188   227.908     0.200
    16.230   228.908     0.200
    18.477   259.908     0.200
    18.513   257.945     0.200
    18.547   258.508     0.200
    19.166   265.355     0.200
     2.182    36.762     0.200
     2.367    41.062     0.200
     2.748    44.762     0.200
     3.092    48.762     0.200
     4.747    72.465     0.200
     5.151    79.363     0.200
     6.129    90.363     0.200
     7.074   104.152     0.200
     7.790   111.133     0.200
     8.082   114.863     0.200
     8.082   116.215     0.200
     8.019   118.492     0.200
     8.178   117.203     0.200
     8.325   122.852     0.200
     8.423   123.805     0.200
     8.541   125.504     0.200
     8.706   123.363     0.200
     8.611   125.262     0.200
     8.611   125.262     0.200
     8.699   127.934     0.200
     8.699   127.621     0.200
     8.847   130.363     0.200
     8.914   130.863     0.200
     8.931   131.145     0.200
     9.104   133.242     0.200
     9.287   135.254     0.200
     9.290   135.875     0.200
     9.612   137.863     0.200
    11.215   156.922     0.200
    11.317   158.363     0.200
    12.694   176.703     0.200
    12.992   182.164     0.200
    13.636   190.062     0.200
    14.197   197.562     0.200
    14.232   198.062     0.200
    14.444   200.363     0.200
    14.853   207.484     0.200
    15.232   210.262     0.200
    15.150   211.762     0.200
    15.150   212.988     0.200
    16.196   224.762     0.200
    16.732   231.305     0.200
    18.239   249.973     0.200
    18.426   254.363     0.200
     2.115    39.758     0.200
     2.569    46.559     0.200
     3.208    55.258     0.200
     4.505    72.859     0.200
     5.588    89.258     0.200
     5.911    90.457     0.200
     6.805   102.906     0.200
     7.528   114.977     0.200
     7.841   115.199     0.200
     7.812   118.496     0.200
     7.888   118.977     0.200
     7.912   117.977     0.200
     8.029   117.258     0.200
     8.092   119.328     0.200
     8.055   122.398     0.200
     8.139   120.969     0.200
     8.192   123.738     0.200
     8.192   123.555     0.200
     8.302   122.809     0.200
     8.249   123.406     0.200
     8.249   123.359     0.200
     8.359   122.430     0.200
     8.328   127.180     0.200
     8.380   125.836     0.200
     8.406   127.059     0.200
     8.595   129.148     0.200
     8.760   130.836     0.200
     8.788   132.648     0.200
     8.873   130.699     0.200
    11.638   168.059     0.200
    12.763   181.359     0.200
    12.802   180.969     0.200
    13.241   185.758     0.200
    13.377   189.758     0.200
    13.942   196.859     0.200
    13.968   197.359     0.200
    14.185   199.957     0.200
    14.569   206.559     0.200
    14.581   206.582     0.200
    14.580   207.109     0.200
    14.580   206.559     0.200
    14.713   207.059     0.200
    15.917   223.148     0.200
    16.595   233.457     0.200
    16.752   232.875     0.200
    16.903   237.098     0.200
    17.643   246.656     0.200
    17.643   246.527     0.200
    17.860   247.949     0.200
    18.170   253.047     0.200
    18.170   252.871     0.200
    18.279   255.039     0.200
    18.279   255.047     0.200
    18.279   255.281     0.200
    18.583   259.758     0.200
    20.132   276.258     0.200
     2.084    38.242     0.200
     2.330    42.445     0.200
     4.546    70.344     0.200
     5.855    88.344     0.200
     7.872   116.293     0.200
     8.008   118.324     0.200
     8.429   124.719     0.200
    12.684   178.445     0.200
    13.279   185.543     0.200
    13.846   192.945     0.200
    13.866   194.445     0.200
    14.086   197.344     0.200
    14.230   204.320     0.200
    14.235   199.145     0.200
    14.603   203.742     0.200
    16.476   230.367     0.200
    16.434   230.383     0.200
    17.914   246.965     0.200
    18.167   252.793     0.200
    18.167   252.773     0.200
     1.460    28.074     0.200
     2.055    38.852     0.200
     2.289    41.953     0.200
     3.182    54.453     0.200
     4.683    73.953     0.200
     4.816    76.953     0.200
     7.000   106.164     0.200
     7.759   116.965     0.200
     7.759   117.305     0.200
     7.867   118.395     0.200
     8.059   121.191     0.200
     8.059   121.793     0.200
     8.283   123.992     0.200
     8.283   124.324     0.200
     8.395   124.820     0.200
     8.434   126.402     0.200
     9.019   134.852     0.200
     9.019   135.254     0.200
    12.940   183.254     0.200
    14.132   198.352     0.200
    14.163   198.652     0.200
    14.378   201.453     0.200
    14.549   204.652     0.200
    14.871   214.555     0.200
    14.914   208.555     0.200
    16.608   233.102     0.200
    18.286   254.531     0.200
    18.286   254.125     0.200
    18.286   254.527     0.200
     2.150    38.215     0.200
     2.887    48.016     0.200
     6.245    93.035     0.200
     6.854   103.727     0.200
     8.082   119.773     0.200
     8.607   128.137     0.200
     8.734   128.074     0.200
     9.328   136.816     0.200
    16.920   235.539     0.200
     3.188    52.414     0.200
     4.348    69.016     0.200
     4.765    76.016     0.200
     5.620    86.695     0.200
     6.067    93.414     0.200
     6.447    97.516     0.200
     6.768   102.367     0.200
     7.834   115.922     0.200
     8.254   119.016     0.200
     8.433   126.812     0.200
     8.672   125.016     0.200
     8.881   131.312     0.200
     8.900   131.469     0.200
     8.900   131.219     0.200
     8.950   132.719     0.200
     8.950   133.797     0.200
     9.129   134.719     0.200
     9.129   135.734     0.200
     9.129   135.227     0.200
     9.129   135.016     0.200
     9.288   137.516     0.200
     9.344   138.016     0.200
     9.409   138.719     0.200
     9.536   141.414     0.200
     9.708   143.719     0.200
     9.743   142.789     0.200
     9.743   142.898     0.200
     9.838   142.914     0.200
     9.911   145.516     0.200
    10.318   150.016     0.200
    10.513   153.828     0.200
    10.910   156.094     0.200
    12.667   179.312     0.200
    12.704   179.492     0.200
    13.123   185.812     0.200
    13.299   187.719     0.200
    14.041   197.125     0.200
    14.523   203.617     0.200
    14.566   203.812     0.200
    14.762   206.617     0.200
    14.774   206.414     0.200
    14.805   208.039     0.200
    14.971   208.617     0.200
    15.073   213.719     0.200
    15.256   211.477     0.200
    15.256   215.164     0.200
    15.264   217.516     0.200
    15.333   216.844     0.200
    15.644   220.773     0.200
    15.644   219.914     0.200
    15.758   223.984     0.200
    15.978   223.609     0.200
    16.002   222.117     0.200
    16.012   228.484     0.200
    16.015   228.367     0.200
    16.655   231.516     0.200
    16.664   231.016     0.200
    16.745   234.016     0.200
    16.791   235.641     0.200
    16.791   235.062     0.200
    17.233   239.219     0.200
    17.310   237.945     0.200
    17.557   245.109     0.200
    17.665   244.117     0.200
    17.665   244.586     0.200
    17.665   245.102     0.200
    17.665   245.312     0.200
    18.382   252.016     0.200
    18.421   258.906     0.200
    18.505   258.570     0.200
    19.327   268.211     0.200
    19.709   272.242     0.200
    20.252   281.102     0.200
    20.720   284.742     0.200
     1.990    37.398     0.200
     3.161    52.500     0.200
     4.331    69.000     0.200
     4.745    76.000     0.200
     5.603    86.258     0.200
     6.047    92.602     0.200
     6.428    97.500     0.200
     7.813   114.500     0.200
     7.813   115.992     0.200
     8.458   126.648     0.200
     8.904   132.039     0.200
     8.929   132.047     0.200
     8.976   132.703     0.200
     8.976   133.680     0.200
     9.154   135.297     0.200
     9.154   135.680     0.200
     9.154   137.102     0.200
     9.154   135.000     0.200
     9.313   138.758     0.200
     9.369   139.000     0.200
     9.431   139.242     0.200
     9.560   141.750     0.200
     9.733   143.672     0.200
     9.766   144.195     0.200
     9.766   143.602     0.200
     9.766   143.742     0.200
     9.818   141.898     0.200
     9.891   144.500     0.200
    10.535   154.984     0.200
    12.648   179.398     0.200
    12.675   179.312     0.200
    13.105   185.602     0.200
    13.280   187.797     0.200
    14.014   196.312     0.200
    14.505   203.203     0.200
    14.548   203.797     0.200
    14.743   206.203     0.200
    14.775   208.406     0.200
    14.756   206.398     0.200
    14.953   209.398     0.200
    15.227   211.648     0.200
    15.249   216.594     0.200
    15.319   216.219     0.200
    15.389   220.602     0.200
    15.467   220.930     0.200
    15.665   221.453     0.200
    15.665   221.602     0.200
    15.742   224.453     0.200
    15.742   223.648     0.200
    15.999   228.781     0.200
    16.001   227.898     0.200
    15.983   222.398     0.200
    16.637   231.000     0.200
    16.647   231.102     0.200
    16.758   236.602     0.200
    16.821   236.523     0.200
    16.821   236.453     0.200
    17.288   239.898     0.200
    17.582   244.586     0.200
    17.690   244.602     0.200
    17.690   245.859     0.200
    17.690   246.703     0.200
    18.352   253.000     0.200
    18.883   262.641     0.200
    18.883   262.398     0.200
    19.484   269.969     0.200
    20.741   285.883     0.200
    20.976   287.812     0.200
    20.976   288.547     0.200
     1.729    30.934     0.200
     1.821    31.834     0.200
     2.804    45.135     0.200
     3.479    52.834     0.200
     4.735    71.033     0.200
     5.961    86.484     0.200
     8.509   122.854     0.200
     8.624   123.385     0.200
    12.264   169.734     0.200
    12.472   172.635     0.200
    13.102   180.533     0.200
    13.664   187.834     0.200
    13.695   188.135     0.200
    13.910   190.934     0.200
    14.082   192.834     0.200
    14.447   198.135     0.200
    14.831   210.438     0.200
    14.831   206.059     0.200
    15.135   206.234     0.200
    15.761   214.834     0.200
    15.775   214.533     0.200
    16.964   234.484     0.200
    16.980   233.775     0.200
     1.645    33.725     0.200
     2.785    48.625     0.200
     3.177    53.525     0.200
     4.365    70.025     0.200
     5.636    86.186     0.200
     6.076    91.326     0.200
     6.459    96.525     0.200
     6.778   101.756     0.200
     7.841   117.725     0.200
     8.248   121.525     0.200
     8.491   126.326     0.200
     8.557   129.725     0.200
     8.640   130.625     0.200
     8.854   132.725     0.200
     8.921   131.525     0.200
     8.940   133.225     0.200
     8.951   132.508     0.200
     8.951   132.025     0.200
     9.008   133.926     0.200
     9.008   135.166     0.200
     9.187   135.826     0.200
     9.187   136.346     0.200
     9.338   138.926     0.200
     9.347   139.125     0.200
     9.403   140.525     0.200
     9.468   141.225     0.200
     9.477   140.426     0.200
     9.594   141.426     0.200
     9.766   144.725     0.200
     9.802   144.178     0.200
     9.802   143.926     0.200
     9.802   143.795     0.200
     9.920   144.625     0.200
    10.166   149.926     0.200
    10.517   154.625     0.200
    10.610   155.625     0.200
    10.860   155.545     0.200
    11.409   167.525     0.200
    12.373   178.326     0.200
    12.677   179.625     0.200
    12.680   180.416     0.200
    13.135   185.826     0.200
    13.260   191.326     0.200
    13.328   192.625     0.200
    13.309   188.326     0.200
    13.386   195.225     0.200
    13.979   196.826     0.200
    14.568   208.725     0.200
    14.535   204.025     0.200
    14.579   204.225     0.200
    14.667   213.025     0.200
    14.769   213.426     0.200
    14.776   208.465     0.200
    14.787   206.525     0.200
    14.995   215.625     0.200
    14.985   210.025     0.200
    15.055   217.525     0.200
    15.109   216.725     0.200
    15.234   211.875     0.200
    15.343   220.105     0.200
    15.346   214.826     0.200
    15.620   221.926     0.200
    15.704   221.467     0.200
    15.704   219.725     0.200
    15.704   221.705     0.200
    15.704   221.025     0.200
    15.704   222.275     0.200
    15.699   223.965     0.200
    15.955   228.064     0.200
    15.957   227.365     0.200
    15.938   224.885     0.200
    16.014   222.926     0.200
    16.668   232.125     0.200
    16.679   231.725     0.200
    16.802   234.826     0.200
    16.823   236.100     0.200
    16.823   235.846     0.200
    17.312   241.215     0.200
    17.614   246.148     0.200
    17.614   245.133     0.200
    17.722   246.725     0.200
    17.722   247.625     0.200
    17.722   246.361     0.200
    17.722   247.455     0.200
    18.353   252.525     0.200
    18.353   255.025     0.200
    18.903   263.100     0.200
    18.943   264.125     0.200
    19.441   269.455     0.200
    20.946   288.973     0.200
    20.946   287.996     0.200
    20.946   289.285     0.200
     4.441    70.845     0.200
     4.441    70.399     0.200
     5.412    82.759     0.200
     5.915    87.399     0.200
     6.610    97.999     0.200
     6.646   103.099     0.200
     7.693   111.489     0.200
     7.990   119.039     0.200
     8.089   120.108     0.200
     8.089   119.699     0.200
     8.220   118.099     0.200
     8.306   123.479     0.200
     8.412   125.039     0.200
     8.510   125.699     0.200
     8.510   125.949     0.200
     8.510   124.879     0.200
     8.542   125.974     0.200
     8.542   125.699     0.200
     8.542   125.399     0.200
     8.676   128.567     0.200
     8.676   128.143     0.200
     8.676   127.699     0.200
     8.676   128.309     0.200
     8.821   126.699     0.200
     8.829   130.649     0.200
     8.892   130.699     0.200
     8.930   132.219     0.200
     9.082   133.779     0.200
     9.261   136.289     0.200
     9.277   135.963     0.200
     9.277   135.699     0.200
     9.277   136.269     0.200
     9.754   139.299     0.200
    10.074   146.999     0.200
    10.036   147.294     0.200
    10.306   149.641     0.200
    10.506   151.299     0.200
    10.507   150.999     0.200
    11.275   157.659     0.200
    11.238   160.898     0.200
    11.238   161.499     0.200
    11.450   161.699     0.200
    12.815   179.809     0.200
    12.938   181.999     0.200
    13.134   184.899     0.200
    13.778   192.899     0.200
    13.757   194.744     0.200
    14.339   200.199     0.200
    14.374   200.199     0.200
    14.574   202.899     0.200
    14.586   203.099     0.200
    14.767   205.199     0.200
    15.031   211.269     0.200
    15.145   213.129     0.200
    15.158   214.235     0.200
    15.158   214.699     0.200
    15.158   212.324     0.200
    15.158   214.099     0.200
    15.356   213.259     0.200
    15.368   218.469     0.200
    15.618   220.869     0.200
    15.762   225.039     0.200
    15.813   219.099     0.200
    16.242   224.699     0.200
    16.242   228.379     0.200
    16.247   226.199     0.200
    16.451   227.099     0.200
    16.458   227.699     0.200
    16.617   231.134     0.200
    16.617   231.699     0.200
    16.617   231.689     0.200
    17.073   237.869     0.200
    17.115   236.056     0.200
    17.115   236.674     0.200
    17.206   239.949     0.200
    17.223   236.699     0.200
    17.223   238.569     0.200
    17.308   240.909     0.200
    18.170   250.599     0.200
    18.170   251.679     0.200
    18.287   252.058     0.200
    18.287   252.624     0.200
    18.538   257.019     0.200
    19.879   272.269     0.200
    19.923   273.019     0.200
    20.059   273.839     0.200
    20.878   283.699     0.200
     2.500    43.334     0.200
     3.197    51.334     0.200
     4.470    70.257     0.200
     5.902    88.434     0.200
     6.597    97.114     0.200
     7.897   114.704     0.200
     8.121   120.080     0.200
     8.542   126.334     0.200
     8.574   125.548     0.200
     8.574   125.044     0.200
     8.707   127.552     0.200
     8.707   128.228     0.200
     9.308   136.044     0.200
     9.742   139.534     0.200
    10.516   150.761     0.200
    12.928   181.534     0.200
    13.123   183.434     0.200
    13.768   192.134     0.200
    14.329   199.434     0.200
    14.364   199.534     0.200
    14.577   202.934     0.200
    14.758   204.834     0.200
    15.187   215.467     0.200
    15.187   214.154     0.200
    15.187   214.158     0.200
    15.187   215.254     0.200
    15.803   217.734     0.200
    16.443   226.834     0.200
    16.449   226.734     0.200
    16.644   231.208     0.200
    16.644   231.354     0.200
    17.146   239.287     0.200
    17.254   239.284     0.200
    18.314   253.484     0.200
    19.155   263.010     0.200
     2.610    44.537     0.200
     3.286    52.438     0.200
     4.411    69.504     0.200
     5.390    81.137     0.200
     5.512    83.727     0.200
     6.010    88.938     0.200
     6.369    93.736     0.200
     6.705    99.137     0.200
     8.110   120.156     0.200
     8.110   120.336     0.200
     8.300   122.137     0.200
     8.543   124.498     0.200
     8.543   124.736     0.200
     8.714   128.307     0.200
     8.714   129.725     0.200
     8.714   128.537     0.200
     8.930   134.137     0.200
     9.322   136.297     0.200
    10.406   149.943     0.200
    11.269   160.348     0.200
    11.302   163.795     0.200
    12.600   177.037     0.200
    12.871   181.506     0.200
    13.232   186.137     0.200
    13.878   194.236     0.200
    14.438   200.537     0.200
    14.474   201.137     0.200
    14.673   203.938     0.200
    14.686   204.236     0.200
    14.868   207.736     0.200
    15.232   212.137     0.200
    15.204   215.367     0.200
    15.217   215.316     0.200
    15.217   215.438     0.200
    15.217   215.857     0.200
    15.217   215.861     0.200
    15.217   217.137     0.200
    15.217   215.396     0.200
    15.913   219.836     0.200
    16.571   230.438     0.200
    16.571   231.197     0.200
    17.148   239.211     0.200
    17.296   240.967     0.200
    17.256   240.236     0.200
    18.239   253.314     0.200
    19.691   270.336     0.200
     2.051    35.480     0.200
     2.214    38.580     0.200
     3.161    50.080     0.200
     4.165    65.150     0.200
     4.283    67.529     0.200
     4.602    71.680     0.200
     5.119    77.090     0.200
     5.320    82.180     0.200
     6.352    93.209     0.200
     7.432   108.119     0.200
     7.432   110.234     0.200
     7.691   113.820     0.200
     7.985   117.840     0.200
     8.062   117.180     0.200
     8.070   118.500     0.200
     8.148   117.590     0.200
     8.216   120.840     0.200
     8.325   120.590     0.200
     8.360   121.029     0.200
     8.360   121.580     0.200
     8.360   121.680     0.200
     8.362   122.725     0.200
     8.362   122.879     0.200
     8.362   122.311     0.200
     8.362   122.980     0.200
     8.503   126.320     0.200
     8.767   128.039     0.200
     8.822   128.811     0.200
     8.859   129.980     0.200
     8.940   131.359     0.200
     8.940   129.969     0.200
     8.940   130.180     0.200
     8.955   130.990     0.200
     9.161   131.680     0.200
     9.161   132.178     0.200
     9.405   136.600     0.200
     9.515   137.770     0.200
     9.661   140.109     0.200
    10.139   145.510     0.200
    10.488   150.799     0.200
    10.562   150.430     0.200
    10.822   152.525     0.200
    10.822   153.379     0.200
    10.822   153.420     0.200
    10.851   154.982     0.200
    12.230   170.680     0.200
    12.860   179.279     0.200
    13.485   187.180     0.200
    14.048   194.480     0.200
    14.077   194.580     0.200
    14.293   197.480     0.200
    14.461   199.879     0.200
    14.654   204.486     0.200
    14.654   204.879     0.200
    14.778   209.451     0.200
    14.778   208.879     0.200
    14.778   205.871     0.200
    14.827   204.779     0.200
    15.518   212.879     0.200
    15.810   224.680     0.200
    16.138   221.279     0.200
    16.812   229.918     0.200
    16.920   235.914     0.200
    16.920   236.879     0.200
     1.494    29.538     0.200
     3.345    53.538     0.200
     4.943    75.938     0.200
     5.464    83.108     0.200
     5.985    90.738     0.200
     6.677    98.298     0.200
     7.429   110.408     0.200
     7.828   116.588     0.200
     8.194   121.398     0.200
     8.257   121.918     0.200
     8.322   120.938     0.200
     8.348   123.538     0.200
     8.378   122.838     0.200
     8.572   124.038     0.200
     8.516   125.648     0.200
     8.516   125.421     0.200
     8.923   130.898     0.200
     9.100   133.258     0.200
     9.121   133.638     0.200
     9.121   133.287     0.200
     9.307   135.448     0.200
     9.602   139.588     0.200
     9.725   141.458     0.200
     9.922   142.888     0.200
     9.871   143.298     0.200
    10.461   149.888     0.200
    10.461   149.210     0.200
    10.450   150.048     0.200
    11.096   158.139     0.200
    12.566   175.738     0.200
    12.950   180.918     0.200
    13.196   184.938     0.200
    13.832   192.738     0.200
    14.394   199.938     0.200
    14.426   200.638     0.200
    14.628   202.938     0.200
    14.640   203.238     0.200
    15.011   211.663     0.200
    15.180   210.638     0.200
    15.866   218.838     0.200
    16.496   228.138     0.200
    16.508   228.138     0.200
    16.474   228.985     0.200
    16.953   236.778     0.200
    17.286   238.228     0.200
    17.238   241.218     0.200
    18.146   250.638     0.200
    18.146   249.738     0.200
     2.598    43.359     0.200
     4.193    66.305     0.200
     4.427    69.680     0.200
     5.495    83.125     0.200
     5.506    83.234     0.200
     6.686    93.539     0.200
     8.001   118.141     0.200
     8.283   118.289     0.200
     8.528   124.062     0.200
     8.528   124.469     0.200
     8.528   124.469     0.200
     8.521   125.234     0.200
     8.692   127.250     0.200
     8.847   130.703     0.200
     8.891   130.070     0.200
     9.050   132.664     0.200
     9.098   133.648     0.200
     9.272   135.680     0.200
     9.298   136.312     0.200
    10.423   149.719     0.200
    12.871   179.906     0.200
    13.861   193.844     0.200
    14.422   200.445     0.200
    14.457   200.445     0.200
    14.669   203.250     0.200
    15.191   214.055     0.200
    15.191   215.867     0.200
    15.191   214.094     0.200
    16.303   228.977     0.200
    17.126   238.500     0.200
    17.126   237.758     0.200
    17.234   240.031     0.200
    17.234   240.539     0.200
    18.236   250.812     0.200
    18.236   251.062     0.200
     2.650    43.766     0.200
     4.137    66.117     0.200
     4.378    69.859     0.200
     5.010    78.586     0.200
     5.460    84.727     0.200
     6.648    96.984     0.200
     6.752   102.859     0.200
     7.831   113.406     0.200
     8.344   119.273     0.200
     8.447   122.867     0.200
     8.480   123.875     0.200
     8.480   123.758     0.200
     8.480   124.039     0.200
     8.660   126.867     0.200
     8.859   130.016     0.200
     9.270   136.414     0.200
    10.370   149.398     0.200
    12.641   177.125     0.200
    12.933   182.148     0.200
    13.076   183.430     0.200
    13.273   186.125     0.200
    13.916   193.328     0.200
    14.512   202.227     0.200
    14.724   203.328     0.200
    15.268   212.125     0.200
    15.171   213.703     0.200
    15.171   212.203     0.200
    15.171   215.094     0.200
    15.951   220.328     0.200
    16.508   229.641     0.200
    16.508   230.523     0.200
    16.508   230.227     0.200
    17.092   235.305     0.200
    18.176   252.125     0.200
     2.343    40.383     0.200
     4.323    68.344     0.200
     4.718    72.727     0.200
     8.068   115.625     0.200
     7.997   118.430     0.200
     8.600   125.414     0.200
     8.600   125.602     0.200
     8.600   125.336     0.200
     8.676   128.148     0.200
     8.676   127.867     0.200
     9.169   135.242     0.200
    11.303   159.086     0.200
    12.334   173.008     0.200
    12.768   179.406     0.200
    13.608   189.305     0.200
    14.403   200.008     0.200
    14.416   199.906     0.200
    14.596   203.305     0.200
    14.960   207.203     0.200
    15.121   215.953     0.200
    15.120   214.156     0.200
    15.120   215.602     0.200
    15.643   215.805     0.200
    16.280   224.602     0.200
    16.736   232.297     0.200
    17.121   236.750     0.200
    18.563   257.031     0.200
     2.804    48.977     0.200
     4.183    67.516     0.200
     4.467    72.545     0.200
     5.169    81.326     0.200
     5.139    80.086     0.200
     5.561    87.596     0.200
     6.876   102.926     0.200
     7.606   115.830     0.200
     8.109   121.809     0.200
     8.109   122.166     0.200
     8.437   125.195     0.200
     8.335   125.176     0.200
     8.569   127.227     0.200
     8.569   126.994     0.200
     8.569   126.535     0.200
     8.569   126.676     0.200
     8.943   132.406     0.200
     8.808   131.186     0.200
     8.808   131.727     0.200
     9.188   135.705     0.200
     9.427   140.012     0.200
     9.425   139.416     0.200
     9.667   142.752     0.200
     9.770   144.152     0.200
    10.137   148.969     0.200
    10.195   150.377     0.200
    11.639   169.125     0.200
    12.960   183.455     0.200
    15.043   217.141     0.200
    15.346   218.865     0.200
    15.346   218.666     0.200
    15.346   216.527     0.200
    16.506   232.746     0.200
    16.506   232.316     0.200
    17.231   240.916     0.200
    18.169   252.416     0.200
    18.169   254.199     0.200
    18.492   257.365     0.200
    18.524   257.516     0.200
    18.524   257.395     0.200
    18.524   258.465     0.200
     2.559    45.398     0.200
     4.203    66.660     0.200
     4.430    71.012     0.200
     5.506    86.801     0.200
     6.720    94.828     0.200
     6.660    99.641     0.200
     6.811   102.180     0.200
     7.334   110.500     0.200
     7.993   119.516     0.200
     8.259   120.398     0.200
     8.168   121.102     0.200
     8.529   125.969     0.200
     8.529   125.824     0.200
     8.529   126.102     0.200
     8.529   125.828     0.200
     8.855   128.531     0.200
     8.681   128.648     0.200
     8.681   127.699     0.200
     8.681   127.445     0.200
     8.881   132.199     0.200
     9.238   136.238     0.200
     9.255   137.371     0.200
     9.286   137.633     0.200
    10.109   148.941     0.200
    10.456   148.809     0.200
    10.456   151.648     0.200
    12.852   180.949     0.200
    15.000   209.641     0.200
    15.175   216.520     0.200
    15.174   216.520     0.200
    15.174   216.016     0.200
    16.278   230.602     0.200
    16.584   231.750     0.200
    16.584   231.770     0.200
    17.118   241.078     0.200
    17.226   241.629     0.200
    17.226   242.301     0.200
    18.253   253.219     0.200
     3.841    60.305     0.200
     4.585    71.543     0.200
     5.600    84.332     0.200
     5.739    89.082     0.200
     6.296    93.445     0.200
     7.221   107.664     0.200
     7.894   113.875     0.200
     8.144   120.805     0.200
     8.144   120.449     0.200
     8.515   122.633     0.200
     8.774   128.043     0.200
     8.774   127.953     0.200
     8.817   130.492     0.200
     8.817   129.922     0.200
     8.817   128.586     0.200
     9.131   134.543     0.200
     9.222   135.203     0.200
     9.397   138.934     0.200
     9.397   137.113     0.200
     9.409   137.805     0.200
    10.809   153.035     0.200
    10.809   154.070     0.200
    10.809   154.145     0.200
    10.809   154.172     0.200
    12.192   170.945     0.200
    12.632   177.445     0.200
    12.824   179.645     0.200
    13.473   188.344     0.200
    14.033   195.645     0.200
    14.070   195.945     0.200
    13.967   196.023     0.200
    14.269   198.344     0.200
    14.281   199.043     0.200
    14.466   201.242     0.200
    14.829   206.043     0.200
    15.107   212.363     0.200
    15.231   215.691     0.200
    15.231   213.902     0.200
    15.231   213.523     0.200
    15.231   213.969     0.200
    15.508   214.844     0.200
    16.155   222.945     0.200
    16.153   223.344     0.200
    16.923   234.344     0.200
    16.923   234.473     0.200
    16.923   234.273     0.200
    17.266   237.895     0.200
    17.374   239.570     0.200
    20.281   274.773     0.200
     3.916    62.727     0.200
     4.103    66.531     0.200
     4.147    66.102     0.200
     4.223    68.344     0.200
     4.649    73.664     0.200
     5.166    80.242     0.200
     5.262    82.797     0.200
     6.403    95.672     0.200
     6.720   101.992     0.200
     6.959   106.016     0.200
     7.161   104.273     0.200
     7.641   114.984     0.200
     7.743   114.422     0.200
     8.162   118.953     0.200
     8.166   123.312     0.200
     8.301   122.461     0.200
     8.301   122.438     0.200
     8.301   122.836     0.200
     8.314   123.547     0.200
     8.314   122.555     0.200
     8.314   124.695     0.200
     8.631   126.828     0.200
     8.895   132.266     0.200
     8.906   133.023     0.200
     9.460   136.555     0.200
    11.398   163.586     0.200
    14.741   210.438     0.200
    14.741   210.711     0.200
    14.741   209.094     0.200
    15.789   223.938     0.200
    16.561   232.211     0.200
    16.561   232.031     0.200
    16.561   232.305     0.200
    16.763   233.031     0.200
    16.870   237.477     0.200
    18.241   252.312     0.200
     2.296    42.234     0.200
     4.275    69.703     0.200
     4.393    71.844     0.200
     4.934    80.543     0.200
     5.201    82.133     0.200
     5.444    86.645     0.200
     5.725    89.473     0.200
     6.417    97.512     0.200
     7.853   118.953     0.200
     8.099   119.645     0.200
     8.377   125.922     0.200
     8.480   126.324     0.200
     8.480   125.992     0.200
     8.480   125.793     0.200
     8.529   127.918     0.200
     8.934   133.562     0.200
     8.934   132.559     0.200
     9.046   135.332     0.200
     9.115   136.461     0.200
     9.115   136.262     0.200
     9.120   135.273     0.200
    11.035   160.672     0.200
    12.742   181.453     0.200
    14.840   209.996     0.200
    14.965   212.973     0.200
    14.965   217.422     0.200
    14.965   212.723     0.200
    14.965   213.148     0.200
    16.669   234.910     0.200
    16.669   233.582     0.200
    16.976   236.098     0.200
    17.084   241.422     0.200
    17.084   241.125     0.200
    18.345   254.371     0.200
    18.345   255.531     0.200
    18.409   258.023     0.200
    18.409   255.773     0.200
     3.485    59.057     0.200
     3.489    58.918     0.200
     4.790    76.957     0.200
     5.304    83.787     0.200
     5.292    83.938     0.200
     5.379    85.277     0.200
     5.852    92.656     0.200
     6.706   102.678     0.200
     6.790   102.986     0.200
     7.100   108.496     0.200
     7.163   109.627     0.200
     7.623   115.697     0.200
     7.628   114.438     0.200
     8.025   120.406     0.200
     8.240   123.387     0.200
     8.327   123.518     0.200
     8.327   123.406     0.200
     8.327   123.467     0.200
     8.398   125.525     0.200
     8.398   125.627     0.200
     8.398   124.746     0.200
     8.398   124.881     0.200
     8.398   125.357     0.200
     8.562   126.496     0.200
     8.546   127.977     0.200
     8.635   128.707     0.200
     8.733   129.428     0.200
     8.733   129.277     0.200
     8.804   130.627     0.200
     8.914   132.406     0.200
     8.914   132.947     0.200
     8.986   133.008     0.200
     8.990   133.957     0.200
     9.291   136.457     0.200
     9.291   137.057     0.200
     9.670   140.396     0.200
    14.731   207.947     0.200
    14.858   209.357     0.200
    14.857   209.557     0.200
    14.857   210.406     0.200
    14.857   213.258     0.200
    16.514   231.797     0.200
    16.514   230.695     0.200
    16.514   231.387     0.200
    16.842   234.182     0.200
    16.950   239.768     0.200
    16.950   239.357     0.200
    18.191   253.156     0.200
    18.191   252.121     0.200
    18.255   253.232     0.200
     1.389    27.395     0.200
     4.149    65.648     0.200
     4.339    67.508     0.200
     5.054    77.875     0.200
     5.256    80.102     0.200
     5.493    84.977     0.200
     5.606    86.242     0.200
     5.606    84.484     0.200
     5.785    90.062     0.200
     5.785    86.992     0.200
     6.261    96.922     0.200
     7.054   101.156     0.200
     7.410   109.945     0.200
     7.410   110.586     0.200
     7.660   111.094     0.200
     8.392   122.188     0.200
     8.392   122.734     0.200
     8.225   119.133     0.200
     8.346   123.422     0.200
     8.509   123.875     0.200
     8.509   123.812     0.200
     8.534   127.188     0.200
     8.712   127.516     0.200
     8.712   128.008     0.200
     8.712   127.852     0.200
     8.858   129.195     0.200
     9.083   132.078     0.200
     9.309   135.547     0.200
     9.317   135.656     0.200
     9.867   142.828     0.200
     9.944   143.594     0.200
     9.710   140.016     0.200
    11.325   162.031     0.200
    15.105   211.703     0.200
    15.235   217.039     0.200
    15.234   213.766     0.200
    15.655   216.875     0.200
    16.375   230.922     0.200
    16.503   229.258     0.200
    16.503   228.023     0.200
    16.503   228.852     0.200
    17.141   239.266     0.200
    17.141   240.148     0.200
    17.249   240.828     0.200
    17.249   240.961     0.200
    18.169   248.828     0.200
     4.087    68.221     0.200
     4.243    70.701     0.200
     4.767    76.410     0.200
     5.285    83.600     0.200
     5.360    86.850     0.200
     5.296    83.461     0.200
     6.512    99.141     0.200
     7.081   107.961     0.200
     7.144   109.811     0.200
     8.331   124.713     0.200
     8.396   126.270     0.200
     8.396   125.693     0.200
     8.728   130.330     0.200
     8.906   130.500     0.200
     8.931   131.301     0.200
    15.313   213.689     0.200
    16.526   232.650     0.200
    16.526   233.090     0.200
    16.841   234.145     0.200
    16.948   236.111     0.200
    18.203   253.301     0.200
     2.617    43.711     0.200
     5.073    79.625     0.200
     5.527    85.586     0.200
     7.091   105.164     0.200
     8.214   120.141     0.200
     8.547   125.086     0.200
     8.547   124.484     0.200
     8.719   128.125     0.200
     8.719   129.156     0.200
     8.719   127.594     0.200
     9.079   131.094     0.200
     9.289   136.961     0.200
    13.038   182.852     0.200
    13.878   194.953     0.200
    14.438   202.055     0.200
    14.686   204.555     0.200
    15.222   217.102     0.200
    15.222   216.742     0.200
    16.574   231.328     0.200
    16.574   230.414     0.200
    16.574   231.250     0.200
    17.153   240.078     0.200
    17.261   241.320     0.200
    18.242   252.305     0.200
    18.242   253.398     0.200
     2.450    43.078     0.200
     2.450    43.852     0.200
     3.595    60.406     0.200
     4.090    65.188     0.200
     4.831    75.758     0.200
     4.991    77.508     0.200
     4.968    79.281     0.200
     4.968    80.883     0.200
     5.461    82.242     0.200
     5.453    85.477     0.200
     5.453    86.898     0.200
     5.867    89.883     0.200
     6.055    95.680     0.200
     6.861   101.430     0.200
     6.870   104.758     0.200
     6.975   104.859     0.200
     7.699   114.938     0.200
     7.734   115.383     0.200
     7.875   118.531     0.200
     8.203   118.961     0.200
     8.202   119.656     0.200
     8.293   121.781     0.200
     8.218   122.883     0.200
     8.445   122.969     0.200
     8.428   121.781     0.200
     8.427   125.680     0.200
     8.483   125.297     0.200
     8.483   124.477     0.200
     8.608   126.297     0.200
     8.589   126.750     0.200
     8.589   128.109     0.200
     8.589   127.797     0.200
     8.589   127.438     0.200
     8.589   128.383     0.200
     8.740   130.438     0.200
     8.835   130.617     0.200
     8.995   133.156     0.200
     9.117   133.477     0.200
     9.117   134.977     0.200
     9.140   134.383     0.200
     9.140   135.961     0.200
     9.176   135.562     0.200
     9.186   136.227     0.200
     9.383   138.023     0.200
     9.419   139.422     0.200
     9.495   138.992     0.200
     9.495   140.477     0.200
     9.531   140.203     0.200
     9.626   139.336     0.200
     9.704   140.242     0.200
     9.781   144.078     0.200
     9.874   145.102     0.200
     9.979   145.578     0.200
     9.927   146.180     0.200
     9.990   146.883     0.200
     9.990   145.797     0.200
     9.990   147.000     0.200
    10.298   150.781     0.200
    10.423   151.680     0.200
    10.778   156.680     0.200
    10.868   157.281     0.200
    11.137   160.656     0.200
    11.542   163.727     0.200
    12.003   172.883     0.200
    12.822   180.789     0.200
    13.720   192.383     0.200
    14.282   199.781     0.200
    14.315   199.883     0.200
    14.516   202.578     0.200
    14.933   210.281     0.200
    14.933   210.383     0.200
    15.060   214.484     0.200
    15.060   212.180     0.200
    15.060   214.883     0.200
    15.060   212.070     0.200
    15.060   211.883     0.200
    15.060   215.078     0.200
    15.395   215.258     0.200
    15.755   218.180     0.200
    16.388   226.781     0.200
    16.398   227.383     0.200
    16.601   232.680     0.200
    16.601   232.000     0.200
    16.601   231.648     0.200
    17.031   236.258     0.200
    17.031   239.125     0.200
    17.139   239.180     0.200
    17.139   242.023     0.200
    18.274   255.062     0.200
    19.207   267.078     0.200
    19.538   269.977     0.200
    19.836   275.977     0.200
    20.526   282.977     0.200
     2.251    39.027     0.200
     2.251    39.238     0.200
     5.257    82.828     0.200
     5.762    88.816     0.200
     5.762    89.148     0.200
     6.234    96.328     0.200
     7.176   107.148     0.200
     7.252   106.926     0.200
     8.075   120.016     0.200
     8.700   129.086     0.200
     8.796   128.215     0.200
     8.796   127.875     0.200
     8.850   130.246     0.200
     8.850   129.648     0.200
     8.850   130.086     0.200
     8.850   129.977     0.200
     9.167   133.727     0.200
     9.255   134.996     0.200
     9.310   136.066     0.200
     9.350   136.328     0.200
     9.432   138.496     0.200
     9.442   137.328     0.200
     9.654   142.578     0.200
    11.332   162.188     0.200
    12.215   170.926     0.200
    12.656   177.527     0.200
    13.498   189.125     0.200
    14.095   194.785     0.200
    14.095   195.727     0.200
    14.293   198.625     0.200
    14.306   198.828     0.200
    14.492   201.828     0.200
    14.855   205.727     0.200
    15.189   210.227     0.200
    15.189   210.777     0.200
    15.145   211.688     0.200
    15.269   214.664     0.200
    15.269   213.578     0.200
    15.269   216.328     0.200
    15.533   213.625     0.200
    16.928   234.375     0.200
    16.928   234.156     0.200
    17.298   239.465     0.200
    17.406   241.148     0.200
    17.406   240.215     0.200
    19.800   271.027     0.200
    20.308   274.625     0.200
     3.047    51.012     0.200
     4.673    72.660     0.200
     5.417    83.293     0.200
     5.448    85.570     0.200
     5.593    85.250     0.200
     6.430    96.543     0.200
     6.423    99.613     0.200
     6.793    99.512     0.200
     7.127   105.500     0.200
     7.469   111.410     0.200
     7.640   114.012     0.200
     7.867   117.961     0.200
     8.297   122.121     0.200
     8.334   122.293     0.200
     8.349   119.512     0.200
     8.440   123.910     0.200
     8.440   123.902     0.200
     8.655   124.184     0.200
     8.687   125.402     0.200
     8.690   126.332     0.200
     8.758   127.934     0.200
     8.776   126.562     0.200
     8.815   130.203     0.200
     8.817   132.012     0.200
     8.759   130.707     0.200
     8.759   130.602     0.200
     8.759   130.180     0.200
     8.759   128.910     0.200
     8.919   128.832     0.200
     8.987   133.371     0.200
     9.165   131.934     0.200
     9.192   133.000     0.200
     9.168   133.512     0.200
     9.167   135.652     0.200
     9.395   138.863     0.200
     9.435   137.613     0.200
     9.435   138.113     0.200
     9.448   137.613     0.200
     9.448   137.410     0.200
     9.537   140.410     0.200
     9.897   143.613     0.200
    10.037   145.512     0.200
    10.196   145.781     0.200
    10.228   147.512     0.200
    10.183   148.410     0.200
    10.310   149.211     0.200
    10.507   152.711     0.200
    10.725   154.613     0.200
    11.111   159.711     0.200
    11.094   160.113     0.200
    11.365   162.910     0.200
    11.458   163.113     0.200
    11.458   164.812     0.200
    12.247   175.812     0.200
    13.024   182.812     0.200
    13.190   185.301     0.200
    13.464   189.113     0.200
    13.539   191.230     0.200
    13.655   191.711     0.200
    14.305   199.312     0.200
    14.865   206.613     0.200
    14.902   207.703     0.200
    15.101   209.812     0.200
    15.297   212.711     0.200
    15.347   215.812     0.200
    15.347   218.613     0.200
    15.347   214.957     0.200
    15.347   214.473     0.200
    15.347   216.312     0.200
    16.294   227.863     0.200
    16.294   228.160     0.200
    16.294   226.941     0.200
    16.983   233.711     0.200
    16.987   234.410     0.200
    17.167   238.238     0.200
    17.275   241.602     0.200
    17.275   240.812     0.200
    17.953   248.812     0.200
    20.425   280.012     0.200
     3.977    63.922     0.200
     4.714    74.859     0.200
     4.851    76.672     0.200
     5.234    81.562     0.200
     5.331    84.203     0.200
     5.446    83.344     0.200
     5.878    93.484     0.200
     6.109    91.789     0.200
     6.430    98.305     0.200
     6.457    97.000     0.200
     6.773   103.227     0.200
     6.847   103.984     0.200
     6.995   104.109     0.200
     7.416   109.094     0.200
     7.421   111.273     0.200
     7.461   112.039     0.200
     7.549   112.125     0.200
     7.665   115.141     0.200
     7.704   116.820     0.200
     7.989   117.984     0.200
     8.044   117.586     0.200
     8.135   118.812     0.200
     8.142   118.914     0.200
     8.161   118.766     0.200
     8.211   121.211     0.200
     8.196   122.102     0.200
     8.237   120.523     0.200
     8.264   121.961     0.200
     8.296   124.500     0.200
     8.348   122.352     0.200
     8.392   122.570     0.200
     8.353   120.305     0.200
     8.409   124.070     0.200
     8.398   124.211     0.200
     8.398   123.172     0.200
     8.450   126.695     0.200
     8.450   125.891     0.200
     8.450   124.492     0.200
     8.450   125.766     0.200
     8.450   126.086     0.200
     8.491   124.711     0.200
     8.596   128.562     0.200
     8.676   129.500     0.200
     8.818   130.406     0.200
     8.855   131.836     0.200
     8.846   128.859     0.200
     8.944   133.125     0.200
     8.944   131.414     0.200
     8.973   131.086     0.200
     8.973   133.641     0.200
     8.973   132.180     0.200
     9.037   133.977     0.200
     9.039   134.359     0.200
     9.519   137.266     0.200
     9.597   139.289     0.200
     9.508   140.102     0.200
     9.622   141.359     0.200
     9.822   142.766     0.200
     9.768   143.312     0.200
     9.782   144.156     0.200
     9.818   141.984     0.200
     9.818   144.906     0.200
    10.255   149.523     0.200
    10.402   149.844     0.200
    10.608   154.102     0.200
    10.635   153.875     0.200
    10.701   155.703     0.200
    10.826   159.930     0.200
    10.958   158.180     0.200
    10.965   157.820     0.200
    10.965   158.898     0.200
    11.442   162.727     0.200
    11.845   167.930     0.200
    12.340   174.086     0.200
    12.362   176.102     0.200
    12.763   179.984     0.200
    12.813   181.344     0.200
    13.601   190.383     0.200
    13.588   192.547     0.200
    14.164   198.781     0.200
    14.195   198.523     0.200
    14.195   198.180     0.200
    14.183   204.844     0.200
    14.581   203.383     0.200
    14.772   207.562     0.200
    14.768   208.484     0.200
    14.893   210.180     0.200
    14.893   209.984     0.200
    14.893   210.047     0.200
    15.345   213.922     0.200
    15.341   215.430     0.200
    15.625   223.984     0.200
    15.662   223.297     0.200
    15.675   224.969     0.200
    15.683   224.609     0.200
    15.859   225.750     0.200
    15.951   222.984     0.200
    15.919   223.211     0.200
    15.919   225.984     0.200
    16.055   228.281     0.200
    16.126   227.422     0.200
    16.260   225.484     0.200
    16.275   224.984     0.200
    16.190   229.102     0.200
    16.190   231.023     0.200
    16.241   231.516     0.200
    16.266   229.453     0.200
    16.470   232.109     0.200
    16.546   234.727     0.200
    16.596   231.484     0.200
    16.596   231.727     0.200
    16.729   235.945     0.200
    16.817   236.703     0.200
    16.896   234.469     0.200
    16.896   236.727     0.200
    16.964   235.352     0.200
    17.004   235.375     0.200
    17.004   234.750     0.200
    17.004   236.086     0.200
    17.004   234.984     0.200
    17.074   237.500     0.200
    17.133   241.523     0.200
    17.413   240.844     0.200
    17.586   243.422     0.200
    18.273   253.336     0.200
    18.326   254.234     0.200
    18.326   253.094     0.200
    18.348   253.680     0.200
    18.794   262.938     0.200
    18.877   262.289     0.200
    19.140   263.375     0.200
    19.068   264.266     0.200
    19.320   266.883     0.200
    19.559   269.891     0.200
    19.649   270.180     0.200
    19.654   271.383     0.200
    19.654   271.586     0.200
    20.163   277.062     0.200
    20.204   276.883     0.200
    20.380   277.570     0.200
    20.384   279.172     0.200
    20.658   283.883     0.200
    20.830   284.391     0.200
     2.321    41.027     0.200
     3.970    62.816     0.200
     5.227    80.359     0.200
     5.879    92.348     0.200
     6.449    95.969     0.200
     7.582   113.609     0.200
     7.742   112.547     0.200
     7.706   115.867     0.200
     8.127   118.879     0.200
     8.154   118.328     0.200
     8.229   119.227     0.200
     8.300   123.477     0.200
     8.404   122.348     0.200
     8.484   122.887     0.200
     8.454   125.426     0.200
     8.599   127.809     0.200
     8.679   129.637     0.200
     8.839   128.957     0.200
     8.859   130.488     0.200
     8.946   131.867     0.200
     8.946   130.309     0.200
     8.976   130.449     0.200
     8.976   130.148     0.200
     9.044   133.609     0.200
     9.041   133.488     0.200
     9.511   136.488     0.200
    10.395   148.848     0.200
    11.436   161.918     0.200
    11.517   162.398     0.200
    12.333   173.148     0.200
    12.806   180.039     0.200
    12.756   179.648     0.200
    12.963   182.047     0.200
    13.369   186.539     0.200
    13.594   189.746     0.200
    14.157   197.148     0.200
    14.188   196.848     0.200
    14.390   200.047     0.200
    14.574   203.148     0.200
    14.770   207.738     0.200
    14.896   210.949     0.200
    14.896   211.246     0.200
    14.896   210.070     0.200
    14.896   211.539     0.200
    15.951   224.047     0.200
    16.603   231.098     0.200
    16.603   231.617     0.200
    16.900   233.598     0.200
    17.008   237.086     0.200
    17.008   235.949     0.200
    18.332   253.039     0.200
     1.427    27.066     0.200
     2.321    37.254     0.200
     2.344    41.635     0.200
     2.344    41.865     0.200
     3.993    63.725     0.200
     4.730    73.965     0.200
     4.874    76.055     0.200
     4.845    77.916     0.200
     5.154    79.385     0.200
     5.250    81.115     0.200
     5.353    84.145     0.200
     5.879    93.035     0.200
     6.473    96.535     0.200
     6.842   103.135     0.200
     7.420   110.455     0.200
     7.451   112.064     0.200
     7.451   113.996     0.200
     7.605   113.824     0.200
     7.655   116.115     0.200
     7.655   117.064     0.200
     8.177   118.596     0.200
     8.291   123.404     0.200
     8.343   119.445     0.200
     8.343   119.975     0.200
     8.388   123.672     0.200
     8.388   123.545     0.200
     8.507   126.215     0.200
     8.445   123.697     0.200
     8.445   125.096     0.200
     8.445   125.654     0.200
     8.445   124.436     0.200
     8.592   127.605     0.200
     8.674   128.695     0.200
     8.860   128.125     0.200
     8.851   130.836     0.200
     8.945   132.035     0.200
     8.945   131.285     0.200
     8.973   131.836     0.200
     8.973   132.135     0.200
     9.035   133.105     0.200
     9.034   133.725     0.200
     9.505   139.625     0.200
     9.621   141.355     0.200
     9.820   143.154     0.200
     9.767   144.006     0.200
    10.255   149.045     0.200
    10.361   151.096     0.200
    10.608   153.926     0.200
    10.629   153.746     0.200
    10.826   159.705     0.200
    10.965   158.395     0.200
    10.965   157.178     0.200
    11.539   163.166     0.200
    12.356   174.135     0.200
    12.827   180.574     0.200
    12.779   180.135     0.200
    12.987   182.734     0.200
    13.617   190.336     0.200
    13.580   191.480     0.200
    14.180   197.936     0.200
    14.211   198.596     0.200
    14.211   198.135     0.200
    14.413   200.836     0.200
    14.597   203.836     0.200
    14.767   207.984     0.200
    14.767   208.086     0.200
    14.893   209.936     0.200
    14.893   208.881     0.200
    14.893   210.475     0.200
    14.893   213.535     0.200
    15.333   218.064     0.200
    16.276   225.635     0.200
    16.291   225.336     0.200
    16.582   231.895     0.200
    16.582   231.311     0.200
    16.582   231.535     0.200
    16.891   233.238     0.200
    16.891   237.463     0.200
    16.999   239.516     0.200
    16.999   236.645     0.200
    16.999   237.885     0.200
    18.259   251.035     0.200
    18.259   253.045     0.200
    18.317   252.287     0.200
    20.396   277.916     0.200
     3.997    65.519     0.200
     4.735    75.749     0.200
     4.843    77.119     0.200
     5.255    82.169     0.200
     5.349    84.619     0.200
     5.788    91.199     0.200
     5.880    93.419     0.200
     6.130    92.659     0.200
     6.477    97.089     0.200
     7.420   110.599     0.200
     8.181   121.459     0.200
     8.290   124.249     0.200
     8.386   124.719     0.200
     8.445   126.013     0.200
     8.445   124.519     0.200
     8.445   126.320     0.200
     8.445   126.569     0.200
     8.592   129.379     0.200
     8.863   130.719     0.200
     8.850   131.609     0.200
     8.946   133.899     0.200
     9.034   133.938     0.200
     9.034   134.899     0.200
     9.539   139.509     0.200
    10.418   151.979     0.200
    10.966   159.359     0.200
    12.361   175.019     0.200
    12.784   180.719     0.200
    12.991   183.619     0.200
    13.622   191.519     0.200
    14.184   199.419     0.200
    14.215   198.399     0.200
    14.215   199.019     0.200
    14.417   202.119     0.200
    14.602   204.719     0.200
    14.767   209.109     0.200
    14.893   211.254     0.200
    14.893   214.179     0.200
    15.958   227.319     0.200
    16.281   226.319     0.200
    16.578   233.409     0.200
    16.578   232.956     0.200
    16.578   232.849     0.200
    16.891   234.494     0.200
    16.998   238.688     0.200
    18.255   254.019     0.200
     2.351    41.422     0.200
     4.871    75.766     0.200
     5.910    93.430     0.200
     6.869   102.742     0.200
     7.450   110.906     0.200
     8.318   124.031     0.200
     8.411   123.930     0.200
     8.411   123.273     0.200
     8.474   126.055     0.200
     8.474   125.391     0.200
     8.474   125.562     0.200
     8.474   125.922     0.200
     8.621   127.375     0.200
     8.879   131.359     0.200
     8.975   131.695     0.200
     9.003   132.180     0.200
     9.063   133.633     0.200
     9.063   134.594     0.200
     9.849   142.742     0.200
    10.996   158.352     0.200
    12.786   180.336     0.200
    13.605   190.875     0.200
    13.624   190.430     0.200
    14.187   198.336     0.200
    14.218   198.531     0.200
    14.420   200.836     0.200
    14.433   200.734     0.200
    14.606   203.430     0.200
    14.797   209.109     0.200
    14.923   210.352     0.200
    14.923   210.500     0.200
    14.923   213.125     0.200
    15.884   223.461     0.200
    15.985   228.133     0.200
    16.285   225.531     0.200
    16.595   231.992     0.200
    16.595   232.156     0.200
    16.919   234.039     0.200
    16.919   233.578     0.200
    17.027   234.281     0.200
    18.271   253.961     0.200
    18.271   252.492     0.200
    18.340   255.406     0.200
     2.324    40.756     0.200
     4.043    63.186     0.200
     4.710    73.376     0.200
     4.891    78.106     0.200
     5.230    79.976     0.200
     5.399    82.736     0.200
     5.915    92.446     0.200
     6.448    95.546     0.200
     6.812   102.226     0.200
     6.887   102.946     0.200
     7.195   107.526     0.200
     7.460   111.766     0.200
     8.336   123.336     0.200
     8.487   123.786     0.200
     8.435   123.291     0.200
     8.435   123.646     0.200
     8.490   124.476     0.200
     8.490   124.915     0.200
     8.490   125.486     0.200
     8.490   125.346     0.200
     8.490   125.062     0.200
     8.636   127.916     0.200
     8.895   130.836     0.200
     8.983   130.586     0.200
     8.983   132.186     0.200
     9.013   132.246     0.200
     9.013   130.266     0.200
     9.013   133.246     0.200
     9.077   133.796     0.200
     9.079   133.616     0.200
     9.349   135.596     0.200
     9.512   136.056     0.200
     9.747   141.306     0.200
     9.857   143.546     0.200
     9.857   142.166     0.200
    11.003   157.996     0.200
    11.003   159.221     0.200
    12.334   173.546     0.200
    12.759   179.046     0.200
    13.597   189.946     0.200
    13.627   191.562     0.200
    14.393   200.046     0.200
    14.579   202.146     0.200
    14.807   208.156     0.200
    14.944   207.946     0.200
    14.932   212.646     0.200
    14.932   212.446     0.200
    14.932   213.814     0.200
    14.932   211.546     0.200
    14.932   210.556     0.200
    14.932   213.646     0.200
    15.265   211.936     0.200
    15.265   211.476     0.200
    15.631   215.646     0.200
    16.259   224.846     0.200
    16.624   231.021     0.200
    16.624   230.616     0.200
    16.936   236.049     0.200
    16.936   237.869     0.200
    17.044   237.836     0.200
    17.044   239.746     0.200
    20.699   282.146     0.200
     2.341    41.137     0.200
     4.726    73.777     0.200
     4.887    78.027     0.200
     5.434    82.258     0.200
     5.920    93.109     0.200
     6.436    95.617     0.200
     6.465    95.457     0.200
     6.885   102.906     0.200
     7.746   115.879     0.200
     8.334   123.520     0.200
     8.428   123.430     0.200
     8.428   123.098     0.200
     8.428   123.609     0.200
     8.489   125.398     0.200
     8.489   124.227     0.200
     8.489   124.727     0.200
     8.489   124.957     0.200
     8.489   125.520     0.200
     8.635   128.656     0.200
     8.817   129.008     0.200
     8.894   130.797     0.200
     8.987   133.109     0.200
     8.987   131.668     0.200
     9.015   131.906     0.200
     9.015   131.609     0.200
     9.078   133.430     0.200
     9.077   133.836     0.200
     9.861   143.906     0.200
    11.007   158.707     0.200
    12.351   173.609     0.200
    12.776   179.309     0.200
    13.614   189.906     0.200
    14.176   197.207     0.200
    14.208   198.559     0.200
    14.410   200.809     0.200
    14.809   208.289     0.200
    14.935   210.309     0.200
    14.935   210.207     0.200
    14.961   207.406     0.200
    15.282   212.836     0.200
    15.648   215.707     0.200
    16.611   231.297     0.200
    16.611   230.855     0.200
    16.611   231.258     0.200
    16.934   234.637     0.200
    17.042   239.418     0.200
    17.042   238.086     0.200
    17.042   239.109     0.200
    18.287   252.656     0.200
     2.341    37.422     0.200
     2.410    40.121     0.200
     2.410    41.383     0.200
     5.011    77.684     0.200
     5.500    85.504     0.200
     5.500    83.992     0.200
     5.976    90.121     0.200
     6.076    94.023     0.200
     7.015   104.223     0.200
     7.310   108.152     0.200
     8.047   125.145     0.200
     7.851   116.723     0.200
     7.900   117.461     0.200
     8.218   127.562     0.200
     8.340   122.473     0.200
     8.467   124.863     0.200
     8.477   120.422     0.200
     8.626   126.934     0.200
     8.626   127.141     0.200
     8.626   126.613     0.200
     8.626   126.832     0.200
     8.776   129.461     0.200
     8.963   132.023     0.200
     9.032   132.273     0.200
     9.141   135.543     0.200
     9.220   134.941     0.200
     9.214   134.871     0.200
     9.694   140.324     0.200
     9.812   141.824     0.200
     9.901   144.922     0.200
     9.958   143.922     0.200
    10.014   148.422     0.200
    10.450   150.422     0.200
    10.610   151.496     0.200
    10.610   150.922     0.200
    10.804   155.422     0.200
    10.801   155.324     0.200
    10.895   156.523     0.200
    11.023   161.324     0.200
    11.161   159.621     0.200
    11.161   158.586     0.200
    13.678   189.922     0.200
    14.239   198.023     0.200
    14.486   200.422     0.200
    14.665   202.824     0.200
    14.961   209.684     0.200
    15.087   214.012     0.200
    15.087   213.125     0.200
    15.087   211.453     0.200
    15.355   212.074     0.200
    15.489   219.121     0.200
    16.348   224.621     0.200
    17.069   236.570     0.200
    17.069   238.320     0.200
    17.177   238.281     0.200
    17.177   238.000     0.200
    19.581   268.723     0.200
    19.821   270.723     0.200
    20.125   275.121     0.200
    20.565   279.824     0.200
     5.815    87.227     0.200
     5.815    86.746     0.200
     6.205    94.376     0.200
     6.346    93.286     0.200
     8.055   117.736     0.200
     8.853   126.267     0.200
     8.864   128.477     0.200
     8.864   128.286     0.200
     8.864   128.174     0.200
     9.166   131.307     0.200
     9.335   131.926     0.200
    10.916   151.227     0.200
    11.309   160.466     0.200
    13.962   191.807     0.200
    15.130   210.536     0.200
    15.253   212.826     0.200
    15.253   214.517     0.200
    17.028   233.201     0.200
    17.316   236.801     0.200
    19.694   266.576     0.200
     4.146    67.789     0.200
     4.146    68.500     0.200
     5.341    85.211     0.200
     5.899    91.492     0.200
     5.899    92.180     0.200
     7.673   116.719     0.200
     8.422   127.086     0.200
     8.422   125.992     0.200
     8.422   126.492     0.200
     8.621   129.633     0.200
    10.610   154.789     0.200
    10.934   158.305     0.200
    10.934   159.188     0.200
    14.737   208.789     0.200
    14.737   208.688     0.200
    14.737   208.492     0.200
    14.849   210.586     0.200
    14.863   210.891     0.200
    14.863   210.117     0.200
    15.250   212.977     0.200
    15.319   216.289     0.200
    15.951   223.898     0.200
    15.951   226.852     0.200
    16.977   237.086     0.200
    16.977   236.586     0.200
    16.977   235.328     0.200
    16.977   236.133     0.200
    18.202   253.695     0.200
    18.328   253.992     0.200
    18.328   254.391     0.200
     3.841    67.438     0.200
     4.146    68.352     0.200
     4.405    74.148     0.200
     4.827    79.438     0.200
     5.521    88.039     0.200
     6.752   102.969     0.200
     6.822   103.961     0.200
     7.133   108.633     0.200
     7.650   115.367     0.200
    14.863   210.781     0.200
    16.589   232.609     0.200
     4.146    64.586     0.200
     3.804    64.141     0.200
     4.121    67.359     0.200
     4.367    71.492     0.200
     4.792    77.812     0.200
     5.309    84.398     0.200
     5.878    91.148     0.200
     6.719   102.703     0.200
     6.785   103.562     0.200
     7.098   107.852     0.200
     7.613   115.281     0.200
     8.385   126.219     0.200
     8.346   125.523     0.200
     8.709   130.633     0.200
    16.568   233.852     0.200
    16.568   233.969     0.200
     4.155    69.688     0.200
     5.366    87.117     0.200
     5.903    91.422     0.200
     5.903    93.164     0.200
     6.046    95.922     0.200
     7.163   109.445     0.200
     7.720   118.359     0.200
     8.461   128.180     0.200
     8.461   127.984     0.200
     8.660   131.219     0.200
     8.790   131.977     0.200
    10.981   160.141     0.200
    14.783   210.359     0.200
    14.783   210.141     0.200
    14.909   211.500     0.200
    14.908   211.617     0.200
    15.284   214.570     0.200
    17.014   236.617     0.200
    17.014   236.891     0.200
    18.352   255.422     0.200
    14.783   209.922     0.200
    14.783   209.820     0.200
     3.880    65.180     0.200
     4.155    67.312     0.200
     4.452    72.195     0.200
     4.859    79.578     0.200
     5.366    84.695     0.200
     5.554    89.188     0.200
     5.903    93.000     0.200
     6.779   103.375     0.200
     6.857   105.000     0.200
     7.229   111.391     0.200
     8.402   126.172     0.200
     8.461   127.609     0.200
    16.591   233.719     0.200
    16.591   233.641     0.200
     4.319    67.367     0.200
     4.153    68.133     0.200
     4.153    69.609     0.200
     5.901    93.008     0.200
     8.459   127.711     0.200
    10.979   160.172     0.200
    14.781   210.016     0.200
    15.285   215.203     0.200
    17.012   236.531     0.200
    18.350   255.578     0.200
     5.901    91.734     0.200
     7.161   109.430     0.200
     7.688   117.289     0.200
     7.718   118.273     0.200
     8.459   126.234     0.200
     8.459   127.945     0.200
     8.788   132.211     0.200
    14.781   210.133     0.200
    14.781   210.570     0.200
    14.907   211.633     0.200
    15.285   215.836     0.200
    17.012   240.234     0.200
    18.350   255.336     0.200
     3.878    67.562     0.200
     4.153    69.172     0.200
     4.451    75.312     0.200
     5.552    89.039     0.200
     4.317    67.336     0.200
     3.558    57.609     0.200
     4.317    67.336     0.200
     4.145    68.427     0.200
     4.145    69.417     0.200
     4.849    80.607     0.200
     5.893    92.427     0.200
     6.036    95.607     0.200
     6.768   104.707     0.200
     7.153   109.167     0.200
     7.712   117.967     0.200
     7.680   116.697     0.200
     8.451   127.627     0.200
     8.451   127.887     0.200
     8.780   132.027     0.200
    14.774   209.827     0.200
    14.774   210.087     0.200
    14.900   212.627     0.200
    18.341   255.027     0.200
     3.871    67.487     0.200
     4.145    68.567     0.200
     4.444    73.997     0.200
     4.849    77.857     0.200
     5.356    84.537     0.200
     5.543    89.267     0.200
     6.768   103.747     0.200
     6.847   105.087     0.200
     7.153   108.646     0.200
     7.680   115.917     0.200
     8.391   125.437     0.200
     8.451   126.497     0.200
     8.980   135.017     0.200
     9.826   146.237     0.200
    10.973   160.297     0.200
    14.900   212.277     0.200
    16.581   233.917     0.200
    16.581   233.827     0.200
    17.004   237.157     0.200
     4.145    65.264     0.200
     4.156    68.283     0.200
     4.156    70.604     0.200
     4.893    81.143     0.200
     5.389    87.244     0.200
     5.897    94.283     0.200
     6.085    96.303     0.200
     6.804   104.973     0.200
     7.194   109.953     0.200
     7.734   117.414     0.200
     8.504   128.283     0.200
     8.840   132.463     0.200
    14.837   210.594     0.200
    14.963   213.684     0.200
    15.340   216.482     0.200
     3.925    68.664     0.200
     4.510    74.133     0.200
     4.893    80.812     0.200
     5.389    86.193     0.200
     5.897    90.354     0.200
     7.734   117.062     0.200
     8.422   125.703     0.200
     9.044   131.883     0.200
    11.039   161.174     0.200
    14.837   211.223     0.200
    14.963   212.863     0.200
    16.581   233.834     0.200
    16.581   233.834     0.200
    18.373   255.953     0.200
     4.156    65.400     0.200
     3.538    57.320     0.200
     4.102    68.816     0.200
     4.810    79.707     0.200
     5.314    86.207     0.200
     5.850    92.473     0.200
     6.727   104.238     0.200
     7.113   108.637     0.200
     7.645   116.316     0.200
     7.684   117.477     0.200
     8.416   127.145     0.200
     8.416   127.297     0.200
     8.926   133.777     0.200
     8.951   136.367     0.200
     9.799   145.887     0.200
    10.345   152.676     0.200
    10.946   159.324     0.200
    14.745   209.488     0.200
    14.745   209.727     0.200
    14.745   209.285     0.200
    14.871   212.746     0.200
    15.315   214.137     0.200
    16.968   236.301     0.200
    18.300   254.738     0.200
     4.102    68.688     0.200
     5.850    92.285     0.200
    18.300   254.188     0.200
     3.836    67.285     0.200
     4.102    68.566     0.200
     4.417    74.047     0.200
     4.810    79.496     0.200
     5.314    86.066     0.200
     5.505    88.797     0.200
     6.727   104.059     0.200
     7.187   110.816     0.200
     7.396   113.625     0.200
     8.349   125.465     0.200
     8.748   130.918     0.200
     8.926   133.527     0.200
     8.951   133.938     0.200
     9.799   145.207     0.200
    10.946   159.637     0.200
    14.745   209.887     0.200
    14.871   211.535     0.200
    16.538   234.098     0.200
    16.538   233.965     0.200
    16.968   237.445     0.200
    18.300   254.926     0.200
     4.102    64.664     0.200
     2.883    47.223     0.200
     3.819    65.609     0.200
     4.129    67.812     0.200
     4.384    71.461     0.200
     4.806    78.055     0.200
     5.321    85.734     0.200
     5.499    88.586     0.200
     5.884    93.336     0.200
     6.731   103.336     0.200
     6.800   104.016     0.200
     7.112   108.461     0.200
     7.164   110.250     0.200
     7.369   112.773     0.200
     7.628   115.352     0.200
     8.358   125.062     0.200
     8.400   126.273     0.200
    10.912   159.859     0.200
    14.715   208.820     0.200
    16.574   233.180     0.200
    16.574   234.094     0.200
    16.955   240.523     0.200
     3.556    57.609     0.200
     4.168    69.502     0.200
     4.168    67.811     0.200
     5.912    93.311     0.200
     7.759   118.352     0.200
     8.495   128.072     0.200
     8.495   127.912     0.200
    14.821   210.471     0.200
    14.947   213.711     0.200
     3.915    67.572     0.200
     4.168    68.971     0.200
     4.492    75.400     0.200
     5.912    92.172     0.200
     8.425   125.492     0.200
     8.495   127.281     0.200
     8.827   131.262     0.200
    14.947   212.871     0.200
    17.048   240.742     0.200
    18.376   255.992     0.200
     4.173    69.355     0.200
     5.918    92.754     0.200
     7.748   117.254     0.200
     8.495   127.957     0.200
    10.660   156.156     0.200
    10.676   155.656     0.200
    10.753   157.457     0.200
    11.018   160.355     0.200
    14.819   210.055     0.200
    14.819   210.461     0.200
    14.819   210.355     0.200
    14.945   211.719     0.200
    14.945   211.855     0.200
    15.299   215.395     0.200
    15.862   224.164     0.200
    17.048   236.652     0.200
    18.212   254.441     0.200
    18.378   255.461     0.200
     3.915    66.656     0.200
     4.173    68.965     0.200
     4.890    80.125     0.200
     5.585    89.375     0.200
     5.918    92.586     0.200
     6.807   104.977     0.200
     6.889   105.656     0.200
     7.193   109.445     0.200
     7.264   111.465     0.200
     7.472   114.004     0.200
     7.724   116.906     0.200
     8.428   125.875     0.200
     8.825   132.016     0.200
     9.025   134.184     0.200
     9.871   146.137     0.200
    14.945   211.656     0.200
    15.862   224.645     0.200
    16.604   232.566     0.200
    16.604   232.754     0.200
     3.566    55.934     0.200
     4.177    66.508     0.200
     4.579    72.578     0.200
     4.943    77.500     0.200
    15.030   214.109     0.200
    16.590   233.602     0.200
    16.590   233.828     0.200
     4.177    65.695     0.200
     4.900    80.062     0.200
     5.401    87.422     0.200
     6.815   105.617     0.200
     6.899   105.297     0.200
     7.202   109.781     0.200
     7.276   111.141     0.200
     7.483   113.812     0.200
     7.735   116.797     0.200
     8.505   126.875     0.200
     9.037   134.344     0.200
     9.883   145.867     0.200
    11.030   160.367     0.200
    14.831   210.617     0.200
    17.058   240.141     0.200
     5.121    78.750     0.200
     4.150    69.440     0.200
     4.864    80.640     0.200
     5.368    86.880     0.200
     5.896    93.074     0.200
     6.781   104.510     0.200
     7.698   117.040     0.200
     7.732   118.330     0.200
     8.469   127.897     0.200
     8.469   128.050     0.200
     9.735   144.760     0.200
    10.994   160.204     0.200
    14.794   210.040     0.200
    14.794   210.410     0.200
    14.794   209.840     0.200
    14.920   211.709     0.200
    15.302   214.629     0.200
    17.021   236.734     0.200
    17.021   236.440     0.200
    18.353   255.535     0.200
    18.353   254.840     0.200
     3.889    67.530     0.200
     4.864    80.310     0.200
     9.847   144.450     0.200
     3.549    57.820     0.200
     4.150    65.639     0.200
     4.165    69.431     0.200
     4.901    81.410     0.200
     5.398    87.130     0.200
     6.813   105.450     0.200
     7.203   110.130     0.200
     7.742   117.460     0.200
     7.783   118.840     0.200
     8.512   128.510     0.200
     9.898   147.130     0.200
    14.844   210.650     0.200
    14.844   210.450     0.200
    14.844   210.840     0.200
    15.336   217.351     0.200
     4.165    67.050     0.200
     5.905    93.150     0.200
     8.512   128.150     0.200
    14.970   213.150     0.200
     3.933    67.800     0.200
     4.165    68.870     0.200
     4.901    80.380     0.200
     7.203   110.670     0.200
     7.742   117.070     0.200
     9.898   146.070     0.200
    18.382   255.400     0.200
     4.165    65.548     0.200
     4.138    68.883     0.200
     6.763   104.662     0.200
     8.447   127.613     0.200
    14.771   210.012     0.200
    15.294   215.402     0.200
     4.138    67.693     0.200
     5.887    92.193     0.200
     8.447   126.992     0.200
    10.630   154.293     0.200
    10.705   157.092     0.200
    17.000   239.992     0.200
     3.867    68.033     0.200
     4.138    69.213     0.200
     4.442    75.232     0.200
     4.844    80.033     0.200
     5.539    89.592     0.200
     5.887    93.104     0.200
     6.842   105.223     0.200
     7.148   109.893     0.200
     7.216   111.682     0.200
     7.423   114.512     0.200
     7.676   116.762     0.200
     8.447   127.512     0.200
     8.777   131.273     0.200
    10.970   160.422     0.200
    14.771   210.432     0.200
     4.138    65.229     0.200
     4.303    66.928     0.200
     4.183    68.715     0.200
     4.183    69.586     0.200
     5.925    92.016     0.200
     7.784   118.906     0.200
     8.518   128.215     0.200
     8.518   128.625     0.200
     9.024   135.254     0.200
    10.780   157.914     0.200
    14.845   210.816     0.200
    14.845   211.027     0.200
    14.971   212.316     0.200
    15.313   215.867     0.200
    17.071   240.055     0.200
    18.396   256.117     0.200
     3.939    68.125     0.200
     4.183    69.285     0.200
     4.516    75.996     0.200
     4.911    80.254     0.200
     5.411    86.617     0.200
     5.606    89.727     0.200
     5.925    92.555     0.200
     6.825   104.605     0.200
     8.445   125.957     0.200
    11.045   160.844     0.200
    14.971   212.195     0.200
    16.610   232.715     0.200
    16.610   232.715     0.200
    17.071   237.395     0.200
     5.126    80.516     0.200
     4.174    70.900     0.200
     4.900    81.260     0.200
     5.400    87.590     0.200
     7.736   117.750     0.200
     8.507   128.850     0.200
     8.839   132.810     0.200
    14.834   211.250     0.200
     4.174    69.830     0.200
     4.505    74.710     0.200
     4.900    79.810     0.200
     5.400    86.140     0.200
     5.595    89.680     0.200
     5.917    93.380     0.200
     6.814   105.060     0.200
     6.900   105.830     0.200
     7.202   110.580     0.200
     7.278   111.910     0.200
     7.486   114.280     0.200
     7.736   116.330     0.200
     8.434   125.300     0.200
     8.507   127.850     0.200
     8.839   131.390     0.200
     9.040   133.110     0.200
    11.034   160.610     0.200
    14.834   210.000     0.200
    14.960   210.540     0.200
    16.602   233.520     0.200
    16.602   233.210     0.200
     3.561    57.571     0.200
     2.974    48.522     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.817    52.047     0.200
     8.132   152.047     0.200
     2.790    52.914     0.200
     4.282    80.914     0.200
     5.831   117.414     0.200
     6.120   119.914     0.200
     6.704   129.914     0.200
     6.010   114.843     0.200
     6.246   122.843     0.200
     6.684   129.843     0.200
     5.868   118.994     0.200
     7.126   139.805     0.200
     8.280   159.102     0.200
     8.264   157.234     0.200
     6.092   114.082     0.200
     2.766    50.859     0.200
     2.753    51.000     0.200
     5.274    97.334     0.200
     3.841    71.785     0.200
     4.211    76.090     0.200
    10.826   199.992     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.809    15.117     0.200
     7.628   130.117     0.200
     8.420   149.117     0.200
     8.532   146.117     0.200
     1.459    25.844     0.200
     2.914    51.250     0.200
     0.725    13.215     0.200
     0.912    16.914     0.200
     0.995    18.243     0.200
     1.136    20.143     0.200
     2.590    45.442     0.200
     5.670   101.843     0.200
     1.774    31.459     0.200
     1.235    22.494     0.200
     1.033    18.826     0.200
     2.982    53.826     0.200
     2.982    54.127     0.200
     1.456    26.703     0.200
     1.830    34.105     0.200
     2.121    37.406     0.200
     2.334    40.203     0.200
     2.993    52.504     0.200
     3.235    56.805     0.200
     1.492    27.812     0.200
     1.846    34.613     0.200
     2.140    38.113     0.200
     2.335    40.512     0.200
     1.463    27.414     0.200
     1.855    35.008     0.200
     2.144    38.508     0.200
     2.367    41.211     0.200
     1.077    19.492     0.200
     1.460    26.891     0.200
     1.840    34.492     0.200
     2.131    38.094     0.200
     1.461    27.602     0.200
     2.137    39.398     0.200
     1.437    26.438     0.200
     1.850    34.438     0.200
     2.136    37.531     0.200
     1.229    23.477     0.200
     1.575    30.070     0.200
     1.865    34.273     0.200
     2.104    37.375     0.200
     1.455    27.242     0.200
     2.156    39.941     0.200
     1.368    25.490     0.200
     2.091    36.289     0.200
     2.423    42.590     0.200
     6.473   108.090     0.200
     1.243    23.684     0.200
     1.400    25.844     0.200
     2.424    42.242     0.200
     1.510    27.918     0.200
     2.162    38.316     0.200
     2.356    39.719     0.200
     1.289    24.742     0.200
     2.130    39.141     0.200
     2.268    40.242     0.200
     0.758    15.141     0.200
     1.689    31.039     0.200
     1.274    24.273     0.200
     1.339    25.883     0.200
     2.496    45.184     0.200
     1.257    23.902     0.200
     1.885    32.402     0.200
     1.240    23.500     0.200
     1.935    36.199     0.200
     2.209    40.000     0.200
     2.327    42.500     0.200
     2.320    42.098     0.200
     1.236    23.734     0.200
     1.541    27.945     0.200
     1.219    22.605     0.200
     1.201    22.854     0.200
     2.372    42.254     0.200
     1.199    22.830     0.200
     1.140    21.383     0.200
     1.647    30.383     0.200
     1.838    33.086     0.200
     1.159    21.992     0.200
     1.656    31.391     0.200
     1.835    34.094     0.200
     2.397    42.492     0.200
     1.346    25.809     0.200
     2.215    41.708     0.200
     1.275    23.262     0.200
     1.205    22.957     0.200
     2.115    39.758     0.200
     1.343    25.844     0.200
     1.266    24.152     0.200
     1.053    20.316     0.200
     1.477    26.914     0.200
     1.742    31.715     0.200
     0.868    15.617     0.200
     1.623    30.516     0.200
     2.016    37.117     0.200
     0.887    16.000     0.200
     1.609    30.500     0.200
     2.747    48.398     0.200
     0.829    18.135     0.200
     0.859    15.426     0.200
     2.007    37.326     0.200
     1.152    20.399     0.200
     1.152    21.199     0.200
     1.418    26.399     0.200
     2.060    37.099     0.200
     2.507    43.999     0.200
     1.149    20.304     0.200
     1.405    26.334     0.200
     2.036    36.134     0.200
     1.042    19.236     0.200
     1.513    27.637     0.200
     2.121    38.037     0.200
     1.576    27.779     0.200
     2.193    37.938     0.200
     1.068    17.859     0.200
     1.031    18.305     0.200
     1.314    22.828     0.200
     0.839    15.756     0.200
     1.101    19.320     0.200
     1.468    27.301     0.200
     1.402    24.914     0.200
     1.562    28.078     0.200
     1.413    25.742     0.200
     1.319    24.848     0.200
     1.389    25.418     0.200
     2.398    41.518     0.200
     2.865    52.217     0.200
     0.957    16.812     0.200
     1.406    26.531     0.200
     1.040    18.375     0.200
     1.244    22.562     0.200
     1.244    23.102     0.200
     1.369    23.816     0.200
     1.369    24.117     0.200
     0.573    10.621     0.200
     0.640    11.820     0.200
     0.640    11.711     0.200
     4.764    83.660     0.200
     1.423    26.453     0.200
     1.423    26.156     0.200
     3.435    58.516     0.200
     7.461   127.695     0.200
     7.461   134.227     0.200
     7.665   131.266     0.200
     7.665   137.914     0.200
     8.353   146.234     0.200
     1.427    24.957     0.200
     2.321    38.848     0.200
     3.429    59.996     0.200
     1.339    24.186     0.200
     1.410    25.215     0.200
     1.406    25.679     0.200
     2.349    41.569     0.200
     1.389    25.492     0.200
     1.406    25.206     0.200
     2.324    39.846     0.200
     1.318    23.938     0.200
     1.391    24.789     0.200
     1.391    25.207     0.200
     2.341    40.809     0.200
     1.193    21.812     0.200
     1.267    22.844     0.200
     1.267    22.742     0.200
     1.379    25.703     0.200
     1.379    25.352     0.200
     1.404    26.648     0.200
     1.329    24.789     0.200
     4.489    77.316     0.200
     3.926    71.406     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.341   118.117     0.200
     4.197   121.117     0.200
     5.523   152.117     0.200
     5.801   157.117     0.200
     5.957   167.117     0.200
     6.110   163.117     0.200
     6.568   176.117     0.200
     6.574   175.117     0.200
     7.488   194.117     0.200
     7.503   199.117     0.200
     7.628   198.117     0.200
     8.420   221.117     0.200
     8.532   225.117     0.200
     9.790   243.117     0.200
     9.646   252.117     0.200
    17.725   435.117     0.200
     4.285   121.047     0.200
     6.146   172.047     0.200
     8.132   207.047     0.200
     8.627   223.047     0.200
    12.400   316.047     0.200
    18.577   450.047     0.200
    20.229   506.047     0.200
    22.150   547.047     0.200
     5.694   155.914     0.200
     5.831   161.414     0.200
     6.120   166.914     0.200
     7.475   196.613     0.200
     7.802   210.914     0.200
     8.084   206.414     0.200
    18.555   451.715     0.200
     4.075   118.643     0.200
     6.246   169.543     0.200
     7.790   204.843     0.200
     8.338   210.843     0.200
     3.125    95.059     0.200
     4.055   114.459     0.200
     5.743   157.759     0.200
     6.518   172.959     0.200
     7.505   201.759     0.200
     8.122   206.959     0.200
     8.310   218.959     0.200
     9.589   245.959     0.200
    12.555   315.459     0.200
    14.077   348.259     0.200
    14.077   362.259     0.200
     4.267   121.395     0.200
     5.868   163.395     0.200
     8.144   205.094     0.200
     8.885   228.395     0.200
    10.145   262.195     0.200
    10.132   262.195     0.200
     4.168   118.727     0.200
     4.170   113.826     0.200
     4.281   124.826     0.200
     4.281   124.826     0.200
     4.377   121.127     0.200
     5.336   144.826     0.200
     5.770   159.025     0.200
     6.303   175.525     0.200
     7.690   200.426     0.200
     8.072   210.826     0.200
     8.812   231.826     0.200
     9.993   266.627     0.200
    10.071   260.627     0.200
    10.084   260.627     0.200
    11.346   281.727     0.200
    15.794   391.025     0.200
    18.583   457.826     0.200
    19.278   471.826     0.200
    19.719   496.826     0.200
    19.756   494.826     0.200
    19.867   497.426     0.200
    21.362   531.426     0.200
    21.401   531.426     0.200
     4.030   118.305     0.200
     5.311   139.805     0.200
     5.746   158.406     0.200
     6.594   175.805     0.200
     7.732   199.605     0.200
     8.095   208.805     0.200
     8.270   206.805     0.200
     8.827   229.805     0.200
     9.102   234.805     0.200
    10.014   265.805     0.200
    10.035   258.805     0.200
    10.093   257.805     0.200
    10.306   263.805     0.200
    10.306   270.805     0.200
    10.490   273.805     0.200
    14.312   361.504     0.200
    17.333   432.504     0.200
    17.564   433.805     0.200
    18.185   443.305     0.200
    18.605   452.805     0.200
    21.357   537.805     0.200
    21.637   536.805     0.200
     3.869   112.211     0.200
     4.144   119.613     0.200
     4.149   117.613     0.200
     4.246   122.414     0.200
     5.730   156.312     0.200
     6.329   175.711     0.200
     8.299   209.113     0.200
     8.849   234.312     0.200
    18.619   465.312     0.200
     3.946   115.008     0.200
     4.097   117.711     0.200
     4.123   121.211     0.200
     4.233   123.914     0.200
     5.376   148.008     0.200
     5.722   154.711     0.200
     6.275   172.508     0.200
     6.558   179.211     0.200
     8.284   210.414     0.200
     8.789   230.609     0.200
     9.108   238.211     0.200
    10.490   274.711     0.200
    14.322   364.812     0.200
    18.631   466.211     0.200
     4.117   117.992     0.200
     4.141   117.391     0.200
     4.141   122.293     0.200
     4.249   121.992     0.200
     4.486   118.992     0.200
     5.324   145.492     0.200
     5.395   140.594     0.200
     5.736   158.492     0.200
     6.298   176.094     0.200
     8.081   211.293     0.200
     8.813   228.492     0.200
     9.102   232.492     0.200
    10.488   268.492     0.200
    12.170   305.492     0.200
    16.191   407.492     0.200
    19.820   499.492     0.200
     3.852   114.602     0.200
     3.862   112.398     0.200
     4.180   114.602     0.200
     3.956   117.703     0.200
     4.009   116.203     0.200
     4.132   118.805     0.200
     4.132   122.102     0.200
     4.241   124.602     0.200
     6.569   183.102     0.200
     8.069   215.898     0.200
     8.280   212.102     0.200
     8.801   234.500     0.200
     9.716   247.703     0.200
    11.370   293.500     0.200
    15.049   372.602     0.200
    17.253   423.102     0.200
    18.623   452.602     0.200
    23.257   570.102     0.200
     3.277    96.234     0.200
     3.638   104.234     0.200
     3.843   111.633     0.200
     3.838   109.234     0.200
     4.150   116.734     0.200
     3.999   113.133     0.200
     4.119   114.734     0.200
     4.123   118.234     0.200
     4.609   129.234     0.200
     5.370   144.234     0.200
     6.370   171.133     0.200
     7.710   192.234     0.200
     8.264   208.234     0.200
     8.760   225.234     0.200
    10.021   259.938     0.200
    10.524   271.836     0.200
    16.126   400.734     0.200
    17.601   436.234     0.200
    18.627   454.234     0.200
    18.627   459.734     0.200
     2.333    72.273     0.200
     5.215   139.273     0.200
     7.503   191.773     0.200
     8.021   202.773     0.200
     9.288   236.273     0.200
     9.490   241.570     0.200
    17.012   415.273     0.200
     2.516    79.941     0.200
     6.510   174.941     0.200
     7.727   202.242     0.200
     8.283   211.242     0.200
     6.473   173.391     0.200
     8.740   227.090     0.200
    16.069   400.090     0.200
     8.079   206.082     0.200
     9.548   258.082     0.200
    15.663   397.082     0.200
    18.607   452.082     0.200
     8.245   208.641     0.200
     9.250   233.641     0.200
    11.507   281.641     0.200
    23.396   573.242     0.200
     8.319   209.117     0.200
     2.268    70.941     0.200
     8.135   205.441     0.200
    18.622   460.441     0.200
     2.270    73.570     0.200
     8.121   207.773     0.200
     2.344    81.285     0.200
     2.337    74.684     0.200
     3.271    94.684     0.200
     6.259   167.184     0.200
     8.186   209.684     0.200
     9.954   253.234     0.200
    18.647   466.684     0.200
     2.368    70.402     0.200
     6.688   179.402     0.200
     8.046   201.902     0.200
     2.327    72.898     0.200
     3.083    88.898     0.200
     6.556   177.098     0.200
     8.864   233.898     0.200
     9.311   251.898     0.200
     2.354    72.934     0.200
     3.973   112.734     0.200
     4.927   130.134     0.200
     5.440   138.434     0.200
     6.092   160.134     0.200
     6.426   169.234     0.200
     8.012   201.734     0.200
     8.253   215.034     0.200
    11.090   278.364     0.200
    12.596   313.394     0.200
     4.268   115.445     0.200
     5.010   138.047     0.200
     5.151   138.844     0.200
     5.222   139.148     0.200
     6.038   156.445     0.200
     6.394   166.945     0.200
     6.733   174.445     0.200
     6.653   178.047     0.200
     7.817   201.945     0.200
     8.343   209.945     0.200
     8.587   216.445     0.200
     8.932   226.602     0.200
     8.856   227.445     0.200
     9.800   250.445     0.200
    11.344   279.914     0.200
    11.344   285.062     0.200
    12.930   320.992     0.200
    13.059   321.766     0.200
    18.651   452.445     0.200
     2.245    71.668     0.200
     2.238    70.504     0.200
     4.848   126.504     0.200
     5.687   151.504     0.200
     6.376   170.504     0.200
     8.065   203.703     0.200
     8.800   224.453     0.200
     8.650   227.004     0.200
     9.430   248.504     0.200
    11.436   283.754     0.200
    12.760   315.223     0.200
    18.517   461.504     0.200
    19.130   475.504     0.200
    19.498   483.184     0.200
     2.217    70.754     0.200
     4.828   132.053     0.200
     6.008   157.953     0.200
     6.356   171.453     0.200
     8.048   204.453     0.200
     8.308   212.354     0.200
    11.433   281.643     0.200
    11.433   292.504     0.200
    11.433   292.973     0.200
    12.746   315.242     0.200
    17.548   436.453     0.200
    18.504   449.453     0.200
     6.343   167.330     0.200
     8.047   204.330     0.200
     8.309   205.930     0.200
    15.831   401.330     0.200
     3.872   110.984     0.200
     4.999   138.984     0.200
     5.606   146.383     0.200
     6.949   176.172     0.200
     7.108   182.336     0.200
     7.515   192.031     0.200
     7.847   198.984     0.200
     8.957   232.219     0.200
     9.348   234.852     0.200
     9.241   242.984     0.200
    12.395   308.336     0.200
    12.395   311.523     0.200
    12.395   311.781     0.200
    12.837   318.984     0.200
    13.497   334.188     0.200
    14.096   345.984     0.200
    14.305   352.281     0.200
    14.859   366.188     0.200
    17.982   450.883     0.200
    18.112   443.484     0.200
    18.792   458.711     0.200
    19.038   470.805     0.200
     8.962   233.453     0.200
    14.877   365.992     0.200
     3.151    91.908     0.200
     4.818   134.809     0.200
     7.145   189.038     0.200
     7.851   200.078     0.200
     8.148   206.408     0.200
     8.146   209.048     0.200
     8.243   210.678     0.200
     8.393   213.068     0.200
     8.393   219.559     0.200
     8.393   219.738     0.200
     8.758   223.908     0.200
     8.696   229.933     0.200
     9.606   244.608     0.200
     9.682   249.208     0.200
     9.661   246.269     0.200
    12.749   318.298     0.200
    16.230   404.908     0.200
    18.477   452.408     0.200
    18.513   464.286     0.200
     6.129   155.762     0.200
     6.467   164.812     0.200
     7.074   184.164     0.200
     7.790   193.535     0.200
     8.082   202.363     0.200
     8.178   204.754     0.200
     8.328   209.152     0.200
     8.611   223.359     0.200
     8.611   223.262     0.200
     8.699   225.117     0.200
     8.914   226.363     0.200
    12.694   309.293     0.200
    16.196   401.664     0.200
    16.732   413.828     0.200
    16.732   409.465     0.200
    18.426   456.363     0.200
    18.500   455.363     0.200
    18.540   460.312     0.200
     5.588   152.156     0.200
     6.805   174.109     0.200
     7.841   199.336     0.200
     8.029   204.258     0.200
     8.192   214.949     0.200
     8.302   209.777     0.200
     8.249   215.027     0.200
     8.249   214.957     0.200
     8.359   212.336     0.200
     8.406   224.258     0.200
     8.873   225.777     0.200
    12.763   317.559     0.200
    12.802   320.039     0.200
    13.377   331.957     0.200
    13.942   346.359     0.200
    13.968   346.656     0.200
    14.185   351.258     0.200
    14.347   355.859     0.200
    14.713   363.859     0.200
    16.595   410.332     0.200
    18.279   450.488     0.200
    18.279   450.488     0.200
    18.279   453.684     0.200
    18.583   457.258     0.200
     3.525   103.344     0.200
     5.855   155.344     0.200
     7.872   206.434     0.200
     8.008   208.031     0.200
     8.429   216.926     0.200
    16.476   403.043     0.200
    18.167   446.168     0.200
     7.000   178.234     0.200
     7.759   204.531     0.200
     7.867   200.562     0.200
     8.112   207.953     0.200
     8.141   207.023     0.200
     8.283   215.824     0.200
     8.371   212.043     0.200
     8.395   220.688     0.200
    16.608   411.148     0.200
    18.286   454.098     0.200
     4.671   126.215     0.200
     6.245   162.387     0.200
     6.854   177.246     0.200
     7.870   198.453     0.200
     8.112   202.375     0.200
     8.734   224.508     0.200
    16.920   417.145     0.200
     2.766    80.453     0.200
     4.348   119.016     0.200
     4.765   134.016     0.200
     5.093   139.016     0.200
     5.620   151.094     0.200
     6.067   164.219     0.200
     6.768   177.062     0.200
     7.142   182.312     0.200
     8.254   208.016     0.200
     8.672   223.016     0.200
     8.900   232.016     0.200
     8.900   228.719     0.200
     8.950   230.016     0.200
     9.129   237.914     0.200
     9.129   232.594     0.200
     9.344   241.016     0.200
    16.745   420.016     0.200
    18.468   457.414     0.200
    18.821   471.719     0.200
    18.854   468.727     0.200
    19.604   491.617     0.200
     2.753    81.203     0.200
     4.331   118.000     0.200
     4.745   135.000     0.200
     5.076   139.000     0.200
     5.603   149.820     0.200
     6.047   164.797     0.200
     6.428   169.500     0.200
     6.748   177.281     0.200
     7.813   201.641     0.200
     8.929   232.680     0.200
     8.976   231.500     0.200
     9.154   238.297     0.200
     9.154   237.359     0.200
     9.369   244.000     0.200
     9.818   250.602     0.200
    16.758   422.602     0.200
    16.821   421.883     0.200
    18.883   473.109     0.200
     0.829    31.334     0.200
     4.735   123.385     0.200
     5.274   136.533     0.200
     5.961   151.504     0.200
     7.055   177.354     0.200
     7.672   186.334     0.200
     8.509   215.254     0.200
    12.418   297.504     0.200
     4.365   119.025     0.200
     5.636   151.105     0.200
     6.076   161.125     0.200
     6.778   178.496     0.200
     7.201   181.326     0.200
     7.841   203.195     0.200
     8.951   232.979     0.200
     8.951   232.826     0.200
     9.008   234.025     0.200
     9.187   239.426     0.200
     9.403   250.525     0.200
     9.802   253.252     0.200
     9.847   244.025     0.200
     9.920   254.125     0.200
    16.802   420.525     0.200
    16.823   416.818     0.200
    16.823   416.895     0.200
    18.480   459.812     0.200
    18.581   466.121     0.200
    19.603   491.826     0.200
     4.441   123.324     0.200
     5.412   145.569     0.200
     5.915   157.599     0.200
     6.610   171.959     0.200
     6.646   167.499     0.200
     7.693   197.859     0.200
     8.089   211.635     0.200
     8.220   207.699     0.200
     8.510   219.029     0.200
     8.542   220.919     0.200
     8.542   220.049     0.200
     8.676   224.820     0.200
     8.676   226.068     0.200
     8.821   224.699     0.200
     8.892   234.199     0.200
     9.754   249.099     0.200
    10.036   259.688     0.200
    10.306   264.650     0.200
    10.507   270.824     0.200
    11.238   289.736     0.200
    11.450   283.699     0.200
    13.757   347.790     0.200
    15.356   374.639     0.200
    16.247   407.699     0.200
    16.617   409.744     0.200
    16.617   407.429     0.200
    18.287   451.462     0.200
    18.287   454.464     0.200
    18.470   459.964     0.200
    18.538   464.169     0.200
     4.470   123.300     0.200
     6.597   171.264     0.200
     6.597   171.464     0.200
     7.897   196.934     0.200
     8.121   211.125     0.200
     8.201   206.434     0.200
     8.542   218.034     0.200
     8.574   219.446     0.200
     8.574   219.964     0.200
     8.707   226.057     0.200
     8.707   223.706     0.200
    16.644   410.474     0.200
    16.644   408.774     0.200
    18.314   450.708     0.200
    18.314   449.178     0.200
     4.411   122.338     0.200
     5.512   142.467     0.200
     6.369   164.137     0.200
     6.705   172.326     0.200
     6.716   166.137     0.200
     8.110   211.861     0.200
     8.300   209.137     0.200
     8.543   221.096     0.200
     8.543   224.637     0.200
     8.714   227.480     0.200
     8.714   228.338     0.200
     8.930   237.137     0.200
     9.322   239.314     0.200
    12.871   317.146     0.200
    16.571   412.561     0.200
    18.239   448.461     0.200
     4.602   126.680     0.200
     5.119   138.320     0.200
     6.238   157.180     0.200
     6.352   165.760     0.200
     7.432   191.910     0.200
     8.192   214.361     0.200
     8.325   204.719     0.200
     8.360   214.336     0.200
     8.362   219.150     0.200
     8.940   229.180     0.200
    10.822   275.980     0.200
    14.778   371.180     0.200
    18.303   444.730     0.200
     4.943   132.938     0.200
     5.464   146.698     0.200
     6.510   163.638     0.200
     6.677   174.538     0.200
     7.429   196.658     0.200
     7.766   199.838     0.200
     8.194   215.878     0.200
     8.194   215.988     0.200
     8.322   210.938     0.200
     8.378   217.561     0.200
     8.572   215.838     0.200
     8.516   221.724     0.200
     9.121   238.358     0.200
    10.461   270.163     0.200
    12.950   322.058     0.200
    16.474   404.277     0.200
    18.146   447.913     0.200
    18.146   446.500     0.200
     4.229   108.547     0.200
     5.495   144.844     0.200
     5.995   159.148     0.200
     6.689   168.547     0.200
     8.283   206.117     0.200
     8.292   205.547     0.200
     8.528   220.898     0.200
     8.692   224.930     0.200
     9.298   243.516     0.200
    18.236   449.578     0.200
    18.236   448.547     0.200
     6.748   169.047     0.200
     7.831   195.180     0.200
     8.480   221.508     0.200
     8.660   226.047     0.200
     8.660   229.203     0.200
     9.270   243.336     0.200
    12.933   315.789     0.200
    16.508   406.992     0.200
    18.176   447.984     0.200
     4.718   129.172     0.200
     5.747   151.617     0.200
     8.068   201.867     0.200
     7.997   208.570     0.200
     8.600   222.875     0.200
     8.676   224.445     0.200
     9.265   242.000     0.200
    11.303   281.328     0.200
    18.409   457.977     0.200
     5.169   142.746     0.200
     6.178   165.445     0.200
     6.876   179.695     0.200
     6.866   171.266     0.200
     7.606   200.873     0.200
     8.109   214.896     0.200
     8.409   213.256     0.200
     8.437   217.775     0.200
     8.569   226.426     0.200
     8.808   230.234     0.200
     9.427   245.148     0.200
    10.226   268.490     0.200
    11.639   290.295     0.200
    12.960   321.496     0.200
    18.169   450.941     0.200
     4.197   115.969     0.200
     5.463   146.859     0.200
     5.965   160.059     0.200
     6.660   173.949     0.200
     6.668   172.301     0.200
     7.993   211.176     0.200
     8.259   209.109     0.200
     8.529   222.992     0.200
     8.681   226.293     0.200
     9.286   246.758     0.200
    10.456   270.051     0.200
    11.492   287.309     0.200
    12.852   317.121     0.200
    18.253   451.074     0.200
     4.585   123.453     0.200
     5.600   147.574     0.200
     6.296   163.254     0.200
     6.680   167.645     0.200
     7.894   197.402     0.200
     8.774   229.727     0.200
     3.916   110.312     0.200
     4.649   128.141     0.200
     5.166   140.305     0.200
     5.717   153.141     0.200
     6.206   159.438     0.200
     6.403   168.508     0.200
     6.959   180.125     0.200
     7.499   192.078     0.200
     8.162   206.188     0.200
     8.301   214.250     0.200
     8.314   216.102     0.200
     8.314   218.703     0.200
     8.889   227.055     0.200
     8.895   232.172     0.200
     9.460   238.562     0.200
    11.398   283.523     0.200
    12.841   319.078     0.200
    18.241   452.438     0.200
     5.201   141.531     0.200
     5.725   152.145     0.200
     6.417   168.352     0.200
     6.431   165.621     0.200
     8.079   205.395     0.200
     8.099   205.895     0.200
     8.480   221.422     0.200
     8.529   220.215     0.200
     8.772   221.961     0.200
     9.559   240.902     0.200
    11.335   281.734     0.200
    12.742   316.883     0.200
    16.669   413.824     0.200
     3.489    99.297     0.200
     4.048   109.938     0.200
     4.785   130.656     0.200
     4.925   133.367     0.200
     5.304   141.547     0.200
     5.379   145.607     0.200
     5.852   161.258     0.200
     6.530   169.617     0.200
     7.163   184.848     0.200
     7.623   196.088     0.200
     8.327   213.723     0.200
     8.398   214.301     0.200
     8.398   218.381     0.200
     8.562   216.947     0.200
     9.670   241.117     0.200
    16.514   406.850     0.200
    18.191   448.807     0.200
    18.191   448.430     0.200
     4.339   113.008     0.200
     4.339   112.703     0.200
     5.256   137.445     0.200
     5.256   140.078     0.200
     5.606   144.734     0.200
     5.606   144.984     0.200
     5.785   151.625     0.200
     6.799   172.266     0.200
     6.799   171.945     0.200
     7.054   170.734     0.200
     7.410   186.797     0.200
     7.410   186.984     0.200
     7.660   187.562     0.200
     8.392   207.445     0.200
     8.392   207.992     0.200
     8.509   218.555     0.200
     8.712   223.695     0.200
     8.712   226.812     0.200
     9.867   243.383     0.200
    16.503   407.781     0.200
    18.169   448.398     0.200
     4.906   129.531     0.200
     5.360   142.750     0.200
     5.824   156.850     0.200
     7.144   182.650     0.200
     8.331   219.332     0.200
     8.396   222.369     0.200
     8.396   219.824     0.200
     2.617    77.406     0.200
     8.547   223.484     0.200
     8.719   225.219     0.200
     8.719   227.805     0.200
    14.686   358.156     0.200
    16.554   403.750     0.200
     3.595   104.633     0.200
     4.090   113.391     0.200
     4.831   132.648     0.200
     4.991   136.148     0.200
     5.461   142.930     0.200
     5.867   155.672     0.200
     6.055   164.977     0.200
     6.970   178.812     0.200
     7.538   198.992     0.200
     7.699   199.086     0.200
     7.734   200.281     0.200
     8.203   207.211     0.200
     8.202   208.156     0.200
     8.270   210.969     0.200
     8.293   210.188     0.200
     8.445   213.906     0.200
     8.428   211.477     0.200
     8.483   221.062     0.200
     8.608   220.273     0.200
     8.589   224.375     0.200
     8.589   225.906     0.200
     9.383   240.953     0.200
     9.626   243.273     0.200
     9.704   242.977     0.200
     9.927   254.383     0.200
    11.438   283.938     0.200
    16.601   411.977     0.200
    18.274   452.602     0.200
    19.207   481.383     0.200
     5.762   155.215     0.200
     6.234   167.027     0.200
     8.850   229.371     0.200
    12.215   300.527     0.200
    18.599   454.777     0.200
    18.724   463.863     0.200
     6.423   173.812     0.200
     8.440   219.156     0.200
     8.759   224.055     0.200
    13.464   333.410     0.200
    13.655   338.312     0.200
    15.101   371.512     0.200
    15.297   376.113     0.200
    16.294   408.805     0.200
    16.983   415.512     0.200
    16.987   416.113     0.200
    17.953   443.996     0.200
    18.877   469.160     0.200
    19.209   477.812     0.200
    20.425   506.910     0.200
     3.977   109.094     0.200
     4.714   130.992     0.200
     5.234   141.602     0.200
     5.331   144.172     0.200
     5.878   162.484     0.200
     6.430   171.406     0.200
     6.457   170.664     0.200
     6.971   183.414     0.200
     6.995   181.625     0.200
     7.416   190.273     0.200
     7.549   196.453     0.200
     7.989   204.055     0.200
     8.135   206.852     0.200
     8.142   206.594     0.200
     8.161   207.305     0.200
     8.237   209.133     0.200
     8.264   211.562     0.200
     8.348   212.570     0.200
     8.398   222.055     0.200
     8.450   218.070     0.200
     8.846   223.883     0.200
     9.519   241.992     0.200
     9.597   242.211     0.200
    12.340   306.086     0.200
    12.763   316.281     0.200
    12.971   321.781     0.200
    13.601   336.484     0.200
    14.164   349.383     0.200
    14.994   368.312     0.200
    15.265   390.305     0.200
    15.625   396.359     0.200
    15.951   398.781     0.200
    16.260   398.086     0.200
    16.596   409.164     0.200
    18.273   454.547     0.200
    18.273   450.562     0.200
    18.326   460.281     0.200
    19.654   492.180     0.200
     1.423    47.312     0.200
     2.328    65.758     0.200
     2.328    65.758     0.200
     1.423    47.312     0.200
     2.328    65.758     0.200
     3.970   110.848     0.200
     5.227   140.559     0.200
     5.326   144.918     0.200
     5.879   160.047     0.200
     6.449   169.270     0.200
     7.582   195.348     0.200
     8.127   206.246     0.200
     8.154   206.059     0.200
     8.484   217.977     0.200
     8.454   220.516     0.200
     9.511   240.207     0.200
    11.517   284.688     0.200
    12.333   304.746     0.200
    12.806   318.469     0.200
    12.756   314.848     0.200
    13.369   327.129     0.200
    17.067   417.047     0.200
    18.280   451.699     0.200
     1.427    45.707     0.200
     2.321    64.375     0.200
     2.321    64.434     0.200
     3.993   110.836     0.200
     4.730   131.564     0.200
     4.874   133.766     0.200
     5.250   142.516     0.200
     5.879   161.234     0.200
     6.473   169.824     0.200
     7.451   196.246     0.200
     7.565   195.455     0.200
     7.605   195.545     0.200
     7.655   203.666     0.200
     8.177   204.975     0.200
     8.343   210.055     0.200
     8.388   218.842     0.200
     8.507   216.904     0.200
     8.445   216.521     0.200
     8.445   220.686     0.200
    10.965   283.053     0.200
    11.539   285.885     0.200
    12.356   306.336     0.200
    12.827   318.395     0.200
    13.580   344.217     0.200
    16.582   415.768     0.200
    18.259   451.178     0.200
    18.259   454.057     0.200
    18.317   454.125     0.200
    18.578   465.455     0.200
     1.410    45.805     0.200
     2.344    64.816     0.200
     3.997   109.729     0.200
     4.735   130.759     0.200
     5.255   142.029     0.200
     5.349   145.179     0.200
     5.788   156.369     0.200
     5.880   161.719     0.200
     6.130   159.438     0.200
     6.477   171.369     0.200
     7.759   199.979     0.200
     8.181   206.699     0.200
     8.386   222.475     0.200
     8.445   219.263     0.200
     8.445   218.489     0.200
     8.445   222.965     0.200
     8.863   226.459     0.200
     9.539   238.129     0.200
    10.418   261.789     0.200
    12.361   308.019     0.200
    12.784   318.419     0.200
    12.991   324.119     0.200
    13.622   338.619     0.200
    14.184   352.619     0.200
    14.417   357.019     0.200
    16.578   412.852     0.200
    18.255   452.669     0.200
    18.255   455.406     0.200
     2.349    67.020     0.200
     4.737   128.234     0.200
     5.450   146.164     0.200
     5.910   161.430     0.200
     6.131   153.000     0.200
     6.477   167.500     0.200
     8.155   208.227     0.200
     8.403   213.953     0.200
     8.411   217.109     0.200
     8.474   220.648     0.200
     8.474   220.445     0.200
     8.514   213.836     0.200
    12.362   306.930     0.200
    13.605   340.461     0.200
    15.985   403.430     0.200
    16.595   411.781     0.200
    18.271   450.633     0.200
    18.271   448.344     0.200
     3.443   100.296     0.200
     3.971   109.076     0.200
     4.043   111.436     0.200
     4.710   128.216     0.200
     5.230   138.996     0.200
     5.343   143.446     0.200
     5.915   161.446     0.200
     6.448   168.236     0.200
     7.582   194.486     0.200
     8.118   202.806     0.200
     8.487   215.686     0.200
     8.435   213.625     0.200
     8.490   217.565     0.200
     8.490   219.991     0.200
     9.512   238.396     0.200
     9.590   238.476     0.200
    11.003   283.859     0.200
    12.334   305.346     0.200
    13.597   334.646     0.200
    13.627   343.674     0.200
    14.393   353.046     0.200
    16.624   411.746     0.200
    18.300   453.146     0.200
    18.300   450.987     0.200
     2.324    65.214     0.200
     3.460    99.246     0.200
     3.988   110.828     0.200
     4.726   131.496     0.200
     5.247   141.719     0.200
     5.434   147.438     0.200
     5.920   160.508     0.200
     6.436   168.316     0.200
     6.465   169.188     0.200
     8.428   218.441     0.200
     8.428   223.906     0.200
     8.489   214.352     0.200
     8.489   222.590     0.200
    12.351   305.207     0.200
    16.611   408.957     0.200
    18.287   448.258     0.200
    18.287   453.484     0.200
     4.047   113.934     0.200
     4.788   134.371     0.200
     5.311   145.602     0.200
     5.407   143.164     0.200
     6.174   163.523     0.200
     6.076   164.023     0.200
     6.515   172.301     0.200
     7.601   197.852     0.200
     8.047   206.871     0.200
     8.218   209.961     0.200
     8.393   213.883     0.200
     8.565   221.164     0.200
     8.783   222.051     0.200
     8.626   219.168     0.200
     8.626   222.102     0.200
     9.581   244.191     0.200
    10.312   256.523     0.200
    11.161   285.113     0.200
    11.385   285.512     0.200
    12.406   306.023     0.200
    12.768   315.051     0.200
    13.400   332.523     0.200
    14.239   349.422     0.200
    14.473   354.824     0.200
    18.502   459.844     0.200
    18.328   454.656     0.200
    19.581   490.023     0.200
    20.125   502.422     0.200
    20.565   510.922     0.200
     8.853   227.620     0.200
     8.864   223.170     0.200
     8.864   226.265     0.200
    17.028   425.466     0.200
     5.899   154.852     0.200
     8.422   221.969     0.200
     3.880   112.547     0.200
     5.745   153.188     0.200
     4.317   117.828     0.200
     2.929    82.875     0.200
     4.317   117.828     0.200
     4.317   117.828     0.200
     3.878   106.094     0.200
     4.317   117.828     0.200
     5.745   153.188     0.200
     4.153   114.305     0.200
     5.737   153.002     0.200
     4.309   117.658     0.200
     4.145   114.109     0.200
     4.145   114.109     0.200
     4.309   117.621     0.200
     2.921    82.668     0.200
     4.444   119.615     0.200
     4.309   117.621     0.200
     2.921    82.668     0.200
     4.309   117.621     0.200
     4.444   119.615     0.200
     4.444   119.615     0.200
     5.737   152.980     0.200
     5.737   152.980     0.200
     4.145   114.109     0.200
     5.737   152.980     0.200
     4.145   114.109     0.200
     4.145   114.109     0.200
     4.336   118.273     0.200
     4.336   118.273     0.200
     5.760   153.520     0.200
     4.156   114.350     0.200
     4.336   118.273     0.200
     5.760   153.520     0.200
     4.510   121.254     0.200
     3.538    99.854     0.200
     3.538    99.854     0.200
     3.538    99.854     0.200
     4.156   114.350     0.200
     5.760   153.520     0.200
     4.336   118.273     0.200
     4.336   118.273     0.200
     4.156   114.350     0.200
     4.336   118.273     0.200
     2.970    83.850     0.200
     4.510   121.254     0.200
     4.168   120.492     0.200
     4.341   118.400     0.200
     8.495   221.355     0.200
     4.373   119.125     0.200
     4.373   119.125     0.200
     4.373   119.125     0.200
     5.791   154.266     0.200
     5.791   154.266     0.200
     5.791   154.266     0.200
     5.791   154.266     0.200
     4.351   118.781     0.200
     4.351   118.797     0.200
     4.351   118.828     0.200
     5.777   153.992     0.200
     5.777   153.992     0.200
     4.351   118.656     0.200
     8.469   224.701     0.200
     2.937    83.078     0.200
     4.319   118.031     0.200
     4.319   118.054     0.200
     3.889   106.335     0.200
     4.150   114.394     0.200
     4.150   114.403     0.200
     4.345   118.484     0.200
     4.345   118.505     0.200
     5.769   153.752     0.200
     4.165   114.586     0.200
     4.345   118.515     0.200
     5.769   153.763     0.200
     4.517   121.646     0.200
     5.769   153.591     0.200
     5.769   153.603     0.200
     4.345   118.513     0.200
     4.345   118.489     0.200
     4.165   114.564     0.200
     4.345   118.489     0.200
     4.345   118.489     0.200
     4.165   114.564     0.200
     2.978    84.048     0.200
     3.546   100.045     0.200
     4.303   117.404     0.200
     5.731   152.811     0.200
     4.138   113.982     0.200
     4.303   117.373     0.200
     2.916    82.424     0.200
     4.442   119.369     0.200
     4.303   117.381     0.200
     2.916    82.432     0.200
     4.303   117.393     0.200
     4.442   119.389     0.200
     4.442   119.389     0.200
     5.731   152.771     0.200
     5.731   152.771     0.200
     4.138   113.908     0.200
     5.731   152.791     0.200
     4.138   113.928     0.200
     4.138   113.938     0.200
     3.939   116.566     0.200
     4.183   119.477     0.200
     5.925   156.555     0.200
     3.561   100.091     0.200
     3.561   100.101     0.200
     3.561   100.112     0.200
     4.174   114.638     0.200
     5.774   153.827     0.200
     4.349   118.581     0.200
     4.349   118.581     0.200
     4.174   114.667     0.200
     4.349   118.591     0.200
     2.974    84.227     0.200
     4.505   121.642     0.200
     4.349   118.745     0.200
     4.349   118.576     0.200
     4.174   114.656     0.200
     4.349   118.586     0.200
     4.349   118.586     0.200
     4.174   114.665     0.200
     2.974    84.150     0.200
     3.561   100.163     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     8.132   235.047     0.200
     3.284   102.914     0.200
     5.831   180.914     0.200
     5.670   168.843     0.200
     3.422   105.395     0.200
     5.868   174.395     0.200
     1.033    35.826     0.200
     3.327   102.525     0.200
     3.873   115.805     0.200
     4.259   125.805     0.200
     8.270   253.805     0.200
     4.647   140.113     0.200
     1.463    49.211     0.200
     3.304   101.992     0.200
     4.350   130.898     0.200
     4.610   141.398     0.200
     1.437    48.234     0.200
     2.501    77.234     0.200
     8.264   240.234     0.200
     5.725   169.773     0.200
     1.455    50.941     0.200
     2.471    77.641     0.200
     2.356    74.117     0.200
     2.105    68.273     0.200
     1.236    41.234     0.200
     4.056   123.234     0.200
     4.062   120.945     0.200
     4.764   141.805     0.200
     1.140    38.383     0.200
     3.535   105.484     0.200
     1.159    39.992     0.200
     1.266    43.953     0.200
     1.053    36.215     0.200
     3.479   102.834     0.200
     1.645    54.525     0.200
     1.494    48.938     0.200
     1.031    31.906     0.200
     1.314    40.242     0.200
     1.468    47.500     0.200
     0.957    29.625     0.200
     1.040    32.062     0.200
     0.640    20.340     0.200
     1.423    44.250     0.200
     1.427    43.746     0.200
     3.429   103.289     0.200
     3.450   101.205     0.200
     3.454   103.149     0.200
     1.389    42.703     0.200
     2.351    71.781     0.200
     1.406    42.885     0.200
     2.324    69.616     0.200
     1.391    42.398     0.200
     1.267    38.973     0.200
     3.565   105.812     0.200
     1.379    46.398     0.200
     1.379    45.766     0.200
     1.329    46.109     0.200
     1.331    45.487     0.200
     1.259    43.703     0.200
     1.390    46.172     0.200
     1.292    43.572     0.200
     1.300    44.359     0.200
     1.310    45.790     0.200
     1.259    44.040     0.200
     1.277    42.395     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     2.627    82.117     0.200
     5.751   181.117     0.200
     2.817    89.047     0.200
     8.132   261.047     0.200
     4.282   134.914     0.200
     2.930    92.843     0.200
     3.241   104.843     0.200
     5.670   187.843     0.200
     3.422   113.395     0.200
     2.982    95.826     0.200
     2.993    94.504     0.200
     3.013    96.914     0.200
     2.956    95.211     0.200
     3.284   106.211     0.200
     3.842   121.211     0.200
     6.558   202.211     0.200
     2.980    93.492     0.200
     2.967    95.102     0.200
     3.221   108.805     0.200
     8.280   268.102     0.200
     2.929    89.938     0.200
     3.022    94.273     0.200
     3.532   109.273     0.200
     2.756    87.641     0.200
     2.626    82.844     0.200
     5.740   176.445     0.200
     3.649   114.652     0.200
     3.875   121.453     0.200
     5.354   164.453     0.200
     3.629   113.529     0.200
     8.957   285.523     0.200
     8.962   285.633     0.200
     4.505   139.059     0.200
     4.546   145.344     0.200
     4.215   135.334     0.200
     9.059   257.266     0.200
     8.676   275.343     0.200
    10.507   343.091     0.200
    15.158   490.550     0.200
    17.115   551.945     0.200
     3.988   124.816     0.200
     8.428   212.117     0.200
     8.589   270.672     0.200
    15.060   465.328     0.200
    17.031   529.180     0.200
     4.211   133.660     0.200
     4.673   148.672     0.200
     5.593   174.543     0.200
     5.941   182.312     0.200
     8.450   267.000     0.200
    14.893   469.625     0.200
    16.896   533.898     0.200
    18.273   583.859     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     8.132   235.047     0.200
     3.284   102.914     0.200
     5.831   180.914     0.200
     5.670   168.843     0.200
     3.422   105.395     0.200
     5.868   174.395     0.200
     1.033    35.826     0.200
     3.327   102.525     0.200
     3.873   115.805     0.200
     4.259   125.805     0.200
     8.270   253.805     0.200
     4.647   140.113     0.200
     1.463    49.211     0.200
     3.304   101.992     0.200
     4.350   130.898     0.200
     4.610   141.398     0.200
     1.437    48.234     0.200
     2.501    77.234     0.200
     8.264   240.234     0.200
     5.725   169.773     0.200
     1.455    50.941     0.200
     2.471    77.641     0.200
     2.356    74.117     0.200
     2.105    68.273     0.200
     1.236    41.234     0.200
     4.056   123.234     0.200
     4.062   120.945     0.200
     4.764   141.805     0.200
     1.140    38.383     0.200
     3.535   105.484     0.200
     1.159    39.992     0.200
     1.266    43.953     0.200
     1.053    36.215     0.200
     3.479   102.834     0.200
     1.645    54.525     0.200
     1.494    48.938     0.200
     1.031    31.906     0.200
     1.314    40.242     0.200
     1.468    47.500     0.200
     0.957    29.625     0.200
     1.040    32.062     0.200
     0.640    20.340     0.200
     1.423    44.250     0.200
     1.427    43.746     0.200
     3.429   103.289     0.200
     3.450   101.205     0.200
     3.454   103.149     0.200
     1.389    42.703     0.200
     2.351    71.781     0.200
     1.406    42.885     0.200
     2.324    69.616     0.200
     1.391    42.398     0.200
     1.267    38.973     0.200
     3.565   105.812     0.200
     1.379    46.398     0.200
     1.379    45.766     0.200
     1.329    46.109     0.200
     1.331    45.487     0.200
     1.259    43.703     0.200
     1.390    46.172     0.200
     1.292    43.572     0.200
     1.300    44.359     0.200
     1.310    45.790     0.200
     1.259    44.040     0.200
     1.277    42.395     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
