#!/bin/bash
gmt begin kunar4.14_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/2.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source kunar4.14'
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.809    -0.033     0.200
     1.459    -0.872     0.200
     0.725    -0.298     0.200
     0.912    -0.054     0.200
     0.995    -0.244     0.200
     1.136    -0.960     0.200
     1.774    -0.886     0.200
     1.235    -0.197     0.200
     1.033    -0.455     0.200
     1.456     0.466     0.200
     1.830     1.580     0.200
     1.492     0.775     0.200
     1.846     1.625     0.200
     1.463     0.606     0.200
     1.855     1.609     0.200
     1.077    -0.452     0.200
     1.460     0.327     0.200
     1.840     1.537     0.200
     1.461     0.443     0.200
     1.437     0.522     0.200
     1.850     1.569     0.200
     1.229     0.857     0.200
     1.575     1.639     0.200
     1.865     0.877     0.200
     1.455     0.217     0.200
     1.368     0.726     0.200
     1.243     0.553     0.200
     1.400     0.514     0.200
     1.510     0.706     0.200
     1.289     1.032     0.200
     0.758     0.711     0.200
     1.689     0.774     0.200
     1.274     0.631     0.200
     1.339     0.990     0.200
     1.257     1.011     0.200
     1.885    -1.091     0.200
     1.240     0.501     0.200
     1.935     1.417     0.200
     1.236     0.937     0.200
     1.541     0.224     0.200
     1.219     0.422     0.200
     1.201     0.656     0.200
     1.199     0.785     0.200
     1.140     0.417     0.200
     1.647     0.830     0.200
     1.838     0.221     0.200
     1.159     0.380     0.200
     1.656     1.307     0.200
     1.835     0.889     0.200
     1.346     0.794     0.200
     1.275     0.019     0.200
     1.205     0.560     0.200
     1.343     1.534     0.200
     1.266     0.583     0.200
     1.053     0.961     0.200
     1.477     0.286     0.200
     1.742     0.670     0.200
     0.868    -0.632     0.200
     1.623     0.795     0.200
     0.887    -0.588     0.200
     1.609     0.954     0.200
     0.829     1.056     0.200
     0.859    -0.625     0.200
     1.152    -0.689     0.200
     1.152     0.111     0.200
     1.418     0.823     0.200
     1.149    -0.759     0.200
     1.405     0.949     0.200
     1.042     0.010     0.200
     1.513     0.429     0.200
     1.576    -0.676     0.200
     1.068    -1.858     0.200
     1.031    -0.784     0.200
     1.314    -1.058     0.200
     0.839     0.040     0.200
     1.101    -1.228     0.200
     1.468     0.548     0.200
     1.402    -0.456     0.200
     1.562    -0.255     0.200
     1.413    -0.506     0.200
     1.319     0.598     0.200
     1.389    -0.025     0.200
     0.957    -1.028     0.200
     1.406     0.396     0.200
     1.040    -0.821     0.200
     1.244    -0.348     0.200
     1.244     0.191     0.200
     1.369    -1.043     0.200
     1.369    -0.742     0.200
     0.573    -0.610     0.200
     0.640    -0.560     0.200
     0.640    -0.669     0.200
     1.423     0.427     0.200
     1.423     0.130     0.200
     1.427    -0.825     0.200
     1.339    -0.150     0.200
     1.410    -0.345     0.200
     1.406    -0.327     0.200
     1.389     0.237     0.200
     1.406    -0.217     0.200
     1.318     0.012     0.200
     1.391    -0.376     0.200
     1.391     0.042     0.200
     1.193    -0.064     0.200
     1.267    -0.302     0.200
     1.267    -0.404     0.200
     1.379     0.109     0.200
     1.379    -0.243     0.200
     1.404     0.549     0.200
     1.329     0.070     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     1.871    -0.554     0.200
     1.717     1.004     0.200
     1.993    -0.316     0.200
     1.460    -2.763     0.200
     1.990    -0.553     0.200
     1.729     1.021     0.200
     1.821     0.676     0.200
     1.645     0.211     0.200
     1.494     0.096     0.200
     1.389    -1.913     0.200
     1.427    -2.006     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,yellow1 << EOF
     1.033     1.246     0.200
     1.463     1.637     0.200
     1.437     2.505     0.200
     1.455     2.073     0.200
     1.236     0.698     0.200
     1.140     1.147     0.200
     1.159     1.274     0.200
     1.266     1.750     0.200
     1.053     1.856     0.200
     1.645     0.802     0.200
     1.494     1.503     0.200
     1.031    -1.963     0.200
     1.314    -1.951     0.200
     1.468     0.107     0.200
     0.957    -2.071     0.200
     1.040    -2.006     0.200
     0.640    -1.908     0.200
     1.423    -1.872     0.200
     1.427    -1.741     0.200
     1.389    -1.955     0.200
     1.406    -1.977     0.200
     1.391    -2.018     0.200
     1.267    -1.924     0.200
     1.379     0.813     0.200
     1.379     0.180     0.200
     1.329     1.065     0.200
     1.331     0.404     0.200
     1.259     0.740     0.200
     1.390    -0.670     0.200
     1.292    -0.385     0.200
     1.300     0.474     0.200
     1.310     1.328     0.200
     1.259     1.069     0.200
     1.277    -1.101     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,yellow2 << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,yellow3 << EOF
     0.829    -0.159     0.200
     1.423    -5.040     0.200
     1.423    -5.040     0.200
     1.427    -5.340     0.200
     1.410    -5.376     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.186
 2.00    0.186
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.463
 2.00   -0.463
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,yellow1,- << EOF
 0.00   -0.0
 2.00   -0.0
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,yellow3,- << EOF
 0.00   -4.2
 2.00   -4.2
EOF
# Indirect calibration
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     9.000 Indirect calibration: shifted hypocenters used
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-2.0)
     0.050     7.000   Pg = red x; average =   0.2 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.5 (solid green line)
    -6.500     0.050   No S phases used for the hypocentroid
     0.050    -7.500   Sg = yellow1 circles; average =  -0.0 (dashed yellow1 line)
     0.050    -9.500   Sn = yellow3 circles; average =  -4.2 (dashed yellow3 line)
EOF
gmt end
