#!/bin/bash
gmt begin kunar4.14_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic kunar4.14'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.471
   135.500     1.553
   136.000     1.638
   136.500     1.726
   137.000     1.818
   137.500     1.913
   138.000     2.011
   138.500     2.113
   139.000     2.218
   139.500     2.327
   140.000     2.439
   140.500     2.556
   141.000     2.677
   141.500     2.803
   142.000     2.933
   142.500     3.068
   143.000     3.208
   143.500     3.354
   144.000     3.504
   144.500     3.661
   145.000     3.823
   145.500     3.991
   146.000     4.166
   146.500     4.348
   147.000     4.536
   147.500     4.732
   148.000     4.935
   148.500     5.146
   149.000     5.365
   149.500     5.594
   150.000     5.832
   150.500     6.080
   151.000     6.339
   151.500     6.607
   152.000     6.886
   152.500     7.175
   153.000     7.474
   153.500     7.783
   154.000     8.103
   154.500     8.435
   155.000     8.777
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.677
   145.500     0.288
   146.000     1.315
   146.500     2.385
   147.000     3.490
   147.500     4.624
   148.000     5.786
   148.500     6.972
   149.000     8.182
   149.500     9.415
   150.000    10.671
   150.500    11.947
   151.000    13.244
   151.500    14.560
   152.000    15.895
   152.500    17.249
   153.000    18.621
   153.500    20.010
   154.000    21.417
   154.500    22.842
   155.000    24.283
   155.500    25.742
   156.000    27.217
   156.500    28.710
   157.000    30.219
   157.500    31.744
   158.000    33.286
   158.500    34.845
   159.000    36.421
   159.500    38.012
   160.000    39.620
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.681
   145.500     0.084
   146.000     0.776
   146.500     1.417
   147.000     2.016
   147.500     2.575
   148.000     3.099
   148.500     3.591
   149.000     4.057
   149.500     4.503
   150.000     4.933
   150.500     5.350
   151.000     5.756
   151.500     6.153
   152.000     6.542
   152.500     6.923
   153.000     7.298
   153.500     7.670
   154.000     8.038
   154.500     8.405
   155.000     8.769
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   139.161     1.502     0.200
   141.688    -1.028     0.200
   147.157     1.879     0.200
   148.093     2.827     0.200
   148.189     2.670     0.200
   140.730    -0.896     0.200
   140.931     1.241     0.200
   143.552    -0.427     0.200
   144.324     2.224     0.200
   144.500     0.316     0.200
   145.423     0.426     0.200
   145.742     1.380     0.200
   145.860     1.578     0.200
   146.376     2.302     0.200
   138.826     2.066     0.200
   135.024     1.551     0.200
   135.064     1.398     0.200
   138.484     1.694     0.200
   141.365    -2.336     0.200
   146.285     1.208     0.200
   148.222     2.837     0.200
   138.464     2.088     0.200
   142.607     2.254     0.200
   145.605     1.052     0.200
   134.919    -0.085     0.200
   138.951     0.940     0.200
   138.951     0.588     0.200
   146.372     1.036     0.200
   148.525    -0.323     0.200
   148.735     1.287     0.200
   148.987     1.271     0.200
   148.987     2.060     0.200
   142.146     2.275     0.200
   142.920    -1.075     0.200
   144.561     2.329     0.200
   147.514     1.912     0.200
   143.289     0.422     0.200
   151.197     1.342     0.200
   138.931     1.564     0.200
   141.154     2.046     0.200
   143.246    -0.268     0.200
   146.896     1.983     0.200
   148.035     1.339     0.200
   138.930     1.315     0.200
   144.516     1.173     0.200
   146.896     0.436     0.200
   147.885     0.781     0.200
   142.841     0.123     0.200
   142.882     0.301     0.200
   142.882     0.075     0.200
   144.493     1.327     0.200
   142.947     0.037     0.200
   142.987    -0.136     0.200
   148.931     0.725     0.200
   149.843    -0.683     0.200
   149.850     0.075     0.200
   151.111     1.240     0.200
   144.473     0.839     0.200
   147.983    -0.079     0.200
   148.011     1.383     0.200
   148.904     1.546     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   146.655     3.279     0.200
   145.886     1.524     0.200
   146.422     1.914     0.200
   147.758     3.180     0.200
   147.837     4.448     0.200
   147.920     4.212     0.200
   148.018     4.252     0.200
   147.542     4.446     0.200
   147.634     4.594     0.200
   147.790     4.336     0.200
   147.812     3.600     0.200
   147.873     4.598     0.200
   147.971     5.037     0.200
   148.046     3.914     0.200
   148.142     3.756     0.200
   147.818     4.892     0.200
   148.843     5.605     0.200
   149.077     5.047     0.200
   149.354     5.388     0.200
   145.024    -0.612     0.200
   148.217     3.571     0.200
   148.217     4.766     0.200
   148.171     3.767     0.200
   148.687     5.433     0.200
   148.307     4.525     0.200
   148.987     5.146     0.200
   149.906     6.192     0.200
   148.978     5.330     0.200
   145.680     1.527     0.200
   148.975     5.518     0.200
   148.975     5.278     0.200
   146.943     3.684     0.200
   148.115     4.021     0.200
   146.484     2.386     0.200
   146.862     2.977     0.200
   146.943     3.395     0.200
   147.422     2.604     0.200
   147.735     3.968     0.200
   148.057     3.372     0.200
   147.826     4.097     0.200
   149.599     6.086     0.200
   147.437     3.340     0.200
   147.729     4.032     0.200
   148.035     3.577     0.200
   146.397     2.582     0.200
   146.870     2.976     0.200
   147.729     2.661     0.200
   148.045     4.802     0.200
   148.946     4.732     0.200
   147.630     4.063     0.200
   147.983     4.550     0.200
   148.447     4.949     0.200
   148.904     5.617     0.200
   149.814     5.198     0.200
   150.001     4.903     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   155.043    28.328     0.200
   145.533     2.703     0.200
   146.043     2.714     0.200
   145.417     1.182     0.200
   146.651     4.393     0.200
   146.918     4.008     0.200
   146.870     4.116     0.200
   147.445     5.019     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   139.234     4.929     0.200
   138.873     3.471     0.200
   147.589     4.961     0.200
   137.978     6.621     0.200
   138.700     4.296     0.200
   138.826     3.065     0.200
   147.711     4.966     0.200
   148.592     6.020     0.200
   138.700     3.297     0.200
   147.796     5.326     0.200
   147.977     5.528     0.200
   148.052     5.405     0.200
   148.148     5.247     0.200
   148.598     5.710     0.200
   138.925     4.475     0.200
   135.004     2.365     0.200
   139.037     3.316     0.200
   149.061     6.324     0.200
   149.125     6.341     0.200
   138.966     2.895     0.200
   148.724     6.176     0.200
   148.774     5.943     0.200
   138.484     2.319     0.200
   142.298     3.263     0.200
   138.499     2.268     0.200
   138.464     2.520     0.200
   138.737     2.421     0.200
   138.737     3.326     0.200
   148.687     5.733     0.200
   148.586     6.367     0.200
   148.766     6.543     0.200
   148.338     5.724     0.200
   138.951     3.276     0.200
   148.087     5.363     0.200
   148.947     5.782     0.200
   148.854     5.795     0.200
   142.902     6.761     0.200
   146.056     4.463     0.200
   147.816     6.083     0.200
   149.864     6.447     0.200
   151.197     7.272     0.200
   148.065     5.392     0.200
   142.060     3.058     0.200
   145.985     4.035     0.200
   149.775     6.662     0.200
   136.882     2.491     0.200
   145.990     4.018     0.200
   146.876     6.645     0.200
   149.794     6.575     0.200
   138.912     3.321     0.200
EOF
# Indirect calibration
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000   -10.000 Indirect calibration: shifted hypocenters used
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
