#!/bin/bash
gmt begin kunar4.14_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P kunar4.14'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.695
    79.000     8.521
    80.000     7.431
    81.000     6.427
    82.000     5.510
    83.000     4.676
    84.000     3.926
    85.000     3.264
    86.000     2.687
    87.000     2.188
    88.000     1.793
    89.000     1.494
    90.000     1.237
    91.000     1.010
    92.000     0.810
    93.000     0.628
    94.000     0.463
    95.000     0.318
    96.000     0.198
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    20.260    -0.964     0.200
    21.617     3.373     0.200
    23.050     2.116     0.200
    26.697     5.291     0.200
    29.673     0.723     0.200
    30.930     0.615     0.200
    33.391     2.019     0.200
    37.856     0.675     0.200
    38.892     0.959     0.200
    39.798     0.392     0.200
    41.203     0.774     0.200
    42.352     0.371     0.200
    43.548     0.682     0.200
    44.221     1.270     0.200
    44.870     0.088     0.200
    45.129     1.030     0.200
    45.563     0.587     0.200
    46.853     1.434     0.200
    51.224     2.934     0.200
    53.555     0.638     0.200
    55.383     0.344     0.200
    57.711     1.779     0.200
    66.053    -1.360     0.200
    70.305    -0.036     0.200
    76.040    -0.929     0.200
    89.862     0.536     0.200
    92.615     1.760     0.200
    17.553     3.845     0.200
    18.577     0.515     0.200
    19.491     0.493     0.200
    20.063     2.250     0.200
    20.229     2.440     0.200
    21.537     3.303     0.200
    21.869     3.747     0.200
    22.150    -2.253     0.200
    23.164     0.994     0.200
    25.128     2.577     0.200
    29.581     0.621     0.200
    29.744     2.183     0.200
    29.736     2.248     0.200
    30.488     3.599     0.200
    30.956     1.467     0.200
    33.300     2.296     0.200
    33.348     2.472     0.200
    33.644     0.898     0.200
    34.389     0.426     0.200
    34.517     1.316     0.200
    34.999     3.152     0.200
    36.168     3.112     0.200
    36.282     1.140     0.200
    37.112     2.061     0.200
    38.156     2.230     0.200
    39.185     0.591     0.200
    39.217     1.327     0.200
    39.313     0.622     0.200
    39.489     2.254     0.200
    39.766     1.745     0.200
    40.451     0.559     0.200
    41.280     0.927     0.200
    41.607     0.547     0.200
    42.130     1.872     0.200
    42.241     0.257     0.200
    42.379    -0.263     0.200
    42.393     1.526     0.200
    43.246     1.805     0.200
    43.314     3.654     0.200
    43.622     0.572     0.200
    43.906     1.786     0.200
    44.061     1.145     0.200
    44.197     1.555     0.200
    44.602     1.414     0.200
    44.830     0.793     0.200
    45.096     1.878     0.200
    45.407     2.905     0.200
    45.512    -1.924     0.200
    45.500     1.169     0.200
    45.530     1.431     0.200
    46.275     2.052     0.200
    46.371     1.903     0.200
    47.334     1.767     0.200
    47.301     3.026     0.200
    47.476    -1.337     0.200
    47.957     1.925     0.200
    47.778     1.818     0.200
    47.881     2.018     0.200
    48.073     2.635     0.200
    48.680     1.847     0.200
    48.706     3.149     0.200
    48.885     1.981     0.200
    49.009     1.824     0.200
    49.158     3.682     0.200
    49.623     1.837     0.200
    50.172     0.756     0.200
    50.302     0.873     0.200
    50.585     1.133     0.200
    50.861     1.350     0.200
    52.381     0.392     0.200
    52.923     1.379     0.200
    53.125     1.181     0.200
    53.510     1.552     0.200
    53.453     1.471     0.200
    53.458     0.539     0.200
    53.487     0.727     0.200
    53.773     1.130     0.200
    53.997     0.492     0.200
    54.556     3.917     0.200
    54.707     1.222     0.200
    54.904     1.191     0.200
    55.329     0.526     0.200
    56.070     2.505     0.200
    56.885    -0.802     0.200
    57.262     3.032     0.200
    58.067     1.368     0.200
    58.142     1.544     0.200
    58.644     0.333     0.200
    59.565    -0.049     0.200
    60.591     1.917     0.200
    60.782    -0.384     0.200
    61.381     0.547     0.200
    62.187     1.620     0.200
    62.507     1.979     0.200
    63.298     1.716     0.200
    63.207    -0.685     0.200
    64.514     0.709     0.200
    66.791     1.007     0.200
    67.707     0.202     0.200
    68.639     0.353     0.200
    69.104     0.461     0.200
    70.454     0.148     0.200
    70.852     0.720     0.200
    72.442     1.147     0.200
    73.388     2.239     0.200
    73.677    -0.162     0.200
    74.836     0.182     0.200
    75.681     0.220     0.200
    76.165    -0.148     0.200
    76.451     1.833     0.200
    76.217    -0.838     0.200
    76.220    -0.058     0.200
    76.697    -0.562     0.200
    77.296     0.865     0.200
    77.662    -0.976     0.200
    77.859    -0.374     0.200
    78.701    -0.737     0.200
    78.789     0.281     0.200
    78.951    -0.108     0.200
    80.742    -0.815     0.200
    81.198     0.753     0.200
    80.960    -0.080     0.200
    83.043    -0.926     0.200
    85.938     1.021     0.200
    89.949     1.228     0.200
    92.344     0.109     0.200
    93.201     2.154     0.200
    95.812     0.185     0.200
    16.362     4.915     0.200
    18.555    -1.219     0.200
    20.288     0.819     0.200
    20.298     0.707     0.200
    21.855     1.904     0.200
    23.279    -0.215     0.200
    23.343     1.607     0.200
    25.117     2.634     0.200
    27.434     2.693     0.200
    28.239     2.702     0.200
    35.596     2.954     0.200
    36.782     1.013     0.200
    38.230     1.848     0.200
    39.222     0.623     0.200
    39.393    -0.210     0.200
    39.581     1.120     0.200
    39.822     1.214     0.200
    41.303     0.868     0.200
    42.273     0.433     0.200
    42.419    -0.253     0.200
    42.411     0.908     0.200
    43.302     2.179     0.200
    43.666     1.947     0.200
    43.646     0.708     0.200
    44.251     1.049     0.200
    44.412     0.256     0.200
    44.851     0.553     0.200
    45.151     0.866     0.200
    47.572    -0.165     0.200
    48.113     1.240     0.200
    48.182     1.913     0.200
    48.453     1.020     0.200
    48.588     1.276     0.200
    49.678     2.330     0.200
    50.620     0.985     0.200
    50.643     1.110     0.200
    51.958     1.651     0.200
    52.426     1.168     0.200
    52.661     2.129     0.200
    52.979     0.676     0.200
    53.111     1.605     0.200
    53.182     0.882     0.200
    53.467     1.085     0.200
    53.510     0.767     0.200
    53.505     0.603     0.200
    53.925     0.924     0.200
    55.698     0.078     0.200
    56.397     0.075     0.200
    57.640     0.870     0.200
    58.207     1.890     0.200
    58.666     1.086     0.200
    60.780     0.530     0.200
    61.451     1.973     0.200
    63.406     1.900     0.200
    65.401    -0.166     0.200
    67.770     0.696     0.200
    69.100    -0.028     0.200
    70.448     0.068     0.200
    72.313    -0.002     0.200
    74.605     0.200     0.200
    75.297     0.300     0.200
    75.657    -0.765     0.200
    76.184    -0.673     0.200
    76.187    -0.490     0.200
    76.719     0.196     0.200
    77.342    -1.612     0.200
    78.666    -1.364     0.200
    80.739    -0.426     0.200
    81.123     0.223     0.200
    83.009     0.222     0.200
    83.029     0.020     0.200
    83.680     0.662     0.200
    86.016     0.401     0.200
    90.691    -0.367     0.200
    20.650    -0.182     0.200
    21.939     1.438     0.200
    22.040    -0.348     0.200
    27.739     1.887     0.200
    28.561     2.564     0.200
    36.148     0.153     0.200
    39.029     0.759     0.200
    42.104     0.236     0.200
    42.211     0.064     0.200
    44.204     0.551     0.200
    56.327     0.306     0.200
    63.101     0.845     0.200
    67.464     0.555     0.200
    69.161     0.125     0.200
    75.763     0.560     0.200
    76.335    -0.703     0.200
    76.337    -0.716     0.200
    14.077    10.831     0.200
    16.803     3.313     0.200
    17.796     2.222     0.200
    20.189     1.217     0.200
    21.183    -0.446     0.200
    21.582    -0.437     0.200
    21.727     6.603     0.200
    21.727     7.003     0.200
    22.018     2.493     0.200
    22.640     3.864     0.200
    23.000     2.056     0.200
    23.119     1.796     0.200
    25.288     2.428     0.200
    26.579     2.642     0.200
    27.132     2.758     0.200
    27.938     2.537     0.200
    29.216     3.161     0.200
    29.426     2.099     0.200
    33.891     1.142     0.200
    35.773    -0.205     0.200
    36.402     2.208     0.200
    36.480     0.743     0.200
    36.480     1.243     0.200
    38.834     1.423     0.200
    39.144     1.230     0.200
    41.047    -0.468     0.200
    41.174     3.185     0.200
    44.347     0.336     0.200
    44.605     1.073     0.200
    45.157    -0.820     0.200
    45.677     0.158     0.200
    46.049     1.119     0.200
    46.049     1.319     0.200
    47.150    -0.520     0.200
    48.865     4.507     0.200
    53.631     1.444     0.200
    56.231     0.628     0.200
    57.227     0.649     0.200
    60.954     1.714     0.200
    63.708     1.271     0.200
    64.865     0.683     0.200
    68.072     1.164     0.200
    68.861    -0.772     0.200
    74.813     0.468     0.200
    75.399    -0.910     0.200
    81.089     0.684     0.200
    81.097    -0.261     0.200
    82.770     0.238     0.200
    89.798    -0.022     0.200
    16.196     5.167     0.200
    17.388     2.229     0.200
    21.747     3.832     0.200
    22.393     3.934     0.200
    22.694     0.739     0.200
    23.839     2.933     0.200
    24.997     2.574     0.200
    39.228     0.047     0.200
    39.412     0.707     0.200
    39.491     0.846     0.200
    44.353     0.001     0.200
    44.402     0.425     0.200
    44.640     0.238     0.200
    67.416     1.577     0.200
    69.322    -2.556     0.200
    81.286     0.628     0.200
    14.272     9.714     0.200
    15.665     6.574     0.200
    17.207     4.829     0.200
    17.370     4.890     0.200
    18.583    -1.771     0.200
    19.330     1.329     0.200
    20.044     1.233     0.200
    21.052     3.305     0.200
    21.362     2.965     0.200
    21.401     2.548     0.200
    21.685     0.495     0.200
    21.844     0.788     0.200
    21.914     4.043     0.200
    22.087    -0.607     0.200
    22.319     3.722     0.200
    22.308     0.332     0.200
    23.124     1.189     0.200
    23.207     0.319     0.200
    23.294    -0.596     0.200
    23.294     0.103     0.200
    23.842     4.079     0.200
    23.995     0.788     0.200
    25.391     0.974     0.200
    25.391     1.775     0.200
    26.655     0.127     0.200
    27.170     2.895     0.200
    27.225     1.400     0.200
    28.143     2.178     0.200
    28.561     2.761     0.200
    29.415     1.872     0.200
    29.583     2.385     0.200
    29.577     0.637     0.200
    29.755     0.859     0.200
    29.755     0.758     0.200
    29.832     1.177     0.200
    29.832     1.777     0.200
    30.775     2.444     0.200
    30.891    -0.180     0.200
    31.127     0.939     0.200
    31.614     1.853     0.200
    31.683     2.642     0.200
    32.065     1.487     0.200
    32.198     1.822     0.200
    32.228     0.754     0.200
    32.435     1.741     0.200
    32.846     3.143     0.200
    33.497     1.459     0.200
    33.799     2.326     0.200
    34.057     2.682     0.200
    34.074     2.835     0.200
    34.061     1.552     0.200
    34.089     1.803     0.200
    34.191     3.224     0.200
    34.229     2.995     0.200
    34.338     2.746     0.200
    34.504     2.712     0.200
    34.616     3.239     0.200
    34.843     2.377     0.200
    34.940     3.440     0.200
    35.311     2.245     0.200
    35.375     2.796     0.200
    35.375     3.196     0.200
    35.600     0.761     0.200
    35.708     2.836     0.200
    35.807     2.985     0.200
    35.819     1.885     0.200
    36.008     2.263     0.200
    36.179    -3.206     0.200
    36.210     0.837     0.200
    36.232     1.346     0.200
    36.416     2.272     0.200
    36.963     2.110     0.200
    36.983     1.942     0.200
    37.079     0.828     0.200
    37.375     2.614     0.200
    37.518     2.401     0.200
    37.518     3.401     0.200
    37.546     2.165     0.200
    37.604     1.675     0.200
    37.754     2.598     0.200
    37.977     1.518     0.200
    38.346     1.512     0.200
    38.692     4.601     0.200
    38.755     1.470     0.200
    38.919     1.098     0.200
    38.988     1.923     0.200
    39.132     0.815     0.200
    39.175     1.953     0.200
    39.224     1.044     0.200
    39.252     2.212     0.200
    39.315     0.783     0.200
    39.341     0.165     0.200
    39.356     2.144     0.200
    39.395     2.614     0.200
    39.453     1.237     0.200
    39.637     1.301     0.200
    40.183     2.066     0.200
    40.184     2.850     0.200
    40.475     0.647     0.200
    40.659     3.524     0.200
    41.225     0.960     0.200
    41.331    -0.514     0.200
    41.276     0.341     0.200
    41.960     2.435     0.200
    41.989     2.002     0.200
    41.997     2.133     0.200
    42.206     0.628     0.200
    42.315     0.241     0.200
    42.370     2.586     0.200
    42.403    -0.180     0.200
    42.507     1.474     0.200
    42.762     1.407     0.200
    42.866     1.263     0.200
    43.116     2.437     0.200
    43.184     4.482     0.200
    43.342     2.012     0.200
    43.383     1.782     0.200
    43.486     1.745     0.200
    43.530     1.695     0.200
    43.771     1.755     0.200
    43.905     1.671     0.200
    43.967     1.674     0.200
    44.063     2.208     0.200
    44.075     1.413     0.200
    44.229     1.574     0.200
    44.258     0.324     0.200
    44.307     0.646     0.200
    44.325     1.809     0.200
    44.383     0.839     0.200
    44.570     2.849     0.200
    44.545     0.529     0.200
    44.623     2.425     0.200
    44.728     1.385     0.200
    44.818     1.867     0.200
    44.831     0.269     0.200
    44.970     1.659     0.200
    45.146     1.756     0.200
    45.234     1.563     0.200
    45.276     2.628     0.200
    45.277     2.720     0.200
    45.334     1.767     0.200
    45.360     1.760     0.200
    45.570     0.796     0.200
    45.664     1.250     0.200
    45.708     2.002     0.200
    45.743    -0.472     0.200
    45.940     2.474     0.200
    46.037     2.508     0.200
    46.171     2.151     0.200
    46.301     0.530     0.200
    47.019     1.801     0.200
    47.040     0.841     0.200
    47.240     0.876     0.200
    47.264     0.592     0.200
    47.274     2.709     0.200
    47.325     1.312     0.200
    47.349     0.927     0.200
    47.370     0.765     0.200
    47.606     2.430     0.200
    47.656     6.044     0.200
    47.668    -0.549     0.200
    47.732     1.954     0.200
    47.874     0.753     0.200
    47.879     1.311     0.200
    47.893     2.004     0.200
    47.932    -0.099     0.200
    47.964     0.851     0.200
    47.987     1.179     0.200
    48.189     1.914     0.200
    48.251     1.637     0.200
    48.390     1.366     0.200
    48.535     2.843     0.200
    48.568     1.492     0.200
    48.659     1.592     0.200
    49.263     1.255     0.200
    49.410     0.935     0.200
    49.490     1.125     0.200
    49.496     1.879     0.200
    49.549     2.175     0.200
    49.863     1.286     0.200
    50.353     0.969     0.200
    50.375     1.699     0.200
    50.418     1.275     0.200
    50.445     1.371     0.200
    50.443     1.084     0.200
    50.576     1.683     0.200
    50.719     1.198     0.200
    50.817     2.859     0.200
    50.876     1.418     0.200
    51.328     1.522     0.200
    51.515     1.919     0.200
    51.753     1.844     0.200
    52.164     2.279     0.200
    52.222     1.452     0.200
    52.451     2.350     0.200
    52.829     2.048     0.200
    52.995     1.125     0.200
    53.073     2.150     0.200
    53.266     1.225     0.200
    53.321     1.220     0.200
    53.344     0.655     0.200
    53.364     0.805     0.200
    53.522     1.550     0.200
    53.856     0.798     0.200
    54.046     1.208     0.200
    54.234     3.043     0.200
    54.263     2.329     0.200
    54.353     1.071     0.200
    54.387     1.427     0.200
    54.486     1.304     0.200
    54.656     2.474     0.200
    54.980     0.820     0.200
    55.178     1.295     0.200
    55.220     1.089     0.200
    55.573     0.545     0.200
    55.715     0.424     0.200
    55.787    -0.589     0.200
    55.991    -0.153     0.200
    55.991     0.046     0.200
    56.129    -0.841     0.200
    56.215     0.151     0.200
    56.419    -0.010     0.200
    57.476     2.298     0.200
    57.663     1.982     0.200
    57.974     1.298     0.200
    58.461     1.295     0.200
    58.606     1.577     0.200
    60.861     0.357     0.200
    61.190     1.621     0.200
    62.080     1.620     0.200
    62.182    -3.069     0.200
    62.528     0.320     0.200
    63.094     0.850     0.200
    64.247     0.240     0.200
    65.639    -0.222     0.200
    67.457     0.560     0.200
    69.233    -0.662     0.200
    69.634     2.962     0.200
    72.135     0.457     0.200
    72.349     1.282     0.200
    72.623    -0.152     0.200
    72.623    -0.755     0.200
    72.964     0.724     0.200
    74.039    -0.305     0.200
    74.267    -0.037     0.200
    74.366     0.589     0.200
    74.627     0.869     0.200
    74.770     0.242     0.200
    74.866     1.189     0.200
    75.929     0.278     0.200
    76.018     1.073     0.200
    76.389    -0.035     0.200
    76.389    -0.035     0.200
    76.733    -0.481     0.200
    77.320     1.716     0.200
    78.882    -0.851     0.200
    78.967    -0.419     0.200
    80.245    -0.365     0.200
    80.452     0.820     0.200
    80.848    -0.602     0.200
    81.153    -0.029     0.200
    81.357     1.090     0.200
    81.365     0.445     0.200
    82.286     0.393     0.200
    82.765     1.795     0.200
    82.935     1.914     0.200
    82.963     0.766     0.200
    83.142     0.745     0.200
    83.156     1.772     0.200
    83.161    -0.157     0.200
    83.524     0.375     0.200
    83.658    -0.016     0.200
    85.578     0.184     0.200
    86.088     0.058     0.200
    90.134     0.145     0.200
    90.138     0.428     0.200
    90.785     0.114     0.200
    92.462     0.645     0.200
    93.759     0.967     0.200
    95.347     0.087     0.200
    95.949     0.344     0.200
    97.211    -0.379     0.200
    14.312    10.774     0.200
    15.617     8.932     0.200
    16.200     4.406     0.200
    17.326     7.207     0.200
    18.605    -2.192     0.200
    18.605    -0.192     0.200
    19.351     1.232     0.200
    19.999     1.549     0.200
    20.603     1.394     0.200
    21.010     3.092     0.200
    21.318     2.271     0.200
    21.324     3.202     0.200
    21.357     1.854     0.200
    21.637     3.846     0.200
    21.746    -1.127     0.200
    21.862     1.038     0.200
    21.869     5.358     0.200
    22.101     1.579     0.200
    22.326     1.485     0.200
    23.082     0.973     0.200
    23.193     0.306     0.200
    23.193     0.505     0.200
    23.277     1.417     0.200
    23.887     2.561     0.200
    25.110     2.409     0.200
    25.348     4.252     0.200
    27.216     2.870     0.200
    27.183     2.670     0.200
    27.777     2.339     0.200
    27.777     2.538     0.200
    27.785     4.166     0.200
    28.191     2.246     0.200
    28.594     2.059     0.200
    29.463     1.344     0.200
    29.535     3.707     0.200
    29.535     3.707     0.200
    29.555     4.528     0.200
    29.800     2.358     0.200
    29.800     2.357     0.200
    29.864     2.795     0.200
    30.819     1.352     0.200
    30.860     0.986     0.200
    31.095     1.415     0.200
    31.276     2.825     0.200
    31.661     1.937     0.200
    31.727     2.657     0.200
    32.113     1.161     0.200
    32.138     2.642     0.200
    32.152     2.220     0.200
    32.181    -0.240     0.200
    32.389     3.043     0.200
    32.656     4.099     0.200
    32.616     1.652     0.200
    32.818     1.785     0.200
    32.889     4.964     0.200
    33.262     1.902     0.200
    33.456     2.716     0.200
    33.495     1.375     0.200
    33.645     4.168     0.200
    33.844     2.334     0.200
    33.813     3.105     0.200
    34.015     1.947     0.200
    34.048     2.064     0.200
    34.203     1.715     0.200
    34.203     3.715     0.200
    34.448     2.197     0.200
    34.330     5.618     0.200
    34.427     2.877     0.200
    34.473     2.376     0.200
    34.567     4.067     0.200
    34.673     0.747     0.200
    34.719    -2.746     0.200
    34.801     3.541     0.200
    34.867     3.977     0.200
    34.898     3.708     0.200
    34.993     2.883     0.200
    35.186     2.226     0.200
    35.200     4.101     0.200
    35.200     5.101     0.200
    35.236     1.793     0.200
    35.249     2.683     0.200
    35.333     2.962     0.200
    35.339     2.403     0.200
    35.566     1.959     0.200
    35.663     3.120     0.200
    35.763     3.263     0.200
    35.774     3.170     0.200
    35.965     5.029     0.200
    35.965     5.529     0.200
    36.216     0.385     0.200
    36.203     1.494     0.200
    36.460     2.304     0.200
    36.457     2.324     0.200
    36.512     2.357     0.200
    36.517     2.815     0.200
    36.992    -0.733     0.200
    37.011     2.212     0.200
    36.944     2.179     0.200
    37.106    -0.200     0.200
    37.106     0.601     0.200
    37.185     1.730     0.200
    37.248     1.095     0.200
    37.331     2.893     0.200
    37.344     3.310     0.200
    37.476     3.662     0.200
    37.484     2.320     0.200
    37.500     3.462     0.200
    37.588     1.717     0.200
    37.671     2.184     0.200
    37.709     4.092     0.200
    37.740     3.159     0.200
    37.751     2.904     0.200
    37.932     1.501     0.200
    37.978     3.421     0.200
    38.174     2.717     0.200
    38.358     3.215     0.200
    38.437     2.322     0.200
    38.652     3.741     0.200
    38.711     3.051     0.200
    38.959     1.175     0.200
    39.036     2.529     0.200
    39.103     0.864     0.200
    39.111     3.898     0.200
    39.135     1.698     0.200
    39.204     2.318     0.200
    39.209     2.276     0.200
    39.284     1.557     0.200
    39.289     0.414     0.200
    39.317     0.680     0.200
    39.316     2.683     0.200
    39.355     2.864     0.200
    39.554     2.204     0.200
    39.598     2.137     0.200
    39.894    -1.126     0.200
    40.229     2.588     0.200
    40.144     2.299     0.200
    40.278     1.188     0.200
    40.511     3.359     0.200
    40.618     4.570     0.200
    40.799     3.074     0.200
    40.723     3.509     0.200
    41.263     1.255     0.200
    41.367     0.201     0.200
    41.254     0.732     0.200
    41.416     1.306     0.200
    41.426     2.724     0.200
    41.676     2.670     0.200
    41.802     1.643     0.200
    41.948     2.945     0.200
    41.948     4.445     0.200
    42.011     2.434     0.200
    42.179    -0.340     0.200
    42.179     0.859     0.200
    42.217     2.252     0.200
    42.284     0.105     0.200
    42.284     1.105     0.200
    42.417     2.619     0.200
    42.384     1.392     0.200
    42.384     1.563     0.200
    42.717     3.187     0.200
    42.906     2.950     0.200
    43.077     2.569     0.200
    43.095     3.620     0.200
    43.117     3.946     0.200
    43.149     3.883     0.200
    43.145     3.714     0.200
    43.399     4.066     0.200
    43.420     2.300     0.200
    43.448     1.272     0.200
    43.448     3.073     0.200
    43.485     2.472     0.200
    43.731     1.491     0.200
    43.731     1.593     0.200
    43.864     2.925     0.200
    43.910     4.555     0.200
    43.923     4.246     0.200
    43.926     2.424     0.200
    44.022     2.654     0.200
    44.029     2.897     0.200
    44.036     2.736     0.200
    44.277     0.411     0.200
    44.385     0.546     0.200
    44.473     2.843     0.200
    44.608     2.459     0.200
    44.509     2.754     0.200
    44.579     3.192     0.200
    44.764     0.718     0.200
    44.779     3.294     0.200
    44.921     2.964     0.200
    44.931     2.885     0.200
    44.995     2.376     0.200
    45.010     3.763     0.200
    45.103     3.022     0.200
    45.189     2.339     0.200
    45.237     2.658     0.200
    45.292     1.517     0.200
    45.320     3.101     0.200
    45.424     3.972     0.200
    45.439     5.853     0.200
    45.618    -0.464     0.200
    45.623     1.396     0.200
    45.748     2.408     0.200
    45.768    -1.149     0.200
    45.897     4.732     0.200
    46.087     6.235     0.200
    46.129     2.901     0.200
    46.211     1.263     0.200
    46.247     1.580     0.200
    46.270     0.099     0.200
    46.270     0.548     0.200
    46.318     2.416     0.200
    46.329     3.629     0.200
    46.365     1.045     0.200
    46.717     1.188     0.200
    46.748     2.241     0.200
    46.981     3.125     0.200
    46.999     1.283     0.200
    47.199     1.022     0.200
    47.224     1.029     0.200
    47.232     4.761     0.200
    47.330     1.805     0.200
    47.647     3.038     0.200
    47.601     4.390     0.200
    47.648     2.032     0.200
    47.683    -0.244     0.200
    47.720     4.170     0.200
    47.832     2.097     0.200
    47.836     0.570     0.200
    47.856     2.418     0.200
    47.878     3.741     0.200
    47.891     1.148     0.200
    47.947     1.611     0.200
    47.969     3.440     0.200
    48.051     1.908     0.200
    48.237     2.470     0.200
    48.209     1.284     0.200
    48.214     1.848     0.200
    48.299     2.186     0.200
    48.349     0.999     0.200
    48.448     1.738     0.200
    48.493     3.493     0.200
    48.530     3.212     0.200
    48.538     1.145     0.200
    48.619     0.923     0.200
    48.850     1.749     0.200
    49.221     0.408     0.200
    49.367     1.287     0.200
    49.447     0.678     0.200
    49.457     2.203     0.200
    49.511     2.593     0.200
    49.820     2.439     0.200
    50.340     1.893     0.200
    50.377     0.610     0.200
    50.403     0.617     0.200
    50.490     2.563     0.200
    50.535     1.021     0.200
    50.679     0.731     0.200
    50.862     4.348     0.200
    50.835     0.852     0.200
    50.922     1.601     0.200
    51.287     2.761     0.200
    51.475     1.355     0.200
    51.712     1.380     0.200
    52.115     2.080     0.200
    52.123     1.519     0.200
    52.181     0.888     0.200
    52.409     1.491     0.200
    52.633     3.229     0.200
    52.759     0.599     0.200
    52.788     1.088     0.200
    52.956     0.448     0.200
    53.031     1.187     0.200
    53.226     0.755     0.200
    53.282     0.443     0.200
    53.330     0.592     0.200
    53.482     0.473     0.200
    53.814     0.843     0.200
    54.090     0.327     0.200
    54.300     1.993     0.200
    54.343     1.177     0.200
    54.613     2.317     0.200
    55.221     1.216     0.200
    55.264     2.012     0.200
    55.538     1.739     0.200
    55.680     1.717     0.200
    55.752     1.802     0.200
    56.001     2.716     0.200
    56.034     2.579     0.200
    56.018    -0.407     0.200
    56.018    -0.106     0.200
    55.984     1.836     0.200
    55.984     3.336     0.200
    56.094     1.949     0.200
    56.239     0.016     0.200
    56.239     0.118     0.200
    56.568    -0.327     0.200
    56.578    -0.304     0.200
    57.276     1.653     0.200
    57.460     1.352     0.200
    57.523     2.907     0.200
    57.637     3.110     0.200
    57.840     3.878     0.200
    57.931     2.542     0.200
    57.931     1.956     0.200
    58.198     5.169     0.200
    58.435     1.912     0.200
    58.435     3.615     0.200
    58.562     3.527     0.200
    58.594     3.403     0.200
    59.341     2.525     0.200
    60.247     1.990     0.200
    60.393     2.990     0.200
    60.435     2.805     0.200
    60.521     3.116     0.200
    60.720     1.763     0.200
    61.586    -0.111     0.200
    61.586     0.588     0.200
    61.997     3.323     0.200
    62.037     3.856     0.200
    62.213    -2.330     0.200
    63.063     0.003     0.200
    64.215     0.398     0.200
    65.656     0.024     0.200
    66.237     1.085     0.200
    67.426     0.710     0.200
    69.235    -0.219     0.200
    69.233     0.396     0.200
    69.681     2.925     0.200
    69.745     1.533     0.200
    71.158     1.601     0.200
    72.106     1.493     0.200
    72.595     1.876     0.200
    72.660     1.588     0.200
    74.051    -0.912     0.200
    74.219    -0.294     0.200
    74.544     1.014     0.200
    74.669     1.789     0.200
    75.831    -0.897     0.200
    75.919     1.602     0.200
    76.053     0.740     0.200
    76.399    -0.231     0.200
    76.399    -0.630     0.200
    77.367     1.421     0.200
    78.169    -0.050     0.200
    78.889    -0.522     0.200
    79.149     2.555     0.200
    79.499     0.644     0.200
    80.276     0.435     0.200
    80.490     1.287     0.200
    80.882     1.186     0.200
    81.168    -1.839     0.200
    81.334     3.581     0.200
    81.399     0.040     0.200
    81.408     0.092     0.200
    82.296    -0.087     0.200
    82.813     0.023     0.200
    83.141     0.020     0.200
    83.155    -0.353     0.200
    83.161    -0.779     0.200
    83.565     0.139     0.200
    83.637     1.267     0.200
    84.545     1.145     0.200
    85.568     2.015     0.200
    85.622    -0.253     0.200
    86.079     0.282     0.200
    86.112     0.818     0.200
    90.179     0.918     0.200
    92.462    -0.172     0.200
    93.748    -0.401     0.200
    93.873     4.823     0.200
    94.050     1.011     0.200
    94.123     2.073     0.200
    94.666     2.184     0.200
    95.019     1.368     0.200
    95.369     0.967     0.200
    95.952     1.313     0.200
    96.181     2.271     0.200
    97.213    -0.404     0.200
    18.229     0.072     0.200
    19.378     1.217     0.200
    20.644     1.133     0.200
    21.772    -0.324     0.200
    22.123     0.429     0.200
    22.369     1.106     0.200
    22.236     3.315     0.200
    23.188     0.433     0.200
    23.932     3.003     0.200
    27.262     2.507     0.200
    28.237     2.284     0.200
    28.632     1.974     0.200
    31.072     1.172     0.200
    31.707     0.777     0.200
    32.158     1.215     0.200
    33.890     2.086     0.200
    34.272     2.165     0.200
    35.297     3.317     0.200
    36.230     0.608     0.200
    36.504     2.467     0.200
    37.057     2.262     0.200
    37.139    -0.435     0.200
    37.139     0.463     0.200
    37.846     2.476     0.200
    39.082     0.682     0.200
    39.271     0.607     0.200
    39.284     3.498     0.200
    39.301     0.459     0.200
    41.396    -0.296     0.200
    41.241     1.279     0.200
    42.161     0.347     0.200
    42.261    -0.469     0.200
    43.045     2.067     0.200
    44.205     0.161     0.200
    44.254     0.528     0.200
    44.492     0.504     0.200
    44.792     1.030     0.200
    45.596    -0.356     0.200
    45.799    -1.459     0.200
    45.799    -1.158     0.200
    47.706    -0.383     0.200
    48.316     1.093     0.200
    50.501     1.408     0.200
    50.802     1.339     0.200
    51.440     1.745     0.200
    51.678     1.667     0.200
    52.088     1.709     0.200
    52.997     1.475     0.200
    54.341     0.727     0.200
    54.341     0.829     0.200
    56.269    -0.171     0.200
    56.269     0.329     0.200
    56.397    -0.084     0.200
    56.522    -0.978     0.200
    56.532    -1.048     0.200
    63.027    -2.739     0.200
    64.179     2.658     0.200
    65.679    -0.107     0.200
    67.390     0.956     0.200
    69.241     0.364     0.200
    75.845     0.041     0.200
    76.418    -0.220     0.200
    76.708     0.138     0.200
    81.435     0.957     0.200
    81.444    -0.089     0.200
    83.149     0.187     0.200
    83.169    -0.412     0.200
    86.079    -0.509     0.200
    14.322    10.408     0.200
    18.631    -3.056     0.200
    21.324     2.611     0.200
    21.890     1.037     0.200
    21.708    -0.912     0.200
    22.063     0.690     0.200
    22.272     3.460     0.200
    22.321     0.945     0.200
    22.790    -2.045     0.200
    23.162     1.027     0.200
    23.162     1.426     0.200
    23.248     1.124     0.200
    23.861     2.745     0.200
    23.986     1.004     0.200
    23.986     1.800     0.200
    25.140     2.486     0.200
    27.194     2.409     0.200
    28.176     2.725     0.200
    28.559     2.307     0.200
    31.077     1.210     0.200
    31.640     1.749     0.200
    32.101     1.602     0.200
    34.238     4.145     0.200
    35.327     3.341     0.200
    36.179     0.733     0.200
    36.433     1.859     0.200
    36.992     2.092     0.200
    37.069     0.437     0.200
    37.069     1.140     0.200
    37.576     1.142     0.200
    37.776     2.649     0.200
    39.082     0.757     0.200
    39.266     0.526     0.200
    41.228     1.959     0.200
    42.157     0.262     0.200
    42.264    -0.821     0.200
    43.066     1.665     0.200
    43.066     2.369     0.200
    43.484     2.295     0.200
    43.437     2.675     0.200
    43.919     2.495     0.200
    44.208     0.073     0.200
    44.257     0.372     0.200
    44.495     0.278     0.200
    45.285     1.380     0.200
    45.598    -0.202     0.200
    45.731    -0.649     0.200
    47.645    -0.646     0.200
    47.645    -0.247     0.200
    48.341     1.073     0.200
    50.527     1.278     0.200
    50.670     1.296     0.200
    50.827     1.216     0.200
    51.467     1.710     0.200
    51.704     1.638     0.200
    52.116     1.865     0.200
    52.173     1.145     0.200
    53.024     1.634     0.200
    56.201    -0.430     0.200
    56.201     0.171     0.200
    56.374     0.041     0.200
    65.618    -0.461     0.200
    65.618    -0.062     0.200
    67.462     0.752     0.200
    74.236     0.464     0.200
    76.362    -0.662     0.200
    81.405    -0.143     0.200
    81.413    -0.094     0.200
    83.106     0.249     0.200
    86.046    -0.117     0.200
    15.972     5.524     0.200
    17.324     5.400     0.200
    18.616    -2.184     0.200
    19.820     2.231     0.200
    21.006     3.751     0.200
    21.323     2.338     0.200
    21.873     1.931     0.200
    21.867     3.496     0.200
    22.087     0.142     0.200
    22.272     3.370     0.200
    22.262     1.281     0.200
    22.796    -1.395     0.200
    23.078     0.728     0.200
    23.181     0.544     0.200
    23.181     1.243     0.200
    23.266    -0.349     0.200
    23.266     0.452     0.200
    23.686     4.974     0.200
    23.879     3.416     0.200
    24.010     2.322     0.200
    25.344     0.363     0.200
    27.765     2.526     0.200
    28.582     2.241     0.200
    29.802     2.916     0.200
    29.851     1.979     0.200
    31.087     1.562     0.200
    31.655     0.865     0.200
    31.718     2.405     0.200
    32.110     1.459     0.200
    32.818     1.859     0.200
    34.237     3.993     0.200
    34.864     3.071     0.200
    35.329     3.566     0.200
    35.558     1.092     0.200
    35.772     2.260     0.200
    36.202     0.874     0.200
    36.194     0.642     0.200
    37.005     1.724     0.200
    37.039     2.439     0.200
    37.582     1.836     0.200
    37.793     2.852     0.200
    37.930     2.287     0.200
    38.709     2.338     0.200
    39.094     1.006     0.200
    39.130     1.806     0.200
    39.193     0.278     0.200
    39.193     0.778     0.200
    39.279     0.560     0.200
    39.307     1.132     0.200
    39.311     3.294     0.200
    39.351     2.163     0.200
    39.472     0.948     0.200
    39.472     1.249     0.200
    39.592     1.847     0.200
    39.592     1.249     0.200
    41.244     0.283     0.200
    41.244     2.884     0.200
    41.667     2.810     0.200
    41.802     1.705     0.200
    42.170     0.801     0.200
    42.275     0.537     0.200
    42.373     0.045     0.200
    42.897     2.990     0.200
    43.071     2.476     0.200
    43.140     2.820     0.200
    43.296     1.860     0.200
    43.385     3.738     0.200
    43.442     2.079     0.200
    43.726     2.094     0.200
    43.860     1.819     0.200
    43.921     2.629     0.200
    44.017     2.251     0.200
    44.026     1.479     0.200
    44.031     1.844     0.200
    44.364     1.579     0.200
    44.771     1.225     0.200
    44.729     2.858     0.200
    44.918     1.650     0.200
    44.926     1.490     0.200
    45.100     2.105     0.200
    45.231     2.959     0.200
    45.421     3.058     0.200
    45.610    -0.938     0.200
    45.755    -2.088     0.200
    45.755    -1.486     0.200
    46.125     2.890     0.200
    46.242     1.572     0.200
    46.315     2.003     0.200
    46.712     1.383     0.200
    46.994     1.176     0.200
    47.195     0.613     0.200
    47.229     3.349     0.200
    47.304     2.764     0.200
    47.637     3.171     0.200
    47.669    -0.080     0.200
    47.828     0.687     0.200
    47.833     0.851     0.200
    48.205     1.272     0.200
    48.345     1.296     0.200
    48.534     1.234     0.200
    48.614     1.318     0.200
    49.217     0.791     0.200
    49.444     0.959     0.200
    49.816     3.419     0.200
    50.373     0.899     0.200
    50.398     0.906     0.200
    50.530     1.308     0.200
    50.674     1.121     0.200
    50.935    -0.545     0.200
    50.831     1.140     0.200
    50.918     1.389     0.200
    51.470     1.840     0.200
    51.707     1.564     0.200
    52.119     1.801     0.200
    52.176     1.275     0.200
    52.405     1.871     0.200
    52.754     0.990     0.200
    52.784     1.670     0.200
    52.951     0.738     0.200
    53.027     1.769     0.200
    53.221     1.141     0.200
    53.277     0.833     0.200
    53.323     0.496     0.200
    53.477     1.061     0.200
    53.810     1.221     0.200
    54.081     0.940     0.200
    54.289     0.122     0.200
    54.289     0.923     0.200
    54.340     2.750     0.200
    55.531     0.437     0.200
    55.673     0.614     0.200
    55.745     0.900     0.200
    55.832     0.472     0.200
    55.980     2.911     0.200
    56.033     0.838     0.200
    56.392     0.272     0.200
    56.576     0.362     0.200
    57.928     2.110     0.200
    58.203     1.182     0.200
    63.075     1.962     0.200
    64.227     1.358     0.200
    66.531     2.438     0.200
    67.438     1.670     0.200
    69.219    -0.486     0.200
    74.673     1.797     0.200
    75.818     0.210     0.200
    76.060     0.830     0.200
    76.386    -0.023     0.200
    76.704     0.173     0.200
    81.403     1.143     0.200
    81.411    -0.102     0.200
    83.128     0.214     0.200
    83.147    -0.187     0.200
    83.569     0.140     0.200
    92.448    -0.092     0.200
    17.307     3.047     0.200
    17.307     3.148     0.200
    18.179     2.046     0.200
    18.623    -0.924     0.200
    20.602     0.956     0.200
    21.881     2.564     0.200
    21.720    -2.607     0.200
    21.720    -1.904     0.200
    22.075     0.595     0.200
    22.322     0.958     0.200
    22.273     3.484     0.200
    23.078     0.947     0.200
    23.172     0.954     0.200
    23.257     0.055     0.200
    23.257     0.453     0.200
    23.689     4.897     0.200
    23.869     2.949     0.200
    25.131     2.549     0.200
    28.181     2.655     0.200
    28.570     1.583     0.200
    28.570     1.981     0.200
    29.457     2.204     0.200
    29.801     3.660     0.200
    31.083     1.335     0.200
    32.105     1.337     0.200
    35.328     2.792     0.200
    35.328     3.292     0.200
    36.190    -0.105     0.200
    37.081    -0.698     0.200
    37.081     0.099     0.200
    37.931     2.299     0.200
    39.089     0.367     0.200
    39.273     0.622     0.200
    39.300     1.600     0.200
    39.590     1.177     0.200
    39.590     1.575     0.200
    41.377     1.395     0.200
    41.236     1.552     0.200
    42.270     0.483     0.200
    42.365     0.315     0.200
    43.295     2.166     0.200
    43.394     1.469     0.200
    43.440     1.600     0.200
    43.484     2.245     0.200
    44.391     1.461     0.200
    44.774     0.398     0.200
    44.919     1.744     0.200
    45.007     3.045     0.200
    45.100     1.003     0.200
    45.287     1.813     0.200
    45.421     3.255     0.200
    45.605     0.002     0.200
    47.228     3.045     0.200
    47.657     0.207     0.200
    47.833     0.942     0.200
    47.886    -0.068     0.200
    48.893     1.161     0.200
    49.444     0.846     0.200
    49.816     1.208     0.200
    50.529     1.497     0.200
    50.673     0.912     0.200
    50.830     1.230     0.200
    51.469     1.529     0.200
    51.706     1.753     0.200
    52.118     1.889     0.200
    52.175     1.361     0.200
    52.404     2.057     0.200
    53.026     1.851     0.200
    53.319    -0.202     0.200
    53.810     0.399     0.200
    56.383     0.203     0.200
    56.585     0.264     0.200
    63.087     2.035     0.200
    64.239     2.431     0.200
    67.450     1.738     0.200
    69.208     0.326     0.200
    75.806    -0.595     0.200
    76.374    -0.827     0.200
    76.686     0.609     0.200
    81.403     0.458     0.200
    81.412    -0.283     0.200
    16.349     4.644     0.200
    17.265     2.703     0.200
    18.138     0.623     0.200
    18.627     0.237     0.200
    20.567     1.052     0.200
    21.891     0.589     0.200
    22.035     0.053     0.200
    23.816     2.293     0.200
    25.142     2.607     0.200
    28.519     1.422     0.200
    32.061     1.514     0.200
    36.157     0.588     0.200
    37.032    -1.874     0.200
    39.094     0.538     0.200
    39.275     0.432     0.200
    41.361    -0.048     0.200
    45.611    -0.306     0.200
    48.617     1.247     0.200
    56.638     2.781     0.200
    69.181    -0.563     0.200
    74.279     0.278     0.200
    75.773    -0.549     0.200
    81.375     0.287     0.200
    81.376     0.178     0.200
    83.546     0.458     0.200
    20.400     1.297     0.200
    21.613     3.003     0.200
    35.563     3.836     0.200
    39.359     0.673     0.200
    39.545     0.921     0.200
    44.532     0.112     0.200
    45.874     0.355     0.200
    48.588     1.102     0.200
    48.858     1.027     0.200
    48.997     1.459     0.200
    50.615     0.950     0.200
    50.641     0.753     0.200
    50.771     1.267     0.200
    51.072     1.103     0.200
    51.461     1.088     0.200
    51.721     1.549     0.200
    51.948     1.549     0.200
    52.356     1.619     0.200
    52.417     1.063     0.200
    53.265     1.297     0.200
    56.623     1.110     0.200
    20.581     0.450     0.200
    21.911     1.811     0.200
    23.818     2.355     0.200
    25.162     2.493     0.200
    39.074     0.713     0.200
    39.254     0.201     0.200
    42.337    -0.242     0.200
    45.591    -0.581     0.200
    48.767     1.838     0.200
    48.777     1.763     0.200
    50.535     1.259     0.200
    50.835     0.698     0.200
    52.126     1.832     0.200
    53.034     1.804     0.200
    53.820     0.530     0.200
    75.756     0.872     0.200
    18.586    -1.752     0.200
    21.105     3.805     0.200
    21.435     3.251     0.200
    21.858     0.817     0.200
    23.176     0.734     0.200
    23.185     1.541     0.200
    23.277     0.671     0.200
    23.743     3.297     0.200
    25.112     2.721     0.200
    28.053     2.215     0.200
    28.466     1.838     0.200
    31.979     1.674     0.200
    35.120     2.136     0.200
    35.120     2.636     0.200
    36.989    -1.852     0.200
    36.989    -1.051     0.200
    39.008     0.619     0.200
    39.146     0.565     0.200
    40.706     2.004     0.200
    42.213     0.748     0.200
    43.527     2.407     0.200
    44.326    -0.109     0.200
    45.665    -0.257     0.200
    47.594    -0.670     0.200
    48.436     1.017     0.200
    48.598     2.072     0.200
    48.856     1.684     0.200
    48.866     1.609     0.200
    50.624     1.139     0.200
    50.766     0.963     0.200
    50.923     1.079     0.200
    51.574     1.600     0.200
    51.801     1.609     0.200
    52.215     1.827     0.200
    52.269     0.921     0.200
    52.500     1.807     0.200
    53.123     1.609     0.200
    56.401    -0.241     0.200
    63.187     0.401     0.200
    67.550     0.553     0.200
    69.185     2.125     0.200
    75.769     0.407     0.200
    76.322    -0.023     0.200
    81.303     0.599     0.200
    81.323     0.099     0.200
    83.475     0.258     0.200
    18.607    -0.232     0.200
    20.208     1.859     0.200
    21.327     3.747     0.200
    21.925     1.520     0.200
    21.672     3.032     0.200
    21.710     2.624     0.200
    23.096     1.680     0.200
    23.329     2.927     0.200
    23.210     2.676     0.200
    23.395     1.733     0.200
    27.675     1.303     0.200
    28.066     2.011     0.200
    29.435     2.035     0.200
    31.119     3.350     0.200
    34.719     1.679     0.200
    34.719     1.878     0.200
    35.649     3.172     0.200
    35.649     3.672     0.200
    36.612    -0.773     0.200
    39.043     0.381     0.200
    39.202     0.754     0.200
    41.357    -0.304     0.200
    43.935     1.253     0.200
    44.400    -0.179     0.200
    48.627     0.845     0.200
    48.894     0.793     0.200
    49.067     1.864     0.200
    49.077     1.792     0.200
    50.661     0.948     0.200
    50.822     1.031     0.200
    50.961     0.887     0.200
    51.120     0.889     0.200
    52.000     1.504     0.200
    56.324     0.161     0.200
    57.135     0.699     0.200
    73.674     2.003     0.200
    74.741     0.659     0.200
    74.811     0.533     0.200
    75.053     0.498     0.200
    81.084     1.204     0.200
    81.092     0.158     0.200
    18.667     0.520     0.200
    21.456     1.499     0.200
    21.950     1.615     0.200
    22.279     2.896     0.200
    23.185     1.316     0.200
    23.185     0.715     0.200
    23.396     0.891     0.200
    28.351     1.241     0.200
    38.774     0.861     0.200
    42.639     0.870     0.200
    43.722     2.324     0.200
    45.407    -0.230     0.200
    45.604    -0.989     0.200
    49.110     1.536     0.200
    56.431     0.442     0.200
    69.070     0.133     0.200
    74.416     0.498     0.200
    74.728     0.291     0.200
    76.253     2.240     0.200
    82.628    -0.462     0.200
    83.498     1.341     0.200
    21.892     2.280     0.200
    23.248     1.288     0.200
    37.877     1.824     0.200
    38.656     1.369     0.200
    38.762     0.577     0.200
    38.932     0.856     0.200
    42.140     0.537     0.200
    42.240     0.116     0.200
    42.681     0.334     0.200
    44.233     1.014     0.200
    45.377    -0.196     0.200
    45.575    -0.171     0.200
    48.711     1.774     0.200
    48.721     1.597     0.200
    49.193     0.575     0.200
    56.155    -0.234     0.200
    69.221     0.117     0.200
    81.453     1.101     0.200
    81.453     0.199     0.200
    81.472     0.097     0.200
    83.619    -0.193     0.200
    23.546     6.362     0.200
    29.751     1.270     0.200
    36.760     1.604     0.200
    38.850     1.051     0.200
    42.677     1.062     0.200
    44.356     0.435     0.200
    45.689     0.024     0.200
    49.117    -0.349     0.200
    56.630    -0.134     0.200
    69.024    -0.588     0.200
    76.409     0.026     0.200
    81.169    -0.234     0.200
    23.651     1.251     0.200
    23.931     1.688     0.200
    35.772     0.217     0.200
    36.738     0.561     0.200
    39.373     0.436     0.200
    39.530     0.632     0.200
    43.144     0.542     0.200
    44.435     1.466     0.200
    44.896     0.584     0.200
    46.033    -0.017     0.200
    46.226    -0.044     0.200
    49.526     0.896     0.200
    51.183     0.664     0.200
    53.326     2.035     0.200
    54.014     1.299     0.200
    56.998     2.237     0.200
    69.308     2.044     0.200
    75.805    -0.343     0.200
    21.506     0.583     0.200
    29.748     1.669     0.200
    38.869     0.053     0.200
    42.701     1.031     0.200
    44.373     0.354     0.200
    45.512    -0.408     0.200
    56.609     0.963     0.200
    58.192     0.598     0.200
    82.964     0.583     0.200
    83.349    -0.008     0.200
    15.855     4.005     0.200
    21.514     0.528     0.200
    23.192     1.969     0.200
    23.284     1.795     0.200
    23.540     3.307     0.200
    29.822     1.007     0.200
    36.816     3.397     0.200
    42.655     0.092     0.200
    44.312     0.825     0.200
    45.648     0.096     0.200
    45.648     0.096     0.200
    56.548     0.672     0.200
    58.119     1.078     0.200
    76.454    -0.935     0.200
    81.236     0.893     0.200
    82.946    -0.781     0.200
    83.420    -0.034     0.200
    21.953    -0.286     0.200
    23.511     1.032     0.200
    36.005     0.453     0.200
    39.040     0.967     0.200
    39.209     1.252     0.200
    45.654     0.036     0.200
    45.904     1.761     0.200
    56.235     0.959     0.200
    75.921     2.249     0.200
    83.358    -0.328     0.200
    15.671     4.447     0.200
    18.429     1.852     0.200
    18.429    -1.648     0.200
    19.357     1.664     0.200
    21.701     1.954     0.200
    21.760    -0.182     0.200
    21.826     0.915     0.200
    22.139    -0.428     0.200
    22.407     2.714     0.200
    23.299     1.280     0.200
    23.342     2.021     0.200
    23.462     0.565     0.200
    23.538     2.786     0.200
    23.747     2.470     0.200
    27.056     2.334     0.200
    27.729     2.801     0.200
    28.007     2.317     0.200
    28.532     1.638     0.200
    29.801     0.773     0.200
    30.165     1.254     0.200
    31.296     1.668     0.200
    33.697     1.430     0.200
    35.185     1.047     0.200
    36.326     2.261     0.200
    36.326     2.457     0.200
    37.076     0.067     0.200
    37.120     0.096     0.200
    38.697     1.774     0.200
    38.995     0.380     0.200
    39.162     0.484     0.200
    39.298     0.450     0.200
    39.545     3.282     0.200
    42.458     0.890     0.200
    42.482     0.592     0.200
    42.882     0.344     0.200
    43.878     2.704     0.200
    44.475     0.718     0.200
    45.423    -0.544     0.200
    45.451     3.154     0.200
    45.792     0.860     0.200
    45.815    -0.230     0.200
    45.815    -0.027     0.200
    48.816     1.103     0.200
    48.980     1.738     0.200
    48.990     1.664     0.200
    49.112     0.927     0.200
    49.236     1.679     0.200
    49.365     0.795     0.200
    49.571     0.321     0.200
    49.923     1.842     0.200
    50.549     1.500     0.200
    50.751     1.175     0.200
    51.051     1.015     0.200
    52.339     1.695     0.200
    52.624     1.278     0.200
    52.974     1.497     0.200
    53.248     1.477     0.200
    53.537     0.153     0.200
    53.958     0.464     0.200
    53.960     1.149     0.200
    54.030     0.836     0.200
    54.701     1.456     0.200
    56.345     0.533     0.200
    69.507    -2.549     0.200
    73.353    -0.310     0.200
    74.097    -0.439     0.200
    74.325    -0.467     0.200
    74.402     0.460     0.200
    74.474     0.315     0.200
    74.713     0.329     0.200
    75.904     0.128     0.200
    76.459    -0.895     0.200
    76.764    -0.752     0.200
    78.798    -0.584     0.200
    81.182     0.221     0.200
    81.191     0.578     0.200
    83.349     0.381     0.200
    83.350     0.673     0.200
    83.240    -0.760     0.200
    83.813     0.097     0.200
    84.503     0.485     0.200
    85.344    -0.337     0.200
    89.963     0.246     0.200
    90.837     0.079     0.200
    93.834    -0.074     0.200
    94.770     0.527     0.200
    95.594     3.966     0.200
    16.293     4.008     0.200
    22.002     0.553     0.200
    23.560     0.447     0.200
    23.879     3.100     0.200
    31.368     0.975     0.200
    39.083     0.189     0.200
    39.252     0.471     0.200
    39.381     0.599     0.200
    45.894    -0.202     0.200
    45.894     0.598     0.200
    48.861     1.204     0.200
    48.997     1.761     0.200
    49.007     1.686     0.200
    50.643     0.737     0.200
    50.773     1.257     0.200
    50.919     1.061     0.200
    51.075     1.190     0.200
    51.950     1.439     0.200
    56.216     0.305     0.200
    58.161     1.056     0.200
    75.880     1.032     0.200
    76.937    -0.861     0.200
    81.171     0.348     0.200
    83.330     0.446     0.200
    83.400    -0.616     0.200
    18.651    -1.993     0.200
    21.835     0.048     0.200
    22.104     5.571     0.200
    22.129    -0.701     0.200
    23.237     1.573     0.200
    23.245     0.388     0.200
    23.975     2.857     0.200
    28.661     2.086     0.200
    29.352     2.940     0.200
    30.106     2.574     0.200
    30.324     2.307     0.200
    31.032     0.903     0.200
    35.830     0.440     0.200
    37.188     1.970     0.200
    38.854     2.098     0.200
    38.747     0.313     0.200
    38.918     0.864     0.200
    39.006     0.125     0.200
    39.045     0.097     0.200
    42.674     0.558     0.200
    43.583     0.315     0.200
    45.158     2.849     0.200
    45.558    -0.518     0.200
    45.558    -0.221     0.200
    46.017     2.552     0.200
    46.077     1.188     0.200
    47.116     0.925     0.200
    47.659     1.214     0.200
    47.867     2.910     0.200
    48.126     1.385     0.200
    48.455     1.206     0.200
    48.680     1.428     0.200
    48.690     1.353     0.200
    48.811     2.423     0.200
    48.938     1.249     0.200
    49.135     1.838     0.200
    49.396     1.653     0.200
    49.632     2.447     0.200
    50.248     1.866     0.200
    50.322     1.412     0.200
    50.453     0.919     0.200
    50.754     0.853     0.200
    51.630     1.280     0.200
    52.039     1.424     0.200
    52.323     2.717     0.200
    52.327     2.688     0.200
    52.680     1.473     0.200
    52.948     1.189     0.200
    53.145     1.242     0.200
    53.260     1.953     0.200
    53.260     1.492     0.200
    54.176     0.887     0.200
    54.178     1.796     0.200
    54.337     1.821     0.200
    54.400     2.365     0.200
    54.780     2.194     0.200
    54.806     1.317     0.200
    56.113    -0.303     0.200
    56.287    -0.430     0.200
    57.854     1.186     0.200
    74.046     1.036     0.200
    75.955     0.552     0.200
    76.732    -0.862     0.200
    81.484     1.195     0.200
    83.140    -0.315     0.200
    83.647     0.475     0.200
    83.649     0.716     0.200
    83.598     0.375     0.200
    94.616    -0.465     0.200
    15.894     6.645     0.200
    17.849     2.030     0.200
    18.517    -0.406     0.200
    21.417     4.248     0.200
    21.606     0.738     0.200
    21.940     5.229     0.200
    21.940     5.740     0.200
    23.218     0.867     0.200
    23.347     1.503     0.200
    23.321     0.579     0.200
    23.535     1.911     0.200
    23.588     3.822     0.200
    23.627     0.269     0.200
    26.859     2.914     0.200
    27.493     2.820     0.200
    27.838     1.631     0.200
    28.296     1.943     0.200
    28.322    -1.691     0.200
    28.998     2.457     0.200
    29.128     2.150     0.200
    29.576     2.171     0.200
    29.726     1.898     0.200
    31.303     0.415     0.200
    31.265     1.550     0.200
    31.378     2.759     0.200
    31.768     1.629     0.200
    32.541     3.345     0.200
    34.501     4.240     0.200
    34.949     2.596     0.200
    35.283     5.691     0.200
    35.600     3.822     0.200
    35.600     3.815     0.200
    36.110     2.517     0.200
    36.110     2.624     0.200
    36.229     2.564     0.200
    36.654     2.480     0.200
    36.841     0.383     0.200
    36.887     1.896     0.200
    37.444     2.263     0.200
    38.940     0.440     0.200
    39.001     2.657     0.200
    39.102     1.305     0.200
    39.110     1.639     0.200
    39.250     1.073     0.200
    39.578     2.035     0.200
    39.872     0.890     0.200
    40.449     3.105     0.200
    41.458     1.593     0.200
    41.675     1.415     0.200
    41.992     2.122     0.200
    42.060     2.868     0.200
    42.569     1.024     0.200
    42.785     1.021     0.200
    43.014     3.377     0.200
    43.101     2.167     0.200
    43.175     3.072     0.200
    43.281     3.293     0.200
    43.239     0.432     0.200
    43.313     2.390     0.200
    43.562     2.684     0.200
    43.677     3.468     0.200
    43.678     2.750     0.200
    43.723     2.509     0.200
    43.779     2.623     0.200
    43.907     1.942     0.200
    43.973     1.379     0.200
    44.003     1.442     0.200
    44.264     1.447     0.200
    44.326     3.767     0.200
    44.337     2.065     0.200
    44.625     2.540     0.200
    44.679     1.731     0.200
    44.710     3.659     0.200
    44.819     3.459     0.200
    44.821     2.836     0.200
    44.862     4.381     0.200
    44.992     2.239     0.200
    45.009     2.414     0.200
    45.048     2.395     0.200
    45.288     3.265     0.200
    45.300     2.329     0.200
    45.293     3.429     0.200
    45.385     1.727     0.200
    45.351    -0.445     0.200
    45.414    -0.115     0.200
    45.475     3.306     0.200
    45.517    -0.830     0.200
    45.553     2.183     0.200
    45.578     1.790     0.200
    45.567     2.774     0.200
    45.699     3.221     0.200
    45.727     3.222     0.200
    45.756     4.184     0.200
    45.774     0.041     0.200
    45.774    -0.010     0.200
    46.197     1.943     0.200
    46.221     0.518     0.200
    46.392     4.670     0.200
    46.503     1.602     0.200
    46.590     2.158     0.200
    46.701     1.899     0.200
    46.719     1.806     0.200
    46.721     1.595     0.200
    46.868     1.642     0.200
    46.969     1.549     0.200
    47.254     1.233     0.200
    47.280     3.268     0.200
    47.309     1.498     0.200
    47.458     1.041     0.200
    47.473     1.228     0.200
    47.488     1.508     0.200
    47.546     3.196     0.200
    47.568     1.345     0.200
    47.646     1.482     0.200
    47.757     1.117     0.200
    47.768     2.329     0.200
    47.784     1.560     0.200
    47.829     1.103     0.200
    47.849     1.405     0.200
    47.954     2.165     0.200
    48.025     0.845     0.200
    48.026     0.040     0.200
    48.091     1.329     0.200
    48.151     0.363     0.200
    48.163    -0.088     0.200
    48.191     1.359     0.200
    48.254     0.654     0.200
    48.265     1.585     0.200
    48.367     1.302     0.200
    48.371     1.672     0.200
    48.464     1.835     0.200
    48.467     1.828     0.200
    48.536     2.734     0.200
    48.559     0.723     0.200
    48.599     2.332     0.200
    48.733     1.586     0.200
    48.735     0.110     0.200
    48.723     1.860     0.200
    48.752     1.547     0.200
    48.767     1.309     0.200
    48.795     0.291     0.200
    48.806     1.553     0.200
    48.869     1.238     0.200
    48.869     1.713     0.200
    48.873     1.603     0.200
    48.865     0.770     0.200
    48.919     1.951     0.200
    48.964     0.522     0.200
    49.025     1.643     0.200
    49.035     1.471     0.200
    49.070     2.700     0.200
    49.109     1.582     0.200
    49.161     1.004     0.200
    49.274     1.438     0.200
    49.492     0.871     0.200
    49.690     2.607     0.200
    49.719     0.843     0.200
    49.723     1.415     0.200
    49.743    -0.542     0.200
    49.897     1.389     0.200
    49.919     3.027     0.200
    49.942     1.548     0.200
    50.087     2.847     0.200
    50.169     3.022     0.200
    50.372     3.383     0.200
    50.397     2.999     0.200
    50.483     3.189     0.200
    50.595     1.404     0.200
    50.652     0.773     0.200
    50.787     0.955     0.200
    50.929     0.789     0.200
    51.077     1.570     0.200
    51.087     0.902     0.200
    51.342     1.587     0.200
    51.393     2.304     0.200
    51.476     0.781     0.200
    51.496     2.330     0.200
    51.543     2.677     0.200
    51.965     1.331     0.200
    52.667     1.619     0.200
    52.676     1.353     0.200
    52.999     1.968     0.200
    52.997     0.480     0.200
    53.190     3.458     0.200
    53.193     0.240     0.200
    53.290     1.322     0.200
    53.475     0.562     0.200
    53.521     0.329     0.200
    53.571     1.361     0.200
    53.553     0.367     0.200
    53.741     0.913     0.200
    53.743     1.388     0.200
    53.980     0.367     0.200
    54.082     0.421     0.200
    54.339     2.152     0.200
    54.346     2.193     0.200
    54.683     2.153     0.200
    54.752     1.649     0.200
    55.012     2.065     0.200
    55.096     0.460     0.200
    55.134     0.385     0.200
    56.026     1.375     0.200
    56.074     3.029     0.200
    56.209     2.764     0.200
    56.458     1.897     0.200
    56.555     1.049     0.200
    56.997     3.359     0.200
    57.521     2.761     0.200
    57.881     2.433     0.200
    57.900     1.797     0.200
    58.220     1.711     0.200
    58.220     1.058     0.200
    58.632     2.179     0.200
    58.797     2.932     0.200
    58.962     1.583     0.200
    59.071     1.327     0.200
    59.209     1.474     0.200
    59.280     0.685     0.200
    59.441     2.174     0.200
    59.512     2.282     0.200
    59.600     1.873     0.200
    59.831     1.881     0.200
    60.276     0.833     0.200
    60.306     0.822     0.200
    60.314     2.870     0.200
    60.522     1.346     0.200
    60.681     2.267     0.200
    61.021     0.657     0.200
    61.600     1.636     0.200
    61.815     2.184     0.200
    62.046     3.135     0.200
    62.347     2.915     0.200
    62.469     3.199     0.200
    62.477     2.351     0.200
    62.719     1.931     0.200
    73.258     2.058     0.200
    73.909     1.663     0.200
    74.497     2.594     0.200
    74.646     2.622     0.200
    74.994     0.757     0.200
    75.916     0.464     0.200
    75.764     0.013     0.200
    76.288     1.494     0.200
    76.250    -0.309     0.200
    76.556    -0.823     0.200
    78.725    -1.185     0.200
    80.980    -1.417     0.200
    83.064    -0.034     0.200
    83.310    -0.204     0.200
    83.312     0.537     0.200
    83.721     0.431     0.200
    84.500     0.717     0.200
    93.803     0.195     0.200
    94.627     0.735     0.200
    98.693     0.437     0.200
    17.829     0.570     0.200
    20.274     0.997     0.200
    21.437     1.115     0.200
    21.603    -0.050     0.200
    21.922    -0.072     0.200
    23.227     1.672     0.200
    23.517     1.830     0.200
    23.332     0.772     0.200
    23.608     5.104     0.200
    27.483     3.164     0.200
    29.705     1.482     0.200
    29.919     1.854     0.200
    29.947     1.929     0.200
    31.282     1.656     0.200
    36.833     0.997     0.200
    38.955     0.855     0.200
    39.122     0.381     0.200
    42.797     1.129     0.200
    43.927     2.226     0.200
    45.561     1.783     0.200
    45.494     3.079     0.200
    45.494     3.086     0.200
    45.790     0.143     0.200
    45.790     0.418     0.200
    46.311     1.335     0.200
    48.578     0.898     0.200
    48.780     1.650     0.200
    48.868     3.173     0.200
    48.889     1.406     0.200
    48.960     1.960     0.200
    48.990     2.230     0.200
    49.045     1.917     0.200
    49.054     1.741     0.200
    49.082     1.926     0.200
    49.181     1.074     0.200
    49.299     1.970     0.200
    49.294     1.510     0.200
    49.512     1.041     0.200
    49.763     1.129     0.200
    49.938     4.695     0.200
    49.961     1.526     0.200
    50.107     2.117     0.200
    50.392     2.154     0.200
    50.417     1.768     0.200
    50.503     1.718     0.200
    50.671     0.549     0.200
    50.807     1.126     0.200
    50.948     0.861     0.200
    51.097     5.143     0.200
    51.106     0.974     0.200
    51.496     0.952     0.200
    51.516     2.300     0.200
    51.984     1.502     0.200
    52.519     0.690     0.200
    52.687     1.689     0.200
    52.696     1.421     0.200
    53.016     0.453     0.200
    53.210     3.215     0.200
    53.212     0.414     0.200
    53.310     1.492     0.200
    53.540     0.503     0.200
    54.102     0.390     0.200
    54.359     2.198     0.200
    54.672     0.737     0.200
    54.703     2.149     0.200
    54.772     1.615     0.200
    55.115     0.636     0.200
    55.153     0.459     0.200
    56.229     1.023     0.200
    56.573     1.315     0.200
    57.541     3.485     0.200
    57.901     3.240     0.200
    58.240     1.924     0.200
    58.240     1.254     0.200
    59.620     3.087     0.200
    73.268     1.742     0.200
    74.517     1.495     0.200
    74.973     0.757     0.200
    76.297     1.134     0.200
    76.249    -0.113     0.200
    76.556    -1.140     0.200
    83.290     0.568     0.200
    83.292     0.610     0.200
    83.068    -0.135     0.200
    83.734     0.513     0.200
    16.325     5.957     0.200
    21.459     3.535     0.200
    21.877    -0.633     0.200
    23.204     0.785     0.200
    23.311     0.160     0.200
    23.471     2.480     0.200
    23.622     1.856     0.200
    29.868     1.242     0.200
    29.970     2.729     0.200
    31.242     0.693     0.200
    36.783     1.107     0.200
    38.946     0.662     0.200
    39.103     0.223     0.200
    42.779     0.664     0.200
    43.704     1.964     0.200
    43.936     1.198     0.200
    44.289     0.569     0.200
    45.514     1.657     0.200
    45.503     3.002     0.200
    45.502     3.010     0.200
    45.784     0.128     0.200
    46.261     1.723     0.200
    48.588     1.012     0.200
    48.904     1.486     0.200
    49.057     1.910     0.200
    49.067     1.836     0.200
    49.194     1.063     0.200
    49.220     0.949     0.200
    49.305     1.615     0.200
    49.527     1.120     0.200
    49.570     1.995     0.200
    49.754     1.194     0.200
    49.776     0.622     0.200
    50.681     0.665     0.200
    50.818     1.237     0.200
    50.958     0.976     0.200
    51.117     1.087     0.200
    51.495     1.554     0.200
    51.507     1.064     0.200
    51.996     1.514     0.200
    52.699     1.096     0.200
    52.710     1.510     0.200
    53.025     0.586     0.200
    53.220     0.550     0.200
    53.322     1.596     0.200
    53.548     0.636     0.200
    54.116     0.382     0.200
    54.681     0.873     0.200
    54.786     1.709     0.200
    55.123     0.674     0.200
    55.162     0.594     0.200
    56.619     0.782     0.200
    58.256     1.309     0.200
    58.256     1.119     0.200
    73.319     1.871     0.200
    74.556     2.074     0.200
    76.207    -0.282     0.200
    76.348     1.070     0.200
    76.513    -0.591     0.200
    83.032    -0.142     0.200
    83.281     0.378     0.200
    83.717     0.204     0.200
    17.581     2.300     0.200
    17.982     0.912     0.200
    19.038     1.230     0.200
    18.920     0.588     0.200
    19.538     0.773     0.200
    20.320    -0.041     0.200
    20.180     2.207     0.200
    20.180     1.988     0.200
    20.298     2.734     0.200
    20.298     1.672     0.200
    20.440     0.915     0.200
    20.440     1.150     0.200
    21.424     3.561     0.200
    21.694     2.734     0.200
    22.515     0.162     0.200
    22.542     3.079     0.200
    23.694     0.903     0.200
    23.939     3.058     0.200
    23.688     1.461     0.200
    23.778    -0.023     0.200
    23.778    -0.468     0.200
    23.755     1.644     0.200
    25.591     1.924     0.200
    26.106     0.898     0.200
    26.821     0.357     0.200
    27.203     2.858     0.200
    27.049     2.345     0.200
    28.084     2.079     0.200
    28.110     1.313     0.200
    28.300     2.351     0.200
    28.414     1.243     0.200
    28.838     2.159     0.200
    29.257     2.045     0.200
    29.187     2.401     0.200
    29.301     2.303     0.200
    29.959     2.322     0.200
    30.444     0.972     0.200
    31.624     1.135     0.200
    31.555     1.536     0.200
    32.966     3.358     0.200
    33.836     1.775     0.200
    35.696     3.711     0.200
    36.528     1.872     0.200
    36.529     2.586     0.200
    36.940     1.787     0.200
    37.414     1.061     0.200
    38.181     2.781     0.200
    38.978     1.565     0.200
    38.937     3.931     0.200
    39.281     0.824     0.200
    39.452     1.714     0.200
    39.729     2.410     0.200
    40.194     0.950     0.200
    39.939     2.366     0.200
    40.103     1.304     0.200
    41.003     3.366     0.200
    41.151     2.550     0.200
    41.536     2.108     0.200
    41.594     2.710     0.200
    41.695     3.179     0.200
    41.813     3.017     0.200
    42.378     3.405     0.200
    42.336     2.351     0.200
    42.367     2.098     0.200
    42.538     2.806     0.200
    43.035    -0.428     0.200
    42.907     2.410     0.200
    43.041     2.747     0.200
    43.211     1.501     0.200
    43.211     1.439     0.200
    43.220     2.402     0.200
    43.479     2.184     0.200
    43.657     1.057     0.200
    43.670     2.690     0.200
    43.727     1.682     0.200
    43.766     2.135     0.200
    43.766     4.705     0.200
    43.857     2.347     0.200
    44.057     2.154     0.200
    44.127     1.281     0.200
    44.358     1.927     0.200
    44.448     1.603     0.200
    44.451     1.978     0.200
    44.822     2.524     0.200
    44.828     1.846     0.200
    45.306     0.518     0.200
    45.339     2.513     0.200
    45.581     0.997     0.200
    45.638     2.745     0.200
    45.637     2.752     0.200
    45.892    -1.758     0.200
    45.664     2.045     0.200
    45.727     0.483     0.200
    45.901     3.126     0.200
    45.900     1.077     0.200
    46.097    -0.082     0.200
    46.015     2.916     0.200
    46.086     0.107     0.200
    46.086     0.357     0.200
    46.135     3.043     0.200
    46.219     2.066     0.200
    46.838     1.499     0.200
    46.731     1.068     0.200
    46.734     1.421     0.200
    46.774     0.105     0.200
    46.794     1.113     0.200
    46.845     0.752     0.200
    47.003     2.774     0.200
    47.211     2.497     0.200
    47.375     1.911     0.200
    47.681     0.710     0.200
    47.706     2.341     0.200
    47.925     1.349     0.200
    47.924     2.650     0.200
    48.089    -0.319     0.200
    48.089    -0.124     0.200
    48.330     2.720     0.200
    48.340     0.938     0.200
    48.508     2.240     0.200
    48.700     1.163     0.200
    48.919     1.772     0.200
    48.957     0.587     0.200
    49.010     1.091     0.200
    49.136     1.321     0.200
    49.146     1.448     0.200
    49.218     1.997     0.200
    49.262     0.562     0.200
    49.266     1.565     0.200
    49.724     1.393     0.200
    49.717     2.086     0.200
    49.794     1.698     0.200
    50.701     1.128     0.200
    50.790     0.956     0.200
    50.918     0.995     0.200
    51.065     1.083     0.200
    51.220     1.124     0.200
    51.608     1.017     0.200
    52.094     1.491     0.200
    52.495     1.316     0.200
    52.769     0.794     0.200
    53.159     0.910     0.200
    53.357     0.954     0.200
    53.406     1.393     0.200
    53.613     0.875     0.200
    53.634     2.723     0.200
    53.682     0.871     0.200
    54.175     0.466     0.200
    54.409     3.406     0.200
    54.604     1.152     0.200
    54.765     1.378     0.200
    54.816     1.208     0.200
    54.846     1.286     0.200
    55.261     0.995     0.200
    55.294     0.950     0.200
    55.868    -0.542     0.200
    56.865     0.214     0.200
    57.930    -0.937     0.200
    58.281    -0.306     0.200
    58.286     0.975     0.200
    58.286     0.256     0.200
    58.467    -2.000     0.200
    59.108    -2.227     0.200
    59.253    -0.632     0.200
    59.308     1.318     0.200
    59.319    -1.273     0.200
    59.490     0.472     0.200
    59.671     0.526     0.200
    59.882    -2.068     0.200
    60.604     1.806     0.200
    60.694     1.571     0.200
    60.738     2.197     0.200
    60.882     0.814     0.200
    60.761     1.739     0.200
    60.949    -2.332     0.200
    61.511     1.954     0.200
    61.633    -1.171     0.200
    61.636     1.907     0.200
    61.723     3.718     0.200
    63.582     1.731     0.200
    72.701     1.469     0.200
    73.772     0.976     0.200
    74.246     0.428     0.200
    74.476    -0.732     0.200
    74.945     1.147     0.200
    75.724     1.293     0.200
    76.291     0.667     0.200
    76.839    -0.841     0.200
    77.145    -1.086     0.200
    77.556    -0.446     0.200
    78.569    -0.528     0.200
    79.299    -0.419     0.200
    79.316    -0.336     0.200
    79.336    -0.447     0.200
    80.552     0.551     0.200
    81.038     0.858     0.200
    81.047     1.005     0.200
    81.047     0.757     0.200
    83.188     1.225     0.200
    83.620     0.045     0.200
    84.136     0.042     0.200
    86.178     0.986     0.200
    89.863     0.533     0.200
    15.459     5.281     0.200
    17.592     2.149     0.200
    17.592     1.923     0.200
    18.001     1.038     0.200
    18.924     0.164     0.200
    19.543     0.947     0.200
    19.543     0.619     0.200
    21.407     1.125     0.200
    23.961     2.861     0.200
    23.777    -0.835     0.200
    39.274     0.061     0.200
    39.446     1.353     0.200
    43.208     0.572     0.200
    44.043     1.684     0.200
    46.078     0.439     0.200
    46.078     0.361     0.200
    46.984     2.713     0.200
    58.270     0.779     0.200
    76.299     0.265     0.200
    76.299    -0.149     0.200
    76.849    -0.100     0.200
    77.155    -0.875     0.200
    81.054    -0.303     0.200
    83.202     0.669     0.200
    83.626    -0.224     0.200
    17.246     2.709     0.200
    18.106     0.360     0.200
    18.106     0.760     0.200
    19.166     0.823     0.200
    20.507    -1.706     0.200
    21.216     4.526     0.200
    21.216     4.924     0.200
    21.881     0.480     0.200
    22.187     0.011     0.200
    23.433     1.015     0.200
    23.869     2.660     0.200
    25.457     0.592     0.200
    26.026     3.429     0.200
    27.182     2.303     0.200
    27.819     2.489     0.200
    28.628     1.879     0.200
    29.327     1.747     0.200
    29.831     1.505     0.200
    29.914     1.567     0.200
    29.717     3.111     0.200
    32.043     1.288     0.200
    33.919     1.587     0.200
    35.444     4.208     0.200
    37.158    -1.548     0.200
    38.931     1.092     0.200
    42.909     0.303     0.200
    42.841     0.752     0.200
    45.746     0.191     0.200
    45.746     0.491     0.200
    47.200     3.569     0.200
    47.766     0.266     0.200
    47.854     0.687     0.200
    48.063     1.065     0.200
    48.427     0.656     0.200
    48.877     1.395     0.200
    48.886     1.120     0.200
    49.007    -0.006     0.200
    49.592     0.623     0.200
    50.650     0.897     0.200
    50.950     0.930     0.200
    51.339     1.010     0.200
    52.236     1.318     0.200
    53.925     1.364     0.200
    54.595     0.977     0.200
    58.049     1.847     0.200
    75.173     0.647     0.200
    75.933    -0.415     0.200
    75.933    -0.040     0.200
    76.499    -0.229     0.200
    76.804    -0.454     0.200
    78.952    -0.698     0.200
    81.288     0.876     0.200
    81.297     0.528     0.200
    81.297     0.229     0.200
    83.251    -0.004     0.200
    83.451     0.571     0.200
    83.452     0.711     0.200
    83.768     0.714     0.200
    18.036     2.059     0.200
    18.426    -2.367     0.200
    18.500    -0.321     0.200
    18.500    -0.059     0.200
    18.540    -0.555     0.200
    18.540     0.038     0.200
    21.287     3.379     0.200
    21.287     3.692     0.200
    21.533     0.831     0.200
    21.879     0.680     0.200
    22.189    -0.979     0.200
    22.369     2.404     0.200
    23.358     1.459     0.200
    23.447     0.466     0.200
    23.447     0.849     0.200
    23.503     1.061     0.200
    23.503     0.510     0.200
    23.556     0.376     0.200
    23.816     2.996     0.200
    26.097     0.951     0.200
    28.174     2.812     0.200
    28.598     2.627     0.200
    29.300     2.895     0.200
    29.788     1.867     0.200
    29.788     1.617     0.200
    29.794     1.612     0.200
    30.233     2.333     0.200
    31.283     0.768     0.200
    31.283     0.897     0.200
    31.975     0.982     0.200
    33.986    -0.034     0.200
    35.514     2.926     0.200
    37.242     0.327     0.200
    37.579     0.319     0.200
    38.989     0.557     0.200
    38.989     0.307     0.200
    39.157     0.151     0.200
    42.559    -0.185     0.200
    42.864     1.339     0.200
    42.889     0.482     0.200
    42.889     0.161     0.200
    43.634     2.921     0.200
    43.848     1.063     0.200
    44.223     1.092     0.200
    44.464     0.134     0.200
    45.423     2.535     0.200
    45.422     2.542     0.200
    45.711    -1.744     0.200
    45.805    -0.087     0.200
    45.805    -0.634     0.200
    45.811     0.168     0.200
    46.598     0.988     0.200
    47.924     0.754     0.200
    48.132     1.650     0.200
    48.496     1.242     0.200
    48.779     1.163     0.200
    48.804     1.175     0.200
    48.946     1.780     0.200
    48.956     1.705     0.200
    49.077     0.977     0.200
    49.080     1.161     0.200
    49.204     1.810     0.200
    49.497     2.068     0.200
    49.584     1.811     0.200
    49.662     1.015     0.200
    49.896     2.034     0.200
    50.071     1.307     0.200
    50.514     1.351     0.200
    50.587     1.499     0.200
    50.719     1.410     0.200
    51.019     1.245     0.200
    51.256     1.465     0.200
    51.402     1.677     0.200
    51.408     1.232     0.200
    51.896     1.688     0.200
    52.305     1.847     0.200
    52.588     1.345     0.200
    52.592     1.816     0.200
    52.945     0.909     0.200
    53.142     0.760     0.200
    53.214     1.727     0.200
    53.410     0.888     0.200
    53.468     0.766     0.200
    53.518    -0.154     0.200
    53.995     1.007     0.200
    54.029     1.482     0.200
    54.601     1.091     0.200
    54.665     1.628     0.200
    55.045     0.881     0.200
    58.119     0.761     0.200
    62.862     1.165     0.200
    67.699     1.289     0.200
    72.958     1.267     0.200
    72.958     3.318     0.200
    73.408     1.966     0.200
    74.262     1.752     0.200
    75.949    -0.215     0.200
    75.949     0.066     0.200
    76.811    -0.853     0.200
    80.733    -0.062     0.200
    81.218     0.946     0.200
    83.275    -0.354     0.200
    83.818     0.188     0.200
    85.838     0.275     0.200
    90.006     0.763     0.200
    92.595     0.598     0.200
    18.818     0.392     0.200
    20.498     1.692     0.200
    21.349     0.042     0.200
    21.677    -0.528     0.200
    21.576     2.986     0.200
    23.245     3.297     0.200
    23.227     0.100     0.200
    23.705     1.953     0.200
    29.192     1.764     0.200
    30.093     2.012     0.200
    31.281     1.790     0.200
    34.093     0.796     0.200
    37.359     0.440     0.200
    38.102     2.762     0.200
    38.923     0.900     0.200
    39.081     0.436     0.200
    39.601     1.195     0.200
    42.374    -0.060     0.200
    42.711     0.571     0.200
    45.234    -0.245     0.200
    45.775    -0.347     0.200
    45.775    -0.070     0.200
    45.936    -1.624     0.200
    48.898     1.176     0.200
    49.134     1.713     0.200
    49.143     2.043     0.200
    49.275     1.736     0.200
    50.235     0.024     0.200
    50.886     0.605     0.200
    53.450     0.323     0.200
    56.339     0.212     0.200
    64.421     0.861     0.200
    74.749     0.930     0.200
    76.581     1.941     0.200
    81.016     0.992     0.200
    82.877    -0.734     0.200
    92.197     0.309     0.200
    17.919     1.744     0.200
    21.015     0.595     0.200
    28.838     0.841     0.200
    34.113     0.935     0.200
    38.841     0.577     0.200
    42.563     1.273     0.200
    42.563     0.402     0.200
    45.711    -0.863     0.200
    45.711     0.215     0.200
    66.070     0.998     0.200
    83.156     0.679     0.200
    18.323     1.353     0.200
    21.609     0.568     0.200
    21.625     0.374     0.200
    21.625     0.394     0.200
    29.521     1.247     0.200
    33.975     0.560     0.200
    42.750     0.899     0.200
    45.731    -0.178     0.200
    65.525     0.203     0.200
    81.182     1.779     0.200
    83.048    -0.312     0.200
    83.362    -0.381     0.200
    15.152     5.924     0.200
    15.152     5.093     0.200
    21.917     0.099     0.200
    21.933    -0.051     0.200
    23.726     0.204     0.200
    46.012    -0.100     0.200
    65.533    -0.614     0.200
    83.160     0.227     0.200
    15.477     5.681     0.200
    17.653     4.100     0.200
    18.032     2.303     0.200
    18.051     4.073     0.200
    18.201     3.223     0.200
    18.468     0.021     0.200
    18.449     0.651     0.200
    18.449     1.026     0.200
    18.530    -1.169     0.200
    18.759     0.599     0.200
    18.821     0.874     0.200
    18.821     0.132     0.200
    18.854     0.082     0.200
    18.854     0.230     0.200
    18.854     0.543     0.200
    18.943    -2.591     0.200
    19.480     1.947     0.200
    19.833     2.419     0.200
    19.852     2.243     0.200
    19.972     2.256     0.200
    20.797     0.683     0.200
    20.957     4.050     0.200
    20.957     3.550     0.200
    21.246     2.936     0.200
    21.549     2.896     0.200
    21.684     3.939     0.200
    21.830     1.979     0.200
    21.823     4.473     0.200
    22.094     2.942     0.200
    22.098     3.932     0.200
    22.342    -0.611     0.200
    22.345     2.391     0.200
    22.369     3.479     0.200
    22.481     1.508     0.200
    22.616    -0.420     0.200
    22.578     4.780     0.200
    22.784     0.401     0.200
    23.041     1.472     0.200
    23.220     4.230     0.200
    23.225     3.601     0.200
    23.247     1.302     0.200
    23.317     3.751     0.200
    23.376     3.617     0.200
    23.443     2.809     0.200
    23.519     1.852     0.200
    23.502     4.214     0.200
    23.580     0.770     0.200
    23.580     0.466     0.200
    23.881     2.075     0.200
    24.177     4.356     0.200
    24.365     3.392     0.200
    24.395     2.856     0.200
    24.799     1.728     0.200
    24.815     0.109     0.200
    25.137     3.442     0.200
    25.254     0.794     0.200
    25.289     3.058     0.200
    25.727     2.706     0.200
    25.727     2.502     0.200
    25.946     3.312     0.200
    26.440     2.880     0.200
    26.613     1.986     0.200
    26.860     1.664     0.200
    26.896     1.536     0.200
    26.868     2.474     0.200
    27.108     1.427     0.200
    27.269     2.154     0.200
    27.295     2.737     0.200
    27.311     3.318     0.200
    27.656     1.911     0.200
    27.719     2.934     0.200
    27.870     2.302     0.200
    28.049     2.203     0.200
    28.254     1.768     0.200
    28.325     2.342     0.200
    28.562     2.829     0.200
    28.518     2.310     0.200
    28.566     2.570     0.200
    28.662     3.177     0.200
    28.767     2.138     0.200
    28.877     2.235     0.200
    29.139     1.605     0.200
    29.392     3.201     0.200
    29.442     1.709     0.200
    29.442     1.967     0.200
    29.455     2.095     0.200
    29.573     3.151     0.200
    29.602     2.154     0.200
    29.658     2.779     0.200
    29.743     2.945     0.200
    29.835     1.526     0.200
    29.843     1.984     0.200
    29.953     0.984     0.200
    29.953     2.172     0.200
    29.953     1.687     0.200
    29.953     1.789     0.200
    29.957     2.054     0.200
    29.957     2.257     0.200
    30.000     2.000     0.200
    30.000     1.672     0.200
    30.164     0.910     0.200
    30.164     1.270     0.200
    30.091     2.366     0.200
    30.091     2.905     0.200
    30.346     2.006     0.200
    30.411     1.637     0.200
    30.650     3.131     0.200
    30.673     1.084     0.200
    30.785     1.653     0.200
    30.785     2.067     0.200
    30.785     1.536     0.200
    31.208     1.602     0.200
    31.208     0.703     0.200
    31.424    -2.265     0.200
    31.601     1.627     0.200
    32.084     1.690     0.200
    32.216     2.037     0.200
    32.209     1.375     0.200
    32.344     3.817     0.200
    32.435     2.320     0.200
    32.687     1.971     0.200
    32.739     1.411     0.200
    32.806     2.516     0.200
    32.907    -0.610     0.200
    33.213     2.110     0.200
    33.285     1.304     0.200
    33.380     2.847     0.200
    33.404     0.341     0.200
    33.430     0.009     0.200
    33.458     1.312     0.200
    33.576     2.738     0.200
    33.732     2.386     0.200
    33.811     1.395     0.200
    33.813     1.102     0.200
    33.816     1.051     0.200
    33.811     0.590     0.200
    33.614     3.676     0.200
    34.020     2.079     0.200
    34.000     1.569     0.200
    34.078     1.848     0.200
    34.136     2.180     0.200
    34.235     3.720     0.200
    34.280     3.021     0.200
    34.526     2.799     0.200
    34.728     3.140     0.200
    34.782     3.086     0.200
    34.903     1.231     0.200
    34.834     2.228     0.200
    34.978     1.087     0.200
    35.004     0.433     0.200
    35.159     1.327     0.200
    35.201     2.364     0.200
    35.200     0.669     0.200
    35.208     1.808     0.200
    35.253     3.435     0.200
    35.253     3.614     0.200
    35.273     0.867     0.200
    35.423    -2.141     0.200
    35.636     0.026     0.200
    35.668     3.150     0.200
    35.794     1.670     0.200
    35.807     0.160     0.200
    35.818     1.260     0.200
    35.880     2.328     0.200
    35.880     2.227     0.200
    35.908     2.485     0.200
    35.922     2.006     0.200
    35.934    -0.331     0.200
    36.024     0.498     0.200
    36.024     0.802     0.200
    36.155     1.679     0.200
    36.171     3.044     0.200
    36.190     2.265     0.200
    36.308     2.065     0.200
    36.274     1.262     0.200
    36.402     1.265     0.200
    36.774     1.888     0.200
    36.781     2.627     0.200
    36.807     2.711     0.200
    36.816     1.828     0.200
    36.848     0.583     0.200
    36.848     1.560     0.200
    36.878     1.729     0.200
    36.947     2.922     0.200
    36.890     1.808     0.200
    36.968     0.143     0.200
    37.055     2.193     0.200
    37.177     1.461     0.200
    37.206     2.322     0.200
    37.214     1.342     0.200
    37.242     1.813     0.200
    37.304     0.984     0.200
    37.363     1.288     0.200
    37.376     1.070     0.200
    37.402     2.956     0.200
    37.484     0.460     0.200
    37.480     2.000     0.200
    37.504     0.796     0.200
    37.516     1.194     0.200
    37.559     2.627     0.200
    37.586     1.875     0.200
    37.586     0.601     0.200
    37.747     2.740     0.200
    37.764     2.187     0.200
    37.764     2.390     0.200
    37.764     0.093     0.200
    37.887     1.451     0.200
    37.882    -0.812     0.200
    37.946     1.556     0.200
    37.983     2.144     0.200
    38.125     0.444     0.200
    38.127    -1.672     0.200
    38.155     0.792     0.200
    38.280     2.639     0.200
    38.424     1.425     0.200
    38.383     3.869     0.200
    38.400    -0.174     0.200
    38.494     2.028     0.200
    38.514     1.166     0.200
    38.647     0.653     0.200
    38.840    -0.168     0.200
    38.969     0.609     0.200
    38.969     0.791     0.200
    39.036     0.187     0.200
    39.046    -0.097     0.200
    39.148     0.049     0.200
    39.225     2.606     0.200
    39.278     1.866     0.200
    39.314     2.565     0.200
    39.314     2.362     0.200
    39.310     3.102     0.200
    39.467     1.792     0.200
    39.510     2.328     0.200
    39.510     2.828     0.200
    39.510     3.125     0.200
    39.512     4.308     0.200
    39.689     1.737     0.200
    39.689     2.299     0.200
    39.707    -1.122     0.200
    39.814     1.394     0.200
    39.814     0.894     0.200
    39.964     3.844     0.200
    39.996     3.678     0.200
    40.076     0.317     0.200
    40.093     3.475     0.200
    40.232     2.118     0.200
    40.521     3.131     0.200
    40.655     1.523     0.200
    40.607     3.616     0.200
    40.734     2.170     0.200
    40.764     3.221     0.200
    41.119     2.502     0.200
    41.119     2.400     0.200
    41.169     3.692     0.200
    41.336     0.044     0.200
    41.272     1.041     0.200
    41.272     1.963     0.200
    41.283     2.151     0.200
    41.539     2.244     0.200
    41.649     2.650     0.200
    41.727     2.221     0.200
    41.727     2.510     0.200
    41.760     2.437     0.200
    41.922     2.808     0.200
    41.957     2.026     0.200
    41.957     1.729     0.200
    42.031     1.934     0.200
    42.012     1.784     0.200
    42.125     2.451     0.200
    42.222     2.072     0.200
    42.305     1.290     0.200
    42.451     2.701     0.200
    42.474     1.933     0.200
    42.483     0.951     0.200
    42.601     2.436     0.200
    42.651     0.968     0.200
    42.651     0.070     0.200
    42.840     3.134     0.200
    42.913     2.040     0.200
    42.839     1.869     0.200
    42.975     0.887     0.200
    42.975     0.817     0.200
    43.046     2.765     0.200
    43.055     1.569     0.200
    43.055     1.991     0.200
    43.063     2.428     0.200
    43.133     2.465     0.200
    43.182     2.141     0.200
    43.298     1.806     0.200
    43.325     0.054     0.200
    43.325     1.117     0.200
    43.420     0.741     0.200
    43.412     0.720     0.200
    43.446     2.299     0.200
    43.446     2.635     0.200
    43.578     1.767     0.200
    43.578     1.439     0.200
    43.634     2.218     0.200
    43.634     1.148     0.200
    43.705     1.743     0.200
    43.705     1.407     0.200
    43.798     1.793     0.200
    43.820     2.925     0.200
    43.968     1.935     0.200
    44.041     2.146     0.200
    44.041     2.045     0.200
    44.164     1.759     0.200
    44.294     1.911     0.200
    44.394     2.717     0.200
    44.402     0.895     0.200
    44.407     2.915     0.200
    44.452     2.855     0.200
    44.462     3.070     0.200
    44.478     2.745     0.200
    44.492     2.633     0.200
    44.537     2.673     0.200
    44.619     2.424     0.200
    44.563     1.183     0.200
    44.578     3.147     0.200
    44.587     2.574     0.200
    44.633     3.201     0.200
    44.813     2.370     0.200
    44.927     2.663     0.200
    44.949     0.918     0.200
    44.949     0.089     0.200
    45.059     1.416     0.200
    45.134     2.405     0.200
    45.115     1.068     0.200
    45.149     0.896     0.200
    45.220     3.236     0.200
    45.221     2.025     0.200
    45.282     2.037     0.200
    45.428     1.910     0.200
    45.428     2.254     0.200
    45.469     0.660     0.200
    45.551     0.540     0.200
    45.719     2.077     0.200
    45.674     2.431     0.200
    45.686     0.892     0.200
    45.692     2.395     0.200
    45.804     2.579     0.200
    45.753     0.216     0.200
    45.753     0.239     0.200
    45.755     0.857     0.200
    45.865     2.165     0.200
    45.824     2.348     0.200
    45.946     2.190     0.200
    46.041     2.498     0.200
    46.045    -0.544     0.200
    46.116     1.761     0.200
    46.268     1.248     0.200
    46.313    -0.806     0.200
    46.303     1.014     0.200
    46.410     1.186     0.200
    46.360     1.381     0.200
    46.410     1.185     0.200
    46.385     0.398     0.200
    46.385    -0.469     0.200
    46.403     2.687     0.200
    46.611     2.256     0.200
    46.611     2.154     0.200
    46.687     2.528     0.200
    46.687     3.324     0.200
    46.762     1.823     0.200
    46.793     2.725     0.200
    46.949     2.006     0.200
    47.228     1.433     0.200
    47.228     2.230     0.200
    47.270     2.308     0.200
    47.287     2.573     0.200
    47.498     1.629     0.200
    47.503     2.389     0.200
    47.581     2.884     0.200
    47.626     2.332     0.200
    47.639     0.532     0.200
    47.731     1.918     0.200
    47.881     0.959     0.200
    47.903     1.752     0.200
    47.913     2.004     0.200
    47.916     1.287     0.200
    47.967     3.076     0.200
    48.030     1.104     0.200
    48.018     2.000     0.200
    48.018     1.695     0.200
    48.082     2.005     0.200
    48.161    -0.813     0.200
    48.180     1.315     0.200
    48.273     0.922     0.200
    48.355     1.690     0.200
    48.403     1.523     0.200
    48.492     2.138     0.200
    48.492     0.730     0.200
    48.503     2.434     0.200
    48.503     2.051     0.200
    48.503     2.848     0.200
    48.511     0.989     0.200
    48.556     0.081     0.200
    48.571    -0.654     0.200
    48.584     1.221     0.200
    48.621    -0.723     0.200
    48.615     2.186     0.200
    48.697     1.554     0.200
    48.707     1.477     0.200
    48.752     2.837     0.200
    48.794     2.211     0.200
    48.819     0.116     0.200
    48.826     1.271     0.200
    48.836     2.195     0.200
    48.921     1.835     0.200
    48.920     1.641     0.200
    48.961     1.859     0.200
    48.968     1.575     0.200
    49.028     2.274     0.200
    49.028     1.867     0.200
    49.131     0.433     0.200
    49.190     1.478     0.200
    49.304     2.104     0.200
    49.433    -0.482     0.200
    49.372     1.885     0.200
    49.407     1.909     0.200
    49.416     1.842     0.200
    49.424     1.381     0.200
    49.441     1.155     0.200
    49.451     2.124     0.200
    49.513     3.344     0.200
    49.550     1.173     0.200
    49.597     2.320     0.200
    49.743     1.754     0.200
    49.743     2.105     0.200
    49.703     1.959     0.200
    49.807     0.966     0.200
    49.995     2.269     0.200
    49.995     1.535     0.200
    50.151     0.523     0.200
    50.261     1.117     0.200
    50.268     2.066     0.200
    50.424     2.727     0.200
    50.363     0.952     0.200
    50.541     2.750     0.200
    50.487     1.205     0.200
    50.637     1.076     0.200
    50.674     1.989     0.200
    50.674     1.098     0.200
    50.674     1.793     0.200
    50.790     1.019     0.200
    50.952     2.284     0.200
    51.025     3.150     0.200
    51.025     2.666     0.200
    50.997     1.168     0.200
    51.084     2.010     0.200
    51.173     1.342     0.200
    51.177     1.007     0.200
    51.179     1.594     0.200
    51.230     2.315     0.200
    51.485     1.054     0.200
    51.663     1.471     0.200
    52.032     2.335     0.200
    52.058     1.627     0.200
    52.324     0.944     0.200
    52.350     1.657     0.200
    52.593     0.959     0.200
    52.741     0.952     0.200
    52.922     1.172     0.200
    52.940     0.878     0.200
    52.969     1.369     0.200
    53.134     0.883     0.200
    53.185     0.781     0.200
    53.326     2.363     0.200
    53.263     0.806     0.200
    53.407     1.691     0.200
    53.395     0.864     0.200
    53.400     0.450     0.200
    53.583     0.214     0.200
    53.731     0.168     0.200
    53.878    -0.234     0.200
    53.921     0.670     0.200
    53.939    -0.729     0.200
    54.180     0.794     0.200
    54.237     0.526     0.200
    54.398     1.296     0.200
    54.402     1.072     0.200
    54.576     0.498     0.200
    54.580     0.475     0.200
    54.581     1.375     0.200
    54.542     0.702     0.200
    54.559     0.716     0.200
    54.577     0.286     0.200
    54.834     2.436     0.200
    54.844     0.959     0.200
    54.875     0.640     0.200
    55.717     0.364     0.200
    56.709     0.482     0.200
    56.782     0.857     0.200
    56.973     0.505     0.200
    57.758     1.515     0.200
    57.758     4.101     0.200
    57.748    -1.865     0.200
    57.833     0.618     0.200
    58.158     0.956     0.200
    58.841     1.394     0.200
    59.097     1.913     0.200
    59.520     1.383     0.200
    59.987     1.474     0.200
    60.112     2.115     0.200
    60.157     3.208     0.200
    60.191     2.824     0.200
    60.292     1.678     0.200
    60.311     2.252     0.200
    60.400     2.145     0.200
    60.987    -0.487     0.200
    60.987    -1.346     0.200
    61.028     0.466     0.200
    61.062     3.236     0.200
    61.230     0.892     0.200
    61.265     0.361     0.200
    62.973     0.989     0.200
    62.973     1.692     0.200
    63.279     1.770     0.200
    63.279     1.551     0.200
    63.279     2.332     0.200
    64.862    -0.924     0.200
    64.862    -0.635     0.200
    67.885     2.376     0.200
    69.605     1.775     0.200
    70.689    -1.449     0.200
    70.993     0.935     0.200
    71.558     0.212     0.200
    72.072     0.239     0.200
    72.386     1.425     0.200
    72.408     2.121     0.200
    72.428     1.519     0.200
    72.428     1.332     0.200
    72.580     0.778     0.200
    72.857     1.426     0.200
    72.857     1.051     0.200
    73.004     0.237     0.200
    73.768    -1.286     0.200
    73.768    -0.114     0.200
    73.997     1.299     0.200
    74.202     0.850     0.200
    74.155    -0.253     0.200
    74.288     0.848     0.200
    74.400    -0.327     0.200
    75.465     1.195     0.200
    76.906     0.471     0.200
    77.209    -0.930     0.200
    77.521     0.079     0.200
    77.542    -1.329     0.200
    77.632    -0.501     0.200
    78.040     0.843     0.200
    78.368    -0.053     0.200
    78.798     0.030     0.200
    79.089    -0.559     0.200
    79.372     0.894     0.200
    79.402    -0.769     0.200
    79.419    -0.461     0.200
    79.500    -0.368     0.200
    80.145     1.997     0.200
    80.629    -0.269     0.200
    80.786     1.153     0.200
    80.786     2.192     0.200
    80.786     3.153     0.200
    81.046    -0.054     0.200
    81.485     0.609     0.200
    81.494     0.694     0.200
    81.494     0.490     0.200
    81.876     0.254     0.200
    82.357    -0.278     0.200
    83.506    -0.719     0.200
    83.574    -0.108     0.200
    83.623     0.532     0.200
    83.623     0.640     0.200
    83.885     0.688     0.200
    83.885     0.173     0.200
    84.687     0.110     0.200
    84.776     1.813     0.200
    84.776     1.610     0.200
    86.202     0.537     0.200
    90.329     0.388     0.200
    90.333    -0.059     0.200
    91.169     0.953     0.200
    91.169     0.234     0.200
    91.169     0.352     0.200
    94.088    -0.127     0.200
    94.995     0.417     0.200
    96.563     0.212     0.200
    97.158     0.347     0.200
    97.211     0.435     0.200
    97.225     0.523     0.200
    97.712     0.778     0.200
    97.714     0.344     0.200
    97.759     0.503     0.200
    97.778     0.426     0.200
    97.827    -0.031     0.200
    98.208     0.921     0.200
    98.364     0.222     0.200
    99.018     0.114     0.200
    15.249     8.915     0.200
    15.319     8.536     0.200
    15.467     5.505     0.200
    17.690     2.443     0.200
    18.455     1.598     0.200
    18.479     0.350     0.200
    18.479     1.131     0.200
    18.560     1.366     0.200
    18.789     1.028     0.200
    18.851     1.143     0.200
    18.851     1.455     0.200
    18.883     1.296     0.200
    18.883     1.077     0.200
    19.626    -0.642     0.200
    19.713     2.622     0.200
    19.836     2.690     0.200
    19.975     2.012     0.200
    20.976     2.990     0.200
    21.267     2.950     0.200
    21.815     1.418     0.200
    22.116     3.745     0.200
    22.119     4.180     0.200
    22.390     5.168     0.200
    22.366    -0.323     0.200
    22.466     1.805     0.200
    22.641    -0.245     0.200
    23.064     3.879     0.200
    23.270     2.403     0.200
    23.270     2.809     0.200
    23.550     1.673     0.200
    23.610     1.018     0.200
    23.610     0.620     0.200
    24.368     2.991     0.200
    25.744     3.081     0.200
    25.744     2.940     0.200
    26.641     2.674     0.200
    26.919     2.668     0.200
    27.282     2.736     0.200
    27.730     1.938     0.200
    27.897     3.089     0.200
    28.076     2.396     0.200
    28.342     2.621     0.200
    28.555     1.921     0.200
    28.778     2.538     0.200
    29.154     1.500     0.200
    29.460     1.965     0.200
    29.460     1.887     0.200
    29.478     3.728     0.200
    29.553     5.854     0.200
    29.851     1.717     0.200
    29.934     1.390     0.200
    30.008     1.858     0.200
    30.145     1.716     0.200
    30.358     1.755     0.200
    30.631     2.730     0.200
    30.797     0.740     0.200
    31.236     2.481     0.200
    32.082     1.743     0.200
    32.323     3.830     0.200
    32.425     2.136     0.200
    32.478     4.665     0.200
    33.385    -0.262     0.200
    33.755     2.117     0.200
    33.837     1.402     0.200
    33.838     1.328     0.200
    33.841     1.159     0.200
    33.837     1.402     0.200
    34.001     2.680     0.200
    34.505     4.206     0.200
    34.751     2.876     0.200
    34.804     3.221     0.200
    34.857     2.062     0.200
    34.885     2.318     0.200
    35.275     3.353     0.200
    35.690     2.989     0.200
    35.932     2.112     0.200
    35.946     2.196     0.200
    36.040     1.491     0.200
    36.040     1.390     0.200
    36.193     2.378     0.200
    36.364     0.617     0.200
    36.804     2.665     0.200
    36.863     0.830     0.200
    36.957     1.960     0.200
    37.037     0.280     0.200
    37.037     2.483     0.200
    37.406     2.550     0.200
    37.502     2.735     0.200
    37.514     0.232     0.200
    37.582     2.558     0.200
    37.770     3.063     0.200
    37.770     2.961     0.200
    37.789     2.612     0.200
    37.789     2.253     0.200
    37.789     2.511     0.200
    37.863     2.586     0.200
    37.970     3.978     0.200
    38.007     2.870     0.200
    38.219     4.532     0.200
    38.302     2.881     0.200
    38.538     4.190     0.200
    38.999     0.875     0.200
    39.177     0.234     0.200
    39.334     3.320     0.200
    39.497     3.163     0.200
    39.534     2.256     0.200
    39.534     2.858     0.200
    39.714     2.257     0.200
    40.256     3.147     0.200
    40.388     2.461     0.200
    40.653     1.173     0.200
    40.759     2.092     0.200
    41.143     2.526     0.200
    41.193     4.120     0.200
    41.247     0.925     0.200
    41.247     0.472     0.200
    41.751     2.334     0.200
    41.783     2.377     0.200
    41.947     2.831     0.200
    41.982     2.048     0.200
    41.982     2.149     0.200
    42.150     2.880     0.200
    42.246     1.980     0.200
    42.311     2.262     0.200
    42.682     1.447     0.200
    42.862     2.182     0.200
    43.006     0.719     0.200
    43.074     1.444     0.200
    43.071     2.289     0.200
    43.088     2.361     0.200
    43.322     1.880     0.200
    43.343     1.352     0.200
    43.428     2.802     0.200
    43.471     2.425     0.200
    43.658     2.554     0.200
    43.658     1.656     0.200
    43.730     0.578     0.200
    43.730     1.976     0.200
    43.845     2.550     0.200
    44.066     2.068     0.200
    44.318     3.151     0.200
    44.419     2.650     0.200
    44.432     2.044     0.200
    44.430     0.964     0.200
    44.477     2.484     0.200
    44.483     0.841     0.200
    44.503     2.373     0.200
    44.517     2.558     0.200
    44.586     1.896     0.200
    44.602     2.879     0.200
    44.612     2.203     0.200
    44.658     2.238     0.200
    44.838     1.395     0.200
    44.952     2.292     0.200
    45.138     1.107     0.200
    45.244     2.969     0.200
    45.492     0.504     0.200
    45.700     2.158     0.200
    45.718     1.513     0.200
    45.778     0.897     0.200
    45.781     0.215     0.200
    45.781     0.511     0.200
    45.850     2.073     0.200
    46.140     2.062     0.200
    46.277     0.209     0.200
    46.326     1.164     0.200
    46.334    -0.840     0.200
    46.384     0.385     0.200
    46.413     1.235     0.200
    46.414     1.234     0.200
    46.673     2.800     0.200
    46.635     1.291     0.200
    46.635     1.994     0.200
    46.785     1.070     0.200
    47.252     0.471     0.200
    47.296     2.434     0.200
    47.652     2.063     0.200
    47.940     1.825     0.200
    48.033     0.925     0.200
    48.038     1.567     0.200
    48.203     0.681     0.200
    48.227    -0.495     0.200
    48.297     0.760     0.200
    48.517     2.246     0.200
    48.528     2.461     0.200
    48.528     1.984     0.200
    48.533     0.646     0.200
    48.608     1.167     0.200
    48.720     1.502     0.200
    48.730     1.331     0.200
    48.842    -0.434     0.200
    48.945     1.679     0.200
    48.986     1.985     0.200
    48.992     1.620     0.200
    49.045     1.520     0.200
    49.045     1.911     0.200
    49.152     0.388     0.200
    49.296     1.185     0.200
    49.329     2.239     0.200
    49.396     1.729     0.200
    49.430     1.766     0.200
    49.448     1.421     0.200
    49.445     0.450     0.200
    49.476     2.228     0.200
    49.622     3.681     0.200
    49.721     1.797     0.200
    49.728     2.196     0.200
    49.829     1.224     0.200
    50.284     1.170     0.200
    50.386     0.793     0.200
    50.511     1.158     0.200
    50.660     1.027     0.200
    50.814     1.065     0.200
    51.006     2.436     0.200
    51.019     1.325     0.200
    51.201     1.062     0.200
    51.203     1.545     0.200
    51.686     1.519     0.200
    52.080     1.383     0.200
    52.346     1.011     0.200
    52.766     0.900     0.200
    52.965     0.928     0.200
    52.992     1.321     0.200
    53.208     0.728     0.200
    53.287     0.849     0.200
    53.753     1.135     0.200
    54.424     1.134     0.200
    54.423     1.145     0.200
    54.581     1.094     0.200
    54.584     0.766     0.200
    54.586     0.862     0.200
    54.868     1.011     0.200
    56.740    -0.014     0.200
    56.803     1.933     0.200
    56.984     0.750     0.200
    57.854    -0.386     0.200
    58.871     2.304     0.200
    61.052     0.528     0.200
    61.286    -0.366     0.200
    63.004     1.913     0.200
    63.004     2.108     0.200
    63.265     1.035     0.200
    64.869    -0.713     0.200
    64.869    -0.440     0.200
    67.867     1.824     0.200
    69.636     1.009     0.200
    71.018     0.880     0.200
    72.054     0.005     0.200
    72.390     2.010     0.200
    72.411     1.683     0.200
    72.411     1.495     0.200
    72.986     0.695     0.200
    73.775    -0.206     0.200
    73.978     0.531     0.200
    74.161    -0.766     0.200
    74.178     0.675     0.200
    74.270    -0.231     0.200
    74.426     0.096     0.200
    75.448     0.859     0.200
    75.448     1.046     0.200
    76.328     0.261     0.200
    76.932     0.344     0.200
    77.236    -1.181     0.200
    77.547    -0.206     0.200
    77.568     0.127     0.200
    77.658    -0.125     0.200
    78.395    -0.290     0.200
    78.825    -0.508     0.200
    79.444     0.217     0.200
    80.769     1.768     0.200
    81.463     0.802     0.200
    81.472     0.629     0.200
    81.472     0.426     0.200
    81.656    -0.721     0.200
    83.535    -0.294     0.200
    83.600     0.780     0.200
    83.600     0.500     0.200
    83.603    -0.143     0.200
    83.915     0.437     0.200
    90.310     0.365     0.200
    94.064     0.073     0.200
    16.964     2.894     0.200
    46.146    -0.313     0.200
    65.942     0.520     0.200
    80.716    -0.863     0.200
    83.239    -0.405     0.200
    15.326     7.948     0.200
    15.999     4.891     0.200
    16.285     4.805     0.200
    16.515     4.575     0.200
    16.802     2.733     0.200
    18.480     0.510     0.200
    18.494     1.864     0.200
    18.581     0.322     0.200
    18.581     0.103     0.200
    18.871     1.152     0.200
    18.871     1.213     0.200
    18.903     1.025     0.200
    18.903     0.658     0.200
    19.014     1.447     0.200
    19.792     1.905     0.200
    19.931     1.950     0.200
    20.049     1.701     0.200
    20.263     0.457     0.200
    20.714     1.776     0.200
    20.813     0.735     0.200
    21.347     6.276     0.200
    21.771     1.311     0.200
    22.091     2.960     0.200
    22.364     4.111     0.200
    22.401    -1.150     0.200
    22.401    -0.810     0.200
    22.422     1.594     0.200
    22.674    -0.811     0.200
    22.800     2.446     0.200
    23.040     2.314     0.200
    23.246     3.539     0.200
    23.246     4.039     0.200
    23.327     2.188     0.200
    23.560     1.554     0.200
    23.618     1.022     0.200
    23.618     1.422     0.200
    23.847     0.127     0.200
    24.185     0.544     0.200
    24.414     2.952     0.200
    25.251     2.331     0.200
    25.711     3.553     0.200
    25.845     3.893     0.200
    26.899     2.817     0.200
    27.008     3.868     0.200
    27.107     1.745     0.200
    27.170     2.369     0.200
    27.648     2.821     0.200
    27.665     4.543     0.200
    27.691     1.407     0.200
    27.708     2.876     0.200
    27.883     2.691     0.200
    28.062     2.388     0.200
    28.211     2.216     0.200
    28.211     3.157     0.200
    28.347     2.737     0.200
    28.598     2.718     0.200
    28.740     2.350     0.200
    29.429     2.336     0.200
    29.503     0.728     0.200
    29.768     2.525     0.200
    29.967     1.316     0.200
    29.964     1.893     0.200
    29.964     3.693     0.200
    30.080     1.237     0.200
    30.175     1.828     0.200
    30.403     1.712     0.200
    30.842     0.937     0.200
    30.842     1.735     0.200
    31.009     0.162     0.200
    31.227     1.239     0.200
    32.127     1.026     0.200
    32.225     3.060     0.200
    32.465     1.759     0.200
    32.849     2.492     0.200
    32.849     2.193     0.200
    33.152    -0.252     0.200
    33.431    -0.388     0.200
    33.446     2.879     0.200
    33.522     1.691     0.200
    33.639     2.796     0.200
    33.819     1.526     0.200
    33.819     1.125     0.200
    33.846     2.895     0.200
    34.030     1.792     0.200
    34.727     3.656     0.200
    34.780     3.596     0.200
    34.834     2.333     0.200
    34.917     2.616     0.200
    34.958     1.362     0.200
    35.251     4.236     0.200
    35.667     3.063     0.200
    35.910     2.875     0.200
    35.924     2.326     0.200
    36.007     1.745     0.200
    36.146     3.453     0.200
    36.168     2.863     0.200
    36.463     3.745     0.200
    36.779     2.648     0.200
    36.801     2.458     0.200
    36.807     3.110     0.200
    36.828     0.929     0.200
    36.891     2.393     0.200
    36.946     3.830     0.200
    37.027     3.236     0.200
    37.199     2.979     0.200
    37.199     2.479     0.200
    37.204     2.438     0.200
    37.272     3.260     0.200
    37.357     1.435     0.200
    37.477     2.717     0.200
    37.449     2.556     0.200
    37.559     2.628     0.200
    37.566     0.929     0.200
    37.584     1.913     0.200
    37.604    -2.658     0.200
    37.749     2.617     0.200
    37.769     2.549     0.200
    37.769     2.430     0.200
    37.769     2.748     0.200
    37.949     2.426     0.200
    37.986     2.910     0.200
    38.110    -0.230     0.200
    38.269     3.523     0.200
    38.278     2.854     0.200
    38.371     1.570     0.200
    38.387     0.330     0.200
    38.434     1.343     0.200
    38.578     3.128     0.200
    38.634     1.660     0.200
    38.699     3.113     0.200
    38.730     2.154     0.200
    38.993     1.425     0.200
    39.020     0.324     0.200
    39.138     2.131     0.200
    39.165     1.408     0.200
    39.173     1.041     0.200
    39.266     1.659     0.200
    39.314     2.562     0.200
    39.349     2.571     0.200
    39.512     3.311     0.200
    39.512     2.901     0.200
    39.513     1.805     0.200
    39.694     1.589     0.200
    40.023     5.253     0.200
    40.365     2.225     0.200
    40.412     4.266     0.200
    40.412     4.033     0.200
    40.412     1.324     0.200
    40.522     3.124     0.200
    40.607     2.317     0.200
    40.697     0.376     0.200
    40.739     2.528     0.200
    40.765     2.916     0.200
    41.123     2.030     0.200
    41.327    -0.412     0.200
    41.327    -0.811     0.200
    41.267     1.130     0.200
    41.267     0.581     0.200
    41.267     0.843     0.200
    41.625     2.442     0.200
    41.639     1.522     0.200
    41.731     2.974     0.200
    41.928     2.460     0.200
    41.928     2.620     0.200
    41.963     2.072     0.200
    41.963     2.371     0.200
    42.030     2.110     0.200
    42.131     2.704     0.200
    42.224     2.005     0.200
    42.357     1.961     0.200
    42.455     1.964     0.200
    42.475     2.720     0.200
    42.595     4.828     0.200
    42.686     0.083     0.200
    42.766     2.018     0.200
    42.783     1.942     0.200
    42.839     2.317     0.200
    43.009     1.060     0.200
    43.009     1.721     0.200
    43.031     2.983     0.200
    43.045     1.683     0.200
    43.068     2.686     0.200
    43.300     2.020     0.200
    43.453     2.158     0.200
    43.453     2.578     0.200
    43.474     0.904     0.200
    43.564     2.708     0.200
    43.637     1.892     0.200
    43.637     2.191     0.200
    43.637     2.091     0.200
    43.709     1.911     0.200
    43.709     2.040     0.200
    44.048     2.087     0.200
    44.296     1.897     0.200
    44.400     2.668     0.200
    44.413     2.765     0.200
    44.582     3.008     0.200
    44.638     2.961     0.200
    44.614     2.080     0.200
    44.820     2.312     0.200
    45.116     0.560     0.200
    45.130     2.308     0.200
    45.130     2.144     0.200
    45.130     1.605     0.200
    45.224     3.295     0.200
    45.225     2.688     0.200
    45.470     0.935     0.200
    45.687     1.400     0.200
    45.756     1.024     0.200
    45.774     0.043     0.200
    45.774     0.443     0.200
    45.754     2.320     0.200
    45.833     2.376     0.200
    45.905     0.037     0.200
    46.117     3.237     0.200
    46.304     1.207     0.200
    46.459     1.443     0.200
    46.459     1.443     0.200
    46.629     2.711     0.200
    46.629     3.072     0.200
    47.231     3.406     0.200
    47.507     2.252     0.200
    47.634     0.470     0.200
    47.919     0.654     0.200
    48.021     2.168     0.200
    48.084     0.878     0.200
    48.084     0.581     0.200
    48.180     1.454     0.200
    48.261    -0.486     0.200
    48.276     0.897     0.200
    48.357     1.771     0.200
    48.498     2.291     0.200
    48.498     2.682     0.200
    48.508     2.757     0.200
    48.508     2.906     0.200
    48.508     0.807     0.200
    48.587     0.898     0.200
    48.697     1.354     0.200
    48.707     1.277     0.200
    48.797     1.284     0.200
    48.818     1.324     0.200
    48.824     1.772     0.200
    48.925     1.701     0.200
    48.969     1.360     0.200
    49.014     2.109     0.200
    49.014     1.621     0.200
    49.375     1.552     0.200
    49.406     0.617     0.200
    49.428     1.252     0.200
    49.709     2.006     0.200
    49.745     2.222     0.200
    49.745     2.328     0.200
    49.745     1.728     0.200
    50.041     1.858     0.200
    50.260     1.019     0.200
    50.365     0.928     0.200
    50.429     2.950     0.200
    50.429     2.739     0.200
    50.429     1.950     0.200
    50.488     1.092     0.200
    50.638     0.858     0.200
    50.792     0.901     0.200
    50.994     1.175     0.200
    51.037     3.267     0.200
    51.037     3.156     0.200
    51.037     2.206     0.200
    51.664     1.256     0.200
    52.057     1.323     0.200
    52.044     1.646     0.200
    52.321     0.859     0.200
    52.350     1.547     0.200
    52.746     0.712     0.200
    52.945     0.937     0.200
    52.969     0.863     0.200
    53.187     0.858     0.200
    53.267     0.664     0.200
    53.339     3.506     0.200
    53.339     3.834     0.200
    53.339     2.444     0.200
    53.437     1.016     0.200
    53.418     1.280     0.200
    54.399     2.178     0.200
    54.402     1.254     0.200
    54.627     0.825     0.200
    54.630     0.500     0.200
    54.632     1.087     0.200
    54.848     0.718     0.200
    54.879     0.597     0.200
    56.842     1.921     0.200
    56.946     1.089     0.200
    57.827     0.094     0.200
    57.827     1.044     0.200
    59.518     2.794     0.200
    59.964     2.916     0.200
    59.985     2.176     0.200
    60.030     2.764     0.200
    60.153     1.619     0.200
    60.289     2.988     0.200
    60.307     1.565     0.200
    60.395     2.663     0.200
    60.602     0.652     0.200
    61.178     1.336     0.200
    61.260     0.782     0.200
    61.263     2.560     0.200
    62.252    -1.504     0.200
    63.010     1.738     0.200
    63.010     3.138     0.200
    63.221     1.334     0.200
    64.827    -0.738     0.200
    64.827    -0.598     0.200
    69.639     1.947     0.200
    71.561     1.122     0.200
    72.369     1.979     0.200
    73.732     0.104     0.200
    73.807    -0.432     0.200
    73.882    -0.371     0.200
    74.119    -0.259     0.200
    74.200     1.147     0.200
    74.456     0.054     0.200
    74.610    -0.608     0.200
    74.663    -1.056     0.200
    75.406     0.788     0.200
    75.406     0.288     0.200
    76.354    -0.227     0.200
    76.885    -0.271     0.200
    76.962    -0.167     0.200
    77.266    -1.171     0.200
    77.579     0.107     0.200
    77.689     0.060     0.200
    78.424     0.089     0.200
    78.855    -2.513     0.200
    79.398    -0.307     0.200
    79.459    -0.804     0.200
    80.727     1.661     0.200
    81.103     0.032     0.200
    81.488     0.501     0.200
    81.497     0.251     0.200
    81.497     1.251     0.200
    82.728     0.954     0.200
    83.625    -0.040     0.200
    83.623     0.569     0.200
    83.623     0.568     0.200
    83.917     0.291     0.200
    84.677     0.200     0.200
    90.343    -0.035     0.200
    92.944     1.013     0.200
    94.086     1.057     0.200
    94.086    -0.392     0.200
    95.039    -0.311     0.200
    14.929     7.805     0.200
    14.929     6.054     0.200
    15.571     7.685     0.200
    15.746     8.250     0.200
    15.890     7.429     0.200
    15.965     6.927     0.200
    16.169     6.980     0.200
    16.247     4.699     0.200
    16.428     7.094     0.200
    17.501     2.361     0.200
    18.470    -0.450     0.200
    18.470     0.513     0.200
    18.540    -0.469     0.200
    18.504    -0.666     0.200
    18.504     0.132     0.200
    18.504     0.732     0.200
    18.504     1.292     0.200
    19.123     0.432     0.200
    19.605     1.260     0.200
    19.716    -1.446     0.200
    20.331     0.261     0.200
    20.464     1.221     0.200
    20.499     1.377     0.200
    20.501     1.927     0.200
    20.576     0.297     0.200
    21.145     4.446     0.200
    21.145     4.765     0.200
    21.145     4.616     0.200
    21.399     3.310     0.200
    21.498     4.150     0.200
    21.888     3.637     0.200
    21.881    -0.251     0.200
    21.881    -0.076     0.200
    22.048     4.259     0.200
    22.215     3.367     0.200
    22.166     1.000     0.200
    22.263     4.271     0.200
    22.329     1.650     0.200
    22.315     2.477     0.200
    22.508     3.564     0.200
    22.553     3.421     0.200
    22.610     1.678     0.200
    22.835     3.539     0.200
    22.941     3.541     0.200
    22.979     1.996     0.200
    23.126     4.300     0.200
    23.162    -0.729     0.200
    23.159     0.781     0.200
    23.172     4.737     0.200
    23.298     3.150     0.200
    23.262     1.497     0.200
    23.361     1.357     0.200
    23.395     2.905     0.200
    23.398     3.328     0.200
    23.497     3.164     0.200
    23.523     4.101     0.200
    23.553     2.428     0.200
    23.614     2.742     0.200
    23.702     4.615     0.200
    23.631     1.128     0.200
    23.825     3.911     0.200
    23.909     2.487     0.200
    24.350     1.158     0.200
    24.350     0.258     0.200
    24.375     3.725     0.200
    24.996     3.918     0.200
    25.334     3.824     0.200
    25.385     0.538     0.200
    25.516     3.496     0.200
    25.700     3.561     0.200
    26.099     2.610     0.200
    26.142     4.556     0.200
    26.355     3.180     0.200
    26.464     3.726     0.200
    26.495    -1.673     0.200
    26.591     0.623     0.200
    26.687     2.589     0.200
    26.694     3.367     0.200
    26.853     2.659     0.200
    27.124     2.005     0.200
    27.209     0.199     0.200
    27.222     1.241     0.200
    27.244     3.308     0.200
    27.284     0.792     0.200
    27.229     3.079     0.200
    27.303     2.123     0.200
    27.325     0.345     0.200
    27.464     1.886     0.200
    27.513     0.252     0.200
    27.534     3.819     0.200
    27.638     2.999     0.200
    27.640     3.660     0.200
    27.697     3.008     0.200
    27.867    -0.833     0.200
    27.827     2.420     0.200
    27.988     2.984     0.200
    28.044     2.018     0.200
    28.053     0.902     0.200
    28.064    -1.613     0.200
    28.042     0.602     0.200
    28.191     2.473     0.200
    28.543    -0.128     0.200
    28.690     2.718     0.200
    28.641     1.872     0.200
    28.746    -0.688     0.200
    28.769     1.134     0.200
    28.921     2.337     0.200
    29.076     2.459     0.200
    29.085     2.216     0.200
    29.337     1.578     0.200
    29.337     1.988     0.200
    29.448     2.300     0.200
    29.576     2.975     0.200
    29.574     1.989     0.200
    29.647     2.154     0.200
    29.647     2.437     0.200
    29.795     2.695     0.200
    29.769     1.472     0.200
    29.851     2.211     0.200
    29.859     0.948     0.200
    29.985     0.749     0.200
    30.019     0.934     0.200
    30.052     2.245     0.200
    30.170     1.683     0.200
    30.294     2.935     0.200
    30.294     2.385     0.200
    30.308    -2.121     0.200
    30.290     2.147     0.200
    30.290     2.283     0.200
    30.290     1.908     0.200
    30.380     1.294     0.200
    30.827     2.214     0.200
    30.896     1.898     0.200
    31.152     1.141     0.200
    31.152     1.341     0.200
    31.643     2.697     0.200
    31.670     1.177     0.200
    31.986    -0.970     0.200
    32.092     1.771     0.200
    32.105     0.562     0.200
    32.214     1.939     0.200
    32.308     3.776     0.200
    32.453    -1.453     0.200
    32.664     2.358     0.200
    32.914     1.969     0.200
    32.976    -0.670     0.200
    33.029     0.606     0.200
    33.106     2.126     0.200
    33.334     2.500     0.200
    33.498     1.877     0.200
    33.580     2.159     0.200
    33.580     1.949     0.200
    33.721     2.533     0.200
    33.834     2.251     0.200
    33.850     2.006     0.200
    33.847     0.883     0.200
    33.847     1.233     0.200
    33.847     0.933     0.200
    33.847     1.093     0.200
    33.877     1.321     0.200
    33.989     2.802     0.200
    34.279     1.242     0.200
    34.287     2.813     0.200
    34.841     3.125     0.200
    34.894     3.163     0.200
    34.937     2.696     0.200
    35.367     1.795     0.200
    35.295     1.508     0.200
    35.372     3.754     0.200
    35.385     1.040     0.200
    35.619    -0.472     0.200
    35.806     2.523     0.200
    35.996     2.692     0.200
    36.000     2.663     0.200
    36.000     2.183     0.200
    36.259     2.249     0.200
    36.291     2.869     0.200
    36.310     1.608     0.200
    36.327     2.161     0.200
    36.317     0.551     0.200
    36.455     1.550     0.200
    36.484     2.625     0.200
    36.682     2.637     0.200
    36.749     1.628     0.200
    36.847     1.661     0.200
    36.862     1.709     0.200
    36.956     2.901     0.200
    36.993     1.689     0.200
    37.016     2.396     0.200
    37.073     2.705     0.200
    37.104     1.345     0.200
    37.104     0.925     0.200
    37.216     1.691     0.200
    37.160     0.070     0.200
    37.277     1.776     0.200
    37.365     2.333     0.200
    37.397     1.157     0.200
    37.404     2.003     0.200
    37.449     0.516     0.200
    37.532     1.719     0.200
    37.600     1.739     0.200
    37.660     3.634     0.200
    37.722     0.804     0.200
    37.734     0.007     0.200
    37.778     1.531     0.200
    37.825     2.135     0.200
    37.825     2.235     0.200
    37.817     2.704     0.200
    37.964     2.172     0.200
    38.022     1.878     0.200
    38.054     2.303     0.200
    38.129     1.574     0.200
    38.154     0.658     0.200
    38.157    -1.463     0.200
    38.220     1.205     0.200
    38.365     2.584     0.200
    38.430     0.835     0.200
    38.430     0.696     0.200
    38.597     0.932     0.200
    38.744     1.671     0.200
    38.760     6.367     0.200
    38.853     1.191     0.200
    38.864     0.395     0.200
    38.864     0.696     0.200
    38.921    -0.183     0.200
    39.215     0.956     0.200
    39.307     3.289     0.200
    39.366    -0.004     0.200
    39.387     0.122     0.200
    39.376     2.916     0.200
    39.473     1.503     0.200
    39.596     2.876     0.200
    39.630     2.196     0.200
    39.760     0.314     0.200
    39.744     1.845     0.200
    39.744     1.516     0.200
    39.888    -1.150     0.200
    39.909     3.778     0.200
    39.950    -1.968     0.200
    39.987     1.207     0.200
    40.240     1.833     0.200
    40.308     1.268     0.200
    40.311     2.338     0.200
    40.358     1.870     0.200
    40.474     2.388     0.200
    40.474     2.288     0.200
    40.796     2.136     0.200
    41.181     2.763     0.200
    41.181     2.233     0.200
    41.216     0.651     0.200
    41.317    -0.295     0.200
    41.556     2.087     0.200
    41.556     2.187     0.200
    41.587     3.426     0.200
    41.658     1.452     0.200
    41.678     1.884     0.200
    41.795     2.525     0.200
    41.849     2.085     0.200
    41.977     2.536     0.200
    42.117     2.253     0.200
    42.178     2.199     0.200
    42.308     2.446     0.200
    42.454     3.352     0.200
    42.450     0.290     0.200
    42.519     2.319     0.200
    42.569     2.318     0.200
    42.678     1.331     0.200
    42.678     0.131     0.200
    42.678     1.231     0.200
    42.664    -0.254     0.200
    42.780     1.224     0.200
    42.780     0.822     0.200
    42.780     0.464     0.200
    42.884     2.192     0.200
    42.886     2.276     0.200
    42.940     2.651     0.200
    42.965     2.201     0.200
    42.938     1.018     0.200
    43.072     1.834     0.200
    43.123     2.428     0.200
    43.286     2.670     0.200
    43.340     2.630     0.200
    43.385     1.904     0.200
    43.495     2.103     0.200
    43.708     1.909     0.200
    43.708     1.735     0.200
    43.776     1.762     0.200
    43.776     1.292     0.200
    43.871     1.908     0.200
    43.899     2.086     0.200
    43.881     1.685     0.200
    44.084     0.885     0.200
    44.084     1.085     0.200
    44.662     1.458     0.200
    44.713     0.958     0.200
    44.875     0.781     0.200
    44.992     3.265     0.200
    45.074     1.692     0.200
    45.176     1.480     0.200
    45.207     1.583     0.200
    45.240     1.102     0.200
    45.282     2.749     0.200
    45.355     3.422     0.200
    45.447     2.695     0.200
    45.478     0.684     0.200
    45.513     3.019     0.200
    45.559     1.169     0.200
    45.677     0.203     0.200
    45.677     0.177     0.200
    45.775     1.466     0.200
    45.849     1.253     0.200
    45.851     0.199     0.200
    45.825    -0.265     0.200
    45.904     0.842     0.200
    45.921     0.725     0.200
    45.950     1.232     0.200
    45.952     1.492     0.200
    45.952     1.488     0.200
    46.215     0.490     0.200
    46.188    -0.569     0.200
    46.327    -0.139     0.200
    46.327     0.491     0.200
    46.393     1.505     0.200
    46.383     2.738     0.200
    46.683     1.632     0.200
    46.682     1.495     0.200
    46.823     0.332     0.200
    46.861     1.359     0.200
    47.185     2.462     0.200
    47.491     1.210     0.200
    47.544     0.879     0.200
    47.748    -0.214     0.200
    47.803     0.877     0.200
    47.912     5.181     0.200
    48.120     3.286     0.200
    48.278     1.702     0.200
    48.490    -0.802     0.200
    48.506    -0.553     0.200
    48.540     1.902     0.200
    48.562     2.873     0.200
    48.562     1.273     0.200
    48.577     1.036     0.200
    48.938     1.788     0.200
    48.938    -0.897     0.200
    49.243     1.667     0.200
    49.243     2.437     0.200
    49.283     1.762     0.200
    49.285     1.761     0.200
    49.286     2.085     0.200
    49.288     1.569     0.200
    49.288     1.640     0.200
    49.288     1.807     0.200
    49.288     1.237     0.200
    49.289     1.635     0.200
    49.290     0.740     0.200
    49.504     2.158     0.200
    49.645     2.511     0.200
    50.374     1.427     0.200
    50.463     1.898     0.200
    50.409     0.633     0.200
    50.853     2.957     0.200
    50.832     3.118     0.200
    51.068     1.737     0.200
    51.288     1.287     0.200
    51.448     3.490     0.200
    51.669     1.433     0.200
    52.143     1.901     0.200
    54.112     0.101     0.200
    54.115     0.477     0.200
    54.117     0.889     0.200
    56.304     2.186     0.200
    56.296     1.441     0.200
    56.472     0.189     0.200
    57.113     2.436     0.200
    57.665     1.697     0.200
    57.922     1.391     0.200
    57.977     0.902     0.200
    58.302     0.806     0.200
    58.771     1.912     0.200
    59.461     3.327     0.200
    59.643     1.774     0.200
    60.106     1.992     0.200
    60.285     2.365     0.200
    60.285     1.075     0.200
    60.561     0.282     0.200
    62.757     1.273     0.200
    62.757     0.923     0.200
    63.475     2.908     0.200
    63.778     1.649     0.200
    65.223    -1.338     0.200
    65.223    -0.518     0.200
    65.223    -0.313     0.200
    72.548     0.614     0.200
    72.925     2.051     0.200
    73.970     0.012     0.200
    74.142     0.323     0.200
    74.142     0.698     0.200
    74.115     1.126     0.200
    74.218     0.451     0.200
    74.290    -0.870     0.200
    74.374     1.014     0.200
    75.674    -0.199     0.200
    75.961     0.651     0.200
    75.961     1.301     0.200
    75.900    -0.151     0.200
    75.900     0.099     0.200
    76.008     0.092     0.200
    76.318     0.393     0.200
    76.681    -0.505     0.200
    76.698     0.482     0.200
    76.784    -0.188     0.200
    76.765    -0.458     0.200
    76.778    -1.092     0.200
    76.778    -1.182     0.200
    76.859    -0.070     0.200
    77.077    -0.237     0.200
    77.195     0.000     0.200
    77.492    -0.519     0.200
    77.947     0.040     0.200
    78.370    -0.540     0.200
    78.647    -0.172     0.200
    78.657    -0.263     0.200
    78.923    -0.058     0.200
    78.922     0.348     0.200
    78.960    -0.252     0.200
    78.979    -0.013     0.200
    79.206     0.261     0.200
    79.220     1.258     0.200
    79.228    -0.948     0.200
    79.840     0.773     0.200
    80.028    -0.787     0.200
    80.704     1.289     0.200
    81.176    -0.662     0.200
    81.360     0.184     0.200
    81.360     0.684     0.200
    81.369     0.937     0.200
    81.369     0.637     0.200
    81.418     0.256     0.200
    83.211    -0.305     0.200
    83.525    -0.063     0.200
    83.706     0.256     0.200
    85.794     0.034     0.200
    90.151     0.269     0.200
    90.849     0.270     0.200
    92.532     0.547     0.200
    94.706    -0.255     0.200
    18.314     0.007     0.200
    18.502     0.460     0.200
    18.502     0.866     0.200
    18.536     0.038     0.200
    18.536     0.848     0.200
    21.911     0.392     0.200
    21.915     0.348     0.200
    23.172     1.255     0.200
    24.335     0.794     0.200
    29.655     2.560     0.200
    29.655     2.560     0.200
    29.873     2.067     0.200
    29.873     2.063     0.200
    29.975     0.639     0.200
    29.975     0.641     0.200
    33.865     0.324     0.200
    33.865     0.323     0.200
    37.108     1.154     0.200
    38.889     0.824     0.200
    38.889     0.819     0.200
    41.298     0.191     0.200
    42.808     0.918     0.200
    42.808     0.915     0.200
    43.723    -0.702     0.200
    45.700     0.034     0.200
    45.700     0.334     0.200
    45.700     0.334     0.200
    47.161     2.000     0.200
    49.251     1.559     0.200
    57.989     1.100     0.200
    65.218    -0.062     0.200
    65.219    -0.065     0.200
    75.935     0.905     0.200
    75.932    -0.323     0.200
    76.810    -0.548     0.200
    81.347     0.370     0.200
    83.243    -0.643     0.200
    83.510     0.702     0.200
    17.256     1.899     0.200
    18.239     1.163     0.200
    18.470     0.396     0.200
    18.503     0.133     0.200
    18.503     0.395     0.200
    18.503     1.113     0.200
    21.044     4.890     0.200
    21.044    -0.020     0.200
    21.924     0.523     0.200
    21.927     0.478     0.200
    22.132     2.823     0.200
    23.065     1.798     0.200
    23.078     5.791     0.200
    23.268     2.393     0.200
    23.314     0.899     0.200
    23.314     1.710     0.200
    23.314     1.091     0.200
    24.011     2.418     0.200
    29.545     2.014     0.200
    29.545     2.013     0.200
    29.545     2.411     0.200
    29.946     4.359     0.200
    30.206    -2.450     0.200
    30.377     1.749     0.200
    31.084     0.609     0.200
    33.765     0.945     0.200
    33.765     0.921     0.200
    36.143     0.508     0.200
    38.805     1.104     0.200
    38.805     0.660     0.200
    38.805     0.611     0.200
    42.740     0.529     0.200
    43.620     1.588     0.200
    45.074     0.895     0.200
    45.382     0.302     0.200
    45.564     0.600     0.200
    45.576     0.195     0.200
    45.613    -0.115     0.200
    45.613     0.135     0.200
    45.613     0.135     0.200
    45.787    -0.201     0.200
    45.822    -0.205     0.200
    45.861     0.341     0.200
    47.787    -0.446     0.200
    50.385     0.958     0.200
    53.227     1.377     0.200
    56.355     1.196     0.200
    65.113    -0.069     0.200
    65.113    -0.066     0.200
    65.113    -0.073     0.200
    72.852     2.264     0.200
    75.891     1.281     0.200
    75.917    -0.463     0.200
    76.348     0.197     0.200
    76.807    -0.675     0.200
    76.807    -0.671     0.200
    80.166     1.694     0.200
    81.454     0.770     0.200
    81.454     0.772     0.200
    81.463     0.374     0.200
    83.215    -0.390     0.200
    83.215    -0.386     0.200
    83.529     1.249     0.200
    83.615     0.406     0.200
    83.615     0.404     0.200
    83.646     0.289     0.200
    18.303     0.742     0.200
    18.286     0.623     0.200
    18.286     0.033     0.200
    18.321     0.739     0.200
    19.241     2.046     0.200
    21.546    -1.229     0.200
    21.546     1.245     0.200
    21.546     0.566     0.200
    22.495     3.343     0.200
    23.287     0.304     0.200
    23.287     0.685     0.200
    23.414     0.021     0.200
    23.414    -0.505     0.200
    23.456     3.917     0.200
    23.613    -1.023     0.200
    27.812     0.865     0.200
    28.211     2.303     0.200
    29.408     0.518     0.200
    29.693     0.082     0.200
    29.967     1.826     0.200
    29.967     1.486     0.200
    32.460     4.767     0.200
    34.035     0.684     0.200
    35.866     1.447     0.200
    36.791     0.453     0.200
    37.801     0.888     0.200
    38.927     0.237     0.200
    38.927     0.620     0.200
    39.399     0.979     0.200
    42.422     0.087     0.200
    42.757     1.068     0.200
    42.756     0.308     0.200
    42.756     1.019     0.200
    42.988     2.775     0.200
    43.213     0.626     0.200
    43.850     1.275     0.200
    43.925     0.717     0.200
    44.863     0.997     0.200
    45.333     0.003     0.200
    45.347     0.710     0.200
    45.534     0.713     0.200
    45.528    -0.080     0.200
    45.571     0.272     0.200
    45.729     0.520     0.200
    45.766    -0.312     0.200
    45.766     0.262     0.200
    45.932    -0.233     0.200
    46.902     0.615     0.200
    58.249     1.583     0.200
    62.711     2.253     0.200
    65.638     0.544     0.200
    75.635     1.691     0.200
    75.649    -0.120     0.200
    75.649     0.505     0.200
    76.372     1.266     0.200
    76.372     1.891     0.200
    76.486    -0.919     0.200
    80.847     0.252     0.200
    81.106    -0.425     0.200
    81.106     1.675     0.200
    81.115     0.290     0.200
    83.005     0.213     0.200
    83.291     1.002     0.200
    15.011     5.721     0.200
    16.130     4.353     0.200
    18.306     1.168     0.200
    21.723     0.194     0.200
    23.087     1.050     0.200
    23.193     0.909     0.200
    23.836     3.464     0.200
    29.461     3.617     0.200
    29.604     2.846     0.200
    29.739     1.802     0.200
    30.040     1.590     0.200
    31.033     1.218     0.200
    32.102     1.717     0.200
    32.834     4.699     0.200
    32.837    -2.830     0.200
    33.751     1.024     0.200
    35.300     2.504     0.200
    35.959     1.348     0.200
    37.079     1.413     0.200
    37.968     1.570     0.200
    38.734     0.504     0.200
    40.194     1.959     0.200
    41.708     2.081     0.200
    42.633     0.223     0.200
    43.330     1.104     0.200
    43.622     0.725     0.200
    44.213     0.457     0.200
    45.553    -0.162     0.200
    45.553    -0.137     0.200
    45.883     0.431     0.200
    45.878     2.124     0.200
    46.757     1.566     0.200
    49.203     0.815     0.200
    54.037     1.666     0.200
    57.913     1.936     0.200
    65.242     0.158     0.200
    74.166     0.586     0.200
    74.244     0.209     0.200
    74.315     1.095     0.200
    74.555     0.996     0.200
    76.098     1.157     0.200
    76.615    -0.502     0.200
    81.432     1.046     0.200
    83.046     0.222     0.200
    83.604     1.248     0.200
    83.561     0.667     0.200
    16.303     4.955     0.200
    18.256     1.521     0.200
    18.455     1.053     0.200
    18.488     0.195     0.200
    18.488     1.336     0.200
    20.661     1.929     0.200
    21.900    -0.841     0.200
    21.900     0.081     0.200
    21.900     0.065     0.200
    22.230    -0.493     0.200
    23.306     0.541     0.200
    23.306     1.432     0.200
    24.045    -1.097     0.200
    23.982     2.969     0.200
    27.308     3.334     0.200
    29.563     2.188     0.200
    29.909     2.460     0.200
    30.348     1.413     0.200
    32.986     4.015     0.200
    35.292     2.977     0.200
    36.124     0.878     0.200
    38.805     0.616     0.200
    38.806     1.064     0.200
    42.735     0.723     0.200
    43.631     0.880     0.200
    44.675     0.820     0.200
    45.384     0.182     0.200
    45.655    -0.600     0.200
    45.566     1.100     0.200
    45.578    -0.089     0.200
    45.615     0.190     0.200
    45.615     0.292     0.200
    45.825     0.025     0.200
    45.864     0.463     0.200
    48.200     1.227     0.200
    53.314     0.942     0.200
    54.188    -0.619     0.200
    57.896     1.839     0.200
    65.139    -0.538     0.200
    76.786    -0.951     0.200
    80.284     0.029     0.200
    80.284     0.904     0.200
    81.363     0.822     0.200
    81.440     0.803     0.200
    81.449     1.242     0.200
    81.594     0.820     0.200
    81.436    -0.667     0.200
    81.692     0.620     0.200
    83.199     0.185     0.200
    83.603     0.406     0.200
    18.176     0.978     0.200
    18.406     0.925     0.200
    18.440     0.342     0.200
    20.713    -1.149     0.200
    21.008     4.522     0.200
    21.870    -0.003     0.200
    21.870    -0.292     0.200
    22.370    -1.157     0.200
    22.990    -2.213     0.200
    23.021     1.738     0.200
    23.249     1.706     0.200
    23.249     0.557     0.200
    24.001     2.050     0.200
    29.510     2.316     0.200
    29.510     1.542     0.200
    29.910     1.470     0.200
    33.713     1.620     0.200
    33.713    -0.154     0.200
    35.873     1.425     0.200
    36.083    -0.020     0.200
    38.744     0.468     0.200
    38.744     0.627     0.200
    38.744     0.728     0.200
    42.675     0.492     0.200
    42.675     0.820     0.200
    45.322    -0.534     0.200
    45.553     0.325     0.200
    45.553     0.575     0.200
    45.763    -0.591     0.200
    48.141     1.342     0.200
    48.800     0.555     0.200
    49.106     2.870     0.200
    52.474     0.906     0.200
    57.839     1.903     0.200
    69.100    -0.967     0.200
    74.908     0.243     0.200
    75.932     1.240     0.200
    79.332    -0.009     0.200
    81.498    -0.493     0.200
    83.152    -0.264     0.200
    83.152     0.064     0.200
    83.662     0.543     0.200
    17.229     4.200     0.200
    18.409     0.309     0.200
    18.528    -0.698     0.200
    21.316     0.780     0.200
    21.870     2.473     0.200
    21.870     1.043     0.200
    23.447     1.361     0.200
    36.152     0.662     0.200
    38.998    -0.029     0.200
    38.998     0.107     0.200
    38.998     0.279     0.200
    42.892    -0.085     0.200
    45.768     0.419     0.200
    45.817     0.215     0.200
    45.817     0.238     0.200
    47.742    -0.862     0.200
    83.359    -0.302     0.200
    16.502     5.039     0.200
    17.339     2.583     0.200
    17.339     3.993     0.200
    18.492     0.267     0.200
    20.865     1.495     0.200
    22.024     0.718     0.200
    22.024    -0.538     0.200
    22.024     0.587     0.200
    22.024     0.138     0.200
    23.275     0.827     0.200
    23.275     0.458     0.200
    24.003     0.474     0.200
    24.003     0.948     0.200
    27.709     0.414     0.200
    29.362     2.616     0.200
    30.113     1.281     0.200
    30.261    -0.047     0.200
    30.552     2.340     0.200
    33.210     0.787     0.200
    33.625     0.991     0.200
    38.714     0.339     0.200
    38.714     0.771     0.200
    38.714     0.941     0.200
    42.684     0.232     0.200
    45.510    -0.119     0.200
    45.510     0.006     0.200
    46.251     0.563     0.200
    47.881     0.008     0.200
    54.413     0.641     0.200
    57.712     1.564     0.200
    64.909     0.009     0.200
    76.881    -1.062     0.200
    81.618     0.108     0.200
    81.618    -0.717     0.200
    83.244    -0.640     0.200
    83.244    -0.208     0.200
    83.772     0.586     0.200
    18.253     1.251     0.200
    18.457     0.800     0.200
    18.491     0.750     0.200
    18.491     0.957     0.200
    19.647     1.579     0.200
    21.094     4.872     0.200
    21.094     2.942     0.200
    21.888    -0.187     0.200
    21.888    -0.207     0.200
    21.888     0.164     0.200
    22.177     2.053     0.200
    22.457    -2.045     0.200
    23.109     2.566     0.200
    23.109     2.191     0.200
    23.311     2.540     0.200
    23.318     0.362     0.200
    23.318     1.362     0.200
    23.318     1.132     0.200
    28.101     0.682     0.200
    29.595     3.203     0.200
    29.595     1.980     0.200
    29.883     1.552     0.200
    30.322     0.656     0.200
    30.322     2.066     0.200
    31.111     1.610     0.200
    32.955     2.113     0.200
    33.801     1.288     0.200
    36.120    -0.290     0.200
    36.120     0.733     0.200
    37.064     2.476     0.200
    37.409     0.155     0.200
    38.826     0.907     0.200
    45.637     0.001     0.200
    45.637     0.075     0.200
    45.846    -0.689     0.200
    45.818     0.083     0.200
    45.842     0.376     0.200
    47.581    -0.802     0.200
    47.581    -0.803     0.200
    54.153     0.766     0.200
    54.158     1.428     0.200
    57.927     1.345     0.200
    65.173    -0.191     0.200
    75.939     1.510     0.200
    75.895     0.186     0.200
    76.475    -0.382     0.200
    76.779    -0.654     0.200
    81.410     0.839     0.200
    83.200    -0.017     0.200
    83.574     0.419     0.200
    16.221     4.996     0.200
    17.905     1.710     0.200
    18.595    -0.003     0.200
    18.595     1.087     0.200
    18.702     0.146     0.200
    18.737     0.780     0.200
    18.737     1.007     0.200
    19.691     2.056     0.200
    21.448     3.432     0.200
    21.448     1.725     0.200
    22.003     0.404     0.200
    22.003     0.165     0.200
    22.542     2.350     0.200
    23.476     2.436     0.200
    23.476     0.010     0.200
    23.540     1.045     0.200
    23.679     1.884     0.200
    23.633     0.472     0.200
    23.774     3.812     0.200
    24.489     0.285     0.200
    27.789     2.759     0.200
    28.120     0.009     0.200
    29.463     0.418     0.200
    29.678     1.264     0.200
    29.809     2.436     0.200
    29.809     2.127     0.200
    29.946     2.398     0.200
    29.946     1.500     0.200
    30.247     2.232     0.200
    31.476     0.093     0.200
    31.676    -2.669     0.200
    32.794     4.423     0.200
    33.124     0.706     0.200
    33.287    -0.878     0.200
    33.287    -0.979     0.200
    34.173     0.741     0.200
    34.173     0.526     0.200
    34.173     1.417     0.200
    35.159     3.266     0.200
    35.213     3.524     0.200
    35.523     3.341     0.200
    35.689     4.057     0.200
    36.317     2.485     0.200
    36.318     2.107     0.200
    37.696     2.988     0.200
    38.698     3.105     0.200
    39.182     0.797     0.200
    40.055     0.278     0.200
    42.002     2.654     0.200
    42.119     2.232     0.200
    42.302     2.512     0.200
    42.630     2.555     0.200
    43.079     1.406     0.200
    43.205     2.080     0.200
    43.260     2.290     0.200
    43.447     2.434     0.200
    43.543     0.528     0.200
    43.605     2.670     0.200
    43.630     2.053     0.200
    43.659     2.274     0.200
    43.686     2.508     0.200
    43.707     2.048     0.200
    43.819     3.210     0.200
    44.030     1.149     0.200
    44.030     1.637     0.200
    44.139     2.005     0.200
    44.345     1.715     0.200
    44.384     2.140     0.200
    44.657     0.120     0.200
    44.758    -1.479     0.200
    44.809     1.776     0.200
    44.896    -1.166     0.200
    44.982     2.057     0.200
    45.528     1.313     0.200
    45.562     1.083     0.200
    45.822     1.234     0.200
    45.880     0.838     0.200
    45.885    -0.173     0.200
    45.885    -0.813     0.200
    45.949    -0.559     0.200
    45.999     0.290     0.200
    45.999     0.165     0.200
    46.096     0.755     0.200
    46.170     1.199     0.200
    46.714     1.559     0.200
    47.878    -0.646     0.200
    49.133     1.542     0.200
    49.539     1.240     0.200
    51.044     1.055     0.200
    52.483     1.614     0.200
    53.392     1.404     0.200
    53.709     0.583     0.200
    58.290     1.082     0.200
    63.049    -0.517     0.200
    65.451     0.168     0.200
    72.603    -2.527     0.200
    73.031    -1.910     0.200
    73.089    -0.252     0.200
    75.416    -0.080     0.200
    75.447     0.790     0.200
    75.809    -0.269     0.200
    76.092    -0.543     0.200
    76.205    -0.219     0.200
    76.476    -0.064     0.200
    76.821    -0.366     0.200
    76.938    -1.342     0.200
    76.938    -0.764     0.200
    77.009    -1.999     0.200
    77.291    -1.795     0.200
    78.151    -2.539     0.200
    79.128    -0.796     0.200
    80.166    -1.538     0.200
    81.043     0.368     0.200
    83.204     0.864     0.200
    83.432    -0.008     0.200
    14.741     6.649     0.200
    18.263     1.161     0.200
    21.501    -0.430     0.200
    21.501     0.141     0.200
    21.501     0.312     0.200
    23.225     1.002     0.200
    29.391     2.262     0.200
    42.694    -0.466     0.200
    44.372     0.136     0.200
    45.706     0.340     0.200
    45.706     0.239     0.200
    53.470    -0.988     0.200
    58.201     1.515     0.200
    65.617     0.783     0.200
    76.402     1.081     0.200
    81.155     0.599     0.200
    83.342     1.002     0.200
    14.965     6.112     0.200
    16.007     6.102     0.200
    18.443     1.106     0.200
    18.443     0.657     0.200
    21.360     4.566     0.200
    21.720    -0.163     0.200
    21.720    -0.163     0.200
    21.720     0.571     0.200
    23.366     0.915     0.200
    23.643     2.846     0.200
    27.801     1.566     0.200
    29.606     1.512     0.200
    29.606     2.813     0.200
    29.777     1.105     0.200
    31.263     1.470     0.200
    32.650     1.683     0.200
    34.001     0.179     0.200
    34.001     0.898     0.200
    36.015     1.049     0.200
    36.015    -0.279     0.200
    42.816     0.528     0.200
    42.816     1.481     0.200
    44.439     0.114     0.200
    45.686     1.272     0.200
    58.174    -0.084     0.200
    65.483    -0.155     0.200
    70.936    -0.375     0.200
    71.002    -0.793     0.200
    71.597    -0.271     0.200
    74.030    -0.738     0.200
    74.820     0.456     0.200
    76.996    -0.472     0.200
    78.034    -0.549     0.200
    81.172     0.198     0.200
    83.137    -0.087     0.200
    83.137     0.237     0.200
    83.346     0.705     0.200
    16.950     3.472     0.200
    18.277     1.882     0.200
    19.327     0.741     0.200
    19.678     1.696     0.200
    20.446    -0.049     0.200
    20.446     1.480     0.200
    21.595     0.443     0.200
    21.595     0.457     0.200
    21.595     0.132     0.200
    21.949     4.079     0.200
    23.148     2.307     0.200
    23.234     1.201     0.200
    23.209     1.130     0.200
    23.209     2.470     0.200
    23.588     1.989     0.200
    24.120     0.925     0.200
    26.864     2.556     0.200
    29.545     1.524     0.200
    29.545     2.905     0.200
    29.738     3.742     0.200
    29.878     1.603     0.200
    29.878     2.853     0.200
    31.119     1.493     0.200
    33.871     1.011     0.200
    33.871     1.475     0.200
    33.871     0.184     0.200
    33.871     0.995     0.200
    35.002     2.050     0.200
    35.446     2.727     0.200
    35.446     3.897     0.200
    35.872     0.611     0.200
    35.872     1.221     0.200
    36.052     2.109     0.200
    36.065     1.986     0.200
    36.075     2.444     0.200
    37.723     2.177     0.200
    38.799     1.330     0.200
    38.799     0.459     0.200
    38.799     0.655     0.200
    38.799     0.785     0.200
    38.939     0.487     0.200
    41.400     1.707     0.200
    42.659     1.076     0.200
    42.659     1.326     0.200
    43.301     2.454     0.200
    44.293     0.429     0.200
    45.317     1.369     0.200
    45.398     0.615     0.200
    45.630     0.009     0.200
    45.630    -0.167     0.200
    45.877     0.661     0.200
    47.466    -0.191     0.200
    47.466     0.799     0.200
    49.125     1.077     0.200
    49.125     1.304     0.200
    55.995     1.812     0.200
    58.066     1.471     0.200
    65.446    -0.127     0.200
    70.407    -0.334     0.200
    74.372    -0.426     0.200
    75.652    -0.192     0.200
    76.511    -1.130     0.200
    76.511    -1.331     0.200
    76.643    -0.089     0.200
    81.285    -0.435     0.200
    81.285     1.365     0.200
    82.986    -0.376     0.200
    83.466    -0.129     0.200
    18.169     1.326     0.200
    18.435     1.022     0.200
    18.456     1.026     0.200
    20.951     2.771     0.200
    21.925     0.851     0.200
    21.925     1.117     0.200
    22.973     2.062     0.200
    23.259     0.411     0.200
    24.040     3.018     0.200
    29.451     2.116     0.200
    29.985     1.334     0.200
    29.985     0.248     0.200
    33.676     1.214     0.200
    35.186     3.453     0.200
    38.728    -0.187     0.200
    38.728     0.597     0.200
    42.674     0.838     0.200
    43.332    -0.775     0.200
    43.529     2.858     0.200
    44.188     0.883     0.200
    45.484     0.014     0.200
    45.533     0.318     0.200
    45.533     0.443     0.200
    45.666     0.928     0.200
    45.743    -0.145     0.200
    45.905     0.398     0.200
    46.122     1.757     0.200
    47.785     0.136     0.200
    49.047     2.637     0.200
    54.283     0.787     0.200
    54.283     0.381     0.200
    57.788     1.762     0.200
    57.788    -0.473     0.200
    65.027     0.248     0.200
    65.027    -1.229     0.200
    81.547     0.194     0.200
    83.183     0.099     0.200
    83.183    -0.643     0.200
    83.707     0.654     0.200
    14.851     5.994     0.200
    18.260     0.746     0.200
    21.592     0.526     0.200
    21.592     0.456     0.200
    23.253     1.464     0.200
    33.888     1.135     0.200
    38.813     0.413     0.200
    42.337     0.643     0.200
    42.670     0.459     0.200
    42.670    -0.486     0.200
    44.308    -0.046     0.200
    45.608     0.129     0.200
    45.645    -0.233     0.200
    58.084     1.072     0.200
    65.464    -0.153     0.200
    80.696    -0.605     0.200
    81.267     0.452     0.200
    82.920    -0.227     0.200
    82.989    -0.486     0.200
    83.448     0.126     0.200
    18.474     1.395     0.200
    18.496     1.561     0.200
    21.928     0.811     0.200
    21.928    -0.064     0.200
    21.928     0.335     0.200
    23.066     3.031     0.200
    23.321     1.480     0.200
    23.321     1.371     0.200
    38.807     0.917     0.200
    38.808     0.591     0.200
    38.808     0.427     0.200
    42.743     0.381     0.200
    44.271     0.393     0.200
    45.566     0.693     0.200
    45.615     0.316     0.200
    45.615     0.245     0.200
    45.863     0.688     0.200
    71.471     0.141     0.200
    72.341    -0.683     0.200
    75.887     0.917     0.200
    81.453     0.127     0.200
    83.220    -0.574     0.200
    16.140     5.146     0.200
    17.931     5.064     0.200
    18.274     1.487     0.200
    18.411     0.172     0.200
    18.433     0.215     0.200
    19.529     1.589     0.200
    19.836     3.139     0.200
    20.083     2.349     0.200
    20.586     1.280     0.200
    20.512     0.447     0.200
    20.512     1.478     0.200
    21.206     3.254     0.200
    21.206     2.785     0.200
    21.206    -0.761     0.200
    21.206     4.504     0.200
    21.206     4.684     0.200
    21.206     5.285     0.200
    21.866     4.647     0.200
    21.790    -0.114     0.200
    21.790    -0.145     0.200
    21.790     1.004     0.200
    21.790     0.121     0.200
    22.383    -0.832     0.200
    23.205     0.579     0.200
    23.205     2.477     0.200
    23.205     3.876     0.200
    23.239     1.225     0.200
    23.226     1.463     0.200
    23.377     1.375     0.200
    23.406    -1.036     0.200
    23.406    -0.357     0.200
    23.406     3.636     0.200
    23.320     0.867     0.200
    23.320    -0.055     0.200
    23.328     2.480     0.200
    23.425     1.159     0.200
    23.470     4.156     0.200
    23.764     3.454     0.200
    24.455    -0.758     0.200
    25.012     2.573     0.200
    25.289     1.057     0.200
    25.360     2.438     0.200
    27.798     1.123     0.200
    29.711     2.288     0.200
    29.711     2.616     0.200
    29.711     2.512     0.200
    29.743     1.406     0.200
    29.743     1.726     0.200
    29.928     1.943     0.200
    30.182     1.341     0.200
    30.182     2.974     0.200
    31.162     1.094     0.200
    32.808     2.637     0.200
    33.876    -0.287     0.200
    33.876     0.814     0.200
    36.049     0.240     0.200
    36.049     0.966     0.200
    36.049    -0.354     0.200
    36.049     1.669     0.200
    36.947     1.913     0.200
    38.862     1.087     0.200
    38.862     0.282     0.200
    42.758     0.104     0.200
    43.744     1.148     0.200
    43.703     1.764     0.200
    44.341     0.241     0.200
    44.619     0.417     0.200
    44.797     0.416     0.200
    44.797     1.908     0.200
    45.632     0.229     0.200
    45.682     0.282     0.200
    45.682     0.227     0.200
    49.250     0.938     0.200
    52.978    -1.997     0.200
    53.372     0.988     0.200
    53.401    -0.165     0.200
    54.010     0.869     0.200
    58.028     0.672     0.200
    65.314     0.436     0.200
    65.314    -1.228     0.200
    65.323     0.506     0.200
    72.065     0.568     0.200
    72.632     0.581     0.200
    73.030     2.408     0.200
    73.030     2.213     0.200
    72.843     0.119     0.200
    73.093     0.339     0.200
    73.120     0.019     0.200
    73.461     1.170     0.200
    74.235    -0.616     0.200
    74.235    -0.467     0.200
    74.085    -0.419     0.200
    74.532     0.961     0.200
    74.863     1.024     0.200
    76.065     1.159     0.200
    76.697    -0.596     0.200
    81.087    -0.592     0.200
    81.314     0.149     0.200
    81.314     0.806     0.200
    81.436    -0.115     0.200
    82.172    -0.304     0.200
    83.080    -0.689     0.200
    83.148    -0.528     0.200
    83.148     0.199     0.200
    83.148    -0.153     0.200
    83.148    -0.004     0.200
    83.163     0.808     0.200
    83.483     0.565     0.200
    83.483     0.666     0.200
    83.483     0.971     0.200
    15.269     5.384     0.200
    16.263     3.938     0.200
    17.406     4.186     0.200
    18.599     1.021     0.200
    18.724     1.408     0.200
    19.731     1.184     0.200
    20.308    -0.470     0.200
    22.038     1.352     0.200
    22.038     1.051     0.200
    23.778     3.273     0.200
    24.446     0.335     0.200
    25.450     2.442     0.200
    25.833     2.373     0.200
    26.801    -2.579     0.200
    26.801     0.940     0.200
    29.703     0.614     0.200
    29.703     1.458     0.200
    29.919     1.740     0.200
    29.852     1.454     0.200
    29.852     1.743     0.200
    30.290     0.657     0.200
    30.650    -1.796     0.200
    32.029     2.509     0.200
    32.838     3.355     0.200
    34.160     0.891     0.200
    34.160    -0.129     0.200
    34.160     0.058     0.200
    35.669     3.897     0.200
    36.339     0.713     0.200
    36.339     0.338     0.200
    36.339     1.787     0.200
    39.181    -0.221     0.200
    39.181     0.676     0.200
    42.465     2.582     0.200
    42.613     2.187     0.200
    42.876     1.610     0.200
    43.086     0.821     0.200
    43.086    -0.390     0.200
    43.242     2.050     0.200
    43.531     1.177     0.200
    43.689     1.954     0.200
    43.806     2.599     0.200
    44.014     1.152     0.200
    44.014     2.223     0.200
    44.201     0.622     0.200
    44.241     0.817     0.200
    44.270     2.673     0.200
    44.297     2.732     0.200
    44.366     2.130     0.200
    44.791     1.720     0.200
    44.877     0.560     0.200
    44.964     0.885     0.200
    45.055     0.204     0.200
    45.055    -0.194     0.200
    45.326     1.563     0.200
    45.511     0.762     0.200
    45.591     3.170     0.200
    45.805     1.105     0.200
    45.764    -1.433     0.200
    45.863     1.192     0.200
    45.958     0.066     0.200
    45.862     1.035     0.200
    45.995     0.143     0.200
    45.995     0.443     0.200
    46.079     1.296     0.200
    46.697     1.530     0.200
    46.697     1.694     0.200
    46.684     1.134     0.200
    47.509     0.180     0.200
    47.509    -0.391     0.200
    47.913    -0.252     0.200
    47.913     0.568     0.200
    48.581     0.634     0.200
    49.512     2.157     0.200
    49.577     0.334     0.200
    49.577     0.185     0.200
    53.700     0.433     0.200
    54.647    -0.429     0.200
    58.269     1.075     0.200
    74.352    -0.463     0.200
    75.144    -0.871     0.200
    76.970    -0.729     0.200
    81.063     0.573     0.200
    81.186    -0.875     0.200
    81.385     0.236     0.200
    83.222     0.542     0.200
    83.222    -0.138     0.200
    83.387    -0.138     0.200
    83.456    -0.089     0.200
    16.577     4.826     0.200
    17.275     2.388     0.200
    18.355    -0.303     0.200
    18.355    -0.354     0.200
    18.376    -0.025     0.200
    18.636     0.413     0.200
    18.877    -1.201     0.200
    18.962    -0.769     0.200
    19.209    -0.871     0.200
    19.500    -0.254     0.200
    19.929    -0.236     0.200
    20.616     1.911     0.200
    20.616     0.895     0.200
    21.109     1.637     0.200
    21.109     0.864     0.200
    21.258     4.019     0.200
    21.981    -0.041     0.200
    22.101     2.031     0.200
    22.650     1.689     0.200
    22.650     0.592     0.200
    22.650     0.990     0.200
    22.853     1.709     0.200
    22.853    -0.240     0.200
    22.853     1.236     0.200
    22.853     1.037     0.200
    22.916     0.972     0.200
    23.024     0.831     0.200
    23.767     0.621     0.200
    23.902     0.975     0.200
    23.902    -1.146     0.200
    24.318     2.586     0.200
    24.872     2.647     0.200
    27.428    -0.297     0.200
    27.415     0.749     0.200
    27.497     1.118     0.200
    27.610    -1.410     0.200
    27.593     1.158     0.200
    27.713     1.688     0.200
    27.764     2.525     0.200
    28.333     0.656     0.200
    28.939     1.764     0.200
    29.114     0.608     0.200
    29.115     1.846     0.200
    29.115     3.096     0.200
    29.617     0.390     0.200
    30.196     1.122     0.200
    30.196     0.927     0.200
    30.203     1.660     0.200
    30.209     1.813     0.200
    30.295     2.337     0.200
    30.295     1.024     0.200
    30.510     1.148     0.200
    30.510     0.238     0.200
    30.529     0.488     0.200
    30.636     1.650     0.200
    30.636     1.388     0.200
    30.735     1.767     0.200
    30.735     1.349     0.200
    30.735     0.388     0.200
    30.966    -0.296     0.200
    32.164    -0.120     0.200
    32.836     3.108     0.200
    33.375     1.120     0.200
    33.375     0.792     0.200
    33.375     0.893     0.200
    33.348     3.428     0.200
    33.620     1.253     0.200
    34.138     0.454     0.200
    34.334     2.892     0.200
    34.334     2.579     0.200
    34.388     2.898     0.200
    34.572     2.347     0.200
    34.698     2.401     0.200
    34.770     0.882     0.200
    34.841     2.507     0.200
    34.863     3.732     0.200
    34.921     2.580     0.200
    35.176     1.262     0.200
    35.273     2.554     0.200
    35.491     2.740     0.200
    35.513     0.313     0.200
    35.513     0.781     0.200
    35.549     0.973     0.200
    35.580     1.011     0.200
    35.587     1.044     0.200
    35.613     0.085     0.200
    35.782     2.607     0.200
    36.046     1.789     0.200
    36.101    -0.279     0.200
    36.101     0.334     0.200
    36.690     2.135     0.200
    37.008     2.911     0.200
    37.041     0.987     0.200
    37.041     0.827     0.200
    37.158     2.836     0.200
    37.208     1.560     0.200
    37.280     1.974     0.200
    37.335     2.276     0.200
    37.549     2.631     0.200
    37.564     2.649     0.200
    37.591     1.171     0.200
    37.633     3.715     0.200
    37.853     2.058     0.200
    37.874     1.416     0.200
    37.889     2.684     0.200
    38.211     2.606     0.200
    38.226     1.000     0.200
    38.286     2.099     0.200
    38.483     0.840     0.200
    38.483     0.410     0.200
    38.694     1.766     0.200
    38.888     3.089     0.200
    38.888     2.866     0.200
    38.969    -1.236     0.200
    39.100     2.585     0.200
    39.100     3.230     0.200
    39.115     0.141     0.200
    39.228     1.042     0.200
    39.182     0.499     0.200
    39.184    -0.391     0.200
    39.262     2.003     0.200
    39.420     2.996     0.200
    39.968     2.036     0.200
    40.164     2.157     0.200
    40.139     0.638     0.200
    40.239     1.087     0.200
    40.265     0.728     0.200
    40.311     2.290     0.200
    40.350     1.955     0.200
    40.596     2.335     0.200
    40.695     2.538     0.200
    40.695     2.721     0.200
    40.695     2.210     0.200
    40.856     2.746     0.200
    40.825     1.231     0.200
    41.076     2.184     0.200
    41.069     0.806     0.200
    41.250     3.052     0.200
    41.307     2.867     0.200
    41.307     2.374     0.200
    41.307     2.515     0.200
    41.266     1.116     0.200
    41.352     2.109     0.200
    41.437     2.109     0.200
    41.495     2.558     0.200
    41.527     2.390     0.200
    41.527     2.212     0.200
    41.568     2.532     0.200
    41.671     2.627     0.200
    41.697     2.368     0.200
    41.812     2.631     0.200
    42.031     2.425     0.200
    42.069     2.445     0.200
    42.077     2.551     0.200
    42.129     1.743     0.200
    42.148     1.641     0.200
    42.153     1.146     0.200
    42.383     2.067     0.200
    42.477     0.710     0.200
    42.477     0.898     0.200
    42.477     0.882     0.200
    42.477     0.577     0.200
    42.483     0.861     0.200
    42.618     2.674     0.200
    42.638     2.570     0.200
    42.663     2.271     0.200
    42.711    -0.240     0.200
    42.708     2.809     0.200
    42.728     3.011     0.200
    42.816     2.035     0.200
    42.835     2.443     0.200
    42.889     1.941     0.200
    42.889     2.328     0.200
    42.914     0.623     0.200
    43.016     2.138     0.200
    43.217     2.013     0.200
    43.217     2.216     0.200
    43.217    -0.808     0.200
    43.286     2.040     0.200
    43.286     0.751     0.200
    43.436     1.804     0.200
    43.460     1.949     0.200
    43.466     2.072     0.200
    43.493     2.280     0.200
    43.564     1.944     0.200
    43.564     2.476     0.200
    43.608     1.811     0.200
    43.608     1.358     0.200
    43.586     1.127     0.200
    43.708     0.154     0.200
    43.745     0.925     0.200
    43.857     1.585     0.200
    43.925     0.682     0.200
    43.966     2.136     0.200
    43.981     2.813     0.200
    43.989     1.353     0.200
    44.161     1.633     0.200
    44.154     2.512     0.200
    44.209     2.713     0.200
    44.251     1.740     0.200
    44.251     1.448     0.200
    44.380     2.029     0.200
    44.436     2.845     0.200
    44.498     2.198     0.200
    44.533     2.840     0.200
    44.589     2.685     0.200
    44.562     0.637     0.200
    44.644     2.052     0.200
    44.695     1.238     0.200
    44.709     1.639     0.200
    44.709     2.873     0.200
    44.729     2.942     0.200
    44.750     2.081     0.200
    44.869     2.268     0.200
    44.949     0.103     0.200
    45.003     1.241     0.200
    44.990     0.476     0.200
    45.061     1.268     0.200
    45.073     0.389     0.200
    45.073     0.343     0.200
    45.182     0.912     0.200
    45.238     2.141     0.200
    45.226    -0.170     0.200
    45.274    -0.254     0.200
    45.274    -0.855     0.200
    45.274     0.121     0.200
    45.350     1.561     0.200
    45.468     0.033     0.200
    45.503     2.105     0.200
    45.698     1.413     0.200
    45.895     1.328     0.200
    45.895     1.836     0.200
    46.022    -0.375     0.200
    46.164     6.189     0.200
    46.193     2.127     0.200
    46.397     0.076     0.200
    46.648     1.048     0.200
    46.772     1.017     0.200
    46.813     1.347     0.200
    46.813     2.719     0.200
    46.813     0.320     0.200
    46.830     2.020     0.200
    46.935     1.327     0.200
    47.265     1.466     0.200
    47.603     1.802     0.200
    47.665     1.289     0.200
    47.669     1.131     0.200
    47.828    -0.463     0.200
    47.828     0.045     0.200
    47.828    -0.685     0.200
    47.931     1.243     0.200
    47.931     0.423     0.200
    48.176     1.501     0.200
    48.336     1.896     0.200
    48.410     6.098     0.200
    48.432     1.719     0.200
    48.432    -0.731     0.200
    48.432     0.551     0.200
    48.512     0.938     0.200
    48.642     0.333     0.200
    48.710     1.578     0.200
    48.710    -0.344     0.200
    48.710     0.203     0.200
    49.056     0.244     0.200
    49.870     1.747     0.200
    49.951     1.002     0.200
    50.180     1.156     0.200
    50.180     0.766     0.200
    50.180     1.485     0.200
    50.653     1.633     0.200
    51.936     1.409     0.200
    52.774     1.315     0.200
    52.813    -0.912     0.200
    52.938     0.767     0.200
    54.021    -0.499     0.200
    54.061     1.852     0.200
    54.551     0.486     0.200
    54.586     1.498     0.200
    55.436     1.145     0.200
    55.420     0.084     0.200
    55.420    -0.026     0.200
    55.623     1.270     0.200
    56.212     0.284     0.200
    56.212     0.796     0.200
    56.481    -0.323     0.200
    56.753     1.272     0.200
    57.422     0.410     0.200
    57.450     0.409     0.200
    57.460     1.140     0.200
    57.460    -0.391     0.200
    58.344     0.949     0.200
    58.344     1.078     0.200
    59.133     1.809     0.200
    59.578     2.064     0.200
    59.597     1.999     0.200
    59.640     3.068     0.200
    59.718     2.307     0.200
    59.701     3.081     0.200
    59.906     1.655     0.200
    59.931     2.245     0.200
    60.376     1.286     0.200
    60.376     1.454     0.200
    60.511     2.575     0.200
    60.580     1.952     0.200
    60.628    -1.247     0.200
    60.757     1.323     0.200
    60.810     1.786     0.200
    60.899     1.592     0.200
    61.058     1.903     0.200
    61.756    -2.659     0.200
    61.756    -2.319     0.200
    62.475     0.306     0.200
    62.475     1.576     0.200
    62.613     0.989     0.200
    63.366     1.395     0.200
    67.401     0.036     0.200
    67.827     4.311     0.200
    72.666     2.098     0.200
    74.208    -0.592     0.200
    74.944    -0.248     0.200
    75.012     0.293     0.200
    75.332     0.331     0.200
    75.718     1.722     0.200
    75.573     0.224     0.200
    75.669     0.318     0.200
    75.710    -0.133     0.200
    75.862    -0.148     0.200
    75.862     0.044     0.200
    75.862     0.423     0.200
    75.930     0.096     0.200
    75.953     0.138     0.200
    76.258    -0.352     0.200
    76.384    -0.146     0.200
    76.468    -0.487     0.200
    76.500    -0.169     0.200
    76.704     0.235     0.200
    76.708    -0.611     0.200
    76.723    -0.024     0.200
    76.794    -0.493     0.200
    76.801    -0.847     0.200
    76.801    -0.854     0.200
    76.801    -0.726     0.200
    77.096    -0.053     0.200
    77.119     0.055     0.200
    77.263    -0.162     0.200
    77.529    -0.508     0.200
    77.733     0.052     0.200
    77.802    -0.496     0.200
    77.885    -0.396     0.200
    77.919    -0.536     0.200
    78.112     0.052     0.200
    78.142    -0.521     0.200
    78.159    -0.049     0.200
    78.683    -0.181     0.200
    78.922    -0.433     0.200
    78.924     0.656     0.200
    79.246     0.325     0.200
    79.248    -0.026     0.200
    79.375     0.554     0.200
    79.723     0.573     0.200
    81.645    -0.786     0.200
    81.870     0.550     0.200
    81.870     1.347     0.200
    82.254    -0.033     0.200
    82.880    -0.563     0.200
    83.112    -0.402     0.200
    83.112    -0.995     0.200
    83.112    -0.527     0.200
    83.112     0.075     0.200
    84.025     0.234     0.200
    84.025    -0.704     0.200
    84.325     0.179     0.200
    90.688     0.070     0.200
    90.688     1.652     0.200
    90.688     0.448     0.200
    96.417     0.152     0.200
    14.768     6.523     0.200
    14.893     6.137     0.200
    15.265     7.238     0.200
    15.919     6.607     0.200
    16.047     4.555     0.200
    16.266     5.704     0.200
    16.470     5.517     0.200
    16.729     4.888     0.200
    16.806     4.177     0.200
    16.808     4.853     0.200
    16.817     4.906     0.200
    17.008     4.603     0.200
    17.444     5.774     0.200
    17.708     4.062     0.200
    18.130     3.550     0.200
    18.295     1.650     0.200
    18.295     3.087     0.200
    18.305     2.808     0.200
    18.564     0.098     0.200
    18.564     0.691     0.200
    18.877     1.986     0.200
    19.068     2.098     0.200
    19.360     1.004     0.200
    19.471     1.566     0.200
    19.635     0.649     0.200
    19.669     1.173     0.200
    19.669     0.916     0.200
    19.920     1.320     0.200
    20.163     2.614     0.200
    20.289     1.373     0.200
    20.380     0.277     0.200
    20.317     2.929     0.200
    20.317     2.233     0.200
    20.526     2.468     0.200
    20.692     2.794     0.200
    20.767     1.752     0.200
    21.133     2.929     0.200
    21.332     2.479     0.200
    21.332     3.753     0.200
    21.332     4.487     0.200
    21.332     5.050     0.200
    21.332     0.714     0.200
    21.332     2.784     0.200
    21.392     3.072     0.200
    21.643     0.134     0.200
    21.643     0.196     0.200
    21.643     0.587     0.200
    21.838     1.600     0.200
    21.796     3.166     0.200
    22.021     2.692     0.200
    22.010     3.860     0.200
    22.357     3.743     0.200
    22.618     3.246     0.200
    22.647     4.231     0.200
    22.760     1.631     0.200
    23.019     4.286     0.200
    23.183     1.066     0.200
    23.248     0.686     0.200
    23.289     0.415     0.200
    23.289     0.110     0.200
    23.271     2.617     0.200
    23.308     0.988     0.200
    23.308     0.558     0.200
    23.308     0.659     0.200
    23.571     2.266     0.200
    23.507     2.014     0.200
    23.507     0.311     0.200
    23.507     2.608     0.200
    23.507     0.155     0.200
    23.507     1.155     0.200
    23.548     1.685     0.200
    24.202     0.737     0.200
    24.202     0.502     0.200
    24.648     1.181     0.200
    24.648     0.197     0.200
    24.648     1.986     0.200
    24.648     1.439     0.200
    25.107     2.755     0.200
    25.462     1.035     0.200
    25.524     4.761     0.200
    25.541     1.921     0.200
    25.861     3.017     0.200
    26.095     4.637     0.200
    26.219     4.724     0.200
    26.219     5.076     0.200
    26.662     1.176     0.200
    26.836     2.146     0.200
    26.916     1.531     0.200
    26.916     1.023     0.200
    26.940     3.072     0.200
    27.301     2.922     0.200
    27.368     1.716     0.200
    27.541     2.773     0.200
    27.810     3.365     0.200
    27.789     0.914     0.200
    27.789     0.351     0.200
    27.851     3.790     0.200
    27.947     0.138     0.200
    28.121     0.490     0.200
    28.164     4.703     0.200
    28.349     2.060     0.200
    28.295     2.472     0.200
    28.834     0.739     0.200
    29.048     3.229     0.200
    29.048     0.869     0.200
    29.048     2.838     0.200
    29.209     3.204     0.200
    29.320     2.380     0.200
    29.553     2.253     0.200
    29.553     1.011     0.200
    29.566     2.249     0.200
    29.591     2.886     0.200
    29.591     0.449     0.200
    29.625     1.923     0.200
    29.653     3.128     0.200
    29.809     0.334     0.200
    29.809     2.022     0.200
    29.809     1.733     0.200
    29.722     1.658     0.200
    29.828     0.425     0.200
    29.846     1.066     0.200
    29.840     2.113     0.200
    29.841     2.587     0.200
    29.841     1.907     0.200
    29.841     2.298     0.200
    29.841     2.806     0.200
    29.992     1.124     0.200
    29.992     2.077     0.200
    30.430     3.153     0.200
    30.427     3.369     0.200
    30.487     3.107     0.200
    30.487     2.943     0.200
    30.612     2.845     0.200
    30.612     1.720     0.200
    30.612     0.697     0.200
    30.959     1.136     0.200
    31.201     0.556     0.200
    31.201     1.173     0.200
    31.201     0.900     0.200
    31.201     1.306     0.200
    31.201     0.400     0.200
    31.339     0.481     0.200
    31.385     1.969     0.200
    31.685     2.299     0.200
    31.931     2.805     0.200
    32.128     3.264     0.200
    32.414     1.531     0.200
    32.422     2.067     0.200
    32.422     2.458     0.200
    32.614     2.582     0.200
    32.968     1.280     0.200
    33.053     2.833     0.200
    33.068     2.703     0.200
    33.221     0.271     0.200
    33.280     2.558     0.200
    33.417     3.047     0.200
    33.484     1.951     0.200
    33.720     2.629     0.200
    33.747     2.428     0.200
    33.841     2.365     0.200
    33.929     2.493     0.200
    33.949     0.236     0.200
    33.949     0.767     0.200
    33.949     1.025     0.200
    33.949     0.431     0.200
    33.949     0.627     0.200
    33.973     2.227     0.200
    34.000     2.043     0.200
    34.040     2.766     0.200
    34.147     1.720     0.200
    34.047     2.745     0.200
    34.080     1.277     0.200
    34.088     2.300     0.200
    34.090     2.730     0.200
    34.164     2.481     0.200
    34.166     2.794     0.200
    34.232     2.774     0.200
    34.294     4.532     0.200
    34.294     2.532     0.200
    34.314     2.913     0.200
    34.385     2.848     0.200
    34.385     2.746     0.200
    34.453     2.960     0.200
    34.563     2.014     0.200
    34.603     0.358     0.200
    34.693     3.277     0.200
    34.728     0.683     0.200
    34.755    -1.954     0.200
    34.768     3.073     0.200
    34.791     4.132     0.200
    35.003     1.509     0.200
    34.962     0.067     0.200
    34.984     3.764     0.200
    34.986     3.242     0.200
    35.009     3.403     0.200
    35.039     3.326     0.200
    35.040     2.646     0.200
    35.057     3.598     0.200
    35.077     2.271     0.200
    35.100     2.704     0.200
    35.208     2.307     0.200
    35.242     3.181     0.200
    35.271     3.852     0.200
    35.400     2.788     0.200
    35.366     0.779     0.200
    35.384     0.533     0.200
    35.404     3.370     0.200
    35.425     1.997     0.200
    35.447     3.233     0.200
    35.455     2.772     0.200
    35.455     0.321     0.200
    35.455     2.719     0.200
    35.478     2.351     0.200
    35.524     3.328     0.200
    35.520     2.506     0.200
    35.520     3.959     0.200
    35.577     2.687     0.200
    35.690     0.539     0.200
    35.738     2.785     0.200
    35.933     0.933     0.200
    35.933     0.339     0.200
    35.933     0.714     0.200
    35.933     0.511     0.200
    35.924     2.794     0.200
    35.928     3.188     0.200
    36.003     3.239     0.200
    36.184     2.668     0.200
    36.107     3.524     0.200
    36.122     0.495     0.200
    36.128     2.479     0.200
    36.141     0.834     0.200
    36.150     0.758     0.200
    36.148     2.740     0.200
    36.159     0.383     0.200
    36.193     2.851     0.200
    36.287     0.985     0.200
    36.386     1.299     0.200
    36.440     2.766     0.200
    36.484     2.608     0.200
    36.478     2.802     0.200
    36.504     2.936     0.200
    36.544     3.787     0.200
    36.631     3.424     0.200
    36.738     2.839     0.200
    36.683     3.326     0.200
    36.812     0.356     0.200
    36.756     0.986     0.200
    36.883     0.901     0.200
    36.811     3.059     0.200
    37.050     2.351     0.200
    37.187     3.007     0.200
    37.250     2.381     0.200
    37.322     1.253     0.200
    37.378     2.950     0.200
    37.397     2.641     0.200
    37.404     3.579     0.200
    37.523     2.771     0.200
    37.459     2.253     0.200
    37.490     0.351     0.200
    37.486     3.488     0.200
    37.534     3.076     0.200
    37.643     2.948     0.200
    37.661     3.145     0.200
    37.666     2.478     0.200
    37.706     2.222     0.200
    37.706     2.620     0.200
    37.749     2.054     0.200
    37.749     1.952     0.200
    37.798     2.913     0.200
    37.936    -0.220     0.200
    37.851     2.627     0.200
    37.881     2.807     0.200
    37.913     2.471     0.200
    37.942     2.248     0.200
    37.968     2.788     0.200
    38.015     1.769     0.200
    38.099     0.602     0.200
    38.147     0.296     0.200
    38.142     2.289     0.200
    38.176     2.465     0.200
    38.202     3.110     0.200
    38.235     0.919     0.200
    38.547     0.317     0.200
    38.518     2.670     0.200
    38.544     2.757     0.200
    38.583     2.598     0.200
    38.795     0.389     0.200
    38.879     0.647     0.200
    38.882     0.567     0.200
    38.882     0.723     0.200
    38.887     0.472     0.200
    38.917     2.247     0.200
    39.067    -0.083     0.200
    39.067     0.276     0.200
    39.183     1.705     0.200
    39.231    -1.300     0.200
    39.340     2.508     0.200
    39.358     2.149     0.200
    39.473     3.104     0.200
    39.494     3.078     0.200
    39.494     1.785     0.200
    39.521     3.341     0.200
    39.727     1.753     0.200
    39.850     1.536     0.200
    39.857     0.668     0.200
    39.857     1.957     0.200
    39.870     2.875     0.200
    40.030     2.883     0.200
    40.076     1.158     0.200
    40.087     2.169     0.200
    40.228     2.101     0.200
    40.319     2.349     0.200
    40.524     2.553     0.200
    40.437     2.465     0.200
    40.477     0.241     0.200
    40.477     1.780     0.200
    40.477     0.546     0.200
    40.537     2.347     0.200
    40.562    -1.860     0.200
    40.652     1.490     0.200
    40.792     3.419     0.200
    40.912     2.751     0.200
    40.956     0.684     0.200
    40.952     2.122     0.200
    41.108     0.154     0.200
    41.038    -0.894     0.200
    41.230     0.837     0.200
    41.111     1.208     0.200
    41.210     3.195     0.200
    41.225     1.968     0.200
    41.297     2.029     0.200
    41.297     2.373     0.200
    41.373     2.172     0.200
    41.403    -0.077     0.200
    41.476     2.327     0.200
    41.585     1.039     0.200
    41.585     0.820     0.200
    41.646     1.903     0.200
    41.740     2.027     0.200
    41.740     2.246     0.200
    41.792     1.814     0.200
    41.894     1.586     0.200
    41.937     1.233     0.200
    41.915     2.233     0.200
    41.915     2.514     0.200
    41.917     1.702     0.200
    41.981     2.182     0.200
    42.048     2.325     0.200
    42.048     2.426     0.200
    42.090     2.384     0.200
    42.114     2.099     0.200
    42.156     2.152     0.200
    42.160     2.314     0.200
    42.258     2.110     0.200
    42.263     2.178     0.200
    42.289     2.258     0.200
    42.289     2.309     0.200
    42.407     0.602     0.200
    42.438     2.250     0.200
    42.494     2.294     0.200
    42.637     1.734     0.200
    42.632     2.145     0.200
    42.632     2.567     0.200
    42.639     2.214     0.200
    42.694     2.429     0.200
    42.703     2.141     0.200
    42.740     1.153     0.200
    42.740     0.387     0.200
    42.857     2.348     0.200
    42.865     1.692     0.200
    42.865     0.575     0.200
    42.865     2.176     0.200
    43.024     2.351     0.200
    43.030     2.468     0.200
    43.030     1.944     0.200
    43.193     0.673     0.200
    43.210     2.282     0.200
    43.238     2.266     0.200
    43.306     2.715     0.200
    43.445     2.486     0.200
    43.363     2.694     0.200
    43.513     1.938     0.200
    43.420     2.993     0.200
    43.425     2.604     0.200
    43.431     2.004     0.200
    43.481     2.504     0.200
    43.482     2.616     0.200
    43.515     1.989     0.200
    43.583     2.379     0.200
    43.802    -0.184     0.200
    43.720     2.672     0.200
    43.836     1.510     0.200
    43.830     1.901     0.200
    43.830     0.214     0.200
    43.891     0.297     0.200
    43.896     1.753     0.200
    43.896     1.355     0.200
    43.934     1.858     0.200
    43.948     1.860     0.200
    44.037     2.255     0.200
    44.189     1.402     0.200
    44.198     2.237     0.200
    44.378     0.941     0.200
    44.337     0.924     0.200
    44.375     0.617     0.200
    44.576     2.010     0.200
    44.620     1.813     0.200
    44.728     1.900     0.200
    44.780     0.685     0.200
    44.780     1.787     0.200
    44.780     2.787     0.200
    44.799     1.383     0.200
    44.843     0.767     0.200
    45.244     0.412     0.200
    45.244     2.584     0.200
    45.244     3.490     0.200
    45.244     3.092     0.200
    45.298    -0.011     0.200
    45.317     0.611     0.200
    45.340     1.464     0.200
    45.373     1.203     0.200
    45.474     2.076     0.200
    45.555     0.012     0.200
    45.500     0.656     0.200
    45.555    -0.269     0.200
    45.516     0.118     0.200
    45.524     1.223     0.200
    45.558    -0.191     0.200
    45.653     1.382     0.200
    45.670     0.524     0.200
    45.675     0.780     0.200
    45.653     1.561     0.200
    45.634     1.141     0.200
    45.691     1.041     0.200
    45.712     0.087     0.200
    45.712     0.087     0.200
    45.712     0.110     0.200
    45.805     0.499     0.200
    45.831     0.638     0.200
    45.897     0.266     0.200
    45.898     0.762     0.200
    45.898     0.304     0.200
    45.906     1.215     0.200
    45.931     0.074     0.200
    45.939     3.695     0.200
    45.983     1.207     0.200
    46.171     0.039     0.200
    46.384     1.492     0.200
    46.373     0.413     0.200
    46.373     0.671     0.200
    46.373     0.179     0.200
    46.525     1.547     0.200
    46.683     3.344     0.200
    46.619     1.343     0.200
    46.805     2.186     0.200
    46.861     0.810     0.200
    46.930     0.991     0.200
    47.094     1.121     0.200
    47.242     0.978     0.200
    47.243     1.376     0.200
    47.243     0.900     0.200
    47.254     0.488     0.200
    47.199     2.810     0.200
    47.395     1.389     0.200
    47.429     0.234     0.200
    47.429     0.523     0.200
    47.429     1.820     0.200
    47.515    -0.281     0.200
    47.479     2.457     0.200
    47.479     2.762     0.200
    47.547     1.262     0.200
    47.609     0.812     0.200
    47.887     1.503     0.200
    47.960     1.209     0.200
    47.970     2.973     0.200
    48.156     0.847     0.200
    48.369     2.138     0.200
    48.547     0.911     0.200
    48.618     0.849     0.200
    48.648     1.884     0.200
    48.677     2.261     0.200
    48.677     2.667     0.200
    48.723     0.753     0.200
    48.824     1.734     0.200
    48.844     0.913     0.200
    49.081     0.968     0.200
    49.081     1.765     0.200
    49.206     1.808     0.200
    49.155     1.924     0.200
    49.203     1.662     0.200
    49.203     0.818     0.200
    49.203     0.443     0.200
    49.203     1.725     0.200
    49.441     1.878     0.200
    49.441     2.222     0.200
    49.441     1.112     0.200
    49.475     1.977     0.200
    49.589     0.449     0.200
    49.615     2.033     0.200
    49.664     1.210     0.200
    49.663     2.615     0.200
    49.862     1.652     0.200
    50.322     0.562     0.200
    50.322     1.383     0.200
    50.514     2.063     0.200
    51.313     0.557     0.200
    51.313     0.955     0.200
    51.313     2.314     0.200
    51.369     1.182     0.200
    51.558     1.230     0.200
    51.625     1.584     0.200
    51.799     0.280     0.200
    52.595     2.192     0.200
    52.809     0.604     0.200
    52.831     1.146     0.200
    52.861     0.431     0.200
    53.011     0.642     0.200
    53.090     3.343     0.200
    53.033     0.402     0.200
    53.056     0.002     0.200
    53.052     0.954     0.200
    53.156     0.594     0.200
    53.315     0.483     0.200
    53.237     0.478     0.200
    53.274     0.641     0.200
    53.288     0.993     0.200
    53.366     1.115     0.200
    53.373     0.287     0.200
    53.379     0.862     0.200
    53.397     1.980     0.200
    53.455     0.408     0.200
    53.456     0.573     0.200
    53.484     0.637     0.200
    53.699     0.745     0.200
    53.812     1.019     0.200
    53.817     1.591     0.200
    53.817     0.794     0.200
    53.763     0.298     0.200
    53.852     0.542     0.200
    53.898     0.413     0.200
    53.818     0.819     0.200
    53.912     0.530     0.200
    53.934     0.922     0.200
    54.041     0.962     0.200
    54.041     0.642     0.200
    54.041     0.368     0.200
    53.966     0.345     0.200
    53.996     0.308     0.200
    54.096     0.403     0.200
    54.098     0.825     0.200
    54.474     0.108     0.200
    54.534     0.327     0.200
    54.557     0.005     0.200
    55.523     0.526     0.200
    55.701     0.655     0.200
    55.726     0.759     0.200
    55.911     0.039     0.200
    55.911     0.344     0.200
    55.952     1.246     0.200
    56.030     0.789     0.200
    56.172     1.068     0.200
    56.172     0.771     0.200
    56.404     0.617     0.200
    56.404     0.516     0.200
    57.423     2.093     0.200
    57.913     0.445     0.200
    58.100     0.737     0.200
    58.128     1.336     0.200
    58.138     1.603     0.200
    58.138     0.346     0.200
    58.347     1.402     0.200
    58.463     2.595     0.200
    58.463     0.697     0.200
    58.463     0.595     0.200
    59.377    -0.856     0.200
    59.360     1.495     0.200
    59.792     2.091     0.200
    60.234     1.635     0.200
    60.315     0.299     0.200
    60.252     2.405     0.200
    60.292     2.089     0.200
    60.367     2.228     0.200
    60.437     2.324     0.200
    60.566     2.571     0.200
    60.599     2.113     0.200
    60.694     1.499     0.200
    60.863     0.898     0.200
    60.863     1.280     0.200
    60.806     0.718     0.200
    60.905     2.521     0.200
    60.921     1.636     0.200
    61.051     1.779     0.200
    61.124     2.615     0.200
    61.179     2.258     0.200
    61.244     2.410     0.200
    61.408     0.070     0.200
    61.408    -1.446     0.200
    61.408    -0.602     0.200
    61.420    -0.518     0.200
    61.349     0.340     0.200
    61.349     0.900     0.200
    62.113    -3.021     0.200
    61.430     1.757     0.200
    61.487     2.020     0.200
    61.579     2.104     0.200
    61.664     2.318     0.200
    61.718     1.694     0.200
    61.861     1.876     0.200
    61.976    -3.168     0.200
    62.440    -2.655     0.200
    62.440    -1.639     0.200
    61.938     1.881     0.200
    62.043     0.787     0.200
    61.979     2.215     0.200
    62.056     2.116     0.200
    62.231     0.684     0.200
    62.231     2.098     0.200
    62.231     2.172     0.200
    62.394     2.253     0.200
    62.438     0.751     0.200
    62.438     1.532     0.200
    62.438     1.235     0.200
    62.547     0.708     0.200
    62.637     0.469     0.200
    62.637     1.789     0.200
    62.703     0.170     0.200
    63.290     0.867     0.200
    63.487     2.840     0.200
    63.854     0.322     0.200
    63.854     1.244     0.200
    64.070     2.753     0.200
    64.070     0.620     0.200
    64.092     1.974     0.200
    67.192     1.299     0.200
    67.192     0.557     0.200
    67.844     3.038     0.200
    68.647     0.741     0.200
    69.144     1.992     0.200
    69.946     1.888     0.200
    69.957     2.192     0.200
    70.545     2.472     0.200
    70.566     2.866     0.200
    70.732     0.354     0.200
    70.705     2.434     0.200
    71.762     2.973     0.200
    72.451    -0.091     0.200
    72.451     1.706     0.200
    72.451     0.987     0.200
    72.951     3.141     0.200
    73.211     2.230     0.200
    73.211     1.582     0.200
    73.417     2.295     0.200
    73.482     3.185     0.200
    73.651     1.287     0.200
    73.651     2.319     0.200
    73.950    -0.202     0.200
    74.210     0.831     0.200
    74.298     0.133     0.200
    74.412     0.143     0.200
    74.412     0.643     0.200
    74.412     1.432     0.200
    74.412     1.143     0.200
    74.691     1.124     0.200
    74.739     0.691     0.200
    75.084     1.747     0.200
    74.692     2.570     0.200
    75.112     0.207     0.200
    75.714     0.528     0.200
    75.714     0.731     0.200
    75.780     0.447     0.200
    75.985     1.451     0.200
    75.985     0.686     0.200
    76.261     0.133     0.200
    76.243     1.684     0.200
    76.243     1.809     0.200
    76.243     0.512     0.200
    76.407     3.132     0.200
    76.407     3.382     0.200
    76.487    -0.472     0.200
    76.566    -1.320     0.200
    76.566    -0.976     0.200
    76.566    -0.437     0.200
    76.581    -1.106     0.200
    76.979     0.252     0.200
    77.887    -0.127     0.200
    78.739    -0.444     0.200
    78.988    -0.516     0.200
    79.156     0.588     0.200
    80.636     2.005     0.200
    80.942     0.157     0.200
    81.212     0.578     0.200
    81.212     0.276     0.200
    81.212    -0.185     0.200
    81.212     0.580     0.200
    81.220     0.932     0.200
    81.220     0.534     0.200
    81.437     0.813     0.200
    83.054     0.030     0.200
    83.054    -0.197     0.200
    83.054     0.225     0.200
    83.054     0.022     0.200
    83.390     0.620     0.200
    83.390     1.073     0.200
    83.421     0.727     0.200
    83.675     0.422     0.200
    84.572     0.050     0.200
    85.363     1.225     0.200
    89.972     0.235     0.200
    90.712     1.279     0.200
    90.722     0.065     0.200
    90.722     0.526     0.200
    90.722     0.831     0.200
    92.427     0.728     0.200
    93.880    -0.810     0.200
    94.600    -1.133     0.200
    94.600    -0.376     0.200
    95.845     1.244     0.200
    15.951     6.552     0.200
    17.008     3.004     0.200
    18.280     0.967     0.200
    18.557    -0.306     0.200
    19.362     1.685     0.200
    21.339     2.173     0.200
    21.339    -0.819     0.200
    21.646     0.404     0.200
    21.646     0.228     0.200
    23.190     1.321     0.200
    23.315     1.357     0.200
    23.296    -0.363     0.200
    23.296     0.407     0.200
    23.296     1.110     0.200
    23.515     1.164     0.200
    23.569     3.271     0.200
    29.553     2.857     0.200
    29.553     1.825     0.200
    29.560     1.690     0.200
    29.565     1.642     0.200
    29.848     2.590     0.200
    29.802     0.954     0.200
    29.802     2.204     0.200
    29.802     0.954     0.200
    29.991     1.932     0.200
    29.991     3.170     0.200
    31.209     0.024     0.200
    32.121     4.234     0.200
    32.581     1.897     0.200
    33.957     0.445     0.200
    33.957     1.160     0.200
    33.957    -0.442     0.200
    33.957     1.261     0.200
    34.611     0.795     0.200
    34.736    -0.388     0.200
    34.993     2.784     0.200
    34.881     1.822     0.200
    35.391    -0.535     0.200
    35.527     3.901     0.200
    35.698    -1.011     0.200
    35.938     1.071     0.200
    35.938     0.880     0.200
    35.938     1.571     0.200
    36.130    -0.369     0.200
    36.148    -0.567     0.200
    36.394     0.942     0.200
    36.448     2.265     0.200
    36.814     0.489     0.200
    37.806     2.934     0.200
    37.920     2.086     0.200
    37.929     2.141     0.200
    37.949     1.901     0.200
    38.886     0.091     0.200
    38.889     0.698     0.200
    39.028     0.831     0.200
    39.502     2.715     0.200
    39.494     0.593     0.200
    39.734     2.154     0.200
    39.865     1.607     0.200
    41.006     2.084     0.200
    41.305     2.386     0.200
    41.800     2.001     0.200
    42.097     2.540     0.200
    42.122     1.969     0.200
    42.415     0.557     0.200
    42.415     0.725     0.200
    42.748     0.250     0.200
    42.748     0.977     0.200
    42.748     0.281     0.200
    42.785     0.649     0.200
    43.377     2.788     0.200
    43.427     1.431     0.200
    43.427    -0.459     0.200
    43.438     2.813     0.200
    43.522     1.517     0.200
    43.446     2.902     0.200
    43.513     1.457     0.200
    43.838     1.270     0.200
    43.838    -0.496     0.200
    43.801     0.639     0.200
    44.001     0.533     0.200
    44.383     0.348     0.200
    44.901     1.303     0.200
    44.901    -0.435     0.200
    45.129     1.671     0.200
    45.270     1.151     0.200
    45.720    -0.053     0.200
    45.720    -0.003     0.200
    45.651     1.346     0.200
    45.651     1.685     0.200
    45.651     2.083     0.200
    46.146    -0.153     0.200
    46.053     1.820     0.200
    46.383     1.315     0.200
    47.575     1.144     0.200
    47.950     1.475     0.200
    49.096     2.102     0.200
    49.210     1.428     0.200
    49.441     1.600     0.200
    50.329     1.324     0.200
    52.362     0.623     0.200
    53.464     0.297     0.200
    53.809     1.406     0.200
    53.815     1.209     0.200
    53.815     1.319     0.200
    54.081     2.306     0.200
    55.194     1.679     0.200
    55.388     2.365     0.200
    56.411     0.990     0.200
    57.910     2.354     0.200
    58.145     1.640     0.200
    58.145     0.265     0.200
    58.470    -0.008     0.200
    58.470     2.062     0.200
    59.135     1.648     0.200
    60.611     2.126     0.200
    61.494     2.178     0.200
    64.099     2.347     0.200
    67.148     0.859     0.200
    67.185     0.905     0.200
    67.951     1.453     0.200
    69.998     0.337     0.200
    75.617     0.222     0.200
    75.690     0.815     0.200
    75.719     0.475     0.200
    75.982     0.457     0.200
    76.225    -0.285     0.200
    76.571    -0.157     0.200
    76.571    -0.665     0.200
    76.571    -0.778     0.200
    78.059     4.793     0.200
    79.161     0.755     0.200
    80.770     0.068     0.200
    80.946    -0.106     0.200
    81.204     1.466     0.200
    83.059     0.205     0.200
    83.059    -0.131     0.200
    83.383     1.118     0.200
    83.383     0.782     0.200
    85.356     4.348     0.200
    96.662     1.906     0.200
    14.893     6.148     0.200
    15.956     5.354     0.200
    18.317     1.171     0.200
    18.338     1.530     0.200
    18.578    -1.856     0.200
    19.360     0.921     0.200
    20.396     0.227     0.200
    21.316     1.426     0.200
    21.316    -0.951     0.200
    21.316     4.680     0.200
    21.639     0.381     0.200
    22.083     4.287     0.200
    22.372     4.236     0.200
    22.744     3.629     0.200
    23.292     0.490     0.200
    23.292     1.353     0.200
    23.292     1.754     0.200
    23.329     5.563     0.200
    23.276     0.887     0.200
    23.276     1.319     0.200
    23.276     2.118     0.200
    23.491     2.157     0.200
    23.581     3.038     0.200
    24.187     0.700     0.200
    24.638     1.642     0.200
    24.638    -0.457     0.200
    26.932     0.359     0.200
    27.775     1.240     0.200
    29.051     2.776     0.200
    29.558     1.475     0.200
    29.558     0.860     0.200
    29.708     3.133     0.200
    29.565     1.715     0.200
    29.571     1.666     0.200
    29.826     0.997     0.200
    29.826     3.307     0.200
    29.825     1.099     0.200
    29.825     1.914     0.200
    29.844     0.247     0.200
    29.997     2.825     0.200
    29.997     2.594     0.200
    31.186     1.999     0.200
    33.934     0.179     0.200
    33.934     0.784     0.200
    33.934     1.134     0.200
    33.934     1.134     0.200
    34.587     2.067     0.200
    34.712     0.186     0.200
    34.739    -0.745     0.200
    34.970     3.324     0.200
    35.368     0.037     0.200
    35.440     2.817     0.200
    35.503     3.688     0.200
    35.675     1.208     0.200
    35.927     0.168     0.200
    35.927     1.037     0.200
    35.927     0.338     0.200
    36.106     1.401     0.200
    36.125     1.542     0.200
    36.134     1.164     0.200
    36.371     1.409     0.200
    36.424     2.470     0.200
    36.619     3.867     0.200
    36.812    -0.498     0.200
    37.034     2.781     0.200
    37.474     1.051     0.200
    37.782     2.738     0.200
    37.926     2.445     0.200
    38.528     3.289     0.200
    38.867     0.258     0.200
    38.867     0.517     0.200
    39.005     0.977     0.200
    39.218     0.683     0.200
    39.478     3.006     0.200
    39.472     0.236     0.200
    39.710    -0.520     0.200
    40.462     0.250     0.200
    40.502     1.227     0.200
    40.983     1.787     0.200
    41.121     1.340     0.200
    41.281     2.403     0.200
    41.281     1.983     0.200
    41.924     1.156     0.200
    42.074     2.314     0.200
    42.273     2.317     0.200
    42.394     0.685     0.200
    42.394     0.564     0.200
    42.727     1.198     0.200
    42.727     0.528     0.200
    42.727     0.688     0.200
    42.764     0.451     0.200
    43.180     0.313     0.200
    43.354     2.504     0.200
    43.405     2.144     0.200
    43.405     1.505     0.200
    43.499     1.916     0.200
    43.518     1.580     0.200
    43.814     1.285     0.200
    43.823     0.583     0.200
    43.809    -0.360     0.200
    44.092     1.904     0.200
    44.323     1.031     0.200
    44.360     0.215     0.200
    44.877     1.669     0.200
    44.877     0.640     0.200
    45.105     1.498     0.200
    45.249     1.678     0.200
    45.246     1.106     0.200
    45.284     0.014     0.200
    45.501    -0.099     0.200
    45.486     0.294     0.200
    45.510     1.055     0.200
    45.647     0.314     0.200
    45.662     1.259     0.200
    45.697     0.084     0.200
    45.697    -0.144     0.200
    45.791     0.783     0.200
    45.884     0.488     0.200
    45.884     1.502     0.200
    46.917     0.732     0.200
    47.275     0.570     0.200
    47.381     1.665     0.200
    47.816     1.619     0.200
    47.927     1.641     0.200
    48.603     1.029     0.200
    49.065     1.871     0.200
    49.073     2.096     0.200
    49.191     1.388     0.200
    49.191     0.720     0.200
    49.191     0.978     0.200
    49.426     2.033     0.200
    50.102     4.216     0.200
    50.498     2.097     0.200
    52.804     1.761     0.200
    53.440    -0.991     0.200
    53.820     0.924     0.200
    53.826    -0.517     0.200
    55.365     2.341     0.200
    56.391     0.398     0.200
    58.122     1.221     0.200
    58.122     0.535     0.200
    58.447     0.902     0.200
    58.447     1.962     0.200
    58.605     2.169     0.200
    59.112     1.505     0.200
    61.035     1.575     0.200
    61.471     2.178     0.200
    62.690     1.054     0.200
    68.025     0.573     0.200
    69.988     0.105     0.200
    73.209     2.204     0.200
    73.945    -0.358     0.200
    74.399    -0.326     0.200
    74.733    -0.003     0.200
    75.707     0.348     0.200
    75.707    -0.622     0.200
    76.001     0.454     0.200
    76.242     1.743     0.200
    76.242     0.102     0.200
    76.255    -0.096     0.200
    76.255    -0.276     0.200
    76.561    -0.829     0.200
    77.269    -0.399     0.200
    77.903     0.662     0.200
    79.151     0.791     0.200
    80.938    -0.049     0.200
    81.228    -0.190     0.200
    81.228     0.610     0.200
    82.681    -0.371     0.200
    82.681    -0.270     0.200
    83.045    -0.184     0.200
    83.406     0.278     0.200
    83.406    -0.181     0.200
    83.661     0.156     0.200
    18.314     1.788     0.200
    21.311     4.717     0.200
    21.311     0.794     0.200
    21.639     0.400     0.200
    23.287     1.484     0.200
    23.273     1.184     0.200
    23.584     2.680     0.200
    29.560     2.082     0.200
    29.560     1.852     0.200
    29.821     2.710     0.200
    29.830     2.745     0.200
    33.929     0.753     0.200
    33.929     0.019     0.200
    36.813    -0.032     0.200
    38.863     0.364     0.200
    39.767     0.874     0.200
    39.836     0.627     0.200
    41.921     1.321     0.200
    42.723     1.082     0.200
    42.723    -0.319     0.200
    43.176     0.405     0.200
    43.400    -0.124     0.200
    43.810     1.864     0.200
    43.810     1.024     0.200
    43.820     1.273     0.200
    44.356     0.145     0.200
    44.826     1.299     0.200
    45.280     0.144     0.200
    45.300     0.241     0.200
    45.496    -0.339     0.200
    45.482     0.761     0.200
    45.693    -0.054     0.200
    45.693    -0.179     0.200
    45.666     1.556     0.200
    45.787     0.560     0.200
    45.880     0.905     0.200
    46.153     0.524     0.200
    46.353     0.341     0.200
    47.590    -1.392     0.200
    49.421     2.895     0.200
    49.421     0.159     0.200
    53.436     0.395     0.200
    54.678     0.342     0.200
    58.115     0.869     0.200
    58.117     1.708     0.200
    58.117     0.269     0.200
    58.442     0.384     0.200
    74.732    -0.548     0.200
    75.045     0.393     0.200
    75.706    -0.208     0.200
    75.823     1.043     0.200
    76.240     1.357     0.200
    76.215     0.501     0.200
    76.377     0.838     0.200
    76.448    -0.072     0.200
    76.560    -0.310     0.200
    83.043    -0.178     0.200
    83.411     0.657     0.200
    83.411     1.530     0.200
    83.658     0.355     0.200
    83.658     0.860     0.200
    21.009     1.153     0.200
    21.669     0.378     0.200
    21.669     0.549     0.200
    23.287     2.729     0.200
    23.292     1.251     0.200
    23.607     2.543     0.200
    29.816     1.435     0.200
    29.832     2.094     0.200
    33.934     1.618     0.200
    36.842     0.061     0.200
    38.876     0.554     0.200
    42.742     1.009     0.200
    43.548     2.082     0.200
    44.367     0.668     0.200
    45.705     0.367     0.200
    58.116     1.979     0.200
    81.232     0.899     0.200
    83.069     0.563     0.200
    83.409     1.389     0.200
    14.807     5.015     0.200
    15.986     5.405     0.200
    18.300     0.831     0.200
    18.363     0.537     0.200
    18.385     1.120     0.200
    19.399     1.301     0.200
    20.380     0.261     0.200
    20.380     1.011     0.200
    21.037     2.338     0.200
    21.334     3.271     0.200
    21.334     1.945     0.200
    21.334     2.501     0.200
    21.683     0.255     0.200
    22.247     1.951     0.200
    22.391     3.690     0.200
    22.768     1.294     0.200
    23.330    -0.577     0.200
    23.315     1.995     0.200
    23.315     0.320     0.200
    23.315     1.620     0.200
    23.320     0.728     0.200
    23.320     1.168     0.200
    23.320     2.268     0.200
    23.516     2.836     0.200
    23.516     0.156     0.200
    23.597     3.039     0.200
    24.622     1.714     0.200
    24.622     1.304     0.200
    25.525     3.283     0.200
    27.817     2.115     0.200
    28.163    -1.041     0.200
    29.606     1.565     0.200
    29.587     1.244     0.200
    29.587     2.224     0.200
    29.594     1.919     0.200
    29.712     2.806     0.200
    29.805     1.848     0.200
    29.775     2.658     0.200
    30.025     0.499     0.200
    30.025     2.499     0.200
    31.222     1.036     0.200
    32.124     3.699     0.200
    32.580     2.162     0.200
    33.050     1.198     0.200
    33.931     0.618     0.200
    33.960     0.766     0.200
    33.964     0.856     0.200
    33.964     1.331     0.200
    33.964     1.311     0.200
    33.964     1.131     0.200
    33.971     0.672     0.200
    34.066     0.748     0.200
    34.093     0.711     0.200
    35.528     2.365     0.200
    35.709    -0.010     0.200
    35.973     0.482     0.200
    35.973     1.197     0.200
    35.973     1.607     0.200
    36.138     1.661     0.200
    36.151     2.068     0.200
    36.851     0.410     0.200
    37.058     2.453     0.200
    37.319     0.857     0.200
    37.954     2.300     0.200
    38.061     2.676     0.200
    38.118     0.883     0.200
    38.118     1.023     0.200
    38.557     1.684     0.200
    38.843     2.274     0.200
    38.906     0.931     0.200
    38.906     0.166     0.200
    39.097     1.188     0.200
    39.097     0.768     0.200
    39.261     0.189     0.200
    39.507     2.829     0.200
    39.872    -2.722     0.200
    40.645     0.907     0.200
    40.847     1.495     0.200
    41.957     2.397     0.200
    41.968     1.100     0.200
    42.115     3.827     0.200
    42.438    -0.338     0.200
    42.776     1.005     0.200
    42.770     1.210     0.200
    42.770     1.174     0.200
    42.770     0.879     0.200
    43.222     0.898     0.200
    43.423     2.569     0.200
    43.423     0.599     0.200
    43.485     1.847     0.200
    43.842     1.796     0.200
    43.842     2.066     0.200
    43.868     1.253     0.200
    44.041     1.636     0.200
    44.091     2.080     0.200
    44.117     2.121     0.200
    44.118     1.495     0.200
    44.366     1.091     0.200
    44.397     0.795     0.200
    44.545     1.912     0.200
    44.572     1.381     0.200
    44.710     1.165     0.200
    44.785     1.080     0.200
    44.903     1.193     0.200
    45.010     1.557     0.200
    45.271     1.187     0.200
    45.345     1.138     0.200
    45.533     0.265     0.200
    45.528     0.868     0.200
    45.538     0.270     0.200
    45.610     0.933     0.200
    45.679     1.651     0.200
    45.735     0.064     0.200
    45.735     0.364     0.200
    45.735     0.289     0.200
    45.832     0.486     0.200
    45.925     1.684     0.200
    46.361     1.981     0.200
    46.881     1.702     0.200
    47.156     0.747     0.200
    47.233     2.188     0.200
    47.274     1.389     0.200
    47.301     0.431     0.200
    47.440     0.295     0.200
    48.424     1.318     0.200
    49.305     1.306     0.200
    49.237     1.461     0.200
    49.237     0.979     0.200
    49.237     1.111     0.200
    49.441     1.702     0.200
    49.441     1.297     0.200
    50.356     1.224     0.200
    50.524     1.559     0.200
    52.765     0.195     0.200
    53.408     1.664     0.200
    53.474    -0.385     0.200
    53.844    -0.808     0.200
    54.705     1.538     0.200
    56.436     0.188     0.200
    56.436     0.668     0.200
    58.106     0.078     0.200
    58.144     1.563     0.200
    58.144     1.102     0.200
    58.469     1.439     0.200
    58.469     0.039     0.200
    61.058     1.068     0.200
    62.734     2.417     0.200
    64.034     1.054     0.200
    64.034     1.334     0.200
    70.516    -0.026     0.200
    73.976     1.277     0.200
    73.976     1.382     0.200
    74.396     1.699     0.200
    74.396     0.649     0.200
    74.333    -0.072     0.200
    74.778     0.282     0.200
    75.772    -0.690     0.200
    76.210    -0.258     0.200
    76.301    -0.492     0.200
    76.493    -0.094     0.200
    76.606    -0.875     0.200
    76.606    -0.544     0.200
    76.754    -0.191     0.200
    77.074    -0.124     0.200
    77.740     0.360     0.200
    77.927     0.053     0.200
    77.950    -0.387     0.200
    78.499     0.894     0.200
    81.204     1.054     0.200
    81.204     0.574     0.200
    83.092     0.127     0.200
    83.380     1.069     0.200
    15.994     4.965     0.200
    18.287     0.987     0.200
    18.357    -0.003     0.200
    18.379     0.556     0.200
    20.397     0.090     0.200
    21.020     2.991     0.200
    21.317     1.565     0.200
    21.317     4.205     0.200
    21.683     0.741     0.200
    21.683     0.038     0.200
    21.683     0.616     0.200
    23.206     1.132     0.200
    23.299     0.685     0.200
    23.299     1.259     0.200
    23.310     0.485     0.200
    23.310     0.946     0.200
    23.499     2.502     0.200
    23.610     2.289     0.200
    24.210     0.803     0.200
    24.327    -2.285     0.200
    24.609    -0.428     0.200
    26.928     2.860     0.200
    29.595     1.752     0.200
    29.825     1.586     0.200
    29.822     0.827     0.200
    30.034     1.284     0.200
    30.034     2.238     0.200
    31.207     0.029     0.200
    33.915     0.019     0.200
    33.944    -0.131     0.200
    33.948     1.181     0.200
    33.948     0.533     0.200
    33.948    -0.366     0.200
    33.948     1.103     0.200
    34.009    -0.197     0.200
    34.031     0.108     0.200
    34.077    -0.286     0.200
    34.725    -0.102     0.200
    34.978     3.301     0.200
    35.511     3.839     0.200
    35.693     0.105     0.200
    35.969     0.901     0.200
    35.969    -0.220     0.200
    35.969     0.600     0.200
    36.122     2.096     0.200
    36.135     2.103     0.200
    36.390     1.185     0.200
    36.432     2.545     0.200
    36.854    -0.032     0.200
    37.497     0.568     0.200
    37.497    -0.214     0.200
    37.652     2.823     0.200
    37.952     2.404     0.200
    38.102     1.213     0.200
    38.171     2.691     0.200
    38.198     0.746     0.200
    38.536     2.595     0.200
    38.536     2.966     0.200
    38.827     2.154     0.200
    38.892     0.710     0.200
    39.028     0.982     0.200
    39.085    -0.641     0.200
    39.490     2.978     0.200
    39.502     0.500     0.200
    39.553     1.144     0.200
    39.721     2.520     0.200
    40.706     0.244     0.200
    40.991     1.731     0.200
    41.103     2.280     0.200
    41.294     2.364     0.200
    41.328     2.405     0.200
    41.379     0.263     0.200
    41.789     2.156     0.200
    41.911     2.339     0.200
    41.956     1.095     0.200
    42.044     2.352     0.200
    42.087     2.322     0.200
    42.112     2.160     0.200
    42.426     0.659     0.200
    42.758     1.547     0.200
    42.758     0.832     0.200
    42.758     0.649     0.200
    43.210     0.759     0.200
    43.406     2.397     0.200
    43.406    -0.052     0.200
    43.601     1.528     0.200
    43.826     2.039     0.200
    43.826     1.691     0.200
    43.826    -0.219     0.200
    44.011     0.052     0.200
    44.101     2.118     0.200
    44.354     1.721     0.200
    44.383     0.374     0.200
    44.698     1.888     0.200
    44.752     2.895     0.200
    44.886     1.846     0.200
    44.886     0.889     0.200
    45.119     1.675     0.200
    45.190     2.655     0.200
    45.312    -0.058     0.200
    45.261     1.297     0.200
    45.263     1.534     0.200
    45.332     0.543     0.200
    45.515     0.892     0.200
    45.523     0.258     0.200
    45.523    -0.004     0.200
    45.538     1.445     0.200
    45.597     0.535     0.200
    45.670     0.400     0.200
    45.720    -0.361     0.200
    45.720    -0.010     0.200
    45.692     0.493     0.200
    45.911     0.866     0.200
    45.912     1.378     0.200
    45.912     0.508     0.200
    46.317     1.746     0.200
    46.344     3.034     0.200
    46.344     0.855     0.200
    46.519     1.616     0.200
    46.861     1.136     0.200
    46.951     0.786     0.200
    47.284     1.121     0.200
    47.561     1.600     0.200
    47.555     0.175     0.200
    47.555    -0.333     0.200
    47.618     1.113     0.200
    48.214     1.960     0.200
    48.407     0.799     0.200
    48.673     2.954     0.200
    48.986     2.231     0.200
    49.073    -0.136     0.200
    49.082     2.206     0.200
    49.200     2.555     0.200
    49.227     1.216     0.200
    49.227     1.052     0.200
    49.227     0.287     0.200
    49.424     1.644     0.200
    50.086    -0.934     0.200
    53.392     1.699     0.200
    53.459     0.289     0.200
    54.289     2.429     0.200
    56.072     0.007     0.200
    56.072    -0.368     0.200
    56.426     0.517     0.200
    57.390     2.119     0.200
    58.127     1.741     0.200
    58.127     0.163     0.200
    58.452     1.749     0.200
    59.117     1.572     0.200
    60.356     1.072     0.200
    60.428     2.573     0.200
    60.356     0.385     0.200
    61.041     2.024     0.200
    61.476     2.220     0.200
    64.027     2.129     0.200
    64.027     2.691     0.200
    65.800     0.035     0.200
    67.909     2.816     0.200
    70.758     0.003     0.200
    74.087    -0.313     0.200
    74.087     0.715     0.200
    74.381     0.261     0.200
    74.381    -0.399     0.200
    74.776     0.010     0.200
    75.089    -0.356     0.200
    75.750     0.427     0.200
    76.200    -0.162     0.200
    76.259     0.136     0.200
    76.421     0.259     0.200
    76.604    -0.744     0.200
    76.604    -0.901     0.200
    76.707     0.259     0.200
    76.742    -0.770     0.200
    77.781    -0.005     0.200
    78.758    -0.002     0.200
    81.220     0.277     0.200
    81.220    -0.414     0.200
    81.220     1.226     0.200
    83.086    -0.103     0.200
    83.086    -0.329     0.200
    83.101     0.201     0.200
    83.397     1.146     0.200
    83.397     1.607     0.200
    83.765     0.324     0.200
    90.751    -0.153     0.200
    90.751     1.597     0.200
    15.087     5.370     0.200
    16.152     4.063     0.200
    17.177     2.776     0.200
    17.177     2.635     0.200
    18.502     0.279     0.200
    18.328     1.270     0.200
    18.328     0.122     0.200
    18.460     1.494     0.200
    18.481     1.580     0.200
    19.555     2.214     0.200
    19.808    -0.643     0.200
    20.472     0.037     0.200
    21.247     4.726     0.200
    21.247     0.960     0.200
    21.247     2.405     0.200
    21.247     0.163     0.200
    21.825     0.241     0.200
    21.903     3.773     0.200
    22.317     4.911     0.200
    22.322     4.068     0.200
    22.944     4.415     0.200
    23.251     0.919     0.200
    23.251     2.044     0.200
    23.284     2.096     0.200
    23.278     1.056     0.200
    23.373     1.158     0.200
    23.373     0.556     0.200
    23.423     1.952     0.200
    23.452     2.890     0.200
    23.452    -0.044     0.200
    23.757     3.390     0.200
    24.239    -0.018     0.200
    24.225     1.421     0.200
    25.479     3.510     0.200
    27.500     2.977     0.200
    27.741     2.526     0.200
    27.939     1.553     0.200
    29.753     2.214     0.200
    29.885     0.719     0.200
    29.885     0.860     0.200
    29.751     2.555     0.200
    29.751     2.708     0.200
    29.751     1.657     0.200
    31.215     1.332     0.200
    31.215     0.929     0.200
    31.215     0.230     0.200
    33.893     0.980     0.200
    33.922     0.831     0.200
    33.927     1.116     0.200
    33.927     0.761     0.200
    33.927    -0.111     0.200
    33.927     1.190     0.200
    33.927     0.530     0.200
    33.933     0.329     0.200
    33.988     0.262     0.200
    34.010    -0.128     0.200
    34.028    -0.091     0.200
    34.056    -0.529     0.200
    34.700     0.795     0.200
    35.464     4.040     0.200
    36.097     0.081     0.200
    36.092     1.425     0.200
    36.092     1.062     0.200
    36.384     2.743     0.200
    36.386     1.642     0.200
    37.509    -0.233     0.200
    37.509     1.068     0.200
    37.749     3.294     0.200
    38.213    -0.370     0.200
    38.844     0.525     0.200
    38.916     0.497     0.200
    38.916     0.972     0.200
    39.302     0.092     0.200
    40.564     2.759     0.200
    40.947     1.868     0.200
    41.135     0.230     0.200
    41.264     2.037     0.200
    41.880     3.017     0.200
    41.880     1.853     0.200
    42.247     0.898     0.200
    42.655     1.698     0.200
    42.758     0.569     0.200
    42.812     0.898     0.200
    42.812     0.374     0.200
    43.030     1.828     0.200
    43.290     2.952     0.200
    43.260     0.443     0.200
    43.317     2.386     0.200
    43.339     2.625     0.200
    43.376     2.171     0.200
    43.472     1.901     0.200
    43.793     1.602     0.200
    43.793     0.313     0.200
    43.851     1.239     0.200
    43.905     1.583     0.200
    43.911     0.968     0.200
    44.020     1.389     0.200
    44.164     1.423     0.200
    44.395     0.654     0.200
    44.559     0.911     0.200
    44.575     1.706     0.200
    44.751     0.380     0.200
    44.742    -0.011     0.200
    44.844     0.695     0.200
    45.347    -0.302     0.200
    45.295     0.882     0.200
    45.329     0.985     0.200
    45.366     2.902     0.200
    45.372     0.992     0.200
    45.537     0.052     0.200
    45.557     0.546     0.200
    45.590     1.024     0.200
    45.574     0.895     0.200
    45.647     0.881     0.200
    45.685     0.629     0.200
    45.735     0.429     0.200
    45.735    -0.071     0.200
    45.735     0.229     0.200
    45.840     2.011     0.200
    45.840     1.600     0.200
    45.862     1.127     0.200
    45.937     1.098     0.200
    46.481     1.317     0.200
    46.545     1.432     0.200
    48.621     2.375     0.200
    48.645     3.310     0.200
    49.348     2.492     0.200
    49.348    -0.184     0.200
    49.302     0.878     0.200
    52.756     0.370     0.200
    53.023     0.718     0.200
    53.453    -0.097     0.200
    54.006     1.810     0.200
    54.006     1.533     0.200
    54.634     0.617     0.200
    56.108     0.005     0.200
    56.493     0.161     0.200
    58.073     1.559     0.200
    58.073     0.329     0.200
    59.736     1.498     0.200
    60.179     1.624     0.200
    60.239     2.593     0.200
    60.315     1.990     0.200
    60.378     2.270     0.200
    60.510     1.574     0.200
    60.539     2.034     0.200
    60.632     1.290     0.200
    60.988     1.628     0.200
    61.118     2.445     0.200
    61.186     2.138     0.200
    61.262     0.225     0.200
    62.051    -2.986     0.200
    61.669     2.240     0.200
    61.914     2.296     0.200
    75.871    -0.272     0.200
    76.736    -0.080     0.200
    76.736    -0.420     0.200
    76.736    -0.232     0.200
    77.843    -0.163     0.200
    80.884    -0.194     0.200
    81.268    -0.066     0.200
    81.268    -0.558     0.200
    83.195     0.073     0.200
    83.195    -0.306     0.200
    83.436     0.634     0.200
    83.436    -0.065     0.200
    15.130     5.169     0.200
    17.423     3.202     0.200
    17.423     2.971     0.200
    17.423     1.301     0.200
    18.701     0.482     0.200
    18.781     0.967     0.200
    18.803     1.274     0.200
    18.803     0.843     0.200
    19.709     1.663     0.200
    20.249     0.986     0.200
    21.139     2.521     0.200
    21.297     1.241     0.200
    21.555     2.721     0.200
    21.555     3.501     0.200
    21.555     1.911     0.200
    22.042     0.099     0.200
    22.042     0.118     0.200
    23.039     1.072     0.200
    23.588     0.226     0.200
    23.685     3.735     0.200
    23.790    -0.426     0.200
    23.790     0.264     0.200
    28.315     1.807     0.200
    29.355    -0.220     0.200
    29.355     1.580     0.200
    29.359     1.518     0.200
    29.570    -0.371     0.200
    30.052     1.969     0.200
    33.226     1.523     0.200
    34.286     0.887     0.200
    34.286     1.412     0.200
    34.286     1.542     0.200
    34.286     1.362     0.200
    35.271     3.086     0.200
    35.801     3.583     0.200
    35.801     3.243     0.200
    36.058     1.881     0.200
    36.372    -0.108     0.200
    36.720     2.305     0.200
    37.160    -0.312     0.200
    37.784     2.656     0.200
    37.946     3.045     0.200
    38.092     2.531     0.200
    38.226     1.286     0.200
    38.263     2.675     0.200
    38.663     3.155     0.200
    38.827     2.513     0.200
    39.140     2.721     0.200
    39.292     0.266     0.200
    39.772     3.309     0.200
    39.813     3.782     0.200
    40.031     2.570     0.200
    40.128     1.913     0.200
    40.129     2.411     0.200
    40.904     1.910     0.200
    41.233     2.526     0.200
    41.287     1.805     0.200
    41.425     2.711     0.200
    41.618     2.458     0.200
    41.726     2.763     0.200
    41.731     2.556     0.200
    41.790     2.463     0.200
    41.854     2.632     0.200
    41.939     2.765     0.200
    41.985     2.739     0.200
    42.116     2.435     0.200
    42.116     1.076     0.200
    42.269     1.832     0.200
    42.415     2.798     0.200
    42.415     2.237     0.200
    42.576     2.796     0.200
    42.595     0.151     0.200
    42.616     2.588     0.200
    43.005     0.981     0.200
    43.084     2.108     0.200
    43.560     2.669     0.200
    43.560     2.079     0.200
    43.629     3.057     0.200
    43.651     2.291     0.200
    43.662     0.398     0.200
    43.743     1.106     0.200
    43.799     2.421     0.200
    43.819     1.847     0.200
    43.933     2.333     0.200
    44.136     2.041     0.200
    44.144     1.758     0.200
    44.144     1.697     0.200
    44.144     1.408     0.200
    44.212     1.349     0.200
    44.372     2.342     0.200
    44.401     1.880     0.200
    44.401     1.101     0.200
    44.427     2.100     0.200
    44.769     0.367     0.200
    44.901     2.342     0.200
    45.077     2.748     0.200
    45.186     1.664     0.200
    45.186     1.074     0.200
    45.361     2.618     0.200
    45.455     2.521     0.200
    45.456     1.442     0.200
    45.457     2.733     0.200
    45.513     2.636     0.200
    45.560     2.048     0.200
    45.570     2.092     0.200
    45.588     2.797     0.200
    45.632     2.891     0.200
    45.641     0.121     0.200
    45.652     2.904     0.200
    45.674     0.391     0.200
    45.676     1.794     0.200
    45.769     2.079     0.200
    46.110    -0.205     0.200
    46.110     0.045     0.200
    46.629     1.508     0.200
    46.827     1.386     0.200
    46.887     2.498     0.200
    46.957     1.700     0.200
    47.120     2.012     0.200
    47.739     1.611     0.200
    47.867     1.497     0.200
    48.531     1.971     0.200
    48.599     1.094     0.200
    48.711     1.115     0.200
    49.644     2.004     0.200
    53.822     0.725     0.200
    53.948     2.231     0.200
    54.271     0.499     0.200
    54.755     0.584     0.200
    57.635     1.225     0.200
    72.348    -0.197     0.200
    73.395     0.154     0.200
    73.441    -0.086     0.200
    74.651    -0.362     0.200
    75.043     1.225     0.200
    75.462     0.560     0.200
    75.929     0.776     0.200
    76.155     0.985     0.200
    76.990    -0.855     0.200
    76.990    -0.636     0.200
    78.073    -0.366     0.200
    79.177     0.165     0.200
    80.932     1.335     0.200
    80.941     0.864     0.200
    83.091     1.281     0.200
    83.505     0.201     0.200
    83.505    -0.099     0.200
    95.353     3.465     0.200
    79.583     0.774     0.200
    75.169     1.221     0.200
    74.369    -0.142     0.200
    46.044     0.096     0.200
    37.160     0.198     0.200
    17.915     0.510     0.200
    17.915     0.620     0.200
    19.329     1.337     0.200
    21.348     4.807     0.200
    21.348     3.510     0.200
    21.348     4.541     0.200
    21.348     4.362     0.200
    21.614    -0.058     0.200
    21.614    -0.121     0.200
    21.816     4.485     0.200
    21.912     0.657     0.200
    22.029     3.448     0.200
    22.397     3.574     0.200
    22.416     3.436     0.200
    23.033     3.783     0.200
    23.277     0.759     0.200
    23.277     0.494     0.200
    23.319     1.421     0.200
    23.505     3.852     0.200
    23.519     2.223     0.200
    23.519     2.520     0.200
    23.519     0.528     0.200
    23.519     1.286     0.200
    24.678     1.362     0.200
    24.678     1.745     0.200
    25.125     1.387     0.200
    25.125     1.551     0.200
    25.268     2.647     0.200
    25.540     3.894     0.200
    26.113     3.886     0.200
    26.236     4.463     0.200
    26.236     4.088     0.200
    26.236     4.987     0.200
    27.270     1.952     0.200
    27.380     2.262     0.200
    27.509     1.906     0.200
    27.684     3.337     0.200
    27.684     3.541     0.200
    27.684     3.642     0.200
    27.781     1.370     0.200
    27.870     2.968     0.200
    28.316     2.590     0.200
    28.538     1.340     0.200
    28.538     1.450     0.200
    28.619     1.833     0.200
    28.619     2.262     0.200
    28.811     2.585     0.200
    28.811     3.428     0.200
    28.797     3.312     0.200
    28.797     3.484     0.200
    28.797     4.218     0.200
    29.372     2.635     0.200
    29.576     1.094     0.200
    29.576     1.673     0.200
    29.576     1.430     0.200
    29.641     2.754     0.200
    29.671     3.352     0.200
    29.820     1.045     0.200
    29.820     0.771     0.200
    29.734     2.700     0.200
    29.775     3.349     0.200
    29.810     3.195     0.200
    29.959     2.403     0.200
    29.959     2.106     0.200
    30.362     3.164     0.200
    30.444     2.710     0.200
    30.503     2.634     0.200
    30.630     1.568     0.200
    30.637     1.874     0.200
    30.637     2.210     0.200
    31.120     3.609     0.200
    31.120     3.937     0.200
    31.201     0.937     0.200
    31.201     0.617     0.200
    31.201     0.437     0.200
    31.704     2.498     0.200
    31.946     3.700     0.200
    32.476     2.109     0.200
    32.476     1.633     0.200
    32.577     2.409     0.200
    32.807     1.915     0.200
    32.851     3.128     0.200
    33.300     3.009     0.200
    33.397     1.354     0.200
    33.429     3.778     0.200
    33.495     2.248     0.200
    33.579     3.662     0.200
    33.588     3.586     0.200
    33.599     3.717     0.200
    33.605     2.722     0.200
    33.605     3.457     0.200
    33.642     2.403     0.200
    33.724     3.817     0.200
    33.733     2.800     0.200
    33.748     2.112     0.200
    33.748     2.229     0.200
    33.759     3.050     0.200
    33.856     3.147     0.200
    33.956     0.915     0.200
    33.956     0.821     0.200
    33.956     2.048     0.200
    34.046     2.795     0.200
    34.051     2.638     0.200
    34.058     2.115     0.200
    34.068     2.261     0.200
    34.088     2.074     0.200
    34.101     3.163     0.200
    34.100     2.928     0.200
    34.199     1.657     0.200
    34.178     3.199     0.200
    34.204     2.978     0.200
    34.240     2.190     0.200
    34.250     2.582     0.200
    34.253     3.030     0.200
    34.310     2.765     0.200
    34.325     3.697     0.200
    34.327     4.101     0.200
    34.422     3.702     0.200
    34.457     3.868     0.200
    34.488     3.129     0.200
    34.522     2.835     0.200
    34.538     1.367     0.200
    34.566     3.172     0.200
    34.582     1.625     0.200
    34.614     3.541     0.200
    34.626     3.363     0.200
    34.704     3.875     0.200
    34.871     0.726     0.200
    34.794     2.863     0.200
    34.806     2.521     0.200
    34.954     2.427     0.200
    34.972     2.448     0.200
    34.995     4.609     0.200
    34.997     3.402     0.200
    34.997     3.246     0.200
    34.997     2.800     0.200
    34.997     2.918     0.200
    35.041     3.817     0.200
    35.050     3.736     0.200
    35.053     2.997     0.200
    35.061     3.875     0.200
    35.087     2.467     0.200
    35.087     1.772     0.200
    35.099     3.820     0.200
    35.113     2.721     0.200
    35.163     3.243     0.200
    35.184     2.388     0.200
    35.218     2.335     0.200
    35.253     2.860     0.200
    35.295     3.763     0.200
    35.295     3.982     0.200
    35.347     3.552     0.200
    35.415     3.677     0.200
    35.435     2.559     0.200
    35.455     3.791     0.200
    35.458     2.898     0.200
    35.474     2.092     0.200
    35.511     2.143     0.200
    35.508     2.648     0.200
    35.531     3.600     0.200
    35.531     4.108     0.200
    35.531     3.490     0.200
    35.590     2.652     0.200
    35.693     0.808     0.200
    35.749     3.430     0.200
    35.762     3.793     0.200
    35.909     0.556     0.200
    35.853     3.478     0.200
    35.878     3.266     0.200
    35.992     1.821     0.200
    35.935     3.258     0.200
    35.947     2.269     0.200
    36.033     3.838     0.200
    36.039     2.841     0.200
    36.153     2.177     0.200
    36.137     2.324     0.200
    36.147     3.531     0.200
    36.160     2.817     0.200
    36.160     2.583     0.200
    36.291     1.526     0.200
    36.320     2.597     0.200
    36.352     3.250     0.200
    36.452     3.351     0.200
    36.452     2.445     0.200
    36.655     0.334     0.200
    36.655     0.600     0.200
    36.657     2.953     0.200
    36.628     3.269     0.200
    36.641     3.632     0.200
    36.653     1.162     0.200
    36.677     3.325     0.200
    36.752     0.459     0.200
    36.822     3.513     0.200
    36.991     3.033     0.200
    37.054     3.682     0.200
    37.054     3.291     0.200
    37.059     3.873     0.200
    37.061     2.420     0.200
    37.061     2.912     0.200
    37.061     2.303     0.200
    37.106     3.680     0.200
    37.197     3.265     0.200
    37.197     2.945     0.200
    37.231     3.839     0.200
    37.450     3.171     0.200
    37.465     2.650     0.200
    37.489     0.389     0.200
    37.489     0.522     0.200
    37.471     2.909     0.200
    37.473     2.303     0.200
    37.526     2.765     0.200
    37.548     3.289     0.200
    37.548     2.766     0.200
    37.570     2.389     0.200
    37.653     3.834     0.200
    37.672     2.842     0.200
    37.672     3.670     0.200
    37.742     2.112     0.200
    37.760     2.193     0.200
    37.760     2.724     0.200
    37.808     2.491     0.200
    37.808     3.225     0.200
    37.808     2.382     0.200
    37.916     0.860     0.200
    37.894     2.268     0.200
    37.949     2.394     0.200
    37.949     2.105     0.200
    37.966     2.751     0.200
    37.966     2.446     0.200
    38.027     2.333     0.200
    38.028     1.572     0.200
    38.073     3.698     0.200
    38.101     1.098     0.200
    38.188     0.739     0.200
    38.214     3.603     0.200
    38.239     0.950     0.200
    38.239     0.653     0.200
    38.239     2.916     0.200
    38.373     3.823     0.200
    38.373     3.690     0.200
    38.373     3.018     0.200
    38.491     1.970     0.200
    38.447     3.781     0.200
    38.471     3.257     0.200
    38.530     2.366     0.200
    38.536     3.507     0.200
    38.556     2.467     0.200
    38.556     2.787     0.200
    38.556     2.631     0.200
    38.584     0.825     0.200
    38.596     2.762     0.200
    38.787     2.866     0.200
    38.773     3.653     0.200
    38.841     2.493     0.200
    38.841     2.157     0.200
    38.879     0.709     0.200
    38.917     4.356     0.200
    38.917     3.637     0.200
    39.020     0.702     0.200
    39.057     1.082     0.200
    39.057    -0.192     0.200
    39.057    -0.067     0.200
    39.052     5.272     0.200
    39.212     1.786     0.200
    39.178     4.169     0.200
    39.178     3.583     0.200
    39.208     0.735     0.200
    39.294     2.416     0.200
    39.289     0.852     0.200
    39.339     0.923     0.200
    39.363     2.255     0.200
    39.479     0.557     0.200
    39.483     3.825     0.200
    39.483     3.177     0.200
    39.483     3.497     0.200
    39.502     3.455     0.200
    39.507     0.074     0.200
    39.780     2.317     0.200
    39.780     2.060     0.200
    39.716     0.375     0.200
    39.736     2.721     0.200
    39.736     2.518     0.200
    39.864     1.566     0.200
    39.864     1.668     0.200
    39.862     2.289     0.200
    39.883     2.568     0.200
    40.329     3.400     0.200
    40.329     2.517     0.200
    40.470     0.216     0.200
    40.471     1.126     0.200
    40.490     2.015     0.200
    40.490     2.171     0.200
    40.626     2.339     0.200
    40.626     1.768     0.200
    40.626     2.175     0.200
    40.694     0.039     0.200
    40.805     2.659     0.200
    40.919     2.215     0.200
    40.919     2.035     0.200
    41.010     1.774     0.200
    41.128     1.029     0.200
    41.116     2.402     0.200
    41.116     2.527     0.200
    41.113     2.716     0.200
    41.113     2.060     0.200
    41.225    -0.532     0.200
    41.218     3.457     0.200
    41.218     3.121     0.200
    41.305     2.039     0.200
    41.305     2.344     0.200
    41.305     1.805     0.200
    41.305     1.914     0.200
    41.355     0.834     0.200
    41.344     2.718     0.200
    41.344     1.992     0.200
    41.415     1.785     0.200
    41.415     2.146     0.200
    41.477     2.168     0.200
    41.476     2.942     0.200
    41.476     2.630     0.200
    41.544     2.216     0.200
    41.606     1.665     0.200
    41.625     2.145     0.200
    41.651     1.234     0.200
    41.673     2.042     0.200
    41.751     2.684     0.200
    41.751     2.809     0.200
    41.751     2.348     0.200
    41.800     1.881     0.200
    41.904     3.527     0.200
    41.904     2.691     0.200
    41.923     2.372     0.200
    41.923     2.739     0.200
    41.923     1.880     0.200
    41.952     2.264     0.200
    41.990     2.428     0.200
    41.990     2.053     0.200
    42.056     2.486     0.200
    42.056     2.165     0.200
    42.097     2.452     0.200
    42.097     2.257     0.200
    42.167     2.688     0.200
    42.165     2.304     0.200
    42.262     2.400     0.200
    42.270     2.044     0.200
    42.268     2.261     0.200
    42.296     1.827     0.200
    42.296     2.069     0.200
    42.398     0.462     0.200
    42.447     2.403     0.200
    42.498     4.886     0.200
    42.505     2.332     0.200
    42.647     2.376     0.200
    42.647     2.275     0.200
    42.647     1.830     0.200
    42.647     0.901     0.200
    42.647     2.315     0.200
    42.731     0.822     0.200
    42.713     2.439     0.200
    42.713     2.220     0.200
    42.769     0.435     0.200
    42.778     2.144     0.200
    42.778     1.886     0.200
    42.868     2.784     0.200
    43.217     1.850     0.200
    43.217     2.475     0.200
    43.245     2.533     0.200
    43.245     2.432     0.200
    43.245     2.104     0.200
    43.413     2.768     0.200
    43.385     2.601     0.200
    43.435     2.896     0.200
    43.435     2.638     0.200
    43.439     0.663     0.200
    43.435     2.480     0.200
    43.474     0.834     0.200
    43.489     2.158     0.200
    43.524     1.766     0.200
    43.610     1.697     0.200
    43.709     1.401     0.200
    43.831     1.827     0.200
    43.839     1.794     0.200
    43.905     2.015     0.200
    43.905     1.617     0.200
    43.941     1.520     0.200
    43.941     2.692     0.200
    43.985     0.318     0.200
    44.039     2.072     0.200
    44.109     1.394     0.200
    44.118     1.947     0.200
    44.118     1.939     0.200
    44.144     2.244     0.200
    44.196     1.396     0.200
    44.208     1.423     0.200
    44.381     0.511     0.200
    44.381     0.823     0.200
    44.642     2.376     0.200
    44.644     3.337     0.200
    44.649     2.659     0.200
    44.567     2.070     0.200
    44.672     3.278     0.200
    44.672     2.965     0.200
    44.703     2.568     0.200
    44.703     2.779     0.200
    44.710     1.721     0.200
    44.793     2.687     0.200
    44.793     2.257     0.200
    44.952     2.132     0.200
    44.952     1.320     0.200
    44.904     1.234     0.200
    45.064     3.086     0.200
    44.970     1.638     0.200
    45.051     2.400     0.200
    45.159     2.799     0.200
    45.159     3.018     0.200
    45.095     1.860     0.200
    45.235     3.486     0.200
    45.145     2.755     0.200
    45.145     2.020     0.200
    45.147     2.361     0.200
    45.151     2.211     0.200
    45.300     2.393     0.200
    45.230     2.209     0.200
    45.252     2.046     0.200
    45.263     1.979     0.200
    45.268     0.900     0.200
    45.263     1.674     0.200
    45.271     1.402     0.200
    45.276     2.990     0.200
    45.319     2.767     0.200
    45.338     2.742     0.200
    45.449     0.683     0.200
    45.370     1.863     0.200
    45.492     0.926     0.200
    45.492     0.754     0.200
    45.492     1.551     0.200
    45.407     2.866     0.200
    45.407     2.717     0.200
    45.407     2.866     0.200
    45.398     2.089     0.200
    45.440     2.559     0.200
    45.524    -0.005     0.200
    45.524    -0.458     0.200
    45.524    -0.146     0.200
    45.499     2.234     0.200
    45.515    -0.252     0.200
    45.622     2.137     0.200
    45.621     1.531     0.200
    45.793     1.787     0.200
    45.817     1.868     0.200
    45.846     2.149     0.200
    45.914     1.774     0.200
    46.105     1.338     0.200
    46.105     0.987     0.200
    46.087     1.850     0.200
    46.086     2.255     0.200
    46.109     1.628     0.200
    46.166     2.210     0.200
    46.351     1.467     0.200
    46.299     2.157     0.200
    46.332     1.796     0.200
    46.373     0.902     0.200
    46.373     0.370     0.200
    46.361     1.609     0.200
    46.399     2.114     0.200
    46.438     2.351     0.200
    46.454     1.587     0.200
    46.484     2.335     0.200
    46.490     2.469     0.200
    46.534     1.383     0.200
    46.534     0.914     0.200
    46.550     1.695     0.200
    46.549     2.912     0.200
    46.651     2.611     0.200
    46.642     2.172     0.200
    46.653     2.246     0.200
    46.666     1.602     0.200
    46.746     2.428     0.200
    46.781     2.511     0.200
    46.795     1.700     0.200
    46.813     2.375     0.200
    46.813     2.132     0.200
    46.826     1.659     0.200
    46.921     2.205     0.200
    46.913     0.705     0.200
    46.948     2.232     0.200
    46.965     2.181     0.200
    47.008     1.352     0.200
    47.084     1.979     0.200
    47.118     2.181     0.200
    47.146     3.034     0.200
    47.173     1.426     0.200
    47.220     1.937     0.200
    47.346     2.187     0.200
    47.302     0.740     0.200
    47.329     2.195     0.200
    47.403     1.446     0.200
    47.404     2.095     0.200
    47.404     1.556     0.200
    47.487     0.202     0.200
    47.487     0.031     0.200
    47.423     2.864     0.200
    47.437     2.084     0.200
    47.437     0.763     0.200
    47.437     2.318     0.200
    47.479     2.386     0.200
    47.613     1.930     0.200
    47.613     1.813     0.200
    47.510     2.149     0.200
    47.512     3.685     0.200
    47.512     3.529     0.200
    47.565     3.679     0.200
    47.577     1.208     0.200
    47.691     1.732     0.200
    47.715     1.955     0.200
    47.760     3.674     0.200
    47.760     1.604     0.200
    47.775     1.816     0.200
    47.797     2.521     0.200
    47.830     2.818     0.200
    47.845     1.839     0.200
    47.908     2.351     0.200
    47.915     1.266     0.200
    47.955     1.477     0.200
    47.987     2.977     0.200
    47.987     1.977     0.200
    48.000     2.006     0.200
    48.002     3.264     0.200
    48.002     2.936     0.200
    48.019     1.633     0.200
    48.227     2.129     0.200
    48.227     1.394     0.200
    48.227     1.832     0.200
    48.284     3.023     0.200
    48.303     1.568     0.200
    48.303     1.786     0.200
    48.655     2.731     0.200
    48.655     1.715     0.200
    48.666     2.347     0.200
    48.686     1.668     0.200
    48.684     2.970     0.200
    48.684     2.298     0.200
    48.690     1.694     0.200
    48.817     1.348     0.200
    48.850     1.936     0.200
    49.006     1.635     0.200
    49.098     1.672     0.200
    49.210     2.139     0.200
    49.308     0.996     0.200
    49.442     1.254     0.200
    49.442     2.871     0.200
    49.446     1.976     0.200
    49.478     1.659     0.200
    49.549     2.201     0.200
    49.671     1.972     0.200
    49.674     1.539     0.200
    50.117     2.143     0.200
    50.117     1.956     0.200
    50.308     0.900     0.200
    50.308     1.236     0.200
    50.308     0.674     0.200
    50.370     2.466     0.200
    50.525     1.943     0.200
    50.525     1.787     0.200
    50.633     2.998     0.200
    50.633     2.865     0.200
    51.386     2.684     0.200
    51.386     2.872     0.200
    51.345     2.928     0.200
    51.631     1.434     0.200
    51.682     1.405     0.200
    51.846     2.491     0.200
    52.073     1.760     0.200
    52.270     3.619     0.200
    52.177     1.602     0.200
    52.366     1.323     0.200
    52.367     2.508     0.200
    52.607     1.962     0.200
    52.839     1.038     0.200
    52.864     0.706     0.200
    53.284     1.696     0.200
    53.284     1.578     0.200
    53.339     1.143     0.200
    53.339     2.416     0.200
    53.309     1.660     0.200
    53.451     1.600     0.200
    53.451     1.295     0.200
    53.373     2.013     0.200
    53.406     1.767     0.200
    53.459     0.460     0.200
    53.459     1.585     0.200
    53.487     0.578     0.200
    53.487     0.687     0.200
    53.781     0.450     0.200
    53.781     0.614     0.200
    54.008     1.612     0.200
    54.008     1.323     0.200
    54.008     1.049     0.200
    54.548     1.491     0.200
    54.548     1.218     0.200
    54.459     1.147     0.200
    54.492     2.975     0.200
    54.651     1.073     0.200
    54.561     2.256     0.200
    54.728     1.377     0.200
    55.027     1.293     0.200
    55.394     2.936     0.200
    55.526     0.937     0.200
    55.730     2.143     0.200
    55.879     0.612     0.200
    55.915    -0.615     0.200
    56.040     2.804     0.200
    56.040     1.335     0.200
    56.040     3.038     0.200
    55.999     1.013     0.200
    55.954     1.482     0.200
    56.242     2.703     0.200
    56.176     2.096     0.200
    56.392     0.545     0.200
    56.590     1.512     0.200
    56.801     2.117     0.200
    57.268     3.296     0.200
    57.268     3.515     0.200
    57.389     2.949     0.200
    57.389     2.816     0.200
    57.427     1.478     0.200
    57.554     1.634     0.200
    57.554     1.212     0.200
    57.942     1.844     0.200
    57.942     3.204     0.200
    58.352     1.960     0.200
    58.476     1.798     0.200
    59.142     1.041     0.200
    59.370    -0.895     0.200
    59.370    -0.786     0.200
    59.320     2.743     0.200
    59.562     1.028     0.200
    60.062     3.372     0.200
    60.196     0.475     0.200
    60.196    -0.181     0.200
    60.286     0.895     0.200
    60.448     2.690     0.200
    60.506     2.439     0.200
    60.686     1.261     0.200
    60.686     1.972     0.200
    60.599    -0.271     0.200
    60.892     0.598     0.200
    60.789     0.435     0.200
    61.064     1.740     0.200
    61.131     2.332     0.200
    61.499     1.746     0.200
    61.731     1.704     0.200
    61.944    -0.026     0.200
    61.944    -1.222     0.200
    61.944    -0.354     0.200
    62.453    -1.378     0.200
    62.034    -2.380     0.200
    62.034    -1.536     0.200
    62.068     2.357     0.200
    62.530     1.780     0.200
    62.530     1.983     0.200
    62.451     2.246     0.200
    62.491     2.145     0.200
    62.650     2.487     0.200
    62.692     1.879     0.200
    63.203     1.627     0.200
    63.515     2.850     0.200
    63.515     3.225     0.200
    64.102     1.881     0.200
    64.102     1.623     0.200
    64.109     1.992     0.200
    64.265     2.256     0.200
    64.971    -1.064     0.200
    67.109     0.603     0.200
    67.181     0.942     0.200
    67.181     0.591     0.200
    67.625     1.710     0.200
    68.630     1.002     0.200
    68.630     1.189     0.200
    69.356     1.782     0.200
    69.356     1.047     0.200
    69.356     1.547     0.200
    70.395     1.339     0.200
    70.719     3.159     0.200
    71.955     1.373     0.200
    71.955     1.975     0.200
    72.367     1.444     0.200
    72.367     1.975     0.200
    72.446     2.168     0.200
    72.690    -0.050     0.200
    72.854     0.306     0.200
    73.243     1.808     0.200
    73.243     2.793     0.200
    73.736     2.370     0.200
    73.683     2.238     0.200
    73.683     2.035     0.200
    73.978     0.955     0.200
    73.978     1.259     0.200
    74.198     1.124     0.200
    68.645     0.385     0.200
    74.420     1.319     0.200
    74.420     1.116     0.200
    74.438     1.677     0.200
    74.438     1.318     0.200
    74.438     1.474     0.200
    74.671     2.002     0.200
    75.053     1.651     0.200
    75.071     0.760     0.200
    75.071     1.284     0.200
    75.165     1.116     0.200
    75.338     0.723     0.200
    75.691     0.099     0.200
    75.691     0.364     0.200
    75.982     1.308     0.200
    76.234     0.044     0.200
    76.234    -0.378     0.200
    76.234    -0.152     0.200
    76.275     2.314     0.200
    76.275     2.057     0.200
    76.486    -0.283     0.200
    76.439     3.313     0.200
    76.711    -0.259     0.200
    76.775     0.827     0.200
    78.066    -0.785     0.200
    78.696    -0.197     0.200
    78.756     1.552     0.200
    78.943    -0.331     0.200
    79.434     3.016     0.200
    79.685     0.845     0.200
    79.665     2.719     0.200
    80.152     1.598     0.200
    80.152     2.480     0.200
    80.171     0.566     0.200
    80.171     0.465     0.200
    80.629     0.786     0.200
    80.914    -0.155     0.200
    80.914    -0.475     0.200
    80.914    -0.366     0.200
    81.209     1.476     0.200
    81.209     0.382     0.200
    81.209     1.632     0.200
    81.303     0.431     0.200
    81.303     0.572     0.200
    81.381     0.074     0.200
    81.381     0.582     0.200
    81.435     0.036     0.200
    81.435     0.544     0.200
    81.505    -0.131     0.200
    81.486     3.407     0.200
    81.598     2.284     0.200
    81.598     2.971     0.200
    82.662    -0.496     0.200
    82.662    -0.379     0.200
    82.964    -0.430     0.200
    83.667    -0.060     0.200
    83.907     1.395     0.200
    83.907     1.278     0.200
    84.289     1.293     0.200
    84.289     1.402     0.200
    84.289     0.863     0.200
    84.567     0.056     0.200
    84.567     0.540     0.200
    84.616     0.992     0.200
    84.617     0.726     0.200
    85.293     1.361     0.200
    85.293     1.979     0.200
    85.351     1.316     0.200
    85.351     0.589     0.200
    87.321     1.332     0.200
    87.321     1.504     0.200
    87.327     0.293     0.200
    87.327     0.144     0.200
    87.636     1.742     0.200
    87.636     2.000     0.200
    87.932     0.120     0.200
    90.702     1.802     0.200
    90.702     1.505     0.200
    90.731     0.031     0.200
    90.888     0.840     0.200
    90.888     1.472     0.200
    91.711     1.171     0.200
    92.416     0.922     0.200
    92.909     1.566     0.200
    93.112     0.352     0.200
    93.506     2.042     0.200
    93.871     1.143     0.200
    93.871     0.573     0.200
    93.923     3.868     0.200
    94.067    -0.716     0.200
    94.311     1.015     0.200
    94.584    -0.132     0.200
    95.077     1.216     0.200
    95.441     0.910     0.200
    95.599     1.908     0.200
    95.599     1.627     0.200
    95.776     1.359     0.200
    95.822     0.643     0.200
    96.423     1.105     0.200
    96.423     1.301     0.200
    97.090     0.857     0.200
    97.212     2.187     0.200
    20.293     1.636     0.200
    20.684     1.822     0.200
    20.941     1.902     0.200
    20.950     1.499     0.200
    21.107     1.968     0.200
    21.348     2.471     0.200
    21.614     0.418     0.200
    21.614     0.301     0.200
    21.700     1.191     0.200
    23.277     1.353     0.200
    24.678     0.456     0.200
    28.619     1.403     0.200
    28.811     0.983     0.200
    29.521     2.267     0.200
    29.641     0.269     0.200
    29.795     1.079     0.200
    29.795     0.782     0.200
    29.858     1.261     0.200
    29.858     1.503     0.200
    30.731     1.585     0.200
    31.201     0.195     0.200
    31.699     3.613     0.200
    32.301     1.424     0.200
    32.577     1.823     0.200
    32.807     1.649     0.200
    33.073     2.259     0.200
    33.956     0.306     0.200
    34.378     1.175     0.200
    34.538     0.969     0.200
    34.582     1.031     0.200
    34.740     2.254     0.200
    34.871     0.054     0.200
    36.153     1.623     0.200
    38.491     1.829     0.200
    39.864     1.332     0.200
    40.490     0.562     0.200
    41.225    -0.860     0.200
    42.298     0.992     0.200
    42.398     0.087     0.200
    42.731     0.221     0.200
    43.176     1.136     0.200
    44.644     0.548     0.200
    44.642     0.719     0.200
    45.407     2.163     0.200
    45.524    -0.716     0.200
    46.373    -0.075     0.200
    47.437     0.873     0.200
    47.512     1.505     0.200
    48.002     1.342     0.200
    49.442     1.074     0.200
    49.478     1.550     0.200
    50.117     1.159     0.200
    50.308     0.572     0.200
    53.284     1.164     0.200
    53.372     0.896     0.200
    53.487     0.117     0.200
    54.008     0.870     0.200
    55.879     0.479     0.200
    57.386    -0.698     0.200
    57.389    -0.004     0.200
    57.554     1.415     0.200
    57.942     0.985     0.200
    58.149     0.989     0.200
    58.476     1.509     0.200
    60.062     2.403     0.200
    60.155     1.038     0.200
    60.448     1.948     0.200
    60.686     0.409     0.200
    60.789     0.653     0.200
    62.034    -0.865     0.200
    62.530     0.804     0.200
    62.692     1.637     0.200
    63.203     0.963     0.200
    63.883     0.943     0.200
    64.102     0.412     0.200
    64.109     1.828     0.200
    64.971    -1.400     0.200
    66.578     0.482     0.200
    69.356     0.594     0.200
    72.446     0.411     0.200
    74.438     0.521     0.200
    75.691    -0.276     0.200
    76.952    -0.275     0.200
    80.171     0.121     0.200
    80.914    -0.655     0.200
    81.209     0.093     0.200
    81.598     2.182     0.200
    83.697     0.567     0.200
    89.957     0.367     0.200
    95.776     0.624     0.200
    97.090     0.388     0.200
    98.972     0.048     0.200
    16.940     4.571     0.200
    21.354     4.295     0.200
    30.453     2.968     0.200
    33.950     1.098     0.200
    35.053     3.416     0.200
    35.531     3.772     0.200
    37.552     2.923     0.200
    38.862     0.962     0.200
    39.495     0.541     0.200
    39.886     2.722     0.200
    41.411     2.368     0.200
    41.473     2.282     0.200
    41.541     2.521     0.200
    41.621     2.524     0.200
    41.669     2.528     0.200
    42.092     2.061     0.200
    42.708     1.296     0.200
    43.441     2.918     0.200
    44.118     1.474     0.200
    44.367     0.508     0.200
    44.903     1.494     0.200
    45.261     1.041     0.200
    45.501    -0.129     0.200
    46.532     1.407     0.200
    49.097     1.665     0.200
    57.571     1.118     0.200
    58.478     1.764     0.200
    59.145     1.413     0.200
    61.501     1.864     0.200
    64.139     1.712     0.200
    73.280     1.375     0.200
    74.420     1.412     0.200
    75.655     0.517     0.200
    82.626    -0.015     0.200
    87.330     0.348     0.200
    21.046     2.733     0.200
    21.354     1.826     0.200
    21.576     1.226     0.200
    23.252     0.984     0.200
    23.519     1.720     0.200
    24.709    -0.684     0.200
    36.148     0.902     0.200
    36.743    -0.215     0.200
    38.862     0.017     0.200
    42.375     0.135     0.200
    42.708     0.397     0.200
    43.441    -0.231     0.200
    44.118     0.599     0.200
    44.903     0.908     0.200
    45.646     0.362     0.200
    47.301     0.363     0.200
    72.956    -0.168     0.200
    74.985    -0.025     0.200
    75.235     0.269     0.200
    75.374    -0.033     0.200
    75.394    -0.228     0.200
    75.655     0.103     0.200
    76.389     0.023     0.200
    78.924     0.056     0.200
    80.876    -0.673     0.200
    17.957     2.362     0.200
    18.201     1.811     0.200
    19.376     0.806     0.200
    21.314     4.950     0.200
    21.314     5.161     0.200
    21.655    -0.158     0.200
    21.655    -0.119     0.200
    21.951     0.408     0.200
    21.990     4.629     0.200
    22.368     3.257     0.200
    22.382     4.216     0.200
    23.002     4.263     0.200
    23.286     0.634     0.200
    23.286     0.486     0.200
    23.292     0.978     0.200
    23.491     1.377     0.200
    23.491     1.681     0.200
    23.491     1.486     0.200
    24.626     0.867     0.200
    25.316     1.924     0.200
    26.077     4.518     0.200
    26.200     4.965     0.200
    26.200     4.660     0.200
    27.319     2.528     0.200
    27.353     1.824     0.200
    27.559     2.374     0.200
    27.784     0.653     0.200
    27.831     3.723     0.200
    28.367     2.253     0.200
    28.570     1.884     0.200
    28.570     1.501     0.200
    28.655     2.491     0.200
    29.643     1.816     0.200
    29.608     1.323     0.200
    29.608     1.432     0.200
    29.706     2.157     0.200
    29.742     3.453     0.200
    29.823     2.725     0.200
    29.827     1.389     0.200
    29.855     1.296     0.200
    29.855     1.132     0.200
    30.012     1.954     0.200
    30.012     2.211     0.200
    30.408     3.695     0.200
    31.191     0.834     0.200
    31.191     1.193     0.200
    31.191     1.014     0.200
    32.508     2.673     0.200
    32.855     1.784     0.200
    32.962    -0.315     0.200
    33.936     0.989     0.200
    33.936     0.974     0.200
    34.970     3.576     0.200
    35.026     3.413     0.200
    35.061     2.461     0.200
    35.679     0.433     0.200
    35.941     0.783     0.200
    35.914     2.727     0.200
    36.448     2.031     0.200
    36.748     0.490     0.200
    36.689     2.583     0.200
    37.480     0.361     0.200
    38.223     0.488     0.200
    38.543     2.368     0.200
    39.063     0.629     0.200
    39.262     1.967     0.200
    39.843     1.567     0.200
    40.898     2.093     0.200
    41.093     2.581     0.200
    41.195     3.094     0.200
    41.283     2.284     0.200
    41.778     2.253     0.200
    41.901     2.252     0.200
    42.034     2.203     0.200
    42.076     2.524     0.200
    42.146     2.046     0.200
    42.249     2.410     0.200
    42.275     2.193     0.200
    42.404     0.452     0.200
    42.625     2.246     0.200
    42.615     1.376     0.200
    42.755     2.149     0.200
    43.197     1.815     0.200
    43.224     2.199     0.200
    43.416     0.738     0.200
    43.464     1.757     0.200
    43.467     2.328     0.200
    43.882     1.585     0.200
    43.882     1.788     0.200
    43.920     2.083     0.200
    44.719     5.006     0.200
    44.763     2.495     0.200
    44.750     3.215     0.200
    44.784     1.202     0.200
    44.972     3.660     0.200
    45.205     3.612     0.200
    45.282     4.099     0.200
    45.325     1.381     0.200
    45.358     0.893     0.200
    45.385     2.713     0.200
    45.571    -0.684     0.200
    45.571    -0.247     0.200
    45.619     1.064     0.200
    45.968     1.067     0.200
    46.363     0.361     0.200
    46.403     0.943     0.200
    46.510     1.357     0.200
    46.704     2.081     0.200
    47.414     1.388     0.200
    47.527     0.103     0.200
    47.527    -0.343     0.200
    47.460     3.225     0.200
    48.204     1.579     0.200
    50.145     3.638     0.200
    50.322     0.837     0.200
    50.322     0.509     0.200
    50.499     1.907     0.200
    53.473     0.539     0.200
    53.833     0.718     0.200
    53.833     0.968     0.200
    54.061     0.500     0.200
    54.061     1.500     0.200
    54.601     0.830     0.200
    56.045     0.356     0.200
    56.402     0.587     0.200
    57.510     1.800     0.200
    57.899     4.854     0.200
    58.446     1.750     0.200
    60.328     0.475     0.200
    60.809     0.727     0.200
    60.849     1.083     0.200
    61.035     1.931     0.200
    61.701     1.884     0.200
    62.423    -1.803     0.200
    62.039     2.054     0.200
    64.051     2.478     0.200
    71.907     1.933     0.200
    72.725    -0.032     0.200
    72.961     1.582     0.200
    73.193     2.242     0.200
    73.631     2.255     0.200
    73.689     3.360     0.200
    75.373     0.823     0.200
    75.722    -0.030     0.200
    75.996     1.310     0.200
    76.271    -0.589     0.200
    76.804     0.744     0.200
    78.730    -0.518     0.200
    79.699     0.864     0.200
    80.649     1.415     0.200
    80.954    -0.449     0.200
    81.236     0.681     0.200
    82.696    -0.638     0.200
    83.074    -0.349     0.200
    83.671     0.390     0.200
    84.585     1.205     0.200
    87.350     0.399     0.200
    87.952     0.480     0.200
    94.602    -0.184     0.200
    83.405     0.420     0.200
    76.226     1.448     0.200
    29.823     2.772     0.200
    29.635     2.933     0.200
    30.012     2.055     0.200
    30.012     1.454     0.200
    33.468     1.996     0.200
    33.731     2.419     0.200
    33.936     1.317     0.200
    34.025     2.752     0.200
    34.065     1.377     0.200
    34.074     3.161     0.200
    34.149     3.122     0.200
    34.190     2.863     0.200
    34.595     3.185     0.200
    34.677     3.542     0.200
    34.736     3.794     0.200
    34.769     2.393     0.200
    34.775     3.328     0.200
    34.970     3.435     0.200
    34.970     2.740     0.200
    34.968     3.412     0.200
    35.014     3.388     0.200
    35.024     3.253     0.200
    35.111     2.136     0.200
    35.083     3.172     0.200
    35.193     2.401     0.200
    35.227     3.621     0.200
    35.316     3.104     0.200
    35.389     3.319     0.200
    35.431     3.276     0.200
    35.504     3.737     0.200
    35.504     4.097     0.200
    35.504     3.237     0.200
    35.560     2.811     0.200
    35.722     3.115     0.200
    35.826     3.722     0.200
    35.908     2.998     0.200
    35.988     3.309     0.200
    36.008     3.004     0.200
    36.113     2.544     0.200
    36.132     3.016     0.200
    36.323     3.153     0.200
    36.424     2.870     0.200
    36.615     3.587     0.200
    36.649     3.527     0.200
    37.034     3.283     0.200
    37.034     2.858     0.200
    37.034     2.358     0.200
    37.171     3.290     0.200
    37.171     3.470     0.200
    37.171     2.688     0.200
    37.206     3.364     0.200
    37.423     2.418     0.200
    37.446     1.750     0.200
    37.500     3.094     0.200
    37.517     3.271     0.200
    37.628     3.368     0.200
    37.645     2.874     0.200
    37.645     3.312     0.200
    37.733     2.222     0.200
    37.783     2.708     0.200
    37.783     3.099     0.200
    37.864     2.817     0.200
    37.928     2.282     0.200
    37.942     2.453     0.200
    38.049     3.190     0.200
    38.187     3.104     0.200
    38.212     2.632     0.200
    38.348     5.235     0.200
    38.422     3.758     0.200
    38.443     2.927     0.200
    38.510     3.244     0.200
    38.502     2.853     0.200
    38.528     2.718     0.200
    38.528     2.858     0.200
    38.874     0.629     0.200
    38.817     2.495     0.200
    38.817     2.292     0.200
    39.152     3.785     0.200
    39.712     2.615     0.200
    39.712     2.912     0.200
    40.459     1.469     0.200
    40.600     2.247     0.200
    40.600     1.747     0.200
    40.780     2.758     0.200
    40.780     2.164     0.200
    40.983     1.885     0.200
    40.983     1.487     0.200
    41.195     3.438     0.200
    41.319     2.622     0.200
    41.319     2.224     0.200
    41.451     3.733     0.200
    41.451     2.140     0.200
    41.723     3.000     0.200
    41.723     2.469     0.200
    41.878     3.037     0.200
    41.901     2.353     0.200
    41.901     2.846     0.200
    41.966     2.121     0.200
    41.966     1.925     0.200
    42.141     2.293     0.200
    42.242     2.168     0.200
    42.478     2.338     0.200
    42.615     1.688     0.200
    42.688     2.633     0.200
    42.841     2.695     0.200
    43.410     2.891     0.200
    43.402     1.964     0.200
    44.372     0.467     0.200
    44.763     1.995     0.200
    45.196     2.530     0.200
    45.257     0.587     0.200
    45.507    -0.013     0.200
    45.824     3.714     0.200
    46.336     1.559     0.200
    46.625     2.629     0.200
    46.770     0.790     0.200
    46.923     0.637     0.200
    46.923     0.832     0.200
    46.791     1.615     0.200
    46.983     1.488     0.200
    47.276     0.082     0.200
    47.414     1.169     0.200
    47.755     0.525     0.200
    47.834     1.442     0.200
    47.815     1.069     0.200
    48.399     0.944     0.200
    48.663     1.874     0.200
    49.203     1.074     0.200
    49.203     2.098     0.200
    53.149     1.401     0.200
    53.445     0.366     0.200
    53.445     0.639     0.200
    53.445     1.718     0.200
    53.460    -1.563     0.200
    53.459     1.689     0.200
    53.474     1.580     0.200
    54.192     0.208     0.200
    54.598    -0.160     0.200
    54.616     1.376     0.200
    54.682     0.990     0.200
    54.941     1.271     0.200
    55.184     2.317     0.200
    55.410     0.081     0.200
    55.975     1.812     0.200
    55.970     2.298     0.200
    56.193     1.567     0.200
    56.359     1.244     0.200
    56.353     0.740     0.200
    56.564    -0.113     0.200
    57.200     2.063     0.200
    57.510     0.940     0.200
    58.120     0.981     0.200
    58.121     0.971     0.200
    58.138     2.579     0.200
    58.274     1.626     0.200
    58.335     0.257     0.200
    58.446     0.906     0.200
    59.111     1.154     0.200
    59.189     1.280     0.200
    59.503     1.759     0.200
    59.761     1.429     0.200
    59.925     2.290     0.200
    60.242     2.312     0.200
    60.545     2.452     0.200
    60.662     1.876     0.200
    61.478     2.294     0.200
    18.352     0.647     0.200
    20.251     0.382     0.200
    20.642     1.072     0.200
    20.906     0.558     0.200
    20.909    -0.216     0.200
    21.014     3.496     0.200
    21.314     3.669     0.200
    21.655     0.428     0.200
    21.655     0.631     0.200
    22.227     2.658     0.200
    23.322     2.842     0.200
    24.548     2.218     0.200
    24.626     0.203     0.200
    26.858     2.071     0.200
    27.179     1.676     0.200
    27.635     1.546     0.200
    29.855    -0.040     0.200
    30.012     0.336     0.200
    30.764     0.315     0.200
    31.191    -0.322     0.200
    32.604     0.524     0.200
    33.936     0.317     0.200
    34.404     1.105     0.200
    34.906     0.722     0.200
    40.459     0.797     0.200
    41.242     0.313     0.200
    44.032     0.952     0.200
    44.719     2.280     0.200
    44.972     1.316     0.200
    45.282     2.036     0.200
    46.363     0.072     0.200
    46.983     1.027     0.200
    47.197     0.829     0.200
    47.414     0.029     0.200
    47.951     1.688     0.200
    49.504     1.138     0.200
    50.145     1.177     0.200
    50.322     0.119     0.200
    53.473     0.039     0.200
    53.833     0.515     0.200
    55.927     0.247     0.200
    57.510     1.503     0.200
    58.446     0.789     0.200
    60.421     0.562     0.200
    60.809    -0.335     0.200
    62.700     0.066     0.200
    63.832     0.670     0.200
    64.051     0.915     0.200
    66.615     0.975     0.200
    69.362     0.195     0.200
    71.744     0.781     0.200
    73.631     1.075     0.200
    74.001     1.183     0.200
    74.390     0.900     0.200
    74.447     1.428     0.200
    75.722    -0.233     0.200
    76.271    -0.362     0.200
    76.989    -0.441     0.200
    80.954    -0.214     0.200
    81.236     1.213     0.200
    84.585     0.377     0.200
    94.342     0.002     0.200
    17.957     2.168     0.200
    18.199     1.772     0.200
    21.313     4.859     0.200
    21.653    -0.137     0.200
    23.284     0.438     0.200
    23.490     1.397     0.200
    24.627     0.862     0.200
    28.571     1.671     0.200
    28.656     2.515     0.200
    29.609     1.376     0.200
    29.856     1.303     0.200
    30.010     2.058     0.200
    31.189     0.826     0.200
    32.509     2.320     0.200
    32.855     2.096     0.200
    33.935     1.088     0.200
    36.205     2.636     0.200
    36.690     0.888     0.200
    38.872     0.317     0.200
    39.061     0.694     0.200
    39.842     1.525     0.200
    41.092     2.507     0.200
    41.243    -0.060     0.200
    41.777     3.179     0.200
    42.074     2.450     0.200
    42.144     2.472     0.200
    42.247     2.437     0.200
    42.274     2.221     0.200
    42.402     0.375     0.200
    42.614     1.228     0.200
    42.624     2.171     0.200
    43.195     2.038     0.200
    43.222     2.218     0.200
    43.415     0.663     0.200
    43.465     2.355     0.200
    43.881     1.612     0.200
    43.919     2.009     0.200
    44.370     0.208     0.200
    44.696     2.776     0.200
    44.719     2.896     0.200
    44.762     2.511     0.200
    45.111     4.019     0.200
    45.282     3.512     0.200
    45.384     2.998     0.200
    45.505    -0.350     0.200
    45.674     1.761     0.200
    47.413     1.172     0.200
    47.462     3.027     0.200
    47.525     0.423     0.200
    47.952     3.177     0.200
    48.203     2.598     0.200
    49.505     1.894     0.200
    50.146     1.824     0.200
    50.320     0.768     0.200
    50.498     1.909     0.200
    51.437     2.111     0.200
    53.833     0.762     0.200
    54.060     1.517     0.200
    54.600     0.766     0.200
    56.400     0.516     0.200
    57.510     1.631     0.200
    57.901    -0.792     0.200
    58.445     1.555     0.200
    60.326     0.504     0.200
    60.851     0.812     0.200
    60.806     0.406     0.200
    61.034     1.860     0.200
    61.700     1.923     0.200
    63.832     0.800     0.200
    64.053     2.156     0.200
    67.210     1.876     0.200
    71.909     1.970     0.200
    72.723     0.066     0.200
    72.873     0.574     0.200
    72.963     1.300     0.200
    73.195     1.968     0.200
    73.632     2.380     0.200
    74.003     1.167     0.200
    74.390     1.166     0.200
    74.448     1.514     0.200
    75.190     1.320     0.200
    75.371     0.866     0.200
    75.720     0.146     0.200
    75.998     0.676     0.200
    76.269    -0.460     0.200
    76.499     0.023     0.200
    76.805     0.972     0.200
    78.728     0.056     0.200
    79.701     0.440     0.200
    80.651     1.064     0.200
    80.749     0.560     0.200
    80.952    -0.298     0.200
    81.238     0.667     0.200
    81.321     0.601     0.200
    81.716     0.612     0.200
    82.694    -0.588     0.200
    83.072    -0.127     0.200
    83.669     0.479     0.200
    84.586     0.775     0.200
    84.612     1.145     0.200
    87.352     0.502     0.200
    87.954     0.231     0.200
    90.728     1.370     0.200
    90.755     0.244     0.200
    90.910     1.134     0.200
    95.850     0.551     0.200
    76.227     1.603     0.200
    29.822     2.764     0.200
    19.374     0.739     0.200
    21.313     4.671     0.200
    21.313     5.234     0.200
    21.653     0.418     0.200
    21.778     4.929     0.200
    21.949    -0.055     0.200
    21.989     4.355     0.200
    22.367     3.980     0.200
    23.001     4.329     0.200
    23.290     1.601     0.200
    23.284     0.570     0.200
    23.327     4.620     0.200
    23.469     4.156     0.200
    23.490     2.343     0.200
    23.490     0.999     0.200
    23.490     1.858     0.200
    25.314     2.455     0.200
    25.505     4.586     0.200
    26.076     4.573     0.200
    27.317     2.558     0.200
    27.557     2.403     0.200
    27.782     0.585     0.200
    27.831     4.027     0.200
    28.366     2.273     0.200
    28.571     2.007     0.200
    28.656     2.335     0.200
    29.609     0.931     0.200
    29.609     1.572     0.200
    29.642     2.243     0.200
    29.634     3.316     0.200
    29.828     1.294     0.200
    29.856     1.452     0.200
    29.705     1.582     0.200
    29.822     2.749     0.200
    30.010     2.175     0.200
    30.010     1.777     0.200
    30.407     3.640     0.200
    31.189     0.365     0.200
    31.189     1.123     0.200
    32.509     2.460     0.200
    32.605     2.661     0.200
    32.960    -0.485     0.200
    33.935     1.323     0.200
    34.229     2.362     0.200
    34.275     5.060     0.200
    34.969     4.063     0.200
    34.969     3.579     0.200
    34.969     3.360     0.200
    35.025     3.541     0.200
    35.434     2.677     0.200
    35.502     3.865     0.200
    35.502     3.662     0.200
    35.677     0.861     0.200
    35.939     0.512     0.200
    36.746     0.514     0.200
    36.794     3.490     0.200
    36.961     2.754     0.200
    37.032     2.782     0.200
    37.032     2.485     0.200
    37.033     3.357     0.200
    37.078     3.143     0.200
    37.170     3.410     0.200
    37.170     3.668     0.200
    37.170     3.215     0.200
    37.422     2.640     0.200
    37.479     0.494     0.200
    37.499     2.855     0.200
    37.516     3.226     0.200
    37.627     2.809     0.200
    37.644     2.994     0.200
    37.644     2.697     0.200
    37.781     2.727     0.200
    37.781     2.532     0.200
    37.863     2.764     0.200
    37.926     2.505     0.200
    37.926     2.208     0.200
    37.941     2.582     0.200
    37.941     2.285     0.200
    38.047     3.740     0.200
    38.185     3.270     0.200
    38.222     0.416     0.200
    38.347     3.762     0.200
    38.347     3.637     0.200
    38.442     3.008     0.200
    38.542     2.019     0.200
    38.501     3.027     0.200
    38.508     3.489     0.200
    38.527     2.846     0.200
    38.527     2.642     0.200
    38.565     2.676     0.200
    38.816     2.514     0.200
    38.816     2.218     0.200
    39.151     3.710     0.200
    39.261     1.791     0.200
    39.457     3.754     0.200
    39.457     3.582     0.200
    39.710     2.642     0.200
    39.710     2.931     0.200
    39.710     2.743     0.200
    40.598     2.477     0.200
    40.598     2.297     0.200
    40.598     2.078     0.200
    40.779     2.683     0.200
    40.779     2.386     0.200
    40.982     1.911     0.200
    40.982     1.505     0.200
    41.194     3.465     0.200
    41.194     3.027     0.200
    41.282     2.139     0.200
    41.282     2.530     0.200
    41.282     2.249     0.200
    41.318     2.649     0.200
    41.318     1.945     0.200
    41.450     4.565     0.200
    41.450     2.463     0.200
    41.722     2.830     0.200
    41.722     2.401     0.200
    41.877     2.962     0.200
    41.899     2.381     0.200
    41.899     2.654     0.200
    41.964     2.046     0.200
    41.964     2.147     0.200
    42.032     2.488     0.200
    42.032     2.145     0.200
    42.139     2.320     0.200
    42.139     2.007     0.200
    42.241     2.187     0.200
    42.272     2.155     0.200
    42.422     2.213     0.200
    42.477     2.465     0.200
    42.624     2.273     0.200
    42.678     2.162     0.200
    42.687     2.660     0.200
    42.754     2.184     0.200
    42.840     2.721     0.200
    43.062     2.445     0.200
    43.222     2.320     0.200
    43.347     2.561     0.200
    43.463     1.877     0.200
    43.408     2.917     0.200
    43.408     2.425     0.200
    43.498     1.916     0.200
    43.881     2.214     0.200
    43.932     1.683     0.200
    44.182     1.975     0.200
    44.603     1.642     0.200
    45.323     1.290     0.200
    45.356     0.803     0.200
    45.618     0.981     0.200
    45.966     1.008     0.200
    46.402     1.468     0.200
    46.361    -0.313     0.200
    46.508     1.415     0.200
    46.703     2.706     0.200
    47.413     1.766     0.200
    47.525    -0.108     0.200
    51.293     2.205     0.200
    54.060     1.126     0.200
    56.043     0.478     0.200
    62.422    -1.741     0.200
    62.038     1.835     0.200
    76.269    -0.694     0.200
    80.952    -0.407     0.200
    81.229     0.417     0.200
    83.057    -0.274     0.200
    94.600    -1.065     0.200
    20.250     0.106     0.200
    20.906     0.302     0.200
    21.013     0.578     0.200
    21.066     0.571     0.200
    21.313     1.265     0.200
    22.226     2.364     0.200
    23.321     3.315     0.200
    23.490    -0.259     0.200
    24.627     0.315     0.200
    27.178     1.385     0.200
    28.571    -0.508     0.200
    28.656    -0.383     0.200
    29.856     0.311     0.200
    30.010     0.199     0.200
    31.189     0.115     0.200
    32.605     0.177     0.200
    33.935     0.057     0.200
    34.275     0.865     0.200
    34.405     0.836     0.200
    34.907     0.652     0.200
    39.061    -0.166     0.200
    41.243     0.581     0.200
    42.402    -0.281     0.200
    45.384     1.529     0.200
    46.152     0.754     0.200
    46.361    -0.110     0.200
    47.197     0.524     0.200
    47.413     0.211     0.200
    47.525     0.181     0.200
    49.505     1.176     0.200
    50.146     0.207     0.200
    50.320    -0.154     0.200
    51.437     1.424     0.200
    53.336    -0.133     0.200
    53.471    -0.324     0.200
    53.833     0.473     0.200
    54.060     0.673     0.200
    57.510     0.771     0.200
    57.901     0.404     0.200
    58.445     0.446     0.200
    60.419     0.765     0.200
    60.806    -0.234     0.200
    62.698     0.517     0.200
    63.832    -0.270     0.200
    64.053     1.883     0.200
    64.073     0.921     0.200
    66.616     0.595     0.200
    70.336     0.594     0.200
    71.746    -0.048     0.200
    71.873    -0.283     0.200
    73.465    -0.448     0.200
    74.297    -0.689     0.200
    74.390     0.018     0.200
    74.675     0.338     0.200
    75.720    -0.159     0.200
    76.157    -0.135     0.200
    76.227     0.041     0.200
    76.269    -0.093     0.200
    76.499    -0.344     0.200
    76.462    -0.322     0.200
    76.987    -0.555     0.200
    80.952    -0.196     0.200
    81.238     0.034     0.200
    86.039    -0.113     0.200
    17.004     1.967     0.200
    19.367     1.012     0.200
    21.310     4.702     0.200
    21.310     5.412     0.200
    21.645     0.193     0.200
    21.941     0.326     0.200
    21.987     4.390     0.200
    22.378     4.637     0.200
    22.363     4.519     0.200
    22.997     4.602     0.200
    23.286     2.043     0.200
    23.276     1.045     0.200
    23.323     3.554     0.200
    23.486     2.943     0.200
    23.486     3.352     0.200
    25.502     4.308     0.200
    26.073     4.469     0.200
    26.196     5.452     0.200
    27.828     4.437     0.200
    27.774     1.150     0.200
    28.360     2.423     0.200
    29.613     0.894     0.200
    30.005     2.218     0.200
    30.005     1.618     0.200
    30.005     2.078     0.200
    30.005     1.418     0.200
    29.819     2.665     0.200
    30.405     3.655     0.200
    31.183     1.018     0.200
    32.953     0.071     0.200
    33.929     0.858     0.200
    33.929     1.218     0.200
    33.929     1.333     0.200
    34.964     2.574     0.200
    35.009     2.792     0.200
    35.018     3.238     0.200
    35.020     3.621     0.200
    35.055     2.322     0.200
    35.498     3.797     0.200
    35.498     3.525     0.200
    35.931     0.579     0.200
    35.902     2.669     0.200
    35.982     3.452     0.200
    36.107     2.509     0.200
    36.262     1.998     0.200
    36.419     2.865     0.200
    36.644     2.990     0.200
    36.957     2.316     0.200
    37.165     2.865     0.200
    37.418     2.425     0.200
    37.512     2.958     0.200
    37.512     3.514     0.200
    37.494     3.043     0.200
    37.472     0.045     0.200
    37.639     3.327     0.200
    37.777     3.063     0.200
    37.777     2.902     0.200
    37.859     2.730     0.200
    37.921     2.646     0.200
    37.921     2.255     0.200
    38.181     3.270     0.200
    38.438     3.090     0.200
    38.497     2.807     0.200
    38.523     2.764     0.200
    38.561     2.839     0.200
    38.865     0.460     0.200
    39.706     2.892     0.200
    40.594     1.763     0.200
    40.978     2.239     0.200
    40.978     1.939     0.200
    41.087     2.839     0.200
    41.277     2.517     0.200
    41.277     1.958     0.200
    41.772     2.015     0.200
    42.027     1.117     0.200
    42.069     1.984     0.200
    42.242     1.673     0.200
    42.269     2.057     0.200
    42.673     1.612     0.200
    42.749     2.075     0.200
    42.727     0.904     0.200
    43.057     1.489     0.200
    43.457     2.221     0.200
    43.460     2.392     0.200
    44.364     0.294     0.200
    45.319     0.329     0.200
    46.397     1.204     0.200
    50.312     0.794     0.200
    53.829     0.802     0.200
    54.055     0.655     0.200
    56.036     0.226     0.200
    76.261    -0.254     0.200
    81.233     0.289     0.200
    83.049    -0.434     0.200
    18.341     0.668     0.200
    20.249     1.638     0.200
    20.640    -0.139     0.200
    20.905     1.086     0.200
    20.907     0.728     0.200
    20.903     1.777     0.200
    21.009     1.627     0.200
    21.310     1.902     0.200
    21.645    -0.358     0.200
    21.645    -0.778     0.200
    22.222     1.470     0.200
    23.276     0.335     0.200
    23.317     1.618     0.200
    23.486     1.341     0.200
    24.544     2.138     0.200
    24.629     0.740     0.200
    25.450     1.378     0.200
    26.856     2.349     0.200
    26.874     1.575     0.200
    27.631     1.288     0.200
    28.575     0.750     0.200
    29.566     1.805     0.200
    29.831     2.120     0.200
    29.831     1.690     0.200
    29.819     1.945     0.200
    30.005     0.758     0.200
    32.610     2.027     0.200
    33.031     1.738     0.200
    33.929     0.768     0.200
    34.910     2.063     0.200
    41.249     0.723     0.200
    42.394     0.235     0.200
    43.398     2.813     0.200
    44.087     1.520     0.200
    44.872     1.162     0.200
    50.312     0.094     0.200
    53.829     0.372     0.200
    57.509     0.834     0.200
    58.441     1.586     0.200
    62.690     1.001     0.200
    64.058     0.739     0.200
    71.515     0.039     0.200
    80.944    -0.643     0.200
    81.242     0.313     0.200
    17.056     3.479     0.200
    17.056     2.559     0.200
    18.373     1.160     0.200
    19.253     3.922     0.200
    19.432     1.155     0.200
    21.259     5.605     0.200
    21.702     0.343     0.200
    21.930     4.348     0.200
    21.994     1.311     0.200
    22.319     4.043     0.200
    22.949     3.992     0.200
    23.244     3.240     0.200
    23.287     1.593     0.200
    25.375     2.854     0.200
    26.020     4.129     0.200
    28.432     2.540     0.200
    28.623     0.991     0.200
    29.879     1.093     0.200
    29.767     2.786     0.200
    30.079     0.920     0.200
    32.560     2.241     0.200
    33.899     1.577     0.200
    33.899     0.968     0.200
    34.980     3.137     0.200
    35.457     4.239     0.200
    36.377     2.966     0.200
    37.738     2.600     0.200
    37.887     2.167     0.200
    38.856     0.446     0.200
    39.059     0.747     0.200
    39.439     3.242     0.200
    39.472     0.497     0.200
    39.470     0.130     0.200
    39.803     3.175     0.200
    41.243     2.141     0.200
    41.739     2.064     0.200
    41.891     1.300     0.200
    42.036     2.327     0.200
    42.200     2.649     0.200
    42.236     2.488     0.200
    42.400     0.216     0.200
    42.732     0.396     0.200
    42.765     0.131     0.200
    43.299     2.573     0.200
    43.349     2.998     0.200
    43.426     2.374     0.200
    43.457     1.648     0.200
    43.982    -0.124     0.200
    44.048     2.460     0.200
    44.348     0.084     0.200
    44.348     0.573     0.200
    44.818     2.688     0.200
    44.833     1.680     0.200
    45.273     2.994     0.200
    45.349     3.422     0.200
    45.484     0.268     0.200
    46.466     1.367     0.200
    46.924     1.111     0.200
    47.231     0.484     0.200
    47.348     2.088     0.200
    48.236     0.609     0.200
    49.029     1.724     0.200
    50.329     2.022     0.200
    50.329     0.893     0.200
    51.630     0.596     0.200
    52.818     0.580     0.200
    53.414     1.257     0.200
    56.404    -0.235     0.200
    58.397     1.731     0.200
    59.061     2.020     0.200
    61.421     1.895     0.200
    63.987     0.547     0.200
    73.131     2.371     0.200
    73.564     2.456     0.200
    74.321     0.595     0.200
    75.754    -0.121     0.200
    76.310    -0.380     0.200
    76.310    -0.681     0.200
    81.000    -0.541     0.200
    81.275     0.826     0.200
    87.392     0.159     0.200
    17.056     2.200     0.200
    20.965     0.011     0.200
    21.702     0.513     0.200
    21.702     0.314     0.200
    23.287     0.384     0.200
    23.270     0.432     0.200
    24.492    -0.054     0.200
    29.640     0.787     0.200
    29.767     0.296     0.200
    29.879     1.213     0.200
    32.651     1.008     0.200
    33.899     1.298     0.200
    35.975     0.130     0.200
    36.082     1.158     0.200
    36.884     0.012     0.200
    38.856     0.806     0.200
    42.036     1.698     0.200
    42.732     0.757     0.200
    43.349     0.978     0.200
    43.774     0.298     0.200
    44.048     1.001     0.200
    44.833     2.001     0.200
    45.631     0.733     0.200
    45.746     1.417     0.200
    46.938     1.547     0.200
    47.231     1.304     0.200
    48.355     1.765     0.200
    49.209     0.151     0.200
    50.329    -0.487     0.200
    54.633     1.970     0.200
    71.253     0.218     0.200
    71.982    -0.596     0.200
    72.763     0.019     0.200
    73.016     0.758     0.200
    73.131     2.240     0.200
    73.564     2.287     0.200
    73.995     0.005     0.200
    74.002    -0.473     0.200
    74.044     1.350     0.200
    74.590    -0.342     0.200
    74.645    -1.130     0.200
    74.610     0.895     0.200
    74.785     0.609     0.200
    75.104     0.116     0.200
    75.352    -0.005     0.200
    75.486     0.059     0.200
    75.509     0.065     0.200
    75.736    -0.316     0.200
    75.754     0.030     0.200
    76.222    -0.528     0.200
    76.271    -0.557     0.200
    76.506    -0.061     0.200
    76.518    -1.168     0.200
    76.962    -0.496     0.200
    77.083    -0.479     0.200
    77.585    -0.470     0.200
    77.698    -0.273     0.200
    77.961    -0.466     0.200
    79.040    -0.193     0.200
    79.204     0.560     0.200
    79.418    -1.068     0.200
    80.538     0.450     0.200
    81.000    -0.282     0.200
    81.275     1.195     0.200
    81.283     1.059     0.200
    83.099    -0.388     0.200
    83.449     1.053     0.200
    89.285    -0.498     0.200
    90.736     0.555     0.200
    92.404     0.445     0.200
    93.581     0.067     0.200
    15.315    -3.393     0.200
    21.283     5.075     0.200
    21.283     5.364     0.200
    21.612    -0.411     0.200
    21.751     5.110     0.200
    21.965     4.190     0.200
    22.968     4.468     0.200
    23.233     0.451     0.200
    23.454     0.999     0.200
    24.633     0.709     0.200
    25.475     4.691     0.200
    26.048     4.616     0.200
    26.171     4.470     0.200
    26.171     4.688     0.200
    28.604     0.805     0.200
    28.604     1.305     0.200
    28.684     1.577     0.200
    28.684     1.706     0.200
    29.641     1.100     0.200
    29.641     1.291     0.200
    29.606     3.146     0.200
    29.990     2.815     0.200
    29.990     2.096     0.200
    29.990     1.616     0.200
    30.379     3.248     0.200
    30.438     3.611     0.200
    30.578     2.597     0.200
    30.578     2.066     0.200
    31.143     1.421     0.200
    31.640     2.301     0.200
    31.881     2.982     0.200
    32.542     1.489     0.200
    32.542     1.685     0.200
    32.865     1.684     0.200
    33.333     1.781     0.200
    33.540     3.137     0.200
    33.683     2.139     0.200
    33.694     2.346     0.200
    33.893     1.003     0.200
    34.003     4.381     0.200
    34.518     2.331     0.200
    34.932     3.033     0.200
    34.932     2.533     0.200
    34.986     3.316     0.200
    34.988     3.401     0.200
    35.466     3.732     0.200
    35.466     4.229     0.200
    35.466     3.533     0.200
    35.525     3.046     0.200
    35.870     2.880     0.200
    36.073     2.300     0.200
    36.197     1.760     0.200
    36.387     2.916     0.200
    36.421     2.133     0.200
    36.720     0.658     0.200
    36.996     2.446     0.200
    36.996     2.688     0.200
    36.996     2.243     0.200
    37.132     3.585     0.200
    37.132     3.288     0.200
    37.461     3.044     0.200
    37.483     3.308     0.200
    37.607     2.962     0.200
    37.607     2.559     0.200
    37.696     2.211     0.200
    37.696     1.910     0.200
    37.744     2.702     0.200
    37.744     2.866     0.200
    37.744     2.401     0.200
    37.829     2.714     0.200
    37.886     2.303     0.200
    37.886     1.905     0.200
    37.902     2.665     0.200
    37.902     2.266     0.200
    38.149     2.923     0.200
    38.465     2.654     0.200
    38.491     2.805     0.200
    38.491     2.504     0.200
    38.531     2.524     0.200
    38.777     2.799     0.200
    38.777     2.401     0.200
    39.010     0.606     0.200
    39.672     2.820     0.200
    39.672     2.320     0.200
    39.801     1.497     0.200
    40.425     1.633     0.200
    40.561     2.334     0.200
    40.561     2.686     0.200
    40.561     1.936     0.200
    40.740     2.756     0.200
    40.740     2.354     0.200
    40.945     2.068     0.200
    40.945     1.666     0.200
    41.052     2.387     0.200
    41.049     3.211     0.200
    41.154     3.544     0.200
    41.154     2.610     0.200
    41.241     2.225     0.200
    41.241     2.326     0.200
    41.241     2.080     0.200
    41.287    -0.043     0.200
    41.280     2.813     0.200
    41.280     2.012     0.200
    41.736     1.566     0.200
    41.859     2.559     0.200
    41.859     2.247     0.200
    41.926     2.517     0.200
    41.926     2.115     0.200
    41.993     2.669     0.200
    41.993     2.059     0.200
    42.034     1.834     0.200
    42.101     2.588     0.200
    42.233     1.809     0.200
    42.351     0.268     0.200
    42.383     2.384     0.200
    42.582     1.462     0.200
    42.714     1.764     0.200
    42.803     3.071     0.200
    43.182     2.402     0.200
    43.371     3.275     0.200
    43.841     0.886     0.200
    43.878     1.889     0.200
    44.687     2.502     0.200
    44.709     2.791     0.200
    44.730     3.535     0.200
    44.762     2.844     0.200
    44.728     3.281     0.200
    45.122     3.901     0.200
    45.295     3.368     0.200
    45.318     0.565     0.200
    45.344     3.088     0.200
    45.539     1.541     0.200
    45.668     2.661     0.200
    45.579     0.754     0.200
    46.163     2.696     0.200
    46.470     0.838     0.200
    47.373     1.574     0.200
    47.486     2.717     0.200
    47.661     2.358     0.200
    47.978     2.677     0.200
    48.164     1.946     0.200
    49.542     2.155     0.200
    50.181     2.361     0.200
    50.269     0.709     0.200
    50.460     2.180     0.200
    50.699     2.337     0.200
    51.433     2.087     0.200
    53.329     2.014     0.200
    53.427     0.525     0.200
    53.824     1.535     0.200
    54.039     1.030     0.200
    54.587     1.934     0.200
    54.685     1.460     0.200
    56.349     0.465     0.200
    57.492     1.678     0.200
    58.411     1.683     0.200
    60.286     0.578     0.200
    60.755     0.653     0.200
    60.891     0.728     0.200
    60.999     1.730     0.200
    61.666     1.647     0.200
    62.585     2.331     0.200
    64.078     1.971     0.200
    71.943     1.734     0.200
    72.508     1.466     0.200
    72.678    -0.007     0.200
    73.002     2.245     0.200
    73.224     2.234     0.200
    73.730     1.880     0.200
    73.654     2.329     0.200
    73.819     1.500     0.200
    74.042     1.197     0.200
    74.380     1.320     0.200
    74.380     0.691     0.200
    74.485     1.906     0.200
    75.136     1.738     0.200
    75.229     1.245     0.200
    75.325     0.621     0.200
    76.043    -0.032     0.200
    76.224    -0.294     0.200
    76.545     0.949     0.200
    76.840     1.518     0.200
    78.682    -0.347     0.200
    79.746     0.638     0.200
    80.215     2.568     0.200
    80.692     1.965     0.200
    80.794     0.366     0.200
    80.910    -0.444     0.200
    81.274     1.524     0.200
    81.364     0.416     0.200
    82.648    -0.585     0.200
    83.023    -0.148     0.200
    83.618     0.361     0.200
    84.563     1.128     0.200
    84.629     0.202     0.200
    87.391     0.987     0.200
    76.258     1.547     0.200
    29.793     2.900     0.200
    21.612    -0.286     0.200
    21.906    -0.738     0.200
    23.233    -0.236     0.200
    23.254     0.938     0.200
    23.292     3.343     0.200
    23.454    -0.661     0.200
    25.282     1.501     0.200
    27.315     0.929     0.200
    27.731     0.394     0.200
    28.340     1.761     0.200
    29.606     3.521     0.200
    29.793     2.857     0.200
    29.990     1.213     0.200
    29.641     0.701     0.200
    31.143     1.030     0.200
    32.910    -1.295     0.200
    33.235     3.157     0.200
    33.431     1.666     0.200
    33.893     0.933     0.200
    34.024     1.489     0.200
    33.807     1.386     0.200
    34.152     3.065     0.200
    34.561     3.433     0.200
    34.740     3.418     0.200
    34.932     3.482     0.200
    34.889     2.605     0.200
    34.976     3.487     0.200
    35.003     3.416     0.200
    35.022     2.678     0.200
    35.098     3.017     0.200
    35.218     3.736     0.200
    35.282     3.134     0.200
    35.393     3.332     0.200
    35.633     0.000     0.200
    35.892     0.671     0.200
    35.870     2.579     0.200
    36.073     2.612     0.200
    36.083     2.325     0.200
    36.387     3.154     0.200
    36.697    -0.111     0.200
    36.926     3.088     0.200
    37.431    -0.051     0.200
    37.385     2.242     0.200
    37.408     1.651     0.200
    37.483     3.542     0.200
    37.607     3.075     0.200
    37.677     1.670     0.200
    37.829     3.066     0.200
    38.406     2.948     0.200
    38.471     3.051     0.200
    38.491     3.199     0.200
    38.531     2.759     0.200
    38.823     0.479     0.200
    38.521     2.051     0.200
    39.010    -1.156     0.200
    39.233     1.977     0.200
    39.672     3.034     0.200
    41.241     2.510     0.200
    43.436     2.545     0.200
    43.841     1.085     0.200
    44.323     0.329     0.200
    44.323     1.153     0.200
    45.457     0.030     0.200
    45.534    -1.030     0.200
    45.539     0.935     0.200
    46.314    -1.186     0.200
    46.869     0.411     0.200
    46.690     2.365     0.200
    47.373     2.124     0.200
    47.483    -1.526     0.200
    50.269     0.380     0.200
    53.398     0.176     0.200
    53.398     1.024     0.200
    53.427     1.017     0.200
    53.824    -0.301     0.200
    54.039     0.925     0.200
    54.689     1.096     0.200
    60.286    -0.074     0.200
    61.964    -1.056     0.200
    81.274     0.634     0.200
    83.007    -0.459     0.200
    84.353     1.137     0.200
    94.548    -1.974     0.200
    20.230     1.205     0.200
    20.621     0.536     0.200
    20.978     3.347     0.200
    21.612    -0.286     0.200
    21.612     0.374     0.200
    23.233     1.533     0.200
    23.288     1.565     0.200
    23.454     1.640     0.200
    24.633     0.502     0.200
    26.859     1.720     0.200
    26.859     1.322     0.200
    27.153     2.317     0.200
    28.684     1.179     0.200
    29.551     1.922     0.200
    29.793     2.114     0.200
    29.860     0.694     0.200
    29.860     0.834     0.200
    30.796     0.158     0.200
    31.143     0.511     0.200
    33.893     0.535     0.200
    34.442     1.556     0.200
    39.010    -0.078     0.200
    40.425     0.551     0.200
    41.287    -1.059     0.200
    42.351    -0.150     0.200
    43.370     1.989     0.200
    43.994     0.349     0.200
    44.687     1.693     0.200
    45.344     2.354     0.200
    45.534     0.067     0.200
    45.668     2.493     0.200
    46.163     1.285     0.200
    46.314    -0.268     0.200
    47.207     1.732     0.200
    47.373     0.867     0.200
    47.486     1.838     0.200
    47.483    -0.748     0.200
    49.542     0.882     0.200
    50.181     1.123     0.200
    53.427     0.025     0.200
    53.824     0.359     0.200
    57.492     1.271     0.200
    58.411     1.160     0.200
    60.384     1.811     0.200
    60.755     0.344     0.200
    62.647     0.758     0.200
    64.078     1.467     0.200
    64.044     1.034     0.200
    64.328     1.362     0.200
    70.363     1.461     0.200
    72.508     0.330     0.200
    72.584    -0.338     0.200
    72.932    -0.141     0.200
    73.654     1.333     0.200
    74.380     0.332     0.200
    74.999    -0.089     0.200
    76.224     0.194     0.200
    76.412     2.140     0.200
    76.545     0.633     0.200
    76.529    -0.599     0.200
    80.910    -0.991     0.200
    81.274     0.962     0.200
    90.022     0.895     0.200
    96.156     0.050     0.200
    18.308     1.547     0.200
    21.041     1.989     0.200
    21.592     0.127     0.200
    21.592     0.361     0.200
    23.260     1.441     0.200
    28.540     1.936     0.200
    35.527     2.589     0.200
    36.760     0.126     0.200
    38.866     0.503     0.200
    17.048     2.907     0.200
    18.376     1.053     0.200
    19.284     2.406     0.200
    19.415     0.873     0.200
    21.291     5.045     0.200
    21.691     0.591     0.200
    21.754     5.072     0.200
    21.985     0.538     0.200
    22.350     2.740     0.200
    23.275     2.247     0.200
    23.299     0.888     0.200
    23.475     3.556     0.200
    23.475     3.401     0.200
    23.475     2.540     0.200
    25.356     2.154     0.200
    26.053     4.348     0.200
    27.792     1.876     0.200
    28.409     2.173     0.200
    28.591     0.702     0.200
    29.629     3.423     0.200
    29.629     2.433     0.200
    29.633     2.232     0.200
    29.610     3.364     0.200
    29.847     1.204     0.200
    29.800     2.624     0.200
    30.053     2.575     0.200
    32.528     2.168     0.200
    32.968     1.427     0.200
    33.713     3.251     0.200
    33.872     2.140     0.200
    74.183  -291.546     0.200
    33.926     0.769     0.200
    33.926     0.680     0.200
    34.929     1.093     0.200
    34.954     3.348     0.200
    34.954     3.539     0.200
    35.007     3.475     0.200
    35.010     3.166     0.200
    35.487     3.771     0.200
    35.487     3.905     0.200
    35.540     2.918     0.200
    35.971     1.319     0.200
    36.159     5.323     0.200
    36.408     2.976     0.200
    36.408     2.695     0.200
    37.017     1.751     0.200
    37.407     2.978     0.200
    37.497     3.126     0.200
    37.768     3.077     0.200
    37.768     2.786     0.200
    37.846     2.976     0.200
    38.170     2.897     0.200
    38.426     3.220     0.200
    38.485     2.977     0.200
    38.494     2.872     0.200
    38.548     2.725     0.200
    38.876     0.373     0.200
    39.303     2.017     0.200
    39.468     3.473     0.200
    40.967     1.737     0.200
    41.271     2.492     0.200
    41.382     2.208     0.200
    41.443     2.215     0.200
    41.592     2.555     0.200
    41.639     2.575     0.200
    41.767     2.202     0.200
    44.371     0.133     0.200
    46.445     1.309     0.200
    53.874     1.557     0.200
    76.303    -0.012     0.200
    81.244     0.615     0.200
    83.085    -0.336     0.200
    20.996     1.994     0.200
    21.291     1.224     0.200
    23.301     2.076     0.200
    23.299     1.859     0.200
    23.475     0.020     0.200
    24.585    -0.844     0.200
    28.591     0.353     0.200
    33.008     1.779     0.200
    33.926    -0.022     0.200
    34.929     0.663     0.200
    35.487     2.187     0.200
    36.112     1.256     0.200
    38.083     0.436     0.200
    41.249     0.287     0.200
    43.381     1.267     0.200
    44.077     0.850     0.200
    44.784     2.009     0.200
    44.863     0.911     0.200
    45.239     2.215     0.200
    45.315     1.951     0.200
    46.968     0.624     0.200
    47.261     0.919     0.200
    48.384     0.515     0.200
    53.443     0.438     0.200
    54.664     0.743     0.200
    58.428     0.793     0.200
    62.712     1.439     0.200
    71.243     0.117     0.200
    71.557    -0.100     0.200
    71.974    -0.140     0.200
    71.975    -0.354     0.200
    72.757     0.214     0.200
    73.012     0.363     0.200
    73.176    -0.249     0.200
    75.405     0.202     0.200
    75.479     0.225     0.200
    75.662     0.865     0.200
    75.751    -0.086     0.200
    75.870     0.625     0.200
    76.214    -0.385     0.200
    76.264    -0.307     0.200
    76.511    -0.909     0.200
    77.771     0.139     0.200
    77.929    -0.168     0.200
    77.954    -0.466     0.200
    78.486    -0.088     0.200
    78.685    -0.323     0.200
    78.762    -0.297     0.200
    78.805    -0.592     0.200
    79.032    -0.213     0.200
    79.667     0.704     0.200
    79.910    -0.544     0.200
    80.989    -0.208     0.200
    82.087     1.302     0.200
    83.577     0.082     0.200
    17.048     2.013     0.200
    18.378     1.430     0.200
    19.412     1.328     0.200
    19.293     2.538     0.200
    19.839    -0.934     0.200
    21.300     3.820     0.200
    21.300     4.882     0.200
    21.690    -0.092     0.200
    21.690    -0.069     0.200
    21.985     0.371     0.200
    21.972     3.785     0.200
    22.359     3.180     0.200
    22.736     1.674     0.200
    22.990     4.164     0.200
    23.304     0.470     0.200
    23.283     1.190     0.200
    23.319     3.811     0.200
    23.456     3.353     0.200
    23.483     1.698     0.200
    23.483     1.886     0.200
    23.483     1.452     0.200
    24.592     1.105     0.200
    25.491     4.361     0.200
    26.184     4.336     0.200
    27.663     2.794     0.200
    27.798     0.873     0.200
    27.850     4.585     0.200
    27.814     3.419     0.200
    28.404     2.559     0.200
    28.582     1.149     0.200
    28.582     1.520     0.200
    28.670     2.292     0.200
    28.847     2.259     0.200
    28.775     2.107     0.200
    29.104     2.745     0.200
    29.304     2.490     0.200
    29.620     0.759     0.200
    29.620     1.165     0.200
    29.620     1.060     0.200
    29.572     2.492     0.200
    29.619     3.161     0.200
    29.698     2.372     0.200
    29.838     1.629     0.200
    29.869     1.266     0.200
    29.729     3.422     0.200
    29.741     2.624     0.200
    29.808     2.798     0.200
    30.048     1.969     0.200
    30.048     2.270     0.200
    30.393     3.164     0.200
    30.454     3.060     0.200
    30.454     2.838     0.200
    30.569     1.641     0.200
    30.565     2.329     0.200
    31.196     1.336     0.200
    31.196     1.039     0.200
    31.899     2.780     0.200
    32.519     2.347     0.200
    32.883     2.066     0.200
    32.974     0.222     0.200
    33.340     0.978     0.200
    33.460     2.122     0.200
    33.566     2.248     0.200
    33.867     2.034     0.200
    33.710     2.119     0.200
    33.722     2.509     0.200
    33.811     2.913     0.200
    33.934     1.052     0.200
    33.934     1.142     0.200
    33.934     1.427     0.200
    34.017     2.645     0.200
    34.020     2.299     0.200
    34.060     1.576     0.200
    34.063     1.773     0.200
    34.238     2.176     0.200
    34.140     2.853     0.200
    34.183     2.826     0.200
    34.206     2.197     0.200
    34.411     2.014     0.200
    34.238     4.051     0.200
    34.238     3.945     0.200
    34.439     2.564     0.200
    34.485     2.716     0.200
    34.484     1.760     0.200
    34.525     1.876     0.200
    34.575     2.582     0.200
    34.670     3.427     0.200
    34.728     3.197     0.200
    34.762     2.148     0.200
    34.764     2.846     0.200
    34.920     1.261     0.200
    34.785     3.197     0.200
    34.910     1.819     0.200
    34.962     3.149     0.200
    34.962     2.805     0.200
    35.007     2.895     0.200
    35.016     3.295     0.200
    35.018     3.334     0.200
    35.054     2.247     0.200
    35.073     2.845     0.200
    35.104     2.200     0.200
    35.121     2.940     0.200
    35.154     2.101     0.200
    35.219     2.936     0.200
    35.247     3.350     0.200
    35.257     3.292     0.200
    35.404     1.855     0.200
    35.417     3.170     0.200
    35.423     2.887     0.200
    35.416     2.123     0.200
    35.461     2.797     0.200
    35.472     2.707     0.200
    35.495     3.557     0.200
    35.495     3.865     0.200
    35.681     0.861     0.200
    35.817     3.077     0.200
    35.972     1.062     0.200
    36.030     1.856     0.200
    35.902     2.648     0.200
    35.980     3.183     0.200
    36.001     3.165     0.200
    36.000     2.691     0.200
    36.240     2.800     0.200
    36.111     3.132     0.200
    36.263     1.625     0.200
    36.261     2.359     0.200
    36.416     2.952     0.200
    36.416     2.784     0.200
    36.431     2.421     0.200
    36.431     2.015     0.200
    36.431     2.151     0.200
    36.702     0.661     0.200
    36.684     1.798     0.200
    36.598     1.344     0.200
    36.641     2.703     0.200
    36.758     1.049     0.200
    36.787     3.121     0.200
    36.954     2.894     0.200
    37.016     2.833     0.200
    37.028     3.220     0.200
    37.025     2.271     0.200
    37.025     2.525     0.200
    37.164     3.294     0.200
    37.164     3.013     0.200
    37.415     2.553     0.200
    37.437     1.901     0.200
    37.486     0.562     0.200
    37.493     2.844     0.200
    37.506     3.174     0.200
    37.637     2.983     0.200
    37.706     1.892     0.200
    37.725     2.043     0.200
    37.776     3.009     0.200
    37.776     2.907     0.200
    37.974     0.782     0.200
    37.854     2.172     0.200
    37.924     2.561     0.200
    37.924     2.338     0.200
    37.937     2.347     0.200
    37.937     2.148     0.200
    37.937     2.616     0.200
    37.971     1.180     0.200
    38.090     1.227     0.200
    38.157     2.369     0.200
    38.179     3.007     0.200
    38.224     0.623     0.200
    38.224     0.776     0.200
    38.342     3.323     0.200
    38.342     4.433     0.200
    38.342     2.835     0.200
    38.580     2.213     0.200
    38.415     2.826     0.200
    38.435     2.992     0.200
    38.493     2.741     0.200
    38.502     3.143     0.200
    38.520     2.821     0.200
    38.520     2.532     0.200
    38.529     0.876     0.200
    38.556     2.690     0.200
    38.813     1.486     0.200
    38.812     2.584     0.200
    38.812     2.482     0.200
    38.881     3.804     0.200
    39.017     0.937     0.200
    39.079     0.744     0.200
    39.079     0.213     0.200
    38.963     4.842     0.200
    39.299     2.103     0.200
    39.145     3.695     0.200
    39.145     2.734     0.200
    39.145     3.496     0.200
    39.208     0.774     0.200
    39.256     2.558     0.200
    39.320     4.429     0.200
    39.320     3.831     0.200
    39.343     1.559     0.200
    39.495     0.222     0.200
    39.452     3.828     0.200
    39.452     3.328     0.200
    39.476     3.600     0.200
    39.500     0.237     0.200
    39.731     0.381     0.200
    39.847     1.548     0.200
    39.847     1.189     0.200
    39.706     2.511     0.200
    39.706     2.363     0.200
    39.706     2.711     0.200
    39.840     1.629     0.200
    39.826     2.514     0.200
    39.843     2.945     0.200
    40.202     2.541     0.200
    40.298     2.896     0.200
    40.298     3.197     0.200
    40.298     2.466     0.200
    40.482     0.314     0.200
    40.424     0.455     0.200
    40.448     1.399     0.200
    40.448     1.617     0.200
    40.592     2.060     0.200
    40.592     1.959     0.200
    40.592     2.318     0.200
    40.696     0.156     0.200
    40.774     2.159     0.200
    40.774     2.359     0.200
    40.894     2.189     0.200
    40.976     1.793     0.200
    40.976     2.094     0.200
    41.081     2.423     0.200
    41.089     2.689     0.200
    41.143     0.726     0.200
    41.081     2.294     0.200
    41.242    -0.328     0.200
    41.190     2.924     0.200
    41.190     3.135     0.200
    41.279     2.095     0.200
    41.279     2.365     0.200
    41.372     0.613     0.200
    41.313     2.322     0.200
    41.313     2.123     0.200
    41.389     2.447     0.200
    41.390     2.058     0.200
    41.445     3.634     0.200
    41.445     2.736     0.200
    41.451     2.333     0.200
    41.445     2.416     0.200
    41.518     2.568     0.200
    41.577     2.304     0.200
    41.600     2.644     0.200
    41.633     1.423     0.200
    41.647     2.724     0.200
    41.715     2.621     0.200
    41.715     2.508     0.200
    41.715     2.403     0.200
    41.775     2.262     0.200
    41.871     2.942     0.200
    41.871     2.340     0.200
    41.871     2.590     0.200
    41.897     2.235     0.200
    41.897     2.396     0.200
    41.927     2.608     0.200
    41.960     2.219     0.200
    41.960     2.117     0.200
    42.029     2.048     0.200
    42.073     2.558     0.200
    42.098     1.931     0.200
    42.135     1.989     0.200
    42.237     2.535     0.200
    42.235     2.170     0.200
    42.272     2.379     0.200
    42.420     0.464     0.200
    42.417     2.087     0.200
    42.464     5.004     0.200
    42.471     2.250     0.200
    42.621     2.030     0.200
    42.621     2.300     0.200
    42.602     1.371     0.200
    42.682     2.336     0.200
    42.682     2.105     0.200
    42.787     0.360     0.200
    42.751     2.307     0.200
    42.751     2.111     0.200
    42.833     2.502     0.200
    43.139    -0.016     0.200
    43.194     2.117     0.200
    43.220     2.076     0.200
    43.220     2.326     0.200
    43.339     2.778     0.200
    43.403     2.396     0.200
    43.403     2.576     0.200
    43.390     2.455     0.200
    43.456     1.052     0.200
    43.463     2.444     0.200
    43.494     1.978     0.200
    43.587     2.082     0.200
    43.689     1.347     0.200
    43.803     1.989     0.200
    43.811     1.995     0.200
    43.878     1.972     0.200
    43.917     2.244     0.200
    43.928     1.614     0.200
    44.004    -0.111     0.200
    44.024     1.833     0.200
    44.086     2.218     0.200
    44.085     2.218     0.200
    44.111     2.365     0.200
    44.174     1.444     0.200
    44.177     2.210     0.200
    44.543     2.092     0.200
    44.728     1.640     0.200
    44.721     2.845     0.200
    44.746     1.820     0.200
    44.746     3.042     0.200
    44.599     1.808     0.200
    44.775     3.175     0.200
    44.697     1.783     0.200
    44.752     2.615     0.200
    44.777     1.334     0.200
    44.871     1.773     0.200
    44.947     1.763     0.200
    45.137     2.699     0.200
    45.024     2.673     0.200
    45.071     2.068     0.200
    45.231     3.312     0.200
    45.119     2.825     0.200
    45.119     2.517     0.200
    45.121     2.813     0.200
    45.124     2.257     0.200
    45.307     3.978     0.200
    45.203     1.962     0.200
    45.226     2.221     0.200
    45.236     2.378     0.200
    45.236     2.100     0.200
    45.248     1.275     0.200
    45.249     1.502     0.200
    45.250     2.575     0.200
    45.294     2.760     0.200
    45.313     2.901     0.200
    45.319     1.516     0.200
    45.343     2.022     0.200
    45.352     1.126     0.200
    45.538     1.517     0.200
    45.345     1.966     0.200
    45.382     3.042     0.200
    45.382     2.843     0.200
    45.382     2.718     0.200
    45.382     2.874     0.200
    45.578     1.039     0.200
    45.423     2.228     0.200
    45.607    -0.325     0.200
    45.470     2.154     0.200
    45.709     1.487     0.200
    45.601     1.267     0.200
    45.613     1.082     0.200
    45.670     1.071     0.200
    45.777     1.855     0.200
    45.797     1.897     0.200
    45.829     1.975     0.200
    45.904     1.246     0.200
    45.885     1.309     0.200
    45.885     0.895     0.200
    45.962     1.301     0.200
    46.179     1.296     0.200
    46.179     0.811     0.200
    46.066     1.973     0.200
    46.060     2.252     0.200
    46.086     1.740     0.200
    46.139     2.440     0.200
    46.284     2.282     0.200
    46.440     1.308     0.200
    46.303     1.707     0.200
    46.329     1.627     0.200
    46.368     0.872     0.200
    46.368     0.474     0.200
    46.380     1.748     0.200
    46.443     1.545     0.200
    46.458     2.383     0.200
    46.463     2.240     0.200
    46.504     1.608     0.200
    46.504     1.448     0.200
    46.530     2.130     0.200
    46.522     2.175     0.200
    46.740     2.958     0.200
    46.617     2.274     0.200
    46.617     1.910     0.200
    46.637     1.774     0.200
    46.718     2.399     0.200
    46.763     2.397     0.200
    46.765     1.693     0.200
    46.786     2.383     0.200
    46.786     2.106     0.200
    46.806     1.791     0.200
    47.009     2.549     0.200
    46.920     1.899     0.200
    46.940     2.292     0.200
    46.976     1.299     0.200
    47.057     2.287     0.200
    47.091     2.517     0.200
    47.122     2.092     0.200
    47.122     2.393     0.200
    47.143     1.556     0.200
    47.434     1.837     0.200
    47.269     0.752     0.200
    47.304     2.387     0.200
    47.383     1.754     0.200
    47.375     1.398     0.200
    47.375     1.120     0.200
    47.399     2.615     0.200
    47.409     1.768     0.200
    47.409     1.530     0.200
    47.409     1.319     0.200
    47.561    -0.357     0.200
    47.561     0.046     0.200
    47.452     2.001     0.200
    47.423     3.090     0.200
    47.423     3.211     0.200
    47.483     1.749     0.200
    47.697     1.802     0.200
    47.697     1.630     0.200
    47.539     2.999     0.200
    47.546     1.434     0.200
    47.662     1.385     0.200
    47.686     1.735     0.200
    47.736     2.430     0.200
    47.732     1.652     0.200
    47.754     1.762     0.200
    47.911     2.907     0.200
    47.769     2.424     0.200
    47.807     2.352     0.200
    47.805     1.534     0.200
    47.880     1.436     0.200
    47.886     1.438     0.200
    47.916     1.645     0.200
    47.964     2.351     0.200
    47.964     2.112     0.200
    47.914     2.788     0.200
    47.970     1.703     0.200
    47.998     1.827     0.200
    48.200     1.487     0.200
    48.200     1.369     0.200
    48.200     1.709     0.200
    48.259     2.763     0.200
    48.274     1.227     0.200
    48.274     1.598     0.200
    48.632     2.053     0.200
    48.632     1.823     0.200
    48.645     2.014     0.200
    48.659     2.705     0.200
    48.659     2.467     0.200
    48.663     1.648     0.200
    48.654     2.035     0.200
    48.848     1.371     0.200
    48.814     1.836     0.200
    48.971     1.592     0.200
    49.217     1.153     0.200
    49.067     2.140     0.200
    49.186     2.024     0.200
    49.282     0.787     0.200
    49.273     0.775     0.200
    49.521     0.927     0.200
    49.521     0.443     0.200
    49.529     2.718     0.200
    49.529     2.585     0.200
    49.511     2.026     0.200
    49.514     2.327     0.200
    49.640     0.993     0.200
    50.153     2.337     0.200
    50.125     1.893     0.200
    50.343     0.764     0.200
    50.343     1.307     0.200
    50.343     0.924     0.200
    50.334     2.127     0.200
    50.492     1.898     0.200
    50.492     2.019     0.200
    50.680     2.609     0.200
    50.554     1.199     0.200
    51.471     2.323     0.200
    51.471     2.092     0.200
    51.256     1.926     0.200
    51.610     1.249     0.200
    51.664     0.966     0.200
    51.768     1.973     0.200
    51.768     1.840     0.200
    52.031     1.349     0.200
    52.329     1.470     0.200
    52.571     2.136     0.200
    52.851     0.798     0.200
    53.370     1.213     0.200
    53.427     0.781     0.200
    53.292     1.189     0.200
    53.367     0.632     0.200
    53.538     1.137     0.200
    53.377     1.266     0.200
    53.475     0.457     0.200
    53.475     0.609     0.200
    53.868     1.024     0.200
    54.097     1.391     0.200
    54.097     0.727     0.200
    54.097     0.899     0.200
    54.445     0.896     0.200
    54.637     0.965     0.200
    54.450     2.321     0.200
    54.546     0.885     0.200
    54.740     0.750     0.200
    54.743     1.090     0.200
    54.693     1.398     0.200
    55.002     1.394     0.200
    55.354     2.652     0.200
    55.512     0.344     0.200
    55.757     0.868     0.200
    55.715     0.708     0.200
    55.964     0.185     0.200
    55.964    -0.010     0.200
    56.078     1.827     0.200
    55.942     1.076     0.200
    56.082     0.751     0.200
    56.160     1.042     0.200
    56.421     0.259     0.200
    56.557     2.299     0.200
    56.758     1.611     0.200
    57.324     2.798     0.200
    57.333     1.427     0.200
    57.488     1.760     0.200
    57.864     2.377     0.200
    58.335     1.500     0.200
    58.335     0.965     0.200
    58.436     1.776     0.200
    58.964     0.984     0.200
    59.101     1.608     0.200
    59.396    -0.890     0.200
    59.286     2.045     0.200
    59.519     0.487     0.200
    60.071     2.322     0.200
    60.071     2.115     0.200
    60.240     0.725     0.200
    60.363     0.790     0.200
    60.363     0.486     0.200
    60.412     2.587     0.200
    60.723    -0.337     0.200
    60.814     1.224     0.200
    60.832     1.189     0.200
    60.832     0.595     0.200
    60.950     0.866     0.200
    61.025     1.775     0.200
    61.397     0.158     0.200
    61.460     2.102     0.200
    61.690     1.711     0.200
    62.581     1.441     0.200
    62.609     2.174     0.200
    62.717     1.451     0.200
    63.157     0.476     0.200
    63.439     3.322     0.200
    64.014     2.527     0.200
    64.059     1.617     0.200
    64.329     1.184     0.200
    65.006    -1.841     0.200
    67.136    -0.226     0.200
    67.217    -0.150     0.200
    67.890     0.243     0.200
    67.890     0.403     0.200
    68.681     1.346     0.200
    68.681     1.236     0.200
    69.378     1.065     0.200
    69.378     0.666     0.200
    69.378     0.092     0.200
    70.270     0.345     0.200
    70.348     0.176     0.200
    70.406     1.882     0.200
    70.677     2.892     0.200
    71.822     0.140     0.200
    71.871     1.814     0.200
    72.381    -0.152     0.200
    72.465     0.703     0.200
    72.758     0.048     0.200
    72.847     0.660     0.200
    73.156     2.396     0.200
    73.594     2.245     0.200
    74.007     1.184     0.200
    74.237     1.005     0.200
    68.670     0.432     0.200
    74.455     1.578     0.200
    74.363     1.121     0.200
    74.363     0.929     0.200
    74.729     1.962     0.200
    75.112     1.017     0.200
    75.195     1.386     0.200
    75.405     0.823     0.200
    75.753     0.226     0.200
    75.994     0.396     0.200
    76.304    -0.180     0.200
    76.189     1.813     0.200
    76.189     1.684     0.200
    76.350     2.876     0.200
    76.493     0.334     0.200
    76.813     1.242     0.200
    78.072    -0.512     0.200
    78.959    -1.328     0.200
    78.899    -0.419     0.200
    78.951    -0.300     0.200
    79.391    -0.222     0.200
    79.350     2.417     0.200
    79.697     0.580     0.200
    79.603     1.865     0.200
    80.216     1.688     0.200
    80.176    -0.578     0.200
    80.176    -0.449     0.200
    80.653     1.311     0.200
    80.745     0.320     0.200
    80.989    -0.149     0.200
    80.989    -0.266     0.200
    81.236     0.837     0.200
    81.244     0.591     0.200
    81.244     0.899     0.200
    81.244     0.778     0.200
    81.319     0.864     0.200
    81.446     0.345     0.200
    81.511     2.582     0.200
    81.750     0.580     0.200
    82.728    -0.396     0.200
    83.018    -0.082     0.200
    83.087    -0.070     0.200
    83.685     0.242     0.200
    83.956     0.547     0.200
    84.346     1.103     0.200
    84.346     1.576     0.200
    84.585     0.597     0.200
    84.585     0.945     0.200
    84.682     0.671     0.200
    84.623     0.998     0.200
    85.358     0.354     0.200
    87.355     0.483     0.200
    87.355     0.686     0.200
    87.366     0.777     0.200
    87.366     1.011     0.200
    87.684     0.345     0.200
    87.956     0.483     0.200
    88.258     0.426     0.200
    90.002     0.336     0.200
    90.002     0.613     0.200
    90.734     0.882     0.200
    90.734     1.022     0.200
    90.759     0.966     0.200
    90.911    -0.646     0.200
    91.737     0.747     0.200
    92.452     0.491     0.200
    92.937     0.765     0.200
    93.136     0.906     0.200
    93.526     0.629     0.200
    93.900    -0.219     0.200
    93.945     0.424     0.200
    94.372     0.952     0.200
    94.624     0.083     0.200
    95.121     0.218     0.200
    95.505     1.339     0.200
    95.639     0.709     0.200
    95.789     1.022     0.200
    95.881     0.167     0.200
    96.455     0.416     0.200
    97.148     0.582     0.200
    97.275     1.337     0.200
    97.683     0.103     0.200
    38.883     0.820     0.200
    44.378     0.671     0.200
    45.513    -0.026     0.200
    46.941     0.782     0.200
    49.223     1.305     0.200
    20.621     2.033     0.200
    21.004     3.139     0.200
    21.300     4.050     0.200
    21.690     0.670     0.200
    21.690     0.170     0.200
    23.304     0.181     0.200
    23.483     1.065     0.200
    24.592     1.312     0.200
    25.436     3.090     0.200
    26.861     2.593     0.200
    27.161     2.025     0.200
    27.663     1.833     0.200
    27.703     3.682     0.200
    27.814     3.001     0.200
    28.339     3.111     0.200
    28.582     0.969     0.200
    28.670     1.639     0.200
    28.775     2.900     0.200
    28.847     1.830     0.200
    29.104     2.162     0.200
    29.304     2.361     0.200
    29.572     2.621     0.200
    29.838     1.571     0.200
    29.869     0.945     0.200
    29.808     2.806     0.200
    30.048     1.821     0.200
    30.454     2.724     0.200
    30.569     2.117     0.200
    31.196     0.738     0.200
    31.652     3.475     0.200
    33.934     1.009     0.200
    34.062     1.550     0.200
    34.238     3.605     0.200
    34.411     1.495     0.200
    36.240     2.323     0.200
    38.580     1.252     0.200
    39.079     0.045     0.200
    40.134     1.366     0.200
    42.370     1.339     0.200
    42.420     0.140     0.200
    43.878     1.512     0.200
    44.024    -0.346     0.200
    44.130     2.946     0.200
    44.445     1.421     0.200
    44.728     1.414     0.200
    44.721     2.544     0.200
    45.345     0.146     0.200
    45.382     2.491     0.200
    45.451     1.144     0.200
    47.224     0.953     0.200
    47.561    -0.533     0.200
    47.423     2.610     0.200
    49.282     0.557     0.200
    50.153     1.302     0.200
    50.343     0.487     0.200
    53.475     0.738     0.200
    53.868     0.419     0.200
    54.097     0.168     0.200
    55.757    -1.195     0.200
    55.964    -0.498     0.200
    57.333     1.204     0.200
    57.316     2.177     0.200
    57.488     0.975     0.200
    57.864     1.397     0.200
    58.110     1.284     0.200
    58.436     0.948     0.200
    59.396    -1.253     0.200
    60.071     1.974     0.200
    60.205     0.286     0.200
    60.240     1.006     0.200
    60.412     1.778     0.200
    60.832     0.322     0.200
    62.064    -0.607     0.200
    62.581     0.738     0.200
    62.717     0.763     0.200
    64.014     1.952     0.200
    64.059     1.058     0.200
    65.006    -1.236     0.200
    71.707     0.398     0.200
    72.465     0.035     0.200
    72.847     0.305     0.200
    73.594     0.960     0.200
    74.363     0.660     0.200
    76.304    -0.711     0.200
    76.189     1.114     0.200
    80.176    -0.840     0.200
    81.244     0.161     0.200
    81.511     0.945     0.200
    84.346     0.798     0.200
    90.002     0.144     0.200
    95.789     0.702     0.200
    20.929     3.567     0.200
    21.762    -0.200     0.200
    21.762     0.027     0.200
    23.306     1.524     0.200
    28.662     0.322     0.200
    33.878     0.207     0.200
    33.878     0.668     0.200
    35.424     2.663     0.200
    36.025     1.259     0.200
    36.054     2.348     0.200
    38.505     0.585     0.200
    38.855     0.512     0.200
    39.074     1.200     0.200
    42.414     0.029     0.200
    42.745     0.971     0.200
    44.802     1.436     0.200
    45.627     0.443     0.200
    47.330     0.714     0.200
    47.632    -0.101     0.200
    48.325     1.279     0.200
    49.233     0.792     0.200
    50.354     0.269     0.200
    54.597     0.398     0.200
    55.571     0.180     0.200
    71.616     0.140     0.200
    73.068     0.756     0.200
    73.125     0.337     0.200
    73.244     0.778     0.200
    73.513     0.266     0.200
    74.071     0.352     0.200
    74.058    -0.038     0.200
    74.649     0.768     0.200
    74.838     0.599     0.200
    75.410    -0.137     0.200
    75.735     0.406     0.200
    76.563    -0.090     0.200
    76.670    -0.588     0.200
    77.774    -0.047     0.200
    20.999     1.444     0.200
    21.294     2.602     0.200
    23.309    -0.178     0.200
    23.305     2.014     0.200
    23.479     0.007     0.200
    24.580    -0.085     0.200
    25.429     1.082     0.200
    26.854     0.974     0.200
    27.153     2.086     0.200
    28.588     0.805     0.200
    29.116     1.023     0.200
    29.876     0.273     0.200
    30.061     0.938     0.200
    30.782     1.173     0.200
    31.196     0.097     0.200
    33.932     0.410     0.200
    34.927     1.042     0.200
    39.702     2.442     0.200
    41.243     0.839     0.200
    42.423     0.465     0.200
    44.020     1.422     0.200
    44.785     2.727     0.200
    46.368     0.515     0.200
    47.234     1.492     0.200
    47.572     0.181     0.200
    49.532     2.082     0.200
    49.515     1.998     0.200
    50.158     4.169     0.200
    50.348     1.039     0.200
    50.306    -0.785     0.200
    53.474     0.682     0.200
    53.880     0.323     0.200
    57.479     0.163     0.200
    58.431     1.229     0.200
    60.407     2.003     0.200
    62.721     1.401     0.200
    64.001     2.172     0.200
    66.638     0.734     0.200
    70.359     3.001     0.200
    70.761     1.621     0.200
    71.695     2.064     0.200
    73.581     2.280     0.200
    74.010     1.656     0.200
    75.762     0.016     0.200
    76.494     0.741     0.200
    81.000    -1.191     0.200
    81.034    -0.452     0.200
    81.249     1.083     0.200
    15.882     6.963     0.200
    17.976     1.636     0.200
    18.193     2.019     0.200
    19.388     0.698     0.200
    21.296     4.767     0.200
    21.296     5.023     0.200
    21.664    -0.182     0.200
    21.664    -0.193     0.200
    21.959    -0.651     0.200
    21.971     4.433     0.200
    22.352     3.854     0.200
    22.365     4.105     0.200
    22.728     2.254     0.200
    22.984     4.219     0.200
    23.282     0.356     0.200
    23.282    -0.098     0.200
    23.275     0.769     0.200
    23.312     3.285     0.200
    23.475     1.364     0.200
    23.475     0.966     0.200
    23.475     1.926     0.200
    24.607     2.979     0.200
    25.329     1.429     0.200
    25.488     4.548     0.200
    26.058     4.394     0.200
    26.182     4.848     0.200
    26.182     4.198     0.200
    27.332     2.325     0.200
    27.573     1.866     0.200
    27.777     0.638     0.200
    27.813     4.021     0.200
    28.382     2.136     0.200
    28.588     1.342     0.200
    28.588     1.631     0.200
    29.081     2.260     0.200
    29.081     2.023     0.200
    29.081     2.534     0.200
    29.626     2.581     0.200
    29.626     2.093     0.200
    29.626     3.334     0.200
    29.616     3.036     0.200
    29.690     1.923     0.200
    29.873     1.147     0.200
    29.873     1.475     0.200
    29.805     2.605     0.200
    30.028     1.930     0.200
    30.028     1.430     0.200
    30.028     1.029     0.200
    30.028     2.189     0.200
    30.390     3.567     0.200
    30.571     3.532     0.200
    31.180     0.458     0.200
    31.180     0.874     0.200
    31.180     0.998     0.200
    32.525     1.802     0.200
    32.875     1.885     0.200
    32.954    -0.226     0.200
    33.452     1.995     0.200
    33.714     2.272     0.200
    33.922     1.033     0.200
    33.922     1.211     0.200
    33.922     1.457     0.200
    34.009     2.490     0.200
    34.050     1.360     0.200
    34.058     2.706     0.200
    34.174     2.550     0.200
    34.257     5.472     0.200
    34.578     2.686     0.200
    34.753     2.323     0.200
    34.954     3.496     0.200
    34.954     2.854     0.200
    34.954     2.496     0.200
    34.998     3.114     0.200
    35.008     3.674     0.200
    35.010     3.134     0.200
    35.045     2.494     0.200
    35.066     2.741     0.200
    35.145     1.895     0.200
    35.178     2.423     0.200
    35.239     2.293     0.200
    35.298     3.092     0.200
    35.373     3.308     0.200
    35.394     2.051     0.200
    35.415     3.160     0.200
    35.487     3.801     0.200
    35.487     4.031     0.200
    35.487     3.601     0.200
    35.543     2.916     0.200
    35.667     0.462     0.200
    35.946     0.863     0.200
    35.892     2.907     0.200
    35.972     3.507     0.200
    35.992     2.478     0.200
    36.097     2.220     0.200
    36.408     2.765     0.200
    36.706     2.322     0.200
    36.599     3.274     0.200
    36.739     0.085     0.200
    36.946     3.096     0.200
    37.017     2.417     0.200
    37.017     2.703     0.200
    37.019     2.907     0.200
    37.155     3.244     0.200
    37.155     3.511     0.200
    37.407     2.174     0.200
    37.429     1.984     0.200
    37.470     0.178     0.200
    37.484     3.229     0.200
    37.629     2.929     0.200
    37.629     3.286     0.200
    37.698     1.418     0.200
    37.717     2.484     0.200
    37.717     2.063     0.200
    37.767     2.760     0.200
    37.767     3.186     0.200
    37.847     2.720     0.200
    37.913     2.228     0.200
    37.927     2.407     0.200
    37.927     2.207     0.200
    38.033     3.504     0.200
    38.171     2.772     0.200
    38.196     2.559     0.200
    38.210     0.517     0.200
    38.333     3.688     0.200
    38.333     2.688     0.200
    38.427     2.750     0.200
    38.560     2.107     0.200
    38.560     1.678     0.200
    38.486     2.468     0.200
    38.494     3.043     0.200
    38.512     2.675     0.200
    38.512     2.886     0.200
    38.549     2.789     0.200
    38.802     2.441     0.200
    38.802     2.341     0.200
    38.864     0.509     0.200
    38.873     4.344     0.200
    39.057     0.771     0.200
    39.057     0.101     0.200
    39.136     3.843     0.200
    39.136     3.143     0.200
    39.277     1.667     0.200
    39.443     4.082     0.200
    39.443     2.982     0.200
    39.696     2.667     0.200
    39.696     3.025     0.200
    39.696     2.468     0.200
    39.829     1.126     0.200
    40.288     3.648     0.200
    40.288     2.548     0.200
    40.584     2.303     0.200
    40.584     2.005     0.200
    40.584     1.903     0.200
    40.764     2.611     0.200
    40.764     2.311     0.200
    40.967     1.937     0.200
    41.072     2.571     0.200
    41.072     1.871     0.200
    41.255     0.330     0.200
    41.180     3.484     0.200
    41.180     2.365     0.200
    41.269     2.258     0.200
    41.269     2.155     0.200
    41.269     1.895     0.200
    41.303     2.570     0.200
    41.707     2.959     0.200
    41.707     2.662     0.200
    41.886     2.395     0.200
    41.886     2.039     0.200
    41.950     2.070     0.200
    41.950     1.770     0.200
    42.019     2.208     0.200
    42.019     1.696     0.200
    42.125     2.141     0.200
    42.226     2.116     0.200
    42.226     1.916     0.200
    42.398     0.887     0.200
    42.408     2.237     0.200
    42.462     2.392     0.200
    42.597     2.107     0.200
    42.610     2.190     0.200
    42.672     2.884     0.200
    42.825     2.444     0.200
    43.209     2.236     0.200
    43.479     1.753     0.200
    43.394     2.542     0.200
    43.867     1.528     0.200
    44.361     0.277     0.200
    44.716     2.892     0.200
    44.713     1.793     0.200
    44.739     2.503     0.200
    44.769     2.699     0.200
    44.746     2.361     0.200
    45.130     2.197     0.200
    45.225     3.097     0.200
    45.301     3.600     0.200
    45.371     2.558     0.200
    45.519     1.532     0.200
    45.563     0.864     0.200
    45.583    -1.061     0.200
    45.694     1.451     0.200
    46.172     1.876     0.200
    46.420     0.738     0.200
    46.352    -0.029     0.200
    46.722     2.465     0.200
    47.416     1.245     0.200
    47.399     1.565     0.200
    47.399     2.079     0.200
    47.445     3.343     0.200
    47.535     0.012     0.200
    47.535    -0.883     0.200
    47.936     3.230     0.200
    48.189     1.798     0.200
    49.511     0.953     0.200
    49.520     1.777     0.200
    50.161     2.562     0.200
    50.319     0.862     0.200
    50.319     0.352     0.200
    50.483     1.608     0.200
    50.684     4.064     0.200
    51.457     2.874     0.200
    53.356     0.314     0.200
    53.460     0.565     0.200
    53.460     1.220     0.200
    53.852     0.045     0.200
    53.852    -0.651     0.200
    54.077     0.302     0.200
    54.077     0.809     0.200
    54.619     1.274     0.200
    55.739     3.238     0.200
    56.057     0.092     0.200
    56.398     0.726     0.200
    57.491     2.205     0.200
    57.889     4.305     0.200
    58.430     1.889     0.200
    60.338     0.328     0.200
    60.338     0.542     0.200
    60.808     0.941     0.200
    61.018     2.258     0.200
    61.684     2.152     0.200
    62.584     1.965     0.200
    64.036     2.839     0.200
    67.225     1.339     0.200
    68.684     1.457     0.200
    69.356     0.901     0.200
    72.731    -0.220     0.200
    73.704     1.800     0.200
    73.615     2.700     0.200
    74.017     1.372     0.200
    74.463     1.718     0.200
    75.118     1.448     0.200
    75.379     1.046     0.200
    75.726     0.086     0.200
    76.009     3.091     0.200
    76.277    -0.532     0.200
    76.277    -0.836     0.200
    76.371     4.076     0.200
    76.820     0.764     0.200
    78.967    -0.080     0.200
    79.374     5.182     0.200
    79.712     0.781     0.200
    80.963     0.113     0.200
    81.253     0.870     0.200
    81.332     0.501     0.200
    81.724     1.050     0.200
    82.702    -0.161     0.200
    82.993    -0.474     0.200
    83.061     0.014     0.200
    83.664     0.537     0.200
    84.598     1.016     0.200
    84.605     1.392     0.200
    84.656     0.947     0.200
    87.365     0.757     0.200
    90.007     0.325     0.200
    90.743     2.075     0.200
    94.600    -0.656     0.200
    95.855     0.901     0.200
    97.658     1.317     0.200
    76.212     1.885     0.200
    29.805     2.462     0.200
    20.623    -0.127     0.200
    20.890     0.834     0.200
    20.997     2.145     0.200
    21.048     1.568     0.200
    21.296     4.343     0.200
    23.282     0.552     0.200
    23.304     2.494     0.200
    23.475     0.736     0.200
    24.530     3.629     0.200
    27.160     2.613     0.200
    27.684     0.889     0.200
    28.588     0.430     0.200
    28.673     0.922     0.200
    29.081     1.873     0.200
    29.527     1.812     0.200
    29.873     0.905     0.200
    30.781     0.794     0.200
    33.015     2.629     0.200
    34.257     3.762     0.200
    34.420     1.417     0.200
    34.924    -0.284     0.200
    35.487     2.511     0.200
    36.037     2.431     0.200
    38.075     0.835     0.200
    40.442     1.222     0.200
    41.255    -1.071     0.200
    41.707     1.949     0.200
    42.398     0.436     0.200
    44.713     0.771     0.200
    44.769     2.203     0.200
    45.225     3.267     0.200
    45.371     1.821     0.200
    46.172    -0.073     0.200
    47.445     2.814     0.200
    47.936     3.390     0.200
    49.520     1.651     0.200
    50.161     2.242     0.200
    17.064     2.506     0.200
    21.264     5.084     0.200
    21.725     4.876     0.200
    21.933     4.038     0.200
    22.332     4.419     0.200
    22.954     4.538     0.200
    23.450     2.648     0.200
    26.024     4.459     0.200
    26.147     4.975     0.200
    27.775     4.115     0.200
    28.618     1.831     0.200
    29.656     1.742     0.200
    29.660     1.711     0.200
    30.084     2.108     0.200
    31.173     0.336     0.200
    32.555     2.522     0.200
    34.272     2.036     0.200
    34.150     2.600     0.200
    34.929     3.332     0.200
    34.929     3.439     0.200
    34.985     3.416     0.200
    35.022     2.231     0.200
    35.390     2.997     0.200
    35.462     4.027     0.200
    35.462     3.871     0.200
    35.868     2.955     0.200
    36.232     1.707     0.200
    36.383     2.971     0.200
    37.132     3.852     0.200
    37.132     2.422     0.200
    37.167     2.555     0.200
    37.471     2.909     0.200
    37.461     3.052     0.200
    37.604     3.247     0.200
    37.604     3.119     0.200
    37.744     3.067     0.200
    37.820     2.631     0.200
    37.894     2.600     0.200
    37.906     2.598     0.200
    38.146     3.033     0.200
    38.401     2.803     0.200
    38.460     2.740     0.200
    38.470     3.297     0.200
    38.487     3.295     0.200
    38.522     2.879     0.200
    38.781     2.329     0.200
    39.675     2.359     0.200
    40.943     2.247     0.200
    40.943     1.846     0.200
    41.249     2.425     0.200
    41.249     2.194     0.200
    41.866     2.668     0.200
    42.386     3.024     0.200
    17.064     3.046     0.200
    18.382     1.120     0.200
    19.258     3.233     0.200
    19.439     0.952     0.200
    21.709     0.029     0.200
    22.002     0.994     0.200
    22.325     4.052     0.200
    22.702     2.636     0.200
    23.295     1.268     0.200
    23.250     2.547     0.200
    23.285     4.273     0.200
    23.450     2.438     0.200
    27.785    -0.318     0.200
    28.437     2.461     0.200
    29.656     2.132     0.200
    29.874     1.403     0.200
    29.771     3.015     0.200
    30.084     2.249     0.200
    31.173     1.026     0.200
    32.958     0.651     0.200
    33.906     1.187     0.200
    33.906     0.872     0.200
    34.029     1.296     0.200
    35.022     1.894     0.200
    35.983     1.155     0.200
    36.075     2.245     0.200
    37.382     1.155     0.200
    37.404     1.826     0.200
    38.170     1.541     0.200
    39.331     2.126     0.200
    41.866     1.835     0.200
    41.999     1.928     0.200
    42.720     1.727     0.200
    43.847     2.599     0.200
    46.346     1.829     0.200
    46.475     1.314     0.200
    46.778     3.240     0.200
    47.580     0.381     0.200
    50.338     1.923     0.200
    53.907     1.757     0.200
    76.319    -0.060     0.200
    81.007     0.314     0.200
    81.269     0.923     0.200
    83.092    -0.338     0.200
    20.190     1.234     0.200
    20.581     2.085     0.200
    20.844     1.593     0.200
    20.970     2.760     0.200
    21.008     2.707     0.200
    21.264     3.033     0.200
    21.600     1.174     0.200
    23.295     0.087     0.200
    23.275     2.706     0.200
    23.450     1.129     0.200
    24.552     0.357     0.200
    28.618     0.381     0.200
    30.813    -0.983     0.200
    31.173    -0.204     0.200
    32.978     1.209     0.200
    33.301    -0.926     0.200
    33.906     0.467     0.200
    35.377     1.747     0.200
    35.462     3.348     0.200
    38.065     1.641     0.200
    38.198     0.392     0.200
    39.068    -0.048     0.200
    39.198     1.585     0.200
    39.675     1.979     0.200
    39.810     0.860     0.200
    41.681     1.751     0.200
    41.999     1.693     0.200
    42.043     2.052     0.200
    42.408    -0.109     0.200
    43.099     0.998     0.200
    43.353     2.637     0.200
    43.847     1.680     0.200
    44.052     2.061     0.200
    44.817     2.485     0.200
    45.272     2.692     0.200
    45.348     2.700     0.200
    46.297     1.541     0.200
    46.346    -0.221     0.200
    50.338     0.283     0.200
    50.459     1.400     0.200
    53.907     0.938     0.200
    57.447     1.523     0.200
    58.402     1.352     0.200
    60.379     0.679     0.200
    60.831     0.418     0.200
    62.708     1.057     0.200
    63.981     2.377     0.200
    67.251     1.293     0.200
    70.390     0.749     0.200
    70.509    -0.158     0.200
    71.261     0.039     0.200
    71.571     0.085     0.200
    72.740    -0.074     0.200
    73.559     2.370     0.200
    74.038     0.813     0.200
    74.604     2.152     0.200
    76.319    -1.150     0.200
    17.000     2.086     0.200
    28.581     1.143     0.200
    29.619     1.927     0.200
    30.005     2.185     0.200
    32.518     1.461     0.200
    33.923     1.182     0.200
    35.014     3.031     0.200
    35.492     3.857     0.200
    36.413     2.654     0.200
    36.699     1.482     0.200
    37.770     2.834     0.200
    38.517     2.793     0.200
    39.047     0.684     0.200
    39.465     0.519     0.200
    39.467     3.411     0.200
    39.842     3.140     0.200
    41.080     2.429     0.200
    41.113     1.866     0.200
    41.765     1.895     0.200
    42.063     2.203     0.200
    42.227     2.639     0.200
    43.342     2.754     0.200
    43.392     3.156     0.200
    43.454     2.561     0.200
    43.487     2.191     0.200
    43.973    -0.110     0.200
    44.080     2.017     0.200
    44.866     1.748     0.200
    45.209     2.813     0.200
    45.235     0.806     0.200
    46.497     1.513     0.200
    47.804     1.695     0.200
    49.061     2.422     0.200
    56.386     0.837     0.200
    61.459     2.007     0.200
    64.059     3.028     0.200
    75.112     0.406     0.200
    76.256    -0.505     0.200
    80.941    -0.318     0.200
    87.363     0.190     0.200
    15.332     3.542     0.200
    18.336     1.124     0.200
    19.365     0.503     0.200
    21.304     4.231     0.200
    21.642     0.097     0.200
    21.937     0.133     0.200
    22.357     3.751     0.200
    23.270     0.680     0.200
    23.280     2.374     0.200
    25.306     1.492     0.200
    27.309     2.387     0.200
    28.359     2.396     0.200
    29.813     2.282     0.200
    30.005     2.586     0.200
    33.923     0.682     0.200
    35.926     0.586     0.200
    42.720     0.824     0.200
    44.357     0.428     0.200
    76.256     0.036     0.200
    81.239     0.221     0.200
    83.043    -0.541     0.200
    17.000     2.515     0.200
    21.003     2.550     0.200
    23.270     1.149     0.200
    28.581     0.893     0.200
    33.923     0.042     0.200
    34.916     0.480     0.200
    42.387     0.735     0.200
    43.392    -0.014     0.200
    44.866     1.129     0.200
    48.387    -0.263     0.200
    70.717    -2.136     0.200
    71.927    -0.573     0.200
    72.711     0.111     0.200
    73.944    -0.452     0.200
    74.014     0.374     0.200
    74.733     0.647     0.200
    75.296    -0.042     0.200
    75.613     0.398     0.200
    75.707    -0.210     0.200
    76.450    -0.502     0.200
    77.030    -1.028     0.200
    77.882    -0.127     0.200
    81.248     0.175     0.200
    82.041     0.256     0.200
    92.364     0.592     0.200
    17.071     2.719     0.200
    19.439     1.112     0.200
    21.287     4.740     0.200
    21.714     0.139     0.200
    21.747     4.024     0.200
    21.956     3.505     0.200
    22.008     0.190     0.200
    22.348     3.968     0.200
    22.726     2.253     0.200
    22.978     3.787     0.200
    23.274     1.665     0.200
    23.309     4.390     0.200
    23.314    -0.065     0.200
    23.474     2.561     0.200
    23.474     2.366     0.200
    25.380     2.040     0.200
    25.477     4.505     0.200
    26.169     4.585     0.200
    27.383     2.542     0.200
    27.797     3.669     0.200
    27.805     0.666     0.200
    28.432     2.165     0.200
    28.595     1.424     0.200
    28.684     2.145     0.200
    28.767     2.189     0.200
    29.131     1.751     0.200
    29.131     2.962     0.200
    29.633     1.404     0.200
    29.633     1.693     0.200
    29.637     1.673     0.200
    29.851     1.374     0.200
    29.884     1.505     0.200
    29.794     2.577     0.200
    30.076     2.177     0.200
    30.076     2.279     0.200
    30.378     3.247     0.200
    30.543     2.340     0.200
    31.196     1.358     0.200
    31.196     0.893     0.200
    32.531     2.223     0.200
    33.450     2.393     0.200
    33.712     2.770     0.200
    33.929     0.649     0.200
    34.173     2.782     0.200
    34.420     1.878     0.200
    34.753     2.215     0.200
    34.953     3.379     0.200
    34.953     3.148     0.200
    34.997     2.999     0.200
    35.009     3.298     0.200
    35.045     2.409     0.200
    35.096     1.971     0.200
    35.178     2.514     0.200
    35.210     2.436     0.200
    35.237     2.837     0.200
    35.371     3.319     0.200
    35.414     3.012     0.200
    35.486     3.492     0.200
    35.486     3.308     0.200
    35.537     3.071     0.200
    35.679     0.231     0.200
    35.889     0.893     0.200
    35.891     2.889     0.200
    35.971     3.222     0.200
    35.993     0.933     0.200
    35.993     2.554     0.200
    36.099     2.353     0.200
    36.256     1.751     0.200
    36.406     3.180     0.200
    36.406     2.461     0.200
    36.631     3.152     0.200
    36.943     2.500     0.200
    37.016     2.506     0.200
    37.016     2.994     0.200
    37.156     3.418     0.200
    37.156     3.028     0.200
    37.406     2.731     0.200
    37.427     2.129     0.200
    37.494     3.106     0.200
    37.487     0.004     0.200
    37.628     3.812     0.200
    37.696     2.394     0.200
    37.715     2.335     0.200
    37.767     3.132     0.200
    37.843     3.085     0.200
    37.929     2.961     0.200
    38.169     2.656     0.200
    38.483     3.212     0.200
    38.493     3.030     0.200
    38.511     2.862     0.200
    38.545     3.050     0.200
    38.805     2.497     0.200
    38.886     0.299     0.200
    39.088     1.523     0.200
    39.327     1.822     0.200
    39.698     2.927     0.200
    39.698     2.739     0.200
    40.583     2.383     0.200
    40.967     2.018     0.200
    41.183     3.434     0.200
    41.273     2.298     0.200
    41.273     2.431     0.200
    41.273     1.802     0.200
    41.304     3.138     0.200
    41.705     2.853     0.200
    41.890     2.140     0.200
    41.890     2.616     0.200
    42.022     2.454     0.200
    42.022     1.556     0.200
    42.226     2.392     0.200
    42.410     2.397     0.200
    42.760     0.548     0.200
    42.824     2.628     0.200
    43.214     1.975     0.200
    43.394     2.916     0.200
    43.871     1.875     0.200
    44.379     0.160     0.200
    45.514    -0.005     0.200
    45.634    -0.292     0.200
    46.468     1.331     0.200
    46.369     0.818     0.200
    46.767     3.087     0.200
    46.951     0.988     0.200
    46.951     1.238     0.200
    47.402     1.932     0.200
    47.586     0.401     0.200
    49.235     0.806     0.200
    49.235     2.056     0.200
    50.355     1.456     0.200
    53.444     0.041     0.200
    53.444     0.690     0.200
    53.895     1.414     0.200
    54.125     2.227     0.200
    55.785     2.517     0.200
    56.108     0.999     0.200
    57.838     2.836     0.200
    76.326     0.260     0.200
    81.245     0.415     0.200
    83.105    -0.337     0.200
    17.996     0.391     0.200
    18.396     0.537     0.200
    20.211     0.360     0.200
    20.602     1.009     0.200
    20.865     0.683     0.200
    20.871     1.344     0.200
    20.994     2.440     0.200
    21.030     1.467     0.200
    21.287     3.470     0.200
    21.622     2.187     0.200
    21.714    -0.111     0.200
    22.470     2.055     0.200
    23.298     2.196     0.200
    23.314     0.635     0.200
    23.474    -0.005     0.200
    24.566     0.540     0.200
    24.520     2.628     0.200
    26.914     1.792     0.200
    26.914     2.073     0.200
    27.144     2.191     0.200
    27.608     1.920     0.200
    28.114     1.763     0.200
    28.595     1.104     0.200
    28.684     1.602     0.200
    28.767    -0.018     0.200
    29.131     1.583     0.200
    29.551     1.204     0.200
    29.638     2.134     0.200
    29.851     1.663     0.200
    29.794     1.940     0.200
    29.794     2.319     0.200
    29.884     1.326     0.200
    30.076     1.798     0.200
    30.440     3.107     0.200
    30.789     1.275     0.200
    31.196     0.503     0.200
    31.638     2.258     0.200
    32.237     1.662     0.200
    33.000     2.079     0.200
    33.929     0.629     0.200
    33.929     0.450     0.200
    34.420     1.179     0.200
    34.508     1.952     0.200
    34.934     0.991     0.200
    35.399     1.633     0.200
    35.486     2.749     0.200
    36.041     1.597     0.200
    35.993     0.745     0.200
    36.112     1.817     0.200
    38.576     0.894     0.200
    38.632     1.566     0.200
    39.088     0.835     0.200
    41.245    -0.165     0.200
    41.705     1.603     0.200
    42.428    -0.054     0.200
    43.377     2.068     0.200
    44.118     1.630     0.200
    44.743     2.987     0.200
    44.768     2.500     0.200
    44.755     1.957     0.200
    44.797     2.534     0.200
    45.159     3.166     0.200
    45.253     2.891     0.200
    45.329     2.961     0.200
    45.375     1.861     0.200
    45.604     0.726     0.200
    45.634    -1.070     0.200
    45.735     1.970     0.200
    45.735     1.970     0.200
    46.369    -0.206     0.200
    47.247     0.512     0.200
    47.395     1.403     0.200
    47.327     0.732     0.200
    47.327     0.743     0.200
    47.402     0.850     0.200
    47.586    -0.376     0.200
    47.724     2.029     0.200
    47.886     1.493     0.200
    49.520     1.747     0.200
    49.545     1.146     0.200
    50.163     1.928     0.200
    50.308    -0.958     0.200
    50.355     1.186     0.200
    51.497     2.949     0.200
    53.049     1.738     0.200
    53.397     1.221     0.200
    53.442     1.094     0.200
    53.473     0.296     0.200
    53.895     0.973     0.200
    54.125     1.278     0.200
    54.664     1.633     0.200
    54.768     1.041     0.200
    57.468     0.794     0.200
    58.426     0.961     0.200
    60.402     1.693     0.200
    60.847     0.488     0.200
    62.596     0.937     0.200
    62.727     0.615     0.200
    63.986     1.234     0.200
    66.646     1.154     0.200
    67.904    -0.149     0.200
    68.696     1.427     0.200
    70.367     1.332     0.200
    71.267    -0.110     0.200
    71.679     0.746     0.200
    71.580     0.058     0.200
    72.686    -1.231     0.200
    72.867     1.774     0.200
    72.780    -0.217     0.200
    72.825     0.336     0.200
    73.128     0.938     0.200
    73.034     0.455     0.200
    73.086    -0.881     0.200
    73.199    -0.394     0.200
    73.398     1.452     0.200
    73.566     1.175     0.200
    73.931     0.284     0.200
    74.012    -0.431     0.200
    74.340     0.726     0.200
    74.464     1.093     0.200
    74.609     1.634     0.200
    74.661    -0.308     0.200
    75.686     0.174     0.200
    76.161     1.000     0.200
    76.322     2.256     0.200
    76.326    -0.479     0.200
    76.494     0.051     0.200
    76.632    -1.280     0.200
    76.772    -0.903     0.200
    77.714    -0.842     0.200
    78.168    -0.757     0.200
    79.055    -0.756     0.200
    79.558    -0.240     0.200
    80.041    -0.394     0.200
    80.553     0.049     0.200
    81.013    -0.360     0.200
    81.061     0.034     0.200
    81.254     0.228     0.200
    82.110     0.509     0.200
    84.704     0.360     0.200
    89.008     0.041     0.200
    92.426     0.246     0.200
    96.932    -0.664     0.200
    17.059     2.501     0.200
    21.286     5.181     0.200
    21.957     4.050     0.200
    22.976     4.373     0.200
    24.573    -0.005     0.200
    33.925    -0.231     0.200
    33.925     0.602     0.200
    34.005     3.051     0.200
    34.054     3.042     0.200
    34.049     1.007     0.200
    34.751     1.983     0.200
    34.995     2.683     0.200
    35.004     3.730     0.200
    35.006     3.523     0.200
    35.043     2.058     0.200
    35.369     3.698     0.200
    35.411     3.070     0.200
    35.483     3.749     0.200
    35.483     4.214     0.200
    35.889     3.331     0.200
    35.969     3.133     0.200
    36.096     2.765     0.200
    37.013     2.710     0.200
    37.013     2.445     0.200
    37.403     3.538     0.200
    37.425     1.879     0.200
    37.482     2.565     0.200
    37.625     2.718     0.200
    37.765     3.335     0.200
    37.765     3.090     0.200
    37.841     2.927     0.200
    37.914     2.531     0.200
    38.083     1.332     0.200
    38.167     3.234     0.200
    38.491     2.755     0.200
    38.509     2.580     0.200
    38.878     0.321     0.200
    39.466     3.819     0.200
    39.695     2.653     0.200
    40.964     2.263     0.200
    41.269     2.383     0.200
    41.379     2.603     0.200
    41.441     2.240     0.200
    41.507     2.735     0.200
    41.917     2.761     0.200
    42.063     2.730     0.200
    42.227     2.792     0.200
    42.751     0.868     0.200
    43.376     3.427     0.200
    43.452     2.599     0.200
    43.577     1.721     0.200
    44.372     0.226     0.200
    44.372     0.976     0.200
    44.859    -0.636     0.200
    45.239     1.267     0.200
    46.942     0.816     0.200
    47.257     1.331     0.200
    20.992     2.546     0.200
    21.286     2.661     0.200
    21.703     0.919     0.200
    21.703     0.599     0.200
    23.297     0.714     0.200
    23.305     1.087     0.200
    23.472     1.275     0.200
    24.573     0.885     0.200
    28.596     1.777     0.200
    33.001     1.827     0.200
    35.483     2.804     0.200
    35.982     0.717     0.200
    36.109     1.187     0.200
    38.083     0.472     0.200
    39.079     0.342     0.200
    43.376     1.447     0.200
    44.074     0.533     0.200
    44.164     0.573     0.200
    44.859     0.904     0.200
    46.965     1.066     0.200
    47.257    -0.059     0.200
    48.381     1.126     0.200
    53.047     1.177     0.200
    54.660     0.370     0.200
    63.996     1.748     0.200
    71.255    -0.207     0.200
    71.568    -0.448     0.200
    71.919    -0.378     0.200
    71.986    -0.221     0.200
    72.379     0.769     0.200
    72.878     2.188     0.200
    73.139     1.339     0.200
    73.023    -0.092     0.200
    73.409     2.025     0.200
    74.005    -0.688     0.200
    74.790     0.784     0.200
    75.355    -0.317     0.200
    75.762     0.003     0.200
    76.225    -0.631     0.200
    76.509    -0.382     0.200
    76.522    -0.705     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   110.744     3.670     0.200
    99.890     2.407     0.200
   102.978     2.078     0.200
   110.739     0.874     0.200
   113.594     0.218     0.200
   100.052     0.829     0.200
   102.910     0.191     0.200
   106.759     1.798     0.200
    99.659     1.269     0.200
    99.659     0.863     0.200
   100.031     0.809     0.200
   100.040     2.769     0.200
   100.040     2.316     0.200
   101.084     0.574     0.200
   101.084     0.332     0.200
   101.951     1.024     0.200
   102.179     1.690     0.200
   102.179     1.846     0.200
   102.739     1.879     0.200
   105.413     0.649     0.200
   109.121     1.931     0.200
   119.487    -2.679     0.200
    99.676     0.836     0.200
   100.084     0.662     0.200
   101.123     0.497     0.200
   102.007     0.929     0.200
   102.124     1.908     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    16.007   298.304     0.200
    16.486   290.170     0.200
    43.548   106.682     0.200
    30.488   180.599     0.200
    33.300   162.898     0.200
    45.096   101.378     0.200
    53.510    68.052     0.200
    54.707    63.323     0.200
    61.381    44.547     0.200
    98.908     1.575     0.200
    30.891   175.820     0.200
    36.232   143.346     0.200
    36.416   143.772     0.200
    37.754   138.200     0.200
    39.252   129.612     0.200
    40.183   125.066     0.200
    40.184   125.050     0.200
    41.989   116.201     0.200
    43.342   110.012     0.200
    44.075   106.313     0.200
    44.075   106.114     0.200
    44.970   102.159     0.200
    45.334    99.267     0.200
    47.019    93.200     0.200
    47.668    90.951     0.200
    48.568    86.992     0.200
    49.496    83.779     0.200
    29.864   183.194     0.200
    31.095   176.915     0.200
    31.661   171.437     0.200
    33.813   158.105     0.200
    39.554   129.204     0.200
    41.948   120.945     0.200
    42.384   112.892     0.200
    42.906   112.649     0.200
    43.145   106.714     0.200
    43.300   109.464     0.200
    43.420   111.499     0.200
    43.731   105.991     0.200
    43.926   109.424     0.200
    44.036   109.537     0.200
    44.931   103.385     0.200
    46.365    94.045     0.200
    46.981    95.226     0.200
    47.647    92.038     0.200
    47.683    92.756     0.200
    47.856    94.418     0.200
    48.530    90.212     0.200
    56.018    57.593     0.200
    56.239    57.118     0.200
    62.213    41.670     0.200
    65.656    31.024     0.200
    43.416   109.564     0.200
    65.618    33.539     0.200
    21.323   246.338     0.200
    41.802   118.705     0.200
    43.296   109.560     0.200
    43.442   109.380     0.200
    43.726   106.094     0.200
    44.926   104.490     0.200
    23.747   225.267     0.200
    28.532   191.638     0.200
    29.801   185.477     0.200
    30.165   182.453     0.200
    35.888   148.709     0.200
    36.326   145.858     0.200
    37.120   140.897     0.200
    38.697   132.375     0.200
    43.878   108.005     0.200
    45.792    98.559     0.200
    45.815    98.871     0.200
    46.681    95.661     0.200
    53.960    65.950     0.200
    43.583   107.768     0.200
    46.017    97.302     0.200
    43.907   107.106     0.200
    45.578    99.892     0.200
    97.420     0.778     0.200
    22.542   236.079     0.200
    28.414   193.837     0.200
    31.555   173.239     0.200
    43.857   110.144     0.200
    44.057   105.224     0.200
    45.892    95.742     0.200
    46.794    94.043     0.200
    46.845    93.650     0.200
    58.286    52.600     0.200
    29.831   184.202     0.200
    43.780   108.468     0.200
    16.196   296.734     0.200
    23.816   224.996     0.200
    43.848   107.485     0.200
    45.118    99.958     0.200
    46.598    95.430     0.200
    53.518    67.846     0.200
    16.745   289.409     0.200
    27.108   201.427     0.200
    28.562   195.032     0.200
    28.767   192.592     0.200
    29.139   189.503     0.200
    29.442   187.467     0.200
    29.442   187.818     0.200
    30.091   182.866     0.200
    30.411   179.840     0.200
    32.435   169.820     0.200
    33.380   164.847     0.200
    37.946   136.353     0.200
    38.969   131.609     0.200
    38.969   132.041     0.200
    43.325   109.203     0.200
    43.634   106.070     0.200
    44.041   110.146     0.200
    44.164   105.954     0.200
    44.402   105.864     0.200
    46.268    96.748     0.200
    46.410    95.982     0.200
    48.161    86.890     0.200
    49.433    81.620     0.200
    49.743    81.613     0.200
    61.028    42.560     0.200
    28.555   194.421     0.200
    28.778   192.569     0.200
    29.154   184.398     0.200
    29.460   186.028     0.200
    29.460   186.043     0.200
    30.797   178.177     0.200
    32.425   169.534     0.200
    33.385   162.136     0.200
    38.999   131.375     0.200
    43.471   110.370     0.200
    43.658   107.258     0.200
    43.730   106.180     0.200
    44.066   106.771     0.200
    49.445    82.255     0.200
    61.052    45.825     0.200
    29.429   186.735     0.200
    30.403   180.511     0.200
    31.009   175.562     0.200
    32.465   169.560     0.200
    38.994   131.340     0.200
    43.009   112.060     0.200
    43.637   106.191     0.200
    29.076   188.234     0.200
    29.647   186.237     0.200
    32.105   172.362     0.200
    33.847   159.073     0.200
    38.054   137.003     0.200
    38.760   129.967     0.200
    39.909   123.778     0.200
    40.311   122.738     0.200
    43.340   109.020     0.200
    43.495   108.083     0.200
    43.708   108.009     0.200
    45.952    97.212     0.200
    45.952    97.207     0.200
    48.938    82.803     0.200
    43.723   107.530     0.200
    43.622   109.276     0.200
    31.111   174.712     0.200
    65.451    30.320     0.200
    31.263   177.270     0.200
    43.744   107.859     0.200
    44.114   105.161     0.200
    43.608   106.358     0.200
    29.320   188.529     0.200
    29.553   185.346     0.200
    29.553   185.214     0.200
    29.809   184.022     0.200
    29.809   183.889     0.200
    30.959   174.332     0.200
    36.812   142.223     0.200
    38.547   133.067     0.200
    39.231   129.403     0.200
    43.030   111.796     0.200
    43.306   106.418     0.200
    43.431   107.106     0.200
    43.583   107.050     0.200
    43.830   105.847     0.200
    43.948   106.391     0.200
    44.620   103.227     0.200
    45.653    98.334     0.200
    45.634    99.406     0.200
    45.691    98.916     0.200
    45.906    97.379     0.200
    45.983    97.520     0.200
    54.041    63.462     0.200
    29.553   184.927     0.200
    29.802   184.493     0.200
    36.842   141.686     0.200
    39.302   128.393     0.200
    37.160   140.188     0.200
    44.599   102.777     0.200
    45.962    97.415     0.200
EOF
# Indirect calibration
gmt text $proj $reg -F+f10p,Helvetica-Bold,black+a0.+jBL << EOF
    12.000    -7.500 Indirect calibration: shifted hypocenters used
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
