#!/bin/bash
gmt begin kunar4.14_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times kunar4.14'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.015
    25.500   327.558
    26.000   332.090
    26.500   336.610
    27.000   341.117
    27.500   345.608
    28.000   350.079
    28.500   354.534
    29.000   358.979
    29.500   363.415
    30.000   367.843
    30.500   372.264
    31.000   376.677
    31.500   381.082
    32.000   385.478
    32.500   389.866
    33.000   394.242
    33.500   398.606
    34.000   402.956
    34.500   407.290
    35.000   411.610
    35.500   415.915
    36.000   420.204
    36.500   424.478
    37.000   428.737
    37.500   432.980
    38.000   437.207
    38.500   441.418
    39.000   445.613
    39.500   449.791
    40.000   453.951
    40.500   458.094
    41.000   462.221
    41.500   466.330
    42.000   470.423
    42.500   474.498
    43.000   478.555
    43.500   482.595
    44.000   486.618
    44.500   490.622
    45.000   494.609
    45.500   498.578
    46.000   502.529
    46.500   506.461
    47.000   510.376
    47.500   514.273
    48.000   518.151
    48.500   522.012
    49.000   525.854
    49.500   529.678
    50.000   533.484
    50.500   537.271
    51.000   541.040
    51.500   544.791
    52.000   548.524
    52.500   552.239
    53.000   555.936
    53.500   559.616
    54.000   563.277
    54.500   566.920
    55.000   570.545
    55.500   574.151
    56.000   577.738
    56.500   581.307
    57.000   584.858
    57.500   588.391
    58.000   591.905
    58.500   595.402
    59.000   598.880
    59.500   602.340
    60.000   605.782
    60.500   609.205
    61.000   612.610
    61.500   615.996
    62.000   619.365
    62.500   622.715
    63.000   626.047
    63.500   629.361
    64.000   632.658
    64.500   635.937
    65.000   639.197
    65.500   642.440
    66.000   645.665
    66.500   648.871
    67.000   652.060
    67.500   655.230
    68.000   658.383
    68.500   661.517
    69.000   664.633
    69.500   667.730
    70.000   670.810
    70.500   673.872
    71.000   676.915
    71.500   679.940
    72.000   682.948
    72.500   685.936
    73.000   688.907
    73.500   691.859
    74.000   694.792
    74.500   697.707
    75.000   700.602
    75.500   703.480
    76.000   706.339
    76.500   709.180
    77.000   712.002
    77.500   714.807
    78.000   717.593
    78.500   720.362
    79.000   723.112
    79.500   725.844
    80.000   728.557
    80.500   731.251
    81.000   733.926
    81.500   736.581
    82.000   739.218
    82.500   741.836
    83.000   744.434
    83.500   747.015
    84.000   749.575
    84.500   752.115
    85.000   754.635
    85.500   757.135
    86.000   759.616
    86.500   762.080
    87.000   764.526
    87.500   766.948
    88.000   769.336
    88.500   771.702
    89.000   774.056
    89.500   776.402
    90.000   778.740
    90.500   781.070
    91.000   783.395
    91.500   785.714
    92.000   788.029
    92.500   790.340
    93.000   792.647
    93.500   794.951
    94.000   797.251
    94.500   799.546
    95.000   801.836
    95.500   804.120
    96.000   806.398
    96.500   808.670
    97.000   810.935
    97.500   813.193
    98.000   815.445
    98.500   817.689
    99.000   819.925
    99.500   822.154
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.148
   116.000  1122.110
   116.500  1123.072
   117.000  1124.034
   117.500  1124.996
   118.000  1125.958
   118.500  1126.920
   119.000  1127.881
   119.500  1128.843
   120.000  1129.804
   120.500  1130.765
   121.000  1131.726
   121.500  1132.686
   122.000  1133.647
   122.500  1134.607
   123.000  1135.566
   123.500  1136.525
   124.000  1137.484
   124.500  1138.442
   125.000  1139.400
   125.500  1140.357
   126.000  1141.313
   126.500  1142.269
   127.000  1143.224
   127.500  1144.179
   128.000  1145.132
   128.500  1146.085
   129.000  1147.037
   129.500  1147.988
   130.000  1148.938
   130.500  1149.887
   131.000  1150.834
   131.500  1151.781
   132.000  1152.726
   132.500  1153.669
   133.000  1154.611
   133.500  1155.552
   134.000  1156.491
   134.500  1157.428
   135.000  1158.363
   135.500  1159.296
   136.000  1160.227
   136.500  1161.156
   137.000  1162.083
   137.500  1163.007
   138.000  1163.928
   138.500  1164.846
   139.000  1165.762
   139.500  1166.675
   140.000  1167.584
   140.500  1168.490
   141.000  1169.393
   141.500  1170.292
   142.000  1171.186
   142.500  1172.077
   143.000  1172.963
   143.500  1173.844
   144.000  1174.720
   144.500  1175.591
   145.000  1176.457
   145.500  1177.317
   146.000  1178.170
   146.500  1179.018
   147.000  1179.859
   147.500  1180.693
   148.000  1181.520
   148.500  1182.340
   149.000  1183.151
   149.500  1183.953
   150.000  1184.747
   150.500  1185.530
   151.000  1186.303
   151.500  1187.067
   152.000  1187.820
   152.500  1188.563
   153.000  1189.297
   153.500  1190.020
   154.000  1190.732
   154.500  1191.433
   155.000  1192.124
   155.500  1192.802
   156.000  1193.470
   156.500  1194.125
   157.000  1194.769
   157.500  1195.400
   158.000  1196.019
   158.500  1196.626
   159.000  1197.220
   159.500  1197.801
   160.000  1198.370
   160.500  1198.925
   161.000  1199.467
   161.500  1199.997
   162.000  1200.513
   162.500  1201.016
   163.000  1201.505
   163.500  1201.981
   164.000  1202.443
   164.500  1202.892
   165.000  1203.326
   165.500  1203.747
   166.000  1204.154
   166.500  1204.547
   167.000  1204.926
   167.500  1205.291
   168.000  1205.642
   168.500  1205.979
   169.000  1206.302
   169.500  1206.610
   170.000  1206.905
   170.500  1207.185
   171.000  1207.451
   171.500  1207.703
   172.000  1207.940
   172.500  1208.164
   173.000  1208.373
   173.500  1208.567
   174.000  1208.747
   174.500  1208.913
   175.000  1209.065
   175.500  1209.202
   176.000  1209.324
   176.500  1209.432
   177.000  1209.526
   177.500  1209.606
   178.000  1209.671
   178.500  1209.721
   179.000  1209.757
   179.500  1209.779
   180.000  1209.786
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.085
     1.000   992.093
     1.500   992.107
     2.000   992.127
     2.500   992.152
     3.000   992.183
     3.500   992.219
     4.000   992.261
     4.500   992.309
     5.000   992.362
     5.500   992.421
     6.000   992.485
     6.500   992.555
     7.000   992.630
     7.500   992.711
     8.000   992.798
     8.500   992.890
     9.000   992.988
     9.500   993.091
    10.000   993.200
    10.500   993.315
    11.000   993.435
    11.500   993.560
    12.000   993.691
    12.500   993.828
    13.000   993.970
    13.500   994.118
    14.000   994.271
    14.500   994.430
    15.000   994.594
    15.500   994.764
    16.000   994.939
    16.500   995.120
    17.000   995.306
    17.500   995.498
    18.000   995.695
    18.500   995.898
    19.000   996.106
    19.500   996.320
    20.000   996.539
    20.500   996.763
    21.000   996.993
    21.500   997.229
    22.000   997.469
    22.500   997.716
    23.000   997.967
    23.500   998.224
    24.000   998.487
    24.500   998.754
    25.000   999.028
    25.500   999.306
    26.000   999.590
    26.500   999.879
    27.000  1000.173
    27.500  1000.473
    28.000  1000.778
    28.500  1001.089
    29.000  1001.405
    29.500  1001.726
    30.000  1002.052
    30.500  1002.383
    31.000  1002.720
    31.500  1003.062
    32.000  1003.409
    32.500  1003.762
    33.000  1004.119
    33.500  1004.482
    34.000  1004.850
    34.500  1005.223
    35.000  1005.601
    35.500  1005.985
    36.000  1006.373
    36.500  1006.767
    37.000  1007.166
    37.500  1007.569
    38.000  1007.978
    38.500  1008.392
    39.000  1008.811
    39.500  1009.235
    40.000  1009.664
    40.500  1010.098
    41.000  1010.537
    41.500  1010.981
    42.000  1011.430
    42.500  1011.884
    43.000  1012.343
    43.500  1012.807
    44.000  1013.275
    44.500  1013.749
    45.000  1014.227
    45.500  1014.710
    46.000  1015.198
    46.500  1015.691
    47.000  1016.189
    47.500  1016.691
    48.000  1017.198
    48.500  1017.710
    49.000  1018.227
    49.500  1018.748
    50.000  1019.274
    50.500  1019.805
    51.000  1020.341
    51.500  1020.881
    52.000  1021.425
    52.500  1021.975
    53.000  1022.529
    53.500  1023.087
    54.000  1023.650
    54.500  1024.218
    55.000  1024.790
    55.500  1025.367
    56.000  1025.948
    56.500  1026.534
    57.000  1027.124
    57.500  1027.718
    58.000  1028.317
    58.500  1028.921
    59.000  1029.528
    59.500  1030.141
    60.000  1030.757
    60.500  1031.378
    61.000  1032.003
    61.500  1032.632
    62.000  1033.266
    62.500  1033.904
    63.000  1034.546
    63.500  1035.192
    64.000  1035.842
    64.500  1036.497
    65.000  1037.156
    65.500  1037.818
    66.000  1038.485
    66.500  1039.157
    67.000  1039.832
    67.500  1040.511
    68.000  1041.194
    68.500  1041.881
    69.000  1042.572
    69.500  1043.268
    70.000  1043.967
    70.500  1044.670
    71.000  1045.376
    71.500  1046.087
    72.000  1046.802
    72.500  1047.520
    73.000  1048.243
    73.500  1048.969
    74.000  1049.698
    74.500  1050.432
    75.000  1051.169
    75.500  1051.910
    76.000  1052.655
    76.500  1053.403
    77.000  1054.155
    77.500  1054.911
    78.000  1055.670
    78.500  1056.432
    79.000  1057.198
    79.500  1057.968
    80.000  1058.742
    80.500  1059.518
    81.000  1060.299
    81.500  1061.082
    82.000  1061.869
    82.500  1062.660
    83.000  1063.453
    83.500  1064.251
    84.000  1065.051
    84.500  1065.855
    85.000  1066.662
    85.500  1067.472
    86.000  1068.286
    86.500  1069.102
    87.000  1069.922
    87.500  1070.745
    88.000  1071.572
    88.500  1072.401
    89.000  1073.233
    89.500  1074.069
    90.000  1074.907
    90.500  1075.749
    91.000  1076.593
    91.500  1077.441
    92.000  1078.291
    92.500  1079.145
    93.000  1080.001
    93.500  1080.860
    94.000  1081.722
    94.500  1082.587
    95.000  1083.454
    95.500  1084.325
    96.000  1085.198
    96.500  1086.074
    97.000  1086.953
    97.500  1087.834
    98.000  1088.718
    98.500  1089.604
    99.000  1090.494
    99.500  1091.385
   100.000  1092.280
   100.500  1093.177
   101.000  1094.076
   101.500  1094.978
   102.000  1095.882
   102.500  1096.789
   103.000  1097.699
   103.500  1098.610
   104.000  1099.524
   104.500  1100.441
   105.000  1101.359
   105.500  1102.281
   106.000  1103.204
   106.500  1104.129
   107.000  1105.057
   107.500  1105.987
   108.000  1106.919
   108.500  1107.854
   109.000  1108.790
   109.500  1109.729
   110.000  1110.670
   110.500  1111.612
   111.000  1112.557
   111.500  1113.504
   112.000  1114.453
   112.500  1115.403
   113.000  1116.356
   113.500  1117.311
   114.000  1118.267
   114.500  1119.226
   115.000  1120.186
   115.500  1121.148
   116.000  1122.112
   116.500  1123.077
   117.000  1124.045
   117.500  1125.014
   118.000  1125.984
   118.500  1126.957
   119.000  1127.931
   119.500  1128.907
   120.000  1129.884
   120.500  1130.863
   121.000  1131.844
   121.500  1132.826
   122.000  1133.809
   122.500  1134.794
   123.000  1135.781
   123.500  1136.769
   124.000  1137.758
   124.500  1138.749
   125.000  1139.741
   125.500  1140.734
   126.000  1141.729
   126.500  1142.725
   127.000  1143.722
   127.500  1144.721
   128.000  1145.721
   128.500  1146.722
   129.000  1147.724
   129.500  1148.727
   130.000  1149.732
   130.500  1150.737
   131.000  1151.744
   131.500  1152.752
   132.000  1153.760
   132.500  1154.770
   133.000  1155.781
   133.500  1156.793
   134.000  1157.806
   134.500  1158.819
   135.000  1159.834
   135.500  1160.849
   136.000  1161.865
   136.500  1162.883
   137.000  1163.901
   137.500  1164.919
   138.000  1165.939
   138.500  1166.959
   139.000  1167.980
   139.500  1169.002
   140.000  1170.024
   140.500  1171.047
   141.000  1172.070
   141.500  1173.095
   142.000  1174.120
   142.500  1175.145
   143.000  1176.171
   143.500  1177.197
   144.000  1178.224
   144.500  1179.252
   145.000  1180.279
   145.500  1181.308
   146.000  1182.336
   146.500  1183.366
   147.000  1184.395
   147.500  1185.425
   148.000  1186.455
   148.500  1187.486
   149.000  1188.516
   149.500  1189.547
   150.000  1190.579
   150.500  1191.610
   151.000  1192.642
   151.500  1193.674
   152.000  1194.706
   152.500  1195.738
   153.000  1196.770
   153.500  1197.803
   154.000  1198.835
   154.500  1199.868
   155.000  1200.901
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.780
   145.500  1177.604
   146.000  1179.486
   146.500  1181.403
   147.000  1183.349
   147.500  1185.318
   148.000  1187.306
   148.500  1189.312
   149.000  1191.333
   149.500  1193.369
   150.000  1195.417
   150.500  1197.477
   151.000  1199.547
   151.500  1201.627
   152.000  1203.715
   152.500  1205.812
   153.000  1207.917
   153.500  1210.030
   154.000  1212.149
   154.500  1214.275
   155.000  1216.407
   155.500  1218.544
   156.000  1220.687
   156.500  1222.835
   157.000  1224.987
   157.500  1227.144
   158.000  1229.306
   158.500  1231.471
   159.000  1233.640
   159.500  1235.813
   160.000  1237.990
   160.500  1240.169
   161.000  1242.352
   161.500  1244.537
   162.000  1246.726
   162.500  1248.916
   163.000  1251.110
   163.500  1253.305
   164.000  1255.503
   164.500  1257.702
   165.000  1259.904
   165.500  1262.107
   166.000  1264.312
   166.500  1266.519
   167.000  1268.727
   167.500  1270.937
   168.000  1273.148
   168.500  1275.360
   169.000  1277.574
   169.500  1279.788
   170.000  1282.004
   170.500  1284.220
   171.000  1286.437
   171.500  1288.655
   172.000  1290.874
   172.500  1293.094
   173.000  1295.313
   173.500  1297.534
   174.000  1299.755
   174.500  1301.976
   175.000  1304.198
   175.500  1306.420
   176.000  1308.643
   176.500  1310.865
   177.000  1313.088
   177.500  1315.311
   178.000  1317.533
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.776
   145.500  1177.400
   146.000  1178.946
   146.500  1180.435
   147.000  1181.874
   147.500  1183.268
   148.000  1184.620
   148.500  1185.931
   149.000  1187.208
   149.500  1188.456
   150.000  1189.679
   150.500  1190.880
   151.000  1192.059
   151.500  1193.220
   152.000  1194.362
   152.500  1195.486
   153.000  1196.595
   153.500  1197.689
   154.000  1198.770
   154.500  1199.838
   155.000  1200.893
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   508.960
     1.000   508.996
     1.500   509.056
     2.000   509.140
     2.500   509.248
     3.000   509.380
     3.500   509.536
     4.000   509.716
     4.500   509.920
     5.000   510.148
     5.500   510.399
     6.000   510.674
     6.500   510.973
     7.000   511.295
     7.500   511.641
     8.000   512.011
     8.500   512.404
     9.000   512.820
     9.500   513.259
    10.000   513.722
    10.500   514.208
    11.000   514.717
    11.500   515.249
    12.000   515.803
    12.500   516.381
    13.000   516.981
    13.500   517.603
    14.000   518.248
    14.500   518.915
    15.000   519.604
    15.500   520.316
    16.000   521.049
    16.500   521.804
    17.000   522.580
    17.500   523.378
    18.000   524.198
    18.500   525.039
    19.000   525.900
    19.500   526.783
    20.000   527.686
    20.500   528.610
    21.000   529.555
    21.500   530.520
    22.000   531.505
    22.500   532.510
    23.000   533.534
    23.500   534.579
    24.000   535.643
    24.500   536.726
    25.000   537.828
    25.500   538.950
    26.000   540.090
    26.500   541.248
    27.000   542.426
    27.500   543.621
    28.000   544.835
    28.500   546.066
    29.000   547.315
    29.500   548.582
    30.000   549.866
    30.500   551.168
    31.000   552.486
    31.500   553.821
    32.000   555.173
    32.500   556.541
    33.000   557.925
    33.500   559.326
    34.000   560.742
    34.500   562.174
    35.000   563.622
    35.500   565.085
    36.000   566.563
    36.500   568.056
    37.000   569.564
    37.500   571.086
    38.000   572.623
    38.500   574.174
    39.000   575.739
    39.500   577.317
    40.000   578.910
    40.500   580.516
    41.000   582.135
    41.500   583.767
    42.000   585.412
    42.500   587.070
    43.000   588.741
    43.500   590.424
    44.000   592.119
    44.500   593.826
    45.000   595.545
    45.500   597.275
    46.000   599.017
    46.500   600.771
    47.000   602.535
    47.500   604.311
    48.000   606.097
    48.500   607.894
    49.000   609.701
    49.500   611.519
    50.000   613.346
    50.500   615.184
    51.000   617.032
    51.500   618.889
    52.000   620.755
    52.500   622.631
    53.000   624.516
    53.500   626.410
    54.000   628.313
    54.500   630.225
    55.000   632.145
    55.500   634.073
    56.000   636.010
    56.500   637.954
    57.000   639.907
    57.500   641.867
    58.000   643.835
    58.500   645.811
    59.000   647.794
    59.500   649.784
    60.000   651.781
    60.500   653.784
    61.000   655.795
    61.500   657.812
    62.000   659.836
    62.500   661.866
    63.000   663.903
    63.500   665.945
    64.000   667.994
    64.500   670.048
    65.000   672.108
    65.500   674.174
    66.000   676.245
    66.500   678.321
    67.000   680.403
    67.500   682.489
    68.000   684.581
    68.500   686.677
    69.000   688.779
    69.500   690.885
    70.000   692.995
    70.500   695.110
    71.000   697.229
    71.500   699.352
    72.000   701.479
    72.500   703.611
    73.000   705.746
    73.500   707.885
    74.000   710.027
    74.500   712.174
    75.000   714.323
    75.500   716.476
    76.000   718.632
    76.500   720.792
    77.000   722.954
    77.500   725.120
    78.000   727.288
    78.500   729.459
    79.000   731.633
    79.500   733.809
    80.000   735.988
    80.500   738.169
    81.000   740.353
    81.500   742.539
    82.000   744.728
    82.500   746.918
    83.000   749.110
    83.500   751.305
    84.000   753.501
    84.500   755.699
    85.000   757.899
    85.500   760.100
    86.000   762.303
    86.500   764.508
    87.000   766.714
    87.500   768.921
    88.000   771.130
    88.500   773.340
    89.000   775.551
    89.500   777.763
    90.000   779.976
    90.500   782.190
    91.000   784.406
    91.500   786.622
    92.000   788.839
    92.500   791.056
    93.000   793.275
    93.500   795.494
    94.000   797.713
    94.500   799.933
    95.000   802.154
    95.500   804.375
    96.000   806.597
    96.500   808.818
    97.000   811.041
    97.500   813.263
    98.000   815.485
    98.500   817.708
    99.000   819.931
    99.500   822.154
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   418.912
    29.000   424.470
    29.500   430.026
    30.000   435.583
    30.500   441.137
    31.000   446.691
    31.500   452.243
    32.000   457.792
    32.500   463.339
    33.000   468.884
    33.500   474.425
    34.000   479.962
    34.500   485.495
    35.000   491.023
    35.500   496.547
    36.000   502.064
    36.500   507.576
    37.000   513.081
    37.500   518.579
    38.000   524.069
    38.500   529.551
    39.000   535.024
    39.500   540.487
    40.000   545.940
    40.500   551.383
    41.000   556.815
    41.500   562.235
    42.000   567.642
    42.500   573.037
    43.000   578.418
    43.500   583.785
    44.000   589.138
    44.500   594.476
    45.000   599.799
    45.500   605.106
    46.000   610.397
    46.500   615.671
    47.000   620.928
    47.500   625.638
    48.000   630.208
    48.500   634.774
    49.000   639.335
    49.500   643.892
    50.000   648.443
    50.500   652.989
    51.000   657.530
    51.500   662.065
    52.000   666.595
    52.500   671.119
    53.000   675.637
    53.500   680.148
    54.000   684.653
    54.500   689.150
    55.000   693.638
    55.500   698.116
    56.000   702.583
    56.500   707.042
    57.000   711.496
    57.500   715.944
    58.000   720.387
    58.500   724.826
    59.000   729.260
    59.500   733.691
    60.000   738.117
    60.500   742.540
    61.000   746.959
    61.500   751.375
    62.000   755.786
    62.500   760.194
    63.000   764.597
    63.500   768.997
    64.000   773.392
    64.500   777.782
    65.000   782.168
    65.500   786.548
    66.000   790.923
    66.500   795.291
    67.000   799.652
    67.500   804.007
    68.000   808.354
    68.500   812.693
    69.000   817.026
    69.500   821.350
    70.000   825.667
    70.500   829.977
    71.000   834.278
    71.500   838.573
    72.000   842.860
    72.500   847.139
    73.000   851.410
    73.500   855.674
    74.000   859.930
    74.500   864.178
    75.000   868.419
    75.500   872.651
    76.000   876.875
    76.500   881.092
    77.000   885.300
    77.500   889.499
    78.000   893.691
    78.500   897.874
    79.000   902.048
    79.500   906.214
    80.000   910.372
    80.500   914.521
    81.000   918.661
    81.500   922.793
    82.000   926.916
    82.500   931.031
    83.000   935.137
    83.500   939.235
    84.000   943.324
    84.500   947.405
    85.000   951.477
    85.500   955.540
    86.000   959.594
    86.500   963.640
    87.000   967.677
    87.500   971.705
    88.000   975.724
    88.500   979.734
    89.000   983.735
    89.500   987.728
    90.000   991.711
    90.500   995.686
    91.000   999.651
    91.500  1003.608
    92.000  1007.555
    92.500  1011.493
    93.000  1015.423
    93.500  1019.343
    94.000  1023.255
    94.500  1027.157
    95.000  1031.050
    95.500  1034.935
    96.000  1038.810
    96.500  1042.676
    97.000  1046.533
    97.500  1050.381
    98.000  1054.220
    98.500  1058.049
    99.000  1061.870
    99.500  1065.681
   100.000  1069.484
   100.500  1073.277
   101.000  1077.061
   101.500  1080.836
   102.000  1084.601
   102.500  1088.358
   103.000  1092.105
   103.500  1095.844
   104.000  1099.573
   104.500  1103.294
   105.000  1107.005
   105.500  1110.708
   106.000  1114.402
   106.500  1118.087
   107.000  1121.763
   107.500  1125.430
   108.000  1129.088
   108.500  1132.737
   109.000  1136.376
   109.500  1140.006
   110.000  1143.627
   110.500  1147.239
   111.000  1150.841
   111.500  1154.435
   112.000  1158.019
   112.500  1161.593
   113.000  1165.159
   113.500  1168.715
   114.000  1172.263
   114.500  1175.801
   115.000  1179.330
   115.500  1182.850
   116.000  1186.361
   116.500  1189.863
   117.000  1193.356
   117.500  1196.840
   118.000  1200.315
   118.500  1203.781
   119.000  1207.237
   119.500  1210.684
   120.000  1214.122
   120.500  1217.551
   121.000  1220.971
   121.500  1224.381
   122.000  1227.783
   122.500  1231.175
   123.000  1234.558
   123.500  1237.931
   124.000  1241.296
   124.500  1244.652
   125.000  1247.998
   125.500  1251.336
   126.000  1254.665
   126.500  1257.984
   127.000  1261.295
   127.500  1264.597
   128.000  1267.890
   128.500  1271.174
   129.000  1274.449
   129.500  1277.715
   130.000  1280.973
   130.500  1284.221
   131.000  1287.460
   131.500  1290.690
   132.000  1293.911
   132.500  1297.123
   133.000  1300.326
   133.500  1303.520
   134.000  1306.705
   134.500  1309.881
   135.000  1313.048
   135.500  1316.206
   136.000  1319.354
   136.500  1322.494
   137.000  1325.624
   137.500  1328.746
   138.000  1331.858
   138.500  1334.961
   139.000  1338.055
   139.500  1341.141
   140.000  1344.217
   140.500  1347.283
   141.000  1350.341
   141.500  1353.390
   142.000  1356.430
   142.500  1359.460
   143.000  1362.482
   143.500  1365.495
   144.000  1368.498
   144.500  1371.492
   145.000  1374.478
   145.500  1377.454
   146.000  1380.421
   146.500  1383.378
   147.000  1386.326
   147.500  1389.265
   148.000  1392.195
   148.500  1395.115
   149.000  1398.025
   149.500  1400.926
   150.000  1403.818
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   824.377
   100.500   826.599
   101.000   828.822
   101.500   831.045
   102.000   833.268
   102.500   835.491
   103.000   837.714
   103.500   839.936
   104.000   842.159
   104.500   844.382
   105.000   846.605
   105.500   848.828
   106.000   851.051
   106.500   853.273
   107.000   855.496
   107.500   857.719
   108.000   859.942
   108.500   862.165
   109.000   864.388
   109.500   866.610
   110.000   868.833
   110.500   871.056
   111.000   873.279
   111.500   875.502
   112.000   877.725
   112.500   879.947
   113.000   882.170
   113.500   884.393
   114.000   886.616
   114.500   888.839
   115.000   891.062
   115.500   893.284
   116.000   895.507
   116.500   897.730
   117.000   899.953
   117.500   902.176
   118.000   904.399
   118.500   906.621
   119.000   908.844
   119.500   911.067
   120.000   913.290
   120.500   915.513
   121.000   917.736
   121.500   919.958
   122.000   922.181
   122.500   924.404
   123.000   926.627
   123.500   928.850
   124.000   931.073
   124.500   933.295
   125.000   935.518
   125.500   937.741
   126.000   939.964
   126.500   942.187
   127.000   944.410
   127.500   946.632
   128.000   948.855
   128.500   951.078
   129.000   953.301
   129.500   955.524
   130.000   957.747
   130.500   959.969
   131.000   962.192
   131.500   964.415
   132.000   966.638
   132.500   968.861
   133.000   971.084
   133.500   973.307
   134.000   975.529
   134.500   977.752
   135.000   979.975
   135.500   982.198
   136.000   984.421
   136.500   986.643
   137.000   988.866
   137.500   991.089
   138.000   993.312
   138.500   995.535
   139.000   997.758
   139.500   999.980
   140.000  1002.203
   140.500  1004.426
   141.000  1006.649
   141.500  1008.872
   142.000  1011.095
   142.500  1013.318
   143.000  1015.540
   143.500  1017.763
   144.000  1019.986
   144.500  1022.209
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   384.416
    15.000   394.655
    15.500   404.889
    16.000   415.116
    16.500   425.333
    17.000   435.535
    17.500   445.718
    18.000   455.878
    18.500   466.010
    19.000   476.107
    19.500   486.165
    20.000   496.176
    20.500   506.136
    21.000   516.038
    21.500   525.876
    22.000   535.646
    22.500   545.344
    23.000   553.926
    23.500   562.067
    24.000   570.175
    24.500   578.249
    25.000   586.279
    25.500   594.228
    26.000   602.139
    26.500   610.039
    27.000   617.930
    27.500   625.814
    28.000   633.690
    28.500   641.560
    29.000   649.424
    29.500   657.281
    30.000   665.130
    30.500   672.972
    31.000   680.803
    31.500   688.623
    32.000   696.431
    32.500   704.224
    33.000   712.002
    33.500   719.762
    34.000   727.505
    34.500   735.230
    35.000   742.935
    35.500   750.621
    36.000   758.287
    36.500   765.933
    37.000   773.559
    37.500   781.164
    38.000   788.748
    38.500   796.311
    39.000   803.851
    39.500   811.369
    40.000   818.864
    40.500   826.336
    41.000   833.784
    41.500   841.209
    42.000   848.610
    42.500   855.986
    43.000   863.339
    43.500   870.666
    44.000   877.969
    44.500   885.247
    45.000   892.500
    45.500   899.728
    46.000   906.930
    46.500   914.107
    47.000   921.257
    47.500   928.380
    48.000   935.477
    48.500   942.548
    49.000   949.591
    49.500   956.607
    50.000   963.596
    50.500   970.559
    51.000   977.494
    51.500   984.401
    52.000   991.281
    52.500   998.133
    53.000  1004.958
    53.500  1011.757
    54.000  1018.531
    54.500  1025.277
    55.000  1031.998
    55.500  1038.691
    56.000  1045.356
    56.500  1051.994
    57.000  1058.604
    57.500  1065.186
    58.000  1071.740
    58.500  1078.265
    59.000  1084.763
    59.500  1091.234
    60.000  1097.677
    60.500  1104.092
    61.000  1110.480
    61.500  1116.839
    62.000  1123.170
    62.500  1129.473
    63.000  1135.747
    63.500  1141.992
    64.000  1148.209
    64.500  1154.399
    65.000  1160.559
    65.500  1166.692
    66.000  1172.796
    66.500  1178.872
    67.000  1184.919
    67.500  1190.938
    68.000  1196.929
    68.500  1202.891
    69.000  1208.824
    69.500  1214.729
    70.000  1220.605
    70.500  1226.452
    71.000  1232.271
    71.500  1238.060
    72.000  1243.820
    72.500  1249.551
    73.000  1255.252
    73.500  1260.924
    74.000  1266.565
    74.500  1272.176
    75.000  1277.757
    75.500  1283.309
    76.000  1288.832
    76.500  1294.326
    77.000  1299.790
    77.500  1305.223
    78.000  1310.627
    78.500  1316.000
    79.000  1321.343
    79.500  1326.656
    80.000  1331.941
    80.500  1337.196
    81.000  1342.421
    81.500  1347.615
    82.000  1352.776
    82.500  1357.906
    83.000  1363.004
    83.500  1368.071
    84.000  1373.106
    84.500  1378.111
    85.000  1383.084
    85.500  1388.026
    86.000  1392.937
    86.500  1397.815
    87.000  1402.661
    87.500  1407.475
    88.000  1412.256
    88.500  1417.003
    89.000  1421.717
    89.500  1426.398
    90.000  1431.045
    90.500  1435.659
    91.000  1440.238
    91.500  1444.784
    92.000  1449.296
    92.500  1453.774
    93.000  1458.218
    93.500  1462.628
    94.000  1467.013
    94.500  1471.380
    95.000  1475.735
    95.500  1480.078
    96.000  1484.410
    96.500  1488.728
    97.000  1493.029
    97.500  1497.311
    98.000  1501.572
    98.500  1505.814
    99.000  1510.036
    99.500  1514.238
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   719.158
     1.000   719.204
     1.500   719.282
     2.000   719.391
     2.500   719.531
     3.000   719.702
     3.500   719.905
     4.000   720.138
     4.500   720.402
     5.000   720.696
     5.500   721.022
     6.000   721.378
     6.500   721.765
     7.000   722.183
     7.500   722.630
     8.000   723.108
     8.500   723.617
     9.000   724.155
     9.500   724.723
    10.000   725.321
    10.500   725.949
    11.000   726.606
    11.500   727.293
    12.000   728.008
    12.500   728.753
    13.000   729.527
    13.500   730.329
    14.000   731.159
    14.500   732.018
    15.000   732.905
    15.500   733.820
    16.000   734.763
    16.500   735.733
    17.000   736.730
    17.500   737.754
    18.000   738.805
    18.500   739.882
    19.000   740.986
    19.500   742.115
    20.000   743.271
    20.500   744.451
    21.000   745.658
    21.500   746.889
    22.000   748.145
    22.500   749.425
    23.000   750.729
    23.500   752.058
    24.000   753.409
    24.500   754.785
    25.000   756.183
    25.500   757.604
    26.000   759.047
    26.500   760.513
    27.000   762.000
    27.500   763.509
    28.000   765.039
    28.500   766.590
    29.000   768.161
    29.500   769.753
    30.000   771.365
    30.500   772.996
    31.000   774.647
    31.500   776.316
    32.000   778.005
    32.500   779.711
    33.000   781.436
    33.500   783.178
    34.000   784.938
    34.500   786.714
    35.000   788.507
    35.500   790.317
    36.000   792.143
    36.500   793.984
    37.000   795.841
    37.500   797.712
    38.000   799.598
    38.500   801.499
    39.000   803.414
    39.500   805.342
    40.000   807.284
    40.500   809.238
    41.000   811.206
    41.500   813.185
    42.000   815.177
    42.500   817.180
    43.000   819.194
    43.500   821.220
    44.000   823.256
    44.500   825.303
    45.000   827.359
    45.500   829.425
    46.000   831.501
    46.500   833.586
    47.000   835.679
    47.500   837.781
    48.000   839.890
    48.500   842.008
    49.000   844.133
    49.500   846.265
    50.000   848.404
    50.500   850.550
    51.000   852.701
    51.500   854.859
    52.000   857.023
    52.500   859.191
    53.000   861.365
    53.500   863.544
    54.000   865.727
    54.500   867.914
    55.000   870.105
    55.500   872.301
    56.000   874.499
    56.500   876.701
    57.000   878.905
    57.500   881.113
    58.000   883.323
    58.500   885.535
    59.000   887.749
    59.500   889.965
    60.000   892.182
    60.500   894.401
    61.000   896.621
    61.500   898.842
    62.000   901.064
    62.500   903.286
    63.000   905.508
    63.500   907.731
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   931.212
     1.000   931.278
     1.500   931.389
     2.000   931.544
     2.500   931.743
     3.000   931.987
     3.500   932.274
     4.000   932.606
     4.500   932.982
     5.000   933.402
     5.500   933.865
     6.000   934.372
     6.500   934.924
     7.000   935.518
     7.500   936.156
     8.000   936.838
     8.500   937.563
     9.000   938.331
     9.500   939.141
    10.000   939.995
    10.500   940.891
    11.000   941.830
    11.500   942.811
    12.000   943.834
    12.500   944.899
    13.000   946.006
    13.500   947.155
    14.000   948.345
    14.500   949.575
    15.000   950.847
    15.500   952.160
    16.000   953.513
    16.500   954.906
    17.000   956.339
    17.500   957.812
    18.000   959.325
    18.500   960.876
    19.000   962.467
    19.500   964.096
    20.000   965.764
    20.500   967.470
    21.000   969.213
    21.500   970.995
    22.000   972.813
    22.500   974.669
    23.000   976.561
    23.500   978.490
    24.000   980.455
    24.500   982.455
    25.000   984.491
    25.500   986.563
    26.000   988.669
    26.500   990.809
    27.000   992.984
    27.500   995.193
    28.000   997.435
    28.500   999.711
    29.000  1002.020
    29.500  1004.361
    30.000  1006.734
    30.500  1009.139
    31.000  1011.576
    31.500  1014.045
    32.000  1016.544
    32.500  1019.073
    33.000  1021.633
    33.500  1024.223
    34.000  1026.843
    34.500  1029.492
    35.000  1032.169
    35.500  1034.875
    36.000  1037.610
    36.500  1040.372
    37.000  1043.162
    37.500  1045.979
    38.000  1048.823
    38.500  1051.694
    39.000  1054.591
    39.500  1057.513
    40.000  1060.462
    40.500  1063.435
    41.000  1066.434
    41.500  1069.456
    42.000  1072.504
    42.500  1075.575
    43.000  1078.669
    43.500  1081.787
    44.000  1084.928
    44.500  1088.091
    45.000  1091.277
    45.500  1094.485
    46.000  1097.714
    46.500  1100.964
    47.000  1104.236
    47.500  1107.528
    48.000  1110.841
    48.500  1114.174
    49.000  1117.527
    49.500  1120.899
    50.000  1124.290
    50.500  1127.700
    51.000  1131.129
    51.500  1134.576
    52.000  1138.041
    52.500  1141.523
    53.000  1145.023
    53.500  1148.541
    54.000  1152.075
    54.500  1155.625
    55.000  1159.192
    55.500  1162.775
    56.000  1166.374
    56.500  1169.988
    57.000  1173.617
    57.500  1177.261
    58.000  1180.920
    58.500  1184.593
    59.000  1188.280
    59.500  1191.981
    60.000  1195.696
    60.500  1199.424
    61.000  1203.165
    61.500  1206.919
    62.000  1210.686
    62.500  1214.465
    63.000  1218.256
    63.500  1222.058
    64.000  1225.873
    64.500  1229.699
    65.000  1233.536
    65.500  1237.384
    66.000  1241.243
    66.500  1245.112
    67.000  1248.992
    67.500  1252.881
    68.000  1256.781
    68.500  1260.690
    69.000  1264.608
    69.500  1268.535
    70.000  1272.472
    70.500  1276.417
    71.000  1280.371
    71.500  1284.333
    72.000  1288.303
    72.500  1292.282
    73.000  1296.268
    73.500  1300.261
    74.000  1304.262
    74.500  1308.270
    75.000  1312.286
    75.500  1316.307
    76.000  1320.336
    76.500  1324.371
    77.000  1328.412
    77.500  1332.460
    78.000  1336.513
    78.500  1340.572
    79.000  1344.637
    79.500  1348.707
    80.000  1352.782
    80.500  1356.862
    81.000  1360.948
    81.500  1365.038
    82.000  1369.132
    82.500  1373.231
    83.000  1377.335
    83.500  1381.442
    84.000  1385.554
    84.500  1389.669
    85.000  1393.788
    85.500  1397.910
    86.000  1402.036
    86.500  1406.166
    87.000  1410.298
    87.500  1414.433
    88.000  1418.571
    88.500  1422.712
    89.000  1426.855
    89.500  1431.001
    90.000  1435.150
    90.500  1439.300
    91.000  1443.453
    91.500  1447.607
    92.000  1451.763
    92.500  1455.921
    93.000  1460.081
    93.500  1464.242
    94.000  1468.404
    94.500  1472.568
    95.000  1476.733
    95.500  1480.898
    96.000  1485.065
    96.500  1489.233
    97.000  1493.401
    97.500  1497.570
    98.000  1501.739
    98.500  1505.909
    99.000  1510.079
    99.500  1514.249
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   772.370
    29.500   782.610
    30.000   792.848
    30.500   803.084
    31.000   813.318
    31.500   823.548
    32.000   833.774
    32.500   843.995
    33.000   854.210
    33.500   864.418
    34.000   874.618
    34.500   884.809
    35.000   894.990
    35.500   905.159
    36.000   915.316
    36.500   925.459
    37.000   935.586
    37.500   945.697
    38.000   955.790
    38.500   965.647
    39.000   975.915
    39.500   985.944
    40.000   995.949
    40.500  1005.928
    41.000  1015.880
    41.500  1025.804
    42.000  1035.697
    42.500  1045.559
    43.000  1055.389
    43.500  1065.184
    44.000  1074.945
    44.500  1084.669
    45.000  1094.355
    45.500  1103.640
    46.000  1111.809
    46.500  1119.961
    47.000  1128.096
    47.500  1136.215
    48.000  1144.318
    48.500  1152.404
    49.000  1160.472
    49.500  1168.520
    50.000  1176.541
    50.500  1184.525
    51.000  1192.453
    51.500  1200.369
    52.000  1208.278
    52.500  1216.180
    53.000  1224.078
    53.500  1231.972
    54.000  1239.862
    54.500  1247.748
    55.000  1255.630
    55.500  1263.509
    56.000  1271.385
    56.500  1279.257
    57.000  1287.126
    57.500  1294.991
    58.000  1302.854
    58.500  1310.713
    59.000  1318.569
    59.500  1326.421
    60.000  1334.269
    60.500  1342.113
    61.000  1349.953
    61.500  1357.788
    62.000  1365.618
    62.500  1373.442
    63.000  1381.260
    63.500  1389.071
    64.000  1396.877
    64.500  1404.675
    65.000  1412.466
    65.500  1420.249
    66.000  1428.023
    66.500  1435.790
    67.000  1443.547
    67.500  1451.296
    68.000  1459.036
    68.500  1466.767
    69.000  1474.488
    69.500  1482.200
    70.000  1489.902
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     2.627    47.117     0.150
     2.627    47.117     0.150
     2.627    82.117     0.150
     5.751    90.117     0.150
     5.957    93.117     0.150
     5.957   111.117     0.150
     6.110    95.117     0.150
     6.110   163.117     0.150
     6.110   194.117     0.150
     6.574   101.117     0.150
     6.574   175.117     0.150
     6.574   221.117     0.150
     7.488   214.117     0.150
     7.628   114.117     0.150
     7.628   198.117     0.150
     8.420   127.117     0.150
     8.420   221.117     0.150
     8.532   128.117     0.150
     8.532   225.117     0.150
     9.790   179.117     0.150
     9.790   191.117     0.150
     9.790   208.117     0.150
     9.790   139.117     0.150
     9.790   191.117     0.150
     9.790   243.117     0.150
     9.560   141.117     0.150
     9.560   305.117     0.150
     9.646   319.117     0.150
    10.100   193.117     0.150
    12.488   178.117     0.150
    12.488   255.117     0.150
    16.019   598.117     0.150
    16.916   234.117     0.150
    16.916   234.117     0.150
    16.916   435.117     0.150
    18.609   591.117     0.150
    18.609   484.117     0.150
    18.609   591.117     0.150
    19.516   465.117     0.150
    20.260    14.000     0.150
    20.260   485.117     0.150
    21.924   476.117     0.150
    22.078   234.117     0.150
    23.322   708.117     0.150
    25.239   743.117     0.150
    29.050   376.117     0.150
    28.923   366.117     0.150
    30.930   753.117     0.150
    30.930   377.117     0.150
    30.930   753.117     0.150
    39.130   442.117     0.150
    39.798   601.117     0.150
    42.352   485.117     0.150
    42.352   474.117     0.150
    42.352   571.117     0.150
    43.548   493.117     0.150
    43.548   484.117     0.150
    43.548   590.117     0.150
    44.068   518.117     0.150
    44.114   484.117     0.150
    45.129   648.117     0.150
    56.297   612.117     0.150
    57.711   624.117     0.150
   125.338  1807.117     0.150
   134.560  1164.117     0.150
     8.132   126.047     0.150
     8.132   131.047     0.150
     8.132   177.047     0.150
     8.132   212.047     0.150
     8.132   260.047     0.150
     8.132   114.047     0.150
     8.132   121.047     0.150
     8.132   133.047     0.150
     8.132   207.047     0.150
     8.132   234.047     0.150
    16.357   567.047     0.150
    19.491  1026.047     0.150
    20.359   287.250     0.150
    28.778   358.047     0.150
    35.409   399.047     0.150
    39.313    18.898     0.150
    39.489   567.047     0.150
    39.766   484.047     0.150
    41.280   550.047     0.150
    42.241   870.047     0.150
    44.061   602.047     0.150
    44.197   623.047     0.150
    44.830   496.047     0.150
    45.096   630.047     0.150
    45.530    25.500     0.150
    45.530   654.047     0.150
    47.881   661.047     0.150
    48.027   520.047     0.150
    52.354   564.047     0.150
    53.487   821.047     0.150
    53.487   829.047     0.150
    58.644    25.000     0.150
    69.115   655.047     0.150
    74.836   700.148     0.150
    75.924   705.148     0.150
    80.757   742.148     0.150
    90.227   781.047     0.150
     2.790    53.914     0.150
     2.790    90.914     0.150
     2.790    97.914     0.150
     4.179    80.914     0.150
     5.831   108.414     0.150
     6.704   149.414     0.150
     7.475   118.814     0.150
     7.475   209.814     0.150
    25.117   911.914     0.150
    31.241   382.914     0.150
    33.153   395.914     0.150
    44.251   529.914     0.150
    44.647   491.414     0.150
     2.930    57.843     0.150
     5.670   117.343     0.150
     6.684   140.843     0.150
     7.190   119.843     0.150
     7.790   261.143     0.150
     8.766   238.843     0.150
    25.187   330.843     0.150
     3.125    55.059     0.150
     3.125    95.059     0.150
     4.055    66.659     0.150
     5.743    84.659     0.150
     5.743    84.659     0.150
     5.743   157.759     0.150
     5.959    93.859     0.150
     6.518   101.959     0.150
     6.518   172.959     0.150
     7.505   113.659     0.150
     8.310   218.959     0.150
    12.555   315.459     0.150
    16.548   618.959     0.150
    17.683   252.259     0.150
    21.183   285.059     0.150
    21.183   518.959     0.150
    21.582   289.359     0.150
    22.640   304.959     0.150
    23.000     4.000     0.150
    23.000   306.959     0.150
    23.000     4.000     0.150
    23.119     9.000     0.150
    23.119   307.959     0.150
    23.119     9.000     0.150
    23.119   556.959     0.150
    23.390   303.959     0.150
    27.132   345.959     0.150
    27.938   352.959     0.150
    29.216   440.959     0.150
    29.216   364.959     0.150
    30.468   379.759     0.150
    30.920   385.959     0.150
    31.185   396.959     0.150
    35.645   423.959     0.150
    35.773    13.000     0.150
    35.773   418.959     0.150
    35.773    13.000     0.150
    41.198   468.559     0.150
    42.176   475.959     0.150
    45.157   496.059     0.150
    47.150   511.959     0.150
    75.909   709.959     0.150
     3.422    65.395     0.150
     4.267    69.395     0.150
     5.868    92.395     0.150
     5.868    92.494     0.150
     7.001    87.395     0.150
     8.885   131.395     0.150
     8.885   228.395     0.150
    22.393   301.395     0.150
    23.304   326.395     0.150
    23.304   327.195     0.150
    23.391   306.395     0.150
    24.997   700.895     0.150
    39.439   456.195     0.150
    39.491   450.494     0.150
    45.744   499.195     0.150
    81.278   742.395     0.150
     2.495    38.826     0.150
     2.982    95.826     0.150
     3.327    58.025     0.150
     3.327    58.025     0.150
     3.327   102.525     0.150
     3.886   104.326     0.150
     3.886    64.326     0.150
     3.886   104.326     0.150
     4.168    68.127     0.150
     4.168   118.727     0.150
     4.170    68.826     0.150
     4.170   113.826     0.150
     4.365   126.025     0.150
     4.365    70.826     0.150
     4.365   126.025     0.150
     4.377    71.627     0.150
     4.377   121.127     0.150
     5.770    90.025     0.150
     5.770   159.025     0.150
     6.303    97.525     0.150
     6.303   175.525     0.150
     6.769   175.326     0.150
     6.769   103.127     0.150
     6.769   175.326     0.150
     8.072   210.826     0.150
     8.234   213.826     0.150
     8.812   131.326     0.150
     8.812   231.826     0.150
     9.149   227.826     0.150
     9.993   147.627     0.150
     9.993   266.627     0.150
    12.216   173.826     0.150
    14.272   351.326     0.150
    14.272   369.326     0.150
    14.272   378.326     0.150
    17.317   239.826     0.150
    17.317   428.326     0.150
    17.317   428.326     0.150
    17.370   246.826     0.150
    18.583    14.000     0.150
    18.583   277.326     0.150
    18.583   321.826     0.150
    18.583   621.826     0.150
    19.330   266.127     0.150
    19.719   272.826     0.150
    19.719   496.826     0.150
    19.867   273.426     0.150
    19.867   497.426     0.150
    20.044   273.826     0.150
    20.044   496.127     0.150
    21.052   286.826     0.150
    21.052   315.826     0.150
    21.052   511.826     0.150
    21.685   600.826     0.150
    21.727   285.826     0.150
    21.727   285.826     0.150
    21.727   528.826     0.150
    21.914   296.826     0.150
    21.914   328.826     0.150
    22.087   294.025     0.150
    22.087   536.127     0.150
    22.319   300.826     0.150
    22.308   316.826     0.150
    22.308   382.826     0.150
    22.308   516.326     0.150
    22.308   599.326     0.150
    22.308  1120.326     0.150
    22.308  1195.326     0.150
    22.750   303.826     0.150
    22.750   361.826     0.150
    23.124   306.826     0.150
    23.124   548.826     0.150
    23.207   306.826     0.150
    23.207   562.826     0.150
    23.207   615.826     0.150
    23.294    16.000     0.150
    23.294    15.301     0.150
    23.294   340.525     0.150
    23.294   356.326     0.150
    23.294   529.826     0.150
    23.294   550.525     0.150
    23.995   314.926     0.150
    25.094   327.826     0.150
    25.094   663.826     0.150
    27.170   392.826     0.150
    27.225   344.826     0.150
    27.225   626.326     0.150
    28.561   637.826     0.150
    28.561   358.127     0.150
    28.561   423.326     0.150
    28.561   637.826     0.150
    29.415   725.826     0.150
    29.577   365.025     0.150
    29.577   434.826     0.150
    29.832   669.826     0.150
    29.832   781.826     0.150
    30.891   375.826     0.150
    31.127   379.025     0.150
    31.127   795.826     0.150
    33.497    13.500     0.150
    33.497   400.326     0.150
    33.497     8.500     0.150
    33.497    13.500     0.150
    33.497   723.826     0.150
    74.014   402.826     0.150
    34.609   401.826     0.150
    34.843   423.326     0.150
    35.281   404.727     0.150
    35.600   761.826     0.150
    35.600   417.826     0.150
    35.600   761.826     0.150
    36.179   418.826     0.150
    36.210   423.127     0.150
    36.210   763.826     0.150
    36.232   423.826     0.150
    36.232   757.826     0.150
    36.983   430.826     0.150
    37.079   430.525     0.150
    80.533   434.826     0.150
    38.755   989.826     0.150
    39.132   447.826     0.150
    39.224   448.826     0.150
    39.328   449.227     0.150
    39.453   450.926     0.150
    39.637   467.525     0.150
    39.637   452.525     0.150
    39.637    15.000     0.150
    39.637   809.826     0.150
    39.999   449.926     0.150
    40.027   454.826     0.150
    40.027   615.826     0.150
    40.184   458.627     0.150
    40.184    11.199     0.150
    41.331   836.326     0.150
    41.276   475.127     0.150
    41.960   807.826     0.150
    41.989   575.826     0.150
    42.315    21.400     0.150
    42.315  1017.826     0.150
    42.315  1417.826     0.150
    42.866   856.826     0.150
    43.116   875.826     0.150
    43.116   482.227     0.150
    43.116   582.326     0.150
    43.116   875.826     0.150
    43.383   508.826     0.150
    43.486   484.525     0.150
    43.613   483.926     0.150
    43.771   486.826     0.150
    43.771   589.727     0.150
    44.063     5.500     0.150
    44.075   606.826     0.150
    44.075   488.926     0.150
    44.970  1110.826     0.150
    44.970   496.326     0.150
    44.970   596.826     0.150
    45.743   500.326     0.150
    45.743   599.826     0.150
    45.743   650.627     0.150
    45.743   902.826     0.150
    45.743   910.627     0.150
    47.606   517.826     0.150
    47.668   515.326     0.150
    47.668     7.500     0.150
    47.668    12.500     0.150
    47.668   929.826     0.150
    47.668   948.826     0.150
    47.893    19.699     0.150
    48.189   941.826     0.150
    49.541   525.826     0.150
    49.549  2958.826     0.150
    53.393   554.826     0.150
    54.263    14.000     0.150
    54.263   567.826     0.150
    54.263    14.000     0.150
    54.263  1027.826     0.150
    54.623   566.326     0.150
    55.991  1045.826     0.150
    56.215   579.727     0.150
    56.215  1071.926     0.150
    57.974   635.826     0.150
    58.616   590.826     0.150
    62.080  1112.826     0.150
    62.182   617.826     0.150
    62.182  1149.826     0.150
    65.639   643.426     0.150
    65.639    13.000     0.150
    75.267   703.326     0.150
    76.189   708.826     0.150
   110.006  1122.326     0.150
   112.503  1111.727     0.150
   139.659  1162.826     0.150
   141.512  1166.826     0.150
     2.993    52.504     0.150
     2.993    94.504     0.150
     3.873    63.004     0.150
     3.873   115.805     0.150
     4.030    65.105     0.150
     4.030   118.305     0.150
     4.152   110.805     0.150
     4.152   110.805     0.150
     5.746    87.805     0.150
     5.746    88.203     0.150
     5.746   158.406     0.150
     6.312    96.805     0.150
     6.760   179.805     0.150
     6.760   179.805     0.150
     8.095   208.805     0.150
     8.827   131.805     0.150
     8.827   229.805     0.150
    10.014   147.805     0.150
    10.014   265.805     0.150
    10.035   147.805     0.150
    10.035   258.805     0.150
    10.093   257.805     0.150
    10.306   263.805     0.150
    10.306   270.805     0.150
    10.490   273.805     0.150
    12.172   174.805     0.150
    12.172   174.805     0.150
    14.312   218.004     0.150
    16.311   397.305     0.150
    17.333   240.805     0.150
    17.333   432.504     0.150
    17.326   247.805     0.150
    17.564   467.805     0.150
    18.605    10.000     0.150
    19.351   265.406     0.150
    19.351   484.703     0.150
    19.676   272.004     0.150
    19.676   500.004     0.150
    19.821   272.805     0.150
    19.821   274.805     0.150
    19.821   301.805     0.150
    19.999   272.805     0.150
    19.999   492.805     0.150
    21.010   285.305     0.150
    21.010   324.805     0.150
    21.010   513.805     0.150
    21.324   288.805     0.150
    21.324   525.805     0.150
    21.637   508.805     0.150
    21.637   670.805     0.150
    21.637  1015.805     0.150
    21.637  1101.805     0.150
    21.746   289.004     0.150
    21.869   296.805     0.150
    22.101   539.805     0.150
    22.101   295.504     0.150
    22.101   539.805     0.150
    22.268   306.805     0.150
    22.275   300.805     0.150
    22.275   300.805     0.150
    23.082   305.305     0.150
    23.082   557.805     0.150
    23.193   557.805     0.150
    23.193   614.805     0.150
    23.277     3.500     0.150
    23.277   307.805     0.150
    23.277     3.500     0.150
    23.277   353.805     0.150
    23.277   561.305     0.150
    23.277   601.805     0.150
    25.110    40.000     0.150
    25.110   377.406     0.150
    25.110   664.805     0.150
    25.348   329.805     0.150
    25.348   587.805     0.150
    27.216   709.805     0.150
    27.216  1014.305     0.150
    27.183   344.805     0.150
    27.183   402.805     0.150
    28.594   356.805     0.150
    28.594   411.305     0.150
    28.594   652.305     0.150
    28.594   743.305     0.150
    29.463    26.000     0.150
    29.463   692.805     0.150
    29.535   366.805     0.150
    29.535   441.805     0.150
    29.535   665.805     0.150
    29.864   368.805     0.150
    29.864   665.805     0.150
    29.864   781.805     0.150
    30.860   375.805     0.150
    30.860   682.805     0.150
    31.095   378.305     0.150
    31.095   453.805     0.150
    31.095   685.805     0.150
    33.067   391.805     0.150
    33.456   400.305     0.150
    33.456   724.305     0.150
    33.685   403.805     0.150
    73.968   402.805     0.150
    33.813   953.805     0.150
    34.048   955.305     0.150
    34.203   963.805     0.150
    34.801   411.305     0.150
    34.801   518.305     0.150
    34.801  1010.805     0.150
    34.898   412.305     0.150
    35.200   913.805     0.150
    35.249   569.805     0.150
    35.333   572.805     0.150
    35.333   980.805     0.150
    35.333   413.805     0.150
    35.566   570.805     0.150
    35.566   923.805     0.150
    36.138   416.805     0.150
    36.216   421.805     0.150
    36.216   760.805     0.150
    36.203   422.805     0.150
    36.203   761.805     0.150
    36.944   429.805     0.150
    36.944   775.805     0.150
    37.041   429.805     0.150
    37.476   433.805     0.150
    37.500   753.805     0.150
    37.588    11.699     0.150
    37.709   509.805     0.150
    37.709   749.805     0.150
    37.800   438.906     0.150
    37.978   439.805     0.150
    37.978   557.805     0.150
    37.978   791.805     0.150
    38.711   778.605     0.150
    38.711  1000.605     0.150
    39.103   785.805     0.150
    39.103   446.703     0.150
    39.111   845.805     0.150
    39.111   939.805     0.150
    39.135   479.805     0.150
    39.204   449.004     0.150
    39.204   805.805     0.150
    39.209   578.203     0.150
    39.209  1002.203     0.150
    39.317   451.805     0.150
    39.316     9.500     0.150
    39.316   583.805     0.150
    39.484   449.805     0.150
    39.484   449.805     0.150
    39.554    10.000     0.150
    39.554   570.805     0.150
    39.598   456.406     0.150
    39.598     9.000     0.150
    39.598   452.105     0.150
    39.598   544.805     0.150
    39.598   812.805     0.150
    40.075   458.805     0.150
    40.144    19.000     0.150
    40.144   456.805     0.150
    40.144   555.805     0.150
    41.263   529.305     0.150
    41.254   468.805     0.150
    41.426    12.000     0.150
    41.948   531.406     0.150
    41.948   579.305     0.150
    41.958   470.805     0.150
    42.179   507.805     0.150
    42.303   480.504     0.150
    42.384   478.004     0.150
    42.384   869.805     0.150
    42.384   901.805     0.150
    42.555   480.805     0.150
    42.906   857.805     0.150
    43.077   481.105     0.150
    43.077   584.805     0.150
    43.077   869.805     0.150
    43.077  1073.805     0.150
    43.145   596.805     0.150
    43.145   883.805     0.150
    43.300   482.305     0.150
    43.300   483.805     0.150
    43.342   481.805     0.150
    43.342   483.805     0.150
    43.448   482.805     0.150
    43.448   875.805     0.150
    43.731   880.805     0.150
    43.731   592.203     0.150
    43.731  1078.805     0.150
    44.022   492.406     0.150
    44.022   550.004     0.150
    44.022   573.605     0.150
    44.022   609.605     0.150
    44.036   605.805     0.150
    44.036   635.805     0.150
    44.036   489.004     0.150
    44.036   595.805     0.150
    44.473   606.805     0.150
    44.868   501.805     0.150
    44.779   902.805     0.150
    44.931   618.805     0.150
    44.931   496.305     0.150
    45.238   499.805     0.150
    45.238   499.766     0.150
    45.449   508.805     0.150
    45.609   505.805     0.150
    45.610   508.805     0.150
    45.768   498.906     0.150
    45.768     5.500     0.150
    45.768   594.406     0.150
    45.768   610.406     0.150
    45.768   903.406     0.150
    45.889   508.805     0.150
    46.329   620.805     0.150
    46.365   505.805     0.150
    46.365   911.805     0.150
    47.647   517.805     0.150
    47.647   632.805     0.150
    47.647   934.805     0.150
    47.647   946.805     0.150
    47.683   514.805     0.150
    47.683   631.805     0.150
    47.683   928.805     0.150
    47.683   949.805     0.150
    47.856   610.805     0.150
    48.237   925.805     0.150
    48.850   589.805     0.150
    48.850   991.805     0.150
    49.457   532.805     0.150
    49.457   655.805     0.150
    49.589   550.805     0.150
    53.301   557.906     0.150
    54.300   566.805     0.150
    54.300     2.500     0.150
    54.300  1028.805     0.150
    54.300  1038.805     0.150
    54.671   570.203     0.150
    56.018  1043.805     0.150
    56.018  1067.805     0.150
    56.239  1049.906     0.150
    56.239  1070.805     0.150
    56.404   579.504     0.150
    57.275   593.805     0.150
    57.637   636.805     0.150
    57.637   656.805     0.150
    57.840   626.504     0.150
    57.840   713.203     0.150
    57.931  1108.805     0.150
    58.198   597.805     0.150
    58.209   596.805     0.150
    60.048   590.805     0.150
    60.853   610.805     0.150
    61.586   650.805     0.150
    61.586   846.203     0.150
    62.213   617.805     0.150
    62.213  1125.805     0.150
    65.656   642.805     0.150
    65.656     2.000     0.150
    65.656     5.000     0.150
    65.656  1169.805     0.150
    65.656  1203.805     0.150
    68.644   663.305     0.150
    68.644   662.934     0.150
    72.934   674.805     0.150
    75.314   706.805     0.150
    76.399   707.605     0.150
    76.716   710.805     0.150
    78.999   723.805     0.150
    83.599   755.805     0.150
    90.182   778.457     0.150
    90.779   779.805     0.150
    73.968   833.203     0.150
   104.222  1107.305     0.150
   106.030   857.004     0.150
   107.099   862.805     0.150
   107.099  1757.805     0.150
   107.099  2093.805     0.150
   108.861  1119.805     0.150
   110.621  1117.805     0.150
   111.118  1120.805     0.150
   113.028  1116.805     0.150
   128.609  1139.805     0.150
   139.611  1160.805     0.150
   139.994  1164.004     0.150
   142.367  1166.906     0.150
   142.417  1168.004     0.150
     3.013    53.812     0.150
     3.013    96.914     0.150
     3.869    63.711     0.150
     3.869   112.211     0.150
     4.144    66.812     0.150
     4.144   119.613     0.150
     4.149   117.613     0.150
     4.341   122.211     0.150
     4.341    69.711     0.150
     4.341   122.211     0.150
     4.379    73.312     0.150
     4.379    73.812     0.150
     4.647    79.211     0.150
     4.647    79.211     0.150
     4.647   140.113     0.150
     5.730    89.012     0.150
     5.730   156.312     0.150
     6.329   175.711     0.150
     8.124   222.512     0.150
     8.124   222.512     0.150
     8.849   234.312     0.150
    10.067   272.312     0.150
    10.067   272.312     0.150
    10.121   150.012     0.150
    11.336   147.711     0.150
    14.345   370.613     0.150
    16.314   236.312     0.150
    16.156   237.312     0.150
    17.567   246.312     0.150
    17.355   445.414     0.150
    19.378   266.113     0.150
    19.780   276.113     0.150
    19.780   276.113     0.150
    19.960   263.312     0.150
    21.871   283.312     0.150
    21.871   601.312     0.150
    21.772   290.512     0.150
    21.772   534.312     0.150
    22.123   295.012     0.150
    22.123   537.312     0.150
    22.369    59.000     0.150
    22.369   371.312     0.150
    22.236   299.113     0.150
    22.840   314.312     0.150
    23.188   306.312     0.150
    23.188   557.914     0.150
    23.188   621.512     0.150
    23.270   312.312     0.150
    23.270     5.000     0.150
    23.270   312.312     0.150
    23.270     5.000     0.150
    23.270   346.312     0.150
    25.117   325.312     0.150
    28.632   357.512     0.150
    28.632   416.012     0.150
    29.839   376.312     0.150
    30.838   380.312     0.150
    30.838   380.312     0.150
    31.072   378.312     0.150
    36.230   422.613     0.150
    36.230     3.699     0.150
    37.557   439.312     0.150
    39.082   451.711     0.150
    39.082   446.812     0.150
    39.271   448.312     0.150
    39.284    11.000     0.150
    39.566   456.312     0.150
    39.566   456.512     0.150
    42.261   475.613     0.150
    42.373   477.312     0.150
    43.045   480.312     0.150
    43.416   488.312     0.150
    43.416   488.512     0.150
    47.706   515.312     0.150
    47.706     6.000     0.150
    50.889   545.312     0.150
    53.303   563.312     0.150
    63.027   623.312     0.150
     2.956    53.609     0.150
     2.956    95.211     0.150
     3.284    99.711     0.150
     3.284    57.414     0.150
     3.284    99.711     0.150
     3.284   106.211     0.150
     3.842    63.609     0.150
     3.842   121.211     0.150
     4.181    60.211     0.150
     4.097    67.812     0.150
     4.097   117.711     0.150
     4.123    68.211     0.150
     4.123   121.211     0.150
     4.123   118.109     0.150
     4.123    67.609     0.150
     4.123   118.109     0.150
     5.376    84.008     0.150
     5.376   148.008     0.150
     5.722    89.414     0.150
     5.722   154.711     0.150
     6.275    95.211     0.150
     6.275   172.508     0.150
     6.558   232.211     0.150
     8.789   230.609     0.150
     9.976   148.211     0.150
    10.055   269.211     0.150
    10.055   149.211     0.150
    10.055   269.211     0.150
    10.306   277.711     0.150
    10.306   149.211     0.150
    10.306   277.711     0.150
    10.490   151.211     0.150
    10.490   274.711     0.150
    17.295   444.008     0.150
    19.822   274.812     0.150
    19.822   277.211     0.150
    19.998   275.211     0.150
    21.708   289.812     0.150
    21.708   532.211     0.150
    22.063   295.211     0.150
    22.063   537.508     0.150
    22.272   300.211     0.150
    22.321    25.000     0.150
    22.321   335.711     0.150
    22.790    25.000     0.150
    22.790   337.211     0.150
    23.076   304.609     0.150
    23.162   352.008     0.150
    23.162   606.211     0.150
    23.162   627.812     0.150
    23.248   308.211     0.150
    23.248   565.211     0.150
    25.140   917.211     0.150
    28.559   357.812     0.150
    31.077   379.008     0.150
    36.179   422.914     0.150
    36.179     5.297     0.150
    37.470   435.211     0.150
    37.576   746.211     0.150
    39.082   447.508     0.150
    39.306   453.211     0.150
    39.266   448.812     0.150
    39.292   461.211     0.150
    39.449   452.211     0.150
    41.381   467.211     0.150
    43.721   472.211     0.150
    56.593   577.508     0.150
    63.099   622.211     0.150
     1.077    52.691     0.150
     2.980    52.891     0.150
     2.980    93.492     0.150
     3.304    57.391     0.150
     3.304   101.992     0.150
     3.872    64.191     0.150
     4.117    67.492     0.150
     4.117   117.992     0.150
     4.141    66.891     0.150
     4.141   117.391     0.150
     4.141    67.492     0.150
     4.141   122.293     0.150
     4.249    68.992     0.150
     4.249    68.992     0.150
     4.249   121.992     0.150
     4.337   124.391     0.150
     4.337   124.391     0.150
     4.360    70.691     0.150
     5.324    81.992     0.150
     5.395    76.492     0.150
     5.395   140.594     0.150
     5.736    89.391     0.150
     5.736   158.492     0.150
     6.298    98.492     0.150
     6.298   176.094     0.150
     7.131   118.492     0.150
     8.081   211.293     0.150
     8.813   228.492     0.150
     9.102   310.492     0.150
    10.000   269.492     0.150
    10.000   147.492     0.150
    10.000   269.492     0.150
    10.022   146.492     0.150
    10.304   149.492     0.150
    10.488   155.492     0.150
    10.488   155.492     0.150
    10.488   268.492     0.150
    12.170   172.492     0.150
    12.170   305.492     0.150
    17.319   241.992     0.150
    17.319   444.594     0.150
    17.324   246.492     0.150
    18.616   419.492     0.150
    19.337   265.492     0.150
    19.820   272.094     0.150
    19.820   499.492     0.150
    21.006   286.492     0.150
    21.006   519.492     0.150
    21.323   288.492     0.150
    22.087   294.492     0.150
    22.087   534.992     0.150
    22.272   299.691     0.150
    23.078   305.594     0.150
    23.181     9.102     0.150
    23.181     8.402     0.150
    23.181   601.492     0.150
    23.266     5.500     0.150
    23.266    12.500     0.150
    23.266     4.699     0.150
    23.266    11.699     0.150
    23.266   348.492     0.150
    23.266   564.492     0.150
    24.010   316.293     0.150
    25.122   327.492     0.150
    28.187   352.391     0.150
    28.582   357.492     0.150
    28.582   403.492     0.150
    28.582   649.492     0.150
    29.851   368.492     0.150
    30.852   377.492     0.150
    30.852   377.492     0.150
    31.087    18.500     0.150
    31.087   378.992     0.150
    31.087    18.500     0.150
    31.087   465.492     0.150
    35.329   408.492     0.150
    35.558   417.492     0.150
    36.202   422.793     0.150
    36.194   422.492     0.150
    36.194   530.492     0.150
    37.093   436.492     0.150
    37.093   436.891     0.150
    39.094   447.391     0.150
    39.130   561.492     0.150
    39.130   584.492     0.150
    39.193   562.293     0.150
    39.282   451.094     0.150
    39.279   448.492     0.150
    39.592   463.492     0.150
    41.421   458.094     0.150
    41.953   471.492     0.150
    43.071   523.492     0.150
    43.071   481.691     0.150
    43.337   482.492     0.150
    43.442   515.492     0.150
    43.442   484.191     0.150
    43.580   484.492     0.150
    43.726   527.492     0.150
    43.726   486.492     0.150
    44.017     6.500     0.150
    44.926   495.492     0.150
    45.755   906.891     0.150
    46.352   502.492     0.150
    47.669    13.000     0.150
    47.669   515.492     0.150
    47.669    13.000     0.150
    49.452   532.191     0.150
    74.224   698.492     0.150
    90.181   781.691     0.150
    90.184   781.691     0.150
     1.461    51.102     0.150
     2.967    54.500     0.150
     2.967    95.102     0.150
     3.294   103.102     0.150
     3.294    58.305     0.150
     3.294   103.102     0.150
     3.852    64.805     0.150
     3.852   114.602     0.150
     3.862    73.398     0.150
     3.862    73.398     0.150
     3.862   112.398     0.150
     3.956    67.703     0.150
     3.956   117.703     0.150
     4.009    67.000     0.150
     4.009   116.203     0.150
     4.132    68.305     0.150
     4.132   118.805     0.150
     4.132    68.703     0.150
     4.132   122.102     0.150
     4.241    70.500     0.150
     4.241   124.602     0.150
     4.328   122.305     0.150
     4.328    71.305     0.150
     4.328   122.305     0.150
     4.350    71.703     0.150
     4.350   130.898     0.150
     4.610   141.398     0.150
     5.336   189.102     0.150
     5.729    90.102     0.150
     8.069   215.898     0.150
     8.280   234.102     0.150
     8.801   132.305     0.150
     8.801   234.500     0.150
     9.106   244.102     0.150
     9.716   145.102     0.150
    10.067   276.203     0.150
    10.079   276.203     0.150
    14.319   217.305     0.150
    14.319   224.805     0.150
    14.319   388.102     0.150
    17.307   440.602     0.150
    18.623   439.102     0.150
    19.822   280.703     0.150
    19.822   275.102     0.150
    19.822   280.703     0.150
    21.720   533.102     0.150
    22.075   296.102     0.150
    22.322    26.000     0.150
    22.322   334.602     0.150
    22.273   301.102     0.150
    23.172   308.102     0.150
    23.257   570.102     0.150
    31.083   380.102     0.150
    36.190   423.102     0.150
    39.089   448.102     0.150
    39.273   453.102     0.150
    39.460   451.102     0.150
    39.460   451.203     0.150
    42.164   471.398     0.150
    43.440   485.102     0.150
    43.859   478.602     0.150
    46.315   506.602     0.150
    47.657   517.102     0.150
    83.117   748.398     0.150
     3.638    59.234     0.150
     3.843    63.234     0.150
     4.317   123.234     0.150
     5.370    83.234     0.150
     6.718   177.234     0.150
     9.145   265.234     0.150
     9.687   145.938     0.150
     9.687   154.531     0.150
     9.687   258.938     0.150
     9.687   269.234     0.150
    20.030   276.234     0.150
    22.303   302.234     0.150
    31.091   376.234     0.150
    39.275   447.438     0.150
    41.361   551.234     0.150
    43.459   486.234     0.150
    43.459   486.336     0.150
    44.271   487.633     0.150
    44.271   487.633     0.150
    60.407   599.438     0.150
    60.407   606.336     0.150
    60.407   707.633     0.150
    83.089   748.836     0.150
     1.229    55.273     0.150
     5.215    78.273     0.150
     5.725    96.273     0.150
    14.404   199.773     0.150
    14.587   205.875     0.150
    17.012   233.273     0.150
    18.351   271.273     0.150
    18.351   481.273     0.150
    18.351   490.273     0.150
    41.508   466.273     0.150
    83.352   747.273     0.150
     2.396    54.840     0.150
    16.121   235.141     0.150
     6.473   101.090     0.150
     6.473   152.090     0.150
     6.473   173.391     0.150
     6.473   173.391     0.150
     8.740   129.490     0.150
     8.740   227.090     0.150
    16.069   493.590     0.150
    16.069   527.090     0.150
    16.069   527.090     0.150
    16.325   518.090     0.150
    21.105   286.090     0.150
    23.176   305.090     0.150
    23.185   305.990     0.150
    23.277   306.090     0.150
    23.743     5.900     0.150
    27.073   350.590     0.150
    28.466   354.391     0.150
    29.693   369.891     0.150
    31.518   385.590     0.150
    34.895   403.090     0.150
    35.428   414.090     0.150
    36.316   430.590     0.150
    43.158   486.090     0.150
    43.158   486.590     0.150
    43.748   482.990     0.150
    43.748    19.500     0.150
    43.748   510.789     0.150
    43.815   492.090     0.150
    43.815    15.000     0.150
    43.815   591.590     0.150
    43.815   597.090     0.150
    43.815   492.090     0.150
    43.815   591.590     0.150
    44.114   495.090     0.150
    44.114   624.090     0.150
    44.114   495.090     0.150
    44.114   624.090     0.150
    45.319   495.590     0.150
    47.594   512.590     0.150
    53.947   568.090     0.150
    63.187   631.090     0.150
    73.970   693.990     0.150
    83.094   742.590     0.150
    83.475   745.289     0.150
     6.092    92.684     0.150
     8.442   127.480     0.150
    10.697   164.082     0.150
    10.697   273.582     0.150
    10.697   164.582     0.150
    10.697   273.582     0.150
    15.663   230.082     0.150
    15.663   403.582     0.150
    21.327   291.082     0.150
    23.096   307.883     0.150
    23.210   315.082     0.150
    23.210   310.082     0.150
    23.210     5.000     0.150
    23.210   338.082     0.150
    25.193   331.082     0.150
    28.066   353.883     0.150
    36.612   425.883     0.150
    39.202   449.281     0.150
    43.935   492.281     0.150
    47.070   527.082     0.150
    82.890   744.184     0.150
    83.274   749.184     0.150
     9.788   145.641     0.150
     9.788   146.438     0.150
    16.426   218.641     0.150
    16.426   438.641     0.150
    18.281   251.641     0.150
    18.281   459.641     0.150
    21.892   292.938     0.150
    21.892   320.938     0.150
    21.892   535.742     0.150
    21.892   292.938     0.150
    21.892   320.938     0.150
    21.892   535.742     0.150
    22.279    12.000     0.150
    22.279   297.641     0.150
    22.279    12.000     0.150
    22.279   330.641     0.150
    23.185    10.000     0.150
    23.185     6.102     0.150
    23.185   305.641     0.150
    23.185    10.000     0.150
    28.351   352.641     0.150
    36.868   431.641     0.150
    36.868   432.438     0.150
    36.903   426.344     0.150
    43.722   491.438     0.150
    43.722   494.742     0.150
    76.199   711.844     0.150
    82.979   741.742     0.150
    82.979   742.344     0.150
     9.046   138.117     0.150
    37.157   433.219     0.150
    83.130   743.316     0.150
    83.130   743.918     0.150
    21.926   296.941     0.150
    81.169   737.742     0.150
    82.933   743.340     0.150
    82.933   743.742     0.150
    83.356   745.441     0.150
     0.758    26.641     0.150
     2.960    53.641     0.150
    21.571   286.938     0.150
    80.590   735.641     0.150
    80.590   733.742     0.150
    82.778   745.438     0.150
    83.216   744.742     0.150
     3.271    45.184     0.150
     6.259   101.184     0.150
     6.259   167.184     0.150
    21.545   286.684     0.150
    45.452   501.883     0.150
     6.688   107.504     0.150
     6.688   179.402     0.150
    29.830   369.801     0.150
    39.339   453.301     0.150
    44.511   489.102     0.150
    45.853   501.203     0.150
    75.921   710.801     0.150
    83.348   743.602     0.150
     2.327    42.500     0.150
     2.327    72.898     0.150
     2.787    36.598     0.150
     6.556   101.898     0.150
     6.556   177.098     0.150
     6.912   109.898     0.150
     8.864   132.500     0.150
     8.864   233.898     0.150
    10.521   154.898     0.150
    12.754   181.000     0.150
    15.671   493.898     0.150
    16.169   215.898     0.150
    16.169   435.898     0.150
    16.129   227.699     0.150
    17.981   253.398     0.150
    18.429   440.398     0.150
    18.429   447.398     0.150
    19.357   266.898     0.150
    19.357   482.898     0.150
    20.389   277.898     0.150
    20.389   492.398     0.150
    21.701   292.598     0.150
    21.760   335.898     0.150
    21.760   291.098     0.150
    21.760   335.898     0.150
    21.760   529.699     0.150
    22.139   294.898     0.150
    22.407   334.898     0.150
    22.407   300.898     0.150
    22.407   326.898     0.150
    22.407   334.898     0.150
    23.299   355.898     0.150
    23.299   308.898     0.150
    23.299   355.898     0.150
    23.747    20.000     0.150
    27.056     9.500     0.150
    27.056   344.398     0.150
    27.056    28.000     0.150
    28.532   420.898     0.150
    28.532   356.898     0.150
    28.532   420.898     0.150
    28.532   546.898     0.150
    31.296   381.398     0.150
    36.326   425.898     0.150
    37.076   429.898     0.150
    37.120   430.297     0.150
    37.120   571.098     0.150
    38.148   440.398     0.150
    39.162   447.898     0.150
    39.298   449.000     0.150
    45.451   501.797     0.150
    58.158   591.598     0.150
    73.942   689.000     0.150
    99.910   820.699     0.150
     3.973    62.234     0.150
     4.865    72.834     0.150
     4.865   128.834     0.150
     6.730   102.234     0.150
     6.730   102.234     0.150
     6.730   102.234     0.150
     9.495   127.234     0.150
     9.495   230.234     0.150
    11.090   161.714     0.150
    17.284   244.784     0.150
    18.036   253.634     0.150
    20.413   495.234     0.150
    29.809   364.834     0.150
     4.062    68.945     0.150
     5.416    66.445     0.150
     5.416   135.445     0.150
     6.038   112.148     0.150
     6.653   101.445     0.150
     8.343   119.445     0.150
     8.932   304.883     0.150
     8.932   305.125     0.150
     8.856   130.445     0.150
     8.856   227.445     0.150
     9.007   258.445     0.150
    11.344   285.125     0.150
    12.930   347.148     0.150
    12.930   347.352     0.150
    16.200   556.445     0.150
    16.336   228.945     0.150
    16.336   466.945     0.150
    18.651   253.445     0.150
    18.651   452.445     0.150
    21.835   290.047     0.150
    21.835   534.648     0.150
    22.104   298.445     0.150
    22.104   317.445     0.150
    22.129   537.445     0.150
    22.129   292.445     0.150
    22.129   537.445     0.150
    23.165   312.344     0.150
    23.165   338.445     0.150
    23.165   312.344     0.150
    23.237   340.445     0.150
    23.237   306.445     0.150
    23.237   340.445     0.150
    23.245   305.344     0.150
    23.975     4.500     0.150
    23.975     7.703     0.150
    28.661   356.242     0.150
    30.200   367.547     0.150
    30.324   371.242     0.150
    31.032   447.453     0.150
    31.032   376.047     0.150
    31.032   448.242     0.150
    31.032   686.445     0.150
    35.317   413.547     0.150
    35.830   417.344     0.150
    38.854   445.984     0.150
    38.918   443.945     0.150
    39.045   444.242     0.150
    43.119   477.016     0.150
    45.189   493.734     0.150
    45.558   496.648     0.150
    46.207   504.398     0.150
    47.116   510.344     0.150
    47.659   514.844     0.150
    47.867   518.148     0.150
    48.126   518.648     0.150
    48.230   520.547     0.150
    48.230   520.547     0.150
    48.455   521.047     0.150
    48.538   521.148     0.150
    48.538   521.242     0.150
    48.680   522.945     0.150
    48.690   522.945     0.150
    48.811   524.945     0.150
    48.938   524.742     0.150
    49.135   526.844     0.150
    49.632   531.242     0.150
    50.248   535.344     0.150
    50.322   535.445     0.150
    50.453   535.945     0.150
    50.598   536.742     0.150
    50.598   536.742     0.150
    50.754   538.148     0.150
    51.137   542.648     0.150
    51.143   542.547     0.150
    51.630   545.148     0.150
    52.039   548.344     0.150
    52.877   555.344     0.150
    53.203   557.844     0.150
    53.729   561.648     0.150
    56.113   576.344     0.150
    81.484   735.742     0.150
    83.140   742.844     0.150
     2.245    42.043     0.150
     2.245    42.004     0.150
     2.245    71.703     0.150
     3.895   116.504     0.150
     3.935   -23.496     0.150
     4.632    76.004     0.150
     4.632   148.805     0.150
     4.764    64.805     0.150
     6.321    97.504     0.150
     6.752   163.504     0.150
     7.469   239.504     0.150
     8.800   295.926     0.150
     8.800   296.484     0.150
     8.650   128.504     0.150
     8.650   227.004     0.150
    11.436   310.652     0.150
    11.436   311.055     0.150
    15.894     5.000     0.150
    15.894   242.504     0.150
    16.306   230.004     0.150
    16.306   244.203     0.150
    16.306   252.402     0.150
    16.306   441.004     0.150
    17.556   482.504     0.150
    18.517   331.504     0.150
    19.294   611.504     0.150
    19.130   261.004     0.150
    19.130   261.004     0.150
    19.130   475.504     0.150
    19.498   632.805     0.150
    20.226   491.004     0.150
    21.606   289.203     0.150
    21.940   678.395     0.150
    23.218   348.805     0.150
    23.218   592.504     0.150
    23.218   306.504     0.150
    23.218   348.805     0.150
    23.218   558.504     0.150
    23.218   592.504     0.150
    23.347   308.504     0.150
    23.347   333.504     0.150
    23.321   307.305     0.150
    23.588   322.805     0.150
    23.588   313.203     0.150
    23.588     9.602     0.150
    26.859     9.500     0.150
    26.859    14.500     0.150
    27.493   347.605     0.150
    28.296   353.902     0.150
    28.322   350.504     0.150
    29.128    10.301     0.150
    29.576   365.504     0.150
    29.726   771.004     0.150
    29.726   366.605     0.150
    30.598   375.902     0.150
    31.021   374.902     0.150
    31.021   374.902     0.150
    31.021   676.703     0.150
    31.265   379.805     0.150
    35.759   421.504     0.150
    35.759   421.504     0.150
    36.110   422.805     0.150
    36.841   427.004     0.150
    36.841   769.805     0.150
    36.887   428.902     0.150
    38.018   440.402     0.150
    38.226   442.203     0.150
    38.306   441.402     0.150
    39.102   447.004     0.150
    39.110    16.102     0.150
    39.110   447.402     0.150
    39.110    16.102     0.150
    39.933   456.402     0.150
    42.509   490.652     0.150
    43.313   482.703     0.150
    43.313     5.500     0.150
    43.313   581.504     0.150
    43.593   484.004     0.150
    43.678   487.504     0.150
    43.678   486.004     0.150
    43.734   490.914     0.150
    43.973   591.004     0.150
    43.973   487.004     0.150
    43.973   591.004     0.150
    44.128   490.043     0.150
    44.264   541.504     0.150
    44.264   613.504     0.150
    45.163   499.203     0.150
    45.163   499.203     0.150
    45.163   499.203     0.150
    45.351   505.344     0.150
    45.517   608.504     0.150
    45.517   655.504     0.150
    45.517   497.105     0.150
    45.517   595.504     0.150
    45.517   608.504     0.150
    45.517   900.504     0.150
    46.324   507.004     0.150
    46.603   507.004     0.150
    47.048   511.754     0.150
    47.309   513.504     0.150
    47.309     9.000     0.150
    48.296   522.504     0.150
    48.752   527.676     0.150
    49.161   530.574     0.150
    49.543   529.805     0.150
    49.690   530.035     0.150
    49.690   534.215     0.150
    53.980    15.102     0.150
    53.980   562.703     0.150
    53.980    15.102     0.150
    54.654   567.703     0.150
    56.555   582.004     0.150
    60.518   607.902     0.150
    61.446   622.504     0.150
    74.497   699.504     0.150
    74.574   700.133     0.150
    74.886   701.793     0.150
    76.250   706.605     0.150
    83.064   743.902     0.150
   139.037  1168.305     0.150
   149.061  1188.703     0.150
     1.201    34.854     0.150
     5.354    76.453     0.150
     6.356   100.453     0.150
     7.450   239.754     0.150
     8.788   120.453     0.150
    14.477   200.924     0.150
    14.935   206.453     0.150
    15.812   152.633     0.150
    15.882   225.453     0.150
    23.517     4.000     0.150
    23.332   351.453     0.150
    23.608   322.553     0.150
    23.608   327.854     0.150
    23.608   348.354     0.150
    23.608   355.453     0.150
    49.245   530.260     0.150
     5.338    88.330     0.150
     7.718   113.920     0.150
    16.325     8.000     0.150
    18.521   451.330     0.150
    20.216   458.330     0.150
    20.252   278.830     0.150
    20.252   492.330     0.150
    23.204   322.330     0.150
    23.311   315.330     0.150
    23.311   350.330     0.150
    23.622   328.631     0.150
    29.686   368.773     0.150
     3.872    69.984     0.150
     6.949    97.023     0.150
     7.190   100.703     0.150
     7.515   194.891     0.150
     7.515   195.172     0.150
     7.937   202.328     0.150
     8.394   264.984     0.150
     8.350   123.953     0.150
     8.650   128.352     0.150
     8.739   129.461     0.150
     8.874   130.586     0.150
     9.026   133.031     0.150
     9.348   306.844     0.150
     9.348   307.062     0.150
     9.170   135.688     0.150
     9.431   138.844     0.150
     9.609   141.141     0.150
     9.617   141.555     0.150
    13.680   336.508     0.150
    14.538   203.086     0.150
    14.538   357.086     0.150
    14.939   204.703     0.150
    14.939   205.602     0.150
    14.939   364.133     0.150
    15.690   382.188     0.150
    15.811   401.984     0.150
    15.811   421.281     0.150
    15.811   434.281     0.150
    15.811   510.086     0.150
    16.536   232.984     0.150
    16.422   231.484     0.150
    16.422    11.500     0.150
    17.581   246.281     0.150
    17.982     6.602     0.150
    17.982   248.883     0.150
    18.112   248.984     0.150
    18.112   443.484     0.150
    18.792   512.492     0.150
    18.792   586.664     0.150
    18.920   260.328     0.150
    18.920   260.281     0.150
    19.928   263.383     0.150
    21.424   290.484     0.150
    21.694   304.781     0.150
    22.542   315.984     0.150
    23.694   535.984     0.150
    23.694   622.984     0.150
    23.939    12.297     0.150
    27.203    10.000     0.150
    27.203    13.500     0.150
    27.549   340.781     0.150
    28.414   407.781     0.150
    29.257    13.398     0.150
    29.257    19.102     0.150
    29.698   364.102     0.150
    30.444   372.383     0.150
    31.950   384.586     0.150
    31.950    10.398     0.150
    31.950   555.984     0.150
    33.010   394.703     0.150
    32.966     7.703     0.150
    36.528   426.281     0.150
    38.978   446.688     0.150
    39.281   448.484     0.150
    39.452   450.781     0.150
    40.194     9.398     0.150
    40.194    14.000     0.150
    39.939   455.391     0.150
    39.939   455.383     0.150
    43.035   859.586     0.150
    42.882   479.688     0.150
    43.211   481.484     0.150
    43.857   487.484     0.150
    43.857   595.281     0.150
    44.057   488.883     0.150
    44.057   591.984     0.150
    44.448   496.984     0.150
    44.448   491.484     0.150
    44.448   496.984     0.150
    44.448   491.484     0.150
    44.448   496.984     0.150
    45.339   499.484     0.150
    45.339   499.484     0.150
    45.339   499.484     0.150
    45.581   499.883     0.150
    45.637   502.086     0.150
    45.637   502.086     0.150
    45.900   502.484     0.150
    46.097   502.883     0.150
    46.086   502.984     0.150
    46.086   502.984     0.150
    46.086   503.281     0.150
    46.616   511.375     0.150
    46.774   508.383     0.150
    46.774   508.383     0.150
    47.003   512.844     0.150
    47.996   526.047     0.150
    48.340   521.383     0.150
    48.443   525.883     0.150
    48.919   526.688     0.150
    49.010   526.688     0.150
    49.136   527.883     0.150
    49.146   528.086     0.150
    49.262   528.086     0.150
    49.401   529.086     0.150
    49.401   529.086     0.150
    50.116   535.086     0.150
    50.116   535.086     0.150
    50.701   539.586     0.150
    50.790   540.086     0.150
    50.918   541.086     0.150
    51.065   542.281     0.150
    51.220   543.484     0.150
    52.094   550.383     0.150
    52.495   553.188     0.150
    52.769   554.688     0.150
    53.159   557.688     0.150
    53.357   559.188     0.150
    53.406   559.984     0.150
    53.613   560.984     0.150
    53.682   561.484     0.150
    54.846   570.383     0.150
    55.255   569.383     0.150
    55.255   569.383     0.150
    55.261   573.086     0.150
    55.527   575.062     0.150
    57.922   590.781     0.150
    59.263   600.055     0.150
    60.882   611.133     0.150
    71.030   677.375     0.150
    76.291   708.281     0.150
    77.145   711.383     0.150
    81.038   734.688     0.150
    83.186   745.984     0.150
    83.620   747.328     0.150
    83.620   747.281     0.150
    89.863   778.281     0.150
   134.737  1158.555     0.150
   134.737  1158.586     0.150
   138.966  1168.281     0.150
    15.459   219.062     0.150
    17.042   238.914     0.150
    17.592   246.797     0.150
    18.001   251.094     0.150
    18.924   260.781     0.150
    18.924   260.797     0.150
    19.543   268.297     0.150
    23.961     8.703     0.150
    23.777   311.594     0.150
    39.274   448.594     0.150
    43.208   481.391     0.150
    44.043   489.297     0.150
    46.078   504.117     0.150
    46.078   504.094     0.150
    76.299   708.992     0.150
    76.849   711.695     0.150
    77.155   712.695     0.150
    81.054   734.594     0.150
    83.626   748.094     0.150
   134.716  1159.617     0.150
   134.716  1159.594     0.150
     4.818    75.309     0.150
     4.961   137.908     0.150
     6.200   174.508     0.150
     6.538   185.948     0.150
     6.538   225.809     0.150
     7.851   269.898     0.150
     7.851   270.738     0.150
     8.148   259.908     0.150
     8.393   123.599     0.150
     8.594   121.618     0.150
     8.696   219.608     0.150
     8.696   128.998     0.150
     8.696   219.639     0.150
    12.749   422.108     0.150
    12.749   422.398     0.150
    16.188   438.908     0.150
    16.230   424.908     0.150
    17.246   243.908     0.150
    17.246   243.968     0.150
    18.106   252.698     0.150
    18.477   439.908     0.150
    18.547   258.548     0.150
    19.166   264.828     0.150
    21.216   290.778     0.150
    21.881   293.858     0.150
    23.433   310.988     0.150
    26.026   337.068     0.150
    27.182   393.208     0.150
    29.327   362.208     0.150
    29.914   370.008     0.150
    29.717   369.758     0.150
    30.270   369.809     0.150
    31.222   382.908     0.150
    74.005   407.809     0.150
    33.919   405.158     0.150
    36.069   418.908     0.150
    38.931   447.533     0.150
    42.377   474.208     0.150
    42.841   479.383     0.150
    43.780   490.108     0.150
    43.780   490.071     0.150
    43.780   594.696     0.150
    45.746   502.108     0.150
    45.746   502.408     0.150
    47.200   516.883     0.150
    47.200   516.878     0.150
    47.854   519.108     0.150
    48.877   527.708     0.150
    48.886   527.508     0.150
    49.007   527.309     0.150
    49.515   531.708     0.150
    50.444   538.708     0.150
    50.444   538.708     0.150
    50.650   540.708     0.150
    50.950   543.008     0.150
    53.145   560.908     0.150
    53.925   565.508     0.150
    54.595   570.008     0.150
    60.574   609.908     0.150
    75.933   707.008     0.150
    76.499   710.358     0.150
    76.804   711.908     0.150
    81.288   737.842     0.150
    81.297   737.508     0.150
    83.251   747.203     0.150
    83.251   747.198     0.150
    83.768   750.578     0.150
   148.724  1190.358     0.150
     6.467    92.805     0.150
     8.328   119.312     0.150
     8.699   127.562     0.150
     8.699   225.062     0.150
    14.626   205.062     0.150
    15.150   215.461     0.150
    16.732   231.262     0.150
    17.402   239.184     0.150
    18.036   250.273     0.150
    18.239   249.965     0.150
    18.500   253.164     0.150
    18.540   253.363     0.150
    18.540   460.262     0.150
    21.287   287.625     0.150
    22.189   517.965     0.150
    22.369    18.102     0.150
    23.358   335.363     0.150
    23.503   335.664     0.150
    23.503   349.363     0.150
    23.503   356.863     0.150
    23.816     5.301     0.150
    23.816     8.500     0.150
    23.816    27.699     0.150
    26.097   331.844     0.150
    29.843   369.512     0.150
    35.252   413.965     0.150
    39.157   444.965     0.150
    42.317   474.465     0.150
    42.317   474.465     0.150
    42.559   472.664     0.150
    43.634   484.465     0.150
    43.916   581.363     0.150
    45.118   494.363     0.150
    45.118   494.363     0.150
    45.118   494.363     0.150
    45.118     8.000     0.150
    45.118   494.363     0.150
    45.118     8.000     0.150
    45.118   593.363     0.150
    45.422   498.363     0.150
    45.422   498.363     0.150
    47.766   512.164     0.150
    48.132   518.664     0.150
    48.496   521.062     0.150
    49.080   525.504     0.150
    49.204   527.062     0.150
    49.896   532.562     0.150
    50.514   536.562     0.150
    50.719   538.164     0.150
    51.019   540.262     0.150
    51.896   547.262     0.150
    52.305   550.465     0.150
    52.588   552.062     0.150
    52.592   552.562     0.150
    53.142   555.562     0.150
    53.214   557.062     0.150
    53.410   557.664     0.150
    53.468   557.965     0.150
    54.029   562.785     0.150
    54.665   567.562     0.150
    55.045   569.562     0.150
    55.071   570.363     0.150
    67.699   655.535     0.150
    72.958   687.664     0.150
    75.989   708.562     0.150
    75.989   708.512     0.150
    75.989   709.691     0.150
    75.949   703.590     0.150
    80.089   729.688     0.150
    80.089   729.684     0.150
    83.275   743.203     0.150
    83.818   746.535     0.150
    85.838   756.785     0.150
   148.774  1186.332     0.150
     8.192   123.547     0.150
     8.192   214.949     0.150
     8.192   123.559     0.150
     8.192   214.957     0.150
     8.249   123.457     0.150
     8.249   215.059     0.150
    14.347   203.258     0.150
    14.581   206.578     0.150
    16.595   233.457     0.150
    16.595   410.359     0.150
    16.752   232.867     0.150
    16.752   232.957     0.150
    17.643   246.559     0.150
    17.687   249.379     0.150
    17.860   247.957     0.150
    18.170   253.039     0.150
    18.170   253.059     0.150
    18.205   252.367     0.150
    18.205   252.359     0.150
    18.279   255.258     0.150
    18.279   453.656     0.150
    18.583   259.758     0.150
    18.818   260.699     0.150
    21.576   293.289     0.150
    22.595   302.258     0.150
    23.245     7.398     0.150
    23.245    10.699     0.150
    23.227   306.258     0.150
    23.227   340.258     0.150
    27.565   341.656     0.150
    27.565   622.957     0.150
    27.997   348.656     0.150
    30.093   368.648     0.150
    32.495   391.297     0.150
    34.093   406.078     0.150
    39.601     9.898     0.150
    39.601    13.000     0.150
    41.790   469.758     0.150
    41.790   469.758     0.150
    45.234   497.758     0.150
    45.775   502.227     0.150
    45.936   501.957     0.150
    47.243   512.059     0.150
    49.134   530.156     0.150
    49.275   531.258     0.150
    50.235   536.859     0.150
    50.886   542.359     0.150
    56.339   581.957     0.150
    56.339   581.957     0.150
    64.421   637.859     0.150
    76.321   707.609     0.150
    82.877   744.699     0.150
     3.525    62.742     0.150
    18.167   252.793     0.150
    21.015   282.863     0.150
    23.059   302.082     0.150
     1.460    44.441     0.150
     8.112   123.953     0.150
     8.141   122.203     0.150
     8.371   126.484     0.150
     8.395   124.812     0.150
     8.395   220.684     0.150
     9.019   134.805     0.150
    12.732   181.352     0.150
    16.608   233.094     0.150
    16.608   411.145     0.150
    21.924   297.852     0.150
    29.521   365.793     0.150
    42.750   478.305     0.150
    45.731   501.172     0.150
    65.525   643.770     0.150
    81.182   737.641     0.150
    83.048   745.398     0.150
     1.477    48.793     0.150
     4.526    73.316     0.150
    23.726   310.754     0.150
     0.868    27.117     0.150
     0.868    15.617     0.150
     0.868    27.148     0.150
     1.623    58.016     0.150
     2.760    48.219     0.150
     4.765    76.016     0.150
     4.765   134.016     0.150
     5.093    77.312     0.150
     6.447   160.516     0.150
     7.142   104.117     0.150
     8.433   126.773     0.150
     8.763   132.719     0.150
     8.763   132.695     0.150
     8.881   131.344     0.150
     8.900   131.203     0.150
     8.900   228.727     0.150
     8.950   132.734     0.150
     8.950   229.977     0.150
     9.129   134.766     0.150
     9.129   134.734     0.150
     9.129   237.961     0.150
     9.288   137.523     0.150
     9.409   138.695     0.150
     9.536   141.469     0.150
     9.708   143.703     0.150
     9.743   142.719     0.150
     9.743   142.805     0.150
    15.399   218.656     0.150
    15.644   219.867     0.150
    15.644   219.867     0.150
    15.644   995.594     0.150
    16.745   439.016     0.150
    16.771   231.516     0.150
    17.653   250.070     0.150
    18.032   252.953     0.150
    18.051   254.953     0.150
    18.201   255.945     0.150
    18.382   252.016     0.150
    18.382   469.016     0.150
    18.382   252.016     0.150
    18.382   469.016     0.150
    18.421   258.906     0.150
    18.449   256.664     0.150
    18.449   256.664     0.150
    18.505   258.570     0.150
    18.821   259.906     0.150
    18.821   471.703     0.150
    18.821   259.906     0.150
    18.821   471.703     0.150
    18.854   260.719     0.150
    19.327   268.211     0.150
    19.604   268.719     0.150
    19.852   273.312     0.150
    20.252   281.102     0.150
    20.957   287.164     0.150
    21.246   289.203     0.150
    21.411   296.016     0.150
    21.760   292.016     0.150
    22.342   297.344     0.150
    22.342   297.344     0.150
    23.041   306.766     0.150
    23.041   306.766     0.150
    23.102   312.352     0.150
    23.580   347.219     0.150
    23.580   621.617     0.150
    24.365     5.500     0.150
    24.365     7.898     0.150
    25.683   333.602     0.150
    25.727   333.172     0.150
    27.656     5.305     0.150
    27.656     8.602     0.150
    27.719   351.406     0.150
    28.562     4.305     0.150
    28.562     7.000     0.150
    28.767   359.938     0.150
    28.767   550.398     0.150
    29.442   365.766     0.150
    29.442   551.617     0.150
    29.743     2.602     0.150
    29.743     3.898     0.150
    29.953   369.289     0.150
    30.000   370.742     0.150
    30.164   554.117     0.150
    30.164   371.469     0.150
    30.164   554.117     0.150
    30.164  1004.617     0.150
    30.091   371.945     0.150
    30.091   552.453     0.150
    30.102   374.609     0.150
    30.245   373.312     0.150
    30.346   373.812     0.150
    30.988   375.219     0.150
    31.208    11.602     0.150
    31.424   379.047     0.150
    32.084     6.805     0.150
    33.213   399.117     0.150
    33.404   491.016     0.150
    33.404   399.016     0.150
    33.404   732.016     0.150
    73.538   403.016     0.150
    73.538   403.016     0.150
    33.811   403.594     0.150
    33.811   480.469     0.150
    33.811   403.594     0.150
    33.811   480.469     0.150
    33.811   788.039     0.150
    33.811   402.773     0.150
    33.811   480.859     0.150
    34.728   413.312     0.150
    34.782   413.719     0.150
    34.812   410.312     0.150
    35.254   422.117     0.150
    35.253   418.133     0.150
    35.636   418.016     0.150
    35.794   428.914     0.150
    36.024   421.812     0.150
    36.308   427.016     0.150
    36.337   422.016     0.150
    36.360   427.414     0.150
    36.932   431.914     0.150
    81.046   433.219     0.150
    81.046   433.219     0.150
    37.206   433.719     0.150
    37.206   433.016     0.150
    37.410   433.312     0.150
    37.402   436.016     0.150
    37.484   434.219     0.150
    37.480   435.719     0.150
    37.559   437.016     0.150
    37.747   439.617     0.150
    37.754   432.719     0.150
    37.764   438.305     0.150
    37.946   973.219     0.150
    37.983   440.117     0.150
    38.155   440.234     0.150
    38.155   528.383     0.150
    38.155   440.914     0.150
    38.225   439.016     0.150
    38.280   443.117     0.150
    38.449   438.117     0.150
    38.514   443.617     0.150
    38.969   447.062     0.150
    38.969   535.969     0.150
    38.969   578.312     0.150
    39.148   447.812     0.150
    39.310   452.219     0.150
    39.510   453.062     0.150
    39.510   546.062     0.150
    39.689   454.016     0.150
    39.689   822.016     0.150
    39.814   454.664     0.150
    40.232   458.914     0.150
    40.365   461.016     0.150
    40.734   463.117     0.150
    40.734   561.117     0.150
    41.119   466.633     0.150
    41.169   468.219     0.150
    41.169   568.812     0.150
    41.336   465.938     0.150
    41.727   471.328     0.150
    41.922   473.438     0.150
    41.922   473.516     0.150
    41.922   575.617     0.150
    42.125   474.812     0.150
    42.222   475.227     0.150
    42.451   477.719     0.150
    42.474   477.133     0.150
    42.651   477.648     0.150
    42.839   480.039     0.150
    42.975   480.164     0.150
    43.046   482.617     0.150
    43.046   582.914     0.150
    43.063   482.414     0.150
    43.063   584.414     0.150
    43.063   872.617     0.150
    43.063  1072.117     0.150
    43.182   483.094     0.150
    43.298   483.695     0.150
    43.420   872.516     0.150
    43.446   485.414     0.150
    43.446   586.414     0.150
    43.446   877.016     0.150
    43.634   486.812     0.150
    43.634   590.016     0.150
    43.634   486.875     0.150
    43.634   485.742     0.150
    43.634   590.664     0.150
    43.705   879.914     0.150
    43.705   591.094     0.150
    43.705   486.914     0.150
    43.705   590.516     0.150
    43.705   879.914     0.150
    43.705  1075.516     0.150
    43.798   487.703     0.150
    43.968   489.242     0.150
    43.968   489.242     0.150
    44.041   490.016     0.150
    44.041   525.016     0.150
    44.041   590.016     0.150
    44.041   593.016     0.150
    44.041   847.016     0.150
    44.041   889.016     0.150
    44.164   490.617     0.150
    44.164   594.812     0.150
    44.402   491.656     0.150
    44.402   596.625     0.150
    44.407   493.719     0.150
    44.537   494.516     0.150
    44.563   493.234     0.150
    44.927   497.617     0.150
    45.115   497.492     0.150
    45.115   497.492     0.150
    45.149   497.656     0.150
    45.149   497.656     0.150
    45.220   500.516     0.150
    45.221   499.273     0.150
    45.351   499.656     0.150
    45.282   499.812     0.150
    45.442   500.445     0.150
    45.469   499.953     0.150
    45.469   499.953     0.150
    45.677   503.203     0.150
    45.674   503.312     0.150
    45.686   501.867     0.150
    45.692   503.414     0.150
    45.753   501.719     0.150
    45.753   501.742     0.150
    45.753   608.992     0.150
    45.755   502.375     0.150
    46.313   908.117     0.150
    46.313  1089.117     0.150
    46.303   506.859     0.150
    46.360   507.672     0.150
    46.410   602.664     0.150
    46.385   506.008     0.150
    46.385   614.172     0.150
    46.403   509.312     0.150
    46.611   510.516     0.150
    46.687   511.367     0.150
    46.687   511.438     0.150
    46.793   512.414     0.150
    47.177   509.812     0.150
    47.228   514.516     0.150
    47.228   514.523     0.150
    47.287   516.117     0.150
    47.503   517.617     0.150
    47.503   517.617     0.150
    47.533   515.172     0.150
    47.639   516.812     0.150
    47.639   516.812     0.150
    47.731   518.914     0.150
    47.881   519.117     0.150
    47.913   520.414     0.150
    47.916   519.719     0.150
    47.916   519.719     0.150
    48.018   521.164     0.150
    48.082   521.719     0.150
    48.082   521.719     0.150
    48.273   522.117     0.150
    48.273   522.117     0.150
    48.355   523.516     0.150
    48.355   523.516     0.150
    48.403   523.719     0.150
    48.403   523.719     0.150
    48.492   525.016     0.150
    48.492   525.016     0.150
    48.503   525.039     0.150
    48.503   640.656     0.150
    48.511   524.016     0.150
    48.511   524.016     0.150
    48.584   524.812     0.150
    48.584   524.812     0.150
    48.615   526.016     0.150
    48.615   526.016     0.150
    48.644   524.062     0.150
    48.697   526.016     0.150
    48.697   526.016     0.150
    48.707   526.016     0.150
    48.707   526.016     0.150
    48.752   527.719     0.150
    48.752   527.719     0.150
    48.794   527.414     0.150
    48.794   527.414     0.150
    48.819   525.516     0.150
    48.819   525.516     0.150
    48.826   526.719     0.150
    48.836   527.719     0.150
    48.921   528.016     0.150
    48.920   527.812     0.150
    48.920   527.812     0.150
    48.968   528.117     0.150
    48.968   528.117     0.150
    49.131   528.219     0.150
    49.131   528.219     0.150
    49.190   529.719     0.150
    49.304   531.219     0.150
    49.304   531.219     0.150
    49.433   695.414     0.150
    49.433  1248.617     0.150
    49.372   531.516     0.150
    49.407   531.812     0.150
    49.407   531.812     0.150
    49.424   531.414     0.150
    49.441   531.312     0.150
    49.441   531.312     0.150
    49.550   532.164     0.150
    49.703   534.117     0.150
    49.703   534.117     0.150
    49.807   533.914     0.150
    50.261   537.516     0.150
    50.261   537.516     0.150
    50.268   537.312     0.150
    50.268   537.273     0.150
    50.363   538.117     0.150
    50.487   539.312     0.150
    50.487   539.312     0.150
    50.637   540.312     0.150
    50.637   540.312     0.150
    50.790   541.414     0.150
    50.790   541.414     0.150
    50.997   543.117     0.150
    51.084   544.617     0.150
    51.173   544.617     0.150
    51.173   544.617     0.150
    51.177   544.312     0.150
    51.177   544.312     0.150
    51.179   544.914     0.150
    51.230   546.016     0.150
    51.230   546.016     0.150
    51.485   546.672     0.150
    51.663   548.414     0.150
    51.663   548.414     0.150
    52.058   551.516     0.150
    52.058   551.516     0.150
    52.324   552.812     0.150
    52.324   552.812     0.150
    52.350   553.719     0.150
    52.350   553.719     0.150
    52.593   554.828     0.150
    52.741   555.914     0.150
    52.741   555.914     0.150
    52.922   557.469     0.150
    52.940   557.312     0.150
    52.940   557.312     0.150
    52.969   558.016     0.150
    52.969   558.016     0.150
    53.134   558.742     0.150
    53.185   559.016     0.150
    53.185   559.016     0.150
    53.263   559.617     0.150
    53.263   559.617     0.150
    53.395   560.641     0.150
    53.400   560.273     0.150
    53.423   559.867     0.150
    53.423   559.867     0.150
    53.423   562.219     0.150
    53.423   562.219     0.150
    53.423   561.914     0.150
    53.583   561.375     0.150
    53.731   562.414     0.150
    53.731   562.414     0.150
    53.878   563.094     0.150
    53.921   564.312     0.150
    53.939   563.039     0.150
    54.180   566.328     0.150
    54.237   566.469     0.150
    54.398   568.414     0.150
    54.398   568.414     0.150
    54.402   568.219     0.150
    54.402   568.219     0.150
    54.576   568.883     0.150
    54.581   569.828     0.150
    54.542   568.867     0.150
    54.559   569.008     0.150
    54.577   568.703     0.150
    54.812   571.219     0.150
    54.812   571.219     0.150
    54.812   571.219     0.150
    54.844   571.312     0.150
    54.844   571.312     0.150
    54.875   571.219     0.150
    54.875   571.219     0.150
    56.709   584.219     0.150
    56.973   709.016     0.150
    56.973   586.078     0.150
    56.973   709.055     0.150
    57.758   592.664     0.150
    57.833   592.289     0.150
    57.833   590.469     0.150
    58.158   594.953     0.150
    58.247   592.516     0.150
    58.841   600.117     0.150
    60.191   610.867     0.150
    61.183   615.719     0.150
    61.183   615.516     0.150
    61.265   615.719     0.150
    62.973   627.797     0.150
    62.973   767.117     0.150
    64.862   638.617     0.150
    71.159   676.945     0.150
    73.768   694.289     0.150
    74.202   697.805     0.150
    74.155   696.414     0.150
    75.465   705.438     0.150
    75.465   705.492     0.150
    76.906   712.867     0.150
    77.209   713.219     0.150
    77.209  1859.969     0.150
    77.632   715.992     0.150
    77.632   892.758     0.150
    79.089   724.039     0.150
    79.402   725.539     0.150
    79.419   725.875     0.150
    81.485   738.094     0.150
    81.485  1349.266     0.150
    81.485  1852.844     0.150
    81.494   738.195     0.150
    81.631   739.016     0.150
    83.574   748.258     0.150
    83.574  1844.914     0.150
    83.574  2334.312     0.150
    83.623   749.266     0.150
    83.623  1372.016     0.150
    83.623  1848.016     0.150
    83.623  2336.367     0.150
    90.329   781.641     0.150
    90.333   781.234     0.150
    94.088   798.516     0.150
    94.088  1026.266     0.150
    94.995   803.219     0.150
   103.405  1101.117     0.150
   107.328  1109.969     0.150
   107.328  1783.469     0.150
   116.529  1126.555     0.150
   116.529  1753.867     0.150
   123.496  1136.516     0.150
    34.649  1151.172     0.150
   134.263  1158.492     0.150
   134.756  1162.867     0.150
   138.484  1168.141     0.150
   148.222  1185.688     0.150
   148.222  1719.812     0.150
     0.887    34.398     0.150
     0.887    16.008     0.150
     0.887    34.422     0.150
     1.609    56.000     0.150
     4.745    76.000     0.150
     4.745   135.000     0.150
     5.076    77.500     0.150
     6.748    99.203     0.150
     7.159   104.102     0.150
     7.159   173.797     0.150
     8.787   133.938     0.150
     8.976   132.719     0.150
     8.976   231.531     0.150
     9.154   135.320     0.150
     9.154   238.297     0.150
     9.766   143.562     0.150
    10.337   151.797     0.150
    15.665   221.672     0.150
    15.665   221.602     0.150
    16.741   231.602     0.150
    16.758   243.602     0.150
    16.758   442.000     0.150
    16.758   527.000     0.150
    18.352   253.000     0.150
    18.352   464.500     0.150
    18.352   253.000     0.150
    18.352   464.500     0.150
    18.479   257.328     0.150
    18.479   257.328     0.150
    18.851   261.711     0.150
    18.851   261.703     0.150
    20.976   286.398     0.150
    21.267   289.539     0.150
    21.432   296.578     0.150
    21.781   298.719     0.150
    22.366   297.977     0.150
    22.366   297.977     0.150
    23.064   309.633     0.150
    23.064   309.625     0.150
    23.610   348.500     0.150
    24.368     3.500     0.150
    24.368     5.500     0.150
    24.368    37.805     0.150
    25.744   333.898     0.150
    26.890   339.703     0.150
    27.655   352.297     0.150
    27.655     4.203     0.150
    27.655     6.805     0.150
    27.655   403.398     0.150
    27.730   350.664     0.150
    28.555     4.297     0.150
    28.555     7.000     0.150
    28.778   360.602     0.150
    28.778   550.625     0.150
    29.460   366.000     0.150
    29.460   550.156     0.150
    29.731   370.898     0.150
    29.934   369.719     0.150
    29.934   366.602     0.150
    29.934   372.898     0.150
    29.938   369.797     0.150
    29.938   373.500     0.150
    30.008   370.828     0.150
    30.145   371.898     0.150
    30.358   373.820     0.150
    30.797   376.703     0.150
    32.425   706.797     0.150
    73.540   403.703     0.150
    73.540   403.703     0.150
    33.755   404.000     0.150
    33.837   404.000     0.150
    33.837   404.000     0.150
    33.837   403.969     0.150
    34.213   416.398     0.150
    34.751   413.398     0.150
    34.804   414.203     0.150
    35.837   417.703     0.150
    81.072   433.898     0.150
    81.072   433.797     0.150
    37.502   436.797     0.150
    37.514   434.398     0.150
    37.582   437.297     0.150
    37.789   439.102     0.150
    37.789   440.797     0.150
    37.970   447.000     0.150
    37.970   454.797     0.150
    38.007   441.203     0.150
    38.182   441.602     0.150
    38.182   441.594     0.150
    38.182   526.789     0.150
    38.182   441.797     0.150
    38.182   442.898     0.150
    38.302   443.703     0.150
    38.538   447.000     0.150
    38.999   447.547     0.150
    38.999   578.047     0.150
    39.177   448.398     0.150
    39.334   452.797     0.150
    39.534   453.391     0.150
    39.714   454.859     0.150
    39.714   454.898     0.150
    40.256   460.297     0.150
    40.759   463.398     0.150
    41.143   466.977     0.150
    41.143   467.000     0.150
    41.193   469.000     0.150
    41.565   468.797     0.150
    41.565   471.797     0.150
    41.947   473.922     0.150
    41.947   473.898     0.150
    41.982   476.203     0.150
    42.150   475.602     0.150
    42.246   475.492     0.150
    42.682   479.344     0.150
    42.682   478.500     0.150
    42.862   480.703     0.150
    43.006   480.398     0.150
    43.071   482.500     0.150
    43.088   482.703     0.150
    43.322   484.117     0.150
    43.471   485.898     0.150
    43.471   593.797     0.150
    43.471   867.000     0.150
    43.471   485.898     0.150
    43.658   487.500     0.150
    43.658   486.602     0.150
    43.658   592.203     0.150
    43.730   486.070     0.150
    43.730   591.703     0.150
    44.066   490.203     0.150
    44.066   490.297     0.150
    44.066   504.000     0.150
    44.432   493.203     0.150
    44.430   492.109     0.150
    44.586   494.289     0.150
    44.952   497.602     0.150
    45.138   497.891     0.150
    45.138   497.891     0.150
    45.244   500.602     0.150
    45.492   500.141     0.150
    45.492   500.141     0.150
    45.700   503.398     0.150
    45.718   502.898     0.150
    45.778   502.758     0.150
    45.781   502.398     0.150
    46.326   507.344     0.150
    46.334   596.203     0.150
    46.334   610.297     0.150
    46.430   512.703     0.150
    46.430   512.703     0.150
    46.673   508.891     0.150
    46.635   509.898     0.150
    47.189   511.203     0.150
    47.252   513.930     0.150
    47.660   517.102     0.150
    47.660   517.102     0.150
    47.660   517.102     0.150
    47.940   520.602     0.150
    47.940   520.602     0.150
    48.042   519.203     0.150
    48.042   519.148     0.150
    48.297   522.297     0.150
    48.297   522.297     0.150
    48.528   525.797     0.150
    48.528   525.273     0.150
    48.533   524.000     0.150
    48.533   524.000     0.150
    48.608   525.102     0.150
    48.608   525.102     0.150
    48.720   526.297     0.150
    48.720   526.297     0.150
    48.730   526.203     0.150
    48.730   526.203     0.150
    48.842   525.297     0.150
    48.842   525.297     0.150
    48.848   529.398     0.150
    48.848   529.367     0.150
    48.945   528.203     0.150
    48.992   528.500     0.150
    48.992   528.500     0.150
    49.152   528.500     0.150
    49.152   528.500     0.150
    49.296   530.398     0.150
    49.296   530.398     0.150
    49.329   531.703     0.150
    49.329   531.703     0.150
    49.396   531.703     0.150
    49.430   532.000     0.150
    49.430   532.000     0.150
    49.448   531.797     0.150
    49.445  1250.203     0.150
    49.728   534.703     0.150
    49.728   534.703     0.150
    49.829   534.500     0.150
    50.284   537.898     0.150
    50.284   537.898     0.150
    50.291   537.602     0.150
    50.291   537.609     0.150
    50.386   538.297     0.150
    50.511   539.602     0.150
    50.511   539.602     0.150
    50.660   540.602     0.150
    50.660   540.602     0.150
    50.705   542.602     0.150
    50.814   541.797     0.150
    50.814   541.797     0.150
    51.019   543.602     0.150
    51.201   544.703     0.150
    51.201   544.703     0.150
    51.203   545.203     0.150
    51.686   548.797     0.150
    51.686   548.797     0.150
    52.080   551.602     0.150
    52.080   551.602     0.150
    52.346   553.203     0.150
    52.346   553.203     0.150
    52.766   556.203     0.150
    52.766   556.203     0.150
    52.965   557.703     0.150
    52.965   557.703     0.150
    52.992   558.297     0.150
    52.992   558.297     0.150
    53.208   559.297     0.150
    53.208   559.297     0.150
    53.287   560.000     0.150
    53.287   560.000     0.150
    53.753   563.703     0.150
    53.753   563.703     0.150
    54.424   568.602     0.150
    54.424   568.602     0.150
    54.423   568.602     0.150
    54.423   568.602     0.150
    54.581   569.648     0.150
    54.586   569.516     0.150
    54.834   571.602     0.150
    54.834   571.602     0.150
    54.834   571.602     0.150
    54.868   571.703     0.150
    54.868   571.703     0.150
    54.899   572.398     0.150
    54.899   572.398     0.150
    54.899   572.398     0.150
    56.740   584.102     0.150
    56.984   586.594     0.150
    57.854   591.602     0.150
    58.871   601.398     0.150
    61.204   615.297     0.150
    61.286   615.297     0.150
    63.004   629.078     0.150
    63.265   629.906     0.150
    64.869   639.016     0.150
    71.140   679.727     0.150
    73.775   694.398     0.150
    74.161   696.102     0.150
    75.448   705.352     0.150
    76.328   709.602     0.150
    76.932   713.117     0.150
    77.236   713.281     0.150
    77.658   716.656     0.150
    79.428   727.297     0.150
    79.428   727.281     0.150
    79.444   726.859     0.150
    81.463   738.328     0.150
    81.472   738.188     0.150
    81.656   737.828     0.150
    83.600   749.453     0.150
    83.603   748.547     0.150
    83.915   750.727     0.150
    90.310   781.703     0.150
    91.199   788.203     0.150
    94.064   798.773     0.150
   103.435  1100.648     0.150
   123.466  1136.273     0.150
   128.633  1151.266     0.150
   132.623  1156.281     0.150
   134.268  1159.172     0.150
   138.499  1168.297     0.150
   145.024  1177.078     0.150
     4.215    61.334     0.150
     7.672   107.334     0.150
     8.624   210.727     0.150
     8.624   238.027     0.150
     9.059   126.990     0.150
    18.542   254.672     0.150
    21.659   287.135     0.150
     0.859    28.926     0.150
     0.859    15.445     0.150
     0.859    28.955     0.150
     5.109    76.926     0.150
     5.109   132.025     0.150
     7.201   106.025     0.150
     7.201   107.525     0.150
     7.201   109.525     0.150
     7.201   185.525     0.150
     8.491   126.295     0.150
     8.940   133.246     0.150
     8.951   132.426     0.150
     8.951   131.986     0.150
     8.951   232.775     0.150
     9.008   133.955     0.150
     9.008   234.006     0.150
     9.187   136.426     0.150
     9.187   135.775     0.150
     9.187   239.406     0.150
     9.187   135.826     0.150
     9.347   139.086     0.150
     9.468   141.186     0.150
     9.594   141.445     0.150
     9.752   133.025     0.150
     9.766   144.746     0.150
     9.802   143.926     0.150
     9.847   136.525     0.150
    10.610   263.525     0.150
    11.409   295.525     0.150
    14.026   199.625     0.150
    14.774   206.326     0.150
    15.704   220.996     0.150
    16.802    10.699     0.150
    16.802   523.525     0.150
    16.823   236.025     0.150
    18.353   462.525     0.150
    18.480   256.008     0.150
    18.480   256.846     0.150
    18.480   256.850     0.150
    18.494   258.365     0.150
    18.581   257.486     0.150
    18.871   261.725     0.150
    18.871   261.836     0.150
    18.871   261.838     0.150
    18.903   262.025     0.150
    18.903   261.975     0.150
    18.903   476.055     0.150
    19.603   270.426     0.150
    21.240   287.307     0.150
    22.401   298.025     0.150
    22.401   544.906     0.150
    22.401   298.025     0.150
    22.401   544.906     0.150
    23.040   307.955     0.150
    23.040   307.951     0.150
    23.246   341.426     0.150
    23.618   350.125     0.150
    23.618   619.326     0.150
    24.414     3.500     0.150
    24.414     6.500     0.150
    24.414    36.500     0.150
    24.414   581.025     0.150
    25.251   370.725     0.150
    25.711   334.225     0.150
    25.845   335.725     0.150
    27.008   346.225     0.150
    27.107   622.225     0.150
    27.170   346.225     0.150
    27.648   350.926     0.150
    27.665   352.826     0.150
    27.691   349.916     0.150
    27.691   349.912     0.150
    27.708   351.525     0.150
    28.211   355.426     0.150
    28.211   356.326     0.150
    28.347   357.125     0.150
    28.384   356.326     0.150
    28.598     4.199     0.150
    28.598     7.000     0.150
    28.740   360.225     0.150
    29.197   362.725     0.150
    29.429   366.275     0.150
    29.429   550.676     0.150
    29.429   366.275     0.150
    29.429   550.676     0.150
    29.394   371.826     0.150
    29.967   370.076     0.150
    29.964   370.586     0.150
    29.964   372.525     0.150
    30.175   372.375     0.150
    30.175   430.176     0.150
    30.175   372.375     0.150
    30.175   430.176     0.150
    30.356   381.525     0.150
    30.403   374.305     0.150
    30.403   374.305     0.150
    30.403   553.125     0.150
    30.842   377.436     0.150
    33.446   402.225     0.150
    73.496   403.725     0.150
    73.496   403.725     0.150
    33.819   404.156     0.150
    33.819   483.256     0.150
    33.819   404.150     0.150
    33.819   483.250     0.150
    33.819   403.725     0.150
    34.727   414.125     0.150
    34.780   414.525     0.150
    35.839   421.926     0.150
    35.910   423.525     0.150
    36.007   423.225     0.150
    36.938   432.725     0.150
    36.946   433.326     0.150
    37.199   434.625     0.150
    37.477   436.725     0.150
    37.512   436.125     0.150
    37.512   436.125     0.150
    37.559   437.326     0.150
    37.769   439.025     0.150
    37.949   452.525     0.150
    37.949   457.525     0.150
    37.986   441.225     0.150
    38.278   443.625     0.150
    38.699   447.426     0.150
    38.994   448.525     0.150
    38.994   578.096     0.150
    38.994   448.525     0.150
    38.994   578.098     0.150
    39.138   450.125     0.150
    39.173   449.326     0.150
    39.314   452.025     0.150
    39.501   442.725     0.150
    39.512   454.426     0.150
    39.512   454.326     0.150
    39.694   454.225     0.150
    40.739   463.826     0.150
    41.123   467.625     0.150
    41.123   467.625     0.150
    41.327   465.326     0.150
    41.625   471.025     0.150
    41.928   473.525     0.150
    42.131   475.426     0.150
    42.455   477.326     0.150
    42.686   477.326     0.150
    43.009   480.875     0.150
    43.009   591.875     0.150
    43.009   480.875     0.150
    43.009   591.875     0.150
    43.068   494.926     0.150
    43.068   483.025     0.150
    43.068   586.725     0.150
    43.453   485.625     0.150
    43.453   869.525     0.150
    43.453  1064.525     0.150
    43.474     9.000     0.150
    43.474   871.326     0.150
    43.637   498.725     0.150
    43.637   486.805     0.150
    43.637   498.766     0.150
    43.637   487.055     0.150
    43.637   487.051     0.150
    43.637   591.125     0.150
    43.709   495.326     0.150
    43.709   487.426     0.150
    43.709   586.025     0.150
    44.048   490.326     0.150
    44.048     4.199     0.150
    44.048   596.525     0.150
    44.413   493.926     0.150
    45.225   500.346     0.150
    45.774   502.426     0.150
    46.629   511.375     0.150
    46.629   511.801     0.150
    47.231   516.926     0.150
    47.231   516.775     0.150
    47.234   510.326     0.150
    47.634   517.025     0.150
    47.634   517.025     0.150
    47.919   519.426     0.150
    47.919   519.426     0.150
    48.021   521.756     0.150
    48.276   522.426     0.150
    48.276   522.426     0.150
    48.498   525.895     0.150
    48.508   526.025     0.150
    48.508   526.025     0.150
    48.508   524.125     0.150
    48.508   524.125     0.150
    48.587   524.826     0.150
    48.587   524.826     0.150
    48.697   526.125     0.150
    48.697   526.125     0.150
    48.707   526.125     0.150
    48.707   526.125     0.150
    48.818   527.025     0.150
    48.818   527.025     0.150
    48.824   527.564     0.150
    48.925   528.225     0.150
    48.969   528.225     0.150
    48.969   528.225     0.150
    49.375   531.525     0.150
    49.406   530.826     0.150
    49.406   530.826     0.150
    49.428   531.625     0.150
    49.457   531.826     0.150
    49.709   534.525     0.150
    49.709   534.525     0.150
    50.041   536.875     0.150
    50.260   537.725     0.150
    50.260   537.725     0.150
    50.365   538.426     0.150
    50.488   539.525     0.150
    50.488   539.525     0.150
    50.638   540.426     0.150
    50.638   540.426     0.150
    50.792   541.625     0.150
    50.792   541.625     0.150
    50.994   543.426     0.150
    51.664   548.525     0.150
    51.664   548.525     0.150
    52.057   551.525     0.150
    52.057   551.525     0.150
    52.321   553.025     0.150
    52.321   553.025     0.150
    52.350   553.926     0.150
    52.350   553.926     0.150
    52.746   556.025     0.150
    52.746   556.025     0.150
    52.945   557.725     0.150
    52.945   557.725     0.150
    52.969   557.826     0.150
    52.969   557.826     0.150
    53.187   559.426     0.150
    53.187   559.426     0.150
    53.267   559.826     0.150
    53.267   559.826     0.150
    53.437   561.385     0.150
    54.399   569.625     0.150
    54.399   569.625     0.150
    54.402   568.725     0.150
    54.402   568.725     0.150
    54.627   569.875     0.150
    54.632   570.256     0.150
    54.632   570.250     0.150
    54.848   571.426     0.150
    54.848   571.426     0.150
    54.879   571.525     0.150
    54.879   571.525     0.150
    56.946   586.865     0.150
    57.827   592.053     0.150
    61.178   616.326     0.150
    61.260   616.426     0.150
    62.252   620.795     0.150
    62.252   620.801     0.150
    63.010   629.105     0.150
    63.221   630.156     0.150
    64.827   638.750     0.150
    72.369   688.445     0.150
    73.732   694.576     0.150
    73.732   694.500     0.150
    74.119   696.525     0.150
    74.119   696.525     0.150
    75.406   705.064     0.150
    76.354   709.416     0.150
    76.962   712.875     0.150
    77.266   713.576     0.150
    77.266   713.576     0.150
    77.689   717.266     0.150
    79.459   726.105     0.150
    81.488   738.346     0.150
    81.488   738.350     0.150
    81.497   738.096     0.150
    83.625   748.965     0.150
    83.625   748.971     0.150
    83.623   749.525     0.150
    83.917   750.750     0.150
    90.343   781.625     0.150
    92.944   794.695     0.150
    94.086   799.996     0.150
    95.039   803.045     0.150
    95.039   803.051     0.150
   103.454  1101.625     0.150
   107.381  1110.150     0.150
   116.574  1126.176     0.150
   116.574  1126.176     0.150
   116.574  1753.451     0.150
   123.457  1136.475     0.150
   128.616  1150.562     0.150
   132.586  1157.605     0.150
   134.225  1158.775     0.150
   134.225  1158.775     0.150
   138.464  1168.205     0.150
   138.464  1168.650     0.150
   148.171  1186.875     0.150
   148.171  1186.875     0.150
     6.646    96.799     0.150
     8.542   125.379     0.150
     8.676   128.569     0.150
     8.676   127.729     0.150
     8.676   226.069     0.150
    13.757   194.699     0.150
    15.158   392.129     0.150
    15.890   226.289     0.150
    16.247    10.100     0.150
    16.247   427.799     0.150
    16.247   521.099     0.150
    17.073   413.449     0.150
    17.223   435.089     0.150
    17.308   418.539     0.150
    17.501   424.649     0.150
    18.287   252.599     0.150
    18.287   454.499     0.150
    18.470   254.899     0.150
    18.470   459.999     0.150
    18.540   448.199     0.150
    18.540   254.699     0.150
    19.605   475.619     0.150
    19.923   478.919     0.150
    20.059   478.639     0.150
    20.878   283.746     0.150
    21.145   287.989     0.150
    21.399   289.649     0.150
    21.498   291.534     0.150
    21.881   291.399     0.150
    21.881   530.099     0.150
    22.263   299.707     0.150
    22.263   299.799     0.150
    22.508   301.710     0.150
    23.159   305.799     0.150
    23.361   308.499     0.150
    23.909     4.200     0.150
    23.909     7.000     0.150
    25.385     7.800     0.150
    25.385   657.599     0.150
    25.958   335.599     0.150
    25.958   335.599     0.150
    27.222   396.099     0.150
    27.222   722.699     0.150
    27.229     4.000     0.150
    27.229     6.500     0.150
    28.044   351.699     0.150
    28.191     4.100     0.150
    29.181   366.399     0.150
    29.769   371.499     0.150
    29.772   371.399     0.150
    29.851   367.999     0.150
    29.985   367.699     0.150
    31.348   389.899     0.150
    31.630   392.899     0.150
    31.670     7.000     0.150
    32.739   399.699     0.150
    33.334   398.899     0.150
    33.498   717.699     0.150
    33.498   824.699     0.150
    33.498   399.699     0.150
    33.498   411.699     0.150
    33.498   717.699     0.150
    33.580   400.699     0.150
    33.834   402.999     0.150
    33.850   402.899     0.150
    33.844   410.799     0.150
    34.841   412.599     0.150
    34.894   413.099     0.150
    35.359   420.299     0.150
    35.367   415.799     0.150
    35.295   422.999     0.150
    35.372   417.799     0.150
    35.385   415.199     0.150
    35.619   415.699     0.150
    35.619   747.699     0.150
    35.619   914.699     0.150
    35.798   425.299     0.150
    35.996   422.099     0.150
    36.000   422.099     0.150
    36.259   423.899     0.150
    36.901   431.699     0.150
    36.993   429.599     0.150
    80.611   432.499     0.150
    80.611   432.499     0.150
    37.216   431.499     0.150
    37.277   432.099     0.150
    37.397   432.499     0.150
    37.404   433.399     0.150
    37.600   434.799     0.150
    37.660   437.199     0.150
    37.722   434.899     0.150
    37.734   434.199     0.150
    38.022   454.899     0.150
    38.054   439.199     0.150
    38.129   439.099     0.150
    38.154   438.399     0.150
    38.220   439.499     0.150
    38.760   449.199     0.150
    38.853   444.799     0.150
    38.822   443.999     0.150
    38.921   443.999     0.150
    39.271   454.699     0.150
    39.315   442.499     0.150
    39.366   447.899     0.150
    39.376   450.899     0.150
    39.473   450.299     0.150
    39.596   451.249     0.150
    39.760   451.499     0.150
    39.744   452.899     0.150
    39.744   452.829     0.150
    39.888   451.099     0.150
    39.909   456.199     0.150
    39.909   544.799     0.150
    39.909   576.199     0.150
    40.311   458.099     0.150
    40.796   461.899     0.150
    41.678   468.899     0.150
    41.977   471.999     0.150
    42.005   472.299     0.150
    42.005   472.299     0.150
    42.178   473.299     0.150
    42.519   476.199     0.150
    42.780   476.799     0.150
    42.965   479.699     0.150
    43.072   480.199     0.150
    43.123   481.199     0.150
    43.123   870.099     0.150
    43.226   478.599     0.150
    43.495   483.899     0.150
    43.495   589.899     0.150
    43.495  1077.699     0.150
    43.708   485.199     0.150
    43.708   591.499     0.150
    43.776   485.799     0.150
    43.776  1082.799     0.150
    43.903   486.229     0.150
    44.084   487.399     0.150
    44.084   492.299     0.150
    44.084    10.300     0.150
    44.084    17.300     0.150
    44.084   604.699     0.150
    44.084   633.699     0.150
    44.084   870.699     0.150
    44.084  1128.699     0.150
    44.936   497.319     0.150
    45.677   499.399     0.150
    45.677   499.399     0.150
    45.952   502.899     0.150
    45.952   598.599     0.150
    46.383   507.499     0.150
    47.185   513.499     0.150
    47.842   522.009     0.150
    48.506  1143.449     0.150
    48.938     9.800     0.150
    48.938    14.000     0.150
    48.938   688.499     0.150
    48.938  1234.299     0.150
    49.288   528.909     0.150
    49.288   528.499     0.150
    50.409  1201.499     0.150
    50.409   536.369     0.150
    54.117   564.199     0.150
    56.472   580.499     0.150
    60.561   617.599     0.150
    60.758   615.499     0.150
    62.757   624.899     0.150
    74.142   695.099     0.150
    75.900   704.799     0.150
    76.784   709.799     0.150
    81.176   733.399     0.150
    83.211   744.399     0.150
   134.646  1157.499     0.150
   138.737  1166.799     0.150
   148.687  1187.199     0.150
     1.149    33.064     0.150
     8.201   121.434     0.150
     9.308   138.959     0.150
    14.564   202.934     0.150
    15.060   213.274     0.150
    41.298   463.414     0.150
    47.161   512.164     0.150
    48.293   517.914     0.150
     1.042    35.137     0.150
     1.042    19.197     0.150
     1.042    35.146     0.150
     4.411    69.537     0.150
     4.411   122.336     0.150
     6.716    97.236     0.150
     8.110   211.836     0.150
     8.543   124.537     0.150
     8.543   221.137     0.150
     8.543   124.777     0.150
     8.543   224.598     0.150
     9.322   136.336     0.150
     9.322   239.336     0.150
    11.302   163.836     0.150
    15.089   213.438     0.150
    15.089   213.396     0.150
    15.217   215.396     0.150
    21.044    21.900     0.150
    21.924   294.986     0.150
    22.203   298.736     0.150
    28.720   356.537     0.150
    29.545   365.336     0.150
    33.765   400.967     0.150
    35.278   414.736     0.150
    35.278   414.717     0.150
    36.154   426.336     0.150
    37.384   435.037     0.150
    38.805   443.688     0.150
    42.740   480.537     0.150
    43.620   490.236     0.150
    50.385   536.387     0.150
    52.869   564.537     0.150
    72.852   689.316     0.150
    74.204   698.875     0.150
    75.917   704.438     0.150
    76.807   712.637     0.150
    83.529   747.477     0.150
   148.586  1187.809     0.150
     1.576    27.779     0.150
     2.214    38.561     0.150
     5.320    82.189     0.150
     6.238    89.480     0.150
     7.432   108.080     0.150
     7.432   191.879     0.150
     8.062   187.570     0.150
     8.148   117.580     0.150
     8.360   121.539     0.150
     8.360   121.670     0.150
     8.362   122.949     0.150
     8.859   130.010     0.150
     9.161   131.580     0.150
     9.405   136.580     0.150
     9.515   137.680     0.150
     9.661   140.080     0.150
    10.139   145.480     0.150
    10.139   145.480     0.150
    10.488   150.779     0.150
    10.562   150.379     0.150
    14.654   204.891     0.150
    14.778   208.910     0.150
    15.810   235.480     0.150
    74.398   231.230     0.150
    74.398   231.180     0.150
    16.812   397.504     0.150
    16.920   236.799     0.150
    18.303   249.756     0.150
    18.321   251.779     0.150
    18.321   251.760     0.150
    23.287   304.910     0.150
    23.456     5.801     0.150
    23.456   611.680     0.150
    26.784   341.680     0.150
    26.784     9.801     0.150
    26.784    12.400     0.150
    29.693   368.379     0.150
    29.967   366.719     0.150
    35.625   414.949     0.150
    41.389   463.680     0.150
    41.389   463.660     0.150
    42.009   468.150     0.150
    42.009   468.180     0.150
    42.422   471.141     0.150
    43.990   481.980     0.150
    45.571   496.680     0.150
    45.766   497.580     0.150
    45.766   498.180     0.150
    46.240   502.004     0.150
    48.515   521.949     0.150
    62.711   623.520     0.150
    65.638   642.070     0.150
    75.649   701.900     0.150
    76.372   707.420     0.150
    78.647   719.100     0.150
    80.847   730.410     0.150
     6.510    93.838     0.150
    10.736   153.998     0.150
    12.566   175.738     0.150
    13.196   184.938     0.150
    13.832   192.738     0.150
    14.394   199.938     0.150
    14.426   200.638     0.150
    14.628   202.938     0.150
    14.640   203.238     0.150
    15.180   210.638     0.150
    15.866   218.838     0.150
    16.130     9.700     0.150
    16.130    12.800     0.150
    16.496   228.138     0.150
    16.508   228.138     0.150
    74.005   233.908     0.150
    16.953   236.701     0.150
    23.836     5.600     0.150
    23.836     9.800     0.150
    31.626   393.938     0.150
     4.229    59.547     0.150
     6.689    96.148     0.150
     6.689   176.945     0.150
     8.692   127.344     0.150
     9.298   138.617     0.150
    10.423   146.188     0.150
    13.021   184.648     0.150
    13.021   184.648     0.150
    13.861   193.844     0.150
    14.422   200.445     0.150
    14.457   200.445     0.150
    14.669   203.250     0.150
    15.063   212.680     0.150
    15.063   214.188     0.150
    22.180   294.039     0.150
    23.982     5.297     0.150
    23.982     8.797     0.150
    26.897   338.000     0.150
    27.308     7.297     0.150
    27.308    10.602     0.150
    29.493   360.836     0.150
    29.563   361.664     0.150
    30.294   367.750     0.150
    35.292   414.125     0.150
    39.519   447.500     0.150
    78.665   721.086     0.150
     6.748    97.570     0.150
     8.344   203.906     0.150
     8.660   125.219     0.150
     8.660   124.469     0.150
    14.712   203.227     0.150
    15.042   212.500     0.150
    23.218   310.219     0.150
    24.001     5.094     0.150
    35.234   412.750     0.150
    35.859   417.578     0.150
    72.891   684.250     0.150
    75.932   701.914     0.150
    75.648   703.344     0.150
     9.265   138.055     0.150
    10.678   148.016     0.150
    14.995   213.898     0.150
    18.421   260.484     0.150
    21.870   292.102     0.150
    65.383   638.203     0.150
     0.839    26.396     0.150
     0.839    15.766     0.150
     0.839    26.365     0.150
     2.804    48.965     0.150
     3.988    56.146     0.150
     4.183    67.566     0.150
     5.561    87.566     0.150
     6.178   104.945     0.150
     6.866   101.266     0.150
     8.109   214.865     0.150
     8.409   126.045     0.150
     8.335   125.166     0.150
     8.569   127.266     0.150
     8.569   126.666     0.150
     9.188   135.666     0.150
     9.427   139.965     0.150
     9.427   245.166     0.150
     9.425   139.465     0.150
    10.226   152.168     0.150
    10.195   150.365     0.150
    15.216   216.365     0.150
    15.216   217.100     0.150
    15.216   216.365     0.150
    15.346   218.865     0.150
    15.346   219.695     0.150
    15.346   221.465     0.150
    16.506   232.766     0.150
    16.502     6.500     0.150
    20.865   279.066     0.150
    22.244   294.086     0.150
    22.244   294.066     0.150
    35.422   411.816     0.150
    35.422   411.816     0.150
    35.422   411.816     0.150
    35.422   504.266     0.150
    35.422   411.766     0.150
    35.422   490.965     0.150
    35.422   560.465     0.150
    35.422   748.465     0.150
    35.422   890.066     0.150
    36.121   425.816     0.150
     1.101    19.301     0.150
     2.565    41.570     0.150
     2.565    41.602     0.150
     4.203    66.699     0.150
     5.506    86.801     0.150
     5.965    86.570     0.150
     6.251    99.102     0.150
     6.668    97.801     0.150
     6.811   102.199     0.150
     7.916   120.398     0.150
     7.993   119.602     0.150
     7.993   211.199     0.150
     8.168   121.102     0.150
     8.529   126.000     0.150
     8.529   126.102     0.150
     8.881   132.199     0.150
     9.238   136.199     0.150
     9.255   137.398     0.150
     9.286   137.602     0.150
     9.286   246.801     0.150
    10.109   148.898     0.150
    10.456   148.801     0.150
    10.456   148.809     0.150
    15.047   214.270     0.150
    15.047   214.301     0.150
    15.175   216.500     0.150
    16.584   231.801     0.150
    21.888   291.199     0.150
    22.457   296.398     0.150
    29.595   368.301     0.150
    29.883   368.480     0.150
    31.111    15.703     0.150
    31.793   383.801     0.150
    31.793   788.801     0.150
    35.947   417.559     0.150
    36.120   422.176     0.150
    45.600   498.711     0.150
    45.885   501.109     0.150
    47.581   514.199     0.150
    47.581    10.301     0.150
    47.581   514.199     0.150
    47.581    10.699     0.150
    47.754   518.102     0.150
    81.410   740.102     0.150
     1.402    45.305     0.150
     1.402    24.945     0.150
     1.402    45.344     0.150
     5.739    89.043     0.150
     6.680    96.242     0.150
     7.221   107.645     0.150
     8.144   217.676     0.150
     8.144   120.445     0.150
     8.144   217.645     0.150
     8.774   127.953     0.150
     8.774   128.043     0.150
     8.774   229.645     0.150
     8.774   127.902     0.150
     8.774   127.945     0.150
     8.817   129.945     0.150
     9.131   134.543     0.150
     9.397   137.043     0.150
    13.967   195.945     0.150
    15.107   212.344     0.150
    15.231   215.645     0.150
    16.221     6.000     0.150
    16.221    14.000     0.150
    16.221   255.043     0.150
    16.923   234.344     0.150
    17.374   239.543     0.150
    17.905   248.844     0.150
    18.235   250.754     0.150
    20.281   274.742     0.150
    22.003   292.395     0.150
    23.633   309.645     0.150
    23.633    16.000     0.150
    23.774     4.902     0.150
    29.463   362.145     0.150
    29.678   368.645     0.150
    29.809   367.145     0.150
    29.946   366.945     0.150
    29.946   362.922     0.150
    31.476   387.844     0.150
    31.476   558.344     0.150
    33.124   394.645     0.150
    74.138   403.570     0.150
    74.138   403.543     0.150
    35.159   414.844     0.150
    35.213   415.543     0.150
    35.689   418.305     0.150
    35.689   418.344     0.150
    36.317   423.945     0.150
    36.318   420.016     0.150
    36.318   420.043     0.150
    39.182   445.184     0.150
    41.311   466.445     0.150
    42.002   471.645     0.150
    42.119   472.145     0.150
    42.302   473.945     0.150
    43.079   479.219     0.150
    43.447   483.145     0.150
    43.630   484.242     0.150
    43.819   486.844     0.150
    44.030   482.812     0.150
    44.099   482.742     0.150
    44.099   482.742     0.150
    44.409   486.344     0.150
    44.409   486.344     0.150
    44.409    19.000     0.150
    47.878   515.145     0.150
    48.599   520.164     0.150
    49.973   531.766     0.150
    51.565   543.453     0.150
    56.992   580.605     0.150
    58.290   590.383     0.150
    65.451   637.324     0.150
    65.451   638.332     0.150
    75.972   703.832     0.150
    76.092   704.742     0.150
    79.128   721.445     0.150
     6.206    91.438     0.150
     7.937   119.117     0.150
     8.301   122.516     0.150
     8.719   130.531     0.150
     8.895   135.805     0.150
    14.616   208.164     0.150
    18.605   252.031     0.150
    32.458   388.133     0.150
    38.866   443.891     0.150
     1.413    25.723     0.150
     2.296    42.223     0.150
     4.934    80.523     0.150
     5.444    86.621     0.150
     6.431    95.121     0.150
     8.480   126.324     0.150
     8.480   221.324     0.150
     8.480   125.824     0.150
     8.674   131.883     0.150
     9.046   135.324     0.150
     9.115   136.223     0.150
    11.035   160.621     0.150
    16.669   234.824     0.150
    17.084   241.121     0.150
    18.345   255.523     0.150
    18.409   257.500     0.150
    23.366    17.898     0.150
    23.366   342.723     0.150
    26.961   339.824     0.150
    26.961    15.898     0.150
    31.263    20.500     0.150
    45.777   500.199     0.150
    45.777   502.523     0.150
    72.797   686.512     0.150
    81.172   736.223     0.150
     1.389    25.457     0.150
     1.389    25.477     0.150
     2.398    41.557     0.150
     3.489    58.918     0.150
     4.048    63.008     0.150
     4.785    78.117     0.150
     4.790    76.957     0.150
     4.925    79.727     0.150
     5.292    83.957     0.150
     5.980    91.627     0.150
     6.530   100.277     0.150
     6.790   102.957     0.150
     7.100   184.547     0.150
     8.327   123.557     0.150
     8.327   123.457     0.150
     8.398   125.668     0.150
     8.733   129.457     0.150
     8.914   132.457     0.150
    14.731   207.957     0.150
    14.731   208.047     0.150
    18.277   254.857     0.150
    20.446   276.758     0.150
    23.209    16.000     0.150
    23.209   339.357     0.150
    33.871   402.957     0.150
    33.871   402.957     0.150
    33.871   403.047     0.150
    35.446   418.357     0.150
    35.872   419.957     0.150
    41.400   467.357     0.150
    55.881   575.258     0.150
    60.270   606.457     0.150
    74.372   696.656     0.150
    82.986   744.057     0.150
     4.339    67.562     0.150
     4.407    68.273     0.150
     5.256    81.273     0.150
     5.785   151.562     0.150
     6.103    98.852     0.150
     6.261   165.422     0.150
     6.799   101.914     0.150
     6.799   101.414     0.150
     8.509   121.875     0.150
     8.712   130.992     0.150
     8.912   129.297     0.150
     9.119   136.305     0.150
     9.291   138.086     0.150
    11.325   163.914     0.150
    11.325   294.828     0.150
    15.105   215.617     0.150
    15.234   213.766     0.150
    18.169   251.477     0.150
    18.435   254.203     0.150
    20.951   283.398     0.150
    21.925   292.258     0.150
    22.973   304.273     0.150
    24.040     7.797     0.150
    28.853   348.648     0.150
    29.451   361.234     0.150
    29.985   366.328     0.150
    33.676   399.664     0.150
    38.728   442.156     0.150
    42.674   474.938     0.150
    43.529   483.969     0.150
    43.911   483.625     0.150
    44.188   487.281     0.150
    45.533   497.547     0.150
    48.096   514.312     0.150
    49.047   523.422     0.150
    81.547   733.062     0.150
    83.707   745.102     0.150
   102.024   831.953     0.150
   102.024   829.672     0.150
     4.767   126.051     0.150
     4.906    79.189     0.150
     5.285   136.951     0.150
     6.512   165.020     0.150
     7.081   179.410     0.150
     7.643   191.930     0.150
     8.331   125.070     0.150
     8.331   125.561     0.150
    33.888   404.180     0.150
     8.547   126.258     0.150
    12.600   176.055     0.150
    12.600   306.352     0.150
    14.674   204.852     0.150
    14.868   208.555     0.150
    15.232   213.852     0.150
    15.094   213.844     0.150
    15.222   217.703     0.150
    16.554   230.750     0.150
    18.242   252.305     0.150
    18.474   255.602     0.150
    24.106   315.727     0.150
    29.545   362.805     0.150
    35.279   414.172     0.150
    72.954   686.930     0.150
    75.887   705.492     0.150
    83.614   745.391     0.150
     1.244    35.133     0.150
     2.450    43.039     0.150
     4.968    79.312     0.150
     5.453    85.492     0.150
     6.166    94.383     0.150
     6.166    94.328     0.150
     6.870   104.781     0.150
     6.975   104.883     0.150
     7.538   116.484     0.150
     7.734   115.430     0.150
     7.734   200.367     0.150
     8.428   123.734     0.150
     8.428   121.781     0.150
     8.428   211.562     0.150
     8.483   126.664     0.150
     8.483   126.578     0.150
     8.483   221.078     0.150
     8.483   124.469     0.150
     8.589   128.203     0.150
     8.589   128.281     0.150
     8.789   127.477     0.150
     8.789   127.430     0.150
     9.117   133.508     0.150
     9.140   134.391     0.150
     9.140   138.281     0.150
     9.140   138.281     0.150
     9.140   138.281     0.150
     9.781   144.133     0.150
     9.979   145.672     0.150
     9.927   146.250     0.150
     9.927   254.469     0.150
    10.298   150.781     0.150
    10.423   151.688     0.150
    10.778   156.773     0.150
    10.868   157.328     0.150
    11.137   165.555     0.150
    11.137   292.578     0.150
    11.137   165.578     0.150
    11.137   292.578     0.150
    11.438   162.898     0.150
    11.542   284.867     0.150
    12.003   172.938     0.150
    14.933   210.273     0.150
    14.933   210.383     0.150
    14.933   210.383     0.150
    14.933   210.383     0.150
    15.060   211.922     0.150
    15.060   212.070     0.150
    16.601   232.680     0.150
    17.139   239.219     0.150
    18.091   255.102     0.150
    18.274   254.312     0.150
    18.433   254.891     0.150
    19.761   278.680     0.150
    19.836     7.398     0.150
    20.512   277.883     0.150
    21.206   289.578     0.150
    21.206   289.578     0.150
    21.206   289.578     0.150
    21.206   289.578     0.150
    21.206   289.578     0.150
    21.206   289.578     0.150
    21.790   292.180     0.150
    21.790   292.180     0.150
    22.901   308.578     0.150
   150.287   305.703     0.150
    23.205   310.078     0.150
    23.205   310.078     0.150
    23.205   310.078     0.150
    23.205   310.078     0.150
    23.205   310.078     0.150
    23.205   310.078     0.150
    23.406   555.281     0.150
    24.172   315.078     0.150
    24.455   317.258     0.150
    24.438   317.930     0.150
    25.395   331.977     0.150
    25.962   336.625     0.150
    26.084   334.828     0.150
    26.007   333.977     0.150
    26.007     8.500     0.150
     9.593   342.586     0.150
    29.711   363.883     0.150
    29.711   363.922     0.150
    29.711   365.336     0.150
    29.711   367.883     0.150
    29.711   367.773     0.150
    29.743   367.281     0.150
    33.876   404.680     0.150
    35.418   421.883     0.150
    36.049   422.281     0.150
    36.049   422.281     0.150
    36.049   422.281     0.150
    36.049   422.281     0.150
    36.049   422.281     0.150
    36.049   422.281     0.150
    38.443   445.250     0.150
    38.862   447.078     0.150
    38.862   445.977     0.150
    42.758   475.945     0.150
    42.758   476.719     0.150
    44.114   490.680     0.150
    44.114   600.680     0.150
    73.461   692.781     0.150
    74.235   695.680     0.150
    76.065   705.578     0.150
    76.065   705.586     0.150
    76.065   709.883     0.150
    76.697   709.680     0.150
    81.087   733.820     0.150
    83.148   745.180     0.150
    83.483   747.602     0.150
   103.006   845.578     0.150
     1.369    23.828     0.150
     2.251    39.016     0.150
     5.257    82.797     0.150
     5.257    82.867     0.150
     7.252   106.926     0.150
     8.796   128.227     0.150
     8.796   127.926     0.150
     8.850   130.125     0.150
     9.167   133.727     0.150
     9.310   139.016     0.150
     9.310   136.027     0.150
     9.350   136.297     0.150
    11.332   162.227     0.150
    12.847   181.328     0.150
    14.095   194.828     0.150
    15.145   210.027     0.150
    15.145   210.027     0.150
    16.263    14.203     0.150
    18.746   255.246     0.150
    18.746   258.328     0.150
    20.308   272.926     0.150
    22.038   293.746     0.150
    23.659   305.137     0.150
    23.659   305.625     0.150
    23.649   304.988     0.150
    23.649   305.027     0.150
    24.446   312.117     0.150
    24.446   312.125     0.150
     9.664   336.227     0.150
    27.329   338.156     0.150
    27.486   340.348     0.150
    29.703   360.898     0.150
    29.919   361.707     0.150
    29.919   361.727     0.150
    29.919   361.355     0.150
    29.919   361.328     0.150
    30.290   369.105     0.150
    34.160   399.605     0.150
    34.160   399.625     0.150
    34.160   402.227     0.150
    34.160   402.426     0.150
    39.901   449.926     0.150
    39.901   449.957     0.150
    41.341   459.828     0.150
    42.328   470.504     0.150
    42.756   472.828     0.150
    42.756   472.855     0.150
    43.086   476.828     0.150
    43.689   484.688     0.150
    45.862   499.297     0.150
    45.862   499.328     0.150
    46.152   500.688     0.150
    47.509   512.527     0.150
    47.509   511.926     0.150
    63.687   625.535     0.150
    72.868   681.527     0.150
    72.868   681.535     0.150
    76.970   707.207     0.150
    76.970   707.227     0.150
    83.222   743.328     0.150
     0.640    11.812     0.150
     3.047    51.043     0.150
     3.047    51.043     0.150
    41.798    65.340     0.150
     4.764   152.660     0.150
     5.417   171.391     0.150
     5.448    85.613     0.150
     5.941    93.551     0.150
     6.430   204.301     0.150
     7.469   111.441     0.150
     7.640   114.043     0.150
     7.867   244.023     0.150
     8.194   121.273     0.150
     8.334   122.312     0.150
     8.349   119.512     0.150
     8.440   125.473     0.150
     8.440   219.113     0.150
     8.440   123.910     0.150
     8.563   128.750     0.150
     8.759   126.410     0.150
     8.759   130.723     0.150
     9.168   133.543     0.150
     9.329   138.543     0.150
     9.435   137.621     0.150
     9.448   137.410     0.150
     9.897   143.621     0.150
    10.037   145.590     0.150
    10.228   147.602     0.150
    10.183   148.453     0.150
    10.310   149.230     0.150
    10.507   152.742     0.150
    10.725   154.691     0.150
    11.094   160.141     0.150
    11.934   171.961     0.150
    12.247   175.871     0.150
    13.024   324.211     0.150
    14.902   207.711     0.150
    14.902   207.613     0.150
    15.213   212.852     0.150
    15.740   222.363     0.150
    16.294   228.113     0.150
    17.953   248.766     0.150
    20.616   279.684     0.150
    20.616   279.711     0.150
    21.109   284.711     0.150
    21.981   293.891     0.150
    21.981   293.910     0.150
    23.902   311.012     0.150
    23.845   311.383     0.150
    24.318     7.102     0.150
    24.872   359.910     0.150
    24.872   652.113     0.150
    25.485   326.043     0.150
    26.150   327.113     0.150
     8.992   345.793     0.150
    27.713     8.598     0.150
    27.713    12.801     0.150
    27.833   348.910     0.150
    29.115   358.512     0.150
    29.115   358.613     0.150
    29.115   359.711     0.150
    29.115   359.203     0.150
    30.295   370.613     0.150
    30.511   373.312     0.150
    30.636   371.613     0.150
    32.074   391.613     0.150
    33.375   397.691     0.150
    33.375   397.613     0.150
    34.334   407.512     0.150
    34.334   405.711     0.150
    34.388   408.312     0.150
    34.863   411.586     0.150
    34.863   411.613     0.150
    35.176   413.492     0.150
    35.176   413.492     0.150
    35.176   504.492     0.150
    35.176   746.953     0.150
    35.176   902.262     0.150
    35.176   413.410     0.150
    35.176   491.512     0.150
    35.176   504.410     0.150
    35.176   746.910     0.150
    35.176   884.512     0.150
    35.176   902.211     0.150
    35.491   417.711     0.150
    35.499   418.188     0.150
    35.499   418.211     0.150
    35.782   418.867     0.150
    36.101   420.410     0.150
    36.158   429.312     0.150
    36.545   425.203     0.150
    36.545   425.211     0.150
    80.643   427.852     0.150
    80.643   427.812     0.150
    36.690   427.312     0.150
    36.873   428.043     0.150
    37.008   428.742     0.150
    37.008   428.711     0.150
    37.041   429.211     0.150
    37.158   430.508     0.150
    37.158   430.512     0.150
    37.208   431.113     0.150
    37.202   430.406     0.150
    37.564   435.211     0.150
    37.564   435.242     0.150
    37.633   436.910     0.150
    37.889   435.801     0.150
    37.889   435.812     0.150
    38.226   439.191     0.150
    38.787   442.043     0.150
    38.787   442.012     0.150
    38.888   446.613     0.150
    39.100   448.812     0.150
    39.262   448.910     0.150
    39.420   451.191     0.150
    39.818   450.871     0.150
    40.164   456.613     0.150
    40.139   454.812     0.150
    40.311   457.891     0.150
    40.695   461.312     0.150
    40.856   462.812     0.150
    40.856   462.820     0.150
    41.069   462.711     0.150
    41.307   466.711     0.150
    41.352   466.332     0.150
    41.437   464.691     0.150
    41.437   464.711     0.150
    41.495   467.910     0.150
    41.527   467.812     0.150
    41.697   473.402     0.150
    41.697   469.410     0.150
    41.779   473.141     0.150
    42.031   472.211     0.150
    42.153   471.902     0.150
    42.153   471.871     0.150
    42.438   473.578     0.150
    42.618   477.211     0.150
    42.638   477.312     0.150
    42.708   478.113     0.150
    42.816   478.211     0.150
    43.016   479.910     0.150
    42.672   484.672     0.150
    43.217   481.383     0.150
    43.564   484.113     0.150
    43.608   483.910     0.150
    43.608   621.012     0.150
    43.608  1346.012     0.150
    43.608  1466.012     0.150
    43.745   484.613     0.150
    43.708   483.551     0.150
    43.981   488.312     0.150
    44.142   487.312     0.150
    44.498   491.910     0.150
    44.533   492.812     0.150
    44.644   492.953     0.150
    44.869   494.910     0.150
    45.274   496.012     0.150
    46.022   595.012     0.150
    46.022   609.512     0.150
    46.022   650.211     0.150
    46.022   906.012     0.150
    46.022  1166.613     0.150
    46.164   509.090     0.150
    46.193   505.211     0.150
    46.772   508.711     0.150
    47.022   508.512     0.150
    47.265   512.012     0.150
    47.603   515.910     0.150
    47.603   514.613     0.150
    48.078   517.590     0.150
    48.078   517.613     0.150
    48.336   521.711     0.150
    48.432   522.312     0.150
    48.400   523.812     0.150
    49.870   531.191     0.150
    49.870   531.211     0.150
    49.870   532.113     0.150
    49.951   533.211     0.150
    50.035   539.352     0.150
    50.653   539.113     0.150
    51.936   548.512     0.150
    52.774   554.613     0.150
    55.420   572.711     0.150
    56.212   578.613     0.150
    56.212   578.668     0.150
    56.753   583.410     0.150
    57.854   596.863     0.150
    58.344   594.312     0.150
    59.701   605.812     0.150
    60.239   607.910     0.150
    60.376   607.230     0.150
    61.441   610.773     0.150
    60.810   612.172     0.150
    62.475   621.891     0.150
    72.666   684.531     0.150
    75.086   700.402     0.150
    75.718   702.301     0.150
    75.862   704.613     0.150
    76.500   708.062     0.150
    76.500   708.113     0.150
    76.801   709.211     0.150
    77.529   713.512     0.150
    78.683   720.211     0.150
    79.246   723.773     0.150
    81.879   743.953     0.150
    83.126   742.434     0.150
    83.388   744.910     0.150
    83.388   744.883     0.150
    84.025   749.012     0.150
     1.423    26.180     0.150
     1.423    44.281     0.150
     3.435    92.594     0.150
    41.248    68.062     0.150
     4.851    76.680     0.150
     6.773   103.180     0.150
     6.847   103.945     0.150
     6.971   105.773     0.150
     7.461   111.984     0.150
     7.665   115.086     0.150
     7.748   112.133     0.150
     8.196   147.641     0.150
     8.353   139.086     0.150
     8.353   120.281     0.150
     8.398   124.180     0.150
     8.398   222.086     0.150
     8.398   123.180     0.150
     8.450   126.695     0.150
     8.450   228.398     0.150
     8.450   126.609     0.150
     8.450   120.883     0.150
     8.944   131.383     0.150
     8.973   131.039     0.150
     9.508   171.664     0.150
     9.508   140.086     0.150
     9.622   173.984     0.150
     9.622   141.281     0.150
     9.822   142.680     0.150
     9.768   177.211     0.150
     9.768   143.281     0.150
     9.782   265.609     0.150
     9.782   144.180     0.150
     9.818   141.953     0.150
    10.255   185.391     0.150
    10.255   149.484     0.150
    10.608   154.086     0.150
    10.635   153.781     0.150
    10.701   193.289     0.150
    10.701   155.680     0.150
    10.826   159.883     0.150
    10.965   157.781     0.150
    12.971   181.680     0.150
    13.588   192.586     0.150
    14.195   198.484     0.150
    14.768   208.484     0.150
    14.893   210.070     0.150
    14.893   209.984     0.150
    15.341   215.383     0.150
    15.919   229.984     0.150
    74.244   230.984     0.150
    16.596   226.914     0.150
    16.596   227.180     0.150
    16.596   409.180     0.150
    16.896   424.539     0.150
    18.273   253.336     0.150
    18.273   246.664     0.150
    18.326   254.180     0.150
    19.863   267.680     0.150
    20.380   277.609     0.150
    20.380   277.562     0.150
    20.380   277.484     0.150
    23.187   311.227     0.150
    23.289   307.680     0.150
    23.289   307.680     0.150
    23.503   309.938     0.150
    24.648   320.180     0.150
    25.541   373.180     0.150
    25.541   663.484     0.150
    26.940     6.398     0.150
    27.923   349.086     0.150
    27.999   346.781     0.150
    28.295   363.180     0.150
    29.560   365.086     0.150
    29.591   364.781     0.150
    29.809  2284.031     0.150
    29.809   367.992     0.150
    29.809   769.242     0.150
    29.809   368.086     0.150
    29.822   355.680     0.150
    29.841   366.914     0.150
    30.487   371.930     0.150
    30.487   375.180     0.150
    30.612   377.680     0.150
    31.201   450.984     0.150
    31.201   379.164     0.150
    79.846   386.742     0.150
    32.588   391.984     0.150
    33.053   398.883     0.150
    33.484   400.484     0.150
    33.736   401.984     0.150
    33.736   401.984     0.150
    74.244   404.977     0.150
    74.244   404.883     0.150
    34.080   404.984     0.150
    34.088   406.086     0.150
    34.563   409.977     0.150
    34.986   413.180     0.150
    34.986   414.781     0.150
    35.039   415.383     0.150
    35.087   416.539     0.150
    35.087   416.484     0.150
    35.455   418.383     0.150
    35.520   416.977     0.150
    35.520   420.180     0.150
    35.690   418.227     0.150
    35.690   418.227     0.150
    35.690   510.609     0.150
    35.690   913.039     0.150
    35.690   418.180     0.150
    35.690   497.281     0.150
    35.690   754.883     0.150
    35.690   896.586     0.150
    35.928   422.883     0.150
    36.128   423.883     0.150
    36.148   424.281     0.150
    36.467   427.680     0.150
    36.467   423.984     0.150
    36.631   429.086     0.150
    37.120   435.281     0.150
    37.187   433.383     0.150
    80.395   434.242     0.150
    80.395   434.180     0.150
    37.459   434.984     0.150
    37.490   433.383     0.150
    37.661   437.586     0.150
    37.798   438.484     0.150
    37.942   439.086     0.150
    38.099   438.203     0.150
    38.176   441.281     0.150
    38.235   440.281     0.150
    38.544   444.680     0.150
    38.882   444.602     0.150
    39.183   830.586     0.150
    39.340   451.086     0.150
    39.358   450.883     0.150
    39.494   452.984     0.150
    39.727   451.555     0.150
    39.727   453.484     0.150
    39.857   454.883     0.150
    40.030   457.180     0.150
    40.163   455.281     0.150
    40.163   455.266     0.150
    40.437   460.180     0.150
    40.615   459.820     0.150
    40.792   464.086     0.150
    40.912   464.383     0.150
    40.912   554.883     0.150
    41.230   465.070     0.150
    41.297   466.781     0.150
    41.373   467.586     0.150
    41.476   468.586     0.150
    41.646   469.586     0.150
    41.740   468.844     0.150
    41.792   470.680     0.150
    41.915   470.906     0.150
    41.915   472.086     0.150
    42.090   473.680     0.150
    42.114   473.586     0.150
    42.160   474.180     0.150
    42.263   474.883     0.150
    42.289   475.180     0.150
    42.407   474.500     0.150
    42.639   477.984     0.150
    42.740   476.977     0.150
    43.210   482.680     0.150
    43.238   482.883     0.150
    43.306   483.883     0.150
    43.513     5.000     0.150
    43.431   484.180     0.150
    43.481   603.883     0.150
    43.896   594.383     0.150
    44.048   488.281     0.150
    44.189   630.883     0.150
    44.189  1145.883     0.150
    44.189   489.680     0.150
    44.576   493.383     0.150
    44.674   493.891     0.150
    44.728   492.836     0.150
    45.184   497.680     0.150
    45.399   498.266     0.150
    45.399   498.281     0.150
    45.555   499.086     0.150
    45.555   594.586     0.150
    45.555   605.383     0.150
    45.555   642.383     0.150
    45.555   901.281     0.150
    45.555  1151.281     0.150
    45.653   501.281     0.150
    45.712   500.484     0.150
    45.712   500.484     0.150
    45.712   496.984     0.150
    47.515   514.281     0.150
    47.479   514.586     0.150
    47.479   515.383     0.150
    47.479   514.586     0.150
    50.322   537.484     0.150
    50.514   538.383     0.150
    50.574   540.086     0.150
    51.313   544.086     0.150
    53.484   560.281     0.150
    53.812   562.984     0.150
    54.041  1012.781     0.150
    55.701   576.383     0.150
    55.952   578.742     0.150
    57.913   591.883     0.150
    60.806   612.180     0.150
    61.051   613.352     0.150
    61.408   614.883     0.150
    62.113   617.250     0.150
    62.440   619.156     0.150
    62.440   619.781     0.150
    62.231   623.086     0.150
    62.703   624.422     0.150
    64.070   633.875     0.150
    68.647   663.383     0.150
    73.651   693.523     0.150
    73.987   696.805     0.150
    74.210   698.008     0.150
    74.412   697.477     0.150
    76.261   708.086     0.150
    76.243   707.633     0.150
    76.243   707.406     0.150
    76.487   707.328     0.150
    76.566   709.281     0.150
    76.979   712.281     0.150
    78.988   722.680     0.150
    80.942   733.883     0.150
    81.220   736.172     0.150
    83.390   747.930     0.150
    83.390   747.680     0.150
    83.390   747.680     0.150
    83.675   747.562     0.150
    84.572   754.758     0.150
    89.972   778.984     0.150
    74.244   833.883     0.150
   102.158   836.656     0.150
   102.158   833.625     0.150
   116.333  1751.812     0.150
   117.639  1125.828     0.150
   117.639  1125.484     0.150
    74.244  1127.625     0.150
   119.459  1741.594     0.150
   124.495  1138.781     0.150
    74.244  1147.492     0.150
   138.951  1166.781     0.150
   148.987  1184.586     0.150
     1.427    23.148     0.150
     1.427    23.148     0.150
     1.427    43.746     0.150
     2.321    38.797     0.150
    41.240    64.527     0.150
     8.404   122.348     0.150
     8.454   125.418     0.150
     8.454   123.078     0.150
     8.454   125.469     0.150
     8.454   122.746     0.150
     8.946   130.348     0.150
     8.976   130.406     0.150
    14.770   207.746     0.150
    14.896   211.547     0.150
    18.354   254.246     0.150
    19.870   264.148     0.150
    20.374   278.848     0.150
    21.646   289.246     0.150
     9.779   341.316     0.150
    26.936   339.746     0.150
    28.349   353.547     0.150
    29.848   364.086     0.150
    29.802   368.648     0.150
    30.615   371.469     0.150
    30.615   371.449     0.150
    79.850   390.098     0.150
    33.957   402.039     0.150
    34.993   413.449     0.150
    35.527   415.176     0.150
    35.527   415.148     0.150
    35.698   415.707     0.150
    35.698   415.707     0.150
    35.698   506.988     0.150
    35.698   909.109     0.150
    35.698   415.648     0.150
    35.698   494.547     0.150
    35.698   751.848     0.150
    35.698   892.848     0.150
    36.148   420.047     0.150
    37.806   437.547     0.150
    37.920   437.746     0.150
    37.929   437.887     0.150
    37.949   437.746     0.150
    38.107   437.219     0.150
    38.243   438.176     0.150
    38.243   438.148     0.150
    38.889   443.617     0.150
    38.889   443.449     0.150
    39.502   451.648     0.150
    39.734   452.949     0.150
    39.865   451.469     0.150
    39.865   451.449     0.150
    40.483   456.699     0.150
    40.483   456.648     0.150
    41.305   466.246     0.150
    41.800   469.848     0.150
    42.097   472.848     0.150
    42.122   472.449     0.150
    42.318   477.859     0.150
    42.415   473.496     0.150
    42.415   473.426     0.150
    43.438   484.047     0.150
    43.838   488.578     0.150
    43.838   488.547     0.150
    44.001   486.227     0.150
    44.197   488.246     0.150
    44.197   488.246     0.150
    45.651   500.547     0.150
    47.950   517.348     0.150
    50.329   536.348     0.150
    53.809   562.348     0.150
    53.815   562.348     0.150
    56.411   580.746     0.150
    58.470   594.289     0.150
    75.719   704.246     0.150
    80.946   732.547     0.150
    81.204   736.949     0.150
    81.213   736.656     0.150
     1.410    25.305     0.150
     1.410    25.336     0.150
     2.344    41.645     0.150
     3.450    59.895     0.150
     4.845    77.936     0.150
     5.353    84.135     0.150
     6.842   103.125     0.150
     7.451   113.936     0.150
     7.655   117.035     0.150
     8.343   119.936     0.150
     8.388   123.635     0.150
     8.388   218.836     0.150
     8.388   123.535     0.150
     8.445   125.084     0.150
     8.445   125.635     0.150
     8.860   220.984     0.150
     8.945   131.336     0.150
     8.973   131.785     0.150
     9.505   139.535     0.150
     9.621   141.336     0.150
     9.820   143.135     0.150
     9.767   143.936     0.150
    10.255   149.035     0.150
    10.608   153.836     0.150
    10.629   153.734     0.150
    10.826   159.635     0.150
    10.965   158.436     0.150
    13.580   191.436     0.150
    13.580   344.234     0.150
    14.211   198.635     0.150
    14.767   214.379     0.150
    14.767   208.135     0.150
    15.333   218.035     0.150
    15.956     4.602     0.150
    16.582   231.336     0.150
    16.582   415.734     0.150
    74.232   232.975     0.150
    74.232   232.936     0.150
    16.999   239.535     0.150
    18.317   252.285     0.150
    20.396   278.586     0.150
    20.396   275.936     0.150
    74.232   290.025     0.150
    21.639   289.475     0.150
    21.639   289.535     0.150
    24.638   318.836     0.150
    29.826   366.205     0.150
    29.825   366.916     0.150
    33.934     1.600     0.150
    33.934   403.035     0.150
    34.970   412.234     0.150
    34.970   412.234     0.150
    35.503   416.965     0.150
    35.503   416.936     0.150
    35.675   418.145     0.150
    35.675   418.145     0.150
    35.675   780.166     0.150
    35.675   418.135     0.150
    35.675   500.135     0.150
    35.675   750.436     0.150
    35.675   900.234     0.150
    35.927   419.246     0.150
    37.474   433.336     0.150
    37.782   437.635     0.150
    37.926   438.535     0.150
    38.528   444.436     0.150
    38.866   442.225     0.150
    38.867   444.336     0.150
    39.478   452.135     0.150
    39.710   450.535     0.150
    40.462   457.535     0.150
    41.245   466.135     0.150
    41.245   466.256     0.150
    41.245   466.115     0.150
    42.074   472.836     0.150
    42.273   474.436     0.150
    42.394   473.746     0.150
    42.394   473.846     0.150
    42.727   476.535     0.150
    43.814   485.926     0.150
    45.662   500.635     0.150
    45.697   499.535     0.150
    45.662   499.027     0.150
    46.389   505.635     0.150
    47.551   513.975     0.150
    47.927   518.746     0.150
    49.065   527.785     0.150
    50.498   538.836     0.150
    52.804   555.734     0.150
    53.820   562.436     0.150
    53.826   560.996     0.150
    56.391   580.436     0.150
    58.447   595.395     0.150
    60.421   612.496     0.150
    60.865   613.686     0.150
    62.690   624.564     0.150
    73.209   691.885     0.150
    74.399   696.285     0.150
    74.399   696.336     0.150
    76.242   707.305     0.150
    76.255   708.135     0.150
    76.561   708.105     0.150
    77.269   712.635     0.150
    80.938   733.035     0.150
    80.938   733.035     0.150
    81.228   734.436     0.150
    81.237   732.836     0.150
    83.045   743.965     0.150
    83.661   747.480     0.150
    89.987   782.484     0.150
    89.987   782.436     0.150
   124.504  1136.852     0.150
   148.978  1187.916     0.150
     5.351    82.239     0.150
     8.386   125.705     0.150
    18.255   254.019     0.150
    18.255   254.026     0.150
    18.314   255.769     0.150
    74.229   290.259     0.150
    21.639   290.679     0.150
    29.821   366.489     0.150
    29.830   369.739     0.150
    38.863   445.509     0.150
    42.723   476.769     0.150
    61.031   613.679     0.150
    76.240   711.119     0.150
    76.560   708.619     0.150
    83.043   745.209     0.150
     3.999    50.906     0.150
     3.999   105.305     0.150
    41.261    65.961     0.150
    41.261   114.531     0.150
     4.737    63.703     0.150
     5.376    82.031     0.150
     5.363    66.641     0.150
     5.363   134.023     0.150
     5.450    74.625     0.150
     6.131    80.883     0.150
     6.477    86.906     0.150
     6.789   101.156     0.150
     7.175   106.141     0.150
     8.155   110.656     0.150
     8.170   111.984     0.150
     8.170   208.227     0.150
     8.403   113.914     0.150
     8.474   220.656     0.150
     8.514   112.820     0.150
     8.846   120.477     0.150
     8.846   227.227     0.150
    12.362   174.734     0.150
    12.992   181.836     0.150
    14.797   206.859     0.150
    16.595   231.906     0.150
    18.271   253.961     0.150
    18.340   250.859     0.150
    18.340   255.414     0.150
    29.832   368.133     0.150
    33.934   403.680     0.150
    38.876   444.805     0.150
    42.742   477.141     0.150
    58.116   594.352     0.150
    81.232   735.711     0.150
    83.069   745.016     0.150
    83.409   747.586     0.150
     1.406    25.246     0.150
     1.406    42.846     0.150
     3.971    61.206     0.150
    41.231    67.786     0.150
     4.891    78.146     0.150
     5.343    81.176     0.150
     6.812   102.246     0.150
     6.887   102.896     0.150
     7.195   107.546     0.150
     7.582   111.086     0.150
     7.743   114.135     0.150
     8.435   123.646     0.150
     8.490   125.546     0.150
     8.490   125.606     0.150
     8.983   132.146     0.150
     9.013   132.286     0.150
     9.590   135.936     0.150
     9.857   143.526     0.150
    11.003   158.046     0.150
    12.759   315.246     0.150
    14.191   196.506     0.150
    14.191   196.546     0.150
    14.807   207.276     0.150
    14.807   207.246     0.150
    18.300   253.116     0.150
    18.300   253.146     0.150
    21.334   285.646     0.150
    74.223   290.646     0.150
    23.320    10.000     0.150
    23.516   308.646     0.150
    24.622   319.846     0.150
    26.095   334.536     0.150
    27.339   345.746     0.150
    29.587   365.346     0.150
    29.805   368.646     0.150
    29.824   366.846     0.150
    31.222   436.446     0.150
    33.050   394.846     0.150
    33.964   402.446     0.150
    33.964   402.746     0.150
    34.994   411.976     0.150
    34.994   410.846     0.150
    83.805   414.246     0.150
    35.528   416.566     0.150
    35.528   416.546     0.150
    35.709   416.666     0.150
    35.709   416.666     0.150
    35.709    19.280     0.150
    35.709   416.646     0.150
    35.709    13.000     0.150
    35.709    19.300     0.150
    35.709   497.346     0.150
    35.709   750.146     0.150
    35.709   773.346     0.150
    35.709   898.546     0.150
    35.973   420.646     0.150
    80.435   430.726     0.150
    38.553   442.046     0.150
    38.553   442.046     0.150
    39.097   446.146     0.150
    39.737   452.236     0.150
    39.870   454.076     0.150
    40.720   460.016     0.150
    42.103   471.635     0.150
    42.103   471.646     0.150
    42.267   473.286     0.150
    42.438   472.656     0.150
    42.770   476.546     0.150
    43.867   487.576     0.150
    44.117   487.116     0.150
    44.742   490.396     0.150
    44.768   493.306     0.150
    44.785   492.946     0.150
    45.135   510.786     0.150
    45.150   511.836     0.150
    45.483   498.346     0.150
    45.483   498.376     0.150
    45.735   499.446     0.150
    45.735   499.446     0.150
    49.237   527.746     0.150
    56.436   580.496     0.150
    58.469   595.506     0.150
    63.447   629.066     0.150
    64.034   632.856     0.150
    72.756   686.635     0.150
    74.396   696.666     0.150
    75.754   704.606     0.150
    75.754   704.646     0.150
    76.606   708.146     0.150
    76.754   709.346     0.150
    83.092   744.146     0.150
    83.092   744.146     0.150
    83.380   746.316     0.150
    83.704   747.396     0.150
    83.704   747.426     0.150
     1.391    24.707     0.150
     2.341    41.156     0.150
     3.460    57.539     0.150
     3.988    61.328     0.150
    41.247    67.156     0.150
     4.887    78.008     0.150
     5.247    80.469     0.150
     6.806   101.629     0.150
     6.806   101.609     0.150
     6.885   102.898     0.150
     7.191   106.566     0.150
     7.191   106.609     0.150
     8.428   123.406     0.150
     8.428   218.406     0.150
     8.489   125.406     0.150
     8.489   124.309     0.150
     8.817   128.996     0.150
     8.987   131.707     0.150
     9.015   131.898     0.150
     9.861   143.887     0.150
    11.007   158.707     0.150
    14.208   198.609     0.150
    14.809   208.309     0.150
    15.994    10.602     0.150
    16.611   230.809     0.150
    16.611   409.008     0.150
    20.397   275.309     0.150
    21.317   286.008     0.150
    23.310    15.598     0.150
    24.609   318.008     0.150
    29.595   365.008     0.150
    29.825   365.148     0.150
    30.034   368.488     0.150
    30.587   371.496     0.150
    33.948   402.609     0.150
    33.948   401.109     0.150
    33.948   402.508     0.150
    34.978   413.609     0.150
    83.812   413.508     0.150
    35.511   418.809     0.150
    35.693   416.648     0.150
    35.693   416.648     0.150
    35.693    19.281     0.150
    35.693   416.609     0.150
    35.693    13.098     0.150
    35.693    19.297     0.150
    35.693   497.609     0.150
    35.693   750.609     0.150
    35.693   773.309     0.150
    35.693   897.309     0.150
    36.122   420.430     0.150
    37.497   432.406     0.150
    38.102   436.707     0.150
    38.171   440.332     0.150
    38.536   443.609     0.150
    38.892   440.648     0.150
    38.892   442.027     0.150
    39.085   444.609     0.150
    39.490   451.609     0.150
    39.553   450.309     0.150
    39.721   453.199     0.150
    41.294   465.906     0.150
    41.379   464.508     0.150
    41.789   469.809     0.150
    41.911   470.906     0.150
    42.044   472.008     0.150
    42.087   472.406     0.150
    42.112   472.406     0.150
    42.260   467.809     0.150
    42.260   467.809     0.150
    42.426   473.547     0.150
    43.601   483.809     0.150
    43.826   486.277     0.150
    43.855   488.027     0.150
    44.011   485.727     0.150
    44.187   487.008     0.150
    44.187   487.008     0.150
    44.860   494.656     0.150
    45.720   498.906     0.150
    45.720   498.906     0.150
    45.819   501.398     0.150
    47.284   512.598     0.150
    48.214   520.707     0.150
    48.673   525.207     0.150
    48.986   526.906     0.150
    49.073   525.207     0.150
    53.392   559.406     0.150
    56.426   580.207     0.150
    58.452   593.508     0.150
    58.452   593.527     0.150
    74.381   696.109     0.150
    75.750   704.207     0.150
    76.200   705.707     0.150
    76.200   706.168     0.150
    80.982   732.598     0.150
    80.982   732.508     0.150
    82.724   741.836     0.150
    83.086   743.707     0.150
    83.397   747.008     0.150
     1.267    22.723     0.150
     1.267    39.023     0.150
     2.410    40.094     0.150
     3.565    66.262     0.150
     4.047    71.453     0.150
    41.260    66.902     0.150
     4.788    83.402     0.150
     5.011    77.723     0.150
     5.311    89.621     0.150
     5.407    88.234     0.150
     5.473    93.172     0.150
     5.473   151.672     0.150
     5.500    84.023     0.150
     5.821   100.812     0.150
     5.821   165.863     0.150
     6.174   100.672     0.150
     6.515   104.652     0.150
     7.015   104.223     0.150
     7.310   108.121     0.150
     7.601   120.043     0.150
     7.655   120.312     0.150
     7.655   199.742     0.150
     8.144   126.281     0.150
     8.144   209.273     0.150
     8.150   126.371     0.150
     8.150   207.992     0.150
     8.241   127.523     0.150
     8.241   211.492     0.150
     8.393   129.801     0.150
     8.565   133.383     0.150
     8.477   120.453     0.150
     8.783   134.121     0.150
     8.626   122.637     0.150
     8.626   126.621     0.150
     8.626   127.223     0.150
     8.963   132.023     0.150
     9.141   137.762     0.150
     9.141   135.523     0.150
     9.581   146.691     0.150
     9.694   140.371     0.150
     9.812   141.895     0.150
     9.901   144.922     0.150
     9.958   143.953     0.150
    10.014   148.484     0.150
    10.312   154.145     0.150
    10.450   150.441     0.150
    10.804   155.512     0.150
    10.801   155.383     0.150
    10.895   156.551     0.150
    11.023   161.371     0.150
    11.161   159.621     0.150
    11.385   170.273     0.150
    12.406   172.523     0.150
    12.768   187.133     0.150
    12.838   178.422     0.150
    12.838   316.422     0.150
    13.400   197.133     0.150
    13.678   334.824     0.150
    14.473   199.523     0.150
    15.029   207.023     0.150
    14.961   212.613     0.150
    14.961   212.809     0.150
    14.961   212.621     0.150
    15.087   214.023     0.150
    15.489   219.145     0.150
    15.712   215.121     0.150
    74.072   234.922     0.150
    74.072   234.941     0.150
    21.247   285.824     0.150
    21.825   289.801     0.150
    23.373   307.223     0.150
    23.452   309.824     0.150
    23.757     8.199     0.150
    25.436   329.613     0.150
    27.746   345.164     0.150
    29.885   368.223     0.150
    30.978   376.223     0.150
    31.215   559.223     0.150
    33.927   401.023     0.150
    33.927   399.781     0.150
    33.927   400.723     0.150
    34.932   408.723     0.150
    83.707   412.922     0.150
    35.464   415.293     0.150
    36.092   419.922     0.150
    37.509   430.164     0.150
    37.749   436.223     0.150
    38.139   441.324     0.150
    38.139   441.336     0.150
    38.844   442.738     0.150
    38.916   443.703     0.150
    39.460   448.594     0.150
    39.460   448.523     0.150
    41.264   464.223     0.150
    42.112   469.887     0.150
    42.396   472.859     0.150
    42.657   474.055     0.150
    42.812   475.324     0.150
    44.164   487.223     0.150
    44.164  1569.223     0.150
    44.164  1749.223     0.150
    45.735   498.223     0.150
    45.840   501.121     0.150
    54.006   562.723     0.150
    60.198   604.461     0.150
    60.378   606.094     0.150
    60.988   610.895     0.150
    62.051   614.504     0.150
    62.568   625.074     0.150
    74.028   693.398     0.150
    74.028   693.012     0.150
    75.871   702.746     0.150
    75.871   703.023     0.150
    76.736   708.023     0.150
    40.896    70.136     0.150
     8.853   126.126     0.150
     8.864   128.445     0.150
     8.864   128.336     0.150
    16.208   225.376     0.150
    18.701   254.876     0.150
    18.701   253.217     0.150
    18.781   256.227     0.150
    21.555   286.670     0.150
    74.205   291.456     0.150
    22.042   290.626     0.150
    22.042   289.646     0.150
    22.351   297.676     0.150
    23.685     4.500     0.150
    26.298   334.546     0.150
    29.570     0.000     0.150
    29.867   361.926     0.150
    36.058   418.786     0.150
    36.058   418.786     0.150
    36.058   755.445     0.150
    39.292   444.437     0.150
    41.425   462.275     0.150
    42.415   472.166     0.150
    42.743   472.441     0.150
    43.002   474.525     0.150
    43.181   474.920     0.150
    43.181   474.916     0.150
    43.373   477.770     0.150
    43.718   479.912     0.150
    43.799   481.477     0.150
    43.819   481.113     0.150
    44.252   484.373     0.150
    44.921   490.717     0.150
    45.095   491.082     0.150
    45.935   497.648     0.150
    45.993   498.133     0.150
    46.282   500.367     0.150
    46.648   508.086     0.150
    46.827   504.727     0.150
    53.948     0.000     0.150
    76.684   704.275     0.150
    80.941  3599.000     0.150
    30.052   366.526     0.150
    49.644   528.826     0.150
     8.422   126.406     0.150
    74.272   179.516     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.688     0.150
    14.737   208.711     0.150
    14.737   208.719     0.150
    15.250   213.000     0.150
    15.951   222.391     0.150
    74.272   271.773     0.150
    19.874   276.086     0.150
    74.272   290.070     0.150
    23.277   308.586     0.150
    23.519   311.648     0.150
    29.580   366.367     0.150
    29.593   368.891     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.789     0.150
    29.959   370.422     0.150
    29.959   370.508     0.150
    30.503   375.898     0.150
    30.503   375.797     0.150
    31.201   381.570     0.150
    33.748   404.570     0.150
    33.956   404.312     0.150
    74.272   406.000     0.150
    74.272   405.266     0.150
    34.378   410.586     0.150
    34.327   410.852     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.995   422.188     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    34.997   415.891     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   420.688     0.150
    35.531   419.586     0.150
    36.014   425.234     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   432.586     0.150
    37.061   431.492     0.150
    37.197   434.586     0.150
    37.197   434.586     0.150
    37.197   434.586     0.150
    37.197   434.586     0.150
    37.197   434.586     0.150
    37.197   434.586     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.992     0.150
    80.369   434.977     0.150
    80.369   434.836     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.188     0.150
    37.672   438.148     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.760   438.289     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.808   438.992     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.949   440.086     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    37.966   440.586     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    38.373   445.086     0.150
    55.465   443.766     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.556   445.586     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.841   447.688     0.150
    38.879   446.219     0.150
    38.879   446.219     0.150
    38.879     7.969     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    38.917   450.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.178   452.188     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.349   457.586     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.483   454.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.391     0.150
    39.736   455.406     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.329   460.992     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.626   462.391     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    40.805   464.188     0.150
    41.010   464.992     0.150
    41.010   464.992     0.150
    41.010   464.992     0.150
    41.010   464.992     0.150
    41.010   464.992     0.150
    41.010   464.992     0.150
    41.010   464.992     0.150
    41.010   464.992     0.150
    41.010   464.945     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.113   466.789     0.150
    41.218   468.391     0.150
    41.218   468.391     0.150
    41.218   468.391     0.150
    41.218   468.391     0.150
    41.218   468.391     0.150
    41.218   468.391     0.150
    41.218   468.391     0.150
    41.218   468.391     0.150
    41.305   467.688     0.150
    41.305   467.688     0.150
    41.305   467.688     0.150
    41.305   467.688     0.150
    41.305   467.688     0.150
    41.305   467.688     0.150
    41.305   467.688     0.150
    41.305   467.688     0.150
    41.344   468.688     0.150
    41.344   468.688     0.150
    41.344   468.688     0.150
    41.344   468.688     0.150
    41.344   468.688     0.150
    41.344   468.688     0.150
    41.344   468.688     0.150
    41.344   468.688     0.150
    41.476   469.992     0.150
    41.476   469.992     0.150
    41.476   469.992     0.150
    41.476   469.992     0.150
    41.476   469.992     0.150
    41.476   469.992     0.150
    41.476   469.992     0.150
    41.476   469.992     0.150
    41.751   471.992     0.150
    41.751   471.992     0.150
    41.751   471.992     0.150
    41.751   471.992     0.150
    41.751   471.992     0.150
    41.751   471.992     0.150
    41.751   471.992     0.150
    41.751   471.992     0.150
    41.800   471.602     0.150
    41.904   474.086     0.150
    41.904   474.086     0.150
    41.904   474.086     0.150
    41.904   474.086     0.150
    41.904   474.086     0.150
    41.904   474.086     0.150
    41.904   474.086     0.150
    41.923   473.086     0.150
    41.923   473.086     0.150
    41.923   473.086     0.150
    41.923   473.086     0.150
    41.923   473.086     0.150
    41.923   473.086     0.150
    41.923   473.086     0.150
    41.923   473.086     0.150
    41.990   473.688     0.150
    41.990   473.688     0.150
    41.990   473.688     0.150
    41.990   473.688     0.150
    41.990   473.688     0.150
    41.990   473.688     0.150
    41.990   473.688     0.150
    42.056   474.289     0.150
    42.056   474.289     0.150
    42.056   474.289     0.150
    42.056   474.289     0.150
    42.056   474.289     0.150
    42.056   474.289     0.150
    42.056   474.289     0.150
    42.056   474.289     0.150
    42.165   474.992     0.150
    42.165   474.992     0.150
    42.165   474.992     0.150
    42.165   474.992     0.150
    42.165   474.992     0.150
    42.165   474.992     0.150
    42.165   474.992     0.150
    42.165  3599.969     0.150
    42.298   476.086     0.150
    42.298   475.898     0.150
    42.268   475.789     0.150
    42.268   475.789     0.150
    42.268   475.789     0.150
    42.268   475.789     0.150
    42.268   475.789     0.150
    42.398   474.992     0.150
    42.398   475.047     0.150
    42.447   477.391     0.150
    42.447   477.391     0.150
    42.447   477.391     0.150
    42.447   477.391     0.150
    42.447   477.391     0.150
    42.447   477.391     0.150
    42.447   477.391     0.150
    42.447     0.141     0.150
    42.498   480.289     0.150
    42.498   480.289     0.150
    42.498   480.289     0.150
    42.498   480.289     0.150
    42.498   480.289     0.150
    42.498   480.289     0.150
    42.498   480.289     0.150
    42.505   477.789     0.150
    42.505   477.789     0.150
    42.505   477.789     0.150
    42.505   477.789     0.150
    42.505   477.789     0.150
    42.505   477.789     0.150
    42.505   477.789     0.150
    42.647   478.992     0.150
    42.647   478.992     0.150
    42.647   478.992     0.150
    42.647   478.992     0.150
    42.647   478.992     0.150
    42.647   478.992     0.150
    42.647   478.992     0.150
    42.647   478.820     0.150
    42.713   479.586     0.150
    42.713   479.586     0.150
    42.713   479.586     0.150
    42.713   479.586     0.150
    42.713   479.586     0.150
    42.713   479.586     0.150
    42.713   479.586     0.150
    42.713     0.047     0.150
    42.868   481.188     0.150
    42.868   481.188     0.150
    42.868   481.188     0.150
    42.868   481.188     0.150
    42.868   481.188     0.150
    42.868   481.188     0.150
    42.868   481.188     0.150
    43.217   886.188     0.150
    43.245   483.992     0.150
    43.245   483.992     0.150
    43.245   483.992     0.150
    43.245   483.992     0.150
    43.245   483.992     0.150
    43.245   483.992     0.150
    43.245   483.992     0.150
    43.435   485.891     0.150
    43.435   485.891     0.150
    43.435   485.891     0.150
    43.435   485.891     0.150
    43.435   485.891     0.150
    43.435   485.891     0.150
    43.435   485.891     0.150
    43.435     0.367     0.150
    43.489   485.633     0.150
    43.905   881.789     0.150
    43.905   488.719     0.150
    44.381   491.102     0.150
    44.381   495.289     0.150
    44.381   491.102     0.150
    44.381   491.414     0.150
    44.381     8.523     0.150
    44.642   495.070     0.150
    44.644   496.039     0.150
    44.649   494.945     0.150
    45.064   499.078     0.150
    45.235   500.906     0.150
    45.407   500.578     0.150
    45.515   501.023     0.150
    45.515   503.953     0.150
    45.515   499.367     0.150
    45.515   501.023     0.150
    45.515   503.953     0.150
    45.515   499.367     0.150
    45.515   501.023     0.150
    45.711   497.391     0.150
    45.915   504.828     0.150
    45.915     0.023     0.150
    46.332   507.781     0.150
    59.150   508.367     0.150
    46.534   509.133     0.150
    46.913   514.500     0.150
    29.620   513.945     0.150
    47.146   515.445     0.150
    47.487   515.188     0.150
    49.189   531.211     0.150
    49.446   532.156     0.150
    49.478   532.148     0.150
    50.583   540.992     0.150
    51.846   550.812     0.150
    97.023   557.453     0.150
    97.023   559.883     0.150
    53.459   560.742     0.150
    53.781   563.289     0.150
    55.879   578.477     0.150
    56.392   581.961     0.150
    58.352   597.242     0.150
    58.476   597.898     0.150
    60.286   609.602     0.150
    60.286   609.539     0.150
    60.686   612.742     0.150
    60.892   613.383     0.150
    69.356   669.586     0.150
    69.356   669.586     0.150
    69.356   669.586     0.150
    69.356   669.586     0.150
    74.272   680.914     0.150
    74.272   680.758     0.150
    72.137   680.773     0.150
    74.438   699.992     0.150
    74.438   699.992     0.150
    75.053   703.602     0.150
    76.275   711.188     0.150
    76.439   713.195     0.150
    55.465   714.102     0.150
    55.465   721.617     0.150
    78.894   722.875     0.150
    80.734   732.812     0.150
   129.412   733.859     0.150
   101.227   738.820     0.150
    55.465   743.859     0.150
    89.953   781.438     0.150
    89.957   780.656     0.150
    89.957   781.430     0.150
    55.465   792.000     0.150
    93.871   798.312     0.150
    74.272   833.328     0.150
    74.272   834.227     0.150
   105.700   856.828     0.150
    74.272  1130.586     0.150
   118.681   913.625     0.150
   122.463  1131.531     0.150
    62.079  1149.508     0.150
   141.490  1169.359     0.150
     1.379    25.383     0.150
     5.341    85.133     0.150
     5.899    92.148     0.150
    74.272    97.969     0.150
     7.186   110.906     0.150
    74.272   272.117     0.150
    20.055   275.211     0.150
    74.272   289.586     0.150
    25.125   326.281     0.150
    29.372   363.656     0.150
    29.959   370.789     0.150
    30.503   374.516     0.150
    33.748   403.086     0.150
    39.057   446.977     0.150
    45.159   498.312     0.150
    47.487   515.070     0.150
    53.781   563.016     0.150
    59.370   600.328     0.150
    63.515   630.328     0.150
    74.272   679.477     0.150
    73.683   694.148     0.150
    76.234   708.180     0.150
    84.289   753.438     0.150
    74.272  1129.922     0.150
   134.873  1161.617     0.150
     7.635   119.055     0.150
     8.385   128.344     0.150
    15.986   223.883     0.150
    42.708   480.289     0.150
    44.367   494.344     0.150
    44.367   494.344     0.150
    45.501   500.320     0.150
    46.888   513.742     0.150
    49.308   533.500     0.150
     1.404    26.586     0.150
     5.485    86.398     0.150
     7.148   109.031     0.150
    10.896   160.711     0.150
    21.576   291.820     0.150
    42.092   473.086     0.150
    45.483   500.398     0.150
     1.329    27.156     0.150
     1.329    26.898     0.150
     4.155    66.016     0.150
     8.461   124.617     0.150
    74.222   181.305     0.150
    15.284   214.562     0.150
    18.352   255.422     0.150
    74.222   272.672     0.150
    21.314   292.680     0.150
    74.222   291.203     0.150
    29.612   367.625     0.150
    30.012   371.703     0.150
    74.222   406.680     0.150
    39.063   448.625     0.150
    41.242   467.750     0.150
    44.696   498.336     0.150
    47.951   524.883     0.150
    60.328   610.453     0.150
    74.001   700.102     0.150
    74.447   702.961     0.150
    75.189   706.883     0.150
    76.271   709.219     0.150
    78.955   725.438     0.150
    29.827   372.711     0.150
    55.489   558.852     0.150
   110.958   552.609     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    14.783   209.922     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    30.012   371.820     0.150
    31.191   381.219     0.150
    74.222   406.508     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.617     0.150
    34.970   416.633     0.150
    35.061   416.438     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    35.504   421.516     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.034   433.719     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    37.171   435.320     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.719     0.150
    80.406   435.688     0.150
    80.406   435.617     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.645   438.922     0.150
    37.714   440.719     0.150
    37.733   439.016     0.150
    37.733   439.016     0.150
    37.733   439.016     0.150
    37.733   439.016     0.150
    37.733   439.016     0.150
    37.733   439.016     0.150
    37.733   439.016     0.150
    37.733   439.016     0.150
    37.733   438.945     0.150
    37.783   439.922     0.150
    37.783   439.922     0.150
    37.783   439.922     0.150
    37.783   439.922     0.150
    37.783   439.922     0.150
    37.783   439.922     0.150
    37.783   439.922     0.150
    37.783   439.922     0.150
    37.928   440.719     0.150
    37.928   440.719     0.150
    37.928   440.719     0.150
    37.928   440.719     0.150
    37.928   440.719     0.150
    37.928   440.719     0.150
    37.928   440.719     0.150
    37.928   440.719     0.150
    37.942   441.016     0.150
    37.942   441.016     0.150
    37.942   441.016     0.150
    37.942   441.016     0.150
    37.942   441.016     0.150
    37.942   441.016     0.150
    37.942   441.016     0.150
    37.942   441.016     0.150
    37.942   440.922     0.150
    38.348   447.219     0.150
    38.348   447.219     0.150
    38.348   447.219     0.150
    38.348   447.219     0.150
    38.348   447.219     0.150
    38.348   447.219     0.150
    38.348   447.219     0.150
    38.528   446.219     0.150
    38.528   446.219     0.150
    38.528   446.219     0.150
    38.528   446.219     0.150
    38.528   446.219     0.150
    38.528   446.219     0.150
    38.528   446.219     0.150
    38.874   447.031     0.150
    38.874   447.031     0.150
    38.874   452.617     0.150
    38.817   448.422     0.150
    38.817   448.422     0.150
    38.817   448.422     0.150
    38.817   448.422     0.150
    38.817   448.422     0.150
    38.817   448.422     0.150
    38.817   448.422     0.150
    39.152   452.516     0.150
    39.152   452.516     0.150
    39.152   452.516     0.150
    39.152   452.516     0.150
    39.152   452.516     0.150
    39.152   452.516     0.150
    39.712   456.016     0.150
    39.712   456.016     0.150
    39.712   456.016     0.150
    39.712   456.016     0.150
    39.712   456.016     0.150
    39.712   456.016     0.150
    39.712   456.016     0.150
    40.600   463.016     0.150
    40.600   463.016     0.150
    40.600   463.016     0.150
    40.600   463.016     0.150
    40.600   463.016     0.150
    40.600   462.930     0.150
    40.780   465.016     0.150
    40.780   465.016     0.150
    40.780   465.016     0.150
    40.780   465.016     0.150
    40.780   465.016     0.150
    40.983   465.820     0.150
    40.983   465.820     0.150
    40.983   465.820     0.150
    40.983   465.820     0.150
    40.983   465.820     0.150
    41.195   469.117     0.150
    41.195   469.117     0.150
    41.195   469.117     0.150
    41.195   469.117     0.150
    41.283   468.617     0.150
    41.283   468.617     0.150
    41.283   468.617     0.150
    41.283   468.617     0.150
    41.283   468.617     0.150
    41.283   468.703     0.150
    41.319   469.320     0.150
    41.319   469.320     0.150
    41.319   469.320     0.150
    41.319   469.320     0.150
    41.451   471.516     0.150
    41.451   471.516     0.150
    41.451   471.516     0.150
    41.451   471.516     0.150
    41.723   473.016     0.150
    41.723   473.016     0.150
    41.723   473.016     0.150
    41.723   473.016     0.150
    41.878   476.219     0.150
    41.878   476.219     0.150
    41.878   476.219     0.150
    41.878   476.219     0.150
    41.901   473.820     0.150
    41.901   473.820     0.150
    41.901   473.820     0.150
    41.966   474.117     0.150
    41.966   474.117     0.150
    41.966   474.117     0.150
    42.034   474.820     0.150
    42.034   474.820     0.150
    42.034   474.820     0.150
    42.034   474.820     0.150
    42.141   475.719     0.150
    42.141   475.719     0.150
    42.141   475.719     0.150
    42.242   476.422     0.150
    42.242   476.422     0.150
    42.423   478.016     0.150
    42.423   478.016     0.150
    42.423   478.016     0.150
    42.423   478.016     0.150
    42.478   478.516     0.150
    42.478   478.516     0.150
    42.478   478.516     0.150
    42.625   479.617     0.150
    42.625   479.617     0.150
    42.625   479.617     0.150
    42.625   479.617     0.150
    42.688   480.516     0.150
    42.688   480.516     0.150
    42.688   480.516     0.150
    42.841   481.820     0.150
    42.841   481.820     0.150
    43.224   484.422     0.150
    43.224   484.422     0.150
    43.224   484.422     0.150
    43.224   484.422     0.150
    43.410   486.617     0.150
    43.410   486.617     0.150
    44.372   491.930     0.150
    44.372   491.945     0.150
    44.372   495.945     0.150
    44.372   491.930     0.150
    44.372   491.930     0.150
    44.372   491.945     0.150
    44.372   495.945     0.150
    44.372   499.234     0.150
    45.507   500.484     0.150
    45.507   500.484     0.150
    47.380   518.531     0.150
    53.445   561.469     0.150
    53.445   566.867     0.150
    55.364   575.484     0.150
    61.035   615.867     0.150
    62.423   620.062     0.150
     1.329    27.359     0.150
     1.329    43.391     0.150
    74.222    98.820     0.150
     7.163   109.469     0.150
     8.790   131.945     0.150
    10.981   160.117     0.150
    74.222   180.625     0.150
    14.783   210.109     0.150
    74.222   272.422     0.150
    20.020   275.180     0.150
    74.222   290.906     0.150
    74.222   292.031     0.150
    23.286   309.516     0.150
    23.491   312.445     0.150
    74.222   315.680     0.150
    38.543   444.352     0.150
    39.063   448.719     0.150
    42.404   476.008     0.150
    45.205   499.578     0.150
    45.385   500.250     0.150
    45.571   500.258     0.150
    47.527   516.031     0.150
    54.601   570.320     0.150
    74.222   681.008     0.150
    74.222  1128.375     0.150
   124.491  1138.141     0.150
    74.222  1150.219     0.150
     1.329    26.711     0.150
     1.329    26.625     0.150
    74.222   272.695     0.150
    74.222   291.102     0.150
    26.199   335.648     0.150
    36.447   424.523     0.150
    44.370   491.656     0.150
    44.370   491.656     0.150
    44.370   494.617     0.150
    45.505   502.336     0.150
    69.114   672.133     0.150
   116.324  1125.227     0.150
    42.402   560.359     0.150
   110.956   550.578     0.150
     1.329    26.625     0.150
     4.153    68.133     0.150
     4.153    69.609     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    14.781   210.133     0.150
    74.222   316.234     0.150
    26.199   335.484     0.150
    29.613   367.766     0.150
    29.741   369.203     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.930     0.150
    30.010   371.992     0.150
    30.010   371.734     0.150
    30.590   378.930     0.150
    74.222   406.891     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    34.969   417.234     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    35.502   421.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.633     0.150
    37.032   433.688     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    37.170   435.430     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.633     0.150
    80.404   435.836     0.150
    80.404   435.430     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.031     0.150
    37.644   439.047     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.930     0.150
    37.781   439.984     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.926   440.930     0.150
    37.941   441.133     0.150
    37.941   441.133     0.150
    37.941   441.133     0.150
    37.941   441.133     0.150
    37.941   441.133     0.150
    37.941   441.133     0.150
    37.941   441.133     0.150
    38.347   445.734     0.150
    38.347   445.734     0.150
    38.347   445.734     0.150
    38.347   445.734     0.150
    38.347   445.734     0.150
    38.347   445.734     0.150
    38.347   445.734     0.150
    38.347   445.734     0.150
    38.347   445.531     0.150
    55.487   445.180     0.150
    38.527   446.336     0.150
    38.527   446.336     0.150
    38.527   446.336     0.150
    38.527   446.336     0.150
    38.527   446.336     0.150
    38.527   446.336     0.150
    38.527   446.336     0.150
    38.527   446.312     0.150
    38.816   448.430     0.150
    38.816   448.430     0.150
    38.816   448.430     0.150
    38.816   448.430     0.150
    38.816   448.430     0.150
    38.816   448.430     0.150
    38.816   448.430     0.150
    38.872   446.703     0.150
    39.061   448.633     0.150
    39.151   452.430     0.150
    39.151   452.430     0.150
    39.151   452.430     0.150
    39.151   452.430     0.150
    39.151   452.430     0.150
    39.151   452.430     0.150
    39.151   452.430     0.150
    39.151   452.406     0.150
    39.457   455.031     0.150
    39.457   455.031     0.150
    39.457   455.031     0.150
    39.457   455.031     0.150
    39.457   455.031     0.150
    39.457   455.031     0.150
    39.457   454.836     0.150
    39.710   456.031     0.150
    39.710   456.031     0.150
    39.710   456.031     0.150
    39.710   456.031     0.150
    39.710   456.031     0.150
    39.710   456.031     0.150
    40.598   463.234     0.150
    40.598   463.234     0.150
    40.598   463.234     0.150
    40.598   463.234     0.150
    40.598   463.234     0.150
    40.598   463.234     0.150
    40.779   464.930     0.150
    40.779   464.930     0.150
    40.779   464.930     0.150
    40.779   464.930     0.150
    40.779   464.930     0.150
    40.982   465.836     0.150
    40.982   465.836     0.150
    40.982   465.836     0.150
    40.982   465.836     0.150
    40.982   465.836     0.150
    41.194   469.133     0.150
    41.194   469.133     0.150
    41.194   469.133     0.150
    41.194   469.133     0.150
    41.282   468.531     0.150
    41.282   468.531     0.150
    41.282   468.531     0.150
    41.282   468.531     0.150
    41.318   469.336     0.150
    41.318   469.336     0.150
    41.318   469.336     0.150
    41.318   469.336     0.150
    41.450   472.336     0.150
    41.450   472.336     0.150
    41.450   472.336     0.150
    41.450   472.336     0.150
    41.722   472.836     0.150
    41.722   472.836     0.150
    41.722   472.836     0.150
    41.722   472.836     0.150
    41.877   476.336     0.150
    41.877   476.336     0.150
    41.877   476.336     0.150
    41.877   476.336     0.150
    41.899   473.836     0.150
    41.899   473.836     0.150
    41.899   473.836     0.150
    41.899   473.836     0.150
    41.899   473.789     0.150
    41.964   474.031     0.150
    41.964   474.031     0.150
    41.964   474.031     0.150
    41.964   474.031     0.150
    42.032   475.031     0.150
    42.032   475.031     0.150
    42.032   475.031     0.150
    42.032   475.031     0.150
    42.139   475.734     0.150
    42.139   475.734     0.150
    42.139   475.734     0.150
    42.139   475.734     0.150
    42.241   476.430     0.150
    42.241   476.430     0.150
    42.422   477.930     0.150
    42.422   477.930     0.150
    42.422   477.930     0.150
    42.422   477.930     0.150
    42.422   477.891     0.150
    42.477   478.633     0.150
    42.477   478.633     0.150
    42.477   478.633     0.150
    42.624   479.633     0.150
    42.624   479.633     0.150
    42.624   479.633     0.150
    42.687   480.531     0.150
    42.687   480.531     0.150
    42.687   480.531     0.150
    42.687   480.531     0.150
    42.840   481.836     0.150
    42.840   481.836     0.150
    42.840   481.836     0.150
    43.222   484.531     0.150
    43.222   484.531     0.150
    43.222   484.531     0.150
    43.408   486.633     0.150
    43.408   486.633     0.150
    43.408   486.633     0.150
    44.370   491.656     0.150
    44.370   491.656     0.150
    44.370   491.656     0.150
    44.370   494.617     0.150
    44.370     6.578     0.150
    45.505   500.133     0.150
    45.505   502.336     0.150
    50.320   538.531     0.150
    53.833   564.633     0.150
    60.326   610.531     0.150
     1.329    41.734     0.150
    18.350   255.602     0.150
    74.222   271.023     0.150
    20.019   274.422     0.150
    74.222   290.172     0.150
    74.222   292.180     0.150
    23.284   309.133     0.150
    74.222   315.203     0.150
    27.831   349.125     0.150
    36.205   424.000     0.150
    44.696   495.305     0.150
    47.462   516.562     0.150
    47.952   519.273     0.150
    54.600   570.281     0.150
    74.222   679.820     0.150
    71.523   681.109     0.150
    73.195   692.305     0.150
    73.632   694.359     0.150
    74.448   699.156     0.150
    74.222  1129.531     0.150
   124.493  1138.930     0.150
    74.222  1148.992     0.150
    74.222  1182.016     0.150
     1.331    27.367     0.150
    14.774   209.827     0.150
    14.774   209.827     0.150
    14.774   209.827     0.150
    14.774   209.827     0.150
    21.776   296.273     0.150
    23.486   313.927     0.150
    26.938   337.167     0.150
    29.831   371.227     0.150
    30.005   371.927     0.150
    30.005   371.927     0.150
    30.005   371.927     0.150
    74.224   406.368     0.150
    35.498   421.527     0.150
    35.498   421.527     0.150
    35.498   421.527     0.150
    37.165   436.627     0.150
    37.165   436.627     0.150
    37.165   436.627     0.150
    37.165   436.627     0.150
    37.639   439.327     0.150
    37.639   439.327     0.150
    37.639   439.327     0.150
    37.777   440.227     0.150
    37.777   440.227     0.150
    37.777   440.227     0.150
    37.921   441.027     0.150
    37.921   441.027     0.150
    37.921   441.027     0.150
    38.865   446.787     0.150
    40.978   466.127     0.150
    40.978   466.127     0.150
    40.978   466.127     0.150
    41.894   475.727     0.150
    41.894   475.727     0.150
    41.894   475.727     0.150
    41.894   472.306     0.150
    42.417   480.027     0.150
    42.417   480.027     0.150
    42.417   476.979     0.150
    43.494   485.457     0.150
    43.876   500.927     0.150
    44.364   491.714     0.150
    44.364   491.688     0.150
    44.364   491.714     0.150
    44.364   496.302     0.150
     1.331    26.727     0.150
     5.893    92.517     0.150
    74.224    97.797     0.150
     7.219   109.587     0.150
    14.774   209.757     0.150
    74.224   234.557     0.150
    74.224   271.997     0.150
    20.016   275.627     0.150
    74.224   290.507     0.150
    74.224   292.517     0.150
    74.224   314.637     0.150
    76.261   709.477     0.150
     2.921    82.668     0.150
     1.259    25.652     0.150
     8.504   128.213     0.150
     9.019   138.273     0.150
    74.150   316.184     0.150
    36.987   430.822     0.150
    37.457   438.283     0.150
    38.856   446.693     0.150
    40.937   467.143     0.150
    41.350   469.584     0.150
    42.400   475.793     0.150
    42.732   480.459     0.150
    44.348   494.684     0.150
    44.348   491.357     0.150
    44.348   491.846     0.150
    44.348   494.684     0.150
    45.214   500.893     0.150
    45.484   502.371     0.150
    46.938   514.732     0.150
    50.454   541.783     0.150
    53.414   564.184     0.150
    57.445   593.143     0.150
    81.283   736.803     0.150
    74.150   835.344     0.150
     1.259    25.684     0.150
     4.156    64.643     0.150
     5.589    86.693     0.150
    74.150    99.273     0.150
     6.804   102.443     0.150
     6.895   103.812     0.150
     7.194   107.543     0.150
     7.279   109.393     0.150
     8.504   124.883     0.150
     8.840   128.594     0.150
    19.964   272.744     0.150
    74.150   290.213     0.150
    74.150   313.094     0.150
    28.623   358.424     0.150
    29.767   367.594     0.150
    32.974   395.354     0.150
    35.457   418.383     0.150
    42.400   475.793     0.150
    50.454   539.633     0.150
    58.070   596.473     0.150
    58.397   598.334     0.150
    74.321   699.123     0.150
     1.325    26.648     0.150
     1.325    50.219     0.150
     1.325    26.875     0.150
     8.615   130.746     0.150
    74.220   180.641     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.488     0.150
    14.745   209.465     0.150
    15.315   213.539     0.150
    17.978   250.398     0.150
    18.149   256.281     0.150
    74.220   273.734     0.150
    74.220   290.598     0.150
    29.710   370.715     0.150
    29.885   368.996     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    29.990   372.387     0.150
    74.220   406.203     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.887     0.150
    34.932   415.809     0.150
    34.932   415.887     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    35.466   421.188     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    36.996   432.988     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    37.132   435.285     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.988     0.150
    80.359   435.586     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.607   438.688     0.150
    37.696   438.688     0.150
    37.696   438.688     0.150
    37.696   438.688     0.150
    37.696   438.688     0.150
    37.696   438.688     0.150
    37.696   438.688     0.150
    37.696   438.688     0.150
    37.696   438.688     0.150
    37.696   440.055     0.150
    37.696   438.688     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.744   439.586     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.886   440.387     0.150
    37.902   440.887     0.150
    37.902   440.887     0.150
    37.902   440.887     0.150
    37.902   440.887     0.150
    37.902   440.887     0.150
    38.521   446.891     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.491   445.988     0.150
    38.777   448.387     0.150
    38.777   448.387     0.150
    38.777   448.387     0.150
    38.777   448.387     0.150
    38.777   448.387     0.150
    38.777   448.387     0.150
    38.777   448.387     0.150
    38.777   448.387     0.150
    39.672   455.887     0.150
    39.672   455.887     0.150
    39.672   455.887     0.150
    39.672   455.887     0.150
    39.672   455.887     0.150
    39.672   455.887     0.150
    39.672   455.887     0.150
    40.561   462.785     0.150
    40.561   462.785     0.150
    40.561   462.785     0.150
    40.561   462.785     0.150
    40.561   462.785     0.150
    40.561   462.785     0.150
    40.740   464.688     0.150
    40.740   464.688     0.150
    40.740   464.688     0.150
    40.740   464.688     0.150
    40.740   464.688     0.150
    40.740   464.688     0.150
    40.945   465.688     0.150
    40.945   465.688     0.150
    40.945   465.688     0.150
    40.945   465.688     0.150
    40.945   465.688     0.150
    40.945   465.688     0.150
    41.049   469.488     0.150
    41.049   469.488     0.150
    41.049   469.488     0.150
    41.049   469.488     0.150
    41.049   469.488     0.150
    41.049   469.488     0.150
    41.049   469.488     0.150
    41.154   468.887     0.150
    41.154   468.887     0.150
    41.154   468.887     0.150
    41.154   468.887     0.150
    41.154   468.887     0.150
    41.241   468.285     0.150
    41.241   468.285     0.150
    41.241   468.285     0.150
    41.241   468.285     0.150
    41.241   468.285     0.150
    41.280   469.188     0.150
    41.280   469.188     0.150
    41.280   469.188     0.150
    41.280   469.188     0.150
    41.280   469.188     0.150
    41.859   473.688     0.150
    41.859   473.688     0.150
    41.859   473.688     0.150
    41.859   473.688     0.150
    41.859   473.688     0.150
    41.926   474.188     0.150
    41.926   474.188     0.150
    41.926   474.188     0.150
    41.926   474.188     0.150
    41.926   474.188     0.150
    41.993   474.887     0.150
    41.993   474.887     0.150
    41.993   474.887     0.150
    41.993   474.887     0.150
    41.993   474.887     0.150
    42.101   475.688     0.150
    42.101   475.688     0.150
    42.101   475.688     0.150
    42.101   475.688     0.150
    42.101   475.688     0.150
    42.101  3599.172     0.150
    42.203   477.086     0.150
    42.203   477.086     0.150
    42.203   477.086     0.150
    42.203   477.086     0.150
    42.383   477.785     0.150
    42.383   477.785     0.150
    42.383   477.785     0.150
    42.383   477.785     0.150
    42.383  3599.980     0.150
    42.648   482.086     0.150
    42.648   482.086     0.150
    42.648   482.086     0.150
    42.648   482.086     0.150
    42.648   482.086     0.150
    42.648  3597.457     0.150
    42.803   481.887     0.150
    42.803   481.887     0.150
    42.803   481.887     0.150
    42.803   481.887     0.150
    43.182   484.285     0.150
    43.182   484.285     0.150
    43.182   484.285     0.150
    43.182   484.285     0.150
    43.182   483.285     0.150
    43.371   486.688     0.150
    43.371   486.688     0.150
    43.371   486.688     0.150
    43.371   486.688     0.150
    43.371  3598.992     0.150
    43.460   486.000     0.150
    74.380   700.285     0.150
    74.380   700.285     0.150
    83.445   750.152     0.150
   105.900   483.520     0.150
    55.437   557.441     0.150
   110.907   550.168     0.150
    44.437   549.867     0.150
     8.416   127.086     0.150
    16.968   236.285     0.150
    19.339   265.988     0.150
    21.283   292.586     0.150
    33.683   404.137     0.150
    33.694   404.523     0.150
    33.893   404.914     0.150
    74.220   406.547     0.150
    34.986   416.688     0.150
    35.525   420.965     0.150
    36.996   433.145     0.150
    37.132   433.539     0.150
    37.461   437.453     0.150
    37.696   438.414     0.150
    37.744   439.793     0.150
    38.149   443.211     0.150
    38.465   445.602     0.150
    38.823   446.457     0.150
    38.823   446.457     0.150
    38.823   452.277     0.150
    40.561   462.766     0.150
    41.859   473.738     0.150
    42.582   478.398     0.150
    44.323   493.074     0.150
    44.323   491.398     0.150
    44.323   492.223     0.150
    44.323   493.074     0.150
    44.323     8.102     0.150
    44.323     8.289     0.150
    44.323   491.398     0.150
    44.323   492.223     0.150
    44.323   493.074     0.150
    44.323   499.500     0.150
    44.323   499.688     0.150
    45.457   500.148     0.150
    45.457   500.137     0.150
    45.457   500.148     0.150
    45.457   500.137     0.150
    45.457   500.148     0.150
    46.381   507.688     0.150
    46.869   511.656     0.150
    46.869   511.637     0.150
    46.869   511.656     0.150
    46.869   511.637     0.150
    46.869   511.656     0.150
    49.149   532.887     0.150
    53.398   560.961     0.150
    53.398   560.988     0.150
    53.398   565.812     0.150
    53.398   567.211     0.150
    56.008   576.785     0.150
    76.224   707.285     0.150
     1.325    26.785     0.150
     5.850    92.367     0.150
    74.220    98.516     0.150
     7.113   108.578     0.150
     7.645   116.328     0.150
     8.416   127.258     0.150
    74.220   180.605     0.150
    74.220   235.785     0.150
    74.220   272.488     0.150
    74.220   290.715     0.150
    74.220   292.867     0.150
    74.220   314.625     0.150
    25.191   326.676     0.150
    26.171   337.125     0.150
    27.805   351.078     0.150
    28.604   358.105     0.150
    29.885   369.066     0.150
    29.990   370.848     0.150
    44.709   496.016     0.150
    47.978   520.676     0.150
    50.269   537.758     0.150
    54.039   566.438     0.150
    74.220   680.297     0.150
    84.353   751.977     0.150
     1.390    27.391     0.150
    14.841   216.273     0.150
    74.284   293.391     0.150
     1.292    25.951     0.150
    17.048   241.400     0.150
    21.291   289.912     0.150
    22.981   310.701     0.150
    74.183   406.271     0.150
    36.098   426.375     0.150
    41.919   471.092     0.150
    44.371   493.361     0.150
    44.371   493.373     0.150
    44.371   493.711     0.150
    44.590   494.139     0.150
    45.662   501.969     0.150
    46.495   508.914     0.150
     1.292    25.480     0.150
    74.183    97.682     0.150
    14.821   209.641     0.150
    74.183   235.141     0.150
    74.183   292.381     0.150
    73.152   691.162     0.150
    76.498   711.551     0.150
    77.691   718.721     0.150
    81.253   736.441     0.150
     2.963    86.186     0.150
     1.300    26.230     0.150
     1.300    26.367     0.150
     5.918    92.809     0.150
     5.918   154.977     0.150
     8.495   127.941     0.150
    74.191   180.090     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    14.819   210.477     0.150
    15.299   215.297     0.150
    74.191   232.656     0.150
    17.977   250.336     0.150
    74.191   272.430     0.150
    21.300   292.207     0.150
    74.191   290.469     0.150
    23.304   309.152     0.150
    23.483   311.926     0.150
    26.184   339.566     0.150
    29.104   364.070     0.150
    29.104   364.145     0.150
    29.624   367.027     0.150
    29.869   369.457     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   371.754     0.150
    30.048   372.094     0.150
    30.048   372.156     0.150
    30.454   376.305     0.150
    30.565   376.637     0.150
    31.196   380.949     0.150
    31.196   380.934     0.150
    32.519   393.816     0.150
    33.934   405.047     0.150
    74.191   406.082     0.150
    74.191   406.047     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    34.962   415.887     0.150
    35.054   415.914     0.150
    35.062   417.707     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    36.702   428.414     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.025   432.984     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    80.439   435.152     0.150
    80.439   435.504     0.150
    37.486   434.984     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.457     0.150
    37.725   438.488     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.855     0.150
    37.776   439.918     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.924   440.656     0.150
    37.937   440.555     0.150
    37.937   440.555     0.150
    37.937   440.555     0.150
    37.937   440.555     0.150
    37.937   440.555     0.150
    37.937   440.555     0.150
    37.937   440.555     0.150
    37.937   440.555     0.150
    38.342   446.055     0.150
    38.342   446.055     0.150
    38.342   446.055     0.150
    38.342   446.055     0.150
    38.342   446.055     0.150
    38.342   446.055     0.150
    38.342   446.055     0.150
    38.342   446.055     0.150
    55.516   444.922     0.150
    38.520   445.656     0.150
    38.520   445.656     0.150
    38.520   445.656     0.150
    38.520   445.656     0.150
    38.520   445.656     0.150
    38.520   445.656     0.150
    38.520   445.656     0.150
    38.520   445.656     0.150
    38.520   445.875     0.150
    38.812   448.156     0.150
    38.812   448.156     0.150
    38.812   448.156     0.150
    38.812   448.156     0.150
    38.812   448.156     0.150
    38.812   448.156     0.150
    38.812   448.156     0.150
    38.812   448.156     0.150
    38.812   448.086     0.150
    38.881   449.957     0.150
    38.881   449.957     0.150
    38.881   449.957     0.150
    38.881   449.957     0.150
    38.881   449.957     0.150
    38.881   449.957     0.150
    39.079   448.117     0.150
    38.963   451.586     0.150
    39.145   452.055     0.150
    39.145   452.055     0.150
    39.145   452.055     0.150
    39.145   452.055     0.150
    39.145   452.055     0.150
    39.145   452.055     0.150
    39.145   452.055     0.150
    39.320   454.254     0.150
    39.320   454.254     0.150
    39.320   454.254     0.150
    39.320   454.254     0.150
    39.320   454.254     0.150
    39.320   454.254     0.150
    39.320   454.254     0.150
    39.452   454.754     0.150
    39.452   454.754     0.150
    39.452   454.754     0.150
    39.452   454.754     0.150
    39.452   454.754     0.150
    39.452   454.754     0.150
    39.452   454.754     0.150
    39.706   455.555     0.150
    39.706   455.555     0.150
    39.706   455.555     0.150
    39.706   455.555     0.150
    39.706   455.555     0.150
    39.706   455.555     0.150
    39.706   455.777     0.150
    39.840   455.867     0.150
    40.298   460.855     0.150
    40.298   460.855     0.150
    40.298   460.855     0.150
    40.298   460.855     0.150
    40.298   460.855     0.150
    40.298   460.855     0.150
    40.592   462.457     0.150
    40.592   462.457     0.150
    40.592   462.457     0.150
    40.592   462.457     0.150
    40.592   462.457     0.150
    40.592   462.457     0.150
    40.592   462.555     0.150
    40.774   464.055     0.150
    40.774   464.055     0.150
    40.774   464.055     0.150
    40.774   464.055     0.150
    40.774   464.055     0.150
    40.976   465.355     0.150
    40.976   465.355     0.150
    40.976   465.355     0.150
    40.976   465.355     0.150
    40.976   465.355     0.150
    40.976   465.355     0.150
    40.976   465.727     0.150
    41.081   466.855     0.150
    41.081   466.855     0.150
    41.081   466.855     0.150
    41.081   466.855     0.150
    41.081   466.855     0.150
    41.081   466.855     0.150
    41.242   465.406     0.150
    41.190   468.254     0.150
    41.190   468.254     0.150
    41.190   468.254     0.150
    41.190   468.254     0.150
    41.190   468.254     0.150
    41.279   468.156     0.150
    41.279   468.156     0.150
    41.279   468.156     0.150
    41.279   468.156     0.150
    41.279   468.156     0.150
    41.279   468.102     0.150
    41.313   468.656     0.150
    41.313   468.656     0.150
    41.313   468.656     0.150
    41.313   468.656     0.150
    41.313   468.656     0.150
    41.313   468.516     0.150
    41.445   471.055     0.150
    41.445   471.055     0.150
    41.445   471.055     0.150
    41.445   471.055     0.150
    41.445   471.055     0.150
    41.715   472.254     0.150
    41.715   472.254     0.150
    41.715   472.254     0.150
    41.715   472.254     0.150
    41.715   472.254     0.150
    41.871   473.855     0.150
    41.871   473.855     0.150
    41.871   473.855     0.150
    41.897   473.355     0.150
    41.897   473.355     0.150
    41.897   473.355     0.150
    41.897   473.355     0.150
    41.897   473.539     0.150
    41.960   473.855     0.150
    41.960   473.855     0.150
    41.960   473.855     0.150
    41.960   473.855     0.150
    41.960   473.867     0.150
    42.029   474.254     0.150
    42.029   474.254     0.150
    42.029   474.254     0.150
    42.029   474.254     0.150
    42.029   474.320     0.150
    42.135   475.055     0.150
    42.135   475.055     0.150
    42.135   475.055     0.150
    42.135   475.055     0.150
    42.135     0.164     0.150
    42.370   476.875     0.150
    42.370   476.914     0.150
    42.235   476.055     0.150
    42.235   476.055     0.150
    42.420   475.777     0.150
    42.420   475.875     0.150
    42.417   477.457     0.150
    42.417   477.457     0.150
    42.417   477.457     0.150
    42.417   477.457     0.150
    42.417     0.293     0.150
    42.464   480.754     0.150
    42.464   480.754     0.150
    42.464   480.754     0.150
    42.471   478.055     0.150
    42.471   478.055     0.150
    42.471   478.055     0.150
    42.621   479.055     0.150
    42.621   479.055     0.150
    42.621   479.055     0.150
    42.621   479.055     0.150
    42.602   478.176     0.150
    42.682   479.855     0.150
    42.682   479.855     0.150
    42.682   479.855     0.150
    42.682  3599.832     0.150
    42.833   481.254     0.150
    42.833   481.254     0.150
    43.220   483.957     0.150
    43.220   483.957     0.150
    43.220   483.957     0.150
    43.403   485.754     0.150
    43.403   485.754     0.150
    43.403   485.754     0.150
    43.403     0.039     0.150
    43.494     0.090     0.150
    43.878   489.117     0.150
    44.177  3599.934     0.150
    44.728   495.566     0.150
    44.721   496.797     0.150
    44.775   497.586     0.150
    44.752   496.777     0.150
    45.137   500.004     0.150
    45.231   501.387     0.150
    45.578   501.695     0.150
    45.607   500.574     0.150
    45.607   500.664     0.150
    46.303   508.156     0.150
    59.232   508.547     0.150
    46.504   509.574     0.150
    29.574   514.047     0.150
    47.409   516.535     0.150
    47.561   515.926     0.150
    47.423   518.297     0.150
    47.914   521.914     0.150
    50.153   538.637     0.150
    50.680   542.836     0.150
    53.370   561.414     0.150
    53.538   562.555     0.150
    53.868   564.855     0.150
    53.868   564.855     0.150
    54.637   570.504     0.150
    56.421   582.684     0.150
    57.333   590.234     0.150
    57.488   591.605     0.150
    58.436   598.387     0.150
    60.363   610.344     0.150
    60.814   614.207     0.150
    62.581   626.234     0.150
    64.014   636.844     0.150
    67.217   654.895     0.150
    69.149   667.195     0.150
    69.378   669.656     0.150
    74.191   680.535     0.150
    72.160   686.746     0.150
    73.156   693.824     0.150
    73.594   696.375     0.150
    74.007   697.676     0.150
    74.455   700.605     0.150
    74.363   699.656     0.150
    74.363   699.496     0.150
    75.112   704.359     0.150
    75.112   704.395     0.150
    75.112   703.926     0.150
    76.304   709.594     0.150
    76.304   709.555     0.150
    76.189   710.855     0.150
    76.350   712.875     0.150
    55.516   724.012     0.150
   129.396   735.070     0.150
    80.989   735.426     0.150
    81.319   738.047     0.150
    81.446   738.184     0.150
    81.511   740.836     0.150
    55.516   745.242     0.150
    82.728   744.246     0.150
    83.956   751.504     0.150
    87.684   769.797     0.150
    95.639   807.215     0.150
   101.123   831.535     0.150
    74.191   834.141     0.150
    74.191   833.406     0.150
   117.593  1127.418     0.150
    74.191  1131.176     0.150
   122.202  1131.180     0.150
   130.694  1155.176     0.150
   141.421  1169.125     0.150
   146.870  1185.477     0.150
    14.819   210.055     0.150
    14.819   210.055     0.150
    30.048   371.754     0.150
    34.962   415.957     0.150
    34.962   415.957     0.150
    35.495   420.957     0.150
    35.495   420.957     0.150
    37.025   432.754     0.150
    37.025   432.754     0.150
    37.164   434.957     0.150
    37.164   434.957     0.150
    80.439   435.457     0.150
    80.439   435.457     0.150
    37.637   438.656     0.150
    37.637   438.656     0.150
    37.725   438.457     0.150
    37.776   439.855     0.150
    37.924   440.656     0.150
    37.937   440.555     0.150
    38.342   446.055     0.150
    38.520   445.656     0.150
    38.812   448.156     0.150
    38.883   446.984     0.150
    38.883     7.562     0.150
    38.881   449.957     0.150
    39.145   452.055     0.150
    39.320   454.254     0.150
    39.452   454.754     0.150
    39.706   455.555     0.150
    40.298   460.855     0.150
    40.592   462.457     0.150
    40.774   464.055     0.150
    40.976   465.355     0.150
    41.081   466.855     0.150
    41.190   468.254     0.150
    41.279   468.156     0.150
    41.313   468.656     0.150
    41.445   471.055     0.150
    41.715   472.254     0.150
    41.871   473.855     0.150
    41.897   473.355     0.150
    41.960   473.855     0.150
    42.029   474.254     0.150
    42.135   475.055     0.150
    42.235   476.055     0.150
    42.417   477.457     0.150
    42.464   480.754     0.150
    42.471   478.055     0.150
    42.621   479.055     0.150
    42.682   479.855     0.150
    42.833   481.254     0.150
    43.220   483.957     0.150
    43.403   485.754     0.150
    44.378   492.492     0.150
    44.378   495.242     0.150
    44.378   495.254     0.150
    44.378   491.867     0.150
    44.378   492.492     0.150
    44.378   495.242     0.150
    44.378   495.254     0.150
    44.378     8.324     0.150
    45.513   502.016     0.150
    45.513   500.207     0.150
    45.513   502.016     0.150
    46.941   512.297     0.150
    46.941   512.254     0.150
    46.941   512.297     0.150
    49.223   530.457     0.150
    69.378   669.656     0.150
    74.363   699.656     0.150
    76.189   710.855     0.150
     1.300    25.816     0.150
    74.191    98.484     0.150
     8.495   127.984     0.150
    11.018   160.277     0.150
    74.191   233.055     0.150
    74.191   290.074     0.150
    74.191   293.605     0.150
    74.191   315.906     0.150
    29.838   369.496     0.150
    29.808   370.477     0.150
    41.242   465.465     0.150
    44.174   491.004     0.150
    45.607   500.707     0.150
    53.367   560.816     0.150
    60.723   611.984     0.150
    74.191   627.664     0.150
    63.157   629.137     0.150
    69.378   668.625     0.150
    74.191   680.465     0.150
    75.753   706.816     0.150
    80.989   735.145     0.150
    74.191  1130.414     0.150
   134.856  1162.207     0.150
     1.193    25.430     0.150
     3.985    65.117     0.150
    71.312   681.969     0.150
     1.290    24.820     0.150
     5.595    88.656     0.150
    74.180    98.156     0.150
    74.180   179.102     0.150
    74.180   290.133     0.150
    74.180   293.297     0.150
    74.180   315.156     0.150
    34.415   412.172     0.150
    39.083   444.875     0.150
    74.459   702.172     0.150
    75.672   708.062     0.150
     1.310    26.475     0.150
     1.310    48.067     0.150
     1.310    26.580     0.150
     5.896   154.634     0.150
     8.668   131.240     0.150
    74.202   180.010     0.150
    14.794   210.040     0.150
    14.794   210.040     0.150
    14.794   210.040     0.150
    14.794   210.040     0.150
    14.794   210.040     0.150
    14.794   210.040     0.150
    14.794   210.040     0.150
    14.794   210.040     0.150
    14.794   210.380     0.150
    15.302   214.640     0.150
    74.202   272.549     0.150
    21.296   292.340     0.150
    74.202   290.358     0.150
    74.202   316.140     0.150
    29.629   369.680     0.150
    29.724   371.410     0.150
    30.028   371.840     0.150
    30.028   371.840     0.150
    30.028   371.840     0.150
    30.028   371.840     0.150
    30.028   371.840     0.150
    30.028   371.840     0.150
    30.028   371.840     0.150
    30.028   371.853     0.150
    30.571   378.230     0.150
    74.202   406.493     0.150
    34.661   413.120     0.150
    34.954   416.540     0.150
    34.954   416.540     0.150
    34.954   416.540     0.150
    34.954   416.540     0.150
    34.954   416.540     0.150
    34.954   416.540     0.150
    34.954   416.540     0.150
    34.954   416.540     0.150
    35.487   421.440     0.150
    35.487   421.440     0.150
    35.487   421.440     0.150
    35.487   421.440     0.150
    35.487   421.440     0.150
    35.487   421.440     0.150
    35.487   421.440     0.150
    35.487   421.440     0.150
    36.429   428.434     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.017   433.140     0.150
    37.155   435.140     0.150
    37.155   435.140     0.150
    37.155   435.140     0.150
    37.155   435.140     0.150
    37.155   435.140     0.150
    37.155   435.140     0.150
    37.155   435.140     0.150
    37.155   435.140     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    80.412   435.640     0.150
    37.629   438.840     0.150
    37.629   438.840     0.150
    37.629   438.840     0.150
    37.629   438.840     0.150
    37.629   438.840     0.150
    37.629   438.840     0.150
    37.629   438.840     0.150
    37.717   439.140     0.150
    37.717   439.140     0.150
    37.717   439.140     0.150
    37.717   439.140     0.150
    37.717   439.140     0.150
    37.717   439.140     0.150
    37.717   439.140     0.150
    37.717   439.140     0.150
    37.767   439.840     0.150
    37.767   439.840     0.150
    37.767   439.840     0.150
    37.767   439.840     0.150
    37.767   439.840     0.150
    37.767   439.840     0.150
    37.767   439.840     0.150
    37.767   439.840     0.150
    37.913   440.540     0.150
    37.913   440.540     0.150
    37.913   440.540     0.150
    37.913   440.540     0.150
    37.913   440.540     0.150
    37.913   440.540     0.150
    37.913   440.540     0.150
    37.927   440.840     0.150
    37.927   440.840     0.150
    37.927   440.840     0.150
    37.927   440.840     0.150
    37.927   440.840     0.150
    37.927   440.840     0.150
    38.333   445.540     0.150
    38.333   445.540     0.150
    38.333   445.540     0.150
    38.333   445.540     0.150
    38.333   445.540     0.150
    38.333   445.540     0.150
    55.491   445.182     0.150
    38.512   446.040     0.150
    38.512   446.040     0.150
    38.512   446.040     0.150
    38.512   446.040     0.150
    38.512   446.040     0.150
    38.512   446.040     0.150
    38.512   446.040     0.150
    38.802   448.240     0.150
    38.802   448.240     0.150
    38.802   448.240     0.150
    38.802   448.240     0.150
    38.802   448.240     0.150
    38.802   448.240     0.150
    38.873   450.740     0.150
    38.873   450.740     0.150
    38.873   450.740     0.150
    38.873   450.740     0.150
    38.873   450.740     0.150
    39.136   452.440     0.150
    39.136   452.440     0.150
    39.136   452.440     0.150
    39.136   452.440     0.150
    39.136   452.440     0.150
    39.443   455.240     0.150
    39.443   455.240     0.150
    39.443   455.240     0.150
    39.443   455.240     0.150
    39.443   455.240     0.150
    39.696   455.940     0.150
    39.696   455.940     0.150
    39.696   455.940     0.150
    39.696   455.940     0.150
    40.288   461.840     0.150
    40.288   461.840     0.150
    40.288   461.840     0.150
    40.288   461.840     0.150
    40.584   462.940     0.150
    40.584   462.940     0.150
    40.584   462.940     0.150
    40.584   462.940     0.150
    40.764   464.740     0.150
    40.764   464.740     0.150
    40.764   464.740     0.150
    40.967   465.740     0.150
    40.967   465.740     0.150
    40.967   465.740     0.150
    40.967   465.740     0.150
    41.072   467.240     0.150
    41.072   467.240     0.150
    41.072   467.240     0.150
    41.180   469.040     0.150
    41.180   469.040     0.150
    41.180   469.040     0.150
    41.269   468.540     0.150
    41.269   468.540     0.150
    41.269   468.540     0.150
    41.303   469.140     0.150
    41.303   469.140     0.150
    41.303   469.140     0.150
    41.303   469.140     0.150
    41.707   472.840     0.150
    41.707   472.840     0.150
    41.707   472.840     0.150
    41.886   473.740     0.150
    41.886   473.740     0.150
    41.886   473.740     0.150
    41.886   473.825     0.150
    41.950   473.940     0.150
    41.950   473.940     0.150
    41.950   473.940     0.150
    42.019   474.640     0.150
    42.019   474.640     0.150
    42.019   474.640     0.150
    42.125   475.440     0.150
    42.125   475.440     0.150
    42.125   475.440     0.150
    42.226   476.240     0.150
    42.408   477.840     0.150
    42.408   477.840     0.150
    42.408   477.840     0.150
    42.462   478.440     0.150
    42.462   478.440     0.150
    42.610   479.440     0.150
    42.610   479.440     0.150
    42.672   480.640     0.150
    42.672   480.640     0.150
    42.740   479.566     0.150
    42.825   481.440     0.150
    42.825   481.440     0.150
    43.209   484.340     0.150
    43.209   484.340     0.150
    43.394   486.140     0.150
    43.394   486.140     0.150
    44.361   491.690     0.150
    44.361   494.752     0.150
    44.361   498.215     0.150
    97.054   562.010     0.150
    53.523   560.791     0.150
    54.721   574.929     0.150
    60.840   616.890     0.150
    71.895   686.975     0.150
    80.963   734.740     0.150
    81.253   739.940     0.150
    87.967   773.515     0.150
    74.202   835.796     0.150
   117.619  1125.051     0.150
   141.426  1169.410     0.150
    29.844   371.963     0.150
    55.491   558.613     0.150
    55.491   548.035     0.150
     1.310    26.270     0.150
     5.368    86.880     0.150
    17.021   235.750     0.150
    18.353   254.180     0.150
    74.202   271.120     0.150
    74.202   290.700     0.150
    74.202   294.500     0.150
    74.202   315.390     0.150
    30.028   371.330     0.150
    31.180   380.470     0.150
    33.922   405.370     0.150
    46.352   507.120     0.150
    47.535   515.490     0.150
    50.319   538.150     0.150
     1.259    25.690     0.150
    35.348   418.943     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    35.462   421.250     0.150
    36.383   428.210     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.744   439.891     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.906   444.750     0.150
    37.906   444.750     0.150
    37.906   444.750     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.781   448.851     0.150
    38.781   448.851     0.150
    38.781   448.851     0.150
    38.781   448.851     0.150
    39.675   458.050     0.150
    39.675   458.050     0.150
    39.675   458.050     0.150
    40.943   465.851     0.150
    41.249   468.550     0.150
    41.866   473.851     0.150
    42.386   478.450     0.150
    42.590   480.050     0.150
    42.590   480.050     0.150
    42.801   484.950     0.150
    42.801   484.950     0.150
    14.844   210.650     0.150
    14.844   210.650     0.150
    14.844   210.650     0.150
    14.844   210.650     0.150
    14.844   210.650     0.150
    14.844   210.650     0.150
    21.264   292.351     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.692   436.685     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.906   444.750     0.150
    37.906   444.750     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.487   444.808     0.150
    38.781   448.851     0.150
    38.781   448.851     0.150
    39.675   458.050     0.150
    39.675   458.050     0.150
    40.943   465.851     0.150
    40.943   465.851     0.150
    41.160   467.091     0.150
    41.249   468.550     0.150
    41.249   468.550     0.150
    41.249   467.511     0.150
    41.866   473.851     0.150
    41.866   473.851     0.150
    42.386   478.450     0.150
    42.590   480.050     0.150
     1.259    25.690     0.150
     4.165    69.431     0.150
     4.901    81.410     0.150
     5.398    87.130     0.150
     6.813   105.450     0.150
     7.203   110.130     0.150
     7.742   117.460     0.150
     7.783   118.840     0.150
     8.512   128.510     0.150
     9.898   147.130     0.150
    14.844   210.650     0.150
    14.844   210.450     0.150
    14.844   210.840     0.150
    15.336   217.351     0.150
    17.064   241.910     0.150
    21.264   292.311     0.150
    21.725   297.062     0.150
    21.933   298.460     0.150
    22.332   303.101     0.150
    22.954   309.820     0.150
    23.450   313.160     0.150
    26.024   338.570     0.150
    26.147   340.200     0.150
    27.775   354.000     0.150
    28.618   359.230     0.150
    29.656   368.360     0.150
    29.660   368.360     0.150
    30.084   372.510     0.150
    31.173   380.360     0.150
    32.555   394.690     0.150
    34.272   409.181     0.150
    34.150   408.684     0.150
    34.929   416.164     0.150
    34.929   416.271     0.150
    34.985   416.730     0.150
    35.022   415.860     0.150
    35.348   418.943     0.150
    35.390   419.798     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    35.462   421.450     0.150
    35.462   421.294     0.150
    35.462   421.250     0.150
    35.868   423.859     0.150
    36.232   425.730     0.150
    36.383   428.285     0.150
    36.383   428.210     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    37.132   435.550     0.150
    37.132   434.119     0.150
    37.167   434.547     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    80.454   436.650     0.150
    37.471   437.480     0.150
    37.461   437.539     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.604   438.950     0.150
    37.604   438.822     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.744   439.950     0.150
    37.744   439.891     0.150
    37.820   440.156     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.894   440.750     0.150
    37.906   444.750     0.150
    37.906   444.750     0.150
    37.906   444.750     0.150
    37.906   440.851     0.150
    38.146   443.312     0.150
    38.401   445.234     0.150
    38.460   445.662     0.150
    38.470   446.303     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.487   446.450     0.150
    38.522   446.323     0.150
    38.781   448.851     0.150
    38.781   448.851     0.150
    38.781   448.851     0.150
    38.781   448.851     0.150
    38.781   447.950     0.150
    39.675   458.050     0.150
    39.675   458.050     0.150
    39.675   458.050     0.150
    39.675   455.450     0.150
    40.943   465.851     0.150
    40.943   465.851     0.150
    40.943   465.450     0.150
    41.249   468.550     0.150
    41.249   468.550     0.150
    41.249   468.319     0.150
    41.866   473.851     0.150
    41.866   473.851     0.150
    42.386   478.450     0.150
    42.386   478.450     0.150
    42.590   480.050     0.150
    42.590   480.050     0.150
    42.801   484.950     0.150
    42.801   484.950     0.150
     1.259    25.410     0.150
    74.150    99.280     0.150
    74.150   234.790     0.150
    74.150   291.740     0.150
    74.150   314.550     0.150
    30.084   369.070     0.150
    38.553   445.780     0.150
    47.580   517.080     0.150
    65.039   642.340     0.150
     1.327    26.803     0.150
    41.256   468.953     0.150
    42.349   473.902     0.150
    38.858   451.922     0.150
    44.357   491.779     0.150
     1.327    26.883     0.150
     6.763   104.604     0.150
    18.336   256.342     0.150
    74.221   290.562     0.150
     1.277    25.105     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    14.845   210.816     0.150
    74.166   234.414     0.150
    21.287   292.125     0.150
    23.474   313.414     0.150
    74.166   316.117     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.516     0.150
    30.076   372.527     0.150
    31.196   381.156     0.150
    74.166   406.359     0.150
    74.166   406.426     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.414     0.150
    34.953   416.336     0.150
    35.007   415.871     0.150
    35.045   416.324     0.150
    35.052   418.074     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    35.486   421.117     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.016   433.215     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    37.156   435.316     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    80.462   435.715     0.150
    37.494   437.957     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.628   439.715     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.767   440.215     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    37.929   441.414     0.150
    38.425   444.805     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.215     0.150
    38.511   446.168     0.150
    38.805   448.316     0.150
    38.805   448.316     0.150
    38.805   448.316     0.150
    38.805   448.316     0.150
    38.805   448.316     0.150
    38.805   448.316     0.150
    38.805   448.316     0.150
    38.805   448.316     0.150
    38.886   452.914     0.150
    38.886   446.797     0.150
    39.698   456.215     0.150
    39.698   456.215     0.150
    39.698   456.215     0.150
    39.698   456.215     0.150
    39.698   456.215     0.150
    39.698   456.215     0.150
    39.698   456.215     0.150
    40.583   463.016     0.150
    40.583   463.016     0.150
    40.583   463.016     0.150
    40.583   463.016     0.150
    40.583   463.016     0.150
    40.583   463.016     0.150
    40.583   463.016     0.150
    40.583   463.066     0.150
    40.967   465.816     0.150
    40.967   465.816     0.150
    40.967   465.816     0.150
    40.967   465.816     0.150
    40.967   465.816     0.150
    40.967   465.816     0.150
    41.183   469.016     0.150
    41.183   469.016     0.150
    41.183   469.016     0.150
    41.183   469.016     0.150
    41.183   469.016     0.150
    41.183   469.016     0.150
    41.183   469.016     0.150
    41.183   466.918     0.150
    41.273   468.617     0.150
    41.273   468.617     0.150
    41.273   468.617     0.150
    41.273   468.617     0.150
    41.273   468.617     0.150
    41.273   468.617     0.150
    41.304   469.715     0.150
    41.304   469.715     0.150
    41.304   469.715     0.150
    41.304   469.715     0.150
    41.304   469.715     0.150
    41.304   469.715     0.150
    41.705   472.715     0.150
    41.705   472.715     0.150
    41.705   472.715     0.150
    41.705   472.715     0.150
    41.705   472.715     0.150
    41.705   472.715     0.150
    41.890   473.516     0.150
    41.890   473.516     0.150
    41.890   473.516     0.150
    41.890   473.516     0.150
    41.890   473.516     0.150
    41.890   473.516     0.150
    41.890   472.391     0.150
    42.022   474.914     0.150
    42.022   474.914     0.150
    42.022   474.914     0.150
    42.022   474.914     0.150
    42.022   474.914     0.150
    42.022   474.914     0.150
    42.226   476.516     0.150
    42.226   476.516     0.150
    42.226   476.516     0.150
    42.226   476.516     0.150
    42.226   476.516     0.150
    42.410   478.016     0.150
    42.410   478.016     0.150
    42.410   478.016     0.150
    42.410   478.016     0.150
    42.410   478.016     0.150
    42.462   480.117     0.150
    42.462   480.117     0.150
    42.462   480.117     0.150
    42.462   480.117     0.150
    42.462   480.117     0.150
    42.462   480.117     0.150
    42.744   479.488     0.150
    42.760   481.641     0.150
    42.760   479.016     0.150
    42.760   481.641     0.150
    42.824   481.617     0.150
    42.824   481.617     0.150
    42.824   481.617     0.150
    42.824   481.617     0.150
    43.214   484.117     0.150
    43.214   484.117     0.150
    43.214   484.117     0.150
    43.214   484.117     0.150
    43.214   484.117     0.150
    43.394   486.516     0.150
    43.394   486.516     0.150
    43.394   486.516     0.150
    43.394   486.516     0.150
    43.394   486.516     0.150
    44.379   492.516     0.150
    44.379   492.527     0.150
    44.379   498.016     0.150
    44.379   498.129     0.150
    44.379   491.676     0.150
    44.379   492.516     0.150
    44.379   492.527     0.150
    45.514   501.941     0.150
    45.514   500.551     0.150
    45.514   501.941     0.150
    45.711   499.117     0.150
    46.951   512.855     0.150
    46.951   513.105     0.150
    49.235   530.340     0.150
    49.235   531.590     0.150
    53.444   563.789     0.150
    53.444   565.367     0.150
    53.444   566.566     0.150
    53.444   561.141     0.150
    53.444   561.789     0.150
    53.444   563.789     0.150
    53.444   565.367     0.150
    53.444   566.566     0.150
    53.473   563.016     0.150
    60.389   612.617     0.150
    76.161   711.816     0.150
    76.161   711.816     0.150
    76.161   711.816     0.150
     1.277    24.664     0.150
    74.166   170.145     0.150
    74.166    98.074     0.150
     8.518   128.305     0.150
    74.166   180.305     0.150
    14.845   210.977     0.150
    15.834   214.305     0.150
    74.166   232.785     0.150
    74.166   271.688     0.150
    74.166   290.016     0.150
    74.166   293.316     0.150
    21.714   292.156     0.150
    74.166   315.285     0.150
    25.181   327.875     0.150
    26.169   337.527     0.150
    27.797   352.125     0.150
    29.851   369.625     0.150
    38.886   446.387     0.150
    74.014   696.984     0.150
    74.166  1130.984     0.150
    74.166  1149.516     0.150
    74.166  1181.605     0.150
     1.282    25.780     0.150
     6.814   107.370     0.150
     7.202   112.050     0.150
    26.958   334.750     0.150
    35.175   418.261     0.150
    80.450   435.900     0.150
    37.493   439.228     0.150
    37.493   434.980     0.150
    38.801   444.670     0.150
    41.269   468.590     0.150
    41.637   471.170     0.150
    41.765   469.900     0.150
    42.751   480.390     0.150
    43.326   484.730     0.150
    49.225   533.702     0.150
     1.282    25.670     0.150
     1.282    41.950     0.150
     3.927    63.230     0.150
    74.172    99.020     0.150
    74.172   182.170     0.150
    74.172   271.310     0.150
    74.172   290.090     0.150
    74.172   293.430     0.150
    74.172   315.880     0.150
    33.925   404.810     0.150
    39.695   454.860     0.150
    72.768   688.380     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.809    15.117     0.150
     2.627    82.117     0.150
     3.166    55.117     0.150
     4.341    68.117     0.150
     4.341   118.117     0.150
     4.079    66.117     0.150
     4.197    70.117     0.150
     4.197   121.117     0.150
     4.143    68.117     0.150
     5.523    87.117     0.150
     5.523   152.117     0.150
     5.801    89.117     0.150
     5.801   157.117     0.150
     5.751    90.117     0.150
     5.751   181.117     0.150
     5.957    93.117     0.150
     5.957   167.117     0.150
     6.110    95.117     0.150
     6.110   163.117     0.150
     6.568   103.117     0.150
     6.568   176.117     0.150
     6.574   101.117     0.150
     6.574   175.117     0.150
     7.488   112.117     0.150
     7.488   194.117     0.150
     7.503   113.117     0.150
     7.503   199.117     0.150
     7.628   114.117     0.150
     7.628   198.117     0.150
     7.628   130.117     0.150
     8.420   127.117     0.150
     8.420   221.117     0.150
     8.420   149.117     0.150
     8.532   128.117     0.150
     8.532   225.117     0.150
     8.532   146.117     0.150
     9.270   136.117     0.150
     9.547   141.117     0.150
     9.790   139.117     0.150
     9.790   243.117     0.150
     9.560   141.117     0.150
     9.646   143.117     0.150
     9.646   252.117     0.150
     9.870   146.117     0.150
    12.488   178.117     0.150
    16.007   421.117     0.150
    16.007   523.117     0.150
    16.019   224.117     0.150
    16.486   233.117     0.150
    16.486   521.117     0.150
    16.916   435.117     0.150
    17.725   247.117     0.150
    17.725   435.117     0.150
    18.609   484.117     0.150
    20.260   274.117     0.150
    20.164   277.117     0.150
    21.617   293.117     0.150
    21.617   319.117     0.150
    23.322   569.117     0.150
    23.050   307.117     0.150
    23.050   339.117     0.150
    26.697   344.117     0.150
    29.050   654.117     0.150
    29.673   366.117     0.150
    30.930   377.117     0.150
    33.391   400.117     0.150
    37.856   437.117     0.150
    38.892   446.117     0.150
    39.798   453.117     0.150
    41.203   465.117     0.150
    42.352   474.117     0.150
    42.352   571.117     0.150
    43.548   484.117     0.150
    43.548   590.117     0.150
    44.221   490.117     0.150
    44.870   494.117     0.150
    45.129   497.117     0.150
    45.563   500.117     0.150
    45.563   613.117     0.150
    46.853   511.117     0.150
    51.224   546.117     0.150
    53.555   561.117     0.150
    55.383   574.117     0.150
    57.711   592.117     0.150
    66.053   645.117     0.150
    70.305   673.117     0.150
    76.040   706.117     0.150
    89.862   779.117     0.150
    92.615   793.117     0.150
   124.701  1139.117     0.150
   125.338  1141.117     0.150
     1.459    25.844     0.150
     2.914    51.250     0.150
     2.817    52.047     0.150
     2.817    89.047     0.150
     4.285    70.047     0.150
     4.285   121.047     0.150
     6.146    96.047     0.150
     6.146   172.047     0.150
     6.701   103.047     0.150
     8.132   117.047     0.150
     8.132   121.047     0.150
     8.132   207.047     0.150
     8.132   152.047     0.150
     8.132   235.047     0.150
     8.132   261.047     0.150
     8.627   130.047     0.150
     8.627   223.047     0.150
     9.276   137.047     0.150
    10.545   154.047     0.150
    12.400   176.047     0.150
    12.400   316.047     0.150
    16.357   227.047     0.150
    16.281   230.047     0.150
    16.281   421.047     0.150
    17.553   248.047     0.150
    18.577   257.047     0.150
    18.577   450.047     0.150
    19.491   267.047     0.150
    19.966   275.047     0.150
    20.063   275.047     0.150
    20.229   277.047     0.150
    20.229   506.047     0.150
    21.537   292.047     0.150
    21.869   296.047     0.150
    22.150   293.047     0.150
    22.150   547.047     0.150
    23.164   307.047     0.150
    23.164   561.047     0.150
    25.128   327.047     0.150
    29.581   365.047     0.150
    29.744   368.047     0.150
    29.736   368.047     0.150
    30.488   376.047     0.150
    30.488   553.047     0.150
    30.956   378.047     0.150
    33.300   399.445     0.150
    33.300   560.047     0.150
    33.348   400.047     0.150
    33.644   401.047     0.150
    34.389   407.047     0.150
    34.517   409.047     0.150
    34.999   415.047     0.150
    36.168   425.047     0.150
    36.282   424.047     0.150
    37.112   432.047     0.150
    38.156   441.047     0.150
    39.185   448.047     0.150
    39.185    14.000     0.150
    39.185   534.047     0.150
    39.185   549.047     0.150
    39.185   810.047     0.150
    39.217   449.047     0.150
    39.313   449.148     0.150
    39.313   539.047     0.150
    39.489   452.250     0.150
    39.489   545.047     0.150
    39.766   454.047     0.150
    39.766   548.047     0.150
    40.451   458.547     0.150
    41.280   465.750     0.150
    41.280   570.047     0.150
    41.607   468.047     0.150
    41.607   573.047     0.150
    42.130   473.648     0.150
    42.130   577.047     0.150
    42.241   472.945     0.150
    42.379   473.547     0.150
    42.379   862.047     0.150
    42.393   475.445     0.150
    42.393   578.047     0.150
    43.246   482.648     0.150
    43.246   584.047     0.150
    43.314   485.047     0.150
    43.622   484.445     0.150
    43.906   487.945     0.150
    44.061   488.547     0.150
    44.061   587.047     0.150
    44.197   490.047     0.150
    44.602   493.148     0.150
    44.830   494.344     0.150
    45.096   497.547     0.150
    45.096    13.500     0.150
    45.096   597.047     0.150
    45.407   501.047     0.150
    45.512   497.047     0.150
    45.500   500.047     0.150
    45.500    10.000     0.150
    45.500    14.000     0.150
    45.500   607.047     0.150
    45.530   500.547     0.150
    46.275   507.047     0.150
    46.371   507.648     0.150
    47.334   515.047     0.150
    47.334   931.047     0.150
    47.301   516.047     0.150
    47.476   513.047     0.150
    47.476   932.047     0.150
    47.957   520.047     0.150
    47.778   518.547     0.150
    47.881   519.547     0.150
    48.073   521.648     0.150
    48.680   525.547     0.150
    48.706   527.047     0.150
    48.885   527.250     0.150
    49.009   528.047     0.150
    49.158   531.047     0.150
    49.623   532.750     0.150
    50.172   535.844     0.150
    50.302   536.945     0.150
    50.585   539.344     0.150
    50.861   541.648     0.150
    52.381   552.047     0.150
    52.923   557.047     0.150
    53.125   558.344     0.150
    53.510   561.547     0.150
    53.510   628.047     0.150
    53.453   561.047     0.150
    53.458   560.148     0.150
    53.487   560.547     0.150
    53.773   563.047     0.150
    53.997   564.047     0.150
    54.556   571.547     0.150
    54.707   569.945     0.150
    54.707   632.047     0.150
    54.904   571.344     0.150
    55.329   573.750     0.150
    56.070   581.047     0.150
    56.885   583.547     0.150
    57.262   590.047     0.150
    58.067   594.047     0.150
    58.142   594.750     0.150
    58.644   597.047     0.150
    59.565   603.047     0.150
    60.591   612.047     0.150
    60.782   611.047     0.150
    61.381   616.047     0.150
    61.381   660.047     0.150
    62.187   622.547     0.150
    62.507   625.047     0.150
    63.298   630.047     0.150
    63.207   627.047     0.150
    64.514   637.047     0.150
    66.791   652.047     0.150
    67.707   657.047     0.150
    68.639   663.047     0.150
    69.104   666.047     0.150
    70.454   674.047     0.150
    70.852   677.047     0.150
    72.442   687.047     0.150
    73.388   693.750     0.150
    73.677   693.047     0.150
    74.836   700.148     0.150
    75.681   705.047     0.150
    76.165   707.445     0.150
    76.451   711.047     0.150
    76.217   707.047     0.150
    76.220   707.844     0.150
    76.697   710.047     0.150
    77.296   714.844     0.150
    77.662   715.047     0.150
    77.859   716.750     0.150
    78.701   721.047     0.150
    78.789   722.547     0.150
    78.951   723.047     0.150
    80.742   732.047     0.150
    81.198   736.047     0.150
    80.960   733.945     0.150
    83.043   744.047     0.150
    85.938   760.648     0.150
    89.949   780.047     0.150
    92.344   790.047     0.150
    93.201   796.047     0.150
    95.812   806.047     0.150
   139.234  1171.445     0.150
     0.725    13.215     0.150
     0.912    16.914     0.150
     2.790    52.914     0.150
     3.284    58.914     0.150
     3.284   102.914     0.150
     4.179    69.914     0.150
     4.282    70.914     0.150
     4.282    80.914     0.150
     4.282   134.914     0.150
     5.694    87.914     0.150
     5.694   155.914     0.150
     5.831    91.414     0.150
     5.831   117.414     0.150
     5.831   161.414     0.150
     5.831   180.914     0.150
     6.120    95.914     0.150
     6.120   119.914     0.150
     6.120   166.914     0.150
     6.911   105.914     0.150
     6.704   103.914     0.150
     6.704   129.914     0.150
     7.475   111.613     0.150
     7.475   196.613     0.150
     7.802   116.914     0.150
     7.802   210.914     0.150
     8.084   118.414     0.150
     8.084   206.414     0.150
     8.590   129.914     0.150
     9.445   139.914     0.150
     9.720   144.914     0.150
     9.893   146.914     0.150
     9.808   145.914     0.150
    10.140   151.414     0.150
    10.616   152.914     0.150
    10.801   154.914     0.150
    12.468   177.914     0.150
    16.362   234.914     0.150
    17.088   237.914     0.150
    18.555   255.914     0.150
    18.555   451.715     0.150
    20.288   276.914     0.150
    20.298   276.914     0.150
    21.855   294.914     0.150
    21.855   531.914     0.150
    23.279   307.914     0.150
    23.343   310.414     0.150
    25.117   327.914     0.150
    27.434   348.914     0.150
    28.239   356.113     0.150
    35.596   420.914     0.150
    36.782   429.113     0.150
    38.230   442.215     0.150
    39.222   449.314     0.150
    39.393   449.914     0.150
    39.581   452.814     0.150
    39.822   454.914     0.150
    41.303   466.814     0.150
    42.273   474.314     0.150
    42.419   474.814     0.150
    42.411   475.914     0.150
    43.302   484.414     0.150
    43.666   487.113     0.150
    43.646   485.715     0.150
    44.251   490.914     0.150
    44.412   491.414     0.150
    44.851   495.215     0.150
    45.151   497.914     0.150
    47.572   515.914     0.150
    48.113   521.514     0.150
    48.182   522.715     0.150
    48.453   523.914     0.150
    48.588   525.215     0.150
    49.678   534.613     0.150
    50.620   540.414     0.150
    50.643   540.715     0.150
    51.958   551.113     0.150
    52.426   554.113     0.150
    52.661   556.814     0.150
    52.979   557.715     0.150
    53.111   559.613     0.150
    53.182   559.414     0.150
    53.467   561.715     0.150
    53.510   561.715     0.150
    53.505   561.514     0.150
    53.925   564.914     0.150
    55.698   576.914     0.150
    56.397   581.914     0.150
    57.640   591.514     0.150
    58.207   596.514     0.150
    58.666   598.914     0.150
    60.780   612.914     0.150
    61.451   618.914     0.150
    63.406   631.914     0.150
    65.401   642.914     0.150
    67.770   658.914     0.150
    69.100   666.514     0.150
    70.448   674.914     0.150
    72.313   686.113     0.150
    74.605   699.814     0.150
    75.297   703.914     0.150
    75.657   704.914     0.150
    76.184   708.014     0.150
    76.187   708.215     0.150
    76.719   711.914     0.150
    77.342   713.613     0.150
    78.666   721.215     0.150
    80.739   733.414     0.150
    81.123   736.113     0.150
    83.009   746.014     0.150
    83.029   745.914     0.150
    83.680   749.914     0.150
    86.016   761.414     0.150
    90.691   782.914     0.150
    98.908   822.414     0.150
   124.551  1139.215     0.150
   139.161  1168.914     0.150
   146.655  1183.914     0.150
     0.995    18.243     0.150
     1.136    20.143     0.150
     2.590    45.442     0.150
     2.930    53.843     0.150
     2.930    92.843     0.150
     3.241    56.843     0.150
     3.241   104.843     0.150
     4.075    68.143     0.150
     4.075   118.643     0.150
     5.670    89.243     0.150
     5.670   101.843     0.150
     5.670   168.843     0.150
     5.670   187.843     0.150
     6.010   114.843     0.150
     6.246    97.843     0.150
     6.246   122.843     0.150
     6.246   169.543     0.150
     6.684   101.843     0.150
     6.684   129.843     0.150
     7.790   117.942     0.150
     7.790   204.843     0.150
     8.338   123.343     0.150
     8.338   210.843     0.150
     8.766   130.843     0.150
     9.062   135.343     0.150
     9.990   146.843     0.150
    10.041   148.843     0.150
    10.053   148.843     0.150
    10.257   148.843     0.150
    17.273   243.843     0.150
    20.650   279.843     0.150
    21.939   295.343     0.150
    22.040   294.643     0.150
    27.739   350.843     0.150
    28.561   358.843     0.150
    36.148   422.843     0.150
    39.029   447.843     0.150
    42.104   472.743     0.150
    42.211   473.442     0.150
    44.204   490.043     0.150
    56.327   581.643     0.150
    63.101   628.843     0.150
    67.464   656.843     0.150
    69.161   667.043     0.150
    75.763   706.843     0.150
    76.335   708.843     0.150
    76.337   708.843     0.150
     1.774    31.459     0.150
     3.125    55.059     0.150
     3.125    95.059     0.150
     4.055    66.659     0.150
     4.055   114.459     0.150
     5.743   157.759     0.150
     5.860    90.959     0.150
     5.860    91.459     0.150
     6.518   101.959     0.150
     6.518   172.959     0.150
     7.505   113.659     0.150
     7.505   201.759     0.150
     8.122   118.759     0.150
     8.122   206.959     0.150
     8.310   124.959     0.150
     8.310   218.959     0.150
     8.310   125.659     0.150
     9.419   139.959     0.150
     9.419   140.259     0.150
     9.589   139.959     0.150
     9.589   245.959     0.150
     9.512   141.959     0.150
     9.525   141.959     0.150
    10.719   152.959     0.150
    10.719   153.459     0.150
    12.555   178.959     0.150
    12.555   315.459     0.150
    12.555   179.459     0.150
    14.077   198.259     0.150
    14.077   210.259     0.150
    14.077   348.259     0.150
    14.077   362.259     0.150
    15.537   218.459     0.150
    16.548   233.959     0.150
    16.606   231.959     0.150
    16.803   238.659     0.150
    16.803   431.259     0.150
    17.796   249.959     0.150
    17.796   463.959     0.150
    18.689   259.959     0.150
    20.189   275.959     0.150
    20.163   279.959     0.150
    20.385   279.959     0.150
    21.183   285.059     0.150
    21.183   518.959     0.150
    21.582   289.359     0.150
    21.727   297.959     0.150
    21.727   298.359     0.150
    22.018   296.959     0.150
    22.640   304.959     0.150
    23.000   306.959     0.150
    23.119   307.959     0.150
    23.119   556.959     0.150
    25.288   328.959     0.150
    26.579   340.859     0.150
    27.132   345.959     0.150
    27.938   352.959     0.150
    29.216   364.959     0.150
    29.426   365.759     0.150
    33.891   404.059     0.150
    35.773   418.959     0.150
    36.402   426.759     0.150
    36.480   425.959     0.150
    36.480   426.459     0.150
    38.834   446.559     0.150
    39.144   448.959     0.150
    39.144     4.200     0.150
    41.047   463.059     0.150
    41.174   467.759     0.150
    44.347   490.659     0.150
    44.605   493.459     0.150
    45.157   495.959     0.150
    45.677   501.059     0.150
    46.049   504.959     0.150
    46.049   505.159     0.150
    47.150   511.959     0.150
    48.865   530.259     0.150
    53.631   562.959     0.150
    56.231   580.959     0.150
    57.227   588.059     0.150
    60.954   614.959     0.150
    63.708   632.959     0.150
    64.865   639.959     0.150
    68.072   660.959     0.150
    68.861   663.959     0.150
    74.813   700.959     0.150
    75.399   702.959     0.150
    81.089   736.059     0.150
    81.097   735.159     0.150
    82.770   744.459     0.150
    89.798   778.759     0.150
     1.235    22.494     0.150
     3.422    57.395     0.150
     3.422    57.895     0.150
     3.422   105.395     0.150
     3.422   113.395     0.150
     4.267    69.395     0.150
     4.267   121.395     0.150
     5.868   118.994     0.150
     5.868   163.395     0.150
     5.868   174.395     0.150
     6.864   105.895     0.150
     6.864   105.395     0.150
     8.144   118.395     0.150
     8.144   205.094     0.150
     8.131   121.395     0.150
     8.131   121.795     0.150
     8.885   131.395     0.150
     8.885   228.395     0.150
     9.207   137.295     0.150
    10.061   150.395     0.150
    10.145   149.395     0.150
    10.145   262.195     0.150
    10.132   149.695     0.150
    10.132   262.195     0.150
    16.196   231.895     0.150
    17.388   243.395     0.150
    17.388   243.994     0.150
    21.747   294.395     0.150
    22.393   301.395     0.150
    22.694   301.395     0.150
    23.839   315.195     0.150
    24.997   325.395     0.150
    39.228   447.395     0.150
    39.412   449.594     0.150
    39.491   450.395     0.150
    44.353   489.275     0.150
    44.402   490.094     0.150
    44.640   491.805     0.150
    67.416   656.094     0.150
    69.322   663.895     0.150
    81.286   735.895     0.150
     1.033    18.826     0.150
     1.033    35.826     0.150
     2.982    53.826     0.150
     2.982    95.826     0.150
     2.982    54.127     0.150
     3.080    48.525     0.150
     3.327   102.525     0.150
     3.886    64.326     0.150
     4.168    68.127     0.150
     4.168   118.727     0.150
     4.170    68.826     0.150
     4.170   113.826     0.150
     4.281    70.326     0.150
     4.281   124.826     0.150
     4.281    70.326     0.150
     4.281   124.826     0.150
     4.365    70.826     0.150
     4.377    71.627     0.150
     4.377   121.127     0.150
     5.336    81.826     0.150
     5.336   144.826     0.150
     5.770    90.025     0.150
     5.770   159.025     0.150
     6.303    97.525     0.150
     6.303   175.525     0.150
     6.769   103.127     0.150
     7.690   115.326     0.150
     7.690   200.426     0.150
     8.072   119.826     0.150
     8.072   210.826     0.150
     8.072   120.326     0.150
     8.234   119.627     0.150
     8.812   131.326     0.150
     8.812   231.826     0.150
     9.149   134.127     0.150
     9.549   138.826     0.150
     9.808   144.025     0.150
     9.993   147.627     0.150
     9.993   266.627     0.150
    10.009   145.826     0.150
    10.009   146.326     0.150
    10.071   148.127     0.150
    10.071   260.627     0.150
    10.084   148.127     0.150
    10.084   260.627     0.150
    10.535   150.826     0.150
    10.535   151.326     0.150
    11.346   160.727     0.150
    11.346   281.727     0.150
    12.216   173.826     0.150
    14.272   199.326     0.150
    14.272   211.326     0.150
    15.665   226.826     0.150
    15.794   220.525     0.150
    15.794   391.025     0.150
    16.068   226.826     0.150
    16.299   227.826     0.150
    17.207   244.727     0.150
    17.317   240.326     0.150
    17.370   246.826     0.150
    18.137   252.227     0.150
    18.583   254.826     0.150
    18.583   260.326     0.150
    18.583   457.826     0.150
    18.583   483.826     0.150
    18.583   960.127     0.150
    19.278   267.826     0.150
    19.278   471.826     0.150
    19.278   493.826     0.150
    19.251   267.826     0.150
    19.330   266.127     0.150
    19.717   275.826     0.150
    19.717   489.826     0.150
    19.719   272.826     0.150
    19.719   496.826     0.150
    19.756   272.826     0.150
    19.756   494.826     0.150
    19.867   273.426     0.150
    19.867   497.426     0.150
    20.044   273.826     0.150
    20.044   496.127     0.150
    20.357   277.826     0.150
    20.557   279.826     0.150
    20.557   494.826     0.150
    21.052   286.826     0.150
    21.052   511.826     0.150
    21.362   289.826     0.150
    21.362   531.426     0.150
    21.401   289.826     0.150
    21.401   531.426     0.150
    21.685   290.826     0.150
    21.685   529.826     0.150
    21.685   979.826     0.150
    21.727   528.826     0.150
    21.844   292.826     0.150
    21.914   296.826     0.150
    22.087   294.025     0.150
    22.087   536.127     0.150
    22.319   300.826     0.150
    22.308   297.326     0.150
    22.308   543.826     0.150
    22.308   753.326     0.150
    22.750   328.826     0.150
    23.124   306.826     0.150
    23.124   548.826     0.150
    23.124   333.826     0.150
    23.124   599.826     0.150
    23.207   306.826     0.150
    23.207   562.826     0.150
    23.294   306.826     0.150
    23.294   550.525     0.150
    23.294   307.525     0.150
    23.842   316.826     0.150
    23.995   314.926     0.150
    25.094   591.826     0.150
    25.094   649.826     0.150
    25.391   327.826     0.150
    25.391   328.627     0.150
    26.655   338.426     0.150
    27.170   345.826     0.150
    27.170     7.000     0.150
    27.170   625.826     0.150
    27.170   641.826     0.150
    27.170   764.826     0.150
    27.225   344.826     0.150
    27.225   626.326     0.150
    28.143   353.826     0.150
    28.143   636.326     0.150
    28.561   358.127     0.150
    29.415   364.826     0.150
    29.415   650.826     0.150
    29.583   366.826     0.150
    29.577   365.025     0.150
    29.755   366.826     0.150
    29.755   663.826     0.150
    29.755   366.727     0.150
    29.832   367.826     0.150
    29.832   669.826     0.150
    29.832   368.426     0.150
    30.775   377.426     0.150
    30.891   375.826     0.150
    30.891   446.826     0.150
    30.891   551.826     0.150
    31.127   379.025     0.150
    31.127   443.826     0.150
    31.614   384.227     0.150
    31.614   694.326     0.150
    31.683   385.627     0.150
    31.683   697.826     0.150
    32.065   387.826     0.150
    32.065   460.826     0.150
    32.065   697.826     0.150
    32.198   389.326     0.150
    32.228   388.525     0.150
    32.435   391.326     0.150
    32.846   396.326     0.150
    32.846   713.826     0.150
    33.497   400.326     0.150
    33.497     8.500     0.150
    33.497   723.826     0.150
    33.497   847.826     0.150
    33.799   403.826     0.150
    33.799   482.826     0.150
    33.799   729.326     0.150
    33.799   787.326     0.150
    33.799   863.826     0.150
    34.057   406.426     0.150
    34.074   406.727     0.150
    34.061   405.326     0.150
    34.089   405.826     0.150
    34.191   408.127     0.150
    34.229   408.227     0.150
    34.338   408.926     0.150
    34.504   410.326     0.150
    34.616   411.826     0.150
    34.843   412.926     0.150
    34.940   414.826     0.150
    35.311   416.826     0.150
    35.375   417.926     0.150
    35.375   418.326     0.150
    35.600   417.826     0.150
    35.708   420.826     0.150
    35.807   421.826     0.150
    35.819   420.826     0.150
    36.008   422.826     0.150
    36.210   423.127     0.150
    36.210   763.826     0.150
    36.210   501.826     0.150
    36.232   423.826     0.150
    36.232   757.826     0.150
    36.232   565.826     0.150
    36.416   426.326     0.150
    36.416   511.826     0.150
    36.416   567.826     0.150
    36.416   774.826     0.150
    36.416   795.826     0.150
    36.416  1041.826     0.150
    36.963   430.826     0.150
    36.963   523.826     0.150
    36.963   773.826     0.150
    36.983   430.826     0.150
    36.983   518.826     0.150
    37.079   430.525     0.150
    37.375   434.826     0.150
    37.518   435.826     0.150
    37.518   436.826     0.150
    37.546   435.826     0.150
    37.546   525.826     0.150
    37.546   783.826     0.150
    37.604   435.826     0.150
    37.754   438.025     0.150
    37.754   573.627     0.150
    37.754   790.826     0.150
    37.977   438.826     0.150
    38.346   441.926     0.150
    38.692   447.926     0.150
    38.755   445.326     0.150
    38.755   541.826     0.150
    38.755   809.826     0.150
    38.919   446.326     0.150
    38.919   804.826     0.150
    38.988   447.727     0.150
    38.988   541.826     0.150
    39.132   447.826     0.150
    39.132   803.826     0.150
    39.175   449.326     0.150
    39.175     1.500     0.150
    39.175     6.500     0.150
    39.175   540.826     0.150
    39.224   448.826     0.150
    39.224   545.826     0.150
    39.252   450.227     0.150
    39.252   577.627     0.150
    39.315   449.326     0.150
    39.341   448.926     0.150
    39.341   811.826     0.150
    39.356   451.025     0.150
    39.356     8.801     0.150
    39.395   451.826     0.150
    39.453   450.926     0.150
    39.637   452.525     0.150
    39.637   809.826     0.150
    39.637     8.500     0.150
    40.183   457.826     0.150
    40.183   554.326     0.150
    40.183   580.826     0.150
    40.183   821.826     0.150
    40.183   997.826     0.150
    40.184   458.627     0.150
    40.184     6.199     0.150
    40.184    11.199     0.150
    40.184   580.826     0.150
    40.475   458.826     0.150
    40.659   463.227     0.150
    41.225   465.326     0.150
    41.331   464.727     0.150
    41.331   835.826     0.150
    41.276   465.127     0.150
    41.960   472.826     0.150
    41.960   577.826     0.150
    41.989   472.627     0.150
    41.989   586.826     0.150
    41.997   472.826     0.150
    41.997   566.326     0.150
    42.206   473.025     0.150
    42.206    12.900     0.150
    42.315   473.525     0.150
    42.315   577.926     0.150
    42.370   476.326     0.150
    42.370   577.826     0.150
    42.370   857.826     0.150
    42.403   473.826     0.150
    42.403   867.826     0.150
    42.507   476.326     0.150
    42.507   861.326     0.150
    42.762   478.326     0.150
    42.866   479.025     0.150
    43.116   482.227     0.150
    43.116   582.326     0.150
    43.116  1063.826     0.150
    43.184   484.826     0.150
    43.342   483.627     0.150
    43.342   591.627     0.150
    43.342   871.826     0.150
    43.383   483.727     0.150
    43.486   484.525     0.150
    43.486   885.826     0.150
    43.530   484.826     0.150
    43.771   486.826     0.150
    43.771   589.727     0.150
    43.905   487.826     0.150
    43.905   590.426     0.150
    43.905   881.826     0.150
    43.905  1107.826     0.150
    43.967   488.326     0.150
    44.063   489.627     0.150
    44.063   592.627     0.150
    44.075   488.926     0.150
    44.075   593.826     0.150
    44.075   593.627     0.150
    44.229   490.326     0.150
    44.258   489.307     0.150
    44.307   490.025     0.150
    44.325   491.326     0.150
    44.383   490.826     0.150
    44.570   494.326     0.150
    44.545   491.807     0.150
    44.623   494.326     0.150
    44.728   494.127     0.150
    44.818   495.326     0.150
    44.831   493.826     0.150
    44.970   496.326     0.150
    44.970   596.826     0.150
    45.146   497.826     0.150
    45.234   498.326     0.150
    45.276   499.727     0.150
    45.277   499.826     0.150
    45.334   499.326     0.150
    45.334   596.826     0.150
    45.360   499.525     0.150
    45.570   500.227     0.150
    45.664   501.426     0.150
    45.708   502.525     0.150
    45.708   612.826     0.150
    45.708   903.826     0.150
    45.743   500.326     0.150
    45.743   902.826     0.150
    45.743   609.826     0.150
    45.940   504.826     0.150
    46.037   505.627     0.150
    46.037   920.826     0.150
    46.171   506.326     0.150
    46.301   505.727     0.150
    47.019   512.627     0.150
    47.019   604.025     0.150
    47.040   511.826     0.150
    47.240   513.426     0.150
    47.264   513.326     0.150
    47.274   515.525     0.150
    47.325   514.525     0.150
    47.349   514.326     0.150
    47.370   514.326     0.150
    47.606   517.826     0.150
    47.606   627.826     0.150
    47.606  1108.826     0.150
    47.656   521.826     0.150
    47.668   515.326     0.150
    47.668     7.500     0.150
    47.668    12.500     0.150
    47.668   929.826     0.150
    47.668   606.826     0.150
    47.668   625.826     0.150
    47.732   518.326     0.150
    47.874   518.227     0.150
    47.879   518.826     0.150
    47.893   519.627     0.150
    47.932   517.826     0.150
    47.964   519.025     0.150
    47.987   519.525     0.150
    48.189   521.826     0.150
    48.251   522.025     0.150
    48.390   522.826     0.150
    48.535   525.426     0.150
    48.568   524.326     0.150
    48.568   609.826     0.150
    48.659   525.127     0.150
    49.263   529.426     0.150
    49.410   530.227     0.150
    49.490   531.025     0.150
    49.496   531.826     0.150
    49.496   613.727     0.150
    49.549   532.525     0.150
    49.863   534.025     0.150
    50.353   537.426     0.150
    50.375   538.326     0.150
    50.418   538.227     0.150
    50.445   538.525     0.150
    50.443   538.227     0.150
    50.576   539.826     0.150
    50.719   540.426     0.150
    50.817   542.826     0.150
    50.876   541.826     0.150
    51.328   545.326     0.150
    51.515   547.127     0.150
    51.753   548.826     0.150
    52.164   552.326     0.150
    52.222   551.926     0.150
    52.451   554.525     0.150
    52.829   557.025     0.150
    52.995   557.326     0.150
    53.073   558.926     0.150
    53.266   559.426     0.150
    53.321   559.826     0.150
    53.344   559.426     0.150
    53.364   559.727     0.150
    53.522   561.627     0.150
    53.856   563.326     0.150
    54.046   565.127     0.150
    54.046  1018.826     0.150
    54.234   568.326     0.150
    54.263   567.826     0.150
    54.263  1027.826     0.150
    54.353   567.227     0.150
    54.387   567.826     0.150
    54.486   568.426     0.150
    54.656   570.826     0.150
    54.980   571.525     0.150
    55.178   573.426     0.150
    55.220   573.525     0.150
    55.573   575.525     0.150
    55.715   576.426     0.150
    55.787   575.926     0.150
    55.991   577.826     0.150
    55.991  1045.826     0.150
    55.991   578.025     0.150
    56.129   578.127     0.150
    56.215   579.727     0.150
    56.215   711.926     0.150
    56.419   581.025     0.150
    57.476   590.826     0.150
    57.476  1071.826     0.150
    57.663   591.826     0.150
    57.974   593.326     0.150
    58.461   596.727     0.150
    58.606   598.025     0.150
    60.861   612.326     0.150
    61.190   615.826     0.150
    62.080   621.826     0.150
    62.182   617.826     0.150
    62.182   759.826     0.150
    62.528   623.525     0.150
    63.094   627.826     0.150
    64.247   634.826     0.150
    65.639   643.426     0.150
    65.639    13.000     0.150
    67.457   655.826     0.150
    67.457  1192.826     0.150
    69.233   665.727     0.150
    69.634   671.826     0.150
    69.634  1218.826     0.150
    72.135   684.525     0.150
    72.349   686.627     0.150
    72.623   686.826     0.150
    72.623   686.227     0.150
    72.964   689.727     0.150
    74.039   695.025     0.150
    74.267   696.627     0.150
    74.366   697.826     0.150
    74.627   699.627     0.150
    74.770   699.826     0.150
    74.866   701.326     0.150
    75.929   706.525     0.150
    76.018   707.826     0.150
    76.389   708.826     0.150
    76.389   708.826     0.150
    76.733   710.326     0.150
    77.320   715.826     0.150
    78.882   721.926     0.150
    78.967   722.826     0.150
    80.245   729.826     0.150
    80.452   732.127     0.150
    80.848   732.826     0.150
    81.153   735.025     0.150
    81.357   737.227     0.150
    81.365   736.627     0.150
    81.365     4.199     0.150
    81.365  1349.826     0.150
    82.286   741.426     0.150
    82.765   745.326     0.150
    82.935   746.326     0.150
    82.963   745.326     0.150
    83.142   746.227     0.150
    83.156   747.326     0.150
    83.161   745.426     0.150
    83.524   747.826     0.150
    83.658   748.127     0.150
    85.578   758.025     0.150
    86.088   760.426     0.150
    90.134   779.826     0.150
    90.134  1415.826     0.150
    90.138   780.127     0.150
    90.785   782.826     0.150
    92.462   791.127     0.150
    93.759   797.426     0.150
    95.347   803.826     0.150
    95.949   806.826     0.150
    97.211   811.826     0.150
   110.744   876.127     0.150
   114.609  1119.826     0.150
   116.710  1124.826     0.150
   124.433  1137.826     0.150
   124.870  1139.727     0.150
   128.646  1149.326     0.150
   128.661  1148.826     0.150
   138.873  1169.326     0.150
   141.688  1169.926     0.150
   141.688  1176.926     0.150
   145.886  1179.826     0.150
   146.422  1181.127     0.150
   147.157  1182.326     0.150
   147.589  1186.127     0.150
   147.758  1184.627     0.150
   147.837  1186.025     0.150
   147.920  1185.926     0.150
   148.018  1186.127     0.150
   148.093  1184.826     0.150
   148.189  1184.826     0.150
     1.456    26.703     0.150
     1.830    34.105     0.150
     2.121    37.406     0.150
     2.334    40.203     0.150
     2.993    52.504     0.150
     2.993    94.504     0.150
     3.278    52.406     0.150
     3.235    56.805     0.150
     3.317    55.805     0.150
     3.317    56.105     0.150
     3.873    63.004     0.150
     3.873   115.805     0.150
     4.030    65.105     0.150
     4.030   118.305     0.150
     4.130    67.305     0.150
     4.152    66.805     0.150
     4.152    66.906     0.150
     4.259    69.805     0.150
     4.259   125.805     0.150
     4.348    68.805     0.150
     4.348    69.406     0.150
     4.373    69.805     0.150
     4.373    70.203     0.150
     5.311    81.805     0.150
     5.311   139.805     0.150
     5.746   158.406     0.150
     6.312    96.805     0.150
     6.594   102.805     0.150
     6.594   175.805     0.150
     6.760   102.805     0.150
     6.760   103.605     0.150
     7.126   139.805     0.150
     7.732   114.406     0.150
     7.732   199.605     0.150
     8.095   119.805     0.150
     8.095   208.805     0.150
     8.095   120.203     0.150
     8.270   121.805     0.150
     8.270   206.805     0.150
     8.270   253.805     0.150
     8.827   131.805     0.150
     8.827   229.805     0.150
     9.102   132.805     0.150
     9.102   234.805     0.150
     9.760   142.805     0.150
    10.014   147.805     0.150
    10.014   265.805     0.150
    10.035   147.805     0.150
    10.035   258.805     0.150
    10.093   147.805     0.150
    10.093   257.805     0.150
    10.093   148.305     0.150
    10.306   147.805     0.150
    10.306   263.805     0.150
    10.306   270.805     0.150
    10.306   148.305     0.150
    10.490   149.805     0.150
    10.490   273.805     0.150
    10.490   150.105     0.150
    11.345   160.703     0.150
    14.312   201.004     0.150
    14.312   212.203     0.150
    14.312   361.504     0.150
    14.312   378.504     0.150
    14.371   200.605     0.150
    14.405   200.703     0.150
    14.618   203.605     0.150
    15.617   227.805     0.150
    15.965   225.805     0.150
    16.202   228.805     0.150
    16.200   230.805     0.150
    16.311   228.203     0.150
    17.333   240.805     0.150
    17.333   432.504     0.150
    17.326   247.805     0.150
    17.564   242.805     0.150
    17.564   258.805     0.150
    17.564   433.805     0.150
    17.564   454.805     0.150
    18.185   252.504     0.150
    18.185   443.305     0.150
    18.605   253.805     0.150
    18.605   255.805     0.150
    18.605   452.805     0.150
    18.605   485.805     0.150
    19.203   268.305     0.150
    19.351   265.406     0.150
    19.351   484.703     0.150
    19.676   272.004     0.150
    19.676   500.004     0.150
    19.709   273.906     0.150
    19.821   272.805     0.150
    19.821   274.805     0.150
    19.821   287.004     0.150
    19.999   272.805     0.150
    19.999   492.805     0.150
    20.603   279.203     0.150
    20.603   497.203     0.150
    21.010   285.305     0.150
    21.010   513.805     0.150
    21.318   287.805     0.150
    21.324   288.805     0.150
    21.324   525.805     0.150
    21.357   287.805     0.150
    21.357   537.805     0.150
    21.637   292.805     0.150
    21.637   536.805     0.150
    21.746   289.004     0.150
    21.862   292.406     0.150
    21.869   296.805     0.150
    22.101   295.504     0.150
    22.326   297.805     0.150
    22.326   537.305     0.150
    22.326   575.305     0.150
    22.326   746.305     0.150
    22.326   971.305     0.150
    23.082   305.305     0.150
    23.082   557.805     0.150
    23.082   335.805     0.150
    23.193   305.805     0.150
    23.193   557.805     0.150
    23.193   306.004     0.150
    23.193   336.906     0.150
    23.277   307.805     0.150
    23.277   561.305     0.150
    23.277   335.805     0.150
    23.887   314.805     0.150
    25.110   325.805     0.150
    25.110   593.805     0.150
    25.110   655.805     0.150
    25.110   755.805     0.150
    25.348   329.805     0.150
    25.348   587.805     0.150
    25.348   371.805     0.150
    27.216   345.305     0.150
    27.216     4.500     0.150
    27.216   388.805     0.150
    27.216   620.805     0.150
    27.216   646.805     0.150
    27.183   344.805     0.150
    27.777   349.805     0.150
    27.777     1.398     0.150
    27.777   350.004     0.150
    27.777     1.199     0.150
    27.785   351.703     0.150
    28.191   353.406     0.150
    28.594   356.805     0.150
    28.594   652.305     0.150
    29.463   363.805     0.150
    29.463   651.805     0.150
    29.535   366.805     0.150
    29.535   366.805     0.150
    29.535   665.805     0.150
    29.555   367.805     0.150
    29.800   367.805     0.150
    29.800   367.805     0.150
    29.864   368.805     0.150
    29.864   665.805     0.150
    29.864   425.805     0.150
    29.864   549.203     0.150
    29.864   753.805     0.150
    30.819   375.805     0.150
    30.860   375.805     0.150
    30.860   682.805     0.150
    31.095   378.305     0.150
    31.095   685.805     0.150
    31.095   553.805     0.150
    31.095   792.805     0.150
    31.276   381.305     0.150
    31.661   383.805     0.150
    31.661   553.305     0.150
    31.661   690.805     0.150
    31.727   385.105     0.150
    32.113   387.004     0.150
    32.138   388.703     0.150
    32.152   388.406     0.150
    32.181   386.203     0.150
    32.389   391.305     0.150
    32.656   394.703     0.150
    32.616   391.906     0.150
    32.818   393.805     0.150
    32.889   397.605     0.150
    33.262   397.805     0.150
    33.262   721.805     0.150
    33.456   400.305     0.150
    33.456   724.305     0.150
    33.456   474.805     0.150
    33.495   399.305     0.150
    33.645   403.406     0.150
    33.844   403.305     0.150
    33.813   403.805     0.150
    33.813   558.805     0.150
    34.015   404.406     0.150
    34.048   404.805     0.150
    34.203   405.805     0.150
    34.203   407.805     0.150
    34.448   408.406     0.150
    34.330   410.805     0.150
    34.427   408.906     0.150
    34.473   408.805     0.150
    34.473   865.805     0.150
    34.567   411.305     0.150
    34.673   408.906     0.150
    34.719   405.805     0.150
    34.801   412.805     0.150
    34.867   413.805     0.150
    34.898   413.805     0.150
    34.993   413.805     0.150
    35.186   414.805     0.150
    35.200   416.805     0.150
    35.200   417.805     0.150
    35.236   414.805     0.150
    35.249   415.805     0.150
    35.249   753.805     0.150
    35.249   897.805     0.150
    35.333   416.805     0.150
    35.339   416.305     0.150
    35.566   417.805     0.150
    35.566   491.805     0.150
    35.566   749.805     0.150
    35.663   419.805     0.150
    35.763   420.805     0.150
    35.774   420.805     0.150
    35.965   424.305     0.150
    35.965   511.805     0.150
    35.965   424.805     0.150
    36.216   421.805     0.150
    36.216   760.805     0.150
    36.216   512.805     0.150
    36.203   422.805     0.150
    36.203   761.805     0.150
    36.460   425.805     0.150
    36.457   425.805     0.150
    36.512   426.305     0.150
    36.517   426.805     0.150
    36.992   427.305     0.150
    37.011   430.406     0.150
    36.944   429.805     0.150
    36.944   775.805     0.150
    36.944   521.805     0.150
    36.944   933.805     0.150
    37.106   428.805     0.150
    37.106   429.605     0.150
    37.185   431.406     0.150
    37.248   431.305     0.150
    37.331   433.805     0.150
    37.344   434.336     0.150
    37.476   517.805     0.150
    37.476   779.805     0.150
    37.476   435.805     0.150
    37.484   434.535     0.150
    37.500   435.805     0.150
    37.500   523.805     0.150
    37.588   434.805     0.150
    37.671   435.977     0.150
    37.709   438.203     0.150
    37.800   782.805     0.150
    37.740   437.535     0.150
    37.751   437.375     0.150
    37.932   437.504     0.150
    37.978   439.805     0.150
    37.978   791.805     0.150
    37.978   525.805     0.150
    37.978   949.805     0.150
    38.174   440.754     0.150
    38.358   442.805     0.150
    38.437   442.574     0.150
    38.652   445.805     0.150
    38.711   445.605     0.150
    38.711   540.605     0.150
    38.711   806.105     0.150
    38.711   822.605     0.150
    38.959   445.805     0.150
    39.036   447.805     0.150
    39.036   806.805     0.150
    39.103   446.703     0.150
    39.103   533.805     0.150
    39.111   449.805     0.150
    39.111   539.805     0.150
    39.111   811.805     0.150
    39.111   968.805     0.150
    39.135   447.805     0.150
    39.135     5.000     0.150
    39.135   542.805     0.150
    39.204   449.004     0.150
    39.204   805.805     0.150
    39.209   449.004     0.150
    39.209   544.805     0.150
    39.209   811.203     0.150
    39.284   448.906     0.150
    39.284   545.703     0.150
    39.284   807.605     0.150
    39.289   447.805     0.150
    39.317   448.305     0.150
    39.317   533.805     0.150
    39.317   813.805     0.150
    39.316   450.305     0.150
    39.355   450.805     0.150
    39.554   451.805     0.150
    39.554   578.805     0.150
    39.598   452.105     0.150
    39.598   544.805     0.150
    39.598   812.805     0.150
    39.598     4.301     0.150
    39.894   451.305     0.150
    40.229   457.805     0.150
    40.229   810.305     0.150
    40.144   456.805     0.150
    40.144   555.805     0.150
    40.144   815.805     0.150
    40.144     2.000     0.150
    40.278   456.805     0.150
    40.278   554.805     0.150
    40.278  1048.805     0.150
    40.511   460.906     0.150
    40.618   463.004     0.150
    40.618   562.805     0.150
    40.618   834.805     0.150
    40.618  1014.805     0.150
    40.799   463.004     0.150
    40.723   462.805     0.150
    40.723   817.805     0.150
    41.263   465.004     0.150
    41.263     5.801     0.150
    41.367   464.805     0.150
    41.367   835.805     0.150
    41.254   464.406     0.150
    41.416   466.305     0.150
    41.426   467.805     0.150
    41.426   566.605     0.150
    41.676   469.805     0.150
    41.802   469.805     0.150
    41.948   472.305     0.150
    41.948   473.805     0.150
    41.948   590.305     0.150
    41.948  1051.504     0.150
    41.958   575.004     0.150
    42.011   472.305     0.150
    42.179   470.906     0.150
    42.179   472.105     0.150
    42.217   473.805     0.150
    42.284   472.203     0.150
    42.284   473.203     0.150
    42.284   575.805     0.150
    42.284   851.805     0.150
    42.417   475.805     0.150
    42.417   581.805     0.150
    42.417   858.805     0.150
    42.417  1065.805     0.150
    42.384   474.305     0.150
    42.384   585.805     0.150
    42.384   474.477     0.150
    42.555   864.805     0.150
    42.717   478.805     0.150
    42.906   480.105     0.150
    42.906   589.805     0.150
    42.906   815.805     0.150
    42.906  1063.805     0.150
    43.077   481.105     0.150
    43.077   584.805     0.150
    43.077   869.805     0.150
    43.077  1073.805     0.150
    43.095   482.305     0.150
    43.117   482.805     0.150
    43.149   483.004     0.150
    43.145   482.805     0.150
    43.145   585.805     0.150
    43.145  1073.805     0.150
    43.300   589.805     0.150
    43.300   821.805     0.150
    43.399   485.203     0.150
    43.420   483.605     0.150
    43.420   592.805     0.150
    43.448   482.805     0.150
    43.448   484.605     0.150
    43.448   825.406     0.150
    43.448   875.805     0.150
    43.448     1.801     0.150
    43.485   484.305     0.150
    43.731   485.305     0.150
    43.731   589.805     0.150
    43.731  1078.805     0.150
    43.731   485.406     0.150
    43.864   487.805     0.150
    43.910   489.805     0.150
    43.923   489.605     0.150
    43.926   487.805     0.150
    43.926   594.805     0.150
    44.022   488.805     0.150
    44.022   591.406     0.150
    44.029   489.105     0.150
    44.036   489.004     0.150
    44.036   595.805     0.150
    44.036  1086.805     0.150
    44.277   488.605     0.150
    44.385   489.605     0.150
    44.473   492.605     0.150
    44.473   828.805     0.150
    44.473   891.805     0.150
    44.473  1079.805     0.150
    44.608   493.305     0.150
    44.509   492.805     0.150
    44.579   493.805     0.150
    44.764   492.805     0.150
    44.868   900.805     0.150
    44.779   495.504     0.150
    44.921   496.305     0.150
    44.931   496.305     0.150
    44.931   596.805     0.150
    44.931   888.805     0.150
    44.931  1078.805     0.150
    44.995   496.305     0.150
    45.010   497.805     0.150
    45.103   497.805     0.150
    45.189   497.805     0.150
    45.237   498.504     0.150
    45.292   497.805     0.150
    45.320   499.605     0.150
    45.424   501.305     0.150
    45.439   503.305     0.150
    45.618   498.406     0.150
    45.623   500.305     0.150
    45.748   502.305     0.150
    45.748   611.805     0.150
    45.748   833.805     0.150
    45.748   906.805     0.150
    45.768   498.906     0.150
    45.768     5.500     0.150
    45.768   903.406     0.150
    45.768  1093.406     0.150
    45.897   505.805     0.150
    45.897   911.805     0.150
    46.087   508.805     0.150
    46.129   505.805     0.150
    46.211   504.805     0.150
    46.247   505.406     0.150
    46.270   504.105     0.150
    46.270   504.555     0.150
    46.318   506.805     0.150
    46.329   508.105     0.150
    46.329   614.805     0.150
    46.365   505.805     0.150
    46.365   911.805     0.150
    46.365   598.805     0.150
    46.365   617.805     0.150
    46.717   508.703     0.150
    46.748   510.004     0.150
    46.981   512.703     0.150
    46.981   604.805     0.150
    46.999   511.004     0.150
    47.199   512.305     0.150
    47.224   512.504     0.150
    47.232   516.305     0.150
    47.330   514.105     0.150
    47.647   517.805     0.150
    47.647   934.805     0.150
    47.647   606.805     0.150
    47.647  1110.805     0.150
    47.601   518.805     0.150
    47.601   628.805     0.150
    47.648   516.805     0.150
    47.683   514.805     0.150
    47.683   928.805     0.150
    47.683   607.805     0.150
    47.683  1111.805     0.150
    47.683  1137.805     0.150
    47.720   519.504     0.150
    47.832   518.305     0.150
    47.836   516.805     0.150
    47.856   518.805     0.150
    47.878   520.305     0.150
    47.878   630.805     0.150
    47.891   517.805     0.150
    47.947   518.703     0.150
    47.969   520.703     0.150
    48.051   519.805     0.150
    48.051   628.805     0.150
    48.051   935.805     0.150
    48.051  1138.805     0.150
    48.237   521.805     0.150
    48.209   520.406     0.150
    48.214   521.004     0.150
    48.299   522.004     0.150
    48.349   521.203     0.150
    48.448   522.703     0.150
    48.493   524.805     0.150
    48.530   524.805     0.150
    48.530   611.805     0.150
    48.538   522.805     0.150
    48.619   523.203     0.150
    48.850   525.805     0.150
    49.221   527.305     0.150
    49.367   529.305     0.150
    49.447   529.305     0.150
    49.457   530.906     0.150
    49.457   961.805     0.150
    49.457  1182.805     0.150
    49.511   531.703     0.150
    49.820   533.906     0.150
    50.340   537.305     0.150
    50.377   536.305     0.150
    50.403   536.504     0.150
    50.490   539.105     0.150
    50.535   537.906     0.150
    50.679   538.703     0.150
    50.862   543.703     0.150
    50.835   540.004     0.150
    50.922   541.406     0.150
    51.287   545.305     0.150
    51.475   545.305     0.150
    51.712   547.105     0.150
    52.115   550.805     0.150
    52.123   550.305     0.150
    52.181   550.105     0.150
    52.409   552.406     0.150
    52.633   555.805     0.150
    52.759   554.105     0.150
    52.788   554.805     0.150
    52.956   555.406     0.150
    53.031   556.703     0.150
    53.226   557.703     0.150
    53.282   557.805     0.150
    53.330   558.305     0.150
    53.482   559.305     0.150
    53.814   562.105     0.150
    54.090   563.605     0.150
    54.090  1023.805     0.150
    54.300   566.805     0.150
    54.300     2.500     0.150
    54.300  1028.805     0.150
    54.300   689.805     0.150
    54.343   566.305     0.150
    54.613   569.406     0.150
    55.221   572.703     0.150
    55.264   573.805     0.150
    55.538   575.504     0.150
    55.680   576.504     0.150
    55.752   577.105     0.150
    56.001   579.805     0.150
    56.034   579.906     0.150
    56.018   576.805     0.150
    56.018     6.000     0.150
    56.018  1043.805     0.150
    56.018   577.105     0.150
    56.018     5.699     0.150
    56.018   634.805     0.150
    56.018   700.805     0.150
    56.018  1271.805     0.150
    55.984   578.805     0.150
    55.984   580.305     0.150
    55.984   705.805     0.150
    56.094   579.703     0.150
    56.239   578.805     0.150
    56.239     2.699     0.150
    56.239  1049.906     0.150
    56.239   578.906     0.150
    56.239     2.598     0.150
    56.239   635.906     0.150
    56.404  1044.805     0.150
    56.568   580.805     0.150
    56.578   580.898     0.150
    57.276   587.805     0.150
    57.460   588.805     0.150
    57.523   590.805     0.150
    57.523  1075.805     0.150
    57.637   591.805     0.150
    57.840   594.004     0.150
    57.931   593.305     0.150
    57.931   723.805     0.150
    57.931  1081.805     0.150
    57.931   592.719     0.150
    58.198   597.805     0.150
    58.435   596.203     0.150
    58.435   597.906     0.150
    58.435   728.406     0.150
    58.562   598.703     0.150
    58.594   598.805     0.150
    59.341   603.105     0.150
    60.247   608.805     0.150
    60.393   610.805     0.150
    60.435   610.906     0.150
    60.521   611.805     0.150
    60.720   611.805     0.150
    61.586   615.805     0.150
    61.586   616.504     0.150
    61.586   753.805     0.150
    61.586  1129.406     0.150
    61.586  1204.805     0.150
    61.586  1360.406     0.150
    61.997   622.004     0.150
    62.037   622.805     0.150
    62.213   617.805     0.150
    62.213  1125.805     0.150
    62.213   661.805     0.150
    62.213   764.805     0.150
    63.063   625.805     0.150
    64.215   633.805     0.150
    65.656   642.805     0.150
    65.656     2.000     0.150
    65.656     5.000     0.150
    65.656  1169.805     0.150
    65.656   673.805     0.150
    66.237   647.605     0.150
    67.426   654.805     0.150
    67.426  1195.805     0.150
    69.235   665.203     0.150
    69.233   665.805     0.150
    69.681   671.105     0.150
    69.681  1219.805     0.150
    69.745   670.105     0.150
    71.158   678.805     0.150
    72.106   684.406     0.150
    72.595   687.703     0.150
    72.660   687.805     0.150
    74.051   693.504     0.150
    74.219   695.105     0.150
    74.544   698.305     0.150
    74.669   699.805     0.150
    75.831   703.805     0.150
    75.919   706.805     0.150
    76.053   706.703     0.150
    76.399   707.703     0.150
    76.399   707.305     0.150
    77.367   714.805     0.150
    78.169   717.805     0.150
    78.889   721.305     0.150
    79.149   725.805     0.150
    79.499   725.805     0.150
    80.276   729.805     0.150
    80.490   731.805     0.150
    80.882   733.805     0.150
    81.168   732.305     0.150
    81.334   738.605     0.150
    81.399   735.406     0.150
    81.408   735.504     0.150
    81.408  1345.805     0.150
    82.296   740.004     0.150
    82.813   742.805     0.150
    83.141   744.504     0.150
    83.155   744.203     0.150
    83.161   743.805     0.150
    83.565   746.805     0.150
    83.565  1366.805     0.150
    83.637   748.305     0.150
    84.545   752.805     0.150
    85.568   758.805     0.150
    85.622   756.805     0.150
    86.079   759.605     0.150
    86.112   760.305     0.150
    90.179   779.805     0.150
    90.179  1001.805     0.150
    90.179  1407.805     0.150
    92.462   789.305     0.150
    93.748   795.004     0.150
    93.873   800.805     0.150
    94.050   797.805     0.150
    94.123   799.203     0.150
    94.666   801.805     0.150
    95.019   802.605     0.150
    95.369   803.805     0.150
    95.952   806.805     0.150
    96.181   808.805     0.150
    97.213   810.805     0.150
    97.213  1043.805     0.150
    99.890   825.605     0.150
   102.978   839.004     0.150
   104.583  1106.305     0.150
   106.881  1122.805     0.150
   107.099  1102.305     0.150
   109.588  1133.805     0.150
   110.621  1155.805     0.150
   110.739   872.305     0.150
   111.056  1143.805     0.150
   114.599  1118.805     0.150
   120.200  1128.805     0.150
   120.560  1132.805     0.150
   121.334  1132.805     0.150
   121.597  1131.805     0.150
   122.158  1134.305     0.150
   122.267  1134.805     0.150
   124.435  1137.703     0.150
   125.594  1142.305     0.150
   126.432  1143.805     0.150
   128.609  1273.305     0.150
   133.294  1156.305     0.150
   134.101  1158.805     0.150
   137.978  1169.805     0.150
   138.700  1168.805     0.150
   138.700  1336.703     0.150
   138.700  1386.105     0.150
   138.826  1167.805     0.150
   140.730  1167.305     0.150
   140.931  1169.805     0.150
   143.552  1172.805     0.150
   144.324  1176.805     0.150
   144.500  1175.203     0.150
   145.423  1176.906     0.150
   145.742  1178.406     0.150
   145.860  1178.805     0.150
   146.376  1180.406     0.150
   147.542  1184.504     0.150
   147.634  1184.805     0.150
   147.711  1185.305     0.150
   147.790  1184.805     0.150
   147.812  1184.105     0.150
   147.873  1185.203     0.150
   147.971  1185.805     0.150
   148.046  1184.805     0.150
   148.142  1184.805     0.150
   148.592  1187.805     0.150
   155.043  1219.805     0.150
     1.492    27.812     0.150
     1.846    34.613     0.150
     2.140    38.113     0.150
     2.335    40.512     0.150
     2.575    45.113     0.150
     3.013    53.812     0.150
     3.013    96.914     0.150
     3.869    63.711     0.150
     3.869   112.211     0.150
     4.023    66.312     0.150
     4.023    67.012     0.150
     4.130    67.914     0.150
     4.144    66.812     0.150
     4.144   119.613     0.150
     4.149    66.312     0.150
     4.149   117.613     0.150
     4.149    67.113     0.150
     4.246    69.414     0.150
     4.246   122.414     0.150
     4.341    69.711     0.150
     4.647   140.113     0.150
     5.730    89.012     0.150
     5.730   156.312     0.150
     6.329    97.312     0.150
     6.329   175.711     0.150
     6.329    97.414     0.150
     6.628   103.312     0.150
     6.760    99.312     0.150
     6.760    99.812     0.150
     8.299   120.312     0.150
     8.299   209.113     0.150
     8.124   120.312     0.150
     8.124   121.211     0.150
     8.849   131.312     0.150
     8.849   234.312     0.150
     8.849   131.812     0.150
     9.059   131.312     0.150
     9.714   143.113     0.150
    10.067   148.312     0.150
    10.067   148.812     0.150
    10.121   150.012     0.150
    10.266   148.312     0.150
    10.266   148.812     0.150
    10.450   150.312     0.150
    14.345   201.812     0.150
    14.410   201.512     0.150
    14.444   200.914     0.150
    14.657   204.414     0.150
    15.045   208.312     0.150
    16.241   227.812     0.150
    17.355   243.312     0.150
    17.355   445.414     0.150
    17.355   244.113     0.150
    18.229   252.211     0.150
    18.619   261.312     0.150
    18.619   465.312     0.150
    19.378   266.113     0.150
    19.780   291.711     0.150
    20.644   279.812     0.150
    20.644   500.312     0.150
    21.772   290.512     0.150
    21.772   534.312     0.150
    22.123   295.012     0.150
    22.123   537.312     0.150
    22.369   298.312     0.150
    22.236   299.113     0.150
    23.188   306.312     0.150
    23.188   557.914     0.150
    23.188   342.414     0.150
    23.932   316.113     0.150
    27.262   345.812     0.150
    28.237   354.312     0.150
    28.632   357.512     0.150
    30.838   445.312     0.150
    31.072   378.312     0.150
    31.707   383.512     0.150
    32.158   387.914     0.150
    33.890   403.914     0.150
    34.272   407.312     0.150
    35.297   417.312     0.150
    36.230   422.613     0.150
    36.230     3.699     0.150
    36.504   426.812     0.150
    37.057   431.312     0.150
    37.139   429.312     0.150
    37.139   430.211     0.150
    37.846   438.211     0.150
    39.082   446.812     0.150
    39.271   448.312     0.150
    39.284   451.312     0.150
    39.301   448.414     0.150
    41.396   465.012     0.150
    41.241   465.312     0.150
    42.161   471.914     0.150
    42.261   471.914     0.150
    43.045   480.812     0.150
    43.416   591.312     0.150
    44.205   488.254     0.150
    44.254   489.012     0.150
    44.492   490.891     0.150
    44.792   493.812     0.150
    45.596   498.812     0.150
    45.799   499.312     0.150
    45.799   499.613     0.150
    47.706   515.312     0.150
    47.706     6.000     0.150
    47.706   625.312     0.150
    48.316   521.512     0.150
    50.501   538.512     0.150
    50.802   540.711     0.150
    51.440   545.914     0.150
    51.678   547.613     0.150
    52.088   550.711     0.150
    52.997   557.211     0.150
    54.341   566.312     0.150
    54.341   566.414     0.150
    56.269   579.312     0.150
    56.269   579.812     0.150
    56.397   580.312     0.150
    56.522   580.312     0.150
    56.532   580.312     0.150
    64.179   636.312     0.150
    65.679   643.312     0.150
    67.390   655.312     0.150
    69.241   666.312     0.150
    75.845   705.312     0.150
    76.418   708.312     0.150
    76.708   710.312     0.150
    81.435   737.012     0.150
    81.444   736.012     0.150
    83.149   745.211     0.150
    83.169   744.711     0.150
    86.079   759.312     0.150
     1.463    27.414     0.150
     1.463    49.211     0.150
     1.855    35.008     0.150
     2.144    38.508     0.150
     2.367    41.211     0.150
     2.534    45.508     0.150
     2.956    53.609     0.150
     2.956    95.211     0.150
     3.299    53.414     0.150
     3.284    57.414     0.150
     3.284   106.211     0.150
     3.842    63.609     0.150
     3.842   121.211     0.150
     3.946    67.312     0.150
     3.946   115.008     0.150
     4.000    66.812     0.150
     4.097    67.812     0.150
     4.097   117.711     0.150
     4.123    68.211     0.150
     4.123   121.211     0.150
     4.123    67.609     0.150
     4.233    69.914     0.150
     4.233   123.914     0.150
     4.339    71.211     0.150
     4.339    71.609     0.150
     4.598    75.211     0.150
     5.376    84.008     0.150
     5.376   148.008     0.150
     5.722    89.414     0.150
     5.722   154.711     0.150
     6.275   172.508     0.150
     6.275    96.109     0.150
     6.558   103.211     0.150
     6.558   179.211     0.150
     6.558   202.211     0.150
     7.136   110.211     0.150
     8.284   120.211     0.150
     8.284   210.414     0.150
     8.057   120.211     0.150
     8.057   120.609     0.150
     8.789   130.211     0.150
     8.789   230.609     0.150
     8.789   131.008     0.150
     9.108   133.414     0.150
     9.108   238.211     0.150
     9.774   144.008     0.150
     9.976   148.211     0.150
     9.998   148.211     0.150
     9.998   149.008     0.150
    10.055   149.211     0.150
    10.306   149.211     0.150
    10.490   151.211     0.150
    10.490   274.711     0.150
    11.381   162.008     0.150
    14.322   200.812     0.150
    14.322   212.812     0.150
    14.322   364.812     0.150
    14.322   380.812     0.150
    14.372   201.609     0.150
    14.406   201.414     0.150
    14.619   205.008     0.150
    15.057   209.711     0.150
    16.343   231.711     0.150
    16.168   227.211     0.150
    17.295   243.211     0.150
    17.295   444.008     0.150
    17.295   243.609     0.150
    18.176   254.609     0.150
    18.631   254.211     0.150
    18.631   466.211     0.150
    19.822   274.812     0.150
    19.822   277.211     0.150
    19.998   275.211     0.150
    20.601   280.711     0.150
    21.324   289.211     0.150
    21.890   293.711     0.150
    21.708   289.812     0.150
    21.708   532.211     0.150
    22.063   295.211     0.150
    22.063   537.508     0.150
    22.272   300.211     0.150
    22.321   298.211     0.150
    22.321   538.211     0.150
    22.321   576.711     0.150
    22.790   300.211     0.150
    22.790   547.211     0.150
    23.162   307.211     0.150
    23.162   307.609     0.150
    23.248   308.211     0.150
    23.248   565.211     0.150
    23.861   315.812     0.150
    23.986   315.211     0.150
    23.986   316.008     0.150
    25.140   327.211     0.150
    27.194   345.711     0.150
    28.176   354.812     0.150
    28.559   357.812     0.150
    31.077   379.008     0.150
    31.640   384.508     0.150
    32.101   388.414     0.150
    34.238   409.609     0.150
    35.327   418.211     0.150
    36.179   422.914     0.150
    36.179     5.297     0.150
    36.179   507.211     0.150
    36.433   426.211     0.150
    36.992   431.211     0.150
    37.069   430.211     0.150
    37.069   430.914     0.150
    37.576   435.211     0.150
    37.776   438.414     0.150
    39.082   447.508     0.150
    39.266   448.812     0.150
    41.228   466.508     0.150
    42.157   472.414     0.150
    42.264   472.211     0.150
    43.066   481.211     0.150
    43.066   481.914     0.150
    43.484   485.211     0.150
    43.437   485.211     0.150
    43.919   488.914     0.150
    44.208   488.812     0.150
    44.257   489.508     0.150
    44.495   491.312     0.150
    45.285   498.711     0.150
    45.598   499.609     0.150
    45.731   500.211     0.150
    47.645   515.211     0.150
    47.645   515.609     0.150
    48.341   522.312     0.150
    50.527   539.211     0.150
    50.670   540.312     0.150
    50.827   541.414     0.150
    51.467   546.711     0.150
    51.704   548.414     0.150
    52.116   551.711     0.150
    52.173   551.414     0.150
    53.024   558.211     0.150
    56.201   579.211     0.150
    56.201   579.812     0.150
    56.374   580.914     0.150
    65.618   643.211     0.150
    65.618   643.609     0.150
    65.618   677.211     0.150
    67.462   656.211     0.150
    74.236   697.109     0.150
    76.362   708.211     0.150
    81.405   736.414     0.150
    81.413   736.508     0.150
    83.106   745.711     0.150
    86.046   760.211     0.150
     1.077    19.492     0.150
     1.460    26.891     0.150
     1.840    34.492     0.150
     2.131    38.094     0.150
     2.536    44.891     0.150
     2.980    52.891     0.150
     2.980    93.492     0.150
     3.226    57.391     0.150
     3.304    57.391     0.150
     3.304   101.992     0.150
     3.872    64.191     0.150
     4.018    65.492     0.150
     4.018    65.992     0.150
     4.117    67.492     0.150
     4.117   117.992     0.150
     4.141    66.891     0.150
     4.141   117.391     0.150
     4.141    67.492     0.150
     4.141   122.293     0.150
     4.249   121.992     0.150
     4.486    68.992     0.150
     4.486   118.992     0.150
     4.337    69.492     0.150
     4.337    70.391     0.150
     4.360    70.691     0.150
     5.324   145.492     0.150
     5.395   140.594     0.150
     5.395    77.391     0.150
     5.736    89.391     0.150
     5.736   158.492     0.150
     6.298    98.492     0.150
     6.298   176.094     0.150
     6.581   102.492     0.150
     6.747   101.492     0.150
     6.747   101.992     0.150
     8.081   119.492     0.150
     8.081   211.293     0.150
     8.081   119.691     0.150
     8.277   120.293     0.150
     8.813   131.492     0.150
     8.813   228.492     0.150
     8.813   131.992     0.150
     9.102   134.293     0.150
     9.102   232.492     0.150
     9.764   144.492     0.150
    10.000   147.492     0.150
    10.080   145.492     0.150
    10.022   146.492     0.150
    10.304   149.492     0.150
    10.488   268.492     0.150
    12.170   172.492     0.150
    12.170   305.492     0.150
    14.373   200.992     0.150
    14.407   201.594     0.150
    14.620   204.793     0.150
    15.972   229.492     0.150
    16.191   225.992     0.150
    16.191   407.492     0.150
    16.323   229.191     0.150
    17.319   241.492     0.150
    17.319   444.594     0.150
    17.324   246.492     0.150
    18.183   253.191     0.150
    18.616   254.492     0.150
    19.337   265.492     0.150
    19.709   272.492     0.150
    19.820   272.094     0.150
    19.820   499.492     0.150
    19.997   274.492     0.150
    21.006   286.492     0.150
    21.006   519.492     0.150
    21.323   288.492     0.150
    21.323   532.492     0.150
    21.873   293.992     0.150
    21.867   295.492     0.150
    22.087   294.492     0.150
    22.087   534.992     0.150
    22.272   299.691     0.150
    22.262   297.492     0.150
    22.796   300.492     0.150
    23.078   305.594     0.150
    23.181   306.492     0.150
    23.181   307.191     0.150
    23.266   306.492     0.150
    23.266   564.492     0.150
    23.266   307.293     0.150
    23.266   338.492     0.150
    23.686   315.992     0.150
    23.879   316.191     0.150
    24.010   316.293     0.150
    25.344   326.492     0.150
    27.765   350.492     0.150
    28.582   357.492     0.150
    28.582   649.492     0.150
    29.802   368.992     0.150
    29.851   368.492     0.150
    30.852   443.492     0.150
    31.087   378.992     0.150
    31.087   446.492     0.150
    31.655   383.293     0.150
    31.718   385.391     0.150
    32.110   387.891     0.150
    32.818   394.492     0.150
    34.237   408.992     0.150
    34.237   480.492     0.150
    34.864   413.492     0.150
    35.329   417.992     0.150
    35.558   417.492     0.150
    35.772   420.492     0.150
    36.202   422.793     0.150
    36.202   507.492     0.150
    36.194   422.492     0.150
    37.005   430.492     0.150
    37.039   431.492     0.150
    37.582   435.492     0.150
    37.793   438.293     0.150
    37.930   438.891     0.150
    38.709   445.492     0.150
    39.094   447.391     0.150
    39.130   448.492     0.150
    39.130   537.492     0.150
    39.193   447.492     0.150
    39.193   447.992     0.150
    39.279   448.492     0.150
    39.307   449.293     0.150
    39.311   451.492     0.150
    39.311    10.000     0.150
    39.351   450.691     0.150
    39.472   450.492     0.150
    39.472   450.793     0.150
    39.592   452.391     0.150
    39.592   451.793     0.150
    39.592    12.098     0.150
    41.244   464.492     0.150
    41.244   467.094     0.150
    41.667   470.492     0.150
    41.802   470.492     0.150
    41.802     7.000     0.150
    41.802   587.492     0.150
    41.953   564.492     0.150
    42.170   472.594     0.150
    42.275   473.191     0.150
    42.373   473.492     0.150
    42.897   480.691     0.150
    43.071   481.594     0.150
    43.140   482.492     0.150
    43.140   582.492     0.150
    43.296   482.793     0.150
    43.296   590.492     0.150
    43.385   485.391     0.150
    43.442   484.191     0.150
    43.442     6.301     0.150
    43.442   591.492     0.150
    43.442     5.902     0.150
    43.726   486.492     0.150
    43.726   590.492     0.150
    43.726   589.992     0.150
    43.860   487.293     0.150
    43.921   488.594     0.150
    44.017   488.992     0.150
    44.026   488.293     0.150
    44.031   488.691     0.150
    44.031   590.492     0.150
    44.364   491.094     0.150
    44.771   493.992     0.150
    44.729   495.293     0.150
    44.918   495.594     0.150
    44.926   495.492     0.150
    44.926   598.492     0.150
    45.100   497.492     0.150
    45.231   499.391     0.150
    45.421   500.992     0.150
    45.610   498.492     0.150
    45.755   498.492     0.150
    45.755   906.891     0.150
    45.755   499.094     0.150
    46.125   506.391     0.150
    46.242   505.992     0.150
    46.315   506.992     0.150
    46.712   509.492     0.150
    46.994   511.492     0.150
    47.195   512.492     0.150
    47.229   515.492     0.150
    47.304   515.492     0.150
    47.637   518.492     0.150
    47.669   515.492     0.150
    47.828   517.492     0.150
    47.833   517.691     0.150
    48.205   520.992     0.150
    48.345   522.094     0.150
    48.534   523.492     0.150
    48.614   524.191     0.150
    49.217   528.293     0.150
    49.444   530.191     0.150
    49.816   535.492     0.150
    50.373   537.191     0.150
    50.398   537.391     0.150
    50.530   538.793     0.150
    50.674   539.691     0.150
    50.935   539.992     0.150
    50.831   540.891     0.150
    50.918   541.793     0.150
    51.470   546.391     0.150
    51.707   547.891     0.150
    52.119   551.191     0.150
    52.176   551.094     0.150
    52.405   553.391     0.150
    52.754   555.094     0.150
    52.784   555.992     0.150
    52.951   556.293     0.150
    53.027   557.891     0.150
    53.221   558.691     0.150
    53.277   558.793     0.150
    53.323   558.793     0.150
    53.477   560.492     0.150
    53.810   563.094     0.150
    54.081   564.793     0.150
    54.289   565.492     0.150
    54.289   566.293     0.150
    54.340   568.492     0.150
    55.531   574.793     0.150
    55.673   575.992     0.150
    55.745   576.793     0.150
    55.832   576.992     0.150
    55.980   580.492     0.150
    56.033   578.793     0.150
    56.392   580.793     0.150
    56.576   582.191     0.150
    57.928   593.492     0.150
    58.203   594.492     0.150
    63.075   628.492     0.150
    64.227   635.492     0.150
    66.531   651.492     0.150
    67.438   656.492     0.150
    69.219   665.492     0.150
    74.673   700.492     0.150
    75.818   705.492     0.150
    76.060   707.492     0.150
    76.386   708.492     0.150
    76.704   710.492     0.150
    81.403   737.191     0.150
    81.411   735.992     0.150
    83.128   745.293     0.150
    83.147   744.992     0.150
    83.569   747.492     0.150
    92.448   789.992     0.150
   124.449  1138.691     0.150
   138.700  1168.492     0.150
   138.826  1167.492     0.150
   147.796  1186.492     0.150
   147.818  1186.094     0.150
   147.977  1186.992     0.150
   148.052  1186.992     0.150
   148.148  1186.992     0.150
   148.598  1188.191     0.150
     1.461    27.602     0.150
     2.137    39.398     0.150
     2.534    45.898     0.150
     2.899    50.000     0.150
     2.967    54.500     0.150
     2.967    95.102     0.150
     3.292    54.102     0.150
     3.221    58.898     0.150
     3.221   108.805     0.150
     3.294    58.305     0.150
     3.852    64.805     0.150
     3.852   114.602     0.150
     3.862   112.398     0.150
     4.180    67.602     0.150
     4.180   114.602     0.150
     3.956    67.703     0.150
     3.956   117.703     0.150
     4.009    67.000     0.150
     4.009   116.203     0.150
     4.108    68.703     0.150
     4.132    68.305     0.150
     4.132   118.805     0.150
     4.132    68.703     0.150
     4.132   122.102     0.150
     4.241    70.500     0.150
     4.241   124.602     0.150
     4.328    71.305     0.150
     4.350    71.703     0.150
     4.350   130.898     0.150
     4.610    76.102     0.150
     4.610   141.398     0.150
     4.610    76.703     0.150
     5.336    84.102     0.150
     5.729    90.102     0.150
     6.286    98.102     0.150
     6.286    98.398     0.150
     6.569   104.102     0.150
     6.569   183.102     0.150
     6.737   103.102     0.150
     6.737   103.703     0.150
     7.736   115.898     0.150
     8.069   121.102     0.150
     8.069   215.898     0.150
     8.069   121.398     0.150
     8.280   121.102     0.150
     8.280   159.102     0.150
     8.280   212.102     0.150
     8.280   268.102     0.150
     8.801   132.305     0.150
     8.801   234.500     0.150
     9.106   135.102     0.150
     9.716   140.703     0.150
     9.716   247.703     0.150
     9.770   145.805     0.150
     9.988   148.102     0.150
     9.988   148.500     0.150
    10.010   147.102     0.150
    10.010   147.805     0.150
    10.067   149.102     0.150
    10.079   149.102     0.150
    10.490   152.102     0.150
    11.370   163.500     0.150
    11.370   293.500     0.150
    14.319   203.398     0.150
    14.372   202.500     0.150
    14.406   202.203     0.150
    14.619   205.102     0.150
    15.049   211.602     0.150
    15.049   372.602     0.150
    16.026   228.102     0.150
    16.179   226.703     0.150
    16.333   229.602     0.150
    17.253   240.102     0.150
    17.253   423.102     0.150
    17.307   245.102     0.150
    17.307   440.602     0.150
    17.307   245.203     0.150
    17.585   245.102     0.150
    18.179   254.898     0.150
    18.623   257.102     0.150
    18.623   452.602     0.150
    18.623   483.602     0.150
    19.712   275.102     0.150
    19.822   275.102     0.150
    20.402   280.102     0.150
    20.602   280.602     0.150
    20.602   498.102     0.150
    21.881   296.000     0.150
    21.720   289.102     0.150
    21.720   533.102     0.150
    21.720   289.805     0.150
    22.075   296.102     0.150
    22.322   299.102     0.150
    22.322   544.102     0.150
    22.273   301.102     0.150
    23.078   307.102     0.150
    23.172   308.102     0.150
    23.172   340.000     0.150
    23.257   308.102     0.150
    23.257   570.102     0.150
    23.257   308.500     0.150
    23.689   317.305     0.150
    23.869   317.000     0.150
    25.131   328.102     0.150
    28.181   355.703     0.150
    28.570   358.102     0.150
    28.570   358.500     0.150
    28.570   409.102     0.150
    29.457   366.602     0.150
    29.801   371.102     0.150
    31.083   380.102     0.150
    32.105   389.102     0.150
    35.328   418.602     0.150
    35.328   419.102     0.150
    36.190   423.102     0.150
    37.081   430.102     0.150
    37.081   430.898     0.150
    37.931   440.305     0.150
    39.089   448.102     0.150
    39.273   449.898     0.150
    39.300   451.102     0.150
    39.590   453.102     0.150
    39.590   453.500     0.150
    41.377   468.102     0.150
    41.236   467.102     0.150
    42.270   474.500     0.150
    42.365   475.102     0.150
    43.295   484.500     0.150
    43.394   484.602     0.150
    43.440   485.102     0.150
    43.484   486.102     0.150
    44.391   492.602     0.150
    44.774   494.602     0.150
    44.919   497.102     0.150
    45.007   499.102     0.150
    45.100   497.805     0.150
    45.287   500.102     0.150
    45.421   502.602     0.150
    45.605   500.805     0.150
    47.228   516.602     0.150
    47.657   517.102     0.150
    47.833   519.203     0.150
    47.886   518.602     0.150
    48.893   527.602     0.150
    49.444   531.500     0.150
    49.816   534.703     0.150
    50.529   540.398     0.150
    50.673   540.898     0.150
    50.830   542.398     0.150
    51.469   547.500     0.150
    51.706   549.500     0.150
    52.118   552.703     0.150
    52.175   552.602     0.150
    52.404   555.000     0.150
    53.026   559.398     0.150
    53.319   559.500     0.150
    53.810   563.703     0.150
    56.383   582.102     0.150
    56.585   583.602     0.150
    63.087   630.102     0.150
    64.239   638.102     0.150
    67.450   658.102     0.150
    69.208   667.703     0.150
    75.806   706.102     0.150
    76.374   709.102     0.150
    76.686   712.305     0.150
    81.403   738.000     0.150
    81.412   737.305     0.150
     1.437    26.438     0.150
     1.437    48.234     0.150
     1.850    34.438     0.150
     2.136    37.531     0.150
     2.377    41.836     0.150
     2.501    44.133     0.150
     2.501    77.234     0.150
     2.928    48.633     0.150
     2.929    51.836     0.150
     2.929    89.938     0.150
     3.287    52.336     0.150
     3.277    55.734     0.150
     3.277    96.234     0.150
     3.638   104.234     0.150
     3.843   111.633     0.150
     3.838    62.734     0.150
     3.838   109.234     0.150
     4.150    65.234     0.150
     4.150   116.734     0.150
     3.999    64.336     0.150
     3.999   113.133     0.150
     4.119    66.234     0.150
     4.119   114.734     0.150
     4.123    67.234     0.150
     4.123   118.234     0.150
     4.325    69.336     0.150
     4.317    68.836     0.150
     4.609    73.234     0.150
     4.609   129.234     0.150
     5.370   144.234     0.150
     6.370    98.133     0.150
     6.370   171.133     0.150
     6.519   101.234     0.150
     6.718   103.234     0.150
     7.710   109.836     0.150
     7.710   192.234     0.150
     8.264   119.234     0.150
     8.264   157.234     0.150
     8.264   208.234     0.150
     8.264   240.234     0.150
     8.760   130.234     0.150
     8.760   225.234     0.150
     9.145   135.234     0.150
     9.687   139.938     0.150
     9.943   145.734     0.150
     9.962   145.234     0.150
     9.816   144.234     0.150
    10.021   147.938     0.150
    10.021   259.938     0.150
    10.339   151.234     0.150
    10.524   151.836     0.150
    10.524   271.836     0.150
    11.399   162.336     0.150
    13.779   192.836     0.150
    14.297   199.336     0.150
    14.341   200.234     0.150
    14.374   200.031     0.150
    14.587   203.734     0.150
    14.763   205.438     0.150
    15.844   221.734     0.150
    16.126   224.234     0.150
    16.126   400.734     0.150
    16.349   232.734     0.150
    17.265   242.336     0.150
    17.265   437.438     0.150
    17.601   244.234     0.150
    17.601   436.234     0.150
    18.138   251.031     0.150
    18.627   256.234     0.150
    18.627   454.234     0.150
    18.627   459.734     0.150
    20.567   278.234     0.150
    21.891   292.031     0.150
    22.035   293.031     0.150
    22.035   318.633     0.150
    22.035   534.234     0.150
    23.816   313.633     0.150
    25.142   326.031     0.150
    28.519   355.234     0.150
    32.061   386.633     0.150
    36.157   421.234     0.150
    36.157    12.000     0.150
    37.032   426.234     0.150
    39.094   446.031     0.150
    39.275   447.438     0.150
    41.361   464.234     0.150
    45.611   498.234     0.150
    48.617   523.234     0.150
    56.638   584.133     0.150
    69.181   664.234     0.150
    74.279   695.734     0.150
    75.773   703.531     0.150
    81.375   735.234     0.150
    81.376   735.133     0.150
    83.546   746.734     0.150
     1.229    23.477     0.150
     1.575    30.070     0.150
     1.865    34.273     0.150
     2.104    37.375     0.150
     2.333    42.273     0.150
     2.333    72.273     0.150
     2.671    45.672     0.150
     3.022    49.273     0.150
     3.022    94.273     0.150
     3.532    59.273     0.150
     3.532   109.273     0.150
     3.963    63.273     0.150
     5.215   139.273     0.150
     5.725   169.773     0.150
     7.503   109.273     0.150
     7.503   191.773     0.150
     8.021   117.273     0.150
     8.021   202.773     0.150
     8.632   125.977     0.150
     9.288   136.273     0.150
     9.288   236.273     0.150
     9.490   137.273     0.150
     9.490   241.570     0.150
    11.139   156.977     0.150
    13.596   190.773     0.150
    14.155   197.375     0.150
    14.192   198.273     0.150
    17.012   415.273     0.150
    20.400   277.477     0.150
    20.400   495.977     0.150
    21.613   292.273     0.150
    35.563   420.273     0.150
    39.359   449.273     0.150
    39.545   451.070     0.150
    44.532   490.977     0.150
    45.874   501.875     0.150
    48.588   523.773     0.150
    48.858   525.773     0.150
    48.997   527.273     0.150
    50.615   539.070     0.150
    50.641   539.070     0.150
    50.771   540.570     0.150
    51.072   542.672     0.150
    51.461   545.570     0.150
    51.721   547.977     0.150
    51.948   549.672     0.150
    52.356   552.773     0.150
    52.417   552.672     0.150
    53.265   559.172     0.150
    56.623   583.273     0.150
     1.455    27.242     0.150
     1.455    50.941     0.150
     1.871    36.441     0.150
     2.156    39.941     0.150
     2.516    46.242     0.150
     2.516    79.941     0.150
     3.307    54.840     0.150
     5.394    87.941     0.150
     6.510   103.941     0.150
     6.510   174.941     0.150
     7.727   116.441     0.150
     7.727   202.242     0.150
     8.283   121.941     0.150
     8.283   211.242     0.150
     9.133   136.941     0.150
    13.795   194.941     0.150
    14.356   202.543     0.150
    14.389   202.742     0.150
    14.603   205.742     0.150
    14.778   207.543     0.150
    20.581   280.441     0.150
    20.581   498.941     0.150
    21.911   296.141     0.150
    23.818   316.543     0.150
    25.162   328.941     0.150
    39.074   448.941     0.150
    39.254   449.941     0.150
    42.337   474.941     0.150
    45.591   500.742     0.150
    48.767   527.941     0.150
    48.777   527.941     0.150
    50.535   540.840     0.150
    50.835   542.543     0.150
    52.126   553.340     0.150
    53.034   560.043     0.150
    53.820   564.543     0.150
    75.756   707.941     0.150
     1.368    25.490     0.150
     2.091    36.289     0.150
     2.423    42.590     0.150
     6.473   101.090     0.150
     6.473   108.090     0.150
     6.473   173.391     0.150
     8.201   118.090     0.150
     8.740   129.490     0.150
     8.740   227.090     0.150
    10.417   146.090     0.150
    13.703   191.289     0.150
    14.264   198.289     0.150
    14.297   198.490     0.150
    14.511   201.090     0.150
    14.686   203.490     0.150
    16.069   225.590     0.150
    16.069   234.090     0.150
    16.069   239.590     0.150
    16.069   400.090     0.150
    16.069   407.590     0.150
    16.069   416.590     0.150
    16.325   230.090     0.150
    18.057   248.590     0.150
    18.586   253.090     0.150
    18.586   468.090     0.150
    21.105   286.090     0.150
    21.435   289.090     0.150
    21.858   291.189     0.150
    23.176   305.090     0.150
    23.185   305.990     0.150
    23.277   306.090     0.150
    23.743   313.189     0.150
    25.112   325.090     0.150
    28.053   351.090     0.150
    28.466   354.391     0.150
    31.518     4.500     0.150
    31.979   385.289     0.150
    31.979     8.801     0.150
    35.120   413.090     0.150
    35.120   413.590     0.150
    36.989   425.090     0.150
    36.989   425.891     0.150
    39.008   444.590     0.150
    39.146   445.689     0.150
    40.706   460.090     0.150
    42.213   471.189     0.150
    43.527   483.490     0.150
    43.527     6.600     0.150
    43.748     7.699     0.150
    44.326   487.391     0.150
    45.665   497.891     0.150
    47.594   512.590     0.150
    48.436   520.789     0.150
    48.598   523.090     0.150
    48.856   524.689     0.150
    48.866   524.689     0.150
    50.624   537.590     0.150
    50.766   538.490     0.150
    50.923   539.789     0.150
    51.574   545.189     0.150
    51.801   546.891     0.150
    52.215   550.189     0.150
    52.269   549.689     0.150
    52.500   552.289     0.150
    53.123   556.689     0.150
    56.401   578.590     0.150
    63.187   625.891     0.150
    67.550   654.289     0.150
    69.185   666.090     0.150
    75.769   703.590     0.150
    76.322   706.311     0.150
    81.303   734.289     0.150
    81.323   733.891     0.150
    83.475   745.289     0.150
     1.243    23.684     0.150
     2.181    41.184     0.150
     2.551    45.082     0.150
     3.218    53.082     0.150
     3.178    54.684     0.150
     5.798    91.582     0.150
     6.092   114.082     0.150
     6.892   108.082     0.150
     8.079   118.582     0.150
     8.079   206.082     0.150
     8.442   127.480     0.150
     9.548   142.082     0.150
     9.548   258.082     0.150
    13.449   189.980     0.150
    14.013   197.480     0.150
    14.040   197.281     0.150
    14.257   200.281     0.150
    14.420   202.582     0.150
    15.663   220.684     0.150
    15.663   397.082     0.150
    16.444   229.980     0.150
    17.725   248.582     0.150
    18.607   257.480     0.150
    18.607   452.082     0.150
    20.208   277.082     0.150
    20.208   490.082     0.150
    21.327   291.082     0.150
    21.925   295.281     0.150
    21.672   294.082     0.150
    21.710   294.082     0.150
    23.096   307.883     0.150
    23.329   311.582     0.150
    23.210   310.082     0.150
    23.210   338.082     0.150
    23.395   311.082     0.150
    27.675   349.684     0.150
    28.066   353.883     0.150
    29.435   366.082     0.150
    31.119   382.281     0.150
    34.719   412.082     0.150
    34.719   412.281     0.150
    35.649   421.582     0.150
    35.649   422.082     0.150
    36.612   425.883     0.150
    39.043   447.582     0.150
    39.202   449.281     0.150
    41.357   466.082     0.150
    43.935   488.582     0.150
    44.400   490.883     0.150
    48.627   525.082     0.150
    48.894   527.082     0.150
    49.067   529.480     0.150
    49.077   529.480     0.150
    50.661   540.684     0.150
    50.822   541.980     0.150
    50.961   542.883     0.150
    51.120   544.082     0.150
    52.000   551.281     0.150
    56.324   581.480     0.150
    57.135   587.781     0.150
    73.674   696.184     0.150
    74.741   701.062     0.150
    74.811   701.344     0.150
    75.053   702.703     0.150
    81.084   736.883     0.150
    81.092   735.883     0.150
     1.400    25.844     0.150
     2.169    38.242     0.150
     2.471    41.844     0.150
     2.471    77.641     0.150
     2.424    42.242     0.150
     3.304    52.844     0.150
     7.656   110.344     0.150
     8.245   119.141     0.150
     8.245   208.641     0.150
     9.250   134.641     0.150
     9.250   233.641     0.150
     9.865   144.641     0.150
     9.878   144.641     0.150
    10.424   147.641     0.150
    10.424   148.141     0.150
    11.507   160.141     0.150
    11.507   281.641     0.150
    12.445   174.312     0.150
    12.867   180.109     0.150
    13.076   183.430     0.150
    13.486   185.641     0.150
    13.704   190.953     0.150
    14.267   198.469     0.150
    14.298   198.391     0.150
    14.512   201.328     0.150
    14.683   203.367     0.150
    15.738   216.547     0.150
    16.361   225.688     0.150
    16.377   225.867     0.150
    18.281   251.641     0.150
    18.281   459.641     0.150
    18.667   256.141     0.150
    20.480   277.141     0.150
    20.480   495.641     0.150
    21.456   287.438     0.150
    21.950   292.844     0.150
    22.279   297.641     0.150
    23.185   305.641     0.150
    23.185   305.039     0.150
    23.185   560.938     0.150
    23.396   307.438     0.150
    23.396   573.242     0.150
    28.351   352.641     0.150
    36.903     8.594     0.150
    38.774   442.742     0.150
    38.774     7.102     0.150
    42.639   474.641     0.150
    42.639     7.102     0.150
    43.722   484.844     0.150
    43.722     7.594     0.150
    45.407   495.742     0.150
    45.407     7.602     0.150
    45.604   496.539     0.150
    49.110   526.344     0.150
    56.431   579.344     0.150
    69.070   663.242     0.150
    74.416   695.742     0.150
    74.728   697.344     0.150
    76.253   708.039     0.150
    82.628   740.039     0.150
    83.498   746.344     0.150
   122.190  1132.641     0.150
     1.510    27.918     0.150
     2.162    38.316     0.150
     2.356    39.719     0.150
     2.356    74.117     0.150
     2.590    45.316     0.150
     2.885    50.117     0.150
     3.321    53.516     0.150
     5.291    84.418     0.150
     8.319   121.117     0.150
     8.319   209.117     0.150
    21.892   294.117     0.150
    23.248   307.516     0.150
    37.877   437.516     0.150
    38.656   443.617     0.150
    38.762   443.719     0.150
    38.932   445.418     0.150
    42.140   471.617     0.150
    42.240   472.016     0.150
    42.681   475.816     0.150
    44.233   489.016     0.150
    45.377   496.918     0.150
    45.575   498.516     0.150
    48.711   524.918     0.150
    48.721   524.816     0.150
    49.193   527.418     0.150
    56.155   578.117     0.150
    69.221   665.617     0.150
    81.453   736.918     0.150
    81.453   736.016     0.150
    81.472   736.016     0.150
    83.619   746.918     0.150
     1.289    24.742     0.150
     2.130    39.141     0.150
     2.268    40.242     0.150
     2.268    70.941     0.150
     3.239    54.141     0.150
     5.693    89.141     0.150
     8.135   120.441     0.150
     8.135   205.441     0.150
    12.921   182.043     0.150
    13.543   190.680     0.150
    14.107   196.840     0.150
    14.135   197.941     0.150
    14.351   200.801     0.150
    14.518   202.820     0.150
    14.884   208.281     0.150
    15.576   216.281     0.150
    16.193   224.543     0.150
    16.213   226.340     0.150
    18.622   262.441     0.150
    18.622   460.441     0.150
    23.546   316.242     0.150
    29.751   367.043     0.150
    36.760   428.441     0.150
    38.850   445.543     0.150
    42.677   477.141     0.150
    44.356   490.043     0.150
    45.689   500.242     0.150
    49.117   526.543     0.150
    56.630   582.242     0.150
    69.024   664.340     0.150
    76.409   708.840     0.150
    81.169   734.742     0.150
     0.758    15.141     0.150
     1.689    31.039     0.150
     1.717    34.242     0.150
     2.273    42.242     0.150
     2.756    46.742     0.150
     2.756    87.641     0.150
     7.577   111.641     0.150
    11.712   165.617     0.150
    12.130   171.438     0.150
    12.342   174.023     0.150
    12.966   182.281     0.150
    13.530   189.078     0.150
    13.559   190.000     0.150
    13.774   192.719     0.150
    13.943   195.023     0.150
    14.309   199.297     0.150
    15.000   207.898     0.150
    15.621   217.242     0.150
    15.638   216.758     0.150
    23.651   311.641     0.150
    23.931   314.641     0.150
    35.772   418.141     0.150
    36.738   426.742     0.150
    39.373   448.844     0.150
    39.530   450.344     0.150
    43.144   479.938     0.150
    44.435   491.242     0.150
    44.896   494.039     0.150
    46.033   502.438     0.150
    46.226   503.938     0.150
    49.526   530.438     0.150
    51.183   542.742     0.150
    53.326   560.039     0.150
    54.014   564.344     0.150
    56.998   586.742     0.150
    69.308   668.242     0.150
    75.805   704.539     0.150
     1.274    24.273     0.150
     2.105    39.477     0.150
     2.105    68.273     0.150
     2.270    40.875     0.150
     2.270    73.570     0.150
     2.263    41.273     0.150
     2.476    44.273     0.150
     3.083    53.477     0.150
     5.661    89.375     0.150
     8.121   118.273     0.150
     8.121   207.773     0.150
     9.880   142.227     0.150
     9.976   144.281     0.150
    10.217   147.547     0.150
    10.768   156.031     0.150
    11.161   159.562     0.150
    11.468   163.406     0.150
    12.286   173.883     0.150
    12.704   179.906     0.150
    13.540   189.961     0.150
    14.103   197.641     0.150
    14.132   198.047     0.150
    14.348   200.883     0.150
    21.506   289.273     0.150
    29.748   367.875     0.150
    38.869   445.172     0.150
    42.701   477.773     0.150
    44.373   490.570     0.150
    45.512   498.875     0.150
    56.609   583.672     0.150
    58.192   594.477     0.150
    82.964   745.477     0.150
    83.349   746.875     0.150
     1.339    25.883     0.150
     2.344    43.184     0.150
     2.344    81.285     0.150
     2.337    43.184     0.150
     2.337    74.684     0.150
     2.496    45.184     0.150
     3.271    94.684     0.150
     6.259   167.184     0.150
     8.186   121.184     0.150
     8.186   209.684     0.150
     9.954   143.652     0.150
     9.954   253.234     0.150
    10.049   145.195     0.150
    10.291   148.812     0.150
    11.234   160.734     0.150
    11.542   164.953     0.150
    12.360   175.305     0.150
    12.778   181.184     0.150
    13.615   191.945     0.150
    14.178   199.262     0.150
    14.207   199.543     0.150
    14.591   204.723     0.150
    15.648   217.543     0.150
    15.855   227.484     0.150
    16.267   226.863     0.150
    16.286   228.562     0.150
    17.920   252.984     0.150
    18.647   260.684     0.150
    18.647   466.684     0.150
    21.514   289.883     0.150
    23.192   309.184     0.150
    23.284   309.984     0.150
    23.540   314.184     0.150
    29.822   368.484     0.150
    36.816   431.785     0.150
    42.655   477.082     0.150
    44.312   491.184     0.150
    45.648   501.082     0.150
    45.648   501.082     0.150
    56.548   583.582     0.150
    58.119   595.082     0.150
    76.454   709.285     0.150
    81.236   737.383     0.150
    82.946   744.684     0.150
    83.420   747.883     0.150
     1.257    23.902     0.150
     1.885    32.402     0.150
     2.368    41.402     0.150
     2.368    70.402     0.150
     2.362    41.102     0.150
     2.673    44.504     0.150
     3.044    47.504     0.150
     6.688   179.402     0.150
     8.046   115.402     0.150
     8.046   201.902     0.150
    21.953   291.102     0.150
    23.511   308.801     0.150
    36.005   419.004     0.150
    36.005     8.598     0.150
    39.040   445.203     0.150
    39.209   446.902     0.150
    44.511     6.801     0.150
    45.654   498.102     0.150
    45.654     6.000     0.150
    45.904   501.801     0.150
    56.235   578.602     0.150
    58.137   597.102     0.150
    75.921   706.301     0.150
    83.358   744.102     0.150
     1.240    23.500     0.150
     1.935    36.199     0.150
     2.209    40.000     0.150
     2.327    42.500     0.150
     2.327    72.898     0.150
     2.320    42.098     0.150
     3.083    51.098     0.150
     3.083    88.898     0.150
     6.556   177.098     0.150
     8.864   132.500     0.150
     8.864   233.898     0.150
     9.311   136.898     0.150
     9.311   251.898     0.150
     9.916   142.707     0.150
    10.002   143.328     0.150
    10.259   147.867     0.150
    10.521   154.898     0.150
    11.184   158.590     0.150
    11.508   163.809     0.150
    12.388   175.898     0.150
    12.953   183.180     0.150
    13.594   191.438     0.150
    14.155   198.977     0.150
    14.189   199.020     0.150
    14.402   202.277     0.150
    14.581   203.977     0.150
    14.945   208.738     0.150
    15.671   224.898     0.150
    15.628   217.320     0.150
    16.129   227.699     0.150
    16.265   225.578     0.150
    16.272   226.359     0.150
    18.429   256.898     0.150
    18.429   253.398     0.150
    19.357   266.898     0.150
    19.357   482.898     0.150
    20.389   277.898     0.150
    20.389   492.398     0.150
    21.701   292.598     0.150
    21.760   291.098     0.150
    21.760   529.699     0.150
    21.826   292.898     0.150
    22.139   294.898     0.150
    22.407   300.898     0.150
    22.407   326.898     0.150
    23.299   308.898     0.150
    23.342   310.098     0.150
    23.462   309.898     0.150
    23.538   312.898     0.150
    23.747   314.500     0.150
    23.747   537.297     0.150
    27.056   344.398     0.150
    27.729   350.898     0.150
    28.007   352.898     0.150
    28.532   356.898     0.150
    28.532   546.898     0.150
    29.801   367.297     0.150
    29.801   552.000     0.150
    30.165   371.000     0.150
    30.165   552.199     0.150
    31.296   381.398     0.150
    33.697   402.199     0.150
    35.185   414.699     0.150
    35.888   568.398     0.150
    36.326   425.699     0.150
    36.326   569.297     0.150
    36.326   425.898     0.150
    37.076   429.898     0.150
    37.120   430.297     0.150
    37.120   571.098     0.150
    38.697   445.297     0.150
    38.697   575.898     0.150
    38.995   446.398     0.150
    39.162   447.898     0.150
    39.298   449.000     0.150
    39.545   453.898     0.150
    42.458   475.500     0.150
    42.482   475.398     0.150
    42.882   478.398     0.150
    43.878   488.797     0.150
    43.878   594.098     0.150
    44.475   491.598     0.150
    45.423   497.879     0.150
    45.423     1.031     0.150
    45.451   501.797     0.150
    45.451     4.602     0.150
    45.792   502.199     0.150
    45.792   599.898     0.150
    45.815   501.297     0.150
    45.815   501.500     0.150
    45.815   600.398     0.150
    46.681   604.000     0.150
    48.816   526.000     0.150
    48.980   527.898     0.150
    48.990   527.898     0.150
    49.112   528.098     0.150
    49.236   529.797     0.150
    49.365   529.898     0.150
    49.571   531.000     0.150
    49.923   535.199     0.150
    50.549   539.598     0.150
    50.751   540.797     0.150
    51.051   542.898     0.150
    52.339   553.199     0.150
    52.624   554.898     0.150
    52.974   557.699     0.150
    53.248   559.699     0.150
    53.537   560.500     0.150
    53.958   563.898     0.150
    53.960   564.598     0.150
    53.960   629.398     0.150
    54.030   564.797     0.150
    54.701   570.297     0.150
    56.345   581.199     0.150
    69.507   665.699     0.150
    73.353   691.160     0.150
    74.097   695.398     0.150
    74.325   696.699     0.150
    74.402   698.070     0.150
    74.474   698.348     0.150
    74.713   699.750     0.150
    75.904   706.398     0.150
    76.459   708.527     0.150
    76.764   710.398     0.150
    78.798   721.898     0.150
    81.182   735.598     0.150
    81.182  1853.199     0.150
    81.191   736.000     0.150
    83.349   747.098     0.150
    83.350   747.398     0.150
    83.350  1847.699     0.150
    83.240   745.398     0.150
    83.240   936.598     0.150
    83.813   749.199     0.150
    84.503   753.098     0.150
    85.344   756.500     0.150
    89.963   779.297     0.150
    90.837   783.199     0.150
    93.834   796.898     0.150
    94.770   801.797     0.150
    95.594   809.000     0.150
   103.094  1099.199     0.150
   138.925  1170.598     0.150
   148.843  1189.000     0.150
     1.236    23.734     0.150
     1.236    41.234     0.150
     2.354    42.434     0.150
     2.354    72.934     0.150
     2.348    42.934     0.150
     2.621    46.734     0.150
     3.003    50.234     0.150
     3.973   112.734     0.150
     4.056    64.234     0.150
     4.056   123.234     0.150
     4.927    73.734     0.150
     4.927   130.134     0.150
     5.440    81.434     0.150
     5.440   138.434     0.150
     6.092    91.134     0.150
     6.092   160.134     0.150
     6.426    97.234     0.150
     6.426   169.234     0.150
     8.012   116.734     0.150
     8.012   201.734     0.150
     8.253   121.634     0.150
     8.253   215.034     0.150
     9.271   136.234     0.150
     9.918   142.224     0.150
     9.999   143.164     0.150
    10.265   147.664     0.150
    11.090   278.364     0.150
    11.179   159.144     0.150
    11.512   163.224     0.150
    12.322   173.684     0.150
    12.596   177.784     0.150
    12.596   313.394     0.150
    12.763   180.164     0.150
    12.954   182.884     0.150
    13.604   191.404     0.150
    14.201   199.284     0.150
    14.412   201.804     0.150
    14.598   203.904     0.150
    14.961   208.764     0.150
    15.639   216.664     0.150
    16.285   225.784     0.150
    16.287   226.484     0.150
    16.293   232.234     0.150
    18.321   257.734     0.150
    20.413   278.234     0.150
    22.002   294.134     0.150
    23.560   310.464     0.150
    23.879   316.034     0.150
    29.809   664.834     0.150
    31.368   381.034     0.150
    39.083   446.634     0.150
    39.252   448.334     0.150
    39.381   449.534     0.150
    45.894   501.634     0.150
    45.894   502.434     0.150
    48.861   526.134     0.150
    48.997   527.734     0.150
    49.007   527.734     0.150
    50.643   539.234     0.150
    50.773   540.734     0.150
    50.919   541.634     0.150
    51.075   542.934     0.150
    51.950   549.734     0.150
    56.216   579.734     0.150
    58.161   594.234     0.150
    75.880   706.834     0.150
    76.937   710.934     0.150
    81.171   735.334     0.150
    83.330   746.734     0.150
    83.400   746.034     0.150
     1.541    27.945     0.150
     2.177    37.047     0.150
     2.354    39.445     0.150
     2.626    44.844     0.150
     2.626    82.844     0.150
     4.062   120.945     0.150
     4.268    66.445     0.150
     4.268   115.445     0.150
     4.325    66.445     0.150
     5.010    76.945     0.150
     5.010   138.047     0.150
     5.151    77.844     0.150
     5.151   138.844     0.150
     5.222    77.242     0.150
     5.222   139.148     0.150
     5.740    86.445     0.150
     5.740   176.445     0.150
     6.038   156.445     0.150
     6.394    94.344     0.150
     6.394   166.945     0.150
     6.733    98.445     0.150
     6.733   174.445     0.150
     6.653   178.047     0.150
     7.817   114.945     0.150
     7.817   201.945     0.150
     8.343   119.445     0.150
     8.343   209.945     0.150
     8.587   124.547     0.150
     8.587   216.445     0.150
     8.932   127.617     0.150
     8.932   226.602     0.150
     8.856   130.445     0.150
     8.856   227.445     0.150
     9.007   131.445     0.150
     9.800   142.445     0.150
     9.800   250.445     0.150
    10.220   145.086     0.150
    10.305   146.242     0.150
    10.564   150.367     0.150
    11.344   158.398     0.150
    11.344   279.914     0.150
    11.344   285.062     0.150
    11.487   162.125     0.150
    11.813   166.766     0.150
    12.930   180.297     0.150
    12.930   320.992     0.150
    13.059   182.906     0.150
    13.059   321.766     0.150
    13.257   185.008     0.150
    13.899   193.883     0.150
    14.460   200.766     0.150
    14.495   200.805     0.150
    14.707   203.422     0.150
    14.887   205.883     0.150
    15.251   211.102     0.150
    15.934   218.828     0.150
    16.336   228.945     0.150
    16.578   228.688     0.150
    18.281   252.445     0.150
    18.651   253.445     0.150
    18.651   452.445     0.150
    20.452   276.945     0.150
    20.695   279.445     0.150
    20.695   502.445     0.150
    21.835   290.047     0.150
    21.835   534.648     0.150
    22.104   298.445     0.150
    22.104   317.445     0.150
    22.129   292.445     0.150
    23.165   338.648     0.150
    23.237   306.445     0.150
    23.245   305.344     0.150
    23.975   314.742     0.150
    28.661   356.242     0.150
    29.352   363.234     0.150
    30.106   369.547     0.150
    30.324   371.203     0.150
    31.032   376.047     0.150
    31.032    11.406     0.150
    31.032   686.445     0.150
    31.032    12.102     0.150
    35.830   417.359     0.150
    37.188   430.469     0.150
    38.854   444.648     0.150
    38.747   441.969     0.150
    38.918   443.945     0.150
    39.006   443.945     0.150
    39.045   444.242     0.150
    42.674   474.609     0.150
    43.583   481.719     0.150
    43.583   589.172     0.150
    45.158   496.844     0.150
    45.558   496.648     0.150
    45.558   496.945     0.150
    46.017   503.344     0.150
    46.017   598.094     0.150
    46.077   502.453     0.150
    47.116   510.328     0.150
    47.659   514.844     0.150
    47.867   518.148     0.150
    48.126   518.633     0.150
    48.455   520.992     0.150
    48.680   522.945     0.150
    48.690   522.945     0.150
    48.811   524.945     0.150
    48.938   524.742     0.150
    49.135   526.844     0.150
    49.396   528.648     0.150
    49.632   531.242     0.150
    50.248   535.344     0.150
    50.322   535.445     0.150
    50.453   535.945     0.150
    50.754   538.148     0.150
    51.630   545.148     0.150
    52.039   548.344     0.150
    52.323   551.742     0.150
    52.327   551.742     0.150
    52.680   553.148     0.150
    52.948   554.844     0.150
    53.145   556.344     0.150
    53.260   557.906     0.150
    53.260   557.445     0.150
    54.176   563.547     0.150
    54.178   564.469     0.150
    54.337   565.648     0.150
    54.400   566.648     0.150
    54.780   569.242     0.150
    54.806   568.547     0.150
    56.113   576.328     0.150
    56.287   577.445     0.150
    57.854   590.148     0.150
    74.046   694.125     0.150
    75.955   704.656     0.150
    76.732   707.648     0.150
    81.484   735.695     0.150
    83.140   742.844     0.150
    83.647   746.242     0.150
    83.649   746.492     0.150
    83.598   745.891     0.150
    94.616   797.594     0.150
     1.219    22.605     0.150
     2.021    37.805     0.150
     2.245    71.668     0.150
     2.238    40.504     0.150
     2.238    70.504     0.150
     2.376    41.504     0.150
     2.982    50.703     0.150
     3.142    51.703     0.150
     3.895    61.504     0.150
     4.764   141.805     0.150
     4.848    74.805     0.150
     4.848   126.504     0.150
     5.687    87.504     0.150
     5.687   151.504     0.150
     6.376    94.504     0.150
     6.376   170.504     0.150
     6.752   100.504     0.150
     7.469   109.504     0.150
     8.065   118.504     0.150
     8.065   203.703     0.150
     8.435   124.773     0.150
     8.800   127.082     0.150
     8.800   224.453     0.150
     8.650   128.504     0.150
     8.650   227.004     0.150
     9.430   137.504     0.150
     9.430   248.504     0.150
     9.852   141.074     0.150
     9.794   142.504     0.150
     9.945   142.234     0.150
    10.191   146.113     0.150
    11.129   157.453     0.150
    11.436   161.855     0.150
    11.436   283.754     0.150
    11.441   161.734     0.150
    12.465   176.504     0.150
    12.680   178.625     0.150
    12.760   179.254     0.150
    12.760   315.223     0.150
    12.889   181.184     0.150
    13.518   189.266     0.150
    14.080   196.383     0.150
    14.111   196.605     0.150
    14.326   199.426     0.150
    14.497   201.844     0.150
    14.862   206.445     0.150
    15.551   214.543     0.150
    15.819   219.504     0.150
    15.819   407.004     0.150
    15.894   221.504     0.150
    15.894   229.004     0.150
    16.306   230.004     0.150
    16.306   420.504     0.150
    16.976   235.504     0.150
    17.556   243.504     0.150
    17.849   249.004     0.150
    18.517   254.504     0.150
    18.517   461.504     0.150
    19.130   475.504     0.150
    19.498   483.184     0.150
    19.547   271.504     0.150
    20.028   279.504     0.150
    20.226   276.004     0.150
    20.295   275.504     0.150
    20.295   495.504     0.150
    20.746   285.504     0.150
    20.746   297.504     0.150
    21.417   290.723     0.150
    21.606   289.242     0.150
    21.940   297.312     0.150
    21.940   297.824     0.150
    23.218   306.504     0.150
    23.218   558.504     0.150
    23.347   308.504     0.150
    23.347   333.504     0.150
    23.321   307.305     0.150
    23.535   310.805     0.150
    23.588   313.203     0.150
    23.627   310.004     0.150
    26.859   342.004     0.150
    27.493   347.605     0.150
    27.838   349.504     0.150
    28.296   353.902     0.150
    28.322   350.504     0.150
    28.998   360.664     0.150
    29.128   361.504     0.150
    29.576   365.504     0.150
    29.726   366.555     0.150
    31.021   676.703     0.150
    31.303   379.004     0.150
    31.265   379.805     0.150
    31.378   382.004     0.150
    31.768   384.305     0.150
    32.541   392.805     0.150
    34.501   410.773     0.150
    34.949   413.004     0.150
    35.283   418.973     0.150
    35.600   419.832     0.150
    35.600   419.824     0.150
    36.110   422.895     0.150
    36.110   423.004     0.150
    36.229   423.965     0.150
    36.654   427.504     0.150
    36.841   427.004     0.150
    36.841   769.805     0.150
    36.887   428.902     0.150
    37.444   434.004     0.150
    38.940   444.777     0.150
    39.001   447.504     0.150
    39.102   447.004     0.150
    39.110   447.402     0.150
    39.250   448.004     0.150
    39.578   451.703     0.150
    39.872   453.004     0.150
    40.449   460.004     0.150
    41.458   466.805     0.150
    41.675   468.402     0.150
    41.992   471.703     0.150
    42.060   473.004     0.150
    42.569   475.305     0.150
    42.785   477.055     0.150
    43.014   481.266     0.150
    43.101   480.766     0.150
    43.175   482.266     0.150
    43.281   483.344     0.150
    43.239   480.145     0.150
    43.239     8.961     0.150
    43.313   482.703     0.150
    43.313     5.500     0.150
    43.313   581.504     0.150
    43.562   485.004     0.150
    43.562    12.000     0.150
    43.677   486.715     0.150
    43.678   486.004     0.150
    43.723   486.125     0.150
    43.779   486.684     0.150
    43.907   487.039     0.150
    43.907   592.203     0.150
    43.973   487.004     0.150
    44.003   487.305     0.150
    44.264   489.402     0.150
    44.264    10.102     0.150
    44.326   492.223     0.150
    44.337   490.605     0.150
    44.625   493.383     0.150
    44.679   493.004     0.150
    44.710   495.184     0.150
    44.819   495.844     0.150
    44.821   495.242     0.150
    44.862   497.113     0.150
    44.992   496.004     0.150
    45.009   496.312     0.150
    45.048   496.605     0.150
    45.288   499.383     0.150
    45.300   498.543     0.150
    45.293   499.582     0.150
    45.385   498.613     0.150
    45.351   496.176     0.150
    45.351     8.887     0.150
    45.414   497.004     0.150
    45.475   500.902     0.150
    45.517   497.105     0.150
    45.517   900.504     0.150
    45.553   500.402     0.150
    45.578   500.203     0.150
    45.578   598.305     0.150
    45.567   501.105     0.150
    45.699   502.594     0.150
    45.727   502.812     0.150
    45.756   504.004     0.150
    45.774   500.004     0.150
    45.774   499.953     0.150
    46.197   505.242     0.150
    46.221   504.004     0.150
    46.392   509.504     0.150
    46.503   507.305     0.150
    46.590   508.543     0.150
    46.701   509.152     0.150
    46.719   509.203     0.150
    46.721   509.004     0.150
    46.868   510.203     0.150
    46.969   510.902     0.150
    47.254   512.805     0.150
    47.280   515.043     0.150
    47.309   513.504     0.150
    47.309     9.000     0.150
    47.458   514.203     0.150
    47.473   514.504     0.150
    47.488   514.902     0.150
    47.546   517.043     0.150
    47.568   515.363     0.150
    47.646   516.105     0.150
    47.757   516.605     0.150
    47.768   517.902     0.150
    47.784   517.254     0.150
    47.829   517.145     0.150
    47.849   517.605     0.150
    47.954   519.176     0.150
    48.025   518.402     0.150
    48.026   517.605     0.150
    48.091   519.402     0.150
    48.151   518.895     0.150
    48.163   518.543     0.150
    48.191   520.203     0.150
    48.254   519.984     0.150
    48.265   521.004     0.150
    48.367   521.504     0.150
    48.371   521.902     0.150
    48.464   522.785     0.150
    48.467   522.805     0.150
    48.536   524.234     0.150
    48.559   522.402     0.150
    48.599   524.324     0.150
    48.733   524.605     0.150
    48.735   523.145     0.150
    48.723   524.805     0.150
    48.752   524.715     0.150
    48.767   524.594     0.150
    48.795   523.785     0.150
    48.806   525.133     0.150
    48.869   525.305     0.150
    48.869   525.773     0.150
    48.873   525.695     0.150
    48.865   524.805     0.150
    48.919   526.402     0.150
    48.964   525.312     0.150
    49.025   526.902     0.150
    49.035   526.805     0.150
    49.070   528.305     0.150
    49.109   527.484     0.150
    49.161   527.305     0.150
    49.274   528.605     0.150
    49.492   529.703     0.150
    49.690   532.945     0.150
    49.719   531.402     0.150
    49.723   532.004     0.150
    49.743   530.203     0.150
    49.897   533.305     0.150
    49.919   535.105     0.150
    49.942   533.805     0.150
    50.087   536.203     0.150
    50.169   537.004     0.150
    50.372   538.902     0.150
    50.397   538.703     0.150
    50.483   539.543     0.150
    50.595   538.605     0.150
    50.652   538.402     0.150
    50.787   539.605     0.150
    50.929   540.504     0.150
    51.077   542.402     0.150
    51.087   541.805     0.150
    51.342   544.402     0.150
    51.393   545.504     0.150
    51.476   544.605     0.150
    51.496   546.305     0.150
    51.543   547.004     0.150
    51.965   548.805     0.150
    52.667   554.305     0.150
    52.676   554.105     0.150
    52.999   557.105     0.150
    52.997   555.605     0.150
    53.190   560.004     0.150
    53.193   556.805     0.150
    53.290   558.605     0.150
    53.475   559.203     0.150
    53.521   559.305     0.150
    53.571   560.703     0.150
    53.553   559.582     0.150
    53.741   561.504     0.150
    53.743   561.992     0.150
    53.980   562.703     0.150
    54.082   563.504     0.150
    54.339   567.105     0.150
    54.346   567.203     0.150
    54.683   569.605     0.150
    54.752   569.605     0.150
    55.012   571.902     0.150
    55.096   570.902     0.150
    55.134   571.105     0.150
    56.026   578.504     0.150
    56.074   580.504     0.150
    56.209   581.203     0.150
    56.458   582.105     0.150
    56.555   581.953     0.150
    56.997   587.402     0.150
    57.521   590.504     0.150
    57.881   592.703     0.150
    57.900   592.203     0.150
    58.220   594.355     0.150
    58.220   593.703     0.150
    58.632   597.703     0.150
    58.797   599.605     0.150
    58.962   599.402     0.150
    59.071   599.902     0.150
    59.209   601.004     0.150
    59.280   600.703     0.150
    59.441   603.305     0.150
    59.512   603.902     0.150
    59.600   604.105     0.150
    59.831   605.703     0.150
    60.276   607.703     0.150
    60.306   607.902     0.150
    60.314   610.004     0.150
    60.522   609.902     0.150
    60.681   611.902     0.150
    61.021   612.605     0.150
    61.600   617.504     0.150
    61.815   619.504     0.150
    62.046   622.004     0.150
    62.347   623.805     0.150
    62.469   624.902     0.150
    62.477   624.105     0.150
    62.719   625.305     0.150
    73.258   691.676     0.150
    73.909   695.105     0.150
    74.497   699.465     0.150
    74.646   700.355     0.150
    74.994   700.504     0.150
    75.916   705.504     0.150
    75.764   704.184     0.150
    76.288   708.652     0.150
    76.250   706.633     0.150
    76.556   707.855     0.150
    78.725   719.594     0.150
    80.980   731.574     0.150
    83.064   743.902     0.150
    83.310   745.004     0.150
    83.312   745.754     0.150
    83.312  1846.055     0.150
    83.721   747.754     0.150
    84.500   752.004     0.150
    93.803   795.703     0.150
    94.627   800.027     0.150
    97.420   812.773     0.150
    98.693   818.152     0.150
   117.655  1124.203     0.150
   118.671  1126.504     0.150
   118.671  1128.703     0.150
   118.671  1139.105     0.150
   119.478  1127.805     0.150
   135.004  1159.879     0.150
   139.037  1168.289     0.150
   149.061  1188.715     0.150
     1.201    22.854     0.150
     2.009    37.953     0.150
     2.217    40.754     0.150
     2.217    70.754     0.150
     2.372    42.254     0.150
     2.981    51.652     0.150
     3.128    52.652     0.150
     3.649    59.953     0.150
     3.649   114.652     0.150
     3.875    62.953     0.150
     3.875   121.453     0.150
     4.612    73.254     0.150
     4.828    75.453     0.150
     4.828   132.053     0.150
     5.354   164.453     0.150
     6.008    89.953     0.150
     6.008   157.953     0.150
     6.356   171.453     0.150
     7.450   111.953     0.150
     8.048   118.453     0.150
     8.048   204.453     0.150
     7.761   117.703     0.150
     8.308   123.152     0.150
     8.308   212.354     0.150
     8.433   126.283     0.150
     8.648   129.053     0.150
     9.496   137.453     0.150
     9.832   141.623     0.150
     9.925   142.604     0.150
     9.790   142.453     0.150
    10.171   146.344     0.150
    10.630   158.453     0.150
    11.109   158.203     0.150
    11.421   162.303     0.150
    11.433   162.242     0.150
    11.433   281.643     0.150
    11.433   292.504     0.150
    11.433   292.973     0.150
    12.660   178.664     0.150
    12.746   179.844     0.150
    12.746   315.242     0.150
    13.497   189.303     0.150
    14.060   196.863     0.150
    14.091   196.883     0.150
    14.305   199.803     0.150
    14.842   207.184     0.150
    15.531   215.303     0.150
    16.155   223.303     0.150
    17.548   436.453     0.150
    17.829   248.053     0.150
    18.504   258.453     0.150
    18.504   449.453     0.150
    20.274   275.953     0.150
    21.437   288.643     0.150
    21.603   289.254     0.150
    21.922   292.652     0.150
    23.227   308.254     0.150
    23.227   561.453     0.150
    23.517   311.453     0.150
    23.332   308.453     0.150
    23.332   337.453     0.150
    23.608   315.553     0.150
    27.483   348.754     0.150
    29.705   366.854     0.150
    29.919   369.113     0.150
    29.947   369.443     0.150
    31.282   380.953     0.150
    36.833   428.453     0.150
    38.955   446.229     0.150
    39.122   447.152     0.150
    39.122   800.453     0.150
    42.797   478.178     0.150
    43.927   488.395     0.150
    45.561   500.982     0.150
    45.494   501.754     0.150
    45.494   501.754     0.150
    45.790   501.152     0.150
    45.790   501.428     0.150
    46.311   506.453     0.150
    48.578   523.652     0.150
    48.780   525.953     0.150
    48.868   528.152     0.150
    48.889   526.553     0.150
    48.960   527.652     0.150
    48.990   528.152     0.150
    49.045   528.254     0.150
    49.054   528.152     0.150
    49.082   528.553     0.150
    49.181   528.453     0.150
    49.299   530.254     0.150
    49.294   529.754     0.150
    49.512   530.953     0.150
    49.763   532.953     0.150
    49.938   537.854     0.150
    49.961   534.854     0.150
    50.107   536.553     0.150
    50.392   538.754     0.150
    50.417   538.553     0.150
    50.503   539.152     0.150
    50.671   539.254     0.150
    50.807   540.854     0.150
    50.948   541.652     0.150
    51.097   547.053     0.150
    51.106   542.953     0.150
    51.496   545.854     0.150
    51.516   547.354     0.150
    51.984   550.053     0.150
    52.519   553.213     0.150
    52.687   555.453     0.150
    52.696   555.254     0.150
    53.016   556.652     0.150
    53.210   560.844     0.150
    53.212   558.053     0.150
    53.310   559.854     0.150
    53.540   560.553     0.150
    54.102   564.553     0.150
    54.359   568.232     0.150
    54.672   569.053     0.150
    54.703   570.684     0.150
    54.772   570.652     0.150
    55.115   572.152     0.150
    55.153   572.254     0.150
    56.229   580.543     0.150
    56.573   583.283     0.150
    57.541   592.312     0.150
    57.901   594.594     0.150
    58.240   595.652     0.150
    58.240   594.982     0.150
    59.620   606.402     0.150
    73.268   692.383     0.150
    74.517   699.447     0.150
    74.973   701.354     0.150
    76.297   709.312     0.150
    76.249   707.793     0.150
    76.556   708.504     0.150
    83.290   746.652     0.150
    83.292   746.703     0.150
    83.068   744.799     0.150
    83.734   748.877     0.150
   135.024  1160.113     0.150
   149.077  1188.477     0.150
     1.199    22.830     0.150
     2.200    40.330     0.150
     3.140    51.830     0.150
     3.629    58.930     0.150
     3.629   113.529     0.150
     4.595    72.830     0.150
     6.343    94.330     0.150
     6.343   167.330     0.150
     8.047   204.330     0.150
     8.309   205.930     0.150
    15.831   222.330     0.150
    15.831   401.330     0.150
    16.325   234.330     0.150
    16.985   238.330     0.150
    17.798   248.730     0.150
    18.521   258.330     0.150
    20.216   277.830     0.150
    21.459   291.010     0.150
    21.877   291.330     0.150
    23.204   306.830     0.150
    23.311   307.330     0.150
    23.311   336.330     0.150
    23.471   311.330     0.150
    23.622   312.131     0.150
    29.686   771.230     0.150
    29.868   367.750     0.150
    29.970   370.141     0.150
    31.242   379.330     0.150
    36.783   427.830     0.150
    38.946   445.654     0.150
    39.103   446.529     0.150
    42.779   477.256     0.150
    43.704   486.029     0.150
    43.936   487.131     0.150
    44.289   489.330     0.150
    45.514   500.170     0.150
    45.503   501.430     0.150
    45.502   501.430     0.150
    45.784   500.779     0.150
    46.261   506.131     0.150
    48.588   523.529     0.150
    48.904   526.430     0.150
    49.057   528.029     0.150
    49.067   528.029     0.150
    49.194   528.230     0.150
    49.220   528.312     0.150
    49.305   529.631     0.150
    49.527   530.830     0.150
    49.570   532.029     0.150
    49.754   532.631     0.150
    49.776   532.230     0.150
    50.681   539.131     0.150
    50.818   540.730     0.150
    50.958   541.529     0.150
    51.117   542.830     0.150
    51.495   546.131     0.150
    51.507   545.730     0.150
    51.996   549.830     0.150
    52.699   554.631     0.150
    52.710   555.131     0.150
    53.025   556.529     0.150
    53.220   557.930     0.150
    53.322   559.730     0.150
    53.548   560.430     0.150
    54.116   564.330     0.150
    54.681   568.930     0.150
    54.786   570.529     0.150
    55.123   571.930     0.150
    55.162   572.131     0.150
    56.619   582.760     0.150
    58.256   594.830     0.150
    58.256   594.641     0.150
    73.319   692.480     0.150
    74.556   699.924     0.150
    76.207   707.051     0.150
    76.348   709.203     0.150
    76.513   708.480     0.150
    83.032   744.275     0.150
    83.281   746.080     0.150
    83.717   748.150     0.150
   135.064  1159.691     0.150
   149.125  1189.504     0.150
     1.140    21.383     0.150
     1.140    38.383     0.150
     1.647    30.383     0.150
     1.838    33.086     0.150
     2.275    40.383     0.150
     2.405    41.586     0.150
     2.815    46.086     0.150
     3.535    58.984     0.150
     3.535   105.484     0.150
     3.872   110.984     0.150
     4.999    77.984     0.150
     4.999   138.984     0.150
     5.606    85.086     0.150
     5.606   146.383     0.150
     6.949   176.172     0.150
     7.108   103.797     0.150
     7.108   182.336     0.150
     7.515   107.758     0.150
     7.515   192.031     0.150
     7.847   112.984     0.150
     7.847   198.984     0.150
     7.937   115.414     0.150
     8.384   122.531     0.150
     8.394   120.984     0.150
     8.350   123.953     0.150
     8.650   128.352     0.150
     8.739   129.461     0.150
     8.874   130.586     0.150
     8.957   130.961     0.150
     8.957   232.219     0.150
     8.957   285.523     0.150
     8.957   130.883     0.150
     9.026   133.031     0.150
     9.348   133.328     0.150
     9.348   234.852     0.150
     9.170   135.688     0.150
     9.241   137.984     0.150
     9.241   242.984     0.150
     9.431   138.844     0.150
     9.609   141.141     0.150
     9.617   141.555     0.150
    12.395   174.641     0.150
    12.395   308.336     0.150
    12.395   311.523     0.150
    12.395   311.781     0.150
    12.654   178.484     0.150
    12.837   180.781     0.150
    12.837   318.984     0.150
    13.120   182.984     0.150
    13.497   189.086     0.150
    13.497   334.188     0.150
    13.680   191.211     0.150
    14.096   196.586     0.150
    14.096   345.984     0.150
    14.305   199.586     0.150
    14.305   352.281     0.150
    14.859   206.883     0.150
    14.859   366.188     0.150
    14.939   204.336     0.150
    15.444   217.242     0.150
    15.444   219.508     0.150
    15.444   219.086     0.150
    15.690   216.281     0.150
    15.811   217.984     0.150
    15.811   231.484     0.150
    17.063   237.086     0.150
    17.063   440.281     0.150
    17.046   236.898     0.150
    17.581   246.328     0.150
    17.581   242.945     0.150
    17.982   249.883     0.150
    17.982   450.883     0.150
    17.982   248.906     0.150
    18.112   248.984     0.150
    18.112   443.484     0.150
    18.792   259.297     0.150
    18.792   277.992     0.150
    18.792   458.711     0.150
    19.038   262.258     0.150
    19.038   470.805     0.150
    18.886   261.148     0.150
    18.886   472.070     0.150
    18.920   260.320     0.150
    19.538   268.891     0.150
    19.538   267.273     0.150
    19.538   268.281     0.150
    19.928   506.086     0.150
    20.320   274.984     0.150
    20.320   495.984     0.150
    20.180   275.711     0.150
    20.180   275.492     0.150
    20.298   277.523     0.150
    20.298   276.461     0.150
    20.440   277.242     0.150
    20.440   277.477     0.150
    21.424   290.516     0.150
    21.694   292.586     0.150
    22.515   298.781     0.150
    22.515   541.383     0.150
    22.542   301.984     0.150
    22.542   534.984     0.150
    22.542   544.984     0.150
    23.694   311.688     0.150
    23.694   567.984     0.150
    23.939   316.086     0.150
    23.688   312.188     0.150
    23.688   341.188     0.150
    23.688   564.883     0.150
    23.688   605.688     0.150
    23.778   311.531     0.150
    23.778   311.086     0.150
    23.778   562.984     0.150
    23.755   312.984     0.150
    25.591   329.992     0.150
    26.106   333.625     0.150
    26.821   339.547     0.150
    27.203   345.484     0.150
    27.049   343.586     0.150
    27.049   607.984     0.150
    28.084   352.586     0.150
    28.110   352.055     0.150
    28.300   354.781     0.150
    28.414   354.688     0.150
    28.414   547.281     0.150
    28.414   634.188     0.150
    28.414   719.688     0.150
    28.838   359.383     0.150
    29.257   362.984     0.150
    29.257   421.883     0.150
    29.257   656.883     0.150
    29.187   362.719     0.150
    29.301   363.633     0.150
    29.959   369.484     0.150
    30.444   372.422     0.150
    31.624   382.984     0.150
    31.555   382.781     0.150
    31.555   453.281     0.150
    31.555   554.484     0.150
    31.555   692.984     0.150
    31.555   806.984     0.150
    32.966   396.984     0.150
    33.836   402.984     0.150
    35.696   420.984     0.150
    36.528   426.266     0.150
    36.529   426.984     0.150
    36.529   759.188     0.150
    36.940   429.688     0.150
    37.414   432.984     0.150
    38.181   441.188     0.150
    38.978   446.664     0.150
    38.937   448.688     0.150
    39.281   448.461     0.150
    39.452   450.781     0.150
    39.729   453.781     0.150
    40.194   456.188     0.150
    40.194   807.984     0.150
    40.194   817.984     0.150
    40.194   989.984     0.150
    39.939   455.484     0.150
    40.103   455.781     0.150
    41.003   465.281     0.150
    41.151   465.688     0.150
    41.536   468.406     0.150
    41.594   469.484     0.150
    41.695   470.781     0.150
    41.813   471.586     0.150
    42.378   476.586     0.150
    42.378   851.883     0.150
    42.336   475.188     0.150
    42.367   475.188     0.150
    42.538   477.281     0.150
    43.035   478.086     0.150
    42.907   479.883     0.150
    43.041   481.305     0.150
    43.211   481.438     0.150
    43.211   481.375     0.150
    43.220   482.406     0.150
    43.479   484.281     0.150
    43.657   484.586     0.150
    43.670   486.328     0.150
    43.727   485.781     0.150
    43.766   486.547     0.150
    43.766   489.117     0.150
    43.857   487.484     0.150
    43.857   595.281     0.150
    44.057   488.898     0.150
    44.057   591.969     0.150
    44.127   488.586     0.150
    44.358   491.086     0.150
    44.448   491.484     0.150
    44.451   491.883     0.150
    44.822   495.383     0.150
    44.828   494.758     0.150
    45.306   497.227     0.150
    45.339   499.484     0.150
    45.581   499.883     0.150
    45.638   502.086     0.150
    45.637   502.086     0.150
    45.892   499.586     0.150
    45.892   597.086     0.150
    45.892   828.484     0.150
    45.892   895.281     0.150
    45.664   501.594     0.150
    45.727   500.523     0.150
    45.901   504.547     0.150
    45.900   502.484     0.150
    46.097   502.883     0.150
    46.015   505.234     0.150
    46.086   502.984     0.150
    46.086   503.234     0.150
    46.135   506.305     0.150
    46.219   505.992     0.150
    46.838   510.281     0.150
    46.731   509.008     0.150
    46.734   509.383     0.150
    46.774   508.383     0.150
    46.794   509.547     0.150
    46.794   602.477     0.150
    46.845   509.586     0.150
    46.845   602.484     0.150
    47.003   512.844     0.150
    47.211   514.188     0.150
    47.375   514.883     0.150
    47.681   516.055     0.150
    47.706   517.883     0.150
    47.925   518.586     0.150
    47.924   519.883     0.150
    48.089   518.188     0.150
    48.089   518.383     0.150
    48.330   523.086     0.150
    48.340   521.383     0.150
    48.508   523.984     0.150
    48.700   524.383     0.150
    48.919   526.672     0.150
    48.957   525.781     0.150
    49.010   526.688     0.150
    49.136   527.883     0.150
    49.146   528.086     0.150
    49.218   529.188     0.150
    49.262   528.086     0.150
    49.266   529.125     0.150
    49.724   532.445     0.150
    49.717   533.086     0.150
    49.794   533.281     0.150
    50.701   539.586     0.150
    50.790   540.086     0.150
    50.918   541.086     0.150
    51.065   542.281     0.150
    51.220   543.484     0.150
    51.608   546.281     0.150
    52.094   550.383     0.150
    52.495   553.188     0.150
    52.769   554.688     0.150
    53.159   557.688     0.150
    53.357   559.188     0.150
    53.406   559.984     0.150
    53.613   560.984     0.150
    53.634   562.984     0.150
    53.682   561.484     0.150
    54.175   564.688     0.150
    54.409   569.328     0.150
    54.604   568.492     0.150
    54.765   569.883     0.150
    54.816   570.086     0.150
    54.846   570.383     0.150
    55.261   573.086     0.150
    55.294   573.281     0.150
    55.868   575.914     0.150
    56.865   583.781     0.150
    57.930   590.141     0.150
    58.281   593.227     0.150
    58.286   594.547     0.150
    58.286   646.172     0.150
    58.286   593.828     0.150
    58.467   592.836     0.150
    59.108   597.062     0.150
    59.253   599.664     0.150
    59.308   601.992     0.150
    59.319   599.477     0.150
    59.490   602.406     0.150
    59.671   603.711     0.150
    59.882   602.562     0.150
    60.604   611.383     0.150
    60.604   736.484     0.150
    60.694   611.758     0.150
    60.738   612.688     0.150
    60.882   612.281     0.150
    60.761   612.383     0.150
    60.949   609.594     0.150
    61.511   617.688     0.150
    61.633   615.383     0.150
    61.636   618.484     0.150
    61.723   620.883     0.150
    63.582   631.297     0.150
    72.701   688.258     0.150
    73.772   694.086     0.150
    74.246   696.312     0.150
    74.476   696.492     0.150
    74.945   701.086     0.150
    75.724   705.711     0.150
    76.291   708.312     0.150
    76.839   709.906     0.150
    77.145   711.383     0.150
    77.556   714.328     0.150
    78.569   719.867     0.150
    79.299   723.984     0.150
    79.316   724.156     0.150
    79.336   724.156     0.150
    80.552   731.734     0.150
    81.038   734.641     0.150
    81.047   734.836     0.150
    81.047   734.586     0.150
    83.188   746.281     0.150
    83.620   747.328     0.150
    84.136   749.961     0.150
    86.178   761.133     0.150
    89.863   778.281     0.150
   123.934  1136.586     0.150
   129.008  1149.148     0.150
   134.737  1158.562     0.150
   138.966  1168.234     0.150
     1.159    21.992     0.150
     1.159    39.992     0.150
     1.656    31.391     0.150
     1.835    34.094     0.150
     2.294    41.297     0.150
     2.397    42.492     0.150
     2.825    46.797     0.150
     8.962   132.086     0.150
     8.962   233.453     0.150
     8.962   285.633     0.150
     8.962   132.195     0.150
    12.672   179.391     0.150
    12.853   181.797     0.150
    13.514   190.094     0.150
    14.113   197.391     0.150
    14.322   200.695     0.150
    14.877   207.992     0.150
    14.877   365.992     0.150
    15.459   223.094     0.150
    15.459   219.070     0.150
    15.459   218.695     0.150
    17.592   247.102     0.150
    17.592   246.875     0.150
    18.001   248.797     0.150
    18.001   251.047     0.150
    18.891   261.406     0.150
    18.924   260.797     0.150
    19.543   268.352     0.150
    19.543   268.023     0.150
    21.407   288.750     0.150
    23.961   316.992     0.150
    23.777   311.617     0.150
    39.274   448.570     0.150
    39.446   451.297     0.150
    43.208   481.422     0.150
    44.043   489.258     0.150
    46.078   504.195     0.150
    46.078   504.117     0.150
    46.984   513.578     0.150
    58.270   595.203     0.150
    76.299   708.945     0.150
    76.299   708.531     0.150
    76.849   711.695     0.150
    77.155   712.641     0.150
    81.054   734.555     0.150
    83.202   746.797     0.150
    83.626   748.086     0.150
   134.716  1159.617     0.150
     1.346    25.809     0.150
     1.993    37.908     0.150
     2.215    41.708     0.150
     2.438    44.008     0.150
     2.767    49.508     0.150
     3.151    52.908     0.150
     3.151    91.908     0.150
     4.818   134.809     0.150
     4.961    77.908     0.150
     6.200    94.708     0.150
     7.145   107.688     0.150
     7.145   189.038     0.150
     7.418   109.898     0.150
     7.851   115.309     0.150
     7.851   200.078     0.150
     7.980   117.889     0.150
     8.148   118.908     0.150
     8.148   206.408     0.150
     8.013   121.038     0.150
     8.146   119.858     0.150
     8.146   209.048     0.150
     8.243   121.468     0.150
     8.243   210.678     0.150
     8.393   213.068     0.150
     8.393   219.559     0.150
     8.393   219.738     0.150
     8.324   125.368     0.150
     8.426   126.718     0.150
     8.534   128.208     0.150
     8.758   127.908     0.150
     8.758   223.908     0.150
     8.696   130.354     0.150
     8.696   229.933     0.150
     8.696   130.678     0.150
     8.696   129.008     0.150
     8.847   132.658     0.150
     9.102   135.889     0.150
     9.293   138.508     0.150
     9.283   138.008     0.150
     9.606   140.908     0.150
     9.606   244.608     0.150
     9.682   141.608     0.150
     9.682   249.208     0.150
     9.661   246.269     0.150
    12.749   181.428     0.150
    12.749   318.298     0.150
    13.063   185.608     0.150
    13.707   193.708     0.150
    14.268   201.008     0.150
    14.303   200.708     0.150
    14.515   203.608     0.150
    15.061   210.908     0.150
    15.163   214.108     0.150
    15.163   214.108     0.150
    16.007   222.328     0.150
    16.188   227.908     0.150
    16.230   228.908     0.150
    16.230   404.908     0.150
    17.246   244.004     0.150
    18.106   252.309     0.150
    18.106   252.708     0.150
    18.477   259.908     0.150
    18.477   452.408     0.150
    18.513   257.945     0.150
    18.513   464.286     0.150
    18.547   258.508     0.150
    19.166   265.355     0.150
    19.166   483.306     0.150
    19.166   264.809     0.150
    20.507   276.908     0.150
    20.507   504.908     0.150
    21.216   290.809     0.150
    21.216   291.206     0.150
    21.881   293.908     0.150
    22.187   296.708     0.150
    22.187   535.208     0.150
    23.433   310.908     0.150
    23.869   316.708     0.150
    25.457   329.108     0.150
    25.457   368.508     0.150
    25.457   592.908     0.150
    25.457   654.208     0.150
    26.026   337.108     0.150
    27.182   346.408     0.150
    27.819   352.309     0.150
    28.628   358.908     0.150
    29.327   364.988     0.150
    29.831   369.212     0.150
    29.831   551.908     0.150
    29.914   370.008     0.150
    29.717   369.809     0.150
    32.043   388.508     0.150
    33.919   405.208     0.150
    35.444   421.008     0.150
    37.158   429.908     0.150
    38.931   447.508     0.150
    42.909   479.508     0.150
    42.841   479.408     0.150
    43.780   594.708     0.150
    45.746   502.108     0.150
    45.746   502.408     0.150
    47.200   516.908     0.150
    47.766   518.008     0.150
    47.854   519.108     0.150
    48.063   521.108     0.150
    48.427   523.508     0.150
    48.877   527.708     0.150
    48.886   527.508     0.150
    49.007   527.309     0.150
    49.592   532.408     0.150
    50.650   540.708     0.150
    50.950   543.008     0.150
    51.339   546.008     0.150
    52.236   553.008     0.150
    53.925   565.508     0.150
    54.595   570.008     0.150
    58.049   595.521     0.150
    75.173   703.708     0.150
    75.933   707.008     0.150
    75.933   707.383     0.150
    76.499   710.408     0.150
    76.804   711.908     0.150
    78.952   723.618     0.150
    81.288   737.809     0.150
    81.297   737.508     0.150
    81.297   737.208     0.150
    83.251   747.208     0.150
    83.451   748.809     0.150
    83.452   748.958     0.150
    83.768   750.583     0.150
   148.724  1190.408     0.150
     1.275    23.262     0.150
     2.182    36.762     0.150
     2.367    41.062     0.150
     2.748    44.762     0.150
     3.092    48.762     0.150
     4.747    72.465     0.150
     5.151    79.363     0.150
     6.129    90.363     0.150
     6.129   155.762     0.150
     6.467   164.812     0.150
     7.074   104.152     0.150
     7.074   184.164     0.150
     7.790   111.133     0.150
     7.790   193.535     0.150
     8.082   114.863     0.150
     8.082   116.215     0.150
     8.082   202.363     0.150
     8.019   118.492     0.150
     8.178   117.203     0.150
     8.178   204.754     0.150
     8.328   209.152     0.150
     8.325   122.852     0.150
     8.423   123.805     0.150
     8.541   125.504     0.150
     8.706   123.363     0.150
     8.611   125.262     0.150
     8.611   223.359     0.150
     8.611   125.262     0.150
     8.611   223.262     0.150
     8.699   127.934     0.150
     8.699   127.621     0.150
     8.699   225.117     0.150
     8.847   130.363     0.150
     8.914   130.863     0.150
     8.914   226.363     0.150
     8.931   131.145     0.150
     9.104   133.242     0.150
     9.287   135.254     0.150
     9.290   135.875     0.150
     9.612   137.863     0.150
    11.215   156.922     0.150
    11.317   158.363     0.150
    12.694   176.703     0.150
    12.694   309.293     0.150
    12.992   182.164     0.150
    13.636   190.062     0.150
    14.197   197.562     0.150
    14.232   198.062     0.150
    14.444   200.363     0.150
    14.853   207.484     0.150
    15.232   210.262     0.150
    15.150   211.762     0.150
    15.150   212.988     0.150
    16.196   224.762     0.150
    16.196   234.465     0.150
    16.196   401.664     0.150
    16.196   521.965     0.150
    16.732   231.305     0.150
    16.732   413.828     0.150
    16.732   409.465     0.150
    18.036   250.262     0.150
    18.239   249.973     0.150
    18.426   250.363     0.150
    18.426   254.363     0.150
    18.426   456.363     0.150
    18.426   480.363     0.150
    18.500   253.223     0.150
    18.500   455.363     0.150
    18.500   253.484     0.150
    18.540   253.430     0.150
    18.540   460.312     0.150
    18.540   254.023     0.150
    21.287   287.262     0.150
    21.287   287.574     0.150
    21.533   287.363     0.150
    21.879   290.914     0.150
    22.189   292.562     0.150
    22.369   297.863     0.150
    23.358   307.363     0.150
    23.447   307.262     0.150
    23.447   332.363     0.150
    23.447   550.164     0.150
    23.447   307.645     0.150
    23.503   308.363     0.150
    23.503   307.812     0.150
    23.556   308.164     0.150
    23.816   313.164     0.150
    23.816   535.164     0.150
    26.097   331.863     0.150
    28.174   352.375     0.150
    28.598   355.965     0.150
    29.300   362.465     0.150
    29.788   365.762     0.150
    29.788   365.512     0.150
    29.794   365.562     0.150
    30.233   370.164     0.150
    31.283   377.863     0.150
    31.283   377.992     0.150
    31.975   384.164     0.150
    33.986   400.715     0.150
    35.514   416.863     0.150
    37.242   429.016     0.150
    37.579   431.863     0.150
    38.989   443.965     0.150
    38.989   443.715     0.150
    39.157   444.965     0.150
    42.559   472.664     0.150
    42.864   476.664     0.150
    42.889   476.012     0.150
    42.889   475.691     0.150
    43.634   484.465     0.150
    43.848   484.328     0.150
    43.848   590.750     0.150
    44.223   487.363     0.150
    44.464   488.332     0.150
    45.118     8.000     0.150
    45.118   593.363     0.150
    45.423   498.363     0.150
    45.423     6.801     0.150
    45.422   498.363     0.150
    45.422     6.801     0.150
    45.711   496.363     0.150
    45.805   498.762     0.150
    45.805   498.215     0.150
    45.811   499.062     0.150
    46.598   506.070     0.150
    46.598   600.512     0.150
    47.924   516.164     0.150
    48.132   518.664     0.150
    48.496   521.062     0.150
    48.779   523.164     0.150
    48.804   523.363     0.150
    48.946   525.062     0.150
    48.956   525.062     0.150
    49.077   525.262     0.150
    49.080   525.465     0.150
    49.204   527.062     0.150
    49.497   529.562     0.150
    49.584   529.965     0.150
    49.662   529.762     0.150
    49.896   532.562     0.150
    50.071   533.164     0.150
    50.514   536.562     0.150
    50.587   537.262     0.150
    50.719   538.164     0.150
    51.019   540.262     0.150
    51.256   542.262     0.150
    51.402   543.562     0.150
    51.408   543.164     0.150
    51.896   547.262     0.150
    52.305   550.465     0.150
    52.588   552.062     0.150
    52.592   552.562     0.150
    52.945   554.262     0.150
    53.142   555.562     0.150
    53.214   557.062     0.150
    53.410   557.664     0.150
    53.468   557.965     0.150
    53.518   557.414     0.150
    53.518   625.414     0.150
    53.995   562.062     0.150
    54.029   562.789     0.150
    54.601   566.562     0.150
    54.665   567.562     0.150
    55.045   569.562     0.150
    58.119   591.301     0.150
    62.862   624.074     0.150
    67.699   655.539     0.150
    72.958   687.664     0.150
    72.958   689.715     0.150
    73.408   691.023     0.150
    74.262   695.812     0.150
    75.949   703.562     0.150
    75.949   703.844     0.150
    76.811   707.812     0.150
    80.733   730.152     0.150
    81.218   733.746     0.150
    83.275   743.207     0.150
    83.818   746.539     0.150
    85.838   756.789     0.150
    90.006   777.215     0.150
    92.595   789.062     0.150
   118.401  1124.262     0.150
   119.208  1125.465     0.150
   133.034  1154.102     0.150
   145.533  1177.688     0.150
   148.774  1186.340     0.150
     1.205    22.957     0.150
     2.115    39.758     0.150
     2.115    39.758     0.150
     2.569    46.559     0.150
     3.208    55.258     0.150
     4.505    72.859     0.150
     4.505   139.059     0.150
     5.588    89.258     0.150
     5.588   152.156     0.150
     5.911    90.457     0.150
     6.805   102.906     0.150
     6.805   174.109     0.150
     7.528   114.977     0.150
     7.841   115.199     0.150
     7.841   199.336     0.150
     7.812   118.496     0.150
     7.888   118.977     0.150
     7.912   117.977     0.150
     8.029   117.258     0.150
     8.029   204.258     0.150
     8.092   119.328     0.150
     8.055   122.398     0.150
     8.139   120.969     0.150
     8.192   123.738     0.150
     8.192   123.555     0.150
     8.192   214.949     0.150
     8.302   122.809     0.150
     8.302   209.777     0.150
     8.249   123.406     0.150
     8.249   215.027     0.150
     8.249   123.359     0.150
     8.249   214.957     0.150
     8.359   122.430     0.150
     8.359   212.336     0.150
     8.328   127.180     0.150
     8.380   125.836     0.150
     8.406   127.059     0.150
     8.406   224.258     0.150
     8.595   129.148     0.150
     8.760   130.836     0.150
     8.788   132.648     0.150
     8.873   130.699     0.150
     8.873   225.777     0.150
    11.638   168.059     0.150
    12.763   181.359     0.150
    12.763   317.559     0.150
    12.802   180.969     0.150
    12.802   320.039     0.150
    13.241   185.758     0.150
    13.377   189.758     0.150
    13.377   331.957     0.150
    13.942   196.859     0.150
    13.942   346.359     0.150
    13.968   197.359     0.150
    13.968   346.656     0.150
    14.185   199.957     0.150
    14.185   351.258     0.150
    14.347   355.859     0.150
    14.569   206.559     0.150
    14.581   206.582     0.150
    14.580   207.109     0.150
    14.580   206.559     0.150
    14.713   207.059     0.150
    14.713   363.859     0.150
    15.917   223.148     0.150
    16.595   233.457     0.150
    16.595   410.332     0.150
    16.752   232.875     0.150
    16.903   237.098     0.150
    17.643   246.656     0.150
    17.643   246.527     0.150
    17.860   247.949     0.150
    18.170   253.047     0.150
    18.170   252.871     0.150
    18.279   255.039     0.150
    18.279   450.488     0.150
    18.279   255.047     0.150
    18.279   450.488     0.150
    18.279   255.281     0.150
    18.279   453.684     0.150
    18.583   259.758     0.150
    18.583   457.258     0.150
    18.583   477.258     0.150
    18.818   260.703     0.150
    20.132   276.258     0.150
    20.498   280.359     0.150
    20.498   507.258     0.150
    21.349   287.906     0.150
    21.349   520.207     0.150
    21.677   290.859     0.150
    21.677   526.258     0.150
    21.576   293.293     0.150
    22.595   328.957     0.150
    23.245   311.359     0.150
    23.227   307.977     0.150
    23.227   557.156     0.150
    23.705   314.656     0.150
    29.192   363.957     0.150
    30.093   372.195     0.150
    31.281   382.457     0.150
    34.093   406.082     0.150
    37.359   433.758     0.150
    38.102   442.359     0.150
    38.923   447.406     0.150
    39.081   448.258     0.150
    39.601   453.359     0.150
    39.601   548.059     0.150
    39.601   813.258     0.150
    39.601   830.258     0.150
    42.374   474.957     0.150
    42.711   478.332     0.150
    45.234   497.777     0.150
    45.775   501.957     0.150
    45.775   502.234     0.150
    45.936   501.957     0.150
    48.898   527.809     0.150
    49.134   530.156     0.150
    49.143   530.559     0.150
    49.275   531.258     0.150
    50.235   536.859     0.150
    50.886   542.359     0.150
    53.450   561.145     0.150
    56.339   581.957     0.150
    64.421   637.887     0.150
    74.749   701.707     0.150
    76.581   713.207     0.150
    81.016   736.641     0.150
    82.877   744.703     0.150
    92.197   790.906     0.150
   146.043  1182.656     0.150
   149.354  1190.809     0.150
     1.343    25.844     0.150
     2.084    38.242     0.150
     2.330    42.445     0.150
     3.525   103.344     0.150
     4.546    70.344     0.150
     4.546   145.344     0.150
     5.855    88.344     0.150
     5.855   155.344     0.150
     7.872   116.293     0.150
     7.872   206.434     0.150
     8.008   118.324     0.150
     8.008   208.031     0.150
     8.429   124.719     0.150
     8.429   216.926     0.150
    12.684   178.445     0.150
    13.279   185.543     0.150
    13.846   192.945     0.150
    13.866   194.445     0.150
    14.086   197.344     0.150
    14.230   204.320     0.150
    14.235   199.145     0.150
    14.603   203.742     0.150
    16.476   230.367     0.150
    16.476   403.043     0.150
    16.434   230.383     0.150
    17.914   246.965     0.150
    17.919   249.680     0.150
    18.167   252.793     0.150
    18.167   252.773     0.150
    18.167   446.168     0.150
    21.015   282.867     0.150
    28.838   357.758     0.150
    34.113   404.242     0.150
    38.841   444.219     0.150
    42.563   475.645     0.150
    42.563   474.773     0.150
    45.711   498.742     0.150
    45.711   499.820     0.150
    66.070   646.445     0.150
    83.156   745.242     0.150
     1.266    24.152     0.150
     1.266    43.953     0.150
     1.460    28.074     0.150
     2.055    38.852     0.150
     2.289    41.953     0.150
     3.182    54.453     0.150
     4.683    73.953     0.150
     4.816    76.953     0.150
     7.000   106.164     0.150
     7.000   178.234     0.150
     7.759   116.965     0.150
     7.759   204.531     0.150
     7.759   117.305     0.150
     7.867   118.395     0.150
     7.867   200.562     0.150
     8.059   121.191     0.150
     8.059   121.793     0.150
     8.112   207.953     0.150
     8.141   207.023     0.150
     8.283   123.992     0.150
     8.283   215.824     0.150
     8.283   124.324     0.150
     8.371   212.043     0.150
     8.395   124.820     0.150
     8.395   220.688     0.150
     8.434   126.402     0.150
     9.019   134.852     0.150
     9.019   135.254     0.150
    12.940   183.254     0.150
    14.132   198.352     0.150
    14.163   198.652     0.150
    14.378   201.453     0.150
    14.549   204.652     0.150
    14.871   214.555     0.150
    14.914   208.555     0.150
    16.608   233.102     0.150
    16.608   411.148     0.150
    18.286   254.531     0.150
    18.286   254.125     0.150
    18.286   454.098     0.150
    18.286   254.527     0.150
    18.323   255.566     0.150
    21.609   290.652     0.150
    21.625   290.633     0.150
    21.625   290.652     0.150
    29.521   365.754     0.150
    33.975   404.203     0.150
    42.750   478.352     0.150
    45.731   501.152     0.150
    65.525   643.762     0.150
    81.182   737.652     0.150
    83.048   745.352     0.150
    83.362   746.902     0.150
     1.053    20.316     0.150
     1.053    36.215     0.150
     1.477    26.914     0.150
     1.742    31.715     0.150
     2.150    38.215     0.150
     2.887    48.016     0.150
     4.671   126.215     0.150
     6.245    93.035     0.150
     6.245   162.387     0.150
     6.854   103.727     0.150
     6.854   177.246     0.150
     7.870   198.453     0.150
     8.112   202.375     0.150
     8.082   119.773     0.150
     8.607   128.137     0.150
     8.734   128.074     0.150
     8.734   224.508     0.150
     9.328   136.816     0.150
    15.152   218.516     0.150
    15.152   217.684     0.150
    16.920   235.539     0.150
    16.920   417.145     0.150
    21.917   291.816     0.150
    21.933   291.840     0.150
    23.726   310.715     0.150
    46.012   501.609     0.150
    65.533   641.090     0.150
    83.160   744.516     0.150
     0.868    15.617     0.150
     1.623    30.516     0.150
     2.016    37.117     0.150
     2.766    50.859     0.150
     2.766    80.453     0.150
     3.188    52.414     0.150
     4.348    69.016     0.150
     4.348   119.016     0.150
     4.765    76.016     0.150
     4.765   134.016     0.150
     5.093   139.016     0.150
     5.620    86.695     0.150
     5.620   151.094     0.150
     6.067    93.414     0.150
     6.067   164.219     0.150
     6.447    97.516     0.150
     6.768   102.367     0.150
     6.768   177.062     0.150
     7.142   182.312     0.150
     7.834   115.922     0.150
     8.254   119.016     0.150
     8.254   208.016     0.150
     8.433   126.812     0.150
     8.672   125.016     0.150
     8.672   223.016     0.150
     8.881   131.312     0.150
     8.900   131.469     0.150
     8.900   232.016     0.150
     8.900   131.219     0.150
     8.900   228.719     0.150
     8.950   132.719     0.150
     8.950   230.016     0.150
     8.950   133.797     0.150
     9.129   134.719     0.150
     9.129   237.914     0.150
     9.129   232.594     0.150
     9.129   135.734     0.150
     9.129   135.227     0.150
     9.129   135.016     0.150
     9.288   137.516     0.150
     9.344   138.016     0.150
     9.344   241.016     0.150
     9.409   138.719     0.150
     9.536   141.414     0.150
     9.708   143.719     0.150
     9.743   142.789     0.150
     9.743   142.898     0.150
     9.838   142.914     0.150
     9.911   145.516     0.150
    10.318   150.016     0.150
    10.513   153.828     0.150
    10.910   156.094     0.150
    12.667   179.312     0.150
    12.704   179.492     0.150
    13.123   185.812     0.150
    13.299   187.719     0.150
    14.041   197.125     0.150
    14.523   203.617     0.150
    14.566   203.812     0.150
    14.762   206.617     0.150
    14.774   206.414     0.150
    14.805   208.039     0.150
    14.971   208.617     0.150
    15.073   213.719     0.150
    15.256   211.477     0.150
    15.256   215.164     0.150
    15.264   217.516     0.150
    15.333   216.844     0.150
    15.477   223.977     0.150
    15.644   220.773     0.150
    15.644   219.914     0.150
    15.644   995.586     0.150
    15.758   223.984     0.150
    15.978   223.609     0.150
    16.002   222.117     0.150
    16.012   228.484     0.150
    16.015   228.367     0.150
    16.655   231.516     0.150
    16.664   231.016     0.150
    16.745   234.016     0.150
    16.745   241.016     0.150
    16.745   248.016     0.150
    16.745   420.016     0.150
    16.745   524.016     0.150
    16.791   235.641     0.150
    16.791   235.062     0.150
    17.233   239.219     0.150
    17.310   237.945     0.150
    17.557   245.109     0.150
    17.557   995.539     0.150
    17.665   244.117     0.150
    17.665   244.586     0.150
    17.665   995.539     0.150
    17.665   245.102     0.150
    17.665   245.312     0.150
    17.653   250.070     0.150
    18.032   252.953     0.150
    18.051   254.953     0.150
    18.201   255.945     0.150
    18.382   252.016     0.150
    18.468   255.914     0.150
    18.468   457.414     0.150
    18.421   258.906     0.150
    18.449   256.344     0.150
    18.449   256.719     0.150
    18.530   255.414     0.150
    18.505   258.570     0.150
    18.759   259.695     0.150
    18.821   260.656     0.150
    18.821   259.914     0.150
    18.821   471.719     0.150
    18.854   260.219     0.150
    18.854   260.367     0.150
    18.854   468.727     0.150
    18.854   260.680     0.150
    18.943   258.523     0.150
    19.327   268.211     0.150
    19.480   268.953     0.150
    19.604   491.617     0.150
    19.709   272.242     0.150
    19.833   273.273     0.150
    19.852   273.312     0.150
    19.972   274.625     0.150
    20.252   281.102     0.150
    20.797   282.016     0.150
    20.720   284.742     0.150
    20.957   287.109     0.150
    20.957   286.609     0.150
    21.246   289.117     0.150
    21.549   292.344     0.150
    21.684   294.836     0.150
    21.830   294.438     0.150
    21.823   296.852     0.150
    22.094   298.219     0.150
    22.098   299.258     0.150
    22.342   297.312     0.150
    22.345   300.352     0.150
    22.369   301.688     0.150
    22.481   300.906     0.150
    22.616   300.414     0.150
    22.616   546.117     0.150
    22.578   305.211     0.150
    22.784   303.016     0.150
    22.784   552.016     0.150
    23.041   306.812     0.150
    23.220   311.453     0.150
    23.225   310.875     0.150
    23.247   308.812     0.150
    23.247   563.312     0.150
    23.317   312.000     0.150
    23.376   312.484     0.150
    23.443   312.383     0.150
    23.519   312.219     0.150
    23.519   564.617     0.150
    23.502   314.406     0.150
    23.580   311.719     0.150
    23.580   568.516     0.150
    23.580   604.914     0.150
    23.580   311.414     0.150
    23.881   315.781     0.150
    24.177   320.766     0.150
    24.365   321.516     0.150
    24.365   583.516     0.150
    24.395   321.250     0.150
    24.799   323.812     0.150
    24.815   322.336     0.150
    25.137   328.594     0.150
    25.254   327.016     0.150
    25.254   594.219     0.150
    25.254   645.117     0.150
    25.289   329.594     0.150
    25.727   333.219     0.150
    25.727   333.016     0.150
    25.946   335.805     0.150
    26.440   339.844     0.150
    26.613   340.516     0.150
    26.613   616.117     0.150
    26.860   342.414     0.150
    26.896   342.617     0.150
    26.868   343.297     0.150
    27.108   344.414     0.150
    27.108   386.516     0.150
    27.108   544.414     0.150
    27.108   624.914     0.150
    27.108   695.617     0.150
    27.269   346.586     0.150
    27.295   347.406     0.150
    27.311   348.125     0.150
    27.656   349.812     0.150
    27.656   396.414     0.150
    27.656   638.414     0.150
    27.656   704.617     0.150
    27.719   351.406     0.150
    27.870   352.117     0.150
    28.049   353.617     0.150
    28.254   355.016     0.150
    28.325   356.219     0.150
    28.562   358.812     0.150
    28.562   410.414     0.150
    28.562   551.016     0.150
    28.562   645.016     0.150
    28.562   651.516     0.150
    28.562   729.516     0.150
    28.562   772.117     0.150
    28.518   357.906     0.150
    28.566   358.594     0.150
    28.662   360.055     0.150
    28.767   359.945     0.150
    28.767   550.398     0.150
    28.877   361.023     0.150
    29.139   362.719     0.150
    29.139   550.617     0.150
    29.392   366.562     0.150
    29.442   365.508     0.150
    29.442   551.266     0.150
    29.442   365.766     0.150
    29.442   551.617     0.150
    29.455   366.016     0.150
    29.455   665.016     0.150
    29.573   368.117     0.150
    29.602   367.375     0.150
    29.658   368.492     0.150
    29.743   369.414     0.150
    29.743   425.516     0.150
    29.743   663.016     0.150
    29.743   755.914     0.150
    29.835   368.812     0.150
    29.843   369.344     0.150
    29.953   369.312     0.150
    29.953   370.500     0.150
    29.953   370.016     0.150
    29.953   370.117     0.150
    29.957   370.414     0.150
    29.957   370.617     0.150
    30.000   370.742     0.150
    30.000   370.414     0.150
    30.164   371.109     0.150
    30.164   371.469     0.150
    30.164  1004.617     0.150
    30.091   371.914     0.150
    30.091   552.414     0.150
    30.091   372.453     0.150
    30.346   373.812     0.150
    30.411   374.016     0.150
    30.411   552.219     0.150
    30.650   377.617     0.150
    30.673   375.773     0.150
    30.785   377.336     0.150
    30.785   377.750     0.150
    30.785   377.219     0.150
    30.988   435.312     0.150
    31.208   381.016     0.150
    31.208   451.617     0.150
    31.208   380.117     0.150
    31.601   384.500     0.150
    32.084   388.812     0.150
    32.084   696.617     0.150
    32.216   390.312     0.150
    32.209   389.594     0.150
    32.344   393.219     0.150
    32.435   392.516     0.150
    32.435   458.812     0.150
    32.435   560.016     0.150
    32.435   704.617     0.150
    32.435   782.812     0.150
    32.435   818.016     0.150
    32.687   394.383     0.150
    32.739   394.273     0.150
    32.806   395.969     0.150
    32.907   393.727     0.150
    33.213   399.117     0.150
    33.285   398.938     0.150
    33.380   401.312     0.150
    33.380   473.117     0.150
    33.380   563.312     0.150
    33.380   720.414     0.150
    33.380   727.016     0.150
    33.380   785.617     0.150
    33.380   788.312     0.150
    33.380   842.617     0.150
    33.380  1025.812     0.150
    33.404   399.016     0.150
    33.404   469.016     0.150
    33.430   398.906     0.150
    33.458   400.453     0.150
    33.576   402.914     0.150
    33.732   403.914     0.150
    33.811   403.617     0.150
    33.811   480.516     0.150
    33.811   788.047     0.150
    33.813   403.336     0.150
    33.816   403.312     0.150
    33.816   481.492     0.150
    33.811   402.812     0.150
    33.811   480.812     0.150
    33.614   404.180     0.150
    34.020   406.117     0.150
    34.000   405.430     0.150
    34.078   406.383     0.150
    34.136   407.219     0.150
    34.235   409.617     0.150
    34.280   409.312     0.150
    34.526   411.219     0.150
    34.728   413.312     0.150
    34.782   413.719     0.150
    34.903   412.914     0.150
    34.834   413.312     0.150
    34.978   413.414     0.150
    35.004   412.984     0.150
    35.159   415.219     0.150
    35.201   416.617     0.150
    35.200   414.914     0.150
    35.208   416.117     0.150
    35.253   418.133     0.150
    35.253   418.312     0.150
    35.273   415.734     0.150
    35.423   414.016     0.150
    35.636   418.016     0.150
    35.668   421.414     0.150
    35.794   421.016     0.150
    35.807   419.617     0.150
    35.818   420.812     0.150
    35.880   422.414     0.150
    35.880   422.312     0.150
    35.908   422.812     0.150
    35.922   422.453     0.150
    35.934   420.219     0.150
    36.024   421.812     0.150
    36.024   422.117     0.150
    36.155   424.117     0.150
    36.171   425.617     0.150
    36.190   425.008     0.150
    36.308   425.812     0.150
    36.274   424.719     0.150
    36.402   425.812     0.150
    36.774   429.609     0.150
    36.781   430.414     0.150
    36.807   430.719     0.150
    36.816   429.914     0.150
    36.848   428.938     0.150
    36.848   429.914     0.150
    36.878   430.336     0.150
    36.947   432.117     0.150
    36.947   775.516     0.150
    36.890   430.523     0.150
    36.932   517.219     0.150
    36.932   777.016     0.150
    36.968   429.516     0.150
    37.055   432.312     0.150
    37.177   432.617     0.150
    37.206   433.719     0.150
    37.214   432.812     0.150
    37.242   433.516     0.150
    37.304   433.219     0.150
    37.410   778.812     0.150
    37.363   434.016     0.150
    37.376   433.914     0.150
    37.402   436.016     0.150
    37.484   434.219     0.150
    37.480   435.719     0.150
    37.504   434.719     0.150
    37.516   435.219     0.150
    37.559   437.016     0.150
    37.586   436.492     0.150
    37.586   435.219     0.150
    37.747   438.719     0.150
    37.764   438.312     0.150
    37.764   438.516     0.150
    37.764   786.719     0.150
    37.764   436.219     0.150
    37.887   438.617     0.150
    37.882   436.312     0.150
    37.946   439.219     0.150
    37.946   574.016     0.150
    37.946   788.812     0.150
    37.983   440.117     0.150
    37.983   527.914     0.150
    37.983   804.914     0.150
    38.125   439.617     0.150
    38.127   437.516     0.150
    38.155   440.219     0.150
    38.155   528.414     0.150
    38.155   527.016     0.150
    38.280   443.117     0.150
    38.424   443.117     0.150
    38.424   798.312     0.150
    38.383   445.219     0.150
    38.400   441.312     0.150
    38.494   444.312     0.150
    38.514   443.617     0.150
    38.514   532.914     0.150
    38.514   798.219     0.150
    38.647   444.219     0.150
    38.840   445.016     0.150
    38.969   446.875     0.150
    38.969   536.266     0.150
    38.969   577.875     0.150
    38.969   447.062     0.150
    38.969   535.969     0.150
    38.969   578.312     0.150
    39.036   447.016     0.150
    39.046   446.812     0.150
    39.148   447.812     0.150
    39.225   451.016     0.150
    39.225   539.516     0.150
    39.278   450.719     0.150
    39.314   451.719     0.150
    39.314   451.516     0.150
    39.310   452.219     0.150
    39.467   452.219     0.150
    39.510   453.117     0.150
    39.510   546.117     0.150
    39.510   453.617     0.150
    39.510   453.914     0.150
    39.512   455.117     0.150
    39.689   454.016     0.150
    39.689   822.016     0.150
    39.689   454.578     0.150
    39.689     4.203     0.150
    39.707   451.312     0.150
    39.814   454.719     0.150
    39.814   454.219     0.150
    39.964   458.414     0.150
    39.996   458.516     0.150
    40.076   455.812     0.150
    40.093   459.117     0.150
    40.232   458.914     0.150
    40.232   553.414     0.150
    40.232   834.414     0.150
    40.521   462.312     0.150
    40.655   461.812     0.150
    40.655   829.516     0.150
    40.607   463.516     0.150
    40.734   463.117     0.150
    40.734   561.117     0.150
    40.764   464.414     0.150
    41.119   466.617     0.150
    41.119   558.867     0.150
    41.119   466.516     0.150
    41.169   468.219     0.150
    41.169   568.812     0.150
    41.336   465.945     0.150
    41.272   466.414     0.150
    41.272   467.336     0.150
    41.283   467.617     0.150
    41.283   842.914     0.150
    41.539   469.812     0.150
    41.539   568.117     0.150
    41.649   471.117     0.150
    41.727   471.328     0.150
    41.727   471.617     0.150
    41.760   471.812     0.150
    41.922   473.516     0.150
    41.922   575.617     0.150
    41.957   473.016     0.150
    41.957   568.516     0.150
    41.957   472.719     0.150
    41.957   568.617     0.150
    42.031   473.531     0.150
    42.012   473.227     0.150
    42.125   474.812     0.150
    42.222   475.227     0.150
    42.305   475.117     0.150
    42.451   477.719     0.150
    42.474   477.141     0.150
    42.483   476.234     0.150
    42.601   478.672     0.150
    42.651   477.617     0.150
    42.651   476.719     0.150
    42.840   481.312     0.150
    42.840   868.414     0.150
    42.913   480.812     0.150
    42.913   862.312     0.150
    42.839   480.039     0.150
    42.975   480.164     0.150
    42.975   480.094     0.150
    43.046   482.617     0.150
    43.046   582.914     0.150
    43.055   481.492     0.150
    43.055   481.914     0.150
    43.063   482.414     0.150
    43.063   584.414     0.150
    43.063   872.617     0.150
    43.063  1072.117     0.150
    43.133   483.016     0.150
    43.133   586.016     0.150
    43.182   483.094     0.150
    43.298   483.695     0.150
    43.325   482.156     0.150
    43.325   591.305     0.150
    43.325   483.219     0.150
    43.420   483.617     0.150
    43.420   586.812     0.150
    43.420  1059.016     0.150
    43.412   483.523     0.150
    43.446   485.383     0.150
    43.446   586.375     0.150
    43.446   877.016     0.150
    43.446  1071.016     0.150
    43.446   485.719     0.150
    43.578   485.914     0.150
    43.578   587.812     0.150
    43.578   485.586     0.150
    43.634   486.812     0.150
    43.634   590.016     0.150
    43.634   589.594     0.150
    43.634   485.742     0.150
    43.634   590.664     0.150
    43.705   486.914     0.150
    43.705   590.516     0.150
    43.705  1075.516     0.150
    43.705   486.578     0.150
    43.798   487.711     0.150
    43.820   489.016     0.150
    43.968   489.219     0.150
    44.041   490.016     0.150
    44.041   590.016     0.150
    44.041   889.016     0.150
    44.041   489.914     0.150
    44.041   598.016     0.150
    44.041  1017.016     0.150
    44.041  1083.016     0.150
    44.164   490.617     0.150
    44.164   594.812     0.150
    44.294   491.812     0.150
    44.394   493.414     0.150
    44.402   491.656     0.150
    44.402   596.625     0.150
    44.407   493.719     0.150
    44.452   494.016     0.150
    44.462   494.312     0.150
    44.478   494.117     0.150
    44.492   494.117     0.150
    44.537   494.516     0.150
    44.619   494.922     0.150
    44.563   493.234     0.150
    44.578   495.312     0.150
    44.587   494.812     0.150
    44.633   495.812     0.150
    44.813   496.414     0.150
    44.927   497.617     0.150
    44.949   496.047     0.150
    44.949   495.219     0.150
    45.059   497.422     0.150
    45.134   499.008     0.150
    45.115   497.516     0.150
    45.149   497.617     0.150
    45.220   500.516     0.150
    45.221   499.312     0.150
    45.282   499.812     0.150
    45.428   500.844     0.150
    45.428   501.188     0.150
    45.469   499.914     0.150
    45.551   500.445     0.150
    45.719   503.312     0.150
    45.674   503.312     0.150
    45.686   501.867     0.150
    45.692   503.414     0.150
    45.804   504.484     0.150
    45.753   501.719     0.150
    45.753   607.117     0.150
    45.753   501.742     0.150
    45.753   608.992     0.150
    45.755   502.375     0.150
    45.865   504.555     0.150
    45.824   504.414     0.150
    45.824   611.719     0.150
    45.946   505.219     0.150
    46.041   506.273     0.150
    46.045   503.266     0.150
    46.116   506.133     0.150
    46.268   506.812     0.150
    46.268   602.312     0.150
    46.268   835.914     0.150
    46.268   913.414     0.150
    46.313   505.117     0.150
    46.313   614.516     0.150
    46.303   506.852     0.150
    46.410   507.867     0.150
    46.410   602.664     0.150
    46.360   507.672     0.150
    46.410   507.867     0.150
    46.385   506.883     0.150
    46.385   506.016     0.150
    46.385   614.219     0.150
    46.403   509.312     0.150
    46.611   510.516     0.150
    46.611   510.414     0.150
    46.687   511.383     0.150
    46.687   623.039     0.150
    46.687   512.180     0.150
    46.762   511.266     0.150
    46.762   622.883     0.150
    46.793   512.414     0.150
    46.949   512.914     0.150
    47.228   514.516     0.150
    47.228   515.312     0.150
    47.270   515.719     0.150
    47.287   516.117     0.150
    47.498   516.812     0.150
    47.503   517.617     0.150
    47.581   518.719     0.150
    47.626   518.516     0.150
    47.639   516.812     0.150
    47.731   518.914     0.150
    47.881   519.117     0.150
    47.903   520.078     0.150
    47.913   520.414     0.150
    47.916   519.719     0.150
    47.967   521.898     0.150
    48.030   520.414     0.150
    48.018   521.219     0.150
    48.018   520.914     0.150
    48.082   521.719     0.150
    48.161   519.516     0.150
    48.161   607.219     0.150
    48.161   631.914     0.150
    48.161   938.914     0.150
    48.180   521.789     0.150
    48.273   522.117     0.150
    48.355   523.516     0.150
    48.403   523.719     0.150
    48.492   525.016     0.150
    48.492   523.609     0.150
    48.503   525.398     0.150
    48.503   641.219     0.150
    48.503   525.016     0.150
    48.503   640.617     0.150
    48.503   525.812     0.150
    48.511   524.016     0.150
    48.556   523.453     0.150
    48.571   522.836     0.150
    48.584   524.812     0.150
    48.621   523.148     0.150
    48.615   526.016     0.150
    48.697   526.016     0.150
    48.707   526.016     0.150
    48.752   527.719     0.150
    48.794   527.414     0.150
    48.819   525.516     0.150
    48.826   526.719     0.150
    48.836   527.719     0.150
    48.921   528.016     0.150
    48.920   527.812     0.150
    48.961   528.344     0.150
    48.968   528.117     0.150
    49.028   529.273     0.150
    49.028   528.867     0.150
    49.131   528.219     0.150
    49.190   529.719     0.150
    49.304   531.219     0.150
    49.433   529.617     0.150
    49.433   611.719     0.150
    49.433   643.617     0.150
    49.433  1121.516     0.150
    49.372   531.516     0.150
    49.407   531.812     0.150
    49.416   531.812     0.150
    49.424   531.414     0.150
    49.441   531.312     0.150
    49.451   532.359     0.150
    49.513   534.055     0.150
    49.550   532.164     0.150
    49.597   533.672     0.150
    49.743   534.219     0.150
    49.743   614.078     0.150
    49.743   534.570     0.150
    49.703   534.117     0.150
    49.807   533.914     0.150
    49.995   536.648     0.150
    49.995   535.914     0.150
    50.151   536.086     0.150
    50.261   537.516     0.150
    50.268   538.516     0.150
    50.424   540.359     0.150
    50.363   538.117     0.150
    50.541   541.266     0.150
    50.487   539.312     0.150
    50.637   540.312     0.150
    50.674   541.508     0.150
    50.674   540.617     0.150
    50.674   541.312     0.150
    50.790   541.414     0.150
    50.952   543.898     0.150
    51.025   545.312     0.150
    51.025   544.828     0.150
    50.997   543.117     0.150
    51.084   544.617     0.150
    51.173   544.617     0.150
    51.177   544.312     0.150
    51.179   544.914     0.150
    51.230   546.016     0.150
    51.485   546.672     0.150
    51.663   548.414     0.150
    52.032   552.031     0.150
    52.058   551.516     0.150
    52.324   552.812     0.150
    52.350   553.719     0.150
    52.593   554.828     0.150
    52.741   555.914     0.150
    52.922   557.469     0.150
    52.940   557.312     0.150
    52.969   558.016     0.150
    53.134   558.742     0.150
    53.185   559.016     0.150
    53.326   561.641     0.150
    53.263   559.617     0.150
    53.407   561.562     0.150
    53.395   560.648     0.150
    53.400   560.273     0.150
    53.583   561.375     0.150
    53.731   562.414     0.150
    53.878   563.094     0.150
    53.921   564.312     0.150
    53.939   563.039     0.150
    54.180   566.328     0.150
    54.237   566.469     0.150
    54.398   568.414     0.150
    54.402   568.219     0.150
    54.576   568.914     0.150
    54.580   568.914     0.150
    54.581   569.828     0.150
    54.542   568.867     0.150
    54.559   569.008     0.150
    54.577   568.703     0.150
    54.834   572.719     0.150
    54.844   571.312     0.150
    54.875   571.219     0.150
    55.717   577.016     0.150
    56.709   584.219     0.150
    56.782   585.117     0.150
    56.973   586.117     0.150
    57.758   592.664     0.150
    57.758   595.250     0.150
    57.748   589.219     0.150
    57.748  1067.516     0.150
    57.833   592.297     0.150
    58.158   594.914     0.150
    58.841   600.117     0.150
    59.097   602.414     0.150
    59.520   604.812     0.150
    59.987   608.117     0.150
    60.112   609.617     0.150
    60.157   611.016     0.150
    60.191   610.867     0.150
    60.292   610.414     0.150
    60.311   611.117     0.150
    60.400   611.617     0.150
    60.987   612.984     0.150
    60.987   612.125     0.150
    61.028   614.219     0.150
    61.028   656.312     0.150
    61.028   745.016     0.150
    61.028  1355.414     0.150
    61.062   617.219     0.150
    61.230   616.016     0.150
    61.265   615.719     0.150
    62.973   627.812     0.150
    62.973   767.117     0.150
    62.973   628.516     0.150
    63.279   630.625     0.150
    63.279   630.406     0.150
    63.279   631.188     0.150
    64.862   638.328     0.150
    64.862   638.617     0.150
    67.885   660.992     0.150
    69.605   671.117     0.150
    70.689   674.539     0.150
    70.993   678.773     0.150
    71.558   681.469     0.150
    72.072   684.586     0.150
    72.386   687.648     0.150
    72.408   688.477     0.150
    72.428   687.992     0.150
    72.428   687.805     0.150
    72.580   688.156     0.150
    72.857   690.453     0.150
    72.857   690.078     0.150
    73.004   690.133     0.150
    73.768   693.117     0.150
    73.768   694.289     0.150
    73.997   697.039     0.150
    74.202   697.789     0.150
    74.155   696.414     0.150
    74.288   698.289     0.150
    74.400   697.766     0.150
    75.465   705.445     0.150
    76.906   712.914     0.150
    77.209   713.219     0.150
    77.209  1859.969     0.150
    77.521   715.977     0.150
    77.542   714.688     0.150
    77.542   888.969     0.150
    77.632   716.016     0.150
    77.632   892.719     0.150
    78.040   719.633     0.150
    78.368   720.555     0.150
    78.798   723.008     0.150
    79.089   724.016     0.150
    79.372   727.016     0.150
    79.402   725.516     0.150
    79.419   725.914     0.150
    79.500   726.453     0.150
    80.145   732.312     0.150
    80.629   732.648     0.150
    80.786   734.914     0.150
    80.786   735.953     0.150
    80.786   736.914     0.150
    81.046   735.094     0.150
    81.485   738.086     0.150
    81.485  1349.266     0.150
    81.485  1852.844     0.150
    81.494   738.219     0.150
    81.494   738.016     0.150
    81.876   739.797     0.150
    82.357   741.789     0.150
    83.506   747.305     0.150
    83.574   748.266     0.150
    83.574  1844.914     0.150
    83.574  2334.312     0.150
    83.623   749.156     0.150
    83.623   749.266     0.150
    83.623  1372.016     0.150
    83.623  1848.016     0.150
    83.623  2336.367     0.150
    83.885   750.656     0.150
    83.885   750.141     0.150
    84.687   754.148     0.150
    84.776   756.305     0.150
    84.776   756.102     0.150
    86.202   762.133     0.150
    90.329   781.648     0.150
    90.333   781.219     0.150
    91.169   786.117     0.150
    91.169   785.398     0.150
    91.169   785.516     0.150
    94.088   798.516     0.150
    94.088  1026.266     0.150
    94.995   803.219     0.150
    96.563   810.156     0.150
    97.158   812.984     0.150
    97.211   813.312     0.150
    97.225   813.461     0.150
    97.712   815.914     0.150
    97.714   815.492     0.150
    97.759   815.852     0.150
    97.778   815.859     0.150
    97.827   815.625     0.150
    98.208   818.289     0.150
    98.364   818.289     0.150
    99.018   821.109     0.150
   103.405  1101.117     0.150
   107.328  1109.969     0.150
   107.328  1783.469     0.150
   112.205  1116.875     0.150
   113.594   886.016     0.150
   113.848  1120.266     0.150
   114.218  1120.812     0.150
   115.314  1122.836     0.150
   115.365  1122.844     0.150
   115.479  1122.797     0.150
   115.603  1123.383     0.150
   116.304  1125.172     0.150
   116.350  1125.078     0.150
   116.386  1123.648     0.150
   116.529  1126.555     0.150
   116.529  1753.867     0.150
   116.961  1125.516     0.150
   116.961  1124.734     0.150
   117.965  1127.219     0.150
   118.120  1128.516     0.150
   118.772  1128.516     0.150
   123.189  1138.875     0.150
   123.496  1136.516     0.150
   123.496  1136.812     0.150
   123.469  1137.578     0.150
   125.336  1141.586     0.150
   127.366  1147.992     0.150
   128.018  1147.453     0.150
   128.413  1147.578     0.150
   129.194  1151.617     0.150
   129.304  1147.984     0.150
   129.426  1151.898     0.150
   130.311  1152.516     0.150
   131.130  1152.586     0.150
   131.856  1157.492     0.150
   134.263  1158.484     0.150
   138.484  1167.523     0.150
   138.484  1168.148     0.150
   141.365  1168.727     0.150
   142.298  1175.992     0.150
   146.285  1180.875     0.150
   148.222  1185.734     0.150
   148.222  1719.812     0.150
     0.887    16.000     0.150
     1.609    30.500     0.150
     1.990    37.398     0.150
     2.753    51.000     0.150
     2.753    81.203     0.150
     2.747    48.398     0.150
     3.161    52.500     0.150
     4.331    69.000     0.150
     4.331   118.000     0.150
     4.745    76.000     0.150
     4.745   135.000     0.150
     5.076   139.000     0.150
     5.603    86.258     0.150
     5.603   149.820     0.150
     6.047    92.602     0.150
     6.047   164.797     0.150
     6.428    97.500     0.150
     6.428   169.500     0.150
     6.748   177.281     0.150
     7.813   114.500     0.150
     7.813   115.992     0.150
     7.813   201.641     0.150
     8.458   126.648     0.150
     8.904   132.039     0.150
     8.929   132.047     0.150
     8.929   232.680     0.150
     8.976   132.703     0.150
     8.976   231.500     0.150
     8.976   133.680     0.150
     9.154   135.297     0.150
     9.154   238.297     0.150
     9.154   135.680     0.150
     9.154   237.359     0.150
     9.154   137.102     0.150
     9.154   135.000     0.150
     9.313   138.758     0.150
     9.369   139.000     0.150
     9.369   244.000     0.150
     9.431   139.242     0.150
     9.560   141.750     0.150
     9.733   143.672     0.150
     9.766   144.195     0.150
     9.766   143.602     0.150
     9.766   143.742     0.150
     9.818   141.898     0.150
     9.818   250.602     0.150
     9.891   144.500     0.150
    10.535   154.984     0.150
    12.648   179.398     0.150
    12.675   179.312     0.150
    13.105   185.602     0.150
    13.280   187.797     0.150
    14.014   196.312     0.150
    14.505   203.203     0.150
    14.548   203.797     0.150
    14.743   206.203     0.150
    14.775   208.406     0.150
    14.756   206.398     0.150
    14.953   209.398     0.150
    15.227   211.648     0.150
    15.249   224.352     0.150
    15.249   216.594     0.150
    15.319   224.898     0.150
    15.319   216.219     0.150
    15.389   220.602     0.150
    15.467   223.805     0.150
    15.467   220.930     0.150
    15.665   221.453     0.150
    15.665   221.602     0.150
    15.742   224.453     0.150
    15.742   223.648     0.150
    15.999   228.781     0.150
    16.001   227.898     0.150
    15.983   222.398     0.150
    16.637   231.000     0.150
    16.647   231.102     0.150
    16.758   236.602     0.150
    16.758   251.000     0.150
    16.758   422.602     0.150
    16.821   236.523     0.150
    16.821   236.453     0.150
    16.821   421.883     0.150
    17.288   239.898     0.150
    17.582   244.586     0.150
    17.690   244.602     0.150
    17.690   245.859     0.150
    17.690   249.008     0.150
    17.690   246.703     0.150
    18.352   253.000     0.150
    18.352   464.500     0.150
    18.455   257.500     0.150
    18.455   465.297     0.150
    18.479   256.516     0.150
    18.479   257.297     0.150
    18.560   258.414     0.150
    18.789   260.594     0.150
    18.851   261.391     0.150
    18.851   261.703     0.150
    18.883   261.898     0.150
    18.883   261.680     0.150
    18.883   473.109     0.150
    18.883   262.641     0.150
    18.883   262.398     0.150
    19.484   269.969     0.150
    19.626   268.102     0.150
    19.626   491.102     0.150
    19.713   272.312     0.150
    19.836   273.719     0.150
    19.975   274.562     0.150
    20.741   285.883     0.150
    20.976   286.398     0.150
    20.976   287.812     0.150
    20.976   288.547     0.150
    21.267   289.500     0.150
    21.815   293.852     0.150
    22.116   299.398     0.150
    22.119   299.867     0.150
    22.390   303.750     0.150
    22.366   298.000     0.150
    22.466   301.188     0.150
    22.641   301.000     0.150
    22.641   547.000     0.150
    23.064   309.602     0.150
    23.270   310.297     0.150
    23.270   563.602     0.150
    23.270   310.703     0.150
    23.550   312.500     0.150
    23.550   568.602     0.150
    23.610   312.398     0.150
    23.610   568.703     0.150
    23.610   605.398     0.150
    23.610   312.000     0.150
    24.368   321.297     0.150
    24.368   583.398     0.150
    24.368   588.797     0.150
    25.744   333.898     0.150
    25.744   333.758     0.150
    26.641   341.602     0.150
    26.919   344.102     0.150
    27.282   347.438     0.150
    27.655   632.297     0.150
    27.655   640.797     0.150
    27.730   350.656     0.150
    27.897   353.297     0.150
    28.076   354.203     0.150
    28.342   356.797     0.150
    28.555   358.000     0.150
    28.555   409.297     0.150
    28.555   550.500     0.150
    28.555   644.297     0.150
    28.555   650.398     0.150
    28.555   728.297     0.150
    28.778   360.602     0.150
    28.778   550.633     0.150
    29.154   362.898     0.150
    29.154   545.797     0.150
    29.460   366.078     0.150
    29.460   550.141     0.150
    29.460   366.000     0.150
    29.460   550.156     0.150
    29.478   368.000     0.150
    29.553   370.797     0.150
    29.731   431.000     0.150
    29.731   667.500     0.150
    29.851   369.297     0.150
    29.934   369.703     0.150
    30.008   370.828     0.150
    30.145   371.898     0.150
    30.358   373.820     0.150
    30.631   377.203     0.150
    30.797   376.680     0.150
    30.797   554.117     0.150
    31.236   382.297     0.150
    31.236   794.703     0.150
    32.082   389.000     0.150
    32.082   697.797     0.150
    32.323   393.203     0.150
    32.425   392.398     0.150
    32.425   460.102     0.150
    32.425   559.797     0.150
    32.425   783.602     0.150
    32.425   820.000     0.150
    32.478   395.398     0.150
    33.385   398.398     0.150
    33.385   469.500     0.150
    33.385   560.797     0.150
    33.385   719.398     0.150
    33.385   784.602     0.150
    33.385   839.500     0.150
    33.385  1024.500     0.150
    33.755   404.000     0.150
    33.837   404.000     0.150
    33.838   403.938     0.150
    33.841   403.797     0.150
    33.837   404.000     0.150
    34.001   406.703     0.150
    34.505   412.602     0.150
    34.751   413.398     0.150
    34.804   414.203     0.150
    34.857   413.500     0.150
    34.885   414.000     0.150
    35.275   418.398     0.150
    35.690   421.602     0.150
    35.932   422.797     0.150
    35.946   423.000     0.150
    36.040   423.102     0.150
    36.040   423.000     0.150
    36.193   425.297     0.150
    36.364   425.000     0.150
    36.804   430.797     0.150
    36.863   429.469     0.150
    36.957   431.398     0.150
    37.037   430.398     0.150
    37.037   432.602     0.150
    37.406   435.797     0.150
    37.502   436.797     0.150
    37.514   434.398     0.150
    37.582   437.297     0.150
    37.770   439.398     0.150
    37.770   439.297     0.150
    37.789   439.102     0.150
    37.789   438.742     0.150
    37.789   439.000     0.150
    37.863   439.703     0.150
    37.970   442.000     0.150
    38.007   441.203     0.150
    38.007   530.000     0.150
    38.219   444.656     0.150
    38.182   526.797     0.150
    38.302   443.703     0.150
    38.538   447.000     0.150
    38.538   533.500     0.150
    38.999   447.547     0.150
    38.999   578.047     0.150
    39.177   448.398     0.150
    39.334   452.797     0.150
    39.497   454.000     0.150
    39.534   453.398     0.150
    39.534   454.000     0.150
    39.714   454.898     0.150
    40.256   460.297     0.150
    40.256   555.703     0.150
    40.388   460.703     0.150
    40.653   461.602     0.150
    40.759   463.398     0.150
    41.143   467.000     0.150
    41.193   469.000     0.150
    41.247   466.250     0.150
    41.247   465.797     0.150
    41.751   471.797     0.150
    41.783   472.102     0.150
    41.947   473.898     0.150
    41.982   473.398     0.150
    41.982   473.500     0.150
    42.150   475.602     0.150
    42.246   475.484     0.150
    42.311   476.297     0.150
    42.682   478.500     0.150
    42.862   480.695     0.150
    43.006   480.398     0.150
    43.074   481.680     0.150
    43.071   482.500     0.150
    43.088   482.703     0.150
    43.322   484.117     0.150
    43.343   483.758     0.150
    43.428   485.898     0.150
    43.471   485.867     0.150
    43.471   593.812     0.150
    43.471   867.000     0.150
    43.658   487.500     0.150
    43.658   486.602     0.150
    43.658   592.203     0.150
    43.730   486.102     0.150
    43.730   591.703     0.150
    43.730   487.500     0.150
    43.845   489.000     0.150
    44.066   490.297     0.150
    44.066   595.000     0.150
    44.066  1082.000     0.150
    44.318   493.398     0.150
    44.419   493.703     0.150
    44.432   493.203     0.150
    44.430   492.109     0.150
    44.477   494.000     0.150
    44.483   492.406     0.150
    44.503   494.102     0.150
    44.517   494.398     0.150
    44.586   494.289     0.150
    44.602   495.398     0.150
    44.612   494.797     0.150
    44.658   495.203     0.150
    44.838   495.797     0.150
    44.952   497.602     0.150
    45.138   497.898     0.150
    45.244   500.602     0.150
    45.492   500.102     0.150
    45.700   503.398     0.150
    45.718   502.898     0.150
    45.778   502.758     0.150
    45.781   502.102     0.150
    45.781   502.398     0.150
    45.850   504.500     0.150
    46.140   506.773     0.150
    46.277   506.000     0.150
    46.326   507.344     0.150
    46.334   505.398     0.150
    46.334     9.203     0.150
    46.334   910.297     0.150
    46.334  1099.703     0.150
    46.384   507.023     0.150
    46.413   508.102     0.150
    46.414   508.102     0.150
    46.673   511.703     0.150
    46.635   509.898     0.150
    46.635   510.602     0.150
    46.785   510.852     0.150
    47.252   513.898     0.150
    47.296   516.203     0.150
    47.652   518.602     0.150
    47.940   520.602     0.150
    48.033   520.422     0.150
    48.038   521.102     0.150
    48.203   521.492     0.150
    48.227   520.500     0.150
    48.297   522.297     0.150
    48.517   525.477     0.150
    48.528   525.773     0.150
    48.528   525.297     0.150
    48.533   524.000     0.150
    48.608   525.102     0.150
    48.720   526.297     0.150
    48.730   526.203     0.150
    48.842   525.297     0.150
    48.945   528.203     0.150
    48.986   528.820     0.150
    48.992   528.500     0.150
    49.045   528.812     0.150
    49.045   529.203     0.150
    49.152   528.500     0.150
    49.296   530.398     0.150
    49.329   531.703     0.150
    49.396   531.703     0.150
    49.430   532.000     0.150
    49.448   531.797     0.150
    49.445   530.797     0.150
    49.445   612.602     0.150
    49.445   958.898     0.150
    49.445   961.703     0.150
    49.445  1123.203     0.150
    49.476   532.812     0.150
    49.622   535.383     0.150
    49.721   534.250     0.150
    49.728   534.703     0.150
    49.829   534.500     0.150
    50.284   537.898     0.150
    50.386   538.297     0.150
    50.511   539.602     0.150
    50.660   540.602     0.150
    50.814   541.797     0.150
    51.006   544.617     0.150
    51.019   543.602     0.150
    51.201   544.703     0.150
    51.203   545.203     0.150
    51.686   548.797     0.150
    52.080   551.602     0.150
    52.346   553.203     0.150
    52.766   556.203     0.150
    52.965   557.703     0.150
    52.992   558.297     0.150
    53.208   559.297     0.150
    53.287   560.000     0.150
    53.753   563.703     0.150
    54.424   568.602     0.150
    54.423   568.602     0.150
    54.581   569.703     0.150
    54.584   569.398     0.150
    54.586   569.508     0.150
    54.868   571.703     0.150
    56.740   584.102     0.150
    56.803   586.500     0.150
    56.984   586.602     0.150
    57.854   591.602     0.150
    58.871   601.398     0.150
    61.052   614.602     0.150
    61.052   659.898     0.150
    61.286   615.297     0.150
    63.004   629.102     0.150
    63.004   629.297     0.150
    63.265   629.953     0.150
    64.869   638.750     0.150
    64.869   639.023     0.150
    67.867   660.492     0.150
    69.636   670.703     0.150
    71.018   679.031     0.150
    72.054   684.406     0.150
    72.390   688.422     0.150
    72.411   688.219     0.150
    72.411   688.031     0.150
    72.986   690.648     0.150
    73.775   694.398     0.150
    73.978   696.328     0.150
    74.161   696.102     0.150
    74.178   697.641     0.150
    74.270   697.273     0.150
    74.426   698.508     0.150
    75.448   705.172     0.150
    75.448   705.359     0.150
    76.328   709.602     0.150
    76.932   713.102     0.150
    77.236   713.281     0.150
    77.547   716.000     0.150
    77.568   716.453     0.150
    77.658   716.703     0.150
    78.395   720.633     0.150
    78.825   722.781     0.150
    79.444   726.898     0.150
    80.769   735.602     0.150
    81.463   738.328     0.150
    81.472   738.203     0.150
    81.472   738.000     0.150
    81.656   737.828     0.150
    83.535   748.047     0.150
    83.600   749.453     0.150
    83.600   749.172     0.150
    83.603   748.547     0.150
    83.915   750.727     0.150
    90.310   781.703     0.150
    94.064   798.773     0.150
   103.435  1100.648     0.150
   116.936  1125.102     0.150
   117.940  1127.297     0.150
   118.747  1128.500     0.150
   123.466  1136.281     0.150
   128.633  1151.258     0.150
   132.623  1156.281     0.150
   134.268  1159.180     0.150
   138.499  1168.297     0.150
   145.024  1177.070     0.150
   148.217  1186.633     0.150
   148.217  1402.156     0.150
   148.217  1187.828     0.150
     0.829    18.135     0.150
     0.829    31.334     0.150
     1.729    30.934     0.150
     1.821    31.834     0.150
     2.804    45.135     0.150
     3.479    52.834     0.150
     3.479   102.834     0.150
     4.215   135.334     0.150
     4.735    71.033     0.150
     4.735   123.385     0.150
     5.274    97.334     0.150
     5.274   136.533     0.150
     5.961    86.484     0.150
     5.961   151.504     0.150
     7.055   177.354     0.150
     7.672   186.334     0.150
     8.509   122.854     0.150
     8.509   215.254     0.150
     8.624   123.385     0.150
     9.059   257.266     0.150
    12.264   169.734     0.150
    12.418   297.504     0.150
    12.472   172.635     0.150
    13.102   180.533     0.150
    13.664   187.834     0.150
    13.695   188.135     0.150
    13.910   190.934     0.150
    14.082   192.834     0.150
    14.447   198.135     0.150
    14.831   210.438     0.150
    14.831   206.059     0.150
    15.135   206.234     0.150
    15.761   214.834     0.150
    15.775   214.533     0.150
    16.964   236.352     0.150
    16.964   234.484     0.150
    16.980   233.775     0.150
    46.146   498.635     0.150
    65.942   640.809     0.150
    80.716   726.385     0.150
    83.239   740.078     0.150
     0.859    15.426     0.150
     1.645    33.725     0.150
     1.645    54.525     0.150
     2.007    37.326     0.150
     2.785    48.625     0.150
     3.177    53.525     0.150
     4.365    70.025     0.150
     4.365   119.025     0.150
     5.636    86.186     0.150
     5.636   151.105     0.150
     6.076    91.326     0.150
     6.076   161.125     0.150
     6.459    96.525     0.150
     6.778   101.756     0.150
     6.778   178.496     0.150
     7.201   181.326     0.150
     7.841   117.725     0.150
     7.841   203.195     0.150
     8.248   121.525     0.150
     8.491   126.326     0.150
     8.557   129.725     0.150
     8.640   130.625     0.150
     8.854   132.725     0.150
     8.921   131.525     0.150
     8.940   133.225     0.150
     8.951   132.508     0.150
     8.951   232.979     0.150
     8.951   132.025     0.150
     8.951   232.826     0.150
     9.008   133.926     0.150
     9.008   234.025     0.150
     9.008   135.166     0.150
     9.187   135.826     0.150
     9.187   239.426     0.150
     9.187   136.346     0.150
     9.338   138.926     0.150
     9.347   139.125     0.150
     9.403   140.525     0.150
     9.403   250.525     0.150
     9.468   141.225     0.150
     9.477   140.426     0.150
     9.594   141.426     0.150
     9.766   144.725     0.150
     9.802   144.178     0.150
     9.802   253.252     0.150
     9.802   143.926     0.150
     9.802   143.795     0.150
     9.847   244.025     0.150
     9.920   144.625     0.150
     9.920   254.125     0.150
    10.166   149.926     0.150
    10.517   154.625     0.150
    10.610   155.625     0.150
    10.860   155.545     0.150
    11.409   167.525     0.150
    12.373   178.326     0.150
    12.677   179.625     0.150
    12.680   180.416     0.150
    13.135   185.826     0.150
    13.260   191.326     0.150
    13.328   192.625     0.150
    13.309   188.326     0.150
    13.386   195.225     0.150
    13.979   196.826     0.150
    14.568   208.725     0.150
    14.535   204.025     0.150
    14.579   204.225     0.150
    14.667   213.025     0.150
    14.769   213.426     0.150
    14.776   208.465     0.150
    14.787   206.525     0.150
    14.995   215.625     0.150
    14.985   210.025     0.150
    15.055   217.525     0.150
    15.109   216.725     0.150
    15.234   211.875     0.150
    15.326   224.525     0.150
    15.343   220.105     0.150
    15.346   214.826     0.150
    15.620   221.926     0.150
    15.704   221.467     0.150
    15.704   219.725     0.150
    15.704   221.705     0.150
    15.704   221.025     0.150
    15.704   222.275     0.150
    15.699   223.965     0.150
    15.955   228.064     0.150
    15.957   227.365     0.150
    15.938   224.885     0.150
    15.999   230.225     0.150
    16.014   222.926     0.150
    16.285   233.826     0.150
    16.515   236.525     0.150
    16.668   232.125     0.150
    16.679   231.725     0.150
    16.802   234.826     0.150
    16.802   238.326     0.150
    16.802   420.525     0.150
    16.802   441.025     0.150
    16.802   738.326     0.150
    16.802   954.826     0.150
    16.823   236.100     0.150
    16.823   416.818     0.150
    16.823   235.846     0.150
    16.823   416.895     0.150
    17.312   241.215     0.150
    17.614   246.148     0.150
    17.614   449.326     0.150
    17.614   245.133     0.150
    17.722   246.725     0.150
    17.722   449.541     0.150
    17.722   247.625     0.150
    17.722   246.361     0.150
    17.722   247.455     0.150
    18.353   252.525     0.150
    18.353   255.025     0.150
    18.480   459.812     0.150
    18.480   256.826     0.150
    18.494   258.326     0.150
    18.581   257.744     0.150
    18.581   466.121     0.150
    18.581   257.525     0.150
    18.871   261.766     0.150
    18.871   475.061     0.150
    18.871   261.826     0.150
    18.903   261.992     0.150
    18.903   476.484     0.150
    18.903   476.025     0.150
    18.903   263.100     0.150
    18.903   261.625     0.150
    18.943   264.125     0.150
    19.014   263.625     0.150
    19.441   269.455     0.150
    19.603   491.826     0.150
    19.792   272.596     0.150
    19.931   274.166     0.150
    20.049   275.195     0.150
    20.263   276.285     0.150
    20.714   282.494     0.150
    20.813   282.525     0.150
    20.946   288.973     0.150
    20.946   287.996     0.150
    20.946   289.285     0.150
    21.347   293.836     0.150
    21.771   293.426     0.150
    22.091   298.492     0.150
    22.364   302.561     0.150
    22.401   297.686     0.150
    22.401   298.025     0.150
    22.401   544.926     0.150
    22.422   300.656     0.150
    22.674   300.926     0.150
    22.674   546.725     0.150
    22.800   305.525     0.150
    23.040   307.926     0.150
    23.246   311.326     0.150
    23.246   557.725     0.150
    23.246   311.826     0.150
    23.327   310.826     0.150
    23.560   312.625     0.150
    23.560   567.625     0.150
    23.618   312.625     0.150
    23.618   566.225     0.150
    23.618   604.225     0.150
    23.618   313.025     0.150
    23.847   313.826     0.150
    24.185   317.326     0.150
    24.414   321.826     0.150
    24.414   588.326     0.150
    25.251   328.826     0.150
    25.251   594.426     0.150
    25.711   334.225     0.150
    25.845   335.775     0.150
    26.899   344.225     0.150
    27.008   346.256     0.150
    27.107   345.025     0.150
    27.170   346.215     0.150
    27.648   350.955     0.150
    27.665   352.836     0.150
    27.691   349.926     0.150
    27.708   351.555     0.150
    27.883   352.926     0.150
    28.062   354.225     0.150
    28.211   355.385     0.150
    28.211   356.326     0.150
    28.347   357.115     0.150
    28.598   359.326     0.150
    28.598   411.025     0.150
    28.598   645.525     0.150
    28.598   730.525     0.150
    28.740   360.225     0.150
    29.429   366.326     0.150
    29.429   550.725     0.150
    29.503   365.375     0.150
    29.768   369.525     0.150
    29.768   426.025     0.150
    29.768   664.025     0.150
    29.768   758.326     0.150
    29.967   370.076     0.150
    29.964   370.625     0.150
    29.964   372.426     0.150
    30.080   370.996     0.150
    30.175   372.426     0.150
    30.175   430.225     0.150
    30.403   374.326     0.150
    30.403   553.125     0.150
    30.842   377.426     0.150
    30.842   378.225     0.150
    31.009   378.125     0.150
    31.009   437.926     0.150
    31.009   553.525     0.150
    31.227   381.125     0.150
    31.227   444.025     0.150
    31.227   686.826     0.150
    32.127   388.826     0.150
    32.225   391.725     0.150
    32.465   392.525     0.150
    32.465   459.025     0.150
    32.465   560.326     0.150
    32.465   705.826     0.150
    32.465   784.326     0.150
    32.465   820.025     0.150
    32.849   396.625     0.150
    32.849   396.326     0.150
    33.152   396.525     0.150
    33.431   398.826     0.150
    33.431   470.525     0.150
    33.431   717.826     0.150
    33.431   785.525     0.150
    33.431   839.826     0.150
    33.431  1023.025     0.150
    33.446   402.225     0.150
    33.522   401.705     0.150
    33.639   403.826     0.150
    33.819   404.125     0.150
    33.819   483.225     0.150
    33.819   403.725     0.150
    33.846   405.725     0.150
    34.030   406.225     0.150
    34.727   414.125     0.150
    34.780   414.525     0.150
    34.834   413.725     0.150
    34.917   414.725     0.150
    34.958   413.826     0.150
    35.251   419.225     0.150
    35.667   421.625     0.150
    35.839   500.725     0.150
    35.910   423.525     0.150
    35.924   423.096     0.150
    36.007   423.225     0.150
    36.146   426.125     0.150
    36.168   425.725     0.150
    36.463   429.125     0.150
    36.779   430.725     0.150
    36.801   430.725     0.150
    36.807   431.426     0.150
    36.828   429.426     0.150
    36.891   431.426     0.150
    36.946   433.326     0.150
    37.027   433.426     0.150
    37.199   434.625     0.150
    37.199   434.125     0.150
    37.204   434.125     0.150
    37.272   435.525     0.150
    37.357   434.426     0.150
    37.477   436.725     0.150
    37.449   436.326     0.150
    37.559   437.326     0.150
    37.566   435.686     0.150
    37.584   436.826     0.150
    37.604   432.426     0.150
    37.749   438.926     0.150
    37.769   439.025     0.150
    37.769   438.906     0.150
    37.769   439.225     0.150
    37.949   440.426     0.150
    37.986   441.225     0.150
    38.110   439.125     0.150
    38.269   444.225     0.150
    38.278   443.625     0.150
    38.371   443.125     0.150
    38.387   442.025     0.150
    38.434   443.426     0.150
    38.578   446.426     0.150
    38.634   445.426     0.150
    38.699   447.426     0.150
    38.699    12.299     0.150
    38.730   446.725     0.150
    38.993   448.205     0.150
    38.994   578.125     0.150
    39.020   447.326     0.150
    39.138   450.125     0.150
    39.138    12.301     0.150
    39.165   449.625     0.150
    39.173   449.326     0.150
    39.266   450.725     0.150
    39.314   452.025     0.150
    39.349   452.326     0.150
    39.512   454.426     0.150
    39.512   454.016     0.150
    39.513   452.926     0.150
    39.694   454.225     0.150
    40.023   460.625     0.150
    40.365   460.426     0.150
    40.412   462.857     0.150
    40.412   462.625     0.150
    40.412   459.916     0.150
    40.522   462.625     0.150
    40.607   462.525     0.150
    40.697   461.326     0.150
    40.739   463.826     0.150
    40.765   464.426     0.150
    41.123   466.496     0.150
    41.327   465.725     0.150
    41.327   465.326     0.150
    41.267   466.773     0.150
    41.267   466.225     0.150
    41.267   466.486     0.150
    41.625   471.025     0.150
    41.639   470.225     0.150
    41.731   472.426     0.150
    41.928   473.525     0.150
    41.928   473.686     0.150
    41.963   473.426     0.150
    41.963   473.725     0.150
    42.030   474.006     0.150
    42.131   475.426     0.150
    42.131     5.199     0.150
    42.224   475.486     0.150
    42.357   476.525     0.150
    42.455   477.326     0.150
    42.475   478.246     0.150
    42.595   481.332     0.150
    42.686   477.326     0.150
    42.766   479.906     0.150
    42.783   479.975     0.150
    42.839   480.799     0.150
    43.009   480.926     0.150
    43.009   591.926     0.150
    43.009   481.586     0.150
    43.031   483.025     0.150
    43.045   481.836     0.150
    43.068   483.025     0.150
    43.068   586.725     0.150
    43.068    11.900     0.150
    43.300   484.236     0.150
    43.453   485.605     0.150
    43.453   869.525     0.150
    43.453  1064.525     0.150
    43.453   486.025     0.150
    43.474   484.525     0.150
    43.564   487.055     0.150
    43.637   486.826     0.150
    43.637   487.125     0.150
    43.637   487.025     0.150
    43.637   591.125     0.150
    43.709   487.426     0.150
    43.709   590.326     0.150
    43.709     7.900     0.150
    43.709   487.555     0.150
    44.048   490.326     0.150
    44.048   591.525     0.150
    44.048  1098.525     0.150
    44.296   492.125     0.150
    44.400   493.725     0.150
    44.413   493.926     0.150
    44.582   495.525     0.150
    44.638   495.926     0.150
    44.614   494.854     0.150
    44.820   496.725     0.150
    45.116   497.330     0.150
    45.130   499.189     0.150
    45.130   499.025     0.150
    45.130   498.486     0.150
    45.224   500.926     0.150
    45.225   500.326     0.150
    45.470   500.514     0.150
    45.687   502.701     0.150
    45.756   502.863     0.150
    45.774   502.025     0.150
    45.774   502.426     0.150
    45.754   504.145     0.150
    45.833   504.826     0.150
    45.905   503.055     0.150
    46.117   507.926     0.150
    46.304   507.369     0.150
    46.459   508.826     0.150
    46.459   508.826     0.150
    46.629   511.426     0.150
    46.629   511.787     0.150
    47.231   516.826     0.150
    47.507   517.826     0.150
    47.634   517.025     0.150
    47.919   519.426     0.150
    48.021   521.725     0.150
    48.084   520.926     0.150
    48.084   520.627     0.150
    48.180   522.246     0.150
    48.261   520.926     0.150
    48.276   522.426     0.150
    48.357   523.926     0.150
    48.498   525.535     0.150
    48.498    10.770     0.150
    48.498   525.926     0.150
    48.508   526.076     0.150
    48.508   526.225     0.150
    48.508   524.125     0.150
    48.587   524.826     0.150
    48.697   526.125     0.150
    48.707   526.125     0.150
    48.797   526.826     0.150
    48.818   527.025     0.150
    48.824   527.525     0.150
    48.925   528.225     0.150
    48.969   528.225     0.150
    49.014   529.314     0.150
    49.014   528.826     0.150
    49.375   531.525     0.150
    49.406   530.826     0.150
    49.428   531.625     0.150
    49.709   534.525     0.150
    49.745   535.020     0.150
    49.745   535.125     0.150
    49.745   534.525     0.150
    50.041   536.906     0.150
    50.260   537.725     0.150
    50.365   538.426     0.150
    50.429   540.936     0.150
    50.429   540.725     0.150
    50.429   539.936     0.150
    50.488   539.525     0.150
    50.638   540.426     0.150
    50.792   541.625     0.150
    50.994   543.426     0.150
    51.037   545.836     0.150
    51.037   545.725     0.150
    51.037   544.775     0.150
    51.664   548.525     0.150
    52.057   551.525     0.150
    52.044   551.752     0.150
    52.321   553.025     0.150
    52.350   553.926     0.150
    52.746   556.025     0.150
    52.945   557.725     0.150
    52.969   557.826     0.150
    53.187   559.426     0.150
    53.267   559.826     0.150
    53.339   563.197     0.150
    53.339   563.525     0.150
    53.339   562.135     0.150
    53.437   561.426     0.150
    53.418   561.555     0.150
    54.399   569.625     0.150
    54.402   568.725     0.150
    54.627   569.926     0.150
    54.630   569.625     0.150
    54.632   570.225     0.150
    54.848   571.426     0.150
    54.879   571.525     0.150
    56.842   586.926     0.150
    56.946   586.826     0.150
    57.827   592.055     0.150
    57.827   593.006     0.150
    59.518   606.525     0.150
    59.964   609.725     0.150
    59.985   609.125     0.150
    60.030   610.025     0.150
    60.153   609.725     0.150
    60.289   612.025     0.150
    60.307   610.725     0.150
    60.395   612.426     0.150
    60.602   611.826     0.150
    61.178   616.426     0.150
    61.260   616.426     0.150
    61.263   618.225     0.150
    62.252   620.826     0.150
    63.010   629.125     0.150
    63.010   630.525     0.150
    63.221   630.125     0.150
    64.827   638.615     0.150
    64.827   638.756     0.150
    69.639   671.826     0.150
    71.561   682.725     0.150
    72.369   688.426     0.150
    73.732   694.625     0.150
    73.807   694.525     0.150
    73.882   695.025     0.150
    74.119   696.525     0.150
    74.200   698.406     0.150
    74.456   698.805     0.150
    74.610   699.035     0.150
    74.663   698.895     0.150
    75.406   705.025     0.150
    75.406   704.525     0.150
    76.354   709.426     0.150
    76.885   712.385     0.150
    76.962   712.926     0.150
    77.266   713.625     0.150
    77.579   716.656     0.150
    77.689   717.225     0.150
    78.424   721.336     0.150
    78.855   721.105     0.150
    79.398   726.285     0.150
    79.459   726.125     0.150
    80.727   735.436     0.150
    81.103   735.814     0.150
    81.488   738.326     0.150
    81.497   738.125     0.150
    81.497   739.125     0.150
    82.728   745.285     0.150
    83.625   748.926     0.150
    83.623   749.525     0.150
    83.623   749.525     0.150
    83.917   750.756     0.150
    84.677   754.525     0.150
    90.343   781.625     0.150
    92.944   794.725     0.150
    94.086   800.025     0.150
    94.086   798.576     0.150
    95.039   803.025     0.150
   103.454  1101.625     0.150
   107.381  1110.156     0.150
   116.574  1126.225     0.150
   116.574  1753.455     0.150
   123.457  1136.385     0.150
   123.951  1138.115     0.150
   127.394  1147.855     0.150
   128.268  1147.846     0.150
   128.616  1150.596     0.150
   130.295  1152.385     0.150
   132.586  1157.605     0.150
   134.225  1158.826     0.150
   134.764  1162.605     0.150
   138.464  1168.225     0.150
   138.464  1168.656     0.150
   148.171  1186.926     0.150
     1.152    20.399     0.150
     1.152    21.199     0.150
     1.418    26.399     0.150
     2.060    37.099     0.150
     2.507    43.999     0.150
     4.441    70.845     0.150
     4.441   123.324     0.150
     4.441    70.399     0.150
     5.412    82.759     0.150
     5.412   145.569     0.150
     5.915    87.399     0.150
     5.915   157.599     0.150
     6.610    97.999     0.150
     6.610   171.959     0.150
     6.646   103.099     0.150
     6.646   167.499     0.150
     7.693   111.489     0.150
     7.693   197.859     0.150
     7.990   119.039     0.150
     8.089   120.108     0.150
     8.089   211.635     0.150
     8.089   119.699     0.150
     8.220   118.099     0.150
     8.220   207.699     0.150
     8.306   123.479     0.150
     8.412   125.039     0.150
     8.510   125.699     0.150
     8.510   125.949     0.150
     8.510   124.879     0.150
     8.510   219.029     0.150
     8.542   125.974     0.150
     8.542   220.919     0.150
     8.542   125.699     0.150
     8.542   125.399     0.150
     8.542   220.049     0.150
     8.676   128.567     0.150
     8.676   224.820     0.150
     8.676   128.143     0.150
     8.676   226.068     0.150
     8.676   275.343     0.150
     8.676   127.699     0.150
     8.676   128.309     0.150
     8.821   126.699     0.150
     8.821   224.699     0.150
     8.829   130.649     0.150
     8.892   130.699     0.150
     8.892   234.199     0.150
     8.930   132.219     0.150
     9.082   133.779     0.150
     9.261   136.289     0.150
     9.277   135.963     0.150
     9.277   135.699     0.150
     9.277   136.269     0.150
     9.754   139.299     0.150
     9.754   249.099     0.150
    10.074   146.999     0.150
    10.036   147.294     0.150
    10.036   259.688     0.150
    10.306   149.641     0.150
    10.306   264.650     0.150
    10.506   151.299     0.150
    10.507   150.999     0.150
    10.507   270.824     0.150
    10.507   343.091     0.150
    11.275   157.659     0.150
    11.238   160.898     0.150
    11.238   289.736     0.150
    11.238   161.499     0.150
    11.450   161.699     0.150
    11.450   283.699     0.150
    12.815   179.809     0.150
    12.938   181.999     0.150
    13.134   184.899     0.150
    13.778   192.899     0.150
    13.757   194.744     0.150
    13.757   347.790     0.150
    14.339   200.199     0.150
    14.374   200.199     0.150
    14.574   202.899     0.150
    14.586   203.099     0.150
    14.767   205.199     0.150
    14.929   217.549     0.150
    14.929   215.798     0.150
    15.031   211.269     0.150
    15.145   213.129     0.150
    15.158   214.235     0.150
    15.158   214.699     0.150
    15.158   212.324     0.150
    15.158   392.125     0.150
    15.158   490.550     0.150
    15.158   214.099     0.150
    15.356   213.259     0.150
    15.356   374.639     0.150
    15.368   218.469     0.150
    15.571   225.859     0.150
    15.618   220.869     0.150
    15.746   228.694     0.150
    15.762   225.039     0.150
    15.813   219.099     0.150
    15.890   229.733     0.150
    15.965   230.195     0.150
    16.169   232.879     0.150
    16.242   224.699     0.150
    16.242   228.379     0.150
    16.247   226.199     0.150
    16.247   231.599     0.150
    16.247   407.699     0.150
    16.247   412.699     0.150
    16.428   236.301     0.150
    16.451   227.099     0.150
    16.458   227.699     0.150
    16.617   231.134     0.150
    16.617   409.744     0.150
    16.617   231.699     0.150
    16.617   231.689     0.150
    16.617   407.429     0.150
    17.073   237.869     0.150
    17.115   236.056     0.150
    17.115   236.674     0.150
    17.115   435.085     0.150
    17.115   551.945     0.150
    17.206   239.949     0.150
    17.223   236.699     0.150
    17.223   435.099     0.150
    17.223   238.569     0.150
    17.308   240.909     0.150
    17.501   245.029     0.150
    18.170   250.599     0.150
    18.170   251.679     0.150
    18.287   252.058     0.150
    18.287   451.462     0.150
    18.287   252.624     0.150
    18.287   454.464     0.150
    18.470   253.948     0.150
    18.470   254.911     0.150
    18.470   459.964     0.150
    18.538   257.019     0.150
    18.538   464.169     0.150
    18.540   254.699     0.150
    18.540   464.699     0.150
    18.540   468.699     0.150
    18.504   254.101     0.150
    18.504   254.899     0.150
    18.504   255.499     0.150
    18.504   256.059     0.150
    19.123   261.998     0.150
    19.605   268.099     0.150
    19.716   266.599     0.150
    19.716   491.099     0.150
    19.879   272.269     0.150
    19.879   491.949     0.150
    19.923   273.019     0.150
    20.059   273.839     0.150
    20.331   275.009     0.150
    20.464   277.409     0.150
    20.464   500.639     0.150
    20.499   277.939     0.150
    20.499   506.009     0.150
    20.501   278.519     0.150
    20.501   506.139     0.150
    20.576   277.699     0.150
    20.576   497.199     0.150
    20.878   283.699     0.150
    21.145   287.999     0.150
    21.145   288.318     0.150
    21.145   288.169     0.150
    21.399   289.599     0.150
    21.498   291.499     0.150
    21.888   295.169     0.150
    21.881   291.199     0.150
    21.881   531.999     0.150
    21.881   291.374     0.150
    21.881   530.142     0.150
    22.048   297.499     0.150
    22.215   298.389     0.150
    22.166   295.499     0.150
    22.166   535.999     0.150
    22.166   575.199     0.150
    22.263   299.799     0.150
    22.329   297.879     0.150
    22.315   298.559     0.150
    22.508   301.699     0.150
    22.553   302.039     0.150
    22.610   300.899     0.150
    22.835   305.139     0.150
    22.941   306.259     0.150
    22.979   305.119     0.150
    23.126   308.969     0.150
    23.162   304.329     0.150
    23.159   305.799     0.150
    23.172   309.899     0.150
    23.298   309.639     0.150
    23.262   307.599     0.150
    23.262   560.299     0.150
    23.361   308.499     0.150
    23.361   559.999     0.150
    23.395   310.409     0.150
    23.398   310.859     0.150
    23.497   311.709     0.150
    23.523   312.887     0.150
    23.553   311.489     0.150
    23.614   312.359     0.150
    23.702   315.039     0.150
    23.631   310.899     0.150
    23.825   315.459     0.150
    23.909   314.799     0.150
    23.909   573.599     0.150
    23.909   579.999     0.150
    24.350   317.499     0.150
    24.350   316.599     0.150
    24.375   320.299     0.150
    24.996   326.149     0.150
    25.334   329.119     0.150
    25.385   326.299     0.150
    25.385   360.199     0.150
    25.385   591.299     0.150
    25.385   608.999     0.150
    25.516   330.449     0.150
    25.700   332.179     0.150
    26.099   334.839     0.150
    26.142   337.179     0.150
    26.355   337.729     0.150
    26.464   339.259     0.150
    26.495   334.139     0.150
    26.591   337.299     0.150
    26.687   340.129     0.150
    26.694   340.969     0.150
    26.853   341.699     0.150
    27.124   343.479     0.150
    27.209   342.439     0.150
    27.222   343.599     0.150
    27.222   624.199     0.150
    27.244   345.859     0.150
    27.284   343.709     0.150
    27.229   345.499     0.150
    27.229   390.099     0.150
    27.229   622.199     0.150
    27.229   630.999     0.150
    27.229   697.699     0.150
    27.303   345.209     0.150
    27.325   343.629     0.150
    27.464   346.419     0.150
    27.513   345.219     0.150
    27.534   348.979     0.150
    27.638   349.089     0.150
    27.640   349.769     0.150
    27.697   349.619     0.150
    27.867   347.299     0.150
    27.827   350.199     0.150
    27.988   352.199     0.150
    28.044   351.736     0.150
    28.053   350.699     0.150
    28.064   348.279     0.150
    28.042   350.299     0.150
    28.191   353.499     0.150
    28.191   400.999     0.150
    28.191   637.599     0.150
    28.191   645.499     0.150
    28.543   354.029     0.150
    28.690   358.189     0.150
    28.641   356.899     0.150
    28.746   355.279     0.150
    28.769   357.299     0.150
    28.921   359.859     0.150
    29.076   361.355     0.150
    29.076   547.130     0.150
    29.085   361.189     0.150
    29.337   362.789     0.150
    29.337   363.199     0.150
    29.337   418.099     0.150
    29.337   659.099     0.150
    29.337   743.999     0.150
    29.448   364.499     0.150
    29.448   656.499     0.150
    29.576   366.309     0.150
    29.574   365.299     0.150
    29.574   663.799     0.150
    29.647   366.116     0.150
    29.647   550.199     0.150
    29.647   366.399     0.150
    29.795   367.969     0.150
    29.769   366.509     0.150
    29.851   367.980     0.150
    29.859   366.789     0.150
    29.985   367.699     0.150
    30.019   368.189     0.150
    30.052   369.789     0.150
    30.170   370.269     0.150
    30.294   372.619     0.150
    30.294   372.069     0.150
    30.308   367.689     0.150
    30.290   371.799     0.150
    30.290   371.935     0.150
    30.290   371.559     0.150
    30.380   371.739     0.150
    30.827   376.609     0.150
    30.896   376.899     0.150
    31.152   378.399     0.150
    31.152   439.799     0.150
    31.152   684.299     0.150
    31.152   378.599     0.150
    31.643   384.279     0.150
    31.670   382.999     0.150
    31.986   383.629     0.150
    32.092   387.299     0.150
    32.105   386.199     0.150
    32.105   456.099     0.150
    32.105   557.999     0.150
    32.105   779.699     0.150
    32.105   812.199     0.150
    32.214   388.539     0.150
    32.308   391.199     0.150
    32.453   387.239     0.150
    32.664   392.899     0.150
    32.914   394.699     0.150
    32.914   712.799     0.150
    32.914   717.599     0.150
    32.976   392.599     0.150
    33.029   394.339     0.150
    33.106   396.529     0.150
    33.334   398.899     0.150
    33.498   399.699     0.150
    33.580   400.699     0.150
    33.580   400.489     0.150
    33.721   402.299     0.150
    33.834   402.999     0.150
    33.850   402.899     0.150
    33.847   401.749     0.150
    33.847   559.939     0.150
    33.847   402.099     0.150
    33.847   401.799     0.150
    33.847   401.959     0.150
    33.877   402.449     0.150
    33.989   404.899     0.150
    34.279   405.859     0.150
    34.287   407.499     0.150
    34.841   412.599     0.150
    34.894   413.099     0.150
    34.937   412.999     0.150
    35.367   415.799     0.150
    35.295   414.899     0.150
    35.372   417.799     0.150
    35.385   415.199     0.150
    35.619   415.699     0.150
    35.806   420.299     0.150
    35.996   422.099     0.150
    36.000   422.099     0.150
    36.000   421.619     0.150
    36.259   423.899     0.150
    36.291   424.799     0.150
    36.310   423.699     0.150
    36.327   424.399     0.150
    36.317   422.699     0.150
    36.455   424.879     0.150
    36.484   426.199     0.150
    36.484   769.599     0.150
    36.682   427.899     0.150
    36.749   427.459     0.150
    36.847   428.329     0.150
    36.862   428.509     0.150
    36.956   430.499     0.150
    36.993   429.599     0.150
    37.016   430.499     0.150
    37.016   777.499     0.150
    37.073   431.299     0.150
    37.104   430.199     0.150
    37.104   429.779     0.150
    37.216   431.499     0.150
    37.160   429.399     0.150
    37.277   432.099     0.150
    37.365   433.399     0.150
    37.397   432.499     0.150
    37.404   433.399     0.150
    37.449   432.299     0.150
    37.532   434.199     0.150
    37.600   434.799     0.150
    37.660   437.199     0.150
    37.722   434.899     0.150
    37.734   434.199     0.150
    37.778   436.099     0.150
    37.825   437.099     0.150
    37.825   437.199     0.150
    37.817   437.599     0.150
    37.964   438.309     0.150
    38.022   438.499     0.150
    38.022   791.499     0.150
    38.054   439.199     0.150
    38.054   523.299     0.150
    38.054   573.899     0.150
    38.129   439.099     0.150
    38.154   438.399     0.150
    38.157   436.299     0.150
    38.157   796.199     0.150
    38.220   439.499     0.150
    38.365   442.099     0.150
    38.430   440.899     0.150
    38.430   440.759     0.150
    38.430     1.000     0.150
    38.597   442.399     0.150
    38.744   444.369     0.150
    38.760   449.199     0.150
    38.760   572.799     0.150
    38.853   444.799     0.150
    38.864   444.099     0.150
    38.864   444.399     0.150
    38.921   443.999     0.150
    39.215   447.599     0.150
    39.307   450.699     0.150
    39.271   538.699     0.150
    39.366   447.899     0.150
    39.387   448.199     0.150
    39.376   450.899     0.150
    39.473   450.299     0.150
    39.596   452.699     0.150
    39.630   452.299     0.150
    39.760   451.499     0.150
    39.744   452.899     0.150
    39.744   452.569     0.150
    39.888   451.099     0.150
    39.909   456.199     0.150
    39.909   544.799     0.150
    39.909   576.199     0.150
    39.950   450.799     0.150
    39.987   454.279     0.150
    40.240   456.999     0.150
    40.308   456.999     0.150
    40.311   458.099     0.150
    40.311   578.499     0.150
    40.358   458.019     0.150
    40.474   459.499     0.150
    40.474   459.399     0.150
    40.796   461.899     0.150
    41.181   465.699     0.150
    41.181   465.169     0.150
    41.216   463.879     0.150
    41.317   463.759     0.150
    41.556   468.099     0.150
    41.556   468.199     0.150
    41.587   469.699     0.150
    41.658   468.299     0.150
    41.678   468.899     0.150
    41.795   470.499     0.150
    41.849   470.499     0.150
    41.977   471.999     0.150
    42.117   472.859     0.150
    42.178   473.299     0.150
    42.308   474.607     0.150
    42.454   476.699     0.150
    42.450   473.609     0.150
    42.519   476.199     0.150
    42.519  1060.899     0.150
    42.569   476.599     0.150
    42.678   476.499     0.150
    42.678   475.299     0.150
    42.678   476.399     0.150
    42.664   474.799     0.150
    42.780   477.219     0.150
    42.780   476.817     0.150
    42.780   476.459     0.150
    42.884   479.029     0.150
    42.886   479.129     0.150
    42.940   479.947     0.150
    42.965   479.699     0.150
    42.938   478.299     0.150
    43.072   480.199     0.150
    43.123   481.199     0.150
    43.123   870.099     0.150
    43.286   482.760     0.150
    43.340   483.159     0.150
    43.340   589.549     0.150
    43.385   482.794     0.150
    43.495   483.879     0.150
    43.495   589.859     0.150
    43.495  1077.699     0.150
    43.708   485.399     0.150
    43.708   485.225     0.150
    43.708   591.499     0.150
    43.776   485.799     0.150
    43.776  1082.799     0.150
    43.776   485.329     0.150
    43.871   486.709     0.150
    43.899   487.118     0.150
    43.881   486.569     0.150
    43.881  1074.829     0.150
    44.084   487.399     0.150
    44.084   870.699     0.150
    44.084   590.699     0.150
    44.084   487.599     0.150
    44.662   492.597     0.150
    44.713   492.499     0.150
    44.875   493.619     0.150
    44.875  1091.449     0.150
    44.992   497.029     0.150
    45.074   496.109     0.150
    45.074     1.240     0.150
    45.176   496.709     0.150
    45.207   497.058     0.150
    45.240   496.842     0.150
    45.282   498.820     0.150
    45.355   500.069     0.150
    45.447   500.069     0.150
    45.478   498.309     0.150
    45.513   500.919     0.150
    45.559   499.436     0.150
    45.677   499.399     0.150
    45.677   499.374     0.150
    45.775   501.436     0.150
    45.849   501.809     0.150
    45.851   500.769     0.150
    45.825   500.099     0.150
    45.904   501.829     0.150
    45.921   501.849     0.150
    45.921  1114.299     0.150
    45.950   502.589     0.150
    45.952   502.859     0.150
    45.952   598.579     0.150
    45.952   502.855     0.150
    45.952   598.574     0.150
    46.215   503.929     0.150
    46.215     1.640     0.150
    46.188   502.659     0.150
    46.188   611.339     0.150
    46.327   504.179     0.150
    46.327  1124.329     0.150
    46.327   504.809     0.150
    46.393   506.344     0.150
    46.383   507.499     0.150
    46.683   508.749     0.150
    46.682   508.599     0.150
    46.823   508.539     0.150
    46.823  1126.739     0.150
    46.861   509.869     0.150
    47.185   513.499     0.150
    47.491   514.629     0.150
    47.544   514.713     0.150
    47.748   515.199     0.150
    47.803   516.719     0.150
    47.912   521.869     0.150
    47.912   629.409     0.150
    47.912  1147.009     0.150
    48.120   521.579     0.150
    48.278   521.219     0.150
    48.490   520.349     0.150
    48.506   520.719     0.150
    48.540   523.439     0.150
    48.562   524.579     0.150
    48.562   522.979     0.150
    48.577   522.859     0.150
    48.938   526.379     0.150
    48.938   523.699     0.150
    48.938   607.399     0.150
    48.938   637.199     0.150
    48.938   945.799     0.150
    48.938   962.499     0.150
    48.938  1113.499     0.150
    48.938  1158.599     0.150
    49.243   528.599     0.150
    49.243   529.369     0.150
    49.283   528.999     0.150
    49.285   529.009     0.150
    49.286   529.339     0.150
    49.288   528.839     0.150
    49.288   528.909     0.150
    49.288   529.079     0.150
    49.288   528.507     0.150
    49.289   528.919     0.150
    49.290   528.029     0.150
    49.504   531.079     0.150
    49.645   532.509     0.150
    50.374   536.959     0.150
    50.463   538.099     0.150
    50.409   536.429     0.150
    50.853   542.099     0.150
    50.832   542.109     0.150
    51.068   542.499     0.150
    51.288   543.699     0.150
    51.448   547.099     0.150
    51.669   546.699     0.150
    52.143   550.699     0.150
    54.112   563.399     0.150
    54.115   563.799     0.150
    54.117   564.224     0.150
    56.304   581.299     0.150
    56.296   580.499     0.150
    56.472   580.499     0.150
    57.113   587.299     0.150
    57.665   590.449     0.150
    57.922   591.949     0.150
    57.977   591.849     0.150
    58.302   594.029     0.150
    58.771   598.399     0.150
    59.461   604.599     0.150
    59.643   604.299     0.150
    60.106   607.699     0.150
    60.285   609.299     0.150
    60.285   608.009     0.150
    60.561   609.099     0.150
    62.757   624.899     0.150
    62.757   624.549     0.150
    63.475   631.299     0.150
    63.778   632.039     0.150
    65.223   638.499     0.150
    65.223   639.319     0.150
    65.223   639.524     0.150
    72.548   686.019     0.150
    72.925   689.699     0.150
    73.970   693.809     0.150
    74.142   695.124     0.150
    74.142   695.499     0.150
    74.115   695.769     0.150
    74.218   695.699     0.150
    74.290   694.799     0.150
    74.374   697.169     0.150
    75.674   703.459     0.150
    75.961   705.949     0.150
    75.961   706.599     0.150
    75.900   704.799     0.150
    75.900   705.049     0.150
    76.008   705.659     0.150
    76.318   707.719     0.150
    76.681   708.879     0.150
    76.698   709.959     0.150
    76.784   709.774     0.150
    76.765   709.399     0.150
    76.778   708.839     0.150
    76.778   708.749     0.150
    76.859   710.319     0.150
    77.077   711.379     0.150
    77.195   712.279     0.150
    77.492   713.419     0.150
    77.947   716.519     0.150
    78.370   718.279     0.150
    78.647   720.179     0.150
    78.657   720.139     0.150
    78.923   721.809     0.150
    78.922   722.209     0.150
    78.960   721.819     0.150
    78.979   722.159     0.150
    79.206   723.679     0.150
    79.220   724.749     0.150
    79.228   722.589     0.150
    79.840   727.639     0.150
    80.028   727.099     0.150
    80.704   732.809     0.150
    81.176   733.374     0.150
    81.360   735.199     0.150
    81.360  1851.699     0.150
    81.360   735.699     0.150
    81.369   735.999     0.150
    81.369   735.699     0.150
    81.418   735.579     0.150
    83.211   744.394     0.150
    83.525   746.249     0.150
    83.525  1846.899     0.150
    83.706   747.499     0.150
    85.794   757.799     0.150
    90.151   778.879     0.150
    90.849   782.129     0.150
    92.532   790.199     0.150
    94.706   799.399     0.150
   108.517  1137.919     0.150
   116.219  1123.313     0.150
   117.411  1123.193     0.150
   118.420  1125.945     0.150
   118.576  1126.405     0.150
   119.227  1127.561     0.150
   124.349  1136.899     0.150
   128.636  1148.687     0.150
   130.530  1150.969     0.150
   134.646  1157.499     0.150
   134.779  1159.579     0.150
   138.737  1166.844     0.150
   138.737  1167.749     0.150
   142.607  1173.663     0.150
   145.417  1177.499     0.150
   146.651  1182.809     0.150
   148.687  1187.219     0.150
   148.687  1187.519     0.150
     1.149    20.304     0.150
     1.405    26.334     0.150
     2.036    36.134     0.150
     2.500    43.334     0.150
     3.197    51.334     0.150
     4.470    70.257     0.150
     4.470   123.300     0.150
     5.902    88.434     0.150
     6.597    97.114     0.150
     6.597   171.264     0.150
     6.597   171.464     0.150
     7.897   114.704     0.150
     7.897   196.934     0.150
     8.121   120.080     0.150
     8.121   211.125     0.150
     8.201   206.434     0.150
     8.542   126.334     0.150
     8.542   218.034     0.150
     8.574   125.548     0.150
     8.574   219.446     0.150
     8.574   125.044     0.150
     8.574   219.964     0.150
     8.707   127.552     0.150
     8.707   226.057     0.150
     8.707   128.228     0.150
     8.707   223.706     0.150
     9.308   136.044     0.150
     9.742   139.534     0.150
    10.516   150.761     0.150
    12.928   181.534     0.150
    13.123   183.434     0.150
    13.768   192.134     0.150
    14.329   199.434     0.150
    14.364   199.534     0.150
    14.577   202.934     0.150
    14.758   204.834     0.150
    15.187   215.467     0.150
    15.187   214.154     0.150
    15.187   214.158     0.150
    15.187   215.254     0.150
    15.803   217.734     0.150
    16.443   226.834     0.150
    16.449   226.734     0.150
    16.644   231.208     0.150
    16.644   410.474     0.150
    16.644   231.354     0.150
    16.644   408.774     0.150
    17.146   239.287     0.150
    17.254   239.284     0.150
    18.314   252.093     0.150
    18.314   450.708     0.150
    18.314   253.484     0.150
    18.314   449.178     0.150
    18.502   254.617     0.150
    18.502   255.023     0.150
    18.536   254.564     0.150
    18.536   255.374     0.150
    19.155   263.010     0.150
    21.911   291.569     0.150
    21.911   526.927     0.150
    21.915   291.564     0.150
    21.915   526.924     0.150
    23.172   305.809     0.150
    24.335   316.354     0.150
    29.655   365.934     0.150
    29.655   365.934     0.150
    29.873   367.374     0.150
    29.873   367.370     0.150
    29.975   366.844     0.150
    29.975   366.846     0.150
    33.865   400.685     0.150
    33.865   400.684     0.150
    37.108   429.378     0.150
    38.889   444.064     0.150
    38.889   444.059     0.150
    41.298   463.414     0.150
    42.808   476.464     0.150
    42.808   476.461     0.150
    43.723   482.238     0.150
    43.723   590.470     0.150
    45.700   498.734     0.150
    45.700   499.034     0.150
    45.700   499.034     0.150
    47.161   512.168     0.150
    49.251   527.859     0.150
    57.989   591.429     0.150
    65.218   639.034     0.150
    65.219   639.034     0.150
    75.935   705.327     0.150
    75.932   704.084     0.150
    76.810   708.834     0.150
    81.347   734.584     0.150
    83.243   743.487     0.150
    83.510   746.206     0.150
     1.042    19.236     0.150
     1.513    27.637     0.150
     2.121    38.037     0.150
     2.610    44.537     0.150
     3.286    52.438     0.150
     4.411    69.504     0.150
     4.411   122.338     0.150
     5.390    81.137     0.150
     5.512    83.727     0.150
     5.512   142.467     0.150
     6.010    88.938     0.150
     6.369    93.736     0.150
     6.369   164.137     0.150
     6.705    99.137     0.150
     6.705   172.326     0.150
     6.716   166.137     0.150
     8.110   120.156     0.150
     8.110   211.861     0.150
     8.110   120.336     0.150
     8.300   122.137     0.150
     8.300   209.137     0.150
     8.543   124.498     0.150
     8.543   221.096     0.150
     8.543   124.736     0.150
     8.543   224.637     0.150
     8.714   128.307     0.150
     8.714   227.480     0.150
     8.714   129.725     0.150
     8.714   228.338     0.150
     8.714   128.537     0.150
     8.930   134.137     0.150
     8.930   237.137     0.150
     9.322   136.297     0.150
     9.322   239.314     0.150
    10.406   149.943     0.150
    11.269   160.348     0.150
    11.302   163.795     0.150
    12.600   177.037     0.150
    12.871   181.506     0.150
    12.871   317.146     0.150
    13.232   186.137     0.150
    13.878   194.236     0.150
    14.438   200.537     0.150
    14.474   201.137     0.150
    14.673   203.938     0.150
    14.686   204.236     0.150
    14.868   207.736     0.150
    15.232   212.137     0.150
    15.204   215.367     0.150
    15.217   215.316     0.150
    15.217   215.438     0.150
    15.217   215.857     0.150
    15.217   215.861     0.150
    15.217   217.137     0.150
    15.217   215.396     0.150
    15.913   219.836     0.150
    16.571   230.438     0.150
    16.571   412.561     0.150
    16.571   231.197     0.150
    17.148   239.211     0.150
    17.296   240.967     0.150
    17.256   240.236     0.150
    17.256   241.416     0.150
    18.239   252.812     0.150
    18.239   448.461     0.150
    18.239   253.314     0.150
    18.470   254.674     0.150
    18.503   254.775     0.150
    18.503   255.037     0.150
    18.503   255.756     0.150
    19.691   270.336     0.150
    21.044   287.236     0.150
    21.044   282.326     0.150
    21.924   292.312     0.150
    21.927   292.307     0.150
    22.132   296.836     0.150
    23.065   305.711     0.150
    23.078   309.836     0.150
    23.268   308.438     0.150
    23.314   307.426     0.150
    23.314   308.236     0.150
    23.314   334.836     0.150
    23.314   549.236     0.150
    23.314   307.617     0.150
    24.011   315.537     0.150
    29.545   364.938     0.150
    29.545   364.938     0.150
    29.545   365.336     0.150
    29.946   370.836     0.150
    30.206   366.326     0.150
    30.377   372.037     0.150
    31.084   377.137     0.150
    33.765   400.961     0.150
    33.765   400.938     0.150
    36.143   421.037     0.150
    38.805   444.176     0.150
    38.805   443.736     0.150
    38.805   443.688     0.150
    42.740   476.062     0.150
    43.620   484.236     0.150
    45.074   495.176     0.150
    45.382   497.027     0.150
    45.564   498.768     0.150
    45.576   498.457     0.150
    45.613   498.438     0.150
    45.613   498.688     0.150
    45.613   498.688     0.150
    45.787   499.727     0.150
    45.822   500.006     0.150
    45.861   500.857     0.150
    47.787   515.137     0.150
    50.385   536.438     0.150
    53.227   558.057     0.150
    56.355   580.537     0.150
    65.113   638.916     0.150
    65.113   638.916     0.150
    65.113   638.912     0.150
    72.852   689.336     0.150
    75.891   706.035     0.150
    75.917   704.438     0.150
    76.348   707.547     0.150
    76.807   709.273     0.150
    76.807   709.277     0.150
    80.166   730.176     0.150
    81.454   736.137     0.150
    81.454   736.137     0.150
    81.463   735.785     0.150
    83.215   744.184     0.150
    83.215   744.188     0.150
    83.529   747.438     0.150
    83.615   747.035     0.150
    83.615   747.035     0.150
    83.646   747.078     0.150
   116.207  1122.957     0.150
   148.586  1187.836     0.150
     1.576    27.779     0.150
     2.051    35.480     0.150
     2.214    38.580     0.150
     3.161    50.080     0.150
     4.165    65.150     0.150
     4.283    67.529     0.150
     4.602    71.680     0.150
     4.602   126.680     0.150
     5.119    77.090     0.150
     5.119   138.320     0.150
     5.320    82.180     0.150
     6.238   157.180     0.150
     6.352    93.209     0.150
     6.352   165.760     0.150
     7.432   108.119     0.150
     7.432   191.910     0.150
     7.432   110.234     0.150
     7.691   113.820     0.150
     7.985   117.840     0.150
     8.062   117.180     0.150
     8.070   118.500     0.150
     8.148   117.590     0.150
     8.192   214.361     0.150
     8.216   120.840     0.150
     8.325   120.590     0.150
     8.325   204.719     0.150
     8.360   121.029     0.150
     8.360   214.336     0.150
     8.360   121.580     0.150
     8.360   121.680     0.150
     8.362   122.725     0.150
     8.362   219.150     0.150
     8.362   122.879     0.150
     8.362   122.311     0.150
     8.362   122.980     0.150
     8.503   126.320     0.150
     8.767   128.039     0.150
     8.822   128.811     0.150
     8.859   129.980     0.150
     8.940   131.359     0.150
     8.940   129.969     0.150
     8.940   130.180     0.150
     8.940   229.180     0.150
     8.955   130.990     0.150
     9.161   131.680     0.150
     9.161   132.178     0.150
     9.405   136.600     0.150
     9.515   137.770     0.150
     9.661   140.109     0.150
    10.139   145.510     0.150
    10.488   150.799     0.150
    10.562   150.430     0.150
    10.822   152.525     0.150
    10.822   275.980     0.150
    10.822   153.379     0.150
    10.822   153.420     0.150
    10.851   154.982     0.150
    12.230   170.680     0.150
    12.860   179.279     0.150
    13.485   187.180     0.150
    14.048   194.480     0.150
    14.077   194.580     0.150
    14.293   197.480     0.150
    14.461   199.879     0.150
    14.654   204.486     0.150
    14.654   204.879     0.150
    14.778   209.451     0.150
    14.778   208.879     0.150
    14.778   205.871     0.150
    14.778   371.180     0.150
    14.827   204.779     0.150
    15.518   212.879     0.150
    15.810   224.680     0.150
    16.138   221.279     0.150
    16.812   229.918     0.150
    16.920   235.914     0.150
    16.920   236.879     0.150
    18.303   251.580     0.150
    18.303   444.730     0.150
    18.286   251.275     0.150
    18.286   250.686     0.150
    18.321   251.777     0.150
    19.241   263.180     0.150
    21.546   284.885     0.150
    21.546   287.359     0.150
    21.546   286.680     0.150
    22.495   299.580     0.150
    23.287   304.898     0.150
    23.287   305.279     0.150
    23.287   328.879     0.150
    23.287   556.180     0.150
    23.414   305.904     0.150
    23.414   305.379     0.150
    23.456   310.180     0.150
    23.456   562.779     0.150
    23.613   306.680     0.150
    26.784   388.080     0.150
    27.812   346.580     0.150
    28.211   351.580     0.150
    29.408   360.430     0.150
    29.693   362.510     0.150
    29.967   366.680     0.150
    29.967   366.340     0.150
    32.460   391.580     0.150
    34.035   401.232     0.150
    35.866   417.779     0.150
    36.791   424.680     0.150
    37.801   433.680     0.150
    37.801   785.080     0.150
    38.927   442.490     0.150
    38.927   442.879     0.150
    39.399   447.180     0.150
    42.422   471.180     0.150
    42.757   474.879     0.150
    42.756   474.119     0.150
    42.756   474.830     0.150
    42.988   478.459     0.150
    43.213   478.129     0.150
    43.850   483.910     0.150
    43.925   483.955     0.150
    44.863   491.730     0.150
    45.333   494.469     0.150
    45.347   495.289     0.150
    45.534   496.770     0.150
    45.528   495.930     0.150
    45.571   496.619     0.150
    45.729   498.119     0.150
    45.766   497.580     0.150
    45.766   498.154     0.150
    45.932   498.969     0.150
    46.902   507.430     0.150
    58.249   592.359     0.150
    62.711   623.480     0.150
    65.638   640.967     0.150
    75.635   702.980     0.150
    75.649   701.254     0.150
    75.649   701.879     0.150
    76.372   706.754     0.150
    76.372   707.379     0.150
    76.486   705.215     0.150
    80.847   730.379     0.150
    81.106   731.080     0.150
    81.106   733.180     0.150
    81.115   731.840     0.150
    83.005   741.680     0.150
    83.291   743.943     0.150
     1.494    29.538     0.150
     1.494    48.938     0.150
     2.193    37.938     0.150
     3.345    53.538     0.150
     4.943    75.938     0.150
     4.943   132.938     0.150
     5.464    83.108     0.150
     5.464   146.698     0.150
     5.985    90.738     0.150
     6.510   163.638     0.150
     6.677    98.298     0.150
     6.677   174.538     0.150
     7.429   110.408     0.150
     7.429   196.658     0.150
     7.766   199.838     0.150
     7.828   116.588     0.150
     8.194   121.398     0.150
     8.194   215.878     0.150
     8.194   215.988     0.150
     8.257   121.918     0.150
     8.322   120.938     0.150
     8.322   210.938     0.150
     8.348   123.538     0.150
     8.378   122.838     0.150
     8.378   217.561     0.150
     8.572   124.038     0.150
     8.572   215.838     0.150
     8.516   125.648     0.150
     8.516   125.421     0.150
     8.516   221.724     0.150
     8.923   130.898     0.150
     9.100   133.258     0.150
     9.121   133.638     0.150
     9.121   133.287     0.150
     9.121   238.358     0.150
     9.307   135.448     0.150
     9.602   139.588     0.150
     9.725   141.458     0.150
     9.922   142.888     0.150
     9.871   143.298     0.150
    10.461   149.888     0.150
    10.461   270.163     0.150
    10.461   149.210     0.150
    10.450   150.048     0.150
    11.096   158.139     0.150
    12.566   175.738     0.150
    12.950   180.918     0.150
    12.950   322.058     0.150
    13.196   184.938     0.150
    13.832   192.738     0.150
    14.394   199.938     0.150
    14.426   200.638     0.150
    14.628   202.938     0.150
    14.640   203.238     0.150
    15.011   215.969     0.150
    15.011   211.663     0.150
    15.180   210.638     0.150
    15.866   218.838     0.150
    16.130   229.138     0.150
    16.496   228.138     0.150
    16.508   228.138     0.150
    16.474   228.985     0.150
    16.474   404.277     0.150
    16.953   236.778     0.150
    17.286   238.228     0.150
    17.238   241.218     0.150
    18.146   250.638     0.150
    18.146   447.913     0.150
    18.146   249.738     0.150
    18.146   446.500     0.150
    18.306   253.051     0.150
    21.723   289.238     0.150
    23.087   304.588     0.150
    23.193   305.557     0.150
    23.193   563.207     0.150
    23.836   314.338     0.150
    23.836   570.038     0.150
    29.461   365.138     0.150
    29.604   365.638     0.150
    29.739   365.784     0.150
    30.040   368.238     0.150
    31.033   376.638     0.150
    32.102   386.538     0.150
    32.834   395.938     0.150
    32.837   388.438     0.150
    33.751   400.263     0.150
    35.300   415.133     0.150
    35.959   419.638     0.150
    37.079   429.254     0.150
    37.968   436.938     0.150
    38.734   442.313     0.150
    40.194   455.938     0.150
    41.708   468.533     0.150
    42.633   474.213     0.150
    43.330   480.738     0.150
    43.622   482.713     0.150
    43.622   591.263     0.150
    44.213   487.188     0.150
    45.553   497.238     0.150
    45.553   497.263     0.150
    45.883   500.438     0.150
    45.878   502.088     0.150
    46.757   508.438     0.150
    49.203   526.613     0.150
    54.037   563.588     0.150
    57.913   591.588     0.150
    65.242   639.263     0.150
    74.166   694.663     0.150
    74.244   694.738     0.150
    74.315   696.038     0.150
    74.555   697.338     0.150
    76.098   706.363     0.150
    76.615   707.638     0.150
    81.432   735.563     0.150
    83.046   743.188     0.150
    83.604   747.088     0.150
    83.561   746.288     0.150
   148.766  1187.538     0.150
     1.068    17.859     0.150
     2.598    43.359     0.150
     4.229   108.547     0.150
     4.193    66.305     0.150
     4.427    69.680     0.150
     5.495    83.125     0.150
     5.495   144.844     0.150
     5.506    83.234     0.150
     5.995   159.148     0.150
     6.686    93.539     0.150
     6.689   168.547     0.150
     8.001   118.141     0.150
     8.283   118.289     0.150
     8.283   206.117     0.150
     8.292   205.547     0.150
     8.528   124.062     0.150
     8.528   220.898     0.150
     8.528   124.469     0.150
     8.528   124.469     0.150
     8.521   125.234     0.150
     8.692   127.250     0.150
     8.692   224.930     0.150
     8.847   130.703     0.150
     8.891   130.070     0.150
     9.050   132.664     0.150
     9.098   133.648     0.150
     9.272   135.680     0.150
     9.298   136.312     0.150
     9.298   243.516     0.150
    10.423   149.719     0.150
    12.871   179.906     0.150
    13.861   193.844     0.150
    14.422   200.445     0.150
    14.457   200.445     0.150
    14.669   203.250     0.150
    15.191   214.055     0.150
    15.191   215.867     0.150
    15.191   214.094     0.150
    16.303   231.844     0.150
    16.303   228.977     0.150
    17.126   238.500     0.150
    17.126   237.758     0.150
    17.234   240.031     0.150
    17.234   240.539     0.150
    18.236   250.812     0.150
    18.236   449.578     0.150
    18.236   251.062     0.150
    18.236   448.547     0.150
    18.256   252.734     0.150
    18.455   254.461     0.150
    18.488   253.969     0.150
    18.488   255.109     0.150
    20.661   279.414     0.150
    21.900   289.977     0.150
    21.900   290.898     0.150
    21.900   290.883     0.150
    22.230   293.844     0.150
    23.306   306.266     0.150
    23.306   307.156     0.150
    24.045   311.555     0.150
    23.982   315.047     0.150
    27.308   345.547     0.150
    27.308   393.844     0.150
    29.563   364.484     0.150
    29.909   367.820     0.150
    30.348   370.656     0.150
    32.986   396.445     0.150
    35.292   415.406     0.150
    36.124   420.445     0.150
    38.805   442.891     0.150
    38.806   443.344     0.150
    42.735   475.406     0.150
    43.631   482.805     0.150
    44.675   491.109     0.150
    45.384   496.109     0.150
    45.655   497.469     0.150
    45.566   498.469     0.150
    45.578   497.375     0.150
    45.615   497.945     0.150
    45.615   498.047     0.150
    45.825   499.438     0.150
    45.864   500.180     0.150
    48.200   519.180     0.150
    53.314   557.430     0.150
    54.188   562.266     0.150
    57.896   591.234     0.150
    65.139   637.758     0.150
    76.786   708.008     0.150
    80.284   728.273     0.150
    80.284   729.148     0.150
    81.363   734.828     0.150
    81.440   735.219     0.150
    81.449   735.703     0.150
    81.594   736.047     0.150
    81.436   733.727     0.150
    81.692   736.367     0.150
    83.199   743.797     0.150
    83.603   746.094     0.150
     1.031    18.305     0.150
     1.031    31.906     0.150
     2.650    43.766     0.150
     4.137    66.117     0.150
     4.378    69.859     0.150
     5.010    78.586     0.150
     5.460    84.727     0.150
     6.648    96.984     0.150
     6.748   169.047     0.150
     6.752   102.859     0.150
     7.831   113.406     0.150
     7.831   195.180     0.150
     8.344   119.273     0.150
     8.447   122.867     0.150
     8.480   123.875     0.150
     8.480   221.508     0.150
     8.480   123.758     0.150
     8.480   124.039     0.150
     8.660   226.047     0.150
     8.660   229.203     0.150
     8.660   126.867     0.150
     8.859   130.016     0.150
     9.270   136.414     0.150
     9.270   243.336     0.150
    10.370   149.398     0.150
    12.641   177.125     0.150
    12.933   182.148     0.150
    12.933   315.789     0.150
    13.076   183.430     0.150
    13.273   186.125     0.150
    13.916   193.328     0.150
    14.512   202.227     0.150
    14.724   203.328     0.150
    15.268   212.125     0.150
    15.171   213.703     0.150
    15.171   212.203     0.150
    15.171   215.094     0.150
    15.951   220.328     0.150
    16.508   229.641     0.150
    16.508   406.992     0.150
    16.508   230.523     0.150
    16.508   230.227     0.150
    17.092   235.305     0.150
    18.176   252.125     0.150
    18.176   251.320     0.150
    18.176   447.984     0.150
    18.406   253.914     0.150
    18.440   253.695     0.150
    20.713   277.023     0.150
    21.008   285.875     0.150
    21.870   290.617     0.150
    21.870   290.328     0.150
    22.370   294.789     0.150
    22.990   300.297     0.150
    23.021   304.578     0.150
    23.249   306.945     0.150
    23.249   305.797     0.150
    24.001   314.430     0.150
    29.510   364.273     0.150
    29.510   363.500     0.150
    29.910   366.969     0.150
    33.713   400.523     0.150
    33.713   398.750     0.150
    35.873   418.977     0.150
    36.083   419.328     0.150
    38.744   442.359     0.150
    38.744   442.523     0.150
    38.744   442.625     0.150
    42.675   474.828     0.150
    42.675   475.156     0.150
    45.322   495.039     0.150
    45.553   497.727     0.150
    45.553   497.977     0.150
    45.763   498.469     0.150
    48.141   518.977     0.150
    48.800   523.266     0.150
    49.106   527.930     0.150
    52.474   551.328     0.150
    57.839   591.039     0.150
    69.100   662.617     0.150
    74.908   698.625     0.150
    75.932   705.500     0.150
    79.332   723.219     0.150
    81.498   734.375     0.150
    83.152   743.250     0.150
    83.152   743.578     0.150
    83.662   746.680     0.150
   134.529  1156.828     0.150
     1.314    22.828     0.150
     1.314    40.242     0.150
     2.343    40.383     0.150
     4.323    68.344     0.150
     4.718    72.727     0.150
     4.718   129.172     0.150
     5.747   151.617     0.150
     8.068   115.625     0.150
     8.068   201.867     0.150
     7.997   118.430     0.150
     7.997   208.570     0.150
     8.600   125.414     0.150
     8.600   125.602     0.150
     8.600   222.875     0.150
     8.600   125.336     0.150
     8.676   128.148     0.150
     8.676   224.445     0.150
     8.676   127.867     0.150
     9.169   135.242     0.150
     9.265   242.000     0.150
    11.303   159.086     0.150
    11.303   281.328     0.150
    12.334   173.008     0.150
    12.768   179.406     0.150
    13.608   189.305     0.150
    14.403   200.008     0.150
    14.416   199.906     0.150
    14.596   203.305     0.150
    14.960   207.203     0.150
    15.121   215.953     0.150
    15.120   214.156     0.150
    15.120   215.602     0.150
    15.643   215.805     0.150
    16.280   224.602     0.150
    16.736   232.297     0.150
    17.121   236.750     0.150
    17.229   242.852     0.150
    18.409   253.328     0.150
    18.409   457.977     0.150
    18.528   253.633     0.150
    18.563   257.031     0.150
    21.316   285.453     0.150
    21.870   293.094     0.150
    21.870   291.664     0.150
    23.447   308.672     0.150
    36.152   420.602     0.150
    38.998   443.992     0.150
    38.998   444.133     0.150
    38.998   444.305     0.150
    42.892   476.008     0.150
    45.768   499.516     0.150
    45.817   499.703     0.150
    45.817   499.727     0.150
    47.742   513.688     0.150
    83.359   744.281     0.150
     0.839    15.756     0.150
     2.804    48.977     0.150
     3.988   124.816     0.150
     4.183    67.516     0.150
     4.467    72.545     0.150
     5.169    81.326     0.150
     5.169   142.746     0.150
     5.139    80.086     0.150
     5.561    87.596     0.150
     6.178   165.445     0.150
     6.876   102.926     0.150
     6.876   179.695     0.150
     6.866   171.266     0.150
     7.606   115.830     0.150
     7.606   200.873     0.150
     8.109   121.809     0.150
     8.109   214.896     0.150
     8.109   122.166     0.150
     8.409   213.256     0.150
     8.437   125.195     0.150
     8.437   217.775     0.150
     8.335   125.176     0.150
     8.569   127.227     0.150
     8.569   126.994     0.150
     8.569   226.426     0.150
     8.569   126.535     0.150
     8.569   126.676     0.150
     8.943   132.406     0.150
     8.808   131.186     0.150
     8.808   230.234     0.150
     8.808   131.727     0.150
     9.188   135.705     0.150
     9.427   140.012     0.150
     9.427   245.148     0.150
     9.425   139.416     0.150
     9.667   142.752     0.150
     9.770   144.152     0.150
    10.226   268.490     0.150
    10.137   148.969     0.150
    10.195   150.377     0.150
    11.639   169.125     0.150
    11.639   290.295     0.150
    12.960   183.455     0.150
    12.960   321.496     0.150
    15.043   217.141     0.150
    15.346   218.865     0.150
    15.346   218.666     0.150
    15.346   216.527     0.150
    16.506   232.746     0.150
    16.506   232.316     0.150
    16.502   236.566     0.150
    17.231   240.916     0.150
    17.339   244.656     0.150
    17.339   246.066     0.150
    18.169   252.416     0.150
    18.169   450.941     0.150
    18.169   254.199     0.150
    18.492   257.365     0.150
    18.492   256.430     0.150
    18.524   257.516     0.150
    18.524   257.395     0.150
    18.524   258.465     0.150
    20.865   283.561     0.150
    22.024   295.246     0.150
    22.024   293.990     0.150
    22.024   295.115     0.150
    22.024   294.666     0.150
    23.275   308.635     0.150
    23.275   308.266     0.150
    23.275   563.566     0.150
    23.275   597.365     0.150
    24.003   315.291     0.150
    24.003   315.766     0.150
    27.709   348.791     0.150
    29.362   365.709     0.150
    30.113   371.021     0.150
    30.261   371.004     0.150
    30.552   375.965     0.150
    33.210   397.766     0.150
    33.625   401.592     0.150
    35.422   490.996     0.150
    35.422   748.486     0.150
    35.422   890.125     0.150
    35.422  1031.166     0.150
    38.714   444.465     0.150
    38.714   444.896     0.150
    38.714   445.066     0.150
    42.684   477.148     0.150
    45.510   499.465     0.150
    45.510   499.590     0.150
    46.251   505.996     0.150
    47.881   518.166     0.150
    54.413   567.865     0.150
    57.712   592.393     0.150
    64.909   639.572     0.150
    76.881   711.240     0.150
    81.618   738.289     0.150
    81.618   737.465     0.150
    83.244   746.033     0.150
    83.244   746.465     0.150
    83.772   749.977     0.150
     1.101    19.320     0.150
     1.468    27.301     0.150
     1.468    47.500     0.150
     2.559    45.398     0.150
     4.197   115.969     0.150
     4.203    66.660     0.150
     4.430    71.012     0.150
     5.463   146.859     0.150
     5.506    86.801     0.150
     5.965   160.059     0.150
     6.720    94.828     0.150
     6.660    99.641     0.150
     6.660   173.949     0.150
     6.668   172.301     0.150
     6.811   102.180     0.150
     7.334   110.500     0.150
     7.993   119.516     0.150
     7.993   211.176     0.150
     8.259   120.398     0.150
     8.259   209.109     0.150
     8.168   121.102     0.150
     8.529   125.969     0.150
     8.529   125.824     0.150
     8.529   222.992     0.150
     8.529   126.102     0.150
     8.529   125.828     0.150
     8.855   128.531     0.150
     8.681   128.648     0.150
     8.681   127.699     0.150
     8.681   127.445     0.150
     8.681   226.293     0.150
     8.881   132.199     0.150
     9.238   136.238     0.150
     9.255   137.371     0.150
     9.286   137.633     0.150
     9.286   246.758     0.150
    10.109   148.941     0.150
    10.456   148.809     0.150
    10.456   151.648     0.150
    10.456   270.051     0.150
    11.492   287.309     0.150
    12.852   180.949     0.150
    12.852   317.121     0.150
    15.000   209.641     0.150
    15.175   216.520     0.150
    15.174   216.520     0.150
    15.174   216.016     0.150
    16.278   230.602     0.150
    16.584   231.750     0.150
    16.584   231.770     0.150
    17.118   241.078     0.150
    17.226   241.629     0.150
    17.226   242.301     0.150
    18.253   253.219     0.150
    18.253   253.949     0.150
    18.253   451.074     0.150
    18.457   255.875     0.150
    18.491   256.191     0.150
    18.491   256.398     0.150
    19.647   269.699     0.150
    21.094   288.699     0.150
    21.094   286.770     0.150
    21.888   292.180     0.150
    21.888   292.160     0.150
    21.888   292.531     0.150
    22.177   297.500     0.150
    22.457   296.391     0.150
    23.109   307.898     0.150
    23.109   307.523     0.150
    23.311   310.000     0.150
    23.318   307.898     0.150
    23.318   308.898     0.150
    23.318   333.199     0.150
    23.318   556.699     0.150
    23.318   596.801     0.150
    23.318   308.668     0.150
    28.101   351.801     0.150
    29.595   367.602     0.150
    29.595   366.379     0.150
    29.883   368.500     0.150
    30.322   371.488     0.150
    30.322   372.898     0.150
    31.111   379.398     0.150
    31.111   444.000     0.150
    31.111   552.500     0.150
    31.793   444.898     0.150
    31.793   692.000     0.150
    32.955   396.102     0.150
    33.801   402.648     0.150
    35.947     7.371     0.150
    36.120   421.078     0.150
    36.120   422.102     0.150
    37.064   431.898     0.150
    37.409   432.500     0.150
    38.826   445.199     0.150
    45.637   499.801     0.150
    45.637   499.875     0.150
    45.846   500.770     0.150
    45.818   501.320     0.150
    45.842   501.801     0.150
    47.581   514.238     0.150
    47.581    10.230     0.150
    47.581   514.238     0.150
    47.581    10.641     0.150
    54.153   565.301     0.150
    54.158   566.000     0.150
    57.927   592.879     0.150
    65.173   640.273     0.150
    75.939   707.648     0.150
    75.895   706.074     0.150
    76.475   708.801     0.150
    76.779   710.250     0.150
    81.410   737.094     0.150
    83.200   745.602     0.150
    83.574   747.961     0.150
     1.402    24.914     0.150
     3.841    60.305     0.150
     3.841    71.785     0.150
     4.585    71.543     0.150
     4.585   123.453     0.150
     5.600    84.332     0.150
     5.600   147.574     0.150
     5.739    89.082     0.150
     6.296    93.445     0.150
     6.296   163.254     0.150
     6.680   167.645     0.150
     7.221   107.664     0.150
     7.894   113.875     0.150
     7.894   197.402     0.150
     8.144   120.805     0.150
     8.144   120.449     0.150
     8.515   122.633     0.150
     8.774   128.043     0.150
     8.774   229.727     0.150
     8.774   127.953     0.150
     8.817   130.492     0.150
     8.817   129.922     0.150
     8.817   128.586     0.150
     9.131   134.543     0.150
     9.222   135.203     0.150
     9.397   138.934     0.150
     9.397   137.113     0.150
     9.409   137.805     0.150
    10.809   153.035     0.150
    10.809   154.070     0.150
    10.809   154.145     0.150
    10.809   154.172     0.150
    12.192   170.945     0.150
    12.632   177.445     0.150
    12.824   179.645     0.150
    13.473   188.344     0.150
    14.033   195.645     0.150
    14.070   195.945     0.150
    13.967   196.023     0.150
    14.269   198.344     0.150
    14.281   199.043     0.150
    14.466   201.242     0.150
    14.829   206.043     0.150
    15.107   212.363     0.150
    15.231   215.691     0.150
    15.231   213.902     0.150
    15.231   213.523     0.150
    15.231   213.969     0.150
    15.508   214.844     0.150
    16.155   222.945     0.150
    16.153   223.344     0.150
    16.221   231.043     0.150
    16.221   409.945     0.150
    16.923   234.344     0.150
    16.923   234.473     0.150
    16.923   234.273     0.150
    17.266   237.895     0.150
    17.374   239.570     0.150
    17.905   248.832     0.150
    18.595   255.180     0.150
    18.595   256.270     0.150
    18.702   256.504     0.150
    18.737   257.516     0.150
    18.737   257.742     0.150
    19.691   269.242     0.150
    20.281   274.773     0.150
    21.448   289.645     0.150
    21.448   287.938     0.150
    22.003   292.562     0.150
    22.003   292.324     0.150
    22.542   300.242     0.150
    23.476   310.145     0.150
    23.476   307.719     0.150
    23.540   309.344     0.150
    23.679   311.445     0.150
    23.633   309.613     0.150
    23.633   337.543     0.150
    23.633   560.043     0.150
    23.633   605.945     0.150
    23.774   314.242     0.150
    24.489   317.242     0.150
    27.789   349.543     0.150
    28.120   349.742     0.150
    29.463   362.094     0.150
    29.678   364.844     0.150
    29.809   367.172     0.150
    29.809   366.863     0.150
    29.946   368.344     0.150
    29.946   367.445     0.150
    30.247   370.844     0.150
    31.476   379.543     0.150
    31.476   447.945     0.150
    31.676   378.543     0.150
    32.794   395.445     0.150
    33.124   394.613     0.150
    33.287   394.445     0.150
    33.287   394.344     0.150
    34.173   403.770     0.150
    34.173   403.555     0.150
    34.173   404.445     0.150
    35.159   414.820     0.150
    35.213   415.539     0.150
    35.523   418.027     0.150
    35.689   420.164     0.150
    36.317   423.969     0.150
    36.318   423.598     0.150
    37.696   436.191     0.150
    38.698   444.746     0.150
    39.182   446.492     0.150
    40.055   453.242     0.150
    42.002   471.645     0.150
    42.119   472.172     0.150
    42.302   473.945     0.150
    42.630   476.656     0.150
    43.079   479.145     0.150
    43.205   480.844     0.150
    43.260   481.496     0.150
    43.447   483.145     0.150
    43.543   482.016     0.150
    43.605   484.660     0.150
    43.630   484.242     0.150
    43.659   484.695     0.150
    43.686   485.145     0.150
    43.707   484.852     0.150
    43.819   486.922     0.150
    44.030   486.555     0.150
    44.030   487.043     0.150
    44.139   488.281     0.150
    44.345   489.645     0.150
    44.384   490.379     0.150
    44.409    19.000     0.150
    44.409   593.344     0.150
    44.657   490.539     0.150
    44.758   489.742     0.150
    44.809   493.402     0.150
    44.896   491.152     0.150
    44.982   495.066     0.150
    45.528   498.652     0.150
    45.562   498.688     0.150
    45.822   500.898     0.150
    45.880   500.961     0.150
    45.885   499.984     0.150
    45.885   499.344     0.150
    45.949   500.105     0.150
    45.999   501.344     0.150
    45.999   501.219     0.150
    46.096   502.578     0.150
    46.170   503.602     0.150
    46.714   508.234     0.150
    47.878   515.094     0.150
    49.133   526.945     0.150
    49.539   529.742     0.150
    51.044   540.945     0.150
    52.483   552.242     0.150
    53.392   558.742     0.150
    53.709   560.242     0.150
    58.290   593.520     0.150
    63.049   624.344     0.150
    65.451   670.922     0.150
    65.451   640.770     0.150
    72.603   682.484     0.150
    73.031   685.645     0.150
    73.089   687.645     0.150
    75.416   701.375     0.150
    75.447   702.422     0.150
    75.809   703.434     0.150
    76.092   704.773     0.150
    76.205   705.742     0.150
    76.476   707.434     0.150
    76.821   709.082     0.150
    76.938   708.766     0.150
    76.938   709.344     0.150
    77.009   708.504     0.150
    77.291   710.293     0.150
    78.151   714.344     0.150
    79.128   721.465     0.150
    80.166   726.363     0.150
    81.043   732.969     0.150
    83.204   744.793     0.150
    83.432   745.094     0.150
     1.562    28.078     0.150
     3.916    62.727     0.150
     3.916   110.312     0.150
     4.103    66.531     0.150
     4.147    66.102     0.150
     4.223    68.344     0.150
     4.649    73.664     0.150
     4.649   128.141     0.150
     5.166    80.242     0.150
     5.166   140.305     0.150
     5.262    82.797     0.150
     5.717   153.141     0.150
     6.206   159.438     0.150
     6.403    95.672     0.150
     6.403   168.508     0.150
     6.720   101.992     0.150
     6.959   106.016     0.150
     6.959   180.125     0.150
     7.161   104.273     0.150
     7.499   192.078     0.150
     7.641   114.984     0.150
     7.743   114.422     0.150
     8.162   118.953     0.150
     8.162   206.188     0.150
     8.166   123.312     0.150
     8.301   122.461     0.150
     8.301   214.250     0.150
     8.301   122.438     0.150
     8.301   122.836     0.150
     8.314   123.547     0.150
     8.314   122.555     0.150
     8.314   216.102     0.150
     8.314   124.695     0.150
     8.314   218.703     0.150
     8.631   126.828     0.150
     8.889   227.055     0.150
     8.895   132.266     0.150
     8.895   232.172     0.150
     8.906   133.023     0.150
     9.460   136.555     0.150
     9.460   238.562     0.150
    11.398   163.586     0.150
    11.398   283.523     0.150
    12.841   319.078     0.150
    14.741   210.438     0.150
    14.741   214.406     0.150
    14.741   210.711     0.150
    14.741   209.094     0.150
    15.789   223.938     0.150
    16.561   232.211     0.150
    16.561   232.031     0.150
    16.561   232.305     0.150
    16.763   233.031     0.150
    16.870   237.477     0.150
    18.241   252.312     0.150
    18.241   452.438     0.150
    18.263   253.844     0.150
    21.501   287.641     0.150
    21.501   288.211     0.150
    21.501   288.383     0.150
    23.225   307.414     0.150
    29.391   364.695     0.150
    42.694   475.594     0.150
    44.372   489.719     0.150
    45.706   500.531     0.150
    45.706   500.430     0.150
    53.470   558.391     0.150
    58.201   594.812     0.150
    65.617   643.961     0.150
    76.402   709.688     0.150
    81.155   735.336     0.150
    83.342   747.188     0.150
     1.413    25.742     0.150
     2.296    42.234     0.150
     4.275    69.703     0.150
     4.393    71.844     0.150
     4.934    80.543     0.150
     5.201    82.133     0.150
     5.201   141.531     0.150
     5.444    86.645     0.150
     5.725    89.473     0.150
     5.725   152.145     0.150
     6.417    97.512     0.150
     6.417   168.352     0.150
     6.431   165.621     0.150
     7.853   118.953     0.150
     8.079   205.395     0.150
     8.099   119.645     0.150
     8.099   205.895     0.150
     8.377   125.922     0.150
     8.480   126.324     0.150
     8.480   221.422     0.150
     8.480   125.992     0.150
     8.480   125.793     0.150
     8.529   127.918     0.150
     8.529   220.215     0.150
     8.772   221.961     0.150
     8.934   133.562     0.150
     8.934   132.559     0.150
     9.046   135.332     0.150
     9.115   136.461     0.150
     9.115   136.262     0.150
     9.120   135.273     0.150
     9.559   240.902     0.150
    11.035   160.672     0.150
    11.335   281.734     0.150
    12.742   181.453     0.150
    12.742   316.883     0.150
    14.840   209.996     0.150
    14.965   212.973     0.150
    14.965   217.777     0.150
    14.965   217.422     0.150
    14.965   212.723     0.150
    14.965   213.148     0.150
    16.007   231.422     0.150
    16.669   234.910     0.150
    16.669   413.824     0.150
    16.669   233.582     0.150
    16.976   236.098     0.150
    17.084   241.422     0.150
    17.084   241.125     0.150
    18.345   254.371     0.150
    18.345   255.531     0.150
    18.409   258.023     0.150
    18.409   255.773     0.150
    18.443   256.871     0.150
    18.443   256.422     0.150
    21.360   292.121     0.150
    21.720   291.262     0.150
    21.720   291.262     0.150
    21.720   291.996     0.150
    23.366   309.824     0.150
    23.366   552.824     0.150
    23.366   598.223     0.150
    23.643   314.523     0.150
    27.801   350.922     0.150
    29.606   366.922     0.150
    29.606   368.223     0.150
    29.777   368.027     0.150
    31.263   381.523     0.150
    31.263   445.023     0.150
    31.263   557.324     0.150
    32.650   393.922     0.150
    34.001   404.203     0.150
    34.001   404.922     0.150
    36.015   422.449     0.150
    36.015   421.121     0.150
    42.816   478.668     0.150
    42.816   479.621     0.150
    44.439   491.332     0.150
    45.686   502.406     0.150
    58.174   594.148     0.150
    65.483   643.297     0.150
    70.936   677.281     0.150
    71.002   677.262     0.150
    71.597   681.383     0.150
    74.030   695.363     0.150
    74.820   701.152     0.150
    76.996   712.645     0.150
    78.034   718.371     0.150
    81.172   736.180     0.150
    83.137   746.199     0.150
    83.137   746.523     0.150
    83.346   748.074     0.150
     1.319    24.848     0.150
     1.389    25.418     0.150
     2.398    41.518     0.150
     2.865    52.217     0.150
     3.485    59.057     0.150
     3.489    58.918     0.150
     3.489    99.297     0.150
     4.048   109.938     0.150
     4.785   130.656     0.150
     4.790    76.957     0.150
     4.925   133.367     0.150
     5.304    83.787     0.150
     5.304   141.547     0.150
     5.292    83.938     0.150
     5.379    85.277     0.150
     5.379   145.607     0.150
     5.852    92.656     0.150
     5.852   161.258     0.150
     6.530   169.617     0.150
     6.706   102.678     0.150
     6.790   102.986     0.150
     7.100   108.496     0.150
     7.163   109.627     0.150
     7.163   184.848     0.150
     7.623   115.697     0.150
     7.623   196.088     0.150
     7.628   114.438     0.150
     8.025   120.406     0.150
     8.240   123.387     0.150
     8.327   123.518     0.150
     8.327   123.406     0.150
     8.327   213.723     0.150
     8.327   123.467     0.150
     8.398   125.525     0.150
     8.398   214.301     0.150
     8.398   125.627     0.150
     8.398   124.746     0.150
     8.398   124.881     0.150
     8.398   218.381     0.150
     8.398   125.357     0.150
     8.562   126.496     0.150
     8.562   216.947     0.150
     8.546   127.977     0.150
     8.635   128.707     0.150
     8.733   129.428     0.150
     8.733   129.277     0.150
     8.804   130.627     0.150
     8.914   132.406     0.150
     8.914   132.947     0.150
     8.986   133.008     0.150
     8.990   133.957     0.150
     9.291   136.457     0.150
     9.291   137.057     0.150
     9.670   140.396     0.150
     9.670   241.117     0.150
    14.731   207.947     0.150
    14.858   209.357     0.150
    14.857   209.557     0.150
    14.857   210.406     0.150
    14.857   213.258     0.150
    16.514   231.797     0.150
    16.514   230.695     0.150
    16.514   406.850     0.150
    16.514   231.387     0.150
    16.842   234.182     0.150
    16.950   239.768     0.150
    16.950   239.357     0.150
    16.950   240.018     0.150
    18.191   253.156     0.150
    18.191   448.807     0.150
    18.191   252.121     0.150
    18.191   448.430     0.150
    18.255   253.232     0.150
    18.277   254.877     0.150
    19.327   265.357     0.150
    19.678   270.156     0.150
    20.446   276.768     0.150
    20.446   278.297     0.150
    21.595   289.668     0.150
    21.595   289.682     0.150
    21.595   289.357     0.150
    21.949   297.098     0.150
    23.148   308.057     0.150
    23.234   307.857     0.150
    23.209   307.518     0.150
    23.209   308.857     0.150
    23.209   557.957     0.150
    23.209   599.557     0.150
    23.588   312.258     0.150
    24.120   316.057     0.150
    26.864   342.582     0.150
    29.545   365.477     0.150
    29.545   366.857     0.150
    29.738   369.406     0.150
    29.878   368.508     0.150
    29.878   369.758     0.150
    31.119   379.357     0.150
    33.871   402.982     0.150
    33.871   403.447     0.150
    33.871   402.156     0.150
    33.871   402.967     0.150
    35.002   413.816     0.150
    35.446   418.316     0.150
    35.446   419.486     0.150
    35.872   419.857     0.150
    35.872   420.467     0.150
    36.052   422.896     0.150
    36.065   422.887     0.150
    36.075   423.428     0.150
    37.723   437.188     0.150
    38.799   445.396     0.150
    38.799   444.531     0.150
    38.799   444.727     0.150
    38.799   444.857     0.150
    38.939   445.727     0.150
    41.400   467.357     0.150
    42.659   477.008     0.150
    42.659   477.258     0.150
    43.301   483.588     0.150
    44.293   489.539     0.150
    45.317   498.637     0.150
    45.398   498.527     0.150
    45.630   499.758     0.150
    45.630   499.582     0.150
    45.877   502.357     0.150
    47.466   513.957     0.150
    47.466   514.947     0.150
    49.125   528.031     0.150
    49.125   528.258     0.150
    55.995   579.656     0.150
    58.066   593.982     0.150
    65.446   642.107     0.150
    70.407   673.117     0.150
    74.372   696.682     0.150
    75.652   704.307     0.150
    76.511   708.258     0.150
    76.511   708.057     0.150
    76.643   710.047     0.150
    81.285   735.156     0.150
    81.285   736.957     0.150
    82.986   744.133     0.150
    83.466   746.857     0.150
     1.389    27.395     0.150
     0.957    16.812     0.150
     0.957    29.625     0.150
     4.149    65.648     0.150
     4.339    67.508     0.150
     4.339   113.008     0.150
     4.339   112.703     0.150
     5.054    77.875     0.150
     5.256   137.445     0.150
     5.256    80.102     0.150
     5.256   140.078     0.150
     5.493    84.977     0.150
     5.606    86.242     0.150
     5.606   144.734     0.150
     5.606    84.484     0.150
     5.606   144.984     0.150
     5.785    90.062     0.150
     5.785   151.625     0.150
     5.785    86.992     0.150
     6.261    96.922     0.150
     6.799   172.266     0.150
     6.799   171.945     0.150
     7.054   101.156     0.150
     7.054   170.734     0.150
     7.410   109.945     0.150
     7.410   186.797     0.150
     7.410   110.586     0.150
     7.410   186.984     0.150
     7.660   111.094     0.150
     7.660   187.562     0.150
     8.392   122.188     0.150
     8.392   207.445     0.150
     8.392   122.734     0.150
     8.392   207.992     0.150
     8.225   119.133     0.150
     8.346   123.422     0.150
     8.509   123.875     0.150
     8.509   218.555     0.150
     8.509   123.812     0.150
     8.534   127.188     0.150
     8.712   127.516     0.150
     8.712   223.695     0.150
     8.712   128.008     0.150
     8.712   127.852     0.150
     8.712   226.812     0.150
     8.858   129.195     0.150
     9.083   132.078     0.150
     9.309   135.547     0.150
     9.317   135.656     0.150
     9.867   142.828     0.150
     9.867   243.383     0.150
     9.944   143.594     0.150
     9.710   140.016     0.150
    11.325   162.031     0.150
    15.105   211.703     0.150
    15.235   217.039     0.150
    15.234   213.766     0.150
    15.655   216.875     0.150
    16.375   230.922     0.150
    16.503   229.258     0.150
    16.503   228.023     0.150
    16.503   407.781     0.150
    16.503   228.852     0.150
    17.141   239.266     0.150
    17.141   240.148     0.150
    17.249   240.828     0.150
    17.249   240.961     0.150
    18.169   251.477     0.150
    18.169   248.828     0.150
    18.169   448.398     0.150
    18.435   254.203     0.150
    18.456   254.438     0.150
    20.951   283.391     0.150
    21.925   291.938     0.150
    21.925   292.203     0.150
    22.973   304.273     0.150
    23.259   305.633     0.150
    24.040   315.625     0.150
    29.451   363.422     0.150
    29.985   367.367     0.150
    29.985   366.281     0.150
    33.676   399.664     0.150
    35.186   414.969     0.150
    38.728   441.438     0.150
    38.728   442.227     0.150
    42.674   475.031     0.150
    43.332   478.742     0.150
    43.529   483.961     0.150
    44.188   487.281     0.150
    45.484   496.734     0.150
    45.533   497.422     0.150
    45.533   497.547     0.150
    45.666   499.086     0.150
    45.743   498.617     0.150
    45.905   500.445     0.150
    46.122   503.508     0.150
    47.785   514.883     0.150
    49.047   527.102     0.150
    54.283   564.359     0.150
    54.283   563.953     0.150
    57.788   590.398     0.150
    57.788   588.164     0.150
    65.027   637.820     0.150
    65.027   636.344     0.150
    81.547   735.172     0.150
    83.183   743.625     0.150
    83.183   742.883     0.150
    83.707   746.875     0.150
     1.406    26.531     0.150
     4.087    68.221     0.150
     4.243    70.701     0.150
     4.767    76.410     0.150
     4.906   129.531     0.150
     5.285    83.600     0.150
     5.360    86.850     0.150
     5.360   142.750     0.150
     5.296    83.461     0.150
     5.824   156.850     0.150
     6.512    99.141     0.150
     7.081   107.961     0.150
     7.144   109.811     0.150
     7.144   182.650     0.150
     8.331   124.713     0.150
     8.331   219.332     0.150
     8.396   126.270     0.150
     8.396   222.369     0.150
     8.396   125.693     0.150
     8.396   219.824     0.150
     8.728   130.330     0.150
     8.906   130.500     0.150
     8.931   131.301     0.150
    14.851   216.100     0.150
    15.313   213.689     0.150
    16.526   232.650     0.150
    16.526   233.090     0.150
    16.841   234.145     0.150
    16.948   236.111     0.150
    18.203   253.301     0.150
    18.260   254.322     0.150
    21.592   290.570     0.150
    21.592   290.500     0.150
    23.253   309.176     0.150
    33.888   404.176     0.150
    38.813   445.529     0.150
    42.337   474.891     0.150
    42.670   477.416     0.150
    42.670   476.471     0.150
    44.308   490.121     0.150
    45.608   500.641     0.150
    45.645   500.572     0.150
    58.084   594.676     0.150
    65.464   643.176     0.150
    80.696   732.840     0.150
    81.267   736.941     0.150
    82.920   744.939     0.150
    82.989   745.037     0.150
    83.448   748.018     0.150
     1.040    18.375     0.150
     1.040    32.062     0.150
     2.617    43.711     0.150
     2.617    77.406     0.150
     5.073    79.625     0.150
     5.527    85.586     0.150
     7.091   105.164     0.150
     8.214   120.141     0.150
     8.547   223.484     0.150
     8.547   125.086     0.150
     8.547   124.484     0.150
     8.719   128.125     0.150
     8.719   225.219     0.150
     8.719   129.156     0.150
     8.719   227.805     0.150
     8.719   127.594     0.150
     9.079   131.094     0.150
     9.289   136.961     0.150
    13.038   182.852     0.150
    13.878   194.953     0.150
    14.438   202.055     0.150
    14.686   204.555     0.150
    14.686   358.156     0.150
    15.222   217.102     0.150
    15.222   216.742     0.150
    16.554   403.750     0.150
    16.574   231.328     0.150
    16.574   230.414     0.150
    16.574   231.250     0.150
    17.153   240.078     0.150
    17.261   241.320     0.150
    18.242   252.305     0.150
    18.242   253.398     0.150
    18.474   255.602     0.150
    18.496   256.000     0.150
    21.928   292.531     0.150
    21.928   291.656     0.150
    21.928   292.055     0.150
    23.066   306.828     0.150
    23.321   307.969     0.150
    23.321   307.859     0.150
    38.807   443.875     0.150
    38.808   443.555     0.150
    38.808   443.391     0.150
    42.743   475.805     0.150
    44.271   488.133     0.150
    45.566   498.742     0.150
    45.615   498.750     0.150
    45.615   498.680     0.150
    45.863   501.086     0.150
    71.471   678.805     0.150
    72.341   683.203     0.150
    75.887   705.500     0.150
    81.453   735.344     0.150
    83.220   743.875     0.150
     1.244    22.562     0.150
     1.244    23.102     0.150
     2.450    43.078     0.150
     2.450    43.852     0.150
     3.595    60.406     0.150
     3.595   104.633     0.150
     4.090    65.188     0.150
     4.090   113.391     0.150
     4.831    75.758     0.150
     4.831   132.648     0.150
     4.991    77.508     0.150
     4.991   136.148     0.150
     4.968    79.281     0.150
     4.968    80.883     0.150
     5.461    82.242     0.150
     5.461   142.930     0.150
     5.453    85.477     0.150
     5.453    86.898     0.150
     5.867    89.883     0.150
     5.867   155.672     0.150
     6.055    95.680     0.150
     6.055   164.977     0.150
     6.861   101.430     0.150
     6.970   178.812     0.150
     6.870   104.758     0.150
     6.975   104.859     0.150
     7.538   198.992     0.150
     7.699   114.938     0.150
     7.699   199.086     0.150
     7.734   115.383     0.150
     7.734   200.281     0.150
     7.875   118.531     0.150
     8.203   118.961     0.150
     8.203   207.211     0.150
     8.202   119.656     0.150
     8.202   208.156     0.150
     8.270   210.969     0.150
     8.293   121.781     0.150
     8.293   210.188     0.150
     8.218   122.883     0.150
     8.445   122.969     0.150
     8.445   213.906     0.150
     8.428   212.117     0.150
     8.428   121.781     0.150
     8.428   211.477     0.150
     8.427   125.680     0.150
     8.483   221.062     0.150
     8.483   125.297     0.150
     8.483   124.477     0.150
     8.608   126.297     0.150
     8.608   220.273     0.150
     8.589   126.750     0.150
     8.589   224.375     0.150
     8.589   270.672     0.150
     8.589   128.109     0.150
     8.589   127.797     0.150
     8.589   225.906     0.150
     8.589   127.438     0.150
     8.589   128.383     0.150
     8.740   130.438     0.150
     8.835   130.617     0.150
     8.995   133.156     0.150
     9.117   133.477     0.150
     9.117   134.977     0.150
     9.140   134.383     0.150
     9.140   135.961     0.150
     9.176   135.562     0.150
     9.186   136.227     0.150
     9.383   138.023     0.150
     9.383   240.953     0.150
     9.419   139.422     0.150
     9.495   138.992     0.150
     9.495   140.477     0.150
     9.531   140.203     0.150
     9.626   139.336     0.150
     9.626   243.273     0.150
     9.704   140.242     0.150
     9.704   242.977     0.150
     9.781   144.078     0.150
     9.874   145.102     0.150
     9.979   145.578     0.150
     9.927   146.180     0.150
     9.927   254.383     0.150
     9.990   146.883     0.150
     9.990   145.797     0.150
     9.990   147.000     0.150
    10.298   150.781     0.150
    10.423   151.680     0.150
    10.778   156.680     0.150
    10.868   157.281     0.150
    11.137   160.656     0.150
    11.438   283.938     0.150
    11.542   163.727     0.150
    12.003   172.883     0.150
    12.822   180.789     0.150
    13.720   192.383     0.150
    14.282   199.781     0.150
    14.315   199.883     0.150
    14.516   202.578     0.150
    14.933   210.281     0.150
    14.933   210.383     0.150
    15.060   214.484     0.150
    15.060   212.180     0.150
    15.060   214.883     0.150
    15.060   212.070     0.150
    15.060   465.328     0.150
    15.060   211.883     0.150
    15.060   215.078     0.150
    15.395   215.258     0.150
    15.755   218.180     0.150
    16.140   231.281     0.150
    16.388   226.781     0.150
    16.398   227.383     0.150
    16.601   232.680     0.150
    16.601   411.977     0.150
    16.601   232.000     0.150
    16.601   231.648     0.150
    17.031   236.258     0.150
    17.031   529.180     0.150
    17.031   239.125     0.150
    17.139   239.180     0.150
    17.139   242.023     0.150
    17.931   253.680     0.150
    18.274   254.305     0.150
    18.274   255.062     0.150
    18.274   452.602     0.150
    18.411   254.602     0.150
    18.433   254.883     0.150
    19.207   267.078     0.150
    19.207   481.383     0.150
    19.538   269.977     0.150
    19.529   268.281     0.150
    19.836   273.180     0.150
    19.836   275.977     0.150
    20.083   275.078     0.150
    20.526   282.977     0.150
    20.586   279.477     0.150
    20.512   277.836     0.150
    20.512   278.867     0.150
    21.206   288.148     0.150
    21.206   287.680     0.150
    21.206   284.133     0.150
    21.206   289.398     0.150
    21.206   289.578     0.150
    21.206   290.180     0.150
    21.866   296.633     0.150
    21.790   291.062     0.150
    21.790   291.031     0.150
    21.790   292.180     0.150
    21.790   291.297     0.150
    22.383   296.672     0.150
    23.205   306.781     0.150
    23.205   308.680     0.150
    23.205   310.078     0.150
    23.239   307.781     0.150
    23.226   307.883     0.150
    23.377   309.383     0.150
    23.406   307.281     0.150
    23.406   307.961     0.150
    23.406   311.953     0.150
    23.320   308.281     0.150
    23.320   331.977     0.150
    23.320   556.680     0.150
    23.320   307.359     0.150
    23.328   309.977     0.150
    23.425   309.672     0.150
    23.470   313.148     0.150
    23.764   315.180     0.150
    24.455   317.281     0.150
    25.012   325.680     0.150
    25.289   326.680     0.150
    25.360   328.711     0.150
    26.007   600.477     0.150
    26.007   617.781     0.150
    27.798   349.383     0.150
    29.711   367.555     0.150
    29.711   367.883     0.150
    29.711   367.781     0.150
    29.743   366.961     0.150
    29.743   367.281     0.150
    29.928   369.133     0.150
    30.182   370.781     0.150
    30.182   372.414     0.150
    31.162   379.180     0.150
    31.162    11.500     0.150
    31.162    18.500     0.150
    31.162   793.680     0.150
    32.808   395.180     0.150
    33.876   401.578     0.150
    33.876   402.680     0.150
    36.049   420.852     0.150
    36.049   421.578     0.150
    36.049   420.258     0.150
    36.049   422.281     0.150
    36.947   430.188     0.150
    38.862   445.531     0.150
    38.862   444.727     0.150
    42.758   476.680     0.150
    43.744   485.695     0.150
    43.744   592.406     0.150
    43.703   485.977     0.150
    44.114   592.680     0.150
    44.341   489.578     0.150
    44.619   491.977     0.150
    44.797   493.391     0.150
    44.797   494.883     0.150
    45.632   499.836     0.150
    45.682   500.281     0.150
    45.682   500.227     0.150
    49.250   528.688     0.150
    52.978   553.758     0.150
    53.372   559.648     0.150
    53.401   558.711     0.150
    54.010   564.203     0.150
    58.028   592.758     0.150
    65.314   641.656     0.150
    65.314   639.992     0.150
    65.323   641.781     0.150
    72.065   683.891     0.150
    72.632   687.289     0.150
    73.030   691.477     0.150
    73.030   691.281     0.150
    72.843   688.078     0.150
    73.093   689.781     0.150
    73.120   689.617     0.150
    73.461   692.781     0.150
    74.235   695.531     0.150
    74.235   695.680     0.150
    74.085   694.852     0.150
    74.532   698.836     0.150
    74.863   700.820     0.150
    76.065   707.852     0.150
    76.697   709.680     0.150
    81.087   733.781     0.150
    81.314   735.727     0.150
    81.314   736.383     0.150
    81.436   736.109     0.150
    82.172   739.797     0.150
    83.080   744.141     0.150
    83.148   744.656     0.150
    83.148   745.383     0.150
    83.148   745.031     0.150
    83.148   745.180     0.150
    83.163   746.070     0.150
    83.483   747.477     0.150
    83.483   747.578     0.150
    83.483   747.883     0.150
   126.744  1142.633     0.150
   145.605  1178.531     0.150
   148.307  1186.531     0.150
   148.338  1187.781     0.150
     1.369    23.816     0.150
     1.369    24.117     0.150
     2.251    39.027     0.150
     2.251    39.238     0.150
     5.257    82.828     0.150
     5.762    88.816     0.150
     5.762   155.215     0.150
     5.762    89.148     0.150
     6.234    96.328     0.150
     6.234   167.027     0.150
     7.176   107.148     0.150
     7.252   106.926     0.150
     8.075   120.016     0.150
     8.700   129.086     0.150
     8.796   128.215     0.150
     8.796   127.875     0.150
     8.850   130.246     0.150
     8.850   229.371     0.150
     8.850   129.648     0.150
     8.850   130.086     0.150
     8.850   129.977     0.150
     9.167   133.727     0.150
     9.255   134.996     0.150
     9.310   136.066     0.150
     9.350   136.328     0.150
     9.432   138.496     0.150
     9.442   137.328     0.150
     9.654   142.578     0.150
    11.332   162.188     0.150
    12.215   170.926     0.150
    12.215   300.527     0.150
    12.656   177.527     0.150
    13.498   189.125     0.150
    14.095   194.785     0.150
    14.095   195.727     0.150
    14.293   198.625     0.150
    14.306   198.828     0.150
    14.492   201.828     0.150
    14.855   205.727     0.150
    15.189   210.227     0.150
    15.189   210.777     0.150
    15.145   211.688     0.150
    15.269   218.727     0.150
    15.269   214.664     0.150
    15.269   213.578     0.150
    15.269   216.328     0.150
    15.533   213.625     0.150
    16.263   230.125     0.150
    16.928   234.375     0.150
    16.928   234.156     0.150
    17.298   239.465     0.150
    17.406   241.148     0.150
    17.406   240.215     0.150
    17.406   244.727     0.150
    18.599   255.777     0.150
    18.599   454.777     0.150
    18.724   257.539     0.150
    18.724   463.863     0.150
    19.800   271.027     0.150
    19.800   274.527     0.150
    19.800   278.527     0.150
    19.731   268.328     0.150
    20.308   272.957     0.150
    20.308   274.625     0.150
    22.038   293.406     0.150
    22.038   293.105     0.150
    23.778   313.227     0.150
    24.446   316.387     0.150
    25.450   327.625     0.150
    25.833   331.027     0.150
    26.801   334.816     0.150
    26.801   338.336     0.150
    29.703   363.883     0.150
    29.703   364.727     0.150
    29.919   366.926     0.150
    29.852   366.047     0.150
    29.852   366.336     0.150
    30.290   369.125     0.150
    30.650   369.848     0.150
    32.029   386.297     0.150
    32.838   394.227     0.150
    34.160   403.277     0.150
    34.160   402.258     0.150
    34.160   402.445     0.150
    35.669   419.305     0.150
    36.339   421.852     0.150
    36.339   421.477     0.150
    36.339   422.926     0.150
    39.181   444.926     0.150
    39.181   445.828     0.150
    42.465   474.805     0.150
    42.613   475.609     0.150
    42.876   477.164     0.150
    43.086   478.078     0.150
    43.086   476.867     0.150
    43.242   480.566     0.150
    43.531   482.027     0.150
    43.689   484.078     0.150
    43.806   485.656     0.150
    44.014   485.887     0.150
    44.014   486.957     0.150
    44.201   486.852     0.150
    44.241   487.367     0.150
    44.270   489.457     0.150
    44.297   489.727     0.150
    44.366   489.684     0.150
    44.791   492.664     0.150
    44.877   492.188     0.150
    44.964   493.207     0.150
    45.055   493.246     0.150
    45.055   492.848     0.150
    45.326   496.758     0.150
    45.511   497.418     0.150
    45.591   500.461     0.150
    45.805   500.086     0.150
    45.764   497.227     0.150
    45.863   500.633     0.150
    45.958   500.258     0.150
    45.862   500.469     0.150
    45.995   500.625     0.150
    45.995   500.926     0.150
    46.079   502.438     0.150
    46.697   507.523     0.150
    46.697   507.688     0.150
    46.684   507.027     0.150
    47.509   512.508     0.150
    47.509   511.938     0.150
    47.913   515.207     0.150
    47.913   516.027     0.150
    48.581   521.246     0.150
    49.512   529.902     0.150
    49.577   528.574     0.150
    49.577   528.426     0.150
    53.700   559.473     0.150
    54.647   565.516     0.150
    58.269   592.801     0.150
    74.352   694.266     0.150
    75.144   698.438     0.150
    76.970   708.977     0.150
    81.063   732.695     0.150
    81.186   731.898     0.150
    81.385   734.066     0.150
    83.222   743.977     0.150
    83.222   743.297     0.150
    83.387   744.148     0.150
    83.456   744.551     0.150
     0.573    10.621     0.150
     0.640    11.820     0.150
     0.640    11.711     0.150
     0.640    20.340     0.150
     3.047    51.012     0.150
     4.211    76.090     0.150
     4.211   133.660     0.150
     4.673    72.660     0.150
     4.673   148.672     0.150
     4.764    83.660     0.150
     5.417    83.293     0.150
     5.448    85.570     0.150
     5.593    85.250     0.150
     5.593   174.543     0.150
     5.941   182.312     0.150
     6.430    96.543     0.150
     6.423    99.613     0.150
     6.423   173.812     0.150
     6.793    99.512     0.150
     7.127   105.500     0.150
     7.469   111.410     0.150
     7.640   114.012     0.150
     7.867   117.961     0.150
     8.297   122.121     0.150
     8.334   122.293     0.150
     8.349   119.512     0.150
     8.440   219.156     0.150
     8.440   123.910     0.150
     8.440   123.902     0.150
     8.655   124.184     0.150
     8.687   125.402     0.150
     8.690   126.332     0.150
     8.758   127.934     0.150
     8.776   126.562     0.150
     8.815   130.203     0.150
     8.817   132.012     0.150
     8.759   130.707     0.150
     8.759   224.055     0.150
     8.759   130.602     0.150
     8.759   130.180     0.150
     8.759   128.910     0.150
     8.919   128.832     0.150
     8.987   133.371     0.150
     9.165   131.934     0.150
     9.192   133.000     0.150
     9.168   133.512     0.150
     9.167   135.652     0.150
     9.395   138.863     0.150
     9.435   137.613     0.150
     9.435   138.113     0.150
     9.448   137.613     0.150
     9.448   137.410     0.150
     9.537   140.410     0.150
     9.897   143.613     0.150
    10.037   145.512     0.150
    10.196   145.781     0.150
    10.228   147.512     0.150
    10.183   148.410     0.150
    10.310   149.211     0.150
    10.507   152.711     0.150
    10.725   154.613     0.150
    11.111   159.711     0.150
    11.094   160.113     0.150
    11.365   162.910     0.150
    11.458   163.113     0.150
    11.458   164.812     0.150
    12.247   175.812     0.150
    13.024   182.812     0.150
    13.190   185.301     0.150
    13.464   189.113     0.150
    13.464   333.410     0.150
    13.539   191.230     0.150
    13.655   191.711     0.150
    13.655   338.312     0.150
    14.305   199.312     0.150
    14.865   206.613     0.150
    14.902   207.703     0.150
    15.101   209.812     0.150
    15.101   371.512     0.150
    15.297   212.711     0.150
    15.297   376.113     0.150
    15.347   215.812     0.150
    15.347   218.613     0.150
    15.347   214.957     0.150
    15.347   214.473     0.150
    15.347   216.312     0.150
    16.294   227.863     0.150
    16.294   228.160     0.150
    16.294   408.805     0.150
    16.294   226.941     0.150
    16.577   235.812     0.150
    16.983   233.711     0.150
    16.983   415.512     0.150
    16.987   234.410     0.150
    16.987   416.113     0.150
    17.167   238.238     0.150
    17.275   241.602     0.150
    17.275   242.141     0.150
    17.275   240.812     0.150
    17.953   248.812     0.150
    17.953   443.996     0.150
    18.355   252.711     0.150
    18.355   252.660     0.150
    18.376   253.211     0.150
    18.636   256.512     0.150
    18.877   257.543     0.150
    18.877   469.160     0.150
    18.962   258.910     0.150
    19.209   261.512     0.150
    19.209   477.812     0.150
    19.500   265.312     0.150
    19.929   270.012     0.150
    20.425   280.012     0.150
    20.425   288.113     0.150
    20.425   506.910     0.150
    20.616   279.629     0.150
    20.616   278.613     0.150
    21.109   284.684     0.150
    21.109   283.910     0.150
    21.258   288.672     0.150
    21.981   292.363     0.150
    22.101   295.711     0.150
    22.650   301.211     0.150
    22.650   300.113     0.150
    22.650   300.512     0.150
    22.853   303.383     0.150
    22.853   301.434     0.150
    22.853   302.910     0.150
    22.853   553.012     0.150
    22.853   302.711     0.150
    22.916   303.312     0.150
    23.024   304.312     0.150
    23.767   311.512     0.150
    23.902   313.102     0.150
    23.902   310.980     0.150
    24.318   318.512     0.150
    24.318   587.312     0.150
    24.872   323.613     0.150
    24.872   637.910     0.150
    27.428   343.781     0.150
    27.415   344.711     0.150
    27.497   345.812     0.150
    27.610   344.293     0.150
    27.593   346.711     0.150
    27.713   348.312     0.150
    27.764   349.613     0.150
    28.333   352.812     0.150
    28.939   359.312     0.150
    28.939     5.598     0.150
    29.114   359.711     0.150
    29.115   360.961     0.150
    29.115   362.211     0.150
    29.617   363.953     0.150
    30.196   369.809     0.150
    30.196   369.613     0.150
    30.203   370.410     0.150
    30.209   370.613     0.150
    30.295   371.902     0.150
    30.295   370.590     0.150
    30.510   372.613     0.150
    30.510   371.703     0.150
    30.529   372.113     0.150
    30.511   432.312     0.150
    30.636     6.598     0.150
    30.636   374.223     0.150
    30.636   373.961     0.150
    30.735   375.211     0.150
    30.735   437.012     0.150
    30.735   374.793     0.150
    30.735   373.832     0.150
    30.966   375.191     0.150
    32.164   385.910     0.150
    32.836   395.023     0.150
    33.375   397.738     0.150
    33.375   397.410     0.150
    33.375   397.512     0.150
    33.348   399.812     0.150
    33.620   400.012     0.150
    34.138   403.711     0.150
    34.334   407.852     0.150
    34.334   407.539     0.150
    34.388   408.320     0.150
    34.572   409.363     0.150
    34.698   410.512     0.150
    34.770   409.613     0.150
    34.841   411.852     0.150
    34.863   413.262     0.150
    34.921   412.613     0.150
    35.176   413.492     0.150
    35.176   491.543     0.150
    35.176   884.602     0.150
    35.273   415.621     0.150
    35.491   417.676     0.150
    35.513   415.441     0.150
    35.513   415.910     0.150
    35.549   416.410     0.150
    35.580   416.711     0.150
    35.580     8.000     0.150
    35.587   416.812     0.150
    35.613   416.070     0.150
    35.782   420.043     0.150
    36.046   421.492     0.150
    36.101   419.887     0.150
    36.101   420.500     0.150
    36.690   427.332     0.150
    37.008   430.820     0.150
    37.041   429.172     0.150
    37.041   429.012     0.150
    37.158   432.012     0.150
    37.208   431.160     0.150
    37.280   432.191     0.150
    37.335   432.953     0.150
    37.549   435.121     0.150
    37.564   435.273     0.150
    37.591   434.023     0.150
    37.633   436.922     0.150
    37.853   437.121     0.150
    37.874   436.656     0.150
    37.889   438.051     0.150
    38.211   440.691     0.150
    38.226   439.211     0.150
    38.286   440.812     0.150
    38.483   441.211     0.150
    38.483   440.781     0.150
    38.694   443.910     0.150
    38.694   800.812     0.150
    38.888   446.863     0.150
    38.888   446.641     0.150
    38.969   443.211     0.150
    39.100   448.133     0.150
    39.100   448.777     0.150
    39.115   445.812     0.150
    39.228   447.660     0.150
    39.182   446.730     0.150
    39.184   445.859     0.150
    39.262   448.902     0.150
    39.420   451.211     0.150
    39.968   454.812     0.150
    40.164   456.562     0.150
    40.139   454.840     0.150
    40.239   456.113     0.150
    40.265   455.973     0.150
    40.311   457.910     0.150
    40.350   457.902     0.150
    40.596   460.312     0.150
    40.695   461.340     0.150
    40.695   461.523     0.150
    40.695   461.012     0.150
    40.856   462.871     0.150
    40.825   461.102     0.150
    41.076   464.121     0.150
    41.069   462.684     0.150
    41.250   466.422     0.150
    41.307   466.703     0.150
    41.307   466.211     0.150
    41.307   466.352     0.150
    41.266   464.613     0.150
    41.266   837.812     0.150
    41.352   466.312     0.150
    41.437   467.012     0.150
    41.495   467.941     0.150
    41.527   468.031     0.150
    41.527   467.852     0.150
    41.568   468.512     0.150
    41.671   469.453     0.150
    41.697   469.402     0.150
    41.812   470.609     0.150
    42.031   472.191     0.150
    42.069   472.523     0.150
    42.077   472.695     0.150
    42.129   472.312     0.150
    42.148   472.363     0.150
    42.153   471.910     0.150
    42.383   474.703     0.150
    42.477   474.113     0.150
    42.477   474.301     0.150
    42.477   474.285     0.150
    42.477   473.980     0.150
    42.483   474.312     0.150
    42.618   477.223     0.150
    42.638   477.281     0.150
    42.663   477.184     0.150
    42.711   475.062     0.150
    42.708   478.082     0.150
    42.728   478.453     0.150
    42.816   478.191     0.150
    42.835   478.750     0.150
    42.889   478.684     0.150
    42.889   479.070     0.150
    42.914   477.570     0.150
    43.016   479.910     0.150
    43.217   481.410     0.150
    43.217   481.613     0.150
    43.217   478.590     0.150
    43.286   482.000     0.150
    43.286   480.711     0.150
    43.436   482.973     0.150
    43.460   483.312     0.150
    43.466   483.480     0.150
    43.493   483.902     0.150
    43.564   484.141     0.150
    43.564   484.672     0.150
    43.608   484.363     0.150
    43.608   483.910     0.150
    43.608   588.910     0.150
    43.586   483.500     0.150
    43.708   483.512     0.150
    43.745   484.582     0.150
    43.857   486.141     0.150
    43.925   485.785     0.150
    43.966   487.570     0.150
    43.981   488.363     0.150
    43.989   486.973     0.150
    44.161   488.629     0.150
    44.154   489.453     0.150
    44.209   490.090     0.150
    44.251   489.453     0.150
    44.251   489.160     0.150
    44.380   490.781     0.150
    44.436   492.043     0.150
    44.498   491.891     0.150
    44.533   492.812     0.150
    44.589   493.102     0.150
    44.562   490.840     0.150
    44.644   492.910     0.150
    44.695   492.500     0.150
    44.709   493.012     0.150
    44.709   494.250     0.150
    44.729   494.480     0.150
    44.750   493.781     0.150
    44.869   494.922     0.150
    44.949   493.391     0.150
    45.003   494.957     0.150
    44.990   494.090     0.150
    45.061   495.449     0.150
    45.073   494.660     0.150
    45.073   494.613     0.150
    45.182   496.051     0.150
    45.238   497.723     0.150
    45.226   495.320     0.150
    45.274   495.613     0.150
    45.274   495.012     0.150
    45.274   495.988     0.150
    45.350   498.031     0.150
    45.468   497.441     0.150
    45.503   499.793     0.150
    45.698   500.641     0.150
    45.895   502.113     0.150
    45.895   502.621     0.150
    46.022   501.410     0.150
    46.022     9.602     0.150
    46.022   922.711     0.150
    46.022  1093.613     0.150
    46.193   505.262     0.150
    46.397   504.812     0.150
    46.648   507.750     0.150
    46.772   508.691     0.150
    46.813   509.340     0.150
    46.813   510.711     0.150
    46.813   508.312     0.150
    46.813     8.598     0.150
    46.830   510.152     0.150
    46.935   510.273     0.150
    47.265   512.992     0.150
    47.603   515.953     0.150
    47.665   515.922     0.150
    47.669   515.793     0.150
    47.828   515.434     0.150
    47.828   515.941     0.150
    47.828   515.211     0.150
    47.828     5.199     0.150
    47.931   517.941     0.150
    47.931   517.121     0.150
    48.176   520.090     0.150
    48.336   521.723     0.150
    48.410   526.492     0.150
    48.432   522.281     0.150
    48.432   519.832     0.150
    48.432   521.113     0.150
    48.512   522.121     0.150
    48.642   522.512     0.150
    48.710   524.285     0.150
    48.710   522.363     0.150
    48.710   522.910     0.150
    49.056   525.602     0.150
    49.870   533.320     0.150
    49.951   533.191     0.150
    50.180   535.082     0.150
    50.180   534.691     0.150
    50.180   535.410     0.150
    50.653   539.133     0.150
    51.936   548.531     0.150
    52.774   554.652     0.150
    52.813   552.711     0.150
    52.938   555.312     0.150
    54.021   562.000     0.150
    54.061   564.641     0.150
    54.551   566.844     0.150
    54.586   568.113     0.150
    55.436   573.902     0.150
    55.420   572.723     0.150
    55.420   572.613     0.150
    55.623   575.371     0.150
    56.212   578.602     0.150
    56.212   579.113     0.150
    56.481   579.910     0.150
    56.481     6.301     0.150
    56.753   583.441     0.150
    57.422   587.312     0.150
    57.450   587.512     0.150
    57.460   588.312     0.150
    57.460   586.781     0.150
    58.344   594.320     0.150
    58.344   594.449     0.150
    59.133   600.672     0.150
    59.578   604.000     0.150
    59.597   604.070     0.150
    59.640   605.434     0.150
    59.718   605.211     0.150
    59.701   605.863     0.150
    59.906   605.852     0.150
    59.931   606.613     0.150
    60.376   608.703     0.150
    60.376   608.871     0.150
    60.511   610.910     0.150
    60.580   610.762     0.150
    60.628   607.891     0.150
    60.757   611.340     0.150
    60.810   612.160     0.150
    60.899   612.570     0.150
    61.058   613.961     0.150
    61.756   614.121     0.150
    61.756   614.461     0.150
    62.475   621.910     0.150
    62.475   623.180     0.150
    62.613   623.512     0.150
    63.366   628.922     0.150
    67.401   653.688     0.150
    67.827   660.652     0.150
    72.666   688.062     0.150
    74.208   694.453     0.150
    74.944   699.070     0.150
    75.012   700.000     0.150
    75.332   701.883     0.150
    75.718   705.488     0.150
    75.573   703.160     0.150
    75.669   703.801     0.150
    75.710   703.582     0.150
    75.862   704.441     0.150
    75.862   704.633     0.150
    75.862   705.012     0.150
    75.930   705.070     0.150
    75.953   705.242     0.150
    76.258   706.492     0.150
    76.384   707.410     0.150
    76.468   707.543     0.150
    76.500   708.043     0.150
    76.704   709.602     0.150
    76.708   708.781     0.150
    76.723   709.453     0.150
    76.794   709.383     0.150
    76.801   709.070     0.150
    76.801   709.062     0.150
    76.801   709.191     0.150
    77.096   711.523     0.150
    77.119   711.762     0.150
    77.263   712.352     0.150
    77.529   713.492     0.150
    77.733   715.191     0.150
    77.802   715.031     0.150
    77.885   715.590     0.150
    77.919   715.641     0.150
    78.112   717.301     0.150
    78.142   716.891     0.150
    78.159   717.461     0.150
    78.683   720.223     0.150
    78.922   721.281     0.150
    78.924   722.383     0.150
    79.246   723.812     0.150
    79.248   723.473     0.150
    79.375   724.750     0.150
    79.723   726.660     0.150
    81.645   735.590     0.150
    81.870   738.113     0.150
    81.870   738.910     0.150
    82.254   739.543     0.150
    82.880   742.273     0.150
    83.112   743.637     0.150
    83.112   743.043     0.150
    83.112   743.512     0.150
    83.112   744.113     0.150
    83.112     9.297     0.150
    84.025   748.961     0.150
    84.025   748.023     0.150
    84.325   750.434     0.150
    90.688   781.031     0.150
    90.688   782.613     0.150
    90.688   781.410     0.150
    96.417   807.461     0.150
   123.993  1135.363     0.150
   123.993  1135.992     0.150
     1.423    26.453     0.150
     1.423    26.156     0.150
     1.423    44.250     0.150
     3.435    58.516     0.150
     3.977    63.922     0.150
     3.977   109.094     0.150
     4.714    74.859     0.150
     4.714   130.992     0.150
     4.851    76.672     0.150
     5.234    81.562     0.150
     5.234   141.602     0.150
     5.331    84.203     0.150
     5.331   144.172     0.150
     5.446    83.344     0.150
     5.878    93.484     0.150
     5.878   162.484     0.150
     6.109    91.789     0.150
     6.430    98.305     0.150
     6.430   171.406     0.150
     6.457    97.000     0.150
     6.457   170.664     0.150
     6.773   103.227     0.150
     6.847   103.984     0.150
     6.971   183.414     0.150
     6.995   104.109     0.150
     6.995   181.625     0.150
     7.416   109.094     0.150
     7.416   190.273     0.150
     7.421   111.273     0.150
     7.461   112.039     0.150
     7.461   127.695     0.150
     7.461   134.227     0.150
     7.549   112.125     0.150
     7.549   196.453     0.150
     7.665   115.141     0.150
     7.665   131.266     0.150
     7.665   137.914     0.150
     7.704   116.820     0.150
     7.989   117.984     0.150
     7.989   204.055     0.150
     8.044   117.586     0.150
     8.135   118.812     0.150
     8.135   206.852     0.150
     8.142   118.914     0.150
     8.142   206.594     0.150
     8.161   118.766     0.150
     8.161   207.305     0.150
     8.211   121.211     0.150
     8.196   122.102     0.150
     8.237   120.523     0.150
     8.237   209.133     0.150
     8.264   121.961     0.150
     8.264   211.562     0.150
     8.296   124.500     0.150
     8.348   122.352     0.150
     8.348   212.570     0.150
     8.392   122.570     0.150
     8.353   120.305     0.150
     8.353   146.234     0.150
     8.409   124.070     0.150
     8.398   124.211     0.150
     8.398   222.055     0.150
     8.398   123.172     0.150
     8.450   126.695     0.150
     8.450   125.891     0.150
     8.450   218.070     0.150
     8.450   267.000     0.150
     8.450   124.492     0.150
     8.450   125.766     0.150
     8.450   126.086     0.150
     8.491   124.711     0.150
     8.596   128.562     0.150
     8.676   129.500     0.150
     8.818   130.406     0.150
     8.855   131.836     0.150
     8.846   128.859     0.150
     8.846   223.883     0.150
     8.944   133.125     0.150
     8.944   131.414     0.150
     8.973   131.086     0.150
     8.973   133.641     0.150
     8.973   132.180     0.150
     9.037   133.977     0.150
     9.039   134.359     0.150
     9.519   137.266     0.150
     9.519   241.992     0.150
     9.597   139.289     0.150
     9.597   242.211     0.150
     9.508   140.102     0.150
     9.622   141.359     0.150
     9.822   142.766     0.150
     9.768   143.312     0.150
     9.782   144.156     0.150
     9.818   141.984     0.150
     9.818   144.906     0.150
    10.255   149.523     0.150
    10.402   149.844     0.150
    10.608   154.102     0.150
    10.635   153.875     0.150
    10.701   155.703     0.150
    10.826   159.930     0.150
    10.826   199.992     0.150
    10.958   158.180     0.150
    10.965   157.820     0.150
    10.965   158.898     0.150
    11.442   162.727     0.150
    11.845   167.930     0.150
    12.340   174.086     0.150
    12.340   306.086     0.150
    12.362   176.102     0.150
    12.763   179.984     0.150
    12.763   316.281     0.150
    12.813   181.344     0.150
    12.971   321.781     0.150
    13.601   190.383     0.150
    13.601   336.484     0.150
    13.588   192.547     0.150
    14.164   198.781     0.150
    14.164   349.383     0.150
    14.195   198.523     0.150
    14.195   198.180     0.150
    14.183   204.844     0.150
    14.581   203.383     0.150
    14.772   207.562     0.150
    14.768   208.484     0.150
    14.768   214.766     0.150
    14.893   216.094     0.150
    14.893   210.180     0.150
    14.893   209.984     0.150
    14.893   210.047     0.150
    14.893   387.016     0.150
    14.893   469.625     0.150
    14.994   368.312     0.150
    15.345   213.922     0.150
    15.265   222.133     0.150
    15.265   390.305     0.150
    15.341   215.430     0.150
    15.625   223.984     0.150
    15.625   396.359     0.150
    15.662   223.297     0.150
    15.675   224.969     0.150
    15.683   224.609     0.150
    15.859   225.750     0.150
    15.951   222.984     0.150
    15.951   398.781     0.150
    15.919   230.023     0.150
    15.919   223.211     0.150
    15.919   225.984     0.150
    16.047   229.617     0.150
    16.055   228.281     0.150
    16.126   227.422     0.150
    16.260   225.484     0.150
    16.260   398.086     0.150
    16.275   224.984     0.150
    16.190   229.102     0.150
    16.190   231.023     0.150
    16.241   231.516     0.150
    16.266   229.453     0.150
    16.266   233.578     0.150
    16.470   232.109     0.150
    16.470   236.000     0.150
    16.546   234.727     0.150
    16.596   231.484     0.150
    16.596   409.164     0.150
    16.596   231.727     0.150
    16.729   235.945     0.150
    16.729   238.656     0.150
    16.806   238.906     0.150
    16.808   239.609     0.150
    16.817   236.703     0.150
    16.817   239.773     0.150
    16.896   234.469     0.150
    16.896   533.898     0.150
    16.896   236.727     0.150
    16.964   235.352     0.150
    17.004   235.375     0.150
    17.004   234.750     0.150
    17.004   236.086     0.150
    17.004   234.984     0.150
    17.074   237.500     0.150
    17.008   241.883     0.150
    17.133   241.523     0.150
    17.413   240.844     0.150
    17.444   248.492     0.150
    17.586   243.422     0.150
    17.708   250.055     0.150
    18.130   254.742     0.150
    18.273   253.336     0.150
    18.273   454.547     0.150
    18.273   583.859     0.150
    18.273   450.562     0.150
    18.326   254.234     0.150
    18.326   253.094     0.150
    18.326   460.281     0.150
    18.295   254.867     0.150
    18.295   256.305     0.150
    18.348   253.680     0.150
    18.305   256.141     0.150
    18.564   256.352     0.150
    18.564   468.836     0.150
    18.564   256.945     0.150
    18.794   262.938     0.150
    18.877   261.680     0.150
    18.877   262.289     0.150
    19.140   263.375     0.150
    19.068   263.883     0.150
    19.068   264.266     0.150
    19.360   265.984     0.150
    19.320   266.883     0.150
    19.320   485.086     0.150
    19.471   267.766     0.150
    19.559   269.891     0.150
    19.649   270.180     0.150
    19.649   277.484     0.150
    19.649   483.383     0.150
    19.635   268.633     0.150
    19.654   271.383     0.150
    19.654   490.781     0.150
    19.654   271.586     0.150
    19.654   492.180     0.150
    19.669   269.539     0.150
    19.669   269.281     0.150
    19.863   489.484     0.150
    19.920   272.414     0.150
    20.163   276.359     0.150
    20.163   277.062     0.150
    20.204   276.883     0.150
    20.204   503.281     0.150
    20.289   276.484     0.150
    20.380   277.570     0.150
    20.380   276.383     0.150
    20.317   278.344     0.150
    20.317   277.648     0.150
    20.384   279.172     0.150
    20.526   280.156     0.150
    20.658   283.883     0.150
    20.658   511.781     0.150
    20.692   282.281     0.150
    20.830   284.391     0.150
    20.830   514.406     0.150
    20.767   282.055     0.150
    21.133   287.180     0.150
    21.332   288.875     0.150
    21.332   527.984     0.150
    21.332   290.148     0.150
    21.332   290.883     0.150
    21.332   291.445     0.150
    21.332   287.109     0.150
    21.332   289.180     0.150
    21.392   290.117     0.150
    21.643   289.867     0.150
    21.643   289.930     0.150
    21.643   526.719     0.150
    21.643   290.320     0.150
    21.838   293.430     0.150
    21.796   294.539     0.150
    22.021   296.477     0.150
    22.010   297.523     0.150
    22.357   301.109     0.150
    22.618   303.391     0.150
    22.647   304.680     0.150
    22.760   303.281     0.150
    23.019   308.672     0.150
    23.187   566.711     0.150
    23.183   307.180     0.150
    23.183   558.680     0.150
    23.248   307.484     0.150
    23.289   307.641     0.150
    23.289   564.922     0.150
    23.289   307.336     0.150
    23.289   331.383     0.150
    23.289   561.383     0.150
    23.289   597.180     0.150
    23.271   309.656     0.150
    23.308   308.414     0.150
    23.308   562.109     0.150
    23.308   307.984     0.150
    23.308   308.086     0.150
    23.571   312.383     0.150
    23.571   568.484     0.150
    23.507   311.539     0.150
    23.507   309.836     0.150
    23.507   312.133     0.150
    23.507   309.680     0.150
    23.507   310.680     0.150
    23.507   565.086     0.150
    23.548   311.586     0.150
    23.548   570.281     0.150
    24.202   316.617     0.150
    24.202   575.062     0.150
    24.202   316.383     0.150
    24.648   321.125     0.150
    24.648   320.141     0.150
    24.648   321.930     0.150
    24.648   321.383     0.150
    25.107   326.883     0.150
    25.462   328.383     0.150
    25.462   599.086     0.150
    25.524   332.672     0.150
    25.541   329.984     0.150
    25.541   365.281     0.150
    25.541   597.281     0.150
    25.861   333.984     0.150
    25.861   601.383     0.150
    25.861   665.086     0.150
    26.095   337.727     0.150
    26.219   338.930     0.150
    26.219   339.281     0.150
    26.662   339.383     0.150
    26.836   341.922     0.150
    26.916   342.031     0.150
    26.916   341.523     0.150
    26.940   343.781     0.150
    26.940   621.680     0.150
    27.301   346.883     0.150
    27.368   346.281     0.150
    27.541   348.883     0.150
    27.810   351.883     0.150
    27.810   638.281     0.150
    27.789   349.242     0.150
    27.789   638.711     0.150
    27.789   348.680     0.150
    27.851   352.672     0.150
    27.947   349.883     0.150
    28.121   351.781     0.150
    28.121   634.781     0.150
    28.164   356.383     0.150
    28.349   355.383     0.150
    28.295   355.320     0.150
    28.295   769.641     0.150
    28.834   358.383     0.150
    28.834   651.883     0.150
    29.048   362.773     0.150
    29.048   360.414     0.150
    29.048   362.383     0.150
    29.209   364.180     0.150
    29.209   656.180     0.150
    29.320   364.336     0.150
    29.320   550.484     0.150
    29.320   772.617     0.150
    29.553   366.273     0.150
    29.553   549.367     0.150
    29.553   771.992     0.150
    29.553   365.031     0.150
    29.553   549.234     0.150
    29.553   770.281     0.150
    29.566   366.383     0.150
    29.591   367.242     0.150
    29.591   364.805     0.150
    29.625   366.586     0.150
    29.625   667.281     0.150
    29.625   779.586     0.150
    29.653   368.039     0.150
    29.809   366.625     0.150
    29.809   368.312     0.150
    29.809   368.023     0.150
    29.809   550.312     0.150
    29.809   663.797     0.150
    29.809   772.719     0.150
    29.809   550.180     0.150
    29.809   663.195     0.150
    29.722   367.180     0.150
    29.722   662.883     0.150
    29.828   366.883     0.150
    29.846   367.680     0.150
    29.840   368.680     0.150
    29.841   369.164     0.150
    29.841   368.484     0.150
    29.841   368.875     0.150
    29.841   664.820     0.150
    29.841   369.383     0.150
    29.992   369.031     0.150
    29.992   369.984     0.150
    30.430   374.938     0.150
    30.427   375.125     0.150
    30.487   375.391     0.150
    30.487   375.227     0.150
    30.612   376.234     0.150
    30.612   375.109     0.150
    30.612   374.086     0.150
    30.959   377.586     0.150
    30.959   439.883     0.150
    30.959   550.781     0.150
    30.959   680.586     0.150
    30.959   784.984     0.150
    31.201   379.141     0.150
    31.201   379.758     0.150
    31.201   379.484     0.150
    31.201     2.898     0.150
    31.201     4.797     0.150
    31.201   686.781     0.150
    31.201   379.891     0.150
    31.201   378.984     0.150
    31.339   380.281     0.150
    31.385   382.180     0.150
    31.685   385.148     0.150
    31.931   387.812     0.150
    32.128   390.000     0.150
    32.414   390.781     0.150
    32.422   391.383     0.150
    32.422   391.773     0.150
    32.614   393.586     0.150
    32.968   395.383     0.150
    33.053   397.680     0.150
    33.068   397.680     0.150
    33.221   396.586     0.150
    33.280   399.383     0.150
    33.417   401.070     0.150
    33.484   400.555     0.150
    33.720   403.289     0.150
    33.747   403.320     0.150
    33.841   404.078     0.150
    33.929   404.969     0.150
    33.949   402.891     0.150
    33.949   403.422     0.150
    33.949   403.680     0.150
    33.949   403.086     0.150
    33.949   403.281     0.150
    33.973   405.086     0.150
    34.000   405.141     0.150
    34.040   406.211     0.150
    34.147   406.086     0.150
    34.047   406.242     0.150
    34.080   405.062     0.150
    34.088   406.156     0.150
    34.090   406.602     0.150
    34.164   407.000     0.150
    34.166   407.328     0.150
    34.232   407.883     0.150
    34.294   410.180     0.150
    34.294   408.180     0.150
    34.314   408.727     0.150
    34.385   409.281     0.150
    34.385   409.180     0.150
    34.453   409.984     0.150
    34.563   409.984     0.150
    34.603   408.680     0.150
    34.693   412.375     0.150
    34.728   410.086     0.150
    34.755   407.680     0.150
    34.768   412.820     0.150
    34.791   414.078     0.150
    35.003   413.281     0.150
    35.003   490.680     0.150
    35.003   746.086     0.150
    34.962   411.484     0.150
    34.984   415.375     0.150
    34.986   414.867     0.150
    35.009   415.227     0.150
    35.039   415.414     0.150
    35.040   414.742     0.150
    35.057   415.836     0.150
    35.077   414.680     0.150
    35.100   415.312     0.150
    35.208   415.852     0.150
    35.242   417.016     0.150
    35.271   417.938     0.150
    35.400   417.984     0.150
    35.366   415.680     0.150
    35.366   744.984     0.150
    35.384   415.586     0.150
    35.404   418.602     0.150
    35.425   417.406     0.150
    35.447   418.828     0.150
    35.455   418.438     0.150
    35.455   415.984     0.150
    35.455   418.383     0.150
    35.478   418.219     0.150
    35.524   419.586     0.150
    35.520   418.727     0.150
    35.520   756.930     0.150
    35.520   420.180     0.150
    35.577   419.398     0.150
    35.690   418.227     0.150
    35.690   497.312     0.150
    35.690   754.930     0.150
    35.690   896.633     0.150
    35.738   420.883     0.150
    35.933   420.703     0.150
    35.933   760.234     0.150
    35.933   420.109     0.150
    35.933   420.484     0.150
    35.933   420.281     0.150
    35.924   422.484     0.150
    35.928   422.914     0.150
    36.003   423.609     0.150
    36.184   424.586     0.150
    36.107   424.781     0.150
    36.122   421.883     0.150
    36.128   423.914     0.150
    36.141   422.383     0.150
    36.150   422.383     0.150
    36.148   424.352     0.150
    36.159   422.086     0.150
    36.193   424.844     0.150
    36.287   423.781     0.150
    36.386   424.945     0.150
    36.440   426.875     0.150
    36.484   427.086     0.150
    36.478   427.227     0.150
    36.504   427.586     0.150
    36.544   428.781     0.150
    36.631   429.156     0.150
    36.738   429.484     0.150
    36.683   429.500     0.150
    36.812   427.633     0.150
    36.812   569.500     0.150
    36.812   795.398     0.150
    36.756   427.781     0.150
    36.883   428.781     0.150
    36.811   430.328     0.150
    37.050   431.648     0.150
    37.187   433.469     0.150
    37.250   433.383     0.150
    37.322   432.867     0.150
    37.322   778.922     0.150
    37.378   435.039     0.150
    37.397   434.883     0.150
    37.404   435.883     0.150
    37.523   436.086     0.150
    37.459   435.023     0.150
    37.490   433.383     0.150
    37.486   436.484     0.150
    37.534   436.484     0.150
    37.643   437.281     0.150
    37.661   437.625     0.150
    37.666   437.000     0.150
    37.706   437.086     0.150
    37.706   437.484     0.150
    37.749   437.281     0.150
    37.749   437.180     0.150
    37.798   438.555     0.150
    37.936   436.586     0.150
    37.936   789.680     0.150
    37.851   438.711     0.150
    37.881   439.148     0.150
    37.913   439.086     0.150
    37.942   439.102     0.150
    37.968   439.867     0.150
    38.015   439.242     0.150
    38.099   438.781     0.150
    38.147   438.883     0.150
    38.142   440.836     0.150
    38.176   441.297     0.150
    38.202   442.164     0.150
    38.235   440.250     0.150
    38.547   442.273     0.150
    38.547   575.023     0.150
    38.547   801.352     0.150
    38.518   444.383     0.150
    38.544   444.688     0.150
    38.583   444.852     0.150
    38.795   444.422     0.150
    38.879   445.383     0.150
    38.882   445.328     0.150
    38.882   445.484     0.150
    38.887   445.281     0.150
    38.917   447.305     0.150
    39.067   446.227     0.150
    39.067   446.586     0.150
    39.183   448.984     0.150
    39.231   446.383     0.150
    39.231   538.680     0.150
    39.231   577.086     0.150
    39.231   803.383     0.150
    39.231   975.281     0.150
    39.340   451.102     0.150
    39.358   450.891     0.150
    39.473   452.812     0.150
    39.494   452.961     0.150
    39.494   451.664     0.150
    39.521   453.445     0.150
    39.727   453.570     0.150
    39.850   454.383     0.150
    39.857   453.570     0.150
    39.857   454.859     0.150
    39.870   455.883     0.150
    40.030   457.219     0.150
    40.076   455.883     0.150
    40.087   456.984     0.150
    40.228   458.086     0.150
    40.319   459.086     0.150
    40.524   460.984     0.150
    40.524   827.680     0.150
    40.437   460.180     0.150
    40.477   458.281     0.150
    40.477   459.820     0.150
    40.477   458.586     0.150
    40.537   460.883     0.150
    40.562   456.883     0.150
    40.652   460.984     0.150
    40.792   464.062     0.150
    40.912   464.383     0.150
    40.912   554.883     0.150
    40.912  1018.883     0.150
    40.956   462.680     0.150
    40.952   464.086     0.150
    41.108   463.406     0.150
    41.038   461.781     0.150
    41.230   465.086     0.150
    41.111   464.484     0.150
    41.210   467.281     0.150
    41.225   466.180     0.150
    41.297   466.836     0.150
    41.297   467.180     0.150
    41.297   563.180     0.150
    41.373   467.602     0.150
    41.403   465.602     0.150
    41.476   468.602     0.150
    41.585   468.203     0.150
    41.585   467.984     0.150
    41.646   469.570     0.150
    41.740   470.461     0.150
    41.740   470.680     0.150
    41.792   470.680     0.150
    41.792   561.781     0.150
    41.792  1037.383     0.150
    41.894   471.281     0.150
    41.937   471.281     0.150
    41.915   472.102     0.150
    41.915   472.383     0.150
    41.915   569.984     0.150
    41.917   471.586     0.150
    41.981   472.586     0.150
    42.048   473.281     0.150
    42.048   571.586     0.150
    42.048   473.383     0.150
    42.090   473.680     0.150
    42.090   567.781     0.150
    42.090  1041.680     0.150
    42.114   473.594     0.150
    42.156   473.984     0.150
    42.156   569.688     0.150
    42.160   474.180     0.150
    42.160   571.180     0.150
    42.160  1043.180     0.150
    42.258   474.773     0.150
    42.263   474.883     0.150
    42.263  1050.180     0.150
    42.289   475.180     0.150
    42.289   570.383     0.150
    42.289  1045.281     0.150
    42.289   475.227     0.150
    42.289   571.102     0.150
    42.407   474.484     0.150
    42.438   476.383     0.150
    42.438   572.711     0.150
    42.494   476.883     0.150
    42.637   477.484     0.150
    42.632   477.859     0.150
    42.632   478.281     0.150
    42.639   477.984     0.150
    42.639  1056.586     0.150
    42.694   478.641     0.150
    42.694   575.133     0.150
    42.703   478.430     0.150
    42.740   477.742     0.150
    42.740   476.977     0.150
    42.857   479.883     0.150
    42.865   479.297     0.150
    42.865   478.180     0.150
    42.865   479.781     0.150
    43.024   481.242     0.150
    43.030   481.406     0.150
    43.030   590.734     0.150
    43.030   871.352     0.150
    43.030   480.883     0.150
    43.193   480.930     0.150
    43.210   482.680     0.150
    43.238   482.883     0.150
    43.238   582.383     0.150
    43.238  1064.883     0.150
    43.306   483.883     0.150
    43.306   587.586     0.150
    43.306  1069.586     0.150
    43.445   484.781     0.150
    43.363   484.328     0.150
    43.363   587.539     0.150
    43.513   484.781     0.150
    43.513   871.180     0.150
    43.420   485.086     0.150
    43.425   484.734     0.150
    43.425   587.523     0.150
    43.431   484.180     0.150
    43.431   589.281     0.150
    43.431  1072.680     0.150
    43.481   485.086     0.150
    43.482   485.211     0.150
    43.515   484.844     0.150
    43.515   588.133     0.150
    43.583   590.453     0.150
    43.583   485.781     0.150
    43.802   484.984     0.150
    43.720   487.180     0.150
    43.836   486.953     0.150
    43.830   487.297     0.150
    43.830   591.242     0.150
    43.830   485.609     0.150
    43.830   590.773     0.150
    43.891   486.180     0.150
    43.896   487.680     0.150
    43.896  1080.781     0.150
    43.896   487.281     0.150
    43.934   488.086     0.150
    43.948   488.203     0.150
    43.948   592.734     0.150
    44.037   489.312     0.150
    44.189   489.680     0.150
    44.189   591.883     0.150
    44.189   878.883     0.150
    44.189  1081.883     0.150
    44.198   490.586     0.150
    44.378   490.727     0.150
    44.337   490.383     0.150
    44.375   490.383     0.150
    44.576   493.383     0.150
    44.576  1092.984     0.150
    44.620   493.531     0.150
    44.620   594.945     0.150
    44.728   494.484     0.150
    44.780   493.680     0.150
    44.780   494.781     0.150
    44.780   495.781     0.150
    44.799   494.531     0.150
    44.843   494.266     0.150
    45.244   497.102     0.150
    45.244   499.273     0.150
    45.244   500.180     0.150
    45.244   499.781     0.150
    45.298   497.109     0.150
    45.317   497.883     0.150
    45.340   498.914     0.150
    45.340   603.094     0.150
    45.373   498.914     0.150
    45.373   604.773     0.150
    45.474   500.586     0.150
    45.555   499.164     0.150
    45.500   499.375     0.150
    45.555   498.883     0.150
    45.555     4.102     0.150
    45.555   911.383     0.150
    45.516   498.961     0.150
    45.524   500.133     0.150
    45.558   498.984     0.150
    45.653   501.312     0.150
    45.670   500.586     0.150
    45.675   500.883     0.150
    45.653   501.492     0.150
    45.653   598.266     0.150
    45.634   500.922     0.150
    45.634   599.188     0.150
    45.691   501.273     0.150
    45.691   599.148     0.150
    45.712   500.484     0.150
    45.712   500.484     0.150
    45.712   500.508     0.150
    45.805   501.633     0.150
    45.831   501.977     0.150
    45.897   502.125     0.150
    45.898   502.625     0.150
    45.898   502.172     0.150
    45.906   503.141     0.150
    45.906   599.305     0.150
    45.931   502.195     0.150
    45.939   505.883     0.150
    45.983   503.742     0.150
    45.983   600.055     0.150
    46.171   504.055     0.150
    46.384   507.180     0.150
    46.373   506.016     0.150
    46.373   506.273     0.150
    46.373   505.781     0.150
    46.525   508.344     0.150
    46.683   511.383     0.150
    46.619   508.883     0.150
    46.805   511.180     0.150
    46.861   510.242     0.150
    46.930   510.961     0.150
    47.094   512.375     0.150
    47.242   513.383     0.150
    47.243   513.789     0.150
    47.243   513.312     0.150
    47.254   512.984     0.150
    47.199   514.883     0.150
    47.395   514.984     0.150
    47.429   514.094     0.150
    47.429   514.383     0.150
    47.429   515.680     0.150
    47.515   514.250     0.150
    47.479   516.711     0.150
    47.479   517.016     0.150
    47.547   516.039     0.150
    47.609   516.070     0.150
    47.887   518.922     0.150
    47.960   519.195     0.150
    47.970   521.031     0.150
    48.156   520.344     0.150
    48.369   523.281     0.150
    48.547   523.430     0.150
    48.618   523.914     0.150
    48.648   525.180     0.150
    48.677   525.773     0.150
    48.677   526.180     0.150
    48.723   524.625     0.150
    48.824   526.383     0.150
    48.844   525.711     0.150
    49.081   527.586     0.150
    49.081   528.383     0.150
    49.206   529.383     0.150
    49.155   529.109     0.150
    49.203   529.211     0.150
    49.203   528.367     0.150
    49.203   527.992     0.150
    49.203   529.273     0.150
    49.441   531.250     0.150
    49.441   531.594     0.150
    49.441   530.484     0.150
    49.475   531.609     0.150
    49.589   530.945     0.150
    49.615   532.727     0.150
    49.664   532.281     0.150
    49.663   533.680     0.150
    49.862   534.227     0.150
    50.322   536.633     0.150
    50.322   537.453     0.150
    50.514   539.586     0.150
    51.313   544.086     0.150
    51.313   544.484     0.150
    51.313   545.844     0.150
    51.369   545.133     0.150
    51.558   546.594     0.150
    51.625   547.453     0.150
    51.799   547.445     0.150
    52.595   555.281     0.150
    52.809   555.273     0.150
    52.831   555.977     0.150
    52.861   555.484     0.150
    53.011   556.805     0.150
    53.090   560.086     0.150
    53.090  1011.781     0.150
    53.033   556.727     0.150
    53.056   556.492     0.150
    53.052   557.414     0.150
    53.156   557.820     0.150
    53.315   558.883     0.150
    53.237   558.305     0.150
    53.274   558.742     0.150
    53.288   559.195     0.150
    53.366   559.891     0.150
    53.373   559.109     0.150
    53.379   559.734     0.150
    53.397   560.984     0.150
    53.455   559.836     0.150
    53.456   560.008     0.150
    53.484   560.281     0.150
    53.699   561.961     0.150
    53.812   563.062     0.150
    53.817   563.672     0.150
    53.817   866.156     0.150
    53.817   562.875     0.150
    53.817   866.273     0.150
    53.763   561.984     0.150
    53.852   562.883     0.150
    53.898   563.086     0.150
    53.818   562.906     0.150
    53.912   563.305     0.150
    53.934   563.859     0.150
    54.041   564.680     0.150
    54.041   627.180     0.150
    54.041   686.883     0.150
    54.041  1237.484     0.150
    54.041   564.359     0.150
    54.041   564.086     0.150
    53.966   563.516     0.150
    53.996   563.695     0.150
    54.096   564.523     0.150
    54.098   564.961     0.150
    54.474   566.984     0.150
    54.534   567.641     0.150
    54.557   567.484     0.150
    55.523   574.984     0.150
    55.701   576.391     0.150
    55.726   576.680     0.150
    55.911   577.281     0.150
    55.911   577.586     0.150
    55.952   578.781     0.150
    56.030   578.883     0.150
    56.172   580.180     0.150
    56.172   579.883     0.150
    56.404   581.383     0.150
    56.404   581.281     0.150
    57.423   590.086     0.150
    57.913   591.883     0.150
    58.100   593.484     0.150
    58.128   594.281     0.150
    58.138   594.617     0.150
    58.138   593.359     0.150
    58.347   595.883     0.150
    58.463   597.883     0.150
    58.463   595.984     0.150
    58.463   595.883     0.150
    59.377   600.781     0.150
    59.360   603.016     0.150
    59.792   606.586     0.150
    60.234   609.164     0.150
    60.315   608.383     0.150
    60.252   610.062     0.150
    60.292   610.016     0.150
    60.367   610.672     0.150
    60.437   611.242     0.150
    60.437  1113.266     0.150
    60.566   612.375     0.150
    60.599   612.141     0.150
    60.694   612.172     0.150
    60.694  1117.320     0.150
    60.863   612.719     0.150
    60.863   613.102     0.150
    60.806   612.156     0.150
    60.905   614.633     0.150
    60.921   613.852     0.150
    61.051   614.883     0.150
    61.124   616.211     0.150
    61.179   616.227     0.150
    61.244   616.820     0.150
    61.408   615.586     0.150
    61.408   614.070     0.150
    61.408   614.914     0.150
    61.420   615.086     0.150
    61.349   615.461     0.150
    61.349   616.023     0.150
    61.430   617.422     0.150
    61.487   618.070     0.150
    61.579   618.781     0.150
    61.664   619.562     0.150
    61.718   619.305     0.150
    61.718  1125.500     0.150
    61.861   620.453     0.150
    61.976   616.180     0.150
    61.976  1118.281     0.150
    62.440   619.805     0.150
    62.440   620.820     0.150
    61.938   620.977     0.150
    62.043   620.586     0.150
    61.979   621.586     0.150
    62.056   622.000     0.150
    62.231   621.742     0.150
    62.231   623.156     0.150
    62.231   623.234     0.150
    62.394   624.406     0.150
    62.438   623.195     0.150
    62.438   623.977     0.150
    62.438   623.680     0.150
    62.547   623.883     0.150
    62.637   624.242     0.150
    62.637   625.562     0.150
    62.703   624.383     0.150
    63.290   628.984     0.150
    63.487   632.258     0.150
    63.854   632.164     0.150
    63.854   633.086     0.150
    64.070   636.016     0.150
    64.070   633.883     0.150
    64.092   635.383     0.150
    67.192   654.727     0.150
    67.192   653.984     0.150
    67.844   660.586     0.150
    68.647   663.320     0.150
    69.144   667.664     0.150
    69.946   672.516     0.150
    69.957   672.883     0.150
    70.545   676.766     0.150
    70.566   677.289     0.150
    70.732   675.789     0.150
    70.705   677.703     0.150
    70.705  1240.906     0.150
    71.762   684.641     0.150
    72.451   685.703     0.150
    72.451   687.500     0.150
    72.451   686.781     0.150
    72.951   691.906     0.150
    73.211   692.531     0.150
    73.211   691.883     0.150
    73.417   693.812     0.150
    73.482   695.086     0.150
    73.651   694.180     0.150
    73.651   695.211     0.150
    73.950   694.445     0.150
    74.210   697.000     0.150
    74.298   696.812     0.150
    74.412   697.484     0.150
    74.412   697.984     0.150
    74.412   698.773     0.150
    74.412   698.484     0.150
    74.691   700.086     0.150
    74.739   699.930     0.150
    75.084   702.984     0.150
    74.692   701.539     0.150
    75.112   701.602     0.150
    75.714   705.383     0.150
    75.714   705.586     0.150
    75.780   705.680     0.150
    75.985   707.852     0.150
    75.985   707.086     0.150
    76.261   708.102     0.150
    76.243   709.555     0.150
    76.243   709.680     0.150
    76.243   708.383     0.150
    76.407   711.930     0.150
    76.407   712.180     0.150
    76.487   708.781     0.150
    76.566   708.383     0.150
    76.566   708.727     0.150
    76.566   709.266     0.150
    76.581   708.680     0.150
    76.581     4.906     0.150
    76.979   712.281     0.150
    77.887   716.984     0.150
    78.739   721.383     0.150
    78.988   722.680     0.150
    79.156   724.703     0.150
    80.636   734.133     0.150
    80.942   733.922     0.150
    81.212   735.781     0.150
    81.212   735.477     0.150
    81.212  1852.938     0.150
    81.212   735.016     0.150
    81.212   735.781     0.150
    81.220   736.180     0.150
    81.220   735.781     0.150
    81.437   737.211     0.150
    83.054   744.891     0.150
    83.054   744.664     0.150
    83.054   745.086     0.150
    83.054   744.883     0.150
    83.390   747.219     0.150
    83.390  1847.141     0.150
    83.390   747.672     0.150
    83.421   747.484     0.150
    83.675   748.484     0.150
    84.572   752.680     0.150
    85.363   757.828     0.150
    89.972   778.992     0.150
    90.712   783.484     0.150
    90.722   782.320     0.150
    90.722   782.781     0.150
    90.722   783.086     0.150
    92.427   790.883     0.150
    93.880   796.039     0.150
    93.880  1024.711     0.150
    94.600   799.023     0.150
    94.600  1817.242     0.150
    94.600   799.781     0.150
    95.845   807.086     0.150
   100.052   825.586     0.150
   102.910   837.656     0.150
   102.910  1091.836     0.150
   102.910  1099.023     0.150
   106.759   856.375     0.150
   106.759  1104.953     0.150
   116.098  1125.055     0.150
   116.098  1751.641     0.150
   116.098  1122.680     0.150
   116.333  1123.992     0.150
   117.639  1125.734     0.150
   117.639  1746.094     0.150
   117.639  1125.461     0.150
   118.653  1127.844     0.150
   118.653  1743.797     0.150
   118.810  1128.039     0.150
   118.810  1745.516     0.150
   119.459  1129.094     0.150
   119.459  1739.742     0.150
   122.271  1136.781     0.150
   123.813  1725.125     0.150
   124.495  1138.164     0.150
   126.872  1142.875     0.150
   128.917  1148.539     0.150
   129.551  1149.500     0.150
   129.926  1150.461     0.150
   130.750  1153.164     0.150
   131.004  1151.914     0.150
   131.004  1153.164     0.150
   132.451  1155.859     0.150
   133.133  1156.055     0.150
   133.365  1157.594     0.150
   134.919  1158.281     0.150
   134.919  1313.680     0.150
   134.919  1370.211     0.150
   138.951  1169.102     0.150
   138.951  1383.352     0.150
   138.951  1166.766     0.150
   138.951  1166.414     0.150
   146.372  1179.992     0.150
   146.918  1183.883     0.150
   148.087  1187.180     0.150
   148.525  1182.211     0.150
   148.735  1184.164     0.150
   148.987  1188.430     0.150
   148.987  1184.555     0.150
   148.987  1185.344     0.150
   149.906  1190.945     0.150
     1.423    47.312     0.150
     2.328    65.758     0.150
     2.328    65.758     0.150
     1.423    47.312     0.150
     2.328    65.758     0.150
     1.427    24.957     0.150
     1.427    43.746     0.150
     2.321    38.848     0.150
     2.321    41.027     0.150
     3.429    59.996     0.150
     3.429   103.289     0.150
     3.970    62.816     0.150
     3.970   110.848     0.150
     5.227    80.359     0.150
     5.227   140.559     0.150
     5.326   144.918     0.150
     5.879    92.348     0.150
     5.879   160.047     0.150
     6.449    95.969     0.150
     6.449   169.270     0.150
     7.582   113.609     0.150
     7.582   195.348     0.150
     7.742   112.547     0.150
     7.706   115.867     0.150
     8.127   118.879     0.150
     8.127   206.246     0.150
     8.154   118.328     0.150
     8.154   206.059     0.150
     8.229   119.227     0.150
     8.300   123.477     0.150
     8.404   122.348     0.150
     8.484   122.887     0.150
     8.484   217.977     0.150
     8.454   125.426     0.150
     8.454   220.516     0.150
     8.599   127.809     0.150
     8.679   129.637     0.150
     8.839   128.957     0.150
     8.859   130.488     0.150
     8.946   131.867     0.150
     8.946   130.309     0.150
     8.976   130.449     0.150
     8.976   130.148     0.150
     9.044   133.609     0.150
     9.041   133.488     0.150
     9.511   136.488     0.150
     9.511   240.207     0.150
    10.395   148.848     0.150
    11.436   161.918     0.150
    11.517   162.398     0.150
    11.517   284.688     0.150
    12.333   173.148     0.150
    12.333   304.746     0.150
    12.806   180.039     0.150
    12.806   318.469     0.150
    12.756   179.648     0.150
    12.756   314.848     0.150
    12.963   182.047     0.150
    13.369   186.539     0.150
    13.369   327.129     0.150
    13.594   189.746     0.150
    14.157   197.148     0.150
    14.188   196.848     0.150
    14.390   200.047     0.150
    14.574   203.148     0.150
    14.770   207.738     0.150
    14.896   210.949     0.150
    14.896   211.246     0.150
    14.896   210.070     0.150
    14.896   211.539     0.150
    15.951   224.047     0.150
    15.951   229.547     0.150
    16.603   231.098     0.150
    16.603   231.617     0.150
    16.900   233.598     0.150
    17.008   239.418     0.150
    17.008   237.086     0.150
    17.008   235.949     0.150
    17.067   417.047     0.150
    18.280   253.121     0.150
    18.280   451.699     0.150
    18.332   253.039     0.150
    18.557   254.926     0.150
    18.557   467.328     0.150
    19.362   265.746     0.150
    19.870   483.047     0.150
    21.339   287.691     0.150
    21.339   284.699     0.150
    21.646   289.223     0.150
    21.646   289.047     0.150
    23.190   306.547     0.150
    23.315   307.898     0.150
    23.296   305.977     0.150
    23.296   306.746     0.150
    23.296   307.449     0.150
    23.296   330.746     0.150
    23.296   560.449     0.150
    23.296   593.648     0.150
    23.515   309.746     0.150
    23.569   312.348     0.150
    29.553   365.848     0.150
    29.553   547.918     0.150
    29.553   364.816     0.150
    29.560   364.746     0.150
    29.565   364.746     0.150
    29.848   368.199     0.150
    29.802   366.156     0.150
    29.802   367.406     0.150
    29.802   549.695     0.150
    29.802   770.961     0.150
    29.802   366.156     0.150
    29.991   368.809     0.150
    29.991   370.047     0.150
    31.209   377.648     0.150
    31.209   439.547     0.150
    32.121   389.879     0.150
    32.581   391.578     0.150
    33.957   402.133     0.150
    33.957   402.848     0.150
    33.957   401.246     0.150
    33.957   402.949     0.150
    34.611   408.148     0.150
    34.736   408.047     0.150
    34.993   413.438     0.150
    34.881   411.508     0.150
    35.391   413.547     0.150
    35.527   419.148     0.150
    35.698   415.707     0.150
    35.698   494.637     0.150
    35.698   751.879     0.150
    35.698   892.867     0.150
    35.938   419.848     0.150
    35.938   419.656     0.150
    35.938   420.348     0.150
    36.130   420.047     0.150
    36.148   420.008     0.150
    36.394   423.617     0.150
    36.448   425.398     0.150
    36.814   426.746     0.150
    37.806   437.598     0.150
    37.920   437.719     0.150
    37.929   437.848     0.150
    37.949   437.777     0.150
    38.886   443.848     0.150
    38.889   444.480     0.150
    39.028   445.777     0.150
    39.502   451.617     0.150
    39.494   449.426     0.150
    39.734   452.988     0.150
    39.865   453.527     0.150
    41.006   463.449     0.150
    41.305   466.207     0.150
    41.800   469.879     0.150
    42.097   472.848     0.150
    42.122   472.477     0.150
    42.415   473.449     0.150
    42.415   473.617     0.150
    42.748   475.848     0.150
    42.748   476.574     0.150
    42.748   475.879     0.150
    42.785   476.547     0.150
    43.377   483.477     0.150
    43.427   482.527     0.150
    43.427   480.637     0.150
    43.438   483.996     0.150
    43.522   483.379     0.150
    43.446   484.148     0.150
    43.513   483.246     0.150
    43.838   485.672     0.150
    43.838   483.906     0.150
    43.801   484.746     0.150
    44.001   486.246     0.150
    44.197   885.348     0.150
    44.383   489.121     0.150
    44.901   494.207     0.150
    44.901   492.469     0.150
    45.129   496.387     0.150
    45.270   496.988     0.150
    45.720   499.348     0.150
    45.720   499.398     0.150
    45.651   500.199     0.150
    45.651   500.539     0.150
    45.651   500.938     0.150
    46.146   502.609     0.150
    46.053   503.848     0.150
    46.383   505.941     0.150
    47.575   515.078     0.150
    47.950   518.316     0.150
    49.096   527.770     0.150
    49.210   527.965     0.150
    49.441   529.906     0.150
    50.329   536.379     0.150
    52.362   550.906     0.150
    53.464   558.715     0.150
    53.809   562.359     0.150
    53.815   562.199     0.150
    53.815   562.309     0.150
    54.081   565.246     0.150
    55.194   572.688     0.150
    55.388   574.777     0.150
    56.411   580.727     0.150
    57.910   592.688     0.150
    58.145   593.621     0.150
    58.145   592.246     0.150
    58.470   594.246     0.150
    58.470   596.316     0.150
    59.135   600.527     0.150
    60.611   611.148     0.150
    61.494   617.188     0.150
    64.099   634.707     0.150
    67.148   652.906     0.150
    67.185   653.188     0.150
    67.951   658.574     0.150
    69.998   670.176     0.150
    75.617   703.406     0.150
    75.690   704.418     0.150
    75.719   704.246     0.150
    75.982   705.727     0.150
    76.225   706.367     0.150
    76.571   708.457     0.150
    76.571   707.949     0.150
    76.571   707.836     0.150
    78.059   721.746     0.150
    79.161   723.777     0.150
    80.770   731.797     0.150
    80.946   732.559     0.150
    81.204   735.508     0.150
    83.059   743.973     0.150
    83.059   743.637     0.150
    83.383   746.555     0.150
    83.383   746.219     0.150
    85.356   759.789     0.150
    96.662   810.328     0.150
     1.427    27.066     0.150
     1.427    45.707     0.150
     2.321    64.375     0.150
     2.321    64.434     0.150
     2.321    37.254     0.150
     1.339    24.186     0.150
     1.410    25.215     0.150
     2.344    41.635     0.150
     2.344    41.865     0.150
     3.450   101.205     0.150
     3.993    63.725     0.150
     3.993   110.836     0.150
     4.730    73.965     0.150
     4.730   131.564     0.150
     4.874    76.055     0.150
     4.874   133.766     0.150
     4.845    77.916     0.150
     5.154    79.385     0.150
     5.250    81.115     0.150
     5.250   142.516     0.150
     5.353    84.145     0.150
     5.879    93.035     0.150
     5.879   161.234     0.150
     6.473    96.535     0.150
     6.473   169.824     0.150
     6.842   103.135     0.150
     7.420   110.455     0.150
     7.451   112.064     0.150
     7.451   196.246     0.150
     7.451   113.996     0.150
     7.565   195.455     0.150
     7.605   113.824     0.150
     7.605   195.545     0.150
     7.655   116.115     0.150
     7.655   203.666     0.150
     7.655   117.064     0.150
     8.177   118.596     0.150
     8.177   204.975     0.150
     8.291   123.404     0.150
     8.343   119.445     0.150
     8.343   210.055     0.150
     8.343   119.975     0.150
     8.388   123.672     0.150
     8.388   218.842     0.150
     8.388   123.545     0.150
     8.507   126.215     0.150
     8.507   216.904     0.150
     8.445   123.697     0.150
     8.445   216.521     0.150
     8.445   125.096     0.150
     8.445   220.686     0.150
     8.445   125.654     0.150
     8.445   124.436     0.150
     8.592   127.605     0.150
     8.674   128.695     0.150
     8.860   128.125     0.150
     8.851   130.836     0.150
     8.945   132.035     0.150
     8.945   131.285     0.150
     8.973   131.836     0.150
     8.973   132.135     0.150
     9.035   133.105     0.150
     9.034   133.725     0.150
     9.505   139.625     0.150
     9.621   141.355     0.150
     9.820   143.154     0.150
     9.767   144.006     0.150
    10.255   149.045     0.150
    10.361   151.096     0.150
    10.608   153.926     0.150
    10.629   153.746     0.150
    10.826   159.705     0.150
    10.965   158.395     0.150
    10.965   157.178     0.150
    10.965   283.053     0.150
    11.539   163.166     0.150
    11.539   285.885     0.150
    12.356   174.135     0.150
    12.356   306.336     0.150
    12.827   180.574     0.150
    12.827   318.395     0.150
    12.779   180.135     0.150
    12.987   182.734     0.150
    13.617   190.336     0.150
    13.580   191.480     0.150
    13.580   344.217     0.150
    14.180   197.936     0.150
    14.211   198.596     0.150
    14.211   198.135     0.150
    14.413   200.836     0.150
    14.597   203.836     0.150
    14.767   207.984     0.150
    14.767   208.086     0.150
    14.893   215.613     0.150
    14.893   209.936     0.150
    14.893   208.881     0.150
    14.893   210.475     0.150
    14.893   213.535     0.150
    15.333   218.064     0.150
    15.956   228.734     0.150
    16.276   225.635     0.150
    16.291   225.336     0.150
    16.582   231.895     0.150
    16.582   231.311     0.150
    16.582   415.768     0.150
    16.582   231.535     0.150
    16.891   233.238     0.150
    16.891   237.463     0.150
    16.999   239.516     0.150
    16.999   236.645     0.150
    16.999   237.885     0.150
    18.259   251.035     0.150
    18.259   451.178     0.150
    18.259   253.045     0.150
    18.259   454.057     0.150
    18.317   254.115     0.150
    18.317   252.287     0.150
    18.317   454.125     0.150
    18.338   254.734     0.150
    18.578   253.984     0.150
    18.578   465.455     0.150
    19.360   265.336     0.150
    20.396   275.936     0.150
    20.396   277.916     0.150
    21.316   287.082     0.150
    21.316   284.705     0.150
    21.316   290.336     0.150
    21.639   289.510     0.150
    22.083   298.166     0.150
    22.372   301.195     0.150
    22.744   304.535     0.150
    23.292   307.172     0.150
    23.292   308.035     0.150
    23.292   308.436     0.150
    23.329   312.635     0.150
    23.276   307.404     0.150
    23.276   307.836     0.150
    23.276   308.635     0.150
    23.276   335.734     0.150
    23.276   557.234     0.150
    23.491   310.936     0.150
    23.581   312.635     0.150
    24.187   315.836     0.150
    24.638   320.895     0.150
    24.638   318.795     0.150
    26.932   340.395     0.150
    27.775   348.836     0.150
    29.051   361.734     0.150
    29.558   364.930     0.150
    29.558   364.314     0.150
    29.708   367.916     0.150
    29.565   365.234     0.150
    29.571   365.234     0.150
    29.826   366.824     0.150
    29.826   369.135     0.150
    29.825   366.920     0.150
    29.825   367.734     0.150
    29.844   366.234     0.150
    29.997   370.166     0.150
    29.997   369.936     0.150
    31.186   379.836     0.150
    31.186   679.535     0.150
    31.186   798.535     0.150
    33.934   402.080     0.150
    33.934   402.686     0.150
    33.934   403.035     0.150
    33.934   403.035     0.150
    34.587   409.635     0.150
    34.712   408.836     0.150
    34.739   408.135     0.150
    34.970   414.195     0.150
    35.368   414.336     0.150
    35.440   417.734     0.150
    35.503   419.154     0.150
    35.675   418.145     0.150
    35.675    17.070     0.150
    35.675   500.135     0.150
    35.675   750.475     0.150
    35.675   900.314     0.150
    35.927   419.266     0.150
    35.927   420.135     0.150
    35.927   419.436     0.150
    36.106   422.035     0.150
    36.125   422.336     0.150
    36.134   422.035     0.150
    36.371   424.305     0.150
    36.424   425.824     0.150
    36.619   428.885     0.150
    36.812   426.162     0.150
    37.034   431.324     0.150
    37.474   433.336     0.150
    37.782   437.625     0.150
    37.926   438.545     0.150
    38.528   444.465     0.150
    38.867   444.275     0.150
    38.867   444.535     0.150
    39.005   446.154     0.150
    39.218   447.635     0.150
    39.478   452.135     0.150
    39.472   449.314     0.150
    39.710   450.535     0.150
    40.462   457.545     0.150
    40.502   458.855     0.150
    40.983   463.385     0.150
    41.121   464.074     0.150
    41.281   466.455     0.150
    41.281   466.035     0.150
    41.924   470.475     0.150
    42.074   472.855     0.150
    42.273   474.484     0.150
    42.394   473.836     0.150
    42.394   473.715     0.150
    42.727   477.055     0.150
    42.727   476.385     0.150
    42.727   476.545     0.150
    42.764   476.605     0.150
    43.180   479.836     0.150
    43.354   483.436     0.150
    43.405   483.484     0.150
    43.405   482.846     0.150
    43.499   484.016     0.150
    43.518   483.836     0.150
    43.814   485.926     0.150
    43.823   485.295     0.150
    43.809   484.234     0.150
    44.092   488.775     0.150
    44.323   489.756     0.150
    44.360   489.232     0.150
    44.877   494.814     0.150
    44.877   493.785     0.150
    45.105   496.455     0.150
    45.249   497.775     0.150
    45.246   497.186     0.150
    45.284   496.395     0.150
    45.501   497.996     0.150
    45.486   498.275     0.150
    45.510   499.225     0.150
    45.647   499.564     0.150
    45.662   500.635     0.150
    45.697   499.734     0.150
    45.697   499.506     0.150
    45.791   501.176     0.150
    45.884   501.615     0.150
    45.884   502.625     0.150
    46.917   509.975     0.150
    47.275   512.605     0.150
    47.381   514.525     0.150
    47.816   517.855     0.150
    47.927   518.734     0.150
    48.603   523.346     0.150
    49.065   527.734     0.150
    49.073   528.016     0.150
    49.191   528.215     0.150
    49.191   527.547     0.150
    49.191   527.805     0.150
    49.426   530.654     0.150
    50.102   537.984     0.150
    50.498   538.865     0.150
    52.804   555.756     0.150
    53.440   557.691     0.150
    53.820   562.395     0.150
    53.826   560.990     0.150
    55.365   575.025     0.150
    56.391   580.436     0.150
    58.122   593.480     0.150
    58.122   592.795     0.150
    58.447   595.436     0.150
    58.447   596.496     0.150
    58.605   597.805     0.150
    59.112   600.666     0.150
    61.035   613.926     0.150
    61.471   617.475     0.150
    62.690   624.535     0.150
    68.025   658.605     0.150
    69.988   670.336     0.150
    73.209   691.836     0.150
    73.945   693.605     0.150
    74.399   696.283     0.150
    74.733   698.545     0.150
    75.707   704.506     0.150
    75.707   703.535     0.150
    76.001   706.285     0.150
    76.242   708.945     0.150
    76.242   707.305     0.150
    76.255   707.186     0.150
    76.255   707.006     0.150
    76.561   708.186     0.150
    77.269   712.605     0.150
    77.903   717.205     0.150
    79.151   724.215     0.150
    80.938   733.035     0.150
    81.228   734.434     0.150
    81.228   735.234     0.150
    82.681   741.895     0.150
    82.681   741.996     0.150
    83.045   743.969     0.150
    83.406   746.295     0.150
    83.406   745.836     0.150
    83.661   747.484     0.150
   124.504  1136.855     0.150
   148.978  1187.912     0.150
     1.410    45.805     0.150
     2.344    64.816     0.150
     1.406    25.679     0.150
     2.349    41.569     0.150
     3.454   103.149     0.150
     3.997    65.519     0.150
     3.997   109.729     0.150
     4.735    75.749     0.150
     4.735   130.759     0.150
     4.843    77.119     0.150
     5.255    82.169     0.150
     5.255   142.029     0.150
     5.349    84.619     0.150
     5.349   145.179     0.150
     5.788    91.199     0.150
     5.788   156.369     0.150
     5.880    93.419     0.150
     5.880   161.719     0.150
     6.130    92.659     0.150
     6.130   159.438     0.150
     6.477    97.089     0.150
     6.477   171.369     0.150
     7.420   110.599     0.150
     7.759   199.979     0.150
     8.181   121.459     0.150
     8.181   206.699     0.150
     8.290   124.249     0.150
     8.386   222.475     0.150
     8.386   124.719     0.150
     8.445   126.013     0.150
     8.445   219.263     0.150
     8.445   124.519     0.150
     8.445   218.489     0.150
     8.445   126.320     0.150
     8.445   222.965     0.150
     8.445   126.569     0.150
     8.592   129.379     0.150
     8.863   130.719     0.150
     8.863   226.459     0.150
     8.850   131.609     0.150
     8.946   133.899     0.150
     9.034   133.938     0.150
     9.034   134.899     0.150
     9.539   139.509     0.150
     9.539   238.129     0.150
    10.418   151.979     0.150
    10.418   261.789     0.150
    10.966   159.359     0.150
    12.361   175.019     0.150
    12.361   308.019     0.150
    12.784   180.719     0.150
    12.784   318.419     0.150
    12.991   183.619     0.150
    12.991   324.119     0.150
    13.622   191.519     0.150
    13.622   338.619     0.150
    14.184   199.419     0.150
    14.184   352.619     0.150
    14.215   198.399     0.150
    14.215   199.019     0.150
    14.417   202.119     0.150
    14.417   357.019     0.150
    14.602   204.719     0.150
    14.767   209.109     0.150
    14.893   211.254     0.150
    14.893   214.179     0.150
    15.958   227.319     0.150
    16.281   226.319     0.150
    16.578   233.409     0.150
    16.578   232.956     0.150
    16.578   412.852     0.150
    16.578   232.849     0.150
    16.891   234.494     0.150
    16.998   238.688     0.150
    18.255   254.019     0.150
    18.255   452.669     0.150
    18.255   455.406     0.150
    18.314   255.769     0.150
    21.311   291.463     0.150
    21.311   287.539     0.150
    21.639   290.669     0.150
    23.287   309.269     0.150
    23.273   308.819     0.150
    23.584   313.519     0.150
    29.560   366.779     0.150
    29.560   366.549     0.150
    29.821   369.719     0.150
    29.830   369.830     0.150
    33.929   403.844     0.150
    33.929   403.109     0.150
    36.813   427.869     0.150
    38.863   445.588     0.150
    39.767   453.649     0.150
    39.836   453.979     0.150
    41.921   471.859     0.150
    42.723   478.159     0.150
    42.723   476.759     0.150
    43.176   481.149     0.150
    43.400   482.429     0.150
    43.810   487.719     0.150
    43.810   486.879     0.150
    43.820   487.209     0.150
    44.356   490.382     0.150
    44.826   495.289     0.150
    45.280   497.749     0.150
    45.300   497.999     0.150
    45.496   498.979     0.150
    45.482   499.969     0.150
    45.693   500.819     0.150
    45.693   500.694     0.150
    45.666   502.215     0.150
    45.787   502.179     0.150
    45.880   503.259     0.150
    46.153   505.029     0.150
    46.353   506.419     0.150
    47.590   514.349     0.150
    49.421   532.744     0.150
    49.421   530.009     0.150
    53.436   560.319     0.150
    54.678   569.339     0.150
    58.115   594.369     0.150
    58.117   595.219     0.150
    58.117   593.779     0.150
    58.442   596.169     0.150
    74.732   699.309     0.150
    75.045   702.059     0.150
    75.706   705.259     0.150
    75.823   707.179     0.150
    76.240   709.869     0.150
    76.215   708.869     0.150
    76.377   710.129     0.150
    76.448   709.619     0.150
    76.560   710.019     0.150
    83.043   745.294     0.150
    83.411   748.026     0.150
    83.411   748.899     0.150
    83.658   748.994     0.150
    83.658   749.499     0.150
   145.680  1179.993     0.150
   148.975  1189.470     0.150
   148.975  1189.229     0.150
     2.349    67.020     0.150
     1.389    25.492     0.150
     1.389    42.703     0.150
     2.351    41.422     0.150
     2.351    71.781     0.150
     4.737   128.234     0.150
     4.871    75.766     0.150
     5.450   146.164     0.150
     5.910    93.430     0.150
     5.910   161.430     0.150
     6.131   153.000     0.150
     6.477   167.500     0.150
     6.869   102.742     0.150
     7.450   110.906     0.150
     8.155   208.227     0.150
     8.318   124.031     0.150
     8.403   213.953     0.150
     8.411   123.930     0.150
     8.411   217.109     0.150
     8.411   123.273     0.150
     8.474   126.055     0.150
     8.474   220.648     0.150
     8.474   125.391     0.150
     8.474   125.562     0.150
     8.474   220.445     0.150
     8.474   125.922     0.150
     8.514   213.836     0.150
     8.621   127.375     0.150
     8.879   131.359     0.150
     8.975   131.695     0.150
     9.003   132.180     0.150
     9.063   133.633     0.150
     9.063   134.594     0.150
     9.849   142.742     0.150
    10.996   158.352     0.150
    12.362   306.930     0.150
    12.786   180.336     0.150
    13.605   190.875     0.150
    13.605   340.461     0.150
    13.624   190.430     0.150
    14.187   198.336     0.150
    14.218   198.531     0.150
    14.420   200.836     0.150
    14.433   200.734     0.150
    14.606   203.430     0.150
    14.797   209.109     0.150
    14.923   210.352     0.150
    14.923   210.500     0.150
    14.923   213.125     0.150
    15.884   223.461     0.150
    15.985   228.133     0.150
    15.985   403.430     0.150
    16.285   225.531     0.150
    16.595   231.992     0.150
    16.595   411.781     0.150
    16.595   232.156     0.150
    16.919   234.039     0.150
    16.919   233.578     0.150
    17.027   234.281     0.150
    18.271   253.961     0.150
    18.271   450.633     0.150
    18.271   252.492     0.150
    18.271   448.344     0.150
    18.340   255.406     0.150
    21.009   283.641     0.150
    21.669   289.961     0.150
    21.669   290.133     0.150
    23.287   309.508     0.150
    23.292   308.086     0.150
    23.607   312.531     0.150
    29.816   367.328     0.150
    29.832   368.133     0.150
    33.934   403.680     0.150
    36.842   427.133     0.150
    36.842   568.758     0.150
    38.876   444.805     0.150
    42.742   477.141     0.150
    43.548   484.734     0.150
    44.174   590.133     0.150
    44.367   489.898     0.150
    45.705   500.234     0.150
    58.116   594.359     0.150
    81.232   735.711     0.150
    83.069   745.008     0.150
    83.409   747.586     0.150
     1.406    25.206     0.150
     1.406    42.885     0.150
     2.324    39.846     0.150
     2.324    40.756     0.150
     2.324    69.616     0.150
     3.443   100.296     0.150
     3.971   109.076     0.150
     4.043    63.186     0.150
     4.043   111.436     0.150
     4.710    73.376     0.150
     4.710   128.216     0.150
     4.891    78.106     0.150
     5.230    79.976     0.150
     5.230   138.996     0.150
     5.343   143.446     0.150
     5.399    82.736     0.150
     5.915    92.446     0.150
     5.915   161.446     0.150
     6.448    95.546     0.150
     6.448   168.236     0.150
     6.812   102.226     0.150
     6.887   102.946     0.150
     7.195   107.526     0.150
     7.460   111.766     0.150
     7.582   194.486     0.150
     8.118   202.806     0.150
     8.336   123.336     0.150
     8.487   123.786     0.150
     8.487   215.686     0.150
     8.435   123.291     0.150
     8.435   213.625     0.150
     8.435   123.646     0.150
     8.490   124.476     0.150
     8.490   124.915     0.150
     8.490   217.565     0.150
     8.490   125.486     0.150
     8.490   125.346     0.150
     8.490   125.062     0.150
     8.490   219.991     0.150
     8.636   127.916     0.150
     8.895   130.836     0.150
     8.983   130.586     0.150
     8.983   132.186     0.150
     9.013   132.246     0.150
     9.013   130.266     0.150
     9.013   133.246     0.150
     9.077   133.796     0.150
     9.079   133.616     0.150
     9.349   135.596     0.150
     9.512   136.056     0.150
     9.512   238.396     0.150
     9.590   238.476     0.150
     9.747   141.306     0.150
     9.857   143.546     0.150
     9.857   142.166     0.150
    11.003   157.996     0.150
    11.003   159.221     0.150
    11.003   283.859     0.150
    12.334   173.546     0.150
    12.334   305.346     0.150
    12.759   179.046     0.150
    13.597   189.946     0.150
    13.597   334.646     0.150
    13.627   191.562     0.150
    13.627   343.674     0.150
    14.393   200.046     0.150
    14.393   353.046     0.150
    14.579   202.146     0.150
    14.807   208.156     0.150
    14.807   212.911     0.150
    14.944   207.946     0.150
    14.932   212.646     0.150
    14.932   212.446     0.150
    14.932   213.814     0.150
    14.932   211.546     0.150
    14.932   210.556     0.150
    14.932   213.646     0.150
    15.265   211.936     0.150
    15.265   211.476     0.150
    15.631   215.646     0.150
    15.986   228.746     0.150
    16.259   224.846     0.150
    16.624   231.021     0.150
    16.624   411.746     0.150
    16.624   230.616     0.150
    16.936   236.049     0.150
    16.936   237.869     0.150
    17.044   237.836     0.150
    17.044   239.746     0.150
    18.300   253.121     0.150
    18.300   453.146     0.150
    18.300   450.987     0.150
    18.363   253.521     0.150
    18.363   460.616     0.150
    18.385   254.346     0.150
    19.399   265.646     0.150
    20.380   275.296     0.150
    20.380   276.046     0.150
    20.699   282.146     0.150
    21.037   284.486     0.150
    21.334   288.616     0.150
    21.334   287.290     0.150
    21.334   287.846     0.150
    21.683   289.346     0.150
    22.247   297.076     0.150
    22.391   300.346     0.150
    22.768   301.946     0.150
    23.330   305.996     0.150
    23.315   308.421     0.150
    23.315   306.746     0.150
    23.315   308.046     0.150
    23.320   307.206     0.150
    23.320   307.646     0.150
    23.320   308.746     0.150
    23.320   335.346     0.150
    23.320   559.546     0.150
    23.320   599.246     0.150
    23.516   311.296     0.150
    23.516   308.616     0.150
    23.597   312.246     0.150
    24.622   320.276     0.150
    24.622   319.866     0.150
    25.525   330.056     0.150
    27.817   349.546     0.150
    28.163   349.476     0.150
    29.606   364.896     0.150
    29.587   364.406     0.150
    29.587   365.385     0.150
    29.594   365.146     0.150
    29.712   367.076     0.150
    29.805   366.946     0.150
    29.775   367.486     0.150
    30.025   367.546     0.150
    30.025   369.546     0.150
    31.222   378.646     0.150
    32.124   389.246     0.150
    32.580   391.706     0.150
    33.050   394.856     0.150
    33.931   401.946     0.150
    33.960   402.346     0.150
    33.964   402.471     0.150
    33.964   402.946     0.150
    33.964   402.926     0.150
    33.964   402.746     0.150
    33.971   402.346     0.150
    34.066   403.246     0.150
    34.093   403.446     0.150
    35.528   417.486     0.150
    35.709   416.666     0.150
    35.709    13.020     0.150
    35.709   497.416     0.150
    35.709   750.186     0.150
    35.709   773.366     0.150
    35.709   898.566     0.150
    35.973   419.421     0.150
    35.973   420.135     0.150
    35.973   420.546     0.150
    36.138   422.016     0.150
    36.151   422.536     0.150
    36.851   426.846     0.150
    37.058   430.646     0.150
    37.319   431.266     0.150
    37.954   438.086     0.150
    38.061   439.366     0.150
    38.118   438.046     0.150
    38.118   438.186     0.150
    38.557   442.546     0.150
    38.843   445.536     0.150
    38.906   444.721     0.150
    38.906   443.956     0.150
    39.097   446.576     0.150
    39.097   446.156     0.150
    39.261   446.946     0.150
    39.507   451.635     0.150
    39.872   449.126     0.150
    40.645   459.156     0.150
    40.847   461.416     0.150
    41.957   471.426     0.150
    41.968   470.216     0.150
    42.115   474.146     0.150
    42.438   472.606     0.150
    42.776   476.696     0.150
    42.770   476.856     0.150
    42.770   476.821     0.150
    42.770   476.526     0.150
    43.222   480.206     0.150
    43.423   483.496     0.150
    43.423   481.526     0.150
    43.485   483.276     0.150
    43.842   486.096     0.150
    43.842   486.366     0.150
    43.868   485.766     0.150
    44.041   487.536     0.150
    44.091   488.376     0.150
    44.117   488.626     0.150
    44.118   488.006     0.150
    44.366   489.596     0.150
    44.397   489.546     0.150
    44.545   491.846     0.150
    44.572   491.526     0.150
    44.710   492.416     0.150
    44.785   492.926     0.150
    44.903   493.976     0.150
    45.010   495.196     0.150
    45.271   496.896     0.150
    45.345   497.436     0.150
    45.533   498.056     0.150
    45.528   498.616     0.150
    45.538   498.096     0.150
    45.610   499.326     0.150
    45.679   500.596     0.150
    45.735   499.446     0.150
    45.735   499.746     0.150
    45.735   499.671     0.150
    45.832   500.635     0.150
    45.925   502.566     0.150
    46.361   506.296     0.150
    46.881   510.096     0.150
    47.156   511.286     0.150
    47.233   513.326     0.150
    47.274   512.846     0.150
    47.301   512.096     0.150
    47.440   513.046     0.150
    47.440    13.900     0.150
    48.424   521.686     0.150
    49.305   528.436     0.150
    49.237   528.066     0.150
    49.237   527.583     0.150
    49.237   527.716     0.150
    49.441   529.871     0.150
    49.441   529.466     0.150
    50.356   536.346     0.150
    50.524   537.946     0.150
    52.765   553.326     0.150
    53.408   559.536     0.150
    53.474   557.971     0.150
    53.844   560.259     0.150
    54.705   568.876     0.150
    56.436   579.966     0.150
    56.436   580.446     0.150
    58.106   591.646     0.150
    58.144   593.397     0.150
    58.144   592.936     0.150
    58.469   595.546     0.150
    58.469   594.146     0.150
    61.058   612.986     0.150
    62.734   625.606     0.150
    64.034   632.846     0.150
    64.034   633.126     0.150
    70.516   672.846     0.150
    73.976   694.821     0.150
    73.976   694.926     0.150
    74.396   697.696     0.150
    74.396   696.646     0.150
    74.333   695.556     0.150
    74.778   698.496     0.150
    75.772   703.236     0.150
    76.210   706.166     0.150
    76.301   706.446     0.150
    76.493   707.936     0.150
    76.606   707.796     0.150
    76.606   708.126     0.150
    76.754   709.316     0.150
    77.074   711.186     0.150
    77.740   715.396     0.150
    77.927   716.126     0.150
    77.950   715.816     0.150
    78.499   720.135     0.150
    81.204   734.946     0.150
    81.204   734.466     0.150
    83.092   743.916     0.150
    83.380   746.346     0.150
     2.324    65.214     0.150
     1.318    23.938     0.150
     1.391    24.789     0.150
     1.391    25.207     0.150
     1.391    42.398     0.150
     2.341    40.809     0.150
     2.341    41.137     0.150
     3.460    99.246     0.150
     3.988   110.828     0.150
     4.726    73.777     0.150
     4.726   131.496     0.150
     4.887    78.027     0.150
     5.247   141.719     0.150
     5.434    82.258     0.150
     5.434   147.438     0.150
     5.920    93.109     0.150
     5.920   160.508     0.150
     6.436    95.617     0.150
     6.436   168.316     0.150
     6.465    95.457     0.150
     6.465   169.188     0.150
     6.885   102.906     0.150
     7.746   115.879     0.150
     8.334   123.520     0.150
     8.428   123.430     0.150
     8.428   218.441     0.150
     8.428   123.098     0.150
     8.428   123.609     0.150
     8.428   223.906     0.150
     8.489   125.398     0.150
     8.489   124.227     0.150
     8.489   214.352     0.150
     8.489   124.727     0.150
     8.489   124.957     0.150
     8.489   222.590     0.150
     8.489   125.520     0.150
     8.635   128.656     0.150
     8.817   129.008     0.150
     8.894   130.797     0.150
     8.987   133.109     0.150
     8.987   131.668     0.150
     9.015   131.906     0.150
     9.015   131.609     0.150
     9.078   133.430     0.150
     9.077   133.836     0.150
     9.861   143.906     0.150
    11.007   158.707     0.150
    12.351   173.609     0.150
    12.351   305.207     0.150
    12.776   179.309     0.150
    13.614   189.906     0.150
    14.176   197.207     0.150
    14.208   198.559     0.150
    14.410   200.809     0.150
    14.809   208.289     0.150
    14.935   210.309     0.150
    14.935   210.207     0.150
    14.961   207.406     0.150
    15.282   212.836     0.150
    15.648   215.707     0.150
    15.994   228.406     0.150
    16.611   231.297     0.150
    16.611   230.855     0.150
    16.611   408.957     0.150
    16.611   231.258     0.150
    16.934   234.637     0.150
    17.042   239.418     0.150
    17.042   238.086     0.150
    17.042   239.109     0.150
    18.287   252.656     0.150
    18.287   448.258     0.150
    18.287   253.121     0.150
    18.287   453.484     0.150
    18.357   252.906     0.150
    18.379   253.707     0.150
    20.397   275.309     0.150
    21.020   284.957     0.150
    21.317   286.727     0.150
    21.317   289.367     0.150
    21.683   289.832     0.150
    21.683   289.129     0.150
    21.683   289.707     0.150
    23.206   306.406     0.150
    23.299   306.934     0.150
    23.299   307.508     0.150
    23.310   306.848     0.150
    23.310   307.309     0.150
    23.310   334.508     0.150
    23.310   556.309     0.150
    23.499   310.809     0.150
    23.499   562.008     0.150
    23.610   311.609     0.150
    24.210   315.609     0.150
    24.327   313.586     0.150
    24.609   318.020     0.150
    26.928   342.316     0.150
    29.595   364.988     0.150
    29.825   366.859     0.150
    29.822   366.074     0.150
    30.034   368.406     0.150
    30.034   369.359     0.150
    31.207   377.508     0.150
    31.207   438.309     0.150
    33.915   401.207     0.150
    33.944   401.309     0.150
    33.948   402.656     0.150
    33.948   402.008     0.150
    33.948   401.109     0.150
    33.948   402.578     0.150
    34.009   401.809     0.150
    34.031   402.309     0.150
    34.077   402.309     0.150
    34.725   408.109     0.150
    34.978   413.688     0.150
    35.511   418.816     0.150
    35.693   416.648     0.150
    35.693    13.090     0.150
    35.693   497.688     0.150
    35.693   750.680     0.150
    35.693   773.328     0.150
    35.693   897.387     0.150
    35.969   419.809     0.150
    35.969   418.688     0.150
    35.969   419.508     0.150
    36.122   422.309     0.150
    36.135   422.430     0.150
    36.390   423.688     0.150
    36.432   425.406     0.150
    36.854   426.434     0.150
    37.497   432.488     0.150
    37.497   431.707     0.150
    37.652   436.059     0.150
    37.952   438.168     0.150
    38.102   438.246     0.150
    38.171   440.309     0.150
    38.198   438.586     0.150
    38.536   443.277     0.150
    38.536   443.648     0.150
    38.827   445.277     0.150
    38.892   444.383     0.150
    39.028   445.789     0.150
    39.085   444.648     0.150
    39.490   451.648     0.150
    39.502   449.270     0.150
    39.553   450.336     0.150
    39.721   453.109     0.150
    40.706   458.996     0.150
    40.991   462.836     0.150
    41.103   464.309     0.150
    41.294   465.957     0.150
    41.328   466.277     0.150
    41.379   464.559     0.150
    41.789   469.809     0.150
    41.911   470.988     0.150
    41.956   470.117     0.150
    42.044   472.086     0.150
    42.087   472.406     0.150
    42.112   472.449     0.150
    42.426   473.508     0.150
    42.758   477.098     0.150
    42.758   476.383     0.150
    42.758   476.199     0.150
    43.210   479.969     0.150
    43.406   483.188     0.150
    43.406   480.738     0.150
    43.601   483.887     0.150
    43.826   486.207     0.150
    43.826   485.859     0.150
    43.826   483.949     0.150
    44.011   485.707     0.150
    44.101   488.496     0.150
    44.354   490.129     0.150
    44.383   489.008     0.150
    44.698   493.039     0.150
    44.752   494.477     0.150
    44.886   494.496     0.150
    44.886   493.539     0.150
    45.119   496.180     0.150
    45.190   497.719     0.150
    45.312   495.977     0.150
    45.261   496.930     0.150
    45.263   497.180     0.150
    45.332   496.738     0.150
    45.515   498.539     0.150
    45.523   497.969     0.150
    45.523   497.707     0.150
    45.538   499.270     0.150
    45.597   498.828     0.150
    45.670   499.270     0.150
    45.720   498.906     0.150
    45.720   499.258     0.150
    45.692   499.535     0.150
    45.911   501.637     0.150
    45.912   502.156     0.150
    45.912   501.289     0.150
    46.317   505.719     0.150
    46.344   507.219     0.150
    46.344   505.039     0.150
    46.519   507.168     0.150
    46.861   509.367     0.150
    46.951   509.727     0.150
    47.284   512.656     0.150
    47.561   515.289     0.150
    47.555   513.816     0.150
    47.555   513.309     0.150
    47.618   515.246     0.150
    48.214   520.707     0.150
    48.407   521.039     0.150
    48.673   525.238     0.150
    48.986   526.918     0.150
    49.073   525.219     0.150
    49.082   527.629     0.150
    49.200   528.879     0.150
    49.227   527.746     0.150
    49.227   527.582     0.150
    49.227   526.816     0.150
    49.424   529.684     0.150
    50.086   532.137     0.150
    53.392   559.449     0.150
    53.459   558.531     0.150
    54.289   566.746     0.150
    56.072   577.184     0.150
    56.072   576.809     0.150
    56.426   580.219     0.150
    57.390   588.656     0.150
    58.127   593.457     0.150
    58.127   591.879     0.150
    58.452   595.738     0.150
    59.117   600.180     0.150
    60.356   608.207     0.150
    60.428   610.199     0.150
    60.356   607.520     0.150
    61.041   613.828     0.150
    61.476   616.969     0.150
    64.027   633.875     0.150
    64.027   634.438     0.150
    65.800   643.316     0.150
    67.909   659.531     0.150
    70.758   674.348     0.150
    74.087   693.879     0.150
    74.087   694.906     0.150
    74.381   696.168     0.150
    74.381   695.508     0.150
    74.776   698.207     0.150
    75.089   699.648     0.150
    75.750   704.227     0.150
    76.200   706.207     0.150
    76.259   706.836     0.150
    76.421   707.879     0.150
    76.604   707.914     0.150
    76.604   707.758     0.150
    76.707   709.496     0.150
    76.742   708.668     0.150
    77.781   715.258     0.150
    78.758   720.668     0.150
    81.220   734.258     0.150
    81.220   733.566     0.150
    81.220   735.207     0.150
    83.086   743.656     0.150
    83.086   743.430     0.150
    83.101   744.039     0.150
    83.397   746.508     0.150
    83.397   746.969     0.150
    83.765   747.578     0.150
    90.751   780.957     0.150
    90.751   782.707     0.150
   148.947  1187.684     0.150
     2.341    37.422     0.150
     1.193    21.812     0.150
     1.267    22.844     0.150
     1.267    22.742     0.150
     1.267    38.973     0.150
     2.410    40.121     0.150
     2.410    41.383     0.150
     3.565   105.812     0.150
     4.047   113.934     0.150
     4.788   134.371     0.150
     5.011    77.684     0.150
     5.311   145.602     0.150
     5.407   143.164     0.150
     5.500    85.504     0.150
     5.500    83.992     0.150
     5.976    90.121     0.150
     6.174   163.523     0.150
     6.076    94.023     0.150
     6.076   164.023     0.150
     6.515   172.301     0.150
     7.015   104.223     0.150
     7.310   108.152     0.150
     7.601   197.852     0.150
     8.047   125.145     0.150
     8.047   206.871     0.150
     7.851   116.723     0.150
     7.900   117.461     0.150
     8.218   127.562     0.150
     8.218   209.961     0.150
     8.393   213.883     0.150
     8.340   122.473     0.150
     8.565   221.164     0.150
     8.467   124.863     0.150
     8.477   120.422     0.150
     8.783   222.051     0.150
     8.626   126.934     0.150
     8.626   127.141     0.150
     8.626   219.168     0.150
     8.626   126.613     0.150
     8.626   222.102     0.150
     8.626   126.832     0.150
     8.776   129.461     0.150
     8.963   132.023     0.150
     9.032   132.273     0.150
     9.141   135.543     0.150
     9.220   134.941     0.150
     9.214   134.871     0.150
     9.581   244.191     0.150
     9.694   140.324     0.150
     9.812   141.824     0.150
     9.901   144.922     0.150
     9.958   143.922     0.150
    10.014   148.422     0.150
    10.312   256.523     0.150
    10.450   150.422     0.150
    10.610   151.496     0.150
    10.610   150.922     0.150
    10.804   155.422     0.150
    10.801   155.324     0.150
    10.895   156.523     0.150
    11.023   161.324     0.150
    11.161   159.621     0.150
    11.161   158.586     0.150
    11.161   285.113     0.150
    11.385   285.512     0.150
    12.406   306.023     0.150
    12.768   315.051     0.150
    13.400   332.523     0.150
    13.678   189.922     0.150
    14.239   198.023     0.150
    14.239   349.422     0.150
    14.473   354.824     0.150
    14.486   200.422     0.150
    14.665   202.824     0.150
    14.961   209.684     0.150
    15.087   214.012     0.150
    15.087   213.125     0.150
    15.087   216.223     0.150
    15.087   211.453     0.150
    15.355   212.074     0.150
    15.489   219.121     0.150
    16.152   228.723     0.150
    16.348   224.621     0.150
    17.069   236.570     0.150
    17.069   238.320     0.150
    17.177   238.281     0.150
    17.177   240.363     0.150
    17.177   238.000     0.150
    17.177   240.223     0.150
    18.502   253.852     0.150
    18.502   459.844     0.150
    18.328   252.922     0.150
    18.328   251.773     0.150
    18.328   454.656     0.150
    18.460   254.598     0.150
    18.481   254.922     0.150
    19.555   267.324     0.150
    19.581   268.723     0.150
    19.581   490.023     0.150
    19.821   270.723     0.150
    19.808   267.223     0.150
    19.808   486.723     0.150
    20.125   275.121     0.150
    20.125   502.422     0.150
    20.472   275.121     0.150
    20.565   279.824     0.150
    20.565   510.922     0.150
    21.247   288.184     0.150
    21.247   284.418     0.150
    21.247   285.863     0.150
    21.247   283.621     0.150
    21.825   289.898     0.150
    21.903   294.262     0.150
    22.317   299.812     0.150
    22.322   299.023     0.150
    22.944   305.961     0.150
    23.251   305.699     0.150
    23.251   306.824     0.150
    23.284   307.223     0.150
    23.278   306.121     0.150
    23.373   307.223     0.150
    23.373   306.621     0.150
    23.423   308.523     0.150
    23.452   309.734     0.150
    23.452   306.801     0.150
    23.452   560.523     0.150
    23.757   313.023     0.150
    24.239   314.012     0.150
    24.225   315.324     0.150
    25.479   328.824     0.150
    25.479   590.824     0.150
    25.479   655.824     0.150
    27.500   346.523     0.150
    27.741   348.223     0.150
    27.939   349.023     0.150
    29.753   365.797     0.150
    29.885   365.473     0.150
    29.885   365.613     0.150
    29.751   366.121     0.150
    29.751   366.273     0.150
    29.751   365.223     0.150
    30.978    13.000     0.150
    30.978   435.922     0.150
    31.215   377.824     0.150
    31.215   685.223     0.150
    31.215   708.324     0.150
    31.215   788.223     0.150
    31.215   377.422     0.150
    31.215   376.723     0.150
    33.893   400.922     0.150
    33.922   401.023     0.150
    33.927   401.348     0.150
    33.927   400.992     0.150
    33.927   400.121     0.150
    33.927   401.422     0.150
    33.927   400.762     0.150
    33.933   400.621     0.150
    33.988   401.023     0.150
    34.010   400.824     0.150
    34.028   401.023     0.150
    34.056   400.824     0.150
    34.700   407.723     0.150
    35.464   417.551     0.150
    36.097   419.023     0.150
    36.092   420.324     0.150
    36.092   419.961     0.150
    36.384   424.133     0.150
    36.386   423.051     0.150
    37.509   430.723     0.150
    37.509   432.023     0.150
    37.749   436.281     0.150
    38.213   436.531     0.150
    38.844   442.723     0.150
    38.916   443.293     0.150
    38.916   443.773     0.150
    39.302   446.121     0.150
    39.302   536.824     0.150
    39.302   574.422     0.150
    40.564   459.262     0.150
    40.947   461.531     0.150
    41.135   461.441     0.150
    41.264   464.312     0.150
    41.880   470.332     0.150
    41.880   469.168     0.150
    42.247   471.211     0.150
    42.655   475.328     0.150
    42.758   475.031     0.150
    42.812   475.797     0.150
    42.812   475.273     0.150
    43.030   478.496     0.150
    43.290   481.723     0.150
    43.260   478.973     0.150
    43.317   481.375     0.150
    43.339   481.793     0.150
    43.376   481.633     0.150
    43.472   482.141     0.150
    43.793   484.422     0.150
    43.793   587.648     0.150
    43.793   483.133     0.150
    43.851   484.523     0.150
    43.905   485.305     0.150
    43.911   484.734     0.150
    44.020   486.031     0.150
    44.164   487.223     0.150
    44.395   488.297     0.150
    44.559   489.863     0.150
    44.575   490.793     0.150
    44.751   490.871     0.150
    44.742   490.402     0.150
    44.844   491.922     0.150
    45.347   494.922     0.150
    45.295   495.695     0.150
    45.329   496.062     0.150
    45.366   498.273     0.150
    45.366     9.172     0.150
    45.372   496.414     0.150
    45.537   496.781     0.150
    45.557   497.434     0.150
    45.590   498.168     0.150
    45.574   497.914     0.150
    45.647   498.480     0.150
    45.685   498.531     0.150
    45.735   498.723     0.150
    45.735   498.223     0.150
    45.735   498.523     0.150
    45.840   501.133     0.150
    45.840   500.723     0.150
    45.862   500.426     0.150
    45.937   500.988     0.150
    46.481   505.480     0.150
    46.545   506.102     0.150
    48.621   523.164     0.150
    48.645   524.281     0.150
    49.348   528.848     0.150
    49.348   526.172     0.150
    49.302   526.883     0.150
    52.756   552.324     0.150
    53.023   554.645     0.150
    53.453   556.996     0.150
    54.006   562.949     0.150
    54.006   562.672     0.150
    54.634   566.324     0.150
    56.108   576.324     0.150
    56.493   579.223     0.150
    58.073   591.773     0.150
    58.073   590.543     0.150
    59.736   603.254     0.150
    60.179   606.422     0.150
    60.239   607.801     0.150
    60.315   607.723     0.150
    60.378   608.434     0.150
    60.510   608.633     0.150
    60.539   609.293     0.150
    60.632   609.184     0.150
    60.988   611.941     0.150
    61.118   613.645     0.150
    61.186   613.793     0.150
    61.262   612.395     0.150
    61.669   617.164     0.150
    61.914   618.863     0.150
    75.871   703.062     0.150
    76.736   708.164     0.150
    76.736   707.824     0.150
    76.736   708.012     0.150
    77.843   714.281     0.150
    80.884   730.824     0.150
    81.268   732.996     0.150
    81.268   732.504     0.150
    83.195   743.223     0.150
    83.195   742.844     0.150
    83.436   745.023     0.150
    83.436   744.324     0.150
     5.815    87.227     0.150
     5.815    86.746     0.150
     6.205    94.376     0.150
     6.346    93.286     0.150
     8.055   117.736     0.150
     8.853   227.620     0.150
     8.853   126.267     0.150
     8.864   128.477     0.150
     8.864   128.286     0.150
     8.864   223.170     0.150
     8.864   128.174     0.150
     8.864   226.265     0.150
     9.166   131.307     0.150
     9.335   131.926     0.150
    10.916   151.227     0.150
    11.309   160.466     0.150
    13.962   191.807     0.150
    15.130   215.736     0.150
    15.130   210.536     0.150
    15.253   212.826     0.150
    15.253   214.517     0.150
    17.028   233.201     0.150
    17.028   425.466     0.150
    17.316   236.801     0.150
    17.423   242.776     0.150
    17.423   242.546     0.150
    17.423   240.876     0.150
    18.701   254.876     0.150
    18.701   456.714     0.150
    18.781   256.227     0.150
    18.803   256.776     0.150
    18.803   256.346     0.150
    19.694   266.576     0.150
    19.709   267.076     0.150
    20.249   272.267     0.150
    21.139   283.406     0.150
    21.297   283.826     0.150
    21.555   288.076     0.150
    21.555   288.856     0.150
    21.555   287.267     0.150
    22.042   290.656     0.150
    22.042   290.676     0.150
    23.039   302.176     0.150
    23.588   306.676     0.150
    23.685   311.076     0.150
    23.790   307.876     0.150
    23.790   308.566     0.150
    28.315   350.966     0.150
    29.355   358.176     0.150
    29.355   359.977     0.150
    29.359   359.946     0.150
    29.570   359.926     0.150
    30.052   366.526     0.150
    33.226   393.977     0.150
    34.286   402.551     0.150
    34.286   403.076     0.150
    34.286   403.206     0.150
    34.286   403.026     0.150
    35.271   413.246     0.150
    35.801   418.286     0.150
    35.801   417.946     0.150
    36.058   418.786     0.150
    36.058    12.430     0.150
    36.058    18.620     0.150
    36.058   500.906     0.150
    36.058   778.275     0.150
    36.058   906.887     0.150
    36.372   419.477     0.150
    36.720   424.856     0.150
    37.160   425.977     0.150
    37.160   566.477     0.150
    37.784   434.227     0.150
    37.946   435.977     0.150
    38.092   436.696     0.150
    38.226   436.576     0.150
    38.263   438.276     0.150
    38.663   442.116     0.150
    38.827   442.846     0.150
    39.140   445.676     0.150
    39.292   444.486     0.150
    39.772   451.526     0.150
    39.813   452.336     0.150
    40.031   452.937     0.150
    40.128   453.086     0.150
    40.129   453.586     0.150
    40.904   459.486     0.150
    41.233   462.807     0.150
    41.287   462.525     0.150
    41.425   464.566     0.150
    41.618   465.896     0.150
    41.726   467.086     0.150
    41.731   466.916     0.150
    41.790   467.307     0.150
    41.854   467.996     0.150
    41.939   468.826     0.150
    41.985   469.176     0.150
    42.116   469.936     0.150
    42.116   468.576     0.150
    42.269   470.576     0.150
    42.415   472.736     0.150
    42.415   472.176     0.150
    42.576   474.037     0.150
    42.595   471.549     0.150
    42.616   474.156     0.150
    43.005   475.699     0.150
    43.084   477.467     0.150
    43.560   481.865     0.150
    43.560   481.275     0.150
    43.629   482.807     0.150
    43.651   482.217     0.150
    43.662   480.410     0.150
    43.743   481.775     0.150
    43.799   483.537     0.150
    43.819   483.127     0.150
    43.933   484.525     0.150
    44.136   485.855     0.150
    44.144   485.637     0.150
    44.144   485.576     0.150
    44.144   485.287     0.150
    44.212   485.775     0.150
    44.372   488.047     0.150
    44.401   487.816     0.150
    44.401   487.037     0.150
    44.427   488.246     0.150
    44.769   489.238     0.150
    44.901   492.266     0.150
    45.077   494.066     0.150
    45.186   493.846     0.150
    45.186   493.256     0.150
    45.361   496.186     0.150
    45.455   496.836     0.150
    45.456   495.766     0.150
    45.457   497.066     0.150
    45.513   497.406     0.150
    45.560   497.195     0.150
    45.570   497.316     0.150
    45.588   498.166     0.150
    45.632   498.605     0.150
    45.641   495.904     0.150
    45.652   498.775     0.150
    45.674   496.439     0.150
    45.676   497.855     0.150
    45.769   498.877     0.150
    46.110   499.275     0.150
    46.110   499.525     0.150
    46.629   505.057     0.150
    46.827   506.486     0.150
    46.887   508.066     0.150
    46.957   507.816     0.150
    47.120   509.396     0.150
    47.739   513.807     0.150
    47.867   514.686     0.150
    48.531   520.275     0.150
    48.599   519.926     0.150
    48.711   520.807     0.150
    49.644   528.826     0.150
    53.822   558.701     0.150
    53.948   561.127     0.150
    54.271   561.746     0.150
    54.755   565.346     0.150
    57.635   586.525     0.150
    72.348   680.656     0.150
    73.395   687.207     0.150
    73.441   687.236     0.150
    74.651   694.025     0.150
    75.043   697.877     0.150
    75.462   699.615     0.150
    75.929   702.502     0.150
    76.155   703.996     0.150
    76.990   706.877     0.150
    76.990   707.096     0.150
    78.073   713.406     0.150
    79.177   720.016     0.150
    80.932   730.650     0.150
    80.941   730.227     0.150
    83.091   741.926     0.150
    83.505   742.977     0.150
    83.505   742.676     0.150
    95.353   802.596     0.150
   148.854  1184.227     0.150
    79.583   722.836     0.150
    75.169   698.596     0.150
    74.369   692.605     0.150
    46.044   499.057     0.150
    37.160   426.486     0.150
     1.379    25.703     0.150
     1.379    46.398     0.150
     1.379    25.352     0.150
     4.146    67.789     0.150
     4.146    68.500     0.150
     5.341    85.211     0.150
     5.899    91.492     0.150
     5.899    92.180     0.150
     5.899   154.852     0.150
     7.673   116.719     0.150
     8.422   127.086     0.150
     8.422   125.992     0.150
     8.422   126.492     0.150
     8.422   221.969     0.150
     8.621   129.633     0.150
    10.610   154.789     0.150
    10.934   158.305     0.150
    10.934   159.188     0.150
    14.737   208.789     0.150
    14.737   208.688     0.150
    14.737   208.492     0.150
    14.849   210.586     0.150
    14.863   210.891     0.150
    14.863   210.117     0.150
    15.250   212.977     0.150
    15.319   216.289     0.150
    15.951   223.898     0.150
    15.951   226.852     0.150
    16.977   237.086     0.150
    16.977   236.586     0.150
    16.977   235.328     0.150
    16.977   236.133     0.150
    17.915   249.719     0.150
    17.915   249.828     0.150
    18.202   253.695     0.150
    18.328   253.992     0.150
    18.328   254.391     0.150
    19.329   266.688     0.150
    21.348   292.086     0.150
    21.348   290.789     0.150
    21.348   291.820     0.150
    21.348   291.641     0.150
    21.614   290.086     0.150
    21.614   290.023     0.150
    21.816   296.789     0.150
    21.912   293.992     0.150
    22.029   298.031     0.150
    22.397   302.086     0.150
    22.416   302.148     0.150
    23.033   309.039     0.150
    23.277   308.586     0.150
    23.277   308.320     0.150
    23.319   309.688     0.150
    23.505   314.070     0.150
    23.519   312.586     0.150
    23.519   312.883     0.150
    23.519   310.891     0.150
    23.519   311.648     0.150
    24.678   322.344     0.150
    24.678   322.727     0.150
    25.125   326.438     0.150
    25.125   326.602     0.150
    25.268   328.992     0.150
    25.540   332.711     0.150
    26.113   337.891     0.150
    26.236   339.586     0.150
    26.236   339.211     0.150
    26.236   340.109     0.150
    27.270   346.391     0.150
    27.380   347.688     0.150
    27.509   348.492     0.150
    27.684   351.492     0.150
    27.684   351.695     0.150
    27.684   351.797     0.150
    27.781   350.391     0.150
    27.870   352.781     0.150
    28.316   356.391     0.150
    28.538   357.117     0.150
    28.538   357.227     0.150
    28.619   358.328     0.150
    28.619   358.758     0.150
    28.811   360.789     0.150
    28.811   361.633     0.150
    28.797   361.391     0.150
    28.797   361.562     0.150
    28.797   362.297     0.150
    29.372   365.820     0.150
    29.576   366.086     0.150
    29.576   366.664     0.150
    29.576   366.422     0.150
    29.641   368.320     0.150
    29.671   369.180     0.150
    29.820   368.195     0.150
    29.820   367.922     0.150
    29.734   369.086     0.150
    29.775   370.102     0.150
    29.810   370.258     0.150
    29.959   370.789     0.150
    29.959   370.492     0.150
    30.362   375.109     0.150
    30.444   375.383     0.150
    30.503   375.828     0.150
    30.630   375.883     0.150
    30.637   376.250     0.150
    30.637   376.586     0.150
    31.120   382.242     0.150
    31.120   382.570     0.150
    31.201   380.289     0.150
    31.201   379.969     0.150
    31.201   379.789     0.150
    31.704   386.281     0.150
    31.946   389.609     0.150
    32.476   392.672     0.150
    32.476   392.195     0.150
    32.577   393.852     0.150
    32.807   395.375     0.150
    32.851   396.969     0.150
    33.300   400.773     0.150
    33.397   399.969     0.150
    33.429   402.672     0.150
    33.495   401.719     0.150
    33.579   403.859     0.150
    33.588   403.859     0.150
    33.599   404.094     0.150
    33.605   403.148     0.150
    33.605   403.883     0.150
    33.642   403.148     0.150
    33.724   405.281     0.150
    33.733   404.336     0.150
    33.748   403.781     0.150
    33.748   403.898     0.150
    33.759   404.812     0.150
    33.856   405.758     0.150
    33.956   404.391     0.150
    33.956   404.297     0.150
    33.956   405.523     0.150
    34.046   407.055     0.150
    34.051   406.945     0.150
    34.058   406.477     0.150
    34.068   406.711     0.150
    34.088   406.703     0.150
    34.101   407.898     0.150
    34.100   407.656     0.150
    34.199   407.242     0.150
    34.178   408.609     0.150
    34.204   408.609     0.150
    34.240   408.133     0.150
    34.250   408.609     0.150
    34.253   409.086     0.150
    34.310   409.320     0.150
    34.325   410.375     0.150
    34.327   410.797     0.150
    34.422   411.227     0.150
    34.457   411.695     0.150
    34.488   411.219     0.150
    34.522   411.227     0.150
    34.538   409.891     0.150
    34.566   411.938     0.150
    34.582   410.531     0.150
    34.614   412.727     0.150
    34.626   412.648     0.150
    34.704   413.836     0.150
    34.871   412.133     0.150
    34.794   413.602     0.150
    34.806   413.359     0.150
    34.954   414.547     0.150
    34.972   414.727     0.150
    34.995   417.086     0.150
    34.997   415.891     0.150
    34.997   415.734     0.150
    34.997   415.289     0.150
    34.997   415.406     0.150
    35.041   416.688     0.150
    35.050   416.688     0.150
    35.053   415.969     0.150
    35.061   416.922     0.150
    35.087   415.734     0.150
    35.087   415.039     0.150
    35.099   417.188     0.150
    35.113   416.211     0.150
    35.163   417.164     0.150
    35.184   416.492     0.150
    35.218   416.734     0.150
    35.253   417.555     0.150
    35.295   418.820     0.150
    35.295   419.039     0.150
    35.347   419.062     0.150
    35.415   419.773     0.150
    35.435   418.820     0.150
    35.455   420.227     0.150
    35.458   419.359     0.150
    35.474   418.695     0.150
    35.511   419.062     0.150
    35.508   419.539     0.150
    35.531   420.688     0.150
    35.531   421.195     0.150
    35.531   420.578     0.150
    35.590   420.250     0.150
    35.693   419.289     0.150
    35.749   422.391     0.150
    35.762   422.867     0.150
    35.909   420.891     0.150
    35.853   423.336     0.150
    35.878   423.336     0.150
    35.992   422.867     0.150
    35.935   423.812     0.150
    35.947   422.930     0.150
    36.033   425.234     0.150
    36.039   424.289     0.150
    36.153   424.602     0.150
    36.137   424.609     0.150
    36.147   425.906     0.150
    36.160   425.297     0.150
    36.160   425.062     0.150
    36.291   425.133     0.150
    36.320   426.445     0.150
    36.352   427.375     0.150
    36.452   428.328     0.150
    36.452   427.422     0.150
    36.655   427.047     0.150
    36.655   427.312     0.150
    36.657   429.680     0.150
    36.628   429.750     0.150
    36.641   430.227     0.150
    36.653   427.859     0.150
    36.677   430.227     0.150
    36.752   427.992     0.150
    36.822   431.648     0.150
    36.991   432.602     0.150
    37.054   433.789     0.150
    37.054   433.398     0.150
    37.059   434.023     0.150
    37.061   432.586     0.150
    37.061   433.078     0.150
    37.061   432.469     0.150
    37.106   434.227     0.150
    37.197   434.586     0.150
    37.197   434.266     0.150
    37.231   435.453     0.150
    37.450   436.641     0.150
    37.465   436.250     0.150
    37.489   434.188     0.150
    37.489   434.320     0.150
    37.471   436.555     0.150
    37.473   435.969     0.150
    37.526   436.875     0.150
    37.548   437.586     0.150
    37.548   437.062     0.150
    37.570   436.875     0.150
    37.653   439.023     0.150
    37.672   438.188     0.150
    37.672   439.016     0.150
    37.742   438.055     0.150
    37.760   438.289     0.150
    37.760   438.820     0.150
    37.808   438.992     0.150
    37.808   439.727     0.150
    37.808   438.883     0.150
    37.916   438.273     0.150
    37.894   439.492     0.150
    37.949   440.086     0.150
    37.949   439.797     0.150
    37.966   440.586     0.150
    37.966   440.281     0.150
    38.027   440.680     0.150
    38.028   439.930     0.150
    38.073   442.438     0.150
    38.101   440.070     0.150
    38.188   440.445     0.150
    38.214   443.523     0.150
    38.239   441.086     0.150
    38.239   440.789     0.150
    38.239   443.055     0.150
    38.373   445.086     0.150
    38.373   444.953     0.150
    38.373   444.281     0.150
    38.491   444.227     0.150
    38.447   445.664     0.150
    38.471   445.344     0.150
    38.530   444.953     0.150
    38.536   446.141     0.150
    38.556   445.266     0.150
    38.556   445.586     0.150
    38.556   445.430     0.150
    38.584   443.867     0.150
    38.596   445.898     0.150
    38.787   447.609     0.150
    38.773   448.281     0.150
    38.841   447.688     0.150
    38.841   447.352     0.150
    38.879   446.219     0.150
    38.879     7.969     0.150
    38.917   450.188     0.150
    38.917   449.469     0.150
    39.020   447.398     0.150
    39.057   448.086     0.150
    39.057   446.812     0.150
    39.057   446.938     0.150
    39.052   452.234     0.150
    39.212   450.086     0.150
    39.178   452.188     0.150
    39.178   451.602     0.150
    39.208   449.000     0.150
    39.294   451.406     0.150
    39.289   449.797     0.150
    39.339   450.281     0.150
    39.363   451.820     0.150
    39.479   451.086     0.150
    39.483   454.391     0.150
    39.483   453.742     0.150
    39.483   454.062     0.150
    39.502   454.180     0.150
    39.507   450.836     0.150
    39.780   455.359     0.150
    39.780   455.102     0.150
    39.716   452.883     0.150
    39.736   455.391     0.150
    39.736   455.188     0.150
    39.864   455.305     0.150
    39.864   455.406     0.150
    39.862   456.008     0.150
    39.883   456.461     0.150
    40.329   460.992     0.150
    40.329   460.109     0.150
    40.470   458.977     0.150
    40.471   459.898     0.150
    40.490   460.945     0.150
    40.490   461.102     0.150
    40.626   462.391     0.150
    40.626   461.820     0.150
    40.626   462.227     0.150
    40.694   460.656     0.150
    40.805   464.188     0.150
    40.919   464.688     0.150
    40.919   464.508     0.150
    41.010   464.992     0.150
    41.128   465.219     0.150
    41.116   466.492     0.150
    41.116   466.617     0.150
    41.113   466.789     0.150
    41.113   466.133     0.150
    41.225   464.461     0.150
    41.218   468.391     0.150
    41.218   468.055     0.150
    41.305   467.688     0.150
    41.305   467.992     0.150
    41.305   467.453     0.150
    41.305   467.562     0.150
    41.355   466.891     0.150
    41.344   468.688     0.150
    41.344   467.961     0.150
    41.415   468.336     0.150
    41.415   468.695     0.150
    41.477   469.227     0.150
    41.476   469.992     0.150
    41.476   469.680     0.150
    41.544   469.828     0.150
    41.606   469.781     0.150
    41.625   470.422     0.150
    41.651   469.719     0.150
    41.673   470.711     0.150
    41.751   471.992     0.150
    41.751   472.117     0.150
    41.751   471.656     0.150
    41.800   471.586     0.150
    41.904   474.086     0.150
    41.904   473.250     0.150
    41.923   473.086     0.150
    41.923   473.453     0.150
    41.923   472.594     0.150
    41.952   473.211     0.150
    41.990   473.688     0.150
    41.990   473.312     0.150
    42.056   474.289     0.150
    42.056   473.969     0.150
    42.097   474.586     0.150
    42.097   474.391     0.150
    42.167   475.391     0.150
    42.165   474.992     0.150
    42.262   475.883     0.150
    42.270   475.586     0.150
    42.268   475.789     0.150
    42.296   475.586     0.150
    42.296   475.828     0.150
    42.298   476.281     0.150
    42.398   475.047     0.150
    42.447   477.391     0.150
    42.498   480.289     0.150
    42.505   477.789     0.150
    42.647   478.992     0.150
    42.647   478.891     0.150
    42.647   478.445     0.150
    42.647   477.516     0.150
    42.647   478.930     0.150
    42.731   478.117     0.150
    42.731     5.898     0.150
    42.702   479.555     0.150
    42.713   479.586     0.150
    42.713   479.367     0.150
    42.769   478.039     0.150
    42.778   479.820     0.150
    42.778   479.562     0.150
    42.868   481.188     0.150
    43.089   482.508     0.150
    43.217   483.086     0.150
    43.217   483.711     0.150
    43.245   483.992     0.150
    43.245   483.891     0.150
    43.245  1074.992     0.150
    43.245   483.562     0.150
    43.413   485.586     0.150
    43.373   485.312     0.150
    43.385   485.188     0.150
    43.435   485.891     0.150
    43.435   485.633     0.150
    43.439   483.688     0.150
    43.435   485.477     0.150
    43.474   484.141     0.150
    43.489   485.586     0.150
    43.524   486.258     0.150
    43.524   485.477     0.150
    43.610   486.102     0.150
    43.709   486.602     0.150
    43.831   488.008     0.150
    43.839   488.039     0.150
    43.905   488.789     0.150
    43.905   488.391     0.150
    43.941   488.586     0.150
    43.941   489.758     0.150
    43.958   489.258     0.150
    43.985   487.742     0.150
    44.039   489.930     0.150
    44.047   490.375     0.150
    44.109   489.812     0.150
    44.118   490.438     0.150
    44.118   490.430     0.150
    44.144   490.938     0.150
    44.196   490.508     0.150
    44.208   491.773     0.150
    44.208   490.633     0.150
    44.381   491.102     0.150
    44.381   491.414     0.150
    44.381     8.523     0.150
    44.381     4.188     0.150
    44.642   495.055     0.150
    44.644   496.031     0.150
    44.649   495.398     0.150
    44.567   494.148     0.150
    44.672   496.195     0.150
    44.672   495.883     0.150
    44.703   495.734     0.150
    44.703   495.945     0.150
    44.629   494.734     0.150
    44.710   494.945     0.150
    44.793   496.570     0.150
    44.793   496.141     0.150
    44.809   496.055     0.150
    44.952   497.281     0.150
    44.952   496.469     0.150
    44.904   496.000     0.150
    45.064   499.125     0.150
    44.970   496.930     0.150
    45.051   498.336     0.150
    45.159   499.594     0.150
    45.159   499.812     0.150
    45.095   498.148     0.150
    45.235   500.891     0.150
    45.145   499.445     0.150
    45.145   498.711     0.150
    45.147   499.062     0.150
    45.151   498.945     0.150
    45.300   500.312     0.150
    45.230   499.570     0.150
    45.252   499.586     0.150
    45.263   499.602     0.150
    45.268   498.562     0.150
    45.263   499.297     0.150
    45.271   499.086     0.150
    45.276   500.719     0.150
    45.319   500.836     0.150
    45.338   500.961     0.150
    45.449   499.781     0.150
    45.349   500.258     0.150
    45.370   500.336     0.150
    45.382   500.414     0.150
    45.492   500.367     0.150
    45.492   500.195     0.150
    45.492   500.992     0.150
    45.407   501.633     0.150
    45.407   501.484     0.150
    45.407   501.633     0.150
    45.398   500.781     0.150
    45.440   501.586     0.150
    45.524   499.688     0.150
    45.524   499.234     0.150
    45.524   499.547     0.150
    45.499   501.727     0.150
    45.515   499.367     0.150
    45.515     4.586     0.150
    45.622   502.609     0.150
    45.621   501.992     0.150
    45.644   502.203     0.150
    45.793   503.609     0.150
    45.817   503.883     0.150
    45.846   504.391     0.150
    45.914   504.547     0.150
    45.992   505.164     0.150
    46.105   505.617     0.150
    46.105   505.266     0.150
    46.087   505.992     0.150
    46.086   506.391     0.150
    46.109   505.945     0.150
    46.166   506.977     0.150
    46.351   507.688     0.150
    46.299   507.969     0.150
    46.332   507.867     0.150
    46.373   507.289     0.150
    46.373   506.758     0.150
    46.361   507.906     0.150
    46.399   508.711     0.150
    46.438   509.250     0.150
    46.454   508.617     0.150
    46.484   509.602     0.150
    46.490   509.781     0.150
    46.534   509.039     0.150
    46.534   508.570     0.150
    46.550   509.477     0.150
    46.549   510.688     0.150
    46.651   511.188     0.150
    46.642   510.672     0.150
    46.653   510.836     0.150
    46.666   510.297     0.150
    46.746   511.742     0.150
    46.781   512.102     0.150
    46.795   511.398     0.150
    46.813   512.219     0.150
    46.813   511.977     0.150
    46.826   511.602     0.150
    46.921   512.891     0.150
    46.913   511.328     0.150
    46.948   513.133     0.150
    46.965   513.211     0.150
    47.008   512.719     0.150
    47.084   513.938     0.150
    47.118   514.406     0.150
    47.146   515.477     0.150
    47.173   514.078     0.150
    47.220   514.961     0.150
    47.346   516.188     0.150
    47.302   514.398     0.150
    47.329   516.062     0.150
    47.403   515.891     0.150
    47.404   516.547     0.150
    47.404   516.008     0.150
    47.487   515.305     0.150
    47.487   515.133     0.150
    47.423   517.469     0.150
    47.437   516.797     0.150
    47.437   515.477     0.150
    47.437   517.031     0.150
    47.479   517.422     0.150
    47.613   518.008     0.150
    47.613   517.891     0.150
    47.510   517.430     0.150
    47.512   518.977     0.150
    47.512   518.820     0.150
    47.565   519.383     0.150
    47.577   517.008     0.150
    47.691   518.422     0.150
    47.715   518.828     0.150
    47.760   520.898     0.150
    47.760   518.828     0.150
    47.775   519.156     0.150
    47.797   520.031     0.150
    47.830   520.586     0.150
    47.845   519.719     0.150
    47.908   520.719     0.150
    47.915   519.688     0.150
    47.955   520.211     0.150
    47.987   521.961     0.150
    47.987   520.961     0.150
    48.000   521.086     0.150
    48.002   522.359     0.150
    48.002   522.031     0.150
    48.019   520.859     0.150
    48.227   522.969     0.150
    48.227   522.234     0.150
    48.227   522.672     0.150
    48.284   524.297     0.150
    48.303   522.992     0.150
    48.303   523.211     0.150
    48.655   526.867     0.150
    48.655   525.852     0.150
    48.666   526.570     0.150
    48.686   526.039     0.150
    48.684   527.328     0.150
    48.684   526.656     0.150
    48.690   526.102     0.150
    48.817   526.727     0.150
    48.850   527.570     0.150
    49.006   528.469     0.150
    49.098   529.211     0.150
    49.189     4.375     0.150
    49.210   530.531     0.150
    49.308   530.141     0.150
    49.442   531.422     0.150
    49.442   533.039     0.150
    49.446   532.172     0.150
    49.478   532.102     0.150
    49.549   533.188     0.150
    49.671   533.883     0.150
    49.674   533.477     0.150
    50.117   537.445     0.150
    50.117   537.258     0.150
    50.308   537.656     0.150
    50.308   537.992     0.150
    50.308   537.430     0.150
    50.370   539.688     0.150
    50.525   540.336     0.150
    50.525   540.180     0.150
    50.633   542.211     0.150
    50.633   542.078     0.150
    51.386   547.555     0.150
    51.386   547.742     0.150
    51.345   547.492     0.150
    51.631   548.141     0.150
    51.682   548.492     0.150
    51.846   550.805     0.150
    52.073   551.766     0.150
    52.270   555.086     0.150
    52.177   552.383     0.150
    52.366   553.508     0.150
    52.367   554.695     0.150
    52.607   555.930     0.150
    52.839   556.727     0.150
    52.864   556.578     0.150
    53.284   560.664     0.150
    53.284   560.547     0.150
    53.339   560.516     0.150
    53.339   561.789     0.150
    53.309   560.812     0.150
    53.451   561.797     0.150
    53.451   561.492     0.150
    53.373   561.633     0.150
    53.406   561.633     0.150
    53.459   560.711     0.150
    53.459   561.836     0.150
    53.459     5.750     0.150
    53.459     7.750     0.150
    53.459     8.453     0.150
    53.487   561.039     0.150
    53.487   561.148     0.150
    53.781   563.062     0.150
    53.781   563.227     0.150
    54.008   565.891     0.150
    54.008   565.602     0.150
    54.008   565.328     0.150
    54.548   569.703     0.150
    54.548   569.430     0.150
    54.459   568.711     0.150
    54.492   570.781     0.150
    54.651   570.031     0.150
    54.561   570.562     0.150
    54.728   570.891     0.150
    55.027   572.977     0.150
    55.394   577.266     0.150
    55.526   576.219     0.150
    55.730   578.891     0.150
    55.879   578.430     0.150
    55.915   577.461     0.150
    56.040   581.773     0.150
    56.040   580.305     0.150
    56.040   582.008     0.150
    55.999   579.688     0.150
    55.954   579.836     0.150
    56.242   583.117     0.150
    56.176   582.039     0.150
    56.392   582.023     0.150
    56.590   584.406     0.150
    56.801   586.508     0.150
    57.268   590.992     0.150
    57.268   591.211     0.150
    57.389   591.500     0.150
    57.389   591.367     0.150
    57.427   590.297     0.150
    57.554   591.352     0.150
    57.554   590.930     0.150
    57.942   594.289     0.150
    57.942   595.648     0.150
    58.352   597.273     0.150
    58.476   597.977     0.150
    59.142   601.852     0.150
    59.370   601.492     0.150
    59.370   601.602     0.150
    59.320   604.789     0.150
    59.562   604.742     0.150
    60.062   610.531     0.150
    60.196   608.547     0.150
    60.196   607.891     0.150
    60.286   609.586     0.150
    60.448   612.492     0.150
    60.506   612.633     0.150
    60.686   612.688     0.150
    60.686   613.398     0.150
    60.599   610.562     0.150
    60.892   613.422     0.150
    60.789   612.562     0.150
    61.064   615.734     0.150
    61.131   616.781     0.150
    61.499   618.688     0.150
    61.731   620.211     0.150
    61.944   619.914     0.150
    61.944   618.719     0.150
    61.944   619.586     0.150
    62.453   621.977     0.150
    62.453  1127.312     0.150
    62.034   618.164     0.150
    62.034   619.008     0.150
    62.068   623.133     0.150
    62.068  1129.031     0.150
    62.530   625.648     0.150
    62.530   625.852     0.150
    62.451   625.586     0.150
    62.491   625.750     0.150
    62.650   627.156     0.150
    62.692   626.828     0.150
    63.203   629.977     0.150
    63.515   633.266     0.150
    63.515   633.641     0.150
    64.102   636.164     0.150
    64.102   635.906     0.150
    64.109   636.320     0.150
    64.265   637.609     0.150
    64.971   638.898     0.150
    67.109   654.312     0.150
    67.181   655.109     0.150
    67.181   654.758     0.150
    67.625   658.688     0.150
    68.630   664.289     0.150
    68.630   664.477     0.150
    69.356   669.586     0.150
    69.356   668.852     0.150
    69.356   669.352     0.150
    70.395   675.531     0.150
    70.719   679.328     0.150
    71.955   685.016     0.150
    71.955   685.617     0.150
    72.367   687.555     0.150
    72.367   688.086     0.150
    72.446   688.750     0.150
    72.690   687.984     0.150
    72.854   689.312     0.150
    73.243   693.117     0.150
    73.243   694.102     0.150
    73.736   696.586     0.150
    73.683   696.141     0.150
    73.683   695.938     0.150
    73.978   696.586     0.150
    73.978   696.891     0.150
    74.198   698.039     0.150
    68.645   663.766     0.150
    74.420   699.531     0.150
    74.420   699.328     0.150
    74.438   699.992     0.150
    74.438   699.633     0.150
    74.438   699.789     0.150
    74.671   701.672     0.150
    75.053   703.531     0.150
    75.071   702.742     0.150
    75.071   703.266     0.150
    75.165   703.641     0.150
    75.338   704.242     0.150
    75.691   705.641     0.150
    75.691   705.906     0.150
    75.982   708.516     0.150
    76.234   708.688     0.150
    76.234   708.266     0.150
    76.234   708.492     0.150
    76.275   711.188     0.150
    76.275   710.930     0.150
    76.486   709.789     0.150
    76.439   713.117     0.150
    76.711   711.086     0.150
    76.775   712.531     0.150
    78.066   718.148     0.150
    78.696   722.219     0.150
    78.756   724.297     0.150
    78.943   723.445     0.150
    79.434   729.477     0.150
    79.685   728.672     0.150
    79.665   730.438     0.150
    80.152   731.953     0.150
    80.152   732.836     0.150
    80.171   731.023     0.150
    80.171   730.922     0.150
    80.629   733.703     0.150
    80.914   734.289     0.150
    80.914   733.969     0.150
    80.914   734.078     0.150
    81.209   737.492     0.150
    81.209   736.398     0.150
    81.209   737.648     0.150
    81.303   736.945     0.150
    81.303   737.086     0.150
    81.381   737.000     0.150
    81.381   737.508     0.150
    81.435   737.250     0.150
    81.435   737.758     0.150
    81.505   737.453     0.150
    81.486   740.891     0.150
    81.598   740.359     0.150
    81.598   741.047     0.150
    82.662   743.164     0.150
    82.662   743.281     0.150
    82.964   744.797     0.150
    83.667   748.789     0.150
    83.907   751.477     0.150
    83.907   751.359     0.150
    84.289   753.320     0.150
    84.289   753.430     0.150
    84.289   752.891     0.150
    84.567   753.492     0.150
    84.567   753.977     0.150
    84.616   754.672     0.150
    84.617   754.414     0.150
    85.293   758.445     0.150
    85.293   759.062     0.150
    85.351   758.688     0.150
    85.351   757.961     0.150
    87.321   768.398     0.150
    87.321   768.570     0.150
    87.327   767.391     0.150
    87.327   767.242     0.150
    87.636   770.328     0.150
    87.636   770.586     0.150
    87.932   770.117     0.150
    90.702   784.797     0.150
    90.702   784.500     0.150
    90.731   783.164     0.150
    90.888   784.703     0.150
    90.888   785.336     0.150
    91.711   788.852     0.150
    92.416   791.859     0.150
    92.909   794.781     0.150
    93.112   794.500     0.150
    93.506   798.008     0.150
    93.871   798.789     0.150
    93.871   798.219     0.150
    93.923   801.750     0.150
    94.067   797.828     0.150
    94.311   800.680     0.150
    94.584   800.789     0.150
    95.077   804.391     0.150
    95.441   805.750     0.150
    95.599   807.469     0.150
    95.599   807.188     0.150
    95.776   807.727     0.150
    95.822   807.219     0.150
    96.423   810.414     0.150
    96.423   810.609     0.150
    97.090   813.188     0.150
    97.212   815.070     0.150
    99.659   825.117     0.150
    99.659   824.711     0.150
   100.031   826.312     0.150
   100.040   828.312     0.150
   100.040   827.859     0.150
   101.084   830.758     0.150
   101.084   830.516     0.150
   101.951   835.062     0.150
   102.179   836.742     0.150
   102.179   836.898     0.150
   102.739   839.422     0.150
   105.413   850.078     0.150
   109.121   867.844     0.150
   116.360  1751.906     0.150
   116.360  1124.242     0.150
   117.666  1126.688     0.150
   117.666  1127.250     0.150
   117.666  1746.391     0.150
   117.666  1125.820     0.150
   118.681  1743.625     0.150
   118.681  1128.234     0.150
   118.838  1742.430     0.150
   118.838  1128.477     0.150
   119.487  1740.828     0.150
   119.487   909.320     0.150
   119.487  1129.586     0.150
   120.754  1133.336     0.150
   121.038  1133.828     0.150
   122.461  1137.219     0.150
   123.825  1138.617     0.150
   124.903  1141.938     0.150
   125.160  1143.859     0.150
   126.750  1147.820     0.150
   126.898  1144.398     0.150
   127.062  1145.906     0.150
   128.042  1147.891     0.150
   130.745  1152.883     0.150
   130.769  1155.820     0.150
   142.146  1174.734     0.150
   142.902  1180.562     0.150
   142.920  1172.758     0.150
   144.561  1179.039     0.150
   146.056  1183.742     0.150
   146.943  1184.461     0.150
   147.514  1183.641     0.150
   147.816  1188.312     0.150
   148.115  1186.742     0.150
   149.864  1191.992     0.150
   151.197  1194.891     0.150
     1.379    45.766     0.150
     3.841    67.438     0.150
     4.146    68.352     0.150
     4.405    74.148     0.150
     4.827    79.438     0.150
     5.521    88.039     0.150
     6.752   102.969     0.150
     6.822   103.961     0.150
     7.133   108.633     0.150
     7.650   115.367     0.150
    14.863   210.781     0.150
    16.589   232.609     0.150
    20.293   277.500     0.150
    20.684   281.930     0.150
    20.941   284.797     0.150
    20.950   284.492     0.150
    21.107   286.656     0.150
    21.348   289.750     0.150
    21.614   290.562     0.150
    21.614   290.445     0.150
    21.700   292.258     0.150
    23.277   309.180     0.150
    24.678   321.438     0.150
    28.619   357.898     0.150
    28.811   359.188     0.150
    29.521   366.766     0.150
    29.641   365.836     0.150
    29.795   368.008     0.150
    29.795   367.711     0.150
    29.858   368.750     0.150
    29.858   368.992     0.150
    30.731   376.789     0.150
    31.201   379.547     0.150
    31.699   387.352     0.150
    32.301   390.445     0.150
    32.577   393.266     0.150
    32.807   395.109     0.150
    33.073   398.039     0.150
    33.956   403.781     0.150
    34.378   408.312     0.150
    34.538   409.492     0.150
    34.582   409.938     0.150
    34.740   412.531     0.150
    34.871   411.461     0.150
    36.153   424.047     0.150
    38.491   444.086     0.150
    39.864   455.070     0.150
    40.490   459.492     0.150
    41.225   464.133     0.150
    42.298   474.766     0.150
    42.398   474.672     0.150
    42.731   477.516     0.150
    43.176   482.039     0.150
    44.644   493.242     0.150
    44.642   493.398     0.150
    45.407   500.930     0.150
    45.524   498.977     0.150
    46.373   506.312     0.150
    47.437   515.586     0.150
    47.512   516.797     0.150
    48.002   520.438     0.150
    49.442   531.242     0.150
    49.478   531.992     0.150
    50.117   536.461     0.150
    50.308   537.328     0.150
    53.284   560.133     0.150
    53.372   560.508     0.150
    53.487   560.578     0.150
    54.008   565.148     0.150
    55.879   578.297     0.150
    57.386   587.836     0.150
    57.389   588.547     0.150
    57.554   591.133     0.150
    57.942   593.430     0.150
    58.149   594.883     0.150
    58.476   597.688     0.150
    60.062   609.562     0.150
    60.155   608.836     0.150
    60.448   611.750     0.150
    60.686   611.836     0.150
    60.789   612.781     0.150
    62.034   619.680     0.150
    62.530   624.672     0.150
    62.692   626.586     0.150
    63.203   629.312     0.150
    63.883   633.789     0.150
    64.102   634.695     0.150
    64.109   636.156     0.150
    64.971   638.562     0.150
    66.578   650.812     0.150
    69.356   668.398     0.150
    72.446   686.992     0.150
    74.438   698.836     0.150
    75.691   705.266     0.150
    76.952   712.430     0.150
    80.171   730.578     0.150
    80.914   733.789     0.150
    81.209   736.109     0.150
    81.598   740.258     0.150
    83.697   749.570     0.150
    89.957   779.891     0.150
    95.776   806.992     0.150
    97.090   812.719     0.150
    98.972   820.836     0.150
   116.081  1124.898     0.150
   117.666  1125.508     0.150
   118.030  1128.609     0.150
   119.791  1130.945     0.150
   120.323  1131.219     0.150
   122.569  1135.922     0.150
   124.515  1139.398     0.150
   125.160  1143.352     0.150
   127.062  1145.156     0.150
   131.029  1152.688     0.150
   131.577  1153.820     0.150
   143.289  1174.906     0.150
   146.484  1182.391     0.150
   146.862  1183.617     0.150
   146.943  1184.172     0.150
   147.422  1184.180     0.150
   147.735  1186.062     0.150
   148.057  1186.000     0.150
   151.197  1188.961     0.150
     4.146    64.586     0.150
     1.404    26.648     0.150
    16.940   242.422     0.150
    21.354   292.500     0.150
    30.453   376.633     0.150
    33.950   405.445     0.150
    35.053   417.312     0.150
    35.531   421.789     0.150
    37.552   438.180     0.150
    38.862   447.266     0.150
    39.495   452.133     0.150
    39.886   457.570     0.150
    41.411   469.820     0.150
    41.473   470.242     0.150
    41.541   471.039     0.150
    41.621   471.703     0.150
    41.669   472.102     0.150
    42.092   475.094     0.150
    42.708   479.344     0.150
    43.441   486.898     0.150
    44.118   490.898     0.150
    44.367   491.930     0.150
    44.367     5.727     0.150
    44.367     6.609     0.150
    44.903   497.195     0.150
    45.261   499.594     0.150
    45.501   500.320     0.150
    46.532   509.992     0.150
    49.097   530.141     0.150
    57.571   591.914     0.150
    58.478   598.922     0.150
    59.145   603.211     0.150
    61.501   619.789     0.150
    64.139   637.211     0.150
    73.280   693.891     0.150
    74.420   700.609     0.150
    75.655   706.844     0.150
    82.626   744.453     0.150
    87.330   768.461     0.150
     3.804    64.141     0.150
     4.121    67.359     0.150
     4.367    71.492     0.150
     4.792    77.812     0.150
     5.309    84.398     0.150
     5.878    91.148     0.150
     6.719   102.703     0.150
     6.785   103.562     0.150
     7.098   107.852     0.150
     7.613   115.281     0.150
     8.385   126.219     0.150
     8.346   125.523     0.150
     8.709   130.633     0.150
    16.568   233.852     0.150
    16.568   233.969     0.150
    21.046   287.609     0.150
    21.354   290.031     0.150
    21.576   291.820     0.150
    23.252   309.414     0.150
    23.519   312.953     0.150
    24.709   321.484     0.150
    36.148   424.211     0.150
    36.743   428.172     0.150
    38.862   446.320     0.150
    42.375   475.469     0.150
    42.708   478.445     0.150
    43.441   483.750     0.150
    44.118   490.023     0.150
    44.903   496.609     0.150
    45.646   501.961     0.150
    47.301   514.961     0.150
    72.956   690.430     0.150
    74.985   702.445     0.150
    75.235   704.180     0.150
    75.374   704.680     0.150
    75.394   704.602     0.150
    75.655   706.430     0.150
    76.389   710.531     0.150
    78.924   724.719     0.150
    80.876   734.562     0.150
     1.329    46.109     0.150
     4.155    69.688     0.150
     5.366    87.117     0.150
     5.903    91.422     0.150
     5.903    93.164     0.150
     6.046    95.922     0.150
     7.163   109.445     0.150
     7.720   118.359     0.150
     8.461   128.180     0.150
     8.461   127.984     0.150
     8.660   131.219     0.150
     8.790   131.977     0.150
    10.981   160.141     0.150
    14.783   210.359     0.150
    14.783   210.141     0.150
    14.909   211.500     0.150
    14.908   211.617     0.150
    15.284   214.570     0.150
    17.014   236.617     0.150
    17.014   236.891     0.150
    17.957   252.875     0.150
    18.201   255.328     0.150
    18.352   255.422     0.150
    19.376   267.516     0.150
    21.314   292.719     0.150
    21.314   292.930     0.150
    21.655   291.281     0.150
    21.655   291.320     0.150
    21.951   295.016     0.150
    21.990   299.656     0.150
    22.368   302.320     0.150
    22.382   303.430     0.150
    23.002   310.047     0.150
    23.286   309.422     0.150
    23.286   309.273     0.150
    23.292   309.820     0.150
    23.491   312.320     0.150
    23.491   312.625     0.150
    23.491   312.430     0.150
    24.626   322.281     0.150
    25.316   329.617     0.150
    26.077   339.109     0.150
    26.200   340.672     0.150
    26.200   340.367     0.150
    27.319   348.320     0.150
    27.353   347.922     0.150
    27.559   350.320     0.150
    27.784   350.617     0.150
    27.831   354.109     0.150
    28.367   357.422     0.150
    28.570   358.859     0.150
    28.570   358.477     0.150
    28.655   360.219     0.150
    29.643   368.320     0.150
    29.608   367.516     0.150
    29.608   367.625     0.150
    29.706   369.219     0.150
    29.742   370.828     0.150
    29.823   370.820     0.150
    29.827   369.516     0.150
    29.855   369.672     0.150
    29.855   369.508     0.150
    30.012   371.719     0.150
    30.012   371.977     0.150
    30.408   376.969     0.150
    31.191   381.016     0.150
    31.191   381.375     0.150
    31.191   381.195     0.150
    32.508   394.430     0.150
    32.855   396.586     0.150
    32.962   395.422     0.150
    33.936   405.219     0.150
    33.936   405.203     0.150
    34.970   416.758     0.150
    35.026   417.078     0.150
    35.061   416.430     0.150
    35.679   419.719     0.150
    35.941   422.320     0.150
    35.914   424.031     0.150
    36.448   427.898     0.150
    36.748   428.922     0.150
    36.689   430.508     0.150
    37.480   435.016     0.150
    38.223   441.422     0.150
    38.543   445.992     0.150
    39.063   448.617     0.150
    39.262   451.617     0.150
    39.843   456.062     0.150
    40.898   465.320     0.150
    41.093   467.422     0.150
    41.195   468.773     0.150
    41.283   468.688     0.150
    41.778   472.719     0.150
    41.901   473.719     0.150
    42.034   474.758     0.150
    42.076   475.422     0.150
    42.146   475.516     0.150
    42.141   475.430     0.150
    42.249   476.719     0.150
    42.275   476.719     0.150
    42.274   476.695     0.150
    42.404   476.023     0.150
    42.423   477.961     0.150
    42.625   479.617     0.150
    42.615   478.664     0.150
    42.679   479.906     0.150
    42.755   480.578     0.150
    43.063   483.188     0.150
    43.197   483.820     0.150
    43.224   484.422     0.150
    43.348   485.656     0.150
    43.416   484.516     0.150
    43.410   486.023     0.150
    43.464   485.922     0.150
    43.467   486.516     0.150
    43.500   486.250     0.150
    43.882   489.117     0.150
    43.882   489.320     0.150
    43.920   489.922     0.150
    43.933   489.609     0.150
    44.183   492.000     0.150
    44.605   494.906     0.150
    44.719   499.242     0.150
    44.763   497.078     0.150
    44.750   497.695     0.150
    44.784   495.953     0.150
    44.972   499.914     0.150
    45.205   501.719     0.150
    45.282   502.812     0.150
    45.325   500.438     0.150
    45.358   500.211     0.150
    45.385   502.250     0.150
    45.571   500.320     0.150
    45.571   500.758     0.150
    45.619   502.453     0.150
    45.968   505.211     0.150
    46.363   507.617     0.150
    46.403   508.516     0.150
    46.510   509.766     0.150
    46.704   512.016     0.150
    47.414   516.867     0.150
    47.527   516.461     0.150
    47.527   516.016     0.150
    47.460   519.062     0.150
    48.204   523.188     0.150
    50.145   540.102     0.150
    50.322   538.648     0.150
    50.322   538.320     0.150
    50.499   541.055     0.150
    53.473   561.852     0.150
    53.833   564.672     0.150
    53.833   564.922     0.150
    54.061   566.117     0.150
    54.061   567.117     0.150
    54.601   570.383     0.150
    56.045   580.320     0.150
    56.402   583.102     0.150
    57.510   592.172     0.150
    57.899   597.961     0.150
    58.446   598.688     0.150
    60.328   610.422     0.150
    60.809   613.953     0.150
    60.849   614.586     0.150
    61.035   616.695     0.150
    61.701   621.156     0.150
    62.423   622.320     0.150
    62.039   623.602     0.150
    64.051   637.398     0.150
    71.907   686.273     0.150
    72.725   689.195     0.150
    72.961   692.211     0.150
    73.193   694.242     0.150
    73.631   696.836     0.150
    73.689   698.281     0.150
    75.373   705.531     0.150
    75.722   706.680     0.150
    75.996   709.586     0.150
    76.271   709.250     0.150
    76.804   713.602     0.150
    78.730   723.078     0.150
    79.699   729.758     0.150
    80.649   735.438     0.150
    80.954   735.203     0.150
    81.236   737.836     0.150
    82.696   744.195     0.150
    83.074   746.445     0.150
    83.671   750.258     0.150
    84.585   755.727     0.150
    87.350   768.609     0.150
    87.952   771.578     0.150
    94.602   801.820     0.150
   116.322  1752.930     0.150
   116.322  1124.938     0.150
   117.627  1747.836     0.150
   117.627  1126.781     0.150
   118.641  1128.961     0.150
   118.798  1129.750     0.150
   119.447  1740.641     0.150
   119.447  1130.141     0.150
    83.405   748.922     0.150
    76.226   711.031     0.150
    29.823   370.867     0.150
    14.783   209.922     0.150
    14.783   209.820     0.150
    29.635   369.359     0.150
    30.012   371.820     0.150
    30.012   371.219     0.150
    33.468   402.148     0.150
    33.731   404.859     0.150
    33.936   405.547     0.150
    34.025   407.750     0.150
    34.065   406.727     0.150
    34.074   408.586     0.150
    34.149   409.203     0.150
    34.190   409.297     0.150
    34.595   413.125     0.150
    34.677   414.195     0.150
    34.736   414.953     0.150
    34.769   413.836     0.150
    34.775   414.828     0.150
    34.970   416.617     0.150
    34.970   415.922     0.150
    34.968   416.578     0.150
    35.014   416.953     0.150
    35.024   416.898     0.150
    35.111   416.531     0.150
    35.083   417.328     0.150
    35.193   417.508     0.150
    35.227   419.016     0.150
    35.316   419.266     0.150
    35.389   420.109     0.150
    35.431   420.430     0.150
    35.504   421.516     0.150
    35.504   421.875     0.150
    35.504   421.016     0.150
    35.560   421.070     0.150
    35.722   422.773     0.150
    35.826   424.266     0.150
    35.908   424.250     0.150
    35.988   425.242     0.150
    36.008   425.109     0.150
    36.113   425.547     0.150
    36.132   426.188     0.150
    36.323   427.953     0.150
    36.424   428.539     0.150
    36.615   430.883     0.150
    36.649   431.117     0.150
    37.034   434.148     0.150
    37.034   433.719     0.150
    37.034   433.219     0.150
    37.171   435.320     0.150
    37.171   435.500     0.150
    37.171   434.719     0.150
    37.206   435.688     0.150
    37.423   436.586     0.150
    37.446   436.109     0.150
    37.500   437.914     0.150
    37.517   438.234     0.150
    37.628   439.273     0.150
    37.645   438.922     0.150
    37.645   439.359     0.150
    37.733   439.016     0.150
    37.783   439.922     0.150
    37.783   440.312     0.150
    37.864   440.719     0.150
    37.928   440.719     0.150
    37.942   441.016     0.150
    38.049   442.648     0.150
    38.187   443.727     0.150
    38.212   443.469     0.150
    38.348   447.219     0.150
    38.422   446.359     0.150
    38.443   445.711     0.150
    38.510   446.586     0.150
    38.502   446.133     0.150
    38.528   446.219     0.150
    38.528   446.359     0.150
    38.874   447.031     0.150
    38.874     5.586     0.150
    38.817   448.422     0.150
    38.817   448.219     0.150
    39.152   452.516     0.150
    39.712   456.016     0.150
    39.712   456.312     0.150
    40.459   461.078     0.150
    40.600   463.016     0.150
    40.600   462.516     0.150
    40.780   465.016     0.150
    40.780   464.422     0.150
    40.983   465.820     0.150
    40.983   465.422     0.150
    41.195   469.117     0.150
    41.319   469.320     0.150
    41.319   468.922     0.150
    41.451   471.516     0.150
    41.451   469.922     0.150
    41.723   473.016     0.150
    41.723   472.484     0.150
    41.878   474.320     0.150
    41.901   473.820     0.150
    41.901   474.312     0.150
    41.966   474.117     0.150
    41.966   473.922     0.150
    42.141   475.719     0.150
    42.242   476.422     0.150
    42.478   478.516     0.150
    42.615   478.977     0.150
    42.688   480.516     0.150
    42.841   481.820     0.150
    43.410   486.617     0.150
    43.402   485.633     0.150
    44.372   491.930     0.150
    44.372     7.305     0.150
    44.763   496.578     0.150
    45.196   500.562     0.150
    45.257   499.102     0.150
    45.507   500.484     0.150
    45.824   506.727     0.150
    46.336   508.602     0.150
    46.625   511.945     0.150
    46.770   511.242     0.150
    46.923   512.281     0.150
    46.923   512.477     0.150
    46.791   512.227     0.150
    46.983   513.602     0.150
    47.276   514.484     0.150
    47.414   516.648     0.150
    47.755   518.656     0.150
    47.834   520.180     0.150
    47.815   519.664     0.150
    48.399   524.055     0.150
    48.663   527.016     0.150
    49.203   530.359     0.150
    49.203   531.383     0.150
    53.149   560.328     0.150
    53.445   561.469     0.150
    53.445   561.742     0.150
    53.445   562.820     0.150
    53.460   559.656     0.150
    53.459   562.898     0.150
    53.474   562.898     0.150
    54.192   566.781     0.150
    54.598   569.367     0.150
    54.616   571.039     0.150
    54.682   571.133     0.150
    54.941   573.289     0.150
    55.184   576.094     0.150
    55.410   575.484     0.150
    55.975   581.273     0.150
    55.970   581.727     0.150
    56.193   582.586     0.150
    56.359   583.453     0.150
    56.353   582.906     0.150
    56.564   583.555     0.150
    57.200   590.242     0.150
    57.510   591.312     0.150
    58.120   595.633     0.150
    58.121   595.633     0.150
    58.138   597.359     0.150
    58.274   597.359     0.150
    58.335   596.414     0.150
    58.446   597.844     0.150
    59.111   602.719     0.150
    59.189   603.383     0.150
    59.503   606.031     0.150
    59.761   607.484     0.150
    59.925   609.469     0.150
    60.242   611.672     0.150
    60.545   613.883     0.150
    60.662   614.102     0.150
    61.478   620.062     0.150
     3.880   112.547     0.150
     3.880    65.180     0.150
     4.155    67.312     0.150
     4.452    72.195     0.150
     4.859    79.578     0.150
     5.366    84.695     0.150
     5.554    89.188     0.150
     5.903    93.000     0.150
     6.779   103.375     0.150
     6.857   105.000     0.150
     7.229   111.391     0.150
     8.402   126.172     0.150
     8.461   127.609     0.150
    16.591   233.719     0.150
    16.591   233.641     0.150
    18.352   256.016     0.150
    20.251   276.641     0.150
    20.642   281.578     0.150
    20.906   283.930     0.150
    20.909   283.188     0.150
    21.014   288.031     0.150
    21.314   291.438     0.150
    21.655   291.867     0.150
    21.655   292.070     0.150
    22.227   300.211     0.150
    23.322   312.000     0.150
    24.548   322.922     0.150
    24.626   321.617     0.150
    26.858   343.719     0.150
    27.179   346.211     0.150
    27.635   350.180     0.150
    29.855   368.336     0.150
    30.012   370.102     0.150
    30.764   376.727     0.150
    31.191   379.859     0.150
    32.604   393.125     0.150
    33.936   404.547     0.150
    34.404   409.391     0.150
    34.906   413.352     0.150
    40.459   460.406     0.150
    41.242   466.375     0.150
    44.032   489.688     0.150
    44.719   496.516     0.150
    44.972   497.570     0.150
    45.282   500.750     0.150
    46.363   507.328     0.150
    46.983   513.141     0.150
    47.197   514.617     0.150
    47.414   515.508     0.150
    47.951   521.336     0.150
    49.504   532.727     0.150
    50.145   537.641     0.150
    50.322   537.930     0.150
    53.473   561.352     0.150
    53.833   564.469     0.150
    55.927   579.367     0.150
    57.510   591.875     0.150
    58.446   597.727     0.150
    60.421   611.141     0.150
    60.809   612.891     0.150
    62.700   626.039     0.150
    63.832   634.148     0.150
    64.051   635.836     0.150
    66.615   652.516     0.150
    69.362   669.016     0.150
    71.744   684.141     0.150
    73.631   695.656     0.150
    74.001   697.938     0.150
    74.390   699.922     0.150
    74.447   700.781     0.150
    75.722   706.477     0.150
    76.271   709.477     0.150
    76.989   713.461     0.150
    80.954   735.438     0.150
    81.236   738.367     0.150
    84.585   754.898     0.150
    94.342   800.812     0.150
   130.483  1152.938     0.150
   138.931  1169.242     0.150
   141.154  1173.758     0.150
   143.246  1175.172     0.150
   146.896  1183.711     0.150
   147.826  1187.375     0.150
   148.035  1184.961     0.150
   148.065  1189.062     0.150
   149.599  1192.242     0.150
     4.319    67.367     0.150
     4.153    68.133     0.150
     4.153    69.609     0.150
     5.901    93.008     0.150
     8.459   127.711     0.150
    10.979   160.172     0.150
    14.781   210.016     0.150
    15.285   215.203     0.150
    17.012   236.531     0.150
    17.957   252.688     0.150
    18.199   255.266     0.150
    18.350   255.578     0.150
    21.313   292.617     0.150
    21.653   291.281     0.150
    23.284   309.203     0.150
    23.490   312.328     0.150
    24.627   322.281     0.150
    28.571   358.656     0.150
    28.656   360.250     0.150
    29.609   367.578     0.150
    29.856   369.688     0.150
    30.010   371.812     0.150
    31.189   380.992     0.150
    32.509   394.086     0.150
    32.855   396.898     0.150
    33.935   405.305     0.150
    36.205   426.430     0.150
    36.690   428.820     0.150
    38.872   446.703     0.150
    38.872     5.953     0.150
    39.061   448.664     0.150
    39.842   456.008     0.150
    41.092   467.336     0.150
    41.243   466.016     0.150
    41.777   473.633     0.150
    42.074   475.336     0.150
    42.144   475.930     0.150
    42.247   476.734     0.150
    42.274   476.734     0.150
    42.402   475.930     0.150
    42.614   478.508     0.150
    42.624   479.531     0.150
    43.195   484.031     0.150
    43.222   484.430     0.150
    43.415   484.430     0.150
    43.465   486.531     0.150
    43.881   489.133     0.150
    43.919   489.836     0.150
    44.370   491.656     0.150
    44.370     6.578     0.150
    44.696   496.828     0.150
    44.719   497.133     0.150
    44.762   497.086     0.150
    45.111   501.375     0.150
    45.282   502.227     0.150
    45.384   502.523     0.150
    45.505   500.133     0.150
    45.674   503.586     0.150
    47.413   516.641     0.150
    47.462   518.875     0.150
    47.525   516.766     0.150
    47.952   522.836     0.150
    48.203   524.195     0.150
    49.505   533.492     0.150
    50.146   538.297     0.150
    50.320   538.562     0.150
    50.498   541.047     0.150
    51.437   548.320     0.150
    53.833   564.711     0.150
    54.060   567.125     0.150
    54.600   570.312     0.150
    56.400   583.016     0.150
    57.510   592.000     0.150
    57.901   592.328     0.150
    58.445   598.484     0.150
    60.326   610.438     0.150
    60.851   614.328     0.150
    60.806   613.617     0.150
    61.034   616.617     0.150
    61.700   621.188     0.150
    63.832   634.281     0.150
    64.053   637.086     0.150
    67.210   657.203     0.150
    71.909   686.320     0.150
    72.723   689.281     0.150
    72.873   690.680     0.150
    72.963   691.938     0.150
    73.195   693.977     0.150
    73.632   696.969     0.150
    74.003   697.930     0.150
    74.390   700.188     0.150
    74.448   700.875     0.150
    75.190   704.977     0.150
    75.371   705.562     0.150
    75.720   706.844     0.150
    75.998   708.961     0.150
    76.269   709.367     0.150
    76.499   711.156     0.150
    76.805   713.836     0.150
    78.728   723.641     0.150
    79.701   729.344     0.150
    80.651   735.094     0.150
    80.749   735.117     0.150
    80.952   735.344     0.150
    81.238   737.828     0.150
    81.321   738.203     0.150
    81.716   740.305     0.150
    82.694   744.234     0.150
    83.072   746.656     0.150
    83.669   750.336     0.150
    84.586   755.305     0.150
    84.612   755.805     0.150
    87.352   768.719     0.150
    87.954   771.336     0.150
    90.728   785.492     0.150
    90.755   784.492     0.150
    90.910   786.102     0.150
    95.850   808.258     0.150
   117.629  1747.648     0.150
   117.629  1126.938     0.150
   118.643  1743.227     0.150
   118.643  1129.094     0.150
   118.800  1129.711     0.150
   119.449  1740.852     0.150
   119.449  1130.586     0.150
    76.227   711.195     0.150
    29.822   370.852     0.150
     5.901    91.734     0.150
     7.161   109.430     0.150
     7.688   117.289     0.150
     7.718   118.273     0.150
     8.459   126.234     0.150
     8.459   127.945     0.150
     8.788   132.211     0.150
    14.781   210.133     0.150
    14.781   210.570     0.150
    14.907   211.633     0.150
    15.285   215.836     0.150
    17.012   240.234     0.150
    18.350   255.336     0.150
    19.374   267.430     0.150
    21.313   292.430     0.150
    21.313   292.992     0.150
    21.653   291.836     0.150
    21.778   297.688     0.150
    21.949   294.531     0.150
    21.989   299.375     0.150
    22.367   303.031     0.150
    23.001   310.102     0.150
    23.290   310.430     0.150
    23.284   309.336     0.150
    23.327   313.836     0.150
    23.469   314.867     0.150
    23.490   313.273     0.150
    23.490   311.930     0.150
    23.490   312.789     0.150
    25.314   330.133     0.150
    25.505   333.992     0.150
    26.076   339.156     0.150
    27.317   348.336     0.150
    27.557   350.336     0.150
    27.782   350.531     0.150
    27.831   354.406     0.150
    28.366   357.430     0.150
    28.571   358.992     0.150
    28.656   360.070     0.150
    29.609   367.133     0.150
    29.609   367.773     0.150
    29.642   368.734     0.150
    29.634   369.734     0.150
    29.828   369.430     0.150
    29.856   369.836     0.150
    29.705   368.633     0.150
    29.822   370.836     0.150
    30.010   371.930     0.150
    30.010   371.531     0.150
    30.407   376.906     0.150
    31.189   380.531     0.150
    31.189   381.289     0.150
    32.509   394.227     0.150
    32.605   395.273     0.150
    32.960   395.234     0.150
    33.935   405.539     0.150
    34.229   409.133     0.150
    34.275   412.234     0.150
    34.969   417.234     0.150
    34.969   416.750     0.150
    34.969   416.531     0.150
    35.025   417.195     0.150
    35.434   419.859     0.150
    35.502   421.633     0.150
    35.502   421.430     0.150
    35.677   420.133     0.150
    35.939   422.031     0.150
    36.746   428.930     0.150
    36.794   432.312     0.150
    36.961   433.000     0.150
    37.032   433.633     0.150
    37.032   433.336     0.150
    37.033   434.211     0.150
    37.078   434.383     0.150
    37.170   435.430     0.150
    37.170   435.688     0.150
    37.170   435.234     0.150
    37.422   436.797     0.150
    37.479   435.133     0.150
    37.499   437.664     0.150
    37.516   438.180     0.150
    37.627   438.703     0.150
    37.644   439.031     0.150
    37.644   438.734     0.150
    37.781   439.930     0.150
    37.781   439.734     0.150
    37.863   440.656     0.150
    37.926   440.930     0.150
    37.926   440.633     0.150
    37.941   441.133     0.150
    37.941   440.836     0.150
    38.047   443.188     0.150
    38.185   443.883     0.150
    38.222   441.336     0.150
    38.347   445.734     0.150
    38.347   445.609     0.150
    38.442   445.781     0.150
    38.542   445.633     0.150
    38.501   446.297     0.150
    38.508   446.820     0.150
    38.527   446.336     0.150
    38.527   446.133     0.150
    38.565   446.484     0.150
    38.816   448.430     0.150
    38.816   448.133     0.150
    39.151   452.430     0.150
    39.261   451.430     0.150
    39.457   455.031     0.150
    39.457   454.859     0.150
    39.710   456.031     0.150
    39.710   456.320     0.150
    39.710   456.133     0.150
    40.598   463.234     0.150
    40.598   463.055     0.150
    40.598   462.836     0.150
    40.779   464.930     0.150
    40.779   464.633     0.150
    40.982   465.836     0.150
    40.982   465.430     0.150
    41.194   469.133     0.150
    41.194   468.695     0.150
    41.282   468.531     0.150
    41.282   468.922     0.150
    41.282   468.641     0.150
    41.318   469.336     0.150
    41.318   468.633     0.150
    41.450   472.336     0.150
    41.450   470.234     0.150
    41.722   472.836     0.150
    41.722   472.406     0.150
    41.877   474.234     0.150
    41.899   473.836     0.150
    41.899   474.109     0.150
    41.964   474.031     0.150
    41.964   474.133     0.150
    42.032   475.031     0.150
    42.032   474.688     0.150
    42.139   475.734     0.150
    42.139   475.422     0.150
    42.241   476.430     0.150
    42.272   476.656     0.150
    42.422   477.930     0.150
    42.477   478.633     0.150
    42.624   479.633     0.150
    42.678   479.961     0.150
    42.687   480.531     0.150
    42.754   480.602     0.150
    42.840   481.836     0.150
    43.062   483.359     0.150
    43.222   484.531     0.150
    43.347   485.781     0.150
    43.463   486.031     0.150
    43.408   486.633     0.150
    43.408   486.141     0.150
    43.498   486.359     0.150
    43.881   489.734     0.150
    43.932   489.617     0.150
    44.182   491.914     0.150
    44.603   494.953     0.150
    45.323   500.336     0.150
    45.356   500.109     0.150
    45.618   502.359     0.150
    45.966   505.141     0.150
    46.402   509.031     0.150
    46.361   506.930     0.150
    46.508   509.812     0.150
    46.703   512.633     0.150
    47.413   517.234     0.150
    47.525   516.234     0.150
    51.293   547.336     0.150
    54.060   566.734     0.150
    56.043   580.430     0.150
    62.422   622.375     0.150
    62.038   623.375     0.150
    76.269   709.133     0.150
    80.952   735.234     0.150
    81.229   737.531     0.150
    83.057   746.430     0.150
    94.600   800.930     0.150
     1.329    24.789     0.150
     3.878    67.562     0.150
     4.153    69.172     0.150
     4.451    75.312     0.150
     5.552    89.039     0.150
    20.250   276.359     0.150
    20.906   283.664     0.150
    21.013   285.102     0.150
    21.066   285.672     0.150
    21.313   289.023     0.150
    22.226   299.906     0.150
    23.321   312.461     0.150
    23.490   310.672     0.150
    24.627   321.734     0.150
    27.178   345.914     0.150
    28.571   356.477     0.150
    28.656   357.352     0.150
    29.856   368.695     0.150
    30.010   369.953     0.150
    31.189   380.281     0.150
    32.605   392.789     0.150
    33.935   404.273     0.150
    34.275   408.039     0.150
    34.405   409.133     0.150
    34.907   413.289     0.150
    39.061   447.805     0.150
    41.243   466.656     0.150
    42.402   475.273     0.150
    45.384   501.055     0.150
    46.152   506.352     0.150
    46.361   507.133     0.150
    47.197   514.312     0.150
    47.413   515.680     0.150
    47.525   516.523     0.150
    49.505   532.773     0.150
    50.146   536.680     0.150
    50.320   537.641     0.150
    51.437   547.633     0.150
    53.336   560.172     0.150
    53.471   560.977     0.150
    53.833   564.422     0.150
    54.060   566.281     0.150
    57.510   591.141     0.150
    57.901   593.523     0.150
    58.445   597.375     0.150
    60.419   611.336     0.150
    60.806   612.977     0.150
    62.698   626.477     0.150
    63.832   633.211     0.150
    64.053   636.812     0.150
    64.073   635.984     0.150
    66.616   652.141     0.150
    70.336   675.406     0.150
    71.746   683.320     0.150
    71.873   683.852     0.150
    73.465   693.156     0.150
    74.297   697.789     0.150
    74.390   699.039     0.150
    74.675   701.016     0.150
    75.720   706.539     0.150
    76.157   709.055     0.150
    76.227   709.633     0.150
    76.269   709.734     0.150
    76.499   710.789     0.150
    76.462   710.602     0.150
    76.987   713.336     0.150
    80.952   735.445     0.150
    81.238   737.195     0.150
    86.039   761.680     0.150
   117.629  1125.703     0.150
   130.983  1152.781     0.150
   134.855  1161.734     0.150
   138.930  1168.992     0.150
   144.516  1178.836     0.150
   146.896  1182.164     0.150
   147.885  1184.156     0.150
     4.317    67.336     0.150
     5.745   153.188     0.150
     4.317   117.828     0.150
     2.929    82.875     0.150
     4.317   117.828     0.150
     3.558    57.609     0.150
     4.317   117.828     0.150
     3.878   106.094     0.150
     4.317   117.828     0.150
     4.317    67.336     0.150
     5.745   153.188     0.150
     4.153   114.305     0.150
     4.145    68.427     0.150
     4.145    69.417     0.150
     4.849    80.607     0.150
     5.893    92.427     0.150
     6.036    95.607     0.150
     6.768   104.707     0.150
     7.153   109.167     0.150
     7.712   117.967     0.150
     7.680   116.697     0.150
     8.451   127.627     0.150
     8.451   127.887     0.150
     8.780   132.027     0.150
    14.774   209.827     0.150
    14.774   210.087     0.150
    14.900   212.627     0.150
    17.004   240.627     0.150
    18.341   255.027     0.150
    19.367   267.627     0.150
    21.310   292.427     0.150
    21.310   293.137     0.150
    21.645   291.527     0.150
    21.941   294.827     0.150
    21.987   299.387     0.150
    22.378   303.807     0.150
    22.363   303.527     0.150
    22.997   310.337     0.150
    23.286   310.827     0.150
    23.276   309.727     0.150
    23.323   312.727     0.150
    23.486   313.828     0.150
    23.486   314.237     0.150
    25.502   333.687     0.150
    26.073   339.027     0.150
    26.196   341.127     0.150
    27.828   354.797     0.150
    27.774   351.027     0.150
    28.360   357.527     0.150
    29.613   367.127     0.150
    30.005   371.927     0.150
    30.005   371.327     0.150
    30.005   371.787     0.150
    30.005   371.127     0.150
    29.819   370.727     0.150
    30.405   376.896     0.150
    31.183   381.127     0.150
    32.953   395.727     0.150
    33.929   405.027     0.150
    33.929   405.387     0.150
    33.929   405.502     0.150
    34.964   415.707     0.150
    35.009   416.308     0.150
    35.018   416.835     0.150
    35.020   417.237     0.150
    35.055   416.240     0.150
    35.498   421.527     0.150
    35.498   421.256     0.150
    35.931   422.027     0.150
    35.902   423.872     0.150
    35.982   425.336     0.150
    36.107   425.460     0.150
    36.262   426.277     0.150
    36.419   428.487     0.150
    36.644   430.534     0.150
    36.957   432.526     0.150
    37.165   434.846     0.150
    37.418   436.546     0.150
    37.512   437.881     0.150
    37.512   438.437     0.150
    37.494   437.813     0.150
    37.472   434.627     0.150
    37.639   439.327     0.150
    37.777   440.227     0.150
    37.777   440.065     0.150
    37.859   440.590     0.150
    37.921   441.027     0.150
    37.921   440.637     0.150
    38.181   443.846     0.150
    38.438   445.827     0.150
    38.497   446.042     0.150
    38.523   446.218     0.150
    38.561   446.614     0.150
    38.865   446.787     0.150
    38.865     6.880     0.150
    39.706   456.242     0.150
    40.594   462.483     0.150
    40.978   466.127     0.150
    40.978   465.827     0.150
    41.087   467.627     0.150
    41.277   468.867     0.150
    41.277   468.308     0.150
    41.772   472.427     0.150
    42.027   473.619     0.150
    42.069   474.827     0.150
    42.242   475.927     0.150
    42.269   476.527     0.150
    42.673   479.371     0.150
    42.749   480.452     0.150
    42.727   479.102     0.150
    42.727     5.075     0.150
    43.057   482.366     0.150
    43.457   486.327     0.150
    43.460   486.527     0.150
    44.364   491.688     0.150
    44.364     4.613     0.150
    45.319   499.337     0.150
    46.397   508.727     0.150
    50.312   538.527     0.150
    53.829   564.727     0.150
    54.055   566.227     0.150
    56.036   580.127     0.150
    76.261   709.527     0.150
    81.233   737.427     0.150
    83.049   746.227     0.150
   116.332  1125.341     0.150
   118.650  1129.355     0.150
   118.808  1129.712     0.150
   119.457  1130.637     0.150
     1.331    45.487     0.150
     3.871    67.487     0.150
     4.145    68.567     0.150
     4.444    73.997     0.150
     4.849    77.857     0.150
     5.356    84.537     0.150
     5.543    89.267     0.150
     6.768   103.747     0.150
     6.847   105.087     0.150
     7.153   108.646     0.150
     7.680   115.917     0.150
     8.391   125.437     0.150
     8.451   126.497     0.150
     8.980   135.017     0.150
     9.826   146.237     0.150
    10.973   160.297     0.150
    14.900   212.277     0.150
    16.581   233.917     0.150
    16.581   233.827     0.150
    17.004   237.157     0.150
    18.341   255.907     0.150
    20.249   277.877     0.150
    20.640   280.347     0.150
    20.905   284.447     0.150
    20.907   284.107     0.150
    20.903   285.107     0.150
    21.009   286.107     0.150
    21.310   289.627     0.150
    21.645   290.977     0.150
    21.645   290.557     0.150
    22.222   298.977     0.150
    23.276   309.017     0.150
    23.317   310.727     0.150
    23.486   312.227     0.150
    24.544   322.807     0.150
    24.629   322.187     0.150
    25.450   330.287     0.150
    26.856   343.977     0.150
    26.874   343.367     0.150
    27.631   349.887     0.150
    28.575   357.767     0.150
    29.566   367.627     0.150
    29.831   370.287     0.150
    29.831   369.857     0.150
    29.819   370.007     0.150
    30.005   370.467     0.150
    32.610   394.677     0.150
    33.031   398.077     0.150
    33.929   404.937     0.150
    34.910   414.727     0.150
    41.249   466.847     0.150
    42.394   475.727     0.150
    43.398   486.447     0.150
    44.087   490.697     0.150
    44.872   496.617     0.150
    50.312   537.827     0.150
    53.829   564.297     0.150
    57.509   591.197     0.150
    58.441   598.487     0.150
    62.690   626.907     0.150
    64.058   635.707     0.150
    71.515   682.017     0.150
    80.944   734.957     0.150
    81.242   737.497     0.150
     5.737   153.002     0.150
     4.309   117.658     0.150
     4.145   114.109     0.150
     4.145   114.109     0.150
     4.145    65.264     0.150
     4.309   117.621     0.150
     2.921    82.668     0.150
     4.444   119.615     0.150
     4.309   117.621     0.150
     2.921    82.668     0.150
     4.309   117.621     0.150
     4.444   119.615     0.150
     4.444   119.615     0.150
     5.737   152.980     0.150
     5.737   152.980     0.150
     4.145   114.109     0.150
     5.737   152.980     0.150
     4.145   114.109     0.150
     4.145   114.109     0.150
     4.156    68.283     0.150
     4.156    70.604     0.150
     4.893    81.143     0.150
     5.389    87.244     0.150
     5.897    94.283     0.150
     6.085    96.303     0.150
     6.804   104.973     0.150
     7.194   109.953     0.150
     7.734   117.414     0.150
     8.504   128.283     0.150
     8.840   132.463     0.150
    14.837   210.594     0.150
    14.963   213.684     0.150
    15.340   216.482     0.150
    17.056   242.783     0.150
    17.056   241.863     0.150
    18.373   256.783     0.150
    19.253   269.283     0.150
    19.432   268.482     0.150
    21.259   292.783     0.150
    21.702   292.283     0.150
    21.930   298.732     0.150
    21.994   296.383     0.150
    22.319   302.584     0.150
    22.949   309.223     0.150
    23.244   311.584     0.150
    23.287   310.383     0.150
    25.375   331.084     0.150
    26.020   338.203     0.150
    28.432   358.283     0.150
    28.623   358.434     0.150
    29.879   369.684     0.150
    29.767   370.383     0.150
    30.079   371.283     0.150
    32.560   394.453     0.150
    33.899   405.482     0.150
    33.899   404.873     0.150
    34.980   416.402     0.150
    35.457   421.613     0.150
    36.377   428.232     0.150
    37.738   439.434     0.150
    37.887   440.264     0.150
    38.856   446.693     0.150
    39.059   448.703     0.150
    39.439   454.373     0.150
    39.472   451.902     0.150
    39.470   451.514     0.150
    39.803   457.334     0.150
    41.243   468.213     0.150
    41.739   472.203     0.150
    41.891   472.684     0.150
    42.036   474.902     0.150
    42.200   476.562     0.150
    42.236   476.693     0.150
    42.400   475.754     0.150
    42.732   478.633     0.150
    42.765   478.643     0.150
    43.299   485.402     0.150
    43.349   486.232     0.150
    43.426   486.232     0.150
    43.457   485.754     0.150
    43.982   488.213     0.150
    44.048   491.322     0.150
    44.348   491.357     0.150
    44.348   491.846     0.150
    44.818   497.713     0.150
    44.833   496.822     0.150
    45.273   501.643     0.150
    45.349   502.674     0.150
    45.484   500.584     0.150
    46.466   509.434     0.150
    46.924   512.764     0.150
    47.231   514.533     0.150
    47.348   517.053     0.150
    48.236   522.463     0.150
    49.029   529.684     0.150
    50.329   539.883     0.150
    50.329   538.754     0.150
    51.630   548.244     0.150
    52.818   557.062     0.150
    53.414   562.133     0.150
    56.404   582.293     0.150
    58.397   598.322     0.150
    59.061   603.232     0.150
    61.421   619.273     0.150
    63.987   635.043     0.150
    73.131   694.004     0.150
    73.564   696.643     0.150
    74.321   699.213     0.150
    75.754   706.773     0.150
    76.310   709.684     0.150
    76.310   709.383     0.150
    81.000   735.354     0.150
    81.275   738.184     0.150
    87.392   768.572     0.150
   118.595  1129.102     0.150
   119.402  1130.252     0.150
     1.259    43.703     0.150
     3.925    68.664     0.150
     4.510    74.133     0.150
     4.893    80.812     0.150
     5.389    86.193     0.150
     5.897    90.354     0.150
     7.734   117.062     0.150
     8.422   125.703     0.150
     9.044   131.883     0.150
    11.039   161.174     0.150
    14.837   211.223     0.150
    14.963   212.863     0.150
    16.581   233.834     0.150
    16.581   233.834     0.150
    17.056   241.504     0.150
    18.373   255.953     0.150
    20.965   284.014     0.150
    21.702   292.453     0.150
    21.702   292.254     0.150
    23.287   309.174     0.150
    23.270   309.043     0.150
    24.492   320.143     0.150
    29.640   367.264     0.150
    29.767   367.893     0.150
    29.879   369.803     0.150
    32.651   394.023     0.150
    33.899   405.203     0.150
    35.975   421.953     0.150
    36.082   423.902     0.150
    36.884   429.604     0.150
    38.856   447.053     0.150
    42.036   474.273     0.150
    42.732   478.994     0.150
    43.349   484.213     0.150
    43.774   486.963     0.150
    44.048   489.863     0.150
    44.833   497.143     0.150
    45.631   502.213     0.150
    45.746   503.812     0.150
    46.938   513.312     0.150
    47.231   515.354     0.150
    48.355   524.533     0.150
    49.209   529.482     0.150
    50.329   537.373     0.150
    54.633   571.754     0.150
    71.253   680.613     0.150
    71.982   684.193     0.150
    72.763   689.473     0.150
    73.016   691.713     0.150
    73.131   693.873     0.150
    73.564   696.473     0.150
    73.995   696.723     0.150
    74.002   696.283     0.150
    74.044   698.354     0.150
    74.590   699.844     0.150
    74.645   699.373     0.150
    74.610   701.193     0.150
    74.785   701.924     0.150
    75.104   703.273     0.150
    75.352   704.584     0.150
    75.486   705.414     0.150
    75.509   705.553     0.150
    75.736   706.473     0.150
    75.754   706.924     0.150
    76.222   709.033     0.150
    76.271   709.283     0.150
    76.506   711.113     0.150
    76.518   710.072     0.150
    76.962   713.254     0.150
    77.083   713.953     0.150
    77.585   716.773     0.150
    77.698   717.604     0.150
    77.961   718.873     0.150
    79.040   725.104     0.150
    79.204   726.754     0.150
    79.418   726.293     0.150
    80.538   733.873     0.150
    81.000   735.613     0.150
    81.275   738.553     0.150
    81.283   738.463     0.150
    83.099   746.533     0.150
    83.449   749.783     0.150
    89.285   776.883     0.150
    90.736   784.713     0.150
    92.404   792.334     0.150
    93.581   797.383     0.150
     4.156    65.400     0.150
     4.336   118.273     0.150
     4.336   118.273     0.150
     5.760   153.520     0.150
     4.156   114.350     0.150
     4.336   118.273     0.150
     5.760   153.520     0.150
     4.510   121.254     0.150
     3.538    99.854     0.150
     3.538    99.854     0.150
     3.538    57.320     0.150
     3.538    99.854     0.150
     4.156   114.350     0.150
     5.760   153.520     0.150
     4.336   118.273     0.150
     4.336   118.273     0.150
     4.156   114.350     0.150
     4.336   118.273     0.150
     2.970    83.850     0.150
     4.510   121.254     0.150
     4.102    68.816     0.150
     4.810    79.707     0.150
     5.314    86.207     0.150
     5.850    92.473     0.150
     6.727   104.238     0.150
     7.113   108.637     0.150
     7.645   116.316     0.150
     7.684   117.477     0.150
     8.416   127.145     0.150
     8.416   127.297     0.150
     8.926   133.777     0.150
     8.951   136.367     0.150
     9.799   145.887     0.150
    10.345   152.676     0.150
    10.946   159.324     0.150
    14.745   209.488     0.150
    14.745   209.727     0.150
    14.745   209.285     0.150
    14.871   212.746     0.150
    15.315   214.137     0.150
    16.968   236.301     0.150
    18.300   254.738     0.150
    21.283   292.508     0.150
    21.283   292.797     0.150
    21.612   290.562     0.150
    21.751   297.578     0.150
    21.965   298.945     0.150
    22.968   309.898     0.150
    23.233   308.676     0.150
    23.454   311.547     0.150
    24.633   322.184     0.150
    25.475   333.828     0.150
    26.048   338.945     0.150
    26.171   339.918     0.150
    26.171   340.137     0.150
    28.604   358.078     0.150
    28.604   358.578     0.150
    28.684   359.566     0.150
    28.684   359.695     0.150
    29.641   367.586     0.150
    29.641   367.777     0.150
    29.606   369.316     0.150
    29.990   372.387     0.150
    29.990   371.668     0.150
    29.990   371.188     0.150
    30.379   376.266     0.150
    30.438   377.148     0.150
    30.578   377.367     0.150
    30.578   376.836     0.150
    31.143   381.176     0.150
    31.640   386.438     0.150
    31.881   389.238     0.150
    32.542   393.543     0.150
    32.542   393.738     0.150
    32.865   396.566     0.150
    33.333   400.758     0.150
    33.540   403.918     0.150
    33.683   404.164     0.150
    33.694   404.465     0.150
    33.893   404.855     0.150
    34.003   409.188     0.150
    34.518   411.605     0.150
    34.932   415.887     0.150
    34.932   415.387     0.150
    34.986   416.633     0.150
    34.988   416.738     0.150
    35.466   421.188     0.150
    35.466   421.684     0.150
    35.466   420.988     0.150
    35.525   421.008     0.150
    35.870   423.805     0.150
    36.073   424.961     0.150
    36.197   425.488     0.150
    36.387   428.266     0.150
    36.421   427.770     0.150
    36.720   428.852     0.150
    36.996   432.988     0.150
    36.996   433.230     0.150
    36.996   432.785     0.150
    37.132   435.285     0.150
    37.132   434.988     0.150
    37.461   437.535     0.150
    37.483   437.980     0.150
    37.607   438.688     0.150
    37.607   438.285     0.150
    37.696   438.688     0.150
    37.696   438.387     0.150
    37.744   439.586     0.150
    37.744   439.750     0.150
    37.744   439.285     0.150
    37.829   440.316     0.150
    37.886   440.387     0.150
    37.886   439.988     0.150
    37.902   440.887     0.150
    37.902   440.488     0.150
    38.149   443.227     0.150
    38.465   445.625     0.150
    38.491   445.988     0.150
    38.491   445.688     0.150
    38.531   446.043     0.150
    38.777   448.387     0.150
    38.777   447.988     0.150
    39.010   448.148     0.150
    39.672   455.887     0.150
    39.672   455.387     0.150
    39.801   455.641     0.150
    40.425   460.957     0.150
    40.561   462.785     0.150
    40.561   463.137     0.150
    40.561   462.387     0.150
    40.740   464.688     0.150
    40.740   464.285     0.150
    40.945   465.688     0.150
    40.945   465.285     0.150
    41.052   466.887     0.150
    41.049   467.688     0.150
    41.154   468.887     0.150
    41.154   467.953     0.150
    41.241   468.285     0.150
    41.241   468.387     0.150
    41.241   468.141     0.150
    41.287   466.391     0.150
    41.280   469.188     0.150
    41.280   468.387     0.150
    41.736   471.688     0.150
    41.859   473.688     0.150
    41.859   473.375     0.150
    41.926   474.188     0.150
    41.926   473.785     0.150
    41.993   474.887     0.150
    41.993   474.277     0.150
    42.034   474.387     0.150
    42.034   577.488     0.150
    42.101   475.688     0.150
    42.233   475.988     0.150
    42.234   476.473     0.150
    42.351   475.406     0.150
    42.383   477.785     0.150
    42.582   478.484     0.150
    42.638   479.703     0.150
    42.714   479.859     0.150
    42.803   481.887     0.150
    43.024   482.773     0.150
    43.182   484.285     0.150
    43.309   485.516     0.150
    43.371   486.688     0.150
    43.460   485.996     0.150
    43.841   488.086     0.150
    43.841   590.688     0.150
    43.878   489.387     0.150
    43.893   489.863     0.150
    44.565   494.559     0.150
    44.687   496.484     0.150
    44.709   496.945     0.150
    44.730   497.859     0.150
    44.762   497.422     0.150
    44.728   497.586     0.150
    45.122   501.348     0.150
    45.295   502.188     0.150
    45.285   500.535     0.150
    45.318   499.566     0.150
    45.344   502.293     0.150
    45.539   502.293     0.150
    45.668   504.434     0.150
    45.579   501.828     0.150
    45.928   505.855     0.150
    46.163   508.375     0.150
    46.470   508.934     0.150
    47.373   516.734     0.150
    47.486   518.754     0.150
    47.661   519.754     0.150
    47.978   522.535     0.150
    48.164   523.238     0.150
    49.542   534.039     0.150
    50.181   539.105     0.150
    50.269   538.113     0.150
    50.460   541.035     0.150
    50.699   542.992     0.150
    51.433   548.266     0.150
    53.329   562.270     0.150
    53.427   561.496     0.150
    53.824   565.422     0.150
    54.039   566.492     0.150
    54.587   571.383     0.150
    54.685   571.625     0.150
    56.349   582.598     0.150
    57.492   591.922     0.150
    58.411   598.371     0.150
    60.286   610.238     0.150
    60.755   613.516     0.150
    60.891   614.516     0.150
    60.999   616.250     0.150
    61.666   620.684     0.150
    62.585   627.535     0.150
    64.078   637.070     0.150
    71.943   686.285     0.150
    72.508   689.402     0.150
    72.678   688.938     0.150
    73.002   693.117     0.150
    73.224   694.414     0.150
    73.730   697.043     0.150
    73.654   697.043     0.150
    73.819   697.188     0.150
    74.042   698.188     0.150
    74.380   700.285     0.150
    74.380   699.656     0.150
    74.485   701.480     0.150
    75.136   705.082     0.150
    75.229   705.125     0.150
    75.325   705.055     0.150
    76.043   708.508     0.150
    76.224   709.277     0.150
    76.545   712.344     0.150
    76.840   714.578     0.150
    78.682   722.984     0.150
    79.746   729.785     0.150
    80.215   734.254     0.150
    80.692   736.215     0.150
    80.794   735.164     0.150
    80.910   734.973     0.150
    81.274   738.879     0.150
    81.364   738.250     0.150
    82.648   743.996     0.150
    83.023   746.379     0.150
    83.618   749.957     0.150
    84.563   755.539     0.150
    84.629   754.949     0.150
    87.391   769.395     0.150
    76.258   711.312     0.150
    29.793   370.730     0.150
     4.102    68.688     0.150
     5.850    92.285     0.150
    18.300   254.188     0.150
    21.612   290.688     0.150
    21.906   293.387     0.150
    23.233   307.988     0.150
    23.254   309.387     0.150
    23.292   312.188     0.150
    23.454   309.887     0.150
    25.282   328.887     0.150
    27.315   346.688     0.150
    27.731   349.887     0.150
    28.340   356.688     0.150
    29.606   369.691     0.150
    29.793   370.688     0.150
    29.990   370.785     0.150
    29.641   367.188     0.150
    31.143   380.785     0.150
    32.910   393.988     0.150
    33.235   401.273     0.150
    33.431   401.492     0.150
    33.893   404.785     0.150
    34.024   406.484     0.150
    33.807   404.488     0.150
    34.152   409.168     0.150
    34.561   413.078     0.150
    34.740   414.617     0.150
    34.932   416.336     0.150
    34.889   415.086     0.150
    34.976   416.723     0.150
    35.003   416.887     0.150
    35.022   416.312     0.150
    35.098   417.301     0.150
    35.218   419.055     0.150
    35.282   419.008     0.150
    35.393   420.160     0.150
    35.633   418.887     0.150
    35.892   421.785     0.150
    35.870   423.504     0.150
    36.073   425.273     0.150
    36.083   425.070     0.150
    36.387   428.504     0.150
    36.697   427.887     0.150
    36.926   433.031     0.150
    37.431   434.188     0.150
    37.385   436.090     0.150
    37.408   435.695     0.150
    37.483   438.215     0.150
    37.607   438.801     0.150
    37.677   437.992     0.150
    37.829   440.668     0.150
    38.406   445.418     0.150
    38.471   446.070     0.150
    38.491   446.383     0.150
    38.531   446.277     0.150
    38.823   446.457     0.150
    38.823     5.820     0.150
    38.521   445.488     0.150
    39.010   446.387     0.150
    39.233   451.387     0.150
    39.672   456.102     0.150
    41.241   468.570     0.150
    43.436   486.488     0.150
    43.841   488.285     0.150
    44.323   491.398     0.150
    44.323   492.223     0.150
    44.323     8.102     0.150
    44.323     8.289     0.150
    45.457   500.137     0.150
    45.534   499.688     0.150
    45.539   501.688     0.150
    46.314   505.688     0.150
    46.869   511.637     0.150
    46.690   512.188     0.150
    47.373   517.285     0.150
    47.483   514.488     0.150
    50.269   537.785     0.150
    53.398   560.938     0.150
    53.398   561.785     0.150
    53.427   561.988     0.150
    53.824   563.586     0.150
    54.039   566.387     0.150
    54.689   571.285     0.150
    60.286   609.586     0.150
    61.964   619.988     0.150
    81.274   737.988     0.150
    83.007   745.988     0.150
    84.353   754.488     0.150
    94.548   799.785     0.150
     3.836    67.285     0.150
     4.102    68.566     0.150
     4.417    74.047     0.150
     4.810    79.496     0.150
     5.314    86.066     0.150
     5.505    88.797     0.150
     6.727   104.059     0.150
     7.187   110.816     0.150
     7.396   113.625     0.150
     8.349   125.465     0.150
     8.748   130.918     0.150
     8.926   133.527     0.150
     8.951   133.938     0.150
     9.799   145.207     0.150
    10.946   159.637     0.150
    14.745   209.887     0.150
    14.871   211.535     0.150
    16.538   234.098     0.150
    16.538   233.965     0.150
    16.968   237.445     0.150
    18.300   254.926     0.150
    20.230   277.238     0.150
    20.621   280.816     0.150
    20.978   287.496     0.150
    21.612   290.688     0.150
    21.612   291.348     0.150
    23.233   309.758     0.150
    23.288   310.367     0.150
    23.454   312.188     0.150
    24.633   321.977     0.150
    26.859   343.375     0.150
    26.859   342.977     0.150
    27.153   346.625     0.150
    28.684   359.168     0.150
    29.551   367.605     0.150
    29.793   369.945     0.150
    29.860   369.117     0.150
    29.860   369.258     0.150
    30.796   376.855     0.150
    31.143   380.266     0.150
    33.893   404.387     0.150
    34.442   410.176     0.150
    39.010   447.465     0.150
    40.425   459.875     0.150
    41.287   465.375     0.150
    42.351   474.988     0.150
    43.370   485.398     0.150
    43.994   488.777     0.150
    44.687   495.676     0.150
    45.344   501.559     0.150
    45.534   500.785     0.150
    45.668   504.266     0.150
    46.163   506.965     0.150
    46.314   506.605     0.150
    47.207   515.598     0.150
    47.373   516.027     0.150
    47.486   517.875     0.150
    47.483   515.266     0.150
    49.542   532.766     0.150
    50.181   537.867     0.150
    53.427   560.996     0.150
    53.824   564.246     0.150
    57.492   591.516     0.150
    58.411   597.848     0.150
    60.384   612.137     0.150
    60.755   613.207     0.150
    62.647   626.375     0.150
    64.078   636.566     0.150
    64.044   635.906     0.150
    64.328   638.098     0.150
    70.363   676.438     0.150
    72.508   688.266     0.150
    72.584   688.047     0.150
    72.932   690.316     0.150
    73.654   696.047     0.150
    74.380   699.297     0.150
    74.999   702.465     0.150
    76.224   709.766     0.150
    76.412   712.777     0.150
    76.545   712.027     0.150
    76.529   710.707     0.150
    80.910   734.426     0.150
    81.274   738.316     0.150
    90.022   781.727     0.150
    96.156   809.148     0.150
     4.102    64.664     0.150
     2.883    47.223     0.150
     1.390    46.172     0.150
     3.819    65.609     0.150
     4.129    67.812     0.150
     4.384    71.461     0.150
     4.806    78.055     0.150
     5.321    85.734     0.150
     5.499    88.586     0.150
     5.884    93.336     0.150
     6.731   103.336     0.150
     6.800   104.016     0.150
     7.112   108.461     0.150
     7.164   110.250     0.150
     7.369   112.773     0.150
     7.628   115.352     0.150
     8.358   125.062     0.150
     8.400   126.273     0.150
    10.912   159.859     0.150
    14.715   208.820     0.150
    16.574   233.180     0.150
    16.574   234.094     0.150
    16.955   240.523     0.150
    18.308   256.375     0.150
    21.041   286.812     0.150
    21.592   290.891     0.150
    21.592   291.125     0.150
    23.260   309.953     0.150
    28.540   358.641     0.150
    35.527   420.570     0.150
    36.760   428.656     0.150
    38.866   446.836     0.150
     3.556    57.609     0.150
     4.168    69.502     0.150
     4.168    67.811     0.150
     5.912    93.311     0.150
     7.759   118.352     0.150
     8.495   128.072     0.150
     8.495   127.912     0.150
    14.821   210.471     0.150
    14.947   213.711     0.150
    17.048   242.111     0.150
    18.376   256.711     0.150
    19.284   268.111     0.150
    19.415   268.012     0.150
    21.291   292.572     0.150
    21.691   292.412     0.150
    21.754   297.572     0.150
    21.985   295.512     0.150
    22.350   301.611     0.150
    23.275   310.912     0.150
    23.299   309.811     0.150
    23.475   314.326     0.150
    23.475   314.172     0.150
    23.475   313.311     0.150
    25.356   330.211     0.150
    26.053   338.721     0.150
    27.792   351.912     0.150
    28.409   357.711     0.150
    28.591   357.861     0.150
    29.629   369.801     0.150
    29.629   368.811     0.150
    29.633   368.641     0.150
    29.610   369.576     0.150
    29.847   369.512     0.150
    29.800   370.512     0.150
    30.053   372.711     0.150
    32.528   394.102     0.150
    32.968   397.211     0.150
    33.713   405.541     0.150
    33.872   405.811     0.150
    33.926   404.912     0.150
    33.926   404.822     0.150
    34.929   413.922     0.150
    34.954   416.391     0.150
    34.954   416.582     0.150
    35.007   416.980     0.150
    35.010   416.691     0.150
    35.487   421.406     0.150
    35.487   421.541     0.150
    35.540   421.010     0.150
    35.971   423.111     0.150
    36.159   428.721     0.150
    36.408   428.502     0.150
    36.408   428.221     0.150
    37.017   432.471     0.150
    37.407   437.006     0.150
    37.497   437.922     0.150
    37.768   440.162     0.150
    37.768   439.871     0.150
    37.846   440.721     0.150
    38.170   443.383     0.150
    38.426   445.861     0.150
    38.485   446.111     0.150
    38.494   446.082     0.150
    38.548   446.387     0.150
    38.876   446.791     0.150
    39.303   452.012     0.150
    39.468   454.842     0.150
    40.967   465.541     0.150
    41.271   468.797     0.150
    41.382   469.422     0.150
    41.443   469.932     0.150
    41.592   471.492     0.150
    41.639   471.900     0.150
    41.767   472.572     0.150
    42.126   474.717     0.150
    42.409   477.549     0.150
    42.666   479.389     0.150
    43.048   481.754     0.150
    43.334   485.127     0.150
    43.486   485.838     0.150
    44.371   491.586     0.150
    46.445   509.211     0.150
    53.874   565.811     0.150
    76.303   710.012     0.150
    81.244   737.811     0.150
    83.085   746.512     0.150
   116.288  1125.760     0.150
   118.763  1129.205     0.150
   119.412  1130.271     0.150
     1.292    43.572     0.150
     3.915    67.572     0.150
     4.168    68.971     0.150
     4.168   120.492     0.150
     4.492    75.400     0.150
     5.912    92.172     0.150
     8.425   125.492     0.150
     8.495   127.281     0.150
     8.827   131.262     0.150
    14.947   212.871     0.150
    17.048   240.742     0.150
    18.376   255.992     0.150
    20.996   286.332     0.150
    21.291   288.752     0.150
    23.301   311.021     0.150
    23.299   310.781     0.150
    23.475   310.791     0.150
    24.585   320.201     0.150
    28.591   357.512     0.150
    33.008   397.912     0.150
    33.926   404.121     0.150
    34.929   413.492     0.150
    35.487   419.822     0.150
    36.112   424.252     0.150
    38.083   440.182     0.150
    41.249   466.412     0.150
    43.381   484.762     0.150
    44.077   489.951     0.150
    44.784   496.762     0.150
    44.863   496.291     0.150
    45.239   500.592     0.150
    45.315   500.932     0.150
    46.968   512.621     0.150
    47.261   515.201     0.150
    48.384   523.512     0.150
    53.443   561.531     0.150
    54.664   570.752     0.150
    58.428   597.602     0.150
    62.712   627.492     0.150
    71.243   680.451     0.150
    71.557   682.131     0.150
    71.974   684.602     0.150
    71.975   684.391     0.150
    72.757   689.631     0.150
    73.012   691.291     0.150
    73.176   691.650     0.150
    75.405   705.092     0.150
    75.479   705.541     0.150
    75.662   707.230     0.150
    75.751   706.791     0.150
    75.870   708.182     0.150
    76.214   709.131     0.150
    76.264   709.492     0.150
    76.511   710.291     0.150
    77.771   718.422     0.150
    77.929   718.992     0.150
    77.954   718.832     0.150
    78.486   722.162     0.150
    78.685   723.021     0.150
    78.762   723.471     0.150
    78.805   723.412     0.150
    79.032   725.041     0.150
    79.667   729.422     0.150
    79.910   729.492     0.150
    80.989   735.631     0.150
    82.087   742.951     0.150
    83.577   749.471     0.150
     4.341   118.400     0.150
     1.300    44.359     0.150
     4.173    69.355     0.150
     5.918    92.754     0.150
     7.748   117.254     0.150
     8.495   127.957     0.150
     8.495   221.355     0.150
    10.660   156.156     0.150
    10.676   155.656     0.150
    10.753   157.457     0.150
    11.018   160.355     0.150
    14.819   210.055     0.150
    14.819   210.461     0.150
    14.819   210.355     0.150
    14.945   211.719     0.150
    14.945   211.855     0.150
    15.299   215.395     0.150
    15.862   224.164     0.150
    17.048   240.957     0.150
    17.048   236.652     0.150
    18.212   254.441     0.150
    18.378   256.855     0.150
    18.378   255.461     0.150
    19.412   268.156     0.150
    19.293   268.055     0.150
    19.839   270.555     0.150
    21.300   291.156     0.150
    21.300   292.219     0.150
    21.690   291.434     0.150
    21.690   291.457     0.150
    21.985   295.055     0.150
    21.972   298.336     0.150
    22.359   301.855     0.150
    22.736   304.355     0.150
    22.990   309.535     0.150
    23.304   309.156     0.150
    23.283   309.656     0.150
    23.319   312.656     0.150
    23.456   313.637     0.150
    23.483   312.270     0.150
    23.483   312.457     0.150
    23.483   312.023     0.150
    24.592   321.910     0.150
    25.491   333.344     0.150
    26.184   339.598     0.150
    27.663   351.367     0.150
    27.798   350.656     0.150
    27.850   354.836     0.150
    27.814   353.344     0.150
    28.404   357.754     0.150
    28.582   357.926     0.150
    28.582   358.297     0.150
    28.670   359.848     0.150
    28.847   361.387     0.150
    28.775   360.602     0.150
    29.104   364.156     0.150
    29.304   365.684     0.150
    29.620   366.754     0.150
    29.620   367.160     0.150
    29.620   367.055     0.150
    29.572   368.055     0.150
    29.619   369.145     0.150
    29.698   369.055     0.150
    29.838   369.555     0.150
    29.869   369.465     0.150
    29.729   370.375     0.150
    29.741   369.684     0.150
    29.808   370.457     0.150
    30.048   371.754     0.150
    30.048   372.055     0.150
    30.393   375.996     0.150
    30.454   376.430     0.150
    30.454   376.207     0.150
    30.569   376.027     0.150
    30.565   376.680     0.150
    31.196   381.254     0.150
    31.196   380.957     0.150
    31.899   388.891     0.150
    32.519   393.898     0.150
    32.883   396.801     0.150
    32.974   395.754     0.150
    33.340   399.707     0.150
    33.460   401.895     0.150
    33.566   402.945     0.150
    33.867   405.355     0.150
    33.710   404.074     0.150
    33.722   404.566     0.150
    33.811   405.746     0.150
    33.934   404.957     0.150
    33.934   405.047     0.150
    33.934   405.332     0.150
    34.017   407.270     0.150
    34.020   406.949     0.150
    34.060   406.574     0.150
    34.063   406.793     0.150
    34.238   408.715     0.150
    34.140   408.543     0.150
    34.183   408.887     0.150
    34.206   408.461     0.150
    34.411   410.055     0.150
    34.238   410.590     0.150
    34.238   410.484     0.150
    34.439   410.844     0.150
    34.485   411.398     0.150
    34.484   410.434     0.150
    34.525   410.906     0.150
    34.575   412.039     0.150
    34.670   413.707     0.150
    34.728   413.980     0.150
    34.762   413.227     0.150
    34.764   413.945     0.150
    34.920   413.707     0.150
    34.785   414.473     0.150
    34.910   414.180     0.150
    34.962   415.957     0.150
    34.962   415.613     0.150
    35.007   416.086     0.150
    35.016   416.566     0.150
    35.018   416.625     0.150
    35.054   415.848     0.150
    35.073   416.605     0.150
    35.104   416.234     0.150
    35.121   417.117     0.150
    35.154   416.566     0.150
    35.219   417.961     0.150
    35.247   418.613     0.150
    35.257   418.645     0.150
    35.404   418.469     0.150
    35.417   419.895     0.150
    35.423   419.664     0.150
    35.416   418.844     0.150
    35.461   419.902     0.150
    35.472   419.902     0.150
    35.495   420.957     0.150
    35.495   421.266     0.150
    35.681   419.855     0.150
    35.817   423.238     0.150
    35.972   422.555     0.150
    36.030   423.844     0.150
    35.902   423.535     0.150
    35.980   424.746     0.150
    36.001   424.906     0.150
    36.000   424.426     0.150
    36.240   426.582     0.150
    36.111   425.816     0.150
    36.263   425.605     0.150
    36.261   426.324     0.150
    36.416   428.242     0.150
    36.416   428.074     0.150
    36.431   427.836     0.150
    36.431   427.430     0.150
    36.431   427.566     0.150
    36.702   428.391     0.150
    36.684   429.375     0.150
    36.598   428.184     0.150
    36.641   429.910     0.150
    36.758   429.254     0.150
    36.787   431.578     0.150
    36.954   432.766     0.150
    37.016   433.234     0.150
    37.028   433.723     0.150
    37.025   432.754     0.150
    37.025   433.008     0.150
    37.164   434.957     0.150
    37.164   434.676     0.150
    37.415   436.344     0.150
    37.437   435.879     0.150
    37.486   434.957     0.150
    37.493   437.297     0.150
    37.506   437.734     0.150
    37.637   438.656     0.150
    37.706   438.145     0.150
    37.725   438.457     0.150
    37.776   439.855     0.150
    37.776   439.754     0.150
    37.974   439.305     0.150
    37.854   439.680     0.150
    37.924   440.656     0.150
    37.924   440.434     0.150
    37.937   440.555     0.150
    37.937   440.355     0.150
    37.937   440.824     0.150
    37.971   439.676     0.150
    38.090   440.727     0.150
    38.157   442.434     0.150
    38.179   443.254     0.150
    38.224   441.254     0.150
    38.224   441.406     0.150
    38.342   444.945     0.150
    38.342   446.055     0.150
    38.342   444.457     0.150
    38.580   445.836     0.150
    38.415   445.062     0.150
    38.435   445.395     0.150
    38.493   445.637     0.150
    38.502   446.113     0.150
    38.520   445.945     0.150
    38.520   445.656     0.150
    38.529   444.074     0.150
    38.556   446.113     0.150
    38.813   447.066     0.150
    38.812   448.156     0.150
    38.812   448.055     0.150
    38.881   449.957     0.150
    39.017   448.227     0.150
    39.079   448.555     0.150
    39.079   448.023     0.150
    38.963   451.680     0.150
    39.299   451.754     0.150
    39.145   452.055     0.150
    39.145   451.094     0.150
    39.145   451.855     0.150
    39.208   449.664     0.150
    39.256   451.844     0.150
    39.320   454.254     0.150
    39.320   453.656     0.150
    39.343   451.574     0.150
    39.495   451.504     0.150
    39.452   454.754     0.150
    39.452   454.254     0.150
    39.476   454.727     0.150
    39.500   451.566     0.150
    39.731   453.637     0.150
    39.847   455.766     0.150
    39.847   455.406     0.150
    39.706   455.555     0.150
    39.706   455.406     0.150
    39.706   455.754     0.150
    39.840   455.785     0.150
    39.826   456.555     0.150
    39.843   457.125     0.150
    40.202   459.707     0.150
    40.298   460.855     0.150
    40.298   461.156     0.150
    40.298   460.426     0.150
    40.482   459.797     0.150
    40.424   459.457     0.150
    40.448   460.605     0.150
    40.448   460.824     0.150
    40.592   462.457     0.150
    40.592   462.355     0.150
    40.592   462.715     0.150
    40.696   461.406     0.150
    40.774   464.055     0.150
    40.774   464.254     0.150
    40.894   465.074     0.150
    40.976   465.355     0.150
    40.976   465.656     0.150
    41.081   466.855     0.150
    41.089   467.184     0.150
    41.143   465.664     0.150
    41.081   466.727     0.150
    41.242   465.422     0.150
    41.190   468.254     0.150
    41.190   468.465     0.150
    41.279   468.156     0.150
    41.279   468.426     0.150
    41.279   571.496     0.150
    41.372   467.434     0.150
    41.313   468.656     0.150
    41.313   468.457     0.150
    41.389   469.406     0.150
    41.390   469.027     0.150
    41.445   471.055     0.150
    41.445   470.156     0.150
    41.451   469.805     0.150
    41.445   469.836     0.150
    41.518   470.586     0.150
    41.577   470.805     0.150
    41.600   471.336     0.150
    41.633   470.387     0.150
    41.647   471.805     0.150
    41.715   472.254     0.150
    41.715   472.141     0.150
    41.715   472.035     0.150
    41.775   472.387     0.150
    41.871   473.855     0.150
    41.871   473.254     0.150
    41.871   473.504     0.150
    41.897   473.355     0.150
    41.897   473.516     0.150
    41.927   473.977     0.150
    41.960   473.855     0.150
    41.960   473.754     0.150
    42.029   474.254     0.150
    42.029   570.848     0.150
    42.073   475.117     0.150
    42.098   474.695     0.150
    42.135   475.055     0.150
    42.135   570.938     0.150
    42.237   476.434     0.150
    42.235   476.055     0.150
    42.272   476.566     0.150
    42.268   476.570     0.150
    42.420   475.852     0.150
    42.417   477.457     0.150
    42.417   574.012     0.150
    42.464   480.754     0.150
    42.471   478.055     0.150
    42.621   479.055     0.150
    42.621   479.324     0.150
    42.602   478.246     0.150
    42.674   479.711     0.150
    42.674   577.039     0.150
    42.682   479.855     0.150
    42.682   479.625     0.150
    42.787   478.734     0.150
    42.751   480.387     0.150
    42.751   480.191     0.150
    42.751   578.082     0.150
    42.833   481.254     0.150
    43.056   483.129     0.150
    43.139   481.215     0.150
    43.194   483.785     0.150
    43.220   483.957     0.150
    43.220   484.207     0.150
    43.342   485.531     0.150
    43.339   485.625     0.150
    43.403   485.754     0.150
    43.403   485.934     0.150
    43.390   485.707     0.150
    43.456   484.844     0.150
    43.463   486.285     0.150
    43.494   486.074     0.150
    43.587   486.926     0.150
    43.689   487.016     0.150
    43.803   488.574     0.150
    43.811   488.645     0.150
    43.878   489.156     0.150
    43.917   489.746     0.150
    43.928   489.199     0.150
    44.004   488.086     0.150
    44.024   490.195     0.150
    44.015   490.531     0.150
    44.086   491.074     0.150
    44.085   491.066     0.150
    44.111   491.426     0.150
    44.174   491.004     0.150
    44.177   491.797     0.150
    44.543   494.605     0.150
    44.728   495.633     0.150
    44.721   496.785     0.150
    44.746   495.953     0.150
    44.746   497.176     0.150
    44.599   494.770     0.150
    44.599   595.738     0.150
    44.775   497.547     0.150
    44.697   495.527     0.150
    44.752   496.801     0.150
    44.777   495.719     0.150
    44.871   496.906     0.150
    44.947   497.504     0.150
    45.137   499.949     0.150
    45.024   499.027     0.150
    45.071   498.797     0.150
    45.231   501.309     0.150
    45.119   499.934     0.150
    45.119   499.625     0.150
    45.121   499.934     0.150
    45.124   499.406     0.150
    45.307   502.578     0.150
    45.203   499.734     0.150
    45.226   500.176     0.150
    45.236   500.414     0.150
    45.236   500.137     0.150
    45.248   499.406     0.150
    45.249   499.645     0.150
    45.250   500.727     0.150
    45.294   501.254     0.150
    45.313   501.547     0.150
    45.319   500.211     0.150
    45.343   500.906     0.150
    45.352   500.082     0.150
    45.538   501.945     0.150
    45.345   500.867     0.150
    45.382   502.234     0.150
    45.382   502.035     0.150
    45.382   501.910     0.150
    45.382   502.066     0.150
    45.578   501.785     0.150
    45.423   501.746     0.150
    45.607   500.656     0.150
    45.470   502.047     0.150
    45.709   503.270     0.150
    45.601   502.195     0.150
    45.613   502.109     0.150
    45.670   502.551     0.150
    45.777   504.176     0.150
    45.797   504.375     0.150
    45.829   504.707     0.150
    45.904   504.574     0.150
    45.885   504.484     0.150
    45.885   504.070     0.150
    45.962   505.082     0.150
    45.962   601.195     0.150
    46.179   506.789     0.150
    46.179   506.305     0.150
    46.066   506.574     0.150
    46.060   506.805     0.150
    46.086   506.504     0.150
    46.139   507.617     0.150
    46.284   508.605     0.150
    46.440   508.855     0.150
    46.303   508.176     0.150
    46.329   508.305     0.150
    46.368   507.855     0.150
    46.368   507.457     0.150
    46.380   508.824     0.150
    46.443   509.117     0.150
    46.458   510.074     0.150
    46.463   509.965     0.150
    46.504   509.656     0.150
    46.504   509.496     0.150
    46.530   510.387     0.150
    46.522   510.367     0.150
    46.740   512.855     0.150
    46.617   511.207     0.150
    46.617   510.844     0.150
    46.637   510.867     0.150
    46.718   512.125     0.150
    46.763   512.477     0.150
    46.765   511.785     0.150
    46.786   512.645     0.150
    46.786   512.367     0.150
    46.806   512.207     0.150
    47.009   514.555     0.150
    46.920   513.207     0.150
    46.940   513.754     0.150
    46.976   513.047     0.150
    47.057   514.664     0.150
    47.091   515.164     0.150
    47.122   514.977     0.150
    47.122   515.277     0.150
    47.143   514.605     0.150
    47.434   517.156     0.150
    47.269   514.785     0.150
    47.304   516.695     0.150
    47.383   516.676     0.150
    47.375   516.254     0.150
    47.375   515.977     0.150
    47.399   517.664     0.150
    47.409   516.895     0.150
    47.409   516.656     0.150
    47.409   516.445     0.150
    47.561   515.953     0.150
    47.561   516.355     0.150
    47.452   517.457     0.150
    47.423   518.324     0.150
    47.423   518.445     0.150
    47.483   517.445     0.150
    47.697   519.168     0.150
    47.697   518.996     0.150
    47.539   519.137     0.150
    47.546   517.625     0.150
    47.662   518.477     0.150
    47.686   519.016     0.150
    47.736   520.094     0.150
    47.732   519.285     0.150
    47.754   519.566     0.150
    47.911   521.926     0.150
    47.769   520.344     0.150
    47.807   520.566     0.150
    47.805   519.734     0.150
    47.880   520.215     0.150
    47.886   520.266     0.150
    47.916   520.707     0.150
    47.964   521.785     0.150
    47.964   521.547     0.150
    47.914   521.832     0.150
    47.970   521.184     0.150
    47.998   521.527     0.150
    48.200   522.742     0.150
    48.200   522.625     0.150
    48.200   522.965     0.150
    48.259   524.477     0.150
    48.274   523.055     0.150
    48.274   523.426     0.150
    48.632   526.645     0.150
    48.632   526.414     0.150
    48.645   526.707     0.150
    48.659   527.504     0.150
    48.659   527.266     0.150
    48.663   526.477     0.150
    48.654   526.797     0.150
    48.848   527.625     0.150
    48.814   527.824     0.150
    48.971   528.785     0.150
    49.217   530.234     0.150
    49.067   530.074     0.150
    49.186   530.867     0.150
    49.282   530.367     0.150
    49.273   530.285     0.150
    49.521   532.328     0.150
    49.521   531.844     0.150
    49.529   534.180     0.150
    49.529   534.047     0.150
    49.511   533.352     0.150
    49.514   533.676     0.150
    49.640   533.305     0.150
    50.153   538.551     0.150
    50.125   537.895     0.150
    50.343   538.414     0.150
    50.343   538.957     0.150
    50.343   538.574     0.150
    50.334   539.707     0.150
    50.492   540.676     0.150
    50.492   540.797     0.150
    50.680   542.805     0.150
    50.554   540.445     0.150
    51.471   548.465     0.150
    51.471   548.234     0.150
    51.256   546.457     0.150
    51.610   548.434     0.150
    51.664   548.555     0.150
    51.768   550.340     0.150
    51.768   550.207     0.150
    52.031   551.676     0.150
    52.329   554.016     0.150
    52.571   556.477     0.150
    52.851   557.207     0.150
    53.370   561.453     0.150
    53.427   561.434     0.150
    53.292   560.855     0.150
    53.367   560.844     0.150
    53.538   562.605     0.150
    53.377   561.555     0.150
    53.475   561.465     0.150
    53.475   561.617     0.150
    53.868   564.910     0.150
    54.097   566.957     0.150
    54.097   566.293     0.150
    54.097   566.465     0.150
    54.445   568.996     0.150
    54.637   570.457     0.150
    54.450   570.457     0.150
    54.546   569.715     0.150
    54.740   570.992     0.150
    54.743   571.355     0.150
    54.693   571.297     0.150
    55.002   573.535     0.150
    55.354   577.336     0.150
    55.512   576.164     0.150
    55.757   578.449     0.150
    55.715   577.984     0.150
    55.964   579.250     0.150
    55.964   579.055     0.150
    56.078   581.707     0.150
    55.942   579.984     0.150
    56.082   580.656     0.150
    56.160   581.504     0.150
    56.421   582.586     0.150
    56.557   585.594     0.150
    56.758   586.336     0.150
    57.324   591.535     0.150
    57.333   590.227     0.150
    57.488   591.652     0.150
    57.864   594.914     0.150
    58.335   597.340     0.150
    58.335   596.805     0.150
    58.436   598.324     0.150
    58.964   601.207     0.150
    59.101   602.777     0.150
    59.396   602.320     0.150
    59.286   604.496     0.150
    59.519   604.547     0.150
    60.071   610.184     0.150
    60.071   609.977     0.150
    60.240   609.746     0.150
    60.363   610.656     0.150
    60.363   610.352     0.150
    60.412   612.785     0.150
    60.723   611.984     0.150
    60.814   614.164     0.150
    60.832   614.254     0.150
    60.832   613.660     0.150
    60.950   614.734     0.150
    61.025   616.152     0.150
    61.397   617.055     0.150
    61.460   619.426     0.150
    61.690   620.590     0.150
    62.581   626.297     0.150
    62.609   627.219     0.150
    62.717   627.215     0.150
    63.157   629.164     0.150
    63.439   633.879     0.150
    64.014   636.879     0.150
    64.059   636.266     0.150
    64.329   637.602     0.150
    65.006   639.000     0.150
    67.136   654.305     0.150
    67.217   654.898     0.150
    67.890   659.547     0.150
    67.890   659.707     0.150
    68.681   665.605     0.150
    68.681   665.496     0.150
    69.378   669.656     0.150
    69.378   669.258     0.150
    69.378   668.684     0.150
    70.270   674.430     0.150
    70.348   674.738     0.150
    70.406   676.797     0.150
    70.677   679.461     0.150
    71.822   683.637     0.150
    71.871   685.605     0.150
    72.381   686.695     0.150
    72.465   688.055     0.150
    72.758   689.141     0.150
    72.847   690.281     0.150
    73.156   693.848     0.150
    73.594   696.281     0.150
    74.007   697.641     0.150
    74.237   698.809     0.150
    68.670   664.625     0.150
    74.455   700.648     0.150
    74.363   699.656     0.150
    74.363   699.465     0.150
    74.729   702.625     0.150
    75.112   703.895     0.150
    75.195   704.738     0.150
    75.405   705.387     0.150
    75.753   706.781     0.150
    75.994   708.332     0.150
    76.304   709.516     0.150
    76.189   710.855     0.150
    76.189   710.727     0.150
    76.350   712.836     0.150
    76.493   711.105     0.150
    76.813   713.824     0.150
    78.072   719.117     0.150
    78.959   723.195     0.150
    78.899   723.773     0.150
    78.951   724.180     0.150
    79.391   726.664     0.150
    79.350   729.078     0.150
    79.697   729.133     0.150
    79.603   729.906     0.150
    80.216   733.047     0.150
    80.176   730.566     0.150
    80.176   730.695     0.150
    80.653   735.020     0.150
    80.745   734.523     0.150
    80.989   735.355     0.150
    80.989   735.238     0.150
    81.236   737.656     0.150
    81.244   737.457     0.150
    81.244   737.766     0.150
    81.244   737.645     0.150
    81.319   738.125     0.150
    81.446   738.281     0.150
    81.511   740.863     0.150
    81.750   740.125     0.150
    82.728   744.270     0.150
    83.018   746.090     0.150
    83.087   746.457     0.150
    83.685   749.852     0.150
    83.956   751.543     0.150
    84.346   754.082     0.150
    84.346   754.555     0.150
    84.585   754.789     0.150
    84.585   755.137     0.150
    84.682   755.352     0.150
    84.623   755.383     0.150
    85.358   758.426     0.150
    87.355   768.383     0.150
    87.355   768.586     0.150
    87.366   768.730     0.150
    87.366   768.965     0.150
    87.684   769.828     0.150
    87.956   771.262     0.150
    88.258   772.637     0.150
    90.002   780.738     0.150
    90.002   781.016     0.150
    90.734   784.695     0.150
    90.734   784.836     0.150
    90.759   784.895     0.150
    90.911   783.992     0.150
    91.737   789.215     0.150
    92.452   792.266     0.150
    92.937   794.777     0.150
    93.136   795.836     0.150
    93.526   797.355     0.150
    93.900   798.227     0.150
    93.945   799.078     0.150
    94.372   801.566     0.150
    94.624   801.855     0.150
    95.121   804.266     0.150
    95.505   807.141     0.150
    95.639   807.121     0.150
    95.789   808.117     0.150
    95.881   807.684     0.150
    96.455   810.539     0.150
    97.148   813.844     0.150
    97.275   815.176     0.150
    97.683   815.781     0.150
    99.676   825.434     0.150
   100.084   827.074     0.150
   101.123   831.523     0.150
   102.007   835.887     0.150
   102.124   837.387     0.150
   113.138  1120.656     0.150
   116.288  1753.133     0.150
   116.288  1125.305     0.150
   117.593  1127.355     0.150
   117.593  1748.031     0.150
   117.593  1127.000     0.150
   118.606  1744.320     0.150
   118.606  1129.285     0.150
   118.763  1743.258     0.150
   118.763  1129.559     0.150
   119.250  1131.766     0.150
   119.413  1741.379     0.150
   119.413  1130.406     0.150
   120.795  1134.516     0.150
   122.505  1135.219     0.150
   124.872  1141.926     0.150
   126.830  1143.996     0.150
   130.711  1155.566     0.150
   142.060  1176.051     0.150
   142.841  1174.504     0.150
   142.882  1174.754     0.150
   142.882  1174.527     0.150
   144.493  1178.605     0.150
   145.985  1183.879     0.150
   146.870  1185.457     0.150
   147.437  1185.629     0.150
   147.729  1186.805     0.150
   148.035  1186.855     0.150
   149.775  1192.754     0.150
   172.519  1213.004     0.150
    38.883   446.984     0.150
    38.883     7.562     0.150
    44.378   491.867     0.150
    44.378     8.324     0.150
    45.513   500.207     0.150
    46.941   512.254     0.150
    49.223   530.430     0.150
     3.915    66.656     0.150
     4.173    68.965     0.150
     4.489    77.316     0.150
     4.890    80.125     0.150
     5.585    89.375     0.150
     5.918    92.586     0.150
     6.807   104.977     0.150
     6.889   105.656     0.150
     7.193   109.445     0.150
     7.264   111.465     0.150
     7.472   114.004     0.150
     7.724   116.906     0.150
     8.428   125.875     0.150
     8.825   132.016     0.150
     9.025   134.184     0.150
     9.871   146.137     0.150
    14.945   211.656     0.150
    15.862   224.645     0.150
    16.604   232.566     0.150
    16.604   232.754     0.150
    20.621   282.027     0.150
    21.004   287.285     0.150
    21.300   291.387     0.150
    21.690   292.195     0.150
    21.690   291.695     0.150
    23.304   308.867     0.150
    23.483   311.637     0.150
    24.592   322.117     0.150
    25.436   331.574     0.150
    26.861   343.965     0.150
    27.161   346.094     0.150
    27.663   350.406     0.150
    27.703   352.617     0.150
    27.814   352.926     0.150
    28.339   357.727     0.150
    28.582   357.746     0.150
    28.670   359.195     0.150
    28.775   361.395     0.150
    28.847   360.957     0.150
    29.104   363.574     0.150
    29.304   365.555     0.150
    29.572   368.184     0.150
    29.838   369.496     0.150
    29.869   369.145     0.150
    29.808   370.465     0.150
    30.048   371.605     0.150
    30.454   376.094     0.150
    30.569   376.504     0.150
    31.196   380.656     0.150
    31.652   387.406     0.150
    33.934   404.914     0.150
    34.062   406.566     0.150
    34.238   410.145     0.150
    34.411   409.535     0.150
    36.240   426.105     0.150
    38.580   444.875     0.150
    39.079   447.855     0.150
    40.134   457.965     0.150
    42.370   476.324     0.150
    42.420   475.527     0.150
    43.878   488.695     0.150
    44.024   488.016     0.150
    44.130   492.156     0.150
    44.445   493.156     0.150
    44.728   495.406     0.150
    44.721   496.484     0.150
    45.345   499.047     0.150
    45.382   501.684     0.150
    45.451   500.887     0.150
    47.224   514.637     0.150
    47.561   515.777     0.150
    47.423   517.844     0.150
    49.282   530.137     0.150
    50.153   537.516     0.150
    50.343   538.137     0.150
    53.475   561.746     0.150
    53.868   564.305     0.150
    54.097   565.734     0.150
    55.757   576.387     0.150
    55.964   578.566     0.150
    57.333   590.004     0.150
    57.316   590.855     0.150
    57.488   590.867     0.150
    57.864   593.934     0.150
    58.110   595.547     0.150
    58.436   597.496     0.150
    59.396   601.957     0.150
    60.071   609.836     0.150
    60.205   609.066     0.150
    60.240   610.027     0.150
    60.412   611.977     0.150
    60.832   613.387     0.150
    62.064   620.785     0.150
    62.581   625.594     0.150
    62.717   626.527     0.150
    64.014   636.305     0.150
    64.059   635.707     0.150
    65.006   639.605     0.150
    71.707   683.207     0.150
    72.465   687.387     0.150
    72.847   689.926     0.150
    73.594   694.996     0.150
    74.363   699.195     0.150
    76.304   708.984     0.150
    76.189   710.156     0.150
    80.176   730.305     0.150
    81.244   737.027     0.150
    81.511   739.227     0.150
    84.346   753.777     0.150
    90.002   780.547     0.150
    95.789   807.797     0.150
   116.125  1124.824     0.150
   117.593  1125.766     0.150
   120.795  1133.215     0.150
   122.202  1133.324     0.150
   122.608  1137.246     0.150
   123.795  1136.254     0.150
   124.872  1140.324     0.150
   130.958  1152.766     0.150
   131.503  1154.504     0.150
   136.882  1166.055     0.150
   142.947  1174.605     0.150
   142.987  1174.504     0.150
   146.397  1183.125     0.150
   146.870  1184.316     0.150
   147.729  1185.434     0.150
   148.931  1185.465     0.150
   149.843  1185.516     0.150
   149.850  1186.285     0.150
   151.111  1189.414     0.150
     3.566    55.934     0.150
     4.177    66.508     0.150
     4.579    72.578     0.150
     4.943    77.500     0.150
    15.030   214.109     0.150
    16.590   233.602     0.150
    16.590   233.828     0.150
    20.929   287.188     0.150
    21.762   292.391     0.150
    21.762   292.617     0.150
    23.306   310.516     0.150
    28.662   358.117     0.150
    33.878   403.930     0.150
    33.878   404.391     0.150
    35.424   419.758     0.150
    36.025   423.508     0.150
    36.054   424.852     0.150
    38.505   443.891     0.150
    38.855   446.758     0.150
    39.074   449.281     0.150
    42.414   475.688     0.150
    42.745   479.320     0.150
    44.802   496.336     0.150
    45.627   501.891     0.150
    47.330   515.539     0.150
    47.632   517.070     0.150
    48.325   523.820     0.150
    49.233   530.312     0.150
    50.354   538.320     0.150
    54.597   569.922     0.150
    55.571   576.742     0.150
    71.616   682.727     0.150
    73.068   692.016     0.150
    73.125   691.938     0.150
    73.244   693.078     0.150
    73.513   694.156     0.150
    74.071   697.516     0.150
    74.058   697.047     0.150
    74.649   701.297     0.150
    74.838   702.219     0.150
    75.410   704.781     0.150
    75.735   707.188     0.150
    76.563   711.406     0.150
    76.670   711.516     0.150
    77.774   718.250     0.150
     4.177    65.695     0.150
     4.373   119.125     0.150
     4.373   119.125     0.150
     4.373   119.125     0.150
     5.791   154.266     0.150
     5.791   154.266     0.150
     5.791   154.266     0.150
     5.791   154.266     0.150
     3.926    71.406     0.150
     4.900    80.062     0.150
     5.401    87.422     0.150
     6.815   105.617     0.150
     6.899   105.297     0.150
     7.202   109.781     0.150
     7.276   111.141     0.150
     7.483   113.812     0.150
     7.735   116.797     0.150
     8.505   126.875     0.150
     9.037   134.344     0.150
     9.883   145.867     0.150
    11.030   160.367     0.150
    14.831   210.617     0.150
    17.058   240.141     0.150
    20.999   285.820     0.150
    21.294   290.156     0.150
    23.309   308.844     0.150
    23.305   310.992     0.150
    23.479   310.820     0.150
    24.580   320.914     0.150
    25.429   329.805     0.150
    26.854   342.586     0.150
    27.153   346.391     0.150
    28.588   357.938     0.150
    29.116   362.852     0.150
    29.876   368.836     0.150
    30.061   371.141     0.150
    30.782   377.750     0.150
    31.196   380.320     0.150
    33.932   404.602     0.150
    34.927   413.852     0.150
    39.702   455.766     0.150
    41.243   466.914     0.150
    42.423   476.195     0.150
    44.020   490.062     0.150
    44.785   497.492     0.150
    46.368   507.812     0.150
    47.234   515.570     0.150
    47.572   516.891     0.150
    49.532   533.883     0.150
    49.515   533.672     0.150
    50.158   540.734     0.150
    50.348   539.047     0.150
    50.306   536.906     0.150
    53.474   562.000     0.150
    53.880   564.617     0.150
    57.479   590.312     0.150
    58.431   598.062     0.150
    60.407   612.492     0.150
    62.721   627.516     0.150
    64.001   636.766     0.150
    66.638   652.422     0.150
    70.359   677.953     0.150
    70.761   679.031     0.150
    71.695   685.125     0.150
    73.581   696.570     0.150
    74.010   698.461     0.150
    75.762   706.953     0.150
    76.494   711.844     0.150
    81.000   734.703     0.150
    81.034   735.625     0.150
    81.249   738.305     0.150
     4.351   118.781     0.150
     4.351   118.797     0.150
     4.351   118.828     0.150
     5.777   153.992     0.150
     5.777   153.992     0.150
     4.351   118.656     0.150
     5.121    78.750     0.150
     4.150    69.440     0.150
     4.864    80.640     0.150
     5.368    86.880     0.150
     5.896    93.074     0.150
     6.781   104.510     0.150
     7.698   117.040     0.150
     7.732   118.330     0.150
     8.469   127.897     0.150
     8.469   224.701     0.150
     8.469   128.050     0.150
     9.735   144.760     0.150
    10.994   160.204     0.150
    14.794   210.040     0.150
    14.794   210.410     0.150
    14.794   209.840     0.150
    14.920   211.709     0.150
    15.302   214.629     0.150
    15.882   231.291     0.150
    17.021   236.734     0.150
    17.021   236.440     0.150
    17.976   252.385     0.150
    18.193   255.433     0.150
    18.353   255.535     0.150
    18.353   254.840     0.150
    19.388   267.540     0.150
    21.296   292.344     0.150
    21.296   292.600     0.150
    21.664   291.351     0.150
    21.664   291.340     0.150
    21.959   294.040     0.150
    21.971   299.260     0.150
    22.352   302.740     0.150
    22.365   303.130     0.150
    22.728   305.140     0.150
    22.984   309.820     0.150
    23.282   309.093     0.150
    23.282   308.640     0.150
    23.275   309.440     0.150
    23.312   312.340     0.150
    23.475   312.138     0.150
    23.475   311.740     0.150
    23.475   312.700     0.150
    24.607   324.220     0.150
    25.329   329.240     0.150
    25.488   333.800     0.150
    26.058   338.820     0.150
    26.182   340.390     0.150
    26.182   339.740     0.150
    27.332   348.240     0.150
    27.573   349.940     0.150
    27.777   350.540     0.150
    27.813   354.240     0.150
    28.382   357.440     0.150
    28.588   358.472     0.150
    28.588   358.760     0.150
    29.081   363.776     0.150
    29.081   363.540     0.150
    29.081   364.050     0.150
    29.626   368.927     0.150
    29.626   368.440     0.150
    29.626   369.680     0.150
    29.616   369.301     0.150
    29.690   368.840     0.150
    29.873   369.682     0.150
    29.873   370.010     0.150
    29.805   370.540     0.150
    30.028   371.840     0.150
    30.028   371.340     0.150
    30.028   370.940     0.150
    30.028   372.100     0.150
    30.390   376.680     0.150
    30.571   378.240     0.150
    31.180   380.540     0.150
    31.180   380.956     0.150
    31.180   381.080     0.150
    32.525   393.710     0.150
    32.875   396.860     0.150
    32.954   395.440     0.150
    33.452   402.005     0.150
    33.714   404.570     0.150
    33.922   405.140     0.150
    33.922   405.318     0.150
    33.922   405.564     0.150
    34.009   407.348     0.150
    34.050   406.577     0.150
    34.058   407.990     0.150
    34.174   408.845     0.150
    34.257   412.490     0.150
    34.578   412.478     0.150
    34.753   413.630     0.150
    34.954   416.540     0.150
    34.954   415.898     0.150
    34.954   415.540     0.150
    34.998   416.540     0.150
    35.008   417.181     0.150
    35.010   416.660     0.150
    35.045   416.326     0.150
    35.066   416.753     0.150
    35.145   416.584     0.150
    35.178   417.395     0.150
    35.239   417.795     0.150
    35.298   419.105     0.150
    35.373   419.960     0.150
    35.394   418.891     0.150
    35.415   420.174     0.150
    35.487   421.440     0.150
    35.487   421.670     0.150
    35.487   421.240     0.150
    35.543   421.029     0.150
    35.667   419.640     0.150
    35.946   422.440     0.150
    35.892   424.021     0.150
    35.972   425.304     0.150
    35.992   424.449     0.150
    36.097   425.090     0.150
    36.408   428.296     0.150
    36.706   430.397     0.150
    36.599   430.434     0.150
    36.739   428.440     0.150
    36.946   433.212     0.150
    37.017   433.140     0.150
    37.017   433.426     0.150
    37.019   433.640     0.150
    37.155   435.140     0.150
    37.155   435.407     0.150
    37.407   436.205     0.150
    37.429   436.205     0.150
    37.470   434.740     0.150
    37.484   437.915     0.150
    37.629   438.840     0.150
    37.629   439.197     0.150
    37.698   437.915     0.150
    37.717   439.140     0.150
    37.717   438.719     0.150
    37.767   439.840     0.150
    37.767   440.266     0.150
    37.847   440.480     0.150
    37.913   440.540     0.150
    37.927   440.840     0.150
    37.927   440.640     0.150
    38.033   442.831     0.150
    38.171   443.259     0.150
    38.196   443.259     0.150
    38.210   441.340     0.150
    38.333   445.540     0.150
    38.333   444.540     0.150
    38.427   445.396     0.150
    38.560   445.869     0.150
    38.560   445.440     0.150
    38.486   445.610     0.150
    38.494   446.251     0.150
    38.512   446.040     0.150
    38.512   446.251     0.150
    38.549   446.465     0.150
    38.802   448.240     0.150
    38.802   448.140     0.150
    38.864   446.830     0.150
    38.873   450.740     0.150
    39.057   448.710     0.150
    39.057   448.040     0.150
    39.136   452.440     0.150
    39.136   451.740     0.150
    39.277   451.440     0.150
    39.443   455.240     0.150
    39.443   454.140     0.150
    39.696   455.940     0.150
    39.696   456.297     0.150
    39.696   455.740     0.150
    39.829   455.500     0.150
    40.288   461.840     0.150
    40.288   460.740     0.150
    40.584   462.940     0.150
    40.584   462.642     0.150
    40.584   462.540     0.150
    40.764   464.740     0.150
    40.764   464.440     0.150
    40.967   465.740     0.150
    41.072   467.240     0.150
    41.072   466.540     0.150
    41.255   466.501     0.150
    41.180   469.040     0.150
    41.180   467.921     0.150
    41.269   468.540     0.150
    41.269   468.437     0.150
    41.269   468.177     0.150
    41.303   469.140     0.150
    41.707   472.840     0.150
    41.707   472.543     0.150
    41.886   473.740     0.150
    41.886   473.384     0.150
    41.950   473.940     0.150
    41.950   473.640     0.150
    42.019   474.640     0.150
    42.019   474.128     0.150
    42.125   475.440     0.150
    42.226   476.240     0.150
    42.226   476.040     0.150
    42.398   476.410     0.150
    42.408   477.840     0.150
    42.462   478.440     0.150
    42.597   479.254     0.150
    42.610   479.440     0.150
    42.672   480.640     0.150
    42.825   481.440     0.150
    43.209   484.340     0.150
    43.479   486.040     0.150
    43.394   486.140     0.150
    43.867   488.940     0.150
    44.361   491.652     0.150
    44.716   497.100     0.150
    44.713   495.982     0.150
    44.739   496.897     0.150
    44.769   497.336     0.150
    44.746   496.810     0.150
    45.130   499.709     0.150
    45.225   501.360     0.150
    45.301   502.470     0.150
    45.371   501.978     0.150
    45.519   502.129     0.150
    45.563   501.812     0.150
    45.583   500.040     0.150
    45.694   503.430     0.150
    46.172   507.629     0.150
    46.420   508.440     0.150
    46.352   507.140     0.150
    46.722   512.540     0.150
    47.416   516.740     0.150
    47.399   516.926     0.150
    47.399   517.440     0.150
    47.445   519.060     0.150
    47.535   516.435     0.150
    47.535   515.540     0.150
    47.936   522.760     0.150
    48.189   523.290     0.150
    49.511   532.599     0.150
    49.520   533.486     0.150
    50.161   539.150     0.150
    50.319   538.650     0.150
    50.319   538.140     0.150
    50.483   540.636     0.150
    50.684   544.610     0.150
    51.457   549.230     0.150
    53.356   560.762     0.150
    53.460   561.785     0.150
    53.460   562.440     0.150
    53.852   564.135     0.150
    53.852   563.440     0.150
    54.077   566.040     0.150
    54.077   566.547     0.150
    54.619   570.957     0.150
    55.739   581.007     0.150
    56.057   580.140     0.150
    56.398   583.210     0.150
    57.491   592.440     0.150
    57.889   597.342     0.150
    58.430   598.710     0.150
    60.338   610.340     0.150
    60.338   610.554     0.150
    60.808   614.160     0.150
    61.018   616.910     0.150
    61.684   621.310     0.150
    62.584   627.163     0.150
    64.036   637.660     0.150
    67.225   656.762     0.150
    68.684   666.060     0.150
    69.356   669.685     0.150
    72.731   689.044     0.150
    73.704   696.810     0.150
    73.615   697.185     0.150
    74.017   698.215     0.150
    74.463   701.165     0.150
    75.118   704.690     0.150
    75.379   705.788     0.150
    75.726   706.820     0.150
    76.009   711.439     0.150
    76.277   709.344     0.150
    76.277   709.040     0.150
    76.371   714.485     0.150
    76.820   713.715     0.150
    78.967   724.815     0.150
    79.374   732.305     0.150
    79.712   729.743     0.150
    80.963   735.810     0.150
    81.253   738.110     0.150
    81.332   738.165     0.150
    81.724   740.788     0.150
    82.702   744.700     0.150
    82.993   745.896     0.150
    83.061   746.740     0.150
    83.664   750.371     0.150
    84.598   755.606     0.150
    84.605   756.015     0.150
    84.656   755.828     0.150
    87.365   769.040     0.150
    90.007   781.085     0.150
    90.743   786.265     0.150
    94.600   801.340     0.150
    95.855   808.633     0.150
    97.658   817.215     0.150
   113.164  1121.040     0.150
   116.314  1752.989     0.150
   116.314  1125.657     0.150
   117.619  1748.228     0.150
   117.619  1127.258     0.150
   118.632  1743.110     0.150
   118.632  1129.540     0.150
   118.789  1130.065     0.150
   119.439  1741.929     0.150
   119.439  1130.902     0.150
   130.691  1155.010     0.150
   145.990  1184.215     0.150
   146.876  1188.340     0.150
   147.445  1187.665     0.150
   148.045  1188.440     0.150
   149.794  1193.040     0.150
    76.212   711.390     0.150
    29.805   370.397     0.150
   138.912  1170.965     0.150
   148.946  1189.840     0.150
     1.310    45.790     0.150
     3.889    67.530     0.150
     4.864    80.310     0.150
     9.847   144.450     0.150
    20.623   280.170     0.150
    20.890   284.030     0.150
    20.997   286.500     0.150
    21.048   286.470     0.150
    21.296   291.920     0.150
    23.282   309.290     0.150
    23.304   311.470     0.150
    23.475   311.510     0.150
    24.530   324.170     0.150
    27.160   346.980     0.150
    27.684   349.960     0.150
    28.588   357.560     0.150
    28.673   358.810     0.150
    29.081   363.390     0.150
    29.527   367.280     0.150
    29.873   369.440     0.150
    30.781   377.360     0.150
    33.015   398.830     0.150
    34.257   410.780     0.150
    34.420   409.840     0.150
    34.924   412.500     0.150
    35.487   420.150     0.150
    36.037   424.790     0.150
    38.075   440.520     0.150
    39.057   448.830     0.150
    40.442   460.690     0.150
    41.255   465.100     0.150
    41.707   471.830     0.150
    42.398   475.960     0.150
    44.713   494.960     0.150
    44.769   496.840     0.150
    45.225   501.530     0.150
    45.371   501.240     0.150
    46.172   505.680     0.150
    47.445   518.530     0.150
    47.936   522.920     0.150
    49.520   533.360     0.150
    50.161   538.830     0.150
     2.937    83.078     0.150
     4.319   118.031     0.150
     3.549    57.820     0.150
     4.319   118.054     0.150
     3.889   106.335     0.150
     4.150   114.394     0.150
     4.150   114.403     0.150
     4.150    65.639     0.150
     4.165    69.431     0.150
     4.901    81.410     0.150
     5.398    87.130     0.150
     6.813   105.450     0.150
     7.203   110.130     0.150
     7.742   117.460     0.150
     7.783   118.840     0.150
     8.512   128.510     0.150
     9.898   147.130     0.150
    14.844   210.650     0.150
    14.844   210.450     0.150
    14.844   210.840     0.150
    15.336   217.351     0.150
    17.064   241.910     0.150
    21.264   292.311     0.150
    21.725   297.062     0.150
    21.933   298.460     0.150
    22.332   303.101     0.150
    22.954   309.820     0.150
    23.450   313.160     0.150
    26.024   338.570     0.150
    26.147   340.200     0.150
    27.775   354.000     0.150
    28.618   359.230     0.150
    29.656   368.360     0.150
    29.660   368.360     0.150
    30.084   372.510     0.150
    31.173   380.360     0.150
    32.555   394.690     0.150
    34.272   409.181     0.150
    34.150   408.684     0.150
    34.929   416.164     0.150
    34.929   416.271     0.150
    34.985   416.730     0.150
    35.022   415.860     0.150
    35.390   419.798     0.150
    35.462   421.450     0.150
    35.462   421.294     0.150
    35.868   423.859     0.150
    36.232   425.730     0.150
    36.383   428.285     0.150
    37.132   435.550     0.150
    37.132   434.119     0.150
    37.167   434.547     0.150
    37.471   437.480     0.150
    37.461   437.539     0.150
    37.604   438.950     0.150
    37.604   438.822     0.150
    37.744   439.950     0.150
    37.820   440.156     0.150
    37.894   440.750     0.150
    37.906   440.851     0.150
    38.146   443.312     0.150
    38.401   445.234     0.150
    38.460   445.662     0.150
    38.470   446.303     0.150
    38.487   446.450     0.150
    38.522   446.323     0.150
    38.781   447.950     0.150
    39.675   455.450     0.150
    40.943   465.851     0.150
    40.943   465.450     0.150
    41.249   468.550     0.150
    41.249   468.319     0.150
    41.866   473.851     0.150
    42.386   478.450     0.150
     4.165    67.050     0.150
     5.905    93.150     0.150
     8.512   128.150     0.150
    14.970   213.150     0.150
    17.064   242.450     0.150
    18.382   256.851     0.150
    19.258   268.650     0.150
    19.439   268.351     0.150
    21.709   292.050     0.150
    22.002   296.150     0.150
    22.325   302.650     0.150
    22.702   305.250     0.150
    23.295   310.150     0.150
    23.250   310.950     0.150
    23.285   313.050     0.150
    23.450   312.950     0.150
    27.785   349.650     0.150
    28.437   358.250     0.150
    29.656   368.750     0.150
    29.874   369.950     0.150
    29.771   370.650     0.150
    30.084   372.650     0.150
    31.173   381.050     0.150
    32.958   396.351     0.150
    33.906   405.150     0.150
    33.906   404.835     0.150
    34.029   406.332     0.150
    35.022   415.523     0.150
    35.983   423.050     0.150
    36.075   424.928     0.150
    37.382   434.975     0.150
    37.404   435.829     0.150
    38.170   442.028     0.150
    39.331   452.351     0.150
    41.866   473.018     0.150
    41.999   474.195     0.150
    42.720   479.871     0.150
    43.847   489.851     0.150
    46.346   508.950     0.150
    46.475   509.450     0.150
    46.778   513.750     0.150
    47.580   517.150     0.150
    50.338   539.851     0.150
    53.907   566.250     0.150
    76.319   710.050     0.150
    81.007   736.250     0.150
    81.269   738.250     0.150
    83.092   746.550     0.150
   116.271  1125.231     0.150
   117.575  1126.455     0.150
   118.588  1128.959     0.150
   118.745  1129.571     0.150
   119.394  1130.239     0.150
     1.259    44.040     0.150
     3.933    67.800     0.150
     4.165    68.870     0.150
     4.901    80.380     0.150
     7.203   110.670     0.150
     7.742   117.070     0.150
     9.898   146.070     0.150
    18.382   255.400     0.150
    20.190   276.830     0.150
    20.581   281.931     0.150
    20.844   284.290     0.150
    20.970   286.820     0.150
    21.008   287.181     0.150
    21.264   290.260     0.150
    21.600   292.021     0.150
    23.295   308.970     0.150
    23.275   311.370     0.150
    23.450   311.641     0.150
    24.552   321.101     0.150
    28.618   357.780     0.150
    30.813   375.860     0.150
    31.173   379.820     0.150
    32.978   397.080     0.150
    33.301   397.771     0.150
    33.906   404.431     0.150
    35.377   418.440     0.150
    35.462   420.771     0.150
    38.065   441.240     0.150
    38.198   441.110     0.150
    39.068   447.980     0.150
    39.198   450.700     0.150
    39.675   455.070     0.150
    39.810   455.080     0.150
    41.681   471.420     0.150
    41.999   473.960     0.150
    42.043   474.681     0.150
    42.408   475.500     0.150
    43.099   482.210     0.150
    43.353   485.910     0.150
    43.847   488.931     0.150
    44.052   490.960     0.150
    44.817   497.500     0.150
    45.272   501.330     0.150
    45.348   501.940     0.150
    46.297   508.280     0.150
    46.346   506.900     0.150
    50.338   538.210     0.150
    50.459   540.250     0.150
    53.907   565.431     0.150
    57.447   591.450     0.150
    58.402   597.980     0.150
    60.379   610.970     0.150
    60.831   613.800     0.150
    62.708   627.080     0.150
    63.981   636.840     0.150
    67.251   656.880     0.150
    70.390   675.891     0.150
    70.509   675.710     0.150
    71.261   680.480     0.150
    71.571   682.400     0.150
    71.990   684.330     0.150
    72.740   689.240     0.150
    73.559   696.530     0.150
    74.038   697.780     0.150
    74.604   702.420     0.150
    76.319   708.960     0.150
     4.165    65.548     0.150
     4.345   118.484     0.150
     4.345   118.505     0.150
     5.769   153.752     0.150
     4.165   114.586     0.150
     4.345   118.515     0.150
     5.769   153.763     0.150
     4.517   121.646     0.150
     5.769   153.591     0.150
     5.769   153.603     0.150
     4.345   118.513     0.150
     4.345   118.489     0.150
     4.165   114.564     0.150
     4.345   118.489     0.150
     4.345   118.489     0.150
     4.165   114.564     0.150
     2.978    84.048     0.150
     3.546   100.045     0.150
     4.138    68.883     0.150
     6.763   104.662     0.150
     8.447   127.613     0.150
    14.771   210.012     0.150
    15.294   215.402     0.150
    17.000   240.693     0.150
    28.581   358.213     0.150
    29.619   368.213     0.150
    30.005   371.893     0.150
    32.518   393.312     0.150
    33.923   405.293     0.150
    35.014   416.592     0.150
    35.492   421.533     0.150
    36.413   428.223     0.150
    36.699   429.492     0.150
    37.770   439.943     0.150
    38.517   446.193     0.150
    39.047   448.533     0.150
    39.465   451.863     0.150
    39.467   454.773     0.150
    39.842   457.623     0.150
    41.080   467.162     0.150
    41.113   466.873     0.150
    41.765   472.252     0.150
    42.063   474.992     0.150
    42.227   476.773     0.150
    43.342   485.932     0.150
    43.392   486.742     0.150
    43.454   486.643     0.150
    43.487   486.543     0.150
    43.973   488.152     0.150
    44.080   491.143     0.150
    44.866   497.152     0.150
    45.209   500.953     0.150
    45.235   499.152     0.150
    46.497   509.822     0.150
    47.804   520.203     0.150
    49.061   530.623     0.150
    56.386   583.232     0.150
    61.459   619.643     0.150
    64.059   638.002     0.150
    75.112   703.613     0.150
    76.256   709.252     0.150
    80.941   735.262     0.150
    87.363   768.463     0.150
     4.138    67.693     0.150
     5.887    92.193     0.150
     8.447   126.992     0.150
    10.630   154.293     0.150
    10.705   157.092     0.150
    15.332   220.693     0.150
    17.000   239.992     0.150
    18.336   256.293     0.150
    19.365   267.092     0.150
    21.304   291.893     0.150
    21.642   291.393     0.150
    21.937   294.592     0.150
    22.357   302.693     0.150
    23.270   309.293     0.150
    23.280   311.092     0.150
    25.306   329.092     0.150
    27.309   348.092     0.150
    28.359   357.492     0.150
    29.813   370.293     0.150
    30.005   372.293     0.150
    33.923   404.793     0.150
    35.926   421.992     0.150
    42.720   478.967     0.150
    44.357   491.768     0.150
    44.357     5.850     0.150
    76.256   709.793     0.150
    81.239   737.393     0.150
    83.043   746.092     0.150
     3.867    68.033     0.150
     4.138    69.213     0.150
     4.442    75.232     0.150
     4.844    80.033     0.150
     5.539    89.592     0.150
     5.887    93.104     0.150
     6.842   105.223     0.150
     7.148   109.893     0.150
     7.216   111.682     0.150
     7.423   114.512     0.150
     7.676   116.762     0.150
     8.447   127.512     0.150
     8.777   131.273     0.150
    10.970   160.422     0.150
    14.771   210.432     0.150
    17.000   241.123     0.150
    21.003   286.963     0.150
    23.270   309.762     0.150
    28.581   357.963     0.150
    33.923   404.152     0.150
    34.916   413.193     0.150
    42.387   476.172     0.150
    43.392   483.572     0.150
    44.866   496.533     0.150
    48.387   522.752     0.150
    70.717   675.002     0.150
    71.927   683.883     0.150
    72.711   689.252     0.150
    73.944   695.963     0.150
    74.014   697.203     0.150
    74.733   701.662     0.150
    75.296   704.223     0.150
    75.613   706.482     0.150
    75.707   706.412     0.150
    76.450   710.354     0.150
    77.030   713.104     0.150
    77.882   718.773     0.150
    81.248   737.393     0.150
    82.041   741.662     0.150
    92.364   792.293     0.150
     4.138    65.229     0.150
     4.303   117.404     0.150
     4.303    66.928     0.150
     5.731   152.811     0.150
     4.138   113.982     0.150
     4.303   117.373     0.150
     2.916    82.424     0.150
     4.442   119.369     0.150
     4.303   117.381     0.150
     2.916    82.432     0.150
     4.303   117.393     0.150
     4.442   119.389     0.150
     4.442   119.389     0.150
     5.731   152.771     0.150
     5.731   152.771     0.150
     4.138   113.908     0.150
     5.731   152.791     0.150
     4.138   113.928     0.150
     4.138   113.938     0.150
     4.183    68.715     0.150
     4.183    69.586     0.150
     5.925    92.016     0.150
     7.784   118.906     0.150
     8.518   128.215     0.150
     8.518   128.625     0.150
     9.024   135.254     0.150
    10.780   157.914     0.150
    14.845   210.816     0.150
    14.845   211.027     0.150
    14.971   212.316     0.150
    15.313   215.867     0.150
    17.071   242.215     0.150
    17.071   240.055     0.150
    18.396   256.117     0.150
    19.439   268.516     0.150
    21.287   292.215     0.150
    21.714   292.215     0.150
    21.747   296.453     0.150
    21.956   298.164     0.150
    22.008   295.414     0.150
    22.348   302.816     0.150
    22.726   305.117     0.150
    22.978   309.316     0.150
    23.274   310.316     0.150
    23.309   313.414     0.150
    23.314   309.016     0.150
    23.474   313.320     0.150
    23.474   313.125     0.150
    25.380   330.316     0.150
    25.477   333.664     0.150
    26.169   340.016     0.150
    27.383   348.914     0.150
    27.797   353.754     0.150
    27.805   350.816     0.150
    28.432   357.914     0.150
    28.595   358.617     0.150
    28.684   360.137     0.150
    28.767   360.914     0.150
    29.131   363.715     0.150
    29.131   364.926     0.150
    29.633   367.816     0.150
    29.633   368.105     0.150
    29.637   368.117     0.150
    29.851   369.715     0.150
    29.884   370.137     0.150
    29.794   370.414     0.150
    30.076   372.516     0.150
    30.076   372.617     0.150
    30.378   376.254     0.150
    30.543   376.805     0.150
    31.196   381.582     0.150
    31.196   381.117     0.150
    32.531   394.188     0.150
    33.450   402.387     0.150
    33.712   405.047     0.150
    33.929   404.816     0.150
    34.173   409.070     0.150
    34.420   410.305     0.150
    34.753   413.527     0.150
    34.953   416.414     0.150
    34.953   416.184     0.150
    34.997   416.418     0.150
    35.009   416.816     0.150
    35.045   416.242     0.150
    35.096   416.242     0.150
    35.178   417.492     0.150
    35.210   417.691     0.150
    35.237   418.324     0.150
    35.371   419.961     0.150
    35.414   420.016     0.150
    35.486   421.117     0.150
    35.486   420.934     0.150
    35.537   421.137     0.150
    35.679   419.516     0.150
    35.889   421.977     0.150
    35.891   423.996     0.150
    35.971   425.016     0.150
    35.993   422.914     0.150
    35.993   424.531     0.150
    36.099   425.238     0.150
    36.256   425.977     0.150
    36.406   428.695     0.150
    36.406   427.977     0.150
    36.631   430.582     0.150
    36.943   432.594     0.150
    37.016   433.215     0.150
    37.016   433.703     0.150
    37.156   435.316     0.150
    37.156   434.926     0.150
    37.406   436.750     0.150
    37.427   436.332     0.150
    37.494   437.875     0.150
    37.487   434.715     0.150
    37.628   439.715     0.150
    37.696   438.871     0.150
    37.715   438.977     0.150
    37.767   440.215     0.150
    37.843   440.809     0.150
    37.929   441.414     0.150
    38.169   443.133     0.150
    38.483   446.332     0.150
    38.493   446.234     0.150
    38.511   446.215     0.150
    38.545   446.691     0.150
    38.805   448.316     0.150
    38.886   446.797     0.150
    38.886     6.117     0.150
    39.088   449.715     0.150
    39.327   452.016     0.150
    39.698   456.215     0.150
    39.698   456.027     0.150
    40.583   463.016     0.150
    40.967   465.816     0.150
    41.183   469.016     0.150
    41.273   468.617     0.150
    41.273   468.750     0.150
    41.273   468.121     0.150
    41.304   469.715     0.150
    41.705   472.715     0.150
    41.890   473.516     0.150
    41.890   473.992     0.150
    42.022   474.914     0.150
    42.022   474.016     0.150
    42.226   476.516     0.150
    42.410   478.016     0.150
    42.760   479.016     0.150
    42.824   481.617     0.150
    43.214   484.117     0.150
    43.394   486.516     0.150
    43.871   489.316     0.150
    44.379   491.676     0.150
    44.379     6.340     0.150
    44.379     6.453     0.150
    45.514   500.551     0.150
    45.634   501.215     0.150
    46.468   509.414     0.150
    46.369   508.117     0.150
    46.767   513.516     0.150
    46.951   512.855     0.150
    46.951   513.105     0.150
    47.402   517.316     0.150
    47.586   517.215     0.150
    49.235   530.340     0.150
    49.235   531.590     0.150
    50.355   539.516     0.150
    53.444   561.141     0.150
    53.444   561.789     0.150
    53.895   565.816     0.150
    54.125   568.316     0.150
    55.785   580.617     0.150
    56.108   581.414     0.150
    57.838   595.516     0.150
    76.326   710.414     0.150
    81.245   737.617     0.150
    83.105   746.617     0.150
   116.265  1125.012     0.150
   117.569  1127.258     0.150
   118.739  1131.016     0.150
   119.389  1132.215     0.150
     1.277    42.395     0.150
     3.939    68.125     0.150
     3.939   116.566     0.150
     4.183    69.285     0.150
     4.183   119.477     0.150
     4.516    75.996     0.150
     4.911    80.254     0.150
     5.411    86.617     0.150
     5.606    89.727     0.150
     5.925    92.555     0.150
     5.925   156.555     0.150
     6.825   104.605     0.150
     8.445   125.957     0.150
    11.045   160.844     0.150
    14.971   212.195     0.150
    16.610   232.715     0.150
    16.610   232.715     0.150
    17.071   237.395     0.150
    17.996   251.387     0.150
    18.396   256.438     0.150
    20.211   276.188     0.150
    20.602   281.086     0.150
    20.865   283.605     0.150
    20.871   284.336     0.150
    20.994   286.754     0.150
    21.030   286.176     0.150
    21.287   290.945     0.150
    21.622   293.266     0.150
    21.714   291.965     0.150
    22.470   302.207     0.150
    23.298   311.105     0.150
    23.314   309.715     0.150
    23.474   310.754     0.150
    24.566   321.406     0.150
    24.520   323.074     0.150
    26.914   343.945     0.150
    26.914   344.227     0.150
    27.144   346.414     0.150
    27.608   350.305     0.150
    28.114   354.676     0.150
    28.595   358.297     0.150
    28.684   359.594     0.150
    28.767   358.707     0.150
    29.131   363.547     0.150
    29.551   366.887     0.150
    29.638   368.586     0.150
    29.851   370.004     0.150
    29.794   369.777     0.150
    29.794   370.156     0.150
    29.884   369.957     0.150
    30.076   372.137     0.150
    30.440   376.656     0.150
    30.789   377.914     0.150
    31.196   380.727     0.150
    31.638   386.375     0.150
    32.237   391.047     0.150
    33.000   398.145     0.150
    33.929   404.797     0.150
    33.929   404.617     0.150
    34.420   409.605     0.150
    34.508   411.145     0.150
    34.934   413.867     0.150
    35.399   418.516     0.150
    35.486   420.375     0.150
    36.041   423.984     0.150
    35.993   422.727     0.150
    36.112   424.816     0.150
    38.576   444.797     0.150
    38.632   445.938     0.150
    39.088   449.027     0.150
    41.245   465.926     0.150
    41.705   471.465     0.150
    42.428   475.715     0.150
    43.377   485.527     0.150
    44.118   491.055     0.150
    44.743   497.414     0.150
    44.768   497.125     0.150
    44.755   496.477     0.150
    44.797   497.395     0.150
    45.159   500.906     0.150
    45.253   501.375     0.150
    45.329   502.047     0.150
    45.375   501.316     0.150
    45.604   501.996     0.150
    45.634   500.438     0.150
    45.735   504.277     0.150
    45.735   504.277     0.150
    46.369   507.094     0.150
    47.247   514.688     0.150
    47.395   516.734     0.150
    47.327   515.535     0.150
    47.327   515.547     0.150
    47.402   516.234     0.150
    47.586   516.438     0.150
    47.724   519.914     0.150
    47.886   520.637     0.150
    49.520   533.457     0.150
    49.545   533.047     0.150
    50.163   538.535     0.150
    50.308   536.746     0.150
    50.355   539.246     0.150
    51.497   549.605     0.150
    53.049   559.926     0.150
    53.397   561.977     0.150
    53.442   562.176     0.150
    53.473   561.605     0.150
    53.895   565.375     0.150
    54.125   567.367     0.150
    54.664   571.645     0.150
    54.768   571.805     0.150
    57.468   590.867     0.150
    58.426   597.754     0.150
    60.402   612.145     0.150
    60.847   613.977     0.150
    62.596   626.215     0.150
    62.727   626.766     0.150
    63.986   635.727     0.150
    66.646   652.895     0.150
    67.904   659.566     0.150
    68.696   666.105     0.150
    70.367   676.336     0.150
    71.267   680.367     0.150
    71.679   683.715     0.150
    71.580   682.426     0.150
    72.686   687.766     0.150
    72.867   691.844     0.150
    72.780   689.336     0.150
    72.825   690.156     0.150
    73.128   692.555     0.150
    73.034   691.516     0.150
    73.086   690.484     0.150
    73.199   691.645     0.150
    73.398   694.664     0.150
    73.566   695.375     0.150
    73.931   696.625     0.150
    74.012   696.387     0.150
    74.340   699.457     0.150
    74.464   700.547     0.150
    74.609   701.926     0.150
    74.661   700.285     0.150
    75.686   706.676     0.150
    76.161   710.215     0.150
    76.322   712.387     0.150
    76.326   709.676     0.150
    76.494   711.156     0.150
    76.632   710.605     0.150
    76.772   711.777     0.150
    77.714   717.125     0.150
    78.168   719.734     0.150
    79.055   724.625     0.150
    79.558   727.887     0.150
    80.041   730.355     0.150
    80.553   733.555     0.150
    81.013   735.605     0.150
    81.061   736.254     0.150
    81.254   737.477     0.150
    82.110   742.277     0.150
    84.704   755.484     0.150
    89.008   776.125     0.150
    92.426   792.234     0.150
    96.932   811.957     0.150
   117.569  1126.766     0.150
   124.446  1140.137     0.150
   144.473  1178.426     0.150
   147.630  1187.016     0.150
   147.983  1188.086     0.150
   147.983  1183.457     0.150
   148.011  1184.965     0.150
   148.447  1189.246     0.150
   148.904  1186.586     0.150
   148.904  1190.656     0.150
   149.814  1191.695     0.150
   150.001  1191.695     0.150
     5.126    80.516     0.150
     4.174    70.900     0.150
     4.900    81.260     0.150
     5.400    87.590     0.150
     7.736   117.750     0.150
     8.507   128.850     0.150
     8.839   132.810     0.150
    14.834   211.250     0.150
    17.059   241.850     0.150
    21.286   292.650     0.150
    21.957   298.720     0.150
    22.976   309.890     0.150
    24.573   320.930     0.150
    33.925   403.900     0.150
    33.925   404.733     0.150
    34.005   407.880     0.150
    34.054   408.296     0.150
    34.049   406.220     0.150
    34.751   413.272     0.150
    34.995   416.081     0.150
    35.004   417.207     0.150
    35.006   417.020     0.150
    35.043   415.868     0.150
    35.369   420.319     0.150
    35.411   420.053     0.150
    35.483   421.355     0.150
    35.483   421.820     0.150
    35.889   424.417     0.150
    35.969   424.905     0.150
    36.096   425.624     0.150
    37.013   433.400     0.150
    37.013   433.135     0.150
    37.403   437.537     0.150
    37.425   436.064     0.150
    37.482   437.230     0.150
    37.625   438.600     0.150
    37.765   440.395     0.150
    37.765   440.150     0.150
    37.841   440.637     0.150
    37.914   440.850     0.150
    38.083   441.080     0.150
    38.167   443.691     0.150
    38.491   445.938     0.150
    38.509   445.914     0.150
    38.878   446.760     0.150
    39.466   455.170     0.150
    39.695   455.916     0.150
    40.964   466.040     0.150
    41.269   468.672     0.150
    41.379   469.790     0.150
    41.441   469.940     0.150
    41.507   470.980     0.150
    41.917   474.360     0.150
    42.063   475.520     0.150
    42.227   476.920     0.150
    42.751   479.265     0.150
    43.376   486.880     0.150
    43.452   486.670     0.150
    43.577   486.800     0.150
    44.372   491.690     0.150
    44.372   492.440     0.150
    44.372     5.225     0.150
    44.859   494.720     0.150
    45.239   499.640     0.150
    46.942   512.610     0.150
    47.257   515.590     0.150
     4.174    69.830     0.150
     4.505    74.710     0.150
     4.900    79.810     0.150
     5.400    86.140     0.150
     5.595    89.680     0.150
     5.917    93.380     0.150
     6.814   105.060     0.150
     6.900   105.830     0.150
     7.202   110.580     0.150
     7.278   111.910     0.150
     7.486   114.280     0.150
     7.736   116.330     0.150
     8.434   125.300     0.150
     8.507   127.850     0.150
     8.839   131.390     0.150
     9.040   133.110     0.150
    11.034   160.610     0.150
    14.834   210.000     0.150
    14.960   210.540     0.150
    16.602   233.520     0.150
    16.602   233.210     0.150
    20.992   286.840     0.150
    21.286   290.130     0.150
    21.703   292.870     0.150
    21.703   292.550     0.150
    23.297   309.610     0.150
    23.305   310.070     0.150
    23.472   312.010     0.150
    24.573   321.820     0.150
    28.596   358.980     0.150
    33.001   397.900     0.150
    35.483   420.410     0.150
    35.982   422.600     0.150
    36.109   424.160     0.150
    38.083   440.220     0.150
    39.079   448.460     0.150
    43.376   484.900     0.150
    44.074   489.610     0.150
    44.164   490.370     0.150
    44.859   496.260     0.150
    46.965   513.040     0.150
    47.257   514.200     0.150
    48.381   524.100     0.150
    53.047   559.350     0.150
    54.660   570.350     0.150
    63.996   636.310     0.150
    71.255   680.200     0.150
    71.568   681.850     0.150
    71.919   684.030     0.150
    71.986   684.590     0.150
    72.379   687.930     0.150
    72.878   692.320     0.150
    73.139   693.020     0.150
    73.023   690.900     0.150
    73.409   695.300     0.150
    74.005   696.090     0.150
    74.790   702.130     0.150
    75.355   704.290     0.150
    75.762   706.940     0.150
    76.225   708.950     0.150
    76.509   710.810     0.150
    76.522   710.560     0.150
     3.561   100.091     0.150
     3.561   100.101     0.150
     3.561    57.571     0.150
     3.561   100.112     0.150
     4.174   114.638     0.150
     5.774   153.827     0.150
     4.349   118.581     0.150
     4.349   118.581     0.150
     4.174   114.667     0.150
     4.349   118.591     0.150
     2.974    84.227     0.150
     4.505   121.642     0.150
     2.974    48.522     0.150
     4.349   118.745     0.150
     4.349   118.576     0.150
     4.174   114.656     0.150
     4.349   118.586     0.150
     4.349   118.586     0.150
     4.174   114.665     0.150
     2.974    84.150     0.150
     3.561   100.163     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
