#!/bin/bash
gmt begin kunar4.14_sel2 pdf,ps
proj=-JM16.0c+
reg=-R70.5/71.0/34.5/34.9
gmt basemap $proj $reg -Bxa0.2f0.1 -Bya0.2f0.1 -BWeSn+t'Base Map kunar4.14'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Calibration location confidence ellipses
gmt plot $proj $reg -SE -Wthick,yellow -Gyellow << EOF
    70.800    34.710   120.000     2.000     6.000
    70.690    34.670   160.000     2.000     6.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    70.789    34.716 72
    70.814    34.748 73
    70.732    34.691 74
    70.732    34.693 75
    70.732    34.702 76
    70.649    34.670 77
    70.717    34.744 78
    70.799    34.736 79
    70.690    34.667 80
    70.701    34.664 81
    70.574    34.630 82
    70.688    34.657 83
    70.708    34.690 84
    70.651    34.661 85
    70.727    34.707 86
    70.674    34.647 87
    70.679    34.658 88
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    70.793    34.706
    70.789    34.716
>
    70.882    34.338
    70.814    34.748
>
    70.731    34.702
    70.732    34.691
>
    70.711    34.663
    70.732    34.693
>
    70.772    34.610
    70.732    34.702
>
    70.680    34.717
    70.649    34.670
>
    70.681    34.675
    70.717    34.744
>
    70.724    34.589
    70.799    34.736
>
    70.598    34.460
    70.690    34.667
>
    70.791    34.719
    70.701    34.664
>
    70.652    34.574
    70.574    34.630
>
    70.669    34.692
    70.688    34.657
>
    70.791    34.667
    70.708    34.690
>
    70.748    34.716
    70.651    34.661
>
    70.788    34.697
    70.727    34.707
>
    70.670    34.549
    70.674    34.647
>
    70.662    34.581
    70.679    34.658
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    70.898    34.750
    70.898    34.749
>
    70.923    34.782
    70.922    34.782
>
    70.841    34.725
    70.841    34.725
>
    70.841    34.727
    70.841    34.727
>
    70.841    34.736
    70.841    34.735
>
    70.758    34.704
    70.758    34.703
>
    70.826    34.778
    70.826    34.777
>
    70.908    34.771
    70.908    34.770
>
    70.800    34.701
    70.799    34.701
>
    70.810    34.698
    70.809    34.698
>
    70.683    34.664
    70.682    34.664
>
    70.798    34.691
    70.797    34.690
>
    70.817    34.724
    70.817    34.724
>
    70.760    34.695
    70.759    34.694
>
    70.837    34.742
    70.836    34.741
>
    70.783    34.681
    70.783    34.681
>
    70.788    34.692
    70.788    34.692
>
EOF

# Calibration shift (for indirect calibration) in red
gmt plot $proj $reg -Wthin,red << EOF
    70.789    34.716
    70.898    34.749
>
    70.814    34.748
    70.922    34.782
>
    70.732    34.691
    70.841    34.725
>
    70.732    34.693
    70.841    34.727
>
    70.732    34.702
    70.841    34.735
>
    70.649    34.670
    70.758    34.703
>
    70.717    34.744
    70.826    34.777
>
    70.799    34.736
    70.908    34.770
>
    70.690    34.667
    70.799    34.701
>
    70.701    34.664
    70.809    34.698
>
    70.574    34.630
    70.682    34.664
>
    70.688    34.657
    70.797    34.690
>
    70.708    34.690
    70.817    34.724
>
    70.651    34.661
    70.759    34.694
>
    70.727    34.707
    70.836    34.741
>
    70.674    34.647
    70.783    34.681
>
    70.679    34.658
    70.788    34.692
>
EOF

# Calibration locations marked by a red cross
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
    70.800    34.710     0.200
    70.690    34.670     0.200
EOF

# Residual calibration shift vectors
gmt plot $proj $reg -Wthick,blue << EOF
    70.800    34.710
    70.789    34.716
>
    70.690    34.670
    70.701    34.664
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    70.789    34.716   -73.224     1.179     1.804
    70.814    34.748    77.278     4.379     6.900
    70.732    34.691   -89.364     1.510     2.191
    70.732    34.693   -76.949     1.538     1.777
    70.732    34.702    40.234     1.861     2.177
    70.649    34.670    41.348     2.385     2.507
    70.717    34.744   -86.941     1.665     2.382
    70.799    34.736    70.285     6.918    12.499
    70.690    34.667    82.175     2.517     3.234
    70.701    34.664   -74.521     0.951     1.461
    70.574    34.630   -10.801     3.533     6.909
    70.688    34.657   -13.462     3.002     6.033
    70.708    34.690   -79.275     1.623     1.992
    70.651    34.661    49.557     2.249     2.549
    70.727    34.707     1.910     2.355     2.550
    70.674    34.647   -86.117     1.589     2.482
    70.679    34.658    41.196     2.449     3.419
EOF

# User-defined ellipses
gmt plot $proj $reg -SE -Wthicker,yellow << EOF
    70.761    34.715    53.000    10.000     6.000
    70.700    34.695    55.000     8.000     4.000
EOF


# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    70.789    34.716     0.200
    70.732    34.691     0.100
    70.732    34.693     0.100
    70.717    34.744     0.100
    70.701    34.664     0.100
    70.708    34.690     0.100
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    70.539    34.584   -40.992     3.058     5.871
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    70.562    34.584   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    70.539    34.584     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    70.539    34.584     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    70.539    34.539   5 km
EOF
gmt end
