#!/bin/bash
gmt begin kunar4.14_sel1 pdf,ps
proj=-JM16.0c+
reg=-R70.6/71.0/34.6/34.8
gmt basemap $proj $reg -Bxa0.2f0.1 -Bya0.2f0.1 -BWeSn+t'Base Map kunar4.14'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Calibration location confidence ellipses
gmt plot $proj $reg -SE -Wthick,yellow -Gyellow << EOF
    70.800    34.710   120.000     2.000     6.000
    70.690    34.670   160.000     2.000     6.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    70.789    34.716 72
    70.701    34.664 81
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    70.793    34.706
    70.789    34.716
>
    70.791    34.719
    70.701    34.664
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    70.898    34.750
    70.898    34.749
>
    70.810    34.698
    70.809    34.698
>
EOF

# Calibration shift (for indirect calibration) in red
gmt plot $proj $reg -Wthin,red << EOF
    70.789    34.716
    70.898    34.749
>
    70.701    34.664
    70.809    34.698
>
EOF

# Calibration locations marked by a red cross
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
    70.800    34.710     0.200
    70.690    34.670     0.200
EOF

# Residual calibration shift vectors
gmt plot $proj $reg -Wthick,blue << EOF
    70.800    34.710
    70.789    34.716
>
    70.690    34.670
    70.701    34.664
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    70.789    34.716   -73.224     1.179     1.804
    70.701    34.664   -74.521     0.951     1.461
EOF

# User-defined ellipses
gmt plot $proj $reg -SE -Wthicker,yellow << EOF
    70.761    34.715    53.000    10.000     6.000
    70.700    34.695    55.000     8.000     4.000
EOF


# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    70.789    34.716     0.200
    70.701    34.664     0.100
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    70.666    34.618   -40.992     3.058     5.871
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    70.689    34.618   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    70.666    34.618     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    70.666    34.618     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    70.666    34.573   5 km
EOF
gmt end
