#!/bin/bash
gmt begin kunar4.14_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-9/7/0/13
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya10f5+l'Counts' -BWeSn+t'Origin Time Mislocation kunar4.14' << EOF
     2.117
     1.539
    -0.277
    -0.168
     4.708
     2.324
    -0.004
    -0.723
     3.762
     2.711
     2.672
     4.094
     1.742
     2.594
     4.422
    -0.332
     4.863
    -0.758
     2.340
     3.801
     2.328
     4.258
     5.414
    -0.156
    -0.469
     3.083
     0.656
     0.875
     2.941
     3.658
     1.156
     2.422
     4.047
     0.023
     2.680
     1.066
     3.234
     1.348
     0.523
     0.578
    -2.357
     2.234
    -0.592
     0.803
     1.695
     1.439
     1.457
    -0.500
     0.016
    -0.516
     1.635
     1.820
    -0.215
     1.984
     2.562
    -1.475
    -0.562
     2.789
    -0.023
     2.484
    -1.883
    -0.559
    -1.008
    -2.391
     1.523
    -0.842
    -1.750
     1.635
     1.949
     0.613
    -7.115
    -0.820
    -2.164
     0.391
    -0.047
     0.246
     0.482
     0.508
     1.102
    -0.340
     1.008
     0.344
     0.828
     0.669
     0.600
     0.102
     0.727
     0.079
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.816    11.682 Median =   0.8 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.8  0.
  0.8  11.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -8.800    12.318 Author: all (  88 samples)
EOF
gmt end
