#!/bin/bash
gmt begin kunar4.14_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-50/50/-50/50
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation kunar4.14'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    34.804    34.804
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.635   -18.693
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.880   -25.106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.531   -22.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.659   -22.237
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.328   -16.968
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.758   -13.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.424    -7.102
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.519    -9.956
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000   -17.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.012   -23.415
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.628   -10.902
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.603   -17.272
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.682   -13.115
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.394   -17.567
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    27.503    15.879
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.813   -14.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.660   -13.660
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.955   -19.689
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.958     4.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.387    -7.391
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.809    14.809
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.617     3.775
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.255    -6.674
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -22.552   -10.516
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.977   -17.106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.224    -8.858
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.477   -25.389
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.021   -15.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.177   -22.458
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.167    -9.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.200   -17.010
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.786    -2.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.133    -8.224
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.490    -9.490
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.105    -4.788
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -19.752    -3.839
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.618    -6.350
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.964    -8.726
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.803    -4.870
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.083    -7.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.665     0.442
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.469    -1.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.791    -8.617
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.688    -4.369
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.223   -13.263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -19.016    -5.453
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.339    -8.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -23.454   -21.118
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.925   -23.383
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -26.994   -25.172
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -26.994   -25.172 50
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -26.181   -21.201
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -20.996   -17.002
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.361   -19.034
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.211   -12.665
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.316   -13.791
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.519    -8.602
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.315   -19.877
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.635   -16.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.925   -28.460
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -21.648   -13.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -23.355   -28.841
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -23.355   -28.841 61
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.502   -13.058
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.803    -3.673
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -22.945   -12.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.788   -14.723
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.921   -10.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.929    -6.761
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.620   -12.314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.804    -6.245
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.876   -16.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.411   -10.826
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.526    -4.854
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.449   -49.318
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.449   -49.318 73
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.028    -2.500
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.912    -7.158
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.227   -13.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.172     1.524
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.208   -11.481
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.848   -20.078
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.609   -26.576
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.689     2.324
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.858    -9.965
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.746     0.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.416    -6.295
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.086     2.440
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.355    -4.837
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.276   -14.675
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.512   -12.346
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -8.885   -11.761     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -48.000    48.000 Author: all (  88 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -48.000   -48.000 Average =  14.7 km at 217.1 deg; median =   17.4 km
EOF
gmt end
