#!/bin/bash
gmt begin kunar4.14_ell pdf,ps
proj=-JM16.0c+
reg=-R69.7/71.7/34.0/35.3
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map kunar4.14'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Calibration location confidence ellipses
gmt plot $proj $reg -SE -Wthick,yellow -Gyellow << EOF
    70.800    34.710   120.000     2.000     6.000
    70.690    34.670   160.000     2.000     6.000
EOF

# Calibration locations marked by a red cross
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
    70.800    34.710     0.200
    70.690    34.670     0.200
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    71.004    34.886    55.892     3.912     5.137
    70.799    34.725   -57.364     3.563     4.967
    70.897    34.735   -28.543     2.715     3.785
    70.407    34.693   -42.621     4.360     6.055
    71.136    34.966   -31.297     3.650     4.663
    70.539    34.526   -14.455     4.574     8.061
    70.494    34.617   -66.732     1.519     2.501
    70.435    34.619   -58.296     1.437     2.437
    70.380    34.613   -42.287     1.623     2.795
    70.453    34.654   -46.301     1.598     2.798
    70.440    34.633   -51.405     1.597     2.574
    70.447    34.643   -48.419     1.800     2.866
    70.504    34.669   -24.188     2.200     4.353
    70.601    34.402   -45.822     1.710     4.753
    70.494    34.688   -51.496     2.907     8.432
    70.602    34.661   -54.231     2.473     5.753
    71.055    34.849   -56.371     2.940     7.584
    70.664    34.774   -43.255     3.219     6.928
    70.369    34.633   -38.496     3.203     7.854
    70.905    34.812    40.682     1.843     4.863
    71.501    34.504   -46.352     3.127     9.652
    70.891    34.781   -54.640     2.839     9.068
    70.802    34.802   -38.498     2.936     7.994
    70.566    34.407   -48.996     6.723    14.042
    70.663    34.512   -53.667     1.791     4.055
    70.564    34.355   -57.904     1.770     7.406
    70.318    34.624   -58.482     1.936     6.808
    70.862    34.682   -61.186     1.332     3.741
    70.887    34.677   -57.748     1.525     4.710
    70.932    34.711   -61.910     2.521     5.960
    70.589    34.133   -56.371     1.456     2.288
    70.563    34.128   -29.827     2.199     4.686
    70.509    34.506   -39.899     1.877     3.490
    70.589    34.480   -51.406     1.895     2.998
    71.159    34.858   -35.106     2.522     4.353
    71.461    35.118   -34.814     4.440    10.745
    70.803    34.699   -25.656     3.118     8.255
    70.817    34.360   -33.507     4.027     7.429
    70.008    34.199   -66.977     1.035     2.065
    70.018    34.169   -66.400     1.282     2.273
    71.310    34.489   -39.065     4.062    11.646
    69.968    34.150   -67.546     1.234     2.398
    70.439    34.549   -70.143     1.106     1.685
    70.434    34.517   -39.625     1.661     3.391
    70.306    34.549   -40.007     1.941     3.990
    70.940    34.738   -48.659     2.332     3.298
    70.458    34.714   -50.052     2.108     3.864
    70.336    34.564   -42.808     3.430     5.697
    70.290    34.613   -83.898     2.059     4.012
    70.633    34.492   -78.747     1.941     4.153
    70.059    34.529   -39.294     3.555     4.984
    70.377    34.562   -39.403     2.999     5.012
    70.718    34.318   -62.612     1.719     3.643
    70.913    34.796   -30.482     3.822     5.811
    70.753    34.613   -28.497     4.076     6.079
    70.705    34.766    74.917     2.648     3.856
    70.201    34.585    88.496     3.315     4.787
    70.728    34.762   -53.690     5.593     8.627
    70.303    34.545    87.941     2.236     4.961
    70.548    34.608   -38.975     1.881     2.623
    70.673    34.295   -62.445     2.169     3.679
    69.804    34.669   -86.062     1.203     2.108
    70.758    34.696   -72.958     0.853     1.287
    70.764    34.690   -72.524     1.288     2.076
    70.742    34.705   -55.702     1.370     2.141
    70.737    34.707   -49.009     2.208     4.441
    70.718    34.681    86.122     1.947     3.559
    70.741    34.658   -81.178     1.346     2.151
    70.722    34.665   -77.429     1.267     2.169
    70.578    34.560    79.903     1.488     3.094
    70.819    34.241    79.982     2.843     5.437
    70.789    34.716   -73.224     1.179     1.804
    70.814    34.748    77.278     4.379     6.900
    70.732    34.691   -89.364     1.510     2.191
    70.732    34.693   -76.949     1.538     1.777
    70.732    34.702    40.234     1.861     2.177
    70.649    34.670    41.348     2.385     2.507
    70.717    34.744   -86.941     1.665     2.382
    70.799    34.736    70.285     6.918    12.499
    70.690    34.667    82.175     2.517     3.234
    70.701    34.664   -74.521     0.951     1.461
    70.574    34.630   -10.801     3.533     6.909
    70.688    34.657   -13.462     3.002     6.033
    70.708    34.690   -79.275     1.623     1.992
    70.651    34.661    49.557     2.249     2.549
    70.727    34.707     1.910     2.355     2.550
    70.674    34.647   -86.117     1.589     2.482
    70.679    34.658    41.196     2.449     3.419
EOF

# User-defined ellipses
gmt plot $proj $reg -SE -Wthicker,yellow << EOF
    70.761    34.715    53.000    10.000     6.000
    70.700    34.695    55.000     8.000     4.000
EOF


# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    70.435    34.619     0.200
    70.789    34.716     0.200
    70.732    34.691     0.100
    70.732    34.693     0.100
    70.717    34.744     0.100
    70.701    34.664     0.100
    70.708    34.690     0.100
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    69.769    34.082   -40.992     3.058     5.871
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    69.791    34.082   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    69.769    34.082     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    69.769    34.082     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    69.769    34.037   5 km
EOF
gmt end
