#!/bin/bash
gmt begin kunar4.14_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-52/57/0/17
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation kunar4.14' << EOF
    17.000
    15.500
     2.000
     2.000
    50.000
    25.000
     2.300
    -6.500
    33.000
    28.400
    26.000
    35.000
    20.000
    26.000
    47.000
     2.300
    42.000
    -1.000
    16.000
    35.000
    17.000
    48.000
    52.000
    14.000
     1.600
    30.000
    13.000
     9.600
    30.000
    33.000
    17.000
    23.000
    35.000
     9.300
    29.000
    15.000
    32.000
    23.000
     4.800
     5.800
   -20.000
    17.000
    -1.900
    16.000
    20.000
    14.000
    15.000
     7.000
    15.000
    15.000
    25.000
    27.000
     9.000
    29.000
    26.000
    -5.000
     7.000
    33.000
    19.000
    26.000
     5.000
     0.700
    -4.100
   -12.000
    16.000
    -1.000
    -8.000
    20.500
    21.900
    11.000
   -47.000
    -2.000
     6.000
     6.000
     6.900
     6.000
     6.000
     6.000
     6.000
     6.000
     4.000
     6.000
     6.000
     5.100
     6.000
     6.000
     6.000
     6.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    14.000    14.892 Median =  14.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 14.0  0.
 14.0  14.6
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -51.000    16.108 Author: all (  88 samples)
EOF
gmt end
