#!/bin/bash
gmt begin kunar4.14_depth_histogram pdf,ps
proj=-JX12/10
reg=-R0/60/0/20
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depths kunar4.14' << EOF
    13.000
    14.000
     8.000
     8.000
    10.000
    17.000
    14.000
    20.000
    17.000
    13.000
    16.000
     7.000
    22.000
    16.000
     3.000
    28.000
     8.000
    29.000
    19.000
    15.000
    18.000
    12.000
     8.000
    28.000
    13.000
    15.000
    29.000
    21.000
    15.000
    17.000
    18.000
    12.000
     7.000
    31.000
     6.000
    20.000
    10.000
    22.000
    10.000
     9.000
    55.000
     8.000
    21.000
    26.000
    22.000
    36.000
    27.000
    28.000
    27.000
    27.000
    10.000
    15.000
    26.000
    16.000
     9.000
    15.000
    28.000
     9.000
    23.000
    16.000
    30.000
    22.000
    15.000
    22.000
    19.000
    11.000
    18.000
    23.000
    23.000
    31.000
    47.000
    10.000
     4.000
     4.000
     4.000
     4.000
     4.000
     4.000
     4.000
     4.000
     6.000
     4.000
     4.000
     4.000
     4.000
     4.000
     4.000
     4.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000    18.800 Median of constrained depths =  15.0
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000    17.600 Spread of constrained depths =  10.7
EOF
gmt end
