#!/bin/bash
gmt begin kunar4.14_base pdf,ps
proj=-JM16.0c+
reg=-R69.7/71.7/34.0/35.3
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map kunar4.14'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Calibration location confidence ellipses
gmt plot $proj $reg -SE -Wthick,yellow -Gyellow << EOF
    70.800    34.710   120.000     2.000     6.000
    70.690    34.670   160.000     2.000     6.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
    71.004    34.886 1
    70.799    34.725 2
    70.897    34.735 3
    70.407    34.693 4
    71.136    34.966 5
    70.539    34.526 6
    70.494    34.617 7
    70.435    34.619 8
    70.380    34.613 9
    70.453    34.654 10
    70.440    34.633 11
    70.447    34.643 12
    70.504    34.669 13
    70.601    34.402 14
    70.494    34.688 15
    70.602    34.661 16
    71.055    34.849 17
    70.664    34.774 18
    70.369    34.633 19
    70.905    34.812 20
    71.501    34.504 21
    70.891    34.781 22
    70.802    34.802 23
    70.566    34.407 24
    70.663    34.512 25
    70.564    34.355 26
    70.318    34.624 27
    70.862    34.682 28
    70.887    34.677 29
    70.932    34.711 30
    70.589    34.133 31
    70.563    34.128 32
    70.509    34.506 33
    70.589    34.480 34
    71.159    34.858 35
    71.461    35.118 36
    70.803    34.699 37
    70.817    34.360 38
    70.008    34.199 39
    70.018    34.169 40
    71.310    34.489 41
    69.968    34.150 42
    70.439    34.549 43
    70.434    34.517 44
    70.306    34.549 45
    70.940    34.738 46
    70.458    34.714 47
    70.336    34.564 48
    70.290    34.613 49
    70.633    34.492 50
    70.059    34.529 51
    70.377    34.562 52
    70.718    34.318 53
    70.913    34.796 54
    70.753    34.613 55
    70.705    34.766 56
    70.201    34.585 57
    70.728    34.762 58
    70.303    34.545 59
    70.548    34.608 60
    70.673    34.295 61
    69.804    34.669 62
    70.758    34.696 63
    70.764    34.690 64
    70.742    34.705 65
    70.737    34.707 66
    70.718    34.681 67
    70.741    34.658 68
    70.722    34.665 69
    70.578    34.560 70
    70.819    34.241 71
    70.789    34.716 72
    70.814    34.748 73
    70.732    34.691 74
    70.732    34.693 75
    70.732    34.702 76
    70.649    34.670 77
    70.717    34.744 78
    70.799    34.736 79
    70.690    34.667 80
    70.701    34.664 81
    70.574    34.630 82
    70.688    34.657 83
    70.708    34.690 84
    70.651    34.661 85
    70.727    34.707 86
    70.674    34.647 87
    70.679    34.658 88
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
    71.094    34.751
    71.004    34.886
>
    70.855    34.532
    70.799    34.725
>
    70.913    34.569
    70.897    34.735
>
    70.313    34.525
    70.407    34.693
>
    71.109    34.847
    71.136    34.966
>
    70.509    34.436
    70.539    34.526
>
    70.500    34.586
    70.494    34.617
>
    70.484    34.563
    70.435    34.619
>
    70.488    34.492
    70.380    34.613
>
    70.375    34.478
    70.453    34.654
>
    70.498    34.568
    70.440    34.633
>
    70.562    34.521
    70.447    34.643
>
    70.687    34.585
    70.504    34.669
>
    70.641    34.277
    70.601    34.402
>
    70.904    34.864
    70.494    34.688
>
    70.614    34.568
    70.602    34.661
>
    71.204    34.760
    71.055    34.849
>
    70.688    34.630
    70.664    34.774
>
    70.554    34.710
    70.369    34.633
>
    71.017    34.779
    70.905    34.812
>
    71.761    34.670
    71.501    34.504
>
    71.127    34.848
    70.891    34.781
>
    70.876    34.776
    70.802    34.802
>
    70.430    34.345
    70.566    34.407
>
    70.686    34.391
    70.663    34.512
>
    70.638    34.309
    70.564    34.355
>
    70.377    34.429
    70.318    34.624
>
    70.863    34.576
    70.862    34.682
>
    71.007    34.508
    70.887    34.677
>
    70.963    34.656
    70.932    34.711
>
    70.755    34.014
    70.589    34.133
>
    70.757    34.138
    70.563    34.128
>
    70.717    34.465
    70.509    34.506
>
    70.595    34.428
    70.589    34.480
>
    71.280    34.849
    71.159    34.858
>
    71.353    35.116
    71.461    35.118
>
    70.762    34.676
    70.803    34.699
>
    70.774    34.315
    70.817    34.360
>
    70.054    34.189
    70.008    34.199
>
    69.995    34.135
    70.018    34.169
>
    71.281    34.526
    71.310    34.489
>
    69.952    34.173
    69.968    34.150
>
    70.396    34.506
    70.439    34.549
>
    70.405    34.511
    70.434    34.517
>
    70.259    34.464
    70.306    34.549
>
    70.840    34.723
    70.940    34.738
>
    70.444    34.673
    70.458    34.714
>
    70.190    34.407
    70.336    34.564
>
    70.290    34.436
    70.290    34.613
>
    70.447    34.299
    70.633    34.492
>
    69.882    34.372
    70.059    34.529
>
    70.258    34.442
    70.377    34.562
>
    70.692    34.180
    70.718    34.318
>
    70.844    34.716
    70.913    34.796
>
    70.695    34.523
    70.753    34.613
>
    70.645    34.721
    70.705    34.766
>
    70.077    34.441
    70.201    34.585
>
    70.678    34.643
    70.728    34.762
>
    70.294    34.322
    70.303    34.545
>
    70.420    34.526
    70.548    34.608
>
    70.530    34.068
    70.673    34.295
>
    69.753    34.586
    69.804    34.669
>
    70.825    34.697
    70.758    34.696
>
    70.623    34.612
    70.764    34.690
>
    70.679    34.605
    70.742    34.705
>
    70.661    34.642
    70.737    34.707
>
    70.654    34.653
    70.718    34.681
>
    70.745    34.581
    70.741    34.658
>
    70.691    34.642
    70.722    34.665
>
    70.614    34.447
    70.578    34.560
>
    70.826    34.176
    70.819    34.241
>
    70.793    34.706
    70.789    34.716
>
    70.882    34.338
    70.814    34.748
>
    70.731    34.702
    70.732    34.691
>
    70.711    34.663
    70.732    34.693
>
    70.772    34.610
    70.732    34.702
>
    70.680    34.717
    70.649    34.670
>
    70.681    34.675
    70.717    34.744
>
    70.724    34.589
    70.799    34.736
>
    70.598    34.460
    70.690    34.667
>
    70.791    34.719
    70.701    34.664
>
    70.652    34.574
    70.574    34.630
>
    70.669    34.692
    70.688    34.657
>
    70.791    34.667
    70.708    34.690
>
    70.748    34.716
    70.651    34.661
>
    70.788    34.697
    70.727    34.707
>
    70.670    34.549
    70.674    34.647
>
    70.662    34.581
    70.679    34.658
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
    71.114    34.918
    71.113    34.919
>
    70.908    34.757
    70.908    34.758
>
    71.009    34.766
    71.005    34.769
>
    70.507    34.734
    70.516    34.726
>
    71.245    35.000
    71.244    35.000
>
    70.651    34.561
    70.647    34.560
>
    70.602    34.647
    70.602    34.651
>
    70.544    34.652
    70.544    34.653
>
    70.488    34.645
    70.488    34.647
>
    70.562    34.688
    70.562    34.688
>
    70.548    34.666
    70.549    34.666
>
    70.555    34.675
    70.556    34.677
>
    70.613    34.702
    70.613    34.703
>
    70.709    34.435
    70.710    34.435
>
    70.604    34.722
    70.603    34.722
>
    70.711    34.695
    70.711    34.695
>
    71.164    34.882
    71.164    34.883
>
    70.776    34.809
    70.773    34.808
>
    70.479    34.667
    70.478    34.667
>
    71.013    34.845
    71.013    34.845
>
    71.605    34.532
    71.610    34.537
>
    70.999    34.814
    70.999    34.815
>
    70.912    34.836
    70.911    34.836
>
    70.671    34.439
    70.675    34.441
>
    70.772    34.545
    70.772    34.545
>
    70.674    34.390
    70.673    34.389
>
    70.424    34.653
    70.427    34.658
>
    70.971    34.715
    70.971    34.716
>
    70.995    34.709
    70.996    34.711
>
    71.041    34.744
    71.041    34.745
>
    70.697    34.167
    70.698    34.167
>
    70.671    34.162
    70.672    34.162
>
    70.618    34.540
    70.618    34.540
>
    70.699    34.513
    70.698    34.514
>
    71.269    34.893
    71.268    34.892
>
    71.571    35.152
    71.569    35.152
>
    70.912    34.732
    70.911    34.733
>
    70.924    34.394
    70.926    34.393
>
    70.117    34.234
    70.117    34.233
>
    70.127    34.202
    70.126    34.203
>
    71.419    34.522
    71.419    34.523
>
    70.076    34.183
    70.076    34.183
>
    70.547    34.583
    70.547    34.583
>
    70.543    34.551
    70.543    34.551
>
    70.415    34.583
    70.415    34.583
>
    71.049    34.772
    71.048    34.771
>
    70.568    34.747
    70.567    34.748
>
    70.444    34.598
    70.445    34.598
>
    70.399    34.647
    70.399    34.647
>
    70.743    34.526
    70.742    34.525
>
    70.169    34.563
    70.168    34.562
>
    70.487    34.596
    70.486    34.596
>
    70.827    34.352
    70.826    34.352
>
    71.022    34.830
    71.022    34.830
>
    70.863    34.647
    70.862    34.646
>
    70.814    34.800
    70.814    34.800
>
    70.310    34.619
    70.310    34.619
>
    70.836    34.795
    70.837    34.795
>
    70.413    34.579
    70.412    34.579
>
    70.658    34.642
    70.657    34.642
>
    70.782    34.330
    70.782    34.329
>
    69.913    34.703
    69.913    34.703
>
    70.867    34.730
    70.867    34.729
>
    70.873    34.724
    70.873    34.724
>
    70.851    34.739
    70.851    34.739
>
    70.846    34.741
    70.846    34.741
>
    70.828    34.715
    70.827    34.715
>
    70.851    34.692
    70.850    34.692
>
    70.832    34.699
    70.831    34.698
>
    70.687    34.595
    70.687    34.594
>
    70.927    34.275
    70.927    34.274
>
    70.898    34.750
    70.898    34.749
>
    70.923    34.782
    70.922    34.782
>
    70.841    34.725
    70.841    34.725
>
    70.841    34.727
    70.841    34.727
>
    70.841    34.736
    70.841    34.735
>
    70.758    34.704
    70.758    34.703
>
    70.826    34.778
    70.826    34.777
>
    70.908    34.771
    70.908    34.770
>
    70.800    34.701
    70.799    34.701
>
    70.810    34.698
    70.809    34.698
>
    70.683    34.664
    70.682    34.664
>
    70.798    34.691
    70.797    34.690
>
    70.817    34.724
    70.817    34.724
>
    70.760    34.695
    70.759    34.694
>
    70.837    34.742
    70.836    34.741
>
    70.783    34.681
    70.783    34.681
>
    70.788    34.692
    70.788    34.692
>
EOF

# Calibration shift (for indirect calibration) in red
gmt plot $proj $reg -Wthin,red << EOF
    71.004    34.886
    71.113    34.919
>
    70.799    34.725
    70.908    34.758
>
    70.897    34.735
    71.005    34.769
>
    70.407    34.693
    70.516    34.726
>
    71.136    34.966
    71.244    35.000
>
    70.539    34.526
    70.647    34.560
>
    70.494    34.617
    70.602    34.651
>
    70.435    34.619
    70.544    34.653
>
    70.380    34.613
    70.488    34.647
>
    70.453    34.654
    70.562    34.688
>
    70.440    34.633
    70.549    34.666
>
    70.447    34.643
    70.556    34.677
>
    70.504    34.669
    70.613    34.703
>
    70.601    34.402
    70.710    34.435
>
    70.494    34.688
    70.603    34.722
>
    70.602    34.661
    70.711    34.695
>
    71.055    34.849
    71.164    34.883
>
    70.664    34.774
    70.773    34.808
>
    70.369    34.633
    70.478    34.667
>
    70.905    34.812
    71.013    34.845
>
    71.501    34.504
    71.610    34.537
>
    70.891    34.781
    70.999    34.815
>
    70.802    34.802
    70.911    34.836
>
    70.566    34.407
    70.675    34.441
>
    70.663    34.512
    70.772    34.545
>
    70.564    34.355
    70.673    34.389
>
    70.318    34.624
    70.427    34.658
>
    70.862    34.682
    70.971    34.716
>
    70.887    34.677
    70.996    34.711
>
    70.932    34.711
    71.041    34.745
>
    70.589    34.133
    70.698    34.167
>
    70.563    34.128
    70.672    34.162
>
    70.509    34.506
    70.618    34.540
>
    70.589    34.480
    70.698    34.514
>
    71.159    34.858
    71.268    34.892
>
    71.461    35.118
    71.569    35.152
>
    70.803    34.699
    70.911    34.733
>
    70.817    34.360
    70.926    34.393
>
    70.008    34.199
    70.117    34.233
>
    70.018    34.169
    70.126    34.203
>
    71.310    34.489
    71.419    34.523
>
    69.968    34.150
    70.076    34.183
>
    70.439    34.549
    70.547    34.583
>
    70.434    34.517
    70.543    34.551
>
    70.306    34.549
    70.415    34.583
>
    70.940    34.738
    71.048    34.771
>
    70.458    34.714
    70.567    34.748
>
    70.336    34.564
    70.445    34.598
>
    70.290    34.613
    70.399    34.647
>
    70.633    34.492
    70.742    34.525
>
    70.059    34.529
    70.168    34.562
>
    70.377    34.562
    70.486    34.596
>
    70.718    34.318
    70.826    34.352
>
    70.913    34.796
    71.022    34.830
>
    70.753    34.613
    70.862    34.646
>
    70.705    34.766
    70.814    34.800
>
    70.201    34.585
    70.310    34.619
>
    70.728    34.762
    70.837    34.795
>
    70.303    34.545
    70.412    34.579
>
    70.548    34.608
    70.657    34.642
>
    70.673    34.295
    70.782    34.329
>
    69.804    34.669
    69.913    34.703
>
    70.758    34.696
    70.867    34.729
>
    70.764    34.690
    70.873    34.724
>
    70.742    34.705
    70.851    34.739
>
    70.737    34.707
    70.846    34.741
>
    70.718    34.681
    70.827    34.715
>
    70.741    34.658
    70.850    34.692
>
    70.722    34.665
    70.831    34.698
>
    70.578    34.560
    70.687    34.594
>
    70.819    34.241
    70.927    34.274
>
    70.789    34.716
    70.898    34.749
>
    70.814    34.748
    70.922    34.782
>
    70.732    34.691
    70.841    34.725
>
    70.732    34.693
    70.841    34.727
>
    70.732    34.702
    70.841    34.735
>
    70.649    34.670
    70.758    34.703
>
    70.717    34.744
    70.826    34.777
>
    70.799    34.736
    70.908    34.770
>
    70.690    34.667
    70.799    34.701
>
    70.701    34.664
    70.809    34.698
>
    70.574    34.630
    70.682    34.664
>
    70.688    34.657
    70.797    34.690
>
    70.708    34.690
    70.817    34.724
>
    70.651    34.661
    70.759    34.694
>
    70.727    34.707
    70.836    34.741
>
    70.674    34.647
    70.783    34.681
>
    70.679    34.658
    70.788    34.692
>
EOF

# Calibration locations marked by a red cross
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
    70.800    34.710     0.200
    70.690    34.670     0.200
EOF

# Residual calibration shift vectors
gmt plot $proj $reg -Wthick,blue << EOF
    70.800    34.710
    70.789    34.716
>
    70.690    34.670
    70.701    34.664
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
    71.004    34.886    55.892     3.912     5.137
    70.799    34.725   -57.364     3.563     4.967
    70.897    34.735   -28.543     2.715     3.785
    70.407    34.693   -42.621     4.360     6.055
    71.136    34.966   -31.297     3.650     4.663
    70.539    34.526   -14.455     4.574     8.061
    70.494    34.617   -66.732     1.519     2.501
    70.435    34.619   -58.296     1.437     2.437
    70.380    34.613   -42.287     1.623     2.795
    70.453    34.654   -46.301     1.598     2.798
    70.440    34.633   -51.405     1.597     2.574
    70.447    34.643   -48.419     1.800     2.866
    70.504    34.669   -24.188     2.200     4.353
    70.601    34.402   -45.822     1.710     4.753
    70.494    34.688   -51.496     2.907     8.432
    70.602    34.661   -54.231     2.473     5.753
    71.055    34.849   -56.371     2.940     7.584
    70.664    34.774   -43.255     3.219     6.928
    70.369    34.633   -38.496     3.203     7.854
    70.905    34.812    40.682     1.843     4.863
    71.501    34.504   -46.352     3.127     9.652
    70.891    34.781   -54.640     2.839     9.068
    70.802    34.802   -38.498     2.936     7.994
    70.566    34.407   -48.996     6.723    14.042
    70.663    34.512   -53.667     1.791     4.055
    70.564    34.355   -57.904     1.770     7.406
    70.318    34.624   -58.482     1.936     6.808
    70.862    34.682   -61.186     1.332     3.741
    70.887    34.677   -57.748     1.525     4.710
    70.932    34.711   -61.910     2.521     5.960
    70.589    34.133   -56.371     1.456     2.288
    70.563    34.128   -29.827     2.199     4.686
    70.509    34.506   -39.899     1.877     3.490
    70.589    34.480   -51.406     1.895     2.998
    71.159    34.858   -35.106     2.522     4.353
    71.461    35.118   -34.814     4.440    10.745
    70.803    34.699   -25.656     3.118     8.255
    70.817    34.360   -33.507     4.027     7.429
    70.008    34.199   -66.977     1.035     2.065
    70.018    34.169   -66.400     1.282     2.273
    71.310    34.489   -39.065     4.062    11.646
    69.968    34.150   -67.546     1.234     2.398
    70.439    34.549   -70.143     1.106     1.685
    70.434    34.517   -39.625     1.661     3.391
    70.306    34.549   -40.007     1.941     3.990
    70.940    34.738   -48.659     2.332     3.298
    70.458    34.714   -50.052     2.108     3.864
    70.336    34.564   -42.808     3.430     5.697
    70.290    34.613   -83.898     2.059     4.012
    70.633    34.492   -78.747     1.941     4.153
    70.059    34.529   -39.294     3.555     4.984
    70.377    34.562   -39.403     2.999     5.012
    70.718    34.318   -62.612     1.719     3.643
    70.913    34.796   -30.482     3.822     5.811
    70.753    34.613   -28.497     4.076     6.079
    70.705    34.766    74.917     2.648     3.856
    70.201    34.585    88.496     3.315     4.787
    70.728    34.762   -53.690     5.593     8.627
    70.303    34.545    87.941     2.236     4.961
    70.548    34.608   -38.975     1.881     2.623
    70.673    34.295   -62.445     2.169     3.679
    69.804    34.669   -86.062     1.203     2.108
    70.758    34.696   -72.958     0.853     1.287
    70.764    34.690   -72.524     1.288     2.076
    70.742    34.705   -55.702     1.370     2.141
    70.737    34.707   -49.009     2.208     4.441
    70.718    34.681    86.122     1.947     3.559
    70.741    34.658   -81.178     1.346     2.151
    70.722    34.665   -77.429     1.267     2.169
    70.578    34.560    79.903     1.488     3.094
    70.819    34.241    79.982     2.843     5.437
    70.789    34.716   -73.224     1.179     1.804
    70.814    34.748    77.278     4.379     6.900
    70.732    34.691   -89.364     1.510     2.191
    70.732    34.693   -76.949     1.538     1.777
    70.732    34.702    40.234     1.861     2.177
    70.649    34.670    41.348     2.385     2.507
    70.717    34.744   -86.941     1.665     2.382
    70.799    34.736    70.285     6.918    12.499
    70.690    34.667    82.175     2.517     3.234
    70.701    34.664   -74.521     0.951     1.461
    70.574    34.630   -10.801     3.533     6.909
    70.688    34.657   -13.462     3.002     6.033
    70.708    34.690   -79.275     1.623     1.992
    70.651    34.661    49.557     2.249     2.549
    70.727    34.707     1.910     2.355     2.550
    70.674    34.647   -86.117     1.589     2.482
    70.679    34.658    41.196     2.449     3.419
EOF

# User-defined ellipses
gmt plot $proj $reg -SE -Wthicker,yellow << EOF
    70.761    34.715    53.000    10.000     6.000
    70.700    34.695    55.000     8.000     4.000
EOF


# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
    70.435    34.619     0.200
    70.789    34.716     0.200
    70.732    34.691     0.100
    70.732    34.693     0.100
    70.717    34.744     0.100
    70.701    34.664     0.100
    70.708    34.690     0.100
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
    69.769    34.082   -40.992     3.058     5.871
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
    69.791    34.082   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
    69.769    34.082     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
    69.769    34.082     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
    69.769    34.037   5 km
EOF
gmt end
