#!/bin/bash
gmt begin kodiak1.21_xsec_1 pdf,ps
proj=-JX18.0/-9.0
reg=-R-142.7/180.4/0/162.0
gmt basemap $proj $reg -Bxa10f10+l'Distance (km)' -Bya10f10+l'Depth (km)' -BWesN+t'Cross-section kodiak1.21'
# Event    1 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   167.297    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   167.297    14.000
   167.297    25.000
EOF
# Event    2 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   140.387    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   140.387     6.000
   140.387    14.000
EOF
# Event    3 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   116.556    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   116.556    15.000
   116.556    23.000
EOF
# Event    4 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   130.031    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   130.031     8.000
   130.031    16.000
EOF
# Event    5 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    48.986    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    48.986    27.000
    48.986    37.000
EOF
# Event    6 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   115.292    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   115.292    15.000
   115.292    23.000
EOF
# Event    7 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.453    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.453    26.000
    30.453    32.000
EOF
# Event    8 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   101.975    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   101.975    12.000
   101.975    20.000
EOF
# Event    9 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -93.348    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -93.348    20.000
   -93.348    44.000
EOF
# Event   10 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    50.771    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    50.771    21.000
    50.771    29.000
EOF
# Event   11 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   131.364    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   131.364    15.000
   131.364    23.000
EOF
# Event   12 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.390    69.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.390    66.000
   -11.390    72.000
EOF
# Event   13 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   148.447    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   148.447     9.000
   148.447    17.000
EOF
# Event   14 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   145.119    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   145.119     9.000
   145.119    17.000
EOF
# Event   15 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   153.365    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   153.365     9.000
   153.365    17.000
EOF
# Event   16 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   175.373     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   175.373     4.000
   175.373    12.000
EOF
# Event   17 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.303    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.303    49.000
    -3.303    55.000
EOF
# Event   18 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.643    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.643    69.000
   -23.643    75.000
EOF
# Event   19 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.828    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.828    54.000
   -18.828    60.000
EOF
# Event   20 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.791    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.791    56.000
    23.791    62.000
EOF
# Event   21 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    55.448    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    55.448    21.000
    55.448    29.000
EOF
# Event   22 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    46.678    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    46.678    34.000
    46.678    40.000
EOF
# Event   23 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -109.736   117.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -109.736   114.000
  -109.736   120.000
EOF
# Event   24 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.732    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.732    46.000
    23.732    52.000
EOF
# Event   25 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    79.309    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    79.309    22.000
    79.309    30.000
EOF
# Event   26 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -65.078    77.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -65.078    74.000
   -65.078    80.000
EOF
# Event   27 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    59.982    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    59.982    26.000
    59.982    60.000
EOF
# Event   28 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.067    76.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.067    73.000
   -21.067    79.000
EOF
# Event   29 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.754    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.754    47.000
    -0.754    53.000
EOF
# Event   30 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -137.670   137.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -137.670   134.000
  -137.670   140.000
EOF
# Event   31 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    58.848    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    58.848     8.000
    58.848    16.000
EOF
# Event   32 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -62.987    73.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -62.987    70.000
   -62.987    76.000
EOF
# Event   33 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.813     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.813     2.000
   -97.813    10.000
EOF
# Event   34 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.434    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.434    55.000
   -37.434    61.000
EOF
# Event   35 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -8.497    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -8.497    60.000
    -8.497    66.000
EOF
# Event   36 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.561    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.561    37.000
    35.561    43.000
EOF
# Event   37 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    94.040    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    94.040    42.000
    94.040    48.000
EOF
# Event   38 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.170    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.170    47.000
    16.170    53.000
EOF
# Event   39 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -60.479    87.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -60.479    84.000
   -60.479    90.000
EOF
# Event   40 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.746    86.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.746    83.000
   -68.746    89.000
EOF
# Event   41 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.820    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.820    26.000
    38.820    44.000
EOF
# Event   42 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.454    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.454    21.000
    51.454    29.000
EOF
# Event   43 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.892    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.892    25.000
    47.892    33.000
EOF
# Event   44 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -100.544   107.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -100.544   104.000
  -100.544   110.000
EOF
# Event   45 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.132    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.132    40.000
    13.132    49.000
EOF
# Event   46 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.605    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.605    44.000
    13.605    49.000
EOF
# Event   47 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.301    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.301     6.000
    65.301    14.000
EOF
# Event   48 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.923    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.923    40.000
    11.923    49.000
EOF
# Event   49 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.907    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.907    45.000
     7.907    51.000
EOF
# Event   50 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.006    69.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.006    66.000
   -56.006    72.000
EOF
# Event   51 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.702    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.702    50.000
    -3.702    56.000
EOF
# Event   52 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.416    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.416    51.000
    41.416    57.000
EOF
# Event   53 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.995    65.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.995    62.000
   -25.995    68.000
EOF
# Event   54 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.585    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.585    52.000
   -12.585    59.000
EOF
# Event   55 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.750   102.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.750    99.000
   -68.750   105.000
EOF
# Event   56 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.788    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.788    56.000
   -25.788    62.000
EOF
# Event   57 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -134.521   146.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -134.521   143.000
  -134.521   149.000
EOF
# Event   58 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.127    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.127    56.000
    -3.127    62.000
EOF
# Event   59 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -89.597   101.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -89.597    98.000
   -89.597   104.000
EOF
# Event   60 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.667    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.667    80.000
   -43.667    86.000
EOF
# Event   61 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -130.896   135.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -130.896   132.000
  -130.896   138.000
EOF
# Event   62 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    57.995    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    57.995    21.000
    57.995    35.000
EOF
# Event   63 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.662    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.662    47.000
    -6.662    56.000
EOF
# Event   64 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    96.034    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    96.034    23.000
    96.034    31.000
EOF
# Event   65 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    90.984    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    90.984    23.000
    90.984    31.000
EOF
# Event   66 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -67.548    92.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -67.548    89.000
   -67.548    95.000
EOF
# Event   67 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.718    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.718    61.000
   -46.718    67.000
EOF
# Event   68 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    63.741    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    63.741    27.000
    63.741    33.000
EOF
# Event   69 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.771    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.771    54.000
    -7.771    60.000
EOF
# Event   70 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.279    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.279    58.000
   -10.279    64.000
EOF
# Event   71 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -71.268    86.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -71.268    83.000
   -71.268    89.000
EOF
# Event   72 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.947    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.947    57.000
   -45.947    63.000
EOF
# Event   73 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.643    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.643    34.000
    38.643    40.000
EOF
# Event   74 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.532    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.532    32.000
    13.532    57.000
EOF
# Event   75 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.675    65.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.675    62.000
   -18.675    68.000
EOF
# Event   76 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    50.934    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    50.934    25.000
    50.934    40.000
EOF
# Event   77 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   131.526    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   131.526    16.000
   131.526    24.000
EOF
# Event   78 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.849    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.849    56.000
    20.849    62.000
EOF
# Event   79 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.651    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.651    47.000
    -4.651    59.000
EOF
# Event   80 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    90.652    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    90.652    17.000
    90.652    23.000
EOF
# Event   81 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.863    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.863    39.000
    29.863    45.000
EOF
# Event   82 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -126.388   144.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -126.388   141.000
  -126.388   147.000
EOF
# Event   83 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.944    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.944    63.000
   -49.944    69.000
EOF
# Event   84 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   145.414    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   145.414    14.000
   145.414    22.000
EOF
# Event   85 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   155.158    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   155.158     9.000
   155.158    17.000
EOF
# Event   86 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    80.200    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    80.200    45.000
    80.200    51.000
EOF
# Event   87 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -65.500    92.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -65.500    89.000
   -65.500    95.000
EOF
# Event   88 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.969    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.969    61.000
   -51.969    67.000
EOF
# Event   89 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    72.402    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    72.402    17.000
    72.402    25.000
EOF
# Event   90 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.330    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.330    24.000
    24.330    46.000
EOF
# Event   91 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -35.024    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -35.024    80.000
   -35.024    86.000
EOF
# Event   92 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.220    98.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.220    95.000
   -69.220   101.000
EOF
# Event   93 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.995    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.995    29.000
    53.995    35.000
EOF
# Event   94 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   145.960    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   145.960    11.000
   145.960    19.000
EOF
# Event   95 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -58.337    90.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -58.337    87.000
   -58.337    93.000
EOF
# Event   96 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.229    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.229    54.000
   -16.229    60.000
EOF
# Event   97 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -95.639    99.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -95.639    96.000
   -95.639   102.000
EOF
# Event   98 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   149.801    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   149.801     9.000
   149.801    17.000
EOF
# Event   99 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.971    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.971    42.000
    21.971    48.000
EOF
# Event  100 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.024    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.024    50.000
    -7.024    56.000
EOF
# Event  101 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -66.934    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -66.934    88.000
   -66.934    94.000
EOF
# Event  102 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.168    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.168    45.000
    18.168    56.000
EOF
# Event  103 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.008    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.008    60.000
   -47.008    66.000
EOF
# Event  104 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.523    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.523    35.000
    51.523    48.000
EOF
# Event  105 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.981    65.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.981    62.000
   -28.981    68.000
EOF
# Event  106 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.845    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.845    47.000
    -2.845    53.000
EOF
# Event  107 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.056    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.056    48.000
     0.056    54.000
EOF
# Event  108 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    87.569    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    87.569    36.000
    87.569    42.000
EOF
# Event  109 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.403    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.403    46.000
    13.403    52.000
EOF
# Event  110 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -75.929    93.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -75.929    90.000
   -75.929    96.000
EOF
# Event  111 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   109.600    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   109.600    13.000
   109.600    21.000
EOF
# Event  112 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   113.703    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   113.703    17.000
   113.703    25.000
EOF
# Event  113 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   152.150    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   152.150     9.000
   152.150    17.000
EOF
# Event  114 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.780    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.780    43.000
   -10.780    49.000
EOF
# Event  115 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.518    71.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.518    68.000
   -56.518    74.000
EOF
# Event  116 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.232    37.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.232    34.000
    44.232    40.000
EOF
# Event  117 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.147    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.147    65.000
   -18.147    71.000
EOF
# Event  118 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -95.584     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -95.584     0.000
   -95.584     4.000
EOF
# Event  119 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.705    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.705    59.000
   -42.705    65.000
EOF
# Event  120 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -83.372    94.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -83.372    91.000
   -83.372    97.000
EOF
# Event  121 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -137.410   143.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -137.410   140.000
  -137.410   146.000
EOF
# Event  122 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.635    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.635    28.000
    52.635    36.000
EOF
# Event  123 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.422     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.422     0.000
   -76.422     5.000
EOF
# Event  124 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -86.323     7.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -86.323     4.000
   -86.323    10.000
EOF
# Event  125 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.768    73.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.768    70.000
   -26.768    76.000
EOF
# Event  126 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    56.795    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    56.795    30.000
    56.795    38.000
EOF
# Event  127 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.574    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.574    44.000
     1.574    50.000
EOF
# Event  128 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   103.017    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   103.017    14.000
   103.017    22.000
EOF
# Event  129 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -60.640    74.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -60.640    71.000
   -60.640    77.000
EOF
# Event  130 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    81.859    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    81.859    22.000
    81.859    28.000
EOF
# Event  131 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.193    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.193    52.000
    23.193    58.000
EOF
# Event  132 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.457    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.457    47.000
    20.457    53.000
EOF
# Event  133 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.991    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.991    55.000
    20.991    61.000
EOF
# Event  134 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -59.624    81.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -59.624    78.000
   -59.624    84.000
EOF
# Event  135 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   109.612    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   109.612    11.000
   109.612    19.000
EOF
# Event  136 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -62.111    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -62.111    69.000
   -62.111    75.000
EOF
# Event  137 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.247    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.247    26.000
    47.247    34.000
EOF
# Event  138 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    97.004    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    97.004    20.000
    97.004    26.000
EOF
# Event  139 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   152.639    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   152.639    18.000
   152.639    26.000
EOF
# Event  140 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.831    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.831    49.000
     0.831    55.000
EOF
# Event  141 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    55.361    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    55.361    15.000
    55.361    23.000
EOF
# Event  142 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -95.346   109.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -95.346   106.000
   -95.346   112.000
EOF
# Event  143 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -34.715    65.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -34.715    62.000
   -34.715    68.000
EOF
# Event  144 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.142    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.142    88.000
   -49.142    94.000
EOF
# Event  145 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -128.889   134.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -128.889   131.000
  -128.889   137.000
EOF
# Event  146 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.033    79.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.033    76.000
   -74.033    82.000
EOF
# Event  147 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.261    95.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.261    92.000
   -73.261    98.000
EOF
# Event  148 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.502    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.502    26.000
    15.502    55.000
EOF
# Event  149 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    97.840    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    97.840    21.000
    97.840    29.000
EOF
# Event  150 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -128.117   134.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -128.117   131.000
  -128.117   137.000
EOF
# Event  151 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.813    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.813    30.000
    39.813    36.000
EOF
# Event  152 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   103.652    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   103.652    19.000
   103.652    27.000
EOF
# Event  153 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -81.858    96.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -81.858    93.000
   -81.858    99.000
EOF
# Event  154 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -85.647    95.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -85.647    92.000
   -85.647    98.000
EOF
# Event  155 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.375     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.375     0.000
    -4.375     4.000
EOF
# Event  156 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    55.137    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    55.137    22.000
    55.137    30.000
EOF
# Event  157 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -126.452   137.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -126.452   134.000
  -126.452   140.000
EOF
# Event  158 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.939    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.939    24.000
    47.939    30.000
EOF
# Event  159 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.630    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.630    53.000
    -3.630    59.000
EOF
# Event  160 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.439    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.439    49.000
    -7.439    55.000
EOF
# Event  161 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.828    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.828    60.000
   -16.828    66.000
EOF
# Event  162 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.752    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.752    80.000
   -69.752    86.000
EOF
# Event  163 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.643    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.643    35.000
    51.643    41.000
EOF
# Event  164 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -34.327    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -34.327    65.000
   -34.327    71.000
EOF
# Event  165 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.131    82.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.131    79.000
   -69.131    85.000
EOF
# Event  166 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -69.875    88.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -69.875    85.000
   -69.875    91.000
EOF
# Event  167 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.969    78.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.969    75.000
    -1.969    81.000
EOF
# Event  168 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.273    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.273    18.000
   -11.273    26.000
EOF
# Event  169 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.354    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.354    59.000
     5.354    65.000
EOF
# Event  170 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.781    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.781    57.000
   -27.781    63.000
EOF
# Event  171 fixed depth, contraint code w
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    78.785    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    78.785    29.000
    78.785    39.000
EOF
# Event  172 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.859    81.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.859    78.000
   -45.859    84.000
EOF
# Event  173 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.019    79.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.019    76.000
   -68.019    82.000
EOF
# Event  174 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    91.268    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    91.268    31.000
    91.268    37.000
EOF
# Event  175 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.177    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.177    53.000
    -6.177    59.000
EOF
# Event  176 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    64.271    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    64.271    22.000
    64.271    30.000
EOF
# Event  177 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.437    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.437    48.000
     7.437    54.000
EOF
# Event  178 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.880    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.880    53.000
    -0.880    59.000
EOF
# Event  179 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -17.313    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -17.313    45.000
   -17.313    51.000
EOF
# Event  180 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.324    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.324    35.000
    45.324    41.000
EOF
# Event  181 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.103    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.103    69.000
   -37.103    75.000
EOF
# Event  182 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -102.707   127.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -102.707   124.000
  -102.707   130.000
EOF
# Event  183 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    49.045    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    49.045    39.000
    49.045    45.000
EOF
# Event  184 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.582    90.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.582    87.000
   -76.582    93.000
EOF
# Event  185 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.238    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.238    54.000
     6.238    60.000
EOF
# Event  186 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    58.836    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    58.836    61.000
    58.836    67.000
EOF
# Event  187 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   101.244    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   101.244    14.000
   101.244    22.000
EOF
# Event  188 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -128.518   133.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -128.518   130.000
  -128.518   136.000
EOF
# Event  189 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.767    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.767    56.000
    20.767    62.000
EOF
# Event  190 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -66.253   103.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -66.253   100.000
   -66.253   106.000
EOF
# Event  191 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    56.653    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    56.653    26.000
    56.653    34.000
EOF
# Event  192 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.804    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.804    65.000
   -19.804    71.000
EOF
# Event  193 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.502    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.502    49.000
   -21.502    55.000
EOF
# Event  194 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -34.889    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -34.889    58.000
   -34.889    64.000
EOF
# Event  195 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -75.100    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -75.100    88.000
   -75.100    94.000
EOF
# Event  196 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.105    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.105    53.000
    37.105    59.000
EOF
# Event  197 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.030    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.030    51.000
   -11.030    57.000
EOF
# Event  198 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.848    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.848    59.000
     1.848    65.000
EOF
# Event  199 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.149    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.149    52.000
    31.149    58.000
EOF
# Event  200 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -51.194    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -51.194    67.000
   -51.194    73.000
EOF
# Event  201 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.632    75.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.632    72.000
   -68.632    78.000
EOF
# Event  202 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.219    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.219    59.000
   -33.219    65.000
EOF
# Event  203 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    54.845    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    54.845    19.000
    54.845    27.000
EOF
# Event  204 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.433    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.433    63.000
   -26.433    69.000
EOF
# Event  205 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   130.689    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   130.689    14.000
   130.689    22.000
EOF
# Event  206 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   129.737    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   129.737    18.000
   129.737    26.000
EOF
# Event  207 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -63.317    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -63.317    88.000
   -63.317    94.000
EOF
# Event  208 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.689    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.689    11.000
    18.689    19.000
EOF
# Event  209 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -64.927    90.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -64.927    87.000
   -64.927    93.000
EOF
# Event  210 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.802    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.802    56.000
   -33.802    62.000
EOF
# Event  211 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -67.730    84.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -67.730    81.000
   -67.730    87.000
EOF
# Event  212 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.012    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.012    55.000
    24.012    61.000
EOF
# Event  213 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     8.343    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     8.343    45.000
     8.343    51.000
EOF
# Event  214 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -122.463   133.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -122.463   130.000
  -122.463   136.000
EOF
# Event  215 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   139.048    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   139.048    16.000
   139.048    24.000
EOF
# Event  216 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   100.709    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   100.709    25.000
   100.709    31.000
EOF
# Event  217 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.211    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.211    49.000
    41.211    55.000
EOF
# Event  218 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -61.828    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -61.828    88.000
   -61.828    94.000
EOF
# Event  219 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    99.395    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    99.395    25.000
    99.395    33.000
EOF
# Event  220 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.054    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.054    44.000
    38.054    50.000
EOF
# Event  221 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    19.516    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    19.516    47.000
    19.516    53.000
EOF
# Event  222 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.968     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.968     2.000
   -29.968    10.000
EOF
# Event  223 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.612     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.612     4.000
   -36.612    12.000
EOF
# Event  224 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -98.497   111.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -98.497   108.000
   -98.497   114.000
EOF
# Event  225 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.809    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.809    41.000
    -5.809    47.000
EOF
# Event  226 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.827    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.827    16.000
    52.827    24.000
EOF
# Event  227 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   117.336    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   117.336    18.000
   117.336    26.000
EOF
# Event  228 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   113.283    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   113.283    17.000
   113.283    25.000
EOF
# Event  229 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   109.103    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   109.103    20.000
   109.103    28.000
EOF
# Event  230 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    54.559    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    54.559    22.000
    54.559    30.000
EOF
# Event  231 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.670    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.670    59.000
   -23.670    65.000
EOF
# Event  232 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -96.106   109.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -96.106   106.000
   -96.106   112.000
EOF
# Event  233 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.392    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.392    37.000
    53.392    43.000
EOF
# Event  234 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.599    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.599    45.000
   -13.599    51.000
EOF
# Event  235 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    64.444    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    64.444    26.000
    64.444    32.000
EOF
# Event  236 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.586    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.586    69.000
   -50.586    75.000
EOF
# Event  237 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -125.355   141.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -125.355   138.000
  -125.355   144.000
EOF
# Event  238 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.335    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.335    11.000
   -27.335    17.000
EOF
# Event  239 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.403    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.403    46.000
    -2.403    52.000
EOF
# Event  240 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    56.405    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    56.405    19.000
    56.405    27.000
EOF
# Event  241 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -135.105   143.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -135.105   140.000
  -135.105   146.000
EOF
# Event  242 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.576    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.576    50.000
    -9.576    56.000
EOF
# Event  243 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.788    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.788    69.000
   -50.788    75.000
EOF
# Event  244 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.702    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.702    80.000
   -49.702    86.000
EOF
# Event  245 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.380     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.380     2.000
   -47.380    10.000
EOF
# Event  246 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -102.255     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -102.255     3.000
  -102.255     9.000
EOF
# Event  247 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.448    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.448    30.000
    47.448    36.000
EOF
# Event  248 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.707    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.707    33.000
    47.707    39.000
EOF
# Event  249 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.390    28.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.390    24.000
    39.390    32.000
EOF
# Event  250 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    95.589    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    95.589    15.000
    95.589    23.000
EOF
# Event  251 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.800    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.800    59.000
   -41.800    65.000
EOF
# Event  252 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -68.330    82.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -68.330    79.000
   -68.330    85.000
EOF
# Event  253 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.145    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.145    42.000
    47.145    48.000
EOF
# Event  254 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    90.696    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    90.696    27.000
    90.696    33.000
EOF
# Event  255 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    99.909    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    99.909    23.000
    99.909    31.000
EOF
# Event  256 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.733     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.733     4.000
   -40.733    12.000
EOF
# Event  257 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.050    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.050    38.000
    30.050    44.000
EOF
# Event  258 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    21.543    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    21.543    43.000
    21.543    51.000
EOF
# Event  259 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    41.971     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    41.971     1.000
    41.971     9.000
EOF
# Event  260 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -104.406   124.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -104.406   121.000
  -104.406   127.000
EOF
# Event  261 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -129.859   139.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -129.859   136.000
  -129.859   142.000
EOF
# Event  262 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.512    76.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.512    73.000
   -39.512    79.000
EOF
# Event  263 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   130.686    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   130.686    16.000
   130.686    24.000
EOF
# Event  264 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   132.692    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   132.692    20.000
   132.692    28.000
EOF
# Event  265 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   141.528    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   141.528    19.000
   141.528    27.000
EOF
# Event  266 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -52.677    77.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -52.677    74.000
   -52.677    80.000
EOF
# Event  267 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.139    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.139    47.000
     1.139    53.000
EOF
# Event  268 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -104.163     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -104.163     2.000
  -104.163     8.000
EOF
# Event  269 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -63.585    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -63.585    11.000
   -63.585    19.000
EOF
# Event  270 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -63.845    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -63.845    12.000
   -63.845    20.000
EOF
# Event  271 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -66.522    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -66.522    11.000
   -66.522    19.000
EOF
# Event  272 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    47.670    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    47.670    50.000
    47.670    56.000
EOF
# Event  273 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    61.162    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    61.162    18.000
    61.162    26.000
EOF
# Event  274 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   115.757    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   115.757    17.000
   115.757    25.000
EOF
# Event  275 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.386    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.386    55.000
   -41.386    61.000
EOF
# Event  276 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.500    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.500    51.000
   -25.500    57.000
EOF
# Event  277 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.770    74.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.770    71.000
   -45.770    77.000
EOF
# Event  278 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -34.518    78.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -34.518    75.000
   -34.518    81.000
EOF
# Event  279 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    48.959    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    48.959    22.000
    48.959    30.000
EOF
# Event  280 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.166    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.166    57.000
   -45.166    63.000
EOF
# Event  281 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    55.594    42.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    55.594    39.000
    55.594    45.000
EOF
# Event  282 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   100.795    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   100.795    17.000
   100.795    23.000
EOF
# Event  283 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -22.394    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -22.394    61.000
   -22.394    67.000
EOF
# Event  284 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.285    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.285    88.000
   -76.285    94.000
EOF
# Event  285 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -76.521    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -76.521    80.000
   -76.521    86.000
EOF
# Event  286 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -111.207   125.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -111.207   122.000
  -111.207   128.000
EOF
# Event  287 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.080    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.080    45.000
    -0.080    51.000
EOF
# Event  288 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.455    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.455    36.000
    31.455    42.000
EOF
# Event  289 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.562    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.562    56.000
   -33.562    62.000
EOF
# Event  290 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.001    77.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.001    74.000
   -40.001    80.000
EOF
# Event  291 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -12.792    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -12.792    51.000
   -12.792    57.000
EOF
# Event  292 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -119.306   127.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -119.306   124.000
  -119.306   130.000
EOF
# Event  293 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -121.428   132.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -121.428   129.000
  -121.428   135.000
EOF
# Event  294 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.298    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.298    67.000
   -46.298    73.000
EOF
# Event  295 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -103.882   115.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -103.882   112.000
  -103.882   118.000
EOF
# Event  296 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    86.807    26.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    86.807    23.000
    86.807    29.000
EOF
# Event  297 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   107.141    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   107.141    20.000
   107.141    28.000
EOF
# Event  298 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.440    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.440    30.000
    29.440    36.000
EOF
# Event  299 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.048    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.048    50.000
     1.048    56.000
EOF
# Event  300 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    57.895    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    57.895    27.000
    57.895    35.000
EOF
# Event  301 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    58.710    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    58.710    27.000
    58.710    35.000
EOF
# Event  302 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.072    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.072    21.000
    33.072    29.000
EOF
# Event  303 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -47.537    69.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -47.537    66.000
   -47.537    72.000
EOF
# Event  304 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.908    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.908    50.000
   -33.908    56.000
EOF
# Event  305 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.286    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.286    53.000
   -24.286    59.000
EOF
# Event  306 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    39.337    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    39.337    44.000
    39.337    50.000
EOF
# Event  307 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.915    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.915    49.000
    -2.915    55.000
EOF
# Event  308 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -46.055     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -46.055     2.000
   -46.055    10.000
EOF
# Event  309 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.886    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.886    19.000
    53.886    27.000
EOF
# Event  310 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -75.438    86.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -75.438    83.000
   -75.438    89.000
EOF
# Event  311 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     6.082    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     6.082    42.000
     6.082    48.000
EOF
# Event  312 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -63.296    78.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -63.296    75.000
   -63.296    81.000
EOF
# Event  313 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    70.141    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    70.141    41.000
    70.141    47.000
EOF
# Event  314 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.429    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.429    58.000
   -10.429    64.000
EOF
# Event  315 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.743     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.743     0.000
    44.743     8.000
EOF
# Event  316 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    42.859    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    42.859     9.000
    42.859    17.000
EOF
# Event  317 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.878    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.878    59.000
   -42.878    65.000
EOF
# Event  318 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.152    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.152    44.000
    10.152    50.000
EOF
# Event  319 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.225    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.225    80.000
   -73.225    86.000
EOF
# Event  320 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   138.001    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   138.001    19.000
   138.001    27.000
EOF
# Event  321 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   130.388    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   130.388    20.000
   130.388    28.000
EOF
# Event  322 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   145.403    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   145.403    19.000
   145.403    27.000
EOF
# Event  323 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   138.239    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   138.239    17.000
   138.239    25.000
EOF
# Event  324 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   148.349    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   148.349     9.000
   148.349    17.000
EOF
# Event  325 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   150.309    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   150.309    19.000
   150.309    27.000
EOF
# Event  326 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   101.953    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   101.953    23.000
   101.953    31.000
EOF
# Event  327 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -11.426    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -11.426    53.000
   -11.426    59.000
EOF
# Event  328 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    85.515    31.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    85.515    28.000
    85.515    34.000
EOF
# Event  329 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.351    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.351    67.000
   -50.351    73.000
EOF
# Event  330 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.688    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.688    49.000
    45.688    55.000
EOF
# Event  331 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   118.249    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   118.249    27.000
   118.249    33.000
EOF
# Event  332 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   123.558    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   123.558    21.000
   123.558    29.000
EOF
# Event  333 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.460    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.460    58.000
   -24.460    64.000
EOF
# Event  334 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   121.283    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   121.283    19.000
   121.283    27.000
EOF
# Event  335 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.833    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.833    47.000
    16.833    53.000
EOF
# Event  336 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    34.774    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    34.774    47.000
    34.774    53.000
EOF
# Event  337 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.630    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.630    61.000
    33.630    67.000
EOF
# Event  338 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   150.297    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   150.297    18.000
   150.297    26.000
EOF
# Event  339 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -54.319    73.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -54.319    70.000
   -54.319    76.000
EOF
# Event  340 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -62.349    90.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -62.349    87.000
   -62.349    93.000
EOF
# Event  341 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    55.508    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    55.508    19.000
    55.508    27.000
EOF
# Event  342 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.691    57.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.691    54.000
     1.691    60.000
EOF
# Event  343 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -13.666    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -13.666    67.000
   -13.666    73.000
EOF
# Event  344 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.401    86.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.401    83.000
   -77.401    89.000
EOF
# Event  345 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.133    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.133     7.000
   -19.133    15.000
EOF
# Event  346 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    81.987    30.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    81.987    27.000
    81.987    33.000
EOF
# Event  347 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -19.478     7.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -19.478     3.000
   -19.478    11.000
EOF
# Event  348 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.563     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.563     4.000
   -36.563    12.000
EOF
# Event  349 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -89.074   105.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -89.074   102.000
   -89.074   108.000
EOF
# Event  350 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.130     1.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.130     0.000
     7.130     5.000
EOF
# Event  351 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     5.172    59.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     5.172    56.000
     5.172    62.000
EOF
# Event  352 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.309    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.309     7.000
   -14.309    15.000
EOF
# Event  353 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -54.630    76.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -54.630    73.000
   -54.630    79.000
EOF
# Event  354 fixed depth, contraint code d
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.520    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.520    48.000
    -4.520    60.000
EOF
# Event  355 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.560    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.560    55.000
    -4.560    61.000
EOF
# Event  356 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -54.242    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -54.242    65.000
   -54.242    71.000
EOF
# Event  357 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.865    82.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.865    79.000
   -37.865    85.000
EOF
# Event  358 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.905    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.905    21.000
    44.905    29.000
EOF
# Event  359 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.922    73.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.922    70.000
     1.922    76.000
EOF
# Event  360 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.888    84.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.888    81.000
   -56.888    87.000
EOF
# Event  361 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -37.359    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -37.359    80.000
   -37.359    86.000
EOF
# Event  362 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    78.536    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    78.536    24.000
    78.536    30.000
EOF
# Event  363 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.089    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.089     8.000
    65.089    16.000
EOF
# Event  364 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -28.073    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -28.073    63.000
   -28.073    69.000
EOF
# Event  365 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.102    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.102    88.000
   -77.102    94.000
EOF
# Event  366 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -121.725   136.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -121.725   133.000
  -121.725   139.000
EOF
# Event  367 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -52.095     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -52.095     1.000
   -52.095     9.000
EOF
# Event  368 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -52.196     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -52.196     4.000
   -52.196    12.000
EOF
# Event  369 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -50.867    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -50.867    61.000
   -50.867    67.000
EOF
# Event  370 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -96.072     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -96.072     3.000
   -96.072     9.000
EOF
# Event  371 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   103.593    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   103.593    19.000
   103.593    27.000
EOF
# Event  372 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.404    66.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.404    63.000
   -10.404    69.000
EOF
# Event  373 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -63.927    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -63.927    10.000
   -63.927    18.000
EOF
# Event  374 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -78.257    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -78.257     6.000
   -78.257    14.000
EOF
# Event  375 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -15.661    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -15.661    10.000
   -15.661    18.000
EOF
# Event  376 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.279    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.279    21.000
    51.279    29.000
EOF
# Event  377 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -93.173     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -93.173     0.000
   -93.173     7.000
EOF
# Event  378 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -91.460   101.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -91.460    98.000
   -91.460   104.000
EOF
# Event  379 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.476     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.476     0.000
   -97.476     8.000
EOF
# Event  380 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.843    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.843    37.000
    44.843    43.000
EOF
# Event  381 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    28.974    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    28.974    46.000
    28.974    52.000
EOF
# Event  382 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.987    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.987    48.000
    15.987    54.000
EOF
# Event  383 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -20.415    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -20.415    50.000
   -20.415    56.000
EOF
# Event  384 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -23.759    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -23.759    55.000
   -23.759    61.000
EOF
# Event  385 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -58.167    74.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -58.167    71.000
   -58.167    77.000
EOF
# Event  386 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -43.218    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -43.218    59.000
   -43.218    65.000
EOF
# Event  387 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.602    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.602    31.000
    33.602    37.000
EOF
# Event  388 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -61.508    88.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -61.508    85.000
   -61.508    91.000
EOF
# Event  389 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.977    85.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.977    82.000
   -40.977    88.000
EOF
# Event  390 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.231    46.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.231    43.000
    -4.231    49.000
EOF
# Event  391 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.613    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.613    59.000
   -41.613    65.000
EOF
# Event  392 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.254    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.254    38.000
    -3.254    44.000
EOF
# Event  393 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    44.311    38.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    44.311    35.000
    44.311    41.000
EOF
# Event  394 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -6.786    52.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -6.786    49.000
    -6.786    55.000
EOF
# Event  395 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.076    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.076    69.000
   -18.076    75.000
EOF
# Event  396 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -62.290    69.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -62.290    66.000
   -62.290    72.000
EOF
# Event  397 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -42.201    68.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -42.201    65.000
   -42.201    71.000
EOF
# Event  398 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -95.871   107.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -95.871   104.000
   -95.871   110.000
EOF
# Event  399 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -36.546    73.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -36.546    70.000
   -36.546    76.000
EOF
# Event  400 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.042    51.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.042    48.000
     4.042    54.000
EOF
# Event  401 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -81.197    91.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -81.197    88.000
   -81.197    94.000
EOF
# Event  402 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -134.284   157.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -134.284   154.000
  -134.284   160.000
EOF
# Event  403 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.331    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.331    60.000
    -2.331    66.000
EOF
# Event  404 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.324     2.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.324     0.000
   -97.324     6.000
EOF
# Event  405 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.071    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.071    57.000
    38.071    63.000
EOF
# Event  406 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.240    63.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.240    60.000
   -26.240    66.000
EOF
# Event  407 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.600    70.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.600    67.000
   -10.600    73.000
EOF
# Event  408 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.866     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.866     1.000
   -97.866     7.000
EOF
# Event  409 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.978    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.978    14.000
    24.978    22.000
EOF
# Event  410 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -33.168    72.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -33.168    69.000
   -33.168    75.000
EOF
# Event  411 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -96.423     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -96.423     1.000
   -96.423     7.000
EOF
# Event  412 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.939    77.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.939    74.000
   -49.939    80.000
EOF
# Event  413 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    45.867    55.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    45.867    52.000
    45.867    58.000
EOF
# Event  414 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.526     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.526     5.000
   -26.526    13.000
EOF
# Event  415 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -72.143    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -72.143    80.000
   -72.143    86.000
EOF
# Event  416 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -98.445     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -98.445     2.000
   -98.445     8.000
EOF
# Event  417 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -45.293    65.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -45.293    62.000
   -45.293    68.000
EOF
# Event  418 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -95.399     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -95.399     1.000
   -95.399     7.000
EOF
# Event  419 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -96.970     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -96.970     2.000
   -96.970     8.000
EOF
# Event  420 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -96.692     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -96.692     2.000
   -96.692     8.000
EOF
# Event  421 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.227     2.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.227     0.000
   -97.227     5.000
EOF
# Event  422 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.941    64.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.941    61.000
   -24.941    67.000
EOF
# Event  423 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.807     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.807     0.000
   -97.807     6.000
EOF
# Event  424 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -65.306    97.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -65.306    94.000
   -65.306   100.000
EOF
# Event  425 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -75.268    98.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -75.268    95.000
   -75.268   101.000
EOF
# Event  426 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -44.815    83.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -44.815    80.000
   -44.815    86.000
EOF
# Event  427 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.292    80.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.292    77.000
   -24.292    83.000
EOF
# Event  428 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -62.812    86.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -62.812    83.000
   -62.812    89.000
EOF
# Event  429 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.576    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.576    42.000
    43.576    48.000
EOF
# Event  430 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -96.203     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -96.203     3.000
   -96.203     9.000
EOF
# Event  431 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    66.917    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    66.917    50.000
    66.917    56.000
EOF
# Event  432 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.428    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.428    18.000
    17.428    25.000
EOF
# Event  433 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -64.721    90.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -64.721    87.000
   -64.721    93.000
EOF
# Event  434 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -21.087    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -21.087    51.000
   -21.087    57.000
EOF
# Event  435 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    83.673    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    83.673    44.000
    83.673    50.000
EOF
# Event  436 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    29.943    34.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    29.943    31.000
    29.943    37.000
EOF
# Event  437 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -121.569   133.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -121.569   130.000
  -121.569   136.000
EOF
# Event  438 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -77.017    82.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -77.017    79.000
   -77.017    85.000
EOF
# Event  439 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    16.317    44.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    16.317    41.000
    16.317    47.000
EOF
# Event  440 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   157.245    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   157.245    10.000
   157.245    18.000
EOF
# Event  441 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.148    47.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.148    44.000
    30.148    50.000
EOF
# Event  442 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   111.215    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   111.215    19.000
   111.215    27.000
EOF
# Event  443 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    38.533    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    38.533    58.000
    38.533    64.000
EOF
# Event  444 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    43.580    39.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    43.580    36.000
    43.580    42.000
EOF
# Event  445 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -125.948   139.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -125.948   136.000
  -125.948   142.000
EOF
# Event  446 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -56.117    82.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -56.117    79.000
   -56.117    85.000
EOF
# Event  447 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    93.961    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    93.961    20.000
    93.961    26.000
EOF
# Event  448 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -125.053   132.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -125.053   129.000
  -125.053   135.000
EOF
# Event  449 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -107.470     4.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -107.470     0.000
  -107.470     8.000
EOF
# Event  450 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    27.740    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    27.740     9.000
    27.740    17.000
EOF
# Event  451 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    23.382    50.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    23.382    47.000
    23.382    53.000
EOF
# Event  452 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -57.168    81.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -57.168    78.000
   -57.168    84.000
EOF
# Event  453 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -115.749   127.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -115.749   124.000
  -115.749   130.000
EOF
# Event  454 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    20.776     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    20.776     0.000
    20.776     4.000
EOF
# Event  455 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -87.826   102.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -87.826    99.000
   -87.826   105.000
EOF
# Event  456 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   101.510    29.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   101.510    25.000
   101.510    33.000
EOF
# Event  457 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   103.646    23.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   103.646    19.000
   103.646    27.000
EOF
# Event  458 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   103.396    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   103.396    18.000
   103.396    26.000
EOF
# Event  459 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.119    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.119    32.000
    35.119    38.000
EOF
# Event  460 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   121.828    24.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   121.828    20.000
   121.828    28.000
EOF
# Event  461 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   117.147    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   117.147    21.000
   117.147    29.000
EOF
# Event  462 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   117.290    27.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   117.290    23.000
   117.290    31.000
EOF
# Event  463 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.887    62.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.887    59.000
    17.887    65.000
EOF
# Event  464 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.814    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.814    32.000
    -3.814    38.000
EOF
# Event  465 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -26.648    61.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -26.648    58.000
   -26.648    64.000
EOF
# Event  466 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.801    54.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.801    51.000
    -5.801    57.000
EOF
# Event  467 fixed depth, contraint code w
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.225    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.225    31.000
    65.225    41.000
EOF
# Event  468 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.002    53.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.002    50.000
    -4.002    56.000
EOF
# Event  469 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -91.961   112.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -91.961   109.000
   -91.961   115.000
EOF
# Event  470 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.042     0.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.042     0.000
    18.042     4.000
EOF
# Event  471 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.516     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.516     4.000
    24.516    12.000
EOF
# Event  472 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    52.069    32.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    52.069    29.000
    52.069    35.000
EOF
# Event  473 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -25.402    74.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -25.402    71.000
   -25.402    77.000
EOF
# Event  474 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -27.716    58.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -27.716    55.000
   -27.716    61.000
EOF
# Event  475 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -24.370    60.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -24.370    57.000
   -24.370    63.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p,Helvetica,black+a0.+jBL << EOF
   167.497    16.000 1
   140.587    10.000 2
   116.756    19.000 3
   130.231    12.000 4
    49.186    33.000 5
   115.492    19.000 6
    30.653    29.000 7
   102.175    16.000 8
   -93.148    36.000 9
    50.971    25.000 10
   131.564    19.000 11
   -11.190    69.000 12
   148.647    13.000 13
   145.319    13.000 14
   153.565    13.000 15
   175.573     8.000 16
    -3.103    52.000 17
   -23.443    72.000 18
   -18.628    57.000 19
    23.991    59.000 20
    55.648    25.000 21
    46.878    37.000 22
  -109.536   117.000 23
    23.932    49.000 24
    79.509    26.000 25
   -64.878    77.000 26
    60.182    50.000 27
   -20.867    76.000 28
    -0.554    50.000 29
  -137.470   137.000 30
    59.048    12.000 31
   -62.787    73.000 32
   -97.613     6.000 33
   -37.234    58.000 34
    -8.297    63.000 35
    35.761    40.000 36
    94.240    45.000 37
    16.370    50.000 38
   -60.279    87.000 39
   -68.546    86.000 40
    39.020    37.000 41
    51.654    25.000 42
    48.092    29.000 43
  -100.344   107.000 44
    13.332    44.000 45
    13.805    46.000 46
    65.501    10.000 47
    12.123    45.000 48
     8.107    48.000 49
   -55.806    69.000 50
    -3.502    53.000 51
    41.616    54.000 52
   -25.795    65.000 53
   -12.385    55.000 54
   -68.550   102.000 55
   -25.588    59.000 56
  -134.321   146.000 57
    -2.927    59.000 58
   -89.397   101.000 59
   -43.467    83.000 60
  -130.696   135.000 61
    58.195    23.000 62
    -6.462    51.000 63
    96.234    27.000 64
    91.184    27.000 65
   -67.348    92.000 66
   -46.518    64.000 67
    63.941    31.000 68
    -7.571    57.000 69
   -10.079    61.000 70
   -71.068    86.000 71
   -45.747    60.000 72
    38.843    37.000 73
    13.732    36.000 74
   -18.475    65.000 75
    51.134    26.000 76
   131.726    20.000 77
    21.049    59.000 78
    -4.451    53.000 79
    90.852    20.000 80
    30.063    42.000 81
  -126.188   144.000 82
   -49.744    66.000 83
   145.614    18.000 84
   155.358    13.000 85
    80.400    48.000 86
   -65.300    92.000 87
   -51.769    64.000 88
    72.602    21.000 89
    24.530    27.000 90
   -34.824    83.000 91
   -69.021    98.000 92
    54.195    32.000 93
   146.160    15.000 94
   -58.137    90.000 95
   -16.029    57.000 96
   -95.439    99.000 97
   150.001    13.000 98
    22.171    45.000 99
    -6.824    53.000 100
   -66.734    91.000 101
    18.368    51.000 102
   -46.808    63.000 103
    51.723    41.000 104
   -28.781    65.000 105
    -2.645    50.000 106
     0.256    51.000 107
    87.769    39.000 108
    13.603    49.000 109
   -75.729    93.000 110
   109.800    17.000 111
   113.903    21.000 112
   152.350    13.000 113
   -10.580    46.000 114
   -56.318    71.000 115
    44.432    37.000 116
   -17.947    68.000 117
   -95.384     0.000 118
   -42.505    62.000 119
   -83.172    94.000 120
  -137.210   143.000 121
    52.835    32.000 122
   -76.222     1.000 123
   -86.123     7.000 124
   -26.568    73.000 125
    56.995    34.000 126
     1.774    47.000 127
   103.217    18.000 128
   -60.440    74.000 129
    82.059    25.000 130
    23.393    55.000 131
    20.657    50.000 132
    21.191    58.000 133
   -59.424    81.000 134
   109.812    15.000 135
   -61.911    72.000 136
    47.447    30.000 137
    97.204    23.000 138
   152.839    22.000 139
     1.031    52.000 140
    55.561    19.000 141
   -95.146   109.000 142
   -34.515    65.000 143
   -48.942    91.000 144
  -128.689   134.000 145
   -73.833    79.000 146
   -73.061    95.000 147
    15.702    47.000 148
    98.040    25.000 149
  -127.917   134.000 150
    40.013    33.000 151
   103.852    23.000 152
   -81.658    96.000 153
   -85.447    95.000 154
    -4.175     0.000 155
    55.337    26.000 156
  -126.252   137.000 157
    48.139    27.000 158
    -3.430    56.000 159
    -7.239    52.000 160
   -16.628    63.000 161
   -69.552    83.000 162
    51.843    38.000 163
   -34.127    68.000 164
   -68.931    82.000 165
   -69.675    88.000 166
    -1.769    78.000 167
   -11.073    22.000 168
     5.554    62.000 169
   -27.581    60.000 170
    78.985    34.000 171
   -45.659    81.000 172
   -67.819    79.000 173
    91.468    34.000 174
    -5.977    56.000 175
    64.471    26.000 176
     7.637    51.000 177
    -0.680    56.000 178
   -17.113    48.000 179
    45.524    38.000 180
   -36.903    72.000 181
  -102.507   127.000 182
    49.245    42.000 183
   -76.382    90.000 184
     6.438    57.000 185
    59.036    64.000 186
   101.444    18.000 187
  -128.318   133.000 188
    20.967    59.000 189
   -66.053   103.000 190
    56.853    30.000 191
   -19.604    68.000 192
   -21.302    52.000 193
   -34.689    61.000 194
   -74.900    91.000 195
    37.305    56.000 196
   -10.830    54.000 197
     2.048    62.000 198
    31.349    55.000 199
   -50.994    70.000 200
   -68.432    75.000 201
   -33.019    62.000 202
    55.045    23.000 203
   -26.233    66.000 204
   130.889    18.000 205
   129.937    22.000 206
   -63.117    91.000 207
    18.889    15.000 208
   -64.727    90.000 209
   -33.602    59.000 210
   -67.530    84.000 211
    24.212    58.000 212
     8.543    48.000 213
  -122.263   133.000 214
   139.248    20.000 215
   100.909    28.000 216
    41.411    52.000 217
   -61.628    91.000 218
    99.595    29.000 219
    38.254    47.000 220
    19.716    50.000 221
   -29.768     6.000 222
   -36.412     8.000 223
   -98.297   111.000 224
    -5.609    44.000 225
    53.027    20.000 226
   117.536    22.000 227
   113.483    21.000 228
   109.303    24.000 229
    54.759    26.000 230
   -23.470    62.000 231
   -95.906   109.000 232
    53.592    40.000 233
   -13.399    48.000 234
    64.644    29.000 235
   -50.386    72.000 236
  -125.155   141.000 237
   -27.135    14.000 238
    -2.203    49.000 239
    56.605    23.000 240
  -134.905   143.000 241
    -9.376    53.000 242
   -50.588    72.000 243
   -49.502    83.000 244
   -47.180     6.000 245
  -102.055     6.000 246
    47.648    33.000 247
    47.907    36.000 248
    39.590    28.000 249
    95.789    19.000 250
   -41.600    62.000 251
   -68.130    82.000 252
    47.345    45.000 253
    90.896    30.000 254
   100.109    27.000 255
   -40.533     8.000 256
    30.250    41.000 257
    21.743    46.000 258
    42.171     5.000 259
  -104.206   124.000 260
  -129.659   139.000 261
   -39.312    76.000 262
   130.886    20.000 263
   132.892    24.000 264
   141.728    23.000 265
   -52.477    77.000 266
     1.339    50.000 267
  -103.963     5.000 268
   -63.385    15.000 269
   -63.645    16.000 270
   -66.322    15.000 271
    47.870    53.000 272
    61.362    22.000 273
   115.957    21.000 274
   -41.186    58.000 275
   -25.300    54.000 276
   -45.570    74.000 277
   -34.318    78.000 278
    49.159    26.000 279
   -44.966    60.000 280
    55.794    42.000 281
   100.995    20.000 282
   -22.194    64.000 283
   -76.085    91.000 284
   -76.321    83.000 285
  -111.007   125.000 286
     0.120    48.000 287
    31.655    39.000 288
   -33.362    59.000 289
   -39.801    77.000 290
   -12.592    54.000 291
  -119.106   127.000 292
  -121.228   132.000 293
   -46.098    70.000 294
  -103.682   115.000 295
    87.007    26.000 296
   107.341    24.000 297
    29.640    33.000 298
     1.248    53.000 299
    58.095    31.000 300
    58.910    31.000 301
    33.272    25.000 302
   -47.337    69.000 303
   -33.708    53.000 304
   -24.086    56.000 305
    39.537    47.000 306
    -2.715    52.000 307
   -45.855     6.000 308
    54.086    23.000 309
   -75.238    86.000 310
     6.282    45.000 311
   -63.096    78.000 312
    70.341    44.000 313
   -10.229    61.000 314
    44.943     4.000 315
    43.059    13.000 316
   -42.678    62.000 317
    10.352    47.000 318
   -73.025    83.000 319
   138.201    23.000 320
   130.588    24.000 321
   145.603    23.000 322
   138.439    21.000 323
   148.549    13.000 324
   150.509    23.000 325
   102.153    27.000 326
   -11.226    56.000 327
    85.715    31.000 328
   -50.151    70.000 329
    45.888    52.000 330
   118.449    30.000 331
   123.758    25.000 332
   -24.260    61.000 333
   121.483    23.000 334
    17.033    50.000 335
    34.974    50.000 336
    33.830    64.000 337
   150.497    22.000 338
   -54.119    73.000 339
   -62.149    90.000 340
    55.708    23.000 341
     1.891    57.000 342
   -13.466    70.000 343
   -77.201    86.000 344
   -18.933    11.000 345
    82.187    30.000 346
   -19.278     7.000 347
   -36.363     8.000 348
   -88.874   105.000 349
     7.330     1.000 350
     5.372    59.000 351
   -14.109    11.000 352
   -54.430    76.000 353
    -4.320    54.000 354
    -4.360    58.000 355
   -54.042    68.000 356
   -37.665    82.000 357
    45.105    25.000 358
     2.122    73.000 359
   -56.688    84.000 360
   -37.159    83.000 361
    78.736    27.000 362
    65.289    12.000 363
   -27.873    66.000 364
   -76.902    91.000 365
  -121.525   136.000 366
   -51.895     5.000 367
   -51.996     8.000 368
   -50.667    64.000 369
   -95.872     6.000 370
   103.793    23.000 371
   -10.204    66.000 372
   -63.727    14.000 373
   -78.057    10.000 374
   -15.461    14.000 375
    51.479    25.000 376
   -92.973     3.000 377
   -91.260   101.000 378
   -97.276     4.000 379
    45.043    40.000 380
    29.174    49.000 381
    16.187    51.000 382
   -20.215    53.000 383
   -23.559    58.000 384
   -57.967    74.000 385
   -43.018    62.000 386
    33.802    34.000 387
   -61.308    88.000 388
   -40.777    85.000 389
    -4.031    46.000 390
   -41.413    62.000 391
    -3.054    41.000 392
    44.511    38.000 393
    -6.586    52.000 394
   -17.876    72.000 395
   -62.090    69.000 396
   -42.001    68.000 397
   -95.671   107.000 398
   -36.346    73.000 399
     4.242    51.000 400
   -80.997    91.000 401
  -134.084   157.000 402
    -2.131    63.000 403
   -97.124     2.000 404
    38.271    60.000 405
   -26.040    63.000 406
   -10.400    70.000 407
   -97.666     4.000 408
    25.178    18.000 409
   -32.968    72.000 410
   -96.223     4.000 411
   -49.739    77.000 412
    46.067    55.000 413
   -26.326     9.000 414
   -71.943    83.000 415
   -98.245     5.000 416
   -45.093    65.000 417
   -95.199     4.000 418
   -96.770     5.000 419
   -96.492     5.000 420
   -97.027     2.000 421
   -24.740    64.000 422
   -97.607     3.000 423
   -65.106    97.000 424
   -75.068    98.000 425
   -44.615    83.000 426
   -24.092    80.000 427
   -62.612    86.000 428
    43.776    45.000 429
   -96.003     6.000 430
    67.117    53.000 431
    17.628    21.000 432
   -64.521    90.000 433
   -20.887    54.000 434
    83.873    47.000 435
    30.143    34.000 436
  -121.369   133.000 437
   -76.817    82.000 438
    16.517    44.000 439
   157.445    14.000 440
    30.348    47.000 441
   111.415    23.000 442
    38.733    61.000 443
    43.780    39.000 444
  -125.748   139.000 445
   -55.917    82.000 446
    94.161    23.000 447
  -124.853   132.000 448
  -107.270     4.000 449
    27.940    13.000 450
    23.582    50.000 451
   -56.968    81.000 452
  -115.549   127.000 453
    20.976     0.000 454
   -87.626   102.000 455
   101.710    29.000 456
   103.846    23.000 457
   103.596    22.000 458
    35.319    35.000 459
   122.028    24.000 460
   117.347    25.000 461
   117.490    27.000 462
    18.087    62.000 463
    -3.614    35.000 464
   -26.448    61.000 465
    -5.601    54.000 466
    65.425    36.000 467
    -3.802    53.000 468
   -91.761   112.000 469
    18.242     0.000 470
    24.716     8.000 471
    52.269    32.000 472
   -25.202    74.000 473
   -27.516    58.000 474
   -24.170    60.000 475
EOF

# Azimuth of the projection plane
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
   180.273     0.100 Azimuth =  135
EOF
gmt end
