#!/bin/bash
gmt begin kodiak1.21_tt8_rdp_summary pdf,ps
proj=-JX18/12
reg=-R25/102/0/61
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1+l'Time Difference (s)' -BWeSn+t'Relative Depth Phase Summary kodiak1.21'
gmt plot $proj $reg -Wthick,green << EOF
    25.000     3.035
    26.000     3.039
    27.000     3.044
    28.000     3.051
    29.000     3.055
    30.000     3.058
    31.000     3.061
    32.000     3.064
    33.000     3.068
    34.000     3.073
    35.000     3.079
    36.000     3.084
    37.000     3.090
    38.000     3.095
    39.000     3.101
    40.000     3.107
    41.000     3.113
    42.000     3.119
    43.000     3.125
    44.000     3.131
    45.000     3.136
    46.000     3.142
    47.000     3.148
    48.000     3.154
    49.000     3.160
    50.000     3.165
    51.000     3.171
    52.000     3.177
    53.000     3.182
    54.000     3.188
    55.000     3.193
    56.000     3.198
    57.000     3.204
    58.000     3.209
    59.000     3.214
    60.000     3.219
    61.000     3.224
    62.000     3.229
    63.000     3.234
    64.000     3.239
    65.000     3.243
    66.000     3.248
    67.000     3.253
    68.000     3.257
    69.000     3.262
    70.000     3.266
    71.000     3.271
    72.000     3.275
    73.000     3.279
    74.000     3.284
    75.000     3.288
    76.000     3.292
    77.000     3.296
    78.000     3.300
    79.000     3.304
    80.000     3.308
    81.000     3.312
    82.000     3.316
    83.000     3.320
    84.000     3.324
    85.000     3.328
    86.000     3.331
    87.000     3.335
    88.000     3.341
    89.000     3.343
    90.000     3.344
    91.000     3.345
    92.000     3.346
    93.000     3.347
    94.000     3.348
    95.000     3.349
    96.000     3.350
    97.000     3.351
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     3.351  10
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000     6.068
    26.000     6.076
    27.000     6.086
    28.000     6.100
    29.000     6.109
    30.000     6.115
    31.000     6.121
    32.000     6.127
    33.000     6.135
    34.000     6.145
    35.000     6.156
    36.000     6.167
    37.000     6.178
    38.000     6.189
    39.000     6.201
    40.000     6.213
    41.000     6.225
    42.000     6.236
    43.000     6.248
    44.000     6.260
    45.000     6.272
    46.000     6.284
    47.000     6.295
    48.000     6.307
    49.000     6.318
    50.000     6.330
    51.000     6.341
    52.000     6.352
    53.000     6.363
    54.000     6.374
    55.000     6.385
    56.000     6.396
    57.000     6.406
    58.000     6.417
    59.000     6.427
    60.000     6.437
    61.000     6.447
    62.000     6.457
    63.000     6.467
    64.000     6.476
    65.000     6.486
    66.000     6.495
    67.000     6.504
    68.000     6.513
    69.000     6.523
    70.000     6.531
    71.000     6.540
    72.000     6.549
    73.000     6.558
    74.000     6.566
    75.000     6.575
    76.000     6.583
    77.000     6.591
    78.000     6.599
    79.000     6.607
    80.000     6.615
    81.000     6.623
    82.000     6.631
    83.000     6.639
    84.000     6.647
    85.000     6.655
    86.000     6.662
    87.000     6.669
    88.000     6.681
    89.000     6.685
    90.000     6.688
    91.000     6.690
    92.000     6.692
    93.000     6.693
    94.000     6.695
    95.000     6.697
    96.000     6.699
    97.000     6.701
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     6.701  20
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000     8.669
    26.000     8.682
    27.000     8.698
    28.000     8.721
    29.000     8.735
    30.000     8.744
    31.000     8.753
    32.000     8.763
    33.000     8.776
    34.000     8.792
    35.000     8.809
    36.000     8.827
    37.000     8.844
    38.000     8.862
    39.000     8.880
    40.000     8.899
    41.000     8.918
    42.000     8.936
    43.000     8.955
    44.000     8.974
    45.000     8.992
    46.000     9.011
    47.000     9.030
    48.000     9.048
    49.000     9.066
    50.000     9.084
    51.000     9.102
    52.000     9.120
    53.000     9.136
    54.000     9.154
    55.000     9.171
    56.000     9.188
    57.000     9.204
    58.000     9.221
    59.000     9.237
    60.000     9.253
    61.000     9.269
    62.000     9.285
    63.000     9.300
    64.000     9.315
    65.000     9.330
    66.000     9.344
    67.000     9.359
    68.000     9.373
    69.000     9.387
    70.000     9.401
    71.000     9.415
    72.000     9.429
    73.000     9.443
    74.000     9.456
    75.000     9.470
    76.000     9.483
    77.000     9.495
    78.000     9.508
    79.000     9.520
    80.000     9.533
    81.000     9.546
    82.000     9.558
    83.000     9.570
    84.000     9.582
    85.000     9.595
    86.000     9.607
    87.000     9.618
    88.000     9.636
    89.000     9.643
    90.000     9.647
    91.000     9.651
    92.000     9.654
    93.000     9.656
    94.000     9.658
    95.000     9.661
    96.000     9.664
    97.000     9.668
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000     9.668  30
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    10.902
    26.000    10.921
    27.000    10.944
    28.000    10.976
    29.000    10.996
    30.000    11.010
    31.000    11.023
    32.000    11.037
    33.000    11.055
    34.000    11.079
    35.000    11.104
    36.000    11.129
    37.000    11.154
    38.000    11.180
    39.000    11.206
    40.000    11.233
    41.000    11.260
    42.000    11.286
    43.000    11.313
    44.000    11.340
    45.000    11.366
    46.000    11.393
    47.000    11.419
    48.000    11.446
    49.000    11.471
    50.000    11.497
    51.000    11.523
    52.000    11.548
    53.000    11.572
    54.000    11.596
    55.000    11.621
    56.000    11.645
    57.000    11.669
    58.000    11.692
    59.000    11.715
    60.000    11.738
    61.000    11.761
    62.000    11.783
    63.000    11.805
    64.000    11.826
    65.000    11.847
    66.000    11.868
    67.000    11.888
    68.000    11.909
    69.000    11.929
    70.000    11.949
    71.000    11.968
    72.000    11.988
    73.000    12.007
    74.000    12.026
    75.000    12.046
    76.000    12.064
    77.000    12.082
    78.000    12.100
    79.000    12.117
    80.000    12.135
    81.000    12.153
    82.000    12.171
    83.000    12.188
    84.000    12.205
    85.000    12.223
    86.000    12.239
    87.000    12.255
    88.000    12.280
    89.000    12.290
    90.000    12.297
    91.000    12.302
    92.000    12.305
    93.000    12.308
    94.000    12.311
    95.000    12.315
    96.000    12.320
    97.000    12.325
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    12.325  40
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    12.764
    26.000    12.790
    27.000    12.821
    28.000    12.865
    29.000    12.893
    30.000    12.912
    31.000    12.929
    32.000    12.948
    33.000    12.973
    34.000    13.004
    35.000    13.038
    36.000    13.072
    37.000    13.106
    38.000    13.141
    39.000    13.177
    40.000    13.213
    41.000    13.249
    42.000    13.285
    43.000    13.321
    44.000    13.357
    45.000    13.393
    46.000    13.429
    47.000    13.464
    48.000    13.499
    49.000    13.534
    50.000    13.569
    51.000    13.603
    52.000    13.637
    53.000    13.669
    54.000    13.702
    55.000    13.735
    56.000    13.767
    57.000    13.799
    58.000    13.830
    59.000    13.861
    60.000    13.892
    61.000    13.922
    62.000    13.952
    63.000    13.980
    64.000    14.009
    65.000    14.037
    66.000    14.065
    67.000    14.092
    68.000    14.120
    69.000    14.146
    70.000    14.173
    71.000    14.199
    72.000    14.225
    73.000    14.251
    74.000    14.276
    75.000    14.302
    76.000    14.327
    77.000    14.350
    78.000    14.374
    79.000    14.397
    80.000    14.421
    81.000    14.445
    82.000    14.468
    83.000    14.491
    84.000    14.514
    85.000    14.538
    86.000    14.559
    87.000    14.580
    88.000    14.614
    89.000    14.627
    90.000    14.636
    91.000    14.642
    92.000    14.647
    93.000    14.651
    94.000    14.655
    95.000    14.660
    96.000    14.667
    97.000    14.673
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    14.673  50
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    14.624
    26.000    14.657
    27.000    14.697
    28.000    14.752
    29.000    14.786
    30.000    14.810
    31.000    14.833
    32.000    14.857
    33.000    14.888
    34.000    14.928
    35.000    14.971
    36.000    15.013
    37.000    15.056
    38.000    15.100
    39.000    15.145
    40.000    15.191
    41.000    15.236
    42.000    15.281
    43.000    15.327
    44.000    15.372
    45.000    15.417
    46.000    15.462
    47.000    15.507
    48.000    15.551
    49.000    15.595
    50.000    15.639
    51.000    15.682
    52.000    15.724
    53.000    15.765
    54.000    15.806
    55.000    15.847
    56.000    15.888
    57.000    15.928
    58.000    15.967
    59.000    16.005
    60.000    16.044
    61.000    16.082
    62.000    16.119
    63.000    16.155
    64.000    16.190
    65.000    16.226
    66.000    16.260
    67.000    16.295
    68.000    16.329
    69.000    16.363
    70.000    16.396
    71.000    16.429
    72.000    16.461
    73.000    16.493
    74.000    16.525
    75.000    16.557
    76.000    16.588
    77.000    16.618
    78.000    16.647
    79.000    16.676
    80.000    16.706
    81.000    16.736
    82.000    16.765
    83.000    16.793
    84.000    16.822
    85.000    16.852
    86.000    16.878
    87.000    16.904
    88.000    16.947
    89.000    16.963
    90.000    16.974
    91.000    16.982
    92.000    16.988
    93.000    16.993
    94.000    16.998
    95.000    17.004
    96.000    17.012
    97.000    17.021
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    17.021  60
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    16.481
    26.000    16.521
    27.000    16.569
    28.000    16.635
    29.000    16.678
    30.000    16.707
    31.000    16.734
    32.000    16.763
    33.000    16.801
    34.000    16.849
    35.000    16.900
    36.000    16.952
    37.000    17.004
    38.000    17.057
    39.000    17.111
    40.000    17.166
    41.000    17.221
    42.000    17.276
    43.000    17.330
    44.000    17.385
    45.000    17.440
    46.000    17.494
    47.000    17.548
    48.000    17.601
    49.000    17.654
    50.000    17.707
    51.000    17.759
    52.000    17.809
    53.000    17.858
    54.000    17.908
    55.000    17.957
    56.000    18.007
    57.000    18.055
    58.000    18.101
    59.000    18.148
    60.000    18.194
    61.000    18.240
    62.000    18.284
    63.000    18.328
    64.000    18.371
    65.000    18.413
    66.000    18.455
    67.000    18.496
    68.000    18.537
    69.000    18.578
    70.000    18.618
    71.000    18.657
    72.000    18.695
    73.000    18.734
    74.000    18.773
    75.000    18.811
    76.000    18.848
    77.000    18.884
    78.000    18.919
    79.000    18.954
    80.000    18.990
    81.000    19.026
    82.000    19.061
    83.000    19.094
    84.000    19.129
    85.000    19.164
    86.000    19.196
    87.000    19.227
    88.000    19.278
    89.000    19.298
    90.000    19.311
    91.000    19.321
    92.000    19.328
    93.000    19.334
    94.000    19.340
    95.000    19.348
    96.000    19.357
    97.000    19.367
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    19.367  70
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    18.336
    26.000    18.383
    27.000    18.439
    28.000    18.515
    29.000    18.566
    30.000    18.600
    31.000    18.632
    32.000    18.667
    33.000    18.711
    34.000    18.767
    35.000    18.828
    36.000    18.888
    37.000    18.949
    38.000    19.011
    39.000    19.075
    40.000    19.140
    41.000    19.204
    42.000    19.268
    43.000    19.332
    44.000    19.396
    45.000    19.460
    46.000    19.524
    47.000    19.587
    48.000    19.649
    49.000    19.711
    50.000    19.773
    51.000    19.834
    52.000    19.893
    53.000    19.950
    54.000    20.008
    55.000    20.066
    56.000    20.124
    57.000    20.180
    58.000    20.235
    59.000    20.289
    60.000    20.343
    61.000    20.396
    62.000    20.449
    63.000    20.500
    64.000    20.549
    65.000    20.599
    66.000    20.648
    67.000    20.696
    68.000    20.744
    69.000    20.791
    70.000    20.838
    71.000    20.884
    72.000    20.929
    73.000    20.974
    74.000    21.019
    75.000    21.064
    76.000    21.107
    77.000    21.149
    78.000    21.190
    79.000    21.231
    80.000    21.272
    81.000    21.314
    82.000    21.355
    83.000    21.395
    84.000    21.435
    85.000    21.477
    86.000    21.514
    87.000    21.550
    88.000    21.609
    89.000    21.633
    90.000    21.647
    91.000    21.659
    92.000    21.667
    93.000    21.674
    94.000    21.681
    95.000    21.690
    96.000    21.702
    97.000    21.713
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    21.713  80
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    20.187
    26.000    20.241
    27.000    20.307
    28.000    20.393
    29.000    20.452
    30.000    20.491
    31.000    20.528
    32.000    20.568
    33.000    20.618
    34.000    20.683
    35.000    20.752
    36.000    20.822
    37.000    20.892
    38.000    20.963
    39.000    21.036
    40.000    21.111
    41.000    21.184
    42.000    21.258
    43.000    21.331
    44.000    21.405
    45.000    21.478
    46.000    21.551
    47.000    21.624
    48.000    21.695
    49.000    21.766
    50.000    21.837
    51.000    21.907
    52.000    21.974
    53.000    22.040
    54.000    22.107
    55.000    22.173
    56.000    22.239
    57.000    22.303
    58.000    22.366
    59.000    22.428
    60.000    22.490
    61.000    22.552
    62.000    22.611
    63.000    22.670
    64.000    22.727
    65.000    22.783
    66.000    22.839
    67.000    22.895
    68.000    22.950
    69.000    23.003
    70.000    23.057
    71.000    23.109
    72.000    23.161
    73.000    23.213
    74.000    23.265
    75.000    23.316
    76.000    23.365
    77.000    23.413
    78.000    23.460
    79.000    23.507
    80.000    23.554
    81.000    23.602
    82.000    23.649
    83.000    23.694
    84.000    23.740
    85.000    23.787
    86.000    23.830
    87.000    23.872
    88.000    23.939
    89.000    23.966
    90.000    23.983
    91.000    23.996
    92.000    24.006
    93.000    24.013
    94.000    24.021
    95.000    24.032
    96.000    24.045
    97.000    24.058
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    24.058  90
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    22.036
    26.000    22.097
    27.000    22.171
    28.000    22.267
    29.000    22.334
    30.000    22.379
    31.000    22.421
    32.000    22.466
    33.000    22.523
    34.000    22.596
    35.000    22.674
    36.000    22.753
    37.000    22.832
    38.000    22.913
    39.000    22.995
    40.000    23.079
    41.000    23.163
    42.000    23.245
    43.000    23.328
    44.000    23.411
    45.000    23.494
    46.000    23.577
    47.000    23.658
    48.000    23.739
    49.000    23.820
    50.000    23.899
    51.000    23.978
    52.000    24.054
    53.000    24.129
    54.000    24.203
    55.000    24.278
    56.000    24.353
    57.000    24.425
    58.000    24.496
    59.000    24.566
    60.000    24.636
    61.000    24.705
    62.000    24.772
    63.000    24.838
    64.000    24.902
    65.000    24.966
    66.000    25.029
    67.000    25.092
    68.000    25.154
    69.000    25.214
    70.000    25.275
    71.000    25.334
    72.000    25.392
    73.000    25.450
    74.000    25.509
    75.000    25.566
    76.000    25.622
    77.000    25.676
    78.000    25.729
    79.000    25.781
    80.000    25.835
    81.000    25.889
    82.000    25.941
    83.000    25.992
    84.000    26.044
    85.000    26.097
    86.000    26.145
    87.000    26.192
    88.000    26.267
    89.000    26.298
    90.000    26.317
    91.000    26.332
    92.000    26.343
    93.000    26.352
    94.000    26.360
    95.000    26.373
    96.000    26.387
    97.000    26.402
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    26.402 100
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    23.881
    26.000    23.950
    27.000    24.034
    28.000    24.138
    29.000    24.214
    30.000    24.265
    31.000    24.311
    32.000    24.362
    33.000    24.426
    34.000    24.506
    35.000    24.594
    36.000    24.682
    37.000    24.770
    38.000    24.860
    39.000    24.952
    40.000    25.045
    41.000    25.138
    42.000    25.230
    43.000    25.323
    44.000    25.416
    45.000    25.508
    46.000    25.600
    47.000    25.691
    48.000    25.781
    49.000    25.871
    50.000    25.959
    51.000    26.047
    52.000    26.132
    53.000    26.215
    54.000    26.298
    55.000    26.382
    56.000    26.464
    57.000    26.545
    58.000    26.624
    59.000    26.702
    60.000    26.780
    61.000    26.857
    62.000    26.932
    63.000    27.005
    64.000    27.077
    65.000    27.148
    66.000    27.218
    67.000    27.287
    68.000    27.356
    69.000    27.424
    70.000    27.491
    71.000    27.557
    72.000    27.622
    73.000    27.686
    74.000    27.751
    75.000    27.815
    76.000    27.877
    77.000    27.937
    78.000    27.996
    79.000    28.055
    80.000    28.114
    81.000    28.174
    82.000    28.233
    83.000    28.289
    84.000    28.347
    85.000    28.406
    86.000    28.460
    87.000    28.512
    88.000    28.595
    89.000    28.630
    90.000    28.651
    91.000    28.667
    92.000    28.680
    93.000    28.689
    94.000    28.699
    95.000    28.713
    96.000    28.729
    97.000    28.745
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    28.745 110
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    25.723
    26.000    25.799
    27.000    25.893
    28.000    26.005
    29.000    26.090
    30.000    26.147
    31.000    26.198
    32.000    26.254
    33.000    26.325
    34.000    26.414
    35.000    26.510
    36.000    26.607
    37.000    26.704
    38.000    26.803
    39.000    26.905
    40.000    27.008
    41.000    27.111
    42.000    27.212
    43.000    27.314
    44.000    27.417
    45.000    27.519
    46.000    27.620
    47.000    27.721
    48.000    27.820
    49.000    27.919
    50.000    28.016
    51.000    28.113
    52.000    28.207
    53.000    28.299
    54.000    28.390
    55.000    28.482
    56.000    28.574
    57.000    28.663
    58.000    28.750
    59.000    28.836
    60.000    28.922
    61.000    29.006
    62.000    29.089
    63.000    29.170
    64.000    29.249
    65.000    29.327
    66.000    29.404
    67.000    29.481
    68.000    29.557
    69.000    29.631
    70.000    29.705
    71.000    29.778
    72.000    29.849
    73.000    29.921
    74.000    29.992
    75.000    30.063
    76.000    30.131
    77.000    30.197
    78.000    30.262
    79.000    30.326
    80.000    30.392
    81.000    30.458
    82.000    30.522
    83.000    30.584
    84.000    30.648
    85.000    30.714
    86.000    30.772
    87.000    30.830
    88.000    30.920
    89.000    30.960
    90.000    30.983
    91.000    31.001
    92.000    31.015
    93.000    31.025
    94.000    31.036
    95.000    31.051
    96.000    31.069
    97.000    31.087
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    31.087 120
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    27.558
    26.000    27.641
    27.000    27.744
    28.000    27.865
    29.000    27.959
    30.000    28.021
    31.000    28.078
    32.000    28.139
    33.000    28.217
    34.000    28.314
    35.000    28.419
    36.000    28.525
    37.000    28.632
    38.000    28.740
    39.000    28.851
    40.000    28.965
    41.000    29.077
    42.000    29.188
    43.000    29.300
    44.000    29.412
    45.000    29.523
    46.000    29.634
    47.000    29.744
    48.000    29.853
    49.000    29.961
    50.000    30.068
    51.000    30.173
    52.000    30.276
    53.000    30.376
    54.000    30.477
    55.000    30.577
    56.000    30.677
    57.000    30.774
    58.000    30.869
    59.000    30.964
    60.000    31.057
    61.000    31.150
    62.000    31.241
    63.000    31.329
    64.000    31.415
    65.000    31.500
    66.000    31.585
    67.000    31.669
    68.000    31.752
    69.000    31.833
    70.000    31.914
    71.000    31.993
    72.000    32.072
    73.000    32.150
    74.000    32.228
    75.000    32.305
    76.000    32.379
    77.000    32.451
    78.000    32.523
    79.000    32.593
    80.000    32.664
    81.000    32.737
    82.000    32.807
    83.000    32.875
    84.000    32.944
    85.000    33.016
    86.000    33.080
    87.000    33.144
    88.000    33.241
    89.000    33.285
    90.000    33.310
    91.000    33.330
    92.000    33.345
    93.000    33.356
    94.000    33.368
    95.000    33.385
    96.000    33.404
    97.000    33.424
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    33.424 130
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    29.378
    26.000    29.469
    27.000    29.582
    28.000    29.711
    29.000    29.814
    30.000    29.882
    31.000    29.944
    32.000    30.011
    33.000    30.096
    34.000    30.201
    35.000    30.315
    36.000    30.430
    37.000    30.546
    38.000    30.664
    39.000    30.785
    40.000    30.908
    41.000    31.030
    42.000    31.151
    43.000    31.273
    44.000    31.394
    45.000    31.516
    46.000    31.636
    47.000    31.756
    48.000    31.874
    49.000    31.991
    50.000    32.107
    51.000    32.222
    52.000    32.334
    53.000    32.443
    54.000    32.552
    55.000    32.661
    56.000    32.769
    57.000    32.875
    58.000    32.978
    59.000    33.081
    60.000    33.183
    61.000    33.283
    62.000    33.382
    63.000    33.477
    64.000    33.571
    65.000    33.664
    66.000    33.756
    67.000    33.847
    68.000    33.937
    69.000    34.025
    70.000    34.113
    71.000    34.199
    72.000    34.284
    73.000    34.368
    74.000    34.453
    75.000    34.537
    76.000    34.618
    77.000    34.696
    78.000    34.773
    79.000    34.850
    80.000    34.927
    81.000    35.006
    82.000    35.082
    83.000    35.156
    84.000    35.231
    85.000    35.309
    86.000    35.379
    87.000    35.448
    88.000    35.552
    89.000    35.601
    90.000    35.628
    91.000    35.649
    92.000    35.666
    93.000    35.678
    94.000    35.691
    95.000    35.709
    96.000    35.730
    97.000    35.752
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    35.752 140
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    31.185
    26.000    31.284
    27.000    31.406
    28.000    31.544
    29.000    31.655
    30.000    31.730
    31.000    31.797
    32.000    31.870
    33.000    31.961
    34.000    32.074
    35.000    32.198
    36.000    32.322
    37.000    32.448
    38.000    32.576
    39.000    32.706
    40.000    32.839
    41.000    32.971
    42.000    33.102
    43.000    33.233
    44.000    33.364
    45.000    33.496
    46.000    33.626
    47.000    33.755
    48.000    33.883
    49.000    34.009
    50.000    34.135
    51.000    34.259
    52.000    34.380
    53.000    34.497
    54.000    34.615
    55.000    34.733
    56.000    34.850
    57.000    34.964
    58.000    35.076
    59.000    35.187
    60.000    35.297
    61.000    35.405
    62.000    35.511
    63.000    35.615
    64.000    35.716
    65.000    35.816
    66.000    35.915
    67.000    36.014
    68.000    36.111
    69.000    36.207
    70.000    36.301
    71.000    36.394
    72.000    36.486
    73.000    36.577
    74.000    36.669
    75.000    36.759
    76.000    36.846
    77.000    36.931
    78.000    37.014
    79.000    37.097
    80.000    37.180
    81.000    37.265
    82.000    37.347
    83.000    37.427
    84.000    37.508
    85.000    37.592
    86.000    37.667
    87.000    37.742
    88.000    37.854
    89.000    37.907
    90.000    37.936
    91.000    37.960
    92.000    37.977
    93.000    37.991
    94.000    38.004
    95.000    38.024
    96.000    38.046
    97.000    38.070
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    38.070 150
EOF
gmt plot $proj $reg -Wthick,green << EOF
    25.000    32.976
    26.000    33.085
    27.000    33.217
    28.000    33.362
    29.000    33.482
    30.000    33.564
    31.000    33.636
    32.000    33.715
    33.000    33.814
    34.000    33.935
    35.000    34.068
    36.000    34.202
    37.000    34.337
    38.000    34.474
    39.000    34.615
    40.000    34.757
    41.000    34.899
    42.000    35.040
    43.000    35.181
    44.000    35.323
    45.000    35.464
    46.000    35.604
    47.000    35.742
    48.000    35.880
    49.000    36.016
    50.000    36.151
    51.000    36.284
    52.000    36.414
    53.000    36.541
    54.000    36.667
    55.000    36.794
    56.000    36.920
    57.000    37.043
    58.000    37.163
    59.000    37.281
    60.000    37.400
    61.000    37.516
    62.000    37.630
    63.000    37.742
    64.000    37.850
    65.000    37.958
    66.000    38.065
    67.000    38.170
    68.000    38.275
    69.000    38.378
    70.000    38.479
    71.000    38.579
    72.000    38.677
    73.000    38.776
    74.000    38.874
    75.000    38.971
    76.000    39.064
    77.000    39.155
    78.000    39.245
    79.000    39.334
    80.000    39.424
    81.000    39.514
    82.000    39.603
    83.000    39.688
    84.000    39.776
    85.000    39.866
    86.000    39.947
    87.000    40.027
    88.000    40.146
    89.000    40.204
    90.000    40.235
    91.000    40.260
    92.000    40.279
    93.000    40.294
    94.000    40.309
    95.000    40.329
    96.000    40.354
    97.000    40.379
EOF
# Labels for pP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jML << EOF
    97.000    40.379 160
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000     4.289
    26.000     4.292
    27.000     4.296
    28.000     4.302
    29.000     4.305
    30.000     4.307
    31.000     4.310
    32.000     4.312
    33.000     4.315
    34.000     4.319
    35.000     4.323
    36.000     4.328
    37.000     4.332
    38.000     4.336
    39.000     4.341
    40.000     4.345
    41.000     4.350
    42.000     4.354
    43.000     4.359
    44.000     4.364
    45.000     4.368
    46.000     4.373
    47.000     4.377
    48.000     4.382
    49.000     4.387
    50.000     4.391
    51.000     4.395
    52.000     4.400
    53.000     4.404
    54.000     4.408
    55.000     4.412
    56.000     4.417
    57.000     4.421
    58.000     4.425
    59.000     4.429
    60.000     4.433
    61.000     4.437
    62.000     4.441
    63.000     4.445
    64.000     4.448
    65.000     4.452
    66.000     4.456
    67.000     4.459
    68.000     4.463
    69.000     4.466
    70.000     4.470
    71.000     4.473
    72.000     4.477
    73.000     4.480
    74.000     4.484
    75.000     4.487
    76.000     4.490
    77.000     4.493
    78.000     4.497
    79.000     4.500
    80.000     4.503
    81.000     4.506
    82.000     4.509
    83.000     4.512
    84.000     4.515
    85.000     4.518
    86.000     4.521
    87.000     4.524
    88.000     4.529
    89.000     4.531
    90.000     4.532
    91.000     4.533
    92.000     4.533
    93.000     4.534
    94.000     4.534
    95.000     4.535
    96.000     4.536
    97.000     4.537
    98.000     4.538
    99.000     4.539
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000     4.539  10
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000     8.577
    26.000     8.583
    27.000     8.591
    28.000     8.602
    29.000     8.609
    30.000     8.614
    31.000     8.618
    32.000     8.623
    33.000     8.629
    34.000     8.637
    35.000     8.646
    36.000     8.654
    37.000     8.663
    38.000     8.672
    39.000     8.681
    40.000     8.690
    41.000     8.699
    42.000     8.708
    43.000     8.717
    44.000     8.726
    45.000     8.736
    46.000     8.745
    47.000     8.754
    48.000     8.763
    49.000     8.772
    50.000     8.781
    51.000     8.790
    52.000     8.799
    53.000     8.807
    54.000     8.815
    55.000     8.824
    56.000     8.832
    57.000     8.841
    58.000     8.849
    59.000     8.857
    60.000     8.865
    61.000     8.873
    62.000     8.881
    63.000     8.888
    64.000     8.896
    65.000     8.903
    66.000     8.911
    67.000     8.918
    68.000     8.925
    69.000     8.932
    70.000     8.939
    71.000     8.946
    72.000     8.953
    73.000     8.960
    74.000     8.967
    75.000     8.973
    76.000     8.980
    77.000     8.986
    78.000     8.993
    79.000     8.999
    80.000     9.005
    81.000     9.012
    82.000     9.018
    83.000     9.024
    84.000     9.030
    85.000     9.037
    86.000     9.042
    87.000     9.048
    88.000     9.057
    89.000     9.061
    90.000     9.063
    91.000     9.065
    92.000     9.066
    93.000     9.067
    94.000     9.068
    95.000     9.070
    96.000     9.071
    97.000     9.073
    98.000     9.075
    99.000     9.077
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000     9.077  20
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    12.342
    26.000    12.352
    27.000    12.365
    28.000    12.382
    29.000    12.392
    30.000    12.400
    31.000    12.407
    32.000    12.414
    33.000    12.424
    34.000    12.437
    35.000    12.450
    36.000    12.464
    37.000    12.477
    38.000    12.491
    39.000    12.505
    40.000    12.520
    41.000    12.534
    42.000    12.549
    43.000    12.563
    44.000    12.578
    45.000    12.592
    46.000    12.607
    47.000    12.621
    48.000    12.635
    49.000    12.649
    50.000    12.664
    51.000    12.678
    52.000    12.691
    53.000    12.704
    54.000    12.718
    55.000    12.731
    56.000    12.744
    57.000    12.757
    58.000    12.770
    59.000    12.783
    60.000    12.795
    61.000    12.808
    62.000    12.820
    63.000    12.832
    64.000    12.844
    65.000    12.855
    66.000    12.867
    67.000    12.878
    68.000    12.889
    69.000    12.901
    70.000    12.912
    71.000    12.923
    72.000    12.933
    73.000    12.944
    74.000    12.955
    75.000    12.965
    76.000    12.976
    77.000    12.986
    78.000    12.996
    79.000    13.005
    80.000    13.015
    81.000    13.025
    82.000    13.035
    83.000    13.045
    84.000    13.054
    85.000    13.064
    86.000    13.073
    87.000    13.082
    88.000    13.096
    89.000    13.102
    90.000    13.105
    91.000    13.108
    92.000    13.110
    93.000    13.112
    94.000    13.114
    95.000    13.116
    96.000    13.119
    97.000    13.122
    98.000    13.125
    99.000    13.128
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    13.128  30
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    15.728
    26.000    15.743
    27.000    15.760
    28.000    15.785
    29.000    15.800
    30.000    15.810
    31.000    15.820
    32.000    15.831
    33.000    15.845
    34.000    15.863
    35.000    15.882
    36.000    15.901
    37.000    15.921
    38.000    15.940
    39.000    15.961
    40.000    15.981
    41.000    16.002
    42.000    16.022
    43.000    16.043
    44.000    16.063
    45.000    16.084
    46.000    16.104
    47.000    16.125
    48.000    16.145
    49.000    16.165
    50.000    16.185
    51.000    16.205
    52.000    16.224
    53.000    16.242
    54.000    16.261
    55.000    16.280
    56.000    16.299
    57.000    16.317
    58.000    16.335
    59.000    16.353
    60.000    16.371
    61.000    16.389
    62.000    16.406
    63.000    16.423
    64.000    16.439
    65.000    16.456
    66.000    16.472
    67.000    16.488
    68.000    16.504
    69.000    16.519
    70.000    16.535
    71.000    16.550
    72.000    16.565
    73.000    16.581
    74.000    16.596
    75.000    16.611
    76.000    16.625
    77.000    16.639
    78.000    16.653
    79.000    16.667
    80.000    16.681
    81.000    16.695
    82.000    16.709
    83.000    16.722
    84.000    16.735
    85.000    16.750
    86.000    16.762
    87.000    16.775
    88.000    16.795
    89.000    16.802
    90.000    16.807
    91.000    16.811
    92.000    16.814
    93.000    16.816
    94.000    16.819
    95.000    16.822
    96.000    16.826
    97.000    16.830
    98.000    16.834
    99.000    16.839
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    16.839  40
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    18.733
    26.000    18.753
    27.000    18.777
    28.000    18.810
    29.000    18.829
    30.000    18.843
    31.000    18.857
    32.000    18.871
    33.000    18.890
    34.000    18.914
    35.000    18.940
    36.000    18.966
    37.000    18.991
    38.000    19.018
    39.000    19.045
    40.000    19.072
    41.000    19.100
    42.000    19.127
    43.000    19.154
    44.000    19.182
    45.000    19.209
    46.000    19.236
    47.000    19.263
    48.000    19.290
    49.000    19.317
    50.000    19.344
    51.000    19.370
    52.000    19.395
    53.000    19.420
    54.000    19.445
    55.000    19.470
    56.000    19.495
    57.000    19.520
    58.000    19.544
    59.000    19.567
    60.000    19.591
    61.000    19.614
    62.000    19.637
    63.000    19.659
    64.000    19.681
    65.000    19.703
    66.000    19.724
    67.000    19.746
    68.000    19.767
    69.000    19.787
    70.000    19.808
    71.000    19.828
    72.000    19.848
    73.000    19.868
    74.000    19.888
    75.000    19.908
    76.000    19.927
    77.000    19.946
    78.000    19.964
    79.000    19.982
    80.000    20.000
    81.000    20.019
    82.000    20.037
    83.000    20.055
    84.000    20.073
    85.000    20.091
    86.000    20.108
    87.000    20.124
    88.000    20.151
    89.000    20.161
    90.000    20.167
    91.000    20.173
    92.000    20.176
    93.000    20.179
    94.000    20.182
    95.000    20.187
    96.000    20.192
    97.000    20.197
    98.000    20.203
    99.000    20.209
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    20.209  50
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    21.735
    26.000    21.760
    27.000    21.790
    28.000    21.832
    29.000    21.856
    30.000    21.874
    31.000    21.890
    32.000    21.909
    33.000    21.933
    34.000    21.963
    35.000    21.995
    36.000    22.027
    37.000    22.059
    38.000    22.092
    39.000    22.126
    40.000    22.161
    41.000    22.195
    42.000    22.229
    43.000    22.263
    44.000    22.298
    45.000    22.332
    46.000    22.366
    47.000    22.400
    48.000    22.433
    49.000    22.467
    50.000    22.500
    51.000    22.533
    52.000    22.564
    53.000    22.595
    54.000    22.627
    55.000    22.658
    56.000    22.689
    57.000    22.720
    58.000    22.749
    59.000    22.779
    60.000    22.808
    61.000    22.838
    62.000    22.866
    63.000    22.894
    64.000    22.921
    65.000    22.948
    66.000    22.975
    67.000    23.001
    68.000    23.027
    69.000    23.053
    70.000    23.079
    71.000    23.104
    72.000    23.129
    73.000    23.154
    74.000    23.179
    75.000    23.203
    76.000    23.227
    77.000    23.250
    78.000    23.273
    79.000    23.295
    80.000    23.318
    81.000    23.342
    82.000    23.364
    83.000    23.386
    84.000    23.408
    85.000    23.431
    86.000    23.452
    87.000    23.472
    88.000    23.505
    89.000    23.518
    90.000    23.526
    91.000    23.532
    92.000    23.537
    93.000    23.540
    94.000    23.544
    95.000    23.550
    96.000    23.556
    97.000    23.562
    98.000    23.570
    99.000    23.577
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    23.577  60
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    24.735
    26.000    24.765
    27.000    24.801
    28.000    24.851
    29.000    24.880
    30.000    24.901
    31.000    24.921
    32.000    24.943
    33.000    24.972
    34.000    25.009
    35.000    25.047
    36.000    25.086
    37.000    25.125
    38.000    25.165
    39.000    25.205
    40.000    25.247
    41.000    25.288
    42.000    25.329
    43.000    25.370
    44.000    25.411
    45.000    25.452
    46.000    25.493
    47.000    25.534
    48.000    25.574
    49.000    25.614
    50.000    25.654
    51.000    25.693
    52.000    25.731
    53.000    25.769
    54.000    25.806
    55.000    25.844
    56.000    25.881
    57.000    25.918
    58.000    25.953
    59.000    25.989
    60.000    26.024
    61.000    26.059
    62.000    26.093
    63.000    26.126
    64.000    26.159
    65.000    26.191
    66.000    26.223
    67.000    26.255
    68.000    26.286
    69.000    26.317
    70.000    26.348
    71.000    26.378
    72.000    26.408
    73.000    26.438
    74.000    26.467
    75.000    26.497
    76.000    26.525
    77.000    26.553
    78.000    26.580
    79.000    26.607
    80.000    26.634
    81.000    26.662
    82.000    26.689
    83.000    26.715
    84.000    26.742
    85.000    26.770
    86.000    26.794
    87.000    26.819
    88.000    26.858
    89.000    26.873
    90.000    26.882
    91.000    26.890
    92.000    26.896
    93.000    26.900
    94.000    26.904
    95.000    26.911
    96.000    26.919
    97.000    26.926
    98.000    26.935
    99.000    26.944
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    26.944  70
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    27.731
    26.000    27.766
    27.000    27.809
    28.000    27.867
    29.000    27.901
    30.000    27.925
    31.000    27.949
    32.000    27.975
    33.000    28.009
    34.000    28.052
    35.000    28.097
    36.000    28.142
    37.000    28.188
    38.000    28.234
    39.000    28.282
    40.000    28.330
    41.000    28.378
    42.000    28.426
    43.000    28.474
    44.000    28.522
    45.000    28.570
    46.000    28.618
    47.000    28.666
    48.000    28.713
    49.000    28.759
    50.000    28.806
    51.000    28.852
    52.000    28.896
    53.000    28.940
    54.000    28.983
    55.000    29.027
    56.000    29.071
    57.000    29.113
    58.000    29.155
    59.000    29.196
    60.000    29.237
    61.000    29.278
    62.000    29.318
    63.000    29.357
    64.000    29.394
    65.000    29.432
    66.000    29.469
    67.000    29.507
    68.000    29.543
    69.000    29.579
    70.000    29.615
    71.000    29.650
    72.000    29.685
    73.000    29.719
    74.000    29.754
    75.000    29.788
    76.000    29.822
    77.000    29.854
    78.000    29.885
    79.000    29.917
    80.000    29.949
    81.000    29.981
    82.000    30.013
    83.000    30.043
    84.000    30.074
    85.000    30.106
    86.000    30.135
    87.000    30.163
    88.000    30.209
    89.000    30.226
    90.000    30.237
    91.000    30.246
    92.000    30.253
    93.000    30.258
    94.000    30.263
    95.000    30.271
    96.000    30.279
    97.000    30.288
    98.000    30.298
    99.000    30.309
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    30.309  80
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    30.724
    26.000    30.765
    27.000    30.815
    28.000    30.880
    29.000    30.919
    30.000    30.947
    31.000    30.974
    32.000    31.004
    33.000    31.043
    34.000    31.092
    35.000    31.144
    36.000    31.196
    37.000    31.248
    38.000    31.301
    39.000    31.356
    40.000    31.411
    41.000    31.466
    42.000    31.521
    43.000    31.576
    44.000    31.631
    45.000    31.686
    46.000    31.741
    47.000    31.795
    48.000    31.849
    49.000    31.902
    50.000    31.955
    51.000    32.008
    52.000    32.058
    53.000    32.108
    54.000    32.158
    55.000    32.209
    56.000    32.258
    57.000    32.307
    58.000    32.354
    59.000    32.402
    60.000    32.449
    61.000    32.495
    62.000    32.540
    63.000    32.585
    64.000    32.628
    65.000    32.671
    66.000    32.714
    67.000    32.756
    68.000    32.798
    69.000    32.839
    70.000    32.880
    71.000    32.920
    72.000    32.960
    73.000    32.999
    74.000    33.039
    75.000    33.078
    76.000    33.116
    77.000    33.153
    78.000    33.189
    79.000    33.225
    80.000    33.261
    81.000    33.298
    82.000    33.334
    83.000    33.369
    84.000    33.404
    85.000    33.441
    86.000    33.474
    87.000    33.506
    88.000    33.558
    89.000    33.578
    90.000    33.590
    91.000    33.600
    92.000    33.608
    93.000    33.614
    94.000    33.620
    95.000    33.628
    96.000    33.638
    97.000    33.649
    98.000    33.660
    99.000    33.672
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    33.672  90
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    33.715
    26.000    33.760
    27.000    33.818
    28.000    33.890
    29.000    33.934
    30.000    33.965
    31.000    33.996
    32.000    34.030
    33.000    34.075
    34.000    34.130
    35.000    34.188
    36.000    34.246
    37.000    34.305
    38.000    34.365
    39.000    34.427
    40.000    34.489
    41.000    34.551
    42.000    34.613
    43.000    34.675
    44.000    34.737
    45.000    34.799
    46.000    34.861
    47.000    34.922
    48.000    34.982
    49.000    35.042
    50.000    35.102
    51.000    35.161
    52.000    35.218
    53.000    35.274
    54.000    35.331
    55.000    35.388
    56.000    35.443
    57.000    35.498
    58.000    35.552
    59.000    35.605
    60.000    35.658
    61.000    35.710
    62.000    35.761
    63.000    35.811
    64.000    35.860
    65.000    35.908
    66.000    35.956
    67.000    36.004
    68.000    36.051
    69.000    36.097
    70.000    36.143
    71.000    36.188
    72.000    36.233
    73.000    36.277
    74.000    36.322
    75.000    36.366
    76.000    36.408
    77.000    36.450
    78.000    36.490
    79.000    36.531
    80.000    36.572
    81.000    36.613
    82.000    36.654
    83.000    36.693
    84.000    36.733
    85.000    36.774
    86.000    36.811
    87.000    36.847
    88.000    36.905
    89.000    36.927
    90.000    36.942
    91.000    36.953
    92.000    36.961
    93.000    36.968
    94.000    36.975
    95.000    36.985
    96.000    36.996
    97.000    37.007
    98.000    37.020
    99.000    37.033
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    37.033 100
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    36.702
    26.000    36.753
    27.000    36.818
    28.000    36.897
    29.000    36.945
    30.000    36.981
    31.000    37.015
    32.000    37.054
    33.000    37.103
    34.000    37.165
    35.000    37.230
    36.000    37.295
    37.000    37.360
    38.000    37.427
    39.000    37.496
    40.000    37.565
    41.000    37.634
    42.000    37.702
    43.000    37.771
    44.000    37.841
    45.000    37.910
    46.000    37.978
    47.000    38.046
    48.000    38.114
    49.000    38.180
    50.000    38.247
    51.000    38.312
    52.000    38.376
    53.000    38.438
    54.000    38.501
    55.000    38.564
    56.000    38.626
    57.000    38.687
    58.000    38.747
    59.000    38.806
    60.000    38.865
    61.000    38.923
    62.000    38.979
    63.000    39.035
    64.000    39.089
    65.000    39.143
    66.000    39.196
    67.000    39.249
    68.000    39.302
    69.000    39.353
    70.000    39.404
    71.000    39.454
    72.000    39.504
    73.000    39.553
    74.000    39.603
    75.000    39.652
    76.000    39.699
    77.000    39.745
    78.000    39.790
    79.000    39.835
    80.000    39.881
    81.000    39.927
    82.000    39.971
    83.000    40.015
    84.000    40.059
    85.000    40.105
    86.000    40.146
    87.000    40.187
    88.000    40.251
    89.000    40.276
    90.000    40.291
    91.000    40.304
    92.000    40.313
    93.000    40.320
    94.000    40.328
    95.000    40.339
    96.000    40.351
    97.000    40.364
    98.000    40.378
    99.000    40.393
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    40.393 110
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    39.686
    26.000    39.743
    27.000    39.815
    28.000    39.901
    29.000    39.954
    30.000    39.993
    31.000    40.031
    32.000    40.074
    33.000    40.129
    34.000    40.197
    35.000    40.268
    36.000    40.340
    37.000    40.412
    38.000    40.485
    39.000    40.561
    40.000    40.638
    41.000    40.714
    42.000    40.789
    43.000    40.865
    44.000    40.941
    45.000    41.017
    46.000    41.093
    47.000    41.168
    48.000    41.242
    49.000    41.316
    50.000    41.389
    51.000    41.461
    52.000    41.531
    53.000    41.600
    54.000    41.669
    55.000    41.738
    56.000    41.807
    57.000    41.874
    58.000    41.939
    59.000    42.004
    60.000    42.069
    61.000    42.133
    62.000    42.195
    63.000    42.256
    64.000    42.316
    65.000    42.375
    66.000    42.434
    67.000    42.492
    68.000    42.550
    69.000    42.607
    70.000    42.663
    71.000    42.718
    72.000    42.773
    73.000    42.827
    74.000    42.882
    75.000    42.935
    76.000    42.987
    77.000    43.038
    78.000    43.088
    79.000    43.137
    80.000    43.187
    81.000    43.238
    82.000    43.287
    83.000    43.335
    84.000    43.384
    85.000    43.434
    86.000    43.479
    87.000    43.524
    88.000    43.595
    89.000    43.622
    90.000    43.639
    91.000    43.653
    92.000    43.663
    93.000    43.671
    94.000    43.679
    95.000    43.691
    96.000    43.705
    97.000    43.719
    98.000    43.735
    99.000    43.751
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    43.751 120
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    42.665
    26.000    42.727
    27.000    42.807
    28.000    42.899
    29.000    42.957
    30.000    43.000
    31.000    43.042
    32.000    43.089
    33.000    43.149
    34.000    43.224
    35.000    43.302
    36.000    43.380
    37.000    43.459
    38.000    43.539
    39.000    43.622
    40.000    43.706
    41.000    43.789
    42.000    43.871
    43.000    43.954
    44.000    44.037
    45.000    44.120
    46.000    44.203
    47.000    44.285
    48.000    44.366
    49.000    44.446
    50.000    44.526
    51.000    44.605
    52.000    44.682
    53.000    44.757
    54.000    44.832
    55.000    44.908
    56.000    44.983
    57.000    45.056
    58.000    45.127
    59.000    45.198
    60.000    45.269
    61.000    45.339
    62.000    45.407
    63.000    45.474
    64.000    45.539
    65.000    45.604
    66.000    45.668
    67.000    45.732
    68.000    45.794
    69.000    45.856
    70.000    45.918
    71.000    45.978
    72.000    46.037
    73.000    46.097
    74.000    46.157
    75.000    46.215
    76.000    46.272
    77.000    46.327
    78.000    46.381
    79.000    46.435
    80.000    46.490
    81.000    46.546
    82.000    46.599
    83.000    46.651
    84.000    46.705
    85.000    46.760
    86.000    46.809
    87.000    46.858
    88.000    46.935
    89.000    46.964
    90.000    46.983
    91.000    46.998
    92.000    47.009
    93.000    47.018
    94.000    47.027
    95.000    47.040
    96.000    47.055
    97.000    47.071
    98.000    47.087
    99.000    47.105
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    47.105 130
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    45.635
    26.000    45.703
    27.000    45.791
    28.000    45.889
    29.000    45.953
    30.000    45.999
    31.000    46.044
    32.000    46.096
    33.000    46.162
    34.000    46.243
    35.000    46.327
    36.000    46.412
    37.000    46.498
    38.000    46.585
    39.000    46.675
    40.000    46.766
    41.000    46.856
    42.000    46.946
    43.000    47.036
    44.000    47.126
    45.000    47.216
    46.000    47.306
    47.000    47.395
    48.000    47.483
    49.000    47.570
    50.000    47.657
    51.000    47.742
    52.000    47.826
    53.000    47.907
    54.000    47.989
    55.000    48.071
    56.000    48.152
    57.000    48.231
    58.000    48.309
    59.000    48.386
    60.000    48.463
    61.000    48.539
    62.000    48.613
    63.000    48.685
    64.000    48.756
    65.000    48.826
    66.000    48.895
    67.000    48.964
    68.000    49.033
    69.000    49.100
    70.000    49.166
    71.000    49.232
    72.000    49.296
    73.000    49.361
    74.000    49.425
    75.000    49.489
    76.000    49.550
    77.000    49.610
    78.000    49.669
    79.000    49.728
    80.000    49.787
    81.000    49.847
    82.000    49.905
    83.000    49.962
    84.000    50.020
    85.000    50.080
    86.000    50.132
    87.000    50.186
    88.000    50.269
    89.000    50.301
    90.000    50.321
    91.000    50.337
    92.000    50.349
    93.000    50.359
    94.000    50.369
    95.000    50.383
    96.000    50.399
    97.000    50.416
    98.000    50.434
    99.000    50.454
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    50.454 140
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    48.597
    26.000    48.671
    27.000    48.767
    28.000    48.871
    29.000    48.940
    30.000    48.990
    31.000    49.039
    32.000    49.095
    33.000    49.167
    34.000    49.254
    35.000    49.345
    36.000    49.437
    37.000    49.529
    38.000    49.624
    39.000    49.721
    40.000    49.819
    41.000    49.916
    42.000    50.013
    43.000    50.111
    44.000    50.208
    45.000    50.305
    46.000    50.402
    47.000    50.498
    48.000    50.593
    49.000    50.687
    50.000    50.780
    51.000    50.873
    52.000    50.962
    53.000    51.050
    54.000    51.139
    55.000    51.227
    56.000    51.315
    57.000    51.400
    58.000    51.484
    59.000    51.567
    60.000    51.650
    61.000    51.732
    62.000    51.811
    63.000    51.889
    64.000    51.966
    65.000    52.041
    66.000    52.116
    67.000    52.191
    68.000    52.264
    69.000    52.337
    70.000    52.408
    71.000    52.479
    72.000    52.549
    73.000    52.618
    74.000    52.688
    75.000    52.756
    76.000    52.823
    77.000    52.887
    78.000    52.951
    79.000    53.014
    80.000    53.078
    81.000    53.143
    82.000    53.206
    83.000    53.266
    84.000    53.329
    85.000    53.393
    86.000    53.450
    87.000    53.509
    88.000    53.597
    89.000    53.631
    90.000    53.653
    91.000    53.671
    92.000    53.684
    93.000    53.694
    94.000    53.705
    95.000    53.720
    96.000    53.738
    97.000    53.756
    98.000    53.776
    99.000    53.797
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    53.797 150
EOF
gmt plot $proj $reg -Wthick,red << EOF
    25.000    51.551
    26.000    51.631
    27.000    51.735
    28.000    51.845
    29.000    51.918
    30.000    51.973
    31.000    52.026
    32.000    52.086
    33.000    52.163
    34.000    52.257
    35.000    52.356
    36.000    52.454
    37.000    52.553
    38.000    52.655
    39.000    52.759
    40.000    52.865
    41.000    52.969
    42.000    53.073
    43.000    53.178
    44.000    53.282
    45.000    53.387
    46.000    53.491
    47.000    53.593
    48.000    53.695
    49.000    53.797
    50.000    53.897
    51.000    53.996
    52.000    54.092
    53.000    54.187
    54.000    54.281
    55.000    54.377
    56.000    54.471
    57.000    54.562
    58.000    54.652
    59.000    54.742
    60.000    54.830
    61.000    54.918
    62.000    55.004
    63.000    55.087
    64.000    55.169
    65.000    55.250
    66.000    55.331
    67.000    55.411
    68.000    55.490
    69.000    55.568
    70.000    55.644
    71.000    55.720
    72.000    55.795
    73.000    55.870
    74.000    55.944
    75.000    56.018
    76.000    56.089
    77.000    56.158
    78.000    56.226
    79.000    56.294
    80.000    56.363
    81.000    56.432
    82.000    56.500
    83.000    56.565
    84.000    56.633
    85.000    56.701
    86.000    56.762
    87.000    56.826
    88.000    56.919
    89.000    56.956
    90.000    56.980
    91.000    56.998
    92.000    57.012
    93.000    57.023
    94.000    57.035
    95.000    57.052
    96.000    57.070
    97.000    57.090
    98.000    57.111
    99.000    57.134
EOF
# Labels for sP-P depth curve
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jML << EOF
    99.000    57.134 160
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.574     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.135     7.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.272     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.041     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.955     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.105     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.263     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.811     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.302     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.814     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.690     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.573     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.881     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.919     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.919    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    50.267     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.363     5.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.671     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.159     6.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.221     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.133     6.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.729     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.937     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.152     9.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.087    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.227     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    27.427    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.928     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.633     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.440     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    41.936     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.999     7.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.378     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.725     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.276    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.210    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.210    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.582     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.957     9.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.957    13.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.057     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    36.057    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.886     8.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.138     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.405    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.566    11.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.314     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.807     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.756     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.346     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.970     5.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.534     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.059     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.222     6.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.460     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.515     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.645     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.392     6.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    84.930     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.715     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.549    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.460     8.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.555     8.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.289     8.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.289    13.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.289     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.289    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.511    14.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.600     8.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.022    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.592     8.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.163     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.188    11.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.169     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.767    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.748    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.891    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    83.064    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.121     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.648     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    27.445    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    27.681     7.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    27.919     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.389     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.465     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.801     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.463     7.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.551     6.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.640     6.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.822     7.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.617     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.744     6.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.988     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.687     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.817     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.277     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.157     7.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.531     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.791     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.201     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.556     6.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.212     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.249     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.057     6.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.644     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.947     5.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.252     5.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.511     6.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.914     5.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.974     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.693     6.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.167     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.778    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.080     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.274     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.602     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.643     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.433     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.850     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.468     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.397     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.397    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.080     6.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.996     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.991     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.366     8.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    85.366    12.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    93.136     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    98.060     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.309    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    84.453    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.079     9.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.771    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    60.304    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.531    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.484    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.028    10.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.337     8.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.327     8.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.263     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    43.514    10.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.025    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.128    10.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.486     9.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    57.806     5.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.806    10.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.640    10.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.794     9.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    61.016     9.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.199    10.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.269    10.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.342     9.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    63.139    10.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    65.807     9.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.504     9.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.702    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.839     9.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.985     9.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.352    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.249     9.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.617    10.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.269     9.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.465    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.761    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    83.273    10.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.599     9.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    84.988    10.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    94.761     9.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.631    18.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.395    16.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    64.397    19.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.531    18.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.324    25.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.791     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.991     6.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.511     7.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.152     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.866     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.443     6.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.630     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.729     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.902    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.111     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.218    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.769     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.598     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    41.744     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.931     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.412     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.600     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.518    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.854     4.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.445     5.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.316     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.744     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.527     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.895     4.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.137     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.329     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.545     5.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.994     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    63.364     5.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    63.773     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    64.562     5.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.582     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.914     5.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.493     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.006     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.903     5.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.271     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.704     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.809     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.809     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.807     6.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.044     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.533     5.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.034     5.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.218    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.218    22.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.218    13.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.218    21.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.956    13.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.956    19.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.918    20.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.135    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.135    19.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.878    14.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.878    20.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.588    16.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.588    15.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.438    14.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.212    14.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.281    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.372    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.531    13.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.840    13.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.162    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.694    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.875    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.599    13.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.998    14.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.327    17.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.112    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.301    17.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.775    18.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.281    14.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.281    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.897    14.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.897    17.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.410    15.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.580    15.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.116    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.116    22.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.116    15.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.116    21.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.609    14.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.320    16.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.324    14.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.324    21.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.367    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.566    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.237    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.286    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.286    22.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.482    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.756    15.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.139    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.415    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.415    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.479    14.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.771    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.203    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.243    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.526    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.538    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.027    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.056    16.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.541    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.795    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.418    15.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.447    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.981    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    36.459    22.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.619    18.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.511    15.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.125    16.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.507    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.114    16.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.768    16.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.858    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.048    18.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.152    17.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.025    16.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.940    22.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.845    25.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.091    24.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.667    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    65.885    23.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.526    22.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.937    23.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.629    27.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.204    27.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.825    27.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.870    16.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.870    27.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.470    16.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.658    18.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    92.839    23.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    93.413    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.715    12.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.452     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.051    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.558    12.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.212    11.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.612    15.707     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.995    16.840     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.168    16.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.358    16.629     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.886    16.027     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.195     5.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.261     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.261    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.583     5.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.803     8.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.804     9.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.855     9.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.496     9.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.948     3.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.192     7.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.126    13.039     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.110    15.990     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.334    16.580     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.453    15.980     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.655    22.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.793    21.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.623    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.948    10.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.593    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.457     9.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.627     9.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.454    12.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.395    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.582    11.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.623     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.372    17.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.172    12.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    79.180    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.073    10.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.047    11.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.649    12.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.756     9.486     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.121     9.220     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    34.968    10.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.862    13.170     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.664     9.538     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.534     9.101     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.147     9.130     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.824     9.860     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.651     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.340     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.413     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.634    10.268     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.827    10.277     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.016     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.715    10.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.842     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.194    10.351     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.260    13.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    43.226    16.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.396    18.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.214    14.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.010    12.781     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.883    16.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.375    18.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.641    13.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.641    18.598     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.399    18.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.569    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.983    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.067    18.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    80.972    18.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.809    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.528    11.691     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.770    12.559     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.886    12.469     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.952    12.629     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.381    12.270     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.393    12.281     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.552    12.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.956    12.527     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.349    10.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.142    12.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.475    12.660     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.499    12.590     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.871    12.988     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.951    12.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.052    12.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.129    12.324     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.501    12.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.522    12.371     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.839    12.719     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.530    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.530    12.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.618    12.773     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.651    12.590     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.280    12.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.084    12.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.191    12.672     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.614    12.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.801    12.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.989    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.227    12.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.798    12.547     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.889    12.762     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.674    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.717    12.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.884    12.672     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.946    12.992     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.408    12.809     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.603    12.770     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.864    12.629     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.112    12.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.748    12.992     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.748    13.426     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.748    19.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.610    13.348     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.869    12.852     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.086    12.949     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.099    12.953     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.302    13.039     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.930    12.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.017    13.039     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.330    12.348     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.330    12.137     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.740    12.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.517    14.211     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.705    12.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.884    13.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.025    13.352     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.686    13.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.200    13.031     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.457    13.121     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.130    14.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.949    13.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.180    12.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.180    17.352     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.046    13.348     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.400    11.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.511    12.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.552    13.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.547    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    65.771    17.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.558    12.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.984    13.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.948    13.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.948    17.832     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.709    12.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.026    13.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.187    12.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.510    11.742     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.897    12.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.897    18.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.133    11.637     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.390    13.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.390    18.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.634    19.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.656    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.656    18.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.690    18.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.757    17.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.414    12.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.414    18.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.708    13.277     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.337    13.344     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.996    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.519    12.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    76.519    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.160    12.652     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.986    13.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    80.986    19.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.667    19.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.990    13.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    82.990    19.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.466    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    93.615    13.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.382    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.382    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.680    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    27.680    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.171    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.171    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.434    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.641    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.651    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.651    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.656    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.368    11.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.940    13.170     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.124    12.706     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.511    13.477     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.933    13.440     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    43.689    13.851     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.736    13.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.195    12.603     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.182    14.270     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    53.389    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.745    13.860     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.564    13.420     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.515    17.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.661    14.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.155    17.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.696    14.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.696    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.800    14.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.847    16.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.494    19.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.584    14.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.641    18.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.951    19.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.533    10.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.980    13.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.918    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.375    16.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.722    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.835    13.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    79.835    17.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.937    15.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.143    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.389    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.333    12.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.162    12.376     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.546    13.313     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.546    19.013     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.218    14.550     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.773    13.573     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.014    14.420     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.112    14.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.025    12.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.158    12.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.342    13.775     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.142    13.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.683    19.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.683    19.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.592    13.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.592    19.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.592    13.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.592    19.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.644    14.225     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.518    19.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.775    12.780     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.021    14.180     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.687    14.180     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.811    13.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.494    13.560     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.131    13.270     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.270    14.060     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.385    13.290     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.102    13.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.102    14.180     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.783    13.840     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.401    14.270     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.486    13.980     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.600    13.530     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.864    14.530     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.918    14.550     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.069    13.990     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.334    13.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    91.655    12.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.081    13.641     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.795    13.527     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.847    13.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.158    13.621     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.216    13.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.071    13.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.083    13.309     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.656    13.492     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.465    13.707     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.126    13.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.196    14.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.081    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.677    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.324    15.470     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.927    15.271     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.252    17.226     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.457    16.220     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.470    15.540     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.470    15.851     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.278    14.920     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.229    16.040     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.622    16.030     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.917    17.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.363    15.460     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.956    15.450     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.432    16.050     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.131    17.979     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.057    15.860     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.788    17.925     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    45.088    25.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    60.723    24.886     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.730    26.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.024    18.649     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    79.482    18.705     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.115    14.133     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.336    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.761    14.148     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.470    14.125     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.470    20.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.911    14.109     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.911    14.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.619    13.426     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    34.619    20.449     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.736    14.430     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.064    14.262     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.109    14.023     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.140    14.738     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.989    21.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.029    15.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.168    23.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.168    35.863     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.236    22.223     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.485    23.941     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.691    23.418     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.606    23.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.744    22.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.083    23.789     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.665    23.789     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.716    24.031     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.867    23.395     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.939    23.582     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.145    23.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.188    24.230     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.195    24.277     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.265    24.840     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.265    35.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.678    23.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.953    24.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.150    22.691     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.199    24.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.323    23.180     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.907    23.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.976    23.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.273    23.688     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.892    23.238     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.903    24.320     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.227    24.047     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.314    24.031     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.603    23.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.635    25.168     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.635    37.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.876    24.262     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.876    35.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.061    25.340     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.396    23.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.438    25.492     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.611    24.152     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.449    25.211     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.587    25.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.654    24.918     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.924    24.789     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.987    25.148     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.115    24.941     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.244    24.660     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    40.244    35.590     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.718    24.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    40.718    34.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.176    24.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.793    24.289     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.345    23.379     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.461    25.129     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.846    25.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.559    25.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.718    25.660     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    46.718    36.453     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.685    25.148     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.600    25.012     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.600    35.832     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.877    25.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.976    25.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.341    23.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.204    25.531     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.302    25.137     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.330    24.719     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.500    26.039     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.483    25.109     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.483    25.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.483    36.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.500    25.930     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.407    24.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.463    25.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.170    25.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.557    25.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.153    28.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.533    27.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.082    28.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.357    28.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.609    27.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.987    28.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.727    27.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.354    28.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.628    26.133     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.628    26.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    91.388    26.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    91.388    27.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    93.510    26.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    96.676    26.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.005    13.516     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.211    12.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.533    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.015    11.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.298     9.649     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.687     9.550     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.683    10.050     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.991     9.725     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.668     9.540     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.020     8.960     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.229     9.409     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.835     9.630     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.992    10.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.590    10.351     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.171     9.990     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.288    10.260     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.352    10.640     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.992    10.080     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.977    10.439     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.475     9.601     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.465     8.960     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.953    10.210     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.518    10.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.296     9.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.376    10.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.711    10.012     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.485     8.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.218     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.203    11.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.315    10.502     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.879     9.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.098     9.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.823    10.230     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.884    11.260     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.164     8.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.680    10.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.683    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.902     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.583    10.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.610     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.747    10.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.880    10.210     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.835    10.290     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.051     9.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.374     9.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.464     6.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.657     9.860     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.766    10.439     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.048     9.950     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.578    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.838     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.883    10.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.287    10.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    98.645    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.677    13.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.389    13.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.389    19.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.462    13.480     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.462    19.258     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.819    13.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.819    19.352     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.208    13.609     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.023    13.895     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    54.574    18.844     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.066    14.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.109    13.352     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.551     5.530     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.800     7.790     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.892     8.440     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.144     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.455     4.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.983     9.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.173     4.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.666     4.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.893     4.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.664     4.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.863     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.940     9.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.983     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.938    12.230     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.985    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.707     9.449     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    56.887     8.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.369     9.711     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.487     9.221     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.811     8.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.056     9.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.573     9.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.573    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.572    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.799     9.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.064     8.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.291     9.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.266     8.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.266    14.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.048     9.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.327     9.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.491     8.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.699    10.279     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.877     9.490     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.961     9.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.784    10.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.931     9.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.273    10.281     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.940    14.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.065    14.559     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.065    14.451     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.171    15.230     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.248    10.041     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.248    14.689     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.430    16.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.818    14.109     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.983    14.830     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.429    16.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.124    14.852     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.362    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.668    15.023     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.466    14.613     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.172    15.975     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.183    14.711     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.184    16.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.409    13.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.608    14.740     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.993    10.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.425    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.504    10.477     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.504    10.555     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    36.297    11.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    41.108    10.438     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.081    10.117     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    43.887    11.430     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.911    10.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.541    11.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.173    12.695     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.001    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.365    11.422     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.671    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.896    12.141     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.158    11.977     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.817    11.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.065    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.168    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.199    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.378    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.445    11.875     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.599    11.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.011    12.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.319    11.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.365    11.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.660    12.445     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.466    10.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.882    13.633     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.311    11.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    84.087    11.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.562    14.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    40.578    16.594     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.773    15.094     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.589    11.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.848    14.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.339    14.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.722    14.195     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.269    15.695     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    80.207    15.641     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.120     6.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.673     9.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.228    12.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.115    11.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.424    11.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.890    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.212    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.981    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.497    10.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.499    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.556    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.721    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.894    11.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.930    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.991    11.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.033    11.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.213    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.399    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.399    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.428    11.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.427    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.851    11.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.191    11.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.196    11.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.359    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.400    12.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.442    11.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.486    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.249     9.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.271    12.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.413    10.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.355    11.512     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.523    11.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.670    11.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.775    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.356    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.771    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.918    10.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.719     6.758     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.829     6.617     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.698     6.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.830     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.559     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.886     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.849     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.996     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.325     7.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.820     9.320     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.345     7.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.686     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.151     7.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.210     7.094     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.351     7.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.932     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.041     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.160     7.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.180     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.434     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.791     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.888     7.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.400     8.621     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.414     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.609     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.317     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.317     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.097     6.387     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.257     7.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.297     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.296     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.391     7.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.567     7.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.831     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.998     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.107     7.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.119     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.199     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.299     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.726     7.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.945     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.483     7.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.652    10.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.698     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.628     7.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.611     7.824     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.314     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.576     7.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.874     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.971     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.938     7.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.775    23.320     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    34.343    23.883     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.535    14.371     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.840    16.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.716    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.564    16.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.977    15.828     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.991    15.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.029    15.359     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.799    15.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.403    15.188     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.493    14.547     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.403    15.809     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.326    15.824     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.132    16.582     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.287    16.789     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.287    24.309     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.155    17.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.184    17.961     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.320    16.789     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.456    17.477     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.381    15.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    61.381    25.129     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.629    24.727     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.849    17.688     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.939    17.492     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.946    17.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.336    17.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.459    18.082     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.674    16.598     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.958    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.230    17.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.298    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.245    16.977     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.096    17.453     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.306    18.809     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.146    18.629     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.676    17.559     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.984    17.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.984    17.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    89.212    17.070     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.312    13.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.709    14.899     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.709    20.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.380    13.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.931    13.550     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    27.779    16.320     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.999    10.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.292    11.430     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.024    11.852     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    27.853     8.899     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.836     7.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.672     9.601     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.842     9.601     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.847     7.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.865     7.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.453     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.593     7.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.600     7.399     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.698     7.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.774     6.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.877     7.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.906     7.101     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.085     7.601     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.307     6.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.391     7.399     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.715     7.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.072     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.739    20.992     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.797    21.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.008    22.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.385    21.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.452    21.531     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.177    21.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.413    21.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.413    21.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.676    22.422     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.739    21.562     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.370    22.348     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.151    21.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.262    21.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.414    21.461     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.600    22.027     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.624    22.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.635    21.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.948    21.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.014    21.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.598    22.148     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.997    21.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.185    22.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.364    21.660     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.038    21.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.038    22.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.402    22.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.252    23.941     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.459    23.117     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.190    21.918     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.612    22.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    41.612    34.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.051    22.188     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.547    22.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.830    23.070     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.823    22.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.835    22.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.317    23.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.250    24.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.080    24.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.017    23.469     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.197    22.992     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.386    25.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.265    23.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.815    23.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.136    24.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.025    24.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.391    24.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.779    24.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.805    24.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.930    24.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.325    24.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.727    24.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.568    24.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.257    24.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.246    24.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.259    16.508     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.631     7.758     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.276     7.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.526     9.023     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.526     8.148     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.801     7.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    61.727     9.992     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.523    10.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.723    11.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.732     9.195     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.630    12.082     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.620    11.824     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.426    10.844     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.053    11.855     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.390    12.578     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.248    12.852     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.949    11.039     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.966    21.965     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.883    23.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.586    21.719     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.392    23.770     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    57.135     8.379     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    60.220     8.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.223     8.176     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.590     7.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.590     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.688     8.125     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.898     8.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.957    15.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.757    15.004     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.195    11.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.796    12.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.464    12.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.086    11.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.883    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.781    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.028    12.176     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.079    12.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.079    18.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.316    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.092    12.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.092    18.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.251    12.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.447    12.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.764    13.449     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.841    12.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.830    13.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.830    20.055     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.870    15.656     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.365    15.617     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.846    21.691     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.307    20.930     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.001    20.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.618    21.480     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.848    21.512     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.997    21.430     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.022    23.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.212    22.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.260    21.129     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.618    20.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.893    21.047     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.529    20.453     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.126    21.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.699    22.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.022    21.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.633    20.629     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.646    23.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.796    22.949     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.037    21.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.142    22.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.666    22.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.362    21.840     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.018    22.949     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.018    22.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.127    22.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.211    22.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.188    25.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.368    32.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.200    24.230     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    92.866    24.641     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.164    13.525     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    52.601    19.742     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.755    12.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.755    17.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.113    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.265    11.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.265    16.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.244    11.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.048    13.540     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    26.246    13.950     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.383    13.340     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.973    14.120     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.037    14.370     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.003    14.490     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.046    14.280     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.351    14.720     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.812    14.490     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.884    11.770     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.981    12.740     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.905    14.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.118    12.360     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.118    13.430     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.119    12.920     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.119    13.675     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.306    14.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.797    15.170     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.033    13.420     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.112    13.580     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.153    13.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.539    13.675     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.539    12.310     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.539    12.540     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.459    14.380     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.656    13.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.796    14.980     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.024    14.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.065    15.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    36.214    14.860     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.816    14.110     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.562    15.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.642    13.310     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.100    14.890     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.806    14.290     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.384    14.660     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.894    14.890     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.460    14.717     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.695    13.670     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.532    15.690     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.877    12.970     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.691    13.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.965    13.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.269    13.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.414    13.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.444    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.995    15.180     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.713    13.530     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.951    14.310     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.222    12.590     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.638    13.530     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.766    13.470     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.512    13.580     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.634    14.110     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.829    14.083     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.879    13.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.389    14.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.288    14.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.588    15.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.823    13.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.892    14.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.598    13.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.598    21.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.892    15.165     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.786    14.950     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    85.402    16.050     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    92.353    14.810     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    97.835    15.814     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.331    13.223     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.488    13.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.390    13.590     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.849    12.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.852    12.453     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.515    13.629     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.668    13.848     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.638    12.121     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.672    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.003    22.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.359    12.105     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.192    12.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.329    11.695     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.081    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.799    12.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.366    12.422     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.976    13.078     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.748    13.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    60.985     7.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    68.150     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.150    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.604     4.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.816     5.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.813     7.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.519     6.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.421     7.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.957     8.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.377     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.150     9.094     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.975     5.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.378    10.720     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.380    10.717     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.959    14.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.450    10.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.450    10.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.450    11.260     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.940    10.630     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.490    10.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.698    11.475     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.077    10.925     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.418    10.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.288    11.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.429    11.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.393    10.988     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.393    10.510     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.296    11.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.296    11.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.784    11.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.784    11.017     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.784    10.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.083    11.080     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.083    11.080     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.445    10.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.448    10.525     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.448    10.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.758    10.720     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.758    10.725     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.911    10.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.911    10.525     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.896    10.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.405    10.720     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.405    10.725     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.919    11.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.249    11.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.384    10.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.530    12.760     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.557    11.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.604    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.626    12.690     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.842    11.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.850    12.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.451    12.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.476    12.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.578    10.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.644    11.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.644    11.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.744    11.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.986    12.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.045    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.077    12.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.765    10.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.059    10.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.639    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.730    11.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.770    11.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.807     9.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    77.328    14.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.001    14.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.436    11.710     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.437    11.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.487    11.690     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.636    12.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.603    14.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.088    11.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.521    11.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.533    11.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.919    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.935    11.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.087    11.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.166    11.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.479    10.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.648    11.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.921    11.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.164    11.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.221    11.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.255    11.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.409    11.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.496    11.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.587    12.050     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.654    11.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.774    11.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.792    11.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.892    16.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.430    11.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.431    11.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.542    11.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.542    11.550     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.485    11.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    26.567    21.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.233    21.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.258    21.711     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.264    21.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.375    21.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.391    21.859     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.406    22.432     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.443    21.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.611    22.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.639    21.510     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.653    21.369     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.653    20.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.660    21.561     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.722    21.711     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.815    21.760     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.819    22.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.318    22.451     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.327    21.361     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.750    22.070     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.750    21.760     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.750    20.678     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.750    21.240     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.975    21.311     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.997    22.871     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.024    21.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.279    20.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.705    21.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.720    22.129     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.727    21.889     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.813    22.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.814    21.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.406    21.959     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.565    21.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.565    22.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.576    22.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.680    22.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.691    21.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.737    22.080     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.737    22.240     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.837    22.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.884    22.389     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.179    22.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.194    22.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.219    21.920     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.339    22.650     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.343    21.760     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.422    21.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.867    22.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.926    22.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.119    22.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.148    22.359     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.152    21.961     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.271    22.311     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.323    22.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.339    21.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.374    21.859     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.425    22.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.425    21.859     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.435    22.260     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.438    22.471     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.450    22.260     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.457    22.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.537    21.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.542    21.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.682    22.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.744    22.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.843    21.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.117    22.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.230    22.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.322    22.021     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.429    21.941     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.663    22.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.969    21.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.169    22.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.396    22.658     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.546    22.340     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.079    21.961     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.200    22.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.226    20.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.226    22.609     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.313    23.059     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.639    22.609     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.769    22.709     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.412    22.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    40.899    22.459     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.737    23.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.830    22.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.849    22.760     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.996    22.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.324    22.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.409    22.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.922    22.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.971    22.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.744    22.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.226    23.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.484    22.859     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.593    22.449     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.886    22.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.162    22.451     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.311    22.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.573    22.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.686    22.410     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.770    22.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.438    22.650     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.617    22.479     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.619    22.061     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.714    22.609     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.985    22.951     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.043    21.879     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.115    22.510     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.144    22.461     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.196    21.959     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.201    21.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.396    22.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.447    22.309     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.480    22.449     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.733    22.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.810    23.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.812    23.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.812    22.609     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.055    22.809     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.129    22.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.131    22.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.598    22.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.677    22.709     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.682    23.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.833    21.670     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.908    23.049     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.014    23.061     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.054    22.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.137    21.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.419    22.729     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.419    22.971     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.473    22.830     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.614    23.320     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.646    22.920     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.740    23.121     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.820    23.170     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.198    22.770     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.515    21.770     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.699    22.879     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.730    23.070     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.839    22.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.860    22.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.251    23.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.109    22.531     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.173    22.971     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.042    22.869     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.317    22.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.147    22.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.151    22.406     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.358    33.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.301    23.881     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.455    23.531     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.834    33.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.049    33.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.080    23.631     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.080    33.641     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.387    23.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.354    22.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.608    24.818     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.788    24.871     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.792    24.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.251    23.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    92.889    24.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.284     9.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.295    10.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.342     9.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.522     9.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.740    11.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.919    10.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.265    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.537     9.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.557     9.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.095    13.729     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.392    14.225     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.831    14.854     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.245    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.563    12.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.472    12.660     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.916    12.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.363    13.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.832    14.029     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.058    12.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.881    13.111     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.037    13.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.039    13.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.624    11.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.641    12.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.343    19.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.957    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.341    14.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.510    13.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.771    13.131     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.439    14.619     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.684    13.209     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.590    12.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.823    13.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.021    12.930     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.125    12.660     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.345    13.490     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.510    13.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.261    13.211     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.085    13.891     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.544    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.982    13.891     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.799    13.430     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.998    13.076     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.251    13.480     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.895    14.250     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.368    14.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.370    14.025     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.921    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.233    13.951     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.025    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.347    14.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.464    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.648    12.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.648    20.357     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.700    14.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.782    13.590     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.800    13.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.810    13.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.936    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.910    13.271     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.138    12.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.300    13.709     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.517    14.170     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.686    14.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.797    14.125     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.796    13.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.970    13.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.222    13.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.312    12.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.572    13.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.905    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.328    14.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.557    14.928     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.206    13.947     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.798    14.080     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.906    14.281     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.211    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.595    14.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.993    14.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.192    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.366    14.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.500    14.580     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.478    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.739    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.970    14.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.060    14.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.205    13.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.351    14.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.459    14.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.893    14.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.900    14.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.312    14.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.312    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.459    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.872    14.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.020    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.296    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.533    13.074     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.536    14.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.639    12.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.870    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.032    14.799     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.153    14.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.165    14.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.267    14.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.728    14.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.861    14.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.162    14.119     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.813    14.389     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    88.308    14.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.344    11.828     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.812    10.945     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    43.806    10.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.390    11.055     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.231    11.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.482    11.875     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.683     9.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    81.014    11.227     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.353    10.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.182    12.074     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.627    12.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.820    13.436     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.015    18.234     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.169    19.281     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.020    20.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.129    14.438     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.129    20.078     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.477    14.879     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.477    20.332     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.106    13.125     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.724    14.883     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.400    13.598     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.672    15.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.958    14.246     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.281     3.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    68.281     4.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.243    11.018     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.736    11.550     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.924    13.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.168    12.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.225    13.094     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.948    13.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    28.293    15.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.571    13.748     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    29.958    13.334     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.879    14.027     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    32.748    15.260     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.362    11.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.413    13.439     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.413     9.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.413    15.330     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    38.470    15.330     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.095    16.260     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    42.992    15.484     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    43.781    15.330     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.344    14.900     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.750    15.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.731    15.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.392     9.670     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.423    16.180     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.976    15.895     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.229    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.945    11.061     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    60.945    15.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.092    11.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.162    12.939     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.550    15.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    66.945    14.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.475    15.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.572    15.949     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.750    15.080     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.742    16.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.489     7.101     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.564     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.260     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.261     7.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.565     7.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.968    10.762     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.425    10.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.308    10.701     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.635    10.676     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    61.897    10.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.798    10.775     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.798    10.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.363    10.977     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.338    10.594     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.806    10.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.806    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.419    11.150     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.433    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.938    14.289     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.454    13.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.527    11.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.642    12.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.936    10.025     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.531    11.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.142     6.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.570     9.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.658     8.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.018     5.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    68.018     8.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.320     6.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.359     6.730     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.409     6.938     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.419     7.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.448     7.312     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.933     9.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.264     6.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.328     5.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.383     6.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.432     6.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.639     6.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.862     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.944     6.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.269     5.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.629     6.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.238     6.508     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.515     6.711     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.623     5.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.060    14.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.315    17.828     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.402    18.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.336    18.789     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.153    17.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.748    18.992     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.858    17.211     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.577    18.289     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.405    19.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.426    20.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.647    26.891     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.278    19.359     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.278    28.281     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.437    18.867     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.437    27.367     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    51.228    18.461     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.120    18.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.130    19.609     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.584    19.512     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    62.584    28.070     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.508    21.328     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.376    20.711     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.842    27.121     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.038    19.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.247    21.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.606    10.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.081    10.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.385    10.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.829    10.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.083    10.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.638    11.695     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    59.798    13.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    59.798    18.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.101    13.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.888    13.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.018    12.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    68.018    18.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.044    13.555     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.355    14.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.617    14.164     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.026    14.258     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.467    13.555     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.775    13.805     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.775    20.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.776    14.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.275    13.555     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.275    13.406     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.322    13.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.438    13.539     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.525    13.586     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.620    14.031     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.799    12.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.946    11.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.245    12.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.245    12.305     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.243    13.836     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.720    12.297     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.372    17.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.538    16.598     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.538    24.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.708    10.789     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.807    11.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    34.709    12.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    44.596    12.859     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.097    11.078     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    46.354    12.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.105    12.777     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.373    11.809     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.535    12.328     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.535    11.383     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.781    12.359     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    60.036    13.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.296    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    64.701    12.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.343    12.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.660    13.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.558    13.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.781    13.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.013    13.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.066    14.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.250    13.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    80.532    12.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    28.075    14.371     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    32.703    16.881     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.080    15.170     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.080    14.840     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.413    14.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.413    16.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.156    15.561     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.601    17.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.485    15.100     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    67.485    16.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.104    18.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.594    18.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.563    22.672     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.646    22.594     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.656    20.172     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.937    23.422     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    52.978    22.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.182    22.547     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    55.182    33.812     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    58.199    25.047     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.181    24.008     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.326    23.641     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.008    23.969     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.074    23.797     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.201    24.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.944    24.648     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.203    30.279     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.622    30.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.691    30.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.753    30.139     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.120    29.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    49.270    29.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.465    31.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.663    33.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    30.290    13.375     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.702    13.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    31.702    20.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.935    31.461     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.131    30.820     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.270    33.148     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    62.565    33.391     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.059    33.547     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.172     3.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.921    14.383     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.086    15.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    60.837     9.902     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.172    10.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.717    10.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    76.965    10.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.632     8.020     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.159     8.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.540     7.490     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.263     8.890     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    42.572     8.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.607     8.450     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.815     9.560     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.022     7.790     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    53.332     7.420     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    54.929     8.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.202     7.350     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.306     8.380     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.850     8.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.965     8.010     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.225     7.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.127     6.840     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.139     6.760     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.633     6.910     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.683     6.610     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.229     7.420     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.458     6.390     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.462     6.540     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    75.503     6.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    82.882     6.990     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.083     6.690     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.345     7.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.756     8.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    37.206     8.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    56.583     8.432     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.592     5.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    68.592     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.815     7.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.482     8.240     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.426     8.859     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.757     8.039     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.257     9.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.368     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.397     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.454     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    70.702     7.630     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.044     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.115     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.188     7.630     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.443     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.496     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.695     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.864     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.205     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.416     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.724     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.749     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.833     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.957     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.054     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.100     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.416     7.200     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.650     6.700     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.654     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.673     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.348     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.351     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.425     6.300     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.683     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    74.719     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    75.169     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    77.027     7.640     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    77.297     7.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    80.435     8.220     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    80.461     7.740     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    80.630     7.960     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    80.944     7.450     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.081     7.880     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.157     7.780     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.528     7.460     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    81.736     6.930     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    82.002     7.680     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    82.154     7.850     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    82.299     7.720     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.144    16.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.590    16.400     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.590    15.990     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    37.634    16.232     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.638    16.877     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.759    15.990     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.863    15.715     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.514    16.971     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    49.738    17.221     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.516    16.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.390    14.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    67.267    16.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.829    15.531     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.047    13.957     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    34.047    14.320     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.167    14.598     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.167    21.668     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.170    14.848     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.170    21.457     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.421    13.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    38.393    14.996     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    39.060    15.230     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.158    15.418     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    45.208    15.352     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    47.769    15.441     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.812    15.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.509    14.781     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.662    13.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.662    14.512     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    68.697    14.098     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.949    13.480     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.473    14.402     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.487    14.062     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.817    13.871     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.838    14.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.951    14.883     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.973    14.340     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    71.973    21.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.477    14.090     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.979    14.281     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.895    14.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.485    19.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.409     9.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    31.461     6.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.639     6.811     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    41.778     7.160     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    57.233     9.270     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    58.764     9.570     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.559     8.379     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    65.149    10.311     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    65.409    10.299     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.852     8.541     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    72.071    11.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    73.034     9.740     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.468    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    36.381    20.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.494    14.723     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    71.696    15.848     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.505    15.203     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    78.375    17.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    78.375    23.699     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    79.786    16.500     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    69.812     4.102     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.059    16.953     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.779    16.750     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    72.114    17.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.839    18.129     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    33.839    27.301     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.405    17.551     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    35.405    26.840     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    35.961    16.801     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    39.289    18.453     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.933    17.969     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    47.423    27.340     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    48.182    18.828     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
    48.733    27.492     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    50.024    18.520     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    70.450    27.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    77.307    20.480     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    27.092    12.844     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.897    12.703     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    64.331    13.543     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    66.238    14.051     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    83.277    12.898     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    69.359     8.040     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.396     5.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.609     5.800     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.911     5.600     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.624     7.101     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.991     5.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.105     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.356     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.568     7.602     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    73.871     7.199     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.583     8.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    74.950     7.398     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    29.823    15.727     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    30.870    15.000     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    33.151    14.422     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    44.273    16.625     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    55.869    14.422     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    63.944    16.578     0.200
EOF
# Legend
gmt text $proj $reg -F+f12p,Helvetica,green+a0.+jBL << EOF
    26.000    57.340 Green for pP-P
EOF
gmt text $proj $reg -F+f12p,Helvetica,red+a0.+jBL << EOF
    26.000    53.680 Red for sP-P
EOF
gmt end
