#!/bin/bash
gmt begin kodiak1.21_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases kodiak1.21'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     0.500     3.681
     1.000    -0.856
     1.500    -4.608
     2.000    -8.225
     2.500   -11.803
     3.000   -15.365
     3.500   -18.920
     4.000   -22.472
     4.500   -26.026
     5.000   -29.579
     5.500   -33.134
     6.000   -36.692
     6.500   -40.255
     7.000   -43.822
     7.500   -47.394
     8.000   -50.971
     8.500   -54.554
     9.000   -58.144
     9.500   -61.740
    10.000   -65.344
    10.500   -68.956
    11.000   -72.575
    11.500   -76.204
    12.000   -79.842
    12.500   -83.489
    13.000   -87.145
    13.500   -90.813
    14.000   -94.491
    14.500   -98.180
    15.000  -101.881
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -84.145 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000    -4.000 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     7.004    -2.972     0.200
    11.362    12.765     0.200
    12.968    -4.676     0.200
     6.881    -3.459     0.200
    12.819     4.744     0.200
     3.866    -4.766     0.200
     4.009    -1.092     0.200
     5.873    -5.941     0.200
    12.840    -0.387     0.200
    14.863    -2.312     0.200
    14.693    -8.147     0.200
    13.163   -11.696     0.200
    14.053   -15.564     0.200
     8.876   -11.611     0.200
     3.693    -0.712     0.200
     2.768    -0.986     0.200
     8.261     3.220     0.200
     3.050    -2.551     0.200
     4.430    -5.605     0.200
     4.453    -5.740     0.200
    15.226    -4.811     0.200
     9.147   -10.606     0.200
    15.163    -4.316     0.200
     9.079    -7.934     0.200
     7.771    -1.570     0.200
     8.236   -10.479     0.200
     7.657    -3.789     0.200
     7.663    -2.783     0.200
     7.630    -3.456     0.200
     7.235    -0.687     0.200
    13.427   -13.059     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
    21.702  -147.151     0.200
    23.282  -170.943     0.200
    14.194  -101.399     0.200
     7.118   -45.415     0.200
    15.686  -106.459     0.200
    20.836  -143.726     0.200
     4.036   -26.363     0.200
    14.759  -109.591     0.200
    16.551  -109.847     0.200
     1.195     0.008     0.200
     1.221     0.868     0.200
     1.228    -1.027     0.200
     1.523    -2.845     0.200
     1.641    -4.805     0.200
     1.856    -6.332     0.200
     1.968    -7.882     0.200
     2.152    -9.968     0.200
     2.246    -9.674     0.200
     2.319    -8.517     0.200
     2.511   -11.581     0.200
     2.873    -9.733     0.200
     2.938   -16.686     0.200
     3.145   -15.374     0.200
     3.629   -19.573     0.200
     3.942   -23.779     0.200
     4.291   -28.151     0.200
     4.306   -29.944     0.200
     4.443   -29.755     0.200
     4.481   -31.814     0.200
     4.570   -28.938     0.200
     4.584   -31.368     0.200
     4.625   -30.410     0.200
     4.691   -33.346     0.200
     4.718   -30.730     0.200
     4.735   -31.410     0.200
     4.755   -31.742     0.200
     4.911   -31.384     0.200
     5.076   -34.668     0.200
     5.107   -33.732     0.200
     5.285   -34.640     0.200
     5.444   -36.172     0.200
     5.781   -39.113     0.200
     6.285   -44.061     0.200
     2.141    -8.192     0.200
     2.770   -10.995     0.200
     4.302   -21.776     0.200
     0.818     0.612     0.200
     3.670   -18.100     0.200
     3.810   -22.918     0.200
     0.773     1.016     0.200
     1.243    -0.986     0.200
     1.572    -3.642     0.200
     1.669    -4.249     0.200
     1.816    -6.544     0.200
     1.877    -6.048     0.200
     1.854    -5.946     0.200
     2.106   -10.009     0.200
     2.588   -12.615     0.200
     2.760   -13.488     0.200
     2.923   -16.565     0.200
     3.373   -17.636     0.200
     3.436   -17.856     0.200
     3.441   -18.020     0.200
     3.578   -18.711     0.200
     3.706   -24.199     0.200
     3.729   -23.227     0.200
     3.743   -21.680     0.200
     4.131   -27.366     0.200
     4.133   -27.597     0.200
     4.251   -30.109     0.200
     4.561   -31.032     0.200
     7.434   -51.253     0.200
     0.849     9.521     0.200
     1.189     4.071     0.200
     1.205     4.462     0.200
     1.373     2.240     0.200
     2.253    -6.096     0.200
     2.332    -6.929     0.200
     2.490   -11.217     0.200
     3.071   -13.182     0.200
     4.294   -28.234     0.200
     5.704   -36.559     0.200
     1.357    -2.414     0.200
     1.357    -1.762     0.200
     1.511    -3.811     0.200
     2.506   -10.931     0.200
     2.666   -11.177     0.200
     3.469   -15.456     0.200
     4.045   -25.417     0.200
     4.449   -27.422     0.200
     4.915   -30.250     0.200
     5.147   -33.760     0.200
     5.147   -32.901     0.200
     5.509   -36.609     0.200
     7.109   -48.891     0.200
     7.621   -50.249     0.200
     8.841   -60.170     0.200
     0.252    12.221     0.200
     0.641     6.172     0.200
     0.632     5.381     0.200
     0.689     6.108     0.200
     0.996     2.399     0.200
     1.151    -0.144     0.200
     1.410    -0.784     0.200
     1.414    -1.794     0.200
     1.490    -2.920     0.200
     6.893   -46.906     0.200
     9.675   -69.695     0.200
     2.037    -6.966     0.200
     2.122    -8.992     0.200
     4.314   -28.007     0.200
     9.686   -66.192     0.200
    10.144   -71.904     0.200
     0.830     2.146     0.200
     0.828     4.177     0.200
     1.536    -3.779     0.200
     1.713    -5.487     0.200
     1.871    -5.528     0.200
     1.932    -6.833     0.200
     1.979    -7.400     0.200
     2.192   -10.673     0.200
     7.427   -52.231     0.200
     9.899   -68.398     0.200
     1.828    -5.899     0.200
     2.362    -9.212     0.200
     7.154   -48.513     0.200
     0.553    17.544     0.200
     0.613    16.343     0.200
     0.617    16.522     0.200
     0.637    16.785     0.200
     0.734    15.623     0.200
     1.154     8.394     0.200
     1.352     5.138     0.200
     1.471     3.041     0.200
     1.677     1.708     0.200
     1.684     1.091     0.200
     1.702     1.729     0.200
     1.751     1.286     0.200
     1.923    -1.468     0.200
     2.038    -3.109     0.200
     2.072    -2.506     0.200
     2.144    -3.469     0.200
     2.180    -5.433     0.200
     2.306    -5.932     0.200
     2.432    -8.501     0.200
     3.493   -16.647     0.200
     4.659   -29.623     0.200
     7.201   -52.590     0.200
     2.114    -4.971     0.200
     2.117    -5.473     0.200
     2.129    -5.158     0.200
     2.398   -10.478     0.200
     2.864   -13.445     0.200
     3.334   -17.455     0.200
     3.726   -21.190     0.200
     3.758   -19.900     0.200
     3.848   -22.247     0.200
     3.998   -22.890     0.200
     7.146   -45.001     0.200
     0.646     4.870     0.200
     0.974     1.871     0.200
     1.148    -0.761     0.200
     1.206     0.113     0.200
     1.440     2.257     0.200
     2.090    -4.925     0.200
     2.413    -6.658     0.200
     1.057     0.867     0.200
     1.244    -0.840     0.200
     1.298    -2.875     0.200
     1.368    -3.788     0.200
     1.574    -4.812     0.200
     1.551    -4.082     0.200
     1.928    -6.723     0.200
     1.964    -6.686     0.200
     2.671   -10.278     0.200
     2.997   -18.107     0.200
     6.805   -46.136     0.200
    12.003   -83.620     0.200
     0.587     4.760     0.200
     0.644     2.746     0.200
     0.935    -0.275     0.200
     0.989     1.108     0.200
     1.035    -1.051     0.200
     1.234    -1.551     0.200
     1.298    -1.677     0.200
     1.401    -1.424     0.200
     1.425    -1.107     0.200
     1.427    -1.458     0.200
     1.428    -1.693     0.200
     1.674    -5.399     0.200
     1.872    -6.578     0.200
     2.092    -8.536     0.200
     2.145    -8.223     0.200
     7.576   -52.497     0.200
     0.875     0.827     0.200
     1.219    -2.480     0.200
     1.364    -2.777     0.200
     0.425     4.616     0.200
     1.901    -6.575     0.200
     1.949    -5.907     0.200
     2.001    -8.350     0.200
     2.272   -11.255     0.200
     2.235    -9.275     0.200
     2.529   -11.281     0.200
     2.531   -11.445     0.200
     2.532   -13.085     0.200
     2.577   -12.014     0.200
     2.852   -18.125     0.200
     3.055   -15.258     0.200
     3.218   -19.324     0.200
     3.216   -17.873     0.200
     3.783   -23.943     0.200
     4.204   -26.987     0.200
     4.246   -29.325     0.200
     4.367   -28.740     0.200
     4.872   -32.045     0.200
     7.628   -54.124     0.200
     1.101     0.458     0.200
     1.271    -2.629     0.200
     1.458    -3.347     0.200
     1.489    -3.133     0.200
     1.475    -3.794     0.200
     1.804    -5.407     0.200
     2.213   -10.071     0.200
     2.267   -10.403     0.200
     2.583   -11.398     0.200
     2.983   -18.471     0.200
     3.305   -19.899     0.200
     3.539   -23.025     0.200
     3.519   -16.967     0.200
     3.876   -22.010     0.200
     3.915   -25.429     0.200
     4.361   -30.063     0.200
     4.678   -29.909     0.200
     4.807   -31.908     0.200
     5.081   -32.886     0.200
     5.194   -33.287     0.200
     5.538   -34.782     0.200
     7.498   -54.324     0.200
     7.576   -52.574     0.200
     0.438    10.975     0.200
     0.738     5.770     0.200
     0.912     4.546     0.200
     1.051     2.343     0.200
     1.088     1.495     0.200
     1.211     0.774     0.200
     1.324    -0.908     0.200
     1.346     0.507     0.200
     1.358    -0.380     0.200
     1.365    -0.805     0.200
     1.656    -2.712     0.200
     1.660    -3.958     0.200
     1.960    -5.860     0.200
     2.014    -7.164     0.200
     2.034    -7.093     0.200
     2.051    -6.358     0.200
     2.066    -6.009     0.200
     2.103    -6.104     0.200
     2.197    -8.669     0.200
     2.453    -7.288     0.200
     2.485   -12.105     0.200
     2.531    -8.373     0.200
     2.543   -10.946     0.200
     3.235   -17.174     0.200
     3.908   -25.624     0.200
     4.329   -28.451     0.200
     4.396   -28.096     0.200
     4.486   -29.324     0.200
     4.769   -28.522     0.200
     4.808   -28.336     0.200
     4.989   -34.168     0.200
     5.702   -37.987     0.200
     6.404   -42.643     0.200
     7.583   -51.123     0.200
     0.521     8.941     0.200
     0.732     5.771     0.200
     0.906     3.759     0.200
     0.884     4.242     0.200
     0.962     3.653     0.200
     0.964     2.409     0.200
     1.326    -1.180     0.200
     1.579    -1.808     0.200
     1.673    -3.662     0.200
     2.106    -8.788     0.200
     2.895   -15.205     0.200
     3.781   -23.297     0.200
     6.068   -41.600     0.200
     6.472   -45.704     0.200
     7.195   -50.703     0.200
     0.763     1.868     0.200
     1.623    -5.790     0.200
    12.631   -86.262     0.200
     0.710     0.613     0.200
     3.771   -24.436     0.200
     4.164   -25.000     0.200
     5.448   -36.890     0.200
     6.899   -44.783     0.200
     1.915    -5.868     0.200
     6.980   -46.687     0.200
    11.431   -78.087     0.200
     0.098    23.366     0.200
     0.095    23.151     0.200
     0.344    16.273     0.200
     0.567    11.203     0.200
     0.798     8.666     0.200
     1.157     4.284     0.200
     1.175     4.429     0.200
     1.470     0.188     0.200
     1.809    -3.677     0.200
     1.858    -3.940     0.200
     1.902    -4.717     0.200
     2.166    -6.998     0.200
     3.938   -24.578     0.200
     4.688   -29.654     0.200
     6.399   -42.472     0.200
     6.837   -49.676     0.200
     7.386   -51.683     0.200
    12.991   -89.362     0.200
     8.240   -54.710     0.200
     8.256   -56.294     0.200
    12.908   -86.367     0.200
     2.161    -5.876     0.200
     2.415    -7.765     0.200
     2.450    -9.198     0.200
     3.711   -15.361     0.200
     7.805   -48.952     0.200
    12.056   -74.305     0.200
     0.893    -0.624     0.200
     2.037    -7.331     0.200
     2.645   -12.638     0.200
     5.717   -38.149     0.200
     8.202   -56.358     0.200
    14.350   -97.969     0.200
     1.224    -3.611     0.200
     2.638   -13.557     0.200
     2.694   -14.530     0.200
     8.197   -57.192     0.200
     0.407     8.551     0.200
     0.520     6.896     0.200
     0.618     4.910     0.200
     0.756     3.421     0.200
     0.781     2.932     0.200
     0.754     3.574     0.200
     0.803     3.424     0.200
     0.959     0.530     0.200
     0.952     1.277     0.200
     1.058    -0.224     0.200
     1.181    -1.393     0.200
     1.465    -4.137     0.200
     1.497    -4.623     0.200
     1.533    -3.814     0.200
     1.819    -6.723     0.200
     1.978    -6.509     0.200
     3.588   -20.320     0.200
     6.173   -44.024     0.200
     6.971   -47.895     0.200
     0.717     1.304     0.200
     0.922     0.001     0.200
     1.116     0.170     0.200
     7.716   -57.307     0.200
    12.542   -87.414     0.200
    15.701  -112.641     0.200
     1.215    -1.766     0.200
     1.355    -2.503     0.200
     1.455    -2.526     0.200
     1.927    -7.906     0.200
     2.055    -7.636     0.200
     3.942   -26.432     0.200
     4.077   -29.226     0.200
     4.385   -30.737     0.200
     4.601   -28.933     0.200
     5.672   -38.549     0.200
     7.282   -47.844     0.200
     1.544    -4.965     0.200
     6.253   -39.817     0.200
     6.264   -40.499     0.200
     6.928   -46.779     0.200
     7.577   -50.336     0.200
    12.592   -85.562     0.200
    15.827  -111.764     0.200
     0.942     0.296     0.200
     1.197     0.075     0.200
     2.245    -7.853     0.200
     8.457   -60.730     0.200
     1.900    -4.763     0.200
     3.811   -22.234     0.200
     3.854   -24.302     0.200
     5.675   -39.372     0.200
     5.901   -41.407     0.200
     5.936   -39.297     0.200
     6.068   -40.911     0.200
     8.110   -57.136     0.200
     0.624     2.362     0.200
     0.963     0.781     0.200
     0.990    -0.937     0.200
     1.011     0.941     0.200
     1.048    -0.190     0.200
     1.118    -0.303     0.200
     1.277    -1.340     0.200
     1.496    -4.045     0.200
     1.646    -5.571     0.200
     2.133    -8.114     0.200
     4.449   -30.894     0.200
     7.089   -47.005     0.200
     0.060    31.823     0.200
     0.271    26.620     0.200
     0.328    25.217     0.200
     0.351    24.176     0.200
     0.434    22.624     0.200
     0.515    20.243     0.200
     0.555    19.166     0.200
     0.609    19.185     0.200
     0.619    18.266     0.200
     0.690    17.684     0.200
     0.769    15.844     0.200
     0.898    13.379     0.200
     1.222     7.988     0.200
     1.873    -2.074     0.200
     1.902    -1.765     0.200
     2.229    -3.273     0.200
     2.282    -4.287     0.200
     2.290    -4.435     0.200
     2.356    -5.645     0.200
     2.740   -10.136     0.200
     7.794   -56.160     0.200
     0.782     2.014     0.200
     0.778     3.186     0.200
     0.986     1.058     0.200
     1.108    -1.360     0.200
     2.551   -10.074     0.200
     2.972   -18.935     0.200
     3.034   -17.405     0.200
     3.331   -17.679     0.200
     4.361   -30.436     0.200
     4.439   -28.297     0.200
     4.524   -32.578     0.200
     4.809   -33.492     0.200
     7.508   -51.712     0.200
     0.203    18.951     0.200
     0.376    14.183     0.200
     0.433    12.293     0.200
     0.926     4.749     0.200
     1.698    -2.358     0.200
     1.803    -4.221     0.200
     1.944    -3.911     0.200
     2.077    -7.562     0.200
     2.787   -13.904     0.200
     2.874   -15.776     0.200
     3.530   -20.042     0.200
     4.124   -25.551     0.200
     4.334   -27.089     0.200
     4.717   -28.372     0.200
     4.957   -31.870     0.200
     5.069   -33.339     0.200
     5.806   -35.666     0.200
     7.081   -49.028     0.200
    12.650   -87.132     0.200
     0.499     8.435     0.200
     0.503     8.273     0.200
     0.502     7.799     0.200
     0.594     6.907     0.200
     0.763     4.544     0.200
     0.770     4.210     0.200
     0.852     4.354     0.200
     0.885     3.606     0.200
     0.903     3.928     0.200
     1.017     2.129     0.200
     1.035     2.395     0.200
     1.497    -2.850     0.200
     1.600    -4.874     0.200
     1.719    -5.538     0.200
     1.942    -5.697     0.200
     2.205    -8.645     0.200
     2.549   -10.999     0.200
     2.629   -11.467     0.200
     3.048   -17.595     0.200
     3.249   -15.827     0.200
     8.167   -60.418     0.200
     0.090    29.449     0.200
     0.307    23.859     0.200
     0.361    21.830     0.200
     0.434    20.412     0.200
     0.490    18.701     0.200
     0.524    17.886     0.200
     0.558    17.778     0.200
     0.570    16.902     0.200
     0.573    16.960     0.200
     0.653    15.589     0.200
     1.104     8.126     0.200
     1.129     8.029     0.200
     2.157    -4.209     0.200
     2.194    -4.013     0.200
     2.197    -4.511     0.200
     2.350    -6.865     0.200
     2.446    -8.922     0.200
     3.529   -16.237     0.200
     3.640   -19.555     0.200
     3.804   -20.567     0.200
     3.975   -22.993     0.200
     4.922   -29.228     0.200
     7.250   -51.782     0.200
     1.495    -3.661     0.200
     1.987    -7.232     0.200
     3.098   -15.860     0.200
     3.180   -18.413     0.200
     3.570   -22.844     0.200
     4.545   -29.070     0.200
     5.185   -33.222     0.200
     5.292   -35.246     0.200
     5.736   -34.539     0.200
     7.004   -48.572     0.200
    11.362   -78.485     0.200
    14.666  -101.500     0.200
     0.949    -0.713     0.200
     1.077    -2.116     0.200
     1.124    -1.167     0.200
     1.187    -1.147     0.200
     1.312    -1.417     0.200
     2.103    -9.557     0.200
     2.154    -7.528     0.200
     2.197    -7.703     0.200
     2.869   -12.825     0.200
     3.290   -14.779     0.200
     4.130   -22.381     0.200
     8.403   -58.251     0.200
    13.203   -89.674     0.200
     0.826     1.399     0.200
     8.350   -58.324     0.200
     8.359   -57.815     0.200
    12.380   -83.822     0.200
     2.533   -12.158     0.200
     3.275   -17.592     0.200
     3.860   -23.272     0.200
     4.721   -32.020     0.200
     7.227   -48.091     0.200
     7.329   -46.961     0.200
     7.506   -53.315     0.200
     7.604   -54.672     0.200
    12.936   -91.410     0.200
     0.483     5.877     0.200
     1.096     0.899     0.200
     2.690   -13.398     0.200
     2.771   -11.717     0.200
     2.906   -12.967     0.200
     3.452   -18.489     0.200
     3.535   -18.025     0.200
     3.596   -18.475     0.200
     3.975   -21.503     0.200
     4.047   -24.026     0.200
     4.072   -22.153     0.200
     4.221   -24.040     0.200
     4.371   -24.484     0.200
     4.703   -30.096     0.200
     4.789   -27.542     0.200
     4.824   -30.957     0.200
     4.871   -28.183     0.200
     5.034   -32.629     0.200
     5.165   -32.036     0.200
     5.542   -35.243     0.200
     6.298   -40.501     0.200
     6.469   -43.279     0.200
     6.519   -44.246     0.200
     7.733   -52.771     0.200
     7.820   -54.743     0.200
     7.820   -55.401     0.200
    12.971   -89.799     0.200
     0.810     0.739     0.200
     4.038   -23.227     0.200
     4.376   -26.386     0.200
     6.342   -42.081     0.200
     6.881   -44.645     0.200
    11.196   -74.692     0.200
    14.537  -102.113     0.200
     0.522     4.140     0.200
     1.170    -0.243     0.200
     1.186    -0.928     0.200
     1.793    -5.368     0.200
     2.653   -16.058     0.200
     3.334   -19.822     0.200
     4.414   -30.114     0.200
     7.199   -50.167     0.200
    12.107   -86.575     0.200
     0.642     3.194     0.200
     0.764     2.336     0.200
     0.779     3.584     0.200
     0.968    -0.191     0.200
     1.184    -0.911     0.200
     1.450    -2.387     0.200
     2.191    -9.379     0.200
     3.141   -20.454     0.200
     3.271   -16.429     0.200
     4.382   -27.153     0.200
     6.309   -42.427     0.200
     7.642   -55.035     0.200
    12.527   -88.926     0.200
     0.289    13.708     0.200
     0.277    14.244     0.200
     0.357    12.362     0.200
     2.172    -8.624     0.200
     2.650   -13.631     0.200
     3.405   -17.158     0.200
     3.699   -22.305     0.200
     3.964   -23.145     0.200
     5.034   -35.125     0.200
     5.137   -32.747     0.200
     5.165   -32.971     0.200
     6.204   -40.670     0.200
     7.702   -55.333     0.200
    13.050   -92.370     0.200
     0.950     0.900     0.200
     1.250     0.637     0.200
     1.828    -5.701     0.200
     2.642   -11.394     0.200
     6.793   -46.322     0.200
    12.062   -84.903     0.200
     0.527     1.997     0.200
     1.256    -1.933     0.200
     1.288    -1.752     0.200
     1.346    -2.113     0.200
     1.351    -1.299     0.200
     1.368    -0.423     0.200
     7.022   -48.974     0.200
     1.058    -0.650     0.200
     1.044    -1.244     0.200
     1.044    -0.814     0.200
     1.293    -3.127     0.200
     2.086    -7.523     0.200
     2.109    -9.448     0.200
     2.488   -10.893     0.200
     6.737   -44.064     0.200
    12.953   -90.545     0.200
     1.555    -5.358     0.200
     1.555    -4.953     0.200
     8.601   -62.124     0.200
    13.478   -94.519     0.200
     0.809     1.624     0.200
     1.480    -3.804     0.200
     2.055    -9.530     0.200
     2.912   -13.266     0.200
     6.782   -45.790     0.200
     9.519   -63.028     0.200
    11.253   -78.052     0.200
     0.709     2.445     0.200
     1.256    -1.989     0.200
     6.168   -41.091     0.200
     0.708     2.360     0.200
     0.708     2.684     0.200
     1.203     0.175     0.200
     1.381    -5.124     0.200
     1.601    -4.228     0.200
     2.143   -11.762     0.200
     3.119   -18.526     0.200
     6.639   -45.959     0.200
     6.769   -44.524     0.200
     6.822   -45.776     0.200
    10.316   -70.637     0.200
    11.526   -80.725     0.200
    12.160   -90.708     0.200
    14.935  -105.977     0.200
     0.934    -0.197     0.200
     0.950     0.001     0.200
     1.128    -1.036     0.200
     1.128     0.244     0.200
     1.200    -0.643     0.200
     1.471    -2.441     0.200
     3.047   -16.974     0.200
     4.446   -26.381     0.200
     8.265   -58.199     0.200
     6.100   -37.347     0.200
     7.585   -52.434     0.200
     0.298     4.790     0.200
     0.513     2.572     0.200
     1.116    -2.173     0.200
     1.176    -1.866     0.200
     1.269    -0.969     0.200
     7.679   -56.530     0.200
     0.346    24.593     0.200
     0.377    23.718     0.200
     1.132     8.399     0.200
     1.606     1.073     0.200
     1.733    -1.079     0.200
     2.197    -3.368     0.200
     2.234    -4.449     0.200
     2.465    -8.480     0.200
     3.672   -19.210     0.200
     4.401   -25.440     0.200
     7.293   -50.639     0.200
     0.523     6.389     0.200
     0.761     3.344     0.200
     0.937     0.996     0.200
     0.958     0.522     0.200
     1.077     0.219     0.200
     1.359    -2.002     0.200
     1.417    -1.686     0.200
     1.707    -6.294     0.200
     6.887   -48.483     0.200
     9.325   -64.681     0.200
    12.175   -86.590     0.200
     1.249     0.824     0.200
     8.721   -59.016     0.200
     3.419   -18.412     0.200
     3.991   -22.261     0.200
     5.415   -31.548     0.200
     8.776   -59.842     0.200
     0.287     6.606     0.200
     0.686     0.067     0.200
     1.486    -6.065     0.200
     1.527    -5.135     0.200
     1.577    -5.499     0.200
     1.684    -6.015     0.200
     1.832    -6.682     0.200
     2.106    -8.789     0.200
     2.535   -12.270     0.200
     2.906   -16.109     0.200
     5.102   -32.851     0.200
     5.335   -32.852     0.200
     6.027   -38.217     0.200
     6.820   -45.393     0.200
     7.658   -54.935     0.200
     8.213   -57.485     0.200
     8.965   -60.534     0.200
     9.029   -58.347     0.200
     9.728   -67.981     0.200
    11.785   -82.501     0.200
     0.868     4.957     0.200
     0.984     4.487     0.200
     1.058     0.005     0.200
     1.394     0.058     0.200
     1.758    -5.838     0.200
     1.841    -6.185     0.200
     2.163   -11.074     0.200
     3.019   -13.247     0.200
     3.125   -14.319     0.200
     6.877   -47.250     0.200
     7.218   -47.537     0.200
    12.290   -89.144     0.200
     0.556     5.017     0.200
     0.661     3.180     0.200
     0.709     3.782     0.200
     0.741     2.832     0.200
     0.894     1.111     0.200
     0.975     0.815     0.200
     1.003     1.209     0.200
     1.203    -2.308     0.200
     1.300    -0.596     0.200
     1.304    -2.253     0.200
     6.826   -47.763     0.200
    12.139   -87.937     0.200
     4.201   -23.075     0.200
     4.299   -23.653     0.200
     5.162   -32.028     0.200
     5.990   -37.522     0.200
     7.162   -43.610     0.200
     8.473   -57.476     0.200
    12.647   -84.708     0.200
    12.647   -83.591     0.200
     1.184    -2.712     0.200
     7.012   -47.714     0.200
    11.667   -80.676     0.200
     0.658     6.171     0.200
     0.667     6.267     0.200
     0.781     4.526     0.200
     0.933     1.597     0.200
     1.205    -0.674     0.200
     1.838    -5.334     0.200
     3.012   -14.378     0.200
     3.714   -24.899     0.200
     3.895   -23.980     0.200
     4.315   -27.878     0.200
     8.095   -57.517     0.200
    13.132   -91.325     0.200
     0.634     9.471     0.200
     0.698     9.354     0.200
     0.769     6.889     0.200
     1.224     1.999     0.200
     1.525    -2.170     0.200
     1.687    -4.698     0.200
     2.103    -6.165     0.200
     2.955   -13.451     0.200
     8.343   -60.504     0.200
    13.608   -96.297     0.200
    14.608   -94.246     0.200
    16.705  -118.556     0.200
     1.817    -5.308     0.200
     2.170    -8.714     0.200
     2.462   -13.586     0.200
     3.271   -19.375     0.200
     4.489   -26.591     0.200
     5.382   -32.525     0.200
     6.107   -35.744     0.200
     7.808   -54.206     0.200
    12.326   -89.785     0.200
    12.384   -90.329     0.200
     3.785   -20.822     0.200
     8.176   -58.773     0.200
     0.518     9.412     0.200
     0.521     9.666     0.200
     0.578     9.058     0.200
     1.036     3.230     0.200
     1.184    -0.128     0.200
     1.289    -1.417     0.200
     1.458    -2.897     0.200
     1.458    -1.147     0.200
     1.885    -8.430     0.200
     1.916    -5.520     0.200
     2.204    -9.844     0.200
     2.742   -12.023     0.200
     2.809   -14.279     0.200
     3.098   -17.556     0.200
     3.709   -22.327     0.200
     3.878   -24.867     0.200
     4.435   -27.268     0.200
     5.002   -33.450     0.200
     5.006   -29.102     0.200
     5.958   -39.494     0.200
     6.379   -41.521     0.200
     6.812   -43.443     0.200
     8.041   -53.745     0.200
     8.170   -59.372     0.200
    12.412   -83.744     0.200
    13.373   -94.652     0.200
     0.658     2.494     0.200
     0.757     1.365     0.200
     0.973     0.651     0.200
     1.008     0.843     0.200
     1.118    -1.164     0.200
     1.203    -3.076     0.200
     1.430    -3.170     0.200
     1.905    -5.849     0.200
     2.062    -6.470     0.200
     3.636   -18.371     0.200
     5.256   -30.036     0.200
     7.006   -50.614     0.200
    12.005   -84.531     0.200
     0.365    14.652     0.200
     0.377    14.792     0.200
     0.470    13.088     0.200
     0.526    11.235     0.200
     0.983     4.530     0.200
     1.308    -0.847     0.200
     1.250     1.722     0.200
     1.502    -3.719     0.200
     1.873    -4.216     0.200
     1.981    -5.926     0.200
     2.011    -8.079     0.200
     2.253    -9.747     0.200
     7.226   -51.939     0.200
    12.818   -92.258     0.200
     0.840     2.527     0.200
     1.788    -8.300     0.200
     5.883   -36.546     0.200
     8.756   -58.395     0.200
     8.797   -61.109     0.200
     0.412     3.419     0.200
     0.540     2.727     0.200
     0.540     3.092     0.200
     1.065    -2.073     0.200
     1.129    -1.859     0.200
     1.112    -2.256     0.200
     1.730    -7.598     0.200
     2.279    -8.067     0.200
     7.865   -56.004     0.200
     0.741     1.050     0.200
     0.741     1.269     0.200
     0.942     0.884     0.200
     0.985     0.608     0.200
     1.505    -4.727     0.200
     2.236   -12.560     0.200
     2.693   -10.958     0.200
     2.749   -10.958     0.200
     2.936   -16.706     0.200
     3.163   -20.054     0.200
     4.214   -27.096     0.200
     6.819   -46.677     0.200
     0.441    11.506     0.200
     0.561    10.513     0.200
     1.057     0.227     0.200
     1.099     2.636     0.200
     1.257    -2.462     0.200
     7.315   -50.368     0.200
    12.678   -91.616     0.200
    16.053  -116.402     0.200
     1.007    -2.492     0.200
     1.257    -3.091     0.200
     1.303    -1.529     0.200
     1.308    -2.733     0.200
     1.358    -2.120     0.200
     1.586    -3.230     0.200
     7.177   -51.807     0.200
    11.869   -82.190     0.200
     0.411     7.520     0.200
     0.774     2.908     0.200
     0.862     1.522     0.200
     0.899     1.926     0.200
     1.238    -2.568     0.200
     1.599    -4.186     0.200
     1.643    -4.717     0.200
     3.878   -26.014     0.200
     4.286   -26.589     0.200
     7.110   -46.472     0.200
    12.344   -87.891     0.200
     0.749     0.721     0.200
     1.371    -2.143     0.200
     1.500    -3.776     0.200
     6.873   -46.709     0.200
     0.628     4.278     0.200
     0.738     2.794     0.200
     0.900     1.696     0.200
     1.000     0.626     0.200
     1.806    -5.662     0.200
     7.018   -48.682     0.200
     0.463     4.774     0.200
     0.866    -0.221     0.200
     0.988    -0.016     0.200
     1.098     0.090     0.200
     2.353    -7.363     0.200
     3.336   -17.948     0.200
     3.741   -24.444     0.200
     4.001   -20.498     0.200
     4.288   -27.589     0.200
     4.651   -31.496     0.200
     4.791   -32.484     0.200
     6.286   -41.805     0.200
     6.435   -43.517     0.200
     6.501   -43.918     0.200
     6.636   -45.701     0.200
     6.708   -46.594     0.200
     7.364   -53.742     0.200
    12.214   -83.645     0.200
     0.582     3.387     0.200
     0.697     2.323     0.200
     0.937    -0.118     0.200
     1.648    -4.986     0.200
     2.276    -8.889     0.200
     2.856   -14.733     0.200
     7.842   -59.512     0.200
    13.988   -96.803     0.200
     0.402     3.599     0.200
     1.658    -6.595     0.200
     1.786    -6.504     0.200
     2.020    -8.097     0.200
     5.044   -34.131     0.200
     5.517   -32.913     0.200
     6.758   -46.374     0.200
     7.484   -42.068     0.200
     7.857   -55.921     0.200
     9.165   -59.066     0.200
     9.209   -60.753     0.200
     9.173   -57.957     0.200
    11.914   -80.209     0.200
     0.531     3.364     0.200
     0.994    -0.795     0.200
     1.083    -1.832     0.200
     1.164    -2.157     0.200
     1.275    -2.828     0.200
     1.487    -2.345     0.200
     2.522   -10.711     0.200
     8.254   -59.287     0.200
     0.316    14.339     0.200
     0.335    14.072     0.200
     0.796     6.593     0.200
     1.245    -1.314     0.200
     1.354     0.039     0.200
     2.516    -9.666     0.200
     2.618   -10.991     0.200
     7.608   -54.167     0.200
    13.002   -88.563     0.200
     0.973     0.391     0.200
     0.973     1.740     0.200
     1.873    -5.488     0.200
     2.846   -12.276     0.200
     2.916   -12.172     0.200
     8.491   -58.084     0.200
    12.354   -84.950     0.200
    14.476  -104.026     0.200
     0.696     4.123     0.200
     1.328    -3.288     0.200
     3.213   -14.771     0.200
     3.502   -18.587     0.200
     5.295   -31.948     0.200
     5.830   -34.931     0.200
     5.982   -36.597     0.200
     6.373   -40.587     0.200
     7.294   -48.657     0.200
     8.856   -60.502     0.200
     8.856   -60.502     0.200
    10.393   -72.333     0.200
    12.689   -85.928     0.200
    23.160  -162.650     0.200
     0.760     2.388     0.200
     1.503    -2.736     0.200
     1.503    -2.851     0.200
     4.377   -26.478     0.200
     5.786   -34.096     0.200
     6.672   -43.071     0.200
     9.002   -59.944     0.200
     0.669     1.507     0.200
     0.768     0.992     0.200
     0.821     1.937     0.200
     0.821     2.292     0.200
     0.832     1.169     0.200
     0.887     0.968     0.200
     1.165    -1.487     0.200
     1.158    -1.217     0.200
     1.658    -3.756     0.200
     2.331    -8.604     0.200
     2.353    -9.937     0.200
     2.750   -14.501     0.200
     2.957   -13.707     0.200
     4.051   -24.422     0.200
     4.251   -23.628     0.200
     4.792   -32.655     0.200
     7.879   -55.975     0.200
     8.460   -61.108     0.200
     0.736     3.844     0.200
     0.856     3.448     0.200
     0.947     0.394     0.200
     0.947     0.620     0.200
     1.312    -5.126     0.200
     1.582    -3.736     0.200
     1.575    -2.195     0.200
     1.641    -4.085     0.200
     1.971    -9.349     0.200
     2.035    -6.334     0.200
     2.140    -7.455     0.200
     3.320   -15.780     0.200
     5.967   -40.175     0.200
     7.073   -50.234     0.200
    12.387   -87.373     0.200
    12.387   -89.088     0.200
     0.426     2.922     0.200
     0.542     0.354     0.200
     1.178    -1.345     0.200
     1.178    -2.783     0.200
     2.986   -14.603     0.200
     2.997   -13.622     0.200
     3.283   -19.981     0.200
     3.883   -24.100     0.200
     4.188   -23.804     0.200
     4.816   -28.757     0.200
     5.614   -31.951     0.200
     5.684   -35.333     0.200
     6.005   -37.585     0.200
     6.016   -39.424     0.200
     6.194   -41.762     0.200
     6.359   -42.271     0.200
     6.786   -44.947     0.200
     8.577   -64.450     0.200
    12.975   -88.390     0.200
    15.806  -112.741     0.200
     0.754     2.938     0.200
     0.821     2.492     0.200
     0.856     1.886     0.200
     1.226    -0.528     0.200
     1.597    -6.894     0.200
     1.597    -6.738     0.200
     1.513    -3.729     0.200
     1.837    -5.998     0.200
     1.857    -7.706     0.200
     2.154   -10.873     0.200
     2.154   -10.483     0.200
     2.408   -10.682     0.200
     2.907   -18.539     0.200
     3.211   -19.349     0.200
     3.165   -17.604     0.200
     3.557   -22.351     0.200
     4.302   -29.955     0.200
     4.473   -31.566     0.200
     4.972   -32.091     0.200
     5.128   -35.615     0.200
     5.375   -35.575     0.200
     5.832   -38.696     0.200
     5.934   -37.202     0.200
     6.400   -45.700     0.200
     6.896   -48.216     0.200
     7.127   -50.164     0.200
     7.399   -52.959     0.200
     0.730     3.057     0.200
     0.777     2.910     0.200
     0.897     0.833     0.200
     1.154     0.235     0.200
     1.313    -1.243     0.200
     1.401    -4.595     0.200
     1.447    -3.736     0.200
     1.819    -6.138     0.200
     1.884    -7.491     0.200
     2.132   -10.949     0.200
     6.860   -48.855     0.200
    12.094   -86.855     0.200
    13.026   -93.654     0.200
     0.586    10.020     0.200
     1.431    -3.807     0.200
     1.769    -3.605     0.200
     1.865    -5.789     0.200
     1.991    -9.798     0.200
     2.142    -9.846     0.200
     2.213    -6.068     0.200
     2.642    -8.827     0.200
     2.698    -7.664     0.200
     2.867   -13.305     0.200
     2.937   -15.758     0.200
     3.163   -17.602     0.200
     3.430   -16.294     0.200
     3.439   -19.577     0.200
     4.207   -25.311     0.200
     6.853   -47.866     0.200
     7.046   -48.702     0.200
     7.171   -49.563     0.200
     7.171   -49.052     0.200
    10.348   -69.657     0.200
    12.679   -89.838     0.200
    16.121  -119.464     0.200
     0.365    23.568     0.200
     0.457    21.855     0.200
     1.122     9.469     0.200
     1.145     9.144     0.200
     1.172     9.336     0.200
     1.696    -1.133     0.200
     1.834    -3.279     0.200
     2.077    -2.776     0.200
     2.219    -5.629     0.200
     2.971   -13.954     0.200
     3.270   -16.451     0.200
     3.554   -17.160     0.200
     3.650   -19.197     0.200
     5.340   -32.261     0.200
     5.629   -37.003     0.200
     5.812   -37.816     0.200
     7.091   -46.558     0.200
     7.243   -52.074     0.200
     7.243   -51.226     0.200
     7.243   -50.279     0.200
     9.190   -59.382     0.200
     0.601     0.980     0.200
     1.270    -4.407     0.200
     1.375    -3.176     0.200
     1.649    -5.462     0.200
     4.087   -25.893     0.200
     4.232   -27.686     0.200
     4.405   -29.670     0.200
     4.433   -29.844     0.200
     4.580   -31.928     0.200
     6.214   -39.654     0.200
     7.009   -47.085     0.200
     7.009   -47.925     0.200
     1.133     1.569     0.200
     1.503     0.073     0.200
     1.870    -3.914     0.200
     5.420   -27.628     0.200
     6.939   -40.455     0.200
    12.428   -81.222     0.200
     1.594    -3.704     0.200
     1.792    -2.849     0.200
     1.856    -5.961     0.200
     1.856    -3.501     0.200
     2.473    -7.373     0.200
     3.056   -12.676     0.200
     3.141   -13.602     0.200
     3.459   -15.767     0.200
     3.709   -19.504     0.200
     3.813   -19.452     0.200
     0.750     4.480     0.200
     0.925     0.126     0.200
     1.087     0.694     0.200
     1.396    -4.055     0.200
     1.451    -1.585     0.200
     1.525    -4.930     0.200
     1.764    -7.527     0.200
     2.155   -12.006     0.200
     2.304   -11.857     0.200
     2.806   -15.967     0.200
     2.928   -15.082     0.200
     3.337   -19.380     0.200
     3.388   -20.158     0.200
     3.434   -21.675     0.200
     3.554   -22.824     0.200
     3.594   -22.660     0.200
     3.783   -24.613     0.200
     3.962   -26.619     0.200
     3.935   -24.700     0.200
     4.107   -26.973     0.200
     4.230   -27.994     0.200
     4.213   -27.424     0.200
     4.377   -28.568     0.200
     4.574   -30.823     0.200
     5.064   -32.635     0.200
     5.085   -32.608     0.200
     5.232   -33.734     0.200
     5.376   -36.183     0.200
     5.354   -33.794     0.200
     5.692   -39.722     0.200
     6.138   -41.039     0.200
     6.181   -40.696     0.200
     6.300   -42.265     0.200
     6.336   -42.102     0.200
     6.391   -42.911     0.200
     6.594   -43.742     0.200
     6.672   -44.210     0.200
     7.604   -51.359     0.200
     8.319   -56.349     0.200
     0.470     1.665     0.200
     0.470     2.266     0.200
     2.403   -13.678     0.200
     2.587   -10.862     0.200
     3.230   -18.720     0.200
     3.735   -24.398     0.200
     3.806   -23.460     0.200
     4.011   -25.786     0.200
     4.827   -30.801     0.200
     7.140   -50.881     0.200
     7.147   -49.303     0.200
     7.147   -49.624     0.200
     7.828   -53.977     0.200
     8.711   -60.563     0.200
     8.951   -66.813     0.200
     9.055   -62.695     0.200
     9.245   -63.449     0.200
    11.506   -81.020     0.200
    11.506   -80.574     0.200
    11.972   -83.258     0.200
     0.560     3.746     0.200
     0.738     2.112     0.200
     0.926    -0.930     0.200
     0.945     0.583     0.200
     1.108    -0.994     0.200
     7.903   -56.915     0.200
     0.891     0.425     0.200
     1.861    -6.748     0.200
     2.835   -11.148     0.200
     3.102   -14.125     0.200
     4.418   -22.523     0.200
     4.512   -25.623     0.200
     4.700   -22.999     0.200
     5.062   -30.591     0.200
     5.133   -27.942     0.200
     5.218   -30.947     0.200
     6.848   -42.582     0.200
     8.108   -51.164     0.200
     0.479     8.647     0.200
     0.812     2.982     0.200
     1.034    -0.117     0.200
     1.034     0.789     0.200
     1.034     0.227     0.200
     1.173    -0.324     0.200
     1.227    -1.214     0.200
     1.335    -2.135     0.200
     1.805    -5.605     0.200
     6.389   -43.062     0.200
     6.836   -48.400     0.200
     0.794     1.766     0.200
     1.135    -2.693     0.200
     1.135    -3.054     0.200
     1.472    -4.025     0.200
     1.472    -3.509     0.200
     7.216   -48.603     0.200
     7.213   -49.066     0.200
     7.564   -50.217     0.200
     8.956   -62.196     0.200
     0.527     5.127     0.200
     1.031    -3.187     0.200
     1.045    -1.602     0.200
     1.117    -0.926     0.200
     1.656    -6.633     0.200
     3.396   -19.501     0.200
     3.693   -22.656     0.200
     3.717   -22.380     0.200
     8.928   -63.918     0.200
     0.553     3.321     0.200
     1.036    -3.015     0.200
     1.062    -2.034     0.200
     1.415    -3.225     0.200
     1.667    -6.317     0.200
     3.235   -20.278     0.200
     3.384   -17.514     0.200
     3.399   -19.313     0.200
     3.697   -22.246     0.200
     8.926   -63.768     0.200
    13.496   -96.022     0.200
    16.276  -116.782     0.200
    21.394  -146.938     0.200
     0.539     4.740     0.200
     1.031    -0.843     0.200
     1.095    -0.280     0.200
     1.061    -1.831     0.200
     3.369   -18.829     0.200
     3.667   -23.192     0.200
     3.691   -22.612     0.200
     4.292   -27.706     0.200
     5.708   -38.154     0.200
     5.714   -37.483     0.200
     5.783   -39.893     0.200
     6.379   -43.842     0.200
     7.316   -49.372     0.200
     7.789   -54.279     0.200
     7.796   -53.877     0.200
     8.573   -59.613     0.200
     8.899   -61.389     0.200
     8.899   -64.289     0.200
     0.323    12.444     0.200
     0.628     6.261     0.200
     0.972     1.049     0.200
     0.965     3.040     0.200
     0.989     2.708     0.200
     0.989     3.970     0.200
     1.263    -2.559     0.200
     1.443    -2.468     0.200
     1.660    -4.145     0.200
     1.710    -3.857     0.200
     1.780    -5.718     0.200
     1.882    -8.925     0.200
     2.067    -9.575     0.200
     2.772   -15.820     0.200
     2.852   -16.318     0.200
     4.069   -26.780     0.200
     6.868   -47.661     0.200
     7.079   -48.778     0.200
     7.192   -50.592     0.200
     7.380   -51.035     0.200
     8.205   -55.851     0.200
     0.926     1.022     0.200
     2.868    -9.558     0.200
     8.095   -52.974     0.200
     8.387   -55.830     0.200
     8.440   -57.462     0.200
     8.679   -58.995     0.200
     0.553     7.600     0.200
     0.700     4.560     0.200
     0.760     4.130     0.200
     0.781     4.023     0.200
     0.815     2.873     0.200
     0.913     2.647     0.200
     1.009    -0.080     0.200
     1.405    -4.069     0.200
     1.483    -3.585     0.200
     1.658    -4.313     0.200
     1.843    -6.685     0.200
     1.917    -8.208     0.200
     2.037    -7.448     0.200
     2.676   -13.549     0.200
     3.183   -17.342     0.200
     3.219   -14.842     0.200
     3.546   -16.651     0.200
     3.758   -20.763     0.200
     3.842   -23.208     0.200
     3.960   -23.052     0.200
     4.170   -28.379     0.200
     4.364   -27.574     0.200
     4.473   -29.633     0.200
     4.523   -28.175     0.200
     5.129   -28.595     0.200
     5.137   -30.809     0.200
     5.353   -31.985     0.200
     5.436   -33.042     0.200
     5.627   -36.634     0.200
     5.660   -32.855     0.200
     5.701   -38.498     0.200
     5.936   -37.334     0.200
     5.936   -34.815     0.200
     6.023   -39.891     0.200
     6.646   -45.219     0.200
     6.660   -42.614     0.200
     6.971   -47.993     0.200
     7.019   -46.255     0.200
     0.546     2.544     0.200
     0.546     2.388     0.200
     1.220    -3.025     0.200
     1.394    -3.699     0.200
     1.674    -6.109     0.200
     1.656    -5.916     0.200
     2.046   -10.261     0.200
     3.142   -19.040     0.200
     3.644   -23.668     0.200
     3.678   -22.934     0.200
     3.774   -25.951     0.200
     3.821   -20.986     0.200
     3.901   -23.535     0.200
     3.936   -25.617     0.200
     4.307   -26.122     0.200
     5.151   -32.650     0.200
     5.224   -33.580     0.200
     5.248   -33.836     0.200
     5.288   -34.967     0.200
     7.034   -49.329     0.200
     0.937     1.194     0.200
     7.667   -52.124     0.200
     9.114   -64.561     0.200
     9.114   -59.092     0.200
     0.694     2.168     0.200
     1.366    -4.541     0.200
     1.721    -6.015     0.200
     1.721    -5.703     0.200
     3.595   -18.155     0.200
     3.879   -21.855     0.200
     4.159   -24.415     0.200
     4.378   -23.322     0.200
     4.486   -27.488     0.200
     5.530   -29.315     0.200
     5.583   -36.412     0.200
     5.959   -35.479     0.200
     6.107   -36.919     0.200
     6.234   -39.357     0.200
     6.363   -39.913     0.200
     6.506   -40.591     0.200
     7.237   -44.322     0.200
     7.238   -48.690     0.200
     7.497   -47.660     0.200
     7.538   -51.567     0.200
     7.518   -46.322     0.200
     7.563   -48.010     0.200
     7.598   -48.830     0.200
     7.651   -47.070     0.200
     7.824   -52.254     0.200
     7.905   -53.978     0.200
     7.933   -50.066     0.200
     7.954   -50.172     0.200
     7.950   -50.924     0.200
     8.772   -54.795     0.200
     8.979   -59.352     0.200
     0.459     4.337     0.200
     0.999    -0.939     0.200
     1.184    -0.458     0.200
     1.193    -1.151     0.200
     1.213    -0.121     0.200
     1.244    -1.582     0.200
     1.608    -3.370     0.200
     1.850    -6.907     0.200
     1.868    -6.032     0.200
     1.893    -8.188     0.200
     2.227    -8.104     0.200
     2.399    -8.562     0.200
     2.620   -15.952     0.200
     3.321   -19.016     0.200
     7.197   -53.330     0.200
     7.733   -52.061     0.200
     9.216   -61.286     0.200
     9.782   -67.918     0.200
    12.033   -85.015     0.200
     0.727     1.563     0.200
     1.257    -0.441     0.200
     0.202    20.668     0.200
     0.305    17.912     0.200
     0.960     5.564     0.200
     1.382    -1.124     0.200
     1.438    -1.894     0.200
     2.263    -8.671     0.200
     7.505   -54.157     0.200
     0.536     5.970     0.200
     0.638     4.451     0.200
     0.748     3.036     0.200
     0.798     2.277     0.200
     0.916     1.516     0.200
     1.091    -1.630     0.200
     1.083     0.270     0.200
     1.546    -4.233     0.200
     1.700    -3.404     0.200
     2.033    -8.852     0.200
     0.504    10.769     0.200
     1.027     1.675     0.200
     1.196     0.228     0.200
     1.323    -1.115     0.200
     1.693    -2.750     0.200
     1.720    -3.639     0.200
     2.064    -8.730     0.200
     2.816   -15.548     0.200
     2.861   -16.181     0.200
     7.932   -55.766     0.200
     0.283    24.285     0.200
     0.302    23.564     0.200
     0.340    22.181     0.200
     0.542    18.537     0.200
     0.983     9.510     0.200
     1.300     6.054     0.200
     1.736    -1.944     0.200
     2.095    -5.964     0.200
     2.225    -5.227     0.200
     2.615   -11.090     0.200
     2.690   -12.076     0.200
     3.737   -19.391     0.200
     4.372   -25.723     0.200
     4.566   -28.966     0.200
     5.586   -35.884     0.200
     0.362    10.915     0.200
     0.637     6.604     0.200
     0.659     6.212     0.200
     0.836     2.963     0.200
     0.904     2.452     0.200
     1.538    -4.923     0.200
     1.810    -5.668     0.200
     2.573   -15.192     0.200
     0.145    19.517     0.200
     0.517    10.443     0.200
     0.635     9.341     0.200
     0.836     5.341     0.200
     0.946     5.336     0.200
     0.972     4.474     0.200
     1.096     0.647     0.200
     1.356    -2.509     0.200
     1.382    -0.849     0.200
     1.637    -2.721     0.200
     1.746    -3.329     0.200
     1.831    -5.639     0.200
     1.939    -8.513     0.200
     2.057    -6.005     0.200
     2.113    -9.219     0.200
     2.170    -9.989     0.200
     2.235    -7.866     0.200
     2.794   -15.683     0.200
     2.711   -12.324     0.200
     3.014   -16.074     0.200
     4.370   -26.136     0.200
     7.184   -48.248     0.200
     0.634     2.972     0.200
     0.663     1.849     0.200
     1.164    -1.463     0.200
     3.838   -21.702     0.200
     8.429   -60.267     0.200
     1.146    -1.814     0.200
     1.816    -5.227     0.200
     1.841    -5.731     0.200
     8.671   -61.777     0.200
     0.088    29.061     0.200
     0.435    20.152     0.200
     0.480    19.408     0.200
     1.147     8.471     0.200
     1.123     7.877     0.200
     1.622    -1.347     0.200
     1.747    -2.706     0.200
     2.082    -4.500     0.200
     2.082    -4.201     0.200
     2.160    -6.888     0.200
     2.215    -6.749     0.200
     2.196    -5.215     0.200
     2.325    -5.704     0.200
     3.676   -20.998     0.200
     4.481   -27.218     0.200
     4.625   -29.842     0.200
     5.652   -37.230     0.200
     5.925   -40.069     0.200
     6.060   -40.519     0.200
     7.141   -48.635     0.200
     7.580   -55.143     0.200
     1.571    -4.292     0.200
     1.860    -8.246     0.200
     2.520   -15.565     0.200
     2.677   -14.682     0.200
     7.216   -49.744     0.200
    11.719   -82.916     0.200
     0.668     1.031     0.200
     0.999    -0.295     0.200
     1.739    -4.789     0.200
     2.943   -12.780     0.200
     8.525   -58.366     0.200
    12.438   -83.597     0.200
     0.026    22.707     0.200
     0.152    19.596     0.200
     0.191    18.625     0.200
     0.263    17.197     0.200
     0.280    15.608     0.200
     0.424    13.874     0.200
     0.503    11.573     0.200
     0.569    10.744     0.200
     0.815     5.686     0.200
     1.309    -1.218     0.200
     1.342    -0.842     0.200
     1.654    -4.729     0.200
     2.356   -11.451     0.200
     2.737   -13.731     0.200
     0.135    19.417     0.200
     0.461    11.815     0.200
     0.615     8.863     0.200
     0.630     8.736     0.200
     0.726     7.805     0.200
     0.783     7.878     0.200
     0.811     6.581     0.200
     1.204    -0.143     0.200
     1.515    -4.215     0.200
     1.470    -1.113     0.200
     1.621    -2.112     0.200
     1.723    -4.042     0.200
     1.997    -7.746     0.200
     2.112    -9.714     0.200
     2.061    -8.704     0.200
     2.965   -17.073     0.200
     2.886   -15.066     0.200
     1.918    -2.377     0.200
     3.252   -10.050     0.200
     4.985   -23.129     0.200
    13.500   -85.273     0.200
     2.535    -9.877     0.200
     7.095   -48.911     0.200
     0.276    25.119     0.200
     0.299    24.049     0.200
     0.468    19.532     0.200
     1.025     9.492     0.200
     1.242     6.628     0.200
     1.518     3.296     0.200
     1.719    -1.791     0.200
     2.099    -5.660     0.200
     2.172    -4.921     0.200
     2.301    -7.400     0.200
     2.562   -10.224     0.200
     2.834   -11.198     0.200
     3.362   -18.545     0.200
     3.691   -17.578     0.200
     4.323   -27.012     0.200
     4.517   -27.997     0.200
     0.888     0.244     0.200
     2.011    -7.717     0.200
     3.567   -16.934     0.200
     9.077   -60.572     0.200
     0.473     4.416     0.200
     0.473     4.186     0.200
     0.850     0.084     0.200
     1.305    -1.106     0.200
     1.319    -1.332     0.200
     1.590    -6.298     0.200
     1.638    -4.280     0.200
     1.808    -5.393     0.200
     2.130   -10.090     0.200
     2.549   -10.392     0.200
     2.843   -17.762     0.200
     3.189   -14.971     0.200
     3.526   -20.529     0.200
     4.108   -26.363     0.200
     4.809   -27.521     0.200
     5.062   -33.447     0.200
     5.290   -34.714     0.200
     5.297   -34.971     0.200
     5.389   -35.524     0.200
     5.429   -33.877     0.200
     5.596   -34.761     0.200
     5.635   -37.338     0.200
     6.064   -38.410     0.200
     6.162   -41.295     0.200
     6.153   -39.111     0.200
     6.247   -41.437     0.200
     7.054   -47.951     0.200
     7.302   -49.543     0.200
     7.304   -49.199     0.200
     7.388   -51.782     0.200
    12.242   -85.695     0.200
     0.641     2.052     0.200
     0.785     1.700     0.200
     0.823     1.393     0.200
     0.846    -0.337     0.200
     1.161    -2.327     0.200
     1.195    -1.251     0.200
     2.632   -13.615     0.200
     2.969   -13.627     0.200
     7.870   -55.230     0.200
     0.640     3.512     0.200
     0.685     3.389     0.200
     0.828     0.376     0.200
     0.803     2.533     0.200
     0.936     0.870     0.200
     0.998     0.237     0.200
     1.413    -2.804     0.200
     1.486    -5.695     0.200
     1.961    -6.607     0.200
     2.279   -11.593     0.200
     2.310   -11.596     0.200
     0.342    12.253     0.200
     0.516     8.328     0.200
     0.966     2.176     0.200
     1.186    -1.001     0.200
     1.207    -1.026     0.200
     1.630    -4.109     0.200
     2.257    -8.781     0.200
     7.606   -54.853     0.200
    12.954   -92.170     0.200
     0.354     2.620     0.200
     1.024    -2.565     0.200
     1.518    -4.099     0.200
     1.668    -5.183     0.200
     1.864    -8.136     0.200
     2.442   -11.337     0.200
     2.680   -13.692     0.200
     3.310   -18.995     0.200
     3.437   -21.064     0.200
     5.415   -35.704     0.200
     7.225   -50.694     0.200
     0.585     4.666     0.200
     0.704     3.464     0.200
     0.698     3.332     0.200
     0.982     0.023     0.200
     0.965     1.138     0.200
     1.086    -0.516     0.200
     1.086    -0.835     0.200
     1.319    -2.547     0.200
     1.764    -6.816     0.200
     1.764    -7.039     0.200
     8.233   -60.321     0.200
     0.217    15.421     0.200
     0.496     9.041     0.200
     0.610     6.958     0.200
     0.755     4.099     0.200
     1.062     0.738     0.200
     1.310    -2.237     0.200
     1.361    -1.721     0.200
     1.679    -4.339     0.200
     1.774    -3.830     0.200
     1.892    -8.268     0.200
     2.193   -10.387     0.200
     2.931   -13.402     0.200
     3.778   -19.499     0.200
     5.114   -31.372     0.200
     5.215   -33.557     0.200
     0.543     9.174     0.200
     0.609     8.108     0.200
     0.732     5.183     0.200
     0.839     4.610     0.200
     1.068     1.255     0.200
     1.006     3.411     0.200
     1.318    -2.056     0.200
     1.364    -1.823     0.200
     1.769    -3.566     0.200
     1.900    -8.013     0.200
     1.850    -5.535     0.200
     2.134    -9.235     0.200
     2.189    -9.689     0.200
     0.732     3.785     0.200
     0.880     2.947     0.200
     1.069    -0.137     0.200
     1.105     0.150     0.200
     1.120     0.546     0.200
     1.194    -1.273     0.200
     1.615    -5.746     0.200
     1.615    -4.863     0.200
     2.324   -11.529     0.200
     2.507   -12.520     0.200
     7.424   -50.501     0.200
     8.071   -52.684     0.200
     8.179   -52.360     0.200
     8.401   -54.297     0.200
     8.761   -60.687     0.200
     0.673     2.133     0.200
     0.827     1.679     0.200
     2.361    -7.363     0.200
     7.886   -54.076     0.200
    12.757   -87.564     0.200
     0.531     5.190     0.200
     0.849     1.784     0.200
     1.888    -5.565     0.200
     2.406   -10.476     0.200
     2.491    -8.959     0.200
     2.979   -13.189     0.200
    12.783   -88.079     0.200
    13.012   -92.299     0.200
     0.494     5.178     0.200
     0.641     3.860     0.200
     0.677     4.520     0.200
     0.699     2.031     0.200
     0.704     2.418     0.200
     0.842     1.148     0.200
     0.835     3.108     0.200
     1.336    -2.096     0.200
     1.786    -4.517     0.200
     2.009    -8.323     0.200
     2.194    -9.137     0.200
     8.876   -63.830     0.200
    12.995   -87.716     0.200
     0.439     9.928     0.200
     0.525     8.547     0.200
     0.856     2.642     0.200
     0.823     3.612     0.200
     0.911     3.596     0.200
     1.256    -2.526     0.200
     1.200     0.547     0.200
     1.548    -2.563     0.200
     1.578    -3.986     0.200
     1.633    -4.018     0.200
     1.687    -3.943     0.200
     1.891    -7.775     0.200
     1.936    -7.849     0.200
     0.351    10.559     0.200
     0.318    12.157     0.200
     0.415    10.287     0.200
     0.606     6.217     0.200
     0.795     3.219     0.200
     1.186    -0.745     0.200
     1.186    -1.025     0.200
     1.268    -0.608     0.200
     1.517    -4.461     0.200
     1.517    -4.719     0.200
     1.552    -2.471     0.200
     1.570    -2.718     0.200
     1.846    -6.410     0.200
     1.846    -6.671     0.200
     1.857    -5.104     0.200
     1.857    -5.314     0.200
     2.237   -11.636     0.200
     2.204    -8.955     0.200
     2.232    -8.936     0.200
     2.366    -9.285     0.200
     2.383    -9.533     0.200
     2.383    -9.651     0.200
     2.441   -11.206     0.200
     2.715   -13.569     0.200
     2.779   -15.142     0.200
     2.811   -13.900     0.200
     3.513   -22.364     0.200
     4.049   -23.636     0.200
     0.501     1.706     0.200
     1.177    -3.708     0.200
     1.576    -5.966     0.200
     1.645    -6.128     0.200
     1.708    -6.580     0.200
     2.077    -9.243     0.200
     2.343   -10.972     0.200
     2.422   -10.169     0.200
     2.753   -13.704     0.200
     2.942   -15.429     0.200
     3.147   -16.127     0.200
     3.318   -17.646     0.200
     7.986   -56.026     0.200
     0.569     3.195     0.200
     0.569     4.148     0.200
     0.569     2.758     0.200
     0.730     0.751     0.200
     0.750     0.600     0.200
     0.774     1.795     0.200
     0.777     0.637     0.200
     0.853     0.830     0.200
     0.882     0.675     0.200
     0.951     1.449     0.200
     1.052    -0.904     0.200
     1.407    -5.560     0.200
     1.438    -2.108     0.200
     1.442    -2.921     0.200
     1.606    -4.296     0.200
     1.740    -5.939     0.200
     2.015    -6.919     0.200
     2.025    -8.040     0.200
     2.101    -9.045     0.200
     2.323   -12.121     0.200
     2.348   -11.878     0.200
     2.348   -12.198     0.200
     2.303    -9.782     0.200
     2.928   -14.191     0.200
     2.997   -15.849     0.200
     3.064   -19.567     0.200
     3.064   -19.809     0.200
     3.735   -22.635     0.200
     3.832   -22.139     0.200
     3.989   -26.023     0.200
     4.078   -26.662     0.200
     4.197   -22.883     0.200
     4.316   -28.581     0.200
     4.363   -29.263     0.200
     4.455   -31.310     0.200
     4.547   -31.243     0.200
     4.588   -28.894     0.200
     4.817   -33.231     0.200
     5.168   -33.024     0.200
     5.284   -36.361     0.200
     5.451   -33.178     0.200
     5.513   -38.393     0.200
     5.505   -36.073     0.200
     5.519   -35.235     0.200
     5.608   -36.541     0.200
     5.776   -36.013     0.200
     5.858   -39.197     0.200
     7.584   -55.846     0.200
     0.613     1.098     0.200
     1.264    -2.523     0.200
     1.560    -3.890     0.200
     1.679    -4.352     0.200
     1.841    -5.214     0.200
     2.558   -10.121     0.200
     0.463     4.290     0.200
     0.632     1.646     0.200
     0.892     0.307     0.200
     0.972    -0.571     0.200
     1.067     0.042     0.200
     1.352    -5.322     0.200
     1.518    -2.206     0.200
     1.810    -7.599     0.200
     7.626   -53.968     0.200
     0.579     2.494     0.200
     0.579     2.728     0.200
     0.788     2.751     0.200
     0.788     2.087     0.200
     0.859     0.398     0.200
     0.921     1.170     0.200
     1.086    -2.095     0.200
     1.308    -1.733     0.200
     1.867    -8.111     0.200
     2.390   -11.533     0.200
     2.568   -11.439     0.200
     3.192   -17.338     0.200
     7.937   -57.064     0.200
     0.631     2.614     0.200
     0.734     1.347     0.200
     0.730     1.673     0.200
     0.747     1.552     0.200
     0.753     1.872     0.200
     0.959    -0.634     0.200
     1.119    -1.796     0.200
     1.316    -1.777     0.200
     1.785    -7.527     0.200
     1.980    -9.202     0.200
     2.233   -10.300     0.200
     2.453   -12.513     0.200
     2.772   -15.907     0.200
     0.413     2.718     0.200
     0.413     2.864     0.200
     0.413     2.558     0.200
     1.090    -2.908     0.200
     1.090    -3.127     0.200
     1.175    -1.217     0.200
     1.300    -2.401     0.200
     1.586    -3.597     0.200
     1.586    -4.025     0.200
     1.595    -4.610     0.200
     1.675    -4.697     0.200
     1.786    -7.620     0.200
     1.774    -7.025     0.200
     2.015    -7.427     0.200
     2.098    -9.811     0.200
     2.360   -10.610     0.200
     2.429   -14.604     0.200
     2.405   -11.334     0.200
     2.405   -11.723     0.200
     3.119   -16.331     0.200
     3.232   -19.354     0.200
     3.367   -21.718     0.200
     3.448   -19.907     0.200
     3.776   -25.549     0.200
     3.800   -24.624     0.200
     3.811   -24.484     0.200
     4.071   -27.628     0.200
     7.146   -50.105     0.200
    11.607   -82.938     0.200
     0.657     4.869     0.200
     0.946     0.368     0.200
     0.910     2.134     0.200
     1.209    -1.007     0.200
     1.376    -1.599     0.200
     1.462    -4.508     0.200
     1.998    -7.426     0.200
     2.048    -7.753     0.200
     2.057    -7.207     0.200
     2.102    -8.352     0.200
     2.396   -12.258     0.200
     0.616    15.122     0.200
     1.250     3.867     0.200
     1.250     4.380     0.200
     1.509    -0.982     0.200
     1.509    -0.670     0.200
     1.598    -1.301     0.200
     1.746    -3.526     0.200
     1.746    -3.296     0.200
     2.333   -10.020     0.200
     2.436   -10.603     0.200
     7.815   -56.875     0.200
     0.279     5.332     0.200
     1.212    -0.907     0.200
     1.376    -3.217     0.200
     1.376    -3.491     0.200
     2.622    -9.620     0.200
     3.290   -15.247     0.200
     3.718   -20.933     0.200
     4.010   -21.483     0.200
     4.914   -30.149     0.200
     5.388   -30.452     0.200
     5.463   -32.429     0.200
     5.559   -37.715     0.200
     5.854   -38.763     0.200
     6.100   -38.130     0.200
     6.556   -42.523     0.200
     6.685   -42.927     0.200
     6.708   -43.826     0.200
     7.068   -46.198     0.200
     8.775   -62.012     0.200
    13.130   -91.264     0.200
     0.424    11.199     0.200
     0.603     9.784     0.200
     0.700     6.946     0.200
     0.857     6.504     0.200
     1.014     1.704     0.200
     1.122     0.730     0.200
     1.122     0.597     0.200
     1.420    -3.056     0.200
     1.420    -3.322     0.200
     1.409    -1.834     0.200
     1.409    -2.233     0.200
     1.632    -3.932     0.200
     1.664    -2.604     0.200
     1.688    -3.067     0.200
     1.688    -3.489     0.200
     2.093    -8.383     0.200
     2.257    -8.831     0.200
     2.257    -9.089     0.200
     2.827   -15.782     0.200
     3.344   -19.234     0.200
     3.706   -22.958     0.200
     3.754   -21.006     0.200
     3.914   -25.079     0.200
     4.012   -25.297     0.200
     4.332   -28.155     0.200
     7.095   -49.802     0.200
    12.562   -90.349     0.200
     0.579     2.732     0.200
     0.579     2.875     0.200
     0.824     1.079     0.200
     1.105     0.161     0.200
     1.213    -3.004     0.200
     1.641    -6.560     0.200
     6.970   -48.575     0.200
     0.762     1.285     0.200
     1.284    -3.232     0.200
     1.332    -1.888     0.200
     1.415    -2.069     0.200
     1.932    -5.874     0.200
     2.431   -10.670     0.200
     3.054   -14.588     0.200
     1.071     0.071     0.200
     0.313    22.798     0.200
     0.398    20.583     0.200
     0.813    11.378     0.200
     0.932    10.577     0.200
     0.932    10.710     0.200
     1.257     5.846     0.200
     1.276     4.980     0.200
     1.276     4.762     0.200
     1.514     3.330     0.200
     1.649    -1.017     0.200
     1.649    -1.361     0.200
     1.694     0.029     0.200
     1.738    -2.295     0.200
     1.738    -1.967     0.200
     2.036    -2.973     0.200
     2.036    -2.708     0.200
     2.117    -6.321     0.200
     2.174    -5.208     0.200
     2.174    -4.793     0.200
     2.276    -4.863     0.200
     2.287    -5.743     0.200
     2.639   -11.476     0.200
     3.039   -11.949     0.200
     3.055   -12.559     0.200
     3.364   -18.408     0.200
     3.770   -21.265     0.200
     4.202   -25.875     0.200
     4.571   -27.659     0.200
     7.382   -52.823     0.200
    13.191   -93.404     0.200
     0.711     3.607     0.200
     0.711     3.365     0.200
     0.782     0.145     0.200
     0.782     0.458     0.200
     1.178    -1.736     0.200
     1.349    -2.829     0.200
     1.349    -4.110     0.200
     1.968    -9.079     0.200
     9.206   -69.182     0.200
     0.455    14.523     0.200
     0.980     4.618     0.200
     1.156     1.052     0.200
     1.607    -4.435     0.200
     1.607    -4.822     0.200
     7.612   -54.934     0.200
     0.590     2.065     0.200
     1.408    -4.181     0.200
     1.681    -6.872     0.200
     0.732     2.957     0.200
     1.041     0.086     0.200
     1.381    -2.107     0.200
     1.810    -6.896     0.200
     1.913    -8.905     0.200
     2.136    -7.855     0.200
     2.263   -10.083     0.200
     2.558   -12.576     0.200
     2.939   -13.756     0.200
     8.049   -58.704     0.200
    12.974   -91.922     0.200
     0.723    -0.744     0.200
     0.581     5.152     0.200
     0.942     2.163     0.200
     1.950    -5.913     0.200
     2.126    -6.252     0.200
     0.615     3.801     0.200
     0.615     3.954     0.200
     0.655     3.374     0.200
     0.692     3.540     0.200
     0.861     1.627     0.200
     0.845     2.454     0.200
     0.845     2.235     0.200
     0.882     0.557     0.200
     1.131    -2.322     0.200
     1.131    -2.608     0.200
     1.177    -2.422     0.200
     1.180    -1.001     0.200
     1.217    -2.712     0.200
     1.523    -4.102     0.200
     1.596    -4.782     0.200
     1.601    -5.008     0.200
     1.601    -5.125     0.200
     1.697    -5.211     0.200
     1.947   -10.320     0.200
     1.947   -10.185     0.200
     1.965    -9.129     0.200
     2.303    -9.453     0.200
     2.401    -9.457     0.200
     2.580   -12.983     0.200
     2.855   -17.202     0.200
     3.188   -19.880     0.200
     3.194   -20.097     0.200
     3.211   -19.659     0.200
     3.349   -22.110     0.200
     3.539   -24.675     0.200
     6.445   -46.423     0.200
    11.675   -81.031     0.200
    15.275  -111.785     0.200
    18.679  -140.748     0.200
     0.469    10.955     0.200
     0.567     8.600     0.200
     0.929     4.631     0.200
     1.035     1.925     0.200
     1.110     0.892     0.200
     1.214     1.750     0.200
     1.388    -2.499     0.200
     1.418    -1.392     0.200
     1.438    -1.835     0.200
     1.707    -2.927     0.200
     1.734    -3.634     0.200
     1.978    -8.223     0.200
     0.215     8.513     0.200
     0.529     2.362     0.200
     1.339    -4.235     0.200
     1.262    -2.805     0.200
     1.771    -5.807     0.200
     2.024    -9.089     0.200
     2.319   -12.236     0.200
     2.323   -11.632     0.200
     3.007   -19.405     0.200
     0.459     4.325     0.200
     0.460     4.280     0.200
     0.570     3.319     0.200
     0.708     2.173     0.200
     0.708     3.650     0.200
     0.752     1.692     0.200
     1.088    -1.454     0.200
     1.088     0.141     0.200
     1.543    -2.588     0.200
     1.543    -3.752     0.200
     1.583    -5.560     0.200
     1.583    -5.669     0.200
     1.801    -5.243     0.200
     1.922    -7.951     0.200
     1.922    -7.591     0.200
     7.125   -49.703     0.200
     0.543     4.879     0.200
     0.638     2.538     0.200
     0.860     2.580     0.200
     1.002     0.509     0.200
     1.003     0.471     0.200
     1.441    -3.488     0.200
     1.512    -4.254     0.200
     1.780    -7.129     0.200
     1.825    -6.807     0.200
     2.022    -8.033     0.200
     2.091    -8.211     0.200
     2.094    -8.886     0.200
     0.564     3.470     0.200
     0.823    -0.882     0.200
     1.220    -2.590     0.200
     1.230    -2.656     0.200
     1.846    -7.525     0.200
     9.137   -65.017     0.200
     0.446     6.893     0.200
     0.788     3.633     0.200
     0.803     2.585     0.200
     0.863     2.285     0.200
     0.863     1.968     0.200
     1.044     0.269     0.200
     1.044    -0.079     0.200
     1.246    -1.203     0.200
     1.272    -2.393     0.200
     1.343    -2.855     0.200
     1.502    -4.219     0.200
     1.494    -3.167     0.200
     1.558    -5.021     0.200
     1.590    -4.736     0.200
     2.017    -8.263     0.200
     2.040    -8.049     0.200
     2.082    -9.544     0.200
     2.258   -10.210     0.200
     2.364   -10.617     0.200
     2.439   -11.946     0.200
     2.456   -10.153     0.200
     2.510   -10.176     0.200
     2.852   -16.070     0.200
     2.888   -14.577     0.200
     2.975   -15.563     0.200
     3.321   -17.803     0.200
     4.024   -24.603     0.200
     7.917   -56.537     0.200
     1.005     1.049     0.200
     0.992     2.225     0.200
     1.193    -0.853     0.200
     1.198     0.258     0.200
     1.330    -0.839     0.200
     1.596    -2.914     0.200
     1.615    -4.647     0.200
     2.098    -8.063     0.200
     2.588   -11.771     0.200
     0.603     4.136     0.200
     0.877     0.977     0.200
     0.996     0.125     0.200
     1.053     0.073     0.200
     1.233    -2.924     0.200
     1.253    -1.073     0.200
     1.437    -3.834     0.200
     1.418    -2.871     0.200
     1.738    -6.533     0.200
     2.043   -10.023     0.200
     2.208    -9.463     0.200
     2.317   -12.669     0.200
     2.854   -17.900     0.200
     2.859   -17.631     0.200
     4.459   -28.075     0.200
     0.624     4.576     0.200
     0.758     2.495     0.200
     0.867     0.771     0.200
     1.009     0.127     0.200
     1.011     0.074     0.200
     1.464    -4.453     0.200
     1.539    -5.358     0.200
     1.767    -6.287     0.200
     1.960    -8.387     0.200
     7.573   -54.389     0.200
     1.472    -7.197     0.200
     2.135    -7.314     0.200
     3.575   -18.359     0.200
     3.947   -27.709     0.200
     4.208   -25.131     0.200
     4.839   -26.037     0.200
     4.840   -26.209     0.200
     5.034   -28.619     0.200
     5.141   -31.274     0.200
     5.506   -34.456     0.200
     5.707   -35.434     0.200
     6.228   -38.258     0.200
     6.342   -40.779     0.200
     6.405   -41.648     0.200
     6.850   -44.743     0.200
     6.863   -41.247     0.200
     7.036   -43.902     0.200
     7.260   -46.582     0.200
     7.310   -45.623     0.200
     7.685   -48.982     0.200
     7.800   -48.816     0.200
     8.082   -51.648     0.200
     8.947   -60.091     0.200
    12.641   -84.300     0.200
     0.821     2.364     0.200
     1.461    -7.830     0.200
     1.461    -7.042     0.200
     1.427    -3.607     0.200
     3.579   -18.554     0.200
     3.936   -26.994     0.200
     4.213   -26.084     0.200
     4.840   -25.940     0.200
     5.039   -29.462     0.200
     5.147   -32.364     0.200
     5.513   -36.235     0.200
     5.618   -35.220     0.200
     5.715   -36.813     0.200
     8.951   -62.954     0.200
    12.653   -90.461     0.200
     0.194    16.758     0.200
     0.296    15.309     0.200
     0.478    11.193     0.200
     0.490    11.267     0.200
     0.565     9.312     0.200
     0.692     6.699     0.200
     0.693     6.768     0.200
     0.949     4.082     0.200
     0.949     4.565     0.200
     1.071     1.775     0.200
     1.150     0.268     0.200
     1.131     1.304     0.200
     1.213     0.488     0.200
     1.261     0.399     0.200
     1.310    -0.861     0.200
     1.588    -4.491     0.200
     1.588    -4.351     0.200
     1.688    -3.391     0.200
     1.761    -4.708     0.200
     1.993    -6.384     0.200
     2.096    -7.631     0.200
     2.080    -7.052     0.200
     2.173    -6.912     0.200
     2.211    -7.512     0.200
     2.377   -12.163     0.200
     2.335    -9.678     0.200
     2.582   -12.803     0.200
     0.961     1.116     0.200
     0.961     1.304     0.200
     1.091     0.571     0.200
     1.091     0.817     0.200
     1.157    -0.083     0.200
     1.157     1.116     0.200
     1.555    -3.620     0.200
     1.827    -4.031     0.200
     1.903    -5.505     0.200
     2.076    -6.773     0.200
     2.337    -6.948     0.200
     2.720   -10.790     0.200
     3.108   -12.781     0.200
     5.447   -30.431     0.200
     9.008   -60.446     0.200
     0.181    17.499     0.200
     0.463    12.000     0.200
     0.487    11.590     0.200
     0.553     9.705     0.200
     0.677     7.096     0.200
     1.062     1.789     0.200
     1.146     0.883     0.200
     1.272     0.210     0.200
     1.300    -0.470     0.200
     0.755     2.552     0.200
     0.755     2.751     0.200
     0.737     3.657     0.200
     1.420    -4.702     0.200
     2.206   -10.326     0.200
     0.236    14.735     0.200
     0.659     6.785     0.200
     0.714     4.814     0.200
     0.985     3.259     0.200
     1.073     0.395     0.200
     1.078     0.560     0.200
     1.254    -0.973     0.200
     0.498     4.143     0.200
     0.498     4.310     0.200
     0.671     2.496     0.200
     1.036    -0.483     0.200
     1.036    -0.364     0.200
     1.375    -3.070     0.200
     1.487    -3.590     0.200
     0.492     3.251     0.200
     1.419    -2.569     0.200
     0.052    29.139     0.200
     0.401    20.552     0.200
     0.571    16.385     0.200
     0.651    14.321     0.200
     0.716    12.729     0.200
     0.889    10.481     0.200
     1.542     1.019     0.200
     1.550     0.351     0.200
     2.092    -5.236     0.200
     2.179    -6.863     0.200
     2.426    -9.584     0.200
     7.197   -50.199     0.200
     2.119   -10.934     0.200
     8.409   -60.987     0.200
     1.821    -6.796     0.200
     9.314   -65.893     0.200
     0.579     1.944     0.200
     0.579     2.077     0.200
     1.146    -0.862     0.200
     1.146    -0.347     0.200
     1.257    -4.233     0.200
     1.341    -3.604     0.200
     1.434    -3.377     0.200
     1.434    -3.002     0.200
     1.623    -6.475     0.200
     1.608    -5.893     0.200
     1.889    -5.948     0.200
     2.082   -11.397     0.200
     2.082   -10.044     0.200
     6.983   -49.958     0.200
     0.930     4.493     0.200
     1.109     1.379     0.200
     1.140     0.371     0.200
     1.311    -0.722     0.200
     1.759    -4.460     0.200
     2.151    -6.961     0.200
     2.221    -9.127     0.200
     6.104   -37.849     0.200
     0.535     2.310     0.200
     0.535     2.545     0.200
     1.807    -5.371     0.200
     1.988    -7.240     0.200
     2.149    -9.333     0.200
     2.221    -9.229     0.200
     2.427   -11.083     0.200
     2.440    -9.690     0.200
     2.599   -13.837     0.200
     2.701   -13.660     0.200
     2.828   -13.038     0.200
     2.849   -15.154     0.200
     2.907   -15.153     0.200
     3.221   -20.765     0.200
     7.979   -58.871     0.200
    11.931   -81.317     0.200
     0.461     4.590     0.200
     1.069    -0.102     0.200
     1.348    -3.582     0.200
     1.507    -3.813     0.200
     2.872   -12.252     0.200
     4.555   -28.172     0.200
     4.806   -30.930     0.200
     5.171   -33.994     0.200
     8.452   -59.171     0.200
     0.429     4.056     0.200
     0.429     4.377     0.200
     0.871     0.397     0.200
     0.871     0.204     0.200
     0.871     0.520     0.200
     1.303    -2.751     0.200
     1.373    -2.984     0.200
     1.503    -3.785     0.200
     1.562    -3.184     0.200
     8.173   -60.987     0.200
     1.371     2.446     0.200
     1.639    -2.030     0.200
     2.210    -4.365     0.200
     2.826    -8.836     0.200
     8.314   -53.400     0.200
     1.110     0.848     0.200
     1.353     1.575     0.200
     1.581    -1.933     0.200
     1.777    -3.919     0.200
     1.858    -4.490     0.200
     2.218    -7.611     0.200
     2.777    -8.391     0.200
     3.160   -12.118     0.200
     4.508   -19.942     0.200
     8.253   -52.259     0.200
     2.106    -6.734     0.200
     0.308     5.540     0.200
     0.602     1.720     0.200
     0.721     2.236     0.200
     1.636    -6.181     0.200
     1.946    -7.754     0.200
     2.638   -13.075     0.200
     1.143     0.216     0.200
     0.877     2.439     0.200
     0.877     1.105     0.200
     0.877     1.327     0.200
     8.361   -60.372     0.200
     0.804     2.872     0.200
     8.284   -57.522     0.200
    12.114   -79.859     0.200
     0.772     3.218     0.200
     0.772     3.045     0.200
     2.767   -13.986     0.200
     8.261   -55.016     0.200
    12.127   -81.689     0.200
     0.591     2.113     0.200
     1.454    -3.313     0.200
     1.510    -6.210     0.200
     0.233    10.195     0.200
     0.654     3.783     0.200
     0.760     2.545     0.200
     0.944     0.597     0.200
     0.920     0.606     0.200
     0.920     1.098     0.200
     0.970     0.816     0.200
     1.129    -0.090     0.200
     1.199    -0.623     0.200
     1.229    -1.475     0.200
     1.685    -6.622     0.200
     2.096    -8.711     0.200
     2.286   -10.883     0.200
     7.862   -57.502     0.200
    12.832   -92.666     0.200
    13.171   -95.407     0.200
     0.147    22.332     0.200
     0.171    21.375     0.200
     0.355    16.398     0.200
     0.449    14.579     0.200
     0.597    12.429     0.200
     1.091     4.549     0.200
     1.437    -1.210     0.200
     1.540    -0.774     0.200
     1.643    -2.421     0.200
     1.753    -4.189     0.200
     1.839    -4.741     0.200
     2.351    -8.439     0.200
     2.789   -14.706     0.200
     3.964   -22.342     0.200
     4.005   -24.799     0.200
     4.375   -25.562     0.200
     0.358     4.197     0.200
     1.065    -0.804     0.200
     1.097    -5.010     0.200
     1.408    -2.727     0.200
     1.406    -3.110     0.200
     1.718    -6.420     0.200
     1.836    -6.349     0.200
     1.837    -6.357     0.200
     9.137   -66.741     0.200
     0.431     4.457     0.200
     0.432     4.410     0.200
     0.602     3.028     0.200
     0.742     1.391     0.200
     1.084    -1.889     0.200
     1.075    -1.048     0.200
     1.053     0.619     0.200
     1.942    -6.184     0.200
     9.119   -66.771     0.200
     0.457     7.451     0.200
     0.471     7.670     0.200
     0.673     4.546     0.200
     0.675     4.383     0.200
     0.732     3.767     0.200
     0.733     3.761     0.200
     0.899     2.632     0.200
     0.913     3.277     0.200
     0.894     1.280     0.200
     0.894     1.096     0.200
     0.894     1.526     0.200
     1.011     2.058     0.200
     1.005     0.786     0.200
     1.005     0.411     0.200
     1.203     0.304     0.200
     1.195    -0.637     0.200
     1.197    -0.825     0.200
     1.233    -2.071     0.200
     1.233    -1.739     0.200
     1.269    -3.264     0.200
     1.537    -3.351     0.200
     1.577    -3.951     0.200
     1.601    -4.548     0.200
     1.588    -3.484     0.200
     1.588    -3.706     0.200
     1.621    -3.912     0.200
     1.697    -4.337     0.200
     1.678    -4.823     0.200
     1.761    -5.742     0.200
     1.973    -8.669     0.200
     1.940    -9.088     0.200
     2.203    -8.581     0.200
     2.277    -9.451     0.200
     2.386   -10.248     0.200
     4.108   -29.036     0.200
     6.987   -48.027     0.200
     7.090   -49.663     0.200
     7.090   -50.737     0.200
    12.356   -86.992     0.200
    12.990   -95.117     0.200
    15.773  -113.310     0.200
     0.052    31.632     0.200
     0.331    24.538     0.200
     0.353    23.896     0.200
     0.495    20.229     0.200
     0.749    14.826     0.200
     0.883    12.091     0.200
     1.211     7.233     0.200
     1.395     5.128     0.200
     1.603     1.804     0.200
     1.919    -1.064     0.200
     2.152    -5.883     0.200
     2.178    -2.891     0.200
     2.195    -3.396     0.200
     2.442    -8.643     0.200
     3.298   -16.285     0.200
     3.650   -19.539     0.200
     3.986   -20.393     0.200
     4.396   -26.796     0.200
     0.960     0.841     0.200
     1.025     1.355     0.200
     1.025     1.719     0.200
     1.186    -0.362     0.200
     0.283     6.766     0.200
     0.761     1.451     0.200
     0.802     1.209     0.200
     0.937    -0.093     0.200
     0.980    -0.484     0.200
     0.991    -1.005     0.200
     1.009    -0.810     0.200
     1.352    -2.805     0.200
     0.674     1.210     0.200
     1.339    -4.677     0.200
     0.262    25.972     0.200
     0.263    26.187     0.200
     0.263    25.925     0.200
     0.319    25.063     0.200
     0.353    24.290     0.200
     0.371    23.115     0.200
     0.372    23.420     0.200
     0.372    23.294     0.200
     0.622    17.335     0.200
     0.800    14.039     0.200
     0.800    14.176     0.200
     0.836    12.791     0.200
     1.025    10.708     0.200
     1.048    10.061     0.200
     1.146     7.259     0.200
     1.297     6.102     0.200
     1.728    -0.997     0.200
     0.356     5.984     0.200
     0.603     3.212     0.200
     0.695     2.853     0.200
     0.887     0.278     0.200
     1.041     0.236     0.200
     1.153    -0.939     0.200
     1.153    -1.489     0.200
     1.306    -1.540     0.200
     1.589    -4.303     0.200
     1.661    -4.613     0.200
     7.035   -51.892     0.200
    11.975   -82.485     0.200
    15.352  -110.568     0.200
     0.359     9.433     0.200
     0.503     6.999     0.200
     0.526     6.631     0.200
     0.554     6.768     0.200
     0.566     6.006     0.200
     0.696     4.107     0.200
     0.696     4.095     0.200
     0.727     3.443     0.200
     0.808     3.623     0.200
     0.920     1.769     0.200
     0.919     1.793     0.200
     0.943     2.278     0.200
     1.266    -1.802     0.200
     1.275    -2.530     0.200
     1.275    -2.045     0.200
     1.320    -2.196     0.200
     1.370    -2.930     0.200
     1.657    -3.947     0.200
     1.659    -3.997     0.200
     1.882    -6.524     0.200
     2.026    -8.248     0.200
     2.130    -9.207     0.200
     2.146    -8.153     0.200
     2.454   -11.592     0.200
     8.076   -59.610     0.200
     0.352    11.298     0.200
     0.514     8.384     0.200
     0.537     8.344     0.200
     0.660     6.564     0.200
     0.706     5.385     0.200
     0.729     5.511     0.200
     0.931     2.807     0.200
     1.318    -1.687     0.200
     1.372    -1.976     0.200
     1.663    -4.468     0.200
     1.679    -5.235     0.200
     2.141    -9.001     0.200
     3.115   -14.371     0.200
     4.342   -25.686     0.200
     1.337    -0.043     0.200
     7.722   -46.271     0.200
     1.532    -1.492     0.200
     1.534    -1.546     0.200
     1.205    -2.492     0.200
     1.251    -3.012     0.200
     1.826    -5.599     0.200
     7.798   -55.083     0.200
    12.201   -85.515     0.200
     0.300     3.559     0.200
     0.390     2.702     0.200
     0.789    -0.766     0.200
     0.789    -0.535     0.200
     1.083    -1.009     0.200
     1.084    -1.034     0.200
     1.210    -3.400     0.200
     1.252    -2.716     0.200
     1.321    -3.605     0.200
     1.400    -3.056     0.200
     1.402    -3.709     0.200
     1.477    -3.677     0.200
     1.692    -5.144     0.200
     1.694    -5.174     0.200
     1.831    -6.733     0.200
     7.794   -54.431     0.200
     0.932     0.680     0.200
     0.932     0.205     0.200
     0.988     0.065     0.200
     8.460   -59.318     0.200
     0.514     5.381     0.200
     0.536     5.952     0.200
     0.663     3.954     0.200
     0.664     3.895     0.200
     0.787     1.491     0.200
     0.788     1.457     0.200
     0.813     1.782     0.200
     0.813     1.954     0.200
     0.950     0.451     0.200
     0.986     0.896     0.200
     1.314    -3.214     0.200
     1.671    -5.576     0.200
     7.149   -50.128     0.200
    12.337   -87.463     0.200
     0.441    10.783     0.200
     0.548     7.952     0.200
     0.596     6.906     0.200
     0.582     7.622     0.200
     0.868     3.452     0.200
     0.948     2.729     0.200
     1.188    -0.742     0.200
     1.227    -0.518     0.200
     1.385    -1.115     0.200
     2.071    -8.176     0.200
     2.284   -10.012     0.200
     0.290     5.789     0.200
     0.290     5.930     0.200
     0.745     1.691     0.200
     1.197    -4.161     0.200
     1.348    -2.937     0.200
     1.394    -4.200     0.200
     1.502    -3.567     0.200
     1.684    -4.648     0.200
     8.785   -64.137     0.200
     1.768    -6.634     0.200
     9.247   -64.675     0.200
     1.845    -7.333     0.200
     9.336   -62.348     0.200
     1.450    -1.415     0.200
     0.174     6.578     0.200
     0.174     5.566     0.200
     0.679     0.479     0.200
     0.792     0.923     0.200
     0.793     0.897     0.200
     0.897    -0.637     0.200
     1.351    -3.704     0.200
     1.650    -5.037     0.200
     1.651    -5.078     0.200
     1.806    -5.208     0.200
     7.505   -49.921     0.200
     0.798     1.141     0.200
     1.021    -0.640     0.200
     1.397    -3.061     0.200
     1.395    -3.443     0.200
     1.513    -4.140     0.200
     1.687    -4.585     0.200
     2.227    -8.019     0.200
     8.893   -65.631     0.200
    13.456   -94.612     0.200
     1.110     1.378     0.200
     1.136     1.549     0.200
     6.490   -36.519     0.200
     0.062    27.322     0.200
     0.027    28.716     0.200
     0.242    22.154     0.200
     0.243    22.114     0.200
     0.556    15.603     0.200
     0.700    12.816     0.200
     0.796    10.324     0.200
     0.796    10.509     0.200
     1.124     6.040     0.200
     1.124     6.309     0.200
     1.191     4.936     0.200
     1.191     5.291     0.200
     1.199     4.300     0.200
     1.580    -1.000     0.200
     1.852    -2.158     0.200
     7.752   -56.994     0.200
    13.335   -95.104     0.200
     0.079    30.490     0.200
     0.419    21.540     0.200
     0.559    18.373     0.200
     0.615    16.717     0.200
     0.616    16.729     0.200
     0.684    15.256     0.200
     0.684    15.018     0.200
     0.819    13.023     0.200
     0.850    12.166     0.200
     1.145     7.551     0.200
     1.145     7.250     0.200
     1.341     5.755     0.200
     1.414     3.955     0.200
     1.480     2.764     0.200
     1.537     2.320     0.200
     1.537     2.058     0.200
     1.621     0.074     0.200
     1.863    -0.473     0.200
     2.215    -6.648     0.200
     7.212   -53.209     0.200
     0.630     5.862     0.200
     0.676     4.917     0.200
     0.827     3.052     0.200
     0.827     3.059     0.200
     1.048     0.157     0.200
     1.048     0.367     0.200
     1.114    -0.309     0.200
     1.114    -0.543     0.200
     1.319    -2.324     0.200
     1.319    -2.699     0.200
     1.388    -2.979     0.200
     1.388    -3.260     0.200
     1.595    -3.813     0.200
     1.748    -7.229     0.200
     1.803    -6.164     0.200
     1.804    -6.088     0.200
     2.191   -10.434     0.200
     8.266   -60.924     0.200
     0.897     2.100     0.200
     1.371    -7.187     0.200
     9.043   -62.359     0.200
    12.740   -83.909     0.200
     0.933     1.460     0.200
     1.348    -6.727     0.200
     1.555    -3.817     0.200
     9.080   -61.106     0.200
    12.762   -86.290     0.200
     1.028    -0.494     0.200
     1.337    -4.980     0.200
     1.642    -5.266     0.200
     1.642    -5.121     0.200
     9.165   -62.739     0.200
     0.553     7.033     0.200
     0.700     5.127     0.200
     0.654     6.320     0.200
     0.906     2.320     0.200
     0.989     1.366     0.200
     1.154    -1.769     0.200
     1.259    -2.234     0.200
     1.437    -2.749     0.200
     1.547    -3.553     0.200
     1.671    -5.578     0.200
     0.459     3.273     0.200
     0.459     4.094     0.200
     0.493     3.800     0.200
     0.495     3.758     0.200
     0.820     0.658     0.200
     0.820     1.189     0.200
     1.003    -2.415     0.200
     1.135    -1.784     0.200
     1.194     0.060     0.200
     1.272    -2.328     0.200
     1.462    -2.114     0.200
     1.568    -4.588     0.200
     1.569    -3.948     0.200
     7.193   -48.540     0.200
     1.096     2.250     0.200
     1.091     2.876     0.200
    13.218   -83.100     0.200
     1.114     0.668     0.200
     1.114     1.025     0.200
     1.199     0.082     0.200
     1.309    -0.598     0.200
     1.576    -2.896     0.200
     2.288    -7.543     0.200
     3.049   -12.256     0.200
     3.298   -13.521     0.200
     3.892   -18.281     0.200
     8.263   -53.214     0.200
     1.120     1.084     0.200
     1.101     1.395     0.200
     1.101     1.263     0.200
     1.336    -2.932     0.200
     1.172     0.502     0.200
     1.589    -3.439     0.200
     0.052    11.935     0.200
     0.730    -0.059     0.200
     0.792     1.723     0.200
     1.256    -0.851     0.200
     1.556    -7.458     0.200
     1.835    -7.673     0.200
     1.840    -7.021     0.200
     1.871    -6.513     0.200
     4.137   -27.843     0.200
     4.150   -26.866     0.200
     4.707   -27.509     0.200
     4.800   -30.479     0.200
     5.740   -37.559     0.200
     0.689     2.015     0.200
     0.691     1.973     0.200
     0.972    -0.327     0.200
     1.146    -0.254     0.200
     1.391    -3.081     0.200
     6.723   -44.359     0.200
     0.865     0.538     0.200
     0.865     1.273     0.200
     0.946    -0.109     0.200
     1.200     0.434     0.200
     2.011    -9.466     0.200
     8.352   -58.701     0.200
    12.161   -85.655     0.200
     0.364     7.212     0.200
     0.365     6.764     0.200
     0.399     5.839     0.200
     0.399     7.190     0.200
     0.917     0.220     0.200
     1.000     0.274     0.200
     1.000     0.602     0.200
     1.248    -2.274     0.200
     1.248    -0.383     0.200
     1.314    -1.799     0.200
     6.711   -44.070     0.200
     0.539     3.722     0.200
     0.676     2.724     0.200
     0.677     2.710     0.200
     0.740     2.442     0.200
     0.929     0.272     0.200
     1.038    -0.801     0.200
     1.038    -0.814     0.200
     1.383    -3.849     0.200
     1.382    -3.825     0.200
     0.397     9.482     0.200
     0.656     4.876     0.200
     0.646     6.168     0.200
     0.665     4.862     0.200
     0.676     4.640     0.200
     0.676     4.622     0.200
     0.776     4.343     0.200
     0.890     1.919     0.200
     0.962     1.392     0.200
     0.964     1.346     0.200
     0.979     1.481     0.200
     0.981     1.429     0.200
     1.055    -0.384     0.200
     1.274    -1.411     0.200
     1.243    -0.427     0.200
     1.350    -3.262     0.200
     1.633    -5.919     0.200
     1.993    -7.710     0.200
     2.328   -11.735     0.200
     0.581     7.016     0.200
     0.580     6.755     0.200
     0.581     6.737     0.200
     0.792     4.390     0.200
     0.923     2.815     0.200
     1.002     2.807     0.200
     1.009     1.426     0.200
     1.009     1.449     0.200
     1.031     1.460     0.200
     1.023     1.087     0.200
     1.208    -1.087     0.200
     1.401    -2.323     0.200
     1.400    -2.300     0.200
     1.657    -5.003     0.200
     1.657    -5.577     0.200
     1.875    -8.166     0.200
     1.985    -7.306     0.200
     2.125    -8.902     0.200
     2.131    -9.045     0.200
     2.132    -9.096     0.200
     2.196    -8.514     0.200
    13.589   -97.618     0.200
     0.371     7.821     0.200
     0.438     6.845     0.200
     0.440     6.788     0.200
     0.585     4.383     0.200
     0.703     3.185     0.200
     0.764     2.300     0.200
     0.914     0.362     0.200
     1.028     0.181     0.200
     1.247    -2.094     0.200
     1.668    -6.200     0.200
     1.668    -5.974     0.200
     1.865    -6.256     0.200
     2.026    -7.505     0.200
     6.859   -48.817     0.200
    12.113   -88.375     0.200
     0.335     5.008     0.200
     0.841    -3.296     0.200
     1.082    -1.551     0.200
     1.082    -1.293     0.200
     1.082    -0.621     0.200
     1.626    -4.404     0.200
     1.744    -6.259     0.200
     1.744    -7.256     0.200
     2.030   -11.346     0.200
     2.139    -8.368     0.200
     2.459   -10.946     0.200
     2.461   -10.530     0.200
     3.205   -21.040     0.200
     5.161   -32.932     0.200
     9.133   -67.563     0.200
    13.432   -95.144     0.200
    16.091  -114.609     0.200
     0.940     0.882     0.200
     1.065     2.036     0.200
     1.613    -4.357     0.200
     1.613    -4.111     0.200
     2.154    -6.500     0.200
     9.120   -62.421     0.200
    13.064   -87.135     0.200
     0.477     5.621     0.200
     0.479     5.709     0.200
     0.614     5.238     0.200
     0.666     2.940     0.200
     0.666     3.623     0.200
     0.732     3.402     0.200
     1.010     1.148     0.200
     1.001     0.267     0.200
     1.002    -0.103     0.200
     1.053    -0.355     0.200
     1.433    -3.403     0.200
     1.434    -3.570     0.200
     1.481    -4.833     0.200
     1.823    -7.200     0.200
     1.865    -7.664     0.200
     1.852    -6.455     0.200
     1.892    -7.045     0.200
     2.466   -11.415     0.200
     2.588   -15.133     0.200
     2.600   -11.770     0.200
     2.701   -13.805     0.200
     3.238   -18.239     0.200
     3.391   -20.572     0.200
     3.506   -22.461     0.200
     3.554   -19.212     0.200
     7.089   -51.258     0.200
    12.128   -85.097     0.200
     0.250    16.045     0.200
     0.432    11.651     0.200
     0.487    10.187     0.200
     0.826     5.290     0.200
     0.891     4.484     0.200
     1.018     2.208     0.200
     0.991     2.854     0.200
     1.120     0.774     0.200
     1.414    -1.980     0.200
     2.012    -7.551     0.200
     7.104   -50.587     0.200
    12.567   -87.256     0.200
    13.334   -97.262     0.200
     0.311    12.767     0.200
     0.363    11.921     0.200
     0.564     7.357     0.200
     0.566     7.311     0.200
     0.803     4.789     0.200
     0.805     4.686     0.200
     0.861     3.787     0.200
     1.000     1.106     0.200
     1.062     1.592     0.200
     1.101     0.666     0.200
     1.103     0.614     0.200
     1.127    -0.415     0.200
     1.128     0.296     0.200
     1.128    -0.165     0.200
     1.371    -2.572     0.200
     1.371    -2.315     0.200
     1.391    -2.061     0.200
     1.443    -2.427     0.200
     1.477    -4.013     0.200
     1.558    -4.005     0.200
     1.558    -3.897     0.200
     1.578    -2.742     0.200
     1.920    -6.117     0.200
     2.106   -10.059     0.200
     2.183    -9.161     0.200
     6.985   -52.624     0.200
     0.188    24.793     0.200
     0.318    21.542     0.200
     0.319    21.352     0.200
     0.424    19.895     0.200
     0.775    12.654     0.200
     0.775    12.482     0.200
     0.888     9.702     0.200
     1.024     8.589     0.200
     0.917     8.868     0.200
     1.041     7.922     0.200
     1.041     8.676     0.200
     1.397     3.813     0.200
     1.414     3.527     0.200
     1.434     3.243     0.200
     1.500     1.642     0.200
     1.445     2.217     0.200
     1.554     1.848     0.200
     1.552     0.878     0.200
     1.553     0.031     0.200
     1.692    -0.267     0.200
     1.560    -1.183     0.200
     1.560     0.144     0.200
     1.684     0.285     0.200
     1.684    -0.031     0.200
     1.572    -0.562     0.200
     1.900    -2.574     0.200
     1.900    -2.893     0.200
     1.910    -2.244     0.200
     1.974    -3.123     0.200
     2.039    -3.799     0.200
     1.905    -4.252     0.200
     2.211    -5.819     0.200
     2.347    -9.551     0.200
     2.347    -9.088     0.200
     2.301    -6.112     0.200
     2.376    -9.173     0.200
     2.491   -10.047     0.200
     2.550   -11.308     0.200
     2.762   -11.218     0.200
     2.752   -12.833     0.200
     2.663    -9.748     0.200
     3.053   -13.788     0.200
     3.152   -14.176     0.200
     3.234   -14.468     0.200
     3.211   -13.449     0.200
     3.249   -14.301     0.200
     3.225   -14.990     0.200
     3.482   -20.348     0.200
     3.560   -19.071     0.200
     3.604   -20.753     0.200
     3.640   -20.343     0.200
     3.699   -19.320     0.200
     3.842   -20.223     0.200
     3.870   -20.509     0.200
     3.870   -20.105     0.200
     3.933   -21.380     0.200
     3.958   -22.779     0.200
     3.931   -22.081     0.200
     3.931   -22.475     0.200
     4.069   -21.028     0.200
     4.093   -21.078     0.200
     4.148   -20.892     0.200
     4.194   -22.817     0.200
     4.283   -24.352     0.200
     4.340   -26.668     0.200
     4.255   -25.210     0.200
     4.387   -26.902     0.200
     4.488   -28.440     0.200
     4.599   -26.490     0.200
     4.614   -26.044     0.200
     4.598   -26.811     0.200
     4.614   -28.947     0.200
     4.684   -28.230     0.200
     4.771   -26.527     0.200
     4.766   -26.570     0.200
     4.805   -26.147     0.200
     4.770   -29.868     0.200
     4.915   -29.965     0.200
     4.915   -31.100     0.200
     5.012   -28.255     0.200
     5.051   -29.741     0.200
     5.169   -30.247     0.200
     5.125   -33.433     0.200
     5.316   -31.719     0.200
     5.299   -33.481     0.200
     5.378   -31.630     0.200
     5.349   -35.611     0.200
     5.577   -33.610     0.200
     5.657   -34.459     0.200
     5.665   -35.560     0.200
     5.670   -36.056     0.200
     5.729   -35.004     0.200
     5.688   -34.151     0.200
     5.865   -37.013     0.200
     5.883   -37.147     0.200
     5.823   -37.135     0.200
     5.900   -34.794     0.200
     5.900   -36.945     0.200
     5.927   -38.764     0.200
     5.991   -34.790     0.200
     6.023   -37.962     0.200
     6.127   -38.512     0.200
     6.126   -40.338     0.200
     6.214   -41.426     0.200
     6.283   -39.814     0.200
     6.283   -41.463     0.200
     6.453   -39.731     0.200
     6.464   -41.352     0.200
     6.638   -42.715     0.200
     6.687   -41.398     0.200
     6.687   -44.693     0.200
     6.649   -43.877     0.200
     6.953   -42.953     0.200
     6.969   -43.401     0.200
     7.024   -45.585     0.200
     7.115   -44.378     0.200
     7.162   -46.471     0.200
     7.148   -45.990     0.200
     7.215   -46.122     0.200
     7.272   -49.721     0.200
     7.321   -48.295     0.200
     7.370   -49.838     0.200
     7.418   -49.664     0.200
     7.406   -49.788     0.200
     7.435   -50.683     0.200
     7.501   -48.358     0.200
     7.594   -48.890     0.200
     7.580   -55.790     0.200
     7.723   -50.246     0.200
     7.737   -52.492     0.200
     7.781   -51.475     0.200
     7.768   -51.214     0.200
     7.857   -52.851     0.200
     7.847   -55.611     0.200
     7.864   -54.761     0.200
     7.915   -53.801     0.200
     8.047   -53.796     0.200
     8.112   -54.120     0.200
     8.229   -55.363     0.200
     8.174   -55.688     0.200
     8.223   -55.070     0.200
     8.267   -57.813     0.200
     8.334   -58.876     0.200
     8.359   -55.777     0.200
     8.526   -60.880     0.200
     8.563   -55.612     0.200
     8.570   -55.814     0.200
     8.581   -56.563     0.200
     8.727   -59.884     0.200
     8.769   -60.002     0.200
     8.816   -61.778     0.200
     8.771   -58.987     0.200
     8.936   -62.655     0.200
     8.899   -59.305     0.200
     8.958   -60.299     0.200
     9.018   -62.774     0.200
     9.111   -63.534     0.200
     9.175   -63.265     0.200
     9.199   -65.017     0.200
     9.245   -63.895     0.200
     9.157   -63.871     0.200
     9.334   -63.073     0.200
     9.277   -65.939     0.200
     9.308   -65.148     0.200
     9.407   -64.533     0.200
     9.357   -64.372     0.200
     9.563   -65.015     0.200
     9.651   -67.068     0.200
     9.786   -67.505     0.200
     9.859   -68.748     0.200
    10.063   -69.965     0.200
    10.039   -70.667     0.200
    10.098   -74.797     0.200
    10.087   -70.711     0.200
    10.217   -69.360     0.200
    10.251   -65.493     0.200
    10.240   -74.647     0.200
    10.306   -67.648     0.200
    10.280   -67.636     0.200
    10.272   -69.515     0.200
    10.411   -68.806     0.200
    10.388   -70.839     0.200
    10.529   -76.265     0.200
    10.626   -72.851     0.200
    10.628   -74.455     0.200
    10.628   -72.736     0.200
    10.650   -71.759     0.200
    10.634   -70.205     0.200
    10.623   -75.531     0.200
    10.717   -76.277     0.200
    10.735   -69.542     0.200
    10.843   -72.946     0.200
    10.840   -70.936     0.200
    10.766   -74.456     0.200
    10.905   -71.576     0.200
    11.054   -75.415     0.200
    11.110   -77.491     0.200
    11.203   -77.500     0.200
    11.402   -79.183     0.200
    11.540   -79.071     0.200
    11.534   -80.913     0.200
    11.594   -78.024     0.200
    11.669   -81.166     0.200
    11.635   -79.386     0.200
    11.740   -84.211     0.200
    11.998   -83.504     0.200
    12.215   -83.958     0.200
    12.523   -85.729     0.200
    12.671   -89.720     0.200
    12.698   -89.516     0.200
    12.616   -87.771     0.200
    12.765   -89.079     0.200
    12.861   -86.447     0.200
    13.029   -90.401     0.200
    13.143   -91.340     0.200
    13.235   -95.107     0.200
    13.235   -91.412     0.200
    13.313   -93.431     0.200
    13.295   -93.000     0.200
    13.458   -89.544     0.200
    13.648   -90.391     0.200
    13.915   -95.161     0.200
    15.620  -107.574     0.200
    16.009  -112.418     0.200
    16.607  -118.119     0.200
     0.227     7.015     0.200
     0.701     1.926     0.200
     0.816     0.941     0.200
     0.959    -1.709     0.200
     0.991    -1.636     0.200
     1.150    -1.227     0.200
     1.149    -4.261     0.200
     1.162    -2.373     0.200
     1.162    -2.381     0.200
     1.271    -2.122     0.200
     1.646    -5.533     0.200
     1.658    -4.946     0.200
     8.319   -61.290     0.200
     0.218     5.357     0.200
     0.218     5.123     0.200
     0.619     1.363     0.200
     0.619     1.243     0.200
     0.868    -0.902     0.200
     1.094    -1.652     0.200
     1.086    -0.621     0.200
     1.152    -1.901     0.200
     1.439    -2.561     0.200
     1.691    -3.920     0.200
     1.965    -8.996     0.200
     7.320   -51.897     0.200
     0.542     4.071     0.200
     0.542     4.540     0.200
     0.813     1.546     0.200
     0.862     1.050     0.200
     0.871     0.964     0.200
     1.135    -1.390     0.200
     1.235    -0.623     0.200
     1.505    -5.212     0.200
     2.057    -9.154     0.200
     2.192    -9.479     0.200
     0.447     8.516     0.200
     0.654     4.912     0.200
     0.718     4.860     0.200
     0.784     4.669     0.200
     0.834     3.254     0.200
     0.944     2.188     0.200
     1.016     0.104     0.200
     1.393    -3.282     0.200
     1.450    -3.308     0.200
     1.970    -7.108     0.200
     0.484     4.107     0.200
     0.578     2.911     0.200
     0.701     2.836     0.200
     0.795     0.997     0.200
     1.032    -1.812     0.200
     1.080    -2.244     0.200
     1.088     0.476     0.200
     1.188    -2.264     0.200
     1.365    -3.335     0.200
     0.282    22.168     0.200
     0.316    21.402     0.200
     0.375    20.551     0.200
     0.937     8.791     0.200
     1.020     6.833     0.200
     1.370     2.948     0.200
     1.524     1.894     0.200
     1.598    -0.101     0.200
     1.778    -1.873     0.200
     2.020    -5.273     0.200
     2.020    -5.064     0.200
     2.205    -5.037     0.200
     2.327    -7.965     0.200
     2.394    -6.976     0.200
     2.547    -8.727     0.200
     2.681   -12.416     0.200
     2.681   -12.525     0.200
     2.780   -12.126     0.200
     0.056    29.752     0.200
     0.055    29.811     0.200
     0.305    23.628     0.200
     0.314    23.134     0.200
     0.420    19.027     0.200
     0.466    19.171     0.200
     0.788    11.581     0.200
     0.788    12.003     0.200
     0.825    11.917     0.200
     0.825    11.690     0.200
     0.815    12.741     0.200
     0.815    12.905     0.200
     0.916    10.502     0.200
     0.916    10.260     0.200
     1.099     5.953     0.200
     1.250     5.302     0.200
     1.250     5.450     0.200
     1.416     3.638     0.200
     1.416     3.787     0.200
     1.408     3.075     0.200
     1.409     3.139     0.200
     1.560     1.265     0.200
     1.570     1.434     0.200
     1.562    -0.041     0.200
     1.562    -0.377     0.200
     1.562     0.186     0.200
     1.638     0.198     0.200
     1.638     0.495     0.200
     1.700    -0.713     0.200
     1.686    -0.991     0.200
     1.686    -0.382     0.200
     1.690    -1.890     0.200
     1.690    -1.562     0.200
     1.840    -2.233     0.200
     1.941    -2.602     0.200
     2.062    -3.728     0.200
     2.117    -4.354     0.200
     2.112    -6.430     0.200
     2.112    -6.102     0.200
     2.201    -6.189     0.200
     2.189    -6.077     0.200
     2.231    -6.872     0.200
     2.525   -10.504     0.200
     2.526   -10.775     0.200
     2.649   -11.712     0.200
     2.810   -13.590     0.200
     2.810   -13.910     0.200
     2.914   -12.036     0.200
     2.942   -10.408     0.200
     2.932   -14.373     0.200
     2.975   -11.555     0.200
     2.976   -12.443     0.200
     3.001   -12.695     0.200
     3.039   -13.769     0.200
     3.112   -13.071     0.200
     3.251   -17.341     0.200
     3.268   -17.454     0.200
     3.323   -14.874     0.200
     3.312   -16.828     0.200
     3.357   -17.761     0.200
     3.424   -15.631     0.200
     3.530   -17.723     0.200
     3.586   -17.253     0.200
     3.597   -18.057     0.200
     3.636   -17.330     0.200
     3.669   -20.802     0.200
     3.806   -20.064     0.200
     3.816   -19.863     0.200
     3.879   -21.165     0.200
     3.927   -19.941     0.200
     4.010   -22.095     0.200
     4.094   -21.610     0.200
     4.093   -25.402     0.200
     4.176   -25.549     0.200
     4.222   -27.237     0.200
     4.354   -27.324     0.200
     4.413   -24.223     0.200
     4.403   -26.572     0.200
     4.403   -28.619     0.200
     4.439   -24.793     0.200
     4.489   -27.139     0.200
     4.530   -25.916     0.200
     4.529   -28.157     0.200
     4.529   -29.970     0.200
     4.589   -29.622     0.200
     4.638   -30.565     0.200
     4.650   -30.880     0.200
     4.698   -27.021     0.200
     4.789   -28.006     0.200
     4.787   -28.805     0.200
     4.864   -31.819     0.200
     4.882   -28.896     0.200
     5.039   -32.492     0.200
     5.128   -33.139     0.200
     5.387   -35.030     0.200
     5.425   -35.482     0.200
     5.629   -36.307     0.200
     5.642   -36.517     0.200
     5.812   -36.844     0.200
     5.796   -37.545     0.200
     5.850   -39.531     0.200
     5.936   -39.325     0.200
     5.929   -37.593     0.200
     6.042   -39.737     0.200
     6.206   -39.486     0.200
     6.222   -40.364     0.200
     6.422   -44.266     0.200
     6.876   -46.654     0.200
     6.890   -46.004     0.200
     6.995   -49.121     0.200
     7.072   -47.705     0.200
     7.094   -47.215     0.200
     7.136   -49.762     0.200
     7.157   -49.132     0.200
     7.243   -47.814     0.200
     7.303   -53.544     0.200
     7.459   -52.333     0.200
     7.498   -51.045     0.200
     7.511   -51.111     0.200
     7.524   -50.249     0.200
     7.578   -52.146     0.200
     7.589   -55.033     0.200
     7.687   -52.385     0.200
     7.723   -50.360     0.200
     7.840   -52.883     0.200
     7.858   -54.128     0.200
     7.945   -53.343     0.200
     7.950   -55.515     0.200
     7.990   -56.379     0.200
     7.982   -52.931     0.200
     8.063   -59.114     0.200
     8.141   -54.634     0.200
     8.248   -60.311     0.200
     8.277   -52.720     0.200
     8.577   -58.378     0.200
     8.744   -65.547     0.200
     8.750   -60.457     0.200
     8.791   -61.924     0.200
     8.834   -63.895     0.200
     9.041   -63.598     0.200
     9.152   -62.497     0.200
     9.299   -61.976     0.200
     9.374   -63.111     0.200
     9.407   -67.690     0.200
     9.417   -67.250     0.200
     9.440   -68.212     0.200
     9.511   -69.118     0.200
     9.684   -64.995     0.200
     9.820   -72.080     0.200
     9.821   -68.821     0.200
     9.837   -67.494     0.200
     9.859   -70.033     0.200
     9.883   -66.574     0.200
     9.941   -68.796     0.200
     9.947   -68.225     0.200
    13.072   -94.270     0.200
    13.596  -101.020     0.200
    16.537  -119.731     0.200
     0.430     8.537     0.200
     0.537     5.585     0.200
     0.576     4.876     0.200
     0.682     3.904     0.200
     0.900     2.708     0.200
     1.017    -0.164     0.200
     1.115     0.187     0.200
     1.284    -1.879     0.200
     1.537    -4.600     0.200
     1.848    -7.400     0.200
     2.133    -8.736     0.200
     2.394   -11.472     0.200
     4.362   -27.440     0.200
     6.018   -35.360     0.200
     7.461   -49.891     0.200
     0.348    18.146     0.200
     0.420    16.503     0.200
     0.836     8.154     0.200
     0.873     7.859     0.200
     1.290     2.160     0.200
     1.592    -2.079     0.200
     1.675    -2.262     0.200
     1.793    -4.189     0.200
     1.793    -3.820     0.200
     1.985    -4.821     0.200
     2.128    -7.645     0.200
     8.107   -59.496     0.200
     1.019     0.676     0.200
     1.019    -0.149     0.200
     1.698    -4.927     0.200
     1.698    -5.659     0.200
     2.633   -10.681     0.200
     3.337   -14.186     0.200
     9.174   -64.524     0.200
    13.230   -92.331     0.200
     1.043    -0.777     0.200
     1.093    -0.026     0.200
     1.714    -7.502     0.200
     8.568   -60.810     0.200
     0.643     1.806     0.200
     1.434    -3.879     0.200
     1.650    -5.272     0.200
     0.575     2.532     0.200
     0.700     2.236     0.200
     0.957    -0.932     0.200
     1.118    -0.321     0.200
     1.142    -3.082     0.200
     1.146    -2.379     0.200
     1.151    -0.453     0.200
     1.271    -2.434     0.200
     1.437    -2.415     0.200
     1.570    -3.924     0.200
     1.820    -7.529     0.200
     2.247    -9.779     0.200
     3.418   -18.920     0.200
     8.663   -61.414     0.200
     0.631     2.119     0.200
     0.632     1.598     0.200
     0.885    -1.074     0.200
     1.549    -5.890     0.200
     2.004    -9.304     0.200
     2.865   -14.593     0.200
     2.938   -16.414     0.200
     3.886   -23.317     0.200
     3.895   -23.141     0.200
     4.025   -24.195     0.200
     4.159   -26.040     0.200
     4.297   -27.401     0.200
     4.487   -27.211     0.200
     6.783   -44.783     0.200
    12.725   -79.939     0.200
     0.630     2.503     0.200
     1.523    -5.524     0.200
     2.230    -8.109     0.200
     0.974    -0.241     0.200
     0.975     0.403     0.200
     0.410     8.121     0.200
     0.660     4.501     0.200
     0.756     3.088     0.200
     0.867     1.649     0.200
     1.247    -2.840     0.200
     1.218    -0.481     0.200
     1.534    -3.810     0.200
     1.553    -4.088     0.200
     1.580    -2.688     0.200
     1.924    -8.491     0.200
     4.881   -31.749     0.200
     7.100   -48.680     0.200
    12.340   -90.789     0.200
     0.374     6.093     0.200
     0.626     2.612     0.200
     0.702     2.329     0.200
     0.820     1.047     0.200
     0.885     0.300     0.200
     0.918     0.477     0.200
     0.917     0.365     0.200
     1.058    -0.162     0.200
     1.092    -1.194     0.200
     1.153    -1.356     0.200
     1.209    -1.717     0.200
     1.372    -3.701     0.200
     1.552    -5.352     0.200
     1.804    -7.255     0.200
     0.113    11.644     0.200
     0.706     1.916     0.200
     0.727     2.139     0.200
     0.747     2.113     0.200
     0.746     1.688     0.200
     0.831     1.493     0.200
     0.874     0.870     0.200
     0.892     0.905     0.200
     0.914     0.326     0.200
     0.920     0.511     0.200
     0.933     0.313     0.200
     1.007     0.690     0.200
     1.069    -0.943     0.200
     1.079    -0.675     0.200
     1.123     0.168     0.200
     1.256    -2.465     0.200
     8.102   -56.809     0.200
     0.419     3.622     0.200
     0.419     3.825     0.200
     0.498     3.015     0.200
     1.098    -2.961     0.200
     1.121    -1.778     0.200
     1.250    -2.672     0.200
     1.318    -3.086     0.200
     1.356    -4.006     0.200
     1.389    -2.628     0.200
     1.394    -2.883     0.200
     1.403    -3.195     0.200
     1.478    -4.371     0.200
     1.551    -5.060     0.200
     7.122   -50.497     0.200
    11.637   -77.259     0.200
     0.483     3.898     0.200
     0.483     3.673     0.200
     0.520     3.249     0.200
     0.804     0.464     0.200
     0.858     0.150     0.200
     0.998    -2.056     0.200
     1.087    -1.601     0.200
     1.181    -0.458     0.200
     3.918   -25.030     0.200
     7.128   -48.978     0.200
     7.207   -48.424     0.200
     1.385     0.918     0.200
     1.445     1.554     0.200
     0.786     2.008     0.200
     1.454    -3.481     0.200
     0.133    17.720     0.200
     0.164    17.032     0.200
     0.247    14.828     0.200
     0.311    12.905     0.200
     0.439    10.139     0.200
     0.471     9.704     0.200
     0.548     9.082     0.200
     0.589     8.514     0.200
     0.894     3.364     0.200
     0.976     3.541     0.200
     1.053     1.162     0.200
     1.119     0.251     0.200
     1.119     0.542     0.200
     1.469    -2.669     0.200
     7.217   -50.900     0.200
    12.658   -88.653     0.200
     0.499     3.998     0.200
     0.568     1.869     0.200
     0.617     2.371     0.200
     0.949    -0.609     0.200
     1.040    -1.244     0.200
     1.143    -1.567     0.200
     1.336    -2.808     0.200
     0.261    12.982     0.200
     0.406    10.208     0.200
     0.535     7.796     0.200
     0.626     6.385     0.200
     0.612     6.612     0.200
     0.700     5.051     0.200
     0.672     5.952     0.200
     0.688     5.637     0.200
     0.704     5.492     0.200
     0.744     4.212     0.200
     0.862     2.948     0.200
     0.979     1.786     0.200
     1.036     0.805     0.200
     1.026     1.869     0.200
     1.002     2.137     0.200
     1.117    -0.476     0.200
     1.276    -1.354     0.200
     1.461    -4.053     0.200
     0.198     7.380     0.200
     0.645     0.071     0.200
     0.987    -0.484     0.200
     1.129    -2.848     0.200
     1.461    -6.434     0.200
     1.436    -3.614     0.200
     1.452    -3.415     0.200
     1.590    -5.256     0.200
     1.804    -5.998     0.200
     1.815    -5.292     0.200
     1.826    -5.859     0.200
     1.986    -8.254     0.200
     2.083    -8.323     0.200
     2.102    -9.059     0.200
     2.264   -11.453     0.200
     7.638   -51.160     0.200
     0.674     3.009     0.200
     0.792     2.072     0.200
     0.809     1.645     0.200
     0.811     1.748     0.200
     0.885     2.114     0.200
     0.929     0.892     0.200
     1.067    -0.939     0.200
     1.067    -0.716     0.200
     1.114    -0.878     0.200
     1.258    -1.618     0.200
     1.354    -2.344     0.200
     1.843    -7.527     0.200
     2.110    -8.264     0.200
     1.268     0.601     0.200
     1.292     1.516     0.200
     2.080    -3.766     0.200
     1.151     0.876     0.200
     1.275    -0.461     0.200
     0.439     6.504     0.200
     0.445     6.921     0.200
     0.491     6.447     0.200
     0.511     5.078     0.200
     0.613     5.192     0.200
     0.707     2.493     0.200
     0.880     0.121     0.200
     0.904     0.575     0.200
     0.997    -0.545     0.200
     1.072     0.041     0.200
     1.412    -4.445     0.200
     1.431    -3.727     0.200
     1.441    -3.732     0.200
     0.356     4.697     0.200
     0.488     3.299     0.200
     0.488     3.451     0.200
     0.864     1.071     0.200
     1.058    -0.555     0.200
     1.116    -0.267     0.200
     1.116    -2.798     0.200
     1.140    -1.053     0.200
     1.156    -1.137     0.200
     1.166    -1.228     0.200
     1.175    -1.985     0.200
     1.175    -1.187     0.200
     1.180    -0.488     0.200
     1.185    -0.450     0.200
     1.197    -1.398     0.200
     1.309    -2.417     0.200
     1.329    -2.657     0.200
     1.441    -3.493     0.200
     1.427    -3.289     0.200
     1.452    -2.967     0.200
     1.476    -3.199     0.200
     1.712    -4.703     0.200
     1.743    -4.920     0.200
     2.128    -9.550     0.200
     6.808   -40.116     0.200
     7.067   -52.237     0.200
    11.838   -83.078     0.200
     0.300    12.570     0.200
     0.393    11.123     0.200
     0.469    10.046     0.200
     0.562     7.834     0.200
     0.600     7.155     0.200
     0.722     6.298     0.200
     0.725     4.974     0.200
     0.739     6.247     0.200
     0.746     6.354     0.200
     0.749     5.954     0.200
     0.768     4.566     0.200
     0.840     4.511     0.200
     0.889     2.738     0.200
     1.028     0.925     0.200
     1.101     0.103     0.200
     1.133     0.545     0.200
     1.393    -2.703     0.200
     1.464    -3.847     0.200
     1.464    -3.997     0.200
     1.462    -2.212     0.200
     1.673    -3.876     0.200
     1.723    -4.311     0.200
     4.903   -30.351     0.200
     6.975   -50.970     0.200
     1.247    -4.330     0.200
     1.698    -5.443     0.200
     1.698    -4.744     0.200
     9.225   -64.131     0.200
     0.952     1.465     0.200
     1.299    -7.120     0.200
     1.299    -7.378     0.200
     2.304    -7.164     0.200
     2.542   -10.677     0.200
     9.110   -64.720     0.200
    12.494   -90.497     0.200
    12.811   -86.763     0.200
    15.105   -95.542     0.200
    15.334  -104.314     0.200
     0.625     2.671     0.200
     1.142    -1.258     0.200
     1.249    -3.617     0.200
     1.765    -6.956     0.200
     1.765    -6.190     0.200
     2.229    -7.796     0.200
     9.290   -66.327     0.200
     1.022     1.457     0.200
     1.022     1.598     0.200
     1.022     1.205     0.200
     1.304    -5.924     0.200
     1.304    -6.263     0.200
     1.644    -4.364     0.200
     2.163    -8.435     0.200
     2.268    -8.543     0.200
     2.310    -7.753     0.200
     2.375    -8.985     0.200
     2.399    -9.307     0.200
     2.378    -7.700     0.200
     2.467    -8.506     0.200
     2.472   -10.080     0.200
     2.613   -11.610     0.200
     2.600    -9.171     0.200
     2.799   -14.860     0.200
     2.735    -9.699     0.200
     3.040   -13.334     0.200
     3.778   -23.956     0.200
     4.957   -30.707     0.200
     4.965   -31.502     0.200
     9.170   -56.878     0.200
     9.170   -61.945     0.200
    12.809   -85.591     0.200
     1.134    -0.132     0.200
     1.749    -5.343     0.200
     1.749    -4.753     0.200
     2.256    -6.264     0.200
     2.331    -7.204     0.200
     2.376    -7.474     0.200
     9.272   -65.721     0.200
    12.831   -84.844     0.200
     0.670     2.116     0.200
     0.670     2.687     0.200
     1.300    -4.190     0.200
     1.763    -6.510     0.200
     2.287    -8.468     0.200
     3.162   -15.528     0.200
     3.641   -19.553     0.200
     3.921   -19.731     0.200
     4.094   -22.971     0.200
     6.014   -36.924     0.200
     9.285   -65.311     0.200
     0.596     1.038     0.200
     1.415    -3.630     0.200
     1.986    -6.493     0.200
     2.142    -9.371     0.200
     2.093    -7.977     0.200
     2.289    -7.935     0.200
     3.076   -16.299     0.200
     9.571   -64.381     0.200
     0.658     2.433     0.200
     0.668     3.039     0.200
     0.829     0.793     0.200
     0.921    -0.433     0.200
     0.977     0.535     0.200
     0.988     0.865     0.200
     1.003    -0.088     0.200
     0.995     0.891     0.200
     1.054    -0.844     0.200
     1.199    -1.912     0.200
     1.319    -1.465     0.200
     1.894    -8.446     0.200
     9.293   -62.235     0.200
    13.360   -90.159     0.200
     0.352     9.237     0.200
     0.371     9.529     0.200
     0.468     7.154     0.200
     0.605     5.115     0.200
     0.619     5.452     0.200
     0.723     4.836     0.200
     0.754     4.677     0.200
     0.895     1.720     0.200
     0.895     2.135     0.200
     1.059     0.799     0.200
     1.159    -1.692     0.200
     1.480    -3.728     0.200
     1.576    -4.420     0.200
     1.670    -5.677     0.200
     7.281   -51.180     0.200
     0.428     4.661     0.200
     0.822    -0.613     0.200
     0.822    -0.414     0.200
     1.135    -1.348     0.200
     1.325    -3.158     0.200
     1.535    -3.120     0.200
     9.138   -64.506     0.200
     1.108    -6.774     0.200
     1.677    -5.206     0.200
     1.677    -4.480     0.200
     9.200   -66.055     0.200
    13.004   -89.523     0.200
    15.226   -98.358     0.200
     1.085    -4.442     0.200
     1.739    -5.174     0.200
     1.739    -4.924     0.200
     9.263   -61.871     0.200
     0.709     2.395     0.200
     0.730     2.433     0.200
     0.809     1.359     0.200
     0.889    -0.324     0.200
     0.890     0.396     0.200
     0.906     0.894     0.200
     0.947     0.700     0.200
     0.974    -0.051     0.200
     0.962     0.285     0.200
     0.943     0.478     0.200
     1.031    -0.274     0.200
     1.031    -0.864     0.200
     1.078    -0.697     0.200
     1.135    -1.397     0.200
     1.200    -1.145     0.200
     1.470    -3.793     0.200
     1.566    -6.207     0.200
     1.799    -5.646     0.200
     2.057    -9.138     0.200
     2.215    -8.398     0.200
     2.237    -8.524     0.200
     2.268   -10.412     0.200
     8.474   -61.956     0.200
     3.952   -23.950     0.200
     4.984   -31.273     0.200
     5.012   -30.930     0.200
     5.029   -28.233     0.200
     5.594   -31.281     0.200
     6.117   -35.205     0.200
     6.375   -35.948     0.200
     6.369   -36.551     0.200
     7.252   -47.934     0.200
     7.761   -51.586     0.200
    12.925   -87.165     0.200
    15.163   -96.691     0.200
    18.950  -131.757     0.200
     0.419     4.772     0.200
     0.732     1.835     0.200
     0.971    -0.306     0.200
     1.012    -1.322     0.200
     1.021    -1.335     0.200
     1.054    -0.817     0.200
     1.081    -1.396     0.200
     1.121    -0.997     0.200
     1.297    -2.362     0.200
     1.359    -2.535     0.200
     1.426    -2.327     0.200
     1.696    -5.040     0.200
     0.507     2.799     0.200
     0.541     3.786     0.200
     1.107    -1.158     0.200
     1.107    -1.572     0.200
     1.162    -2.503     0.200
     1.271    -3.163     0.200
     1.289    -2.826     0.200
     1.291    -2.634     0.200
     1.329    -3.052     0.200
     1.411    -2.989     0.200
     1.481    -3.080     0.200
     1.614    -4.591     0.200
     1.706    -5.641     0.200
     8.472   -61.294     0.200
     0.361     7.805     0.200
     0.422     4.994     0.200
     1.209    -3.101     0.200
     1.130    -1.235     0.200
     1.135    -0.237     0.200
     1.189    -1.707     0.200
     1.269    -2.285     0.200
     1.392    -2.801     0.200
     1.698    -5.454     0.200
     1.834    -6.266     0.200
     2.105    -9.016     0.200
     2.153    -9.368     0.200
     2.309   -10.420     0.200
     2.350   -10.793     0.200
     0.700     2.494     0.200
     1.010     0.410     0.200
     1.481    -5.907     0.200
     1.589    -4.890     0.200
     1.589    -4.616     0.200
     2.286    -8.952     0.200
     9.101   -65.844     0.200
     0.322     9.982     0.200
     0.405     8.331     0.200
     0.429     8.008     0.200
     0.466     7.968     0.200
     0.472     7.547     0.200
     0.552     6.069     0.200
     0.664     4.325     0.200
     0.673     5.219     0.200
     0.794     3.437     0.200
     0.814     3.323     0.200
     0.898     2.154     0.200
     1.021     0.962     0.200
     1.051     0.413     0.200
     1.080     1.143     0.200
     1.258    -0.842     0.200
     1.287    -2.061     0.200
     1.445    -3.661     0.200
     2.006    -7.148     0.200
     2.413   -11.076     0.200
     2.567   -12.406     0.200
     0.284    14.200     0.200
     0.305    13.683     0.200
     0.372    12.921     0.200
     0.380    12.868     0.200
     0.397    12.194     0.200
     0.491    10.711     0.200
     0.571     8.770     0.200
     0.946     3.549     0.200
     0.995     2.941     0.200
     1.069     2.337     0.200
     1.121     0.959     0.200
     1.142     0.350     0.200
     1.125     1.954     0.200
     1.225     0.682     0.200
     1.316    -1.027     0.200
     1.765    -5.306     0.200
     2.344    -9.827     0.200
     2.577   -13.164     0.200
     2.650   -12.634     0.200
     0.551     3.823     0.200
     0.551     4.862     0.200
     0.633     2.326     0.200
     0.841     0.655     0.200
     0.886     0.512     0.200
     0.903     0.468     0.200
     0.990    -0.366     0.200
     1.105    -1.111     0.200
     1.311    -4.025     0.200
     1.286    -2.641     0.200
     1.489    -3.986     0.200
     1.528    -3.677     0.200
     1.782    -7.599     0.200
     2.020    -8.322     0.200
     2.105    -9.038     0.200
     2.145   -11.226     0.200
     2.174    -9.693     0.200
     2.194   -10.407     0.200
     2.403   -12.843     0.200
     7.676   -53.832     0.200
    12.462   -89.199     0.200
    12.818   -93.605     0.200
    12.818   -93.460     0.200
    15.625  -113.831     0.200
     0.575     4.448     0.200
     0.689     4.892     0.200
     0.750     3.914     0.200
     0.870     0.808     0.200
     0.853     1.872     0.200
     0.852     3.030     0.200
     0.975     0.774     0.200
     0.976     0.489     0.200
     1.257    -1.264     0.200
     1.276    -1.901     0.200
     1.273    -1.265     0.200
     1.570    -6.164     0.200
     1.581    -4.031     0.200
     1.593    -5.396     0.200
     1.899    -7.217     0.200
     1.916    -8.109     0.200
     1.985    -8.381     0.200
     2.193   -11.002     0.200
     2.552   -12.050     0.200
     2.562   -12.575     0.200
     2.827   -14.151     0.200
     0.347    12.820     0.200
     0.322    13.360     0.200
     0.421    11.677     0.200
     0.517     8.839     0.200
     0.550     8.367     0.200
     0.681     6.406     0.200
     0.739     5.563     0.200
     0.756     5.897     0.200
     0.761     6.227     0.200
     0.993     1.737     0.200
     1.134     0.530     0.200
     0.995     0.911     0.200
     1.027     1.251     0.200
     1.202     0.227     0.200
     1.243    -0.233     0.200
     1.243     0.017     0.200
     1.495    -2.341     0.200
     2.308    -6.547     0.200
     8.276   -52.150     0.200
     1.878    -7.287     0.200
     2.119    -8.365     0.200
     9.330   -64.427     0.200
    13.425   -92.386     0.200
     1.205     0.667     0.200
     1.230     0.394     0.200
     2.305    -5.545     0.200
     2.283    -5.644     0.200
     2.687    -8.543     0.200
     2.807    -8.806     0.200
     3.103   -13.067     0.200
     1.448    -1.247     0.200
     0.055    23.521     0.200
     0.092    22.113     0.200
     0.125    22.075     0.200
     0.117    22.291     0.200
     0.260    17.825     0.200
     0.382    15.291     0.200
     0.432    14.506     0.200
     0.470    13.116     0.200
     0.770     7.870     0.200
     0.791     7.302     0.200
     0.866     6.523     0.200
     0.883     6.146     0.200
     0.956     5.492     0.200
     1.073     4.208     0.200
     1.214     1.726     0.200
     1.374    -0.562     0.200
     1.453    -0.130     0.200
     1.469     0.242     0.200
     1.730    -3.012     0.200
     1.767    -3.565     0.200
     2.097    -7.388     0.200
     2.134    -7.192     0.200
     2.383   -11.248     0.200
     2.423   -10.007     0.200
     1.273     1.444     0.200
     1.354     0.671     0.200
     0.532     3.999     0.200
     0.689     3.203     0.200
     0.689     2.828     0.200
     0.767     1.897     0.200
     0.828     1.658     0.200
     0.886     1.352     0.200
     1.118    -2.037     0.200
     1.118    -3.008     0.200
     1.352    -2.944     0.200
     1.488    -4.087     0.200
     1.597    -6.196     0.200
     1.711    -5.100     0.200
     1.883    -8.028     0.200
     2.008    -9.152     0.200
     2.025    -7.819     0.200
     2.313   -11.459     0.200
     2.359   -10.883     0.200
     2.404   -11.456     0.200
     2.511   -11.047     0.200
     2.555   -12.506     0.200
     2.616   -13.901     0.200
     2.847   -16.534     0.200
     2.823   -13.572     0.200
     2.861   -14.314     0.200
     2.949   -14.335     0.200
     2.990   -14.976     0.200
     4.278   -26.210     0.200
     7.882   -58.430     0.200
    12.624   -89.816     0.200
     0.981     1.600     0.200
     1.216    -0.328     0.200
     1.225     0.326     0.200
     1.225     0.654     0.200
     1.406    -1.581     0.200
     1.773    -4.062     0.200
     8.815   -60.154     0.200
    15.030  -105.965     0.200
     0.332    11.787     0.200
     0.729     4.786     0.200
     0.747     4.447     0.200
     0.754     4.495     0.200
     0.769     4.508     0.200
     0.880     2.211     0.200
     0.903     2.297     0.200
     0.914     1.758     0.200
     0.957     0.886     0.200
     0.957     1.026     0.200
     0.998     1.850     0.200
     1.058     1.485     0.200
     1.393    -3.386     0.200
     1.393    -3.722     0.200
     1.436    -3.056     0.200
     1.530    -4.144     0.200
     1.776    -6.584     0.200
     1.807    -6.004     0.200
     1.834    -5.261     0.200
     2.086    -8.051     0.200
     2.086    -9.808     0.200
     2.535   -12.222     0.200
     3.707   -20.854     0.200
     6.935   -48.810     0.200
    12.254   -87.619     0.200
     0.752     2.750     0.200
     0.752     2.008     0.200
     0.857     0.467     0.200
     0.862    -0.281     0.200
     0.998    -0.227     0.200
     0.967     0.438     0.200
     0.967    -0.972     0.200
     1.070    -0.761     0.200
     1.064    -0.488     0.200
     1.108    -0.615     0.200
     1.143    -1.156     0.200
     1.307    -2.449     0.200
     1.355    -3.148     0.200
     1.431    -3.701     0.200
     1.485    -4.285     0.200
     1.947    -6.941     0.200
     2.032    -9.183     0.200
     2.190   -10.949     0.200
     2.457   -10.980     0.200
     2.426   -10.528     0.200
     2.726   -13.904     0.200
     2.852   -14.262     0.200
     2.937   -15.895     0.200
     3.015   -16.754     0.200
     3.080   -15.659     0.200
     3.091   -15.674     0.200
     3.102   -15.853     0.200
     3.135   -15.287     0.200
     3.250   -16.863     0.200
     3.515   -18.538     0.200
     8.621   -61.176     0.200
    13.392   -94.372     0.200
    16.299  -118.567     0.200
     0.752     1.767     0.200
     0.856     0.875     0.200
     0.859     0.538     0.200
     0.980    -0.624     0.200
     1.009    -0.429     0.200
     1.011    -0.721     0.200
     1.074    -0.861     0.200
     1.068    -0.280     0.200
     1.104    -0.307     0.200
     1.152    -0.964     0.200
     1.174    -1.553     0.200
     1.305    -2.653     0.200
     1.424    -3.764     0.200
     1.500    -5.231     0.200
     1.500    -5.520     0.200
     1.961    -6.877     0.200
     2.197    -8.951     0.200
     2.458   -11.375     0.200
     2.737   -14.229     0.200
     2.858   -15.156     0.200
     3.028   -13.887     0.200
     3.500   -19.686     0.200
     3.867   -22.668     0.200
     3.907   -23.254     0.200
     8.635   -60.650     0.200
     0.535     6.161     0.200
     0.772     2.552     0.200
     0.759     3.570     0.200
     0.777     3.407     0.200
     0.801     3.408     0.200
     0.800     3.150     0.200
     1.089     0.452     0.200
     1.276    -0.677     0.200
     1.367    -3.479     0.200
     1.405    -2.532     0.200
     1.468    -3.776     0.200
     1.541    -4.634     0.200
     1.628    -5.090     0.200
     0.482     8.658     0.200
     0.505     8.239     0.200
     0.552     7.665     0.200
     0.734     4.647     0.200
     0.853     4.334     0.200
     0.966     1.389     0.200
     1.161    -0.869     0.200
     1.242    -1.456     0.200
     2.143    -8.292     0.200
     5.671   -36.662     0.200
     8.112   -60.701     0.200
     6.901   -46.125     0.200
     0.718     3.748     0.200
     0.718     3.428     0.200
     0.827     2.497     0.200
     1.340    -3.221     0.200
     1.340    -2.807     0.200
     8.519   -60.604     0.200
     0.297    12.930     0.200
     0.338    12.059     0.200
     0.356    11.661     0.200
     0.429     9.753     0.200
     0.438     9.775     0.200
     0.455     9.593     0.200
     0.570     8.952     0.200
     0.576     7.568     0.200
     0.706     5.054     0.200
     0.733     5.461     0.200
     0.985     1.015     0.200
     0.985     0.716     0.200
     1.149    -0.499     0.200
     1.149    -1.749     0.200
     1.151     1.171     0.200
     1.171     0.680     0.200
     1.169     1.003     0.200
     1.178     1.691     0.200
     1.233     0.008     0.200
     1.239    -1.475     0.200
     1.311    -0.557     0.200
     1.358    -1.277     0.200
     1.443    -2.172     0.200
     1.486    -1.657     0.200
     1.502    -2.974     0.200
     1.498    -2.471     0.200
     1.703    -4.661     0.200
     1.703    -6.921     0.200
     1.683    -3.073     0.200
     1.683    -4.918     0.200
     1.802    -5.618     0.200
     1.815    -5.109     0.200
     1.932    -5.450     0.200
     1.944    -7.735     0.200
     2.126    -7.864     0.200
     2.288    -9.917     0.200
     2.562   -11.893     0.200
     4.207   -25.018     0.200
     4.515   -25.703     0.200
     6.972   -42.874     0.200
     7.408   -52.972     0.200
    12.682   -89.407     0.200
     0.484     9.632     0.200
     0.567     7.673     0.200
     0.656     5.961     0.200
     0.672     5.752     0.200
     0.691     5.849     0.200
     0.685     6.583     0.200
     0.752     4.812     0.200
     0.778     4.256     0.200
     0.780     3.893     0.200
     0.771     4.414     0.200
     1.059     0.072     0.200
     1.102     1.758     0.200
     1.120     1.492     0.200
     1.124     1.456     0.200
     1.139     1.450     0.200
     1.450    -2.389     0.200
     1.435    -1.271     0.200
     1.520    -2.895     0.200
     1.581    -3.458     0.200
     1.675    -4.638     0.200
     1.708    -6.180     0.200
     1.691    -4.476     0.200
     1.722    -5.253     0.200
     1.751    -4.634     0.200
     1.769    -5.092     0.200
     1.777    -5.527     0.200
     1.789    -5.810     0.200
     1.930    -5.784     0.200
     1.975    -7.151     0.200
     2.126    -9.529     0.200
     2.166    -9.694     0.200
     0.936    -0.077     0.200
     0.936    -0.407     0.200
     0.982    -0.037     0.200
     3.414   -17.312     0.200
     3.648   -19.131     0.200
     5.785   -34.274     0.200
     9.079   -62.046     0.200
    13.199   -90.896     0.200
     1.118     0.760     0.200
     1.353     1.029     0.200
     7.194   -44.347     0.200
     0.547     5.374     0.200
     0.731     1.893     0.200
     0.724     3.611     0.200
     0.807     2.534     0.200
     0.904     1.702     0.200
     0.932     1.075     0.200
     0.956     1.249     0.200
     0.985     0.135     0.200
     1.003     1.009     0.200
     1.006     0.891     0.200
     1.224    -3.573     0.200
     1.431    -4.540     0.200
     1.454    -2.398     0.200
     1.522    -4.528     0.200
     0.108    18.799     0.200
     0.194    17.038     0.200
     0.198    16.386     0.200
     0.244    15.434     0.200
     0.280    15.330     0.200
     0.286    14.745     0.200
     0.456    10.803     0.200
     0.506    10.037     0.200
     0.581     7.673     0.200
     0.591     8.399     0.200
     0.631     8.639     0.200
     0.719     6.806     0.200
     0.863     2.725     0.200
     1.291    -0.147     0.200
     1.306     0.759     0.200
     1.446    -1.552     0.200
     1.451    -1.710     0.200
     1.510    -2.826     0.200
     1.704    -2.953     0.200
     1.795    -4.301     0.200
     2.015    -5.731     0.200
     7.939   -57.860     0.200
    13.302   -99.327     0.200
     0.210    26.320     0.200
     0.216    26.134     0.200
     0.233    25.938     0.200
     0.243    24.850     0.200
     0.292    24.021     0.200
     0.299    23.450     0.200
     0.334    23.410     0.200
     0.360    21.898     0.200
     0.416    21.085     0.200
     0.427    20.552     0.200
     0.533    18.430     0.200
     0.887    11.363     0.200
     0.919    10.284     0.200
     0.920    10.464     0.200
     0.946    10.561     0.200
     0.956    10.507     0.200
     0.993    10.518     0.200
     1.029     8.243     0.200
     1.310     5.243     0.200
     1.382     3.633     0.200
     1.490     2.983     0.200
     1.603     1.680     0.200
     1.619    -0.352     0.200
     1.885    -2.346     0.200
     2.022    -4.489     0.200
     2.128    -4.003     0.200
     2.227    -5.309     0.200
     2.245    -5.689     0.200
     2.382    -7.729     0.200
     2.579    -9.025     0.200
     1.383     0.348     0.200
     1.537    -1.119     0.200
     7.618   -48.262     0.200
     1.312    -0.215     0.200
     1.354     0.953     0.200
     1.378     0.764     0.200
     1.821    -2.987     0.200
     0.316     8.478     0.200
     0.421     6.646     0.200
     0.613     4.499     0.200
     0.628     4.490     0.200
     0.642     4.324     0.200
     0.668     4.153     0.200
     0.686     4.402     0.200
     0.764     3.399     0.200
     0.968     0.043     0.200
     1.118    -0.574     0.200
     1.091     0.308     0.200
     1.213    -1.566     0.200
     1.210     0.171     0.200
     1.225    -2.110     0.200
     1.250    -2.377     0.200
     1.254    -3.100     0.200
     1.359    -2.627     0.200
     1.145     0.753     0.200
     1.204     1.209     0.200
     1.212     1.256     0.200
     1.044    -0.792     0.200
     1.061     0.224     0.200
     1.676    -4.485     0.200
     8.570   -60.036     0.200
     0.808     2.086     0.200
     0.827     2.205     0.200
     0.844     1.737     0.200
     0.855     1.962     0.200
     0.865     1.700     0.200
     0.875     1.371     0.200
     0.892     1.539     0.200
     0.932     1.099     0.200
     1.033    -0.281     0.200
     1.041    -0.008     0.200
     1.098    -0.243     0.200
     1.121    -0.658     0.200
     1.247    -0.786     0.200
     1.268    -2.009     0.200
     1.370    -1.617     0.200
     1.384    -2.451     0.200
     1.377    -4.456     0.200
     1.377    -3.210     0.200
     1.803    -5.306     0.200
     1.914    -7.270     0.200
     2.086    -8.897     0.200
     2.135    -9.907     0.200
     2.199   -11.104     0.200
     2.240    -9.020     0.200
     2.245    -8.580     0.200
     2.392   -11.495     0.200
     2.555   -11.289     0.200
     2.871   -13.999     0.200
     2.936   -14.306     0.200
     2.960   -14.692     0.200
     3.356   -17.133     0.200
     3.567   -20.169     0.200
     3.630   -21.421     0.200
     5.255   -34.581     0.200
     8.476   -61.646     0.200
    13.300   -91.767     0.200
     0.887     2.097     0.200
     1.252     0.703     0.200
     1.443    -2.767     0.200
     3.034   -15.333     0.200
     3.473   -15.012     0.200
     3.767   -20.066     0.200
     8.092   -49.257     0.200
     1.102     1.126     0.200
     1.316    -0.333     0.200
     1.451    -1.830     0.200
     1.764    -5.329     0.200
     0.885     0.835     0.200
     0.917     0.642     0.200
     0.829     2.287     0.200
     0.829     2.918     0.200
     1.240    -0.830     0.200
     1.197     1.547     0.200
     1.378    -2.139     0.200
     1.282     0.938     0.200
     1.819    -4.385     0.200
     1.891    -4.636     0.200
     1.990    -5.409     0.200
     1.990    -5.169     0.200
     2.249    -6.409     0.200
     2.594    -8.107     0.200
     6.744   -42.050     0.200
    11.769   -81.169     0.200
    12.852   -85.640     0.200
     0.625     1.297     0.200
     6.982   -46.454     0.200
    11.402   -79.328     0.200
     1.188     3.134     0.200
     1.493    -0.537     0.200
     1.599    -1.242     0.200
     1.664    -2.185     0.200
     1.655    -1.716     0.200
     1.689    -2.528     0.200
     1.857    -2.917     0.200
     2.078    -4.425     0.200
     2.126    -4.439     0.200
     2.228    -5.436     0.200
     0.340    15.453     0.200
     0.721     8.399     0.200
     0.735     8.346     0.200
     0.737     8.448     0.200
     0.871     4.986     0.200
     0.930     5.591     0.200
     1.050     3.864     0.200
     1.257     0.593     0.200
     1.257     0.405     0.200
     1.361     0.751     0.200
     1.370     0.304     0.200
     1.999    -5.602     0.200
     6.980   -48.293     0.200
     1.323     0.686     0.200
     1.527    -1.228     0.200
     1.527    -1.064     0.200
     0.167     5.968     0.200
     0.691     0.640     0.200
     0.691     0.290     0.200
     1.122    -2.452     0.200
     1.187    -2.464     0.200
     1.262    -2.682     0.200
     1.275    -2.921     0.200
     1.295    -2.020     0.200
     1.335    -1.834     0.200
     1.520    -4.324     0.200
     8.137   -58.749     0.200
     0.628     1.571     0.200
     1.117    -1.975     0.200
     1.191    -2.497     0.200
     1.188    -2.333     0.200
     1.221    -2.076     0.200
     1.221    -2.623     0.200
     1.257    -2.150     0.200
     1.289    -2.356     0.200
     1.302    -2.122     0.200
     1.343    -2.968     0.200
     1.439    -2.320     0.200
     1.450    -2.569     0.200
     1.795    -5.865     0.200
     2.342   -12.374     0.200
     8.551   -60.649     0.200
     0.496     4.101     0.200
     0.895    -0.468     0.200
     0.959     0.260     0.200
     0.959     0.112     0.200
     0.966    -0.635     0.200
     1.091    -1.633     0.200
     1.182    -2.011     0.200
     1.233    -2.490     0.200
     1.377    -3.040     0.200
     1.389    -3.107     0.200
     1.853    -7.587     0.200
     2.047    -8.266     0.200
     2.055    -8.325     0.200
     2.060    -8.569     0.200
     2.124    -9.142     0.200
     2.206   -10.222     0.200
     2.237    -9.017     0.200
     2.310    -9.843     0.200
     2.571   -11.650     0.200
     2.634   -12.406     0.200
     2.669   -12.920     0.200
     2.743   -13.498     0.200
     2.777   -13.334     0.200
     2.798   -13.524     0.200
     2.971   -17.464     0.200
     3.223   -16.939     0.200
     3.361   -18.847     0.200
     3.457   -19.274     0.200
     3.479   -18.646     0.200
     3.971   -21.333     0.200
     3.992   -21.471     0.200
    12.870   -88.720     0.200
     0.105    11.067     0.200
     0.628     2.892     0.200
     0.798     1.410     0.200
     0.806     1.664     0.200
     0.829     1.481     0.200
     0.905    -0.842     0.200
     0.905    -1.006     0.200
     1.035     0.246     0.200
     1.080    -0.002     0.200
     1.071    -0.205     0.200
     1.169    -0.336     0.200
     1.293    -2.542     0.200
     1.306    -2.720     0.200
     1.375    -3.782     0.200
     1.340    -2.913     0.200
     1.397    -3.764     0.200
     1.400    -3.388     0.200
     1.520    -6.757     0.200
     1.564    -6.067     0.200
     1.769    -6.740     0.200
     1.806    -7.341     0.200
     1.915    -7.597     0.200
     6.669   -49.121     0.200
     0.562     4.125     0.200
     0.615     4.489     0.200
     0.608     3.100     0.200
     0.668     3.532     0.200
     0.762     2.192     0.200
     0.762     2.453     0.200
     0.827     1.005     0.200
     0.881     0.563     0.200
     0.985     1.297     0.200
     1.056    -0.455     0.200
     1.259    -2.382     0.200
     1.274    -2.173     0.200
     1.790    -6.390     0.200
     2.004    -9.402     0.200
     2.056    -7.265     0.200
     7.628   -57.682     0.200
    12.621   -90.742     0.200
     0.337    10.410     0.200
     0.439     8.493     0.200
     0.520     7.542     0.200
     0.590     5.528     0.200
     0.687     4.375     0.200
     0.696     4.743     0.200
     0.748     3.786     0.200
     0.769     3.586     0.200
     0.779     3.409     0.200
     0.825     3.122     0.200
     0.814     3.565     0.200
     0.832     3.461     0.200
     0.836     3.384     0.200
     0.847     3.377     0.200
     1.336    -3.233     0.200
     1.530    -4.425     0.200
     1.585    -3.767     0.200
     1.553    -2.988     0.200
     1.599    -4.105     0.200
     1.700    -5.063     0.200
     1.694    -5.353     0.200
     0.417     6.840     0.200
     0.462     6.282     0.200
     0.572     4.658     0.200
     0.700     2.920     0.200
     0.711     2.687     0.200
     0.744     2.198     0.200
     0.830     2.664     0.200
     0.824     2.602     0.200
     0.873     1.044     0.200
     0.889     1.076     0.200
     1.003     0.488     0.200
     1.025    -0.471     0.200
     1.022     0.384     0.200
     1.041     0.196     0.200
     1.148    -0.928     0.200
     1.508    -3.854     0.200
     1.525    -2.887     0.200
     1.671    -5.511     0.200
     1.699    -6.310     0.200
     2.137    -7.978     0.200
     2.175    -8.636     0.200
     0.672     0.317     0.200
     1.351    -5.726     0.200
     1.573    -5.720     0.200
     1.535    -4.594     0.200
     1.768    -5.963     0.200
     1.778    -5.943     0.200
     1.831    -6.470     0.200
     0.230    15.066     0.200
     0.262    14.479     0.200
     0.283    14.045     0.200
     0.318    13.961     0.200
     0.359    13.175     0.200
     0.412    11.139     0.200
     0.414    11.864     0.200
     0.553     8.915     0.200
     0.573     8.081     0.200
     0.569     8.563     0.200
     0.924     4.051     0.200
     1.024     2.141     0.200
     1.103     0.789     0.200
     1.138     0.225     0.200
     1.150     1.467     0.200
     1.228     0.135     0.200
     1.249     0.143     0.200
     1.334    -0.187     0.200
     1.349    -0.487     0.200
     1.593    -4.239     0.200
     1.980    -6.002     0.200
     2.062    -7.518     0.200
     2.686   -13.070     0.200
     0.398    10.978     0.200
     0.602     7.521     0.200
     0.654     6.839     0.200
     0.810     4.591     0.200
     1.075     1.004     0.200
     1.118     0.636     0.200
     1.125     0.758     0.200
     1.423    -2.667     0.200
     1.622    -3.566     0.200
     1.795    -5.783     0.200
     1.837    -6.288     0.200
     1.867    -6.603     0.200
     2.054    -6.758     0.200
     0.413     3.875     0.200
     0.868     0.359     0.200
     1.360    -3.557     0.200
     1.829    -6.550     0.200
     1.907    -6.366     0.200
     2.140    -9.003     0.200
     2.180    -9.439     0.200
     2.248    -9.289     0.200
     2.267    -8.608     0.200
     2.266    -9.274     0.200
     2.448   -12.008     0.200
     2.583   -11.446     0.200
     8.500   -60.553     0.200
     0.441     6.052     0.200
     0.525     5.588     0.200
     0.624     4.603     0.200
     0.706     4.120     0.200
     0.841    -0.248     0.200
     0.822     2.338     0.200
     0.838     2.091     0.200
     0.848     1.983     0.200
     0.852     1.791     0.200
     0.869     2.093     0.200
     0.875     1.403     0.200
     0.936     0.708     0.200
     0.934     0.664     0.200
     1.115    -1.843     0.200
     1.126    -0.774     0.200
     1.143    -0.455     0.200
     1.297    -4.539     0.200
     1.323    -1.838     0.200
     1.309    -3.408     0.200
     1.449    -1.368     0.200
     1.455    -3.868     0.200
     1.477    -4.550     0.200
     1.647    -6.140     0.200
     1.787    -8.152     0.200
     1.741    -5.748     0.200
     1.824    -6.090     0.200
     1.934    -8.444     0.200
     2.376   -12.533     0.200
     0.362     3.844     0.200
     0.700     0.795     0.200
     0.692     2.534     0.200
     0.692     2.362     0.200
     0.786     0.187     0.200
     0.786     0.437     0.200
     0.802     0.182     0.200
     0.802     0.659     0.200
     0.820    -0.176     0.200
     0.820     0.058     0.200
     0.826     0.870     0.200
     0.835     0.158     0.200
     0.956    -0.513     0.200
     1.081    -1.018     0.200
     1.164    -0.600     0.200
     1.187    -1.956     0.200
     1.340    -2.699     0.200
     1.465    -4.107     0.200
     1.465    -3.091     0.200
     1.581    -4.732     0.200
     2.239    -9.975     0.200
     2.549   -12.295     0.200
     7.802   -55.111     0.200
     0.147     6.349     0.200
     0.549     1.802     0.200
     0.890    -0.793     0.200
     0.931    -0.606     0.200
     1.204    -3.341     0.200
     1.204    -2.991     0.200
     1.226    -2.891     0.200
     1.251    -3.367     0.200
     1.299    -3.163     0.200
     1.320    -3.196     0.200
     1.331    -3.466     0.200
     1.370    -3.274     0.200
     1.427    -2.884     0.200
     1.494    -3.464     0.200
     0.309     6.079     0.200
     0.640     2.603     0.200
     0.749     2.918     0.200
     0.749     1.976     0.200
     0.744     1.264     0.200
     0.778     0.993     0.200
     0.778     1.126     0.200
     0.772     0.371     0.200
     0.772     0.820     0.200
     0.802     0.943     0.200
     0.851     1.770     0.200
     0.881     0.997     0.200
     0.874     0.891     0.200
     0.907     0.039     0.200
     1.061    -0.971     0.200
     1.205    -1.136     0.200
     1.210    -1.600     0.200
     1.229    -1.842     0.200
     1.257    -2.830     0.200
     1.283    -2.522     0.200
     1.410    -3.423     0.200
     1.570    -5.415     0.200
     2.879   -15.539     0.200
     7.834   -56.507     0.200
    12.675   -89.806     0.200
     0.610     4.577     0.200
     0.610     3.964     0.200
     0.641     5.129     0.200
     0.772     3.263     0.200
     0.720     4.407     0.200
     0.745     2.339     0.200
     0.810     4.144     0.200
     0.795     2.997     0.200
     0.829     2.313     0.200
     0.865     1.892     0.200
     0.913     1.003     0.200
     0.940     1.178     0.200
     0.943     1.180     0.200
     1.043     0.944     0.200
     1.087    -0.129     0.200
     1.215    -1.311     0.200
     1.232    -0.907     0.200
     1.525    -3.548     0.200
     1.533    -3.595     0.200
     1.590    -4.132     0.200
     1.671    -4.654     0.200
     1.724    -5.314     0.200
     1.876    -7.273     0.200
     1.862    -7.010     0.200
     1.941    -7.435     0.200
     7.387   -54.119     0.200
    12.359   -87.660     0.200
     0.303    10.358     0.200
     0.370     9.618     0.200
     0.492     7.375     0.200
     0.571     6.328     0.200
     0.655     4.783     0.200
     0.653     5.505     0.200
     0.715     3.763     0.200
     0.736     4.364     0.200
     0.751     4.686     0.200
     0.816     2.527     0.200
     0.845     2.603     0.200
     0.893     1.995     0.200
     0.934     2.290     0.200
     0.940     1.487     0.200
     1.015     0.364     0.200
     1.065     1.070     0.200
     1.051     1.393     0.200
     1.169    -0.214     0.200
     1.385    -2.295     0.200
     1.560    -4.267     0.200
     1.663    -4.354     0.200
     1.680    -4.786     0.200
     1.754    -5.248     0.200
     0.423     6.563     0.200
     0.491     6.280     0.200
     0.540     5.771     0.200
     0.644     4.642     0.200
     0.726     4.139     0.200
     0.796     2.852     0.200
     0.812     2.965     0.200
     0.856     1.197     0.200
     0.823     2.852     0.200
     0.831     2.715     0.200
     0.835     2.619     0.200
     0.845     2.947     0.200
     0.965     0.810     0.200
     1.052     0.243     0.200
     1.148    -1.323     0.200
     1.115     0.098     0.200
     1.323    -3.668     0.200
     1.294    -1.675     0.200
     1.416    -3.761     0.200
     1.426    -2.860     0.200
     1.449    -3.376     0.200
     1.755    -5.167     0.200
     1.747    -5.290     0.200
     1.782    -5.773     0.200
     1.854    -6.273     0.200
     1.968    -7.455     0.200
     2.041    -9.842     0.200
     2.036    -7.690     0.200
     2.091    -8.698     0.200
     2.725   -11.850     0.200
     2.836   -13.054     0.200
     0.069    23.712     0.200
     0.112    22.705     0.200
     0.168    20.379     0.200
     0.163    20.961     0.200
     0.172    20.404     0.200
     0.241    19.115     0.200
     0.267    17.766     0.200
     0.285    18.296     0.200
     0.345    16.940     0.200
     0.361    15.500     0.200
     0.361    15.766     0.200
     0.798     7.079     0.200
     0.877     6.265     0.200
     0.952     5.512     0.200
     0.951     5.848     0.200
     1.001     5.336     0.200
     1.102     3.626     0.200
     1.154     2.682     0.200
     1.419    -0.846     0.200
     1.436    -1.159     0.200
     1.445    -0.404     0.200
     1.570    -2.219     0.200
     1.666    -1.744     0.200
     1.696    -2.483     0.200
     1.801    -4.612     0.200
     1.966    -5.379     0.200
     1.968    -5.194     0.200
     2.439    -8.510     0.200
     2.622   -13.399     0.200
     0.460     7.540     0.200
     0.470     8.546     0.200
     0.582     6.289     0.200
     0.681     5.016     0.200
     0.809     1.592     0.200
     0.763     4.305     0.200
     0.824     3.119     0.200
     0.833     3.384     0.200
     0.849     3.179     0.200
     0.860     2.973     0.200
     0.863     3.069     0.200
     0.932     1.761     0.200
     1.148     0.178     0.200
     0.557     2.903     0.200
     0.767     0.510     0.200
     0.820     0.352     0.200
     0.828     0.595     0.200
     0.909    -0.283     0.200
     0.909    -0.045     0.200
     0.932    -0.483     0.200
     0.932    -0.370     0.200
     0.951    -0.774     0.200
     0.935    -0.348     0.200
     0.995    -0.928     0.200
     1.111     0.081     0.200
     1.138    -1.691     0.200
     1.180    -1.756     0.200
     1.239    -1.911     0.200
     1.338    -2.020     0.200
     1.530    -3.964     0.200
     8.106   -59.184     0.200
     0.155    17.959     0.200
     0.293    14.547     0.200
     0.361    13.181     0.200
     0.465    10.523     0.200
     0.494     9.910     0.200
     0.628     7.733     0.200
     0.702     6.562     0.200
     0.770     6.127     0.200
     0.767     6.375     0.200
     0.784     6.258     0.200
     0.817     5.853     0.200
     0.874     4.563     0.200
     0.881     4.382     0.200
     0.964     2.600     0.200
     1.165     0.619     0.200
     1.351    -1.408     0.200
     1.483    -3.421     0.200
     1.509    -2.363     0.200
     1.564    -2.752     0.200
     1.584    -3.047     0.200
     1.611    -2.261     0.200
     7.029   -50.447     0.200
     0.293    28.910     0.200
     0.423    25.162     0.200
     0.471    23.307     0.200
     0.514    22.637     0.200
     0.652    20.107     0.200
     0.706    18.484     0.200
     0.712    18.709     0.200
     0.749    17.913     0.200
     0.774    17.620     0.200
     0.764    16.839     0.200
     0.836    16.085     0.200
     1.231     9.689     0.200
     1.274     8.687     0.200
     1.316     8.183     0.200
     1.483     5.659     0.200
     1.534     4.957     0.200
     1.815     2.038     0.200
     1.806     0.142     0.200
     1.945     0.147     0.200
     1.949     0.460     0.200
     2.009    -0.474     0.200
     2.098    -2.688     0.200
     7.660   -53.083     0.200
     0.607     3.715     0.200
     0.696     3.349     0.200
     0.706     2.953     0.200
     0.843     2.268     0.200
     0.959     0.195     0.200
     1.092    -0.441     0.200
     1.177    -0.863     0.200
     1.282    -2.590     0.200
     1.311    -2.566     0.200
     1.336    -3.032     0.200
     1.463    -3.036     0.200
     1.618    -5.116     0.200
     1.637    -4.309     0.200
     2.139    -8.166     0.200
     2.253    -8.742     0.200
     1.431     0.622     0.200
     1.449     0.166     0.200
     1.449     0.885     0.200
     1.448     0.002     0.200
     1.448     0.463     0.200
     1.466    -0.106     0.200
     1.466     0.386     0.200
     1.479    -0.226     0.200
     1.618    -1.607     0.200
     1.618    -1.248     0.200
     1.661    -1.616     0.200
     1.661    -1.308     0.200
     1.774    -2.145     0.200
     2.011    -3.884     0.200
     2.011    -3.075     0.200
     2.107    -4.346     0.200
     0.384     6.180     0.200
     0.384     6.668     0.200
     1.096    -1.643     0.200
     1.151    -1.986     0.200
     1.159    -0.759     0.200
     1.169    -0.878     0.200
     1.184    -2.062     0.200
     1.223    -1.650     0.200
     1.371    -3.181     0.200
     1.654    -4.806     0.200
     1.689    -5.388     0.200
     1.702    -5.242     0.200
     1.756    -5.527     0.200
     1.772    -6.103     0.200
     1.783    -5.825     0.200
     1.843    -6.361     0.200
     2.013    -8.334     0.200
     2.102    -9.628     0.200
     2.232    -9.274     0.200
     2.357   -11.253     0.200
     2.404   -12.048     0.200
     2.481   -12.422     0.200
     2.496   -13.700     0.200
     2.493   -12.380     0.200
     2.504   -12.673     0.200
     2.502   -13.069     0.200
     2.783   -14.788     0.200
     2.783   -14.159     0.200
     2.915   -14.396     0.200
     3.024   -16.060     0.200
     3.026   -14.656     0.200
     3.658   -21.245     0.200
     3.733   -22.371     0.200
     3.810   -22.961     0.200
     7.823   -58.657     0.200
    12.303   -85.873     0.200
     0.766     1.471     0.200
     1.271    -2.245     0.200
     1.450    -3.749     0.200
     1.574    -4.645     0.200
     1.884    -7.379     0.200
     1.887    -6.679     0.200
     1.989    -6.527     0.200
     2.009    -6.804     0.200
     2.006    -6.836     0.200
     2.050    -6.886     0.200
     2.244    -9.934     0.200
     2.335   -11.833     0.200
     2.341    -9.988     0.200
     2.364   -11.153     0.200
     2.648   -12.917     0.200
     2.689   -14.013     0.200
     2.716   -14.083     0.200
     2.749   -13.429     0.200
     2.798   -14.768     0.200
     3.085   -18.708     0.200
     0.697     3.706     0.200
     0.736     3.471     0.200
     0.769     3.226     0.200
     0.880     1.885     0.200
     0.925     1.439     0.200
     0.935     1.750     0.200
     0.984     0.967     0.200
     1.029     2.160     0.200
     1.140    -0.920     0.200
     1.120    -0.417     0.200
     1.138     0.801     0.200
     2.389   -10.648     0.200
     2.415   -11.669     0.200
     2.631   -13.461     0.200
     2.682   -13.023     0.200
     2.738   -13.893     0.200
     2.820   -15.207     0.200
     3.004   -16.129     0.200
     1.439     1.559     0.200
     1.428     0.676     0.200
     1.428     1.637     0.200
     1.475    -0.649     0.200
     1.475    -1.153     0.200
     2.016    -4.097     0.200
     2.473    -5.747     0.200
     2.520    -7.746     0.200
     2.609    -8.784     0.200
     3.311   -13.243     0.200
     3.338   -11.878     0.200
     3.377   -12.717     0.200
     4.087   -17.637     0.200
     1.000     0.278     0.200
     0.994     0.245     0.200
     1.163    -0.669     0.200
     1.194    -0.779     0.200
     1.229    -0.633     0.200
     1.270    -0.055     0.200
     2.650    -9.419     0.200
     2.713   -11.990     0.200
     2.754   -10.334     0.200
     2.778   -10.770     0.200
     3.050   -16.409     0.200
     0.207    11.742     0.200
     0.429     7.549     0.200
     0.489     6.805     0.200
     0.499     6.968     0.200
     0.634     4.505     0.200
     0.740     4.658     0.200
     0.918     1.571     0.200
     0.916     2.110     0.200
     0.942     1.700     0.200
     0.972     1.371     0.200
     1.062    -0.377     0.200
     1.094     0.089     0.200
     1.257    -2.197     0.200
     1.629    -6.180     0.200
     1.684    -4.295     0.200
     1.670    -5.996     0.200
     1.741    -5.686     0.200
     2.124    -9.079     0.200
     2.142    -9.237     0.200
     2.216    -7.781     0.200
     2.206    -9.677     0.200
     2.334   -10.200     0.200
     2.346    -9.951     0.200
     2.775   -16.289     0.200
     1.157     2.720     0.200
     1.407     1.200     0.200
     1.411     0.531     0.200
     1.417     0.657     0.200
     1.445     1.145     0.200
     1.445     0.238     0.200
     2.487    -6.239     0.200
     0.345    10.739     0.200
     0.389     9.451     0.200
     0.401     9.095     0.200
     0.455     8.247     0.200
     0.526     7.250     0.200
     0.543     7.717     0.200
     0.681     4.797     0.200
     0.709     4.849     0.200
     0.738     4.533     0.200
     0.862     2.791     0.200
     0.907     2.557     0.200
     0.975     1.164     0.200
     1.034     0.137     0.200
     1.297    -1.850     0.200
     1.297    -1.709     0.200
     1.388    -1.803     0.200
     1.394    -3.062     0.200
     1.640    -4.871     0.200
     1.658    -5.211     0.200
     1.795    -4.837     0.200
     1.810    -4.591     0.200
     1.813    -4.042     0.200
     1.922    -6.921     0.200
     2.035    -7.732     0.200
     2.120    -8.488     0.200
     2.385   -10.809     0.200
     2.438   -10.284     0.200
     2.445   -11.031     0.200
     2.502   -10.632     0.200
     2.763   -14.156     0.200
     2.870   -14.755     0.200
     2.951   -16.873     0.200
     8.056   -59.952     0.200
    13.208   -96.915     0.200
     0.392     5.259     0.200
     0.715     1.419     0.200
     1.161    -2.369     0.200
     1.217    -2.300     0.200
     1.231    -1.528     0.200
     1.247    -2.505     0.200
     1.434    -3.614     0.200
     1.697    -5.405     0.200
     1.735    -5.737     0.200
     1.743    -6.027     0.200
     1.890    -7.850     0.200
     2.064    -8.834     0.200
     2.174   -10.951     0.200
     2.278    -9.765     0.200
     2.419   -10.004     0.200
     2.535   -14.124     0.200
     2.538   -13.525     0.200
     2.579   -10.849     0.200
     2.805   -14.453     0.200
     2.946   -14.913     0.200
     3.082   -16.851     0.200
     3.550   -20.360     0.200
     3.710   -21.121     0.200
     7.870   -57.525     0.200
     0.863     3.564     0.200
     0.886     2.996     0.200
     0.956     2.414     0.200
     0.975     2.185     0.200
     1.006     2.388     0.200
     1.033     2.411     0.200
     1.198     1.639     0.200
     1.198     1.859     0.200
     2.265    -5.860     0.200
     2.523    -7.941     0.200
     0.290    13.198     0.200
     0.370    11.455     0.200
     0.418    10.732     0.200
     0.451     9.358     0.200
     0.532     8.044     0.200
     0.613     7.031     0.200
     0.645     6.518     0.200
     0.666     6.033     0.200
     0.689     5.774     0.200
     0.741     5.370     0.200
     0.834     4.789     0.200
     0.854     4.317     0.200
     0.852     4.404     0.200
     0.861     4.607     0.200
     0.862     4.379     0.200
     0.883     3.958     0.200
     1.083    -0.549     0.200
     1.440    -3.268     0.200
     1.463    -2.075     0.200
     1.482    -2.528     0.200
     1.486    -1.877     0.200
     1.557    -2.867     0.200
     1.617    -3.573     0.200
     1.646    -2.894     0.200
     1.686    -3.586     0.200
     2.010    -7.278     0.200
     2.027    -7.608     0.200
     2.085    -7.479     0.200
     2.128    -8.218     0.200
     2.140    -8.127     0.200
     2.131    -7.836     0.200
     2.276    -9.350     0.200
     2.802   -13.264     0.200
     2.804   -13.057     0.200
     2.811   -12.180     0.200
     2.874   -12.690     0.200
     2.920   -12.513     0.200
     3.147   -15.362     0.200
     3.332   -18.537     0.200
     7.093   -53.847     0.200
    12.526   -90.569     0.200
     1.148     1.651     0.200
     1.421     0.562     0.200
     1.452     0.169     0.200
     1.648    -1.995     0.200
     2.610    -6.863     0.200
     0.380     7.382     0.200
     0.666     4.324     0.200
     0.742     3.270     0.200
     0.758     3.141     0.200
     0.769     2.897     0.200
     0.900     1.142     0.200
     0.899     1.727     0.200
     1.003     0.783     0.200
     1.059     0.005     0.200
     1.237    -1.549     0.200
     1.281    -3.008     0.200
     1.370    -2.540     0.200
     1.393    -3.039     0.200
     1.528    -2.989     0.200
     1.600    -5.529     0.200
     1.884    -6.804     0.200
     1.895    -6.732     0.200
     1.911    -6.703     0.200
     1.980    -7.254     0.200
     2.016    -7.074     0.200
     2.098   -10.211     0.200
     1.136     2.407     0.200
     1.164     2.723     0.200
     1.398     0.395     0.200
     1.404     0.506     0.200
     1.599    -1.319     0.200
     1.407    -0.044     0.200
     1.415     0.606     0.200
     1.421     1.002     0.200
     1.450     1.768     0.200
     1.130     1.713     0.200
     1.449    -0.014     0.200
     1.593    -1.020     0.200
     2.577    -7.727     0.200
     0.583     5.416     0.200
     0.639     4.147     0.200
     0.684     2.527     0.200
     0.684     3.144     0.200
     0.688     2.952     0.200
     0.679     3.053     0.200
     0.707     3.152     0.200
     0.743     1.888     0.200
     0.777     2.206     0.200
     0.810     2.655     0.200
     0.843     1.899     0.200
     0.870     1.046     0.200
     1.223    -0.896     0.200
     1.241    -0.862     0.200
     1.251    -0.598     0.200
     1.446    -2.989     0.200
     1.505    -3.642     0.200
     1.504    -5.056     0.200
     1.554    -4.764     0.200
     1.584    -3.924     0.200
     1.719    -5.843     0.200
     1.792    -6.391     0.200
     1.870    -6.899     0.200
     1.889    -7.184     0.200
     1.906    -7.811     0.200
     1.933    -6.882     0.200
     2.104    -9.085     0.200
     2.146    -9.104     0.200
     2.199   -10.767     0.200
     2.233   -10.665     0.200
     2.427   -10.798     0.200
     2.730   -13.959     0.200
     7.423   -50.880     0.200
     1.141     2.090     0.200
     1.386     0.688     0.200
     1.448    -0.069     0.200
     1.579    -0.982     0.200
     3.250   -10.469     0.200
     0.181    18.227     0.200
     0.264    15.774     0.200
     0.278    16.006     0.200
     0.279    15.843     0.200
     0.363    14.709     0.200
     0.551    10.569     0.200
     0.950     4.503     0.200
     0.975     4.440     0.200
     1.051     3.387     0.200
     1.103     2.880     0.200
     1.200     1.929     0.200
     1.149     1.387     0.200
     1.298     0.452     0.200
     1.273     1.056     0.200
     1.356     0.798     0.200
     1.376     0.919     0.200
     1.379     0.010     0.200
     1.421    -1.227     0.200
     1.749    -3.958     0.200
     1.974    -4.755     0.200
     2.178    -6.332     0.200
     2.589   -12.451     0.200
     3.091   -15.242     0.200
     3.154   -16.923     0.200
     3.258   -17.741     0.200
     7.617   -53.794     0.200
    12.930   -89.668     0.200
    16.216  -116.611     0.200
     0.113    20.678     0.200
     0.205    18.178     0.200
     0.203    18.003     0.200
     0.277    16.469     0.200
     0.303    15.488     0.200
     0.483    12.129     0.200
     0.921     4.956     0.200
     0.959     4.377     0.200
     1.006     3.626     0.200
     1.042     3.341     0.200
     1.187     1.936     0.200
     1.239     0.494     0.200
     1.236     0.895     0.200
     1.330     0.573     0.200
     1.334     0.568     0.200
     1.354     0.489     0.200
     1.367    -0.005     0.200
     1.374     0.080     0.200
     1.681    -2.831     0.200
     1.692    -2.826     0.200
     1.882    -4.751     0.200
     1.990    -5.875     0.200
     2.202    -7.295     0.200
     2.207    -7.151     0.200
     0.389    10.572     0.200
     0.412    10.407     0.200
     0.433     9.774     0.200
     0.482     9.210     0.200
     0.481     9.123     0.200
     0.568     8.160     0.200
     0.753     5.296     0.200
     0.777     4.980     0.200
     0.906     2.848     0.200
     0.931     3.005     0.200
     1.018     1.623     0.200
     1.081     1.189     0.200
     1.256    -1.096     0.200
     1.256    -2.045     0.200
     1.386    -1.580     0.200
     1.609    -3.997     0.200
     1.680    -5.227     0.200
     1.684    -4.485     0.200
     1.797    -4.264     0.200
     1.817    -4.033     0.200
     1.950    -7.008     0.200
     2.083    -7.866     0.200
     2.129    -7.554     0.200
     2.145    -8.638     0.200
     2.413   -11.173     0.200
     2.442    -9.439     0.200
     2.590   -12.111     0.200
     8.058   -55.057     0.200
    13.172   -93.970     0.200
     0.633     6.004     0.200
     0.681     5.220     0.200
     0.693     5.499     0.200
     0.694     5.411     0.200
     0.788     4.052     0.200
     0.809     3.783     0.200
     0.964     2.497     0.200
     1.043     0.999     0.200
     1.200    -0.140     0.200
     1.309    -1.894     0.200
     1.631    -3.496     0.200
     1.782    -5.517     0.200
     1.843    -6.458     0.200
     1.853    -4.820     0.200
     1.919    -6.493     0.200
     1.936    -7.243     0.200
     2.047    -6.954     0.200
     2.070    -6.859     0.200
     2.261    -9.268     0.200
     0.215    14.843     0.200
     0.233    14.511     0.200
     0.247    14.176     0.200
     0.299    13.024     0.200
     0.334    12.415     0.200
     0.713     5.620     0.200
     0.751     5.088     0.200
     0.769     5.374     0.200
     0.856     4.163     0.200
     0.986     3.126     0.200
     0.997     2.432     0.200
     1.259     0.800     0.200
     1.307    -1.346     0.200
     1.307    -0.630     0.200
     1.412    -2.485     0.200
     1.501    -3.636     0.200
     1.498    -2.507     0.200
     1.558    -3.322     0.200
     1.660    -3.270     0.200
     1.674    -3.252     0.200
     1.680    -3.981     0.200
     1.682    -3.295     0.200
     1.682    -3.449     0.200
     1.931    -6.118     0.200
     1.963    -7.109     0.200
     1.967    -5.941     0.200
     1.988    -6.371     0.200
     1.991    -7.917     0.200
     2.298    -9.052     0.200
     2.304    -9.586     0.200
     2.330    -9.740     0.200
     2.455   -12.292     0.200
     2.489    -9.847     0.200
     2.779   -11.710     0.200
     2.791   -11.979     0.200
     2.847   -15.090     0.200
     2.825   -12.750     0.200
     2.849   -15.279     0.200
     2.897   -16.149     0.200
     2.935   -13.937     0.200
     2.953   -13.636     0.200
     2.954   -14.789     0.200
     2.999   -14.399     0.200
     3.031   -15.645     0.200
     3.088   -14.548     0.200
     3.596   -20.608     0.200
     3.606   -19.489     0.200
     3.621   -18.964     0.200
     3.671   -19.125     0.200
     3.728   -19.006     0.200
     3.954   -21.847     0.200
     3.954   -22.509     0.200
     4.029   -23.567     0.200
     7.918   -59.235     0.200
     0.593     2.221     0.200
     1.112    -2.646     0.200
     1.175    -2.364     0.200
     1.190    -2.396     0.200
     1.204    -2.699     0.200
     1.233    -2.858     0.200
     1.252    -2.226     0.200
     1.258    -2.661     0.200
     1.332    -1.806     0.200
     1.329    -2.721     0.200
     1.540    -3.563     0.200
     3.068   -15.371     0.200
     0.962     2.428     0.200
     1.158     2.118     0.200
     1.394     0.425     0.200
     1.394     0.542     0.200
     1.403     0.649     0.200
     1.403     0.891     0.200
     1.430     0.679     0.200
     0.258     7.805     0.200
     1.093    -1.083     0.200
     1.397    -3.453     0.200
     1.411    -3.663     0.200
     1.514    -4.303     0.200
     1.529    -5.037     0.200
     1.666    -5.813     0.200
     1.968    -7.870     0.200
     2.004    -7.463     0.200
     2.016    -7.752     0.200
     2.199    -9.345     0.200
     2.329   -11.292     0.200
     2.421   -12.739     0.200
     2.563   -11.524     0.200
     2.616   -12.242     0.200
     2.972   -15.431     0.200
     3.684   -19.926     0.200
     3.760   -19.885     0.200
     0.956    -0.434     0.200
     1.048     0.184     0.200
     1.134    -0.610     0.200
     1.048     0.267     0.200
     1.048    -0.201     0.200
     8.329   -59.494     0.200
     0.151    17.919     0.200
     0.223    15.879     0.200
     0.323    13.559     0.200
     0.402    11.959     0.200
     0.667     7.569     0.200
     0.679     7.865     0.200
     0.790     4.982     0.200
     0.793     5.806     0.200
     0.930     3.964     0.200
     1.053     1.471     0.200
     1.065     2.122     0.200
     1.255    -0.068     0.200
     1.255    -0.326     0.200
     1.421    -1.606     0.200
     1.456    -2.235     0.200
     1.464    -1.892     0.200
     1.493    -2.156     0.200
     1.555    -2.063     0.200
     1.569    -2.142     0.200
     1.575    -1.872     0.200
     1.605    -2.378     0.200
     1.881    -5.584     0.200
     1.931    -6.422     0.200
     2.602   -12.897     0.200
     4.056   -25.772     0.200
     7.814   -55.062     0.200
    13.100   -90.143     0.200
     0.594     2.790     0.200
     0.707     2.491     0.200
     0.712     2.206     0.200
     0.976    -0.005     0.200
     1.009    -0.558     0.200
     1.024    -0.270     0.200
     1.164    -0.950     0.200
     1.272    -1.840     0.200
     1.441    -2.372     0.200
     1.752    -4.773     0.200
     1.774    -7.292     0.200
     1.852    -6.956     0.200
     2.225   -10.477     0.200
     2.311   -10.396     0.200
     2.404   -10.151     0.200
     2.418   -10.479     0.200
     2.469   -11.467     0.200
     3.085   -16.665     0.200
     0.328     5.467     0.200
     1.112    -1.530     0.200
     1.569    -4.559     0.200
     1.581    -5.227     0.200
     1.613    -5.495     0.200
     1.630    -5.144     0.200
     1.855    -6.582     0.200
     1.965    -6.720     0.200
     2.161   -10.014     0.200
     2.197    -8.727     0.200
     2.381   -12.840     0.200
     2.362   -11.131     0.200
     2.352   -10.895     0.200
     2.453   -12.698     0.200
     2.552   -11.542     0.200
     2.596   -12.315     0.200
     0.743    -0.324     0.200
     1.444    -4.873     0.200
     1.679    -5.612     0.200
     1.677    -4.956     0.200
     1.692    -5.025     0.200
     1.674    -5.229     0.200
     1.712    -5.383     0.200
     1.719    -5.088     0.200
     3.097   -14.994     0.200
     0.369    21.469     0.200
     0.357    22.223     0.200
     0.428    19.792     0.200
     0.463    19.882     0.200
     0.857    10.760     0.200
     0.914    10.254     0.200
     1.016     8.906     0.200
     1.193     5.521     0.200
     1.225     6.125     0.200
     1.321     4.324     0.200
     1.483     2.294     0.200
     1.524     1.899     0.200
     1.591     0.635     0.200
     1.591     0.362     0.200
     1.715     0.979     0.200
     2.061    -5.401     0.200
     2.249    -4.062     0.200
     2.550   -10.561     0.200
     7.401   -50.306     0.200
     0.293    12.707     0.200
     0.238    14.398     0.200
     0.434     9.797     0.200
     0.505     8.887     0.200
     0.605     6.730     0.200
     0.618     6.069     0.200
     0.676     6.497     0.200
     0.676     6.291     0.200
     0.685     6.383     0.200
     0.704     6.171     0.200
     0.768     4.226     0.200
     0.758     5.209     0.200
     0.838     3.409     0.200
     0.909     3.132     0.200
     0.993     1.044     0.200
     1.143    -0.121     0.200
     1.346    -1.738     0.200
     1.508    -3.751     0.200
     1.845    -6.311     0.200
     0.431     4.051     0.200
     0.431     3.500     0.200
     0.406     3.962     0.200
     1.025    -1.158     0.200
     1.093    -1.419     0.200
     1.204    -2.195     0.200
     1.215    -1.177     0.200
     1.227    -1.395     0.200
     1.236    -1.495     0.200
     1.292    -2.505     0.200
     1.313    -2.579     0.200
     1.334    -2.767     0.200
     1.369    -2.468     0.200
     1.524    -2.472     0.200
     1.634    -3.549     0.200
     1.803    -7.021     0.200
     7.114   -48.050     0.200
    11.828   -83.438     0.200
     1.825    -5.467     0.200
     1.825    -5.176     0.200
     2.358    -7.323     0.200
     3.236   -15.701     0.200
     3.308   -14.668     0.200
     3.337   -16.298     0.200
     3.397   -15.723     0.200
     3.984   -21.682     0.200
     4.605   -25.266     0.200
     4.609   -25.082     0.200
     4.803   -27.588     0.200
     5.169   -29.703     0.200
     9.344   -63.952     0.200
     0.419     3.504     0.200
     1.024    -1.451     0.200
     1.097    -0.930     0.200
     1.112    -1.844     0.200
     1.117    -1.601     0.200
     1.364    -2.593     0.200
     1.711    -4.421     0.200
     1.888    -7.773     0.200
     2.277    -9.893     0.200
     2.442   -12.394     0.200
     3.251   -16.874     0.200
     3.337   -17.896     0.200
     0.991    -0.238     0.200
     0.991    -0.357     0.200
     1.732    -4.804     0.200
     1.826    -5.502     0.200
     1.877    -6.269     0.200
     2.049    -6.190     0.200
     2.934   -13.484     0.200
    12.358   -80.920     0.200
    14.492   -99.071     0.200
     0.742     1.290     0.200
     0.829     1.115     0.200
     1.243    -2.562     0.200
     1.244    -2.434     0.200
     1.286    -2.738     0.200
     1.295    -2.280     0.200
     1.308    -3.079     0.200
     1.366    -2.458     0.200
     1.406    -3.911     0.200
     1.439    -3.782     0.200
     1.458    -4.188     0.200
     1.531    -4.160     0.200
     1.537    -4.903     0.200
     1.613    -4.960     0.200
     1.695    -5.176     0.200
     2.080    -7.764     0.200
     2.098    -8.459     0.200
     2.109    -7.740     0.200
     2.389   -11.297     0.200
     0.209     6.006     0.200
     0.777     1.433     0.200
     0.777     1.160     0.200
     0.766     1.780     0.200
     1.272    -3.286     0.200
     1.272    -3.017     0.200
     1.294    -3.174     0.200
     1.294    -2.924     0.200
     1.316    -3.484     0.200
     1.352    -2.165     0.200
     1.355    -4.361     0.200
     1.381    -2.704     0.200
     1.503    -5.219     0.200
     1.558    -4.916     0.200
     8.209   -56.294     0.200
     0.046    31.348     0.200
     0.262    26.083     0.200
     0.325    24.195     0.200
     0.333    23.278     0.200
     0.374    23.053     0.200
     0.441    21.277     0.200
     0.549    18.410     0.200
     0.698    15.848     0.200
     0.710    14.814     0.200
     0.885    11.663     0.200
     1.044     9.683     0.200
     1.053     9.675     0.200
     1.055     9.386     0.200
     1.059     9.708     0.200
     1.071     9.180     0.200
     1.088     9.464     0.200
     1.104     8.839     0.200
     1.170     7.155     0.200
     1.193     7.498     0.200
     1.218     7.328     0.200
     1.273     6.165     0.200
     1.340     5.875     0.200
     1.385     4.526     0.200
     1.536     3.470     0.200
     1.553     2.106     0.200
     1.586     1.166     0.200
     1.586     0.551     0.200
     1.586     0.672     0.200
     1.620     1.281     0.200
     1.683     1.356     0.200
     1.686     0.855     0.200
     1.999    -2.113     0.200
     7.220   -51.180     0.200
     0.301    12.524     0.200
     0.366    11.068     0.200
     0.586     6.822     0.200
     0.966     0.984     0.200
     0.966     1.859     0.200
     0.968     2.130     0.200
     1.129     0.930     0.200
     1.160    -1.012     0.200
     1.138     1.266     0.200
     1.247    -1.390     0.200
     1.509    -3.099     0.200
     1.549    -2.854     0.200
     1.667    -4.384     0.200
     1.733    -6.613     0.200
     1.884    -4.968     0.200
     1.916    -6.870     0.200
     2.238   -10.595     0.200
     7.365   -53.543     0.200
     1.371    -2.758     0.200
     8.882   -63.166     0.200
     0.080    28.524     0.200
     0.265    24.040     0.200
     0.301    22.744     0.200
     0.327    22.421     0.200
     0.347    21.912     0.200
     0.776    11.972     0.200
     1.059     7.790     0.200
     1.105     7.336     0.200
     1.144     7.104     0.200
     1.147     6.982     0.200
     1.125     7.144     0.200
     1.151     7.238     0.200
     1.163     7.246     0.200
     1.180     6.293     0.200
     1.239     5.230     0.200
     1.433     3.931     0.200
     1.443     2.620     0.200
     1.598    -0.412     0.200
     1.598    -0.206     0.200
     1.713     0.426     0.200
     1.776    -0.754     0.200
     7.311   -52.891     0.200
     1.052     2.154     0.200
     1.258     1.136     0.200
     1.419     2.143     0.200
     1.437    -3.270     0.200
     8.745   -58.528     0.200
     0.499     4.243     0.200
     0.831     1.155     0.200
     1.111    -2.511     0.200
     1.111    -1.441     0.200
     1.141    -1.815     0.200
     1.185    -2.375     0.200
     1.191    -1.920     0.200
     1.204    -2.365     0.200
     1.255    -2.323     0.200
     1.312    -2.747     0.200
     1.324    -3.093     0.200
     1.351    -2.856     0.200
     1.432    -3.251     0.200
     1.561    -4.444     0.200
     1.662    -5.735     0.200
     1.703    -5.482     0.200
     8.716   -61.201     0.200
     0.452     9.868     0.200
     0.573     7.545     0.200
     0.575     7.627     0.200
     0.654     6.397     0.200
     0.692     6.221     0.200
     0.709     5.764     0.200
     0.717     5.616     0.200
     0.721     5.810     0.200
     0.728     5.880     0.200
     0.732     5.641     0.200
     0.737     4.861     0.200
     0.736     5.566     0.200
     0.796     3.868     0.200
     0.924     2.405     0.200
     0.938     2.005     0.200
     0.987     0.825     0.200
     0.987     1.081     0.200
     1.019     1.544     0.200
     1.126     0.302     0.200
     1.173    -0.728     0.200
     1.335    -1.174     0.200
     1.392    -0.950     0.200
     1.398    -2.383     0.200
     1.432    -2.349     0.200
     1.502    -3.780     0.200
     1.628    -3.938     0.200
     1.747    -6.328     0.200
     1.742    -4.854     0.200
     1.758    -5.057     0.200
     1.799    -6.783     0.200
     2.003    -7.195     0.200
     2.013    -7.006     0.200
     2.123   -10.046     0.200
     6.899   -49.343     0.200
    12.243   -86.597     0.200
     0.171    25.091     0.200
     0.207    24.787     0.200
     0.221    23.617     0.200
     0.240    23.760     0.200
     0.224    23.944     0.200
     0.236    23.580     0.200
     0.347    20.854     0.200
     0.899     8.891     0.200
     0.960     8.535     0.200
     0.966     8.000     0.200
     1.037     7.162     0.200
     1.037     7.297     0.200
     1.190     6.978     0.200
     1.234     5.342     0.200
     1.238     5.580     0.200
     1.248     5.481     0.200
     1.362     2.873     0.200
     1.454     1.971     0.200
     1.543    -0.406     0.200
     1.587     0.317     0.200
     1.757    -1.860     0.200
     1.881    -2.512     0.200
     2.013    -5.136     0.200
     2.157    -4.686     0.200
     2.221    -5.766     0.200
     2.245    -5.210     0.200
     2.281    -6.450     0.200
     2.349    -6.489     0.200
     2.388    -8.165     0.200
     2.543   -10.946     0.200
     3.227   -17.016     0.200
     3.290   -16.127     0.200
     1.111     3.355     0.200
     1.155     2.821     0.200
     1.162     2.497     0.200
     1.173     3.408     0.200
     1.224     3.357     0.200
     1.282     2.020     0.200
     1.316     3.052     0.200
     1.302     2.178     0.200
     1.325     2.398     0.200
     1.337     2.087     0.200
     1.401     1.325     0.200
     1.515     1.596     0.200
     0.098    21.910     0.200
     0.111    21.426     0.200
     0.151    20.831     0.200
     0.147    21.023     0.200
     0.178    20.233     0.200
     0.219    18.662     0.200
     0.327    16.037     0.200
     0.449    13.148     0.200
     0.645    10.179     0.200
     0.709     8.369     0.200
     0.826     6.806     0.200
     0.972     5.123     0.200
     1.255     0.908     0.200
     1.268     0.920     0.200
     1.396    -0.419     0.200
     1.430    -0.689     0.200
     1.516    -0.785     0.200
     1.533    -1.187     0.200
     1.548    -1.636     0.200
     1.664    -3.731     0.200
     1.731    -3.378     0.200
     1.834    -3.816     0.200
     1.983    -6.432     0.200
     2.007    -5.601     0.200
     1.711    -4.986     0.200
     1.755    -5.410     0.200
     8.448   -58.931     0.200
     0.711     0.905     0.200
     0.960    -0.370     0.200
     1.902    -5.461     0.200
     1.958    -6.253     0.200
     2.017    -6.767     0.200
     2.171    -7.100     0.200
     2.236    -9.395     0.200
     2.497    -8.484     0.200
     2.527    -9.606     0.200
     2.536    -9.725     0.200
     2.802   -12.985     0.200
     2.898   -11.117     0.200
     2.974   -13.498     0.200
     0.961    -0.010     0.200
     2.168    -7.083     0.200
     2.833   -11.209     0.200
     1.326    -3.132     0.200
     1.549    -4.435     0.200
     1.844    -5.801     0.200
     1.933    -7.204     0.200
     2.004    -8.989     0.200
     2.089   -10.040     0.200
     7.433   -53.537     0.200
     1.859    -5.596     0.200
     1.859    -5.294     0.200
     2.549   -13.370     0.200
     3.742   -20.021     0.200
     7.544   -49.336     0.200
     7.571   -44.331     0.200
     9.307   -59.108     0.200
     9.377   -62.144     0.200
     1.867    -6.444     0.200
     1.867    -5.969     0.200
     2.499   -12.503     0.200
     3.696   -20.637     0.200
     9.142   -63.102     0.200
     9.308   -56.297     0.200
     9.380   -60.768     0.200
     1.817    -5.363     0.200
     2.535   -13.830     0.200
     9.333   -60.740     0.200
    13.149   -90.825     0.200
     0.393     6.563     0.200
     0.965     0.150     0.200
     0.952     0.077     0.200
     0.993    -0.755     0.200
     1.001    -0.436     0.200
     1.045    -0.664     0.200
     1.063    -0.769     0.200
     1.094    -1.266     0.200
     1.233    -1.695     0.200
     1.311    -4.000     0.200
     1.612    -5.446     0.200
     1.762    -6.504     0.200
     2.188   -10.086     0.200
     2.288   -10.757     0.200
     2.301   -10.808     0.200
     2.359   -12.213     0.200
     2.373   -12.450     0.200
     3.170   -19.851     0.200
     7.664   -52.582     0.200
     1.448    -5.527     0.200
     1.732    -6.908     0.200
     1.967    -8.288     0.200
     2.021    -8.459     0.200
     2.085    -7.041     0.200
     2.089    -8.329     0.200
     2.541   -13.267     0.200
     0.536     4.695     0.200
     0.582     3.996     0.200
     0.643     3.371     0.200
     0.787     3.095     0.200
     0.787     2.525     0.200
     1.064    -0.033     0.200
     1.241    -1.491     0.200
     1.397    -2.713     0.200
     1.423    -3.841     0.200
     1.395    -1.929     0.200
     1.414    -1.763     0.200
     1.527    -4.567     0.200
     1.556    -5.216     0.200
     1.764    -6.477     0.200
     1.953    -8.090     0.200
     2.047    -7.624     0.200
     2.139    -8.675     0.200
     2.232   -10.269     0.200
     7.624   -53.464     0.200
     0.204     8.875     0.200
     0.668     2.363     0.200
     0.668     0.910     0.200
     0.980     0.432     0.200
     0.991     0.257     0.200
     0.999     0.210     0.200
     1.010    -0.288     0.200
     1.040     0.314     0.200
     1.280    -2.670     0.200
     1.290    -2.095     0.200
     1.317    -3.485     0.200
     1.374    -2.857     0.200
     1.531    -3.047     0.200
     1.938    -8.605     0.200
     1.978    -7.577     0.200
     2.136    -8.487     0.200
     2.758   -13.192     0.200
     2.838   -11.800     0.200
     6.908   -46.319     0.200
    12.466   -90.556     0.200
    12.466   -90.559     0.200
     0.663     0.125     0.200
     0.662     1.374     0.200
     1.624    -3.859     0.200
     1.829    -6.373     0.200
     7.022   -49.359     0.200
    11.314   -77.642     0.200
    11.818   -84.550     0.200
    11.819   -85.405     0.200
    14.604  -104.192     0.200
     0.473     5.752     0.200
     0.473     4.299     0.200
     0.473     3.986     0.200
     0.629     2.884     0.200
     0.956    -0.437     0.200
     0.983    -0.782     0.200
     1.012    -1.067     0.200
     1.054    -1.306     0.200
     1.083    -0.426     0.200
     1.125    -1.509     0.200
     1.209    -1.061     0.200
     1.236    -2.000     0.200
     1.655    -6.225     0.200
     1.671    -5.013     0.200
     1.722    -3.818     0.200
     1.931    -6.477     0.200
     2.011    -8.680     0.200
     2.021    -8.351     0.200
     2.019    -8.801     0.200
     2.149    -9.646     0.200
     2.300    -7.948     0.200
     2.421   -10.389     0.200
     2.478   -10.334     0.200
     2.823   -15.797     0.200
     2.836   -12.159     0.200
     2.906   -14.841     0.200
     2.959   -13.684     0.200
     3.065   -16.552     0.200
     3.370   -16.879     0.200
     7.305   -51.154     0.200
    12.170   -82.592     0.200
     0.040    25.586     0.200
     0.155    22.446     0.200
     0.155    22.215     0.200
     0.176    21.746     0.200
     0.882     6.698     0.200
     0.987     5.757     0.200
     0.955     6.704     0.200
     1.042     4.915     0.200
     1.137     3.792     0.200
     1.117     3.631     0.200
     1.328     2.141     0.200
     1.338     1.226     0.200
     1.376     0.195     0.200
     1.376     0.065     0.200
     1.380     1.525     0.200
     1.403     1.017     0.200
     1.578    -1.450     0.200
     1.784    -4.447     0.200
     1.947    -4.639     0.200
     2.589   -12.237     0.200
     2.650   -13.130     0.200
    13.084   -91.335     0.200
     1.135     2.598     0.200
     1.193     2.308     0.200
     1.270     1.813     0.200
     1.349     1.549     0.200
     1.361     0.971     0.200
     1.361     2.401     0.200
     1.504     0.274     0.200
     8.762   -55.191     0.200
     1.351     1.405     0.200
     2.167    -6.364     0.200
     2.488    -7.052     0.200
     8.803   -58.435     0.200
     1.509    -6.973     0.200
     2.178   -10.276     0.200
     2.516   -11.988     0.200
     7.533   -51.791     0.200
     0.153    13.471     0.200
     0.573     6.609     0.200
     0.762     4.268     0.200
     0.772     4.399     0.200
     0.776     4.227     0.200
     0.793     3.617     0.200
     0.806     3.601     0.200
     0.825     3.401     0.200
     0.910     1.025     0.200
     1.012     1.751     0.200
     1.100     0.740     0.200
     1.329    -2.788     0.200
     1.349    -2.332     0.200
     1.407    -4.163     0.200
     1.407    -2.761     0.200
     1.438    -4.369     0.200
     1.437    -2.881     0.200
     1.448    -1.919     0.200
     1.511    -4.689     0.200
     1.736    -4.567     0.200
     1.736    -5.812     0.200
     1.760    -6.379     0.200
     1.807    -5.428     0.200
     1.908    -6.394     0.200
     1.909    -5.721     0.200
     2.032    -7.424     0.200
     2.204   -10.456     0.200
     0.643     3.042     0.200
     0.718     2.604     0.200
     0.855     1.546     0.200
     0.888     1.423     0.200
     0.919     1.014     0.200
     0.958    -0.226     0.200
     0.961     0.250     0.200
     1.031     0.022     0.200
     1.216    -2.099     0.200
     1.617    -5.185     0.200
     1.988    -7.952     0.200
     8.602   -57.163     0.200
     0.673     2.821     0.200
     0.750     2.328     0.200
     0.857     0.598     0.200
     0.883     1.143     0.200
     0.912     0.514     0.200
     0.932     1.106     0.200
     0.957     0.869     0.200
     0.998    -0.199     0.200
     1.111    -1.269     0.200
     1.123    -2.551     0.200
     1.553    -3.588     0.200
     1.625    -5.401     0.200
     1.630    -4.963     0.200
     2.071    -9.160     0.200
     2.196   -10.242     0.200
     2.302   -10.947     0.200
     2.486   -11.649     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     1.147     0.906     0.200
     1.209    -0.808     0.200
     1.321    -0.426     0.200
     1.463    -1.723     0.200
     1.635    -2.113     0.200
     1.691    -2.158     0.200
     1.711    -1.478     0.200
     1.931    -3.458     0.200
     2.426    -7.364     0.200
     1.297    -2.878     0.200
     1.409    -0.624     0.200
     1.511     0.338     0.200
     1.534    -0.092     0.200
     1.736    -0.187     0.200
     1.763    -2.762     0.200
     2.065    -3.817     0.200
     2.225    -5.011     0.200
     0.088     0.162     0.200
     0.173     0.838     0.200
     1.620    -1.423     0.200
     0.539     2.110     0.200
     1.259    -0.519     0.200
     1.449    -0.738     0.200
     1.469    -2.362     0.200
     1.571    -3.287     0.200
     1.624    -1.585     0.200
     2.029    -1.220     0.200
     2.397    -3.683     0.200
     3.476   -12.398     0.200
     1.412    -0.621     0.200
     1.433    -0.783     0.200
     1.403    -0.042     0.200
     2.010    -2.875     0.200
     2.425    -5.234     0.200
     1.574    -0.233     0.200
     1.871    -2.272     0.200
     1.538    -1.527     0.200
     5.020    -6.836     0.200
     1.458    -1.663     0.200
     1.256    -1.603     0.200
     0.268     2.565     0.200
     0.630     0.292     0.200
     1.301    -1.613     0.200
     1.641    -2.485     0.200
     1.812    -2.641     0.200
     1.840    -2.596     0.200
     2.436    -7.114     0.200
     2.627    -4.327     0.200
     0.872    -0.693     0.200
     1.322    -2.450     0.200
     0.538     1.773     0.200
     1.151    -0.929     0.200
     1.433    -2.234     0.200
     1.484    -2.762     0.200
     0.292     3.845     0.200
     0.292     3.997     0.200
     0.386     2.712     0.200
     1.307    -2.226     0.200
     1.379    -2.743     0.200
     1.459    -2.563     0.200
     0.922     0.337     0.200
     0.863     1.813     0.200
     0.861     0.059     0.200
     1.323    -1.950     0.200
     1.323    -1.261     0.200
     0.444     2.275     0.200
     1.929    -3.529     0.200
     0.448     0.609     0.200
     1.328    -1.773     0.200
     0.067     0.541     0.200
     1.061    -1.236     0.200
     1.456    -0.510     0.200
     0.601     0.335     0.200
     1.495    -1.432     0.200
     0.728    -1.257     0.200
     0.858     1.589     0.200
     1.133     0.378     0.200
     1.499    -1.173     0.200
     3.750    -5.975     0.200
     0.664     0.718     0.200
     1.912    -3.101     0.200
     2.653    -6.448     0.200
     0.372     1.587     0.200
     0.783    -0.054     0.200
     1.807    -1.749     0.200
     1.856    -2.267     0.200
     1.980    -3.585     0.200
     2.767    -7.880     0.200
     0.057     6.458     0.200
     1.645    -2.808     0.200
     0.431     1.263     0.200
     0.804     0.820     0.200
     1.871    -2.953     0.200
     2.036    -2.723     0.200
     2.796    -8.375     0.200
     1.458    -1.588     0.200
     1.492    -2.852     0.200
     0.191     3.997     0.200
     1.784    -3.273     0.200
     1.860    -3.175     0.200
     2.132    -4.160     0.200
     1.413    -1.242     0.200
     1.468    -2.063     0.200
     1.476    -1.254     0.200
     1.503    -0.862     0.200
     2.341    -5.267     0.200
     0.470     1.802     0.200
     0.501     2.480     0.200
     0.319     3.163     0.200
     0.997     0.016     0.200
     1.434    -2.895     0.200
     1.495    -3.468     0.200
     1.523    -3.540     0.200
     1.641    -3.817     0.200
     1.607    -3.253     0.200
     0.419     2.192     0.200
     2.004    -4.800     0.200
     2.157    -5.992     0.200
     1.161     0.070     0.200
     1.224    -0.576     0.200
     1.491    -0.745     0.200
     1.602     0.114     0.200
     1.602     1.395     0.200
     0.518     1.661     0.200
     1.184    -0.440     0.200
     1.459    -1.269     0.200
     1.502    -1.583     0.200
     1.520     0.300     0.200
     1.562    -1.281     0.200
     2.016    -4.373     0.200
     0.360     3.519     0.200
     1.057     1.937     0.200
     1.351    -2.787     0.200
     1.702    -4.423     0.200
     1.728    -4.197     0.200
     0.831    -0.689     0.200
     0.831    -0.818     0.200
     1.705    -3.659     0.200
     0.715     2.412     0.200
     1.393    -1.497     0.200
     1.393    -1.365     0.200
     1.620     0.201     0.200
     0.436     1.911     0.200
     1.354    -1.482     0.200
     1.440    -2.519     0.200
     1.528    -3.045     0.200
     1.571    -2.942     0.200
     1.955    -3.658     0.200
     2.053    -5.031     0.200
     0.453     2.217     0.200
     1.895    -4.341     0.200
     1.254    -2.170     0.200
     1.521    -1.727     0.200
     1.533    -1.833     0.200
     1.707    -2.181     0.200
     0.588     2.783     0.200
     0.825    -0.060     0.200
     1.209    -0.703     0.200
     1.888    -4.726     0.200
     0.563     2.000     0.200
     0.563     2.429     0.200
     1.424    -2.120     0.200
     1.424    -1.961     0.200
     2.148    -4.513     0.200
     0.551     1.771     0.200
     0.551     2.050     0.200
     1.427    -2.461     0.200
     0.606     1.983     0.200
     0.606     1.811     0.200
     1.765    -1.917     0.200
     1.765    -3.421     0.200
     1.765    -2.440     0.200
     1.902    -3.214     0.200
     2.400    -1.955     0.200
     0.703     0.403     0.200
     0.996    -1.353     0.200
     0.996    -1.462     0.200
     0.346     3.712     0.200
     0.346     4.068     0.200
     0.855    -2.552     0.200
     0.855    -2.345     0.200
     1.144    -0.865     0.200
     0.518     2.020     0.200
     1.348    -2.812     0.200
     0.746     2.900     0.200
     0.982    -0.876     0.200
     1.182    -0.322     0.200
     1.359    -1.986     0.200
     1.359    -2.150     0.200
     1.484    -0.313     0.200
     1.881    -2.689     0.200
     1.931    -1.525     0.200
     2.191    -1.763     0.200
     2.386    -2.849     0.200
     2.393    -3.211     0.200
     2.548    -2.880     0.200
     2.759    -4.273     0.200
     3.250    -5.086     0.200
     3.366    -5.209     0.200
     0.719     2.501     0.200
     1.810     0.008     0.200
     1.858    -0.837     0.200
     2.150    -3.369     0.200
     2.218    -3.650     0.200
     2.477    -0.842     0.200
     2.690    -4.516     0.200
     3.177    -5.336     0.200
     3.177    -3.614     0.200
     0.895    -0.267     0.200
     1.284     0.518     0.200
     1.367    -1.499     0.200
     1.565    -1.182     0.200
     0.499     1.638     0.200
     0.499     1.956     0.200
     1.709    -3.648     0.200
     0.439     1.428     0.200
     0.439     1.791     0.200
     1.605    -1.998     0.200
     3.648    -6.098     0.200
     0.843    -0.445     0.200
     1.194    -1.045     0.200
     1.317    -0.747     0.200
     1.317    -0.599     0.200
     1.330    -0.960     0.200
     1.330    -1.546     0.200
     1.510    -1.593     0.200
     0.247     4.202     0.200
     0.881    -0.612     0.200
     1.029     1.459     0.200
     1.076     1.369     0.200
     1.498    -2.019     0.200
     1.501    -2.172     0.200
     1.698    -3.960     0.200
     1.901    -3.499     0.200
     1.901    -3.496     0.200
     0.166     2.520     0.200
     0.644     0.784     0.200
     0.657     0.739     0.200
     0.713     0.799     0.200
     0.766     0.622     0.200
     0.825    -1.634     0.200
     0.871     0.424     0.200
     0.961     0.241     0.200
     1.022    -1.870     0.200
     1.281    -1.832     0.200
     1.711    -2.078     0.200
     2.013    -2.152     0.200
     0.581     1.890     0.200
     1.294    -1.428     0.200
     1.338     0.766     0.200
     0.419     0.790     0.200
     0.419     0.954     0.200
     0.436     0.843     0.200
     0.512     0.875     0.200
     0.498     0.662     0.200
     0.574     0.945     0.200
     0.619     1.036     0.200
     1.039    -0.458     0.200
     0.340     1.296     0.200
     0.342     1.419     0.200
     0.388     1.736     0.200
     0.387     1.842     0.200
     0.888     0.615     0.200
     0.842     1.332     0.200
     1.113     0.399     0.200
     1.577    -0.168     0.200
     0.305     3.963     0.200
     0.305     3.826     0.200
     0.386     3.126     0.200
     0.784     0.059     0.200
     1.087    -0.810     0.200
     1.088    -1.206     0.200
     1.318    -2.320     0.200
     1.516    -2.798     0.200
     1.517    -2.671     0.200
     1.690    -3.695     0.200
     3.013    -4.390     0.200
     3.073    -5.843     0.200
     0.530     0.646     0.200
     0.451     2.667     0.200
     1.124    -0.716     0.200
     1.296    -1.029     0.200
     1.378    -2.026     0.200
     1.380    -1.987     0.200
     0.338     1.947     0.200
     0.338     2.177     0.200
     0.679     2.097     0.200
     1.774    -1.423     0.200
     1.775    -3.190     0.200
     1.804    -3.105     0.200
     1.804    -0.253     0.200
     1.926    -4.126     0.200
     0.272     4.649     0.200
     0.272     4.828     0.200
     0.862    -3.661     0.200
     0.862    -3.223     0.200
     1.090     0.164     0.200
     1.090    -0.539     0.200
     1.267     0.667     0.200
     1.267     0.268     0.200
     1.743    -2.424     0.200
     1.743    -3.854     0.200
     1.741    -2.601     0.200
     0.364     3.431     0.200
     0.364     3.181     0.200
     0.827    -1.529     0.200
     0.827    -1.037     0.200
     1.368     0.257     0.200
     1.833    -1.972     0.200
     2.086    -3.462     0.200
     2.100    -3.605     0.200
     2.235    -5.252     0.200
     2.235    -3.490     0.200
     0.482     0.921     0.200
     0.497     0.825     0.200
     0.514     0.626     0.200
     0.557     0.833     0.200
     0.695     1.082     0.200
     0.911    -1.241     0.200
     0.935    -0.310     0.200
     0.965    -0.859     0.200
     1.433     0.593     0.200
     1.490    -0.591     0.200
     2.550    -3.726     0.200
     0.648     1.128     0.200
     0.649     1.079     0.200
     0.903    -0.543     0.200
     1.065     0.796     0.200
     1.149     0.033     0.200
     1.136    -0.453     0.200
     1.517    -2.470     0.200
     0.595     2.540     0.200
     1.560    -0.678     0.200
     1.714    -0.851     0.200
     1.758     0.703     0.200
     0.554     1.202     0.200
     0.574     0.478     0.200
     1.576    -2.435     0.200
     1.620    -1.943     0.200
     1.757    -3.141     0.200
     1.757    -1.141     0.200
     0.414     1.811     0.200
     0.545     1.319     0.200
     0.564     0.760     0.200
     1.313    -1.021     0.200
     1.570    -2.505     0.200
     0.393     2.695     0.200
     0.531     1.257     0.200
     0.554     0.718     0.200
     1.735    -2.724     0.200
     2.198    -4.641     0.200
     0.972    -1.237     0.200
     1.348    -1.340     0.200
     0.485     1.602     0.200
     0.485     1.743     0.200
     0.946    -0.914     0.200
     1.698    -3.329     0.200
     1.698    -3.342     0.200
     0.517     0.919     0.200
     0.719     0.086     0.200
     1.258    -1.136     0.200
     1.238    -1.128     0.200
     1.392    -1.765     0.200
     1.435    -0.200     0.200
     1.674    -3.201     0.200
     1.872    -4.480     0.200
     1.877    -5.053     0.200
     1.986    -2.849     0.200
     0.199     4.800     0.200
     0.199     4.479     0.200
     0.920    -1.558     0.200
     0.920    -2.131     0.200
     1.198     0.811     0.200
     2.079    -2.175     0.200
     2.151    -0.695     0.200
     2.287    -4.033     0.200
     2.311    -1.313     0.200
     2.922    -4.714     0.200
     3.624    -6.689     0.200
     0.463     1.083     0.200
     0.651     0.631     0.200
     1.043    -1.241     0.200
     1.865    -2.064     0.200
     1.896    -2.068     0.200
     2.128    -3.472     0.200
     0.206     5.458     0.200
     0.835    -0.039     0.200
     1.080    -0.139     0.200
     1.122    -1.497     0.200
     1.407    -3.058     0.200
     1.700    -3.321     0.200
     0.885    -0.413     0.200
     1.184     1.389     0.200
     1.329    -1.105     0.200
     1.329     0.661     0.200
     1.358    -0.215     0.200
     1.358     0.157     0.200
     1.403    -2.939     0.200
     0.860    -0.174     0.200
     1.208    -2.156     0.200
     1.357    -1.338     0.200
     1.357    -1.088     0.200
     1.523    -0.684     0.200
     1.490    -2.886     0.200
     1.517    -2.952     0.200
     1.517    -2.574     0.200
     0.476     2.110     0.200
     1.102     0.581     0.200
     1.183    -0.787     0.200
     1.263    -0.779     0.200
     1.416    -0.697     0.200
     0.392     0.834     0.200
     0.414     0.778     0.200
     0.560     0.733     0.200
     0.588     0.925     0.200
     0.674     1.162     0.200
     0.675     2.024     0.200
     0.879    -0.055     0.200
     1.076     0.273     0.200
     1.333    -1.078     0.200
     0.570     3.276     0.200
     1.233     1.038     0.200
     1.296    -0.236     0.200
     0.548    -0.232     0.200
     0.940    -0.010     0.200
     1.371    -0.208     0.200
     1.726    -0.341     0.200
     0.564     0.838     0.200
     0.997    -1.422     0.200
     1.007     0.421     0.200
     1.360    -0.673     0.200
     1.500    -0.987     0.200
     1.672    -2.030     0.200
     2.040    -3.136     0.200
     2.160    -6.215     0.200
     1.583    -3.141     0.200
     1.583    -2.520     0.200
     1.583    -2.220     0.200
     1.583    -2.392     0.200
     2.093    -6.030     0.200
     2.092    -5.089     0.200
     2.232    -5.633     0.200
     2.235    -5.094     0.200
     1.644    -3.679     0.200
     1.644    -3.478     0.200
     2.163    -5.176     0.200
     0.651     0.924     0.200
     1.294    -4.327     0.200
     1.415     0.077     0.200
     2.096    -3.575     0.200
     2.142    -4.531     0.200
     2.093    -3.836     0.200
     2.234    -4.477     0.200
     2.289    -2.747     0.200
     2.299    -2.942     0.200
     2.339    -4.427     0.200
     2.485    -4.573     0.200
     2.773    -8.523     0.200
     2.887    -7.699     0.200
     0.325     4.937     0.200
     0.782    -2.244     0.200
     1.688    -1.072     0.200
     2.212    -1.925     0.200
     2.219    -2.098     0.200
     2.684    -8.605     0.200
     0.380     4.412     0.200
     1.018     1.290     0.200
     1.083     0.267     0.200
     1.622    -3.675     0.200
     2.004    -3.598     0.200
     2.237    -5.157     0.200
     2.182    -4.703     0.200
     2.199    -5.405     0.200
     2.199    -3.115     0.200
     2.273    -6.163     0.200
     0.754    -0.765     0.200
     1.269    -2.128     0.200
     1.302    -0.933     0.200
     1.396    -1.340     0.200
     1.465    -1.339     0.200
     1.467    -0.764     0.200
     1.485    -0.585     0.200
     0.707     1.465     0.200
     0.807     0.552     0.200
     0.858     0.378     0.200
     0.854     0.936     0.200
     0.856     0.566     0.200
     0.857     0.872     0.200
     0.932     0.281     0.200
     0.960     0.127     0.200
     1.696    -1.486     0.200
     0.375     3.526     0.200
     0.375     3.705     0.200
     0.722    -1.077     0.200
     0.722    -0.436     0.200
     1.201    -2.010     0.200
     1.664    -1.990     0.200
     1.881    -3.512     0.200
     0.807     0.735     0.200
     0.865    -0.410     0.200
     0.857     0.647     0.200
     0.935     0.395     0.200
     0.960     1.006     0.200
     1.052     0.259     0.200
     1.056     0.300     0.200
     1.251     0.028     0.200
     1.488     0.248     0.200
     1.608    -0.479     0.200
     1.691    -0.761     0.200
     1.946    -1.392     0.200
     2.419    -3.520     0.200
     2.771    -5.276     0.200
     2.749    -4.745     0.200
     0.488     0.373     0.200
     0.500     0.135     0.200
     0.581     0.528     0.200
     0.835    -1.287     0.200
     0.957    -0.253     0.200
     1.292    -0.445     0.200
     1.534    -1.053     0.200
     1.512     0.037     0.200
     0.620    -0.544     0.200
     0.788     0.414     0.200
     0.852     1.343     0.200
     1.025     0.415     0.200
     1.047     1.140     0.200
     1.081     0.205     0.200
     1.071    -0.058     0.200
     1.063     0.684     0.200
     1.094     0.828     0.200
     1.163     0.198     0.200
     1.354     0.394     0.200
     2.107    -2.257     0.200
     0.765     1.073     0.200
     0.861     1.159     0.200
     1.290    -1.086     0.200
     1.530    -1.401     0.200
     1.530    -0.772     0.200
     1.551    -1.485     0.200
     1.551    -1.157     0.200
     1.743    -2.076     0.200
     0.686     0.058     0.200
     0.686    -0.122     0.200
     1.195    -1.450     0.200
     1.374    -0.296     0.200
     1.732    -2.500     0.200
     0.111     5.395     0.200
     1.609    -2.971     0.200
     1.697    -3.687     0.200
     1.824    -3.028     0.200
     1.869    -3.431     0.200
     0.475     1.364     0.200
     0.475     0.747     0.200
     1.542    -1.178     0.200
     1.542    -0.342     0.200
     1.593    -0.542     0.200
     1.671    -2.648     0.200
     1.656     0.179     0.200
     1.642    -1.249     0.200
     1.730    -0.459     0.200
     1.825    -1.829     0.200
     1.822    -2.444     0.200
     1.943    -2.016     0.200
     2.115    -3.438     0.200
     0.299     0.445     0.200
     0.340     0.495     0.200
     0.396     0.519     0.200
     0.402     0.047     0.200
     0.419     0.541     0.200
     0.469     0.882     0.200
     0.613     0.553     0.200
     1.025    -0.905     0.200
     1.130    -0.011     0.200
     1.309    -1.120     0.200
     1.531     1.747     0.200
     1.531     0.919     0.200
     1.693     0.025     0.200
     2.008    -1.630     0.200
     2.019    -2.802     0.200
     2.122    -2.210     0.200
     2.141    -2.861     0.200
     2.494    -3.974     0.200
     0.301     0.449     0.200
     0.341     0.517     0.200
     0.361     0.203     0.200
     0.402     0.184     0.200
     0.398     0.279     0.200
     0.416     0.559     0.200
     0.471     0.746     0.200
     0.521     0.778     0.200
     0.938    -0.232     0.200
     1.024     0.262     0.200
     1.065     0.312     0.200
     1.535     0.048     0.200
     2.137    -3.083     0.200
     0.026     1.937     0.200
     0.098    -0.185     0.200
     0.100     0.636     0.200
     0.234     0.220     0.200
     0.226     1.643     0.200
     0.251     0.373     0.200
     0.320     0.827     0.200
     0.321     0.824     0.200
     0.370     0.008     0.200
     0.357     1.746     0.200
     0.412     0.641     0.200
     0.522     1.068     0.200
     0.615     1.747     0.200
     0.646     1.158     0.200
     0.726    -0.405     0.200
     0.924    -0.337     0.200
     0.955     0.025     0.200
     1.093    -0.069     0.200
     1.103     0.350     0.200
     1.137    -0.172     0.200
     0.445     1.763     0.200
     1.676    -1.094     0.200
     1.728    -2.910     0.200
     1.739    -2.300     0.200
     1.835    -2.524     0.200
     1.831    -3.702     0.200
     0.321     1.729     0.200
     0.490    -0.787     0.200
     0.391     0.956     0.200
     0.444     1.090     0.200
     0.538     2.082     0.200
     0.496     1.497     0.200
     0.561     1.823     0.200
     0.661    -0.237     0.200
     0.786     0.145     0.200
     0.818     0.268     0.200
     1.443    -1.889     0.200
     1.549    -1.034     0.200
     1.622    -1.957     0.200
     1.622    -1.309     0.200
     1.838    -3.548     0.200
     1.904    -3.079     0.200
     0.369     1.731     0.200
     0.513     1.598     0.200
     0.576     0.280     0.200
     0.596     0.260     0.200
     0.597     0.753     0.200
     0.685     1.102     0.200
     0.678     1.337     0.200
     0.848     0.816     0.200
     0.912     0.148     0.200
     0.986     0.261     0.200
     1.107    -0.440     0.200
     1.229    -1.383     0.200
     1.276    -1.389     0.200
     1.877    -3.227     0.200
     0.650     1.136     0.200
     0.854     0.155     0.200
     0.854     0.366     0.200
     0.863     0.433     0.200
     0.868     0.469     0.200
     1.102    -0.584     0.200
     1.154    -1.442     0.200
     1.477    -1.994     0.200
     1.450     0.684     0.200
     1.450     0.795     0.200
     1.589    -1.492     0.200
     1.847    -2.629     0.200
     1.847    -2.097     0.200
     0.538     2.082     0.200
     0.625     0.752     0.200
     1.241    -1.104     0.200
     1.458    -1.987     0.200
     1.438    -2.012     0.200
     1.446    -1.857     0.200
     1.445    -1.632     0.200
     1.479    -0.784     0.200
     1.622    -1.911     0.200
     1.517    -1.787     0.200
     1.593    -1.016     0.200
     1.649    -2.147     0.200
     1.768    -3.838     0.200
     1.785    -2.469     0.200
     1.890    -3.522     0.200
     1.936    -4.528     0.200
     2.179    -5.309     0.200
     0.596    -0.634     0.200
     0.922     0.103     0.200
     0.970     0.492     0.200
     0.981     0.703     0.200
     0.981     0.913     0.200
     0.990     0.256     0.200
     0.988     0.816     0.200
     1.022     0.206     0.200
     1.022     0.656     0.200
     1.117     0.107     0.200
     1.356    -0.357     0.200
     1.820    -1.889     0.200
     1.184     0.278     0.200
     1.240    -0.739     0.200
     1.456    -1.374     0.200
     1.565     0.182     0.200
     1.632     0.316     0.200
     1.704    -1.454     0.200
     2.113    -1.996     0.200
     2.159    -1.234     0.200
     0.378     3.725     0.200
     1.091    -0.935     0.200
     1.277    -1.221     0.200
     1.283    -1.297     0.200
     1.305    -1.016     0.200
     1.326    -1.572     0.200
     1.408    -2.474     0.200
     1.490    -2.028     0.200
     1.487    -1.952     0.200
     1.596    -3.265     0.200
     1.731    -4.469     0.200
     0.034     0.850     0.200
     0.053     0.950     0.200
     0.092     0.147     0.200
     0.162     0.566     0.200
     0.197     0.295     0.200
     0.255    -0.142     0.200
     0.427     0.435     0.200
     0.924     1.003     0.200
     1.020    -0.276     0.200
     1.020     1.365     0.200
     1.067     0.769     0.200
     1.155     0.821     0.200
     1.437    -0.466     0.200
     1.437    -0.228     0.200
     1.466    -0.384     0.200
     2.472    -2.447     0.200
     0.037     0.974     0.200
     0.101     0.598     0.200
     0.110     0.459     0.200
     0.109    -0.233     0.200
     0.167     0.096     0.200
     0.152     1.047     0.200
     0.375     1.967     0.200
     0.436     0.995     0.200
     0.786     1.334     0.200
     0.914     0.831     0.200
     1.011     0.161     0.200
     1.152    -0.123     0.200
     1.654    -0.861     0.200
     2.280    -3.718     0.200
     1.000    -0.800     0.200
     1.291    -0.526     0.200
     1.440    -1.005     0.200
     1.652    -2.786     0.200
     1.709    -3.839     0.200
     2.213    -5.991     0.200
     0.033     0.772     0.200
     0.061     0.002     0.200
     0.072     1.108     0.200
     0.089     0.216     0.200
     0.156     0.217     0.200
     0.192     1.121     0.200
     0.224     0.034     0.200
     0.336     0.756     0.200
     0.399     1.230     0.200
     1.036     0.005     0.200
     1.139    -0.392     0.200
     1.602    -0.641     0.200
     1.677     0.517     0.200
     1.916    -1.274     0.200
     1.990    -1.695     0.200
     2.017    -2.389     0.200
     2.079    -2.599     0.200
     2.097    -3.088     0.200
     0.666     1.015     0.200
     0.953    -1.354     0.200
     1.515    -0.720     0.200
     1.667    -0.497     0.200
     0.039     1.036     0.200
     0.042     0.251     0.200
     0.042     1.561     0.200
     0.106     0.072     0.200
     0.112    -0.230     0.200
     0.145     0.550     0.200
     0.173     0.087     0.200
     0.270     0.007     0.200
     0.380     0.273     0.200
     0.427     1.286     0.200
     0.442     0.691     0.200
     0.792    -0.922     0.200
     1.479     2.408     0.200
     1.481     0.516     0.200
     1.620    -1.197     0.200
     2.053    -2.758     0.200
     2.117    -3.466     0.200
     2.121    -2.958     0.200
     2.566    -5.285     0.200
     0.047     0.503     0.200
     0.047     0.772     0.200
     0.080     0.385     0.200
     0.088     0.824     0.200
     0.129     0.388     0.200
     0.208     0.316     0.200
     0.209     0.909     0.200
     0.323     0.601     0.200
     0.381     0.870     0.200
     0.393     1.353     0.200
     1.022     0.036     0.200
     1.431    -0.579     0.200
     1.475    -0.060     0.200
     1.704    -0.569     0.200
     1.689     0.690     0.200
     1.779    -0.743     0.200
     1.983    -1.653     0.200
     2.006    -1.696     0.200
     2.068    -2.739     0.200
     0.028     0.999     0.200
     0.075     0.387     0.200
     0.061     0.861     0.200
     0.117     0.302     0.200
     0.178     0.940     0.200
     0.238    -0.061     0.200
     0.411     1.112     0.200
     0.408     0.626     0.200
     1.608    -0.949     0.200
     0.066     0.478     0.200
     0.030     0.930     0.200
     0.092     0.374     0.200
     0.067     0.663     0.200
     0.122     0.330     0.200
     0.187     0.929     0.200
     0.341     0.700     0.200
     0.401     0.685     0.200
     0.402     1.074     0.200
     0.793     1.246     0.200
     1.041     0.853     0.200
     1.604     0.115     0.200
     0.056     0.292     0.200
     0.028     1.027     0.200
     0.070     1.052     0.200
     0.096    -0.066     0.200
     0.133     0.011     0.200
     0.164     0.376     0.200
     0.219    -0.110     0.200
     0.331     0.342     0.200
     0.392     0.566     0.200
     0.390    -1.275     0.200
     0.390     0.780     0.200
     0.907     1.019     0.200
     0.955     1.304     0.200
     1.031     0.190     0.200
     1.449    -0.179     0.200
     1.671     0.699     0.200
     1.709     0.085     0.200
     1.981    -1.511     0.200
     0.044     0.529     0.200
     0.103    -0.425     0.200
     0.034     0.882     0.200
     0.077     0.940     0.200
     0.207     0.205     0.200
     0.317     0.434     0.200
     0.379     0.797     0.200
     0.376     1.617     0.200
     1.017     0.114     0.200
     1.381    -0.006     0.200
     1.694    -0.220     0.200
     1.670    -0.066     0.200
     1.967    -1.905     0.200
     2.057    -2.249     0.200
     2.438    -2.957     0.200
     0.038     0.724     0.200
     0.052     0.611     0.200
     0.078     0.857     0.200
     0.087     0.715     0.200
     0.215    -0.116     0.200
     0.200     0.844     0.200
     0.228     0.950     0.200
     0.328     0.942     0.200
     0.388     0.858     0.200
     0.393     1.343     0.200
     1.028     0.266     0.200
     1.598    -1.207     0.200
     1.681    -0.900     0.200
     0.939    -1.090     0.200
     1.148    -2.797     0.200
     1.437     0.974     0.200
     1.807    -1.508     0.200
     0.350     3.758     0.200
     1.255    -1.789     0.200
     1.237    -1.617     0.200
     1.242    -1.366     0.200
     1.243    -1.296     0.200
     1.268    -1.193     0.200
     1.327    -1.737     0.200
     1.423    -2.261     0.200
     1.506    -3.136     0.200
     1.540    -3.922     0.200
     1.556    -3.594     0.200
     0.734     1.398     0.200
     0.462     1.672     0.200
     0.746     0.015     0.200
     0.746     0.244     0.200
     1.732    -2.974     0.200
     1.944    -5.194     0.200
     0.233     2.166     0.200
     1.371    -2.586     0.200
     1.694    -1.814     0.200
     1.694    -0.673     0.200
     1.701    -2.158     0.200
     1.738    -1.368     0.200
     1.764    -1.581     0.200
     1.779    -0.574     0.200
     1.779    -0.254     0.200
     1.769    -2.290     0.200
     1.864    -3.090     0.200
     1.864    -2.168     0.200
     1.879    -2.238     0.200
     1.898    -2.226     0.200
     0.216     1.087     0.200
     0.339     0.553     0.200
     0.395     1.378     0.200
     0.423     0.759     0.200
     0.425     1.573     0.200
     0.481     0.648     0.200
     0.615     2.144     0.200
     0.831    -0.276     0.200
     1.014    -0.128     0.200
     1.015     0.676     0.200
     1.026     0.725     0.200
     1.279    -0.636     0.200
     1.322    -0.233     0.200
     1.419    -1.551     0.200
     1.522    -0.032     0.200
     1.620    -1.255     0.200
     1.730     0.254     0.200
     1.812    -1.401     0.200
     0.458     2.118     0.200
     1.362     0.295     0.200
     1.437    -0.994     0.200
     1.884    -2.337     0.200
     0.525     0.703     0.200
     1.412    -0.923     0.200
     1.628     0.887     0.200
     1.648     1.027     0.200
     1.851    -1.173     0.200
     1.865    -1.181     0.200
     1.954    -2.038     0.200
     0.734    -0.168     0.200
     0.924    -0.341     0.200
     0.924    -0.021     0.200
     0.960    -0.751     0.200
     1.883    -4.812     0.200
     1.876    -4.985     0.200
     1.876    -0.985     0.200
     2.017    -0.097     0.200
     2.236    -1.116     0.200
     0.399     1.648     0.200
     1.662    -2.128     0.200
     1.730    -3.166     0.200
     1.729    -2.658     0.200
     1.793    -3.192     0.200
     1.810    -3.774     0.200
     1.819    -4.441     0.200
     1.833    -3.188     0.200
     1.849    -2.932     0.200
     1.874    -2.878     0.200
     1.882    -2.926     0.200
     1.899    -2.748     0.200
     1.955    -3.498     0.200
     2.014    -4.383     0.200
     2.233    -5.388     0.200
     2.497    -6.548     0.200
     2.808    -9.035     0.200
     0.129     7.152     0.200
     0.755     0.119     0.200
     0.727     1.096     0.200
     1.224    -2.367     0.200
     1.281    -2.654     0.200
     1.341    -2.797     0.200
     1.391    -2.084     0.200
     1.489    -2.949     0.200
     1.516    -3.090     0.200
     1.518    -3.011     0.200
     1.194    -1.134     0.200
     1.198    -1.157     0.200
     1.198    -1.036     0.200
     2.361    -6.750     0.200
     0.569     1.499     0.200
     0.545     1.062     0.200
     1.060     1.116     0.200
     1.060     1.436     0.200
     0.486     2.134     0.200
     1.119    -0.961     0.200
     1.251    -0.291     0.200
     1.264    -0.637     0.200
     1.516    -0.961     0.200
     1.516     0.071     0.200
     1.639    -1.848     0.200
     1.808    -2.492     0.200
     1.855    -1.898     0.200
     1.895    -2.897     0.200
     0.034     8.571     0.200
     0.848     1.186     0.200
     1.306    -2.346     0.200
     1.356    -2.363     0.200
     1.452    -3.079     0.200
     1.449    -2.922     0.200
     1.512    -2.337     0.200
     1.953    -4.513     0.200
EOF
gmt end
