#!/bin/bash
gmt begin kodiak1.21_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional kodiak1.21'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    38.618
    14.500    38.340
    15.000    38.060
    15.500    37.776
    16.000    37.488
    16.500    37.193
    17.000    36.891
    17.500    36.579
    18.000    36.255
    18.500    35.917
    19.000    35.563
    19.500    35.190
    20.000    34.798
    20.500    34.382
    21.000    33.941
    21.500    33.473
    22.000    32.977
    22.500    32.449
    23.000    31.889
    23.500    30.942
    24.000    29.674
    24.500    28.397
    25.000    27.110
    25.500    25.813
    26.000    24.504
    26.500    23.183
    27.000    21.848
    27.500    20.495
    28.000    19.123
    28.500    17.738
    29.000    16.343
    29.500    14.941
    30.000    13.530
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    16.123 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500     5.527
     1.000     6.080
     1.500     7.005
     2.000     7.993
     2.500     9.001
     3.000    10.017
     3.500    11.037
     4.000    12.058
     4.500    13.080
     5.000    14.101
     5.500    15.123
     6.000    16.143
     6.500    17.162
     7.000    18.179
     7.500    19.195
     8.000    20.208
     8.500    21.219
     9.000    22.229
     9.500    23.235
    10.000    24.239
    10.500    25.240
    11.000    26.237
    11.500    27.232
    12.000    28.223
    12.500    29.210
    13.000    30.194
    13.500    31.173
    14.000    32.145
    14.500    32.896
    15.000    33.606
    15.500    34.257
    16.000    34.791
    16.500    35.259
    17.000    35.665
    17.500    36.024
    18.000    36.312
    18.500    36.544
    19.000    36.719
    19.500    36.837
    20.000    36.899
    20.500    36.902
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    27.194 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    -3.000 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     0.500    13.696
     1.000    19.174
     1.500    25.437
     2.000    31.835
     2.500    38.272
     3.000    44.725
     3.500    51.185
     4.000    57.648
     4.500    64.109
     5.000    70.571
     5.500    77.031
     6.000    83.488
     6.500    89.940
     7.000    96.388
     7.500   102.831
     8.000   109.269
     8.500   115.701
     9.000   122.126
     9.500   128.545
    10.000   134.956
    10.500   141.359
    11.000   147.755
    11.500   154.141
    12.000   160.518
    12.500   166.886
    13.000   173.245
    13.500   179.592
    14.000   185.929
    14.500   192.255
    15.000   198.569
    15.500   204.872
    16.000   211.162
    16.500   217.443
    17.000   223.712
    17.500   229.972
    18.000   236.217
    18.500   242.448
    19.000   248.666
    19.500   254.870
    20.000   261.060
    20.500   267.236
    21.000   273.396
    21.500   279.541
    22.000   285.670
    22.500   291.783
    23.000   297.880
    23.500   303.959
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    55.648 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    -3.000 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    24.539   304.438     0.150
    27.435   310.643     0.150
    27.435   384.643     0.150
    27.435   450.643     0.150
    29.418   311.504     0.150
    24.246   252.651     0.150
    25.767   237.899     0.150
    27.227  -313.739     0.150
    27.427  -310.068     0.150
    28.117   308.475     0.150
    24.389   463.721     0.150
    24.991   301.690     0.150
    26.276  -292.642     0.150
    22.433   279.320     0.150
    24.633   292.638     0.150
    25.225   302.733     0.150
    28.197   315.055     0.150
    28.952   311.235     0.150
    24.457   304.141     0.150
    26.687   304.121     0.150
    27.445  -308.783     0.150
    27.681   303.519     0.150
    27.681  -315.833     0.150
    27.681    75.519     0.150
    27.919  -318.818     0.150
    28.389  -324.401     0.150
    28.465  -325.192     0.150
    28.801  -329.112     0.150
    28.801   210.443     0.150
    29.141   308.477     0.150
    29.463  -336.632     0.150
    29.685   423.129     0.150
    14.263   208.771     0.150
    29.382   312.325     0.150
    28.612   210.568     0.150
    29.571   202.383     0.150
    23.942   254.371     0.150
    28.325   214.228     0.150
    29.028  -328.351     0.150
    29.028   208.026     0.150
    14.961   205.985     0.150
    21.794   732.242     0.150
    25.469   235.350     0.150
    26.934   220.251     0.150
    28.631  -315.818     0.150
    29.395  -326.345     0.150
    29.395   198.532     0.150
    29.395   413.532     0.150
    26.791  -306.647     0.150
    27.454    29.958     0.150
    29.991  -343.296     0.150
    16.480   232.819     0.150
    19.241    49.572     0.150
    24.757   465.201     0.150
    27.038   311.581     0.150
    28.055   306.019     0.150
    27.832   440.321     0.150
    28.437   305.261     0.150
    29.642   314.193     0.150
    29.642   204.193     0.150
    19.175    54.787     0.150
    19.230    54.143     0.150
    28.218  -315.303     0.150
    28.218  -307.303     0.150
    28.218  -316.104     0.150
    28.218  -308.104     0.150
    26.281  -291.802     0.150
    26.281  -289.704     0.150
    26.281   228.120     0.150
    26.897  -299.096     0.150
    26.897  -296.194     0.150
    27.410  -304.773     0.150
    27.580  -306.556     0.150
    28.116  -312.111     0.150
    28.116  -306.111     0.150
    28.116   291.111     0.150
    28.116  -312.510     0.150
    28.116  -306.510     0.150
    28.116    72.713     0.150
    28.116   207.713     0.150
    28.116   382.713     0.150
    28.609  -319.371     0.150
    29.320  -325.563     0.150
    29.320   200.359     0.150
    29.320   416.961     0.150
    29.324  -327.314     0.150
    29.324  -321.212     0.150
    29.367  -327.708     0.150
    29.566  -330.041     0.150
    27.715  -311.038     0.150
    20.725    50.805     0.150
    14.261   203.228     0.150
    22.685   266.820     0.150
     7.201   607.246     0.150
    20.010   277.169     0.150
    20.010   479.569     0.150
    19.063   506.216     0.150
    19.536    49.691     0.150
    19.991   491.875     0.150
    27.101   285.178     0.150
    18.692   303.992     0.150
    20.553   258.515     0.150
     8.256   618.671     0.150
    14.403   555.529     0.150
    20.270    55.066     0.150
    20.270   498.316     0.150
    26.528  -297.893     0.150
    26.806    64.695     0.150
    26.806   296.695     0.150
    27.770  -311.518     0.150
    27.886  -312.959     0.150
    28.165    69.031     0.150
    28.165   298.730     0.150
    27.952  -313.569     0.150
    28.381  -318.939     0.150
    28.393  -319.067     0.150
    28.552  -320.517     0.150
    28.956  -325.384     0.150
    29.349  -331.703     0.150
    29.142  -327.548     0.150
    29.475  -331.316     0.150
    29.499  -331.658     0.150
    29.871  -335.604     0.150
    29.951  -336.850     0.150
    19.466   299.487     0.150
    19.082   250.168     0.150
    20.223   258.176     0.150
    20.541   259.743     0.150
    25.409    64.012     0.150
    25.409   300.012     0.150
    25.409   311.012     0.150
    25.423    66.990     0.150
    25.423   299.990     0.150
    25.423   314.990     0.150
    26.382  -296.877     0.150
    26.382  -290.877     0.150
    26.382    65.123     0.150
    26.382   296.123     0.150
    26.382   319.123     0.150
    27.680  -311.029     0.150
    27.680  -306.029     0.150
    27.680    67.251     0.150
    27.680   297.251     0.150
    27.680   319.251     0.150
    27.680   439.251     0.150
    28.166   300.565     0.150
    28.171  -316.751     0.150
    28.171  -311.751     0.150
    28.171    67.939     0.150
    28.171    68.939     0.150
    28.171    80.939     0.150
    28.171   211.939     0.150
    28.171   301.939     0.150
    28.171   427.939     0.150
    28.434  -315.826     0.150
    28.434    68.474     0.150
    28.434    84.474     0.150
    28.434   301.474     0.150
    28.434   329.474     0.150
    28.641  -318.237     0.150
    28.641    81.593     0.150
    28.641   304.593     0.150
    28.641   329.593     0.150
    28.651  -321.353     0.150
    28.651  -317.353     0.150
    28.651    82.738     0.150
    28.651   301.738     0.150
    28.656  -318.417     0.150
    28.656   304.513     0.150
    28.656   310.513     0.150
    29.368  -330.825     0.150
    29.368    67.135     0.150
    29.368   300.135     0.150
    29.940  -336.227     0.150
    20.242   286.749     0.150
    20.242   498.749     0.150
    29.333  -329.413     0.150
    13.862   202.223     0.150
    19.316   248.638     0.150
    19.804   501.946     0.150
    20.387   256.049     0.150
    29.081  -325.732     0.150
    29.795  -334.183     0.150
    29.847  -334.918     0.150
    19.791    49.552     0.150
    28.324  -315.067     0.150
    29.927  -333.973     0.150
    28.115  -313.969     0.150
    28.336  -316.675     0.150
    28.761  -321.498     0.150
    14.367   198.657     0.150
    14.367   543.481     0.150
    20.572   276.817     0.150
    20.572   484.266     0.150
    20.572   742.270     0.150
    26.168  -282.291     0.150
    26.168  -269.518     0.150
    27.236  -295.627     0.150
    27.485  -296.812     0.150
    27.691  -299.741     0.150
    28.606  -310.830     0.150
    28.744  -312.789     0.150
    29.083  -315.612     0.150
    19.584    47.483     0.150
    13.329   189.396     0.150
    20.025   277.760     0.150
    18.646   305.531     0.150
    29.015  -327.507     0.150
    29.015   307.185     0.150
    29.227   206.116     0.150
    26.521    66.027     0.150
    26.521   294.027     0.150
    28.677  -320.980     0.150
    19.860   292.753     0.150
    19.860   508.353     0.150
    27.568   304.907     0.150
    27.630   219.619     0.150
    27.801   217.581     0.150
    28.955   306.218     0.150
    29.173   205.673     0.150
    29.173   206.165     0.150
    29.340   204.550     0.150
    13.842   194.715     0.150
    20.975   264.191     0.150
    27.247   223.191     0.150
    27.247   300.191     0.150
    27.247   364.191     0.150
    29.113   304.915     0.150
    19.289   294.094     0.150
    19.289   505.393     0.150
    29.940  -334.652     0.150
    19.766   500.695     0.150
    12.961   564.447     0.150
    19.103   505.243     0.150
    20.752   264.145     0.150
    28.993  -327.779     0.150
    29.425  -331.393     0.150
    20.320   287.166     0.150
    20.559    51.877     0.150
    20.559   261.275     0.150
    20.860   265.620     0.150
    28.063   299.360     0.150
    20.087   291.489     0.150
    20.087   506.395     0.150
    28.285   433.477     0.150
    29.030   428.078     0.150
    29.150   207.266     0.150
    29.150   426.489     0.150
    20.592    57.537     0.150
    20.592   279.537     0.150
    27.760   294.480     0.150
    29.535   198.876     0.150
    29.535   413.614     0.150
    14.442   206.824     0.150
    20.385   284.171     0.150
    20.385   495.870     0.150
    20.395    49.294     0.150
    27.779  -307.858     0.150
    19.222   294.428     0.150
    19.942   293.419     0.150
    19.942   508.719     0.150
    27.853  -316.144     0.150
    27.853   304.195     0.150
    28.328   433.756     0.150
    28.530   432.614     0.150
    28.985   209.904     0.150
    28.985   429.614     0.150
    29.896   419.097     0.150
    29.989   419.437     0.150
     6.877   622.542     0.150
    19.302   290.288     0.150
    19.302   497.686     0.150
    19.302   757.077     0.150
    19.430   246.292     0.150
    22.600    51.745     0.150
    22.637    52.610     0.150
    22.638    46.946     0.150
    22.727    51.948     0.150
    23.539    48.283     0.150
    24.600    46.906     0.150
    25.847    44.744     0.150
    27.357   214.082     0.150
    29.739  -326.065     0.150
    29.797  -326.431     0.150
    19.172   503.800     0.150
    20.146   290.447     0.150
    21.093   283.055     0.150
    27.253   294.873     0.150
    29.631  -338.039     0.150
    18.887   301.314     0.150
     8.343   605.471     0.150
    14.417   200.198     0.150
    29.957  -333.792     0.150
    19.806   290.964     0.150
    19.806   502.464     0.150
    20.620    53.264     0.150
    29.892   196.970     0.150
    13.540   553.307     0.150
    19.754   286.040     0.150
    19.754   493.540     0.150
    19.754   752.290     0.150
    23.274   252.468     0.150
    24.063   244.362     0.150
    25.502   231.613     0.150
    26.639   220.503     0.150
    26.846  -291.599     0.150
    26.889   219.044     0.150
    27.036   427.339     0.150
    27.307  -297.740     0.150
    27.697   209.465     0.150
    28.001  -306.362     0.150
    28.077   207.663     0.150
    28.618  -312.486     0.150
    28.618   203.408     0.150
    29.632   194.991     0.150
    29.848  -326.812     0.150
    29.848   193.782     0.150
    29.997  -328.636     0.150
    19.101    47.301     0.150
    24.696   245.481     0.150
    19.431   294.064     0.150
    26.048  -290.435     0.150
    26.246  -292.345     0.150
    26.383  -294.555     0.150
    27.973  -312.324     0.150
    28.037  -312.822     0.150
    29.003  -323.970     0.150
    29.046  -324.691     0.150
    29.283    33.911     0.150
    29.351  -327.808     0.150
    29.742    30.683     0.150
    29.812  -333.422     0.150
    29.884  -336.979     0.150
    29.981  -337.133     0.150
    19.914   289.367     0.150
    20.424    51.267     0.150
    29.331  -329.067     0.150
    29.488  -331.107     0.150
    20.269   285.963     0.150
    20.556   279.708     0.150
    20.556   284.005     0.150
    20.100   282.396     0.150
    21.427   303.602     0.150
    14.863   213.143     0.150
    20.304   289.026     0.150
    27.439   299.151     0.150
    28.580    29.636     0.150
    28.627    29.606     0.150
    29.373   424.330     0.150
    29.373   203.611     0.150
    29.373   424.432     0.150
    29.569    27.240     0.150
    29.689    23.777     0.150
    29.708    25.786     0.150
    29.950    73.852     0.150
    29.950   310.555     0.150
    14.046   200.686     0.150
     7.073   625.432     0.150
    19.449   291.994     0.150
    19.449   500.154     0.150
    14.693   208.080     0.150
    20.432   258.563     0.150
    20.432   285.258     0.150
    20.431   258.563     0.150
    20.431   285.454     0.150
    23.863   288.245     0.150
    24.485   248.087     0.150
    25.253   299.360     0.150
    25.391   239.789     0.150
    26.908   292.781     0.150
    27.378  -308.776     0.150
    27.378   219.083     0.150
    27.380  -308.803     0.150
    27.380   219.060     0.150
    28.228   212.524     0.150
    28.620   209.562     0.150
    28.803   208.059     0.150
    29.436   302.585     0.150
    29.427   202.853     0.150
    29.959   197.156     0.150
    29.959   415.576     0.150
    29.959  -335.272     0.150
    29.959   197.151     0.150
    29.959   416.301     0.150
     7.171   618.999     0.150
    13.414   191.723     0.150
    13.414   554.172     0.150
    19.686   286.799     0.150
    19.699   286.543     0.150
    19.699   493.048     0.150
    19.699   287.314     0.150
    24.122   453.070     0.150
    25.782   437.837     0.150
    26.567  -288.439     0.150
    26.567   284.550     0.150
    26.900   428.335     0.150
    27.016   216.428     0.150
    27.016   428.448     0.150
    27.018   216.403     0.150
    27.018   428.417     0.150
    27.018   217.651     0.150
    29.162   295.966     0.150
    18.690    46.632     0.150
    19.427   299.971     0.150
    19.424   298.913     0.150
    25.423   239.098     0.150
    27.023   224.229     0.150
    27.326   221.190     0.150
    28.367   211.039     0.150
    28.370   211.020     0.150
    28.889   207.127     0.150
    29.286   203.652     0.150
    29.286   203.652     0.150
    29.354   202.717     0.150
     8.926   610.735     0.150
     8.926  2312.536     0.150
    17.438   247.723     0.150
    17.804   251.786     0.150
    18.472    45.472     0.150
    18.472   253.997     0.150
    18.802    47.933     0.150
    18.802   260.591     0.150
    18.961   256.635     0.150
    19.380    46.619     0.150
    19.380   265.910     0.150
    19.616    50.847     0.150
    19.616   266.074     0.150
    20.484    51.831     0.150
    20.484   277.210     0.150
    20.649    50.175     0.150
    20.649   261.874     0.150
    20.940   279.321     0.150
    20.940   491.270     0.150
    24.241   246.618     0.150
    24.337   461.612     0.150
    26.463   288.725     0.150
    26.938   222.680     0.150
    26.938   438.930     0.150
    26.753   225.040     0.150
    28.600   207.402     0.150
    29.720   197.201     0.150
    24.429    40.576     0.150
    26.578    36.587     0.150
    27.048    34.543     0.150
    28.210    35.019     0.150
    28.638    29.329     0.150
    29.344  -330.612     0.150
    19.233   295.442     0.150
    29.856   196.881     0.150
    26.872   217.772     0.150
    20.026   261.948     0.150
    20.026   291.946     0.150
    20.026   507.648     0.150
    24.887   245.197     0.150
    27.256   223.224     0.150
    20.105   286.791     0.150
    21.169   270.672     0.150
    29.243  -330.248     0.150
    19.585   288.270     0.150
    12.572   570.652     0.150
    18.679   300.560     0.150
    18.679   510.287     0.150
    20.094   276.545     0.150
    27.459   296.400     0.150
    27.902   212.712     0.150
    28.293  -315.017     0.150
    29.571  -331.340     0.150
    29.958  -336.272     0.150
    29.249   204.911     0.150
    20.334   285.453     0.150
    20.785   261.741     0.150
    20.785   284.142     0.150
    29.968  -338.962     0.150
    29.968   196.301     0.150
    19.671   295.866     0.150
    19.671   511.093     0.150
    21.451    52.966     0.150
    21.451   271.966     0.150
    21.451   299.966     0.150
    27.787   299.635     0.150
    28.959   429.982     0.150
    29.136   427.442     0.150
    19.674   294.961     0.150
     7.090   624.313     0.150
     7.090   836.910     0.150
    12.356   569.692     0.150
    13.281   559.694     0.150
    18.976   243.349     0.150
    18.976   504.576     0.150
    19.433   290.548     0.150
    19.433   499.997     0.150
    23.775   460.926     0.150
    23.959   248.946     0.150
    25.842   231.286     0.150
    26.033   229.342     0.150
    26.107   226.558     0.150
    26.376   226.396     0.150
    27.366   215.420     0.150
    27.366   215.064     0.150
    27.366   428.720     0.150
    27.366   670.123     0.150
    27.927   209.713     0.150
    27.936   211.796     0.150
    29.902   195.897     0.150
    29.613   199.986     0.150
    20.899   492.675     0.150
     8.595   607.688     0.150
    20.141   251.496     0.150
    24.855   244.241     0.150
    26.468   229.065     0.150
    26.682   289.196     0.150
    28.532   209.799     0.150
    28.075  -313.268     0.150
     7.104   620.021     0.150
    13.334   554.667     0.150
    19.592   287.260     0.150
    19.592   494.940     0.150
     7.580   606.986     0.150
    13.235   549.690     0.150
    13.870   190.133     0.150
    13.870   541.985     0.150
    13.870   189.487     0.150
    17.369   220.266     0.150
    18.279   227.222     0.150
    20.254   481.109     0.150
    26.524   424.536     0.150
     7.303   608.030     0.150
    13.072   549.773     0.150
    13.596   543.287     0.150
    20.029   277.035     0.150
    20.029   481.340     0.150
    20.822   499.138     0.150
    29.793   198.823     0.150
    29.793   421.073     0.150
    20.558   286.909     0.150
    20.478   266.337     0.150
    20.478   286.907     0.150
    20.478   503.408     0.150
    27.457    67.557     0.150
    27.457   302.557     0.150
    27.457   374.557     0.150
    29.061   205.528     0.150
    29.314   204.834     0.150
    29.314   426.075     0.150
    20.495   287.067     0.150
    20.495   503.428     0.150
    29.260   427.630     0.150
    19.127   301.652     0.150
    20.543   289.208     0.150
    29.201   208.474     0.150
    20.960   281.702     0.150
    20.656   283.892     0.150
    20.656   498.033     0.150
    20.712   279.921     0.150
     9.147   615.031     0.150
     9.147   613.351     0.150
    20.579   285.804     0.150
    20.579   503.077     0.150
    27.339   292.091     0.150
    27.819   217.162     0.150
    27.819   216.845     0.150
    29.426   202.939     0.150
    29.426   424.557     0.150
    29.836   299.448     0.150
    19.925   287.773     0.150
     8.621   612.247     0.150
    20.757   280.742     0.150
    20.757   492.242     0.150
    26.408   292.314     0.150
    26.879   437.768     0.150
    18.307   225.352     0.150
    27.409  -310.060     0.150
     8.476   611.768     0.150
    14.672   547.468     0.150
    20.638   280.441     0.150
    20.638   491.043     0.150
    26.441   291.626     0.150
    26.910   221.352     0.150
    20.528   288.386     0.150
    18.865   304.964     0.150
    18.865   520.042     0.150
    29.865   202.321     0.150
     1.002   711.058     0.150
     1.002   710.398     0.150
    20.488   282.330     0.150
    20.270   291.977     0.150
    19.558   496.017     0.150
    20.052   281.695     0.150
    20.052   488.613     0.150
    26.913   216.635     0.150
    27.092  -303.316     0.150
    20.831   283.704     0.150
    20.831   499.666     0.150
    27.687   218.278     0.150
    29.527   201.494     0.150
    29.527   423.633     0.150
    20.810   283.366     0.150
    29.553   201.030     0.150
    29.823  -332.308     0.150
    18.615   303.824     0.150
    29.161   205.084     0.150
    19.376   294.099     0.150
    19.376   505.419     0.150
    29.940   195.768     0.150
    20.142   483.790     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    18.748    37.709     0.200
    19.140    37.140     0.200
    19.625    36.482     0.200
    19.959    40.579     0.200
    21.817    35.891     0.200
    22.524    33.642     0.200
    26.073    29.324     0.200
    26.882    26.986     0.200
    27.464    22.997     0.200
    28.471    21.248     0.200
    28.858    22.531     0.200
    29.755    18.264     0.200
    29.955    20.119     0.200
    18.813    39.730     0.200
    18.907    39.631     0.200
    19.315    38.865     0.200
    20.340    40.903     0.200
    20.782    40.646     0.200
    21.529    40.627     0.200
    21.520    40.132     0.200
    21.740    38.568     0.200
    22.151    36.769     0.200
    23.905    36.005     0.200
    24.390    34.642     0.200
    25.553    32.666     0.200
    26.131    30.324     0.200
    26.228    29.696     0.200
    26.462    30.355     0.200
    26.899    29.366     0.200
    27.110    25.894     0.200
    27.180    28.286     0.200
    27.241    28.971     0.200
    27.948    26.016     0.200
    28.421    22.598     0.200
    28.904    23.764     0.200
    28.968    24.023     0.200
    29.602    18.818     0.200
    29.380    23.511     0.200
    29.438    20.731     0.200
    18.962    36.528     0.200
    19.224    38.471     0.200
    20.200    39.081     0.200
    20.469    38.940     0.200
    20.937    38.477     0.200
    21.620    36.510     0.200
    21.815    37.235     0.200
    21.984    36.261     0.200
    24.021    34.689     0.200
    24.539    33.438     0.200
    25.738    30.552     0.200
    26.257    27.592     0.200
    26.415    27.657     0.200
    26.972    25.054     0.200
    27.024    27.342     0.200
    27.349    27.155     0.200
    27.435    26.143     0.200
    28.142    24.697     0.200
    29.418    18.504     0.200
    29.136    21.595     0.200
    29.616    20.097     0.200
    19.336    37.948     0.200
    19.728    38.369     0.200
    20.664    39.444     0.200
    21.062    39.403     0.200
    21.881    39.242     0.200
    22.125    37.394     0.200
    22.487    37.177     0.200
    24.246    34.850     0.200
    24.680    34.579     0.200
    25.767    31.500     0.200
    26.458    29.130     0.200
    26.435    30.003     0.200
    26.651    29.477     0.200
    27.227    26.858     0.200
    27.485    24.847     0.200
    27.427    27.529     0.200
    28.117    22.475     0.200
    28.135    25.566     0.200
    29.085    22.976     0.200
    29.393    18.576     0.200
    29.219    22.811     0.200
    18.867    37.162     0.200
    19.031    37.249     0.200
    20.870    36.783     0.200
    21.404    36.551     0.200
    21.566    34.663     0.200
    21.946    35.230     0.200
    22.076    35.711     0.200
    24.389    32.022     0.200
    24.991    30.690     0.200
    26.276    26.698     0.200
    26.637    25.483     0.200
    26.650    25.037     0.200
    27.214    24.054     0.200
    27.871    19.082     0.200
    27.709    23.670     0.200
    27.996    23.025     0.200
    28.702    20.891     0.200
    29.635    18.600     0.200
    19.483    39.999     0.200
    19.855    36.657     0.200
    20.221    37.384     0.200
    21.079    38.370     0.200
    21.428    38.296     0.200
    22.336    36.703     0.200
    22.605    35.559     0.200
    22.879    34.362     0.200
    23.229    37.284     0.200
    24.678    32.171     0.200
    25.056    30.955     0.200
    26.056    29.694     0.200
    26.716    26.588     0.200
    26.875    26.926     0.200
    26.911    26.509     0.200
    27.926    22.464     0.200
    27.673    26.423     0.200
    27.683    26.307     0.200
    27.762    25.377     0.200
    29.551    20.508     0.200
    19.090    37.933     0.200
    19.649    38.810     0.200
    20.903    38.073     0.200
    21.111    37.439     0.200
    21.635    37.330     0.200
    21.666    34.971     0.200
    22.193    35.117     0.200
    22.324    35.585     0.200
    22.433    36.621     0.200
    23.282    35.704     0.200
    24.633    31.638     0.200
    25.225    29.733     0.200
    26.726    26.718     0.200
    27.019    23.802     0.200
    27.166    25.080     0.200
    27.631    20.661     0.200
    27.657    23.752     0.200
    28.197    23.055     0.200
    28.903    20.814     0.200
    28.952    20.934     0.200
    29.862    18.416     0.200
    29.858    18.563     0.200
    14.194    43.909     0.200
    19.337    39.895     0.200
    19.420    38.926     0.200
    19.742    38.170     0.200
    20.555    39.673     0.200
    20.884    39.836     0.200
    21.299    39.397     0.200
    22.080    37.878     0.200
    22.305    36.261     0.200
    22.400    35.146     0.200
    22.838    37.030     0.200
    24.914    32.711     0.200
    26.018    30.824     0.200
    26.687    28.324     0.200
    27.438    23.354     0.200
    27.443    24.295     0.200
    27.445    25.772     0.200
    27.681    26.316     0.200
    27.690    24.412     0.200
    28.389    24.357     0.200
    28.465    24.363     0.200
    28.801    23.443     0.200
    29.141    19.477     0.200
    29.463    21.516     0.200
    29.685    20.028     0.200
    29.820    21.349     0.200
    29.917    20.421     0.200
    17.439    41.710     0.200
    19.690    35.442     0.200
    19.856    34.503     0.200
    20.846    38.943     0.200
    21.657    31.482     0.200
    22.289    34.104     0.200
    22.836    32.728     0.200
    23.404    32.097     0.200
    24.236    32.385     0.200
    25.792    27.421     0.200
    26.422    25.175     0.200
    26.948    24.740     0.200
    27.684    23.252     0.200
    28.361    20.440     0.200
    28.524    19.346     0.200
    28.828    19.096     0.200
    29.123    19.359     0.200
    18.732    37.572     0.200
    20.782    36.951     0.200
    21.448    34.170     0.200
    21.331    39.536     0.200
    21.964    36.356     0.200
    22.584    35.915     0.200
    22.729    35.223     0.200
    24.293    32.569     0.200
    24.662    31.670     0.200
    24.914    32.724     0.200
    26.225    28.327     0.200
    26.510    25.105     0.200
    26.559    26.130     0.200
    27.192    24.136     0.200
    27.323    24.612     0.200
    27.655    24.734     0.200
    27.767    24.427     0.200
    28.612    21.068     0.200
    28.659    22.519     0.200
    28.698    22.569     0.200
    28.943    16.713     0.200
    29.067    19.156     0.200
    29.339    17.081     0.200
    29.571    19.383     0.200
    19.270    38.490     0.200
    20.097    39.242     0.200
    20.383    38.907     0.200
    20.836    38.921     0.200
    21.760    37.333     0.200
    22.079    35.118     0.200
    22.084    36.062     0.200
    22.336    37.517     0.200
    22.545    37.572     0.200
    23.942    34.271     0.200
    24.152    35.726     0.200
    24.399    33.035     0.200
    24.442    33.543     0.200
    25.620    31.087     0.200
    25.843    30.193     0.200
    26.173    28.941     0.200
    26.931    25.488     0.200
    27.048    24.124     0.200
    27.137    25.585     0.200
    27.313    26.441     0.200
    28.019    24.691     0.200
    28.079    24.793     0.200
    28.325    23.728     0.200
    28.430    24.199     0.200
    28.583    22.908     0.200
    29.028    22.626     0.200
    29.448    18.115     0.200
    29.451    21.882     0.200
    16.456    36.133     0.200
    16.719    35.467     0.200
    19.141    33.197     0.200
    19.488    33.846     0.200
    21.595    33.561     0.200
    21.794    31.242     0.200
    22.109    33.765     0.200
    22.802    31.078     0.200
    23.402    30.471     0.200
    23.401    30.986     0.200
    23.544    30.413     0.200
    25.469    26.950     0.200
    25.498    25.009     0.200
    25.702    25.130     0.200
    26.934    22.451     0.200
    27.376    19.702     0.200
    28.077    17.920     0.200
    28.014    16.648     0.200
    28.631    18.157     0.200
    29.337    15.709     0.200
    29.395    15.832     0.200
    29.729     9.634     0.200
    29.901    13.825     0.200
    15.973    43.941     0.200
    19.961    39.800     0.200
    20.023    39.184     0.200
    20.993    40.364     0.200
    22.614    37.144     0.200
    22.950    37.528     0.200
    23.222    35.448     0.200
    23.722    36.220     0.200
    23.841    36.928     0.200
    25.208    32.975     0.200
    25.538    31.718     0.200
    25.851    30.972     0.200
    26.791    28.806     0.200
    27.695    21.853     0.200
    27.571    26.997     0.200
    27.863    21.696     0.200
    28.127    24.112     0.200
    28.239    22.802     0.200
    28.211    25.126     0.200
    28.274    24.894     0.200
    28.897    23.728     0.200
    29.225    17.601     0.200
    29.043    22.621     0.200
    29.380    21.691     0.200
    29.991    20.055     0.200
    16.145    40.734     0.200
    16.480    40.819     0.200
    21.008    38.982     0.200
    22.621    36.652     0.200
    22.965    37.146     0.200
    23.197    35.830     0.200
    23.677    36.528     0.200
    24.352    35.153     0.200
    25.193    31.846     0.200
    25.232    32.683     0.200
    25.553    31.040     0.200
    25.875    30.685     0.200
    27.667    22.571     0.200
    28.062    24.661     0.200
    28.129    22.884     0.200
    28.218    22.844     0.200
    28.299    24.700     0.200
    29.199    18.396     0.200
    29.066    21.943     0.200
    29.401    21.834     0.200
    29.809    20.275     0.200
    16.073    44.250     0.200
    16.551    40.272     0.200
    20.930    39.568     0.200
    22.552    37.737     0.200
    23.204    35.534     0.200
    24.271    35.584     0.200
    25.120    31.770     0.200
    25.151    32.815     0.200
    25.476    31.823     0.200
    25.793    30.817     0.200
    27.747    21.818     0.200
    27.980    25.492     0.200
    28.212    22.595     0.200
    28.217    24.530     0.200
    28.834    24.027     0.200
    29.320    21.763     0.200
    29.727    20.707     0.200
    29.928    20.359     0.200
    18.682    41.094     0.200
    19.302    40.856     0.200
    20.370    40.495     0.200
    21.413    39.231     0.200
    21.916    38.451     0.200
    22.326    38.669     0.200
    22.720    36.370     0.200
    23.078    38.795     0.200
    23.184    38.256     0.200
    23.204    38.026     0.200
    23.445    37.313     0.200
    24.504    34.153     0.200
    24.757    34.801     0.200
    25.211    33.903     0.200
    25.905    31.008     0.200
    26.137    30.191     0.200
    26.166    30.654     0.200
    26.347    29.948     0.200
    27.038    28.982     0.200
    27.403    28.316     0.200
    27.526    27.083     0.200
    28.055    21.818     0.200
    27.747    26.412     0.200
    27.832    26.621     0.200
    28.437    20.761     0.200
    28.864    23.574     0.200
    29.642    18.393     0.200
    29.828    21.324     0.200
    29.977    20.278     0.200
    19.168    35.173     0.200
    21.394    34.892     0.200
    21.596    32.636     0.200
    22.567    33.206     0.200
    23.342    32.160     0.200
    25.272    26.641     0.200
    26.175    26.598     0.200
    26.552    20.701     0.200
    26.552    21.100     0.200
    26.794    24.281     0.200
    27.358    22.598     0.200
    28.218    17.260     0.200
    28.218    18.061     0.200
    28.496    20.016     0.200
    29.260    17.795     0.200
    29.854    14.367     0.200
    13.544    35.186     0.200
    21.737    33.072     0.200
    21.757    34.340     0.200
    22.968    31.208     0.200
    29.767    14.155     0.200
    15.032    35.596     0.200
    19.106    35.461     0.200
    19.356    34.140     0.200
    20.206    35.022     0.200
    20.978    36.013     0.200
    21.443    31.688     0.200
    21.449    35.509     0.200
    21.499    34.729     0.200
    21.529    34.584     0.200
    22.009    34.294     0.200
    22.579    32.331     0.200
    23.396    32.193     0.200
    25.296    26.622     0.200
    25.449    30.235     0.200
    25.975    26.700     0.200
    26.281    25.819     0.200
    26.897    24.033     0.200
    27.294    20.307     0.200
    27.410    21.649     0.200
    27.580    20.666     0.200
    27.743    19.462     0.200
    28.116    16.713     0.200
    28.116    17.111     0.200
    28.609    19.254     0.200
    29.320    15.859     0.200
    29.324    17.112     0.200
    29.367    17.116     0.200
    29.513    16.709     0.200
    29.566    16.284     0.200
    21.700    35.115     0.200
    21.741    34.841     0.200
    22.154    33.522     0.200
    22.537    31.558     0.200
    23.695    31.039     0.200
    27.510    20.518     0.200
    27.715    20.921     0.200
    29.241    16.311     0.200
    21.285    30.647     0.200
    21.820    26.311     0.200
    24.494    23.217     0.200
    21.291    35.817     0.200
    23.205    33.378     0.200
    26.915    22.453     0.200
    21.104    38.210     0.200
    21.565    35.987     0.200
    22.208    35.790     0.200
    22.523    34.306     0.200
    24.784    31.806     0.200
    24.967    30.696     0.200
    25.057    32.489     0.200
    25.781    29.515     0.200
    26.539    27.933     0.200
    26.587    25.378     0.200
    29.367    19.037     0.200
    15.797    36.539     0.200
    21.365    31.764     0.200
    21.490    36.472     0.200
    22.685    32.021     0.200
    19.198    34.923     0.200
    21.640    31.523     0.200
    21.640    35.125     0.200
    13.104    30.656     0.200
    20.010    27.869     0.200
    21.603    23.675     0.200
    18.795    39.598     0.200
    19.273    33.423     0.200
    20.246    38.462     0.200
    22.623    40.018     0.200
    23.423    38.263     0.200
    23.708    37.489     0.200
    24.224    36.503     0.200
    24.238    36.405     0.200
    24.397    35.945     0.200
    24.543    35.084     0.200
    24.723    35.615     0.200
    25.245    34.220     0.200
    25.545    29.823     0.200
    25.490    32.750     0.200
    27.741    27.157     0.200
    28.560    24.743     0.200
    19.063    34.716     0.200
    29.616    15.649     0.200
    19.687    34.427     0.200
    19.425    35.782     0.200
    19.076    35.854     0.200
    22.713    34.624     0.200
    19.536    34.591     0.200
    19.991    32.172     0.200
    24.173    27.571     0.200
    19.642    32.244     0.200
    20.034    36.150     0.200
    21.051    38.185     0.200
    21.514    37.224     0.200
    21.624    36.704     0.200
    21.944    36.415     0.200
    22.029    36.193     0.200
    22.074    36.932     0.200
    22.457    35.986     0.200
    22.579    36.005     0.200
    22.625    35.737     0.200
    22.751    33.917     0.200
    23.289    34.742     0.200
    23.635    33.049     0.200
    23.635    34.030     0.200
    23.679    33.493     0.200
    24.503    32.283     0.200
    25.147    30.924     0.200
    27.655    23.509     0.200
    28.098    21.520     0.200
    29.660    18.232     0.200
    29.756    17.397     0.200
    29.919    17.892     0.200
    18.579    37.786     0.200
    21.537    40.309     0.200
    21.667    38.491     0.200
    22.388    36.627     0.200
    22.450    36.348     0.200
    22.760    35.426     0.200
    23.540    35.062     0.200
    23.740    34.945     0.200
    24.647    33.295     0.200
    25.640    30.375     0.200
    26.045    28.600     0.200
    27.326    25.141     0.200
    28.785    21.526     0.200
    28.894    21.794     0.200
    28.989    20.969     0.200
    20.005    30.762     0.200
    20.257    35.106     0.200
    20.553    34.617     0.200
    23.795    32.570     0.200
    23.926    32.738     0.200
    25.427    28.898     0.200
    26.384    26.581     0.200
    26.810    21.846     0.200
    26.969    24.480     0.200
    27.946    20.935     0.200
    28.245    21.097     0.200
    28.533    21.269     0.200
    29.865    15.942     0.200
    29.950    17.128     0.200
    29.948    17.261     0.200
    18.618    35.061     0.200
    19.056    34.475     0.200
    20.270    34.566     0.200
    20.558    33.800     0.200
    21.345    36.668     0.200
    21.399    36.654     0.200
    21.626    37.174     0.200
    21.806    35.924     0.200
    21.918    35.903     0.200
    22.233    35.619     0.200
    22.323    35.518     0.200
    22.367    34.912     0.200
    22.508    35.657     0.200
    22.753    34.296     0.200
    22.872    34.391     0.200
    23.046    33.955     0.200
    23.054    35.142     0.200
    23.297    34.102     0.200
    23.549    33.254     0.200
    23.585    32.704     0.200
    23.607    33.655     0.200
    23.720    33.650     0.200
    23.799    32.601     0.200
    23.917    33.594     0.200
    23.931    32.067     0.200
    23.970    32.734     0.200
    24.136    33.341     0.200
    24.249    31.765     0.200
    24.487    31.394     0.200
    24.798    29.874     0.200
    25.428    29.584     0.200
    25.584    29.314     0.200
    26.474    20.561     0.200
    26.504    24.876     0.200
    26.506    26.339     0.200
    26.528    26.650     0.200
    26.806    21.695     0.200
    26.835    23.679     0.200
    26.881    23.555     0.200
    26.971    24.971     0.200
    27.321    22.942     0.200
    27.568    21.065     0.200
    27.728    21.637     0.200
    27.770    21.900     0.200
    27.861    21.698     0.200
    27.886    21.728     0.200
    28.165    17.133     0.200
    27.952    21.259     0.200
    27.961    22.188     0.200
    28.251    20.116     0.200
    28.381    20.288     0.200
    28.393    20.496     0.200
    28.416    20.122     0.200
    28.552    19.608     0.200
    28.611    20.423     0.200
    28.725    17.578     0.200
    28.736    20.156     0.200
    28.956    18.905     0.200
    29.349    12.711     0.200
    29.142    18.350     0.200
    29.198    18.707     0.200
    29.413    17.751     0.200
    29.475    17.981     0.200
    29.499    17.467     0.200
    29.629    16.625     0.200
    29.871    17.525     0.200
    29.917    16.346     0.200
    29.951    16.907     0.200
    19.466    39.487     0.200
    19.891    37.927     0.200
    23.122    38.197     0.200
    26.020    30.243     0.200
    29.205    23.106     0.200
    29.248    23.588     0.200
    29.632    22.775     0.200
    18.645    33.901     0.200
    19.082    33.669     0.200
    19.082    33.418     0.200
    20.223    35.357     0.200
    20.541    33.743     0.200
    20.855    37.447     0.200
    21.185    37.413     0.200
    21.331    36.917     0.200
    21.382    36.979     0.200
    21.449    36.389     0.200
    21.611    37.359     0.200
    21.794    37.125     0.200
    21.903    36.300     0.200
    21.956    36.234     0.200
    22.223    35.969     0.200
    22.261    36.045     0.200
    22.309    36.005     0.200
    22.317    36.132     0.200
    22.354    35.724     0.200
    22.496    35.875     0.200
    22.736    34.823     0.200
    22.859    34.995     0.200
    22.905    34.893     0.200
    23.029    34.356     0.200
    23.046    35.419     0.200
    23.287    34.657     0.200
    23.305    34.060     0.200
    23.533    33.696     0.200
    23.566    32.963     0.200
    23.596    34.018     0.200
    23.707    33.399     0.200
    23.726    31.888     0.200
    23.784    32.905     0.200
    23.890    32.740     0.200
    23.911    33.844     0.200
    23.910    32.146     0.200
    24.782    30.302     0.200
    25.409    27.012     0.200
    25.415    28.407     0.200
    25.423    27.990     0.200
    25.750    27.578     0.200
    25.880    27.108     0.200
    26.046    26.531     0.200
    26.382    25.123     0.200
    26.482    25.199     0.200
    26.499    26.382     0.200
    26.822    21.545     0.200
    26.813    23.990     0.200
    26.859    24.021     0.200
    26.961    24.943     0.200
    27.006    24.046     0.200
    27.298    23.490     0.200
    27.365    23.296     0.200
    27.546    21.716     0.200
    27.680    20.251     0.200
    27.706    21.655     0.200
    27.749    22.310     0.200
    27.876    19.849     0.200
    27.858    21.653     0.200
    27.865    21.684     0.200
    28.166    18.265     0.200
    27.931    21.576     0.200
    27.961    22.245     0.200
    28.171    18.939     0.200
    28.230    20.210     0.200
    28.362    20.355     0.200
    28.377    20.598     0.200
    28.393    20.299     0.200
    28.434    18.474     0.200
    28.517    19.534     0.200
    28.531    19.971     0.200
    28.641    18.593     0.200
    28.647    19.985     0.200
    28.656    18.513     0.200
    28.686    18.997     0.200
    28.760    19.806     0.200
    28.801    19.046     0.200
    28.934    19.326     0.200
    29.061    18.808     0.200
    29.368    11.635     0.200
    29.122    18.430     0.200
    29.198    18.342     0.200
    29.220    18.589     0.200
    29.410    17.593     0.200
    29.452    18.303     0.200
    29.607    17.201     0.200
    29.850    17.441     0.200
    29.880    16.749     0.200
    29.917    16.035     0.200
    29.940    16.854     0.200
    29.938    17.155     0.200
    18.613    34.540     0.200
    19.049    34.343     0.200
    19.049    35.262     0.200
    20.242    34.499     0.200
    20.505    34.272     0.200
    21.368    36.830     0.200
    23.744    33.029     0.200
    23.945    31.666     0.200
    23.948    33.435     0.200
    26.420    26.161     0.200
    26.786    21.472     0.200
    26.998    24.358     0.200
    27.896    21.291     0.200
    27.966    21.408     0.200
    27.999    21.971     0.200
    28.128    16.215     0.200
    28.413    20.246     0.200
    28.839    16.712     0.200
    29.333    11.755     0.200
    29.236    18.029     0.200
    29.955    15.922     0.200
    29.974    16.585     0.200
    19.343    34.156     0.200
    19.316    33.443     0.200
    19.316    34.021     0.200
    19.804    34.747     0.200
    20.387    33.350     0.200
    20.898    36.454     0.200
    21.005    36.775     0.200
    21.013    36.638     0.200
    21.185    36.317     0.200
    21.216    36.366     0.200
    21.248    36.247     0.200
    21.306    35.706     0.200
    21.491    36.372     0.200
    21.578    36.121     0.200
    21.780    35.142     0.200
    22.152    35.085     0.200
    22.147    35.484     0.200
    22.398    34.770     0.200
    22.412    35.367     0.200
    22.592    34.473     0.200
    22.779    34.434     0.200
    23.280    34.092     0.200
    23.404    31.920     0.200
    23.657    31.674     0.200
    23.733    31.138     0.200
    23.867    32.326     0.200
    23.863    32.319     0.200
    24.538    31.998     0.200
    24.652    30.133     0.200
    25.396    28.711     0.200
    26.367    25.585     0.200
    26.442    25.514     0.200
    26.532    25.763     0.200
    26.583    25.288     0.200
    26.626    23.371     0.200
    26.881    24.002     0.200
    26.970    21.324     0.200
    27.752    21.395     0.200
    27.846    20.215     0.200
    27.969    21.115     0.200
    27.970    21.153     0.200
    28.047    19.373     0.200
    28.172    18.298     0.200
    28.199    19.421     0.200
    28.244    19.683     0.200
    28.566    19.679     0.200
    29.081    17.893     0.200
    29.303    16.958     0.200
    29.400    17.009     0.200
    29.729    16.044     0.200
    29.795    16.567     0.200
    29.847    16.320     0.200
    19.061    35.302     0.200
    29.486    16.396     0.200
    15.827    35.385     0.200
    19.225    33.710     0.200
    19.791    34.152     0.200
    20.515    33.974     0.200
    21.029    35.580     0.200
    21.327    34.912     0.200
    21.383    35.320     0.200
    21.438    34.703     0.200
    22.335    34.727     0.200
    22.385    33.858     0.200
    23.131    32.981     0.200
    23.144    30.640     0.200
    23.568    31.473     0.200
    23.794    30.440     0.200
    23.852    30.077     0.200
    24.016    30.997     0.200
    25.074    26.167     0.200
    25.563    27.165     0.200
    26.537    24.484     0.200
    26.741    21.967     0.200
    27.034    22.513     0.200
    27.268    18.873     0.200
    27.623    19.929     0.200
    27.871    19.615     0.200
    28.017    19.426     0.200
    28.163    19.444     0.200
    28.324    18.229     0.200
    28.378    18.481     0.200
    28.730    17.563     0.200
    29.422    14.854     0.200
    29.572    15.765     0.200
    29.790    14.442     0.200
    29.857    14.867     0.200
    29.927    15.242     0.200
    29.983    14.591     0.200
    16.264    37.302     0.200
    18.666    35.003     0.200
    20.332    33.651     0.200
    20.630    33.759     0.200
    24.315    29.919     0.200
    24.478    31.474     0.200
    25.198    29.153     0.200
    25.597    26.886     0.200
    28.165    17.221     0.200
    28.115    19.859     0.200
    28.336    19.848     0.200
    28.761    18.666     0.200
    29.525    16.607     0.200
    16.552    34.109     0.200
    18.448    30.260     0.200
    19.817    31.630     0.200
    20.572    30.567     0.200
    21.008    31.794     0.200
    21.204    32.697     0.200
    21.315    32.532     0.200
    21.846    31.630     0.200
    22.015    30.688     0.200
    22.088    31.024     0.200
    22.637    30.024     0.200
    23.024    29.678     0.200
    23.071    29.062     0.200
    23.089    29.522     0.200
    23.296    28.708     0.200
    23.344    29.414     0.200
    23.432    28.386     0.200
    23.580    28.182     0.200
    23.594    28.320     0.200
    23.615    28.190     0.200
    24.106    27.176     0.200
    24.192    26.652     0.200
    24.230    26.546     0.200
    24.240    26.355     0.200
    24.493    25.471     0.200
    24.531    26.093     0.200
    24.590    24.766     0.200
    24.684    25.458     0.200
    24.872    25.942     0.200
    25.203    24.360     0.200
    25.490    22.832     0.200
    25.564    23.472     0.200
    25.835    21.354     0.200
    26.168    22.213     0.200
    27.236    18.725     0.200
    27.485    16.520     0.200
    27.691    17.318     0.200
    27.848    15.493     0.200
    28.609    14.224     0.200
    28.606    13.877     0.200
    28.744    14.809     0.200
    28.905    12.800     0.200
    29.083    12.704     0.200
    29.193    11.909     0.200
    29.475    13.025     0.200
    29.884    11.375     0.200
    19.285    34.960     0.200
    20.178    33.250     0.200
    20.581    27.278     0.200
    19.574    34.365     0.200
    19.584    34.803     0.200
    20.387    34.002     0.200
    23.593    31.654     0.200
    19.642    31.416     0.200
    24.123    26.366     0.200
    20.498    31.995     0.200
    13.097    30.464     0.200
    18.614    28.563     0.200
    20.011    28.055     0.200
    20.025    28.510     0.200
    14.666    38.962     0.200
    20.449    35.800     0.200
    20.925    35.700     0.200
    21.130    38.347     0.200
    21.215    39.701     0.200
    21.226    40.272     0.200
    21.271    38.965     0.200
    21.446    40.119     0.200
    21.573    38.774     0.200
    22.362    36.728     0.200
    22.646    37.112     0.200
    22.661    35.993     0.200
    22.673    36.773     0.200
    22.913    35.693     0.200
    22.989    36.315     0.200
    23.448    37.054     0.200
    23.650    36.296     0.200
    23.670    37.387     0.200
    24.151    34.527     0.200
    24.173    34.667     0.200
    24.554    34.553     0.200
    25.248    30.707     0.200
    25.552    30.034     0.200
    25.552    31.017     0.200
    25.547    29.764     0.200
    26.428    27.754     0.200
    26.977    26.591     0.200
    27.154    26.153     0.200
    27.236    26.158     0.200
    27.267    25.005     0.200
    27.809    24.613     0.200
    27.889    24.691     0.200
    28.241    23.965     0.200
    28.607    23.903     0.200
    28.586    22.927     0.200
    28.807    23.243     0.200
    28.897    22.558     0.200
    29.015    18.285     0.200
    29.207    21.309     0.200
    29.227    22.066     0.200
    29.282    21.582     0.200
    29.635    21.003     0.200
    29.975    20.383     0.200
    18.760    34.287     0.200
    20.383    33.764     0.200
    20.541    34.513     0.200
    20.971    37.052     0.200
    21.097    36.053     0.200
    21.594    35.481     0.200
    21.683    35.730     0.200
    22.200    34.854     0.200
    22.603    34.400     0.200
    22.647    34.842     0.200
    22.723    35.296     0.200
    22.777    34.883     0.200
    23.680    33.165     0.200
    23.770    32.679     0.200
    23.997    31.984     0.200
    24.082    31.423     0.200
    24.222    30.031     0.200
    24.394    31.685     0.200
    25.081    29.130     0.200
    25.503    26.192     0.200
    25.685    28.097     0.200
    26.521    24.828     0.200
    26.638    24.140     0.200
    27.127    22.622     0.200
    28.022    20.104     0.200
    28.113    19.668     0.200
    28.670    18.658     0.200
    28.677    19.278     0.200
    28.830    17.918     0.200
    19.769    36.325     0.200
    19.854    37.253     0.200
    19.860    36.958     0.200
    19.860    37.303     0.200
    20.708    37.633     0.200
    21.027    36.797     0.200
    21.151    38.255     0.200
    21.553    37.926     0.200
    21.560    37.727     0.200
    21.595    37.479     0.200
    21.731    36.871     0.200
    21.995    37.112     0.200
    22.097    37.112     0.200
    22.269    36.800     0.200
    22.514    36.419     0.200
    22.786    36.016     0.200
    22.837    35.691     0.200
    22.944    35.807     0.200
    23.033    35.449     0.200
    23.129    35.368     0.200
    23.191    35.805     0.200
    23.191    35.384     0.200
    23.707    35.061     0.200
    24.492    32.224     0.200
    24.638    33.666     0.200
    25.778    27.860     0.200
    26.190    28.695     0.200
    26.575    27.322     0.200
    27.258    21.630     0.200
    27.070    25.396     0.200
    27.171    26.189     0.200
    27.214    25.907     0.200
    27.568    21.567     0.200
    27.568    24.407     0.200
    27.630    24.479     0.200
    27.801    23.521     0.200
    27.822    24.331     0.200
    27.860    23.093     0.200
    27.946    23.546     0.200
    28.161    21.392     0.200
    28.375    22.557     0.200
    28.622    21.859     0.200
    28.955    17.688     0.200
    28.757    21.716     0.200
    29.173    20.663     0.200
    29.173    21.165     0.200
    29.340    20.360     0.200
    29.413    19.872     0.200
    29.604    20.073     0.200
    29.631    19.966     0.200
    29.734    19.203     0.200
    29.950    18.025     0.200
    19.712    34.882     0.200
    19.712    35.471     0.200
    19.896    36.763     0.200
    19.903    37.241     0.200
    21.255    34.339     0.200
    23.248    34.979     0.200
    24.693    31.702     0.200
    27.687    23.801     0.200
    29.395    18.598     0.200
    29.468    19.034     0.200
    20.051    31.130     0.200
    18.858    33.373     0.200
    20.158    32.945     0.200
    28.711    18.230     0.200
    18.463    37.434     0.200
    20.164    37.410     0.200
    20.975    34.393     0.200
    21.003    37.775     0.200
    21.153    38.317     0.200
    21.317    37.254     0.200
    21.333    38.806     0.200
    21.447    36.844     0.200
    22.231    35.115     0.200
    22.508    36.041     0.200
    22.537    35.513     0.200
    22.537    34.977     0.200
    22.531    36.288     0.200
    22.822    36.158     0.200
    23.527    33.699     0.200
    23.661    34.421     0.200
    23.725    33.090     0.200
    24.085    33.867     0.200
    24.461    33.195     0.200
    24.686    32.002     0.200
    25.111    29.427     0.200
    25.450    29.614     0.200
    25.457    29.682     0.200
    25.843    28.477     0.200
    26.288    26.737     0.200
    26.374    24.819     0.200
    26.839    25.740     0.200
    26.940    25.125     0.200
    27.022    25.022     0.200
    27.025    25.478     0.200
    27.111    25.993     0.200
    27.247    22.791     0.200
    27.605    24.351     0.200
    27.753    23.625     0.200
    27.756    23.397     0.200
    28.060    22.639     0.200
    28.106    22.534     0.200
    28.470    22.762     0.200
    29.113    16.995     0.200
    29.113    17.815     0.200
    29.075    20.075     0.200
    29.139    17.886     0.200
    29.197    19.655     0.200
    29.553    19.489     0.200
    29.744    18.157     0.200
    29.750    18.208     0.200
    29.882    18.513     0.200
    29.920    17.534     0.200
    29.977    17.611     0.200
    19.279    34.831     0.200
    19.680    33.234     0.200
    21.891    34.687     0.200
    23.416    31.861     0.200
    23.441    32.091     0.200
    26.322    24.232     0.200
    26.689    24.314     0.200
    26.851    21.507     0.200
    27.199    21.932     0.200
    27.920    19.728     0.200
    29.975    12.882     0.200
    29.940    15.801     0.200
    15.718    36.139     0.200
    19.314    33.926     0.200
    19.756    34.000     0.200
    19.766    34.297     0.200
    20.326    32.959     0.200
    23.747    31.337     0.200
    23.747    31.481     0.200
    25.433    27.602     0.200
    27.318    19.778     0.200
    20.170    31.687     0.200
    19.091    34.376     0.200
    19.103    34.743     0.200
    19.661    33.828     0.200
    19.996    32.731     0.200
    22.681    31.766     0.200
    23.552    31.103     0.200
    25.502    25.941     0.200
    28.143    18.034     0.200
    29.805    12.478     0.200
    29.826    15.088     0.200
    18.791    35.695     0.200
    20.752    33.849     0.200
    20.752    33.599     0.200
    22.115    34.845     0.200
    22.878    34.455     0.200
    22.878    34.057     0.200
    23.955    32.041     0.200
    24.751    30.932     0.200
    24.751    31.042     0.200
    25.059    29.947     0.200
    25.753    29.022     0.200
    25.758    26.467     0.200
    26.583    24.618     0.200
    26.633    24.141     0.200
    27.441    23.275     0.200
    28.816    17.533     0.200
    28.993    20.362     0.200
    29.101    19.626     0.200
    29.197    19.285     0.200
    29.366    18.406     0.200
    29.425    17.506     0.200
    20.311    34.885     0.200
    20.320    35.166     0.200
    20.559    33.877     0.200
    20.559    33.775     0.200
    23.428    33.488     0.200
    26.995    26.418     0.200
    28.422    22.370     0.200
    29.743    20.239     0.200
    29.976    18.450     0.200
    20.283    33.416     0.200
    20.813    32.961     0.200
    23.955    29.439     0.200
    24.470    28.406     0.200
    28.912    17.053     0.200
    18.493    37.934     0.200
    19.860    38.922     0.200
    20.033    39.342     0.200
    20.086    39.246     0.200
    20.216    38.767     0.200
    20.259    39.299     0.200
    20.453    39.040     0.200
    20.860    35.522     0.200
    20.860    35.343     0.200
    20.961    38.232     0.200
    20.979    38.529     0.200
    21.083    38.112     0.200
    21.253    39.136     0.200
    21.409    37.579     0.200
    21.413    37.589     0.200
    21.425    37.667     0.200
    21.429    37.419     0.200
    21.493    36.998     0.200
    21.530    37.258     0.200
    21.561    37.522     0.200
    21.809    37.161     0.200
    21.826    35.742     0.200
    21.952    36.786     0.200
    21.997    37.535     0.200
    22.027    37.532     0.200
    22.035    36.970     0.200
    22.285    37.335     0.200
    22.360    36.506     0.200
    22.377    35.987     0.200
    22.492    36.353     0.200
    22.552    36.612     0.200
    22.588    36.813     0.200
    22.605    36.077     0.200
    22.627    36.502     0.200
    22.636    35.568     0.200
    22.801    36.484     0.200
    22.806    36.764     0.200
    22.894    36.798     0.200
    22.903    36.269     0.200
    22.909    35.989     0.200
    22.919    37.180     0.200
    22.930    37.049     0.200
    22.973    36.038     0.200
    23.041    36.799     0.200
    23.111    36.382     0.200
    23.253    35.620     0.200
    23.357    35.033     0.200
    23.398    35.346     0.200
    23.412    35.980     0.200
    23.428    34.932     0.200
    23.623    34.672     0.200
    23.674    34.457     0.200
    23.692    34.212     0.200
    23.768    34.618     0.200
    23.768    35.489     0.200
    23.807    35.856     0.200
    23.820    34.218     0.200
    23.834    33.925     0.200
    23.828    34.489     0.200
    23.894    34.335     0.200
    24.054    34.718     0.200
    24.116    33.565     0.200
    24.291    33.269     0.200
    24.295    33.071     0.200
    24.320    33.298     0.200
    24.323    33.172     0.200
    24.346    32.755     0.200
    24.388    33.322     0.200
    24.475    33.015     0.200
    24.570    32.898     0.200
    24.569    33.500     0.200
    24.569    32.836     0.200
    24.598    33.066     0.200
    24.599    32.362     0.200
    24.613    32.709     0.200
    24.634    32.011     0.200
    24.642    32.349     0.200
    24.694    32.135     0.200
    24.691    32.121     0.200
    24.758    31.430     0.200
    24.774    32.395     0.200
    24.880    32.677     0.200
    24.893    32.317     0.200
    24.914    32.237     0.200
    24.930    32.387     0.200
    24.972    31.354     0.200
    24.970    31.843     0.200
    25.028    32.312     0.200
    25.090    30.674     0.200
    25.193    31.247     0.200
    25.200    30.132     0.200
    25.241    30.692     0.200
    25.244    30.856     0.200
    25.261    31.061     0.200
    25.285    30.317     0.200
    25.297    30.537     0.200
    25.333    30.765     0.200
    25.358    30.844     0.200
    25.457    30.718     0.200
    25.502    28.701     0.200
    25.555    30.242     0.200
    25.566    29.800     0.200
    25.566    30.409     0.200
    25.586    29.686     0.200
    25.584    30.690     0.200
    25.692    29.505     0.200
    25.695    30.062     0.200
    25.704    30.083     0.200
    25.719    30.152     0.200
    25.781    30.232     0.200
    25.799    29.947     0.200
    25.795    30.442     0.200
    25.924    29.758     0.200
    25.946    31.266     0.200
    26.017    29.674     0.200
    26.140    29.179     0.200
    26.172    29.232     0.200
    26.190    28.408     0.200
    26.220    28.747     0.200
    26.239    29.291     0.200
    26.272    28.822     0.200
    26.281    28.348     0.200
    26.341    28.385     0.200
    26.436    28.227     0.200
    26.490    28.064     0.200
    26.552    27.679     0.200
    26.577    27.185     0.200
    26.606    27.079     0.200
    26.602    27.272     0.200
    26.677    27.125     0.200
    26.676    27.311     0.200
    26.864    27.113     0.200
    27.137    22.268     0.200
    26.972    26.299     0.200
    26.994    25.813     0.200
    26.997    26.474     0.200
    27.058    25.927     0.200
    27.066    25.605     0.200
    27.088    25.720     0.200
    27.106    26.186     0.200
    27.132    25.749     0.200
    27.271    25.384     0.200
    27.289    25.615     0.200
    27.364    25.413     0.200
    27.377    24.883     0.200
    27.434    24.632     0.200
    27.455    25.435     0.200
    27.470    24.729     0.200
    27.558    24.722     0.200
    27.588    24.726     0.200
    27.634    24.743     0.200
    27.657    24.472     0.200
    27.711    22.476     0.200
    27.737    25.118     0.200
    27.828    24.926     0.200
    27.832    24.548     0.200
    28.063    20.161     0.200
    28.009    23.630     0.200
    28.110    23.438     0.200
    28.195    21.984     0.200
    28.201    23.629     0.200
    28.513    18.520     0.200
    28.513    18.660     0.200
    28.329    23.537     0.200
    28.382    22.763     0.200
    28.536    22.360     0.200
    28.619    22.457     0.200
    28.632    22.025     0.200
    28.885    22.996     0.200
    28.885    20.672     0.200
    28.891    21.242     0.200
    28.948    22.067     0.200
    28.949    21.187     0.200
    28.974    20.376     0.200
    29.117    20.643     0.200
    29.152    20.201     0.200
    29.236    20.099     0.200
    29.251    19.937     0.200
    29.364    19.325     0.200
    29.492    19.465     0.200
    29.671    18.648     0.200
    29.732    18.275     0.200
    29.757    18.548     0.200
    29.964    18.129     0.200
    19.351    36.245     0.200
    19.447    40.473     0.200
    19.971    39.105     0.200
    19.994    38.489     0.200
    20.087    38.145     0.200
    20.269    38.143     0.200
    20.426    37.762     0.200
    20.537    39.595     0.200
    20.593    38.111     0.200
    20.617    39.288     0.200
    20.665    38.642     0.200
    20.899    38.474     0.200
    21.065    38.033     0.200
    21.106    38.016     0.200
    21.259    38.009     0.200
    21.372    38.037     0.200
    21.636    34.875     0.200
    21.636    34.715     0.200
    21.474    38.970     0.200
    21.562    37.492     0.200
    21.647    38.899     0.200
    21.668    37.231     0.200
    21.722    37.192     0.200
    21.754    38.241     0.200
    21.851    36.949     0.200
    21.862    37.070     0.200
    21.870    38.189     0.200
    21.904    38.081     0.200
    21.929    37.259     0.200
    22.050    37.233     0.200
    22.102    37.838     0.200
    22.114    37.279     0.200
    22.350    36.441     0.200
    22.474    37.887     0.200
    22.477    36.068     0.200
    22.492    36.677     0.200
    22.619    36.255     0.200
    22.648    36.735     0.200
    22.665    37.365     0.200
    22.682    37.317     0.200
    22.764    36.247     0.200
    22.765    36.415     0.200
    22.784    36.377     0.200
    22.787    37.845     0.200
    22.850    35.895     0.200
    22.883    35.515     0.200
    22.892    36.799     0.200
    22.925    35.464     0.200
    23.025    35.565     0.200
    23.055    35.801     0.200
    23.072    35.510     0.200
    23.121    35.461     0.200
    23.131    36.323     0.200
    23.165    36.051     0.200
    23.182    35.523     0.200
    23.284    35.533     0.200
    23.451    35.960     0.200
    23.571    35.770     0.200
    23.604    34.556     0.200
    23.616    36.725     0.200
    23.676    35.772     0.200
    23.709    35.404     0.200
    23.751    34.431     0.200
    23.863    34.280     0.200
    23.928    34.521     0.200
    23.935    34.080     0.200
    24.187    33.193     0.200
    24.235    33.813     0.200
    24.258    33.273     0.200
    24.272    32.730     0.200
    24.357    33.011     0.200
    24.439    32.668     0.200
    24.441    34.081     0.200
    24.441    34.838     0.200
    24.442    32.906     0.200
    24.467    33.355     0.200
    24.536    32.431     0.200
    24.579    32.804     0.200
    24.595    32.391     0.200
    24.652    31.373     0.200
    24.655    32.959     0.200
    24.759    31.474     0.200
    24.785    32.037     0.200
    24.809    31.596     0.200
    24.872    31.809     0.200
    24.994    31.666     0.200
    25.039    31.493     0.200
    25.073    31.158     0.200
    25.077    31.339     0.200
    25.077    31.147     0.200
    25.111    32.012     0.200
    25.164    30.804     0.200
    25.277    30.632     0.200
    25.287    30.731     0.200
    25.323    30.755     0.200
    25.387    31.799     0.200
    25.457    30.533     0.200
    25.482    30.840     0.200
    25.547    30.978     0.200
    25.560    34.079     0.200
    25.625    30.592     0.200
    25.652    29.646     0.200
    25.720    29.166     0.200
    25.723    29.422     0.200
    25.809    29.239     0.200
    25.810    29.112     0.200
    25.816    29.219     0.200
    25.873    29.815     0.200
    25.886    29.534     0.200
    25.904    29.236     0.200
    25.908    29.471     0.200
    26.037    29.710     0.200
    26.049    28.871     0.200
    26.137    28.992     0.200
    26.215    28.538     0.200
    26.346    28.445     0.200
    26.366    27.269     0.200
    26.378    27.983     0.200
    26.457    28.271     0.200
    26.613    26.983     0.200
    26.629    27.564     0.200
    26.637    27.293     0.200
    26.652    27.377     0.200
    26.679    26.806     0.200
    26.734    27.538     0.200
    26.794    26.624     0.200
    26.861    27.182     0.200
    26.860    26.950     0.200
    26.921    26.528     0.200
    26.955    26.794     0.200
    26.956    26.691     0.200
    26.957    26.189     0.200
    26.982    26.749     0.200
    27.007    26.672     0.200
    27.020    26.795     0.200
    27.121    25.863     0.200
    27.117    26.254     0.200
    27.146    26.170     0.200
    27.187    26.571     0.200
    27.525    21.547     0.200
    27.327    24.935     0.200
    27.679    21.551     0.200
    27.342    25.018     0.200
    27.342    25.307     0.200
    27.357    25.333     0.200
    27.364    25.344     0.200
    27.407    25.594     0.200
    27.433    25.783     0.200
    27.454    25.718     0.200
    27.526    25.276     0.200
    27.526    25.663     0.200
    27.539    24.984     0.200
    27.556    25.070     0.200
    27.629    24.487     0.200
    27.635    26.130     0.200
    27.642    25.071     0.200
    27.751    24.936     0.200
    27.743    24.148     0.200
    27.743    24.602     0.200
    27.753    25.157     0.200
    27.765    25.240     0.200
    27.791    24.659     0.200
    27.788    24.945     0.200
    27.803    24.638     0.200
    27.807    24.753     0.200
    28.154    19.726     0.200
    28.154    19.944     0.200
    27.876    24.308     0.200
    27.886    24.665     0.200
    28.089    23.842     0.200
    28.102    23.679     0.200
    28.285    21.727     0.200
    28.163    23.659     0.200
    28.213    23.815     0.200
    28.249    23.922     0.200
    28.283    23.328     0.200
    28.289    23.296     0.200
    28.319    23.472     0.200
    28.333    23.596     0.200
    28.379    22.823     0.200
    28.405    23.089     0.200
    28.410    22.920     0.200
    28.514    22.665     0.200
    28.520    23.647     0.200
    28.611    22.763     0.200
    28.692    20.647     0.200
    28.693    22.574     0.200
    28.711    22.623     0.200
    28.716    22.383     0.200
    28.727    22.718     0.200
    28.778    22.071     0.200
    28.820    21.208     0.200
    28.881    21.780     0.200
    28.902    23.679     0.200
    28.916    22.167     0.200
    29.030    21.906     0.200
    29.057    20.767     0.200
    29.060    21.666     0.200
    29.060    22.233     0.200
    29.069    23.329     0.200
    29.081    22.201     0.200
    29.136    21.930     0.200
    29.150    21.266     0.200
    29.166    21.488     0.200
    29.166    20.644     0.200
    29.196    21.648     0.200
    29.203    21.877     0.200
    29.203    20.782     0.200
    29.243    21.004     0.200
    29.252    21.383     0.200
    29.342    20.714     0.200
    29.342    21.058     0.200
    29.354    20.680     0.200
    29.387    21.091     0.200
    29.463    21.016     0.200
    29.495    20.108     0.200
    29.502    20.796     0.200
    29.502    19.851     0.200
    29.506    20.529     0.200
    29.551    20.389     0.200
    29.573    19.872     0.200
    29.588    21.070     0.200
    29.601    20.042     0.200
    29.623    19.969     0.200
    29.624    19.723     0.200
    29.635    19.930     0.200
    29.677    19.532     0.200
    29.679    19.788     0.200
    29.827    19.278     0.200
    29.846    20.445     0.200
    29.947    19.384     0.200
    20.238    32.136     0.200
    20.564    34.921     0.200
    20.592    33.138     0.200
    20.592    33.029     0.200
    21.073    35.517     0.200
    21.402    35.014     0.200
    21.557    34.372     0.200
    21.712    35.263     0.200
    21.846    34.417     0.200
    22.636    32.957     0.200
    22.681    31.892     0.200
    22.909    32.609     0.200
    22.930    32.550     0.200
    22.940    31.878     0.200
    23.206    32.550     0.200
    23.557    31.601     0.200
    23.928    30.302     0.200
    24.066    31.297     0.200
    24.107    29.524     0.200
    24.392    29.518     0.200
    24.402    28.920     0.200
    24.416    28.963     0.200
    24.599    29.108     0.200
    24.731    28.340     0.200
    24.773    27.577     0.200
    24.797    28.106     0.200
    24.870    27.641     0.200
    24.866    29.555     0.200
    24.943    29.017     0.200
    25.030    27.159     0.200
    25.134    27.295     0.200
    25.271    26.193     0.200
    25.387    25.894     0.200
    25.503    25.993     0.200
    25.585    26.001     0.200
    25.631    25.588     0.200
    25.637    26.239     0.200
    25.657    25.101     0.200
    25.860    24.625     0.200
    25.856    26.262     0.200
    25.861    26.238     0.200
    25.996    24.987     0.200
    26.019    24.391     0.200
    26.208    23.625     0.200
    26.249    24.718     0.200
    26.324    23.211     0.200
    26.403    22.695     0.200
    26.403    22.520     0.200
    26.443    23.619     0.200
    26.475    24.125     0.200
    26.524    24.046     0.200
    26.586    23.529     0.200
    26.614    22.994     0.200
    26.640    22.386     0.200
    26.681    22.552     0.200
    26.845    20.157     0.200
    26.816    22.959     0.200
    26.872    22.713     0.200
    26.881    22.832     0.200
    26.898    22.138     0.200
    26.909    22.494     0.200
    26.907    22.609     0.200
    26.922    21.869     0.200
    26.922    21.748     0.200
    26.943    21.930     0.200
    26.982    22.610     0.200
    26.986    21.746     0.200
    27.081    21.778     0.200
    27.180    21.736     0.200
    27.296    20.392     0.200
    27.298    21.674     0.200
    27.346    21.738     0.200
    27.358    20.817     0.200
    27.369    21.325     0.200
    27.396    21.318     0.200
    27.410    21.414     0.200
    27.417    21.217     0.200
    27.421    21.256     0.200
    27.474    21.013     0.200
    27.511    20.731     0.200
    27.511    21.266     0.200
    27.576    20.234     0.200
    27.668    20.640     0.200
    27.680    20.784     0.200
    27.760    18.879     0.200
    27.760    17.898     0.200
    27.738    20.939     0.200
    27.751    20.553     0.200
    27.770    20.989     0.200
    27.817    20.076     0.200
    27.818    20.680     0.200
    27.924    19.572     0.200
    28.036    19.328     0.200
    28.111    18.842     0.200
    28.161    19.901     0.200
    28.168    19.568     0.200
    28.210    16.063     0.200
    28.210    15.915     0.200
    28.182    19.681     0.200
    28.310    19.791     0.200
    28.327    19.330     0.200
    28.347    18.411     0.200
    28.362    18.618     0.200
    28.410    19.481     0.200
    28.429    18.749     0.200
    28.465    18.950     0.200
    28.613    19.192     0.200
    28.634    18.607     0.200
    28.715    19.260     0.200
    28.726    17.549     0.200
    28.744    17.678     0.200
    28.746    18.108     0.200
    28.783    17.878     0.200
    28.781    18.265     0.200
    28.873    18.375     0.200
    28.888    18.861     0.200
    28.901    17.469     0.200
    28.913    17.633     0.200
    28.978    16.808     0.200
    29.041    18.067     0.200
    29.069    16.479     0.200
    29.098    17.722     0.200
    29.130    15.989     0.200
    29.135    17.870     0.200
    29.155    15.978     0.200
    29.166    16.938     0.200
    29.197    16.710     0.200
    29.216    17.325     0.200
    29.219    17.727     0.200
    29.240    16.586     0.200
    29.252    16.731     0.200
    29.273    16.217     0.200
    29.352    16.003     0.200
    29.395    15.590     0.200
    29.420    16.362     0.200
    29.449    16.712     0.200
    29.463    15.527     0.200
    29.523    16.300     0.200
    29.535    15.978     0.200
    29.551    15.458     0.200
    29.569    15.729     0.200
    29.669    16.075     0.200
    29.719    15.259     0.200
    29.764    15.895     0.200
    29.849    14.902     0.200
    29.872    14.825     0.200
    29.931    14.438     0.200
    29.936    15.912     0.200
    29.956    14.819     0.200
    18.884    34.579     0.200
    20.385    34.120     0.200
    20.395    33.595     0.200
    24.109    31.075     0.200
    24.511    29.646     0.200
    24.815    30.361     0.200
    24.829    28.856     0.200
    25.182    27.770     0.200
    25.476    27.260     0.200
    25.614    26.916     0.200
    25.610    28.155     0.200
    25.696    26.413     0.200
    25.795    25.719     0.200
    25.832    26.220     0.200
    25.949    25.867     0.200
    26.025    25.805     0.200
    26.065    25.181     0.200
    26.077    25.989     0.200
    26.225    24.424     0.200
    26.245    24.410     0.200
    26.543    23.801     0.200
    26.697    23.239     0.200
    26.693    23.449     0.200
    26.772    22.980     0.200
    26.802    22.797     0.200
    26.837    23.026     0.200
    26.947    22.458     0.200
    27.091    19.752     0.200
    27.038    21.589     0.200
    27.140    22.030     0.200
    27.185    22.164     0.200
    27.193    22.358     0.200
    27.328    21.217     0.200
    27.509    21.173     0.200
    27.642    21.147     0.200
    27.646    20.738     0.200
    27.645    21.788     0.200
    27.661    21.104     0.200
    27.673    21.364     0.200
    27.860    20.371     0.200
    27.959    19.047     0.200
    27.959    18.676     0.200
    27.920    20.430     0.200
    27.928    20.954     0.200
    27.961    20.658     0.200
    27.983    20.376     0.200
    28.002    19.802     0.200
    28.035    20.142     0.200
    28.098    19.849     0.200
    28.253    18.836     0.200
    28.417    18.887     0.200
    28.422    19.145     0.200
    28.493    19.104     0.200
    28.532    19.060     0.200
    28.703    18.375     0.200
    28.722    18.139     0.200
    28.786    18.370     0.200
    28.809    18.427     0.200
    28.814    18.593     0.200
    28.837    17.882     0.200
    28.860    18.134     0.200
    28.926    17.702     0.200
    28.919    18.511     0.200
    29.030    18.219     0.200
    29.043    17.589     0.200
    29.199    17.035     0.200
    29.222    17.033     0.200
    29.214    17.340     0.200
    29.373    16.923     0.200
    29.476    16.017     0.200
    29.501    16.086     0.200
    29.553    16.387     0.200
    29.669    15.636     0.200
    29.706    15.431     0.200
    29.743    15.484     0.200
    29.739    15.838     0.200
    29.788    15.643     0.200
    20.396    38.052     0.200
    27.704    23.856     0.200
    19.550    35.777     0.200
    19.559    36.084     0.200
    23.387    31.904     0.200
    27.779    18.548     0.200
    29.743    17.868     0.200
    20.044    28.072     0.200
    26.564    13.599     0.200
    19.222    34.686     0.200
    19.554    32.916     0.200
    22.450    33.166     0.200
    22.790    32.210     0.200
    23.645    30.820     0.200
    23.645    30.629     0.200
    23.659    30.910     0.200
    24.276    29.161     0.200
    24.715    28.205     0.200
    25.110    26.724     0.200
    25.568    27.125     0.200
    26.178    23.984     0.200
    26.517    22.985     0.200
    27.386    20.657     0.200
    27.494    18.450     0.200
    27.593    19.638     0.200
    27.624    19.745     0.200
    27.624    19.409     0.200
    27.625    20.018     0.200
    27.658    20.279     0.200
    27.779    19.398     0.200
    27.895    20.080     0.200
    28.176    18.375     0.200
    28.230    19.665     0.200
    28.272    17.957     0.200
    28.628    17.089     0.200
    28.735    16.637     0.200
    29.064    15.957     0.200
    29.121    17.113     0.200
    29.135    16.069     0.200
    29.138    15.624     0.200
    29.449    15.009     0.200
    29.455    15.438     0.200
    29.677    14.211     0.200
    29.757    14.986     0.200
    29.764    15.424     0.200
    29.879    14.102     0.200
    29.904    14.124     0.200
    29.905    15.247     0.200
    29.958    14.626     0.200
    29.968    14.670     0.200
    19.982    36.449     0.200
    19.982    36.649     0.200
    19.942    38.219     0.200
    20.417    39.249     0.200
    20.494    38.946     0.200
    20.933    40.104     0.200
    21.300    38.265     0.200
    21.496    38.328     0.200
    21.528    35.748     0.200
    21.603    37.615     0.200
    21.686    37.517     0.200
    21.839    37.622     0.200
    22.029    36.884     0.200
    22.405    36.926     0.200
    22.449    36.860     0.200
    22.473    36.544     0.200
    22.530    34.866     0.200
    22.533    36.480     0.200
    22.595    36.686     0.200
    22.588    36.540     0.200
    22.589    35.969     0.200
    22.609    35.685     0.200
    22.675    35.522     0.200
    22.705    36.431     0.200
    22.751    36.254     0.200
    22.861    37.165     0.200
    22.900    36.765     0.200
    22.945    36.109     0.200
    22.954    36.059     0.200
    22.954    35.872     0.200
    23.128    36.118     0.200
    23.429    35.175     0.200
    23.490    36.681     0.200
    23.511    36.201     0.200
    23.735    36.125     0.200
    23.761    35.045     0.200
    23.836    35.736     0.200
    23.912    35.402     0.200
    24.113    34.674     0.200
    24.264    33.801     0.200
    24.278    34.819     0.200
    24.278    34.623     0.200
    24.271    34.348     0.200
    24.290    34.486     0.200
    24.459    34.205     0.200
    24.478    34.030     0.200
    24.621    33.641     0.200
    24.680    33.533     0.200
    24.817    32.398     0.200
    24.846    32.574     0.200
    24.899    31.931     0.200
    25.110    31.560     0.200
    25.225    31.957     0.200
    25.310    31.514     0.200
    25.379    31.784     0.200
    25.543    32.323     0.200
    25.543    30.801     0.200
    25.628    30.869     0.200
    25.867    30.067     0.200
    25.872    29.202     0.200
    26.686    27.524     0.200
    26.699    26.926     0.200
    26.777    26.805     0.200
    26.856    27.583     0.200
    26.974    27.186     0.200
    27.165    25.646     0.200
    27.180    26.706     0.200
    27.223    26.023     0.200
    27.351    25.553     0.200
    27.351    25.755     0.200
    27.372    25.614     0.200
    27.379    25.121     0.200
    27.469    25.799     0.200
    27.672    21.707     0.200
    27.566    25.741     0.200
    27.853    21.495     0.200
    27.853    21.095     0.200
    27.702    24.712     0.200
    27.720    24.442     0.200
    27.892    24.184     0.200
    28.045    24.258     0.200
    28.116    23.325     0.200
    28.143    23.587     0.200
    28.157    23.930     0.200
    28.328    19.596     0.200
    28.328    20.056     0.200
    28.206    22.270     0.200
    28.249    23.468     0.200
    28.311    22.807     0.200
    28.357    23.441     0.200
    28.515    23.123     0.200
    28.530    23.134     0.200
    28.598    22.637     0.200
    28.611    22.914     0.200
    28.751    22.006     0.200
    28.859    22.452     0.200
    28.892    22.023     0.200
    28.904    23.318     0.200
    28.904    21.375     0.200
    28.949    21.969     0.200
    28.985    21.713     0.200
    29.027    21.908     0.200
    29.038    22.259     0.200
    29.058    21.159     0.200
    29.148    21.347     0.200
    29.211    21.335     0.200
    29.227    21.291     0.200
    29.230    21.767     0.200
    29.246    21.134     0.200
    29.333    21.975     0.200
    29.364    20.375     0.200
    29.396    20.674     0.200
    29.425    20.841     0.200
    29.448    20.775     0.200
    29.466    20.195     0.200
    29.554    19.739     0.200
    29.605    20.010     0.200
    29.648    19.892     0.200
    29.684    19.956     0.200
    29.686    19.462     0.200
    29.804    19.520     0.200
    29.821    19.295     0.200
    29.844    19.338     0.200
    29.896    18.397     0.200
    29.908    19.311     0.200
    29.951    18.505     0.200
    29.989    17.517     0.200
    29.989    18.288     0.200
    19.937    39.602     0.200
    22.567    36.304     0.200
    24.199    35.466     0.200
    28.245    22.143     0.200
    28.397    19.569     0.200
    28.907    23.406     0.200
    27.244    20.662     0.200
    28.296    16.818     0.200
    14.329    35.458     0.200
    19.302    32.428     0.200
    19.430    31.753     0.200
    19.430    31.191     0.200
    19.823    32.211     0.200
    19.823    32.488     0.200
    20.779    33.358     0.200
    22.026    33.165     0.200
    22.589    30.502     0.200
    22.912    28.859     0.200
    23.491    28.417     0.200
    23.655    27.953     0.200
    23.710    28.213     0.200
    23.782    27.167     0.200
    23.782    26.331     0.200
    23.800    25.049     0.200
    24.265    26.777     0.200
    24.857    25.313     0.200
    24.947    24.237     0.200
    25.250    23.946     0.200
    25.579    23.381     0.200
    25.878    22.442     0.200
    26.014    19.363     0.200
    26.014    20.214     0.200
    26.077    22.059     0.200
    26.314    21.206     0.200
    26.584    18.859     0.200
    26.653    20.027     0.200
    26.710    21.081     0.200
    26.910    18.807     0.200
    26.910    18.007     0.200
    27.357    16.180     0.200
    27.521    18.050     0.200
    27.721    16.828     0.200
    27.755    16.236     0.200
    27.755    16.615     0.200
    27.766    17.349     0.200
    27.794    17.163     0.200
    27.908    16.560     0.200
    28.177    15.802     0.200
    28.272    15.961     0.200
    28.306    15.700     0.200
    28.370    15.558     0.200
    28.370    15.957     0.200
    28.400    14.930     0.200
    28.759    14.182     0.200
    28.864    13.876     0.200
    28.998    14.348     0.200
    29.194    13.447     0.200
    29.255    14.301     0.200
    29.267    13.372     0.200
    29.580    12.106     0.200
    29.588    12.838     0.200
    29.739    13.884     0.200
    29.739    13.423     0.200
    29.797    12.436     0.200
    29.806    11.698     0.200
    29.951    10.656     0.200
    19.172    34.101     0.200
    19.943    33.477     0.200
    26.152    21.176     0.200
    26.518    21.084     0.200
    27.512    17.972     0.200
    19.443    37.810     0.200
    19.443    37.138     0.200
    20.146    37.400     0.200
    21.093    36.156     0.200
    21.093    35.086     0.200
    21.335    38.538     0.200
    21.536    38.788     0.200
    21.907    37.759     0.200
    21.948    37.747     0.200
    22.031    37.840     0.200
    22.115    37.586     0.200
    22.157    36.743     0.200
    22.167    37.467     0.200
    22.197    36.805     0.200
    22.258    36.916     0.200
    22.313    36.941     0.200
    22.498    37.264     0.200
    22.553    37.045     0.200
    23.062    35.886     0.200
    23.071    36.783     0.200
    23.077    36.256     0.200
    23.152    35.824     0.200
    23.171    35.215     0.200
    23.261    35.578     0.200
    23.514    35.108     0.200
    23.514    34.733     0.200
    23.580    35.311     0.200
    23.754    35.456     0.200
    24.128    34.909     0.200
    24.157    35.019     0.200
    24.165    35.224     0.200
    24.362    33.581     0.200
    24.366    33.485     0.200
    24.545    34.201     0.200
    24.818    32.195     0.200
    24.851    32.149     0.200
    24.889    32.605     0.200
    24.927    33.318     0.200
    24.927    32.771     0.200
    25.028    31.811     0.200
    25.110    32.039     0.200
    25.119    32.922     0.200
    25.325    31.804     0.200
    25.365    30.684     0.200
    25.445    30.161     0.200
    25.499    30.781     0.200
    25.536    30.558     0.200
    25.660    30.172     0.200
    25.879    30.203     0.200
    26.017    29.970     0.200
    26.101    28.717     0.200
    26.493    28.635     0.200
    27.001    22.706     0.200
    27.253    24.474     0.200
    27.724    21.574     0.200
    27.681    23.773     0.200
    27.721    23.779     0.200
    27.878    24.036     0.200
    27.945    24.238     0.200
    28.077    21.450     0.200
    28.077    21.653     0.200
    28.195    22.486     0.200
    28.236    22.873     0.200
    28.392    22.576     0.200
    28.665    21.912     0.200
    28.680    21.113     0.200
    29.079    21.533     0.200
    29.117    21.099     0.200
    29.142    20.604     0.200
    29.252    20.286     0.200
    29.430    20.077     0.200
    29.468    21.711     0.200
    29.468    20.954     0.200
    29.475    19.694     0.200
    29.479    19.164     0.200
    29.597    20.419     0.200
    29.605    20.257     0.200
    29.631    19.679     0.200
    29.758    19.269     0.200
    29.782    19.278     0.200
    29.898    18.849     0.200
    29.968    19.152     0.200
    23.013    35.786     0.200
    24.889    32.595     0.200
    28.504    21.028     0.200
    29.239    20.132     0.200
    29.563    19.324     0.200
    20.377    32.349     0.200
    26.906    17.715     0.200
    16.705    36.052     0.200
    19.821    28.872     0.200
    20.812    30.603     0.200
    24.749    26.182     0.200
    25.665    19.142     0.200
    25.976    19.545     0.200
    26.264    23.525     0.200
    26.441    17.465     0.200
    28.084    13.613     0.200
    27.940    18.416     0.200
    22.553    37.267     0.200
    22.683    38.099     0.200
    22.842    36.519     0.200
    23.235    36.130     0.200
    23.431    38.412     0.200
    23.644    35.280     0.200
    24.056    35.857     0.200
    25.139    32.707     0.200
    27.001    26.034     0.200
    29.823    18.628     0.200
    15.978    34.177     0.200
    20.579    31.253     0.200
    23.908    26.854     0.200
    24.536    25.449     0.200
    24.536    25.926     0.200
    28.995    14.801     0.200
    29.023    14.081     0.200
    19.141    35.089     0.200
    22.596    33.095     0.200
    23.401    31.895     0.200
    25.505    26.636     0.200
    26.451    22.208     0.200
    29.957    14.696     0.200
    19.820    31.279     0.200
    25.656    19.704     0.200
    26.875    16.182     0.200
    19.998    39.509     0.200
    24.264    37.137     0.200
    28.972    23.609     0.200
    13.974    40.193     0.200
    19.806    34.015     0.200
    19.806    35.060     0.200
    20.620    34.005     0.200
    20.620    33.866     0.200
    22.353    35.209     0.200
    22.978    34.576     0.200
    23.341    32.771     0.200
    23.417    32.677     0.200
    23.587    31.974     0.200
    23.587    32.513     0.200
    23.587    33.269     0.200
    23.812    32.334     0.200
    23.961    31.434     0.200
    24.365    31.280     0.200
    24.524    31.165     0.200
    24.770    30.214     0.200
    25.085    29.047     0.200
    25.197    28.419     0.200
    25.197    30.993     0.200
    25.349    30.502     0.200
    25.388    28.918     0.200
    25.418    28.892     0.200
    25.583    27.847     0.200
    25.682    28.220     0.200
    25.715    27.056     0.200
    25.781    27.898     0.200
    26.169    25.619     0.200
    26.635    20.519     0.200
    26.741    24.756     0.200
    27.443    23.071     0.200
    27.509    21.621     0.200
    27.589    18.747     0.200
    27.643    22.466     0.200
    27.683    20.901     0.200
    28.080    19.758     0.200
    28.191    19.785     0.200
    28.895    19.490     0.200
    29.281    19.032     0.200
    29.669    17.069     0.200
    29.669    17.789     0.200
    29.687    17.139     0.200
    29.689    17.804     0.200
    29.892    16.969     0.200
    29.892    17.395     0.200
    29.962    17.215     0.200
    23.199    32.961     0.200
    25.136    28.873     0.200
    27.940    18.720     0.200
    28.436    16.287     0.200
    19.754    32.290     0.200
    19.754    30.584     0.200
    19.815    32.138     0.200
    20.889    32.295     0.200
    21.171    34.483     0.200
    21.493    31.934     0.200
    22.641    32.213     0.200
    22.810    31.053     0.200
    22.855    30.503     0.200
    23.240    29.407     0.200
    23.274    28.808     0.200
    23.762    28.688     0.200
    23.773    28.446     0.200
    23.904    28.364     0.200
    23.908    27.493     0.200
    23.935    27.755     0.200
    24.039    27.690     0.200
    24.063    27.210     0.200
    24.063    27.355     0.200
    24.283    26.380     0.200
    24.572    26.359     0.200
    25.004    25.495     0.200
    25.075    25.592     0.200
    25.115    25.483     0.200
    25.397    24.667     0.200
    25.502    23.714     0.200
    25.542    23.450     0.200
    25.905    19.964     0.200
    25.865    23.492     0.200
    25.872    22.740     0.200
    26.171    21.772     0.200
    26.459    21.610     0.200
    26.846    22.604     0.200
    26.889    20.314     0.200
    27.036    17.339     0.200
    27.036    17.785     0.200
    27.080    16.425     0.200
    27.307    19.513     0.200
    27.417    18.681     0.200
    27.697    15.340     0.200
    28.001    17.091     0.200
    28.077    15.741     0.200
    28.077    16.003     0.200
    28.543    15.055     0.200
    28.618    14.842     0.200
    28.618    15.377     0.200
    28.658    14.194     0.200
    29.632    13.100     0.200
    29.848    14.489     0.200
    29.997    13.149     0.200
    21.754    34.392     0.200
    21.967    34.365     0.200
    22.015    34.142     0.200
    26.787    21.963     0.200
    27.968    19.343     0.200
    27.968    20.683     0.200
    28.961    18.087     0.200
    29.085    16.824     0.200
    29.662    15.355     0.200
    29.679    15.924     0.200
    29.688    16.050     0.200
    29.747    15.917     0.200
    29.913    15.778     0.200
    19.432    33.685     0.200
    26.137    20.999     0.200
    22.656    34.158     0.200
    27.131    20.063     0.200
    28.142    20.546     0.200
    28.180    20.195     0.200
    28.484    16.820     0.200
    28.484    16.390     0.200
    28.994    14.430     0.200
    19.231    34.826     0.200
    19.431    35.164     0.200
    19.431    35.619     0.200
    21.749    34.350     0.200
    22.053    33.798     0.200
    22.283    34.335     0.200
    22.398    34.451     0.200
    22.773    33.119     0.200
    23.179    33.179     0.200
    23.330    32.373     0.200
    23.456    32.832     0.200
    23.498    32.033     0.200
    23.498    32.282     0.200
    23.498    33.218     0.200
    23.848    31.785     0.200
    23.977    31.908     0.200
    24.089    30.915     0.200
    24.407    31.217     0.200
    24.477    30.696     0.200
    24.710    29.469     0.200
    24.801    30.435     0.200
    24.924    28.459     0.200
    24.983    29.241     0.200
    25.042    29.584     0.200
    25.266    28.193     0.200
    25.314    28.066     0.200
    25.384    27.576     0.200
    25.612    27.135     0.200
    25.649    27.348     0.200
    25.642    28.664     0.200
    25.860    27.979     0.200
    26.048    25.994     0.200
    26.076    25.713     0.200
    26.246    27.354     0.200
    26.292    26.945     0.200
    26.383    25.104     0.200
    26.502    21.700     0.200
    26.502    21.399     0.200
    26.713    24.647     0.200
    26.818    24.710     0.200
    27.263    23.331     0.200
    27.416    22.962     0.200
    27.539    21.721     0.200
    27.973    20.495     0.200
    28.037    21.107     0.200
    28.096    20.356     0.200
    28.096    19.540     0.200
    28.810    19.106     0.200
    28.891    17.636     0.200
    29.003    18.568     0.200
    29.046    17.827     0.200
    29.351    17.431     0.200
    29.457    17.135     0.200
    29.608    16.709     0.200
    29.656    16.556     0.200
    29.656    15.942     0.200
    29.812    15.507     0.200
    29.884    15.460     0.200
    29.981    15.816     0.200
    19.914    34.375     0.200
    20.424    33.669     0.200
    21.153    34.944     0.200
    21.284    36.335     0.200
    21.317    35.749     0.200
    21.344    35.815     0.200
    21.508    36.517     0.200
    21.893    36.621     0.200
    21.996    34.324     0.200
    22.103    34.760     0.200
    22.272    35.295     0.200
    22.443    34.637     0.200
    22.535    34.186     0.200
    22.550    34.279     0.200
    22.578    34.751     0.200
    23.232    34.154     0.200
    23.414    33.277     0.200
    23.453    32.769     0.200
    23.500    32.816     0.200
    23.533    33.606     0.200
    23.545    32.880     0.200
    23.580    32.437     0.200
    23.623    33.410     0.200
    23.780    31.163     0.200
    23.780    31.772     0.200
    23.780    31.999     0.200
    24.017    31.917     0.200
    24.165    31.505     0.200
    24.338    30.515     0.200
    24.571    31.061     0.200
    24.623    31.690     0.200
    24.648    31.161     0.200
    24.725    29.839     0.200
    24.975    30.188     0.200
    25.026    30.109     0.200
    25.202    29.488     0.200
    25.276    28.201     0.200
    25.280    28.891     0.200
    25.404    28.980     0.200
    25.404    29.620     0.200
    25.595    29.118     0.200
    25.610    27.447     0.200
    25.790    28.022     0.200
    25.882    26.667     0.200
    25.907    26.401     0.200
    25.988    26.800     0.200
    26.429    21.255     0.200
    26.320    26.128     0.200
    26.342    25.057     0.200
    26.362    25.357     0.200
    26.372    26.453     0.200
    26.458    26.114     0.200
    26.676    24.017     0.200
    26.903    24.952     0.200
    26.948    23.977     0.200
    27.391    18.740     0.200
    27.514    19.871     0.200
    27.563    21.930     0.200
    27.671    22.098     0.200
    27.867    20.154     0.200
    27.867    20.463     0.200
    28.168    19.398     0.200
    28.023    20.831     0.200
    28.243    20.171     0.200
    28.280    20.033     0.200
    28.384    19.503     0.200
    28.578    20.141     0.200
    28.952    19.530     0.200
    29.172    18.798     0.200
    29.192    17.548     0.200
    29.207    18.835     0.200
    29.331    17.504     0.200
    29.349    17.919     0.200
    29.488    18.389     0.200
    29.739    17.251     0.200
    29.739    17.809     0.200
    29.882    16.477     0.200
    29.955    15.943     0.200
    29.955    16.189     0.200
    19.374    36.142     0.200
    20.269    34.557     0.200
    20.556    33.505     0.200
    21.268    36.763     0.200
    22.115    34.675     0.200
    22.687    34.665     0.200
    23.624    33.263     0.200
    23.664    33.610     0.200
    23.702    32.817     0.200
    23.932    31.445     0.200
    23.932    32.195     0.200
    23.932    31.922     0.200
    24.069    32.462     0.200
    24.233    31.887     0.200
    24.619    31.550     0.200
    24.669    31.586     0.200
    25.031    31.356     0.200
    25.246    30.041     0.200
    25.429    28.957     0.200
    25.614    28.651     0.200
    25.773    27.444     0.200
    25.823    28.070     0.200
    26.005    27.244     0.200
    26.473    20.734     0.200
    26.473    20.461     0.200
    26.516    25.351     0.200
    26.805    21.084     0.200
    26.966    24.309     0.200
    27.272    18.939     0.200
    27.928    18.879     0.200
    27.928    19.379     0.200
    28.060    20.376     0.200
    28.164    16.831     0.200
    28.382    18.896     0.200
    28.394    19.965     0.200
    28.612    18.454     0.200
    29.482    17.763     0.200
    29.511    18.585     0.200
    29.888    16.454     0.200
    29.888    16.594     0.200
    19.740    32.402     0.200
    20.100    31.748     0.200
    25.757    19.604     0.200
    25.757    19.779     0.200
    26.822    16.830     0.200
    27.515    15.315     0.200
    20.455    37.491     0.200
    21.167    40.341     0.200
    21.427    35.833     0.200
    21.427    36.003     0.200
    21.537    40.275     0.200
    21.785    35.455     0.200
    21.830    39.355     0.200
    21.895    39.228     0.200
    22.705    38.322     0.200
    22.781    34.407     0.200
    22.798    37.576     0.200
    22.798    34.711     0.200
    22.902    37.413     0.200
    22.980    37.378     0.200
    23.155    37.741     0.200
    23.155    37.601     0.200
    23.208    35.031     0.200
    23.382    34.917     0.200
    23.445    38.532     0.200
    23.650    36.780     0.200
    23.756    33.968     0.200
    23.785    37.229     0.200
    23.794    34.032     0.200
    23.968    36.611     0.200
    23.997    35.895     0.200
    24.173    32.329     0.200
    24.468    35.058     0.200
    24.485    34.841     0.200
    24.555    35.710     0.200
    24.555    36.042     0.200
    24.600    35.427     0.200
    24.747    35.631     0.200
    24.738    31.714     0.200
    24.953    30.872     0.200
    25.127    30.327     0.200
    25.168    33.570     0.200
    25.508    32.379     0.200
    25.558    32.125     0.200
    25.644    32.467     0.200
    25.742    28.554     0.200
    25.742    30.448     0.200
    26.121    31.199     0.200
    26.806    27.881     0.200
    26.920    28.533     0.200
    27.132    28.227     0.200
    27.363    22.453     0.200
    27.334    24.091     0.200
    27.334    26.443     0.200
    27.385    27.559     0.200
    27.621    22.418     0.200
    27.578    23.360     0.200
    27.578    26.580     0.200
    27.590    26.101     0.200
    27.765    23.039     0.200
    27.765    25.088     0.200
    27.742    27.204     0.200
    28.030    22.266     0.200
    27.921    25.094     0.200
    28.092    23.966     0.200
    28.092    20.923     0.200
    28.092    22.196     0.200
    28.105    26.715     0.200
    28.540    22.226     0.200
    28.534    24.094     0.200
    28.636    24.397     0.200
    28.718    23.731     0.200
    28.719    23.759     0.200
    28.887    23.673     0.200
    28.929    23.518     0.200
    29.064    23.042     0.200
    29.108    23.064     0.200
    29.108    23.880     0.200
    29.235    21.549     0.200
    29.259    22.602     0.200
    29.259    22.576     0.200
    29.357    21.743     0.200
    29.358    21.582     0.200
    29.332    21.935     0.200
    29.439    22.217     0.200
    29.498    21.194     0.200
    29.491    20.707     0.200
    29.545    20.818     0.200
    29.605    21.159     0.200
    29.623    20.786     0.200
    29.637    21.074     0.200
    29.680    20.404     0.200
    19.102    35.614     0.200
    20.055    37.852     0.200
    20.298    37.717     0.200
    20.304    37.870     0.200
    20.837    37.542     0.200
    21.347    38.203     0.200
    21.422    38.352     0.200
    21.492    37.691     0.200
    21.503    37.842     0.200
    21.713    37.719     0.200
    21.930    37.790     0.200
    22.020    36.749     0.200
    22.108    36.854     0.200
    22.332    37.534     0.200
    22.851    36.425     0.200
    22.889    36.474     0.200
    22.924    35.850     0.200
    22.941    36.309     0.200
    23.010    36.016     0.200
    23.008    36.562     0.200
    23.094    35.414     0.200
    23.167    35.344     0.200
    23.265    36.043     0.200
    23.309    36.503     0.200
    23.342    35.457     0.200
    23.363    35.647     0.200
    23.531    35.265     0.200
    23.545    36.366     0.200
    23.848    34.067     0.200
    23.886    35.350     0.200
    23.899    34.902     0.200
    23.901    34.789     0.200
    24.114    34.519     0.200
    24.175    33.554     0.200
    24.311    34.567     0.200
    24.507    33.896     0.200
    24.663    33.530     0.200
    24.663    33.272     0.200
    24.678    31.831     0.200
    24.682    32.527     0.200
    24.687    31.523     0.200
    24.717    31.901     0.200
    24.791    33.150     0.200
    24.842    33.179     0.200
    24.881    32.993     0.200
    25.070    32.199     0.200
    25.228    32.242     0.200
    25.242    31.145     0.200
    25.299    31.856     0.200
    25.352    30.988     0.200
    25.606    30.497     0.200
    25.718    29.269     0.200
    25.773    29.808     0.200
    25.775    29.993     0.200
    25.967    29.760     0.200
    25.967    29.002     0.200
    26.192    28.421     0.200
    26.271    28.647     0.200
    26.560    29.644     0.200
    26.840    23.851     0.200
    26.903    24.615     0.200
    27.100    26.176     0.200
    27.331    22.034     0.200
    27.331    21.909     0.200
    27.439    22.237     0.200
    27.439    22.753     0.200
    27.398    25.369     0.200
    27.592    24.396     0.200
    27.592    24.278     0.200
    27.603    25.222     0.200
    27.631    26.499     0.200
    27.768    24.529     0.200
    27.768    24.365     0.200
    27.801    24.411     0.200
    27.913    20.940     0.200
    27.915    20.659     0.200
    27.915    20.924     0.200
    27.915    20.792     0.200
    27.859    24.196     0.200
    27.962    22.634     0.200
    27.990    23.617     0.200
    28.032    24.567     0.200
    28.214    24.062     0.200
    28.416    21.626     0.200
    28.416    21.282     0.200
    28.475    22.657     0.200
    28.741    22.316     0.200
    28.972    18.608     0.200
    28.972    17.100     0.200
    28.939    22.072     0.200
    29.008    21.323     0.200
    29.111    20.621     0.200
    29.149    21.899     0.200
    29.281    21.389     0.200
    29.328    21.654     0.200
    29.328    19.756     0.200
    29.373    20.142     0.200
    29.373    20.455     0.200
    29.449    20.371     0.200
    29.447    19.664     0.200
    29.460    20.876     0.200
    29.591    19.716     0.200
    29.591    19.966     0.200
    29.592    20.200     0.200
    29.617    21.115     0.200
    29.646    20.190     0.200
    29.716    20.004     0.200
    29.818    19.192     0.200
    29.846    20.063     0.200
    29.863    19.471     0.200
    29.950    14.758     0.200
    20.213    39.167     0.200
    24.326    34.988     0.200
    25.948    31.182     0.200
    29.038    22.545     0.200
    20.017    34.170     0.200
    19.437    33.827     0.200
    19.449    34.044     0.200
    19.449    33.799     0.200
    19.449    32.289     0.200
    23.818    29.623     0.200
    23.818    29.931     0.200
    24.437    28.540     0.200
    24.868    27.234     0.200
    24.894    29.401     0.200
    24.966    28.931     0.200
    25.688    25.783     0.200
    26.055    21.030     0.200
    26.055    20.405     0.200
    27.322    17.351     0.200
    27.877    16.741     0.200
    27.877    16.947     0.200
    28.841    17.060     0.200
    29.364    15.895     0.200
    29.935    14.558     0.200
    15.806    38.627     0.200
    20.424    35.593     0.200
    20.432    34.521     0.200
    20.431    34.104     0.200
    21.077    37.754     0.200
    21.167    37.429     0.200
    21.348    37.153     0.200
    21.452    37.019     0.200
    21.468    37.679     0.200
    21.858    36.839     0.200
    21.879    37.287     0.200
    21.907    36.499     0.200
    21.971    36.962     0.200
    22.018    36.098     0.200
    22.045    36.224     0.200
    22.250    36.103     0.200
    22.400    36.219     0.200
    22.494    35.965     0.200
    22.542    35.501     0.200
    22.606    35.312     0.200
    22.902    36.512     0.200
    22.958    34.984     0.200
    22.992    35.078     0.200
    23.237    35.530     0.200
    23.415    35.162     0.200
    23.414    34.363     0.200
    23.492    34.467     0.200
    23.502    34.386     0.200
    23.508    33.858     0.200
    23.590    34.838     0.200
    23.607    33.002     0.200
    23.693    33.864     0.200
    23.800    33.829     0.200
    23.847    34.006     0.200
    23.856    33.152     0.200
    23.863    32.972     0.200
    23.863    33.113     0.200
    23.863    33.289     0.200
    23.885    33.136     0.200
    23.914    33.364     0.200
    23.969    34.350     0.200
    24.063    33.701     0.200
    24.091    33.267     0.200
    24.362    31.911     0.200
    24.461    32.906     0.200
    24.485    33.087     0.200
    24.490    32.450     0.200
    24.677    32.193     0.200
    24.709    31.142     0.200
    24.880    31.913     0.200
    25.084    31.075     0.200
    25.099    30.951     0.200
    25.167    29.663     0.200
    25.198    29.773     0.200
    25.253    30.787     0.200
    25.253    30.972     0.200
    25.288    30.914     0.200
    25.377    29.378     0.200
    25.391    29.649     0.200
    25.434    30.591     0.200
    25.453    30.615     0.200
    25.654    29.622     0.200
    25.714    28.446     0.200
    25.822    29.468     0.200
    25.880    28.225     0.200
    25.902    29.502     0.200
    26.202    27.817     0.200
    26.269    27.460     0.200
    26.349    27.692     0.200
    26.378    27.806     0.200
    26.387    27.483     0.200
    26.449    25.885     0.200
    26.706    21.342     0.200
    26.706    21.042     0.200
    26.785    25.718     0.200
    26.908    21.802     0.200
    26.908    21.482     0.200
    26.831    26.143     0.200
    27.166    25.005     0.200
    27.378    19.903     0.200
    27.380    20.028     0.200
    27.380    19.878     0.200
    27.445    23.890     0.200
    27.499    23.272     0.200
    27.633    23.359     0.200
    27.673    23.030     0.200
    27.830    23.258     0.200
    27.883    22.521     0.200
    28.030    21.344     0.200
    28.094    21.946     0.200
    28.229    19.996     0.200
    28.228    21.963     0.200
    28.363    17.401     0.200
    28.291    21.568     0.200
    28.300    21.514     0.200
    28.443    21.588     0.200
    28.472    18.735     0.200
    28.472    20.725     0.200
    28.620    21.532     0.200
    28.803    18.973     0.200
    28.803    21.030     0.200
    29.012    19.913     0.200
    29.063    20.089     0.200
    29.070    19.647     0.200
    29.226    19.156     0.200
    29.249    19.337     0.200
    29.332    19.629     0.200
    29.412    18.766     0.200
    29.422    18.951     0.200
    29.427    19.033     0.200
    29.553    19.090     0.200
    29.589    18.440     0.200
    29.638    19.438     0.200
    29.697    18.210     0.200
    29.802    19.021     0.200
    29.816    19.013     0.200
    29.816    18.789     0.200
    29.945    17.666     0.200
    29.953    18.002     0.200
    29.959    16.446     0.200
    29.959    17.501     0.200
    20.264    39.183     0.200
    23.326    38.979     0.200
    28.306    25.380     0.200
    29.010    23.755     0.200
    29.076    23.045     0.200
    19.152    34.373     0.200
    27.578    17.698     0.200
    16.121    33.535     0.200
    16.121    33.910     0.200
    18.641    31.874     0.200
    19.686    31.448     0.200
    19.699    32.148     0.200
    19.699    30.753     0.200
    20.631    31.555     0.200
    20.964    32.339     0.200
    21.103    31.762     0.200
    21.550    31.681     0.200
    21.568    31.775     0.200
    21.716    31.106     0.200
    21.950    32.400     0.200
    21.992    32.091     0.200
    22.336    31.228     0.200
    22.402    31.131     0.200
    22.479    30.724     0.200
    22.590    30.794     0.200
    22.724    29.633     0.200
    22.921    29.063     0.200
    22.955    28.741     0.200
    23.089    29.594     0.200
    23.498    28.709     0.200
    23.527    29.070     0.200
    23.622    28.600     0.200
    23.824    27.154     0.200
    23.840    26.799     0.200
    23.847    27.982     0.200
    23.979    26.620     0.200
    24.024    27.311     0.200
    24.116    26.496     0.200
    24.122    26.298     0.200
    24.122    26.552     0.200
    24.166    27.326     0.200
    24.258    26.663     0.200
    24.289    26.076     0.200
    24.296    27.044     0.200
    24.367    26.017     0.200
    24.544    25.901     0.200
    24.664    25.514     0.200
    24.739    24.572     0.200
    24.779    25.924     0.200
    25.167    23.615     0.200
    25.181    25.269     0.200
    25.224    24.705     0.200
    25.494    24.013     0.200
    25.574    22.551     0.200
    25.597    22.706     0.200
    25.741    23.327     0.200
    25.757    22.737     0.200
    25.782    20.462     0.200
    25.789    23.166     0.200
    25.926    21.676     0.200
    25.973    22.801     0.200
    26.171    22.471     0.200
    26.310    19.636     0.200
    26.310    20.956     0.200
    26.345    21.613     0.200
    26.569    21.369     0.200
    26.567    18.450     0.200
    26.696    19.025     0.200
    26.696    19.441     0.200
    26.795    20.006     0.200
    26.900    17.560     0.200
    26.900    17.429     0.200
    26.957    19.401     0.200
    26.988    19.468     0.200
    27.016    16.987     0.200
    27.018    17.200     0.200
    27.018    16.966     0.200
    27.399    18.177     0.200
    27.527    17.577     0.200
    27.590    16.182     0.200
    27.871    16.390     0.200
    28.117    15.085     0.200
    28.117    15.204     0.200
    28.256    14.485     0.200
    28.256    14.944     0.200
    28.372    14.453     0.200
    28.418    14.495     0.200
    28.541    14.948     0.200
    28.607    14.428     0.200
    28.691    14.040     0.200
    28.691    14.382     0.200
    28.714    13.822     0.200
    28.714    14.215     0.200
    28.986    13.717     0.200
    29.162    10.665     0.200
    29.328    13.162     0.200
    29.338    12.648     0.200
    29.515    12.153     0.200
    29.516    13.062     0.200
    29.606    12.546     0.200
    29.668    12.134     0.200
    29.691    12.060     0.200
    29.768    12.010     0.200
    29.807    11.984     0.200
    29.907    12.292     0.200
    29.994    10.738     0.200
    13.137    31.240     0.200
    13.137    31.401     0.200
    16.643    33.504     0.200
    18.164    25.759     0.200
    20.036    27.273     0.200
    20.049    27.917     0.200
    24.640    21.179     0.200
    19.414    40.406     0.200
    19.427    39.141     0.200
    19.427    39.715     0.200
    19.427    39.721     0.200
    25.898    29.156     0.200
    25.834    32.314     0.200
    27.218    26.225     0.200
    27.221    26.192     0.200
    19.411    39.293     0.200
    19.424    39.148     0.200
    19.424    39.143     0.200
    23.974    34.871     0.200
    25.818    28.643     0.200
    25.909    29.902     0.200
    26.606    27.836     0.200
    26.907    29.296     0.200
    27.164    26.133     0.200
    27.166    26.102     0.200
    18.810    36.922     0.200
    20.202    36.269     0.200
    20.578    36.098     0.200
    20.916    34.442     0.200
    20.916    33.457     0.200
    21.352    35.895     0.200
    21.565    36.487     0.200
    21.588    36.256     0.200
    22.468    35.472     0.200
    22.616    34.904     0.200
    22.626    34.928     0.200
    22.748    34.086     0.200
    22.775    36.093     0.200
    22.775    35.390     0.200
    22.923    34.149     0.200
    23.376    32.948     0.200
    23.797    32.982     0.200
    23.888    32.900     0.200
    23.983    32.209     0.200
    24.211    31.930     0.200
    24.610    32.609     0.200
    24.810    31.144     0.200
    24.941    31.285     0.200
    24.978    30.658     0.200
    25.352    29.528     0.200
    25.352    28.372     0.200
    25.598    29.731     0.200
    25.617    29.264     0.200
    25.808    29.095     0.200
    26.026    27.508     0.200
    26.166    27.748     0.200
    26.537    25.869     0.200
    26.680    23.141     0.200
    26.680    23.290     0.200
    26.811    25.348     0.200
    27.023    23.339     0.200
    27.123    20.450     0.200
    27.123    22.825     0.200
    27.326    24.674     0.200
    27.326    25.385     0.200
    27.372    24.428     0.200
    28.276    22.455     0.200
    28.323    22.194     0.200
    28.370    17.426     0.200
    28.700    21.429     0.200
    28.695    19.969     0.200
    28.734    20.247     0.200
    28.889    19.627     0.200
    28.930    20.274     0.200
    28.930    19.883     0.200
    28.956    16.627     0.200
    28.975    20.291     0.200
    29.286    19.706     0.200
    29.354    18.045     0.200
    29.617    18.668     0.200
    19.969    34.783     0.200
    19.969    34.781     0.200
    23.807    31.411     0.200
    27.366    18.280     0.200
    27.368    18.249     0.200
    23.165    37.215     0.200
    24.591    35.075     0.200
    28.070    21.202     0.200
    28.072    21.178     0.200
    29.133    22.318     0.200
    29.294    21.274     0.200
    29.294    21.275     0.200
    19.233    33.310     0.200
    19.233    33.309     0.200
    27.424    18.281     0.200
    27.427    18.261     0.200
    20.614    37.079     0.200
    27.529    23.613     0.200
    20.927    34.753     0.200
    26.963    22.570     0.200
    17.804    40.563     0.200
    18.543    35.103     0.200
    20.649    32.976     0.200
    20.649    32.685     0.200
    20.940    34.171     0.200
    21.518    36.806     0.200
    21.621    36.227     0.200
    22.405    36.727     0.200
    22.474    36.084     0.200
    22.909    34.881     0.200
    23.310    34.614     0.200
    23.357    34.445     0.200
    23.425    33.768     0.200
    23.649    33.515     0.200
    23.900    33.043     0.200
    23.920    32.680     0.200
    23.979    32.889     0.200
    24.241    31.739     0.200
    24.320    31.836     0.200
    24.337    30.852     0.200
    24.337    30.162     0.200
    24.449    31.788     0.200
    24.510    31.069     0.200
    24.864    30.880     0.200
    24.871    30.336     0.200
    25.289    29.719     0.200
    25.484    29.257     0.200
    25.491    28.998     0.200
    25.637    27.665     0.200
    25.814    28.620     0.200
    26.045    27.826     0.200
    26.194    25.271     0.200
    26.199    27.680     0.200
    26.406    20.794     0.200
    26.406    20.493     0.200
    26.463    21.424     0.200
    26.463    21.225     0.200
    26.938    20.030     0.200
    26.753    24.480     0.200
    26.756    25.789     0.200
    26.925    23.627     0.200
    27.163    23.882     0.200
    28.016    17.103     0.200
    28.619    16.865     0.200
    28.600    19.453     0.200
    28.978    13.873     0.200
    28.948    18.222     0.200
    29.324    16.330     0.200
    29.324    15.660     0.200
    29.720    15.820     0.200
    20.909    33.997     0.200
    19.588    33.575     0.200
    21.425    36.569     0.200
    21.860    38.020     0.200
    23.118    38.415     0.200
    23.116    34.877     0.200
    23.763    35.461     0.200
    24.428    33.606     0.200
    24.534    36.529     0.200
    24.534    34.592     0.200
    26.095    30.027     0.200
    26.930    26.716     0.200
    28.123    23.159     0.200
    29.238    22.943     0.200
    18.907    34.623     0.200
    20.829    34.478     0.200
    22.800    35.512     0.200
    28.342    17.854     0.200
    29.344    19.513     0.200
    18.572    38.158     0.200
    20.694    37.570     0.200
    21.344    35.106     0.200
    27.589    22.757     0.200
    28.721    20.081     0.200
    29.141    22.269     0.200
    19.233    35.567     0.200
    20.417    34.013     0.200
    22.148    34.146     0.200
    23.357    31.567     0.200
    23.357    30.645     0.200
    24.465    30.743     0.200
    24.964    25.822     0.200
    25.176    29.705     0.200
    25.176    26.158     0.200
    26.573    21.266     0.200
    26.837    21.688     0.200
    26.837    20.138     0.200
    27.787    17.362     0.200
    29.856    16.327     0.200
    20.097    30.655     0.200
    20.286    31.436     0.200
    26.872    16.374     0.200
    29.462    12.226     0.200
    29.997    12.376     0.200
    19.656    32.193     0.200
    20.442    34.266     0.200
    24.905    29.388     0.200
    25.320    28.688     0.200
    27.187    19.192     0.200
    27.187    22.408     0.200
    29.559    18.177     0.200
    14.695    40.372     0.200
    27.863    23.429     0.200
    17.907    38.669     0.200
    29.334    21.516     0.200
    20.877    39.299     0.200
    24.433    36.194     0.200
    25.800    33.398     0.200
    26.204    27.167     0.200
    26.812    26.671     0.200
    28.445    23.190     0.200
    28.994    24.646     0.200
    29.350    23.963     0.200
    15.216    39.834     0.200
    18.646    37.652     0.200
    20.946    36.978     0.200
    25.522    29.166     0.200
    19.987    34.107     0.200
    28.085    16.273     0.200
    20.065    31.837     0.200
    29.364    18.638     0.200
    14.450    35.921     0.200
    17.917    34.198     0.200
    20.515    33.190     0.200
    26.830    20.369     0.200
    20.890    32.577     0.200
    24.447    26.925     0.200
    15.879    42.186     0.200
    18.687    36.129     0.200
    20.026    37.421     0.200
    20.324    35.004     0.200
    20.686    38.315     0.200
    21.232    37.046     0.200
    21.287    37.650     0.200
    22.143    37.194     0.200
    22.709    35.270     0.200
    23.164    34.975     0.200
    23.460    35.290     0.200
    23.677    34.961     0.200
    23.752    34.875     0.200
    23.825    34.138     0.200
    23.860    34.066     0.200
    23.916    34.766     0.200
    23.916    33.459     0.200
    24.147    33.418     0.200
    24.297    33.415     0.200
    24.338    32.612     0.200
    24.701    33.716     0.200
    24.775    33.029     0.200
    24.887    32.568     0.200
    25.105    32.649     0.200
    25.362    31.618     0.200
    25.531    32.367     0.200
    25.531    30.628     0.200
    25.721    31.293     0.200
    25.918    30.880     0.200
    26.114    30.275     0.200
    26.312    24.090     0.200
    26.497    26.719     0.200
    26.693    28.493     0.200
    27.074    25.737     0.200
    27.256    23.720     0.200
    28.043    21.982     0.200
    28.414    21.325     0.200
    28.706    21.497     0.200
    29.875    17.745     0.200
    29.963    17.170     0.200
    18.703    32.343     0.200
    20.105    34.232     0.200
    20.478    32.019     0.200
    20.478    32.878     0.200
    20.626    34.114     0.200
    20.788    34.661     0.200
    21.162    31.975     0.200
    21.226    32.156     0.200
    21.394    34.781     0.200
    21.556    32.801     0.200
    21.562    33.943     0.200
    21.959    34.224     0.200
    22.069    29.548     0.200
    22.336    34.097     0.200
    22.606    33.290     0.200
    22.624    29.157     0.200
    22.634    33.891     0.200
    23.044    32.060     0.200
    23.090    28.990     0.200
    23.114    29.195     0.200
    23.373    29.947     0.200
    23.484    32.278     0.200
    23.541    33.234     0.200
    23.537    32.139     0.200
    23.599    32.403     0.200
    23.872    31.747     0.200
    23.872    29.501     0.200
    23.946    31.114     0.200
    24.058    28.462     0.200
    24.214    27.797     0.200
    24.239    29.419     0.200
    24.610    27.306     0.200
    24.673    26.378     0.200
    24.804    29.960     0.200
    25.008    27.934     0.200
    25.018    27.765     0.200
    25.133    25.780     0.200
    25.266    25.417     0.200
    25.431    29.357     0.200
    25.431    28.244     0.200
    25.593    26.611     0.200
    25.596    28.898     0.200
    25.619    25.347     0.200
    25.821    25.136     0.200
    26.011    24.574     0.200
    26.436    20.659     0.200
    26.436    20.780     0.200
    26.376    23.835     0.200
    26.455    22.360     0.200
    26.587    23.566     0.200
    26.850    20.353     0.200
    26.972    22.141     0.200
    27.314    18.235     0.200
    27.314    19.094     0.200
    27.314    17.668     0.200
    27.711    21.041     0.200
    27.980    18.423     0.200
    28.006    19.949     0.200
    28.150    16.881     0.200
    29.423    15.993     0.200
    29.423    16.779     0.200
    29.830    14.040     0.200
    18.358    35.826     0.200
    20.546    36.670     0.200
    21.169    33.469     0.200
    26.984    20.856     0.200
    26.984    20.309     0.200
    27.546    21.146     0.200
    27.546    21.724     0.200
    27.546    19.498     0.200
    27.546    20.951     0.200
    28.612    16.804     0.200
    29.740    18.946     0.200
    28.209    17.120     0.200
    29.243    20.055     0.200
    19.681    35.035     0.200
    27.241    21.999     0.200
    27.278    20.082     0.200
    27.325    18.474     0.200
    27.614    19.275     0.200
    18.888    36.597     0.200
    13.765    38.447     0.200
    18.235    33.981     0.200
    19.850    32.607     0.200
    13.378    31.386     0.200
    19.402    35.964     0.200
    20.615    35.358     0.200
    20.615    34.108     0.200
    20.897    33.314     0.200
    20.897    33.134     0.200
    23.957    32.974     0.200
    25.287    31.175     0.200
    26.713    20.624     0.200
    27.309    20.696     0.200
    27.309    19.743     0.200
    27.309    21.493     0.200
    28.430    18.910     0.200
    28.430    18.113     0.200
    28.482    18.431     0.200
    29.996    17.654     0.200
    29.996    15.522     0.200
    13.326    35.929     0.200
    17.774    32.089     0.200
    17.774    32.308     0.200
    19.585    33.020     0.200
    19.585    32.028     0.200
    19.726    32.477     0.200
    25.862    20.315     0.200
    13.191    31.713     0.200
    13.191    31.510     0.200
    14.148    32.858     0.200
    17.192    28.685     0.200
    17.192    28.122     0.200
    18.083    27.891     0.200
    18.083    27.657     0.200
    20.143    28.794     0.200
    20.143    28.559     0.200
    26.492    14.441     0.200
    26.829    15.571     0.200
    28.644    10.955     0.200
    21.236    33.980     0.200
    28.983    16.912     0.200
    17.325    31.104     0.200
    20.052    31.662     0.200
    20.052    31.111     0.200
    20.244    33.061     0.200
    27.077    17.551     0.200
    27.750    17.271     0.200
    18.679    34.759     0.200
    19.625    32.487     0.200
    19.625    32.917     0.200
    20.094    33.444     0.200
    22.063    33.840     0.200
    22.311    32.773     0.200
    22.965    31.295     0.200
    23.024    33.057     0.200
    23.115    33.027     0.200
    23.142    32.216     0.200
    23.243    32.419     0.200
    23.243    31.300     0.200
    23.243    32.044     0.200
    23.299    32.165     0.200
    23.463    32.620     0.200
    24.102    30.989     0.200
    24.364    29.355     0.200
    24.382    28.833     0.200
    25.028    26.633     0.200
    25.298    27.687     0.200
    25.810    25.466     0.200
    25.973    24.671     0.200
    26.021    24.472     0.200
    26.098    22.731     0.200
    26.098    22.481     0.200
    26.396    20.797     0.200
    26.519    24.095     0.200
    26.861    22.769     0.200
    26.967    22.074     0.200
    27.181    21.479     0.200
    27.269    21.659     0.200
    27.459    19.999     0.200
    27.740    20.448     0.200
    27.825    20.227     0.200
    27.826    19.659     0.200
    27.861    19.308     0.200
    27.861    19.619     0.200
    27.902    17.626     0.200
    27.902    17.026     0.200
    28.293    16.664     0.200
    28.293    16.424     0.200
    28.293    16.895     0.200
    28.782    17.683     0.200
    29.360    16.368     0.200
    29.382    14.152     0.200
    29.571    16.219     0.200
    29.875    14.808     0.200
    29.958    14.937     0.200
    19.623    30.739     0.200
    19.232    34.419     0.200
    26.916    20.941     0.200
    20.282    32.546     0.200
    19.788    33.953     0.200
    20.294    38.736     0.200
    21.999    37.723     0.200
    22.723    37.259     0.200
    22.816    33.855     0.200
    22.901    36.230     0.200
    22.981    36.236     0.200
    23.211    34.501     0.200
    23.274    36.710     0.200
    23.339    34.598     0.200
    24.181    32.752     0.200
    24.527    34.324     0.200
    27.482    21.761     0.200
    28.037    21.482     0.200
    28.037    20.732     0.200
    29.140    21.577     0.200
    29.238    21.268     0.200
    29.238    20.839     0.200
    20.305    37.392     0.200
    28.025    20.232     0.200
    29.249    20.391     0.200
    21.037    37.426     0.200
    26.872    24.646     0.200
    14.490    39.391     0.200
    19.052    35.698     0.200
    19.930    27.449     0.200
    28.449    20.452     0.200
    21.389    35.198     0.200
    27.114    22.146     0.200
    27.507    21.856     0.200
    28.928    19.409     0.200
    18.495    37.125     0.200
    18.495    36.977     0.200
    19.428    37.085     0.200
    19.428    37.288     0.200
    21.316    34.924     0.200
    28.297    19.142     0.200
    19.077    34.656     0.200
    20.334    35.177     0.200
    20.785    33.142     0.200
    20.791    34.923     0.200
    22.238    35.448     0.200
    22.526    34.505     0.200
    22.581    33.430     0.200
    23.484    33.025     0.200
    23.834    32.006     0.200
    23.834    31.441     0.200
    24.675    28.673     0.200
    24.697    29.918     0.200
    24.881    29.554     0.200
    25.128    28.291     0.200
    25.263    28.887     0.200
    26.671    19.899     0.200
    26.828    25.157     0.200
    27.394    17.678     0.200
    27.620    22.193     0.200
    27.639    21.619     0.200
    27.988    20.392     0.200
    27.988    19.156     0.200
    28.105    18.816     0.200
    28.105    18.956     0.200
    28.276    19.852     0.200
    28.274    19.706     0.200
    28.274    19.006     0.200
    28.443    19.110     0.200
    28.451    18.836     0.200
    29.388    18.330     0.200
    29.399    17.439     0.200
    29.524    17.435     0.200
    29.596    16.107     0.200
    29.789    16.907     0.200
    29.789    15.434     0.200
    29.813    16.866     0.200
    29.813    16.083     0.200
    29.927    16.932     0.200
    29.968    16.725     0.200
    20.147    35.174     0.200
    27.380    19.278     0.200
    18.989    38.971     0.200
    20.576    38.346     0.200
    24.585    35.641     0.200
    25.276    33.265     0.200
    26.044    28.328     0.200
    28.031    23.413     0.200
    28.494    23.719     0.200
    28.494    24.414     0.200
    17.943    41.334     0.200
    18.931    39.009     0.200
    20.549    37.888     0.200
    25.994    28.332     0.200
    26.980    26.370     0.200
    27.975    22.430     0.200
    28.506    22.237     0.200
    17.685    38.848     0.200
    18.875    35.886     0.200
    19.729    37.804     0.200
    19.729    36.573     0.200
    20.113    35.834     0.200
    28.251    19.531     0.200
    18.799    38.195     0.200
    19.671    38.218     0.200
    21.451    36.067     0.200
    22.514    34.319     0.200
    22.969    36.577     0.200
    22.969    35.710     0.200
    23.244    32.487     0.200
    23.661    34.566     0.200
    23.826    34.866     0.200
    24.273    32.215     0.200
    24.368    32.851     0.200
    24.435    33.256     0.200
    24.612    30.407     0.200
    25.555    29.668     0.200
    27.131    24.938     0.200
    27.441    21.673     0.200
    27.441    21.775     0.200
    27.411    26.419     0.200
    27.578    25.567     0.200
    27.787    21.494     0.200
    27.787    22.936     0.200
    27.787    20.834     0.200
    27.798    22.982     0.200
    27.798    20.936     0.200
    28.256    19.083     0.200
    28.256    19.263     0.200
    28.256    19.138     0.200
    28.256    19.532     0.200
    28.924    22.687     0.200
    28.959    21.959     0.200
    29.136    21.275     0.200
    29.152    17.477     0.200
    29.152    18.356     0.200
    29.152    18.907     0.200
    29.175    17.868     0.200
    29.166    21.445     0.200
    29.496    20.999     0.200
    29.856    18.822     0.200
    29.915    18.997     0.200
    19.674    35.986     0.200
    27.782    21.697     0.200
    27.782    21.987     0.200
    18.522    33.814     0.200
    18.522    34.556     0.200
    18.596    34.471     0.200
    18.596    34.905     0.200
    20.073    33.233     0.200
    20.073    32.991     0.200
    22.774    32.399     0.200
    23.367    31.820     0.200
    23.785    31.877     0.200
    23.972    31.216     0.200
    24.016    29.348     0.200
    24.016    30.059     0.200
    24.016    30.207     0.200
    24.340    30.765     0.200
    24.450    29.604     0.200
    25.005    28.865     0.200
    25.215    28.998     0.200
    25.226    27.808     0.200
    25.521    27.322     0.200
    25.642    26.178     0.200
    25.794    26.076     0.200
    25.844    25.428     0.200
    26.598    23.894     0.200
    27.152    18.104     0.200
    27.561    17.011     0.200
    27.796    20.522     0.200
    28.097    18.716     0.200
    28.480    18.107     0.200
    28.519    18.646     0.200
    28.519    17.806     0.200
    28.619    16.023     0.200
    28.817    16.863     0.200
    29.446    14.990     0.200
    29.932    13.081     0.200
    29.955    14.875     0.200
    20.895    36.678     0.200
    26.796    21.772     0.200
    27.257    22.155     0.200
    27.257    23.545     0.200
    27.257    21.270     0.200
    29.995    19.186     0.200
    17.750    33.510     0.200
    18.976    30.923     0.200
    19.433    33.845     0.200
    19.433    33.525     0.200
    20.911    34.473     0.200
    21.989    33.453     0.200
    23.186    31.811     0.200
    23.775    30.168     0.200
    23.775    28.852     0.200
    25.637    24.365     0.200
    25.752    25.528     0.200
    26.033    24.549     0.200
    26.107    19.859     0.200
    26.349    22.465     0.200
    26.376    24.068     0.200
    26.790    20.877     0.200
    26.790    19.545     0.200
    26.915    19.022     0.200
    26.915    19.862     0.200
    26.915    19.362     0.200
    27.366    17.388     0.200
    27.366    18.299     0.200
    27.366    17.119     0.200
    27.366    16.689     0.200
    27.773    18.717     0.200
    27.927    16.654     0.200
    27.927    16.943     0.200
    27.927    15.615     0.200
    28.107    16.956     0.200
    28.344    17.886     0.200
    28.367    17.665     0.200
    29.509    11.690     0.200
    29.733    15.091     0.200
    29.917    14.196     0.200
    19.129    34.814     0.200
    19.129    35.134     0.200
    20.225    34.576     0.200
    20.491    34.355     0.200
    20.895    34.497     0.200
    21.229    33.424     0.200
    22.187    33.561     0.200
    22.561    31.985     0.200
    23.237    32.211     0.200
    23.356    31.921     0.200
    23.491    30.093     0.200
    23.547    31.217     0.200
    23.583    30.264     0.200
    23.787    31.336     0.200
    23.903    30.807     0.200
    23.903    31.839     0.200
    23.970    30.047     0.200
    24.031    29.810     0.200
    24.400    28.685     0.200
    24.500    28.742     0.200
    24.735    27.734     0.200
    25.038    27.492     0.200
    25.226    29.526     0.200
    25.321    29.569     0.200
    26.233    25.578     0.200
    26.269    23.187     0.200
    26.700    24.145     0.200
    27.362    20.555     0.200
    27.785    18.319     0.200
    27.923    19.552     0.200
    28.378    20.444     0.200
    28.401    20.735     0.200
    28.767    19.725     0.200
    29.311    18.225     0.200
    29.466    17.819     0.200
    29.471    17.669     0.200
    29.501    16.668     0.200
    29.583    17.311     0.200
    29.902    15.968     0.200
    20.061    39.307     0.200
    13.855    39.815     0.200
    17.265    37.543     0.200
    18.381    36.066     0.200
    23.294    34.708     0.200
    24.920    31.393     0.200
    25.877    27.290     0.200
    27.392    23.514     0.200
    27.789    23.283     0.200
    27.899    22.891     0.200
    27.880    18.178     0.200
    29.253    20.678     0.200
    29.382    19.327     0.200
    29.472    18.825     0.200
    29.613    18.334     0.200
    29.609    19.139     0.200
    19.442    34.237     0.200
    18.335    34.485     0.200
    19.414    35.941     0.200
    20.637    35.537     0.200
    20.881    32.218     0.200
    27.284    19.461     0.200
    18.733    37.110     0.200
    19.851    36.480     0.200
    20.879    35.602     0.200
    20.879    36.891     0.200
    21.295    33.943     0.200
    21.295    34.552     0.200
    26.965    23.691     0.200
    27.029    21.443     0.200
    27.445    22.500     0.200
    27.445    22.391     0.200
    27.445    22.812     0.200
    18.807    37.903     0.200
    20.920    36.549     0.200
    18.506    35.406     0.200
    18.506    35.734     0.200
    19.548    34.668     0.200
    19.548    35.973     0.200
    20.657    33.825     0.200
    20.657    33.583     0.200
    20.899    33.254     0.200
    20.899    34.785     0.200
    23.621    30.502     0.200
    23.878    29.933     0.200
    24.110    28.204     0.200
    24.303    30.039     0.200
    24.303    30.719     0.200
    24.303    31.352     0.200
    24.305    29.471     0.200
    25.121    28.061     0.200
    25.833    29.111     0.200
    26.423    20.992     0.200
    26.493    24.409     0.200
    26.968    22.447     0.200
    26.968    22.361     0.200
    26.968    19.337     0.200
    27.222    23.338     0.200
    27.399    23.970     0.200
    27.712    21.260     0.200
    28.037    17.856     0.200
    28.488    18.351     0.200
    28.488    19.156     0.200
    28.584    18.146     0.200
    28.584    19.474     0.200
    28.710    19.509     0.200
    28.710    20.251     0.200
    29.162    15.933     0.200
    29.852    15.955     0.200
    29.959    15.868     0.200
    21.643    37.186     0.200
    28.887    21.970     0.200
    13.543    31.838     0.200
    17.537    30.692     0.200
    18.451    28.682     0.200
    20.392    29.004     0.200
    13.057    31.538     0.200
    19.982    27.792     0.200
    17.962    32.544     0.200
    20.577    32.548     0.200
    15.281    39.668     0.200
    18.405    38.032     0.200
    18.405    38.694     0.200
    19.527    35.707     0.200
    19.584    38.362     0.200
    20.402    37.836     0.200
    21.642    35.622     0.200
    21.642    35.390     0.200
    21.853    33.693     0.200
    22.835    34.722     0.200
    23.049    34.408     0.200
    23.113    33.721     0.200
    23.206    34.142     0.200
    23.346    34.109     0.200
    23.346    36.900     0.200
    24.038    32.125     0.200
    25.296    29.964     0.200
    26.770    26.358     0.200
    27.041    25.751     0.200
    27.530    22.796     0.200
    27.580    23.063     0.200
    27.714    22.776     0.200
    27.714    25.748     0.200
    27.979    22.710     0.200
    27.958    22.797     0.200
    28.587    20.187     0.200
    29.085    19.209     0.200
    29.281    21.594     0.200
    29.292    20.573     0.200
    18.441    38.006     0.200
    19.621    37.904     0.200
    20.431    37.473     0.200
    21.662    34.721     0.200
    22.641    33.097     0.200
    29.277    21.133     0.200
    15.143    38.885     0.200
    18.510    37.974     0.200
    28.019    22.284     0.200
    19.227    34.820     0.200
    20.257    40.243     0.200
    18.954    36.487     0.200
    20.702    36.900     0.200
    20.702    37.019     0.200
    21.478    38.056     0.200
    24.988    30.391     0.200
    29.362    20.245     0.200
    18.319    48.614     0.200
    19.730    36.296     0.200
    21.476    35.520     0.200
    19.090    34.536     0.200
    21.090    31.958     0.200
    16.558    35.684     0.200
    17.928    33.216     0.200
    18.299    32.919     0.200
    19.278    33.869     0.200
    20.141    32.659     0.200
    20.141    32.195     0.200
    20.892    31.610     0.200
    24.372    28.661     0.200
    24.751    28.233     0.200
    25.943    19.986     0.200
    26.034    23.183     0.200
    28.005    18.218     0.200
    19.166    33.891     0.200
    15.910    36.427     0.200
    16.091    36.666     0.200
    16.454    37.330     0.200
    16.957    38.009     0.200
    18.323    33.856     0.200
    18.690    35.635     0.200
    20.974    33.462     0.200
    20.962    34.993     0.200
    20.974    32.497     0.200
    20.974    32.997     0.200
    23.863    31.505     0.200
    24.154    32.086     0.200
    26.682    21.434     0.200
    26.682    21.798     0.200
    26.682    22.298     0.200
    26.682    22.055     0.200
    26.707    20.103     0.200
    26.677    24.098     0.200
    27.014    25.243     0.200
    27.160    22.512     0.200
    27.160    20.774     0.200
    27.160    19.262     0.200
    28.298    17.754     0.200
    28.532    20.272     0.200
    28.797    17.682     0.200
    29.266    16.618     0.200
    20.677    37.874     0.200
    27.624    22.891     0.200
    15.206    35.193     0.200
    20.209    33.390     0.200
    20.209    33.086     0.200
    22.475    31.728     0.200
    24.050    30.090     0.200
    24.880    27.944     0.200
    26.374    20.028     0.200
    26.756    21.680     0.200
    27.630    19.073     0.200
    27.630    17.233     0.200
    28.075    20.490     0.200
    28.198    16.548     0.200
    28.198    16.747     0.200
    28.198    17.407     0.200
    16.018    33.798     0.200
    17.782    31.858     0.200
    18.752    31.652     0.200
    19.592    32.393     0.200
    19.729    31.699     0.200
    19.729    31.500     0.200
    24.017    27.711     0.200
    24.017    27.547     0.200
    25.885    23.708     0.200
    27.123    16.254     0.200
    27.679    15.615     0.200
    27.679    14.818     0.200
    29.970    11.919     0.200
    19.474    32.370     0.200
    13.915    33.616     0.200
    15.620    32.843     0.200
    16.009    32.968     0.200
    16.174    32.480     0.200
    16.607    33.016     0.200
    17.369    29.923     0.200
    17.369    29.167     0.200
    18.279    28.706     0.200
    19.425    29.935     0.200
    19.425    29.256     0.200
    20.254    29.158     0.200
    20.643    30.444     0.200
    20.729    30.411     0.200
    21.100    30.249     0.200
    21.708    29.783     0.200
    22.122    29.714     0.200
    22.798    27.592     0.200
    23.182    28.018     0.200
    24.245    24.259     0.200
    24.432    23.794     0.200
    24.622    23.408     0.200
    24.698    23.555     0.200
    24.720    22.046     0.200
    24.762    22.858     0.200
    24.818    23.972     0.200
    24.966    23.223     0.200
    25.434    18.632     0.200
    26.069    18.155     0.200
    26.372    20.524     0.200
    26.524    15.441     0.200
    26.524    14.829     0.200
    27.193    14.601     0.200
    27.193    14.800     0.200
    27.193    15.111     0.200
    27.328    13.682     0.200
    27.837    15.682     0.200
    28.645    12.747     0.200
    28.979    10.677     0.200
    28.979     7.967     0.200
    29.167    10.989     0.200
    29.167    11.538     0.200
    18.973    35.595     0.200
    20.415    33.840     0.200
    24.297    32.513     0.200
    25.194    30.221     0.200
    27.103    19.269     0.200
    19.167    36.122     0.200
    13.796    30.894     0.200
    13.796    30.996     0.200
    15.444    31.935     0.200
    15.814    32.291     0.200
    16.537    32.144     0.200
    17.099    28.420     0.200
    17.099    27.795     0.200
    18.002    28.170     0.200
    18.002    27.733     0.200
    18.238    29.441     0.200
    19.201    28.713     0.200
    19.330    29.931     0.200
    19.329    28.230     0.200
    20.029    28.629     0.200
    20.646    27.381     0.200
    22.749    24.487     0.200
    23.136    24.749     0.200
    24.254    20.496     0.200
    26.151    14.537     0.200
    26.151    16.326     0.200
    26.341    16.408     0.200
    26.602    13.168     0.200
    26.602    13.410     0.200
    27.191    12.358     0.200
    27.191    13.241     0.200
    28.286    10.909     0.200
    20.746    28.967     0.200
    15.256    37.925     0.200
    15.256    40.200     0.200
    18.590    35.936     0.200
    18.662    37.917     0.200
    19.779    36.942     0.200
    20.822    36.948     0.200
    21.256    34.935     0.200
    21.256    35.062     0.200
    22.605    36.407     0.200
    23.647    35.279     0.200
    23.882    34.236     0.200
    26.721    26.069     0.200
    27.449    21.185     0.200
    27.449    22.355     0.200
    28.249    21.042     0.200
    28.598    19.575     0.200
    28.800    19.313     0.200
    29.793    18.973     0.200
    20.028    37.069     0.200
    29.317    20.878     0.200
    19.206    36.495     0.200
    19.269    36.420     0.200
    20.764    33.573     0.200
    20.771    34.010     0.200
    20.771    33.706     0.200
    26.907    19.791     0.200
    14.541    37.254     0.200
    18.407    37.178     0.200
    18.464    37.265     0.200
    20.206    34.117     0.200
    20.206    34.843     0.200
    20.206    34.027     0.200
    20.922    34.699     0.200
    20.922    34.976     0.200
    20.922    34.648     0.200
    22.040    33.102     0.200
    22.272    33.315     0.200
    22.404    35.360     0.200
    22.480    33.992     0.200
    22.536    35.949     0.200
    22.536    36.582     0.200
    22.548    32.616     0.200
    23.029    32.413     0.200
    23.131    32.182     0.200
    23.600    31.845     0.200
    23.606    33.274     0.200
    23.730    33.051     0.200
    23.973    29.853     0.200
    24.211    30.903     0.200
    24.361    30.516     0.200
    25.234    26.989     0.200
    25.445    27.998     0.200
    25.623    27.251     0.200
    25.790    26.777     0.200
    25.862    30.050     0.200
    26.280    25.807     0.200
    26.420    25.984     0.200
    26.531    25.202     0.200
    26.786    22.815     0.200
    27.023    25.018     0.200
    27.119    23.499     0.200
    27.119    27.100     0.200
    27.126    24.078     0.200
    27.212    21.166     0.200
    27.212    21.041     0.200
    28.154    19.644     0.200
    28.604    17.500     0.200
    28.604    18.007     0.200
    28.604    17.546     0.200
    28.882    17.849     0.200
    29.088    17.147     0.200
    29.088    15.866     0.200
    29.088    16.647     0.200
    29.088    17.011     0.200
    29.157    21.067     0.200
    29.983    18.799     0.200
    27.214    21.309     0.200
    28.596    17.533     0.200
    19.425    33.875     0.200
    20.325    33.543     0.200
    19.267    35.563     0.200
    29.895    16.057     0.200
    19.701    32.606     0.200
    19.299    33.905     0.200
    19.309    32.763     0.200
    19.366    33.697     0.200
    18.215    34.169     0.200
    16.570    36.556     0.200
    19.445    32.509     0.200
    20.556    37.353     0.200
    20.558    37.534     0.200
    20.558    37.839     0.200
    20.614    37.772     0.200
    21.718    35.623     0.200
    27.946    22.562     0.200
    29.288    21.136     0.200
    14.300    37.796     0.200
    18.479    37.467     0.200
    19.071    36.031     0.200
    19.655    38.634     0.200
    20.476    37.521     0.200
    20.478    37.490     0.200
    20.478    36.925     0.200
    20.478    37.295     0.200
    20.535    36.589     0.200
    20.653    36.711     0.200
    21.442    37.550     0.200
    21.643    35.013     0.200
    21.643    34.921     0.200
    21.643    33.601     0.200
    22.289    36.570     0.200
    22.289    36.730     0.200
    23.399    34.511     0.200
    23.399    34.211     0.200
    24.601    33.052     0.200
    25.135    31.254     0.200
    25.342    30.538     0.200
    26.236    27.906     0.200
    27.457    21.977     0.200
    27.457    23.757     0.200
    27.457    22.817     0.200
    27.447    21.394     0.200
    27.447    21.569     0.200
    27.761    23.251     0.200
    27.936    22.865     0.200
    27.936    20.734     0.200
    27.936    20.425     0.200
    28.645    22.891     0.200
    28.659    20.723     0.200
    29.061    17.053     0.200
    29.061    17.554     0.200
    29.061    18.034     0.200
    29.061    17.794     0.200
    29.236    19.887     0.200
    29.314    18.997     0.200
    15.271    39.367     0.200
    29.240    22.479     0.200
    17.844    39.697     0.200
    18.524    38.494     0.200
    19.708    38.372     0.200
    20.495    38.173     0.200
    20.551    38.257     0.200
    21.717    35.593     0.200
    21.717    35.251     0.200
    23.118    34.466     0.200
    23.365    35.571     0.200
    23.787    35.636     0.200
    24.028    34.570     0.200
    26.187    29.485     0.200
    27.982    21.821     0.200
    28.710    21.013     0.200
    28.710    21.243     0.200
    29.260    20.930     0.200
    18.609    38.064     0.200
    20.542    37.121     0.200
    20.543    38.814     0.200
    20.600    37.998     0.200
    21.813    36.212     0.200
    23.978    31.287     0.200
    27.594    23.373     0.200
    27.760    21.221     0.200
    28.027    23.179     0.200
    28.801    21.607     0.200
    29.201    23.873     0.200
    15.255    38.455     0.200
    20.544    35.827     0.200
    20.546    36.283     0.200
    21.832    35.643     0.200
    28.039    21.665     0.200
    28.039    20.841     0.200
    29.187    23.176     0.200
    15.653    38.613     0.200
    19.057    37.081     0.200
    21.166    37.332     0.200
    21.416    34.591     0.200
    18.794    36.001     0.200
    19.904    36.520     0.200
    19.904    36.009     0.200
    20.956    35.109     0.200
    20.960    36.176     0.200
    20.960    36.051     0.200
    21.016    34.902     0.200
    21.251    34.407     0.200
    22.455    31.988     0.200
    23.208    30.247     0.200
    26.884    23.420     0.200
    26.884    22.211     0.200
    26.884    24.510     0.200
    26.884    24.670     0.200
    26.969    21.773     0.200
    26.969    22.324     0.200
    27.365    20.710     0.200
    27.365    21.524     0.200
    27.365    20.239     0.200
    27.471    19.422     0.200
    29.060    17.846     0.200
    29.861    19.194     0.200
    19.626    33.617     0.200
    19.626    32.922     0.200
    27.253    16.505     0.200
    18.716    35.799     0.200
    21.019    32.392     0.200
    21.065    32.117     0.200
    21.024    34.881     0.200
    21.024    33.381     0.200
    21.081    32.679     0.200
    27.059    20.383     0.200
    27.059    20.152     0.200
    27.059    21.072     0.200
    29.083    16.114     0.200
    18.611    37.366     0.200
    18.879    32.920     0.200
    19.767    37.709     0.200
    19.767    36.908     0.200
    20.656    36.244     0.200
    21.539    34.519     0.200
    21.540    33.977     0.200
    23.310    31.644     0.200
    25.009    26.925     0.200
    26.412    27.667     0.200
    27.756    20.112     0.200
    27.756    20.772     0.200
    28.787    19.984     0.200
    28.778    19.478     0.200
    29.481    17.878     0.200
    20.691    34.790     0.200
    20.693    36.904     0.200
    21.591    35.288     0.200
    21.591    34.528     0.200
    27.773    20.232     0.200
    28.830    20.255     0.200
    20.712    33.072     0.200
    20.712    31.617     0.200
    20.769    32.793     0.200
    23.892    29.943     0.200
    25.315    27.871     0.200
    25.791    26.077     0.200
    26.778    19.046     0.200
    18.545    37.530     0.200
    18.950    34.743     0.200
    18.950    34.609     0.200
    18.950    34.089     0.200
    19.335    35.393     0.200
    19.646    36.419     0.200
    19.708    38.425     0.200
    20.307    35.101     0.200
    20.527    35.452     0.200
    20.576    35.043     0.200
    20.579    37.464     0.200
    21.564    34.690     0.200
    21.564    34.160     0.200
    22.403    36.535     0.200
    23.234    33.101     0.200
    23.545    33.068     0.200
    23.519    34.706     0.200
    25.244    28.311     0.200
    26.028    26.105     0.200
    26.351    28.178     0.200
    27.046    23.237     0.200
    27.339    21.691     0.200
    27.339    20.531     0.200
    27.339    21.411     0.200
    27.350    21.568     0.200
    27.819    20.095     0.200
    27.819    19.598     0.200
    27.819    20.044     0.200
    27.880    21.605     0.200
    27.880    23.375     0.200
    27.951    21.748     0.200
    28.132    21.039     0.200
    28.841    19.245     0.200
    28.759    20.520     0.200
    28.759    19.259     0.200
    28.759    20.830     0.200
    28.711    19.727     0.200
    28.716    19.221     0.200
    28.716    20.391     0.200
    28.956    17.720     0.200
    28.956    16.920     0.200
    28.956    17.820     0.200
    28.956    17.610     0.200
    29.426    19.477     0.200
    29.836    13.648     0.200
    20.375    35.420     0.200
    29.102    21.511     0.200
    19.730    34.286     0.200
    26.480    20.543     0.200
    27.506    17.234     0.200
    19.946    35.243     0.200
    20.173    33.264     0.200
    20.323    32.732     0.200
    22.937    29.664     0.200
    24.948    26.574     0.200
    26.826    23.782     0.200
    26.927    21.765     0.200
    27.307    22.573     0.200
    18.517    33.756     0.200
    18.836    31.866     0.200
    19.051    32.919     0.200
    19.919    34.192     0.200
    19.925    34.240     0.200
    19.925    33.965     0.200
    19.982    33.682     0.200
    20.471    32.509     0.200
    20.471    33.070     0.200
    20.471    32.798     0.200
    20.991    31.235     0.200
    22.972    28.985     0.200
    23.288    27.159     0.200
    23.387    27.619     0.200
    23.514    26.357     0.200
    23.589    27.977     0.200
    23.758    30.811     0.200
    25.522    22.533     0.200
    26.470    20.484     0.200
    26.872    24.143     0.200
    27.416    16.648     0.200
    27.416    18.023     0.200
    27.549    19.190     0.200
    27.549    19.046     0.200
    28.253    18.784     0.200
    18.493    37.375     0.200
    19.491    38.694     0.200
    21.007    37.635     0.200
    21.013    37.498     0.200
    26.670    24.920     0.200
    27.054    24.310     0.200
    28.534    21.178     0.200
    29.004    20.592     0.200
    13.361    35.819     0.200
    14.787    34.152     0.200
    19.298    33.968     0.200
    19.298    32.828     0.200
    19.920    32.441     0.200
    27.422    16.703     0.200
    27.422    17.586     0.200
    27.941    16.589     0.200
    16.299    36.044     0.200
    18.170    34.244     0.200
    20.468    34.942     0.200
    20.710    34.648     0.200
    20.757    33.766     0.200
    20.814    33.525     0.200
    21.701    33.304     0.200
    23.459    30.788     0.200
    24.354    30.595     0.200
    26.226    20.948     0.200
    26.408    21.814     0.200
    26.408    21.212     0.200
    26.408    21.314     0.200
    26.408    21.584     0.200
    26.879    20.261     0.200
    26.879    19.421     0.200
    26.879    20.241     0.200
    27.334    23.540     0.200
    27.869    17.692     0.200
    27.869    17.270     0.200
    27.869    17.469     0.200
    28.327    17.354     0.200
    28.327    17.553     0.200
    28.754    17.582     0.200
    28.790    19.024     0.200
    28.939    13.680     0.200
    29.211    15.912     0.200
    29.211    16.275     0.200
    29.211    15.705     0.200
    20.772    31.910     0.200
    26.870    19.591     0.200
    20.410    32.613     0.200
    20.614    31.849     0.200
    18.080    31.512     0.200
    19.784    32.394     0.200
    19.792    33.327     0.200
    19.792    32.502     0.200
    19.849    32.566     0.200
    23.267    30.458     0.200
    23.867    28.416     0.200
    24.029    27.665     0.200
    24.029    29.076     0.200
    24.322    26.602     0.200
    25.040    24.443     0.200
    25.617    23.624     0.200
    27.103    21.035     0.200
    27.116    17.432     0.200
    27.365    18.514     0.200
    27.700    16.334     0.200
    28.575    17.200     0.200
    20.768    36.542     0.200
    20.825    35.922     0.200
    21.177    34.299     0.200
    21.177    35.078     0.200
    23.893    34.048     0.200
    24.671    28.164     0.200
    26.206    25.964     0.200
    26.753    26.152     0.200
    26.944    25.358     0.200
    27.409    20.844     0.200
    27.422    21.738     0.200
    27.422    22.148     0.200
    28.269    20.823     0.200
    28.545    18.194     0.200
    29.827    18.921     0.200
    29.834    19.345     0.200
    29.845    18.508     0.200
    18.798    38.208     0.200
    18.803    38.251     0.200
    20.441    30.650     0.200
    19.980    38.777     0.200
    20.054    37.262     0.200
    16.256    35.781     0.200
    18.231    33.003     0.200
    20.352    32.672     0.200
    20.352    32.281     0.200
    20.365    31.978     0.200
    20.352    33.180     0.200
    20.638    32.946     0.200
    20.638    33.192     0.200
    20.768    33.172     0.200
    21.457    32.767     0.200
    23.393    32.295     0.200
    26.198    20.356     0.200
    26.441    20.529     0.200
    26.441    19.888     0.200
    26.441    20.786     0.200
    26.910    20.055     0.200
    26.910    18.954     0.200
    26.910    18.766     0.200
    27.317    20.855     0.200
    27.858    16.323     0.200
    27.858    16.643     0.200
    27.858    16.784     0.200
    28.183    14.997     0.200
    28.183    16.864     0.200
    29.115    14.686     0.200
    29.115    15.405     0.200
    29.115    14.515     0.200
    29.115    15.116     0.200
    19.860    38.309     0.200
    20.520    37.369     0.200
    20.528    38.093     0.200
    20.524    37.445     0.200
    20.586    37.318     0.200
    21.161    36.108     0.200
    25.768    28.372     0.200
    26.640    26.904     0.200
    26.640    26.517     0.200
    19.327    39.466     0.200
    18.856    39.080     0.200
    18.916    37.657     0.200
    18.922    39.146     0.200
    19.344    38.781     0.200
    19.654    39.159     0.200
    20.266    37.783     0.200
    20.266    38.594     0.200
    20.266    37.082     0.200
    20.282    38.730     0.200
    21.577    37.642     0.200
    21.878    36.842     0.200
    23.515    35.928     0.200
    23.693    35.066     0.200
    25.197    30.490     0.200
    25.807    29.207     0.200
    26.553    26.405     0.200
    26.796    26.411     0.200
    27.520    24.858     0.200
    27.520    26.639     0.200
    27.827    26.369     0.200
    27.904    23.778     0.200
    27.904    22.065     0.200
    28.379    20.863     0.200
    28.379    22.873     0.200
    29.865    20.798     0.200
    29.931    17.148     0.200
    20.880    36.391     0.200
    29.286    19.787     0.200
    19.800    40.253     0.200
    19.551    31.866     0.200
    19.607    29.438     0.200
    20.376    40.139     0.200
    19.955    35.957     0.200
    20.847    33.196     0.200
    20.493    35.136     0.200
    20.493    33.073     0.200
    20.721    31.054     0.200
    27.245    20.100     0.200
    27.245    19.014     0.200
    20.235    34.858     0.200
    20.593    32.134     0.200
    27.308    19.394     0.200
    19.572    34.871     0.200
    20.238    32.983     0.200
    26.312    24.282     0.200
    19.831    33.938     0.200
    19.831    32.893     0.200
    19.902    33.216     0.200
    20.629    33.922     0.200
    19.892    34.928     0.200
    19.948    35.647     0.200
    20.017    35.217     0.200
    24.138    31.673     0.200
    19.946    34.663     0.200
    20.377    30.960     0.200
    27.330    18.537     0.200
    27.942    18.522     0.200
    19.547    32.394     0.200
    20.252    32.605     0.200
    20.266    31.556     0.200
    27.491    19.302     0.200
    20.082    31.273     0.200
    20.168    34.188     0.200
    20.481    30.483     0.200
    21.323    34.020     0.200
    21.563    33.829     0.200
    27.270    18.038     0.200
    19.544    33.202     0.200
    27.123    14.963     0.200
    19.235    28.680     0.200
    20.446    24.591     0.200
    20.163    39.442     0.200
    20.260    40.719     0.200
    20.260    39.090     0.200
    20.317    39.392     0.200
    21.852    38.611     0.200
    26.600    31.531     0.200
    26.600    28.722     0.200
    19.662    34.097     0.200
    29.716    15.361     0.200
    20.202    33.297     0.200
    20.202    32.766     0.200
    20.215    32.023     0.200
    20.488    33.643     0.200
    20.488    32.600     0.200
    20.575    33.242     0.200
    25.204    25.486     0.200
    26.430    23.037     0.200
    26.896    21.043     0.200
    26.896    19.078     0.200
    17.230    42.097     0.200
    19.545    39.733     0.200
    19.559    40.017     0.200
    20.171    39.150     0.200
    20.270    39.153     0.200
    20.270    38.883     0.200
    20.327    39.228     0.200
    21.076    39.750     0.200
    22.425    36.969     0.200
    22.854    38.777     0.200
    22.868    38.891     0.200
    23.342    38.358     0.200
    23.802    36.446     0.200
    23.861    36.589     0.200
    23.942    36.146     0.200
    24.245    36.454     0.200
    24.387    35.336     0.200
    24.510    34.780     0.200
    24.558    35.764     0.200
    24.558    34.490     0.200
    24.604    34.978     0.200
    24.642    34.571     0.200
    24.688    33.931     0.200
    24.857    34.195     0.200
    24.978    33.878     0.200
    25.007    33.094     0.200
    25.146    32.371     0.200
    25.552    33.128     0.200
    25.540    30.147     0.200
    26.277    29.880     0.200
    26.592    27.368     0.200
    26.592    28.528     0.200
    27.290    26.880     0.200
    27.290    26.380     0.200
    27.290    25.220     0.200
    27.443    26.782     0.200
    27.897    25.798     0.200
    28.966    23.827     0.200
    29.093    26.158     0.200
    29.182    21.863     0.200
    20.278    36.508     0.200
    20.278    37.242     0.200
    19.572    40.245     0.200
    20.229    39.071     0.200
    19.983    32.540     0.200
    19.997    32.441     0.200
    20.418    31.005     0.200
    19.662    34.901     0.200
    20.918    38.036     0.200
    16.545    35.635     0.200
    19.494    32.578     0.200
    19.558    32.814     0.200
    19.615    32.597     0.200
    19.780    29.846     0.200
    20.414    33.063     0.200
    23.138    29.211     0.200
    23.347    30.125     0.200
    23.860    27.275     0.200
    23.973    27.482     0.200
    23.973    26.558     0.200
    24.227    26.620     0.200
    24.498    26.101     0.200
    25.842    23.387     0.200
    27.167    16.818     0.200
    27.437    17.515     0.200
    19.554    40.085     0.200
    20.276    38.880     0.200
    25.534    31.126     0.200
    19.564    37.749     0.200
    19.625    33.625     0.200
    20.205    31.383     0.200
    16.216    34.461     0.200
    16.216    33.660     0.200
    16.479    33.393     0.200
    19.835    31.650     0.200
    19.849    30.927     0.200
    20.027    31.812     0.200
    20.052    31.398     0.200
    20.052    31.129     0.200
    20.051    31.774     0.200
    20.109    31.674     0.200
    20.346    34.441     0.200
    23.506    26.649     0.200
    26.456    19.017     0.200
    26.456    18.697     0.200
    26.900    15.647     0.200
    26.913    15.795     0.200
    26.913    16.268     0.200
    26.913    16.369     0.200
    26.913    15.916     0.200
    27.427    20.461     0.200
    27.612    16.217     0.200
    27.612    13.904     0.200
    27.612    12.635     0.200
    27.830    16.072     0.200
    28.473    13.719     0.200
    28.699    13.767     0.200
    17.188    34.462     0.200
    18.261    31.962     0.200
    18.261    31.841     0.200
    20.043    32.518     0.200
    20.392    32.361     0.200
    20.392    31.302     0.200
    20.431    32.253     0.200
    24.340    25.324     0.200
    26.374    20.961     0.200
    26.837    17.758     0.200
    26.837    17.832     0.200
    26.837    18.059     0.200
    27.131    16.025     0.200
    28.817    15.161     0.200
    20.345    30.998     0.200
    16.956    38.860     0.200
    20.325    37.820     0.200
    27.266    27.114     0.200
    27.266    23.575     0.200
    19.858    30.560     0.200
    20.249    31.503     0.200
    19.344    28.939     0.200
    20.127    29.020     0.200
    26.541    14.126     0.200
    15.846    39.521     0.200
    19.047    36.756     0.200
    19.104    36.318     0.200
    20.569    33.341     0.200
    20.567    39.053     0.200
    19.935    38.520     0.200
    21.456    34.347     0.200
    28.098    20.029     0.200
    29.250    21.990     0.200
    19.724    36.047     0.200
    20.041    34.543     0.200
    20.839    32.973     0.200
    22.555    33.199     0.200
    23.818    33.347     0.200
    23.862    33.346     0.200
    24.167    30.276     0.200
    29.813    16.434     0.200
    13.035    30.322     0.200
    19.970    28.596     0.200
    26.612    13.271     0.200
    19.744    32.852     0.200
    20.459    38.629     0.200
    21.318    35.021     0.200
    24.057    35.811     0.200
    27.696    23.790     0.200
    27.696    23.665     0.200
    27.696    23.790     0.200
    29.588    21.330     0.200
    13.106    33.965     0.200
    20.056    29.300     0.200
    19.467    40.318     0.200
    19.752    40.469     0.200
    19.891    39.397     0.200
    19.891    39.727     0.200
    14.897    40.278     0.200
    20.718    36.567     0.200
    20.707    37.979     0.200
    20.707    37.578     0.200
    20.707    38.408     0.200
    20.705    37.296     0.200
    20.841    39.236     0.200
    21.235    39.104     0.200
    22.332    38.087     0.200
    22.391    38.291     0.200
    23.694    35.816     0.200
    23.876    35.443     0.200
    24.139    35.945     0.200
    24.151    35.085     0.200
    24.598    33.233     0.200
    24.631    33.396     0.200
    26.512    24.929     0.200
    26.562    29.675     0.200
    26.644    26.289     0.200
    26.791    27.139     0.200
    27.117    25.118     0.200
    27.117    23.942     0.200
    27.082    30.478     0.200
    28.096    24.575     0.200
    28.556    24.422     0.200
    28.556    23.301     0.200
    29.112    21.613     0.200
    20.678    33.430     0.200
    20.701    33.993     0.200
    27.092    20.426     0.200
    19.277    33.473     0.200
    19.277    32.523     0.200
    19.334    32.846     0.200
    19.912    32.483     0.200
    19.897    32.232     0.200
    26.087    20.096     0.200
    14.446    39.729     0.200
    19.932    37.685     0.200
    19.932    35.220     0.200
    21.366    34.669     0.200
    21.353    35.330     0.200
    28.035    23.045     0.200
    28.035    19.920     0.200
    28.035    19.666     0.200
    29.324    21.350     0.200
    19.958    38.318     0.200
    19.263    36.499     0.200
    29.601    17.329     0.200
    15.410    38.738     0.200
    16.318    39.969     0.200
    18.778    35.964     0.200
    18.778    36.942     0.200
    18.778    37.338     0.200
    19.483    41.126     0.200
    19.953    36.133     0.200
    20.256    37.184     0.200
    20.443    38.516     0.200
    20.443    36.960     0.200
    20.662    37.714     0.200
    20.608    38.122     0.200
    20.827    37.222     0.200
    20.900    37.652     0.200
    20.915    37.651     0.200
    20.828    37.142     0.200
    20.830    37.046     0.200
    20.831    36.742     0.200
    20.831    36.402     0.200
    21.005    37.461     0.200
    21.285    36.790     0.200
    21.531    36.828     0.200
    21.596    37.380     0.200
    21.582    34.983     0.200
    21.582    35.143     0.200
    21.595    35.024     0.200
    21.735    37.352     0.200
    21.820    37.160     0.200
    21.907    37.028     0.200
    21.956    36.323     0.200
    21.967    37.079     0.200
    22.022    36.938     0.200
    22.125    36.392     0.200
    22.186    36.344     0.200
    22.282    35.879     0.200
    22.405    36.341     0.200
    22.402    36.194     0.200
    22.445    36.438     0.200
    22.519    36.832     0.200
    22.519    36.983     0.200
    22.519    36.403     0.200
    22.552    36.027     0.200
    22.544    35.717     0.200
    22.803    35.189     0.200
    22.863    36.064     0.200
    22.929    35.846     0.200
    23.369    34.270     0.200
    23.444    34.895     0.200
    23.688    34.212     0.200
    24.065    33.420     0.200
    24.248    32.746     0.200
    25.564    29.403     0.200
    27.205    22.657     0.200
    27.205    22.247     0.200
    27.205    22.977     0.200
    27.205    22.397     0.200
    27.311    21.816     0.200
    27.673    22.387     0.200
    27.687    24.729     0.200
    27.687    21.548     0.200
    27.687    20.640     0.200
    27.763    23.005     0.200
    27.947    23.120     0.200
    28.028    23.119     0.200
    28.301    22.173     0.200
    28.889    18.615     0.200
    28.889    18.390     0.200
    28.889    19.300     0.200
    28.990    20.117     0.200
    28.990    20.390     0.200
    29.521    22.229     0.200
    29.527    19.403     0.200
    29.527    19.054     0.200
    29.538    19.822     0.200
    29.691    15.436     0.200
    20.494    38.523     0.200
    20.861    36.639     0.200
    20.863    38.066     0.200
    20.863    36.686     0.200
    20.863    36.001     0.200
    20.920    35.994     0.200
    21.307    36.778     0.200
    21.540    35.281     0.200
    21.553    34.563     0.200
    23.419    33.199     0.200
    23.738    33.688     0.200
    23.891    32.019     0.200
    24.861    30.625     0.200
    27.154    21.175     0.200
    27.154    22.499     0.200
    27.154    22.765     0.200
    27.623    25.475     0.200
    27.637    21.818     0.200
    27.637    21.608     0.200
    27.637    21.792     0.200
    27.637    21.268     0.200
    28.995    18.299     0.200
    29.531    19.429     0.200
    29.577    19.095     0.200
    19.829    40.701     0.200
    19.829    39.279     0.200
    20.607    36.069     0.200
    20.842    37.279     0.200
    20.810    36.791     0.200
    20.933    36.307     0.200
    21.253    36.405     0.200
    21.539    34.440     0.200
    21.552    34.513     0.200
    21.546    36.062     0.200
    21.754    35.218     0.200
    21.921    35.830     0.200
    21.986    36.291     0.200
    22.299    35.251     0.200
    22.415    34.600     0.200
    26.160    27.246     0.200
    26.497    27.353     0.200
    26.642    24.286     0.200
    27.185    21.783     0.200
    27.185    21.955     0.200
    27.364    23.386     0.200
    27.653    21.261     0.200
    27.666    21.103     0.200
    27.666    20.482     0.200
    27.666    20.455     0.200
    27.916    21.701     0.200
    28.106    21.956     0.200
    28.857    18.430     0.200
    28.922    19.349     0.200
    28.942    19.118     0.200
    29.553    18.831     0.200
    27.099    24.669     0.200
    26.009    27.088     0.200
    19.619    34.722     0.200
    19.842    34.267     0.200
    18.973    36.094     0.200
    18.973    35.539     0.200
    19.030    35.202     0.200
    19.056    34.353     0.200
    20.370    32.748     0.200
    20.355    34.072     0.200
    26.541    22.302     0.200
    26.541    20.951     0.200
    26.921    20.088     0.200
    27.898    17.491     0.200
    27.898    18.257     0.200
    29.823    13.824     0.200
    18.615    37.101     0.200
    21.005    34.169     0.200
    20.989    33.796     0.200
    22.611    36.119     0.200
    23.129    30.091     0.200
    26.644    24.521     0.200
    27.231    19.351     0.200
    28.531    17.234     0.200
    28.531    16.784     0.200
    29.161    19.307     0.200
    16.921    37.272     0.200
    19.376    35.622     0.200
    19.376    35.247     0.200
    19.433    35.067     0.200
    19.481    35.076     0.200
    19.579    37.848     0.200
    19.579    34.980     0.200
    19.867    35.067     0.200
    20.305    35.130     0.200
    20.390    33.029     0.200
    20.376    33.161     0.200
    20.563    35.450     0.200
    20.781    35.327     0.200
    20.975    35.000     0.200
    21.010    34.749     0.200
    21.162    35.021     0.200
    21.477    34.962     0.200
    21.512    34.116     0.200
    21.649    34.007     0.200
    21.727    34.295     0.200
    21.776    34.394     0.200
    21.786    34.341     0.200
    22.035    33.877     0.200
    22.067    35.483     0.200
    22.154    34.900     0.200
    22.259    33.734     0.200
    22.276    33.784     0.200
    22.291    34.048     0.200
    22.395    33.245     0.200
    22.464    32.947     0.200
    22.559    33.810     0.200
    22.604    33.516     0.200
    22.734    33.250     0.200
    22.746    32.830     0.200
    22.782    33.899     0.200
    22.820    35.665     0.200
    23.141    33.008     0.200
    23.150    31.928     0.200
    23.159    32.121     0.200
    23.259    32.725     0.200
    23.307    32.170     0.200
    23.471    32.996     0.200
    23.572    31.836     0.200
    23.773    30.864     0.200
    25.062    28.187     0.200
    25.285    27.653     0.200
    25.604    25.962     0.200
    26.022    26.634     0.200
    26.049    25.527     0.200
    26.151    24.842     0.200
    26.384    23.774     0.200
    26.504    21.547     0.200
    26.698    24.799     0.200
    26.809    23.379     0.200
    27.234    21.368     0.200
    27.224    22.526     0.200
    27.340    21.026     0.200
    27.400    21.678     0.200
    27.675    17.786     0.200
    27.675    18.114     0.200
    27.924    20.678     0.200
    27.953    19.383     0.200
    27.953    19.265     0.200
    27.953    19.031     0.200
    28.305    17.723     0.200
    28.305    17.872     0.200
    28.803    17.895     0.200
    29.940    16.339     0.200
    19.610    29.047     0.200
    20.054    30.535     0.200
    20.142    30.470     0.200
    20.142    30.315     0.200
    20.199    30.264     0.200
    20.808    30.717     0.200
    23.231    28.559     0.200
    24.445    24.392     0.200
    26.702    18.582     0.200
    26.702    16.034     0.200
    26.702    14.479     0.200
    26.975    18.922     0.200
    27.122    18.470     0.200
    27.781    16.092     0.200
    28.373    14.339     0.200
    20.632    38.933     0.200
    20.780    39.257     0.200
    20.983    39.132     0.200
    21.115    39.153     0.200
    20.692    36.105     0.200
    20.788    38.964     0.200
    20.788    38.343     0.200
    20.844    37.920     0.200
    20.921    38.484     0.200
    21.006    38.061     0.200
    21.076    37.802     0.200
    23.773    34.869     0.200
    27.051    27.031     0.200
    27.051    26.804     0.200
    27.051    27.254     0.200
    19.259    37.008     0.200
    19.259    37.696     0.200
    20.896    34.103     0.200
    29.469    19.829     0.200
    20.863    33.134     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     8.125    18.183     0.200
    15.351    37.354     0.200
     3.957    13.395     0.200
     7.742    20.919     0.200
    15.410    38.438     0.200
     3.766    12.258     0.200
     7.554    19.862     0.200
     8.694    23.348     0.200
    15.557    36.257     0.200
    18.879    39.491     0.200
     8.038    20.796     0.200
     9.001    22.260     0.200
    15.706    38.313     0.200
    19.104    42.655     0.200
    20.318    42.491     0.200
     3.304    10.786     0.200
     7.080    18.022     0.200
    16.008    36.527     0.200
    19.415    38.762     0.200
    20.674    38.079     0.200
     0.877     6.433     0.200
     8.391    20.541     0.200
    16.091    38.586     0.200
     7.157    18.585     0.200
     9.230    21.399     0.200
    15.217    31.920     0.200
    15.973    37.209     0.200
    16.242    36.571     0.200
    19.213    38.588     0.200
    20.776    39.261     0.200
     7.924    20.084     0.200
     9.180    24.421     0.200
    14.194    35.409     0.200
    15.881    38.218     0.200
    15.937    38.571     0.200
     4.068    11.443     0.200
     4.864    13.454     0.200
     6.505    17.508     0.200
     6.836    17.239     0.200
     7.118    18.353     0.200
     7.296    18.275     0.200
    10.346    21.480     0.200
    12.835    31.830     0.200
    14.263    33.072     0.200
    17.098    37.682     0.200
     2.168     8.774     0.200
     3.515    11.548     0.200
     3.636    11.438     0.200
     4.252    13.553     0.200
     6.035    17.144     0.200
     6.970    19.129     0.200
     7.137    18.189     0.200
    15.583    37.518     0.200
    15.621    37.178     0.200
    15.931    36.557     0.200
    18.140    40.782     0.200
    19.776    40.688     0.200
     2.860    10.398     0.200
     4.307    13.212     0.200
     4.296    13.241     0.200
     4.827    14.941     0.200
     6.633    18.372     0.200
     7.662    19.657     0.200
     7.767    19.631     0.200
     7.846    19.612     0.200
     7.824    19.668     0.200
     8.548    20.025     0.200
     8.638    19.978     0.200
    15.347    37.676     0.200
    15.461    38.350     0.200
    15.686    34.726     0.200
    18.887    40.372     0.200
    19.475    41.498     0.200
     0.598     6.496     0.200
     3.631    11.104     0.200
     3.905    11.503     0.200
     3.842    11.038     0.200
     4.036    11.278     0.200
     4.752    13.518     0.200
     5.326    14.522     0.200
     6.180    16.153     0.200
     6.480    17.352     0.200
     6.753    16.073     0.200
     7.023    16.619     0.200
     7.155    17.380     0.200
     7.245    17.022     0.200
     7.257    16.887     0.200
     7.378    16.976     0.200
     7.942    18.896     0.200
     8.197    20.813     0.200
     9.224    20.632     0.200
     9.712    20.740     0.200
    10.212    22.302     0.200
    13.278    32.224     0.200
    14.759    30.036     0.200
    14.961    32.485     0.200
    20.125    34.712     0.200
     1.253     7.632     0.200
     1.392     6.602     0.200
     1.594     8.653     0.200
     2.139     9.794     0.200
     2.339     8.055     0.200
     2.338     9.069     0.200
     2.498     9.595     0.200
     2.766     9.368     0.200
     2.746    11.501     0.200
     2.877    12.076     0.200
     3.029    12.000     0.200
     3.214    11.639     0.200
     3.366    10.869     0.200
     3.932    13.570     0.200
     4.435    14.790     0.200
     5.413    15.387     0.200
     8.749    22.252     0.200
     8.860    22.453     0.200
     9.502    23.570     0.200
    10.051    23.853     0.200
    10.685    26.858     0.200
    14.681    34.022     0.200
    16.512    36.654     0.200
     1.223     7.177     0.200
     1.364     6.121     0.200
     1.381     7.425     0.200
     1.561     8.324     0.200
     2.311     8.773     0.200
     2.479    11.108     0.200
     2.475     9.057     0.200
     2.714    11.478     0.200
     2.750     9.048     0.200
     2.845    12.244     0.200
     3.001    11.723     0.200
     3.182    11.816     0.200
     4.425    13.999     0.200
     4.848    15.369     0.200
     5.387    15.278     0.200
     5.734    17.225     0.200
     5.973    17.634     0.200
     6.491    18.896     0.200
     6.644    18.915     0.200
     7.398    21.811     0.200
     7.455    20.841     0.200
     7.770    23.474     0.200
     7.889    21.574     0.200
     8.015    22.805     0.200
     8.259    21.259     0.200
     8.357    21.621     0.200
     8.607    21.706     0.200
     8.722    22.360     0.200
     8.764    22.873     0.200
     8.833    22.559     0.200
     8.860    23.150     0.200
     9.585    24.982     0.200
     9.508    22.389     0.200
    10.047    23.194     0.200
    10.193    26.696     0.200
    10.659    25.957     0.200
    10.909    26.832     0.200
    11.359    28.579     0.200
    14.660    36.062     0.200
    15.991    38.031     0.200
    19.955    39.773     0.200
    20.016    39.556     0.200
    20.293    42.726     0.200
    20.725    42.284     0.200
     1.254     7.593     0.200
     1.444     6.472     0.200
     1.609     8.949     0.200
     2.392     9.008     0.200
     2.557     9.383     0.200
     2.527    11.334     0.200
     2.829     9.111     0.200
     3.022    12.362     0.200
     3.189    13.210     0.200
     3.429    10.408     0.200
     4.498    13.134     0.200
     4.902    15.712     0.200
     4.998    15.697     0.200
     5.342    16.588     0.200
     5.396    15.853     0.200
     6.486    19.334     0.200
     6.694    19.510     0.200
     8.418    23.682     0.200
     8.737    21.865     0.200
     9.440    23.655     0.200
     9.622    25.533     0.200
    10.261    27.579     0.200
    10.670    27.804     0.200
    14.653    34.818     0.200
    19.910    40.870     0.200
     1.432     6.905     0.200
     1.608     8.755     0.200
     1.583     9.243     0.200
     1.846     8.173     0.200
     2.439    10.053     0.200
     2.450    11.622     0.200
     2.797    10.778     0.200
     2.682    12.010     0.200
     2.762    12.478     0.200
     2.792    13.033     0.200
     2.871    12.909     0.200
     2.987    12.058     0.200
     3.301    12.896     0.200
     4.843    15.999     0.200
     4.995    15.919     0.200
     5.301    14.551     0.200
     5.952    18.960     0.200
     6.573    18.906     0.200
     8.316    21.063     0.200
     8.316    21.563     0.200
     8.797    24.052     0.200
     9.366    27.111     0.200
    10.348    29.048     0.200
    14.103    34.535     0.200
    15.498    38.759     0.200
    15.385    37.567     0.200
    16.669    37.793     0.200
     0.575     5.252     0.200
     2.938    10.473     0.200
     3.157    10.421     0.200
     3.412    10.542     0.200
     3.818    11.111     0.200
     3.873    10.559     0.200
     4.518    13.134     0.200
     4.911    14.247     0.200
     5.119    13.926     0.200
     5.087    14.192     0.200
     5.794    16.448     0.200
     5.948    16.144     0.200
     6.205    16.544     0.200
     6.573    16.953     0.200
     6.774    17.911     0.200
     6.943    17.436     0.200
     7.067    17.087     0.200
     7.067    17.587     0.200
     7.824    20.859     0.200
     8.679    23.378     0.200
    13.218    29.310     0.200
    15.007    34.428     0.200
    19.175    35.787     0.200
    19.230    36.143     0.200
     0.722     6.413     0.200
     0.784     7.247     0.200
     0.824     7.068     0.200
     1.106     7.179     0.200
     1.195     7.654     0.200
     1.221     7.935     0.200
     1.228     7.825     0.200
     1.242     7.768     0.200
     1.523     8.198     0.200
     1.641     8.285     0.200
     1.856     8.385     0.200
     1.968     8.314     0.200
     2.152     8.616     0.200
     2.246     9.776     0.200
     2.319     9.246     0.200
     2.511     9.332     0.200
     2.873    12.193     0.200
     2.909     9.086     0.200
     2.938     9.592     0.200
     3.127    10.892     0.200
     3.139    10.603     0.200
     3.145    10.705     0.200
     3.187    11.088     0.200
     3.216    11.342     0.200
     3.273    11.331     0.200
     3.349    11.339     0.200
     3.590    11.073     0.200
     3.629    12.414     0.200
     3.942    11.877     0.200
     3.985    11.968     0.200
     3.999    11.566     0.200
     4.129    11.756     0.200
     4.186    12.109     0.200
     4.291    12.025     0.200
     4.306    11.224     0.200
     4.443    11.763     0.200
     4.570    13.114     0.200
     4.584    13.693     0.200
     4.625    12.313     0.200
     4.691    12.798     0.200
     4.698    12.258     0.200
     4.717    13.391     0.200
     4.718    12.950     0.200
     4.735    12.505     0.200
     4.755    13.085     0.200
     4.824    13.408     0.200
     4.911    13.407     0.200
     4.942    14.770     0.200
     5.076    13.563     0.200
     5.107    14.011     0.200
     5.131    13.959     0.200
     5.142    13.982     0.200
     5.285    14.528     0.200
     5.334    14.905     0.200
     5.444    14.285     0.200
     5.439    15.664     0.200
     5.581    16.108     0.200
     5.768    15.790     0.200
     5.781    14.674     0.200
     5.907    16.085     0.200
     5.950    15.284     0.200
     5.978    14.952     0.200
     6.053    16.487     0.200
     6.090    15.826     0.200
     6.285    15.441     0.200
     6.285    16.228     0.200
     6.413    16.244     0.200
     6.797    18.941     0.200
     6.809    17.128     0.200
     6.851    18.031     0.200
     6.878    16.885     0.200
     7.053    18.224     0.200
     7.090    17.111     0.200
     7.193    18.602     0.200
     7.322    17.293     0.200
     7.342    19.263     0.200
     7.475    18.282     0.200
     7.950    21.658     0.200
     8.624    21.696     0.200
     9.877    21.771     0.200
     0.605     6.330     0.200
     0.747     5.411     0.200
     0.935     7.183     0.200
     0.966     7.110     0.200
     1.384     7.474     0.200
     1.487     7.391     0.200
     1.520     7.135     0.200
     1.798     9.025     0.200
     1.971     8.467     0.200
     2.141     8.949     0.200
     2.449    11.022     0.200
     2.432     8.196     0.200
     2.478     8.782     0.200
     2.765    10.494     0.200
     2.770    10.381     0.200
     2.830    10.714     0.200
     2.847    10.813     0.200
     2.898    10.772     0.200
     2.990    10.236     0.200
     2.983    10.979     0.200
     3.211    10.976     0.200
     3.272    10.642     0.200
     3.550    11.195     0.200
     3.604    11.518     0.200
     3.549    10.804     0.200
     3.677    10.902     0.200
     3.677    10.914     0.200
     3.828    10.365     0.200
     3.882    11.459     0.200
     4.071    11.771     0.200
     4.147    11.466     0.200
     4.738    14.130     0.200
     4.653    13.072     0.200
     4.673    12.922     0.200
     4.815    13.398     0.200
     4.968    14.154     0.200
     5.193    14.621     0.200
     5.207    14.005     0.200
     5.348    14.461     0.200
     5.474    14.199     0.200
     5.472    14.362     0.200
     5.636    15.172     0.200
     5.620    14.679     0.200
     5.820    15.299     0.200
     6.346    17.566     0.200
     6.411    15.491     0.200
     6.464    15.843     0.200
     6.623    16.435     0.200
     6.674    15.974     0.200
     6.751    17.165     0.200
     6.910    16.977     0.200
     6.910    16.586     0.200
     6.905    18.540     0.200
     7.059    16.803     0.200
     7.649    18.858     0.200
     8.164    20.655     0.200
     8.578    20.723     0.200
     8.874    19.976     0.200
     9.510    20.041     0.200
    12.999    26.331     0.200
    13.085    27.123     0.200
    14.858    33.625     0.200
    19.913    36.443     0.200
     0.748     5.835     0.200
     1.367     7.017     0.200
     1.475     7.051     0.200
     1.888     8.191     0.200
     1.913     7.975     0.200
     1.915     8.699     0.200
     1.916     8.616     0.200
     1.916     8.301     0.200
     1.921     8.808     0.200
     1.935     9.328     0.200
     2.217     9.421     0.200
     2.462     9.334     0.200
     2.470     9.840     0.200
     2.893    10.370     0.200
     3.012    10.459     0.200
     3.054    10.799     0.200
     3.057    10.656     0.200
     3.056    10.772     0.200
     3.072    10.552     0.200
     3.088    10.606     0.200
     3.107    11.116     0.200
     3.141    10.608     0.200
     3.191    10.386     0.200
     3.201    10.520     0.200
     3.477    10.061     0.200
     3.566    10.514     0.200
     3.779    11.356     0.200
     3.819    11.706     0.200
     3.835    11.467     0.200
     3.880    12.005     0.200
     3.963    12.140     0.200
     4.025    11.482     0.200
     4.040    12.409     0.200
     4.264    11.344     0.200
     4.302    12.941     0.200
     4.364    12.628     0.200
     4.646    13.843     0.200
     4.674    14.027     0.200
     4.770    12.566     0.200
     4.770    12.996     0.200
     4.803    12.830     0.200
     4.853    12.492     0.200
     4.975    13.307     0.200
     5.000    12.505     0.200
     5.160    13.327     0.200
     5.170    13.559     0.200
     5.263    14.853     0.200
     5.299    13.991     0.200
     5.599    15.216     0.200
     5.688    15.035     0.200
     5.905    16.485     0.200
     6.033    16.856     0.200
     6.237    17.045     0.200
     6.252    17.353     0.200
     6.272    18.115     0.200
     6.395    16.549     0.200
     6.441    17.015     0.200
     6.458    16.465     0.200
     6.531    16.512     0.200
     6.726    18.276     0.200
     6.868    17.375     0.200
     6.874    17.807     0.200
     6.899    17.788     0.200
     7.285    18.694     0.200
     7.555    17.908     0.200
     7.718    18.989     0.200
     7.766    18.164     0.200
     7.982    20.125     0.200
     8.000    18.902     0.200
     8.151    19.759     0.200
     8.639    23.240     0.200
     9.068    20.799     0.200
    10.002    24.331     0.200
    14.170    31.195     0.200
    14.345    32.449     0.200
     1.470     7.791     0.200
     1.757     8.817     0.200
     1.941     9.391     0.200
     1.963     9.391     0.200
     2.058     9.136     0.200
     2.273     8.997     0.200
     2.253     9.629     0.200
     2.254     9.644     0.200
     2.256     9.669     0.200
     2.272     9.177     0.200
     2.283     9.663     0.200
     2.305     9.514     0.200
     2.315     9.204     0.200
     2.259     9.126     0.200
     2.368     9.473     0.200
     2.377     9.810     0.200
     2.429    11.046     0.200
     2.767     9.196     0.200
     2.821    10.058     0.200
     2.790    10.231     0.200
     2.887    10.445     0.200
     2.921    11.063     0.200
     2.937    11.131     0.200
     2.978    10.262     0.200
     2.979     8.573     0.200
     2.992    11.267     0.200
     3.010    11.079     0.200
     3.075    10.938     0.200
     3.114    11.484     0.200
     3.168    11.049     0.200
     3.258    10.869     0.200
     3.372    10.467     0.200
     3.425    12.153     0.200
     3.436    11.108     0.200
     3.473    11.178     0.200
     3.473    10.728     0.200
     3.494    10.540     0.200
     3.517    11.407     0.200
     3.648    11.404     0.200
     3.683    11.622     0.200
     3.676    12.009     0.200
     3.670    12.326     0.200
     3.810    12.164     0.200
     3.819    12.101     0.200
     3.846    12.030     0.200
     3.943    13.077     0.200
     4.017    11.711     0.200
     4.069    13.213     0.200
     4.134    14.793     0.200
     4.178    12.428     0.200
     4.209    13.008     0.200
     4.603    14.707     0.200
     4.750    14.644     0.200
     4.774    14.422     0.200
     4.778    15.556     0.200
     4.997    14.353     0.200
     5.116    14.363     0.200
     5.118    15.505     0.200
     5.174    15.158     0.200
     5.148    14.963     0.200
     5.250    16.096     0.200
     5.253    15.906     0.200
     5.334    15.324     0.200
     5.349    15.222     0.200
     5.499    15.939     0.200
     5.558    16.565     0.200
     5.752    16.690     0.200
     5.818    18.422     0.200
     5.995    17.115     0.200
     6.273    17.125     0.200
     6.350    17.120     0.200
     6.356    19.452     0.200
     6.371    17.678     0.200
     6.374    17.296     0.200
     6.423    19.168     0.200
     6.470    17.670     0.200
     6.574    17.901     0.200
     6.591    17.211     0.200
     6.820    17.718     0.200
     6.954    18.802     0.200
     7.846    20.169     0.200
    20.725    38.055     0.200
     0.095     4.879     0.200
     0.773     5.464     0.200
     1.243     6.552     0.200
     1.572     7.867     0.200
     1.586     8.250     0.200
     1.597     7.746     0.200
     1.602     8.148     0.200
     1.669     8.201     0.200
     1.612     7.806     0.200
     1.618     8.129     0.200
     1.652     7.370     0.200
     1.816     8.154     0.200
     1.877     8.545     0.200
     1.854     8.455     0.200
     2.106     8.270     0.200
     2.244     8.831     0.200
     2.257     8.667     0.200
     2.588     9.328     0.200
     2.631     9.676     0.200
     2.632     9.686     0.200
     2.653     9.589     0.200
     2.657     9.704     0.200
     2.768     8.678     0.200
     2.737     9.748     0.200
     2.760     9.853     0.200
     2.923     9.407     0.200
     2.983    11.594     0.200
     3.112     9.779     0.200
     3.314     9.653     0.200
     3.241    10.801     0.200
     3.359    10.798     0.200
     3.366    11.796     0.200
     3.373    11.059     0.200
     3.397    11.470     0.200
     3.433    11.300     0.200
     3.436    11.006     0.200
     3.441    10.940     0.200
     3.598    10.204     0.200
     3.486    11.428     0.200
     3.578    11.480     0.200
     3.706    10.937     0.200
     3.640    10.039     0.200
     3.729    10.971     0.200
     3.743    11.565     0.200
     4.020    11.380     0.200
     4.046    12.371     0.200
     4.132    11.397     0.200
     4.131    11.542     0.200
     4.133    11.348     0.200
     4.251    11.163     0.200
     4.181    12.379     0.200
     4.410    12.257     0.200
     4.503    12.746     0.200
     4.561    12.662     0.200
     4.692    13.295     0.200
     4.713    14.391     0.200
     4.957    13.629     0.200
     5.074    12.979     0.200
     5.330    15.182     0.200
     5.391    14.630     0.200
     5.518    15.793     0.200
     5.700    15.009     0.200
     5.756    15.166     0.200
     5.733    15.814     0.200
     5.833    15.751     0.200
     6.095    15.717     0.200
     6.303    16.977     0.200
     6.509    17.381     0.200
     6.728    17.665     0.200
     7.000    17.706     0.200
     7.065    17.783     0.200
     7.449    19.566     0.200
     7.434    16.795     0.200
     7.459    18.307     0.200
     8.192    20.341     0.200
     8.275    21.464     0.200
     9.300    20.452     0.200
     0.786    11.126     0.200
     0.849    10.698     0.200
     1.189    10.356     0.200
     1.203    10.511     0.200
     1.205    10.814     0.200
     1.210     9.730     0.200
     1.220    10.589     0.200
     1.225    10.543     0.200
     1.373    10.107     0.200
     1.389     9.871     0.200
     1.539     8.204     0.200
     1.873    10.466     0.200
     2.106    10.906     0.200
     2.222    10.448     0.200
     2.253    10.898     0.200
     2.295    11.132     0.200
     2.295    11.107     0.200
     2.332    11.040     0.200
     2.424    11.485     0.200
     2.471    11.339     0.200
     2.482    10.924     0.200
     2.490    10.649     0.200
     2.645    11.115     0.200
     2.943    11.762     0.200
     3.071    11.980     0.200
     3.091    11.781     0.200
     3.097    12.268     0.200
     3.119    12.175     0.200
     3.141    12.506     0.200
     3.180    11.693     0.200
     3.212    12.128     0.200
     3.262    12.545     0.200
     3.289    11.523     0.200
     3.904    12.393     0.200
     3.999    12.398     0.200
     4.077    12.692     0.200
     4.089    12.441     0.200
     4.294    11.557     0.200
     4.418    12.604     0.200
     4.490    12.309     0.200
     4.351    12.205     0.200
     4.482    13.942     0.200
     4.598    13.293     0.200
     4.720    12.739     0.200
     4.755    13.892     0.200
     4.898    12.724     0.200
     4.999    13.727     0.200
     5.103    13.786     0.200
     5.128    14.641     0.200
     5.157    14.233     0.200
     5.223    15.100     0.200
     5.459    15.061     0.200
     5.475    14.567     0.200
     5.487    15.455     0.200
     5.704    15.093     0.200
     5.777    15.456     0.200
     5.962    17.197     0.200
     6.031    15.933     0.200
     6.191    15.910     0.200
     6.298    16.093     0.200
     6.363    16.184     0.200
     6.492    16.891     0.200
     6.737    15.556     0.200
     6.857    16.070     0.200
     6.872    16.804     0.200
     6.897    17.587     0.200
     7.072    16.401     0.200
     7.086    16.767     0.200
     7.150    18.941     0.200
     7.247    17.178     0.200
     7.290    16.694     0.200
     7.302    19.358     0.200
     7.396    16.667     0.200
     7.396    16.952     0.200
     7.456    17.160     0.200
     7.546    19.483     0.200
     7.634    19.085     0.200
     7.838    20.831     0.200
     7.935    19.308     0.200
     7.969    20.660     0.200
     9.270    20.887     0.200
    10.617    22.170     0.200
    12.888    26.944     0.200
    13.679    28.820     0.200
     0.596     5.067     0.200
     1.024     6.089     0.200
     1.357     7.663     0.200
     1.372     7.794     0.200
     1.381     7.968     0.200
     1.382     7.287     0.200
     1.387     7.552     0.200
     1.403     7.661     0.200
     1.437     7.070     0.200
     1.509     7.883     0.200
     1.644     8.220     0.200
     1.675     7.808     0.200
     1.715     8.139     0.200
     1.920     7.841     0.200
     1.896     7.775     0.200
     2.039     8.566     0.200
     2.137     9.058     0.200
     2.389     9.140     0.200
     2.433     9.496     0.200
     2.433     9.455     0.200
     2.460     9.473     0.200
     2.549     9.381     0.200
     2.563     9.636     0.200
     2.665     8.432     0.200
     2.784     9.031     0.200
     2.815    11.169     0.200
     2.996     9.251     0.200
     3.051    10.416     0.200
     3.171    10.246     0.200
     3.175    11.449     0.200
     3.183    10.694     0.200
     3.208    11.212     0.200
     3.240    11.163     0.200
     3.245    10.821     0.200
     3.252    10.550     0.200
     3.399    10.262     0.200
     3.421    10.409     0.200
     3.576    11.209     0.200
     3.589    10.973     0.200
     3.595    10.305     0.200
     3.893    11.922     0.200
     3.966    11.355     0.200
     3.994    11.246     0.200
     3.994    10.516     0.200
     3.999    11.958     0.200
     4.008    11.341     0.200
     4.200    11.804     0.200
     4.373    12.056     0.200
     4.360    11.871     0.200
     4.481    12.307     0.200
     4.545    13.048     0.200
     4.666    13.207     0.200
     4.871    13.568     0.200
     5.182    14.564     0.200
     5.175    14.057     0.200
     5.225    14.980     0.200
     5.079    12.784     0.200
     5.423    15.514     0.200
     5.559    15.755     0.200
     5.602    15.646     0.200
     5.641    14.829     0.200
     5.695    15.348     0.200
     5.737    16.086     0.200
     6.001    16.153     0.200
     6.062    15.867     0.200
     6.099    15.821     0.200
     6.309    16.923     0.200
     6.351    16.550     0.200
     6.789    16.559     0.200
     6.826    16.830     0.200
     6.966    17.597     0.200
     7.034    16.513     0.200
     7.080    17.916     0.200
     7.122    21.394     0.200
     7.273    16.798     0.200
     7.306    17.278     0.200
     7.306    17.324     0.200
     7.366    18.791     0.200
     7.418    18.721     0.200
     7.991    19.479     0.200
     8.074    19.668     0.200
     8.933    23.629     0.200
     9.390    20.974     0.200
    10.108    21.851     0.200
    20.734    36.324     0.200
     0.646     5.411     0.200
     0.789     6.159     0.200
     1.447     8.188     0.200
     1.511     8.074     0.200
     1.490     8.478     0.200
     1.646     8.702     0.200
     1.691     9.317     0.200
     1.691     9.016     0.200
     1.710     8.044     0.200
     1.711     9.308     0.200
     1.718     9.296     0.200
     1.730     9.249     0.200
     1.732     9.284     0.200
     1.768     8.285     0.200
     1.893     9.626     0.200
     1.931     8.775     0.200
     2.027     9.256     0.200
     2.175     9.752     0.200
     2.217     9.458     0.200
     2.219     9.444     0.200
     2.233     9.737     0.200
     2.318     8.532     0.200
     2.289     9.695     0.200
     2.426    10.012     0.200
     2.506     9.659     0.200
     2.564     9.823     0.200
     2.573     9.960     0.200
     2.596     9.958     0.200
     2.662     9.776     0.200
     2.666    10.130     0.200
     2.687     9.318     0.200
     2.730     9.292     0.200
     2.731    11.494     0.200
     2.765     9.514     0.200
     2.991    11.836     0.200
     3.099    10.556     0.200
     3.248    10.865     0.200
     3.278    10.619     0.200
     3.281    11.037     0.200
     3.291    11.279     0.200
     3.326    10.859     0.200
     3.365    11.177     0.200
     3.469    11.322     0.200
     3.611    11.040     0.200
     3.668    11.366     0.200
     3.717    11.082     0.200
     3.721    12.226     0.200
     3.760    11.503     0.200
     3.760    11.212     0.200
     3.768    12.101     0.200
     3.963    12.224     0.200
     4.045    12.702     0.200
     4.088    12.996     0.200
     4.100    12.652     0.200
     4.337    13.714     0.200
     4.434    14.798     0.200
     4.449    13.482     0.200
     4.860    15.329     0.200
     4.915    15.231     0.200
     5.024    16.124     0.200
     5.034    14.995     0.200
     5.147    14.772     0.200
     5.166    15.049     0.200
     5.243    16.130     0.200
     5.376    15.610     0.200
     5.445    16.297     0.200
     5.426    15.132     0.200
     5.475    16.120     0.200
     5.489    16.191     0.200
     5.509    15.673     0.200
     5.545    16.076     0.200
     5.555    15.914     0.200
     5.688    15.864     0.200
     5.763    16.362     0.200
     5.689    18.315     0.200
     5.855    16.871     0.200
     5.914    15.904     0.200
     6.078    16.621     0.200
     6.112    16.197     0.200
     6.242    17.961     0.200
     6.259    19.004     0.200
     6.444    17.609     0.200
     6.634    17.092     0.200
     6.665    16.335     0.200
     6.673    17.316     0.200
     6.684    17.246     0.200
     6.758    18.556     0.200
     6.868    17.865     0.200
     6.928    19.595     0.200
     7.042    18.231     0.200
     7.109    18.190     0.200
     7.109    18.193     0.200
     7.114    17.625     0.200
     7.114    18.225     0.200
     7.124    18.679     0.200
     7.247    18.925     0.200
     7.621    20.575     0.200
     8.017    20.793     0.200
     8.067    20.108     0.200
     8.147    20.754     0.200
     8.396    21.365     0.200
     8.700    21.342     0.200
     8.841    22.970     0.200
     9.037    22.980     0.200
     9.377    24.754     0.200
     9.925    22.990     0.200
    11.267    28.128     0.200
    13.031    31.080     0.200
    15.711    35.296     0.200
    15.711    35.496     0.200
    15.712    34.730     0.200
    20.628    39.083     0.200
     0.252     8.971     0.200
     0.641     7.392     0.200
     0.632     7.636     0.200
     0.664     7.744     0.200
     0.689     8.018     0.200
     0.692     7.906     0.200
     0.692     8.057     0.200
     0.692     7.624     0.200
     0.696     7.890     0.200
     0.710     7.815     0.200
     0.996     7.929     0.200
     1.106     6.739     0.200
     1.151     7.481     0.200
     1.247     7.967     0.200
     1.410     8.399     0.200
     1.406     8.102     0.200
     1.414     8.078     0.200
     1.490     8.021     0.200
     1.773     7.978     0.200
     1.809     9.371     0.200
     1.890     8.955     0.200
     1.996     8.682     0.200
     2.393    11.085     0.200
     2.516     8.896     0.200
     2.563     8.467     0.200
     2.626    10.111     0.200
     2.629     9.959     0.200
     2.652    10.389     0.200
     2.639     9.606     0.200
     2.664    10.371     0.200
     2.683    10.221     0.200
     2.697     9.934     0.200
     2.757    10.414     0.200
     2.822     9.298     0.200
     3.164    10.303     0.200
     3.190    10.234     0.200
     3.207    10.279     0.200
     3.247    10.254     0.200
     3.281    10.610     0.200
     3.322    10.781     0.200
     3.448    10.492     0.200
     3.469    11.389     0.200
     3.515    11.473     0.200
     3.681    10.961     0.200
     3.681    10.481     0.200
     3.829    11.710     0.200
     3.865    11.258     0.200
     3.883    11.389     0.200
     3.964    10.798     0.200
     4.085    12.266     0.200
     4.094    11.382     0.200
     4.412    12.086     0.200
     4.448    12.821     0.200
     4.424    12.965     0.200
     4.644    13.088     0.200
     5.039    13.888     0.200
     5.052    14.303     0.200
     5.061    14.599     0.200
     5.036    14.725     0.200
     5.280    14.479     0.200
     5.275    14.294     0.200
     5.359    14.389     0.200
     5.537    14.610     0.200
     5.549    14.907     0.200
     5.635    14.381     0.200
     5.693    15.042     0.200
     5.838    15.387     0.200
     5.861    15.079     0.200
     5.858    15.692     0.200
     6.147    15.663     0.200
     6.269    16.653     0.200
     6.299    15.380     0.200
     6.379    16.104     0.200
     6.534    17.433     0.200
     6.517    17.024     0.200
     6.568    16.537     0.200
     6.600    16.223     0.200
     6.592    16.338     0.200
     6.794    16.167     0.200
     6.821    16.837     0.200
     6.821    16.766     0.200
     6.893    18.056     0.200
     6.966    17.319     0.200
     6.978    16.998     0.200
     7.371    17.854     0.200
     7.417    19.368     0.200
     7.834    18.289     0.200
     8.129    21.467     0.200
     8.691    21.671     0.200
     8.796    19.800     0.200
     9.675    23.290     0.200
     9.874    20.850     0.200
    13.097    28.851     0.200
     0.708     5.863     0.200
     1.487     7.309     0.200
     1.721     8.029     0.200
     2.037     8.341     0.200
     2.122     9.035     0.200
     2.145     9.330     0.200
     2.147     9.125     0.200
     2.149     9.148     0.200
     2.151     9.267     0.200
     2.157     9.171     0.200
     2.169     9.214     0.200
     2.402     9.569     0.200
     2.391     8.729     0.200
     2.441     9.538     0.200
     2.570     9.757     0.200
     2.607    10.067     0.200
     2.802    10.050     0.200
     2.864     9.884     0.200
     2.851     9.833     0.200
     2.854    10.222     0.200
     2.877    10.074     0.200
     3.030    10.796     0.200
     3.223    10.578     0.200
     3.541    10.268     0.200
     3.679    10.801     0.200
     3.701    12.865     0.200
     3.882    10.805     0.200
     4.036    10.987     0.200
     4.031    11.827     0.200
     4.037    12.459     0.200
     4.062    13.049     0.200
     4.087    12.631     0.200
     4.070    11.951     0.200
     4.107    12.468     0.200
     4.287    12.005     0.200
     4.314    11.607     0.200
     4.382    12.587     0.200
     4.479    12.488     0.200
     4.399    10.576     0.200
     4.484    12.628     0.200
     4.865    13.616     0.200
     4.892    12.622     0.200
     4.889    12.802     0.200
     4.889    12.681     0.200
     4.905    13.365     0.200
     5.095    13.480     0.200
     5.266    13.453     0.200
     5.333    14.214     0.200
     5.360    14.503     0.200
     5.430    14.785     0.200
     5.520    14.441     0.200
     5.552    14.973     0.200
     5.880    15.737     0.200
     6.103    16.530     0.200
     6.362    16.823     0.200
     6.435    16.991     0.200
     6.463    16.409     0.200
     6.494    16.779     0.200
     6.468    17.842     0.200
     6.590    16.936     0.200
     6.617    17.256     0.200
     6.809    17.263     0.200
     6.837    17.373     0.200
     6.985    17.781     0.200
     7.242    18.273     0.200
     7.417    18.716     0.200
     7.537    20.593     0.200
     7.670    18.353     0.200
     7.860    19.455     0.200
     7.924    18.717     0.200
     8.162    18.106     0.200
     8.200    18.786     0.200
     8.221    20.998     0.200
     8.797    21.029     0.200
     8.882    21.839     0.200
     9.392    23.447     0.200
     9.686    23.319     0.200
     9.806    22.077     0.200
    10.144    22.776     0.200
    14.261    29.830     0.200
    14.511    30.170     0.200
     0.708     6.047     0.200
     0.830     6.984     0.200
     0.828     7.463     0.200
     1.144     7.523     0.200
     1.239     7.863     0.200
     1.264     8.162     0.200
     1.266     8.147     0.200
     1.267     8.848     0.200
     1.267     7.802     0.200
     1.267     8.107     0.200
     1.273     8.032     0.200
     1.286     7.999     0.200
     1.568     8.440     0.200
     1.536     8.174     0.200
     1.682     8.431     0.200
     1.713     8.213     0.200
     1.871     8.793     0.200
     1.896     8.509     0.200
     1.932     8.786     0.200
     1.979     8.774     0.200
     1.985     8.687     0.200
     2.013     8.495     0.200
     2.192     8.726     0.200
     2.364     9.427     0.200
     2.440     9.610     0.200
     2.458     9.897     0.200
     2.492     9.906     0.200
     2.917    11.948     0.200
     2.948     9.226     0.200
     2.980     9.887     0.200
     3.056    10.792     0.200
     3.172    11.113     0.200
     3.190    10.895     0.200
     3.178    10.690     0.200
     3.216    11.214     0.200
     3.245    10.159     0.200
     3.232    11.316     0.200
     3.248    11.102     0.200
     3.261    10.658     0.200
     3.318    11.229     0.200
     3.394    11.472     0.200
     3.561    10.463     0.200
     3.633    10.806     0.200
     3.674    11.789     0.200
     3.768    11.634     0.200
     3.866    11.260     0.200
     4.026    12.222     0.200
     4.030    12.475     0.200
     4.030    12.005     0.200
     4.172    11.666     0.200
     4.172    11.323     0.200
     4.228    11.788     0.200
     4.290    11.812     0.200
     4.325    12.406     0.200
     4.344    11.542     0.200
     4.376    12.559     0.200
     4.572    12.484     0.200
     4.629    13.574     0.200
     4.663    12.705     0.200
     4.724    12.860     0.200
     4.684    13.752     0.200
     4.793    13.172     0.200
     4.902    13.741     0.200
     4.944    13.245     0.200
     4.982    14.439     0.200
     5.138    13.772     0.200
     5.169    14.190     0.200
     5.311    14.197     0.200
     5.480    15.756     0.200
     5.701    16.227     0.200
     5.864    15.594     0.200
     5.981    15.878     0.200
     5.985    15.558     0.200
     6.008    15.472     0.200
     6.122    16.023     0.200
     6.446    16.655     0.200
     6.509    17.092     0.200
     6.840    19.335     0.200
     6.882    17.916     0.200
     7.367    17.258     0.200
     7.427    17.699     0.200
     7.427    17.843     0.200
     7.427    17.929     0.200
     7.544    17.625     0.200
     7.662    19.774     0.200
     7.909    19.766     0.200
     9.899    23.781     0.200
    10.208    22.876     0.200
     0.539     4.239     0.200
     0.457     5.528     0.200
     0.794     6.096     0.200
     1.132     6.847     0.200
     1.149     7.453     0.200
     1.157     7.161     0.200
     1.158     6.657     0.200
     1.162     7.197     0.200
     1.172     7.186     0.200
     1.179     7.200     0.200
     1.209     6.651     0.200
     1.363     7.352     0.200
     1.430     6.971     0.200
     1.428     7.802     0.200
     1.552     7.650     0.200
     1.564     8.005     0.200
     1.578     7.444     0.200
     1.675     7.313     0.200
     1.691     7.634     0.200
     1.777     7.451     0.200
     1.783     7.851     0.200
     1.850     7.873     0.200
     1.828     8.225     0.200
     1.830     7.810     0.200
     1.846     7.716     0.200
     1.988     9.067     0.200
     2.187     8.742     0.200
     2.259     9.103     0.200
     2.329     9.182     0.200
     2.355     9.184     0.200
     2.362     9.197     0.200
     2.537     9.450     0.200
     2.578     8.273     0.200
     2.650    11.035     0.200
     2.858    10.315     0.200
     2.893     9.002     0.200
     2.980    10.488     0.200
     2.982    10.460     0.200
     2.991    10.555     0.200
     3.044    10.638     0.200
     3.052    10.482     0.200
     3.060    10.750     0.200
     3.111    10.063     0.200
     3.165     9.528     0.200
     3.196    10.963     0.200
     3.192     9.946     0.200
     3.289     9.877     0.200
     3.349    10.179     0.200
     3.412    10.743     0.200
     3.455    10.844     0.200
     3.507    10.538     0.200
     3.612     9.515     0.200
     3.744    11.575     0.200
     3.815    11.545     0.200
     3.861    11.010     0.200
     3.861    10.491     0.200
     3.893    11.135     0.200
     3.927    11.633     0.200
     3.933    10.971     0.200
     3.966    10.581     0.200
     4.066    11.610     0.200
     4.128    10.887     0.200
     4.249    11.238     0.200
     4.284    11.769     0.200
     4.325    12.087     0.200
     4.378    12.670     0.200
     4.414    12.255     0.200
     4.559    12.855     0.200
     4.691    14.116     0.200
     4.731    13.147     0.200
     4.796    13.289     0.200
     4.902    13.555     0.200
     4.949    13.533     0.200
     5.018    14.308     0.200
     5.088    13.452     0.200
     5.128    14.524     0.200
     5.164    12.692     0.200
     5.338    14.870     0.200
     5.382    14.751     0.200
     5.418    14.937     0.200
     5.598    14.735     0.200
     5.560    15.081     0.200
     5.594    14.679     0.200
     5.622    14.847     0.200
     5.667    16.027     0.200
     5.637    16.881     0.200
     5.715    14.769     0.200
     5.830    15.924     0.200
     5.877    15.876     0.200
     5.838    15.632     0.200
     5.990    15.663     0.200
     6.011    15.908     0.200
     6.041    15.662     0.200
     6.097    16.610     0.200
     6.123    16.302     0.200
     6.178    15.659     0.200
     6.331    17.079     0.200
     6.474    17.207     0.200
     6.529    17.872     0.200
     6.618    15.937     0.200
     6.665    16.684     0.200
     6.761    17.566     0.200
     6.817    16.605     0.200
     6.892    17.731     0.200
     7.045    17.244     0.200
     7.130    17.759     0.200
     7.099    17.222     0.200
     7.154    16.379     0.200
     7.154    16.879     0.200
     7.259    17.646     0.200
     7.291    18.574     0.200
     7.783    19.238     0.200
     7.866    19.762     0.200
     8.085    19.705     0.200
     9.950    21.346     0.200
    12.008    26.934     0.200
     0.553    13.826     0.200
     0.613    13.625     0.200
     0.617    13.481     0.200
     0.637    13.647     0.200
     0.734    13.119     0.200
     0.824    12.560     0.200
     1.081    12.163     0.200
     1.081    12.363     0.200
     1.090    12.463     0.200
     1.093    12.328     0.200
     1.098    11.683     0.200
     1.103    12.305     0.200
     1.118    12.336     0.200
     1.154    11.713     0.200
     1.352    12.009     0.200
     1.471    11.112     0.200
     1.657    11.067     0.200
     1.677    11.607     0.200
     1.684    11.627     0.200
     1.702    11.619     0.200
     1.751     9.336     0.200
     1.751    11.751     0.200
     1.923    11.044     0.200
     2.038    11.703     0.200
     2.072    11.799     0.200
     2.144    11.866     0.200
     2.149    11.899     0.200
     2.180    10.938     0.200
     2.237    11.876     0.200
     2.306    11.965     0.200
     2.374    11.983     0.200
     2.368    11.717     0.200
     2.432    11.205     0.200
     2.449    11.903     0.200
     2.749    12.495     0.200
     2.824    13.929     0.200
     2.837    12.580     0.200
     2.874    12.639     0.200
     2.881    12.962     0.200
     2.900    12.834     0.200
     2.919    12.770     0.200
     2.943    13.031     0.200
     3.017    12.777     0.200
     3.060    13.277     0.200
     3.075    11.362     0.200
     3.230    11.783     0.200
     3.434    12.407     0.200
     3.493    13.918     0.200
     3.511    12.904     0.200
     3.646    12.731     0.200
     3.685    11.276     0.200
     3.765    12.549     0.200
     3.771    12.774     0.200
     3.931    13.307     0.200
     3.967    11.888     0.200
     4.054    12.566     0.200
     4.153    11.736     0.200
     4.206    14.228     0.200
     4.298    12.628     0.200
     4.346    12.865     0.200
     4.391    13.640     0.200
     4.454    13.003     0.200
     4.485    12.416     0.200
     4.584    12.515     0.200
     4.609    12.896     0.200
     4.616    13.708     0.200
     4.659    12.206     0.200
     4.839    13.015     0.200
     4.923    13.833     0.200
     4.981    13.748     0.200
     5.029    14.694     0.200
     5.051    14.237     0.200
     5.115    14.588     0.200
     5.139    15.511     0.200
     5.237    15.072     0.200
     5.275    15.222     0.200
     5.291    15.735     0.200
     5.386    14.627     0.200
     5.429    15.026     0.200
     5.477    17.971     0.200
     5.591    15.836     0.200
     5.587    15.584     0.200
     5.639    16.269     0.200
     5.782    16.206     0.200
     5.770    14.948     0.200
     5.832    15.620     0.200
     5.856    15.944     0.200
     6.066    16.692     0.200
     6.085    16.173     0.200
     6.296    16.505     0.200
     6.354    16.330     0.200
     6.457    18.026     0.200
     6.491    17.435     0.200
     6.522    15.566     0.200
     6.636    16.735     0.200
     6.655    16.118     0.200
     6.754    18.258     0.200
     6.855    17.785     0.200
     6.897    16.495     0.200
     7.036    16.470     0.200
     7.201    16.146     0.200
     7.201    16.946     0.200
     7.253    17.140     0.200
     7.303    19.859     0.200
     7.284    19.377     0.200
     7.320    19.151     0.200
     7.372    19.141     0.200
     7.735    20.112     0.200
     7.827    19.645     0.200
     8.041    20.249     0.200
     8.157    20.386     0.200
     8.147    17.908     0.200
     9.910    19.431     0.200
    10.702    21.310     0.200
    13.509    26.127     0.200
    13.995    27.933     0.200
     1.534     9.733     0.200
     1.555     9.831     0.200
     1.562    10.001     0.200
     1.576     9.848     0.200
     1.787     9.885     0.200
     1.736    10.377     0.200
     1.763    10.556     0.200
     2.016    10.911     0.200
     2.065    10.937     0.200
     2.068     9.989     0.200
     2.114    11.068     0.200
     2.117    11.030     0.200
     2.125    11.041     0.200
     2.129    11.090     0.200
     2.225    11.265     0.200
     2.398    10.151     0.200
     2.516    11.872     0.200
     2.548    11.403     0.200
     2.599    11.109     0.200
     2.581    12.119     0.200
     2.586    11.758     0.200
     2.717    13.126     0.200
     2.754    11.091     0.200
     2.731    11.657     0.200
     2.864    10.713     0.200
     3.037    12.399     0.200
     3.165    12.202     0.200
     3.165    12.497     0.200
     3.166    12.789     0.200
     3.188    12.829     0.200
     3.236    13.267     0.200
     3.230    13.037     0.200
     3.235    13.083     0.200
     3.334    12.529     0.200
     3.367    13.336     0.200
     3.404    12.906     0.200
     3.467    13.269     0.200
     3.622    13.327     0.200
     3.726    12.450     0.200
     3.758    12.978     0.200
     3.743    14.556     0.200
     3.780    13.127     0.200
     3.804    13.336     0.200
     3.804    12.898     0.200
     3.848    12.531     0.200
     3.945    14.299     0.200
     3.998    13.683     0.200
     4.165    14.125     0.200
     4.159    13.690     0.200
     4.272    14.678     0.200
     4.359    14.566     0.200
     4.418    15.283     0.200
     4.437    15.662     0.200
     4.516    15.325     0.200
     4.564    14.969     0.200
     4.955    17.014     0.200
     5.132    17.243     0.200
     5.197    16.480     0.200
     5.291    16.189     0.200
     5.313    15.909     0.200
     5.470    18.300     0.200
     5.471    17.991     0.200
     5.499    17.460     0.200
     5.539    17.801     0.200
     5.493    17.439     0.200
     5.535    16.439     0.200
     5.676    17.894     0.200
     5.677    16.986     0.200
     5.848    18.484     0.200
     5.884    18.463     0.200
     5.873    17.701     0.200
     6.090    18.567     0.200
     6.310    19.097     0.200
     6.583    19.309     0.200
     6.651    19.318     0.200
     7.052    20.832     0.200
     7.146    19.542     0.200
     7.146    20.042     0.200
     8.012    21.632     0.200
     8.093    23.044     0.200
     9.959    25.711     0.200
    13.122    32.494     0.200
     0.243     8.503     0.200
     0.602     7.515     0.200
     0.646     7.101     0.200
     0.670     7.624     0.200
     0.672     7.701     0.200
     0.672     7.404     0.200
     0.673     7.583     0.200
     0.678     7.622     0.200
     0.692     7.468     0.200
     0.974     7.676     0.200
     1.061     7.154     0.200
     1.097     6.832     0.200
     1.148     7.140     0.200
     1.206     7.666     0.200
     1.309     7.461     0.200
     1.339     7.223     0.200
     1.353     7.556     0.200
     1.371     8.239     0.200
     1.392     7.800     0.200
     1.421     7.558     0.200
     1.448     7.839     0.200
     1.732     7.924     0.200
     1.771     9.171     0.200
     1.849     8.556     0.200
     1.898     8.788     0.200
     1.951     8.766     0.200
     1.970     8.447     0.200
     2.145     8.904     0.200
     2.361    10.989     0.200
     2.468    10.041     0.200
     2.521     8.418     0.200
     2.581     9.918     0.200
     2.601     9.981     0.200
     2.604     9.853     0.200
     2.627    10.279     0.200
     2.640    10.323     0.200
     2.641     9.619     0.200
     2.731    10.262     0.200
     2.781     9.478     0.200
     2.804    10.615     0.200
     3.110    11.050     0.200
     3.128     9.731     0.200
     3.151    10.066     0.200
     3.204     9.747     0.200
     3.244    10.977     0.200
     3.408    10.364     0.200
     3.444    11.950     0.200
     3.482    11.503     0.200
     3.645    10.698     0.200
     3.645    10.577     0.200
     3.729    11.023     0.200
     3.786    10.954     0.200
     3.922    10.365     0.200
     4.057    11.801     0.200
     4.056    12.106     0.200
     4.123    10.626     0.200
     4.241    11.648     0.200
     4.366    11.982     0.200
     4.371    12.034     0.200
     4.410    12.669     0.200
     4.701    14.182     0.200
     4.731    13.127     0.200
     4.816    13.233     0.200
     5.000    14.185     0.200
     5.026    14.389     0.200
     5.037    14.563     0.200
     5.199    14.770     0.200
     5.240    14.885     0.200
     5.325    14.701     0.200
     5.499    15.269     0.200
     5.520    15.214     0.200
     5.592    14.474     0.200
     5.824    15.377     0.200
     5.831    15.788     0.200
     6.056    16.367     0.200
     6.104    15.406     0.200
     6.272    15.844     0.200
     6.306    17.551     0.200
     6.350    15.634     0.200
     6.491    16.387     0.200
     6.495    16.748     0.200
     6.557    17.019     0.200
     6.537    16.351     0.200
     6.753    17.829     0.200
     6.758    16.975     0.200
     6.767    16.771     0.200
     6.862    16.854     0.200
     6.923    17.644     0.200
     6.908    18.428     0.200
     6.948    16.753     0.200
     7.211    17.989     0.200
     7.328    18.019     0.200
     7.318    19.445     0.200
     7.402    19.550     0.200
     7.803    18.681     0.200
     1.521     8.084     0.200
     2.066     9.876     0.200
     2.312    11.457     0.200
     2.413    11.876     0.200
     2.576    11.881     0.200
     2.584    11.877     0.200
     2.582    12.008     0.200
     2.669    12.094     0.200
     2.688    12.875     0.200
     2.689    12.554     0.200
     2.725    12.241     0.200
     2.870    11.341     0.200
     2.879    12.544     0.200
     3.189    13.326     0.200
     3.283    13.821     0.200
     3.332    14.056     0.200
     3.336    13.808     0.200
     3.343    14.323     0.200
     3.398    13.300     0.200
     3.508    14.697     0.200
     3.727    14.339     0.200
     3.867    16.405     0.200
     4.082    15.297     0.200
     4.131    15.730     0.200
     4.178    15.485     0.200
     4.275    16.642     0.200
     4.354    15.128     0.200
     4.524    15.939     0.200
     4.524    15.469     0.200
     4.641    16.677     0.200
     4.685    17.162     0.200
     4.690    17.203     0.200
     4.722    16.730     0.200
     4.821    17.175     0.200
     4.883    14.855     0.200
     4.948    16.490     0.200
     4.937    17.317     0.200
     5.091    16.626     0.200
     5.114    17.760     0.200
     5.326    17.888     0.200
     5.330    18.037     0.200
     5.340    17.425     0.200
     5.707    19.643     0.200
     5.683    17.818     0.200
     5.734    19.716     0.200
     5.790    18.973     0.200
     5.924    19.402     0.200
     6.171    19.918     0.200
     6.177    20.647     0.200
     6.277    21.284     0.200
     6.559    19.990     0.200
     6.721    20.605     0.200
     7.103    21.444     0.200
     7.119    21.457     0.200
     7.077    21.443     0.200
     7.156    23.324     0.200
     7.330    22.100     0.200
     7.494    22.584     0.200
     7.502    23.234     0.200
     7.455    22.536     0.200
     7.531    22.252     0.200
     7.641    19.772     0.200
     7.641    22.173     0.200
     7.786    21.880     0.200
     7.873    21.725     0.200
     7.987    22.895     0.200
     7.887    22.297     0.200
     8.150    22.925     0.200
     8.182    23.451     0.200
     8.282    23.691     0.200
     8.586    24.541     0.200
     9.517    25.779     0.200
    10.369    27.332     0.200
    13.119    35.079     0.200
    13.917    32.827     0.200
     0.434     6.418     0.200
     0.743     6.717     0.200
     0.752     6.712     0.200
     0.753     6.183     0.200
     0.757     6.547     0.200
     0.768     6.528     0.200
     0.774     6.556     0.200
     0.939     6.001     0.200
     1.021     6.873     0.200
     1.057     7.046     0.200
     1.244     7.672     0.200
     1.280     7.248     0.200
     1.298     6.633     0.200
     1.373     6.561     0.200
     1.380     6.975     0.200
     1.368     6.518     0.200
     1.425     7.059     0.200
     1.444     7.030     0.200
     1.574     7.516     0.200
     1.551     7.685     0.200
     1.661     8.703     0.200
     1.832     8.301     0.200
     1.862     8.261     0.200
     1.884     8.303     0.200
     1.928     8.389     0.200
     1.964     8.361     0.200
     1.965     8.454     0.200
     2.146     8.846     0.200
     2.295    10.704     0.200
     2.345     8.022     0.200
     2.353     8.521     0.200
     2.467     9.792     0.200
     2.587     9.993     0.200
     2.596     9.896     0.200
     2.601    10.030     0.200
     2.626    10.339     0.200
     2.628     8.811     0.200
     2.650    10.254     0.200
     2.661     8.749     0.200
     2.671    10.618     0.200
     2.806    10.440     0.200
     2.801     9.038     0.200
     2.911    11.012     0.200
     2.997     8.715     0.200
     3.011     9.543     0.200
     3.028    10.250     0.200
     3.054    10.744     0.200
     3.139    10.350     0.200
     3.252    10.033     0.200
     3.404    11.159     0.200
     3.432    11.234     0.200
     3.544    10.632     0.200
     3.544    10.062     0.200
     3.543    11.138     0.200
     3.603    10.744     0.200
     3.748    11.144     0.200
     3.746    10.171     0.200
     3.760    11.010     0.200
     3.933    10.289     0.200
     3.945    11.079     0.200
     4.065    11.148     0.200
     4.161    11.523     0.200
     4.195    11.630     0.200
     4.279    12.454     0.200
     4.546    12.601     0.200
     4.565    12.715     0.200
     4.598    12.823     0.200
     4.599    13.721     0.200
     4.656    13.644     0.200
     4.779    13.119     0.200
     4.860    13.769     0.200
     5.006    13.862     0.200
     5.034    14.544     0.200
     5.088    14.712     0.200
     5.236    14.285     0.200
     5.257    14.441     0.200
     5.404    14.125     0.200
     5.362    13.812     0.200
     5.477    14.965     0.200
     5.483    14.503     0.200
     5.702    14.946     0.200
     5.734    16.674     0.200
     5.807    15.423     0.200
     5.751    17.669     0.200
     5.894    15.200     0.200
     5.849    18.130     0.200
     5.860    17.396     0.200
     5.951    16.142     0.200
     6.149    18.728     0.200
     6.212    17.496     0.200
     6.246    15.689     0.200
     6.254    16.796     0.200
     6.306    15.396     0.200
     6.342    16.478     0.200
     6.473    15.941     0.200
     6.503    16.790     0.200
     6.686    17.257     0.200
     6.717    16.618     0.200
     6.733    16.711     0.200
     6.805    16.170     0.200
     6.805    16.470     0.200
     6.982    17.509     0.200
     7.053    17.876     0.200
     7.083    17.626     0.200
     7.378    18.980     0.200
     7.462    19.141     0.200
     7.741    18.947     0.200
     8.352    21.622     0.200
     8.384    22.647     0.200
     9.110    22.270     0.200
     9.133    23.206     0.200
     9.566    20.742     0.200
     9.592    21.147     0.200
    12.003    28.607     0.200
    12.958    29.063     0.200
    15.035    33.733     0.200
     0.587     5.422     0.200
     0.644     5.293     0.200
     0.892     6.067     0.200
     0.935     6.258     0.200
     0.939     6.311     0.200
     0.989     6.426     0.200
     1.018     6.591     0.200
     1.035     6.486     0.200
     1.234     6.969     0.200
     1.298     7.125     0.200
     1.401     7.629     0.200
     1.425     7.939     0.200
     1.427     8.021     0.200
     1.428     7.598     0.200
     1.429     7.899     0.200
     1.434     7.838     0.200
     1.447     7.783     0.200
     1.674     7.533     0.200
     1.728     8.308     0.200
     1.817     8.074     0.200
     1.872     8.322     0.200
     2.010     8.719     0.200
     2.022     8.468     0.200
     2.092     8.105     0.200
     2.105     9.107     0.200
     2.139     8.809     0.200
     2.145     8.839     0.200
     2.172     8.720     0.200
     2.320     8.698     0.200
     2.430     9.919     0.200
     2.523     9.925     0.200
     2.568    10.009     0.200
     2.599     9.943     0.200
     2.618    10.323     0.200
     2.652    10.025     0.200
     2.702    10.142     0.200
     2.714    10.002     0.200
     2.892    10.325     0.200
     3.064     9.114     0.200
     3.115     9.718     0.200
     3.330    11.207     0.200
     3.332    10.690     0.200
     3.347    11.107     0.200
     3.348    11.198     0.200
     3.370    10.344     0.200
     3.374    11.800     0.200
     3.391    11.499     0.200
     3.406    11.239     0.200
     3.419    11.674     0.200
     3.476    11.714     0.200
     3.552    11.719     0.200
     3.658    10.378     0.200
     3.682    11.900     0.200
     3.824    11.843     0.200
     3.907    11.683     0.200
     3.988    11.333     0.200
     4.176    12.439     0.200
     4.187    12.915     0.200
     4.311    11.119     0.200
     4.360    11.894     0.200
     4.420    13.187     0.200
     4.413    11.776     0.200
     4.456    11.676     0.200
     4.516    12.566     0.200
     4.596    12.384     0.200
     4.621    11.849     0.200
     4.671    12.060     0.200
     4.709    12.472     0.200
     4.755    12.287     0.200
     4.774    12.360     0.200
     4.819    13.041     0.200
     4.904    13.446     0.200
     5.033    14.329     0.200
     5.031    13.557     0.200
     5.132    15.078     0.200
     5.181    14.911     0.200
     5.175    14.382     0.200
     5.201    16.276     0.200
     5.139    14.835     0.200
     5.228    15.060     0.200
     5.249    15.612     0.200
     5.267    14.107     0.200
     5.284    14.107     0.200
     5.343    15.926     0.200
     5.391    14.555     0.200
     5.425    15.063     0.200
     5.526    16.885     0.200
     5.563    14.950     0.200
     5.636    14.904     0.200
     5.605    15.359     0.200
     5.766    15.885     0.200
     5.784    15.973     0.200
     5.822    16.036     0.200
     6.006    16.379     0.200
     6.006    15.482     0.200
     6.066    15.282     0.200
     6.085    16.053     0.200
     6.087    15.635     0.200
     6.113    17.938     0.200
     6.148    16.818     0.200
     6.205    16.555     0.200
     6.246    16.785     0.200
     6.356    17.294     0.200
     6.459    16.797     0.200
     6.533    16.828     0.200
     6.581    17.473     0.200
     6.809    18.214     0.200
     6.964    17.999     0.200
     7.009    17.774     0.200
     7.075    17.111     0.200
     7.237    18.314     0.200
     7.286    17.141     0.200
     7.390    19.130     0.200
     7.518    18.632     0.200
     7.485    17.744     0.200
     7.499    18.360     0.200
     7.597    18.520     0.200
     7.576    17.557     0.200
     8.156    21.996     0.200
     8.513    19.226     0.200
     8.710    21.250     0.200
     0.168     4.809     0.200
     0.219     4.190     0.200
     0.875     5.755     0.200
     1.219     6.739     0.200
     1.312     6.250     0.200
     1.364     6.946     0.200
     1.455     6.690     0.200
     1.446     6.992     0.200
     1.585     7.968     0.200
     1.600     7.692     0.200
     1.604     8.449     0.200
     1.662     7.268     0.200
     1.610     8.278     0.200
     1.611     7.612     0.200
     1.615     7.520     0.200
     1.632     8.518     0.200
     1.789     8.386     0.200
     1.887     8.443     0.200
     1.955     8.353     0.200
     1.995     8.786     0.200
     2.027     7.807     0.200
     2.125     8.374     0.200
     2.249     8.515     0.200
     2.239     8.090     0.200
     2.245     9.063     0.200
     2.290     9.240     0.200
     2.291     8.629     0.200
     2.308     8.929     0.200
     2.417     9.561     0.200
     2.649     9.156     0.200
     2.692     9.947     0.200
     2.744     9.744     0.200
     2.791     9.893     0.200
     2.815     9.719     0.200
     2.824    10.215     0.200
     2.937     8.991     0.200
     2.998    10.183     0.200
     3.093    11.576     0.200
     3.272    10.182     0.200
     3.461     9.873     0.200
     3.440    11.221     0.200
     3.440    11.218     0.200
     3.451    11.499     0.200
     3.505    11.764     0.200
     3.512    11.081     0.200
     3.519    11.997     0.200
     3.569    11.720     0.200
     3.618     9.760     0.200
     3.656    11.406     0.200
     3.855    11.684     0.200
     3.873    11.163     0.200
     3.869    11.413     0.200
     4.173    12.564     0.200
     4.215    11.676     0.200
     4.274    11.588     0.200
     4.274    11.258     0.200
     4.301    11.277     0.200
     4.286    11.750     0.200
     4.300    11.687     0.200
     4.440    11.451     0.200
     4.480    12.385     0.200
     4.607    12.601     0.200
     4.598    12.312     0.200
     4.616    12.399     0.200
     4.652    12.619     0.200
     4.745    13.297     0.200
     4.862    13.052     0.200
     4.907    13.206     0.200
     4.809    13.350     0.200
     4.823    15.081     0.200
     4.901    13.566     0.200
     4.943    13.788     0.200
     4.981    13.436     0.200
     5.141    14.268     0.200
     5.137    13.919     0.200
     5.394    13.670     0.200
     5.550    15.597     0.200
     5.560    14.779     0.200
     5.498    15.702     0.200
     5.627    14.502     0.200
     5.731    16.182     0.200
     5.825    15.688     0.200
     5.834    15.486     0.200
     5.894    15.583     0.200
     5.874    16.216     0.200
     5.961    15.599     0.200
     5.975    16.640     0.200
     6.068    16.258     0.200
     6.306    16.674     0.200
     6.298    16.068     0.200
     6.280    15.983     0.200
     6.375    16.667     0.200
     6.515    17.333     0.200
     6.715    17.901     0.200
     6.941    17.867     0.200
     6.938    18.706     0.200
     7.213    18.090     0.200
     7.519    16.903     0.200
     7.543    18.041     0.200
     7.586    17.436     0.200
     0.365     4.698     0.200
     0.425     4.724     0.200
     1.082     6.455     0.200
     1.901     8.498     0.200
     1.881     7.622     0.200
     1.949     8.636     0.200
     1.938     8.366     0.200
     2.001     8.228     0.200
     1.973     8.956     0.200
     1.973     8.597     0.200
     1.979     9.189     0.200
     1.994     9.014     0.200
     2.019     8.418     0.200
     2.022     7.977     0.200
     2.070     8.520     0.200
     2.272     8.457     0.200
     2.235     8.799     0.200
     2.508     9.411     0.200
     2.529     9.465     0.200
     2.529     8.820     0.200
     2.531     9.349     0.200
     2.532     9.131     0.200
     2.577     9.402     0.200
     2.584     9.421     0.200
     2.586     9.506     0.200
     2.852     8.695     0.200
     2.965    10.184     0.200
     2.994    10.244     0.200
     3.032     9.796     0.200
     3.055    10.327     0.200
     3.066    10.106     0.200
     3.218     9.425     0.200
     3.210    11.427     0.200
     3.260     9.534     0.200
     3.216     9.944     0.200
     3.471     9.678     0.200
     3.629    10.624     0.200
     3.653    11.054     0.200
     3.723    11.736     0.200
     3.718    11.714     0.200
     3.719    11.483     0.200
     3.721    11.548     0.200
     3.783    11.033     0.200
     3.758    11.324     0.200
     3.884    11.353     0.200
     3.988    11.635     0.200
     4.033    11.622     0.200
     4.146    11.195     0.200
     4.204    11.517     0.200
     4.246    11.228     0.200
     4.229    11.621     0.200
     4.244    11.751     0.200
     4.282    11.706     0.200
     4.282    11.019     0.200
     4.367    12.222     0.200
     4.436    12.313     0.200
     4.452    12.423     0.200
     4.486    12.428     0.200
     4.546    13.024     0.200
     4.567    13.184     0.200
     4.578    12.959     0.200
     4.628    12.533     0.200
     4.694    13.305     0.200
     4.839    13.608     0.200
     4.872    13.727     0.200
     4.928    13.774     0.200
     4.983    13.635     0.200
     5.258    11.611     0.200
     5.266    11.423     0.200
     5.396    15.207     0.200
     5.503    14.859     0.200
     5.662    15.005     0.200
     5.668    14.930     0.200
     5.759    14.440     0.200
     5.855    14.059     0.200
     5.912    16.587     0.200
     5.960    16.122     0.200
     6.010    15.750     0.200
     5.972    15.883     0.200
     5.946    13.892     0.200
     5.982    14.576     0.200
     5.983    14.057     0.200
     6.055    15.922     0.200
     6.142    16.406     0.200
     6.237    14.099     0.200
     6.299    16.277     0.200
     6.405    16.838     0.200
     6.561    17.315     0.200
     6.679    18.639     0.200
     7.176    18.238     0.200
     7.172    17.386     0.200
     7.516    18.259     0.200
     7.628    19.459     0.200
     8.540    21.216     0.200
     8.578    21.275     0.200
     8.991    18.708     0.200
    11.633    27.716     0.200
    13.567    30.960     0.200
     0.403     5.439     0.200
     0.875     6.264     0.200
     1.101     6.721     0.200
     1.128     6.206     0.200
     1.271     6.637     0.200
     1.458     7.159     0.200
     1.489     7.796     0.200
     1.511     8.239     0.200
     1.475     7.057     0.200
     1.514     8.004     0.200
     1.516     7.562     0.200
     1.519     7.853     0.200
     1.526     7.867     0.200
     1.537     7.643     0.200
     1.785     8.239     0.200
     1.804     8.324     0.200
     1.970     8.585     0.200
     1.987     8.889     0.200
     2.004     7.984     0.200
     2.163     8.067     0.200
     2.172     8.632     0.200
     2.213     8.751     0.200
     2.215     8.929     0.200
     2.267     8.814     0.200
     2.237     8.273     0.200
     2.410     9.851     0.200
     2.583     9.634     0.200
     2.656     9.875     0.200
     2.678     9.923     0.200
     2.720     9.834     0.200
     2.760     9.869     0.200
     2.760    10.068     0.200
     2.941    10.053     0.200
     2.983     9.169     0.200
     3.070    11.743     0.200
     3.305    10.003     0.200
     3.383    10.999     0.200
     3.446    11.262     0.200
     3.457    11.096     0.200
     3.539    10.070     0.200
     3.487    10.546     0.200
     3.519    11.211     0.200
     3.704    10.846     0.200
     3.876    11.636     0.200
     3.915    11.387     0.200
     4.166    12.060     0.200
     4.298    12.518     0.200
     4.282    11.704     0.200
     4.282    11.504     0.200
     4.310    11.978     0.200
     4.341    11.812     0.200
     4.361    11.584     0.200
     4.488    12.403     0.200
     4.512    11.620     0.200
     4.659    12.604     0.200
     4.678    12.586     0.200
     4.693    12.707     0.200
     4.669    12.461     0.200
     4.807    13.077     0.200
     4.746    12.051     0.200
     4.797    13.393     0.200
     4.901    13.683     0.200
     4.974    13.630     0.200
     5.081    13.982     0.200
     5.194    14.256     0.200
     5.277    13.988     0.200
     5.437    14.920     0.200
     5.432    14.682     0.200
     5.538    15.346     0.200
     5.742    15.961     0.200
     5.690    15.172     0.200
     5.795    14.546     0.200
     5.925    15.828     0.200
     5.972    15.276     0.200
     5.969    15.219     0.200
     5.981    15.572     0.200
     6.063    15.622     0.200
     6.049    16.386     0.200
     6.258    16.244     0.200
     6.396    16.238     0.200
     6.422    16.934     0.200
     6.405    16.325     0.200
     6.639    17.394     0.200
     6.676    17.966     0.200
     6.819    17.795     0.200
     6.950    19.071     0.200
     7.066    18.110     0.200
     7.035    16.581     0.200
     7.240    17.888     0.200
     7.343    18.286     0.200
     7.299    17.498     0.200
     7.336    19.367     0.200
     7.414    18.150     0.200
     7.438    19.171     0.200
     7.498    17.746     0.200
     7.517    17.946     0.200
     7.576    17.167     0.200
     8.248    22.026     0.200
     8.508    20.090     0.200
     9.494    22.878     0.200
     9.676    20.858     0.200
    12.252    29.995     0.200
     0.430     8.453     0.200
     0.438     8.755     0.200
     0.572     8.300     0.200
     0.738     7.956     0.200
     0.912     7.922     0.200
     1.051     8.102     0.200
     1.088     7.478     0.200
     1.146     6.379     0.200
     1.324     8.617     0.200
     1.346     8.865     0.200
     1.347     8.854     0.200
     1.346     8.658     0.200
     1.350     8.254     0.200
     1.358     8.921     0.200
     1.365     8.739     0.200
     1.656     9.150     0.200
     1.660     8.497     0.200
     1.960     9.098     0.200
     2.014     8.836     0.200
     2.034     9.438     0.200
     2.051     9.531     0.200
     2.066     9.664     0.200
     2.103     9.425     0.200
     2.128     9.735     0.200
     2.197     9.234     0.200
     2.453    10.245     0.200
     2.485     9.371     0.200
     2.527    10.678     0.200
     2.531    10.430     0.200
     2.543    10.592     0.200
     2.560    10.600     0.200
     3.030    10.209     0.200
     3.099    12.405     0.200
     3.235    10.720     0.200
     3.268     9.934     0.200
     3.284    11.641     0.200
     3.337    11.365     0.200
     3.537    10.697     0.200
     3.838    12.482     0.200
     3.908    11.560     0.200
     3.926    10.851     0.200
     3.997    12.423     0.200
     4.163    11.788     0.200
     4.223    12.792     0.200
     4.329    11.419     0.200
     4.396    12.464     0.200
     4.396    11.294     0.200
     4.443    12.516     0.200
     4.486    12.723     0.200
     4.582    12.503     0.200
     4.689    13.044     0.200
     4.769    13.712     0.200
     4.808    14.163     0.200
     4.811    12.894     0.200
     4.862    12.136     0.200
     4.862    15.325     0.200
     4.931    14.621     0.200
     4.969    13.287     0.200
     4.989    13.154     0.200
     5.119    13.836     0.200
     5.167    14.069     0.200
     5.219    15.263     0.200
     5.258    14.708     0.200
     5.319    14.298     0.200
     5.340    14.857     0.200
     5.483    14.479     0.200
     5.524    14.804     0.200
     5.702    15.226     0.200
     5.758    15.379     0.200
     5.963    14.978     0.200
     5.996    16.593     0.200
     6.069    15.750     0.200
     6.231    16.253     0.200
     6.256    18.065     0.200
     6.332    16.072     0.200
     6.404    16.233     0.200
     6.506    16.743     0.200
     6.523    16.345     0.200
     6.579    16.989     0.200
     6.807    18.938     0.200
     6.823    17.048     0.200
     6.964    16.304     0.200
     7.060    16.277     0.200
     7.143    17.208     0.200
     7.268    18.753     0.200
     7.263    18.007     0.200
     7.464    16.890     0.200
     7.466    17.244     0.200
     7.592    19.170     0.200
     7.583    17.473     0.200
     7.882    19.587     0.200
     7.973    19.220     0.200
     7.967    21.197     0.200
     7.989    20.244     0.200
     8.042    19.719     0.200
     8.185    18.447     0.200
     8.208    20.377     0.200
    12.864    30.451     0.200
    13.810    29.203     0.200
     0.521     8.679     0.200
     0.732     8.223     0.200
     0.906     7.796     0.200
     0.884     7.946     0.200
     0.938     8.219     0.200
     0.960     8.458     0.200
     0.962     8.242     0.200
     0.962     8.432     0.200
     0.964     8.411     0.200
     0.971     8.336     0.200
     0.980     8.322     0.200
     0.964     7.915     0.200
     1.116     6.555     0.200
     1.271     8.528     0.200
     1.326     8.085     0.200
     1.579     8.532     0.200
     1.633     8.486     0.200
     1.651     7.794     0.200
     1.673     8.741     0.200
     1.685     8.898     0.200
     1.721     8.681     0.200
     1.742     9.337     0.200
     1.822     8.602     0.200
     2.106     8.590     0.200
     2.116     9.569     0.200
     2.137     9.927     0.200
     2.150     9.873     0.200
     2.163     9.816     0.200
     2.184     9.674     0.200
     2.250     9.806     0.200
     2.706    11.881     0.200
     2.760     9.600     0.200
     2.895     9.182     0.200
     2.879    10.867     0.200
     2.904    10.670     0.200
     2.930    10.566     0.200
     2.935    11.114     0.200
     2.975    11.144     0.200
     3.154    10.354     0.200
     3.522    10.766     0.200
     3.605    11.494     0.200
     3.781    11.137     0.200
     3.830    13.066     0.200
     4.004    11.839     0.200
     4.096    11.765     0.200
     4.198    11.676     0.200
     4.205    12.588     0.200
     4.296    11.228     0.200
     4.334    12.586     0.200
     4.382    13.926     0.200
     4.496    11.400     0.200
     4.577    13.473     0.200
     4.744    13.495     0.200
     5.105    13.790     0.200
     5.181    14.401     0.200
     5.334    15.617     0.200
     5.332    15.039     0.200
     5.363    14.576     0.200
     5.676    15.128     0.200
     6.014    16.177     0.200
     6.068    15.848     0.200
     6.161    16.066     0.200
     6.188    16.547     0.200
     6.472    16.333     0.200
     6.583    16.040     0.200
     6.777    16.577     0.200
     6.923    18.269     0.200
     7.079    17.646     0.200
     7.195    17.301     0.200
     7.571    18.611     0.200
     7.672    18.634     0.200
     8.137    19.804     0.200
    13.417    29.383     0.200
     0.763     5.644     0.200
     0.782     4.937     0.200
     1.255     6.795     0.200
     1.312     6.837     0.200
     1.475     7.227     0.200
     1.623     8.010     0.200
     2.034     9.110     0.200
     2.061     8.861     0.200
     2.238     8.430     0.200
     2.497     9.209     0.200
     2.569     9.660     0.200
     2.724     9.535     0.200
     3.935    12.180     0.200
     3.972    12.121     0.200
     4.096    10.743     0.200
     4.271    11.416     0.200
     4.296    10.809     0.200
     4.372    12.021     0.200
     4.416    10.912     0.200
     4.478    12.591     0.200
     4.766    13.420     0.200
     4.848    13.166     0.200
     4.883    12.629     0.200
     4.989    13.629     0.200
     5.047    13.146     0.200
     5.269    13.682     0.200
     5.337    13.364     0.200
     5.381    14.052     0.200
     5.754    15.787     0.200
     6.129    16.720     0.200
     6.923    16.798     0.200
     7.534    18.329     0.200
     8.094    19.297     0.200
     8.175    19.238     0.200
     8.788    23.354     0.200
     9.216    23.134     0.200
     9.975    20.966     0.200
    12.631    29.640     0.200
    14.275    31.856     0.200
    14.354    33.933     0.200
     1.259     7.307     0.200
     1.542     7.808     0.200
     1.571     8.174     0.200
     1.653     8.612     0.200
     1.783     8.991     0.200
     1.694     8.329     0.200
     1.831     8.640     0.200
     1.898     9.353     0.200
     1.904     9.180     0.200
     1.946     8.996     0.200
     1.948     9.275     0.200
     1.974     9.063     0.200
     2.029     8.922     0.200
     2.064     9.218     0.200
     2.120     9.063     0.200
     2.328     9.636     0.200
     2.266     9.556     0.200
     2.394     9.566     0.200
     2.397     9.828     0.200
     2.501     9.013     0.200
     2.486    10.987     0.200
     2.619     8.935     0.200
     2.967    10.774     0.200
     2.992    11.087     0.200
     3.081    10.552     0.200
     3.155    10.879     0.200
     3.369    11.187     0.200
     3.476    10.834     0.200
     3.505    11.000     0.200
     3.527    11.347     0.200
     3.555    11.218     0.200
     3.555    10.667     0.200
     3.602    10.764     0.200
     3.502    11.733     0.200
     3.759    11.930     0.200
     3.771    11.896     0.200
     3.907    12.408     0.200
     3.959    12.505     0.200
     4.058    12.852     0.200
     4.131    12.393     0.200
     4.164    13.307     0.200
     4.199    13.497     0.200
     4.292    12.918     0.200
     4.314    13.256     0.200
     4.702    15.033     0.200
     4.888    14.856     0.200
     4.880    15.450     0.200
     5.050    14.773     0.200
     5.217    16.824     0.200
     5.155    14.440     0.200
     5.248    15.659     0.200
     5.237    15.889     0.200
     5.324    15.773     0.200
     5.448    15.328     0.200
     5.595    16.711     0.200
     5.681    16.501     0.200
     5.630    16.496     0.200
     5.704    16.679     0.200
     5.866    16.647     0.200
     5.755    17.939     0.200
     6.010    16.967     0.200
     6.109    16.114     0.200
     6.276    17.060     0.200
     6.442    17.920     0.200
     6.376    18.394     0.200
     6.551    17.657     0.200
     6.650    17.404     0.200
     6.648    19.617     0.200
     6.797    18.286     0.200
     6.862    18.147     0.200
     6.899    18.095     0.200
     6.900    18.584     0.200
     7.813    21.026     0.200
     7.886    21.469     0.200
    11.324    28.651     0.200
     1.484     8.517     0.200
     1.620     7.922     0.200
     1.915     9.084     0.200
     2.010     9.177     0.200
     2.267     9.576     0.200
     2.307     9.796     0.200
     2.359     9.805     0.200
     2.425    10.133     0.200
     2.427     9.702     0.200
     2.550    11.274     0.200
     2.595     9.046     0.200
     2.729     8.785     0.200
     2.978    11.007     0.200
     3.080    10.583     0.200
     3.147    11.597     0.200
     3.239    10.728     0.200
     3.480    11.122     0.200
     3.494    11.557     0.200
     3.576    12.298     0.200
     3.582    10.432     0.200
     3.619    11.194     0.200
     3.640    11.350     0.200
     3.640    11.250     0.200
     3.711    10.527     0.200
     3.845    12.159     0.200
     3.871    11.661     0.200
     3.997    12.383     0.200
     4.023    12.186     0.200
     4.071    12.123     0.200
     4.221    12.669     0.200
     4.261    13.109     0.200
     4.419    13.057     0.200
     4.802    14.694     0.200
     5.168    15.011     0.200
     5.160    14.214     0.200
     5.336    15.163     0.200
     5.692    15.902     0.200
     5.591    17.047     0.200
     6.392    19.637     0.200
     6.938    18.328     0.200
     6.980    17.769     0.200
     7.931    20.208     0.200
     8.904    20.515     0.200
    11.431    28.436     0.200
    12.967    30.876     0.200
    18.692    38.607     0.200
     0.098    13.929     0.200
     0.095    13.858     0.200
     0.344    11.359     0.200
     0.548    10.275     0.200
     0.567    10.356     0.200
     0.798     9.856     0.200
     1.157    10.365     0.200
     1.174    10.172     0.200
     1.175     9.961     0.200
     1.450     7.357     0.200
     1.470    10.023     0.200
     1.809    10.358     0.200
     1.833    10.283     0.200
     1.858    10.284     0.200
     1.902    10.276     0.200
     2.166     9.691     0.200
     2.439     9.812     0.200
     2.687    11.114     0.200
     3.082    11.806     0.200
     3.081    12.412     0.200
     3.473    11.442     0.200
     3.872    12.181     0.200
     3.938    11.810     0.200
     4.065    12.528     0.200
     4.099    11.937     0.200
     4.264    11.948     0.200
     4.389    12.067     0.200
     4.509    12.150     0.200
     4.527    12.944     0.200
     4.524    14.402     0.200
     4.535    11.444     0.200
     4.570    13.342     0.200
     4.632    12.416     0.200
     4.696    13.766     0.200
     4.688    12.858     0.200
     4.798    14.278     0.200
     4.844    12.544     0.200
     4.928    13.455     0.200
     4.890    14.909     0.200
     4.940    14.722     0.200
     4.976    14.797     0.200
     5.067    13.546     0.200
     5.079    13.806     0.200
     5.098    14.074     0.200
     5.074    14.354     0.200
     5.212    14.541     0.200
     5.237    15.856     0.200
     5.277    15.084     0.200
     5.336    14.798     0.200
     5.367    15.442     0.200
     5.429    14.318     0.200
     5.462    15.130     0.200
     5.485    14.955     0.200
     5.555    15.549     0.200
     5.574    16.025     0.200
     5.666    15.851     0.200
     5.740    15.987     0.200
     5.766    15.081     0.200
     5.912    15.181     0.200
     5.921    16.179     0.200
     6.024    15.676     0.200
     6.311    16.523     0.200
     6.296    16.399     0.200
     6.386    16.747     0.200
     6.399    17.398     0.200
     6.447    17.040     0.200
     6.461    16.473     0.200
     6.532    17.145     0.200
     6.557    17.955     0.200
     6.735    16.370     0.200
     6.837    17.677     0.200
     6.882    17.162     0.200
     7.065    16.424     0.200
     7.073    16.924     0.200
     7.233    19.360     0.200
     7.250    17.166     0.200
     7.294    19.053     0.200
     7.385    18.886     0.200
     7.386    16.831     0.200
     7.665    19.717     0.200
     7.661    20.242     0.200
     7.964    19.836     0.200
     8.331    19.151     0.200
     9.265    21.052     0.200
    12.991    30.519     0.200
     0.906     5.650     0.200
     0.927     5.710     0.200
     1.006     6.159     0.200
     1.039     6.088     0.200
     1.084     6.141     0.200
     0.982     6.313     0.200
     1.013     6.382     0.200
     1.271     6.801     0.200
     1.835     7.977     0.200
     2.028     9.006     0.200
     2.052     9.450     0.200
     2.058     9.180     0.200
     2.074     9.497     0.200
     2.361     9.761     0.200
     2.438     9.182     0.200
     2.678    10.017     0.200
     2.676    10.211     0.200
     2.683     9.781     0.200
     2.727    10.208     0.200
     2.770    10.250     0.200
     2.779    10.473     0.200
     2.810    10.091     0.200
     2.981    10.074     0.200
     3.097    11.158     0.200
     3.163    11.260     0.200
     3.207    11.134     0.200
     3.256    11.409     0.200
     3.284    11.403     0.200
     3.341    11.263     0.200
     3.361    11.010     0.200
     3.831    12.103     0.200
     3.780    11.012     0.200
     3.995    12.166     0.200
     4.018    12.712     0.200
     4.028    11.384     0.200
     4.123    12.736     0.200
     4.276    11.107     0.200
     4.396    12.300     0.200
     4.464    12.996     0.200
     4.573    12.938     0.200
     4.642    12.707     0.200
     4.640    13.200     0.200
     4.737    14.180     0.200
     4.842    13.160     0.200
     4.978    12.841     0.200
     5.183    13.987     0.200
     5.249    12.923     0.200
     5.240    15.721     0.200
     5.394    13.886     0.200
     5.441    15.141     0.200
     5.428    14.006     0.200
     5.640    15.519     0.200
     5.662    15.737     0.200
     5.634    14.868     0.200
     5.693    14.966     0.200
     5.754    14.998     0.200
     5.810    15.681     0.200
     5.928    15.512     0.200
     5.972    15.276     0.200
     6.263    16.383     0.200
     6.473    17.420     0.200
     6.563    17.423     0.200
     6.772    17.772     0.200
     6.906    17.158     0.200
     7.126    17.760     0.200
     7.546    18.915     0.200
     8.040    19.333     0.200
     8.144    18.452     0.200
     8.156    18.903     0.200
     8.240    19.694     0.200
     8.661    21.182     0.200
     8.747    21.554     0.200
     9.177    21.637     0.200
    10.150    22.839     0.200
    11.020    23.790     0.200
    12.897    30.972     0.200
    14.044    32.469     0.200
    14.388    31.263     0.200
    20.484    37.330     0.200
    20.867    37.526     0.200
     0.882     5.451     0.200
     1.011     6.028     0.200
     1.047     5.936     0.200
     1.090     6.052     0.200
     1.086     6.024     0.200
     0.995     6.402     0.200
     1.026     5.547     0.200
     1.166     6.800     0.200
     1.184     6.834     0.200
     1.276     6.658     0.200
     1.259     7.107     0.200
     1.372     7.035     0.200
     2.043     9.008     0.200
     2.067     9.339     0.200
     2.073     9.374     0.200
     2.180     9.231     0.200
     2.220     9.258     0.200
     2.273     8.922     0.200
     2.377     9.793     0.200
     2.452     9.225     0.200
     2.693    10.339     0.200
     2.692    10.609     0.200
     2.742    10.659     0.200
     2.699     9.868     0.200
     2.757    10.252     0.200
     2.785    10.350     0.200
     2.794    10.604     0.200
     2.826    10.291     0.200
     2.997    10.090     0.200
     3.112    11.212     0.200
     3.222    11.482     0.200
     3.271    11.910     0.200
     3.299    11.355     0.200
     3.357    11.463     0.200
     3.377    11.006     0.200
     3.746    13.299     0.200
     3.843    12.195     0.200
     3.796    11.086     0.200
     4.019    11.941     0.200
     3.987    12.662     0.200
     4.008    12.544     0.200
     4.011    12.200     0.200
     4.034    12.865     0.200
     4.061    10.978     0.200
     4.043    11.511     0.200
     4.155    14.028     0.200
     4.210    13.119     0.200
     4.291    11.872     0.200
     4.412    12.916     0.200
     4.479    13.140     0.200
     4.594    13.766     0.200
     4.636    13.280     0.200
     4.640    13.496     0.200
     4.589    12.992     0.200
     4.669    14.614     0.200
     4.687    13.744     0.200
     4.718    14.387     0.200
     4.725    13.801     0.200
     4.657    12.694     0.200
     4.653    12.451     0.200
     4.788    13.124     0.200
     4.858    13.952     0.200
     4.980    14.066     0.200
     5.016    13.875     0.200
     4.994    13.184     0.200
     5.079    13.888     0.200
     5.039    13.153     0.200
     5.049    13.201     0.200
     5.083    13.092     0.200
     5.228    15.186     0.200
     5.199    13.732     0.200
     5.264    12.897     0.200
     5.457    15.306     0.200
     5.409    14.208     0.200
     5.443    13.939     0.200
     5.558    14.397     0.200
     5.675    15.587     0.200
     5.708    15.022     0.200
     5.769    14.721     0.200
     5.824    15.217     0.200
     5.944    15.444     0.200
     5.986    15.392     0.200
     6.205    16.998     0.200
     6.278    17.100     0.200
     6.432    17.302     0.200
     6.508    18.691     0.200
     6.488    17.850     0.200
     6.641    17.695     0.200
     6.577    17.190     0.200
     6.787    17.949     0.200
     6.805    17.150     0.200
     6.921    18.284     0.200
     7.137    18.075     0.200
     7.259    20.098     0.200
     7.141    17.626     0.200
     7.560    18.804     0.200
     7.678    18.103     0.200
     7.663    20.850     0.200
     7.778    19.100     0.200
     7.851    19.219     0.200
     7.896    19.364     0.200
     7.926    19.350     0.200
     7.993    20.149     0.200
     7.927    19.835     0.200
     8.068    21.237     0.200
     8.052    19.188     0.200
     8.160    18.750     0.200
     8.171    19.268     0.200
     8.181    21.482     0.200
     8.256    18.921     0.200
     8.762    21.658     0.200
     9.193    22.001     0.200
    10.166    22.805     0.200
    10.265    21.486     0.200
    11.036    24.236     0.200
    12.908    29.954     0.200
    14.073    31.740     0.200
    14.073    35.279     0.200
    14.058    33.357     0.200
    14.403    31.779     0.200
    20.487    38.459     0.200
    20.504    37.555     0.200
    20.626    37.521     0.200
    20.871    37.297     0.200
     1.369     8.630     0.200
     1.396     8.820     0.200
     1.401     8.702     0.200
     1.425     8.818     0.200
     1.459     9.344     0.200
     1.574    10.051     0.200
     1.637    10.216     0.200
     1.650    10.296     0.200
     1.678    10.348     0.200
     1.888    10.767     0.200
     2.161    11.399     0.200
     2.223    11.890     0.200
     2.415    11.791     0.200
     2.450    11.356     0.200
     2.463    12.199     0.200
     2.515    12.387     0.200
     2.520    12.202     0.200
     2.566    12.505     0.200
     2.568    12.133     0.200
     2.582    12.225     0.200
     2.961    13.231     0.200
     3.063    13.320     0.200
     3.091    13.276     0.200
     3.073    13.490     0.200
     3.449    13.003     0.200
     3.575    12.476     0.200
     3.698    13.725     0.200
     3.702    14.434     0.200
     3.711    14.213     0.200
     3.735    14.166     0.200
     3.896    14.176     0.200
     3.909    14.688     0.200
     3.976    15.218     0.200
     4.038    14.093     0.200
     4.393    15.747     0.200
     4.438    13.926     0.200
     4.463    14.638     0.200
     4.470    14.846     0.200
     4.477    14.440     0.200
     4.560    14.203     0.200
     4.683    15.494     0.200
     4.704    15.300     0.200
     4.732    15.351     0.200
     4.877    15.815     0.200
     4.848    16.077     0.200
     4.867    15.132     0.200
     5.059    17.995     0.200
     5.054    16.101     0.200
     5.072    16.539     0.200
     5.487    17.509     0.200
     5.483    17.432     0.200
     5.567    17.888     0.200
     5.662    18.025     0.200
     5.660    18.379     0.200
     5.683    18.044     0.200
     5.625    17.683     0.200
     5.773    18.233     0.200
     6.000    18.120     0.200
     6.028    18.439     0.200
     6.078    19.127     0.200
     6.176    19.226     0.200
     6.175    19.601     0.200
     6.212    18.908     0.200
     6.372    19.089     0.200
     6.510    19.710     0.200
     6.776    20.317     0.200
     7.132    21.842     0.200
     7.304    20.084     0.200
     7.462    21.829     0.200
     7.605    20.746     0.200
     7.747    21.244     0.200
     7.776    21.241     0.200
     7.805    20.882     0.200
     8.519    23.411     0.200
     8.602    24.079     0.200
     9.359    26.823     0.200
    10.612    26.636     0.200
    12.056    32.467     0.200
    13.825    34.219     0.200
     0.852     5.723     0.200
     0.893     6.004     0.200
     0.910     5.924     0.200
     0.997     6.337     0.200
     1.023     6.260     0.200
     1.070     6.263     0.200
     1.048     6.209     0.200
     0.951     6.464     0.200
     1.123     6.842     0.200
     1.144     6.839     0.200
     0.983     5.969     0.200
     1.189     6.574     0.200
     1.261     6.697     0.200
     1.213     7.063     0.200
     1.335     7.050     0.200
     1.554     7.286     0.200
     1.802     8.010     0.200
     1.992     8.814     0.200
     2.082     7.877     0.200
     2.016     9.095     0.200
     2.018     8.925     0.200
     2.019     9.096     0.200
     2.325     9.430     0.200
     2.641     9.808     0.200
     2.638    10.172     0.200
     2.690    10.187     0.200
     2.645     9.559     0.200
     2.705     9.992     0.200
     2.734     9.965     0.200
     3.219    11.249     0.200
     3.305    11.443     0.200
     3.692    13.191     0.200
     3.802    12.066     0.200
     3.742    10.569     0.200
     4.064    12.652     0.200
     3.935    12.432     0.200
     3.958    12.049     0.200
     3.990    11.430     0.200
     4.101    13.502     0.200
     4.129    14.374     0.200
     4.425    12.586     0.200
     4.636    13.923     0.200
     4.676    13.226     0.200
     4.682    13.861     0.200
     4.535    12.636     0.200
     4.729    14.205     0.200
     4.767    14.001     0.200
     4.604    12.419     0.200
     4.831    13.882     0.200
     4.607    11.347     0.200
     4.804    13.687     0.200
     5.058    13.820     0.200
     5.122    13.844     0.200
     4.940    12.930     0.200
     4.985    13.025     0.200
     4.998    13.034     0.200
     5.269    15.169     0.200
     5.059    12.607     0.200
     5.145    13.587     0.200
     5.403    14.684     0.200
     5.632    15.611     0.200
     5.505    14.103     0.200
     5.599    14.553     0.200
     5.654    14.832     0.200
     5.717    15.459     0.200
     5.776    14.458     0.200
     5.891    15.063     0.200
     6.225    16.156     0.200
     6.380    17.099     0.200
     6.549    17.494     0.200
     6.587    16.915     0.200
     6.530    17.054     0.200
     6.635    16.784     0.200
     6.620    17.234     0.200
     6.734    17.708     0.200
     6.757    16.329     0.200
     6.868    17.642     0.200
     7.084    17.586     0.200
     7.092    17.531     0.200
     7.105    17.566     0.200
     7.512    18.699     0.200
     7.609    19.834     0.200
     7.820    19.458     0.200
     7.926    19.701     0.200
     7.845    19.338     0.200
     8.034    19.040     0.200
     7.872    18.924     0.200
     7.909    18.429     0.200
     7.885    19.343     0.200
     8.107    19.846     0.200
     8.118    19.632     0.200
     8.202    18.941     0.200
     8.714    21.411     0.200
     9.005    20.929     0.200
     9.139    22.063     0.200
    10.112    23.111     0.200
    10.234    21.332     0.200
    12.870    30.461     0.200
    12.985    30.833     0.200
    14.110    29.840     0.200
    14.012    29.876     0.200
    14.350    30.477     0.200
    15.863    35.238     0.200
    20.474    37.884     0.200
    20.490    38.557     0.200
    20.610    38.046     0.200
     0.820     5.276     0.200
     0.857     5.509     0.200
     0.876     5.528     0.200
     0.960     5.956     0.200
     0.989     6.069     0.200
     1.035     5.955     0.200
     1.021     5.759     0.200
     0.973     5.742     0.200
     1.007     5.499     0.200
     1.100     6.475     0.200
     1.119     6.606     0.200
     1.160     6.057     0.200
     1.224     6.581     0.200
     1.193     6.791     0.200
     1.307     6.765     0.200
     1.559     7.290     0.200
     1.782     7.809     0.200
     1.980     8.867     0.200
     2.004     9.220     0.200
     2.010     9.096     0.200
     2.025     9.091     0.200
     2.055     7.772     0.200
     2.314     9.248     0.200
     2.630    10.284     0.200
     2.638    10.409     0.200
     2.649     9.685     0.200
     2.679    10.536     0.200
     2.694     9.997     0.200
     2.722     9.991     0.200
     2.731    10.423     0.200
     2.947     9.838     0.200
     3.058    11.243     0.200
     3.160    11.575     0.200
     3.209    11.464     0.200
     3.294    11.736     0.200
     3.777    12.268     0.200
     3.744    11.170     0.200
     3.812    12.500     0.200
     3.949    12.546     0.200
     4.044    13.097     0.200
     4.092    11.421     0.200
     4.358    11.726     0.200
     4.425    12.730     0.200
     4.535    13.243     0.200
     4.659    13.850     0.200
     4.610    12.488     0.200
     4.706    14.045     0.200
     4.627    11.777     0.200
     4.735    14.448     0.200
     4.744    14.100     0.200
     4.809    13.889     0.200
     4.801    14.356     0.200
     4.940    14.079     0.200
     5.036    14.103     0.200
     4.988    13.231     0.200
     5.011    13.340     0.200
     5.100    13.597     0.200
     5.245    15.527     0.200
     5.406    14.048     0.200
     5.515    14.092     0.200
     5.609    16.862     0.200
     5.614    14.779     0.200
     5.658    14.937     0.200
     5.728    15.616     0.200
     5.899    15.253     0.200
     5.955    16.079     0.200
     6.041    16.287     0.200
     6.230    16.895     0.200
     6.371    17.650     0.200
     6.582    17.885     0.200
     6.549    17.659     0.200
     6.738    18.462     0.200
     6.862    18.353     0.200
     7.087    18.128     0.200
     7.107    17.986     0.200
     7.124    17.760     0.200
     7.529    18.989     0.200
     7.797    19.321     0.200
     7.902    19.461     0.200
     7.868    19.378     0.200
     8.010    20.536     0.200
     8.031    19.142     0.200
     8.100    21.240     0.200
     8.197    19.704     0.200
     8.972    23.367     0.200
    10.265    24.022     0.200
    12.898    30.379     0.200
    13.021    30.698     0.200
    14.082    30.711     0.200
    14.351    32.941     0.200
    15.898    32.486     0.200
     0.348     7.556     0.200
     0.407     7.201     0.200
     0.520     6.922     0.200
     0.618     6.747     0.200
     0.601     6.860     0.200
     0.676     6.508     0.200
     0.722     6.924     0.200
     0.756     7.073     0.200
     0.781     7.315     0.200
     0.784     7.322     0.200
     0.754     6.649     0.200
     0.803     7.098     0.200
     0.867     6.347     0.200
     0.959     6.184     0.200
     0.952     6.645     0.200
     1.016     6.038     0.200
     1.086     7.439     0.200
     1.058     6.891     0.200
     1.085     7.142     0.200
     1.181     6.519     0.200
     1.183     7.179     0.200
     1.259     6.989     0.200
     1.401     7.579     0.200
     1.451     7.797     0.200
     1.465     8.219     0.200
     1.465     7.479     0.200
     1.497     7.753     0.200
     1.532     7.746     0.200
     1.533     7.583     0.200
     1.819     7.839     0.200
     1.870     9.134     0.200
     1.929     8.509     0.200
     1.978     8.741     0.200
     2.010     8.852     0.200
     2.468    11.092     0.200
     2.693    10.243     0.200
     2.735     9.920     0.200
     3.230    10.491     0.200
     3.274     9.771     0.200
     3.346    10.593     0.200
     3.498    10.354     0.200
     3.588    11.690     0.200
     3.747    10.848     0.200
     3.826    11.228     0.200
     3.950    12.088     0.200
     4.005    10.438     0.200
     4.036    11.552     0.200
     4.166    12.686     0.200
     4.454    12.801     0.200
     4.506    12.889     0.200
     4.500    13.314     0.200
     4.522    12.942     0.200
     4.670    12.992     0.200
     4.687    12.954     0.200
     4.818    13.196     0.200
     4.810    14.352     0.200
     4.993    17.071     0.200
     5.063    13.702     0.200
     5.095    14.967     0.200
     5.109    14.748     0.200
     5.354    14.872     0.200
     5.594    15.795     0.200
     5.630    15.614     0.200
     5.768    14.926     0.200
     5.922    15.614     0.200
     6.173    16.057     0.200
     6.285    16.406     0.200
     6.868    17.289     0.200
     6.971    16.686     0.200
     6.971    17.333     0.200
     7.300    19.295     0.200
     7.427    19.563     0.200
     7.512    19.609     0.200
     9.744    22.972     0.200
    13.165    29.452     0.200
     0.717     5.150     0.200
     0.631     5.697     0.200
     0.795     5.854     0.200
     0.683     5.711     0.200
     0.791     5.475     0.200
     0.811     5.542     0.200
     0.840     5.834     0.200
     0.845     6.114     0.200
     0.855     5.653     0.200
     0.922     6.057     0.200
     0.955     5.892     0.200
     0.999     6.235     0.200
     0.996     6.162     0.200
     1.062     6.131     0.200
     1.074     6.608     0.200
     1.116     7.184     0.200
     1.215     6.578     0.200
     1.404     6.936     0.200
     1.531     8.052     0.200
     1.555     8.314     0.200
     1.558     8.311     0.200
     1.559     8.319     0.200
     1.563     8.233     0.200
     1.756     6.971     0.200
     1.860     8.729     0.200
     2.150     9.128     0.200
     2.175     8.792     0.200
     2.161     8.774     0.200
     2.225     9.087     0.200
     2.238     8.816     0.200
     2.271     9.202     0.200
     2.278     8.926     0.200
     2.306     8.835     0.200
     2.458     9.017     0.200
     2.570    10.647     0.200
     2.563    10.090     0.200
     2.657     9.573     0.200
     2.702     9.876     0.200
     2.656    10.086     0.200
     2.752     9.934     0.200
     3.255     9.996     0.200
     3.434    11.480     0.200
     3.484    11.309     0.200
     3.507    10.315     0.200
     3.613    13.029     0.200
     3.819    12.071     0.200
     3.785    10.800     0.200
     3.870    11.438     0.200
     3.937    11.144     0.200
     4.047    11.944     0.200
     4.202    11.065     0.200
     4.316    12.346     0.200
     4.452    11.938     0.200
     4.499    12.175     0.200
     4.477    12.761     0.200
     4.546    12.149     0.200
     4.657    12.666     0.200
     4.751    12.024     0.200
     4.848    12.647     0.200
     4.887    12.889     0.200
     4.920    13.344     0.200
     5.036    13.601     0.200
     5.021    14.614     0.200
     5.039    14.531     0.200
     5.091    15.167     0.200
     5.170    13.927     0.200
     5.116    14.762     0.200
     5.157    13.784     0.200
     5.227    14.943     0.200
     5.155    15.103     0.200
     5.249    14.865     0.200
     5.253    13.868     0.200
     5.228    14.287     0.200
     5.288    14.722     0.200
     5.343    14.416     0.200
     5.418    14.406     0.200
     5.510    14.731     0.200
     5.521    14.338     0.200
     5.643    14.383     0.200
     5.648    16.150     0.200
     5.743    15.357     0.200
     6.102    15.620     0.200
     6.146    16.124     0.200
     6.120    16.180     0.200
     6.216    15.698     0.200
     6.251    16.271     0.200
     6.320    16.514     0.200
     6.385    16.865     0.200
     6.428    17.127     0.200
     6.466    16.393     0.200
     6.598    16.512     0.200
     6.655    16.830     0.200
     6.695    17.140     0.200
     7.084    18.169     0.200
     7.147    16.631     0.200
     7.385    18.121     0.200
     7.426    17.571     0.200
     7.516    17.683     0.200
     7.624    17.455     0.200
     7.624    18.525     0.200
     7.716    17.520     0.200
     7.913    19.343     0.200
     8.195    20.390     0.200
     8.281    20.831     0.200
     8.200    20.105     0.200
     8.219    20.789     0.200
     8.301    19.807     0.200
     8.775    20.821     0.200
     9.369    22.298     0.200
     9.967    21.006     0.200
    10.073    23.684     0.200
    10.500    23.753     0.200
    12.542    29.053     0.200
    13.189    28.993     0.200
    13.862    30.348     0.200
    14.439    32.926     0.200
    15.701    35.574     0.200
    20.370    37.088     0.200
    20.373    37.620     0.200
    20.475    37.436     0.200
    20.723    36.112     0.200
    20.824    37.176     0.200
     0.263     5.354     0.200
     0.614     5.806     0.200
     1.215     6.614     0.200
     1.265     6.779     0.200
     1.343     7.094     0.200
     1.355     6.984     0.200
     1.400     6.439     0.200
     1.455     7.581     0.200
     1.466     8.118     0.200
     1.479     8.242     0.200
     1.496     7.922     0.200
     1.502     6.792     0.200
     1.509     7.205     0.200
     1.548     7.040     0.200
     1.573     7.050     0.200
     1.638     7.577     0.200
     1.596     7.404     0.200
     1.705     8.165     0.200
     1.683     7.695     0.200
     1.722     8.382     0.200
     1.718     7.267     0.200
     1.927     7.781     0.200
     2.001     8.292     0.200
     2.055     8.387     0.200
     2.053     8.625     0.200
     2.108     8.460     0.200
     2.112     8.379     0.200
     2.481     9.260     0.200
     2.533     9.326     0.200
     2.744     9.040     0.200
     2.812    10.580     0.200
     2.932     9.516     0.200
     3.162    11.020     0.200
     3.197    10.096     0.200
     3.209    10.545     0.200
     3.276    10.740     0.200
     3.364    11.256     0.200
     3.374    10.231     0.200
     3.334    10.183     0.200
     3.446     9.406     0.200
     3.453    10.204     0.200
     3.537    10.882     0.200
     3.849    11.377     0.200
     3.870    11.615     0.200
     3.942    10.902     0.200
     3.951    11.189     0.200
     3.954    10.852     0.200
     4.077    10.760     0.200
     4.160    11.714     0.200
     4.241    12.148     0.200
     4.323    12.663     0.200
     4.385    12.357     0.200
     4.442    12.745     0.200
     4.587    12.625     0.200
     4.541    12.678     0.200
     4.615    12.607     0.200
     4.601    13.103     0.200
     4.775    13.194     0.200
     4.779    13.236     0.200
     5.151    14.776     0.200
     5.224    14.107     0.200
     5.272    13.647     0.200
     5.368    14.722     0.200
     5.249    13.785     0.200
     5.270    13.843     0.200
     5.529    14.699     0.200
     5.672    15.872     0.200
     5.707    14.915     0.200
     5.664    15.558     0.200
     5.654    15.068     0.200
     5.690    14.784     0.200
     5.775    16.115     0.200
     5.809    14.705     0.200
     5.931    15.522     0.200
     5.878    15.760     0.200
     5.904    15.833     0.200
     5.916    15.581     0.200
     5.990    15.965     0.200
     5.985    15.847     0.200
     6.034    16.234     0.200
     6.156    16.289     0.200
     6.349    16.904     0.200
     6.611    18.397     0.200
     6.858    17.035     0.200
     6.787    16.370     0.200
     6.928    16.972     0.200
     6.939    17.357     0.200
     7.227    17.138     0.200
     7.282    17.161     0.200
     8.125    19.777     0.200
    13.310    30.336     0.200
     0.637     6.431     0.200
     0.756     6.220     0.200
     0.814     6.166     0.200
     1.014     6.855     0.200
     1.402     7.982     0.200
     1.544     7.069     0.200
     1.790     8.061     0.200
     2.039     9.001     0.200
     2.072     8.559     0.200
     2.138     8.793     0.200
     2.367     8.817     0.200
     2.454    10.228     0.200
     2.690     9.813     0.200
     3.070    12.144     0.200
     3.149    10.173     0.200
     3.226    11.080     0.200
     3.299    11.422     0.200
     3.324    11.039     0.200
     3.421    10.139     0.200
     3.488    11.917     0.200
     3.523    11.932     0.200
     3.699    12.148     0.200
     3.746    10.655     0.200
     3.820    11.129     0.200
     3.933    11.832     0.200
     4.187    12.059     0.200
     4.208    11.773     0.200
     4.336    11.412     0.200
     4.399    11.973     0.200
     4.499    12.408     0.200
     4.540    12.310     0.200
     4.740    12.861     0.200
     4.774    13.705     0.200
     4.974    13.500     0.200
     5.022    14.574     0.200
     5.022    14.441     0.200
     5.026    14.615     0.200
     5.044    14.785     0.200
     5.074    13.737     0.200
     5.157    14.911     0.200
     5.197    13.610     0.200
     5.237    14.212     0.200
     5.349    14.199     0.200
     5.495    14.836     0.200
     5.604    14.290     0.200
     5.655    15.177     0.200
     5.961    15.714     0.200
     6.025    15.607     0.200
     6.119    16.408     0.200
     6.169    15.517     0.200
     6.239    16.291     0.200
     6.253    16.523     0.200
     6.264    16.737     0.200
     6.474    17.096     0.200
     6.498    16.366     0.200
     6.630    16.541     0.200
     6.745    18.364     0.200
     6.928    18.050     0.200
     6.992    16.678     0.200
     7.066    18.000     0.200
     7.250    17.782     0.200
     7.477    17.634     0.200
     7.486    17.842     0.200
     7.577    18.489     0.200
     7.578    18.014     0.200
     7.641    18.622     0.200
     7.724    18.446     0.200
     7.841    19.271     0.200
     8.005    20.226     0.200
     8.091    19.795     0.200
     8.194    20.544     0.200
     8.565    22.808     0.200
    10.050    22.057     0.200
    12.592    29.563     0.200
    13.753    29.849     0.200
    14.397    30.540     0.200
     0.842     5.850     0.200
     0.942     6.099     0.200
     0.954     6.333     0.200
     1.197     6.597     0.200
     1.217     6.770     0.200
     1.225     6.980     0.200
     1.361     7.017     0.200
     1.372     6.265     0.200
     1.407     7.099     0.200
     2.245     9.412     0.200
     2.851    10.655     0.200
     2.916    10.827     0.200
     2.985    10.757     0.200
     3.380    11.810     0.200
     3.548    11.711     0.200
     3.652    11.796     0.200
     3.711    11.821     0.200
     3.843    11.889     0.200
     4.054    11.736     0.200
     4.141    13.233     0.200
     4.177    12.983     0.200
     4.213    13.843     0.200
     4.249    13.526     0.200
     4.287    14.391     0.200
     4.326    12.955     0.200
     4.597    13.699     0.200
     4.638    13.739     0.200
     4.721    12.988     0.200
     4.835    13.600     0.200
     4.846    15.253     0.200
     5.238    13.317     0.200
     5.441    14.639     0.200
     5.658    15.717     0.200
     5.681    15.881     0.200
     5.646    15.291     0.200
     5.644    14.797     0.200
     5.868    15.383     0.200
     6.086    15.624     0.200
     6.478    16.032     0.200
     6.560    17.571     0.200
     7.051    17.445     0.200
     7.110    17.665     0.200
     7.397    18.626     0.200
     7.488    18.611     0.200
     8.344    18.843     0.200
     8.457    19.024     0.200
     8.494    20.411     0.200
     8.742    21.120     0.200
     8.741    21.267     0.200
     8.829    21.780     0.200
     8.872    22.543     0.200
    13.299    31.302     0.200
    14.655    31.046     0.200
     0.291    11.559     0.200
     1.497     8.223     0.200
     1.547     8.739     0.200
     1.764     9.106     0.200
     1.900    10.203     0.200
     2.624    11.096     0.200
     3.069    10.765     0.200
     3.101    11.952     0.200
     3.190    11.657     0.200
     3.339    11.875     0.200
     3.651    13.596     0.200
     3.743    11.458     0.200
     3.759    13.029     0.200
     3.808    12.671     0.200
     3.811    12.100     0.200
     3.854    11.419     0.200
     4.120    12.086     0.200
     4.232    12.810     0.200
     4.239    12.776     0.200
     4.307    13.799     0.200
     4.445    12.736     0.200
     4.510    12.102     0.200
     4.564    12.972     0.200
     4.755    12.693     0.200
     4.775    13.887     0.200
     4.856    14.376     0.200
     4.961    12.895     0.200
     5.007    13.317     0.200
     5.060    13.423     0.200
     5.151    14.819     0.200
     5.175    14.360     0.200
     5.161    13.572     0.200
     5.294    14.339     0.200
     5.256    13.302     0.200
     5.274    14.453     0.200
     5.379    14.135     0.200
     5.448    13.589     0.200
     5.555    14.573     0.200
     5.675    15.078     0.200
     5.705    15.122     0.200
     5.743    14.801     0.200
     5.937    15.397     0.200
     5.901    15.687     0.200
     5.936    15.437     0.200
     6.068    15.807     0.200
     6.189    16.103     0.200
     6.280    16.373     0.200
     6.364    16.225     0.200
     6.622    16.181     0.200
     6.749    16.470     0.200
     6.882    17.968     0.200
     6.832    17.816     0.200
     6.918    17.406     0.200
     7.023    17.155     0.200
     7.060    18.518     0.200
     7.150    17.516     0.200
     7.402    17.912     0.200
     7.414    18.595     0.200
     7.368    19.076     0.200
     7.463    17.135     0.200
     7.577    17.046     0.200
     7.634    18.624     0.200
     7.791    17.325     0.200
     7.796    17.798     0.200
     7.848    19.895     0.200
     7.971    17.941     0.200
     7.977    17.733     0.200
     8.110    17.827     0.200
     8.355    21.005     0.200
    10.834    23.331     0.200
    13.394    30.280     0.200
    13.594    27.859     0.200
    14.367    29.208     0.200
     0.499     5.928     0.200
     0.691     5.123     0.200
     0.592     6.409     0.200
     0.624     6.781     0.200
     0.747     4.947     0.200
     0.700     6.202     0.200
     0.782     6.302     0.200
     0.825     6.194     0.200
     0.951     6.112     0.200
     0.959     6.286     0.200
     0.963     6.660     0.200
     0.969     6.176     0.200
     0.985     7.099     0.200
     0.988     7.236     0.200
     0.990     6.906     0.200
     0.993     6.874     0.200
     0.991     6.541     0.200
     1.001     6.751     0.200
     1.011     6.885     0.200
     1.048     6.418     0.200
     1.118     6.514     0.200
     1.143     6.495     0.200
     1.208     6.878     0.200
     1.281     6.874     0.200
     1.277     7.421     0.200
     1.403     7.244     0.200
     1.523     8.632     0.200
     1.496     7.178     0.200
     1.547     7.513     0.200
     1.585     7.736     0.200
     1.646     7.754     0.200
     1.711     7.778     0.200
     1.843     7.671     0.200
     1.942     8.895     0.200
     2.103     8.679     0.200
     2.133     9.284     0.200
     2.154     9.143     0.200
     2.194     9.214     0.200
     2.579    11.243     0.200
     2.631     9.019     0.200
     2.896     9.290     0.200
     2.873    10.210     0.200
     2.984    11.646     0.200
     2.992    10.153     0.200
     3.051    10.566     0.200
     3.144    10.981     0.200
     3.194    11.716     0.200
     3.229    10.143     0.200
     3.420    10.760     0.200
     3.688    11.733     0.200
     3.825    10.929     0.200
     3.878    11.100     0.200
     3.992    11.519     0.200
     4.000    10.513     0.200
     4.030    11.745     0.200
     4.177    10.659     0.200
     4.224    12.400     0.200
     4.299    12.391     0.200
     4.297    12.863     0.200
     4.393    12.356     0.200
     4.449    12.532     0.200
     4.552    12.734     0.200
     4.616    12.870     0.200
     4.673    12.928     0.200
     4.744    13.775     0.200
     4.816    13.594     0.200
     4.766    13.796     0.200
     4.823    13.152     0.200
     4.992    13.722     0.200
     5.016    14.339     0.200
     5.086    13.830     0.200
     5.311    15.176     0.200
     5.477    14.668     0.200
     5.518    15.025     0.200
     5.647    15.206     0.200
     5.636    16.272     0.200
     5.638    14.210     0.200
     5.761    16.040     0.200
     5.978    15.624     0.200
     6.039    15.527     0.200
     6.119    15.308     0.200
     6.230    18.464     0.200
     6.528    15.786     0.200
     6.757    16.934     0.200
     6.779    17.999     0.200
     6.801    16.473     0.200
     7.000    17.074     0.200
     7.089    17.191     0.200
     7.636    19.298     0.200
     7.720    19.685     0.200
    12.156    29.312     0.200
    13.238    27.962     0.200
     0.060    19.009     0.200
     0.271    17.038     0.200
     0.328    16.507     0.200
     0.351    16.289     0.200
     0.434    15.447     0.200
     0.459    15.167     0.200
     0.515    15.210     0.200
     0.555    14.643     0.200
     0.609    14.567     0.200
     0.619    14.260     0.200
     0.690    14.243     0.200
     0.769    14.022     0.200
     0.898    13.409     0.200
     1.222    12.335     0.200
     1.674    11.949     0.200
     1.678    12.138     0.200
     1.693    12.179     0.200
     1.700    12.112     0.200
     1.711    12.130     0.200
     1.745    11.742     0.200
     1.873    10.767     0.200
     1.902    11.863     0.200
     1.930    10.756     0.200
     1.956    12.158     0.200
     2.229    12.060     0.200
     2.282    11.917     0.200
     2.290    12.015     0.200
     2.356    12.222     0.200
     2.675    12.144     0.200
     2.714    12.504     0.200
     2.741    12.328     0.200
     2.740    12.040     0.200
     2.815    12.634     0.200
     2.838    12.585     0.200
     2.910    12.447     0.200
     2.966    13.223     0.200
     3.004    12.018     0.200
     3.430    14.054     0.200
     3.472    13.694     0.200
     3.497    13.125     0.200
     3.651    13.949     0.200
     3.672    13.337     0.200
     3.893    14.975     0.200
     3.865    11.954     0.200
     4.022    13.460     0.200
     4.376    13.727     0.200
     4.431    14.345     0.200
     4.520    13.902     0.200
     4.537    14.216     0.200
     4.537    14.109     0.200
     4.615    15.798     0.200
     4.759    13.568     0.200
     4.827    14.127     0.200
     4.900    13.438     0.200
     4.952    13.593     0.200
     4.988    14.543     0.200
     5.192    14.096     0.200
     5.275    15.172     0.200
     5.413    14.324     0.200
     5.486    15.516     0.200
     5.584    14.733     0.200
     5.636    15.779     0.200
     5.677    15.456     0.200
     5.881    16.185     0.200
     5.977    15.645     0.200
     6.139    16.894     0.200
     6.181    16.343     0.200
     6.189    16.430     0.200
     6.326    17.353     0.200
     6.348    16.543     0.200
     6.374    15.770     0.200
     6.423    16.747     0.200
     6.454    17.549     0.200
     6.670    17.677     0.200
     6.876    17.990     0.200
     6.878    18.454     0.200
     6.989    18.667     0.200
     6.994    19.355     0.200
     7.101    16.838     0.200
     7.115    18.642     0.200
     7.144    18.807     0.200
     7.359    19.134     0.200
     7.417    19.040     0.200
     7.395    19.250     0.200
     7.397    17.363     0.200
     7.458    17.204     0.200
     7.493    17.599     0.200
     7.477    18.299     0.200
     7.617    17.598     0.200
     7.634    17.987     0.200
     7.774    20.310     0.200
     7.794    17.844     0.200
     7.794    17.100     0.200
     8.426    20.808     0.200
     8.662    21.283     0.200
    14.112    26.292     0.200
     0.561     4.456     0.200
     0.782     6.160     0.200
     0.778     6.198     0.200
     0.822     5.291     0.200
     0.823     5.786     0.200
     0.844     6.311     0.200
     0.923     5.616     0.200
     0.988     5.746     0.200
     0.986     6.194     0.200
     1.063     6.511     0.200
     1.108     6.314     0.200
     1.132     6.117     0.200
     1.323     6.711     0.200
     2.097     8.883     0.200
     2.354     9.726     0.200
     2.520    10.128     0.200
     2.551    10.059     0.200
     2.571    10.241     0.200
     2.608    10.258     0.200
     2.654     9.957     0.200
     2.661     9.827     0.200
     2.972     8.878     0.200
     2.999    11.819     0.200
     3.034     9.742     0.200
     3.282    10.048     0.200
     3.281    11.246     0.200
     3.294    11.066     0.200
     3.297    11.242     0.200
     3.322    11.432     0.200
     3.342    11.487     0.200
     3.356    11.679     0.200
     3.331    11.257     0.200
     3.367    11.604     0.200
     3.399    10.865     0.200
     3.422    11.592     0.200
     3.559    10.348     0.200
     3.501    11.702     0.200
     3.608    11.172     0.200
     3.829    11.539     0.200
     4.104    12.237     0.200
     4.234    11.311     0.200
     4.276    11.705     0.200
     4.321    11.865     0.200
     4.361    11.308     0.200
     4.439    12.399     0.200
     4.524    11.467     0.200
     4.628    12.726     0.200
     4.660    12.366     0.200
     4.718    12.357     0.200
     4.685    11.657     0.200
     4.719    13.793     0.200
     4.809    13.082     0.200
     4.946    13.515     0.200
     5.071    13.536     0.200
     5.120    13.774     0.200
     5.108    14.855     0.200
     5.191    13.803     0.200
     5.289    14.377     0.200
     5.250    13.814     0.200
     5.361    15.170     0.200
     5.417    13.815     0.200
     5.354    14.488     0.200
     5.371    14.233     0.200
     5.518    15.274     0.200
     5.731    16.074     0.200
     5.732    16.421     0.200
     5.902    15.435     0.200
     5.897    15.291     0.200
     5.930    15.226     0.200
     5.989    15.287     0.200
     6.026    16.467     0.200
     6.092    16.612     0.200
     6.182    16.910     0.200
     6.375    16.106     0.200
     6.431    15.593     0.200
     6.950    16.781     0.200
     7.509    18.123     0.200
     7.508    17.431     0.200
     7.686    18.626     0.200
     8.039    19.722     0.200
     8.124    20.693     0.200
     8.414    20.081     0.200
    10.215    26.288     0.200
    12.348    31.372     0.200
    13.641    30.214     0.200
     0.203    12.168     0.200
     0.266    11.604     0.200
     0.384    10.664     0.200
     0.376    10.506     0.200
     0.440    10.717     0.200
     0.433    10.430     0.200
     0.550    10.217     0.200
     0.626     9.259     0.200
     0.688     9.313     0.200
     0.700     9.351     0.200
     0.826     9.709     0.200
     0.779     9.324     0.200
     0.846     9.834     0.200
     0.850     9.851     0.200
     0.861     9.867     0.200
     0.864     9.686     0.200
     0.799     9.135     0.200
     0.902     9.159     0.200
     0.926     8.983     0.200
     1.239     7.928     0.200
     1.298     8.162     0.200
     1.461     9.359     0.200
     1.526     9.422     0.200
     1.698     9.569     0.200
     1.803     9.228     0.200
     1.944     9.830     0.200
     1.987    10.113     0.200
     2.022    10.093     0.200
     2.048    10.073     0.200
     2.076    10.416     0.200
     2.077     9.154     0.200
     2.120    10.156     0.200
     2.162     9.801     0.200
     2.571    10.345     0.200
     2.613    11.823     0.200
     2.746    11.008     0.200
     2.774    10.874     0.200
     2.786    10.717     0.200
     2.787    10.183     0.200
     2.800    11.313     0.200
     2.741    10.432     0.200
     2.826    11.656     0.200
     2.845    11.688     0.200
     2.874     9.597     0.200
     2.830    10.295     0.200
     2.911    11.059     0.200
     2.972    11.376     0.200
     3.114    10.270     0.200
     3.270    11.931     0.200
     3.409    11.378     0.200
     3.530    11.529     0.200
     3.576    11.266     0.200
     3.737    12.004     0.200
     3.924    11.061     0.200
     4.033    11.502     0.200
     4.124    11.717     0.200
     4.176    12.659     0.200
     4.266    13.039     0.200
     4.270    11.455     0.200
     4.334    12.738     0.200
     4.346    12.483     0.200
     4.369    13.462     0.200
     4.391    13.538     0.200
     4.481    11.791     0.200
     4.717    13.174     0.200
     4.717    13.075     0.200
     4.736    13.047     0.200
     4.743    13.178     0.200
     4.910    14.198     0.200
     4.957    13.709     0.200
     5.069    13.731     0.200
     5.193    14.100     0.200
     5.193    14.518     0.200
     5.217    15.137     0.200
     5.314    14.441     0.200
     5.298    17.098     0.200
     5.379    15.012     0.200
     5.337    15.415     0.200
     5.412    14.594     0.200
     5.461    14.232     0.200
     5.434    15.847     0.200
     5.584    14.619     0.200
     5.725    15.223     0.200
     5.727    16.127     0.200
     5.806    15.568     0.200
     5.948    15.371     0.200
     5.973    16.136     0.200
     6.013    15.543     0.200
     6.041    16.743     0.200
     6.088    16.807     0.200
     6.117    15.901     0.200
     6.170    16.301     0.200
     6.419    17.590     0.200
     6.453    15.372     0.200
     6.475    16.656     0.200
     6.554    15.600     0.200
     6.568    18.024     0.200
     6.630    16.558     0.200
     6.764    16.081     0.200
     6.768    15.790     0.200
     6.932    18.253     0.200
     6.957    16.304     0.200
     6.957    16.417     0.200
     7.043    17.889     0.200
     7.081    16.312     0.200
     7.081    16.003     0.200
     7.153    17.060     0.200
     7.378    18.867     0.200
     7.464    18.741     0.200
     7.538    19.326     0.200
     7.610    19.408     0.200
     7.718    19.280     0.200
     7.950    21.743     0.200
     8.025    18.527     0.200
     8.330    21.362     0.200
     8.412    20.299     0.200
     8.970    21.519     0.200
     9.423    25.214     0.200
     9.830    20.661     0.200
    10.220    22.190     0.200
    12.650    29.395     0.200
    13.329    27.818     0.200
     0.438     8.246     0.200
     0.499     7.964     0.200
     0.503     7.994     0.200
     0.502     8.113     0.200
     0.594     8.055     0.200
     0.611     7.984     0.200
     0.763     7.389     0.200
     0.770     7.697     0.200
     0.852     7.746     0.200
     0.885     7.666     0.200
     0.903     7.920     0.200
     1.017     7.611     0.200
     1.035     7.844     0.200
     1.335     7.032     0.200
     1.382     6.939     0.200
     1.497     8.057     0.200
     1.600     8.293     0.200
     1.719     8.471     0.200
     1.907     9.093     0.200
     1.942     9.342     0.200
     1.948     9.358     0.200
     2.205     9.310     0.200
     2.549    10.321     0.200
     2.613    10.430     0.200
     2.629    10.410     0.200
     3.048    10.168     0.200
     3.075    11.705     0.200
     3.106    11.616     0.200
     3.110    11.701     0.200
     3.133    11.684     0.200
     3.207    11.890     0.200
     3.249    11.525     0.200
     3.496    11.790     0.200
     3.684    13.470     0.200
     3.779    11.262     0.200
     3.793    11.481     0.200
     3.811    11.103     0.200
     3.821    10.629     0.200
     3.832    12.861     0.200
     3.874    12.394     0.200
     3.885    13.238     0.200
     4.058    13.541     0.200
     4.326    13.035     0.200
     4.331    13.823     0.200
     4.405    12.994     0.200
     4.451    13.569     0.200
     4.451    12.240     0.200
     4.530    12.824     0.200
     4.579    13.527     0.200
     4.823    13.010     0.200
     4.807    14.225     0.200
     5.062    13.485     0.200
     5.181    14.475     0.200
     5.215    14.024     0.200
     5.311    15.611     0.200
     5.334    14.936     0.200
     5.352    15.107     0.200
     5.392    14.624     0.200
     5.520    14.553     0.200
     5.615    14.575     0.200
     5.670    15.085     0.200
     5.743    15.273     0.200
     5.896    15.439     0.200
     5.991    15.769     0.200
     6.030    15.590     0.200
     6.041    15.576     0.200
     6.202    16.052     0.200
     6.309    15.521     0.200
     6.330    16.945     0.200
     6.823    17.761     0.200
     6.830    18.369     0.200
     6.872    17.011     0.200
     7.013    17.629     0.200
     7.338    18.027     0.200
     7.589    18.997     0.200
     7.774    19.361     0.200
     7.855    17.612     0.200
     8.044    18.424     0.200
     8.167    18.056     0.200
     8.167    18.521     0.200
     8.337    20.023     0.200
     8.401    20.573     0.200
     8.489    21.333     0.200
     8.529    20.956     0.200
     8.550    19.735     0.200
     0.090    17.367     0.200
     0.215    16.188     0.200
     0.307    15.414     0.200
     0.361    14.650     0.200
     0.376    14.923     0.200
     0.434    14.494     0.200
     0.490    13.899     0.200
     0.524    13.926     0.200
     0.558    13.440     0.200
     0.570    13.160     0.200
     0.573    13.597     0.200
     0.645    12.989     0.200
     0.653    13.437     0.200
     0.675    13.094     0.200
     0.705    12.846     0.200
     0.824    12.498     0.200
     1.104    12.076     0.200
     1.107    12.267     0.200
     1.117    12.406     0.200
     1.123    12.262     0.200
     1.129    12.111     0.200
     1.207    11.536     0.200
     1.449    11.107     0.200
     1.638     9.737     0.200
     1.662    11.587     0.200
     1.698     9.833     0.200
     1.724    11.603     0.200
     2.157    11.929     0.200
     2.190    11.141     0.200
     2.192    11.757     0.200
     2.194    11.847     0.200
     2.197    11.795     0.200
     2.350    11.801     0.200
     2.397    12.190     0.200
     2.446    10.994     0.200
     2.437    12.068     0.200
     2.860    13.055     0.200
     2.886    12.599     0.200
     2.947    12.044     0.200
     3.101    11.879     0.200
     3.455    12.380     0.200
     3.529    13.154     0.200
     3.640    12.439     0.200
     3.680    13.366     0.200
     3.804    12.705     0.200
     3.975    13.032     0.200
     3.971    13.906     0.200
     4.189    11.714     0.200
     4.252    14.407     0.200
     4.275    14.308     0.200
     4.328    12.593     0.200
     4.382    12.611     0.200
     4.435    12.212     0.200
     4.439    13.604     0.200
     4.448    12.484     0.200
     4.613    13.873     0.200
     4.619    12.775     0.200
     4.628    12.847     0.200
     4.726    14.396     0.200
     4.805    14.764     0.200
     4.922    14.320     0.200
     4.916    14.481     0.200
     4.960    15.256     0.200
     5.012    13.679     0.200
     5.071    14.256     0.200
     5.078    14.347     0.200
     5.108    14.970     0.200
     5.126    14.408     0.200
     5.292    15.622     0.200
     5.318    15.139     0.200
     5.328    15.460     0.200
     5.371    15.065     0.200
     5.409    14.620     0.200
     5.399    14.608     0.200
     5.617    15.446     0.200
     5.641    16.742     0.200
     5.792    15.641     0.200
     5.811    14.904     0.200
     5.883    15.837     0.200
     5.882    15.625     0.200
     6.098    15.751     0.200
     6.138    16.049     0.200
     6.309    17.659     0.200
     6.389    16.259     0.200
     6.426    18.277     0.200
     6.461    17.579     0.200
     6.576    15.937     0.200
     6.690    17.630     0.200
     6.696    16.987     0.200
     6.706    16.133     0.200
     6.744    17.633     0.200
     6.796    17.921     0.200
     6.844    18.629     0.200
     6.867    17.961     0.200
     6.921    16.376     0.200
     6.945    16.527     0.200
     7.089    16.801     0.200
     7.101    16.722     0.200
     7.251    16.969     0.200
     7.250    16.492     0.200
     7.304    17.563     0.200
     7.330    19.428     0.200
     7.349    19.105     0.200
     7.437    19.170     0.200
     7.855    19.488     0.200
     7.957    19.458     0.200
     8.015    19.204     0.200
     8.039    19.527     0.200
     8.155    20.259     0.200
     8.159    19.522     0.200
     8.196    18.515     0.200
     9.964    20.328     0.200
    10.683    23.387     0.200
    13.553    26.793     0.200
     1.495     8.974     0.200
     1.500     9.301     0.200
     1.499     8.903     0.200
     1.518     9.379     0.200
     1.519     9.473     0.200
     1.526     9.373     0.200
     1.538     9.375     0.200
     1.540     9.280     0.200
     1.705     9.689     0.200
     1.888     9.796     0.200
     1.942     9.944     0.200
     1.987     9.747     0.200
     1.993    10.037     0.200
     2.037     9.815     0.200
     2.050     9.984     0.200
     2.097     9.722     0.200
     2.244     8.970     0.200
     2.240     9.743     0.200
     2.372    10.396     0.200
     2.392    10.313     0.200
     2.424    10.398     0.200
     2.446     9.958     0.200
     2.456    10.027     0.200
     2.591    11.731     0.200
     2.603    10.290     0.200
     2.707     9.623     0.200
     2.902    11.820     0.200
     2.929    10.826     0.200
     3.031    10.967     0.200
     3.059    11.277     0.200
     3.031    10.222     0.200
     3.098    12.113     0.200
     3.170    11.464     0.200
     3.180    11.251     0.200
     3.257    12.029     0.200
     3.260    11.644     0.200
     3.453    11.552     0.200
     3.570    11.224     0.200
     3.578    12.641     0.200
     3.604    12.331     0.200
     3.629    11.949     0.200
     3.659    11.487     0.200
     3.691    11.338     0.200
     3.842    12.199     0.200
     3.864    12.723     0.200
     3.863    12.475     0.200
     4.010    13.191     0.200
     4.008    12.984     0.200
     4.038    13.249     0.200
     4.124    13.380     0.200
     4.203    13.276     0.200
     4.206    13.108     0.200
     4.305    14.253     0.200
     4.364    13.578     0.200
     4.407    13.846     0.200
     4.545    14.025     0.200
     4.800    14.777     0.200
     4.926    15.279     0.200
     4.976    16.055     0.200
     4.954    14.974     0.200
     5.050    15.400     0.200
     5.047    14.771     0.200
     5.088    16.030     0.200
     5.135    15.140     0.200
     5.185    15.282     0.200
     5.224    15.671     0.200
     5.243    15.304     0.200
     5.315    16.705     0.200
     5.292    16.097     0.200
     5.395    16.779     0.200
     5.736    17.152     0.200
     5.639    16.781     0.200
     5.938    16.955     0.200
     6.000    17.325     0.200
     6.115    17.645     0.200
     6.199    19.132     0.200
     6.223    19.181     0.200
     6.246    19.158     0.200
     6.331    17.090     0.200
     6.271    19.294     0.200
     6.319    19.708     0.200
     6.332    19.302     0.200
     6.401    19.366     0.200
     6.548    17.768     0.200
     6.550    18.178     0.200
     6.514    18.064     0.200
     6.619    19.014     0.200
     6.655    18.144     0.200
     6.755    18.201     0.200
     6.901    18.915     0.200
     6.895    19.983     0.200
     6.829    20.611     0.200
     6.967    18.885     0.200
     7.004    18.259     0.200
     7.005    18.972     0.200
     7.313    22.744     0.200
     7.907    20.068     0.200
     7.987    20.378     0.200
     8.825    19.805     0.200
     9.381    25.145     0.200
     9.818    23.366     0.200
    11.362    29.121     0.200
    12.968    31.252     0.200
    15.622    35.384     0.200
    18.638    38.670     0.200
    18.646    38.682     0.200
    19.176    40.509     0.200
    20.243    40.565     0.200
    20.290    41.136     0.200
    20.759    39.137     0.200
    20.791    42.357     0.200
     0.795     5.540     0.200
     0.830     5.341     0.200
     0.858     5.920     0.200
     0.852     5.481     0.200
     0.949     5.871     0.200
     0.970     5.943     0.200
     1.077     5.786     0.200
     1.124     6.459     0.200
     1.187     6.582     0.200
     1.193     6.538     0.200
     1.312     7.187     0.200
     1.349     6.839     0.200
     1.278     5.831     0.200
     1.313     6.309     0.200
     1.735     7.989     0.200
     1.825     8.213     0.200
     1.896     7.921     0.200
     2.103     8.263     0.200
     2.154     9.135     0.200
     2.177     9.362     0.200
     2.179     9.452     0.200
     2.180     9.338     0.200
     2.181     9.277     0.200
     2.197     9.383     0.200
     2.488     9.950     0.200
     2.505     9.192     0.200
     2.804    10.428     0.200
     2.851    10.761     0.200
     2.869    10.480     0.200
     2.890    10.709     0.200
     2.903     9.944     0.200
     2.938    10.962     0.200
     3.200    10.237     0.200
     3.290    11.568     0.200
     3.291    11.895     0.200
     3.368    12.067     0.200
     3.381    11.673     0.200
     3.401    11.818     0.200
     3.742    12.355     0.200
     3.835    11.873     0.200
     3.901    14.272     0.200
     3.949    10.850     0.200
     4.130    12.558     0.200
     4.307    13.727     0.200
     4.252    12.387     0.200
     4.344    13.651     0.200
     4.354    13.744     0.200
     4.322    13.516     0.200
     4.381    14.650     0.200
     4.324    14.221     0.200
     4.430    14.626     0.200
     4.439    14.030     0.200
     4.465    13.493     0.200
     4.505    13.660     0.200
     4.537    12.382     0.200
     4.651    13.591     0.200
     4.796    13.802     0.200
     4.770    13.166     0.200
     4.940    15.503     0.200
     4.871    13.017     0.200
     4.928    14.122     0.200
     5.021    14.137     0.200
     5.173    13.559     0.200
     5.298    14.017     0.200
     5.341    13.642     0.200
     5.421    17.642     0.200
     5.377    14.838     0.200
     5.503    13.685     0.200
     5.594    16.185     0.200
     5.650    16.117     0.200
     5.673    15.728     0.200
     5.640    14.754     0.200
     5.694    14.448     0.200
     5.789    15.043     0.200
     5.909    15.277     0.200
     5.904    15.736     0.200
     6.006    15.153     0.200
     6.086    15.455     0.200
     6.170    15.739     0.200
     6.394    16.051     0.200
     6.487    17.237     0.200
     6.706    18.532     0.200
     6.785    16.780     0.200
     6.850    18.582     0.200
     6.931    17.672     0.200
     6.939    16.920     0.200
     6.968    17.420     0.200
     7.058    17.261     0.200
     7.068    17.661     0.200
     7.360    17.973     0.200
     7.491    19.148     0.200
     7.515    17.817     0.200
     7.425    18.423     0.200
     7.632    20.577     0.200
     7.582    21.277     0.200
     7.825    19.352     0.200
     7.888    18.400     0.200
     8.101    18.354     0.200
     8.294    20.735     0.200
     8.299    18.916     0.200
     8.335    19.628     0.200
     8.403    18.463     0.200
     8.486    20.553     0.200
     8.720    21.428     0.200
     8.664    21.503     0.200
     8.807    22.751     0.200
     8.905    22.805     0.200
     9.344    22.234     0.200
    10.371    25.899     0.200
    11.170    23.947     0.200
    13.203    31.904     0.200
    14.590    31.469     0.200
    16.172    36.004     0.200
    20.598    36.073     0.200
     4.362    13.222     0.200
     4.269    12.503     0.200
     4.433    13.196     0.200
     4.516    11.825     0.200
     4.530    11.382     0.200
     5.020    13.208     0.200
     5.383    14.472     0.200
     6.161    17.156     0.200
     6.183    16.871     0.200
     7.057    18.607     0.200
     7.378    19.182     0.200
     8.294    20.535     0.200
     8.350    20.530     0.200
     9.125    22.906     0.200
     9.716    24.747     0.200
     9.611    21.464     0.200
     9.732    24.007     0.200
    11.188    27.878     0.200
    12.328    29.035     0.200
    12.328    29.630     0.200
    14.351    31.755     0.200
    14.351    32.245     0.200
    14.689    37.091     0.200
    15.136    37.439     0.200
    19.551    39.031     0.200
    19.769    37.924     0.200
    19.713    39.101     0.200
    20.544    38.561     0.200
    20.636    38.929     0.200
     4.337    13.806     0.200
     4.441    13.564     0.200
     4.479    11.488     0.200
     5.032    13.494     0.200
     5.210    13.839     0.200
     5.397    14.819     0.200
     6.139    17.167     0.200
     6.204    17.512     0.200
     7.062    17.801     0.200
     7.395    21.127     0.200
     8.275    18.682     0.200
     8.300    20.803     0.200
     8.359    20.865     0.200
     9.114    22.823     0.200
     9.759    24.760     0.200
    14.371    33.609     0.200
    14.371    33.749     0.200
     0.270    10.344     0.200
     0.472     9.563     0.200
     0.448     9.699     0.200
     0.499     9.202     0.200
     1.047     8.502     0.200
     1.164     7.579     0.200
     1.222     7.530     0.200
     1.346     8.789     0.200
     1.367     9.058     0.200
     1.675     9.221     0.200
     2.066     9.617     0.200
     2.120     9.710     0.200
     2.247     9.375     0.200
     2.533     9.407     0.200
     2.547    10.544     0.200
     2.571    10.600     0.200
     2.566    11.107     0.200
     2.645    10.932     0.200
     3.004    10.735     0.200
     3.275    10.883     0.200
     3.311    11.336     0.200
     3.369    12.176     0.200
     3.435    12.015     0.200
     3.860    11.580     0.200
     3.984    11.450     0.200
     4.033    12.093     0.200
     4.209    12.071     0.200
     4.252    12.630     0.200
     4.278    11.506     0.200
     4.431    12.081     0.200
     4.525    12.315     0.200
     4.510    12.267     0.200
     4.632    12.844     0.200
     4.721    12.183     0.200
     4.789    14.261     0.200
     4.816    14.619     0.200
     4.839    14.155     0.200
     4.747    13.874     0.200
     4.847    13.556     0.200
     4.873    14.680     0.200
     4.901    14.789     0.200
     5.019    13.890     0.200
     5.150    13.860     0.200
     5.208    14.339     0.200
     5.402    14.638     0.200
     5.532    14.548     0.200
     5.727    15.271     0.200
     5.800    16.230     0.200
     5.835    15.044     0.200
     6.041    16.742     0.200
     6.098    15.348     0.200
     6.250    15.912     0.200
     6.386    16.648     0.200
     6.567    16.960     0.200
     6.840    18.943     0.200
     6.978    18.153     0.200
     7.082    18.911     0.200
     7.148    17.942     0.200
     7.227    19.243     0.200
     7.286    18.116     0.200
     7.329    18.901     0.200
     7.481    17.017     0.200
     7.506    17.229     0.200
     7.545    19.063     0.200
     7.604    16.331     0.200
     7.658    19.180     0.200
     7.870    19.911     0.200
     7.957    20.665     0.200
     7.918    18.602     0.200
     8.012    19.786     0.200
     8.042    19.281     0.200
    12.936    29.491     0.200
    12.936    29.956     0.200
    13.842    28.141     0.200
     0.367     6.757     0.200
     0.392     6.633     0.200
     0.483     6.549     0.200
     0.529     6.419     0.200
     0.549     6.510     0.200
     0.706     6.480     0.200
     0.771     6.119     0.200
     0.761     6.108     0.200
     1.096     7.104     0.200
     1.149     5.682     0.200
     1.584     7.886     0.200
     2.254     9.080     0.200
     2.306     9.067     0.200
     2.343     9.141     0.200
     2.398     9.100     0.200
     2.690     9.342     0.200
     2.771    10.312     0.200
     2.783    10.452     0.200
     2.801    10.251     0.200
     2.870    10.446     0.200
     2.906    10.525     0.200
     3.252    10.437     0.200
     3.393    11.541     0.200
     3.452    11.151     0.200
     3.525    12.219     0.200
     3.535    12.044     0.200
     3.596    12.661     0.200
     3.975    12.432     0.200
     4.047    12.006     0.200
     4.072    12.686     0.200
     4.103    11.310     0.200
     4.142    12.978     0.200
     4.221    12.313     0.200
     4.371    13.071     0.200
     4.369    11.907     0.200
     4.584    12.496     0.200
     4.621    12.259     0.200
     4.652    13.988     0.200
     4.703    12.798     0.200
     4.702    14.206     0.200
     4.824    13.338     0.200
     4.789    14.358     0.200
     4.871    14.487     0.200
     5.007    14.720     0.200
     5.034    13.661     0.200
     5.064    14.824     0.200
     5.165    14.990     0.200
     5.267    13.580     0.200
     5.542    14.319     0.200
     6.298    16.043     0.200
     6.469    15.444     0.200
     6.519    15.952     0.200
     7.032    18.627     0.200
     7.512    16.855     0.200
     7.703    18.196     0.200
     7.733    19.285     0.200
     7.820    17.548     0.200
     7.820    17.431     0.200
     7.821    18.580     0.200
     8.102    19.389     0.200
     8.171    20.106     0.200
     8.203    20.117     0.200
     9.617    23.029     0.200
    12.971    30.751     0.200
    14.038    31.547     0.200
     0.793     5.575     0.200
     0.810     5.914     0.200
     0.810     5.654     0.200
     1.281     7.148     0.200
     1.537     7.916     0.200
     1.537     7.418     0.200
     1.574     8.385     0.200
     1.578     8.153     0.200
     1.619     8.355     0.200
     1.714     8.454     0.200
     1.706     8.677     0.200
     1.798     8.553     0.200
     1.823     8.228     0.200
     1.925     8.536     0.200
     1.972     8.850     0.200
     1.980     8.856     0.200
     1.968     8.617     0.200
     2.016     8.669     0.200
     2.037     8.859     0.200
     2.108     8.206     0.200
     2.099     7.716     0.200
     2.197     9.424     0.200
     2.352     9.122     0.200
     2.337     8.669     0.200
     2.394     8.859     0.200
     2.448     9.209     0.200
     2.457     9.422     0.200
     2.465     8.515     0.200
     2.868     9.719     0.200
     2.963     9.963     0.200
     2.963    10.041     0.200
     2.999    10.240     0.200
     2.985    10.943     0.200
     3.137    10.542     0.200
     3.284    10.637     0.200
     3.491    11.253     0.200
     3.491    10.857     0.200
     3.533    10.816     0.200
     3.596    11.437     0.200
     3.672    11.301     0.200
     3.674    11.155     0.200
     3.736    11.523     0.200
     3.876    12.018     0.200
     4.013    12.688     0.200
     4.038    12.260     0.200
     4.120    13.162     0.200
     4.203    13.979     0.200
     4.248    12.955     0.200
     4.376    12.955     0.200
     4.649    14.807     0.200
     4.818    14.523     0.200
     4.966    14.142     0.200
     5.011    13.917     0.200
     5.210    14.462     0.200
     5.245    15.112     0.200
     5.326    15.346     0.200
     5.350    15.110     0.200
     5.548    15.575     0.200
     5.625    15.667     0.200
     5.764    16.592     0.200
     5.800    17.388     0.200
     5.814    15.961     0.200
     6.342    17.658     0.200
     6.395    17.368     0.200
     6.442    16.788     0.200
     6.470    17.639     0.200
     6.492    17.973     0.200
     6.505    18.312     0.200
     6.531    17.873     0.200
     6.639    16.824     0.200
     6.852    16.999     0.200
     6.881    17.643     0.200
     6.881    17.097     0.200
     7.018    18.532     0.200
     7.843    19.366     0.200
     7.923    19.606     0.200
     8.200    20.375     0.200
     8.672    19.146     0.200
     9.222    23.447     0.200
     9.554    23.190     0.200
     9.697    22.725     0.200
    10.685    27.500     0.200
    11.210    25.508     0.200
    11.196    27.887     0.200
    11.196    27.163     0.200
    12.819    28.425     0.200
    12.819    29.855     0.200
    14.537    32.793     0.200
    15.790    34.505     0.200
    19.054    38.341     0.200
    19.752    39.959     0.200
    20.091    38.111     0.200
    20.120    38.500     0.200
    20.671    38.287     0.200
     0.528     5.901     0.200
     0.522     5.714     0.200
     0.578     5.713     0.200
     0.759     5.795     0.200
     0.894     6.358     0.200
     1.003     6.140     0.200
     1.123     6.728     0.200
     1.143     7.132     0.200
     1.094     6.216     0.200
     1.170     6.957     0.200
     1.160     6.559     0.200
     1.104     6.374     0.200
     1.186     6.745     0.200
     1.275     7.032     0.200
     1.616     7.852     0.200
     1.616     8.613     0.200
     1.733     7.937     0.200
     1.793     7.578     0.200
     1.836     7.815     0.200
     1.857     7.828     0.200
     1.914     8.093     0.200
     2.275     9.132     0.200
     2.377     9.154     0.200
     2.653     8.514     0.200
     2.715     9.230     0.200
     2.880    10.194     0.200
     2.962     9.601     0.200
     3.014    10.521     0.200
     3.074    11.038     0.200
     3.161    10.282     0.200
     3.294    11.429     0.200
     3.334    10.367     0.200
     3.511    11.038     0.200
     3.578    10.817     0.200
     3.707    11.461     0.200
     3.792    12.191     0.200
     3.917    11.148     0.200
     3.956    11.315     0.200
     4.003    11.213     0.200
     4.013    11.641     0.200
     4.044    10.809     0.200
     4.122    11.910     0.200
     4.309    12.349     0.200
     4.343    11.869     0.200
     4.414    11.885     0.200
     4.416    12.694     0.200
     4.625    13.155     0.200
     4.711    12.979     0.200
     4.873    13.618     0.200
     4.911    13.848     0.200
     5.109    13.515     0.200
     4.984    14.589     0.200
     4.998    14.735     0.200
     5.197    14.665     0.200
     5.415    14.185     0.200
     5.445    14.522     0.200
     5.614    15.209     0.200
     5.528    15.577     0.200
     5.678    15.026     0.200
     5.639    15.838     0.200
     5.805    15.366     0.200
     5.738    14.778     0.200
     5.878    15.654     0.200
     6.054    15.909     0.200
     6.131    15.890     0.200
     6.427    17.417     0.200
     6.565    17.549     0.200
     6.585    18.161     0.200
     6.653    16.155     0.200
     6.865    16.801     0.200
     6.917    16.268     0.200
     6.916    17.852     0.200
     6.985    17.624     0.200
     7.118    16.846     0.200
     7.137    17.569     0.200
     7.200    17.432     0.200
     7.199    17.137     0.200
     7.227    18.115     0.200
     7.367    19.078     0.200
     7.789    19.355     0.200
     7.873    20.073     0.200
     8.210    21.509     0.200
     8.823    21.477     0.200
     8.696    20.672     0.200
     9.575    22.520     0.200
     9.581    23.249     0.200
     9.992    22.370     0.200
    10.126    25.596     0.200
    10.348    24.039     0.200
    12.107    28.720     0.200
    12.107    28.521     0.200
    13.322    29.966     0.200
    13.322    29.290     0.200
    19.289    35.344     0.200
     0.642     5.947     0.200
     0.682     5.637     0.200
     0.726     6.312     0.200
     0.733     5.860     0.200
     0.764     6.144     0.200
     0.779     6.306     0.200
     0.780     5.990     0.200
     0.833     6.063     0.200
     0.897     6.126     0.200
     1.017     6.622     0.200
     0.968     6.877     0.200
     0.976     6.407     0.200
     1.184     6.804     0.200
     1.324     7.212     0.200
     1.450     7.855     0.200
     1.478     8.153     0.200
     1.483     8.007     0.200
     1.497     7.983     0.200
     1.780     8.456     0.200
     1.889     8.351     0.200
     2.095     8.688     0.200
     2.191     8.950     0.200
     2.226     8.928     0.200
     2.395     8.712     0.200
     2.500    10.253     0.200
     2.578     9.973     0.200
     2.622     9.877     0.200
     2.654    10.075     0.200
     2.757    10.328     0.200
     2.772    10.027     0.200
     3.141     9.374     0.200
     3.188    10.109     0.200
     3.271    11.325     0.200
     3.355    11.356     0.200
     3.405    11.079     0.200
     3.446    10.482     0.200
     3.446    11.607     0.200
     3.751    12.273     0.200
     3.801    11.341     0.200
     3.867    12.261     0.200
     3.978    11.759     0.200
     4.169    12.435     0.200
     4.244    12.404     0.200
     4.382    11.928     0.200
     4.433    12.160     0.200
     4.489    11.896     0.200
     4.500    12.568     0.200
     4.587    12.705     0.200
     4.503    13.411     0.200
     4.781    13.508     0.200
     4.833    12.905     0.200
     4.845    13.862     0.200
     4.900    13.041     0.200
     5.106    13.704     0.200
     5.146    14.859     0.200
     5.067    14.620     0.200
     5.200    13.675     0.200
     5.102    14.529     0.200
     5.362    14.277     0.200
     5.264    15.004     0.200
     5.488    15.279     0.200
     5.596    14.547     0.200
     5.825    16.198     0.200
     5.841    16.498     0.200
     6.076    15.815     0.200
     6.166    15.883     0.200
     6.285    16.946     0.200
     6.309    17.272     0.200
     6.533    16.173     0.200
     6.612    17.121     0.200
     6.629    16.697     0.200
     7.044    18.282     0.200
     7.051    18.813     0.200
     7.312    17.751     0.200
     7.350    17.693     0.200
     7.548    18.535     0.200
     7.642    17.635     0.200
     7.673    18.162     0.200
     7.856    19.894     0.200
     8.114    20.332     0.200
     8.199    20.635     0.200
     8.707    23.058     0.200
     9.311    22.191     0.200
    10.042    24.295     0.200
    10.179    26.116     0.200
    12.527    29.209     0.200
    12.527    30.783     0.200
    13.795    29.933     0.200
    13.795    29.695     0.200
     0.072    10.958     0.200
     0.169    10.191     0.200
     0.244     9.542     0.200
     0.289     9.287     0.200
     0.277     9.496     0.200
     0.357     9.166     0.200
     0.387     8.814     0.200
     0.410     9.027     0.200
     0.429     9.078     0.200
     1.249     7.103     0.200
     1.467     8.895     0.200
     1.486     8.671     0.200
     2.123     9.579     0.200
     2.172     8.867     0.200
     2.176     9.711     0.200
     2.216     9.787     0.200
     2.264     8.554     0.200
     2.364     9.558     0.200
     2.605    10.788     0.200
     2.650     9.639     0.200
     2.641    10.740     0.200
     2.679    11.139     0.200
     2.782    10.509     0.200
     3.047     9.683     0.200
     3.260    11.455     0.200
     3.361    11.787     0.200
     3.388    10.978     0.200
     3.437    10.163     0.200
     3.405    11.166     0.200
     3.699    11.689     0.200
     3.887    12.708     0.200
     3.970    11.970     0.200
     3.964    12.859     0.200
     4.103    11.793     0.200
     4.160    10.682     0.200
     4.237    13.160     0.200
     4.325    12.112     0.200
     4.539    12.475     0.200
     4.628    12.238     0.200
     4.627    14.122     0.200
     4.695    13.757     0.200
     4.742    12.870     0.200
     4.753    14.337     0.200
     4.782    14.425     0.200
     4.838    12.267     0.200
     4.866    13.653     0.200
     4.871    14.844     0.200
     4.886    14.436     0.200
     4.861    14.702     0.200
     4.958    13.177     0.200
     5.034    12.731     0.200
     5.043    15.032     0.200
     5.137    14.022     0.200
     5.165    15.396     0.200
     5.268    14.003     0.200
     5.270    13.824     0.200
     5.287    13.981     0.200
     5.257    16.271     0.200
     5.321    13.738     0.200
     5.531    15.124     0.200
     5.649    14.931     0.200
     5.704    15.259     0.200
     5.750    16.289     0.200
     5.801    15.690     0.200
     5.818    15.570     0.200
     5.883    15.760     0.200
     6.157    17.620     0.200
     6.204    15.462     0.200
     6.345    15.960     0.200
     6.505    16.691     0.200
     6.554    17.499     0.200
     6.675    17.386     0.200
     6.686    17.212     0.200
     6.728    17.995     0.200
     6.948    18.745     0.200
     7.001    17.585     0.200
     7.068    16.399     0.200
     7.346    18.937     0.200
     7.313    19.195     0.200
     7.345    19.652     0.200
     7.350    19.605     0.200
     7.386    17.279     0.200
     7.448    19.352     0.200
     7.575    18.325     0.200
     7.702    16.795     0.200
     7.799    18.709     0.200
     7.933    19.850     0.200
     8.020    19.230     0.200
     8.128    20.229     0.200
     8.159    19.772     0.200
     8.218    21.722     0.200
     9.567    22.891     0.200
    10.496    25.085     0.200
    13.050    30.492     0.200
    13.462    28.843     0.200
    13.948    29.204     0.200
    13.948    30.782     0.200
     0.403     6.889     0.200
     0.632     6.078     0.200
     0.671     6.424     0.200
     0.689     6.763     0.200
     0.696     6.715     0.200
     0.710     6.615     0.200
     0.797     6.178     0.200
     0.835     6.465     0.200
     0.916     6.128     0.200
     0.971     6.184     0.200
     0.975     6.836     0.200
     0.950     6.543     0.200
     1.070     7.392     0.200
     1.193     6.474     0.200
     1.239     6.885     0.200
     1.250     7.705     0.200
     1.300     7.371     0.200
     1.325     7.193     0.200
     1.332     7.329     0.200
     1.341     7.105     0.200
     1.383     7.089     0.200
     1.384     7.052     0.200
     1.406     7.073     0.200
     1.424     7.335     0.200
     1.497     7.241     0.200
     1.592     7.573     0.200
     1.798     8.158     0.200
     1.828     8.147     0.200
     1.849     8.214     0.200
     1.890     8.406     0.200
     1.931     8.412     0.200
     2.284    10.528     0.200
     2.361     8.698     0.200
     2.370     8.110     0.200
     2.556    10.099     0.200
     2.568     8.636     0.200
     2.572     9.884     0.200
     2.597    10.241     0.200
     2.618    10.070     0.200
     2.631    10.064     0.200
     2.642    10.359     0.200
     2.697    10.078     0.200
     2.697    10.824     0.200
     2.716     9.212     0.200
     2.902    10.686     0.200
     2.908    10.937     0.200
     2.965    10.285     0.200
     3.034     9.730     0.200
     3.243    11.286     0.200
     3.397    11.380     0.200
     3.544    10.554     0.200
     3.748    11.403     0.200
     3.772    10.181     0.200
     3.796    11.386     0.200
     3.949    11.560     0.200
     3.964    10.399     0.200
     3.997    12.203     0.200
     4.071    11.292     0.200
     4.200    11.616     0.200
     4.221    11.710     0.200
     4.289    12.591     0.200
     4.467    13.553     0.200
     4.452    12.495     0.200
     4.640    13.093     0.200
     4.983    14.490     0.200
     5.006    14.086     0.200
     5.106    14.925     0.200
     5.213    15.356     0.200
     5.434    14.168     0.200
     5.461    15.285     0.200
     5.630    15.710     0.200
     5.694    16.281     0.200
     5.710    15.086     0.200
     5.785    15.452     0.200
     5.823    15.481     0.200
     5.853    17.196     0.200
     5.933    15.298     0.200
     5.953    15.813     0.200
     6.283    16.379     0.200
     6.326    18.711     0.200
     6.338    17.168     0.200
     6.463    16.580     0.200
     6.473    16.453     0.200
     6.502    16.220     0.200
     6.640    17.367     0.200
     6.700    16.622     0.200
     6.714    16.619     0.200
     6.793    16.899     0.200
     7.073    18.374     0.200
     7.137    17.354     0.200
     7.335    18.857     0.200
     7.419    19.346     0.200
     8.682    20.496     0.200
     8.865    20.596     0.200
     8.871    20.601     0.200
     9.448    22.617     0.200
     9.576    21.103     0.200
     9.748    23.463     0.200
    12.062    28.259     0.200
    12.062    27.989     0.200
    12.961    28.747     0.200
    12.961    28.083     0.200
     0.446     4.255     0.200
     0.527     4.519     0.200
     1.256     7.082     0.200
     1.288     6.779     0.200
     1.346     7.102     0.200
     1.351     7.227     0.200
     1.367     7.381     0.200
     1.368     7.339     0.200
     1.366     7.016     0.200
     1.375     7.363     0.200
     1.378     7.215     0.200
     1.388     7.444     0.200
     1.388     7.210     0.200
     1.463     7.486     0.200
     1.577     7.501     0.200
     1.635     7.298     0.200
     1.662     7.333     0.200
     1.670     7.430     0.200
     1.752     7.824     0.200
     1.873     8.451     0.200
     1.932     7.869     0.200
     1.936     7.964     0.200
     1.942     8.039     0.200
     1.942     7.855     0.200
     2.051     9.046     0.200
     2.048     8.347     0.200
     2.289     8.810     0.200
     2.312     9.079     0.200
     2.311     8.259     0.200
     2.341     9.112     0.200
     2.403     9.202     0.200
     2.412     9.060     0.200
     2.479     8.728     0.200
     2.657     9.053     0.200
     2.906    10.763     0.200
     2.979     9.535     0.200
     3.023    10.182     0.200
     3.067    10.586     0.200
     3.106    10.630     0.200
     3.109    10.422     0.200
     3.414    10.480     0.200
     3.575    11.053     0.200
     3.613    11.711     0.200
     3.894    11.522     0.200
     3.970    11.697     0.200
     4.053    12.489     0.200
     4.107    12.089     0.200
     4.309    12.954     0.200
     4.326    12.673     0.200
     5.061    15.291     0.200
     5.108    13.917     0.200
     5.128    13.786     0.200
     5.324    14.889     0.200
     5.386    15.028     0.200
     5.436    15.024     0.200
     5.467    15.501     0.200
     5.687    14.522     0.200
     5.738    15.680     0.200
     5.758    15.931     0.200
     6.051    16.546     0.200
     6.078    16.759     0.200
     6.149    16.981     0.200
     6.236    16.449     0.200
     6.256    18.220     0.200
     6.529    16.269     0.200
     6.691    17.261     0.200
     6.764    16.873     0.200
     6.870    17.956     0.200
     6.957    19.044     0.200
     6.973    17.444     0.200
     6.994    18.905     0.200
     7.006    17.734     0.200
     7.022    17.529     0.200
     7.022    17.526     0.200
     7.145    19.254     0.200
     7.843    18.899     0.200
     7.924    20.846     0.200
     8.458    20.546     0.200
     9.063    22.544     0.200
     9.088    20.540     0.200
     9.833    21.926     0.200
    11.552    29.295     0.200
    11.552    25.568     0.200
    13.035    29.808     0.200
    13.035    29.386     0.200
    18.801    37.117     0.200
     0.899     6.017     0.200
     1.111     6.328     0.200
     1.196     6.920     0.200
     1.212     6.987     0.200
     1.293     7.083     0.200
     1.396     7.305     0.200
     2.086     9.199     0.200
     2.109     9.351     0.200
     2.112     9.174     0.200
     2.113     9.327     0.200
     2.116     9.335     0.200
     2.131     9.213     0.200
     2.147     8.766     0.200
     2.488     9.423     0.200
     2.547    10.203     0.200
     2.749     9.864     0.200
     2.784    10.422     0.200
     2.827    10.309     0.200
     3.265    11.240     0.200
     3.298    11.653     0.200
     3.421    11.337     0.200
     3.793    13.525     0.200
     3.779    10.619     0.200
     3.845    10.866     0.200
     3.857    12.163     0.200
     4.030    12.646     0.200
     4.054    12.420     0.200
     4.093    11.877     0.200
     4.253    13.011     0.200
     4.390    13.075     0.200
     4.413    13.704     0.200
     4.461    12.619     0.200
     4.591    16.996     0.200
     5.043    13.752     0.200
     5.099    14.123     0.200
     5.162    13.082     0.200
     5.248    13.906     0.200
     5.315    13.322     0.200
     5.496    14.467     0.200
     5.609    14.556     0.200
     5.682    16.101     0.200
     5.758    15.083     0.200
     5.820    15.400     0.200
     5.875    16.034     0.200
     5.994    15.640     0.200
     6.195    15.700     0.200
     6.476    17.045     0.200
     6.485    17.136     0.200
     6.539    17.997     0.200
     6.626    17.978     0.200
     6.737    17.004     0.200
     6.775    17.421     0.200
     6.837    18.848     0.200
     6.856    18.168     0.200
     6.967    18.305     0.200
     7.187    18.197     0.200
     7.191    18.635     0.200
     7.282    18.043     0.200
     7.447    19.817     0.200
     7.568    20.070     0.200
     7.610    19.925     0.200
     7.728    20.048     0.200
     7.796    18.196     0.200
     7.831    20.133     0.200
     8.009    18.430     0.200
     8.118    20.410     0.200
     8.205    19.125     0.200
     8.205    18.945     0.200
     8.216    18.891     0.200
     8.161    20.080     0.200
     8.303    19.076     0.200
     8.302    18.962     0.200
     7.973    23.436     0.200
     8.712    21.586     0.200
     8.798    21.350     0.200
     9.949    23.932     0.200
    10.135    22.995     0.200
    10.305    24.736     0.200
    10.415    26.518     0.200
    10.510    26.938     0.200
    10.560    24.865     0.200
    11.082    24.129     0.200
    12.953    32.147     0.200
    12.953    31.366     0.200
    14.453    31.211     0.200
    14.453    30.976     0.200
     0.846     6.266     0.200
     0.864     6.369     0.200
     0.929     6.304     0.200
     0.938     6.286     0.200
     1.475     7.601     0.200
     1.555     7.119     0.200
     1.610     7.333     0.200
     2.342     9.269     0.200
     2.364    10.208     0.200
     2.368     9.777     0.200
     2.673    10.423     0.200
     2.924    11.253     0.200
     3.067    10.763     0.200
     3.082    11.118     0.200
     3.145    10.709     0.200
     3.513    12.231     0.200
     3.904    11.760     0.200
     4.199    11.536     0.200
     4.217    12.093     0.200
     4.272    13.513     0.200
     4.312    13.129     0.200
     4.153    13.297     0.200
     4.646    14.359     0.200
     4.819    13.495     0.200
     5.561    14.499     0.200
     5.599    14.331     0.200
     5.729    16.059     0.200
     5.804    15.532     0.200
     5.961    15.008     0.200
     6.043    15.429     0.200
     6.145    15.753     0.200
     6.421    16.460     0.200
     6.658    16.936     0.200
     6.717    17.875     0.200
     7.604    19.659     0.200
     7.669    19.002     0.200
     8.078    18.159     0.200
     8.292    18.895     0.200
     8.483    19.416     0.200
     8.601    19.796     0.200
     8.601    19.200     0.200
     8.677    20.145     0.200
     8.836    21.319     0.200
    10.366    24.564     0.200
    11.356    22.983     0.200
    13.478    32.703     0.200
    14.813    31.077     0.200
    14.813    32.582     0.200
     1.480     7.472     0.200
     2.055     8.182     0.200
     2.269     9.279     0.200
     2.897    10.607     0.200
     2.912    11.470     0.200
     3.459    12.413     0.200
     3.471    11.350     0.200
     3.671    11.459     0.200
     3.821    12.367     0.200
     4.043    12.174     0.200
     4.278    13.321     0.200
     4.587    14.756     0.200
     5.163    15.545     0.200
     5.240    15.839     0.200
     5.551    16.570     0.200
     5.578    15.879     0.200
     5.775    17.267     0.200
     5.787    16.123     0.200
     6.385    17.269     0.200
     6.782    17.733     0.200
     7.827    20.219     0.200
     8.178    20.842     0.200
     8.438    20.988     0.200
     8.747    20.379     0.200
     8.942    21.726     0.200
     9.000    24.030     0.200
     9.519    23.143     0.200
    10.570    27.045     0.200
    10.437    23.584     0.200
    10.504    24.949     0.200
    11.174    26.280     0.200
    11.253    28.815     0.200
    11.253    27.967     0.200
     1.256     7.177     0.200
     2.860    12.130     0.200
     3.059     9.108     0.200
     3.932    13.463     0.200
     4.221    12.707     0.200
     4.411    11.967     0.200
     4.771    14.745     0.200
     4.851    14.953     0.200
     5.428    14.617     0.200
     5.501    15.702     0.200
     5.499    15.050     0.200
     5.783    15.975     0.200
     5.909    16.203     0.200
     6.168    15.038     0.200
     6.197    17.015     0.200
     6.385    18.124     0.200
     6.572    18.322     0.200
     6.594    18.216     0.200
     7.055    19.297     0.200
     7.103    19.348     0.200
     7.370    19.795     0.200
     7.481    19.966     0.200
     7.461    21.498     0.200
     7.713    18.547     0.200
     7.643    19.595     0.200
     7.818    20.905     0.200
     7.914    20.802     0.200
     8.224    19.249     0.200
     8.454    21.584     0.200
     8.609    21.849     0.200
     8.717    21.438     0.200
     8.767    21.358     0.200
     9.097    25.119     0.200
     9.509    22.346     0.200
     9.482    23.361     0.200
     9.669    22.732     0.200
     9.782    24.454     0.200
    10.058    26.061     0.200
    10.077    25.902     0.200
    11.564    28.120     0.200
    11.793    27.485     0.200
    12.448    31.698     0.200
    14.729    34.379     0.200
    14.729    34.000     0.200
     0.708     6.299     0.200
     0.708     5.373     0.200
     0.824     6.522     0.200
     1.164     7.649     0.200
     1.165     7.832     0.200
     1.203     7.719     0.200
     1.205     7.627     0.200
     1.213     7.781     0.200
     1.226     7.365     0.200
     1.377     7.912     0.200
     1.381     5.944     0.200
     1.601     7.478     0.200
     1.671     8.077     0.200
     1.723     8.026     0.200
     1.720     8.011     0.200
     1.734     8.086     0.200
     1.950     7.988     0.200
     2.034     8.632     0.200
     2.075     8.864     0.200
     2.127     8.760     0.200
     2.143     8.093     0.200
     2.284     8.589     0.200
     2.310     8.561     0.200
     2.506     9.101     0.200
     2.655     9.445     0.200
     2.784     9.907     0.200
     2.905    10.441     0.200
     2.913     9.641     0.200
     2.944    10.607     0.200
     3.084    10.589     0.200
     3.116    10.310     0.200
     3.119    10.045     0.200
     3.224    10.511     0.200
     3.494    10.560     0.200
     3.575    11.032     0.200
     3.574    10.781     0.200
     3.626    11.755     0.200
     3.661    10.592     0.200
     3.848    11.577     0.200
     3.865    11.537     0.200
     3.958    12.002     0.200
     4.059    10.875     0.200
     4.149    12.618     0.200
     4.167    12.471     0.200
     4.199    12.994     0.200
     4.347    13.056     0.200
     4.452    14.272     0.200
     4.487    12.872     0.200
     4.468    13.647     0.200
     4.512    13.300     0.200
     4.546    13.090     0.200
     4.602    12.247     0.200
     4.692    13.410     0.200
     4.832    13.751     0.200
     4.903    13.468     0.200
     4.923    13.387     0.200
     4.919    13.929     0.200
     5.114    14.247     0.200
     5.105    14.201     0.200
     5.194    14.453     0.200
     5.232    14.084     0.200
     5.261    14.899     0.200
     5.397    15.196     0.200
     5.478    15.408     0.200
     5.532    14.681     0.200
     5.556    15.409     0.200
     5.561    14.564     0.200
     5.582    15.198     0.200
     6.093    16.230     0.200
     6.487    17.839     0.200
     6.511    17.330     0.200
     6.639    17.286     0.200
     6.769    16.351     0.200
     6.822    17.079     0.200
     8.203    20.070     0.200
     8.304    20.694     0.200
     8.699    21.924     0.200
     8.764    21.103     0.200
     8.874    19.796     0.200
     9.041    19.831     0.200
     9.283    20.776     0.200
    10.316    26.195     0.200
    10.738    21.946     0.200
    10.799    23.928     0.200
    10.895    26.818     0.200
    11.526    28.061     0.200
    11.526    27.526     0.200
    12.160    25.329     0.200
    12.160    25.328     0.200
    12.858    29.088     0.200
    12.858    28.288     0.200
    14.935    32.798     0.200
    18.708    35.664     0.200
    19.920    36.202     0.200
    20.097    35.882     0.200
    20.274    36.119     0.200
    20.494    36.037     0.200
     0.760     5.255     0.200
     0.904     5.913     0.200
     0.934     5.613     0.200
     0.950     5.961     0.200
     1.098     6.505     0.200
     1.128     6.339     0.200
     1.200     6.798     0.200
     1.471     7.206     0.200
     1.473     7.248     0.200
     2.051     9.088     0.200
     2.056     9.445     0.200
     2.058     9.277     0.200
     2.027     8.030     0.200
     2.040     8.572     0.200
     2.067     8.300     0.200
     2.359     9.832     0.200
     2.391     8.048     0.200
     2.727     9.842     0.200
     2.763    10.490     0.200
     2.775    10.737     0.200
     2.798    10.536     0.200
     2.804    10.545     0.200
     2.965     8.702     0.200
     3.047     9.895     0.200
     3.253    11.826     0.200
     3.276    11.701     0.200
     3.339    11.739     0.200
     3.740    11.758     0.200
     3.969    12.811     0.200
     3.884    11.346     0.200
     3.999    12.639     0.200
     4.026    13.190     0.200
     4.078    11.749     0.200
     4.109    12.891     0.200
     4.334    13.305     0.200
     4.390    13.281     0.200
     4.446    12.823     0.200
     4.512    13.386     0.200
     4.506    13.143     0.200
     4.553    12.967     0.200
     4.658    13.484     0.200
     4.772    12.613     0.200
     4.838    13.758     0.200
     4.848    13.210     0.200
     4.884    13.052     0.200
     5.026    13.354     0.200
     4.950    12.887     0.200
     5.084    13.408     0.200
     5.428    14.160     0.200
     5.567    15.537     0.200
     5.539    14.070     0.200
     5.635    15.722     0.200
     5.633    14.514     0.200
     5.574    14.614     0.200
     5.758    15.216     0.200
     6.014    15.653     0.200
     6.188    15.501     0.200
     6.237    15.585     0.200
     6.371    15.997     0.200
     6.505    15.990     0.200
     6.598    16.533     0.200
     6.647    16.434     0.200
     6.715    16.950     0.200
     6.772    16.470     0.200
     6.851    16.912     0.200
     6.933    17.399     0.200
     7.075    17.645     0.200
     7.150    17.948     0.200
     7.191    17.812     0.200
     7.451    19.172     0.200
     7.483    18.804     0.200
     7.558    18.771     0.200
     7.578    18.818     0.200
     7.670    18.653     0.200
     7.752    18.317     0.200
     7.737    19.782     0.200
     7.965    18.413     0.200
     7.883    18.316     0.200
     8.160    18.784     0.200
     8.167    18.971     0.200
     8.265    19.353     0.200
     8.265    18.957     0.200
     8.509    20.863     0.200
     8.618    21.489     0.200
     9.408    21.816     0.200
     9.815    23.627     0.200
    10.284    24.003     0.200
    10.355    26.797     0.200
    10.550    25.252     0.200
    13.058    31.272     0.200
    13.058    30.497     0.200
    14.442    33.384     0.200
    14.442    30.824     0.200
     1.641     8.174     0.200
     1.689     8.345     0.200
     1.791     9.102     0.200
     1.812     8.719     0.200
     1.842     8.866     0.200
     1.840     9.251     0.200
     2.108     9.167     0.200
     2.436    10.048     0.200
     2.497    10.255     0.200
     2.494    10.404     0.200
     2.734    12.100     0.200
     2.741    11.845     0.200
     2.749    11.885     0.200
     3.032    12.420     0.200
     3.473    12.153     0.200
     3.866    13.966     0.200
     4.000    14.070     0.200
     4.137    12.660     0.200
     4.507    14.911     0.200
     4.573    14.855     0.200
     4.626    15.066     0.200
     4.636    15.296     0.200
     4.688    15.300     0.200
     4.917    14.619     0.200
     4.969    15.946     0.200
     5.499    14.723     0.200
     5.720    15.861     0.200
     5.873    17.555     0.200
     5.910    16.720     0.200
     6.100    16.586     0.200
     6.137    17.280     0.200
     6.324    19.722     0.200
     6.421    17.693     0.200
     6.392    18.799     0.200
     7.044    19.659     0.200
     7.501    21.575     0.200
     7.585    20.382     0.200
     8.512    24.991     0.200
    10.200    26.586     0.200
    14.861    34.408     0.200
    20.403    38.408     0.200
     0.298     4.166     0.200
     0.298     4.865     0.200
     0.513     4.351     0.200
     1.061     5.461     0.200
     1.116     5.835     0.200
     1.105     5.767     0.200
     1.176     6.054     0.200
     1.210     6.580     0.200
     1.269     6.631     0.200
     1.560     6.962     0.200
     1.658     8.094     0.200
     1.666     8.237     0.200
     1.932     8.579     0.200
     2.087     9.025     0.200
     2.298     9.386     0.200
     2.751    10.229     0.200
     2.883    10.195     0.200
     2.854     9.665     0.200
     2.859    10.580     0.200
     2.947     9.832     0.200
     3.054     9.182     0.200
     3.167     9.891     0.200
     3.223     9.840     0.200
     3.504    11.289     0.200
     3.509    11.219     0.200
     3.568    11.935     0.200
     3.605    11.248     0.200
     3.631    12.412     0.200
     3.841    12.436     0.200
     3.943    11.051     0.200
     4.375    11.781     0.200
     4.739    12.635     0.200
     4.757    13.780     0.200
     4.713    12.821     0.200
     4.868    13.213     0.200
     5.074    13.724     0.200
     5.208    14.718     0.200
     5.391    14.933     0.200
     5.911    15.196     0.200
     6.052    15.835     0.200
     6.074    15.619     0.200
     6.160    16.744     0.200
     6.366    16.859     0.200
     6.375    16.579     0.200
     6.430    16.547     0.200
     6.487    16.910     0.200
     6.741    17.585     0.200
     6.831    18.160     0.200
     7.005    18.492     0.200
     7.192    17.346     0.200
     7.402    17.409     0.200
     7.416    21.328     0.200
     7.415    18.385     0.200
     7.605    17.894     0.200
     7.679    18.388     0.200
     7.753    19.969     0.200
     8.292    20.528     0.200
     8.578    21.518     0.200
     9.111    22.614     0.200
     9.215    22.535     0.200
     9.453    22.855     0.200
     9.631    22.049     0.200
     9.806    23.596     0.200
    12.234    28.823     0.200
    13.761    30.205     0.200
     0.074    18.542     0.200
     0.315    16.069     0.200
     0.346    16.092     0.200
     0.377    15.955     0.200
     0.670    14.160     0.200
     0.690    13.975     0.200
     0.774    13.434     0.200
     1.132    12.685     0.200
     1.136    12.907     0.200
     1.139    12.865     0.200
     1.151    12.841     0.200
     1.158    12.874     0.200
     1.418    12.386     0.200
     1.606    10.751     0.200
     1.733    10.528     0.200
     1.761    12.057     0.200
     1.829    12.239     0.200
     2.197    12.117     0.200
     2.234    12.065     0.200
     2.324    12.088     0.200
     2.347    12.316     0.200
     2.408    11.554     0.200
     2.465    11.190     0.200
     2.476    12.028     0.200
     2.930    12.703     0.200
     2.934    11.322     0.200
     2.975    13.070     0.200
     2.989    12.392     0.200
     3.265    12.010     0.200
     3.255    13.136     0.200
     3.315    13.598     0.200
     3.351    12.851     0.200
     3.454    13.419     0.200
     3.512    12.576     0.200
     3.592    13.041     0.200
     3.672    12.645     0.200
     3.804    13.469     0.200
     4.222    12.154     0.200
     4.304    14.319     0.200
     4.401    12.731     0.200
     4.480    13.667     0.200
     4.512    15.131     0.200
     4.619    14.067     0.200
     4.652    12.867     0.200
     5.094    15.139     0.200
     5.145    14.688     0.200
     5.275    15.365     0.200
     5.341    15.264     0.200
     5.373    14.714     0.200
     5.370    14.790     0.200
     5.434    14.951     0.200
     5.436    16.123     0.200
     5.613    15.767     0.200
     5.849    14.990     0.200
     5.926    15.529     0.200
     5.920    16.877     0.200
     6.212    17.164     0.200
     6.425    17.678     0.200
     6.622    16.046     0.200
     6.672    17.293     0.200
     6.744    16.364     0.200
     6.750    15.673     0.200
     6.849    17.669     0.200
     6.884    17.946     0.200
     6.964    16.045     0.200
     6.986    16.570     0.200
     7.057    18.529     0.200
     7.097    18.522     0.200
     7.134    16.327     0.200
     7.145    16.407     0.200
     7.213    18.890     0.200
     7.293    16.483     0.200
     7.293    16.479     0.200
     7.343    17.887     0.200
     7.401    18.627     0.200
     7.488    19.504     0.200
     7.884    19.992     0.200
     7.935    19.583     0.200
     7.937    19.262     0.200
     8.162    20.408     0.200
     8.907    19.357     0.200
     9.040    19.681     0.200
    13.100    29.103     0.200
     0.523     6.631     0.200
     0.713     6.874     0.200
     0.761     7.010     0.200
     0.760     6.674     0.200
     0.937     6.621     0.200
     1.033     7.276     0.200
     0.958     6.482     0.200
     0.987     6.423     0.200
     1.077     7.416     0.200
     1.179     7.072     0.200
     1.344     7.400     0.200
     1.268     7.013     0.200
     1.359     8.136     0.200
     1.417     7.734     0.200
     1.407     7.058     0.200
     1.707     7.630     0.200
     1.887     8.679     0.200
     1.955     8.718     0.200
     2.002     8.685     0.200
     2.013     8.547     0.200
     2.470     9.193     0.200
     2.487     8.428     0.200
     2.630    10.132     0.200
     2.647    10.081     0.200
     2.689    10.378     0.200
     2.691    10.408     0.200
     2.724     9.736     0.200
     2.982    10.911     0.200
     3.134    11.180     0.200
     3.137    10.114     0.200
     3.386    10.356     0.200
     3.486    11.388     0.200
     3.649    10.813     0.200
     3.593    11.641     0.200
     3.712    10.813     0.200
     3.889    10.619     0.200
     3.961    13.213     0.200
     4.083    10.806     0.200
     4.319    11.916     0.200
     4.324    13.946     0.200
     4.338    12.193     0.200
     4.491    13.500     0.200
     4.570    12.848     0.200
     4.704    13.075     0.200
     4.760    12.674     0.200
     4.799    13.353     0.200
     4.850    14.044     0.200
     5.003    13.175     0.200
     5.056    14.208     0.200
     5.083    15.205     0.200
     5.110    14.278     0.200
     5.095    14.205     0.200
     5.271    14.453     0.200
     5.300    15.247     0.200
     5.335    14.470     0.200
     5.380    14.884     0.200
     5.454    14.539     0.200
     5.546    15.147     0.200
     5.551    15.350     0.200
     5.553    14.613     0.200
     5.611    15.620     0.200
     5.620    14.717     0.200
     5.694    16.329     0.200
     5.809    15.749     0.200
     5.819    15.363     0.200
     5.870    16.132     0.200
     5.872    15.277     0.200
     5.930    15.957     0.200
     6.011    15.631     0.200
     6.023    16.275     0.200
     6.048    16.015     0.200
     6.052    15.688     0.200
     6.242    15.237     0.200
     6.310    16.120     0.200
     6.314    17.484     0.200
     6.380    16.273     0.200
     6.377    16.623     0.200
     6.396    17.438     0.200
     6.471    17.381     0.200
     6.546    17.214     0.200
     6.559    16.907     0.200
     6.592    16.515     0.200
     6.790    16.894     0.200
     6.700    19.029     0.200
     6.801    16.975     0.200
     6.887    17.131     0.200
     6.887    16.674     0.200
     6.978    18.094     0.200
     7.006    17.673     0.200
     7.188    18.093     0.200
     7.380    19.312     0.200
     7.389    19.231     0.200
     7.474    19.603     0.200
     8.304    20.295     0.200
     8.451    20.346     0.200
     8.633    20.997     0.200
     8.753    20.928     0.200
     8.745    21.310     0.200
     9.325    23.049     0.200
     9.566    22.721     0.200
     9.666    22.810     0.200
     9.752    23.178     0.200
    12.175    27.897     0.200
    12.175    28.749     0.200
    13.067    28.721     0.200
    20.639    35.576     0.200
     1.249     7.966     0.200
     1.249     6.966     0.200
     2.049     9.212     0.200
     2.209     9.484     0.200
     2.262     9.918     0.200
     2.268    10.328     0.200
     2.352    10.240     0.200
     2.481    10.739     0.200
     2.529     9.642     0.200
     2.550    10.134     0.200
     2.812    11.934     0.200
     2.866    12.190     0.200
     2.887    12.826     0.200
     3.142    12.831     0.200
     3.171    12.729     0.200
     3.362    11.645     0.200
     3.661    11.373     0.200
     3.937    13.379     0.200
     3.945    12.465     0.200
     3.989    14.154     0.200
     4.040    13.972     0.200
     4.067    13.996     0.200
     4.173    13.433     0.200
     4.278    15.490     0.200
     4.418    13.581     0.200
     4.583    12.294     0.200
     4.667    15.410     0.200
     4.676    15.414     0.200
     4.738    15.760     0.200
     4.742    15.558     0.200
     4.795    16.229     0.200
     4.828    15.360     0.200
     4.803    14.692     0.200
     4.811    15.595     0.200
     4.872    14.397     0.200
     5.034    15.397     0.200
     5.336    13.600     0.200
     5.216    14.920     0.200
     5.377    15.289     0.200
     5.391    15.203     0.200
     5.488    16.505     0.200
     5.611    14.175     0.200
     5.501    15.548     0.200
     5.551    16.293     0.200
     5.675    16.153     0.200
     5.781    16.276     0.200
     5.812    16.217     0.200
     5.962    17.157     0.200
     6.049    16.964     0.200
     6.087    16.802     0.200
     6.340    15.615     0.200
     6.275    16.984     0.200
     6.384    18.751     0.200
     6.388    17.905     0.200
     6.618    18.807     0.200
     6.568    18.412     0.200
     6.754    16.120     0.200
     6.677    18.178     0.200
     6.693    18.216     0.200
     6.738    18.947     0.200
     6.910    19.492     0.200
     6.909    18.905     0.200
     6.920    19.094     0.200
     6.937    18.897     0.200
     7.113    16.877     0.200
     7.001    19.440     0.200
     6.980    18.978     0.200
     7.033    20.428     0.200
     7.008    19.237     0.200
     7.023    19.395     0.200
     7.068    19.357     0.200
     7.089    19.920     0.200
     7.051    19.114     0.200
     7.142    19.688     0.200
     7.268    19.764     0.200
     7.371    20.663     0.200
     7.387    20.135     0.200
     7.446    20.343     0.200
     7.827    20.952     0.200
     8.264    21.251     0.200
     8.305    22.977     0.200
     8.373    21.705     0.200
     8.497    22.354     0.200
     8.469    21.392     0.200
     8.571    21.583     0.200
     8.597    22.906     0.200
     8.680    21.543     0.200
     8.680    22.213     0.200
     8.714    22.270     0.200
     8.721    21.861     0.200
     8.721    21.664     0.200
     8.721    22.444     0.200
     8.955    22.892     0.200
     9.488    23.918     0.200
     9.496    23.625     0.200
     9.684    23.684     0.200
     9.975    25.489     0.200
     9.979    24.867     0.200
    10.788    26.055     0.200
    11.664    30.114     0.200
    11.921    29.815     0.200
    12.282    32.453     0.200
    12.282    32.012     0.200
    14.649    34.289     0.200
    14.649    34.464     0.200
    14.803    34.787     0.200
    19.272    40.017     0.200
    19.798    40.060     0.200
    19.818    39.564     0.200
     2.288    10.952     0.200
     2.299    10.786     0.200
     2.356    11.273     0.200
     2.570    11.557     0.200
     2.641    11.459     0.200
     2.898    12.664     0.200
     2.946    13.280     0.200
     2.950    12.930     0.200
     3.220    13.557     0.200
     3.236    13.102     0.200
     3.419    12.293     0.200
     3.621    14.097     0.200
     3.712    12.405     0.200
     4.012    14.400     0.200
     3.991    13.213     0.200
     4.063    15.165     0.200
     4.115    14.881     0.200
     4.141    15.020     0.200
     4.229    14.011     0.200
     4.621    13.927     0.200
     4.747    15.986     0.200
     4.810    16.206     0.200
     4.814    16.316     0.200
     4.857    16.587     0.200
     4.913    16.326     0.200
     4.916    15.224     0.200
     5.062    16.663     0.200
     5.050    15.214     0.200
     5.097    15.752     0.200
     5.251    16.170     0.200
     5.430    17.491     0.200
     5.415    16.270     0.200
     5.556    17.140     0.200
     5.800    17.622     0.200
     5.842    17.222     0.200
     6.007    18.265     0.200
     6.110    17.557     0.200
     6.164    19.067     0.200
     6.455    19.324     0.200
     6.575    19.134     0.200
     6.697    19.074     0.200
     6.716    19.349     0.200
     6.922    20.037     0.200
     6.994    20.346     0.200
     7.097    20.291     0.200
     7.156    20.474     0.200
     7.429    20.568     0.200
     7.506    20.072     0.200
     8.739    23.185     0.200
     8.739    22.747     0.200
     8.776    22.547     0.200
     9.563    24.311     0.200
    10.856    26.686     0.200
    11.755    30.210     0.200
    12.254    32.439     0.200
    14.687    35.168     0.200
    14.687    35.765     0.200
     0.287     5.412     0.200
     0.686     4.321     0.200
     1.486     5.708     0.200
     1.527     7.342     0.200
     1.577     7.161     0.200
     1.684     7.434     0.200
     1.723     8.084     0.200
     1.831     7.963     0.200
     1.832     7.901     0.200
     1.899     8.660     0.200
     1.904     8.668     0.200
     1.963     8.039     0.200
     2.070     8.203     0.200
     2.106     8.800     0.200
     2.147     9.198     0.200
     2.187     8.167     0.200
     2.235     8.093     0.200
     2.297     8.148     0.200
     2.535     9.378     0.200
     2.909     8.777     0.200
     2.957    10.303     0.200
     3.015    10.185     0.200
     3.032    10.733     0.200
     3.111     9.657     0.200
     3.593    10.343     0.200
     3.629    11.495     0.200
     3.697    11.903     0.200
     3.741    11.100     0.200
     3.742    11.871     0.200
     3.844    11.013     0.200
     3.936    12.409     0.200
     3.929    11.526     0.200
     3.967    11.369     0.200
     4.051    12.028     0.200
     4.085    11.463     0.200
     4.225    11.206     0.200
     4.318    11.606     0.200
     4.469    12.048     0.200
     4.517    12.485     0.200
     4.652    13.381     0.200
     4.660    12.949     0.200
     4.848    13.427     0.200
     4.892    13.895     0.200
     4.929    13.989     0.200
     5.102    14.500     0.200
     5.171    13.841     0.200
     5.335    13.592     0.200
     5.671    14.582     0.200
     5.767    15.001     0.200
     5.995    16.431     0.200
     5.967    15.970     0.200
     6.027    15.587     0.200
     6.076    15.873     0.200
     6.274    16.945     0.200
     6.359    16.922     0.200
     6.379    16.496     0.200
     6.831    17.204     0.200
     6.820    15.237     0.200
     7.197    17.385     0.200
     7.613    18.008     0.200
     7.658    18.321     0.200
     8.213    20.679     0.200
     8.459    20.316     0.200
     8.965    22.008     0.200
     9.029    22.435     0.200
     9.013    22.248     0.200
     9.728    22.518     0.200
    11.785    27.984     0.200
    13.632    30.558     0.200
    13.632    30.855     0.200
    19.206    36.085     0.200
     0.406     9.425     0.200
     0.626     9.293     0.200
     0.649     9.355     0.200
     0.677     9.522     0.200
     0.677     9.544     0.200
     0.696     9.522     0.200
     0.740     8.500     0.200
     0.868     8.187     0.200
     0.918     7.699     0.200
     0.946     8.261     0.200
     0.950     8.233     0.200
     0.984     8.590     0.200
     0.980     9.173     0.200
     1.058     6.997     0.200
     1.058     6.896     0.200
     1.140     8.737     0.200
     1.154     8.154     0.200
     1.391     8.982     0.200
     1.394     9.071     0.200
     1.588     8.612     0.200
     1.738     9.065     0.200
     1.758     8.401     0.200
     1.811     9.093     0.200
     1.825     9.444     0.200
     1.841     8.711     0.200
     1.874     9.549     0.200
     1.904     9.578     0.200
     1.960     9.523     0.200
     2.163     7.911     0.200
     2.500     9.566     0.200
     2.589    10.504     0.200
     2.611    10.505     0.200
     2.614    10.318     0.200
     2.647    10.671     0.200
     2.648    10.746     0.200
     2.741    10.652     0.200
     2.949    10.953     0.200
     3.019    11.414     0.200
     3.125    11.130     0.200
     3.175    10.754     0.200
     3.433    10.899     0.200
     3.454    11.389     0.200
     3.818    11.391     0.200
     4.247    12.732     0.200
     4.358    13.037     0.200
     4.397    12.560     0.200
     4.397    12.960     0.200
     4.630    13.255     0.200
     4.633    13.549     0.200
     4.799    14.329     0.200
     4.846    13.639     0.200
     4.881    13.943     0.200
     5.076    13.843     0.200
     5.258    14.177     0.200
     5.267    14.121     0.200
     5.343    14.606     0.200
     5.533    15.168     0.200
     5.576    15.629     0.200
     5.585    15.580     0.200
     5.623    15.790     0.200
     5.620    15.087     0.200
     5.756    15.662     0.200
     5.845    15.430     0.200
     5.924    15.554     0.200
     6.049    15.561     0.200
     6.075    16.562     0.200
     6.271    16.947     0.200
     6.324    17.513     0.200
     6.363    15.556     0.200
     6.435    16.081     0.200
     6.502    15.639     0.200
     6.522    17.481     0.200
     6.552    16.472     0.200
     6.576    15.810     0.200
     6.695    16.620     0.200
     6.770    16.031     0.200
     6.770    16.512     0.200
     6.778    16.599     0.200
     6.877    16.116     0.200
     6.877    16.092     0.200
     6.915    16.398     0.200
     6.961    16.853     0.200
     6.997    18.411     0.200
     6.998    17.823     0.200
     7.309    18.173     0.200
     8.148    20.889     0.200
     8.396    21.600     0.200
     8.476    19.666     0.200
     8.665    20.516     0.200
     8.703    19.893     0.200
     9.434    22.891     0.200
     9.595    25.131     0.200
     9.866    20.712     0.200
    10.085    25.690     0.200
    11.584    23.220     0.200
    11.626    25.712     0.200
    12.290    29.219     0.200
    13.081    27.837     0.200
    13.081    28.313     0.200
     0.556     5.945     0.200
     0.661     6.674     0.200
     0.688     6.932     0.200
     0.691     6.920     0.200
     0.709     7.384     0.200
     0.741     6.758     0.200
     0.894     6.027     0.200
     0.977     7.040     0.200
     0.975     6.560     0.200
     1.003     6.745     0.200
     1.038     5.933     0.200
     1.084     6.739     0.200
     1.090     6.437     0.200
     1.203     7.077     0.200
     1.300     7.697     0.200
     1.304     6.568     0.200
     1.387     7.200     0.200
     1.461     7.079     0.200
     1.649     7.336     0.200
     1.727     8.191     0.200
     1.810     8.084     0.200
     1.860     8.405     0.200
     1.897     8.579     0.200
     1.861     8.752     0.200
     1.944     8.420     0.200
     1.933     8.850     0.200
     2.178     8.360     0.200
     2.410     8.795     0.200
     2.432     8.011     0.200
     2.571    10.008     0.200
     2.630    10.225     0.200
     2.632    10.383     0.200
     2.685     9.876     0.200
     2.715    10.535     0.200
     2.922    10.802     0.200
     2.948    10.978     0.200
     3.010    10.411     0.200
     3.073    11.066     0.200
     3.328     9.964     0.200
     3.426    10.936     0.200
     3.588    10.758     0.200
     3.649    10.790     0.200
     3.834    10.022     0.200
     4.132    11.446     0.200
     4.268    11.647     0.200
     4.267    13.429     0.200
     4.283    12.155     0.200
     4.341    12.636     0.200
     4.446    13.602     0.200
     4.499    12.260     0.200
     4.515    12.539     0.200
     4.711    13.002     0.200
     4.749    12.987     0.200
     4.793    15.065     0.200
     4.951    12.849     0.200
     4.952    13.602     0.200
     5.006    14.825     0.200
     5.024    14.381     0.200
     5.165    14.844     0.200
     5.210    14.216     0.200
     5.274    14.594     0.200
     5.487    15.138     0.200
     5.490    14.943     0.200
     5.759    15.338     0.200
     6.319    15.456     0.200
     6.321    17.231     0.200
     6.337    16.738     0.200
     6.379    16.482     0.200
     6.488    16.919     0.200
     6.498    16.535     0.200
     6.532    16.179     0.200
     6.641    16.596     0.200
     6.689    17.202     0.200
     6.729    16.577     0.200
     6.741    16.698     0.200
     6.826    16.462     0.200
     6.826    16.779     0.200
     6.917    17.001     0.200
     7.326    18.865     0.200
     8.391    20.630     0.200
     8.575    20.608     0.200
     8.695    20.514     0.200
     9.702    25.271     0.200
    10.216    25.322     0.200
    12.139    28.354     0.200
    13.006    28.415     0.200
     0.971     6.587     0.200
     1.667     9.006     0.200
     1.858     9.431     0.200
     2.077    10.125     0.200
     2.881    11.967     0.200
     3.115    11.845     0.200
     3.137    11.459     0.200
     3.531    13.484     0.200
     3.552    13.256     0.200
     3.582    13.929     0.200
     3.621    13.755     0.200
     3.665    13.794     0.200
     3.952    13.091     0.200
     4.201    12.634     0.200
     4.289    15.395     0.200
     4.299    14.946     0.200
     4.350    15.612     0.200
     4.352    15.656     0.200
     4.580    13.947     0.200
     4.631    15.741     0.200
     4.736    14.819     0.200
     4.747    14.106     0.200
     4.923    14.515     0.200
     4.959    14.737     0.200
     5.209    15.284     0.200
     5.162    14.673     0.200
     5.154    14.636     0.200
     5.241    14.751     0.200
     5.419    15.330     0.200
     5.448    16.121     0.200
     5.594    15.825     0.200
     5.604    15.764     0.200
     5.758    15.552     0.200
     5.788    16.407     0.200
     5.822    16.770     0.200
     5.844    16.351     0.200
     5.990    18.233     0.200
     5.992    17.000     0.200
     6.089    18.859     0.200
     6.121    16.585     0.200
     6.516    20.027     0.200
     6.720    18.648     0.200
     6.705    19.124     0.200
     6.736    19.527     0.200
     6.714    18.338     0.200
     6.870    19.141     0.200
     6.911    18.756     0.200
     7.162    19.135     0.200
     7.255    19.651     0.200
     7.503    20.328     0.200
     7.988    21.087     0.200
     8.206    21.294     0.200
     8.198    21.320     0.200
     8.183    22.820     0.200
     8.401    20.872     0.200
     8.401    21.239     0.200
     8.423    21.447     0.200
     8.473    21.639     0.200
     8.473    21.584     0.200
     8.473    21.636     0.200
     8.461    20.871     0.200
     8.481    21.295     0.200
     9.042    22.835     0.200
     9.051    23.013     0.200
     9.872    25.352     0.200
     9.947    25.257     0.200
    10.416    25.509     0.200
    11.023    29.810     0.200
    11.252    29.866     0.200
    12.647    32.727     0.200
    12.647    33.087     0.200
    14.364    31.681     0.200
    14.531    34.237     0.200
    15.457    38.823     0.200
    16.786    36.152     0.200
     1.184     6.780     0.200
     1.433     8.272     0.200
     1.426     7.672     0.200
     1.481     8.169     0.200
     1.444     7.557     0.200
     1.484     7.759     0.200
     1.497     7.690     0.200
     1.549     8.392     0.200
     1.662     7.890     0.200
     1.609     8.095     0.200
     1.857     8.680     0.200
     1.847     8.528     0.200
     2.003     8.345     0.200
     2.219     9.367     0.200
     2.250     9.232     0.200
     2.271     9.940     0.200
     2.342     8.664     0.200
     2.330     9.746     0.200
     2.345     9.738     0.200
     2.362     9.728     0.200
     2.478     9.461     0.200
     2.941    11.007     0.200
     3.005    11.365     0.200
     3.009    11.576     0.200
     3.055    11.531     0.200
     3.095    11.438     0.200
     3.107    10.671     0.200
     3.251    11.500     0.200
     3.278    10.930     0.200
     3.298    11.135     0.200
     3.304    10.893     0.200
     3.689    11.365     0.200
     3.710    11.303     0.200
     3.745    12.279     0.200
     3.880    12.061     0.200
     4.007    12.319     0.200
     4.037    12.417     0.200
     4.155    13.020     0.200
     4.244    13.255     0.200
     4.348    13.486     0.200
     4.362    13.224     0.200
     4.426    13.417     0.200
     4.491    14.027     0.200
     4.545    13.806     0.200
     4.648    14.424     0.200
     4.736    13.783     0.200
     5.013    14.401     0.200
     5.107    15.655     0.200
     5.292    15.277     0.200
     5.315    14.806     0.200
     5.346    15.297     0.200
     5.389    15.613     0.200
     5.419    15.330     0.200
     5.448    15.860     0.200
     5.380    14.953     0.200
     5.718    16.193     0.200
     5.780    16.417     0.200
     6.078    16.344     0.200
     6.292    18.097     0.200
     6.348    17.789     0.200
     6.540    16.893     0.200
     6.670    17.582     0.200
     6.709    20.345     0.200
     6.748    17.337     0.200
     6.815    18.330     0.200
     6.828    17.446     0.200
     6.868    17.842     0.200
     6.955    17.856     0.200
     6.984    18.273     0.200
     7.012    18.168     0.200
     7.012    18.219     0.200
     7.013    18.216     0.200
     7.040    17.840     0.200
     7.779    19.875     0.200
     8.402    21.282     0.200
     9.045    21.383     0.200
     9.819    22.098     0.200
    10.369    27.873     0.200
    11.667    30.022     0.200
    11.667    28.936     0.200
    18.887    37.841     0.200
     0.486     7.939     0.200
     0.623     8.519     0.200
     0.658     7.627     0.200
     0.667     7.930     0.200
     0.773     7.555     0.200
     0.781     7.741     0.200
     0.829     7.682     0.200
     0.933     6.703     0.200
     0.905     7.408     0.200
     0.929     7.404     0.200
     0.972     7.553     0.200
     1.205     7.045     0.200
     1.557     8.272     0.200
     1.838     9.015     0.200
     1.861     9.314     0.200
     1.864     9.470     0.200
     2.170     9.737     0.200
     2.165     9.289     0.200
     2.391     9.106     0.200
     2.484    10.196     0.200
     2.567    10.335     0.200
     2.947     9.968     0.200
     3.012    11.120     0.200
     3.021    11.317     0.200
     3.059    11.597     0.200
     3.075    11.524     0.200
     3.145    11.572     0.200
     3.477    11.595     0.200
     3.604    13.332     0.200
     3.714    10.681     0.200
     3.717    11.413     0.200
     3.773    12.712     0.200
     3.826    12.771     0.200
     3.827    13.060     0.200
     3.827    12.910     0.200
     3.895    12.012     0.200
     4.145    13.271     0.200
     4.247    13.503     0.200
     4.315    12.769     0.200
     4.347    13.269     0.200
     4.382    12.281     0.200
     4.646    13.857     0.200
     4.785    12.543     0.200
     4.833    14.081     0.200
     4.891    12.976     0.200
     5.113    12.836     0.200
     5.305    15.754     0.200
     5.413    13.852     0.200
     5.421    16.260     0.200
     5.501    14.571     0.200
     5.562    14.416     0.200
     5.647    15.040     0.200
     5.911    15.721     0.200
     5.936    15.369     0.200
     5.967    15.937     0.200
     5.940    16.179     0.200
     6.183    16.285     0.200
     6.195    15.678     0.200
     6.221    15.740     0.200
     6.229    15.832     0.200
     6.361    16.043     0.200
     6.476    15.968     0.200
     6.502    16.975     0.200
     6.571    16.461     0.200
     6.590    16.210     0.200
     6.745    17.105     0.200
     6.775    17.351     0.200
     6.790    17.800     0.200
     6.811    17.045     0.200
     6.868    17.739     0.200
     6.932    17.524     0.200
     7.067    18.137     0.200
     7.067    17.427     0.200
     7.066    17.824     0.200
     7.127    18.652     0.200
     7.148    18.591     0.200
     7.171    18.086     0.200
     7.226    18.425     0.200
     7.302    18.655     0.200
     7.382    18.943     0.200
     7.448    19.466     0.200
     7.502    19.487     0.200
     7.538    19.134     0.200
     7.552    20.110     0.200
     7.583    19.604     0.200
     7.574    17.349     0.200
     7.681    20.086     0.200
     7.616    18.396     0.200
     7.656    17.719     0.200
     7.788    17.635     0.200
     7.917    18.141     0.200
     7.979    18.056     0.200
     7.981    18.321     0.200
     7.996    19.501     0.200
     8.096    18.412     0.200
     8.095    17.786     0.200
     8.095    18.236     0.200
     8.251    19.452     0.200
     8.366    20.280     0.200
     8.376    20.763     0.200
     8.345    21.557     0.200
     8.426    21.031     0.200
     9.698    22.120     0.200
     9.841    21.630     0.200
     9.875    23.341     0.200
    13.132    30.509     0.200
    14.308    29.405     0.200
     0.310    10.598     0.200
     0.364    10.346     0.200
     0.518     9.282     0.200
     0.600     9.099     0.200
     0.634     9.401     0.200
     0.661     8.989     0.200
     0.654     8.833     0.200
     0.698     9.351     0.200
     0.769     8.869     0.200
     0.830     8.548     0.200
     1.079     8.806     0.200
     1.105     8.608     0.200
     1.224     9.024     0.200
     1.367     7.702     0.200
     1.457     7.951     0.200
     1.507     8.879     0.200
     1.525     8.337     0.200
     1.547     8.521     0.200
     1.735     9.270     0.200
     1.687     8.316     0.200
     1.981     8.348     0.200
     2.103    10.104     0.200
     2.119    10.234     0.200
     2.122    10.338     0.200
     2.139    10.233     0.200
     2.321    10.120     0.200
     2.423    10.657     0.200
     2.352    10.418     0.200
     2.378    10.035     0.200
     2.479    10.138     0.200
     2.561    10.177     0.200
     2.572    10.145     0.200
     2.789    11.322     0.200
     2.858    11.425     0.200
     2.955    10.570     0.200
     3.029    11.015     0.200
     3.241    12.148     0.200
     3.243    11.955     0.200
     3.284    12.247     0.200
     3.288    12.102     0.200
     3.316    10.764     0.200
     3.371    12.129     0.200
     3.497    11.622     0.200
     3.483    10.881     0.200
     3.892    14.114     0.200
     3.987    13.374     0.200
     4.035    13.709     0.200
     4.036    13.575     0.200
     4.046    13.721     0.200
     4.057    12.406     0.200
     4.100    11.553     0.200
     4.096    12.594     0.200
     4.369    13.640     0.200
     4.395    13.037     0.200
     4.434    12.678     0.200
     4.616    14.279     0.200
     4.637    13.032     0.200
     4.863    14.120     0.200
     4.993    13.560     0.200
     5.109    13.922     0.200
     5.204    13.448     0.200
     5.238    13.672     0.200
     5.315    15.658     0.200
     5.338    14.885     0.200
     5.502    13.943     0.200
     5.516    15.014     0.200
     5.493    14.810     0.200
     5.584    17.048     0.200
     5.624    14.538     0.200
     5.693    14.376     0.200
     5.801    15.839     0.200
     5.919    15.352     0.200
     5.951    15.665     0.200
     5.989    15.437     0.200
     6.095    16.585     0.200
     6.182    16.318     0.200
     6.315    16.045     0.200
     6.343    16.227     0.200
     6.408    16.631     0.200
     6.438    16.331     0.200
     6.608    16.605     0.200
     6.665    16.453     0.200
     6.647    17.370     0.200
     6.723    16.292     0.200
     6.799    16.964     0.200
     6.827    18.469     0.200
     6.793    17.841     0.200
     6.862    16.397     0.200
     6.905    17.179     0.200
     6.945    17.758     0.200
     6.980    16.853     0.200
     7.144    18.095     0.200
     7.163    18.533     0.200
     7.184    18.113     0.200
     7.166    17.334     0.200
     7.248    17.573     0.200
     7.179    18.345     0.200
     7.252    18.823     0.200
     7.261    18.152     0.200
     7.326    18.794     0.200
     7.395    17.883     0.200
     7.479    18.362     0.200
     7.505    18.880     0.200
     7.611    19.003     0.200
     7.590    19.138     0.200
     7.600    18.752     0.200
     7.646    18.821     0.200
     7.647    19.245     0.200
     7.687    17.642     0.200
     7.721    19.339     0.200
     7.806    17.369     0.200
     7.816    18.178     0.200
     7.819    19.556     0.200
     7.957    20.306     0.200
     7.967    19.832     0.200
     7.994    19.423     0.200
     8.021    17.595     0.200
     8.030    17.948     0.200
     8.030    20.072     0.200
     8.087    20.271     0.200
     8.171    18.768     0.200
     8.101    19.776     0.200
     8.197    18.887     0.200
     8.205    17.326     0.200
     8.205    18.396     0.200
     8.199    20.228     0.200
     8.180    19.860     0.200
     8.343    18.120     0.200
     8.343    18.580     0.200
     8.343    18.221     0.200
     8.391    22.777     0.200
     8.387    20.523     0.200
     8.442    20.943     0.200
     8.467    21.245     0.200
     8.739    20.446     0.200
     8.752    20.681     0.200
     8.796    21.587     0.200
     8.818    19.969     0.200
     9.316    21.396     0.200
     9.977    22.247     0.200
    10.023    21.997     0.200
    10.236    23.627     0.200
    10.805    24.546     0.200
    11.073    24.639     0.200
    12.633    26.357     0.200
    13.608    30.850     0.200
    14.608    29.228     0.200
    15.744    30.058     0.200
     1.255     6.162     0.200
     1.295     7.021     0.200
     1.307     7.186     0.200
     1.356     7.461     0.200
     1.379     6.773     0.200
     1.459     7.511     0.200
     1.467     7.576     0.200
     1.529     7.308     0.200
     1.575     7.424     0.200
     1.750     7.599     0.200
     1.761     7.498     0.200
     1.817     8.642     0.200
     1.819     7.960     0.200
     1.812     8.315     0.200
     1.866     8.079     0.200
     2.010     8.325     0.200
     2.170     9.005     0.200
     2.219     9.405     0.200
     2.462     8.853     0.200
     2.481     9.734     0.200
     2.526     9.793     0.200
     2.544     9.828     0.200
     2.877     9.696     0.200
     2.932     9.809     0.200
     2.928    10.479     0.200
     2.947    10.582     0.200
     2.953    10.251     0.200
     2.973    10.569     0.200
     2.979    10.884     0.200
     3.027    10.582     0.200
     3.059    10.666     0.200
     3.131     9.539     0.200
     3.278    10.306     0.200
     3.271     9.981     0.200
     3.675    12.210     0.200
     3.739    12.689     0.200
     3.737    12.423     0.200
     3.740    13.009     0.200
     3.833    11.535     0.200
     3.880    11.327     0.200
     3.820    11.955     0.200
     3.891    12.307     0.200
     3.907    11.679     0.200
     3.890    12.078     0.200
     4.004    12.750     0.200
     4.068    11.805     0.200
     4.374    12.718     0.200
     4.481    12.396     0.200
     4.489    12.030     0.200
     4.609    12.054     0.200
     4.764    13.335     0.200
     4.776    13.288     0.200
     4.746    13.277     0.200
     4.862    13.457     0.200
     4.922    13.905     0.200
     4.957    14.039     0.200
     5.120    13.788     0.200
     5.120    14.110     0.200
     5.143    14.581     0.200
     5.318    14.963     0.200
     5.382    16.634     0.200
     5.466    14.684     0.200
     5.548    15.282     0.200
     5.600    15.431     0.200
     5.729    15.095     0.200
     5.963    16.250     0.200
     6.097    16.331     0.200
     6.065    16.648     0.200
     6.107    16.405     0.200
     6.246    16.987     0.200
     6.225    15.918     0.200
     6.210    15.876     0.200
     6.313    17.116     0.200
     6.334    16.331     0.200
     6.380    16.894     0.200
     6.438    17.326     0.200
     6.461    17.303     0.200
     6.506    16.728     0.200
     6.576    16.911     0.200
     6.731    17.426     0.200
     6.644    16.884     0.200
     6.745    17.598     0.200
     6.847    17.987     0.200
     6.937    17.615     0.200
     7.075    19.327     0.200
     7.366    17.971     0.200
     7.745    17.793     0.200
     7.808    19.810     0.200
     7.808    17.161     0.200
     7.808    18.423     0.200
    12.384    25.916     0.200
    13.852    30.943     0.200
     2.077     9.963     0.200
     2.133    10.393     0.200
     2.210     9.635     0.200
     2.411    11.372     0.200
     2.525    11.420     0.200
     2.602    11.372     0.200
     2.540    11.449     0.200
     2.589    11.653     0.200
     3.121    12.126     0.200
     3.177    12.193     0.200
     3.177    12.375     0.200
     3.367    11.083     0.200
     3.536    13.133     0.200
     3.569    12.755     0.200
     3.636    12.519     0.200
     3.649    13.568     0.200
     3.785    12.693     0.200
     4.246    14.159     0.200
     4.260    13.502     0.200
     4.310    14.297     0.200
     4.398    14.220     0.200
     4.539    14.605     0.200
     4.313    15.214     0.200
     4.579    14.921     0.200
     4.606    13.833     0.200
     4.679    13.930     0.200
     4.763    14.891     0.200
     4.889    15.097     0.200
     4.920    15.715     0.200
     5.024    15.698     0.200
     5.027    15.589     0.200
     5.042    15.789     0.200
     5.158    15.738     0.200
     5.192    15.890     0.200
     5.376    16.385     0.200
     5.437    16.324     0.200
     5.458    16.727     0.200
     5.522    17.186     0.200
     5.946    20.796     0.200
     6.046    18.096     0.200
     6.064    17.858     0.200
     6.105    18.902     0.200
     6.151    18.714     0.200
     6.322    18.517     0.200
     6.347    19.140     0.200
     6.395    19.949     0.200
     6.390    19.174     0.200
     6.418    19.465     0.200
     6.506    19.706     0.200
     6.541    19.306     0.200
     6.615    20.249     0.200
     6.794    19.342     0.200
     6.792    20.495     0.200
     6.925    20.773     0.200
     7.161    20.695     0.200
     7.604    21.396     0.200
     7.505    22.134     0.200
     7.708    22.991     0.200
     7.889    21.491     0.200
     7.938    21.904     0.200
     8.152    21.143     0.200
     8.177    20.959     0.200
     8.176    20.323     0.200
     8.176    21.173     0.200
     9.182    26.461     0.200
     9.357    25.757     0.200
     9.370    24.815     0.200
    11.714    31.385     0.200
    14.045    34.561     0.200
    19.320    40.667     0.200
     0.360     9.509     0.200
     0.390     9.393     0.200
     0.447     9.063     0.200
     0.472     8.918     0.200
     0.518     9.136     0.200
     0.521     8.760     0.200
     0.578     9.038     0.200
     0.574     8.699     0.200
     0.618     8.617     0.200
     0.652     8.365     0.200
     0.660     7.983     0.200
     0.711     8.006     0.200
     0.785     7.959     0.200
     0.896     8.380     0.200
     0.970     8.025     0.200
     1.036     8.344     0.200
     1.184     7.385     0.200
     1.289     7.309     0.200
     1.458     8.103     0.200
     1.458     8.972     0.200
     1.578     8.583     0.200
     1.885     7.438     0.200
     1.916     9.442     0.200
     1.935     9.827     0.200
     1.937     9.814     0.200
     1.954     9.576     0.200
     2.204     8.579     0.200
     2.242     9.974     0.200
     2.582    10.471     0.200
     2.625    10.511     0.200
     2.606    10.298     0.200
     2.615    10.660     0.200
     2.683    11.179     0.200
     2.742    10.921     0.200
     2.711    10.486     0.200
     2.809    10.339     0.200
     2.789    10.583     0.200
     2.803    10.900     0.200
     3.071    11.335     0.200
     3.076    11.309     0.200
     3.098    10.159     0.200
     3.124    11.542     0.200
     3.410    12.205     0.200
     3.417    11.145     0.200
     3.709    11.003     0.200
     3.824    12.827     0.200
     3.849    11.920     0.200
     3.878    10.949     0.200
     3.875    13.383     0.200
     3.876    13.376     0.200
     4.203    13.359     0.200
     4.328    13.113     0.200
     4.433    13.519     0.200
     4.435    12.768     0.200
     4.628    13.681     0.200
     4.700    13.741     0.200
     4.666    13.374     0.200
     4.777    13.010     0.200
     5.002    13.581     0.200
     5.006    13.937     0.200
     5.243    15.282     0.200
     5.280    13.381     0.200
     5.287    14.077     0.200
     5.444    16.236     0.200
     5.467    13.339     0.200
     5.579    15.391     0.200
     5.690    14.588     0.200
     5.729    15.311     0.200
     5.781    15.088     0.200
     5.912    15.368     0.200
     5.958    15.694     0.200
     6.096    15.699     0.200
     6.110    15.847     0.200
     6.161    16.217     0.200
     6.280    16.608     0.200
     6.379    15.967     0.200
     6.430    16.004     0.200
     6.550    15.799     0.200
     6.565    16.518     0.200
     6.672    16.409     0.200
     6.711    16.642     0.200
     6.762    17.244     0.200
     6.812    16.434     0.200
     6.933    17.718     0.200
     7.031    17.699     0.200
     7.093    17.873     0.200
     7.192    18.396     0.200
     7.356    18.640     0.200
     7.368    18.287     0.200
     7.417    18.579     0.200
     7.401    18.175     0.200
     7.497    18.137     0.200
     7.586    19.128     0.200
     7.639    17.203     0.200
     7.721    19.708     0.200
     7.783    19.650     0.200
     7.795    19.260     0.200
     7.854    19.844     0.200
     7.854    17.302     0.200
     7.965    19.799     0.200
     8.041    17.960     0.200
     8.170    18.169     0.200
     8.170    18.022     0.200
     8.170    18.002     0.200
     8.352    20.798     0.200
     8.580    21.291     0.200
     9.080    20.756     0.200
     9.822    22.483     0.200
     9.851    21.249     0.200
     9.898    25.339     0.200
    10.023    24.099     0.200
    12.412    27.194     0.200
    12.544    28.417     0.200
    13.373    30.629     0.200
    14.417    29.974     0.200
    14.417    29.774     0.200
     0.658     5.541     0.200
     0.757     6.070     0.200
     0.843     6.112     0.200
     0.973     6.250     0.200
     1.008     6.762     0.200
     1.062     6.323     0.200
     1.102     6.247     0.200
     1.104     6.150     0.200
     1.118     6.183     0.200
     1.203     5.926     0.200
     1.256     7.220     0.200
     1.237     6.890     0.200
     1.424     7.520     0.200
     1.430     7.410     0.200
     1.468     6.779     0.200
     1.524     6.942     0.200
     1.553     7.238     0.200
     1.614     7.518     0.200
     1.659     7.575     0.200
     1.728     7.455     0.200
     1.905     8.101     0.200
     1.905     8.272     0.200
     1.970     7.496     0.200
     2.062     8.990     0.200
     2.034     8.412     0.200
     2.114     9.119     0.200
     2.160     8.923     0.200
     2.372     9.621     0.200
     2.475     8.207     0.200
     2.525     8.899     0.200
     2.814    10.231     0.200
     2.851    10.778     0.200
     2.878    10.452     0.200
     2.893    11.132     0.200
     2.974     8.816     0.200
     3.007     9.673     0.200
     3.102    11.132     0.200
     3.143    10.192     0.200
     3.151    10.879     0.200
     3.169    10.294     0.200
     3.260    11.095     0.200
     3.396    10.284     0.200
     3.653    11.588     0.200
     3.636    12.146     0.200
     3.725    10.758     0.200
     3.853    11.540     0.200
     3.870    10.748     0.200
     4.042    10.602     0.200
     4.119    12.208     0.200
     4.169    11.603     0.200
     4.254    11.921     0.200
     4.319    12.289     0.200
     4.439    12.755     0.200
     4.474    12.608     0.200
     4.540    12.728     0.200
     4.696    13.054     0.200
     4.759    13.706     0.200
     4.865    14.216     0.200
     4.947    13.480     0.200
     4.953    14.056     0.200
     5.128    13.979     0.200
     5.223    14.729     0.200
     5.275    13.741     0.200
     5.256    15.443     0.200
     5.357    14.684     0.200
     5.398    14.991     0.200
     5.422    15.002     0.200
     5.511    14.620     0.200
     5.553    15.161     0.200
     5.563    15.353     0.200
     5.567    14.679     0.200
     5.867    15.833     0.200
     5.911    15.047     0.200
     5.920    15.234     0.200
     5.930    14.975     0.200
     5.977    15.528     0.200
     5.981    15.348     0.200
     6.297    15.714     0.200
     6.361    15.724     0.200
     6.416    16.394     0.200
     6.416    17.855     0.200
     6.528    15.720     0.200
     6.513    16.391     0.200
     6.672    16.549     0.200
     6.727    16.947     0.200
     6.724    16.812     0.200
     6.728    16.578     0.200
     6.925    17.541     0.200
     6.944    17.238     0.200
     7.006    16.923     0.200
     7.006    17.404     0.200
     7.190    18.157     0.200
     7.612    19.292     0.200
     7.698    18.397     0.200
     8.498    19.385     0.200
     8.836    22.345     0.200
     8.940    21.173     0.200
     9.448    21.432     0.200
     9.799    22.237     0.200
    12.005    28.195     0.200
    13.132    29.734     0.200
     0.062    13.242     0.200
     0.209    11.492     0.200
     0.246    11.418     0.200
     0.365    10.553     0.200
     0.377    10.484     0.200
     0.442    10.640     0.200
     0.418    10.185     0.200
     0.474     9.673     0.200
     0.520     9.722     0.200
     0.470    10.066     0.200
     0.526     9.900     0.200
     0.609     9.608     0.200
     0.614     9.579     0.200
     0.624     9.254     0.200
     0.983     9.064     0.200
     0.997     9.349     0.200
     1.019     9.212     0.200
     1.018     9.152     0.200
     1.065     8.605     0.200
     1.308     8.095     0.200
     1.221     8.879     0.200
     1.253     8.891     0.200
     1.250     8.709     0.200
     1.301     9.244     0.200
     1.316     8.660     0.200
     1.325     8.731     0.200
     1.340     9.190     0.200
     1.502     8.024     0.200
     1.468     9.026     0.200
     1.606     9.264     0.200
     1.670     9.361     0.200
     1.680     8.880     0.200
     1.981     9.367     0.200
     2.011     8.586     0.200
     2.126     9.935     0.200
     2.171    10.377     0.200
     2.253     8.986     0.200
     2.232    10.217     0.200
     2.258    10.270     0.200
     2.491     9.707     0.200
     2.519    10.780     0.200
     2.567    10.134     0.200
     2.573    10.465     0.200
     2.601    10.212     0.200
     2.798     9.503     0.200
     2.880    11.282     0.200
     2.910    11.466     0.200
     2.931    11.662     0.200
     2.958    11.018     0.200
     2.937    11.717     0.200
     3.258    11.801     0.200
     3.432    12.057     0.200
     3.525    11.155     0.200
     3.642    11.296     0.200
     3.915    11.277     0.200
     4.088    12.165     0.200
     4.201    11.727     0.200
     4.349    12.381     0.200
     4.410    13.035     0.200
     4.425    13.944     0.200
     4.511    13.273     0.200
     4.447    13.793     0.200
     4.511    13.277     0.200
     4.658    11.958     0.200
     4.743    13.686     0.200
     4.855    14.077     0.200
     4.893    13.646     0.200
     4.886    13.263     0.200
     4.915    13.154     0.200
     5.134    14.215     0.200
     5.244    13.719     0.200
     5.370    14.585     0.200
     5.336    14.695     0.200
     5.589    14.844     0.200
     5.606    14.495     0.200
     5.675    15.220     0.200
     5.735    15.533     0.200
     5.738    15.311     0.200
     5.741    15.271     0.200
     5.840    15.771     0.200
     5.826    15.451     0.200
     5.867    15.451     0.200
     6.000    16.232     0.200
     6.048    15.961     0.200
     6.070    16.107     0.200
     6.205    16.273     0.200
     6.286    16.760     0.200
     6.283    15.677     0.200
     6.310    17.530     0.200
     6.429    17.100     0.200
     6.454    16.677     0.200
     6.492    17.079     0.200
     6.544    16.968     0.200
     6.615    17.226     0.200
     6.641    17.441     0.200
     6.655    17.012     0.200
     6.652    17.284     0.200
     6.695    15.834     0.200
     6.748    16.495     0.200
     6.909    16.071     0.200
     6.971    18.501     0.200
     6.979    18.192     0.200
     7.053    18.516     0.200
     7.053    16.518     0.200
     7.093    18.343     0.200
     7.093    17.147     0.200
     7.096    16.543     0.200
     7.208    18.708     0.200
     7.226    16.499     0.200
     7.226    16.703     0.200
     7.485    18.753     0.200
     7.467    19.041     0.200
     7.665    18.666     0.200
     7.710    18.690     0.200
     8.909    20.066     0.200
     8.929    20.721     0.200
     9.141    21.700     0.200
     9.964    25.108     0.200
    12.818    31.740     0.200
    13.487    27.838     0.200
     1.323     8.399     0.200
     1.788     7.200     0.200
     2.096     9.703     0.200
     2.252    10.717     0.200
     2.258    10.715     0.200
     2.396    11.427     0.200
     2.410    12.021     0.200
     2.535    11.459     0.200
     2.595    10.929     0.200
     2.910    13.294     0.200
     2.948    13.350     0.200
     2.958    13.144     0.200
     3.053    11.505     0.200
     3.160    12.716     0.200
     3.216    11.222     0.200
     3.214    13.813     0.200
     3.438    12.535     0.200
     3.512    13.769     0.200
     3.617    13.963     0.200
     4.011    14.680     0.200
     4.020    12.997     0.200
     4.250    13.953     0.200
     4.750    16.136     0.200
     4.893    16.230     0.200
     4.879    15.171     0.200
     4.947    15.174     0.200
     5.289    15.558     0.200
     5.369    15.417     0.200
     5.453    16.129     0.200
     5.461    16.183     0.200
     5.580    15.689     0.200
     5.800    17.575     0.200
     5.883    17.192     0.200
     6.037    18.171     0.200
     6.122    18.006     0.200
     6.126    18.036     0.200
     6.338    18.308     0.200
     6.458    19.461     0.200
     6.450    18.843     0.200
     6.630    19.405     0.200
     6.707    19.477     0.200
     6.745    19.305     0.200
     6.974    19.619     0.200
     7.046    20.216     0.200
     7.109    20.572     0.200
     7.164    20.999     0.200
     7.461    22.143     0.200
     7.522    21.262     0.200
     8.379    24.540     0.200
     8.756    23.143     0.200
    10.863    27.165     0.200
    11.716    30.626     0.200
    14.722    36.227     0.200
    14.722    36.397     0.200
     0.412     4.532     0.200
     0.540     5.059     0.200
     0.540     4.809     0.200
     0.927     5.104     0.200
     1.026     5.663     0.200
     1.065     5.777     0.200
     1.129     5.981     0.200
     1.151     5.929     0.200
     1.112     5.722     0.200
     1.195     6.145     0.200
     1.200     6.141     0.200
     1.214     6.266     0.200
     1.300     6.468     0.200
     1.324     6.819     0.200
     1.438     6.658     0.200
     1.634     7.518     0.200
     1.730     8.076     0.200
     1.755     8.464     0.200
     1.764     8.245     0.200
     1.777     8.708     0.200
     2.054     8.835     0.200
     2.130     8.007     0.200
     2.279     9.386     0.200
     2.366     9.103     0.200
     2.465     9.268     0.200
     2.555     9.298     0.200
     2.564     8.909     0.200
     2.613    10.036     0.200
     2.888    10.550     0.200
     2.939    10.889     0.200
     2.977    10.133     0.200
     3.013    10.624     0.200
     3.022    10.518     0.200
     3.279     9.996     0.200
     3.372    10.464     0.200
     3.386    12.104     0.200
     3.434    12.964     0.200
     3.650    11.447     0.200
     3.648    11.538     0.200
     3.661    11.321     0.200
     3.665    11.639     0.200
     3.690    12.265     0.200
     3.708    11.911     0.200
     3.710    12.016     0.200
     3.958    12.905     0.200
     3.995    12.684     0.200
     3.994    11.956     0.200
     4.212    12.167     0.200
     4.466    13.478     0.200
     4.577    12.803     0.200
     4.953    13.268     0.200
     4.965    14.183     0.200
     4.981    13.278     0.200
     5.101    13.824     0.200
     5.140    14.878     0.200
     5.271    14.298     0.200
     5.346    16.042     0.200
     5.359    14.275     0.200
     5.455    15.548     0.200
     5.477    14.972     0.200
     5.490    14.650     0.200
     5.681    14.900     0.200
     5.796    14.672     0.200
     5.872    16.360     0.200
     5.926    15.544     0.200
     6.022    15.527     0.200
     6.047    16.739     0.200
     6.074    16.320     0.200
     6.099    17.520     0.200
     6.192    16.110     0.200
     6.256    16.033     0.200
     6.276    16.458     0.200
     6.294    17.288     0.200
     6.354    16.521     0.200
     6.499    16.894     0.200
     6.543    17.343     0.200
     6.533    16.817     0.200
     6.571    17.027     0.200
     6.629    17.434     0.200
     6.620    16.945     0.200
     6.675    17.106     0.200
     6.703    17.834     0.200
     6.856    17.703     0.200
     6.987    17.879     0.200
     6.996    18.249     0.200
     7.078    18.067     0.200
     7.323    18.573     0.200
     7.371    17.720     0.200
     7.530    18.712     0.200
     7.566    18.404     0.200
     7.581    18.221     0.200
     7.633    21.125     0.200
     7.660    18.470     0.200
     7.782    19.154     0.200
     7.782    18.084     0.200
     7.800    18.699     0.200
     7.865    19.461     0.200
     7.865    18.575     0.200
     7.865    18.806     0.200
     7.985    19.251     0.200
     8.231    19.973     0.200
     8.404    20.434     0.200
     9.035    22.900     0.200
     9.168    21.956     0.200
     9.330    23.878     0.200
     9.446    23.823     0.200
     9.696    24.571     0.200
     9.773    25.151     0.200
    10.052    23.886     0.200
    10.487    26.705     0.200
    10.809    27.076     0.200
    12.473    30.116     0.200
    12.473    32.112     0.200
    13.974    30.473     0.200
     0.552     5.175     0.200
     0.674     5.400     0.200
     0.715     5.685     0.200
     0.741     5.295     0.200
     0.741     5.170     0.200
     0.942     6.325     0.200
     0.949     6.665     0.200
     0.984     6.590     0.200
     0.985     6.574     0.200
     1.063     6.762     0.200
     1.155     6.464     0.200
     1.193     7.033     0.200
     1.206     6.822     0.200
     1.228     7.346     0.200
     1.308     6.699     0.200
     1.349     6.744     0.200
     1.365     6.123     0.200
     1.356     6.850     0.200
     1.468     7.327     0.200
     1.465     7.060     0.200
     1.505     6.920     0.200
     1.535     7.136     0.200
     1.693     7.241     0.200
     1.951     8.208     0.200
     2.082     8.776     0.200
     2.161     7.603     0.200
     2.236     7.674     0.200
     2.312     8.328     0.200
     2.686    10.155     0.200
     2.693    10.045     0.200
     2.717    10.531     0.200
     2.749    10.538     0.200
     2.752    10.482     0.200
     2.906     9.832     0.200
     2.936     9.617     0.200
     3.008    10.972     0.200
     3.011     9.874     0.200
     3.163     9.854     0.200
     3.380    11.508     0.200
     3.519     9.422     0.200
     3.905    11.426     0.200
     3.887    12.123     0.200
     3.927    10.982     0.200
     4.004    11.096     0.200
     4.214    12.545     0.200
     4.295    11.364     0.200
     4.394    13.643     0.200
     4.456    12.661     0.200
     4.697    12.607     0.200
     4.701    13.307     0.200
     4.724    13.548     0.200
     4.744    12.937     0.200
     4.875    13.051     0.200
     5.065    13.507     0.200
     5.109    15.010     0.200
     5.218    14.547     0.200
     5.217    14.096     0.200
     5.263    14.099     0.200
     5.313    14.008     0.200
     5.510    15.325     0.200
     5.645    14.977     0.200
     5.648    15.403     0.200
     5.678    15.004     0.200
     5.979    16.537     0.200
     6.045    15.918     0.200
     6.109    16.581     0.200
     6.749    16.043     0.200
     6.820    17.390     0.200
     6.819    17.292     0.200
     6.951    18.191     0.200
     7.512    19.705     0.200
     8.803    21.648     0.200
    10.080    22.567     0.200
    11.763    28.046     0.200
    12.915    28.656     0.200
    18.888    35.893     0.200
     0.206    11.023     0.200
     0.297     9.738     0.200
     0.441     9.268     0.200
     0.455     8.837     0.200
     0.492     9.228     0.200
     0.558     8.993     0.200
     0.561     9.153     0.200
     0.517     8.831     0.200
     0.559     8.513     0.200
     0.643     8.784     0.200
     0.795     8.513     0.200
     0.821     8.714     0.200
     1.057     8.681     0.200
     1.057     6.970     0.200
     1.057     8.044     0.200
     1.080     8.953     0.200
     1.090     8.971     0.200
     1.099     8.830     0.200
     1.257     6.760     0.200
     1.390     9.089     0.200
     1.769     9.421     0.200
     1.789     9.681     0.200
     1.814     7.515     0.200
     1.864     9.563     0.200
     2.233    10.106     0.200
     2.226     8.959     0.200
     2.260    10.646     0.200
     2.280    10.397     0.200
     2.346    10.331     0.200
     2.367    10.353     0.200
     2.558    10.327     0.200
     2.593     9.919     0.200
     2.607    10.140     0.200
     2.662     9.024     0.200
     2.821    10.512     0.200
     2.968    10.005     0.200
     2.995    11.411     0.200
     3.021    11.319     0.200
     3.013     9.602     0.200
     3.030    11.132     0.200
     3.070     9.909     0.200
     3.047    11.463     0.200
     3.050    11.622     0.200
     3.050    11.669     0.200
     3.365    11.701     0.200
     3.433    12.884     0.200
     3.457    12.869     0.200
     3.477    11.903     0.200
     3.555    11.167     0.200
     3.648    13.199     0.200
     3.698    12.794     0.200
     3.902    11.550     0.200
     4.127    11.562     0.200
     4.232    12.402     0.200
     4.502    12.857     0.200
     4.570    13.224     0.200
     4.542    12.444     0.200
     4.638    14.634     0.200
     4.660    13.913     0.200
     4.654    14.738     0.200
     4.713    12.872     0.200
     4.824    13.795     0.200
     4.851    13.474     0.200
     4.863    13.409     0.200
     4.901    13.382     0.200
     5.116    15.535     0.200
     5.097    13.690     0.200
     5.163    14.985     0.200
     5.176    14.668     0.200
     5.225    14.139     0.200
     5.291    14.931     0.200
     5.331    14.789     0.200
     5.447    15.052     0.200
     5.451    14.341     0.200
     5.502    16.001     0.200
     5.534    14.690     0.200
     5.585    15.026     0.200
     5.611    15.692     0.200
     5.675    16.270     0.200
     5.637    15.109     0.200
     5.695    14.688     0.200
     5.736    15.308     0.200
     5.754    15.131     0.200
     5.890    16.071     0.200
     5.909    15.866     0.200
     5.962    15.183     0.200
     5.964    15.369     0.200
     5.984    15.706     0.200
     6.151    15.924     0.200
     6.162    16.647     0.200
     6.191    16.575     0.200
     6.311    16.013     0.200
     6.384    17.400     0.200
     6.338    17.096     0.200
     6.461    17.776     0.200
     6.461    17.031     0.200
     6.543    18.345     0.200
     6.537    16.919     0.200
     6.543    16.870     0.200
     6.552    17.462     0.200
     6.555    17.528     0.200
     6.794    15.973     0.200
     6.889    16.463     0.200
     6.873    18.406     0.200
     6.945    19.801     0.200
     6.904    17.868     0.200
     6.909    17.822     0.200
     6.990    19.252     0.200
     6.993    18.459     0.200
     6.994    16.508     0.200
     7.007    16.081     0.200
     6.999    18.462     0.200
     7.137    16.995     0.200
     7.198    16.740     0.200
     7.198    16.369     0.200
     7.201    16.638     0.200
     7.240    17.647     0.200
     7.315    15.991     0.200
     7.315    16.604     0.200
     7.315    16.604     0.200
     7.378    18.996     0.200
     7.647    19.332     0.200
     7.696    19.965     0.200
     7.704    18.965     0.200
     7.759    20.168     0.200
     7.818    19.875     0.200
     7.770    19.024     0.200
     7.802    19.011     0.200
     7.837    20.259     0.200
     8.213    19.744     0.200
     8.220    20.633     0.200
     8.418    20.745     0.200
     8.440    21.035     0.200
     8.632    20.512     0.200
     8.942    20.535     0.200
     9.080    20.662     0.200
     9.143    21.880     0.200
     9.182    22.373     0.200
     9.145    21.865     0.200
     9.309    22.631     0.200
     9.651    25.263     0.200
     9.859    22.182     0.200
     9.838    23.397     0.200
    10.028    25.700     0.200
    10.093    24.322     0.200
    11.957    25.426     0.200
    12.678    29.397     0.200
    12.914    27.347     0.200
    13.540    28.381     0.200
    13.540    27.365     0.200
    16.679    31.571     0.200
     0.757     4.835     0.200
     0.863     5.130     0.200
     0.948     5.678     0.200
     1.183     5.975     0.200
     1.257     7.034     0.200
     1.258     7.036     0.200
     1.270     7.521     0.200
     1.255     5.949     0.200
     1.303     7.111     0.200
     1.308     6.171     0.200
     1.358     6.930     0.200
     1.373     6.819     0.200
     1.423     7.315     0.200
     1.440     6.968     0.200
     1.586     7.529     0.200
     1.681     7.161     0.200
     1.929     8.261     0.200
     2.011     8.430     0.200
     2.022     8.197     0.200
     2.163     8.938     0.200
     2.314     8.846     0.200
     2.342     8.951     0.200
     2.418     9.319     0.200
     2.444     9.477     0.200
     2.655     8.972     0.200
     3.047    10.266     0.200
     3.052    10.577     0.200
     3.060    10.544     0.200
     3.127    11.043     0.200
     3.260    11.111     0.200
     3.259    10.900     0.200
     3.315    10.857     0.200
     3.375    11.290     0.200
     3.353    10.456     0.200
     3.500     9.672     0.200
     3.666    10.826     0.200
     4.063    11.608     0.200
     4.250    11.889     0.200
     4.361    12.283     0.200
     4.539    12.933     0.200
     4.641    13.668     0.200
     4.749    13.242     0.200
     5.055    14.077     0.200
     5.076    14.166     0.200
     5.166    14.411     0.200
     5.313    14.106     0.200
     5.287    14.661     0.200
     5.493    15.029     0.200
     5.563    15.389     0.200
     5.577    14.622     0.200
     5.624    14.530     0.200
     5.652    15.151     0.200
     5.790    15.525     0.200
     5.821    15.667     0.200
     5.843    15.654     0.200
     5.868    15.974     0.200
     5.902    15.557     0.200
     5.954    15.899     0.200
     5.967    15.678     0.200
     6.165    16.584     0.200
     6.223    16.635     0.200
     6.269    16.096     0.200
     6.301    16.699     0.200
     6.381    16.079     0.200
     6.484    16.410     0.200
     6.492    17.836     0.200
     6.697    17.159     0.200
     6.850    17.871     0.200
     6.837    17.382     0.200
     6.902    19.276     0.200
     6.905    16.922     0.200
     6.955    18.138     0.200
     7.111    18.254     0.200
     7.136    17.568     0.200
     7.177    17.863     0.200
     7.177    17.116     0.200
     7.177    17.786     0.200
     7.245    17.432     0.200
     7.874    19.028     0.200
     8.529    20.500     0.200
     8.596    21.171     0.200
     8.706    22.284     0.200
     8.900    21.870     0.200
     9.058    22.306     0.200
     9.099    22.447     0.200
     9.373    21.695     0.200
     9.979    21.949     0.200
    10.339    24.358     0.200
    11.869    28.253     0.200
    11.869    27.483     0.200
    13.246    29.258     0.200
    13.246    30.233     0.200
    19.101    36.201     0.200
    19.101    35.946     0.200
     0.323     6.639     0.200
     0.358     6.495     0.200
     0.411     6.733     0.200
     0.487     6.493     0.200
     0.624     6.119     0.200
     0.756     5.965     0.200
     0.774     5.979     0.200
     0.779     5.829     0.200
     0.832     6.479     0.200
     0.862     5.980     0.200
     0.899     6.694     0.200
     0.907     6.749     0.200
     0.885     6.342     0.200
     0.926     7.015     0.200
     0.945     6.841     0.200
     1.116     6.471     0.200
     1.229     7.347     0.200
     1.238     6.124     0.200
     1.494     7.063     0.200
     1.544     7.605     0.200
     1.589     8.392     0.200
     1.608     7.506     0.200
     1.590     7.687     0.200
     1.599     8.028     0.200
     1.643     7.654     0.200
     1.676     7.770     0.200
     1.669     7.887     0.200
     1.712     7.961     0.200
     1.782     8.291     0.200
     2.088     8.843     0.200
     2.153     9.260     0.200
     2.193     9.318     0.200
     2.711     8.695     0.200
     2.836    10.900     0.200
     2.840     9.926     0.200
     2.889    10.061     0.200
     3.193    11.491     0.200
     3.301    11.037     0.200
     3.370    11.035     0.200
     3.613    10.540     0.200
     3.697    11.735     0.200
     3.878    11.106     0.200
     4.082    12.071     0.200
     4.113    11.429     0.200
     4.286    12.487     0.200
     4.302    11.600     0.200
     4.412    12.178     0.200
     4.533    12.320     0.200
     4.523    13.833     0.200
     4.562    12.728     0.200
     4.630    13.774     0.200
     4.630    13.679     0.200
     4.929    14.179     0.200
     5.279    14.667     0.200
     5.291    14.516     0.200
     5.493    14.751     0.200
     5.563    15.224     0.200
     5.658    14.422     0.200
     5.771    15.131     0.200
     5.816    15.354     0.200
     5.862    15.240     0.200
     6.134    15.680     0.200
     6.220    16.117     0.200
     6.224    16.229     0.200
     6.224    15.968     0.200
     6.261    16.634     0.200
     6.447    16.632     0.200
     6.543    17.182     0.200
     6.600    16.681     0.200
     6.670    17.266     0.200
     6.791    17.715     0.200
     7.046    17.280     0.200
     7.110    17.687     0.200
     7.110    17.642     0.200
     7.110    17.212     0.200
     7.415    18.398     0.200
     7.568    18.628     0.200
     8.035    19.113     0.200
     9.885    23.056     0.200
    12.344    29.307     0.200
    13.296    31.154     0.200
     0.749     5.315     0.200
     1.110     5.934     0.200
     1.267     6.641     0.200
     1.249     6.419     0.200
     1.371     6.585     0.200
     1.424     7.273     0.200
     1.428     7.713     0.200
     1.430     7.063     0.200
     1.419     6.344     0.200
     1.467     8.130     0.200
     1.500     7.739     0.200
     1.517     6.798     0.200
     1.618     7.822     0.200
     1.705     7.560     0.200
     1.815     7.453     0.200
     1.849     7.669     0.200
     1.844     8.318     0.200
     1.852     7.800     0.200
     1.887     8.398     0.200
     1.975     7.843     0.200
     2.116     7.410     0.200
     2.211     8.357     0.200
     2.262     8.632     0.200
     2.299     8.276     0.200
     2.325     8.216     0.200
     2.383     8.920     0.200
     2.393     8.891     0.200
     2.512     8.559     0.200
     2.582     9.283     0.200
     2.731     9.021     0.200
     2.910     9.567     0.200
     2.937    10.196     0.200
     2.941     9.741     0.200
     2.954     9.797     0.200
     2.967    10.726     0.200
     2.939    10.750     0.200
     3.035    10.528     0.200
     3.052     9.524     0.200
     3.209    10.344     0.200
     3.221    10.639     0.200
     3.339    10.310     0.200
     3.476    11.076     0.200
     3.499    10.230     0.200
     3.528    10.274     0.200
     3.572     9.751     0.200
     3.701    11.131     0.200
     3.733    11.479     0.200
     3.732    11.001     0.200
     3.741    10.858     0.200
     3.820    11.146     0.200
     3.856    11.447     0.200
     3.880    11.775     0.200
     3.887    11.384     0.200
     4.084    11.755     0.200
     4.102    12.172     0.200
     4.136    12.388     0.200
     4.222    11.924     0.200
     4.433    12.137     0.200
     4.539    12.115     0.200
     4.631    13.252     0.200
     4.670    12.580     0.200
     4.765    12.228     0.200
     4.937    13.591     0.200
     4.946    13.640     0.200
     5.044    14.179     0.200
     5.125    13.885     0.200
     5.082    13.972     0.200
     5.145    14.012     0.200
     5.099    13.768     0.200
     5.214    14.503     0.200
     5.221    14.482     0.200
     5.242    13.882     0.200
     5.289    14.652     0.200
     5.299    14.815     0.200
     5.283    14.134     0.200
     5.363    14.407     0.200
     5.436    14.409     0.200
     5.566    15.091     0.200
     5.557    14.946     0.200
     5.606    15.530     0.200
     5.718    14.551     0.200
     5.729    15.221     0.200
     5.743    15.346     0.200
     5.836    14.039     0.200
     5.935    14.513     0.200
     5.986    15.884     0.200
     6.047    16.014     0.200
     6.081    15.853     0.200
     6.420    16.662     0.200
     6.491    17.438     0.200
     6.524    17.611     0.200
     6.624    16.733     0.200
     6.676    17.070     0.200
     6.713    17.143     0.200
     6.775    17.001     0.200
     6.774    17.068     0.200
     6.837    17.369     0.200
     6.875    17.082     0.200
     6.873    17.563     0.200
     6.873    16.976     0.200
     7.001    17.340     0.200
     7.575    20.046     0.200
     7.788    18.915     0.200
     8.175    20.487     0.200
     8.240    21.263     0.200
     8.488    21.481     0.200
     8.801    22.147     0.200
     8.991    21.321     0.200
     9.465    21.975     0.200
     9.687    22.042     0.200
    10.541    26.037     0.200
    12.840    30.454     0.200
    18.550    37.163     0.200
     0.347     6.520     0.200
     0.541     6.345     0.200
     0.628     6.271     0.200
     0.738     5.954     0.200
     0.852     6.345     0.200
     0.900     6.886     0.200
     0.920     7.150     0.200
     0.976     6.376     0.200
     0.994     6.166     0.200
     1.000     6.367     0.200
     1.113     6.687     0.200
     1.120     7.182     0.200
     1.229     6.439     0.200
     1.344     6.844     0.200
     1.453     8.194     0.200
     1.480     7.521     0.200
     1.643     7.891     0.200
     1.776     7.469     0.200
     1.806     8.334     0.200
     1.875     8.632     0.200
     2.351     9.686     0.200
     2.562     8.869     0.200
     2.792    10.349     0.200
     2.854    10.842     0.200
     2.922     9.819     0.200
     3.137    10.856     0.200
     3.173    10.349     0.200
     3.266    11.169     0.200
     3.451    10.254     0.200
     3.640    11.408     0.200
     3.754    11.009     0.200
     3.809    10.905     0.200
     3.934    11.335     0.200
     3.959    11.611     0.200
     4.117    10.549     0.200
     4.154    11.894     0.200
     4.236    11.439     0.200
     4.337    11.867     0.200
     4.386    12.320     0.200
     4.484    12.525     0.200
     4.492    14.483     0.200
     4.611    12.671     0.200
     4.687    14.252     0.200
     4.708    14.118     0.200
     4.759    13.275     0.200
     5.027    13.167     0.200
     5.048    13.939     0.200
     5.095    14.089     0.200
     5.241    15.409     0.200
     5.371    14.712     0.200
     5.405    14.710     0.200
     5.447    14.801     0.200
     5.602    14.672     0.200
     5.619    15.762     0.200
     5.650    15.171     0.200
     5.689    16.125     0.200
     5.745    14.906     0.200
     5.899    15.406     0.200
     5.909    15.636     0.200
     5.927    15.615     0.200
     6.015    15.992     0.200
     6.065    16.013     0.200
     6.241    16.542     0.200
     6.330    17.059     0.200
     6.459    17.207     0.200
     6.469    17.637     0.200
     6.506    17.262     0.200
     6.518    16.467     0.200
     6.621    16.949     0.200
     6.686    16.924     0.200
     6.729    16.480     0.200
     6.830    17.428     0.200
     6.840    17.951     0.200
     6.944    17.029     0.200
     7.018    16.510     0.200
     7.215    17.725     0.200
     7.250    18.496     0.200
     7.570    19.358     0.200
     7.811    18.949     0.200
     8.540    20.436     0.200
     8.701    21.142     0.200
     8.918    20.937     0.200
     9.548    23.270     0.200
     9.804    22.336     0.200
    12.119    27.996     0.200
    13.168    28.833     0.200
     0.463     5.596     0.200
     0.463     4.377     0.200
     0.686     5.193     0.200
     0.755     5.333     0.200
     0.778     5.724     0.200
     0.873     6.228     0.200
     0.878     5.933     0.200
     0.866     6.027     0.200
     0.920     5.956     0.200
     0.988     6.137     0.200
     1.016     6.328     0.200
     1.089     6.405     0.200
     1.098     6.851     0.200
     1.128     6.680     0.200
     1.258     7.282     0.200
     1.280     7.636     0.200
     1.305     7.070     0.200
     1.369     7.099     0.200
     1.613     7.148     0.200
     1.649     7.831     0.200
     1.782     7.947     0.200
     1.782     8.688     0.200
     1.880     8.386     0.200
     2.006     8.813     0.200
     2.080     8.079     0.200
     2.353     9.275     0.200
     2.398     9.640     0.200
     2.419     9.376     0.200
     2.524    10.036     0.200
     2.531     9.785     0.200
     2.714    10.002     0.200
     2.815     9.052     0.200
     2.881     9.366     0.200
     2.855    10.324     0.200
     3.013    10.742     0.200
     3.155    11.043     0.200
     3.164    10.772     0.200
     3.169    10.902     0.200
     3.169    10.892     0.200
     3.218    11.316     0.200
     3.238    11.236     0.200
     3.248    10.558     0.200
     3.336    11.079     0.200
     3.460    11.459     0.200
     3.498    11.552     0.200
     3.500    11.192     0.200
     3.617    11.802     0.200
     3.741    11.037     0.200
     3.729    13.288     0.200
     3.838    11.177     0.200
     4.001    11.859     0.200
     4.083    11.463     0.200
     4.122    11.566     0.200
     4.203    11.195     0.200
     4.288    12.255     0.200
     4.366    11.105     0.200
     4.475    12.554     0.200
     4.502    12.146     0.200
     4.579    13.090     0.200
     4.608    12.854     0.200
     4.651    13.459     0.200
     4.791    13.642     0.200
     4.856    14.399     0.200
     4.868    13.331     0.200
     4.838    13.774     0.200
     5.025    13.826     0.200
     5.033    13.899     0.200
     5.029    14.501     0.200
     5.260    13.839     0.200
     5.383    15.804     0.200
     5.555    15.632     0.200
     5.575    15.903     0.200
     5.482    16.001     0.200
     5.602    16.190     0.200
     5.643    14.909     0.200
     5.780    14.924     0.200
     5.810    15.622     0.200
     5.828    15.678     0.200
     5.780    16.202     0.200
     5.914    16.227     0.200
     6.042    16.444     0.200
     6.133    16.717     0.200
     6.179    16.645     0.200
     6.201    16.687     0.200
     6.220    16.282     0.200
     6.286    17.016     0.200
     6.435    17.070     0.200
     6.501    17.400     0.200
     6.636    17.391     0.200
     6.708    17.643     0.200
     6.736    18.175     0.200
     6.869    16.482     0.200
     6.986    17.966     0.200
     7.030    17.798     0.200
     7.080    16.662     0.200
     7.151    19.857     0.200
     7.281    17.806     0.200
     7.268    18.430     0.200
     7.299    17.909     0.200
     7.365    17.175     0.200
     7.364    17.305     0.200
     7.364    17.338     0.200
     7.349    18.048     0.200
     7.528    19.574     0.200
     7.917    18.860     0.200
     7.932    19.818     0.200
     8.562    21.389     0.200
     8.850    22.055     0.200
     8.874    21.561     0.200
     8.985    22.724     0.200
     9.169    22.775     0.200
     9.280    23.366     0.200
     9.281    21.785     0.200
     9.681    24.738     0.200
     9.712    23.723     0.200
     9.959    23.833     0.200
    10.155    22.754     0.200
    10.614    24.699     0.200
    11.431    27.504     0.200
    12.214    28.761     0.200
    13.488    29.778     0.200
    13.488    30.178     0.200
    19.606    37.389     0.200
    20.308    35.754     0.200
    20.580    35.818     0.200
    20.912    35.832     0.200
     0.721     4.819     0.200
     0.582     5.280     0.200
     0.697     5.652     0.200
     0.697     4.886     0.200
     0.836     5.375     0.200
     0.891     5.488     0.200
     0.937     6.015     0.200
     0.925     5.860     0.200
     1.012     5.888     0.200
     1.117     6.098     0.200
     1.098     6.064     0.200
     1.233     6.207     0.200
     1.230     6.714     0.200
     1.285     6.853     0.200
     1.467     7.527     0.200
     1.648     8.312     0.200
     1.676     8.736     0.200
     1.694     8.375     0.200
     2.294     9.262     0.200
     2.276     9.863     0.200
     2.286     9.223     0.200
     2.358     9.112     0.200
     2.406     9.213     0.200
     2.389     9.082     0.200
     2.468    10.057     0.200
     2.467     9.364     0.200
     2.561     8.732     0.200
     2.584     9.028     0.200
     2.777    10.393     0.200
     2.856     9.850     0.200
     2.822    11.086     0.200
     2.838    10.289     0.200
     2.943    10.964     0.200
     2.956    10.915     0.200
     3.257    11.592     0.200
     3.322     9.841     0.200
     3.381    10.460     0.200
     3.509    11.343     0.200
     3.585    11.872     0.200
     3.606    11.598     0.200
     3.639    12.255     0.200
     3.675    11.997     0.200
     3.996    11.939     0.200
     4.249    12.011     0.200
     4.353    12.551     0.200
     4.306    12.264     0.200
     4.578    12.188     0.200
     4.625    12.513     0.200
     4.664    13.220     0.200
     4.710    12.342     0.200
     4.870    12.405     0.200
     4.966    14.464     0.200
     5.013    14.736     0.200
     5.038    13.123     0.200
     5.062    13.978     0.200
     5.158    14.189     0.200
     5.272    15.283     0.200
     5.309    15.954     0.200
     5.323    15.446     0.200
     5.346    15.298     0.200
     5.345    15.437     0.200
     5.295    14.417     0.200
     5.373    14.927     0.200
     5.395    14.854     0.200
     5.455    14.724     0.200
     5.541    14.764     0.200
     5.798    16.519     0.200
     5.760    15.315     0.200
     5.899    15.367     0.200
     6.032    16.394     0.200
     6.026    16.395     0.200
     6.126    15.940     0.200
     6.228    16.737     0.200
     6.272    16.406     0.200
     6.303    16.486     0.200
     6.421    16.925     0.200
     6.509    17.950     0.200
     6.463    17.003     0.200
     6.566    17.280     0.200
     6.603    17.069     0.200
     6.649    17.245     0.200
     6.680    17.373     0.200
     6.724    17.648     0.200
     6.716    17.523     0.200
     6.768    17.926     0.200
     6.972    18.158     0.200
     7.083    18.343     0.200
     7.110    18.316     0.200
     7.200    18.784     0.200
     7.500    18.382     0.200
     7.447    18.634     0.200
     7.511    19.153     0.200
     7.550    18.012     0.200
     7.655    19.775     0.200
     7.748    18.490     0.200
     7.761    18.451     0.200
     7.724    18.849     0.200
     7.842    19.098     0.200
     7.842    17.578     0.200
     7.842    19.153     0.200
     7.795    18.856     0.200
     8.100    19.630     0.200
     8.036    20.386     0.200
     8.201    19.865     0.200
     8.305    20.791     0.200
     8.305    20.529     0.200
     8.941    22.170     0.200
     9.310    22.481     0.200
     9.354    22.983     0.200
     9.493    22.986     0.200
     9.753    23.950     0.200
     9.838    23.339     0.200
    10.176    24.364     0.200
    10.608    27.099     0.200
    11.141    25.078     0.200
    11.141    27.223     0.200
    11.650    26.768     0.200
    12.628    31.221     0.200
    13.988    30.780     0.200
    14.351    32.237     0.200
    15.744    34.647     0.200
    19.890    37.697     0.200
     0.402     4.824     0.200
     0.529     4.481     0.200
     1.571     7.161     0.200
     1.658     7.526     0.200
     1.677     8.034     0.200
     1.786     8.008     0.200
     2.020     8.918     0.200
     2.060     9.121     0.200
     2.069     9.010     0.200
     2.071     8.477     0.200
     2.080     8.092     0.200
     2.298     9.099     0.200
     2.496     8.477     0.200
     2.592     9.686     0.200
     2.647     9.540     0.200
     2.699     9.870     0.200
     3.108    10.432     0.200
     3.210    11.086     0.200
     3.311    10.028     0.200
     3.189     9.773     0.200
     3.212    10.362     0.200
     3.498     9.918     0.200
     3.768    10.243     0.200
     3.810    12.078     0.200
     3.881    12.124     0.200
     3.888    12.516     0.200
     3.941    11.228     0.200
     3.943    11.992     0.200
     3.918    11.785     0.200
     4.059    11.932     0.200
     4.122    12.693     0.200
     4.161    11.682     0.200
     4.423    11.493     0.200
     4.494    12.114     0.200
     4.518    11.990     0.200
     4.616    12.740     0.200
     4.659    12.599     0.200
     4.723    12.769     0.200
     4.714    12.810     0.200
     4.874    13.234     0.200
     5.044    13.435     0.200
     4.953    13.156     0.200
     5.130    14.282     0.200
     5.211    14.406     0.200
     5.216    14.360     0.200
     5.260    14.079     0.200
     5.361    14.295     0.200
     5.517    15.131     0.200
     5.624    14.857     0.200
     5.768    15.507     0.200
     5.818    15.241     0.200
     5.845    16.469     0.200
     5.963    15.730     0.200
     5.983    15.851     0.200
     6.096    16.125     0.200
     6.092    15.894     0.200
     6.159    16.240     0.200
     6.156    16.246     0.200
     6.195    16.692     0.200
     6.214    16.213     0.200
     6.216    16.753     0.200
     6.242    16.216     0.200
     6.273    16.321     0.200
     6.305    16.500     0.200
     6.416    17.030     0.200
     6.560    16.906     0.200
     6.575    17.261     0.200
     6.606    17.392     0.200
     6.619    17.677     0.200
     6.758    18.874     0.200
     6.892    17.471     0.200
     7.030    18.490     0.200
     7.115    18.133     0.200
     7.359    18.808     0.200
     7.394    19.235     0.200
     7.484    19.937     0.200
     7.600    18.408     0.200
     7.741    19.581     0.200
     7.857    18.424     0.200
     7.857    19.018     0.200
     8.641    21.140     0.200
     8.646    21.682     0.200
     8.775    21.715     0.200
     9.165    22.743     0.200
     9.209    22.745     0.200
     9.173    23.020     0.200
    11.914    28.919     0.200
    13.833    30.931     0.200
    13.833    31.619     0.200
     0.531     5.184     0.200
     0.910     5.371     0.200
     1.009     5.788     0.200
     0.994     5.945     0.200
     0.994     5.500     0.200
     0.994     6.078     0.200
     1.083     6.012     0.200
     1.088     5.790     0.200
     1.164     6.570     0.200
     1.182     6.729     0.200
     1.275     6.383     0.200
     1.359     6.666     0.200
     1.487     7.307     0.200
     1.503     7.627     0.200
     1.620     7.835     0.200
     2.041     9.172     0.200
     2.071     9.265     0.200
     2.078     9.468     0.200
     2.181     8.730     0.200
     2.199     8.864     0.200
     2.522     8.407     0.200
     2.690    10.176     0.200
     2.783    10.428     0.200
     2.935    10.186     0.200
     2.937     9.574     0.200
     2.995     9.905     0.200
     3.220    11.924     0.200
     3.235    11.313     0.200
     3.794    11.223     0.200
     3.826    11.870     0.200
     3.984    12.690     0.200
     4.008    12.583     0.200
     4.034    13.311     0.200
     4.006    12.024     0.200
     4.076    12.968     0.200
     4.344    13.426     0.200
     4.363    13.383     0.200
     4.410    12.753     0.200
     4.501    13.456     0.200
     4.687    13.125     0.200
     4.848    13.626     0.200
     4.992    12.845     0.200
     5.016    13.138     0.200
     5.037    13.141     0.200
     5.109    12.578     0.200
     5.197    13.819     0.200
     5.388    14.622     0.200
     5.408    13.798     0.200
     5.443    14.046     0.200
     5.650    16.015     0.200
     5.663    17.042     0.200
     5.706    15.306     0.200
     5.768    14.771     0.200
     5.823    15.068     0.200
     5.942    15.401     0.200
     6.143    15.310     0.200
     6.187    17.318     0.200
     6.430    16.883     0.200
     6.440    18.453     0.200
     6.639    17.526     0.200
     6.687    17.288     0.200
     6.828    18.269     0.200
     6.919    18.458     0.200
     6.962    18.438     0.200
     7.034    17.830     0.200
     7.135    18.027     0.200
     7.537    18.854     0.200
     7.676    20.143     0.200
     7.748    18.499     0.200
     7.894    19.978     0.200
     7.905    20.530     0.200
     7.961    18.742     0.200
     8.066    20.295     0.200
     8.113    19.169     0.200
     8.158    19.198     0.200
     8.169    19.248     0.200
     8.254    19.568     0.200
     8.254    19.204     0.200
     8.254    19.501     0.200
     8.333    20.377     0.200
     8.437    21.186     0.200
     8.673    21.896     0.200
     8.910    20.729     0.200
     9.286    22.056     0.200
     9.765    23.939     0.200
     9.896    24.482     0.200
    10.092    24.653     0.200
    10.163    25.245     0.200
    10.143    24.642     0.200
    10.511    24.694     0.200
    10.715    26.696     0.200
    11.530    27.452     0.200
    11.530    28.741     0.200
    12.907    30.620     0.200
    14.401    31.583     0.200
    14.401    34.138     0.200
     0.316    10.391     0.200
     0.335    10.350     0.200
     0.477     9.463     0.200
     0.561     8.996     0.200
     0.796     8.847     0.200
     0.843     8.409     0.200
     0.959     8.685     0.200
     1.030     8.579     0.200
     1.245     7.637     0.200
     1.260     7.125     0.200
     1.354     9.068     0.200
     1.373     9.259     0.200
     1.378     9.234     0.200
     2.065     9.871     0.200
     2.202     9.851     0.200
     2.212     9.660     0.200
     2.261     9.503     0.200
     2.516    10.801     0.200
     2.568     9.472     0.200
     2.618    10.933     0.200
     2.643    11.004     0.200
     2.729     9.705     0.200
     2.948    10.225     0.200
     3.088    11.297     0.200
     3.302    11.632     0.200
     3.358    10.361     0.200
     3.366    12.222     0.200
     3.871    12.510     0.200
     3.881    11.785     0.200
     4.227    11.421     0.200
     4.450    12.562     0.200
     4.550    12.451     0.200
     4.569    11.754     0.200
     4.650    12.632     0.200
     4.775    15.442     0.200
     4.817    13.966     0.200
     4.869    12.661     0.200
     4.898    14.167     0.200
     5.057    13.419     0.200
     5.156    14.321     0.200
     5.197    13.654     0.200
     5.207    14.397     0.200
     5.234    14.118     0.200
     5.241    14.499     0.200
     5.416    15.653     0.200
     5.442    14.254     0.200
     5.567    14.674     0.200
     5.636    14.957     0.200
     5.706    15.562     0.200
     5.723    15.071     0.200
     5.822    16.591     0.200
     5.841    16.838     0.200
     5.880    14.955     0.200
     5.928    15.755     0.200
     5.979    16.403     0.200
     5.988    15.076     0.200
     6.038    16.225     0.200
     6.112    15.680     0.200
     6.213    15.539     0.200
     6.251    15.080     0.200
     6.252    16.517     0.200
     6.328    16.344     0.200
     6.390    16.623     0.200
     6.533    17.473     0.200
     6.617    16.969     0.200
     6.639    16.707     0.200
     6.749    16.992     0.200
     6.805    17.584     0.200
     6.888    17.451     0.200
     6.896    17.885     0.200
     6.896    18.062     0.200
     6.930    17.702     0.200
     6.973    16.762     0.200
     7.079    16.513     0.200
     7.117    18.542     0.200
     7.134    16.941     0.200
     7.214    19.005     0.200
     7.254    18.441     0.200
     7.292    16.848     0.200
     7.293    16.435     0.200
     7.315    18.992     0.200
     7.375    18.214     0.200
     7.379    19.185     0.200
     7.383    18.649     0.200
     7.462    19.473     0.200
     7.479    17.291     0.200
     7.481    18.963     0.200
     7.497    19.064     0.200
     7.491    19.320     0.200
     7.567    18.476     0.200
     7.609    16.364     0.200
     7.608    17.528     0.200
     7.608    17.309     0.200
     7.813    18.405     0.200
     7.842    19.195     0.200
     7.868    18.557     0.200
     7.875    19.723     0.200
     7.987    19.164     0.200
     8.044    20.340     0.200
     8.875    20.954     0.200
     9.060    22.678     0.200
     9.175    22.504     0.200
     9.268    21.267     0.200
     9.313    21.167     0.200
     9.482    22.948     0.200
     9.495    22.137     0.200
     9.640    23.338     0.200
    10.353    21.746     0.200
    10.434    24.728     0.200
    10.757    26.070     0.200
    13.002    29.388     0.200
    13.857    29.231     0.200
     1.781     8.577     0.200
     1.873     9.041     0.200
     1.933     9.713     0.200
     1.929     9.446     0.200
     1.956     9.656     0.200
     2.016     9.213     0.200
     2.082    10.187     0.200
     2.076     9.411     0.200
     2.142    10.603     0.200
     2.143     9.920     0.200
     2.219     9.734     0.200
     2.229     9.651     0.200
     2.481    11.186     0.200
     2.444    10.208     0.200
     2.528    11.532     0.200
     2.542    11.692     0.200
     2.566    11.775     0.200
     2.574    11.776     0.200
     2.846    11.728     0.200
     2.916    12.318     0.200
     2.827    10.478     0.200
     2.912    11.239     0.200
     2.921    11.165     0.200
     3.132    11.596     0.200
     3.090    10.540     0.200
     3.261    12.961     0.200
     3.517    12.116     0.200
     3.645    13.677     0.200
     3.670    13.412     0.200
     3.744    13.664     0.200
     3.774    13.674     0.200
     3.776    13.627     0.200
     3.715    12.366     0.200
     3.749    12.275     0.200
     3.948    13.182     0.200
     4.389    14.450     0.200
     4.391    14.722     0.200
     4.351    14.032     0.200
     4.400    15.071     0.200
     4.463    15.406     0.200
     4.468    15.374     0.200
     4.498    14.861     0.200
     4.500    14.938     0.200
     4.574    15.152     0.200
     4.578    14.590     0.200
     4.489    13.587     0.200
     4.781    15.009     0.200
     4.901    14.770     0.200
     5.137    15.129     0.200
     5.157    15.205     0.200
     5.215    15.780     0.200
     5.225    14.383     0.200
     5.362    15.971     0.200
     5.446    16.022     0.200
     5.443    16.450     0.200
     5.516    16.241     0.200
     5.590    16.468     0.200
     5.538    15.708     0.200
     5.676    16.821     0.200
     5.583    15.271     0.200
     5.686    16.674     0.200
     5.774    17.160     0.200
     5.793    16.657     0.200
     5.797    16.510     0.200
     5.898    16.837     0.200
     5.979    17.043     0.200
     5.993    17.289     0.200
     6.099    18.253     0.200
     6.097    17.267     0.200
     6.210    18.074     0.200
     6.294    18.302     0.200
     6.238    16.837     0.200
     6.340    18.896     0.200
     6.383    18.000     0.200
     6.425    18.866     0.200
     6.515    18.691     0.200
     6.552    18.899     0.200
     6.577    18.411     0.200
     6.625    19.268     0.200
     6.653    18.754     0.200
     6.679    19.384     0.200
     6.771    19.014     0.200
     6.732    19.646     0.200
     6.819    19.351     0.200
     6.836    19.217     0.200
     6.854    19.040     0.200
     6.837    18.986     0.200
     6.837    19.181     0.200
     6.902    19.063     0.200
     6.903    19.424     0.200
     6.939    19.607     0.200
     6.977    20.037     0.200
     6.993    19.951     0.200
     6.986    19.708     0.200
     7.084    20.558     0.200
     7.016    19.122     0.200
     7.201    19.967     0.200
     7.204    19.754     0.200
     7.167    19.993     0.200
     7.198    20.361     0.200
     7.357    19.685     0.200
     7.362    20.671     0.200
     7.560    21.010     0.200
     7.500    22.522     0.200
     7.676    21.262     0.200
     7.788    21.256     0.200
     7.997    20.680     0.200
     8.003    20.864     0.200
     8.023    21.301     0.200
     8.175    21.657     0.200
     8.230    21.432     0.200
     8.297    21.774     0.200
     8.375    22.841     0.200
     8.413    21.882     0.200
     8.303    20.453     0.200
     8.438    22.413     0.200
     8.468    21.868     0.200
     8.491    22.061     0.200
     8.491    21.998     0.200
     8.491    22.096     0.200
     8.422    21.006     0.200
     8.538    23.632     0.200
     8.932    22.854     0.200
     9.187    23.561     0.200
     9.136    24.110     0.200
     9.412    23.871     0.200
     9.330    22.833     0.200
     9.465    24.396     0.200
     9.659    26.464     0.200
     9.807    24.725     0.200
     9.855    23.815     0.200
     9.843    25.888     0.200
     9.821    26.024     0.200
    10.061    26.401     0.200
    10.417    27.174     0.200
    10.513    25.774     0.200
    11.119    26.120     0.200
    11.952    27.844     0.200
    11.952    28.921     0.200
    12.153    29.287     0.200
    12.265    30.201     0.200
    12.354    32.330     0.200
    14.476    34.722     0.200
    14.476    35.132     0.200
    19.499    41.657     0.200
    19.920    39.126     0.200
    19.926    38.962     0.200
    20.040    40.226     0.200
    20.741    39.912     0.200
     1.328     7.389     0.200
     1.328     7.709     0.200
     1.328     6.967     0.200
     1.850     8.821     0.200
     1.877     8.879     0.200
     1.939     9.088     0.200
     1.959     9.106     0.200
     1.993     9.214     0.200
     2.027     9.527     0.200
     2.029     9.235     0.200
     2.138    10.170     0.200
     2.174     9.549     0.200
     2.214     9.841     0.200
     2.302     9.847     0.200
     2.405    10.409     0.200
     2.411    10.958     0.200
     2.610     9.593     0.200
     2.701    10.222     0.200
     2.701     9.872     0.200
     2.814    12.064     0.200
     2.849    12.215     0.200
     2.857    12.228     0.200
     3.213    11.641     0.200
     3.234    11.553     0.200
     3.269    12.455     0.200
     3.440    11.954     0.200
     3.465    10.991     0.200
     3.502    11.613     0.200
     3.568    13.514     0.200
     3.958    13.674     0.200
     3.980    13.935     0.200
     4.085    14.146     0.200
     4.090    14.078     0.200
     4.165    11.373     0.200
     4.319    13.602     0.200
     4.722    14.820     0.200
     4.716    14.774     0.200
     4.724    15.514     0.200
     4.740    14.352     0.200
     4.793    15.739     0.200
     4.828    15.751     0.200
     4.914    13.447     0.200
     4.938    16.118     0.200
     4.948    14.573     0.200
     5.132    15.221     0.200
     5.295    15.321     0.200
     5.453    14.497     0.200
     5.518    15.406     0.200
     5.529    14.573     0.200
     5.549    16.386     0.200
     5.555    14.286     0.200
     5.673    15.336     0.200
     5.734    15.659     0.200
     5.744    15.690     0.200
     5.830    15.939     0.200
     5.894    16.018     0.200
     5.921    14.758     0.200
     5.982    15.891     0.200
     6.069    16.312     0.200
     6.080    16.988     0.200
     6.159    16.700     0.200
     6.180    16.906     0.200
     6.186    17.148     0.200
     6.333    16.739     0.200
     6.335    15.973     0.200
     6.373    16.833     0.200
     6.383    17.133     0.200
     6.416    17.776     0.200
     6.484    17.672     0.200
     6.599    17.512     0.200
     6.695    17.333     0.200
     6.760    17.823     0.200
     6.771    18.628     0.200
     6.816    18.310     0.200
     6.902    18.173     0.200
     6.943    19.410     0.200
     6.942    18.198     0.200
     6.974    18.658     0.200
     7.114    18.485     0.200
     7.152    19.028     0.200
     7.209    19.447     0.200
     7.228    19.230     0.200
     7.226    19.633     0.200
     7.227    19.220     0.200
     7.231    19.640     0.200
     7.294    19.022     0.200
     7.331    19.289     0.200
     7.396    20.364     0.200
     7.426    18.192     0.200
     7.467    17.459     0.200
     7.498    18.738     0.200
     7.556    20.208     0.200
     7.546    20.076     0.200
     7.589    19.658     0.200
     7.588    20.021     0.200
     7.687    19.953     0.200
     7.676    20.978     0.200
     7.865    22.720     0.200
     7.907    20.204     0.200
     8.043    21.182     0.200
     8.145    20.110     0.200
     8.313    22.282     0.200
     8.345    21.176     0.200
     8.380    20.704     0.200
     8.386    21.920     0.200
     8.513    21.745     0.200
     8.589    20.319     0.200
     8.626    21.183     0.200
     8.643    22.642     0.200
     8.768    22.712     0.200
     8.795    21.795     0.200
     8.798    22.933     0.200
     8.821    21.272     0.200
     8.856    22.476     0.200
     8.856    21.499     0.200
     8.856    21.762     0.200
     8.915    23.747     0.200
     8.980    22.127     0.200
     9.006    21.245     0.200
     9.006    23.906     0.200
     9.267    24.148     0.200
     9.311    23.556     0.200
     9.493    24.175     0.200
     9.628    22.613     0.200
     9.780    24.435     0.200
     9.917    24.091     0.200
     9.973    25.422     0.200
    10.014    25.703     0.200
    10.159    26.662     0.200
    10.196    24.804     0.200
    10.236    25.495     0.200
    10.393    25.404     0.200
    10.488    26.067     0.200
    10.780    25.367     0.200
    11.629    27.395     0.200
    12.278    29.164     0.200
    12.278    28.992     0.200
    12.363    29.181     0.200
    12.423    30.518     0.200
    12.479    30.093     0.200
    12.479    32.288     0.200
    12.689    33.214     0.200
    12.689    32.198     0.200
    14.863    35.268     0.200
    14.863    34.573     0.200
    15.316    35.384     0.200
    19.501    39.935     0.200
    20.209    39.073     0.200
    20.649    38.598     0.200
     1.503     8.841     0.200
     1.503     8.690     0.200
     2.195    10.216     0.200
     2.217    10.335     0.200
     2.313    10.771     0.200
     2.325    11.010     0.200
     2.334    10.928     0.200
     2.366    11.068     0.200
     2.527    10.979     0.200
     2.673    12.663     0.200
     2.918    11.143     0.200
     3.063    13.106     0.200
     3.100    13.593     0.200
     3.361    13.181     0.200
     3.440    13.876     0.200
     3.495    13.217     0.200
     3.641    13.106     0.200
     3.707    13.384     0.200
     4.207    15.135     0.200
     4.310    15.317     0.200
     4.377    13.394     0.200
     4.706    15.451     0.200
     5.003    16.909     0.200
     5.016    16.633     0.200
     5.034    16.481     0.200
     5.085    16.033     0.200
     5.305    16.602     0.200
     5.437    15.090     0.200
     5.685    16.591     0.200
     5.748    17.766     0.200
     5.796    17.126     0.200
     5.786    17.407     0.200
     5.865    17.476     0.200
     5.965    17.436     0.200
     6.011    17.714     0.200
     6.072    17.715     0.200
     6.106    17.683     0.200
     6.136    15.604     0.200
     6.150    17.767     0.200
     6.253    18.725     0.200
     6.343    19.013     0.200
     6.380    18.394     0.200
     6.634    19.089     0.200
     6.672    19.111     0.200
     6.819    20.280     0.200
     6.852    19.659     0.200
     6.904    18.974     0.200
     6.969    19.651     0.200
     6.986    20.254     0.200
     7.023    19.538     0.200
     7.067    20.011     0.200
     7.161    20.974     0.200
     7.197    20.426     0.200
     7.269    21.090     0.200
     7.299    20.978     0.200
     7.284    20.500     0.200
     7.313    21.253     0.200
     7.350    21.224     0.200
     7.353    21.037     0.200
     7.336    20.770     0.200
     7.555    20.462     0.200
     7.890    21.524     0.200
     8.183    19.849     0.200
     8.232    20.421     0.200
     8.297    23.084     0.200
     8.483    23.505     0.200
     8.540    22.715     0.200
     8.805    23.974     0.200
     9.002    24.209     0.200
     9.002    24.008     0.200
     9.704    23.826     0.200
    10.268    27.937     0.200
    10.273    27.374     0.200
    12.516    33.573     0.200
    14.942    37.590     0.200
    14.942    37.859     0.200
     0.615     4.854     0.200
     0.669     4.665     0.200
     0.717     5.174     0.200
     0.758     5.255     0.200
     0.768     5.318     0.200
     0.821     5.911     0.200
     0.832     5.785     0.200
     0.887     5.845     0.200
     1.044     5.949     0.200
     1.165     6.370     0.200
     1.158     6.541     0.200
     1.188     6.495     0.200
     1.237     7.160     0.200
     1.210     6.792     0.200
     1.340     6.824     0.200
     1.473     7.025     0.200
     1.454     7.363     0.200
     1.505     7.157     0.200
     1.658     7.926     0.200
     1.675     7.952     0.200
     1.688     7.983     0.200
     2.290     9.233     0.200
     2.331    10.011     0.200
     2.353     9.056     0.200
     2.350     9.124     0.200
     2.650     8.788     0.200
     2.750     8.769     0.200
     2.852    10.655     0.200
     2.957    10.773     0.200
     2.993    10.176     0.200
     3.149    10.682     0.200
     3.469    11.031     0.200
     3.623    10.892     0.200
     3.694    12.252     0.200
     3.737    11.896     0.200
     4.051    12.365     0.200
     4.251    12.068     0.200
     4.467    13.272     0.200
     4.756    12.975     0.200
     4.792    12.750     0.200
     4.957    12.377     0.200
     5.091    13.479     0.200
     5.156    13.361     0.200
     5.280    14.696     0.200
     5.289    14.849     0.200
     5.361    14.699     0.200
     5.501    14.442     0.200
     5.620    15.034     0.200
     5.804    16.171     0.200
     5.852    15.733     0.200
     5.923    17.060     0.200
     6.049    16.246     0.200
     6.228    15.805     0.200
     6.322    17.585     0.200
     6.409    16.477     0.200
     6.414    16.379     0.200
     6.423    16.476     0.200
     6.537    16.636     0.200
     6.542    17.736     0.200
     6.706    17.353     0.200
     6.784    17.499     0.200
     6.815    17.591     0.200
     6.866    17.837     0.200
     6.907    17.661     0.200
     7.182    18.019     0.200
     7.309    18.769     0.200
     7.371    18.786     0.200
     7.550    20.469     0.200
     7.557    18.971     0.200
     7.551    20.115     0.200
     7.584    17.557     0.200
     7.837    19.276     0.200
     7.879    18.374     0.200
     7.879    18.834     0.200
     7.909    18.786     0.200
     7.998    20.565     0.200
     8.114    19.360     0.200
     8.089    19.458     0.200
     8.295    20.577     0.200
     8.460    20.053     0.200
     9.418    23.639     0.200
    10.161    21.805     0.200
    10.212    24.914     0.200
    10.285    24.126     0.200
    12.748    30.058     0.200
    14.046    31.211     0.200
    14.232    32.993     0.200
     0.338     7.600     0.200
     0.423     7.410     0.200
     0.686     6.719     0.200
     0.736     6.479     0.200
     0.856     7.085     0.200
     0.858     7.342     0.200
     0.871     7.625     0.200
     0.897     6.826     0.200
     0.947     6.437     0.200
     0.947     6.268     0.200
     1.062     6.751     0.200
     1.569     7.986     0.200
     1.582     7.886     0.200
     1.575     8.671     0.200
     1.623     8.204     0.200
     1.641     7.928     0.200
     1.654     8.201     0.200
     1.686     8.127     0.200
     1.745     8.475     0.200
     1.833     8.766     0.200
     1.929     7.847     0.200
     1.971     7.659     0.200
     2.035     9.060     0.200
     2.140     9.418     0.200
     2.177     9.059     0.200
     2.760    10.156     0.200
     2.806    10.542     0.200
     2.824     9.620     0.200
     2.863    10.571     0.200
     2.876    10.943     0.200
     2.920    10.874     0.200
     3.210    11.365     0.200
     3.279    10.544     0.200
     3.320    11.653     0.200
     3.354    10.453     0.200
     3.368    10.727     0.200
     3.650    11.790     0.200
     3.734    12.399     0.200
     3.862    12.632     0.200
     3.855    11.045     0.200
     3.932    12.289     0.200
     3.935    11.257     0.200
     3.950    12.961     0.200
     4.058    11.568     0.200
     4.115    10.982     0.200
     4.143    11.833     0.200
     4.309    10.991     0.200
     4.413    11.776     0.200
     4.466    14.458     0.200
     4.546    12.194     0.200
     4.554    13.877     0.200
     4.796    12.981     0.200
     4.870    13.580     0.200
     4.910    14.397     0.200
     4.928    13.216     0.200
     4.986    13.373     0.200
     4.991    14.414     0.200
     5.230    13.595     0.200
     5.232    15.409     0.200
     5.240    15.405     0.200
     5.435    15.496     0.200
     5.450    14.401     0.200
     5.455    14.945     0.200
     5.467    14.994     0.200
     5.535    14.945     0.200
     5.596    15.473     0.200
     5.680    14.757     0.200
     5.730    15.693     0.200
     5.763    15.308     0.200
     5.780    15.110     0.200
     5.806    15.211     0.200
     5.847    15.439     0.200
     5.890    15.649     0.200
     6.031    16.117     0.200
     6.100    15.948     0.200
     6.238    15.786     0.200
     6.265    17.363     0.200
     6.275    16.325     0.200
     6.280    16.278     0.200
     6.387    16.713     0.200
     6.473    16.702     0.200
     6.479    16.006     0.200
     6.559    16.012     0.200
     6.604    16.185     0.200
     6.695    17.426     0.200
     6.696    16.692     0.200
     6.748    17.087     0.200
     6.772    16.528     0.200
     6.780    18.283     0.200
     6.821    17.854     0.200
     6.967    17.286     0.200
     6.975    17.283     0.200
     7.073    15.568     0.200
     7.073    16.782     0.200
     7.073    17.332     0.200
     7.076    17.671     0.200
     7.158    17.608     0.200
     7.215    18.265     0.200
     7.217    18.494     0.200
     7.472    18.077     0.200
     7.502    19.721     0.200
     7.603    19.095     0.200
     8.077    19.366     0.200
     8.139    19.583     0.200
     8.227    20.776     0.200
     8.518    20.801     0.200
     8.525    20.983     0.200
     8.529    20.511     0.200
     8.607    20.843     0.200
     8.663    20.306     0.200
     8.854    21.709     0.200
     8.896    20.515     0.200
     8.976    20.320     0.200
     9.448    21.267     0.200
     9.541    23.871     0.200
     9.790    22.121     0.200
     9.843    21.500     0.200
     9.862    24.336     0.200
    10.153    23.813     0.200
    10.334    25.218     0.200
    12.387    29.239     0.200
    12.387    29.104     0.200
    13.272    28.938     0.200
    13.272    28.258     0.200
    19.926    36.504     0.200
     0.426     4.170     0.200
     0.542     4.169     0.200
     1.230     6.715     0.200
     1.178     5.904     0.200
     1.178     6.108     0.200
     1.178     6.348     0.200
     1.309     7.017     0.200
     1.334     6.962     0.200
     1.348     6.765     0.200
     1.408     7.085     0.200
     1.549     7.497     0.200
     1.600     7.695     0.200
     1.727     8.089     0.200
     2.126     8.105     0.200
     2.169     8.110     0.200
     2.209     8.839     0.200
     2.257     8.236     0.200
     2.437     7.972     0.200
     2.420    10.512     0.200
     2.860     9.734     0.200
     3.013    10.184     0.200
     2.986    10.714     0.200
     2.997    10.996     0.200
     3.048    10.464     0.200
     3.170    11.582     0.200
     3.283    10.533     0.200
     3.522    11.915     0.200
     3.567    12.327     0.200
     3.583    12.056     0.200
     3.616    12.588     0.200
     3.688    12.322     0.200
     3.701    12.468     0.200
     3.717    12.175     0.200
     3.883    10.765     0.200
     4.188    13.060     0.200
     4.350    13.524     0.200
     4.461    13.994     0.200
     4.548    12.561     0.200
     4.594    12.774     0.200
     4.682    12.576     0.200
     4.713    13.340     0.200
     4.719    13.493     0.200
     4.827    14.098     0.200
     4.916    12.662     0.200
     4.926    13.385     0.200
     5.142    14.348     0.200
     5.190    15.301     0.200
     5.266    14.053     0.200
     5.296    13.988     0.200
     5.326    14.168     0.200
     5.358    13.678     0.200
     5.501    15.068     0.200
     5.496    13.430     0.200
     5.614    14.609     0.200
     5.655    14.672     0.200
     5.658    14.613     0.200
     5.684    15.473     0.200
     5.757    15.056     0.200
     5.852    15.312     0.200
     5.913    14.746     0.200
     5.989    15.862     0.200
     6.015    17.078     0.200
     6.005    15.655     0.200
     6.016    15.818     0.200
     6.094    15.696     0.200
     6.170    15.719     0.200
     6.194    16.261     0.200
     6.252    16.244     0.200
     6.266    15.829     0.200
     6.359    15.846     0.200
     6.441    15.617     0.200
     6.540    17.726     0.200
     6.562    16.971     0.200
     6.665    16.633     0.200
     6.770    17.892     0.200
     6.786    18.340     0.200
     6.739    16.981     0.200
     6.819    17.130     0.200
     6.844    17.154     0.200
     6.966    18.200     0.200
     6.947    17.422     0.200
     6.969    17.181     0.200
     6.994    17.907     0.200
     7.097    18.529     0.200
     7.167    17.502     0.200
     7.139    17.814     0.200
     7.149    17.876     0.200
     7.250    18.905     0.200
     7.228    18.183     0.200
     7.310    19.176     0.200
     7.274    17.897     0.200
     7.312    18.158     0.200
     7.333    18.318     0.200
     7.420    19.273     0.200
     7.501    18.831     0.200
     7.684    17.418     0.200
     7.640    18.833     0.200
     7.717    19.126     0.200
     7.682    19.098     0.200
     7.797    18.570     0.200
     7.922    19.400     0.200
     8.014    18.968     0.200
     8.078    19.124     0.200
     8.061    19.384     0.200
     8.198    20.637     0.200
     8.182    19.641     0.200
     8.244    20.793     0.200
     8.244    20.789     0.200
     8.231    19.493     0.200
     8.290    19.556     0.200
     8.330    21.056     0.200
     8.489    21.710     0.200
     8.504    20.253     0.200
     8.484    21.319     0.200
     8.578    19.339     0.200
     8.577    20.052     0.200
     8.577    20.652     0.200
     8.622    21.690     0.200
     8.754    22.329     0.200
     8.689    21.213     0.200
     8.753    21.665     0.200
     8.780    21.510     0.200
     8.729    20.504     0.200
     9.034    22.273     0.200
     9.056    22.073     0.200
     9.076    21.180     0.200
     9.354    23.386     0.200
     9.340    21.627     0.200
     9.440    23.267     0.200
    10.046    24.699     0.200
    10.151    24.451     0.200
    10.242    24.473     0.200
    10.445    24.187     0.200
    10.491    26.144     0.200
    10.439    25.181     0.200
    10.648    25.151     0.200
    10.689    24.597     0.200
    10.993    26.551     0.200
    11.799    29.759     0.200
    11.883    29.691     0.200
    11.883    28.528     0.200
    12.919    31.154     0.200
    12.975    31.468     0.200
    12.976    31.122     0.200
    14.693    32.731     0.200
    15.806    36.547     0.200
    19.979    38.697     0.200
    20.211    38.474     0.200
    20.571    38.086     0.200
    20.752    38.431     0.200
     0.650     7.175     0.200
     0.714     6.610     0.200
     0.754     6.317     0.200
     0.748     7.117     0.200
     0.821     6.422     0.200
     0.856     6.489     0.200
     0.933     6.521     0.200
     0.931     6.857     0.200
     1.035     6.876     0.200
     1.077     6.779     0.200
     1.246     7.077     0.200
     1.226     7.633     0.200
     1.597     6.625     0.200
     1.513     7.496     0.200
     1.577     7.571     0.200
     1.660     7.490     0.200
     1.837     8.067     0.200
     1.857     8.622     0.200
     1.865     8.328     0.200
     1.928     8.566     0.200
     2.154     8.452     0.200
     2.346     9.253     0.200
     2.408     9.543     0.200
     2.513     9.834     0.200
     2.524     9.826     0.200
     2.782     9.860     0.200
     2.907     9.181     0.200
     3.211     9.786     0.200
     3.170    10.764     0.200
     3.165    10.499     0.200
     3.557    11.018     0.200
     4.191    11.938     0.200
     4.302    11.555     0.200
     4.343    11.400     0.200
     4.473    11.696     0.200
     4.538    11.390     0.200
     4.601    12.453     0.200
     4.681    13.091     0.200
     4.715    12.159     0.200
     4.865    13.401     0.200
     4.972    13.974     0.200
     5.092    13.484     0.200
     5.128    14.311     0.200
     5.832    14.532     0.200
     5.934    16.182     0.200
     6.075    15.500     0.200
     6.400    17.128     0.200
     7.068    15.781     0.200
     7.399    15.730     0.200
     7.899    18.470     0.200
     8.070    18.922     0.200
     9.851    23.190     0.200
     1.756    11.270     0.200
     2.105    11.739     0.200
     2.195    11.564     0.200
     2.334    12.865     0.200
     2.432    13.019     0.200
     2.605    12.052     0.200
     2.710    12.976     0.200
     3.469    14.903     0.200
     3.948    15.868     0.200
     4.094    16.508     0.200
     4.189    16.674     0.200
     4.376    16.113     0.200
     4.550    16.700     0.200
     4.665    16.945     0.200
     4.916    18.680     0.200
     4.955    17.511     0.200
     4.974    18.476     0.200
     5.359    18.450     0.200
     5.429    18.682     0.200
     5.704    18.609     0.200
     5.764    20.460     0.200
     6.038    19.348     0.200
     6.050    20.953     0.200
     6.198    20.935     0.200
     6.235    20.129     0.200
     6.271    19.702     0.200
     6.574    22.003     0.200
     6.746    21.633     0.200
     7.132    22.285     0.200
     7.150    22.080     0.200
     7.347    22.559     0.200
     7.523    23.390     0.200
     7.531    23.612     0.200
     7.670    23.253     0.200
     7.669    23.268     0.200
     7.669    23.317     0.200
     7.671    24.380     0.200
     7.900    24.354     0.200
     8.012    23.658     0.200
     8.891    25.624     0.200
     9.371    26.699     0.200
     9.605    28.360     0.200
    10.748    30.082     0.200
    13.199    34.205     0.200
    13.944    34.466     0.200
     0.438     6.533     0.200
     0.730     6.619     0.200
     0.749     6.924     0.200
     0.722     6.287     0.200
     0.768     6.760     0.200
     0.777     7.037     0.200
     0.802     6.339     0.200
     0.897     6.359     0.200
     0.877     6.097     0.200
     1.112     6.522     0.200
     1.154     6.874     0.200
     1.250     6.803     0.200
     1.313     7.758     0.200
     1.284     6.941     0.200
     1.359     7.530     0.200
     1.345     7.226     0.200
     1.401     6.734     0.200
     1.406     7.394     0.200
     1.379     7.213     0.200
     1.447     7.400     0.200
     1.460     7.180     0.200
     1.651     7.462     0.200
     1.819     8.097     0.200
     1.884     8.354     0.200
     1.868     8.206     0.200
     1.879     8.146     0.200
     1.914     8.796     0.200
     1.950     8.364     0.200
     1.989     9.031     0.200
     2.002     8.731     0.200
     1.985     8.494     0.200
     2.044     8.585     0.200
     2.132     7.891     0.200
     2.133     9.233     0.200
     2.350    10.943     0.200
     2.427     8.231     0.200
     2.638    10.038     0.200
     2.638    10.038     0.200
     2.746    10.413     0.200
     2.769    10.674     0.200
     2.764     9.447     0.200
     2.973    11.094     0.200
     3.030    10.424     0.200
     3.086     9.850     0.200
     3.107    10.908     0.200
     3.119    10.323     0.200
     3.191    10.958     0.200
     3.330    10.166     0.200
     3.473    11.162     0.200
     3.609    10.570     0.200
     3.634    10.848     0.200
     3.674    10.773     0.200
     3.814    11.089     0.200
     3.828    10.355     0.200
     3.847    11.659     0.200
     4.018    10.504     0.200
     4.013    11.757     0.200
     4.053    12.300     0.200
     4.127    11.385     0.200
     4.150    11.606     0.200
     4.237    11.731     0.200
     4.250    11.725     0.200
     4.322    13.290     0.200
     4.352    12.765     0.200
     4.478    12.369     0.200
     4.507    12.386     0.200
     4.521    13.103     0.200
     4.687    12.894     0.200
     4.707    13.767     0.200
     4.868    13.516     0.200
     4.848    14.095     0.200
     4.936    12.906     0.200
     4.946    13.509     0.200
     4.981    13.604     0.200
     5.050    14.786     0.200
     5.150    13.726     0.200
     5.169    14.408     0.200
     5.158    14.376     0.200
     5.246    14.532     0.200
     5.305    14.479     0.200
     5.299    14.713     0.200
     5.300    14.948     0.200
     5.380    14.324     0.200
     5.488    14.501     0.200
     5.494    15.020     0.200
     5.516    14.925     0.200
     5.528    15.079     0.200
     5.552    14.439     0.200
     5.588    14.925     0.200
     5.603    15.540     0.200
     5.669    14.337     0.200
     5.734    15.373     0.200
     5.773    15.203     0.200
     5.857    15.407     0.200
     5.940    15.375     0.200
     5.948    15.876     0.200
     5.952    16.068     0.200
     5.982    15.321     0.200
     6.087    16.555     0.200
     6.101    16.414     0.200
     6.183    17.186     0.200
     6.306    16.326     0.200
     6.345    16.857     0.200
     6.357    15.663     0.200
     6.396    17.153     0.200
     6.394    15.940     0.200
     6.521    17.634     0.200
     6.530    16.595     0.200
     6.539    17.236     0.200
     6.569    16.192     0.200
     6.777    16.798     0.200
     6.768    16.757     0.200
     6.782    16.750     0.200
     6.860    16.254     0.200
     6.860    16.383     0.200
     7.072    17.427     0.200
     7.132    17.931     0.200
     7.174    17.685     0.200
     7.398    18.929     0.200
     7.782    18.915     0.200
     7.797    18.917     0.200
     8.314    20.862     0.200
     8.405    20.646     0.200
     8.579    21.542     0.200
     8.748    19.076     0.200
     8.816    20.476     0.200
     9.571    21.854     0.200
     9.653    21.085     0.200
     9.643    21.245     0.200
     9.863    23.080     0.200
    12.094    27.055     0.200
    13.026    28.576     0.200
     0.058    13.107     0.200
     0.308    10.012     0.200
     0.353    10.330     0.200
     0.546     9.453     0.200
     0.586     9.543     0.200
     0.718     9.014     0.200
     0.723     8.487     0.200
     0.933     9.448     0.200
     0.948     9.431     0.200
     0.953     9.372     0.200
     1.352     8.504     0.200
     1.553     9.548     0.200
     1.618     9.601     0.200
     1.769     9.400     0.200
     1.865     9.036     0.200
     1.991     7.506     0.200
     2.036    10.259     0.200
     2.125    10.745     0.200
     2.142     8.776     0.200
     2.213    10.678     0.200
     2.253    10.268     0.200
     2.671     9.978     0.200
     2.698    12.128     0.200
     2.761    10.148     0.200
     2.867    11.595     0.200
     2.937     9.542     0.200
     2.937    11.932     0.200
     2.944    12.210     0.200
     2.986    11.822     0.200
     3.163    10.642     0.200
     3.353    12.155     0.200
     3.430    12.256     0.200
     3.439    11.526     0.200
     3.551    12.024     0.200
     3.632    12.501     0.200
     3.713    12.244     0.200
     3.811    11.425     0.200
     4.007    11.511     0.200
     4.007    11.632     0.200
     4.110    11.853     0.200
     4.207    12.506     0.200
     4.213    11.687     0.200
     4.213    11.918     0.200
     4.336    11.280     0.200
     4.390    12.190     0.200
     4.426    12.204     0.200
     4.458    14.609     0.200
     4.489    15.101     0.200
     4.543    11.537     0.200
     4.633    12.429     0.200
     4.657    12.888     0.200
     4.745    12.957     0.200
     4.793    12.931     0.200
     4.794    13.293     0.200
     5.001    14.988     0.200
     5.010    15.735     0.200
     5.022    13.545     0.200
     5.028    13.550     0.200
     5.138    14.024     0.200
     5.186    14.953     0.200
     5.233    15.013     0.200
     5.245    14.114     0.200
     5.261    14.372     0.200
     5.296    15.595     0.200
     5.471    14.233     0.200
     5.546    15.011     0.200
     5.551    14.878     0.200
     5.551    15.008     0.200
     5.573    15.619     0.200
     5.604    15.226     0.200
     5.639    15.381     0.200
     5.660    14.871     0.200
     5.669    14.809     0.200
     5.712    14.958     0.200
     5.738    17.044     0.200
     5.799    15.775     0.200
     5.817    15.869     0.200
     5.871    15.709     0.200
     5.942    15.441     0.200
     5.952    15.473     0.200
     6.086    16.261     0.200
     6.105    16.358     0.200
     6.135    15.678     0.200
     6.156    15.984     0.200
     6.197    15.967     0.200
     6.223    16.039     0.200
     6.232    16.935     0.200
     6.300    16.728     0.200
     6.344    18.172     0.200
     6.414    17.207     0.200
     6.417    16.465     0.200
     6.546    16.409     0.200
     6.645    16.057     0.200
     6.724    16.934     0.200
     6.853    16.511     0.200
     6.853    16.623     0.200
     6.859    16.271     0.200
     6.932    17.488     0.200
     6.995    17.152     0.200
     7.046    16.980     0.200
     7.049    17.041     0.200
     7.049    16.958     0.200
     7.095    18.725     0.200
     7.124    18.179     0.200
     7.172    16.956     0.200
     7.171    17.077     0.200
     7.171    17.030     0.200
     7.245    17.874     0.200
     7.348    17.523     0.200
     7.352    18.548     0.200
     7.357    18.103     0.200
     7.370    17.346     0.200
     7.455    18.983     0.200
     7.472    19.619     0.200
     7.610    18.928     0.200
     7.612    19.321     0.200
     7.623    19.424     0.200
     7.639    18.597     0.200
     7.650    18.841     0.200
     7.684    19.340     0.200
     7.755    18.837     0.200
     7.753    20.326     0.200
     8.017    22.349     0.200
     8.269    20.466     0.200
     8.367    19.931     0.200
     8.795    21.501     0.200
     8.826    20.404     0.200
     8.913    21.509     0.200
     9.045    21.539     0.200
     9.062    20.474     0.200
     9.827    23.071     0.200
     9.911    23.131     0.200
    10.061    23.865     0.200
    10.156    24.162     0.200
    10.233    21.512     0.200
    10.287    25.921     0.200
    10.348    23.764     0.200
    10.348    23.915     0.200
    10.449    23.509     0.200
    11.263    25.460     0.200
    11.934    24.311     0.200
    11.991    25.058     0.200
    12.679    29.074     0.200
    13.337    27.822     0.200
    13.414    28.422     0.200
    14.367    30.096     0.200
     0.346    15.949     0.200
     0.365    15.948     0.200
     0.453    15.305     0.200
     0.457    15.313     0.200
     0.544    14.668     0.200
     0.571    14.367     0.200
     0.676    13.760     0.200
     0.701    13.891     0.200
     0.695    13.776     0.200
     1.122    12.612     0.200
     1.123    12.865     0.200
     1.145    12.690     0.200
     1.666    11.962     0.200
     1.720    11.889     0.200
     1.696    10.319     0.200
     1.834    10.175     0.200
     2.077    11.878     0.200
     2.115    11.912     0.200
     2.150    11.896     0.200
     2.155    12.176     0.200
     2.186    11.931     0.200
     2.219    11.320     0.200
     2.279    11.928     0.200
     2.349    12.048     0.200
     2.385    11.883     0.200
     2.438    11.594     0.200
     2.471    11.162     0.200
     2.522    11.804     0.200
     2.916    12.699     0.200
     2.916    12.580     0.200
     2.941    12.658     0.200
     2.971    11.128     0.200
     3.042    12.971     0.200
     3.270    12.299     0.200
     3.332    12.226     0.200
     3.382    12.511     0.200
     3.554    12.975     0.200
     3.650    12.306     0.200
     3.751    13.534     0.200
     4.096    12.503     0.200
     4.196    12.338     0.200
     4.212    14.391     0.200
     4.340    12.653     0.200
     4.389    13.184     0.200
     4.445    16.625     0.200
     4.429    12.659     0.200
     4.627    13.167     0.200
     4.649    13.362     0.200
     4.651    14.246     0.200
     4.879    13.337     0.200
     4.954    14.407     0.200
     4.943    14.641     0.200
     4.950    16.098     0.200
     5.024    13.713     0.200
     5.056    15.173     0.200
     5.155    14.407     0.200
     5.316    15.091     0.200
     5.291    15.197     0.200
     5.340    15.057     0.200
     5.427    14.760     0.200
     5.627    14.927     0.200
     5.629    16.281     0.200
     5.767    15.293     0.200
     5.812    14.747     0.200
     5.817    15.733     0.200
     5.820    16.023     0.200
     5.874    15.781     0.200
     5.895    16.759     0.200
     5.930    15.440     0.200
     5.945    16.422     0.200
     6.014    16.451     0.200
     6.103    16.237     0.200
     6.126    15.362     0.200
     6.194    16.067     0.200
     6.266    17.589     0.200
     6.271    16.866     0.200
     6.333    16.668     0.200
     6.397    16.089     0.200
     6.494    17.056     0.200
     6.528    17.753     0.200
     6.561    17.674     0.200
     6.675    16.010     0.200
     6.697    15.910     0.200
     6.697    17.602     0.200
     6.805    17.864     0.200
     6.911    16.532     0.200
     6.907    18.648     0.200
     7.077    16.320     0.200
     7.091    16.992     0.200
     7.243    16.574     0.200
     7.243    16.574     0.200
     7.243    16.512     0.200
     7.318    18.474     0.200
     7.315    17.888     0.200
     7.394    18.944     0.200
     7.427    18.348     0.200
     7.512    19.657     0.200
     7.579    21.054     0.200
     7.560    19.091     0.200
     7.771    19.861     0.200
     7.791    19.587     0.200
     7.940    18.237     0.200
     7.962    20.355     0.200
     7.988    20.413     0.200
     8.018    18.952     0.200
     8.054    19.294     0.200
     8.071    19.478     0.200
     8.711    22.086     0.200
     8.786    21.883     0.200
     8.824    21.927     0.200
     8.853    21.796     0.200
     8.931    20.066     0.200
     9.010    19.702     0.200
     9.053    21.991     0.200
     9.105    20.015     0.200
     9.190    22.281     0.200
     9.284    21.999     0.200
     9.569    20.994     0.200
    10.270    24.012     0.200
    10.466    23.937     0.200
    10.621    25.839     0.200
    10.730    23.163     0.200
    10.920    24.654     0.200
    12.446    25.010     0.200
    13.552    27.299     0.200
    13.552    28.037     0.200
    13.957    28.887     0.200
     1.270     5.761     0.200
     1.375     7.128     0.200
     1.320     7.007     0.200
     1.484     7.867     0.200
     1.457     7.857     0.200
     1.495     7.895     0.200
     1.497     7.826     0.200
     1.649     7.044     0.200
     1.835     8.231     0.200
     1.911     8.785     0.200
     1.895     8.146     0.200
     1.957     8.565     0.200
     2.019     8.992     0.200
     2.262     7.738     0.200
     2.195     8.828     0.200
     2.308     8.992     0.200
     2.348     9.230     0.200
     2.383     9.110     0.200
     2.468     9.105     0.200
     3.091    10.115     0.200
     3.104    10.688     0.200
     3.126    11.799     0.200
     3.198    10.089     0.200
     3.234    11.062     0.200
     3.333    10.680     0.200
     3.487    10.737     0.200
     3.517    11.070     0.200
     3.595    10.149     0.200
     3.642    10.652     0.200
     3.667    10.745     0.200
     3.636    11.556     0.200
     3.698    11.759     0.200
     3.815    11.729     0.200
     3.878    11.524     0.200
     4.021    11.105     0.200
     4.087    12.129     0.200
     4.232    11.868     0.200
     4.245    13.214     0.200
     4.281    13.055     0.200
     4.405    12.001     0.200
     4.433    13.012     0.200
     4.580    12.838     0.200
     4.491    13.937     0.200
     4.738    13.655     0.200
     5.191    14.363     0.200
     5.356    15.658     0.200
     5.337    15.234     0.200
     5.361    14.869     0.200
     5.431    15.337     0.200
     5.581    16.360     0.200
     5.712    15.643     0.200
     5.736    16.082     0.200
     5.953    16.158     0.200
     6.214    17.551     0.200
     6.552    15.143     0.200
     6.661    18.408     0.200
     6.892    18.210     0.200
     6.921    17.577     0.200
     7.009    17.253     0.200
     7.009    16.956     0.200
     7.009    17.090     0.200
     7.005    17.593     0.200
     7.889    19.451     0.200
     8.611    21.677     0.200
     8.942    22.806     0.200
     8.936    22.645     0.200
     9.110    21.207     0.200
     9.140    23.873     0.200
     9.333    23.194     0.200
     9.962    21.560     0.200
     1.503    10.458     0.200
     2.597    12.211     0.200
     2.664    12.399     0.200
     2.901    14.111     0.200
     2.952    13.841     0.200
     3.432    15.223     0.200
     3.750    14.708     0.200
     3.846    15.264     0.200
     3.951    15.341     0.200
     3.954    15.262     0.200
     4.167    15.834     0.200
     4.361    15.190     0.200
     4.529    16.953     0.200
     4.521    16.546     0.200
     4.749    16.520     0.200
     4.824    17.221     0.200
     4.867    17.203     0.200
     5.160    18.176     0.200
     5.278    18.313     0.200
     5.319    19.065     0.200
     5.420    18.948     0.200
     5.505    19.813     0.200
     5.590    20.087     0.200
     5.602    18.650     0.200
     5.686    19.231     0.200
     5.640    20.015     0.200
     5.890    20.818     0.200
     5.937    19.581     0.200
     6.258    20.315     0.200
     6.419    20.487     0.200
     6.532    20.334     0.200
     6.535    20.057     0.200
     6.617    20.918     0.200
     6.633    20.557     0.200
     6.677    21.525     0.200
     6.760    21.193     0.200
     6.825    21.333     0.200
     6.829    21.572     0.200
     6.865    21.133     0.200
     6.939    20.956     0.200
     6.939    21.376     0.200
     7.113    21.109     0.200
     7.321    21.262     0.200
     7.341    21.803     0.200
     7.388    22.202     0.200
     7.496    22.403     0.200
     7.881    23.319     0.200
     8.040    22.699     0.200
     8.527    26.122     0.200
     8.566    24.523     0.200
     8.778    25.414     0.200
     8.836    25.280     0.200
     9.714    25.695     0.200
     9.908    28.182     0.200
     9.977    27.615     0.200
    10.166    29.792     0.200
    11.005    29.475     0.200
    12.428    33.127     0.200
    12.428    33.621     0.200
    13.163    34.055     0.200
    13.163    33.325     0.200
    13.211    35.534     0.200
    14.631    38.828     0.200
     1.792     9.789     0.200
     2.224    11.941     0.200
     2.567    11.576     0.200
     2.603    12.129     0.200
     2.616    12.543     0.200
     2.653    11.819     0.200
     2.916    12.997     0.200
     2.969    13.039     0.200
     3.056    13.709     0.200
     3.141    13.442     0.200
     3.459    13.870     0.200
     3.709    13.908     0.200
     3.813    14.481     0.200
     3.807    14.501     0.200
     3.909    14.543     0.200
     3.974    14.692     0.200
     4.016    15.364     0.200
     4.049    13.598     0.200
     4.129    15.172     0.200
     4.346    15.085     0.200
     4.520    14.668     0.200
     4.737    15.756     0.200
     4.748    16.672     0.200
     4.950    17.222     0.200
     5.165    16.963     0.200
     5.187    17.146     0.200
     5.261    17.982     0.200
     5.345    18.322     0.200
     5.373    18.200     0.200
     5.519    18.220     0.200
     5.530    19.305     0.200
     5.530    18.231     0.200
     5.657    18.428     0.200
     5.656    18.872     0.200
     5.825    18.442     0.200
     5.860    18.793     0.200
     5.900    18.292     0.200
     5.948    19.317     0.200
     6.058    18.370     0.200
     6.117    19.581     0.200
     6.154    18.498     0.200
     6.258    19.083     0.200
     6.359    20.107     0.200
     6.459    19.703     0.200
     6.506    21.743     0.200
     6.562    20.357     0.200
     6.572    20.174     0.200
     6.635    20.734     0.200
     6.716    20.453     0.200
     6.763    20.986     0.200
     6.766    20.965     0.200
     6.881    20.427     0.200
     6.881    20.727     0.200
     7.073    20.894     0.200
     7.238    21.147     0.200
     7.405    21.521     0.200
     7.370    22.590     0.200
     7.517    21.782     0.200
     7.825    23.282     0.200
     7.948    22.757     0.200
     7.997    23.292     0.200
     8.071    24.612     0.200
     8.135    23.190     0.200
     8.193    23.678     0.200
     8.168    23.769     0.200
     8.535    23.867     0.200
     8.528    23.811     0.200
     8.547    24.481     0.200
     8.681    24.542     0.200
     8.750    24.201     0.200
     8.812    23.886     0.200
     9.065    24.544     0.200
     9.593    27.094     0.200
     9.582    25.757     0.200
     9.638    25.476     0.200
     9.806    25.620     0.200
     9.939    29.709     0.200
     9.893    25.550     0.200
    10.090    30.082     0.200
    12.456    32.613     0.200
    12.456    32.284     0.200
    13.117    33.665     0.200
    13.117    33.437     0.200
    13.203    34.800     0.200
    19.638    41.742     0.200
     0.750     7.369     0.200
     0.792     7.479     0.200
     0.792     7.504     0.200
     0.925     6.115     0.200
     1.016     7.280     0.200
     1.087     7.111     0.200
     1.096     7.431     0.200
     1.233     7.400     0.200
     1.275     7.311     0.200
     1.330     7.384     0.200
     1.396     7.000     0.200
     1.451     7.851     0.200
     1.525     6.684     0.200
     1.493     7.785     0.200
     1.642     7.726     0.200
     1.764     8.149     0.200
     1.894     8.458     0.200
     2.155     7.892     0.200
     2.189     8.283     0.200
     2.304     7.967     0.200
     2.578     9.783     0.200
     2.806     9.597     0.200
     2.819     9.771     0.200
     2.928    10.143     0.200
     3.337    10.237     0.200
     3.388    10.149     0.200
     3.434    10.359     0.200
     3.554    10.063     0.200
     3.594    10.913     0.200
     3.783    11.175     0.200
     3.854    11.050     0.200
     3.962    11.296     0.200
     3.935    13.175     0.200
     4.107    12.269     0.200
     4.230    12.345     0.200
     4.213    12.970     0.200
     4.311    11.958     0.200
     4.377    12.667     0.200
     4.574    13.036     0.200
     4.533    13.107     0.200
     4.528    13.114     0.200
     4.672    13.091     0.200
     4.739    13.275     0.200
     5.064    13.693     0.200
     5.085    14.238     0.200
     5.232    14.270     0.200
     5.239    14.405     0.200
     5.376    14.345     0.200
     5.354    14.712     0.200
     5.439    15.124     0.200
     5.473    14.818     0.200
     5.533    14.701     0.200
     5.692    15.063     0.200
     5.694    15.400     0.200
     6.138    16.414     0.200
     6.181    15.511     0.200
     6.300    16.359     0.200
     6.336    15.738     0.200
     6.391    16.050     0.200
     6.413    16.454     0.200
     6.464    17.035     0.200
     6.594    16.417     0.200
     6.614    16.376     0.200
     6.672    16.544     0.200
     6.672    16.384     0.200
     6.728    16.471     0.200
     6.776    17.500     0.200
     6.878    17.281     0.200
     6.868    17.656     0.200
     7.324    17.839     0.200
     7.324    19.018     0.200
     7.604    19.037     0.200
     7.934    20.248     0.200
     8.164    19.996     0.200
     8.319    20.902     0.200
     8.590    20.762     0.200
     8.591    21.720     0.200
     8.949    20.518     0.200
     9.109    21.726     0.200
     9.194    22.756     0.200
     9.278    22.474     0.200
     9.373    20.700     0.200
     9.573    23.382     0.200
    10.067    26.420     0.200
    11.097    23.995     0.200
    11.133    25.177     0.200
    11.800    28.616     0.200
    12.797    30.385     0.200
    13.812    31.074     0.200
    15.240    33.438     0.200
     1.132     5.690     0.200
     1.330     6.874     0.200
     1.510     7.390     0.200
     1.481     7.413     0.200
     1.518     7.509     0.200
     1.547     7.893     0.200
     1.560     7.824     0.200
     1.560     7.812     0.200
     1.610     8.042     0.200
     1.787     7.430     0.200
     1.757     7.799     0.200
     1.822     8.351     0.200
     2.005     8.331     0.200
     1.957     7.384     0.200
     2.053     8.294     0.200
     2.083     8.452     0.200
     2.403     8.253     0.200
     2.455     9.364     0.200
     2.587     9.640     0.200
     3.014     9.136     0.200
     3.040     9.020     0.200
     3.230    10.436     0.200
     3.246    11.296     0.200
     3.465    10.759     0.200
     3.586    10.818     0.200
     3.594    11.756     0.200
     3.627    12.171     0.200
     3.735    10.611     0.200
     3.783    11.240     0.200
     3.806    11.043     0.200
     3.858    10.659     0.200
     3.940    11.918     0.200
     4.011    11.703     0.200
     4.029    11.818     0.200
     3.973    11.709     0.200
     4.128    12.260     0.200
     4.205    12.363     0.200
     4.287    12.768     0.200
     4.373    12.559     0.200
     4.423    13.108     0.200
     4.530    13.038     0.200
     4.827    13.699     0.200
     4.859    13.796     0.200
     5.117    14.931     0.200
     5.150    14.717     0.200
     5.212    14.935     0.200
     5.216    14.322     0.200
     5.280    14.280     0.200
     5.300    14.166     0.200
     5.382    14.223     0.200
     5.501    15.199     0.200
     5.535    15.091     0.200
     5.463    15.500     0.200
     5.567    15.047     0.200
     5.690    15.628     0.200
     5.854    15.727     0.200
     5.872    16.119     0.200
     5.901    16.578     0.200
     6.080    15.597     0.200
     6.135    17.881     0.200
     6.245    16.539     0.200
     6.335    16.558     0.200
     6.326    17.452     0.200
     6.600    17.597     0.200
     6.650    17.593     0.200
     6.688    17.032     0.200
     6.669    17.514     0.200
     6.779    17.445     0.200
     6.800    17.395     0.200
     6.894    17.009     0.200
     7.020    17.977     0.200
     7.062    17.934     0.200
     7.061    18.993     0.200
     7.103    17.958     0.200
     7.105    17.922     0.200
     7.140    18.078     0.200
     7.147    17.042     0.200
     7.147    17.472     0.200
     7.156    19.964     0.200
     7.392    18.694     0.200
     7.551    19.468     0.200
     7.828    20.412     0.200
     8.004    19.439     0.200
     8.063    20.978     0.200
     8.463    20.819     0.200
     8.527    22.064     0.200
     8.711    21.886     0.200
     8.667    22.439     0.200
     8.705    23.015     0.200
     8.855    22.134     0.200
     8.951    19.468     0.200
     8.971    20.661     0.200
     9.075    23.116     0.200
     9.055    22.691     0.200
     9.191    23.549     0.200
     9.237    21.945     0.200
     9.245    21.632     0.200
     9.224    22.598     0.200
     9.327    22.828     0.200
     9.362    23.458     0.200
     9.365    23.315     0.200
     9.898    24.533     0.200
     9.960    22.465     0.200
    10.675    26.085     0.200
    10.898    26.563     0.200
    10.880    25.137     0.200
    11.187    26.879     0.200
    11.193    27.117     0.200
    11.506    27.895     0.200
    11.506    27.574     0.200
    11.972    27.807     0.200
    12.262    28.797     0.200
    13.128    30.319     0.200
    13.128    30.623     0.200
    14.762    32.236     0.200
    15.475    32.097     0.200
    15.734    34.762     0.200
    18.801    37.235     0.200
    20.965    37.598     0.200
     0.560     4.963     0.200
     0.738     5.525     0.200
     0.900     6.029     0.200
     0.926     5.747     0.200
     0.945     6.197     0.200
     1.145     5.966     0.200
     1.182     6.469     0.200
     1.108     5.868     0.200
     1.240     6.167     0.200
     1.705     8.354     0.200
     1.733     8.524     0.200
     1.732     8.648     0.200
     1.736     8.541     0.200
     1.751     8.218     0.200
     2.059     7.351     0.200
     2.059     7.502     0.200
     2.339    10.071     0.200
     2.349     9.193     0.200
     2.352     9.163     0.200
     2.647     9.097     0.200
     2.880    11.181     0.200
     2.897    10.289     0.200
     2.802     9.778     0.200
     3.001    10.936     0.200
     3.205    11.603     0.200
     3.384     9.909     0.200
     3.553    11.193     0.200
     3.665    11.041     0.200
     3.697    12.108     0.200
     4.059    11.947     0.200
     4.151    12.706     0.200
     4.298    13.306     0.200
     4.505    12.882     0.200
     4.640    12.619     0.200
     4.687    13.480     0.200
     4.772    12.448     0.200
     4.846    13.964     0.200
     4.931    12.162     0.200
     4.931    12.482     0.200
     5.037    13.769     0.200
     5.070    13.151     0.200
     5.330    15.356     0.200
     5.330    14.077     0.200
     5.358    14.466     0.200
     5.369    14.690     0.200
     5.391    15.421     0.200
     5.450    14.504     0.200
     5.512    14.606     0.200
     5.677    14.996     0.200
     5.773    14.936     0.200
     5.855    16.439     0.200
     5.884    15.246     0.200
     6.100    15.891     0.200
     5.980    18.203     0.200
     6.289    16.339     0.200
     6.281    15.877     0.200
     6.335    17.404     0.200
     6.367    16.389     0.200
     6.394    16.620     0.200
     6.494    16.872     0.200
     6.570    17.286     0.200
     6.624    17.779     0.200
     6.786    16.628     0.200
     6.826    17.492     0.200
     6.890    17.569     0.200
     7.073    18.041     0.200
     7.331    19.069     0.200
     7.400    17.639     0.200
     7.500    18.470     0.200
     7.554    19.053     0.200
     7.558    19.145     0.200
     7.612    17.835     0.200
     7.717    20.153     0.200
     7.845    18.528     0.200
     7.903    18.463     0.200
     7.903    18.871     0.200
     7.982    20.318     0.200
     8.097    19.957     0.200
     8.048    19.703     0.200
     8.150    20.228     0.200
     8.350    20.497     0.200
     8.619    21.413     0.200
     8.856    22.995     0.200
     8.906    21.963     0.200
     8.995    22.585     0.200
     9.068    22.145     0.200
     9.417    22.851     0.200
     9.554    22.571     0.200
    10.228    22.777     0.200
    12.673    29.698     0.200
    14.051    30.189     0.200
    14.306    34.135     0.200
     1.650     8.365     0.200
     1.723     8.637     0.200
     1.790     9.038     0.200
     1.807     8.978     0.200
     1.812     9.430     0.200
     1.837     9.018     0.200
     1.856     9.804     0.200
     1.866     9.874     0.200
     1.861     8.099     0.200
     1.980     9.295     0.200
     2.001     9.847     0.200
     2.037     9.322     0.200
     2.071    10.081     0.200
     2.157    10.077     0.200
     2.191     9.935     0.200
     2.261    10.890     0.200
     2.475    11.658     0.200
     2.483    11.269     0.200
     2.767    10.877     0.200
     2.767    11.119     0.200
     2.835    11.474     0.200
     2.822    11.142     0.200
     2.906    11.874     0.200
     2.916    11.402     0.200
     3.053    11.217     0.200
     3.056    12.092     0.200
     3.114    12.865     0.200
     3.102    10.794     0.200
     3.518    12.795     0.200
     3.509    12.173     0.200
     3.562    12.715     0.200
     3.527    13.092     0.200
     3.681    11.501     0.200
     4.308    14.531     0.200
     4.379    14.963     0.200
     4.418    14.336     0.200
     4.434    14.475     0.200
     4.500    13.954     0.200
     4.512    13.967     0.200
     4.700    14.221     0.200
     4.993    14.267     0.200
     5.079    16.335     0.200
     5.096    14.057     0.200
     5.133    16.942     0.200
     5.218    15.133     0.200
     5.440    16.843     0.200
     5.534    15.706     0.200
     5.701    17.067     0.200
     6.015    18.112     0.200
     6.213    17.980     0.200
     6.370    18.474     0.200
     6.498    19.094     0.200
     6.518    18.157     0.200
     6.736    18.843     0.200
     6.777    19.164     0.200
     6.822    19.634     0.200
     7.121    20.356     0.200
     7.275    19.307     0.200
     7.357    19.905     0.200
     7.479    20.483     0.200
     7.639    19.713     0.200
     7.809    20.552     0.200
     8.068    22.059     0.200
     8.108    20.515     0.200
     8.150    21.711     0.200
     8.215    22.024     0.200
     8.309    23.316     0.200
     8.324    21.135     0.200
     8.412    22.887     0.200
     8.412    21.715     0.200
     8.412    23.817     0.200
     8.442    21.919     0.200
     8.469    22.123     0.200
     8.888    24.851     0.200
     9.113    23.278     0.200
     9.451    26.296     0.200
    10.039    26.594     0.200
    10.338    27.683     0.200
    11.234    25.789     0.200
    12.331    31.358     0.200
    14.404    34.986     0.200
    14.404    34.689     0.200
    14.694    32.181     0.200
    19.882    38.990     0.200
    19.882    38.996     0.200
     0.479     7.419     0.200
     0.610     7.082     0.200
     0.679     7.598     0.200
     0.686     7.166     0.200
     0.775     6.726     0.200
     0.812     6.754     0.200
     1.034     6.836     0.200
     1.034     6.969     0.200
     1.173     7.056     0.200
     1.227     7.033     0.200
     1.336     7.898     0.200
     1.335     7.524     0.200
     1.293     7.479     0.200
     1.410     7.768     0.200
     1.490     7.247     0.200
     1.695     7.576     0.200
     1.754     8.156     0.200
     1.798     8.443     0.200
     1.805     8.281     0.200
     1.921     8.726     0.200
     1.933     8.687     0.200
     1.897     8.418     0.200
     2.047     9.179     0.200
     2.187     8.036     0.200
     2.483     8.231     0.200
     2.562    10.111     0.200
     2.581     9.915     0.200
     2.617    10.606     0.200
     2.628     9.385     0.200
     2.693    10.569     0.200
     3.038    10.423     0.200
     3.050    10.731     0.200
     3.422    11.334     0.200
     3.614    10.861     0.200
     3.695    11.202     0.200
     3.884    10.456     0.200
     3.924    11.580     0.200
     4.025    11.659     0.200
     4.083    10.658     0.200
     4.182    11.647     0.200
     4.252    13.093     0.200
     4.328    11.634     0.200
     4.376    12.794     0.200
     4.399    13.267     0.200
     4.777    13.966     0.200
     4.959    13.978     0.200
     5.017    14.874     0.200
     5.219    14.136     0.200
     5.496    15.099     0.200
     5.553    14.872     0.200
     5.542    14.961     0.200
     5.609    14.970     0.200
     5.624    14.691     0.200
     5.665    14.948     0.200
     5.754    15.066     0.200
     6.063    15.512     0.200
     6.185    16.711     0.200
     6.325    15.934     0.200
     6.389    16.066     0.200
     6.450    17.020     0.200
     6.477    17.166     0.200
     6.516    17.156     0.200
     6.510    16.381     0.200
     6.539    16.945     0.200
     6.538    16.054     0.200
     6.720    17.228     0.200
     6.743    16.767     0.200
     6.836    16.731     0.200
     6.836    16.723     0.200
     6.836    16.293     0.200
     6.882    17.726     0.200
     6.974    17.251     0.200
     7.174    17.850     0.200
     7.174    18.209     0.200
     7.181    18.100     0.200
     7.287    17.711     0.200
     7.307    18.154     0.200
     7.307    18.372     0.200
     7.904    19.321     0.200
     8.325    20.202     0.200
     8.422    20.959     0.200
     8.616    20.828     0.200
     9.624    22.498     0.200
    12.217    27.680     0.200
     1.135     5.581     0.200
     1.135     5.772     0.200
     1.472     7.493     0.200
     1.472     7.743     0.200
     1.472     7.913     0.200
     1.637     7.820     0.200
     1.648     7.915     0.200
     1.645     8.104     0.200
     1.704     8.167     0.200
     1.719     8.339     0.200
     1.813     8.414     0.200
     1.856     8.425     0.200
     1.870     8.485     0.200
     1.881     8.928     0.200
     1.956     9.371     0.200
     2.048     9.446     0.200
     2.154     9.093     0.200
     2.421    10.058     0.200
     2.805    11.381     0.200
     2.821    11.354     0.200
     3.336    12.021     0.200
     3.366    12.219     0.200
     3.450    12.181     0.200
     3.513    12.254     0.200
     3.632    11.887     0.200
     3.635    12.191     0.200
     3.931    12.940     0.200
     3.969    13.063     0.200
     3.975    13.952     0.200
     3.993    13.283     0.200
     4.110    13.577     0.200
     4.311    12.409     0.200
     4.618    14.407     0.200
     4.738    14.785     0.200
     4.756    14.719     0.200
     4.794    15.069     0.200
     4.825    15.147     0.200
     4.865    15.333     0.200
     5.072    14.818     0.200
     5.212    15.183     0.200
     5.531    15.920     0.200
     5.592    16.585     0.200
     5.656    14.987     0.200
     5.655    15.957     0.200
     5.777    14.791     0.200
     5.777    14.651     0.200
     5.861    17.203     0.200
     5.916    16.197     0.200
     5.951    15.981     0.200
     6.117    16.754     0.200
     6.337    17.201     0.200
     6.429    20.619     0.200
     6.442    18.623     0.200
     6.935    18.513     0.200
     7.055    19.148     0.200
     7.087    19.295     0.200
     7.169    19.904     0.200
     7.216    19.306     0.200
     7.213    19.345     0.200
     7.349    19.614     0.200
     7.355    19.462     0.200
     7.482    20.004     0.200
     7.500    19.696     0.200
     7.506    20.335     0.200
     7.564    20.072     0.200
     7.637    20.939     0.200
     7.666    19.693     0.200
     7.755    20.905     0.200
     7.864    19.687     0.200
     7.958    19.981     0.200
     8.372    21.905     0.200
     8.619    22.008     0.200
     8.675    20.604     0.200
     8.684    23.460     0.200
     8.724    22.761     0.200
     8.895    23.300     0.200
     8.956    21.650     0.200
     8.956    21.543     0.200
     8.956    23.730     0.200
     8.983    23.948     0.200
     9.459    23.449     0.200
     9.459    23.801     0.200
     9.887    25.392     0.200
    10.374    25.973     0.200
    10.449    25.056     0.200
    10.875    27.251     0.200
    11.764    28.639     0.200
    13.050    33.140     0.200
    15.031    37.193     0.200
     0.527     5.293     0.200
     1.031     4.446     0.200
     1.045     6.128     0.200
     1.104     6.349     0.200
     1.117     6.406     0.200
     1.267     6.526     0.200
     1.293     6.625     0.200
     1.321     6.575     0.200
     1.327     7.292     0.200
     1.338     6.928     0.200
     1.426     7.159     0.200
     1.427     6.915     0.200
     1.515     7.281     0.200
     1.595     7.576     0.200
     1.656     7.372     0.200
     1.666     6.582     0.200
     1.691     7.231     0.200
     1.857     7.920     0.200
     3.379     9.565     0.200
     3.396    11.292     0.200
     3.693    11.196     0.200
     3.717    11.545     0.200
     3.820    12.112     0.200
     3.864    11.678     0.200
     3.875    12.639     0.200
     3.932    12.826     0.200
     3.998    12.453     0.200
     4.322    12.466     0.200
     4.426    12.247     0.200
     4.489    12.526     0.200
     4.627    13.973     0.200
     4.682    14.136     0.200
     4.739    13.808     0.200
     4.786    14.150     0.200
     5.103    13.900     0.200
     5.110    14.271     0.200
     5.175    14.770     0.200
     5.355    14.080     0.200
     5.498    15.449     0.200
     5.684    14.041     0.200
     5.736    14.961     0.200
     5.734    14.980     0.200
     5.807    14.428     0.200
     5.888    16.152     0.200
     5.956    14.228     0.200
     6.130    15.986     0.200
     6.149    16.107     0.200
     6.405    16.304     0.200
     6.499    17.153     0.200
     6.574    16.432     0.200
     6.656    16.988     0.200
     6.872    17.285     0.200
     6.874    17.083     0.200
     6.980    17.017     0.200
     7.081    17.339     0.200
     7.310    18.588     0.200
     7.335    18.488     0.200
     7.343    18.646     0.200
     7.375    18.689     0.200
     7.414    18.291     0.200
     7.443    18.941     0.200
     7.478    18.344     0.200
     7.585    19.167     0.200
     7.594    18.900     0.200
     7.702    19.778     0.200
     7.759    18.894     0.200
     7.817    18.698     0.200
     7.833    19.255     0.200
     8.125    20.415     0.200
     8.229    19.963     0.200
     8.422    20.634     0.200
     8.415    19.177     0.200
     8.600    21.754     0.200
     8.628    18.771     0.200
     8.684    21.417     0.200
     8.928    20.250     0.200
     8.928    20.121     0.200
    15.097    32.929     0.200
     0.553     5.115     0.200
     1.094     6.372     0.200
     1.036     4.441     0.200
     1.173     6.738     0.200
     1.062     6.018     0.200
     1.302     6.847     0.200
     1.252     6.676     0.200
     1.276     6.782     0.200
     1.326     6.821     0.200
     1.415     7.071     0.200
     1.411     7.090     0.200
     1.540     7.480     0.200
     1.502     7.728     0.200
     1.642     6.474     0.200
     1.673     7.508     0.200
     1.713     8.122     0.200
     1.667     6.886     0.200
     1.667     7.281     0.200
     2.127     9.229     0.200
     2.407     8.896     0.200
     2.497     9.441     0.200
     2.534     9.008     0.200
     2.575     8.096     0.200
     2.680    10.145     0.200
     2.704    10.791     0.200
     2.706    10.565     0.200
     2.723    10.463     0.200
     2.725    10.178     0.200
     3.235     8.527     0.200
     3.363     9.505     0.200
     3.384    11.877     0.200
     3.399    11.474     0.200
     3.697    11.238     0.200
     3.721    11.458     0.200
     3.815    12.269     0.200
     3.859    12.576     0.200
     3.869    12.631     0.200
     3.926    12.870     0.200
     3.973    12.959     0.200
     3.993    12.830     0.200
     4.309    12.403     0.200
     4.431    12.054     0.200
     4.463    14.714     0.200
     4.491    12.544     0.200
     4.622    14.141     0.200
     4.647    13.936     0.200
     4.663    14.664     0.200
     4.677    14.348     0.200
     4.717    14.335     0.200
     4.732    14.602     0.200
     4.764    14.233     0.200
     4.781    14.253     0.200
     5.092    12.929     0.200
     5.020    15.175     0.200
     5.104    14.147     0.200
     5.173    14.792     0.200
     5.322    12.734     0.200
     5.360    14.107     0.200
     5.493    14.973     0.200
     5.684    14.610     0.200
     5.737    14.589     0.200
     5.745    14.988     0.200
     5.813    14.294     0.200
     5.889    15.011     0.200
     5.964    14.099     0.200
     6.084    15.411     0.200
     6.158    16.178     0.200
     6.112    15.252     0.200
     6.139    15.368     0.200
     6.216    16.280     0.200
     6.277    17.914     0.200
     6.408    16.366     0.200
     6.646    16.643     0.200
     6.510    16.166     0.200
     6.584    16.662     0.200
     6.763    17.633     0.200
     6.754    16.698     0.200
     6.771    16.538     0.200
     6.873    16.972     0.200
     6.872    17.135     0.200
     6.979    17.391     0.200
     7.073    17.870     0.200
     7.077    17.592     0.200
     7.163    16.658     0.200
     7.196    17.263     0.200
     7.066    17.560     0.200
     7.276    16.848     0.200
     7.306    17.130     0.200
     7.166    17.255     0.200
     7.315    17.095     0.200
     7.198    18.658     0.200
     7.308    17.867     0.200
     7.354    17.857     0.200
     7.422    18.262     0.200
     7.452    18.190     0.200
     7.587    18.595     0.200
     7.582    18.763     0.200
     7.659    18.494     0.200
     7.711    18.779     0.200
     7.770    18.796     0.200
     7.836    19.202     0.200
     7.827    18.933     0.200
     7.820    18.919     0.200
     7.885    18.902     0.200
     7.846    19.188     0.200
     7.957    19.276     0.200
     8.108    18.312     0.200
     7.983    19.072     0.200
     8.014    19.251     0.200
     8.189    18.361     0.200
     8.091    20.530     0.200
     8.136    19.724     0.200
     8.294    19.344     0.200
     8.195    19.640     0.200
     8.241    19.888     0.200
     8.384    18.239     0.200
     8.325    19.979     0.200
     8.412    18.972     0.200
     8.513    19.796     0.200
     8.599    20.048     0.200
     8.599    20.771     0.200
     8.602    20.972     0.200
     8.625    19.105     0.200
     8.581    19.551     0.200
     8.743    20.507     0.200
     8.767    21.077     0.200
     8.750    20.148     0.200
     8.816    19.691     0.200
     8.816    20.482     0.200
     8.819    19.434     0.200
     8.819    20.184     0.200
     8.824    20.158     0.200
     8.817    22.013     0.200
     8.926    19.866     0.200
     8.926    19.735     0.200
     8.973    22.152     0.200
     9.031    21.424     0.200
     9.117    20.601     0.200
     9.117    20.932     0.200
     9.124    22.481     0.200
     9.142    22.712     0.200
     9.262    22.263     0.200
     9.228    22.253     0.200
     9.250    20.752     0.200
     9.428    21.877     0.200
     9.569    22.575     0.200
     9.584    22.678     0.200
     9.590    24.082     0.200
     9.866    22.075     0.200
     9.876    23.311     0.200
    10.466    24.563     0.200
    10.601    25.596     0.200
    10.698    23.400     0.200
    10.781    24.668     0.200
    10.763    25.015     0.200
    10.829    24.008     0.200
    10.959    24.770     0.200
    11.209    25.016     0.200
    11.839    27.759     0.200
    12.308    26.135     0.200
    12.514    28.467     0.200
    12.908    30.771     0.200
    13.510    27.888     0.200
    13.496    30.826     0.200
    13.776    29.260     0.200
    13.744    31.464     0.200
    15.098    31.924     0.200
    16.276    36.130     0.200
     0.539     5.302     0.200
     1.031     6.207     0.200
     1.083     6.662     0.200
     1.095     6.545     0.200
     1.061     4.643     0.200
     1.237     6.715     0.200
     1.264     6.755     0.200
     1.308     7.207     0.200
     1.398     7.070     0.200
     1.636     7.383     0.200
     1.666     6.207     0.200
     1.826     8.145     0.200
     2.358     7.791     0.200
     3.266     8.226     0.200
     3.393     9.452     0.200
     3.667    11.313     0.200
     3.691    11.506     0.200
     3.790    12.180     0.200
     3.834    12.886     0.200
     3.845    12.548     0.200
     3.902    12.465     0.200
     3.968    12.222     0.200
     4.292    12.648     0.200
     4.401    11.919     0.200
     4.436    13.464     0.200
     4.463    13.172     0.200
     4.639    13.996     0.200
     4.652    14.046     0.200
     4.693    13.976     0.200
     4.709    13.561     0.200
     4.756    14.036     0.200
     5.075    14.411     0.200
     5.146    15.397     0.200
     5.330    14.188     0.200
     5.468    15.106     0.200
     5.708    14.371     0.200
     5.714    14.781     0.200
     5.783    14.501     0.200
     5.861    15.494     0.200
     5.933    14.320     0.200
     6.081    15.390     0.200
     6.108    15.283     0.200
     6.119    15.618     0.200
     6.142    17.028     0.200
     6.254    15.874     0.200
     6.379    16.491     0.200
     6.479    15.993     0.200
     6.636    16.402     0.200
     6.844    16.507     0.200
     6.845    16.444     0.200
     6.952    16.881     0.200
     7.052    17.506     0.200
     7.281    18.067     0.200
     7.316    18.184     0.200
     7.323    18.635     0.200
     7.193    15.991     0.200
     7.458    19.021     0.200
     7.564    18.582     0.200
     7.789    18.907     0.200
     7.796    19.058     0.200
     8.386    19.507     0.200
     8.573    20.387     0.200
     8.599    19.321     0.200
     8.899    20.408     0.200
     8.899    20.503     0.200
    13.419    32.434     0.200
    15.070    32.697     0.200
     0.323     8.851     0.200
     0.405     8.405     0.200
     0.599     7.558     0.200
     0.628     7.549     0.200
     0.813     7.370     0.200
     0.852     7.674     0.200
     0.972     7.123     0.200
     0.965     7.916     0.200
     0.970     7.952     0.200
     0.972     7.946     0.200
     0.942     7.618     0.200
     0.989     7.883     0.200
     0.989     7.864     0.200
     1.263     7.155     0.200
     1.431     8.051     0.200
     1.443     8.040     0.200
     1.595     8.398     0.200
     1.613     8.345     0.200
     1.660     8.375     0.200
     1.710     8.942     0.200
     1.696     8.593     0.200
     1.780     8.432     0.200
     1.882     7.880     0.200
     2.067     8.179     0.200
     2.118     8.644     0.200
     2.081     9.207     0.200
     2.125     9.471     0.200
     2.138     9.352     0.200
     2.198     9.452     0.200
     2.242     9.544     0.200
     2.260     9.534     0.200
     2.739    11.218     0.200
     2.772     9.082     0.200
     2.818     9.634     0.200
     2.852     8.783     0.200
     2.799     9.885     0.200
     2.913    10.769     0.200
     2.936    11.463     0.200
     2.946    10.965     0.200
     2.983    10.970     0.200
     3.010    11.253     0.200
     3.028    10.881     0.200
     3.046    10.810     0.200
     3.229    10.297     0.200
     3.308    11.817     0.200
     3.410    11.094     0.200
     3.441    11.537     0.200
     3.745    11.109     0.200
     3.758    11.727     0.200
     3.985    11.151     0.200
     4.066    11.636     0.200
     4.069    11.954     0.200
     4.187    12.488     0.200
     4.254    11.334     0.200
     4.282    12.453     0.200
     4.449    11.338     0.200
     4.552    12.968     0.200
     4.562    14.368     0.200
     4.685    12.705     0.200
     4.626    13.360     0.200
     4.750    13.415     0.200
     4.777    12.430     0.200
     5.124    14.085     0.200
     5.165    14.039     0.200
     5.147    13.883     0.200
     5.167    13.789     0.200
     5.251    14.173     0.200
     5.305    14.297     0.200
     5.372    14.225     0.200
     5.341    14.799     0.200
     5.344    14.534     0.200
     5.418    14.446     0.200
     5.470    14.579     0.200
     5.573    14.779     0.200
     5.662    15.166     0.200
     5.742    15.356     0.200
     5.817    15.346     0.200
     5.845    15.737     0.200
     5.919    15.616     0.200
     5.961    15.689     0.200
     5.986    15.437     0.200
     6.009    15.688     0.200
     6.024    15.894     0.200
     6.105    15.777     0.200
     6.239    15.955     0.200
     6.376    16.422     0.200
     6.388    16.958     0.200
     6.414    16.956     0.200
     6.418    16.252     0.200
     6.606    17.116     0.200
     6.675    16.044     0.200
     6.742    17.211     0.200
     6.794    17.294     0.200
     6.867    18.075     0.200
     6.868    16.573     0.200
     6.888    16.238     0.200
     6.911    17.351     0.200
     6.955    18.643     0.200
     7.079    17.326     0.200
     7.211    18.344     0.200
     7.192    16.896     0.200
     7.357    18.862     0.200
     7.346    18.624     0.200
     7.380    17.822     0.200
     7.505    18.051     0.200
     7.523    19.063     0.200
     7.603    18.860     0.200
     7.633    19.621     0.200
     7.968    18.531     0.200
     8.133    20.279     0.200
     8.205    19.793     0.200
     8.224    21.885     0.200
     8.272    21.252     0.200
     8.313    20.420     0.200
     8.219    22.138     0.200
     8.548    21.161     0.200
     8.990    22.376     0.200
     9.672    22.737     0.200
     9.988    24.538     0.200
    10.277    23.856     0.200
    11.235    28.396     0.200
     1.784     9.084     0.200
     1.870     9.944     0.200
     1.897     9.753     0.200
     1.957    10.539     0.200
     1.871     8.619     0.200
     2.036     9.948     0.200
     2.094    10.394     0.200
     2.248    10.057     0.200
     2.507    11.557     0.200
     2.520    11.694     0.200
     2.796    11.730     0.200
     2.868    12.600     0.200
     2.865    11.010     0.200
     3.081    11.588     0.200
     3.066    11.939     0.200
     3.100    12.638     0.200
     3.159    12.705     0.200
     3.204    12.453     0.200
     3.137    11.362     0.200
     3.561    13.344     0.200
     3.604    13.984     0.200
     3.630    13.445     0.200
     3.563    12.599     0.200
     3.699    12.387     0.200
     3.632    13.004     0.200
     3.733    13.458     0.200
     3.896    13.228     0.200
     4.293    15.013     0.200
     4.358    15.374     0.200
     4.324    13.565     0.200
     4.457    15.410     0.200
     4.472    15.018     0.200
     4.512    15.359     0.200
     4.527    14.874     0.200
     4.540    14.848     0.200
     4.634    14.761     0.200
     4.733    15.240     0.200
     4.844    15.082     0.200
     5.005    15.123     0.200
     5.084    15.229     0.200
     5.105    14.526     0.200
     5.221    15.984     0.200
     5.295    15.898     0.200
     5.310    15.969     0.200
     5.463    17.201     0.200
     5.533    16.340     0.200
     5.629    16.817     0.200
     5.720    17.496     0.200
     6.057    17.828     0.200
     6.039    17.638     0.200
     6.265    18.188     0.200
     6.281    18.029     0.200
     6.283    18.345     0.200
     6.325    18.441     0.200
     6.288    19.090     0.200
     6.367    18.431     0.200
     6.475    18.458     0.200
     6.494    19.209     0.200
     6.522    18.525     0.200
     6.520    18.843     0.200
     6.596    18.740     0.200
     6.774    19.972     0.200
     6.802    20.114     0.200
     6.780    19.428     0.200
     6.768    19.260     0.200
     6.779    19.124     0.200
     6.852    20.113     0.200
     6.846    19.738     0.200
     6.881    19.682     0.200
     6.936    19.889     0.200
     7.152    21.323     0.200
     7.111    20.343     0.200
     7.149    21.018     0.200
     7.141    20.583     0.200
     7.230    20.730     0.200
     7.590    21.005     0.200
     7.621    21.028     0.200
     7.863    21.616     0.200
     8.010    22.224     0.200
     8.095    22.795     0.200
     8.095    23.315     0.200
     8.085    22.425     0.200
     8.192    22.494     0.200
     8.253    23.123     0.200
     8.440    22.809     0.200
     8.440    22.599     0.200
     8.353    22.888     0.200
     8.482    22.961     0.200
     8.563    24.530     0.200
     9.082    24.661     0.200
     9.158    23.989     0.200
     9.500    23.930     0.200
     9.605    26.193     0.200
     9.752    27.597     0.200
     9.770    25.959     0.200
     9.844    27.845     0.200
    10.010    25.787     0.200
    11.077    26.162     0.200
    14.728    34.239     0.200
    19.870    39.310     0.200
     0.473     7.368     0.200
     0.553     7.211     0.200
     0.700     6.887     0.200
     0.756     7.083     0.200
     0.760     7.142     0.200
     0.767     7.265     0.200
     0.781     7.102     0.200
     0.815     6.675     0.200
     0.913     6.987     0.200
     1.009     6.939     0.200
     1.405     7.200     0.200
     1.388     7.507     0.200
     1.483     7.940     0.200
     1.481     7.746     0.200
     1.641     8.051     0.200
     1.658     7.918     0.200
     1.753     8.160     0.200
     1.843     7.323     0.200
     1.873     8.178     0.200
     1.897     7.738     0.200
     1.932     8.454     0.200
     2.037     8.791     0.200
     2.052     8.621     0.200
     2.073     8.488     0.200
     2.591     9.420     0.200
     2.631     8.752     0.200
     2.676     9.451     0.200
     2.703    10.178     0.200
     2.739     9.538     0.200
     2.774    10.022     0.200
     2.817    10.309     0.200
     2.988     9.498     0.200
     3.183    10.829     0.200
     3.219    11.260     0.200
     3.520    10.415     0.200
     3.546    11.515     0.200
     3.758    10.622     0.200
     3.842    11.230     0.200
     3.960    10.778     0.200
     4.364    13.985     0.200
     4.473    12.208     0.200
     4.464    13.821     0.200
     4.523    12.909     0.200
     4.923    13.736     0.200
     4.941    13.604     0.200
     4.956    13.340     0.200
     5.028    13.728     0.200
     5.129    14.894     0.200
     5.137    15.059     0.200
     5.333    16.147     0.200
     5.353    14.868     0.200
     5.436    14.463     0.200
     5.627    15.021     0.200
     5.660    16.502     0.200
     5.701    15.071     0.200
     5.898    15.554     0.200
     5.936    16.024     0.200
     5.936    15.865     0.200
     6.023    15.981     0.200
     6.168    15.444     0.200
     6.192    16.531     0.200
     6.208    16.442     0.200
     6.376    15.872     0.200
     6.457    15.931     0.200
     6.533    16.588     0.200
     6.593    17.227     0.200
     6.646    16.582     0.200
     6.660    16.439     0.200
     6.670    16.145     0.200
     6.684    16.763     0.200
     6.789    16.670     0.200
     6.862    16.883     0.200
     6.864    16.696     0.200
     6.872    18.196     0.200
     6.971    16.992     0.200
     7.019    17.682     0.200
     7.119    18.358     0.200
     7.162    17.278     0.200
     8.165    20.608     0.200
     1.220     6.124     0.200
     1.394     7.322     0.200
     1.437     8.211     0.200
     1.445     8.050     0.200
     1.458     7.940     0.200
     1.458     8.144     0.200
     1.492     8.205     0.200
     1.674     7.633     0.200
     1.656     7.833     0.200
     1.717     8.298     0.200
     1.891     8.888     0.200
     1.939     8.875     0.200
     2.046     8.087     0.200
     2.303     8.222     0.200
     2.338     9.703     0.200
     2.372     9.592     0.200
     2.459     9.534     0.200
     2.488     9.113     0.200
     2.469     9.917     0.200
     2.627     9.611     0.200
     3.040    10.260     0.200
     3.040    10.705     0.200
     3.094    10.843     0.200
     3.142    10.309     0.200
     3.118    11.152     0.200
     3.104    10.952     0.200
     3.127    10.762     0.200
     3.125     9.642     0.200
     3.240    10.369     0.200
     3.348    10.898     0.200
     3.543    10.414     0.200
     3.483    11.107     0.200
     3.644    10.649     0.200
     3.678    11.308     0.200
     3.696    11.207     0.200
     3.774    10.652     0.200
     3.821    11.890     0.200
     3.901    11.909     0.200
     3.936    11.571     0.200
     3.940    11.930     0.200
     4.055    12.166     0.200
     4.320    13.166     0.200
     4.379    13.051     0.200
     4.559    12.776     0.200
     4.585    13.124     0.200
     4.740    13.951     0.200
     4.875    14.119     0.200
     4.872    13.991     0.200
     4.970    13.629     0.200
     4.943    14.642     0.200
     4.949    13.967     0.200
     5.056    14.842     0.200
     5.069    14.350     0.200
     5.141    14.119     0.200
     5.151    14.407     0.200
     5.154    14.662     0.200
     5.224    14.486     0.200
     5.168    14.491     0.200
     5.248    14.610     0.200
     5.188    14.550     0.200
     5.288    14.739     0.200
     5.350    14.469     0.200
     5.485    15.783     0.200
     5.437    15.838     0.200
     5.514    16.687     0.200
     5.935    16.078     0.200
     6.042    16.223     0.200
     6.241    18.368     0.200
     6.475    17.202     0.200
     6.679    17.561     0.200
     6.901    18.274     0.200
     6.973    18.758     0.200
     6.990    17.401     0.200
     7.034    17.786     0.200
     7.034    17.817     0.200
     7.034    18.520     0.200
     7.191    18.490     0.200
     7.198    21.182     0.200
     7.886    20.887     0.200
     8.745    23.410     0.200
     8.953    20.933     0.200
     8.953    23.257     0.200
     9.097    24.456     0.200
     9.230    22.467     0.200
     9.265    23.507     0.200
     9.860    24.548     0.200
    10.556    27.536     0.200
    10.801    27.366     0.200
    10.920    27.266     0.200
    11.075    28.148     0.200
    11.116    27.529     0.200
    11.486    28.460     0.200
    12.007    27.778     0.200
    13.028    30.146     0.200
    13.028    30.490     0.200
    14.044    29.950     0.200
    15.060    35.192     0.200
    15.499    34.393     0.200
    18.755    37.664     0.200
     1.047     5.207     0.200
     1.613     8.071     0.200
     1.784     8.446     0.200
     1.860     9.020     0.200
     1.958     8.979     0.200
     1.981     8.840     0.200
     1.993     8.992     0.200
     2.009     9.818     0.200
     2.006     9.491     0.200
     2.132    10.113     0.200
     2.148     9.689     0.200
     2.234     9.861     0.200
     2.328     9.827     0.200
     2.433    11.093     0.200
     2.824    10.052     0.200
     3.086    11.028     0.200
     3.514    11.171     0.200
     3.487    12.416     0.200
     3.769    11.628     0.200
     3.781    12.196     0.200
     3.782    12.540     0.200
     4.101    13.089     0.200
     4.145    14.415     0.200
     4.164    13.653     0.200
     4.269    14.061     0.200
     4.279    14.061     0.200
     4.450    12.746     0.200
     4.596    13.329     0.200
     4.794    14.926     0.200
     4.924    15.053     0.200
     4.964    15.573     0.200
     4.966    15.223     0.200
     5.033    15.488     0.200
     5.224    15.585     0.200
     5.387    15.163     0.200
     5.786    15.412     0.200
     5.759    16.360     0.200
     5.813    15.908     0.200
     5.900    15.097     0.200
     6.464    18.030     0.200
     7.335    19.381     0.200
     7.359    20.901     0.200
     7.507    20.495     0.200
     7.509    20.385     0.200
     7.593    20.078     0.200
     7.667    19.742     0.200
     7.667    20.062     0.200
     7.799    21.863     0.200
     7.897    21.983     0.200
     7.963    22.028     0.200
     8.054    22.336     0.200
     8.574    22.331     0.200
     8.626    21.454     0.200
     8.686    24.132     0.200
     8.776    21.934     0.200
     8.836    20.931     0.200
     8.824    22.808     0.200
     9.058    22.987     0.200
     9.109    23.940     0.200
     9.104    24.556     0.200
     9.114    22.499     0.200
     9.114    22.687     0.200
     9.114    23.710     0.200
     9.701    25.631     0.200
     9.634    23.755     0.200
     9.634    24.286     0.200
     9.911    25.069     0.200
    10.044    26.013     0.200
    10.513    26.427     0.200
    10.881    27.764     0.200
    11.925    27.715     0.200
    15.173    36.554     0.200
     1.121     6.755     0.200
     1.366     6.371     0.200
     1.721     8.244     0.200
     1.721     8.400     0.200
     2.296     9.908     0.200
     2.370    10.135     0.200
     2.431     9.922     0.200
     2.724    10.971     0.200
     3.313    11.791     0.200
     3.595    12.512     0.200
     3.879    12.798     0.200
     3.863    12.544     0.200
     4.159    11.563     0.200
     4.378    14.603     0.200
     4.401    14.449     0.200
     4.486    13.765     0.200
     4.510    14.509     0.200
     4.694    13.769     0.200
     5.129    16.190     0.200
     5.221    14.816     0.200
     5.324    15.378     0.200
     5.530    16.221     0.200
     5.583    16.232     0.200
     5.857    15.234     0.200
     5.952    15.981     0.200
     6.234    16.756     0.200
     6.257    17.118     0.200
     6.363    17.846     0.200
     6.506    18.063     0.200
     7.181    19.778     0.200
     7.497    18.889     0.200
     7.538    20.128     0.200
     7.518    20.354     0.200
     7.563    21.684     0.200
     7.598    20.888     0.200
     7.651    21.261     0.200
     7.905    21.865     0.200
     7.954    20.859     0.200
     7.950    21.875     0.200
     8.772    23.769     0.200
     8.894    23.812     0.200
     8.979    24.269     0.200
     9.040    23.868     0.200
     9.239    23.671     0.200
     9.497    24.292     0.200
     9.916    24.568     0.200
    10.158    27.066     0.200
    11.165    26.820     0.200
    12.062    26.836     0.200
    20.478    38.891     0.200
     0.459     5.408     0.200
     0.721     4.937     0.200
     0.899     5.566     0.200
     0.999     5.778     0.200
     1.002     5.801     0.200
     1.156     6.260     0.200
     1.179     6.755     0.200
     1.184     6.961     0.200
     1.179     6.092     0.200
     1.193     6.444     0.200
     1.192     7.368     0.200
     1.206     6.911     0.200
     1.213     7.091     0.200
     1.244     6.796     0.200
     1.266     6.754     0.200
     1.500     6.864     0.200
     1.595     7.447     0.200
     1.608     8.118     0.200
     1.764     7.920     0.200
     1.779     7.561     0.200
     1.822     8.145     0.200
     1.850     8.190     0.200
     1.858     8.096     0.200
     1.868     8.132     0.200
     1.893     7.729     0.200
     1.911     7.637     0.200
     1.996     8.546     0.200
     2.104     8.732     0.200
     2.131     8.852     0.200
     2.227     8.566     0.200
     2.270     9.625     0.200
     2.295     9.049     0.200
     2.322     9.434     0.200
     2.399     9.498     0.200
     2.402     9.416     0.200
     2.620     8.531     0.200
     2.699     8.802     0.200
     2.731    10.692     0.200
     2.801     8.826     0.200
     3.021    10.480     0.200
     3.032    10.246     0.200
     3.032    10.184     0.200
     3.082    10.742     0.200
     3.152    10.477     0.200
     3.201    10.304     0.200
     3.258    10.320     0.200
     3.321    10.575     0.200
     3.355    11.046     0.200
     3.455    11.060     0.200
     3.549    10.423     0.200
     3.534    11.220     0.200
     3.904    11.112     0.200
     3.936    11.279     0.200
     3.926    11.821     0.200
     3.965    11.626     0.200
     4.007    11.021     0.200
     4.075    11.522     0.200
     4.110    11.789     0.200
     4.168    11.192     0.200
     4.292    12.239     0.200
     4.365    12.229     0.200
     4.411    12.325     0.200
     4.602    13.214     0.200
     4.727    14.072     0.200
     4.826    13.517     0.200
     4.961    13.929     0.200
     5.037    14.930     0.200
     5.061    14.242     0.200
     5.092    13.674     0.200
     5.120    13.676     0.200
     5.123    13.635     0.200
     5.236    14.258     0.200
     5.425    14.905     0.200
     5.460    15.715     0.200
     5.591    14.245     0.200
     5.611    15.350     0.200
     5.603    15.104     0.200
     5.633    15.009     0.200
     5.677    15.582     0.200
     5.710    15.658     0.200
     5.751    15.417     0.200
     5.881    15.809     0.200
     5.934    16.292     0.200
     5.995    15.772     0.200
     6.028    16.001     0.200
     6.033    15.340     0.200
     6.078    16.310     0.200
     6.087    16.077     0.200
     6.238    16.277     0.200
     6.221    16.290     0.200
     6.363    16.966     0.200
     6.395    17.047     0.200
     6.510    17.268     0.200
     6.569    17.570     0.200
     6.708    16.430     0.200
     6.792    18.045     0.200
     6.807    17.791     0.200
     6.861    17.504     0.200
     6.918    16.708     0.200
     6.934    17.294     0.200
     7.047    18.462     0.200
     7.083    17.632     0.200
     7.119    17.514     0.200
     7.121    17.662     0.200
     7.159    17.810     0.200
     7.142    17.670     0.200
     7.207    18.869     0.200
     7.197    17.071     0.200
     7.197    16.712     0.200
     7.197    16.982     0.200
     7.232    18.161     0.200
     7.333    18.349     0.200
     7.333    18.427     0.200
     7.415    17.142     0.200
     7.733    19.469     0.200
     7.821    19.247     0.200
     7.821    19.649     0.200
     7.867    20.448     0.200
     7.909    20.176     0.200
     8.238    21.074     0.200
     8.273    20.558     0.200
     8.661    20.468     0.200
     8.726    22.008     0.200
     8.757    20.536     0.200
     8.790    21.459     0.200
     8.854    20.845     0.200
     9.116    20.814     0.200
     9.146    22.082     0.200
     9.216    22.962     0.200
     9.518    23.170     0.200
     9.782    23.715     0.200
     9.993    21.802     0.200
    10.007    22.134     0.200
    10.664    26.299     0.200
    12.033    29.117     0.200
    13.303    28.450     0.200
    13.303    30.216     0.200
    16.736    32.347     0.200
     1.289     8.225     0.200
     1.257     7.985     0.200
     1.394     7.087     0.200
     1.413     8.513     0.200
     1.468     8.880     0.200
     1.470     8.682     0.200
     1.476     8.718     0.200
     1.484     9.025     0.200
     1.492     8.935     0.200
     1.503     9.027     0.200
     1.527     8.603     0.200
     1.507     8.897     0.200
     1.555     8.214     0.200
     1.603     9.005     0.200
     1.685     9.264     0.200
     1.866     9.139     0.200
     1.885     9.484     0.200
     1.888     9.443     0.200
     1.928     9.612     0.200
     1.975     9.609     0.200
     1.992    10.042     0.200
     2.148     8.898     0.200
     2.147     9.650     0.200
     2.265     9.802     0.200
     2.304    10.056     0.200
     2.362     9.852     0.200
     2.341     9.974     0.200
     2.421    10.123     0.200
     2.435    10.416     0.200
     2.533    11.750     0.200
     2.581    10.907     0.200
     2.593    11.282     0.200
     2.733    10.854     0.200
     2.979    11.010     0.200
     2.991    11.307     0.200
     2.983    11.371     0.200
     3.083    11.171     0.200
     3.042    11.590     0.200
     3.048    12.022     0.200
     3.248    11.731     0.200
     3.262    12.164     0.200
     3.361    11.599     0.200
     3.474    11.633     0.200
     3.533    11.892     0.200
     3.597    11.391     0.200
     3.514    12.077     0.200
     3.752    12.235     0.200
     3.768    12.591     0.200
     3.742    12.953     0.200
     3.769    13.042     0.200
     3.914    13.479     0.200
     4.118    12.273     0.200
     4.192    12.829     0.200
     4.168    13.782     0.200
     4.553    13.523     0.200
     4.673    14.839     0.200
     4.734    14.962     0.200
     4.825    15.194     0.200
     4.890    14.490     0.200
     4.962    14.863     0.200
     4.946    15.677     0.200
     5.042    15.000     0.200
     5.064    14.727     0.200
     5.098    15.186     0.200
     5.166    15.460     0.200
     5.256    16.541     0.200
     5.254    16.556     0.200
     5.323    16.403     0.200
     5.337    16.377     0.200
     5.329    16.830     0.200
     5.435    15.793     0.200
     5.644    18.291     0.200
     5.745    16.881     0.200
     5.852    16.638     0.200
     5.876    17.454     0.200
     6.026    19.022     0.200
     6.076    18.970     0.200
     6.396    18.438     0.200
     6.458    18.596     0.200
     6.561    19.636     0.200
     6.662    18.615     0.200
     6.800    18.264     0.200
     6.800    20.054     0.200
     6.807    19.052     0.200
     6.815    18.995     0.200
     6.910    18.826     0.200
     6.910    19.095     0.200
     6.914    18.409     0.200
     7.002    19.217     0.200
     7.160    19.468     0.200
     7.390    20.619     0.200
     7.823    21.340     0.200
     7.830    20.319     0.200
     7.830    21.049     0.200
     8.818    24.037     0.200
     8.838    24.272     0.200
     9.032    24.989     0.200
     9.153    24.656     0.200
     9.457    24.000     0.200
     9.526    24.026     0.200
     9.724    24.517     0.200
     9.737    25.486     0.200
     0.202    13.131     0.200
     0.090    14.176     0.200
     0.262    12.704     0.200
     0.305    12.253     0.200
     0.320    12.225     0.200
     0.346    11.726     0.200
     0.424    11.357     0.200
     0.439    11.381     0.200
     0.932     9.760     0.200
     0.960     9.509     0.200
     1.033     9.546     0.200
     1.076     9.791     0.200
     1.285     9.883     0.200
     1.289    10.029     0.200
     1.382     8.658     0.200
     1.438     8.516     0.200
     1.887    10.602     0.200
     1.958     9.971     0.200
     2.162    10.587     0.200
     2.263    10.252     0.200
     2.361    10.570     0.200
     2.403    10.686     0.200
     2.406    10.686     0.200
     2.506    10.947     0.200
     2.539     9.603     0.200
     2.534    11.054     0.200
     2.602     9.677     0.200
     2.778    10.411     0.200
     3.178    12.287     0.200
     3.202    12.435     0.200
     3.249    11.068     0.200
     3.532    12.582     0.200
     3.779    12.178     0.200
     3.815    11.876     0.200
     4.028    12.996     0.200
     4.204    12.214     0.200
     4.378    12.288     0.200
     4.492    12.394     0.200
     4.576    12.326     0.200
     4.606    14.315     0.200
     4.629    14.258     0.200
     4.732    12.484     0.200
     4.765    15.458     0.200
     4.788    13.910     0.200
     4.801    13.051     0.200
     4.941    12.763     0.200
     5.177    13.829     0.200
     5.192    14.082     0.200
     5.493    14.161     0.200
     5.547    14.265     0.200
     5.582    15.324     0.200
     5.590    14.373     0.200
     5.605    14.978     0.200
     5.642    15.269     0.200
     5.677    15.405     0.200
     5.826    15.926     0.200
     5.885    14.723     0.200
     6.083    16.057     0.200
     6.143    15.875     0.200
     6.409    16.418     0.200
     6.475    17.087     0.200
     6.485    16.837     0.200
     6.532    17.476     0.200
     6.620    17.161     0.200
     6.736    17.294     0.200
     6.855    16.213     0.200
     6.917    18.526     0.200
     6.920    18.350     0.200
     6.929    17.925     0.200
     6.970    16.182     0.200
     7.000    17.234     0.200
     7.125    18.663     0.200
     7.187    18.719     0.200
     7.184    16.210     0.200
     7.192    16.947     0.200
     7.255    18.840     0.200
     7.369    17.332     0.200
     7.383    19.216     0.200
     7.505    17.112     0.200
     7.505    17.162     0.200
     7.687    19.832     0.200
     8.000    20.279     0.200
     8.739    23.318     0.200
     9.190    22.669     0.200
     9.199    20.391     0.200
     9.384    20.805     0.200
    10.239    21.457     0.200
    13.774    29.795     0.200
     0.494     7.031     0.200
     0.536     6.467     0.200
     0.638     6.211     0.200
     0.748     6.307     0.200
     0.798     6.087     0.200
     0.818     6.077     0.200
     0.889     6.435     0.200
     0.916     6.471     0.200
     0.934     6.283     0.200
     1.006     6.735     0.200
     1.073     6.659     0.200
     1.060     7.003     0.200
     1.091     6.410     0.200
     1.072     7.167     0.200
     1.073     7.269     0.200
     1.078     7.089     0.200
     1.082     7.089     0.200
     1.083     7.096     0.200
     1.091     7.073     0.200
     1.137     6.489     0.200
     1.545     7.720     0.200
     1.546     7.823     0.200
     1.674     7.798     0.200
     1.688     8.123     0.200
     1.700     8.186     0.200
     1.738     8.058     0.200
     1.764     8.124     0.200
     1.784     8.188     0.200
     1.815     8.599     0.200
     2.033     8.021     0.200
     2.072     8.301     0.200
     2.170     8.925     0.200
     2.214     9.587     0.200
     2.232     9.044     0.200
     2.336     9.740     0.200
     2.349     9.698     0.200
     2.363     9.495     0.200
     2.800     8.918     0.200
     2.811     9.814     0.200
     2.997    10.733     0.200
     3.032    11.219     0.200
     3.036    11.184     0.200
     3.038    11.127     0.200
     3.290    10.366     0.200
     3.333    11.496     0.200
     3.417    11.159     0.200
     3.669    12.303     0.200
     3.711    10.962     0.200
     3.797    12.024     0.200
     3.938    12.033     0.200
     3.996    10.957     0.200
     4.061    11.359     0.200
     4.200    10.610     0.200
     4.200    12.147     0.200
     4.201    12.055     0.200
     4.381    10.563     0.200
     4.401    12.042     0.200
     4.602    11.828     0.200
     4.667    16.002     0.200
     4.737    12.991     0.200
     4.795    12.974     0.200
     4.776    14.224     0.200
     4.808    11.876     0.200
     4.797    13.982     0.200
     5.026    13.243     0.200
     5.074    14.018     0.200
     5.183    14.150     0.200
     5.290    14.457     0.200
     5.310    14.457     0.200
     5.418    15.521     0.200
     5.432    15.558     0.200
     5.484    14.512     0.200
     5.625    14.501     0.200
     5.685    14.900     0.200
     5.713    14.966     0.200
     5.852    14.646     0.200
     5.866    14.795     0.200
     5.903    15.518     0.200
     5.911    15.726     0.200
     5.905    16.928     0.200
     5.909    15.478     0.200
     5.958    17.384     0.200
     6.009    15.833     0.200
     6.270    16.716     0.200
     6.283    16.316     0.200
     6.328    16.545     0.200
     6.330    16.688     0.200
     6.504    17.217     0.200
     6.590    17.565     0.200
     6.650    16.516     0.200
     6.656    17.743     0.200
     6.663    16.403     0.200
     6.734    16.619     0.200
     6.770    17.159     0.200
     6.912    17.830     0.200
     6.946    16.333     0.200
     7.241    17.216     0.200
     7.468    18.440     0.200
     7.511    17.255     0.200
     7.715    18.651     0.200
     7.925    20.383     0.200
     8.032    20.748     0.200
     8.056    18.726     0.200
     8.179    19.935     0.200
     8.196    20.022     0.200
     8.479    20.002     0.200
     8.543    20.927     0.200
     8.572    20.529     0.200
     8.617    20.271     0.200
     0.340     9.532     0.200
     0.461     9.239     0.200
     0.504     9.095     0.200
     0.514     9.020     0.200
     0.552     8.643     0.200
     0.678     8.804     0.200
     0.791     8.440     0.200
     0.811     8.473     0.200
     0.824     8.345     0.200
     0.959     8.170     0.200
     1.027     7.787     0.200
     1.082     8.169     0.200
     1.113     8.210     0.200
     1.196     8.010     0.200
     1.323     8.049     0.200
     1.693     9.092     0.200
     1.695     9.220     0.200
     1.695     9.213     0.200
     1.699     9.150     0.200
     1.713     9.117     0.200
     1.720     9.018     0.200
     2.004     9.372     0.200
     2.064     8.158     0.200
     2.381     9.778     0.200
     2.467    10.176     0.200
     2.799    10.643     0.200
     2.816     9.628     0.200
     2.843    11.647     0.200
     2.861     9.795     0.200
     2.874    11.050     0.200
     2.908    10.771     0.200
     3.016    10.618     0.200
     3.298    11.668     0.200
     3.576    10.921     0.200
     3.592    10.434     0.200
     3.630    11.811     0.200
     3.642    11.925     0.200
     3.704    12.304     0.200
     3.732    11.315     0.200
     3.976    12.866     0.200
     3.999    12.625     0.200
     4.022    12.453     0.200
     4.187    13.084     0.200
     4.477    14.189     0.200
     4.496    12.392     0.200
     4.661    14.584     0.200
     4.710    13.917     0.200
     4.827    13.479     0.200
     4.945    13.949     0.200
     4.993    13.513     0.200
     4.996    13.796     0.200
     5.156    14.734     0.200
     5.178    13.164     0.200
     5.245    17.536     0.200
     5.398    14.279     0.200
     5.508    14.497     0.200
     5.788    16.679     0.200
     5.812    15.624     0.200
     6.059    16.143     0.200
     6.137    16.982     0.200
     6.312    16.451     0.200
     6.417    17.851     0.200
     6.579    18.174     0.200
     6.648    17.422     0.200
     6.659    17.063     0.200
     6.705    17.414     0.200
     6.801    17.781     0.200
     6.923    18.757     0.200
     6.979    18.614     0.200
     7.122    18.630     0.200
     7.139    19.017     0.200
     7.175    19.093     0.200
     7.247    18.760     0.200
     7.694    18.537     0.200
     7.789    19.172     0.200
     7.832    19.393     0.200
     7.932    17.705     0.200
    14.158    31.377     0.200
     0.173    16.385     0.200
     0.219    15.996     0.200
     0.283    15.544     0.200
     0.302    15.343     0.200
     0.340    14.865     0.200
     0.356    14.935     0.200
     0.440    14.609     0.200
     0.499    13.918     0.200
     0.542    13.949     0.200
     0.933    11.950     0.200
     0.983    11.666     0.200
     0.992    11.724     0.200
     1.287    11.949     0.200
     1.299    11.633     0.200
     1.300    11.934     0.200
     1.567    11.477     0.200
     1.668    10.032     0.200
     1.736    10.007     0.200
     2.095    10.075     0.200
     2.355    11.919     0.200
     2.337    11.355     0.200
     2.337    11.158     0.200
     2.340    11.758     0.200
     2.560    11.555     0.200
     2.690    11.889     0.200
     3.472    12.883     0.200
     3.453    13.528     0.200
     3.737    13.063     0.200
     3.822    13.048     0.200
     3.940    13.683     0.200
     4.252    12.599     0.200
     4.254    12.671     0.200
     4.400    11.523     0.200
     4.372    12.859     0.200
     4.385    14.092     0.200
     4.408    14.180     0.200
     4.510    12.869     0.200
     4.566    13.226     0.200
     4.621    13.875     0.200
     4.636    16.268     0.200
     4.801    13.433     0.200
     4.801    12.957     0.200
     5.025    13.668     0.200
     5.096    15.119     0.200
     5.194    14.063     0.200
     5.294    14.758     0.200
     5.362    14.477     0.200
     5.448    14.371     0.200
     5.467    15.730     0.200
     5.506    15.858     0.200
     5.525    14.334     0.200
     5.539    14.655     0.200
     5.586    15.052     0.200
     5.798    15.658     0.200
     5.815    15.283     0.200
     5.911    16.279     0.200
     5.958    15.888     0.200
     5.995    15.253     0.200
     6.063    16.203     0.200
     6.486    17.140     0.200
     6.574    17.425     0.200
     6.572    17.617     0.200
     6.769    16.234     0.200
     6.822    17.506     0.200
     6.886    16.797     0.200
     6.998    18.206     0.200
     7.018    18.230     0.200
     7.101    16.649     0.200
     7.127    16.980     0.200
     7.183    18.215     0.200
     7.208    18.294     0.200
     7.266    17.208     0.200
     7.282    18.406     0.200
     7.267    16.986     0.200
     7.280    17.214     0.200
     7.431    17.072     0.200
     7.431    16.662     0.200
     7.492    20.776     0.200
     7.502    19.161     0.200
     7.502    19.271     0.200
     7.582    18.096     0.200
     7.725    18.069     0.200
     7.939    19.233     0.200
     8.035    19.501     0.200
     8.035    19.653     0.200
     0.362     8.580     0.200
     0.502     8.186     0.200
     0.673     7.572     0.200
     0.637     8.091     0.200
     0.642     8.298     0.200
     0.643     8.017     0.200
     0.645     8.074     0.200
     0.682     7.577     0.200
     0.659     7.880     0.200
     0.836     7.245     0.200
     0.904     7.465     0.200
     0.949     7.900     0.200
     1.129     7.233     0.200
     1.330     7.834     0.200
     1.408     8.639     0.200
     1.538     7.497     0.200
     1.500     7.972     0.200
     1.779     8.056     0.200
     1.796     8.764     0.200
     1.839     7.817     0.200
     1.810     8.701     0.200
     1.914     9.012     0.200
     2.200     8.116     0.200
     2.508     9.400     0.200
     2.573     8.677     0.200
     2.546     9.443     0.200
     2.676    10.043     0.200
     2.685    10.487     0.200
     2.698    10.594     0.200
     2.924    10.889     0.200
     3.092    10.290     0.200
     3.111    11.370     0.200
     3.428    11.119     0.200
     3.450    10.513     0.200
     3.664    10.539     0.200
     3.758    11.006     0.200
     3.861    10.913     0.200
     3.867    10.710     0.200
     3.972    10.122     0.200
     4.026    11.693     0.200
     4.080    12.039     0.200
     4.178    10.845     0.200
     4.332    13.036     0.200
     4.354    13.296     0.200
     4.430    12.155     0.200
     4.748    13.423     0.200
     4.776    12.938     0.200
     4.845    13.354     0.200
     4.884    13.229     0.200
     4.907    14.379     0.200
     4.922    13.638     0.200
     5.018    14.286     0.200
     5.011    13.012     0.200
     5.086    14.983     0.200
     5.249    14.509     0.200
     5.242    14.273     0.200
     5.337    14.487     0.200
     5.515    14.985     0.200
     5.722    15.651     0.200
     5.776    15.161     0.200
     5.800    15.356     0.200
     5.849    15.752     0.200
     5.942    15.891     0.200
     5.973    14.834     0.200
     6.057    15.712     0.200
     6.129    15.810     0.200
     6.169    16.716     0.200
     6.167    15.843     0.200
     6.299    16.765     0.200
     6.494    17.348     0.200
     6.539    16.567     0.200
     6.557    16.077     0.200
     6.607    17.492     0.200
     6.591    17.056     0.200
     6.623    16.781     0.200
     6.751    17.033     0.200
     6.757    17.311     0.200
     6.777    18.197     0.200
     6.861    16.748     0.200
     6.861    17.178     0.200
     7.250    19.150     0.200
     7.300    18.519     0.200
     7.272    18.993     0.200
     8.437    21.625     0.200
     9.640    21.581     0.200
     9.825    25.323     0.200
     9.929    21.812     0.200
    10.122    23.202     0.200
    11.689    26.468     0.200
    12.344    27.711     0.200
     0.145    11.956     0.200
     0.206    11.415     0.200
     0.357    10.037     0.200
     0.517     9.141     0.200
     0.563     8.930     0.200
     0.642     8.880     0.200
     0.635     9.260     0.200
     0.750     8.603     0.200
     0.766     8.893     0.200
     0.836     8.729     0.200
     0.870     8.720     0.200
     0.946     8.991     0.200
     0.951     9.018     0.200
     0.968     8.996     0.200
     0.967     8.908     0.200
     0.972     8.886     0.200
     1.096     7.383     0.200
     1.257     8.944     0.200
     1.356     7.518     0.200
     1.364     8.632     0.200
     1.382     8.529     0.200
     1.474     8.699     0.200
     1.524     8.950     0.200
     1.572     8.988     0.200
     1.637     9.061     0.200
     1.657     9.687     0.200
     1.746     9.214     0.200
     1.746     9.438     0.200
     1.831     9.172     0.200
     1.939     8.236     0.200
     2.057     9.506     0.200
     2.113     8.612     0.200
     2.101     9.774     0.200
     2.111     9.698     0.200
     2.170     8.696     0.200
     2.167     9.820     0.200
     2.235    10.042     0.200
     2.744    11.734     0.200
     2.744    11.314     0.200
     2.794     9.120     0.200
     2.711    10.067     0.200
     2.847    10.235     0.200
     2.904     9.351     0.200
     2.889    10.677     0.200
     2.918    11.019     0.200
     2.959    10.993     0.200
     2.975    11.194     0.200
     3.014    10.354     0.200
     3.007    10.902     0.200
     3.233    11.360     0.200
     3.438    11.689     0.200
     3.543    12.112     0.200
     3.664    11.736     0.200
     3.735    12.059     0.200
     3.786    11.393     0.200
     4.001    11.680     0.200
     4.096    12.086     0.200
     4.149    12.162     0.200
     4.149    11.903     0.200
     4.154    12.182     0.200
     4.202    12.384     0.200
     4.305    11.394     0.200
     4.348    12.744     0.200
     4.370    13.668     0.200
     4.418    12.406     0.200
     4.506    12.000     0.200
     4.523    14.363     0.200
     4.523    13.849     0.200
     4.603    12.858     0.200
     4.545    13.900     0.200
     4.682    12.516     0.200
     4.714    12.983     0.200
     4.751    13.512     0.200
     4.748    12.933     0.200
     4.779    13.868     0.200
     4.989    13.941     0.200
     5.075    13.691     0.200
     5.111    14.090     0.200
     5.149    13.595     0.200
     5.197    14.359     0.200
     5.207    14.380     0.200
     5.180    13.673     0.200
     5.250    13.910     0.200
     5.315    14.588     0.200
     5.319    14.411     0.200
     5.380    14.725     0.200
     5.372    15.089     0.200
     5.432    14.093     0.200
     5.496    14.796     0.200
     5.551    14.360     0.200
     5.564    14.069     0.200
     5.663    15.292     0.200
     5.670    14.750     0.200
     5.830    15.195     0.200
     5.893    15.567     0.200
     5.976    15.760     0.200
     6.032    16.180     0.200
     6.048    15.781     0.200
     6.086    16.001     0.200
     6.104    15.998     0.200
     6.177    16.229     0.200
     6.249    16.603     0.200
     6.300    15.993     0.200
     6.369    16.567     0.200
     6.446    16.711     0.200
     6.470    16.136     0.200
     6.480    16.957     0.200
     6.487    16.862     0.200
     6.603    17.769     0.200
     6.584    15.312     0.200
     6.680    17.724     0.200
     6.662    15.476     0.200
     6.787    18.005     0.200
     6.784    17.790     0.200
     6.812    17.865     0.200
     6.864    15.653     0.200
     6.875    15.844     0.200
     6.939    18.094     0.200
     6.927    17.568     0.200
     7.040    18.625     0.200
     7.006    16.278     0.200
     7.060    17.670     0.200
     7.069    16.844     0.200
     7.115    18.004     0.200
     7.184    16.854     0.200
     7.184    16.444     0.200
     7.184    16.574     0.200
     7.296    19.155     0.200
     7.364    17.223     0.200
     7.592    19.387     0.200
     7.521    19.355     0.200
     7.521    18.486     0.200
     7.588    19.059     0.200
     7.588    18.690     0.200
     7.694    18.896     0.200
     8.035    19.043     0.200
     8.311    20.039     0.200
     8.744    21.458     0.200
     8.817    20.394     0.200
     9.237    22.737     0.200
     9.765    23.158     0.200
     9.941    21.113     0.200
    10.008    23.612     0.200
    10.089    24.125     0.200
    10.156    22.896     0.200
    10.380    24.109     0.200
    12.613    29.713     0.200
    12.613    29.088     0.200
    13.413    27.876     0.200
    13.413    28.071     0.200
    14.424    32.003     0.200
     0.634     5.331     0.200
     0.663     4.394     0.200
     1.164     6.479     0.200
     1.164     6.309     0.200
     1.529     7.236     0.200
     2.362     7.251     0.200
     2.879    10.400     0.200
     3.177    10.444     0.200
     3.200    10.603     0.200
     3.385    11.263     0.200
     3.433    12.076     0.200
     3.838    10.421     0.200
     3.948    11.852     0.200
     3.909    11.112     0.200
     4.103    12.115     0.200
     4.590    13.103     0.200
     4.839    13.118     0.200
     5.219    13.680     0.200
     5.227    13.911     0.200
     5.292    13.428     0.200
     5.377    14.423     0.200
     5.444    13.336     0.200
     5.548    14.083     0.200
     5.569    14.502     0.200
     5.590    14.426     0.200
     5.623    14.381     0.200
     5.694    15.012     0.200
     5.889    15.744     0.200
     5.918    15.356     0.200
     5.950    15.543     0.200
     6.000    15.873     0.200
     6.071    15.805     0.200
     6.125    15.950     0.200
     6.305    16.658     0.200
     6.323    16.093     0.200
     6.361    16.455     0.200
     6.369    16.719     0.200
     6.402    16.568     0.200
     6.477    16.467     0.200
     6.460    16.611     0.200
     6.435    16.004     0.200
     6.598    17.204     0.200
     6.605    16.827     0.200
     6.748    17.032     0.200
     6.844    17.560     0.200
     6.903    17.331     0.200
     6.980    17.154     0.200
     7.092    17.805     0.200
     7.125    18.198     0.200
     7.195    18.993     0.200
     7.261    17.876     0.200
     7.317    18.740     0.200
     7.317    18.499     0.200
     7.334    18.862     0.200
     7.322    18.435     0.200
     7.453    18.558     0.200
     7.620    17.814     0.200
     7.628    19.160     0.200
     7.706    19.369     0.200
     7.734    19.556     0.200
     7.859    19.565     0.200
     7.829    19.346     0.200
     7.921    18.815     0.200
     7.949    19.297     0.200
     8.055    19.382     0.200
     8.100    19.683     0.200
     8.134    18.967     0.200
     8.217    19.574     0.200
     8.330    19.916     0.200
     8.340    19.453     0.200
     8.302    21.388     0.200
     8.275    19.382     0.200
     8.429    19.693     0.200
     8.429    19.421     0.200
     8.429    20.353     0.200
     8.459    21.594     0.200
     8.514    21.005     0.200
     8.620    20.588     0.200
     8.620    21.299     0.200
     8.817    22.066     0.200
     9.143    21.479     0.200
     9.947    22.268     0.200
    10.079    24.633     0.200
    10.678    25.302     0.200
    10.777    24.864     0.200
    13.057    29.968     0.200
    14.583    35.239     0.200
     1.146     6.900     0.200
     1.541     6.783     0.200
     1.649     7.713     0.200
     1.686     7.682     0.200
     1.782     8.101     0.200
     1.816     8.431     0.200
     1.841     8.482     0.200
     1.828     8.308     0.200
     1.839     8.435     0.200
     1.856     8.830     0.200
     1.865     8.760     0.200
     2.056     8.977     0.200
     2.115     9.235     0.200
     2.136     8.849     0.200
     2.637    10.934     0.200
     2.819    10.008     0.200
     3.031    11.317     0.200
     3.082    11.722     0.200
     3.245    11.464     0.200
     3.306    12.468     0.200
     3.321    11.387     0.200
     3.315    11.526     0.200
     3.784    13.079     0.200
     3.855    13.320     0.200
     3.895    13.331     0.200
     3.990    10.163     0.200
     3.970    11.594     0.200
     4.138    12.803     0.200
     4.210    12.878     0.200
     4.225    13.825     0.200
     4.530    14.182     0.200
     4.599    14.178     0.200
     4.634    14.885     0.200
     4.669    15.179     0.200
     4.767    14.126     0.200
     4.907    13.882     0.200
     4.944    14.702     0.200
     5.150    15.670     0.200
     5.295    14.602     0.200
     5.343    15.437     0.200
     5.349    14.805     0.200
     5.404    13.614     0.200
     5.531    15.082     0.200
     5.554    15.385     0.200
     5.587    15.250     0.200
     5.712    17.758     0.200
     5.852    17.341     0.200
     5.945    16.155     0.200
     5.988    17.072     0.200
     6.063    16.916     0.200
     6.133    16.904     0.200
     6.232    16.684     0.200
     6.220    18.962     0.200
     6.341    18.205     0.200
     6.363    17.279     0.200
     6.528    17.984     0.200
     6.529    18.132     0.200
     6.611    17.862     0.200
     6.657    17.789     0.200
     6.817    18.686     0.200
     6.831    18.002     0.200
     6.833    18.281     0.200
     6.922    18.853     0.200
     6.959    19.483     0.200
     7.048    18.987     0.200
     7.097    18.718     0.200
     7.093    19.314     0.200
     7.073    18.868     0.200
     7.101    18.279     0.200
     7.167    18.779     0.200
     7.401    19.735     0.200
     7.420    19.402     0.200
     7.464    19.890     0.200
     7.493    20.927     0.200
     7.923    20.988     0.200
     8.193    19.972     0.200
     8.330    21.984     0.200
     8.615    23.782     0.200
     8.671    21.774     0.200
     8.671    21.173     0.200
     8.671    22.364     0.200
     9.293    24.342     0.200
    14.695    34.892     0.200
     0.088    17.043     0.200
     0.274    15.400     0.200
     0.329    14.622     0.200
     0.363    14.652     0.200
     0.374    14.685     0.200
     0.435    14.053     0.200
     0.480    13.981     0.200
     0.600    13.340     0.200
     0.631    13.188     0.200
     1.075    11.519     0.200
     1.141    12.041     0.200
     1.147    11.962     0.200
     1.154    11.973     0.200
     1.163    11.874     0.200
     1.123    11.404     0.200
     1.110    11.816     0.200
     1.187    11.804     0.200
     1.138    11.367     0.200
     1.421    11.518     0.200
     1.622     9.769     0.200
     1.701    11.451     0.200
     1.747     9.733     0.200
     1.764    11.365     0.200
     2.158    11.445     0.200
     2.160    10.187     0.200
     2.195    11.441     0.200
     2.215    10.904     0.200
     2.196    11.423     0.200
     2.198    11.672     0.200
     2.234    11.518     0.200
     2.325    11.477     0.200
     2.467    11.837     0.200
     2.843    10.358     0.200
     2.946    12.721     0.200
     2.965    12.288     0.200
     2.932    11.591     0.200
     2.976    13.094     0.200
     2.992    12.509     0.200
     2.998    12.407     0.200
     3.035    12.749     0.200
     3.091    12.420     0.200
     3.135    12.229     0.200
     3.328    12.543     0.200
     3.314    12.956     0.200
     3.298    12.652     0.200
     3.594    12.807     0.200
     3.676    12.174     0.200
     3.676    12.508     0.200
     3.803    13.312     0.200
     4.109    12.560     0.200
     4.226    12.009     0.200
     4.294    14.608     0.200
     4.364    12.592     0.200
     4.420    12.751     0.200
     4.397    13.150     0.200
     4.481    13.955     0.200
     4.481    14.058     0.200
     4.508    16.004     0.200
     4.542    12.514     0.200
     4.625    13.887     0.200
     4.631    13.665     0.200
     4.658    13.117     0.200
     4.656    12.906     0.200
     4.752    14.145     0.200
     4.883    13.216     0.200
     5.048    13.876     0.200
     5.120    14.297     0.200
     5.154    14.519     0.200
     5.220    14.196     0.200
     5.305    14.177     0.200
     5.348    15.413     0.200
     5.336    15.262     0.200
     5.381    14.181     0.200
     5.372    15.048     0.200
     5.397    14.312     0.200
     5.441    14.557     0.200
     5.623    15.740     0.200
     5.646    15.482     0.200
     5.662    16.190     0.200
     5.652    15.247     0.200
     5.676    15.139     0.200
     5.812    15.989     0.200
     5.820    15.620     0.200
     5.830    15.602     0.200
     5.851    15.062     0.200
     5.936    16.388     0.200
     5.925    15.532     0.200
     5.925    15.651     0.200
     6.001    16.469     0.200
     6.060    16.505     0.200
     6.096    16.140     0.200
     6.254    17.003     0.200
     6.326    16.754     0.200
     6.344    16.907     0.200
     6.433    17.144     0.200
     6.427    16.455     0.200
     6.447    17.233     0.200
     6.482    17.386     0.200
     6.550    17.297     0.200
     6.595    17.575     0.200
     6.635    16.039     0.200
     6.635    16.314     0.200
     6.680    17.382     0.200
     6.688    18.064     0.200
     6.740    16.552     0.200
     6.740    16.961     0.200
     6.749    16.536     0.200
     6.798    18.079     0.200
     6.859    18.015     0.200
     6.877    18.210     0.200
     6.893    18.096     0.200
     6.923    18.356     0.200
     6.964    16.869     0.200
     6.987    16.922     0.200
     7.048    18.746     0.200
     7.075    16.915     0.200
     7.075    17.352     0.200
     7.127    17.147     0.200
     7.137    17.724     0.200
     7.133    17.487     0.200
     7.141    16.909     0.200
     7.141    17.485     0.200
     7.144    17.123     0.200
     7.222    18.757     0.200
     7.236    19.278     0.200
     7.252    17.502     0.200
     7.252    17.885     0.200
     7.293    16.722     0.200
     7.293    16.781     0.200
     7.355    19.061     0.200
     7.356    19.383     0.200
     7.347    18.801     0.200
     7.394    19.291     0.200
     7.394    19.330     0.200
     7.446    17.960     0.200
     7.486    18.776     0.200
     7.498    19.732     0.200
     7.580    17.287     0.200
     7.580    17.600     0.200
     7.757    20.111     0.200
     7.796    19.854     0.200
     7.889    20.262     0.200
     7.889    20.172     0.200
     7.967    21.060     0.200
     7.930    19.672     0.200
     7.985    19.816     0.200
     8.009    19.986     0.200
     8.173    20.157     0.200
     8.282    20.092     0.200
     8.842    22.215     0.200
     9.043    20.930     0.200
     9.159    19.839     0.200
     9.309    22.366     0.200
    10.007    20.465     0.200
    10.021    20.812     0.200
    10.249    23.704     0.200
    10.455    24.331     0.200
    10.691    23.335     0.200
    10.891    26.030     0.200
    11.472    27.504     0.200
    12.399    25.135     0.200
    13.112    29.115     0.200
     0.997     5.158     0.200
     1.220     6.378     0.200
     1.434     7.330     0.200
     1.440     7.860     0.200
     1.458     7.688     0.200
     1.461     7.652     0.200
     1.571     7.472     0.200
     1.495     6.883     0.200
     1.523     7.520     0.200
     1.566     7.706     0.200
     1.641     7.965     0.200
     1.608     7.282     0.200
     1.607     7.829     0.200
     1.677     8.176     0.200
     1.752     7.719     0.200
     1.821     6.920     0.200
     1.860     7.473     0.200
     1.853     7.790     0.200
     1.951     8.224     0.200
     2.004     8.470     0.200
     2.427     9.629     0.200
     2.457     9.432     0.200
     2.520     7.995     0.200
     2.536     9.377     0.200
     2.553     9.372     0.200
     2.677     9.041     0.200
     2.764     9.234     0.200
     2.893     8.648     0.200
     3.219    11.153     0.200
     3.222    11.250     0.200
     3.250    11.226     0.200
     3.306    10.660     0.200
     3.329    11.658     0.200
     3.458    10.444     0.200
     3.462    11.800     0.200
     3.506    10.538     0.200
     3.483    10.808     0.200
     3.784    10.299     0.200
     3.875    10.899     0.200
     3.883    11.301     0.200
     4.010    10.648     0.200
     3.956    12.103     0.200
     4.093    11.505     0.200
     4.520    13.071     0.200
     4.552    13.377     0.200
     4.533    13.276     0.200
     4.713    13.493     0.200
     4.712    13.511     0.200
     4.879    13.382     0.200
     4.975    13.996     0.200
     5.083    14.583     0.200
     5.068    13.950     0.200
     5.260    14.552     0.200
     5.250    14.908     0.200
     5.396    14.567     0.200
     5.463    14.274     0.200
     5.490    14.686     0.200
     5.532    14.995     0.200
     5.548    15.148     0.200
     5.501    15.520     0.200
     5.556    15.474     0.200
     5.586    15.204     0.200
     5.625    15.584     0.200
     5.692    15.483     0.200
     5.730    15.463     0.200
     5.749    15.683     0.200
     5.868    15.604     0.200
     5.884    16.352     0.200
     6.180    16.674     0.200
     6.192    16.847     0.200
     6.287    16.835     0.200
     6.526    17.401     0.200
     6.802    17.707     0.200
     6.872    17.810     0.200
     6.953    17.623     0.200
     7.161    18.604     0.200
     7.205    18.739     0.200
     7.192    18.833     0.200
     7.216    17.853     0.200
     7.216    18.232     0.200
     7.216    18.443     0.200
     7.252    19.021     0.200
     7.765    19.710     0.200
     8.023    20.902     0.200
     7.987    20.783     0.200
     8.583    21.129     0.200
     9.255    22.949     0.200
     9.459    22.268     0.200
    10.037    24.022     0.200
    10.695    26.399     0.200
    11.719    28.322     0.200
    11.719    26.634     0.200
    19.000    37.655     0.200
     1.727     8.204     0.200
     1.833     8.429     0.200
     1.908     9.330     0.200
     1.903     8.809     0.200
     1.944     8.781     0.200
     1.971     9.036     0.200
     2.556    11.404     0.200
     2.557    11.399     0.200
     2.561    10.891     0.200
     2.841    11.801     0.200
     2.880    10.980     0.200
     2.943    11.489     0.200
     3.145    12.359     0.200
     3.168    11.054     0.200
     3.157    11.319     0.200
     3.205    12.132     0.200
     3.431    12.140     0.200
     3.680    12.894     0.200
     3.752    13.265     0.200
     3.801    11.540     0.200
     3.787    12.978     0.200
     3.985    12.644     0.200
     4.065    12.598     0.200
     4.082    14.458     0.200
     4.415    14.467     0.200
     4.441    14.691     0.200
     4.467    14.700     0.200
     4.483    14.674     0.200
     4.481    14.335     0.200
     4.517    14.664     0.200
     4.563    15.378     0.200
     4.615    13.981     0.200
     4.737    13.648     0.200
     4.735    15.181     0.200
     4.808    14.798     0.200
     5.116    13.852     0.200
     5.181    14.326     0.200
     5.194    14.305     0.200
     5.220    13.663     0.200
     5.234    15.209     0.200
     5.342    14.871     0.200
     5.407    15.035     0.200
     5.400    14.706     0.200
     5.515    15.628     0.200
     5.557    15.540     0.200
     5.658    15.304     0.200
     5.753    15.698     0.200
     5.821    16.817     0.200
     5.953    16.391     0.200
     6.042    16.469     0.200
     6.111    18.416     0.200
     6.283    18.167     0.200
     6.304    18.253     0.200
     6.357    18.383     0.200
     6.413    17.581     0.200
     6.394    17.800     0.200
     6.472    18.273     0.200
     6.494    18.531     0.200
     6.559    18.270     0.200
     6.621    18.544     0.200
     6.642    17.930     0.200
     6.642    18.091     0.200
     6.638    19.208     0.200
     6.728    19.450     0.200
     6.750    18.277     0.200
     6.794    19.027     0.200
     6.838    18.978     0.200
     6.899    19.071     0.200
     6.902    18.685     0.200
     6.906    18.908     0.200
     6.893    19.273     0.200
     6.932    19.097     0.200
     6.972    19.229     0.200
     7.007    18.807     0.200
     7.065    19.132     0.200
     7.202    20.311     0.200
     7.230    19.211     0.200
     7.251    19.820     0.200
     7.268    19.232     0.200
     7.359    19.576     0.200
     7.375    19.436     0.200
     7.434    19.656     0.200
     7.724    20.218     0.200
     7.723    20.877     0.200
     7.756    20.332     0.200
     7.988    21.505     0.200
     8.053    20.631     0.200
     8.135    21.745     0.200
     8.181    21.808     0.200
     8.260    21.045     0.200
     8.468    23.396     0.200
     8.496    21.381     0.200
     8.525    22.282     0.200
     8.525    21.807     0.200
     8.525    23.022     0.200
     8.692    23.874     0.200
     9.217    23.277     0.200
     9.201    23.511     0.200
     9.447    24.656     0.200
     9.858    25.754     0.200
     9.905    25.683     0.200
     9.901    25.365     0.200
    10.146    25.983     0.200
    10.194    26.562     0.200
    10.450    26.561     0.200
    10.529    25.692     0.200
    11.332    26.147     0.200
    11.346    29.070     0.200
    12.438    31.248     0.200
    14.525    35.285     0.200
    14.525    34.890     0.200
    14.637    34.287     0.200
    20.003    38.263     0.200
     0.026    12.925     0.200
     0.184    11.432     0.200
     0.134    12.331     0.200
     0.152    11.847     0.200
     0.164    11.549     0.200
     0.170    11.505     0.200
     0.191    11.437     0.200
     0.263    11.211     0.200
     0.315    10.687     0.200
     0.280    10.969     0.200
     0.424    10.403     0.200
     0.486     9.734     0.200
     0.503     9.778     0.200
     0.569     9.787     0.200
     0.815     8.761     0.200
     0.921     8.539     0.200
     1.309     7.771     0.200
     1.342     8.141     0.200
     1.464     9.220     0.200
     1.465     9.235     0.200
     1.654     8.115     0.200
     2.073     9.820     0.200
     2.138     9.797     0.200
     2.356     8.454     0.200
     2.619     9.487     0.200
     2.550    10.603     0.200
     2.589    10.628     0.200
     2.597    10.798     0.200
     2.645    10.703     0.200
     2.680     9.567     0.200
     2.737     9.659     0.200
     2.724    10.941     0.200
     2.973    10.577     0.200
     3.373    10.855     0.200
     3.408    11.168     0.200
     3.446    12.132     0.200
     3.472    11.054     0.200
     3.579    11.651     0.200
     3.724    12.802     0.200
     3.962    12.567     0.200
     3.983    11.923     0.200
     4.115    12.138     0.200
     4.193    12.627     0.200
     4.221    12.970     0.200
     4.353    12.218     0.200
     4.549    11.815     0.200
     4.655    12.530     0.200
     4.684    13.437     0.200
     4.689    13.398     0.200
     4.749    13.198     0.200
     4.824    14.817     0.200
     4.872    13.348     0.200
     4.910    13.691     0.200
     4.964    15.417     0.200
     5.073    12.963     0.200
     5.314    14.012     0.200
     5.339    14.312     0.200
     5.598    14.504     0.200
     5.679    14.827     0.200
     5.676    14.537     0.200
     5.723    14.674     0.200
     5.754    15.334     0.200
     5.795    15.374     0.200
     5.774    14.690     0.200
     5.778    16.005     0.200
     5.800    15.733     0.200
     5.935    15.797     0.200
     5.934    15.461     0.200
     5.996    15.435     0.200
     6.074    14.918     0.200
     6.217    16.044     0.200
     6.207    15.419     0.200
     6.282    16.567     0.200
     6.282    16.042     0.200
     6.447    16.560     0.200
     6.543    16.609     0.200
     6.591    16.921     0.200
     6.613    17.014     0.200
     6.610    16.429     0.200
     6.652    17.223     0.200
     6.735    16.899     0.200
     6.742    17.751     0.200
     6.865    17.617     0.200
     6.923    17.680     0.200
     7.006    17.904     0.200
     7.015    17.981     0.200
     7.048    17.749     0.200
     7.152    18.250     0.200
     7.161    16.465     0.200
     7.236    18.447     0.200
     7.334    19.241     0.200
     7.346    18.797     0.200
     7.372    18.864     0.200
     7.375    16.584     0.200
     7.379    17.188     0.200
     7.461    19.128     0.200
     7.497    19.384     0.200
     7.518    17.659     0.200
     7.557    17.113     0.200
     7.750    18.745     0.200
     7.694    17.380     0.200
     7.694    16.833     0.200
     7.836    19.311     0.200
     7.887    19.974     0.200
     8.128    19.998     0.200
     8.153    20.334     0.200
     9.590    23.142     0.200
     9.865    22.990     0.200
    10.446    22.081     0.200
    10.553    25.022     0.200
     0.135    11.882     0.200
     0.461     9.581     0.200
     0.615     8.855     0.200
     0.630     8.980     0.200
     0.726     9.005     0.200
     0.783     9.285     0.200
     0.784     9.247     0.200
     0.788     9.300     0.200
     0.873     8.565     0.200
     0.859     8.722     0.200
     0.802     9.171     0.200
     0.811     9.138     0.200
     0.979     8.607     0.200
     1.204     7.854     0.200
     1.092     9.019     0.200
     1.515     7.829     0.200
     1.405     8.986     0.200
     1.499     8.728     0.200
     1.573     8.811     0.200
     1.539     9.113     0.200
     1.599     8.515     0.200
     1.621     9.284     0.200
     1.723     8.643     0.200
     1.889     9.432     0.200
     1.933     9.755     0.200
     1.942     9.580     0.200
     1.997     8.438     0.200
     2.112     8.629     0.200
     1.997     9.695     0.200
     2.061     8.551     0.200
     2.045     9.714     0.200
     2.066     9.666     0.200
     2.547    10.049     0.200
     2.591    11.479     0.200
     2.712     9.734     0.200
     2.720    10.787     0.200
     2.794     9.305     0.200
     2.748    11.027     0.200
     2.791    11.007     0.200
     2.791    11.190     0.200
     2.839    10.864     0.200
     2.965     9.770     0.200
     2.886    10.377     0.200
     3.065    11.284     0.200
     3.314    11.017     0.200
     3.287    10.599     0.200
     3.279    11.701     0.200
     3.567    11.388     0.200
     3.700    12.194     0.200
     3.663    11.201     0.200
     3.854    10.958     0.200
     3.959    11.246     0.200
     4.089    11.299     0.200
     4.094    10.948     0.200
     4.054    11.964     0.200
     4.191    11.249     0.200
     4.252    12.303     0.200
     4.207    12.493     0.200
     4.274    12.591     0.200
     4.401    11.512     0.200
     4.351    14.526     0.200
     4.356    13.627     0.200
     4.378    13.459     0.200
     4.488    12.802     0.200
     4.656    12.555     0.200
     4.643    13.128     0.200
     4.806    13.901     0.200
     4.878    13.765     0.200
     4.852    13.780     0.200
     4.917    13.620     0.200
     4.991    13.519     0.200
     4.992    13.628     0.200
     5.030    13.612     0.200
     5.111    14.116     0.200
     5.135    15.150     0.200
     5.092    13.887     0.200
     5.144    14.600     0.200
     5.150    14.284     0.200
     5.239    14.049     0.200
     5.297    13.607     0.200
     5.331    14.438     0.200
     5.417    14.733     0.200
     5.401    14.194     0.200
     5.477    15.269     0.200
     5.489    15.475     0.200
     5.517    14.643     0.200
     5.581    14.800     0.200
     5.599    14.996     0.200
     5.658    15.189     0.200
     5.668    16.122     0.200
     5.742    15.018     0.200
     5.811    15.354     0.200
     5.868    15.436     0.200
     5.942    16.003     0.200
     5.959    16.572     0.200
     6.028    16.218     0.200
     6.045    15.869     0.200
     6.088    15.670     0.200
     6.196    16.337     0.200
     6.285    16.638     0.200
     6.355    16.800     0.200
     6.383    17.454     0.200
     6.398    17.354     0.200
     6.393    16.866     0.200
     6.527    17.685     0.200
     6.497    15.651     0.200
     6.595    17.202     0.200
     6.651    17.131     0.200
     6.720    17.622     0.200
     6.703    16.177     0.200
     6.711    15.913     0.200
     6.796    18.130     0.200
     6.780    16.155     0.200
     6.835    18.213     0.200
     6.850    18.177     0.200
     6.881    16.931     0.200
     6.898    16.154     0.200
     6.901    16.598     0.200
     6.902    16.610     0.200
     6.975    17.635     0.200
     6.972    17.722     0.200
     7.021    16.595     0.200
     7.021    16.505     0.200
     7.228    18.616     0.200
     7.200    17.500     0.200
     7.218    17.895     0.200
     7.314    18.901     0.200
     7.461    18.287     0.200
     7.483    19.454     0.200
     7.637    19.010     0.200
     7.895    19.478     0.200
     8.205    21.148     0.200
     8.409    20.236     0.200
     8.673    19.867     0.200
     8.776    20.508     0.200
     8.895    21.153     0.200
     9.711    23.937     0.200
     9.934    24.103     0.200
    10.049    26.724     0.200
    10.143    23.287     0.200
    10.213    24.788     0.200
    10.344    25.648     0.200
    12.569    30.028     0.200
    16.806    31.314     0.200
     1.602    11.058     0.200
     1.602    10.569     0.200
     1.918    11.025     0.200
     2.483    13.634     0.200
     2.503    13.235     0.200
     2.503    13.092     0.200
     2.506    13.549     0.200
     2.567    14.490     0.200
     3.126    14.131     0.200
     3.191    14.552     0.200
     3.324    13.571     0.200
     3.398    16.028     0.200
     3.549    15.117     0.200
     3.580    15.397     0.200
     3.611    15.017     0.200
     3.649    16.079     0.200
     3.654    16.336     0.200
     3.717    16.084     0.200
     3.788    15.848     0.200
     3.991    17.550     0.200
     4.064    16.536     0.200
     4.084    17.294     0.200
     4.121    17.646     0.200
     4.282    17.380     0.200
     4.299    15.630     0.200
     4.333    16.806     0.200
     4.442    17.673     0.200
     4.473    17.052     0.200
     4.513    17.858     0.200
     4.561    17.539     0.200
     4.787    18.398     0.200
     4.939    18.386     0.200
     4.985    18.929     0.200
     5.105    18.626     0.200
     5.221    18.198     0.200
     5.260    18.720     0.200
     5.471    19.185     0.200
     5.506    19.257     0.200
     5.517    18.626     0.200
     5.582    18.188     0.200
     5.644    18.539     0.200
     5.690    18.356     0.200
     5.721    19.507     0.200
     5.852    18.201     0.200
     5.913    19.769     0.200
     5.923    20.142     0.200
     5.989    20.136     0.200
     6.059    22.206     0.200
     6.042    18.806     0.200
     6.258    20.673     0.200
     6.355    20.252     0.200
     6.354    20.172     0.200
     6.428    20.162     0.200
     6.495    20.385     0.200
     6.519    21.048     0.200
     6.590    20.629     0.200
     6.703    21.383     0.200
     6.682    20.710     0.200
     6.706    20.878     0.200
     6.740    20.533     0.200
     6.796    21.825     0.200
     6.804    21.239     0.200
     6.862    22.347     0.200
     6.836    21.901     0.200
     6.872    21.889     0.200
     6.867    20.758     0.200
     6.997    21.554     0.200
     7.116    21.775     0.200
     7.093    22.049     0.200
     7.092    21.359     0.200
     7.184    22.249     0.200
     7.262    22.381     0.200
     7.272    21.898     0.200
     7.316    21.996     0.200
     7.372    22.807     0.200
     7.387    22.061     0.200
     7.354    22.462     0.200
     7.409    22.286     0.200
     7.569    22.796     0.200
     7.612    23.292     0.200
     7.602    23.410     0.200
     7.681    23.787     0.200
     7.689    22.519     0.200
     7.743    22.769     0.200
     7.757    22.944     0.200
     7.758    23.408     0.200
     7.926    23.634     0.200
     7.965    23.778     0.200
     8.056    23.592     0.200
     8.066    23.833     0.200
     8.145    23.872     0.200
     8.165    23.951     0.200
     8.216    23.742     0.200
     8.295    23.401     0.200
     8.262    23.710     0.200
     8.413    24.374     0.200
     8.429    23.769     0.200
     8.390    24.265     0.200
     8.440    26.094     0.200
     8.601    24.147     0.200
     8.623    24.006     0.200
     8.612    26.487     0.200
     8.659    24.825     0.200
     8.736    24.876     0.200
     8.736    24.599     0.200
     8.723    25.328     0.200
     8.718    24.078     0.200
     8.881    25.189     0.200
     8.920    26.664     0.200
     9.013    25.279     0.200
     9.014    25.131     0.200
     9.014    26.116     0.200
     9.023    26.332     0.200
     9.517    28.472     0.200
     9.523    26.831     0.200
     9.812    27.558     0.200
     9.895    28.128     0.200
    10.313    29.283     0.200
    10.475    29.078     0.200
    10.469    29.863     0.200
    11.119    29.746     0.200
    11.586    31.705     0.200
    13.500    36.577     0.200
    14.934    36.879     0.200
    14.934    38.415     0.200
     1.184     5.732     0.200
     1.459     7.811     0.200
     1.491     7.916     0.200
     1.502     7.731     0.200
     1.513     8.508     0.200
     1.521     8.477     0.200
     1.534     8.659     0.200
     1.534     8.244     0.200
     1.562     8.263     0.200
     1.671     7.929     0.200
     1.714     8.151     0.200
     1.735     7.709     0.200
     1.718     8.913     0.200
     1.765     8.235     0.200
     1.798     8.571     0.200
     1.858     8.474     0.200
     1.949     9.027     0.200
     1.968     9.198     0.200
     2.008     7.468     0.200
     2.016     9.120     0.200
     2.068     9.293     0.200
     2.098     8.952     0.200
     2.350     8.432     0.200
     2.373     9.548     0.200
     2.410    10.153     0.200
     2.414     9.944     0.200
     2.426     9.982     0.200
     2.496     9.467     0.200
     2.548     9.346     0.200
     2.531    10.237     0.200
     2.535     9.900     0.200
     2.569     9.938     0.200
     2.695    11.025     0.200
     3.177    10.709     0.200
     3.177    11.497     0.200
     3.200    11.710     0.200
     3.287    10.861     0.200
     3.406    11.794     0.200
     3.415    11.224     0.200
     3.571    11.645     0.200
     3.559    11.664     0.200
     3.683    11.262     0.200
     3.730    11.635     0.200
     3.807    10.974     0.200
     3.893    12.363     0.200
     3.962    11.964     0.200
     3.959    12.253     0.200
     4.109    13.431     0.200
     4.325    12.643     0.200
     4.370    13.866     0.200
     4.400    13.476     0.200
     4.520    13.633     0.200
     4.663    13.964     0.200
     4.758    13.421     0.200
     4.813    15.837     0.200
     4.909    15.120     0.200
     5.072    15.244     0.200
     5.058    14.886     0.200
     5.169    14.834     0.200
     5.252    14.607     0.200
     5.304    14.717     0.200
     5.246    15.027     0.200
     5.266    15.167     0.200
     5.460    15.563     0.200
     5.418    16.294     0.200
     5.533    15.744     0.200
     5.486    16.882     0.200
     5.516    16.138     0.200
     5.586    15.694     0.200
     5.647    16.234     0.200
     5.642    15.941     0.200
     5.776    16.715     0.200
     5.858    16.570     0.200
     5.821    16.952     0.200
     5.955    16.971     0.200
     6.057    16.808     0.200
     6.285    17.326     0.200
     6.559    18.001     0.200
     6.630    17.020     0.200
     6.635    18.206     0.200
     7.095    18.922     0.200
     7.095    18.945     0.200
     7.341    20.091     0.200
     7.411    19.995     0.200
     7.961    20.467     0.200
     8.011    20.966     0.200
     8.145    20.752     0.200
    18.765    39.108     0.200
     0.187    16.579     0.200
     0.166    16.647     0.200
     0.299    15.719     0.200
     0.393    14.968     0.200
     0.468    14.059     0.200
     0.977    12.169     0.200
     1.025    12.039     0.200
     1.041    12.116     0.200
     1.236    11.979     0.200
     1.242    11.933     0.200
     1.243    12.068     0.200
     1.258    11.946     0.200
     1.518    11.736     0.200
     1.632    10.236     0.200
     1.719    10.063     0.200
     1.799    11.301     0.200
     1.861    11.342     0.200
     2.099    10.397     0.200
     2.301    11.440     0.200
     2.255    11.372     0.200
     2.292    11.520     0.200
     2.296    11.781     0.200
     2.331    11.560     0.200
     2.562    11.054     0.200
     2.636    10.709     0.200
     2.542    11.618     0.200
     2.834    11.570     0.200
     3.042    13.229     0.200
     3.026    12.603     0.200
     3.154    13.102     0.200
     3.132    12.873     0.200
     3.200    12.592     0.200
     3.188    12.722     0.200
     3.229    12.339     0.200
     3.420    12.686     0.200
     3.411    13.161     0.200
     3.691    13.104     0.200
     3.772    12.765     0.200
     3.900    13.583     0.200
     4.202    12.526     0.200
     4.323    12.356     0.200
     4.369    14.270     0.200
     4.459    12.785     0.200
     4.392    14.390     0.200
     4.517    13.165     0.200
     4.601    15.636     0.200
     4.700    14.056     0.200
     4.705    13.987     0.200
     4.749    13.339     0.200
     4.837    14.311     0.200
     4.971    13.560     0.200
     5.144    13.927     0.200
     5.240    14.451     0.200
     5.439    15.275     0.200
     5.403    14.303     0.200
     5.431    15.678     0.200
     5.478    14.491     0.200
     5.468    15.366     0.200
     5.495    14.510     0.200
     5.534    14.914     0.200
     5.741    16.010     0.200
     5.731    15.849     0.200
     5.747    15.595     0.200
     5.773    15.633     0.200
     5.894    16.256     0.200
     5.907    16.013     0.200
     5.923    17.093     0.200
     6.017    16.249     0.200
     6.081    16.359     0.200
     6.022    15.851     0.200
     6.151    16.739     0.200
     6.178    16.595     0.200
     6.408    17.067     0.200
     6.433    17.095     0.200
     6.521    17.142     0.200
     6.532    17.242     0.200
     6.562    17.473     0.200
     6.524    17.764     0.200
     6.630    17.748     0.200
     6.679    17.566     0.200
     6.769    17.862     0.200
     6.731    16.196     0.200
     6.881    18.097     0.200
     6.845    16.649     0.200
     6.944    18.059     0.200
     6.964    18.234     0.200
     6.979    17.909     0.200
     7.002    18.508     0.200
     7.129    18.390     0.200
     7.060    16.830     0.200
     7.084    16.963     0.200
     7.190    19.030     0.200
     7.169    17.711     0.200
     7.235    17.915     0.200
     7.224    17.341     0.200
     7.228    17.496     0.200
     7.238    17.289     0.200
     7.240    17.437     0.200
     7.316    19.381     0.200
     7.307    18.887     0.200
     7.440    18.771     0.200
     7.390    17.107     0.200
     7.390    16.998     0.200
     7.444    19.258     0.200
     7.569    19.158     0.200
     7.478    18.319     0.200
     7.478    19.420     0.200
     7.542    17.926     0.200
     7.677    18.522     0.200
     7.885    19.963     0.200
     7.984    19.546     0.200
     7.984    19.515     0.200
     0.888     5.395     0.200
     1.057     6.064     0.200
     1.336     6.524     0.200
     1.553     7.422     0.200
     1.552     7.415     0.200
     1.547     7.162     0.200
     1.668     8.165     0.200
     1.702     7.911     0.200
     1.710     8.368     0.200
     1.796     8.573     0.200
     1.918     8.604     0.200
     1.915     9.209     0.200
     2.011     8.476     0.200
     2.413    10.050     0.200
     2.437     9.682     0.200
     2.876    11.637     0.200
     2.880    11.535     0.200
     2.896    10.428     0.200
     3.186    12.379     0.200
     3.224    10.554     0.200
     3.408    12.460     0.200
     3.503    12.725     0.200
     3.510    13.158     0.200
     3.509    12.317     0.200
     3.806    12.224     0.200
     3.823    12.510     0.200
     3.989    13.606     0.200
     4.033    13.743     0.200
     4.105    13.935     0.200
     4.167    14.201     0.200
     4.537    13.503     0.200
     4.521    13.259     0.200
     4.608    13.467     0.200
     4.610    14.278     0.200
     4.797    15.271     0.200
     4.890    15.102     0.200
     4.935    14.924     0.200
     5.154    16.970     0.200
     5.160    15.862     0.200
     5.229    15.140     0.200
     5.324    15.976     0.200
     5.455    15.141     0.200
     5.664    15.160     0.200
     5.798    15.708     0.200
     5.812    17.043     0.200
     5.849    15.942     0.200
     5.891    15.905     0.200
     6.029    15.434     0.200
     6.189    16.426     0.200
     6.204    16.989     0.200
     6.365    17.673     0.200
     6.388    19.185     0.200
     6.432    16.838     0.200
     6.466    19.570     0.200
     6.515    17.695     0.200
     6.695    17.437     0.200
     6.727    18.310     0.200
     6.891    18.249     0.200
     7.079    19.337     0.200
     7.124    19.000     0.200
     7.220    19.392     0.200
     7.247    19.229     0.200
     7.252    19.360     0.200
     7.279    19.488     0.200
     7.337    19.199     0.200
     7.385    19.102     0.200
     7.462    19.217     0.200
     7.479    19.592     0.200
     7.500    19.611     0.200
     7.517    19.287     0.200
     7.661    20.027     0.200
     7.664    19.379     0.200
     7.771    19.021     0.200
     7.759    19.542     0.200
     7.800    19.713     0.200
     7.829    20.324     0.200
     7.860    20.254     0.200
     7.946    20.526     0.200
     7.977    20.257     0.200
     8.165    21.064     0.200
     8.191    20.820     0.200
     8.265    20.716     0.200
     8.464    22.930     0.200
     8.429    21.486     0.200
     8.570    20.648     0.200
     8.685    22.052     0.200
     8.720    23.869     0.200
     8.747    21.788     0.200
     8.783    19.998     0.200
     8.874    21.139     0.200
     8.860    22.509     0.200
     8.876    24.396     0.200
     8.987    21.899     0.200
     8.989    21.910     0.200
     9.013    22.201     0.200
     9.077    21.809     0.200
     9.077    21.739     0.200
     9.077    22.047     0.200
     9.221    22.169     0.200
     9.221    23.400     0.200
     9.277    22.145     0.200
     9.441    23.350     0.200
     9.441    23.709     0.200
     9.519    22.755     0.200
     9.952    23.866     0.200
    10.573    26.024     0.200
    10.684    25.191     0.200
    10.697    25.224     0.200
    10.986    26.569     0.200
    11.034    28.980     0.200
    11.143    27.451     0.200
    11.153    25.778     0.200
    11.856    27.041     0.200
    11.869    26.171     0.200
    12.085    30.027     0.200
    12.186    28.432     0.200
    15.216    36.791     0.200
    16.032    36.503     0.200
     0.473     5.337     0.200
     0.850     5.563     0.200
     0.996     5.690     0.200
     1.299     7.286     0.200
     1.305     7.440     0.200
     1.319     7.338     0.200
     1.590     6.646     0.200
     1.588     7.994     0.200
     1.638     7.704     0.200
     1.650     7.632     0.200
     1.809     8.149     0.200
     1.808     8.151     0.200
     1.792     7.562     0.200
     1.897     8.190     0.200
     1.958     8.285     0.200
     2.107     8.050     0.200
     2.130     8.382     0.200
     2.371     9.194     0.200
     2.415     9.389     0.200
     2.549     9.564     0.200
     2.843     8.814     0.200
     2.907     9.508     0.200
     2.918    11.262     0.200
     2.918    11.543     0.200
     3.032     9.355     0.200
     3.189    10.589     0.200
     3.189    10.695     0.200
     3.215    11.115     0.200
     3.234     9.968     0.200
     3.258    11.271     0.200
     3.253    10.380     0.200
     3.296    11.287     0.200
     3.526    10.739     0.200
     3.526    10.899     0.200
     3.518    11.387     0.200
     3.640    11.452     0.200
     3.769    11.026     0.200
     4.021    11.656     0.200
     4.021    11.793     0.200
     4.108    11.222     0.200
     4.108    11.094     0.200
     4.194    12.015     0.200
     4.501    12.328     0.200
     4.501    12.777     0.200
     4.594    12.513     0.200
     4.818    13.353     0.200
     4.809    13.692     0.200
     4.874    14.137     0.200
     4.874    14.438     0.200
     4.950    13.681     0.200
     4.996    14.010     0.200
     5.062    13.012     0.200
     5.062    13.813     0.200
     5.059    13.954     0.200
     5.059    13.751     0.200
     5.165    14.130     0.200
     5.297    14.221     0.200
     5.389    14.498     0.200
     5.389    15.103     0.200
     5.429    14.413     0.200
     5.596    15.257     0.200
     5.596    15.136     0.200
     5.635    15.036     0.200
     5.635    15.462     0.200
     5.622    15.378     0.200
     5.778    14.921     0.200
     5.861    15.357     0.200
     5.852    15.916     0.200
     5.905    16.073     0.200
     6.064    15.938     0.200
     6.153    15.956     0.200
     6.153    16.237     0.200
     6.247    15.785     0.200
     6.247    16.035     0.200
     6.306    16.534     0.200
     6.396    16.370     0.200
     6.623    17.394     0.200
     6.738    17.916     0.200
     6.790    18.010     0.200
     6.892    15.814     0.200
     7.054    17.335     0.200
     7.054    16.647     0.200
     7.091    17.264     0.200
     7.103    16.633     0.200
     7.178    17.408     0.200
     7.302    18.463     0.200
     7.304    17.587     0.200
     7.304    18.622     0.200
     7.321    17.109     0.200
     7.344    17.520     0.200
     7.344    17.270     0.200
     7.388    17.740     0.200
     7.388    17.772     0.200
     7.388    17.643     0.200
     7.557    18.890     0.200
     7.599    18.573     0.200
     7.599    19.026     0.200
     7.946    19.646     0.200
     8.322    20.037     0.200
     8.322    19.850     0.200
     8.499    22.080     0.200
     8.533    19.938     0.200
     8.718    22.000     0.200
     8.877    21.127     0.200
     9.304    20.704     0.200
     9.300    21.162     0.200
     9.300    20.767     0.200
    10.192    24.319     0.200
    10.605    25.833     0.200
    10.605    25.727     0.200
    10.740    24.125     0.200
    12.242    28.796     0.200
    13.514    32.368     0.200
    19.461    35.657     0.200
     0.641     5.299     0.200
     0.647     4.977     0.200
     0.753     5.311     0.200
     0.785     4.720     0.200
     0.785     5.322     0.200
     0.806     6.099     0.200
     0.823     5.799     0.200
     0.846     5.831     0.200
     0.886     5.825     0.200
     1.066     6.165     0.200
     1.161     5.834     0.200
     1.195     6.783     0.200
     1.225     6.742     0.200
     1.378     6.858     0.200
     1.491     7.552     0.200
     1.681     8.308     0.200
     1.686     8.072     0.200
     1.989     8.791     0.200
     2.305     8.959     0.200
     2.369     9.053     0.200
     2.632     8.901     0.200
     2.660     8.946     0.200
     2.780     9.474     0.200
     2.790    10.052     0.200
     2.834    10.812     0.200
     2.912    10.338     0.200
     2.969    10.426     0.200
     3.424    10.274     0.200
     3.482    11.188     0.200
     3.599    11.293     0.200
     3.656    11.442     0.200
     3.958    12.214     0.200
     4.117    12.869     0.200
     4.241    11.491     0.200
     4.301    11.664     0.200
     4.462    13.059     0.200
     4.730    13.212     0.200
     4.933    12.953     0.200
     5.068    13.426     0.200
     5.280    15.816     0.200
     5.300    15.004     0.200
     5.323    15.142     0.200
     5.343    15.058     0.200
     5.471    14.677     0.200
     5.526    14.948     0.200
     5.598    15.271     0.200
     5.693    14.878     0.200
     5.822    15.942     0.200
     5.972    15.171     0.200
     6.044    16.007     0.200
     6.054    16.713     0.200
     6.254    17.218     0.200
     6.370    16.539     0.200
     6.379    16.069     0.200
     6.441    17.509     0.200
     6.509    16.688     0.200
     6.534    16.488     0.200
     6.699    18.295     0.200
     6.787    17.260     0.200
     6.839    17.771     0.200
     6.877    17.634     0.200
     6.992    17.645     0.200
     7.098    17.600     0.200
     7.154    18.806     0.200
     7.186    17.903     0.200
     7.267    18.323     0.200
     7.370    18.269     0.200
     7.363    17.481     0.200
     7.526    18.622     0.200
     7.541    19.043     0.200
     7.576    17.754     0.200
     7.701    19.704     0.200
     7.870    19.176     0.200
     7.870    17.930     0.200
     7.870    20.254     0.200
     8.300    20.052     0.200
     8.300    21.310     0.200
     8.775    22.689     0.200
     9.709    23.583     0.200
     0.640     6.111     0.200
     0.655     6.992     0.200
     0.685     6.087     0.200
     0.803     6.127     0.200
     0.820     6.706     0.200
     0.838     6.544     0.200
     0.854     6.188     0.200
     0.936     6.471     0.200
     0.998     6.303     0.200
     1.161     6.729     0.200
     1.356     7.808     0.200
     1.361     7.814     0.200
     1.367     7.695     0.200
     1.375     7.821     0.200
     1.413     7.181     0.200
     1.426     7.263     0.200
     1.486     6.431     0.200
     1.568     7.382     0.200
     1.657     8.215     0.200
     1.693     7.548     0.200
     1.961     8.828     0.200
     1.982     8.491     0.200
     1.972     8.496     0.200
     2.035     8.259     0.200
     2.279     8.403     0.200
     2.310     8.717     0.200
     2.455     9.238     0.200
     2.499     9.572     0.200
     2.581     9.737     0.200
     2.633     9.883     0.200
     3.031     9.241     0.200
     3.050    11.422     0.200
     3.069     9.719     0.200
     3.092    10.107     0.200
     3.234    10.565     0.200
     3.281    11.083     0.200
     3.308    11.347     0.200
     3.322    11.411     0.200
     3.351    11.217     0.200
     3.617    11.536     0.200
     3.681    11.304     0.200
     3.766    12.566     0.200
     3.951    11.303     0.200
     4.121    11.931     0.200
     4.262    11.727     0.200
     4.316    11.826     0.200
     4.401    12.528     0.200
     4.467    12.525     0.200
     4.596    13.216     0.200
     4.662    12.819     0.200
     4.801    13.092     0.200
     4.952    13.500     0.200
     4.990    13.706     0.200
     5.037    14.668     0.200
     5.059    14.631     0.200
     5.095    13.606     0.200
     5.169    14.255     0.200
     5.209    14.172     0.200
     5.252    14.197     0.200
     5.266    14.561     0.200
     5.380    14.265     0.200
     5.450    14.470     0.200
     5.457    14.486     0.200
     5.482    14.885     0.200
     5.566    14.721     0.200
     5.660    14.758     0.200
     5.701    15.521     0.200
     5.717    15.318     0.200
     5.802    15.221     0.200
     5.831    15.104     0.200
     5.904    15.154     0.200
     6.052    16.143     0.200
     6.193    16.426     0.200
     6.185    16.092     0.200
     6.243    16.118     0.200
     6.525    16.836     0.200
     6.575    17.310     0.200
     6.681    17.570     0.200
     6.807    17.753     0.200
     6.884    17.915     0.200
     6.952    17.877     0.200
     6.961    16.245     0.200
     6.986    18.206     0.200
     7.014    16.837     0.200
     7.060    17.854     0.200
     7.237    17.821     0.200
     7.226    17.043     0.200
     7.333    17.534     0.200
     7.424    17.692     0.200
     7.437    17.609     0.200
     7.446    17.559     0.200
     7.483    18.760     0.200
     7.520    18.318     0.200
     7.519    17.692     0.200
     7.601    18.547     0.200
     7.609    18.417     0.200
     7.644    20.276     0.200
     7.721    19.062     0.200
     7.746    19.062     0.200
     7.995    19.145     0.200
     0.151     9.882     0.200
     0.342     9.084     0.200
     0.293     9.123     0.200
     0.337     8.979     0.200
     0.342     8.698     0.200
     0.388     8.666     0.200
     0.516     8.141     0.200
     0.481     8.332     0.200
     0.958     7.785     0.200
     0.966     7.721     0.200
     1.083     7.684     0.200
     1.186     7.624     0.200
     1.186     7.425     0.200
     1.207     7.372     0.200
     1.368     8.564     0.200
     1.388     8.456     0.200
     1.397     8.478     0.200
     1.630     7.919     0.200
     1.677     8.844     0.200
     1.987     9.225     0.200
     2.052     9.100     0.200
     2.180     9.679     0.200
     2.257     9.276     0.200
     2.400     8.800     0.200
     2.469    10.240     0.200
     2.512    10.356     0.200
     2.543     9.163     0.200
     2.571    10.431     0.200
     2.596     9.247     0.200
     2.753    10.307     0.200
     2.979    10.614     0.200
     3.177    12.387     0.200
     3.283    10.706     0.200
     3.330     9.920     0.200
     3.325    12.307     0.200
     3.369    12.434     0.200
     3.448    10.812     0.200
     3.645    12.315     0.200
     3.754    12.988     0.200
     3.866    11.892     0.200
     3.866    12.529     0.200
     4.145    12.851     0.200
     4.219    11.967     0.200
     4.253    12.440     0.200
     4.522    12.725     0.200
     4.533    12.134     0.200
     4.637    12.587     0.200
     4.732    11.954     0.200
     4.760    13.161     0.200
     4.791    14.211     0.200
     4.806    14.778     0.200
     4.854    13.219     0.200
     4.928    12.108     0.200
     4.909    15.154     0.200
     5.164    13.823     0.200
     5.215    13.725     0.200
     5.414    14.602     0.200
     5.542    14.546     0.200
     5.578    14.276     0.200
     5.599    14.880     0.200
     5.678    14.676     0.200
     5.714    15.843     0.200
     5.727    15.669     0.200
     5.779    15.365     0.200
     5.808    15.179     0.200
     5.939    15.674     0.200
     5.986    16.026     0.200
     6.061    15.654     0.200
     6.142    15.789     0.200
     6.222    16.385     0.200
     6.251    16.894     0.200
     6.437    16.449     0.200
     6.581    16.784     0.200
     6.624    17.573     0.200
     6.718    16.864     0.200
     6.855    18.212     0.200
     6.893    17.864     0.200
     6.993    18.228     0.200
     6.992    16.488     0.200
     7.080    18.352     0.200
     7.079    16.236     0.200
     7.174    18.830     0.200
     7.219    18.697     0.200
     7.243    18.930     0.200
     7.302    19.027     0.200
     7.293    16.566     0.200
     7.343    19.130     0.200
     7.460    18.765     0.200
     7.453    17.911     0.200
     7.480    16.982     0.200
     7.482    16.715     0.200
     7.481    17.007     0.200
     7.552    18.776     0.200
     7.606    17.215     0.200
     7.606    17.325     0.200
     7.606    16.875     0.200
     7.675    18.910     0.200
     7.800    18.256     0.200
     7.836    20.341     0.200
     7.863    20.467     0.200
     7.966    18.449     0.200
     8.001    20.596     0.200
     8.021    20.281     0.200
     8.021    19.660     0.200
     8.211    20.932     0.200
     8.471    20.451     0.200
     8.550    19.541     0.200
     9.253    21.505     0.200
     9.327    22.265     0.200
     9.461    23.079     0.200
    10.393    24.828     0.200
    12.954    28.345     0.200
    13.847    29.373     0.200
     0.354     3.936     0.200
     1.024     5.211     0.200
     1.471     7.113     0.200
     1.518     7.187     0.200
     1.581     7.439     0.200
     1.547     7.861     0.200
     1.668     8.061     0.200
     1.752     7.973     0.200
     1.715     7.167     0.200
     1.864     7.658     0.200
     1.850     7.982     0.200
     1.850     6.884     0.200
     1.860     8.052     0.200
     2.019     8.595     0.200
     2.070     8.120     0.200
     2.263     8.745     0.200
     2.442     9.049     0.200
     2.483     8.672     0.200
     2.427     9.326     0.200
     2.507     9.440     0.200
     2.680     9.120     0.200
     2.757     9.194     0.200
     2.806     8.854     0.200
     3.201    10.541     0.200
     3.282    10.918     0.200
     3.310    10.555     0.200
     3.437    10.717     0.200
     3.501    11.472     0.200
     3.529    10.966     0.200
     3.572    10.574     0.200
     3.841    10.981     0.200
     3.874    11.395     0.200
     3.889    11.483     0.200
     3.968    10.936     0.200
     3.992    11.785     0.200
     4.094    12.018     0.200
     4.126    12.256     0.200
     4.250    12.728     0.200
     4.490    12.484     0.200
     4.518    13.355     0.200
     4.500    13.212     0.200
     4.678    13.018     0.200
     4.827    13.080     0.200
     4.936    13.249     0.200
     4.903    14.128     0.200
     5.061    13.783     0.200
     5.066    14.089     0.200
     5.096    14.246     0.200
     5.127    14.515     0.200
     5.140    14.438     0.200
     5.219    13.782     0.200
     5.259    14.676     0.200
     5.334    14.374     0.200
     5.284    14.107     0.200
     5.415    14.041     0.200
     5.437    13.861     0.200
     5.529    15.111     0.200
     5.590    15.218     0.200
     5.640    15.048     0.200
     5.751    14.383     0.200
     5.807    15.072     0.200
     5.827    15.039     0.200
     5.950    14.440     0.200
     5.942    15.239     0.200
     6.134    15.131     0.200
     6.310    15.254     0.200
     6.761    16.771     0.200
     6.761    16.189     0.200
     6.967    17.266     0.200
     7.074    17.207     0.200
     7.157    17.316     0.200
     7.175    18.249     0.200
     7.210    17.300     0.200
     7.225    17.572     0.200
     7.225    17.881     0.200
     7.278    17.855     0.200
     7.741    18.975     0.200
     8.040    19.142     0.200
     8.144    19.984     0.200
     8.562    20.650     0.200
     9.176    20.930     0.200
     9.152    21.553     0.200
    10.049    24.273     0.200
    10.730    25.406     0.200
    18.930    37.652     0.200
     0.531     6.589     0.200
     0.585     6.413     0.200
     0.594     6.693     0.200
     0.704     6.791     0.200
     0.698     6.658     0.200
     0.737     6.648     0.200
     0.745     6.701     0.200
     0.851     6.390     0.200
     0.902     6.579     0.200
     0.982     5.872     0.200
     0.982     6.266     0.200
     0.965     6.815     0.200
     0.978     6.565     0.200
     1.086     6.253     0.200
     1.086     6.475     0.200
     1.104     6.934     0.200
     1.319     6.863     0.200
     1.319     6.624     0.200
     1.319     7.069     0.200
     1.764     7.065     0.200
     1.764     6.952     0.200
     1.996     8.985     0.200
     1.999     9.347     0.200
     2.015     9.131     0.200
     2.305     9.892     0.200
     2.618    10.333     0.200
     2.645    10.420     0.200
     2.683    10.275     0.200
     2.699    10.679     0.200
     2.750    10.622     0.200
     2.750    10.127     0.200
     3.091    10.119     0.200
     3.101    11.486     0.200
     3.130    10.198     0.200
     3.145    11.198     0.200
     3.206    11.506     0.200
     3.278    11.773     0.200
     3.573    11.192     0.200
     3.788    13.358     0.200
     3.755    11.696     0.200
     3.755    12.940     0.200
     3.860    11.979     0.200
     3.958    13.141     0.200
     3.959    12.557     0.200
     4.003    13.276     0.200
     4.278    13.537     0.200
     4.458    12.975     0.200
     4.486    13.662     0.200
     4.769    12.754     0.200
     4.779    13.730     0.200
     5.112    13.559     0.200
     5.236    13.983     0.200
     5.257    13.122     0.200
     5.401    15.423     0.200
     5.433    13.027     0.200
     5.444    14.504     0.200
     5.556    14.379     0.200
     5.791    15.194     0.200
     5.930    15.080     0.200
     6.050    15.920     0.200
     6.080    16.102     0.200
     6.107    15.874     0.200
     6.123    15.777     0.200
     6.195    15.946     0.200
     6.217    15.898     0.200
     6.297    15.869     0.200
     6.336    15.956     0.200
     6.362    16.751     0.200
     6.376    16.647     0.200
     6.639    16.882     0.200
     6.664    17.017     0.200
     6.860    17.080     0.200
     6.902    17.385     0.200
     6.953    17.285     0.200
     7.171    16.734     0.200
     7.209    18.103     0.200
     7.310    18.412     0.200
     7.359    18.227     0.200
     7.410    17.557     0.200
     7.520    18.877     0.200
     7.635    19.285     0.200
     7.627    17.712     0.200
     7.677    19.359     0.200
     7.719    18.813     0.200
     7.710    17.830     0.200
     7.792    19.603     0.200
     7.782    18.096     0.200
     7.898    19.286     0.200
     7.923    18.705     0.200
     8.064    19.610     0.200
     8.089    19.060     0.200
     8.115    19.014     0.200
     8.139    19.720     0.200
     8.233    19.126     0.200
     8.233    18.905     0.200
     8.323    21.268     0.200
     8.485    21.029     0.200
     8.487    21.127     0.200
     8.487    21.146     0.200
     8.570    21.093     0.200
     8.570    20.323     0.200
     9.175    22.155     0.200
     9.455    23.616     0.200
     0.217     9.901     0.200
     0.299     9.319     0.200
     0.496     8.207     0.200
     0.539     7.760     0.200
     0.584     8.243     0.200
     0.610     7.861     0.200
     0.729     7.552     0.200
     0.852     7.668     0.200
     0.840     7.402     0.200
     0.990     8.046     0.200
     1.062     7.152     0.200
     1.062     7.283     0.200
     1.008     8.121     0.200
     1.013     8.038     0.200
     1.310     7.450     0.200
     1.310     7.278     0.200
     1.299     8.285     0.200
     1.361     7.686     0.200
     1.458     7.877     0.200
     1.614     8.623     0.200
     1.679     8.405     0.200
     1.700     8.553     0.200
     1.774     8.174     0.200
     1.774     9.014     0.200
     1.892     8.813     0.200
     1.854     8.688     0.200
     2.099     9.256     0.200
     2.138     8.385     0.200
     2.143     9.695     0.200
     2.193     8.593     0.200
     2.211     9.468     0.200
     2.277     9.501     0.200
     2.757     9.898     0.200
     2.878     9.784     0.200
     2.906    10.853     0.200
     2.931    10.657     0.200
     2.961    10.979     0.200
     3.002    11.153     0.200
     3.042     9.906     0.200
     3.275    11.405     0.200
     3.463    10.880     0.200
     3.519    11.680     0.200
     3.477    11.834     0.200
     3.778    12.230     0.200
     3.813    10.956     0.200
     4.035    11.696     0.200
     4.237    11.915     0.200
     4.411    13.192     0.200
     4.451    12.466     0.200
     4.528    12.187     0.200
     4.568    12.275     0.200
     4.570    13.387     0.200
     4.769    12.916     0.200
     4.810    13.414     0.200
     5.012    13.580     0.200
     5.114    14.058     0.200
     5.137    13.857     0.200
     5.187    13.819     0.200
     5.215    13.747     0.200
     5.289    14.099     0.200
     5.358    15.606     0.200
     5.402    15.131     0.200
     5.451    13.870     0.200
     5.738    15.453     0.200
     5.873    16.444     0.200
     5.874    15.945     0.200
     5.998    15.932     0.200
     6.048    15.717     0.200
     6.068    15.776     0.200
     6.220    16.902     0.200
     6.320    16.143     0.200
     6.463    16.465     0.200
     6.504    16.375     0.200
     6.616    17.561     0.200
     6.695    17.647     0.200
     6.829    17.527     0.200
     6.924    17.801     0.200
     6.916    17.543     0.200
     6.955    18.005     0.200
     7.075    18.122     0.200
     7.095    17.537     0.200
     7.111    17.973     0.200
     7.438    18.777     0.200
     7.597    19.449     0.200
    10.019    22.546     0.200
    10.380    24.899     0.200
    12.615    29.693     0.200
     0.214    10.813     0.200
     0.296    10.378     0.200
     0.543     8.322     0.200
     0.492     8.838     0.200
     0.585     8.797     0.200
     0.609     8.433     0.200
     0.732     8.029     0.200
     0.839     7.834     0.200
     0.983     8.594     0.200
     1.068     7.490     0.200
     0.985     8.577     0.200
     1.001     8.540     0.200
     1.001     8.854     0.200
     1.006     8.471     0.200
     1.318     7.535     0.200
     1.292     8.659     0.200
     1.364     7.963     0.200
     1.461     8.526     0.200
     1.516     8.438     0.200
     1.606     8.797     0.200
     1.671     8.581     0.200
     1.900     8.042     0.200
     1.850     8.954     0.200
     2.092     9.282     0.200
     2.134     8.724     0.200
     2.136     9.860     0.200
     2.189     8.719     0.200
     2.270     9.737     0.200
     2.749     9.844     0.200
     2.872    10.067     0.200
     2.923     9.502     0.200
     2.924    10.752     0.200
     2.951    11.120     0.200
     2.954    10.868     0.200
     2.994    10.849     0.200
     3.268    11.499     0.200
     3.458    10.986     0.200
     3.470    11.752     0.200
     3.770    12.186     0.200
     3.809    11.338     0.200
     4.029    11.515     0.200
     4.231    12.274     0.200
     4.324    11.350     0.200
     4.363    12.651     0.200
     4.445    12.501     0.200
     4.524    11.679     0.200
     4.560    13.946     0.200
     4.562    13.453     0.200
     4.584    13.473     0.200
     4.766    12.940     0.200
     4.805    13.234     0.200
     5.008    13.464     0.200
     5.107    13.605     0.200
     5.133    14.046     0.200
     5.209    13.617     0.200
     5.282    13.825     0.200
     5.351    14.533     0.200
     5.354    14.255     0.200
     5.397    15.070     0.200
     5.448    14.338     0.200
     5.597    15.818     0.200
     5.734    15.879     0.200
     5.866    15.227     0.200
     5.866    15.014     0.200
     5.905    15.606     0.200
     5.994    15.844     0.200
     6.045    15.967     0.200
     6.064    15.613     0.200
     6.190    15.949     0.200
     6.460    16.675     0.200
     6.495    16.853     0.200
     6.501    16.668     0.200
     6.614    17.015     0.200
     6.692    17.596     0.200
     6.696    15.459     0.200
     6.826    17.467     0.200
     6.794    16.024     0.200
     6.922    18.443     0.200
     6.952    17.674     0.200
     7.104    17.116     0.200
     7.142    18.353     0.200
     7.217    16.555     0.200
     7.304    18.296     0.200
     7.392    17.458     0.200
     7.560    18.532     0.200
     7.592    18.933     0.200
     7.611    17.338     0.200
     7.700    18.603     0.200
     0.732     6.800     0.200
     0.872     7.042     0.200
     0.880     7.467     0.200
     0.957     7.500     0.200
     1.035     7.308     0.200
     1.053     7.209     0.200
     1.087     7.151     0.200
     1.069     6.939     0.200
     1.120     7.194     0.200
     1.190     7.347     0.200
     1.194     7.334     0.200
     1.257     7.834     0.200
     1.364     7.671     0.200
     1.450     7.506     0.200
     1.505     7.786     0.200
     1.519     7.868     0.200
     1.636     8.124     0.200
     1.615     7.665     0.200
     1.615     7.767     0.200
     2.324     8.671     0.200
     2.327     8.807     0.200
     2.507     9.339     0.200
     2.529    10.379     0.200
     2.838    10.832     0.200
     3.152    11.299     0.200
     3.217    11.244     0.200
     3.273    11.112     0.200
     3.386    10.016     0.200
     3.570    11.225     0.200
     3.601    11.286     0.200
     3.637    12.298     0.200
     3.681    12.225     0.200
     3.814    12.776     0.200
     3.814    12.635     0.200
     3.983    12.147     0.200
     4.028    12.311     0.200
     4.093    12.269     0.200
     4.075    11.909     0.200
     4.112    12.212     0.200
     4.307    13.202     0.200
     4.319    11.814     0.200
     4.356    12.210     0.200
     4.402    12.344     0.200
     4.469    13.639     0.200
     4.496    14.004     0.200
     4.495    13.804     0.200
     4.539    13.950     0.200
     4.813    14.421     0.200
     4.870    14.039     0.200
     4.962    14.009     0.200
     5.011    14.291     0.200
     5.242    13.771     0.200
     5.269    14.900     0.200
     5.274    14.513     0.200
     5.315    14.861     0.200
     5.541    14.536     0.200
     5.661    14.937     0.200
     5.710    14.267     0.200
     5.744    15.251     0.200
     5.870    14.480     0.200
     5.918    15.918     0.200
     5.942    16.037     0.200
     5.946    15.581     0.200
     6.059    15.781     0.200
     6.086    16.918     0.200
     6.280    16.304     0.200
     6.373    16.250     0.200
     6.539    16.673     0.200
     6.605    16.801     0.200
     6.647    16.716     0.200
     6.696    16.977     0.200
     6.727    16.716     0.200
     6.720    16.861     0.200
     6.757    17.126     0.200
     6.820    16.991     0.200
     6.858    17.323     0.200
     6.889    16.937     0.200
     6.898    17.480     0.200
     7.011    17.580     0.200
     7.111    18.033     0.200
     7.107    18.063     0.200
     7.142    18.046     0.200
     7.276    17.765     0.200
     7.275    17.744     0.200
     7.287    18.403     0.200
     7.334    18.402     0.200
     7.371    18.640     0.200
     7.400    18.671     0.200
     7.412    19.411     0.200
     7.424    17.790     0.200
     7.615    19.094     0.200
     7.629    18.050     0.200
     7.758    19.091     0.200
     7.773    18.912     0.200
     7.772    19.360     0.200
     7.899    19.602     0.200
     8.071    19.711     0.200
     8.080    20.571     0.200
     8.164    18.245     0.200
     8.157    20.326     0.200
     8.179    20.001     0.200
     8.242    18.443     0.200
     8.262    21.056     0.200
     8.322    19.083     0.200
     8.401    20.059     0.200
     8.455    18.646     0.200
     8.628    19.905     0.200
     8.635    21.678     0.200
     8.647    20.628     0.200
     8.650    19.362     0.200
     8.728    19.750     0.200
     8.739    21.966     0.200
     8.761    19.430     0.200
     8.761    19.454     0.200
     8.761    19.172     0.200
     8.895    21.223     0.200
     8.898    22.611     0.200
     9.021    21.060     0.200
     9.021    21.755     0.200
     9.016    22.231     0.200
     9.034    21.968     0.200
     9.034    21.937     0.200
     9.538    22.845     0.200
     9.531    22.690     0.200
     9.536    23.668     0.200
     9.703    21.730     0.200
    10.336    24.874     0.200
    10.489    25.383     0.200
    11.130    27.025     0.200
    11.522    23.748     0.200
    14.958    31.958     0.200
    14.958    33.122     0.200
    15.892    33.312     0.200
    18.413    34.083     0.200
     1.684     8.446     0.200
     1.688     8.518     0.200
     1.692     8.506     0.200
     1.705     8.510     0.200
     1.708     8.560     0.200
     1.996     9.478     0.200
     2.313     9.855     0.200
     2.377    10.036     0.200
     2.361    10.079     0.200
     2.487     9.755     0.200
     2.487     9.599     0.200
     2.658    10.471     0.200
     2.688    11.076     0.200
     2.798    10.721     0.200
     2.842    10.964     0.200
     2.875    11.839     0.200
     2.918    11.637     0.200
     2.977    11.734     0.200
     3.110    11.078     0.200
     3.106    11.096     0.200
     3.106    10.863     0.200
     3.139    13.870     0.200
     3.419    13.588     0.200
     3.419    11.367     0.200
     3.407    11.569     0.200
     3.447    12.072     0.200
     3.470    11.877     0.200
     3.583    11.971     0.200
     3.583    11.709     0.200
     3.629    13.728     0.200
     3.629    11.919     0.200
     3.632    12.788     0.200
     3.655    13.169     0.200
     3.664    13.794     0.200
     3.699    13.748     0.200
     3.742    13.682     0.200
     3.968    14.402     0.200
     3.974    13.209     0.200
     4.058    13.647     0.200
     4.132    13.812     0.200
     4.132    14.487     0.200
     4.329    13.430     0.200
     4.200    14.819     0.200
     4.208    14.780     0.200
     4.242    14.774     0.200
     4.242    15.258     0.200
     4.472    14.899     0.200
     4.472    14.770     0.200
     4.423    13.181     0.200
     4.638    14.482     0.200
     4.638    13.978     0.200
     4.695    14.316     0.200
     4.765    14.556     0.200
     4.800    13.975     0.200
     4.800    13.706     0.200
     4.843    15.144     0.200
     4.966    13.971     0.200
     5.040    15.090     0.200
     4.894    17.419     0.200
     5.083    15.948     0.200
     5.083    15.426     0.200
     5.099    14.955     0.200
     5.165    15.192     0.200
     5.165    14.993     0.200
     5.205    16.017     0.200
     5.285    17.333     0.200
     5.290    16.290     0.200
     5.312    15.459     0.200
     5.312    15.125     0.200
     5.368    15.935     0.200
     5.467    16.066     0.200
     5.628    16.482     0.200
     5.727    17.375     0.200
     5.763    17.128     0.200
     5.731    16.856     0.200
     5.828    17.326     0.200
     5.828    16.775     0.200
     5.826    16.710     0.200
     5.829    17.254     0.200
     5.861    16.545     0.200
     5.862    17.006     0.200
     5.915    17.038     0.200
     5.945    17.691     0.200
     5.945    17.361     0.200
     6.054    18.309     0.200
     6.054    18.024     0.200
     6.062    18.413     0.200
     5.913    18.528     0.200
     6.112    17.855     0.200
     6.112    17.703     0.200
     6.169    18.429     0.200
     6.148    18.121     0.200
     6.204    17.373     0.200
     6.249    18.638     0.200
     6.249    18.142     0.200
     6.269    18.101     0.200
     6.237    17.653     0.200
     6.221    19.112     0.200
     6.407    17.508     0.200
     6.432    17.818     0.200
     6.305    19.802     0.200
     6.418    18.223     0.200
     6.427    17.801     0.200
     6.424    18.186     0.200
     6.500    18.779     0.200
     6.500    18.121     0.200
     6.476    18.283     0.200
     6.482    18.712     0.200
     6.547    18.413     0.200
     6.547    18.290     0.200
     6.584    19.028     0.200
     6.584    18.081     0.200
     6.547    18.644     0.200
     6.715    18.921     0.200
     6.734    19.282     0.200
     6.734    18.392     0.200
     6.794    18.886     0.200
     6.794    18.501     0.200
     6.766    19.079     0.200
     6.766    18.811     0.200
     6.793    19.066     0.200
     6.860    19.485     0.200
     6.825    19.219     0.200
     6.876    18.885     0.200
     6.755    19.987     0.200
     6.885    19.131     0.200
     6.916    19.648     0.200
     7.030    19.821     0.200
     7.089    20.136     0.200
     7.139    20.007     0.200
     7.192    20.357     0.200
     7.225    20.144     0.200
     7.317    18.549     0.200
     7.317    18.973     0.200
     7.319    20.364     0.200
     7.377    19.594     0.200
     7.516    20.157     0.200
     7.516    19.468     0.200
     7.558    21.258     0.200
     7.558    20.183     0.200
     7.558    20.376     0.200
     7.558    19.491     0.200
     7.589    19.753     0.200
     7.460    22.427     0.200
     7.567    20.556     0.200
     7.567    20.455     0.200
     7.701    20.390     0.200
     7.559    22.203     0.200
     7.725    20.621     0.200
     7.601    22.265     0.200
     7.783    20.821     0.200
     7.783    19.776     0.200
     7.786    20.285     0.200
     7.786    19.777     0.200
     7.795    18.981     0.200
     7.795    20.200     0.200
     7.795    20.393     0.200
     7.846    21.577     0.200
     7.886    20.649     0.200
     7.886    20.029     0.200
     7.845    20.711     0.200
     7.919    20.710     0.200
     7.992    20.957     0.200
     7.987    21.212     0.200
     7.987    20.538     0.200
     8.007    22.086     0.200
     8.083    20.974     0.200
     8.083    20.333     0.200
     8.111    21.135     0.200
     8.104    21.797     0.200
     8.104    21.327     0.200
     8.122    21.788     0.200
     8.216    23.278     0.200
     8.418    22.002     0.200
     8.418    21.488     0.200
     8.424    22.532     0.200
     8.626    22.761     0.200
     8.626    22.267     0.200
     8.663    21.822     0.200
     8.663    21.283     0.200
     8.660    24.576     0.200
     8.678    23.007     0.200
     8.747    23.801     0.200
     8.747    21.732     0.200
     8.824    22.043     0.200
     9.058    22.679     0.200
     8.998    24.109     0.200
     9.426    24.186     0.200
     9.426    23.145     0.200
     9.577    24.764     0.200
     9.713    24.568     0.200
     9.713    23.326     0.200
     9.964    24.848     0.200
     9.964    24.971     0.200
    10.171    24.092     0.200
    10.171    23.957     0.200
    10.222    25.969     0.200
    10.295    26.081     0.200
    10.295    25.923     0.200
    10.676    25.460     0.200
    11.151    27.189     0.200
    11.867    27.989     0.200
    11.786    27.748     0.200
    11.916    28.599     0.200
    11.916    27.661     0.200
    12.757    31.493     0.200
    12.757    30.954     0.200
    12.762    30.883     0.200
    13.700    30.179     0.200
    13.700    30.313     0.200
    14.053    31.923     0.200
    14.053    31.682     0.200
    14.053    31.305     0.200
    14.222    33.312     0.200
    16.598    36.610     0.200
    17.503    34.938     0.200
    17.503    34.465     0.200
     0.531     6.003     0.200
     0.531     5.753     0.200
     0.767     5.813     0.200
     0.836     5.898     0.200
     0.926     6.601     0.200
     0.954     6.370     0.200
     0.938     6.364     0.200
     0.849     6.055     0.200
     0.849     6.278     0.200
     1.008     6.263     0.200
     1.071     6.257     0.200
     1.225     6.300     0.200
     1.381     6.576     0.200
     1.567     6.735     0.200
     1.867     8.118     0.200
     1.871     8.122     0.200
     1.876     7.987     0.200
     1.888     8.022     0.200
     1.892     8.558     0.200
     2.178     8.749     0.200
     2.178     8.654     0.200
     2.495    10.277     0.200
     2.491    10.389     0.200
     2.491     9.393     0.200
     2.501     9.294     0.200
     2.559     9.884     0.200
     2.678     9.016     0.200
     2.673    10.174     0.200
     2.799     9.239     0.200
     2.823     9.540     0.200
     2.823     9.267     0.200
     2.979    10.802     0.200
     3.078     9.808     0.200
     3.085     9.855     0.200
     3.024    10.945     0.200
     3.102    10.794     0.200
     3.244    10.008     0.200
     3.177    10.497     0.200
     3.302    10.385     0.200
     3.302    10.284     0.200
     3.535    10.252     0.200
     3.535    10.135     0.200
     3.585    11.877     0.200
     3.585    11.135     0.200
     3.596    10.515     0.200
     3.662    10.613     0.200
     3.724    11.562     0.200
     3.724    10.995     0.200
     3.809    11.648     0.200
     3.809    11.468     0.200
     3.811    11.393     0.200
     3.846    11.934     0.200
     3.879    13.049     0.200
     3.921    11.970     0.200
     4.093    10.033     0.200
     4.100    10.214     0.200
     4.164    11.042     0.200
     4.146    12.467     0.200
     4.211    12.019     0.200
     4.211    12.144     0.200
     4.301    12.893     0.200
     4.301    12.761     0.200
     4.393    12.456     0.200
     4.462    12.405     0.200
     4.492    11.849     0.200
     4.650    14.093     0.200
     4.650    12.956     0.200
     4.685    13.304     0.200
     4.786    12.616     0.200
     4.833    12.729     0.200
     4.872    13.192     0.200
     4.793    12.840     0.200
     4.840    13.819     0.200
     4.840    12.870     0.200
     4.867    13.677     0.200
     4.921    12.776     0.200
     4.998    13.615     0.200
     5.164    13.074     0.200
     5.078    12.605     0.200
     5.190    14.099     0.200
     5.190    13.740     0.200
     5.220    13.908     0.200
     5.255    14.539     0.200
     5.255    13.367     0.200
     5.265    14.060     0.200
     5.265    13.728     0.200
     5.324    14.325     0.200
     5.482    14.068     0.200
     5.470    14.699     0.200
     5.470    14.500     0.200
     5.504    14.646     0.200
     5.504    14.146     0.200
     5.510    14.477     0.200
     5.582    14.680     0.200
     5.854    14.228     0.200
     5.854    14.005     0.200
     5.752    15.055     0.200
     5.752    14.860     0.200
     5.816    15.174     0.200
     5.929    15.318     0.200
     5.909    15.544     0.200
     6.069    14.684     0.200
     5.936    15.471     0.200
     5.982    15.278     0.200
     5.964    15.086     0.200
     5.992    15.497     0.200
     5.992    15.208     0.200
     6.033    15.592     0.200
     6.082    16.070     0.200
     6.185    16.421     0.200
     6.232    16.195     0.200
     6.232    16.093     0.200
     6.244    16.848     0.200
     6.225    16.216     0.200
     6.301    17.931     0.200
     6.321    16.449     0.200
     6.321    16.336     0.200
     6.319    16.122     0.200
     6.439    16.338     0.200
     6.492    16.719     0.200
     6.496    16.772     0.200
     6.504    16.736     0.200
     6.515    16.447     0.200
     6.540    16.794     0.200
     6.550    16.610     0.200
     6.700    16.069     0.200
     6.578    16.888     0.200
     6.635    17.876     0.200
     6.635    17.646     0.200
     6.634    17.065     0.200
     6.720    17.466     0.200
     6.767    17.512     0.200
     6.796    17.434     0.200
     6.836    17.916     0.200
     6.835    17.853     0.200
     6.835    17.462     0.200
     6.870    17.564     0.200
     6.913    17.801     0.200
     6.939    17.577     0.200
     6.939    18.037     0.200
     6.967    17.780     0.200
     6.980    18.042     0.200
     6.989    18.019     0.200
     7.037    18.123     0.200
     7.112    18.327     0.200
     7.158    18.374     0.200
     7.202    18.461     0.200
     7.280    18.522     0.200
     7.297    18.741     0.200
     7.382    18.969     0.200
     7.387    18.736     0.200
     7.390    18.843     0.200
     7.493    17.558     0.200
     7.493    18.238     0.200
     7.483    19.182     0.200
     7.489    18.685     0.200
     7.549    17.409     0.200
     7.628    18.938     0.200
     7.628    19.098     0.200
     7.699    18.180     0.200
     7.699    19.297     0.200
     7.724    18.627     0.200
     7.724    19.295     0.200
     7.746    18.498     0.200
     7.746    19.076     0.200
     7.761    17.512     0.200
     7.946    18.707     0.200
     7.806    20.792     0.200
     7.870    20.184     0.200
     7.994    18.219     0.200
     8.027    18.279     0.200
     7.902    19.132     0.200
     7.956    18.426     0.200
     7.956    19.680     0.200
     7.958    19.721     0.200
     7.958    19.256     0.200
     7.975    18.503     0.200
     7.975    18.652     0.200
     7.970    18.472     0.200
     7.946    20.436     0.200
     7.968    19.214     0.200
     8.136    18.806     0.200
     8.054    18.557     0.200
     8.054    18.275     0.200
     8.054    18.795     0.200
     8.163    18.531     0.200
     8.104    20.843     0.200
     8.135    20.236     0.200
     8.135    19.853     0.200
     8.182    19.799     0.200
     8.230    20.163     0.200
     8.230    20.280     0.200
     8.240    20.964     0.200
     8.247    20.725     0.200
     8.247    20.733     0.200
     8.600    20.208     0.200
     8.600    21.263     0.200
     8.744    20.899     0.200
     8.744    20.321     0.200
     8.865    19.698     0.200
     8.743    22.647     0.200
     8.765    21.916     0.200
     8.765    21.619     0.200
     8.753    21.886     0.200
     8.754    22.136     0.200
     8.840    20.958     0.200
     8.840    21.134     0.200
     8.945    19.781     0.200
     8.919    21.512     0.200
     8.991    21.496     0.200
     8.991    21.785     0.200
     9.041    22.775     0.200
     9.128    22.529     0.200
     9.580    20.871     0.200
     9.569    22.573     0.200
     9.569    22.967     0.200
     9.705    22.855     0.200
     9.899    22.411     0.200
     9.899    22.907     0.200
     9.964    22.305     0.200
    10.005    23.711     0.200
    10.005    23.832     0.200
    10.166    21.962     0.200
    10.166    21.735     0.200
    10.246    24.015     0.200
    10.389    23.674     0.200
    10.357    24.142     0.200
    10.357    23.732     0.200
    10.511    24.061     0.200
    10.647    23.203     0.200
    10.848    23.177     0.200
    10.848    23.607     0.200
    11.292    24.642     0.200
    11.337    26.265     0.200
    11.337    25.944     0.200
    11.759    25.030     0.200
    11.759    25.389     0.200
    11.907    25.989     0.200
    11.907    26.489     0.200
    12.011    28.880     0.200
    12.011    27.482     0.200
    12.783    30.918     0.200
    12.783    29.348     0.200
    13.012    27.766     0.200
    13.309    31.444     0.200
    13.718    30.600     0.200
    14.195    29.632     0.200
    14.203    31.355     0.200
    14.203    31.859     0.200
    14.203    31.456     0.200
    16.583    32.212     0.200
    17.645    34.486     0.200
    17.645    34.384     0.200
     0.494     5.844     0.200
     0.578     6.120     0.200
     0.641     5.821     0.200
     0.645     6.597     0.200
     0.677     6.828     0.200
     0.699     6.140     0.200
     0.769     6.217     0.200
     0.778     6.281     0.200
     0.783     5.982     0.200
     0.842     5.655     0.200
     0.835     6.372     0.200
     1.175     6.813     0.200
     1.336     6.760     0.200
     1.481     7.698     0.200
     1.493     7.698     0.200
     1.496     7.537     0.200
     1.786     8.353     0.200
     2.009     7.576     0.200
     2.103     8.832     0.200
     2.158     9.418     0.200
     2.167     8.842     0.200
     2.194     8.837     0.200
     2.272     8.680     0.200
     2.290     9.480     0.200
     2.490     8.690     0.200
     2.526     8.910     0.200
     2.589     9.886     0.200
     2.633    10.370     0.200
     2.707    10.101     0.200
     2.768    10.289     0.200
     2.896     9.991     0.200
     2.902     9.645     0.200
     3.244    10.784     0.200
     3.224    12.078     0.200
     3.261    10.340     0.200
     3.269    10.076     0.200
     3.490    11.853     0.200
     3.535    11.746     0.200
     3.760    12.012     0.200
     3.874    11.722     0.200
     3.934    12.238     0.200
     3.987    12.183     0.200
     4.166    11.555     0.200
     4.264    12.692     0.200
     4.279    12.868     0.200
     4.356    11.075     0.200
     4.329    12.024     0.200
     4.361    11.765     0.200
     4.453    12.525     0.200
     4.519    12.080     0.200
     4.634    12.601     0.200
     4.649    11.768     0.200
     4.657    12.696     0.200
     4.824    11.843     0.200
     4.859    12.867     0.200
     4.949    13.225     0.200
     5.072    15.425     0.200
     5.079    13.938     0.200
     5.101    14.595     0.200
     5.196    14.036     0.200
     5.473    14.501     0.200
     5.567    15.111     0.200
     5.619    14.875     0.200
     5.634    15.225     0.200
     5.640    14.588     0.200
     5.721    15.048     0.200
     5.728    15.215     0.200
     5.760    15.701     0.200
     5.777    15.799     0.200
     5.847    16.046     0.200
     5.853    16.591     0.200
     6.042    15.880     0.200
     6.056    16.176     0.200
     6.069    15.417     0.200
     6.127    15.843     0.200
     6.293    15.602     0.200
     6.316    16.526     0.200
     6.316    16.325     0.200
     6.345    15.464     0.200
     6.373    17.102     0.200
     6.605    17.168     0.200
     6.618    16.483     0.200
     6.706    17.303     0.200
     6.755    17.261     0.200
     6.760    17.875     0.200
     6.815    17.513     0.200
     6.919    18.048     0.200
     6.991    17.823     0.200
     7.073    17.963     0.200
     7.124    18.505     0.200
     7.175    16.854     0.200
     7.183    18.717     0.200
     7.190    18.567     0.200
     7.304    18.150     0.200
     7.299    18.181     0.200
     7.361    17.681     0.200
     7.388    17.562     0.200
     7.587    18.106     0.200
     7.591    18.381     0.200
     7.687    18.232     0.200
     7.687    17.751     0.200
     7.761    18.966     0.200
     7.808    18.432     0.200
     7.842    19.369     0.200
     7.947    19.630     0.200
     7.965    19.708     0.200
     8.208    19.678     0.200
     8.454    21.666     0.200
     8.627    19.584     0.200
     8.958    20.904     0.200
     9.250    20.869     0.200
    10.473    23.081     0.200
     1.393     6.847     0.200
     2.750    10.725     0.200
     2.755    10.797     0.200
     2.761    10.767     0.200
     2.769    10.684     0.200
     2.776    10.719     0.200
     2.888     8.331     0.200
     3.058    11.232     0.200
     3.058    11.105     0.200
     3.256    11.180     0.200
     3.292    10.750     0.200
     3.285    11.291     0.200
     3.373    11.553     0.200
     3.436    11.468     0.200
     3.537    11.852     0.200
     3.631     8.565     0.200
     3.636     8.243     0.200
     3.551    10.986     0.200
     3.577    11.525     0.200
     3.555    11.330     0.200
     3.849     9.833     0.200
     3.854    12.532     0.200
     3.898    12.585     0.200
     3.982    12.596     0.200
     4.032    12.894     0.200
     4.176    12.536     0.200
     4.201    13.239     0.200
     4.231    11.551     0.200
     4.365    12.440     0.200
     4.409    12.672     0.200
     4.409    13.258     0.200
     4.467    13.363     0.200
     4.467    13.198     0.200
     4.587    11.924     0.200
     4.552    13.317     0.200
     4.678    14.081     0.200
     4.720    14.172     0.200
     4.787    14.847     0.200
     4.935    14.718     0.200
     4.950    11.942     0.200
     4.992    13.686     0.200
     5.010    15.041     0.200
     5.132    14.426     0.200
     5.169    13.712     0.200
     5.286    15.166     0.200
     5.292    15.180     0.200
     5.454    14.628     0.200
     5.599    12.113     0.200
     5.514    14.879     0.200
     5.514    15.074     0.200
     5.584    15.759     0.200
     5.574    14.861     0.200
     5.578    14.150     0.200
     5.578    14.268     0.200
     5.588    13.925     0.200
     5.588    14.745     0.200
     5.699    13.951     0.200
     5.780    15.099     0.200
     5.840    14.551     0.200
     5.840    15.161     0.200
     5.954    15.439     0.200
     5.954    16.549     0.200
     6.096    16.532     0.200
     6.242    16.661     0.200
     6.320    16.018     0.200
     6.353    17.333     0.200
     6.398    17.045     0.200
     6.415    16.452     0.200
     6.415    16.819     0.200
     6.542    16.315     0.200
     6.542    16.620     0.200
     6.745    17.528     0.200
     6.761    17.326     0.200
     6.761    17.803     0.200
     6.794    18.155     0.200
     6.801    17.180     0.200
     6.952    17.711     0.200
     6.952    18.219     0.200
     6.983    17.127     0.200
     7.013    17.843     0.200
     7.030    17.221     0.200
     7.149    16.825     0.200
     7.090    18.513     0.200
     7.090    19.294     0.200
     7.113    19.105     0.200
     7.136    18.080     0.200
     7.143    18.063     0.200
     7.146    17.558     0.200
     7.269    18.777     0.200
     7.279    18.447     0.200
     7.334    18.146     0.200
     7.436    18.470     0.200
     7.558    19.410     0.200
     7.558    19.152     0.200
     7.642    19.628     0.200
     7.642    19.417     0.200
     7.675    19.541     0.200
     7.675    19.127     0.200
     7.740    19.292     0.200
     7.791    19.543     0.200
     7.885    20.120     0.200
     7.965    19.600     0.200
     8.022    19.164     0.200
     8.022    19.468     0.200
     8.175    21.377     0.200
     8.272    19.710     0.200
     8.347    19.876     0.200
     8.385    20.175     0.200
     8.539    20.393     0.200
     8.539    20.839     0.200
     8.577    20.211     0.200
     8.577    20.391     0.200
     8.596    20.422     0.200
     8.604    22.025     0.200
     8.634    21.025     0.200
     8.798    20.644     0.200
     8.816    21.102     0.200
     8.899    20.338     0.200
     8.899    20.854     0.200
     8.838    20.523     0.200
     8.876    21.066     0.200
     8.876    21.034     0.200
     8.876    20.925     0.200
     8.881    20.996     0.200
     8.888    21.189     0.200
     8.888    21.822     0.200
     8.905    22.521     0.200
     9.076    22.248     0.200
     9.092    22.457     0.200
     9.092    22.184     0.200
     9.471    21.766     0.200
     9.476    23.434     0.200
     9.476    23.855     0.200
     9.704    26.263     0.200
     9.704    23.763     0.200
     9.693    22.872     0.200
     9.807    23.463     0.200
     9.807    24.760     0.200
    10.294    24.007     0.200
    10.371    24.568     0.200
    10.461    23.456     0.200
    10.782    25.465     0.200
    10.782    24.934     0.200
    12.732    27.737     0.200
    12.995    32.987     0.200
    14.951    33.832     0.200
    14.951    34.332     0.200
    14.951    32.637     0.200
    16.483    32.143     0.200
     0.439     8.354     0.200
     0.664     7.478     0.200
     0.856     6.927     0.200
     0.823     7.180     0.200
     0.786     7.395     0.200
     0.891     7.736     0.200
     0.915     7.247     0.200
     0.923     7.477     0.200
     0.935     7.768     0.200
     0.893     7.912     0.200
     0.897     8.040     0.200
     0.900     8.034     0.200
     0.906     8.013     0.200
     0.911     7.901     0.200
     0.919     7.879     0.200
     1.016     7.424     0.200
     1.061     7.517     0.200
     1.153     7.564     0.200
     1.256     6.990     0.200
     1.200     8.131     0.200
     1.200     8.222     0.200
     1.515     8.151     0.200
     1.548     8.458     0.200
     1.600     8.132     0.200
     1.578     8.063     0.200
     1.642     8.288     0.200
     1.633     8.117     0.200
     1.687     8.669     0.200
     1.755     8.477     0.200
     1.823     8.665     0.200
     1.778     8.413     0.200
     1.891     8.010     0.200
     1.936     8.189     0.200
     1.997     8.619     0.200
     2.035     8.731     0.200
     2.042     9.203     0.200
     2.125     9.199     0.200
     2.176     9.123     0.200
     2.401     9.732     0.200
     2.519     9.793     0.200
     2.668     8.769     0.200
     2.659     9.254     0.200
     2.805    10.293     0.200
     2.826    10.044     0.200
     2.831     9.910     0.200
     2.895    10.430     0.200
     2.936    10.435     0.200
     3.161    10.822     0.200
     3.260    10.701     0.200
     3.320    11.213     0.200
     3.433    11.722     0.200
     3.570    10.853     0.200
     3.665    11.787     0.200
     3.812    12.091     0.200
     3.783    12.307     0.200
     3.857    11.508     0.200
     3.910    11.597     0.200
     4.042    11.848     0.200
     4.069    10.951     0.200
     4.086    12.024     0.200
     4.258    11.027     0.200
     4.246    12.396     0.200
     4.368    12.231     0.200
     4.489    12.365     0.200
     4.588    13.095     0.200
     4.617    13.613     0.200
     4.748    13.107     0.200
     4.886    13.578     0.200
     4.947    12.561     0.200
     4.952    13.828     0.200
     5.025    13.684     0.200
     5.102    14.099     0.200
     5.175    13.746     0.200
     5.174    14.437     0.200
     5.214    14.297     0.200
     5.264    14.427     0.200
     5.247    14.433     0.200
     5.479    14.739     0.200
     5.457    14.395     0.200
     5.537    14.990     0.200
     5.614    15.003     0.200
     5.729    15.192     0.200
     5.732    15.942     0.200
     5.761    15.315     0.200
     5.792    15.110     0.200
     5.805    15.454     0.200
     5.818    14.958     0.200
     5.786    16.260     0.200
     5.904    15.077     0.200
     6.008    16.231     0.200
     6.091    16.112     0.200
     6.181    16.185     0.200
     6.181    16.361     0.200
     6.176    16.053     0.200
     6.220    16.018     0.200
     6.218    16.502     0.200
     6.318    16.939     0.200
     6.543    17.076     0.200
     6.565    15.927     0.200
     6.627    17.684     0.200
     6.666    17.775     0.200
     6.748    17.792     0.200
     7.003    17.754     0.200
     7.163    18.669     0.200
     7.195    18.317     0.200
     7.354    18.917     0.200
     7.394    18.442     0.200
     7.373    18.274     0.200
     0.115    10.218     0.200
     0.207     9.413     0.200
     0.265     9.578     0.200
     0.297     8.993     0.200
     0.351     8.578     0.200
     0.318     8.777     0.200
     0.355     8.567     0.200
     0.370     8.461     0.200
     0.415     8.284     0.200
     0.606     7.445     0.200
     0.652     8.059     0.200
     0.795     7.348     0.200
     0.928     7.078     0.200
     1.044     7.108     0.200
     1.186     6.986     0.200
     1.268     7.402     0.200
     1.517     7.266     0.200
     1.551     8.754     0.200
     1.552     8.829     0.200
     1.552     8.549     0.200
     1.570     8.697     0.200
     1.846     8.285     0.200
     1.846     8.184     0.200
     1.858     9.109     0.200
     1.857     8.949     0.200
     1.857     9.108     0.200
     2.237     7.562     0.200
     2.204     8.980     0.200
     2.232     9.421     0.200
     2.366     9.176     0.200
     2.383    10.091     0.200
     2.383     9.908     0.200
     2.441     9.550     0.200
     2.647     9.959     0.200
     2.690     9.417     0.200
     2.696    10.400     0.200
     2.715     9.761     0.200
     2.715     9.517     0.200
     2.727     9.456     0.200
     2.746    10.435     0.200
     2.779     9.551     0.200
     2.811    10.435     0.200
     2.823    10.194     0.200
     3.106    10.325     0.200
     3.469    10.795     0.200
     3.476    11.595     0.200
     3.513    11.131     0.200
     3.541    11.850     0.200
     4.116    10.986     0.200
     4.125    10.815     0.200
     4.049    12.514     0.200
     4.053    12.467     0.200
     4.053    12.208     0.200
     4.176    12.834     0.200
     4.176    12.588     0.200
     4.322    13.402     0.200
     4.404    12.018     0.200
     4.719    13.207     0.200
     4.914    12.588     0.200
     4.914    12.481     0.200
     4.937    13.444     0.200
     4.934    14.413     0.200
     4.972    13.615     0.200
     5.108    12.720     0.200
     5.341    14.004     0.200
     5.372    15.079     0.200
     5.372    15.452     0.200
     5.402    13.894     0.200
     5.726    15.155     0.200
     5.726    14.957     0.200
     5.762    14.815     0.200
     5.800    14.978     0.200
     5.902    15.210     0.200
     5.994    16.132     0.200
     6.027    15.848     0.200
     6.018    16.726     0.200
     6.190    16.309     0.200
     6.190    16.453     0.200
     6.232    15.545     0.200
     6.324    16.308     0.200
     6.579    16.617     0.200
     6.631    16.622     0.200
     6.810    17.468     0.200
     6.939    17.910     0.200
     7.161    18.301     0.200
     7.168    18.021     0.200
     7.312    18.038     0.200
     7.394    18.709     0.200
     7.470    19.126     0.200
     7.513    18.470     0.200
     7.516    18.709     0.200
     7.594    19.152     0.200
     7.625    18.269     0.200
     8.188    20.164     0.200
     8.230    19.525     0.200
     8.230    19.924     0.200
     8.512    19.645     0.200
     8.731    20.477     0.200
     1.177     5.621     0.200
     1.576     6.764     0.200
     1.645     7.641     0.200
     1.653     7.685     0.200
     1.693     7.138     0.200
     1.708     7.591     0.200
     1.732     7.876     0.200
     1.791     7.881     0.200
     1.858     8.063     0.200
     2.077     8.166     0.200
     2.121     8.383     0.200
     2.140     9.328     0.200
     2.153     9.177     0.200
     2.269     7.402     0.200
     2.277     8.543     0.200
     2.343     8.860     0.200
     2.406     9.722     0.200
     2.406     9.605     0.200
     2.422     9.608     0.200
     2.625     8.930     0.200
     2.609     9.149     0.200
     2.697     9.733     0.200
     2.753     9.876     0.200
     2.805    10.618     0.200
     2.942    10.049     0.200
     3.059     9.687     0.200
     3.070    10.682     0.200
     3.147    10.708     0.200
     3.190    11.076     0.200
     3.216    11.173     0.200
     3.218    11.068     0.200
     3.243     9.347     0.200
     3.318    11.343     0.200
     3.320    11.064     0.200
     3.685    11.486     0.200
     3.831    11.946     0.200
     3.924    13.010     0.200
     3.998    13.140     0.200
     4.002    13.081     0.200
     4.043    12.931     0.200
     4.071    11.844     0.200
     4.096    13.060     0.200
     4.140    12.297     0.200
     4.178    11.615     0.200
     4.240    12.943     0.200
     4.286    12.258     0.200
     4.407    12.151     0.200
     4.676    11.782     0.200
     4.682    11.711     0.200
     4.661    11.860     0.200
     4.736    13.515     0.200
     4.846    13.072     0.200
     4.853    13.719     0.200
     4.985    13.692     0.200
     5.055    14.317     0.200
     5.175    13.876     0.200
     5.205    14.354     0.200
     5.263    14.699     0.200
     5.392    14.730     0.200
     5.490    14.534     0.200
     5.526    14.615     0.200
     5.797    16.112     0.200
     5.888    15.809     0.200
     5.908    15.809     0.200
     5.913    15.578     0.200
     6.087    15.619     0.200
     6.142    16.751     0.200
     6.210    15.902     0.200
     6.277    16.640     0.200
     6.367    16.808     0.200
     6.377    16.889     0.200
     6.431    16.954     0.200
     6.462    17.180     0.200
     6.553    17.050     0.200
     6.682    17.650     0.200
     6.962    18.138     0.200
     7.640    20.056     0.200
     7.728    18.449     0.200
     7.986    20.084     0.200
     7.986    18.897     0.200
     8.033    19.736     0.200
     0.569     5.440     0.200
     0.569     5.667     0.200
     0.730     5.156     0.200
     0.730     5.265     0.200
     0.750     5.393     0.200
     0.774     6.135     0.200
     0.777     5.896     0.200
     0.850     5.820     0.200
     0.853     5.744     0.200
     0.882     5.841     0.200
     0.892     6.038     0.200
     0.909     5.811     0.200
     0.951     6.160     0.200
     0.954     6.000     0.200
     1.001     6.283     0.200
     1.037     6.411     0.200
     1.052     6.173     0.200
     1.407     6.115     0.200
     1.434     7.867     0.200
     1.438     7.877     0.200
     1.441     7.907     0.200
     1.447     7.867     0.200
     1.452     7.621     0.200
     1.461     7.815     0.200
     1.442     7.266     0.200
     1.606     7.390     0.200
     1.741     8.360     0.200
     1.740     8.335     0.200
     1.742     7.778     0.200
     2.025     8.448     0.200
     2.054     8.690     0.200
     2.117     8.334     0.200
     2.101     8.265     0.200
     2.219     8.770     0.200
     2.219     8.942     0.200
     2.323     8.379     0.200
     2.348     8.744     0.200
     2.303     8.902     0.200
     2.383     7.406     0.200
     2.383     7.296     0.200
     2.535     9.457     0.200
     2.572     9.544     0.200
     2.579     9.939     0.200
     2.598     9.849     0.200
     2.629    10.392     0.200
     2.664     9.893     0.200
     2.713    10.139     0.200
     2.928    10.498     0.200
     2.997    10.286     0.200
     2.997    10.418     0.200
     3.064     8.873     0.200
     3.119     9.891     0.200
     3.114    11.412     0.200
     3.114    11.263     0.200
     3.248    10.674     0.200
     3.248     9.830     0.200
     3.359    11.031     0.200
     3.333    10.908     0.200
     3.429    11.726     0.200
     3.469    11.632     0.200
     3.481    11.203     0.200
     3.495    11.771     0.200
     3.693    12.163     0.200
     3.735    10.949     0.200
     3.735    11.191     0.200
     3.832    11.801     0.200
     3.989    11.339     0.200
     3.974    12.290     0.200
     3.974    12.571     0.200
     4.078    13.154     0.200
     4.083    13.240     0.200
     4.197    12.169     0.200
     4.197    11.950     0.200
     4.316    12.182     0.200
     4.312    13.273     0.200
     4.363    12.341     0.200
     4.363    11.684     0.200
     4.417    12.297     0.200
     4.455    11.817     0.200
     4.455    11.552     0.200
     4.522    12.413     0.200
     4.547    11.191     0.200
     4.555    12.306     0.200
     4.619    11.717     0.200
     4.588    13.346     0.200
     4.713    12.955     0.200
     4.713    12.448     0.200
     4.754    13.273     0.200
     4.817    13.866     0.200
     4.817    12.640     0.200
     5.034    13.722     0.200
     5.034    14.779     0.200
     5.034    14.647     0.200
     5.120    13.748     0.200
     5.168    13.808     0.200
     5.135    14.709     0.200
     5.217    14.391     0.200
     5.157    14.642     0.200
     5.277    14.425     0.200
     5.284    14.289     0.200
     5.284    13.813     0.200
     5.386    14.312     0.200
     5.457    14.669     0.200
     5.519    15.102     0.200
     5.451    15.374     0.200
     5.451    15.007     0.200
     5.513    14.778     0.200
     5.513    14.231     0.200
     5.505    14.584     0.200
     5.505    14.420     0.200
     5.519    14.744     0.200
     5.519    14.330     0.200
     5.608    15.419     0.200
     5.608    15.224     0.200
     5.665    15.285     0.200
     5.804    15.170     0.200
     5.776    16.128     0.200
     5.776    15.441     0.200
     5.795    15.693     0.200
     5.858    15.719     0.200
     5.858    15.016     0.200
     5.892    15.205     0.200
     5.971    15.397     0.200
     6.061    16.388     0.200
     6.008    16.739     0.200
     6.008    15.505     0.200
     6.075    15.999     0.200
     6.079    15.453     0.200
     6.080    14.992     0.200
     6.085    16.250     0.200
     6.129    16.589     0.200
     6.200    16.011     0.200
     6.254    17.232     0.200
     6.254    16.724     0.200
     6.275    16.447     0.200
     6.275    16.298     0.200
     6.370    16.601     0.200
     6.323    17.333     0.200
     6.323    16.255     0.200
     6.425    16.624     0.200
     6.425    16.843     0.200
     6.449    16.978     0.200
     6.478    17.089     0.200
     6.462    17.042     0.200
     6.462    16.206     0.200
     6.528    17.266     0.200
     6.538    17.407     0.200
     6.574    17.445     0.200
     6.578    16.723     0.200
     6.883    16.950     0.200
     6.936    16.856     0.200
     6.956    17.070     0.200
     7.064    17.568     0.200
     7.035    16.720     0.200
     7.083    16.778     0.200
     7.229    18.597     0.200
     7.230    18.361     0.200
     7.252    17.085     0.200
     7.252    17.726     0.200
     7.258    18.222     0.200
     7.258    17.347     0.200
     7.295    17.465     0.200
     7.319    18.107     0.200
     7.393    18.692     0.200
     7.510    18.231     0.200
     7.508    18.094     0.200
     7.522    17.751     0.200
     7.522    18.055     0.200
     7.584    18.590     0.200
     7.584    18.254     0.200
     7.658    19.131     0.200
     7.658    18.444     0.200
     7.761    19.792     0.200
     7.761    19.003     0.200
     7.779    19.147     0.200
     7.790    18.633     0.200
     7.790    19.117     0.200
     7.798    19.278     0.200
     8.085    19.993     0.200
     8.290    21.050     0.200
     8.317    22.110     0.200
     8.381    19.544     0.200
     8.716    22.425     0.200
     8.730    22.042     0.200
     8.976    24.187     0.200
     9.093    22.140     0.200
     9.956    25.305     0.200
     9.972    25.711     0.200
    10.383    23.545     0.200
    10.903    25.384     0.200
    13.088    29.114     0.200
    14.104    32.787     0.200
    14.543    31.152     0.200
    14.801    31.694     0.200
    16.909    33.761     0.200
     1.264     5.992     0.200
     1.354     7.579     0.200
     1.440     7.681     0.200
     1.528     7.956     0.200
     1.560     8.438     0.200
     1.566     8.144     0.200
     1.571     8.562     0.200
     1.580     8.934     0.200
     1.587     8.551     0.200
     1.599     9.143     0.200
     1.679     8.406     0.200
     1.707     7.989     0.200
     1.786     8.341     0.200
     1.769     9.109     0.200
     1.769     8.943     0.200
     1.841     8.383     0.200
     1.888     8.667     0.200
     1.913     8.928     0.200
     1.955     9.248     0.200
     2.085     7.502     0.200
     2.008     9.349     0.200
     2.053     9.625     0.200
     2.054     9.237     0.200
     2.294     8.602     0.200
     2.289     8.708     0.200
     2.399     9.567     0.200
     2.439     9.720     0.200
     2.514     9.473     0.200
     2.475     9.959     0.200
     2.573     9.492     0.200
     2.522    10.223     0.200
     2.558     9.958     0.200
     2.558    10.052     0.200
     2.570    10.148     0.200
     2.562    10.031     0.200
     2.684    11.276     0.200
     3.172     8.855     0.200
     3.097    10.674     0.200
     3.131    11.778     0.200
     3.143    10.849     0.200
     3.090    11.068     0.200
     3.229    10.717     0.200
     3.186    11.630     0.200
     3.206    11.869     0.200
     3.400    11.341     0.200
     3.487    11.425     0.200
     3.409    11.513     0.200
     3.611    10.960     0.200
     3.682    11.645     0.200
     3.620    11.600     0.200
     3.728    10.334     0.200
     3.716    11.490     0.200
     3.875    12.028     0.200
     3.905    11.458     0.200
     3.920    12.218     0.200
     3.890    12.232     0.200
     4.064    12.565     0.200
     4.061    12.966     0.200
     4.121    12.055     0.200
     4.231    12.305     0.200
     4.241    12.675     0.200
     4.315    13.593     0.200
     4.367    14.080     0.200
     4.449    13.143     0.200
     4.494    12.485     0.200
     4.402    13.861     0.200
     4.577    13.537     0.200
     4.661    13.737     0.200
     4.848    14.425     0.200
     4.971    14.967     0.200
     4.981    14.103     0.200
     5.068    14.895     0.200
     5.075    15.033     0.200
     5.168    15.162     0.200
     5.185    14.913     0.200
     5.209    15.138     0.200
     5.362    15.716     0.200
     5.340    16.816     0.200
     5.445    16.422     0.200
     5.407    15.935     0.200
     5.405    15.496     0.200
     5.409    15.366     0.200
     5.546    16.147     0.200
     5.489    15.855     0.200
     5.479    15.921     0.200
     5.678    16.367     0.200
     5.610    17.116     0.200
     5.744    16.623     0.200
     5.853    16.823     0.200
     5.857    16.515     0.200
     5.796    17.211     0.200
     6.053    15.861     0.200
     6.076    16.991     0.200
     6.026    15.841     0.200
     6.179    16.594     0.200
     6.216    17.234     0.200
     6.218    17.644     0.200
     6.452    17.310     0.200
     6.452    18.256     0.200
     6.543    18.302     0.200
     6.610    17.645     0.200
     6.625    17.177     0.200
     6.713    18.390     0.200
     6.814    17.590     0.200
     6.918    18.269     0.200
     6.953    18.420     0.200
     6.965    18.591     0.200
     7.025    18.741     0.200
     7.027    18.629     0.200
     7.061    17.948     0.200
     7.061    18.249     0.200
     7.066    18.677     0.200
     7.105    18.626     0.200
     7.150    18.591     0.200
     7.313    19.556     0.200
     7.523    20.211     0.200
     7.603    19.456     0.200
     7.811    20.064     0.200
     7.956    20.503     0.200
     7.974    19.034     0.200
     7.973    20.938     0.200
     8.349    21.836     0.200
     8.908    22.258     0.200
     8.990    23.496     0.200
     9.372    23.607     0.200
     9.889    24.365     0.200
     0.463     5.395     0.200
     0.632     4.858     0.200
     0.863     5.284     0.200
     0.892     5.794     0.200
     0.972     5.665     0.200
     1.008     6.243     0.200
     1.030     6.184     0.200
     1.067     6.296     0.200
     1.090     6.480     0.200
     1.156     6.354     0.200
     1.352     6.103     0.200
     1.513     8.040     0.200
     1.523     7.267     0.200
     1.518     8.039     0.200
     1.520     7.990     0.200
     1.528     7.546     0.200
     1.528     8.041     0.200
     1.546     7.661     0.200
     1.695     7.701     0.200
     1.815     8.483     0.200
     1.814     8.449     0.200
     1.810     7.442     0.200
     2.040     8.509     0.200
     2.044     9.036     0.200
     2.126     8.542     0.200
     2.188     8.840     0.200
     2.213     8.608     0.200
     2.281     9.654     0.200
     2.357     7.525     0.200
     2.338     8.521     0.200
     2.357     8.796     0.200
     2.399     9.104     0.200
     2.603     9.718     0.200
     2.647    10.170     0.200
     2.671     9.436     0.200
     2.667    10.043     0.200
     2.736    10.173     0.200
     2.781    10.277     0.200
     3.023    10.640     0.200
     3.065     9.176     0.200
     3.126     9.548     0.200
     3.141     9.884     0.200
     3.156    12.140     0.200
     3.262     9.473     0.200
     3.419    10.930     0.200
     3.423    11.137     0.200
     3.439    11.103     0.200
     3.449    11.393     0.200
     3.467    11.452     0.200
     3.531    11.579     0.200
     3.693    11.759     0.200
     3.753    11.822     0.200
     3.761    11.297     0.200
     3.878    12.130     0.200
     3.994    11.429     0.200
     4.031    10.728     0.200
     4.031    11.377     0.200
     4.036    10.772     0.200
     4.098    12.506     0.200
     4.257    11.975     0.200
     4.344    11.626     0.200
     4.380    11.842     0.200
     4.406    13.217     0.200
     4.449    11.309     0.200
     4.549    12.630     0.200
     4.605    11.576     0.200
     4.624    12.128     0.200
     4.653    13.826     0.200
     4.735    12.732     0.200
     4.793    12.702     0.200
     4.839    12.747     0.200
     5.048    14.036     0.200
     5.109    13.923     0.200
     5.248    14.184     0.200
     5.235    15.027     0.200
     5.280    14.220     0.200
     5.350    14.706     0.200
     5.492    14.096     0.200
     5.533    14.594     0.200
     5.538    14.727     0.200
     5.616    15.209     0.200
     5.628    15.009     0.200
     5.631    14.955     0.200
     5.832    15.569     0.200
     5.832    15.166     0.200
     5.848    15.418     0.200
     5.857    15.427     0.200
     5.955    16.461     0.200
     6.028    15.800     0.200
     6.016    15.326     0.200
     6.040    15.669     0.200
     6.047    15.575     0.200
     6.042    15.766     0.200
     6.068    15.325     0.200
     6.082    15.737     0.200
     6.106    15.653     0.200
     6.167    15.718     0.200
     6.167    16.725     0.200
     6.302    15.323     0.200
     6.302    16.465     0.200
     6.364    16.917     0.200
     6.361    16.415     0.200
     6.387    16.580     0.200
     6.446    16.739     0.200
     6.478    16.186     0.200
     6.498    16.551     0.200
     6.510    16.997     0.200
     6.530    16.782     0.200
     6.648    17.564     0.200
     6.633    16.637     0.200
     6.702    17.801     0.200
     6.813    17.900     0.200
     6.839    17.669     0.200
     6.924    17.900     0.200
     7.014    18.507     0.200
     7.026    18.512     0.200
     7.089    16.486     0.200
     7.130    17.449     0.200
     7.178    18.232     0.200
     7.178    18.232     0.200
     7.251    18.684     0.200
     7.292    17.883     0.200
     7.333    19.032     0.200
     7.324    18.070     0.200
     7.324    17.570     0.200
     7.341    17.370     0.200
     7.392    18.551     0.200
     7.409    18.944     0.200
     7.455    18.315     0.200
     7.436    17.729     0.200
     7.474    20.054     0.200
     7.529    18.102     0.200
     7.540    17.854     0.200
     7.542    17.829     0.200
     7.559    17.658     0.200
     7.581    18.028     0.200
     7.634    19.850     0.200
     7.626    17.857     0.200
     7.626    18.068     0.200
     7.677    18.475     0.200
     7.758    19.634     0.200
     7.776    19.638     0.200
     7.776    19.256     0.200
     7.819    18.531     0.200
     7.837    19.822     0.200
     7.845    18.714     0.200
     8.168    20.088     0.200
     8.168    19.569     0.200
     8.215    19.160     0.200
     8.215    19.785     0.200
     8.300    21.276     0.200
     8.368    19.984     0.200
     8.435    19.886     0.200
     8.469    20.068     0.200
     8.560    22.488     0.200
     8.850    23.333     0.200
     9.106    22.028     0.200
     9.234    22.805     0.200
     9.795    21.256     0.200
    10.430    23.486     0.200
    12.370    31.194     0.200
    14.611    32.444     0.200
     0.579     5.250     0.200
     0.788     6.032     0.200
     0.788     5.563     0.200
     0.859     5.539     0.200
     0.921     6.062     0.200
     1.086     5.759     0.200
     1.308     7.398     0.200
     1.760     8.528     0.200
     1.867     7.515     0.200
     1.867     7.413     0.200
     2.023     7.423     0.200
     2.023     6.978     0.200
     2.061     9.006     0.200
     2.061     9.107     0.200
     2.061     8.802     0.200
     2.308     8.598     0.200
     2.377     8.956     0.200
     2.390     9.544     0.200
     2.461     8.723     0.200
     2.555     9.870     0.200
     2.568     9.443     0.200
     2.688     9.155     0.200
     2.751     9.218     0.200
     2.751     8.992     0.200
     2.713     9.412     0.200
     2.906    11.256     0.200
     3.154    10.650     0.200
     3.192    11.259     0.200
     3.192    11.079     0.200
     3.428    10.203     0.200
     3.428     9.875     0.200
     3.483    10.510     0.200
     3.558    11.258     0.200
     3.613    11.646     0.200
     3.613    11.459     0.200
     3.693    11.644     0.200
     4.028    12.503     0.200
     4.097    11.593     0.200
     4.184    13.013     0.200
     4.184    12.560     0.200
     4.248    13.485     0.200
     4.248    12.274     0.200
     4.282    13.010     0.200
     4.354    12.103     0.200
     4.406    11.345     0.200
     4.533    12.828     0.200
     4.576    13.705     0.200
     4.679    12.894     0.200
     4.728    12.489     0.200
     4.771    13.102     0.200
     4.817    12.209     0.200
     4.855    14.150     0.200
     4.977    12.478     0.200
     5.169    13.576     0.200
     5.353    15.075     0.200
     5.376    15.242     0.200
     5.399    14.413     0.200
     5.500    14.578     0.200
     5.647    15.012     0.200
     5.737    15.758     0.200
     5.867    15.346     0.200
     5.867    15.025     0.200
     5.973    15.914     0.200
     6.114    15.739     0.200
     6.126    15.663     0.200
     6.218    16.018     0.200
     6.320    15.894     0.200
     6.322    15.935     0.200
     6.372    16.194     0.200
     6.405    16.196     0.200
     6.424    15.975     0.200
     6.441    16.352     0.200
     6.482    16.922     0.200
     6.526    17.890     0.200
     6.560    17.047     0.200
     6.602    16.359     0.200
     6.650    16.321     0.200
     6.823    17.397     0.200
     6.827    17.454     0.200
     6.875    17.388     0.200
     6.887    18.084     0.200
     6.906    17.350     0.200
     7.024    17.842     0.200
     7.189    18.085     0.200
     7.214    18.444     0.200
     7.262    18.984     0.200
     7.297    18.542     0.200
     7.301    18.504     0.200
     7.376    16.692     0.200
     7.402    18.206     0.200
     7.431    17.259     0.200
     7.582    18.271     0.200
     7.630    18.561     0.200
     7.644    17.776     0.200
     7.705    19.465     0.200
     7.751    18.140     0.200
     7.841    18.114     0.200
     7.850    20.323     0.200
     7.857    18.382     0.200
     7.896    18.402     0.200
     7.937    18.402     0.200
     7.937    18.230     0.200
     8.010    20.487     0.200
     8.022    18.784     0.200
     8.067    19.637     0.200
     8.146    19.549     0.200
     8.149    20.885     0.200
     8.375    20.713     0.200
     8.375    20.713     0.200
     8.668    21.675     0.200
     8.674    21.600     0.200
     8.722    20.045     0.200
     8.843    22.101     0.200
     8.874    21.171     0.200
     9.018    20.130     0.200
     9.458    24.363     0.200
    10.123    21.846     0.200
    12.723    30.677     0.200
    14.090    32.074     0.200
    14.255    31.135     0.200
     0.564     4.836     0.200
     0.631     5.163     0.200
     0.734     5.269     0.200
     0.730     5.209     0.200
     0.747     5.491     0.200
     0.753     5.597     0.200
     0.753     5.499     0.200
     0.776     5.671     0.200
     0.927     5.993     0.200
     0.959     5.816     0.200
     1.059     6.172     0.200
     1.119     5.812     0.200
     1.213     6.271     0.200
     1.316     6.655     0.200
     1.386     6.607     0.200
     1.785     6.911     0.200
     1.980     7.076     0.200
     2.072     8.721     0.200
     2.148     8.191     0.200
     2.233     8.249     0.200
     2.389     9.169     0.200
     2.446     9.724     0.200
     2.453     9.186     0.200
     2.476     9.036     0.200
     2.531     9.150     0.200
     2.610     9.444     0.200
     2.579     9.436     0.200
     2.772     8.877     0.200
     2.875    10.389     0.200
     2.919    11.245     0.200
     2.932    10.676     0.200
     3.008     9.999     0.200
     3.152    10.683     0.200
     3.493    11.321     0.200
     3.515    12.534     0.200
     3.527    10.339     0.200
     3.683    12.084     0.200
     3.696    11.519     0.200
     3.712    12.084     0.200
     4.084    12.383     0.200
     4.048    13.020     0.200
     4.112    11.243     0.200
     4.163    12.152     0.200
     4.224    12.868     0.200
     4.246    13.040     0.200
     4.446    12.124     0.200
     4.531    13.896     0.200
     4.552    13.130     0.200
     4.743    13.699     0.200
     4.805    12.640     0.200
     4.829    14.157     0.200
     4.892    12.563     0.200
     4.947    13.599     0.200
     5.292    13.941     0.200
     5.480    14.490     0.200
     5.642    15.178     0.200
     5.706    16.444     0.200
     5.988    15.434     0.200
     6.140    15.431     0.200
     6.135    15.304     0.200
     6.326    16.428     0.200
     6.360    15.679     0.200
     6.528    17.341     0.200
     6.537    16.923     0.200
     6.554    16.224     0.200
     6.557    17.383     0.200
     6.603    17.206     0.200
     6.676    16.937     0.200
     6.860    18.068     0.200
     6.904    18.583     0.200
     7.048    17.740     0.200
     7.161    17.515     0.200
     7.321    18.522     0.200
     7.357    18.906     0.200
     7.435    19.073     0.200
     7.465    20.013     0.200
     7.465    17.400     0.200
     7.539    19.047     0.200
     7.585    18.165     0.200
     7.651    19.365     0.200
     7.664    20.716     0.200
     7.678    18.845     0.200
     7.699    18.737     0.200
     7.815    19.976     0.200
     7.847    20.713     0.200
     7.835    21.490     0.200
     7.880    18.283     0.200
     7.978    19.000     0.200
     7.978    19.379     0.200
     8.048    20.045     0.200
     8.241    21.251     0.200
     8.347    21.374     0.200
     8.492    19.678     0.200
     8.718    21.877     0.200
     8.745    22.633     0.200
     0.413     4.265     0.200
     0.413     4.136     0.200
     1.090     5.319     0.200
     1.090     5.102     0.200
     1.175     6.290     0.200
     1.300     6.802     0.200
     1.502     7.239     0.200
     1.445     7.352     0.200
     1.446     7.505     0.200
     1.454     7.603     0.200
     1.475     8.105     0.200
     1.473     7.561     0.200
     1.586     7.747     0.200
     1.595     7.306     0.200
     1.676     7.882     0.200
     1.675     7.861     0.200
     1.786     7.123     0.200
     1.774     7.524     0.200
     1.708     7.779     0.200
     1.916     6.549     0.200
     1.916     6.723     0.200
     1.939     8.182     0.200
     1.990     7.940     0.200
     2.015     8.675     0.200
     2.098     7.811     0.200
     2.275     9.293     0.200
     2.360     8.849     0.200
     2.429     7.853     0.200
     2.402     9.334     0.200
     2.405     8.728     0.200
     2.434     8.924     0.200
     2.398     8.566     0.200
     2.434     9.159     0.200
     2.602     8.618     0.200
     2.682     8.745     0.200
     2.682     8.497     0.200
     2.725    10.288     0.200
     2.993     9.987     0.200
     3.099    10.593     0.200
     3.119    10.741     0.200
     3.119     9.907     0.200
     3.143    10.792     0.200
     3.203    10.679     0.200
     3.180    10.629     0.200
     3.270     9.969     0.200
     3.274     9.856     0.200
     3.232    10.014     0.200
     3.209    10.843     0.200
     3.367    10.222     0.200
     3.419    11.316     0.200
     3.448    10.707     0.200
     3.448    10.486     0.200
     3.501    10.729     0.200
     3.678    10.962     0.200
     3.776    10.516     0.200
     3.776    10.342     0.200
     3.800    10.822     0.200
     3.801    11.713     0.200
     3.811    10.746     0.200
     3.811    10.547     0.200
     3.908    10.262     0.200
     3.910    11.858     0.200
     4.017    11.830     0.200
     4.071    11.495     0.200
     3.996    11.942     0.200
     4.072    11.686     0.200
     4.175    11.988     0.200
     4.366    12.408     0.200
     4.331    12.706     0.200
     4.418    12.389     0.200
     4.442    12.291     0.200
     4.418    13.270     0.200
     4.445    12.826     0.200
     4.514    13.027     0.200
     4.491    13.835     0.200
     4.491    13.663     0.200
     4.614    12.925     0.200
     4.693    12.985     0.200
     4.772    13.013     0.200
     4.772    12.832     0.200
     4.878    13.410     0.200
     4.874    13.633     0.200
     4.820    14.171     0.200
     5.008    14.010     0.200
     4.991    14.566     0.200
     4.991    14.139     0.200
     5.104    13.907     0.200
     5.158    14.466     0.200
     5.158    13.966     0.200
     5.196    14.297     0.200
     5.186    14.337     0.200
     5.287    14.403     0.200
     5.286    15.019     0.200
     5.207    14.193     0.200
     5.304    13.573     0.200
     5.228    14.229     0.200
     5.228    13.948     0.200
     5.358    14.277     0.200
     5.383    14.213     0.200
     5.422    14.351     0.200
     5.372    14.748     0.200
     5.447    14.816     0.200
     5.530    15.078     0.200
     5.530    14.745     0.200
     5.508    15.218     0.200
     5.580    14.985     0.200
     5.560    14.923     0.200
     5.617    15.242     0.200
     5.617    14.650     0.200
     5.642    14.908     0.200
     5.642    14.466     0.200
     5.653    14.982     0.200
     5.703    15.294     0.200
     5.758    15.504     0.200
     5.771    15.466     0.200
     5.777    15.172     0.200
     5.811    14.828     0.200
     5.811    15.502     0.200
     5.896    15.907     0.200
     5.878    16.131     0.200
     5.878    15.072     0.200
     5.862    16.521     0.200
     5.862    15.281     0.200
     5.940    16.170     0.200
     5.986    16.325     0.200
     6.069    16.497     0.200
     6.079    16.378     0.200
     6.051    16.085     0.200
     6.051    15.747     0.200
     6.165    16.845     0.200
     6.173    16.406     0.200
     6.176    16.859     0.200
     6.250    17.068     0.200
     6.250    16.787     0.200
     6.187    16.907     0.200
     6.187    15.853     0.200
     6.273    16.820     0.200
     6.412    16.854     0.200
     6.412    16.475     0.200
     6.636    17.359     0.200
     6.636    17.644     0.200
     6.688    17.065     0.200
     6.681    16.748     0.200
     6.760    17.163     0.200
     6.760    17.037     0.200
     6.747    17.777     0.200
     6.801    17.139     0.200
     6.903    18.516     0.200
     6.903    18.807     0.200
     6.887    17.328     0.200
     6.992    17.930     0.200
     7.105    18.565     0.200
     7.095    17.772     0.200
     7.097    17.544     0.200
     7.061    18.283     0.200
     7.130    17.654     0.200
     7.113    17.507     0.200
     7.146    17.494     0.200
     7.146    17.725     0.200
     7.197    17.758     0.200
     7.289    18.147     0.200
     7.289    18.339     0.200
     7.386    18.084     0.200
     7.386    18.234     0.200
     7.528    20.608     0.200
     7.537    19.797     0.200
     7.617    18.816     0.200
     7.600    19.043     0.200
     7.823    20.337     0.200
     7.851    19.675     0.200
     7.851    19.021     0.200
     7.958    19.690     0.200
     8.066    19.847     0.200
     8.066    20.308     0.200
     8.570    20.820     0.200
     9.141    21.610     0.200
     9.141    22.298     0.200
     9.135    20.217     0.200
     9.956    22.194     0.200
    11.607    27.692     0.200
     0.946     6.643     0.200
     0.910     6.688     0.200
     1.185     6.972     0.200
     1.209     7.017     0.200
     1.216     7.121     0.200
     1.355     7.298     0.200
     1.353     7.771     0.200
     1.356     7.819     0.200
     1.361     7.825     0.200
     1.376     7.741     0.200
     1.377     7.715     0.200
     1.500     7.249     0.200
     1.473     7.351     0.200
     1.462     7.031     0.200
     1.489     7.525     0.200
     1.667     8.304     0.200
     1.666     8.276     0.200
     1.892     7.998     0.200
     1.983     8.763     0.200
     1.998     8.681     0.200
     2.048     8.800     0.200
     2.057     9.135     0.200
     2.102     8.746     0.200
     2.117     9.122     0.200
     2.173     9.587     0.200
     2.387     8.497     0.200
     2.396     8.719     0.200
     2.420     9.087     0.200
     2.435     8.890     0.200
     2.469     9.792     0.200
     2.507     9.926     0.200
     2.513     9.706     0.200
     2.526     9.963     0.200
     2.581     9.700     0.200
     2.586    10.161     0.200
     2.648    10.407     0.200
     2.929    10.010     0.200
     3.113    12.263     0.200
     3.142    10.600     0.200
     3.164     9.443     0.200
     3.168    10.122     0.200
     3.311    11.477     0.200
     3.332    11.396     0.200
     3.301    11.466     0.200
     3.306    11.063     0.200
     3.316    10.377     0.200
     3.334    11.838     0.200
     3.416    11.622     0.200
     3.642    12.148     0.200
     3.676    12.303     0.200
     3.770    11.649     0.200
     3.864    12.203     0.200
     4.074    11.590     0.200
     4.157    12.987     0.200
     4.219    12.519     0.200
     4.273    12.096     0.200
     4.278    12.101     0.200
     4.348    12.407     0.200
     4.434    12.344     0.200
     4.419    12.284     0.200
     4.440    13.678     0.200
     4.560    12.769     0.200
     4.551    12.693     0.200
     4.564    11.783     0.200
     4.745    11.884     0.200
     4.755    13.351     0.200
     4.765    13.920     0.200
     4.863    13.036     0.200
     4.962    13.020     0.200
     4.950    14.914     0.200
     4.958    14.281     0.200
     4.981    14.341     0.200
     5.097    14.070     0.200
     5.239    13.845     0.200
     5.320    15.293     0.200
     5.353    14.767     0.200
     5.381    14.539     0.200
     5.385    14.568     0.200
     5.432    14.531     0.200
     5.455    14.978     0.200
     5.523    14.930     0.200
     5.533    14.818     0.200
     5.555    14.903     0.200
     5.653    14.387     0.200
     5.661    15.153     0.200
     5.682    14.850     0.200
     5.681    15.479     0.200
     5.703    15.523     0.200
     5.729    15.818     0.200
     5.733    15.635     0.200
     5.836    15.126     0.200
     5.913    16.673     0.200
     5.913    16.002     0.200
     5.955    15.686     0.200
     5.973    15.527     0.200
     5.982    15.922     0.200
     6.032    16.023     0.200
     6.065    15.774     0.200
     6.143    16.839     0.200
     6.184    16.363     0.200
     6.215    15.791     0.200
     6.223    16.039     0.200
     6.239    15.967     0.200
     6.242    15.813     0.200
     6.229    16.577     0.200
     6.254    16.085     0.200
     6.252    16.678     0.200
     6.270    15.871     0.200
     6.364    16.201     0.200
     6.525    16.704     0.200
     6.517    17.079     0.200
     6.543    16.780     0.200
     6.536    17.494     0.200
     6.615    17.167     0.200
     6.627    17.314     0.200
     6.639    17.234     0.200
     6.686    16.741     0.200
     6.689    16.803     0.200
     6.758    17.628     0.200
     6.857    17.705     0.200
     6.844    18.321     0.200
     6.936    18.278     0.200
     6.997    18.067     0.200
     7.006    17.915     0.200
     6.992    16.729     0.200
     7.041    18.032     0.200
     7.067    18.241     0.200
     7.122    18.345     0.200
     7.125    18.303     0.200
     7.175    18.730     0.200
     7.182    18.161     0.200
     7.236    18.257     0.200
     7.222    18.389     0.200
     7.247    17.407     0.200
     7.272    17.823     0.200
     7.276    17.703     0.200
     7.272    16.891     0.200
     7.427    18.548     0.200
     7.427    18.548     0.200
     7.447    19.381     0.200
     7.464    17.541     0.200
     7.466    17.366     0.200
     7.467    18.053     0.200
     7.473    18.111     0.200
     7.573    17.759     0.200
     7.573    17.810     0.200
     7.655    19.263     0.200
     7.713    18.893     0.200
     7.705    19.026     0.200
     7.705    18.631     0.200
     7.764    18.222     0.200
     7.799    19.139     0.200
     7.805    19.803     0.200
     7.800    18.900     0.200
     7.856    19.260     0.200
     7.875    19.518     0.200
     7.875    19.627     0.200
     7.948    20.919     0.200
     7.960    20.333     0.200
     7.960    19.946     0.200
     8.129    19.511     0.200
     8.339    20.363     0.200
     8.482    21.585     0.200
     8.473    22.118     0.200
     8.540    20.999     0.200
     8.796    21.921     0.200
     8.901    22.765     0.200
     9.149    22.135     0.200
     9.323    22.840     0.200
     9.323    22.520     0.200
     9.857    23.811     0.200
    10.143    25.280     0.200
    10.150    23.442     0.200
    10.150    24.329     0.200
    10.342    23.000     0.200
    10.356    22.821     0.200
    10.816    24.402     0.200
    11.794    26.561     0.200
    12.675    29.626     0.200
    13.421    28.927     0.200
    13.765    30.775     0.200
     0.746    12.852     0.200
     0.834    12.576     0.200
     1.250    10.213     0.200
     1.256     9.844     0.200
     1.256    10.017     0.200
     1.509     9.417     0.200
     1.598     9.615     0.200
     1.620    10.770     0.200
     1.626    10.607     0.200
     1.628    10.783     0.200
     1.641    10.570     0.200
     1.659    10.520     0.200
     1.746     9.201     0.200
     1.718    10.030     0.200
     1.854     9.697     0.200
     1.914    10.688     0.200
     1.915    10.747     0.200
     1.882    10.898     0.200
     1.935    10.688     0.200
     2.018    10.057     0.200
     2.142    10.435     0.200
     2.208    10.771     0.200
     2.208    10.667     0.200
     2.272    10.869     0.200
     2.333     9.212     0.200
     2.333     9.343     0.200
     2.442    11.060     0.200
     2.436    10.117     0.200
     2.511    11.257     0.200
     2.511    11.553     0.200
     2.613    10.874     0.200
     2.674    11.372     0.200
     2.716    11.309     0.200
     2.715    11.315     0.200
     2.724    11.396     0.200
     2.756    11.355     0.200
     2.776    11.434     0.200
     2.815    11.007     0.200
     2.844    11.793     0.200
     2.889    10.635     0.200
     2.952    11.219     0.200
     2.959    11.369     0.200
     3.440    13.478     0.200
     3.473    13.165     0.200
     3.500    13.463     0.200
     3.515    12.957     0.200
     3.595    12.390     0.200
     3.774    12.684     0.200
     3.809    13.179     0.200
     3.920    12.508     0.200
     4.032    13.260     0.200
     4.060    13.771     0.200
     4.060    13.576     0.200
     4.156    13.118     0.200
     4.419    14.727     0.200
     4.552    13.043     0.200
     4.715    14.282     0.200
     4.782    14.678     0.200
     4.836    13.664     0.200
     4.836    13.512     0.200
     4.805    14.706     0.200
     4.932    14.041     0.200
     4.912    13.762     0.200
     4.937    13.911     0.200
     5.038    16.261     0.200
     5.038    16.416     0.200
     5.083    14.126     0.200
     5.083    13.980     0.200
     5.141    13.658     0.200
     5.291    14.053     0.200
     5.274    15.666     0.200
     5.521    14.865     0.200
     5.541    15.156     0.200
     5.547    16.921     0.200
     5.734    14.829     0.200
     5.700    16.123     0.200
     5.769    15.752     0.200
     5.817    14.960     0.200
     5.882    16.029     0.200
     5.866    16.218     0.200
     5.880    14.861     0.200
     5.855    16.654     0.200
     5.900    16.221     0.200
     5.988    16.443     0.200
     5.995    15.977     0.200
     5.959    17.561     0.200
     6.025    16.409     0.200
     6.085    16.925     0.200
     6.120    16.808     0.200
     6.171    16.741     0.200
     6.219    16.550     0.200
     6.197    15.853     0.200
     6.286    16.978     0.200
     6.340    17.258     0.200
     6.357    15.905     0.200
     6.359    16.948     0.200
     6.359    16.833     0.200
     6.454    17.100     0.200
     6.449    16.810     0.200
     6.491    17.213     0.200
     6.611    17.453     0.200
     6.684    17.484     0.200
     6.684    17.727     0.200
     6.654    18.373     0.200
     6.710    17.297     0.200
     6.759    17.588     0.200
     6.823    18.730     0.200
     6.823    17.847     0.200
     6.835    17.703     0.200
     6.843    17.604     0.200
     6.877    18.080     0.200
     6.913    18.393     0.200
     6.913    17.311     0.200
     6.968    18.325     0.200
     7.004    17.487     0.200
     7.086    18.415     0.200
     7.086    18.034     0.200
     7.114    18.704     0.200
     7.071    18.837     0.200
     7.160    18.492     0.200
     7.101    18.654     0.200
     7.163    17.253     0.200
     7.163    17.063     0.200
     7.237    18.071     0.200
     7.253    18.634     0.200
     7.259    18.791     0.200
     7.259    18.684     0.200
     7.269    18.734     0.200
     7.277    18.466     0.200
     7.252    18.980     0.200
     7.274    16.823     0.200
     7.269    18.393     0.200
     7.269    18.641     0.200
     7.393    19.320     0.200
     7.489    17.277     0.200
     7.506    17.521     0.200
     7.534    19.708     0.200
     7.534    19.604     0.200
     7.576    20.045     0.200
     7.603    18.976     0.200
     7.604    18.717     0.200
     7.581    18.568     0.200
     7.635    19.110     0.200
     7.608    18.627     0.200
     7.647    17.690     0.200
     7.642    19.862     0.200
     7.660    17.966     0.200
     7.702    19.919     0.200
     7.656    19.104     0.200
     7.727    19.812     0.200
     7.730    19.640     0.200
     7.815    17.870     0.200
     7.815    17.680     0.200
     7.851    19.584     0.200
     7.907    20.033     0.200
     7.977    19.967     0.200
     7.972    18.439     0.200
     8.082    20.278     0.200
     8.082    20.338     0.200
     8.076    19.006     0.200
     8.204    21.289     0.200
     8.192    20.336     0.200
     8.329    20.420     0.200
     8.348    20.052     0.200
     8.348    20.933     0.200
     8.377    20.284     0.200
     8.372    20.969     0.200
     8.474    20.435     0.200
     8.501    19.217     0.200
     8.548    20.313     0.200
     8.564    19.924     0.200
     9.184    21.937     0.200
     9.534    23.193     0.200
     9.777    23.266     0.200
    10.542    23.349     0.200
    10.549    22.126     0.200
    10.796    25.165     0.200
    10.849    27.048     0.200
    14.102    28.261     0.200
     0.279     4.505     0.200
     1.212     4.545     0.200
     1.212     4.741     0.200
     1.336     6.409     0.200
     1.348     6.453     0.200
     1.351     6.415     0.200
     1.376     6.782     0.200
     1.376     6.938     0.200
     1.420     6.726     0.200
     1.511     7.022     0.200
     1.528     7.155     0.200
     1.561     6.670     0.200
     1.593     7.412     0.200
     1.797     8.219     0.200
     1.868     8.125     0.200
     2.144     7.687     0.200
     2.155     9.030     0.200
     2.598    10.334     0.200
     2.601    10.319     0.200
     2.607    10.469     0.200
     2.619     9.970     0.200
     2.623     8.730     0.200
     2.623     8.839     0.200
     2.622    10.460     0.200
     2.700     8.782     0.200
     2.716     8.745     0.200
     2.911     9.341     0.200
     2.910    10.826     0.200
     2.909    10.380     0.200
     3.078    10.053     0.200
     3.188    10.918     0.200
     3.197    11.221     0.200
     3.197    11.010     0.200
     3.226    11.002     0.200
     3.243    10.991     0.200
     3.290    10.944     0.200
     3.390    11.045     0.200
     3.390    11.185     0.200
     3.403    11.756     0.200
     3.403    11.569     0.200
     3.485    10.689     0.200
     3.498    10.955     0.200
     3.498    11.159     0.200
     3.548     9.167     0.200
     3.554     9.072     0.200
     3.718     9.970     0.200
     3.718    10.157     0.200
     3.711    11.988     0.200
     3.755    12.291     0.200
     3.770    12.072     0.200
     3.833    12.358     0.200
     3.875    12.701     0.200
     3.889    12.283     0.200
     4.010    12.790     0.200
     4.193    11.463     0.200
     4.292    12.125     0.200
     4.305    14.060     0.200
     4.305    13.482     0.200
     4.408    12.555     0.200
     4.408    12.305     0.200
     4.429    12.128     0.200
     4.439    12.601     0.200
     4.540    13.631     0.200
     4.541    13.424     0.200
     4.566    13.886     0.200
     4.652    14.000     0.200
     4.757    12.872     0.200
     4.845    14.722     0.200
     4.877    14.050     0.200
     4.914    13.734     0.200
     4.914    13.586     0.200
     4.999    13.108     0.200
     4.999    13.968     0.200
     5.104    14.733     0.200
     5.128    13.699     0.200
     5.388    15.579     0.200
     5.388    15.329     0.200
     5.412    15.666     0.200
     5.412    14.955     0.200
     5.457    15.112     0.200
     5.457    14.721     0.200
     5.497    14.441     0.200
     5.497    13.956     0.200
     5.528    14.314     0.200
     5.559    14.105     0.200
     5.559    13.613     0.200
     5.687    16.017     0.200
     5.687    15.704     0.200
     5.695    14.141     0.200
     5.702    14.791     0.200
     5.854    14.818     0.200
     5.854    14.678     0.200
     5.856    15.126     0.200
     5.886    15.328     0.200
     5.886    14.946     0.200
     5.957    16.138     0.200
     5.981    15.559     0.200
     5.981    16.019     0.200
     6.100    14.959     0.200
     6.100    15.474     0.200
     6.166    16.840     0.200
     6.189    16.465     0.200
     6.189    16.629     0.200
     6.191    16.046     0.200
     6.191    16.296     0.200
     6.200    17.094     0.200
     6.200    17.242     0.200
     6.205    16.121     0.200
     6.208    15.837     0.200
     6.288    16.161     0.200
     6.360    16.237     0.200
     6.395    16.760     0.200
     6.395    16.369     0.200
     6.441    16.346     0.200
     6.452    16.335     0.200
     6.556    16.074     0.200
     6.556    16.340     0.200
     6.631    16.653     0.200
     6.647    17.044     0.200
     6.661    17.427     0.200
     6.685    17.023     0.200
     6.685    16.836     0.200
     6.708    16.977     0.200
     6.708    16.626     0.200
     6.724    17.354     0.200
     6.724    18.268     0.200
     6.750    16.958     0.200
     6.752    17.786     0.200
     6.854    17.032     0.200
     6.924    17.494     0.200
     6.945    17.785     0.200
     6.959    18.401     0.200
     6.962    17.782     0.200
     6.962    17.970     0.200
     6.975    17.291     0.200
     7.033    17.514     0.200
     7.050    17.671     0.200
     7.068    17.745     0.200
     7.144    17.926     0.200
     7.163    17.906     0.200
     7.164    18.264     0.200
     7.164    18.045     0.200
     7.164    17.968     0.200
     7.183    17.959     0.200
     7.195    18.054     0.200
     7.195    17.640     0.200
     7.299    18.982     0.200
     7.299    19.130     0.200
     7.328    17.961     0.200
     7.333    18.183     0.200
     7.333    18.285     0.200
     7.387    18.755     0.200
     7.391    18.562     0.200
     7.424    18.501     0.200
     7.424    18.782     0.200
     7.445    18.799     0.200
     7.466    18.656     0.200
     7.498    19.038     0.200
     7.498    18.898     0.200
     7.497    18.705     0.200
     7.525    17.446     0.200
     7.525    17.720     0.200
     7.526    18.583     0.200
     7.550    18.872     0.200
     7.603    17.769     0.200
     7.622    18.938     0.200
     7.622    18.625     0.200
     7.640    18.203     0.200
     7.657    19.009     0.200
     7.682    18.972     0.200
     7.773    18.431     0.200
     7.766    19.109     0.200
     7.803    19.336     0.200
     7.831    19.451     0.200
     7.863    19.414     0.200
     7.928    19.384     0.200
     7.931    19.488     0.200
     8.017    19.218     0.200
     8.036    20.076     0.200
     8.036    19.904     0.200
     8.050    19.735     0.200
     8.050    20.407     0.200
     8.101    19.756     0.200
     8.101    20.053     0.200
     8.223    18.681     0.200
     8.274    19.235     0.200
     8.327    21.905     0.200
     8.327    22.108     0.200
     8.359    19.451     0.200
     8.400    21.075     0.200
     8.400    20.903     0.200
     8.404    19.786     0.200
     8.404    20.107     0.200
     8.424    21.509     0.200
     8.424    21.033     0.200
     8.430    19.862     0.200
     8.443    20.271     0.200
     8.473    20.470     0.200
     8.473    20.337     0.200
     8.486    19.749     0.200
     8.525    21.300     0.200
     8.553    20.862     0.200
     8.587    20.674     0.200
     8.670    22.159     0.200
     8.678    21.525     0.200
     8.678    21.666     0.200
     8.683    20.433     0.200
     8.683    20.034     0.200
     8.685    19.040     0.200
     8.685    19.407     0.200
     8.685    19.556     0.200
     8.698    19.792     0.200
     8.706    19.989     0.200
     8.706    19.849     0.200
     8.775    20.314     0.200
     8.775    19.744     0.200
     8.775    19.588     0.200
     8.824    21.127     0.200
     8.846    22.613     0.200
     8.872    22.140     0.200
     8.872    21.788     0.200
     8.889    22.101     0.200
     8.889    21.937     0.200
     8.905    21.346     0.200
     8.972    20.981     0.200
     8.981    20.551     0.200
     9.206    22.078     0.200
     9.206    21.992     0.200
     9.346    22.179     0.200
     9.346    22.343     0.200
     9.443    23.287     0.200
     9.569    22.441     0.200
     9.569    21.535     0.200
     9.711    22.819     0.200
     9.711    22.248     0.200
    10.248    24.255     0.200
    10.352    24.775     0.200
    10.408    24.666     0.200
    10.414    24.856     0.200
    10.594    25.793     0.200
    10.629    23.212     0.200
    10.629    23.416     0.200
    10.688    23.707     0.200
    10.841    25.616     0.200
    10.908    27.732     0.200
    11.037    29.264     0.200
    11.574    25.260     0.200
    12.067    26.199     0.200
    12.067    26.441     0.200
    12.135    27.873     0.200
    12.987    29.649     0.200
    13.130    31.983     0.200
    13.130    30.568     0.200
    14.596    33.901     0.200
    14.895    32.895     0.200
    14.895    32.364     0.200
    19.402    36.621     0.200
     0.424     9.253     0.200
     0.700     8.576     0.200
     0.857     8.542     0.200
     0.860     8.691     0.200
     0.878     8.548     0.200
     0.883     8.526     0.200
     1.014     7.655     0.200
     1.122     7.896     0.200
     1.169     8.616     0.200
     1.420     7.879     0.200
     1.409     8.162     0.200
     1.548     8.705     0.200
     1.632     8.465     0.200
     1.664     9.059     0.200
     1.688     9.178     0.200
     1.754     8.645     0.200
     1.969     9.361     0.200
     2.013     9.170     0.200
     2.034     8.567     0.200
     2.023     9.543     0.200
     2.093     8.508     0.200
     2.079     9.678     0.200
     2.146     9.740     0.200
     2.257     9.720     0.200
     2.656    11.530     0.200
     2.643     9.907     0.200
     2.763     9.515     0.200
     2.801    10.589     0.200
     2.827     9.188     0.200
     2.810    10.342     0.200
     2.918    11.129     0.200
     3.145    11.356     0.200
     3.344    10.771     0.200
     3.641    11.892     0.200
     3.641    12.135     0.200
     3.706    11.202     0.200
     3.914    11.126     0.200
     3.920    12.578     0.200
     3.920    12.257     0.200
     4.012    11.441     0.200
     4.115    11.704     0.200
     4.332    11.974     0.200
     4.332    12.193     0.200
     4.437    13.288     0.200
     4.437    12.945     0.200
     4.451    13.681     0.200
     4.473    13.243     0.200
     4.473    13.517     0.200
     4.680    12.770     0.200
     4.695    12.820     0.200
     4.695    13.102     0.200
     4.801    14.233     0.200
     4.801    14.061     0.200
     4.912    13.834     0.200
     4.960    14.981     0.200
     4.987    13.998     0.200
     5.032    13.819     0.200
     5.092    13.705     0.200
     5.164    14.117     0.200
     5.227    14.734     0.200
     5.231    14.733     0.200
     5.289    14.395     0.200
     5.358    13.953     0.200
     5.358    14.187     0.200
     5.396    15.282     0.200
     5.396    15.134     0.200
     5.475    14.689     0.200
     5.582    14.159     0.200
     5.582    14.878     0.200
     5.596    14.947     0.200
     5.636    15.001     0.200
     5.624    15.806     0.200
     5.624    15.532     0.200
     5.755    15.586     0.200
     5.744    15.453     0.200
     5.744    15.625     0.200
     5.743    14.667     0.200
     5.743    15.581     0.200
     5.827    15.347     0.200
     5.851    15.724     0.200
     5.851    15.537     0.200
     5.900    15.299     0.200
     5.963    15.722     0.200
     5.974    15.428     0.200
     5.983    15.521     0.200
     6.020    15.955     0.200
     6.039    16.538     0.200
     6.108    15.980     0.200
     6.102    15.700     0.200
     6.226    15.965     0.200
     6.226    16.246     0.200
     6.302    16.590     0.200
     6.323    16.974     0.200
     6.377    16.272     0.200
     6.336    17.158     0.200
     6.397    16.732     0.200
     6.407    17.311     0.200
     6.407    16.983     0.200
     6.408    16.739     0.200
     6.416    16.281     0.200
     6.496    15.611     0.200
     6.496    15.845     0.200
     6.539    17.570     0.200
     6.573    15.830     0.200
     6.686    16.858     0.200
     6.686    17.217     0.200
     6.671    16.703     0.200
     6.671    17.024     0.200
     6.701    17.593     0.200
     6.705    17.684     0.200
     6.705    17.442     0.200
     6.742    17.556     0.200
     6.775    16.936     0.200
     6.803    18.296     0.200
     6.787    16.024     0.200
     6.847    18.059     0.200
     6.841    17.787     0.200
     6.841    17.677     0.200
     6.867    17.734     0.200
     6.870    17.874     0.200
     6.890    18.474     0.200
     6.979    18.569     0.200
     6.964    16.855     0.200
     6.993    18.083     0.200
     6.976    16.189     0.200
     6.976    17.369     0.200
     6.978    17.216     0.200
     6.978    17.357     0.200
     6.981    16.942     0.200
     7.029    17.936     0.200
     7.095    16.886     0.200
     7.095    17.026     0.200
     7.095    16.831     0.200
     7.124    17.771     0.200
     7.124    18.287     0.200
     7.136    18.704     0.200
     7.136    18.461     0.200
     7.235    18.635     0.200
     7.235    18.330     0.200
     7.278    17.663     0.200
     7.277    18.380     0.200
     7.342    17.562     0.200
     7.488    19.134     0.200
     7.506    19.262     0.200
     7.511    19.603     0.200
     7.533    19.392     0.200
     7.576    19.093     0.200
     7.638    18.820     0.200
     7.777    19.347     0.200
     7.841    19.492     0.200
     7.841    19.235     0.200
     8.383    19.902     0.200
     8.731    19.740     0.200
     8.864    20.074     0.200
     8.864    20.644     0.200
     8.943    22.200     0.200
     8.943    21.857     0.200
     9.397    22.464     0.200
     9.584    23.104     0.200
     9.710    23.407     0.200
     9.867    21.575     0.200
     9.944    23.956     0.200
     9.944    23.393     0.200
    10.386    23.846     0.200
    10.956    24.677     0.200
    12.562    29.797     0.200
    12.562    30.117     0.200
    13.326    29.921     0.200
    13.326    29.226     0.200
    16.804    31.188     0.200
     0.579     5.298     0.200
     0.824     5.667     0.200
     1.105     6.985     0.200
     1.134     7.084     0.200
     1.213     6.181     0.200
     1.344     6.996     0.200
     1.351     7.671     0.200
     1.641     6.976     0.200
     1.652     7.284     0.200
     1.662     7.557     0.200
     1.730     8.241     0.200
     1.752     7.248     0.200
     2.017     8.017     0.200
     2.072     8.361     0.200
     2.114     8.902     0.200
     2.223     8.612     0.200
     2.221     8.759     0.200
     2.243     8.863     0.200
     2.354     7.698     0.200
     2.453     8.400     0.200
     2.659     9.611     0.200
     2.881    10.476     0.200
     2.954    10.868     0.200
     3.020    10.873     0.200
     3.079     9.788     0.200
     3.285     9.917     0.200
     3.662    10.145     0.200
     3.682    10.575     0.200
     3.679    11.707     0.200
     3.736    10.142     0.200
     3.867    11.072     0.200
     3.895    10.263     0.200
     4.035    11.247     0.200
     4.010    12.265     0.200
     4.091    11.414     0.200
     4.344    12.607     0.200
     4.398    12.243     0.200
     4.568    12.833     0.200
     4.787    12.756     0.200
     4.909    13.841     0.200
     4.879    13.814     0.200
     4.900    13.897     0.200
     5.074    15.167     0.200
     5.083    13.747     0.200
     5.136    13.895     0.200
     5.173    14.066     0.200
     5.224    14.961     0.200
     5.270    14.967     0.200
     5.360    14.288     0.200
     5.370    14.308     0.200
     5.458    14.726     0.200
     5.651    15.304     0.200
     5.665    15.621     0.200
     5.755    15.588     0.200
     5.776    14.148     0.200
     5.804    15.090     0.200
     5.861    16.071     0.200
     5.892    16.514     0.200
     6.015    16.237     0.200
     6.170    16.764     0.200
     6.489    17.301     0.200
     6.631    17.242     0.200
     6.698    16.438     0.200
     6.933    18.396     0.200
     6.970    17.423     0.200
     6.970    16.314     0.200
     7.142    18.092     0.200
     7.676    19.861     0.200
    13.049    29.396     0.200
    18.961    35.708     0.200
     0.762     6.095     0.200
     1.284     6.912     0.200
     1.332     7.308     0.200
     1.424     6.985     0.200
     1.415     7.374     0.200
     1.515     7.320     0.200
     1.546     6.907     0.200
     1.680     8.010     0.200
     1.932     8.597     0.200
     1.943     8.599     0.200
     2.126     7.661     0.200
     2.247     7.387     0.200
     2.267     8.991     0.200
     2.272     8.814     0.200
     2.277     8.695     0.200
     2.316     8.481     0.200
     2.351     8.522     0.200
     2.407     8.249     0.200
     2.407     8.526     0.200
     2.380     8.988     0.200
     2.431     8.883     0.200
     2.437     9.122     0.200
     2.443     8.982     0.200
     2.530     9.880     0.200
     2.777     9.752     0.200
     2.910     9.433     0.200
     2.956     9.920     0.200
     2.978     9.850     0.200
     3.005    10.195     0.200
     2.997    10.359     0.200
     3.061     9.915     0.200
     3.054     9.957     0.200
     3.264    11.175     0.200
     3.446    10.215     0.200
     3.515    10.572     0.200
     3.566    10.037     0.200
     3.551    10.550     0.200
     3.539    11.294     0.200
     3.577    10.989     0.200
     3.719    11.126     0.200
     3.740    11.230     0.200
     3.754    11.433     0.200
     3.742    11.764     0.200
     3.897    11.713     0.200
     4.078    12.020     0.200
     4.147    12.449     0.200
     4.241    11.192     0.200
     4.284    12.577     0.200
     4.292    13.090     0.200
     4.420    12.527     0.200
     4.680    13.994     0.200
     4.676    13.661     0.200
     4.832    12.720     0.200
     4.818    13.515     0.200
     4.925    13.867     0.200
     5.010    13.830     0.200
     5.030    13.678     0.200
     5.218    13.446     0.200
     5.213    14.452     0.200
     5.195    13.436     0.200
     5.184    14.271     0.200
     5.249    14.334     0.200
     5.343    13.855     0.200
     5.280    14.361     0.200
     5.327    14.528     0.200
     5.327    14.740     0.200
     5.399    14.675     0.200
     5.635    15.510     0.200
     5.709    14.383     0.200
     5.875    15.448     0.200
     6.325    15.166     0.200
     6.448    16.641     0.200
     6.548    16.355     0.200
     6.652    16.790     0.200
     6.786    16.764     0.200
     6.813    17.396     0.200
     6.897    16.716     0.200
     6.905    16.920     0.200
     6.993    18.036     0.200
     7.016    17.657     0.200
     7.322    17.660     0.200
     7.461    18.029     0.200
     7.809    18.868     0.200
     7.835    18.732     0.200
     9.498    22.701     0.200
     1.708     8.844     0.200
     1.810     8.912     0.200
     1.895     9.330     0.200
     2.110     9.862     0.200
     2.154     9.874     0.200
     2.175    11.039     0.200
     2.175    10.352     0.200
     2.598    10.581     0.200
     2.836    11.051     0.200
     2.916    10.967     0.200
     2.955    12.333     0.200
     3.013    13.034     0.200
     3.244    12.311     0.200
     3.236    12.589     0.200
     3.265    12.203     0.200
     3.334    13.108     0.200
     3.342    12.544     0.200
     3.482    12.248     0.200
     3.710    14.002     0.200
     3.733    13.097     0.200
     3.804    13.023     0.200
     3.842    12.855     0.200
     3.885    12.198     0.200
     4.087    13.352     0.200
     4.107    14.503     0.200
     4.093    13.291     0.200
     4.145    13.414     0.200
     4.311    13.974     0.200
     4.311    13.700     0.200
     4.464    15.419     0.200
     4.508    15.164     0.200
     4.617    14.429     0.200
     4.691    14.749     0.200
     4.795    14.822     0.200
     4.821    14.590     0.200
     5.183    16.557     0.200
     5.183    16.225     0.200
     5.262    15.707     0.200
     5.271    15.642     0.200
     5.311    14.942     0.200
     5.435    16.045     0.200
     5.477    16.032     0.200
     5.735    16.550     0.200
     5.894    17.295     0.200
     5.904    17.004     0.200
     5.964    17.201     0.200
     6.042    17.214     0.200
     6.136    17.396     0.200
     6.159    17.228     0.200
     6.269    17.530     0.200
     6.314    17.436     0.200
     6.550    18.488     0.200
     6.563    18.228     0.200
     6.621    19.395     0.200
     6.694    20.242     0.200
     6.735    17.886     0.200
     6.846    19.415     0.200
     6.859    18.637     0.200
     6.899    20.958     0.200
     6.996    20.110     0.200
     7.003    19.996     0.200
     7.067    19.535     0.200
     7.299    20.018     0.200
     7.444    20.875     0.200
     7.853    20.910     0.200
     8.125    21.980     0.200
     8.332    23.092     0.200
     9.254    24.413     0.200
     0.270    15.142     0.200
     0.313    15.170     0.200
     0.398    14.474     0.200
     0.532    13.622     0.200
     0.549    13.437     0.200
     0.813    11.818     0.200
     0.932    11.774     0.200
     0.932    12.016     0.200
     1.032    11.361     0.200
     1.044    11.309     0.200
     1.196    10.999     0.200
     1.242    12.082     0.200
     1.245    11.843     0.200
     1.257    11.638     0.200
     1.276    11.166     0.200
     1.514    11.476     0.200
     1.649     9.893     0.200
     1.694    10.752     0.200
     1.738     9.909     0.200
     2.036    11.650     0.200
     2.117    10.144     0.200
     2.174    11.868     0.200
     2.249    11.455     0.200
     2.276    11.727     0.200
     2.276    11.610     0.200
     2.287    11.300     0.200
     2.290    11.575     0.200
     2.383    11.430     0.200
     2.396    10.810     0.200
     2.416    11.457     0.200
     2.482    11.506     0.200
     2.527    11.497     0.200
     2.639    10.830     0.200
     2.639    11.307     0.200
     2.839    10.707     0.200
     3.033    12.873     0.200
     3.039    13.440     0.200
     3.039    12.057     0.200
     3.055    12.409     0.200
     3.055    12.229     0.200
     3.065    12.935     0.200
     3.181    12.586     0.200
     3.204    11.673     0.200
     3.229    11.742     0.200
     3.363    12.908     0.200
     3.404    13.047     0.200
     3.421    12.806     0.200
     3.421    12.454     0.200
     3.618    13.269     0.200
     3.618    13.120     0.200
     3.770    12.567     0.200
     3.972    13.872     0.200
     3.972    13.997     0.200
     4.101    12.817     0.200
     4.101    13.013     0.200
     4.202    12.731     0.200
     4.303    12.788     0.200
     4.303    12.460     0.200
     4.320    12.376     0.200
     4.320    12.212     0.200
     4.353    14.190     0.200
     4.376    14.146     0.200
     4.376    13.584     0.200
     4.441    11.732     0.200
     4.458    12.823     0.200
     4.458    12.666     0.200
     4.450    11.874     0.200
     4.514    12.758     0.200
     4.571    13.953     0.200
     4.571    13.844     0.200
     4.591    16.020     0.200
     4.707    13.732     0.200
     4.712    13.662     0.200
     4.750    13.651     0.200
     4.750    13.073     0.200
     4.750    12.971     0.200
     4.750    12.839     0.200
     4.829    14.924     0.200
     4.835    15.045     0.200
     4.974    13.377     0.200
     5.044    14.483     0.200
     5.100    15.212     0.200
     5.142    14.017     0.200
     5.244    14.822     0.200
     5.244    14.681     0.200
     5.421    15.681     0.200
     5.440    15.394     0.200
     5.459    15.530     0.200
     5.459    15.327     0.200
     5.474    14.015     0.200
     5.511    16.183     0.200
     5.511    15.840     0.200
     5.534    15.064     0.200
     5.534    14.884     0.200
     5.642    16.310     0.200
     5.642    16.045     0.200
     5.711    14.920     0.200
     5.747    16.497     0.200
     5.747    16.747     0.200
     5.746    15.415     0.200
     5.766    15.156     0.200
     5.820    16.158     0.200
     5.820    15.744     0.200
     5.899    16.428     0.200
     5.913    15.803     0.200
     5.913    15.592     0.200
     5.944    15.173     0.200
     5.944    14.899     0.200
     6.014    16.284     0.200
     6.014    15.792     0.200
     6.035    16.362     0.200
     6.087    16.770     0.200
     6.152    16.897     0.200
     6.152    16.452     0.200
     6.183    16.696     0.200
     6.231    17.330     0.200
     6.231    16.603     0.200
     6.269    16.401     0.200
     6.311    16.332     0.200
     6.435    17.126     0.200
     6.524    17.446     0.200
     6.521    16.482     0.200
     6.521    16.271     0.200
     6.608    17.726     0.200
     6.709    17.644     0.200
     6.722    16.324     0.200
     6.722    16.129     0.200
     6.804    17.824     0.200
     6.821    16.944     0.200
     6.837    16.441     0.200
     6.886    17.733     0.200
     6.948    18.232     0.200
     6.983    18.037     0.200
     6.986    18.822     0.200
     7.008    18.082     0.200
     7.008    17.918     0.200
     7.052    16.613     0.200
     7.077    16.824     0.200
     7.134    19.399     0.200
     7.156    18.157     0.200
     7.159    17.295     0.200
     7.159    16.834     0.200
     7.180    19.041     0.200
     7.180    18.854     0.200
     7.196    19.036     0.200
     7.196    18.927     0.200
     7.217    16.817     0.200
     7.220    17.089     0.200
     7.231    17.775     0.200
     7.231    17.478     0.200
     7.230    17.420     0.200
     7.230    17.108     0.200
     7.232    17.295     0.200
     7.232    17.123     0.200
     7.311    19.599     0.200
     7.323    18.951     0.200
     7.346    18.694     0.200
     7.346    18.030     0.200
     7.382    17.200     0.200
     7.382    16.864     0.200
     7.382    17.138     0.200
     7.442    19.845     0.200
     7.440    18.085     0.200
     7.464    19.092     0.200
     7.464    19.303     0.200
     7.534    18.049     0.200
     7.534    17.479     0.200
     7.633    19.402     0.200
     7.633    19.129     0.200
     7.673    17.673     0.200
     7.673    17.415     0.200
     7.676    17.870     0.200
     7.676    17.659     0.200
     7.680    21.240     0.200
     7.841    20.639     0.200
     7.838    18.472     0.200
     7.838    18.097     0.200
     7.888    20.529     0.200
     7.964    19.865     0.200
     7.964    19.443     0.200
     7.983    19.106     0.200
     7.983    20.309     0.200
     8.058    20.764     0.200
     8.058    20.483     0.200
     8.058    17.687     0.200
     8.092    20.327     0.200
     8.144    20.651     0.200
     8.155    18.389     0.200
     8.255    20.883     0.200
     8.328    18.319     0.200
     8.798    22.399     0.200
     8.867    22.536     0.200
     8.980    20.263     0.200
     8.980    19.607     0.200
     9.137    20.239     0.200
     9.269    23.196     0.200
     9.403    21.890     0.200
     9.403    22.257     0.200
     9.460    23.784     0.200
     9.934    22.399     0.200
    10.108    20.276     0.200
    10.408    22.480     0.200
    10.465    22.886     0.200
    10.671    26.585     0.200
    10.759    23.917     0.200
    10.944    24.939     0.200
    11.566    25.576     0.200
    11.566    24.514     0.200
    12.448    28.530     0.200
    12.462    26.198     0.200
    13.685    27.009     0.200
    13.685    27.119     0.200
    13.685    26.705     0.200
     0.711     5.553     0.200
     0.711     5.835     0.200
     0.782     4.628     0.200
     1.178     6.114     0.200
     1.259     6.575     0.200
     1.329     6.824     0.200
     1.358     6.928     0.200
     1.349     6.496     0.200
     1.349     6.684     0.200
     1.461     7.088     0.200
     1.566     6.571     0.200
     1.605     7.757     0.200
     1.619     7.708     0.200
     1.664     6.299     0.200
     1.664     6.619     0.200
     1.968     7.857     0.200
     2.090     7.810     0.200
     2.533     9.928     0.200
     2.533     9.654     0.200
     2.805     9.771     0.200
     2.805     9.060     0.200
     2.973    11.011     0.200
     2.994    10.934     0.200
     2.998     9.957     0.200
     3.082    10.182     0.200
     3.285    11.516     0.200
     3.284    11.619     0.200
     3.658    10.976     0.200
     3.664    11.982     0.200
     3.678    11.873     0.200
     3.697    11.633     0.200
     3.801    12.628     0.200
     3.994    11.558     0.200
     4.020    11.862     0.200
     4.128    12.852     0.200
     4.137    12.856     0.200
     4.191    13.122     0.200
     4.259    13.087     0.200
     4.261    13.012     0.200
     4.514    13.185     0.200
     4.786    13.433     0.200
     4.821    14.631     0.200
     4.926    14.509     0.200
     4.943    14.427     0.200
     4.987    14.680     0.200
     5.031    13.861     0.200
     5.034    15.002     0.200
     5.260    15.032     0.200
     5.351    15.148     0.200
     5.396    14.468     0.200
     5.600    15.213     0.200
     5.610    15.677     0.200
     5.660    14.543     0.200
     5.954    16.637     0.200
     6.033    15.992     0.200
     6.181    16.316     0.200
     6.336    17.095     0.200
     6.359    16.236     0.200
     6.379    17.124     0.200
     6.414    16.612     0.200
     6.442    15.858     0.200
     6.532    18.883     0.200
     6.706    17.067     0.200
     6.716    17.950     0.200
     6.773    17.807     0.200
     6.810    16.280     0.200
     6.817    18.263     0.200
     6.885    17.118     0.200
     6.948    17.635     0.200
     6.967    18.090     0.200
     7.050    19.122     0.200
     7.164    17.703     0.200
     7.241    17.433     0.200
     7.279    19.049     0.200
     7.336    19.698     0.200
     7.345    18.739     0.200
     7.364    18.090     0.200
     7.464    18.233     0.200
     7.542    19.076     0.200
     7.587    18.241     0.200
     7.645    18.348     0.200
     7.665    20.004     0.200
     7.754    19.330     0.200
     7.846    19.635     0.200
     7.859    19.759     0.200
     7.940    19.366     0.200
     8.007    19.170     0.200
     8.128    19.452     0.200
     8.132    20.376     0.200
     8.256    19.904     0.200
     8.423    20.158     0.200
     8.540    20.823     0.200
     8.631    20.880     0.200
     8.688    19.134     0.200
     8.728    20.494     0.200
     8.768    21.493     0.200
     8.896    21.915     0.200
     8.902    19.268     0.200
     8.996    22.429     0.200
     9.064    23.041     0.200
     9.075    20.884     0.200
     9.097    20.514     0.200
     9.181    22.487     0.200
     9.206    21.941     0.200
     9.206    20.550     0.200
     9.206    22.347     0.200
     9.326    22.764     0.200
     9.349    23.355     0.200
     9.426    23.462     0.200
     9.435    23.182     0.200
     9.455    23.866     0.200
     9.455    23.037     0.200
    10.147    22.980     0.200
    10.764    25.928     0.200
    10.793    26.923     0.200
    10.801    26.938     0.200
    11.982    25.719     0.200
    18.840    35.353     0.200
     0.303    11.572     0.200
     0.362    10.855     0.200
     0.368    10.877     0.200
     0.455    10.718     0.200
     0.502    10.354     0.200
     0.652     9.776     0.200
     0.974     9.318     0.200
     0.980     9.301     0.200
     1.156     8.022     0.200
     1.176     7.770     0.200
     1.101     9.150     0.200
     1.289     8.506     0.200
     1.375     9.351     0.200
     1.393     9.217     0.200
     1.396     9.223     0.200
     1.607     8.048     0.200
     1.682     9.492     0.200
     2.058     9.923     0.200
     2.065     9.545     0.200
     2.065     9.412     0.200
     2.205    10.227     0.200
     2.249     9.694     0.200
     2.218     8.836     0.200
     2.388     8.536     0.200
     2.476    10.495     0.200
     2.536     9.510     0.200
     2.520    10.539     0.200
     2.527    10.683     0.200
     2.588     9.664     0.200
     2.580    10.828     0.200
     2.630    10.826     0.200
     2.653    10.855     0.200
     2.680    10.789     0.200
     2.760     9.668     0.200
     3.002    10.806     0.200
     3.126    11.326     0.200
     3.280    10.650     0.200
     3.321    10.664     0.200
     3.307    11.684     0.200
     3.255    11.532     0.200
     3.319    11.421     0.200
     3.332    12.153     0.200
     3.333    11.832     0.200
     3.443    11.335     0.200
     3.426    12.088     0.200
     3.653    12.415     0.200
     3.775    12.609     0.200
     3.827    13.051     0.200
     3.865    11.847     0.200
     4.053    13.190     0.200
     4.213    12.237     0.200
     4.275    12.891     0.200
     4.261    12.336     0.200
     4.367    13.885     0.200
     4.436    12.683     0.200
     4.530    12.620     0.200
     4.637    13.008     0.200
     4.723    12.544     0.200
     4.797    13.563     0.200
     4.853    13.315     0.200
     4.828    14.773     0.200
     4.851    14.320     0.200
     4.918    12.615     0.200
     4.921    15.034     0.200
     5.022    13.578     0.200
     5.152    14.284     0.200
     5.212    14.036     0.200
     5.239    14.931     0.200
     5.405    14.853     0.200
     5.440    15.643     0.200
     5.535    14.809     0.200
     5.576    15.007     0.200
     5.615    14.678     0.200
     5.764    15.768     0.200
     5.724    15.565     0.200
     5.736    15.469     0.200
     5.804    15.558     0.200
     5.875    15.839     0.200
     5.869    14.950     0.200
     5.992    15.003     0.200
     6.046    15.817     0.200
     6.047    16.931     0.200
     6.060    16.275     0.200
     6.105    15.583     0.200
     6.133    16.340     0.200
     6.198    16.517     0.200
     6.276    16.484     0.200
     6.234    16.654     0.200
     6.257    16.019     0.200
     6.366    16.839     0.200
     6.388    16.684     0.200
     6.405    17.437     0.200
     6.454    16.568     0.200
     6.467    16.897     0.200
     6.567    17.307     0.200
     6.545    16.051     0.200
     6.622    16.835     0.200
     6.707    17.593     0.200
     6.753    17.681     0.200
     6.842    17.922     0.200
     6.839    17.449     0.200
     6.845    17.668     0.200
     6.880    17.998     0.200
     6.883    17.605     0.200
     6.977    18.499     0.200
     7.001    16.289     0.200
     7.065    18.590     0.200
     7.086    16.449     0.200
     7.157    17.000     0.200
     7.206    18.604     0.200
     7.174    18.242     0.200
     7.215    18.512     0.200
     7.286    19.371     0.200
     7.329    18.873     0.200
     7.300    16.530     0.200
     7.363    18.421     0.200
     7.404    19.311     0.200
     7.445    18.578     0.200
     7.463    17.496     0.200
     7.487    18.042     0.200
     7.489    16.622     0.200
     7.489    17.385     0.200
     7.550    19.014     0.200
     7.622    19.333     0.200
     7.612    17.302     0.200
     7.612    16.990     0.200
     7.591    19.358     0.200
     7.799    18.426     0.200
     7.863    18.229     0.200
     7.881    19.356     0.200
     7.997    20.138     0.200
     8.016    19.693     0.200
     8.016    19.635     0.200
     8.009    19.204     0.200
     8.241    23.087     0.200
     8.346    18.919     0.200
     9.456    22.666     0.200
     9.880    23.699     0.200
    10.062    24.020     0.200
    10.376    24.753     0.200
    10.377    21.927     0.200
    10.775    26.329     0.200
    10.856    25.633     0.200
    18.294    32.884     0.200
     1.254     6.281     0.200
     1.408     7.592     0.200
     1.521     8.612     0.200
     1.533     8.569     0.200
     1.657     7.351     0.200
     1.681     6.981     0.200
     1.707     8.742     0.200
     1.707     9.102     0.200
     2.000     8.820     0.200
     1.996     8.876     0.200
     2.078     8.075     0.200
     2.286     8.001     0.200
     2.220     8.063     0.200
     2.347     8.569     0.200
     2.387    10.230     0.200
     2.491     8.669     0.200
     2.422     9.007     0.200
     2.506     9.403     0.200
     2.518     9.226     0.200
     3.053    11.426     0.200
     3.029    10.868     0.200
     3.222     9.837     0.200
     3.162     9.529     0.200
     3.367    10.965     0.200
     3.668    10.333     0.200
     3.737     9.956     0.200
     3.556    11.200     0.200
     3.708    12.276     0.200
     3.908    10.865     0.200
     3.900    11.428     0.200
     4.049    12.766     0.200
     4.086    12.593     0.200
     4.306    13.237     0.200
     4.452    13.150     0.200
     4.345    13.770     0.200
     4.481    13.968     0.200
     4.868    13.347     0.200
     4.988    14.818     0.200
     5.095    14.108     0.200
     5.181    14.669     0.200
     5.202    14.039     0.200
     5.388    15.175     0.200
     5.250    16.236     0.200
     5.461    15.661     0.200
     5.389    15.820     0.200
     5.357    16.413     0.200
     5.576    16.693     0.200
     5.571    14.493     0.200
     5.462    16.277     0.200
     5.442    14.357     0.200
     5.704    15.397     0.200
     5.884    16.486     0.200
     5.880    16.853     0.200
     5.986    17.343     0.200
     6.080    16.975     0.200
     5.988    15.923     0.200
     6.923    18.730     0.200
     7.039    19.411     0.200
     7.118    19.430     0.200
     7.166    19.661     0.200
     7.927    20.171     0.200
     9.866    26.260     0.200
     0.604     6.493     0.200
     0.715     6.524     0.200
     0.732     6.581     0.200
     0.755     6.726     0.200
     0.772     6.217     0.200
     0.780     6.455     0.200
     1.041     6.685     0.200
     1.085     6.435     0.200
     1.381     7.186     0.200
     1.381     7.501     0.200
     1.810     7.573     0.200
     1.824     8.708     0.200
     1.827     9.002     0.200
     1.846     8.824     0.200
     1.848     8.708     0.200
     1.913     7.487     0.200
     1.913     7.045     0.200
     2.137     9.403     0.200
     2.136     9.236     0.200
     2.217     8.580     0.200
     2.263     8.387     0.200
     2.263     8.702     0.200
     2.525     9.557     0.200
     2.525     9.925     0.200
     2.577     9.197     0.200
     2.577     9.718     0.200
     2.647    10.178     0.200
     2.855     9.036     0.200
     2.888     9.712     0.200
     2.939    10.575     0.200
     2.920    10.227     0.200
     2.983    11.200     0.200
     2.994    10.805     0.200
     3.098    11.110     0.200
     3.076    10.513     0.200
     3.144    10.448     0.200
     3.195    11.150     0.200
     3.524    11.245     0.200
     3.589    12.102     0.200
     3.612    10.231     0.200
     3.636    10.685     0.200
     3.778    11.932     0.200
     3.797    12.440     0.200
     3.887    12.447     0.200
     4.024    11.532     0.200
     4.113    12.819     0.200
     4.242    12.368     0.200
     4.290    13.274     0.200
     4.530    12.319     0.200
     4.572    14.262     0.200
     4.695    13.671     0.200
     4.674    13.309     0.200
     4.821    12.773     0.200
     4.877    14.487     0.200
     4.886    12.862     0.200
     5.007    12.747     0.200
     5.024    14.454     0.200
     5.177    12.766     0.200
     5.226    13.583     0.200
     5.240    15.216     0.200
     5.306    13.674     0.200
     5.379    13.942     0.200
     5.373    14.819     0.200
     5.410    16.043     0.200
     5.562    14.633     0.200
     5.676    14.939     0.200
     5.730    15.793     0.200
     5.752    16.258     0.200
     5.833    15.106     0.200
     5.841    15.478     0.200
     5.932    16.742     0.200
     5.950    15.197     0.200
     5.999    15.260     0.200
     6.007    15.258     0.200
     6.048    15.827     0.200
     6.075    15.444     0.200
     6.081    15.983     0.200
     6.142    16.181     0.200
     6.200    16.025     0.200
     6.200    15.896     0.200
     6.228    15.855     0.200
     6.367    16.801     0.200
     6.412    16.405     0.200
     6.430    16.137     0.200
     6.456    16.578     0.200
     6.507    16.846     0.200
     6.561    16.951     0.200
     6.574    17.600     0.200
     6.643    17.189     0.200
     6.644    16.721     0.200
     6.691    17.219     0.200
     6.698    17.620     0.200
     6.704    17.019     0.200
     6.716    17.098     0.200
     6.764    17.530     0.200
     6.933    17.726     0.200
     6.947    17.552     0.200
     6.985    17.305     0.200
     7.012    18.016     0.200
     7.042    17.999     0.200
     7.092    17.771     0.200
     7.101    18.208     0.200
     7.249    18.587     0.200
     7.409    18.816     0.200
     7.445    19.229     0.200
     7.464    17.372     0.200
     7.487    18.746     0.200
     7.523    19.138     0.200
     7.534    17.308     0.200
     7.627    19.190     0.200
     7.674    19.563     0.200
     7.743    19.607     0.200
     7.747    17.501     0.200
     7.901    19.984     0.200
     7.916    19.474     0.200
     7.936    18.345     0.200
     7.947    19.441     0.200
     8.049    18.611     0.200
     8.049    18.361     0.200
     8.049    18.721     0.200
     8.065    19.641     0.200
     8.098    20.031     0.200
     8.138    19.486     0.200
     8.175    19.438     0.200
     8.276    19.608     0.200
     8.308    20.546     0.200
     8.326    20.316     0.200
     8.394    21.003     0.200
     8.553    20.168     0.200
     8.810    21.321     0.200
     9.277    21.363     0.200
     9.778    23.234     0.200
    10.119    24.935     0.200
    10.515    25.152     0.200
    11.063    26.543     0.200
    12.974    30.313     0.200
    14.238    30.336     0.200
     0.581     5.405     0.200
     0.913     6.314     0.200
     0.921     6.382     0.200
     0.923     6.336     0.200
     0.942     6.371     0.200
     1.151     6.750     0.200
     1.188     6.816     0.200
     1.314     6.748     0.200
     1.376     7.095     0.200
     1.363     7.745     0.200
     1.468     7.158     0.200
     1.618     7.843     0.200
     1.673     7.235     0.200
     1.703     7.461     0.200
     1.861     7.435     0.200
     1.950     8.093     0.200
     1.994     8.488     0.200
     2.018     8.377     0.200
     2.091     8.422     0.200
     2.122     9.383     0.200
     2.126     8.620     0.200
     2.426     8.327     0.200
     2.467     8.611     0.200
     2.473    10.681     0.200
     2.470     8.803     0.200
     2.598     8.034     0.200
     2.669     8.639     0.200
     2.783    10.522     0.200
     2.813    10.905     0.200
     2.863    10.281     0.200
     3.083    10.054     0.200
     3.083    10.591     0.200
     3.345    10.086     0.200
     3.513    11.437     0.200
     3.578    11.615     0.200
     3.665    10.667     0.200
     3.712    10.842     0.200
     3.823    10.242     0.200
     3.870    11.436     0.200
     3.836    11.745     0.200
     3.999    10.428     0.200
     4.061    11.660     0.200
     4.042    12.444     0.200
     4.123    12.046     0.200
     4.216    11.665     0.200
     4.384    12.623     0.200
     4.495    12.616     0.200
     4.451    13.887     0.200
     4.621    13.583     0.200
     4.638    13.447     0.200
     4.648    13.134     0.200
     4.687    13.119     0.200
     4.714    13.210     0.200
     4.815    12.913     0.200
     4.854    13.412     0.200
     4.907    13.015     0.200
     4.873    13.416     0.200
     4.927    14.123     0.200
     4.978    14.013     0.200
     5.096    13.418     0.200
     5.157    14.370     0.200
     5.188    14.854     0.200
     5.333    14.586     0.200
     5.361    14.757     0.200
     5.451    14.883     0.200
     5.469    14.261     0.200
     5.516    14.756     0.200
     5.434    15.207     0.200
     5.515    15.074     0.200
     5.621    14.696     0.200
     5.620    15.491     0.200
     5.779    15.246     0.200
     5.722    15.398     0.200
     5.803    14.993     0.200
     5.749    15.315     0.200
     5.811    15.525     0.200
     5.955    15.741     0.200
     6.116    16.303     0.200
     6.262    15.686     0.200
     6.333    16.641     0.200
     6.302    17.243     0.200
     6.383    17.054     0.200
     6.410    15.636     0.200
     6.496    16.551     0.200
     6.448    16.011     0.200
     6.550    18.280     0.200
     6.578    17.253     0.200
     6.703    16.835     0.200
     6.719    17.982     0.200
     6.743    17.315     0.200
     6.878    17.066     0.200
     6.906    16.350     0.200
     6.942    16.998     0.200
     6.942    16.819     0.200
     7.122    17.415     0.200
     7.140    18.353     0.200
     7.138    17.352     0.200
     7.207    17.719     0.200
     7.544    18.246     0.200
     7.544    18.508     0.200
     7.756    18.646     0.200
     8.348    18.312     0.200
     8.442    20.704     0.200
     8.504    21.564     0.200
     8.872    19.820     0.200
     9.422    22.735     0.200
     9.753    22.123     0.200
     9.747    22.405     0.200
    11.992    27.087     0.200
     0.615     6.429     0.200
     0.655     6.700     0.200
     0.663     6.812     0.200
     0.683     6.907     0.200
     0.692     6.808     0.200
     0.861     6.477     0.200
     0.861     6.887     0.200
     0.845     6.660     0.200
     0.845     6.806     0.200
     0.845     6.772     0.200
     0.882     6.655     0.200
     1.131     6.484     0.200
     1.131     6.070     0.200
     1.177     6.271     0.200
     1.180     7.425     0.200
     1.180     7.527     0.200
     1.217     6.856     0.200
     1.523     7.543     0.200
     1.566     7.220     0.200
     1.596     7.773     0.200
     1.697     8.218     0.200
     1.748     7.069     0.200
     1.748     7.414     0.200
     1.947     7.055     0.200
     1.947     7.452     0.200
     1.965     7.923     0.200
     1.979     9.771     0.200
     1.979    10.111     0.200
     2.100     7.480     0.200
     2.100     8.180     0.200
     2.303     9.602     0.200
     2.303     9.722     0.200
     2.327     9.974     0.200
     2.359     9.888     0.200
     2.374    10.001     0.200
     2.401    10.059     0.200
     2.509    10.163     0.200
     2.530     8.495     0.200
     2.530     8.858     0.200
     2.530     8.616     0.200
     2.580     8.983     0.200
     2.580     9.314     0.200
     2.618    10.526     0.200
     2.698     9.025     0.200
     2.855     8.978     0.200
     2.855     9.513     0.200
     3.082    10.350     0.200
     3.162     9.439     0.200
     3.162    10.160     0.200
     3.188     9.585     0.200
     3.188     9.833     0.200
     3.194     9.571     0.200
     3.211     9.638     0.200
     3.211    10.140     0.200
     3.349     9.232     0.200
     3.349     9.494     0.200
     3.367    10.124     0.200
     3.491    11.638     0.200
     3.491    11.808     0.200
     3.539     9.315     0.200
     3.558    10.488     0.200
     3.558    11.007     0.200
     3.536    10.272     0.200
     3.596    11.317     0.200
     3.648    10.421     0.200
     3.650    12.399     0.200
     3.670    11.317     0.200
     3.728    11.200     0.200
     3.757    10.968     0.200
     3.775    10.597     0.200
     3.885    11.203     0.200
     3.885    11.811     0.200
     4.004    12.921     0.200
     4.028    11.279     0.200
     4.167    12.024     0.200
     4.167    12.194     0.200
     4.256    12.282     0.200
     4.351    12.756     0.200
     4.373    12.762     0.200
     4.373    12.905     0.200
     4.372    13.073     0.200
     4.402    12.258     0.200
     4.392    13.092     0.200
     4.458    11.683     0.200
     4.458    12.167     0.200
     4.465    13.069     0.200
     4.467    12.462     0.200
     4.519    12.914     0.200
     4.530    13.151     0.200
     4.532    13.517     0.200
     4.532    13.976     0.200
     4.505    14.133     0.200
     4.577    12.666     0.200
     4.633    14.690     0.200
     4.685    12.663     0.200
     4.678    13.941     0.200
     4.678    13.404     0.200
     4.695    13.607     0.200
     4.720    14.203     0.200
     4.758    12.924     0.200
     4.758    13.146     0.200
     4.830    13.861     0.200
     4.844    13.702     0.200
     4.839    13.375     0.200
     4.859    13.593     0.200
     4.859    13.849     0.200
     4.916    13.348     0.200
     4.993    14.069     0.200
     4.993    13.948     0.200
     5.009    12.812     0.200
     5.021    14.343     0.200
     5.059    13.631     0.200
     5.075    13.625     0.200
     5.108    13.228     0.200
     5.129    14.688     0.200
     5.129    14.438     0.200
     5.198    13.977     0.200
     5.217    14.318     0.200
     5.258    14.573     0.200
     5.258    13.957     0.200
     5.310    14.468     0.200
     5.328    14.054     0.200
     5.348    14.857     0.200
     5.348    15.498     0.200
     5.391    14.609     0.200
     5.468    14.516     0.200
     5.472    15.124     0.200
     5.486    15.046     0.200
     5.504    14.998     0.200
     5.509    14.340     0.200
     5.566    15.317     0.200
     5.638    14.818     0.200
     5.638    15.211     0.200
     5.702    15.380     0.200
     5.822    15.083     0.200
     5.822    15.505     0.200
     5.834    15.358     0.200
     5.867    16.519     0.200
     5.871    16.227     0.200
     5.936    16.245     0.200
     5.927    14.880     0.200
     5.957    16.002     0.200
     5.961    16.582     0.200
     5.956    15.041     0.200
     6.058    16.155     0.200
     6.058    15.917     0.200
     6.070    16.780     0.200
     6.076    15.551     0.200
     6.076    15.862     0.200
     6.082    15.995     0.200
     6.166    15.299     0.200
     6.220    16.828     0.200
     6.241    16.135     0.200
     6.248    16.608     0.200
     6.254    16.004     0.200
     6.238    17.220     0.200
     6.299    17.125     0.200
     6.299    16.533     0.200
     6.327    16.557     0.200
     6.367    16.014     0.200
     6.369    15.820     0.200
     6.369    15.990     0.200
     6.390    15.948     0.200
     6.429    16.188     0.200
     6.429    16.342     0.200
     6.446    17.171     0.200
     6.445    16.135     0.200
     6.445    16.026     0.200
     6.504    16.685     0.200
     6.504    16.343     0.200
     6.612    17.554     0.200
     6.627    16.496     0.200
     6.637    17.017     0.200
     6.637    17.236     0.200
     6.636    16.894     0.200
     6.655    17.175     0.200
     6.655    16.626     0.200
     6.662    16.625     0.200
     6.694    17.374     0.200
     6.716    17.353     0.200
     6.736    16.900     0.200
     6.776    16.967     0.200
     6.776    16.817     0.200
     7.020    17.231     0.200
     7.073    17.428     0.200
     7.086    17.712     0.200
     7.127    17.872     0.200
     7.143    17.810     0.200
     7.143    17.322     0.200
     7.271    17.591     0.200
     7.244    19.382     0.200
     7.244    19.486     0.200
     7.244    19.603     0.200
     7.317    19.701     0.200
     7.371    19.414     0.200
     7.371    19.209     0.200
     7.421    19.163     0.200
     7.460    19.984     0.200
     7.768    19.644     0.200
     7.768    19.470     0.200
     7.942    19.549     0.200
     7.975    19.969     0.200
     8.016    20.921     0.200
     8.104    19.919     0.200
     8.339    21.322     0.200
     8.339    21.730     0.200
     8.413    20.460     0.200
     8.413    20.761     0.200
     8.501    20.345     0.200
     8.696    21.201     0.200
     8.747    21.623     0.200
     8.736    22.046     0.200
     8.812    20.658     0.200
     8.812    21.426     0.200
     8.833    22.358     0.200
     8.867    21.730     0.200
     9.034    21.629     0.200
     9.243    21.710     0.200
     9.243    21.511     0.200
     9.241    20.653     0.200
     9.254    20.775     0.200
     9.287    20.181     0.200
     9.458    22.164     0.200
     9.481    22.835     0.200
     9.481    22.712     0.200
     9.588    24.802     0.200
     9.803    24.633     0.200
     9.853    23.338     0.200
     9.853    24.090     0.200
     9.965    23.366     0.200
    10.279    24.928     0.200
    10.384    23.575     0.200
    10.427    25.216     0.200
    10.932    24.466     0.200
    10.991    25.647     0.200
    11.032    22.856     0.200
    11.049    24.653     0.200
    11.675    27.520     0.200
    12.281    28.369     0.200
    12.572    27.388     0.200
    12.572    27.777     0.200
    12.583    26.286     0.200
    13.426    27.917     0.200
    13.972    33.793     0.200
    15.275    33.225     0.200
    15.392    34.014     0.200
    15.392    34.214     0.200
    16.019    31.320     0.200
    16.019    30.875     0.200
    17.066    33.417     0.200
    17.066    33.204     0.200
    18.679    35.509     0.200
    20.746    35.653     0.200
    20.757    35.533     0.200
     0.469     9.288     0.200
     0.567     8.653     0.200
     0.787     8.273     0.200
     0.796     8.406     0.200
     0.854     8.084     0.200
     0.904     8.409     0.200
     0.903     8.694     0.200
     0.906     8.792     0.200
     0.924     8.631     0.200
     0.925     8.690     0.200
     0.929     8.607     0.200
     1.035     7.731     0.200
     1.110     7.750     0.200
     1.214     8.637     0.200
     1.215     8.667     0.200
     1.388     7.485     0.200
     1.418     8.443     0.200
     1.438     8.377     0.200
     1.506     8.318     0.200
     1.671     8.483     0.200
     1.707     8.953     0.200
     1.734     9.149     0.200
     1.795     8.677     0.200
     1.978     8.435     0.200
     2.014     9.252     0.200
     2.058     9.451     0.200
     2.076     8.673     0.200
     2.068     9.498     0.200
     2.134     8.759     0.200
     2.125     9.480     0.200
     2.172     9.694     0.200
     2.192     9.694     0.200
     2.295     9.400     0.200
     2.334     9.449     0.200
     2.676     9.884     0.200
     2.837     9.291     0.200
     2.807     9.889     0.200
     2.846    10.683     0.200
     2.868    10.077     0.200
     2.875    11.039     0.200
     2.964    11.043     0.200
     2.975    10.689     0.200
     3.190    11.394     0.200
     3.278    11.619     0.200
     3.389    11.128     0.200
     3.385    11.361     0.200
     3.397    11.908     0.200
     3.679    12.045     0.200
     3.960    11.534     0.200
     3.960    11.956     0.200
     3.962    12.635     0.200
     4.056    11.491     0.200
     4.123    12.397     0.200
     4.128    12.117     0.200
     4.161    12.001     0.200
     4.268    11.339     0.200
     4.328    12.801     0.200
     4.377    12.408     0.200
     4.471    11.663     0.200
     4.481    13.726     0.200
     4.487    13.576     0.200
     4.509    13.435     0.200
     4.566    12.941     0.200
     4.572    12.874     0.200
     4.720    13.910     0.200
     4.718    12.955     0.200
     4.788    12.147     0.200
     4.739    13.201     0.200
     4.842    14.437     0.200
     4.953    13.715     0.200
     5.004    14.538     0.200
     5.004    14.702     0.200
     5.074    13.716     0.200
     5.106    13.839     0.200
     5.138    13.867     0.200
     5.166    14.058     0.200
     5.178    14.650     0.200
     5.202    14.194     0.200
     5.272    14.279     0.200
     5.276    14.733     0.200
     5.333    14.577     0.200
     5.398    14.394     0.200
     5.466    14.981     0.200
     5.522    15.261     0.200
     5.521    14.519     0.200
     5.632    14.950     0.200
     5.628    14.945     0.200
     5.665    15.987     0.200
     5.665    16.308     0.200
     5.678    15.110     0.200
     5.790    15.739     0.200
     5.788    15.591     0.200
     5.863    15.467     0.200
     5.895    15.602     0.200
     5.941    15.297     0.200
     6.004    16.306     0.200
     6.014    15.359     0.200
     6.055    16.250     0.200
     6.147    16.496     0.200
     6.338    16.794     0.200
     6.414    16.694     0.200
     6.432    16.763     0.200
     6.454    16.651     0.200
     6.541    15.439     0.200
     6.728    17.205     0.200
     6.748    16.828     0.200
     6.748    17.492     0.200
     6.780    16.891     0.200
     6.833    15.395     0.200
     6.882    17.668     0.200
     6.886    17.702     0.200
     7.009    17.265     0.200
     7.026    16.635     0.200
     7.141    16.724     0.200
     7.141    18.435     0.200
     7.166    18.026     0.200
     7.178    18.172     0.200
     7.268    18.554     0.200
     7.323    17.298     0.200
     7.383    19.027     0.200
     7.388    18.581     0.200
     7.388    19.042     0.200
     7.481    19.240     0.200
     7.549    18.055     0.200
     7.549    18.734     0.200
     7.624    17.791     0.200
     7.624    18.362     0.200
     7.669    19.067     0.200
     9.912    23.096     0.200
     9.979    24.962     0.200
    10.359    25.439     0.200
    12.590    30.157     0.200
     0.215     6.215     0.200
     0.529     4.901     0.200
     1.339     5.767     0.200
     1.262     7.519     0.200
     1.350     7.484     0.200
     1.771     7.805     0.200
     1.942     8.625     0.200
     2.024     8.474     0.200
     2.062     8.808     0.200
     2.319     8.316     0.200
     2.323     8.711     0.200
     2.399     7.431     0.200
     2.374     9.489     0.200
     2.708     9.587     0.200
     2.752    10.045     0.200
     2.776     9.750     0.200
     2.849     9.858     0.200
     2.883     9.680     0.200
     3.007     8.990     0.200
     3.133     9.708     0.200
     3.198    10.731     0.200
     3.301     9.847     0.200
     3.326    10.830     0.200
     3.563    11.281     0.200
     3.614    11.227     0.200
     3.640    11.239     0.200
     3.760    11.140     0.200
     4.175    12.570     0.200
     4.257    12.477     0.200
     4.370    11.646     0.200
     4.355    11.508     0.200
     4.508    11.278     0.200
     4.549    12.485     0.200
     4.676    12.642     0.200
     4.574    13.620     0.200
     4.721    13.591     0.200
     4.698    11.817     0.200
     4.788    12.321     0.200
     4.795    14.316     0.200
     4.889    14.804     0.200
     5.017    13.464     0.200
     5.012    13.805     0.200
     5.206    14.035     0.200
     5.316    15.114     0.200
     5.207    14.409     0.200
     5.377    14.149     0.200
     5.440    14.539     0.200
     5.529    14.533     0.200
     5.568    15.362     0.200
     5.575    14.775     0.200
     5.705    14.542     0.200
     5.793    15.784     0.200
     5.758    15.309     0.200
     5.681    16.118     0.200
     5.962    15.444     0.200
     5.988    15.960     0.200
     6.044    16.088     0.200
     6.053    14.934     0.200
     6.182    16.468     0.200
     6.247    16.921     0.200
     6.363    15.820     0.200
     6.498    17.296     0.200
     6.445    17.202     0.200
     6.473    17.650     0.200
     6.503    16.724     0.200
     6.676    17.553     0.200
     6.673    17.319     0.200
     6.779    18.098     0.200
     6.874    17.623     0.200
     6.847    18.526     0.200
     7.000    17.425     0.200
     6.956    18.587     0.200
     7.271    18.580     0.200
     7.238    18.840     0.200
     7.171    17.746     0.200
     7.229    18.692     0.200
     7.315    18.178     0.200
     7.381    17.742     0.200
     7.609    18.038     0.200
     7.683    19.282     0.200
     7.700    19.603     0.200
     7.654    19.070     0.200
     7.654    20.289     0.200
     7.649    18.216     0.200
     7.965    18.733     0.200
     8.252    20.490     0.200
     8.292    18.998     0.200
     8.301    21.566     0.200
     8.491    20.250     0.200
     9.372    22.350     0.200
     9.407    22.654     0.200
     9.729    24.553     0.200
     9.626    24.553     0.200
     9.881    23.424     0.200
    10.468    24.231     0.200
     0.459     5.503     0.200
     0.460     5.494     0.200
     0.570     5.488     0.200
     0.708     5.680     0.200
     0.752     5.877     0.200
     1.088     5.995     0.200
     1.078     6.655     0.200
     1.088     6.521     0.200
     1.089     6.695     0.200
     1.090     6.726     0.200
     1.090     6.729     0.200
     1.097     6.420     0.200
     1.107     6.778     0.200
     1.362     7.398     0.200
     1.433     7.078     0.200
     1.545     7.458     0.200
     1.543     7.724     0.200
     1.543     8.201     0.200
     1.583     6.676     0.200
     1.724     7.874     0.200
     1.801     8.177     0.200
     1.851     7.201     0.200
     1.843     7.333     0.200
     1.867     7.691     0.200
     1.922     7.771     0.200
     1.990     8.051     0.200
     2.014     8.128     0.200
     2.131     8.884     0.200
     2.175     8.347     0.200
     2.199     8.737     0.200
     2.271     9.035     0.200
     2.303     9.475     0.200
     2.308     9.123     0.200
     2.568     8.934     0.200
     2.585     8.503     0.200
     2.629     9.450     0.200
     2.656    10.055     0.200
     2.692     9.915     0.200
     2.768     8.753     0.200
     2.798     9.145     0.200
     2.798     9.567     0.200
     2.856     8.316     0.200
     2.926    10.020     0.200
     2.935    10.156     0.200
     3.011    10.859     0.200
     3.090    10.031     0.200
     3.261     9.887     0.200
     3.261    10.348     0.200
     3.267    10.847     0.200
     3.379    10.825     0.200
     3.379    11.028     0.200
     3.596    10.977     0.200
     3.656    11.738     0.200
     3.761    11.338     0.200
     3.770    11.482     0.200
     3.843    10.534     0.200
     3.884    11.321     0.200
     3.951    11.561     0.200
     3.977    11.493     0.200
     3.977    10.555     0.200
     4.000    12.223     0.200
     4.049    11.496     0.200
     4.146    10.024     0.200
     4.215    12.900     0.200
     4.236    12.307     0.200
     4.352    11.129     0.200
     4.554    12.957     0.200
     4.645    13.127     0.200
     4.633    13.377     0.200
     4.633    14.221     0.200
     4.805    13.464     0.200
     4.852    13.918     0.200
     4.873    13.570     0.200
     4.873    13.805     0.200
     4.937    13.574     0.200
     5.029    12.647     0.200
     5.032    13.880     0.200
     5.044    14.605     0.200
     5.046    13.530     0.200
     5.082    13.733     0.200
     5.101    13.866     0.200
     5.101    14.514     0.200
     5.127    14.413     0.200
     5.160    14.597     0.200
     5.341    14.003     0.200
     5.341    15.034     0.200
     5.382    14.789     0.200
     5.382    15.078     0.200
     5.372    15.180     0.200
     5.517    14.684     0.200
     5.540    14.922     0.200
     5.540    15.156     0.200
     5.564    15.550     0.200
     5.614    14.832     0.200
     5.635    14.585     0.200
     5.663    14.652     0.200
     5.804    15.787     0.200
     5.919    15.309     0.200
     5.906    15.431     0.200
     5.906    16.260     0.200
     5.924    14.896     0.200
     5.924    15.715     0.200
     5.994    15.356     0.200
     5.983    16.441     0.200
     6.007    16.347     0.200
     6.077    16.644     0.200
     6.137    16.189     0.200
     6.140    17.733     0.200
     6.238    16.548     0.200
     6.390    17.378     0.200
     6.446    17.903     0.200
     6.458    17.552     0.200
     6.508    17.140     0.200
     6.617    16.863     0.200
     6.753    17.689     0.200
     6.791    16.977     0.200
     6.806    17.663     0.200
     6.843    16.920     0.200
     6.844    17.207     0.200
     6.870    17.834     0.200
     6.914    17.334     0.200
     6.925    16.953     0.200
     7.063    17.264     0.200
     7.093    18.027     0.200
     7.091    17.023     0.200
     7.125    17.659     0.200
     7.125    17.542     0.200
     7.125    17.386     0.200
     7.180    18.166     0.200
     7.281    17.974     0.200
     7.299    18.007     0.200
     7.318    19.165     0.200
     7.339    16.418     0.200
     7.698    19.656     0.200
     7.729    18.883     0.200
     7.809    20.955     0.200
     7.941    19.170     0.200
     8.231    19.997     0.200
     8.281    20.514     0.200
     9.056    21.345     0.200
     9.091    22.468     0.200
     9.235    22.971     0.200
     9.529    22.729     0.200
     9.537    23.030     0.200
     9.909    24.059     0.200
     9.931    22.797     0.200
    12.067    29.120     0.200
    12.067    28.581     0.200
     0.543     6.246     0.200
     0.638     5.632     0.200
     0.831     7.172     0.200
     0.860     7.053     0.200
     0.935     6.554     0.200
     1.002     6.815     0.200
     1.003     6.800     0.200
     1.096     7.170     0.200
     1.105     6.804     0.200
     1.290     6.822     0.200
     1.320     6.091     0.200
     1.441     7.177     0.200
     1.497     7.143     0.200
     1.512     7.113     0.200
     1.526     8.010     0.200
     1.532     8.050     0.200
     1.534     8.085     0.200
     1.539     8.050     0.200
     1.543     7.947     0.200
     1.552     7.959     0.200
     1.780     7.566     0.200
     1.825     7.583     0.200
     2.022     8.211     0.200
     2.091     8.985     0.200
     2.094     8.687     0.200
     2.166     8.470     0.200
     2.191     8.598     0.200
     2.207     8.396     0.200
     2.274     9.284     0.200
     2.307     7.215     0.200
     2.307     9.261     0.200
     2.392     8.689     0.200
     2.414     9.069     0.200
     2.605     9.229     0.200
     2.625     9.445     0.200
     2.663     9.276     0.200
     2.662     9.409     0.200
     2.669     9.898     0.200
     2.688     9.708     0.200
     2.755     9.846     0.200
     2.793    10.144     0.200
     2.803    10.003     0.200
     2.935     9.830     0.200
     3.021    10.534     0.200
     3.086    10.366     0.200
     3.126     9.442     0.200
     3.192     9.872     0.200
     3.196    11.312     0.200
     3.317    11.123     0.200
     3.425    10.860     0.200
     3.446    11.329     0.200
     3.447    11.070     0.200
     3.448    11.056     0.200
     3.488    11.494     0.200
     3.490    11.186     0.200
     3.518    11.724     0.200
     3.557    11.410     0.200
     3.755    12.036     0.200
     3.781    11.944     0.200
     3.810    11.414     0.200
     3.915    11.974     0.200
     4.066    12.328     0.200
     4.100    12.265     0.200
     4.109    11.162     0.200
     4.114    11.137     0.200
     4.285    12.481     0.200
     4.392    11.908     0.200
     4.405    13.028     0.200
     4.434    12.160     0.200
     4.466    12.611     0.200
     4.513    11.858     0.200
     4.597    12.833     0.200
     4.660    13.184     0.200
     4.672    12.159     0.200
     4.786    13.090     0.200
     4.812    13.051     0.200
     4.864    13.478     0.200
     4.950    13.696     0.200
     5.103    13.911     0.200
     5.125    14.677     0.200
     5.175    14.179     0.200
     5.227    14.752     0.200
     5.249    14.556     0.200
     5.344    14.361     0.200
     5.522    14.706     0.200
     5.538    14.917     0.200
     5.544    14.993     0.200
     5.553    14.722     0.200
     5.562    14.746     0.200
     5.581    14.595     0.200
     5.651    14.789     0.200
     5.674    15.368     0.200
     5.839    15.458     0.200
     5.863    15.887     0.200
     5.914    15.871     0.200
     5.930    15.299     0.200
     6.033    15.864     0.200
     6.088    15.402     0.200
     6.102    16.150     0.200
     6.116    15.879     0.200
     6.121    15.926     0.200
     6.136    16.134     0.200
     6.177    16.362     0.200
     6.241    16.441     0.200
     6.368    16.958     0.200
     6.408    16.808     0.200
     6.457    16.922     0.200
     6.485    16.934     0.200
     6.520    17.160     0.200
     6.532    16.793     0.200
     6.571    16.927     0.200
     6.583    17.203     0.200
     6.607    16.935     0.200
     6.723    17.377     0.200
     6.829    17.838     0.200
     6.886    17.419     0.200
     6.916    17.533     0.200
     6.995    17.350     0.200
     6.999    17.310     0.200
     7.097    18.847     0.200
     7.101    17.004     0.200
     7.167    17.227     0.200
     7.257    18.457     0.200
     7.257    18.459     0.200
     7.347    17.679     0.200
     7.378    17.280     0.200
     7.477    18.202     0.200
     7.535    18.393     0.200
     7.546    20.045     0.200
     7.609    17.943     0.200
     7.609    18.450     0.200
     7.666    18.425     0.200
     7.730    18.368     0.200
     7.839    18.903     0.200
     7.858    18.541     0.200
     7.865    18.940     0.200
     8.177    19.514     0.200
     8.241    19.103     0.200
     8.289    18.679     0.200
     0.564     5.622     0.200
     0.823     4.809     0.200
     1.214     6.477     0.200
     1.220     6.433     0.200
     1.230     6.727     0.200
     1.406     7.015     0.200
     1.421     7.052     0.200
     1.812     6.286     0.200
     1.846     7.652     0.200
     1.859     7.656     0.200
     2.239     7.742     0.200
     2.470     9.307     0.200
     2.510     9.387     0.200
     2.511     9.372     0.200
     2.677     9.254     0.200
     2.791     9.323     0.200
     2.852     9.346     0.200
     3.058     8.262     0.200
     3.064     8.192     0.200
     3.224     9.413     0.200
     3.225    11.391     0.200
     3.255     9.993     0.200
     3.329     9.982     0.200
     3.365    10.210     0.200
     3.553    11.438     0.200
     3.603    11.613     0.200
     3.737    12.544     0.200
     3.901    11.616     0.200
     3.945    11.081     0.200
     3.923    11.879     0.200
     4.027    12.770     0.200
     4.071    12.487     0.200
     4.082    13.253     0.200
     4.138    13.416     0.200
     4.205    13.415     0.200
     4.233    13.143     0.200
     4.236    13.082     0.200
     4.630    12.483     0.200
     4.698    12.954     0.200
     4.867    14.440     0.200
     5.202    15.137     0.200
     5.312    14.420     0.200
     5.384    14.593     0.200
     5.395    16.129     0.200
     5.561    14.374     0.200
     5.593    16.266     0.200
     5.705    15.888     0.200
     5.931    15.165     0.200
     6.009    14.645     0.200
     6.097    15.530     0.200
     6.155    14.623     0.200
     6.307    15.679     0.200
     6.324    16.063     0.200
     6.587    16.946     0.200
     6.612    16.887     0.200
     6.687    16.523     0.200
     6.765    16.955     0.200
     6.794    18.205     0.200
     6.843    16.814     0.200
     6.843    17.252     0.200
     6.940    17.079     0.200
     7.017    17.799     0.200
     7.025    17.412     0.200
     7.115    17.426     0.200
     7.182    18.742     0.200
     7.402    19.142     0.200
     7.531    18.913     0.200
     7.610    18.731     0.200
     7.611    20.424     0.200
     7.986    19.657     0.200
     8.129    19.640     0.200
     8.293    20.182     0.200
     8.489    21.663     0.200
     8.837    19.889     0.200
     8.853    21.084     0.200
     9.023    20.762     0.200
     9.037    20.640     0.200
     9.137    22.158     0.200
     9.137    20.396     0.200
     9.153    22.787     0.200
     9.338    22.912     0.200
     9.357    21.846     0.200
     0.289     7.652     0.200
     0.446     7.035     0.200
     0.446     7.217     0.200
     0.480     6.990     0.200
     0.660     7.052     0.200
     0.762     6.250     0.200
     0.788     6.856     0.200
     0.804     6.591     0.200
     0.803     6.428     0.200
     0.863     6.482     0.200
     0.863     6.787     0.200
     1.044     6.520     0.200
     1.246     7.374     0.200
     1.246     7.011     0.200
     1.272     6.794     0.200
     1.343     6.897     0.200
     1.502     7.077     0.200
     1.494     7.954     0.200
     1.496     7.955     0.200
     1.558     7.121     0.200
     1.590     7.529     0.200
     1.678     8.656     0.200
     1.678     8.718     0.200
     1.680     8.701     0.200
     1.988     9.053     0.200
     2.017     8.241     0.200
     2.040     8.605     0.200
     2.040     8.398     0.200
     2.082     7.777     0.200
     2.082     7.613     0.200
     2.149     9.130     0.200
     2.258     8.527     0.200
     2.309     9.542     0.200
     2.364     8.992     0.200
     2.365     9.482     0.200
     2.439     8.841     0.200
     2.456    10.220     0.200
     2.456    10.118     0.200
     2.501     9.200     0.200
     2.510    10.124     0.200
     2.516     9.789     0.200
     2.783    10.479     0.200
     2.807     9.964     0.200
     2.827    10.784     0.200
     2.834    10.605     0.200
     2.852     9.665     0.200
     2.880    10.566     0.200
     2.888     9.899     0.200
     2.887    10.768     0.200
     2.937    10.946     0.200
     2.960    10.942     0.200
     2.975    10.634     0.200
     3.277    10.636     0.200
     3.321    11.077     0.200
     3.565    11.442     0.200
     3.586    11.798     0.200
     3.614    12.727     0.200
     3.614    12.317     0.200
     3.621    12.874     0.200
     3.626    12.058     0.200
     3.733    12.454     0.200
     3.960    12.652     0.200
     4.005    12.280     0.200
     4.032    11.605     0.200
     4.070    12.463     0.200
     4.132    13.542     0.200
     4.132    13.390     0.200
     4.157    12.954     0.200
     4.157    12.637     0.200
     4.172    12.862     0.200
     4.172    12.972     0.200
     4.343    13.148     0.200
     4.408    12.269     0.200
     4.486    12.518     0.200
     4.525    13.422     0.200
     4.525    13.757     0.200
     4.577    13.788     0.200
     4.642    13.270     0.200
     4.665    14.219     0.200
     4.703    12.617     0.200
     4.708    12.560     0.200
     4.730    13.722     0.200
     4.730    13.066     0.200
     4.816    12.942     0.200
     4.932    14.456     0.200
     4.985    12.877     0.200
     4.985    13.502     0.200
     4.990    13.642     0.200
     5.105    14.407     0.200
     5.103    14.804     0.200
     5.128    14.299     0.200
     5.144    14.593     0.200
     5.144    14.382     0.200
     5.171    12.441     0.200
     5.227    14.868     0.200
     5.227    14.493     0.200
     5.333    14.832     0.200
     5.333    14.941     0.200
     5.392    14.206     0.200
     5.392    14.050     0.200
     5.497    14.864     0.200
     5.536    15.412     0.200
     5.536    15.201     0.200
     5.663    15.299     0.200
     5.746    15.609     0.200
     5.785    15.570     0.200
     5.785    15.406     0.200
     5.803    15.515     0.200
     5.810    15.231     0.200
     5.813    15.115     0.200
     5.863    15.156     0.200
     5.883    15.398     0.200
     5.883    15.531     0.200
     5.911    15.400     0.200
     5.988    15.547     0.200
     6.031    16.038     0.200
     6.043    16.093     0.200
     6.043    15.991     0.200
     6.082    15.203     0.200
     6.082    15.879     0.200
     6.085    16.206     0.200
     6.085    16.405     0.200
     6.093    15.907     0.200
     6.134    16.434     0.200
     6.173    16.612     0.200
     6.268    15.821     0.200
     6.355    16.734     0.200
     6.386    16.633     0.200
     6.395    16.399     0.200
     6.403    16.566     0.200
     6.403    16.265     0.200
     6.414    16.739     0.200
     6.497    16.347     0.200
     6.541    16.043     0.200
     6.541    16.226     0.200
     6.564    15.856     0.200
     6.564    17.184     0.200
     6.616    16.954     0.200
     6.645    17.209     0.200
     6.645    16.803     0.200
     6.641    16.101     0.200
     6.654    16.649     0.200
     6.674    16.688     0.200
     6.687    16.741     0.200
     6.844    17.463     0.200
     6.911    17.521     0.200
     6.911    18.119     0.200
     6.954    17.219     0.200
     6.975    17.588     0.200
     6.988    18.049     0.200
     7.046    18.099     0.200
     7.060    18.119     0.200
     7.071    18.045     0.200
     7.120    17.517     0.200
     7.190    18.105     0.200
     7.289    18.471     0.200
     7.308    17.542     0.200
     7.393    17.624     0.200
     7.423    18.770     0.200
     7.423    18.657     0.200
     7.438    18.725     0.200
     7.458    19.393     0.200
     7.463    17.728     0.200
     7.463    17.904     0.200
     7.477    18.353     0.200
     7.499    18.749     0.200
     7.554    18.617     0.200
     7.557    18.961     0.200
     7.598    18.758     0.200
     7.606    17.507     0.200
     7.606    19.054     0.200
     7.657    19.292     0.200
     7.657    19.526     0.200
     7.668    18.784     0.200
     7.683    20.069     0.200
     7.697    18.849     0.200
     7.697    18.486     0.200
     7.770    18.718     0.200
     7.794    18.740     0.200
     7.794    18.927     0.200
     7.796    18.594     0.200
     7.796    18.867     0.200
     7.796    18.329     0.200
     7.840    19.908     0.200
     7.857    19.042     0.200
     7.857    19.010     0.200
     7.891    20.016     0.200
     7.891    19.910     0.200
     7.884    19.242     0.200
     7.917    19.120     0.200
     7.917    18.389     0.200
     7.917    17.671     0.200
     8.037    20.359     0.200
     8.037    20.203     0.200
     8.092    19.917     0.200
     8.096    19.475     0.200
     8.142    19.935     0.200
     8.164    19.514     0.200
     8.164    19.744     0.200
     8.176    19.475     0.200
     8.176    20.135     0.200
     8.232    19.360     0.200
     8.232    19.723     0.200
     8.225    19.880     0.200
     8.225    19.638     0.200
     8.234    20.220     0.200
     8.270    20.207     0.200
     8.270    19.379     0.200
     8.289    20.365     0.200
     8.289    20.494     0.200
     8.378    19.258     0.200
     8.378    19.684     0.200
     8.595    20.340     0.200
     8.595    20.816     0.200
     8.653    20.253     0.200
     8.653    20.038     0.200
     8.717    21.156     0.200
     8.717    20.921     0.200
     8.720    21.430     0.200
     8.720    20.719     0.200
     8.755    21.113     0.200
     8.860    19.972     0.200
     8.860    20.492     0.200
     8.914    22.485     0.200
     8.947    20.921     0.200
     9.164    21.296     0.200
     9.164    21.398     0.200
     9.305    22.388     0.200
     9.305    21.978     0.200
     9.357    22.301     0.200
     9.357    21.957     0.200
     9.425    21.711     0.200
     9.430    21.948     0.200
     9.495    22.384     0.200
     9.508    20.775     0.200
     9.508    20.384     0.200
     9.645    22.335     0.200
     9.668    22.248     0.200
     9.734    22.778     0.200
     9.734    22.926     0.200
     9.767    22.829     0.200
     9.767    22.400     0.200
     9.809    22.337     0.200
     9.810    21.833     0.200
     9.963    23.000     0.200
    10.007    22.816     0.200
    10.203    23.458     0.200
    10.203    23.145     0.200
    10.443    23.540     0.200
    10.445    23.020     0.200
    10.628    22.820     0.200
    10.628    22.121     0.200
    10.650    23.428     0.200
    10.650    22.975     0.200
    10.670    23.365     0.200
    10.684    22.673     0.200
    10.713    23.762     0.200
    10.844    23.602     0.200
    11.113    23.891     0.200
    14.145    32.837     0.200
     0.265     8.814     0.200
     0.289     8.642     0.200
     0.449     7.828     0.200
     0.618     7.126     0.200
     1.005     6.967     0.200
     0.992     7.418     0.200
     1.153     6.892     0.200
     1.193     7.020     0.200
     1.198     7.381     0.200
     1.330     8.099     0.200
     1.396     7.406     0.200
     1.596     7.341     0.200
     1.615     7.213     0.200
     1.932     8.148     0.200
     2.057     8.232     0.200
     2.041     8.786     0.200
     2.098     9.208     0.200
     2.163     8.129     0.200
     2.204     8.917     0.200
     2.248     9.581     0.200
     2.284     8.590     0.200
     2.302     9.235     0.200
     2.515     9.959     0.200
     2.553     9.982     0.200
     2.559    10.079     0.200
     2.565    10.057     0.200
     2.588     9.140     0.200
     2.617    10.191     0.200
     2.633     9.473     0.200
     2.641     9.207     0.200
     2.707     8.975     0.200
     2.691    10.266     0.200
     2.703    10.225     0.200
     3.015    10.165     0.200
     3.136    10.665     0.200
     3.224    11.321     0.200
     3.316    11.719     0.200
     3.330    10.926     0.200
     3.358    11.470     0.200
     3.374    10.144     0.200
     3.691    12.344     0.200
     3.798    11.560     0.200
     3.858    12.973     0.200
     3.913    11.896     0.200
     4.073    12.596     0.200
     4.208    12.586     0.200
     4.265    11.473     0.200
     4.228    12.108     0.200
     4.265    11.833     0.200
     4.564    12.605     0.200
     4.579    13.223     0.200
     4.688    13.552     0.200
     4.684    12.937     0.200
     4.776    12.145     0.200
     4.803    13.197     0.200
     4.838    13.880     0.200
     4.865    15.006     0.200
     4.901    12.809     0.200
     4.954    15.598     0.200
     4.971    12.399     0.200
     5.075    13.575     0.200
     5.206    13.411     0.200
     5.263    14.877     0.200
     5.262    13.898     0.200
     5.550    14.208     0.200
     5.587    15.219     0.200
     5.631    15.727     0.200
     5.684    14.774     0.200
     5.819    15.545     0.200
     5.891    14.712     0.200
     5.930    15.153     0.200
     5.978    16.112     0.200
     6.033    16.612     0.200
     6.083    17.084     0.200
     6.101    15.386     0.200
     6.150    15.035     0.200
     6.186    16.019     0.200
     6.253    15.898     0.200
     6.267    16.360     0.200
     6.331    15.784     0.200
     6.442    16.097     0.200
     6.460    16.703     0.200
     6.478    16.178     0.200
     6.508    16.366     0.200
     6.522    16.391     0.200
     6.670    17.523     0.200
     6.682    17.221     0.200
     6.808    17.649     0.200
     6.894    17.846     0.200
     6.935    17.890     0.200
     7.033    18.204     0.200
     7.126    16.028     0.200
     7.189    17.911     0.200
     7.340    16.553     0.200
     7.341    18.912     0.200
     7.384    18.846     0.200
     7.410    18.269     0.200
     7.459    18.482     0.200
     7.500    18.815     0.200
     7.527    17.951     0.200
     7.617    18.881     0.200
     7.653    18.626     0.200
     7.653    18.204     0.200
     7.675    19.267     0.200
     7.712    20.192     0.200
     7.847    18.450     0.200
     7.873    19.891     0.200
     7.879    20.010     0.200
     7.907    19.238     0.200
     8.003    19.332     0.200
     8.044    20.420     0.200
     8.049    19.729     0.200
     8.067    19.670     0.200
     8.067    19.624     0.200
     8.095    19.280     0.200
     8.105    18.875     0.200
     8.346    19.739     0.200
     8.383    18.519     0.200
     9.050    21.131     0.200
     9.175    21.549     0.200
     9.371    21.547     0.200
     0.423     6.358     0.200
     0.490     6.233     0.200
     0.592     6.172     0.200
     0.603     6.379     0.200
     0.612     6.500     0.200
     0.614     6.255     0.200
     0.626     6.068     0.200
     0.723     6.803     0.200
     0.833     6.589     0.200
     0.877     6.038     0.200
     0.921     6.275     0.200
     0.911     6.345     0.200
     0.996     6.353     0.200
     1.053     6.572     0.200
     1.233     6.498     0.200
     1.233     6.319     0.200
     1.253     6.994     0.200
     1.437     6.578     0.200
     1.418     7.553     0.200
     1.639     6.875     0.200
     1.698     8.228     0.200
     1.719     8.017     0.200
     1.738     7.469     0.200
     2.043     7.116     0.200
     2.007     8.927     0.200
     2.006     8.705     0.200
     2.154     8.380     0.200
     2.115     8.333     0.200
     2.115     8.161     0.200
     2.208     8.261     0.200
     2.248     8.454     0.200
     2.334     9.084     0.200
     2.387     9.371     0.200
     2.405     8.465     0.200
     2.423     9.139     0.200
     2.432     9.102     0.200
     2.467     9.278     0.200
     2.577     8.665     0.200
     2.521    10.125     0.200
     2.600     8.777     0.200
     2.762     9.082     0.200
     2.800     9.459     0.200
     2.808    10.863     0.200
     2.846    10.777     0.200
     2.852    11.241     0.200
     2.862    10.728     0.200
     2.966     9.945     0.200
     2.919    10.709     0.200
     2.966    11.076     0.200
     2.986    10.955     0.200
     2.996    10.169     0.200
     2.996     9.982     0.200
     3.050    10.108     0.200
     3.050    10.705     0.200
     3.376    10.738     0.200
     3.474    11.056     0.200
     3.528    10.242     0.200
     3.534    11.013     0.200
     3.648    11.793     0.200
     3.682    12.161     0.200
     3.726    12.380     0.200
     3.983    12.804     0.200
     4.072    10.431     0.200
     4.080    11.209     0.200
     4.082    11.439     0.200
     4.082    11.568     0.200
     4.135    12.112     0.200
     4.145    12.356     0.200
     4.184    13.000     0.200
     4.184    13.614     0.200
     4.327    12.277     0.200
     4.426    13.192     0.200
     4.426    13.399     0.200
     4.628    13.195     0.200
     4.577    13.416     0.200
     4.604    12.821     0.200
     4.733    14.034     0.200
     4.785    13.407     0.200
     4.785    12.904     0.200
     4.913    13.184     0.200
     4.915    12.710     0.200
     4.926    12.298     0.200
     5.121    13.629     0.200
     5.202    14.688     0.200
     5.225    15.333     0.200
     5.226    13.195     0.200
     5.315    13.550     0.200
     5.463    14.372     0.200
     5.608    15.325     0.200
     5.608    15.427     0.200
     5.686    14.866     0.200
     5.686    15.057     0.200
     5.726    14.691     0.200
     5.749    14.818     0.200
     5.794    16.296     0.200
     5.812    15.376     0.200
     5.882    15.388     0.200
     5.897    15.271     0.200
     5.897    15.184     0.200
     5.999    15.550     0.200
     6.008    15.221     0.200
     6.047    16.368     0.200
     6.047    15.977     0.200
     6.066    16.696     0.200
     6.177    15.596     0.200
     6.307    16.554     0.200
     6.334    16.172     0.200
     6.394    15.161     0.200
     6.405    16.130     0.200
     6.429    16.711     0.200
     6.429    16.539     0.200
     6.568    17.266     0.200
     6.572    17.129     0.200
     6.581    16.869     0.200
     6.593    16.557     0.200
     6.709    16.836     0.200
     6.749    17.182     0.200
     6.883    17.576     0.200
     6.878    16.882     0.200
     6.883    17.470     0.200
     6.945    18.191     0.200
     7.034    17.956     0.200
     7.092    18.377     0.200
     7.197    18.365     0.200
     7.401    18.682     0.200
     7.408    16.543     0.200
     7.469    19.046     0.200
     7.508    17.394     0.200
     7.534    18.451     0.200
     7.577    19.101     0.200
     7.603    18.381     0.200
     7.622    18.081     0.200
     7.637    17.868     0.200
     7.642    18.505     0.200
     7.797    19.033     0.200
     7.751    19.772     0.200
     7.803    19.553     0.200
     7.819    18.348     0.200
     7.926    18.417     0.200
     7.926    19.968     0.200
     7.942    19.883     0.200
     7.956    20.127     0.200
     7.956    19.443     0.200
     8.033    19.828     0.200
     8.070    21.234     0.200
     8.111    19.519     0.200
     8.161    19.196     0.200
     8.221    20.077     0.200
     8.239    20.385     0.200
     8.249    19.770     0.200
     8.249    20.660     0.200
     8.418    19.355     0.200
     8.578    21.747     0.200
     8.578    20.406     0.200
     8.868    21.390     0.200
     9.234    22.044     0.200
     9.295    22.963     0.200
     9.689    23.988     0.200
     9.826    23.965     0.200
    10.704    23.316     0.200
    11.487    26.857     0.200
    14.129    31.958     0.200
    14.277    30.647     0.200
     1.315     7.634     0.200
     1.344     8.288     0.200
     1.492     6.538     0.200
     1.438     8.020     0.200
     1.470     7.646     0.200
     1.456     7.771     0.200
     1.466     8.608     0.200
     1.483     9.414     0.200
     1.483     8.755     0.200
     1.493     8.804     0.200
     1.565     8.719     0.200
     1.631     8.953     0.200
     1.631     8.762     0.200
     1.890     8.932     0.200
     1.847     9.345     0.200
     1.870     9.456     0.200
     1.925     8.773     0.200
     1.914     9.297     0.200
     1.888     9.618     0.200
     1.887     8.982     0.200
     2.046     9.143     0.200
     2.213     9.388     0.200
     2.274     9.015     0.200
     2.252     9.839     0.200
     2.253     9.286     0.200
     2.331     9.154     0.200
     2.290     9.548     0.200
     2.366     9.592     0.200
     2.374     9.868     0.200
     2.382    10.034     0.200
     2.398     9.605     0.200
     2.456    10.926     0.200
     2.488    10.104     0.200
     2.736    10.487     0.200
     2.760    10.761     0.200
     2.902    10.535     0.200
     2.885    11.555     0.200
     2.987    10.552     0.200
     2.920    11.164     0.200
     2.945    11.046     0.200
     2.993    11.404     0.200
     3.121    11.932     0.200
     3.263    11.289     0.200
     3.375    10.594     0.200
     3.284    11.444     0.200
     3.439    11.292     0.200
     3.498    10.685     0.200
     3.492    11.831     0.200
     3.672    12.600     0.200
     3.686    12.331     0.200
     3.821    12.647     0.200
     3.940    13.164     0.200
     3.888    13.231     0.200
     4.072    13.377     0.200
     4.213    13.519     0.200
     4.356    13.251     0.200
     4.232    13.906     0.200
     4.607    14.576     0.200
     4.750    14.022     0.200
     4.944    14.040     0.200
     5.100    15.254     0.200
     5.115    15.257     0.200
     5.164    15.795     0.200
     5.355    15.746     0.200
     5.358    15.770     0.200
     6.471    17.989     0.200
     6.820    19.147     0.200
     6.828    18.351     0.200
     6.940    18.478     0.200
     0.580     6.598     0.200
     0.624     6.418     0.200
     0.690     5.957     0.200
     0.758     6.106     0.200
     0.758     6.407     0.200
     0.851     6.280     0.200
     0.867     6.168     0.200
     0.930     6.659     0.200
     1.009     6.782     0.200
     1.011     6.768     0.200
     1.047     6.393     0.200
     1.372     7.870     0.200
     1.365     7.110     0.200
     1.377     7.938     0.200
     1.378     7.972     0.200
     1.393     7.763     0.200
     1.397     7.881     0.200
     1.442     7.103     0.200
     1.464     6.923     0.200
     1.539     6.979     0.200
     1.581     7.199     0.200
     1.684     8.317     0.200
     1.684     8.338     0.200
     1.767     7.846     0.200
     1.960     7.956     0.200
     2.017     8.609     0.200
     2.035     9.130     0.200
     2.065     8.790     0.200
     2.068     8.540     0.200
     2.182     9.523     0.200
     2.197     8.673     0.200
     2.364     8.472     0.200
     2.359     8.976     0.200
     2.384     8.263     0.200
     2.399     8.679     0.200
     2.409     8.772     0.200
     2.485     9.698     0.200
     2.545     9.907     0.200
     2.607    10.198     0.200
     2.650    10.333     0.200
     2.664    10.310     0.200
     2.682     9.490     0.200
     2.822    10.218     0.200
     2.856     9.960     0.200
     2.983     9.918     0.200
     3.107    12.119     0.200
     3.124     9.214     0.200
     3.145     9.870     0.200
     3.205    10.587     0.200
     3.286    10.330     0.200
     3.314    11.226     0.200
     3.315    11.211     0.200
     3.422    11.965     0.200
     3.500    11.689     0.200
     3.654    12.080     0.200
     3.752    11.496     0.200
     3.819    11.987     0.200
     3.902    12.767     0.200
     3.902    13.021     0.200
     3.909    12.210     0.200
     3.920    11.225     0.200
     4.039    11.254     0.200
     4.158    12.375     0.200
     4.202    11.719     0.200
     4.207    11.843     0.200
     4.207    12.919     0.200
     4.214    12.902     0.200
     4.332    11.894     0.200
     4.395    11.951     0.200
     4.480    13.704     0.200
     4.483    11.561     0.200
     4.488    13.108     0.200
     4.506    12.519     0.200
     4.522    11.506     0.200
     4.536    12.539     0.200
     4.697    11.625     0.200
     4.736    12.958     0.200
     4.736    12.818     0.200
     4.769    13.589     0.200
     4.821    12.353     0.200
     4.908    12.912     0.200
     4.912    13.493     0.200
     4.975    15.816     0.200
     5.016    14.343     0.200
     5.038    14.725     0.200
     5.070    13.871     0.200
     5.070    13.758     0.200
     5.193    13.685     0.200
     5.286    14.572     0.200
     5.320    14.244     0.200
     5.346    14.228     0.200
     5.346    13.998     0.200
     5.362    15.110     0.200
     5.374    14.452     0.200
     5.451    14.893     0.200
     5.493    14.782     0.200
     5.500    15.235     0.200
     5.500    15.633     0.200
     5.517    14.731     0.200
     5.519    14.407     0.200
     5.596    14.775     0.200
     5.601    14.311     0.200
     5.635    15.098     0.200
     5.651    15.288     0.200
     5.741    15.241     0.200
     5.750    15.772     0.200
     5.773    15.281     0.200
     5.917    15.784     0.200
     5.929    15.068     0.200
     5.929    14.868     0.200
     5.956    15.499     0.200
     6.002    15.375     0.200
     6.020    15.689     0.200
     6.020    15.525     0.200
     6.117    16.039     0.200
     6.166    15.751     0.200
     6.185    16.558     0.200
     6.185    16.925     0.200
     6.190    16.183     0.200
     6.207    16.802     0.200
     6.234    16.527     0.200
     6.272    16.363     0.200
     6.304    16.209     0.200
     6.346    16.692     0.200
     6.473    17.471     0.200
     6.479    16.911     0.200
     6.494    16.113     0.200
     6.494    17.012     0.200
     6.546    16.903     0.200
     6.546    17.417     0.200
     6.562    17.173     0.200
     6.633    16.650     0.200
     6.691    17.659     0.200
     6.926    18.122     0.200
     7.000    18.112     0.200
     7.000    18.283     0.200
     7.003    17.090     0.200
     7.034    19.015     0.200
     7.057    17.727     0.200
     7.061    18.274     0.200
     7.064    18.118     0.200
     7.063    17.268     0.200
     7.104    18.617     0.200
     7.173    18.187     0.200
     7.244    19.149     0.200
     7.245    18.596     0.200
     7.253    19.099     0.200
     7.276    17.436     0.200
     7.355    19.167     0.200
     7.355    18.601     0.200
     7.469    18.035     0.200
     7.472    18.009     0.200
     7.481    17.799     0.200
     7.540    19.392     0.200
     7.573    17.293     0.200
     7.573    17.000     0.200
     7.573    19.074     0.200
     7.588    19.400     0.200
     7.640    18.729     0.200
     7.690    19.521     0.200
     7.723    18.651     0.200
     7.750    20.177     0.200
     7.792    18.544     0.200
     7.819    19.170     0.200
     7.837    19.511     0.200
     7.837    19.343     0.200
     8.000    20.686     0.200
     8.106    19.336     0.200
     8.196    19.928     0.200
     8.196    19.358     0.200
     8.218    20.776     0.200
     8.329    20.632     0.200
     8.350    21.213     0.200
     8.421    22.193     0.200
     8.512    20.603     0.200
     8.558    20.775     0.200
     8.561    22.580     0.200
     8.801    19.817     0.200
     8.834    22.420     0.200
     8.877    22.257     0.200
     8.920    22.463     0.200
     8.993    22.236     0.200
     9.126    22.449     0.200
     9.289    22.924     0.200
     9.506    22.704     0.200
     9.646    22.495     0.200
     9.778    24.372     0.200
     9.791    23.717     0.200
    10.080    24.388     0.200
    10.362    24.232     0.200
    11.065    25.776     0.200
    11.082    26.432     0.200
    12.591    28.593     0.200
    12.591    29.273     0.200
     0.822     6.420     0.200
     1.424     8.324     0.200
     1.424     7.825     0.200
     1.424     8.477     0.200
     1.979     8.989     0.200
     2.111     9.437     0.200
     2.135     9.084     0.200
     2.148     9.617     0.200
     2.164     9.836     0.200
     2.181     9.672     0.200
     2.255    10.478     0.200
     2.256    10.549     0.200
     2.283    10.633     0.200
     2.363    10.360     0.200
     2.451    10.633     0.200
     2.459    10.166     0.200
     2.543    11.186     0.200
     2.543    11.478     0.200
     2.660     9.656     0.200
     2.900     8.980     0.200
     2.900     9.169     0.200
     2.941    10.465     0.200
     2.941    11.306     0.200
     2.962    12.880     0.200
     2.970    12.633     0.200
     3.185    11.841     0.200
     3.258    12.630     0.200
     3.258    13.260     0.200
     3.290    11.693     0.200
     3.302    12.336     0.200
     3.368    12.837     0.200
     3.368    13.258     0.200
     3.534    11.343     0.200
     3.533    11.340     0.200
     3.590    12.816     0.200
     3.588    12.519     0.200
     3.575    12.876     0.200
     3.625    13.537     0.200
     3.677    12.149     0.200
     3.701    14.197     0.200
     3.947    10.601     0.200
     3.952    10.644     0.200
     3.959    12.883     0.200
     4.034    14.200     0.200
     4.122    12.973     0.200
     4.122    12.848     0.200
     4.101    14.582     0.200
     4.173    14.944     0.200
     4.229    11.990     0.200
     4.229    12.150     0.200
     4.205    14.727     0.200
     4.210    14.305     0.200
     4.208    13.288     0.200
     4.208    12.926     0.200
     4.473    14.845     0.200
     4.473    15.054     0.200
     4.480    13.906     0.200
     4.513    14.584     0.200
     4.513    14.709     0.200
     4.830    15.078     0.200
     4.839    15.401     0.200
     4.840    15.402     0.200
     4.840    15.027     0.200
     4.867    15.604     0.200
     4.908    16.558     0.200
     5.019    15.452     0.200
     5.019    15.552     0.200
     5.034    15.451     0.200
     5.034    15.242     0.200
     5.141    15.111     0.200
     5.233    15.066     0.200
     5.496    17.005     0.200
     5.496    17.285     0.200
     5.506    15.413     0.200
     5.551    17.056     0.200
     5.551    17.275     0.200
     5.593    16.120     0.200
     5.596    16.713     0.200
     5.600    15.135     0.200
     5.613    16.038     0.200
     5.660    17.202     0.200
     5.707    16.410     0.200
     5.707    16.533     0.200
     5.818    16.811     0.200
     5.840    17.370     0.200
     5.840    16.738     0.200
     5.857    18.061     0.200
     5.857    17.907     0.200
     5.972    17.555     0.200
     5.972    17.002     0.200
     6.004    16.975     0.200
     6.104    18.518     0.200
     6.096    17.558     0.200
     6.193    15.854     0.200
     6.194    15.789     0.200
     6.138    17.522     0.200
     6.189    18.357     0.200
     6.200    17.409     0.200
     6.228    18.129     0.200
     6.342    17.786     0.200
     6.342    18.041     0.200
     6.397    17.734     0.200
     6.405    17.961     0.200
     6.494    18.303     0.200
     6.612    18.239     0.200
     6.647    18.814     0.200
     6.677    19.703     0.200
     6.699    19.075     0.200
     6.699    19.438     0.200
     6.758    19.459     0.200
     6.842    17.634     0.200
     6.816    19.685     0.200
     6.850    18.509     0.200
     6.850    19.290     0.200
     6.863    19.140     0.200
     6.909    19.108     0.200
     6.958    18.397     0.200
     6.989    19.565     0.200
     6.989    19.938     0.200
     7.009    19.012     0.200
     7.036    19.946     0.200
     7.077    19.439     0.200
     7.125    19.661     0.200
     7.220    20.375     0.200
     7.212    20.008     0.200
     7.260    20.363     0.200
     7.260    19.869     0.200
     7.285    20.218     0.200
     7.310    19.990     0.200
     7.310    20.111     0.200
     7.353    20.050     0.200
     7.489    18.800     0.200
     7.539    21.438     0.200
     7.655    21.086     0.200
     7.657    21.193     0.200
     7.685    20.649     0.200
     7.756    20.475     0.200
     7.767    21.205     0.200
     7.767    20.929     0.200
     7.800    20.752     0.200
     7.800    21.189     0.200
     7.813    21.614     0.200
     7.813    21.494     0.200
     7.949    21.952     0.200
     8.040    18.905     0.200
     8.040    20.392     0.200
     8.023    22.000     0.200
     8.023    22.108     0.200
     8.082    21.522     0.200
     8.082    22.159     0.200
     8.293    19.178     0.200
     8.292    22.594     0.200
     8.294    23.098     0.200
     8.303    22.731     0.200
     8.457    23.557     0.200
     8.464    21.518     0.200
     8.477    22.318     0.200
     8.480    22.910     0.200
     8.562    23.218     0.200
     8.562    22.521     0.200
     8.603    22.230     0.200
     8.623    22.997     0.200
     8.623    22.720     0.200
     8.684    22.606     0.200
     8.704    23.057     0.200
     8.740    22.767     0.200
     8.740    22.969     0.200
     8.798    22.655     0.200
     8.827    23.197     0.200
     8.821    23.425     0.200
     8.821    22.511     0.200
     8.867    23.618     0.200
     8.890    23.412     0.200
     8.892    22.143     0.200
     8.892    23.303     0.200
     8.921    22.499     0.200
     8.947    22.713     0.200
     8.947    23.013     0.200
     8.947    23.273     0.200
     8.971    22.268     0.200
     8.971    23.078     0.200
     8.964    22.773     0.200
     9.013    24.462     0.200
     9.089    23.145     0.200
     9.089    24.207     0.200
     9.182    24.070     0.200
     9.288    23.872     0.200
     9.331    24.763     0.200
     9.404    24.184     0.200
     9.428    24.654     0.200
     9.462    24.521     0.200
     9.564    24.642     0.200
     9.617    24.637     0.200
     9.617    24.116     0.200
     9.617    24.696     0.200
     9.633    24.995     0.200
     9.738    24.874     0.200
     9.738    25.127     0.200
     9.805    24.501     0.200
     9.868    24.693     0.200
     9.868    25.068     0.200
     9.938    25.676     0.200
     9.983    27.926     0.200
     9.983    25.357     0.200
    10.149    25.920     0.200
    10.172    25.801     0.200
    10.257    26.764     0.200
    10.282    26.327     0.200
    10.328    26.450     0.200
    10.367    25.535     0.200
    10.453    26.389     0.200
    10.453    25.563     0.200
    10.473    25.776     0.200
    10.503    26.117     0.200
    10.586    26.843     0.200
    10.681    26.620     0.200
    10.681    26.908     0.200
    10.781    27.139     0.200
    10.816    27.233     0.200
    10.859    26.538     0.200
    10.873    27.956     0.200
    10.954    27.113     0.200
    10.954    26.794     0.200
    11.155    27.757     0.200
    11.172    25.974     0.200
    11.210    27.465     0.200
    11.317    28.421     0.200
    11.426    27.883     0.200
    11.469    27.672     0.200
    11.764    28.050     0.200
    11.769    30.510     0.200
    11.770    28.524     0.200
    11.792    28.612     0.200
    11.814    28.401     0.200
    11.913    29.578     0.200
    12.081    29.473     0.200
    12.185    28.978     0.200
    12.270    29.845     0.200
    12.394    29.974     0.200
    12.641    32.854     0.200
    12.661    30.535     0.200
    12.719    31.802     0.200
    12.948    30.745     0.200
    12.962    31.110     0.200
    13.322    32.771     0.200
    13.516    32.037     0.200
    13.924    34.401     0.200
    14.279    34.029     0.200
    14.927    35.921     0.200
    14.927    34.195     0.200
    16.324    36.662     0.200
     1.427     7.822     0.200
     1.427     8.009     0.200
     1.973     8.776     0.200
     2.101     9.100     0.200
     2.125     8.729     0.200
     2.142     9.241     0.200
     2.213    10.340     0.200
     2.257    10.136     0.200
     2.258    10.029     0.200
     2.315     9.510     0.200
     2.280    10.170     0.200
     2.352     9.538     0.200
     2.452     9.754     0.200
     2.447    10.068     0.200
     2.542    11.108     0.200
     2.648    10.670     0.200
     2.887     8.785     0.200
     2.934    10.093     0.200
     2.961    12.393     0.200
     2.969    12.347     0.200
     3.181    11.426     0.200
     3.181    11.321     0.200
     3.258    12.759     0.200
     3.284    11.265     0.200
     3.284    11.523     0.200
     3.306    12.159     0.200
     3.371    12.850     0.200
     3.371    12.587     0.200
     3.522    11.317     0.200
     3.520    11.275     0.200
     3.592    12.109     0.200
     3.590    12.863     0.200
     3.579    12.392     0.200
     3.579    12.222     0.200
     3.616    12.534     0.200
     3.616    12.288     0.200
     3.625    13.021     0.200
     3.669    11.676     0.200
     3.702    13.693     0.200
     3.702    13.579     0.200
     3.936    10.018     0.200
     3.940    10.359     0.200
     3.953    12.724     0.200
     3.953    12.497     0.200
     4.034    13.770     0.200
     4.217    11.092     0.200
     4.217    11.198     0.200
     4.078    14.278     0.200
     4.114    12.590     0.200
     4.114    12.726     0.200
     4.102    14.104     0.200
     4.173    14.347     0.200
     4.213    12.470     0.200
     4.213    12.629     0.200
     4.206    14.268     0.200
     4.210    14.115     0.200
     4.471    14.834     0.200
     4.471    14.693     0.200
     4.485    13.845     0.200
     4.509    14.475     0.200
     4.510    16.317     0.200
     4.759    12.878     0.200
     4.830    15.448     0.200
     4.831    15.339     0.200
     4.840    15.102     0.200
     4.841    15.336     0.200
     4.841    15.482     0.200
     4.864    15.148     0.200
     4.909    15.711     0.200
     5.012    15.111     0.200
     5.012    14.897     0.200
     5.039    14.749     0.200
     5.147    14.512     0.200
     5.236    15.577     0.200
     5.236    15.335     0.200
     5.496    16.722     0.200
     5.496    16.555     0.200
     5.513    14.621     0.200
     5.513    14.999     0.200
     5.549    16.049     0.200
     5.549    16.658     0.200
     5.608    14.637     0.200
     5.598    15.458     0.200
     5.598    15.806     0.200
     5.599    16.442     0.200
     5.618    15.632     0.200
     5.618    15.354     0.200
     5.662    16.709     0.200
     5.715    15.723     0.200
     5.715    15.828     0.200
     5.849    16.757     0.200
     5.849    16.447     0.200
     5.823    16.207     0.200
     5.855    17.678     0.200
     5.855    17.378     0.200
     5.977    16.585     0.200
     5.977    16.748     0.200
     6.013    16.450     0.200
     6.180    15.546     0.200
     6.114    17.104     0.200
     6.102    17.222     0.200
     6.103    17.784     0.200
     6.147    16.805     0.200
     6.199    17.212     0.200
     6.209    16.978     0.200
     6.234    17.241     0.200
     6.234    17.416     0.200
     6.349    17.293     0.200
     6.349    17.549     0.200
     6.407    17.014     0.200
     6.414    17.333     0.200
     6.414    17.211     0.200
     6.504    17.669     0.200
     6.621    17.649     0.200
     6.657    17.957     0.200
     6.674    19.239     0.200
     6.830    17.276     0.200
     6.697    18.621     0.200
     6.697    18.771     0.200
     6.764    18.936     0.200
     6.764    18.599     0.200
     6.791    18.093     0.200
     6.795    18.524     0.200
     6.820    18.760     0.200
     6.858    18.208     0.200
     6.858    18.720     0.200
     6.867    18.904     0.200
     6.919    18.594     0.200
     6.968    18.809     0.200
     6.989    19.121     0.200
     6.989    19.556     0.200
     7.017    18.795     0.200
     7.046    18.927     0.200
     7.046    19.274     0.200
     7.087    18.776     0.200
     7.135    19.056     0.200
     7.222    19.361     0.200
     7.222    19.976     0.200
     7.268    19.331     0.200
     7.268    19.539     0.200
     7.291    20.479     0.200
     7.291    20.790     0.200
     7.315    19.394     0.200
     7.315    19.812     0.200
     7.476    18.372     0.200
     7.362    19.574     0.200
     7.359    19.736     0.200
     7.663    20.214     0.200
     7.663    20.918     0.200
     7.658    20.725     0.200
     7.658    20.952     0.200
     7.695    20.326     0.200
     7.766    20.371     0.200
     7.777    20.820     0.200
     7.802    20.432     0.200
     7.802    20.311     0.200
     7.812    20.729     0.200
     7.812    20.868     0.200
     8.028    18.316     0.200
     7.957    21.691     0.200
     8.015    21.158     0.200
     8.111    19.404     0.200
     8.034    21.360     0.200
     8.034    21.221     0.200
     8.013    22.046     0.200
     8.092    21.155     0.200
     8.092    20.733     0.200
     8.311    22.103     0.200
     8.311    22.265     0.200
     8.297    22.604     0.200
     8.345    22.294     0.200
     8.462    22.523     0.200
     8.467    20.605     0.200
     8.467    20.878     0.200
     8.480    20.948     0.200
     8.559    22.953     0.200
     8.559    22.599     0.200
     8.634    22.701     0.200
     8.634    22.941     0.200
     8.607    22.602     0.200
     8.688    21.254     0.200
     8.741    22.508     0.200
     8.832    23.183     0.200
     8.832    22.065     0.200
     8.805    23.999     0.200
     8.828    22.988     0.200
     8.872    23.365     0.200
     8.893    22.471     0.200
     8.895    22.153     0.200
     8.895    22.563     0.200
     8.924    22.023     0.200
     8.951    22.387     0.200
     8.951    22.326     0.200
     8.973    22.610     0.200
     8.973    22.343     0.200
     9.022    24.319     0.200
     9.094    22.499     0.200
     9.094    23.486     0.200
     9.186    23.362     0.200
     9.186    23.097     0.200
     9.288    22.926     0.200
     9.288    23.073     0.200
     9.342    23.099     0.200
     9.409    23.574     0.200
     9.409    23.969     0.200
     9.474    24.576     0.200
     9.434    24.412     0.200
     9.565    24.008     0.200
     9.565    24.440     0.200
     9.642    24.548     0.200
     9.642    24.728     0.200
     9.617    24.199     0.200
     9.619    23.851     0.200
     9.748    24.786     0.200
     9.748    24.202     0.200
     9.808    23.639     0.200
     9.808    23.520     0.200
     9.872    24.234     0.200
     9.949    24.604     0.200
     9.994    27.051     0.200
     9.994    25.609     0.200
    10.138    25.522     0.200
    10.149    25.214     0.200
    10.177    25.403     0.200
    10.263    26.475     0.200
    10.263    26.856     0.200
    10.290    26.081     0.200
    10.338    25.827     0.200
    10.376    25.561     0.200
    10.484    26.163     0.200
    10.454    25.008     0.200
    10.506    25.123     0.200
    10.587    26.314     0.200
    10.684    25.586     0.200
    10.789    26.953     0.200
    10.827    26.382     0.200
    10.790    27.282     0.200
    10.859    28.221     0.200
    10.877    27.701     0.200
    10.955    27.265     0.200
    10.955    26.670     0.200
    11.156    28.796     0.200
    11.322    29.036     0.200
    11.464    27.376     0.200
    11.428    27.738     0.200
    11.473    26.186     0.200
    11.683    28.493     0.200
    11.767    29.039     0.200
    11.774    28.410     0.200
    11.793    28.666     0.200
    11.915    28.699     0.200
    12.084    29.621     0.200
    12.197    30.001     0.200
    12.273    29.855     0.200
    12.395    30.836     0.200
    12.653    32.122     0.200
    12.662    31.533     0.200
    12.693    30.857     0.200
    12.729    31.197     0.200
    12.966    31.617     0.200
    13.927    34.384     0.200
    14.285    33.552     0.200
    14.933    35.907     0.200
    14.933    34.966     0.200
    14.933    35.315     0.200
    16.334    37.952     0.200
    18.305    39.008     0.200
    20.305    38.547     0.200
     0.194    10.817     0.200
     0.296    10.094     0.200
     0.278    10.173     0.200
     0.324    10.208     0.200
     0.350     9.949     0.200
     0.369    10.181     0.200
     0.376    10.007     0.200
     0.446     9.416     0.200
     0.478     9.289     0.200
     0.490     9.609     0.200
     0.565     9.019     0.200
     0.678     8.281     0.200
     0.692     8.388     0.200
     0.693     8.375     0.200
     0.991     8.006     0.200
     0.949     8.292     0.200
     0.949     8.550     0.200
     1.071     7.915     0.200
     1.117     7.871     0.200
     1.150     7.742     0.200
     1.131     8.125     0.200
     1.131     8.011     0.200
     1.261     8.445     0.200
     1.263     8.428     0.200
     1.310     7.849     0.200
     1.310     8.031     0.200
     1.379     9.041     0.200
     1.379     8.979     0.200
     1.399     8.910     0.200
     1.406     8.802     0.200
     1.438     8.456     0.200
     1.588     7.923     0.200
     1.685     8.012     0.200
     1.688     9.146     0.200
     1.761     8.698     0.200
     1.993     8.888     0.200
     2.000     9.347     0.200
     2.009     9.324     0.200
     2.065     9.438     0.200
     2.096     8.940     0.200
     2.080     9.089     0.200
     2.173     9.416     0.200
     2.173     9.910     0.200
     2.211     9.944     0.200
     2.244     9.285     0.200
     2.377     8.045     0.200
     2.377     8.305     0.200
     2.335     9.343     0.200
     2.484    10.204     0.200
     2.527    10.316     0.200
     2.531     9.530     0.200
     2.535    10.344     0.200
     2.582     9.570     0.200
     2.589    10.424     0.200
     2.644     9.701     0.200
     2.638    10.544     0.200
     2.661    10.543     0.200
     2.765     9.264     0.200
     2.765     9.365     0.200
     2.696    10.313     0.200
     3.021    10.595     0.200
     3.179    10.914     0.200
     3.181    11.374     0.200
     3.181    12.066     0.200
     3.265    10.911     0.200
     3.263    10.497     0.200
     3.287    11.554     0.200
     3.316    10.100     0.200
     3.316    10.334     0.200
     3.326    11.263     0.200
     3.385    11.586     0.200
     3.440    11.106     0.200
     3.660    12.165     0.200
     3.757    12.692     0.200
     3.791    12.041     0.200
     3.791    12.173     0.200
     3.840    12.704     0.200
     3.840    12.531     0.200
     3.865    11.683     0.200
     3.865    11.840     0.200
     3.874    12.444     0.200
     4.070    12.881     0.200
     4.070    13.282     0.200
     4.161    12.699     0.200
     4.161    12.381     0.200
     4.209    12.083     0.200
     4.307    11.357     0.200
     4.316    11.147     0.200
     4.279    12.673     0.200
     4.279    12.806     0.200
     4.490    12.682     0.200
     4.495    13.034     0.200
     4.529    12.801     0.200
     4.529    12.348     0.200
     4.638    12.181     0.200
     4.717    11.900     0.200
     4.717    12.319     0.200
     4.739    13.556     0.200
     4.803    13.510     0.200
     4.853    12.879     0.200
     4.853    13.230     0.200
     4.870    14.437     0.200
     4.910    12.379     0.200
     4.933    14.369     0.200
     4.933    14.941     0.200
     5.016    13.104     0.200
     5.143    13.649     0.200
     5.143    13.872     0.200
     5.211    13.972     0.200
     5.211    14.175     0.200
     5.255    15.248     0.200
     5.255    14.757     0.200
     5.398    14.024     0.200
     5.452    14.835     0.200
     5.452    15.234     0.200
     5.511    14.195     0.200
     5.530    15.105     0.200
     5.530    14.881     0.200
     5.563    15.073     0.200
     5.575    14.566     0.200
     5.585    14.132     0.200
     5.585    14.303     0.200
     5.619    15.016     0.200
     5.617    14.397     0.200
     5.744    14.900     0.200
     5.753    15.465     0.200
     5.802    15.273     0.200
     5.829    14.992     0.200
     5.829    15.303     0.200
     5.863    15.543     0.200
     5.910    16.057     0.200
     5.998    14.811     0.200
     6.035    15.255     0.200
     6.076    16.431     0.200
     6.107    15.040     0.200
     6.107    15.174     0.200
     6.127    15.887     0.200
     6.244    15.840     0.200
     6.244    16.014     0.200
     6.265    16.155     0.200
     6.264    15.642     0.200
     6.363    16.955     0.200
     6.381    16.626     0.200
     6.393    17.011     0.200
     6.455    16.729     0.200
     6.557    16.675     0.200
     6.615    17.400     0.200
     6.622    16.868     0.200
     6.622    17.112     0.200
     6.699    16.156     0.200
     6.699    17.729     0.200
     6.741    17.300     0.200
     6.826    17.984     0.200
     6.826    17.367     0.200
     6.830    17.935     0.200
     6.871    17.853     0.200
     6.965    18.088     0.200
     7.010    16.001     0.200
     7.186    18.105     0.200
     7.274    19.004     0.200
     7.299    17.539     0.200
     7.299    17.244     0.200
     7.307    16.161     0.200
     7.315    18.858     0.200
     7.319    18.545     0.200
     7.410    18.326     0.200
     7.364    17.907     0.200
     7.364    18.341     0.200
     7.434    18.924     0.200
     7.472    16.631     0.200
     7.497    16.562     0.200
     7.550    18.942     0.200
     7.605    18.358     0.200
     7.617    19.217     0.200
     7.617    19.399     0.200
     7.618    18.704     0.200
     7.644    19.080     0.200
     7.644    19.338     0.200
     7.807    20.266     0.200
     7.807    19.969     0.200
     7.800    18.895     0.200
     7.800    18.573     0.200
     7.816    20.396     0.200
     7.928    18.149     0.200
     7.928    18.647     0.200
     7.867    17.966     0.200
     7.867    19.048     0.200
     7.896    19.323     0.200
     7.934    18.635     0.200
     7.982    20.475     0.200
     7.993    20.249     0.200
     7.993    20.076     0.200
     8.012    20.245     0.200
     8.012    19.875     0.200
     8.025    19.457     0.200
     8.064    20.128     0.200
     8.301    19.367     0.200
     8.301    20.053     0.200
     8.468    19.821     0.200
     8.505    20.911     0.200
     8.676    22.821     0.200
     8.718    21.768     0.200
     8.718    21.640     0.200
     9.099    22.475     0.200
     9.099    22.674     0.200
     9.108    23.451     0.200
     9.252    21.511     0.200
     9.431    22.198     0.200
     9.454    22.849     0.200
     9.498    22.904     0.200
    10.051    23.954     0.200
    10.051    23.793     0.200
    10.847    25.533     0.200
    11.330    26.476     0.200
     1.157     6.844     0.200
     1.519     8.138     0.200
     1.568     8.767     0.200
     1.685     9.342     0.200
     1.765     9.404     0.200
     1.827     9.936     0.200
     1.827     9.647     0.200
     1.903     9.551     0.200
     1.902     9.414     0.200
     2.076     9.531     0.200
     2.337    11.094     0.200
     2.337    10.793     0.200
     2.400    11.377     0.200
     2.402    11.369     0.200
     2.447    10.570     0.200
     2.532    11.447     0.200
     2.532    10.556     0.200
     2.645    10.938     0.200
     2.720    11.113     0.200
     2.778    11.950     0.200
     3.090    12.789     0.200
     3.090    13.004     0.200
     3.108    11.939     0.200
     3.131    11.708     0.200
     3.138    11.848     0.200
     3.185    11.558     0.200
     3.185    11.410     0.200
     3.228    11.697     0.200
     3.267    12.828     0.200
     3.406    13.796     0.200
     3.418    13.421     0.200
     3.471    13.519     0.200
     3.473    13.772     0.200
     3.473    13.635     0.200
     3.483    13.660     0.200
     3.483    13.086     0.200
     3.490    13.569     0.200
     3.605    14.619     0.200
     3.788    13.555     0.200
     3.813    13.841     0.200
     3.930    14.915     0.200
     3.936    15.408     0.200
     3.946    14.983     0.200
     3.953    13.971     0.200
     3.953    13.865     0.200
     4.069    15.037     0.200
     4.089    14.562     0.200
     4.166    14.259     0.200
     4.360    14.706     0.200
     4.525    14.174     0.200
     4.525    14.292     0.200
     4.547    16.318     0.200
     4.581    14.999     0.200
     4.698    16.513     0.200
     4.713    16.487     0.200
     4.723    16.136     0.200
     4.724    16.186     0.200
     4.733    16.377     0.200
     4.841    16.428     0.200
     5.183    16.824     0.200
     5.183    16.723     0.200
     5.192    16.535     0.200
     5.192    16.308     0.200
     5.253    18.111     0.200
     5.255    17.134     0.200
     5.447    17.457     0.200
     5.453    16.446     0.200
     5.570    17.704     0.200
     5.570    17.493     0.200
     5.653    17.340     0.200
     5.653    17.473     0.200
     5.772    17.125     0.200
     5.772    16.942     0.200
     5.782    18.508     0.200
     5.827    17.103     0.200
     5.827    17.353     0.200
     5.841    17.165     0.200
     5.908    16.850     0.200
     5.908    16.647     0.200
     6.059    16.853     0.200
     6.173    18.491     0.200
     6.173    18.838     0.200
     6.185    18.508     0.200
     6.208    18.865     0.200
     6.206    17.719     0.200
     6.236    17.805     0.200
     6.236    17.403     0.200
     6.348    18.766     0.200
     6.344    18.830     0.200
     6.499    18.012     0.200
     6.499    18.832     0.200
     6.515    19.301     0.200
     6.566    18.685     0.200
     6.607    18.983     0.200
     6.649    19.685     0.200
     6.649    19.798     0.200
     6.741    19.244     0.200
     6.741    19.111     0.200
     6.765    19.493     0.200
     6.867    20.247     0.200
     6.868    20.113     0.200
     6.890    19.902     0.200
     6.936    19.158     0.200
     6.936    19.044     0.200
     6.957    19.731     0.200
     6.960    19.516     0.200
     6.960    19.672     0.200
     7.038    18.826     0.200
     7.072    20.492     0.200
     7.072    20.356     0.200
     7.148    20.960     0.200
     7.154    20.873     0.200
     7.154    20.459     0.200
     7.263    19.880     0.200
     7.295    20.865     0.200
     7.295    21.350     0.200
     7.305    20.156     0.200
     7.305    20.344     0.200
     7.343    20.595     0.200
     7.389    19.884     0.200
     7.444    20.525     0.200
     7.462    21.224     0.200
     7.462    21.119     0.200
     7.466    21.040     0.200
     7.466    21.767     0.200
     7.518    20.760     0.200
     7.549    21.416     0.200
     7.625    20.656     0.200
     7.625    22.093     0.200
     7.640    21.087     0.200
     7.660    22.414     0.200
     7.663    21.735     0.200
     7.662    20.888     0.200
     7.738    21.451     0.200
     7.756    20.442     0.200
     7.807    21.305     0.200
     7.807    21.668     0.200
     7.806    20.947     0.200
     7.867    21.105     0.200
     7.917    20.907     0.200
     7.926    21.726     0.200
     7.926    22.191     0.200
     7.924    21.290     0.200
     7.943    21.040     0.200
     8.060    21.807     0.200
     8.111    21.378     0.200
     8.224    21.714     0.200
     8.233    22.720     0.200
     8.335    22.567     0.200
     8.338    22.276     0.200
     8.389    22.827     0.200
     8.389    23.073     0.200
     8.419    22.931     0.200
     8.430    22.133     0.200
     8.473    23.860     0.200
     8.492    21.983     0.200
     8.584    22.803     0.200
     8.598    23.576     0.200
     8.658    23.417     0.200
     8.658    24.073     0.200
     8.683    23.009     0.200
     8.691    24.141     0.200
     8.705    22.315     0.200
     8.780    23.118     0.200
     8.780    23.876     0.200
     8.789    23.055     0.200
     8.789    24.122     0.200
     8.857    24.920     0.200
     8.886    23.479     0.200
     8.896    23.899     0.200
     8.898    23.692     0.200
     8.903    23.022     0.200
     8.914    23.513     0.200
     9.009    24.417     0.200
     9.009    24.190     0.200
     9.008    23.215     0.200
     9.008    21.895     0.200
     9.008    23.856     0.200
     9.070    23.554     0.200
     9.070    24.261     0.200
     9.121    23.518     0.200
     9.218    25.110     0.200
     9.233    24.625     0.200
     9.233    24.449     0.200
     9.236    23.263     0.200
     9.236    24.911     0.200
     9.288    23.754     0.200
     9.288    25.531     0.200
     9.397    25.205     0.200
     9.497    24.675     0.200
     9.497    24.480     0.200
     9.635    26.556     0.200
     9.755    26.831     0.200
     9.755    26.323     0.200
     9.764    26.219     0.200
     9.948    26.300     0.200
    10.210    26.656     0.200
    10.362    26.484     0.200
    10.557    27.664     0.200
    10.622    27.419     0.200
    10.656    27.343     0.200
    10.695    28.210     0.200
    10.695    27.995     0.200
    10.858    29.316     0.200
    10.909    27.468     0.200
    11.038    28.117     0.200
    11.788    29.336     0.200
    12.356    30.894     0.200
    13.420    33.347     0.200
    13.589    36.322     0.200
    15.187    37.344     0.200
    15.187    34.672     0.200
     0.181    10.781     0.200
     0.463     9.331     0.200
     0.487     9.543     0.200
     0.553     9.010     0.200
     0.677     8.333     0.200
     0.950     8.450     0.200
     1.062     7.745     0.200
     1.106     7.734     0.200
     1.164     7.586     0.200
     1.146     7.861     0.200
     1.272     8.437     0.200
     1.300     7.856     0.200
     1.378     9.006     0.200
     1.379     8.893     0.200
     1.380     9.038     0.200
     1.424     8.386     0.200
     1.597     7.802     0.200
     1.687     9.096     0.200
     1.751     8.599     0.200
     1.978     8.691     0.200
     1.999     9.299     0.200
     2.082     8.838     0.200
     2.074     9.037     0.200
     2.177     9.745     0.200
     2.210     9.846     0.200
     2.250     9.427     0.200
     2.320     9.161     0.200
     2.381     8.270     0.200
     2.482    10.102     0.200
     2.526    10.384     0.200
     2.533    10.265     0.200
     2.537     9.309     0.200
     2.588     9.422     0.200
     2.634     9.835     0.200
     2.659    10.531     0.200
     2.759     9.258     0.200
     2.689    10.281     0.200
     3.012    10.259     0.200
     3.165    10.753     0.200
     3.183    12.489     0.200
     3.282    10.522     0.200
     3.285    11.539     0.200
     3.321    10.208     0.200
     3.383    11.986     0.200
     3.432    11.914     0.200
     3.659    12.194     0.200
     3.784    12.037     0.200
     3.835    12.644     0.200
     3.868    11.561     0.200
     3.874    12.501     0.200
     4.063    12.696     0.200
     4.159    13.070     0.200
     4.172    12.214     0.200
     4.261    11.651     0.200
     4.214    11.946     0.200
     4.312    10.825     0.200
     4.280    12.935     0.200
     4.532    12.232     0.200
     4.723    12.099     0.200
     4.747    13.434     0.200
     4.802    14.357     0.200
     4.855    12.947     0.200
     4.861    14.146     0.200
     4.917    12.159     0.200
     4.929    14.354     0.200
     5.150    13.727     0.200
     5.214    13.790     0.200
     5.248    14.701     0.200
     5.404    14.540     0.200
     5.448    14.723     0.200
     5.535    14.741     0.200
     5.572    15.952     0.200
     5.583    14.944     0.200
     5.586    14.276     0.200
     5.618    14.295     0.200
     5.742    14.865     0.200
     5.762    15.372     0.200
     5.870    14.726     0.200
     5.806    15.616     0.200
     5.836    15.256     0.200
     5.920    15.808     0.200
     5.997    14.954     0.200
     6.044    15.581     0.200
     6.069    17.075     0.200
     6.108    15.274     0.200
     6.133    16.086     0.200
     6.241    16.079     0.200
     6.263    15.983     0.200
     6.388    16.535     0.200
     6.402    16.758     0.200
     6.453    17.058     0.200
     6.464    16.846     0.200
     6.565    17.117     0.200
     6.624    16.943     0.200
     6.706    16.961     0.200
     6.750    17.356     0.200
     6.835    17.790     0.200
     6.839    17.857     0.200
     6.837    17.527     0.200
     6.879    18.024     0.200
     6.881    17.450     0.200
     6.974    18.128     0.200
     7.007    15.642     0.200
     7.092    15.720     0.200
     7.129    18.738     0.200
     7.164    16.422     0.200
     7.182    17.234     0.200
     7.191    18.312     0.200
     7.204    18.452     0.200
     7.217    18.478     0.200
     7.283    18.922     0.200
     7.298    17.048     0.200
     7.306    16.013     0.200
     7.327    19.094     0.200
     7.366    18.521     0.200
     7.443    18.673     0.200
     7.469    17.281     0.200
     7.553    19.058     0.200
     7.600    18.774     0.200
     7.622    19.348     0.200
     7.802    19.075     0.200
     7.867    19.515     0.200
     7.890    19.915     0.200
     7.989    20.457     0.200
     7.998    20.002     0.200
     8.016    20.256     0.200
     8.016    19.795     0.200
     8.078    18.276     0.200
     8.303    20.193     0.200
     8.471    20.560     0.200
     8.560    19.670     0.200
     9.009    19.971     0.200
     0.755     6.082     0.200
     0.737     6.015     0.200
     0.737     6.230     0.200
     0.794     5.938     0.200
     1.010     6.088     0.200
     1.420     6.297     0.200
     1.420     6.563     0.200
     1.487     7.569     0.200
     1.487     7.685     0.200
     1.656     7.370     0.200
     1.822     7.638     0.200
     1.822     7.501     0.200
     1.834     8.611     0.200
     1.834     8.869     0.200
     1.873     8.577     0.200
     1.981     8.768     0.200
     2.025     7.708     0.200
     2.025     8.200     0.200
     2.168     8.129     0.200
     2.206     8.350     0.200
     2.332     9.729     0.200
     2.587     8.200     0.200
     2.650    10.029     0.200
     2.650     9.830     0.200
     2.717     9.535     0.200
     2.904    11.716     0.200
     2.934     8.916     0.200
     3.052    10.191     0.200
     3.089    10.056     0.200
     3.089     9.823     0.200
     3.116    10.802     0.200
     3.118    10.896     0.200
     3.462    11.611     0.200
     3.551    11.111     0.200
     3.616    11.780     0.200
     3.712    13.021     0.200
     3.712    12.615     0.200
     3.733    11.949     0.200
     3.846    10.901     0.200
     3.958    11.926     0.200
     4.035    12.539     0.200
     4.051    11.649     0.200
     4.056    11.251     0.200
     4.130    11.353     0.200
     4.130    11.474     0.200
     4.195    11.749     0.200
     4.195    12.138     0.200
     4.330    11.981     0.200
     4.334    11.194     0.200
     4.334    12.013     0.200
     4.514    11.122     0.200
     4.535    12.570     0.200
     4.566    13.459     0.200
     4.664    12.797     0.200
     4.732    12.245     0.200
     4.732    12.573     0.200
     4.872    13.381     0.200
     5.008    13.222     0.200
     5.153    13.626     0.200
     5.156    13.803     0.200
     5.181    15.292     0.200
     5.306    15.575     0.200
     5.306    15.754     0.200
     5.314    14.176     0.200
     5.317    14.010     0.200
     5.328    13.983     0.200
     5.423    13.811     0.200
     5.454    15.107     0.200
     5.454    14.995     0.200
     5.540    15.796     0.200
     5.540    15.573     0.200
     5.609    14.411     0.200
     5.742    15.199     0.200
     5.750    16.837     0.200
     5.753    15.552     0.200
     5.818    15.288     0.200
     5.984    15.197     0.200
     6.004    16.957     0.200
     6.004    16.506     0.200
     6.012    16.057     0.200
     6.028    15.255     0.200
     6.295    16.256     0.200
     6.294    16.665     0.200
     6.391    16.782     0.200
     6.391    16.652     0.200
     6.533    17.036     0.200
     6.777    16.919     0.200
     6.811    17.568     0.200
     6.811    17.429     0.200
     6.842    17.840     0.200
     6.894    17.809     0.200
     6.897    17.801     0.200
     7.206    18.188     0.200
     7.206    18.182     0.200
     7.370    17.767     0.200
     7.494    18.858     0.200
     7.574    19.433     0.200
     8.254    21.781     0.200
     8.355    19.761     0.200
     8.677    21.944     0.200
     0.236     9.751     0.200
     0.236     9.962     0.200
     0.659     8.241     0.200
     0.712     7.765     0.200
     0.714     7.733     0.200
     0.985     8.296     0.200
     0.985     7.975     0.200
     0.985     8.221     0.200
     1.073     7.202     0.200
     1.078     7.284     0.200
     1.254     7.706     0.200
     1.319     8.116     0.200
     1.414     8.661     0.200
     1.414     7.841     0.200
     1.414     7.994     0.200
     1.488     7.362     0.200
     1.487     8.584     0.200
     1.497     8.236     0.200
     1.533     7.978     0.200
     1.545     8.116     0.200
     1.572     8.164     0.200
     1.779     7.848     0.200
     1.836     8.118     0.200
     1.831     8.978     0.200
     1.951     9.093     0.200
     2.077     8.546     0.200
     2.159     8.340     0.200
     2.168     9.454     0.200
     2.283     9.375     0.200
     2.295     9.329     0.200
     2.434    11.126     0.200
     2.434    10.630     0.200
     2.463     9.491     0.200
     2.570     8.725     0.200
     2.601     9.563     0.200
     2.617    10.154     0.200
     2.621     9.826     0.200
     3.073     9.483     0.200
     3.107    10.479     0.200
     3.136    10.957     0.200
     3.159    11.023     0.200
     3.210    11.592     0.200
     3.242    11.043     0.200
     3.242    11.145     0.200
     3.454    10.863     0.200
     3.453    10.719     0.200
     3.453    10.446     0.200
     3.461    11.129     0.200
     3.518    11.025     0.200
     3.518    11.127     0.200
     3.537    11.724     0.200
     3.537    11.587     0.200
     3.551    11.803     0.200
     3.681    10.915     0.200
     3.681    11.048     0.200
     3.769    11.066     0.200
     3.800    12.469     0.200
     3.839    12.416     0.200
     3.883    11.369     0.200
     3.971    10.780     0.200
     4.017    11.870     0.200
     4.079    12.045     0.200
     4.079    12.482     0.200
     4.094    11.747     0.200
     4.094    12.056     0.200
     4.173    10.857     0.200
     4.278    13.818     0.200
     4.285    12.409     0.200
     4.421    12.249     0.200
     4.421    12.374     0.200
     4.451    12.919     0.200
     4.451    12.786     0.200
     4.655    13.125     0.200
     4.684    13.964     0.200
     4.684    14.324     0.200
     4.778    13.392     0.200
     4.772    13.508     0.200
     4.803    12.501     0.200
     4.803    14.235     0.200
     4.842    13.229     0.200
     4.842    13.698     0.200
     4.863    13.300     0.200
     4.888    14.268     0.200
     4.905    13.642     0.200
     5.016    13.899     0.200
     5.042    14.214     0.200
     5.042    14.319     0.200
     5.055    13.322     0.200
     5.044    14.004     0.200
     5.044    14.559     0.200
     5.051    13.448     0.200
     5.100    12.725     0.200
     5.100    13.671     0.200
     5.269    13.995     0.200
     5.338    14.220     0.200
     5.357    14.345     0.200
     5.357    14.552     0.200
     5.380    14.491     0.200
     5.380    14.702     0.200
     5.498    15.155     0.200
     5.508    15.318     0.200
     5.543    14.726     0.200
     5.543    15.176     0.200
     5.604    15.541     0.200
     5.643    14.838     0.200
     5.713    15.642     0.200
     5.716    14.926     0.200
     5.762    15.250     0.200
     5.862    14.878     0.200
     5.862    15.729     0.200
     5.967    15.383     0.200
     5.967    15.692     0.200
     6.044    15.997     0.200
     6.139    16.583     0.200
     6.151    16.631     0.200
     6.151    16.479     0.200
     6.282    16.366     0.200
     6.307    14.444     0.200
     6.307    15.413     0.200
     6.375    17.101     0.200
     6.433    17.021     0.200
     6.483    16.601     0.200
     6.506    16.438     0.200
     6.506    17.137     0.200
     6.557    16.056     0.200
     6.564    16.080     0.200
     6.564    16.513     0.200
     6.590    17.598     0.200
     6.586    15.469     0.200
     6.607    17.513     0.200
     6.642    18.033     0.200
     6.642    17.322     0.200
     6.778    16.539     0.200
     6.780    16.524     0.200
     6.784    16.785     0.200
     6.784    16.617     0.200
     6.791    17.769     0.200
     6.787    15.990     0.200
     6.868    17.603     0.200
     6.868    17.869     0.200
     6.888    15.907     0.200
     6.888    16.227     0.200
     7.001    17.600     0.200
     7.043    17.111     0.200
     7.043    17.283     0.200
     7.078    17.454     0.200
     7.113    18.782     0.200
     7.122    17.179     0.200
     7.122    17.499     0.200
     7.237    18.804     0.200
     7.253    19.105     0.200
     7.255    18.608     0.200
     7.318    18.400     0.200
     7.386    18.551     0.200
     7.386    18.782     0.200
     7.407    17.474     0.200
     7.407    18.193     0.200
     7.429    19.980     0.200
     7.546    18.369     0.200
     7.654    18.729     0.200
     7.708    18.318     0.200
     7.836    19.995     0.200
     7.829    17.983     0.200
     7.829    18.761     0.200
     8.228    19.643     0.200
     8.258    20.145     0.200
     8.363    20.823     0.200
     8.493    20.863     0.200
     8.695    21.237     0.200
     8.695    20.869     0.200
     9.139    22.031     0.200
     9.347    22.776     0.200
     9.670    22.088     0.200
     9.688    24.898     0.200
    10.092    24.983     0.200
    10.127    23.563     0.200
    10.612    23.574     0.200
     0.498     5.615     0.200
     0.671     5.718     0.200
     1.036     6.474     0.200
     1.036     5.513     0.200
     1.375     6.466     0.200
     1.487     7.225     0.200
     1.487     7.137     0.200
     1.688     7.949     0.200
     1.730     7.630     0.200
     1.856     7.765     0.200
     2.236     8.468     0.200
     2.300     8.436     0.200
     2.498     8.174     0.200
     2.685     9.750     0.200
     2.702     9.206     0.200
     2.783     9.697     0.200
     2.818    10.329     0.200
     2.968     9.686     0.200
     2.976     9.714     0.200
     2.976    10.400     0.200
     3.081    10.050     0.200
     3.100    10.533     0.200
     3.570    10.469     0.200
     3.804    10.345     0.200
     3.804    10.859     0.200
     3.884    11.644     0.200
     3.971    11.248     0.200
     4.006    10.871     0.200
     4.026    12.325     0.200
     4.116    12.159     0.200
     4.502    12.918     0.200
     4.502    13.439     0.200
     4.691    13.801     0.200
     4.700    14.004     0.200
     4.700    14.450     0.200
     4.736    12.262     0.200
     4.736    13.100     0.200
     4.956    14.059     0.200
     4.980    14.109     0.200
     5.124    13.433     0.200
     5.124    13.754     0.200
     5.478    13.322     0.200
     5.504    14.198     0.200
     5.775    17.534     0.200
     5.791    14.667     0.200
     5.791    15.666     0.200
     5.791    16.431     0.200
     5.837    15.178     0.200
     6.016    15.774     0.200
     6.016    15.934     0.200
     6.149    16.533     0.200
     6.205    15.973     0.200
     6.205    16.179     0.200
     6.310    15.219     0.200
     6.299    17.477     0.200
     6.359    17.344     0.200
     6.537    17.465     0.200
     6.549    16.331     0.200
     6.576    17.183     0.200
     6.619    17.402     0.200
     6.717    17.138     0.200
     6.781    18.267     0.200
     6.787    16.828     0.200
     6.817    17.410     0.200
     6.972    18.350     0.200
     7.010    17.670     0.200
     7.022    18.572     0.200
     7.076    17.559     0.200
     7.072    19.305     0.200
     7.193    17.967     0.200
     7.222    17.866     0.200
     7.501    18.768     0.200
     7.503    18.679     0.200
     7.755    19.129     0.200
     7.798    19.161     0.200
     7.817    19.673     0.200
     7.851    18.766     0.200
     7.940    21.136     0.200
     8.023    19.293     0.200
     8.059    19.407     0.200
     8.274    19.768     0.200
     8.354    20.358     0.200
     8.354    17.184     0.200
     8.354    19.408     0.200
     8.485    22.275     0.200
     8.494    20.118     0.200
     8.557    21.308     0.200
     8.789    20.413     0.200
     8.906    21.541     0.200
     9.043    21.735     0.200
     9.145    21.784     0.200
     9.327    22.455     0.200
     9.850    24.170     0.200
     9.972    24.339     0.200
    10.546    24.590     0.200
    11.151    24.591     0.200
    14.112    31.639     0.200
    14.490    33.138     0.200
    20.313    36.315     0.200
     0.492     5.012     0.200
     1.113     5.605     0.200
     1.113     5.804     0.200
     1.419     7.648     0.200
     1.419     7.381     0.200
     1.419     7.494     0.200
     1.447     7.287     0.200
     1.478     7.471     0.200
     1.744     7.266     0.200
     1.736     7.711     0.200
     1.755     7.621     0.200
     1.761     7.133     0.200
     1.814     8.420     0.200
     1.915     7.577     0.200
     2.074     8.148     0.200
     2.117     8.010     0.200
     2.117     8.361     0.200
     2.327     9.196     0.200
     2.456     7.952     0.200
     2.555     8.585     0.200
     2.612    10.622     0.200
     2.665     9.786     0.200
     2.719     9.912     0.200
     2.944    10.235     0.200
     2.945    10.411     0.200
     3.126    10.770     0.200
     3.181     9.896     0.200
     3.206    10.568     0.200
     3.338    10.563     0.200
     3.338    10.710     0.200
     3.388    10.206     0.200
     3.630    11.650     0.200
     3.710    11.423     0.200
     3.749    11.774     0.200
     3.764    10.663     0.200
     3.759    11.436     0.200
     3.785    10.833     0.200
     3.969    11.481     0.200
     4.076    12.341     0.200
     4.146    12.107     0.200
     4.188    11.475     0.200
     4.306    12.457     0.200
     4.447    12.722     0.200
     4.498    12.404     0.200
     4.647    12.973     0.200
     4.644    13.764     0.200
     4.670    12.956     0.200
     4.885    12.910     0.200
     4.885    13.098     0.200
     4.939    13.661     0.200
     4.951    13.550     0.200
     4.962    13.637     0.200
     4.962    13.950     0.200
     4.992    13.677     0.200
     4.992    13.834     0.200
     5.011    14.340     0.200
     5.011    14.480     0.200
     5.150    14.459     0.200
     5.171    14.081     0.200
     5.237    14.177     0.200
     5.264    13.982     0.200
     5.319    14.642     0.200
     5.319    14.810     0.200
     5.362    14.646     0.200
     5.458    14.356     0.200
     5.464    14.670     0.200
     5.464    14.838     0.200
     5.469    15.171     0.200
     5.500    14.502     0.200
     5.560    15.582     0.200
     5.606    15.459     0.200
     5.757    14.928     0.200
     5.757    15.343     0.200
     5.763    15.094     0.200
     5.763    15.751     0.200
     5.848    15.215     0.200
     5.879    15.103     0.200
     5.879    15.612     0.200
     5.899    15.389     0.200
     5.901    15.303     0.200
     5.901    15.422     0.200
     5.970    15.344     0.200
     6.111    16.015     0.200
     6.215    16.323     0.200
     6.565    16.106     0.200
     6.591    17.775     0.200
     6.588    15.855     0.200
     6.658    17.195     0.200
     6.731    17.189     0.200
     6.731    17.319     0.200
     6.797    16.184     0.200
     6.841    16.873     0.200
     6.841    17.190     0.200
     6.939    17.289     0.200
     7.026    17.190     0.200
     7.070    17.074     0.200
     7.070    17.204     0.200
     7.070    17.246     0.200
     7.070    17.580     0.200
     7.081    17.258     0.200
     7.157    18.521     0.200
     7.244    17.612     0.200
     7.294    18.339     0.200
     7.412    18.277     0.200
     7.412    18.518     0.200
     7.605    18.385     0.200
     7.715    18.319     0.200
    11.856    28.601     0.200
    13.152    29.327     0.200
     0.052    17.196     0.200
     0.331    14.974     0.200
     0.360    14.602     0.200
     0.401    14.313     0.200
     0.484    13.590     0.200
     0.571    13.397     0.200
     0.651    12.785     0.200
     0.716    12.135     0.200
     0.889    11.934     0.200
     1.031    12.298     0.200
     1.069    11.895     0.200
     1.173    11.218     0.200
     1.250    11.312     0.200
     1.309    11.619     0.200
     1.342    11.468     0.200
     1.301    11.265     0.200
     1.542    10.758     0.200
     1.550    10.326     0.200
     1.550    10.478     0.200
     1.545    10.623     0.200
     1.593    11.002     0.200
     1.595    11.086     0.200
     1.658    11.304     0.200
     1.614    10.851     0.200
     1.721    10.106     0.200
     1.833    11.616     0.200
     1.854    10.658     0.200
     2.057    11.282     0.200
     2.092    10.930     0.200
     2.095    11.387     0.200
     2.098    11.531     0.200
     2.138    11.359     0.200
     2.141    11.459     0.200
     2.179    10.455     0.200
     2.226    11.493     0.200
     2.351    10.586     0.200
     2.426    10.568     0.200
     2.433    10.924     0.200
     2.871    12.179     0.200
     2.892    11.301     0.200
     2.901    10.686     0.200
     2.995    12.298     0.200
     3.017    11.903     0.200
     3.039    11.683     0.200
     3.208    12.336     0.200
     3.234    12.590     0.200
     3.326    12.834     0.200
     3.489    12.888     0.200
     3.501    13.070     0.200
     3.562    12.395     0.200
     3.711    13.631     0.200
     3.836    13.427     0.200
     3.903    12.903     0.200
     3.989    12.188     0.200
     4.082    13.270     0.200
     4.114    12.006     0.200
     4.248    12.406     0.200
     4.284    13.969     0.200
     4.309    12.408     0.200
     4.383    13.868     0.200
     4.431    15.985     0.200
     4.543    12.766     0.200
     4.700    14.556     0.200
     4.757    13.459     0.200
     4.932    13.817     0.200
     4.944    15.089     0.200
     5.030    14.107     0.200
     5.119    14.246     0.200
     5.202    14.043     0.200
     5.226    15.208     0.200
     5.253    15.157     0.200
     5.272    14.080     0.200
     5.284    14.832     0.200
     5.321    14.647     0.200
     5.523    15.761     0.200
     5.518    15.681     0.200
     5.536    15.329     0.200
     5.697    15.692     0.200
     5.745    14.752     0.200
     5.751    15.390     0.200
     5.831    15.681     0.200
     5.939    16.528     0.200
     6.033    17.182     0.200
     6.100    16.181     0.200
     6.094    16.173     0.200
     6.221    16.986     0.200
     6.222    17.654     0.200
     6.310    17.164     0.200
     6.315    16.000     0.200
     6.359    17.806     0.200
     6.548    16.007     0.200
     6.557    17.919     0.200
     6.656    16.002     0.200
     6.660    17.755     0.200
     6.664    16.687     0.200
     6.769    17.842     0.200
     6.871    16.187     0.200
     6.889    16.677     0.200
     6.946    17.871     0.200
     6.968    18.707     0.200
     6.993    17.096     0.200
     7.028    18.380     0.200
     7.044    16.979     0.200
     7.062    18.738     0.200
     7.098    18.952     0.200
     7.136    18.221     0.200
     7.197    17.031     0.200
     7.197    16.960     0.200
     7.197    16.851     0.200
     7.340    18.895     0.200
     7.354    17.326     0.200
     7.420    19.358     0.200
     7.470    17.930     0.200
     7.587    17.688     0.200
     7.753    19.898     0.200
     7.771    19.620     0.200
     7.782    19.646     0.200
     7.844    20.726     0.200
     7.887    18.448     0.200
     7.955    18.143     0.200
     8.052    19.050     0.200
     9.193    21.811     0.200
     9.933    20.677     0.200
     1.092     6.278     0.200
     1.811     9.096     0.200
     2.119     8.297     0.200
     2.119     8.418     0.200
     2.255    10.553     0.200
     2.255    10.799     0.200
     2.366    10.487     0.200
     2.398     9.638     0.200
     2.444    10.325     0.200
     2.781    11.133     0.200
     2.880    11.626     0.200
     2.902    12.415     0.200
     2.902    12.359     0.200
     2.995    10.497     0.200
     3.037    11.682     0.200
     3.027    11.301     0.200
     3.054    10.877     0.200
     3.221    12.258     0.200
     3.292    12.941     0.200
     3.447    11.376     0.200
     3.447    11.180     0.200
     3.621    11.481     0.200
     3.677    13.157     0.200
     3.787    12.800     0.200
     4.016    14.433     0.200
     4.094    12.412     0.200
     4.166    13.793     0.200
     4.184    14.458     0.200
     4.184    14.184     0.200
     4.391    13.626     0.200
     4.478    13.956     0.200
     4.490    13.609     0.200
     4.547    13.719     0.200
     4.636    14.778     0.200
     4.832    15.071     0.200
     4.832    14.505     0.200
     5.018    14.182     0.200
     5.061    14.961     0.200
     5.062    14.562     0.200
     5.062    14.226     0.200
     5.082    15.741     0.200
     5.113    15.806     0.200
     5.205    15.383     0.200
     5.266    14.987     0.200
     5.405    16.011     0.200
     5.481    15.753     0.200
     5.513    16.295     0.200
     5.578    15.767     0.200
     5.553    16.781     0.200
     5.638    16.612     0.200
     5.719    16.305     0.200
     5.757    16.559     0.200
     6.153    18.282     0.200
     6.214    17.344     0.200
     6.227    17.327     0.200
     6.286    17.440     0.200
     6.324    17.443     0.200
     6.348    17.626     0.200
     6.362    17.945     0.200
     6.428    18.695     0.200
     6.584    18.205     0.200
     6.607    18.364     0.200
     6.636    18.708     0.200
     6.671    19.207     0.200
     6.740    17.983     0.200
     6.803    18.472     0.200
     6.943    19.703     0.200
     7.060    19.946     0.200
     7.105    19.790     0.200
     7.105    19.790     0.200
     7.142    19.501     0.200
     7.346    19.107     0.200
     7.367    20.502     0.200
     7.823    22.164     0.200
     7.845    22.623     0.200
     7.957    20.368     0.200
     8.055    22.275     0.200
     8.060    21.825     0.200
     8.162    21.020     0.200
     8.287    20.932     0.200
     8.301    22.875     0.200
     8.374    21.427     0.200
     8.409    21.823     0.200
     8.411    21.422     0.200
    14.320    34.519     0.200
    19.633    39.131     0.200
     0.855     3.817     0.200
     1.144     6.390     0.200
     1.821     8.044     0.200
     2.313     7.501     0.200
     2.313     7.841     0.200
     2.470     9.745     0.200
     2.739    11.138     0.200
     2.739    10.974     0.200
     3.224    10.906     0.200
     3.224    10.645     0.200
     3.489    12.316     0.200
     3.489    12.412     0.200
     3.489    12.205     0.200
     3.611    10.780     0.200
     3.681    12.014     0.200
     3.681    11.893     0.200
     3.692    12.245     0.200
     3.724    12.831     0.200
     3.724    12.523     0.200
     3.972    13.570     0.200
     3.989    12.923     0.200
     3.986    11.996     0.200
     3.988    12.325     0.200
     3.988    12.743     0.200
     4.331    14.490     0.200
     4.611    14.652     0.200
     4.611    14.405     0.200
     4.658    12.648     0.200
     4.847    14.715     0.200
     4.900    14.889     0.200
     4.942    14.588     0.200
     5.111    15.197     0.200
     5.428    15.043     0.200
     5.428    15.652     0.200
     5.571    16.095     0.200
     5.571    16.275     0.200
     5.596    14.995     0.200
     5.704    16.430     0.200
     5.712    17.153     0.200
     5.712    17.035     0.200
     5.950    16.535     0.200
     5.950    16.831     0.200
     5.951    16.228     0.200
     5.990    17.052     0.200
     5.990    17.353     0.200
     6.011    16.262     0.200
     6.020    16.275     0.200
     6.239    16.422     0.200
     6.284    17.638     0.200
     6.388    17.105     0.200
     6.388    17.702     0.200
     6.672    18.081     0.200
     6.783    18.215     0.200
     6.783    18.324     0.200
     6.791    18.552     0.200
     6.791    18.681     0.200
     6.940    17.862     0.200
     7.163    19.003     0.200
     7.163    19.151     0.200
     7.183    18.968     0.200
     7.197    18.800     0.200
     7.308    19.240     0.200
     7.308    19.630     0.200
     7.527    20.377     0.200
     7.527    19.689     0.200
     7.538    19.083     0.200
     7.711    20.134     0.200
     7.801    20.382     0.200
     7.873    19.804     0.200
     8.075    20.631     0.200
     8.105    21.744     0.200
     8.169    20.959     0.200
     8.824    21.395     0.200
     8.977    22.249     0.200
     8.977    22.776     0.200
     9.010    21.981     0.200
     9.034    22.438     0.200
     9.062    21.864     0.200
     9.254    22.931     0.200
     9.274    22.815     0.200
     9.314    23.317     0.200
     9.314    23.333     0.200
     9.499    23.414     0.200
     9.804    23.991     0.200
    10.245    25.432     0.200
    10.721    26.949     0.200
    11.233    26.264     0.200
    13.262    33.677     0.200
    15.381    36.822     0.200
    15.381    36.658     0.200
    19.910    38.169     0.200
     0.579     5.251     0.200
     1.146     6.998     0.200
     1.257     5.968     0.200
     1.341     7.085     0.200
     1.434     7.393     0.200
     1.434     7.581     0.200
     1.579     8.057     0.200
     1.579     7.932     0.200
     1.623     6.978     0.200
     1.608     7.256     0.200
     1.889     8.589     0.200
     2.082     7.565     0.200
     2.082     8.126     0.200
     2.082     7.962     0.200
     2.262     7.681     0.200
     2.262     7.564     0.200
     2.276     8.859     0.200
     2.325     8.897     0.200
     2.355     8.646     0.200
     2.516     8.830     0.200
     2.570     9.963     0.200
     2.900    10.026     0.200
     2.957     9.494     0.200
     2.979     9.517     0.200
     2.980     9.665     0.200
     3.042    10.145     0.200
     3.068     9.617     0.200
     3.068     9.726     0.200
     3.128    10.139     0.200
     3.128     8.967     0.200
     3.132    10.171     0.200
     3.157     9.101     0.200
     3.200    10.036     0.200
     3.292    10.531     0.200
     3.292    10.179     0.200
     3.423    11.063     0.200
     3.423    10.891     0.200
     3.633    10.490     0.200
     3.647    10.546     0.200
     3.642    11.051     0.200
     3.711    11.407     0.200
     3.763    11.307     0.200
     3.912    11.236     0.200
     3.912    11.126     0.200
     3.886    12.015     0.200
     4.008    11.686     0.200
     4.030    12.241     0.200
     4.254    12.317     0.200
     4.224    12.655     0.200
     4.262    12.609     0.200
     4.262    12.742     0.200
     4.369    12.784     0.200
     4.448    12.401     0.200
     4.613    12.785     0.200
     4.613    12.550     0.200
     4.680    13.602     0.200
     4.824    13.792     0.200
     4.824    13.225     0.200
     4.898    13.538     0.200
     4.994    13.527     0.200
     5.126    14.480     0.200
     5.126    14.308     0.200
     5.197    13.930     0.200
     5.203    14.042     0.200
     5.203    13.542     0.200
     5.248    14.292     0.200
     5.294    14.385     0.200
     5.344    14.620     0.200
     5.363    14.898     0.200
     5.484    14.521     0.200
     5.526    17.086     0.200
     5.710    15.017     0.200
     5.703    15.490     0.200
     5.903    15.102     0.200
     5.903    14.931     0.200
     6.275    16.188     0.200
     6.386    17.352     0.200
     6.475    16.895     0.200
     6.474    16.938     0.200
     6.503    17.333     0.200
     6.524    15.985     0.200
     6.631    16.849     0.200
     6.637    17.181     0.200
     6.747    17.446     0.200
     6.843    17.161     0.200
     6.899    17.482     0.200
     6.923    17.478     0.200
     6.918    17.409     0.200
     6.940    18.097     0.200
     6.935    17.823     0.200
     6.937    17.951     0.200
     6.937    17.381     0.200
     6.971    17.252     0.200
     6.983    17.242     0.200
     6.983    17.101     0.200
     7.043    17.501     0.200
     7.379    20.698     0.200
     7.390    19.373     0.200
     7.450    18.370     0.200
     7.462    18.381     0.200
     7.768    19.775     0.200
     7.768    18.931     0.200
     7.825    19.135     0.200
     7.902    19.893     0.200
     8.154    20.121     0.200
     8.325    20.534     0.200
     8.404    20.741     0.200
     8.645    20.807     0.200
     8.683    21.096     0.200
     8.683    21.612     0.200
     8.960    22.460     0.200
     8.971    19.092     0.200
     8.971    20.842     0.200
     9.003    22.369     0.200
     9.003    21.408     0.200
     9.040    23.049     0.200
     9.061    21.222     0.200
     9.239    20.727     0.200
     9.270    22.439     0.200
     9.270    22.095     0.200
     9.569    23.411     0.200
     9.808    23.645     0.200
     9.978    24.785     0.200
    10.046    24.490     0.200
    11.493    27.581     0.200
    16.387    34.046     0.200
    17.524    34.982     0.200
    18.741    36.524     0.200
     0.569     8.937     0.200
     0.930     8.412     0.200
     0.930     8.532     0.200
     1.109     7.877     0.200
     1.140     7.687     0.200
     1.311     7.930     0.200
     1.672     9.103     0.200
     1.672     9.038     0.200
     1.759     8.548     0.200
     2.072     8.944     0.200
     2.072     9.090     0.200
     2.194     9.885     0.200
     2.221     9.511     0.200
     2.508     9.392     0.200
     2.512    10.146     0.200
     2.558     9.477     0.200
     2.624    10.456     0.200
     2.689    10.427     0.200
     3.019    10.595     0.200
     3.163    12.357     0.200
     3.163    11.769     0.200
     3.257    10.278     0.200
     3.292    10.359     0.200
     3.299    11.262     0.200
     3.418    10.629     0.200
     3.418    11.299     0.200
     3.737    12.443     0.200
     3.784    12.397     0.200
     3.784    11.973     0.200
     3.829    12.244     0.200
     3.829    12.669     0.200
     3.845    11.705     0.200
     3.845    11.925     0.200
     3.856    12.473     0.200
     3.856    12.582     0.200
     4.065    12.680     0.200
     4.147    12.434     0.200
     4.147    12.637     0.200
     4.186    12.072     0.200
     4.261    12.356     0.200
     4.373    13.183     0.200
     4.417    12.268     0.200
     4.417    12.588     0.200
     4.508    12.303     0.200
     4.508    12.940     0.200
     4.619    12.676     0.200
     4.787    14.105     0.200
     4.832    13.332     0.200
     4.832    13.711     0.200
     4.867    14.692     0.200
     4.921    14.681     0.200
     5.118    14.182     0.200
     5.189    13.886     0.200
     5.247    15.650     0.200
     5.247    14.807     0.200
     5.374    14.717     0.200
     5.441    15.382     0.200
     5.441    15.170     0.200
     5.507    14.729     0.200
     5.507    14.957     0.200
     5.597    14.448     0.200
     5.729    15.123     0.200
     5.780    15.661     0.200
     5.804    15.002     0.200
     5.804    15.297     0.200
     6.104    16.306     0.200
     6.248    16.341     0.200
     6.341    16.430     0.200
     6.357    16.521     0.200
     6.367    16.633     0.200
     6.421    16.505     0.200
     6.601    17.495     0.200
     6.674    17.195     0.200
     6.804    17.410     0.200
     6.848    17.480     0.200
     7.163    17.538     0.200
     7.163    17.312     0.200
     7.177    17.493     0.200
     7.281    17.152     0.200
     7.291    16.221     0.200
     7.344    18.024     0.200
     7.344    18.298     0.200
     7.435    16.624     0.200
     7.596    18.464     0.200
     7.601    16.872     0.200
     7.780    18.764     0.200
     7.781    18.035     0.200
     7.957    20.642     0.200
     7.971    19.137     0.200
     7.971    20.149     0.200
     7.989    19.173     0.200
     7.999    19.874     0.200
     8.041    20.453     0.200
     8.282    20.269     0.200
     8.989    20.965     0.200
     1.348     7.515     0.200
     1.807     8.792     0.200
     1.988     9.040     0.200
     2.149     8.810     0.200
     2.221     8.598     0.200
     2.340     9.514     0.200
     2.427     9.945     0.200
     2.440    10.412     0.200
     2.619     9.317     0.200
     2.599     9.828     0.200
     2.622     9.612     0.200
     2.622     9.854     0.200
     2.701    10.125     0.200
     2.758    10.437     0.200
     2.828    10.984     0.200
     2.849     9.532     0.200
     2.907    10.950     0.200
     3.000    10.806     0.200
     3.115    10.890     0.200
     3.221     9.777     0.200
     3.214    10.870     0.200
     3.345    11.656     0.200
     3.432    10.857     0.200
     3.480     9.979     0.200
     3.480    11.752     0.200
     3.499    10.806     0.200
     3.542    11.919     0.200
     3.566    12.786     0.200
     3.566    12.434     0.200
     3.727    12.409     0.200
     3.727    12.518     0.200
     3.763    10.885     0.200
     3.829    10.915     0.200
     3.829    10.751     0.200
     3.833    11.004     0.200
     3.833    10.832     0.200
     3.822    12.477     0.200
     3.931    12.739     0.200
     3.948    12.235     0.200
     4.040    12.625     0.200
     4.062    12.165     0.200
     4.154    12.122     0.200
     4.190    12.793     0.200
     4.190    13.067     0.200
     4.290    12.649     0.200
     4.290    12.821     0.200
     4.609    12.912     0.200
     4.638    12.957     0.200
     4.638    12.856     0.200
     4.641    13.120     0.200
     4.636    14.667     0.200
     4.649    13.696     0.200
     4.649    13.931     0.200
     4.744    13.302     0.200
     4.744    13.145     0.200
     4.748    14.047     0.200
     4.748    13.742     0.200
     4.769    14.156     0.200
     4.843    13.624     0.200
     4.922    12.641     0.200
     4.922    13.016     0.200
     4.922    12.766     0.200
     4.991    13.826     0.200
     5.111    14.566     0.200
     5.093    14.825     0.200
     5.137    14.392     0.200
     5.241    15.199     0.200
     5.241    15.004     0.200
     5.260    16.176     0.200
     5.260    14.598     0.200
     5.288    15.544     0.200
     5.359    14.943     0.200
     5.359    14.732     0.200
     5.612    14.129     0.200
     5.770    16.472     0.200
     5.770    15.987     0.200
     5.875    15.885     0.200
     5.875    16.627     0.200
     5.972    16.284     0.200
     6.045    16.490     0.200
     6.044    16.374     0.200
     6.176    16.137     0.200
     6.176    16.652     0.200
     6.172    17.043     0.200
     6.172    16.785     0.200
     6.298    17.809     0.200
     6.305    17.148     0.200
     6.305    16.648     0.200
     6.314    16.734     0.200
     6.378    17.080     0.200
     6.398    18.042     0.200
     6.671    18.291     0.200
     6.640    18.058     0.200
     6.657    17.486     0.200
     6.657    16.939     0.200
     6.676    18.228     0.200
     6.670    17.732     0.200
     6.670    17.631     0.200
     6.702    18.316     0.200
     6.702    17.956     0.200
     6.907    17.985     0.200
     6.907    18.727     0.200
     6.890    17.638     0.200
     6.890    18.247     0.200
     6.973    18.860     0.200
     6.973    18.672     0.200
     7.029    19.036     0.200
     7.029    19.435     0.200
     7.071    19.140     0.200
     7.131    18.294     0.200
     7.160    19.003     0.200
     7.186    19.137     0.200
     7.201    18.939     0.200
     7.201    18.829     0.200
     7.309    20.092     0.200
     7.309    20.396     0.200
     7.310    19.643     0.200
     7.335    19.524     0.200
     7.471    19.529     0.200
     7.471    19.779     0.200
     7.540    20.428     0.200
     7.520    19.089     0.200
     7.522    19.057     0.200
     7.592    21.038     0.200
     7.592    21.360     0.200
     7.633    20.170     0.200
     7.633    21.248     0.200
     7.743    20.736     0.200
     7.726    19.031     0.200
     7.769    20.575     0.200
     7.820    19.941     0.200
     7.820    20.441     0.200
     7.836    20.191     0.200
     7.821    20.028     0.200
     7.831    19.740     0.200
     7.880    20.093     0.200
     7.934    20.463     0.200
     7.936    20.310     0.200
     7.936    20.568     0.200
     7.945    20.099     0.200
     7.945    20.349     0.200
     7.970    19.397     0.200
     7.979    19.966     0.200
     7.979    19.294     0.200
     7.979    20.216     0.200
     7.985    20.579     0.200
     8.039    20.198     0.200
     8.078    20.978     0.200
     8.106    22.613     0.200
     8.210    20.384     0.200
     8.224    20.809     0.200
     8.224    19.739     0.200
     8.433    21.465     0.200
     8.433    20.519     0.200
     8.417    20.983     0.200
     8.417    20.725     0.200
     8.442    21.532     0.200
     8.442    21.149     0.200
     8.425    20.845     0.200
     8.425    20.345     0.200
     8.502    21.682     0.200
     8.675    21.111     0.200
     8.678    22.540     0.200
     8.690    22.263     0.200
     8.672    21.639     0.200
     8.692    21.367     0.200
     8.692    21.140     0.200
     8.727    19.721     0.200
     8.727    20.603     0.200
     8.775    21.889     0.200
     8.841    21.871     0.200
     8.858    22.740     0.200
     8.858    21.865     0.200
     8.896    22.622     0.200
     8.896    22.161     0.200
     9.080    22.456     0.200
     9.173    23.394     0.200
     9.203    23.728     0.200
     9.203    23.900     0.200
     9.187    23.131     0.200
     9.187    22.967     0.200
     9.247    21.299     0.200
     9.247    21.103     0.200
     9.270    23.528     0.200
     9.270    23.348     0.200
     9.304    23.841     0.200
     9.304    23.614     0.200
     9.300    23.026     0.200
     9.395    24.168     0.200
     9.433    23.237     0.200
     9.439    24.053     0.200
     9.542    22.970     0.200
     9.598    23.785     0.200
     9.645    23.359     0.200
     9.670    24.933     0.200
     9.670    25.074     0.200
     9.714    23.911     0.200
     9.737    23.680     0.200
     9.798    24.319     0.200
     9.815    24.672     0.200
     9.907    24.954     0.200
     9.967    24.368     0.200
    10.035    24.740     0.200
    10.008    23.939     0.200
    10.048    24.507     0.200
    10.288    26.028     0.200
    10.288    26.200     0.200
    10.304    25.485     0.200
    10.304    24.993     0.200
    10.281    25.994     0.200
    10.332    25.613     0.200
    10.492    24.922     0.200
    10.497    24.528     0.200
    10.556    25.051     0.200
    10.556    24.833     0.200
    10.570    25.432     0.200
    10.629    24.329     0.200
    10.745    26.494     0.200
    10.773    26.434     0.200
    10.805    24.108     0.200
    10.805    23.866     0.200
    10.788    25.086     0.200
    10.805    25.988     0.200
    10.810    25.535     0.200
    10.979    25.787     0.200
    10.979    25.506     0.200
    10.990    25.892     0.200
    11.116    26.607     0.200
    11.143    28.443     0.200
    11.143    27.490     0.200
    11.319    26.771     0.200
    11.392    27.637     0.200
    11.487    27.248     0.200
    11.667    26.662     0.200
    11.700    28.980     0.200
    11.769    27.786     0.200
    11.817    28.399     0.200
    11.841    28.844     0.200
    11.931    29.222     0.200
    11.931    29.472     0.200
    11.931    28.699     0.200
    11.998    28.464     0.200
    12.031    28.119     0.200
    11.988    28.455     0.200
    12.271    29.847     0.200
    12.329    28.645     0.200
    12.386    30.849     0.200
    12.605    28.853     0.200
    12.754    29.416     0.200
    12.971    30.508     0.200
    13.103    29.031     0.200
    13.154    31.453     0.200
    13.107    30.037     0.200
    13.293    30.911     0.200
    13.940    32.336     0.200
    13.940    31.625     0.200
    13.940    32.047     0.200
    15.067    32.893     0.200
    15.332    33.636     0.200
    17.314    35.152     0.200
     0.461     4.785     0.200
     1.069     6.050     0.200
     1.507     6.498     0.200
     1.623     7.329     0.200
     1.766     7.914     0.200
     1.847     8.042     0.200
     1.847     8.676     0.200
     1.938     7.361     0.200
     2.085     7.280     0.200
     2.372     8.194     0.200
     2.372     8.479     0.200
     2.508     6.776     0.200
     2.828     8.722     0.200
     2.863    10.201     0.200
     2.872    10.233     0.200
     2.872    10.506     0.200
     2.933     9.806     0.200
     3.105    10.470     0.200
     3.104    10.410     0.200
     3.104    10.536     0.200
     3.086    10.728     0.200
     3.160     9.748     0.200
     3.174    10.333     0.200
     3.264     9.771     0.200
     3.442    11.661     0.200
     3.564    11.872     0.200
     3.727    12.077     0.200
     3.871    10.662     0.200
     3.871    10.891     0.200
     3.967    11.551     0.200
     3.982    13.266     0.200
     3.982    12.938     0.200
     3.967    12.215     0.200
     3.967    10.940     0.200
     4.078    12.237     0.200
     4.083    11.817     0.200
     4.161    12.242     0.200
     4.225    12.339     0.200
     4.225    12.939     0.200
     4.555    13.303     0.200
     4.589    13.201     0.200
     4.589    12.867     0.200
     4.637    11.831     0.200
     4.701    13.645     0.200
     4.701    13.448     0.200
     4.717    14.254     0.200
     4.818    13.898     0.200
     4.818    14.084     0.200
     4.820    14.728     0.200
     4.820    14.547     0.200
     4.806    13.039     0.200
     5.065    14.111     0.200
     5.065    13.959     0.200
     5.109    14.315     0.200
     5.109    15.047     0.200
     5.171    13.359     0.200
     5.171    13.570     0.200
     5.203    13.641     0.200
     5.395    15.508     0.200
     5.561    14.966     0.200
     5.561    15.146     0.200
     5.547    14.310     0.200
     5.547    14.761     0.200
     5.547    14.167     0.200
     5.660    16.975     0.200
     5.660    15.088     0.200
     5.718    15.184     0.200
     5.892    16.223     0.200
     5.892    16.590     0.200
     5.867    15.405     0.200
     5.867    15.590     0.200
     5.924    16.350     0.200
     5.924    16.770     0.200
     5.891    15.615     0.200
     6.077    15.601     0.200
     6.077    15.985     0.200
     6.275    17.049     0.200
     6.275    16.870     0.200
     6.417    16.608     0.200
     6.417    17.237     0.200
     6.430    16.544     0.200
     6.430    17.325     0.200
     6.645    17.196     0.200
     6.645    17.682     0.200
     6.661    17.717     0.200
     6.631    17.155     0.200
     6.631    16.813     0.200
     6.840    17.757     0.200
     6.860    17.616     0.200
     6.835    17.679     0.200
     6.859    17.571     0.200
     6.977    18.436     0.200
     7.124    18.093     0.200
     7.124    18.331     0.200
     7.119    18.815     0.200
     7.119    18.381     0.200
     7.186    18.119     0.200
     7.186    18.266     0.200
     7.170    18.109     0.200
     7.228    18.031     0.200
     7.249    18.362     0.200
     7.298    18.069     0.200
     7.298    18.241     0.200
     7.448    18.201     0.200
     7.535    19.512     0.200
     7.588    18.697     0.200
     7.635    19.217     0.200
     7.638    18.844     0.200
     7.720    19.879     0.200
     7.720    19.260     0.200
     7.787    19.717     0.200
     7.787    19.939     0.200
     7.762    17.351     0.200
     7.762    17.765     0.200
     7.728    18.909     0.200
     7.875    20.625     0.200
     7.829    19.023     0.200
     7.829    19.082     0.200
     7.904    17.928     0.200
     7.904    18.235     0.200
     7.953    18.671     0.200
     8.006    21.309     0.200
     8.006    21.453     0.200
     8.075    20.245     0.200
     8.120    19.621     0.200
     8.120    19.387     0.200
     8.119    20.213     0.200
     8.078    20.229     0.200
     8.111    21.000     0.200
     8.111    20.746     0.200
     8.092    19.526     0.200
     8.170    19.838     0.200
     8.170    19.596     0.200
     8.164    18.794     0.200
     8.144    19.210     0.200
     8.144    19.759     0.200
     8.144    19.507     0.200
     8.229    19.940     0.200
     8.364    19.628     0.200
     8.364    20.398     0.200
     8.364    19.497     0.200
     8.378    19.739     0.200
     8.390    19.320     0.200
     8.390    19.590     0.200
     8.377    21.273     0.200
     8.452    18.888     0.200
     8.464    21.254     0.200
     8.499    19.873     0.200
     8.499    20.767     0.200
     8.537    20.731     0.200
     8.554    20.842     0.200
     8.554    21.155     0.200
     8.607    20.953     0.200
     8.607    20.841     0.200
     8.660    20.453     0.200
     8.660    20.342     0.200
     8.694    21.560     0.200
     8.779    20.471     0.200
     8.917    21.278     0.200
     9.018    21.150     0.200
     8.986    23.753     0.200
     9.114    23.121     0.200
     9.114    22.187     0.200
     9.274    22.203     0.200
     9.274    22.768     0.200
     9.251    21.902     0.200
     9.251    21.386     0.200
     9.387    22.777     0.200
     9.387    22.408     0.200
     9.344    22.786     0.200
     9.452    23.116     0.200
     9.439    23.606     0.200
     9.519    23.447     0.200
     9.634    23.230     0.200
     9.651    21.489     0.200
     9.762    22.623     0.200
     9.762    22.226     0.200
     9.729    22.737     0.200
     9.830    21.958     0.200
     9.925    23.377     0.200
     9.973    23.462     0.200
    10.000    23.401     0.200
    10.034    23.914     0.200
    10.118    22.282     0.200
    10.161    23.457     0.200
    10.160    24.227     0.200
    10.160    25.127     0.200
    10.160    23.037     0.200
    10.321    23.188     0.200
    10.321    23.001     0.200
    10.275    24.185     0.200
    10.275    24.728     0.200
    10.366    23.051     0.200
    10.335    25.061     0.200
    10.391    22.911     0.200
    10.400    23.825     0.200
    10.481    25.517     0.200
    10.587    24.759     0.200
    10.575    24.424     0.200
    10.742    26.307     0.200
    10.838    24.486     0.200
    10.907    24.752     0.200
    10.984    25.495     0.200
    10.991    25.172     0.200
    11.122    25.332     0.200
    11.092    26.217     0.200
    11.185    24.835     0.200
    11.222    24.967     0.200
    11.181    26.317     0.200
    11.212    26.685     0.200
    11.212    26.935     0.200
    11.305    24.749     0.200
    11.334    25.828     0.200
    11.566    26.016     0.200
    11.546    26.277     0.200
    11.697    26.567     0.200
    11.655    27.125     0.200
    11.655    27.567     0.200
    11.718    25.094     0.200
    12.006    26.705     0.200
    12.365    29.405     0.200
    12.365    29.054     0.200
    12.482    28.688     0.200
    12.734    26.525     0.200
    12.887    27.405     0.200
    12.917    28.304     0.200
    12.903    30.026     0.200
    12.903    30.327     0.200
    13.373    29.671     0.200
    13.475    29.958     0.200
    13.955    29.306     0.200
    14.317    29.720     0.200
    14.570    31.787     0.200
    14.570    32.795     0.200
    14.570    31.111     0.200
    15.872    33.110     0.200
    16.315    34.842     0.200
    17.997    35.605     0.200
    17.997    34.195     0.200
    19.077    36.537     0.200
    19.387    37.168     0.200
     0.429     4.948     0.200
     0.429     5.116     0.200
     0.871     5.666     0.200
     0.871     5.807     0.200
     1.303     6.531     0.200
     1.332     6.412     0.200
     1.373     6.717     0.200
     1.503     7.318     0.200
     1.562     7.336     0.200
     1.562     7.737     0.200
     1.910     7.524     0.200
     1.929     7.854     0.200
     2.112     7.718     0.200
     2.313     9.422     0.200
     2.312     9.806     0.200
     2.312     9.391     0.200
     2.554     8.743     0.200
     2.554     8.862     0.200
     2.599     9.802     0.200
     2.599     9.956     0.200
     2.673     9.119     0.200
     2.647     8.641     0.200
     2.802    10.480     0.200
     2.897     9.436     0.200
     2.916     9.746     0.200
     3.156    11.504     0.200
     3.448    11.391     0.200
     3.699    10.917     0.200
     3.703    12.752     0.200
     3.810    11.888     0.200
     3.821    11.035     0.200
     3.941    11.995     0.200
     4.318    12.249     0.200
     4.421    13.098     0.200
     4.421    12.933     0.200
     4.552    12.379     0.200
     4.780    13.657     0.200
     4.901    12.452     0.200
     4.939    12.807     0.200
     4.939    13.015     0.200
     5.106    13.855     0.200
     5.293    14.076     0.200
     5.327    13.430     0.200
     5.606    16.357     0.200
     5.607    15.031     0.200
     5.607    14.916     0.200
     5.652    14.438     0.200
     5.656    14.396     0.200
     5.834    15.283     0.200
     5.993    17.070     0.200
     5.993    15.795     0.200
     6.045    15.770     0.200
     6.131    17.682     0.200
     6.131    16.332     0.200
     6.174    16.965     0.200
     6.360    17.144     0.200
     6.376    16.568     0.200
     6.396    16.564     0.200
     6.608    16.902     0.200
     6.640    16.789     0.200
     6.724    17.605     0.200
     6.842    16.149     0.200
     6.900    18.543     0.200
     6.899    16.391     0.200
     6.965    17.447     0.200
     7.021    17.790     0.200
     7.037    17.260     0.200
     7.332    18.221     0.200
     7.620    20.070     0.200
     7.671    18.006     0.200
     7.756    20.249     0.200
     7.809    18.243     0.200
     7.834    19.568     0.200
     7.841    19.448     0.200
     7.884    19.341     0.200
     8.095    19.011     0.200
     8.173    19.026     0.200
     8.173    19.736     0.200
     8.173    20.266     0.200
     8.236    20.240     0.200
     8.329    20.451     0.200
     8.632    22.457     0.200
     9.060    22.293     0.200
     9.109    21.613     0.200
     9.164    22.488     0.200
     9.666    21.944     0.200
    10.018    23.461     0.200
    10.530    26.225     0.200
    10.971    24.740     0.200
    10.982    26.592     0.200
    11.458    26.405     0.200
    14.306    34.713     0.200
    14.306    33.602     0.200
    17.740    35.885     0.200
    18.805    36.225     0.200
     1.359     8.579     0.200
     1.371    10.274     0.200
     1.484     9.642     0.200
     1.881    10.274     0.200
     1.931     9.967     0.200
     2.210    11.418     0.200
     2.386    11.750     0.200
     2.393    11.151     0.200
     2.548    11.603     0.200
     2.708    12.072     0.200
     2.665    12.118     0.200
     2.759    12.625     0.200
     2.826    13.580     0.200
     2.826    12.354     0.200
     3.165    13.624     0.200
     3.203    13.801     0.200
     3.227    14.465     0.200
     3.250    13.070     0.200
     3.338    14.370     0.200
     3.366    13.926     0.200
     3.366    13.375     0.200
     3.578    14.330     0.200
     3.650    15.029     0.200
     3.693    16.166     0.200
     3.693    15.928     0.200
     3.930    14.540     0.200
     3.930    14.098     0.200
     4.013    14.336     0.200
     4.025    15.953     0.200
     4.085    15.152     0.200
     4.085    14.781     0.200
     4.266    17.039     0.200
     4.437    16.916     0.200
     4.461    15.983     0.200
     4.461    15.831     0.200
     4.531    17.010     0.200
     4.531    16.413     0.200
     4.536    16.407     0.200
     4.536    16.173     0.200
     4.566    16.161     0.200
     4.718    16.438     0.200
     4.728    16.608     0.200
     4.843    16.025     0.200
     4.843    16.272     0.200
     4.861    17.111     0.200
     4.969    17.587     0.200
     4.969    16.966     0.200
     4.970    15.882     0.200
     4.974    16.140     0.200
     5.059    17.407     0.200
     5.112    17.492     0.200
     5.112    16.934     0.200
     5.112    16.641     0.200
     5.188    17.508     0.200
     5.188    16.934     0.200
     5.315    18.168     0.200
     5.500    18.709     0.200
     5.362    20.567     0.200
     5.522    18.000     0.200
     5.522    18.277     0.200
     5.628    20.445     0.200
     5.628    19.813     0.200
     5.705    18.314     0.200
     5.708    18.131     0.200
     5.708    17.983     0.200
     5.708    17.842     0.200
     5.866    19.199     0.200
     5.866    18.699     0.200
     5.927    18.974     0.200
     5.999    18.440     0.200
     6.146    20.347     0.200
     6.146    20.452     0.200
     6.151    19.164     0.200
     6.275    20.189     0.200
     6.275    19.349     0.200
     6.432    21.718     0.200
     6.443    20.857     0.200
     6.451    20.066     0.200
     6.572    20.411     0.200
     6.734    20.484     0.200
     6.745    19.985     0.200
     6.941    21.451     0.200
     6.962    21.974     0.200
     6.962    20.974     0.200
     7.008    21.583     0.200
     7.253    22.410     0.200
     7.275    21.622     0.200
     7.286    21.196     0.200
     7.286    21.497     0.200
     7.356    21.659     0.200
     7.430    22.275     0.200
     7.709    22.486     0.200
     7.809    23.604     0.200
     7.806    22.881     0.200
     7.858    23.583     0.200
     7.850    22.885     0.200
     7.864    23.301     0.200
     7.864    23.461     0.200
     7.875    23.147     0.200
     7.993    22.874     0.200
     7.993    22.491     0.200
     8.037    23.473     0.200
     8.037    23.895     0.200
     8.045    24.586     0.200
     8.118    23.158     0.200
     8.118    22.966     0.200
     8.171    23.585     0.200
     8.171    23.901     0.200
     8.193    23.051     0.200
     8.195    24.253     0.200
     8.195    23.222     0.200
     8.223    23.939     0.200
     8.285    24.024     0.200
     8.314    23.399     0.200
     8.314    23.000     0.200
     8.321    24.038     0.200
     8.236    24.901     0.200
     8.236    24.452     0.200
     8.395    23.390     0.200
     8.471    23.851     0.200
     8.471    23.992     0.200
     8.467    23.581     0.200
     8.467    23.245     0.200
     8.495    25.016     0.200
     8.495    24.242     0.200
     8.555    24.711     0.200
     8.555    24.398     0.200
     8.550    24.933     0.200
     8.567    24.466     0.200
     8.624    24.775     0.200
     8.624    24.435     0.200
     8.630    24.414     0.200
     8.679    25.927     0.200
     8.696    25.001     0.200
     8.779    25.025     0.200
     8.978    25.718     0.200
     8.978    25.327     0.200
     8.982    25.325     0.200
     9.054    25.762     0.200
     9.054    25.148     0.200
     9.108    25.136     0.200
     9.126    26.169     0.200
     9.210    27.496     0.200
     9.084    27.099     0.200
     9.229    25.941     0.200
     9.256    25.160     0.200
     9.256    25.453     0.200
     9.298    25.022     0.200
     9.298    24.819     0.200
     9.564    25.068     0.200
     9.609    26.401     0.200
     9.627    25.483     0.200
     9.680    27.152     0.200
     9.692    26.112     0.200
     9.748    26.914     0.200
     9.816    26.236     0.200
     9.909    25.494     0.200
     9.918    27.750     0.200
     9.918    26.449     0.200
     9.961    26.084     0.200
     9.981    26.829     0.200
    10.044    26.108     0.200
    10.092    27.813     0.200
    10.092    27.501     0.200
    10.074    25.906     0.200
    10.100    27.222     0.200
    10.161    26.847     0.200
    10.162    28.625     0.200
    10.162    28.067     0.200
    10.208    27.603     0.200
    10.210    27.950     0.200
    10.277    27.855     0.200
    10.348    28.001     0.200
    10.447    28.157     0.200
    10.447    28.013     0.200
    10.510    27.070     0.200
    10.510    29.043     0.200
    10.575    28.120     0.200
    10.575    28.327     0.200
    10.604    27.256     0.200
    10.683    29.199     0.200
    10.758    29.466     0.200
    10.805    29.702     0.200
    10.832    29.582     0.200
    10.843    28.117     0.200
    10.909    28.828     0.200
    10.954    29.376     0.200
    11.029    28.505     0.200
    11.016    28.950     0.200
    11.050    29.589     0.200
    11.083    29.479     0.200
    11.204    31.146     0.200
    11.204    29.634     0.200
    11.225    30.120     0.200
    11.225    29.612     0.200
    11.236    30.212     0.200
    11.336    29.680     0.200
    11.398    29.150     0.200
    11.394    29.716     0.200
    11.394    29.845     0.200
    11.514    29.205     0.200
    11.702    31.925     0.200
    11.788    30.463     0.200
    11.817    29.276     0.200
    11.817    30.519     0.200
    11.873    30.560     0.200
    11.873    31.131     0.200
    12.086    31.454     0.200
    12.084    30.084     0.200
    12.272    28.922     0.200
    12.342    31.592     0.200
    12.358    31.762     0.200
    12.494    32.407     0.200
    12.606    32.112     0.200
    12.739    31.967     0.200
    12.782    32.479     0.200
    12.893    33.094     0.200
    12.908    32.878     0.200
    13.167    33.526     0.200
    13.246    33.646     0.200
    13.295    34.339     0.200
    13.295    33.690     0.200
    13.295    34.870     0.200
    13.418    36.227     0.200
    13.824    36.561     0.200
    13.926    33.484     0.200
    13.926    34.620     0.200
    13.942    34.097     0.200
    14.529    34.987     0.200
    14.529    35.358     0.200
    16.196    39.072     0.200
    16.529    39.795     0.200
    17.994    39.019     0.200
    17.994    39.410     0.200
     1.353     9.556     0.200
     1.418     9.398     0.200
     1.581     9.155     0.200
     1.810    10.201     0.200
     1.858     9.671     0.200
     1.858     9.917     0.200
     2.150    11.163     0.200
     2.218    10.348     0.200
     2.218    11.867     0.200
     2.324    11.464     0.200
     2.477    11.318     0.200
     2.599    11.826     0.200
     2.646    11.630     0.200
     2.690    11.838     0.200
     2.690    12.315     0.200
     2.777    12.281     0.200
     2.777    13.734     0.200
     2.826    12.694     0.200
     2.846    13.481     0.200
     3.120    12.959     0.200
     3.160    13.287     0.200
     3.160    13.451     0.200
     3.164    14.235     0.200
     3.177    12.678     0.200
     3.177    12.827     0.200
     3.295    13.518     0.200
     3.295    13.413     0.200
     3.510    14.121     0.200
     3.722    15.430     0.200
     3.722    16.161     0.200
     3.811    16.020     0.200
     3.811    16.376     0.200
     3.888    14.490     0.200
     3.887    14.920     0.200
     3.950    15.232     0.200
     3.951    15.430     0.200
     3.963    15.329     0.200
     4.039    15.655     0.200
     4.282    16.440     0.200
     4.382    16.915     0.200
     4.390    15.699     0.200
     4.390    16.039     0.200
     4.484    15.580     0.200
     4.463    16.513     0.200
     4.463    16.770     0.200
     4.508    16.469     0.200
     4.508    16.906     0.200
     4.686    17.391     0.200
     4.657    16.053     0.200
     4.657    16.482     0.200
     4.797    17.351     0.200
     4.797    17.515     0.200
     4.912    16.595     0.200
     4.912    17.138     0.200
     4.949    15.365     0.200
     4.953    15.310     0.200
     4.989    16.779     0.200
     5.059    15.900     0.200
     5.059    17.392     0.200
     5.139    17.298     0.200
     5.261    16.166     0.200
     5.383    19.332     0.200
     5.439    17.188     0.200
     5.439    18.469     0.200
     5.470    17.945     0.200
     5.561    18.984     0.200
     5.561    18.671     0.200
     5.675    17.930     0.200
     5.818    18.131     0.200
     5.818    18.940     0.200
     5.856    18.389     0.200
     5.856    18.667     0.200
     6.110    18.705     0.200
     6.078    20.051     0.200
     6.078    20.324     0.200
     6.218    19.898     0.200
     6.367    20.356     0.200
     6.380    19.238     0.200
     6.380    20.258     0.200
     6.404    20.781     0.200
     6.504    19.036     0.200
     6.633    20.284     0.200
     6.695    20.061     0.200
     6.673    20.220     0.200
     6.673    20.356     0.200
     6.875    21.406     0.200
     6.875    22.133     0.200
     6.900    20.616     0.200
     6.934    20.111     0.200
     6.928    21.106     0.200
     6.985    19.791     0.200
     7.189    22.336     0.200
     7.241    21.295     0.200
     7.241    22.306     0.200
     7.235    21.769     0.200
     7.283    22.309     0.200
     7.344    22.007     0.200
     7.393    21.334     0.200
     7.399    21.846     0.200
     7.447    21.914     0.200
     7.645    20.879     0.200
     7.645    21.922     0.200
     7.711    21.823     0.200
     7.729    19.775     0.200
     7.765    21.433     0.200
     7.765    23.851     0.200
     7.754    23.492     0.200
     7.823    22.950     0.200
     7.826    22.173     0.200
     7.812    22.636     0.200
     7.796    22.180     0.200
     7.796    22.750     0.200
     7.850    22.742     0.200
     7.806    21.680     0.200
     7.806    22.278     0.200
     7.932    22.413     0.200
     7.933    21.444     0.200
     7.933    23.030     0.200
     7.943    22.298     0.200
     7.985    22.460     0.200
     8.000    24.842     0.200
     8.099    22.926     0.200
     8.099    22.676     0.200
     8.131    21.554     0.200
     8.131    24.030     0.200
     8.133    21.103     0.200
     8.133    23.400     0.200
     8.133    21.940     0.200
     8.165    21.828     0.200
     8.185    23.962     0.200
     8.185    23.474     0.200
     8.215    23.086     0.200
     8.215    23.262     0.200
     8.253    21.827     0.200
     8.253    21.409     0.200
     8.219    23.834     0.200
     8.219    23.045     0.200
     8.262    23.244     0.200
     8.297    23.750     0.200
     8.378    22.735     0.200
     8.452    22.846     0.200
     8.452    22.686     0.200
     8.420    24.100     0.200
     8.433    24.285     0.200
     8.518    24.887     0.200
     8.498    24.288     0.200
     8.498    25.128     0.200
     8.496    23.981     0.200
     8.581    25.172     0.200
     8.626    24.946     0.200
     8.651    25.871     0.200
     8.628    24.447     0.200
     8.628    25.276     0.200
     8.925    24.455     0.200
     8.963    25.186     0.200
     8.990    25.428     0.200
     8.990    26.334     0.200
     9.037    25.521     0.200
     9.077    23.977     0.200
     9.183    27.496     0.200
     9.205    25.994     0.200
     9.196    25.134     0.200
     9.196    25.759     0.200
     9.285    24.766     0.200
     9.285    25.067     0.200
     9.496    27.337     0.200
     9.586    26.193     0.200
     9.558    26.607     0.200
     9.645    26.188     0.200
     9.637    25.622     0.200
     9.637    26.091     0.200
     9.731    26.467     0.200
     9.744    26.028     0.200
     9.844    28.213     0.200
     9.867    27.485     0.200
     9.867    27.731     0.200
     9.934    27.267     0.200
     9.969    26.916     0.200
     9.976    27.278     0.200
     9.976    27.677     0.200
    10.073    25.584     0.200
    10.048    27.176     0.200
    10.063    27.174     0.200
    10.091    26.747     0.200
    10.094    25.184     0.200
    10.147    26.883     0.200
    10.256    26.905     0.200
    10.294    26.764     0.200
    10.414    28.020     0.200
    10.414    26.403     0.200
    10.498    27.961     0.200
    10.550    27.171     0.200
    10.550    27.792     0.200
    10.537    27.550     0.200
    10.643    29.961     0.200
    10.734    29.546     0.200
    10.776    28.926     0.200
    10.782    27.103     0.200
    10.840    26.667     0.200
    10.950    28.992     0.200
    11.018    29.465     0.200
    10.965    28.709     0.200
    10.983    29.260     0.200
    11.021    30.237     0.200
    11.177    30.415     0.200
    11.179    30.151     0.200
    11.324    28.672     0.200
    11.365    29.088     0.200
    11.365    28.572     0.200
    11.449    30.480     0.200
    11.632    30.661     0.200
    11.766    30.750     0.200
    11.801    28.930     0.200
    11.801    30.504     0.200
    11.845    30.195     0.200
    11.845    29.715     0.200
    12.281    30.888     0.200
    12.427    32.452     0.200
    12.537    32.665     0.200
    12.727    31.687     0.200
    12.779    33.885     0.200
    12.840    33.215     0.200
    12.879    32.148     0.200
    13.145    32.510     0.200
    13.102    31.468     0.200
    13.180    33.899     0.200
    13.289    34.620     0.200
    13.289    33.968     0.200
    13.891    34.618     0.200
    14.475    32.801     0.200
    14.475    35.070     0.200
    14.475    35.406     0.200
    16.180    39.855     0.200
    16.499    39.898     0.200
    18.931    41.447     0.200
     0.737    10.615     0.200
     0.940     9.659     0.200
     1.357     8.595     0.200
     1.392     9.604     0.200
     1.415    10.261     0.200
     1.494     8.638     0.200
     1.720     9.824     0.200
     1.731     9.414     0.200
     1.998    10.647     0.200
     2.106    10.300     0.200
     2.234    10.579     0.200
     2.274    10.040     0.200
     2.340    10.406     0.200
     2.378     9.730     0.200
     2.444     9.761     0.200
     2.947    10.434     0.200
     2.936    12.795     0.200
     3.033    11.042     0.200
     3.081    10.934     0.200
     3.176    10.484     0.200
     3.261    10.919     0.200
     3.435    12.013     0.200
     3.505    12.336     0.200
     3.609    12.050     0.200
     3.646    11.584     0.200
     3.709    12.577     0.200
     3.861    12.619     0.200
     4.019    12.446     0.200
     4.039    11.847     0.200
     4.208    12.016     0.200
     4.324    13.032     0.200
     4.434    12.565     0.200
     4.406    12.504     0.200
     4.462    13.630     0.200
     4.467    13.628     0.200
     4.520    14.081     0.200
     4.605    14.703     0.200
     4.632    12.953     0.200
     4.901    14.680     0.200
     5.008    13.774     0.200
     5.039    14.288     0.200
     5.121    15.337     0.200
     5.259    14.299     0.200
     5.369    14.560     0.200
     5.418    14.740     0.200
     5.439    15.058     0.200
     5.607    15.055     0.200
     5.720    16.031     0.200
     5.922    15.457     0.200
     5.979    15.729     0.200
     5.974    16.122     0.200
     6.250    16.203     0.200
     6.249    15.723     0.200
     6.329    16.918     0.200
     6.404    17.250     0.200
     6.579    16.661     0.200
     6.704    15.493     0.200
     6.777    17.799     0.200
     6.802    15.387     0.200
     6.840    17.004     0.200
     6.847    17.468     0.200
     7.021    18.329     0.200
     7.019    18.939     0.200
     7.016    16.185     0.200
     7.022    16.771     0.200
     7.103    18.306     0.200
     7.130    18.884     0.200
     7.157    16.894     0.200
     7.197    16.796     0.200
     7.209    19.187     0.200
     7.199    17.619     0.200
     7.202    17.800     0.200
     7.233    17.282     0.200
     7.257    18.673     0.200
     7.329    18.338     0.200
     7.336    16.879     0.200
     7.336    16.949     0.200
     7.358    17.821     0.200
     7.344    16.837     0.200
     7.465    19.370     0.200
     7.509    17.479     0.200
     7.502    17.529     0.200
     7.542    18.982     0.200
     7.570    17.963     0.200
     7.605    19.757     0.200
     7.605    18.142     0.200
     7.759    18.415     0.200
     7.816    19.707     0.200
     7.834    19.087     0.200
     7.920    18.545     0.200
     8.009    19.827     0.200
     8.026    19.283     0.200
     8.047    19.768     0.200
     8.062    20.562     0.200
     8.257    20.561     0.200
     8.280    19.441     0.200
     8.755    20.146     0.200
     8.851    22.267     0.200
     9.217    20.705     0.200
     9.265    22.348     0.200
     9.748    23.909     0.200
    10.086    21.775     0.200
    10.410    22.850     0.200
    12.914    26.013     0.200
     0.308     4.912     0.200
     0.602     4.360     0.200
     0.721     5.211     0.200
     1.026     6.426     0.200
     1.045     6.379     0.200
     1.052     6.377     0.200
     1.069     7.032     0.200
     1.189     5.139     0.200
     1.190     6.376     0.200
     1.213     6.388     0.200
     1.207     6.415     0.200
     1.207     6.246     0.200
     1.282     6.924     0.200
     1.304     6.820     0.200
     1.304     6.643     0.200
     1.401     6.702     0.200
     1.413     7.295     0.200
     1.451     7.315     0.200
     1.595     7.303     0.200
     1.649     7.312     0.200
     1.625     7.296     0.200
     1.636     6.388     0.200
     1.652     7.367     0.200
     1.699     7.086     0.200
     1.714     7.711     0.200
     1.946     7.479     0.200
     2.051     8.429     0.200
     2.082     7.955     0.200
     2.086     8.615     0.200
     2.094     8.922     0.200
     2.196     8.697     0.200
     2.224     8.972     0.200
     2.504     8.471     0.200
     2.597     9.408     0.200
     2.638     8.992     0.200
     2.805    10.080     0.200
     2.807     9.674     0.200
     2.839    10.298     0.200
     2.850     9.617     0.200
     2.901    10.241     0.200
     2.917    10.644     0.200
     2.951    10.303     0.200
     3.016    10.004     0.200
     3.080    10.112     0.200
     3.126    10.126     0.200
     3.169    10.685     0.200
     3.262    11.130     0.200
     3.524    11.594     0.200
     3.633    11.547     0.200
     3.640    11.086     0.200
     3.670    11.452     0.200
     3.709    10.522     0.200
     3.720    11.643     0.200
     3.914    12.153     0.200
     3.958    12.356     0.200
     4.097    12.115     0.200
     4.409    12.448     0.200
     4.547    13.810     0.200
     4.651    13.162     0.200
     4.928    13.691     0.200
     5.040    14.304     0.200
     5.073    15.305     0.200
     5.226    15.020     0.200
     5.235    14.655     0.200
     5.273    15.019     0.200
     5.404    14.972     0.200
     5.455    14.216     0.200
     5.503    14.709     0.200
     5.532    15.482     0.200
     5.688    15.300     0.200
     5.737    15.211     0.200
     5.810    16.391     0.200
     5.861    15.577     0.200
     5.911    15.369     0.200
     6.031    16.064     0.200
     6.230    16.709     0.200
     6.412    17.074     0.200
     6.485    16.126     0.200
     6.515    16.175     0.200
     6.612    17.514     0.200
     6.666    17.289     0.200
     6.725    16.856     0.200
     6.749    16.947     0.200
     6.949    17.361     0.200
     6.986    17.433     0.200
     7.024    17.323     0.200
     7.003    17.429     0.200
     7.003    17.839     0.200
     7.038    18.917     0.200
     7.128    18.928     0.200
     7.146    18.560     0.200
     7.186    18.059     0.200
     7.310    17.707     0.200
     7.651    19.360     0.200
     8.644    22.135     0.200
     9.074    23.023     0.200
     9.813    23.793     0.200
     1.319     7.646     0.200
     1.367     8.109     0.200
     1.401     7.712     0.200
     1.437     9.043     0.200
     1.449     8.998     0.200
     1.465     9.353     0.200
     1.466     8.741     0.200
     1.475     9.424     0.200
     1.601     9.003     0.200
     1.601     9.128     0.200
     1.822     9.387     0.200
     1.847     9.121     0.200
     1.849     9.066     0.200
     1.978     8.365     0.200
     1.933     9.441     0.200
     1.939     9.090     0.200
     1.962     8.712     0.200
     2.203     9.174     0.200
     2.165     9.472     0.200
     2.200    10.424     0.200
     2.203     9.890     0.200
     2.258     9.196     0.200
     2.255     9.532     0.200
     2.326     9.886     0.200
     2.333    10.091     0.200
     2.390    11.268     0.200
     2.371     9.981     0.200
     2.398     9.849     0.200
     2.477    10.793     0.200
     2.592     9.150     0.200
     2.830    10.535     0.200
     2.824    11.482     0.200
     2.801    10.690     0.200
     2.826    10.881     0.200
     2.856    10.713     0.200
     2.913    10.622     0.200
     2.878    11.204     0.200
     2.917    11.125     0.200
     2.910    11.423     0.200
     2.934    10.926     0.200
     3.101    11.531     0.200
     3.131    11.814     0.200
     3.263    11.707     0.200
     3.277    11.878     0.200
     3.365    11.474     0.200
     3.402    11.386     0.200
     3.432    12.414     0.200
     3.462    11.864     0.200
     3.585    11.878     0.200
     3.527    12.423     0.200
     3.606    12.216     0.200
     3.619    12.494     0.200
     3.748    12.345     0.200
     3.867    13.251     0.200
     3.842    12.972     0.200
     3.937    12.343     0.200
     3.998    13.626     0.200
     4.140    13.419     0.200
     4.188    14.071     0.200
     4.293    13.799     0.200
     4.364    13.916     0.200
     4.331    14.496     0.200
     4.533    15.165     0.200
     4.544    14.586     0.200
     4.627    14.707     0.200
     4.678    14.215     0.200
     4.718    14.787     0.200
     4.664    15.110     0.200
     4.873    14.684     0.200
     4.897    14.939     0.200
     5.028    15.122     0.200
     5.062    14.966     0.200
     5.156    15.792     0.200
     5.107    16.233     0.200
     5.217    15.398     0.200
     5.161    15.416     0.200
     5.273    15.532     0.200
     5.188    16.154     0.200
     5.290    15.378     0.200
     5.428    16.750     0.200
     5.489    17.053     0.200
     5.584    16.691     0.200
     5.692    16.839     0.200
     5.791    16.889     0.200
     5.771    17.326     0.200
     5.736    16.286     0.200
     5.942    17.227     0.200
     5.861    17.350     0.200
     5.904    18.027     0.200
     5.964    17.574     0.200
     6.084    18.803     0.200
     6.066    18.117     0.200
     6.149    17.260     0.200
     6.223    17.286     0.200
     6.261    18.243     0.200
     6.227    18.466     0.200
     6.302    16.706     0.200
     6.301    18.143     0.200
     6.352    19.627     0.200
     6.417    18.213     0.200
     6.399    18.525     0.200
     6.518    18.189     0.200
     6.505    17.897     0.200
     6.612    18.654     0.200
     6.629    19.466     0.200
     6.637    19.279     0.200
     6.674    19.209     0.200
     6.716    19.245     0.200
     6.718    19.227     0.200
     6.806    18.494     0.200
     6.749    19.766     0.200
     6.749    18.996     0.200
     6.754    20.024     0.200
     6.759    19.503     0.200
     6.867    19.539     0.200
     6.850    18.579     0.200
     7.137    19.210     0.200
     7.174    19.608     0.200
     7.329    19.618     0.200
     7.558    19.607     0.200
     7.513    19.691     0.200
     7.660    21.202     0.200
     7.650    21.355     0.200
     7.706    20.732     0.200
     7.943    21.692     0.200
     8.405    22.058     0.200
     8.677    23.121     0.200
     8.925    21.361     0.200
     8.889    22.885     0.200
     9.235    23.971     0.200
     9.300    24.233     0.200
     9.577    23.808     0.200
     9.604    26.052     0.200
     9.712    24.963     0.200
     1.709     8.622     0.200
     2.104     9.594     0.200
     2.104    10.309     0.200
     2.176     9.789     0.200
     2.194     8.785     0.200
     2.720    10.814     0.200
     2.774    11.584     0.200
     2.774    11.353     0.200
     2.774    11.549     0.200
     2.802    10.682     0.200
     2.860    10.761     0.200
     3.000    10.480     0.200
     2.981    10.929     0.200
     3.263    11.828     0.200
     3.282    10.026     0.200
     3.421    11.994     0.200
     3.566    12.968     0.200
     3.601    11.611     0.200
     3.881    11.973     0.200
     4.040    13.519     0.200
     4.156    13.919     0.200
     4.295    14.626     0.200
     4.444    13.614     0.200
     4.533    13.384     0.200
     4.666    14.178     0.200
     4.991    14.292     0.200
     4.998    15.217     0.200
     5.020    14.248     0.200
     5.020    15.679     0.200
     5.096    15.493     0.200
     5.098    14.601     0.200
     5.225    15.300     0.200
     5.373    15.544     0.200
     5.415    16.909     0.200
     5.621    16.546     0.200
     5.729    16.852     0.200
     6.012    17.697     0.200
     6.147    17.736     0.200
     6.238    17.726     0.200
     6.282    17.589     0.200
     6.393    17.355     0.200
     6.399    17.396     0.200
     6.513    18.279     0.200
     6.538    18.688     0.200
     6.653    18.288     0.200
     6.663    18.867     0.200
     6.718    18.327     0.200
     7.049    18.056     0.200
     7.096    19.310     0.200
     7.169    19.272     0.200
     7.202    19.846     0.200
     7.259    19.790     0.200
     7.334    19.676     0.200
     7.447    19.912     0.200
     7.692    21.012     0.200
     7.850    21.169     0.200
     7.899    21.296     0.200
     7.899    19.976     0.200
     7.970    23.335     0.200
     8.014    21.008     0.200
     8.106    20.360     0.200
     8.200    20.993     0.200
     8.258    22.319     0.200
     8.284    22.019     0.200
     8.306    21.761     0.200
     8.349    21.285     0.200
     8.361    21.693     0.200
     8.361    20.262     0.200
     8.413    21.299     0.200
     8.491    21.625     0.200
     8.604    21.615     0.200
     8.736    23.808     0.200
     8.781    22.669     0.200
     8.797    22.985     0.200
     9.125    23.193     0.200
     9.460    24.677     0.200
     9.568    24.877     0.200
    11.186    27.450     0.200
    12.156    30.629     0.200
    14.317    35.217     0.200
     1.635     8.932     0.200
     2.040    10.231     0.200
     2.040    10.126     0.200
     2.782     9.781     0.200
     2.643    11.032     0.200
     2.704    11.656     0.200
     2.726    11.864     0.200
     2.726    11.536     0.200
     2.806    10.570     0.200
     2.806    10.738     0.200
     3.036    10.876     0.200
     2.923    10.751     0.200
     2.904    11.166     0.200
     3.027    11.058     0.200
     3.110    12.605     0.200
     3.205    11.857     0.200
     3.355    12.198     0.200
     3.555    11.520     0.200
     3.493    13.013     0.200
     3.525    11.160     0.200
     3.525    11.011     0.200
     3.686    12.252     0.200
     3.931    12.552     0.200
     3.804    12.318     0.200
     3.804    12.119     0.200
     3.866    13.965     0.200
     3.866    14.184     0.200
     3.974    13.864     0.200
     4.098    13.945     0.200
     4.092    12.578     0.200
     4.092    12.847     0.200
     4.095    12.555     0.200
     4.095    13.915     0.200
     4.221    13.170     0.200
     4.236    14.152     0.200
     4.344    14.256     0.200
     4.417    14.400     0.200
     4.417    14.662     0.200
     4.367    13.412     0.200
     4.367    13.584     0.200
     4.729    12.008     0.200
     4.729    12.617     0.200
     4.729    11.891     0.200
     4.457    13.319     0.200
     4.457    13.436     0.200
     4.590    14.015     0.200
     4.590    14.265     0.200
     4.775    15.035     0.200
     4.827    15.333     0.200
     4.926    15.563     0.200
     4.914    14.295     0.200
     4.944    15.043     0.200
     4.944    14.715     0.200
     4.943    14.116     0.200
     4.943    14.518     0.200
     4.943    14.397     0.200
     5.027    15.561     0.200
     5.097    16.189     0.200
     5.028    14.697     0.200
     5.028    14.471     0.200
     5.148    14.528     0.200
     5.296    14.800     0.200
     5.296    15.467     0.200
     5.347    15.822     0.200
     5.347    16.302     0.200
     5.415    15.732     0.200
     5.430    15.554     0.200
     5.557    16.585     0.200
     5.545    16.303     0.200
     5.560    16.778     0.200
     5.560    16.227     0.200
     5.656    15.933     0.200
     5.938    17.408     0.200
     6.001    17.024     0.200
     6.072    17.755     0.200
     6.474    15.669     0.200
     6.474    16.748     0.200
     6.166    17.106     0.200
     6.217    16.959     0.200
     6.217    17.756     0.200
     6.217    17.595     0.200
     6.199    17.325     0.200
     6.442    18.150     0.200
     6.463    17.669     0.200
     6.587    18.315     0.200
     6.585    18.088     0.200
     6.598    18.742     0.200
     6.926    18.400     0.200
     6.973    18.050     0.200
     6.973    19.019     0.200
     7.004    18.948     0.200
     7.029    18.941     0.200
     7.145    19.656     0.200
     7.184    18.763     0.200
     7.263    20.058     0.200
     7.263    19.546     0.200
     7.265    19.086     0.200
     7.424    20.367     0.200
     7.424    19.820     0.200
     7.439    20.068     0.200
     7.430    21.600     0.200
     7.607    21.143     0.200
     7.607    21.342     0.200
     7.615    21.045     0.200
     7.622    20.426     0.200
     8.026    19.455     0.200
     7.775    20.326     0.200
     7.813    21.577     0.200
     7.822    19.515     0.200
     7.854    21.792     0.200
     7.937    21.118     0.200
     8.005    21.194     0.200
     8.027    20.992     0.200
     8.072    20.739     0.200
     8.124    19.954     0.200
     8.113    21.992     0.200
     8.183    20.909     0.200
     8.233    21.227     0.200
     8.232    20.929     0.200
     8.541    19.131     0.200
     8.541    20.432     0.200
     8.541    19.748     0.200
     8.237    21.479     0.200
     8.239    21.318     0.200
     8.239    21.759     0.200
     8.284    21.381     0.200
     8.284    20.721     0.200
     8.290    21.135     0.200
     8.327    22.451     0.200
     8.337    20.689     0.200
     8.364    23.867     0.200
     8.414    21.473     0.200
     8.414    22.297     0.200
     8.527    22.414     0.200
     8.527    21.496     0.200
     8.677    22.444     0.200
     8.708    21.733     0.200
     8.728    23.596     0.200
     8.721    23.238     0.200
     8.741    22.363     0.200
     8.843    21.221     0.200
     8.887    22.701     0.200
     8.961    22.428     0.200
     8.965    23.337     0.200
     8.989    22.650     0.200
     9.053    22.837     0.200
     9.109    23.933     0.200
     9.096    23.316     0.200
     9.160    22.398     0.200
     9.201    23.052     0.200
     9.318    23.798     0.200
     9.390    22.341     0.200
     9.390    22.829     0.200
     9.390    22.997     0.200
     9.411    24.780     0.200
     9.411    24.409     0.200
     9.454    24.476     0.200
     9.492    24.877     0.200
     9.580    24.752     0.200
     9.580    23.890     0.200
     9.571    24.231     0.200
     9.598    24.922     0.200
     9.690    24.916     0.200
     9.754    23.864     0.200
     9.703    24.581     0.200
     9.751    23.269     0.200
     9.823    25.476     0.200
     9.836    24.024     0.200
     9.843    23.873     0.200
    10.195    22.389     0.200
    10.195    23.584     0.200
     9.988    23.732     0.200
    10.038    24.015     0.200
    10.101    25.208     0.200
    10.102    26.408     0.200
    10.244    25.372     0.200
    10.240    25.846     0.200
    10.288    25.284     0.200
    10.270    24.482     0.200
    10.341    24.676     0.200
    10.567    25.190     0.200
    10.567    26.534     0.200
    10.567    26.088     0.200
    10.637    26.560     0.200
    10.753    24.458     0.200
    10.776    25.108     0.200
    10.791    24.800     0.200
    10.802    25.645     0.200
    10.835    26.653     0.200
    10.912    24.617     0.200
    10.912    24.867     0.200
    10.912    24.484     0.200
    10.825    27.913     0.200
    10.939    26.332     0.200
    11.029    27.334     0.200
    11.112    27.673     0.200
    11.093    27.565     0.200
    11.113    26.236     0.200
    11.200    26.655     0.200
    11.199    26.466     0.200
    11.314    26.863     0.200
    11.314    26.121     0.200
    11.287    26.204     0.200
    11.421    28.643     0.200
    11.635    27.199     0.200
    11.635    27.906     0.200
    11.563    28.579     0.200
    11.625    28.040     0.200
    11.622    27.334     0.200
    11.777    27.421     0.200
    11.780    27.818     0.200
    12.087    28.639     0.200
    12.000    29.413     0.200
    12.073    29.391     0.200
    12.059    28.789     0.200
    12.074    29.249     0.200
    12.114    31.012     0.200
    12.114    29.582     0.200
    12.149    28.970     0.200
    12.293    29.890     0.200
    12.331    29.228     0.200
    12.490    29.657     0.200
    12.572    30.858     0.200
    12.686    29.487     0.200
    12.763    29.946     0.200
    12.900    29.306     0.200
    13.274    31.727     0.200
    13.408    32.003     0.200
    13.592    32.357     0.200
    14.115    34.399     0.200
    14.242    35.404     0.200
    14.242    33.013     0.200
    14.502    32.012     0.200
    14.909    33.922     0.200
    14.914    37.181     0.200
    15.137    36.672     0.200
    15.425    37.411     0.200
    15.684    37.437     0.200
    17.612    36.507     0.200
    17.612    36.276     0.200
     1.605     8.512     0.200
     2.004     9.776     0.200
     2.619    10.627     0.200
     2.670    11.220     0.200
     2.670    11.364     0.200
     2.699    10.398     0.200
     2.699    11.182     0.200
     2.745     9.544     0.200
     2.768    10.488     0.200
     2.900    10.821     0.200
     2.882    10.814     0.200
     2.994    11.126     0.200
     2.998    10.618     0.200
     3.078    12.290     0.200
     3.167    10.918     0.200
     3.167    11.673     0.200
     3.319    12.190     0.200
     3.319    11.726     0.200
     3.461    12.533     0.200
     3.507    11.048     0.200
     3.507    10.736     0.200
     3.648    11.886     0.200
     3.784    11.672     0.200
     3.839    13.724     0.200
     3.893    12.040     0.200
     3.938    13.123     0.200
     3.938    13.485     0.200
     4.090    13.810     0.200
     4.090    12.324     0.200
     4.093    13.358     0.200
     4.060    13.446     0.200
     4.191    13.738     0.200
     4.206    13.704     0.200
     4.320    14.238     0.200
     4.345    13.586     0.200
     4.345    13.276     0.200
     4.380    14.283     0.200
     4.380    14.443     0.200
     4.441    13.228     0.200
     4.441    12.926     0.200
     4.564    14.520     0.200
     4.564    13.908     0.200
     4.716    11.879     0.200
     4.716    11.418     0.200
     4.736    14.329     0.200
     4.790    14.843     0.200
     4.895    14.103     0.200
     4.895    13.946     0.200
     4.894    15.032     0.200
     4.922    14.432     0.200
     4.922    14.122     0.200
     4.922    13.799     0.200
     4.919    14.317     0.200
     5.020    14.251     0.200
     5.020    14.672     0.200
     5.020    14.019     0.200
     4.993    15.462     0.200
     4.993    15.176     0.200
     5.059    15.701     0.200
     5.126    14.892     0.200
     5.276    14.906     0.200
     5.312    16.012     0.200
     5.397    15.450     0.200
     5.433    13.275     0.200
     5.528    15.938     0.200
     5.523    16.134     0.200
     5.534    15.642     0.200
     5.534    16.029     0.200
     5.643    15.691     0.200
     5.907    16.894     0.200
     6.001    16.737     0.200
     6.056    17.323     0.200
     6.156    16.552     0.200
     6.176    16.827     0.200
     6.181    17.067     0.200
     6.181    17.527     0.200
     6.181    17.218     0.200
     6.318    16.884     0.200
     6.409    17.844     0.200
     6.460    14.577     0.200
     6.433    17.759     0.200
     6.578    17.418     0.200
     6.578    17.644     0.200
     6.560    18.009     0.200
     6.584    18.101     0.200
     6.895    18.252     0.200
     6.956    18.750     0.200
     6.979    18.837     0.200
     7.027    18.538     0.200
     7.148    19.246     0.200
     7.148    19.116     0.200
     7.155    19.378     0.200
     7.155    18.530     0.200
     7.254    19.869     0.200
     7.230    19.128     0.200
     7.344    21.239     0.200
     7.397    19.498     0.200
     7.431    19.642     0.200
     7.431    19.522     0.200
     7.416    21.903     0.200
     7.440    19.851     0.200
     7.594    21.529     0.200
     7.595    20.773     0.200
     7.613    21.420     0.200
     7.613    20.621     0.200
     7.757    20.841     0.200
     7.809    21.021     0.200
     7.796    20.437     0.200
     7.796    19.615     0.200
     7.798    21.792     0.200
     7.853    21.472     0.200
     7.878    23.317     0.200
     7.915    21.532     0.200
     8.010    20.880     0.200
     8.019    20.950     0.200
     8.005    21.004     0.200
     8.036    20.897     0.200
     8.102    22.271     0.200
     8.102    21.374     0.200
     8.096    21.692     0.200
     8.096    20.510     0.200
     8.118    22.247     0.200
     8.166    21.684     0.200
     8.240    21.696     0.200
     8.240    21.130     0.200
     8.214    21.497     0.200
     8.261    19.152     0.200
     8.261    22.103     0.200
     8.329    21.527     0.200
     8.310    20.933     0.200
     8.364    23.775     0.200
     8.394    21.699     0.200
     8.503    21.439     0.200
     8.527    20.043     0.200
     8.680    22.221     0.200
     8.676    21.892     0.200
     8.703    21.865     0.200
     8.734    21.651     0.200
     8.727    23.883     0.200
     8.727    22.512     0.200
     8.858    20.921     0.200
     8.896    22.743     0.200
     8.960    22.919     0.200
     8.932    22.000     0.200
     8.962    21.741     0.200
     9.021    23.217     0.200
     9.096    22.793     0.200
     9.134    24.491     0.200
     9.134    23.138     0.200
     9.179    23.270     0.200
     9.322    23.389     0.200
     9.420    24.145     0.200
     9.420    24.825     0.200
     9.420    23.965     0.200
     9.448    24.304     0.200
     9.473    24.526     0.200
     9.548    23.654     0.200
     9.586    24.210     0.200
     9.691    24.366     0.200
     9.700    23.889     0.200
     9.765    23.642     0.200
     9.771    23.795     0.200
     9.837    24.266     0.200
     9.807    23.799     0.200
     9.820    24.515     0.200
     9.958    24.868     0.200
    10.012    24.044     0.200
    10.093    24.781     0.200
    10.084    25.748     0.200
    10.253    24.779     0.200
    10.246    24.487     0.200
    10.256    24.610     0.200
    10.562    26.172     0.200
    10.562    25.360     0.200
    10.561    26.679     0.200
    10.536    25.123     0.200
    10.618    25.069     0.200
    10.774    24.044     0.200
    10.783    26.724     0.200
    10.783    25.905     0.200
    10.765    26.494     0.200
    10.780    25.695     0.200
    10.839    26.355     0.200
    10.934    24.153     0.200
    10.934    24.256     0.200
    10.950    26.318     0.200
    11.029    27.367     0.200
    11.073    26.417     0.200
    11.132    25.714     0.200
    11.132    25.243     0.200
    11.086    26.505     0.200
    11.088    26.186     0.200
    11.170    26.562     0.200
    11.170    26.749     0.200
    11.260    26.346     0.200
    11.275    28.657     0.200
    11.397    26.868     0.200
    11.578    25.581     0.200
    11.635    27.908     0.200
    11.596    27.619     0.200
    11.751    28.619     0.200
    11.751    27.788     0.200
    11.986    28.610     0.200
    12.030    28.421     0.200
    12.074    27.991     0.200
    12.127    29.859     0.200
    12.127    29.654     0.200
    12.127    28.041     0.200
    12.271    28.580     0.200
    12.302    29.002     0.200
    12.414    28.232     0.200
    12.557    29.847     0.200
    12.659    30.360     0.200
    12.871    30.096     0.200
    13.249    32.603     0.200
    13.382    32.980     0.200
    14.226    33.816     0.200
    14.226    32.550     0.200
    15.146    34.422     0.200
    17.599    36.921     0.200
    17.599    36.157     0.200
    18.781    38.192     0.200
    18.781    38.632     0.200
     1.421     7.444     0.200
     1.454     7.187     0.200
     1.510     6.423     0.200
     1.510     6.298     0.200
     1.625     8.546     0.200
     1.625     8.660     0.200
     1.625     8.543     0.200
     1.859     8.967     0.200
     1.879     8.622     0.200
     1.922     9.067     0.200
     1.923     9.123     0.200
     2.034     7.993     0.200
     2.034     7.712     0.200
     2.241     9.200     0.200
     2.313     8.670     0.200
     2.372     9.555     0.200
     2.393     9.681     0.200
     2.441    10.572     0.200
     2.486    10.359     0.200
     2.486     9.734     0.200
     2.645     8.567     0.200
     2.749    10.157     0.200
     2.885    10.179     0.200
     2.872    10.055     0.200
     2.900    10.270     0.200
     2.901    10.185     0.200
     2.969    10.207     0.200
     2.938    10.660     0.200
     3.153    10.801     0.200
     3.281    11.909     0.200
     3.281    11.104     0.200
     3.421    10.920     0.200
     3.457    10.900     0.200
     3.485    11.244     0.200
     3.486    11.843     0.200
     3.513    12.552     0.200
     3.637    11.266     0.200
     3.661    12.193     0.200
     3.660    12.129     0.200
     3.690    12.744     0.200
     3.804    12.461     0.200
     3.804    11.813     0.200
     3.878    12.610     0.200
     3.923    12.786     0.200
     3.992    12.237     0.200
     4.054    13.172     0.200
     4.118    13.583     0.200
     4.167    12.158     0.200
     4.195    12.776     0.200
     4.195    12.932     0.200
     4.223    13.203     0.200
     4.223    13.055     0.200
     4.319    12.524     0.200
     4.333    13.054     0.200
     4.589    14.646     0.200
     4.589    14.482     0.200
     4.591    14.154     0.200
     4.732    14.309     0.200
     4.732    13.989     0.200
     4.719    14.062     0.200
     4.764    14.385     0.200
     4.853    13.988     0.200
     4.926    14.676     0.200
     4.949    15.014     0.200
     5.145    15.081     0.200
     5.110    14.573     0.200
     5.110    14.066     0.200
     5.186    15.069     0.200
     5.136    14.830     0.200
     5.136    14.408     0.200
     5.159    15.414     0.200
     5.159    14.984     0.200
     5.208    15.683     0.200
     5.202    14.960     0.200
     5.238    15.615     0.200
     5.484    15.995     0.200
     5.484    15.604     0.200
     5.543    16.261     0.200
     5.543    15.980     0.200
     5.633    16.198     0.200
     5.647    16.153     0.200
     5.741    15.250     0.200
     5.786    15.793     0.200
     5.786    15.551     0.200
     5.838    16.361     0.200
     5.814    17.427     0.200
     5.826    17.203     0.200
     5.927    16.500     0.200
     5.985    17.603     0.200
     5.959    17.867     0.200
     6.007    16.627     0.200
     6.007    16.314     0.200
     6.121    18.032     0.200
     6.196    17.333     0.200
     6.207    17.439     0.200
     6.264    16.629     0.200
     6.283    17.750     0.200
     6.342    16.782     0.200
     6.355    16.182     0.200
     6.374    17.071     0.200
     6.408    18.455     0.200
     6.454    17.688     0.200
     6.559    17.453     0.200
     6.666    19.070     0.200
     6.684    18.956     0.200
     6.693    17.883     0.200
     6.724    18.217     0.200
     6.724    17.608     0.200
     6.770    17.608     0.200
     6.772    16.731     0.200
     6.803    18.260     0.200
     6.803    18.767     0.200
     6.850    18.876     0.200
     6.812    17.535     0.200
     6.902    17.737     0.200
     6.902    17.870     0.200
     6.923    18.511     0.200
     6.923    18.347     0.200
     7.057    19.140     0.200
     7.176    19.786     0.200
     7.376    18.943     0.200
     7.376    18.763     0.200
     7.564    20.257     0.200
     7.609    19.976     0.200
     7.704    20.287     0.200
     7.715    20.550     0.200
     7.752    19.624     0.200
     8.428    21.310     0.200
     9.632    23.167     0.200
     0.233     7.227     0.200
     0.498     6.084     0.200
     0.657     6.109     0.200
     0.654     6.180     0.200
     0.658     6.619     0.200
     0.679     6.098     0.200
     0.747     6.430     0.200
     0.760     6.202     0.200
     0.816     6.568     0.200
     0.799     6.223     0.200
     0.785     6.187     0.200
     0.944     6.455     0.200
     0.944     6.197     0.200
     0.944     6.451     0.200
     0.920     6.457     0.200
     0.970     6.324     0.200
     0.971     6.387     0.200
     1.009     6.379     0.200
     1.059     7.197     0.200
     1.129     7.197     0.200
     1.199     6.792     0.200
     1.199     6.980     0.200
     1.235     7.162     0.200
     1.306     7.454     0.200
     1.307     7.393     0.200
     1.229     7.222     0.200
     1.353     6.995     0.200
     1.535     7.338     0.200
     1.535     7.194     0.200
     1.643     8.248     0.200
     1.646     8.311     0.200
     1.647     8.336     0.200
     1.666     8.254     0.200
     1.685     7.374     0.200
     1.807     7.972     0.200
     1.956     8.791     0.200
     1.955     8.729     0.200
     2.130     8.457     0.200
     2.096     8.191     0.200
     2.096     8.398     0.200
     2.272     9.330     0.200
     2.286     9.184     0.200
     2.310     9.139     0.200
     2.310     9.018     0.200
     2.337     9.366     0.200
     2.336     9.969     0.200
     2.336     9.766     0.200
     2.273     8.572     0.200
     2.280     8.467     0.200
     2.370     9.229     0.200
     2.419     9.300     0.200
     2.419     8.937     0.200
     2.374     8.592     0.200
     2.463     9.874     0.200
     2.463     9.624     0.200
     2.469     8.949     0.200
     2.666     9.109     0.200
     2.686     9.471     0.200
     2.700     9.454     0.200
     2.758     9.858     0.200
     2.695     9.739     0.200
     2.695     9.974     0.200
     2.796    10.445     0.200
     2.802    10.222     0.200
     2.874    10.593     0.200
     2.919    10.669     0.200
     2.937    10.806     0.200
     3.018    10.341     0.200
     3.040    10.715     0.200
     3.040    10.816     0.200
     3.127    10.336     0.200
     3.087    11.318     0.200
     3.103    11.062     0.200
     3.222    10.320     0.200
     3.388    10.983     0.200
     3.401    12.415     0.200
     3.401    12.579     0.200
     3.446    10.565     0.200
     3.547    11.685     0.200
     3.589    11.581     0.200
     3.590    11.702     0.200
     3.589    11.957     0.200
     3.596    11.365     0.200
     3.623    12.159     0.200
     3.660    12.111     0.200
     3.705    11.995     0.200
     3.798    11.940     0.200
     3.834    12.581     0.200
     3.931    12.239     0.200
     3.962    12.775     0.200
     3.963    12.581     0.200
     3.938    12.374     0.200
     3.938    12.491     0.200
     4.027    12.770     0.200
     4.027    12.875     0.200
     4.052    11.950     0.200
     4.052    12.310     0.200
     4.109    12.501     0.200
     4.109    12.637     0.200
     4.134    12.667     0.200
     4.154    13.290     0.200
     4.154    13.552     0.200
     4.211    11.905     0.200
     4.211    12.413     0.200
     4.198    12.823     0.200
     4.198    12.702     0.200
     4.341    11.863     0.200
     4.341    12.121     0.200
     4.390    13.138     0.200
     4.421    13.203     0.200
     4.421    13.477     0.200
     4.394    13.388     0.200
     4.474    12.427     0.200
     4.474    12.673     0.200
     4.479    12.473     0.200
     4.507    12.680     0.200
     4.507    13.825     0.200
     4.608    13.317     0.200
     4.608    13.465     0.200
     4.631    12.792     0.200
     4.631    12.953     0.200
     4.696    13.164     0.200
     4.696    13.301     0.200
     4.715    14.220     0.200
     4.715    14.345     0.200
     4.728    13.544     0.200
     4.804    13.769     0.200
     4.799    13.300     0.200
     4.754    14.529     0.200
     4.822    13.088     0.200
     4.822    12.444     0.200
     4.835    13.253     0.200
     4.841    14.468     0.200
     4.928    14.317     0.200
     4.928    14.485     0.200
     5.036    13.513     0.200
     5.036    13.678     0.200
     5.055    14.669     0.200
     5.200    14.142     0.200
     5.213    14.316     0.200
     5.213    14.781     0.200
     5.236    14.992     0.200
     5.236    15.453     0.200
     5.233    15.288     0.200
     5.233    15.929     0.200
     5.334    15.125     0.200
     5.334    14.906     0.200
     5.334    14.828     0.200
     5.372    14.472     0.200
     5.372    14.589     0.200
     5.357    15.424     0.200
     5.357    15.725     0.200
     5.492    14.365     0.200
     5.556    15.557     0.200
     5.593    15.413     0.200
     5.593    15.523     0.200
     5.647    14.822     0.200
     5.647    15.107     0.200
     5.743    15.125     0.200
     5.759    15.719     0.200
     5.759    16.219     0.200
     5.777    15.528     0.200
     5.793    16.336     0.200
     5.793    16.461     0.200
     5.811    15.453     0.200
     5.818    15.016     0.200
     5.818    14.875     0.200
     5.823    16.366     0.200
     5.823    15.823     0.200
     5.878    15.616     0.200
     5.858    15.972     0.200
     5.913    16.162     0.200
     5.953    16.023     0.200
     5.953    16.187     0.200
     6.018    15.734     0.200
     6.018    15.991     0.200
     6.021    15.790     0.200
     6.102    16.322     0.200
     6.074    16.091     0.200
     6.196    16.534     0.200
     6.197    16.467     0.200
     6.228    16.369     0.200
     6.228    16.947     0.200
     6.244    15.855     0.200
     6.265    16.935     0.200
     6.284    16.138     0.200
     6.317    16.083     0.200
     6.317    16.642     0.200
     6.331    16.733     0.200
     6.394    16.713     0.200
     6.416    17.096     0.200
     6.416    17.241     0.200
     6.450    16.635     0.200
     6.462    16.264     0.200
     6.469    16.433     0.200
     6.510    18.345     0.200
     6.519    16.376     0.200
     6.519    16.520     0.200
     6.511    16.515     0.200
     6.540    16.638     0.200
     6.540    16.747     0.200
     6.590    17.051     0.200
     6.668    17.834     0.200
     6.663    17.725     0.200
     6.663    17.569     0.200
     6.762    17.396     0.200
     6.767    17.284     0.200
     6.767    17.909     0.200
     6.777    17.870     0.200
     6.777    18.006     0.200
     6.795    17.227     0.200
     6.795    17.883     0.200
     6.826    17.064     0.200
     6.821    17.721     0.200
     6.843    17.975     0.200
     6.871    18.039     0.200
     6.867    17.670     0.200
     6.916    18.133     0.200
     6.924    18.228     0.200
     7.038    18.468     0.200
     7.077    18.280     0.200
     7.096    18.374     0.200
     7.234    18.446     0.200
     7.282    16.905     0.200
     7.282    16.698     0.200
     7.277    18.890     0.200
     7.301    19.186     0.200
     7.301    18.592     0.200
     7.333    18.925     0.200
     7.333    19.714     0.200
     7.346    19.134     0.200
     7.349    18.849     0.200
     7.359    18.696     0.200
     7.359    19.614     0.200
     7.375    18.936     0.200
     7.469    18.029     0.200
     7.469    17.924     0.200
     7.456    18.320     0.200
     7.402    18.751     0.200
     7.402    20.512     0.200
     7.505    18.789     0.200
     7.536    17.835     0.200
     7.536    18.007     0.200
     7.546    18.205     0.200
     7.546    20.322     0.200
     7.562    17.471     0.200
     7.645    19.659     0.200
     7.625    18.915     0.200
     7.625    19.262     0.200
     7.717    19.545     0.200
     7.717    20.373     0.200
     7.726    19.436     0.200
     7.742    20.066     0.200
     7.756    18.202     0.200
     7.756    17.827     0.200
     7.756    17.922     0.200
     7.756    18.582     0.200
     7.763    18.089     0.200
     7.838    19.875     0.200
     7.820    20.065     0.200
     7.862    18.096     0.200
     7.862    18.193     0.200
     7.862    17.904     0.200
     7.870    18.014     0.200
     7.906    19.257     0.200
     7.934    19.801     0.200
     7.985    18.802     0.200
     7.985    19.326     0.200
     7.922    19.731     0.200
     7.922    20.028     0.200
     7.983    19.308     0.200
     7.983    19.636     0.200
     7.983    19.120     0.200
     7.939    19.114     0.200
     8.054    18.532     0.200
     8.054    18.360     0.200
     7.989    19.496     0.200
     8.087    19.007     0.200
     8.087    19.894     0.200
     8.020    19.810     0.200
     8.121    20.348     0.200
     8.121    20.102     0.200
     8.139    19.786     0.200
     8.132    19.679     0.200
     8.158    20.157     0.200
     8.234    20.256     0.200
     8.255    19.634     0.200
     8.255    19.509     0.200
     8.375    19.345     0.200
     8.375    19.517     0.200
     8.394    20.866     0.200
     8.491    20.638     0.200
     8.496    20.343     0.200
     8.496    21.097     0.200
     8.489    21.373     0.200
     8.629    19.632     0.200
     8.631    21.537     0.200
     8.614    22.019     0.200
     8.614    22.370     0.200
     8.614    21.738     0.200
     8.706    23.189     0.200
     8.729    22.072     0.200
     8.729    22.346     0.200
     8.744    22.221     0.200
     8.772    21.295     0.200
     8.817    20.829     0.200
     9.013    22.563     0.200
     9.111    21.687     0.200
     9.111    23.171     0.200
     9.176    20.858     0.200
     9.176    20.515     0.200
     9.172    22.933     0.200
     9.172    22.737     0.200
     9.218    21.471     0.200
     9.262    21.526     0.200
     9.259    22.228     0.200
     9.388    21.898     0.200
     9.427    22.081     0.200
     9.427    22.578     0.200
     9.457    22.647     0.200
     9.457    22.370     0.200
     9.482    22.723     0.200
     9.490    20.968     0.200
     9.490    20.851     0.200
     9.504    22.949     0.200
     9.504    23.051     0.200
     9.591    22.772     0.200
     9.591    23.366     0.200
     9.593    23.244     0.200
     9.593    23.689     0.200
     9.576    22.279     0.200
     9.576    22.849     0.200
     9.628    22.035     0.200
     9.628    21.715     0.200
     9.663    21.344     0.200
     9.778    21.545     0.200
     9.781    23.656     0.200
     9.809    22.949     0.200
     9.809    23.719     0.200
     9.869    22.905     0.200
     9.869    23.765     0.200
     9.939    24.095     0.200
     9.939    24.681     0.200
    10.032    24.109     0.200
    10.032    25.320     0.200
    10.032    24.460     0.200
    10.073    24.195     0.200
    10.073    24.445     0.200
    10.112    25.496     0.200
    10.112    23.164     0.200
    10.178    26.215     0.200
    10.198    22.180     0.200
    10.198    22.383     0.200
    10.258    22.263     0.200
    10.258    24.282     0.200
    10.258    22.880     0.200
    10.297    25.231     0.200
    10.360    23.547     0.200
    10.360    23.781     0.200
    10.394    23.412     0.200
    10.394    23.869     0.200
    10.389    23.917     0.200
    10.451    24.035     0.200
    10.451    24.535     0.200
    10.528    23.267     0.200
    10.528    23.416     0.200
    10.499    23.850     0.200
    10.570    24.645     0.200
    10.603    22.365     0.200
    10.579    24.575     0.200
    10.579    23.946     0.200
    10.646    22.595     0.200
    10.657    22.687     0.200
    10.731    25.242     0.200
    10.731    25.004     0.200
    10.772    24.686     0.200
    10.857    25.625     0.200
    10.888    25.769     0.200
    10.888    26.320     0.200
    10.961    23.214     0.200
    11.013    24.571     0.200
    11.093    23.031     0.200
    11.100    24.274     0.200
    11.100    24.829     0.200
    11.339    24.912     0.200
    11.330    24.980     0.200
    11.330    27.120     0.200
    11.368    26.050     0.200
    11.368    27.249     0.200
    11.616    26.461     0.200
    11.666    25.315     0.200
    11.677    25.229     0.200
    11.881    24.871     0.200
    12.005    26.635     0.200
    12.092    25.256     0.200
    12.206    26.976     0.200
    12.228    25.818     0.200
    12.262    29.014     0.200
    12.330    29.144     0.200
    12.407    29.820     0.200
    12.402    28.340     0.200
    12.737    29.078     0.200
    12.839    28.169     0.200
    12.832    30.941     0.200
    12.832    30.824     0.200
    12.832    29.773     0.200
    12.983    31.588     0.200
    13.171    29.959     0.200
    13.171    29.017     0.200
    13.454    29.764     0.200
    13.629    27.761     0.200
    13.711    31.364     0.200
    14.048    29.806     0.200
    14.048    30.877     0.200
    14.149    30.622     0.200
    14.149    31.572     0.200
    14.209    30.969     0.200
    14.408    29.854     0.200
    16.023    35.355     0.200
    17.504    33.532     0.200
    17.504    34.083     0.200
     0.033    15.000     0.200
     0.116    13.869     0.200
     0.157    13.293     0.200
     0.147    13.603     0.200
     0.171    13.340     0.200
     0.355    11.553     0.200
     0.449    11.373     0.200
     0.597    10.848     0.200
     0.770    10.014     0.200
     0.850     9.635     0.200
     0.886     9.415     0.200
     0.908     9.686     0.200
     0.998     9.691     0.200
     1.091     9.630     0.200
     1.171     9.363     0.200
     1.180     9.088     0.200
     1.437     8.752     0.200
     1.469     8.807     0.200
     1.479     9.855     0.200
     1.493     9.917     0.200
     1.540     9.408     0.200
     1.643     9.349     0.200
     1.665     9.387     0.200
     1.753     8.810     0.200
     1.772    10.017     0.200
     1.771     9.858     0.200
     1.839     9.142     0.200
     2.012     9.372     0.200
     2.043    10.208     0.200
     2.033     9.416     0.200
     2.088     9.814     0.200
     2.177     9.519     0.200
     2.300    10.449     0.200
     2.351    10.948     0.200
     2.410     9.162     0.200
     2.450    10.441     0.200
     2.496    10.380     0.200
     2.528    10.199     0.200
     2.541    10.474     0.200
     2.588    10.032     0.200
     2.583    11.045     0.200
     2.632    10.625     0.200
     2.728    10.256     0.200
     2.789    10.124     0.200
     2.897    10.872     0.200
     2.905    10.729     0.200
     3.047    10.484     0.200
     3.181    11.321     0.200
     3.300    11.407     0.200
     3.319    11.336     0.200
     3.380    12.474     0.200
     3.386    12.181     0.200
     3.396    11.572     0.200
     3.439    12.055     0.200
     3.709    12.868     0.200
     3.723    12.536     0.200
     3.752    12.123     0.200
     3.824    13.366     0.200
     3.964    12.920     0.200
     3.983    13.101     0.200
     4.005    12.400     0.200
     4.077    12.601     0.200
     4.083    12.663     0.200
     4.221    13.326     0.200
     4.329    13.651     0.200
     4.393    12.126     0.200
     4.408    13.170     0.200
     4.768    13.638     0.200
     4.773    13.578     0.200
     4.765    13.303     0.200
     4.869    14.605     0.200
     4.921    13.478     0.200
     4.991    13.227     0.200
     5.189    15.355     0.200
     5.318    15.035     0.200
     5.367    14.356     0.200
     5.442    16.152     0.200
     5.678    14.937     0.200
     5.722    15.951     0.200
     5.750    15.490     0.200
     5.778    15.332     0.200
     5.965    16.184     0.200
     6.006    16.375     0.200
     6.004    17.405     0.200
     6.065    15.346     0.200
     6.121    16.402     0.200
     6.657    17.745     0.200
     7.072    17.941     0.200
     7.113    18.134     0.200
     7.156    18.170     0.200
     7.237    18.348     0.200
     7.306    18.863     0.200
     7.538    17.280     0.200
     8.063    19.131     0.200
     8.310    19.884     0.200
     0.358     4.336     0.200
     0.358     4.557     0.200
     1.065     6.070     0.200
     1.097     5.657     0.200
     1.097     6.036     0.200
     1.097     5.917     0.200
     1.408     7.265     0.200
     1.406     6.721     0.200
     1.613     7.209     0.200
     1.718     7.307     0.200
     1.756     6.791     0.200
     1.836     7.479     0.200
     1.837     7.470     0.200
     1.830     7.813     0.200
     1.825     6.969     0.200
     1.887     8.766     0.200
     1.919     7.856     0.200
     2.007     7.322     0.200
     2.133     8.144     0.200
     2.132     8.254     0.200
     2.373     8.609     0.200
     2.467     8.921     0.200
     2.468     8.908     0.200
     2.433     8.653     0.200
     2.493     9.731     0.200
     2.884     9.145     0.200
     2.937    10.373     0.200
     3.032     9.529     0.200
     3.187     8.890     0.200
     3.249    11.656     0.200
     3.193     9.002     0.200
     3.346    10.787     0.200
     3.346    10.434     0.200
     3.390     9.932     0.200
     3.390    10.072     0.200
     3.473    10.231     0.200
     3.564    11.683     0.200
     3.534    10.823     0.200
     3.581    11.103     0.200
     3.877    11.224     0.200
     4.041    11.687     0.200
     4.134    11.852     0.200
     4.163    11.967     0.200
     4.306    12.789     0.200
     4.392    12.758     0.200
     4.469    13.355     0.200
     4.588    13.563     0.200
     4.976    14.159     0.200
     5.009    13.995     0.200
     4.997    13.966     0.200
     5.075    14.183     0.200
     5.184    14.878     0.200
     5.372    15.739     0.200
     5.445    15.705     0.200
     5.675    16.611     0.200
     5.675    15.968     0.200
     5.725    15.739     0.200
     5.792    15.331     0.200
     6.233    16.596     0.200
     6.202    16.659     0.200
     6.313    17.097     0.200
     6.456    16.751     0.200
     6.720    17.930     0.200
     6.866    17.742     0.200
     7.053    18.392     0.200
     7.203    19.369     0.200
     9.137    19.153     0.200
     0.431     5.343     0.200
     0.432     5.325     0.200
     0.602     5.126     0.200
     0.677     5.575     0.200
     0.742     5.417     0.200
     1.049     5.840     0.200
     1.084     5.478     0.200
     1.042     6.747     0.200
     1.075     5.917     0.200
     1.052     6.715     0.200
     1.053     6.782     0.200
     1.054     6.878     0.200
     1.125     5.733     0.200
     1.071     6.448     0.200
     1.087     6.687     0.200
     1.087     6.035     0.200
     1.088     6.022     0.200
     1.101     5.626     0.200
     1.144     6.709     0.200
     1.197     6.453     0.200
     1.312     6.846     0.200
     1.325     7.343     0.200
     1.325     7.179     0.200
     1.325     7.249     0.200
     1.511     6.954     0.200
     1.512     6.936     0.200
     1.507     7.588     0.200
     1.507     7.705     0.200
     1.512     7.572     0.200
     1.560     6.501     0.200
     1.627     7.619     0.200
     1.654     7.320     0.200
     1.686     7.688     0.200
     1.763     8.169     0.200
     1.810     7.558     0.200
     1.844     8.211     0.200
     1.836     7.753     0.200
     1.887     7.301     0.200
     1.922     7.998     0.200
     1.894     7.359     0.200
     1.894     7.511     0.200
     1.977     8.331     0.200
     1.977     7.628     0.200
     1.980     8.118     0.200
     1.980     7.907     0.200
     2.094     8.574     0.200
     2.130     8.721     0.200
     2.138     8.972     0.200
     2.234     9.060     0.200
     2.265     9.091     0.200
     2.270     9.447     0.200
     2.544     9.083     0.200
     2.549     8.698     0.200
     2.554     8.297     0.200
     2.554     7.797     0.200
     2.594     9.376     0.200
     2.608     8.864     0.200
     2.620    10.606     0.200
     2.620    10.449     0.200
     2.685     9.483     0.200
     2.735     8.990     0.200
     2.768     9.437     0.200
     2.768     9.245     0.200
     2.891     8.450     0.200
     2.891    10.458     0.200
     2.897    10.378     0.200
     2.912     9.741     0.200
     2.903     9.886     0.200
     2.904     9.876     0.200
     2.904    10.215     0.200
     2.930     9.916     0.200
     2.952    10.424     0.200
     2.973    10.305     0.200
     2.973    10.585     0.200
     3.009    10.493     0.200
     3.058     9.396     0.200
     3.058    10.024     0.200
     3.226    10.436     0.200
     3.226    10.283     0.200
     3.230    10.467     0.200
     3.340    10.377     0.200
     3.342    10.987     0.200
     3.342    10.851     0.200
     3.477    10.491     0.200
     3.477    10.331     0.200
     3.564    10.789     0.200
     3.559    11.895     0.200
     3.636    11.587     0.200
     3.644    11.677     0.200
     3.725    11.918     0.200
     3.795    12.136     0.200
     3.808    10.685     0.200
     3.808    10.865     0.200
     3.850    11.022     0.200
     3.948    10.453     0.200
     3.965    12.600     0.200
     3.965    12.072     0.200
     4.013    11.640     0.200
     4.038    12.721     0.200
     4.067    13.303     0.200
     4.178    13.202     0.200
     4.202    12.020     0.200
     4.202    11.629     0.200
     4.302    12.675     0.200
     4.327    11.725     0.200
     4.327    11.850     0.200
     4.367    12.804     0.200
     4.384    12.553     0.200
     4.521    13.057     0.200
     4.521    12.936     0.200
     4.564    13.718     0.200
     4.595    14.279     0.200
     4.595    13.818     0.200
     4.617    12.356     0.200
     4.628    12.439     0.200
     4.681    12.357     0.200
     4.775    13.120     0.200
     4.959    14.102     0.200
     4.997    13.703     0.200
     5.020    13.431     0.200
     5.050    12.446     0.200
     5.057    13.278     0.200
     5.018    13.701     0.200
     5.064    14.996     0.200
     5.064    14.602     0.200
     5.095    13.823     0.200
     5.095    14.198     0.200
     5.108    14.799     0.200
     5.122    15.093     0.200
     5.122    14.375     0.200
     5.304    15.442     0.200
     5.304    15.063     0.200
     5.341    14.731     0.200
     5.335    15.242     0.200
     5.353    14.573     0.200
     5.353    14.265     0.200
     5.408    14.229     0.200
     5.425    14.530     0.200
     5.452    15.341     0.200
     5.480    14.678     0.200
     5.505    14.835     0.200
     5.544    14.978     0.200
     5.584    14.696     0.200
     5.587    14.606     0.200
     5.577    15.180     0.200
     5.603    14.564     0.200
     5.614    14.725     0.200
     5.648    15.621     0.200
     5.678    14.675     0.200
     5.725    15.246     0.200
     5.726    15.949     0.200
     5.767    16.103     0.200
     5.767    15.818     0.200
     5.796    15.934     0.200
     5.868    16.338     0.200
     5.873    16.244     0.200
     5.893    16.171     0.200
     5.893    15.789     0.200
     5.887    16.409     0.200
     5.887    15.838     0.200
     5.949    15.858     0.200
     5.949    15.499     0.200
     5.975    16.249     0.200
     5.975    16.054     0.200
     5.987    15.971     0.200
     6.000    15.440     0.200
     6.048    15.539     0.200
     6.053    15.182     0.200
     6.118    16.642     0.200
     6.193    16.569     0.200
     6.216    16.784     0.200
     6.295    17.010     0.200
     6.367    16.831     0.200
     6.427    17.189     0.200
     6.482    16.733     0.200
     6.485    17.030     0.200
     6.536    17.527     0.200
     6.558    16.239     0.200
     6.595    16.432     0.200
     6.789    17.944     0.200
     6.789    17.670     0.200
     6.806    16.844     0.200
     6.806    17.567     0.200
     6.806    17.168     0.200
     6.964    18.113     0.200
     7.008    18.154     0.200
     7.005    17.549     0.200
     7.007    17.525     0.200
     7.026    17.750     0.200
     7.077    17.925     0.200
     7.053    17.666     0.200
     7.053    17.423     0.200
     7.089    17.571     0.200
     7.146    17.744     0.200
     7.146    16.572     0.200
     7.166    17.616     0.200
     7.170    18.119     0.200
     7.251    18.478     0.200
     7.251    18.255     0.200
     7.269    18.777     0.200
     7.282    18.084     0.200
     7.282    17.709     0.200
     7.349    18.561     0.200
     7.664    19.240     0.200
     7.664    18.689     0.200
     7.684    20.067     0.200
     7.691    18.961     0.200
     7.691    19.062     0.200
     7.903    18.697     0.200
     8.022    19.584     0.200
     8.214    20.381     0.200
     8.298    20.381     0.200
     8.596    20.491     0.200
     8.718    20.429     0.200
     0.881     4.740     0.200
     1.076     6.475     0.200
     1.498     7.730     0.200
     1.501     7.496     0.200
     1.650     7.845     0.200
     1.704     8.772     0.200
     1.701     8.169     0.200
     1.698     7.449     0.200
     1.698     7.653     0.200
     1.772     8.150     0.200
     1.778     8.919     0.200
     1.821     8.627     0.200
     1.901     8.272     0.200
     1.901     8.269     0.200
     1.946     8.091     0.200
     1.942     8.522     0.200
     2.008     8.767     0.200
     2.040     8.869     0.200
     2.123     7.498     0.200
     2.168     9.145     0.200
     2.168     9.106     0.200
     2.447     9.697     0.200
     2.432     9.819     0.200
     2.433     9.811     0.200
     2.520     9.081     0.200
     2.493    10.045     0.200
     2.877    10.139     0.200
     2.922    10.000     0.200
     2.922    10.405     0.200
     3.120    10.442     0.200
     3.382    10.745     0.200
     3.382    11.340     0.200
     3.539    11.106     0.200
     3.528    11.773     0.200
     3.582    11.673     0.200
     3.614    11.218     0.200
     3.629    12.495     0.200
     3.712    12.007     0.200
     3.745    12.727     0.200
     3.837    12.062     0.200
     4.050    13.042     0.200
     4.171    13.905     0.200
     4.247    12.568     0.200
     4.271    12.507     0.200
     4.229    13.545     0.200
     4.248    12.469     0.200
     4.248    13.050     0.200
     4.261    13.053     0.200
     4.330    13.811     0.200
     4.330    14.026     0.200
     4.499    13.505     0.200
     4.545    13.664     0.200
     4.642    13.321     0.200
     4.634    13.767     0.200
     4.678    14.332     0.200
     4.950    14.527     0.200
     4.993    15.348     0.200
     5.077    15.576     0.200
     5.131    14.778     0.200
     5.218    15.703     0.200
     5.273    15.066     0.200
     5.256    14.587     0.200
     5.425    16.061     0.200
     5.455    15.585     0.200
     5.463    14.557     0.200
     5.463    15.335     0.200
     5.704    16.689     0.200
     5.737    16.259     0.200
     5.797    15.480     0.200
     5.867    15.476     0.200
     6.012    17.344     0.200
     6.045    16.185     0.200
     6.227    15.848     0.200
     6.286    16.870     0.200
     6.405    17.599     0.200
     6.512    17.849     0.200
     6.529    17.999     0.200
     6.724    17.760     0.200
     6.888    19.172     0.200
     6.991    19.130     0.200
     7.028    18.276     0.200
     7.060    19.175     0.200
     7.060    19.482     0.200
     7.274    18.915     0.200
     7.304    19.199     0.200
     7.429    18.604     0.200
     7.442    19.105     0.200
     7.506    19.178     0.200
     7.539    20.571     0.200
     7.538    20.173     0.200
     7.709    19.753     0.200
     7.709    20.789     0.200
     7.828    20.003     0.200
     7.837    19.825     0.200
     7.938    20.048     0.200
     8.565    21.103     0.200
     8.618    20.735     0.200
     8.768    21.258     0.200
     8.787    22.039     0.200
     8.830    20.584     0.200
     9.028    23.422     0.200
     9.041    22.119     0.200
     9.047    22.141     0.200
     9.119    22.259     0.200
     9.119    21.459     0.200
     9.233    22.775     0.200
     9.233    23.200     0.200
     9.316    23.346     0.200
     9.325    22.459     0.200
     9.529    23.632     0.200
     9.627    24.326     0.200
     9.671    22.861     0.200
     9.671    23.445     0.200
     9.912    23.926     0.200
    10.055    24.322     0.200
    10.430    26.044     0.200
    11.918    26.920     0.200
    15.235    33.365     0.200
    16.139    34.778     0.200
     0.386     7.692     0.200
     0.457     7.245     0.200
     0.457     7.394     0.200
     0.471     7.420     0.200
     0.554     7.187     0.200
     0.611     6.986     0.200
     0.673     7.250     0.200
     0.675     7.285     0.200
     0.732     6.952     0.200
     0.733     6.981     0.200
     0.764     6.714     0.200
     0.776     6.668     0.200
     0.787     6.739     0.200
     0.841     6.940     0.200
     0.840     7.228     0.200
     0.870     7.032     0.200
     0.893     7.696     0.200
     0.899     7.732     0.200
     0.884     7.285     0.200
     0.922     7.086     0.200
     0.894     6.732     0.200
     0.894     5.939     0.200
     1.011     7.150     0.200
     1.005     6.656     0.200
     1.099     7.197     0.200
     1.203     7.685     0.200
     1.203     8.044     0.200
     1.195     7.448     0.200
     1.197     7.452     0.200
     1.233     7.197     0.200
     1.269     6.884     0.200
     1.537     8.248     0.200
     1.583     8.238     0.200
     1.577     8.638     0.200
     1.577     8.806     0.200
     1.601     8.114     0.200
     1.601     8.219     0.200
     1.588     8.030     0.200
     1.621     8.209     0.200
     1.636     8.148     0.200
     1.697     8.817     0.200
     1.678     8.215     0.200
     1.678     8.325     0.200
     1.761     8.140     0.200
     1.761     8.593     0.200
     1.853     8.742     0.200
     1.926     8.192     0.200
     1.973     8.440     0.200
     1.940     7.940     0.200
     2.041     9.103     0.200
     2.047     9.034     0.200
     2.127     9.843     0.200
     2.277     9.280     0.200
     2.330     9.746     0.200
     2.386     9.028     0.200
     2.386    10.094     0.200
     2.490     9.411     0.200
     2.490     9.876     0.200
     2.557    10.046     0.200
     2.629    11.339     0.200
     2.629    10.015     0.200
     2.688     9.340     0.200
     2.706     8.900     0.200
     2.738    10.007     0.200
     2.738    10.183     0.200
     2.808    10.249     0.200
     2.831    10.993     0.200
     2.832    10.849     0.200
     2.834    10.848     0.200
     2.841     9.879     0.200
     2.837     9.758     0.200
     2.866     9.205     0.200
     2.866     9.389     0.200
     2.909    10.193     0.200
     3.001    10.330     0.200
     3.191    11.696     0.200
     3.287    11.044     0.200
     3.287    11.228     0.200
     3.337    11.710     0.200
     3.375    10.952     0.200
     3.431    12.525     0.200
     3.462    12.055     0.200
     3.501    12.070     0.200
     3.555    10.917     0.200
     3.605    11.035     0.200
     3.713    13.069     0.200
     3.735    12.059     0.200
     3.769    12.654     0.200
     3.769    12.806     0.200
     3.745    12.598     0.200
     3.772    12.325     0.200
     3.864    11.401     0.200
     3.864    11.971     0.200
     3.876    12.800     0.200
     3.901    11.138     0.200
     3.901    11.321     0.200
     3.907    11.437     0.200
     3.907    11.668     0.200
     3.939    11.488     0.200
     3.939    11.703     0.200
     3.961    12.989     0.200
     4.031    13.131     0.200
     4.067    12.259     0.200
     4.108    10.943     0.200
     4.108    11.095     0.200
     4.129    12.147     0.200
     4.272    12.039     0.200
     4.272    12.215     0.200
     4.285    12.909     0.200
     4.285    12.765     0.200
     4.299    11.128     0.200
     4.339    13.255     0.200
     4.364    13.383     0.200
     4.456    12.642     0.200
     4.497    14.447     0.200
     4.497    14.565     0.200
     4.532    12.966     0.200
     4.532    12.369     0.200
     4.620    13.641     0.200
     4.620    14.040     0.200
     4.620    13.801     0.200
     4.619    13.487     0.200
     4.619    13.225     0.200
     4.799    14.806     0.200
     4.834    14.292     0.200
     4.905    14.771     0.200
     4.878    13.760     0.200
     4.905    12.890     0.200
     4.923    13.637     0.200
     4.913    12.548     0.200
     4.966    13.697     0.200
     4.968    13.679     0.200
     5.022    14.659     0.200
     5.038    14.158     0.200
     5.049    14.250     0.200
     5.049    13.867     0.200
     5.072    14.823     0.200
     5.226    15.316     0.200
     5.226    15.214     0.200
     5.205    14.768     0.200
     5.217    13.691     0.200
     5.217    13.804     0.200
     5.256    14.240     0.200
     5.267    14.380     0.200
     5.261    14.348     0.200
     5.318    15.931     0.200
     5.318    16.216     0.200
     5.312    14.417     0.200
     5.378    15.870     0.200
     5.361    15.747     0.200
     5.382    15.319     0.200
     5.431    14.294     0.200
     5.433    15.378     0.200
     5.472    16.047     0.200
     5.467    15.374     0.200
     5.467    15.238     0.200
     5.480    15.226     0.200
     5.491    15.777     0.200
     5.517    14.718     0.200
     5.519    16.237     0.200
     5.547    14.972     0.200
     5.564    15.579     0.200
     5.602    15.547     0.200
     5.602    15.438     0.200
     5.622    15.803     0.200
     5.729    15.949     0.200
     5.750    15.453     0.200
     5.765    15.821     0.200
     5.765    15.540     0.200
     5.791    15.048     0.200
     5.791    14.943     0.200
     5.826    15.009     0.200
     5.834    15.232     0.200
     5.859    15.869     0.200
     5.898    16.162     0.200
     6.088    15.744     0.200
     6.229    16.666     0.200
     6.261    16.340     0.200
     6.359    17.214     0.200
     6.408    17.458     0.200
     6.408    17.727     0.200
     6.480    17.429     0.200
     6.490    17.653     0.200
     6.490    17.786     0.200
     6.489    17.926     0.200
     6.489    18.074     0.200
     6.487    16.178     0.200
     6.487    17.350     0.200
     6.487    16.889     0.200
     6.518    16.247     0.200
     6.563    18.018     0.200
     6.579    16.483     0.200
     6.578    17.737     0.200
     6.587    17.162     0.200
     6.684    18.063     0.200
     6.724    16.613     0.200
     6.703    17.460     0.200
     6.708    17.506     0.200
     6.711    17.576     0.200
     6.764    16.840     0.200
     6.778    17.761     0.200
     6.778    17.105     0.200
     6.767    18.076     0.200
     6.782    17.884     0.200
     6.803    18.733     0.200
     6.844    17.950     0.200
     6.985    17.297     0.200
     6.987    17.471     0.200
     6.988    17.012     0.200
     6.988    17.212     0.200
     6.999    17.179     0.200
     7.007    18.187     0.200
     7.007    17.957     0.200
     7.063    19.130     0.200
     7.069    18.659     0.200
     7.052    18.208     0.200
     7.090    17.539     0.200
     7.090    16.981     0.200
     7.090    16.145     0.200
     7.133    19.487     0.200
     7.201    18.566     0.200
     7.222    18.506     0.200
     7.204    18.866     0.200
     7.222    17.941     0.200
     7.285    17.789     0.200
     7.266    19.483     0.200
     7.315    17.961     0.200
     7.298    18.233     0.200
     7.298    19.393     0.200
     7.311    19.090     0.200
     7.314    19.476     0.200
     7.346    18.629     0.200
     7.371    18.665     0.200
     7.415    19.792     0.200
     7.415    19.514     0.200
     7.389    18.692     0.200
     7.408    18.831     0.200
     7.454    19.131     0.200
     7.444    18.543     0.200
     7.444    18.281     0.200
     7.523    18.800     0.200
     7.523    18.667     0.200
     7.539    19.285     0.200
     7.532    19.983     0.200
     7.532    20.104     0.200
     7.624    18.540     0.200
     7.729    19.018     0.200
     7.729    18.881     0.200
     7.779    20.444     0.200
     7.805    20.224     0.200
     7.862    19.327     0.200
     7.865    18.409     0.200
     7.911    20.049     0.200
     7.982    20.180     0.200
     8.030    19.474     0.200
     8.030    19.193     0.200
     8.017    20.658     0.200
     8.017    20.294     0.200
     8.058    20.888     0.200
     8.074    20.745     0.200
     8.050    20.406     0.200
     8.069    21.495     0.200
     8.081    19.988     0.200
     8.086    20.270     0.200
     8.112    20.242     0.200
     8.115    20.528     0.200
     8.124    20.240     0.200
     8.140    20.565     0.200
     8.182    21.303     0.200
     8.155    20.162     0.200
     8.159    20.620     0.200
     8.155    20.702     0.200
     8.279    21.762     0.200
     8.285    19.927     0.200
     8.435    19.835     0.200
     8.435    19.936     0.200
     8.448    19.882     0.200
     8.448    19.772     0.200
     8.488    21.597     0.200
     8.488    20.812     0.200
     8.537    20.808     0.200
     8.537    20.590     0.200
     8.508    20.614     0.200
     8.508    20.478     0.200
     8.535    20.551     0.200
     8.543    20.434     0.200
     8.601    21.458     0.200
     8.625    20.534     0.200
     8.660    21.925     0.200
     8.730    22.017     0.200
     8.698    21.401     0.200
     8.698    21.058     0.200
     8.729    20.014     0.200
     8.729    19.740     0.200
     8.740    21.187     0.200
     8.784    21.141     0.200
     8.824    20.914     0.200
     8.853    21.607     0.200
     8.890    23.079     0.200
     8.888    21.301     0.200
     8.926    20.622     0.200
     8.951    22.592     0.200
     8.951    22.803     0.200
     8.951    22.698     0.200
     8.996    20.669     0.200
     9.011    20.527     0.200
     9.094    21.433     0.200
     9.101    20.955     0.200
     9.163    23.175     0.200
     9.199    23.908     0.200
     9.187    20.795     0.200
     9.207    20.226     0.200
     9.261    22.130     0.200
     9.406    22.683     0.200
     9.406    22.976     0.200
     9.392    21.891     0.200
     9.445    21.225     0.200
     9.445    22.569     0.200
     9.445    22.300     0.200
     9.456    22.917     0.200
     9.465    21.946     0.200
     9.515    23.688     0.200
     9.495    23.687     0.200
     9.501    22.466     0.200
     9.505    21.926     0.200
     9.513    22.862     0.200
     9.513    22.659     0.200
     9.543    21.828     0.200
     9.589    21.956     0.200
     9.575    21.958     0.200
     9.622    21.400     0.200
     9.734    22.750     0.200
     9.751    24.333     0.200
     9.751    24.192     0.200
     9.790    22.339     0.200
     9.767    23.324     0.200
     9.767    23.215     0.200
     9.838    21.661     0.200
     9.830    23.509     0.200
     9.878    21.607     0.200
     9.888    24.355     0.200
     9.888    23.925     0.200
     9.910    22.203     0.200
     9.892    20.432     0.200
     9.892    22.221     0.200
     9.892    20.635     0.200
     9.977    23.574     0.200
    10.009    23.378     0.200
    10.009    23.210     0.200
     9.999    22.139     0.200
    10.008    24.193     0.200
    10.008    24.626     0.200
    10.050    22.702     0.200
    10.120    24.360     0.200
    10.182    24.521     0.200
    10.199    24.970     0.200
    10.192    22.817     0.200
    10.182    23.438     0.200
    10.182    22.552     0.200
    10.180    22.484     0.200
    10.253    25.607     0.200
    10.237    23.889     0.200
    10.261    24.987     0.200
    10.331    22.222     0.200
    10.364    24.635     0.200
    10.365    23.668     0.200
    10.365    23.996     0.200
    10.330    23.176     0.200
    10.458    24.116     0.200
    10.465    25.644     0.200
    10.465    25.964     0.200
    10.495    23.386     0.200
    10.570    24.714     0.200
    10.615    24.259     0.200
    10.687    25.028     0.200
    10.738    25.566     0.200
    10.720    24.959     0.200
    10.769    24.490     0.200
    10.771    24.302     0.200
    10.771    24.662     0.200
    10.886    26.664     0.200
    10.927    24.522     0.200
    11.059    26.084     0.200
    11.065    25.373     0.200
    11.120    27.104     0.200
    11.109    24.669     0.200
    11.109    25.337     0.200
    11.122    23.955     0.200
    11.121    25.645     0.200
    11.202    26.609     0.200
    11.340    24.284     0.200
    11.346    24.246     0.200
    11.484    25.420     0.200
    11.492    24.432     0.200
    11.598    26.674     0.200
    11.588    24.942     0.200
    11.588    24.731     0.200
    11.588    24.043     0.200
    11.643    25.588     0.200
    11.679    25.959     0.200
    11.748    26.821     0.200
    11.742    26.358     0.200
    11.917    26.175     0.200
    11.914    25.929     0.200
    11.884    26.994     0.200
    11.986    26.662     0.200
    12.083    26.966     0.200
    12.131    26.683     0.200
    12.142    27.212     0.200
    12.176    27.922     0.200
    12.225    27.693     0.200
    12.356    28.165     0.200
    12.356    28.567     0.200
    12.356    27.715     0.200
    12.432    28.030     0.200
    12.595    28.854     0.200
    12.579    29.140     0.200
    12.664    28.839     0.200
    12.692    28.136     0.200
    12.783    30.393     0.200
    12.962    28.960     0.200
    12.990    27.828     0.200
    13.025    30.003     0.200
    13.240    27.448     0.200
    13.240    28.549     0.200
    13.281    28.366     0.200
    13.281    29.062     0.200
    13.281    28.218     0.200
    13.956    29.874     0.200
    14.213    32.748     0.200
    14.671    30.760     0.200
    15.147    33.379     0.200
    15.366    33.942     0.200
    15.421    33.987     0.200
    15.773    32.589     0.200
    16.745    31.328     0.200
    16.745    31.848     0.200
    17.750    35.112     0.200
    18.439    36.148     0.200
    20.284    34.645     0.200
     0.052    18.387     0.200
     0.285    16.208     0.200
     0.331    15.957     0.200
     0.353    15.736     0.200
     0.495    14.722     0.200
     0.523    14.043     0.200
     0.749    12.972     0.200
     0.811    12.869     0.200
     0.883    12.440     0.200
     1.126    12.507     0.200
     1.219    11.725     0.200
     1.211    11.812     0.200
     1.421    11.715     0.200
     1.395    12.450     0.200
     1.523    11.227     0.200
     1.592    10.615     0.200
     1.603    11.314     0.200
     1.728    10.401     0.200
     1.739    11.511     0.200
     1.919    12.103     0.200
     2.077    11.354     0.200
     2.152    10.535     0.200
     2.162    11.426     0.200
     2.183    11.541     0.200
     2.178    12.074     0.200
     2.195    11.721     0.200
     2.352    11.240     0.200
     2.442    11.426     0.200
     2.469    11.601     0.200
     2.505    11.093     0.200
     2.614    11.873     0.200
     2.847    10.527     0.200
     2.954    11.287     0.200
     2.948    12.297     0.200
     3.017    12.704     0.200
     3.298    12.391     0.200
     3.286    12.797     0.200
     3.391    12.926     0.200
     3.548    13.151     0.200
     3.650    12.308     0.200
     3.986    12.826     0.200
     4.172    13.485     0.200
     4.337    12.622     0.200
     4.422    12.607     0.200
     4.396    12.653     0.200
     4.462    13.576     0.200
     4.563    13.740     0.200
     4.591    14.829     0.200
     4.596    14.540     0.200
     4.630    12.917     0.200
     4.719    14.352     0.200
     4.752    14.444     0.200
     5.008    14.932     0.200
     5.021    13.784     0.200
     5.122    14.534     0.200
     5.284    13.871     0.200
     5.318    15.279     0.200
     5.323    15.149     0.200
     5.357    14.872     0.200
     5.412    14.868     0.200
     5.590    15.973     0.200
     5.568    15.580     0.200
     5.614    15.780     0.200
     5.628    16.407     0.200
     5.625    15.472     0.200
     5.779    16.296     0.200
     5.818    15.010     0.200
     5.968    16.041     0.200
     6.030    16.098     0.200
     6.313    16.916     0.200
     6.401    17.660     0.200
     6.415    17.713     0.200
     6.449    17.569     0.200
     6.719    17.345     0.200
     6.729    15.783     0.200
     6.968    16.471     0.200
     7.058    18.725     0.200
     7.117    16.607     0.200
     7.275    16.801     0.200
     7.275    16.700     0.200
     7.323    19.582     0.200
     7.511    19.363     0.200
     7.564    17.488     0.200
     8.040    18.822     0.200
     8.138    19.708     0.200
     1.281     7.677     0.200
     1.711     8.657     0.200
     1.711     8.504     0.200
     1.791     9.045     0.200
     2.013     9.950     0.200
     2.013     9.293     0.200
     2.104    10.797     0.200
     2.162     9.856     0.200
     2.259     9.991     0.200
     2.476    11.778     0.200
     2.473    11.588     0.200
     2.548    11.696     0.200
     2.582    11.009     0.200
     2.807    12.155     0.200
     3.045    11.948     0.200
     3.092    12.470     0.200
     3.157    12.166     0.200
     3.157    12.467     0.200
     3.494    15.333     0.200
     3.795    14.224     0.200
     3.795    14.408     0.200
     3.975    14.199     0.200
     3.975    14.629     0.200
     4.074    14.426     0.200
     4.086    13.973     0.200
     4.151    13.886     0.200
     4.199    15.504     0.200
     4.187    14.534     0.200
     4.220    16.009     0.200
     4.339    15.059     0.200
     4.448    14.906     0.200
     4.469    15.718     0.200
     4.516    15.865     0.200
     4.599    15.361     0.200
     4.641    16.354     0.200
     4.799    15.412     0.200
     4.911    15.558     0.200
     4.931    15.100     0.200
     4.933    15.317     0.200
     5.104    15.014     0.200
     5.136    15.693     0.200
     5.476    17.110     0.200
     5.649    16.969     0.200
     5.720    17.554     0.200
     5.755    16.731     0.200
     5.755    18.020     0.200
     5.829    18.617     0.200
     5.829    18.898     0.200
     5.890    17.937     0.200
     6.026    18.534     0.200
     6.058    18.977     0.200
     6.099    19.673     0.200
     6.098    18.175     0.200
     6.169    17.735     0.200
     6.337    18.105     0.200
     6.332    18.072     0.200
     6.413    19.355     0.200
     6.470    19.542     0.200
     6.507    19.218     0.200
     6.563    19.156     0.200
     6.573    18.954     0.200
     6.623    18.805     0.200
     6.614    20.365     0.200
     6.739    19.574     0.200
     6.879    20.423     0.200
     6.934    18.957     0.200
     6.980    19.995     0.200
     7.081    20.379     0.200
     7.190    20.836     0.200
     7.255    20.880     0.200
     7.364    19.085     0.200
     7.462    21.466     0.200
     7.569    21.013     0.200
     7.627    20.834     0.200
     7.648    20.916     0.200
     7.738    20.841     0.200
     7.826    21.568     0.200
     7.835    21.473     0.200
     7.809    21.744     0.200
     7.847    21.639     0.200
     7.933    22.460     0.200
     7.951    20.819     0.200
     7.951    21.221     0.200
     7.959    21.939     0.200
     7.993    22.621     0.200
     8.018    21.479     0.200
     7.995    21.305     0.200
     8.095    21.474     0.200
     8.086    22.454     0.200
     8.155    23.183     0.200
     8.182    22.720     0.200
     8.228    23.167     0.200
     8.246    22.535     0.200
     8.290    22.125     0.200
     8.602    23.310     0.200
     8.602    23.740     0.200
     8.595    23.059     0.200
     8.710    23.876     0.200
     8.892    23.388     0.200
     8.928    23.056     0.200
     9.126    24.998     0.200
     9.283    25.135     0.200
     9.283    25.553     0.200
     9.314    25.132     0.200
     9.570    25.146     0.200
     9.735    24.120     0.200
     9.894    26.060     0.200
    10.685    25.969     0.200
    10.731    27.601     0.200
    11.777    27.248     0.200
    12.515    31.060     0.200
     0.283     5.438     0.200
     0.761     5.437     0.200
     0.802     5.836     0.200
     0.802     5.586     0.200
     0.836     5.401     0.200
     0.937     5.966     0.200
     0.980     5.778     0.200
     0.966     5.811     0.200
     0.972     6.445     0.200
     0.991     5.896     0.200
     1.009     5.660     0.200
     1.014     6.306     0.200
     1.122     6.243     0.200
     1.150     6.454     0.200
     1.153     6.136     0.200
     1.153     6.130     0.200
     1.188     6.914     0.200
     1.224     6.363     0.200
     1.301     7.480     0.200
     1.352     6.891     0.200
     1.352     6.860     0.200
     1.582     6.323     0.200
     1.586     7.339     0.200
     1.727     6.933     0.200
     1.712     7.932     0.200
     1.782     7.884     0.200
     1.784     7.867     0.200
     2.106     7.809     0.200
     2.107     7.939     0.200
     2.290     8.224     0.200
     2.460     8.522     0.200
     2.467     9.588     0.200
     2.467     9.435     0.200
     2.565     9.109     0.200
     2.775     8.742     0.200
     2.797    10.228     0.200
     2.872     9.376     0.200
     2.870     9.392     0.200
     2.842     9.471     0.200
     2.842    10.623     0.200
     2.849    10.407     0.200
     2.865     9.984     0.200
     2.908     9.356     0.200
     2.898     9.927     0.200
     2.978    11.171     0.200
     3.163     9.734     0.200
     3.191    10.291     0.200
     3.270    11.729     0.200
     3.301    10.363     0.200
     3.308    11.507     0.200
     3.314    11.547     0.200
     3.326    11.740     0.200
     3.383    11.425     0.200
     3.436    11.332     0.200
     3.436    10.902     0.200
     3.448    11.660     0.200
     3.477    10.607     0.200
     3.477    11.591     0.200
     3.514    11.947     0.200
     3.514    11.630     0.200
     3.816    11.720     0.200
     3.826    12.117     0.200
     3.909    10.770     0.200
     3.952    11.428     0.200
     3.984    12.286     0.200
     4.020    12.547     0.200
     4.173    13.829     0.200
     4.192    13.500     0.200
     4.324    12.767     0.200
     4.361    13.108     0.200
     4.338    13.230     0.200
     4.444    13.884     0.200
     4.503    13.166     0.200
     4.600    12.796     0.200
     4.609    13.352     0.200
     4.625    13.610     0.200
     4.652    14.074     0.200
     4.657    12.575     0.200
     4.832    12.907     0.200
     4.887    14.524     0.200
     4.948    14.861     0.200
     5.027    14.626     0.200
     5.042    13.940     0.200
     5.102    14.302     0.200
     5.141    13.387     0.200
     5.172    14.332     0.200
     5.199    13.528     0.200
     5.299    13.119     0.200
     5.345    14.311     0.200
     5.469    15.310     0.200
     5.459    13.291     0.200
     5.584    15.134     0.200
     5.649    14.223     0.200
     5.717    15.931     0.200
     5.753    15.797     0.200
     5.873    15.065     0.200
     5.962    14.953     0.200
     6.074    16.614     0.200
     6.074    16.211     0.200
     6.104    15.412     0.200
     6.128    15.824     0.200
     6.256    17.297     0.200
     6.258    16.625     0.200
     6.348    15.831     0.200
     6.449    17.100     0.200
     6.482    16.891     0.200
     6.531    17.653     0.200
     6.673    17.479     0.200
     6.724    17.310     0.200
     6.700    17.030     0.200
     6.721    17.794     0.200
     6.760    17.574     0.200
     6.830    17.407     0.200
     6.830    17.868     0.200
     6.857    17.976     0.200
     6.857    17.789     0.200
     6.894    18.531     0.200
     6.894    18.116     0.200
     6.923    17.277     0.200
     7.003    17.781     0.200
     7.031    18.277     0.200
     7.031    17.921     0.200
     7.019    17.725     0.200
     7.227    18.352     0.200
     7.220    18.516     0.200
     7.299    18.032     0.200
     7.366    18.383     0.200
     7.374    18.123     0.200
     7.497    18.540     0.200
     7.545    18.457     0.200
     7.651    18.386     0.200
     7.844    19.333     0.200
     1.339     6.723     0.200
     1.294     7.788     0.200
     1.338     8.039     0.200
     1.457     9.072     0.200
     1.580     8.567     0.200
     1.580     8.594     0.200
     1.606     8.081     0.200
     1.653     8.006     0.200
     1.680     9.391     0.200
     1.787     8.730     0.200
     1.832     8.785     0.200
     1.846     8.982     0.200
     1.896     9.724     0.200
     1.953     9.177     0.200
     1.954     9.681     0.200
     1.958     9.202     0.200
     2.062     9.647     0.200
     2.163     7.985     0.200
     2.203     8.840     0.200
     2.267     9.698     0.200
     2.300     9.896     0.200
     2.340     9.481     0.200
     2.376    10.188     0.200
     2.437     9.681     0.200
     2.477     9.611     0.200
     2.471    10.289     0.200
     2.493     9.778     0.200
     2.581    10.638     0.200
     2.616    10.544     0.200
     2.714    10.478     0.200
     3.000    11.283     0.200
     3.044    10.969     0.200
     3.138    10.569     0.200
     3.247     9.396     0.200
     3.220    11.991     0.200
     3.249    11.219     0.200
     3.297    11.008     0.200
     3.306    12.024     0.200
     3.310    11.537     0.200
     3.529    11.144     0.200
     3.535    11.806     0.200
     3.587    11.291     0.200
     3.618    12.706     0.200
     3.651    10.044     0.200
     3.645    12.298     0.200
     3.687    12.471     0.200
     3.768    12.755     0.200
     3.787    11.738     0.200
     3.822    12.771     0.200
     3.969    12.644     0.200
     3.965    13.255     0.200
     4.090    13.532     0.200
     4.164    12.140     0.200
     4.170    13.761     0.200
     4.223    13.503     0.200
     4.265    14.276     0.200
     4.329    12.634     0.200
     4.307    13.569     0.200
     4.367    14.053     0.200
     4.354    14.107     0.200
     4.401    14.066     0.200
     4.507    14.015     0.200
     4.604    14.476     0.200
     4.684    14.691     0.200
     4.759    15.066     0.200
     4.759    14.621     0.200
     4.790    14.845     0.200
     4.903    14.677     0.200
     4.921    16.112     0.200
     5.014    15.224     0.200
     5.096    15.645     0.200
     5.150    14.432     0.200
     5.145    15.580     0.200
     5.167    15.800     0.200
     5.237    15.050     0.200
     5.265    16.010     0.200
     5.291    16.034     0.200
     5.303    15.576     0.200
     5.310    15.335     0.200
     5.341    15.393     0.200
     5.308    15.476     0.200
     5.376    16.856     0.200
     5.431    16.099     0.200
     5.622    15.489     0.200
     5.607    16.568     0.200
     5.838    17.076     0.200
     5.903    16.640     0.200
     5.999    16.492     0.200
     6.117    16.784     0.200
     6.126    17.661     0.200
     6.248    16.296     0.200
     6.355    18.940     0.200
     6.485    17.921     0.200
     6.614    18.093     0.200
     6.714    17.683     0.200
     6.838    17.734     0.200
     6.862    17.514     0.200
     6.962    18.805     0.200
     6.962    17.977     0.200
     6.964    18.713     0.200
     7.048    19.187     0.200
     7.087    18.582     0.200
     7.212    19.931     0.200
     7.501    18.554     0.200
     7.634    18.870     0.200
     7.708    19.034     0.200
     7.777    20.382     0.200
     7.855    20.046     0.200
     7.876    18.665     0.200
     7.871    20.359     0.200
     8.001    19.796     0.200
     8.166    19.953     0.200
     8.298    20.673     0.200
     0.186    17.183     0.200
     0.213    17.146     0.200
     0.262    16.650     0.200
     0.263    16.664     0.200
     0.319    16.341     0.200
     0.353    16.060     0.200
     0.364    16.172     0.200
     0.370    15.667     0.200
     0.371    15.584     0.200
     0.372    15.868     0.200
     0.372    15.566     0.200
     0.406    15.398     0.200
     0.417    15.618     0.200
     0.499    15.162     0.200
     0.517    14.644     0.200
     0.597    14.460     0.200
     0.622    13.996     0.200
     0.800    12.926     0.200
     0.836    12.823     0.200
     0.933    12.868     0.200
     0.972    12.562     0.200
     0.976    12.689     0.200
     1.025    12.563     0.200
     1.048    12.475     0.200
     1.146    11.242     0.200
     1.297    11.895     0.200
     1.331    12.240     0.200
     1.384    11.500     0.200
     1.464    11.429     0.200
     1.497    11.604     0.200
     1.591    11.318     0.200
     1.591    11.818     0.200
     1.619    11.659     0.200
     1.621    12.210     0.200
     1.694    11.034     0.200
     1.728    11.128     0.200
     1.737    11.543     0.200
     1.790    10.675     0.200
     1.860    11.318     0.200
     1.927    11.570     0.200
     2.110    11.986     0.200
     2.134    10.763     0.200
     2.127    11.321     0.200
     2.127    11.583     0.200
     2.146    11.473     0.200
     2.263    11.342     0.200
     2.263    11.869     0.200
     2.308    11.749     0.200
     2.308    12.003     0.200
     2.315    11.668     0.200
     2.334    11.027     0.200
     2.350    11.637     0.200
     2.354    12.102     0.200
     2.396    11.753     0.200
     2.540    11.882     0.200
     2.537    11.444     0.200
     2.654    11.261     0.200
     2.730    11.206     0.200
     2.756    10.299     0.200
     2.771    11.459     0.200
     2.852    12.261     0.200
     3.005    12.315     0.200
     3.023    12.344     0.200
     3.075    11.606     0.200
     3.312    12.233     0.200
     3.394    12.656     0.200
     3.390    12.591     0.200
     3.462    12.539     0.200
     3.463    13.555     0.200
     3.506    12.256     0.200
     3.506    12.771     0.200
     3.525    12.871     0.200
     3.638    13.564     0.200
     3.638    13.271     0.200
     3.729    12.962     0.200
     3.729    13.282     0.200
     3.754    13.459     0.200
     3.754    13.130     0.200
     3.840    13.238     0.200
     3.848    13.174     0.200
     3.848    12.748     0.200
     3.946    13.832     0.200
     3.946    13.946     0.200
     3.948    13.755     0.200
     4.169    13.278     0.200
     4.229    12.561     0.200
     4.288    13.510     0.200
     4.288    12.971     0.200
     4.386    13.672     0.200
     4.385    14.562     0.200
     4.395    13.231     0.200
     4.562    14.368     0.200
     4.588    14.604     0.200
     4.632    13.686     0.200
     4.634    16.433     0.200
     4.787    15.365     0.200
     4.803    14.229     0.200
     4.803    14.643     0.200
     4.808    14.167     0.200
     4.826    13.532     0.200
     4.838    12.730     0.200
     4.838    13.570     0.200
     4.853    15.539     0.200
     4.949    15.424     0.200
     4.949    15.295     0.200
     5.044    14.334     0.200
     5.063    13.822     0.200
     5.140    15.912     0.200
     5.221    13.936     0.200
     5.335    14.747     0.200
     5.376    14.425     0.200
     5.463    14.294     0.200
     5.468    15.593     0.200
     5.511    15.530     0.200
     5.528    15.474     0.200
     5.546    14.182     0.200
     5.546    14.350     0.200
     5.619    15.582     0.200
     5.619    15.226     0.200
     5.664    16.131     0.200
     5.826    15.962     0.200
     5.826    15.571     0.200
     5.826    15.193     0.200
     5.842    17.216     0.200
     5.842    16.747     0.200
     6.001    16.043     0.200
     6.013    15.079     0.200
     6.071    15.408     0.200
     6.071    16.076     0.200
     6.239    16.739     0.200
     6.276    16.494     0.200
     6.391    16.808     0.200
     6.391    17.077     0.200
     6.519    17.589     0.200
     6.524    17.106     0.200
     6.614    17.499     0.200
     6.629    17.825     0.200
     6.650    17.344     0.200
     6.662    17.860     0.200
     6.776    17.563     0.200
     6.772    15.987     0.200
     6.772    16.420     0.200
     6.861    18.317     0.200
     6.861    17.864     0.200
     6.861    16.665     0.200
     6.893    16.646     0.200
     7.036    18.093     0.200
     7.040    18.054     0.200
     7.058    18.660     0.200
     7.108    16.478     0.200
     7.203    18.690     0.200
     7.228    19.076     0.200
     7.223    19.081     0.200
     7.235    18.317     0.200
     7.264    18.786     0.200
     7.272    16.676     0.200
     7.287    18.978     0.200
     7.286    16.987     0.200
     7.302    17.854     0.200
     7.403    19.506     0.200
     7.416    19.511     0.200
     7.425    19.024     0.200
     7.441    17.007     0.200
     7.441    16.577     0.200
     7.486    18.830     0.200
     7.533    19.691     0.200
     7.537    19.905     0.200
     7.667    19.569     0.200
     7.678    20.209     0.200
     7.719    19.729     0.200
     7.740    17.803     0.200
     7.936    20.423     0.200
     7.936    20.427     0.200
     7.977    20.309     0.200
     8.046    19.615     0.200
     8.050    20.945     0.200
     8.065    18.727     0.200
     0.355     5.679     0.200
     0.356     5.653     0.200
     0.603     5.660     0.200
     0.695     5.346     0.200
     0.806     5.683     0.200
     0.887     5.718     0.200
     0.969     6.118     0.200
     1.033     6.194     0.200
     1.041     6.068     0.200
     1.045     6.256     0.200
     1.012     5.999     0.200
     1.062     6.262     0.200
     1.130     6.188     0.200
     1.153     6.066     0.200
     1.154     6.102     0.200
     1.153     6.192     0.200
     1.158     6.114     0.200
     1.223     6.932     0.200
     1.229     6.627     0.200
     1.306     6.946     0.200
     1.273     6.610     0.200
     1.272     6.878     0.200
     1.302     6.771     0.200
     1.444     7.258     0.200
     1.448     7.591     0.200
     1.448     7.456     0.200
     1.391     7.023     0.200
     1.509     6.873     0.200
     1.599     6.458     0.200
     1.631     7.217     0.200
     1.589     7.306     0.200
     1.591     7.383     0.200
     1.661     7.181     0.200
     1.729     8.174     0.200
     1.742     7.300     0.200
     1.765     7.480     0.200
     1.919     7.510     0.200
     1.926     8.400     0.200
     1.981     7.748     0.200
     1.981     7.890     0.200
     1.940     7.738     0.200
     1.940     7.495     0.200
     2.007     7.964     0.200
     2.063     8.332     0.200
     2.004     8.577     0.200
     2.004     8.162     0.200
     2.034     7.888     0.200
     2.034     7.988     0.200
     2.099     8.394     0.200
     2.107     8.893     0.200
     2.059     8.533     0.200
     2.132     8.569     0.200
     2.231     8.985     0.200
     2.236     9.041     0.200
     2.199     9.350     0.200
     2.481     7.988     0.200
     2.544     8.651     0.200
     2.568    10.635     0.200
     2.568    10.347     0.200
     2.590     9.384     0.200
     2.590     9.151     0.200
     2.596     8.772     0.200
     2.596     8.897     0.200
     2.667     8.973     0.200
     2.667     8.573     0.200
     2.626     8.593     0.200
     2.626     8.839     0.200
     2.751     9.714     0.200
     2.751     9.494     0.200
     2.785     9.569     0.200
     2.785     9.244     0.200
     2.867     9.808     0.200
     2.867     9.988     0.200
     2.867     9.788     0.200
     2.867    10.108     0.200
     2.893     9.461     0.200
     2.918    10.332     0.200
     2.936    10.611     0.200
     2.970    10.327     0.200
     2.969     9.879     0.200
     2.969     9.727     0.200
     3.015    10.644     0.200
     2.954     8.998     0.200
     2.954     8.695     0.200
     3.065    10.129     0.200
     3.065    10.499     0.200
     3.098    10.701     0.200
     3.090     9.907     0.200
     3.164    10.296     0.200
     3.164    10.146     0.200
     3.190    11.005     0.200
     3.260     9.465     0.200
     3.260    10.271     0.200
     3.292    10.569     0.200
     3.292    10.689     0.200
     3.406    10.337     0.200
     3.406    10.192     0.200
     3.534    11.555     0.200
     3.553    10.443     0.200
     3.557    10.526     0.200
     3.557    11.756     0.200
     3.632    11.553     0.200
     3.671    11.386     0.200
     3.671    11.224     0.200
     3.691    12.172     0.200
     3.691    11.771     0.200
     3.643    11.094     0.200
     3.643    12.240     0.200
     3.680    11.598     0.200
     3.747    10.475     0.200
     3.747    11.045     0.200
     3.747    10.642     0.200
     3.708    11.747     0.200
     3.784    10.848     0.200
     3.784    10.605     0.200
     3.847    11.148     0.200
     3.816    11.548     0.200
     3.816    11.947     0.200
     3.873    10.463     0.200
     3.873    10.313     0.200
     3.952    11.266     0.200
     3.956    12.478     0.200
     3.956    12.145     0.200
     4.041    10.739     0.200
     4.075    12.394     0.200
     4.138    11.751     0.200
     4.138    11.968     0.200
     4.121    13.148     0.200
     4.248    11.565     0.200
     4.248    11.995     0.200
     4.257    12.334     0.200
     4.257    12.998     0.200
     4.300    12.146     0.200
     4.300    12.575     0.200
     4.233    12.939     0.200
     4.308    12.693     0.200
     4.308    13.022     0.200
     4.453    12.783     0.200
     4.451    13.293     0.200
     4.541    12.301     0.200
     4.562    14.069     0.200
     4.562    14.171     0.200
     4.631    12.933     0.200
     4.631    13.424     0.200
     4.661    12.660     0.200
     4.613    13.183     0.200
     4.613    13.437     0.200
     4.647    13.242     0.200
     4.647    13.417     0.200
     4.701    13.238     0.200
     4.701    13.136     0.200
     4.714    12.613     0.200
     4.712    13.181     0.200
     4.712    13.331     0.200
     4.834    13.347     0.200
     4.835    13.304     0.200
     4.905    13.704     0.200
     4.936    13.284     0.200
     4.939    12.896     0.200
     4.942    12.947     0.200
     4.942    12.802     0.200
     4.962    13.522     0.200
     4.962    13.739     0.200
     4.981    13.178     0.200
     5.025    14.201     0.200
     5.025    14.318     0.200
     5.045    14.074     0.200
     5.045    14.409     0.200
     5.089    13.562     0.200
     5.089    14.810     0.200
     5.115    13.364     0.200
     5.121    14.316     0.200
     5.121    13.884     0.200
     5.126    14.604     0.200
     5.133    14.075     0.200
     5.232    14.630     0.200
     5.148    13.944     0.200
     5.148    15.194     0.200
     5.148    15.436     0.200
     5.202    14.890     0.200
     5.202    14.613     0.200
     5.260    14.641     0.200
     5.260    15.071     0.200
     5.277    14.024     0.200
     5.277    13.891     0.200
     5.295    14.313     0.200
     5.428    14.337     0.200
     5.445    14.627     0.200
     5.445    14.995     0.200
     5.462    14.976     0.200
     5.450    15.018     0.200
     5.450    14.777     0.200
     5.503    14.581     0.200
     5.509    14.529     0.200
     5.523    14.567     0.200
     5.558    14.336     0.200
     5.546    15.537     0.200
     5.546    15.781     0.200
     5.578    14.812     0.200
     5.578    15.714     0.200
     5.603    15.118     0.200
     5.610    15.518     0.200
     5.629    15.135     0.200
     5.644    14.884     0.200
     5.690    15.103     0.200
     5.717    15.459     0.200
     5.717    15.972     0.200
     5.682    15.549     0.200
     5.732    15.774     0.200
     5.732    16.199     0.200
     5.815    15.196     0.200
     5.815    15.556     0.200
     5.804    15.248     0.200
     5.804    15.587     0.200
     5.773    15.984     0.200
     5.830    16.089     0.200
     5.830    16.015     0.200
     5.830    16.137     0.200
     5.796    15.982     0.200
     5.882    15.374     0.200
     5.882    15.894     0.200
     5.867    16.509     0.200
     5.867    15.984     0.200
     5.893    15.919     0.200
     5.893    15.796     0.200
     5.886    15.716     0.200
     5.886    15.992     0.200
     5.920    15.476     0.200
     5.973    15.857     0.200
     6.036    16.332     0.200
     6.056    15.973     0.200
     6.135    16.814     0.200
     6.214    16.479     0.200
     6.213    16.344     0.200
     6.213    16.643     0.200
     6.287    16.314     0.200
     6.354    16.503     0.200
     6.401    16.936     0.200
     6.405    16.839     0.200
     6.451    18.318     0.200
     6.454    17.529     0.200
     6.515    16.756     0.200
     6.512    15.982     0.200
     6.512    16.496     0.200
     6.502    16.199     0.200
     6.502    17.598     0.200
     6.544    15.968     0.200
     6.611    18.186     0.200
     6.611    18.410     0.200
     6.654    17.399     0.200
     6.654    17.518     0.200
     6.699    17.038     0.200
     6.699    18.109     0.200
     6.684    16.725     0.200
     6.684    17.712     0.200
     6.707    17.143     0.200
     6.707    17.579     0.200
     6.707    17.840     0.200
     6.707    17.963     0.200
     6.755    16.004     0.200
     6.766    17.725     0.200
     6.769    17.090     0.200
     6.769    17.816     0.200
     6.855    17.419     0.200
     6.855    17.716     0.200
     6.793    17.445     0.200
     6.793    19.094     0.200
     6.793    18.699     0.200
     6.883    17.718     0.200
     6.883    18.298     0.200
     6.855    17.923     0.200
     6.855    18.490     0.200
     6.933    18.165     0.200
     6.957    17.022     0.200
     6.957    17.482     0.200
     6.957    19.262     0.200
     6.977    17.175     0.200
     6.995    17.465     0.200
     7.010    17.774     0.200
     7.035    17.502     0.200
     7.035    17.412     0.200
     7.035    16.772     0.200
     7.080    18.223     0.200
     7.084    17.784     0.200
     7.084    18.004     0.200
     7.084    18.152     0.200
     7.091    18.919     0.200
     7.102    18.774     0.200
     7.178    17.929     0.200
     7.178    18.587     0.200
     7.195    18.241     0.200
     7.223    17.488     0.200
     7.223    18.559     0.200
     7.228    19.668     0.200
     7.218    18.512     0.200
     7.251    17.629     0.200
     7.251    18.571     0.200
     7.291    18.239     0.200
     7.291    18.580     0.200
     7.322    18.218     0.200
     7.322    18.788     0.200
     7.384    19.570     0.200
     7.393    18.819     0.200
     7.569    19.784     0.200
     7.569    19.524     0.200
     7.600    18.323     0.200
     7.600    19.275     0.200
     7.591    19.712     0.200
     7.650    19.213     0.200
     7.650    19.360     0.200
     7.660    19.828     0.200
     7.707    20.455     0.200
     7.707    19.604     0.200
     7.718    20.155     0.200
     7.793    19.681     0.200
     7.856    19.937     0.200
     7.922    19.773     0.200
     7.922    20.073     0.200
     7.968    20.860     0.200
     7.968    20.226     0.200
     8.025    20.773     0.200
     8.039    20.956     0.200
     8.050    20.509     0.200
     8.179    21.110     0.200
     8.179    20.561     0.200
     8.189    20.532     0.200
     8.219    20.795     0.200
     8.219    20.510     0.200
     8.338    20.036     0.200
     8.338    20.756     0.200
     8.348    20.979     0.200
     8.345    21.111     0.200
     8.332    21.634     0.200
     8.482    21.079     0.200
     8.515    20.844     0.200
     8.497    21.978     0.200
     8.580    21.379     0.200
     8.617    21.783     0.200
     8.614    22.209     0.200
     8.641    21.290     0.200
     8.651    21.344     0.200
     8.651    21.671     0.200
     8.729    21.616     0.200
     8.793    22.057     0.200
     8.811    19.939     0.200
     8.811    20.219     0.200
     8.815    22.713     0.200
     8.853    21.702     0.200
     8.853    22.073     0.200
     8.898    22.167     0.200
     8.851    21.379     0.200
     8.851    21.195     0.200
     8.953    22.946     0.200
     8.978    22.626     0.200
     8.987    21.984     0.200
     8.982    22.605     0.200
     8.988    21.646     0.200
     8.980    21.885     0.200
     9.003    21.922     0.200
     9.132    22.407     0.200
     9.146    22.598     0.200
     9.146    22.338     0.200
     9.186    23.345     0.200
     9.230    23.379     0.200
     9.230    23.091     0.200
     9.196    23.822     0.200
     9.351    23.142     0.200
     9.339    23.515     0.200
     9.429    22.943     0.200
     9.463    22.898     0.200
     9.483    22.937     0.200
     9.485    20.885     0.200
     9.485    21.012     0.200
     9.566    24.148     0.200
     9.660    23.679     0.200
     9.653    23.986     0.200
     9.741    24.468     0.200
     9.779    23.058     0.200
     9.779    23.448     0.200
     9.823    23.449     0.200
     9.822    23.664     0.200
     9.843    24.200     0.200
     9.842    23.484     0.200
     9.910    23.822     0.200
     9.941    23.263     0.200
     9.941    23.863     0.200
     9.945    24.343     0.200
     9.966    23.753     0.200
     9.966    23.969     0.200
    10.049    25.433     0.200
    10.049    24.480     0.200
    10.042    25.204     0.200
    10.087    25.367     0.200
    10.130    24.611     0.200
    10.157    24.629     0.200
    10.323    24.822     0.200
    10.351    25.840     0.200
    10.359    25.129     0.200
    10.359    23.872     0.200
    10.379    25.103     0.200
    10.379    25.920     0.200
    10.422    24.499     0.200
    10.420    24.576     0.200
    10.420    24.407     0.200
    10.422    24.652     0.200
    10.422    25.596     0.200
    10.432    26.415     0.200
    10.560    26.895     0.200
    10.502    26.280     0.200
    10.689    26.669     0.200
    10.746    26.210     0.200
    10.746    25.481     0.200
    10.869    26.812     0.200
    10.954    26.847     0.200
    10.975    25.278     0.200
    10.975    26.384     0.200
    10.957    26.457     0.200
    11.064    26.895     0.200
    11.126    26.862     0.200
    11.172    25.698     0.200
    11.175    27.893     0.200
    11.329    28.679     0.200
    11.360    27.202     0.200
    11.376    26.565     0.200
    11.408    26.323     0.200
    11.383    24.771     0.200
    11.454    25.792     0.200
    11.495    26.890     0.200
    11.561    28.017     0.200
    11.835    27.716     0.200
    11.975    28.743     0.200
    11.975    28.588     0.200
    11.975    28.899     0.200
    12.018    27.495     0.200
    12.046    29.078     0.200
    12.065    26.381     0.200
    12.180    29.334     0.200
    12.180    29.174     0.200
    13.150    28.730     0.200
    13.150    28.383     0.200
    13.590    31.281     0.200
    15.352    33.486     0.200
    16.588    34.022     0.200
    17.652    35.264     0.200
    19.409    36.125     0.200
     0.359     7.409     0.200
     0.402     7.379     0.200
     0.503     7.204     0.200
     0.518     7.410     0.200
     0.526     7.139     0.200
     0.554     7.262     0.200
     0.566     6.941     0.200
     0.658     7.054     0.200
     0.666     6.706     0.200
     0.665     6.946     0.200
     0.696     6.748     0.200
     0.696     6.634     0.200
     0.727     6.675     0.200
     0.727     6.827     0.200
     0.789     6.935     0.200
     0.808     7.206     0.200
     0.840     6.744     0.200
     0.920     6.920     0.200
     0.920     6.811     0.200
     0.919     6.810     0.200
     0.943     7.159     0.200
     0.953     6.952     0.200
     1.266     6.749     0.200
     1.275     6.823     0.200
     1.275     6.956     0.200
     1.320     7.233     0.200
     1.370     6.875     0.200
     1.409     7.389     0.200
     1.640     7.670     0.200
     1.657     8.347     0.200
     1.659     8.281     0.200
     1.668     7.459     0.200
     1.830     7.606     0.200
     1.838     8.770     0.200
     1.881     8.086     0.200
     1.882     8.515     0.200
     1.941     7.271     0.200
     2.026     8.367     0.200
     2.130     8.524     0.200
     2.146     9.090     0.200
     2.309     8.692     0.200
     2.335     8.540     0.200
     2.335     8.708     0.200
     2.454     8.943     0.200
     2.499     9.337     0.200
     2.522    10.029     0.200
     2.536     9.925     0.200
     2.624    10.483     0.200
     2.624    10.280     0.200
     2.670    10.430     0.200
     2.684     9.834     0.200
     2.738     9.945     0.200
     2.847    10.287     0.200
     2.861    10.423     0.200
     2.860    10.330     0.200
     2.900    10.183     0.200
     2.939    10.993     0.200
     2.939    10.785     0.200
     2.975     9.687     0.200
     2.982    11.195     0.200
     2.989    11.060     0.200
     2.989    10.092     0.200
     3.020     9.919     0.200
     3.013    10.133     0.200
     3.040    11.113     0.200
     3.091    11.149     0.200
     3.104    11.017     0.200
     3.115    11.409     0.200
     3.158    11.272     0.200
     3.354    11.166     0.200
     3.387    10.845     0.200
     3.387    11.134     0.200
     3.578    11.752     0.200
     3.578    11.877     0.200
     3.603    11.484     0.200
     3.732    11.267     0.200
     3.751    10.635     0.200
     3.767    12.811     0.200
     3.769    12.802     0.200
     3.791    11.938     0.200
     3.792    13.450     0.200
     3.836    12.889     0.200
     3.839    13.449     0.200
     3.840    11.477     0.200
     3.840    12.047     0.200
     3.840    11.875     0.200
     3.860    12.115     0.200
     3.857    10.487     0.200
     3.865    10.109     0.200
     3.876    12.127     0.200
     3.889    13.000     0.200
     3.889    12.568     0.200
     4.092    12.685     0.200
     4.115    13.437     0.200
     4.152    12.342     0.200
     4.198    12.918     0.200
     4.274    13.712     0.200
     4.274    13.598     0.200
     4.323    12.703     0.200
     4.334    13.523     0.200
     4.368    13.135     0.200
     4.465    13.371     0.200
     4.465    13.509     0.200
     4.482    13.831     0.200
     4.504    13.420     0.200
     4.571    12.566     0.200
     4.577    13.378     0.200
     4.577    13.245     0.200
     4.577    12.778     0.200
     4.615    13.527     0.200
     4.615    13.812     0.200
     4.654    12.573     0.200
     4.666    13.494     0.200
     4.666    13.740     0.200
     4.709    13.305     0.200
     4.798    14.412     0.200
     4.858    13.215     0.200
     4.858    13.372     0.200
     4.863    13.159     0.200
     4.983    13.717     0.200
     5.058    14.589     0.200
     5.098    13.933     0.200
     5.127    14.156     0.200
     5.152    12.756     0.200
     5.154    13.827     0.200
     5.238    14.870     0.200
     5.238    15.139     0.200
     5.257    14.897     0.200
     5.261    15.653     0.200
     5.310    14.010     0.200
     5.310    13.814     0.200
     5.310    14.757     0.200
     5.336    13.075     0.200
     5.480    16.417     0.200
     5.556    13.960     0.200
     5.556    14.620     0.200
     5.556    14.073     0.200
     5.612    15.636     0.200
     5.612    15.457     0.200
     5.664    14.770     0.200
     5.664    14.652     0.200
     5.664    15.779     0.200
     5.664    15.912     0.200
     5.695    15.348     0.200
     5.811    16.167     0.200
     5.829    15.223     0.200
     5.890    16.279     0.200
     5.942    15.767     0.200
     5.942    15.575     0.200
     5.970    15.530     0.200
     5.971    15.473     0.200
     5.974    15.641     0.200
     6.026    15.685     0.200
     6.046    15.561     0.200
     6.076    15.242     0.200
     6.148    15.963     0.200
     6.181    16.000     0.200
     6.196    16.072     0.200
     6.196    16.759     0.200
     6.208    16.218     0.200
     6.247    15.390     0.200
     6.253    16.339     0.200
     6.253    16.554     0.200
     6.252    15.997     0.200
     6.290    16.798     0.200
     6.292    16.352     0.200
     6.314    17.238     0.200
     6.429    16.139     0.200
     6.482    16.587     0.200
     6.561    16.830     0.200
     6.561    16.522     0.200
     6.568    16.970     0.200
     6.568    16.123     0.200
     6.574    17.150     0.200
     6.688    16.945     0.200
     6.688    17.222     0.200
     6.721    17.217     0.200
     6.721    17.553     0.200
     6.774    17.375     0.200
     6.807    16.685     0.200
     6.813    17.561     0.200
     6.816    17.087     0.200
     6.836    16.783     0.200
     6.864    16.853     0.200
     6.958    17.584     0.200
     7.003    17.571     0.200
     7.020    18.637     0.200
     7.020    18.938     0.200
     7.094    18.236     0.200
     7.119    17.974     0.200
     7.203    18.445     0.200
     7.283    18.096     0.200
     7.449    18.952     0.200
     7.462    17.149     0.200
     7.524    19.299     0.200
     7.539    18.409     0.200
     7.539    18.979     0.200
     7.550    17.278     0.200
     7.554    19.649     0.200
     7.597    19.916     0.200
     7.600    18.821     0.200
     7.608    18.031     0.200
     7.614    19.540     0.200
     7.614    19.157     0.200
     7.616    19.102     0.200
     7.616    18.884     0.200
     7.626    19.287     0.200
     7.635    18.957     0.200
     7.715    19.391     0.200
     7.718    19.489     0.200
     7.748    19.201     0.200
     7.758    18.316     0.200
     7.761    19.664     0.200
     7.764    17.299     0.200
     7.789    19.575     0.200
     7.823    19.493     0.200
     7.829    19.325     0.200
     7.852    19.658     0.200
     7.920    18.459     0.200
     7.951    18.310     0.200
     8.011    19.890     0.200
     8.011    19.890     0.200
     8.024    20.430     0.200
     8.024    20.035     0.200
     8.051    20.337     0.200
     8.076    18.581     0.200
     8.076    17.710     0.200
     8.196    20.510     0.200
     8.218    21.254     0.200
     8.252    19.717     0.200
     8.258    19.758     0.200
     8.295    20.244     0.200
     8.304    20.711     0.200
     8.327    20.601     0.200
     8.367    21.198     0.200
     8.375    19.989     0.200
     8.398    20.771     0.200
     8.438    20.868     0.200
     8.456    20.737     0.200
     8.470    20.884     0.200
     8.526    19.788     0.200
     8.806    20.036     0.200
     8.845    21.306     0.200
     8.875    22.004     0.200
     8.922    22.766     0.200
     9.020    20.898     0.200
     9.197    23.587     0.200
     9.210    21.668     0.200
     9.469    22.591     0.200
     9.491    22.876     0.200
     9.522    23.180     0.200
     9.813    24.710     0.200
     9.829    23.021     0.200
     9.902    23.801     0.200
     9.966    22.596     0.200
    10.030    22.425     0.200
    10.163    23.536     0.200
    10.292    24.129     0.200
    10.428    23.855     0.200
    10.737    25.344     0.200
    10.762    25.207     0.200
    10.839    23.979     0.200
    10.891    26.961     0.200
    10.981    25.608     0.200
    11.252    26.076     0.200
    11.253    25.934     0.200
    11.530    27.183     0.200
    11.720    27.185     0.200
    11.735    27.155     0.200
    12.015    27.660     0.200
    12.076    26.150     0.200
    12.298    28.187     0.200
    12.658    29.503     0.200
    12.678    29.289     0.200
    13.232    30.266     0.200
    16.119    34.528     0.200
     0.352     8.543     0.200
     0.413     8.484     0.200
     0.514     8.470     0.200
     0.537     8.045     0.200
     0.577     8.038     0.200
     0.660     7.778     0.200
     0.676     8.000     0.200
     0.706     7.854     0.200
     0.729     7.657     0.200
     0.844     7.476     0.200
     0.931     7.718     0.200
     1.021     7.354     0.200
     1.255     7.415     0.200
     1.285     7.501     0.200
     1.318     7.625     0.200
     1.372     7.371     0.200
     1.417     7.963     0.200
     1.651     7.985     0.200
     1.663     8.405     0.200
     1.679     7.867     0.200
     1.931     7.529     0.200
     2.036     8.554     0.200
     2.141     9.038     0.200
     2.155     9.355     0.200
     2.331     8.598     0.200
     2.464     8.951     0.200
     2.474     9.683     0.200
     2.509    10.035     0.200
     2.679    10.338     0.200
     2.689     9.893     0.200
     2.857    10.480     0.200
     2.908     9.904     0.200
     2.992    11.749     0.200
     3.000    10.237     0.200
     2.998    10.870     0.200
     3.024    10.048     0.200
     3.049    11.100     0.200
     3.115    11.009     0.200
     3.365    11.029     0.200
     3.398    11.023     0.200
     3.588    11.633     0.200
     3.611    11.594     0.200
     3.650    13.047     0.200
     3.739    11.669     0.200
     3.756    10.491     0.200
     3.778    12.241     0.200
     3.803    11.791     0.200
     3.836    11.855     0.200
     3.848    12.790     0.200
     3.871    12.076     0.200
     3.888    12.401     0.200
     3.895    11.401     0.200
     4.100    12.588     0.200
     4.124    13.177     0.200
     4.162    12.251     0.200
     4.209    13.030     0.200
     4.284    13.542     0.200
     4.330    12.904     0.200
     4.342    13.383     0.200
     4.476    14.001     0.200
     4.588    12.918     0.200
     4.588    13.730     0.200
     4.624    13.473     0.200
     4.675    13.511     0.200
     4.660    12.559     0.200
     4.808    14.084     0.200
     4.903    13.779     0.200
     4.990    12.927     0.200
     5.066    14.925     0.200
     5.105    13.405     0.200
     5.268    14.901     0.200
     5.270    14.487     0.200
     5.320    14.790     0.200
     5.317    13.805     0.200
     5.341    13.107     0.200
     5.560    14.152     0.200
     5.623    15.557     0.200
     5.675    15.899     0.200
     5.671    14.571     0.200
     5.822    16.696     0.200
     5.900    15.950     0.200
     5.976    15.411     0.200
     6.206    16.419     0.200
     6.219    15.947     0.200
     6.259    16.163     0.200
     6.301    17.523     0.200
     6.427    16.977     0.200
     6.493    18.319     0.200
     6.567    17.177     0.200
     6.698    17.255     0.200
     6.811    16.980     0.200
     6.849    17.182     0.200
     6.868    17.629     0.200
     7.123    17.733     0.200
     7.452    19.092     0.200
     7.659    20.099     0.200
     7.930    18.256     0.200
     8.035    20.036     0.200
     8.335    19.463     0.200
     8.444    20.909     0.200
     8.462    20.845     0.200
     8.768    20.727     0.200
     8.876    22.161     0.200
     9.477    21.729     0.200
     9.832    22.571     0.200
     9.908    23.840     0.200
    10.297    25.108     0.200
     1.438     9.393     0.200
     1.464     8.937     0.200
     1.464     9.140     0.200
     1.586     9.588     0.200
     1.586     9.877     0.200
     1.704    10.680     0.200
     1.704     9.907     0.200
     1.797    10.955     0.200
     1.913    10.110     0.200
     2.116    11.442     0.200
     2.177    10.996     0.200
     2.207    11.592     0.200
     2.254    10.922     0.200
     2.247    11.310     0.200
     2.255    11.783     0.200
     2.257    11.135     0.200
     2.315    12.141     0.200
     2.369    11.715     0.200
     2.474    11.522     0.200
     2.474    11.420     0.200
     2.631    12.402     0.200
     2.631    12.957     0.200
     2.642    13.602     0.200
     2.723    12.689     0.200
     2.902    12.601     0.200
     2.902    12.702     0.200
     3.038    13.349     0.200
     3.172    13.135     0.200
     3.241    13.476     0.200
     3.349    12.820     0.200
     3.362    13.621     0.200
     3.627    14.470     0.200
 