#!/bin/bash
gmt begin kodiak1.21_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance kodiak1.21'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.100     8.039
     0.200     8.535
     0.300     9.298
     0.400    10.260
     0.500    11.362
     0.600    12.557
     0.700    13.811
     0.800    15.103
     0.900    16.419
     1.000    17.750
     1.100    19.091
     1.200    20.440
     1.300    21.793
     1.400    23.150
     1.500    24.510
     1.600    25.872
     1.700    27.235
     1.800    28.600
     1.900    29.967
     2.000    31.333
     2.100    32.701
     2.200    34.069
     2.300    35.438
     2.400    36.807
     2.500    38.176
     2.600    39.546
     2.700    40.916
     2.800    42.286
     2.900    43.656
     3.000    45.027
     3.100    46.398
     3.200    47.768
     3.300    49.139
     3.400    50.511
     3.500    51.882
     3.600    53.253
     3.700    54.624
     3.800    55.995
     3.900    57.367
     4.000    58.738
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    51.253 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.100    13.760
     0.200    14.617
     0.300    15.937
     0.400    17.609
     0.500    19.531
     0.600    21.628
     0.700    23.841
     0.800    26.130
     0.900    28.471
     1.000    30.844
     1.100    33.241
     1.200    35.652
     1.300    38.075
     1.400    40.505
     1.500    42.942
     1.600    45.383
     1.700    47.827
     1.800    50.274
     1.900    52.724
     2.000    55.175
     2.100    57.627
     2.200    60.081
     2.300    62.536
     2.400    64.991
     2.500    67.447
     2.600    69.904
     2.700    72.362
     2.800    74.819
     2.900    77.277
     3.000    79.735
     3.100    82.194
     3.200    84.653
     3.300    87.112
     3.400    89.571
     3.500    92.030
     3.600    94.489
     3.700    96.949
     3.800    99.408
     3.900   101.868
     4.000   104.328
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    92.489 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    18.522
     0.900    19.897
     1.000    21.273
     1.100    22.648
     1.200    24.023
     1.300    25.398
     1.400    26.774
     1.500    28.149
     1.600    29.524
     1.700    30.900
     1.800    32.275
     1.900    33.650
     2.000    35.025
     2.100    36.401
     2.200    37.776
     2.300    39.151
     2.400    40.527
     2.500    41.902
     2.600    43.277
     2.700    44.652
     2.800    46.028
     2.900    47.403
     3.000    48.778
     3.100    50.154
     3.200    51.529
     3.300    52.904
     3.400    54.280
     3.500    55.654
     3.600    57.029
     3.700    58.404
     3.800    59.779
     3.900    61.153
     4.000    62.528
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.917
     0.200     3.834
     0.300     5.751
     0.400     7.668
     0.500     9.585
     0.600    11.502
     0.700    13.419
     0.800    15.337
     0.900    17.254
     1.000    19.171
     1.100    21.088
     1.200    23.005
     1.300    24.922
     1.400    26.839
     1.500    28.712
     1.600    30.417
     1.700    32.122
     1.800    33.827
     1.900    35.533
     2.000    37.238
     2.100    38.943
     2.200    40.648
     2.300    42.354
     2.400    44.059
     2.500    45.764
     2.600    47.469
     2.700    49.174
     2.800    50.879
     2.900    52.584
     3.000    54.289
     3.100    55.994
     3.200    57.699
     3.300    59.404
     3.400    61.109
     3.500    62.814
     3.600    64.519
     3.700    66.223
     3.800    67.928
     3.900    69.633
     4.000    71.337
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    33.599
     1.000    36.067
     1.100    38.535
     1.200    41.003
     1.300    43.471
     1.400    45.939
     1.500    48.407
     1.600    50.876
     1.700    53.344
     1.800    55.812
     1.900    58.280
     2.000    60.748
     2.100    63.216
     2.200    65.684
     2.300    68.152
     2.400    70.620
     2.500    73.088
     2.600    75.556
     2.700    78.024
     2.800    80.493
     2.900    82.961
     3.000    85.429
     3.100    87.897
     3.200    90.365
     3.300    92.833
     3.400    95.301
     3.500    97.768
     3.600   100.235
     3.700   102.702
     3.800   105.169
     3.900   107.635
     4.000   110.102
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.214
     0.200     6.427
     0.300     9.641
     0.400    12.854
     0.500    16.068
     0.600    19.281
     0.700    22.495
     0.800    25.709
     0.900    28.922
     1.000    32.136
     1.100    35.349
     1.200    38.563
     1.300    41.777
     1.400    44.990
     1.500    48.204
     1.600    51.168
     1.700    54.047
     1.800    56.926
     1.900    59.805
     2.000    62.684
     2.100    65.563
     2.200    68.442
     2.300    71.321
     2.400    74.200
     2.500    77.079
     2.600    79.958
     2.700    82.836
     2.800    85.715
     2.900    88.594
     3.000    91.472
     3.100    94.351
     3.200    97.230
     3.300   100.107
     3.400   102.986
     3.500   105.864
     3.600   108.743
     3.700   111.621
     3.800   114.499
     3.900   117.377
     4.000   120.255
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    20.939
     0.200    21.089
     0.300    21.336
     0.400    21.678
     0.500    22.109
     0.600    22.624
     0.700    23.217
     0.800    23.882
     0.900    24.613
     1.000    25.403
     1.100    26.247
     1.200    27.139
     1.300    28.076
     1.400    29.050
     1.500    30.060
     1.600    31.100
     1.700    32.168
     1.800    33.262
     1.900    34.377
     2.000    35.512
     2.100    36.664
     2.200    37.833
     2.300    39.016
     2.400    40.212
     2.500    41.419
     2.600    42.637
     2.700    43.865
     2.800    45.101
     2.900    46.345
     3.000    47.596
     3.100    48.853
     3.200    50.117
     3.300    51.386
     3.400    52.660
     3.500    53.938
     3.600    55.221
     3.700    56.507
     3.800    57.798
     3.900    59.091
     4.000    60.387
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    36.912
     0.200    37.178
     0.300    37.617
     0.400    38.223
     0.500    38.987
     0.600    39.901
     0.700    40.954
     0.800    42.135
     0.900    43.434
     1.000    44.838
     1.100    46.339
     1.200    47.927
     1.300    49.593
     1.400    51.329
     1.500    53.128
     1.600    54.982
     1.700    56.887
     1.800    58.837
     1.900    60.827
     2.000    62.853
     2.100    64.912
     2.200    66.999
     2.300    69.113
     2.400    71.251
     2.500    73.410
     2.600    75.588
     2.700    77.784
     2.800    79.996
     2.900    82.222
     3.000    84.462
     3.100    86.714
     3.200    88.976
     3.300    91.249
     3.400    93.531
     3.500    95.822
     3.600    98.120
     3.700   100.426
     3.800   102.738
     3.900   105.057
     4.000   107.381
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     1.002   722.752     0.150
     1.002   722.092     0.150
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     8.125   113.000     0.200
    15.351   216.500     0.200
     3.957    59.574     0.200
     7.742   111.273     0.200
    15.410   218.273     0.200
     3.766    56.211     0.200
     7.554   108.012     0.200
     8.694   124.812     0.200
    15.557   217.812     0.200
    18.879   259.812     0.200
     8.038   114.598     0.200
     9.001   127.297     0.200
    15.706   221.598     0.200
    19.104   265.598     0.200
    20.318   279.598     0.200
     3.304    49.340     0.200
     7.080   100.641     0.200
    16.008   223.340     0.200
    19.415   265.340     0.200
    20.674   279.340     0.200
     0.877    16.664     0.200
     8.391   118.465     0.200
    16.091   226.363     0.200
     7.157   102.109     0.200
     9.230   129.109     0.200
    15.217   209.508     0.200
    15.973   223.609     0.200
    16.242   226.109     0.200
    19.213   262.809     0.200
    20.776   281.711     0.200
     7.924   112.555     0.200
     9.180   131.555     0.200
    14.194   201.055     0.200
    15.881   223.555     0.200
    15.937   224.555     0.200
     4.068    58.918     0.200
     4.864    70.219     0.200
     6.505    93.418     0.200
     6.836    97.020     0.200
     7.118   101.418     0.200
     7.296   103.418     0.200
    10.346   142.219     0.200
    12.835   181.617     0.200
    14.263   199.520     0.200
    17.098   237.219     0.200
     2.168    34.072     0.200
     3.515    52.572     0.200
     3.636    53.873     0.200
     4.252    63.172     0.200
     6.035    87.572     0.200
     6.970   100.473     0.200
     7.137   101.473     0.200
    15.583   219.373     0.200
    15.621   219.473     0.200
    15.931   222.473     0.200
    18.140   252.473     0.200
    19.776   271.473     0.200
     2.860    43.777     0.200
     4.307    63.477     0.200
     4.296    63.377     0.200
     4.827    71.277     0.200
     6.633    95.777     0.200
     7.662   109.078     0.200
     7.767   110.277     0.200
     7.846   111.178     0.200
     7.824   110.977     0.200
     8.548   119.777     0.200
     8.638   120.777     0.200
    15.347   216.777     0.200
    15.461   218.777     0.200
    15.686   217.777     0.200
    18.887   260.777     0.200
    19.475   268.777     0.200
     0.598    13.477     0.200
     3.631    53.477     0.200
     3.905    57.076     0.200
     3.842    55.877     0.200
     4.036    58.377     0.200
     4.752    68.977     0.200
     5.326    76.676     0.200
     6.180    88.275     0.200
     6.480    92.977     0.200
     6.753    94.877     0.200
     7.023    98.576     0.200
     7.155   100.877     0.200
     7.245   101.576     0.200
     7.257   101.576     0.200
     7.378   103.076     0.200
     7.942   111.576     0.200
     8.197   116.477     0.200
     9.224   128.275     0.200
     9.712   134.076     0.200
    10.212   141.477     0.200
    13.278   187.176     0.200
    14.759   202.275     0.200
    14.961   207.076     0.200
    20.125   269.576     0.200
     1.253    22.250     0.200
     1.392    22.852     0.200
     1.594    27.250     0.200
     2.139    34.750     0.200
     2.339    35.352     0.200
     2.338    36.352     0.200
     2.498    38.750     0.200
     2.766    41.652     0.200
     2.746    43.551     0.200
     2.877    45.652     0.200
     3.029    47.352     0.200
     3.214    49.152     0.200
     3.366    50.152     0.200
     3.932    59.453     0.200
     4.435    66.551     0.200
     5.413    78.551     0.200
     8.749   124.352     0.200
     8.860   125.852     0.200
     9.502   134.453     0.200
    10.051   141.152     0.200
    10.685   151.551     0.200
    14.681   205.352     0.200
    16.512   229.352     0.200
     1.223    21.445     0.200
     1.364    22.043     0.200
     1.381    23.543     0.200
     1.561    26.543     0.200
     2.311    35.746     0.200
     2.479    40.043     0.200
     2.475    37.945     0.200
     2.714    43.145     0.200
     2.750    41.145     0.200
     2.845    45.445     0.200
     3.001    46.746     0.200
     3.182    48.945     0.200
     4.425    65.645     0.200
     4.848    71.945     0.200
     5.387    78.145     0.200
     5.734    84.145     0.200
     5.973    87.344     0.200
     6.491    94.645     0.200
     6.644    96.445     0.200
     7.398   108.145     0.200
     7.455   107.844     0.200
     7.770   114.145     0.200
     7.889   113.645     0.200
     8.015   116.344     0.200
     8.259   117.645     0.200
     8.357   119.145     0.200
     8.607   122.145     0.200
     8.722   124.145     0.200
     8.764   125.145     0.200
     8.833   125.645     0.200
     8.860   126.543     0.200
     9.585   136.844     0.200
     9.508   133.344     0.200
    10.047   140.445     0.200
    10.193   145.645     0.200
    10.659   150.344     0.200
    10.909   154.145     0.200
    11.359   161.145     0.200
    14.660   207.145     0.200
    15.991   224.645     0.200
    19.955   272.645     0.200
    20.016   273.145     0.200
    20.293   279.543     0.200
    20.725   284.145     0.200
     1.254    22.224     0.200
     1.444    23.324     0.200
     1.609    27.724     0.200
     2.392    36.924     0.200
     2.557    39.224     0.200
     2.527    40.824     0.200
     2.829    42.124     0.200
     3.022    47.624     0.200
     3.189    50.424     0.200
     3.429    50.424     0.200
     4.498    65.624     0.200
     4.902    72.924     0.200
     4.998    74.024     0.200
     5.342    78.924     0.200
     5.396    78.824     0.200
     6.486    95.024     0.200
     6.694    97.624     0.200
     8.418   121.924     0.200
     8.737   123.824     0.200
     9.440   133.824     0.200
     9.622   137.824     0.200
    10.261   147.324     0.200
    10.670   152.324     0.200
    14.653   205.824     0.200
    19.910   273.224     0.200
     1.432    23.615     0.200
     1.608    27.516     0.200
     1.583    27.715     0.200
     1.846    29.715     0.200
     2.439    38.516     0.200
     2.450    40.215     0.200
     2.797    43.416     0.200
     2.682    43.314     0.200
     2.762    44.715     0.200
     2.792    45.615     0.200
     2.871    46.416     0.200
     2.987    46.916     0.200
     3.301    51.416     0.200
     4.843    72.516     0.200
     4.995    74.215     0.200
     5.301    76.416     0.200
     5.952    88.416     0.200
     6.573    95.615     0.200
     8.316   118.115     0.200
     8.316   118.615     0.200
     8.797   126.715     0.200
     9.366   136.416     0.200
    10.348   149.814     0.200
    14.103   199.115     0.200
    15.498   219.615     0.200
    15.385   217.115     0.200
    16.669   232.314     0.200
     0.575    11.961     0.200
     2.938    44.762     0.200
     3.157    47.262     0.200
     3.412    50.363     0.200
     3.818    55.664     0.200
     3.873    55.762     0.200
     4.518    65.863     0.200
     4.911    71.562     0.200
     5.119    73.664     0.200
     5.087    73.562     0.200
     5.794    84.062     0.200
     5.948    85.562     0.200
     6.205    88.961     0.200
     6.573    93.664     0.200
     6.774    96.961     0.200
     6.943    98.461     0.200
     7.067    99.562     0.200
     7.067   100.062     0.200
     7.824   112.164     0.200
     8.679   124.664     0.200
    13.218   183.562     0.200
    15.007   209.562     0.200
    19.175   259.562     0.200
    19.230   260.562     0.200
     0.722    14.839     0.200
     0.784    16.399     0.200
     0.824    16.680     0.200
     1.106    20.089     0.200
     1.195    21.600     0.200
     1.221    22.189     0.200
     1.228    22.159     0.200
     1.242    22.259     0.200
     1.523    25.970     0.200
     1.641    27.430     0.200
     1.856    30.039     0.200
     1.968    31.279     0.200
     2.152    33.729     0.200
     2.246    35.989     0.200
     2.319    36.310     0.200
     2.511    38.640     0.200
     2.873    45.720     0.200
     2.909    43.039     0.200
     2.938    43.879     0.200
     3.127    47.379     0.200
     3.139    47.239     0.200
     3.145    47.409     0.200
     3.187    48.279     0.200
     3.216    48.869     0.200
     3.273    49.529     0.200
     3.349    50.419     0.200
     3.590    52.970     0.200
     3.629    54.770     0.200
     3.942    57.879     0.200
     3.985    58.470     0.200
     3.999    58.239     0.200
     4.129    59.939     0.200
     4.186    60.959     0.200
     4.291    62.100     0.200
     4.306    61.479     0.200
     4.443    63.609     0.200
     4.570    66.449     0.200
     4.584    67.189     0.200
     4.625    66.289     0.200
     4.691    67.539     0.200
     4.698    67.089     0.200
     4.717    68.439     0.200
     4.718    68.009     0.200
     4.735    67.759     0.200
     4.755    68.579     0.200
     4.824    69.699     0.200
     4.911    70.720     0.200
     4.942    72.439     0.200
     5.076    72.799     0.200
     5.107    73.609     0.200
     5.131    73.839     0.200
     5.142    73.989     0.200
     5.285    76.209     0.200
     5.334    77.149     0.200
     5.444    77.819     0.200
     5.439    79.140     0.200
     5.581    81.239     0.200
     5.768    83.100     0.200
     5.781    82.140     0.200
     5.907    85.020     0.200
     5.950    84.720     0.200
     5.978    84.720     0.200
     6.053    87.129     0.200
     6.090    86.899     0.200
     6.285    88.789     0.200
     6.285    89.579     0.200
     6.413    91.089     0.200
     6.797    98.259     0.200
     6.809    96.589     0.200
     6.851    97.979     0.200
     6.878    97.149     0.200
     7.053   100.529     0.200
     7.090    99.850     0.200
     7.193   102.539     0.200
     7.322   102.739     0.200
     7.342   104.939     0.200
     7.475   105.520     0.200
     7.950   114.439     0.200
     8.624   122.339     0.200
     9.877   137.039     0.200
     0.605    13.395     0.200
     0.747    14.125     0.200
     0.935    18.094     0.200
     0.966    18.383     0.200
     1.384    23.625     0.200
     1.487    24.746     0.200
     1.520    24.875     0.200
     1.798    30.004     0.200
     1.971    31.465     0.200
     2.141    33.934     0.200
     2.449    39.605     0.200
     2.432    36.574     0.200
     2.478    37.695     0.200
     2.765    42.766     0.200
     2.770    42.703     0.200
     2.830    43.734     0.200
     2.847    44.035     0.200
     2.898    44.594     0.200
     2.990    45.125     0.200
     2.983    45.785     0.200
     3.211    48.445     0.200
     3.272    48.824     0.200
     3.550    52.625     0.200
     3.604    53.574     0.200
     3.549    52.223     0.200
     3.677    53.812     0.200
     3.677    53.824     0.200
     3.828    55.035     0.200
     3.882    56.766     0.200
     4.071    59.285     0.200
     4.147    59.855     0.200
     4.738    69.426     0.200
     4.653    67.375     0.200
     4.673    67.453     0.200
     4.815    69.594     0.200
     4.968    72.125     0.200
     5.193    75.223     0.200
     5.207    74.766     0.200
     5.348    76.875     0.200
     5.474    78.086     0.200
     5.472    78.215     0.200
     5.636    80.945     0.200
     5.620    80.266     0.200
     5.820    83.223     0.200
     6.346    91.625     0.200
     6.411    90.312     0.200
     6.464    91.273     0.200
     6.623    93.723     0.200
     6.674    93.863     0.200
     6.751    95.953     0.200
     6.910    97.613     0.200
     6.910    97.223     0.200
     6.905    99.125     0.200
     7.059    99.184     0.200
     7.649   108.125     0.200
     8.164   115.926     0.200
     8.578   120.824     0.200
     8.874   123.535     0.200
     9.510   131.023     0.200
    12.999   178.023     0.200
    13.085   179.824     0.200
    14.858   207.023     0.200
    19.913   268.824     0.200
     0.748    14.560     0.200
     1.367    22.970     0.200
     1.475    24.260     0.200
     1.888    30.229     0.200
     1.913    30.300     0.200
     1.915    31.050     0.200
     1.916    30.979     0.200
     1.916    30.659     0.200
     1.921    31.229     0.200
     1.935    31.909     0.200
     2.217    35.290     0.200
     2.462    38.069     0.200
     2.470    38.670     0.200
     2.893    44.130     0.200
     3.012    45.609     0.200
     3.054    46.439     0.200
     3.057    46.329     0.200
     3.056    46.439     0.200
     3.072    46.399     0.200
     3.088    46.640     0.200
     3.107    47.369     0.200
     3.141    47.260     0.200
     3.191    47.619     0.200
     3.201    47.880     0.200
     3.477    50.640     0.200
     3.566    52.130     0.200
     3.779    55.460     0.200
     3.819    56.270     0.200
     3.835    56.220     0.200
     3.880    57.279     0.200
     3.963    58.390     0.200
     4.025    58.449     0.200
     4.040    59.560     0.200
     4.264    61.109     0.200
     4.302    63.149     0.200
     4.364    63.560     0.200
     4.646    68.060     0.200
     4.674    68.569     0.200
     4.770    68.229     0.200
     4.770    68.659     0.200
     4.803    68.880     0.200
     4.853    69.130     0.200
     4.975    71.369     0.200
     5.000    70.859     0.200
     5.160    73.540     0.200
     5.170    73.890     0.200
     5.263    76.270     0.200
     5.299    75.829     0.200
     5.599    80.560     0.200
     5.688    81.409     0.200
     5.905    85.399     0.200
     6.033    87.260     0.200
     6.237    89.829     0.200
     6.252    90.310     0.200
     6.272    91.310     0.200
     6.395    91.180     0.200
     6.441    92.180     0.200
     6.458    91.829     0.200
     6.531    92.729     0.200
     6.726    96.770     0.200
     6.868    97.520     0.200
     6.874    98.029     0.200
     6.899    98.300     0.200
     7.285   103.710     0.200
     7.555   106.069     0.200
     7.718   109.060     0.200
     7.766   108.790     0.200
     7.982   113.270     0.200
     8.000   112.260     0.200
     8.151   114.880     0.200
     8.639   124.060     0.200
     9.068   126.619     0.200
    10.002   141.060     0.200
    14.170   196.560     0.200
    14.345   199.859     0.200
     1.470    24.942     0.200
     1.757    29.322     0.200
     1.941    32.042     0.200
     1.963    32.302     0.200
     2.058    33.152     0.200
     2.273    35.522     0.200
     2.253    35.922     0.200
     2.254    35.952     0.200
     2.256    35.992     0.200
     2.272    35.692     0.200
     2.283    36.302     0.200
     2.305    36.412     0.200
     2.315    36.222     0.200
     2.259    35.492     0.200
     2.368    37.112     0.200
     2.377    37.552     0.200
     2.429    39.392     0.200
     2.767    41.482     0.200
     2.821    42.982     0.200
     2.790    42.792     0.200
     2.887    44.132     0.200
     2.921    45.152     0.200
     2.937    45.402     0.200
     2.978    45.012     0.200
     2.979    43.342     0.200
     2.992    46.182     0.200
     3.010    46.202     0.200
     3.075    46.822     0.200
     3.114    47.822     0.200
     3.168    48.022     0.200
     3.258    48.892     0.200
     3.372    49.812     0.200
     3.425    52.122     0.200
     3.436    51.212     0.200
     3.473    51.702     0.200
     3.473    51.252     0.200
     3.494    51.312     0.200
     3.517    52.452     0.200
     3.648    53.972     0.200
     3.683    54.603     0.200
     3.676    54.912     0.200
     3.670    55.152     0.200
     3.810    56.632     0.200
     3.819    56.672     0.200
     3.846    56.912     0.200
     3.943    59.092     0.200
     4.017    58.592     0.200
     4.069    60.702     0.200
     4.134    63.032     0.200
     4.178    61.182     0.200
     4.209    62.132     0.200
     4.603    68.422     0.200
     4.750    70.082     0.200
     4.774    70.132     0.200
     4.778    71.312     0.200
     4.997    72.672     0.200
     5.116    74.072     0.200
     5.118    75.232     0.200
     5.174    75.542     0.200
     5.148    75.042     0.200
     5.250    77.362     0.200
     5.253    77.212     0.200
     5.334    77.572     0.200
     5.349    77.642     0.200
     5.499    80.112     0.200
     5.558    81.432     0.200
     5.752    83.812     0.200
     5.818    86.322     0.200
     5.995    87.072     0.200
     6.273    90.332     0.200
     6.350    91.222     0.200
     6.356    93.622     0.200
     6.371    92.022     0.200
     6.374    91.682     0.200
     6.423    94.122     0.200
     6.470    93.172     0.200
     6.574    94.622     0.200
     6.591    94.132     0.200
     6.820    97.302     0.200
     6.954    99.952     0.200
     7.846   111.732     0.200
    20.725   279.912     0.200
     0.095     5.992     0.200
     0.773    14.482     0.200
     1.243    21.053     0.200
     1.572    26.213     0.200
     1.586    26.764     0.200
     1.597    26.383     0.200
     1.602    26.844     0.200
     1.669    27.684     0.200
     1.612    26.623     0.200
     1.618    27.014     0.200
     1.652    26.652     0.200
     1.816    29.344     0.200
     1.877    30.453     0.200
     1.854    30.094     0.200
     2.106    32.844     0.200
     2.244    35.014     0.200
     2.257    35.004     0.200
     2.588    39.533     0.200
     2.631    40.383     0.200
     2.632    40.402     0.200
     2.653    40.553     0.200
     2.657    40.713     0.200
     2.768    40.982     0.200
     2.737    41.684     0.200
     2.760    42.062     0.200
     2.923    43.514     0.200
     2.983    46.402     0.200
     3.112    46.094     0.200
     3.314    48.332     0.200
     3.241    48.623     0.200
     3.359    49.992     0.200
     3.366    51.082     0.200
     3.373    50.424     0.200
     3.397    51.113     0.200
     3.433    51.363     0.200
     3.436    51.104     0.200
     3.441    51.094     0.200
     3.598    52.193     0.200
     3.486    52.113     0.200
     3.578    53.232     0.200
     3.706    54.184     0.200
     3.640    52.514     0.200
     3.729    54.492     0.200
     3.743    55.242     0.200
     4.020    58.293     0.200
     4.046    59.594     0.200
     4.132    59.613     0.200
     4.131    59.754     0.200
     4.133    59.582     0.200
     4.251    60.773     0.200
     4.181    61.174     0.200
     4.410    63.723     0.200
     4.503    65.293     0.200
     4.561    65.893     0.200
     4.692    68.053     0.200
     4.713    69.393     0.200
     4.957    71.473     0.200
     5.074    72.193     0.200
     5.330    77.383     0.200
     5.391    77.543     0.200
     5.518    80.184     0.200
     5.700    81.533     0.200
     5.756    82.344     0.200
     5.733    82.723     0.200
     5.833    83.822     0.200
     6.095    86.844     0.200
     6.303    90.533     0.200
     6.509    93.344     0.200
     6.728    96.184     0.200
     7.000    99.393     0.200
     7.065   100.232     0.200
     7.449   106.492     0.200
     7.434   103.553     0.200
     7.459   105.354     0.200
     8.192   115.943     0.200
     8.275   118.033     0.200
     9.300   128.982     0.200
     0.786    20.297     0.200
     0.849    20.602     0.200
     1.189    24.227     0.200
     1.203    24.555     0.200
     1.205    24.875     0.200
     1.210    23.852     0.200
     1.220    24.820     0.200
     1.225    24.844     0.200
     1.373    26.125     0.200
     1.389    26.086     0.200
     1.539    26.164     0.200
     1.873    32.320     0.200
     2.106    35.484     0.200
     2.222    36.375     0.200
     2.253    37.195     0.200
     2.295    37.914     0.200
     2.295    37.891     0.200
     2.332    38.250     0.200
     2.424    39.773     0.200
     2.471    40.172     0.200
     2.482    39.891     0.200
     2.490    39.711     0.200
     2.645    41.977     0.200
     2.943    46.109     0.200
     3.071    47.820     0.200
     3.091    47.852     0.200
     3.097    48.414     0.200
     3.119    48.570     0.200
     3.141    49.164     0.200
     3.180    48.805     0.200
     3.212    49.609     0.200
     3.262    50.609     0.200
     3.289    49.906     0.200
     3.904    57.953     0.200
     3.999    59.062     0.200
     4.077    60.273     0.200
     4.089    60.156     0.200
     4.294    61.664     0.200
     4.418    64.164     0.200
     4.490    64.711     0.200
     4.351    62.977     0.200
     4.482    66.250     0.200
     4.598    66.953     0.200
     4.720    67.820     0.200
     4.755    69.383     0.200
     4.898    69.883     0.200
     4.999    72.062     0.200
     5.103    73.336     0.200
     5.128    74.484     0.200
     5.157    74.414     0.200
     5.223    76.047     0.200
     5.459    78.766     0.200
     5.475    78.461     0.200
     5.487    79.492     0.200
     5.704    81.656     0.200
     5.777    82.875     0.200
     5.962    86.773     0.200
     6.031    86.320     0.200
     6.191    88.156     0.200
     6.298    89.586     0.200
     6.363    90.445     0.200
     6.492    92.656     0.200
     6.737    94.172     0.200
     6.857    96.094     0.200
     6.872    97.000     0.200
     6.897    98.070     0.200
     7.072    98.930     0.200
     7.086    99.461     0.200
     7.150   102.383     0.200
     7.247   101.750     0.200
     7.290   101.773     0.200
     7.302   104.570     0.200
     7.396   102.977     0.200
     7.396   103.266     0.200
     7.456   104.172     0.200
     7.546   107.547     0.200
     7.634   108.172     0.200
     7.838   112.305     0.200
     7.935   111.906     0.200
     7.969   113.656     0.200
     9.270   129.070     0.200
    10.617   146.070     0.200
    12.888   177.352     0.200
    13.679   188.453     0.200
     0.596    12.023     0.200
     1.024    18.043     0.200
     1.357    23.496     0.200
     1.372    23.805     0.200
     1.381    24.086     0.200
     1.382    23.414     0.200
     1.387    23.734     0.200
     1.403    24.035     0.200
     1.437    23.836     0.200
     1.509    25.496     0.200
     1.644    27.406     0.200
     1.675    27.355     0.200
     1.715    28.156     0.200
     1.920    30.246     0.200
     1.896    29.906     0.200
     2.039    32.355     0.200
     2.137    33.996     0.200
     2.389    37.023     0.200
     2.433    37.895     0.200
     2.433    37.844     0.200
     2.460    38.176     0.200
     2.549    39.125     0.200
     2.563    39.543     0.200
     2.665    39.535     0.200
     2.784    41.523     0.200
     2.815    44.016     0.200
     2.996    44.215     0.200
     3.051    46.016     0.200
     3.171    47.254     0.200
     3.175    48.496     0.200
     3.183    47.844     0.200
     3.208    48.645     0.200
     3.240    48.977     0.200
     3.245    48.695     0.200
     3.252    48.496     0.200
     3.399    49.926     0.200
     3.421    50.336     0.200
     3.576    52.945     0.200
     3.589    52.855     0.200
     3.595    52.254     0.200
     3.893    57.355     0.200
     3.966    57.633     0.200
     3.994    57.855     0.200
     3.994    57.125     0.200
     3.999    58.625     0.200
     4.008    58.113     0.200
     4.200    60.816     0.200
     4.373    63.086     0.200
     4.360    62.754     0.200
     4.481    64.605     0.200
     4.545    66.094     0.200
     4.666    67.664     0.200
     4.871    70.414     0.200
     5.182    75.035     0.200
     5.175    74.453     0.200
     5.225    75.953     0.200
     5.079    72.055     0.200
     5.423    78.805     0.200
     5.559    80.625     0.200
     5.602    81.023     0.200
     5.641    80.664     0.200
     5.695    81.805     0.200
     5.737    83.035     0.200
     6.001    86.184     0.200
     6.062    86.605     0.200
     6.099    86.996     0.200
     6.309    90.555     0.200
     6.351    90.664     0.200
     6.789    95.785     0.200
     6.826    96.484     0.200
     6.966    98.895     0.200
     7.034    98.605     0.200
     7.080   100.543     0.200
     7.122   104.504     0.200
     7.273   101.676     0.200
     7.306   102.543     0.200
     7.306   102.586     0.200
     7.366   104.754     0.200
     7.418   105.293     0.200
     7.991   112.734     0.200
     8.074   113.895     0.200
     8.933   127.883     0.200
     9.390   130.555     0.200
    10.108   139.816     0.200
    20.734   278.285     0.200
     0.646    12.947     0.200
     0.789    15.367     0.200
     1.447    25.076     0.200
     1.511    25.707     0.200
     1.490    25.867     0.200
     1.646    27.916     0.200
     1.691    29.057     0.200
     1.691    28.746     0.200
     1.710    27.996     0.200
     1.711    29.277     0.200
     1.718    29.346     0.200
     1.730    29.436     0.200
     1.732    29.496     0.200
     1.768    28.916     0.200
     1.893    31.717     0.200
     1.931    31.307     0.200
     2.027    32.916     0.200
     2.175    35.137     0.200
     2.217    35.326     0.200
     2.219    35.336     0.200
     2.233    35.797     0.200
     2.318    35.586     0.200
     2.289    36.406     0.200
     2.426    38.326     0.200
     2.506    38.906     0.200
     2.564    39.746     0.200
     2.573    39.986     0.200
     2.596    40.256     0.200
     2.662    40.836     0.200
     2.666    41.246     0.200
     2.687    40.676     0.200
     2.730    41.156     0.200
     2.731    43.367     0.200
     2.765    41.777     0.200
     2.991    46.746     0.200
     3.099    46.717     0.200
     3.248    48.766     0.200
     3.278    48.877     0.200
     3.281    49.326     0.200
     3.291    49.686     0.200
     3.326    49.676     0.200
     3.365    50.447     0.200
     3.469    51.807     0.200
     3.611    53.186     0.200
     3.668    54.176     0.200
     3.717    54.457     0.200
     3.721    55.646     0.200
     3.760    55.387     0.200
     3.760    55.096     0.200
     3.768    56.076     0.200
     3.963    58.477     0.200
     4.045    59.906     0.200
     4.088    60.697     0.200
     4.100    60.496     0.200
     4.337    64.326     0.200
     4.434    66.537     0.200
     4.449    65.396     0.200
     4.860    72.047     0.200
     4.915    72.586     0.200
     5.024    74.756     0.200
     5.034    73.736     0.200
     5.147    74.836     0.200
     5.166    75.336     0.200
     5.243    77.316     0.200
     5.376    78.346     0.200
     5.445    79.846     0.200
     5.426    78.457     0.200
     5.475    80.016     0.200
     5.489    80.246     0.200
     5.509    79.967     0.200
     5.545    80.787     0.200
     5.555    80.746     0.200
     5.688    82.246     0.200
     5.763    83.617     0.200
     5.689    84.707     0.200
     5.855    85.197     0.200
     5.914    84.926     0.200
     6.078    87.557     0.200
     6.112    87.527     0.200
     6.242    90.807     0.200
     6.259    92.047     0.200
     6.444    92.816     0.200
     6.634    94.506     0.200
     6.665    94.117     0.200
     6.673    95.186     0.200
     6.684    95.246     0.200
     6.758    97.426     0.200
     6.868    98.016     0.200
     6.928   100.447     0.200
     7.042   100.406     0.200
     7.109   101.156     0.200
     7.109   101.156     0.200
     7.114   100.646     0.200
     7.114   101.246     0.200
     7.124   101.816     0.200
     7.247   103.496     0.200
     7.621   109.516     0.200
     8.017   114.357     0.200
     8.067   114.246     0.200
     8.147   115.826     0.200
     8.396   119.346     0.200
     8.700   122.877     0.200
     8.841   126.146     0.200
     9.037   128.447     0.200
     9.377   134.186     0.200
     9.925   138.816     0.200
    11.267   159.617     0.200
    13.031   183.146     0.200
    15.711   218.646     0.200
    15.711   218.846     0.200
    15.712   218.086     0.200
    20.628   279.807     0.200
     0.252    11.906     0.200
     0.641    14.867     0.200
     0.632    15.016     0.200
     0.664    15.496     0.200
     0.689    16.055     0.200
     0.692    15.977     0.200
     0.692    16.137     0.200
     0.692    15.695     0.200
     0.696    16.016     0.200
     0.710    16.105     0.200
     0.996    19.547     0.200
     1.106    19.645     0.200
     1.151    20.918     0.200
     1.247    22.516     0.200
     1.410    24.855     0.200
     1.406    24.508     0.200
     1.414    24.574     0.200
     1.490    25.406     0.200
     1.773    28.668     0.200
     1.809    30.477     0.200
     1.890    31.008     0.200
     1.996    31.977     0.200
     2.393    39.016     0.200
     2.516    38.258     0.200
     2.563    38.375     0.200
     2.626    40.758     0.200
     2.629    40.645     0.200
     2.652    41.336     0.200
     2.639    40.406     0.200
     2.664    41.457     0.200
     2.683    41.527     0.200
     2.697    41.406     0.200
     2.757    42.586     0.200
     2.822    42.227     0.200
     3.164    47.227     0.200
     3.190    47.465     0.200
     3.207    47.707     0.200
     3.247    48.145     0.200
     3.281    48.895     0.200
     3.322    49.547     0.200
     3.448    50.734     0.200
     3.469    51.875     0.200
     3.515    52.496     0.200
     3.681    53.918     0.200
     3.681    53.438     0.200
     3.829    56.395     0.200
     3.865    56.367     0.200
     3.883    56.707     0.200
     3.964    57.055     0.200
     4.085    59.938     0.200
     4.094    59.156     0.200
     4.412    63.574     0.200
     4.448    64.734     0.200
     4.424    64.598     0.200
     4.644    67.285     0.200
     5.039    72.695     0.200
     5.052    73.258     0.200
     5.061    73.656     0.200
     5.036    73.496     0.200
     5.280    76.098     0.200
     5.275    75.848     0.200
     5.359    76.926     0.200
     5.537    79.227     0.200
     5.549    79.668     0.200
     5.635    80.137     0.200
     5.693    81.477     0.200
     5.838    83.516     0.200
     5.861    83.477     0.200
     5.858    84.055     0.200
     6.147    87.395     0.200
     6.269    89.816     0.200
     6.299    88.887     0.200
     6.379    90.547     0.200
     6.534    93.688     0.200
     6.517    93.074     0.200
     6.568    93.188     0.200
     6.600    93.246     0.200
     6.592    93.266     0.200
     6.794    95.457     0.200
     6.821    96.438     0.200
     6.821    96.367     0.200
     6.893    98.496     0.200
     6.966    98.617     0.200
     6.978    98.426     0.200
     7.371   103.875     0.200
     7.417   105.926     0.200
     7.834   109.707     0.200
     8.129   116.336     0.200
     8.691   123.098     0.200
     8.796   122.445     0.200
     9.675   136.195     0.200
     9.874   136.074     0.200
    13.097   181.695     0.200
     0.708    14.125     0.200
     1.487    24.666     0.200
     1.721    28.115     0.200
     2.037    32.115     0.200
     2.122    33.795     0.200
     2.145    34.365     0.200
     2.147    34.176     0.200
     2.149    34.225     0.200
     2.151    34.365     0.200
     2.157    34.346     0.200
     2.169    34.525     0.200
     2.402    37.605     0.200
     2.391    36.635     0.200
     2.441    38.025     0.200
     2.570    39.744     0.200
     2.607    40.494     0.200
     2.802    42.744     0.200
     2.864    43.305     0.200
     2.851    43.105     0.200
     2.854    43.525     0.200
     2.877    43.645     0.200
     3.030    46.154     0.200
     3.223    48.195     0.200
     3.541    51.596     0.200
     3.679    53.734     0.200
     3.701    56.055     0.200
     3.882    56.105     0.200
     4.036    58.086     0.200
     4.031    58.865     0.200
     4.037    59.574     0.200
     4.062    60.455     0.200
     4.087    60.324     0.200
     4.070    59.445     0.200
     4.107    60.395     0.200
     4.287    62.035     0.200
     4.314    61.955     0.200
     4.382    63.725     0.200
     4.479    64.756     0.200
     4.399    61.916     0.200
     4.484    64.955     0.200
     4.865    70.395     0.200
     4.892    69.715     0.200
     4.889    69.855     0.200
     4.889    69.734     0.200
     4.905    70.605     0.200
     5.095    72.936     0.200
     5.266    74.904     0.200
     5.333    76.455     0.200
     5.360    77.055     0.200
     5.430    78.154     0.200
     5.520    78.855     0.200
     5.552    79.766     0.200
     5.880    84.355     0.200
     6.103    87.756     0.200
     6.362    91.064     0.200
     6.435    92.086     0.200
     6.463    91.836     0.200
     6.494    92.564     0.200
     6.468    93.324     0.200
     6.590    93.836     0.200
     6.617    94.475     0.200
     6.809    96.725     0.200
     6.837    97.166     0.200
     6.985    99.295     0.200
     7.242   102.785     0.200
     7.417   105.275     0.200
     7.537   108.555     0.200
     7.670   107.865     0.200
     7.860   111.186     0.200
     7.924   111.195     0.200
     8.162   113.355     0.200
     8.200   114.475     0.200
     8.221   116.936     0.200
     8.797   123.695     0.200
     8.882   125.494     0.200
     9.392   133.055     0.200
     9.686   136.355     0.200
     9.806   136.516     0.200
    10.144   141.154     0.200
    14.261   196.256     0.200
    14.511   199.516     0.200
     0.708    14.312     0.200
     0.830    16.672     0.200
     0.828    17.125     0.200
     1.144    20.875     0.200
     1.239    22.328     0.200
     1.264    22.914     0.200
     1.266    22.922     0.200
     1.267    23.633     0.200
     1.267    22.586     0.200
     1.267    22.898     0.200
     1.273    22.883     0.200
     1.286    23.008     0.200
     1.568    26.734     0.200
     1.536    26.094     0.200
     1.682    28.062     0.200
     1.713    28.203     0.200
     1.871    30.633     0.200
     1.896    30.633     0.200
     1.932    31.336     0.200
     1.979    31.867     0.200
     1.985    31.852     0.200
     2.013    31.984     0.200
     2.192    34.312     0.200
     2.364    37.016     0.200
     2.440    38.086     0.200
     2.458    38.586     0.200
     2.492    38.984     0.200
     2.917    45.992     0.200
     2.948    43.625     0.200
     2.980    44.664     0.200
     3.056    46.461     0.200
     3.172    48.125     0.200
     3.190    48.125     0.200
     3.178    47.773     0.200
     3.216    48.742     0.200
     3.245    48.031     0.200
     3.232    49.031     0.200
     3.248    49.008     0.200
     3.261    48.711     0.200
     3.318    49.953     0.200
     3.394    51.078     0.200
     3.561    52.023     0.200
     3.633    53.203     0.200
     3.674    54.664     0.200
     3.768    55.602     0.200
     3.866    56.375     0.200
     4.026    59.203     0.200
     4.030    59.508     0.200
     4.030    59.031     0.200
     4.172    60.352     0.200
     4.172    60.008     0.200
     4.228    61.125     0.200
     4.290    61.875     0.200
     4.325    62.875     0.200
     4.344    62.234     0.200
     4.376    63.633     0.200
     4.572    65.844     0.200
     4.629    67.594     0.200
     4.663    67.117     0.200
     4.724    67.992     0.200
     4.684    68.414     0.200
     4.793    69.102     0.200
     4.902    70.945     0.200
     4.944    70.938     0.200
     4.982    72.578     0.200
     5.138    73.734     0.200
     5.169    74.516     0.200
     5.311    76.172     0.200
     5.480    79.703     0.200
     5.701    82.758     0.200
     5.864    84.023     0.200
     5.981    85.672     0.200
     5.985    85.406     0.200
     6.008    85.586     0.200
     6.122    87.461     0.200
     6.446    91.875     0.200
     6.509    93.055     0.200
     6.840    99.156     0.200
     6.882    98.227     0.200
     7.367   103.227     0.200
     7.427   104.375     0.200
     7.427   104.516     0.200
     7.427   104.602     0.200
     7.544   105.664     0.200
     7.662   109.188     0.200
     7.909   112.062     0.200
     9.899   139.305     0.200
    10.208   142.008     0.200
     0.539    10.531     0.200
     0.457    10.863     0.200
     0.794    15.363     0.200
     1.132    20.062     0.200
     1.149    20.863     0.200
     1.157    20.664     0.200
     1.158    20.172     0.200
     1.162    20.762     0.200
     1.172    20.863     0.200
     1.179    20.961     0.200
     1.209    20.762     0.200
     1.363    23.262     0.200
     1.430    23.664     0.200
     1.428    24.461     0.200
     1.552    25.762     0.200
     1.564    26.262     0.200
     1.578    25.863     0.200
     1.675    26.863     0.200
     1.691    27.363     0.200
     1.777    28.191     0.200
     1.783    28.664     0.200
     1.850    29.461     0.200
     1.828    29.562     0.200
     1.830    29.164     0.200
     1.846    29.262     0.200
     1.988    32.262     0.200
     2.187    34.262     0.200
     2.259    35.461     0.200
     2.329    36.363     0.200
     2.355    36.664     0.200
     2.362    36.762     0.200
     2.537    39.062     0.200
     2.578    38.363     0.200
     2.650    41.961     0.200
     2.858    43.664     0.200
     2.893    42.762     0.200
     2.980    45.262     0.200
     2.982    45.262     0.200
     2.991    45.461     0.200
     3.044    46.164     0.200
     3.052    46.102     0.200
     3.060    46.461     0.200
     3.111    46.363     0.200
     3.165    46.461     0.200
     3.196    48.262     0.200
     3.192    47.191     0.200
     3.289    48.262     0.200
     3.349    49.262     0.200
     3.412    50.562     0.200
     3.455    51.164     0.200
     3.507    51.461     0.200
     3.612    51.664     0.200
     3.744    55.262     0.200
     3.815    56.062     0.200
     3.861    56.062     0.200
     3.861    55.543     0.200
     3.893    56.562     0.200
     3.927    57.461     0.200
     3.933    56.863     0.200
     3.966    56.863     0.200
     4.066    59.062     0.200
     4.128    59.062     0.200
     4.249    60.824     0.200
     4.284    61.762     0.200
     4.325    62.562     0.200
     4.378    63.762     0.200
     4.414    63.762     0.200
     4.559    66.062     0.200
     4.691    68.863     0.200
     4.731    68.363     0.200
     4.796    69.262     0.200
     4.902    70.762     0.200
     4.949    71.293     0.200
     5.018    72.863     0.200
     5.088    72.824     0.200
     5.128    74.363     0.200
     5.164    72.961     0.200
     5.338    77.164     0.200
     5.382    77.562     0.200
     5.418    78.164     0.200
     5.598    80.062     0.200
     5.560    79.961     0.200
     5.594    79.961     0.200
     5.622    80.461     0.200
     5.667    82.164     0.200
     5.637    82.664     0.200
     5.715    81.461     0.200
     5.830    83.961     0.200
     5.877    84.461     0.200
     5.838    83.762     0.200
     5.990    85.562     0.200
     6.011    86.062     0.200
     6.041    86.164     0.200
     6.097    87.762     0.200
     6.123    87.762     0.200
     6.178    87.762     0.200
     6.331    90.961     0.200
     6.474    92.762     0.200
     6.529    94.062     0.200
     6.618    93.164     0.200
     6.665    94.461     0.200
     6.761    96.461     0.200
     6.817    96.164     0.200
     6.892    98.164     0.200
     7.045    99.461     0.200
     7.130   100.961     0.200
     7.099   100.062     0.200
     7.154    99.863     0.200
     7.154   100.363     0.200
     7.259   102.363     0.200
     7.291   103.664     0.200
     7.783   110.062     0.200
     7.866   111.562     0.200
     8.085   114.062     0.200
     9.950   137.461     0.200
    12.008   167.062     0.200
     0.553    20.282     0.200
     0.613    20.782     0.200
     0.617    20.682     0.200
     0.637    21.082     0.200
     0.734    21.682     0.200
     0.824    22.182     0.200
     1.081    24.782     0.200
     1.081    24.981     0.200
     1.090    25.182     0.200
     1.093    25.082     0.200
     1.098    24.501     0.200
     1.103    25.182     0.200
     1.118    25.381     0.200
     1.154    25.182     0.200
     1.352    27.782     0.200
     1.471    28.282     0.200
     1.657    30.401     0.200
     1.677    31.182     0.200
     1.684    31.282     0.200
     1.702    31.481     0.200
     1.751    29.771     0.200
     1.751    32.182     0.200
     1.923    33.481     0.200
     2.038    35.481     0.200
     2.072    35.981     0.200
     2.144    36.881     0.200
     2.149    36.981     0.200
     2.180    36.381     0.200
     2.237    37.981     0.200
     2.306    38.881     0.200
     2.374    39.682     0.200
     2.368    39.352     0.200
     2.432    39.582     0.200
     2.449    40.481     0.200
     2.749    44.582     0.200
     2.824    46.881     0.200
     2.837    45.682     0.200
     2.874    46.182     0.200
     2.881    46.582     0.200
     2.900    46.682     0.200
     2.919    46.832     0.200
     2.943    47.381     0.200
     3.017    47.981     0.200
     3.060    48.981     0.200
     3.075    47.251     0.200
     3.230    49.481     0.200
     3.434    52.481     0.200
     3.493    54.682     0.200
     3.511    53.881     0.200
     3.646    55.282     0.200
     3.685    54.282     0.200
     3.765    56.481     0.200
     3.771    56.782     0.200
     3.931    59.182     0.200
     3.967    58.182     0.200
     4.054    59.881     0.200
     4.153    60.202     0.200
     4.206    63.312     0.200
     4.298    62.782     0.200
     4.346    63.582     0.200
     4.391    64.881     0.200
     4.454    64.981     0.200
     4.485    64.751     0.200
     4.584    66.012     0.200
     4.609    66.682     0.200
     4.616    67.582     0.200
     4.659    66.582     0.200
     4.839    69.481     0.200
     4.923    71.282     0.200
     4.981    71.881     0.200
     5.029    73.381     0.200
     5.051    73.182     0.200
     5.115    74.282     0.200
     5.139    75.481     0.200
     5.237    76.182     0.200
     5.275    76.782     0.200
     5.291    77.481     0.200
     5.386    77.481     0.200
     5.429    78.381     0.200
     5.477    81.881     0.200
     5.591    81.082     0.200
     5.587    80.782     0.200
     5.639    82.082     0.200
     5.782    83.682     0.200
     5.770    82.282     0.200
     5.832    83.682     0.200
     5.856    84.282     0.200
     6.066    87.481     0.200
     6.085    87.182     0.200
     6.296    89.981     0.200
     6.354    90.481     0.200
     6.457    93.381     0.200
     6.491    93.182     0.200
     6.522    91.682     0.200
     6.636    94.182     0.200
     6.655    93.782     0.200
     6.754    97.082     0.200
     6.855    97.782     0.200
     6.897    96.981     0.200
     7.036    98.582     0.200
     7.201   100.182     0.200
     7.201   100.981     0.200
     7.253   101.782     0.200
     7.303   105.082     0.200
     7.284   104.381     0.200
     7.320   104.582     0.200
     7.372   105.171     0.200
     7.735   110.381     0.200
     7.827   110.981     0.200
     8.041   114.082     0.200
     8.157   115.582     0.200
     8.147   112.981     0.200
     9.910   135.082     0.200
    10.702   146.202     0.200
    13.509   183.782     0.200
    13.995   191.251     0.200
     1.534    27.633     0.200
     1.555    27.977     0.200
     1.562    28.234     0.200
     1.576    28.234     0.200
     1.787    30.734     0.200
     1.736    30.633     0.200
     1.763    31.133     0.200
     2.016    34.438     0.200
     2.065    35.031     0.200
     2.068    34.117     0.200
     2.114    35.734     0.200
     2.117    35.734     0.200
     2.125    35.836     0.200
     2.129    35.938     0.200
     2.225    37.234     0.200
     2.398    38.133     0.200
     2.516    41.234     0.200
     2.548    41.133     0.200
     2.599    41.438     0.200
     2.581    42.234     0.200
     2.586    41.938     0.200
     2.717    44.836     0.200
     2.754    43.234     0.200
     2.731    43.531     0.200
     2.864    44.133     0.200
     3.037    47.836     0.200
     3.165    49.133     0.200
     3.165    49.438     0.200
     3.166    49.734     0.200
     3.188    50.031     0.200
     3.236    51.031     0.200
     3.230    50.734     0.200
     3.235    50.836     0.200
     3.334    51.438     0.200
     3.367    52.633     0.200
     3.404    52.633     0.200
     3.467    53.734     0.200
     3.622    55.594     0.200
     3.726    55.938     0.200
     3.758    56.836     0.200
     3.743    58.234     0.200
     3.780    57.234     0.200
     3.804    57.734     0.200
     3.804    57.297     0.200
     3.848    57.438     0.200
     3.945    60.336     0.200
     3.998    60.336     0.200
     4.165    62.734     0.200
     4.159    62.227     0.200
     4.272    64.531     0.200
     4.359    65.438     0.200
     4.418    66.836     0.200
     4.437    67.438     0.200
     4.516    68.031     0.200
     4.564    68.234     0.200
     4.955    74.836     0.200
     5.132    77.133     0.200
     5.197    77.133     0.200
     5.291    77.938     0.200
     5.313    77.906     0.200
     5.470    82.133     0.200
     5.471    81.836     0.200
     5.499    81.633     0.200
     5.539    82.438     0.200
     5.493    81.547     0.200
     5.535    81.031     0.200
     5.676    84.133     0.200
     5.677    83.234     0.200
     5.848    86.734     0.200
     5.884    87.133     0.200
     5.873    86.234     0.200
     6.090    89.633     0.200
     6.310    92.734     0.200
     6.583    96.133     0.200
     6.651    96.938     0.200
     7.052   103.133     0.200
     7.146   102.938     0.200
     7.146   103.438     0.200
     8.012   115.133     0.200
     8.093   117.492     0.200
     9.959   141.938     0.200
    13.122   185.633     0.200
     0.243    11.340     0.200
     0.602    14.539     0.200
     0.646    14.637     0.200
     0.670    15.438     0.200
     0.672    15.539     0.200
     0.672    15.250     0.200
     0.673    15.438     0.200
     0.678    15.539     0.200
     0.692    15.539     0.200
     0.974    19.039     0.200
     1.061    19.539     0.200
     1.097    19.637     0.200
     1.148    20.539     0.200
     1.206    21.738     0.200
     1.309    22.738     0.200
     1.339    22.848     0.200
     1.353    23.340     0.200
     1.371    24.238     0.200
     1.392    24.039     0.200
     1.421    24.137     0.200
     1.448    24.738     0.200
     1.732    28.137     0.200
     1.771    29.840     0.200
     1.849    30.137     0.200
     1.898    30.938     0.200
     1.951    31.539     0.200
     1.970    31.438     0.200
     2.145    33.938     0.200
     2.361    38.539     0.200
     2.468    38.840     0.200
     2.521    37.840     0.200
     2.581    40.039     0.200
     2.601    40.340     0.200
     2.604    40.238     0.200
     2.627    40.938     0.200
     2.640    41.137     0.200
     2.641    40.438     0.200
     2.731    42.137     0.200
     2.781    41.938     0.200
     2.804    43.340     0.200
     3.110    47.340     0.200
     3.128    46.238     0.200
     3.151    46.840     0.200
     3.204    47.137     0.200
     3.244    48.840     0.200
     3.408    50.137     0.200
     3.444    52.137     0.200
     3.482    52.137     0.200
     3.645    53.238     0.200
     3.645    53.117     0.200
     3.729    54.539     0.200
     3.786    55.137     0.200
     3.922    56.137     0.200
     4.057    59.148     0.200
     4.056    59.438     0.200
     4.123    58.738     0.200
     4.241    61.137     0.200
     4.366    62.938     0.200
     4.371    63.039     0.200
     4.410    64.137     0.200
     4.701    69.039     0.200
     4.731    68.340     0.200
     4.816    69.438     0.200
     5.000    72.539     0.200
     5.026    73.039     0.200
     5.037    73.340     0.200
     5.199    75.438     0.200
     5.240    76.039     0.200
     5.325    76.840     0.200
     5.499    79.438     0.200
     5.520    79.637     0.200
     5.592    79.738     0.200
     5.824    83.340     0.200
     5.831    83.840     0.200
     6.056    87.039     0.200
     6.104    86.637     0.200
     6.272    89.039     0.200
     6.306    91.137     0.200
     6.350    89.738     0.200
     6.491    92.137     0.200
     6.495    92.539     0.200
     6.557    93.539     0.200
     6.537    92.637     0.200
     6.753    96.637     0.200
     6.758    95.840     0.200
     6.767    95.738     0.200
     6.862    96.938     0.200
     6.923    98.438     0.200
     6.908    99.039     0.200
     6.948    97.840     0.200
     7.211   102.137     0.200
     7.328   103.539     0.200
     7.318   104.840     0.200
     7.402   105.938     0.200
     7.803   109.738     0.200
     1.521    25.838     0.200
     2.066    33.988     0.200
     2.312    38.438     0.200
     2.413    40.037     0.200
     2.576    41.938     0.200
     2.584    42.037     0.200
     2.582    42.137     0.200
     2.669    43.238     0.200
     2.688    44.238     0.200
     2.689    43.938     0.200
     2.725    44.037     0.200
     2.870    44.838     0.200
     2.879    46.137     0.200
     3.189    50.537     0.200
     3.283    52.137     0.200
     3.332    52.938     0.200
     3.336    52.738     0.200
     3.343    53.338     0.200
     3.398    52.957     0.200
     3.508    55.637     0.200
     3.727    57.838     0.200
     3.867    61.537     0.200
     4.082    62.938     0.200
     4.131    63.938     0.200
     4.178    64.238     0.200
     4.275    66.537     0.200
     4.354    65.938     0.200
     4.524    68.738     0.200
     4.524    68.268     0.200
     4.641    70.838     0.200
     4.685    71.838     0.200
     4.690    71.938     0.200
     4.722    71.838     0.200
     4.821    73.438     0.200
     4.883    71.838     0.200
     4.948    74.238     0.200
     4.937    74.938     0.200
     5.091    76.037     0.200
     5.114    77.438     0.200
     5.326    80.037     0.200
     5.330    80.238     0.200
     5.340    79.738     0.200
     5.707    86.238     0.200
     5.683    84.137     0.200
     5.734    86.637     0.200
     5.790    86.537     0.200
     5.924    88.537     0.200
     6.171    91.938     0.200
     6.177    92.738     0.200
     6.277    94.537     0.200
     6.559    96.537     0.200
     6.721    99.037     0.200
     7.103   104.338     0.200
     7.119   104.537     0.200
     7.077   104.037     0.200
     7.156   106.838     0.200
     7.330   107.637     0.200
     7.494   110.037     0.200
     7.502   110.777     0.200
     7.455   109.537     0.200
     7.531   110.137     0.200
     7.641   108.938     0.200
     7.641   111.338     0.200
     7.786   112.738     0.200
     7.873   113.607     0.200
     7.987   116.107     0.200
     7.887   114.338     0.200
     8.150   118.037     0.200
     8.182   118.938     0.200
     8.282   120.338     0.200
     8.586   124.738     0.200
     9.517   136.838     0.200
    10.369   148.338     0.200
    13.119   188.178     0.200
    13.917   195.238     0.200
     0.434    11.485     0.200
     0.743    15.385     0.200
     0.752    15.485     0.200
     0.753    14.965     0.200
     0.757    15.385     0.200
     0.768    15.485     0.200
     0.774    15.585     0.200
     0.939    16.955     0.200
     1.021    18.785     0.200
     1.057    19.385     0.200
     1.244    22.185     0.200
     1.280    22.185     0.200
     1.298    21.785     0.200
     1.373    22.585     0.200
     1.380    23.085     0.200
     1.368    22.485     0.200
     1.425    23.685     0.200
     1.444    23.885     0.200
     1.574    25.885     0.200
     1.551    25.785     0.200
     1.661    28.085     0.200
     1.832    29.685     0.200
     1.862    29.985     0.200
     1.884    30.285     0.200
     1.928    30.885     0.200
     1.964    31.285     0.200
     1.965    31.385     0.200
     2.146    33.885     0.200
     2.295    37.485     0.200
     2.345    35.385     0.200
     2.353    35.985     0.200
     2.467    38.585     0.200
     2.587    40.185     0.200
     2.596    40.185     0.200
     2.601    40.385     0.200
     2.626    40.985     0.200
     2.628    39.485     0.200
     2.650    41.185     0.200
     2.661    39.805     0.200
     2.671    41.785     0.200
     2.806    43.185     0.200
     2.801    41.725     0.200
     2.911    44.985     0.200
     2.997    43.685     0.200
     3.011    44.685     0.200
     3.028    45.585     0.200
     3.054    46.385     0.200
     3.139    46.985     0.200
     3.252    47.985     0.200
     3.404    50.885     0.200
     3.432    51.285     0.200
     3.544    51.985     0.200
     3.544    51.415     0.200
     3.543    52.485     0.200
     3.603    52.785     0.200
     3.748    54.885     0.200
     3.746    53.885     0.200
     3.760    54.885     0.200
     3.933    56.185     0.200
     3.945    57.115     0.200
     4.065    58.585     0.200
     4.161    60.085     0.200
     4.195    60.585     0.200
     4.279    62.385     0.200
     4.546    65.655     0.200
     4.565    65.985     0.200
     4.598    66.485     0.200
     4.599    67.385     0.200
     4.656    67.985     0.200
     4.779    68.885     0.200
     4.860    70.485     0.200
     5.006    72.285     0.200
     5.034    73.285     0.200
     5.088    74.085     0.200
     5.236    75.385     0.200
     5.257    75.785     0.200
     5.404    77.185     0.200
     5.362    76.385     0.200
     5.477    78.885     0.200
     5.483    78.485     0.200
     5.702    81.485     0.200
     5.734    83.585     0.200
     5.807    83.185     0.200
     5.751    84.785     0.200
     5.894    83.985     0.200
     5.849    86.385     0.200
     5.860    85.785     0.200
     5.951    85.585     0.200
     6.149    90.485     0.200
     6.212    89.985     0.200
     6.246    88.585     0.200
     6.254    89.785     0.200
     6.306    88.985     0.200
     6.342    90.485     0.200
     6.473    91.485     0.200
     6.503    92.685     0.200
     6.686    95.285     0.200
     6.717    95.005     0.200
     6.733    95.285     0.200
     6.805    95.585     0.200
     6.805    95.885     0.200
     6.982    98.985     0.200
     7.053   100.185     0.200
     7.083   100.285     0.200
     7.378   105.085     0.200
     7.462   106.225     0.200
     7.741   109.285     0.200
     8.352   119.095     0.200
     8.384   120.485     0.200
     9.110   128.585     0.200
     9.133   129.785     0.200
     9.566   132.375     0.200
     9.592   133.085     0.200
    12.003   168.685     0.200
    12.958   180.285     0.200
    15.035   209.185     0.200
     0.587    12.273     0.200
     0.644    12.812     0.200
     0.892    16.473     0.200
     0.935    17.172     0.200
     0.939    17.273     0.200
     0.989    17.973     0.200
     1.018    18.473     0.200
     1.035    18.570     0.200
     1.234    21.371     0.200
     1.298    22.273     0.200
     1.401    23.973     0.200
     1.425    24.570     0.200
     1.427    24.672     0.200
     1.428    24.262     0.200
     1.429    24.570     0.200
     1.434    24.570     0.200
     1.447    24.672     0.200
     1.674    27.070     0.200
     1.728    28.473     0.200
     1.817    29.273     0.200
     1.872    30.172     0.200
     2.010    32.172     0.200
     2.022    32.070     0.200
     2.092    32.523     0.200
     2.105    33.672     0.200
     2.139    33.773     0.200
     2.145    33.871     0.200
     2.172    34.070     0.200
     2.320    35.773     0.200
     2.430    38.273     0.200
     2.523    39.371     0.200
     2.568    39.973     0.200
     2.599    40.273     0.200
     2.618    40.871     0.200
     2.652    40.973     0.200
     2.702    41.672     0.200
     2.714    41.672     0.200
     2.892    44.070     0.200
     3.064    44.871     0.200
     3.115    46.070     0.200
     3.330    50.070     0.200
     3.332    49.570     0.200
     3.347    50.172     0.200
     3.348    50.273     0.200
     3.370    49.672     0.200
     3.374    51.172     0.200
     3.391    51.070     0.200
     3.406    50.992     0.200
     3.419    51.570     0.200
     3.476    52.273     0.200
     3.552    53.172     0.200
     3.658    53.070     0.200
     3.682    54.871     0.200
     3.824    56.473     0.200
     3.907    57.273     0.200
     3.988    57.871     0.200
     4.176    61.172     0.200
     4.187    61.773     0.200
     4.311    61.434     0.200
     4.360    62.773     0.200
     4.420    64.773     0.200
     4.413    63.273     0.200
     4.456    63.672     0.200
     4.516    65.273     0.200
     4.596    66.023     0.200
     4.621    65.773     0.200
     4.671    66.570     0.200
     4.709    67.422     0.200
     4.755    67.773     0.200
     4.774    68.070     0.200
     4.819    69.273     0.200
     4.904    70.672     0.200
     5.033    73.070     0.200
     5.031    72.273     0.200
     5.132    74.973     0.200
     5.181    75.371     0.200
     5.175    74.773     0.200
     5.201    76.973     0.200
     5.139    74.812     0.200
     5.228    76.070     0.200
     5.249    76.871     0.200
     5.267    75.570     0.200
     5.284    75.773     0.200
     5.343    78.273     0.200
     5.391    77.473     0.200
     5.425    78.371     0.200
     5.526    81.371     0.200
     5.563    79.871     0.200
     5.636    80.672     0.200
     5.605    80.773     0.200
     5.766    83.172     0.200
     5.784    83.473     0.200
     5.822    83.973     0.200
     6.006    86.473     0.200
     6.006    85.570     0.200
     6.066    86.070     0.200
     6.085    87.070     0.200
     6.087    86.672     0.200
     6.113    89.273     0.200
     6.148    88.570     0.200
     6.205    88.973     0.200
     6.246    89.672     0.200
     6.356    91.473     0.200
     6.459    92.172     0.200
     6.533    93.070     0.200
     6.581    94.273     0.200
     6.809    97.672     0.200
     6.964    99.273     0.200
     7.009    99.570     0.200
     7.075    99.672     0.200
     7.237   102.773     0.200
     7.286   102.172     0.200
     7.390   105.371     0.200
     7.518   106.371     0.200
     7.485   105.094     0.200
     7.499   105.871     0.200
     7.597   107.172     0.200
     7.576   105.973     0.200
     8.156   117.172     0.200
     8.513   118.570     0.200
     8.710   122.891     0.200
     0.168     6.767     0.200
     0.219     6.747     0.200
     0.875    15.967     0.200
     1.219    20.967     0.200
     1.312    21.566     0.200
     1.364    22.866     0.200
     1.455    23.667     0.200
     1.446    23.866     0.200
     1.585    26.467     0.200
     1.600    26.366     0.200
     1.604    27.167     0.200
     1.662    26.667     0.200
     1.610    27.066     0.200
     1.611    26.417     0.200
     1.615    26.366     0.200
     1.632    27.566     0.200
     1.789    29.267     0.200
     1.887    30.467     0.200
     1.955    31.167     0.200
     1.995    32.066     0.200
     2.027    31.467     0.200
     2.125    33.167     0.200
     2.249    34.767     0.200
     2.239    34.217     0.200
     2.245    35.267     0.200
     2.290    35.967     0.200
     2.291    35.366     0.200
     2.308    35.866     0.200
     2.417    37.767     0.200
     2.649    40.066     0.200
     2.692    41.366     0.200
     2.744    41.767     0.200
     2.791    42.467     0.200
     2.815    42.566     0.200
     2.824    43.167     0.200
     2.937    43.267     0.200
     2.998    45.167     0.200
     3.093    47.667     0.200
     3.272    48.366     0.200
     3.461    50.267     0.200
     3.440    51.366     0.200
     3.440    51.366     0.200
     3.451    51.767     0.200
     3.505    52.667     0.200
     3.512    52.066     0.200
     3.519    53.066     0.200
     3.569    53.366     0.200
     3.618    51.977     0.200
     3.656    54.066     0.200
     3.855    56.667     0.200
     3.873    56.366     0.200
     3.869    56.566     0.200
     4.173    61.267     0.200
     4.215    60.866     0.200
     4.274    61.467     0.200
     4.274    61.137     0.200
     4.301    61.467     0.200
     4.286    61.767     0.200
     4.300    61.866     0.200
     4.440    63.267     0.200
     4.480    64.667     0.200
     4.607    66.366     0.200
     4.598    65.967     0.200
     4.616    66.267     0.200
     4.652    66.906     0.200
     4.745    68.667     0.200
     4.862    69.797     0.200
     4.907    70.467     0.200
     4.809    69.467     0.200
     4.823    71.366     0.200
     4.901    70.767     0.200
     4.943    71.467     0.200
     4.981    71.566     0.200
     5.141    74.267     0.200
     5.137    73.866     0.200
     5.394    76.616     0.200
     5.550    80.366     0.200
     5.560    79.667     0.200
     5.498    79.866     0.200
     5.627    80.167     0.200
     5.731    83.066     0.200
     5.825    83.667     0.200
     5.834    83.566     0.200
     5.894    84.366     0.200
     5.874    84.767     0.200
     5.961    85.167     0.200
     5.975    86.366     0.200
     6.068    87.066     0.200
     6.306    90.267     0.200
     6.298    89.566     0.200
     6.280    89.267     0.200
     6.375    91.066     0.200
     6.515    93.366     0.200
     6.715    96.267     0.200
     6.941    98.866     0.200
     6.938    99.667     0.200
     7.213   102.267     0.200
     7.519   104.646     0.200
     7.543   106.066     0.200
     7.586   105.967     0.200
     0.365     8.953     0.200
     0.425     9.680     0.200
     1.082    19.078     0.200
     1.901    30.680     0.200
     1.881    29.578     0.200
     1.949    31.383     0.200
     1.938    30.977     0.200
     2.001    31.578     0.200
     1.973    31.977     0.200
     1.973    31.617     0.200
     1.979    32.281     0.200
     1.994    32.281     0.200
     2.019    31.977     0.200
     2.022    31.578     0.200
     2.070    32.680     0.200
     2.272    34.977     0.200
     2.235    34.883     0.200
     2.508    38.680     0.200
     2.529    38.977     0.200
     2.529    38.336     0.200
     2.531    38.883     0.200
     2.532    38.680     0.200
     2.577    39.477     0.200
     2.584    39.578     0.200
     2.586    39.680     0.200
     2.852    41.977     0.200
     2.965    44.781     0.200
     2.994    45.180     0.200
     3.032    45.180     0.200
     3.055    45.977     0.200
     3.066    45.883     0.200
     3.218    46.977     0.200
     3.210    48.883     0.200
     3.260    47.578     0.200
     3.216    47.477     0.200
     3.471    50.180     0.200
     3.629    52.977     0.200
     3.653    53.680     0.200
     3.723    55.180     0.200
     3.718    55.102     0.200
     3.719    54.883     0.200
     3.721    54.977     0.200
     3.783    55.180     0.200
     3.758    55.180     0.200
     3.884    56.680     0.200
     3.988    58.180     0.200
     4.033    58.688     0.200
     4.146    59.578     0.200
     4.204    60.578     0.200
     4.246    60.781     0.200
     4.229    60.977     0.200
     4.244    61.281     0.200
     4.282    61.680     0.200
     4.282    60.992     0.200
     4.367    63.180     0.200
     4.436    64.078     0.200
     4.452    64.383     0.200
     4.486    64.781     0.200
     4.546    66.078     0.200
     4.567    66.477     0.200
     4.578    66.383     0.200
     4.628    66.547     0.200
     4.694    68.078     0.200
     4.839    70.078     0.200
     4.872    70.578     0.200
     4.928    71.281     0.200
     4.983    71.781     0.200
     5.258    72.969     0.200
     5.266    72.883     0.200
     5.396    78.180     0.200
     5.503    79.078     0.200
     5.662    81.078     0.200
     5.668    81.078     0.200
     5.759    81.648     0.200
     5.855    82.383     0.200
     5.912    85.578     0.200
     5.960    85.680     0.200
     6.010    85.883     0.200
     5.972    85.578     0.200
     5.946    83.281     0.200
     5.982    84.383     0.200
     5.983    83.883     0.200
     6.055    86.578     0.200
     6.142    88.078     0.200
     6.237    86.883     0.200
     6.299    89.781     0.200
     6.405    91.578     0.200
     6.561    93.883     0.200
     6.679    96.578     0.200
     7.176   101.977     0.200
     7.172   101.078     0.200
     7.516   105.977     0.200
     7.628   108.477     0.200
     8.540   120.883     0.200
     8.578   121.383     0.200
     8.991   123.633     0.200
    11.633   163.477     0.200
    13.567   189.281     0.200
     0.403    10.145     0.200
     0.875    16.475     0.200
     1.101    19.575     0.200
     1.128    19.375     0.200
     1.271    21.475     0.200
     1.458    24.175     0.200
     1.489    25.175     0.200
     1.511    25.875     0.200
     1.475    24.274     0.200
     1.514    25.675     0.200
     1.516    25.254     0.200
     1.519    25.575     0.200
     1.526    25.675     0.200
     1.537    25.575     0.200
     1.785    29.075     0.200
     1.804    29.375     0.200
     1.970    31.575     0.200
     1.987    32.075     0.200
     2.004    31.375     0.200
     2.163    33.305     0.200
     2.172    33.975     0.200
     2.213    34.575     0.200
     2.215    34.774     0.200
     2.267    35.274     0.200
     2.237    34.375     0.200
     2.410    37.975     0.200
     2.583    39.774     0.200
     2.656    40.875     0.200
     2.678    41.175     0.200
     2.720    41.575     0.200
     2.760    42.075     0.200
     2.760    42.274     0.200
     2.941    44.375     0.200
     2.983    43.975     0.200
     3.070    47.575     0.200
     3.305    48.575     0.200
     3.383    50.475     0.200
     3.446    51.475     0.200
     3.457    51.435     0.200
     3.539    51.375     0.200
     3.487    51.234     0.200
     3.519    52.274     0.200
     3.704    54.075     0.200
     3.876    56.875     0.200
     3.915    57.075     0.200
     4.166    60.675     0.200
     4.298    62.675     0.200
     4.282    61.675     0.200
     4.282    61.475     0.200
     4.310    62.274     0.200
     4.341    62.475     0.200
     4.361    62.475     0.200
     4.488    64.774     0.200
     4.512    64.274     0.200
     4.659    66.975     0.200
     4.678    67.175     0.200
     4.693    67.475     0.200
     4.669    66.945     0.200
     4.807    69.175     0.200
     4.746    67.435     0.200
     4.797    69.375     0.200
     4.901    70.875     0.200
     4.974    71.675     0.200
     5.081    73.274     0.200
     5.194    74.875     0.200
     5.277    75.575     0.200
     5.437    78.375     0.200
     5.432    78.075     0.200
     5.538    79.975     0.200
     5.742    82.975     0.200
     5.690    81.575     0.200
     5.795    82.175     0.200
     5.925    84.975     0.200
     5.972    84.975     0.200
     5.969    84.875     0.200
     5.981    85.375     0.200
     6.063    86.375     0.200
     6.049    86.975     0.200
     6.258    89.274     0.200
     6.396    90.875     0.200
     6.422    91.875     0.200
     6.405    91.075     0.200
     6.639    94.875     0.200
     6.676    95.875     0.200
     6.819    97.375     0.200
     6.950   100.175     0.200
     7.066   100.575     0.200
     7.035    98.675     0.200
     7.240   102.375     0.200
     7.343   103.975     0.200
     7.299   102.675     0.200
     7.336   104.975     0.200
     7.414   104.675     0.200
     7.438   105.975     0.200
     7.498   105.245     0.200
     7.517   105.675     0.200
     7.576   105.575     0.200
     8.248   118.274     0.200
     8.508   119.375     0.200
     9.494   133.675     0.200
     9.676   133.774     0.200
    12.252   172.975     0.200
     0.430    13.471     0.200
     0.438    13.871     0.200
     0.572    14.971     0.200
     0.738    16.570     0.200
     0.912    18.570     0.200
     1.051    20.371     0.200
     1.088    20.170     0.200
     1.146    19.750     0.200
     1.324    24.070     0.200
     1.346    24.570     0.200
     1.347    24.570     0.200
     1.346    24.371     0.200
     1.350    24.010     0.200
     1.358    24.770     0.200
     1.365    24.670     0.200
     1.656    28.471     0.200
     1.660    27.871     0.200
     1.960    31.971     0.200
     2.014    32.340     0.200
     2.034    33.170     0.200
     2.051    33.471     0.200
     2.066    33.770     0.200
     2.103    33.971     0.200
     2.128    34.570     0.200
     2.197    34.871     0.200
     2.453    38.871     0.200
     2.485    38.371     0.200
     2.527    40.170     0.200
     2.531    39.971     0.200
     2.543    40.270     0.200
     2.560    40.471     0.200
     3.030    45.570     0.200
     3.099    48.570     0.200
     3.235    48.471     0.200
     3.268    48.070     0.200
     3.284    49.971     0.200
     3.337    50.311     0.200
     3.537    51.971     0.200
     3.838    57.270     0.200
     3.908    57.170     0.200
     3.926    56.670     0.200
     3.997    59.070     0.200
     4.163    60.371     0.200
     4.223    62.070     0.200
     4.329    61.939     0.200
     4.396    63.770     0.200
     4.396    62.600     0.200
     4.443    64.371     0.200
     4.486    65.070     0.200
     4.582    65.971     0.200
     4.689    67.770     0.200
     4.769    69.371     0.200
     4.808    70.270     0.200
     4.811    69.041     0.200
     4.862    68.871     0.200
     4.862    72.070     0.200
     4.931    72.170     0.200
     4.969    71.270     0.200
     4.989    71.371     0.200
     5.119    73.570     0.200
     5.167    74.371     0.200
     5.219    76.170     0.200
     5.258    76.070     0.200
     5.319    76.371     0.200
     5.340    77.170     0.200
     5.483    78.471     0.200
     5.524    79.270     0.200
     5.702    81.770     0.200
     5.758    82.570     0.200
     5.963    84.570     0.200
     5.996    86.570     0.200
     6.069    86.570     0.200
     6.231    88.971     0.200
     6.256    91.070     0.200
     6.332    89.971     0.200
     6.404    90.971     0.200
     6.506    92.670     0.200
     6.523    92.471     0.200
     6.579    93.770     0.200
     6.807    98.371     0.200
     6.823    96.670     0.200
     6.964    97.570     0.200
     7.060    98.670     0.200
     7.143   100.570     0.200
     7.268   103.570     0.200
     7.263   102.770     0.200
     7.464   104.000     0.200
     7.466   104.371     0.200
     7.592   107.770     0.200
     7.583   105.971     0.200
     7.882   111.570     0.200
     7.973   112.270     0.200
     7.967   114.170     0.200
     7.989   113.471     0.200
     8.042   113.570     0.200
     8.185   113.971     0.200
     8.208   116.170     0.200
    12.864   180.570     0.200
    13.810   190.371     0.200
     0.521    14.762     0.200
     0.732    16.762     0.200
     0.906    18.363     0.200
     0.884    18.262     0.200
     0.938    19.164     0.200
     0.960    19.664     0.200
     0.962    19.465     0.200
     0.962    19.664     0.200
     0.964    19.664     0.200
     0.971    19.664     0.200
     0.980    19.762     0.200
     0.964    19.164     0.200
     1.116    19.574     0.200
     1.271    23.363     0.200
     1.326    23.562     0.200
     1.579    26.965     0.200
     1.633    27.543     0.200
     1.651    27.062     0.200
     1.673    28.262     0.200
     1.685    28.562     0.200
     1.721    28.762     0.200
     1.742    29.664     0.200
     1.822    29.863     0.200
     2.106    33.164     0.200
     2.116    34.262     0.200
     2.137    34.863     0.200
     2.150    34.965     0.200
     2.163    35.062     0.200
     2.184    35.164     0.200
     2.250    36.062     0.200
     2.706    43.465     0.200
     2.760    41.812     0.200
     2.895    42.965     0.200
     2.879    44.465     0.200
     2.904    44.562     0.200
     2.930    44.762     0.200
     2.935    45.363     0.200
     2.975    45.863     0.200
     3.154    47.164     0.200
     3.522    51.863     0.200
     3.605    53.562     0.200
     3.781    55.262     0.200
     3.830    57.762     0.200
     4.004    58.562     0.200
     4.096    59.562     0.200
     4.198    60.664     0.200
     4.205    61.664     0.200
     4.296    61.363     0.200
     4.334    63.164     0.200
     4.382    65.062     0.200
     4.496    63.863     0.200
     4.577    66.883     0.200
     4.744    68.863     0.200
     5.105    73.363     0.200
     5.181    74.863     0.200
     5.334    77.863     0.200
     5.332    77.262     0.200
     5.363    77.164     0.200
     5.676    81.363     0.200
     6.014    86.363     0.200
     6.068    86.664     0.200
     6.161    87.965     0.200
     6.188    88.762     0.200
     6.472    91.863     0.200
     6.583    92.863     0.200
     6.777    95.664     0.200
     6.923    99.062     0.200
     7.079   100.262     0.200
     7.195   101.262     0.200
     7.571   106.965     0.200
     7.672   108.164     0.200
     8.137   114.762     0.200
    13.417   185.965     0.200
     0.763    14.545     0.200
     0.782    14.064     0.200
     1.255    21.445     0.200
     1.312    22.145     0.200
     1.475    24.445     0.200
     1.623    26.945     0.200
     2.034    32.846     0.200
     2.061    32.916     0.200
     2.238    34.545     0.200
     2.497    38.346     0.200
     2.569    39.645     0.200
     2.724    41.326     0.200
     3.935    58.096     0.200
     3.972    58.475     0.200
     4.096    58.545     0.200
     4.271    61.256     0.200
     4.296    60.945     0.200
     4.372    63.045     0.200
     4.416    62.445     0.200
     4.478    64.846     0.200
     4.766    69.045     0.200
     4.848    69.746     0.200
     4.883    69.615     0.200
     4.989    71.846     0.200
     5.047    72.045     0.200
     5.269    75.166     0.200
     5.337    75.645     0.200
     5.381    76.846     0.200
     5.754    82.936     0.200
     6.129    88.246     0.200
     6.923    97.586     0.200
     7.534   106.246     0.200
     8.094   113.756     0.200
     8.175   114.645     0.200
     8.788   125.916     0.200
     9.216   130.686     0.200
     9.975   137.375     0.200
    12.631   177.045     0.200
    14.275   198.445     0.200
    14.354   201.445     0.200
     1.259    22.004     0.200
     1.542    25.801     0.200
     1.571    26.504     0.200
     1.653    27.902     0.200
     1.783    29.801     0.200
     1.694    28.102     0.200
     1.831    30.004     0.200
     1.898    31.504     0.200
     1.904    31.402     0.200
     1.946    31.703     0.200
     1.948    32.004     0.200
     1.974    32.102     0.200
     2.029    32.602     0.200
     2.064    33.301     0.200
     2.120    33.801     0.200
     2.328    36.801     0.200
     2.266    36.004     0.200
     2.394    37.504     0.200
     2.397    37.801     0.200
     2.501    38.203     0.200
     2.486    40.004     0.200
     2.619    39.504     0.200
     2.967    45.402     0.200
     2.992    46.004     0.200
     3.081    46.504     0.200
     3.155    47.703     0.200
     3.369    50.504     0.200
     3.476    51.402     0.200
     3.505    51.902     0.200
     3.527    52.504     0.200
     3.555    52.703     0.200
     3.555    52.152     0.200
     3.602    52.801     0.200
     3.502    52.602     0.200
     3.759    55.801     0.200
     3.771    55.902     0.200
     3.907    58.004     0.200
     3.959    58.703     0.200
     4.058    60.203     0.200
     4.131    60.602     0.200
     4.164    61.902     0.200
     4.199    62.504     0.200
     4.292    63.004     0.200
     4.314    63.602     0.200
     4.702    69.902     0.200
     4.888    71.902     0.200
     4.880    72.402     0.200
     5.050    73.703     0.200
     5.217    77.703     0.200
     5.155    74.602     0.200
     5.248    76.902     0.200
     5.237    77.004     0.200
     5.324    77.902     0.200
     5.448    78.902     0.200
     5.595    82.004     0.200
     5.681    82.801     0.200
     5.630    82.203     0.200
     5.704    83.242     0.200
     5.866    85.102     0.200
     5.755    85.102     0.200
     6.010    87.102     0.200
     6.109    87.402     0.200
     6.276    90.301     0.200
     6.442    93.102     0.200
     6.376    92.801     0.200
     6.551    94.102     0.200
     6.650    95.004     0.200
     6.648    97.203     0.200
     6.797    97.602     0.200
     6.862    98.223     0.200
     6.899    98.602     0.200
     6.900    99.102     0.200
     7.813   112.203     0.200
     7.886   113.504     0.200
    11.324   160.801     0.200
     1.484    25.830     0.200
     1.620    26.830     0.200
     1.915    31.429     0.200
     2.010    32.629     0.200
     2.267    36.030     0.200
     2.307    36.719     0.200
     2.359    37.330     0.200
     2.425    38.429     0.200
     2.427    38.030     0.200
     2.550    41.030     0.200
     2.595    39.330     0.200
     2.729    40.629     0.200
     2.978    45.760     0.200
     3.080    46.530     0.200
     3.147    48.320     0.200
     3.239    48.530     0.200
     3.480    51.729     0.200
     3.494    52.330     0.200
     3.576    54.030     0.200
     3.582    52.229     0.200
     3.619    53.429     0.200
     3.640    53.830     0.200
     3.640    53.729     0.200
     3.711    53.830     0.200
     3.845    57.030     0.200
     3.871    56.830     0.200
     3.997    59.030     0.200
     4.023    59.129     0.200
     4.071    59.629     0.200
     4.221    61.929     0.200
     4.261    62.830     0.200
     4.419    64.629     0.200
     4.802    70.729     0.200
     5.168    75.320     0.200
     5.160    74.429     0.200
     5.336    77.429     0.200
     5.692    82.330     0.200
     5.591    82.290     0.200
     6.392    94.229     0.200
     6.938    99.300     0.200
     6.980    99.229     0.200
     7.931   112.760     0.200
     8.904   124.429     0.200
    11.431   161.836     0.200
    12.967   182.205     0.200
    18.692   256.743     0.200
     0.098    15.072     0.200
     0.095    14.971     0.200
     0.344    15.371     0.200
     0.548    16.672     0.200
     0.567    16.971     0.200
     0.798    19.172     0.200
     1.157    23.871     0.200
     1.174    23.871     0.200
     1.175    23.672     0.200
     1.450    24.281     0.200
     1.470    27.172     0.200
     1.809    31.471     0.200
     1.833    31.672     0.200
     1.858    31.971     0.200
     1.902    32.471     0.200
     2.166    34.971     0.200
     2.439    38.271     0.200
     2.687    42.471     0.200
     3.082    47.771     0.200
     3.081    48.371     0.200
     3.473    51.971     0.200
     3.872    57.371     0.200
     3.938    57.771     0.200
     4.065    59.971     0.200
     4.099    59.771     0.200
     4.264    61.711     0.200
     4.389    63.281     0.200
     4.509    64.771     0.200
     4.527    65.771     0.200
     4.524    67.191     0.200
     4.535    64.371     0.200
     4.570    66.672     0.200
     4.632    66.471     0.200
     4.696    68.572     0.200
     4.688    67.572     0.200
     4.798    70.271     0.200
     4.844    69.072     0.200
     4.928    70.971     0.200
     4.890    71.971     0.200
     4.940    72.371     0.200
     4.976    72.871     0.200
     5.067    72.672     0.200
     5.079    73.072     0.200
     5.098    73.572     0.200
     5.074    73.572     0.200
     5.212    75.371     0.200
     5.237    76.971     0.200
     5.277    76.672     0.200
     5.336    77.072     0.200
     5.367    78.072     0.200
     5.429    77.672     0.200
     5.462    78.871     0.200
     5.485    78.971     0.200
     5.555    80.371     0.200
     5.574    81.072     0.200
     5.666    81.971     0.200
     5.740    82.971     0.200
     5.766    82.371     0.200
     5.912    84.172     0.200
     5.921    85.271     0.200
     6.024    85.971     0.200
     6.311    90.172     0.200
     6.296    89.871     0.200
     6.386    91.271     0.200
     6.399    92.072     0.200
     6.447    92.271     0.200
     6.461    91.871     0.200
     6.532    93.371     0.200
     6.557    94.471     0.200
     6.735    94.971     0.200
     6.837    97.471     0.200
     6.882    97.471     0.200
     7.065    98.871     0.200
     7.073    99.471     0.200
     7.233   103.771     0.200
     7.250   101.771     0.200
     7.294   104.172     0.200
     7.385   105.072     0.200
     7.386   103.021     0.200
     7.665   109.172     0.200
     7.661   109.641     0.200
     7.964   112.771     0.200
     8.331   116.371     0.200
     9.265   129.172     0.200
    12.991   182.121     0.200
     0.906    16.219     0.200
     0.927    16.527     0.200
     1.006    17.898     0.200
     1.039    18.219     0.200
     1.084    18.789     0.200
     0.982    17.777     0.200
     1.013    18.207     0.200
     1.271    21.637     0.200
     1.835    29.387     0.200
     2.028    32.676     0.200
     2.052    33.398     0.200
     2.058    33.195     0.200
     2.074    33.695     0.200
     2.361    37.316     0.200
     2.438    37.637     0.200
     2.678    41.266     0.200
     2.676    41.445     0.200
     2.683    41.098     0.200
     2.727    42.027     0.200
     2.770    42.578     0.200
     2.779    42.906     0.200
     2.810    42.887     0.200
     2.981    44.867     0.200
     3.097    47.297     0.200
     3.163    48.168     0.200
     3.207    48.559     0.200
     3.256    49.406     0.200
     3.284    49.727     0.200
     3.341    50.258     0.200
     3.361    50.238     0.200
     3.831    56.809     0.200
     3.780    55.129     0.200
     3.995    58.789     0.200
     4.018    59.605     0.200
     4.028    58.387     0.200
     4.123    60.848     0.200
     4.276    61.008     0.200
     4.396    63.605     0.200
     4.464    65.086     0.200
     4.573    66.309     0.200
     4.642    66.879     0.200
     4.640    67.348     0.200
     4.737    69.457     0.200
     4.842    69.668     0.200
     4.978    70.938     0.200
     5.183    74.477     0.200
     5.249    74.176     0.200
     5.240    76.867     0.200
     5.394    76.836     0.200
     5.441    78.637     0.200
     5.428    77.355     0.200
     5.640    81.336     0.200
     5.662    81.816     0.200
     5.634    80.617     0.200
     5.693    81.398     0.200
     5.754    82.148     0.200
     5.810    83.488     0.200
     5.928    84.695     0.200
     5.972    84.969     0.200
     6.263    89.469     0.200
     6.473    92.957     0.200
     6.563    94.016     0.200
     6.772    96.797     0.200
     6.906    97.746     0.200
     7.126   100.926     0.200
     7.546   106.977     0.200
     8.040   113.156     0.200
     8.144   113.496     0.200
     8.156   114.078     0.200
     8.240   115.855     0.200
     8.661   122.258     0.200
     8.747   123.637     0.200
     9.177   128.738     0.200
    10.150   141.289     0.200
    11.020   152.398     0.200
    12.897   181.484     0.200
    14.044   196.367     0.200
    14.388   199.168     0.200
    20.484   276.379     0.200
    20.867   281.047     0.200
     0.882    15.746     0.200
     1.011    17.824     0.200
     1.047    18.156     0.200
     1.090    18.777     0.200
     1.086    18.695     0.200
     0.995    18.016     0.200
     1.026    17.516     0.200
     1.166    20.406     0.200
     1.184    20.656     0.200
     1.276    21.555     0.200
     1.259    21.797     0.200
     1.372    23.047     0.200
     2.043    32.855     0.200
     2.067    33.465     0.200
     2.073    33.566     0.200
     2.180    34.676     0.200
     2.220    35.164     0.200
     2.273    35.445     0.200
     2.377    37.527     0.200
     2.452    37.844     0.200
     2.693    41.766     0.200
     2.692    42.027     0.200
     2.742    42.656     0.200
     2.699    41.367     0.200
     2.757    42.426     0.200
     2.785    42.855     0.200
     2.794    43.215     0.200
     2.826    43.266     0.200
     2.997    45.066     0.200
     3.112    47.535     0.200
     3.222    49.086     0.200
     3.271    50.086     0.200
     3.299    49.855     0.200
     3.357    50.637     0.200
     3.377    50.414     0.200
     3.746    57.016     0.200
     3.843    57.047     0.200
     3.796    55.387     0.200
     4.019    58.844     0.200
     3.987    59.188     0.200
     4.008    59.316     0.200
     4.011    59.004     0.200
     4.034    59.938     0.200
     4.061    58.375     0.200
     4.043    58.695     0.200
     4.155    62.516     0.200
     4.210    62.254     0.200
     4.291    61.945     0.200
     4.412    64.406     0.200
     4.479    65.414     0.200
     4.594    67.375     0.200
     4.636    67.387     0.200
     4.640    67.645     0.200
     4.589    66.547     0.200
     4.669    69.105     0.200
     4.687    68.438     0.200
     4.718    69.445     0.200
     4.725    68.938     0.200
     4.657    67.047     0.200
     4.653    66.754     0.200
     4.788    68.996     0.200
     4.858    70.645     0.200
     4.980    72.188     0.200
     5.016    72.406     0.200
     4.994    71.465     0.200
     5.079    73.156     0.200
     5.039    71.957     0.200
     5.049    72.117     0.200
     5.083    72.414     0.200
     5.228    76.195     0.200
     5.199    74.406     0.200
     5.264    74.324     0.200
     5.457    78.984     0.200
     5.409    77.336     0.200
     5.443    77.457     0.200
     5.558    79.254     0.200
     5.675    81.816     0.200
     5.708    81.637     0.200
     5.769    82.047     0.200
     5.824    83.188     0.200
     5.944    84.805     0.200
     5.986    85.246     0.200
     6.205    89.406     0.200
     6.278    90.367     0.200
     6.432    92.367     0.200
     6.508    94.637     0.200
     6.488    93.566     0.200
     6.641    95.195     0.200
     6.577    93.938     0.200
     6.787    97.156     0.200
     6.805    96.566     0.200
     6.921    99.055     0.200
     7.137   101.367     0.200
     7.259   104.805     0.200
     7.141   100.957     0.200
     7.560   107.027     0.200
     7.678   107.707     0.200
     7.663   110.277     0.200
     7.778   109.875     0.200
     7.851   110.836     0.200
     7.896   111.516     0.200
     7.926   111.844     0.200
     7.993   113.426     0.200
     7.927   112.344     0.200
     8.068   115.395     0.200
     8.052   113.156     0.200
     8.160   113.977     0.200
     8.171   114.625     0.200
     8.181   116.957     0.200
     8.256   115.266     0.200
     8.762   123.906     0.200
     9.193   129.285     0.200
    10.166   141.438     0.200
    10.265   141.277     0.200
    11.036   153.027     0.200
    12.908   180.590     0.200
    14.073   195.977     0.200
    14.073   199.516     0.200
    14.058   197.414     0.200
    14.403   199.867     0.200
    20.487   277.547     0.200
    20.504   276.836     0.200
    20.626   278.227     0.200
    20.871   280.867     0.200
     1.369    24.602     0.200
     1.396    25.109     0.200
     1.401    25.047     0.200
     1.425    25.445     0.200
     1.459    26.367     0.200
     1.574    28.414     0.200
     1.637    29.320     0.200
     1.650    29.547     0.200
     1.678    29.930     0.200
     1.888    32.805     0.200
     2.161    36.617     0.200
     2.223    37.836     0.200
     2.415    39.977     0.200
     2.450    39.945     0.200
     2.463    40.938     0.200
     2.515    41.734     0.200
     2.520    41.609     0.200
     2.566    42.445     0.200
     2.568    42.102     0.200
     2.582    42.352     0.200
     2.961    47.789     0.200
     3.063    49.070     0.200
     3.091    49.352     0.200
     3.073    49.352     0.200
     3.449    53.250     0.200
     3.575    54.195     0.200
     3.698    56.875     0.200
     3.702    57.641     0.200
     3.711    57.516     0.200
     3.735    57.750     0.200
     3.896    59.648     0.200
     3.909    60.305     0.200
     3.976    61.617     0.200
     4.038    61.211     0.200
     4.393    67.008     0.200
     4.438    65.719     0.200
     4.463    66.719     0.200
     4.470    67.016     0.200
     4.477    66.688     0.200
     4.560    67.414     0.200
     4.683    70.141     0.200
     4.704    70.195     0.200
     4.732    70.578     0.200
     4.877    72.734     0.200
     4.848    72.648     0.200
     4.867    71.930     0.200
     5.059    77.031     0.200
     5.054    75.078     0.200
     5.072    75.727     0.200
     5.487    81.539     0.200
     5.483    81.414     0.200
     5.567    82.852     0.200
     5.662    84.102     0.200
     5.660    84.438     0.200
     5.683    84.367     0.200
     5.625    83.328     0.200
     5.773    85.602     0.200
     6.000    88.141     0.200
     6.028    88.789     0.200
     6.078    90.055     0.200
     6.176    91.305     0.200
     6.175    91.664     0.200
     6.212    91.398     0.200
     6.372    93.445     0.200
     6.510    95.680     0.200
     6.776    99.398     0.200
     7.132   105.070     0.200
     7.304   105.320     0.200
     7.462   108.906     0.200
     7.605   109.500     0.200
     7.747   111.656     0.200
     7.776   111.984     0.200
     7.805   111.961     0.200
     8.519   122.828     0.200
     8.602   124.469     0.200
     9.359   136.039     0.200
    10.612   150.477     0.200
    12.056   173.156     0.200
    13.825   195.555     0.200
     0.852    15.670     0.200
     0.893    16.420     0.200
     0.910    16.541     0.200
     0.997    17.970     0.200
     1.023    18.200     0.200
     1.070    18.750     0.200
     1.048    18.440     0.200
     0.951    17.561     0.200
     1.123    19.950     0.200
     1.144    20.190     0.200
     0.983    17.440     0.200
     1.189    20.450     0.200
     1.261    21.410     0.200
     1.213    21.220     0.200
     1.335    22.630     0.200
     1.554    25.420     0.200
     1.802    29.041     0.200
     1.992    32.061     0.200
     2.082    32.170     0.200
     2.016    32.620     0.200
     2.018    32.480     0.200
     2.019    32.660     0.200
     2.325    36.561     0.200
     2.641    40.630     0.200
     2.638    40.960     0.200
     2.690    41.581     0.200
     2.645    40.430     0.200
     2.705    41.561     0.200
     2.734    41.870     0.200
     3.219    48.820     0.200
     3.305    50.010     0.200
     3.692    56.280     0.200
     3.802    56.430     0.200
     3.742    54.240     0.200
     4.064    60.081     0.200
     3.935    58.351     0.200
     3.958    58.240     0.200
     3.990    57.990     0.200
     4.101    61.360     0.200
     4.129    62.561     0.200
     4.425    64.230     0.200
     4.636    68.021     0.200
     4.676    67.791     0.200
     4.682    68.500     0.200
     4.535    65.561     0.200
     4.729    69.390     0.200
     4.767    69.630     0.200
     4.604    66.150     0.200
     4.831    70.260     0.200
     4.607    65.110     0.200
     4.804    69.750     0.200
     5.058    72.851     0.200
     5.122    73.620     0.200
     4.940    70.581     0.200
     4.985    71.200     0.200
     4.998    71.360     0.200
     5.269    76.660     0.200
     5.059    71.640     0.200
     5.145    73.630     0.200
     5.403    77.740     0.200
     5.632    81.340     0.200
     5.505    78.351     0.200
     5.599    79.890     0.200
     5.654    80.820     0.200
     5.717    82.180     0.200
     5.776    81.860     0.200
     5.891    83.811     0.200
     6.225    88.800     0.200
     6.380    91.550     0.200
     6.549    93.920     0.200
     6.587    93.791     0.200
     6.530    93.260     0.200
     6.635    94.210     0.200
     6.620    94.490     0.200
     6.734    96.291     0.200
     6.757    95.180     0.200
     6.868    97.791     0.200
     7.084   100.250     0.200
     7.092   100.291     0.200
     7.105   100.480     0.200
     7.512   106.360     0.200
     7.609   108.630     0.200
     7.820   110.720     0.200
     7.926   112.200     0.200
     7.845   110.890     0.200
     8.034   112.800     0.200
     7.872   110.791     0.200
     7.909   110.730     0.200
     7.885   111.360     0.200
     8.107   114.450     0.200
     8.118   114.370     0.200
     8.202   114.660     0.200
     8.714   123.101     0.200
     9.005   126.021     0.200
     9.139   128.720     0.200
    10.112   141.120     0.200
    10.234   140.760     0.200
    12.870   180.660     0.200
    12.985   182.370     0.200
    14.110   194.500     0.200
    14.012   193.400     0.200
    14.350   197.936     0.200
    15.863   220.360     0.200
    20.474   276.820     0.200
    20.490   277.670     0.200
    20.610   278.561     0.200
     0.820    14.849     0.200
     0.857    15.509     0.200
     0.876    15.749     0.200
     0.960    17.159     0.200
     0.989    17.609     0.200
     1.035    18.029     0.200
     1.021    17.669     0.200
     0.973    17.099     0.200
     1.007    17.249     0.200
     1.100    19.309     0.200
     1.119    19.659     0.200
     1.160    19.589     0.200
     1.224    20.869     0.200
     1.193    20.709     0.200
     1.307    22.019     0.200
     1.559    25.489     0.200
     1.782    28.609     0.200
     1.980    31.979     0.200
     2.004    32.609     0.200
     2.010    32.549     0.200
     2.025    32.729     0.200
     2.055    31.759     0.200
     2.314    36.249     0.200
     2.630    40.979     0.200
     2.638    41.199     0.200
     2.649    40.599     0.200
     2.679    41.799     0.200
     2.694    41.439     0.200
     2.722    41.759     0.200
     2.731    42.299     0.200
     2.947    44.229     0.200
     3.058    46.929     0.200
     3.160    48.449     0.200
     3.209    48.909     0.200
     3.294    50.179     0.200
     3.777    56.349     0.200
     3.744    54.859     0.200
     3.812    56.989     0.200
     3.949    58.629     0.200
     4.044    60.289     0.200
     4.092    59.179     0.200
     4.358    62.589     0.200
     4.425    64.369     0.200
     4.535    66.169     0.200
     4.659    68.219     0.200
     4.610    66.289     0.200
     4.706    68.959     0.200
     4.627    65.769     0.200
     4.735    69.709     0.200
     4.744    69.459     0.200
     4.809    70.009     0.200
     4.801    70.389     0.200
     4.940    71.729     0.200
     5.036    72.869     0.200
     4.988    71.439     0.200
     5.011    71.819     0.200
     5.100    73.119     0.200
     5.245    76.739     0.200
     5.406    77.139     0.200
     5.515    78.449     0.200
     5.609    82.319     0.200
     5.614    80.289     0.200
     5.658    80.969     0.200
     5.728    82.459     0.200
     5.899    84.099     0.200
     5.955    85.569     0.200
     6.041    86.789     0.200
     6.230    89.599     0.200
     6.371    91.999     0.200
     6.582    94.699     0.200
     6.549    94.089     0.200
     6.738    97.099     0.200
     6.862    98.429     0.200
     7.087   100.829     0.200
     7.107   100.929     0.200
     7.124   100.899     0.200
     7.529   106.849     0.200
     7.797   110.309     0.200
     7.902   111.679     0.200
     7.868   111.199     0.200
     8.010   114.019     0.200
     8.031   112.859     0.200
     8.100   115.769     0.200
     8.197   115.369     0.200
     8.972   128.069     0.200
    10.265   143.809     0.200
    12.898   180.894     0.200
    13.021   182.649     0.200
    14.082   195.049     0.200
    14.351   200.419     0.200
    15.898   218.019     0.200
     0.348    11.619     0.200
     0.407    11.949     0.200
     0.520    12.990     0.200
     0.618    13.959     0.200
     0.601    13.869     0.200
     0.676    14.400     0.200
     0.722    15.350     0.200
     0.756    15.900     0.200
     0.781    16.430     0.200
     0.784    16.469     0.200
     0.754    15.449     0.200
     0.803    16.469     0.200
     0.867    16.459     0.200
     0.959    17.379     0.200
     0.952    17.760     0.200
     1.016    17.889     0.200
     1.086    20.109     0.200
     1.058    19.240     0.200
     1.085    19.799     0.200
     1.181    20.299     0.200
     1.183    20.990     0.200
     1.259    21.680     0.200
     1.401    23.930     0.200
     1.451    24.729     0.200
     1.465    25.320     0.200
     1.465    24.570     0.200
     1.497    25.219     0.200
     1.532    25.619     0.200
     1.533    25.469     0.200
     1.819    29.070     0.200
     1.870    30.959     0.200
     1.929    31.020     0.200
     1.978    31.830     0.200
     2.010    32.309     0.200
     2.468    39.889     0.200
     2.693    41.670     0.200
     2.735    41.840     0.200
     3.230    48.189     0.200
     3.274    47.979     0.200
     3.346    49.639     0.200
     3.498    51.170     0.200
     3.588    53.559     0.200
     3.747    54.580     0.200
     3.826    55.879     0.200
     3.950    58.189     0.200
     4.005    57.180     0.200
     4.036    58.650     0.200
     4.166    61.299     0.200
     4.454    64.779     0.200
     4.506    65.479     0.200
     4.500    65.830     0.200
     4.522    65.709     0.200
     4.670    67.490     0.200
     4.687    67.650     0.200
     4.818    69.420     0.200
     4.810    70.490     0.200
     4.993    75.340     0.200
     5.063    72.789     0.200
     5.095    74.420     0.200
     5.109    74.369     0.200
     5.354    77.350     0.200
     5.594    81.080     0.200
     5.630    81.320     0.200
     5.768    82.240     0.200
     5.922    84.729     0.200
     6.173    88.100     0.200
     6.285    89.750     0.200
     6.868    97.439     0.200
     6.971    98.039     0.200
     6.971    98.689     0.200
     7.300   104.490     0.200
     7.427   106.240     0.200
     7.512   107.279     0.200
     9.744   136.689     0.200
    13.165   183.084     0.200
     0.717    13.516     0.200
     0.631    13.055     0.200
     0.795    15.137     0.200
     0.683    13.676     0.200
     0.791    14.707     0.200
     0.811    15.008     0.200
     0.840    15.637     0.200
     0.845    15.977     0.200
     0.855    15.637     0.200
     0.922    16.816     0.200
     0.955    17.035     0.200
     0.999    17.895     0.200
     0.996    17.785     0.200
     1.062    18.527     0.200
     1.074    19.145     0.200
     1.116    20.207     0.200
     1.215    20.758     0.200
     1.404    23.316     0.200
     1.531    25.918     0.200
     1.555    26.465     0.200
     1.558    26.496     0.200
     1.559    26.508     0.200
     1.563    26.477     0.200
     1.756    27.465     0.200
     1.860    30.438     0.200
     2.150    34.215     0.200
     2.175    34.176     0.200
     2.161    33.988     0.200
     2.225    35.055     0.200
     2.238    34.938     0.200
     2.271    35.707     0.200
     2.278    35.508     0.200
     2.306    35.746     0.200
     2.458    37.707     0.200
     2.570    40.637     0.200
     2.563    39.996     0.200
     2.657    40.586     0.200
     2.702    41.406     0.200
     2.656    41.086     0.200
     2.752    42.047     0.200
     3.255    47.977     0.200
     3.434    51.555     0.200
     3.484    51.965     0.200
     3.507    51.246     0.200
     3.613    55.188     0.200
     3.819    56.637     0.200
     3.785    54.977     0.200
     3.870    56.598     0.200
     3.937    57.086     0.200
     4.047    59.168     0.200
     4.202    60.098     0.200
     4.316    62.715     0.200
     4.452    63.887     0.200
     4.499    64.676     0.200
     4.477    65.008     0.200
     4.546    65.195     0.200
     4.657    67.008     0.200
     4.751    67.465     0.200
     4.848    69.227     0.200
     4.887    69.926     0.200
     4.920    70.766     0.200
     5.036    72.375     0.200
     5.021    73.207     0.200
     5.039    73.336     0.200
     5.091    74.578     0.200
     5.170    74.258     0.200
     5.116    74.465     0.200
     5.157    73.965     0.200
     5.227    75.938     0.200
     5.155    75.258     0.200
     5.249    76.117     0.200
     5.253    75.168     0.200
     5.228    75.297     0.200
     5.288    76.438     0.200
     5.343    76.766     0.200
     5.418    77.637     0.200
     5.510    79.035     0.200
     5.521    78.766     0.200
     5.643    80.238     0.200
     5.648    82.066     0.200
     5.743    82.375     0.200
     6.102    86.836     0.200
     6.146    87.848     0.200
     6.120    87.598     0.200
     6.216    88.238     0.200
     6.251    89.215     0.200
     6.320    90.266     0.200
     6.385    91.375     0.200
     6.428    92.137     0.200
     6.466    91.855     0.200
     6.598    93.508     0.200
     6.655    94.496     0.200
     6.695    95.266     0.200
     7.084   100.836     0.200
     7.147   100.035     0.200
     7.385   104.305     0.200
     7.426   104.227     0.200
     7.516   105.395     0.200
     7.624   106.426     0.200
     7.624   107.496     0.200
     7.716   107.566     0.200
     7.913   111.688     0.200
     8.195   116.027     0.200
     8.281   117.465     0.200
     8.200   115.805     0.200
     8.219   116.707     0.200
     8.301   116.676     0.200
     8.775   123.227     0.200
     9.369   131.637     0.200
     9.967   137.316     0.200
    10.073   141.238     0.200
    10.500   146.285     0.200
    12.542   175.418     0.200
    13.189   182.906     0.200
    13.862   192.117     0.200
    14.439   201.426     0.200
    15.701   218.809     0.200
    20.370   274.805     0.200
    20.373   275.367     0.200
    20.475   276.375     0.200
    20.723   277.945     0.200
    20.824   280.195     0.200
     0.263     8.422     0.200
     0.614    12.973     0.200
     1.215    20.793     0.200
     1.265    21.543     0.200
     1.343    22.770     0.200
     1.355    22.801     0.200
     1.400    22.781     0.200
     1.455    24.562     0.200
     1.466    25.230     0.200
     1.479    25.500     0.200
     1.496    25.383     0.200
     1.502    24.320     0.200
     1.509    24.812     0.200
     1.548    25.102     0.200
     1.573    25.410     0.200
     1.638    26.691     0.200
     1.596    26.031     0.200
     1.705    28.062     0.200
     1.683    27.340     0.200
     1.722    28.480     0.200
     1.718    27.312     0.200
     1.927    30.270     0.200
     2.001    31.641     0.200
     2.055    32.363     0.200
     2.053    32.582     0.200
     2.108    33.062     0.200
     2.112    33.031     0.200
     2.481    38.211     0.200
     2.533    38.883     0.200
     2.744    41.062     0.200
     2.812    43.391     0.200
     2.932    43.730     0.200
     3.162    47.922     0.200
     3.197    47.410     0.200
     3.209    47.992     0.200
     3.276    48.973     0.200
     3.364    50.520     0.200
     3.374    49.602     0.200
     3.334    49.090     0.200
     3.446    49.621     0.200
     3.453    50.500     0.200
     3.537    52.160     0.200
     3.849    56.301     0.200
     3.870    56.781     0.200
     3.942    56.910     0.200
     3.951    57.301     0.200
     3.954    57.000     0.200
     4.077    58.340     0.200
     4.160    60.262     0.200
     4.241    61.641     0.200
     4.323    63.113     0.200
     4.385    63.531     0.200
     4.442    64.582     0.200
     4.587    66.152     0.200
     4.541    65.672     0.200
     4.615    66.461     0.200
     4.601    66.801     0.200
     4.775    68.922     0.200
     4.779    69.012     0.200
     5.151    74.883     0.200
     5.224    75.070     0.200
     5.272    75.172     0.200
     5.368    77.371     0.200
     5.249    75.043     0.200
     5.270    75.340     0.200
     5.529    79.223     0.200
     5.672    82.062     0.200
     5.707    81.520     0.200
     5.664    81.660     0.200
     5.654    81.051     0.200
     5.690    81.191     0.200
     5.775    83.512     0.200
     5.809    82.492     0.200
     5.931    84.742     0.200
     5.878    84.352     0.200
     5.904    84.730     0.200
     5.916    84.621     0.200
     5.990    85.863     0.200
     5.985    85.691     0.200
     6.034    86.652     0.200
     6.156    88.133     0.200
     6.349    91.000     0.200
     6.611    95.543     0.200
     6.858    97.062     0.200
     6.787    95.570     0.200
     6.928    97.820     0.200
     6.939    98.332     0.200
     7.227   101.473     0.200
     7.282   102.141     0.200
     8.125   114.590     0.200
    13.310   185.668     0.200
     0.637    13.865     0.200
     0.756    15.046     0.200
     0.814    15.666     0.200
     1.014    18.686     0.200
     1.402    24.346     0.200
     1.544    25.086     0.200
     1.790    28.945     0.200
     2.039    32.796     0.200
     2.072    32.735     0.200
     2.138    33.746     0.200
     2.367    36.445     0.200
     2.454    38.865     0.200
     2.690    41.206     0.200
     3.070    47.976     0.200
     3.149    46.926     0.200
     3.226    48.726     0.200
     3.299    49.926     0.200
     3.324    49.825     0.200
     3.421    50.065     0.200
     3.488    52.626     0.200
     3.523    53.046     0.200
     3.699    55.315     0.200
     3.746    54.365     0.200
     3.820    55.706     0.200
     3.933    57.726     0.200
     4.187    60.926     0.200
     4.208    60.886     0.200
     4.336    62.016     0.200
     4.399    63.306     0.200
     4.499    64.916     0.200
     4.540    65.296     0.200
     4.740    68.176     0.200
     4.774    69.416     0.200
     4.974    71.546     0.200
     5.022    73.176     0.200
     5.022    73.046     0.200
     5.026    73.266     0.200
     5.044    73.646     0.200
     5.074    72.956     0.200
     5.157    75.096     0.200
     5.197    74.256     0.200
     5.237    75.325     0.200
     5.349    76.626     0.200
     5.495    78.966     0.200
     5.604    79.686     0.200
     5.655    81.166     0.200
     5.961    85.275     0.200
     6.025    85.916     0.200
     6.119    87.815     0.200
     6.169    87.506     0.200
     6.239    89.096     0.200
     6.253    89.496     0.200
     6.264    89.836     0.200
     6.474    92.646     0.200
     6.498    92.195     0.200
     6.630    93.916     0.200
     6.745    97.075     0.200
     6.928    98.896     0.200
     6.992    98.275     0.200
     7.066   100.466     0.200
     7.250   102.386     0.200
     7.477   104.886     0.200
     7.486   105.206     0.200
     7.577   106.916     0.200
     7.578   106.445     0.200
     7.641   107.796     0.200
     7.724   108.586     0.200
     7.841   110.775     0.200
     8.005   113.646     0.200
     8.091   114.216     0.200
     8.194   116.166     0.200
     8.565   122.766     0.200
    10.050   139.346     0.200
    12.592   176.516     0.200
    13.753   190.341     0.200
    14.397   198.556     0.200
     0.842    15.672     0.200
     0.942    17.094     0.200
     0.954    17.461     0.200
     1.197    20.570     0.200
     1.217    20.973     0.200
     1.225    21.281     0.200
     1.361    22.902     0.200
     1.372    22.281     0.200
     1.407    23.523     0.200
     2.245    35.613     0.200
     2.851    43.922     0.200
     2.916    44.852     0.200
     2.985    45.594     0.200
     3.380    51.250     0.200
     3.548    53.113     0.200
     3.652    54.410     0.200
     3.711    55.133     0.200
     3.843    56.742     0.200
     4.054    59.051     0.200
     4.141    61.562     0.200
     4.177    61.730     0.200
     4.213    63.012     0.200
     4.249    63.113     0.200
     4.287    64.422     0.200
     4.326    63.434     0.200
     4.597    67.344     0.200
     4.638    67.863     0.200
     4.721    68.082     0.200
     4.835    70.023     0.200
     4.846    71.801     0.200
     5.238    74.441     0.200
     5.441    78.141     0.200
     5.658    81.750     0.200
     5.681    82.184     0.200
     5.646    81.184     0.200
     5.644    80.660     0.200
     5.868    83.863     0.200
     6.086    86.652     0.200
     6.478    91.633     0.200
     6.560    94.121     0.200
     7.051    99.730     0.200
     7.110   100.633     0.200
     7.397   104.953     0.200
     7.488   105.992     0.200
     8.344   116.223     0.200
     8.457   117.723     0.200
     8.494   119.531     0.200
     8.742   123.141     0.200
     8.741   123.273     0.200
     8.829   124.820     0.200
     8.872   126.082     0.200
    13.299   186.496     0.200
    14.655   202.070     0.200
     0.291    14.957     0.200
     1.497    25.695     0.200
     1.547    26.797     0.200
     1.764    29.695     0.200
     1.900    32.375     0.200
     2.624    41.715     0.200
     3.069    46.586     0.200
     3.101    48.145     0.200
     3.190    48.887     0.200
     3.339    50.836     0.200
     3.651    56.207     0.200
     3.743    55.137     0.200
     3.759    56.895     0.200
     3.808    57.105     0.200
     3.811    56.574     0.200
     3.854    56.395     0.200
     4.120    60.164     0.200
     4.232    62.195     0.200
     4.239    62.246     0.200
     4.307    64.066     0.200
     4.445    64.605     0.200
     4.510    64.734     0.200
     4.564    66.234     0.200
     4.755    68.184     0.200
     4.775    69.605     0.200
     4.856    71.047     0.200
     4.961    70.785     0.200
     5.007    71.746     0.200
     5.060    72.477     0.200
     5.151    74.934     0.200
     5.175    74.746     0.200
     5.161    73.797     0.200
     5.294    76.117     0.200
     5.256    74.637     0.200
     5.274    75.996     0.200
     5.379    76.914     0.200
     5.448    77.164     0.200
     5.555    79.395     0.200
     5.675    81.305     0.200
     5.705    81.695     0.200
     5.743    81.824     0.200
     5.937    84.684     0.200
     5.901    84.555     0.200
     5.936    84.715     0.200
     6.068    86.625     0.200
     6.189    88.324     0.200
     6.280    89.656     0.200
     6.364    90.496     0.200
     6.622    93.457     0.200
     6.749    95.234     0.200
     6.882    98.285     0.200
     6.832    97.547     0.200
     6.918    98.145     0.200
     7.023    99.117     0.200
     7.060   100.906     0.200
     7.150   100.957     0.200
     7.402   104.297     0.200
     7.414   105.117     0.200
     7.368   105.066     0.200
     7.463   104.227     0.200
     7.577   105.465     0.200
     7.634   107.707     0.200
     7.791   108.246     0.200
     7.796   108.773     0.200
     7.848   111.477     0.200
     7.971   110.965     0.200
     7.977   110.820     0.200
     8.110   112.469     0.200
     8.355   118.504     0.200
    10.834   149.766     0.200
    13.394   186.594     0.200
    13.594   186.496     0.200
    14.367   196.871     0.200
     0.499    11.750     0.200
     0.691    13.191     0.200
     0.592    13.312     0.200
     0.624    14.062     0.200
     0.747    13.660     0.200
     0.700    14.371     0.200
     0.782    15.430     0.200
     0.825    15.820     0.200
     0.951    17.211     0.200
     0.959    17.480     0.200
     0.963    17.902     0.200
     0.969    17.480     0.200
     0.985    18.590     0.200
     0.988    18.770     0.200
     0.990    18.461     0.200
     0.993    18.461     0.200
     0.991    18.109     0.200
     1.001    18.430     0.200
     1.011    18.680     0.200
     1.048    18.652     0.200
     1.118    19.562     0.200
     1.143    19.832     0.200
     1.208    20.973     0.200
     1.281    21.820     0.200
     1.277    22.320     0.200
     1.403    23.621     0.200
     1.523    26.410     0.200
     1.496    24.641     0.200
     1.547    25.562     0.200
     1.585    26.230     0.200
     1.646    26.961     0.200
     1.711    27.750     0.200
     1.843    29.180     0.200
     1.942    31.562     0.200
     2.103    33.223     0.200
     2.133    34.180     0.200
     2.154    34.281     0.200
     2.194    34.820     0.200
     2.579    41.340     0.200
     2.631    39.723     0.200
     2.896    43.090     0.200
     2.873    43.742     0.200
     2.984    46.473     0.200
     2.992    45.070     0.200
     3.051    46.172     0.200
     3.144    47.672     0.200
     3.194    48.992     0.200
     3.229    47.820     0.200
     3.420    50.672     0.200
     3.688    54.770     0.200
     3.825    55.562     0.200
     3.878    56.359     0.200
     3.992    58.109     0.200
     4.000    57.191     0.200
     4.030    58.770     0.200
     4.177    59.410     0.200
     4.224    61.691     0.200
     4.299    62.562     0.200
     4.297    63.012     0.200
     4.393    63.621     0.200
     4.449    64.449     0.200
     4.552    65.859     0.200
     4.616    66.742     0.200
     4.673    67.461     0.200
     4.744    69.141     0.200
     4.816    69.801     0.200
     4.766    69.410     0.200
     4.823    69.441     0.200
     4.992    71.980     0.200
     5.016    72.871     0.200
     5.086    73.180     0.200
     5.311    77.160     0.200
     5.477    78.582     0.200
     5.518    79.422     0.200
     5.647    81.109     0.200
     5.636    82.043     0.200
     5.638    80.000     0.200
     5.761    83.270     0.200
     5.978    85.383     0.200
     6.039    86.000     0.200
     6.119    86.723     0.200
     6.230    91.172     0.200
     6.528    91.973     0.200
     6.757    95.793     0.200
     6.779    97.109     0.200
     6.801    95.840     0.200
     7.000    98.770     0.200
     7.089    99.922     0.200
     7.636   108.410     0.200
     7.720   109.781     0.200
    12.156   171.172     0.200
    13.238   182.445     0.200
     0.060    19.711     0.200
     0.271    20.201     0.200
     0.328    20.330     0.200
     0.351    20.381     0.200
     0.434    20.512     0.200
     0.459    20.521     0.200
     0.515    21.221     0.200
     0.555    21.121     0.200
     0.609    21.670     0.200
     0.619    21.480     0.200
     0.690    22.301     0.200
     0.769    23.000     0.200
     0.898    23.891     0.200
     1.222    26.602     0.200
     1.674    31.490     0.200
     1.678    31.721     0.200
     1.693    31.941     0.200
     1.700    31.951     0.200
     1.711    32.102     0.200
     1.745    32.102     0.200
     1.873    32.621     0.200
     1.902    34.061     0.200
     1.930    33.281     0.200
     1.956    34.980     0.200
     2.229    38.070     0.200
     2.282    38.551     0.200
     2.290    38.740     0.200
     2.356    39.721     0.200
     2.675    43.361     0.200
     2.714    44.182     0.200
     2.741    44.320     0.200
     2.740    44.012     0.200
     2.815    45.490     0.200
     2.838    45.701     0.200
     2.910    46.410     0.200
     2.966    47.842     0.200
     3.004    47.070     0.200
     3.430    54.080     0.200
     3.472    54.211     0.200
     3.497    53.932     0.200
     3.651    56.561     0.200
     3.672    56.191     0.200
     3.893    60.400     0.200
     3.865    57.061     0.200
     4.022    60.400     0.200
     4.376    64.791     0.200
     4.431    66.061     0.200
     4.520    66.650     0.200
     4.537    67.160     0.200
     4.537    67.051     0.200
     4.615    69.660     0.200
     4.759    69.102     0.200
     4.827    70.461     0.200
     4.900    70.621     0.200
     4.952    71.381     0.200
     4.988    72.750     0.200
     5.192    74.682     0.200
     5.275    76.730     0.200
     5.413    77.490     0.200
     5.486    79.541     0.200
     5.584    79.900     0.200
     5.636    81.551     0.200
     5.677    81.701     0.200
     5.881    84.820     0.200
     5.977    85.400     0.200
     6.139    88.541     0.200
     6.181    88.471     0.200
     6.189    88.650     0.200
     6.326    91.182     0.200
     6.348    90.621     0.200
     6.374    90.160     0.200
     6.423    91.701     0.200
     6.454    92.871     0.200
     6.670    95.512     0.200
     6.876    98.230     0.200
     6.878    98.721     0.200
     6.989   100.230     0.200
     6.994   100.980     0.200
     7.101    99.701     0.200
     7.115   101.670     0.200
     7.144   102.182     0.200
     7.359   105.012     0.200
     7.417   105.592     0.200
     7.395   105.551     0.200
     7.397   103.682     0.200
     7.458   104.240     0.200
     7.493   105.041     0.200
     7.477   105.561     0.200
     7.617   106.490     0.200
     7.634   107.080     0.200
     7.774   111.031     0.200
     7.794   108.801     0.200
     7.794   108.053     0.200
     8.426   119.141     0.200
     8.662   122.371     0.200
    14.112   190.980     0.200
     0.561    11.008     0.200
     0.782    15.289     0.200
     0.778    15.281     0.200
     0.822    14.883     0.200
     0.823    15.391     0.200
     0.844    16.164     0.200
     0.923    16.383     0.200
     0.988    17.273     0.200
     0.986    17.703     0.200
     1.063    18.914     0.200
     1.108    19.242     0.200
     1.132    19.328     0.200
     1.323    22.148     0.200
     2.097    33.359     0.200
     2.354    37.195     0.200
     2.520    39.539     0.200
     2.551    39.828     0.200
     2.571    40.242     0.200
     2.608    40.695     0.200
     2.654    40.930     0.200
     2.661    40.883     0.200
     2.972    43.562     0.200
     2.999    46.812     0.200
     3.034    45.148     0.200
     3.282    48.352     0.200
     3.281    49.531     0.200
     3.294    49.508     0.200
     3.297    49.719     0.200
     3.322    50.203     0.200
     3.342    50.492     0.200
     3.356    50.844     0.200
     3.331    50.133     0.200
     3.367    50.898     0.200
     3.399    50.531     0.200
     3.422    51.531     0.200
     3.559    51.883     0.200
     3.501    52.562     0.200
     3.608    53.281     0.200
     3.829    56.219     0.200
     4.104    60.133     0.200
     4.234    60.719     0.200
     4.276    61.609     0.200
     4.321    62.289     0.200
     4.361    62.203     0.200
     4.439    64.203     0.200
     4.524    64.258     0.200
     4.628    66.734     0.200
     4.660    66.750     0.200
     4.718    67.422     0.200
     4.685    66.328     0.200
     4.719    68.859     0.200
     4.809    69.203     0.200
     4.946    71.234     0.200
     5.071    72.711     0.200
     5.120    73.523     0.200
     5.108    74.469     0.200
     5.191    74.383     0.200
     5.289    76.094     0.200
     5.250    75.078     0.200
     5.361    77.734     0.200
     5.417    77.031     0.200
     5.354    76.969     0.200
     5.371    76.914     0.200
     5.518    79.664     0.200
     5.731    82.953     0.200
     5.732    83.312     0.200
     5.902    84.312     0.200
     5.897    84.109     0.200
     5.930    84.430     0.200
     5.989    85.180     0.200
     6.026    86.789     0.200
     6.092    87.711     0.200
     6.182    89.055     0.200
     6.375    90.500     0.200
     6.431    90.648     0.200
     6.950    97.891     0.200
     7.509   105.750     0.200
     7.508   105.055     0.200
     7.686   108.320     0.200
     8.039   113.539     0.200
     8.124   115.500     0.200
     8.414   118.273     0.200
    10.215   145.492     0.200
    12.348   175.469     0.200
    13.641   189.406     0.200
     0.203    14.539     0.200
     0.266    14.703     0.200
     0.384    15.141     0.200
     0.376    14.891     0.200
     0.440    15.852     0.200
     0.433    15.484     0.200
     0.550    16.641     0.200
     0.626    16.570     0.200
     0.688    17.344     0.200
     0.700    17.523     0.200
     0.826    19.344     0.200
     0.779    18.414     0.200
     0.846    19.703     0.200
     0.850    19.773     0.200
     0.861    19.914     0.200
     0.864    19.766     0.200
     0.799    18.461     0.200
     0.902    19.680     0.200
     0.926    19.789     0.200
     1.239    22.383     0.200
     1.298    23.312     0.200
     1.461    26.414     0.200
     1.526    27.234     0.200
     1.698    29.391     0.200
     1.803    30.273     0.200
     1.944    32.516     0.200
     1.987    33.305     0.200
     2.022    33.695     0.200
     2.048    33.969     0.200
     2.076    34.648     0.200
     2.077    33.391     0.200
     2.120    34.898     0.200
     2.162    35.031     0.200
     2.571    40.344     0.200
     2.613    42.320     0.200
     2.746    43.055     0.200
     2.774    43.250     0.200
     2.786    43.234     0.200
     2.787    42.711     0.200
     2.800    43.984     0.200
     2.741    42.414     0.200
     2.826    44.641     0.200
     2.845    44.891     0.200
     2.874    43.133     0.200
     2.830    43.320     0.200
     2.911    45.031     0.200
     2.972    46.055     0.200
     3.114    46.609     0.200
     3.270    50.094     0.200
     3.409    51.164     0.200
     3.530    52.719     0.200
     3.576    53.000     0.200
     3.737    55.609     0.200
     3.924    56.859     0.200
     4.033    58.562     0.200
     4.124    59.844     0.200
     4.176    61.391     0.200
     4.266    62.820     0.200
     4.270    61.289     0.200
     4.334    63.312     0.200
     4.346    63.195     0.200
     4.369    64.445     0.200
     4.391    64.781     0.200
     4.481    64.086     0.200
     4.717    68.219     0.200
     4.717    68.125     0.200
     4.736    68.312     0.200
     4.743    68.531     0.200
     4.910    71.500     0.200
     4.957    71.562     0.200
     5.069    72.891     0.200
     5.193    74.703     0.200
     5.193    75.125     0.200
     5.217    76.023     0.200
     5.314    76.453     0.200
     5.298    78.922     0.200
     5.379    77.789     0.200
     5.337    77.703     0.200
     5.412    77.750     0.200
     5.461    77.961     0.200
     5.434    79.266     0.200
     5.584    79.781     0.200
     5.725    82.039     0.200
     5.727    82.961     0.200
     5.806    83.320     0.200
     5.948    84.789     0.200
     5.973    85.844     0.200
     6.013    85.711     0.200
     6.041    87.242     0.200
     6.088    87.852     0.200
     6.117    87.289     0.200
     6.170    88.305     0.200
     6.419    92.500     0.200
     6.453    90.680     0.200
     6.475    92.219     0.200
     6.554    92.086     0.200
     6.568    94.672     0.200
     6.630    93.930     0.200
     6.764    95.016     0.200
     6.768    94.773     0.200
     6.932    99.148     0.200
     6.957    97.492     0.200
     6.957    97.602     0.200
     7.043   100.086     0.200
     7.081    98.953     0.200
     7.081    98.641     0.200
     7.153   100.539     0.200
     7.378   104.969     0.200
     7.464   105.852     0.200
     7.538   107.289     0.200
     7.610   108.219     0.200
     7.718   109.352     0.200
     7.950   114.523     0.200
     8.025   112.180     0.200
     8.330   118.570     0.200
     8.412   118.469     0.200
     8.970   126.203     0.200
     9.423   135.180     0.200
     9.830   135.383     0.200
    10.220   141.453     0.200
    12.650   177.016     0.200
    13.329   183.367     0.200
     0.438    13.359     0.200
     0.499    13.789     0.200
     0.503    13.867     0.200
     0.502    13.977     0.200
     0.594    14.992     0.200
     0.611    15.117     0.200
     0.763    16.289     0.200
     0.770    16.680     0.200
     0.852    17.688     0.200
     0.885    17.992     0.200
     0.903    18.453     0.200
     1.017    19.477     0.200
     1.035    19.922     0.200
     1.335    22.617     0.200
     1.382    23.062     0.200
     1.497    25.531     0.200
     1.600    26.961     0.200
     1.719    28.531     0.200
     1.907    31.352     0.200
     1.942    32.000     0.200
     1.948    32.086     0.200
     2.205    35.047     0.200
     2.549    40.062     0.200
     2.613    40.930     0.200
     2.629    41.086     0.200
     3.048    45.742     0.200
     3.075    47.586     0.200
     3.106    47.859     0.200
     3.110    47.992     0.200
     3.133    48.250     0.200
     3.207    49.320     0.200
     3.249    49.438     0.200
     3.496    52.586     0.200
     3.684    56.461     0.200
     3.779    55.359     0.200
     3.793    55.742     0.200
     3.811    55.578     0.200
     3.821    55.219     0.200
     3.832    57.586     0.200
     3.874    57.602     0.200
     3.885    58.578     0.200
     4.058    60.898     0.200
     4.326    63.516     0.200
     4.331    64.367     0.200
     4.405    64.398     0.200
     4.451    65.516     0.200
     4.451    64.188     0.200
     4.530    65.688     0.200
     4.579    66.961     0.200
     4.823    69.297     0.200
     4.807    70.328     0.200
     5.062    72.562     0.200
     5.181    74.938     0.200
     5.215    74.883     0.200
     5.311    77.586     0.200
     5.334    77.180     0.200
     5.352    77.562     0.200
     5.392    77.547     0.200
     5.520    78.977     0.200
     5.615    80.102     0.200
     5.670    81.258     0.200
     5.743    82.289     0.200
     5.896    84.250     0.200
     5.991    85.688     0.200
     6.030    85.961     0.200
     6.041    86.078     0.200
     6.202    88.430     0.200
     6.309    89.148     0.200
     6.330    90.812     0.200
     6.823    97.383     0.200
     6.830    98.078     0.200
     6.872    97.203     0.200
     7.013    99.477     0.200
     7.338   103.656     0.200
     7.589   107.562     0.200
     7.774   110.078     0.200
     7.855   109.281     0.200
     8.044   112.297     0.200
     8.167   113.359     0.200
     8.167   113.828     0.200
     8.337   117.320     0.200
     8.401   118.617     0.200
     8.489   120.398     0.200
     8.529   120.492     0.200
     8.550   119.508     0.200
     0.090    18.414     0.200
     0.215    18.693     0.200
     0.307    18.994     0.200
     0.361    18.863     0.200
     0.376    19.313     0.200
     0.434    19.563     0.200
     0.490    19.613     0.200
     0.524    20.044     0.200
     0.558    19.954     0.200
     0.570    19.813     0.200
     0.573    20.284     0.200
     0.645    20.514     0.200
     0.653    21.063     0.200
     0.675    20.974     0.200
     0.705    21.073     0.200
     0.824    22.113     0.200
     1.104    24.964     0.200
     1.107    25.184     0.200
     1.117    25.443     0.200
     1.123    25.363     0.200
     1.129    25.284     0.200
     1.207    25.624     0.200
     1.449    28.014     0.200
     1.638    28.854     0.200
     1.662    30.983     0.200
     1.698    29.653     0.200
     1.724    31.724     0.200
     2.157    37.104     0.200
     2.190    36.693     0.200
     2.192    37.334     0.200
     2.194    37.454     0.200
     2.197    37.434     0.200
     2.350    39.224     0.200
     2.397    40.164     0.200
     2.446    39.534     0.200
     2.437    40.504     0.200
     2.860    46.434     0.200
     2.886    46.284     0.200
     2.947    46.434     0.200
     3.101    48.073     0.200
     3.455    52.704     0.200
     3.529    54.334     0.200
     3.640    54.914     0.200
     3.680    56.313     0.200
     3.804    57.104     0.200
     3.975    59.424     0.200
     3.971    60.244     0.200
     4.189    60.594     0.200
     4.252    64.023     0.200
     4.275    64.193     0.200
     4.328    63.104     0.200
     4.382    63.754     0.200
     4.435    63.964     0.200
     4.439    65.403     0.200
     4.448    64.394     0.200
     4.613    67.704     0.200
     4.619    66.674     0.200
     4.628    66.854     0.200
     4.726    69.544     0.200
     4.805    70.834     0.200
     4.922    71.754     0.200
     4.916    71.854     0.200
     4.960    73.134     0.200
     5.012    72.174     0.200
     5.071    73.434     0.200
     5.078    73.604     0.200
     5.108    74.584     0.200
     5.126    74.233     0.200
     5.292    77.384     0.200
     5.318    77.204     0.200
     5.328    77.644     0.200
     5.371    77.744     0.200
     5.409    77.744     0.200
     5.399    77.613     0.200
     5.617    80.994     0.200
     5.641    82.573     0.200
     5.792    83.233     0.200
     5.811    82.724     0.200
     5.883    84.494     0.200
     5.882    84.273     0.200
     6.098    86.914     0.200
     6.138    87.684     0.200
     6.309    91.284     0.200
     6.389    90.823     0.200
     6.426    93.264     0.200
     6.461    92.974     0.200
     6.576    92.684     0.200
     6.690    95.704     0.200
     6.696    95.124     0.200
     6.706    94.394     0.200
     6.744    96.334     0.200
     6.796    97.233     0.200
     6.844    98.504     0.200
     6.867    98.094     0.200
     6.921    97.144     0.200
     6.945    97.573     0.200
     7.089    99.534     0.200
     7.101    99.594     0.200
     7.251   101.584     0.200
     7.250   101.104     0.200
     7.304   102.804     0.200
     7.330   104.974     0.200
     7.349   104.874     0.200
     7.437   105.964     0.200
     7.855   111.153     0.200
     7.957   112.313     0.200
     8.015   112.744     0.200
     8.039   113.344     0.200
     8.155   115.424     0.200
     8.159   114.733     0.200
     8.196   114.164     0.200
     9.964   136.604     0.200
    10.683   148.054     0.200
    13.553   184.954     0.200
     1.495    26.421     0.200
     1.500    26.801     0.200
     1.499    26.392     0.200
     1.518    27.091     0.200
     1.519    27.201     0.200
     1.526    27.182     0.200
     1.538    27.321     0.200
     1.540    27.251     0.200
     1.705    29.581     0.200
     1.888    31.831     0.200
     1.942    32.611     0.200
     1.987    32.941     0.200
     1.993    33.291     0.200
     2.037    33.581     0.200
     2.050    33.911     0.200
     2.097    34.191     0.200
     2.244    35.161     0.200
     2.240    35.881     0.200
     2.372    38.081     0.200
     2.392    38.231     0.200
     2.424    38.682     0.200
     2.446    38.501     0.200
     2.456    38.691     0.200
     2.591    41.972     0.200
     2.603    40.671     0.200
     2.707    41.211     0.200
     2.902    45.691     0.200
     2.929    45.011     0.200
     3.031    46.341     0.200
     3.059    46.981     0.200
     3.031    45.591     0.200
     3.098    48.261     0.200
     3.170    48.461     0.200
     3.180    48.361     0.200
     3.257    50.041     0.200
     3.260    49.691     0.200
     3.453    51.852     0.200
     3.570    52.881     0.200
     3.578    54.392     0.200
     3.604    54.392     0.200
     3.629    54.301     0.200
     3.659    54.191     0.200
     3.691    54.411     0.200
     3.842    57.031     0.200
     3.864    57.812     0.200
     3.863    57.562     0.200
     4.010    59.991     0.200
     4.008    59.761     0.200
     4.038    60.371     0.200
     4.124    61.501     0.200
     4.203    62.321     0.200
     4.206    62.191     0.200
     4.305    64.491     0.200
     4.364    64.511     0.200
     4.407    65.281     0.200
     4.545    67.071     0.200
     4.800    70.791     0.200
     4.926    72.761     0.200
     4.976    74.121     0.200
     4.954    72.781     0.200
     5.050    74.331     0.200
     5.047    73.671     0.200
     5.088    75.411     0.200
     5.135    75.062     0.200
     5.185    75.791     0.200
     5.224    76.631     0.200
     5.243    76.491     0.200
     5.315    78.731     0.200
     5.292    77.852     0.200
     5.395    79.741     0.200
     5.736    84.091     0.200
     5.639    82.591     0.200
     5.938    86.251     0.200
     6.000    87.341     0.200
     6.115    89.011     0.200
     6.199    91.472     0.200
     6.223    91.801     0.200
     6.246    92.051     0.200
     6.331    90.972     0.200
     6.271    92.472     0.200
     6.319    93.451     0.200
     6.332    93.191     0.200
     6.401    94.062     0.200
     6.548    94.182     0.200
     6.550    94.621     0.200
     6.514    94.081     0.200
     6.619    96.261     0.200
     6.655    95.812     0.200
     6.755    97.031     0.200
     6.901    99.451     0.200
     6.895   100.451     0.200
     6.829   100.301     0.200
     6.967   100.191     0.200
     7.004    99.991     0.200
     7.005   100.722     0.200
     7.313   108.091     0.200
     7.907   112.341     0.200
     7.987   113.591     0.200
     8.825   122.791     0.200
     9.381   134.621     0.200
     9.818   137.941     0.200
    11.362   161.716     0.200
    12.968   182.591     0.200
    15.622   217.691     0.200
    18.638   256.171     0.200
    18.646   256.286     0.200
    19.176   264.291     0.200
    20.243   276.801     0.200
    20.290   277.921     0.200
    20.759   281.392     0.200
    20.791   284.991     0.200
     0.795    14.820     0.200
     0.830    15.027     0.200
     0.858    15.938     0.200
     0.852    15.418     0.200
     0.949    16.949     0.200
     0.970    17.258     0.200
     1.077    18.359     0.200
     1.124    19.578     0.200
     1.187    20.438     0.200
     1.193    20.457     0.200
     1.312    22.500     0.200
     1.349    22.578     0.200
     1.278    20.750     0.200
     1.313    21.629     0.200
     1.735    28.230     0.200
     1.825    29.508     0.200
     1.896    30.051     0.200
     2.103    32.801     0.200
     2.154    34.277     0.200
     2.177    34.770     0.200
     2.179    34.879     0.200
     2.180    34.777     0.200
     2.181    34.730     0.200
     2.197    35.027     0.200
     2.488    38.988     0.200
     2.505    38.430     0.200
     2.804    43.148     0.200
     2.851    44.027     0.200
     2.869    43.957     0.200
     2.890    44.438     0.200
     2.903    43.820     0.200
     2.938    45.250     0.200
     3.200    47.578     0.200
     3.290    49.957     0.200
     3.291    50.301     0.200
     3.368    51.367     0.200
     3.381    51.129     0.200
     3.401    51.508     0.200
     3.742    56.027     0.200
     3.835    56.629     0.200
     3.901    59.801     0.200
     3.949    56.938     0.200
     4.130    60.750     0.200
     4.307    63.988     0.200
     4.252    62.008     0.200
     4.344    64.348     0.200
     4.354    64.551     0.200
     4.322    63.949     0.200
     4.381    65.777     0.200
     4.324    64.680     0.200
     4.430    66.320     0.200
     4.439    65.828     0.200
     4.465    65.598     0.200
     4.505    66.230     0.200
     4.537    65.328     0.200
     4.651    67.867     0.200
     4.796    69.777     0.200
     4.770    68.828     0.200
     4.940    73.148     0.200
     4.871    69.867     0.200
     4.928    71.629     0.200
     5.021    72.730     0.200
     5.173    73.930     0.200
     5.298    75.840     0.200
     5.341    75.969     0.200
     5.421    80.910     0.200
     5.377    77.590     0.200
     5.503    77.910     0.200
     5.594    81.469     0.200
     5.650    82.051     0.200
     5.673    81.930     0.200
     5.640    80.570     0.200
     5.694    80.898     0.200
     5.789    82.598     0.200
     5.909    84.238     0.200
     5.904    84.641     0.200
     6.006    85.238     0.200
     6.086    86.480     0.200
     6.170    87.738     0.200
     6.394    90.668     0.200
     6.487    92.938     0.200
     6.706    96.789     0.200
     6.785    95.957     0.200
     6.850    98.520     0.200
     6.931    98.551     0.200
     6.939    97.898     0.200
     6.968    98.738     0.200
     7.058    99.629     0.200
     7.068   100.148     0.200
     7.360   103.859     0.200
     7.491   106.570     0.200
     7.515   105.520     0.200
     7.425   105.070     0.200
     7.632   109.648     0.200
     7.582   109.758     0.200
     7.825   110.668     0.200
     7.888   110.449     0.200
     8.101   112.891     0.200
     8.294   117.527     0.200
     8.299   115.770     0.200
     8.335   116.898     0.200
     8.403   116.527     0.200
     8.486   119.590     0.200
     8.720   123.188     0.200
     8.664   122.609     0.200
     8.807   125.527     0.200
     8.905   126.730     0.200
     9.344   131.277     0.200
    10.371   146.930     0.200
    11.170   154.301     0.200
    13.203   185.980     0.200
    14.590   201.730     0.200
    16.172   224.730     0.200
    20.598   276.457     0.200
     4.362    64.127     0.200
     4.269    62.327     0.200
     4.433    64.927     0.200
     4.516    64.527     0.200
     4.530    64.247     0.200
     5.020    71.787     0.200
     5.383    77.287     0.200
     6.161    89.057     0.200
     6.183    89.027     0.200
     7.057   100.957     0.200
     7.378   105.287     0.200
     8.294   117.327     0.200
     8.350   117.977     0.200
     9.125   129.397     0.200
     9.716   138.127     0.200
     9.611   133.627     0.200
     9.732   137.577     0.200
    11.188   158.437     0.200
    12.328   172.907     0.200
    12.328   173.502     0.200
    14.351   199.237     0.200
    14.351   199.727     0.200
    14.689   208.507     0.200
    15.136   214.077     0.200
    19.551   267.187     0.200
    19.769   268.626     0.200
    19.713   269.157     0.200
    20.544   278.307     0.200
    20.636   279.757     0.200
     4.337    64.413     0.200
     4.441    65.394     0.200
     4.479    63.764     0.200
     5.032    72.213     0.200
     5.210    74.644     0.200
     5.397    77.804     0.200
     6.139    88.813     0.200
     6.204    89.913     0.200
     7.062   100.213     0.200
     7.395   107.423     0.200
     8.275   115.253     0.200
     8.300   117.663     0.200
     8.359   118.413     0.200
     9.114   129.184     0.200
     9.759   138.644     0.200
    14.371   201.323     0.200
    14.371   201.463     0.200
     0.270    13.496     0.200
     0.472    15.074     0.200
     0.448    14.926     0.200
     0.499    15.023     0.200
     1.047    20.723     0.200
     1.164    21.164     0.200
     1.222    21.793     0.200
     1.346    24.496     0.200
     1.367    25.016     0.200
     1.675    28.766     0.200
     2.066    33.723     0.200
     2.120    34.453     0.200
     2.247    35.594     0.200
     2.533    38.965     0.200
     2.547    40.266     0.200
     2.571    40.605     0.200
     2.566    41.055     0.200
     2.645    41.793     0.200
     3.004    45.793     0.200
     3.275    49.105     0.200
     3.311    49.973     0.200
     3.369    51.496     0.200
     3.435    52.105     0.200
     3.860    56.625     0.200
     3.984    57.945     0.200
     4.033    59.152     0.200
     4.209    61.195     0.200
     4.252    62.246     0.200
     4.278    61.426     0.200
     4.431    63.785     0.200
     4.525    65.125     0.200
     4.510    64.902     0.200
     4.632    66.895     0.200
     4.721    67.273     0.200
     4.789    70.152     0.200
     4.816    70.824     0.200
     4.839    70.625     0.200
     4.747    69.266     0.200
     4.847    70.125     0.200
     4.873    71.543     0.200
     4.901    71.984     0.200
     5.019    72.465     0.200
     5.150    73.965     0.200
     5.208    75.113     0.200
     5.402    77.684     0.200
     5.532    79.105     0.200
     5.727    82.105     0.200
     5.800    83.914     0.200
     5.835    83.145     0.200
     6.041    87.246     0.200
     6.098    86.516     0.200
     6.250    88.844     0.200
     6.386    91.176     0.200
     6.567    93.594     0.200
     6.840    98.766     0.200
     6.978    99.586     0.200
     7.082   101.555     0.200
     7.148   101.355     0.200
     7.227   103.586     0.200
     7.286   103.145     0.200
     7.329   104.426     0.200
     7.481   104.324     0.200
     7.506   104.824     0.200
     7.545   107.113     0.200
     7.604   105.074     0.200
     7.658   108.555     0.200
     7.870   111.754     0.200
     7.957   113.523     0.200
     7.918   111.004     0.200
     8.012   113.285     0.200
     8.042   113.133     0.200
    12.936   180.449     0.200
    12.936   180.914     0.200
    13.842   189.676     0.200
     0.367    11.043     0.200
     0.392    11.203     0.200
     0.483    12.191     0.200
     0.529    12.594     0.200
     0.549    12.922     0.200
     0.706    14.723     0.200
     0.771    15.121     0.200
     0.761    14.992     0.200
     1.096    19.891     0.200
     1.149    19.094     0.200
     1.584    26.371     0.200
     2.254    35.383     0.200
     2.306    35.973     0.200
     2.343    36.480     0.200
     2.398    37.082     0.200
     2.690    40.730     0.200
     2.771    42.652     0.200
     2.783    42.934     0.200
     2.801    42.934     0.200
     2.870    43.941     0.200
     2.906    44.441     0.200
     3.252    48.383     0.200
     3.393    51.133     0.200
     3.452    51.434     0.200
     3.525    53.352     0.200
     3.535    53.293     0.200
     3.596    54.621     0.200
     3.975    58.820     0.200
     4.047    59.230     0.200
     4.072    60.211     0.200
     4.103    59.191     0.200
     4.142    61.312     0.200
     4.221    61.570     0.200
     4.371    64.082     0.200
     4.369    62.891     0.200
     4.584    65.992     0.200
     4.621    66.191     0.200
     4.652    68.273     0.200
     4.703    67.684     0.200
     4.702    69.082     0.200
     4.824    69.633     0.200
     4.789    70.242     0.200
     4.871    71.332     0.200
     5.007    73.152     0.200
     5.034    72.402     0.200
     5.064    73.922     0.200
     5.165    75.262     0.200
     5.267    75.051     0.200
     5.542    78.992     0.200
     6.298    89.543     0.200
     6.469    90.941     0.200
     6.519    92.031     0.200
     7.032   100.691     0.200
     7.512   104.523     0.200
     7.703   108.094     0.200
     7.733   109.531     0.200
     7.820   108.812     0.200
     7.820   108.691     0.200
     7.821   109.852     0.200
     8.102   113.941     0.200
     8.171   115.461     0.200
     8.203   115.852     0.200
     9.617   135.262     0.200
    12.971   182.117     0.200
    14.038   195.367     0.200
     0.793    14.828     0.200
     0.810    15.367     0.200
     0.810    15.107     0.200
     1.281    22.098     0.200
     1.537    25.857     0.200
     1.537    25.357     0.200
     1.574    26.748     0.200
     1.578    26.568     0.200
     1.619    27.248     0.200
     1.714    28.457     0.200
     1.706    28.588     0.200
     1.798    29.537     0.200
     1.823    29.498     0.200
     1.925    30.998     0.200
     1.972    31.857     0.200
     1.980    31.957     0.200
     1.968    31.578     0.200
     2.016    32.197     0.200
     2.037    32.637     0.200
     2.108    32.807     0.200
     2.099    32.217     0.200
     2.197    35.068     0.200
     2.352    36.568     0.200
     2.337    35.938     0.200
     2.394    36.797     0.200
     2.448    37.777     0.200
     2.457    38.098     0.200
     2.465    37.277     0.200
     2.868    43.188     0.200
     2.963    44.547     0.200
     2.963    44.617     0.200
     2.999    45.238     0.200
     2.985    45.777     0.200
     3.137    47.148     0.200
     3.284    48.967     0.200
     3.491    51.988     0.200
     3.491    51.598     0.200
     3.533    52.047     0.200
     3.596    53.398     0.200
     3.672    54.148     0.200
     3.674    54.027     0.200
     3.736    55.127     0.200
     3.876    57.248     0.200
     4.013    59.518     0.200
     4.038    59.387     0.200
     4.120    61.238     0.200
     4.203    63.027     0.200
     4.248    62.527     0.200
     4.376    64.018     0.200
     4.649    69.057     0.200
     4.818    70.748     0.200
     4.966    72.098     0.200
     5.011    72.398     0.200
     5.210    75.258     0.200
     5.245    76.318     0.200
     5.326    77.498     0.200
     5.350    77.547     0.200
     5.548    80.318     0.200
     5.625    81.307     0.200
     5.764    83.857     0.200
     5.800    85.068     0.200
     5.814    83.807     0.200
     6.342    91.668     0.200
     6.395    91.998     0.200
     6.442    91.967     0.200
     6.470    93.148     0.200
     6.492    93.738     0.200
     6.505    94.229     0.200
     6.531    94.088     0.200
     6.639    94.297     0.200
     6.852    96.967     0.200
     6.881    97.947     0.200
     6.881    97.398     0.200
     7.018   100.428     0.200
     7.843   110.898     0.200
     7.923   112.068     0.200
     8.200   116.068     0.200
     8.672   120.348     0.200
     9.222   131.068     0.200
     9.554   134.688     0.200
     9.697   135.887     0.200
    10.685   152.197     0.200
    11.210   156.328     0.200
    11.196   158.543     0.200
    11.196   157.818     0.200
    12.819   178.018     0.200
    12.819   179.447     0.200
    14.537   202.443     0.200
    15.790   218.777     0.200
    19.054   260.707     0.200
    19.752   270.467     0.200
    20.091   272.568     0.200
    20.120   273.297     0.200
    20.671   279.518     0.200
     0.528    12.064     0.200
     0.522    11.805     0.200
     0.578    12.453     0.200
     0.759    14.654     0.200
     0.894    16.793     0.200
     1.003    17.844     0.200
     1.123    19.834     0.200
     1.143    20.465     0.200
     1.094    18.984     0.200
     1.170    20.613     0.200
     1.160    20.094     0.200
     1.104    19.254     0.200
     1.186    20.584     0.200
     1.275    21.914     0.200
     1.616    26.715     0.200
     1.616    27.475     0.200
     1.733    28.164     0.200
     1.793    28.504     0.200
     1.836    29.244     0.200
     1.857    29.504     0.200
     1.914    30.434     0.200
     2.275    35.684     0.200
     2.377    36.895     0.200
     2.653    39.475     0.200
     2.715    40.914     0.200
     2.880    43.805     0.200
     2.962    44.164     0.200
     3.014    45.693     0.200
     3.074    46.914     0.200
     3.161    47.174     0.200
     3.294    49.873     0.200
     3.334    49.273     0.200
     3.511    52.014     0.200
     3.578    52.574     0.200
     3.707    54.725     0.200
     3.792    56.443     0.200
     3.917    56.854     0.200
     3.956    57.484     0.200
     4.003    57.934     0.200
     4.013    58.475     0.200
     4.044    58.004     0.200
     4.122    60.014     0.200
     4.309    62.635     0.200
     4.343    62.555     0.200
     4.414    63.395     0.200
     4.416    64.234     0.200
     4.625    67.135     0.200
     4.711    67.953     0.200
     4.873    70.484     0.200
     4.911    71.154     0.200
     5.109    73.135     0.200
     4.984    72.754     0.200
     4.998    73.064     0.200
     5.197    75.314     0.200
     5.415    77.373     0.200
     5.445    78.064     0.200
     5.614    80.725     0.200
     5.528    80.084     0.200
     5.678    81.283     0.200
     5.639    81.645     0.200
     5.805    83.113     0.200
     5.738    81.744     0.200
     5.878    84.254     0.200
     6.054    86.564     0.200
     6.131    87.434     0.200
     6.427    92.414     0.200
     6.565    94.164     0.200
     6.585    95.014     0.200
     6.653    93.793     0.200
     6.865    96.914     0.200
     6.917    96.984     0.200
     6.916    98.564     0.200
     6.985    99.145     0.200
     7.118    99.914     0.200
     7.137   100.854     0.200
     7.200   101.453     0.200
     7.199   101.154     0.200
     7.227   102.453     0.200
     7.367   105.055     0.200
     7.789   110.254     0.200
     7.873   111.953     0.200
     8.210   117.314     0.200
     8.823   124.443     0.200
     8.696   122.154     0.200
     9.575   134.264     0.200
     9.581   135.055     0.200
     9.992   138.975     0.200
    10.126   143.764     0.200
    10.348   144.805     0.200
    12.107   170.004     0.200
    12.107   169.805     0.200
    13.322   185.430     0.200
    13.322   184.754     0.200
    19.289   260.449     0.200
     0.642    13.441     0.200
     0.682    13.598     0.200
     0.726    14.781     0.200
     0.733    14.410     0.200
     0.764    15.059     0.200
     0.779    15.398     0.200
     0.780    15.090     0.200
     0.833    15.789     0.200
     0.897    16.598     0.200
     1.017    18.488     0.200
     0.968    18.168     0.200
     0.976    17.801     0.200
     1.184    20.621     0.200
     1.324    22.660     0.200
     1.450    24.781     0.200
     1.478    25.398     0.200
     1.483    25.309     0.200
     1.497    25.449     0.200
     1.780    29.230     0.200
     1.889    30.398     0.200
     2.095    33.141     0.200
     2.191    34.520     0.200
     2.226    34.910     0.200
     2.395    36.660     0.200
     2.500    39.430     0.200
     2.578    40.059     0.200
     2.622    40.480     0.200
     2.654    41.051     0.200
     2.757    42.500     0.200
     2.772    42.371     0.200
     3.141    46.031     0.200
     3.188    47.309     0.200
     3.271    49.500     0.200
     3.355    50.508     0.200
     3.405    50.820     0.200
     3.446    50.691     0.200
     3.446    51.820     0.200
     3.751    56.051     0.200
     3.801    55.699     0.200
     3.867    57.391     0.200
     3.978    58.180     0.200
     4.169    61.090     0.200
     4.244    61.930     0.200
     4.382    63.070     0.200
     4.433    63.898     0.200
     4.489    64.281     0.200
     4.500    65.078     0.200
     4.587    66.238     0.200
     4.503    65.961     0.200
     4.781    69.301     0.200
     4.833    69.301     0.200
     4.845    70.398     0.200
     4.900    70.219     0.200
     5.106    73.289     0.200
     5.146    74.918     0.200
     5.067    73.750     0.200
     5.200    74.359     0.200
     5.102    74.070     0.200
     5.362    76.848     0.200
     5.264    76.430     0.200
     5.488    79.328     0.200
     5.596    79.848     0.200
     5.825    84.180     0.200
     5.841    84.660     0.200
     6.076    86.719     0.200
     6.166    87.840     0.200
     6.285    90.289     0.200
     6.309    90.898     0.200
     6.533    92.410     0.200
     6.612    94.289     0.200
     6.629    94.059     0.200
     7.044   100.480     0.200
     7.051   101.098     0.200
     7.312   103.078     0.200
     7.350   103.469     0.200
     7.548   106.621     0.200
     7.642   106.816     0.200
     7.673   107.711     0.200
     7.856   111.570     0.200
     8.114   115.020     0.200
     8.199   116.320     0.200
     8.707   124.668     0.200
     9.311   130.848     0.200
    10.042   141.488     0.200
    10.179   144.910     0.200
    12.527   175.395     0.200
    12.527   176.969     0.200
    13.795   190.918     0.200
    13.795   190.680     0.200
     0.072    11.801     0.200
     0.169    12.168     0.200
     0.244    12.391     0.200
     0.289    12.660     0.200
     0.277    12.730     0.200
     0.357    13.328     0.200
     0.387    13.328     0.200
     0.410    13.809     0.200
     0.429    14.090     0.200
     1.249    21.680     0.200
     1.467    26.020     0.200
     1.486    26.008     0.200
     2.123    34.359     0.200
     2.172    34.211     0.200
     2.176    35.102     0.200
     2.216    35.648     0.200
     2.264    34.969     0.200
     2.364    37.148     0.200
     2.605    41.191     0.200
     2.650    40.559     0.200
     2.641    41.559     0.200
     2.679    42.398     0.200
     2.782    42.980     0.200
     3.047    45.238     0.200
     3.260    49.500     0.200
     3.361    51.008     0.200
     3.388    50.520     0.200
     3.437    50.270     0.200
     3.405    50.898     0.200
     3.699    54.852     0.200
     3.887    58.070     0.200
     3.970    58.301     0.200
     3.964    59.121     0.200
     4.103    59.680     0.200
     4.160    59.230     0.200
     4.237    62.602     0.200
     4.325    62.590     0.200
     4.539    65.449     0.200
     4.628    66.250     0.200
     4.627    68.121     0.200
     4.695    68.551     0.200
     4.742    68.211     0.200
     4.753    69.809     0.200
     4.782    70.230     0.200
     4.838    68.730     0.200
     4.866    70.441     0.200
     4.871    71.691     0.200
     4.886    71.461     0.200
     4.861    71.430     0.200
     4.958    71.031     0.200
     5.034    71.480     0.200
     5.043    73.879     0.200
     5.137    73.969     0.200
     5.165    75.668     0.200
     5.268    75.480     0.200
     5.270    75.320     0.200
     5.287    75.680     0.200
     5.257    77.621     0.200
     5.321    75.828     0.200
     5.531    79.668     0.200
     5.649    80.852     0.200
     5.704    81.828     0.200
     5.750    83.391     0.200
     5.801    83.391     0.200
     5.818    83.461     0.200
     5.883    84.418     0.200
     6.157    89.469     0.200
     6.204    87.859     0.200
     6.345    90.008     0.200
     6.505    92.602     0.200
     6.554    93.980     0.200
     6.675    95.289     0.200
     6.686    95.238     0.200
     6.728    96.508     0.200
     6.948    99.828     0.200
     7.001    99.289     0.200
     7.068    98.879     0.200
     7.346   104.660     0.200
     7.313   104.539     0.200
     7.345   105.371     0.200
     7.350   105.379     0.200
     7.386   103.469     0.200
     7.448   106.270     0.200
     7.575   106.730     0.200
     7.702   106.680     0.200
     7.799   109.719     0.200
     7.933   112.430     0.200
     8.020   112.828     0.200
     8.128   115.078     0.200
     8.159   114.988     0.200
     8.218   117.629     0.200
     9.567   134.539     0.200
    10.496   147.570     0.200
    13.050   182.781     0.200
    13.462   185.941     0.200
    13.948   191.980     0.200
    13.948   193.559     0.200
     0.403    11.588     0.200
     0.632    13.457     0.200
     0.671    14.258     0.200
     0.689    14.807     0.200
     0.696    14.838     0.200
     0.710    14.906     0.200
     0.797    15.477     0.200
     0.835    16.207     0.200
     0.916    16.816     0.200
     0.971    17.518     0.200
     0.975    18.217     0.200
     0.950    17.627     0.200
     1.070    19.877     0.200
     1.193    20.396     0.200
     1.239    21.338     0.200
     1.250    22.287     0.200
     1.300    22.547     0.200
     1.325    22.656     0.200
     1.332    22.877     0.200
     1.341    22.758     0.200
     1.383    23.227     0.200
     1.384    23.207     0.200
     1.406    23.486     0.200
     1.424    23.957     0.200
     1.497    24.707     0.200
     1.592    26.146     0.200
     1.798    29.137     0.200
     1.828    29.477     0.200
     1.849    29.787     0.200
     1.890    30.457     0.200
     1.931    30.947     0.200
     2.284    37.178     0.200
     2.361    36.246     0.200
     2.370    35.768     0.200
     2.556    39.928     0.200
     2.568    38.607     0.200
     2.572    39.896     0.200
     2.597    40.547     0.200
     2.618    40.627     0.200
     2.631    40.768     0.200
     2.642    41.188     0.200
     2.697    41.547     0.200
     2.697    42.297     0.200
     2.716    40.906     0.200
     2.902    44.557     0.200
     2.908    44.867     0.200
     2.965    44.887     0.200
     3.034    45.137     0.200
     3.243    49.127     0.200
     3.397    51.027     0.200
     3.544    51.916     0.200
     3.748    55.146     0.200
     3.772    54.197     0.200
     3.796    55.688     0.200
     3.949    57.646     0.200
     3.964    56.656     0.200
     3.997    58.848     0.200
     4.071    58.797     0.200
     4.200    60.627     0.200
     4.221    60.967     0.200
     4.289    62.646     0.200
     4.467    65.678     0.200
     4.452    64.447     0.200
     4.640    67.246     0.200
     4.983    72.646     0.200
     5.006    72.508     0.200
     5.106    74.508     0.200
     5.213    76.197     0.200
     5.434    77.588     0.200
     5.461    79.018     0.200
     5.630    81.406     0.200
     5.694    82.727     0.200
     5.710    81.717     0.200
     5.785    82.967     0.200
     5.823    83.438     0.200
     5.853    85.496     0.200
     5.933    84.537     0.200
     5.953    85.287     0.200
     6.283    89.697     0.200
     6.326    92.537     0.200
     6.338    91.137     0.200
     6.463    92.008     0.200
     6.473    91.996     0.200
     6.502    92.098     0.200
     6.640    94.857     0.200
     6.700    94.816     0.200
     6.714    94.977     0.200
     6.793    96.178     0.200
     7.073   100.916     0.200
     7.137   100.646     0.200
     7.335   104.457     0.200
     7.419   105.928     0.200
     8.682   121.816     0.200
     8.865   124.047     0.200
     8.871   124.127     0.200
     9.448   132.877     0.200
     9.576   132.857     0.200
     9.748   137.227     0.200
    12.062   169.027     0.200
    12.062   168.758     0.200
    12.961   180.002     0.200
    12.961   179.338     0.200
     0.446     9.461     0.200
     0.527    10.672     0.200
     1.256    21.734     0.200
     1.288    21.812     0.200
     1.346    22.812     0.200
     1.351    22.992     0.200
     1.367    23.336     0.200
     1.368    23.305     0.200
     1.366    22.953     0.200
     1.375    23.406     0.200
     1.378    23.297     0.200
     1.388    23.641     0.200
     1.388    23.406     0.200
     1.463    24.562     0.200
     1.577    25.906     0.200
     1.635    26.375     0.200
     1.662    26.734     0.200
     1.670    26.922     0.200
     1.752    28.273     0.200
     1.873    30.305     0.200
     1.932    30.414     0.200
     1.936    30.562     0.200
     1.942    30.703     0.200
     1.942    30.516     0.200
     2.051    32.977     0.200
     2.048    32.250     0.200
     2.289    35.523     0.200
     2.312    36.055     0.200
     2.311    35.234     0.200
     2.341    36.430     0.200
     2.403    37.250     0.200
     2.412    37.211     0.200
     2.479    37.656     0.200
     2.657    40.062     0.200
     2.906    44.680     0.200
     2.979    44.305     0.200
     3.023    45.461     0.200
     3.067    46.383     0.200
     3.106    46.883     0.200
     3.109    46.703     0.200
     3.414    50.320     0.200
     3.575    52.773     0.200
     3.613    53.875     0.200
     3.894    56.961     0.200
     3.970    58.023     0.200
     4.053    59.781     0.200
     4.107    60.016     0.200
     4.309    63.242     0.200
     4.326    63.156     0.200
     5.061    74.352     0.200
     5.108    73.523     0.200
     5.128    73.625     0.200
     5.324    77.023     0.200
     5.386    77.883     0.200
     5.436    78.461     0.200
     5.467    79.297     0.200
     5.687    80.891     0.200
     5.738    82.641     0.200
     5.758    83.133     0.200
     6.051    87.164     0.200
     6.078    87.695     0.200
     6.149    88.742     0.200
     6.236    89.227     0.200
     6.256    91.227     0.200
     6.529    92.461     0.200
     6.691    95.344     0.200
     6.764    95.805     0.200
     6.870    98.133     0.200
     6.957   100.227     0.200
     6.973    98.820     0.200
     6.994   100.523     0.200
     7.006    99.492     0.200
     7.022    99.477     0.200
     7.022    99.477     0.200
     7.145   102.633     0.200
     7.843   110.422     0.200
     7.924   113.320     0.200
     8.458   119.250     0.200
     9.063   128.312     0.200
     9.088   126.594     0.200
     9.833   136.672     0.200
    11.552   164.102     0.200
    11.552   160.375     0.200
    13.035   181.922     0.200
    13.035   181.500     0.200
    18.801   256.523     0.200
     0.899    16.508     0.200
     1.111    19.289     0.200
     1.196    20.883     0.200
     1.212    21.133     0.200
     1.293    22.172     0.200
     1.396    23.594     0.200
     2.086    33.539     0.200
     2.109    33.969     0.200
     2.112    33.820     0.200
     2.113    33.984     0.200
     2.116    34.023     0.200
     2.131    34.078     0.200
     2.147    33.820     0.200
     2.488    38.461     0.200
     2.547    39.930     0.200
     2.749    41.945     0.200
     2.784    42.914     0.200
     2.827    43.305     0.200
     3.265    49.344     0.200
     3.298    50.141     0.200
     3.421    51.258     0.200
     3.793    57.789     0.200
     3.779    54.719     0.200
     3.845    55.742     0.200
     3.857    57.180     0.200
     4.030    59.672     0.200
     4.054    59.734     0.200
     4.093    59.648     0.200
     4.253    62.648     0.200
     4.390    64.305     0.200
     4.413    65.203     0.200
     4.461    64.680     0.200
     4.591    70.570     0.200
     5.043    72.602     0.200
     5.099    73.633     0.200
     5.162    73.320     0.200
     5.248    75.148     0.200
     5.315    75.344     0.200
     5.496    78.602     0.200
     5.609    80.008     0.200
     5.682    82.414     0.200
     5.758    82.281     0.200
     5.820    83.320     0.200
     5.875    84.594     0.200
     5.994    85.594     0.200
     6.195    88.000     0.200
     6.476    92.625     0.200
     6.485    92.820     0.200
     6.539    94.305     0.200
     6.626    95.305     0.200
     6.737    95.625     0.200
     6.775    96.484     0.200
     6.837    98.641     0.200
     6.856    98.172     0.200
     6.967    99.609     0.200
     7.187   102.070     0.200
     7.191   102.555     0.200
     7.282   103.023     0.200
     7.447   106.719     0.200
     7.568   108.383     0.200
     7.610   108.734     0.200
     7.728   110.234     0.200
     7.796   109.180     0.200
     7.831   111.523     0.200
     8.009   111.891     0.200
     8.118   115.148     0.200
     8.205   114.883     0.200
     8.205   114.703     0.200
     8.216   114.773     0.200
     8.161   115.320     0.200
     8.303   115.969     0.200
     8.302   115.852     0.200
     7.973   116.484     0.200
     8.712   123.250     0.200
     8.798   124.023     0.200
     9.949   140.031     0.200
    10.135   141.273     0.200
    10.305   145.000     0.200
    10.415   148.062     0.200
    10.510   149.594     0.200
    10.560   148.102     0.200
    11.082   153.453     0.200
    12.953   183.305     0.200
    12.953   182.523     0.200
    14.453   199.875     0.200
    14.453   199.641     0.200
     0.846    16.141     0.200
     0.864    16.451     0.200
     0.929    17.150     0.200
     0.938    17.230     0.200
     1.475    24.811     0.200
     1.555    25.270     0.200
     1.610    26.121     0.200
     2.342    36.600     0.200
     2.364    37.791     0.200
     2.368    37.410     0.200
     2.673    41.621     0.200
     2.924    45.381     0.200
     3.067    46.561     0.200
     3.082    47.090     0.200
     3.145    47.410     0.200
     3.513    53.230     0.200
     3.904    57.320     0.200
     4.199    60.541     0.200
     4.217    61.311     0.200
     4.272    63.371     0.200
     4.312    63.451     0.200
     4.153    61.760     0.200
     4.646    68.580     0.200
     4.819    69.730     0.200
     5.561    79.400     0.200
     5.599    79.670     0.200
     5.729    82.920     0.200
     5.804    83.270     0.200
     5.961    84.570     0.200
     6.043    85.951     0.200
     6.145    87.471     0.200
     6.421    91.391     0.200
     6.658    94.631     0.200
     6.717    96.260     0.200
     7.604   108.400     0.200
     7.669   108.500     0.200
     8.078   112.430     0.200
     8.292   115.660     0.200
     8.483   118.410     0.200
     8.601   120.170     0.200
     8.601   119.570     0.200
     8.677   121.400     0.200
     8.836   124.430     0.200
    10.366   145.531     0.200
    11.356   155.510     0.200
    13.478   189.996     0.200
    14.813   203.945     0.200
    14.813   205.451     0.200
     1.480    24.746     0.200
     2.055    32.168     0.200
     2.269    35.758     0.200
     2.897    44.418     0.200
     2.912    45.457     0.200
     3.459    52.785     0.200
     3.471    51.855     0.200
     3.671    54.305     0.200
     3.821    56.957     0.200
     4.043    59.355     0.200
     4.278    63.246     0.200
     4.587    68.285     0.200
     5.163    75.797     0.200
     5.240    76.984     0.200
     5.551    81.355     0.200
     5.578    80.977     0.200
     5.775    84.656     0.200
     5.787    83.656     0.200
     6.385    91.777     0.200
     6.782    96.875     0.200
     7.827   111.555     0.200
     8.178   116.285     0.200
     8.438   119.457     0.200
     8.747   122.457     0.200
     8.942   126.078     0.200
     9.000   129.055     0.200
     9.519   134.227     0.200
    10.570   150.395     0.200
    10.437   145.387     0.200
    10.504   147.527     0.200
    11.174   156.676     0.200
    11.253   160.133     0.200
    11.253   159.285     0.200
     1.256    21.840     0.200
     2.860    45.504     0.200
     3.059    44.805     0.200
     3.932    59.344     0.200
     4.221    61.965     0.200
     4.411    63.445     0.200
     4.771    70.426     0.200
     4.851    71.566     0.200
     5.428    77.965     0.200
     5.501    79.895     0.200
     5.499    79.227     0.200
     5.783    83.465     0.200
     5.909    85.164     0.200
     6.168    87.016     0.200
     6.197    89.336     0.200
     6.385    92.637     0.200
     6.572    95.016     0.200
     6.594    95.164     0.200
     7.055   101.625     0.200
     7.103   102.246     0.200
     7.370   105.805     0.200
     7.481   107.266     0.200
     7.461   108.566     0.200
     7.713   108.555     0.200
     7.643   108.785     0.200
     7.818   112.145     0.200
     7.914   113.164     0.200
     8.224   115.227     0.200
     8.454   120.246     0.200
     8.609   122.316     0.200
     8.717   123.164     0.200
     8.767   123.664     0.200
     9.097   131.285     0.200
     9.509   133.316     0.200
     9.482   134.016     0.200
     9.669   135.566     0.200
     9.782   138.605     0.200
    10.058   143.434     0.200
    10.077   143.504     0.200
    11.564   163.066     0.200
    11.793   165.105     0.200
    12.448   176.965     0.200
    14.729   206.266     0.200
    14.729   205.887     0.200
     0.708    14.566     0.200
     0.708    13.641     0.200
     0.824    16.141     0.200
     1.164    21.230     0.200
     1.165    21.430     0.200
     1.203    21.762     0.200
     1.205    21.691     0.200
     1.213    21.941     0.200
     1.226    21.672     0.200
     1.377    23.980     0.200
     1.381    22.062     0.200
     1.601    26.160     0.200
     1.671    27.582     0.200
     1.723    28.129     0.200
     1.720    28.082     0.200
     1.734    28.320     0.200
     1.950    30.742     0.200
     2.034    32.371     0.200
     2.075    33.082     0.200
     2.127    33.582     0.200
     2.143    33.102     0.200
     2.284    35.242     0.200
     2.310    35.520     0.200
     2.506    38.352     0.200
     2.655    40.430     0.200
     2.784    42.391     0.200
     2.905    44.340     0.200
     2.913    43.641     0.200
     2.944    44.969     0.200
     3.084    46.582     0.200
     3.116    46.672     0.200
     3.119    46.441     0.200
     3.224    48.141     0.200
     3.494    51.340     0.200
     3.575    52.750     0.200
     3.574    52.492     0.200
     3.626    54.070     0.200
     3.661    53.320     0.200
     3.848    56.480     0.200
     3.865    56.641     0.200
     3.958    58.191     0.200
     4.059    58.242     0.200
     4.149    61.039     0.200
     4.167    61.102     0.200
     4.199    61.992     0.200
     4.347    63.789     0.200
     4.452    66.230     0.200
     4.487    65.230     0.200
     4.468    65.789     0.200
     4.512    65.961     0.200
     4.546    66.141     0.200
     4.602    65.949     0.200
     4.692    68.160     0.200
     4.832    70.141     0.200
     4.903    70.691     0.200
     4.923    70.840     0.200
     4.919    71.340     0.200
     5.114    73.922     0.200
     5.105    73.781     0.200
     5.194    75.070     0.200
     5.232    75.141     0.200
     5.261    76.301     0.200
     5.397    78.180     0.200
     5.478    79.332     0.200
     5.532    79.242     0.200
     5.556    80.242     0.200
     5.561    79.461     0.200
     5.582    80.340     0.200
     6.093    87.340     0.200
     6.487    93.539     0.200
     6.511    93.312     0.200
     6.639    94.762     0.200
     6.769    95.340     0.200
     6.822    96.691     0.200
     8.203   115.801     0.200
     8.304   117.602     0.200
     8.699   123.441     0.200
     8.764   123.379     0.200
     8.874   123.359     0.200
     9.041   125.340     0.200
     9.283   129.109     0.200
    10.316   146.582     0.200
    10.738   147.262     0.200
    10.799   149.949     0.200
    10.895   153.961     0.200
    11.526   162.566     0.200
    11.526   162.031     0.200
    12.160   167.230     0.200
    12.160   167.230     0.200
    12.858   179.141     0.200
    12.858   178.340     0.200
    14.935   207.090     0.200
    18.708   253.984     0.200
    19.920   268.672     0.200
    20.097   270.410     0.200
    20.274   272.719     0.200
    20.494   275.199     0.200
     0.760    14.128     0.200
     0.904    16.468     0.200
     0.934    16.508     0.200
     0.950    17.048     0.200
     1.098    19.318     0.200
     1.128    19.498     0.200
     1.200    20.798     0.200
     1.471    24.368     0.200
     1.473    24.438     0.200
     2.051    33.028     0.200
     2.056    33.438     0.200
     2.058    33.298     0.200
     2.027    31.688     0.200
     2.040    32.378     0.200
     2.067    32.418     0.200
     2.359    37.358     0.200
     2.391    35.948     0.200
     2.727    41.668     0.200
     2.763    42.738     0.200
     2.775    43.118     0.200
     2.798    43.188     0.200
     2.804    43.268     0.200
     2.965    43.298     0.200
     3.047    45.458     0.200
     3.253    49.788     0.200
     3.276    49.928     0.200
     3.339    50.708     0.200
     3.740    55.408     0.200
     3.969    59.128     0.200
     3.884    56.668     0.200
     3.999    59.308     0.200
     4.026    60.168     0.200
     4.078    59.338     0.200
     4.109    60.838     0.200
     4.334    63.888     0.200
     4.390    64.508     0.200
     4.446    64.708     0.200
     4.512    66.038     0.200
     4.506    65.728     0.200
     4.553    66.098     0.200
     4.658    67.848     0.200
     4.772    68.308     0.200
     4.838    70.218     0.200
     4.848    69.788     0.200
     4.884    70.048     0.200
     5.026    72.008     0.200
     4.950    70.658     0.200
     5.084    72.738     0.200
     5.428    77.508     0.200
     5.567    80.508     0.200
     5.539    78.708     0.200
     5.635    81.478     0.200
     5.633    80.248     0.200
     5.574    79.658     0.200
     5.758    82.408     0.200
     6.014    85.838     0.200
     6.188    87.718     0.200
     6.237    88.368     0.200
     6.371    90.348     0.200
     6.505    91.898     0.200
     6.598    93.528     0.200
     6.647    94.008     0.200
     6.715    95.318     0.200
     6.772    95.498     0.200
     6.851    96.868     0.200
     6.933    98.308     0.200
     7.075   100.208     0.200
     7.150   101.388     0.200
     7.191   101.728     0.200
     7.451   106.128     0.200
     7.483   106.128     0.200
     7.558   106.968     0.200
     7.578   107.248     0.200
     7.670   108.158     0.200
     7.752   108.788     0.200
     7.737   110.078     0.200
     7.965   111.368     0.200
     7.883   110.308     0.200
     8.160   114.008     0.200
     8.167   114.278     0.200
     8.265   115.808     0.200
     8.265   115.408     0.200
     8.509   120.158     0.200
     8.618   122.058     0.200
     9.408   131.608     0.200
     9.815   138.168     0.200
    10.284   144.018     0.200
    10.355   147.638     0.200
    10.550   148.368     0.200
    13.058   183.658     0.200
    13.058   182.883     0.200
    14.442   201.918     0.200
    14.442   199.358     0.200
     1.641    27.320     0.200
     1.689    28.055     0.200
     1.791    30.008     0.200
     1.812    29.867     0.200
     1.842    30.367     0.200
     1.840    30.719     0.200
     2.108    33.766     0.200
     2.436    38.477     0.200
     2.497    39.391     0.200
     2.494    39.508     0.200
     2.734    44.008     0.200
     2.741    43.828     0.200
     2.749    43.961     0.200
     3.032    47.805     0.200
     3.473    52.680     0.200
     3.866    59.086     0.200
     4.000    60.750     0.200
     4.137    60.938     0.200
     4.507    67.508     0.200
     4.573    68.227     0.200
     4.626    69.047     0.200
     4.636    69.398     0.200
     4.688    70.008     0.200
     4.917    72.000     0.200
     4.969    73.938     0.200
     5.499    78.898     0.200
     5.720    82.609     0.200
     5.873    86.094     0.200
     5.910    85.688     0.200
     6.100    87.773     0.200
     6.137    88.898     0.200
     6.324    93.523     0.200
     6.421    92.625     0.200
     6.392    93.398     0.200
     7.044   101.867     0.200
     7.501   109.117     0.200
     7.585   108.898     0.200
     8.512   124.328     0.200
    10.200   145.617     0.200
    14.861   207.836     0.200
    20.403   276.508     0.200
     0.298     7.648     0.200
     0.298     8.348     0.200
     0.513    10.340     0.200
     1.061    17.848     0.200
     1.116    18.859     0.200
     1.105    18.660     0.200
     1.176    19.777     0.200
     1.210    20.699     0.200
     1.269    21.438     0.200
     1.560    25.168     0.200
     1.658    27.438     0.200
     1.666    27.680     0.200
     1.932    31.129     0.200
     2.087    33.379     0.200
     2.298    36.199     0.200
     2.751    42.328     0.200
     2.883    43.840     0.200
     2.854    42.969     0.200
     2.859    43.949     0.200
     2.947    44.227     0.200
     3.054    44.820     0.200
     3.167    46.848     0.200
     3.223    47.457     0.200
     3.504    52.180     0.200
     3.509    52.168     0.200
     3.568    53.570     0.200
     3.605    53.320     0.200
     3.631    54.789     0.200
     3.841    57.258     0.200
     3.943    57.070     0.200
     4.375    62.840     0.200
     4.739    67.938     0.200
     4.757    69.297     0.200
     4.713    67.820     0.200
     4.868    70.020     0.200
     5.074    72.938     0.200
     5.208    75.500     0.200
     5.391    77.848     0.200
     5.911    84.180     0.200
     6.052    86.457     0.200
     6.074    86.508     0.200
     6.160    88.629     0.200
     6.366    91.148     0.200
     6.375    90.977     0.200
     6.430    91.590     0.200
     6.487    92.609     0.200
     6.741    96.258     0.200
     6.831    97.879     0.200
     7.005   100.238     0.200
     7.192   101.277     0.200
     7.402   103.789     0.200
     7.416   107.879     0.200
     7.415   104.918     0.200
     7.605   106.648     0.200
     7.679   108.000     0.200
     7.753   110.449     0.200
     8.292   117.297     0.200
     8.578   121.629     0.200
     9.111   128.938     0.200
     9.215   130.078     0.200
     9.453   133.168     0.200
     9.631   134.438     0.200
     9.806   138.027     0.200
    12.234   171.598     0.200
    13.761   190.797     0.200
     0.074    19.410     0.200
     0.315    19.742     0.200
     0.346    20.133     0.200
     0.377    20.352     0.200
     0.670    21.980     0.200
     0.690    22.031     0.200
     0.774    22.473     0.200
     1.132    25.891     0.200
     1.136    26.160     0.200
     1.139    26.152     0.200
     1.151    26.270     0.200
     1.158    26.383     0.200
     1.418    28.930     0.200
     1.606    29.492     0.200
     1.733    30.750     0.200
     1.761    32.613     0.200
     1.829    33.582     0.200
     2.197    37.762     0.200
     2.234    38.141     0.200
     2.324    39.211     0.200
     2.347    39.711     0.200
     2.408    39.660     0.200
     2.465    39.961     0.200
     2.476    40.922     0.200
     2.930    46.891     0.200
     2.934    45.562     0.200
     2.975    47.793     0.200
     2.989    47.270     0.200
     3.265    50.113     0.200
     3.255    51.121     0.200
     3.315    52.281     0.200
     3.351    51.953     0.200
     3.454    53.723     0.200
     3.512    53.562     0.200
     3.592    54.961     0.200
     3.672    55.492     0.200
     3.804    57.863     0.200
     4.222    61.430     0.200
     4.304    64.543     0.200
     4.401    64.090     0.200
     4.480    65.953     0.200
     4.512    67.781     0.200
     4.619    67.973     0.200
     4.652    67.152     0.200
     5.094    74.590     0.200
     5.145    74.730     0.200
     5.275    76.930     0.200
     5.341    77.590     0.200
     5.373    77.422     0.200
     5.370    77.453     0.200
     5.434    78.371     0.200
     5.436    79.562     0.200
     5.613    81.270     0.200
     5.849    83.250     0.200
     5.926    84.680     0.200
     5.920    85.961     0.200
     6.212    89.652     0.200
     6.425    92.652     0.200
     6.622    93.320     0.200
     6.672    95.152     0.200
     6.744    95.062     0.200
     6.750    94.441     0.200
     6.849    97.602     0.200
     6.884    98.281     0.200
     6.964    97.320     0.200
     6.986    98.102     0.200
     7.057   100.883     0.200
     7.097   101.340     0.200
     7.134    99.582     0.200
     7.145    99.793     0.200
     7.213   103.062     0.200
     7.293   101.590     0.200
     7.293   101.590     0.200
     7.343   103.582     0.200
     7.401   104.992     0.200
     7.488   106.883     0.200
     7.884   111.992     0.200
     7.935   112.180     0.200
     7.937   111.891     0.200
     8.162   115.652     0.200
     8.907   123.301     0.200
     9.040   125.180     0.200
    13.100   181.980     0.200
     0.523    12.730     0.200
     0.713    15.199     0.200
     0.761    15.887     0.200
     0.760    15.547     0.200
     0.937    17.559     0.200
     1.033    19.328     0.200
     0.958    17.660     0.200
     0.987    17.938     0.200
     1.077    19.980     0.200
     1.179    20.828     0.200
     1.344    23.090     0.200
     1.268    21.809     0.200
     1.359    24.000     0.200
     1.417    24.270     0.200
     1.407    23.480     0.200
     1.707    27.547     0.200
     1.887    30.699     0.200
     1.955    31.527     0.200
     2.002    32.047     0.200
     2.013    32.039     0.200
     2.470    38.020     0.200
     2.487    37.457     0.200
     2.630    40.820     0.200
     2.647    40.969     0.200
     2.689    41.758     0.200
     2.691    41.809     0.200
     2.724    41.520     0.200
     2.982    45.707     0.200
     3.134    47.750     0.200
     3.137    46.719     0.200
     3.386    49.867     0.200
     3.486    52.070     0.200
     3.649    53.398     0.200
     3.593    53.570     0.200
     3.712    54.137     0.200
     3.889    56.008     0.200
     3.961    59.438     0.200
     4.083    58.449     0.200
     4.319    62.320     0.200
     4.324    64.410     0.200
     4.338    62.820     0.200
     4.491    65.910     0.200
     4.570    66.180     0.200
     4.704    67.969     0.200
     4.760    68.219     0.200
     4.799    69.359     0.200
     4.850    70.648     0.200
     5.003    71.559     0.200
     5.056    73.207     0.200
     5.083    74.527     0.200
     5.110    73.910     0.200
     5.095    73.668     0.200
     5.271    75.969     0.200
     5.300    77.098     0.200
     5.335    76.730     0.200
     5.380    77.668     0.200
     5.454    78.188     0.200
     5.546    79.867     0.200
     5.551    80.129     0.200
     5.553    79.418     0.200
     5.611    81.098     0.200
     5.620    80.297     0.200
     5.694    82.777     0.200
     5.809    83.539     0.200
     5.819    83.270     0.200
     5.870    84.629     0.200
     5.872    83.809     0.200
     5.930    85.160     0.200
     6.011    85.777     0.200
     6.023    86.559     0.200
     6.048    86.598     0.200
     6.052    86.320     0.200
     6.242    88.078     0.200
     6.310    89.758     0.200
     6.314    91.168     0.200
     6.380    90.730     0.200
     6.377    91.039     0.200
     6.396    92.078     0.200
     6.471    92.898     0.200
     6.546    93.609     0.200
     6.559    93.449     0.200
     6.592    93.449     0.200
     6.790    96.129     0.200
     6.700    97.219     0.200
     6.801    96.348     0.200
     6.887    97.508     0.200
     6.887    97.047     0.200
     6.978    99.527     0.200
     7.006    99.430     0.200
     7.188   101.980     0.200
     7.380   105.438     0.200
     7.389   105.457     0.200
     7.474   106.820     0.200
     8.304   117.199     0.200
     8.451   118.969     0.200
     8.633   121.750     0.200
     8.753   123.070     0.200
     8.745   123.367     0.200
     9.325   131.867     0.200
     9.566   134.359     0.200
     9.666   135.609     0.200
     9.752   136.980     0.200
    12.175   169.980     0.200
    12.175   170.832     0.200
    13.067   181.207     0.200
    20.639   276.430     0.200
     1.249    22.538     0.200
     1.249    21.538     0.200
     2.049    33.118     0.200
     2.209    35.258     0.200
     2.262    36.318     0.200
     2.268    36.798     0.200
     2.352    37.688     0.200
     2.481    39.688     0.200
     2.529    39.158     0.200
     2.550    39.897     0.200
     2.812    44.748     0.200
     2.866    45.638     0.200
     2.887    46.518     0.200
     3.142    49.498     0.200
     3.171    49.738     0.200
     3.362    50.878     0.200
     3.661    54.098     0.200
     3.937    59.328     0.200
     3.945    58.498     0.200
     3.989    60.708     0.200
     4.040    61.118     0.200
     4.067    61.458     0.200
     4.173    62.138     0.200
     4.278    65.418     0.200
     4.418    65.138     0.200
     4.583    65.778     0.200
     4.667    69.878     0.200
     4.676    69.978     0.200
     4.738    71.058     0.200
     4.742    70.897     0.200
     4.795    72.188     0.200
     4.828    71.698     0.200
     4.803    70.738     0.200
     4.811    71.738     0.200
     4.872    71.258     0.200
     5.034    74.147     0.200
     5.336    75.868     0.200
     5.216    75.788     0.200
     5.377    78.038     0.200
     5.391    78.118     0.200
     5.488    80.548     0.200
     5.611    79.658     0.200
     5.501    79.748     0.200
     5.551    81.068     0.200
     5.675    82.378     0.200
     5.781    83.738     0.200
     5.812    84.038     0.200
     5.962    86.738     0.200
     6.049    87.558     0.200
     6.087    87.838     0.200
     6.340    89.607     0.200
     6.275    90.208     0.200
     6.384    93.248     0.200
     6.388    92.458     0.200
     6.618    96.038     0.200
     6.568    95.058     0.200
     6.754    94.938     0.200
     6.677    96.098     0.200
     6.693    96.318     0.200
     6.738    97.578     0.200
     6.910   100.128     0.200
     6.909    99.538     0.200
     6.920    99.848     0.200
     6.937    99.848     0.200
     7.113    99.888     0.200
     7.001   101.138     0.200
     6.980   100.438     0.200
     7.033   102.498     0.200
     7.008   101.018     0.200
     7.023   101.357     0.200
     7.068   101.838     0.200
     7.089   102.647     0.200
     7.051   101.397     0.200
     7.142   103.038     0.200
     7.268   104.578     0.200
     7.371   106.688     0.200
     7.387   106.338     0.200
     7.446   107.238     0.200
     7.827   112.288     0.200
     8.264   117.688     0.200
     8.305   119.897     0.200
     8.373   119.418     0.200
     8.497   121.518     0.200
     8.469   120.228     0.200
     8.571   121.607     0.200
     8.597   123.228     0.200
     8.680   122.838     0.200
     8.680   123.508     0.200
     8.714   123.968     0.200
     8.721   123.638     0.200
     8.721   123.438     0.200
     8.721   124.218     0.200
     8.955   127.397     0.200
     9.488   134.638     0.200
     9.496   134.438     0.200
     9.684   136.698     0.200
     9.975   141.897     0.200
     9.979   141.318     0.200
    10.788   151.948     0.200
    11.664   166.238     0.200
    11.921   168.938     0.200
    12.282   175.778     0.200
    12.282   175.338     0.200
    14.649   205.238     0.200
    14.649   205.413     0.200
    14.803   207.538     0.200
    19.272   264.918     0.200
    19.798   271.107     0.200
    19.818   270.838     0.200
     2.288    37.656     0.200
     2.299    37.613     0.200
     2.356    38.773     0.200
     2.570    41.555     0.200
     2.641    42.273     0.200
     2.898    46.484     0.200
     2.946    47.664     0.200
     2.950    47.355     0.200
     3.220    51.137     0.200
     3.236    50.863     0.200
     3.419    52.195     0.200
     3.621    56.355     0.200
     3.712    55.727     0.200
     4.012    61.215     0.200
     3.991    59.785     0.200
     4.063    62.586     0.200
     4.115    62.906     0.200
     4.141    63.344     0.200
     4.229    63.363     0.200
     4.621    67.855     0.200
     4.747    71.387     0.200
     4.810    72.344     0.200
     4.814    72.496     0.200
     4.857    73.273     0.200
     4.913    73.664     0.200
     4.916    72.594     0.200
     5.062    75.734     0.200
     5.050    74.145     0.200
     5.097    75.234     0.200
     5.251    77.453     0.200
     5.430    80.863     0.200
     5.415    79.465     0.200
     5.556    81.977     0.200
     5.800    85.305     0.200
     5.842    85.395     0.200
     6.007    88.363     0.200
     6.110    88.855     0.200
     6.164    90.996     0.200
     6.455    94.656     0.200
     6.575    95.863     0.200
     6.697    97.227     0.200
     6.716    97.727     0.200
     6.922   100.816     0.200
     6.994   101.965     0.200
     7.097   103.113     0.200
     7.156   103.984     0.200
     7.429   107.266     0.200
     7.506   107.664     0.200
     8.739   125.164     0.200
     8.739   124.727     0.200
     8.776   124.965     0.200
     9.563   135.914     0.200
    10.856   153.375     0.200
    11.755   167.387     0.200
    12.254   175.445     0.200
    14.687   206.566     0.200
    14.687   207.164     0.200
     0.287     8.766     0.200
     0.686    12.328     0.200
     1.486    23.055     0.200
     1.527    25.168     0.200
     1.577    25.566     0.200
     1.684    27.086     0.200
     1.723    28.188     0.200
     1.831    29.336     0.200
     1.832    29.285     0.200
     1.899    30.816     0.200
     1.904    30.887     0.200
     1.963    30.945     0.200
     2.070    32.355     0.200
     2.106    33.375     0.200
     2.147    34.258     0.200
     2.187    33.688     0.200
     2.235    34.176     0.200
     2.297    34.957     0.200
     2.535    38.957     0.200
     2.909    42.727     0.200
     2.957    44.816     0.200
     3.015    45.367     0.200
     3.032    46.117     0.200
     3.111    45.965     0.200
     3.593    52.277     0.200
     3.629    53.848     0.200
     3.697    55.047     0.200
     3.741    54.758     0.200
     3.742    55.535     0.200
     3.844    55.875     0.200
     3.936    58.348     0.200
     3.929    57.375     0.200
     3.967    57.668     0.200
     4.051    59.305     0.200
     4.085    59.137     0.200
     4.225    60.508     0.200
     4.318    61.996     0.200
     4.469    64.207     0.200
     4.517    65.195     0.200
     4.652    67.676     0.200
     4.660    67.336     0.200
     4.848    70.008     0.200
     4.892    70.988     0.200
     4.929    71.516     0.200
     5.102    74.035     0.200
     5.171    74.188     0.200
     5.335    75.855     0.200
     5.671    80.766     0.200
     5.767    82.297     0.200
     5.995    86.395     0.200
     5.967    85.605     0.200
     6.027    85.926     0.200
     6.076    86.777     0.200
     6.274    90.168     0.200
     6.359    91.137     0.200
     6.379    90.938     0.200
     6.831    96.918     0.200
     6.820    94.828     0.200
     7.197   101.375     0.200
     7.613   106.855     0.200
     7.658   107.688     0.200
     8.213   116.527     0.200
     8.459   119.027     0.200
     8.965   126.625     0.200
     9.029   127.805     0.200
     9.013   127.426     0.200
     9.728   136.047     0.200
    11.785   165.516     0.200
    13.632   189.645     0.200
    13.632   189.941     0.200
    19.206   260.215     0.200
     0.406    14.164     0.200
     0.626    16.602     0.200
     0.649    16.934     0.200
     0.677    17.422     0.200
     0.677    17.441     0.200
     0.696    17.641     0.200
     0.740    17.133     0.200
     0.868    18.312     0.200
     0.918    18.414     0.200
     0.946    19.301     0.200
     0.950    19.320     0.200
     0.984    20.070     0.200
     0.980    20.613     0.200
     1.058    19.344     0.200
     1.058    19.242     0.200
     1.140    22.043     0.200
     1.154    21.621     0.200
     1.391    25.211     0.200
     1.394    25.344     0.200
     1.588    27.141     0.200
     1.738    29.352     0.200
     1.758    28.914     0.200
     1.811    30.230     0.200
     1.825    30.742     0.200
     1.841    30.191     0.200
     1.874    31.422     0.200
     1.904    31.801     0.200
     1.960    32.391     0.200
     2.163    33.152     0.200
     2.500    38.742     0.200
     2.589    40.723     0.200
     2.611    40.980     0.200
     2.614    40.820     0.200
     2.647    41.562     0.200
     2.648    41.652     0.200
     2.741    42.641     0.200
     2.949    45.371     0.200
     3.019    46.641     0.200
     3.125    47.594     0.200
     3.175    47.801     0.200
     3.433    50.961     0.200
     3.454    51.691     0.200
     3.818    55.941     0.200
     4.247    62.293     0.200
     4.358    63.891     0.200
     4.397    63.871     0.200
     4.397    64.273     0.200
     4.630    67.293     0.200
     4.633    67.613     0.200
     4.799    70.332     0.200
     4.846    70.191     0.200
     4.881    70.902     0.200
     5.076    73.082     0.200
     5.258    75.543     0.200
     5.267    75.582     0.200
     5.343    76.953     0.200
     5.533    79.742     0.200
     5.576    80.703     0.200
     5.585    80.754     0.200
     5.623    81.414     0.200
     5.620    80.672     0.200
     5.756    82.832     0.200
     5.845    83.641     0.200
     5.924    84.684     0.200
     6.049    86.152     0.200
     6.075    87.461     0.200
     6.271    90.133     0.200
     6.324    91.312     0.200
     6.363    89.812     0.200
     6.435    91.172     0.200
     6.502    91.512     0.200
     6.522    93.594     0.200
     6.552    92.934     0.200
     6.576    92.551     0.200
     6.695    94.754     0.200
     6.770    95.043     0.200
     6.770    95.523     0.200
     6.778    95.703     0.200
     6.877    96.371     0.200
     6.877    96.344     0.200
     6.915    97.102     0.200
     6.961    98.094     0.200
     6.997   100.070     0.200
     6.998    99.492     0.200
     7.309   103.473     0.200
     8.148   115.980     0.200
     8.396   119.582     0.200
     8.476   118.582     0.200
     8.665   121.641     0.200
     8.703   121.461     0.200
     9.434   132.980     0.200
     9.595   137.102     0.200
     9.866   135.844     0.200
    10.085   143.383     0.200
    11.584   158.402     0.200
    11.626   161.383     0.200
    12.290   172.641     0.200
    13.081   180.492     0.200
    13.081   180.969     0.200
     0.556    12.430     0.200
     0.661    14.391     0.200
     0.688    14.961     0.200
     0.691    14.980     0.200
     0.709    15.652     0.200
     0.741    15.402     0.200
     0.894    16.461     0.200
     0.977    18.441     0.200
     0.975    17.941     0.200
     1.003    18.453     0.200
     1.038    18.051     0.200
     1.084    19.391     0.200
     1.090    19.160     0.200
     1.203    21.121     0.200
     1.300    22.863     0.200
     1.304    21.781     0.200
     1.387    23.391     0.200
     1.461    24.133     0.200
     1.649    26.582     0.200
     1.727    28.340     0.200
     1.810    29.203     0.200
     1.860    30.113     0.200
     1.897    30.723     0.200
     1.861    30.473     0.200
     1.944    31.102     0.200
     1.933    31.410     0.200
     2.178    33.781     0.200
     2.410    36.922     0.200
     2.432    36.391     0.200
     2.571    40.012     0.200
     2.630    40.922     0.200
     2.632    41.102     0.200
     2.685    41.211     0.200
     2.715    42.223     0.200
     2.922    44.902     0.200
     2.948    45.383     0.200
     3.010    45.543     0.200
     3.073    46.922     0.200
     3.328    48.801     0.200
     3.426    50.922     0.200
     3.588    52.633     0.200
     3.649    53.371     0.200
     3.834    54.762     0.200
     4.132    59.672     0.200
     4.268    61.453     0.200
     4.267    63.223     0.200
     4.283    62.133     0.200
     4.341    63.293     0.200
     4.446    65.492     0.200
     4.499    64.762     0.200
     4.515    65.230     0.200
     4.711    67.980     0.200
     4.749    68.410     0.200
     4.793    71.000     0.200
     4.951    70.621     0.200
     4.952    71.391     0.200
     5.006    73.242     0.200
     5.024    73.012     0.200
     5.165    75.121     0.200
     5.210    75.020     0.200
     5.274    76.141     0.200
     5.487    79.172     0.200
     5.490    79.012     0.200
     5.759    82.543     0.200
     6.319    89.203     0.200
     6.321    91.000     0.200
     6.337    90.691     0.200
     6.379    90.922     0.200
     6.488    92.633     0.200
     6.498    92.363     0.200
     6.532    92.402     0.200
     6.641    94.102     0.200
     6.689    95.262     0.200
     6.729    95.102     0.200
     6.741    95.363     0.200
     6.826    96.121     0.200
     6.826    96.441     0.200
     6.917    97.723     0.200
     7.326   104.363     0.200
     8.391   118.551     0.200
     8.575   120.680     0.200
     8.695   121.980     0.200
     9.702   138.492     0.200
    10.216   144.543     0.200
    12.139   170.016     0.200
    13.006   180.191     0.200
     0.971    17.914     0.200
     1.667    28.461     0.200
     1.858    31.109     0.200
     2.077    34.359     0.200
     2.881    45.586     0.200
     3.115    48.195     0.200
     3.137    48.062     0.200
     3.531    54.695     0.200
     3.552    54.711     0.200
     3.582    55.734     0.200
     3.621    56.016     0.200
     3.665    56.562     0.200
     3.952    59.211     0.200
     4.201    61.664     0.200
     4.289    65.453     0.200
     4.299    65.109     0.200
     4.350    66.375     0.200
     4.352    66.445     0.200
     4.580    67.391     0.200
     4.631    69.789     0.200
     4.736    70.086     0.200
     4.747    69.500     0.200
     4.923    71.961     0.200
     4.959    72.609     0.200
     5.209    76.070     0.200
     5.162    74.914     0.200
     5.154    74.781     0.200
     5.241    75.914     0.200
     5.419    78.570     0.200
     5.448    79.703     0.200
     5.594    81.102     0.200
     5.604    81.164     0.200
     5.758    82.750     0.200
     5.788    83.953     0.200
     5.822    84.711     0.200
     5.844    84.555     0.200
     5.990    88.133     0.200
     5.992    86.922     0.200
     6.089    89.914     0.200
     6.121    88.016     0.200
     6.516    96.070     0.200
     6.720    97.070     0.200
     6.705    97.375     0.200
     6.736    98.141     0.200
     6.714    96.695     0.200
     6.870    99.312     0.200
     6.911    99.406     0.200
     7.162   102.711     0.200
     7.255   104.312     0.200
     7.503   107.883     0.200
     7.988   114.305     0.200
     8.206   117.062     0.200
     8.198   116.984     0.200
     8.183   118.312     0.200
     8.401   118.914     0.200
     8.401   119.281     0.200
     8.423   119.742     0.200
     8.473   120.516     0.200
     8.473   120.461     0.200
     8.473   120.516     0.200
     8.461   119.609     0.200
     8.481   120.266     0.200
     9.042   128.359     0.200
     9.051   128.641     0.200
     9.872   140.562     0.200
     9.947   141.336     0.200
    10.416   147.062     0.200
    11.023   158.453     0.200
    11.252   161.180     0.200
    12.647   180.312     0.200
    12.647   180.672     0.200
    14.364   199.312     0.200
    14.531   203.812     0.200
    15.457   219.211     0.200
    16.786   232.039     0.200
     1.184    20.594     0.200
     1.433    24.992     0.200
     1.426    24.312     0.200
     1.481    25.453     0.200
     1.444    24.414     0.200
     1.484    25.074     0.200
     1.497    25.164     0.200
     1.549    26.473     0.200
     1.662    27.281     0.200
     1.609    26.875     0.200
     1.857    30.352     0.200
     1.847    30.082     0.200
     2.003    31.723     0.200
     2.219    35.262     0.200
     2.250    35.492     0.200
     2.271    36.441     0.200
     2.342    35.992     0.200
     2.330    36.934     0.200
     2.345    37.102     0.200
     2.362    37.293     0.200
     2.478    38.383     0.200
     2.941    45.332     0.200
     3.005    46.434     0.200
     3.009    46.691     0.200
     3.055    47.184     0.200
     3.095    47.555     0.200
     3.107    46.934     0.200
     3.251    49.441     0.200
     3.278    49.184     0.200
     3.298    49.625     0.200
     3.304    49.453     0.200
     3.689    54.414     0.200
     3.710    54.594     0.200
     3.745    55.984     0.200
     3.880    57.344     0.200
     4.007    59.082     0.200
     4.037    59.531     0.200
     4.155    61.504     0.200
     4.244    62.781     0.200
     4.348    64.223     0.200
     4.362    64.133     0.200
     4.426    65.074     0.200
     4.491    66.434     0.200
     4.545    66.844     0.200
     4.648    68.664     0.200
     4.736    69.055     0.200
     5.013    72.902     0.200
     5.107    75.254     0.200
     5.292    77.031     0.200
     5.315    76.832     0.200
     5.346    77.684     0.200
     5.389    78.504     0.200
     5.419    78.574     0.200
     5.448    79.434     0.200
     5.380    77.742     0.200
     5.718    82.922     0.200
     5.780    83.875     0.200
     6.078    87.273     0.200
     6.292    91.523     0.200
     6.348    91.875     0.200
     6.540    93.215     0.200
     6.670    95.422     0.200
     6.709    98.645     0.200
     6.748    96.082     0.200
     6.815    97.863     0.200
     6.828    97.133     0.200
     6.868    97.992     0.200
     6.955    99.023     0.200
     6.984    99.781     0.200
     7.012   100.004     0.200
     7.012   100.055     0.200
     7.013   100.055     0.200
     7.040    99.992     0.200
     7.779   110.652     0.200
     8.402   119.332     0.200
     9.045   126.941     0.200
     9.819   136.691     0.200
    10.369   148.875     0.200
    11.667   166.180     0.200
    11.667   165.094     0.200
    18.887   258.250     0.200
     0.486    13.609     0.200
     0.623    15.790     0.200
     0.658    15.310     0.200
     0.667    15.710     0.200
     0.773    16.580     0.200
     0.781    16.850     0.200
     0.829    17.359     0.200
     0.933    17.590     0.200
     0.905    17.970     0.200
     0.929    18.250     0.200
     0.972    18.899     0.200
     1.205    21.109     0.200
     1.557    26.439     0.200
     1.838    30.460     0.200
     1.861    31.029     0.200
     1.864    31.220     0.200
     2.170    35.060     0.200
     2.165    34.560     0.200
     2.391    37.010     0.200
     2.484    39.180     0.200
     2.567    40.290     0.200
     2.947    44.359     0.200
     3.012    46.270     0.200
     3.021    46.569     0.200
     3.059    47.290     0.200
     3.075    47.410     0.200
     3.145    48.279     0.200
     3.477    52.170     0.200
     3.604    55.390     0.200
     3.714    54.029     0.200
     3.717    54.790     0.200
     3.773    56.740     0.200
     3.826    57.420     0.200
     3.827    57.720     0.200
     3.827    57.569     0.200
     3.895    57.470     0.200
     4.145    61.640     0.200
     4.247    63.060     0.200
     4.315    63.130     0.200
     4.347    64.000     0.200
     4.382    63.420     0.200
     4.646    68.080     0.200
     4.785    68.380     0.200
     4.833    70.479     0.200
     4.891    70.060     0.200
     5.113    72.510     0.200
     5.305    77.660     0.200
     5.413    77.020     0.200
     5.421    79.520     0.200
     5.501    78.770     0.200
     5.562    79.330     0.200
     5.647    80.939     0.200
     5.911    84.700     0.200
     5.936    84.640     0.200
     5.967    85.569     0.200
     5.940    85.500     0.200
     6.183    88.439     0.200
     6.195    87.970     0.200
     6.221    88.340     0.200
     6.229    88.529     0.200
     6.361    90.279     0.200
     6.476    91.540     0.200
     6.502    92.859     0.200
     6.571    93.140     0.200
     6.590    93.109     0.200
     6.745    95.819     0.200
     6.775    96.420     0.200
     6.790    97.040     0.200
     6.811    96.529     0.200
     6.868    97.890     0.200
     6.932    98.420     0.200
     7.067   100.609     0.200
     7.067    99.899     0.200
     7.066   100.279     0.200
     7.127   101.819     0.200
     7.148   102.010     0.200
     7.171   101.770     0.200
     7.226   102.750     0.200
     7.302   103.870     0.200
     7.382   105.090     0.200
     7.448   106.390     0.200
     7.502   107.040     0.200
     7.538   107.100     0.200
     7.552   108.240     0.200
     7.583   108.100     0.200
     7.574   105.740     0.200
     7.681   109.729     0.200
     7.616   107.270     0.200
     7.656   107.069     0.200
     7.788   108.520     0.200
     7.917   110.529     0.200
     7.979   111.170     0.200
     7.981   111.460     0.200
     7.996   112.810     0.200
     8.096   112.890     0.200
     8.095   112.260     0.200
     8.095   112.710     0.200
     8.251   115.740     0.200
     8.366   117.910     0.200
     8.376   118.510     0.200
     8.345   118.939     0.200
     8.426   119.359     0.200
     9.698   135.290     0.200
     9.841   136.470     0.200
     9.875   138.580     0.200
    13.132   183.760     0.200
    14.308   196.385     0.200
     0.310    14.211     0.200
     0.364    14.590     0.200
     0.518    15.328     0.200
     0.600    16.102     0.200
     0.634    16.801     0.200
     0.661    16.699     0.200
     0.654    16.461     0.200
     0.698    17.500     0.200
     0.769    17.840     0.200
     0.830    18.238     0.200
     1.079    21.398     0.200
     1.105    21.500     0.200
     1.224    23.309     0.200
     1.367    23.660     0.200
     1.457    24.949     0.200
     1.507    26.461     0.200
     1.525    26.129     0.200
     1.547    26.578     0.200
     1.735    29.520     0.200
     1.687    28.004     0.200
     1.981    31.461     0.200
     2.103    34.648     0.200
     2.119    34.961     0.200
     2.122    35.102     0.200
     2.139    35.199     0.200
     2.321    37.211     0.200
     2.423    38.930     0.200
     2.352    37.871     0.200
     2.378    37.789     0.200
     2.479    39.070     0.200
     2.561    40.059     0.200
     2.572    40.160     0.200
     2.789    43.871     0.200
     2.858    44.781     0.200
     2.955    45.051     0.200
     3.029    46.359     0.200
     3.241    49.969     0.200
     3.243    49.801     0.200
     3.284    50.570     0.200
     3.288    50.469     0.200
     3.316    49.461     0.200
     3.371    51.469     0.200
     3.497    52.430     0.200
     3.483    51.531     0.200
     3.892    59.539     0.200
     3.987    59.898     0.200
     4.035    60.801     0.200
     4.036    60.680     0.200
     4.046    60.941     0.200
     4.057    59.750     0.200
     4.100    59.398     0.200
     4.096    60.391     0.200
     4.369    64.621     0.200
     4.395    64.328     0.200
     4.434    64.418     0.200
     4.616    68.148     0.200
     4.637    67.141     0.200
     4.863    70.871     0.200
     4.993    71.828     0.200
     5.109    73.539     0.200
     5.204    74.180     0.200
     5.238    74.801     0.200
     5.315    77.680     0.200
     5.338    77.180     0.200
     5.502    78.148     0.200
     5.516    79.391     0.200
     5.493    78.910     0.200
     5.584    82.211     0.200
     5.624    80.168     0.200
     5.693    80.809     0.200
     5.801    83.531     0.200
     5.919    84.430     0.200
     5.951    85.109     0.200
     5.989    85.328     0.200
     6.095    87.711     0.200
     6.182    88.461     0.200
     6.315    89.738     0.200
     6.343    90.250     0.200
     6.408    91.418     0.200
     6.438    91.461     0.200
     6.608    93.719     0.200
     6.665    94.238     0.200
     6.647    94.941     0.200
     6.723    94.750     0.200
     6.799    96.309     0.200
     6.827    98.141     0.200
     6.793    97.109     0.200
     6.862    96.480     0.200
     6.905    97.758     0.200
     6.945    98.809     0.200
     6.980    98.309     0.200
     7.144   101.469     0.200
     7.163   102.129     0.200
     7.184   101.949     0.200
     7.166   100.961     0.200
     7.248   102.160     0.200
     7.179   102.129     0.200
     7.252   103.449     0.200
     7.261   102.891     0.200
     7.326   104.289     0.200
     7.395   104.180     0.200
     7.479   105.641     0.200
     7.505   106.469     0.200
     7.611   107.820     0.200
     7.590   107.719     0.200
     7.600   107.449     0.200
     7.646   108.051     0.200
     7.647   108.488     0.200
     7.687   107.352     0.200
     7.721   109.441     0.200
     7.806   108.469     0.200
     7.816   109.391     0.200
     7.819   110.809     0.200
     7.957   113.168     0.200
     7.967   112.809     0.200
     7.994   112.711     0.200
     8.021   111.199     0.200
     8.030   111.660     0.200
     8.030   113.781     0.200
     8.087   114.648     0.200
     8.171   114.129     0.200
     8.101   114.320     0.200
     8.197   114.551     0.200
     8.205   113.078     0.200
     8.205   114.148     0.200
     8.199   115.910     0.200
     8.180   115.320     0.200
     8.343   115.480     0.200
     8.343   115.938     0.200
     8.343   115.578     0.200
     8.391   120.699     0.200
     8.387   118.398     0.200
     8.442   119.461     0.200
     8.467   120.059     0.200
     8.739   122.430     0.200
     8.752   122.820     0.200
     8.796   124.230     0.200
     8.818   122.871     0.200
     9.316   130.109     0.200
     9.977   138.680     0.200
    10.023   138.969     0.200
    10.236   143.078     0.200
    10.805   150.641     0.200
    11.073   153.859     0.200
    12.633   173.789     0.200
    13.608   189.656     0.200
    14.608   199.703     0.200
    15.744   213.789     0.200
     1.255    20.805     0.200
     1.295    22.133     0.200
     1.307    22.434     0.200
     1.356    23.281     0.200
     1.379    22.871     0.200
     1.459    24.543     0.200
     1.467    24.691     0.200
     1.529    25.152     0.200
     1.575    25.805     0.200
     1.750    28.023     0.200
     1.761    28.043     0.200
     1.817    29.852     0.200
     1.819    29.191     0.200
     1.812    29.461     0.200
     1.866    29.852     0.200
     2.010    31.781     0.200
     2.170    34.324     0.200
     2.219    35.305     0.200
     2.462    37.582     0.200
     2.481    38.684     0.200
     2.526    39.273     0.200
     2.544    39.512     0.200
     2.877    43.273     0.200
     2.932    44.023     0.200
     2.928    44.645     0.200
     2.947    44.973     0.200
     2.953    44.711     0.200
     2.973    45.262     0.200
     2.979    45.652     0.200
     3.027    45.902     0.200
     3.059    46.363     0.200
     3.131    46.074     0.200
     3.278    48.562     0.200
     3.271    48.152     0.200
     3.675    55.094     0.200
     3.739    56.324     0.200
     3.737    56.031     0.200
     3.740    56.652     0.200
     3.833    56.262     0.200
     3.880    56.602     0.200
     3.820    56.531     0.200
     3.891    57.711     0.200
     3.907    57.273     0.200
     3.890    57.473     0.200
     4.004    59.473     0.200
     4.068    59.281     0.200
     4.374    63.762     0.200
     4.481    64.684     0.200
     4.489    64.414     0.200
     4.609    65.844     0.200
     4.764    68.934     0.200
     4.776    69.023     0.200
     4.746    68.664     0.200
     4.862    70.191     0.200
     4.922    71.344     0.200
     4.957    71.883     0.200
     5.120    73.543     0.200
     5.120    73.863     0.200
     5.143    74.602     0.200
     5.318    77.023     0.200
     5.382    79.441     0.200
     5.466    78.473     0.200
     5.548    80.023     0.200
     5.600    80.781     0.200
     5.729    81.953     0.200
     5.963    85.844     0.200
     6.097    87.484     0.200
     6.065    87.422     0.200
     6.107    87.672     0.200
     6.246    89.883     0.200
     6.225    88.562     0.200
     6.210    88.352     0.200
     6.313    90.793     0.200
     6.334    90.254     0.200
     6.380    91.344     0.200
     6.438    92.461     0.200
     6.461    92.703     0.200
     6.506    92.652     0.200
     6.576    93.652     0.200
     6.731    95.973     0.200
     6.644    94.422     0.200
     6.745    96.312     0.200
     6.847    97.895     0.200
     6.937    98.574     0.200
     7.075   101.895     0.200
     7.366   103.934     0.200
     7.745   108.172     0.200
     7.808   110.934     0.200
     7.808   108.281     0.200
     7.808   109.543     0.200
    12.384   170.441     0.200
    13.852   192.598     0.200
     2.077    34.199     0.200
     2.133    35.279     0.200
     2.210    35.430     0.200
     2.411    39.510     0.200
     2.525    40.889     0.200
     2.602    41.740     0.200
     2.540    41.090     0.200
     2.589    41.869     0.200
     3.121    48.549     0.200
     3.177    49.270     0.200
     3.177    49.449     0.200
     3.367    50.379     0.200
     3.536    54.400     0.200
     3.569    54.400     0.200
     3.636    54.949     0.200
     3.649    56.150     0.200
     3.785    56.859     0.200
     4.246    63.709     0.200
     4.260    63.219     0.200
     4.310    64.600     0.200
     4.398    65.549     0.200
     4.539    67.580     0.200
     4.313    65.549     0.200
     4.579    68.359     0.200
     4.606    67.590     0.200
     4.679    68.529     0.200
     4.763    70.479     0.200
     4.889    72.150     0.200
     4.920    73.129     0.200
     5.024    74.330     0.200
     5.027    74.250     0.200
     5.042    74.629     0.200
     5.158    75.930     0.200
     5.192    76.479     0.200
     5.376    79.129     0.200
     5.437    79.770     0.200
     5.458    80.420     0.200
     5.522    81.629     0.200
     5.946    90.189     0.200
     6.046    88.650     0.200
     6.064    88.629     0.200
     6.105    90.150     0.200
     6.151    90.500     0.200
     6.322    92.289     0.200
     6.347    93.209     0.200
     6.395    94.580     0.200
     6.390    93.750     0.200
     6.418    94.369     0.200
     6.506    95.629     0.200
     6.541    95.639     0.200
     6.615    97.449     0.200
     6.794    98.629     0.200
     6.792    99.760     0.200
     6.925   101.590     0.200
     7.161   104.270     0.200
     7.604   110.139     0.200
     7.505   109.719     0.200
     7.708   112.939     0.200
     7.889   113.559     0.200
     7.938   114.539     0.200
     8.152   116.279     0.200
     8.177   116.379     0.200
     8.176   115.740     0.200
     8.176   116.590     0.200
     9.182   133.609     0.200
     9.357   134.949     0.200
     9.370   134.160     0.200
    11.714   168.090     0.200
    14.045   198.465     0.200
    19.320   266.135     0.200
     0.360    13.705     0.200
     0.390    13.945     0.200
     0.447    14.285     0.200
     0.472    14.426     0.200
     0.518    15.186     0.200
     0.521    14.846     0.200
     0.578    15.785     0.200
     0.574    15.395     0.200
     0.618    15.824     0.200
     0.652    15.975     0.200
     0.660    15.686     0.200
     0.711    16.305     0.200
     0.785    17.115     0.200
     0.896    18.834     0.200
     0.970    19.346     0.200
     1.036    20.436     0.200
     1.184    21.205     0.200
     1.289    22.355     0.200
     1.458    25.115     0.200
     1.458    25.984     0.200
     1.578    27.004     0.200
     1.885    29.436     0.200
     1.916    31.805     0.200
     1.935    32.404     0.200
     1.937    32.414     0.200
     1.954    32.385     0.200
     2.204    34.305     0.200
     2.242    36.135     0.200
     2.582    40.605     0.200
     2.625    41.145     0.200
     2.606    40.705     0.200
     2.615    41.176     0.200
     2.683    42.494     0.200
     2.742    42.926     0.200
     2.711    42.125     0.200
     2.809    43.115     0.200
     2.789    43.125     0.200
     2.803    43.615     0.200
     3.071    47.176     0.200
     3.076    47.205     0.200
     3.098    46.314     0.200
     3.124    48.004     0.200
     3.410    52.004     0.200
     3.417    51.025     0.200
     3.709    54.285     0.200
     3.824    57.455     0.200
     3.849    56.834     0.200
     3.878    56.205     0.200
     3.875    58.605     0.200
     3.876    58.605     0.200
     4.203    62.404     0.200
     4.328    63.625     0.200
     4.433    65.254     0.200
     4.435    64.525     0.200
     4.628    67.686     0.200
     4.700    68.596     0.200
     4.666    67.824     0.200
     4.777    68.754     0.200
     5.002    71.955     0.200
     5.006    72.355     0.200
     5.243    76.465     0.200
     5.280    74.994     0.200
     5.287    75.775     0.200
     5.444    79.766     0.200
     5.467    77.135     0.200
     5.579    80.494     0.200
     5.690    80.984     0.200
     5.729    82.164     0.200
     5.781    82.555     0.200
     5.912    84.355     0.200
     5.958    85.225     0.200
     6.096    86.834     0.200
     6.110    87.154     0.200
     6.161    88.115     0.200
     6.280    89.895     0.200
     6.379    90.414     0.200
     6.430    91.045     0.200
     6.550    92.234     0.200
     6.565    93.135     0.200
     6.672    94.275     0.200
     6.711    94.955     0.200
     6.762    96.154     0.200
     6.812    95.926     0.200
     6.933    98.625     0.200
     7.031    99.754     0.200
     7.093   100.654     0.200
     7.192   102.324     0.200
     7.356   104.484     0.200
     7.368   104.275     0.200
     7.417   105.135     0.200
     7.401   104.545     0.200
     7.497   105.625     0.200
     7.586   107.654     0.200
     7.639   106.355     0.200
     7.721   109.814     0.200
     7.783   110.475     0.200
     7.795   110.225     0.200
     7.854   111.504     0.200
     7.854   108.955     0.200
     7.965   112.754     0.200
     8.041   111.795     0.200
     8.170   113.516     0.200
     8.170   113.365     0.200
     8.170   113.346     0.200
     8.352   118.266     0.200
     8.580   121.414     0.200
     9.080   126.715     0.200
     9.822   137.105     0.200
     9.851   136.205     0.200
     9.898   140.846     0.200
    10.023   141.064     0.200
    12.412   172.045     0.200
    12.544   174.805     0.200
    13.373   186.689     0.200
    14.417   198.215     0.200
    14.417   198.016     0.200
     0.658    13.215     0.200
     0.757    14.898     0.200
     0.843    15.949     0.200
     0.973    17.609     0.200
     1.008    18.527     0.200
     1.062    18.711     0.200
     1.102    19.109     0.200
     1.104    19.039     0.200
     1.118    19.230     0.200
     1.203    19.969     0.200
     1.256    21.879     0.200
     1.237    21.328     0.200
     1.424    24.141     0.200
     1.430    24.098     0.200
     1.468    23.910     0.200
     1.524    24.730     0.200
     1.553    25.367     0.200
     1.614    26.348     0.200
     1.659    26.938     0.200
     1.728    27.617     0.200
     1.905    30.328     0.200
     1.905    30.508     0.200
     1.970    30.480     0.200
     2.062    33.059     0.200
     2.034    32.148     0.200
     2.114    33.789     0.200
     2.160    34.129     0.200
     2.372    37.301     0.200
     2.475    37.090     0.200
     2.525    38.367     0.200
     2.814    43.070     0.200
     2.851    44.051     0.200
     2.878    44.039     0.200
     2.893    44.891     0.200
     2.974    43.520     0.200
     3.007    44.770     0.200
     3.102    47.328     0.200
     3.143    46.867     0.200
     3.151    47.648     0.200
     3.169    47.277     0.200
     3.260    49.141     0.200
     3.396    49.918     0.200
     3.653    54.219     0.200
     3.636    54.578     0.200
     3.725    54.230     0.200
     3.853    56.500     0.200
     3.870    55.910     0.200
     4.042    57.777     0.200
     4.119    60.277     0.200
     4.169    60.258     0.200
     4.254    61.570     0.200
     4.319    62.688     0.200
     4.439    64.559     0.200
     4.474    64.820     0.200
     4.540    65.711     0.200
     4.696    67.859     0.200
     4.759    69.238     0.200
     4.865    70.988     0.200
     4.947    71.211     0.200
     4.953    71.859     0.200
     5.128    73.820     0.200
     5.223    75.688     0.200
     5.275    75.301     0.200
     5.256    76.777     0.200
     5.357    77.199     0.200
     5.398    77.980     0.200
     5.422    78.277     0.200
     5.511    78.938     0.200
     5.553    79.961     0.200
     5.563    80.277     0.200
     5.567    79.648     0.200
     5.867    84.301     0.200
     5.911    84.027     0.200
     5.920    84.320     0.200
     5.930    84.180     0.200
     5.977    85.277     0.200
     5.981    85.141     0.200
     6.297    89.199     0.200
     6.361    89.961     0.200
     6.416    91.270     0.200
     6.416    92.730     0.200
     6.528    91.898     0.200
     6.513    92.398     0.200
     6.672    94.410     0.200
     6.727    95.449     0.200
     6.724    95.277     0.200
     6.728    95.098     0.200
     6.925    98.359     0.200
     6.944    98.277     0.200
     7.006    98.688     0.200
     7.006    99.168     0.200
     7.190   102.059     0.200
     7.612   108.129     0.200
     7.698   108.230     0.200
     8.498   118.551     0.200
     8.836   125.461     0.200
     8.940   125.508     0.200
     9.448   131.688     0.200
     9.799   136.590     0.200
    12.005   168.289     0.200
    13.132   182.988     0.200
     0.062    13.969     0.200
     0.209    13.930     0.200
     0.246    14.289     0.200
     0.365    14.809     0.200
     0.377    14.879     0.200
     0.442    15.801     0.200
     0.418    15.059     0.200
     0.474    15.199     0.200
     0.520    15.789     0.200
     0.470    15.551     0.200
     0.526    16.039     0.200
     0.609    16.719     0.200
     0.614    16.738     0.200
     0.624    16.539     0.200
     0.983    20.531     0.200
     0.997    20.988     0.200
     1.019    21.102     0.200
     1.018    21.031     0.200
     1.065    21.031     0.200
     1.308    23.355     0.200
     1.221    23.129     0.200
     1.253    23.508     0.200
     1.250    23.301     0.200
     1.301    24.430     0.200
     1.316    24.020     0.200
     1.325    24.191     0.200
     1.340    24.828     0.200
     1.502    25.551     0.200
     1.468    26.160     0.200
     1.606    28.000     0.200
     1.670    28.852     0.200
     1.680    28.488     0.200
     1.981    32.480     0.200
     2.011    32.059     0.200
     2.126    34.750     0.200
     2.171    35.711     0.200
     2.253    35.281     0.200
     2.232    36.270     0.200
     2.258    36.621     0.200
     2.491    38.781     0.200
     2.519    40.180     0.200
     2.567    40.090     0.200
     2.573    40.488     0.200
     2.601    40.570     0.200
     2.798    42.160     0.200
     2.880    44.891     0.200
     2.910    45.430     0.200
     2.931    45.871     0.200
     2.958    45.539     0.200
     2.937    45.988     0.200
     3.258    49.820     0.200
     3.432    52.109     0.200
     3.525    52.289     0.200
     3.642    53.801     0.200
     3.915    56.961     0.200
     4.088    59.871     0.200
     4.201    60.758     0.200
     4.349    63.129     0.200
     4.410    64.500     0.200
     4.425    65.578     0.200
     4.511    65.918     0.200
     4.447    65.691     0.200
     4.511    65.918     0.200
     4.658    66.320     0.200
     4.743    69.039     0.200
     4.855    70.738     0.200
     4.893    70.750     0.200
     4.886    70.281     0.200
     4.915    70.508     0.200
     5.134    74.129     0.200
     5.244    74.918     0.200
     5.370    77.258     0.200
     5.336    76.969     0.200
     5.589    80.070     0.200
     5.606    79.918     0.200
     5.675    81.449     0.200
     5.735    82.461     0.200
     5.738    82.270     0.200
     5.741    82.270     0.200
     5.840    83.918     0.200
     5.826    83.441     0.200
     5.867    83.918     0.200
     6.000    86.258     0.200
     6.048    86.539     0.200
     6.070    86.941     0.200
     6.205    88.680     0.200
     6.286    90.121     0.200
     6.283    89.000     0.200
     6.310    91.168     0.200
     6.429    92.121     0.200
     6.454    92.000     0.200
     6.492    92.840     0.200
     6.544    93.340     0.200
     6.615    94.418     0.200
     6.641    94.941     0.200
     6.655    94.680     0.200
     6.652    94.918     0.200
     6.695    93.961     0.200
     6.748    95.238     0.200
     6.909    96.699     0.200
     6.971    99.852     0.200
     6.979    99.641     0.200
     7.053   100.820     0.200
     7.053    98.828     0.200
     7.093   101.121     0.200
     7.093    99.918     0.200
     7.096    99.352     0.200
     7.208   102.828     0.200
     7.226   100.828     0.200
     7.226   101.031     0.200
     7.485   106.102     0.200
     7.467   106.180     0.200
     7.665   108.121     0.200
     7.710   108.668     0.200
     8.909   124.031     0.200
     8.929   124.918     0.200
     9.141   128.379     0.200
     9.964   141.391     0.200
    12.818   181.328     0.200
    13.487   185.230     0.200
     1.323    23.838     0.200
     1.788    28.068     0.200
     2.096    34.168     0.200
     2.252    36.998     0.200
     2.258    37.068     0.200
     2.396    39.388     0.200
     2.410    40.147     0.200
     2.535    41.048     0.200
     2.595    41.218     0.200
     2.910    47.258     0.200
     2.948    47.758     0.200
     2.958    47.658     0.200
     3.053    47.138     0.200
     3.160    49.598     0.200
     3.216    48.748     0.200
     3.214    51.318     0.200
     3.438    52.658     0.200
     3.512    54.748     0.200
     3.617    56.168     0.200
     4.011    61.488     0.200
     4.020    59.908     0.200
     4.250    63.548     0.200
     4.750    71.568     0.200
     4.893    73.328     0.200
     4.879    72.107     0.200
     4.947    72.908     0.200
     5.289    77.278     0.200
     5.369    78.078     0.200
     5.453    79.768     0.200
     5.461    79.908     0.200
     5.580    80.808     0.200
     5.800    85.258     0.200
     5.883    85.848     0.200
     6.037    88.628     0.200
     6.122    89.448     0.200
     6.126    89.528     0.200
     6.338    92.278     0.200
     6.458    94.828     0.200
     6.450    94.118     0.200
     6.630    96.778     0.200
     6.707    97.748     0.200
     6.745    98.018     0.200
     6.974   101.008     0.200
     7.046   102.438     0.200
     7.109   103.528     0.200
     7.164   104.607     0.200
     7.461   109.218     0.200
     7.522   109.048     0.200
     8.379   122.328     0.200
     8.756   125.328     0.200
    10.863   153.938     0.200
    11.716   167.357     0.200
    14.722   208.038     0.200
    14.722   208.208     0.200
     0.412     9.346     0.200
     0.540    11.355     0.200
     0.540    11.105     0.200
     0.927    15.916     0.200
     1.026    17.635     0.200
     1.065    18.205     0.200
     1.129    19.154     0.200
     1.151    19.355     0.200
     1.112    18.695     0.200
     1.195    20.086     0.200
     1.200    20.145     0.200
     1.214    20.436     0.200
     1.300    21.645     0.200
     1.324    22.266     0.200
     1.438    23.436     0.200
     1.634    26.586     0.200
     1.730    28.266     0.200
     1.755    28.945     0.200
     1.764    28.836     0.200
     1.777    29.445     0.200
     2.054    32.805     0.200
     2.130    32.865     0.200
     2.279    35.984     0.200
     2.366    36.715     0.200
     2.465    38.035     0.200
     2.555    39.115     0.200
     2.564    38.836     0.200
     2.613    40.525     0.200
     2.888    44.256     0.200
     2.939    45.186     0.200
     2.977    44.875     0.200
     3.013    45.785     0.200
     3.022    45.785     0.200
     3.279    48.266     0.200
     3.372    49.814     0.200
     3.386    51.615     0.200
     3.434    53.045     0.200
     3.650    54.045     0.200
     3.648    54.115     0.200
     3.661    54.045     0.200
     3.665    54.404     0.200
     3.690    55.324     0.200
     3.708    55.186     0.200
     3.710    55.314     0.200
     3.958    59.096     0.200
     3.995    59.305     0.200
     3.994    58.564     0.200
     4.212    61.324     0.200
     4.466    65.596     0.200
     4.577    66.215     0.200
     4.953    71.074     0.200
     4.965    72.125     0.200
     4.981    71.404     0.200
     5.101    73.355     0.200
     5.140    74.865     0.200
     5.271    75.814     0.200
     5.346    78.426     0.200
     5.359    76.814     0.200
     5.455    79.205     0.200
     5.477    78.885     0.200
     5.490    78.715     0.200
     5.681    81.195     0.200
     5.796    82.314     0.200
     5.872    84.885     0.200
     5.926    84.705     0.200
     6.022    85.805     0.200
     6.047    87.305     0.200
     6.074    87.205     0.200
     6.099    88.695     0.200
     6.192    88.365     0.200
     6.256    89.035     0.200
     6.276    89.695     0.200
     6.294    90.734     0.200
     6.354    90.676     0.200
     6.499    92.734     0.200
     6.543    93.695     0.200
     6.533    93.055     0.200
     6.571    93.715     0.200
     6.629    94.795     0.200
     6.620    94.205     0.200
     6.675    95.006     0.200
     6.703    96.055     0.200
     6.856    97.715     0.200
     6.987    99.416     0.200
     6.996    99.895     0.200
     7.078   100.666     0.200
     7.323   104.035     0.200
     7.371   103.734     0.200
     7.530   106.586     0.200
     7.566   106.695     0.200
     7.581   106.695     0.200
     7.633   110.205     0.200
     7.660   107.865     0.200
     7.782   109.975     0.200
     7.782   108.904     0.200
     7.800   109.725     0.200
     7.865   111.244     0.200
     7.865   110.355     0.200
     7.865   110.586     0.200
     7.985   112.436     0.200
     8.231   116.025     0.200
     8.404   118.506     0.200
     9.035   128.336     0.200
     9.168   128.945     0.200
     9.330   132.756     0.200
     9.446   134.055     0.200
     9.696   137.725     0.200
     9.773   139.205     0.200
    10.052   141.195     0.200
    10.487   149.086     0.200
    10.809   153.215     0.200
    12.473   175.680     0.200
    12.473   177.676     0.200
    13.974   193.555     0.200
     0.552    11.617     0.200
     0.674    13.266     0.200
     0.715    14.023     0.200
     0.741    13.945     0.200
     0.741    13.820     0.200
     0.942    17.320     0.200
     0.949    17.742     0.200
     0.984    18.070     0.200
     0.985    18.070     0.200
     1.063    19.172     0.200
     1.155    19.945     0.200
     1.193    20.953     0.200
     1.206    20.891     0.200
     1.228    21.672     0.200
     1.308    21.961     0.200
     1.349    22.492     0.200
     1.365    22.055     0.200
     1.356    22.672     0.200
     1.468    24.461     0.200
     1.465    24.156     0.200
     1.505    24.484     0.200
     1.535    25.047     0.200
     1.693    27.000     0.200
     1.951    30.977     0.200
     2.082    33.070     0.200
     2.161    32.820     0.200
     2.236    33.773     0.200
     2.312    35.312     0.200
     2.686    41.500     0.200
     2.693    41.477     0.200
     2.717    42.242     0.200
     2.749    42.617     0.200
     2.752    42.602     0.200
     2.906    43.742     0.200
     2.936    43.875     0.200
     3.008    46.070     0.200
     3.011    45.016     0.200
     3.163    46.766     0.200
     3.380    50.953     0.200
     3.519    50.484     0.200
     3.905    57.000     0.200
     3.887    57.484     0.200
     3.927    56.805     0.200
     4.004    57.820     0.200
     4.214    61.727     0.200
     4.295    61.484     0.200
     4.394    64.922     0.200
     4.456    64.664     0.200
     4.697    67.422     0.200
     4.701    68.164     0.200
     4.724    68.672     0.200
     4.744    68.297     0.200
     4.875    69.945     0.200
     5.065    72.617     0.200
     5.109    74.633     0.200
     5.218    75.445     0.200
     5.217    74.977     0.200
     5.263    75.523     0.200
     5.313    76.016     0.200
     5.510    79.625     0.200
     5.645    80.852     0.200
     5.648    81.312     0.200
     5.678    81.266     0.200
     5.979    86.312     0.200
     6.045    86.461     0.200
     6.109    87.875     0.200
     6.749    94.805     0.200
     6.820    96.977     0.200
     6.819    96.875     0.200
     6.951    99.305     0.200
     7.512   107.375     0.200
     8.803   124.383     0.200
    10.080   140.203     0.200
    11.763   165.320     0.200
    12.915   179.375     0.200
    18.888   256.320     0.200
     0.206    13.426     0.200
     0.297    13.203     0.200
     0.441    14.414     0.200
     0.455    14.145     0.200
     0.492    14.973     0.200
     0.558    15.504     0.200
     0.561    15.695     0.200
     0.517    14.863     0.200
     0.559    15.035     0.200
     0.643    16.285     0.200
     0.795    17.793     0.200
     0.821    18.293     0.200
     1.057    21.016     0.200
     1.057    19.301     0.200
     1.057    20.375     0.200
     1.080    21.562     0.200
     1.090    21.695     0.200
     1.099    21.652     0.200
     1.257    21.426     0.200
     1.390    25.305     0.200
     1.769    30.062     0.200
     1.789    30.555     0.200
     1.814    28.684     0.200
     1.864    31.312     0.200
     2.233    36.164     0.200
     2.226    34.934     0.200
     2.260    37.016     0.200
     2.280    37.004     0.200
     2.346    37.715     0.200
     2.367    37.973     0.200
     2.558    40.184     0.200
     2.593    40.184     0.200
     2.607    40.562     0.200
     2.662    40.094     0.200
     2.821    43.434     0.200
     2.968    44.645     0.200
     2.995    46.363     0.200
     3.021    46.574     0.200
     3.013    44.766     0.200
     3.030    46.496     0.200
     3.070    45.734     0.200
     3.047    47.023     0.200
     3.050    47.215     0.200
     3.050    47.266     0.200
     3.365    50.973     0.200
     3.433    52.945     0.200
     3.457    53.215     0.200
     3.477    52.484     0.200
     3.555    52.652     0.200
     3.648    55.766     0.200
     3.698    55.945     0.200
     3.902    57.086     0.200
     4.127    59.723     0.200
     4.232    61.793     0.200
     4.502    65.395     0.200
     4.570    66.555     0.200
     4.542    65.453     0.200
     4.638    68.754     0.200
     4.660    68.293     0.200
     4.654    69.055     0.200
     4.713    67.875     0.200
     4.824    70.086     0.200
     4.851    70.086     0.200
     4.863    70.164     0.200
     4.901    70.574     0.200
     5.116    75.234     0.200
     5.097    73.176     0.200
     5.163    75.234     0.200
     5.176    75.074     0.200
     5.225    75.113     0.200
     5.291    76.676     0.200
     5.331    77.004     0.200
     5.447    78.613     0.200
     5.451    77.953     0.200
     5.502    80.215     0.200
     5.534    79.273     0.200
     5.585    80.203     0.200
     5.611    81.176     0.200
     5.675    82.496     0.200
     5.637    80.895     0.200
     5.695    81.152     0.200
     5.736    82.246     0.200
     5.754    82.285     0.200
     5.890    84.805     0.200
     5.909    84.824     0.200
     5.962    84.754     0.200
     5.964    84.973     0.200
     5.984    85.543     0.200
     6.151    87.703     0.200
     6.162    88.562     0.200
     6.191    88.824     0.200
     6.311    89.664     0.200
     6.384    91.902     0.200
     6.338    91.062     0.200
     6.461    93.176     0.200
     6.461    92.426     0.200
     6.543    94.703     0.200
     6.537    93.203     0.200
     6.543    93.223     0.200
     6.552    93.926     0.200
     6.555    94.023     0.200
     6.794    95.254     0.200
     6.889    96.855     0.200
     6.873    98.613     0.200
     6.945   100.844     0.200
     6.904    98.434     0.200
     6.909    98.445     0.200
     6.990   100.824     0.200
     6.993   100.062     0.200
     6.994    98.133     0.200
     7.007    97.855     0.200
     6.999   100.145     0.200
     7.137   100.285     0.200
     7.198   100.746     0.200
     7.198   100.375     0.200
     7.201   100.676     0.200
     7.240   102.133     0.200
     7.315   101.363     0.200
     7.315   101.973     0.200
     7.315   101.973     0.200
     7.378   105.094     0.200
     7.647   108.574     0.200
     7.696   109.773     0.200
     7.704   108.875     0.200
     7.759   110.715     0.200
     7.818   111.113     0.200
     7.770   109.695     0.200
     7.802   110.062     0.200
     7.837   111.715     0.200
     8.213   115.594     0.200
     8.220   116.562     0.200
     8.418   118.984     0.200
     8.440   119.535     0.200
     8.632   121.246     0.200
     8.942   124.883     0.200
     9.080   126.625     0.200
     9.143   128.574     0.200
     9.182   129.523     0.200
     9.145   128.586     0.200
     9.309   131.266     0.200
     9.651   137.895     0.200
     9.859   137.234     0.200
     9.838   138.203     0.200
    10.028   142.723     0.200
    10.093   142.105     0.200
    11.957   164.965     0.200
    12.678   177.348     0.200
    12.914   178.055     0.200
    13.540   186.398     0.200
    13.540   185.383     0.200
    16.679   226.215     0.200
     0.757    13.667     0.200
     0.863    15.197     0.200
     0.948    16.737     0.200
     1.183    19.777     0.200
     1.257    21.708     0.200
     1.258    21.717     0.200
     1.270    22.347     0.200
     1.255    20.597     0.200
     1.303    22.317     0.200
     1.308    21.438     0.200
     1.358    22.777     0.200
     1.373    22.837     0.200
     1.423    23.917     0.200
     1.440    23.777     0.200
     1.586    26.038     0.200
     1.681    26.777     0.200
     1.929    30.768     0.200
     2.011    31.897     0.200
     2.022    31.797     0.200
     2.163    34.177     0.200
     2.314    35.847     0.200
     2.342    36.277     0.200
     2.418    37.538     0.200
     2.444    37.998     0.200
     2.655    39.958     0.200
     3.047    45.827     0.200
     3.052    46.197     0.200
     3.060    46.257     0.200
     3.127    47.538     0.200
     3.260    49.157     0.200
     3.259    48.938     0.200
     3.315    49.538     0.200
     3.375    50.677     0.200
     3.353    49.587     0.200
     3.500    50.518     0.200
     3.666    53.607     0.200
     4.063    59.027     0.200
     4.250    61.487     0.200
     4.361    63.177     0.200
     4.539    65.907     0.200
     4.641    67.827     0.200
     4.749    68.667     0.200
     5.055    73.067     0.200
     5.076    73.397     0.200
     5.166    74.697     0.200
     5.313    76.107     0.200
     5.287    76.357     0.200
     5.493    79.137     0.200
     5.563    80.308     0.200
     5.577    79.708     0.200
     5.624    80.157     0.200
     5.652    81.107     0.200
     5.790    83.097     0.200
     5.821    83.597     0.200
     5.843    83.837     0.200
     5.868    84.458     0.200
     5.902    84.438     0.200
     5.954    85.387     0.200
     5.967    85.308     0.200
     6.165    88.527     0.200
     6.223    89.257     0.200
     6.269    89.257     0.200
     6.301    90.228     0.200
     6.381    90.547     0.200
     6.484    92.077     0.200
     6.492    93.597     0.200
     6.697    95.308     0.200
     6.850    97.808     0.200
     6.837    97.167     0.200
     6.902    99.817     0.200
     6.905    97.507     0.200
     6.955    99.308     0.200
     7.111   101.237     0.200
     7.136   100.847     0.200
     7.177   101.617     0.200
     7.177   100.867     0.200
     7.177   101.538     0.200
     7.245   101.978     0.200
     7.874   110.917     0.200
     8.529   120.038     0.200
     8.596   121.487     0.200
     8.706   123.877     0.200
     8.900   125.737     0.200
     9.058   128.018     0.200
     9.099   128.637     0.200
     9.373   131.077     0.200
     9.979   138.407     0.200
    10.339   145.018     0.200
    11.869   166.768     0.200
    11.869   165.998     0.200
    13.246   183.842     0.200
    13.246   184.817     0.200
    19.101   259.112     0.200
    19.101   258.857     0.200
     0.323    10.414     0.200
     0.358    10.676     0.200
     0.411    11.535     0.200
     0.487    12.176     0.200
     0.624    13.404     0.200
     0.756    14.785     0.200
     0.774    15.016     0.200
     0.779    14.926     0.200
     0.832    16.186     0.200
     0.862    16.035     0.200
     0.899    17.186     0.200
     0.907    17.334     0.200
     0.885    16.664     0.200
     0.926    17.824     0.200
     0.945    17.875     0.200
     1.116    19.494     0.200
     1.229    21.686     0.200
     1.238    20.574     0.200
     1.494    24.504     0.200
     1.544    25.625     0.200
     1.589    26.936     0.200
     1.608    26.266     0.200
     1.590    26.244     0.200
     1.599    26.686     0.200
     1.643    26.824     0.200
     1.676    27.324     0.200
     1.669    27.365     0.200
     1.712    27.936     0.200
     1.782    29.084     0.200
     2.088    33.215     0.200
     2.153    34.385     0.200
     2.193    34.914     0.200
     2.711    40.334     0.200
     2.836    43.994     0.200
     2.840    43.074     0.200
     2.889    43.775     0.200
     3.193    48.754     0.200
     3.301    49.555     0.200
     3.370    50.365     0.200
     3.613    52.705     0.200
     3.697    54.885     0.200
     3.878    56.365     0.200
     4.082    59.705     0.200
     4.113    59.426     0.200
     4.286    62.504     0.200
     4.302    61.805     0.200
     4.412    63.664     0.200
     4.533    65.215     0.200
     4.523    66.615     0.200
     4.562    65.965     0.200
     4.630    67.805     0.200
     4.630    67.715     0.200
     4.929    71.705     0.200
     5.279    76.275     0.200
     5.291    76.266     0.200
     5.493    78.855     0.200
     5.563    80.145     0.200
     5.658    80.445     0.200
     5.771    82.475     0.200
     5.816    83.225     0.200
     5.862    83.645     0.200
     6.134    87.266     0.200
     6.220    88.705     0.200
     6.224    88.865     0.200
     6.224    88.605     0.200
     6.261    89.705     0.200
     6.447    91.865     0.200
     6.543    93.535     0.200
     6.600    93.705     0.200
     6.670    95.105     0.200
     6.791    96.965     0.200
     7.046    99.504     0.200
     7.110   100.664     0.200
     7.110   100.615     0.200
     7.110   100.186     0.200
     7.415   104.936     0.200
     7.568   106.945     0.200
     8.035   112.885     0.200
     9.885   138.414     0.200
    12.344   173.365     0.200
    13.296   186.314     0.200
     0.749    14.051     0.200
     1.110    18.891     0.200
     1.267    21.422     0.200
     1.249    20.992     0.200
     1.371    22.590     0.200
     1.424    23.891     0.200
     1.428    24.379     0.200
     1.430    23.750     0.200
     1.419    22.902     0.200
     1.467    25.250     0.200
     1.500    25.242     0.200
     1.517    24.500     0.200
     1.618    26.699     0.200
     1.705    27.461     0.200
     1.815    28.629     0.200
     1.849    29.242     0.200
     1.844    29.840     0.200
     1.852    29.410     0.200
     1.887    30.422     0.200
     1.975    30.891     0.200
     2.116    32.102     0.200
     2.211    34.160     0.200
     2.262    35.031     0.200
     2.299    35.109     0.200
     2.325    35.352     0.200
     2.383    36.730     0.200
     2.393    36.820     0.200
     2.512    37.879     0.200
     2.582    39.410     0.200
     2.731    40.891     0.200
     2.910    43.531     0.200
     2.937    44.473     0.200
     2.941    44.062     0.200
     2.954    44.270     0.200
     2.967    45.352     0.200
     2.939    45.051     0.200
     3.035    45.941     0.200
     3.052    45.141     0.200
     3.209    47.789     0.200
     3.221    48.223     0.200
     3.339    49.281     0.200
     3.476    51.641     0.200
     3.499    51.062     0.200
     3.528    51.449     0.200
     3.572    51.441     0.200
     3.701    54.320     0.200
     3.733    55.039     0.200
     3.732    54.551     0.200
     3.741    54.520     0.200
     3.820    55.723     0.200
     3.856    56.449     0.200
     3.880    57.051     0.200
     3.887    56.742     0.200
     4.084    59.410     0.200
     4.102    60.039     0.200
     4.136    60.652     0.200
     4.222    61.199     0.200
     4.433    63.871     0.200
     4.539    65.082     0.200
     4.631    67.301     0.200
     4.670    67.082     0.200
     4.765    67.832     0.200
     4.937    71.211     0.200
     4.946    71.359     0.200
     5.044    73.039     0.200
     5.125    73.699     0.200
     5.082    73.281     0.200
     5.145    74.051     0.200
     5.099    73.270     0.200
     5.214    75.352     0.200
     5.221    75.410     0.200
     5.242    75.051     0.200
     5.289    76.371     0.200
     5.299    76.652     0.200
     5.283    75.781     0.200
     5.363    76.992     0.200
     5.436    77.852     0.200
     5.566    80.051     0.200
     5.557    79.801     0.200
     5.606    80.949     0.200
     5.718    81.281     0.200
     5.729    82.082     0.200
     5.743    82.371     0.200
     5.836    82.141     0.200
     5.935    83.770     0.200
     5.986    85.742     0.200
     6.047    86.582     0.200
     6.081    86.820     0.200
     6.420    91.582     0.200
     6.491    93.191     0.200
     6.524    93.750     0.200
     6.624    94.039     0.200
     6.676    94.980     0.200
     6.713    95.480     0.200
     6.775    96.062     0.200
     6.774    96.121     0.200
     6.837    97.152     0.200
     6.875    97.312     0.200
     6.873    97.770     0.200
     6.873    97.180     0.200
     7.001    99.039     0.200
     7.575   108.441     0.200
     7.788   109.801     0.200
     8.175   115.891     0.200
     8.240   117.422     0.200
     8.488   120.531     0.200
     8.801   124.852     0.200
     8.991   126.250     0.200
     9.465   132.430     0.200
     9.687   135.090     0.200
    10.541   149.051     0.200
    12.840   180.301     0.200
    18.550   253.645     0.200
     0.347    10.570     0.200
     0.541    12.652     0.200
     0.628    13.602     0.200
     0.738    14.570     0.200
     0.852    16.289     0.200
     0.900    17.391     0.200
     0.920    17.891     0.200
     0.976    17.770     0.200
     0.994    17.770     0.200
     1.000    18.039     0.200
     1.113    19.672     0.200
     1.120    20.250     0.200
     1.229    20.781     0.200
     1.344    22.531     0.200
     1.453    25.152     0.200
     1.480    24.789     0.200
     1.643    27.062     0.200
     1.776    28.191     0.200
     1.806    29.410     0.200
     1.875    30.512     0.200
     2.351    37.121     0.200
     2.562    38.762     0.200
     2.792    42.930     0.200
     2.854    44.152     0.200
     2.922    43.922     0.200
     3.137    47.461     0.200
     3.173    47.379     0.200
     3.266    49.289     0.200
     3.451    50.531     0.200
     3.640    53.891     0.200
     3.754    54.820     0.200
     3.809    55.359     0.200
     3.934    57.250     0.200
     3.959    57.812     0.200
     4.117    58.590     0.200
     4.154    60.371     0.200
     4.236    60.871     0.200
     4.337    62.480     0.200
     4.386    63.500     0.200
     4.484    64.852     0.200
     4.492    66.910     0.200
     4.611    66.480     0.200
     4.687    68.949     0.200
     4.708    69.062     0.200
     4.759    68.812     0.200
     5.027    71.832     0.200
     5.048    72.852     0.200
     5.095    73.551     0.200
     5.241    76.570     0.200
     5.371    77.391     0.200
     5.405    77.789     0.200
     5.447    78.371     0.200
     5.602    80.051     0.200
     5.619    81.340     0.200
     5.650    81.109     0.200
     5.689    82.520     0.200
     5.745    81.949     0.200
     5.899    84.242     0.200
     5.909    84.590     0.200
     5.927    84.789     0.200
     6.015    86.191     0.200
     6.065    86.789     0.200
     6.241    89.371     0.200
     6.330    90.930     0.200
     6.459    92.582     0.200
     6.469    93.129     0.200
     6.506    93.191     0.200
     6.518    92.531     0.200
     6.621    94.211     0.200
     6.686    94.949     0.200
     6.729    95.012     0.200
     6.830    97.129     0.200
     6.840    97.770     0.200
     6.944    98.070     0.200
     7.018    98.406     0.200
     7.215   101.930     0.200
     7.250   103.102     0.200
     7.570   107.699     0.200
     7.811   110.102     0.200
     8.540   120.102     0.200
     8.701   122.680     0.200
     8.918   125.012     0.200
     9.548   134.699     0.200
     9.804   136.750     0.200
    12.119   169.426     0.200
    13.168   182.500     0.200
     0.463    10.998     0.200
     0.463     9.779     0.200
     0.686    13.199     0.200
     0.755    14.149     0.200
     0.778    14.799     0.200
     0.873    16.419     0.200
     0.878    16.179     0.200
     0.866    16.129     0.200
     0.920    16.689     0.200
     0.988    17.669     0.200
     1.016    18.189     0.200
     1.089    19.119     0.200
     1.098    19.669     0.200
     1.128    19.839     0.200
     1.258    21.959     0.200
     1.280    22.569     0.200
     1.305    22.299     0.200
     1.369    23.079     0.200
     1.613    25.969     0.200
     1.649    27.079     0.200
     1.782    28.739     0.200
     1.782    29.489     0.200
     1.880    30.329     0.200
     2.006    32.229     0.200
     2.080    32.349     0.200
     2.353    36.739     0.200
     2.398    37.619     0.200
     2.419    37.609     0.200
     2.524    39.489     0.200
     2.531    39.319     0.200
     2.714    41.669     0.200
     2.815    41.899     0.200
     2.881    42.989     0.200
     2.855    43.639     0.200
     3.013    45.909     0.200
     3.155    47.859     0.200
     3.164    47.699     0.200
     3.169    47.889     0.200
     3.169    47.879     0.200
     3.218    48.869     0.200
     3.238    49.029     0.200
     3.248    48.459     0.200
     3.336    50.009     0.200
     3.460    51.839     0.200
     3.498    52.369     0.200
     3.500    52.039     0.200
     3.617    54.009     0.200
     3.741    54.699     0.200
     3.729    56.809     0.200
     3.838    55.969     0.200
     4.001    58.549     0.200
     4.083    59.109     0.200
     4.122    59.669     0.200
     4.203    60.249     0.200
     4.288    62.299     0.200
     4.366    62.059     0.200
     4.475    64.779     0.200
     4.502    64.689     0.200
     4.579    66.529     0.200
     4.608    66.629     0.200
     4.651    67.739     0.200
     4.791    69.549     0.200
     4.856    71.069     0.200
     4.868    70.139     0.200
     4.838    70.239     0.200
     5.025    72.469     0.200
     5.033    72.639     0.200
     5.029    73.189     0.200
     5.260    75.229     0.200
     5.383    78.619     0.200
     5.555    80.459     0.200
     5.575    80.959     0.200
     5.482    79.979     0.200
     5.602    81.569     0.200
     5.643    80.759     0.200
     5.780    82.379     0.200
     5.810    83.419     0.200
     5.828    83.689     0.200
     5.780    83.659     0.200
     5.914    85.239     0.200
     6.042    86.949     0.200
     6.133    88.289     0.200
     6.179    88.759     0.200
     6.201    89.049     0.200
     6.220    88.869     0.200
     6.286    90.369     0.200
     6.435    92.169     0.200
     6.501    93.269     0.200
     6.636    94.829     0.200
     6.708    95.929     0.200
     6.736    96.779     0.200
     6.869    96.649     0.200
     6.986    99.489     0.200
     7.030    99.839     0.200
     7.080    99.289     0.200
     7.151   103.309     0.200
     7.281   102.779     0.200
     7.268   103.249     0.200
     7.299   103.089     0.200
     7.365   103.119     0.200
     7.364   103.246     0.200
     7.364   103.279     0.200
     7.349   103.809     0.200
     7.528   107.429     0.200
     7.917   111.249     0.200
     7.932   112.379     0.200
     8.562   121.309     0.200
     8.850   125.329     0.200
     8.874   125.119     0.200
     8.985   127.579     0.200
     9.169   129.779     0.200
     9.280   131.669     0.200
     9.281   130.099     0.200
     9.681   137.719     0.200
     9.712   137.059     0.200
     9.959   140.059     0.200
    10.155   141.269     0.200
    10.614   148.569     0.200
    11.431   160.899     0.200
    12.214   171.304     0.200
    13.488   187.179     0.200
    13.488   187.579     0.200
    19.606   266.189     0.200
    20.308   272.752     0.200
    20.580   275.989     0.200
    20.912   279.870     0.200
     0.721    13.234     0.200
     0.582    12.074     0.200
     0.697    13.781     0.200
     0.697    13.016     0.200
     0.836    15.133     0.200
     0.891    15.883     0.200
     0.937    16.953     0.200
     0.925    16.652     0.200
     1.012    17.703     0.200
     1.117    19.133     0.200
     1.098    18.875     0.200
     1.233    20.594     0.200
     1.230    21.074     0.200
     1.285    21.844     0.200
     1.467    24.652     0.200
     1.648    27.543     0.200
     1.676    28.293     0.200
     1.694    28.145     0.200
     2.294    36.035     0.200
     2.276    36.426     0.200
     2.286    35.902     0.200
     2.358    36.625     0.200
     2.406    37.293     0.200
     2.389    36.965     0.200
     2.468    38.855     0.200
     2.467    38.152     0.200
     2.561    38.613     0.200
     2.584    39.184     0.200
     2.777    42.805     0.200
     2.856    43.176     0.200
     2.822    44.016     0.200
     2.838    43.414     0.200
     2.943    45.312     0.200
     2.956    45.414     0.200
     3.257    49.605     0.200
     3.322    48.613     0.200
     3.381    49.914     0.200
     3.509    52.293     0.200
     3.585    53.715     0.200
     3.606    53.676     0.200
     3.639    54.723     0.200
     3.675    54.883     0.200
     3.996    58.574     0.200
     4.249    61.594     0.200
     4.353    63.355     0.200
     4.306    62.516     0.200
     4.578    65.613     0.200
     4.625    66.484     0.200
     4.664    67.645     0.200
     4.710    67.312     0.200
     4.870    69.242     0.200
     4.966    72.414     0.200
     5.013    73.234     0.200
     5.038    71.914     0.200
     5.062    73.055     0.200
     5.158    74.383     0.200
     5.272    76.812     0.200
     5.309    77.914     0.200
     5.323    77.562     0.200
     5.346    77.684     0.200
     5.345    77.812     0.200
     5.295    76.215     0.200
     5.373    77.633     0.200
     5.395    77.812     0.200
     5.455    78.383     0.200
     5.541    79.426     0.200
     5.798    84.176     0.200
     5.760    82.535     0.200
     5.899    84.203     0.200
     6.032    86.793     0.200
     6.026    86.715     0.200
     6.126    87.426     0.200
     6.228    89.414     0.200
     6.272    89.605     0.200
     6.303    90.043     0.200
     6.421    91.855     0.200
     6.509    93.914     0.200
     6.463    92.426     0.200
     6.566    93.902     0.200
     6.603    94.125     0.200
     6.649    94.844     0.200
     6.680    95.324     0.200
     6.724    96.113     0.200
     6.716    95.902     0.200
     6.768    96.914     0.200
     6.972    99.523     0.200
     7.083   101.004     0.200
     7.110   101.285     0.200
     7.200   102.805     0.200
     7.500   105.902     0.200
     7.447   105.543     0.200
     7.511   106.805     0.200
     7.550   106.125     0.200
     7.655   109.105     0.200
     7.748   108.914     0.200
     7.761   109.023     0.200
     7.724   108.984     0.200
     7.842   110.613     0.200
     7.842   109.090     0.200
     7.842   110.664     0.200
     7.795   109.824     0.200
     8.100   114.152     0.200
     8.036   114.164     0.200
     8.201   115.574     0.200
     8.305   117.715     0.200
     8.305   117.453     0.200
     8.941   126.516     0.200
     9.310   131.125     0.200
     9.354   132.145     0.200
     9.493   133.766     0.200
     9.753   137.766     0.200
     9.838   138.152     0.200
    10.176   143.113     0.200
    10.608   150.895     0.200
    11.141   155.090     0.200
    11.141   157.234     0.200
    11.650   162.723     0.200
    12.628   178.586     0.200
    13.988   194.023     0.200
    14.351   199.715     0.200
    15.744   218.379     0.200
    19.890   269.812     0.200
     0.402     9.512     0.200
     0.529    10.654     0.200
     1.571    25.494     0.200
     1.658    26.875     0.200
     1.677    27.605     0.200
     1.786    28.855     0.200
     2.020    32.494     0.200
     2.060    33.164     0.200
     2.069    33.154     0.200
     2.071    32.645     0.200
     2.080    32.365     0.200
     2.298    35.914     0.200
     2.496    37.605     0.200
     2.592    39.936     0.200
     2.647    40.436     0.200
     2.699    41.365     0.200
     3.108    46.705     0.200
     3.210    48.545     0.200
     3.311    48.664     0.200
     3.189    46.984     0.200
     3.212    47.844     0.200
     3.498    50.734     0.200
     3.768    54.215     0.200
     3.810    56.535     0.200
     3.881    57.414     0.200
     3.888    57.895     0.200
     3.941    57.215     0.200
     3.943    58.004     0.200
     3.918    57.504     0.200
     4.059    59.305     0.200
     4.122    60.795     0.200
     4.161    60.244     0.200
     4.423    63.105     0.200
     4.494    64.564     0.200
     4.518    64.715     0.200
     4.616    66.605     0.200
     4.659    66.975     0.200
     4.723    67.885     0.200
     4.714    67.824     0.200
     4.874    70.115     0.200
     5.044    72.295     0.200
     4.953    70.955     0.200
     5.130    74.154     0.200
     5.211    75.215     0.200
     5.216    75.234     0.200
     5.260    75.465     0.200
     5.361    76.855     0.200
     5.517    79.514     0.200
     5.624    80.484     0.200
     5.768    82.814     0.200
     5.818    83.135     0.200
     5.845    84.686     0.200
     5.963    85.324     0.200
     5.983    85.674     0.200
     6.096    87.264     0.200
     6.092    86.984     0.200
     6.159    88.115     0.200
     6.156    88.084     0.200
     6.195    88.984     0.200
     6.214    88.725     0.200
     6.216    89.295     0.200
     6.242    89.064     0.200
     6.273    89.525     0.200
     6.305    90.084     0.200
     6.416    91.904     0.200
     6.560    93.465     0.200
     6.575    93.994     0.200
     6.606    94.484     0.200
     6.619    94.924     0.200
     6.758    97.744     0.200
     6.892    97.904     0.200
     7.030   100.525     0.200
     7.115   101.164     0.200
     7.359   104.686     0.200
     7.394   105.525     0.200
     7.484   107.275     0.200
     7.600   107.105     0.200
     7.741   109.924     0.200
     7.857   110.111     0.200
     7.857   110.705     0.200
     8.641   121.975     0.200
     8.646   122.584     0.200
     8.775   124.115     0.200
     9.165   129.695     0.200
     9.209   130.215     0.200
     9.173   130.064     0.200
    11.914   167.955     0.200
    13.833   192.357     0.200
    13.833   193.045     0.200
     0.531    11.383     0.200
     0.910    15.992     0.200
     1.009    17.562     0.200
     0.994    17.547     0.200
     0.994    17.102     0.200
     0.994    17.680     0.200
     1.083    18.648     0.200
     1.088    18.492     0.200
     1.164    20.148     0.200
     1.182    20.523     0.200
     1.275    21.258     0.200
     1.359    22.531     0.200
     1.487    24.656     0.200
     1.503    25.172     0.200
     1.620    26.742     0.200
     2.041    32.992     0.200
     2.071    33.430     0.200
     2.078    33.719     0.200
     2.181    34.180     0.200
     2.199    34.531     0.200
     2.522    37.844     0.200
     2.690    41.570     0.200
     2.783    42.906     0.200
     2.935    44.438     0.200
     2.937    43.844     0.200
     2.995    44.859     0.200
     3.220    49.500     0.200
     3.235    49.062     0.200
     3.794    55.500     0.200
     3.826    56.523     0.200
     3.984    59.188     0.200
     4.008    59.359     0.200
     4.034    60.391     0.200
     4.006    58.773     0.200
     4.076    60.531     0.200
     4.344    64.117     0.200
     4.363    64.297     0.200
     4.410    64.219     0.200
     4.501    65.977     0.200
     4.687    67.828     0.200
     4.848    70.203     0.200
     4.992    71.102     0.200
     5.016    71.680     0.200
     5.037    71.922     0.200
     5.109    72.203     0.200
     5.197    74.469     0.200
     5.388    77.500     0.200
     5.408    76.906     0.200
     5.443    77.570     0.200
     5.650    81.953     0.200
     5.663    83.133     0.200
     5.706    81.898     0.200
     5.768    82.078     0.200
     5.823    83.023     0.200
     5.942    84.742     0.200
     6.143    87.000     0.200
     6.187    89.523     0.200
     6.430    91.922     0.200
     6.440    93.609     0.200
     6.639    95.000     0.200
     6.687    95.320     0.200
     6.828    97.953     0.200
     6.919    99.203     0.200
     6.962    99.688     0.200
     7.034    99.922     0.200
     7.135   101.297     0.200
     7.537   106.812     0.200
     7.676   109.719     0.200
     7.748   108.922     0.200
     7.894   112.102     0.200
     7.905   112.781     0.200
     7.961   111.641     0.200
     8.066   114.430     0.200
     8.113   113.844     0.200
     8.158   114.398     0.200
     8.169   114.578     0.200
     8.254   115.891     0.200
     8.254   115.523     0.200
     8.254   115.820     0.200
     8.333   117.617     0.200
     8.437   119.648     0.200
     8.673   123.109     0.200
     8.910   124.711     0.200
     9.286   130.430     0.200
     9.765   137.898     0.200
     9.896   139.969     0.200
    10.092   142.430     0.200
    10.163   143.852     0.200
    10.143   143.008     0.200
    10.511   147.352     0.200
    10.715   151.742     0.200
    11.530   162.008     0.200
    11.530   163.297     0.200
    12.907   181.250     0.200
    14.401   199.648     0.200
    14.401   202.203     0.200
     0.316    14.078     0.200
     0.335    14.258     0.200
     0.477    15.035     0.200
     0.561    15.547     0.200
     0.796    18.137     0.200
     0.843    18.246     0.200
     0.959    19.875     0.200
     1.030    20.598     0.200
     1.245    22.160     0.200
     1.260    21.828     0.200
     1.354    24.875     0.200
     1.373    25.277     0.200
     1.378    25.316     0.200
     2.065    33.965     0.200
     2.202    35.547     0.200
     2.212    35.477     0.200
     2.261    35.887     0.200
     2.516    40.168     0.200
     2.568    39.445     0.200
     2.618    41.488     0.200
     2.643    41.848     0.200
     2.729    41.547     0.200
     2.948    44.625     0.200
     3.088    47.336     0.200
     3.302    50.168     0.200
     3.358    49.547     0.200
     3.366    51.508     0.200
     3.871    57.688     0.200
     3.881    57.078     0.200
     4.227    60.746     0.200
     4.450    64.488     0.200
     4.550    65.555     0.200
     4.569    65.078     0.200
     4.650    66.895     0.200
     4.775    71.168     0.200
     4.817    70.176     0.200
     4.869    69.477     0.200
     4.898    71.328     0.200
     5.057    72.438     0.200
     5.156    74.496     0.200
     5.197    74.305     0.200
     5.207    75.168     0.200
     5.234    75.195     0.200
     5.241    75.656     0.200
     5.416    78.855     0.200
     5.442    77.766     0.200
     5.567    79.645     0.200
     5.636    80.727     0.200
     5.706    82.156     0.200
     5.723    81.855     0.200
     5.822    84.535     0.200
     5.841    85.008     0.200
     5.880    83.578     0.200
     5.928    84.938     0.200
     5.979    86.176     0.200
     5.988    84.957     0.200
     6.038    86.688     0.200
     6.112    87.008     0.200
     6.213    88.047     0.200
     6.251    88.027     0.200
     6.252    89.477     0.200
     6.328    90.195     0.200
     6.390    91.195     0.200
     6.533    93.715     0.200
     6.617    94.188     0.200
     6.639    94.188     0.200
     6.749    95.758     0.200
     6.805    96.996     0.200
     6.888    97.836     0.200
     6.896    98.355     0.200
     6.896    98.535     0.200
     6.930    98.578     0.200
     6.973    98.137     0.200
     7.079    99.125     0.200
     7.117   101.598     0.200
     7.134   100.195     0.200
     7.214   103.195     0.200
     7.254   103.098     0.200
     7.292   101.945     0.200
     7.293   101.547     0.200
     7.315   104.355     0.200
     7.375   104.285     0.200
     7.379   105.297     0.200
     7.383   104.805     0.200
     7.462   106.555     0.200
     7.479   104.566     0.200
     7.481   106.266     0.200
     7.497   106.555     0.200
     7.491   106.746     0.200
     7.567   106.777     0.200
     7.609   105.156     0.200
     7.608   106.316     0.200
     7.608   106.098     0.200
     7.813   109.586     0.200
     7.842   110.707     0.200
     7.868   110.375     0.200
     7.875   111.625     0.200
     7.987   112.367     0.200
     8.044   114.215     0.200
     8.875   124.527     0.200
     9.060   128.406     0.200
     9.175   129.578     0.200
     9.268   129.426     0.200
     9.313   129.855     0.200
     9.482   133.605     0.200
     9.495   132.945     0.200
     9.640   135.836     0.200
    10.353   142.566     0.200
    10.434   146.488     0.200
    10.757   151.605     0.200
    13.002   181.117     0.200
    13.857   190.941     0.200
     1.781    29.365     0.200
     1.873    30.895     0.200
     1.933    32.266     0.200
     1.929    31.955     0.200
     1.956    32.484     0.200
     2.016    32.744     0.200
     2.082    34.484     0.200
     2.076    33.635     0.200
     2.142    35.605     0.200
     2.143    34.924     0.200
     2.219    35.625     0.200
     2.229    35.664     0.200
     2.481    40.145     0.200
     2.444    38.734     0.200
     2.528    41.035     0.200
     2.542    41.355     0.200
     2.566    41.715     0.200
     2.574    41.814     0.200
     2.846    44.945     0.200
     2.916    46.344     0.200
     2.827    43.465     0.200
     2.912    45.225     0.200
     2.921    45.254     0.200
     3.132    48.145     0.200
     3.090    46.605     0.200
     3.261    51.016     0.200
     3.517    53.154     0.200
     3.645    56.215     0.200
     3.670    56.244     0.200
     3.744    57.355     0.200
     3.774    57.715     0.200
     3.776    57.695     0.200
     3.715    55.715     0.200
     3.749    56.025     0.200
     3.948    59.254     0.200
     4.389    65.664     0.200
     4.391    65.965     0.200
     4.351    64.805     0.200
     4.400    66.424     0.200
     4.463    67.484     0.200
     4.468    67.516     0.200
     4.498    67.355     0.200
     4.500    67.455     0.200
     4.574    68.535     0.200
     4.578    68.016     0.200
     4.489    65.975     0.200
     4.781    70.805     0.200
     4.901    71.965     0.200
     5.137    75.084     0.200
     5.157    75.385     0.200
     5.215    76.645     0.200
     5.225    75.355     0.200
     5.362    78.545     0.200
     5.446    79.574     0.200
     5.443    79.965     0.200
     5.516    80.615     0.200
     5.590    81.705     0.200
     5.538    80.334     0.200
     5.676    83.055     0.200
     5.583    80.424     0.200
     5.686    83.035     0.200
     5.774    84.545     0.200
     5.793    84.266     0.200
     5.797    84.164     0.200
     5.898    85.664     0.200
     5.979    86.814     0.200
     5.993    87.225     0.200
     6.099    89.424     0.200
     6.097    88.414     0.200
     6.210    90.545     0.200
     6.294    91.754     0.200
     6.238    89.635     0.200
     6.340    92.885     0.200
     6.383    92.484     0.200
     6.425    93.844     0.200
     6.515    94.725     0.200
     6.552    95.355     0.200
     6.577    95.164     0.200
     6.625    96.584     0.200
     6.653    96.395     0.200
     6.679    97.324     0.200
     6.771    98.035     0.200
     6.732    98.205     0.200
     6.819    98.924     0.200
     6.836    98.994     0.200
     6.854    99.025     0.200
     6.837    98.775     0.200
     6.837    98.965     0.200
     6.902    99.605     0.200
     6.903    99.984     0.200
     6.939   100.584     0.200
     6.977   101.455     0.200
     6.993   101.564     0.200
     6.986   101.234     0.200
     7.084   103.225     0.200
     7.016   100.994     0.200
     7.201   104.004     0.200
     7.204   103.824     0.200
     7.167   103.635     0.200
     7.198   104.365     0.200
     7.357   105.545     0.200
     7.362   106.584     0.200
     7.560   109.234     0.200
     7.500   110.045     0.200
     7.676   110.844     0.200
     7.788   112.145     0.200
     7.997   114.004     0.200
     8.003   114.254     0.200
     8.023   114.924     0.200
     8.175   117.064     0.200
     8.230   117.475     0.200
     8.297   118.605     0.200
     8.375   120.574     0.200
     8.413   120.064     0.200
     8.303   117.344     0.200
     8.438   120.885     0.200
     8.468   120.686     0.200
     8.491   121.154     0.200
     8.491   121.088     0.200
     8.491   121.186     0.200
     8.422   119.285     0.200
     8.538   123.275     0.200
     8.932   127.094     0.200
     9.187   130.775     0.200
     9.136   130.725     0.200
     9.412   133.705     0.200
     9.330   131.715     0.200
     9.465   134.855     0.200
     9.659   139.186     0.200
     9.807   139.174     0.200
     9.855   138.824     0.200
     9.843   140.754     0.200
     9.821   140.635     0.200
    10.061   143.814     0.200
    10.417   148.744     0.200
    10.513   148.455     0.200
    11.119   155.875     0.200
    11.952   167.328     0.200
    11.952   168.404     0.200
    12.153   171.115     0.200
    12.265   173.334     0.200
    12.354   176.504     0.200
    14.476   203.654     0.200
    14.476   204.064     0.200
    19.499   269.205     0.200
    19.920   271.594     0.200
    19.926   271.500     0.200
    20.040   274.094     0.200
    20.741   281.965     0.200
     1.328    22.891     0.200
     1.328    23.211     0.200
     1.328    22.469     0.200
     1.850    30.414     0.200
     1.877    30.789     0.200
     1.939    31.711     0.200
     1.959    31.969     0.200
     1.993    32.469     0.200
     2.027    33.188     0.200
     2.029    32.914     0.200
     2.138    35.117     0.200
     2.174    34.914     0.200
     2.214    35.680     0.200
     2.302    36.711     0.200
     2.405    38.477     0.200
     2.411    39.094     0.200
     2.610    40.047     0.200
     2.701    41.742     0.200
     2.701    41.398     0.200
     2.814    44.898     0.200
     2.849    45.461     0.200
     2.857    45.570     0.200
     3.213    49.133     0.200
     3.234    49.297     0.200
     3.269    50.609     0.200
     3.440    52.102     0.200
     3.465    51.422     0.200
     3.502    52.477     0.200
     3.568    55.148     0.200
     3.958    59.859     0.200
     3.980    60.383     0.200
     4.085    61.812     0.200
     4.090    61.812     0.200
     4.165    59.977     0.200
     4.319    64.000     0.200
     4.722    69.930     0.200
     4.716    69.812     0.200
     4.724    70.648     0.200
     4.740    69.664     0.200
     4.793    71.672     0.200
     4.828    72.094     0.200
     4.914    70.789     0.200
     4.938    73.742     0.200
     4.948    72.320     0.200
     5.132    75.117     0.200
     5.295    77.117     0.200
     5.453    78.133     0.200
     5.518    79.797     0.200
     5.529    79.094     0.200
     5.549    81.141     0.200
     5.555    79.117     0.200
     5.673    81.539     0.200
     5.734    82.578     0.200
     5.744    82.719     0.200
     5.830    83.977     0.200
     5.894    84.797     0.200
     5.921    83.852     0.200
     5.982    85.703     0.200
     6.069    87.141     0.200
     6.080    87.938     0.200
     6.159    88.570     0.200
     6.180    89.031     0.200
     6.186    89.344     0.200
     6.333    90.648     0.200
     6.335    89.898     0.200
     6.373    91.203     0.200
     6.383    91.617     0.200
     6.416    92.648     0.200
     6.484    93.344     0.200
     6.599    94.523     0.200
     6.695    95.461     0.200
     6.760    96.711     0.200
     6.771    97.641     0.200
     6.816    97.852     0.200
     6.902    98.719     0.200
     6.943   100.430     0.200
     6.942    99.211     0.200
     6.974   100.039     0.200
     7.114   101.500     0.200
     7.152   102.492     0.200
     7.209   103.578     0.200
     7.228   103.578     0.200
     7.226   103.961     0.200
     7.227   103.562     0.200
     7.231   104.023     0.200
     7.294   104.148     0.200
     7.331   104.844     0.200
     7.396   106.680     0.200
     7.426   104.852     0.200
     7.467   104.594     0.200
     7.498   106.242     0.200
     7.556   108.391     0.200
     7.546   108.133     0.200
     7.589   108.227     0.200
     7.588   108.578     0.200
     7.687   109.664     0.200
     7.676   110.562     0.200
     7.865   114.500     0.200
     7.907   112.477     0.200
     8.043   115.047     0.200
     8.145   115.164     0.200
     8.313   119.297     0.200
     8.345   118.562     0.200
     8.380   118.500     0.200
     8.386   119.781     0.200
     8.513   121.094     0.200
     8.589   120.547     0.200
     8.626   121.852     0.200
     8.643   123.508     0.200
     8.768   125.039     0.200
     8.795   124.430     0.200
     8.798   125.609     0.200
     8.821   124.211     0.200
     8.856   125.820     0.200
     8.856   124.844     0.200
     8.856   125.109     0.200
     8.915   127.789     0.200
     8.980   126.930     0.200
     9.006   126.344     0.200
     9.006   129.008     0.200
     9.267   132.289     0.200
     9.311   132.219     0.200
     9.493   134.953     0.200
     9.628   134.977     0.200
     9.780   138.562     0.200
     9.917   139.820     0.200
     9.973   141.812     0.200
    10.014   142.570     0.200
    10.159   145.219     0.200
    10.196   143.789     0.200
    10.236   144.953     0.200
    10.393   146.688     0.200
    10.488   148.461     0.200
    10.780   151.172     0.200
    11.629   163.102     0.200
    12.278   172.453     0.200
    12.278   172.281     0.200
    12.363   173.453     0.200
    12.423   175.492     0.200
    12.479   175.719     0.200
    12.479   177.914     0.200
    12.689   181.297     0.200
    12.689   180.281     0.200
    14.863   208.719     0.200
    14.863   208.023     0.200
    15.316   214.117     0.200
    19.501   267.508     0.200
    20.209   274.914     0.200
    20.649   279.570     0.200
     1.503    26.379     0.200
     1.503    26.229     0.200
     2.195    35.830     0.200
     2.217    36.209     0.200
     2.313    37.760     0.200
     2.325    38.148     0.200
     2.334    38.170     0.200
     2.366    38.680     0.200
     2.527    40.469     0.200
     2.673    43.859     0.200
     2.918    45.199     0.200
     3.063    48.850     0.200
     3.100    49.770     0.200
     3.361    52.398     0.200
     3.440    54.020     0.200
     3.495    54.000     0.200
     3.641    55.600     0.200
     3.707    56.639     0.200
     4.207    64.229     0.200
     4.310    65.619     0.200
     4.377    64.469     0.200
     4.706    70.369     0.200
     5.003    75.289     0.200
     5.016    75.170     0.200
     5.034    75.229     0.200
     5.085    75.369     0.200
     5.305    78.510     0.200
     5.437    78.539     0.200
     5.685    82.930     0.200
     5.748    84.840     0.200
     5.796    84.760     0.200
     5.786    84.930     0.200
     5.865    85.920     0.200
     5.965    87.049     0.200
     6.011    87.859     0.200
     6.072    88.580     0.200
     6.106    88.939     0.200
     6.136    87.209     0.200
     6.150    89.539     0.200
     6.253    91.699     0.200
     6.343    93.039     0.200
     6.380    92.850     0.200
     6.634    96.510     0.200
     6.672    96.969     0.200
     6.819    99.859     0.200
     6.852    99.619     0.200
     6.904    99.549     0.200
     6.969   100.979     0.200
     6.986   101.779     0.200
     7.023   101.500     0.200
     7.067   102.479     0.200
     7.161   104.539     0.200
     7.197   104.420     0.200
     7.269   105.920     0.200
     7.299   106.160     0.200
     7.284   105.500     0.200
     7.313   106.600     0.200
     7.350   107.000     0.200
     7.353   106.850     0.200
     7.336   106.379     0.200
     7.555   108.629     0.200
     7.890   113.600     0.200
     8.183   115.340     0.200
     8.232   116.490     0.200
     8.297   119.910     0.200
     8.483   122.500     0.200
     8.540   122.379     0.200
     8.805   126.729     0.200
     9.002   129.260     0.200
     9.002   129.059     0.200
     9.704   137.070     0.200
    10.268   147.770     0.200
    10.273   147.260     0.200
    12.516   179.635     0.200
    14.942   211.959     0.200
    14.942   212.229     0.200
     0.615    12.036     0.200
     0.669    12.477     0.200
     0.717    13.547     0.200
     0.758    14.106     0.200
     0.768    14.276     0.200
     0.821    15.495     0.200
     0.832    15.496     0.200
     0.887    16.196     0.200
     1.044    18.137     0.200
     1.165    19.967     0.200
     1.158    20.057     0.200
     1.188    20.356     0.200
     1.237    21.597     0.200
     1.210    20.917     0.200
     1.340    22.467     0.200
     1.473    24.217     0.200
     1.454    24.326     0.200
     1.505    24.717     0.200
     1.658    27.276     0.200
     1.675    27.496     0.200
     1.688    27.677     0.200
     2.290    35.957     0.200
     2.331    37.217     0.200
     2.353    36.517     0.200
     2.350    36.547     0.200
     2.650    39.717     0.200
     2.750    40.866     0.200
     2.852    43.937     0.200
     2.957    45.276     0.200
     2.993    45.106     0.200
     3.149    47.427     0.200
     3.469    51.517     0.200
     3.623    53.177     0.200
     3.694    55.356     0.200
     3.737    55.507     0.200
     4.051    59.637     0.200
     4.251    61.677     0.200
     4.467    65.396     0.200
     4.756    68.477     0.200
     4.792    68.667     0.200
     4.957    70.227     0.200
     5.091    72.887     0.200
     5.156    73.526     0.200
     5.280    76.316     0.200
     5.289    76.566     0.200
     5.361    77.257     0.200
     5.501    78.637     0.200
     5.620    80.616     0.200
     5.804    83.906     0.200
     5.852    84.026     0.200
     5.923    86.177     0.200
     6.049    86.837     0.200
     6.228    88.486     0.200
     6.322    91.366     0.200
     6.409    91.267     0.200
     6.414    91.236     0.200
     6.423    91.437     0.200
     6.537    92.927     0.200
     6.542    94.076     0.200
     6.706    95.606     0.200
     6.784    96.667     0.200
     6.815    97.127     0.200
     6.866    97.967     0.200
     6.907    98.267     0.200
     7.182   101.837     0.200
     7.309   104.066     0.200
     7.371   104.807     0.200
     7.550   108.576     0.200
     7.557   107.167     0.200
     7.551   108.236     0.200
     7.584   106.057     0.200
     7.837   110.736     0.200
     7.879   110.326     0.200
     7.879   110.786     0.200
     7.909   111.087     0.200
     7.998   113.896     0.200
     8.114   114.047     0.200
     8.089   113.856     0.200
     8.295   117.377     0.200
     8.460   118.786     0.200
     9.418   133.547     0.200
    10.161   140.387     0.200
    10.212   144.087     0.200
    10.285   144.156     0.200
    12.748   178.826     0.200
    14.046   195.127     0.200
    14.232   199.076     0.200
     0.338    11.550     0.200
     0.423    12.350     0.200
     0.686    14.730     0.200
     0.736    15.070     0.200
     0.856    17.070     0.200
     0.858    17.360     0.200
     0.871    17.790     0.200
     0.897    17.290     0.200
     0.947    17.489     0.200
     0.947    17.320     0.200
     1.062    19.150     0.200
     1.569    26.300     0.200
     1.582    26.350     0.200
     1.575    27.050     0.200
     1.623    27.150     0.200
     1.641    27.080     0.200
     1.654    27.500     0.200
     1.686    27.800     0.200
     1.745    28.840     0.200
     1.833    30.160     0.200
     1.929    30.360     0.200
     1.971    30.660     0.200
     2.035    32.810     0.200
     2.140    34.390     0.200
     2.177    34.460     0.200
     2.760    42.370     0.200
     2.806    43.290     0.200
     2.824    42.580     0.200
     2.863    43.980     0.200
     2.876    44.510     0.200
     2.920    44.950     0.200
     3.210    48.830     0.200
     3.279    48.810     0.200
     3.320    50.400     0.200
     3.354    49.600     0.200
     3.368    50.030     0.200
     3.650    54.380     0.200
     3.734    55.980     0.200
     3.862    57.700     0.200
     3.855    56.030     0.200
     3.932    58.180     0.200
     3.935    57.180     0.200
     3.950    59.060     0.200
     4.058    58.920     0.200
     4.115    59.000     0.200
     4.143    60.180     0.200
     4.309    61.280     0.200
     4.413    63.280     0.200
     4.466    66.580     0.200
     4.546    65.250     0.200
     4.554    67.020     0.200
     4.796    68.950     0.200
     4.870    70.410     0.200
     4.910    71.700     0.200
     4.928    70.720     0.200
     4.986    71.560     0.200
     4.991    72.660     0.200
     5.230    74.630     0.200
     5.232    76.470     0.200
     5.240    76.560     0.200
     5.435    78.920     0.200
     5.450    78.000     0.200
     5.455    78.600     0.200
     5.467    78.790     0.200
     5.535    79.540     0.200
     5.596    80.780     0.200
     5.680    81.040     0.200
     5.730    82.560     0.200
     5.763    82.560     0.200
     5.780    82.560     0.200
     5.806    82.970     0.200
     5.847    83.670     0.200
     5.890    84.380     0.200
     6.031    86.500     0.200
     6.100    87.130     0.200
     6.238    88.580     0.200
     6.265    90.480     0.200
     6.275    89.560     0.200
     6.280    89.560     0.200
     6.387    91.250     0.200
     6.473    92.240     0.200
     6.479    91.620     0.200
     6.559    92.560     0.200
     6.604    93.250     0.200
     6.695    95.560     0.200
     6.696    94.830     0.200
     6.748    95.830     0.200
     6.772    95.560     0.200
     6.780    97.410     0.200
     6.821    97.450     0.200
     6.967    98.590     0.200
     6.975    98.680     0.200
     7.073    98.110     0.200
     7.073    99.320     0.200
     7.073    99.870     0.200
     7.076   100.250     0.200
     7.158   101.140     0.200
     7.215   102.460     0.200
     7.217   102.720     0.200
     7.472   105.270     0.200
     7.502   107.270     0.200
     7.603   107.820     0.200
     8.077   113.620     0.200
     8.139   114.560     0.200
     8.227   116.780     0.200
     8.518   120.210     0.200
     8.525   120.470     0.200
     8.529   120.040     0.200
     8.607   121.290     0.200
     8.663   121.400     0.200
     8.854   125.030     0.200
     8.896   124.330     0.200
     8.976   125.070     0.200
     9.448   131.520     0.200
     9.541   135.220     0.200
     9.790   136.370     0.200
     9.843   136.370     0.200
     9.862   139.430     0.200
    10.153   142.300     0.200
    10.334   145.820     0.200
    12.387   173.795     0.200
    12.387   173.660     0.200
    13.272   183.820     0.200
    13.272   183.140     0.200
    19.926   269.040     0.200
     0.426     9.139     0.200
     0.542    10.499     0.200
     1.230    21.069     0.200
     1.178    19.655     0.200
     1.178    19.859     0.200
     1.178    20.099     0.200
     1.309    22.299     0.200
     1.334    22.529     0.200
     1.348    22.499     0.200
     1.408    23.519     0.200
     1.549    25.569     0.200
     1.600    26.369     0.200
     1.727    28.239     0.200
     2.126    32.919     0.200
     2.169    33.419     0.200
     2.209    34.619     0.200
     2.257    34.579     0.200
     2.437    36.409     0.200
     2.420    38.749     0.200
     2.860    43.109     0.200
     3.013    45.349     0.200
     2.986    45.559     0.200
     2.997    45.969     0.200
     3.048    46.039     0.200
     3.170    48.579     0.200
     3.283    48.849     0.200
     3.522    53.019     0.200
     3.567    53.949     0.200
     3.583    53.869     0.200
     3.616    54.789     0.200
     3.688    55.359     0.200
     3.701    55.659     0.200
     3.717    55.549     0.200
     3.883    56.079     0.200
     4.188    61.939     0.200
     4.350    64.289     0.200
     4.461    66.059     0.200
     4.548    65.639     0.200
     4.594    66.389     0.200
     4.682    67.219     0.200
     4.713    68.339     0.200
     4.719    68.569     0.200
     4.827    70.429     0.200
     4.916    70.029     0.200
     4.926    70.869     0.200
     5.142    74.359     0.200
     5.190    75.869     0.200
     5.266    75.509     0.200
     5.296    75.789     0.200
     5.326    76.319     0.200
     5.358    76.209     0.200
     5.501    79.269     0.200
     5.496    77.569     0.200
     5.614    80.119     0.200
     5.655    80.669     0.200
     5.658    80.639     0.200
     5.684    81.809     0.200
     5.757    82.239     0.200
     5.852    83.599     0.200
     5.913    83.749     0.200
     5.989    85.749     0.200
     6.015    87.279     0.200
     6.005    85.739     0.200
     6.016    86.019     0.200
     6.094    86.819     0.200
     6.170    87.719     0.200
     6.194    88.549     0.200
     6.252    89.209     0.200
     6.266    88.949     0.200
     6.359    90.059     0.200
     6.441    90.789     0.200
     6.540    94.049     0.200
     6.562    93.549     0.200
     6.665    94.409     0.200
     6.770    96.899     0.200
     6.786    97.529     0.200
     6.739    95.619     0.200
     6.819    96.709     0.200
     6.844    97.029     0.200
     6.966    99.489     0.200
     6.947    98.489     0.200
     6.969    98.509     0.200
     6.994    99.529     0.200
     7.097   101.349     0.200
     7.167   101.139     0.200
     7.139   101.129     0.200
     7.149   101.309     0.200
     7.250   103.509     0.200
     7.228   102.539     0.200
     7.310   104.489     0.200
     7.274   102.789     0.200
     7.312   103.489     0.200
     7.333   103.899     0.200
     7.420   105.869     0.200
     7.501   106.369     0.200
     7.684   107.089     0.200
     7.640   107.989     0.200
     7.717   109.179     0.200
     7.682   108.749     0.200
     7.797   109.559     0.200
     7.922   111.849     0.200
     8.014   112.489     0.200
     8.078   113.399     0.200
     8.061   113.459     0.200
     8.198   116.309     0.200
     8.182   115.129     0.200
     8.244   116.999     0.200
     8.244   116.999     0.200
     8.231   115.549     0.200
     8.290   116.299     0.200
     8.330   118.269     0.200
     8.489   120.779     0.200
     8.504   119.489     0.200
     8.484   120.329     0.200
     8.578   119.439     0.200
     8.577   120.149     0.200
     8.577   120.749     0.200
     8.622   122.309     0.200
     8.754   124.489     0.200
     8.689   122.609     0.200
     8.753   123.809     0.200
     8.780   123.969     0.200
     8.729   122.369     0.200
     9.034   127.699     0.200
     9.056   127.759     0.200
     9.076   127.099     0.200
     9.354   132.549     0.200
     9.340   130.629     0.200
     9.440   133.429     0.200
    10.046   141.939     0.200
    10.151   142.919     0.200
    10.242   143.999     0.200
    10.445   146.079     0.200
    10.491   148.579     0.200
    10.439   146.999     0.200
    10.648   149.419     0.200
    10.689   149.339     0.200
    10.993   154.839     0.200
    11.799   167.459     0.200
    11.883   168.369     0.200
    11.883   167.206     0.200
    12.919   181.919     0.200
    12.975   182.888     0.200
    12.976   182.549     0.200
    14.693   204.199     0.200
    15.806   220.999     0.200
    19.979   271.849     0.200
    20.211   274.339     0.200
    20.571   278.147     0.200
    20.752   280.609     0.200
     0.650    14.758     0.200
     0.714    14.945     0.200
     0.754    15.117     0.200
     0.748    15.844     0.200
     0.821    16.008     0.200
     0.856    16.477     0.200
     0.933    17.414     0.200
     0.931    17.727     0.200
     1.035    18.953     0.200
     1.077    19.352     0.200
     1.246    21.617     0.200
     1.226    21.938     0.200
     1.597    25.258     0.200
     1.513    25.156     0.200
     1.577    25.977     0.200
     1.660    26.867     0.200
     1.837    29.508     0.200
     1.857    30.297     0.200
     1.865    30.094     0.200
     1.928    31.062     0.200
     2.154    33.594     0.200
     2.346    36.625     0.200
     2.408    37.648     0.200
     2.513    39.164     0.200
     2.524    39.281     0.200
     2.782    42.328     0.200
     2.907    43.102     0.200
     3.211    47.258     0.200
     3.170    47.758     0.200
     3.165    47.438     0.200
     3.557    52.531     0.200
     4.191    60.852     0.200
     4.302    61.758     0.200
     4.343    62.086     0.200
     4.473    63.898     0.200
     4.538    64.344     0.200
     4.601    66.148     0.200
     4.681    67.719     0.200
     4.715    67.188     0.200
     4.865    70.172     0.200
     4.972    71.992     0.200
     5.092    72.906     0.200
     5.128    74.156     0.200
     5.832    82.586     0.200
     5.934    85.438     0.200
     6.075    86.398     0.200
     6.400    91.812     0.200
     7.068    98.266     0.200
     7.399   102.078     0.200
     7.899   110.648     0.200
     8.070   113.094     0.200
     9.851   138.156     0.200
     1.756    31.768     0.200
     2.105    36.307     0.200
     2.195    37.178     0.200
     2.334    40.098     0.200
     2.432    41.406     0.200
     2.605    42.457     0.200
     2.710    44.598     0.200
     3.469    55.387     0.200
     3.948    61.938     0.200
     4.094    64.287     0.200
     4.189    65.557     0.200
     4.376    67.178     0.200
     4.550    69.797     0.200
     4.665    71.387     0.200
     4.916    76.047     0.200
     4.955    75.336     0.200
     4.974    76.518     0.200
     5.359    80.986     0.200
     5.429    82.037     0.200
     5.704    85.178     0.200
     5.764    87.727     0.200
     6.038    89.807     0.200
     6.050    91.557     0.200
     6.198    93.268     0.200
     6.235    92.896     0.200
     6.271    92.887     0.200
     6.574    98.727     0.200
     6.746   100.357     0.200
     7.132   105.518     0.200
     7.150   105.518     0.200
     7.347   108.297     0.200
     7.523   111.188     0.200
     7.531   111.496     0.200
     7.670   112.756     0.200
     7.669   112.768     0.200
     7.669   112.816     0.200
     7.671   113.896     0.200
     7.900   116.547     0.200
     8.012   117.156     0.200
     8.891   129.387     0.200
     9.371   136.057     0.200
     9.605   140.447     0.200
    10.748   155.506     0.200
    13.199   188.242     0.200
    13.944   197.191     0.200
     0.438    11.641     0.200
     0.730    15.133     0.200
     0.749    15.664     0.200
     0.722    14.711     0.200
     0.768    15.723     0.200
     0.777    16.102     0.200
     0.802    15.703     0.200
     0.897    16.832     0.200
     0.877    16.332     0.200
     1.112    19.504     0.200
     1.154    20.344     0.200
     1.250    21.391     0.200
     1.313    23.082     0.200
     1.284    21.922     0.200
     1.359    23.391     0.200
     1.345    22.922     0.200
     1.401    23.082     0.200
     1.406    23.801     0.200
     1.379    23.301     0.200
     1.447    24.281     0.200
     1.460    24.223     0.200
     1.651    26.734     0.200
     1.819    29.324     0.200
     1.884    30.344     0.200
     1.868    30.004     0.200
     1.879    30.074     0.200
     1.914    31.133     0.200
     1.950    31.121     0.200
     1.989    32.242     0.200
     2.002    32.094     0.200
     1.985    31.664     0.200
     2.044    32.434     0.200
     2.132    32.773     0.200
     2.133    34.121     0.200
     2.350    38.371     0.200
     2.427    36.551     0.200
     2.638    40.824     0.200
     2.638    40.824     0.200
     2.746    42.461     0.200
     2.769    42.984     0.200
     2.764    41.703     0.200
     2.973    45.793     0.200
     3.030    45.781     0.200
     3.086    45.863     0.200
     3.107    47.172     0.200
     3.119    46.723     0.200
     3.191    48.191     0.200
     3.330    49.031     0.200
     3.473    51.691     0.200
     3.609    52.691     0.200
     3.634    53.254     0.200
     3.674    53.652     0.200
     3.814    55.594     0.200
     3.828    55.031     0.200
     3.847    56.551     0.200
     4.018    57.391     0.200
     4.013    58.594     0.200
     4.053    59.602     0.200
     4.127    59.551     0.200
     4.150    60.031     0.200
     4.237    61.172     0.200
     4.250    61.324     0.200
     4.322    63.723     0.200
     4.352    63.551     0.200
     4.478    64.633     0.200
     4.507    64.984     0.200
     4.521    65.863     0.200
     4.687    67.594     0.200
     4.707    68.703     0.200
     4.868    70.324     0.200
     4.848    70.672     0.200
     4.936    70.504     0.200
     4.946    71.234     0.200
     4.981    71.734     0.200
     5.050    73.723     0.200
     5.150    73.832     0.200
     5.169    74.734     0.200
     5.158    74.574     0.200
     5.246    75.754     0.200
     5.305    76.391     0.200
     5.299    76.551     0.200
     5.300    76.801     0.200
     5.380    77.113     0.200
     5.488    78.551     0.200
     5.494    79.133     0.200
     5.516    79.301     0.200
     5.528    79.594     0.200
     5.552    79.234     0.200
     5.588    80.133     0.200
     5.603    80.922     0.200
     5.669    80.492     0.200
     5.734    82.293     0.200
     5.773    82.574     0.200
     5.857    83.754     0.200
     5.940    84.691     0.200
     5.948    85.293     0.200
     5.952    85.531     0.200
     5.982    85.133     0.200
     6.087    87.594     0.200
     6.101    87.613     0.200
     6.183    89.344     0.200
     6.306    89.914     0.200
     6.345    90.902     0.200
     6.357    89.852     0.200
     6.396    91.793     0.200
     6.394    90.562     0.200
     6.521    93.734     0.200
     6.530    92.801     0.200
     6.539    93.551     0.200
     6.569    92.852     0.200
     6.777    95.883     0.200
     6.768    95.734     0.200
     6.782    95.891     0.200
     6.860    96.312     0.200
     6.860    96.441     0.200
     7.072    99.961     0.200
     7.132   101.164     0.200
     7.174   101.402     0.200
     7.398   105.262     0.200
     7.782   109.734     0.200
     7.797   109.914     0.200
     8.314   117.891     0.200
     8.405   118.734     0.200
     8.579   121.664     0.200
     8.748   121.164     0.200
     8.816   123.363     0.200
     9.571   133.543     0.200
     9.653   133.734     0.200
     9.643   133.781     0.200
     9.863   138.184     0.200
    12.094   168.188     0.200
    13.026   180.586     0.200
     0.058    13.789     0.200
     0.308    13.607     0.200
     0.353    14.449     0.200
     0.546    15.828     0.200
     0.586    16.379     0.200
     0.718    17.398     0.200
     0.723    16.928     0.200
     0.933    20.338     0.200
     0.948    20.498     0.200
     0.953    20.488     0.200
     1.352    24.277     0.200
     1.553    27.668     0.200
     1.618    28.479     0.200
     1.769    30.039     0.200
     1.865    30.799     0.200
     1.991    30.738     0.200
     2.036    34.018     0.200
     2.125    35.549     0.200
     2.142    33.777     0.200
     2.213    36.498     0.200
     2.253    36.559     0.200
     2.671    41.148     0.200
     2.698    43.619     0.200
     2.761    42.369     0.200
     2.867    45.049     0.200
     2.937    43.818     0.200
     2.937    46.209     0.200
     2.944    46.568     0.200
     2.986    46.668     0.200
     3.163    47.559     0.200
     3.353    51.289     0.200
     3.430    52.289     0.200
     3.439    51.658     0.200
     3.551    53.459     0.200
     3.632    54.889     0.200
     3.713    55.578     0.200
     3.811    55.898     0.200
     4.007    58.268     0.200
     4.007    58.389     0.200
     4.110    59.818     0.200
     4.207    61.598     0.200
     4.213    60.857     0.200
     4.213    61.088     0.200
     4.336    61.879     0.200
     4.390    63.418     0.200
     4.426    63.857     0.200
     4.458    66.639     0.200
     4.489    67.488     0.200
     4.543    64.549     0.200
     4.633    66.498     0.200
     4.657    67.238     0.200
     4.745    68.328     0.200
     4.793    68.869     0.200
     4.794    69.238     0.200
     5.001    73.348     0.200
     5.010    74.199     0.200
     5.022    72.148     0.200
     5.028    72.229     0.200
     5.138    73.988     0.200
     5.186    75.469     0.200
     5.233    76.078     0.200
     5.245    75.318     0.200
     5.261    75.768     0.200
     5.296    77.398     0.200
     5.471    78.078     0.200
     5.546    79.738     0.200
     5.551    79.658     0.200
     5.551    79.789     0.200
     5.573    80.658     0.200
     5.604    80.629     0.200
     5.639    81.188     0.200
     5.660    80.928     0.200
     5.669    80.969     0.200
     5.712    81.619     0.200
     5.738    84.008     0.200
     5.799    83.449     0.200
     5.817    83.748     0.200
     5.871    84.229     0.200
     5.942    84.789     0.200
     5.952    84.938     0.200
     6.086    87.289     0.200
     6.105    87.607     0.200
     6.135    87.277     0.200
     6.156    87.828     0.200
     6.197    88.289     0.200
     6.223    88.658     0.200
     6.232    89.668     0.200
     6.300    90.248     0.200
     6.344    92.209     0.200
     6.414    92.059     0.200
     6.417    91.357     0.200
     6.546    92.799     0.200
     6.645    93.607     0.200
     6.724    95.408     0.200
     6.853    96.488     0.200
     6.853    96.600     0.200
     6.859    96.318     0.200
     6.932    98.389     0.200
     6.995    98.789     0.200
     7.046    99.209     0.200
     7.049    99.299     0.200
     7.049    99.219     0.200
     7.095   101.527     0.200
     7.124   101.318     0.200
     7.172   100.648     0.200
     7.171   100.766     0.200
     7.171   100.719     0.200
     7.245   102.418     0.200
     7.348   103.279     0.200
     7.352   104.348     0.200
     7.357   103.959     0.200
     7.370   103.357     0.200
     7.455   105.988     0.200
     7.472   106.818     0.200
     7.610   107.738     0.200
     7.612   108.148     0.200
     7.623   108.389     0.200
     7.639   107.748     0.200
     7.650   108.119     0.200
     7.684   109.018     0.200
     7.755   109.338     0.200
     7.753   110.799     0.200
     8.017   115.908     0.200
     8.269   116.969     0.200
     8.367   117.578     0.200
     8.795   124.139     0.200
     8.826   123.398     0.200
     8.913   125.518     0.200
     9.045   127.098     0.200
     9.062   126.229     0.200
     9.827   137.758     0.200
     9.911   138.789     0.200
    10.061   141.277     0.200
    10.156   142.688     0.200
    10.233   140.928     0.200
    10.287   145.969     0.200
    10.348   144.527     0.200
    10.348   144.678     0.200
    10.449   145.449     0.200
    11.263   156.896     0.200
    11.934   163.578     0.200
    11.991   164.998     0.200
    12.679   177.039     0.200
    13.337   183.469     0.200
    13.414   184.963     0.200
    14.367   197.758     0.200
     0.346    19.988     0.200
     0.365    20.211     0.200
     0.453    20.590     0.200
     0.457    20.648     0.200
     0.544    21.020     0.200
     0.571    21.027     0.200
     0.676    21.648     0.200
     0.701    22.070     0.200
     0.695    21.891     0.200
     1.122    25.711     0.200
     1.123    25.969     0.200
     1.145    26.051     0.200
     1.666    31.398     0.200
     1.720    31.961     0.200
     1.696    30.117     0.200
     1.834    31.578     0.200
     2.077    36.121     0.200
     2.115    36.590     0.200
     2.150    36.988     0.200
     2.155    37.320     0.200
     2.186    37.438     0.200
     2.219    37.211     0.200
     2.279    38.527     0.200
     2.349    39.461     0.200
     2.385    39.719     0.200
     2.438    40.051     0.200
     2.471    40.000     0.200
     2.522    41.238     0.200
     2.916    46.730     0.200
     2.916    46.609     0.200
     2.941    46.980     0.200
     2.971    45.801     0.200
     3.042    48.469     0.200
     3.270    50.461     0.200
     3.332    51.109     0.200
     3.382    51.980     0.200
     3.554    54.449     0.200
     3.650    54.898     0.200
     3.751    57.309     0.200
     4.096    60.301     0.200
     4.196    61.301     0.200
     4.212    63.551     0.200
     4.340    63.301     0.200
     4.389    64.398     0.200
     4.445    68.500     0.200
     4.429    64.340     0.200
     4.627    67.160     0.200
     4.649    67.621     0.200
     4.651    68.520     0.200
     4.879    70.270     0.200
     4.954    72.219     0.200
     4.943    72.320     0.200
     4.950    73.859     0.200
     5.024    72.340     0.200
     5.056    74.180     0.200
     5.155    74.570     0.200
     5.316    77.129     0.200
     5.291    76.938     0.200
     5.340    77.379     0.200
     5.427    78.098     0.200
     5.627    80.598     0.200
     5.629    81.969     0.200
     5.767    82.598     0.200
     5.812    82.578     0.200
     5.817    83.621     0.200
     5.820    83.938     0.200
     5.874    84.328     0.200
     5.895    85.559     0.200
     5.930    84.641     0.200
     5.945    85.801     0.200
     6.014    86.629     0.200
     6.103    87.461     0.200
     6.126    86.848     0.200
     6.194    88.348     0.200
     6.266    90.711     0.200
     6.271    90.051     0.200
     6.333    90.578     0.200
     6.397    90.738     0.200
     6.494    92.840     0.200
     6.528    93.938     0.200
     6.561    94.238     0.200
     6.675    93.910     0.200
     6.697    94.059     0.200
     6.697    95.758     0.200
     6.805    97.277     0.200
     6.911    97.188     0.200
     6.907    99.258     0.200
     7.077    98.910     0.200
     7.091    99.738     0.200
     7.243   101.098     0.200
     7.243   101.098     0.200
     7.243   101.039     0.200
     7.318   103.879     0.200
     7.315   103.250     0.200
     7.394   105.230     0.200
     7.427   105.020     0.200
     7.512   107.320     0.200
     7.579   109.500     0.200
     7.560   107.320     0.200
     7.771   110.551     0.200
     7.791   110.508     0.200
     7.940   110.898     0.200
     7.962   113.277     0.200
     7.988   113.629     0.200
     8.018   112.520     0.200
     8.054   113.289     0.200
     8.071   113.668     0.200
     8.711   123.738     0.200
     8.786   124.410     0.200
     8.824   124.898     0.200
     8.853   125.109     0.200
     8.931   124.289     0.200
     9.010   124.848     0.200
     9.053   127.641     0.200
     9.105   126.270     0.200
     9.190   129.527     0.200
     9.284   130.348     0.200
     9.569   132.668     0.200
    10.270   143.859     0.200
    10.466   146.070     0.200
    10.621   149.789     0.200
    10.730   148.379     0.200
    10.920   152.090     0.200
    12.446   170.250     0.200
    13.552   185.449     0.200
    13.552   186.188     0.200
    13.957   191.770     0.200
     1.270    20.586     0.200
     1.375    23.176     0.200
     1.320    22.406     0.200
     1.484    25.184     0.200
     1.457    24.863     0.200
     1.495    25.344     0.200
     1.497    25.293     0.200
     1.649    26.293     0.200
     1.835    29.645     0.200
     1.911    31.086     0.200
     1.895    30.266     0.200
     1.957    31.406     0.200
     2.019    32.555     0.200
     2.262    34.133     0.200
     2.195    34.445     0.200
     2.308    35.926     0.200
     2.348    36.633     0.200
     2.383    36.926     0.200
     2.468    37.906     0.200
     3.091    46.184     0.200
     3.104    46.906     0.200
     3.126    48.273     0.200
     3.198    47.414     0.200
     3.234    48.805     0.200
     3.333    49.574     0.200
     3.487    51.426     0.200
     3.517    52.113     0.200
     3.595    52.105     0.200
     3.642    53.156     0.200
     3.667    53.535     0.200
     3.636    53.984     0.200
     3.698    54.914     0.200
     3.815    56.246     0.200
     3.878    56.785     0.200
     4.021    58.035     0.200
     4.087    59.824     0.200
     4.232    61.254     0.200
     4.245    62.754     0.200
     4.281    63.016     0.200
     4.405    63.406     0.200
     4.433    64.746     0.200
     4.580    66.285     0.200
     4.491    66.344     0.200
     4.738    68.953     0.200
     5.191    74.945     0.200
     5.356    78.164     0.200
     5.337    77.516     0.200
     5.361    77.434     0.200
     5.431    78.715     0.200
     5.581    81.484     0.200
     5.712    82.305     0.200
     5.736    83.023     0.200
     5.953    85.625     0.200
     6.214    90.066     0.200
     6.552    91.605     0.200
     6.661    96.145     0.200
     6.892    98.645     0.200
     6.921    98.344     0.200
     7.009    99.043     0.200
     7.009    98.746     0.200
     7.009    98.883     0.200
     7.005    99.344     0.200
     7.889   111.516     0.200
     8.611   122.164     0.200
     8.942   127.164     0.200
     8.936   126.934     0.200
     9.110   127.516     0.200
     9.140   130.535     0.200
     9.333   132.113     0.200
     9.962   137.816     0.200
     1.503    28.002     0.200
     2.597    42.521     0.200
     2.664    43.492     0.200
     2.901    47.961     0.200
     2.952    48.291     0.200
     3.432    55.271     0.200
     3.750    58.471     0.200
     3.846    60.150     0.200
     3.951    61.451     0.200
     3.954    61.400     0.200
     4.167    64.461     0.200
     4.361    66.082     0.200
     4.529    69.811     0.200
     4.521    69.311     0.200
     4.749    71.941     0.200
     4.824    73.512     0.200
     4.867    74.002     0.200
     5.160    78.391     0.200
     5.278    79.912     0.200
     5.319    81.141     0.200
     5.420    82.201     0.200
     5.505    84.061     0.200
     5.590    85.320     0.200
     5.602    84.021     0.200
     5.686    85.582     0.200
     5.640    85.832     0.200
     5.890    89.551     0.200
     5.937    88.861     0.200
     6.258    93.352     0.200
     6.419    95.400     0.200
     6.532    96.561     0.200
     6.535    96.320     0.200
     6.617    98.141     0.200
     6.633    97.961     0.200
     6.677    99.441     0.200
     6.760   100.082     0.200
     6.825   100.980     0.200
     6.829   101.271     0.200
     6.865   101.242     0.200
     6.939   101.932     0.200
     6.939   102.352     0.200
     7.113   104.121     0.200
     7.321   106.701     0.200
     7.341   107.471     0.200
     7.388   108.422     0.200
     7.496   109.881     0.200
     7.881   115.291     0.200
     8.040   116.521     0.200
     8.527   125.631     0.200
     8.566   124.492     0.200
     8.778   127.852     0.200
     8.836   128.400     0.200
     9.714   139.061     0.200
     9.908   143.811     0.200
     9.977   144.051     0.200
    10.166   148.432     0.200
    11.005   157.900     0.200
    12.428   178.162     0.200
    12.428   178.656     0.200
    13.163   187.662     0.200
    13.163   186.932     0.200
    13.211   189.711     0.200
    14.631   209.570     0.200
     1.792    30.704     0.200
     2.224    37.894     0.200
     2.567    41.534     0.200
     2.603    42.504     0.200
     2.616    43.074     0.200
     2.653    42.784     0.200
     2.916    47.023     0.200
     2.969    47.684     0.200
     3.056    49.374     0.200
     3.141    50.104     0.200
     3.459    54.233     0.200
     3.709    57.193     0.200
     3.813    58.983     0.200
     3.807    58.934     0.200
     3.909    60.164     0.200
     3.974    61.074     0.200
     4.016    62.233     0.200
     4.049    60.854     0.200
     4.129    63.354     0.200
     4.346    65.804     0.200
     4.520    67.414     0.200
     4.737    71.034     0.200
     4.748    72.084     0.200
     4.950    74.994     0.200
     5.165    77.233     0.200
     5.187    77.674     0.200
     5.261    79.384     0.200
     5.345    80.693     0.200
     5.373    80.903     0.200
     5.519    82.624     0.200
     5.530    83.834     0.200
     5.530    82.764     0.200
     5.657    84.443     0.200
     5.656    84.874     0.200
     5.825    86.414     0.200
     5.860    87.174     0.200
     5.900    87.144     0.200
     5.948    88.733     0.200
     6.058    89.063     0.200
     6.117    90.964     0.200
     6.154    90.313     0.200
     6.258    92.114     0.200
     6.359    94.313     0.200
     6.459    95.074     0.200
     6.506    97.664     0.200
     6.562    96.934     0.200
     6.572    96.874     0.200
     6.635    98.164     0.200
     6.716    98.834     0.200
     6.763    99.914     0.200
     6.766    99.924     0.200
     6.881   100.734     0.200
     6.881   101.034     0.200
     7.073   103.434     0.200
     7.238   105.614     0.200
     7.405   107.943     0.200
     7.370   108.604     0.200
     7.517   109.504     0.200
     7.825   114.594     0.200
     7.948   115.514     0.200
     7.997   116.614     0.200
     8.071   118.804     0.200
     8.135   118.124     0.200
     8.193   119.284     0.200
     8.168   119.094     0.200
     8.535   123.474     0.200
     8.528   123.334     0.200
     8.547   124.224     0.200
     8.681   125.844     0.200
     8.750   126.313     0.200
     8.812   126.724     0.200
     9.065   130.334     0.200
     9.593   139.044     0.200
     9.582   137.574     0.200
     9.638   137.954     0.200
     9.806   140.054     0.200
     9.939   145.693     0.200
     9.893   141.004     0.200
    10.090   147.834     0.200
    12.456   177.974     0.200
    12.456   177.646     0.200
    13.117   186.744     0.200
    13.117   186.517     0.200
    13.203   188.874     0.200
    19.638   270.914     0.200
     0.750    16.121     0.200
     0.792    16.723     0.200
     0.792    16.742     0.200
     0.925    16.914     0.200
     1.016    19.141     0.200
     1.087    19.801     0.200
     1.096    20.223     0.200
     1.233    21.793     0.200
     1.275    22.191     0.200
     1.330    22.902     0.200
     1.396    23.293     0.200
     1.451    24.781     0.200
     1.525    24.484     0.200
     1.493    25.203     0.200
     1.642    26.891     0.200
     1.764    28.734     0.200
     1.894    30.562     0.200
     2.155    33.043     0.200
     2.189    33.832     0.200
     2.304    34.852     0.200
     2.578    39.871     0.200
     2.806    42.344     0.200
     2.819    42.664     0.200
     2.928    44.312     0.200
     3.337    49.184     0.200
     3.388    49.691     0.200
     3.434    50.434     0.200
     3.554    51.543     0.200
     3.594    52.852     0.200
     3.783    55.324     0.200
     3.854    56.023     0.200
     3.962    57.531     0.200
     3.935    59.094     0.200
     4.107    60.191     0.200
     4.230    61.703     0.200
     4.213    62.133     0.200
     4.311    62.262     0.200
     4.377    63.742     0.200
     4.574    66.414     0.200
     4.533    66.012     0.200
     4.528    65.953     0.200
     4.672    67.613     0.200
     4.739    68.582     0.200
     5.064    72.793     0.200
     5.085    73.582     0.200
     5.232    75.332     0.200
     5.239    75.543     0.200
     5.376    77.082     0.200
     5.354    77.191     0.200
     5.439    78.602     0.200
     5.473    78.691     0.200
     5.533    79.273     0.200
     5.692    81.484     0.200
     5.694    81.852     0.200
     6.138    88.043     0.200
     6.181    87.641     0.200
     6.300    89.883     0.200
     6.336    89.684     0.200
     6.391    90.633     0.200
     6.413    91.293     0.200
     6.464    92.473     0.200
     6.594    93.363     0.200
     6.614    93.562     0.200
     6.672    94.402     0.200
     6.672    94.242     0.200
     6.728    94.992     0.200
     6.776    96.574     0.200
     6.878    97.543     0.200
     6.868    97.801     0.200
     7.324   103.312     0.200
     7.324   104.492     0.200
     7.604   107.781     0.200
     7.934   112.832     0.200
     8.164   115.273     0.200
     8.319   117.984     0.200
     8.590   121.004     0.200
     8.591   121.973     0.200
     8.949   124.953     0.200
     9.109   128.023     0.200
     9.194   130.051     0.200
     9.278   130.754     0.200
     9.373   130.082     0.200
     9.573   135.094     0.200
    10.067   143.902     0.200
    11.097   153.492     0.200
    11.133   155.102     0.200
    11.800   166.324     0.200
    12.797   179.723     0.200
    13.812   192.262     0.200
    15.240   211.293     0.200
     1.132    18.906     0.200
     1.330    22.398     0.200
     1.510    25.008     0.200
     1.481    24.695     0.200
     1.518    25.227     0.200
     1.547    25.945     0.200
     1.560    26.031     0.200
     1.560    26.016     0.200
     1.610    26.836     0.200
     1.787    28.281     0.200
     1.757    28.305     0.200
     1.822    29.609     0.200
     2.005    31.727     0.200
     1.957    30.219     0.200
     2.053    32.258     0.200
     2.083    32.758     0.200
     2.403    36.297     0.200
     2.455    38.016     0.200
     2.587    39.828     0.200
     3.014    44.305     0.200
     3.040    44.500     0.200
     3.230    48.125     0.200
     3.246    49.180     0.200
     3.465    51.195     0.200
     3.586    52.672     0.200
     3.594    53.695     0.200
     3.627    54.500     0.200
     3.735    54.195     0.200
     3.783    55.391     0.200
     3.806    55.461     0.200
     3.858    55.680     0.200
     3.940    57.898     0.200
     4.011    58.516     0.200
     4.029    58.836     0.200
     3.973    58.078     0.200
     4.128    60.430     0.200
     4.205    61.438     0.200
     4.287    62.797     0.200
     4.373    63.586     0.200
     4.423    64.719     0.200
     4.530    65.906     0.200
     4.827    70.031     0.200
     4.859    70.500     0.200
     5.117    74.641     0.200
     5.150    74.820     0.200
     5.212    75.758     0.200
     5.216    75.195     0.200
     5.280    75.898     0.200
     5.300    76.016     0.200
     5.382    77.031     0.200
     5.501    79.398     0.200
     5.535    79.680     0.200
     5.463    79.258     0.200
     5.567    80.016     0.200
     5.690    82.031     0.200
     5.854    84.039     0.200
     5.872    84.641     0.200
     5.901    85.438     0.200
     6.080    86.547     0.200
     6.135    89.477     0.200
     6.245    89.422     0.200
     6.335    90.492     0.200
     6.326    91.281     0.200
     6.600    94.617     0.200
     6.650    95.195     0.200
     6.688    95.086     0.200
     6.669    95.336     0.200
     6.779    96.555     0.200
     6.800    96.750     0.200
     6.894    97.461     0.200
     7.020    99.898     0.200
     7.062   100.352     0.200
     7.061   101.398     0.200
     7.103   100.852     0.200
     7.105   100.836     0.200
     7.140   101.406     0.200
     7.147   100.445     0.200
     7.147   100.875     0.200
     7.156   103.469     0.200
     7.392   104.961     0.200
     7.551   107.586     0.200
     7.828   111.766     0.200
     8.004   112.852     0.200
     8.063   115.078     0.200
     8.463   119.586     0.200
     8.527   121.578     0.200
     8.711   123.547     0.200
     8.667   123.586     0.200
     8.705   124.602     0.200
     8.855   125.477     0.200
     8.951   123.922     0.200
     8.971   125.352     0.200
     9.075   129.016     0.200
     9.055   128.367     0.200
     9.191   130.805     0.200
     9.237   129.742     0.200
     9.245   129.516     0.200
     9.224   130.242     0.200
     9.327   131.672     0.200
     9.362   132.711     0.200
     9.365   132.602     0.200
     9.898   140.039     0.200
     9.960   138.695     0.200
    10.675   150.656     0.200
    10.898   153.742     0.200
    10.880   152.109     0.200
    11.187   157.430     0.200
    11.193   157.742     0.200
    11.506   162.172     0.200
    11.506   161.852     0.200
    11.972   167.516     0.200
    12.262   171.898     0.200
    13.128   183.523     0.200
    13.128   183.828     0.200
    14.762   204.508     0.200
    15.475   212.688     0.200
    15.734   218.375     0.200
    18.801   256.648     0.200
    20.965   282.266     0.200
     0.560    11.492     0.200
     0.738    14.135     0.200
     0.900    16.533     0.200
     0.926    16.553     0.200
     0.945    17.223     0.200
     1.145    19.332     0.200
     1.182    20.262     0.200
     1.108    18.793     0.200
     1.240    20.633     0.200
     1.705    28.252     0.200
     1.733    28.752     0.200
     1.732    28.863     0.200
     1.736    28.803     0.200
     1.751    28.652     0.200
     2.059    31.383     0.200
     2.059    31.533     0.200
     2.339    37.363     0.200
     2.349    36.602     0.200
     2.352    36.613     0.200
     2.647    39.982     0.200
     2.880    44.793     0.200
     2.897    44.092     0.200
     2.802    42.473     0.200
     3.001    45.963     0.200
     3.205    49.002     0.200
     3.384    49.402     0.200
     3.553    52.652     0.200
     3.665    53.812     0.200
     3.697    55.252     0.200
     4.059    59.312     0.200
     4.151    61.143     0.200
     4.298    63.463     0.200
     4.505    65.453     0.200
     4.640    66.773     0.200
     4.687    68.182     0.200
     4.772    68.133     0.200
     4.846    70.512     0.200
     4.931    69.703     0.200
     4.931    70.023     0.200
     5.037    72.553     0.200
     5.070    72.322     0.200
     5.330    77.553     0.200
     5.330    76.273     0.200
     5.358    76.992     0.200
     5.369    77.342     0.200
     5.391    78.332     0.200
     5.450    78.102     0.200
     5.512    78.932     0.200
     5.677    81.252     0.200
     5.773    82.303     0.200
     5.855    84.762     0.200
     5.884    83.912     0.200
     6.100    87.072     0.200
     5.980    87.992     0.200
     6.289    89.732     0.200
     6.281    89.172     0.200
     6.335    91.332     0.200
     6.367    90.693     0.200
     6.394    91.242     0.200
     6.494    92.662     0.200
     6.570    93.963     0.200
     6.624    95.082     0.200
     6.786    95.822     0.200
     6.826    97.152     0.200
     6.890    97.973     0.200
     7.073   100.582     0.200
     7.331   104.623     0.200
     7.400   103.992     0.200
     7.500   105.992     0.200
     7.554   107.213     0.200
     7.558   107.342     0.200
     7.612   106.662     0.200
     7.717   110.213     0.200
     7.845   110.082     0.200
     7.903   110.693     0.200
     7.903   111.102     0.200
     7.982   113.473     0.200
     8.097   114.453     0.200
     8.048   113.623     0.200
     8.150   115.342     0.200
     8.350   117.943     0.200
     8.619   121.992     0.200
     8.856   126.342     0.200
     8.906   125.893     0.200
     8.995   127.562     0.200
     9.068   127.973     0.200
     9.417   132.742     0.200
     9.554   134.072     0.200
    10.228   142.143     0.200
    12.673   177.588     0.200
    14.051   194.162     0.200
    14.306   201.082     0.200
     1.650    27.625     0.200
     1.723    28.750     0.200
     1.790    29.930     0.200
     1.807    30.062     0.200
     1.812    30.578     0.200
     1.837    30.453     0.200
     1.856    31.461     0.200
     1.866    31.648     0.200
     1.861    29.812     0.200
     1.980    32.398     0.200
     2.001    33.203     0.200
     2.037    33.094     0.200
     2.071    34.250     0.200
     2.157    35.250     0.200
     2.191    35.508     0.200
     2.261    37.281     0.200
     2.475    40.539     0.200
     2.483    40.242     0.200
     2.767    43.172     0.200
     2.767    43.414     0.200
     2.835    44.555     0.200
     2.822    44.070     0.200
     2.906    45.781     0.200
     2.916    45.438     0.200
     3.053    46.852     0.200
     3.056    47.750     0.200
     3.114    49.211     0.200
     3.102    46.992     0.200
     3.518    53.852     0.200
     3.509    53.125     0.200
     3.562    54.281     0.200
     3.527    54.258     0.200
     3.681    54.453     0.200
     4.308    64.805     0.200
     4.379    66.070     0.200
     4.418    65.898     0.200
     4.434    66.219     0.200
     4.500    66.469     0.200
     4.512    66.625     0.200
     4.700    69.070     0.200
     4.993    72.531     0.200
     5.079    75.609     0.200
     5.096    73.531     0.200
     5.133    76.844     0.200
     5.218    76.023     0.200
     5.440    80.328     0.200
     5.534    80.289     0.200
     5.701    83.594     0.200
     6.015    88.312     0.200
     6.213    90.484     0.200
     6.370    92.812     0.200
     6.498    94.922     0.200
     6.518    94.219     0.200
     6.736    97.453     0.200
     6.777    98.250     0.200
     6.822    99.242     0.200
     7.121   103.453     0.200
     7.275   104.203     0.200
     7.357   105.758     0.200
     7.479   107.758     0.200
     7.639   108.859     0.200
     7.809   111.688     0.200
     8.068   116.211     0.200
     8.108   115.133     0.200
     8.150   116.820     0.200
     8.215   117.891     0.200
     8.309   120.281     0.200
     8.324   118.281     0.200
     8.412   121.055     0.200
     8.412   119.883     0.200
     8.412   121.984     0.200
     8.442   120.438     0.200
     8.469   120.961     0.200
     8.888   128.570     0.200
     9.113   129.625     0.200
     9.451   136.594     0.200
    10.039   143.750     0.200
    10.338   148.328     0.200
    11.234   156.891     0.200
    12.331   175.258     0.200
    14.404   203.078     0.200
    14.404   202.781     0.200
    14.694   203.664     0.200
    19.882   271.016     0.200
    19.882   271.023     0.200
     0.479    13.008     0.200
     0.610    14.195     0.200
     0.679    15.523     0.200
     0.686    15.172     0.200
     0.775    15.773     0.200
     0.812    16.234     0.200
     1.034    18.898     0.200
     1.034    19.031     0.200
     1.173    20.742     0.200
     1.227    21.352     0.200
     1.336    23.484     0.200
     1.335    23.102     0.200
     1.293    22.570     0.200
     1.410    24.219     0.200
     1.490    24.633     0.200
     1.695    27.352     0.200
     1.754    28.625     0.200
     1.798    29.430     0.200
     1.805    29.344     0.200
     1.921    31.141     0.200
     1.933    31.242     0.200
     1.897    30.555     0.200
     2.047    33.062     0.200
     2.187    33.555     0.200
     2.483    37.203     0.200
     2.562    40.008     0.200
     2.581    40.039     0.200
     2.617    41.141     0.200
     2.628    40.055     0.200
     2.693    42.000     0.200
     3.038    45.875     0.200
     3.050    46.320     0.200
     3.422    51.273     0.200
     3.614    53.031     0.200
     3.695    54.320     0.200
     3.884    55.781     0.200
     3.924    57.375     0.200
     4.025    58.625     0.200
     4.083    58.312     0.200
     4.182    60.453     0.200
     4.252    62.711     0.200
     4.328    62.141     0.200
     4.376    63.859     0.200
     4.399    64.602     0.200
     4.777    69.719     0.200
     4.959    71.852     0.200
     5.017    73.422     0.200
     5.219    75.039     0.200
     5.496    79.234     0.200
     5.553    79.680     0.200
     5.542    79.641     0.200
     5.609    80.430     0.200
     5.624    80.328     0.200
     5.665    81.062     0.200
     5.754    82.219     0.200
     6.063    86.273     0.200
     6.185    88.891     0.200
     6.325    89.750     0.200
     6.389    90.625     0.200
     6.450    92.289     0.200
     6.477    92.750     0.200
     6.516    93.203     0.200
     6.510    92.352     0.200
     6.539    93.258     0.200
     6.538    92.352     0.200
     6.720    95.648     0.200
     6.743    95.461     0.200
     6.836    96.508     0.200
     6.836    96.500     0.200
     6.836    96.070     0.200
     6.882    98.039     0.200
     6.974    98.633     0.200
     7.174   101.570     0.200
     7.174   101.930     0.200
     7.181   101.898     0.200
     7.287   102.750     0.200
     7.307   103.430     0.200
     7.307   103.648     0.200
     7.904   111.562     0.200
     8.325   117.352     0.200
     8.422   119.242     0.200
     8.616   121.375     0.200
     9.624   134.805     0.200
    12.217   170.250     0.200
     1.135    18.826     0.200
     1.135    19.018     0.200
     1.472    24.676     0.200
     1.472    24.926     0.200
     1.472    25.096     0.200
     1.637    26.926     0.200
     1.648    27.146     0.200
     1.645    27.297     0.200
     1.704    28.047     0.200
     1.719    28.396     0.200
     1.813    29.576     0.200
     1.856    30.086     0.200
     1.870    30.307     0.200
     1.881    30.877     0.200
     1.956    32.197     0.200
     2.048    33.346     0.200
     2.154    34.227     0.200
     2.421    38.316     0.200
     2.805    44.117     0.200
     2.821    44.277     0.200
     3.336    50.957     0.200
     3.366    51.496     0.200
     3.450    52.438     0.200
     3.513    53.246     0.200
     3.632    54.268     0.200
     3.635    54.617     0.200
     3.931    58.816     0.200
     3.969    59.377     0.200
     3.975    60.346     0.200
     3.993    59.887     0.200
     4.110    61.537     0.200
     4.311    62.717     0.200
     4.618    68.297     0.200
     4.738    70.076     0.200
     4.756    70.217     0.200
     4.794    71.018     0.200
     4.825    71.457     0.200
     4.865    72.107     0.200
     5.072    74.006     0.200
     5.212    76.006     0.200
     5.531    80.467     0.200
     5.592    81.846     0.200
     5.656    80.996     0.200
     5.655    81.947     0.200
     5.777    82.207     0.200
     5.777    82.066     0.200
     5.861    85.596     0.200
     5.916    85.236     0.200
     5.951    85.426     0.200
     6.117    88.137     0.200
     6.337    91.156     0.200
     6.429    95.646     0.200
     6.442    93.807     0.200
     6.935    99.447     0.200
     7.055   101.477     0.200
     7.087   101.996     0.200
     7.169   103.566     0.200
     7.216   103.518     0.200
     7.213   103.518     0.200
     7.349   105.377     0.200
     7.355   105.297     0.200
     7.482   107.316     0.200
     7.500   107.227     0.200
     7.506   107.926     0.200
     7.564   108.346     0.200
     7.637   110.066     0.200
     7.666   109.156     0.200
     7.755   111.406     0.200
     7.864   111.457     0.200
     7.958   112.846     0.200
     8.372   119.607     0.200
     8.619   122.596     0.200
     8.675   121.846     0.200
     8.684   124.797     0.200
     8.724   124.566     0.200
     8.895   127.107     0.200
     8.956   126.166     0.200
     8.956   126.059     0.200
     8.956   128.246     0.200
     8.983   128.777     0.200
     9.459   133.836     0.200
     9.459   134.188     0.200
     9.887   140.777     0.200
    10.374   147.037     0.200
    10.449   146.996     0.200
    10.875   154.156     0.200
    11.764   165.926     0.200
    13.050   185.432     0.200
    15.031   212.607     0.200
     0.527    11.438     0.200
     1.031    16.479     0.200
     1.045    18.328     0.200
     1.104    19.238     0.200
     1.117    19.447     0.200
     1.267    21.309     0.200
     1.293    21.719     0.200
     1.321    21.988     0.200
     1.327    22.777     0.200
     1.338    22.539     0.200
     1.426    23.799     0.200
     1.427    23.568     0.200
     1.515    24.959     0.200
     1.595    26.188     0.200
     1.656    26.703     0.200
     1.666    26.027     0.200
     1.691    26.959     0.200
     1.857    29.588     0.200
     3.379    48.998     0.200
     3.396    50.918     0.200
     3.693    54.299     0.200
     3.717    54.918     0.200
     3.820    56.688     0.200
     3.864    56.768     0.200
     3.875    57.857     0.200
     3.932    58.709     0.200
     3.998    59.107     0.200
     4.322    62.908     0.200
     4.426    63.898     0.200
     4.489    64.918     0.200
     4.627    67.969     0.200
     4.682    68.777     0.200
     4.739    69.107     0.200
     4.786    69.998     0.200
     5.103    73.447     0.200
     5.110    73.908     0.200
     5.175    75.158     0.200
     5.355    76.578     0.200
     5.498    79.607     0.200
     5.684    80.369     0.200
     5.736    81.898     0.200
     5.734    81.898     0.200
     5.807    82.197     0.200
     5.888    84.869     0.200
     5.956    83.738     0.200
     6.130    87.527     0.200
     6.149    87.869     0.200
     6.405    91.049     0.200
     6.499    92.998     0.200
     6.574    93.148     0.200
     6.656    94.668     0.200
     6.872    97.479     0.200
     6.874    97.299     0.200
     6.980    98.479     0.200
     7.081    99.979     0.200
     7.310   103.898     0.200
     7.335   104.088     0.200
     7.343   104.338     0.200
     7.375   104.758     0.200
     7.414   104.809     0.200
     7.443   105.799     0.200
     7.478   105.607     0.200
     7.585   107.688     0.200
     7.594   107.518     0.200
     7.702   109.658     0.200
     7.759   109.447     0.200
     7.817   109.918     0.200
     7.833   110.668     0.200
     8.125   115.238     0.200
     8.229   115.998     0.200
     8.422   118.918     0.200
     8.415   117.379     0.200
     8.600   122.119     0.200
     8.628   119.459     0.200
     8.684   122.758     0.200
     8.928   124.438     0.200
     8.928   124.309     0.200
    15.097   209.107     0.200
     0.553    11.566     0.200
     1.094    19.137     0.200
     1.036    16.527     0.200
     1.173    20.426     0.200
     1.062    18.406     0.200
     1.302    22.037     0.200
     1.252    21.287     0.200
     1.276    21.676     0.200
     1.326    22.297     0.200
     1.415    23.586     0.200
     1.411    23.557     0.200
     1.540    25.447     0.200
     1.502    25.256     0.200
     1.642    25.637     0.200
     1.673    27.037     0.200
     1.713    28.107     0.200
     1.667    26.346     0.200
     1.667    26.740     0.200
     2.127    34.057     0.200
     2.407    36.986     0.200
     2.497    38.576     0.200
     2.534    38.576     0.200
     2.575    38.146     0.200
     2.680    41.416     0.200
     2.704    42.346     0.200
     2.706    42.146     0.200
     2.723    42.236     0.200
     2.725    41.977     0.200
     3.235    46.277     0.200
     3.363    48.746     0.200
     3.384    51.367     0.200
     3.399    51.137     0.200
     3.697    54.377     0.200
     3.721    54.877     0.200
     3.815    56.787     0.200
     3.859    57.607     0.200
     3.869    57.787     0.200
     3.926    58.686     0.200
     3.973    59.326     0.200
     3.993    59.426     0.200
     4.309    62.686     0.200
     4.431    63.766     0.200
     4.463    66.797     0.200
     4.491    64.957     0.200
     4.622    68.076     0.200
     4.647    68.166     0.200
     4.663    69.076     0.200
     4.677    68.926     0.200
     4.717    69.387     0.200
     4.732    69.826     0.200
     4.764    69.826     0.200
     4.781    70.047     0.200
     5.092    72.357     0.200
     5.020    73.756     0.200
     5.104    73.707     0.200
     5.173    75.156     0.200
     5.322    74.846     0.200
     5.360    76.656     0.200
     5.493    79.076     0.200
     5.684    80.947     0.200
     5.737    81.537     0.200
     5.745    82.027     0.200
     5.813    82.137     0.200
     5.889    83.736     0.200
     5.964    83.697     0.200
     6.084    86.416     0.200
     6.158    88.047     0.200
     6.112    86.576     0.200
     6.139    87.016     0.200
     6.216    88.816     0.200
     6.277    91.166     0.200
     6.408    91.146     0.200
     6.646    94.197     0.200
     6.510    92.137     0.200
     6.584    93.496     0.200
     6.763    96.557     0.200
     6.754    95.516     0.200
     6.771    95.557     0.200
     6.873    97.176     0.200
     6.872    97.336     0.200
     6.979    98.836     0.200
     7.073   100.416     0.200
     7.077   100.176     0.200
     7.163   100.246     0.200
     7.196   101.236     0.200
     7.066   100.016     0.200
     7.276   101.756     0.200
     7.306   102.396     0.200
     7.166   100.877     0.200
     7.315   102.467     0.200
     7.198   102.656     0.200
     7.308   103.146     0.200
     7.354   103.676     0.200
     7.422   104.877     0.200
     7.452   105.156     0.200
     7.587   107.137     0.200
     7.582   107.246     0.200
     7.659   107.877     0.200
     7.711   108.766     0.200
     7.770   109.477     0.200
     7.836   110.646     0.200
     7.827   110.277     0.200
     7.820   110.176     0.200
     7.885   110.916     0.200
     7.846   110.756     0.200
     7.957   112.137     0.200
     8.108   112.936     0.200
     7.983   112.236     0.200
     8.014   112.777     0.200
     8.189   113.926     0.200
     8.091   114.957     0.200
     8.136   114.676     0.200
     8.294   116.137     0.200
     8.195   115.277     0.200
     8.241   116.057     0.200
     8.384   116.086     0.200
     8.325   117.137     0.200
     8.412   117.137     0.200
     8.513   119.137     0.200
     8.599   120.404     0.200
     8.599   121.127     0.200
     8.602   121.357     0.200
     8.625   119.756     0.200
     8.581   119.686     0.200
     8.743   122.537     0.200
     8.767   123.387     0.200
     8.750   122.256     0.200
     8.816   122.576     0.200
     8.816   123.367     0.200
     8.819   122.346     0.200
     8.819   123.096     0.200
     8.824   123.137     0.200
     8.817   124.906     0.200
     8.926   124.027     0.200
     8.926   123.896     0.200
     8.973   126.867     0.200
     9.031   126.816     0.200
     9.117   126.996     0.200
     9.117   127.326     0.200
     9.124   128.957     0.200
     9.142   129.396     0.200
     9.262   130.346     0.200
     9.228   129.947     0.200
     9.250   128.697     0.200
     9.428   131.896     0.200
     9.569   134.246     0.200
     9.584   134.527     0.200
     9.590   135.996     0.200
     9.866   137.207     0.200
     9.876   138.566     0.200
    10.466   146.707     0.200
    10.601   149.307     0.200
    10.698   148.246     0.200
    10.781   150.477     0.200
    10.763   150.617     0.200
    10.829   150.377     0.200
    10.959   152.666     0.200
    11.209   155.826     0.200
    11.839   165.916     0.200
    12.308   169.766     0.200
    12.514   174.506     0.200
    12.908   181.408     0.200
    13.510   185.547     0.200
    13.496   188.322     0.200
    13.776   190.027     0.200
    13.744   191.857     0.200
    15.098   208.121     0.200
    16.276   226.072     0.200
     0.539    11.590     0.200
     1.031    18.239     0.200
     1.083    19.300     0.200
     1.095    19.319     0.200
     1.061    17.020     0.200
     1.237    21.149     0.200
     1.264    21.510     0.200
     1.308    22.470     0.200
     1.398    23.379     0.200
     1.636    26.479     0.200
     1.666    25.649     0.200
     1.826    29.459     0.200
     2.358    35.310     0.200
     3.266    46.340     0.200
     3.393    49.050     0.200
     3.667    54.109     0.200
     3.691    54.579     0.200
     3.790    56.409     0.200
     3.834    57.629     0.200
     3.845    57.419     0.200
     3.902    57.999     0.200
     3.968    58.529     0.200
     4.292    62.739     0.200
     4.401    63.279     0.200
     4.436    65.229     0.200
     4.463    65.249     0.200
     4.639    68.129     0.200
     4.652    68.340     0.200
     4.693    68.739     0.200
     4.709    68.510     0.200
     4.756    69.539     0.200
     5.075    73.640     0.200
     5.146    75.449     0.200
     5.330    76.390     0.200
     5.468    78.919     0.200
     5.708    80.979     0.200
     5.714    81.459     0.200
     5.783    81.989     0.200
     5.861    83.890     0.200
     5.933    83.560     0.200
     6.081    86.359     0.200
     6.108    86.569     0.200
     6.119    87.029     0.200
     6.142    88.709     0.200
     6.254    88.859     0.200
     6.379    90.930     0.200
     6.479    91.600     0.200
     6.636    93.850     0.200
     6.844    96.379     0.200
     6.845    96.329     0.200
     6.952    98.010     0.200
     7.052    99.800     0.200
     7.281   103.039     0.200
     7.316   103.560     0.200
     7.323   104.090     0.200
     7.193    99.930     0.200
     7.458   106.050     0.200
     7.564   106.850     0.200
     7.789   109.800     0.200
     7.796   110.039     0.200
     8.386   117.369     0.200
     8.573   120.430     0.200
     8.599   119.669     0.200
     8.899   124.260     0.200
     8.899   124.354     0.200
    13.419   189.029     0.200
    15.070   208.560     0.200
     0.323    12.623     0.200
     0.405    13.133     0.200
     0.599    14.543     0.200
     0.628    14.883     0.200
     0.813    16.861     0.200
     0.852    17.611     0.200
     0.972    18.467     0.200
     0.965    19.182     0.200
     0.970    19.271     0.200
     0.972    19.283     0.200
     0.942    18.611     0.200
     0.989    19.422     0.200
     0.989    19.402     0.200
     1.263    21.893     0.200
     1.431    24.752     0.200
     1.443    24.883     0.200
     1.595    27.012     0.200
     1.613    27.172     0.200
     1.660    27.742     0.200
     1.710    28.902     0.200
     1.696    28.383     0.200
     1.780    29.203     0.200
     1.882    29.842     0.200
     2.067    32.303     0.200
     2.118    33.361     0.200
     2.081    33.492     0.200
     2.125    34.271     0.200
     2.138    34.303     0.200
     2.198    35.102     0.200
     2.242    35.713     0.200
     2.260    35.902     0.200
     2.739    43.182     0.200
     2.772    41.432     0.200
     2.818    42.521     0.200
     2.852    42.062     0.200
     2.799    42.553     0.200
     2.913    44.762     0.200
     2.936    45.723     0.200
     2.946    45.342     0.200
     2.983    45.783     0.200
     3.010    46.383     0.200
     3.028    46.223     0.200
     3.046    46.352     0.200
     3.229    47.982     0.200
     3.308    50.422     0.200
     3.410    50.893     0.200
     3.441    51.691     0.200
     3.745    54.812     0.200
     3.758    55.582     0.200
     3.985    57.652     0.200
     4.066    59.082     0.200
     4.069    59.441     0.200
     4.187    61.352     0.200
     4.254    60.973     0.200
     4.282    62.422     0.200
     4.449    63.252     0.200
     4.552    66.092     0.200
     4.562    67.611     0.200
     4.685    67.383     0.200
     4.626    67.352     0.200
     4.750    68.852     0.200
     4.777    68.182     0.200
     5.124    73.883     0.200
     5.165    74.312     0.200
     5.147    73.953     0.200
     5.167    74.092     0.200
     5.251    75.453     0.200
     5.305    76.203     0.200
     5.372    76.912     0.200
     5.341    77.133     0.200
     5.344    76.902     0.200
     5.418    77.672     0.200
     5.470    78.412     0.200
     5.573    79.812     0.200
     5.662    81.242     0.200
     5.742    82.361     0.200
     5.817    83.232     0.200
     5.845    83.953     0.200
     5.919    84.691     0.200
     5.961    85.252     0.200
     5.986    85.293     0.200
     6.009    85.812     0.200
     6.024    86.191     0.200
     6.105    87.021     0.200
     6.239    88.762     0.200
     6.376    90.832     0.200
     6.388    91.502     0.200
     6.414    91.812     0.200
     6.418    91.152     0.200
     6.606    94.203     0.200
     6.675    93.941     0.200
     6.742    95.893     0.200
     6.794    96.582     0.200
     6.867    98.213     0.200
     6.868    96.725     0.200
     6.888    96.623     0.200
     6.911    98.002     0.200
     6.955    99.812     0.200
     7.079    99.939     0.200
     7.211   102.492     0.200
     7.192   100.822     0.200
     7.357   104.713     0.200
     7.346   104.352     0.200
     7.380   103.947     0.200
     7.505   105.633     0.200
     7.523   106.852     0.200
     7.603   107.592     0.200
     7.633   108.703     0.200
     7.968   111.521     0.200
     8.133   115.191     0.200
     8.205   115.543     0.200
     8.224   117.861     0.200
     8.272   117.783     0.200
     8.313   117.432     0.200
     8.219   118.053     0.200
     8.548   120.922     0.200
     8.990   127.293     0.200
     9.672   135.611     0.200
     9.988   141.102     0.200
    10.277   143.793     0.200
    11.235   159.512     0.200
     1.784    29.898     0.200
     1.870    31.770     0.200
     1.897    31.887     0.200
     1.957    33.379     0.200
     1.871    30.457     0.200
     2.036    33.707     0.200
     2.094    34.828     0.200
     2.248    36.289     0.200
     2.507    40.809     0.200
     2.520    41.098     0.200
     2.796    44.359     0.200
     2.868    46.066     0.200
     2.865    44.449     0.200
     3.081    47.539     0.200
     3.066    47.719     0.200
     3.100    48.816     0.200
     3.159    49.566     0.200
     3.204    49.848     0.200
     3.137    47.969     0.200
     3.561    54.898     0.200
     3.604    56.047     0.200
     3.630    55.809     0.200
     3.563    54.176     0.200
     3.699    55.559     0.200
     3.632    55.387     0.200
     3.733    57.027     0.200
     3.896    58.699     0.200
     4.293    65.117     0.200
     4.358    66.227     0.200
     4.324    64.027     0.200
     4.457    67.418     0.200
     4.472    67.207     0.200
     4.512    68.020     0.200
     4.527    67.699     0.200
     4.540    67.828     0.200
     4.634    68.836     0.200
     4.733    70.477     0.200
     4.844    71.609     0.200
     5.005    73.527     0.200
     5.084    74.559     0.200
     5.105    74.098     0.200
     5.221    76.918     0.200
     5.295    77.688     0.200
     5.310    77.938     0.200
     5.463    80.957     0.200
     5.533    80.906     0.200
     5.629    82.508     0.200
     5.720    84.246     0.200
     6.057    88.508     0.200
     6.039    88.117     0.200
     6.265    91.297     0.200
     6.281    91.328     0.200
     6.283    91.668     0.200
     6.325    92.258     0.200
     6.288    92.469     0.200
     6.367    92.738     0.200
     6.475    94.020     0.200
     6.494    94.996     0.200
     6.522    94.637     0.200
     6.520    94.926     0.200
     6.596    95.719     0.200
     6.774    99.020     0.200
     6.802    99.488     0.200
     6.780    98.547     0.200
     6.768    98.246     0.200
     6.779    98.238     0.200
     6.852   100.078     0.200
     6.846    99.629     0.200
     6.881    99.988     0.200
     6.936   100.836     0.200
     7.152   104.789     0.200
     7.111   103.328     0.200
     7.149   104.449     0.200
     7.141   103.918     0.200
     7.230   105.109     0.200
     7.590   109.578     0.200
     7.621   109.969     0.200
     7.863   113.379     0.200
     8.010   115.699     0.200
     8.095   117.270     0.200
     8.095   117.789     0.200
     8.085   116.777     0.200
     8.192   118.098     0.200
     8.253   119.438     0.200
     8.440   121.309     0.200
     8.440   121.098     0.200
     8.353   120.367     0.200
     8.482   121.949     0.200
     8.563   124.457     0.200
     9.082   130.648     0.200
     9.158   130.859     0.200
     9.500   134.789     0.200
     9.605   138.289     0.200
     9.752   141.398     0.200
     9.770   139.969     0.200
     9.844   142.727     0.200
    10.010   142.609     0.200
    11.077   155.426     0.200
    14.728   206.117     0.200
    19.870   271.191     0.200
     0.473    12.893     0.200
     0.553    13.662     0.200
     0.700    15.053     0.200
     0.756    15.902     0.200
     0.760    16.012     0.200
     0.767    16.213     0.200
     0.781    16.213     0.200
     0.815    16.191     0.200
     0.913    17.643     0.200
     1.009    18.713     0.200
     1.405    23.602     0.200
     1.388    23.703     0.200
     1.483    25.252     0.200
     1.481    25.033     0.200
     1.641    27.203     0.200
     1.658    27.262     0.200
     1.753    28.613     0.200
     1.843    28.832     0.200
     1.873    30.033     0.200
     1.897    29.873     0.200
     1.932    31.002     0.200
     2.037    32.562     0.200
     2.052    32.562     0.200
     2.073    32.682     0.200
     2.591    39.652     0.200
     2.631    39.453     0.200
     2.676    40.682     0.200
     2.703    41.723     0.200
     2.739    41.502     0.200
     2.774    42.393     0.200
     2.817    43.182     0.200
     2.988    44.373     0.200
     3.183    47.973     0.200
     3.219    48.822     0.200
     3.520    51.492     0.200
     3.546    52.902     0.200
     3.758    54.473     0.200
     3.842    56.062     0.200
     3.960    56.992     0.200
     4.364    64.912     0.200
     4.473    64.412     0.200
     4.464    65.912     0.200
     4.523    65.691     0.200
     4.923    71.191     0.200
     4.941    71.262     0.200
     4.956    71.172     0.200
     5.028    72.402     0.200
     5.129    74.752     0.200
     5.137    75.012     0.200
     5.333    78.383     0.200
     5.353    77.332     0.200
     5.436    77.902     0.200
     5.627    80.691     0.200
     5.660    82.553     0.200
     5.701    81.602     0.200
     5.898    84.383     0.200
     5.936    85.303     0.200
     5.936    85.133     0.200
     6.023    86.271     0.200
     6.168    87.422     0.200
     6.192    88.793     0.200
     6.208    88.893     0.200
     6.376    90.283     0.200
     6.457    91.283     0.200
     6.533    92.832     0.200
     6.593    94.162     0.200
     6.646    94.143     0.200
     6.660    94.162     0.200
     6.670    93.982     0.200
     6.684    94.762     0.200
     6.789    95.902     0.200
     6.862    96.963     0.200
     6.864    96.803     0.200
     6.872    98.393     0.200
     6.971    98.342     0.200
     7.019    99.592     0.200
     7.119   101.432     0.200
     7.162   100.863     0.200
     8.165   115.893     0.200
     1.220    20.367     0.200
     1.394    23.594     0.200
     1.437    24.984     0.200
     1.445    24.914     0.200
     1.458    24.953     0.200
     1.458    25.164     0.200
     1.492    25.617     0.200
     1.674    27.164     0.200
     1.656    27.164     0.200
     1.717    28.336     0.200
     1.891    30.953     0.200
     1.939    31.500     0.200
     2.046    31.969     0.200
     2.303    35.094     0.200
     2.338    36.984     0.200
     2.372    37.273     0.200
     2.459    38.234     0.200
     2.488    38.148     0.200
     2.469    38.734     0.200
     2.627    40.266     0.200
     3.040    45.734     0.200
     3.040    46.180     0.200
     3.094    46.953     0.200
     3.142    46.977     0.200
     3.118    47.539     0.200
     3.104    47.180     0.200
     3.127    47.258     0.200
     3.125    46.109     0.200
     3.240    48.180     0.200
     3.348    49.969     0.200
     3.543    51.766     0.200
     3.483    51.750     0.200
     3.644    53.180     0.200
     3.678    54.227     0.200
     3.696    54.336     0.200
     3.774    54.695     0.200
     3.821    56.484     0.200
     3.901    57.430     0.200
     3.936    57.508     0.200
     3.940    57.906     0.200
     4.055    59.484     0.200
     4.320    63.586     0.200
     4.379    64.156     0.200
     4.559    65.984     0.200
     4.585    66.633     0.200
     4.740    69.266     0.200
     4.875    71.008     0.200
     4.872    70.844     0.200
     4.970    71.625     0.200
     4.943    72.328     0.200
     4.949    71.727     0.200
     5.056    73.844     0.200
     5.069    73.508     0.200
     5.141    74.117     0.200
     5.151    74.523     0.200
     5.154    74.805     0.200
     5.224    75.445     0.200
     5.168    74.805     0.200
     5.248    75.859     0.200
     5.188    75.094     0.200
     5.288    76.445     0.200
     5.350    76.906     0.200
     5.485    79.797     0.200
     5.437    79.289     0.200
     5.514    81.039     0.200
     5.935    85.336     0.200
     6.042    86.734     0.200
     6.241    91.203     0.200
     6.475    92.766     0.200
     6.679    95.500     0.200
     6.901    98.812     0.200
     6.973   100.133     0.200
     6.990    98.977     0.200
     7.034    99.875     0.200
     7.034    99.906     0.200
     7.034   100.609     0.200
     7.191   102.414     0.200
     7.198   105.180     0.200
     7.886   112.914     0.200
     8.745   125.469     0.200
     8.953   125.414     0.200
     8.953   127.734     0.200
     9.097   130.617     0.200
     9.230   130.180     0.200
     9.265   131.625     0.200
     9.860   139.609     0.200
    10.556   150.727     0.200
    10.801   153.414     0.200
    10.920   154.703     0.200
    11.075   157.398     0.200
    11.116   157.258     0.200
    11.486   162.508     0.200
    12.007   167.898     0.200
    13.028   182.180     0.200
    13.028   182.523     0.200
    14.044   193.844     0.200
    15.060   210.945     0.200
    15.499   215.266     0.200
    18.755   256.531     0.200
     1.047    17.430     0.200
     1.613    26.891     0.200
     1.784    29.266     0.200
     1.860    30.727     0.200
     1.958    31.828     0.200
     1.981    31.961     0.200
     1.993    32.250     0.200
     2.009    33.258     0.200
     2.006    32.898     0.200
     2.132    34.992     0.200
     2.148    34.758     0.200
     2.234    35.930     0.200
     2.328    37.000     0.200
     2.433    39.492     0.200
     2.824    43.008     0.200
     3.086    47.039     0.200
     3.514    52.180     0.200
     3.487    53.109     0.200
     3.769    55.617     0.200
     3.781    56.320     0.200
     3.782    56.672     0.200
     4.101    60.945     0.200
     4.145    62.789     0.200
     4.164    62.242     0.200
     4.269    63.875     0.200
     4.279    64.000     0.200
     4.450    64.672     0.200
     4.596    66.969     0.200
     4.794    70.867     0.200
     4.924    72.516     0.200
     4.964    73.508     0.200
     4.966    73.180     0.200
     5.033    74.219     0.200
     5.224    76.547     0.200
     5.387    78.031     0.200
     5.786    82.930     0.200
     5.759    83.570     0.200
     5.813    83.750     0.200
     5.900    83.945     0.200
     6.464    93.469     0.200
     7.335   104.977     0.200
     7.359   106.781     0.200
     7.507   108.102     0.200
     7.509   108.016     0.200
     7.593   108.688     0.200
     7.667   109.211     0.200
     7.667   109.531     0.200
     7.799   112.875     0.200
     7.897   114.141     0.200
     7.963   114.961     0.200
     8.054   116.328     0.200
     8.574   122.391     0.200
     8.626   122.117     0.200
     8.686   125.500     0.200
     8.776   124.352     0.200
     8.836   124.047     0.200
     8.824   125.781     0.200
     9.058   128.695     0.200
     9.109   130.242     0.200
     9.104   130.797     0.200
     9.114   128.859     0.200
     9.114   129.047     0.200
     9.114   130.070     0.200
     9.701   138.836     0.200
     9.634   136.180     0.200
     9.634   136.711     0.200
     9.911   140.727     0.200
    10.044   143.227     0.200
    10.513   149.109     0.200
    10.881   154.750     0.200
    11.925   166.875     0.200
    15.173   213.625     0.200
     1.121    19.832     0.200
     1.366    22.312     0.200
     1.721    28.324     0.200
     1.721    28.480     0.200
     2.296    36.703     0.200
     2.370    37.793     0.200
     2.431    38.293     0.200
     2.724    42.754     0.200
     3.313    50.453     0.200
     3.595    54.461     0.200
     3.879    58.062     0.200
     3.863    57.621     0.200
     4.159    60.102     0.200
     4.378    65.691     0.200
     4.401    65.812     0.200
     4.486    66.121     0.200
     4.510    67.141     0.200
     4.694    68.551     0.200
     5.129    76.043     0.200
     5.221    75.742     0.200
     5.324    77.512     0.200
     5.530    80.754     0.200
     5.583    81.391     0.200
     5.857    83.582     0.200
     5.952    85.441     0.200
     6.234    89.512     0.200
     6.257    90.141     0.200
     6.363    92.102     0.200
     6.506    93.992     0.200
     7.181   103.582     0.200
     7.497   106.383     0.200
     7.538   108.102     0.200
     7.518   108.094     0.200
     7.563   109.941     0.200
     7.598   109.551     0.200
     7.651   110.543     0.200
     7.905   114.113     0.200
     7.954   113.684     0.200
     7.950   114.652     0.200
     8.772   126.133     0.200
     8.894   127.602     0.200
     8.979   129.051     0.200
     9.040   129.363     0.200
     9.239   131.488     0.200
     9.497   135.121     0.200
     9.916   140.293     0.200
    10.158   145.613     0.200
    11.165   157.121     0.200
    12.062   167.602     0.200
    20.478   277.867     0.200
     0.459    10.766     0.200
     0.721    13.352     0.200
     0.899    16.062     0.200
     0.999    17.441     0.200
     1.002    17.492     0.200
     1.156    19.750     0.200
     1.179    20.512     0.200
     1.184    20.781     0.200
     1.179    19.852     0.200
     1.193    20.371     0.200
     1.192    21.281     0.200
     1.206    20.980     0.200
     1.213    21.250     0.200
     1.244    21.312     0.200
     1.266    21.531     0.200
     1.500    24.371     0.200
     1.595    26.062     0.200
     1.608    26.883     0.200
     1.764    28.500     0.200
     1.779    28.320     0.200
     1.822    29.410     0.200
     1.850    29.781     0.200
     1.858    29.781     0.200
     1.868    29.930     0.200
     1.893    29.820     0.200
     1.911    29.941     0.200
     1.996    31.840     0.200
     2.104    33.281     0.200
     2.131    33.723     0.200
     2.227    34.551     0.200
     2.270    36.121     0.200
     2.295    35.832     0.200
     2.322    36.531     0.200
     2.399    37.492     0.200
     2.402    37.449     0.200
     2.620    39.109     0.200
     2.699    40.301     0.200
     2.731    42.562     0.200
     2.801    41.512     0.200
     3.021    45.730     0.200
     3.032    45.633     0.200
     3.032    45.570     0.200
     3.082    46.711     0.200
     3.152    47.262     0.200
     3.201    47.660     0.200
     3.258    48.340     0.200
     3.321    49.332     0.200
     3.355    50.199     0.200
     3.455    51.383     0.200
     3.549    51.840     0.200
     3.534    52.461     0.200
     3.904    56.672     0.200
     3.936    57.211     0.200
     3.926    57.641     0.200
     3.965    57.902     0.200
     4.007    57.781     0.200
     4.075    59.082     0.200
     4.110    59.750     0.200
     4.168    59.832     0.200
     4.292    62.332     0.200
     4.365    63.172     0.200
     4.411    63.801     0.200
     4.602    66.922     0.200
     4.727    69.230     0.200
     4.826    69.840     0.200
     4.961    71.820     0.200
     5.037    73.711     0.200
     5.061    73.301     0.200
     5.092    73.102     0.200
     5.120    73.422     0.200
     5.123    73.422     0.200
     5.236    75.359     0.200
     5.425    78.211     0.200
     5.460    79.430     0.200
     5.591    79.492     0.200
     5.611    80.832     0.200
     5.603    80.492     0.200
     5.633    80.750     0.200
     5.677    81.832     0.200
     5.710    82.293     0.200
     5.751    82.531     0.200
     5.881    84.441     0.200
     5.934    85.543     0.200
     5.995    85.730     0.200
     6.028    86.352     0.200
     6.033    85.742     0.200
     6.078    87.242     0.200
     6.087    87.109     0.200
     6.238    89.070     0.200
     6.221    88.891     0.200
     6.363    91.223     0.200
     6.395    91.680     0.200
     6.510    93.242     0.200
     6.569    94.230     0.200
     6.708    94.711     0.200
     6.792    97.312     0.200
     6.807    97.230     0.200
     6.861    97.570     0.200
     6.918    97.441     0.200
     6.934    98.211     0.200
     7.047   100.699     0.200
     7.083   100.293     0.200
     7.119   100.590     0.200
     7.121   100.762     0.200
     7.159   101.359     0.200
     7.142   101.012     0.200
     7.207   102.980     0.200
     7.197   101.062     0.200
     7.197   100.703     0.200
     7.197   100.973     0.200
     7.232   102.562     0.200
     7.333   103.922     0.200
     7.333   104.000     0.200
     7.415   103.672     0.200
     7.733   109.711     0.200
     7.821   110.520     0.200
     7.821   110.922     0.200
     7.867   112.250     0.200
     7.909   112.473     0.200
     8.238   117.211     0.200
     8.273   117.109     0.200
     8.661   121.543     0.200
     8.726   123.840     0.200
     8.757   122.730     0.200
     8.790   124.043     0.200
     8.854   124.172     0.200
     9.116   127.199     0.200
     9.146   128.820     0.200
     9.216   130.512     0.200
     9.518   134.242     0.200
     9.782   137.871     0.200
     9.993   138.422     0.200
    10.007   138.910     0.200
    10.664   150.750     0.200
    12.033   169.547     0.200
    13.303   183.695     0.200
    13.303   185.461     0.200
    16.736   227.652     0.200
     1.289    23.262     0.200
     1.257    22.660     0.200
     1.394    23.352     0.200
     1.413    25.000     0.200
     1.468    26.012     0.200
     1.470    25.840     0.200
     1.476    25.941     0.200
     1.484    26.340     0.200
     1.492    26.352     0.200
     1.503    26.570     0.200
     1.527    26.422     0.200
     1.507    26.480     0.200
     1.555    26.363     0.200
     1.603    27.711     0.200
     1.685    28.930     0.200
     1.866    30.910     0.200
     1.885    31.480     0.200
     1.888    31.473     0.200
     1.928    32.113     0.200
     1.975    32.660     0.200
     1.992    33.293     0.200
     2.148    33.961     0.200
     2.147    34.711     0.200
     2.265    36.230     0.200
     2.304    36.941     0.200
     2.362    37.422     0.200
     2.341    37.293     0.200
     2.421    38.371     0.200
     2.435    38.832     0.200
     2.533    41.312     0.200
     2.581    41.031     0.200
     2.593    41.543     0.200
     2.733    42.750     0.200
     2.979    45.773     0.200
     2.991    46.211     0.200
     2.983    46.180     0.200
     3.083    47.152     0.200
     3.042    47.090     0.200
     3.048    47.590     0.200
     3.248    49.641     0.200
     3.262    50.230     0.200
     3.361    50.820     0.200
     3.474    52.172     0.200
     3.533    53.121     0.200
     3.597    53.363     0.200
     3.514    53.090     0.200
     3.752    56.023     0.200
     3.768    56.562     0.200
     3.742    56.621     0.200
     3.769    57.023     0.200
     3.914    59.160     0.200
     4.118    60.332     0.200
     4.192    61.750     0.200
     4.168    62.422     0.200
     4.553    66.660     0.200
     4.673    69.371     0.200
     4.734    70.211     0.200
     4.825    71.500     0.200
     4.890    71.562     0.200
     4.962    72.773     0.200
     4.946    73.402     0.200
     5.042    73.840     0.200
     5.064    73.820     0.200
     5.098    74.680     0.200
     5.166    75.750     0.200
     5.256    77.883     0.200
     5.254    77.871     0.200
     5.323    78.523     0.200
     5.337    78.660     0.200
     5.329    79.023     0.200
     5.435    79.223     0.200
     5.644    84.160     0.200
     5.745    83.930     0.200
     5.852    84.930     0.200
     5.876    86.031     0.200
     6.026    89.340     0.200
     6.076    89.871     0.200
     6.396    93.082     0.200
     6.458    93.961     0.200
     6.561    96.203     0.200
     6.662    96.363     0.200
     6.800    97.621     0.200
     6.800    99.410     0.200
     6.807    98.492     0.200
     6.815    98.531     0.200
     6.910    99.461     0.200
     6.910    99.730     0.200
     6.914    99.090     0.200
     7.002   100.930     0.200
     7.160   103.031     0.200
     7.390   106.863     0.200
     7.823   112.633     0.200
     7.830   111.691     0.200
     7.830   112.422     0.200
     8.818   126.941     0.200
     8.838   127.410     0.200
     9.032   130.391     0.200
     9.153   131.473     0.200
     9.457   134.363     0.200
     9.526   135.191     0.200
     9.724   138.000     0.200
     9.737   139.121     0.200
     0.202    15.492     0.200
     0.090    15.230     0.200
     0.262    15.762     0.200
     0.305    15.812     0.200
     0.320    15.961     0.200
     0.346    15.770     0.200
     0.424    16.301     0.200
     0.439    16.500     0.200
     0.932    20.641     0.200
     0.960    20.711     0.200
     1.033    21.602     0.200
     1.076    22.352     0.200
     1.285    24.879     0.200
     1.289    25.070     0.200
     1.382    24.785     0.200
     1.438    25.301     0.200
     1.887    32.621     0.200
     1.958    32.820     0.200
     2.162    35.812     0.200
     2.263    36.660     0.200
     2.361    38.121     0.200
     2.403    38.730     0.200
     2.406    38.762     0.200
     2.506    40.191     0.200
     2.539    39.230     0.200
     2.534    40.621     0.200
     2.602    40.039     0.200
     2.778    42.832     0.200
     3.178    49.371     0.200
     3.202    49.801     0.200
     3.249    48.980     0.200
     3.532    53.801     0.200
     3.779    56.281     0.200
     3.815    56.402     0.200
     4.028    60.000     0.200
     4.204    61.270     0.200
     4.378    63.379     0.200
     4.492    64.820     0.200
     4.576    65.730     0.200
     4.606    68.070     0.200
     4.629    68.281     0.200
     4.732    67.711     0.200
     4.765    71.070     0.200
     4.788    69.789     0.200
     4.801    69.082     0.200
     4.941    70.422     0.200
     5.177    74.242     0.200
     5.192    74.672     0.200
     5.493    78.270     0.200
     5.547    79.000     0.200
     5.582    80.461     0.200
     5.590    79.609     0.200
     5.605    80.391     0.200
     5.642    81.109     0.200
     5.677    81.652     0.200
     5.826    83.910     0.200
     5.885    83.402     0.200
     6.083    87.051     0.200
     6.143    87.562     0.200
     6.409    91.211     0.200
     6.475    92.652     0.200
     6.485    92.520     0.200
     6.532    93.699     0.200
     6.620    94.422     0.200
     6.736    95.902     0.200
     6.855    96.211     0.200
     6.917    99.250     0.200
     6.920    99.109     0.200
     6.929    98.781     0.200
     6.970    97.520     0.200
     7.000    98.930     0.200
     7.125   101.812     0.200
     7.187   102.590     0.200
     7.184   100.051     0.200
     7.192   100.879     0.200
     7.255   103.500     0.200
     7.369   103.332     0.200
     7.383   105.371     0.200
     7.505   104.691     0.200
     7.505   104.742     0.200
     7.687   109.539     0.200
     8.000   113.641     0.200
     8.739   125.301     0.200
     9.190   129.922     0.200
     9.199   127.742     0.200
     9.384   130.320     0.200
    10.239   140.941     0.200
    13.774   190.539     0.200
     0.494    12.795     0.200
     0.536    12.717     0.200
     0.638    13.656     0.200
     0.748    15.035     0.200
     0.798    15.396     0.200
     0.818    15.625     0.200
     0.889    16.807     0.200
     0.916    17.166     0.200
     0.934    17.186     0.200
     1.006    18.477     0.200
     1.073    19.186     0.200
     1.060    19.375     0.200
     1.091    19.146     0.200
     1.072    19.676     0.200
     1.073    19.785     0.200
     1.078    19.666     0.200
     1.082    19.717     0.200
     1.083    19.736     0.200
     1.091    19.807     0.200
     1.137    19.756     0.200
     1.545    25.746     0.200
     1.546    25.865     0.200
     1.674    27.336     0.200
     1.688    27.816     0.200
     1.700    28.025     0.200
     1.738    28.346     0.200
     1.764    28.705     0.200
     1.784    29.006     0.200
     1.815    29.785     0.200
     2.033    31.746     0.200
     2.072    32.477     0.200
     2.170    34.246     0.200
     2.214    35.426     0.200
     2.232    35.086     0.200
     2.336    37.006     0.200
     2.349    37.105     0.200
     2.363    37.076     0.200
     2.800    41.596     0.200
     2.811    42.615     0.200
     2.997    45.705     0.200
     3.032    46.605     0.200
     3.036    46.615     0.200
     3.038    46.576     0.200
     3.290    48.766     0.200
     3.333    50.387     0.200
     3.417    51.035     0.200
     3.669    55.125     0.200
     3.711    54.266     0.200
     3.797    56.336     0.200
     3.938    57.986     0.200
     3.996    57.596     0.200
     4.061    58.746     0.200
     4.200    59.625     0.200
     4.200    61.156     0.200
     4.201    61.076     0.200
     4.381    61.695     0.200
     4.401    63.396     0.200
     4.602    65.535     0.200
     4.667    70.467     0.200
     4.737    68.275     0.200
     4.795    68.936     0.200
     4.776    69.955     0.200
     4.808    67.986     0.200
     4.797    69.967     0.200
     5.026    71.896     0.200
     5.074    73.236     0.200
     5.183    74.637     0.200
     5.290    76.195     0.200
     5.310    76.426     0.200
     5.418    78.746     0.200
     5.432    78.955     0.200
     5.484    78.506     0.200
     5.625    80.146     0.200
     5.685    81.246     0.200
     5.713    81.637     0.200
     5.852    82.936     0.200
     5.866    83.256     0.200
     5.903    84.406     0.200
     5.911    84.705     0.200
     5.905    85.836     0.200
     5.909    84.436     0.200
     5.958    86.916     0.200
     6.009    85.955     0.200
     6.270    89.887     0.200
     6.283    89.637     0.200
     6.328    90.396     0.200
     6.330    90.557     0.200
     6.504    93.115     0.200
     6.590    94.467     0.200
     6.650    94.115     0.200
     6.656    95.416     0.200
     6.663    94.156     0.200
     6.734    95.205     0.200
     6.770    96.166     0.200
     6.912    98.496     0.200
     6.946    97.396     0.200
     7.241   101.717     0.200
     7.468   105.586     0.200
     7.511   104.906     0.200
     7.715   108.686     0.200
     7.925   112.865     0.200
     8.032   114.477     0.200
     8.056   112.736     0.200
     8.179   115.387     0.200
     8.196   115.666     0.200
     8.479   118.955     0.200
     8.543   120.625     0.200
     8.572   120.566     0.200
     8.617   120.826     0.200
     0.340    13.496     0.200
     0.461    14.613     0.200
     0.504    14.973     0.200
     0.514    15.023     0.200
     0.552    15.086     0.200
     0.678    16.715     0.200
     0.791    17.676     0.200
     0.811    17.934     0.200
     0.824    17.965     0.200
     0.959    19.363     0.200
     1.027    19.773     0.200
     1.082    20.793     0.200
     1.113    21.195     0.200
     1.196    21.969     0.200
     1.323    23.484     0.200
     1.693    28.855     0.200
     1.695    28.996     0.200
     1.695    28.996     0.200
     1.699    28.973     0.200
     1.713    29.113     0.200
     1.720    29.094     0.200
     2.004    32.754     0.200
     2.064    32.246     0.200
     2.381    37.562     0.200
     2.467    38.965     0.200
     2.799    43.312     0.200
     2.816    42.496     0.200
     2.843    44.824     0.200
     2.861    43.184     0.200
     2.874    44.594     0.200
     2.908    44.703     0.200
     3.016    45.812     0.200
     3.298    50.152     0.200
     3.576    52.652     0.200
     3.592    52.355     0.200
     3.630    54.176     0.200
     3.642    54.426     0.200
     3.704    55.535     0.200
     3.732    54.863     0.200
     3.976    59.266     0.200
     3.999    59.293     0.200
     4.022    59.395     0.200
     4.187    61.945     0.200
     4.477    66.434     0.200
     4.496    64.855     0.200
     4.661    68.973     0.200
     4.710    68.883     0.200
     4.827    69.812     0.200
     4.945    71.652     0.200
     4.993    71.785     0.200
     4.996    72.094     0.200
     5.156    74.902     0.200
     5.178    73.586     0.200
     5.245    78.746     0.200
     5.398    77.273     0.200
     5.508    78.773     0.200
     5.788    84.223     0.200
     5.812    83.445     0.200
     6.059    86.855     0.200
     6.137    88.605     0.200
     6.312    90.113     0.200
     6.417    92.734     0.200
     6.579    94.953     0.200
     6.648    95.004     0.200
     6.659    94.773     0.200
     6.705    95.664     0.200
     6.801    97.145     0.200
     6.923    99.543     0.200
     6.979   100.055     0.200
     7.122   101.746     0.200
     7.139   102.324     0.200
     7.175   102.824     0.200
     7.247   103.336     0.200
     7.694   108.324     0.200
     7.789   110.074     0.200
     7.832   110.793     0.200
     7.932   110.273     0.200
    14.158   196.598     0.200
     0.173    18.398     0.200
     0.219    18.555     0.200
     0.283    18.848     0.200
     0.302    18.867     0.200
     0.340    18.828     0.200
     0.356    19.086     0.200
     0.440    19.738     0.200
     0.499    19.738     0.200
     0.542    20.277     0.200
     0.933    22.836     0.200
     0.983    23.137     0.200
     0.992    23.305     0.200
     1.287    26.965     0.200
     1.299    26.797     0.200
     1.300    27.105     0.200
     1.567    29.766     0.200
     1.668    29.496     0.200
     1.736    30.266     0.200
     2.095    34.527     0.200
     2.355    39.398     0.200
     2.337    38.625     0.200
     2.337    38.426     0.200
     2.340    39.066     0.200
     2.560    41.426     0.200
     2.690    43.277     0.200
     3.472    53.406     0.200
     3.453    53.828     0.200
     3.737    56.676     0.200
     3.822    57.648     0.200
     3.940    59.668     0.200
     4.252    62.215     0.200
     4.254    62.316     0.200
     4.400    62.867     0.200
     4.372    63.875     0.200
     4.385    65.266     0.200
     4.408    65.625     0.200
     4.510    65.496     0.200
     4.566    66.508     0.200
     4.621    67.797     0.200
     4.636    70.367     0.200
     4.801    69.465     0.200
     4.801    68.988     0.200
     5.025    72.305     0.200
     5.096    74.586     0.200
     5.194    74.676     0.200
     5.294    76.535     0.200
     5.362    77.055     0.200
     5.448    77.945     0.200
     5.467    79.535     0.200
     5.506    80.117     0.200
     5.525    78.816     0.200
     5.539    79.297     0.200
     5.586    80.238     0.200
     5.798    83.316     0.200
     5.815    83.148     0.200
     5.911    85.266     0.200
     5.958    85.418     0.200
     5.995    85.215     0.200
     6.063    86.957     0.200
     6.486    92.836     0.200
     6.574    94.148     0.200
     6.572    94.316     0.200
     6.769    95.227     0.200
     6.822    97.117     0.200
     6.886    97.156     0.200
     6.998    99.867     0.200
     7.018   100.125     0.200
     7.101    99.516     0.200
     7.127   100.148     0.200
     7.183   102.035     0.200
     7.208   102.406     0.200
     7.266   102.008     0.200
     7.282   103.387     0.200
     7.267   101.797     0.200
     7.280   102.176     0.200
     7.431   103.797     0.200
     7.431   103.387     0.200
     7.492   108.207     0.200
     7.502   106.707     0.200
     7.502   106.816     0.200
     7.582   106.578     0.200
     7.725   108.215     0.200
     7.939   111.875     0.200
     8.035   113.266     0.200
     8.035   113.418     0.200
     0.362    12.801     0.200
     0.502    14.039     0.200
     0.673    15.422     0.200
     0.637    15.520     0.200
     0.642    15.789     0.200
     0.643    15.520     0.200
     0.645    15.602     0.200
     0.682    15.539     0.200
     0.659    15.570     0.200
     0.836    17.000     0.200
     0.904    18.020     0.200
     0.949    18.980     0.200
     1.129    20.410     0.200
     1.330    23.359     0.200
     1.408    25.070     0.200
     1.538    25.441     0.200
     1.500    25.480     0.200
     1.779    28.812     0.200
     1.796    29.723     0.200
     1.839    29.281     0.200
     1.810    29.820     0.200
     1.914    31.352     0.200
     2.200    33.789     0.200
     2.508    38.672     0.200
     2.573    38.699     0.200
     2.546    39.160     0.200
     2.676    41.270     0.200
     2.685    41.820     0.200
     2.698    42.082     0.200
     2.924    45.012     0.200
     3.092    46.379     0.200
     3.111    47.680     0.200
     3.428    51.121     0.200
     3.450    50.770     0.200
     3.664    53.301     0.200
     3.758    54.859     0.200
     3.861    55.973     0.200
     3.867    55.832     0.200
     3.972    56.473     0.200
     4.026    58.680     0.200
     4.080    59.652     0.200
     4.178    59.602     0.200
     4.332    63.590     0.200
     4.354    64.102     0.200
     4.430    63.852     0.200
     4.748    68.832     0.200
     4.776    68.672     0.200
     4.845    69.891     0.200
     4.884    70.223     0.200
     4.907    71.641     0.200
     4.922    71.082     0.200
     5.018    72.852     0.200
     5.011    71.492     0.200
     5.086    74.340     0.200
     5.249    75.762     0.200
     5.242    75.449     0.200
     5.337    76.770     0.200
     5.515    79.340     0.200
     5.722    82.430     0.200
     5.776    82.570     0.200
     5.800    83.039     0.200
     5.849    84.012     0.200
     5.942    85.230     0.200
     5.973    84.539     0.200
     6.057    86.402     0.200
     6.129    87.332     0.200
     6.169    88.711     0.200
     6.167    87.812     0.200
     6.299    90.270     0.200
     6.494    93.129     0.200
     6.539    92.871     0.200
     6.557    92.602     0.200
     6.607    94.590     0.200
     6.591    93.973     0.200
     6.623    94.070     0.200
     6.751    95.812     0.200
     6.757    96.160     0.200
     6.777    97.289     0.200
     6.861    96.820     0.200
     6.861    97.250     0.200
     7.250   103.762     0.200
     7.300   103.711     0.200
     7.272   103.859     0.200
     8.437   120.082     0.200
     9.640   134.082     0.200
     9.825   139.980     0.200
     9.929   137.680     0.200
    10.122   141.320     0.200
    11.689   162.879     0.200
    12.344   171.762     0.200
     0.145    13.650     0.200
     0.206    13.820     0.200
     0.357    14.199     0.200
     0.517    15.170     0.200
     0.563    15.500     0.200
     0.642    16.369     0.200
     0.635    16.670     0.200
     0.750    17.359     0.200
     0.766    17.830     0.200
     0.836    18.480     0.200
     0.870    18.869     0.200
     0.946    20.029     0.200
     0.951    20.119     0.200
     0.968    20.289     0.200
     0.967    20.189     0.200
     0.972    20.230     0.200
     1.096    20.174     0.200
     1.257    23.619     0.200
     1.356    23.340     0.200
     1.364    24.549     0.200
     1.382    24.660     0.200
     1.474    25.900     0.200
     1.524    26.730     0.200
     1.572    27.330     0.200
     1.637    28.160     0.200
     1.657    29.020     0.200
     1.746    29.586     0.200
     1.746    29.811     0.200
     1.831    30.539     0.200
     1.939    30.859     0.200
     2.057    33.510     0.200
     2.113    33.270     0.200
     2.101    34.289     0.200
     2.111    34.330     0.200
     2.170    34.020     0.200
     2.167    35.109     0.200
     2.235    36.119     0.200
     2.744    43.760     0.200
     2.744    43.340     0.200
     2.794    41.730     0.200
     2.711    41.699     0.200
     2.847    43.459     0.200
     2.904    43.240     0.200
     2.889    44.391     0.200
     2.918    45.070     0.200
     2.959    45.529     0.200
     2.975    45.910     0.200
     3.014    45.523     0.200
     3.007    45.990     0.200
     3.233    49.090     0.200
     3.438    51.811     0.200
     3.543    53.459     0.200
     3.664    54.500     0.200
     3.735    55.650     0.200
     3.786    55.580     0.200
     4.001    58.369     0.200
     4.096    59.891     0.200
     4.149    60.580     0.200
     4.149    60.320     0.200
     4.154    60.660     0.200
     4.202    61.420     0.200
     4.305    61.629     0.200
     4.348    63.480     0.200
     4.370    64.670     0.200
     4.418    63.959     0.200
     4.506    64.590     0.200
     4.523    67.150     0.200
     4.523    66.629     0.200
     4.603    66.570     0.200
     4.545    66.939     0.200
     4.682    67.160     0.200
     4.714    67.990     0.200
     4.751    68.959     0.200
     4.748    68.340     0.200
     4.779    69.641     0.200
     4.989    72.160     0.200
     5.075    72.920     0.200
     5.111    73.740     0.200
     5.149    73.680     0.200
     5.197    75.010     0.200
     5.207    75.141     0.200
     5.180    74.119     0.200
     5.250    75.180     0.200
     5.315    76.609     0.200
     5.319    76.480     0.200
     5.380    77.510     0.200
     5.372    77.785     0.200
     5.432    77.480     0.200
     5.496    78.930     0.200
     5.551    79.141     0.200
     5.564    79.000     0.200
     5.663    81.379     0.200
     5.670    80.920     0.200
     5.830    83.230     0.200
     5.893    84.340     0.200
     5.976    85.500     0.200
     6.032    86.570     0.200
     6.048    86.359     0.200
     6.086    87.020     0.200
     6.104    87.230     0.200
     6.177    88.311     0.200
     6.249    89.529     0.200
     6.300    89.510     0.200
     6.369    90.891     0.200
     6.446    91.939     0.200
     6.470    91.641     0.200
     6.480    92.580     0.200
     6.487    92.561     0.200
     6.603    94.830     0.200
     6.584    92.145     0.200
     6.680    95.680     0.200
     6.662    93.219     0.200
     6.787    97.209     0.200
     6.784    96.959     0.200
     6.812    97.359     0.200
     6.864    95.750     0.200
     6.875    96.080     0.200
     6.939    99.070     0.200
     6.927    98.410     0.200
     7.040   100.779     0.200
     7.006    98.039     0.200
     7.060   100.061     0.200
     7.069    99.340     0.200
     7.115   101.039     0.200
     7.184   100.689     0.200
     7.184   100.279     0.200
     7.184   100.410     0.200
     7.296   104.299     0.200
     7.364   103.162     0.200
     7.592   107.990     0.200
     7.521   107.129     0.200
     7.521   106.260     0.200
     7.588   107.609     0.200
     7.588   107.240     0.200
     7.694   108.689     0.200
     8.035   112.811     0.200
     8.311   117.029     0.200
     8.744   123.500     0.200
     8.817   123.289     0.200
     9.237   130.529     0.200
     9.765   137.119     0.200
     9.941   137.129     0.200
    10.008   140.400     0.200
    10.089   141.859     0.200
    10.156   141.420     0.200
    10.380   145.240     0.200
    12.613   176.904     0.200
    12.613   176.279     0.200
    13.413   184.404     0.200
    13.413   184.600     0.200
    14.424   200.330     0.200
     0.634    12.734     0.200
     0.663    12.135     0.200
     1.164    20.064     0.200
     1.164    19.895     0.200
     1.529    25.084     0.200
     2.362    34.814     0.200
     2.879    44.004     0.200
     3.177    47.525     0.200
     3.200    47.945     0.200
     3.385    50.764     0.200
     3.433    52.145     0.200
     3.838    55.215     0.200
     3.948    57.924     0.200
     3.909    56.734     0.200
     4.103    59.994     0.200
     4.590    66.674     0.200
     4.839    69.584     0.200
     5.219    74.584     0.200
     5.227    74.914     0.200
     5.292    75.184     0.200
     5.377    77.174     0.200
     5.444    76.865     0.200
     5.548    78.834     0.200
     5.569    79.494     0.200
     5.590    79.664     0.200
     5.623    80.004     0.200
     5.694    81.465     0.200
     5.889    84.465     0.200
     5.918    84.424     0.200
     5.950    84.975     0.200
     6.000    85.895     0.200
     6.071    86.654     0.200
     6.125    87.424     0.200
     6.305    90.234     0.200
     6.323    89.885     0.200
     6.361    90.684     0.200
     6.369    91.045     0.200
     6.402    91.275     0.200
     6.477    92.055     0.200
     6.460    91.994     0.200
     6.435    91.105     0.200
     6.598    94.205     0.200
     6.605    93.904     0.200
     6.748    95.775     0.200
     6.844    97.434     0.200
     6.903    97.895     0.200
     6.980    98.615     0.200
     7.092   100.564     0.200
     7.125   101.344     0.200
     7.195   102.955     0.200
     7.261   102.615     0.200
     7.317   104.135     0.200
     7.317   103.885     0.200
     7.334   104.445     0.200
     7.322   103.885     0.200
     7.453   105.535     0.200
     7.620   106.734     0.200
     7.628   108.174     0.200
     7.706   109.295     0.200
     7.734   109.814     0.200
     7.859   111.275     0.200
     7.829   110.715     0.200
     7.921   111.254     0.200
     7.949   112.064     0.200
     8.055   113.385     0.200
     8.100   114.205     0.200
     8.134   113.885     0.200
     8.217   115.465     0.200
     8.330   117.125     0.200
     8.340   116.775     0.200
     8.302   118.275     0.200
     8.275   115.955     0.200
     8.429   118.055     0.200
     8.429   117.783     0.200
     8.429   118.715     0.200
     8.459   120.314     0.200
     8.514   120.365     0.200
     8.620   121.184     0.200
     8.620   121.895     0.200
     8.817   124.965     0.200
     9.143   128.174     0.200
     9.947   138.355     0.200
    10.079   142.254     0.200
    10.678   149.914     0.200
    10.777   150.635     0.200
    13.057   182.344     0.200
    14.583   205.420     0.200
     1.146    20.273     0.200
     1.541    24.762     0.200
     1.649    26.953     0.200
     1.686    27.363     0.200
     1.782    28.895     0.200
     1.816    29.625     0.200
     1.841    29.965     0.200
     1.828    29.645     0.200
     1.839    29.895     0.200
     1.856    30.492     0.200
     1.865    30.523     0.200
     2.056    32.965     0.200
     2.115    33.922     0.200
     2.136    33.773     0.200
     2.637    41.703     0.200
     2.819    42.902     0.200
     3.031    46.684     0.200
     3.082    47.691     0.200
     3.245    49.332     0.200
     3.306    51.055     0.200
     3.321    50.145     0.200
     3.315    50.215     0.200
     3.784    57.242     0.200
     3.855    58.305     0.200
     3.895    58.785     0.200
     3.990    56.723     0.200
     3.970    57.922     0.200
     4.138    61.094     0.200
     4.210    62.004     0.200
     4.225    63.133     0.200
     4.530    67.043     0.200
     4.599    67.844     0.200
     4.634    68.965     0.200
     4.669    69.664     0.200
     4.767    69.762     0.200
     4.907    71.145     0.200
     4.944    72.395     0.200
     5.150    75.773     0.200
     5.295    76.395     0.200
     5.343    77.793     0.200
     5.349    77.223     0.200
     5.404    76.684     0.200
     5.531    79.633     0.200
     5.554    80.203     0.200
     5.587    80.453     0.200
     5.712    84.414     0.200
     5.852    85.633     0.200
     5.945    85.535     0.200
     5.988    86.953     0.200
     6.063    87.672     0.200
     6.133    88.473     0.200
     6.232    89.414     0.200
     6.220    91.555     0.200
     6.341    92.203     0.200
     6.363    91.535     0.200
     6.528    94.164     0.200
     6.529    94.324     0.200
     6.611    95.012     0.200
     6.657    95.473     0.200
     6.817    98.234     0.200
     6.831    97.715     0.200
     6.833    98.023     0.200
     6.922    99.633     0.200
     6.959   100.691     0.200
     7.048   101.242     0.200
     7.097   101.543     0.200
     7.093   102.094     0.200
     7.073   101.414     0.200
     7.101   101.152     0.200
     7.167   102.414     0.200
     7.401   106.102     0.200
     7.420   105.992     0.200
     7.464   106.992     0.200
     7.493   108.375     0.200
     7.923   113.453     0.200
     8.193   115.582     0.200
     8.330   119.191     0.200
     8.615   124.324     0.200
     8.671   122.965     0.200
     8.671   122.363     0.200
     8.671   123.555     0.200
     9.293   132.785     0.200
    14.695   206.383     0.200
     0.088    18.064     0.200
     0.274    18.596     0.200
     0.329    18.465     0.200
     0.363    18.885     0.200
     0.374    19.045     0.200
     0.435    19.135     0.200
     0.480    19.586     0.200
     0.600    20.346     0.200
     0.631    20.555     0.200
     1.075    24.064     0.200
     1.141    25.355     0.200
     1.147    25.346     0.200
     1.154    25.445     0.200
     1.163    25.445     0.200
     1.123    24.506     0.200
     1.110    24.775     0.200
     1.187    25.656     0.200
     1.138    24.645     0.200
     1.421    28.105     0.200
     1.622    28.695     0.200
     1.701    31.305     0.200
     1.747    30.125     0.200
     1.764    31.945     0.200
     2.158    36.625     0.200
     2.160    35.395     0.200
     2.195    37.055     0.200
     2.215    36.756     0.200
     2.196    37.045     0.200
     2.198    37.326     0.200
     2.234    37.586     0.200
     2.325    38.605     0.200
     2.467    40.625     0.200
     2.843    43.535     0.200
     2.946    47.096     0.200
     2.965    46.895     0.200
     2.932    45.805     0.200
     2.976    47.826     0.200
     2.992    47.426     0.200
     2.998    47.395     0.200
     3.035    48.166     0.200
     3.091    48.486     0.200
     3.135    48.814     0.200
     3.328    51.375     0.200
     3.314    51.635     0.200
     3.298    51.135     0.200
     3.594    54.746     0.200
     3.676    55.072     0.200
     3.676    55.406     0.200
     3.803    57.695     0.200
     4.109    60.516     0.200
     4.226    61.326     0.200
     4.294    64.725     0.200
     4.364    63.516     0.200
     4.420    64.336     0.200
     4.397    64.465     0.200
     4.481    66.242     0.200
     4.481    66.346     0.200
     4.508    68.615     0.200
     4.542    65.516     0.200
     4.625    67.865     0.200
     4.631    67.705     0.200
     4.658    67.475     0.200
     4.656    67.236     0.200
     4.752    69.596     0.200
     4.883    70.195     0.200
     5.048    72.785     0.200
     5.120    74.045     0.200
     5.154    74.666     0.200
     5.220    75.115     0.200
     5.305    76.086     0.200
     5.348    77.826     0.200
     5.336    77.535     0.200
     5.381    76.975     0.200
     5.372    77.736     0.200
     5.397    77.295     0.200
     5.441    78.055     0.200
     5.623    81.355     0.200
     5.646    81.375     0.200
     5.662    82.266     0.200
     5.652    81.203     0.200
     5.676    81.375     0.200
     5.812    83.814     0.200
     5.820    83.535     0.200
     5.830    83.635     0.200
     5.851    83.346     0.200
     5.936    85.656     0.200
     5.925    84.676     0.200
     5.925    84.795     0.200
     6.001    86.506     0.200
     6.060    87.221     0.200
     6.096    87.275     0.200
     6.254    89.986     0.200
     6.326    90.576     0.200
     6.344    90.936     0.200
     6.433    92.215     0.200
     6.427    91.455     0.200
     6.447    92.475     0.200
     6.482    93.035     0.200
     6.550    93.736     0.200
     6.595    94.535     0.200
     6.635    93.471     0.200
     6.635    93.746     0.200
     6.680    95.336     0.200
     6.688    96.115     0.200
     6.740    95.207     0.200
     6.740    95.615     0.200
     6.749    95.295     0.200
     6.798    97.416     0.200
     6.859    98.055     0.200
     6.877    98.465     0.200
     6.893    98.535     0.200
     6.923    99.145     0.200
     6.964    98.135     0.200
     6.987    98.455     0.200
     7.048   100.996     0.200
     7.075    99.479     0.200
     7.075    99.916     0.200
     7.127   100.314     0.200
     7.137   101.016     0.200
     7.133   100.725     0.200
     7.141   100.250     0.200
     7.141   100.826     0.200
     7.144   100.496     0.200
     7.222   103.035     0.200
     7.236   103.725     0.200
     7.252   102.133     0.200
     7.252   102.516     0.200
     7.293   101.826     0.200
     7.293   101.885     0.200
     7.355   104.895     0.200
     7.356   105.225     0.200
     7.347   104.535     0.200
     7.394   105.576     0.200
     7.394   105.615     0.200
     7.446   104.852     0.200
     7.486   106.135     0.200
     7.498   107.236     0.200
     7.580   105.742     0.200
     7.580   106.055     0.200
     7.757   110.635     0.200
     7.796   110.836     0.200
     7.889   112.326     0.200
     7.889   112.236     0.200
     7.967   114.035     0.200
     7.930   112.215     0.200
     7.985   113.006     0.200
     8.009   113.455     0.200
     8.173   115.535     0.200
     8.282   116.746     0.200
     8.842   125.406     0.200
     9.043   126.465     0.200
     9.159   126.725     0.200
     9.309   130.996     0.200
    10.007   137.246     0.200
    10.021   137.756     0.200
    10.249   143.314     0.200
    10.455   146.346     0.200
    10.691   148.096     0.200
    10.891   153.125     0.200
    11.472   161.385     0.200
    12.399   169.836     0.200
    13.112   182.135     0.200
     0.997    16.789     0.200
     1.220    20.609     0.200
     1.434    24.066     0.200
     1.440    24.668     0.200
     1.458    24.707     0.200
     1.461    24.707     0.200
     1.571    25.809     0.200
     1.495    24.328     0.200
     1.523    25.289     0.200
     1.566    25.977     0.200
     1.641    27.117     0.200
     1.608    26.047     0.200
     1.607    26.586     0.200
     1.677    27.746     0.200
     1.752    28.168     0.200
     1.821    28.176     0.200
     1.860    29.176     0.200
     1.853    29.418     0.200
     1.951    30.996     0.200
     2.004    31.859     0.200
     2.427    37.949     0.200
     2.457    38.109     0.200
     2.520    37.406     0.200
     2.536    38.977     0.200
     2.553    39.168     0.200
     2.677    40.277     0.200
     2.764    41.488     0.200
     2.893    42.406     0.200
     3.219    48.719     0.200
     3.222    48.848     0.200
     3.250    49.148     0.200
     3.306    49.246     0.200
     3.329    50.508     0.200
     3.458    50.797     0.200
     3.462    52.199     0.200
     3.506    51.457     0.200
     3.483    51.457     0.200
     3.784    54.457     0.200
     3.875    56.117     0.200
     3.883    56.617     0.200
     4.010    57.449     0.200
     3.956    58.266     0.200
     4.093    59.266     0.200
     4.520    65.816     0.200
     4.552    66.496     0.200
     4.533    66.176     0.200
     4.713    68.496     0.200
     4.712    68.496     0.200
     4.879    70.316     0.200
     4.975    72.059     0.200
     5.083    73.898     0.200
     5.068    73.098     0.200
     5.260    75.938     0.200
     5.250    76.176     0.200
     5.396    77.539     0.200
     5.463    78.027     0.200
     5.490    78.758     0.200
     5.532    79.559     0.200
     5.548    79.898     0.200
     5.501    79.719     0.200
     5.556    80.316     0.200
     5.586    80.398     0.200
     5.625    81.227     0.200
     5.692    81.906     0.200
     5.730    82.336     0.200
     5.749    82.777     0.200
     5.868    84.086     0.200
     5.884    85.016     0.200
     6.180    88.789     0.200
     6.192    89.109     0.200
     6.287    90.207     0.200
     6.526    93.559     0.200
     6.802    97.086     0.200
     6.872    98.008     0.200
     6.953    98.766     0.200
     7.161   102.176     0.200
     7.205   102.816     0.200
     7.192   102.758     0.200
     7.216   102.059     0.200
     7.216   102.438     0.200
     7.216   102.648     0.200
     7.252   103.648     0.200
     7.765   110.328     0.200
     8.023   114.527     0.200
     7.987   113.996     0.200
     8.583   121.297     0.200
     9.255   130.949     0.200
     9.459   132.656     0.200
    10.037   141.156     0.200
    10.695   151.207     0.200
    11.719   165.086     0.200
    11.719   163.398     0.200
    19.000   259.387     0.200
     1.727    28.354     0.200
     1.833    29.824     0.200
     1.908    31.594     0.200
     1.903    31.014     0.200
     1.944    31.463     0.200
     1.971    32.033     0.200
     2.556    41.234     0.200
     2.557    41.244     0.200
     2.561    40.773     0.200
     2.841    44.953     0.200
     2.880    44.594     0.200
     2.943    45.834     0.200
     3.145    49.064     0.200
     3.168    48.023     0.200
     3.157    48.164     0.200
     3.205    49.533     0.200
     3.431    52.174     0.200
     3.680    55.834     0.200
     3.752    57.053     0.200
     3.801    55.895     0.200
     3.787    57.174     0.200
     3.985    59.145     0.200
     4.065    60.033     0.200
     4.082    62.094     0.200
     4.415    65.994     0.200
     4.441    66.514     0.200
     4.467    66.824     0.200
     4.483    66.994     0.200
     4.481    66.633     0.200
     4.517    67.373     0.200
     4.563    68.633     0.200
     4.615    67.834     0.200
     4.737    68.924     0.200
     4.735    70.434     0.200
     4.808    70.904     0.200
     5.116    73.553     0.200
     5.181    74.783     0.200
     5.194    74.924     0.200
     5.220    74.584     0.200
     5.234    76.293     0.200
     5.342    77.213     0.200
     5.407    78.133     0.200
     5.400    77.723     0.200
     5.515    79.984     0.200
     5.557    80.395     0.200
     5.658    81.334     0.200
     5.753    82.834     0.200
     5.821    84.744     0.200
     5.953    85.863     0.200
     6.042    86.984     0.200
     6.111    89.734     0.200
     6.283    91.484     0.200
     6.304    91.824     0.200
     6.357    92.564     0.200
     6.413    92.424     0.200
     6.394    92.414     0.200
     6.472    93.803     0.200
     6.494    94.314     0.200
     6.559    94.814     0.200
     6.621    95.814     0.200
     6.642    95.443     0.200
     6.642    95.604     0.200
     6.638    96.674     0.200
     6.728    97.963     0.200
     6.750    97.053     0.200
     6.794    98.314     0.200
     6.838    98.773     0.200
     6.899    99.584     0.200
     6.902    99.234     0.200
     6.906    99.504     0.200
     6.893    99.713     0.200
     6.932    99.994     0.200
     6.972   100.594     0.200
     7.007   100.574     0.200
     7.065   101.584     0.200
     7.202   104.363     0.200
     7.230   103.584     0.200
     7.251   104.443     0.200
     7.268   104.053     0.200
     7.359   105.453     0.200
     7.375   105.504     0.200
     7.434   106.414     0.200
     7.724   110.354     0.200
     7.723   111.004     0.200
     7.756   110.844     0.200
     7.988   114.723     0.200
     8.053   114.604     0.200
     8.135   116.684     0.200
     8.181   117.283     0.200
     8.260   117.443     0.200
     8.468   122.213     0.200
     8.496   120.523     0.200
     8.525   121.764     0.200
     8.525   121.289     0.200
     8.525   122.504     0.200
     8.692   125.314     0.200
     9.217   130.844     0.200
     9.201   130.883     0.200
     9.447   134.904     0.200
     9.858   140.793     0.200
     9.905   141.273     0.200
     9.901   140.904     0.200
    10.146   144.383     0.200
    10.194   145.523     0.200
    10.450   148.514     0.200
    10.529   148.564     0.200
    11.332   158.395     0.200
    11.346   161.473     0.200
    12.438   176.404     0.200
    14.525   204.789     0.200
    14.525   204.395     0.200
    14.637   205.104     0.200
    20.003   271.693     0.200
     0.026    13.227     0.200
     0.184    13.574     0.200
     0.134    13.895     0.200
     0.152    13.625     0.200
     0.164    13.465     0.200
     0.170    13.484     0.200
     0.191    13.664     0.200
     0.263    14.285     0.200
     0.315    14.367     0.200
     0.280    14.234     0.200
     0.424    15.348     0.200
     0.486    15.406     0.200
     0.503    15.645     0.200
     0.569    16.426     0.200
     0.815    18.277     0.200
     0.921    19.285     0.200
     1.309    23.047     0.200
     1.342    23.805     0.200
     1.464    26.305     0.200
     1.465    26.336     0.200
     1.654    27.414     0.200
     2.073    34.016     0.200
     2.138    34.746     0.200
     2.356    35.945     0.200
     2.619    40.055     0.200
     2.550    40.367     0.200
     2.589    40.836     0.200
     2.597    41.105     0.200
     2.645    41.566     0.200
     2.680    40.848     0.200
     2.737    41.605     0.200
     2.724    42.734     0.200
     2.973    45.277     0.200
     3.373    50.215     0.200
     3.408    50.938     0.200
     3.446    52.348     0.200
     3.472    51.566     0.200
     3.579    53.414     0.200
     3.724    56.258     0.200
     3.962    58.805     0.200
     3.983    58.406     0.200
     4.115    60.164     0.200
     4.193    61.555     0.200
     4.221    62.227     0.200
     4.353    63.016     0.200
     4.549    64.906     0.200
     4.655    66.855     0.200
     4.684    68.098     0.200
     4.689    68.117     0.200
     4.749    68.617     0.200
     4.824    71.117     0.200
     4.872    70.207     0.200
     4.910    70.996     0.200
     4.964    73.348     0.200
     5.073    72.164     0.200
     5.314    76.027     0.200
     5.339    76.617     0.200
     5.598    79.836     0.200
     5.679    81.098     0.200
     5.676    80.777     0.200
     5.723    81.457     0.200
     5.754    82.484     0.200
     5.795    82.996     0.200
     5.774    82.074     0.200
     5.778    83.438     0.200
     5.800    83.414     0.200
     5.935    85.055     0.200
     5.934    84.715     0.200
     5.996    85.414     0.200
     6.074    85.797     0.200
     6.217    88.598     0.200
     6.207    87.855     0.200
     6.282    89.875     0.200
     6.282    89.348     0.200
     6.447    91.797     0.200
     6.543    92.965     0.200
     6.591    93.836     0.200
     6.613    94.188     0.200
     6.610    93.566     0.200
     6.652    94.855     0.200
     6.735    95.496     0.200
     6.742    96.426     0.200
     6.865    97.734     0.200
     6.923    98.477     0.200
     7.006    99.664     0.200
     7.015    99.848     0.200
     7.048    99.996     0.200
     7.152   101.715     0.200
     7.161   100.035     0.200
     7.236   102.887     0.200
     7.334   104.824     0.200
     7.346   104.527     0.200
     7.372   104.895     0.200
     7.375   102.656     0.200
     7.379   103.305     0.200
     7.461   106.195     0.200
     7.497   106.875     0.200
     7.518   105.395     0.200
     7.557   105.305     0.200
     7.750   109.188     0.200
     7.694   107.164     0.200
     7.694   106.617     0.200
     7.836   110.758     0.200
     7.887   112.016     0.200
     8.128   114.855     0.200
     8.153   115.484     0.200
     9.590   135.055     0.200
     9.865   138.117     0.200
    10.446   143.984     0.200
    10.553   148.176     0.200
     0.135    13.457     0.200
     0.461    14.957     0.200
     0.615    16.035     0.200
     0.630    16.336     0.200
     0.726    17.477     0.200
     0.783    18.418     0.200
     0.784    18.398     0.200
     0.788    18.496     0.200
     0.873    18.758     0.200
     0.859    18.746     0.200
     0.802    18.535     0.200
     0.811    18.598     0.200
     0.979    20.035     0.200
     1.204    21.906     0.200
     1.092    21.766     0.200
     1.515    25.508     0.200
     1.405    25.379     0.200
     1.499    26.227     0.200
     1.573    27.168     0.200
     1.539    27.078     0.200
     1.599    27.176     0.200
     1.621    28.195     0.200
     1.723    28.746     0.200
     1.889    31.477     0.200
     1.933    32.309     0.200
     1.942    32.238     0.200
     1.997    31.746     0.200
     2.112    33.277     0.200
     1.997    32.996     0.200
     2.061    32.605     0.200
     2.045    33.578     0.200
     2.066    33.777     0.200
     2.547    39.777     0.200
     2.591    41.719     0.200
     2.712    41.387     0.200
     2.720    42.535     0.200
     2.794    41.906     0.200
     2.748    43.098     0.200
     2.791    43.578     0.200
     2.791    43.766     0.200
     2.839    43.996     0.200
     2.965    44.367     0.200
     2.886    44.059     0.200
     3.065    47.059     0.200
     3.314    49.688     0.200
     3.287    48.957     0.200
     3.279    49.969     0.200
     3.567    53.016     0.200
     3.700    55.367     0.200
     3.663    53.945     0.200
     3.854    55.938     0.200
     3.959    57.445     0.200
     4.089    59.016     0.200
     4.094    58.727     0.200
     4.054    59.277     0.200
     4.191    60.156     0.200
     4.252    61.926     0.200
     4.207    61.586     0.200
     4.274    62.469     0.200
     4.401    62.867     0.200
     4.351    65.297     0.200
     4.356    64.457     0.200
     4.378    64.547     0.200
     4.488    65.176     0.200
     4.656    66.887     0.200
     4.643    67.309     0.200
     4.806    69.988     0.200
     4.878    70.688     0.200
     4.852    70.398     0.200
     4.917    70.996     0.200
     4.991    71.766     0.200
     4.992    71.879     0.200
     5.030    72.309     0.200
     5.111    73.766     0.200
     5.135    75.078     0.200
     5.092    73.309     0.200
     5.144    74.629     0.200
     5.150    74.387     0.200
     5.239    75.188     0.200
     5.297    75.426     0.200
     5.331    76.648     0.200
     5.417    77.945     0.200
     5.401    77.227     0.200
     5.477    79.188     0.200
     5.489    79.535     0.200
     5.517    79.027     0.200
     5.581    79.926     0.200
     5.599    80.336     0.200
     5.658    81.219     0.200
     5.668    82.266     0.200
     5.742    82.027     0.200
     5.811    83.168     0.200
     5.868    83.918     0.200
     5.942    85.348     0.200
     5.959    86.117     0.200
     6.028    86.566     0.200
     6.045    86.418     0.200
     6.088    86.719     0.200
     6.196    88.648     0.200
     6.285    89.988     0.200
     6.355    90.969     0.200
     6.383    91.945     0.200
     6.398    92.016     0.200
     6.393    91.477     0.200
     6.527    93.855     0.200
     6.497    91.469     0.200
     6.595    94.168     0.200
     6.651    94.746     0.200
     6.720    96.047     0.200
     6.703    94.398     0.200
     6.711    94.227     0.200
     6.796    97.438     0.200
     6.780    95.277     0.200
     6.835    97.977     0.200
     6.850    98.117     0.200
     6.881    97.238     0.200
     6.898    96.656     0.200
     6.901    97.129     0.200
     6.902    97.156     0.200
     6.975    99.035     0.200
     6.972    99.086     0.200
     7.021    98.535     0.200
     7.021    98.445     0.200
     7.228   102.969     0.200
     7.200   101.527     0.200
     7.218   102.129     0.200
     7.314   104.258     0.200
     7.461   105.355     0.200
     7.483   106.777     0.200
     7.637   108.129     0.200
     7.895   111.617     0.200
     8.205   116.906     0.200
     8.409   118.367     0.200
     8.673   121.086     0.200
     8.776   122.926     0.200
     8.895   124.957     0.200
     9.711   137.266     0.200
     9.934   140.027     0.200
    10.049   143.996     0.200
    10.143   141.656     0.200
    10.213   143.969     0.200
    10.344   146.367     0.200
    12.569   176.707     0.200
    16.806   227.445     0.200
     1.602    29.758     0.200
     1.602    29.270     0.200
     1.918    33.410     0.200
     2.483    42.609     0.200
     2.503    42.441     0.200
     2.503    42.301     0.200
     2.506    42.789     0.200
     2.567    44.441     0.200
     3.126    50.609     0.200
     3.191    51.789     0.200
     3.324    52.359     0.200
     3.398    55.680     0.200
     3.549    56.531     0.200
     3.580    57.172     0.200
     3.611    57.152     0.200
     3.649    58.660     0.200
     3.654    58.980     0.200
     3.717    59.461     0.200
     3.788    60.051     0.200
     3.991    64.129     0.200
     4.064    63.961     0.200
     4.084    64.949     0.200
     4.121    65.742     0.200
     4.282    67.352     0.200
     4.299    65.801     0.200
     4.333    67.371     0.200
     4.442    69.512     0.200
     4.473    69.250     0.200
     4.513    70.520     0.200
     4.561    70.762     0.200
     4.787    74.262     0.200
     4.939    76.020     0.200
     4.985    77.109     0.200
     5.105    78.199     0.200
     5.221    79.129     0.200
     5.260    80.109     0.200
     5.471    83.031     0.200
     5.506    83.512     0.200
     5.517    83.012     0.200
     5.582    83.332     0.200
     5.644    84.402     0.200
     5.690    84.762     0.200
     5.721    86.270     0.200
     5.852    86.492     0.200
     5.913    88.770     0.200
     5.923    89.262     0.200
     5.989    90.031     0.200
     6.059    92.910     0.200
     6.042    89.312     0.200
     6.258    93.699     0.200
     6.355    94.410     0.200
     6.354    94.320     0.200
     6.428    95.172     0.200
     6.495    96.180     0.200
     6.519    97.129     0.200
     6.590    97.539     0.200
     6.703    99.609     0.200
     6.682    98.691     0.200
     6.706    99.141     0.200
     6.740    99.191     0.200
     6.796   101.129     0.200
     6.804   100.641     0.200
     6.862   102.430     0.200
     6.836   101.680     0.200
     6.872   102.082     0.200
     6.867   100.891     0.200
     6.997   103.211     0.200
     7.116   104.820     0.200
     7.093   104.820     0.200
     7.092   104.129     0.200
     7.184   106.082     0.200
     7.262   107.129     0.200
     7.272   106.762     0.200
     7.316   107.371     0.200
     7.372   108.840     0.200
     7.387   108.262     0.200
     7.354   108.289     0.200
     7.409   108.750     0.200
     7.569   111.129     0.200
     7.612   112.129     0.200
     7.602   112.129     0.200
     7.681   113.430     0.200
     7.689   112.250     0.200
     7.743   113.129     0.200
     7.757   113.469     0.200
     7.758   113.949     0.200
     7.926   116.129     0.200
     7.965   116.730     0.200
     8.056   117.602     0.200
     8.066   117.969     0.200
     8.145   118.930     0.200
     8.165   119.230     0.200
     8.216   119.621     0.200
     8.295   120.199     0.200
     8.262   120.129     0.200
     8.413   122.551     0.200
     8.429   122.141     0.200
     8.390   122.172     0.200
     8.440   124.590     0.200
     8.601   124.520     0.200
     8.623   124.641     0.200
     8.612   126.992     0.200
     8.659   125.871     0.200
     8.736   126.820     0.200
     8.736   126.543     0.200
     8.723   127.121     0.200
     8.718   125.820     0.200
     8.881   128.832     0.200
     8.920   130.762     0.200
     9.013   130.461     0.200
     9.014   130.320     0.200
     9.014   131.312     0.200
     9.023   131.629     0.200
     9.517   139.539     0.200
     9.523   137.961     0.200
     9.812   142.062     0.200
     9.895   143.602     0.200
    10.313   149.641     0.200
    10.475   151.320     0.200
    10.469   152.031     0.200
    11.119   159.500     0.200
    11.586   166.910     0.200
    13.500   194.117     0.200
    14.934   211.164     0.200
    14.934   212.699     0.200
     1.184    19.547     0.200
     1.459    24.836     0.200
     1.491    25.316     0.200
     1.502    25.258     0.200
     1.513    26.168     0.200
     1.521    26.227     0.200
     1.534    26.559     0.200
     1.534    26.148     0.200
     1.562    26.496     0.200
     1.671    27.426     0.200
     1.714    28.156     0.200
     1.735    27.957     0.200
     1.718    28.957     0.200
     1.765    28.828     0.200
     1.798    29.559     0.200
     1.858    30.156     0.200
     1.949    31.777     0.200
     1.968    32.168     0.200
     2.008    30.906     0.200
     2.016    32.648     0.200
     2.068    33.426     0.200
     2.098    33.438     0.200
     2.350    35.859     0.200
     2.373    37.246     0.200
     2.410    38.277     0.200
     2.414    38.117     0.200
     2.426    38.289     0.200
     2.496    38.598     0.200
     2.548    39.078     0.200
     2.531    39.770     0.200
     2.535    39.488     0.200
     2.569    39.918     0.200
     2.695    42.477     0.200
     3.177    47.789     0.200
     3.177    48.578     0.200
     3.200    49.059     0.200
     3.287    49.219     0.200
     3.406    51.547     0.200
     3.415    51.078     0.200
     3.571    53.316     0.200
     3.559    53.199     0.200
     3.683    54.238     0.200
     3.730    55.168     0.200
     3.807    55.398     0.200
     3.893    57.789     0.200
     3.962    58.199     0.200
     3.959    58.449     0.200
     4.109    61.387     0.200
     4.325    63.117     0.200
     4.370    64.859     0.200
     4.400    64.828     0.200
     4.520    66.387     0.200
     4.663    68.387     0.200
     4.758    68.949     0.200
     4.813    72.008     0.200
     4.909    72.406     0.200
     5.072    74.438     0.200
     5.058    73.918     0.200
     5.169    75.156     0.200
     5.252    75.898     0.200
     5.304    76.617     0.200
     5.246    76.246     0.200
     5.266    76.617     0.200
     5.460    79.277     0.200
     5.418    79.527     0.200
     5.533    80.309     0.200
     5.486    80.906     0.200
     5.516    80.508     0.200
     5.586    80.879     0.200
     5.647    82.137     0.200
     5.642    81.789     0.200
     5.776    84.117     0.200
     5.858    84.938     0.200
     5.821    84.879     0.200
     5.955    86.469     0.200
     6.057    87.496     0.200
     6.285    90.668     0.200
     6.559    94.547     0.200
     6.630    94.387     0.200
     6.635    95.637     0.200
     7.095   101.719     0.200
     7.095   101.742     0.200
     7.341   105.758     0.200
     7.411   106.477     0.200
     7.961   113.367     0.200
     8.011   114.457     0.200
     8.145   115.809     0.200
    18.765   258.102     0.200
     0.187    18.762     0.200
     0.166    18.582     0.200
     0.299    19.203     0.200
     0.393    19.555     0.200
     0.468    19.523     0.200
     0.977    23.574     0.200
     1.025    24.004     0.200
     1.041    24.262     0.200
     1.236    26.402     0.200
     1.242    26.422     0.200
     1.243    26.574     0.200
     1.258    26.625     0.200
     1.518    29.453     0.200
     1.632    29.285     0.200
     1.719    30.125     0.200
     1.799    32.293     0.200
     1.861    33.062     0.200
     2.099    34.895     0.200
     2.301    38.293     0.200
     2.255    37.691     0.200
     2.292    38.273     0.200
     2.296    38.574     0.200
     2.331    38.762     0.200
     2.562    40.953     0.200
     2.636    41.473     0.200
     2.542    41.285     0.200
     2.834    44.645     0.200
     3.042    48.734     0.200
     3.026    47.914     0.200
     3.154    49.914     0.200
     3.132    49.422     0.200
     3.200    49.941     0.200
     3.188    49.922     0.200
     3.229    50.023     0.200
     3.420    52.602     0.200
     3.411    52.973     0.200
     3.691    56.184     0.200
     3.772    56.785     0.200
     3.900    59.094     0.200
     4.202    61.562     0.200
     4.323    62.805     0.200
     4.369    65.254     0.200
     4.459    64.824     0.200
     4.392    65.645     0.200
     4.517    65.883     0.200
     4.601    69.332     0.200
     4.700    68.902     0.200
     4.705    68.895     0.200
     4.749    68.754     0.200
     4.837    70.762     0.200
     4.971    71.574     0.200
     5.144    73.953     0.200
     5.240    75.602     0.200
     5.439    78.742     0.200
     5.403    77.352     0.200
     5.431    79.055     0.200
     5.478    78.422     0.200
     5.468    79.172     0.200
     5.495    78.633     0.200
     5.534    79.492     0.200
     5.741    83.004     0.200
     5.731    82.734     0.200
     5.747    82.664     0.200
     5.773    83.004     0.200
     5.894    85.043     0.200
     5.907    84.953     0.200
     5.923    86.215     0.200
     6.017    86.465     0.200
     6.081    87.324     0.200
     6.022    86.125     0.200
     6.151    88.523     0.200
     6.178    88.691     0.200
     6.408    91.852     0.200
     6.433    92.172     0.200
     6.521    93.242     0.200
     6.532    93.473     0.200
     6.562    94.055     0.200
     6.524    93.895     0.200
     6.630    95.125     0.200
     6.679    95.512     0.200
     6.769    96.852     0.200
     6.731    94.742     0.200
     6.881    98.402     0.200
     6.845    96.535     0.200
     6.944    99.094     0.200
     6.964    99.504     0.200
     6.979    99.352     0.200
     7.002   100.223     0.200
     7.129   101.582     0.200
     7.060    99.223     0.200
     7.084    99.633     0.200
     7.190   102.934     0.200
     7.169   101.375     0.200
     7.235   102.344     0.200
     7.224   101.645     0.200
     7.228   101.852     0.200
     7.238   101.754     0.200
     7.240   101.934     0.200
     7.316   104.762     0.200
     7.307   104.164     0.200
     7.440   105.602     0.200
     7.390   103.344     0.200
     7.390   103.234     0.200
     7.444   106.125     0.200
     7.569   107.492     0.200
     7.478   105.582     0.200
     7.478   106.684     0.200
     7.542   105.941     0.200
     7.677   108.113     0.200
     7.885   111.984     0.200
     7.984   112.715     0.200
     7.984   112.684     0.200
     0.888    15.754     0.200
     1.057    18.402     0.200
     1.336    22.113     0.200
     1.553    25.543     0.200
     1.552    25.531     0.200
     1.547    25.211     0.200
     1.668    27.633     0.200
     1.702    27.773     0.200
     1.710    28.328     0.200
     1.796    29.531     0.200
     1.918    30.992     0.200
     1.915    31.555     0.200
     2.011    31.941     0.200
     2.413    38.211     0.200
     2.437    38.121     0.200
     2.876    45.203     0.200
     2.880    45.145     0.200
     2.896    44.223     0.200
     3.186    49.562     0.200
     3.224    48.184     0.200
     3.408    52.234     0.200
     3.503    53.602     0.200
     3.510    54.121     0.200
     3.509    53.262     0.200
     3.806    56.645     0.200
     3.823    57.121     0.200
     3.989    60.152     0.200
     4.033    60.805     0.200
     4.105    61.844     0.200
     4.167    62.832     0.200
     4.537    66.453     0.200
     4.521    66.023     0.200
     4.608    67.242     0.200
     4.610    68.082     0.200
     4.797    71.254     0.200
     4.890    72.172     0.200
     4.935    72.512     0.200
     5.154    77.121     0.200
     5.160    76.082     0.200
     5.229    76.164     0.200
     5.324    78.102     0.200
     5.455    78.805     0.200
     5.664    81.262     0.200
     5.798    83.371     0.200
     5.812    84.863     0.200
     5.849    84.203     0.200
     5.891    84.652     0.200
     6.029    85.793     0.200
     6.189    88.652     0.200
     6.204    89.395     0.200
     6.365    91.953     0.200
     6.388    93.734     0.200
     6.432    91.902     0.200
     6.466    95.023     0.200
     6.515    93.723     0.200
     6.695    95.562     0.200
     6.727    96.812     0.200
     6.891    98.664     0.200
     7.079   101.953     0.200
     7.124   102.133     0.200
     7.220   103.652     0.200
     7.247   103.805     0.200
     7.252   103.992     0.200
     7.279   104.434     0.200
     7.337   104.824     0.200
     7.385   105.281     0.200
     7.462   106.293     0.200
     7.479   106.871     0.200
     7.500   107.133     0.200
     7.517   107.012     0.200
     7.661   109.434     0.200
     7.664   108.812     0.200
     7.771   109.703     0.200
     7.759   110.094     0.200
     7.800   110.742     0.200
     7.829   111.684     0.200
     7.860   111.984     0.200
     7.946   113.254     0.200
     7.977   113.352     0.200
     8.165   116.352     0.200
     8.191   116.414     0.200
     8.265   117.164     0.200
     8.464   121.703     0.200
     8.429   119.852     0.200
     8.570   120.664     0.200
     8.685   123.402     0.200
     8.720   125.633     0.200
     8.747   123.863     0.200
     8.783   122.492     0.200
     8.874   124.703     0.200
     8.860   125.902     0.200
     8.876   127.984     0.200
     8.987   126.773     0.200
     8.989   126.812     0.200
     9.013   127.383     0.200
     9.077   127.734     0.200
     9.077   127.664     0.200
     9.077   127.973     0.200
     9.221   129.781     0.200
     9.221   131.012     0.200
     9.277   130.402     0.200
     9.441   133.523     0.200
     9.441   133.883     0.200
     9.519   133.844     0.200
     9.952   140.004     0.200
    10.573   149.414     0.200
    10.684   149.871     0.200
    10.697   150.062     0.200
    10.986   154.773     0.200
    11.034   157.742     0.200
    11.143   157.492     0.200
    11.153   155.934     0.200
    11.856   165.395     0.200
    11.869   164.684     0.200
    12.085   171.062     0.200
    12.186   170.645     0.200
    15.216   214.363     0.200
    16.032   223.594     0.200
     0.473    10.855     0.200
     0.850    15.480     0.200
     0.996    17.309     0.200
     1.299    22.449     0.200
     1.305    22.668     0.200
     1.319    22.727     0.200
     1.590    25.203     0.200
     1.588    26.527     0.200
     1.638    26.816     0.200
     1.650    26.887     0.200
     1.809    29.258     0.200
     1.808    29.246     0.200
     1.792    28.469     0.200
     1.897    30.328     0.200
     1.958    31.137     0.200
     2.107    32.637     0.200
     2.130    33.234     0.200
     2.371    36.867     0.200
     2.415    37.578     0.200
     2.549    39.309     0.200
     2.843    41.992     0.200
     2.907    43.438     0.200
     2.918    45.316     0.200
     2.918    45.598     0.200
     3.032    44.738     0.200
     3.189    47.801     0.200
     3.189    47.906     0.200
     3.215    48.629     0.200
     3.234    47.707     0.200
     3.258    49.289     0.200
     3.253    48.348     0.200
     3.296    49.746     0.200
     3.526    51.887     0.200
     3.526    52.047     0.200
     3.518    52.438     0.200
     3.640    53.926     0.200
     3.769    55.016     0.200
     4.021    58.582     0.200
     4.021    58.719     0.200
     4.108    59.168     0.200
     4.108    59.039     0.200
     4.194    60.957     0.200
     4.501    64.859     0.200
     4.501    65.309     0.200
     4.594    66.121     0.200
     4.818    69.578     0.200
     4.809    69.812     0.200
     4.874    71.016     0.200
     4.874    71.316     0.200
     4.950    71.449     0.200
     4.996    72.309     0.200
     5.062    72.086     0.200
     5.062    72.887     0.200
     5.059    72.992     0.200
     5.059    72.789     0.200
     5.165    74.406     0.200
     5.297    76.039     0.200
     5.389    77.391     0.200
     5.389    77.996     0.200
     5.429    77.773     0.200
     5.596    80.559     0.200
     5.596    80.438     0.200
     5.635    80.793     0.200
     5.635    81.219     0.200
     5.622    80.988     0.200
     5.778    82.348     0.200
     5.861    83.758     0.200
     5.852    84.215     0.200
     5.905    84.988     0.200
     6.064    86.707     0.200
     6.153    87.766     0.200
     6.153    88.047     0.200
     6.247    88.688     0.200
     6.247    88.938     0.200
     6.306    90.129     0.200
     6.396    91.008     0.200
     6.623    94.688     0.200
     6.738    96.547     0.200
     6.790    97.246     0.200
     6.892    96.246     0.200
     7.054    99.656     0.200
     7.054    98.969     0.200
     7.091   100.012     0.200
     7.103    99.527     0.200
     7.178   101.176     0.200
     7.302   103.676     0.200
     7.304   102.824     0.200
     7.304   103.859     0.200
     7.321   102.547     0.200
     7.344   103.227     0.200
     7.344   102.977     0.200
     7.388   103.957     0.200
     7.388   103.988     0.200
     7.388   103.859     0.200
     7.557   107.078     0.200
     7.599   107.254     0.200
     7.599   107.707     0.200
     7.946   112.379     0.200
     8.322   117.156     0.200
     8.322   116.969     0.200
     8.499   121.258     0.200
     8.533   119.516     0.200
     8.718   123.734     0.200
     8.877   124.719     0.200
     9.304   129.277     0.200
     9.300   129.691     0.200
     9.300   129.297     0.200
    10.192   143.258     0.200
    10.605   149.594     0.200
    10.605   149.488     0.200
    10.740   149.457     0.200
    12.242   171.664     0.200
    13.514   190.078     0.200
    19.461   262.762     0.200
     0.641    12.777     0.200
     0.647    12.527     0.200
     0.753    14.098     0.200
     0.785    13.879     0.200
     0.785    14.480     0.200
     0.806    15.508     0.200
     0.823    15.398     0.200
     0.846    15.699     0.200
     0.886    16.160     0.200
     1.066    18.609     0.200
     1.161    19.387     0.200
     1.195    20.730     0.200
     1.225    21.039     0.200
     1.378    22.938     0.200
     1.491    24.949     0.200
     1.681    27.930     0.200
     1.686    27.750     0.200
     1.989    32.000     0.200
     2.305    35.859     0.200
     2.369    36.699     0.200
     2.632    39.617     0.200
     2.660    39.988     0.200
     2.780    41.918     0.200
     2.790    42.609     0.200
     2.834    43.887     0.200
     2.912    44.320     0.200
     2.969    45.070     0.200
     3.424    50.230     0.200
     3.482    51.828     0.200
     3.599    53.289     0.200
     3.656    54.109     0.200
     3.958    58.398     0.200
     4.117    60.910     0.200
     4.241    60.980     0.200
     4.301    61.859     0.200
     4.462    65.129     0.200
     4.730    68.410     0.200
     4.933    70.520     0.200
     5.068    72.570     0.200
     5.280    77.430     0.200
     5.300    76.859     0.200
     5.323    77.258     0.200
     5.343    77.410     0.200
     5.471    78.520     0.200
     5.526    79.438     0.200
     5.598    80.598     0.200
     5.693    81.320     0.200
     5.822    83.887     0.200
     5.972    84.859     0.200
     6.044    86.539     0.200
     6.054    87.367     0.200
     6.254    90.207     0.200
     6.370    90.879     0.200
     6.379    90.508     0.200
     6.441    92.680     0.200
     6.509    92.648     0.200
     6.534    92.738     0.200
     6.699    96.469     0.200
     6.787    96.469     0.200
     6.839    97.578     0.200
     6.877    97.887     0.200
     6.992    99.238     0.200
     7.098   100.438     0.200
     7.154   102.297     0.200
     7.186   101.758     0.200
     7.267   103.129     0.200
     7.370   104.277     0.200
     7.363   103.410     0.200
     7.526   106.449     0.200
     7.541   107.047     0.200
     7.576   106.160     0.200
     7.701   109.570     0.200
     7.870   111.020     0.200
     7.870   109.773     0.200
     7.870   112.098     0.200
     8.300   116.910     0.200
     8.300   118.168     0.200
     8.775   125.098     0.200
     9.709   136.887     0.200
     0.640    13.582     0.200
     0.655    14.633     0.200
     0.685    14.082     0.200
     0.803    15.504     0.200
     0.820    16.273     0.200
     0.838    16.324     0.200
     0.854    16.152     0.200
     0.936    17.395     0.200
     0.998    17.953     0.200
     1.161    20.273     0.200
     1.356    23.633     0.200
     1.361    23.695     0.200
     1.367    23.652     0.200
     1.375    23.863     0.200
     1.413    23.672     0.200
     1.426    23.902     0.200
     1.486    23.773     0.200
     1.568    25.684     0.200
     1.657    27.555     0.200
     1.693    27.305     0.200
     1.961    31.715     0.200
     1.982    31.625     0.200
     1.972    31.512     0.200
     2.035    32.012     0.200
     2.279    35.004     0.200
     2.310    35.672     0.200
     2.455    37.883     0.200
     2.499    38.734     0.200
     2.581    39.863     0.200
     2.633    40.613     0.200
     3.031    44.613     0.200
     3.050    47.012     0.200
     3.069    45.535     0.200
     3.092    46.195     0.200
     3.234    48.305     0.200
     3.281    49.375     0.200
     3.308    49.945     0.200
     3.322    50.184     0.200
     3.351    50.324     0.200
     3.617    53.742     0.200
     3.681    54.262     0.200
     3.766    56.512     0.200
     3.951    57.414     0.200
     4.121    60.023     0.200
     4.262    61.465     0.200
     4.316    62.195     0.200
     4.401    63.883     0.200
     4.467    64.652     0.200
     4.596    66.855     0.200
     4.662    67.223     0.200
     4.801    69.125     0.200
     4.952    71.285     0.200
     4.990    71.934     0.200
     5.037    73.453     0.200
     5.059    73.672     0.200
     5.095    73.062     0.200
     5.169    74.582     0.200
     5.209    74.965     0.200
     5.252    75.492     0.200
     5.266    76.012     0.200
     5.380    77.055     0.200
     5.450    78.074     0.200
     5.457    78.172     0.200
     5.482    78.863     0.200
     5.566    79.672     0.200
     5.660    80.812     0.200
     5.701    82.055     0.200
     5.717    82.035     0.200
     5.802    82.934     0.200
     5.831    83.152     0.200
     5.904    84.055     0.200
     6.052    86.773     0.200
     6.193    88.695     0.200
     6.185    88.273     0.200
     6.243    88.973     0.200
     6.525    92.984     0.200
     6.575    94.043     0.200
     6.681    95.535     0.200
     6.807    97.195     0.200
     6.884    98.254     0.200
     6.952    99.012     0.200
     6.961    97.484     0.200
     6.986    99.734     0.200
     7.014    98.695     0.200
     7.060   100.242     0.200
     7.237   102.273     0.200
     7.226   101.375     0.200
     7.333   103.105     0.200
     7.424   104.332     0.200
     7.437   104.395     0.200
     7.446   104.453     0.200
     7.483   106.082     0.200
     7.520   106.074     0.200
     7.519   105.434     0.200
     7.601   107.254     0.200
     7.609   107.215     0.200
     7.644   109.484     0.200
     7.721   109.164     0.200
     7.746   109.453     0.200
     7.995   112.445     0.200
     0.151    11.641     0.200
     0.342    13.070     0.200
     0.293    12.543     0.200
     0.337    12.910     0.200
     0.342    12.691     0.200
     0.388    13.191     0.200
     0.516    14.160     0.200
     0.481    13.941     0.200
     0.958    18.961     0.200
     0.966    18.992     0.200
     1.083    20.320     0.200
     1.186    21.461     0.200
     1.186    21.262     0.200
     1.207    21.453     0.200
     1.368    24.531     0.200
     1.388    24.652     0.200
     1.397    24.781     0.200
     1.630    26.941     0.200
     1.677    28.410     0.200
     1.987    32.410     0.200
     2.052    33.043     0.200
     2.180    35.121     0.200
     2.257    35.621     0.200
     2.400    36.812     0.200
     2.469    39.051     0.200
     2.512    39.672     0.200
     2.543    38.840     0.200
     2.571    40.430     0.200
     2.596    39.543     0.200
     2.753    42.430     0.200
     2.979    45.383     0.200
     3.177    49.461     0.200
     3.283    49.020     0.200
     3.330    48.781     0.200
     3.325    51.113     0.200
     3.369    51.750     0.200
     3.448    51.051     0.200
     3.645    54.852     0.200
     3.754    56.801     0.200
     3.866    57.012     0.200
     3.866    57.641     0.200
     4.145    61.223     0.200
     4.219    61.203     0.200
     4.253    62.070     0.200
     4.522    65.492     0.200
     4.533    65.031     0.200
     4.637    66.703     0.200
     4.732    67.172     0.200
     4.760    68.711     0.200
     4.791    70.121     0.200
     4.806    70.863     0.200
     4.854    69.863     0.200
     4.928    69.613     0.200
     4.909    72.441     0.200
     5.164    74.082     0.200
     5.215    74.590     0.200
     5.414    77.781     0.200
     5.542    79.223     0.200
     5.578    79.371     0.200
     5.599    80.223     0.200
     5.678    80.941     0.200
     5.714    82.520     0.200
     5.727    82.500     0.200
     5.779    82.801     0.200
     5.808    82.961     0.200
     5.939    84.980     0.200
     5.986    85.883     0.200
     6.061    86.383     0.200
     6.142    87.461     0.200
     6.222    89.000     0.200
     6.251    89.840     0.200
     6.437    91.570     0.200
     6.581    93.582     0.200
     6.624    94.871     0.200
     6.718    95.262     0.200
     6.855    98.211     0.200
     6.893    98.301     0.200
     6.993    99.840     0.200
     6.992    98.090     0.200
     7.080   100.973     0.200
     7.079    98.852     0.200
     7.174   102.551     0.200
     7.219   102.941     0.200
     7.243   103.461     0.200
     7.302   104.242     0.200
     7.293   101.680     0.200
     7.343   104.820     0.200
     7.460   105.820     0.200
     7.453   104.883     0.200
     7.480   104.270     0.200
     7.482   104.031     0.200
     7.481   104.312     0.200
     7.552   106.902     0.200
     7.606   105.980     0.200
     7.606   106.090     0.200
     7.606   105.641     0.200
     7.675   108.473     0.200
     7.800   109.281     0.200
     7.836   111.781     0.200
     7.863   112.230     0.200
     7.966   111.410     0.200
     8.001   113.973     0.200
     8.021   113.891     0.200
     8.021   113.270     0.200
     8.211   116.750     0.200
     8.471   119.312     0.200
     8.550   119.320     0.200
     9.253   129.492     0.200
     9.327   131.113     0.200
     9.461   133.492     0.200
    10.393   146.113     0.200
    12.954   179.516     0.200
    13.847   190.965     0.200
     0.354     8.066     0.200
     1.024    17.164     0.200
     1.471    24.281     0.200
     1.518    24.902     0.200
     1.581    25.895     0.200
     1.547    25.914     0.200
     1.668    27.523     0.200
     1.752    28.422     0.200
     1.715    27.184     0.200
     1.864    29.414     0.200
     1.850    29.574     0.200
     1.850    28.473     0.200
     1.860    29.754     0.200
     2.019    32.152     0.200
     2.070    32.273     0.200
     2.263    35.152     0.200
     2.442    37.543     0.200
     2.483    37.652     0.200
     2.427    37.645     0.200
     2.507    38.691     0.200
     2.680    40.395     0.200
     2.757    41.371     0.200
     2.806    41.602     0.200
     3.201    47.895     0.200
     3.282    49.223     0.200
     3.310    49.184     0.200
     3.437    50.832     0.200
     3.501    52.332     0.200
     3.529    52.152     0.200
     3.572    52.262     0.200
     3.841    55.801     0.200
     3.874    56.602     0.200
     3.889    56.863     0.200
     3.968    57.242     0.200
     3.992    58.371     0.200
     4.094    59.793     0.200
     4.126    60.402     0.200
     4.250    62.324     0.200
     4.490    64.883     0.200
     4.518    66.074     0.200
     4.500    65.723     0.200
     4.678    67.613     0.200
     4.827    69.414     0.200
     4.936    70.852     0.200
     4.903    71.344     0.200
     5.061    72.844     0.200
     5.066    73.211     0.200
     5.096    73.711     0.200
     5.127    74.352     0.200
     5.140    74.422     0.200
     5.219    74.691     0.200
     5.259    76.051     0.200
     5.334    76.621     0.200
     5.284    75.773     0.200
     5.415    77.234     0.200
     5.437    77.312     0.200
     5.529    79.633     0.200
     5.590    80.453     0.200
     5.640    80.863     0.200
     5.751    81.492     0.200
     5.807    82.844     0.200
     5.827    83.043     0.200
     5.950    83.871     0.200
     5.942    84.582     0.200
     6.134    86.711     0.200
     6.310    88.895     0.200
     6.761    95.672     0.200
     6.761    95.094     0.200
     6.967    98.574     0.200
     7.074    99.762     0.200
     7.157   100.844     0.200
     7.175   101.984     0.200
     7.210   101.441     0.200
     7.225   101.883     0.200
     7.225   102.191     0.200
     7.278   102.793     0.200
     7.741   109.312     0.200
     8.040   112.973     0.200
     8.144   115.023     0.200
     8.562   120.574     0.200
     9.176   128.012     0.200
     9.152   128.352     0.200
    10.049   141.543     0.200
    10.730   150.621     0.200
    18.930   258.562     0.200
     0.531    12.791     0.200
     0.585    13.240     0.200
     0.594    13.621     0.200
     0.704    15.011     0.200
     0.698    14.801     0.200
     0.737    15.251     0.200
     0.745    15.400     0.200
     0.851    16.320     0.200
     0.902    17.101     0.200
     0.982    17.331     0.200
     0.982    17.725     0.200
     0.965    18.081     0.200
     0.978    17.980     0.200
     1.086    18.931     0.200
     1.086    19.152     0.200
     1.104    19.820     0.200
     1.319    22.250     0.200
     1.319    22.011     0.200
     1.319    22.456     0.200
     1.764    27.650     0.200
     1.764    27.537     0.200
     1.996    32.280     0.200
     1.999    32.681     0.200
     2.015    32.641     0.200
     2.305    36.791     0.200
     2.618    40.881     0.200
     2.645    41.291     0.200
     2.683    41.581     0.200
     2.699    42.181     0.200
     2.750    42.711     0.200
     2.750    42.216     0.200
     3.091    46.190     0.200
     3.101    47.681     0.200
     3.130    46.730     0.200
     3.145    47.900     0.200
     3.206    48.921     0.200
     3.278    50.030     0.200
     3.573    52.891     0.200
     3.788    57.561     0.200
     3.755    55.521     0.200
     3.755    56.765     0.200
     3.860    57.030     0.200
     3.958    59.331     0.200
     3.959    58.761     0.200
     4.003    59.990     0.200
     4.278    63.461     0.200
     4.458    65.001     0.200
     4.486    66.011     0.200
     4.769    68.411     0.200
     4.779    69.501     0.200
     5.112    73.211     0.200
     5.236    75.091     0.200
     5.257    74.471     0.200
     5.401    78.450     0.200
     5.433    76.431     0.200
     5.444    78.041     0.200
     5.556    79.221     0.200
     5.791    82.771     0.200
     5.930    84.280     0.200
     6.050    86.521     0.200
     6.080    87.051     0.200
     6.107    87.141     0.200
     6.123    87.230     0.200
     6.195    88.240     0.200
     6.217    88.450     0.200
     6.297    89.360     0.200
     6.336    89.900     0.200
     6.362    90.990     0.200
     6.376    91.051     0.200
     6.639    94.360     0.200
     6.664    94.791     0.200
     6.860    97.131     0.200
     6.902    97.931     0.200
     6.953    98.421     0.200
     7.171   100.421     0.200
     7.209   102.230     0.200
     7.310   103.721     0.200
     7.359   104.110     0.200
     7.410   104.030     0.200
     7.520   106.631     0.200
     7.635   108.391     0.200
     7.627   106.721     0.200
     7.677   108.950     0.200
     7.719   108.891     0.200
     7.710   107.801     0.200
     7.792   110.541     0.200
     7.782   108.911     0.200
     7.898   111.461     0.200
     7.923   111.171     0.200
     8.064   113.711     0.200
     8.089   113.461     0.200
     8.115   113.711     0.200
     8.139   114.700     0.200
     8.233   115.200     0.200
     8.233   114.979     0.200
     8.323   118.400     0.200
     8.485   120.051     0.200
     8.487   120.171     0.200
     8.487   120.190     0.200
     8.570   121.101     0.200
     8.570   120.331     0.200
     9.175   129.230     0.200
     9.455   133.961     0.200
     0.217    12.436     0.200
     0.299    12.807     0.200
     0.496    13.996     0.200
     0.539    14.047     0.200
     0.584    15.057     0.200
     0.610    14.977     0.200
     0.729    16.057     0.200
     0.852    17.615     0.200
     0.840    17.207     0.200
     0.990    19.596     0.200
     1.062    19.547     0.200
     1.062    19.678     0.200
     1.008    19.887     0.200
     1.013    19.855     0.200
     1.310    22.736     0.200
     1.310    22.564     0.200
     1.299    23.445     0.200
     1.361    23.566     0.200
     1.458    24.896     0.200
     1.614    27.457     0.200
     1.679    27.996     0.200
     1.700    28.387     0.200
     1.774    28.877     0.200
     1.774    29.717     0.200
     1.892    30.889     0.200
     1.854    30.326     0.200
     2.099    33.756     0.200
     2.138    33.336     0.200
     2.143    34.707     0.200
     2.193    34.186     0.200
     2.211    35.266     0.200
     2.277    36.076     0.200
     2.757    42.076     0.200
     2.878    43.365     0.200
     2.906    44.766     0.200
     2.931    44.867     0.200
     2.961    45.535     0.200
     3.002    46.186     0.200
     3.042    45.406     0.200
     3.275    49.627     0.200
     3.463    51.297     0.200
     3.519    52.746     0.200
     3.477    52.406     0.200
     3.778    56.316     0.200
     3.813    55.457     0.200
     4.035    58.785     0.200
     4.237    61.355     0.200
     4.411    64.666     0.200
     4.451    64.406     0.200
     4.528    65.025     0.200
     4.568    65.586     0.200
     4.570    66.717     0.200
     4.769    68.576     0.200
     4.810    69.547     0.200
     5.012    72.066     0.200
     5.114    73.736     0.200
     5.137    73.807     0.200
     5.187    74.346     0.200
     5.215    74.605     0.200
     5.289    75.816     0.200
     5.358    78.137     0.200
     5.402    78.176     0.200
     5.451    77.486     0.200
     5.738    82.416     0.200
     5.873    84.986     0.200
     5.874    84.496     0.200
     5.998    85.926     0.200
     6.048    86.297     0.200
     6.068    86.586     0.200
     6.220    89.486     0.200
     6.320    89.896     0.200
     6.463    91.887     0.200
     6.504    92.275     0.200
     6.616    94.766     0.200
     6.695    95.775     0.200
     6.829    97.217     0.200
     6.924    98.605     0.200
     6.916    98.256     0.200
     6.955    99.166     0.200
     7.075   100.686     0.200
     7.095   100.336     0.200
     7.111   100.957     0.200
     7.438   105.576     0.200
     7.597   108.105     0.200
    10.019   139.467     0.200
    10.380   146.035     0.200
    12.615   176.916     0.200
     0.214    13.314     0.200
     0.296    13.836     0.200
     0.543    14.654     0.200
     0.492    14.574     0.200
     0.585    15.625     0.200
     0.609    15.545     0.200
     0.732    16.574     0.200
     0.839    17.625     0.200
     0.983    20.064     0.200
     1.068    19.955     0.200
     0.985    20.074     0.200
     1.001    20.225     0.200
     1.001    20.535     0.200
     1.006    20.205     0.200
     1.318    22.916     0.200
     1.292    23.734     0.200
     1.364    23.885     0.200
     1.461    25.574     0.200
     1.516    26.135     0.200
     1.606    27.545     0.200
     1.671    28.086     0.200
     1.900    30.215     0.200
     1.850    30.545     0.200
     2.092    33.695     0.200
     2.134    33.625     0.200
     2.136    34.785     0.200
     2.189    34.266     0.200
     2.270    36.225     0.200
     2.749    41.926     0.200
     2.872    43.586     0.200
     2.923    43.615     0.200
     2.924    44.875     0.200
     2.951    45.555     0.200
     2.954    45.336     0.200
     2.994    45.795     0.200
     3.268    49.635     0.200
     3.458    51.336     0.200
     3.470    52.246     0.200
     3.770    56.186     0.200
     3.809    55.785     0.200
     4.029    58.535     0.200
     4.231    61.645     0.200
     4.324    61.814     0.200
     4.363    63.564     0.200
     4.445    64.375     0.200
     4.524    64.475     0.200
     4.560    67.166     0.200
     4.562    66.686     0.200
     4.584    66.965     0.200
     4.766    68.564     0.200
     4.805    69.305     0.200
     5.008    71.904     0.200
     5.107    73.205     0.200
     5.133    73.945     0.200
     5.209    74.404     0.200
     5.282    75.465     0.200
     5.351    76.975     0.200
     5.354    76.734     0.200
     5.397    78.055     0.200
     5.448    77.916     0.200
     5.597    81.135     0.200
     5.734    82.795     0.200
     5.866    83.686     0.200
     5.866    83.475     0.200
     5.905    84.516     0.200
     5.994    85.795     0.200
     6.045    86.516     0.200
     6.064    86.385     0.200
     6.190    88.186     0.200
     6.460    92.064     0.200
     6.495    92.654     0.200
     6.501    92.535     0.200
     6.614    94.195     0.200
     6.692    95.695     0.200
     6.696    93.596     0.200
     6.826    97.125     0.200
     6.794    95.314     0.200
     6.922    99.225     0.200
     6.952    98.805     0.200
     7.104   100.016     0.200
     7.142   101.705     0.200
     7.217   100.775     0.200
     7.304   103.535     0.200
     7.392   103.725     0.200
     7.560   106.756     0.200
     7.592   107.535     0.200
     7.611   106.154     0.200
     7.700   108.465     0.200
     0.732    15.344     0.200
     0.872    17.219     0.200
     0.880    17.734     0.200
     0.957    18.672     0.200
     1.035    19.383     0.200
     1.053    19.500     0.200
     1.087    19.836     0.200
     1.069    19.414     0.200
     1.120    20.266     0.200
     1.190    21.234     0.200
     1.194    21.266     0.200
     1.257    22.500     0.200
     1.364    23.594     0.200
     1.450    24.430     0.200
     1.505    25.352     0.200
     1.519    25.594     0.200
     1.636    27.211     0.200
     1.615    26.508     0.200
     1.615    26.609     0.200
     2.324    35.789     0.200
     2.327    35.961     0.200
     2.507    38.594     0.200
     2.529    39.891     0.200
     2.838    43.953     0.200
     3.152    48.086     0.200
     3.217    48.789     0.200
     3.273    49.312     0.200
     3.386    49.531     0.200
     3.570    52.891     0.200
     3.601    53.305     0.200
     3.637    54.742     0.200
     3.681    55.180     0.200
     3.814    57.289     0.200
     3.814    57.148     0.200
     3.983    58.625     0.200
     4.028    59.320     0.200
     4.093    60.031     0.200
     4.075    59.461     0.200
     4.112    60.203     0.200
     4.307    63.461     0.200
     4.319    62.219     0.200
     4.356    63.039     0.200
     4.402    63.711     0.200
     4.469    65.789     0.200
     4.496    66.469     0.200
     4.495    66.266     0.200
     4.539    66.922     0.200
     4.813    70.594     0.200
     4.870    70.875     0.200
     4.962    71.914     0.200
     5.011    72.766     0.200
     5.242    74.945     0.200
     5.269    76.391     0.200
     5.274    76.055     0.200
     5.315    76.891     0.200
     5.541    79.195     0.200
     5.661    81.000     0.200
     5.710    80.898     0.200
     5.744    82.289     0.200
     5.870    82.984     0.200
     5.918    84.984     0.200
     5.942    85.375     0.200
     5.946    84.969     0.200
     6.059    86.484     0.200
     6.086    87.945     0.200
     6.280    89.586     0.200
     6.373    90.625     0.200
     6.539    92.984     0.200
     6.605    93.883     0.200
     6.647    94.281     0.200
     6.696    95.125     0.200
     6.727    95.219     0.200
     6.720    95.281     0.200
     6.757    95.984     0.200
     6.820    96.586     0.200
     6.858    97.352     0.200
     6.889    97.336     0.200
     6.898    97.984     0.200
     7.011    99.398     0.200
     7.111   101.023     0.200
     7.107   101.000     0.200
     7.142   101.391     0.200
     7.276   102.672     0.200
     7.275   102.648     0.200
     7.287   103.445     0.200
     7.334   103.984     0.200
     7.371   104.664     0.200
     7.400   105.023     0.200
     7.412   105.914     0.200
     7.424   104.430     0.200
     7.615   107.961     0.200
     7.629   107.086     0.200
     7.758   109.633     0.200
     7.773   109.625     0.200
     7.772   110.055     0.200
     7.899   111.789     0.200
     8.071   113.898     0.200
     8.080   114.859     0.200
     8.164   113.516     0.200
     8.157   115.523     0.200
     8.179   115.453     0.200
     8.242   114.625     0.200
     8.262   117.469     0.200
     8.322   116.203     0.200
     8.401   118.102     0.200
     8.455   117.320     0.200
     8.628   120.594     0.200
     8.635   122.445     0.200
     8.647   121.539     0.200
     8.650   120.305     0.200
     8.728   121.609     0.200
     8.739   123.953     0.200
     8.761   121.672     0.200
     8.761   121.695     0.200
     8.761   121.414     0.200
     8.895   125.023     0.200
     8.898   126.445     0.200
     9.021   126.336     0.200
     9.021   127.031     0.200
     9.016   127.445     0.200
     9.034   127.391     0.200
     9.034   127.359     0.200
     9.538   134.148     0.200
     9.531   133.914     0.200
     9.536   134.953     0.200
     9.703   134.961     0.200
    10.336   145.492     0.200
    10.489   147.789     0.200
    11.130   156.914     0.200
    11.522   158.211     0.200
    14.958   206.516     0.200
    14.958   207.680     0.200
    15.892   218.773     0.200
    18.413   248.961     0.200
     1.684    28.094     0.200
     1.688    28.213     0.200
     1.692    28.254     0.200
     1.705    28.412     0.200
     1.708    28.492     0.200
     1.996    32.773     0.200
     2.313    36.844     0.200
     2.377    37.773     0.200
     2.361    37.633     0.200
     2.487    38.773     0.200
     2.487    38.617     0.200
     2.658    41.492     0.200
     2.688    42.443     0.200
     2.798    43.373     0.200
     2.842    44.133     0.200
     2.875    45.393     0.200
     2.918    45.693     0.200
     2.977    46.473     0.200
     3.110    47.373     0.200
     3.106    47.344     0.200
     3.106    47.111     0.200
     3.139    50.504     0.200
     3.419    53.492     0.200
     3.419    51.271     0.200
     3.407    51.334     0.200
     3.447    52.303     0.200
     3.470    52.373     0.200
     3.583    53.783     0.200
     3.583    53.521     0.200
     3.629    56.072     0.200
     3.629    54.264     0.200
     3.632    55.174     0.200
     3.655    55.822     0.200
     3.664    56.553     0.200
     3.699    56.912     0.200
     3.742    57.354     0.200
     3.968    60.703     0.200
     3.974    59.584     0.200
     4.058    61.004     0.200
     4.132    62.033     0.200
     4.132    62.709     0.200
     4.329    63.953     0.200
     4.200    63.834     0.200
     4.208    63.883     0.200
     4.242    64.273     0.200
     4.242    64.758     0.200
     4.472    67.084     0.200
     4.472    66.955     0.200
     4.423    64.803     0.200
     4.638    68.613     0.200
     4.638    68.109     0.200
     4.695    69.104     0.200
     4.765    70.162     0.200
     4.800    69.992     0.200
     4.800    69.723     0.200
     4.843    71.662     0.200
     4.966    71.924     0.200
     5.040    73.902     0.200
     4.894    74.533     0.200
     5.083    75.264     0.200
     5.083    74.742     0.200
     5.099    74.463     0.200
     5.165    75.463     0.200
     5.165    75.264     0.200
     5.205    76.764     0.200
     5.285    79.004     0.200
     5.290    78.023     0.200
     5.312    77.453     0.200
     5.312    77.119     0.200
     5.368    78.584     0.200
     5.467    79.863     0.200
     5.628    82.162     0.200
     5.727    84.213     0.200
     5.763    84.383     0.200
     5.731    83.742     0.200
     5.828    85.344     0.200
     5.828    84.793     0.200
     5.826    84.703     0.200
     5.829    85.283     0.200
     5.861    84.943     0.200
     5.862    85.412     0.200
     5.915    86.062     0.200
     5.945    87.072     0.200
     5.945    86.742     0.200
     6.054    88.963     0.200
     6.054    88.678     0.200
     6.062    89.162     0.200
     5.913    87.533     0.200
     6.112    89.184     0.200
     6.112    89.031     0.200
     6.169    90.424     0.200
     6.148    89.863     0.200
     6.204    89.773     0.200
     6.249    91.562     0.200
     6.249    91.066     0.200
     6.269    91.264     0.200
     6.237    90.443     0.200
     6.221    91.713     0.200
     6.407    92.283     0.200
     6.432    92.883     0.200
     6.305    93.383     0.200
     6.418    93.123     0.200
     6.427    92.799     0.200
     6.424    93.152     0.200
     6.500    94.633     0.200
     6.500    93.975     0.200
     6.476    93.863     0.200
     6.482    94.354     0.200
     6.547    94.822     0.200
     6.547    94.699     0.200
     6.584    95.863     0.200
     6.584    94.916     0.200
     6.547    95.043     0.200
     6.715    97.283     0.200
     6.734    97.863     0.200
     6.734    96.973     0.200
     6.794    98.174     0.200
     6.794    97.789     0.200
     6.766    98.043     0.200
     6.766    97.775     0.200
     6.793    98.344     0.200
     6.860    99.543     0.200
     6.825    98.863     0.200
     6.876    99.123     0.200
     6.755    98.822     0.200
     6.885    99.482     0.200
     6.916   100.363     0.200
     7.030   101.863     0.200
     7.089   102.863     0.200
     7.139   103.322     0.200
     7.192   104.283     0.200
     7.225   104.463     0.200
     7.317   103.934     0.200
     7.317   104.357     0.200
     7.319   105.773     0.200
     7.377   105.684     0.200
     7.516   107.863     0.200
     7.516   107.174     0.200
     7.558   109.463     0.200
     7.558   108.389     0.200
     7.558   108.572     0.200
     7.558   107.688     0.200
     7.589   108.322     0.200
     7.460   109.482     0.200
     7.567   108.863     0.200
     7.567   108.762     0.200
     7.701   110.264     0.200
     7.559   110.412     0.200
     7.725   110.773     0.200
     7.601   110.973     0.200
     7.783   111.652     0.200
     7.783   110.607     0.200
     7.786   111.143     0.200
     7.786   110.635     0.200
     7.795   109.953     0.200
     7.795   111.172     0.200
     7.795   111.363     0.200
     7.846   113.143     0.200
     7.886   112.674     0.200
     7.886   112.055     0.200
     7.845   112.264     0.200
     7.919   113.123     0.200
     7.992   114.229     0.200
     7.987   114.424     0.200
     7.987   113.750     0.200
     8.007   115.523     0.200
     8.083   115.303     0.200
     8.083   114.662     0.200
     8.111   115.793     0.200
     8.104   116.373     0.200
     8.104   115.902     0.200
     8.122   116.572     0.200
     8.216   119.162     0.200
     8.418   120.242     0.200
     8.418   119.729     0.200
     8.424   120.844     0.200
     8.626   123.424     0.200
     8.626   122.930     0.200
     8.663   122.924     0.200
     8.663   122.385     0.200
     8.660   125.643     0.200
     8.678   124.283     0.200
     8.747   125.883     0.200
     8.747   123.814     0.200
     8.824   125.023     0.200
     9.058   128.383     0.200
     8.998   129.113     0.200
     9.426   134.184     0.200
     9.426   133.143     0.200
     9.577   136.523     0.200
     9.713   137.924     0.200
     9.713   136.682     0.200
     9.964   141.133     0.200
     9.964   141.256     0.200
    10.171   142.783     0.200
    10.171   142.648     0.200
    10.222   145.254     0.200
    10.295   146.223     0.200
    10.295   146.064     0.200
    10.676   150.043     0.200
    11.151   157.324     0.200
    11.867   166.480     0.200
    11.786   165.289     0.200
    11.916   167.662     0.200
    11.916   166.725     0.200
    12.757   180.373     0.200
    12.757   179.834     0.200
    12.762   179.812     0.200
    13.700   190.062     0.200
    13.700   190.197     0.200
    14.053   195.924     0.200
    14.053   195.684     0.200
    14.053   195.307     0.200
    14.222   199.283     0.200
    16.598   230.303     0.200
    17.503   239.193     0.200
    17.503   238.721     0.200
     0.531    12.203     0.200
     0.531    11.953     0.200
     0.767    14.762     0.200
     0.836    15.652     0.200
     0.926    17.402     0.200
     0.954    17.504     0.200
     0.938    17.312     0.200
     0.849    15.961     0.200
     0.849    16.184     0.200
     1.008    18.031     0.200
     1.071    18.754     0.200
     1.225    20.602     0.200
     1.381    22.691     0.200
     1.567    25.023     0.200
     1.867    29.902     0.200
     1.871    29.961     0.200
     1.876    29.883     0.200
     1.888    30.051     0.200
     1.892    30.633     0.200
     2.178    34.172     0.200
     2.178    34.070     0.200
     2.495    39.391     0.200
     2.491    39.461     0.200
     2.491    38.465     0.200
     2.501    38.480     0.200
     2.559    39.742     0.200
     2.678    40.273     0.200
     2.673    41.363     0.200
     2.799    41.902     0.200
     2.823    42.480     0.200
     2.823    42.207     0.200
     2.979    45.570     0.200
     3.078    45.730     0.200
     3.085    45.852     0.200
     3.024    46.230     0.200
     3.102    46.992     0.200
     3.244    47.863     0.200
     3.177    47.570     0.200
     3.302    48.922     0.200
     3.302    48.820     0.200
     3.535    51.504     0.200
     3.535    51.387     0.200
     3.585    53.711     0.200
     3.585    52.969     0.200
     3.596    52.480     0.200
     3.662    53.344     0.200
     3.724    55.023     0.200
     3.724    54.457     0.200
     3.809    56.094     0.200
     3.809    55.914     0.200
     3.811    55.863     0.200
     3.846    56.812     0.200
     3.879    58.312     0.200
     3.921    57.730     0.200
     4.093    57.797     0.200
     4.100    58.062     0.200
     4.164    59.633     0.200
     4.146    60.852     0.200
     4.211    61.164     0.200
     4.211    61.289     0.200
     4.301    63.082     0.200
     4.301    62.949     0.200
     4.393    63.723     0.200
     4.462    64.480     0.200
     4.492    64.273     0.200
     4.650    68.363     0.200
     4.650    67.227     0.200
     4.685    67.980     0.200
     4.786    68.473     0.200
     4.833    69.133     0.200
     4.872    70.043     0.200
     4.793    68.773     0.200
     4.840    70.301     0.200
     4.840    69.352     0.200
     4.867    70.480     0.200
     4.921    70.203     0.200
     4.998    71.941     0.200
     5.164    73.344     0.200
     5.078    71.863     0.200
     5.190    74.664     0.200
     5.190    74.305     0.200
     5.220    74.820     0.200
     5.255    75.863     0.200
     5.255    74.691     0.200
     5.265    75.504     0.200
     5.265    75.172     0.200
     5.324    76.461     0.200
     5.482    78.043     0.200
     5.470    78.531     0.200
     5.470    78.332     0.200
     5.504    78.883     0.200
     5.504    78.383     0.200
     5.510    78.781     0.200
     5.582    79.820     0.200
     5.854    82.543     0.200
     5.854    82.320     0.200
     5.752    82.184     0.200
     5.752    81.988     0.200
     5.816    83.043     0.200
     5.929    84.504     0.200
     5.909    84.504     0.200
     6.069    85.504     0.200
     5.936    84.742     0.200
     5.982    85.082     0.200
     5.964    84.684     0.200
     5.992    85.422     0.200
     5.992    85.133     0.200
     6.033    85.992     0.200
     6.082    87.051     0.200
     6.185    88.602     0.200
     6.232    88.922     0.200
     6.232    88.820     0.200
     6.244    89.711     0.200
     6.225    88.863     0.200
     6.301    91.461     0.200
     6.321    90.211     0.200
     6.321    90.098     0.200
     6.319    89.863     0.200
     6.439    91.480     0.200
     6.492    92.480     0.200
     6.496    92.582     0.200
     6.504    92.633     0.200
     6.515    92.477     0.200
     6.540    93.121     0.200
     6.550    93.051     0.200
     6.700    94.262     0.200
     6.578    93.652     0.200
     6.635    95.301     0.200
     6.635    95.070     0.200
     6.634    94.480     0.200
     6.720    95.883     0.200
     6.767    96.480     0.200
     6.796    96.742     0.200
     6.836    97.691     0.200
     6.835    97.621     0.200
     6.835    97.230     0.200
     6.870    97.742     0.200
     6.913    98.480     0.200
     6.939    98.551     0.200
     6.939    99.012     0.200
     6.967    99.082     0.200
     6.980    99.504     0.200
     6.989    99.582     0.200
     7.037   100.242     0.200
     7.112   101.320     0.200
     7.158   101.914     0.200
     7.202   102.512     0.200
     7.280   103.480     0.200
     7.297   103.902     0.200
     7.382   105.121     0.200
     7.387   104.938     0.200
     7.390   105.082     0.200
     7.493   105.004     0.200
     7.493   105.684     0.200
     7.483   106.504     0.200
     7.489   106.082     0.200
     7.549   105.504     0.200
     7.628   107.961     0.200
     7.628   108.121     0.200
     7.699   108.031     0.200
     7.699   109.148     0.200
     7.724   108.762     0.200
     7.724   109.430     0.200
     7.746   108.891     0.200
     7.746   109.469     0.200
     7.761   108.082     0.200
     7.946   111.434     0.200
     7.806   111.891     0.200
     7.870   112.023     0.200
     7.994   111.504     0.200
     8.027   111.953     0.200
     7.902   111.344     0.200
     7.956   111.273     0.200
     7.956   112.527     0.200
     7.958   112.594     0.200
     7.958   112.129     0.200
     7.975   111.570     0.200
     7.975   111.719     0.200
     7.970   111.480     0.200
     7.946   113.164     0.200
     7.968   112.203     0.200
     8.136   113.754     0.200
     8.054   112.543     0.200
     8.054   112.262     0.200
     8.054   112.781     0.200
     8.163   113.793     0.200
     8.104   115.422     0.200
     8.135   115.172     0.200
     8.135   114.789     0.200
     8.182   115.281     0.200
     8.230   116.203     0.200
     8.230   116.320     0.200
     8.240   117.121     0.200
     8.247   116.973     0.200
     8.247   116.980     0.200
     8.600   120.570     0.200
     8.600   121.625     0.200
     8.744   122.941     0.200
     8.744   122.363     0.200
     8.865   123.152     0.200
     8.743   124.684     0.200
     8.765   124.203     0.200
     8.765   123.906     0.200
     8.753   124.031     0.200
     8.754   124.301     0.200
     8.840   124.121     0.200
     8.840   124.297     0.200
     8.945   124.164     0.200
     8.919   125.594     0.200
     8.991   126.422     0.200
     8.991   126.711     0.200
     9.041   128.281     0.200
     9.128   129.051     0.200
     9.580   132.664     0.200
     9.569   134.242     0.200
     9.569   134.637     0.200
     9.705   136.113     0.200
     9.899   137.934     0.200
     9.899   138.430     0.200
     9.964   138.582     0.200
    10.005   140.473     0.200
    10.005   140.594     0.200
    10.166   140.594     0.200
    10.166   140.367     0.200
    10.246   143.582     0.200
    10.389   144.918     0.200
    10.357   145.012     0.200
    10.357   144.602     0.200
    10.511   146.723     0.200
    10.647   147.457     0.200
    10.848   149.773     0.200
    10.848   150.203     0.200
    11.292   156.418     0.200
    11.337   158.570     0.200
    11.337   158.250     0.200
    11.759   162.262     0.200
    11.759   162.621     0.200
    11.907   164.941     0.200
    11.907   165.441     0.200
    12.011   169.043     0.200
    12.011   167.645     0.200
    12.783   180.094     0.200
    12.783   178.523     0.200
    13.012   179.617     0.200
    13.309   186.762     0.200
    13.718   190.684     0.200
    14.195   195.293     0.200
    14.203   197.109     0.200
    14.203   197.613     0.200
    14.203   197.211     0.200
    16.583   225.730     0.200
    17.645   240.402     0.200
    17.645   240.301     0.200
     0.494    11.605     0.200
     0.578    12.867     0.200
     0.641    13.297     0.200
     0.645    14.125     0.200
     0.677    14.727     0.200
     0.699    14.297     0.200
     0.769    15.188     0.200
     0.778    15.355     0.200
     0.783    15.125     0.200
     0.842    15.477     0.200
     0.835    16.117     0.200
     1.175    20.527     0.200
     1.336    22.348     0.200
     1.481    24.984     0.200
     1.493    25.125     0.200
     1.496    24.996     0.200
     1.786    29.195     0.200
     2.009    31.016     0.200
     2.103    33.375     0.200
     2.158    34.605     0.200
     2.167    34.137     0.200
     2.194    34.445     0.200
     2.272    35.195     0.200
     2.290    36.207     0.200
     2.490    37.746     0.200
     2.526    38.387     0.200
     2.589    40.098     0.200
     2.633    41.098     0.200
     2.707    41.695     0.200
     2.768    42.586     0.200
     2.896    43.785     0.200
     2.902    43.508     0.200
     3.244    48.645     0.200
     3.224    49.707     0.200
     3.261    48.395     0.200
     3.269    48.227     0.200
     3.490    52.586     0.200
     3.535    52.996     0.200
     3.760    55.895     0.200
     3.874    56.938     0.200
     3.934    58.145     0.200
     3.987    58.707     0.200
     4.166    60.176     0.200
     4.264    62.457     0.200
     4.279    62.805     0.200
     4.356    61.906     0.200
     4.329    62.547     0.200
     4.361    62.656     0.200
     4.453    64.496     0.200
     4.519    64.816     0.200
     4.634    66.676     0.200
     4.649    66.027     0.200
     4.657    67.047     0.200
     4.824    68.145     0.200
     4.859    69.566     0.200
     4.949    70.977     0.200
     5.072    74.617     0.200
     5.079    73.207     0.200
     5.101    74.125     0.200
     5.196    74.668     0.200
     5.473    78.375     0.200
     5.567    80.078     0.200
     5.619    80.445     0.200
     5.634    80.977     0.200
     5.640    80.406     0.200
     5.721    81.816     0.200
     5.728    82.066     0.200
     5.760    82.918     0.200
     5.777    83.215     0.200
     5.847    84.285     0.200
     5.853    84.895     0.200
     6.042    86.387     0.200
     6.056    86.855     0.200
     6.069    86.246     0.200
     6.127    87.348     0.200
     6.293    89.047     0.200
     6.316    90.234     0.200
     6.316    90.027     0.200
     6.345    89.508     0.200
     6.373    91.477     0.200
     6.605    94.246     0.200
     6.618    93.715     0.200
     6.706    95.566     0.200
     6.755    96.086     0.200
     6.760    96.766     0.200
     6.815    97.047     0.200
     6.919    98.797     0.200
     6.991    99.406     0.200
     7.073   100.508     0.200
     7.124   101.645     0.200
     7.175   100.586     0.200
     7.183   102.547     0.200
     7.190   102.477     0.200
     7.304   103.387     0.200
     7.299   103.355     0.200
     7.361   103.578     0.200
     7.388   103.777     0.200
     7.587   106.645     0.200
     7.591   106.965     0.200
     7.687   107.938     0.200
     7.687   107.457     0.200
     7.761   109.535     0.200
     7.808   109.547     0.200
     7.842   110.887     0.200
     7.947   112.367     0.200
     7.965   112.656     0.200
     8.208   115.465     0.200
     8.454   120.328     0.200
     8.627   120.258     0.200
     8.958   125.445     0.200
     9.250   128.816     0.200
    10.473   145.297     0.200
     1.393    23.102     0.200
     2.750    42.812     0.200
     2.755    42.953     0.200
     2.761    42.992     0.200
     2.769    42.992     0.200
     2.776    43.109     0.200
     2.888    42.039     0.200
     3.058    46.922     0.200
     3.058    46.789     0.200
     3.256    49.180     0.200
     3.292    49.172     0.200
     3.285    49.633     0.200
     3.373    50.914     0.200
     3.436    51.562     0.200
     3.537    53.125     0.200
     3.631    50.938     0.200
     3.636    50.680     0.200
     3.551    52.430     0.200
     3.577    53.273     0.200
     3.555    52.820     0.200
     3.849    54.750     0.200
     3.854    57.508     0.200
     3.898    58.078     0.200
     3.982    59.070     0.200
     4.032    59.953     0.200
     4.176    61.273     0.200
     4.201    62.266     0.200
     4.231    60.930     0.200
     4.365    63.383     0.200
     4.409    64.125     0.200
     4.409    64.711     0.200
     4.467    65.492     0.200
     4.467    65.328     0.200
     4.587    65.453     0.200
     4.552    66.438     0.200
     4.678    68.672     0.200
     4.720    69.250     0.200
     4.787    70.711     0.200
     4.935    72.312     0.200
     4.950    69.711     0.200
     4.992    71.938     0.200
     5.010    73.508     0.200
     5.132    74.320     0.200
     5.169    74.031     0.200
     5.286    76.859     0.200
     5.292    76.938     0.200
     5.454    78.281     0.200
     5.599    77.453     0.200
     5.514    79.227     0.200
     5.514    79.422     0.200
     5.584    80.922     0.200
     5.574    79.914     0.200
     5.578    79.242     0.200
     5.578    79.359     0.200
     5.588    79.133     0.200
     5.588    79.953     0.200
     5.699    80.461     0.200
     5.780    82.555     0.200
     5.840    82.703     0.200
     5.840    83.312     0.200
     5.954    84.922     0.200
     5.954    86.031     0.200
     6.096    87.672     0.200
     6.242    89.508     0.200
     6.320    89.773     0.200
     6.353    91.469     0.200
     6.398    91.711     0.200
     6.415    91.320     0.200
     6.415    91.688     0.200
     6.542    92.656     0.200
     6.542    92.961     0.200
     6.745    96.242     0.200
     6.761    96.227     0.200
     6.761    96.703     0.200
     6.794    97.438     0.200
     6.801    96.547     0.200
     6.952    98.836     0.200
     6.952    99.344     0.200
     6.983    98.617     0.200
     7.013    99.688     0.200
     7.030    99.266     0.200
     7.149   100.250     0.200
     7.090   101.258     0.200
     7.090   102.039     0.200
     7.113   102.117     0.200
     7.136   101.359     0.200
     7.143   101.422     0.200
     7.146   100.953     0.200
     7.269   103.609     0.200
     7.279   103.391     0.200
     7.334   103.734     0.200
     7.436   105.242     0.200
     7.558   107.609     0.200
     7.558   107.352     0.200
     7.642   108.805     0.200
     7.642   108.594     0.200
     7.675   109.109     0.200
     7.675   108.695     0.200
     7.740   109.617     0.200
     7.791   110.461     0.200
     7.885   112.141     0.200
     7.965   112.555     0.200
     8.022   112.781     0.200
     8.022   113.086     0.200
     8.175   116.781     0.200
     8.272   116.250     0.200
     8.347   117.281     0.200
     8.385   118.031     0.200
     8.539   120.047     0.200
     8.539   120.492     0.200
     8.577   120.305     0.200
     8.577   120.484     0.200
     8.596   120.734     0.200
     8.604   122.430     0.200
     8.634   121.789     0.200
     8.798   123.312     0.200
     8.816   123.984     0.200
     8.899   124.188     0.200
     8.899   124.703     0.200
     8.838   123.664     0.200
     8.876   124.648     0.200
     8.876   124.617     0.200
     8.876   124.508     0.200
     8.881   124.633     0.200
     8.888   124.906     0.200
     8.888   125.539     0.200
     8.905   126.438     0.200
     9.076   128.164     0.200
     9.092   128.562     0.200
     9.092   128.289     0.200
     9.471   132.289     0.200
     9.476   134.016     0.200
     9.476   134.438     0.200
     9.704   139.508     0.200
     9.704   137.008     0.200
     9.693   135.984     0.200
     9.807   137.914     0.200
     9.807   139.211     0.200
    10.294   144.141     0.200
    10.371   145.594     0.200
    10.461   145.539     0.200
    10.782   151.289     0.200
    10.782   150.758     0.200
    12.732   176.320     0.200
    12.995   184.633     0.200
    14.951   208.312     0.200
    14.951   208.812     0.200
    14.951   207.117     0.200
    16.483   224.500     0.200
     0.439    13.473     0.200
     0.664    15.223     0.200
     0.856    16.922     0.200
     0.823    16.781     0.200
     0.786    16.562     0.200
     0.891    18.133     0.200
     0.915    17.922     0.200
     0.923    18.250     0.200
     0.935    18.680     0.200
     0.893    18.332     0.200
     0.897    18.512     0.200
     0.900    18.531     0.200
     0.906    18.590     0.200
     0.911    18.531     0.200
     0.919    18.609     0.200
     1.016    19.281     0.200
     1.061    19.902     0.200
     1.153    21.020     0.200
     1.256    21.652     0.200
     1.200    22.133     0.200
     1.200    22.230     0.200
     1.515    25.832     0.200
     1.548    26.520     0.200
     1.600    26.801     0.200
     1.578    26.480     0.200
     1.642    27.453     0.200
     1.633    27.172     0.200
     1.687    28.359     0.200
     1.755    28.953     0.200
     1.823    29.941     0.200
     1.778    29.160     0.200
     1.891    30.082     0.200
     1.936    30.781     0.200
     1.997    31.930     0.200
     2.035    32.480     0.200
     2.042    33.031     0.200
     2.125    33.992     0.200
     2.176    34.520     0.200
     2.401    37.750     0.200
     2.519    39.191     0.200
     2.668    39.902     0.200
     2.659    40.281     0.200
     2.805    43.031     0.200
     2.826    43.020     0.200
     2.831    42.953     0.200
     2.895    44.211     0.200
     2.936    44.703     0.200
     3.161    47.711     0.200
     3.260    48.750     0.200
     3.320    49.961     0.200
     3.433    51.781     0.200
     3.570    52.520     0.200
     3.665    54.562     0.200
     3.812    56.582     0.200
     3.783    56.453     0.200
     3.857    56.520     0.200
     3.910    57.223     0.200
     4.042    59.020     0.200
     4.069    58.441     0.200
     4.086    59.703     0.200
     4.258    60.723     0.200
     4.246    61.941     0.200
     4.368    63.211     0.200
     4.489    64.750     0.200
     4.588    66.641     0.200
     4.617    67.492     0.200
     4.748    68.520     0.200
     4.886    70.602     0.200
     4.947    70.293     0.200
     4.952    71.621     0.200
     5.025    72.320     0.200
     5.102    73.641     0.200
     5.175    74.141     0.200
     5.174    74.812     0.200
     5.214    75.141     0.200
     5.264    75.859     0.200
     5.247    75.660     0.200
     5.479    78.680     0.200
     5.457    78.082     0.200
     5.537    79.609     0.200
     5.614    80.520     0.200
     5.729    82.051     0.200
     5.732    82.840     0.200
     5.761    82.543     0.200
     5.792    82.703     0.200
     5.805    83.203     0.200
     5.818    82.859     0.200
     5.786    83.781     0.200
     5.904    83.980     0.200
     6.008    86.340     0.200
     6.091    87.191     0.200
     6.181    88.320     0.200
     6.181    88.492     0.200
     6.176    88.133     0.200
     6.220    88.602     0.200
     6.218    89.062     0.200
     6.318    90.672     0.200
     6.543    93.430     0.200
     6.565    92.543     0.200
     6.627    95.020     0.200
     6.666    95.570     0.200
     6.748    96.543     0.200
     7.003    99.480     0.200
     7.163   102.262     0.200
     7.195   102.281     0.200
     7.354   104.742     0.200
     7.394   104.730     0.200
     7.373   104.312     0.200
     0.115    11.563     0.200
     0.207    11.833     0.200
     0.265    12.673     0.200
     0.297    12.463     0.200
     0.351    12.673     0.200
     0.318    12.483     0.200
     0.355    12.713     0.200
     0.370    12.783     0.200
     0.415    13.123     0.200
     0.606    14.523     0.200
     0.652    15.673     0.200
     0.795    16.623     0.200
     0.928    17.913     0.200
     1.044    19.293     0.200
     1.186    20.831     0.200
     1.268    22.202     0.200
     1.517    24.971     0.200
     1.551    26.853     0.200
     1.552    26.943     0.200
     1.552    26.663     0.200
     1.570    27.023     0.200
     1.846    29.833     0.200
     1.846    29.733     0.200
     1.858    30.793     0.200
     1.857    30.624     0.200
     1.857    30.783     0.200
     2.237    33.664     0.200
     2.204    34.701     0.200
     2.232    35.463     0.200
     2.366    36.786     0.200
     2.383    37.906     0.200
     2.383    37.723     0.200
     2.441    38.033     0.200
     2.647    40.853     0.200
     2.690    40.813     0.200
     2.696    41.863     0.200
     2.715    41.446     0.200
     2.715    41.203     0.200
     2.727    41.283     0.200
     2.746    42.483     0.200
     2.779    41.981     0.200
     2.811    43.243     0.200
     2.823    43.133     0.200
     3.106    46.573     0.200
     3.469    51.283     0.200
     3.476    52.155     0.200
     3.513    52.123     0.200
     3.541    53.173     0.200
     4.116    59.025     0.200
     4.125    58.953     0.200
     4.049    59.765     0.200
     4.053    59.762     0.200
     4.053    59.503     0.200
     4.176    61.569     0.200
     4.176    61.323     0.200
     4.322    63.835     0.200
     4.404    63.413     0.200
     4.719    68.279     0.200
     4.914    69.940     0.200
     4.914    69.833     0.200
     4.937    71.063     0.200
     4.934    71.993     0.200
     4.972    71.633     0.200
     5.108    72.333     0.200
     5.341    76.330     0.200
     5.372    77.770     0.200
     5.372    78.143     0.200
     5.402    76.933     0.200
     5.726    81.980     0.200
     5.726    81.783     0.200
     5.762    82.056     0.200
     5.800    82.661     0.200
     5.902    84.091     0.200
     5.994    86.086     0.200
     6.027    86.181     0.200
     6.018    86.957     0.200
     6.190    88.549     0.200
     6.190    88.693     0.200
     6.232    88.273     0.200
     6.324    90.114     0.200
     6.579    93.393     0.200
     6.631    94.010     0.200
     6.810    96.942     0.200
     6.939    98.883     0.200
     7.161   101.873     0.200
     7.168   101.673     0.200
     7.312   103.371     0.200
     7.394   104.993     0.200
     7.470   106.303     0.200
     7.513   106.145     0.200
     7.516   106.423     0.200
     7.594   107.776     0.200
     7.625   107.255     0.200
     8.188   115.720     0.200
     8.230   115.564     0.200
     8.230   115.963     0.200
     8.512   118.975     0.200
     8.731   122.372     0.200
     1.177    19.358     0.200
     1.576    25.158     0.200
     1.645    26.838     0.200
     1.653    26.978     0.200
     1.693    26.898     0.200
     1.708    27.528     0.200
     1.732    28.088     0.200
     1.791    28.778     0.200
     1.858    29.748     0.200
     2.077    32.408     0.200
     2.121    33.138     0.200
     2.140    34.298     0.200
     2.153    34.308     0.200
     2.269    33.878     0.200
     2.277    35.118     0.200
     2.343    36.198     0.200
     2.406    37.798     0.200
     2.406    37.678     0.200
     2.422    37.868     0.200
     2.625    39.568     0.200
     2.609    39.598     0.200
     2.697    41.208     0.200
     2.753    42.008     0.200
     2.805    43.358     0.200
     2.942    44.388     0.200
     3.059    45.388     0.200
     3.070    46.508     0.200
     3.147    47.428     0.200
     3.190    48.298     0.200
     3.216    48.698     0.200
     3.218    48.618     0.200
     3.243    47.188     0.200
     3.318    50.068     0.200
     3.320    49.808     0.200
     3.685    54.488     0.200
     3.831    56.658     0.200
     3.924    58.808     0.200
     3.998    59.798     0.200
     4.002    59.778     0.200
     4.043    60.118     0.200
     4.071    59.348     0.200
     4.096    60.858     0.200
     4.140    60.608     0.200
     4.178    60.368     0.200
     4.240    62.428     0.200
     4.286    62.278     0.200
     4.407    63.578     0.200
     4.676    66.350     0.200
     4.682    66.348     0.200
     4.661    66.258     0.200
     4.736    68.778     0.200
     4.846    69.628     0.200
     4.853    70.358     0.200
     4.985    71.868     0.200
     5.055    73.308     0.200
     5.175    74.268     0.200
     5.205    75.098     0.200
     5.263    76.118     0.200
     5.392    77.658     0.200
     5.490    78.598     0.200
     5.526    79.108     0.200
     5.797    83.758     0.200
     5.888    84.518     0.200
     5.908    84.758     0.200
     5.913    84.588     0.200
     6.087    86.658     0.200
     6.142    88.428     0.200
     6.210    88.368     0.200
     6.277    89.888     0.200
     6.367    91.108     0.200
     6.377    91.308     0.200
     6.431    91.998     0.200
     6.462    92.588     0.200
     6.553    93.528     0.200
     6.682    95.628     0.200
     6.962    99.388     0.200
     7.640   109.218     0.200
     7.728   108.638     0.200
     7.986   113.278     0.200
     7.986   112.092     0.200
     8.033   113.478     0.200
     0.569    12.078     0.200
     0.569    12.305     0.200
     0.730    13.672     0.200
     0.730    13.781     0.200
     0.750    14.148     0.200
     0.774    15.172     0.200
     0.777    14.969     0.200
     0.850    15.734     0.200
     0.853    15.703     0.200
     0.882    16.133     0.200
     0.892    16.453     0.200
     0.909    16.414     0.200
     0.951    17.258     0.200
     0.954    17.133     0.200
     1.001    17.969     0.200
     1.037    18.508     0.200
     1.052    18.453     0.200
     1.407    22.539     0.200
     1.434    24.602     0.200
     1.438    24.664     0.200
     1.441    24.719     0.200
     1.447    24.758     0.200
     1.452    24.562     0.200
     1.461    24.859     0.200
     1.442    24.094     0.200
     1.606    26.133     0.200
     1.741    28.672     0.200
     1.740    28.641     0.200
     1.742    28.109     0.200
     2.025    32.078     0.200
     2.054    32.664     0.200
     2.117    33.039     0.200
     2.101    32.789     0.200
     2.219    34.664     0.200
     2.219    34.836     0.200
     2.323    35.484     0.200
     2.348    36.148     0.200
     2.303    35.773     0.200
     2.383    35.211     0.200
     2.383    35.102     0.200
     2.535    39.039     0.200
     2.572    39.562     0.200
     2.579    40.039     0.200
     2.598    40.164     0.200
     2.629    41.078     0.200
     2.664    40.984     0.200
     2.713    41.805     0.200
     2.928    44.664     0.200
     2.997    45.258     0.200
     2.997    45.391     0.200
     3.064    44.633     0.200
     3.119    46.289     0.200
     3.114    47.750     0.200
     3.114    47.602     0.200
     3.248    48.578     0.200
     3.248    47.734     0.200
     3.359    50.234     0.200
     3.333    49.805     0.200
     3.429    51.742     0.200
     3.469    52.117     0.200
     3.481    51.828     0.200
     3.495    52.562     0.200
     3.693    55.258     0.200
     3.735    54.531     0.200
     3.735    54.773     0.200
     3.832    56.523     0.200
     3.989    57.891     0.200
     3.974    58.664     0.200
     3.974    58.945     0.200
     4.078    60.750     0.200
     4.083    60.891     0.200
     4.197    61.148     0.200
     4.197    60.930     0.200
     4.316    62.555     0.200
     4.312    63.594     0.200
     4.363    63.258     0.200
     4.363    62.602     0.200
     4.417    63.844     0.200
     4.455    63.805     0.200
     4.455    63.539     0.200
     4.522    65.180     0.200
     4.547    64.258     0.200
     4.555    65.461     0.200
     4.619    65.617     0.200
     4.588    66.883     0.200
     4.713    67.953     0.200
     4.713    67.445     0.200
     4.754    68.750     0.200
     4.817    70.078     0.200
     4.817    68.852     0.200
     5.034    72.469     0.200
     5.034    73.531     0.200
     5.034    73.398     0.200
     5.120    73.500     0.200
     5.168    74.117     0.200
     5.135    74.633     0.200
     5.217    75.273     0.200
     5.157    74.820     0.200
     5.277    76.008     0.200
     5.284    75.953     0.200
     5.284    75.477     0.200
     5.386    77.164     0.200
     5.457    78.352     0.200
     5.519    79.508     0.200
     5.451    78.992     0.200
     5.451    78.625     0.200
     5.513    79.117     0.200
     5.513    78.570     0.200
     5.505    78.828     0.200
     5.505    78.664     0.200
     5.519    79.148     0.200
     5.519    78.734     0.200
     5.608    80.859     0.200
     5.608    80.664     0.200
     5.665    81.391     0.200
     5.804    82.898     0.200
     5.776    83.531     0.200
     5.776    82.844     0.200
     5.795    83.320     0.200
     5.858    84.078     0.200
     5.858    83.375     0.200
     5.892    83.969     0.200
     5.971    85.078     0.200
     6.061    87.117     0.200
     6.008    86.852     0.200
     6.008    85.617     0.200
     6.075    86.898     0.200
     6.079    86.398     0.200
     6.080    85.945     0.200
     6.085    87.258     0.200
     6.129    88.109     0.200
     6.200    88.367     0.200
     6.254    90.219     0.200
     6.254    89.711     0.200
     6.275    89.680     0.200
     6.275    89.531     0.200
     6.370    90.938     0.200
     6.323    91.117     0.200
     6.323    90.039     0.200
     6.425    91.609     0.200
     6.425    91.828     0.200
     6.449    92.242     0.200
     6.478    92.688     0.200
     6.462    92.453     0.200
     6.462    91.617     0.200
     6.528    93.453     0.200
     6.538    93.703     0.200
     6.574    94.164     0.200
     6.578    93.492     0.200
     6.883    97.273     0.200
     6.936    97.797     0.200
     6.956    98.242     0.200
     7.064   100.000     0.200
     7.035    98.812     0.200
     7.083    99.438     0.200
     7.229   102.961     0.200
     7.230   102.734     0.200
     7.252   101.719     0.200
     7.252   102.359     0.200
     7.258   102.922     0.200
     7.258   102.047     0.200
     7.295   102.594     0.200
     7.319   103.516     0.200
     7.393   104.969     0.200
     7.510   105.867     0.200
     7.508   105.711     0.200
     7.522   105.531     0.200
     7.522   105.836     0.200
     7.584   107.094     0.200
     7.584   106.758     0.200
     7.658   108.500     0.200
     7.658   107.812     0.200
     7.761   110.359     0.200
     7.761   109.570     0.200
     7.779   109.922     0.200
     7.790   109.539     0.200
     7.790   110.023     0.200
     7.798   110.281     0.200
     8.085   114.344     0.200
     8.290   117.789     0.200
     8.317   119.172     0.200
     8.381   117.352     0.200
     8.716   124.141     0.200
     8.730   123.922     0.200
     8.976   128.938     0.200
     9.093   128.250     0.200
     9.956   141.492     0.200
     9.972   142.078     0.200
    10.383   144.711     0.200
    10.903   152.617     0.200
    13.088   181.852     0.200
    14.104   197.383     0.200
    14.543   200.867     0.200
    14.801   204.422     0.200
    16.909   231.094     0.200
     1.264    20.746     0.200
     1.354    23.375     0.200
     1.440    24.484     0.200
     1.528    25.793     0.200
     1.560    26.645     0.200
     1.566    26.414     0.200
     1.571    26.895     0.200
     1.580    27.375     0.200
     1.587    27.066     0.200
     1.599    27.805     0.200
     1.679    27.996     0.200
     1.707    27.914     0.200
     1.786    29.184     0.200
     1.769    29.754     0.200
     1.769    29.586     0.200
     1.841    29.863     0.200
     1.888    30.695     0.200
     1.913    31.254     0.200
     1.955    32.066     0.200
     2.085    31.836     0.200
     2.008    32.785     0.200
     2.053    33.586     0.200
     2.054    33.203     0.200
     2.294    35.375     0.200
     2.289    35.426     0.200
     2.399    37.566     0.200
     2.439    38.184     0.200
     2.514    38.816     0.200
     2.475    38.844     0.200
     2.573    39.523     0.200
     2.522    39.656     0.200
     2.558    39.805     0.200
     2.558    39.906     0.200
     2.570    40.145     0.200
     2.562    39.934     0.200
     2.684    42.594     0.200
     3.172    45.875     0.200
     3.097    46.816     0.200
     3.131    48.316     0.200
     3.143    47.523     0.200
     3.090    47.133     0.200
     3.229    48.395     0.200
     3.186    48.805     0.200
     3.206    49.285     0.200
     3.400    51.016     0.200
     3.487    52.113     0.200
     3.409    51.293     0.200
     3.611    53.105     0.200
     3.682    54.613     0.200
     3.620    53.844     0.200
     3.728    53.844     0.200
     3.716    54.855     0.200
     3.875    57.254     0.200
     3.905    57.023     0.200
     3.920    57.965     0.200
     3.890    57.633     0.200
     4.064    59.996     0.200
     4.061    60.363     0.200
     4.121    60.145     0.200
     4.231    61.684     0.200
     4.241    62.164     0.200
     4.315    63.945     0.200
     4.367    65.043     0.200
     4.449    65.066     0.200
     4.494    64.934     0.200
     4.402    65.234     0.200
     4.577    66.953     0.200
     4.661    68.133     0.200
     4.848    70.996     0.200
     4.971    72.977     0.200
     4.981    72.227     0.200
     5.068    74.035     0.200
     5.075    74.254     0.200
     5.168    75.477     0.200
     5.185    75.426     0.200
     5.209    75.926     0.200
     5.362    78.285     0.200
     5.340    79.133     0.200
     5.445    79.965     0.200
     5.407    79.035     0.200
     5.405    78.574     0.200
     5.409    78.484     0.200
     5.546    80.863     0.200
     5.489    79.914     0.200
     5.479    79.863     0.200
     5.678    82.625     0.200
     5.610    82.586     0.200
     5.744    83.656     0.200
     5.853    85.133     0.200
     5.857    84.863     0.200
     5.796    84.855     0.200
     6.053    86.504     0.200
     6.076    87.895     0.200
     6.026    86.164     0.200
     6.179    88.703     0.200
     6.216    89.773     0.200
     6.218    90.203     0.200
     6.452    92.605     0.200
     6.452    93.555     0.200
     6.543    94.664     0.200
     6.610    94.785     0.200
     6.625    94.496     0.200
     6.713    96.727     0.200
     6.814    97.113     0.200
     6.918    99.004     0.200
     6.953    99.566     0.200
     6.965    99.875     0.200
     7.025   100.727     0.200
     7.027   100.633     0.200
     7.061   100.355     0.200
     7.061   100.656     0.200
     7.066   101.133     0.200
     7.105   101.543     0.200
     7.150   102.035     0.200
     7.313   104.895     0.200
     7.523   108.004     0.200
     7.603   108.184     0.200
     7.811   111.215     0.200
     7.956   113.355     0.200
     7.974   112.094     0.200
     7.973   113.984     0.200
     8.349   119.266     0.200
     8.908   126.215     0.200
     8.990   128.406     0.200
     9.372   132.977     0.200
     9.889   139.773     0.200
     0.463    10.801     0.200
     0.632    12.230     0.200
     0.863    15.352     0.200
     0.892    16.203     0.200
     0.972    17.012     0.200
     1.008    18.012     0.200
     1.030    18.203     0.200
     1.067    18.750     0.200
     1.090    19.203     0.200
     1.156    19.844     0.200
     1.352    21.883     0.200
     1.513    25.691     0.200
     1.523    25.043     0.200
     1.518    25.750     0.200
     1.520    25.730     0.200
     1.528    25.383     0.200
     1.528    25.871     0.200
     1.546    25.703     0.200
     1.695    27.480     0.200
     1.815    29.660     0.200
     1.814    29.621     0.200
     1.810    28.570     0.200
     2.040    32.312     0.200
     2.044    32.891     0.200
     2.126    33.352     0.200
     2.188    34.371     0.200
     2.213    34.434     0.200
     2.281    36.273     0.200
     2.357    35.031     0.200
     2.338    35.801     0.200
     2.357    36.301     0.200
     2.399    37.102     0.200
     2.603    40.094     0.200
     2.647    41.062     0.200
     2.671    40.602     0.200
     2.667    41.172     0.200
     2.736    42.102     0.200
     2.781    42.730     0.200
     3.023    45.922     0.200
     3.065    44.941     0.200
     3.126    46.031     0.200
     3.141    46.543     0.200
     3.156    48.973     0.200
     3.262    47.543     0.200
     3.419    50.832     0.200
     3.423    51.082     0.200
     3.439    51.230     0.200
     3.449    51.641     0.200
     3.467    51.910     0.200
     3.531    52.781     0.200
     3.693    54.852     0.200
     3.753    55.621     0.200
     3.761    55.191     0.200
     3.878    57.383     0.200
     3.994    58.043     0.200
     4.031    57.773     0.200
     4.031    58.422     0.200
     4.036    57.871     0.200
     4.098    60.332     0.200
     4.257    61.652     0.200
     4.344    62.320     0.200
     4.380    62.961     0.200
     4.406    64.641     0.200
     4.449    63.223     0.200
     4.549    65.723     0.200
     4.605    65.312     0.200
     4.624    66.094     0.200
     4.653    68.121     0.200
     4.735    67.992     0.200
     4.793    68.641     0.200
     4.839    69.223     0.200
     5.048    72.941     0.200
     5.109    73.543     0.200
     5.248    75.434     0.200
     5.235    76.121     0.200
     5.280    75.844     0.200
     5.350    77.141     0.200
     5.492    78.184     0.200
     5.533    79.160     0.200
     5.538    79.352     0.200
     5.616    80.750     0.200
     5.628    80.684     0.200
     5.631    80.672     0.200
     5.832    83.633     0.200
     5.832    83.230     0.200
     5.848    83.660     0.200
     5.857    83.781     0.200
     5.955    85.961     0.200
     6.028    86.152     0.200
     6.016    85.531     0.200
     6.040    86.160     0.200
     6.047    86.148     0.200
     6.042    86.273     0.200
     6.068    86.133     0.200
     6.082    86.711     0.200
     6.106    86.910     0.200
     6.167    87.684     0.200
     6.167    88.691     0.200
     6.302    88.863     0.200
     6.302    90.012     0.200
     6.364    91.184     0.200
     6.361    90.652     0.200
     6.387    91.121     0.200
     6.446    91.961     0.200
     6.478    91.781     0.200
     6.498    92.383     0.200
     6.510    92.973     0.200
     6.530    92.992     0.200
     6.648    95.141     0.200
     6.633    94.043     0.200
     6.702    96.012     0.200
     6.813    97.402     0.200
     6.839    97.480     0.200
     6.924    98.703     0.200
     7.014   100.363     0.200
     7.026   100.500     0.200
     7.089    99.211     0.200
     7.130   100.660     0.200
     7.178   102.000     0.200
     7.178   102.000     0.200
     7.251   103.301     0.200
     7.292   102.980     0.200
     7.333   104.613     0.200
     7.324   103.543     0.200
     7.324   103.043     0.200
     7.341   103.043     0.200
     7.392   104.820     0.200
     7.409   105.402     0.200
     7.455   105.320     0.200
     7.436   104.512     0.200
     7.474   107.281     0.200
     7.529   105.961     0.200
     7.540   105.844     0.200
     7.542   105.844     0.200
     7.559   105.871     0.200
     7.581   106.492     0.200
     7.634   108.934     0.200
     7.626   106.852     0.200
     7.626   107.062     0.200
     7.677   108.062     0.200
     7.758   110.172     0.200
     7.776   110.383     0.200
     7.776   110.000     0.200
     7.819   109.781     0.200
     7.837   111.281     0.200
     7.845   110.262     0.200
     8.168   115.410     0.200
     8.168   114.891     0.200
     8.215   115.023     0.200
     8.215   115.648     0.200
     8.300   118.133     0.200
     8.368   117.641     0.200
     8.435   118.320     0.200
     8.469   118.902     0.200
     8.560   122.383     0.200
     8.850   126.613     0.200
     9.106   128.301     0.200
     9.234   130.570     0.200
     9.795   135.562     0.200
    10.430   145.203     0.200
    12.370   175.547     0.200
    14.611   202.953     0.200
     0.579    12.008     0.200
     0.788    15.227     0.200
     0.788    14.758     0.200
     0.859    15.562     0.200
     0.921    16.805     0.200
     1.086    18.438     0.200
     1.308    22.664     0.200
     1.760    29.062     0.200
     1.867    29.305     0.200
     1.867    29.203     0.200
     2.023    31.031     0.200
     2.023    30.586     0.200
     2.061    33.062     0.200
     2.061    33.156     0.200
     2.061    32.852     0.200
     2.308    35.531     0.200
     2.377    36.695     0.200
     2.390    37.438     0.200
     2.461    37.445     0.200
     2.555    39.688     0.200
     2.568    39.406     0.200
     2.688    40.523     0.200
     2.751    41.328     0.200
     2.751    41.102     0.200
     2.713    41.078     0.200
     2.906    45.172     0.200
     3.154    47.461     0.200
     3.192    48.508     0.200
     3.192    48.328     0.200
     3.428    50.211     0.200
     3.428    49.883     0.200
     3.483    51.156     0.200
     3.558    52.781     0.200
     3.613    53.812     0.200
     3.613    53.625     0.200
     3.693    54.742     0.200
     4.028    59.516     0.200
     4.097    59.406     0.200
     4.184    61.836     0.200
     4.184    61.383     0.200
     4.248    63.062     0.200
     4.248    61.852     0.200
     4.282    62.977     0.200
     4.354    62.914     0.200
     4.406    62.758     0.200
     4.533    65.727     0.200
     4.576    67.102     0.200
     4.679    67.492     0.200
     4.728    67.664     0.200
     4.771    68.773     0.200
     4.817    68.422     0.200
     4.855    70.812     0.200
     4.977    70.562     0.200
     5.169    73.898     0.200
     5.353    77.547     0.200
     5.376    77.984     0.200
     5.399    77.422     0.200
     5.500    78.758     0.200
     5.647    80.914     0.200
     5.737    82.703     0.200
     5.867    83.812     0.200
     5.867    83.492     0.200
     5.973    85.617     0.200
     6.114    87.094     0.200
     6.126    87.156     0.200
     6.218    88.586     0.200
     6.320    89.648     0.200
     6.322    89.711     0.200
     6.372    90.555     0.200
     6.405    90.945     0.200
     6.424    90.945     0.200
     6.441    91.523     0.200
     6.482    92.562     0.200
     6.526    94.047     0.200
     6.560    93.602     0.200
     6.602    93.406     0.200
     6.650    93.922     0.200
     6.823    97.016     0.200
     6.827    97.125     0.200
     6.875    97.617     0.200
     6.887    98.453     0.200
     6.906    97.938     0.200
     7.024    99.812     0.200
     7.189   101.984     0.200
     7.214   102.633     0.200
     7.262   103.734     0.200
     7.297   103.703     0.200
     7.301   103.703     0.200
     7.376   102.766     0.200
     7.402   104.586     0.200
     7.431   103.984     0.200
     7.582   106.758     0.200
     7.630   107.602     0.200
     7.644   106.977     0.200
     7.705   109.383     0.200
     7.751   108.594     0.200
     7.841   109.617     0.200
     7.850   111.938     0.200
     7.857   110.078     0.200
     7.896   110.547     0.200
     7.937   111.023     0.200
     7.937   110.852     0.200
     8.010   113.961     0.200
     8.022   112.406     0.200
     8.067   113.781     0.200
     8.146   114.617     0.200
     8.149   115.984     0.200
     8.375   118.453     0.200
     8.375   118.453     0.200
     8.668   122.836     0.200
     8.674   122.828     0.200
     8.722   121.836     0.200
     8.843   125.297     0.200
     8.874   124.734     0.200
     9.018   125.367     0.200
     9.458   134.734     0.200
    10.123   139.977     0.200
    12.723   179.156     0.200
    14.090   196.508     0.200
    14.255   197.492     0.200
     0.564    11.418     0.200
     0.631    12.527     0.200
     0.734    13.836     0.200
     0.730    13.727     0.200
     0.747    14.207     0.200
     0.753    14.387     0.200
     0.753    14.285     0.200
     0.776    14.727     0.200
     0.927    16.816     0.200
     0.959    17.008     0.200
     1.059    18.527     0.200
     1.119    18.875     0.200
     1.213    20.426     0.200
     1.316    22.008     0.200
     1.386    22.785     0.200
     1.785    27.738     0.200
     1.980    30.188     0.200
     2.072    32.898     0.200
     2.148    33.258     0.200
     2.233    34.309     0.200
     2.389    37.047     0.200
     2.446    38.266     0.200
     2.453    37.816     0.200
     2.476    37.926     0.200
     2.531    38.688     0.200
     2.610    39.906     0.200
     2.579    39.535     0.200
     2.772    41.227     0.200
     2.875    43.938     0.200
     2.919    45.309     0.200
     2.932    44.887     0.200
     3.008    45.098     0.200
     3.152    47.465     0.200
     3.493    52.078     0.200
     3.515    53.559     0.200
     3.527    51.496     0.200
     3.683    55.066     0.200
     3.696    54.648     0.200
     3.712    55.406     0.200
     4.084    60.047     0.200
     4.048    60.258     0.200
     4.112    59.227     0.200
     4.163    60.738     0.200
     4.224    62.168     0.200
     4.246    62.586     0.200
     4.446    64.008     0.200
     4.531    66.777     0.200
     4.552    66.246     0.200
     4.743    69.047     0.200
     4.805    68.715     0.200
     4.829    70.508     0.200
     4.892    69.648     0.200
     4.947    71.328     0.200
     5.292    75.695     0.200
     5.480    78.445     0.200
     5.642    81.016     0.200
     5.706    83.035     0.200
     5.988    85.309     0.200
     6.140    87.086     0.200
     6.135    86.898     0.200
     6.326    90.258     0.200
     6.360    89.898     0.200
     6.528    93.527     0.200
     6.537    93.207     0.200
     6.554    92.715     0.200
     6.557    93.906     0.200
     6.603    94.266     0.200
     6.676    94.848     0.200
     6.860    98.125     0.200
     6.904    99.156     0.200
     7.048    99.988     0.200
     7.161   101.078     0.200
     7.321   103.957     0.200
     7.357   104.758     0.200
     7.435   105.836     0.200
     7.465   107.125     0.200
     7.465   104.516     0.200
     7.539   107.027     0.200
     7.585   106.688     0.200
     7.651   108.656     0.200
     7.664   110.156     0.200
     7.678   108.445     0.200
     7.699   108.586     0.200
     7.815   111.176     0.200
     7.847   112.285     0.200
     7.835   112.926     0.200
     7.880   110.238     0.200
     7.978   112.098     0.200
     7.978   112.477     0.200
     8.048   113.965     0.200
     8.241   117.426     0.200
     8.347   118.785     0.200
     8.492   118.777     0.200
     8.718   123.617     0.200
     8.745   124.688     0.200
     0.413     9.084     0.200
     0.413     8.955     0.200
     1.090    18.035     0.200
     1.090    17.818     0.200
     1.175    20.004     0.200
     1.300    21.975     0.200
     1.502    24.766     0.200
     1.445    24.215     0.200
     1.446    24.375     0.200
     1.454    24.574     0.200
     1.475    25.314     0.200
     1.473    24.754     0.200
     1.586    26.254     0.200
     1.595    25.914     0.200
     1.676    27.436     0.200
     1.675    27.414     0.200
     1.786    27.965     0.200
     1.774    28.225     0.200
     1.708    27.715     0.200
     1.916    28.904     0.200
     1.916    29.078     0.200
     1.939    30.814     0.200
     1.990    31.164     0.200
     2.015    32.186     0.200
     2.098    32.295     0.200
     2.275    35.846     0.200
     2.360    36.395     0.200
     2.429    36.205     0.200
     2.402    37.365     0.200
     2.405    36.795     0.200
     2.434    37.334     0.200
     2.398    36.555     0.200
     2.434    37.564     0.200
     2.602    38.984     0.200
     2.682    40.045     0.200
     2.682    39.797     0.200
     2.725    42.084     0.200
     2.993    44.914     0.200
     3.099    46.754     0.200
     3.119    47.135     0.200
     3.119    46.301     0.200
     3.143    47.465     0.200
     3.203    48.055     0.200
     3.180    47.744     0.200
     3.270    48.125     0.200
     3.274    48.064     0.200
     3.232    47.734     0.200
     3.209    48.295     0.200
     3.367    49.516     0.200
     3.419    51.215     0.200
     3.448    50.945     0.200
     3.448    50.725     0.200
     3.501    51.584     0.200
     3.678    53.885     0.200
     3.776    54.584     0.200
     3.776    54.410     0.200
     3.800    55.164     0.200
     3.801    56.074     0.200
     3.811    55.225     0.200
     3.811    55.025     0.200
     3.908    55.865     0.200
     3.910    57.484     0.200
     4.017    58.705     0.200
     4.071    59.004     0.200
     3.996    58.574     0.200
     4.072    59.205     0.200
     4.175    60.705     0.200
     4.366    63.355     0.200
     4.331    63.244     0.200
     4.418    63.945     0.200
     4.442    64.125     0.200
     4.418    64.834     0.200
     4.445    64.705     0.200
     4.514    65.705     0.200
     4.491    66.244     0.200
     4.491    66.072     0.200
     4.614    66.766     0.200
     4.693    67.754     0.200
     4.772    68.705     0.200
     4.772    68.523     0.200
     4.878    70.334     0.200
     4.874    70.516     0.200
     4.820    70.426     0.200
     5.008    72.455     0.200
     4.991    72.814     0.200
     4.991    72.387     0.200
     5.104    73.465     0.200
     5.158    74.664     0.200
     5.158    74.164     0.200
     5.196    74.936     0.200
     5.186    74.855     0.200
     5.287    76.105     0.200
     5.286    76.705     0.200
     5.207    74.965     0.200
     5.304    75.475     0.200
     5.228    75.234     0.200
     5.228    74.953     0.200
     5.358    76.805     0.200
     5.383    77.035     0.200
     5.422    77.625     0.200
     5.372    77.436     0.200
     5.447    78.385     0.200
     5.530    79.615     0.200
     5.530    79.283     0.200
     5.508    79.494     0.200
     5.580    80.105     0.200
     5.560    79.805     0.200
     5.617    80.795     0.200
     5.617    80.203     0.200
     5.642    80.754     0.200
     5.642    80.312     0.200
     5.653    80.955     0.200
     5.703    81.846     0.200
     5.758    82.705     0.200
     5.771    82.814     0.200
     5.777    82.584     0.200
     5.811    82.645     0.200
     5.811    83.318     0.200
     5.896    84.715     0.200
     5.878    84.725     0.200
     5.878    83.666     0.200
     5.862    84.926     0.200
     5.862    83.686     0.200
     5.940    85.494     0.200
     5.986    86.176     0.200
     6.069    87.324     0.200
     6.079    87.324     0.200
     6.051    86.705     0.200
     6.051    86.367     0.200
     6.165    88.795     0.200
     6.173    88.445     0.200
     6.176    88.936     0.200
     6.250    90.004     0.200
     6.250    89.723     0.200
     6.187    89.105     0.200
     6.187    88.051     0.200
     6.273    90.025     0.200
     6.412    91.686     0.200
     6.412    91.307     0.200
     6.636    94.805     0.200
     6.636    95.090     0.200
     6.688    95.115     0.200
     6.681    94.715     0.200
     6.760    96.055     0.200
     6.760    95.928     0.200
     6.747    96.516     0.200
     6.801    96.504     0.200
     6.903    99.074     0.200
     6.903    99.365     0.200
     6.887    97.705     0.200
     6.992    99.525     0.200
     7.105   101.484     0.200
     7.095   100.572     0.200
     7.097   100.365     0.200
     7.061   100.680     0.200
     7.130   100.855     0.200
     7.113   100.516     0.200
     7.146   100.885     0.200
     7.146   101.115     0.200
     7.197   101.744     0.200
     7.289   103.205     0.200
     7.289   103.396     0.200
     7.386   104.275     0.200
     7.386   104.426     0.200
     7.528   108.465     0.200
     7.537   107.754     0.200
     7.617   107.711     0.200
     7.600   107.732     0.200
     7.823   111.635     0.200
     7.851   111.295     0.200
     7.851   110.641     0.200
     7.958   112.564     0.200
     8.066   113.975     0.200
     8.066   114.436     0.200
     8.570   120.834     0.200
     9.141   128.285     0.200
     9.141   128.973     0.200
     9.135   126.824     0.200
     9.956   138.385     0.200
    11.607   163.141     0.200
     0.946    17.680     0.200
     0.910    17.305     0.200
     1.185    20.805     0.200
     1.209    21.125     0.200
     1.216    21.316     0.200
     1.355    23.113     0.200
     1.353    23.566     0.200
     1.356    23.645     0.200
     1.361    23.703     0.200
     1.376    23.805     0.200
     1.377    23.785     0.200
     1.500    24.754     0.200
     1.473    24.535     0.200
     1.462    24.094     0.200
     1.489    24.906     0.200
     1.667    27.754     0.200
     1.666    27.719     0.200
     1.892    30.074     0.200
     1.983    31.906     0.200
     1.998    31.996     0.200
     2.048    32.695     0.200
     2.057    33.141     0.200
     2.102    33.273     0.200
     2.117    33.824     0.200
     2.173    34.945     0.200
     2.387    36.348     0.200
     2.396    36.676     0.200
     2.420    37.324     0.200
     2.435    37.312     0.200
     2.469    38.605     0.200
     2.507    39.184     0.200
     2.513    39.035     0.200
     2.526    39.445     0.200
     2.581    39.816     0.200
     2.586    40.344     0.200
     2.648    41.305     0.200
     2.929    44.188     0.200
     3.113    48.594     0.200
     3.142    47.266     0.200
     3.164    46.371     0.200
     3.168    47.094     0.200
     3.311    50.113     0.200
     3.332    50.285     0.200
     3.301    49.984     0.200
     3.306    49.645     0.200
     3.316    49.070     0.200
     3.334    50.746     0.200
     3.416    51.484     0.200
     3.642    54.645     0.200
     3.676    55.203     0.200
     3.770    55.645     0.200
     3.864    57.293     0.200
     4.074    59.133     0.200
     4.157    61.496     0.200
     4.219    61.750     0.200
     4.273    61.961     0.200
     4.278    62.023     0.200
     4.348    63.145     0.200
     4.434    64.086     0.200
     4.419    63.852     0.200
     4.440    65.492     0.200
     4.560    65.984     0.200
     4.551    65.805     0.200
     4.564    65.047     0.200
     4.745    67.254     0.200
     4.755    68.844     0.200
     4.765    69.527     0.200
     4.863    69.793     0.200
     4.962    70.930     0.200
     4.950    72.684     0.200
     4.958    72.145     0.200
     4.981    72.465     0.200
     5.097    73.551     0.200
     5.239    74.984     0.200
     5.320    77.379     0.200
     5.353    77.242     0.200
     5.381    77.336     0.200
     5.385    77.414     0.200
     5.432    77.926     0.200
     5.455    78.633     0.200
     5.523    79.383     0.200
     5.533    79.391     0.200
     5.555    79.734     0.200
     5.653    80.363     0.200
     5.661    81.215     0.200
     5.682    81.156     0.200
     5.681    81.773     0.200
     5.703    82.074     0.200
     5.729    82.672     0.200
     5.733    82.535     0.200
     5.836    83.234     0.200
     5.913    85.684     0.200
     5.913    85.004     0.200
     5.955    85.176     0.200
     5.973    85.227     0.200
     5.982    85.734     0.200
     6.032    86.414     0.200
     6.065    86.555     0.200
     6.143    88.531     0.200
     6.184    88.535     0.200
     6.215    88.316     0.200
     6.223    88.656     0.200
     6.239    88.773     0.200
     6.242    88.660     0.200
     6.229    89.273     0.200
     6.254    89.074     0.200
     6.252    89.641     0.200
     6.270    89.043     0.200
     6.364    90.473     0.200
     6.525    92.855     0.200
     6.517    93.133     0.200
     6.543    93.133     0.200
     6.536    93.766     0.200
     6.615    94.363     0.200
     6.627    94.656     0.200
     6.639    94.715     0.200
     6.686    94.766     0.200
     6.689    94.863     0.200
     6.758    96.496     0.200
     6.857    97.723     0.200
     6.844    98.191     0.200
     6.936    99.215     0.200
     6.997    99.723     0.200
     7.006    99.676     0.200
     6.992    98.328     0.200
     7.041   100.195     0.200
     7.067   100.715     0.200
     7.122   101.457     0.200
     7.125   101.453     0.200
     7.175   102.465     0.200
     7.182   101.980     0.200
     7.236   102.703     0.200
     7.222   102.668     0.200
     7.247   101.984     0.200
     7.272   102.684     0.200
     7.276   102.613     0.200
     7.272   101.754     0.200
     7.427   105.223     0.200
     7.427   105.223     0.200
     7.447   106.293     0.200
     7.464   104.645     0.200
     7.466   104.496     0.200
     7.467   105.195     0.200
     7.473   105.324     0.200
     7.573   106.133     0.200
     7.573   106.184     0.200
     7.655   108.594     0.200
     7.713   108.906     0.200
     7.705   108.938     0.200
     7.705   108.543     0.200
     7.764   108.832     0.200
     7.799   110.152     0.200
     7.805   110.883     0.200
     7.800   109.930     0.200
     7.856   110.945     0.200
     7.875   111.414     0.200
     7.875   111.523     0.200
     7.948   113.676     0.200
     7.960   113.223     0.200
     7.960   112.836     0.200
     8.129   114.375     0.200
     8.339   117.676     0.200
     8.482   120.574     0.200
     8.473   120.996     0.200
     8.540   120.664     0.200
     8.796   124.574     0.200
     8.901   126.645     0.200
     9.149   128.906     0.200
     9.323   131.645     0.200
     9.323   131.324     0.200
     9.857   138.844     0.200
    10.143   143.645     0.200
    10.150   141.898     0.200
    10.150   142.785     0.200
    10.342   143.695     0.200
    10.356   143.676     0.200
    10.816   150.625     0.200
    11.794   164.203     0.200
    12.675   177.543     0.200
    13.421   185.555     0.200
    13.765   191.414     0.200
     0.746    21.559     0.200
     0.834    22.309     0.200
     1.250    24.799     0.200
     1.256    24.499     0.200
     1.256    24.672     0.200
     1.509    27.029     0.200
     1.598    28.269     0.200
     1.620    29.669     0.200
     1.626    29.579     0.200
     1.628    29.779     0.200
     1.641    29.719     0.200
     1.659    29.879     0.200
     1.746    29.579     0.200
     1.718    30.079     0.200
     1.854    31.329     0.200
     1.914    33.029     0.200
     1.915    33.099     0.200
     1.882    32.859     0.200
     1.935    33.269     0.200
     2.018    33.609     0.200
     2.142    35.429     0.200
     2.208    36.539     0.200
     2.208    36.429     0.200
     2.272    37.379     0.200
     2.333    36.439     0.200
     2.333    36.570     0.200
     2.442    39.559     0.200
     2.436    38.549     0.200
     2.511    40.559     0.200
     2.511    40.855     0.200
     2.613    41.369     0.200
     2.674    42.579     0.200
     2.716    42.999     0.200
     2.715    42.999     0.200
     2.724    43.179     0.200
     2.756    43.519     0.200
     2.776    43.829     0.200
     2.815    43.859     0.200
     2.844    44.979     0.200
     2.889    44.349     0.200
     2.952    45.669     0.200
     2.959    45.899     0.200
     3.440    53.619     0.200
     3.473    53.689     0.200
     3.500    54.309     0.200
     3.515    53.979     0.200
     3.595    54.339     0.200
     3.774    56.729     0.200
     3.809    57.629     0.200
     3.920    58.259     0.200
     4.032    60.319     0.200
     4.060    61.149     0.200
     4.060    60.954     0.200
     4.156    61.619     0.200
     4.419    66.299     0.200
     4.552    66.169     0.200
     4.715    69.309     0.200
     4.782    70.479     0.200
     4.836    70.099     0.200
     4.836    69.947     0.200
     4.805    70.779     0.200
     4.932    71.599     0.200
     4.912    71.089     0.200
     4.937    71.529     0.200
     5.038    75.049     0.200
     5.038    75.204     0.200
     5.083    73.439     0.200
     5.083    73.293     0.200
     5.141    73.649     0.200
     5.291    75.799     0.200
     5.274    77.209     0.200
     5.521    79.289     0.200
     5.541    79.819     0.200
     5.547    81.659     0.200
     5.734    81.749     0.200
     5.700    82.639     0.200
     5.769    83.079     0.200
     5.817    82.839     0.200
     5.882    84.669     0.200
     5.866    84.669     0.200
     5.880    83.479     0.200
     5.855    84.979     0.200
     5.900    85.069     0.200
     5.988    86.329     0.200
     5.995    85.939     0.200
     5.959    87.099     0.200
     6.025    86.719     0.200
     6.085    87.939     0.200
     6.120    88.229     0.200
     6.171    88.759     0.200
     6.219    89.129     0.200
     6.197    88.169     0.200
     6.286    90.339     0.200
     6.340    91.249     0.200
     6.357    90.089     0.200
     6.359    91.159     0.200
     6.359    91.044     0.200
     6.454    92.419     0.200
     6.449    92.069     0.200
     6.491    92.959     0.200
     6.611    94.599     0.200
     6.684    95.489     0.200
     6.684    95.729     0.200
     6.654    96.029     0.200
     6.710    95.599     0.200
     6.759    96.469     0.200
     6.823    98.349     0.200
     6.823    97.469     0.200
     6.835    97.469     0.200
     6.843    97.465     0.200
     6.877    98.329     0.200
     6.913    99.069     0.200
     6.913    97.987     0.200
     6.968    99.639     0.200
     7.004    99.229     0.200
     7.086   101.109     0.200
     7.086   100.728     0.200
     7.114   101.729     0.200
     7.071   101.359     0.200
     7.160   102.049     0.200
     7.101   101.519     0.200
     7.163   100.849     0.200
     7.163   100.659     0.200
     7.237   102.529     0.200
     7.253   103.279     0.200
     7.259   103.499     0.200
     7.259   103.392     0.200
     7.269   103.569     0.200
     7.277   103.389     0.200
     7.252   103.609     0.200
     7.274   101.709     0.200
     7.269   103.219     0.200
     7.269   103.467     0.200
     7.393   105.599     0.200
     7.489   104.669     0.200
     7.506   105.119     0.200
     7.534   107.629     0.200
     7.534   107.525     0.200
     7.576   108.459     0.200
     7.603   107.699     0.200
     7.604   107.459     0.200
     7.581   107.039     0.200
     7.635   108.209     0.200
     7.608   107.409     0.200
     7.647   106.929     0.200
     7.642   109.049     0.200
     7.660   107.359     0.200
     7.702   109.799     0.200
     7.656   108.449     0.200
     7.727   109.982     0.200
     7.730   109.849     0.200
     7.815   109.069     0.200
     7.815   108.879     0.200
     7.851   111.209     0.200
     7.907   112.309     0.200
     7.977   113.059     0.200
     7.972   111.469     0.200
     8.082   114.599     0.200
     8.082   114.659     0.200
     8.076   113.249     0.200
     8.204   117.029     0.200
     8.192   115.939     0.200
     8.329   117.619     0.200
     8.348   117.469     0.200
     8.348   118.349     0.200
     8.377   118.039     0.200
     8.372   118.669     0.200
     8.474   119.329     0.200
     8.501   118.429     0.200
     8.548   120.069     0.200
     8.564   119.869     0.200
     9.184   129.109     0.200
     9.534   134.459     0.200
     9.777   137.369     0.200
    10.542   146.369     0.200
    10.549   145.229     0.200
    10.796   151.159     0.200
    10.849   153.659     0.200
    14.102   192.829     0.200
     0.279     7.766     0.200
     1.212    18.688     0.200
     1.212    18.883     0.200
     1.336    22.000     0.200
     1.348    22.180     0.200
     1.351    22.180     0.200
     1.376    22.836     0.200
     1.376    22.992     0.200
     1.420    23.297     0.200
     1.511    24.656     0.200
     1.528    24.992     0.200
     1.561    24.883     0.200
     1.593    26.008     0.200
     1.797    29.188     0.200
     1.868    29.930     0.200
     2.144    32.711     0.200
     2.155    34.180     0.200
     2.598    40.648     0.200
     2.601    40.672     0.200
     2.607    40.891     0.200
     2.619    40.531     0.200
     2.623    39.336     0.200
     2.623    39.445     0.200
     2.622    41.062     0.200
     2.700    40.289     0.200
     2.716    40.445     0.200
     2.911    43.312     0.200
     2.910    44.781     0.200
     2.909    44.328     0.200
     3.078    45.977     0.200
     3.188    48.117     0.200
     3.197    48.531     0.200
     3.197    48.320     0.200
     3.226    48.648     0.200
     3.243    48.836     0.200
     3.290    49.336     0.200
     3.390    50.602     0.200
     3.390    50.742     0.200
     3.403    51.469     0.200
     3.403    51.281     0.200
     3.485    51.359     0.200
     3.498    51.781     0.200
     3.498    51.984     0.200
     3.548    50.570     0.200
     3.554    50.547     0.200
     3.718    53.359     0.200
     3.718    53.547     0.200
     3.711    55.289     0.200
     3.755    56.109     0.200
     3.770    56.070     0.200
     3.833    57.086     0.200
     3.875    57.922     0.200
     3.889    57.672     0.200
     4.010    59.586     0.200
     4.193    60.391     0.200
     4.292    62.219     0.200
     4.305    64.297     0.200
     4.305    63.719     0.200
     4.408    63.992     0.200
     4.408    63.742     0.200
     4.429    63.812     0.200
     4.439    64.406     0.200
     4.540    66.609     0.200
     4.541    66.422     0.200
     4.566    67.172     0.200
     4.652    68.289     0.200
     4.757    68.391     0.200
     4.845    71.266     0.200
     4.877    70.961     0.200
     4.914    71.078     0.200
     4.914    70.930     0.200
     4.999    71.445     0.200
     4.999    72.305     0.200
     5.104    74.297     0.200
     5.128    73.539     0.200
     5.388    78.461     0.200
     5.388    78.211     0.200
     5.412    78.820     0.200
     5.412    78.109     0.200
     5.457    78.789     0.200
     5.457    78.398     0.200
     5.497    78.586     0.200
     5.497    78.102     0.200
     5.528    78.820     0.200
     5.559    78.977     0.200
     5.559    78.484     0.200
     5.687    82.383     0.200
     5.687    82.070     0.200
     5.695    80.602     0.200
     5.702    81.336     0.200
     5.854    83.133     0.200
     5.854    82.992     0.200
     5.856    83.461     0.200
     5.886    84.016     0.200
     5.886    83.633     0.200
     5.957    85.656     0.200
     5.981    85.359     0.200
     5.981    85.820     0.200
     6.100    86.141     0.200
     6.100    86.656     0.200
     6.166    88.797     0.200
     6.189    88.688     0.200
     6.189    88.852     0.200
     6.191    88.289     0.200
     6.191    88.539     0.200
     6.200    89.445     0.200
     6.200    89.594     0.200
     6.205    88.531     0.200
     6.208    88.281     0.200
     6.288    89.547     0.200
     6.360    90.461     0.200
     6.395    91.391     0.200
     6.395    91.000     0.200
     6.441    91.516     0.200
     6.452    91.633     0.200
     6.556    92.578     0.200
     6.556    92.844     0.200
     6.631    94.039     0.200
     6.647    94.617     0.200
     6.661    95.156     0.200
     6.685    95.039     0.200
     6.685    94.852     0.200
     6.708    95.258     0.200
     6.708    94.906     0.200
     6.724    95.820     0.200
     6.724    96.734     0.200
     6.750    95.727     0.200
     6.752    96.586     0.200
     6.854    97.016     0.200
     6.924    98.297     0.200
     6.945    98.836     0.200
     6.959    99.609     0.200
     6.962    99.031     0.200
     6.962    99.219     0.200
     6.975    98.688     0.200
     7.033    99.586     0.200
     7.050    99.945     0.200
     7.068   100.227     0.200
     7.144   101.297     0.200
     7.163   101.492     0.200
     7.164   101.867     0.200
     7.164   101.648     0.200
     7.164   101.578     0.200
     7.183   101.781     0.200
     7.195   102.016     0.200
     7.195   101.602     0.200
     7.299   104.156     0.200
     7.299   104.305     0.200
     7.328   103.477     0.200
     7.333   103.758     0.200
     7.333   103.859     0.200
     7.387   104.961     0.200
     7.391   104.820     0.200
     7.424   105.141     0.200
     7.424   105.422     0.200
     7.445   105.688     0.200
     7.466   105.781     0.200
     7.498   106.539     0.200
     7.498   106.398     0.200
     7.497   106.195     0.200
     7.525   105.266     0.200
     7.525   105.539     0.200
     7.526   106.406     0.200
     7.550   106.977     0.200
     7.603   106.492     0.200
     7.622   107.891     0.200
     7.622   107.578     0.200
     7.640   107.367     0.200
     7.657   108.367     0.200
     7.682   108.617     0.200
     7.773   109.141     0.200
     7.766   109.742     0.200
     7.803   110.398     0.200
     7.831   110.836     0.200
     7.863   111.172     0.200
     7.928   111.898     0.200
     7.931   112.039     0.200
     8.017   112.781     0.200
     8.036   113.852     0.200
     8.036   113.680     0.200
     8.050   113.680     0.200
     8.050   114.352     0.200
     8.101   114.297     0.200
     8.101   114.594     0.200
     8.223   114.641     0.200
     8.274   115.797     0.200
     8.327   119.078     0.200
     8.327   119.281     0.200
     8.359   117.000     0.200
     8.400   119.102     0.200
     8.400   118.930     0.200
     8.404   117.859     0.200
     8.404   118.180     0.200
     8.424   119.812     0.200
     8.424   119.336     0.200
     8.430   118.242     0.200
     8.443   118.797     0.200
     8.473   119.352     0.200
     8.473   119.219     0.200
     8.486   118.781     0.200
     8.525   120.781     0.200
     8.553   120.672     0.200
     8.587   120.883     0.200
     8.670   123.336     0.200
     8.678   122.797     0.200
     8.678   122.938     0.200
     8.683   121.758     0.200
     8.683   121.359     0.200
     8.685   120.391     0.200
     8.685   120.758     0.200
     8.685   120.906     0.200
     8.698   121.297     0.200
     8.706   121.586     0.200
     8.706   121.445     0.200
     8.775   122.719     0.200
     8.775   122.148     0.200
     8.775   121.992     0.200
     8.824   124.102     0.200
     8.846   125.852     0.200
     8.872   125.672     0.200
     8.872   125.320     0.200
     8.889   125.836     0.200
     8.889   125.672     0.200
     8.905   125.266     0.200
     8.972   125.688     0.200
     8.981   125.359     0.200
     9.206   129.508     0.200
     9.206   129.422     0.200
     9.346   131.250     0.200
     9.346   131.414     0.200
     9.443   133.492     0.200
     9.569   134.117     0.200
     9.569   133.211     0.200
     9.711   136.141     0.200
     9.711   135.570     0.200
    10.248   143.852     0.200
    10.352   145.586     0.200
    10.408   146.133     0.200
    10.414   146.391     0.200
    10.594   149.430     0.200
    10.629   147.250     0.200
    10.629   147.453     0.200
    10.688   148.438     0.200
    10.841   152.133     0.200
    10.908   155.031     0.200
    11.037   158.070     0.200
    11.574   160.328     0.200
    12.067   167.016     0.200
    12.067   167.258     0.200
    12.135   169.492     0.200
    12.987   181.203     0.200
    13.130   185.211     0.200
    13.130   183.797     0.200
    14.596   204.242     0.200
    14.895   206.719     0.200
    14.895   206.188     0.200
    19.402   263.039     0.200
     0.424    14.195     0.200
     0.700    16.750     0.200
     0.857    18.547     0.200
     0.860    18.727     0.200
     0.878    18.797     0.200
     0.883    18.836     0.200
     1.014    19.484     0.200
     1.122    20.992     0.200
     1.169    22.258     0.200
     1.420    24.445     0.200
     1.409    24.609     0.200
     1.548    26.773     0.200
     1.632    27.508     0.200
     1.664    28.477     0.200
     1.688    28.875     0.200
     1.754    29.117     0.200
     1.969    32.336     0.200
     2.013    32.656     0.200
     2.034    32.305     0.200
     2.023    33.148     0.200
     2.093    32.938     0.200
     2.079    33.945     0.200
     2.146    34.789     0.200
     2.257    36.055     0.200
     2.656    42.531     0.200
     2.643    40.750     0.200
     2.763    41.758     0.200
     2.801    43.273     0.200
     2.827    42.180     0.200
     2.810    43.133     0.200
     2.918    45.188     0.200
     3.145    48.055     0.200
     3.344    49.797     0.200
     3.641    54.383     0.200
     3.641    54.625     0.200
     3.706    54.445     0.200
     3.914    56.805     0.200
     3.920    58.328     0.200
     3.920    58.008     0.200
     4.012    58.258     0.200
     4.115    59.727     0.200
     4.332    62.523     0.200
     4.332    62.742     0.200
     4.437    65.070     0.200
     4.437    64.727     0.200
     4.451    65.625     0.200
     4.473    65.445     0.200
     4.473    65.719     0.200
     4.680    67.383     0.200
     4.695    67.609     0.200
     4.695    67.891     0.200
     4.801    70.258     0.200
     4.801    70.086     0.200
     4.912    71.156     0.200
     4.960    72.859     0.200
     4.987    72.195     0.200
     5.032    72.539     0.200
     5.092    73.133     0.200
     5.164    74.383     0.200
     5.227    75.734     0.200
     5.231    75.773     0.200
     5.289    76.117     0.200
     5.358    76.484     0.200
     5.358    76.719     0.200
     5.396    78.258     0.200
     5.396    78.109     0.200
     5.475    78.586     0.200
     5.582    79.305     0.200
     5.582    80.023     0.200
     5.596    80.258     0.200
     5.636    80.773     0.200
     5.624    81.438     0.200
     5.624    81.164     0.200
     5.755    82.750     0.200
     5.744    82.484     0.200
     5.744    82.656     0.200
     5.743    81.688     0.200
     5.743    82.602     0.200
     5.827    83.344     0.200
     5.851    84.008     0.200
     5.851    83.820     0.200
     5.900    84.156     0.200
     5.963    85.305     0.200
     5.974    85.148     0.200
     5.983    85.344     0.200
     6.020    86.203     0.200
     6.039    87.016     0.200
     6.108    87.258     0.200
     6.102    86.906     0.200
     6.226    88.617     0.200
     6.226    88.898     0.200
     6.302    90.133     0.200
     6.323    90.766     0.200
     6.377    90.688     0.200
     6.336    91.102     0.200
     6.397    91.383     0.200
     6.407    92.086     0.200
     6.407    91.758     0.200
     6.408    91.523     0.200
     6.416    91.156     0.200
     6.496    91.414     0.200
     6.496    91.648     0.200
     6.539    93.883     0.200
     6.573    92.539     0.200
     6.686    94.883     0.200
     6.686    95.242     0.200
     6.671    94.555     0.200
     6.671    94.875     0.200
     6.701    95.789     0.200
     6.705    95.930     0.200
     6.705    95.688     0.200
     6.742    96.234     0.200
     6.775    96.000     0.200
     6.803    97.688     0.200
     6.787    95.227     0.200
     6.847    97.969     0.200
     6.841    97.617     0.200
     6.841    97.508     0.200
     6.867    97.867     0.200
     6.870    98.047     0.200
     6.890    98.875     0.200
     6.979   100.008     0.200
     6.964    98.125     0.200
     6.993    99.688     0.200
     6.976    97.594     0.200
     6.976    98.773     0.200
     6.978    98.648     0.200
     6.978    98.789     0.200
     6.981    98.406     0.200
     7.029    99.969     0.200
     7.095    99.688     0.200
     7.095    99.828     0.200
     7.095    99.633     0.200
     7.124   100.906     0.200
     7.124   101.422     0.200
     7.136   101.977     0.200
     7.136   101.734     0.200
     7.235   103.070     0.200
     7.235   102.766     0.200
     7.278   102.594     0.200
     7.277   103.305     0.200
     7.342   103.242     0.200
     7.488   106.516     0.200
     7.506   106.859     0.200
     7.511   107.258     0.200
     7.533   107.305     0.200
     7.576   107.500     0.200
     7.638   107.953     0.200
     7.777   110.109     0.200
     7.841   111.000     0.200
     7.841   110.742     0.200
     8.383   117.727     0.200
     8.731   121.633     0.200
     8.864   123.516     0.200
     8.864   124.086     0.200
     8.943   126.570     0.200
     8.943   126.227     0.200
     9.397   132.125     0.200
     9.584   134.945     0.200
     9.710   136.727     0.200
     9.867   136.719     0.200
     9.944   140.008     0.200
     9.944   139.445     0.200
    10.386   145.055     0.200
    10.956   152.531     0.200
    12.562   176.398     0.200
    12.562   176.719     0.200
    13.326   185.430     0.200
    13.326   184.734     0.200
    16.804   227.289     0.200
     0.579    12.051     0.200
     0.824    15.285     0.200
     1.105    19.875     0.200
     1.134    20.316     0.200
     1.213    20.336     0.200
     1.344    22.686     0.200
     1.351    23.436     0.200
     1.641    26.125     0.200
     1.652    26.566     0.200
     1.662    26.955     0.200
     1.730    28.426     0.200
     1.752    27.695     0.200
     2.017    31.557     0.200
     2.072    32.535     0.200
     2.114    33.576     0.200
     2.223    34.557     0.200
     2.221    34.676     0.200
     2.243    35.035     0.200
     2.354    35.166     0.200
     2.453    37.025     0.200
     2.659    40.646     0.200
     2.881    44.096     0.200
     2.954    45.336     0.200
     3.020    46.115     0.200
     3.079    45.717     0.200
     3.285    48.256     0.200
     3.662    52.875     0.200
     3.682    53.545     0.200
     3.679    54.646     0.200
     3.736    53.746     0.200
     3.867    56.205     0.200
     3.895    55.717     0.200
     4.035    58.336     0.200
     4.010    59.057     0.200
     4.091    59.156     0.200
     4.344    63.307     0.200
     4.398    63.566     0.200
     4.568    66.146     0.200
     4.787    68.625     0.200
     4.909    71.125     0.200
     4.879    70.756     0.200
     4.900    71.076     0.200
     5.074    74.375     0.200
     5.083    73.066     0.200
     5.136    73.836     0.200
     5.173    74.436     0.200
     5.224    75.926     0.200
     5.270    76.467     0.200
     5.360    76.836     0.200
     5.370    76.977     0.200
     5.458    78.416     0.200
     5.651    81.246     0.200
     5.665    81.727     0.200
     5.755    82.746     0.200
     5.776    81.557     0.200
     5.804    82.826     0.200
     5.861    84.467     0.200
     5.892    85.275     0.200
     6.015    86.436     0.200
     6.170    88.766     0.200
     6.489    93.025     0.200
     6.631    94.625     0.200
     6.698    94.605     0.200
     6.933    99.307     0.200
     6.970    98.766     0.200
     6.970    97.656     0.200
     7.142   101.436     0.200
     7.676   109.436     0.200
    13.049   181.682     0.200
    18.961   256.980     0.200
     0.762    14.984     0.200
     1.284    21.895     0.200
     1.332    22.855     0.200
     1.424    23.605     0.200
     1.415    23.887     0.200
     1.515    24.996     0.200
     1.546    24.953     0.200
     1.680    27.613     0.200
     1.932    31.145     0.200
     1.943    31.273     0.200
     2.126    32.477     0.200
     2.247    33.613     0.200
     2.267    35.445     0.200
     2.272    35.324     0.200
     2.277    35.266     0.200
     2.316    35.504     0.200
     2.351    35.953     0.200
     2.407    36.336     0.200
     2.407    36.613     0.200
     2.380    36.766     0.200
     2.431    37.254     0.200
     2.437    37.566     0.200
     2.443    37.496     0.200
     2.530    39.406     0.200
     2.777    42.156     0.200
     2.910    43.395     0.200
     2.956    44.414     0.200
     2.978    44.605     0.200
     3.005    45.266     0.200
     2.997    45.336     0.200
     3.061    45.637     0.200
     3.054    45.594     0.200
     3.264    49.266     0.200
     3.446    50.434     0.200
     3.515    51.586     0.200
     3.566    51.656     0.200
     3.551    51.984     0.200
     3.539    52.594     0.200
     3.577    52.734     0.200
     3.719    54.523     0.200
     3.740    54.875     0.200
     3.754    55.246     0.200
     3.742    55.434     0.200
     3.897    57.195     0.200
     4.078    59.613     0.200
     4.147    60.844     0.200
     4.241    60.684     0.200
     4.284    62.574     0.200
     4.292    63.176     0.200
     4.420    64.113     0.200
     4.680    68.613     0.200
     4.676    68.227     0.200
     4.832    69.113     0.200
     4.818    69.746     0.200
     4.925    71.336     0.200
     5.010    72.293     0.200
     5.030    72.375     0.200
     5.218    74.336     0.200
     5.213    75.285     0.200
     5.195    74.066     0.200
     5.184    74.766     0.200
     5.249    75.594     0.200
     5.343    76.203     0.200
     5.280    75.984     0.200
     5.327    76.695     0.200
     5.327    76.906     0.200
     5.399    77.684     0.200
     5.635    81.273     0.200
     5.709    81.004     0.200
     5.875    84.004     0.200
     6.325    88.984     0.200
     6.448    91.887     0.200
     6.548    92.766     0.200
     6.652    94.414     0.200
     6.786    95.953     0.200
     6.813    96.906     0.200
     6.897    97.203     0.200
     6.905    97.496     0.200
     6.993    99.645     0.200
     7.016    99.535     0.200
     7.322   103.113     0.200
     7.461   105.094     0.200
     7.809   109.996     0.200
     7.835   110.164     0.200
     9.498   133.543     0.200
     1.708    28.781     0.200
     1.810    30.031     0.200
     1.895    31.449     0.200
     2.110    34.480     0.200
     2.154    35.012     0.200
     2.175    36.422     0.200
     2.175    35.734     0.200
     2.598    40.902     0.200
     2.836    44.152     0.200
     2.916    44.992     0.200
     2.955    46.820     0.200
     3.013    48.191     0.200
     3.244    50.172     0.200
     3.236    50.352     0.200
     3.265    50.301     0.200
     3.334    52.020     0.200
     3.342    51.543     0.200
     3.482    52.883     0.200
     3.710    57.293     0.200
     3.733    56.660     0.200
     3.804    57.422     0.200
     3.842    57.691     0.200
     3.885    57.531     0.200
     4.087    61.051     0.200
     4.107    62.430     0.200
     4.093    61.051     0.200
     4.145    61.781     0.200
     4.311    64.281     0.200
     4.311    64.008     0.200
     4.464    67.520     0.200
     4.508    67.770     0.200
     4.617    68.312     0.200
     4.691    69.492     0.200
     4.795    70.781     0.200
     4.821    70.852     0.200
     5.183    77.043     0.200
     5.183    76.711     0.200
     5.262    77.109     0.200
     5.271    77.160     0.200
     5.311    76.922     0.200
     5.435    79.473     0.200
     5.477    79.949     0.200
     5.735    83.480     0.200
     5.894    86.082     0.200
     5.904    85.902     0.200
     5.964    86.801     0.200
     6.042    87.723     0.200
     6.136    89.000     0.200
     6.159    89.102     0.200
     6.269    90.691     0.200
     6.314    91.121     0.200
     6.550    94.930     0.200
     6.563    94.820     0.200
     6.621    96.660     0.200
     6.694    98.359     0.200
     6.735    96.480     0.200
     6.846    99.312     0.200
     6.859    98.680     0.200
     6.899   101.473     0.200
     6.996   101.750     0.200
     7.003   101.723     0.200
     7.067   102.012     0.200
     7.299   105.199     0.200
     7.444   107.750     0.200
     7.853   112.551     0.200
     8.125   116.793     0.200
     8.332   120.320     0.200
     9.254   132.402     0.200
     0.270    18.297     0.200
     0.313    18.828     0.200
     0.398    19.117     0.200
     0.532    19.828     0.200
     0.549    19.844     0.200
     0.813    21.305     0.200
     0.932    22.648     0.200
     0.932    22.891     0.200
     1.032    23.406     0.200
     1.044    23.492     0.200
     1.196    24.953     0.200
     1.242    26.578     0.200
     1.245    26.367     0.200
     1.257    26.305     0.200
     1.276    26.062     0.200
     1.514    29.148     0.200
     1.649    29.141     0.200
     1.694    30.523     0.200
     1.738    30.188     0.200
     2.036    35.414     0.200
     2.117    34.844     0.200
     2.174    37.242     0.200
     2.249    37.703     0.200
     2.276    38.289     0.200
     2.276    38.172     0.200
     2.287    37.984     0.200
     2.290    38.297     0.200
     2.383    39.234     0.200
     2.396    38.773     0.200
     2.416    39.648     0.200
     2.482    40.477     0.200
     2.527    40.984     0.200
     2.639    41.633     0.200
     2.639    42.109     0.200
     2.839    43.836     0.200
     3.033    48.273     0.200
     3.039    48.906     0.200
     3.039    47.523     0.200
     3.055    48.062     0.200
     3.055    47.883     0.200
     3.065    48.703     0.200
     3.181    49.703     0.200
     3.204    49.062     0.200
     3.229    49.422     0.200
     3.363    52.156     0.200
     3.404    52.773     0.200
     3.421    52.727     0.200
     3.421    52.375     0.200
     3.618    55.492     0.200
     3.618    55.344     0.200
     3.770    56.562     0.200
     3.972    60.227     0.200
     3.972    60.352     0.200
     4.101    60.672     0.200
     4.101    60.867     0.200
     4.202    61.773     0.200
     4.303    63.008     0.200
     4.303    62.680     0.200
     4.320    62.789     0.200
     4.320    62.625     0.200
     4.353    64.992     0.200
     4.376    65.219     0.200
     4.376    64.656     0.200
     4.441    63.555     0.200
     4.458    64.844     0.200
     4.458    64.688     0.200
     4.450    63.805     0.200
     4.514    65.438     0.200
     4.571    67.297     0.200
     4.571    67.188     0.200
     4.591    69.594     0.200
     4.707    68.664     0.200
     4.712    68.656     0.200
     4.750    69.086     0.200
     4.750    68.508     0.200
     4.750    68.398     0.200
     4.750    68.266     0.200
     4.829    71.273     0.200
     4.835    71.469     0.200
     4.974    71.422     0.200
     5.044    73.352     0.200
     5.100    74.727     0.200
     5.142    74.023     0.200
     5.244    76.016     0.200
     5.244    75.875     0.200
     5.421    78.945     0.200
     5.440    78.883     0.200
     5.459    79.234     0.200
     5.459    79.031     0.200
     5.474    77.898     0.200
     5.511    80.492     0.200
     5.511    80.148     0.200
     5.534    79.648     0.200
     5.534    79.469     0.200
     5.642    82.148     0.200
     5.642    81.883     0.200
     5.711    81.562     0.200
     5.747    83.562     0.200
     5.747    83.812     0.200
     5.746    82.469     0.200
     5.766    82.445     0.200
     5.820    84.078     0.200
     5.820    83.664     0.200
     5.899    85.273     0.200
     5.913    84.805     0.200
     5.913    84.594     0.200
     5.944    84.539     0.200
     5.944    84.266     0.200
     6.014    86.469     0.200
     6.014    85.977     0.200
     6.035    86.789     0.200
     6.087    87.805     0.200
     6.152    88.695     0.200
     6.152    88.250     0.200
     6.183    88.852     0.200
     6.231    90.047     0.200
     6.231    89.320     0.200
     6.269    89.555     0.200
     6.311    89.977     0.200
     6.435    92.227     0.200
     6.524    93.578     0.200
     6.521    92.578     0.200
     6.521    92.367     0.200
     6.608    94.836     0.200
     6.709    95.938     0.200
     6.722    94.766     0.200
     6.722    94.570     0.200
     6.804    97.227     0.200
     6.821    96.547     0.200
     6.837    96.234     0.200
     6.886    98.094     0.200
     6.948    99.312     0.200
     6.983    99.523     0.200
     6.986   100.352     0.200
     7.008    99.867     0.200
     7.008    99.703     0.200
     7.052    98.914     0.200
     7.077    99.414     0.200
     7.134   102.656     0.200
     7.156   101.664     0.200
     7.159   100.844     0.200
     7.159   100.383     0.200
     7.180   102.836     0.200
     7.180   102.648     0.200
     7.196   103.016     0.200
     7.196   102.906     0.200
     7.217   101.039     0.200
     7.220   101.344     0.200
     7.231   102.156     0.200
     7.231   101.859     0.200
     7.230   101.789     0.200
     7.230   101.477     0.200
     7.232   101.695     0.200
     7.232   101.523     0.200
     7.311   104.922     0.200
     7.323   104.414     0.200
     7.346   104.422     0.200
     7.346   103.758     0.200
     7.382   103.352     0.200
     7.382   103.016     0.200
     7.382   103.289     0.200
     7.442   106.688     0.200
     7.440   104.914     0.200
     7.464   106.195     0.200
     7.464   106.406     0.200
     7.534   105.969     0.200
     7.534   105.398     0.200
     7.633   108.484     0.200
     7.633   108.211     0.200
     7.673   107.219     0.200
     7.673   106.961     0.200
     7.676   107.445     0.200
     7.676   107.234     0.200
     7.680   110.867     0.200
     7.841   112.148     0.200
     7.838   109.938     0.200
     7.838   109.562     0.200
     7.888   112.578     0.200
     7.964   112.805     0.200
     7.964   112.383     0.200
     7.983   112.266     0.200
     7.983   113.469     0.200
     8.058   114.805     0.200
     8.058   114.523     0.200
     8.058   111.727     0.200
     8.092   114.766     0.200
     8.144   115.688     0.200
     8.155   113.562     0.200
     8.255   117.219     0.200
     8.328   115.508     0.200
     8.798   125.070     0.200
     8.867   126.016     0.200
     8.980   125.062     0.200
     8.980   124.406     0.200
     9.137   126.867     0.200
     9.269   131.367     0.200
     9.403   131.617     0.200
     9.403   131.984     0.200
     9.460   134.188     0.200
     9.934   138.328     0.200
    10.108   138.234     0.200
    10.408   143.938     0.200
    10.465   145.016     0.200
    10.671   151.117     0.200
    10.759   149.477     0.200
    10.944   152.656     0.200
    11.566   160.547     0.200
    11.566   159.484     0.200
    12.448   173.797     0.200
    12.462   171.625     0.200
    13.685   186.719     0.200
    13.685   186.828     0.200
    13.685   186.414     0.200
     0.711    13.852     0.200
     0.711    14.133     0.200
     0.782    13.758     0.200
     1.178    19.859     0.200
     1.259    21.273     0.200
     1.329    22.328     0.200
     1.358    22.773     0.200
     1.349    22.234     0.200
     1.349    22.422     0.200
     1.461    24.141     0.200
     1.566    24.852     0.200
     1.605    26.492     0.200
     1.619    26.602     0.200
     1.664    25.719     0.200
     1.664    26.039     0.200
     1.968    30.820     0.200
     2.090    32.203     0.200
     2.533    39.484     0.200
     2.533    39.211     0.200
     2.805    42.508     0.200
     2.805    41.797     0.200
     2.973    45.703     0.200
     2.994    45.875     0.200
     2.998    44.945     0.200
     3.082    46.148     0.200
     3.285    49.852     0.200
     3.284    49.945     0.200
     3.658    53.664     0.200
     3.664    54.742     0.200
     3.678    54.789     0.200
     3.697    54.773     0.200
     3.801    56.984     0.200
     3.994    58.172     0.200
     4.020    58.773     0.200
     4.128    61.023     0.200
     4.137    61.133     0.200
     4.191    62.031     0.200
     4.259    62.789     0.200
     4.261    62.742     0.200
     4.514    65.859     0.200
     4.786    69.289     0.200
     4.821    70.891     0.200
     4.926    71.992     0.200
     4.943    72.109     0.200
     4.987    72.875     0.200
     5.031    72.578     0.200
     5.034    73.750     0.200
     5.260    76.422     0.200
     5.351    77.594     0.200
     5.396    77.445     0.200
     5.600    80.570     0.200
     5.610    81.148     0.200
     5.660    80.594     0.200
     5.954    86.125     0.200
     6.033    86.398     0.200
     6.181    88.445     0.200
     6.336    91.031     0.200
     6.359    90.445     0.200
     6.379    91.562     0.200
     6.414    91.461     0.200
     6.442    91.031     0.200
     6.532    95.109     0.200
     6.706    95.320     0.200
     6.716    96.320     0.200
     6.773    96.844     0.200
     6.810    95.758     0.200
     6.817    97.820     0.200
     6.885    97.469     0.200
     6.948    98.719     0.200
     6.967    99.398     0.200
     7.050   101.391     0.200
     7.164   101.305     0.200
     7.241   101.930     0.200
     7.279   104.000     0.200
     7.336   105.312     0.200
     7.345   104.461     0.200
     7.364   104.023     0.200
     7.464   105.344     0.200
     7.542   107.094     0.200
     7.587   106.781     0.200
     7.645   107.570     0.200
     7.665   109.453     0.200
     7.754   109.820     0.200
     7.846   111.195     0.200
     7.859   111.469     0.200
     7.940   112.023     0.200
     8.007   112.609     0.200
     8.128   114.305     0.200
     8.132   115.281     0.200
     8.256   116.250     0.200
     8.423   118.453     0.200
     8.540   120.484     0.200
     8.631   121.602     0.200
     8.688   120.523     0.200
     8.728   122.352     0.200
     8.768   123.812     0.200
     8.896   125.734     0.200
     8.902   123.148     0.200
     8.996   127.414     0.200
     9.064   128.812     0.200
     9.075   126.789     0.200
     9.097   126.672     0.200
     9.181   129.625     0.200
     9.206   129.375     0.200
     9.206   127.984     0.200
     9.206   129.781     0.200
     9.326   131.602     0.200
     9.349   132.453     0.200
     9.426   133.461     0.200
     9.435   133.289     0.200
     9.455   134.203     0.200
     9.455   133.375     0.200
    10.147   141.398     0.200
    10.764   151.539     0.200
    10.793   152.883     0.200
    10.801   152.984     0.200
    11.982   165.555     0.200
    18.840   255.219     0.200
     0.303    15.113     0.200
     0.362    15.074     0.200
     0.368    15.176     0.200
     0.455    16.023     0.200
     0.502    16.215     0.200
     0.652    17.383     0.200
     0.974    20.684     0.200
     0.980    20.734     0.200
     1.156    21.508     0.200
     1.176    21.492     0.200
     1.101    22.004     0.200
     1.289    23.555     0.200
     1.375    25.395     0.200
     1.393    25.473     0.200
     1.396    25.516     0.200
     1.607    26.805     0.200
     1.682    29.125     0.200
     2.058    33.945     0.200
     2.065    33.645     0.200
     2.065    33.512     0.200
     2.205    35.965     0.200
     2.249    35.945     0.200
     2.218    34.715     0.200
     2.388    36.402     0.200
     2.476    39.395     0.200
     2.536    39.105     0.200
     2.520    39.945     0.200
     2.527    40.176     0.200
     2.588    39.863     0.200
     2.580    40.934     0.200
     2.630    41.516     0.200
     2.653    41.812     0.200
     2.680    42.062     0.200
     2.760    41.875     0.200
     3.002    45.836     0.200
     3.126    47.805     0.200
     3.280    48.926     0.200
     3.321    49.426     0.200
     3.307    50.273     0.200
     3.255    49.516     0.200
     3.319    50.152     0.200
     3.332    51.035     0.200
     3.333    50.734     0.200
     3.443    51.516     0.200
     3.426    52.074     0.200
     3.653    55.043     0.200
     3.775    56.664     0.200
     3.827    57.715     0.200
     3.865    56.953     0.200
     4.053    60.492     0.200
     4.213    61.402     0.200
     4.275    62.785     0.200
     4.261    62.062     0.200
     4.367    64.844     0.200
     4.436    64.453     0.200
     4.530    65.484     0.200
     4.637    67.125     0.200
     4.723    67.664     0.200
     4.797    69.543     0.200
     4.853    69.945     0.200
     4.828    71.113     0.200
     4.851    70.926     0.200
     4.918    70.004     0.200
     4.921    72.465     0.200
     5.022    72.184     0.200
     5.152    74.402     0.200
     5.212    74.863     0.200
     5.239    76.074     0.200
     5.405    77.926     0.200
     5.440    79.133     0.200
     5.535    79.402     0.200
     5.576    80.074     0.200
     5.615    80.203     0.200
     5.764    83.035     0.200
     5.724    82.363     0.200
     5.736    82.402     0.200
     5.804    83.293     0.200
     5.875    84.395     0.200
     5.869    83.445     0.200
     5.992    84.926     0.200
     6.046    86.375     0.200
     6.047    87.504     0.200
     6.060    86.992     0.200
     6.105    86.824     0.200
     6.133    87.914     0.200
     6.198    88.844     0.200
     6.276    89.723     0.200
     6.234    89.402     0.200
     6.257    89.043     0.200
     6.366    91.125     0.200
     6.388    91.234     0.200
     6.405    92.184     0.200
     6.454    91.883     0.200
     6.467    92.363     0.200
     6.567    93.945     0.200
     6.545    92.434     0.200
     6.622    94.113     0.200
     6.707    95.863     0.200
     6.753    96.484     0.200
     6.842    97.766     0.200
     6.839    97.266     0.200
     6.845    97.555     0.200
     6.880    98.293     0.200
     6.883    97.926     0.200
     6.977    99.926     0.200
     7.001    97.992     0.200
     7.065   101.043     0.200
     7.086    99.145     0.200
     7.157   100.523     0.200
     7.206   102.695     0.200
     7.174   101.965     0.200
     7.215   102.715     0.200
     7.286   104.402     0.200
     7.329   104.402     0.200
     7.300   101.723     0.200
     7.363   104.344     0.200
     7.404   105.715     0.200
     7.445   105.465     0.200
     7.463   104.586     0.200
     7.487   105.414     0.200
     7.489   104.023     0.200
     7.489   104.785     0.200
     7.550   107.125     0.200
     7.622   108.285     0.200
     7.612   106.133     0.200
     7.612   105.820     0.200
     7.591   107.945     0.200
     7.799   109.445     0.200
     7.863   109.992     0.200
     7.881   111.324     0.200
     7.997   113.465     0.200
     8.016   113.234     0.200
     8.016   113.176     0.200
     8.009   112.664     0.200
     8.241   119.254     0.200
     8.346   116.312     0.200
     9.456   133.023     0.200
     9.880   139.004     0.200
    10.062   141.445     0.200
    10.376   145.844     0.200
    10.377   143.023     0.200
    10.775   152.074     0.200
    10.856   152.324     0.200
    18.294   246.375     0.200
     1.254    20.912     0.200
     1.408    24.023     0.200
     1.521    26.363     0.200
     1.533    26.463     0.200
     1.657    26.684     0.200
     1.681    26.594     0.200
     1.707    28.662     0.200
     1.707    29.023     0.200
     2.000    32.162     0.200
     1.996    32.174     0.200
     2.078    32.322     0.200
     2.286    34.674     0.200
     2.220    33.973     0.200
     2.347    35.953     0.200
     2.387    38.082     0.200
     2.491    37.742     0.200
     2.422    37.273     0.200
     2.506    38.652     0.200
     2.518    38.613     0.200
     3.053    47.053     0.200
     3.029    46.213     0.200
     3.222    47.434     0.200
     3.162    46.424     0.200
     3.367    50.254     0.200
     3.668    53.143     0.200
     3.737    53.562     0.200
     3.556    52.693     0.200
     3.708    55.553     0.200
     3.908    56.473     0.200
     3.900    56.943     0.200
     4.049    60.014     0.200
     4.086    60.273     0.200
     4.306    63.482     0.200
     4.452    65.104     0.200
     4.345    64.473     0.200
     4.481    66.264     0.200
     4.868    70.152     0.200
     4.988    73.033     0.200
     5.095    73.562     0.200
     5.181    75.133     0.200
     5.202    74.742     0.200
     5.388    78.053     0.200
     5.250    77.504     0.200
     5.461    79.393     0.200
     5.389    78.713     0.200
     5.357    78.934     0.200
     5.576    81.764     0.200
     5.571    79.504     0.200
     5.462    80.023     0.200
     5.442    77.863     0.200
     5.704    81.963     0.200
     5.884    85.152     0.200
     5.880    85.473     0.200
     5.986    87.193     0.200
     6.080    87.934     0.200
     5.988    85.803     0.200
     6.923    99.523     0.200
     7.039   101.553     0.200
     7.118   102.492     0.200
     7.166   103.293     0.200
     7.927   112.674     0.200
     9.866   141.393     0.200
     0.604    13.539     0.200
     0.715    14.869     0.200
     0.732    15.119     0.200
     0.755    15.539     0.200
     0.772    15.229     0.200
     0.780    15.559     0.200
     1.041    18.833     0.200
     1.085    19.099     0.200
     1.381    23.298     0.200
     1.381    23.613     0.200
     1.810    28.698     0.200
     1.824    29.988     0.200
     1.827    30.329     0.200
     1.846    30.369     0.200
     1.848    30.269     0.200
     1.913    29.809     0.200
     1.913    29.367     0.200
     2.137    34.338     0.200
     2.136    34.164     0.200
     2.217    34.448     0.200
     2.263    34.798     0.200
     2.263    35.113     0.200
     2.525    39.028     0.200
     2.525    39.396     0.200
     2.577    39.269     0.200
     2.577    39.790     0.200
     2.647    41.068     0.200
     2.855    42.349     0.200
     2.888    43.418     0.200
     2.939    44.869     0.200
     2.920    44.298     0.200
     2.983    46.008     0.200
     2.994    45.749     0.200
     3.098    47.269     0.200
     3.076    46.409     0.200
     3.144    47.139     0.200
     3.195    48.438     0.200
     3.524    52.369     0.200
     3.589    53.988     0.200
     3.612    52.378     0.200
     3.636    53.119     0.200
     3.778    56.019     0.200
     3.797    56.749     0.200
     3.887    57.809     0.200
     4.024    58.488     0.200
     4.113    60.818     0.200
     4.242    61.869     0.200
     4.290    63.338     0.200
     4.530    65.179     0.200
     4.572    67.619     0.200
     4.695    68.458     0.200
     4.674    67.858     0.200
     4.821    69.028     0.200
     4.877    71.398     0.200
     4.886    69.878     0.200
     5.007    71.179     0.200
     5.024    73.088     0.200
     5.177    73.179     0.200
     5.226    74.568     0.200
     5.240    76.369     0.200
     5.306    75.599     0.200
     5.379    76.718     0.200
     5.373    77.519     0.200
     5.410    79.179     0.200
     5.562    79.539     0.200
     5.676    81.179     0.200
     5.730    82.659     0.200
     5.752    83.389     0.200
     5.833    83.179     0.200
     5.841    83.639     0.200
     5.932    85.968     0.200
     5.950    84.628     0.200
     5.999    85.269     0.200
     6.007    85.358     0.200
     6.048    86.409     0.200
     6.075    86.338     0.200
     6.081    86.948     0.200
     6.142    87.858     0.200
     6.200    88.378     0.200
     6.200    88.249     0.200
     6.228    88.539     0.200
     6.367    91.099     0.200
     6.412    91.238     0.200
     6.430    91.179     0.200
     6.456    91.918     0.200
     6.507    92.778     0.200
     6.561    93.519     0.200
     6.574    94.318     0.200
     6.643    94.708     0.200
     6.644    94.258     0.200
     6.691    95.298     0.200
     6.698    95.789     0.200
     6.704    95.258     0.200
     6.716    95.479     0.200
     6.764    96.468     0.200
     6.933    98.639     0.200
     6.947    98.628     0.200
     6.985    98.818     0.200
     7.012    99.849     0.200
     7.042   100.179     0.200
     7.092   100.539     0.200
     7.101   101.079     0.200
     7.249   103.179     0.200
     7.409   105.278     0.200
     7.445   106.108     0.200
     7.464   104.479     0.200
     7.487   106.119     0.200
     7.523   106.929     0.200
     7.534   105.229     0.200
     7.627   108.198     0.200
     7.674   109.119     0.200
     7.743   109.968     0.200
     7.747   107.909     0.200
     7.901   112.188     0.200
     7.916   111.849     0.200
     7.936   110.958     0.200
     7.947   112.179     0.200
     8.049   112.539     0.200
     8.049   112.289     0.200
     8.049   112.648     0.200
     8.065   113.758     0.200
     8.098   114.539     0.200
     8.138   114.458     0.200
     8.175   114.838     0.200
     8.276   116.188     0.200
     8.308   117.499     0.200
     8.326   117.479     0.200
     8.394   118.958     0.200
     8.553   119.979     0.200
     8.810   124.139     0.200
     9.277   129.628     0.200
     9.778   137.349     0.200
    10.119   143.019     0.200
    10.515   147.858     0.200
    11.063   155.648     0.200
    12.974   181.713     0.200
    14.238   196.488     0.200
     0.581    12.180     0.200
     0.913    16.969     0.200
     0.921    17.125     0.200
     0.923    17.109     0.200
     0.942    17.367     0.200
     1.151    20.188     0.200
     1.188    20.680     0.200
     1.314    22.086     0.200
     1.376    23.148     0.200
     1.363    23.656     0.200
     1.468    24.289     0.200
     1.618    26.727     0.200
     1.673    26.758     0.200
     1.703    27.336     0.200
     1.861    29.156     0.200
     1.950    30.852     0.200
     1.994    31.758     0.200
     2.018    31.930     0.200
     2.091    32.828     0.200
     2.122    34.148     0.200
     2.126    33.430     0.200
     2.426    36.641     0.200
     2.467    37.398     0.200
     2.473    39.539     0.200
     2.470    37.625     0.200
     2.598    38.352     0.200
     2.669    39.781     0.200
     2.783    43.000     0.200
     2.813    43.734     0.200
     2.863    43.688     0.200
     3.083    46.031     0.200
     3.083    46.570     0.200
     3.345    49.117     0.200
     3.513    52.430     0.200
     3.578    53.375     0.200
     3.665    53.438     0.200
     3.712    54.156     0.200
     3.823    54.859     0.200
     3.870    56.602     0.200
     3.836    56.508     0.200
     3.999    57.102     0.200
     4.061    59.047     0.200
     4.042    59.609     0.200
     4.123    60.156     0.200
     4.216    60.867     0.200
     4.384    63.781     0.200
     4.495    65.078     0.200
     4.451    65.828     0.200
     4.621    67.516     0.200
     4.638    67.578     0.200
     4.648    67.375     0.200
     4.687    67.820     0.200
     4.714    68.227     0.200
     4.815    69.102     0.200
     4.854    70.055     0.200
     4.907    70.281     0.200
     4.873    70.281     0.200
     4.927    71.625     0.200
     4.978    72.102     0.200
     5.096    72.891     0.200
     5.157    74.547     0.200
     5.188    75.398     0.200
     5.333    76.820     0.200
     5.361    77.320     0.200
     5.451    78.500     0.200
     5.469    78.086     0.200
     5.516    79.125     0.200
     5.434    78.617     0.200
     5.515    79.430     0.200
     5.621    80.297     0.200
     5.620    81.078     0.200
     5.779    82.688     0.200
     5.722    82.172     0.200
     5.803    82.711     0.200
     5.749    82.406     0.200
     5.811    83.336     0.200
     5.955    85.234     0.200
     6.116    87.680     0.200
     6.262    88.766     0.200
     6.333    90.547     0.200
     6.302    90.789     0.200
     6.383    91.539     0.200
     6.410    90.445     0.200
     6.496    92.359     0.200
     6.448    91.258     0.200
     6.550    94.719     0.200
     6.578    94.016     0.200
     6.703    95.055     0.200
     6.719    96.398     0.200
     6.743    96.008     0.200
     6.878    97.336     0.200
     6.906    96.945     0.200
     6.942    98.016     0.200
     6.942    97.836     0.200
     7.122   100.531     0.200
     7.140   101.680     0.200
     7.138   100.648     0.200
     7.207   101.828     0.200
     7.544   106.289     0.200
     7.544   106.547     0.200
     7.756   109.156     0.200
     8.348   115.734     0.200
     8.442   119.219     0.200
     8.504   120.805     0.200
     8.872   123.359     0.200
     9.422   132.688     0.200
     9.753   135.945     0.200
     9.747   136.156     0.200
    11.992   167.031     0.200
     0.615    13.611     0.200
     0.655    14.342     0.200
     0.663    14.543     0.200
     0.683    14.873     0.200
     0.692    14.883     0.200
     0.861    16.521     0.200
     0.861    16.932     0.200
     0.845    16.521     0.200
     0.845    16.668     0.200
     0.845    16.633     0.200
     0.882    16.953     0.200
     1.131    19.686     0.200
     1.131    19.271     0.200
     1.177    20.012     0.200
     1.180    21.191     0.200
     1.180    21.293     0.200
     1.217    21.053     0.200
     1.523    25.322     0.200
     1.566    25.492     0.200
     1.596    26.402     0.200
     1.697    28.021     0.200
     1.748    27.463     0.200
     1.748    27.809     0.200
     1.947    29.781     0.200
     1.947    30.178     0.200
     1.965    30.852     0.200
     1.979    32.861     0.200
     1.979    33.201     0.200
     2.100    31.992     0.200
     2.100    32.691     0.200
     2.303    36.482     0.200
     2.303    36.602     0.200
     2.327    37.133     0.200
     2.359    37.422     0.200
     2.374    37.703     0.200
     2.401    38.082     0.200
     2.509    39.441     0.200
     2.530    38.021     0.200
     2.530    38.385     0.200
     2.530    38.143     0.200
     2.580    39.092     0.200
     2.580    39.422     0.200
     2.618    41.072     0.200
     2.698    40.512     0.200
     2.855    42.293     0.200
     2.855    42.828     0.200
     3.082    46.312     0.200
     3.162    46.342     0.200
     3.162    47.062     0.200
     3.188    46.793     0.200
     3.188    47.041     0.200
     3.194    46.842     0.200
     3.211    47.111     0.200
     3.211    47.613     0.200
     3.349    48.312     0.200
     3.349    48.574     0.200
     3.367    49.422     0.200
     3.491    52.373     0.200
     3.491    52.543     0.200
     3.539    50.611     0.200
     3.558    52.012     0.200
     3.558    52.531     0.200
     3.536    51.543     0.200
     3.596    53.281     0.200
     3.648    52.992     0.200
     3.650    54.992     0.200
     3.670    54.143     0.200
     3.728    54.707     0.200
     3.757    54.812     0.200
     3.775    54.652     0.200
     3.885    56.543     0.200
     3.885    57.150     0.200
     4.004    59.652     0.200
     4.028    58.281     0.200
     4.167    60.652     0.200
     4.167    60.822     0.200
     4.256    61.953     0.200
     4.351    63.531     0.200
     4.373    63.793     0.200
     4.373    63.936     0.200
     4.372    64.092     0.200
     4.402    63.633     0.200
     4.392    64.342     0.200
     4.458    63.713     0.200
     4.458    64.197     0.200
     4.465    65.172     0.200
     4.467    64.592     0.200
     4.519    65.652     0.200
     4.530    66.021     0.200
     4.532    66.402     0.200
     4.532    66.861     0.200
     4.505    66.703     0.200
     4.577    66.082     0.200
     4.633    68.762     0.200
     4.685    67.342     0.200
     4.678    68.531     0.200
     4.678    67.994     0.200
     4.695    68.393     0.200
     4.720    69.281     0.200
     4.758    68.453     0.200
     4.758    68.676     0.200
     4.830    70.227     0.200
     4.844    70.232     0.200
     4.839    69.842     0.200
     4.859    70.293     0.200
     4.859    70.549     0.200
     4.916    70.713     0.200
     4.993    72.332     0.200
     4.993    72.211     0.200
     5.009    71.271     0.200
     5.021    72.941     0.200
     5.059    72.672     0.200
     5.075    72.852     0.200
     5.108    72.842     0.200
     5.129    74.543     0.200
     5.129    74.293     0.200
     5.198    74.643     0.200
     5.217    75.203     0.200
     5.258    75.932     0.200
     5.258    75.316     0.200
     5.310    76.441     0.200
     5.328    76.232     0.200
     5.348    77.271     0.200
     5.348    77.912     0.200
     5.391    77.521     0.200
     5.468    78.332     0.200
     5.472    78.982     0.200
     5.486    79.062     0.200
     5.504    79.232     0.200
     5.509    78.633     0.200
     5.566    80.271     0.200
     5.638    80.611     0.200
     5.638    81.004     0.200
     5.702    81.922     0.200
     5.822    83.031     0.200
     5.822    83.453     0.200
     5.834    83.441     0.200
     5.867    84.982     0.200
     5.871    84.742     0.200
     5.936    85.521     0.200
     5.927    84.043     0.200
     5.957    85.523     0.200
     5.961    86.143     0.200
     5.956    84.543     0.200
     6.058    86.852     0.200
     6.058    86.613     0.200
     6.070    87.611     0.200
     6.076    86.453     0.200
     6.076    86.764     0.200
     6.082    86.973     0.200
     6.166    87.252     0.200
     6.220    89.412     0.200
     6.241    88.973     0.200
     6.248    89.521     0.200
     6.254    88.992     0.200
     6.238    90.021     0.200
     6.299    90.633     0.200
     6.299    90.041     0.200
     6.327    90.393     0.200
     6.367    90.312     0.200
     6.369    90.143     0.200
     6.369    90.312     0.200
     6.390    90.521     0.200
     6.429    91.213     0.200
     6.429    91.367     0.200
     6.446    92.393     0.200
     6.445    91.352     0.200
     6.445    91.242     0.200
     6.504    92.592     0.200
     6.504    92.250     0.200
     6.612    94.713     0.200
     6.627    93.832     0.200
     6.637    94.473     0.200
     6.637    94.691     0.200
     6.636    94.332     0.200
     6.655    94.842     0.200
     6.655    94.293     0.200
     6.662    94.375     0.200
     6.694    95.492     0.200
     6.716    95.732     0.200
     6.736    95.512     0.200
     6.776    96.043     0.200
     6.776    95.893     0.200
     7.020    99.156     0.200
     7.073    99.967     0.200
     7.086   100.402     0.200
     7.127   101.043     0.200
     7.143   101.172     0.200
     7.143   100.684     0.200
     7.271   102.439     0.200
     7.244   103.922     0.200
     7.244   104.025     0.200
     7.244   104.143     0.200
     7.317   105.094     0.200
     7.371   105.432     0.200
     7.371   105.227     0.200
     7.421   105.762     0.200
     7.460   107.043     0.200
     7.768   110.293     0.200
     7.768   110.119     0.200
     7.942   112.232     0.200
     7.975   113.043     0.200
     8.016   114.473     0.200
     8.104   114.496     0.200
     8.339   118.643     0.200
     8.339   119.051     0.200
     8.413   118.643     0.200
     8.413   118.943     0.200
     8.501   119.557     0.200
     8.696   122.686     0.200
     8.747   123.699     0.200
     8.736   123.992     0.200
     8.812   123.492     0.200
     8.812   124.260     0.200
     8.833   125.441     0.200
     8.867   125.213     0.200
     9.034   127.055     0.200
     9.243   129.582     0.200
     9.243   129.383     0.200
     9.241   128.492     0.200
     9.254   128.771     0.200
     9.287   128.562     0.200
     9.458   132.543     0.200
     9.481   133.482     0.200
     9.481   133.359     0.200
     9.588   136.693     0.200
     9.803   139.031     0.200
     9.853   138.322     0.200
     9.853   139.074     0.200
     9.965   139.662     0.200
    10.279   144.883     0.200
    10.384   144.752     0.200
    10.427   146.898     0.200
    10.932   152.047     0.200
    10.991   153.914     0.200
    11.032   151.604     0.200
    11.049   153.590     0.200
    11.675   163.768     0.200
    12.281   171.684     0.200
    12.572   174.104     0.200
    12.572   174.492     0.200
    12.583   173.133     0.200
    13.426   184.602     0.200
    13.972   196.842     0.200
    15.275   211.479     0.200
    15.392   213.643     0.200
    15.392   213.842     0.200
    16.019   218.262     0.200
    16.019   217.816     0.200
    17.066   232.582     0.200
    17.066   232.369     0.200
    18.679   253.492     0.200
    20.746   277.754     0.200
    20.757   277.770     0.200
     0.469    14.766     0.200
     0.567    15.266     0.200
     0.787    17.453     0.200
     0.796    17.695     0.200
     0.854    18.055     0.200
     0.904    18.953     0.200
     0.903    19.234     0.200
     0.906    19.359     0.200
     0.924    19.414     0.200
     0.925    19.484     0.200
     0.929    19.453     0.200
     1.035    19.812     0.200
     1.110    20.703     0.200
     1.214    22.805     0.200
     1.215    22.844     0.200
     1.388    23.680     0.200
     1.418    24.992     0.200
     1.438    25.164     0.200
     1.506    25.898     0.200
     1.671    27.984     0.200
     1.707    28.875     0.200
     1.734    29.383     0.200
     1.795    29.625     0.200
     1.978    31.523     0.200
     2.014    32.758     0.200
     2.058    33.469     0.200
     2.076    32.898     0.200
     2.068    33.633     0.200
     2.134    33.664     0.200
     2.125    34.273     0.200
     2.172    35.039     0.200
     2.192    35.273     0.200
     2.295    36.188     0.200
     2.334    36.688     0.200
     2.676    41.117     0.200
     2.837    42.398     0.200
     2.807    42.648     0.200
     2.846    43.898     0.200
     2.868    43.547     0.200
     2.875    44.594     0.200
     2.964    45.633     0.200
     2.975    45.406     0.200
     3.190    48.625     0.200
     3.278    49.875     0.200
     3.389    50.680     0.200
     3.385    50.867     0.200
     3.397    51.555     0.200
     3.679    54.984     0.200
     3.960    57.742     0.200
     3.960    58.164     0.200
     3.962    58.867     0.200
     4.056    58.828     0.200
     4.123    60.508     0.200
     4.128    60.289     0.200
     4.161    60.555     0.200
     4.268    61.148     0.200
     4.328    63.305     0.200
     4.377    63.484     0.200
     4.471    63.844     0.200
     4.481    66.023     0.200
     4.487    65.938     0.200
     4.509    66.055     0.200
     4.566    66.227     0.200
     4.572    66.227     0.200
     4.720    68.992     0.200
     4.718    68.016     0.200
     4.788    68.023     0.200
     4.739    68.508     0.200
     4.842    70.938     0.200
     4.953    71.516     0.200
     5.004    72.930     0.200
     5.004    73.094     0.200
     5.074    72.930     0.200
     5.106    73.430     0.200
     5.138    73.828     0.200
     5.166    74.344     0.200
     5.178    75.078     0.200
     5.202    74.898     0.200
     5.272    75.805     0.200
     5.276    76.305     0.200
     5.333    76.812     0.200
     5.398    77.383     0.200
     5.466    78.766     0.200
     5.522    79.703     0.200
     5.521    78.953     0.200
     5.632    80.680     0.200
     5.628    80.625     0.200
     5.665    82.094     0.200
     5.665    82.414     0.200
     5.678    81.367     0.200
     5.790    83.312     0.200
     5.788    83.133     0.200
     5.863    83.883     0.200
     5.895    84.398     0.200
     5.941    84.625     0.200
     6.004    86.375     0.200
     6.014    85.539     0.200
     6.055    86.914     0.200
     6.147    88.227     0.200
     6.338    90.758     0.200
     6.414    91.547     0.200
     6.432    91.828     0.200
     6.454    91.969     0.200
     6.541    91.773     0.200
     6.728    95.727     0.200
     6.748    95.578     0.200
     6.748    96.242     0.200
     6.780    96.008     0.200
     6.833    95.133     0.200
     6.882    97.984     0.200
     6.886    98.062     0.200
     7.009    99.062     0.200
     7.026    98.633     0.200
     7.141   100.062     0.200
     7.141   101.773     0.200
     7.166   101.648     0.200
     7.178   101.938     0.200
     7.268   103.375     0.200
     7.323   102.758     0.200
     7.383   105.188     0.200
     7.388   104.797     0.200
     7.388   105.258     0.200
     7.481   106.547     0.200
     7.549   106.156     0.200
     7.549   106.836     0.200
     7.624   106.766     0.200
     7.624   107.336     0.200
     7.669   108.562     0.200
     9.912   138.773     0.200
     9.979   141.414     0.200
    10.359   146.328     0.200
    12.590   177.086     0.200
     0.215     8.727     0.200
     0.529    11.078     0.200
     1.339    21.398     0.200
     1.262    22.250     0.200
     1.350    23.234     0.200
     1.771    28.477     0.200
     1.942    31.289     0.200
     2.024    32.094     0.200
     2.062    32.875     0.200
     2.319    35.375     0.200
     2.323    35.820     0.200
     2.399    35.430     0.200
     2.374    37.195     0.200
     2.708    41.188     0.200
     2.752    42.156     0.200
     2.776    42.148     0.200
     2.849    43.109     0.200
     2.883    43.328     0.200
     3.007    44.078     0.200
     3.133    46.273     0.200
     3.198    48.047     0.200
     3.301    48.367     0.200
     3.326    49.648     0.200
     3.563    52.859     0.200
     3.614    53.406     0.200
     3.640    53.719     0.200
     3.760    55.023     0.200
     4.175    61.297     0.200
     4.257    62.156     0.200
     4.370    62.641     0.200
     4.355    62.336     0.200
     4.508    63.891     0.200
     4.549    65.570     0.200
     4.676    67.211     0.200
     4.574    67.000     0.200
     4.721    68.688     0.200
     4.698    66.641     0.200
     4.788    68.195     0.200
     4.795    70.273     0.200
     4.889    71.859     0.200
     5.017    72.016     0.200
     5.012    72.297     0.200
     5.206    74.789     0.200
     5.316    77.156     0.200
     5.207    75.180     0.200
     5.377    76.898     0.200
     5.440    78.023     0.200
     5.529    79.055     0.200
     5.568    80.344     0.200
     5.575    79.836     0.200
     5.705    81.125     0.200
     5.793    83.391     0.200
     5.758    82.500     0.200
     5.681    82.414     0.200
     5.962    85.016     0.200
     5.988    85.844     0.200
     6.044    86.617     0.200
     6.053    85.570     0.200
     6.182    88.609     0.200
     6.247    89.828     0.200
     6.363    90.078     0.200
     6.498    93.125     0.200
     6.445    92.414     0.200
     6.473    93.195     0.200
     6.503    92.617     0.200
     6.676    95.461     0.200
     6.673    95.195     0.200
     6.779    97.211     0.200
     6.874    97.844     0.200
     6.847    98.430     0.200
     7.000    99.117     0.200
     6.956    99.766     0.200
     7.271   103.438     0.200
     7.238   103.305     0.200
     7.171   101.438     0.200
     7.229   103.055     0.200
     7.315   103.539     0.200
     7.381   103.875     0.200
     7.609   106.836     0.200
     7.683   108.938     0.200
     7.700   109.461     0.200
     7.654   108.391     0.200
     7.654   109.609     0.200
     7.649   107.484     0.200
     7.965   111.688     0.200
     8.252   116.789     0.200
     8.292   115.766     0.200
     8.301   118.438     0.200
     8.491   119.336     0.200
     9.372   131.719     0.200
     9.407   132.430     0.200
     9.729   138.094     0.200
     9.626   136.891     0.200
     9.881   138.734     0.200
    10.468   146.398     0.200
     0.459    10.859     0.200
     0.460    10.867     0.200
     0.570    12.141     0.200
     0.708    13.945     0.200
     0.752    14.656     0.200
     1.088    18.688     0.200
     1.078    19.234     0.200
     1.088    19.219     0.200
     1.089    19.398     0.200
     1.090    19.445     0.200
     1.090    19.445     0.200
     1.097    19.219     0.200
     1.107    19.695     0.200
     1.362    23.297     0.200
     1.433    23.805     0.200
     1.545    25.484     0.200
     1.543    25.727     0.200
     1.543    26.203     0.200
     1.583    25.148     0.200
     1.724    27.992     0.200
     1.801    29.195     0.200
     1.851    28.797     0.200
     1.843    28.836     0.200
     1.867    29.484     0.200
     1.922    30.203     0.200
     1.990    31.273     0.200
     2.014    31.633     0.200
     2.131    33.758     0.200
     2.175    33.734     0.200
     2.199    34.398     0.200
     2.271    35.539     0.200
     2.303    36.352     0.200
     2.308    36.055     0.200
     2.568    38.898     0.200
     2.585    38.664     0.200
     2.629    40.125     0.200
     2.656    41.055     0.200
     2.692    41.328     0.200
     2.768    41.055     0.200
     2.798    41.797     0.200
     2.798    42.219     0.200
     2.856    41.648     0.200
     2.926    44.164     0.200
     2.935    44.406     0.200
     3.011    45.992     0.200
     3.090    46.094     0.200
     3.261    47.938     0.200
     3.261    48.398     0.200
     3.267    48.977     0.200
     3.379    50.258     0.200
     3.379    50.461     0.200
     3.596    52.945     0.200
     3.656    54.398     0.200
     3.761    55.234     0.200
     3.770    55.477     0.200
     3.843    55.383     0.200
     3.884    56.648     0.200
     3.951    57.672     0.200
     3.977    57.906     0.200
     3.977    56.969     0.200
     4.000    58.906     0.200
     4.049    58.742     0.200
     4.146    58.406     0.200
     4.215    62.094     0.200
     4.236    61.742     0.200
     4.352    61.922     0.200
     4.554    66.102     0.200
     4.645    67.336     0.200
     4.633    67.445     0.200
     4.633    68.289     0.200
     4.805    69.539     0.200
     4.852    70.539     0.200
     4.873    70.438     0.200
     4.873    70.672     0.200
     4.937    71.188     0.200
     5.029    71.336     0.200
     5.032    72.602     0.200
     5.044    73.469     0.200
     5.046    72.422     0.200
     5.082    73.039     0.200
     5.101    73.398     0.200
     5.101    74.047     0.200
     5.127    74.242     0.200
     5.160    74.812     0.200
     5.341    76.336     0.200
     5.341    77.367     0.200
     5.382    77.594     0.200
     5.382    77.883     0.200
     5.372    77.875     0.200
     5.517    79.062     0.200
     5.540    79.578     0.200
     5.540    79.812     0.200
     5.564    80.477     0.200
     5.614    80.344     0.200
     5.635    80.344     0.200
     5.663    80.734     0.200
     5.804    83.523     0.200
     5.919    84.383     0.200
     5.906    84.352     0.200
     5.906    85.180     0.200
     5.924    84.023     0.200
     5.924    84.844     0.200
     5.994    85.305     0.200
     5.983    86.258     0.200
     6.007    86.453     0.200
     6.077    87.562     0.200
     6.137    87.812     0.200
     6.140    89.383     0.200
     6.238    89.344     0.200
     6.390    91.953     0.200
     6.446    93.133     0.200
     6.458    92.914     0.200
     6.508    93.086     0.200
     6.617    94.086     0.200
     6.753    96.492     0.200
     6.791    96.227     0.200
     6.806    97.094     0.200
     6.843    96.773     0.200
     6.844    97.078     0.200
     6.870    98.008     0.200
     6.914    98.016     0.200
     6.925    97.766     0.200
     7.063    99.688     0.200
     7.093   100.805     0.200
     7.091    99.773     0.200
     7.125   100.812     0.200
     7.125   100.695     0.200
     7.125   100.539     0.200
     7.180   101.953     0.200
     7.281   102.945     0.200
     7.299   103.188     0.200
     7.318   104.562     0.200
     7.339   102.062     0.200
     7.698   109.492     0.200
     7.729   109.078     0.200
     7.809   112.086     0.200
     7.941   111.836     0.200
     8.231   116.047     0.200
     8.281   117.148     0.200
     9.056   127.023     0.200
     9.091   128.562     0.200
     9.235   130.742     0.200
     9.529   133.938     0.200
     9.537   134.328     0.200
     9.909   139.695     0.200
     9.931   138.695     0.200
    12.067   169.945     0.200
    12.067   169.406     0.200
     0.543    12.584     0.200
     0.638    13.074     0.200
     0.831    16.864     0.200
     0.860    17.094     0.200
     0.935    17.464     0.200
     1.002    18.504     0.200
     1.003    18.504     0.200
     1.096    19.954     0.200
     1.105    19.704     0.200
     1.290    21.874     0.200
     1.320    21.494     0.200
     1.441    23.994     0.200
     1.497    24.614     0.200
     1.512    24.754     0.200
     1.526    25.813     0.200
     1.532    25.934     0.200
     1.534    25.984     0.200
     1.539    26.014     0.200
     1.543    25.954     0.200
     1.552    26.074     0.200
     1.780    28.334     0.200
     1.825    28.884     0.200
     2.022    31.804     0.200
     2.091    33.384     0.200
     2.094    33.124     0.200
     2.166    33.744     0.200
     2.191    34.164     0.200
     2.207    34.154     0.200
     2.274    35.824     0.200
     2.307    34.134     0.200
     2.307    36.184     0.200
     2.392    36.604     0.200
     2.414    37.244     0.200
     2.605    39.624     0.200
     2.625    40.074     0.200
     2.663    40.354     0.200
     2.662    40.474     0.200
     2.669    41.044     0.200
     2.688    41.074     0.200
     2.755    41.994     0.200
     2.793    42.734     0.200
     2.803    42.714     0.200
     2.935    44.084     0.200
     3.021    45.784     0.200
     3.086    46.384     0.200
     3.126    45.924     0.200
     3.192    47.124     0.200
     3.196    48.604     0.200
     3.317    49.834     0.200
     3.425    50.824     0.200
     3.446    51.544     0.200
     3.447    51.297     0.200
     3.448    51.294     0.200
     3.488    52.204     0.200
     3.490    51.914     0.200
     3.518    52.773     0.200
     3.557    52.924     0.200
     3.755    55.854     0.200
     3.781    56.063     0.200
     3.810    55.874     0.200
     3.915    57.664     0.200
     4.066    59.773     0.200
     4.100    60.114     0.200
     4.109    59.114     0.200
     4.114    59.144     0.200
     4.285    62.484     0.200
     4.392    63.164     0.200
     4.405    64.434     0.200
     4.434    63.904     0.200
     4.466    64.724     0.200
     4.513    64.523     0.200
     4.597    66.484     0.200
     4.660    67.563     0.200
     4.672    66.684     0.200
     4.786    68.944     0.200
     4.812    69.204     0.200
     4.864    70.244     0.200
     4.950    71.464     0.200
     5.103    73.464     0.200
     5.125    74.484     0.200
     5.175    74.574     0.200
     5.227    75.754     0.200
     5.249    75.813     0.200
     5.344    76.724     0.200
     5.522    79.144     0.200
     5.538    79.544     0.200
     5.544    79.694     0.200
     5.553    79.523     0.200
     5.562    79.654     0.200
     5.581    79.724     0.200
     5.651    80.734     0.200
     5.674    81.584     0.200
     5.839    83.604     0.200
     5.863    84.304     0.200
     5.914    84.884     0.200
     5.930    84.504     0.200
     6.033    86.264     0.200
     6.088    86.454     0.200
     6.102    87.364     0.200
     6.116    87.254     0.200
     6.121    87.362     0.200
     6.136    87.744     0.200
     6.177    88.444     0.200
     6.241    89.273     0.200
     6.368    91.273     0.200
     6.408    91.584     0.200
     6.457    92.273     0.200
     6.485    92.614     0.200
     6.520    93.244     0.200
     6.532    93.023     0.200
     6.571    93.614     0.200
     6.583    94.023     0.200
     6.607    94.044     0.200
     6.723    95.834     0.200
     6.829    97.534     0.200
     6.886    97.784     0.200
     6.916    98.244     0.200
     6.995    98.986     0.200
     6.999    98.984     0.200
     7.097   101.664     0.200
     7.101    99.874     0.200
     7.167   100.864     0.200
     7.257   103.144     0.200
     7.257   103.146     0.200
     7.347   103.424     0.200
     7.378   103.384     0.200
     7.477   105.464     0.200
     7.535   106.324     0.200
     7.546   108.104     0.200
     7.609   106.744     0.200
     7.609   107.244     0.200
     7.666   107.884     0.200
     7.730   108.574     0.200
     7.839   110.384     0.200
     7.858   110.244     0.200
     7.865   110.724     0.200
     8.177   114.944     0.200
     8.241   115.273     0.200
     8.289   115.414     0.200
     0.564    12.199     0.200
     0.823    14.418     0.200
     1.214    20.648     0.200
     1.220    20.676     0.200
     1.230    21.078     0.200
     1.406    23.426     0.200
     1.421    23.637     0.200
     1.812    27.438     0.200
     1.846    29.195     0.200
     1.859    29.355     0.200
     2.239    33.867     0.200
     2.470    38.137     0.200
     2.510    38.676     0.200
     2.511    38.676     0.200
     2.677    40.496     0.200
     2.791    41.898     0.200
     2.852    42.629     0.200
     3.058    43.945     0.200
     3.064    43.949     0.200
     3.224    47.039     0.200
     3.225    49.027     0.200
     3.255    47.977     0.200
     3.329    48.828     0.200
     3.365    49.477     0.200
     3.553    52.906     0.200
     3.603    53.656     0.200
     3.737    56.156     0.200
     3.901    57.137     0.200
     3.945    57.117     0.200
     3.923    57.656     0.200
     4.027    59.766     0.200
     4.071    59.996     0.200
     4.082    60.887     0.200
     4.138    61.707     0.200
     4.205    62.488     0.200
     4.233    62.547     0.200
     4.236    62.516     0.200
     4.630    66.516     0.200
     4.698    67.777     0.200
     4.867    71.238     0.200
     5.202    75.848     0.200
     5.312    76.406     0.200
     5.384    77.426     0.200
     5.395    79.086     0.200
     5.561    79.266     0.200
     5.593    81.539     0.200
     5.705    82.469     0.200
     5.931    84.379     0.200
     6.009    84.766     0.200
     6.097    86.688     0.200
     6.155    86.449     0.200
     6.307    89.277     0.200
     6.324    89.867     0.200
     6.587    93.816     0.200
     6.612    94.047     0.200
     6.687    94.566     0.200
     6.765    95.898     0.200
     6.794    97.488     0.200
     6.843    96.668     0.200
     6.843    97.105     0.200
     6.940    98.066     0.200
     7.017    99.688     0.200
     7.025    99.398     0.200
     7.115   100.457     0.200
     7.182   102.559     0.200
     7.402   105.527     0.200
     7.531   106.797     0.200
     7.610   107.539     0.200
     7.611   109.246     0.200
     7.986   112.855     0.200
     8.129   114.508     0.200
     8.293   116.957     0.200
     8.489   120.727     0.200
     8.837   123.016     0.200
     8.853   124.398     0.200
     9.023   126.059     0.200
     9.037   126.098     0.200
     9.137   128.789     0.200
     9.137   127.027     0.200
     9.153   129.598     0.200
     9.338   131.887     0.200
     9.357   131.047     0.200
     0.289    11.023     0.200
     0.446    12.234     0.200
     0.446    12.422     0.200
     0.480    12.594     0.200
     0.660    14.754     0.200
     0.762    15.145     0.200
     0.788    16.055     0.200
     0.804    15.973     0.200
     0.803    15.805     0.200
     0.863    16.555     0.200
     0.863    16.859     0.200
     1.044    18.703     0.200
     1.246    21.914     0.200
     1.246    21.551     0.200
     1.272    21.633     0.200
     1.343    22.574     0.200
     1.502    24.602     0.200
     1.494    25.395     0.200
     1.496    25.414     0.200
     1.558    25.305     0.200
     1.590    26.082     0.200
     1.678    28.242     0.200
     1.678    28.305     0.200
     1.680    28.305     0.200
     1.988    32.254     0.200
     2.017    31.781     0.200
     2.040    32.414     0.200
     2.040    32.207     0.200
     2.082    32.074     0.200
     2.082    31.910     0.200
     2.149    34.203     0.200
     2.258    34.883     0.200
     2.309    36.484     0.200
     2.364    36.582     0.200
     2.365    37.082     0.200
     2.439    37.305     0.200
     2.456    38.883     0.200
     2.456    38.781     0.200
     2.501    38.383     0.200
     2.510    39.414     0.200
     2.516    39.152     0.200
     2.783    42.961     0.200
     2.807    42.723     0.200
     2.827    43.773     0.200
     2.834    43.684     0.200
     2.852    42.953     0.200
     2.880    44.172     0.200
     2.888    43.602     0.200
     2.887    44.461     0.200
     2.937    45.223     0.200
     2.960    45.484     0.200
     2.975    45.352     0.200
     3.277    48.883     0.200
     3.321    49.832     0.200
     3.565    53.043     0.200
     3.586    53.645     0.200
     3.614    54.902     0.200
     3.614    54.492     0.200
     3.621    55.133     0.200
     3.626    54.371     0.200
     3.733    56.023     0.200
     3.960    58.863     0.200
     4.005    59.023     0.200
     4.032    58.664     0.200
     4.070    59.961     0.200
     4.132    61.762     0.200
     4.132    61.609     0.200
     4.157    61.461     0.200
     4.157    61.145     0.200
     4.172    61.555     0.200
     4.172    61.664     0.200
     4.343    63.832     0.200
     4.408    63.711     0.200
     4.486    64.871     0.200
     4.525    66.223     0.200
     4.525    66.559     0.200
     4.577    67.203     0.200
     4.642    67.441     0.200
     4.665    68.664     0.200
     4.703    67.504     0.200
     4.708    67.504     0.200
     4.730    68.922     0.200
     4.730    68.266     0.200
     4.816    69.145     0.200
     4.932    72.012     0.200
     4.985    71.055     0.200
     4.985    71.680     0.200
     4.990    71.871     0.200
     5.105    73.984     0.200
     5.103    74.352     0.200
     5.128    74.145     0.200
     5.144    74.621     0.200
     5.144    74.410     0.200
     5.171    72.781     0.200
     5.227    75.871     0.200
     5.227    75.496     0.200
     5.333    77.062     0.200
     5.333    77.172     0.200
     5.392    77.133     0.200
     5.392    76.977     0.200
     5.497    79.012     0.200
     5.536    80.012     0.200
     5.536    79.801     0.200
     5.663    81.383     0.200
     5.746    82.664     0.200
     5.785    83.082     0.200
     5.785    82.918     0.200
     5.803    83.234     0.200
     5.810    83.031     0.200
     5.813    82.953     0.200
     5.863    83.582     0.200
     5.883    84.055     0.200
     5.883    84.188     0.200
     5.911    84.383     0.200
     5.988    85.422     0.200
     6.031    86.422     0.200
     6.043    86.613     0.200
     6.043    86.512     0.200
     6.082    86.184     0.200
     6.082    86.859     0.200
     6.085    87.223     0.200
     6.085    87.422     0.200
     6.093    87.012     0.200
     6.134    88.023     0.200
     6.173    88.656     0.200
     6.268    88.973     0.200
     6.355    90.895     0.200
     6.386    91.160     0.200
     6.395    91.023     0.200
     6.403    91.293     0.200
     6.403    90.992     0.200
     6.414    91.594     0.200
     6.497    92.172     0.200
     6.541    92.371     0.200
     6.541    92.555     0.200
     6.564    92.453     0.200
     6.564    93.781     0.200
     6.616    94.164     0.200
     6.645    94.762     0.200
     6.645    94.355     0.200
     6.641    93.602     0.200
     6.654    94.305     0.200
     6.674    94.574     0.200
     6.687    94.773     0.200
     6.844    97.332     0.200
     6.911    98.172     0.200
     6.911    98.770     0.200
     6.954    98.371     0.200
     6.975    98.984     0.200
     6.988    99.594     0.200
     7.046   100.328     0.200
     7.060   100.504     0.200
     7.071   100.562     0.200
     7.120   100.602     0.200
     7.190   102.012     0.200
     7.289   103.531     0.200
     7.308   102.832     0.200
     7.393   103.895     0.200
     7.423   105.395     0.200
     7.423   105.281     0.200
     7.438   105.523     0.200
     7.458   106.434     0.200
     7.463   104.824     0.200
     7.463   105.000     0.200
     7.477   105.613     0.200
     7.499   106.262     0.200
     7.554   106.770     0.200
     7.557   107.152     0.200
     7.598   107.422     0.200
     7.606   106.273     0.200
     7.606   107.812     0.200
     7.657   108.645     0.200
     7.657   108.879     0.200
     7.668   108.273     0.200
     7.683   109.734     0.200
     7.697   108.672     0.200
     7.697   108.309     0.200
     7.770   109.395     0.200
     7.794   109.691     0.200
     7.794   109.879     0.200
     7.796   109.574     0.200
     7.796   109.848     0.200
     7.796   109.312     0.200
     7.840   111.402     0.200
     7.857   110.734     0.200
     7.857   110.703     0.200
     7.891   112.102     0.200
     7.891   111.996     0.200
     7.884   111.250     0.200
     7.917   111.512     0.200
     7.917   110.781     0.200
     7.917   110.062     0.200
     8.037   114.152     0.200
     8.037   113.996     0.200
     8.092   114.352     0.200
     8.096   113.953     0.200
     8.142   114.953     0.200
     8.164   114.793     0.200
     8.164   115.023     0.200
     8.176   114.895     0.200
     8.176   115.555     0.200
     8.232   115.422     0.200
     8.232   115.785     0.200
     8.225   115.871     0.200
     8.225   115.629     0.200
     8.234   116.312     0.200
     8.270   116.723     0.200
     8.270   115.895     0.200
     8.289   117.094     0.200
     8.289   117.223     0.200
     8.378   117.031     0.200
     8.378   117.457     0.200
     8.595   120.645     0.200
     8.595   121.121     0.200
     8.653   121.234     0.200
     8.653   121.020     0.200
     8.717   122.883     0.200
     8.717   122.648     0.200
     8.720   123.191     0.200
     8.720   122.480     0.200
     8.755   123.285     0.200
     8.860   123.371     0.200
     8.860   123.891     0.200
     8.914   126.516     0.200
     8.947   125.332     0.200
     9.164   128.242     0.200
     9.164   128.344     0.200
     9.305   130.973     0.200
     9.305   130.562     0.200
     9.357   131.492     0.200
     9.357   131.148     0.200
     9.425   131.703     0.200
     9.430   131.996     0.200
     9.495   133.195     0.200
     9.508   131.734     0.200
     9.508   131.344     0.200
     9.645   134.895     0.200
     9.668   135.074     0.200
     9.734   136.371     0.200
     9.734   136.520     0.200
     9.767   136.805     0.200
     9.767   136.375     0.200
     9.809   136.812     0.200
     9.810   136.312     0.200
     9.963   139.273     0.200
    10.007   139.594     0.200
    10.203   142.523     0.200
    10.203   142.211     0.200
    10.443   145.410     0.200
    10.445   144.918     0.200
    10.628   146.852     0.200
    10.628   146.152     0.200
    10.650   147.711     0.200
    10.650   147.258     0.200
    10.670   147.883     0.200
    10.684   147.352     0.200
    10.713   148.781     0.200
    10.844   150.148     0.200
    11.113   153.582     0.200
    14.145   197.906     0.200
     0.265    11.906     0.200
     0.289    12.016     0.200
     0.449    13.062     0.200
     0.618    14.336     0.200
     1.005    18.695     0.200
     0.992    18.992     0.200
     1.153    20.344     0.200
     1.193    20.938     0.200
     1.198    21.367     0.200
     1.330    23.625     0.200
     1.396    23.695     0.200
     1.596    25.961     0.200
     1.615    26.062     0.200
     1.932    30.695     0.200
     2.057    32.242     0.200
     2.041    32.602     0.200
     2.098    33.695     0.200
     2.163    33.375     0.200
     2.204    34.633     0.200
     2.248    35.812     0.200
     2.284    35.242     0.200
     2.302    36.102     0.200
     2.515    39.312     0.200
     2.553    39.781     0.200
     2.559    39.938     0.200
     2.565    39.992     0.200
     2.588    39.344     0.200
     2.617    40.727     0.200
     2.633    40.195     0.200
     2.641    40.023     0.200
     2.707    40.570     0.200
     2.691    41.672     0.200
     2.703    41.766     0.200
     3.015    45.352     0.200
     3.136    47.266     0.200
     3.224    48.945     0.200
     3.316    50.414     0.200
     3.330    49.781     0.200
     3.358    50.656     0.200
     3.374    49.523     0.200
     3.691    55.422     0.200
     3.798    55.883     0.200
     3.858    57.992     0.200
     3.913    57.562     0.200
     4.073    60.133     0.200
     4.208    61.695     0.200
     4.265    61.242     0.200
     4.228    61.453     0.200
     4.265    61.602     0.200
     4.564    65.867     0.200
     4.579    66.664     0.200
     4.688    68.266     0.200
     4.684    67.602     0.200
     4.776    67.883     0.200
     4.803    69.242     0.200
     4.838    70.336     0.200
     4.865    71.781     0.200
     4.901    70.000     0.200
     4.954    73.406     0.200
     4.971    70.414     0.200
     5.075    72.797     0.200
     5.206    74.164     0.200
     5.263    76.297     0.200
     5.262    75.305     0.200
     5.550    78.977     0.200
     5.587    80.422     0.200
     5.631    81.438     0.200
     5.684    81.102     0.200
     5.819    83.453     0.200
     5.891    83.461     0.200
     5.930    84.352     0.200
     5.978    85.875     0.200
     6.033    87.016     0.200
     6.083    88.070     0.200
     6.101    86.586     0.200
     6.150    86.805     0.200
     6.186    88.211     0.200
     6.253    88.867     0.200
     6.267    89.500     0.200
     6.331    89.664     0.200
     6.442    91.273     0.200
     6.460    92.094     0.200
     6.478    91.781     0.200
     6.508    92.312     0.200
     6.522    92.500     0.200
     6.670    95.367     0.200
     6.682    95.203     0.200
     6.808    97.094     0.200
     6.894    98.297     0.200
     6.935    98.820     0.200
     7.033   100.273     0.200
     7.126    99.188     0.200
     7.189   101.812     0.200
     7.340   102.211     0.200
     7.341   104.586     0.200
     7.384   105.016     0.200
     7.410   104.742     0.200
     7.459   105.523     0.200
     7.500   106.344     0.200
     7.527   105.797     0.200
     7.617   107.773     0.200
     7.653   107.938     0.200
     7.653   107.516     0.200
     7.675   108.836     0.200
     7.712   110.195     0.200
     7.847   110.023     0.200
     7.873   111.773     0.200
     7.879   111.953     0.200
     7.907   111.516     0.200
     8.003   112.727     0.200
     8.044   114.297     0.200
     8.049   113.656     0.200
     8.067   113.812     0.200
     8.067   113.766     0.200
     8.095   113.750     0.200
     8.105   113.461     0.200
     8.346   117.141     0.200
     8.383   116.344     0.200
     9.050   126.750     0.200
     9.175   128.625     0.200
     9.371   130.906     0.200
     0.423    11.297     0.200
     0.490    11.949     0.200
     0.592    13.078     0.200
     0.603    13.418     0.200
     0.612    13.637     0.200
     0.614    13.418     0.200
     0.626    13.379     0.200
     0.723    15.238     0.200
     0.833    16.309     0.200
     0.877    16.270     0.200
     0.921    17.020     0.200
     0.911    16.977     0.200
     0.996    17.977     0.200
     1.053    18.859     0.200
     1.233    20.887     0.200
     1.233    20.707     0.200
     1.253    21.617     0.200
     1.437    23.348     0.200
     1.418    24.098     0.200
     1.639    26.000     0.200
     1.698    28.047     0.200
     1.719    28.078     0.200
     1.738    27.750     0.200
     2.043    30.957     0.200
     2.007    32.348     0.200
     2.006    32.117     0.200
     2.154    33.520     0.200
     2.115    33.020     0.200
     2.115    32.848     0.200
     2.208    34.027     0.200
     2.248    34.688     0.200
     2.334    36.320     0.200
     2.387    37.227     0.200
     2.405    36.527     0.200
     2.423    37.418     0.200
     2.432    37.488     0.200
     2.467    38.070     0.200
     2.577    38.738     0.200
     2.521    39.547     0.200
     2.600    39.117     0.200
     2.762    41.309     0.200
     2.800    42.137     0.200
     2.808    43.629     0.200
     2.846    43.988     0.200
     2.852    44.520     0.200
     2.862    44.129     0.200
     2.966    44.559     0.200
     2.919    44.770     0.200
     2.966    45.688     0.200
     2.986    45.797     0.200
     2.996    45.137     0.200
     2.996    44.949     0.200
     3.050    45.699     0.200
     3.050    46.297     0.200
     3.376    50.137     0.200
     3.474    51.598     0.200
     3.528    51.410     0.200
     3.534    52.258     0.200
     3.648    54.367     0.200
     3.682    55.129     0.200
     3.726    55.859     0.200
     3.983    59.289     0.200
     4.072    57.949     0.200
     4.080    58.820     0.200
     4.082    59.070     0.200
     4.082    59.199     0.200
     4.135    60.367     0.200
     4.145    60.727     0.200
     4.184    61.828     0.200
     4.184    62.441     0.200
     4.327    62.770     0.200
     4.426    64.840     0.200
     4.426    65.047     0.200
     4.628    67.199     0.200
     4.577    66.824     0.200
     4.604    66.547     0.200
     4.733    69.270     0.200
     4.785    69.250     0.200
     4.785    68.746     0.200
     4.913    70.520     0.200
     4.915    70.070     0.200
     4.926    69.789     0.200
     5.121    73.387     0.200
     5.202    75.398     0.200
     5.225    76.309     0.200
     5.226    74.180     0.200
     5.315    75.570     0.200
     5.463    78.129     0.200
     5.608    80.770     0.200
     5.608    80.871     0.200
     5.686    81.219     0.200
     5.686    81.410     0.200
     5.726    81.508     0.200
     5.749    81.910     0.200
     5.794    83.910     0.200
     5.812    83.199     0.200
     5.882    84.027     0.200
     5.897    84.090     0.200
     5.897    84.000     0.200
     5.999    85.559     0.200
     6.008    85.332     0.200
     6.047    86.938     0.200
     6.047    86.547     0.200
     6.066    87.488     0.200
     6.177    87.680     0.200
     6.307    90.160     0.200
     6.334    90.090     0.200
     6.394    89.777     0.200
     6.405    90.879     0.200
     6.429    91.738     0.200
     6.429    91.566     0.200
     6.568    93.918     0.200
     6.572    93.828     0.200
     6.581    93.668     0.200
     6.593    93.500     0.200
     6.709    95.129     0.200
     6.749    95.938     0.200
     6.883    97.898     0.200
     6.878    97.148     0.200
     6.883    97.797     0.200
     6.945    99.238     0.200
     7.034   100.039     0.200
     7.092   101.137     0.200
     7.197   102.359     0.200
     7.401   105.047     0.200
     7.408   103.000     0.200
     7.469   106.207     0.200
     7.508   105.008     0.200
     7.534   106.367     0.200
     7.577   107.520     0.200
     7.603   107.109     0.200
     7.622   107.027     0.200
     7.637   106.988     0.200
     7.642   107.688     0.200
     7.797   110.020     0.200
     7.751   110.227     0.200
     7.803   110.617     0.200
     7.819   109.590     0.200
     7.926   110.918     0.200
     7.926   112.469     0.200
     7.942   112.570     0.200
     7.956   112.969     0.200
     7.956   112.285     0.200
     8.033   113.570     0.200
     8.070   115.410     0.200
     8.111   114.180     0.200
     8.161   114.430     0.200
     8.221   116.020     0.200
     8.239   116.539     0.200
     8.249   116.039     0.200
     8.249   116.930     0.200
     8.418   117.590     0.200
     8.578   121.848     0.200
     8.578   120.508     0.200
     8.868   124.879     0.200
     9.234   129.809     0.200
     9.295   131.438     0.200
     9.689   137.059     0.200
     9.826   138.629     0.200
    10.704   148.227     0.200
    11.487   160.910     0.200
    14.129   196.848     0.200
    14.277   197.258     0.200
     1.315    22.977     0.200
     1.344    23.969     0.200
     1.492    23.953     0.200
     1.438    24.805     0.200
     1.470    24.805     0.200
     1.456    24.766     0.200
     1.466    25.719     0.200
     1.483    26.719     0.200
     1.483    26.062     0.200
     1.493    26.227     0.200
     1.565    26.984     0.200
     1.631    27.984     0.200
     1.631    27.797     0.200
     1.890    30.992     0.200
     1.847    30.898     0.200
     1.870    31.273     0.200
     1.925    31.234     0.200
     1.914    31.633     0.200
     1.888    31.648     0.200
     1.887    31.008     0.200
     2.046    33.023     0.200
     2.213    35.219     0.200
     2.274    35.555     0.200
     2.252    36.117     0.200
     2.253    35.578     0.200
     2.331    36.352     0.200
     2.290    36.273     0.200
     2.366    37.203     0.200
     2.374    37.578     0.200
     2.382    37.836     0.200
     2.398    37.586     0.200
     2.456    39.586     0.200
     2.488    39.133     0.200
     2.736    42.414     0.200
     2.760    42.969     0.200
     2.902    44.398     0.200
     2.885    45.227     0.200
     2.987    45.406     0.200
     2.920    45.234     0.200
     2.945    45.414     0.200
     2.993    46.336     0.200
     3.121    48.352     0.200
     3.263    49.367     0.200
     3.375    49.984     0.200
     3.284    49.773     0.200
     3.439    51.422     0.200
     3.498    51.508     0.200
     3.492    52.578     0.200
     3.672    55.453     0.200
     3.686    55.344     0.200
     3.821    57.242     0.200
     3.940    59.148     0.200
     3.888    58.602     0.200
     4.072    60.898     0.200
     4.213    62.688     0.200
     4.356    64.086     0.200
     4.232    63.297     0.200
     4.607    68.336     0.200
     4.750    69.453     0.200
     4.944    71.734     0.200
     5.100    74.773     0.200
     5.115    74.953     0.200
     5.164    76.062     0.200
     5.355    78.234     0.200
     5.358    78.297     0.200
     6.471    93.508     0.200
     6.820    98.742     0.200
     6.828    98.039     0.200
     6.940    99.469     0.200
     0.580    13.363     0.200
     0.624    13.695     0.200
     0.690    14.004     0.200
     0.758    14.953     0.200
     0.758    15.254     0.200
     0.851    16.215     0.200
     0.867    16.285     0.200
     0.930    17.512     0.200
     1.009    18.559     0.200
     1.011    18.562     0.200
     1.047    18.605     0.200
     1.372    23.883     0.200
     1.365    23.035     0.200
     1.377    24.004     0.200
     1.378    24.055     0.200
     1.393    24.023     0.200
     1.397    24.184     0.200
     1.442    23.934     0.200
     1.464    24.012     0.200
     1.539    24.934     0.200
     1.581    25.652     0.200
     1.684    27.965     0.200
     1.684    27.992     0.200
     1.767    28.465     0.200
     1.960    30.832     0.200
     2.017    32.152     0.200
     2.035    32.875     0.200
     2.065    32.883     0.200
     2.068    32.672     0.200
     2.182    34.984     0.200
     2.197    34.312     0.200
     2.364    36.055     0.200
     2.359    36.512     0.200
     2.384    36.082     0.200
     2.399    36.672     0.200
     2.409    36.883     0.200
     2.485    38.703     0.200
     2.545    39.605     0.200
     2.607    40.625     0.200
     2.650    41.254     0.200
     2.664    41.402     0.200
     2.682    40.785     0.200
     2.822    43.152     0.200
     2.856    43.285     0.200
     2.983    44.734     0.200
     3.107    48.383     0.200
     3.124    45.672     0.200
     3.145    46.574     0.200
     3.205    47.984     0.200
     3.286    48.684     0.200
     3.314    49.906     0.200
     3.315    49.902     0.200
     3.422    51.895     0.200
     3.500    52.535     0.200
     3.654    54.723     0.200
     3.752    55.285     0.200
     3.819    56.555     0.200
     3.902    58.305     0.200
     3.902    58.559     0.200
     3.909    57.832     0.200
     3.920    56.973     0.200
     4.039    58.395     0.200
     4.158    60.902     0.200
     4.202    60.754     0.200
     4.207    60.934     0.200
     4.207    62.012     0.200
     4.214    62.082     0.200
     4.332    62.445     0.200
     4.395    63.234     0.200
     4.480    65.984     0.200
     4.483    63.883     0.200
     4.488    65.484     0.200
     4.506    65.105     0.200
     4.522    64.273     0.200
     4.536    65.473     0.200
     4.697    66.434     0.200
     4.736    68.223     0.200
     4.736    68.082     0.200
     4.769    69.242     0.200
     4.821    68.613     0.200
     4.908    70.184     0.200
     4.912    70.812     0.200
     4.975    73.875     0.200
     5.016    72.883     0.200
     5.038    73.523     0.200
     5.070    73.043     0.200
     5.070    72.930     0.200
     5.193    74.293     0.200
     5.286    76.254     0.200
     5.320    76.332     0.200
     5.346    76.613     0.200
     5.346    76.383     0.200
     5.362    77.684     0.200
     5.374    77.172     0.200
     5.451    78.504     0.200
     5.493    78.883     0.200
     5.500    79.414     0.200
     5.500    79.812     0.200
     5.517    79.113     0.200
     5.519    78.812     0.200
     5.596    80.082     0.200
     5.601    79.672     0.200
     5.635    80.863     0.200
     5.651    81.234     0.200
     5.741    82.234     0.200
     5.750    82.875     0.200
     5.773    82.652     0.200
     5.917    84.832     0.200
     5.929    84.254     0.200
     5.929    84.055     0.200
     5.956    85.004     0.200
     6.002    85.414     0.200
     6.020    85.945     0.200
     6.020    85.781     0.200
     6.117    87.422     0.200
     6.166    87.703     0.200
     6.185    88.742     0.200
     6.185    89.109     0.200
     6.190    88.422     0.200
     6.207    89.242     0.200
     6.234    89.273     0.200
     6.272    89.562     0.200
     6.304    89.773     0.200
     6.346    90.754     0.200
     6.473    93.012     0.200
     6.479    92.523     0.200
     6.494    91.895     0.200
     6.494    92.793     0.200
     6.546    93.293     0.200
     6.546    93.812     0.200
     6.562    93.754     0.200
     6.633    94.055     0.200
     6.691    95.742     0.200
     6.926    98.945     0.200
     7.000    99.805     0.200
     7.000    99.973     0.200
     7.003    98.812     0.200
     7.034   101.105     0.200
     7.057   100.082     0.200
     7.061   100.672     0.200
     7.064   100.555     0.200
     7.063    99.695     0.200
     7.104   101.523     0.200
     7.173   101.895     0.200
     7.244   103.684     0.200
     7.245   103.145     0.200
     7.253   103.742     0.200
     7.276   102.344     0.200
     7.355   105.004     0.200
     7.355   104.438     0.200
     7.469   105.203     0.200
     7.472   105.203     0.200
     7.481   105.105     0.200
     7.540   107.383     0.200
     7.573   105.664     0.200
     7.573   105.371     0.200
     7.573   107.445     0.200
     7.588   107.953     0.200
     7.640   107.883     0.200
     7.690   109.262     0.200
     7.723   108.773     0.200
     7.750   110.625     0.200
     7.792   109.473     0.200
     7.819   110.422     0.200
     7.837   110.973     0.200
     7.837   110.805     0.200
     8.000   114.043     0.200
     8.106   113.934     0.200
     8.196   115.574     0.200
     8.196   115.004     0.200
     8.218   116.684     0.200
     8.329   117.832     0.200
     8.350   118.652     0.200
     8.421   120.465     0.200
     8.512   119.934     0.200
     8.558   120.652     0.200
     8.561   122.484     0.200
     8.801   122.523     0.200
     8.834   125.512     0.200
     8.877   125.855     0.200
     8.920   126.562     0.200
     8.993   127.184     0.200
     9.126   128.945     0.200
     9.289   131.324     0.200
     9.506   133.645     0.200
     9.646   135.062     0.200
     9.778   138.484     0.200
     9.791   137.973     0.200
    10.080   142.023     0.200
    10.362   145.152     0.200
    11.065   154.902     0.200
    11.082   155.754     0.200
    12.591   175.535     0.200
    12.591   176.215     0.200
     0.822    16.012     0.200
     1.424    24.940     0.200
     1.424    24.441     0.200
     1.424    25.094     0.200
     1.979    32.082     0.200
     2.111    34.071     0.200
     2.135    34.002     0.200
     2.148    34.682     0.200
     2.164    35.092     0.200
     2.181    35.122     0.200
     2.255    36.794     0.200
     2.256    36.872     0.200
     2.283    37.281     0.200
     2.363    37.932     0.200
     2.451    39.241     0.200
     2.459    38.861     0.200
     2.543    40.861     0.200
     2.543    41.153     0.200
     2.660    40.692     0.200
     2.900    42.821     0.200
     2.900    43.010     0.200
     2.941    44.792     0.200
     2.941    45.633     0.200
     2.962    47.441     0.200
     2.970    47.292     0.200
     3.185    49.012     0.200
     3.258    50.651     0.200
     3.258    51.281     0.200
     3.290    50.092     0.200
     3.302    50.872     0.200
     3.368    52.142     0.200
     3.368    52.562     0.200
     3.534    52.589     0.200
     3.533    52.571     0.200
     3.590    54.712     0.200
     3.588    54.392     0.200
     3.575    54.592     0.200
     3.625    55.842     0.200
     3.677    55.062     0.200
     3.701    57.392     0.200
     3.947    56.667     0.200
     3.952    56.762     0.200
     3.959    59.082     0.200
     4.034    61.271     0.200
     4.122    61.071     0.200
     4.122    60.946     0.200
     4.101    62.441     0.200
     4.173    63.642     0.200
     4.229    61.342     0.200
     4.229    61.502     0.200
     4.205    63.802     0.200
     4.210    63.432     0.200
     4.208    62.392     0.200
     4.208    62.029     0.200
     4.473    67.042     0.200
     4.473    67.251     0.200
     4.480    66.185     0.200
     4.513    67.252     0.200
     4.513    67.377     0.200
     4.830    71.441     0.200
     4.839    71.870     0.200
     4.840    71.882     0.200
     4.840    71.507     0.200
     4.867    72.401     0.200
     4.908    73.832     0.200
     5.019    74.021     0.200
     5.019    74.122     0.200
     5.034    74.202     0.200
     5.034    73.993     0.200
     5.141    75.111     0.200
     5.233    76.136     0.200
     5.496    81.142     0.200
     5.496    81.422     0.200
     5.506    79.672     0.200
     5.551    81.832     0.200
     5.551    82.051     0.200
     5.593    81.392     0.200
     5.596    82.021     0.200
     5.600    80.491     0.200
     5.613    81.545     0.200
     5.660    83.252     0.200
     5.707    83.012     0.200
     5.707    83.135     0.200
     5.818    84.712     0.200
     5.840    85.521     0.200
     5.840    84.890     0.200
     5.857    86.412     0.200
     5.857    86.258     0.200
     5.972    87.252     0.200
     5.972    86.699     0.200
     6.004    87.042     0.200
     6.104    89.752     0.200
     6.096    88.703     0.200
     6.193    88.122     0.200
     6.194    88.071     0.200
     6.138    89.151     0.200
     6.189    90.582     0.200
     6.200    89.762     0.200
     6.228    90.812     0.200
     6.342    91.802     0.200
     6.342    92.057     0.200
     6.397    92.392     0.200
     6.405    92.712     0.200
     6.494    94.092     0.200
     6.612    95.401     0.200
     6.647    96.382     0.200
     6.677    97.622     0.200
     6.699    97.252     0.200
     6.699    97.614     0.200
     6.758    98.321     0.200
     6.842    97.481     0.200
     6.816    99.231     0.200
     6.850    98.452     0.200
     6.850    99.233     0.200
     6.863    99.230     0.200
     6.909    99.741     0.200
     6.958    99.602     0.200
     6.989   101.132     0.200
     6.989   101.505     0.200
     7.009   100.802     0.200
     7.036   102.051     0.200
     7.077   102.031     0.200
     7.125   102.812     0.200
     7.220   104.632     0.200
     7.212   104.172     0.200
     7.260   105.082     0.200
     7.260   104.589     0.200
     7.285   105.232     0.200
     7.310   105.302     0.200
     7.310   105.423     0.200
     7.353   105.861     0.200
     7.489   106.191     0.200
     7.539   109.422     0.200
     7.655   110.415     0.200
     7.657   110.552     0.200
     7.685   110.336     0.200
     7.756   110.991     0.200
     7.767   111.842     0.200
     7.767   111.565     0.200
     7.800   111.781     0.200
     7.800   112.218     0.200
     7.813   112.792     0.200
     7.813   112.672     0.200
     7.949   114.720     0.200
     8.040   112.731     0.200
     8.040   114.219     0.200
     8.023   115.632     0.200
     8.023   115.740     0.200
     8.082   115.842     0.200
     8.082   116.479     0.200
     8.293   115.962     0.200
     8.292   119.366     0.200
     8.294   119.885     0.200
     8.303   119.624     0.200
     8.457   122.249     0.200
     8.464   120.292     0.200
     8.477   121.241     0.200
     8.480   121.875     0.200
     8.562   123.132     0.200
     8.562   122.435     0.200
     8.603   122.622     0.200
     8.623   123.632     0.200
     8.623   123.355     0.200
     8.684   123.952     0.200
     8.704   124.636     0.200
     8.740   124.762     0.200
     8.740   124.963     0.200
     8.798   125.325     0.200
     8.827   126.206     0.200
     8.821   126.361     0.200
     8.821   125.448     0.200
     8.867   127.092     0.200
     8.890   127.160     0.200
     8.892   125.912     0.200
     8.892   127.072     0.200
     8.921   126.602     0.200
     8.947   127.122     0.200
     8.947   127.422     0.200
     8.947   127.682     0.200
     8.971   126.962     0.200
     8.971   127.771     0.200
     8.964   127.383     0.200
     9.013   129.638     0.200
     9.089   129.212     0.200
     9.089   130.273     0.200
     9.182   131.229     0.200
     9.288   132.263     0.200
     9.331   133.660     0.200
     9.404   133.925     0.200
     9.428   134.678     0.200
     9.462   134.944     0.200
     9.564   136.253     0.200
     9.617   136.872     0.200
     9.617   136.342     0.200
     9.617   136.922     0.200
     9.633   137.412     0.200
     9.738   138.521     0.200
     9.738   138.775     0.200
     9.805   138.929     0.200
     9.868   139.852     0.200
     9.868   140.227     0.200
     9.938   141.654     0.200
     9.983   144.422     0.200
     9.983   141.853     0.200
    10.149   144.363     0.200
    10.172   144.504     0.200
    10.257   146.465     0.200
    10.282   146.323     0.200
    10.328   146.973     0.200
    10.367   146.517     0.200
    10.453   148.372     0.200
    10.453   147.547     0.200
    10.473   147.999     0.200
    10.503   148.686     0.200
    10.586   150.384     0.200
    10.681   151.271     0.200
    10.681   151.560     0.200
    10.781   152.957     0.200
    10.816   153.450     0.200
    10.859   153.262     0.200
    10.873   154.842     0.200
    10.954   154.941     0.200
    10.954   154.623     0.200
    11.155   157.938     0.200
    11.172   156.357     0.200
    11.210   158.282     0.200
    11.317   160.489     0.200
    11.426   161.221     0.200
    11.469   161.519     0.200
    11.764   165.339     0.200
    11.769   167.852     0.200
    11.770   165.875     0.200
    11.792   166.226     0.200
    11.814   166.269     0.200
    11.913   168.604     0.200
    12.081   170.456     0.200
    12.185   171.182     0.200
    12.270   173.036     0.200
    12.394   174.607     0.200
    12.641   180.372     0.200
    12.661   178.292     0.200
    12.719   180.232     0.200
    12.948   181.853     0.200
    12.962   182.376     0.200
    13.322   188.234     0.200
    13.516   189.770     0.200
    13.924   196.894     0.200
    14.279   200.664     0.200
    14.927   210.122     0.200
    14.927   208.396     0.200
    16.324   227.158     0.200
     1.427    24.474     0.200
     1.427    24.660     0.200
     1.973    31.800     0.200
     2.101    33.620     0.200
     2.125    33.529     0.200
     2.142    34.239     0.200
     2.213    36.170     0.200
     2.257    36.479     0.200
     2.258    36.380     0.200
     2.315    36.529     0.200
     2.280    36.779     0.200
     2.352    36.989     0.200
     2.452    38.370     0.200
     2.447    38.620     0.200
     2.542    40.770     0.200
     2.648    41.577     0.200
     2.887    42.479     0.200
     2.934    44.330     0.200
     2.961    46.949     0.200
     2.969    47.000     0.200
     3.181    48.550     0.200
     3.181    48.444     0.200
     3.258    50.779     0.200
     3.284    49.590     0.200
     3.284    49.848     0.200
     3.306    50.739     0.200
     3.371    52.189     0.200
     3.371    51.927     0.200
     3.522    52.416     0.200
     3.520    52.359     0.200
     3.592    54.029     0.200
     3.590    54.760     0.200
     3.579    54.160     0.200
     3.579    53.990     0.200
     3.616    54.729     0.200
     3.616    54.483     0.200
     3.625    55.330     0.200
     3.669    54.489     0.200
     3.702    56.899     0.200
     3.702    56.785     0.200
     3.936    55.947     0.200
     3.940    56.340     0.200
     3.953    58.850     0.200
     3.953    58.623     0.200
     4.034    60.850     0.200
     4.217    60.300     0.200
     4.217    60.406     0.200
     4.078    61.870     0.200
     4.114    60.600     0.200
     4.114    60.735     0.200
     4.102    61.970     0.200
     4.173    63.050     0.200
     4.213    61.640     0.200
     4.213    61.798     0.200
     4.206    63.350     0.200
     4.210    63.250     0.200
     4.471    67.010     0.200
     4.471    66.869     0.200
     4.485    66.180     0.200
     4.509    67.100     0.200
     4.510    68.949     0.200
     4.759    68.420     0.200
     4.830    71.810     0.200
     4.831    71.720     0.200
     4.840    71.586     0.200
     4.841    71.830     0.200
     4.841    71.977     0.200
     4.864    71.910     0.200
     4.909    73.000     0.200
     5.012    73.600     0.200
     5.012    73.386     0.200
     5.039    73.550     0.200
     5.147    74.580     0.200
     5.236    76.680     0.200
     5.236    76.438     0.200
     5.496    80.859     0.200
     5.496    80.692     0.200
     5.513    78.960     0.200
     5.513    79.338     0.200
     5.549    80.810     0.200
     5.549    81.419     0.200
     5.608    80.080     0.200
     5.598    80.790     0.200
     5.598    81.138     0.200
     5.599    81.788     0.200
     5.618    81.189     0.200
     5.618    80.912     0.200
     5.662    82.779     0.200
     5.715    82.420     0.200
     5.715    82.525     0.200
     5.849    85.020     0.200
     5.849    84.710     0.200
     5.823    84.160     0.200
     5.855    86.010     0.200
     5.855    85.710     0.200
     5.977    86.340     0.200
     5.977    86.502     0.200
     6.013    86.620     0.200
     6.180    87.670     0.200
     6.114    88.460     0.200
     6.102    88.430     0.200
     6.103    89.010     0.200
     6.147    88.540     0.200
     6.199    89.550     0.200
     6.209    89.439     0.200
     6.234    89.989     0.200
     6.234    90.164     0.200
     6.349    91.390     0.200
     6.349    91.646     0.200
     6.407    91.779     0.200
     6.414    92.180     0.200
     6.414    92.058     0.200
     6.504    93.569     0.200
     6.621    94.920     0.200
     6.657    95.640     0.200
     6.674    97.130     0.200
     6.830    96.979     0.200
     6.697    96.770     0.200
     6.697    96.919     0.200
     6.764    97.870     0.200
     6.764    97.533     0.200
     6.791    97.340     0.200
     6.795    97.817     0.200
     6.820    98.350     0.200
     6.858    98.239     0.200
     6.858    98.751     0.200
     6.867    99.040     0.200
     6.919    99.340     0.200
     6.968   100.120     0.200
     6.989   100.680     0.200
     6.989   101.114     0.200
     7.017   100.680     0.200
     7.046   101.149     0.200
     7.046   101.496     0.200
     7.087   101.479     0.200
     7.135   102.319     0.200
     7.222   103.640     0.200
     7.222   104.260     0.200
     7.268   104.149     0.200
     7.268   104.357     0.200
     7.291   105.569     0.200
     7.291   105.880     0.200
     7.315   104.760     0.200
     7.315   105.178     0.200
     7.476   105.620     0.200
     7.362   105.489     0.200
     7.359   105.620     0.200
     7.663   109.640     0.200
     7.663   110.344     0.200
     7.658   110.090     0.200
     7.658   110.317     0.200
     7.695   110.123     0.200
     7.766   111.000     0.200
     7.777   111.578     0.200
     7.802   111.479     0.200
     7.802   111.358     0.200
     7.812   111.899     0.200
     7.812   112.038     0.200
     8.028   112.000     0.200
     7.957   114.546     0.200
     8.015   114.689     0.200
     8.111   114.060     0.200
     8.034   115.120     0.200
     8.034   114.980     0.200
     8.013   115.560     0.200
     8.092   115.590     0.200
     8.092   115.168     0.200
     8.311   119.090     0.200
     8.311   119.251     0.200
     8.297   119.435     0.200
     8.345   119.680     0.200
     8.462   121.280     0.200
     8.467   119.410     0.200
     8.467   119.684     0.200
     8.480   119.910     0.200
     8.559   122.840     0.200
     8.559   122.485     0.200
     8.634   123.460     0.200
     8.634   123.699     0.200
     8.607   123.040     0.200
     8.688   122.640     0.200
     8.741   124.520     0.200
     8.832   126.250     0.200
     8.832   125.132     0.200
     8.805   126.755     0.200
     8.828   126.006     0.200
     8.872   126.906     0.200
     8.893   126.257     0.200
     8.895   125.960     0.200
     8.895   126.370     0.200
     8.924   126.160     0.200
     8.951   126.840     0.200
     8.951   126.779     0.200
     8.973   127.330     0.200
     8.973   127.063     0.200
     9.022   129.608     0.200
     9.094   128.620     0.200
     9.094   129.607     0.200
     9.186   130.560     0.200
     9.186   130.295     0.200
     9.288   131.319     0.200
     9.288   131.467     0.200
     9.342   132.123     0.200
     9.409   133.380     0.200
     9.409   133.775     0.200
     9.474   135.132     0.200
     9.434   134.512     0.200
     9.565   135.630     0.200
     9.565   136.062     0.200
     9.642   137.069     0.200
     9.642   137.249     0.200
     9.617   136.430     0.200
     9.619   136.100     0.200
     9.748   138.550     0.200
     9.748   137.966     0.200
     9.808   138.100     0.200
     9.808   137.981     0.200
     9.872   139.439     0.200
     9.949   140.705     0.200
     9.994   143.680     0.200
     9.994   142.237     0.200
    10.138   143.833     0.200
    10.149   143.655     0.200
    10.177   144.167     0.200
    10.263   146.250     0.200
    10.263   146.631     0.200
    10.290   146.164     0.200
    10.338   146.468     0.200
    10.376   146.649     0.200
    10.484   148.511     0.200
    10.454   147.009     0.200
    10.506   147.733     0.200
    10.587   149.864     0.200
    10.684   150.270     0.200
    10.789   152.865     0.200
    10.827   152.731     0.200
    10.790   153.206     0.200
    10.859   154.943     0.200
    10.877   154.630     0.200
    10.955   155.109     0.200
    10.955   154.515     0.200
    11.156   158.982     0.200
    11.322   161.165     0.200
    11.464   161.162     0.200
    11.428   161.103     0.200
    11.473   160.080     0.200
    11.683   164.835     0.200
    11.767   166.363     0.200
    11.774   165.817     0.200
    11.793   166.285     0.200
    11.915   167.747     0.200
    12.084   170.646     0.200
    12.197   172.339     0.200
    12.273   173.081     0.200
    12.395   175.485     0.200
    12.653   179.779     0.200
    12.662   179.301     0.200
    12.693   178.984     0.200
    12.729   179.743     0.200
    12.966   182.933     0.200
    13.927   196.912     0.200
    14.285   200.264     0.200
    14.933   210.180     0.200
    14.933   209.239     0.200
    14.933   209.588     0.200
    16.334   228.565     0.200
    18.305   252.628     0.200
    20.305   275.505     0.200
     0.194    13.082     0.200
     0.296    13.552     0.200
     0.278    13.412     0.200
     0.324    13.992     0.200
     0.350    14.032     0.200
     0.369    14.492     0.200
     0.376    14.392     0.200
     0.446    14.622     0.200
     0.478    14.862     0.200
     0.490    15.332     0.200
     0.565    15.612     0.200
     0.678    16.192     0.200
     0.692    16.462     0.200
     0.693    16.465     0.200
     0.991    19.572     0.200
     0.949    19.362     0.200
     0.949    19.620     0.200
     1.071    20.412     0.200
     1.117    20.902     0.200
     1.150    21.162     0.200
     1.131    21.322     0.200
     1.131    21.208     0.200
     1.261    23.160     0.200
     1.263    23.162     0.200
     1.310    23.142     0.200
     1.310    23.324     0.200
     1.379    25.132     0.200
     1.379    25.072     0.200
     1.399    25.232     0.200
     1.406    25.212     0.200
     1.438    25.242     0.200
     1.588    26.452     0.200
     1.685    27.672     0.200
     1.688    28.842     0.200
     1.761    29.246     0.200
     1.993    32.142     0.200
     2.000    32.692     0.200
     2.009    32.772     0.200
     2.065    33.542     0.200
     2.096    33.402     0.200
     2.080    33.362     0.200
     2.173    34.772     0.200
     2.173    35.265     0.200
     2.211    35.742     0.200
     2.244    35.472     0.200
     2.377    35.782     0.200
     2.377    36.042     0.200
     2.335    36.592     0.200
     2.484    39.192     0.200
     2.527    39.812     0.200
     2.531    39.072     0.200
     2.535    39.932     0.200
     2.582    39.702     0.200
     2.589    40.632     0.200
     2.644    40.562     0.200
     2.638    41.332     0.200
     2.661    41.592     0.200
     2.765    41.532     0.200
     2.765    41.633     0.200
     2.696    41.772     0.200
     3.021    45.852     0.200
     3.179    48.012     0.200
     3.181    48.502     0.200
     3.181    49.194     0.200
     3.265    49.013     0.200
     3.263    48.582     0.200
     3.287    49.912     0.200
     3.316    48.792     0.200
     3.316    49.026     0.200
     3.326    50.082     0.200
     3.385    51.092     0.200
     3.440    51.252     0.200
     3.660    54.882     0.200
     3.757    56.532     0.200
     3.791    56.282     0.200
     3.791    56.414     0.200
     3.840    57.512     0.200
     3.840    57.339     0.200
     3.865    56.792     0.200
     3.865    56.949     0.200
     3.874    57.652     0.200
     4.070    60.382     0.200
     4.070    60.783     0.200
     4.161    61.262     0.200
     4.161    60.944     0.200
     4.209    61.202     0.200
     4.307    61.624     0.200
     4.316    61.512     0.200
     4.279    62.612     0.200
     4.279    62.745     0.200
     4.490    65.082     0.200
     4.495    65.492     0.200
     4.529    65.652     0.200
     4.529    65.199     0.200
     4.638    66.312     0.200
     4.717    66.952     0.200
     4.717    67.371     0.200
     4.739    68.862     0.200
     4.803    69.562     0.200
     4.853    69.512     0.200
     4.853    69.862     0.200
     4.870    71.265     0.200
     4.910    69.682     0.200
     4.933    71.932     0.200
     4.933    72.504     0.200
     5.016    71.642     0.200
     5.143    73.662     0.200
     5.143    73.885     0.200
     5.211    74.782     0.200
     5.211    74.985     0.200
     5.255    76.572     0.200
     5.255    76.081     0.200
     5.398    77.022     0.200
     5.452    78.462     0.200
     5.452    78.861     0.200
     5.511    78.512     0.200
     5.530    79.642     0.200
     5.530    79.418     0.200
     5.563    79.992     0.200
     5.575    79.622     0.200
     5.585    79.312     0.200
     5.585    79.482     0.200
     5.619    80.592     0.200
     5.617    79.942     0.200
     5.744    81.932     0.200
     5.753    82.602     0.200
     5.802    82.982     0.200
     5.829    83.012     0.200
     5.829    83.323     0.200
     5.863    83.962     0.200
     5.910    85.032     0.200
     5.998    84.802     0.200
     6.035    85.682     0.200
     6.076    87.332     0.200
     6.107    86.312     0.200
     6.107    86.445     0.200
     6.127    87.392     0.200
     6.244    88.712     0.200
     6.244    88.886     0.200
     6.265    89.262     0.200
     6.264    88.743     0.200
     6.363    91.212     0.200
     6.381    91.092     0.200
     6.393    91.612     0.200
     6.455    92.062     0.200
     6.557    93.192     0.200
     6.615    94.602     0.200
     6.622    94.142     0.200
     6.622    94.386     0.200
     6.699    94.332     0.200
     6.699    95.905     0.200
     6.741    95.972     0.200
     6.826    97.642     0.200
     6.826    97.024     0.200
     6.830    97.642     0.200
     6.871    98.042     0.200
     6.965    99.372     0.200
     7.010    97.802     0.200
     7.186   101.962     0.200
     7.274   103.892     0.200
     7.299   102.712     0.200
     7.299   102.418     0.200
     7.307   101.432     0.200
     7.315   104.226     0.200
     7.319   103.952     0.200
     7.410   104.802     0.200
     7.364   103.842     0.200
     7.364   104.276     0.200
     7.434   105.682     0.200
     7.472   103.832     0.200
     7.497   104.052     0.200
     7.550   107.052     0.200
     7.605   107.112     0.200
     7.617   108.102     0.200
     7.617   108.284     0.200
     7.618   107.602     0.200
     7.644   108.282     0.200
     7.644   108.541     0.200
     7.807   111.372     0.200
     7.807   111.075     0.200
     7.800   109.922     0.200
     7.800   109.601     0.200
     7.816   111.612     0.200
     7.928   110.672     0.200
     7.928   111.170     0.200
     7.867   109.772     0.200
     7.867   110.854     0.200
     7.896   111.472     0.200
     7.934   111.222     0.200
     7.982   113.622     0.200
     7.993   113.532     0.200
     7.993   113.359     0.200
     8.012   113.742     0.200
     8.012   113.372     0.200
     8.025   113.112     0.200
     8.064   114.239     0.200
     8.301   116.242     0.200
     8.301   116.928     0.200
     8.468   118.642     0.200
     8.505   120.160     0.200
     8.676   124.069     0.200
     8.718   123.502     0.200
     8.718   123.374     0.200
     9.099   128.662     0.200
     9.099   128.861     0.200
     9.108   129.742     0.200
     9.252   129.482     0.200
     9.431   132.259     0.200
     9.454   133.172     0.200
     9.498   133.751     0.200
    10.051   141.252     0.200
    10.051   141.091     0.200
    10.847   152.112     0.200
    11.330   158.692     0.200
     1.157    20.348     0.200
     1.519    25.867     0.200
     1.568    27.066     0.200
     1.685    29.008     0.200
     1.765    29.996     0.200
     1.827    31.258     0.200
     1.827    30.969     0.200
     1.903    31.758     0.200
     1.902    31.613     0.200
     2.076    33.758     0.200
     2.337    38.367     0.200
     2.337    38.066     0.200
     2.400    39.391     0.200
     2.402    39.398     0.200
     2.447    39.125     0.200
     2.532    40.996     0.200
     2.532    40.105     0.200
     2.645    41.805     0.200
     2.720    42.855     0.200
     2.778    44.375     0.200
     3.090    48.855     0.200
     3.090    49.070     0.200
     3.108    48.215     0.200
     3.131    48.246     0.200
     3.138    48.465     0.200
     3.185    48.727     0.200
     3.185    48.578     0.200
     3.228    49.367     0.200
     3.267    50.957     0.200
     3.406    53.547     0.200
     3.418    53.305     0.200
     3.471    54.027     0.200
     3.473    54.297     0.200
     3.473    54.160     0.200
     3.483    54.305     0.200
     3.483    53.730     0.200
     3.490    54.297     0.200
     3.605    56.688     0.200
     3.788    57.758     0.200
     3.813    58.336     0.200
     3.930    60.777     0.200
     3.936    61.336     0.200
     3.946    61.027     0.200
     3.953    60.098     0.200
     3.953    59.992     0.200
     4.069    62.527     0.200
     4.089    62.277     0.200
     4.166    62.875     0.200
     4.360    65.586     0.200
     4.525    66.977     0.200
     4.525    67.094     0.200
     4.547    69.387     0.200
     4.581    68.457     0.200
     4.698    71.336     0.200
     4.713    71.488     0.200
     4.723    71.250     0.200
     4.724    71.312     0.200
     4.733    71.605     0.200
     4.841    72.926     0.200
     5.183    77.305     0.200
     5.183    77.203     0.200
     5.192    77.125     0.200
     5.192    76.898     0.200
     5.253    79.418     0.200
     5.255    78.465     0.200
     5.447    81.027     0.200
     5.453    80.078     0.200
     5.570    82.707     0.200
     5.570    82.496     0.200
     5.653    83.316     0.200
     5.653    83.449     0.200
     5.772    84.488     0.200
     5.772    84.305     0.200
     5.782    85.988     0.200
     5.827    85.105     0.200
     5.827    85.355     0.200
     5.841    85.328     0.200
     5.908    85.797     0.200
     5.908    85.594     0.200
     6.059    87.566     0.200
     6.173    90.535     0.200
     6.173    90.883     0.200
     6.185    90.688     0.200
     6.208    91.316     0.200
     6.206    90.148     0.200
     6.236    90.578     0.200
     6.236    90.176     0.200
     6.348    92.848     0.200
     6.344    92.863     0.200
     6.499    93.855     0.200
     6.499    94.676     0.200
     6.515    95.336     0.200
     6.566    95.305     0.200
     6.607    96.086     0.200
     6.649    97.277     0.200
     6.649    97.391     0.200
     6.741    97.906     0.200
     6.741    97.773     0.200
     6.765    98.438     0.200
     6.867   100.387     0.200
     6.868   100.266     0.200
     6.890   100.305     0.200
     6.936   100.105     0.200
     6.936    99.992     0.200
     6.957   100.922     0.200
     6.960   100.738     0.200
     6.960   100.895     0.200
     7.038   100.965     0.200
     7.072   103.027     0.200
     7.072   102.891     0.200
     7.148   104.375     0.200
     7.154   104.355     0.200
     7.154   103.941     0.200
     7.263   104.637     0.200
     7.295   105.996     0.200
     7.295   106.480     0.200
     7.305   105.406     0.200
     7.305   105.594     0.200
     7.343   106.285     0.200
     7.389   106.117     0.200
     7.444   107.398     0.200
     7.462   108.305     0.200
     7.462   108.199     0.200
     7.466   108.168     0.200
     7.466   108.895     0.200
     7.518   108.496     0.200
     7.549   109.508     0.200
     7.625   109.637     0.200
     7.625   111.074     0.200
     7.640   110.246     0.200
     7.660   111.805     0.200
     7.663   111.156     0.200
     7.662   110.305     0.200
     7.738   111.758     0.200
     7.756   110.957     0.200
     7.807   112.418     0.200
     7.807   112.781     0.200
     7.806   112.047     0.200
     7.867   112.918     0.200
     7.917   113.297     0.200
     7.926   114.227     0.200
     7.926   114.691     0.200
     7.924   113.766     0.200
     7.943   113.738     0.200
     8.060   115.863     0.200
     8.111   116.035     0.200
     8.224   117.688     0.200
     8.233   118.805     0.200
     8.335   119.832     0.200
     8.338   119.578     0.200
     8.389   120.727     0.200
     8.389   120.973     0.200
     8.419   121.176     0.200
     8.430   120.508     0.200
     8.473   122.738     0.200
     8.492   121.086     0.200
     8.584   122.977     0.200
     8.598   123.918     0.200
     8.658   124.457     0.200
     8.658   125.113     0.200
     8.683   124.336     0.200
     8.691   125.566     0.200
     8.705   123.906     0.200
     8.780   125.586     0.200
     8.780   126.344     0.200
     8.789   125.625     0.200
     8.789   126.691     0.200
     8.857   128.285     0.200
     8.886   127.176     0.200
     8.896   127.715     0.200
     8.898   127.535     0.200
     8.903   126.918     0.200
     8.914   127.535     0.200
     9.009   129.547     0.200
     9.009   129.320     0.200
     9.008   128.336     0.200
     9.008   127.016     0.200
     9.008   128.977     0.200
     9.070   129.398     0.200
     9.070   130.105     0.200
     9.121   129.957     0.200
     9.218   132.688     0.200
     9.233   132.375     0.200
     9.233   132.199     0.200
     9.236   131.047     0.200
     9.236   132.695     0.200
     9.288   132.148     0.200
     9.288   133.926     0.200
     9.397   134.871     0.200
     9.497   135.508     0.200
     9.497   135.312     0.200
     9.635   138.996     0.200
     9.755   140.668     0.200
     9.755   140.160     0.200
     9.764   140.168     0.200
     9.948   142.398     0.200
    10.210   145.809     0.200
    10.362   147.406     0.200
    10.557   150.867     0.200
    10.622   151.383     0.200
    10.656   151.699     0.200
    10.695   153.016     0.200
    10.695   152.801     0.200
    10.858   156.027     0.200
    10.909   154.777     0.200
    11.038   156.926     0.200
    11.788   166.898     0.200
    12.356   175.086     0.200
    13.420   189.957     0.200
    13.589   194.902     0.200
    15.187   214.578     0.200
    15.187   211.906     0.200
     0.181    12.891     0.200
     0.463    14.738     0.200
     0.487    15.230     0.200
     0.553    15.469     0.200
     0.677    16.238     0.200
     0.950    19.531     0.200
     1.062    20.141     0.200
     1.106    20.641     0.200
     1.164    21.168     0.200
     1.146    21.230     0.200
     1.272    23.281     0.200
     1.300    23.031     0.200
     1.378    25.090     0.200
     1.379    24.980     0.200
     1.380    25.141     0.200
     1.424    25.008     0.200
     1.597    26.438     0.200
     1.687    28.781     0.200
     1.751    29.039     0.200
     1.978    31.770     0.200
     1.999    32.629     0.200
     2.082    33.141     0.200
     2.074    33.238     0.200
     2.177    35.148     0.200
     2.210    35.641     0.200
     2.250    35.680     0.200
     2.320    36.238     0.200
     2.381    36.051     0.200
     2.482    39.070     0.200
     2.526    39.859     0.200
     2.533    39.828     0.200
     2.537    38.910     0.200
     2.588    39.621     0.200
     2.634    40.578     0.200
     2.659    41.559     0.200
     2.759    41.461     0.200
     2.689    41.660     0.200
     3.012    45.410     0.200
     3.165    47.688     0.200
     3.183    49.629     0.200
     3.282    48.820     0.200
     3.285    49.871     0.200
     3.321    48.969     0.200
     3.383    51.469     0.200
     3.432    51.969     0.200
     3.659    54.891     0.200
     3.784    56.199     0.200
     3.835    57.398     0.200
     3.868    56.699     0.200
     3.874    57.711     0.200
     4.063    60.109     0.200
     4.159    61.609     0.200
     4.172    60.898     0.200
     4.261    61.379     0.200
     4.214    61.121     0.200
     4.312    61.148     0.200
     4.280    62.879     0.200
     4.532    65.121     0.200
     4.723    67.219     0.200
     4.747    68.828     0.200
     4.802    70.398     0.200
     4.855    69.609     0.200
     4.861    70.871     0.200
     4.917    69.539     0.200
     4.929    71.871     0.200
     5.150    73.828     0.200
     5.214    74.641     0.200
     5.248    75.949     0.200
     5.404    77.609     0.200
     5.448    78.301     0.200
     5.535    79.340     0.200
     5.572    80.980     0.200
     5.583    80.098     0.200
     5.586    79.461     0.200
     5.618    79.859     0.200
     5.742    81.871     0.200
     5.762    82.609     0.200
     5.870    83.230     0.200
     5.806    83.371     0.200
     5.836    83.359     0.200
     5.920    84.891     0.200
     5.997    84.938     0.200
     6.044    86.109     0.200
     6.069    87.898     0.200
     6.108    86.559     0.200
     6.133    87.660     0.200
     6.241    88.910     0.200
     6.263    89.070     0.200
     6.388    91.078     0.200
     6.402    91.469     0.200
     6.453    92.359     0.200
     6.464    92.281     0.200
     6.565    93.730     0.200
     6.624    94.250     0.200
     6.706    95.219     0.200
     6.750    96.129     0.200
     6.835    97.559     0.200
     6.839    97.668     0.200
     6.837    97.320     0.200
     6.879    98.301     0.200
     6.881    97.750     0.200
     6.974    99.520     0.200
     7.007    97.418     0.200
     7.092    98.480     0.200
     7.129   101.930     0.200
     7.164   100.031     0.200
     7.182   101.051     0.200
     7.191   102.230     0.200
     7.204   102.520     0.200
     7.217   102.699     0.200
     7.283   103.918     0.200
     7.298   102.219     0.200
     7.306   101.270     0.200
     7.327   104.598     0.200
     7.366   104.480     0.200
     7.443   105.531     0.200
     7.469   104.449     0.200
     7.553   107.199     0.200
     7.600   107.461     0.200
     7.622   108.301     0.200
     7.802   110.129     0.200
     7.867   111.328     0.200
     7.890   111.988     0.200
     7.989   113.688     0.200
     7.998   113.340     0.200
     8.016   113.809     0.200
     8.016   113.348     0.200
     8.078   112.551     0.200
     8.303   117.090     0.200
     8.471   119.418     0.200
     8.560   119.570     0.200
     9.009   125.109     0.200
     0.755    14.898     0.200
     0.737    14.619     0.200
     0.737    14.834     0.200
     0.794    15.199     0.200
     1.010    17.879     0.200
     1.420    22.869     0.200
     1.420    23.135     0.200
     1.487    24.920     0.200
     1.487    25.035     0.200
     1.656    26.699     0.200
     1.822    28.898     0.200
     1.822    28.762     0.200
     1.834    30.020     0.200
     1.834    30.277     0.200
     1.873    30.439     0.200
     1.981    31.885     0.200
     2.025    31.340     0.200
     2.025    31.832     0.200
     2.168    33.430     0.200
     2.206    34.098     0.200
     2.332    36.939     0.200
     2.587    38.389     0.200
     2.650    40.959     0.200
     2.650    40.760     0.200
     2.717    41.240     0.200
     2.904    45.609     0.200
     2.934    43.160     0.200
     3.052    45.809     0.200
     3.089    46.109     0.200
     3.089    45.877     0.200
     3.116    47.170     0.200
     3.118    47.289     0.200
     3.462    52.010     0.200
     3.551    52.549     0.200
     3.616    53.979     0.200
     3.712    56.340     0.200
     3.712    55.934     0.200
     3.733    55.510     0.200
     3.846    55.779     0.200
     3.958    58.119     0.200
     4.035    59.629     0.200
     4.051    58.930     0.200
     4.056    58.590     0.200
     4.130    59.549     0.200
     4.130    59.670     0.200
     4.195    60.709     0.200
     4.195    61.098     0.200
     4.330    62.510     0.200
     4.334    61.770     0.200
     4.334    62.590     0.200
     4.514    63.799     0.200
     4.535    65.490     0.200
     4.566    66.750     0.200
     4.664    67.229     0.200
     4.732    67.469     0.200
     4.732    67.797     0.200
     4.872    70.240     0.200
     5.008    71.670     0.200
     5.153    73.760     0.200
     5.156    73.969     0.200
     5.181    75.750     0.200
     5.306    77.490     0.200
     5.306    77.670     0.200
     5.314    76.188     0.200
     5.317    76.057     0.200
     5.328    76.160     0.200
     5.423    77.098     0.200
     5.454    78.760     0.200
     5.454    78.648     0.200
     5.540    80.449     0.200
     5.540    80.227     0.200
     5.609    79.869     0.200
     5.742    82.209     0.200
     5.750    83.938     0.200
     5.753    82.689     0.200
     5.818    83.180     0.200
     5.984    85.029     0.200
     6.004    87.029     0.200
     6.004    86.578     0.200
     6.012    86.215     0.200
     6.028    85.600     0.200
     6.295    89.717     0.200
     6.294    90.119     0.200
     6.391    91.369     0.200
     6.391    91.238     0.200
     6.533    93.279     0.200
     6.777    96.010     0.200
     6.811    97.049     0.200
     6.811    96.910     0.200
     6.842    97.689     0.200
     6.894    98.258     0.200
     6.897    98.289     0.200
     7.206   102.279     0.200
     7.206   102.273     0.200
     7.370   103.770     0.200
     7.494   106.309     0.200
     7.574   107.826     0.200
     8.254   118.109     0.200
     8.355   117.260     0.200
     8.677   123.199     0.200
     0.236    12.500     0.200
     0.236    12.711     0.200
     0.659    15.938     0.200
     0.712    16.078     0.200
     0.714    16.062     0.200
     0.985    19.797     0.200
     0.985    19.469     0.200
     0.985    19.715     0.200
     1.073    19.719     0.200
     1.078    19.859     0.200
     1.254    22.340     0.200
     1.319    23.508     0.200
     1.414    25.160     0.200
     1.414    24.340     0.200
     1.414    24.492     0.200
     1.488    24.727     0.200
     1.487    25.938     0.200
     1.497    25.707     0.200
     1.533    25.871     0.200
     1.545    26.148     0.200
     1.572    26.512     0.200
     1.779    28.609     0.200
     1.836    29.547     0.200
     1.831    30.348     0.200
     1.951    31.859     0.200
     2.077    32.789     0.200
     2.159    33.539     0.200
     2.168    34.758     0.200
     2.283    36.016     0.200
     2.295    36.109     0.200
     2.434    39.527     0.200
     2.434    39.031     0.200
     2.463    38.238     0.200
     2.570    38.719     0.200
     2.601    39.918     0.200
     2.617    40.699     0.200
     2.621    40.418     0.200
     3.073    45.340     0.200
     3.107    46.738     0.200
     3.136    47.559     0.200
     3.159    47.887     0.200
     3.210    49.047     0.200
     3.242    48.879     0.200
     3.242    48.980     0.200
     3.454    51.172     0.200
     3.453    51.020     0.200
     3.453    50.746     0.200
     3.461    51.520     0.200
     3.518    52.078     0.200
     3.518    52.180     0.200
     3.537    53.000     0.200
     3.537    52.863     0.200
     3.551    53.238     0.200
     3.681    53.867     0.200
     3.681    54.000     0.200
     3.769    55.047     0.200
     3.800    56.812     0.200
     3.839    57.215     0.200
     3.883    56.680     0.200
     3.971    57.117     0.200
     4.017    58.750     0.200
     4.079    59.648     0.200
     4.079    60.086     0.200
     4.094    59.527     0.200
     4.094    59.836     0.200
     4.173    59.559     0.200
     4.278    63.738     0.200
     4.285    62.414     0.200
     4.421    63.840     0.200
     4.421    63.965     0.200
     4.451    64.859     0.200
     4.451    64.727     0.200
     4.655    67.449     0.200
     4.684    68.629     0.200
     4.684    68.988     0.200
     4.778    69.148     0.200
     4.772    69.199     0.200
     4.803    68.547     0.200
     4.803    70.281     0.200
     4.842    69.738     0.200
     4.842    70.207     0.200
     4.863    70.047     0.200
     4.888    71.316     0.200
     4.905    70.887     0.200
     5.016    72.438     0.200
     5.042    73.059     0.200
     5.042    73.164     0.200
     5.055    72.316     0.200
     5.044    72.867     0.200
     5.044    73.422     0.200
     5.051    72.398     0.200
     5.100    72.238     0.200
     5.100    73.184     0.200
     5.269    75.488     0.200
     5.338    76.520     0.200
     5.357    76.859     0.200
     5.357    77.066     0.200
     5.380    77.277     0.200
     5.380    77.488     0.200
     5.498    79.316     0.200
     5.508    79.598     0.200
     5.543    79.418     0.200
     5.543    79.867     0.200
     5.604    80.938     0.200
     5.643    80.688     0.200
     5.713    82.316     0.200
     5.716    81.629     0.200
     5.762    82.488     0.200
     5.862    83.289     0.200
     5.862    84.141     0.200
     5.967    85.020     0.200
     5.967    85.328     0.200
     6.044    86.527     0.200
     6.139    88.227     0.200
     6.151    88.418     0.200
     6.151    88.266     0.200
     6.282    89.680     0.200
     6.307    88.047     0.200
     6.307    89.016     0.200
     6.375    91.500     0.200
     6.433    92.090     0.200
     6.483    92.258     0.200
     6.506    92.367     0.200
     6.506    93.066     0.200
     6.557    92.578     0.200
     6.564    92.680     0.200
     6.564    93.113     0.200
     6.590    94.508     0.200
     6.586    92.328     0.200
     6.607    94.617     0.200
     6.642    95.547     0.200
     6.642    94.836     0.200
     6.778    95.637     0.200
     6.780    95.648     0.200
     6.784    95.957     0.200
     6.784    95.789     0.200
     6.791    97.020     0.200
     6.787    95.199     0.200
     6.868    97.758     0.200
     6.868    98.023     0.200
     6.888    96.289     0.200
     6.888    96.609     0.200
     7.001    99.297     0.200
     7.043    99.297     0.200
     7.043    99.469     0.200
     7.078   100.059     0.200
     7.113   101.789     0.200
     7.122   100.289     0.200
     7.122   100.609     0.200
     7.237   103.258     0.200
     7.253   103.742     0.200
     7.255   103.277     0.200
     7.318   103.797     0.200
     7.386   104.750     0.200
     7.386   104.980     0.200
     7.407   103.918     0.200
     7.407   104.637     0.200
     7.429   106.672     0.200
     7.546   106.430     0.200
     7.654   108.047     0.200
     7.708   108.270     0.200
     7.836   111.445     0.200
     7.829   109.348     0.200
     7.829   110.125     0.200
     8.228   115.668     0.200
     8.258   116.520     0.200
     8.363   118.414     0.200
     8.493   119.977     0.200
     8.695   122.707     0.200
     8.695   122.340     0.200
     9.139   128.680     0.200
     9.347   131.859     0.200
     9.670   134.938     0.200
     9.688   137.957     0.200
    10.092   142.758     0.200
    10.127   141.750     0.200
    10.612   147.418     0.200
     0.498    11.431     0.200
     0.671    13.551     0.200
     1.036    18.562     0.200
     1.036    17.602     0.200
     1.375    22.511     0.200
     1.487    24.576     0.200
     1.487    24.486     0.200
     1.688    27.646     0.200
     1.730    27.821     0.200
     1.856    29.421     0.200
     2.236    34.562     0.200
     2.300    35.271     0.200
     2.498    37.321     0.200
     2.685    41.085     0.200
     2.702    40.736     0.200
     2.783    42.181     0.200
     2.818    43.211     0.200
     2.968    44.328     0.200
     2.976    44.441     0.200
     2.976    45.127     0.200
     3.081    46.011     0.200
     3.100    46.711     0.200
     3.570    52.131     0.200
     3.804    54.741     0.200
     3.804    55.256     0.200
     3.884    56.971     0.200
     3.971    57.591     0.200
     4.006    57.621     0.200
     4.026    59.312     0.200
     4.116    60.191     0.200
     4.502    65.461     0.200
     4.502    65.981     0.200
     4.691    68.541     0.200
     4.700    68.852     0.200
     4.700    69.298     0.200
     4.736    67.531     0.200
     4.736    68.369     0.200
     4.956    71.892     0.200
     4.980    72.221     0.200
     5.124    73.231     0.200
     5.124    73.553     0.200
     5.478    77.251     0.200
     5.504    78.431     0.200
     5.775    84.931     0.200
     5.791    82.251     0.200
     5.791    83.250     0.200
     5.791    84.011     0.200
     5.837    83.291     0.200
     6.016    85.981     0.200
     6.016    86.142     0.200
     6.149    88.291     0.200
     6.205    88.381     0.200
     6.205    88.587     0.200
     6.310    88.852     0.200
     6.299    90.991     0.200
     6.359    91.551     0.200
     6.537    93.751     0.200
     6.549    92.761     0.200
     6.576    93.931     0.200
     6.619    94.642     0.200
     6.717    95.521     0.200
     6.781    97.401     0.200
     6.787    96.031     0.200
     6.817    96.961     0.200
     6.972    99.711     0.200
     7.010    99.481     0.200
     7.022   100.521     0.200
     7.076   100.131     0.200
     7.072   101.841     0.200
     7.193   101.911     0.200
     7.222   102.142     0.200
     7.501   106.301     0.200
     7.503   106.241     0.200
     7.755   109.631     0.200
     7.798   110.161     0.200
     7.817   110.901     0.200
     7.851   110.392     0.200
     7.940   113.791     0.200
     8.023   112.921     0.200
     8.059   113.461     0.200
     8.274   116.321     0.200
     8.354   117.852     0.200
     8.354   114.678     0.200
     8.354   116.901     0.200
     8.485   121.291     0.200
     8.494   119.241     0.200
     8.557   121.171     0.200
     8.789   122.981     0.200
     8.906   125.471     0.200
     9.043   127.261     0.200
     9.145   128.501     0.200
     9.327   131.301     0.200
     9.850   139.121     0.200
     9.972   140.711     0.200
    10.546   147.661     0.200
    11.151   154.721     0.200
    14.112   196.321     0.200
    14.490   202.241     0.200
    20.313   273.370     0.200
     0.492    10.758     0.200
     1.113    18.595     0.200
     1.113    18.794     0.200
     1.419    24.214     0.200
     1.419    23.944     0.200
     1.419    24.058     0.200
     1.447    24.174     0.200
     1.478    24.725     0.200
     1.744    27.614     0.200
     1.736    27.975     0.200
     1.755    28.104     0.200
     1.761    27.685     0.200
     1.814    29.589     0.200
     1.915    29.924     0.200
     2.074    32.354     0.200
     2.117    32.714     0.200
     2.117    33.064     0.200
     2.327    36.354     0.200
     2.456    36.614     0.200
     2.555    38.404     0.200
     2.612    41.104     0.200
     2.665    40.884     0.200
     2.719    41.645     0.200
     2.944    44.589     0.200
     2.945    44.774     0.200
     3.126    47.254     0.200
     3.181    47.015     0.200
     3.206    47.984     0.200
     3.338    49.515     0.200
     3.338    49.662     0.200
     3.388    49.744     0.200
     3.630    54.015     0.200
     3.710    54.714     0.200
     3.749    55.524     0.200
     3.764    54.584     0.200
     3.759    55.305     0.200
     3.785    55.004     0.200
     3.969    57.805     0.200
     4.076    59.914     0.200
     4.146    60.494     0.200
     4.188    60.345     0.200
     4.306    62.714     0.200
     4.447    64.624     0.200
     4.498    64.895     0.200
     4.647    67.204     0.200
     4.644    67.964     0.200
     4.670    67.454     0.200
     4.885    69.914     0.200
     4.885    70.103     0.200
     4.939    71.294     0.200
     4.951    71.324     0.200
     4.962    71.544     0.200
     4.962    71.857     0.200
     4.992    71.935     0.200
     4.992    72.092     0.200
     5.011    72.824     0.200
     5.011    72.964     0.200
     5.150    74.564     0.200
     5.171    74.424     0.200
     5.237    75.289     0.200
     5.264    75.414     0.200
     5.319    76.714     0.200
     5.319    76.882     0.200
     5.362    77.225     0.200
     5.458    78.055     0.200
     5.464    78.435     0.200
     5.464    78.603     0.200
     5.469    78.994     0.200
     5.500    78.685     0.200
     5.560    80.470     0.200
     5.606    80.884     0.200
     5.757    82.114     0.200
     5.757    82.529     0.200
     5.763    82.345     0.200
     5.763    83.002     0.200
     5.848    83.464     0.200
     5.879    83.714     0.200
     5.879    84.223     0.200
     5.899    84.225     0.200
     5.901    84.164     0.200
     5.901    84.282     0.200
     5.970    85.015     0.200
     6.111    87.334     0.200
     6.215    88.854     0.200
     6.565    92.725     0.200
     6.591    94.694     0.200
     6.588    92.734     0.200
     6.658    94.895     0.200
     6.731    95.744     0.200
     6.731    95.874     0.200
     6.797    95.504     0.200
     6.841    96.704     0.200
     6.841    97.021     0.200
     6.939    98.265     0.200
     7.026    99.185     0.200
     7.070    99.584     0.200
     7.070    99.714     0.200
     7.070    99.754     0.200
     7.070   100.089     0.200
     7.081    99.895     0.200
     7.157   102.039     0.200
     7.244   102.145     0.200
     7.294   103.464     0.200
     7.412   104.774     0.200
     7.412   105.015     0.200
     7.605   107.134     0.200
     7.715   108.354     0.200
    11.856   166.964     0.200
    13.152   182.814     0.200
     0.052    17.801     0.200
     0.331    18.840     0.200
     0.360    18.801     0.200
     0.401    18.992     0.200
     0.484    19.242     0.200
     0.571    20.062     0.200
     0.651    20.379     0.200
     0.716    20.492     0.200
     0.889    22.312     0.200
     1.031    24.332     0.200
     1.069    24.371     0.200
     1.173    24.902     0.200
     1.250    25.902     0.200
     1.309    26.891     0.200
     1.342    27.129     0.200
     1.301    26.449     0.200
     1.542    28.750     0.200
     1.550    28.418     0.200
     1.550    28.570     0.200
     1.545    28.652     0.200
     1.593    29.590     0.200
     1.595    29.699     0.200
     1.658    30.652     0.200
     1.614    29.691     0.200
     1.721    30.191     0.200
     1.833    33.012     0.200
     1.854    32.289     0.200
     2.057    35.289     0.200
     2.092    35.340     0.200
     2.095    35.832     0.200
     2.098    36.020     0.200
     2.138    36.312     0.200
     2.141    36.441     0.200
     2.179    35.879     0.200
     2.226    37.473     0.200
     2.351    38.020     0.200
     2.426    38.879     0.200
     2.433    39.320     0.200
     2.871    45.680     0.200
     2.892    45.051     0.200
     2.901    44.539     0.200
     2.995    47.250     0.200
     3.017    47.109     0.200
     3.039    47.152     0.200
     3.208    49.770     0.200
     3.234    50.332     0.200
     3.326    51.652     0.200
     3.489    53.609     0.200
     3.501    53.930     0.200
     3.562    53.961     0.200
     3.711    56.941     0.200
     3.836    58.191     0.200
     3.903    58.449     0.200
     3.989    58.742     0.200
     4.082    60.902     0.200
     4.114    60.020     0.200
     4.248    61.980     0.200
     4.284    63.961     0.200
     4.309    62.699     0.200
     4.383    65.020     0.200
     4.431    67.691     0.200
     4.543    65.781     0.200
     4.700    69.410     0.200
     4.757    68.973     0.200
     4.932    71.379     0.200
     4.944    72.781     0.200
     5.030    72.812     0.200
     5.119    73.980     0.200
     5.202    74.750     0.200
     5.226    76.199     0.200
     5.253    76.461     0.200
     5.272    75.609     0.200
     5.284    76.492     0.200
     5.321    76.742     0.200
     5.523    80.211     0.200
     5.518    80.070     0.200
     5.536    79.930     0.200
     5.697    82.172     0.200
     5.745    81.801     0.200
     5.751    82.500     0.200
     5.831    83.730     0.200
     5.939    85.832     0.200
     6.033    87.590     0.200
     6.100    87.371     0.200
     6.094    87.289     0.200
     6.221    89.590     0.200
     6.222    90.262     0.200
     6.310    90.801     0.200
     6.315    89.691     0.200
     6.359    92.012     0.200
     6.548    92.422     0.200
     6.557    94.441     0.200
     6.656    93.680     0.200
     6.660    95.473     0.200
     6.664    94.461     0.200
     6.769    96.832     0.200
     6.871    96.371     0.200
     6.889    97.070     0.200
     6.946    98.930     0.200
     6.968   100.020     0.200
     6.993    98.699     0.200
     7.028   100.402     0.200
     7.044    99.180     0.200
     7.062   101.152     0.200
     7.098   101.789     0.200
     7.136   101.500     0.200
     7.197   101.020     0.200
     7.197   100.949     0.200
     7.197   100.840     0.200
     7.340   104.551     0.200
     7.354   103.152     0.200
     7.420   105.949     0.200
     7.470   105.109     0.200
     7.587   106.230     0.200
     7.753   110.371     0.200
     7.771   110.312     0.200
     7.782   110.461     0.200
     7.844   112.270     0.200
     7.887   110.492     0.200
     7.955   110.980     0.200
     8.052   113.012     0.200
     9.193   129.090     0.200
     9.933   136.590     0.200
     1.092    19.020     0.200
     1.811    30.230     0.200
     2.119    33.020     0.200
     2.119    33.141     0.200
     2.255    36.871     0.200
     2.255    37.117     0.200
     2.366    38.098     0.200
     2.398    37.625     0.200
     2.444    38.848     0.200
     2.781    43.590     0.200
     2.880    45.230     0.200
     2.902    46.281     0.200
     2.902    46.223     0.200
     2.995    45.445     0.200
     3.037    47.121     0.200
     3.027    46.621     0.200
     3.054    46.520     0.200
     3.221    49.852     0.200
     3.292    51.355     0.200
     3.447    51.602     0.200
     3.447    51.406     0.200
     3.621    53.742     0.200
     3.677    56.070     0.200
     3.787    56.992     0.200
     4.016    61.301     0.200
     4.094    60.188     0.200
     4.166    62.414     0.200
     4.184    63.281     0.200
     4.184    63.008     0.200
     4.391    64.871     0.200
     4.478    66.211     0.200
     4.490    66.012     0.200
     4.547    66.781     0.200
     4.636    68.883     0.200
     4.832    71.461     0.200
     4.832    70.895     0.200
     5.018    72.742     0.200
     5.061    74.020     0.200
     5.062    73.641     0.200
     5.062    73.305     0.200
     5.082    75.051     0.200
     5.113    75.473     0.200
     5.205    76.121     0.200
     5.266    76.441     0.200
     5.405    79.082     0.200
     5.481    79.711     0.200
     5.513    80.637     0.200
     5.578    80.867     0.200
     5.553    81.586     0.200
     5.638    82.402     0.200
     5.719    83.043     0.200
     5.757    83.742     0.200
     6.153    90.082     0.200
     6.214    89.855     0.200
     6.227    89.992     0.200
     6.286    90.793     0.200
     6.324    91.250     0.200
     6.348    91.703     0.200
     6.362    92.191     0.200
     6.428    93.711     0.200
     6.584    95.043     0.200
     6.607    95.473     0.200
     6.636    96.145     0.200
     6.671    97.062     0.200
     6.740    96.633     0.200
     6.803    97.859     0.200
     6.943   100.730     0.200
     7.060   102.340     0.200
     7.105   102.711     0.200
     7.105   102.711     0.200
     7.142   102.852     0.200
     7.346   104.840     0.200
     7.367   106.480     0.200
     7.823   113.453     0.200
     7.845   114.180     0.200
     7.957   113.230     0.200
     8.055   116.273     0.200
     8.060   115.883     0.200
     8.162   116.270     0.200
     8.287   117.641     0.200
     8.301   119.750     0.200
     8.374   119.152     0.200
     8.409   119.957     0.200
     8.411   119.582     0.200
    14.320   201.633     0.200
    19.633   268.254     0.200
     0.855    13.797     0.200
     1.144    19.738     0.200
     1.821    29.289     0.200
     2.313    34.496     0.200
     2.313    34.836     0.200
     2.470    38.570     0.200
     2.739    43.105     0.200
     2.739    42.941     0.200
     3.224    48.535     0.200
     3.224    48.273     0.200
     3.489    53.035     0.200
     3.489    53.125     0.200
     3.489    52.918     0.200
     3.611    52.918     0.200
     3.681    54.969     0.200
     3.681    54.848     0.200
     3.692    55.328     0.200
     3.724    56.285     0.200
     3.724    55.977     0.200
     3.972    59.922     0.200
     3.989    59.477     0.200
     3.986    58.516     0.200
     3.988    58.867     0.200
     3.988    59.285     0.200
     4.331    65.035     0.200
     4.611    68.457     0.200
     4.611    68.211     0.200
     4.658    67.008     0.200
     4.847    71.285     0.200
     4.900    72.070     0.200
     4.942    72.258     0.200
     5.111    74.848     0.200
     5.428    78.387     0.200
     5.428    78.996     0.200
     5.571    81.105     0.200
     5.571    81.285     0.200
     5.596    80.297     0.200
     5.704    82.996     0.200
     5.712    83.816     0.200
     5.712    83.699     0.200
     5.950    85.969     0.200
     5.950    86.266     0.200
     5.951    85.676     0.200
     5.990    86.957     0.200
     5.990    87.258     0.200
     6.011    86.406     0.200
     6.020    86.531     0.200
     6.239    89.227     0.200
     6.284    90.973     0.200
     6.388    91.656     0.200
     6.388    92.254     0.200
     6.672    95.945     0.200
     6.783    97.375     0.200
     6.783    97.484     0.200
     6.791    97.809     0.200
     6.791    97.938     0.200
     6.940    98.848     0.200
     7.163   102.598     0.200
     7.163   102.746     0.200
     7.183   102.797     0.200
     7.197   102.785     0.200
     7.308   104.527     0.200
     7.308   104.918     0.200
     7.527   108.219     0.200
     7.527   107.531     0.200
     7.538   107.047     0.200
     7.711   110.125     0.200
     7.801   111.418     0.200
     7.873   111.676     0.200
     8.075   114.867     0.200
     8.105   116.328     0.200
     8.169   116.285     0.200
     8.824   124.367     0.200
     8.977   127.016     0.200
     8.977   127.543     0.200
     9.010   127.125     0.200
     9.034   127.867     0.200
     9.062   127.617     0.200
     9.254   130.926     0.200
     9.274   131.047     0.200
     9.314   132.016     0.200
     9.314   132.031     0.200
     9.499   134.266     0.200
     9.804   138.398     0.200
    10.245   144.996     0.200
    10.721   152.066     0.200
    11.233   157.355     0.200
    13.262   188.445     0.200
    15.381   216.320     0.200
    15.381   216.156     0.200
    19.910   270.516     0.200
     0.579    12.008     0.200
     1.146    20.367     0.200
     1.257    20.633     0.200
     1.341    22.734     0.200
     1.434    24.133     0.200
     1.434    24.320     0.200
     1.579    26.484     0.200
     1.579    26.359     0.200
     1.623    25.914     0.200
     1.608    26.023     0.200
     1.889    30.633     0.200
     2.082    31.867     0.200
     2.082    32.422     0.200
     2.082    32.258     0.200
     2.262    34.078     0.200
     2.262    33.961     0.200
     2.276    35.422     0.200
     2.325    36.031     0.200
     2.355    36.133     0.200
     2.516    38.188     0.200
     2.570    39.961     0.200
     2.900    43.875     0.200
     2.957    44.008     0.200
     2.979    44.281     0.200
     2.980    44.438     0.200
     3.042    45.641     0.200
     3.068    45.422     0.200
     3.068    45.531     0.200
     3.128    46.641     0.200
     3.128    45.469     0.200
     3.132    46.727     0.200
     3.157    45.945     0.200
     3.200    47.375     0.200
     3.292    48.953     0.200
     3.292    48.602     0.200
     3.423    51.008     0.200
     3.423    50.836     0.200
     3.633    52.883     0.200
     3.647    53.102     0.200
     3.642    53.555     0.200
     3.711    54.711     0.200
     3.763    55.219     0.200
     3.912    56.891     0.200
     3.912    56.781     0.200
     3.886    57.359     0.200
     4.008    58.461     0.200
     4.030    59.266     0.200
     4.254    61.961     0.200
     4.224    61.945     0.200
     4.262    62.352     0.200
     4.262    62.484     0.200
     4.369    63.773     0.200
     4.448    64.305     0.200
     4.613    66.617     0.200
     4.613    66.383     0.200
     4.680    68.219     0.200
     4.824    70.086     0.200
     4.824    69.523     0.200
     4.898    70.703     0.200
     4.994    71.812     0.200
     5.126    74.305     0.200
     5.126    74.133     0.200
     5.197    74.578     0.200
     5.203    74.766     0.200
     5.203    74.266     0.200
     5.248    75.531     0.200
     5.294    76.164     0.200
     5.344    76.984     0.200
     5.363    77.484     0.200
     5.484    78.516     0.200
     5.526    81.578     0.200
     5.710    81.656     0.200
     5.703    82.039     0.200
     5.903    83.992     0.200
     5.903    83.820     0.200
     6.275    89.422     0.200
     6.386    91.875     0.200
     6.475    92.453     0.200
     6.474    92.484     0.200
     6.503    93.219     0.200
     6.524    92.117     0.200
     6.631    94.234     0.200
     6.637    94.641     0.200
     6.747    96.180     0.200
     6.843    97.023     0.200
     6.899    97.992     0.200
     6.923    98.266     0.200
     6.918    98.141     0.200
     6.940    99.086     0.200
     6.935    98.758     0.200
     6.937    98.906     0.200
     6.937    98.336     0.200
     6.971    98.602     0.200
     6.983    98.734     0.200
     6.983    98.594     0.200
     7.043    99.688     0.200
     7.379   106.812     0.200
     7.390   105.617     0.200
     7.450   105.312     0.200
     7.462   105.461     0.200
     7.768   110.422     0.200
     7.768   109.578     0.200
     7.825   110.453     0.200
     7.902   112.109     0.200
     8.154   115.273     0.200
     8.325   117.688     0.200
     8.404   118.820     0.200
     8.645   121.695     0.200
     8.683   122.422     0.200
     8.683   122.938     0.200
     8.960   127.023     0.200
     8.971   123.781     0.200
     8.971   125.531     0.200
     9.003   127.438     0.200
     9.003   126.477     0.200
     9.040   128.547     0.200
     9.061   126.961     0.200
     9.239   128.547     0.200
     9.270   130.625     0.200
     9.270   130.281     0.200
     9.569   135.078     0.200
     9.808   138.102     0.200
     9.978   141.227     0.200
    10.046   141.727     0.200
    11.493   161.703     0.200
    16.387   225.281     0.200
    17.524   239.492     0.200
    18.741   255.234     0.200
     0.569    15.577     0.200
     0.930    19.266     0.200
     0.930    19.386     0.200
     1.109    20.815     0.200
     1.140    20.985     0.200
     1.311    23.226     0.200
     1.672    28.611     0.200
     1.672    28.555     0.200
     1.759    29.075     0.200
     2.072    33.125     0.200
     2.072    33.271     0.200
     2.194    35.485     0.200
     2.221    35.426     0.200
     2.508    38.665     0.200
     2.512    39.466     0.200
     2.558    39.335     0.200
     2.624    41.075     0.200
     2.689    41.806     0.200
     3.019    45.825     0.200
     3.163    49.266     0.200
     3.163    48.678     0.200
     3.257    48.285     0.200
     3.292    48.775     0.200
     3.299    49.761     0.200
     3.418    50.516     0.200
     3.418    51.186     0.200
     3.737    56.056     0.200
     3.784    56.556     0.200
     3.784    56.132     0.200
     3.829    56.926     0.200
     3.829    57.351     0.200
     3.845    56.575     0.200
     3.845    56.795     0.200
     3.856    57.476     0.200
     3.856    57.584     0.200
     4.065    60.115     0.200
     4.147    60.825     0.200
     4.147    61.028     0.200
     4.186    60.926     0.200
     4.261    62.084     0.200
     4.373    64.218     0.200
     4.417    63.815     0.200
     4.417    64.136     0.200
     4.508    64.905     0.200
     4.508    65.543     0.200
     4.619    66.575     0.200
     4.787    69.966     0.200
     4.832    69.726     0.200
     4.832    70.104     0.200
     4.867    71.485     0.200
     4.921    72.105     0.200
     5.118    73.905     0.200
     5.189    74.445     0.200
     5.247    76.886     0.200
     5.247    76.043     0.200
     5.374    77.436     0.200
     5.441    78.875     0.200
     5.441    78.663     0.200
     5.507    78.995     0.200
     5.507    79.224     0.200
     5.597    79.766     0.200
     5.729    81.985     0.200
     5.780    83.115     0.200
     5.804    82.735     0.200
     5.804    83.030     0.200
     6.104    87.535     0.200
     6.248    89.255     0.200
     6.341    90.431     0.200
     6.357    90.705     0.200
     6.367    90.936     0.200
     6.421    91.436     0.200
     6.601    94.525     0.200
     6.674    95.085     0.200
     6.804    96.815     0.200
     6.848    97.396     0.200
     7.163   101.125     0.200
     7.163   100.899     0.200
     7.177   101.249     0.200
     7.281   102.125     0.200
     7.291   101.306     0.200
     7.344   103.726     0.200
     7.344   104.000     0.200
     7.435   103.396     0.200
     7.596   107.115     0.200
     7.601   105.575     0.200
     7.780   109.556     0.200
     7.781   108.834     0.200
     7.957   113.501     0.200
     7.971   112.155     0.200
     7.971   113.167     0.200
     7.989   112.405     0.200
     7.999   113.226     0.200
     8.041   114.286     0.200
     8.282   116.914     0.200
     8.989   125.871     0.200
     1.348    23.250     0.200
     1.807    29.875     0.200
     1.988    32.234     0.200
     2.149    33.891     0.200
     2.221    34.516     0.200
     2.340    36.820     0.200
     2.427    38.273     0.200
     2.440    38.883     0.200
     2.619    39.883     0.200
     2.599    40.156     0.200
     2.622    40.211     0.200
     2.622    40.453     0.200
     2.701    41.648     0.200
     2.758    42.625     0.200
     2.828    43.992     0.200
     2.849    42.781     0.200
     2.907    44.875     0.200
     3.000    45.820     0.200
     3.115    47.242     0.200
     3.221    47.367     0.200
     3.214    48.375     0.200
     3.345    50.688     0.200
     3.432    50.914     0.200
     3.480    50.594     0.200
     3.480    52.367     0.200
     3.499    51.641     0.200
     3.542    53.258     0.200
     3.566    54.406     0.200
     3.566    54.055     0.200
     3.727    55.906     0.200
     3.727    56.016     0.200
     3.763    54.797     0.200
     3.829    55.602     0.200
     3.829    55.438     0.200
     3.833    55.734     0.200
     3.833    55.562     0.200
     3.822    57.078     0.200
     3.931    58.617     0.200
     3.948    58.312     0.200
     4.040    59.773     0.200
     4.062    59.570     0.200
     4.154    60.602     0.200
     4.190    61.688     0.200
     4.190    61.961     0.200
     4.290    62.711     0.200
     4.290    62.883     0.200
     4.609    66.703     0.200
     4.638    67.086     0.200
     4.638    66.984     0.200
     4.641    67.281     0.200
     4.636    68.766     0.200
     4.649    67.953     0.200
     4.649    68.188     0.200
     4.744    68.664     0.200
     4.744    68.508     0.200
     4.748    69.453     0.200
     4.748    69.148     0.200
     4.769    69.805     0.200
     4.843    70.141     0.200
     4.922    70.086     0.200
     4.922    70.461     0.200
     4.922    70.211     0.200
     4.991    72.070     0.200
     5.111    74.211     0.200
     5.093    74.266     0.200
     5.137    74.344     0.200
     5.241    76.367     0.200
     5.241    76.172     0.200
     5.260    77.562     0.200
     5.260    75.984     0.200
     5.288    77.250     0.200
     5.359    77.484     0.200
     5.359    77.273     0.200
     5.612    79.617     0.200
     5.770    83.812     0.200
     5.770    83.328     0.200
     5.875    84.445     0.200
     5.875    85.188     0.200
     5.972    85.977     0.200
     6.045    87.031     0.200
     6.044    86.906     0.200
     6.176    88.211     0.200
     6.176    88.727     0.200
     6.172    89.070     0.200
     6.172    88.812     0.200
     6.298    91.312     0.200
     6.305    90.727     0.200
     6.305    90.227     0.200
     6.314    90.414     0.200
     6.378    91.516     0.200
     6.398    92.711     0.200
     6.671    96.141     0.200
     6.640    95.547     0.200
     6.657    95.172     0.200
     6.657    94.625     0.200
     6.676    96.141     0.200
     6.670    95.570     0.200
     6.670    95.469     0.200
     6.702    96.523     0.200
     6.702    96.164     0.200
     6.907    98.586     0.200
     6.907    99.328     0.200
     6.890    98.047     0.200
     6.890    98.656     0.200
     6.973   100.234     0.200
     6.973   100.047     0.200
     7.029   101.062     0.200
     7.029   101.461     0.200
     7.071   101.656     0.200
     7.131   101.516     0.200
     7.160   102.562     0.200
     7.186   102.992     0.200
     7.201   102.977     0.200
     7.201   102.867     0.200
     7.309   105.391     0.200
     7.309   105.695     0.200
     7.310   104.945     0.200
     7.335   105.125     0.200
     7.471   106.711     0.200
     7.471   106.961     0.200
     7.540   108.422     0.200
     7.520   106.844     0.200
     7.522   106.836     0.200
     7.592   109.641     0.200
     7.592   109.961     0.200
     7.633   109.242     0.200
     7.633   110.320     0.200
     7.743   111.102     0.200
     7.726   109.188     0.200
     7.769   111.242     0.200
     7.820   111.195     0.200
     7.820   111.695     0.200
     7.836   111.641     0.200
     7.821   111.305     0.200
     7.831   111.125     0.200
     7.880   112.047     0.200
     7.934   113.055     0.200
     7.936   112.922     0.200
     7.936   113.180     0.200
     7.945   112.812     0.200
     7.945   113.062     0.200
     7.970   112.406     0.200
     7.979   113.086     0.200
     7.979   112.414     0.200
     7.979   113.336     0.200
     7.985   113.766     0.200
     8.039   114.008     0.200
     8.078   115.250     0.200
     8.106   117.211     0.200
     8.210   116.195     0.200
     8.224   116.781     0.200
     8.224   115.711     0.200
     8.433   119.883     0.200
     8.433   118.938     0.200
     8.417   119.211     0.200
     8.417   118.953     0.200
     8.442   120.047     0.200
     8.442   119.664     0.200
     8.425   119.164     0.200
     8.425   118.664     0.200
     8.502   120.898     0.200
     8.675   122.352     0.200
     8.678   123.812     0.200
     8.690   123.680     0.200
     8.672   122.836     0.200
     8.692   122.805     0.200
     8.692   122.578     0.200
     8.727   121.562     0.200
     8.727   122.445     0.200
     8.775   124.297     0.200
     8.841   125.047     0.200
     8.858   126.117     0.200
     8.858   125.242     0.200
     8.896   126.438     0.200
     8.896   125.977     0.200
     9.080   128.422     0.200
     9.173   130.445     0.200
     9.203   131.133     0.200
     9.203   131.305     0.200
     9.187   130.344     0.200
     9.187   130.180     0.200
     9.247   129.211     0.200
     9.247   129.016     0.200
     9.270   131.711     0.200
     9.270   131.531     0.200
     9.304   132.422     0.200
     9.304   132.195     0.200
     9.300   131.562     0.200
     9.395   133.805     0.200
     9.433   133.320     0.200
     9.439   134.211     0.200
     9.542   134.320     0.200
     9.598   135.797     0.200
     9.645   135.922     0.200
     9.670   137.781     0.200
     9.670   137.922     0.200
     9.714   137.273     0.200
     9.737   137.312     0.200
     9.798   138.664     0.200
     9.815   139.211     0.200
     9.907   140.570     0.200
     9.967   140.680     0.200
    10.035   141.852     0.200
    10.008   140.734     0.200
    10.048   141.766     0.200
    10.288   146.086     0.200
    10.288   146.258     0.200
    10.304   145.734     0.200
    10.304   145.242     0.200
    10.281   145.977     0.200
    10.332   146.188     0.200
    10.492   147.367     0.200
    10.497   147.031     0.200
    10.556   148.234     0.200
    10.556   148.016     0.200
    10.570   148.789     0.200
    10.629   148.375     0.200
    10.745   151.891     0.200
    10.773   152.156     0.200
    10.805   150.203     0.200
    10.805   149.961     0.200
    10.788   150.977     0.200
    10.805   152.086     0.200
    10.810   151.688     0.200
    10.979   153.906     0.200
    10.979   153.625     0.200
    10.990   154.148     0.200
    11.116   156.336     0.200
    11.143   158.477     0.200
    11.143   157.523     0.200
    11.319   158.867     0.200
    11.392   160.586     0.200
    11.487   161.297     0.200
    11.667   162.820     0.200
    11.700   165.523     0.200
    11.769   165.133     0.200
    11.817   166.305     0.200
    11.841   167.023     0.200
    11.931   168.461     0.200
    11.931   168.711     0.200
    11.931   167.938     0.200
    11.998   168.477     0.200
    12.031   168.523     0.200
    11.988   168.352     0.200
    12.271   173.047     0.200
    12.329   172.523     0.200
    12.386   175.398     0.200
    12.605   175.953     0.200
    12.754   178.258     0.200
    12.971   181.883     0.200
    13.103   181.945     0.200
    13.154   184.961     0.200
    13.107   182.992     0.200
    13.293   186.039     0.200
    13.940   195.016     0.200
    13.940   194.305     0.200
    13.940   194.727     0.200
    15.067   208.727     0.200
    15.332   212.562     0.200
    17.314   237.211     0.200
     0.461    10.170     0.200
     1.069    18.520     0.200
     1.507    24.080     0.200
     1.623    26.271     0.200
     1.766    28.525     0.200
     1.847    29.600     0.200
     1.847    30.234     0.200
     1.938    29.973     0.200
     2.085    31.611     0.200
     2.372    35.869     0.200
     2.372    36.154     0.200
     2.508    36.049     0.200
     2.828    41.729     0.200
     2.863    43.609     0.200
     2.872    43.750     0.200
     2.872    44.023     0.200
     2.933    44.029     0.200
     3.105    46.705     0.200
     3.104    46.629     0.200
     3.104    46.756     0.200
     3.086    46.746     0.200
     3.160    46.629     0.200
     3.174    47.379     0.200
     3.264    47.865     0.200
     3.442    51.830     0.200
     3.564    53.459     0.200
     3.727    55.570     0.200
     3.871    55.840     0.200
     3.871    56.068     0.200
     3.967    57.850     0.200
     3.982    59.730     0.200
     3.982    59.402     0.200
     3.967    58.510     0.200
     3.967    57.234     0.200
     4.078    59.830     0.200
     4.083    59.469     0.200
     4.161    60.803     0.200
     4.225    61.646     0.200
     4.225    62.250     0.200
     4.555    66.457     0.200
     4.589    66.750     0.200
     4.589    66.416     0.200
     4.637    65.945     0.200
     4.701    68.510     0.200
     4.701    68.312     0.200
     4.717    69.299     0.200
     4.818    70.129     0.200
     4.818    70.314     0.200
     4.820    70.980     0.200
     4.820    70.799     0.200
     4.806    69.119     0.200
     5.065    73.219     0.200
     5.065    73.066     0.200
     5.109    73.939     0.200
     5.109    74.672     0.200
     5.171    73.709     0.200
     5.171    73.920     0.200
     5.203    74.359     0.200
     5.395    78.463     0.200
     5.561    79.859     0.200
     5.561    80.039     0.200
     5.547    79.049     0.200
     5.547    79.500     0.200
     5.547    78.906     0.200
     5.660    83.029     0.200
     5.660    81.143     0.200
     5.718    81.910     0.200
     5.892    84.980     0.200
     5.892    85.348     0.200
     5.867    83.869     0.200
     5.867    84.055     0.200
     5.924    85.480     0.200
     5.924    85.900     0.200
     5.891    84.359     0.200
     6.077    86.520     0.200
     6.077    86.904     0.200
     6.275    90.279     0.200
     6.275    90.100     0.200
     6.417    91.490     0.200
     6.417    92.119     0.200
     6.430    91.580     0.200
     6.430    92.361     0.200
     6.645    94.740     0.200
     6.645    95.227     0.200
     6.661    95.449     0.200
     6.631    94.539     0.200
     6.631    94.197     0.200
     6.840    97.580     0.200
     6.860    97.670     0.200
     6.835    97.439     0.200
     6.859    97.619     0.200
     6.977    99.857     0.200
     7.124   101.230     0.200
     7.124   101.469     0.200
     7.119   101.889     0.200
     7.119   101.455     0.200
     7.186   101.980     0.200
     7.186   102.127     0.200
     7.170   101.779     0.200
     7.228   102.379     0.200
     7.249   102.959     0.200
     7.298   103.240     0.200
     7.298   103.412     0.200
     7.448   105.119     0.200
     7.535   107.449     0.200
     7.588   107.250     0.200
     7.635   108.316     0.200
     7.638   107.980     0.200
     7.720   109.969     0.200
     7.720   109.350     0.200
     7.787   110.590     0.200
     7.787   110.812     0.200
     7.762   107.930     0.200
     7.762   108.344     0.200
     7.728   109.100     0.200
     7.875   112.527     0.200
     7.829   110.389     0.200
     7.829   110.447     0.200
     7.904   110.170     0.200
     7.904   110.477     0.200
     7.953   111.480     0.200
     8.006   114.740     0.200
     8.006   114.885     0.200
     8.075   114.480     0.200
     8.120   114.379     0.200
     8.120   114.145     0.200
     8.119   114.959     0.200
     8.078   114.498     0.200
     8.111   115.660     0.200
     8.111   115.406     0.200
     8.092   113.959     0.200
     8.170   115.180     0.200
     8.170   114.938     0.200
     8.164   114.070     0.200
     8.144   114.250     0.200
     8.144   114.799     0.200
     8.144   114.547     0.200
     8.229   115.969     0.200
     8.364   117.230     0.200
     8.364   118.000     0.200
     8.364   117.100     0.200
     8.378   117.510     0.200
     8.390   117.230     0.200
     8.390   117.500     0.200
     8.377   119.027     0.200
     8.452   117.520     0.200
     8.464   120.027     0.200
     8.499   119.061     0.200
     8.499   119.955     0.200
     8.537   120.355     0.200
     8.554   120.670     0.200
     8.554   120.982     0.200
     8.607   121.400     0.200
     8.607   121.289     0.200
     8.660   121.510     0.200
     8.660   121.398     0.200
     8.694   123.014     0.200
     8.779   122.920     0.200
     8.917   125.340     0.200
     9.018   126.389     0.200
     8.986   128.621     0.200
     9.114   129.480     0.200
     9.114   128.547     0.200
     9.274   130.430     0.200
     9.274   130.994     0.200
     9.251   129.859     0.200
     9.251   129.344     0.200
     9.387   132.320     0.200
     9.387   131.951     0.200
     9.344   131.830     0.200
     9.452   133.416     0.200
     9.439   133.758     0.200
     9.519   134.537     0.200
     9.634   135.656     0.200
     9.651   134.115     0.200
     9.762   136.549     0.200
     9.762   136.152     0.200
     9.729   136.275     0.200
     9.830   136.674     0.200
     9.925   139.199     0.200
     9.973   139.848     0.200
    10.000   140.098     0.200
    10.034   141.010     0.200
    10.118   140.359     0.200
    10.161   142.039     0.200
    10.160   142.799     0.200
    10.160   143.699     0.200
    10.160   141.609     0.200
    10.321   143.639     0.200
    10.321   143.451     0.200
    10.275   144.090     0.200
    10.275   144.633     0.200
    10.366   144.020     0.200
    10.335   145.670     0.200
    10.391   144.176     0.200
    10.400   145.195     0.200
    10.481   147.836     0.200
    10.587   148.307     0.200
    10.575   147.832     0.200
    10.742   151.670     0.200
    10.838   150.967     0.200
    10.907   152.037     0.200
    10.984   153.674     0.200
    10.991   153.439     0.200
    11.122   155.131     0.200
    11.092   155.666     0.200
    11.185   155.363     0.200
    11.222   155.926     0.200
    11.181   156.799     0.200
    11.212   157.529     0.200
    11.212   157.779     0.200
    11.305   156.684     0.200
    11.334   158.100     0.200
    11.566   160.996     0.200
    11.546   161.014     0.200
    11.697   163.070     0.200
    11.655   163.139     0.200
    11.655   163.580     0.200
    11.718   161.840     0.200
    12.006   166.820     0.200
    12.365   173.709     0.200
    12.365   173.357     0.200
    12.482   174.355     0.200
    12.734   175.127     0.200
    12.887   177.791     0.200
    12.917   179.045     0.200
    12.903   180.600     0.200
    12.903   180.900     0.200
    13.373   185.738     0.200
    13.475   187.209     0.200
    13.955   192.164     0.200
    14.317   196.801     0.200
    14.570   201.822     0.200
    14.570   202.830     0.200
    14.570   201.146     0.200
    15.872   218.340     0.200
    16.315   225.232     0.200
    17.997   245.629     0.200
    17.997   244.219     0.200
    19.077   259.160     0.200
    19.387   263.420     0.200
     0.429     9.960     0.200
     0.429    10.128     0.200
     0.871    15.829     0.200
     0.871    15.970     0.200
     1.303    21.735     0.200
     1.332    21.960     0.200
     1.373    22.735     0.200
     1.503    24.860     0.200
     1.562    25.561     0.200
     1.562    25.962     0.200
     1.910    29.811     0.200
     1.929    30.360     0.200
     2.112    32.367     0.200
     2.313    36.412     0.200
     2.312    36.790     0.200
     2.312    36.375     0.200
     2.554    38.550     0.200
     2.554    38.669     0.200
     2.599    40.130     0.200
     2.599    40.290     0.200
     2.673    40.311     0.200
     2.647    39.530     0.200
     2.802    43.175     0.200
     2.897    43.240     0.200
     2.916    43.771     0.200
     3.156    48.340     0.200
     3.448    51.630     0.200
     3.699    54.090     0.200
     3.703    55.960     0.200
     3.810    56.351     0.200
     3.821    55.630     0.200
     3.941    57.980     0.200
     4.318    62.641     0.200
     4.421    64.690     0.200
     4.421    64.525     0.200
     4.552    65.500     0.200
     4.780    69.440     0.200
     4.901    69.641     0.200
     4.939    70.450     0.200
     4.939    70.658     0.200
     5.106    73.440     0.200
     5.293    75.851     0.200
     5.327    75.601     0.200
     5.606    81.780     0.200
     5.607    80.460     0.200
     5.607    80.345     0.200
     5.652    80.400     0.200
     5.656    80.400     0.200
     5.834    83.360     0.200
     5.993    87.010     0.200
     5.993    85.734     0.200
     6.045    86.320     0.200
     6.131    89.230     0.200
     6.131    87.880     0.200
     6.174    89.021     0.200
     6.360    91.370     0.200
     6.376    90.970     0.200
     6.396    91.200     0.200
     6.608    94.021     0.200
     6.640    94.280     0.200
     6.724    96.078     0.200
     6.842    96.000     0.200
     6.900    99.070     0.200
     6.899    96.900     0.200
     6.965    98.730     0.200
     7.021    99.720     0.200
     7.037    99.380     0.200
     7.332   103.780     0.200
     7.620   109.000     0.200
     7.671   107.530     0.200
     7.756   110.760     0.200
     7.809   109.380     0.200
     7.834   110.990     0.200
     7.841   110.950     0.200
     7.884   111.353     0.200
     8.095   113.480     0.200
     8.173   114.400     0.200
     8.173   115.110     0.200
     8.173   115.641     0.200
     8.236   116.351     0.200
     8.329   117.650     0.200
     8.632   123.190     0.200
     9.060   128.021     0.200
     9.109   127.910     0.200
     9.164   129.430     0.200
     9.666   134.740     0.200
    10.018   140.370     0.200
    10.530   149.110     0.200
    10.971   152.771     0.200
    10.982   154.750     0.200
    11.458   160.120     0.200
    14.306   201.660     0.200
    14.306   200.550     0.200
    17.740   242.910     0.200
    18.805   255.680     0.200
     1.359    24.434     0.200
     1.371    26.270     0.200
     1.484    26.965     0.200
     1.881    32.230     0.200
     1.931    32.500     0.200
     2.210    37.211     0.200
     2.386    39.590     0.200
     2.393    39.082     0.200
     2.548    41.340     0.200
     2.708    43.680     0.200
     2.665    43.215     0.200
     2.759    44.828     0.200
     2.826    46.559     0.200
     2.826    45.332     0.200
     3.165    50.559     0.200
     3.203    51.180     0.200
     3.227    52.121     0.200
     3.250    51.000     0.200
     3.338    53.320     0.200
     3.366    53.211     0.200
     3.366    52.660     0.200
     3.578    56.090     0.200
     3.650    57.621     0.200
     3.693    59.262     0.200
     3.693    59.023     0.200
     3.930    60.398     0.200
     3.930    59.957     0.200
     4.013    61.168     0.200
     4.025    62.930     0.200
     4.085    62.828     0.200
     4.085    62.457     0.200
     4.266    66.828     0.200
     4.437    68.691     0.200
     4.461    68.039     0.200
     4.461    67.887     0.200
     4.531    69.891     0.200
     4.531    69.293     0.200
     4.536    69.340     0.200
     4.536    69.105     0.200
     4.566    69.449     0.200
     4.718    71.496     0.200
     4.728    71.789     0.200
     4.843    72.539     0.200
     4.843    72.785     0.200
     4.861    73.836     0.200
     4.969    75.578     0.200
     4.969    74.957     0.200
     4.970    73.879     0.200
     4.974    74.191     0.200
     5.059    76.449     0.200
     5.112    77.148     0.200
     5.112    76.590     0.200
     5.112    76.297     0.200
     5.188    78.051     0.200
     5.188    77.477     0.200
     5.315    80.191     0.200
     5.500    82.895     0.200
     5.362    83.145     0.200
     5.522    82.441     0.200
     5.522    82.719     0.200
     5.628    86.121     0.200
     5.628    85.488     0.200
     5.705    84.891     0.200
     5.708    84.738     0.200
     5.708    84.590     0.200
     5.708    84.449     0.200
     5.866    87.660     0.200
     5.866    87.160     0.200
     5.927    88.141     0.200
     5.999    88.449     0.200
     6.146    92.070     0.200
     6.146    92.176     0.200
     6.151    90.949     0.200
     6.275    93.418     0.200
     6.275    92.578     0.200
     6.432    96.781     0.200
     6.443    96.051     0.200
     6.451    95.344     0.200
     6.572    97.109     0.200
     6.734    99.074     0.200
     6.745    98.695     0.200
     6.941   102.457     0.200
     6.962   103.219     0.200
     6.962   102.219     0.200
     7.008   103.371     0.200
     7.253   107.051     0.200
     7.275   106.520     0.200
     7.286   106.219     0.200
     7.286   106.520     0.200
     7.356   107.504     0.200
     7.430   108.988     0.200
     7.709   112.449     0.200
     7.809   114.734     0.200
     7.806   113.977     0.200
     7.858   115.289     0.200
     7.850   114.500     0.200
     7.864   115.070     0.200
     7.864   115.230     0.200
     7.875   115.051     0.200
     7.993   116.148     0.200
     7.993   115.766     0.200
     8.037   117.270     0.200
     8.037   117.691     0.200
     8.045   118.477     0.200
     8.118   117.891     0.200
     8.118   117.699     0.200
     8.171   118.941     0.200
     8.171   119.258     0.200
     8.193   118.660     0.200
     8.195   119.891     0.200
     8.195   118.859     0.200
     8.223   119.906     0.200
     8.285   120.715     0.200
     8.314   120.418     0.200
     8.314   120.020     0.200
     8.321   121.148     0.200
     8.236   121.020     0.200
     8.236   120.570     0.200
     8.395   121.359     0.200
     8.471   122.711     0.200
     8.471   122.852     0.200
     8.467   122.391     0.200
     8.467   122.055     0.200
     8.495   124.148     0.200
     8.495   123.375     0.200
     8.555   124.551     0.200
     8.555   124.238     0.200
     8.550   124.715     0.200
     8.567   124.441     0.200
     8.624   125.418     0.200
     8.624   125.078     0.200
     8.630   125.125     0.200
     8.679   127.207     0.200
     8.696   126.488     0.200
     8.779   127.477     0.200
     8.978   130.488     0.200
     8.978   130.098     0.200
     8.982   130.145     0.200
     9.054   131.418     0.200
     9.054   130.805     0.200
     9.108   131.426     0.200
     9.126   132.664     0.200
     9.210   134.973     0.200
     9.084   133.109     0.200
     9.229   133.645     0.200
     9.256   133.180     0.200
     9.256   133.473     0.200
     9.298   133.531     0.200
     9.298   133.328     0.200
     9.564   136.680     0.200
     9.609   138.535     0.200
     9.627   137.832     0.200
     9.680   140.113     0.200
     9.692   139.223     0.200
     9.748   140.668     0.200
     9.816   140.785     0.200
     9.909   141.133     0.200
     9.918   143.488     0.200
     9.918   142.188     0.200
     9.961   142.324     0.200
     9.981   143.309     0.200
    10.044   143.324     0.200
    10.092   145.590     0.200
    10.092   145.277     0.200
    10.074   143.469     0.200
    10.100   145.094     0.200
    10.161   145.426     0.200
    10.162   147.211     0.200
    10.162   146.652     0.200
    10.208   146.730     0.200
    10.210   147.098     0.200
    10.277   147.785     0.200
    10.348   148.766     0.200
    10.447   150.070     0.200
    10.447   149.926     0.200
    10.510   149.719     0.200
    10.510   151.691     0.200
    10.575   151.531     0.200
    10.575   151.738     0.200
    10.604   151.000     0.200
    10.683   153.875     0.200
    10.758   155.012     0.200
    10.805   155.793     0.200
    10.832   155.992     0.200
    10.843   154.652     0.200
    10.909   156.133     0.200
    10.954   157.207     0.200
    11.029   157.211     0.200
    11.016   157.504     0.200
    11.050   158.543     0.200
    11.083   158.820     0.200
    11.204   161.898     0.200
    11.204   160.387     0.200
    11.225   161.121     0.200
    11.225   160.613     0.200
    11.236   161.340     0.200
    11.336   161.977     0.200
    11.398   162.164     0.200
    11.394   162.680     0.200
    11.394   162.809     0.200
    11.514   163.574     0.200
    11.702   168.488     0.200
    11.788   168.023     0.200
    11.817   167.180     0.200
    11.817   168.422     0.200
    11.873   169.121     0.200
    11.873   169.691     0.200
    12.086   172.492     0.200
    12.084   171.109     0.200
    12.272   172.141     0.200
    12.342   175.625     0.200
    12.358   175.984     0.200
    12.494   178.211     0.200
    12.606   179.223     0.200
    12.739   180.625     0.200
    12.782   181.641     0.200
    12.893   183.551     0.200
    12.908   183.512     0.200
    13.167   187.188     0.200
    13.246   188.230     0.200
    13.295   189.488     0.200
    13.295   188.840     0.200
    13.295   190.020     0.200
    13.418   192.820     0.200
    13.824   197.887     0.200
    13.926   196.000     0.200
    13.926   197.137     0.200
    13.942   196.801     0.200
    14.529   204.539     0.200
    14.529   204.910     0.200
    16.196   228.078     0.200
    16.529   232.684     0.200
    17.994   249.012     0.200
    17.994   249.402     0.200
     1.353    25.352     0.200
     1.418    25.949     0.200
     1.581    27.602     0.200
     1.810    31.324     0.200
     1.858    31.355     0.200
     1.858    31.602     0.200
     2.150    36.250     0.200
     2.218    36.234     0.200
     2.218    37.754     0.200
     2.324    38.586     0.200
     2.477    40.227     0.200
     2.599    42.156     0.200
     2.646    42.504     0.200
     2.690    43.227     0.200
     2.690    43.703     0.200
     2.777    44.688     0.200
     2.777    46.141     0.200
     2.826    45.676     0.200
     2.846    46.695     0.200
     3.120    49.367     0.200
     3.160    50.164     0.200
     3.160    50.328     0.200
     3.164    51.156     0.200
     3.177    49.754     0.200
     3.177    49.902     0.200
     3.295    51.977     0.200
     3.295    51.871     0.200
     3.510    55.086     0.200
     3.722    58.867     0.200
     3.722    59.598     0.200
     3.811    60.496     0.200
     3.811    60.852     0.200
     3.888    59.867     0.200
     3.887    60.285     0.200
     3.950    61.324     0.200
     3.951    61.535     0.200
     3.963    61.574     0.200
     4.039    62.785     0.200
     4.282    66.410     0.200
     4.382    68.055     0.200
     4.390    66.926     0.200
     4.390    67.266     0.200
     4.484    67.906     0.200
     4.463    68.598     0.200
     4.463    68.855     0.200
     4.508    69.074     0.200
     4.508    69.512     0.200
     4.686    72.082     0.200
     4.657    70.395     0.200
     4.657    70.824     0.200
     4.797    73.336     0.200
     4.797    73.500     0.200
     4.912    73.914     0.200
     4.912    74.457     0.200
     4.949    73.117     0.200
     4.953    73.117     0.200
     4.989    75.000     0.200
     5.059    74.938     0.200
     5.059    76.430     0.200
     5.139    77.266     0.200
     5.261    77.566     0.200
     5.383    82.148     0.200
     5.439    80.664     0.200
     5.439    81.945     0.200
     5.470    81.785     0.200
     5.561    83.875     0.200
     5.561    83.562     0.200
     5.675    84.156     0.200
     5.818    86.027     0.200
     5.818    86.836     0.200
     5.856    86.727     0.200
     5.856    87.004     0.200
     6.110    90.004     0.200
     6.078    90.984     0.200
     6.078    91.258     0.200
     6.218    92.457     0.200
     6.367    94.656     0.200
     6.380    93.688     0.200
     6.380    94.707     0.200
     6.404    95.512     0.200
     6.504    94.934     0.200
     6.633    97.695     0.200
     6.695    98.195     0.200
     6.673    98.098     0.200
     6.673    98.234     0.200
     6.875   101.637     0.200
     6.875   102.363     0.200
     6.900   101.145     0.200
     6.934   101.027     0.200
     6.928   101.957     0.200
     6.985   101.305     0.200
     7.189   106.234     0.200
     7.241   105.797     0.200
     7.241   106.809     0.200
     7.235   106.207     0.200
     7.283   107.301     0.200
     7.344   107.707     0.200
     7.393   107.605     0.200
     7.399   108.195     0.200
     7.447   108.824     0.200
     7.645   110.098     0.200
     7.645   111.141     0.200
     7.711   111.805     0.200
     7.729   109.977     0.200
     7.765   112.047     0.200
     7.765   114.465     0.200
     7.754   113.984     0.200
     7.823   114.242     0.200
     7.826   113.504     0.200
     7.812   113.805     0.200
     7.796   113.164     0.200
     7.796   113.734     0.200
     7.850   114.348     0.200
     7.806   112.777     0.200
     7.806   113.375     0.200
     7.932   114.984     0.200
     7.933   114.027     0.200
     7.933   115.613     0.200
     7.943   114.996     0.200
     7.985   115.645     0.200
     8.000   118.199     0.200
     8.099   117.438     0.200
     8.099   117.188     0.200
     8.131   116.438     0.200
     8.131   118.914     0.200
     8.133   116.016     0.200
     8.133   118.312     0.200
     8.133   116.855     0.200
     8.165   117.117     0.200
     8.185   119.477     0.200
     8.185   118.988     0.200
     8.215   118.957     0.200
     8.215   119.133     0.200
     8.253   118.145     0.200
     8.253   117.727     0.200
     8.219   119.746     0.200
     8.219   118.957     0.200
     8.262   119.656     0.200
     8.297   120.574     0.200
     8.378   120.504     0.200
     8.452   121.484     0.200
     8.452   121.324     0.200
     8.420   122.355     0.200
     8.433   122.695     0.200
     8.518   124.289     0.200
     8.498   123.465     0.200
     8.498   124.305     0.200
     8.496   123.125     0.200
     8.581   125.312     0.200
     8.626   125.613     0.200
     8.651   126.824     0.200
     8.628   125.137     0.200
     8.628   125.965     0.200
     8.925   128.605     0.200
     8.963   129.781     0.200
     8.990   130.336     0.200
     8.990   131.242     0.200
     9.037   130.980     0.200
     9.077   129.906     0.200
     9.183   134.656     0.200
     9.205   133.418     0.200
     9.196   132.457     0.200
     9.196   133.082     0.200
     9.285   133.117     0.200
     9.285   133.418     0.200
     9.496   138.156     0.200
     9.586   138.066     0.200
     9.558   138.145     0.200
     9.645   138.750     0.200
     9.637   138.086     0.200
     9.637   138.555     0.200
     9.731   140.023     0.200
     9.744   139.746     0.200
     9.844   143.094     0.200
     9.867   142.637     0.200
     9.867   142.883     0.200
     9.934   143.199     0.200
     9.969   143.258     0.200
     9.976   143.695     0.200
     9.976   144.094     0.200
    10.073   143.137     0.200
    10.048   144.434     0.200
    10.063   144.605     0.200
    10.091   144.504     0.200
    10.094   142.977     0.200
    10.147   145.293     0.200
    10.256   146.590     0.200
    10.294   146.898     0.200
    10.414   149.547     0.200
    10.414   147.930     0.200
    10.498   150.473     0.200
    10.550   150.285     0.200
    10.550   150.906     0.200
    10.537   150.520     0.200
    10.643   154.160     0.200
    10.734   154.816     0.200
    10.776   154.684     0.200
    10.782   152.930     0.200
    10.840   153.172     0.200
    10.950   156.781     0.200
    11.018   158.039     0.200
    10.965   156.668     0.200
    10.983   157.426     0.200
    11.021   158.848     0.200
    11.177   160.848     0.200
    11.179   160.605     0.200
    11.324   160.824     0.200
    11.365   161.715     0.200
    11.365   161.199     0.200
    11.449   164.094     0.200
    11.632   166.410     0.200
    11.766   168.055     0.200
    11.801   166.645     0.200
    11.801   168.219     0.200
    11.845   168.426     0.200
    11.845   167.945     0.200
    12.281   174.211     0.200
    12.427   177.477     0.200
    12.537   178.973     0.200
    12.727   180.215     0.200
    12.779   183.016     0.200
    12.840   183.062     0.200
    12.879   182.441     0.200
    13.145   185.906     0.200
    13.102   184.371     0.200
    13.180   187.711     0.200
    13.289   189.699     0.200
    13.289   189.047     0.200
    13.891   196.723     0.200
    14.475   201.727     0.200
    14.475   203.996     0.200
    14.475   204.332     0.200
    16.180   228.676     0.200
    16.499   232.445     0.200
    18.931   262.375     0.200
     0.737    19.215     0.200
     0.940    20.633     0.200
     1.357    24.434     0.200
     1.392    25.844     0.200
     1.415    26.773     0.200
     1.494    26.074     0.200
     1.720    29.895     0.200
     1.731    29.613     0.200
     1.998    33.965     0.200
     2.106    34.871     0.200
     2.234    36.652     0.200
     2.274    36.582     0.200
     2.340    37.715     0.200
     2.378    37.484     0.200
     2.444    38.281     0.200
     2.947    44.824     0.200
     2.936    47.055     0.200
     3.033    46.434     0.200
     3.081    46.895     0.200
     3.176    47.543     0.200
     3.261    48.973     0.200
     3.435    52.102     0.200
     3.505    53.242     0.200
     3.609    54.164     0.200
     3.646    54.133     0.200
     3.709    55.863     0.200
     3.861    57.672     0.200
     4.019    59.352     0.200
     4.039    58.984     0.200
     4.208    61.121     0.200
     4.324    63.492     0.200
     4.434    64.305     0.200
     4.406    63.922     0.200
     4.462    65.703     0.200
     4.467    65.762     0.200
     4.520    66.824     0.200
     4.605    68.441     0.200
     4.632    67.004     0.200
     4.901    71.871     0.200
     5.008    72.223     0.200
     5.039    73.094     0.200
     5.121    75.102     0.200
     5.259    75.672     0.200
     5.369    77.215     0.200
     5.418    77.965     0.200
     5.439    78.531     0.200
     5.607    80.492     0.200
     5.720    82.781     0.200
     5.922    84.562     0.200
     5.979    85.504     0.200
     5.974    85.844     0.200
     6.250    89.145     0.200
     6.249    88.652     0.200
     6.329    90.781     0.200
     6.404    91.984     0.200
     6.579    93.441     0.200
     6.704    93.734     0.200
     6.777    96.883     0.200
     6.802    94.762     0.200
     6.840    96.832     0.200
     6.847    97.371     0.200
     7.021   100.262     0.200
     7.019   100.852     0.200
     7.016    98.062     0.200
     7.022    98.723     0.200
     7.103   101.203     0.200
     7.130   102.094     0.200
     7.157   100.422     0.200
     7.197   100.781     0.200
     7.209   103.312     0.200
     7.199   101.633     0.200
     7.202   101.844     0.200
     7.233   101.691     0.200
     7.257   103.363     0.200
     7.329   103.863     0.200
     7.336   102.484     0.200
     7.336   102.555     0.200
     7.358   103.684     0.200
     7.344   102.543     0.200
     7.465   106.484     0.200
     7.509   105.113     0.200
     7.502   105.082     0.200
     7.542   106.992     0.200
     7.570   106.305     0.200
     7.605   108.512     0.200
     7.605   106.895     0.200
     7.759   108.965     0.200
     7.816   110.914     0.200
     7.834   110.512     0.200
     7.920   110.973     0.200
     8.009   113.293     0.200
     8.026   112.941     0.200
     8.047   113.672     0.200
     8.062   114.645     0.200
     8.257   116.914     0.200
     8.280   116.074     0.200
     8.755   122.312     0.200
     8.851   125.555     0.200
     9.217   128.262     0.200
     9.265   130.465     0.200
     9.748   137.672     0.200
    10.086   139.473     0.200
    10.410   144.332     0.200
    12.914   176.723     0.200
     0.308     8.502     0.200
     0.602    11.381     0.200
     0.721    13.621     0.200
     1.026    18.400     0.200
     1.045    18.570     0.200
     1.052    18.650     0.200
     1.069    19.502     0.200
     1.189    19.012     0.200
     1.190    20.262     0.200
     1.213    20.541     0.200
     1.207    20.502     0.200
     1.207    20.332     0.200
     1.282    21.891     0.200
     1.304    22.041     0.200
     1.304    21.861     0.200
     1.401    23.051     0.200
     1.413    23.781     0.200
     1.451    24.252     0.200
     1.595    25.922     0.200
     1.649    26.551     0.200
     1.625    26.262     0.200
     1.636    25.480     0.200
     1.652    26.650     0.200
     1.699    26.912     0.200
     1.714    27.711     0.200
     1.946    30.191     0.200
     2.051    32.361     0.200
     2.082    32.252     0.200
     2.086    32.961     0.200
     2.094    33.361     0.200
     2.196    34.320     0.200
     2.224    34.922     0.200
     2.504    37.691     0.200
     2.597    39.721     0.200
     2.638    39.781     0.200
     2.805    42.811     0.200
     2.807    42.432     0.200
     2.839    43.432     0.200
     2.850    42.871     0.200
     2.901    44.102     0.200
     2.917    44.691     0.200
     2.951    44.740     0.200
     3.016    45.201     0.200
     3.080    46.061     0.200
     3.126    46.602     0.200
     3.169    47.672     0.200
     3.262    49.201     0.200
     3.524    52.721     0.200
     3.633    53.941     0.200
     3.640    53.561     0.200
     3.670    54.281     0.200
     3.709    53.801     0.200
     3.720    55.051     0.200
     3.914    57.832     0.200
     3.958    58.551     0.200
     4.097    59.932     0.200
     4.409    63.900     0.200
     4.547    66.871     0.200
     4.651    67.441     0.200
     4.928    71.201     0.200
     5.040    73.121     0.200
     5.073    74.512     0.200
     5.226    76.002     0.200
     5.235    75.752     0.200
     5.273    76.561     0.200
     5.404    78.031     0.200
     5.455    77.881     0.200
     5.503    78.932     0.200
     5.532    80.041     0.200
     5.688    81.682     0.200
     5.737    82.162     0.200
     5.810    84.191     0.200
     5.861    83.971     0.200
     5.911    84.352     0.200
     6.031    86.441     0.200
     6.230    89.412     0.200
     6.412    91.900     0.200
     6.485    91.811     0.200
     6.515    92.201     0.200
     6.612    94.682     0.200
     6.666    95.082     0.200
     6.725    95.332     0.200
     6.749    95.711     0.200
     6.949    98.461     0.200
     6.986    98.961     0.200
     7.024    99.291     0.200
     7.003    99.150     0.200
     7.003    99.561     0.200
     7.038   101.051     0.200
     7.128   102.111     0.200
     7.146   101.951     0.200
     7.186   101.922     0.200
     7.310   103.012     0.200
     7.651   108.650     0.200
     8.644   123.012     0.200
     9.074   128.922     0.200
     9.813   138.311     0.200
     1.319    23.043     0.200
     1.367    24.062     0.200
     1.401    24.062     0.200
     1.437    25.812     0.200
     1.449    25.902     0.200
     1.465    26.453     0.200
     1.466    25.844     0.200
     1.475    26.633     0.200
     1.601    27.684     0.200
     1.601    27.812     0.200
     1.822    30.652     0.200
     1.847    30.676     0.200
     1.849    30.645     0.200
     1.978    31.445     0.200
     1.933    32.004     0.200
     1.939    31.723     0.200
     1.962    31.613     0.200
     2.203    34.883     0.200
     2.165    34.734     0.200
     2.200    36.094     0.200
     2.203    35.594     0.200
     2.258    35.543     0.200
     2.255    35.844     0.200
     2.326    37.035     0.200
     2.333    37.312     0.200
     2.390    39.164     0.200
     2.371    37.645     0.200
     2.398    37.836     0.200
     2.477    39.695     0.200
     2.592    39.402     0.200
     2.830    43.562     0.200
     2.824    44.434     0.200
     2.801    43.375     0.200
     2.826    43.863     0.200
     2.856    44.043     0.200
     2.913    44.613     0.200
     2.878    44.793     0.200
     2.917    45.164     0.200
     2.910    45.383     0.200
     2.934    45.164     0.200
     3.101    47.723     0.200
     3.131    48.355     0.200
     3.263    49.785     0.200
     3.277    50.125     0.200
     3.365    50.746     0.200
     3.402    51.086     0.200
     3.432    52.465     0.200
     3.462    52.266     0.200
     3.585    53.715     0.200
     3.527    53.586     0.200
     3.606    54.293     0.200
     3.619    54.723     0.200
     3.748    56.086     0.200
     3.867    58.375     0.200
     3.842    57.812     0.200
     3.937    58.293     0.200
     3.998    60.285     0.200
     4.140    61.734     0.200
     4.188    62.945     0.200
     4.293    63.895     0.200
     4.364    64.844     0.200
     4.331    65.035     0.200
     4.533    68.062     0.200
     4.544    67.613     0.200
     4.627    68.703     0.200
     4.678    68.805     0.200
     4.718    69.844     0.200
     4.664    69.543     0.200
     4.873    71.555     0.200
     4.897    72.086     0.200
     5.028    73.793     0.200
     5.062    74.043     0.200
     5.156    75.965     0.200
     5.107    75.836     0.200
     5.217    76.285     0.200
     5.161    75.645     0.200
     5.273    77.062     0.200
     5.188    76.695     0.200
     5.290    77.113     0.200
     5.428    80.094     0.200
     5.489    81.113     0.200
     5.584    81.855     0.200
     5.692    83.266     0.200
     5.791    84.465     0.200
     5.771    84.676     0.200
     5.736    83.223     0.200
     5.942    86.574     0.200
     5.861    85.746     0.200
     5.904    86.926     0.200
     5.964    87.176     0.200
     6.084    89.805     0.200
     6.066    88.902     0.200
     6.149    89.023     0.200
     6.223    89.902     0.200
     6.261    91.305     0.200
     6.227    91.133     0.200
     6.302    90.246     0.200
     6.301    91.676     0.200
     6.352    93.754     0.200
     6.417    93.094     0.200
     6.399    93.203     0.200
     6.518    94.254     0.200
     6.505    93.805     0.200
     6.612    95.812     0.200
     6.629    96.824     0.200
     6.637    96.734     0.200
     6.674    97.094     0.200
     6.716    97.625     0.200
     6.718    97.625     0.200
     6.806    97.926     0.200
     6.749    98.523     0.200
     6.749    97.754     0.200
     6.754    98.844     0.200
     6.759    98.375     0.200
     6.867    99.676     0.200
     6.850    98.516     0.200
     7.137   102.496     0.200
     7.174   103.324     0.200
     7.329   105.145     0.200
     7.558   107.805     0.200
     7.513   107.363     0.200
     7.660   110.594     0.200
     7.650   110.633     0.200
     7.706   110.664     0.200
     7.943   114.383     0.200
     8.405   120.145     0.200
     8.677   124.383     0.200
     8.925   125.516     0.200
     8.889   126.625     0.200
     9.235   131.746     0.200
     9.300   132.766     0.200
     9.577   135.574     0.200
     9.604   138.125     0.200
     9.712   138.305     0.200
     1.709    28.567     0.200
     2.104    34.152     0.200
     2.104    34.867     0.200
     2.176    35.187     0.200
     2.194    34.393     0.200
     2.720    42.553     0.200
     2.774    43.957     0.200
     2.774    43.723     0.200
     2.774    43.918     0.200
     2.802    43.383     0.200
     2.860    44.133     0.200
     3.000    45.492     0.200
     2.981    45.713     0.200
     3.263    49.902     0.200
     3.282    48.333     0.200
     3.421    51.912     0.200
     3.566    54.583     0.200
     3.601    53.633     0.200
     3.881    57.263     0.200
     4.040    60.662     0.200
     4.156    62.423     0.200
     4.295    64.753     0.200
     4.444    65.473     0.200
     4.533    66.282     0.200
     4.666    68.633     0.200
     4.991    72.532     0.200
     4.998    73.543     0.200
     5.020    72.833     0.200
     5.020    74.263     0.200
     5.096    74.963     0.200
     5.098    74.093     0.200
     5.225    76.272     0.200
     5.373    78.242     0.200
     5.415    80.103     0.200
     5.621    82.143     0.200
     5.729    83.713     0.200
     6.012    87.853     0.200
     6.147    89.473     0.200
     6.238    90.522     0.200
     6.282    90.902     0.200
     6.393    91.963     0.200
     6.399    92.072     0.200
     6.513    94.282     0.200
     6.538    94.982     0.200
     6.653    95.933     0.200
     6.663    96.623     0.200
     6.718    96.723     0.200
     7.049   100.312     0.200
     7.096   102.123     0.200
     7.169   102.933     0.200
     7.202   103.893     0.200
     7.259   104.503     0.200
     7.334   105.263     0.200
     7.447   106.822     0.200
     7.692   110.782     0.200
     7.850   112.782     0.200
     7.899   113.473     0.200
     7.899   112.162     0.200
     7.970   116.343     0.200
     8.014   114.532     0.200
     8.106   114.952     0.200
     8.200   116.683     0.200
     8.258   118.692     0.200
     8.284   118.692     0.200
     8.306   118.692     0.200
     8.349   118.713     0.200
     8.361   119.263     0.200
     8.361   117.831     0.200
     8.413   119.482     0.200
     8.491   120.713     0.200
     8.604   122.022     0.200
     8.736   125.753     0.200
     8.781   125.143     0.200
     8.797   125.643     0.200
     9.125   129.683     0.200
     9.460   135.072     0.200
     9.568   136.532     0.200
    11.186   157.992     0.200
    12.156   172.492     0.200
    14.317   202.293     0.200
     1.635    28.008     0.200
     2.040    34.035     0.200
     2.040    33.930     0.200
     2.782    42.246     0.200
     2.643    41.875     0.200
     2.704    43.207     0.200
     2.726    43.676     0.200
     2.726    43.348     0.200
     2.806    43.316     0.200
     2.806    43.484     0.200
     3.036    46.305     0.200
     2.923    44.867     0.200
     2.904    45.055     0.200
     3.027    46.387     0.200
     3.110    48.895     0.200
     3.205    49.258     0.200
     3.355    51.355     0.200
     3.555    53.008     0.200
     3.493    53.777     0.200
     3.525    52.297     0.200
     3.525    52.148     0.200
     3.686    55.273     0.200
     3.931    58.430     0.200
     3.804    56.715     0.200
     3.804    56.516     0.200
     3.866    59.078     0.200
     3.866    59.297     0.200
     3.974    60.234     0.200
     4.098    61.766     0.200
     4.092    60.328     0.200
     4.092    60.598     0.200
     4.095    60.348     0.200
     4.095    61.707     0.200
     4.221    62.426     0.200
     4.236    63.586     0.200
     4.344    64.945     0.200
     4.417    65.945     0.200
     4.417    66.207     0.200
     4.367    64.375     0.200
     4.367    64.547     0.200
     4.729    67.195     0.200
     4.729    67.805     0.200
     4.729    67.078     0.200
     4.457    65.336     0.200
     4.457    65.453     0.200
     4.590    67.578     0.200
     4.590    67.828     0.200
     4.775    70.758     0.200
     4.827    71.664     0.200
     4.926    73.047     0.200
     4.914    71.645     0.200
     4.944    72.734     0.200
     4.944    72.406     0.200
     4.943    71.805     0.200
     4.943    72.207     0.200
     4.943    72.086     0.200
     5.027    74.230     0.200
     5.097    75.672     0.200
     5.028    73.375     0.200
     5.028    73.148     0.200
     5.148    74.605     0.200
     5.296    76.605     0.200
     5.296    77.273     0.200
     5.347    78.227     0.200
     5.347    78.707     0.200
     5.415    78.930     0.200
     5.430    78.918     0.200
     5.557    81.430     0.200
     5.545    81.016     0.200
     5.560    81.668     0.200
     5.560    81.117     0.200
     5.656    81.938     0.200
     5.938    86.699     0.200
     6.001    87.055     0.200
     6.072    88.617     0.200
     6.474    91.227     0.200
     6.474    92.305     0.200
     6.166    89.066     0.200
     6.217    89.508     0.200
     6.217    90.305     0.200
     6.217    90.145     0.200
     6.199    89.668     0.200
     6.442    93.328     0.200
     6.463    93.098     0.200
     6.587    95.184     0.200
     6.585    94.934     0.200
     6.598    95.746     0.200
     6.926    99.223     0.200
     6.973    99.426     0.200
     6.973   100.395     0.200
     7.004   100.684     0.200
     7.029   100.973     0.200
     7.145   103.035     0.200
     7.184   102.598     0.200
     7.263   104.816     0.200
     7.263   104.305     0.200
     7.265   103.867     0.200
     7.424   107.008     0.200
     7.424   106.461     0.200
     7.439   106.883     0.200
     7.430   108.305     0.200
     7.607   109.918     0.200
     7.607   110.117     0.200
     7.615   109.906     0.200
     7.622   109.375     0.200
     8.026   113.117     0.200
     7.775   111.055     0.200
     7.813   112.758     0.200
     7.822   110.801     0.200
     7.854   113.449     0.200
     7.937   113.746     0.200
     8.005   114.617     0.200
     8.027   114.664     0.200
     8.072   114.934     0.200
     8.124   114.766     0.200
     8.113   116.668     0.200
     8.183   116.402     0.200
     8.233   117.301     0.200
     8.232   116.996     0.200
     8.541   118.805     0.200
     8.541   120.105     0.200
     8.541   119.422     0.200
     8.237   117.605     0.200
     8.239   117.465     0.200
     8.239   117.906     0.200
     8.284   118.055     0.200
     8.284   117.395     0.200
     8.290   117.875     0.200
     8.327   119.633     0.200
     8.337   117.984     0.200
     8.364   121.477     0.200
     8.414   119.668     0.200
     8.414   120.492     0.200
     8.527   121.926     0.200
     8.527   121.008     0.200
     8.677   123.707     0.200
     8.708   123.352     0.200
     8.728   125.457     0.200
     8.721   125.012     0.200
     8.741   124.375     0.200
     8.843   124.422     0.200
     8.887   126.414     0.200
     8.961   127.008     0.200
     8.965   127.957     0.200
     8.989   127.555     0.200
     9.053   128.484     0.200
     9.109   130.238     0.200
     9.096   129.461     0.200
     9.160   129.293     0.200
     9.201   130.426     0.200
     9.318   132.543     0.200
     9.390   131.918     0.200
     9.390   132.406     0.200
     9.390   132.574     0.200
     9.411   134.605     0.200
     9.411   134.234     0.200
     9.454   134.809     0.200
     9.492   135.645     0.200
     9.580   136.547     0.200
     9.580   135.688     0.200
     9.571   135.926     0.200
     9.598   136.926     0.200
     9.690   138.000     0.200
     9.754   137.691     0.200
     9.703   137.820     0.200
     9.751   137.066     0.200
     9.823   140.105     0.200
     9.836   138.809     0.200
     9.843   138.746     0.200
    10.195   141.367     0.200
    10.195   142.562     0.200
     9.988   140.297     0.200
    10.038   141.160     0.200
    10.101   143.090     0.200
    10.102   144.297     0.200
    10.244   144.914     0.200
    10.240   145.348     0.200
    10.288   145.348     0.200
    10.270   144.332     0.200
    10.341   145.355     0.200
    10.567   148.508     0.200
    10.567   149.855     0.200
    10.567   149.410     0.200
    10.637   150.688     0.200
    10.753   149.941     0.200
    10.776   150.859     0.200
    10.791   150.734     0.200
    10.802   151.707     0.200
    10.835   153.098     0.200
    10.912   151.957     0.200
    10.912   152.207     0.200
    10.912   151.824     0.200
    10.825   154.246     0.200
    10.939   153.984     0.200
    11.029   156.043     0.200
    11.112   157.348     0.200
    11.093   157.016     0.200
    11.113   155.922     0.200
    11.200   157.363     0.200
    11.199   157.152     0.200
    11.314   158.895     0.200
    11.314   158.152     0.200
    11.287   157.926     0.200
    11.421   161.922     0.200
    11.635   162.984     0.200
    11.635   163.691     0.200
    11.563   163.520     0.200
    11.625   163.703     0.200
    11.622   162.957     0.200
    11.777   164.859     0.200
    11.780   165.293     0.200
    12.087   169.695     0.200
    12.000   169.453     0.200
    12.073   170.285     0.200
    12.059   169.523     0.200
    12.074   170.152     0.200
    12.114   172.383     0.200
    12.114   170.953     0.200
    12.149   170.750     0.200
    12.293   173.348     0.200
    12.331   173.125     0.200
    12.490   175.410     0.200
    12.572   177.570     0.200
    12.686   177.531     0.200
    12.763   178.895     0.200
    12.900   179.844     0.200
    13.274   186.633     0.200
    13.408   188.469     0.200
    13.592   190.980     0.200
    14.115   199.121     0.200
    14.242   201.605     0.200
    14.242   199.215     0.200
    14.502   201.254     0.200
    14.909   207.906     0.200
    14.914   211.230     0.200
    15.137   213.324     0.200
    15.425   217.418     0.200
    15.684   220.469     0.200
    17.612   242.035     0.200
    17.612   241.805     0.200
     1.605    27.241     0.200
     2.004    33.159     0.200
     2.619    41.189     0.200
     2.670    42.379     0.200
     2.670    42.523     0.200
     2.699    41.899     0.200
     2.699    42.683     0.200
     2.745    41.574     0.200
     2.768    42.789     0.200
     2.900    44.669     0.200
     2.882    44.449     0.200
     2.994    46.069     0.200
     2.998    45.600     0.200
     3.078    48.215     0.200
     3.167    47.879     0.200
     3.167    48.634     0.200
     3.319    50.929     0.200
     3.319    50.465     0.200
     3.461    52.929     0.200
     3.507    51.979     0.200
     3.507    51.667     0.200
     3.648    54.459     0.200
     3.784    55.831     0.200
     3.839    58.529     0.200
     3.893    57.475     0.200
     3.938    59.079     0.200
     3.938    59.441     0.200
     4.090    61.539     0.200
     4.090    60.052     0.200
     4.093    61.129     0.200
     4.060    60.829     0.200
     4.191    62.649     0.200
     4.206    62.788     0.200
     4.320    64.649     0.200
     4.345    64.289     0.200
     4.345    63.979     0.200
     4.380    65.399     0.200
     4.380    65.559     0.200
     4.441    65.049     0.200
     4.441    64.747     0.200
     4.564    67.779     0.200
     4.564    67.167     0.200
     4.716    66.919     0.200
     4.716    66.458     0.200
     4.736    69.604     0.200
     4.790    70.745     0.200
     4.895    71.229     0.200
     4.895    71.072     0.200
     4.894    72.140     0.200
     4.922    71.869     0.200
     4.922    71.559     0.200
     4.922    71.236     0.200
     4.919    71.719     0.200
     5.020    72.839     0.200
     5.020    73.259     0.200
     5.020    72.607     0.200
     4.993    73.729     0.200
     4.993    73.444     0.200
     5.059    74.740     0.200
     5.126    74.719     0.200
     5.276    76.479     0.200
     5.312    78.009     0.200
     5.397    78.434     0.200
     5.433    76.677     0.200
     5.528    80.447     0.200
     5.523    80.590     0.200
     5.534    80.229     0.200
     5.534    80.616     0.200
     5.643    81.547     0.200
     5.907    85.831     0.200
     6.001    86.769     0.200
     6.056    88.002     0.200
     6.156    88.392     0.200
     6.176    88.904     0.200
     6.181    89.199     0.200
     6.181    89.659     0.200
     6.181    89.350     0.200
     6.318    90.619     0.200
     6.409    92.634     0.200
     6.460    89.969     0.200
     6.433    92.835     0.200
     6.578    94.189     0.200
     6.578    94.415     0.200
     6.560    94.562     0.200
     6.584    94.936     0.200
     6.895    98.717     0.200
     6.956    99.929     0.200
     6.979   100.282     0.200
     7.027   100.548     0.200
     7.148   102.669     0.200
     7.148   102.539     0.200
     7.155   102.879     0.200
     7.155   102.031     0.200
     7.254   104.528     0.200
     7.230   103.501     0.200
     7.344   106.949     0.200
     7.397   105.819     0.200
     7.431   106.359     0.200
     7.431   106.239     0.200
     7.416   108.449     0.200
     7.440   106.671     0.200
     7.594   110.149     0.200
     7.595   109.408     0.200
     7.613   110.269     0.200
     7.613   109.470     0.200
     7.757   111.364     0.200
     7.809   112.151     0.200
     7.796   111.419     0.200
     7.796   110.597     0.200
     7.798   112.799     0.200
     7.853   113.113     0.200
     7.878   115.259     0.200
     7.915   113.899     0.200
     8.010   114.351     0.200
     8.019   114.536     0.200
     8.005   114.419     0.200
     8.036   114.678     0.200
     8.102   116.819     0.200
     8.102   115.922     0.200
     8.096   116.169     0.200
     8.096   114.987     0.200
     8.118   116.989     0.200
     8.166   116.979     0.200
     8.240   117.859     0.200
     8.240   117.293     0.200
     8.214   117.359     0.200
     8.261   115.559     0.200
     8.261   118.509     0.200
     8.329   118.725     0.200
     8.310   117.915     0.200
     8.364   121.378     0.200
     8.394   119.657     0.200
     8.503   120.669     0.200
     8.527   119.559     0.200
     8.680   123.514     0.200
     8.676   123.146     0.200
     8.703   123.435     0.200
     8.734   123.582     0.200
     8.727   125.729     0.200
     8.727   124.358     0.200
     8.858   124.299     0.200
     8.896   126.561     0.200
     8.960   127.484     0.200
     8.932   126.234     0.200
     8.962   126.324     0.200
     9.021   128.489     0.200
     9.096   128.942     0.200
     9.134   131.089     0.200
     9.134   129.736     0.200
     9.179   130.386     0.200
     9.322   132.178     0.200
     9.420   134.079     0.200
     9.420   134.759     0.200
     9.420   133.899     0.200
     9.448   134.559     0.200
     9.473   135.076     0.200
     9.548   135.080     0.200
     9.586   136.085     0.200
     9.691   137.464     0.200
     9.700   137.087     0.200
     9.765   137.603     0.200
     9.771   137.820     0.200
     9.837   139.059     0.200
     9.807   138.251     0.200
     9.820   139.115     0.200
     9.958   141.083     0.200
    10.012   140.889     0.200
    10.093   142.564     0.200
    10.084   143.434     0.200
    10.253   144.428     0.200
    10.246   144.054     0.200
    10.256   144.303     0.200
    10.562   149.429     0.200
    10.562   148.617     0.200
    10.561   149.929     0.200
    10.536   148.083     0.200
    10.618   148.981     0.200
    10.774   149.771     0.200
    10.783   152.559     0.200
    10.783   151.740     0.200
    10.765   152.117     0.200
    10.780   151.500     0.200
    10.839   152.844     0.200
    10.934   151.759     0.200
    10.934   151.862     0.200
    10.950   154.106     0.200
    11.029   156.076     0.200
    11.073   155.638     0.200
    11.132   155.619     0.200
    11.132   155.148     0.200
    11.086   155.879     0.200
    11.088   155.584     0.200
    11.170   156.915     0.200
    11.170   157.103     0.200
    11.260   157.746     0.200
    11.275   160.239     0.200
    11.397   159.875     0.200
    11.578   160.696     0.200
    11.635   163.691     0.200
    11.596   162.950     0.200
    11.751   165.759     0.200
    11.751   164.928     0.200
    11.986   168.484     0.200
    12.030   168.810     0.200
    12.074   168.892     0.200
    12.127   171.384     0.200
    12.127   171.179     0.200
    12.127   169.566     0.200
    12.271   171.786     0.200
    12.302   172.569     0.200
    12.414   173.109     0.200
    12.557   176.383     0.200
    12.659   178.095     0.200
    12.871   180.302     0.200
    13.249   187.220     0.200
    13.382   189.144     0.200
    14.226   199.834     0.200
    14.226   198.569     0.200
    15.146   211.172     0.200
    17.599   242.299     0.200
    17.599   241.535     0.200
    18.781   257.369     0.200
    18.781   257.809     0.200
     1.421    24.031     0.200
     1.454    24.156     0.200
     1.510    24.047     0.200
     1.510    23.922     0.200
     1.625    27.508     0.200
     1.625    27.625     0.200
     1.625    27.508     0.200
     1.859    30.664     0.200
     1.879    30.555     0.200
     1.922    31.492     0.200
     1.923    31.562     0.200
     2.034    31.727     0.200
     2.034    31.445     0.200
     2.241    35.352     0.200
     2.313    35.664     0.200
     2.372    37.242     0.200
     2.393    37.602     0.200
     2.441    39.055     0.200
     2.486    39.375     0.200
     2.486    38.750     0.200
     2.645    39.430     0.200
     2.749    42.242     0.200
     2.885    43.844     0.200
     2.872    43.570     0.200
     2.900    44.117     0.200
     2.901    44.039     0.200
     2.969    44.852     0.200
     2.938    44.945     0.200
     3.153    47.594     0.200
     3.281    50.195     0.200
     3.281    49.391     0.200
     3.421    50.844     0.200
     3.457    51.242     0.200
     3.485    51.914     0.200
     3.486    52.523     0.200
     3.513    53.547     0.200
     3.637    53.711     0.200
     3.661    54.914     0.200
     3.660    54.844     0.200
     3.690    55.805     0.200
     3.804    56.852     0.200
     3.804    56.203     0.200
     3.878    57.867     0.200
     3.923    58.562     0.200
     3.992    58.820     0.200
     4.054    60.484     0.200
     4.118    61.641     0.200
     4.167    60.781     0.200
     4.195    61.734     0.200
     4.195    61.891     0.200
     4.223    62.484     0.200
     4.223    62.336     0.200
     4.319    62.922     0.200
     4.333    63.617     0.200
     4.589    68.195     0.200
     4.589    68.031     0.200
     4.591    67.727     0.200
     4.732    69.531     0.200
     4.732    69.211     0.200
     4.719    69.133     0.200
     4.764    69.977     0.200
     4.853    70.617     0.200
     4.926    72.164     0.200
     4.949    72.766     0.200
     5.145    75.125     0.200
     5.110    74.203     0.200
     5.110    73.695     0.200
     5.186    75.594     0.200
     5.136    74.766     0.200
     5.136    74.344     0.200
     5.159    75.617     0.200
     5.159    75.188     0.200
     5.208    76.461     0.200
     5.202    75.672     0.200
     5.238    76.742     0.200
     5.484    79.992     0.200
     5.484    79.602     0.200
     5.543    80.945     0.200
     5.543    80.664     0.200
     5.633    81.938     0.200
     5.647    82.055     0.200
     5.741    82.242     0.200
     5.786    83.312     0.200
     5.786    83.070     0.200
     5.838    84.492     0.200
     5.814    85.281     0.200
     5.826    85.188     0.200
     5.927    85.672     0.200
     5.985    87.453     0.200
     5.959    87.414     0.200
     6.007    86.727     0.200
     6.007    86.414     0.200
     6.121    89.469     0.200
     6.196    89.641     0.200
     6.207    89.875     0.200
     6.264    89.734     0.200
     6.283    91.070     0.200
     6.342    90.789     0.200
     6.355    90.344     0.200
     6.374    91.461     0.200
     6.408    93.234     0.200
     6.454    93.008     0.200
     6.559    93.992     0.200
     6.666    96.867     0.200
     6.684    96.953     0.200
     6.693    95.992     0.200
     6.724    96.688     0.200
     6.724    96.078     0.200
     6.770    96.617     0.200
     6.772    95.758     0.200
     6.803    97.656     0.200
     6.803    98.164     0.200
     6.850    98.812     0.200
     6.812    97.031     0.200
     6.902    98.281     0.200
     6.902    98.414     0.200
     6.923    99.297     0.200
     6.923    99.133     0.200
     7.057   101.492     0.200
     7.176   103.531     0.200
     7.376   105.016     0.200
     7.376   104.836     0.200
     7.564   108.531     0.200
     7.609   108.773     0.200
     7.704   110.188     0.200
     7.715   110.586     0.200
     7.752   110.086     0.200
     8.428   119.664     0.200
     9.632   135.570     0.200
     0.233     9.945     0.200
     0.498    11.898     0.200
     0.657    13.777     0.200
     0.654    13.816     0.200
     0.658    14.297     0.200
     0.679    14.027     0.200
     0.747    15.148     0.200
     0.760    15.066     0.200
     0.816    16.086     0.200
     0.799    15.547     0.200
     0.785    15.348     0.200
     0.944    17.477     0.200
     0.944    17.219     0.200
     0.944    17.473     0.200
     0.920    17.191     0.200
     0.970    17.648     0.200
     0.971    17.723     0.200
     1.009    18.148     0.200
     1.059    19.559     0.200
     1.129    20.375     0.200
     1.199    20.785     0.200
     1.199    20.973     0.200
     1.235    21.578     0.200
     1.306    22.691     0.200
     1.307    22.648     0.200
     1.229    21.566     0.200
     1.353    22.785     0.200
     1.535    25.246     0.200
     1.535    25.102     0.200
     1.643    27.418     0.200
     1.646    27.516     0.200
     1.647    27.559     0.200
     1.666    27.695     0.200
     1.685    27.035     0.200
     1.807    29.059     0.200
     1.956    31.617     0.200
     1.955    31.547     0.200
     2.130    33.309     0.200
     2.096    32.656     0.200
     2.096    32.863     0.200
     2.272    35.848     0.200
     2.286    35.867     0.200
     2.310    36.098     0.200
     2.310    35.977     0.200
     2.337    36.637     0.200
     2.336    37.227     0.200
     2.336    37.023     0.200
     2.273    35.098     0.200
     2.280    35.078     0.200
     2.370    36.887     0.200
     2.419    37.527     0.200
     2.419    37.164     0.200
     2.374    36.297     0.200
     2.463    38.617     0.200
     2.463    38.367     0.200
     2.469    37.766     0.200
     2.666    40.219     0.200
     2.686    40.816     0.200
     2.700    40.969     0.200
     2.758    42.047     0.200
     2.695    41.188     0.200
     2.695    41.422     0.200
     2.796    43.078     0.200
     2.802    42.926     0.200
     2.874    44.137     0.200
     2.919    44.738     0.200
     2.937    45.078     0.200
     3.018    45.559     0.200
     3.040    46.195     0.200
     3.040    46.297     0.200
     3.127    46.828     0.200
     3.087    47.348     0.200
     3.103    47.277     0.200
     3.222    47.926     0.200
     3.388    50.516     0.200
     3.401    52.105     0.200
     3.401    52.270     0.200
     3.446    50.785     0.200
     3.547    53.078     0.200
     3.589    53.465     0.200
     3.590    53.598     0.200
     3.589    53.836     0.200
     3.596    53.328     0.200
     3.623    54.438     0.200
     3.660    54.828     0.200
     3.705    55.238     0.200
     3.798    56.266     0.200
     3.834    57.328     0.200
     3.931    58.117     0.200
     3.962    59.008     0.200
     3.963    58.828     0.200
     3.938    58.328     0.200
     3.938    58.445     0.200
     4.027    59.766     0.200
     4.027    59.871     0.200
     4.052    59.238     0.200
     4.052    59.598     0.200
     4.109    60.457     0.200
     4.109    60.594     0.200
     4.134    60.906     0.200
     4.154    61.766     0.200
     4.154    62.027     0.200
     4.211    61.047     0.200
     4.211    61.555     0.200
     4.198    61.816     0.200
     4.198    61.695     0.200
     4.341    62.527     0.200
     4.341    62.785     0.200
     4.390    64.375     0.200
     4.421    64.797     0.200
     4.421    65.070     0.200
     4.394    64.668     0.200
     4.474    64.637     0.200
     4.474    64.883     0.200
     4.479    64.738     0.200
     4.507    65.277     0.200
     4.507    66.422     0.200
     4.608    67.098     0.200
     4.608    67.246     0.200
     4.631    66.836     0.200
     4.631    66.996     0.200
     4.696    67.969     0.200
     4.696    68.105     0.200
     4.715    69.246     0.200
     4.715    69.371     0.200
     4.728    68.719     0.200
     4.804    69.828     0.200
     4.799    69.309     0.200
     4.754    70.008     0.200
     4.822    69.355     0.200
     4.822    68.711     0.200
     4.835    69.676     0.200
     4.841    70.957     0.200
     4.928    71.828     0.200
     4.928    71.996     0.200
     5.036    72.285     0.200
     5.036    72.449     0.200
     5.055    73.660     0.200
     5.200    74.828     0.200
     5.213    75.156     0.200
     5.213    75.621     0.200
     5.236    76.098     0.200
     5.236    76.559     0.200
     5.233    76.355     0.200
     5.233    76.996     0.200
     5.334    77.367     0.200
     5.334    77.148     0.200
     5.334    77.078     0.200
     5.372    77.168     0.200
     5.372    77.285     0.200
     5.357    77.945     0.200
     5.357    78.246     0.200
     5.492    78.457     0.200
     5.556    80.398     0.200
     5.593    80.688     0.200
     5.593    80.797     0.200
     5.647    80.719     0.200
     5.647    81.004     0.200
     5.743    82.148     0.200
     5.759    82.926     0.200
     5.759    83.426     0.200
     5.777    82.945     0.200
     5.793    83.945     0.200
     5.793    84.070     0.200
     5.811    83.266     0.200
     5.818    82.906     0.200
     5.818    82.766     0.200
     5.823    84.316     0.200
     5.823    83.773     0.200
     5.878    84.207     0.200
     5.858    84.336     0.200
     5.913    85.168     0.200
     5.953    85.496     0.200
     5.953    85.660     0.200
     6.018    85.969     0.200
     6.018    86.227     0.200
     6.021    86.059     0.200
     6.102    87.527     0.200
     6.074    86.969     0.200
     6.196    88.844     0.200
     6.197    88.785     0.200
     6.228    89.047     0.200
     6.228    89.625     0.200
     6.244    88.727     0.200
     6.265    90.047     0.200
     6.284    89.477     0.200
     6.317    89.809     0.200
     6.317    90.367     0.200
     6.331    90.617     0.200
     6.394    91.328     0.200
     6.416    91.969     0.200
     6.416    92.113     0.200
     6.450    91.906     0.200
     6.462    91.676     0.200
     6.469    91.930     0.200
     6.510    94.312     0.200
     6.519    92.457     0.200
     6.519    92.602     0.200
     6.511    92.496     0.200
     6.540    92.957     0.200
     6.540    93.066     0.200
     6.590    93.957     0.200
     6.668    95.652     0.200
     6.663    95.488     0.200
     6.663    95.332     0.200
     6.762    96.309     0.200
     6.767    96.258     0.200
     6.767    96.883     0.200
     6.777    96.957     0.200
     6.777    97.094     0.200
     6.795    96.527     0.200
     6.795    97.184     0.200
     6.826    96.719     0.200
     6.821    97.316     0.200
     6.843    97.828     0.200
     6.871    98.219     0.200
     6.867    97.809     0.200
     6.916    98.848     0.200
     6.924    99.027     0.200
     7.038   100.602     0.200
     7.077   100.867     0.200
     7.096   101.184     0.200
     7.234   102.867     0.200
     7.282   101.887     0.200
     7.282   101.680     0.200
     7.277   103.816     0.200
     7.301   104.387     0.200
     7.301   103.793     0.200
     7.333   104.496     0.200
     7.333   105.285     0.200
     7.346   104.863     0.200
     7.349   104.617     0.200
     7.359   104.578     0.200
     7.359   105.496     0.200
     7.375   105.008     0.200
     7.469   105.195     0.200
     7.469   105.090     0.200
     7.456   105.328     0.200
     7.402   105.137     0.200
     7.402   106.898     0.200
     7.505   106.367     0.200
     7.536   105.785     0.200
     7.536   105.957     0.200
     7.546   106.266     0.200
     7.546   108.383     0.200
     7.562   105.719     0.200
     7.645   108.871     0.200
     7.625   107.898     0.200
     7.625   108.246     0.200
     7.717   109.598     0.200
     7.717   110.426     0.200
     7.726   109.598     0.200
     7.742   110.410     0.200
     7.756   108.719     0.200
     7.756   108.344     0.200
     7.756   108.438     0.200
     7.756   109.098     0.200
     7.763   108.688     0.200
     7.838   111.348     0.200
     7.820   111.328     0.200
     7.862   109.848     0.200
     7.862   109.945     0.200
     7.862   109.656     0.200
     7.870   109.855     0.200
     7.906   111.516     0.200
     7.934   112.387     0.200
     7.985   111.988     0.200
     7.985   112.512     0.200
     7.922   112.176     0.200
     7.922   112.473     0.200
     7.983   112.469     0.200
     7.983   112.797     0.200
     7.983   112.281     0.200
     7.939   111.758     0.200
     8.054   112.527     0.200
     8.054   112.355     0.200
     7.989   112.727     0.200
     8.087   113.387     0.200
     8.087   114.273     0.200
     8.020   113.406     0.200
     8.121   115.117     0.200
     8.121   114.871     0.200
     8.139   114.766     0.200
     8.132   114.578     0.200
     8.158   115.355     0.200
     8.234   116.348     0.200
     8.255   115.969     0.200
     8.255   115.844     0.200
     8.375   117.086     0.200
     8.375   117.258     0.200
     8.394   118.824     0.200
     8.491   119.730     0.200
     8.496   119.488     0.200
     8.496   120.242     0.200
     8.489   120.438     0.200
     8.629   120.328     0.200
     8.631   122.262     0.200
     8.614   122.547     0.200
     8.614   122.898     0.200
     8.614   122.266     0.200
     8.706   124.785     0.200
     8.729   123.938     0.200
     8.729   124.211     0.200
     8.744   124.266     0.200
     8.772   123.668     0.200
     8.817   123.719     0.200
     9.013   127.746     0.200
     9.111   128.008     0.200
     9.111   129.492     0.200
     9.176   127.945     0.200
     9.176   127.602     0.200
     9.172   129.969     0.200
     9.172   129.773     0.200
     9.218   129.047     0.200
     9.262   129.613     0.200
     9.259   130.277     0.200
     9.388   131.457     0.200
     9.427   132.098     0.200
     9.427   132.594     0.200
     9.457   133.016     0.200
     9.457   132.738     0.200
     9.482   133.375     0.200
     9.490   131.719     0.200
     9.490   131.602     0.200
     9.504   133.855     0.200
     9.504   133.957     0.200
     9.591   134.695     0.200
     9.591   135.289     0.200
     9.593   135.195     0.200
     9.593   135.641     0.200
     9.576   134.027     0.200
     9.576   134.598     0.200
     9.628   134.398     0.200
     9.628   134.078     0.200
     9.663   134.117     0.200
     9.778   135.652     0.200
     9.781   137.797     0.200
     9.809   137.418     0.200
     9.809   138.188     0.200
     9.869   138.078     0.200
     9.869   138.938     0.200
     9.939   140.086     0.200
     9.939   140.672     0.200
    10.032   141.188     0.200
    10.032   142.398     0.200
    10.032   141.539     0.200
    10.073   141.746     0.200
    10.073   141.996     0.200
    10.112   143.508     0.200
    10.112   141.176     0.200
    10.178   144.992     0.200
    10.198   141.195     0.200
    10.198   141.398     0.200
    10.258   141.977     0.200
    10.258   143.996     0.200
    10.258   142.594     0.200
    10.297   145.398     0.200
    10.360   144.445     0.200
    10.360   144.680     0.200
    10.394   144.707     0.200
    10.394   145.164     0.200
    10.389   145.156     0.200
    10.451   145.996     0.200
    10.451   146.496     0.200
    10.528   146.125     0.200
    10.528   146.273     0.200
    10.499   146.375     0.200
    10.570   147.996     0.200
    10.603   146.098     0.200
    10.579   148.035     0.200
    10.579   147.406     0.200
    10.646   146.836     0.200
    10.657   147.051     0.200
    10.731   150.477     0.200
    10.731   150.238     0.200
    10.772   150.391     0.200
    10.857   152.332     0.200
    10.888   152.836     0.200
    10.888   153.387     0.200
    10.961   151.125     0.200
    11.013   153.090     0.200
    11.093   152.488     0.200
    11.100   153.816     0.200
    11.100   154.371     0.200
    11.339   157.242     0.200
    11.330   157.195     0.200
    11.330   159.336     0.200
    11.368   158.719     0.200
    11.368   159.918     0.200
    11.616   162.023     0.200
    11.666   161.453     0.200
    11.677   161.496     0.200
    11.881   163.520     0.200
    12.005   166.738     0.200
    12.092   166.371     0.200
    12.206   169.418     0.200
    12.228   168.520     0.200
    12.262   172.113     0.200
    12.330   173.031     0.200
    12.407   174.609     0.200
    12.402   173.074     0.200
    12.737   177.719     0.200
    12.839   177.996     0.200
    12.832   180.695     0.200
    12.832   180.578     0.200
    12.832   179.527     0.200
    12.983   183.094     0.200
    13.171   183.668     0.200
    13.171   182.727     0.200
    13.454   186.773     0.200
    13.629   186.816     0.200
    13.711   191.367     0.200
    14.048   193.746     0.200
    14.048   194.816     0.200
    14.149   195.746     0.200
    14.149   196.695     0.200
    14.209   196.785     0.200
    14.408   197.996     0.200
    16.023   222.344     0.200
    17.504   237.809     0.200
    17.504   238.359     0.200
     0.033    15.387     0.200
     0.116    15.227     0.200
     0.157    15.127     0.200
     0.147    15.316     0.200
     0.171    15.336     0.200
     0.355    15.697     0.200
     0.449    16.607     0.200
     0.597    17.816     0.200
     0.770    18.996     0.200
     0.850    19.557     0.200
     0.886    19.756     0.200
     0.908    20.277     0.200
     0.998    21.336     0.200
     1.091    22.367     0.200
     1.171    23.027     0.200
     1.180    22.857     0.200
     1.437    25.527     0.200
     1.469    25.947     0.200
     1.479    27.117     0.200
     1.493    27.346     0.200
     1.540    27.377     0.200
     1.643    28.527     0.200
     1.665    28.816     0.200
     1.753    29.266     0.200
     1.772    30.697     0.200
     1.771    30.527     0.200
     1.839    30.607     0.200
     2.012    32.857     0.200
     2.043    34.047     0.200
     2.033    33.146     0.200
     2.088    34.176     0.200
     2.177    34.926     0.200
     2.300    37.287     0.200
     2.351    38.387     0.200
     2.410    37.287     0.200
     2.450    39.037     0.200
     2.496    39.506     0.200
     2.528    39.697     0.200
     2.541    40.127     0.200
     2.588    40.236     0.200
     2.583    41.188     0.200
     2.632    41.346     0.200
     2.728    42.086     0.200
     2.789    42.676     0.200
     2.897    44.676     0.200
     2.905    44.627     0.200
     3.047    46.047     0.200
     3.181    48.447     0.200
     3.300    49.916     0.200
     3.319    50.066     0.200
     3.380    51.916     0.200
     3.386    51.697     0.200
     3.396    51.207     0.200
     3.439    52.188     0.200
     3.709    56.156     0.200
     3.723    55.986     0.200
     3.752    55.906     0.200
     3.824    57.996     0.200
     3.964    59.176     0.200
     3.983    59.586     0.200
     4.005    59.137     0.200
     4.077    60.176     0.200
     4.083    60.316     0.200
     4.221    62.586     0.200
     4.329    64.166     0.200
     4.393    63.396     0.200
     4.408    64.607     0.200
     4.768    69.277     0.200
     4.773    69.277     0.200
     4.765    68.906     0.200
     4.869    71.426     0.200
     4.921    70.906     0.200
     4.991    71.467     0.200
     5.189    75.916     0.200
     5.318    77.096     0.200
     5.367    76.986     0.200
     5.442    79.656     0.200
     5.678    81.197     0.200
     5.722    82.727     0.200
     5.750    82.596     0.200
     5.778    82.766     0.200
     5.965    85.797     0.200
     6.006    86.467     0.200
     6.004    87.477     0.200
     6.065    86.127     0.200
     6.121    87.836     0.200
     6.657    95.438     0.200
     7.072   100.477     0.200
     7.113   101.137     0.200
     7.156   101.676     0.200
     7.237   102.807     0.200
     7.306   104.127     0.200
     7.538   105.246     0.200
     8.063   113.227     0.200
     8.310   116.867     0.200
     0.358     8.514     0.200
     0.358     8.734     0.200
     1.065    18.494     0.200
     1.097    18.455     0.200
     1.097    18.834     0.200
     1.097    18.715     0.200
     1.408    23.695     0.200
     1.406    23.135     0.200
     1.613    26.035     0.200
     1.718    27.354     0.200
     1.756    27.285     0.200
     1.836    28.910     0.200
     1.837    28.904     0.200
     1.830    29.174     0.200
     1.825    28.264     0.200
     1.887    30.785     0.200
     1.919    30.254     0.200
     2.007    30.744     0.200
     2.133    33.035     0.200
     2.132    33.139     0.200
     2.373    36.305     0.200
     2.467    37.715     0.200
     2.468    37.715     0.200
     2.433    37.045     0.200
     2.493    38.824     0.200
     2.884    42.805     0.200
     2.937    44.645     0.200
     3.032    44.914     0.200
     3.187    46.084     0.200
     3.249    49.574     0.200
     3.193    46.264     0.200
     3.346    49.834     0.200
     3.346    49.480     0.200
     3.390    49.494     0.200
     3.390    49.635     0.200
     3.473    50.764     0.200
     3.564    53.273     0.200
     3.534    52.064     0.200
     3.581    52.895     0.200
     3.877    56.465     0.200
     4.041    58.844     0.200
     4.134    60.094     0.200
     4.163    60.545     0.200
     4.306    63.037     0.200
     4.392    64.014     0.200
     4.469    65.504     0.200
     4.588    67.104     0.200
     4.976    72.225     0.200
     5.009    72.445     0.200
     4.997    72.285     0.200
     5.075    73.404     0.200
     5.184    75.375     0.200
     5.372    78.434     0.200
     5.445    79.244     0.200
     5.675    82.844     0.200
     5.675    82.201     0.200
     5.725    82.555     0.200
     5.792    82.924     0.200
     6.233    89.334     0.200
     6.202    89.035     0.200
     6.313    90.764     0.200
     6.456    92.094     0.200
     6.720    96.354     0.200
     6.866    97.865     0.200
     7.053   100.695     0.200
     7.203   103.434     0.200
     9.137   125.785     0.200
     0.431    10.367     0.200
     0.432    10.367     0.200
     0.602    12.156     0.200
     0.677    13.477     0.200
     0.742    14.078     0.200
     1.049    18.078     0.200
     1.084    18.125     0.200
     1.042    18.906     0.200
     1.075    18.465     0.200
     1.052    18.988     0.200
     1.053    19.066     0.200
     1.054    19.176     0.200
     1.125    18.867     0.200
     1.071    18.945     0.200
     1.087    19.367     0.200
     1.087    18.715     0.200
     1.088    18.715     0.200
     1.101    18.477     0.200
     1.144    20.055     0.200
     1.197    20.426     0.200
     1.312    22.156     0.200
     1.325    22.805     0.200
     1.325    22.641     0.200
     1.325    22.715     0.200
     1.511    24.586     0.200
     1.512    24.586     0.200
     1.507    25.176     0.200
     1.507    25.293     0.200
     1.512    25.215     0.200
     1.560    24.707     0.200
     1.627    26.605     0.200
     1.654    26.617     0.200
     1.686    27.367     0.200
     1.763    28.746     0.200
     1.810    28.676     0.200
     1.844    29.727     0.200
     1.836    29.176     0.200
     1.887    29.328     0.200
     1.922    30.426     0.200
     1.894    29.465     0.200
     1.894    29.617     0.200
     1.977    31.406     0.200
     1.977    30.695     0.200
     1.980    31.227     0.200
     1.980    31.016     0.200
     2.094    33.008     0.200
     2.130    33.578     0.200
     2.138    33.918     0.200
     2.234    35.125     0.200
     2.265    35.527     0.200
     2.270    35.938     0.200
     2.544    38.777     0.200
     2.549    38.445     0.200
     2.554    38.105     0.200
     2.554    37.605     0.200
     2.594    39.645     0.200
     2.608    39.297     0.200
     2.620    41.176     0.200
     2.620    41.020     0.200
     2.685    40.816     0.200
     2.735    40.906     0.200
     2.768    41.738     0.200
     2.768    41.547     0.200
     2.891    42.188     0.200
     2.891    44.195     0.200
     2.897    44.188     0.200
     2.912    43.727     0.200
     2.903    43.766     0.200
     2.904    43.766     0.200
     2.904    44.105     0.200
     2.930    44.105     0.200
     2.952    44.875     0.200
     2.973    44.996     0.200
     2.973    45.285     0.200
     3.009    45.605     0.200
     3.058    45.078     0.200
     3.058    45.707     0.200
     3.226    48.078     0.200
     3.226    47.926     0.200
     3.230    48.156     0.200
     3.340    49.355     0.200
     3.342    49.988     0.200
     3.342    49.852     0.200
     3.477    51.066     0.200
     3.477    50.906     0.200
     3.564    52.375     0.200
     3.559    53.426     0.200
     3.636    54.016     0.200
     3.644    54.207     0.200
     3.725    55.387     0.200
     3.795    56.418     0.200
     3.808    55.125     0.200
     3.808    55.305     0.200
     3.850    55.957     0.200
     3.948    56.527     0.200
     3.965    58.867     0.200
     3.965    58.340     0.200
     4.013    58.477     0.200
     4.038    59.848     0.200
     4.067    60.766     0.200
     4.178    61.965     0.200
     4.202    61.055     0.200
     4.202    60.664     0.200
     4.302    62.875     0.200
     4.327    62.227     0.200
     4.327    62.352     0.200
     4.367    63.766     0.200
     4.384    63.715     0.200
     4.521    65.816     0.200
     4.521    65.695     0.200
     4.564    66.977     0.200
     4.595    67.906     0.200
     4.595    67.445     0.200
     4.617    66.238     0.200
     4.628    66.445     0.200
     4.681    66.988     0.200
     4.775    68.848     0.200
     4.959    71.977     0.200
     4.997    72.016     0.200
     5.020    72.016     0.200
     5.050    71.375     0.200
     5.057    72.297     0.200
     5.018    72.266     0.200
     5.064    74.098     0.200
     5.064    73.703     0.200
     5.095    73.277     0.200
     5.095    73.652     0.200
     5.108    74.406     0.200
     5.122    74.867     0.200
     5.122    74.148     0.200
     5.304    77.336     0.200
     5.304    76.957     0.200
     5.341    77.066     0.200
     5.335    77.496     0.200
     5.353    77.047     0.200
     5.353    76.738     0.200
     5.408    77.336     0.200
     5.425    77.836     0.200
     5.452    78.965     0.200
     5.480    78.625     0.200
     5.505    79.078     0.200
     5.544    79.676     0.200
     5.584    79.855     0.200
     5.587    79.805     0.200
     5.577    80.266     0.200
     5.603    79.953     0.200
     5.614    80.238     0.200
     5.648    81.535     0.200
     5.678    80.938     0.200
     5.725    82.055     0.200
     5.726    82.766     0.200
     5.767    83.406     0.200
     5.767    83.121     0.200
     5.796    83.578     0.200
     5.868    84.816     0.200
     5.873    84.785     0.200
     5.893    84.945     0.200
     5.893    84.562     0.200
     5.887    85.105     0.200
     5.887    84.535     0.200
     5.949    85.285     0.200
     5.949    84.926     0.200
     5.975    85.977     0.200
     5.975    85.781     0.200
     5.987    85.836     0.200
     6.000    85.465     0.200
     6.048    86.117     0.200
     6.053    85.816     0.200
     6.118    88.035     0.200
     6.193    88.836     0.200
     6.216    89.328     0.200
     6.295    90.477     0.200
     6.367    91.137     0.200
     6.427    92.188     0.200
     6.482    92.379     0.200
     6.485    92.715     0.200
     6.536    93.805     0.200
     6.558    92.766     0.200
     6.595    93.395     0.200
     6.789    97.168     0.200
     6.789    96.895     0.200
     6.806    96.266     0.200
     6.806    96.996     0.200
     6.806    96.598     0.200
     6.964    99.387     0.200
     7.008    99.938     0.200
     7.005    99.297     0.200
     7.007    99.297     0.200
     7.026    99.738     0.200
     7.077   100.508     0.200
     7.053    99.977     0.200
     7.053    99.734     0.200
     7.089   100.297     0.200
     7.146   101.137     0.200
     7.146    99.965     0.200
     7.166   101.238     0.200
     7.170   101.797     0.200
     7.251   103.098     0.200
     7.251   102.875     0.200
     7.269   103.605     0.200
     7.282   103.066     0.200
     7.282   102.691     0.200
     7.349   104.328     0.200
     7.664   108.676     0.200
     7.664   108.125     0.200
     7.684   109.738     0.200
     7.691   108.715     0.200
     7.691   108.816     0.200
     7.903   110.926     0.200
     8.022   113.207     0.200
     8.214   116.238     0.200
     8.298   117.215     0.200
     8.596   120.805     0.200
     8.718   122.168     0.200
     0.881    15.019     0.200
     1.076    19.029     0.200
     1.498    25.209     0.200
     1.501    25.009     0.200
     1.650    27.099     0.200
     1.704    28.659     0.200
     1.701    28.019     0.200
     1.698    27.269     0.200
     1.698    27.473     0.200
     1.772    28.829     0.200
     1.778    29.669     0.200
     1.821    29.879     0.200
     1.901    30.459     0.200
     1.901    30.454     0.200
     1.946    30.799     0.200
     1.942    31.189     0.200
     2.008    32.199     0.200
     2.040    32.679     0.200
     2.123    32.269     0.200
     2.168    34.449     0.200
     2.168    34.404     0.200
     2.447    38.259     0.200
     2.432    38.204     0.200
     2.433    38.209     0.200
     2.520    38.489     0.200
     2.493    39.139     0.200
     2.877    43.709     0.200
     2.922    44.099     0.200
     2.922    44.504     0.200
     3.120    46.849     0.200
     3.382    50.209     0.200
     3.382    50.804     0.200
     3.539    52.409     0.200
     3.528    52.949     0.200
     3.582    53.469     0.200
     3.614    53.399     0.200
     3.629    54.849     0.200
     3.712    55.329     0.200
     3.745    56.429     0.200
     3.837    56.839     0.200
     4.050    60.309     0.200
     4.171    62.579     0.200
     4.247    62.129     0.200
     4.271    62.349     0.200
     4.229    62.899     0.200
     4.248    62.049     0.200
     4.248    62.629     0.200
     4.261    62.779     0.200
     4.330    64.339     0.200
     4.330    64.554     0.200
     4.499    66.009     0.200
     4.545    66.709     0.200
     4.642    67.489     0.200
     4.634    67.849     0.200
     4.678    68.929     0.200
     4.950    72.299     0.200
     4.993    73.619     0.200
     5.077    74.829     0.200
     5.131    74.659     0.200
     5.218    76.599     0.200
     5.273    76.599     0.200
     5.256    75.929     0.200
     5.425    79.369     0.200
     5.455    79.249     0.200
     5.463    78.309     0.200
     5.463    79.087     0.200
     5.704    83.254     0.200
     5.737    83.209     0.200
     5.797    83.129     0.200
     5.867    83.949     0.200
     6.012    87.509     0.200
     6.045    86.729     0.200
     6.227    88.519     0.200
     6.286    90.229     0.200
     6.405    92.349     0.200
     6.512    93.849     0.200
     6.529    94.189     0.200
     6.724    96.229     0.200
     6.888    99.554     0.200
     6.991   100.719     0.200
     7.028   100.289     0.200
     7.060   101.559     0.200
     7.060   101.867     0.200
     7.274   103.799     0.200
     7.304   104.439     0.200
     7.429   105.299     0.200
     7.442   105.949     0.200
     7.506   106.779     0.200
     7.539   108.549     0.200
     7.538   108.139     0.200
     7.709   109.719     0.200
     7.709   110.754     0.200
     7.828   111.359     0.200
     7.837   111.279     0.200
     7.938   112.679     0.200
     8.565   121.059     0.200
     8.618   121.309     0.200
     8.768   123.579     0.200
     8.787   124.579     0.200
     8.830   123.629     0.200
     9.028   128.779     0.200
     9.041   127.629     0.200
     9.047   127.719     0.200
     9.119   128.679     0.200
     9.119   127.879     0.200
     9.233   130.529     0.200
     9.233   130.954     0.200
     9.316   132.059     0.200
     9.325   131.279     0.200
     9.529   134.839     0.200
     9.627   136.679     0.200
     9.671   135.719     0.200
     9.671   136.304     0.200
     9.912   139.599     0.200
    10.055   141.659     0.200
    10.430   147.759     0.200
    11.918   165.999     0.200
    15.235   211.154     0.200
    16.139   223.119     0.200
     0.386    12.195     0.200
     0.457    12.578     0.200
     0.457    12.727     0.200
     0.471    12.918     0.200
     0.554    13.648     0.200
     0.611    14.117     0.200
     0.673    15.102     0.200
     0.675    15.156     0.200
     0.732    15.496     0.200
     0.733    15.539     0.200
     0.764    15.629     0.200
     0.776    15.727     0.200
     0.787    15.926     0.200
     0.841    16.758     0.200
     0.840    17.035     0.200
     0.870    17.188     0.200
     0.893    18.117     0.200
     0.899    18.219     0.200
     0.884    17.598     0.200
     0.922    17.848     0.200
     0.894    17.168     0.200
     0.894    16.375     0.200
     1.011    18.945     0.200
     1.005    18.379     0.200
     1.099    20.027     0.200
     1.203    21.719     0.200
     1.203    22.078     0.200
     1.195    21.398     0.200
     1.197    21.422     0.200
     1.233    21.586     0.200
     1.269    21.695     0.200
     1.537    26.188     0.200
     1.583    26.707     0.200
     1.577    27.047     0.200
     1.577    27.215     0.200
     1.601    26.797     0.200
     1.601    26.902     0.200
     1.588    26.559     0.200
     1.621    27.129     0.200
     1.636    27.238     0.200
     1.697    28.625     0.200
     1.678    27.797     0.200
     1.678    27.906     0.200
     1.761    28.695     0.200
     1.761    29.148     0.200
     1.853    30.367     0.200
     1.926    30.668     0.200
     1.973    31.465     0.200
     1.940    30.578     0.200
     2.041    32.918     0.200
     2.047    32.926     0.200
     2.127    34.668     0.200
     2.277    35.852     0.200
     2.330    36.941     0.200
     2.386    36.867     0.200
     2.386    37.934     0.200
     2.490    38.469     0.200
     2.490    38.934     0.200
     2.557    39.887     0.200
     2.629    42.016     0.200
     2.629    40.691     0.200
     2.688    40.707     0.200
     2.706    40.477     0.200
     2.738    41.957     0.200
     2.738    42.133     0.200
     2.808    43.016     0.200
     2.831    44.031     0.200
     2.832    43.898     0.200
     2.834    43.926     0.200
     2.841    43.031     0.200
     2.837    42.867     0.200
     2.866    42.656     0.200
     2.866    42.840     0.200
     2.909    44.137     0.200
     3.001    45.348     0.200
     3.191    48.938     0.200
     3.287    49.398     0.200
     3.287    49.582     0.200
     3.337    50.656     0.200
     3.375    50.336     0.200
     3.431    52.559     0.200
     3.462    52.457     0.200
     3.501    52.926     0.200
     3.555    52.406     0.200
     3.605    53.105     0.200
     3.713    56.402     0.200
     3.735    55.641     0.200
     3.769    56.637     0.200
     3.769    56.789     0.200
     3.745    56.297     0.200
     3.772    56.348     0.200
     3.864    56.488     0.200
     3.864    57.059     0.200
     3.876    58.031     0.200
     3.901    56.668     0.200
     3.901    56.852     0.200
     3.907    57.027     0.200
     3.907    57.258     0.200
     3.939    57.457     0.200
     3.939    57.672     0.200
     3.961    59.219     0.200
     4.031    60.168     0.200
     4.067    59.719     0.200
     4.108    58.879     0.200
     4.108    59.031     0.200
     4.129    60.328     0.200
     4.272    61.898     0.200
     4.272    62.074     0.200
     4.285    62.918     0.200
     4.285    62.773     0.200
     4.299    61.297     0.200
     4.339    63.895     0.200
     4.364    64.309     0.200
     4.456    64.645     0.200
     4.497    66.926     0.200
     4.497    67.043     0.200
     4.532    65.855     0.200
     4.532    65.258     0.200
     4.620    67.559     0.200
     4.620    67.957     0.200
     4.620    67.719     0.200
     4.619    67.387     0.200
     4.619    67.125     0.200
     4.799    70.805     0.200
     4.834    70.707     0.200
     4.905    72.016     0.200
     4.878    70.684     0.200
     4.905    70.133     0.200
     4.923    71.086     0.200
     4.913    69.887     0.200
     4.966    71.648     0.200
     4.968    71.656     0.200
     5.022    73.266     0.200
     5.038    72.957     0.200
     5.049    73.168     0.200
     5.049    72.785     0.200
     5.072    74.008     0.200
     5.226    76.309     0.200
     5.226    76.207     0.200
     5.205    75.516     0.200
     5.217    74.578     0.200
     5.217    74.691     0.200
     5.256    75.582     0.200
     5.267    75.848     0.200
     5.261    75.738     0.200
     5.318    77.996     0.200
     5.318    78.281     0.200
     5.312    76.406     0.200
     5.378    78.637     0.200
     5.361    78.309     0.200
     5.382    78.129     0.200
     5.431    77.668     0.200
     5.433    78.777     0.200
     5.472    79.906     0.200
     5.467    79.176     0.200
     5.467    79.039     0.200
     5.480    79.176     0.200
     5.491    79.855     0.200
     5.517    79.105     0.200
     5.519    80.648     0.200
     5.547    79.703     0.200
     5.564    80.516     0.200
     5.602    80.926     0.200
     5.602    80.816     0.200
     5.622    81.406     0.200
     5.729    82.809     0.200
     5.750    82.555     0.200
     5.765    83.098     0.200
     5.765    82.816     0.200
     5.791    82.629     0.200
     5.791    82.523     0.200
     5.826    82.996     0.200
     5.834    83.316     0.200
     5.859    84.238     0.200
     5.898    84.996     0.200
     6.088    86.785     0.200
     6.229    89.363     0.200
     6.261    89.406     0.200
     6.359    91.418     0.200
     6.408    92.238     0.200
     6.408    92.508     0.200
     6.480    93.055     0.200
     6.490    93.387     0.200
     6.490    93.520     0.200
     6.489    93.648     0.200
     6.489    93.797     0.200
     6.487    91.887     0.200
     6.487    93.059     0.200
     6.487    92.598     0.200
     6.518    92.316     0.200
     6.563    94.609     0.200
     6.579    93.266     0.200
     6.578    94.508     0.200
     6.587    94.035     0.200
     6.684    96.066     0.200
     6.724    95.086     0.200
     6.703    95.688     0.200
     6.708    95.789     0.200
     6.711    95.898     0.200
     6.764    95.777     0.200
     6.778    96.855     0.200
     6.778    96.199     0.200
     6.767    97.047     0.200
     6.782    97.027     0.200
     6.803    98.121     0.200
     6.844    97.816     0.200
     6.985    98.816     0.200
     6.987    99.008     0.200
     6.988    98.559     0.200
     6.988    98.758     0.200
     6.999    98.852     0.200
     7.007    99.957     0.200
     7.007    99.727     0.200
     7.063   101.559     0.200
     7.069   101.156     0.200
     7.052   100.504     0.200
     7.090   100.285     0.200
     7.090    99.727     0.200
     7.090    98.891     0.200
     7.133   102.730     0.200
     7.201   102.605     0.200
     7.222   102.785     0.200
     7.204   102.934     0.200
     7.222   102.219     0.200
     7.285   102.809     0.200
     7.266   104.277     0.200
     7.315   103.332     0.200
     7.298   103.398     0.200
     7.298   104.559     0.200
     7.311   104.406     0.200
     7.314   104.828     0.200
     7.346   104.355     0.200
     7.371   104.680     0.200
     7.415   106.328     0.200
     7.415   106.051     0.200
     7.389   104.926     0.200
     7.408   105.277     0.200
     7.454   106.117     0.200
     7.444   105.418     0.200
     7.444   105.156     0.200
     7.523   106.598     0.200
     7.523   106.465     0.200
     7.539   107.266     0.200
     7.532   107.879     0.200
     7.532   108.000     0.200
     7.624   107.508     0.200
     7.729   109.219     0.200
     7.729   109.082     0.200
     7.779   111.230     0.200
     7.805   111.309     0.200
     7.862   111.078     0.200
     7.865   110.195     0.200
     7.911   112.371     0.200
     7.982   113.328     0.200
     8.030   113.188     0.200
     8.030   112.906     0.200
     8.017   114.219     0.200
     8.017   113.855     0.200
     8.058   114.930     0.200
     8.074   114.965     0.200
     8.050   114.348     0.200
     8.069   115.656     0.200
     8.081   114.297     0.200
     8.086   114.637     0.200
     8.112   114.906     0.200
     8.115   115.227     0.200
     8.124   115.047     0.200
     8.140   115.559     0.200
     8.182   116.785     0.200
     8.155   115.336     0.200
     8.159   115.836     0.200
     8.155   115.867     0.200
     8.279   118.379     0.200
     8.285   116.609     0.200
     8.435   118.266     0.200
     8.435   118.367     0.200
     8.448   118.469     0.200
     8.448   118.359     0.200
     8.488   120.648     0.200
     8.488   119.863     0.200
     8.537   120.438     0.200
     8.537   120.219     0.200
     8.508   119.898     0.200
     8.508   119.762     0.200
     8.535   120.156     0.200
     8.543   120.129     0.200
     8.601   121.832     0.200
     8.625   121.188     0.200
     8.660   122.992     0.200
     8.730   123.898     0.200
     8.698   122.906     0.200
     8.698   122.562     0.200
     8.729   121.887     0.200
     8.729   121.613     0.200
     8.740   123.188     0.200
     8.784   123.645     0.200
     8.824   123.895     0.200
     8.853   124.918     0.200
     8.890   126.828     0.200
     8.888   125.027     0.200
     8.926   124.793     0.200
     8.951   127.047     0.200
     8.951   127.258     0.200
     8.951   127.152     0.200
     8.996   125.648     0.200
     9.011   125.688     0.200
     9.094   127.562     0.200
     9.101   127.164     0.200
     9.163   130.105     0.200
     9.199   131.258     0.200
     9.187   128.004     0.200
     9.207   127.676     0.200
     9.261   130.207     0.200
     9.406   132.457     0.200
     9.406   132.750     0.200
     9.392   131.492     0.200
     9.445   131.445     0.200
     9.445   132.797     0.200
     9.445   132.527     0.200
     9.456   133.273     0.200
     9.465   132.406     0.200
     9.515   134.730     0.200
     9.495   134.488     0.200
     9.501   133.340     0.200
     9.505   132.848     0.200
     9.513   133.879     0.200
     9.513   133.676     0.200
     9.543   133.195     0.200
     9.589   133.859     0.200
     9.575   133.695     0.200
     9.622   133.691     0.200
     9.734   136.348     0.200
     9.751   138.129     0.200
     9.751   137.988     0.200
     9.790   136.586     0.200
     9.767   137.309     0.200
     9.767   137.199     0.200
     9.838   136.473     0.200
     9.830   138.227     0.200
     9.878   136.879     0.200
     9.888   139.746     0.200
     9.888   139.316     0.200
     9.910   137.855     0.200
     9.892   135.867     0.200
     9.892   137.656     0.200
     9.892   136.070     0.200
     9.977   140.008     0.200
    10.009   140.188     0.200
    10.009   140.020     0.200
     9.999   138.832     0.200
    10.008   140.988     0.200
    10.008   141.422     0.200
    10.050   139.980     0.200
    10.120   142.457     0.200
    10.182   143.348     0.200
    10.199   143.992     0.200
    10.192   141.758     0.200
    10.182   142.258     0.200
    10.182   141.371     0.200
    10.180   141.285     0.200
    10.253   145.258     0.200
    10.237   143.355     0.200
    10.261   144.730     0.200
    10.331   142.785     0.200
    10.364   145.578     0.200
    10.365   144.629     0.200
    10.365   144.957     0.200
    10.330   143.730     0.200
    10.458   146.156     0.200
    10.465   147.766     0.200
    10.465   148.086     0.200
    10.495   145.859     0.200
    10.570   148.070     0.200
    10.615   148.133     0.200
    10.687   149.746     0.200
    10.738   150.883     0.200
    10.720   150.066     0.200
    10.769   150.168     0.200
    10.771   149.996     0.200
    10.771   150.355     0.200
    10.886   153.707     0.200
    10.927   152.043     0.200
    11.059   155.148     0.200
    11.065   154.504     0.200
    11.120   156.871     0.200
    11.109   154.309     0.200
    11.109   154.977     0.200
    11.122   153.746     0.200
    11.121   155.422     0.200
    11.202   157.332     0.200
    11.340   156.621     0.200
    11.346   156.656     0.200
    11.484   159.438     0.200
    11.492   158.539     0.200
    11.598   162.027     0.200
    11.588   160.168     0.200
    11.588   159.957     0.200
    11.588   159.270     0.200
    11.643   161.465     0.200
    11.679   162.254     0.200
    11.748   163.918     0.200
    11.742   163.387     0.200
    11.917   165.246     0.200
    11.914   164.961     0.200
    11.884   165.684     0.200
    11.986   166.543     0.200
    12.083   167.973     0.200
    12.131   168.254     0.200
    12.142   168.906     0.200
    12.176   170.016     0.200
    12.225   170.355     0.200
    12.356   172.355     0.200
    12.356   172.758     0.200
    12.356   171.906     0.200
    12.432   173.117     0.200
    12.595   175.844     0.200
    12.579   175.938     0.200
    12.664   176.625     0.200
    12.692   176.258     0.200
    12.783   179.574     0.200
    12.962   180.227     0.200
    12.990   179.418     0.200
    13.025   182.008     0.200
    13.240   181.957     0.200
    13.240   183.059     0.200
    13.281   183.355     0.200
    13.281   184.051     0.200
    13.281   183.207     0.200
    13.956   192.738     0.200
    14.213   198.617     0.200
    14.671   201.969     0.200
    15.147   210.145     0.200
    15.366   213.262     0.200
    15.421   213.949     0.200
    15.773   216.656     0.200
    16.745   226.738     0.200
    16.745   227.258     0.200
    17.750   242.258     0.200
    18.439   251.328     0.200
    20.284   271.355     0.200
     0.052    18.996     0.200
     0.285    19.535     0.200
     0.331    19.824     0.200
     0.353    19.855     0.200
     0.495    20.496     0.200
     0.523    20.152     0.200
     0.749    21.715     0.200
     0.811    22.336     0.200
     0.883    22.746     0.200
     1.126    25.645     0.200
     1.219    25.945     0.200
     1.211    25.945     0.200
     1.421    28.293     0.200
     1.395    28.734     0.200
     1.523    29.004     0.200
     1.592    29.195     0.200
     1.603    30.023     0.200
     1.728    30.562     0.200
     1.739    31.805     0.200
     1.919    34.496     0.200
     2.077    35.594     0.200
     2.152    35.652     0.200
     2.162    36.652     0.200
     2.183    37.016     0.200
     2.178    37.496     0.200
     2.195    37.336     0.200
     2.352    38.684     0.200
     2.442    39.926     0.200
     2.469    40.414     0.200
     2.505    40.324     0.200
     2.614    42.375     0.200
     2.847    43.754     0.200
     2.954    45.766     0.200
     2.948    46.695     0.200
     3.017    47.914     0.200
     3.298    50.883     0.200
     3.286    51.145     0.200
     3.391    52.496     0.200
     3.548    54.555     0.200
     3.650    54.902     0.200
     3.986    59.344     0.200
     4.172    62.176     0.200
     4.337    63.234     0.200
     4.422    64.215     0.200
     4.396    63.953     0.200
     4.462    65.645     0.200
     4.563    66.984     0.200
     4.591    68.402     0.200
     4.596    68.176     0.200
     4.630    66.953     0.200
     4.719    69.426     0.200
     4.752    69.902     0.200
     5.008    73.375     0.200
     5.021    72.383     0.200
     5.122    74.305     0.200
     5.284    75.535     0.200
     5.318    77.336     0.200
     5.323    77.266     0.200
     5.357    77.383     0.200
     5.412    78.023     0.200
     5.590    81.203     0.200
     5.568    80.555     0.200
     5.614    81.293     0.200
     5.628    82.086     0.200
     5.625    81.113     0.200
     5.779    83.734     0.200
     5.818    82.902     0.200
     5.968    85.684     0.200
     6.030    86.465     0.200
     6.313    90.586     0.200
     6.401    92.363     0.200
     6.415    92.574     0.200
     6.449    92.824     0.200
     6.719    95.754     0.200
     6.729    94.312     0.200
     6.968    97.785     0.200
     7.058   101.094     0.200
     7.117    99.664     0.200
     7.275   101.695     0.200
     7.275   101.594     0.200
     7.323   105.043     0.200
     7.511   107.016     0.200
     7.564   105.754     0.200
     8.040   112.645     0.200
     8.138   114.684     0.200
     1.281    22.621     0.200
     1.711    28.621     0.200
     1.711    28.469     0.200
     1.791    29.949     0.200
     2.013    33.441     0.200
     2.013    32.785     0.200
     2.104    35.352     0.200
     2.162    35.090     0.200
     2.259    36.359     0.200
     2.476    40.672     0.200
     2.473    40.449     0.200
     2.548    41.430     0.200
     2.582    41.141     0.200
     2.807    44.918     0.200
     3.045    47.480     0.200
     3.092    48.551     0.200
     3.157    49.012     0.200
     3.157    49.312     0.200
     3.494    56.109     0.200
     3.795    58.512     0.200
     3.795    58.695     0.200
     3.975    60.590     0.200
     3.975    61.020     0.200
     4.074    61.973     0.200
     4.086    61.652     0.200
     4.151    62.332     0.200
     4.199    64.512     0.200
     4.187    63.391     0.200
     4.220    65.262     0.200
     4.339    65.695     0.200
     4.448    66.812     0.200
     4.469    67.871     0.200
     4.516    68.562     0.200
     4.599    69.031     0.200
     4.641    70.520     0.200
     4.799    71.410     0.200
     4.911    72.871     0.200
     4.931    72.641     0.200
     4.933    72.883     0.200
     5.104    74.582     0.200
     5.136    75.633     0.200
     5.476    81.012     0.200
     5.649    82.891     0.200
     5.720    84.301     0.200
     5.755    83.891     0.200
     5.755    85.180     0.200
     5.829    86.641     0.200
     5.829    86.922     0.200
     5.890    86.672     0.200
     6.026    88.859     0.200
     6.058    89.672     0.200
     6.099    90.852     0.200
     6.098    89.340     0.200
     6.169    89.730     0.200
     6.337    92.062     0.200
     6.332    91.973     0.200
     6.413    94.199     0.200
     6.470    95.051     0.200
     6.507    95.152     0.200
     6.563    95.742     0.200
     6.573    95.660     0.200
     6.623    96.090     0.200
     6.614    97.551     0.200
     6.739    98.223     0.200
     6.879   100.699     0.200
     6.934    99.871     0.200
     6.980   101.449     0.200
     7.081   103.020     0.200
     7.190   104.742     0.200
     7.255   105.551     0.200
     7.364   105.020     0.200
     7.462   108.551     0.200
     7.569   109.340     0.200
     7.627   109.840     0.200
     7.648   110.172     0.200
     7.738   111.141     0.200
     7.826   112.902     0.200
     7.835   112.902     0.200
     7.809   112.871     0.200
     7.847   113.211     0.200
     7.933   115.043     0.200
     7.951   113.609     0.200
     7.951   114.012     0.200
     7.959   114.820     0.200
     7.993   115.902     0.200
     8.018   115.051     0.200
     7.995   114.602     0.200
     8.095   115.941     0.200
     8.086   116.812     0.200
     8.155   118.352     0.200
     8.182   118.199     0.200
     8.228   119.191     0.200
     8.246   118.770     0.200
     8.290   118.871     0.200
     8.602   123.691     0.200
     8.602   124.121     0.200
     8.595   123.359     0.200
     8.710   125.520     0.200
     8.892   127.160     0.200
     8.928   127.250     0.200
     9.126   131.500     0.200
     9.283   133.473     0.200
     9.283   133.891     0.200
     9.314   133.832     0.200
     9.570   136.832     0.200
     9.735   137.730     0.200
     9.894   141.520     0.200
    10.685   150.660     0.200
    10.731   152.832     0.200
    11.777   164.691     0.200
    12.515   177.109     0.200
     0.283     8.742     0.200
     0.761    14.320     0.200
     0.802    15.191     0.200
     0.802    14.941     0.200
     0.836    15.160     0.200
     0.937    16.902     0.200
     0.980    17.211     0.200
     0.966    17.082     0.200
     0.972    17.793     0.200
     0.991    17.461     0.200
     1.009    17.434     0.200
     1.014    18.141     0.200
     1.122    19.340     0.200
     1.150    19.871     0.200
     1.153    19.590     0.200
     1.153    19.586     0.200
     1.188    20.773     0.200
     1.224    20.652     0.200
     1.301    22.660     0.200
     1.352    22.672     0.200
     1.352    22.637     0.200
     1.582    24.781     0.200
     1.586    25.852     0.200
     1.727    27.090     0.200
     1.712    27.910     0.200
     1.782    28.684     0.200
     1.784    28.684     0.200
     2.106    32.383     0.200
     2.107    32.523     0.200
     2.290    34.953     0.200
     2.460    37.230     0.200
     2.467    38.383     0.200
     2.467    38.230     0.200
     2.565    39.043     0.200
     2.775    41.121     0.200
     2.797    42.871     0.200
     2.872    42.891     0.200
     2.870    42.891     0.200
     2.842    42.641     0.200
     2.842    43.793     0.200
     2.849    43.652     0.200
     2.865    43.422     0.200
     2.908    43.293     0.200
     2.898    43.750     0.200
     2.978    45.922     0.200
     3.163    46.641     0.200
     3.191    47.531     0.200
     3.270    49.891     0.200
     3.301    48.883     0.200
     3.308    50.113     0.200
     3.314    50.223     0.200
     3.326    50.551     0.200
     3.383    50.910     0.200
     3.436    51.434     0.200
     3.436    51.004     0.200
     3.448    51.902     0.200
     3.477    51.184     0.200
     3.477    52.172     0.200
     3.514    52.953     0.200
     3.514    52.637     0.200
     3.816    56.250     0.200
     3.826    56.762     0.200
     3.909    56.383     0.200
     3.952    57.543     0.200
     3.984    58.781     0.200
     4.020    59.461     0.200
     4.173    62.523     0.200
     4.192    62.422     0.200
     4.324    63.230     0.200
     4.361    64.000     0.200
     4.338    63.852     0.200
     4.444    65.750     0.200
     4.503    65.711     0.200
     4.600    66.473     0.200
     4.609    67.141     0.200
     4.625    67.582     0.200
     4.652    68.363     0.200
     4.657    66.922     0.200
     4.832    69.301     0.200
     4.887    71.551     0.200
     4.948    72.602     0.200
     5.027    73.293     0.200
     5.042    72.781     0.200
     5.102    73.840     0.200
     5.141    73.383     0.200
     5.172    74.691     0.200
     5.199    74.203     0.200
     5.299    74.953     0.200
     5.345    76.691     0.200
     5.469    79.133     0.200
     5.459    77.000     0.200
     5.584    80.301     0.200
     5.649    80.152     0.200
     5.717    82.652     0.200
     5.753    82.934     0.200
     5.873    83.602     0.200
     5.962    84.531     0.200
     6.074    87.500     0.200
     6.074    87.098     0.200
     6.104    86.641     0.200
     6.128    87.340     0.200
     6.256    90.301     0.200
     6.258    89.660     0.200
     6.348    89.910     0.200
     6.449    92.363     0.200
     6.482    92.531     0.200
     6.531    93.871     0.200
     6.673    95.352     0.200
     6.724    95.781     0.200
     6.700    95.223     0.200
     6.721    96.230     0.200
     6.760    96.461     0.200
     6.830    97.113     0.200
     6.830    97.574     0.200
     6.857    98.000     0.200
     6.857    97.812     0.200
     6.894    98.980     0.200
     6.894    98.566     0.200
     6.923    98.070     0.200
     7.003    99.512     0.200
     7.031   100.332     0.200
     7.031    99.977     0.200
     7.019    99.641     0.200
     7.227   102.691     0.200
     7.220   102.773     0.200
     7.299   103.211     0.200
     7.366   104.340     0.200
     7.374   104.172     0.200
     7.497   106.031     0.200
     7.545   106.512     0.200
     7.651   107.672     0.200
     7.844   110.871     0.200
     1.339    22.348     0.200
     1.294    22.887     0.200
     1.338    23.648     0.200
     1.457    26.078     0.200
     1.580    27.008     0.200
     1.580    27.027     0.200
     1.606    26.828     0.200
     1.653    27.297     0.200
     1.680    28.996     0.200
     1.787    29.586     0.200
     1.832    30.168     0.200
     1.846    30.527     0.200
     1.896    31.855     0.200
     1.953    31.965     0.200
     1.954    32.488     0.200
     1.958    32.055     0.200
     2.062    33.707     0.200
     2.163    33.227     0.200
     2.203    34.547     0.200
     2.267    36.148     0.200
     2.300    36.738     0.200
     2.340    36.785     0.200
     2.376    37.918     0.200
     2.437    38.125     0.200
     2.477    38.516     0.200
     2.471    39.125     0.200
     2.493    38.867     0.200
     2.581    40.758     0.200
     2.616    41.078     0.200
     2.714    42.148     0.200
     3.000    46.297     0.200
     3.044    46.488     0.200
     3.138    47.195     0.200
     3.247    47.285     0.200
     3.220    49.566     0.200
     3.249    49.137     0.200
     3.297    49.488     0.200
     3.306    50.605     0.200
     3.310    50.168     0.200
     3.529    52.328     0.200
     3.535    53.055     0.200
     3.587    53.156     0.200
     3.618    54.926     0.200
     3.651    52.656     0.200
     3.645    54.836     0.200
     3.687    55.496     0.200
     3.768    56.727     0.200
     3.787    55.938     0.200
     3.822    57.375     0.200
     3.969    58.957     0.200
     3.965    59.527     0.200
     4.090    61.266     0.200
     4.164    60.738     0.200
     4.170    62.426     0.200
     4.223    62.785     0.200
     4.265    64.047     0.200
     4.329    63.156     0.200
     4.307    63.828     0.200
     4.367    65.016     0.200
     4.354    64.918     0.200
     4.401    65.426     0.200
     4.507    66.617     0.200
     4.604    68.207     0.200
     4.684    69.355     0.200
     4.759    70.605     0.200
     4.759    70.156     0.200
     4.790    70.746     0.200
     4.903    71.898     0.200
     4.921    73.535     0.200
     5.014    73.738     0.200
     5.096    75.117     0.200
     5.150    74.527     0.200
     5.145    75.617     0.200
     5.167    76.098     0.200
     5.237    76.168     0.200
     5.265    77.457     0.200
     5.291    77.785     0.200
     5.303    77.457     0.200
     5.310    77.305     0.200
     5.341    77.727     0.200
     5.308    77.426     0.200
     5.376    79.598     0.200
     5.431    79.477     0.200
     5.622    81.098     0.200
     5.607    82.008     0.200
     5.838    85.207     0.200
     5.903    85.527     0.200
     5.999    86.496     0.200
     6.117    88.168     0.200
     6.126    89.148     0.200
     6.248    89.215     0.200
     6.355    93.098     0.200
     6.485    93.605     0.200
     6.614    95.277     0.200
     6.714    96.035     0.200
     6.838    97.535     0.200
     6.862    97.598     0.200
     6.962   100.055     0.200
     6.962    99.227     0.200
     6.964    99.988     0.200
     7.048   101.438     0.200
     7.087   101.285     0.200
     7.212   104.098     0.200
     7.501   106.086     0.200
     7.634   107.957     0.200
     7.708   108.988     0.200
     7.777   111.137     0.200
     7.855   111.715     0.200
     7.876   110.578     0.200
     7.871   112.215     0.200
     8.001   113.168     0.200
     8.166   115.246     0.200
     8.298   117.516     0.200
     0.186    19.359     0.200
     0.213    19.637     0.200
     0.262    19.707     0.200
     0.263    19.738     0.200
     0.319    20.059     0.200
     0.353    20.180     0.200
     0.364    20.418     0.200
     0.370    19.980     0.200
     0.371    19.910     0.200
     0.372    20.207     0.200
     0.372    19.910     0.200
     0.406    20.137     0.200
     0.417    20.480     0.200
     0.499    20.980     0.200
     0.517    20.680     0.200
     0.597    21.430     0.200
     0.622    21.250     0.200
     0.800    22.258     0.200
     0.836    22.578     0.200
     0.933    23.750     0.200
     0.972    23.910     0.200
     0.976    24.078     0.200
     1.025    24.527     0.200
     1.048    24.707     0.200
     1.146    24.617     0.200
     1.297    27.027     0.200
     1.331    27.777     0.200
     1.384    27.648     0.200
     1.464    28.520     0.200
     1.497    29.078     0.200
     1.591    29.887     0.200
     1.591    30.387     0.200
     1.619    30.559     0.200
     1.621    31.129     0.200
     1.694    30.797     0.200
     1.728    31.297     0.200
     1.737    31.809     0.200
     1.790    31.559     0.200
     1.860    33.020     0.200
     1.927    34.059     0.200
     2.110    36.609     0.200
     2.134    35.668     0.200
     2.127    36.148     0.200
     2.127    36.410     0.200
     2.146    36.520     0.200
     2.263    37.750     0.200
     2.263    38.277     0.200
     2.308    38.680     0.200
     2.308    38.934     0.200
     2.315    38.680     0.200
     2.334    38.270     0.200
     2.350    39.059     0.200
     2.354    39.578     0.200
     2.396    39.719     0.200
     2.540    41.520     0.200
     2.537    41.047     0.200
     2.654    42.238     0.200
     2.730    43.070     0.200
     2.756    42.457     0.200
     2.771    43.797     0.200
     2.852    45.539     0.200
     3.005    47.387     0.200
     3.023    47.617     0.200
     3.075    47.488     0.200
     3.312    50.879     0.200
     3.394    52.270     0.200
     3.390    52.148     0.200
     3.462    52.938     0.200
     3.463    53.969     0.200
     3.506    53.168     0.200
     3.506    53.684     0.200
     3.525    54.008     0.200
     3.638    56.020     0.200
     3.638    55.727     0.200
     3.729    56.480     0.200
     3.729    56.801     0.200
     3.754    57.270     0.200
     3.754    56.941     0.200
     3.840    58.047     0.200
     3.848    58.078     0.200
     3.848    57.652     0.200
     3.946    59.887     0.200
     3.946    60.000     0.200
     3.948    59.828     0.200
     4.169    61.930     0.200
     4.229    61.910     0.200
     4.288    63.547     0.200
     4.288    63.008     0.200
     4.386    64.859     0.200
     4.385    65.738     0.200
     4.395    64.520     0.200
     4.562    67.609     0.200
     4.588    68.148     0.200
     4.632    67.738     0.200
     4.634    70.508     0.200
     4.787    71.230     0.200
     4.803    70.277     0.200
     4.803    70.691     0.200
     4.808    70.277     0.200
     4.826    69.848     0.200
     4.838    69.188     0.200
     4.838    70.027     0.200
     4.853    72.180     0.200
     4.949    73.180     0.200
     4.949    73.051     0.200
     5.044    73.199     0.200
     5.063    72.910     0.200
     5.140    75.898     0.200
     5.221    74.867     0.200
     5.335    77.008     0.200
     5.376    77.168     0.200
     5.463    78.047     0.200
     5.468    79.410     0.200
     5.511    79.840     0.200
     5.528    79.988     0.200
     5.546    78.898     0.200
     5.546    79.066     0.200
     5.619    81.160     0.200
     5.619    80.805     0.200
     5.664    82.230     0.200
     5.826    83.949     0.200
     5.826    83.559     0.200
     5.826    83.180     0.200
     5.842    85.387     0.200
     5.842    84.918     0.200
     6.001    86.070     0.200
     6.013    85.246     0.200
     6.071    86.258     0.200
     6.071    86.926     0.200
     6.239    89.547     0.200
     6.276    89.738     0.200
     6.391    91.387     0.200
     6.391    91.656     0.200
     6.519    93.668     0.200
     6.524    93.238     0.200
     6.614    94.680     0.200
     6.629    95.180     0.200
     6.650    94.945     0.200
     6.662    95.609     0.200
     6.776    96.637     0.200
     6.772    95.020     0.200
     6.772    95.453     0.200
     6.861    98.379     0.200
     6.861    97.926     0.200
     6.861    96.738     0.200
     6.893    97.090     0.200
     7.036   100.199     0.200
     7.040   100.207     0.200
     7.058   101.027     0.200
     7.108    99.430     0.200
     7.203   102.750     0.200
     7.228   103.430     0.200
     7.223   103.379     0.200
     7.235   102.750     0.200
     7.264   103.559     0.200
     7.272   101.539     0.200
     7.287   104.020     0.200
     7.286   102.020     0.200
     7.302   103.070     0.200
     7.403   105.898     0.200
     7.416   106.059     0.200
     7.425   105.680     0.200
     7.441   103.840     0.200
     7.441   103.410     0.200
     7.486   106.188     0.200
     7.533   107.605     0.200
     7.537   107.859     0.200
     7.667   109.039     0.200
     7.678   109.809     0.200
     7.719   109.809     0.200
     7.740   108.129     0.200
     7.936   113.039     0.200
     7.936   113.043     0.200
     7.977   113.398     0.200
     8.046   113.508     0.200
     8.050   114.887     0.200
     8.065   112.840     0.200
     0.355     9.821     0.200
     0.356     9.812     0.200
     0.603    12.692     0.200
     0.695    13.451     0.200
     0.806    15.091     0.200
     0.887    16.071     0.200
     0.969    17.431     0.200
     1.033    18.251     0.200
     1.041    18.211     0.200
     1.045    18.451     0.200
     1.012    17.812     0.200
     1.062    18.661     0.200
     1.130    19.371     0.200
     1.153    19.521     0.200
     1.154    19.571     0.200
     1.153    19.651     0.200
     1.158    19.631     0.200
     1.223    21.201     0.200
     1.229    20.971     0.200
     1.306    22.191     0.200
     1.273    21.471     0.200
     1.272    21.721     0.200
     1.302    21.961     0.200
     1.444    24.111     0.200
     1.448    24.491     0.200
     1.448    24.355     0.200
     1.391    23.261     0.200
     1.509    24.481     0.200
     1.599    25.116     0.200
     1.631    26.251     0.200
     1.589    25.851     0.200
     1.591    25.946     0.200
     1.661    26.562     0.200
     1.729    28.351     0.200
     1.742    27.631     0.200
     1.765    28.081     0.200
     1.919    29.901     0.200
     1.926    30.871     0.200
     1.981    30.871     0.200
     1.981    31.013     0.200
     1.940    30.381     0.200
     1.940    30.139     0.200
     2.007    31.381     0.200
     2.063    32.411     0.200
     2.004    31.961     0.200
     2.004    31.546     0.200
     2.034    31.621     0.200
     2.034    31.721     0.200
     2.099    32.891     0.200
     2.107    33.481     0.200
     2.059    32.562     0.200
     2.132    33.451     0.200
     2.231    35.021     0.200
     2.236    35.131     0.200
     2.199    35.011     0.200
     2.481    36.941     0.200
     2.544    38.341     0.200
     2.568    40.601     0.200
     2.568    40.312     0.200
     2.590    39.611     0.200
     2.590    39.378     0.200
     2.596    39.071     0.200
     2.596    39.196     0.200
     2.667    40.101     0.200
     2.667    39.700     0.200
     2.626    39.241     0.200
     2.626    39.487     0.200
     2.751    41.821     0.200
     2.751    41.601     0.200
     2.785    42.071     0.200
     2.785    41.746     0.200
     2.867    43.261     0.200
     2.867    43.451     0.200
     2.867    43.251     0.200
     2.867    43.571     0.200
     2.893    43.221     0.200
     2.918    44.381     0.200
     2.936    44.871     0.200
     2.970    44.991     0.200
     2.969    44.521     0.200
     2.969    44.369     0.200
     3.015    45.831     0.200
     2.954    43.471     0.200
     2.954    43.168     0.200
     3.065    45.901     0.200
     3.065    46.271     0.200
     3.098    46.851     0.200
     3.090    45.971     0.200
     3.164    47.221     0.200
     3.164    47.071     0.200
     3.190    48.231     0.200
     3.260    47.511     0.200
     3.260    48.317     0.200
     3.292    48.981     0.200
     3.292    49.102     0.200
     3.406    50.081     0.200
     3.406    49.937     0.200
     3.534    52.792     0.200
     3.553    51.901     0.200
     3.557    52.042     0.200
     3.557    53.271     0.200
     3.632    53.941     0.200
     3.671    54.231     0.200
     3.671    54.069     0.200
     3.691    55.251     0.200
     3.691    54.851     0.200
     3.643    53.611     0.200
     3.643    54.758     0.200
     3.680    54.542     0.200
     3.747    54.201     0.200
     3.747    54.771     0.200
     3.747    54.368     0.200
     3.708    55.021     0.200
     3.784    55.011     0.200
     3.784    54.768     0.200
     3.847    56.042     0.200
     3.816    56.081     0.200
     3.816    56.480     0.200
     3.873    55.661     0.200
     3.873    55.511     0.200
     3.952    57.391     0.200
     3.956    58.641     0.200
     3.956    58.308     0.200
     4.041    57.901     0.200
     4.075    59.951     0.200
     4.138    60.042     0.200
     4.138    60.259     0.200
     4.121    61.241     0.200
     4.248    61.141     0.200
     4.248    61.571     0.200
     4.257    62.011     0.200
     4.257    62.675     0.200
     4.300    62.331     0.200
     4.300    62.760     0.200
     4.233    62.341     0.200
     4.308    62.971     0.200
     4.308    63.299     0.200
     4.453    64.751     0.200
     4.451    65.241     0.200
     4.541    65.292     0.200
     4.562    67.312     0.200
     4.562    67.413     0.200
     4.631    66.981     0.200
     4.631    67.473     0.200
     4.661    67.051     0.200
     4.613    67.011     0.200
     4.613    67.265     0.200
     4.647    67.471     0.200
     4.647    67.646     0.200
     4.701    68.101     0.200
     4.701    68.000     0.200
     4.714    67.631     0.200
     4.712    68.171     0.200
     4.712    68.321     0.200
     4.834    69.761     0.200
     4.835    69.725     0.200
     4.905    70.941     0.200
     4.936    70.881     0.200
     4.939    70.531     0.200
     4.942    70.621     0.200
     4.942    70.476     0.200
     4.962    71.431     0.200
     4.962    71.648     0.200
     4.981    71.301     0.200
     5.025    72.841     0.200
     5.025    72.958     0.200
     5.045    72.951     0.200
     5.045    73.286     0.200
     5.089    72.951     0.200
     5.089    74.199     0.200
     5.115    73.051     0.200
     5.121    74.081     0.200
     5.121    73.649     0.200
     5.126    74.421     0.200
     5.133    73.981     0.200
     5.232    75.691     0.200
     5.148    74.021     0.200
     5.148    75.271     0.200
     5.148    75.513     0.200
     5.202    75.601     0.200
     5.202    75.324     0.200
     5.260    76.021     0.200
     5.260    76.452     0.200
     5.277    75.611     0.200
     5.277    75.479     0.200
     5.295    76.101     0.200
     5.428    77.681     0.200
     5.445    78.171     0.200
     5.445    78.539     0.200
     5.462    78.721     0.200
     5.450    78.621     0.200
     5.450    78.380     0.200
     5.503    78.801     0.200
     5.509    78.821     0.200
     5.523    79.015     0.200
     5.558    79.201     0.200
     5.546    80.261     0.200
     5.546    80.505     0.200
     5.578    79.901     0.200
     5.578    80.803     0.200
     5.603    80.511     0.200
     5.610    80.981     0.200
     5.629    80.821     0.200
     5.644    80.751     0.200
     5.690    81.501     0.200
     5.717    82.181     0.200
     5.717    82.693     0.200
     5.682    81.861     0.200
     5.732    82.671     0.200
     5.732    83.097     0.200
     5.815    83.051     0.200
     5.815    83.411     0.200
     5.804    82.981     0.200
     5.804    83.321     0.200
     5.773    83.351     0.200
     5.830    84.121     0.200
     5.830    84.051     0.200
     5.830    84.173     0.200
     5.796    83.621     0.200
     5.882    84.021     0.200
     5.882    84.542     0.200
     5.867    84.971     0.200
     5.867    84.446     0.200
     5.893    84.691     0.200
     5.893    84.568     0.200
     5.886    84.401     0.200
     5.886    84.677     0.200
     5.920    84.562     0.200
     5.973    85.562     0.200
     6.036    86.771     0.200
     6.056    86.651     0.200
     6.135    88.411     0.200
     6.214    88.991     0.200
     6.213    88.851     0.200
     6.213    89.149     0.200
     6.287    89.681     0.200
     6.354    90.651     0.200
     6.401    91.639     0.200
     6.405    91.581     0.200
     6.451    93.599     0.200
     6.454    92.851     0.200
     6.515    92.781     0.200
     6.512    91.971     0.200
     6.512    92.485     0.200
     6.502    92.071     0.200
     6.502    93.471     0.200
     6.544    92.341     0.200
     6.611    95.341     0.200
     6.611    95.565     0.200
     6.654    95.051     0.200
     6.654    95.169     0.200
     6.699    95.221     0.200
     6.699    96.292     0.200
     6.684    94.721     0.200
     6.684    95.708     0.200
     6.707    95.411     0.200
     6.707    95.847     0.200
     6.707    96.111     0.200
     6.707    96.234     0.200
     6.755    94.831     0.200
     6.766    96.681     0.200
     6.769    96.081     0.200
     6.769    96.807     0.200
     6.855    97.421     0.200
     6.855    97.718     0.200
     6.793    96.721     0.200
     6.793    98.371     0.200
     6.793    97.976     0.200
     6.883    98.042     0.200
     6.883    98.621     0.200
     6.855    97.921     0.200
     6.855    98.488     0.200
     6.933    99.071     0.200
     6.957    98.211     0.200
     6.957    98.671     0.200
     6.957   100.452     0.200
     6.977    98.601     0.200
     6.995    99.091     0.200
     7.010    99.581     0.200
     7.035    99.601     0.200
     7.035    99.511     0.200
     7.035    98.871     0.200
     7.080   100.851     0.200
     7.084   100.451     0.200
     7.084   100.671     0.200
     7.084   100.819     0.200
     7.091   101.671     0.200
     7.102   101.653     0.200
     7.178   101.691     0.200
     7.178   102.349     0.200
     7.195   102.211     0.200
     7.223   101.781     0.200
     7.223   102.852     0.200
     7.228   104.022     0.200
     7.218   102.741     0.200
     7.251   102.251     0.200
     7.251   103.193     0.200
     7.291   103.321     0.200
     7.291   103.663     0.200
     7.322   103.661     0.200
     7.322   104.231     0.200
     7.384   105.741     0.200
     7.393   105.098     0.200
     7.569   108.111     0.200
     7.569   107.851     0.200
     7.600   107.011     0.200
     7.600   107.963     0.200
     7.591   108.304     0.200
     7.650   108.491     0.200
     7.650   108.638     0.200
     7.660   109.221     0.200
     7.707   110.401     0.200
     7.707   109.550     0.200
     7.718   110.218     0.200
     7.793   110.622     0.200
     7.856   111.621     0.200
     7.922   112.221     0.200
     7.922   112.521     0.200
     7.968   113.841     0.200
     7.968   113.208     0.200
     8.025   114.422     0.200
     8.039   114.776     0.200
     8.050   114.453     0.200
     8.179   116.562     0.200
     8.179   116.012     0.200
     8.189   116.098     0.200
     8.219   116.711     0.200
     8.219   116.427     0.200
     8.338   117.341     0.200
     8.338   118.062     0.200
     8.348   118.397     0.200
     8.345   118.492     0.200
     8.332   118.871     0.200
     8.482   120.060     0.200
     8.515   120.211     0.200
     8.497   121.135     0.200
     8.580   121.502     0.200
     8.617   122.341     0.200
     8.614   122.739     0.200
     8.641   122.131     0.200
     8.651   122.301     0.200
     8.651   122.627     0.200
     8.729   123.479     0.200
     8.793   124.668     0.200
     8.811   122.761     0.200
     8.811   123.042     0.200
     8.815   125.587     0.200
     8.853   125.021     0.200
     8.853   125.393     0.200
     8.898   126.005     0.200
     8.851   124.671     0.200
     8.851   124.487     0.200
     8.953   127.431     0.200
     8.978   127.396     0.200
     8.987   126.861     0.200
     8.982   127.420     0.200
     8.988   126.531     0.200
     8.980   126.688     0.200
     9.003   126.990     0.200
     9.132   128.981     0.200
     9.146   129.331     0.200
     9.146   129.071     0.200
     9.186   130.545     0.200
     9.230   131.091     0.200
     9.230   130.803     0.200
     9.196   131.134     0.200
     9.351   132.271     0.200
     9.339   132.504     0.200
     9.429   132.981     0.200
     9.463   133.336     0.200
     9.483   133.600     0.200
     9.485   131.571     0.200
     9.485   131.698     0.200
     9.566   135.783     0.200
     9.660   136.416     0.200
     9.653   136.635     0.200
     9.741   138.140     0.200
     9.779   137.181     0.200
     9.779   137.571     0.200
     9.823   138.080     0.200
     9.822   138.284     0.200
     9.843   139.071     0.200
     9.842   138.342     0.200
     9.910   139.474     0.200
     9.941   139.271     0.200
     9.941   139.872     0.200
     9.945   140.403     0.200
     9.966   140.062     0.200
     9.966   140.277     0.200
    10.049   142.701     0.200
    10.049   141.748     0.200
    10.042   142.397     0.200
    10.087   143.080     0.200
    10.130   142.833     0.200
    10.157   143.158     0.200
    10.323   145.296     0.200
    10.351   146.637     0.200
    10.359   146.021     0.200
    10.359   144.764     0.200
    10.379   146.221     0.200
    10.379   147.038     0.200
    10.422   146.121     0.200
    10.420   146.181     0.200
    10.420   146.012     0.200
    10.422   146.271     0.200
    10.422   147.216     0.200
    10.432   148.159     0.200
    10.560   150.129     0.200
    10.502   148.842     0.200
    10.689   151.410     0.200
    10.746   151.611     0.200
    10.746   150.882     0.200
    10.869   153.656     0.200
    10.954   154.675     0.200
    10.975   153.351     0.200
    10.975   154.458     0.200
    10.957   154.319     0.200
    11.064   156.009     0.200
    11.126   156.698     0.200
    11.172   156.071     0.200
    11.175   158.307     0.200
    11.329   160.891     0.200
    11.360   159.771     0.200
    11.376   159.321     0.200
    11.408   159.458     0.200
    11.383   157.612     0.200
    11.454   159.461     0.200
    11.495   161.031     0.200
    11.561   162.939     0.200
    11.835   165.835     0.200
    11.975   168.491     0.200
    11.975   168.335     0.200
    11.975   168.646     0.200
    12.018   167.743     0.200
    12.046   169.650     0.200
    12.065   167.174     0.200
    12.180   171.471     0.200
    12.180   171.312     0.200
    13.150   182.193     0.200
    13.150   181.846     0.200
    13.590   189.871     0.200
    15.352   212.646     0.200
    16.588   227.600     0.200
    17.652   241.263     0.200
    19.409   262.631     0.200
     0.359    11.602     0.200
     0.402    12.070     0.200
     0.503    13.070     0.200
     0.518    13.453     0.200
     0.526    13.273     0.200
     0.554    13.730     0.200
     0.566    13.551     0.200
     0.658    14.730     0.200
     0.666    14.480     0.200
     0.665    14.703     0.200
     0.696    14.871     0.200
     0.696    14.762     0.200
     0.727    15.160     0.200
     0.727    15.312     0.200
     0.789    16.141     0.200
     0.808    16.641     0.200
     0.840    16.551     0.200
     0.920    17.652     0.200
     0.920    17.543     0.200
     0.919    17.535     0.200
     0.943    18.160     0.200
     0.953    18.070     0.200
     1.266    21.523     0.200
     1.275    21.703     0.200
     1.275    21.836     0.200
     1.320    22.641     0.200
     1.370    22.863     0.200
     1.409    23.832     0.200
     1.640    26.812     0.200
     1.657    27.688     0.200
     1.659    27.641     0.200
     1.668    26.922     0.200
     1.830    28.961     0.200
     1.838    30.223     0.200
     1.881    30.043     0.200
     1.882    30.480     0.200
     1.941    29.922     0.200
     2.026    32.012     0.200
     2.130    33.383     0.200
     2.146    34.133     0.200
     2.309    35.641     0.200
     2.335    35.793     0.200
     2.335    35.961     0.200
     2.454    37.582     0.200
     2.499    38.500     0.200
     2.522    39.461     0.200
     2.536    39.523     0.200
     2.624    41.102     0.200
     2.624    40.898     0.200
     2.670    41.590     0.200
     2.684    41.152     0.200
     2.738    41.902     0.200
     2.847    43.512     0.200
     2.861    43.812     0.200
     2.860    43.703     0.200
     2.900    44.023     0.200
     2.939    45.293     0.200
     2.939    45.082     0.200
     2.975    44.402     0.200
     2.982    46.000     0.200
     2.989    45.941     0.200
     2.989    44.973     0.200
     3.020    45.160     0.200
     3.013    45.293     0.200
     3.040    46.590     0.200
     3.091    47.223     0.200
     3.104    47.242     0.200
     3.115    47.762     0.200
     3.158    48.121     0.200
     3.354    50.312     0.200
     3.387    50.371     0.200
     3.387    50.660     0.200
     3.578    53.512     0.200
     3.578    53.637     0.200
     3.603    53.531     0.200
     3.732    54.820     0.200
     3.751    54.410     0.200
     3.767    56.777     0.200
     3.769    56.781     0.200
     3.791    56.184     0.200
     3.792    57.703     0.200
     3.836    57.660     0.200
     3.839    58.250     0.200
     3.840    56.293     0.200
     3.840    56.863     0.200
     3.840    56.691     0.200
     3.860    57.160     0.200
     3.857    55.492     0.200
     3.865    55.211     0.200
     3.876    57.363     0.200
     3.889    58.383     0.200
     3.889    57.953     0.200
     4.092    60.434     0.200
     4.115    61.461     0.200
     4.152    60.793     0.200
     4.198    61.910     0.200
     4.274    63.590     0.200
     4.274    63.477     0.200
     4.323    63.152     0.200
     4.334    64.102     0.200
     4.368    64.113     0.200
     4.465    65.480     0.200
     4.465    65.613     0.200
     4.482    66.141     0.200
     4.504    65.980     0.200
     4.571    65.910     0.200
     4.577    66.793     0.200
     4.577    66.660     0.200
     4.577    66.191     0.200
     4.615    67.383     0.200
     4.615    67.668     0.200
     4.654    66.883     0.200
     4.666    67.941     0.200
     4.666    68.188     0.200
     4.709    68.262     0.200
     4.798    70.402     0.200
     4.858    69.910     0.200
     4.858    70.066     0.200
     4.863    69.910     0.200
     4.983    71.871     0.200
     5.058    73.613     0.200
     5.098    73.422     0.200
     5.127    73.992     0.200
     5.152    72.883     0.200
     5.154    73.973     0.200
     5.238    75.992     0.200
     5.238    76.262     0.200
     5.257    76.242     0.200
     5.261    77.051     0.200
     5.310    75.980     0.200
     5.310    75.785     0.200
     5.310    76.723     0.200
     5.336    75.352     0.200
     5.480    80.363     0.200
     5.556    78.801     0.200
     5.556    79.461     0.200
     5.556    78.914     0.200
     5.612    81.133     0.200
     5.612    80.953     0.200
     5.664    80.871     0.200
     5.664    80.754     0.200
     5.664    81.883     0.200
     5.664    82.016     0.200
     5.695    81.812     0.200
     5.811    83.980     0.200
     5.829    83.250     0.200
     5.890    85.012     0.200
     5.942    85.113     0.200
     5.942    84.922     0.200
     5.970    85.203     0.200
     5.971    85.160     0.200
     5.974    85.363     0.200
     6.026    86.012     0.200
     6.046    86.113     0.200
     6.076    86.152     0.200
     6.148    87.711     0.200
     6.181    88.133     0.200
     6.196    88.383     0.200
     6.196    89.070     0.200
     6.208    88.660     0.200
     6.247    88.293     0.200
     6.253    89.312     0.200
     6.253    89.527     0.200
     6.252    88.961     0.200
     6.290    90.203     0.200
     6.292    89.781     0.200
     6.314    90.922     0.200
     6.429    91.160     0.200
     6.482    92.230     0.200
     6.561    93.402     0.200
     6.561    93.094     0.200
     6.568    93.613     0.200
     6.568    92.766     0.200
     6.574    93.871     0.200
     6.688    94.992     0.200
     6.688    95.270     0.200
     6.721    95.652     0.200
     6.721    95.988     0.200
     6.774    96.422     0.200
     6.807    96.121     0.200
     6.813    97.070     0.200
     6.816    96.633     0.200
     6.836    96.559     0.200
     6.864    96.953     0.200
     6.958    98.781     0.200
     7.003    99.293     0.200
     7.020   100.562     0.200
     7.020   100.863     0.200
     7.094   101.023     0.200
     7.119   101.051     0.200
     7.203   102.500     0.200
     7.283   103.090     0.200
     7.449   105.883     0.200
     7.462   104.230     0.200
     7.524   107.102     0.200
     7.539   106.391     0.200
     7.539   106.961     0.200
     7.550   105.383     0.200
     7.554   107.801     0.200
     7.597   108.570     0.200
     7.600   107.512     0.200
     7.608   106.820     0.200
     7.614   108.391     0.200
     7.614   108.008     0.200
     7.616   107.980     0.200
     7.616   107.762     0.200
     7.626   108.281     0.200
     7.635   108.062     0.200
     7.715   109.426     0.200
     7.718   109.562     0.200
     7.748   109.621     0.200
     7.758   108.852     0.200
     7.761   110.230     0.200
     7.764   107.902     0.200
     7.789   110.473     0.200
     7.823   110.781     0.200
     7.829   110.684     0.200
     7.852   111.293     0.200
     7.920   110.891     0.200
     7.951   111.102     0.200
     8.011   113.383     0.200
     8.011   113.383     0.200
     8.024   114.070     0.200
     8.024   113.676     0.200
     8.051   114.293     0.200
     8.076   112.832     0.200
     8.076   111.961     0.200
     8.196   116.160     0.200
     8.218   117.160     0.200
     8.252   116.023     0.200
     8.258   116.133     0.200
     8.295   117.043     0.200
     8.304   117.621     0.200
     8.327   117.781     0.200
     8.367   118.840     0.200
     8.375   117.730     0.200
     8.398   118.781     0.200
     8.438   119.340     0.200
     8.456   119.422     0.200
     8.470   119.730     0.200
     8.526   119.281     0.200
     8.806   122.801     0.200
     8.845   124.531     0.200
     8.875   125.570     0.200
     8.922   126.891     0.200
     9.020   126.160     0.200
     9.197   130.910     0.200
     9.210   129.152     0.200
     9.469   133.090     0.200
     9.491   133.633     0.200
     9.522   134.301     0.200
     9.813   139.230     0.200
     9.829   137.723     0.200
     9.902   139.352     0.200
     9.966   138.902     0.200
    10.030   139.480     0.200
    10.163   142.141     0.200
    10.292   144.242     0.200
    10.428   145.551     0.200
    10.737   150.641     0.200
    10.762   150.801     0.200
    10.839   150.473     0.200
    10.891   154.062     0.200
    10.981   153.762     0.200
    11.252   157.391     0.200
    11.253   157.262     0.200
    11.530   161.742     0.200
    11.720   163.953     0.200
    11.735   164.102     0.200
    12.015   167.871     0.200
    12.076   167.082     0.200
    12.298   171.703     0.200
    12.658   177.223     0.200
    12.678   177.242     0.200
    13.232   184.688     0.200
    16.119   222.633     0.200
     0.352    12.648     0.200
     0.413    13.301     0.200
     0.514    14.469     0.200
     0.537    14.309     0.200
     0.577    14.777     0.200
     0.660    15.480     0.200
     0.676    15.891     0.200
     0.706    16.098     0.200
     0.729    16.160     0.200
     0.844    17.328     0.200
     0.931    18.578     0.200
     1.021    19.270     0.200
     1.255    22.059     0.200
     1.285    22.500     0.200
     1.318    23.008     0.200
     1.372    23.379     0.200
     1.417    24.500     0.200
     1.651    27.258     0.200
     1.663    27.809     0.200
     1.679    27.461     0.200
     1.931    30.059     0.200
     2.036    32.309     0.200
     2.141    34.027     0.200
     2.155    34.500     0.200
     2.331    35.801     0.200
     2.464    37.711     0.200
     2.474    38.551     0.200
     2.509    39.320     0.200
     2.679    41.598     0.200
     2.689    41.277     0.200
     2.857    43.820     0.200
     2.908    43.840     0.200
     2.992    46.660     0.200
     3.000    45.250     0.200
     2.998    45.859     0.200
     3.024    45.340     0.200
     3.049    46.688     0.200
     3.115    47.359     0.200
     3.365    50.301     0.200
     3.398    50.680     0.200
     3.588    53.508     0.200
     3.611    53.730     0.200
     3.650    55.641     0.200
     3.739    55.301     0.200
     3.756    54.328     0.200
     3.778    56.328     0.200
     3.803    56.168     0.200
     3.836    56.621     0.200
     3.848    57.699     0.200
     3.871    57.250     0.200
     3.888    57.770     0.200
     3.895    56.859     0.200
     4.100    60.438     0.200
     4.124    61.309     0.200
     4.162    60.820     0.200
     4.209    62.148     0.200
     4.284    63.539     0.200
     4.330    63.438     0.200
     4.342    64.059     0.200
     4.476    66.238     0.200
     4.588    66.461     0.200
     4.588    67.277     0.200
     4.624    67.438     0.200
     4.675    68.070     0.200
     4.660    66.938     0.200
     4.808    70.199     0.200
     4.903    71.000     0.200
     4.990    71.160     0.200
     5.066    74.051     0.200
     5.105    72.980     0.200
     5.268    76.379     0.200
     5.270    75.988     0.200
     5.320    76.871     0.200
     5.317    75.859     0.200
     5.341    75.438     0.200
     5.560    79.039     0.200
     5.623    81.180     0.200
     5.675    82.129     0.200
     5.671    80.750     0.200
     5.822    84.641     0.200
     5.900    84.801     0.200
     5.976    85.148     0.200
     6.206    88.840     0.200
     6.219    88.520     0.200
     6.259    89.211     0.200
     6.301    91.059     0.200
     6.427    91.980     0.200
     6.493    94.090     0.200
     6.567    93.809     0.200
     6.698    95.418     0.200
     6.811    96.469     0.200
     6.849    97.109     0.200
     6.868    97.777     0.200
     7.123   100.859     0.200
     7.452   106.059     0.200
     7.659   109.480     0.200
     7.930   110.801     0.200
     8.035   113.801     0.200
     8.335   116.738     0.200
     8.444   119.449     0.200
     8.462   119.598     0.200
     8.768   123.051     0.200
     8.876   125.750     0.200
     9.477   132.320     0.200
     9.832   137.309     0.200
     9.908   139.461     0.200
    10.297   145.270     0.200
     1.438    26.172     0.200
     1.464    26.023     0.200
     1.464    26.227     0.200
     1.586    28.102     0.200
     1.586    28.391     0.200
     1.704    30.562     0.200
     1.704    29.789     0.200
     1.797    31.930     0.200
     1.913    32.430     0.200
     2.116    36.133     0.200
     2.177    36.406     0.200
     2.207    37.352     0.200
     2.254    37.227     0.200
     2.247    37.531     0.200
     2.255    38.102     0.200
     2.257    37.477     0.200
     2.315    39.156     0.200
     2.369    39.359     0.200
     2.474    40.398     0.200
     2.474    40.297     0.200
     2.631    43.109     0.200
     2.631    43.664     0.200
     2.642    44.430     0.200
     2.723    44.469     0.200
     2.902    46.469     0.200
     2.902    46.570     0.200
     3.038    48.805     0.200
     3.172    50.156     0.200
     3.241    51.297     0.200
     3.349    51.906     0.200
     3.362    52.859     0.200
     3.627    56.797     0.200
     3.627    57.406     0.200
     3.739    57.969     0.200
     3.739    58.250     0.200
     3.764    58.492     0.200
     3.764    58.938     0.200
     3.843    58.883     0.200
     3.804    59.250     0.200
     3.945    60.523     0.200
     3.973    61.797     0.200
     3.973    61.641     0.200
     4.186    63.211     0.200
     4.186    64.648     0.200
     4.178    64.117     0.200
     4.216    64.672     0.200
     4.216    64.891     0.200
     4.266    64.289     0.200
     4.266    65.273     0.200
     4.228    61.820     0.200
     4.276    64.977     0.200
     4.276    66.414     0.200
     4.251    62.062     0.200
     4.375    68.070     0.200
     4.504    67.617     0.200
     4.504    68.594     0.200
     4.601    69.078     0.200
     4.579    69.398     0.200
     4.722    70.867     0.200
     4.931    73.617     0.200
     5.060    76.688     0.200
     5.164    78.203     0.200
     5.567    83.336     0.200
     5.582    82.328     0.200
     5.582    83.391     0.200
     5.592    82.281     0.200
     5.581    84.039     0.200
     5.571    83.648     0.200
     5.571    84.078     0.200
     5.607    83.242     0.200
     5.607    84.602     0.200
     5.681    85.172     0.200
     5.703    85.391     0.200
     5.767    85.391     0.200
     5.860    86.070     0.200
     5.873    86.273     0.200
     5.855    87.117     0.200
     5.860    88.609     0.200
     5.860    88.500     0.200
     6.048    88.812     0.200
     6.102    90.797     0.200
     6.106    90.156     0.200
     6.197    93.086     0.200
     6.197    92.070     0.200
     6.372    94.727     0.200
     6.368    95.469     0.200
     6.467    95.000     0.200
     6.697    99.625     0.200
     6.731    98.758     0.200
     6.828   100.156     0.200
     6.828   100.555     0.200
     6.837   100.242     0.200
     7.277   107.523     0.200
     7.295   108.031     0.200
     7.442   107.883     0.200
     7.442   109.406     0.200
     7.538   110.648     0.200
     7.610   111.742     0.200
     7.628   110.086     0.200
     7.722   112.586     0.200
     7.722   113.078     0.200
     7.817   114.727     0.200
     7.880   115.273     0.200
     7.906   114.859     0.200
     7.961   116.609     0.200
     7.961   116.484     0.200
     8.013   116.664     0.200
     8.012   118.109     0.200
     8.069   118.148     0.200
     8.664   126.211     0.200
     8.850   128.828     0.200
     9.010   130.133     0.200
     9.114   133.680     0.200
     9.789   142.062     0.200
     9.905   142.852     0.200
    10.160   147.906     0.200
    10.364   149.188     0.200
    10.496   150.891     0.200
    10.639   153.617     0.200
    10.893   155.461     0.200
    10.919   156.602     0.200
    10.933   156.977     0.200
    11.353   162.898     0.200
    11.351   161.781     0.200
    12.301   175.969     0.200
    12.382   177.383     0.200
    12.887   182.227     0.200
    12.885   184.078     0.200
    13.936   198.648     0.200
    13.936   198.078     0.200
     1.449    26.668     0.200
     1.437    26.625     0.200
     1.437    26.727     0.200
     1.577    27.836     0.200
     1.622    28.910     0.200
     1.724    30.398     0.200
     1.820    31.457     0.200
     1.820    31.324     0.200
     1.776    30.711     0.200
     1.979    33.445     0.200
     1.979    33.766     0.200
     2.083    35.176     0.200
     2.087    35.375     0.200
     2.252    39.125     0.200
     2.475    40.695     0.200
     2.428    39.816     0.200
     2.462    40.188     0.200
     2.462    41.258     0.200
     2.526    42.965     0.200
     2.573    42.438     0.200
     2.568    41.785     0.200
     2.568    42.109     0.200
     2.553    42.047     0.200
     2.629    43.148     0.200
     2.629    43.336     0.200
     2.659    43.637     0.200
     2.698    43.715     0.200
     2.829    45.117     0.200
     2.845    45.898     0.200
     3.130    50.246     0.200
     3.130    50.586     0.200
     3.232    50.898     0.200
     3.232    51.082     0.200
     3.305    53.211     0.200
     3.306    53.207     0.200
     3.321    54.047     0.200
     3.285    52.035     0.200
     3.319    52.168     0.200
     3.319    52.359     0.200
     3.350    53.578     0.200
     3.334    52.355     0.200
     3.334    52.664     0.200
     3.376    54.508     0.200
     3.581    55.559     0.200
     3.658    57.148     0.200
     3.684    57.715     0.200
     3.709    58.375     0.200
     3.763    58.215     0.200
     3.763    59.438     0.200
     3.914    60.656     0.200
     3.917    60.766     0.200
     3.963    61.176     0.200
     4.016    61.898     0.200
     4.043    62.578     0.200
     4.043    62.211     0.200
     4.114    64.457     0.200
     4.148    64.488     0.200
     4.148    65.016     0.200
     4.154    63.578     0.200
     4.154    63.926     0.200
     4.224    65.059     0.200
     4.224    65.328     0.200
     4.326    66.297     0.200
     4.360    66.738     0.200
     4.523    69.078     0.200
     4.643    70.566     0.200
     4.630    70.246     0.200
     4.630    70.535     0.200
     4.679    71.445     0.200
     4.720    71.809     0.200
     4.669    71.648     0.200
     4.699    71.707     0.200
     4.699    71.508     0.200
     4.816    72.246     0.200
     4.850    73.656     0.200
     4.850    73.785     0.200
     4.950    74.547     0.200
     4.948    74.957     0.200
     5.101    75.406     0.200
     5.096    77.148     0.200
     5.096    77.328     0.200
     5.124    76.707     0.200
     5.124    77.266     0.200
     5.250    78.176     0.200
     5.327    79.258     0.200
     5.380    79.965     0.200
     5.380    82.062     0.200
     5.547    83.707     0.200
     5.689    84.438     0.200
     5.689    85.090     0.200
     5.691    84.617     0.200
     5.662    83.887     0.200
     5.721    85.125     0.200
     5.735    85.656     0.200
     5.805    86.406     0.200
     5.939    87.398     0.200
     6.012    88.738     0.200
     6.074    89.676     0.200
     6.161    90.508     0.200
     6.167    91.328     0.200
     6.188    90.777     0.200
     6.271    92.266     0.200
     6.212    91.918     0.200
     6.299    92.707     0.200
     6.569    96.297     0.200
     6.638    98.246     0.200
     6.643    98.965     0.200
     6.646    96.715     0.200
     6.694    97.516     0.200
     6.977   102.336     0.200
     6.986   100.367     0.200
     7.080   102.898     0.200
     7.052   103.625     0.200
     7.092   102.137     0.200
     7.101   102.637     0.200
     7.213   106.027     0.200
     7.193   106.336     0.200
     7.288   105.906     0.200
     7.321   108.438     0.200
     7.341   108.125     0.200
     7.338   107.738     0.200
     7.417   108.836     0.200
     7.431   109.387     0.200
     7.521   110.527     0.200
     7.481   109.488     0.200
     7.490   109.797     0.200
     7.490   109.547     0.200
     7.528   111.035     0.200
     7.545   111.277     0.200
     7.631   110.457     0.200
     7.631   111.047     0.200
     7.631   112.438     0.200
     7.791   114.309     0.200
     7.910   114.156     0.200
     7.884   115.078     0.200
     7.937   114.246     0.200
     7.949   114.656     0.200
     8.136   119.375     0.200
     8.154   119.848     0.200
     8.202   118.945     0.200
     8.303   120.137     0.200
     8.373   122.277     0.200
     8.574   124.547     0.200
     8.576   123.996     0.200
     8.662   126.777     0.200
     8.764   128.059     0.200
     8.793   128.098     0.200
     8.803   128.086     0.200
     9.010   130.648     0.200
     9.062   131.707     0.200
     9.143   133.516     0.200
     9.171   133.715     0.200
     9.289   134.848     0.200
     9.255   134.297     0.200
     9.490   137.816     0.200
     9.584   138.496     0.200
     9.849   140.898     0.200
    10.035   143.578     0.200
    10.008   143.125     0.200
    10.067   144.957     0.200
    10.165   147.328     0.200
    10.283   147.438     0.200
    10.332   148.695     0.200
    10.370   148.828     0.200
    10.577   152.117     0.200
    10.617   151.668     0.200
    10.667   154.867     0.200
    10.696   156.516     0.200
    10.777   156.059     0.200
    11.002   159.988     0.200
    11.149   161.336     0.200
    11.648   167.008     0.200
    11.691   168.637     0.200
    11.734   168.336     0.200
    11.980   171.176     0.200
    12.132   173.035     0.200
    12.632   179.996     0.200
    12.898   182.656     0.200
     0.784    14.309     0.200
     1.087    18.855     0.200
     1.088    18.758     0.200
     1.205    20.367     0.200
     1.237    21.090     0.200
     1.251    21.309     0.200
     1.257    21.250     0.200
     1.297    22.270     0.200
     1.318    21.988     0.200
     1.346    23.117     0.200
     1.401    23.789     0.200
     1.401    23.648     0.200
     1.398    23.160     0.200
     1.405    23.500     0.200
     1.468    24.258     0.200
     1.473    24.230     0.200
     1.516    24.957     0.200
     1.517    25.070     0.200
     1.690    27.145     0.200
     1.763    28.379     0.200
     1.799    29.410     0.200
     1.811    29.660     0.200
     1.828    29.680     0.200
     1.826    29.199     0.200
     1.952    30.969     0.200
     2.059    32.758     0.200
     2.088    33.250     0.200
     2.088    33.066     0.200
     2.164    34.008     0.200
     2.167    33.617     0.200
     2.207    34.027     0.200
     2.207    34.676     0.200
     2.234    34.641     0.200
     2.275    34.520     0.200
     2.275    34.402     0.200
     2.418    37.398     0.200
     2.458    37.438     0.200
     2.435    37.594     0.200
     2.450    37.930     0.200
     2.459    37.758     0.200
     2.466    38.098     0.200
     2.522    39.180     0.200
     2.561    39.289     0.200
     2.717    41.270     0.200
     2.830    42.688     0.200
     2.856    43.160     0.200
     2.892    43.668     0.200
     2.900    44.309     0.200
     2.898    44.250     0.200
     2.924    44.117     0.200
     2.997    45.250     0.200
     3.024    45.398     0.200
     3.013    45.457     0.200
     3.073    46.219     0.200
     3.136    46.188     0.200
     3.231    47.930     0.200
     3.231    48.250     0.200
     3.273    48.070     0.200
     3.342    51.020     0.200
     3.338    50.238     0.200
     3.338    49.984     0.200
     3.371    49.949     0.200
     3.371    49.645     0.200
     3.349    49.930     0.200
     3.453    51.551     0.200
     3.660    54.363     0.200
     3.661    54.070     0.200
     3.661    54.555     0.200
     3.645    54.367     0.200
     3.667    54.309     0.200
     3.686    54.598     0.200
     3.711    55.027     0.200
     3.729    55.340     0.200
     3.763    55.809     0.200
     3.792    54.840     0.200
     3.792    55.398     0.200
     3.773    55.840     0.200
     3.808    56.391     0.200
     3.818    56.652     0.200
     3.816    56.719     0.200
     3.853    57.559     0.200
     3.901    57.078     0.200
     3.901    56.848     0.200
     3.953    57.707     0.200
     3.957    57.758     0.200
     3.938    58.078     0.200
     3.982    58.688     0.200
     4.067    59.859     0.200
     4.067    59.398     0.200
     4.074    59.250     0.200
     4.165    61.410     0.200
     4.165    61.793     0.200
     4.184    61.328     0.200
     4.184    61.488     0.200
     4.323    63.410     0.200
     4.323    63.250     0.200
     4.393    64.000     0.200
     4.400    64.430     0.200
     4.400    64.281     0.200
     4.439    64.758     0.200
     4.439    64.473     0.200
     4.455    65.730     0.200
     4.455    65.523     0.200
     4.484    64.430     0.200
     4.484    64.770     0.200
     4.492    64.598     0.200
     4.492    64.480     0.200
     4.482    65.797     0.200
     4.482    65.066     0.200
     4.492    64.719     0.200
     4.492    64.617     0.200
     4.508    66.777     0.200
     4.625    66.047     0.200
     4.614    68.059     0.200
     4.614    67.625     0.200
     4.662    68.039     0.200
     4.690    67.648     0.200
     4.716    69.199     0.200
     4.716    68.977     0.200
     4.709    68.750     0.200
     4.709    69.469     0.200
     4.709    68.402     0.200
     4.785    68.898     0.200
     4.859    70.668     0.200
     4.859    70.355     0.200
     4.941    71.988     0.200
     5.003    72.570     0.200
     5.016    73.359     0.200
     5.016    73.129     0.200
     5.036    73.340     0.200
     5.053    72.828     0.200
     5.053    72.949     0.200
     5.047    73.520     0.200
     5.100    74.449     0.200
     5.135    73.938     0.200
     5.146    74.168     0.200
     5.146    74.410     0.200
     5.223    75.207     0.200
     5.302    76.160     0.200
     5.291    76.828     0.200
     5.291    76.609     0.200
     5.296    76.891     0.200
     5.296    77.102     0.200
     5.329    77.070     0.200
     5.329    76.934     0.200
     5.303    76.688     0.200
     5.356    77.062     0.200
     5.388    77.117     0.200
     5.406    77.680     0.200
     5.428    78.418     0.200
     5.486    78.430     0.200
     5.486    78.891     0.200
     5.575    79.789     0.200
     5.579    80.359     0.200
     5.603    81.480     0.200
     5.603    81.090     0.200
     5.666    81.109     0.200
     5.669    80.980     0.200
     5.669    81.137     0.200
     5.700    81.891     0.200
     5.699    82.449     0.200
     5.699    82.266     0.200
     5.718    81.848     0.200
     5.800    83.141     0.200
     5.797    84.520     0.200
     5.797    83.895     0.200
     5.827    84.168     0.200
     5.876    84.449     0.200
     5.876    84.664     0.200
     5.881    85.027     0.200
     5.883    85.340     0.200
     5.883    84.898     0.200
     5.981    85.730     0.200
     5.955    85.840     0.200
     5.989    86.098     0.200
     6.007    85.949     0.200
     6.046    86.859     0.200
     6.046    86.625     0.200
     6.074    86.840     0.200
     6.060    87.867     0.200
     6.060    87.613     0.200
     6.096    87.398     0.200
     6.086    87.617     0.200
     6.124    87.957     0.200
     6.126    87.488     0.200
     6.184    88.730     0.200
     6.198    88.188     0.200
     6.188    89.098     0.200
     6.221    89.027     0.200
     6.241    89.707     0.200
     6.241    89.844     0.200
     6.239    89.617     0.200
     6.215    89.598     0.200
     6.275    89.730     0.200
     6.296    90.238     0.200
     6.339    90.926     0.200
     6.355    91.238     0.200
     6.355    91.438     0.200
     6.384    92.488     0.200
     6.384    92.172     0.200
     6.455    92.719     0.200
     6.417    91.688     0.200
     6.492    92.383     0.200
     6.579    93.602     0.200
     6.568    94.188     0.200
     6.568    94.074     0.200
     6.591    94.570     0.200
     6.622    94.980     0.200
     6.649    94.797     0.200
     6.649    95.145     0.200
     6.763    96.508     0.200
     6.771    96.840     0.200
     6.872    98.020     0.200
     6.875    98.258     0.200
     6.850    98.117     0.200
     6.850    98.238     0.200
     6.967    99.391     0.200
     6.967    99.859     0.200
     7.079   101.020     0.200
     7.084   101.598     0.200
     7.084   101.770     0.200
     7.180   102.859     0.200
     7.266   104.699     0.200
     7.266   104.023     0.200
     7.283   104.660     0.200
     7.294   102.859     0.200
     7.294   104.047     0.200
     7.318   104.363     0.200
     7.317   102.859     0.200
     7.346   104.410     0.200
     7.353   105.730     0.200
     7.353   105.367     0.200
     7.328   105.340     0.200
     7.366   106.320     0.200
     7.405   104.945     0.200
     7.380   106.074     0.200
     7.388   106.258     0.200
     7.388   105.574     0.200
     7.436   106.430     0.200
     7.458   106.348     0.200
     7.561   106.699     0.200
     7.612   109.133     0.200
     7.649   108.309     0.200
     7.649   108.922     0.200
     7.701   110.512     0.200
     7.731   109.918     0.200
     7.731   110.168     0.200
     7.756   108.758     0.200
     7.776   111.133     0.200
     7.784   109.469     0.200
     7.784   111.379     0.200
     7.798   109.797     0.200
     7.798   110.500     0.200
     7.798   108.910     0.200
     7.805   111.539     0.200
     7.797   109.820     0.200
     7.822   111.641     0.200
     7.943   113.230     0.200
     7.943   113.367     0.200
     7.964   112.359     0.200
     7.964   112.918     0.200
     7.969   114.168     0.200
     7.997   113.254     0.200
     8.024   114.547     0.200
     8.024   113.246     0.200
     8.026   113.930     0.200
     8.099   115.547     0.200
     8.099   114.953     0.200
     8.113   114.039     0.200
     8.113   114.234     0.200
     8.149   116.320     0.200
     8.149   116.434     0.200
     8.220   117.383     0.200
     8.224   118.141     0.200
     8.230   116.219     0.200
     8.312   117.219     0.200
     8.372   120.711     0.200
     8.440   119.848     0.200
     8.448   119.668     0.200
     8.488   119.949     0.200
     8.588   121.770     0.200
     8.588   122.148     0.200
     8.638   123.559     0.200
     8.695   123.387     0.200
     8.726   124.258     0.200
     8.726   124.379     0.200
     8.756   124.277     0.200
     8.745   125.496     0.200
     8.766   125.367     0.200
     8.766   125.082     0.200
     8.812   125.457     0.200
     8.906   125.934     0.200
     8.968   126.488     0.200
     8.968   126.270     0.200
     8.970   125.867     0.200
     8.978   126.367     0.200
     8.978   126.965     0.200
     9.020   128.367     0.200
     9.020   128.711     0.200
     9.065   128.199     0.200
     9.065   127.945     0.200
     9.199   131.477     0.200
     9.212   130.559     0.200
     9.212   131.312     0.200
     9.211   131.344     0.200
     9.247   130.449     0.200
     9.274   130.219     0.200
     9.274   129.699     0.200
     9.286   131.348     0.200
     9.286   131.961     0.200
     9.349   131.426     0.200
     9.434   132.957     0.200
     9.434   133.332     0.200
     9.510   134.219     0.200
     9.510   134.383     0.200
     9.512   133.090     0.200
     9.512   134.004     0.200
     9.553   135.750     0.200
     9.553   135.598     0.200
     9.575   133.090     0.200
     9.575   134.879     0.200
     9.575   135.070     0.200
     9.575   135.621     0.200
     9.593   135.797     0.200
     9.693   137.602     0.200
     9.687   138.879     0.200
     9.687   137.070     0.200
     9.721   138.000     0.200
     9.763   137.668     0.200
     9.775   138.660     0.200
     9.807   138.039     0.200
     9.807   137.645     0.200
     9.830   139.750     0.200
     9.830   139.562     0.200
     9.855   138.789     0.200
     9.855   139.328     0.200
     9.845   140.641     0.200
     9.845   139.891     0.200
     9.910   139.348     0.200
     9.926   140.258     0.200
    10.043   142.078     0.200
    10.043   141.691     0.200
    10.108   143.367     0.200
    10.108   142.883     0.200
    10.145   143.871     0.200
    10.211   144.945     0.200
    10.263   144.398     0.200
    10.263   144.281     0.200
    10.251   144.723     0.200
    10.331   145.441     0.200
    10.326   146.328     0.200
    10.372   146.738     0.200
    10.418   146.641     0.200
    10.418   146.754     0.200
    10.477   147.949     0.200
    10.477   147.676     0.200
    10.478   148.277     0.200
    10.478   149.004     0.200
    10.601   151.020     0.200
    10.614   148.738     0.200
    10.615   149.809     0.200
    10.635   150.340     0.200
    10.650   149.348     0.200
    10.650   149.633     0.200
    10.667   150.520     0.200
    10.667   151.707     0.200
    10.683   152.125     0.200
    10.762   152.340     0.200
    10.762   151.598     0.200
    10.820   152.812     0.200
    10.893   153.555     0.200
    10.927   154.539     0.200
    10.998   155.168     0.200
    10.998   155.883     0.200
    11.022   156.133     0.200
    11.049   157.559     0.200
    11.104   158.941     0.200
    11.173   156.082     0.200
    11.199   158.629     0.200
    11.199   159.160     0.200
    11.215   158.488     0.200
    11.215   159.457     0.200
    11.317   158.961     0.200
    11.298   159.301     0.200
    11.351   160.129     0.200
    11.483   162.277     0.200
    11.637   163.824     0.200
    11.640   161.801     0.200
    11.660   163.590     0.200
    11.660   163.793     0.200
    11.681   163.789     0.200
    11.681   165.098     0.200
    11.713   165.180     0.200
    11.702   165.695     0.200
    11.770   164.234     0.200
    12.031   167.020     0.200
    12.148   169.809     0.200
    12.148   170.488     0.200
    12.201   170.969     0.200
    12.201   173.023     0.200
    12.201   171.168     0.200
    12.195   171.559     0.200
    12.195   172.402     0.200
    12.443   173.688     0.200
    12.613   178.539     0.200
    12.613   178.387     0.200
    12.742   179.230     0.200
    12.742   180.039     0.200
    12.751   178.355     0.200
    12.785   180.117     0.200
    12.819   180.480     0.200
    12.852   180.660     0.200
    12.852   179.684     0.200
    12.878   181.617     0.200
    13.110   184.449     0.200
    13.228   184.488     0.200
    13.353   188.602     0.200
    13.855   193.617     0.200
    13.855   191.770     0.200
    14.340   200.730     0.200
    14.779   204.539     0.200
    15.041   209.047     0.200
    15.552   217.500     0.200
    17.170   233.930     0.200
    18.381   252.793     0.200
     0.300     7.543     0.200
     0.789    13.949     0.200
     1.083    18.676     0.200
     1.084    18.418     0.200
     1.210    19.809     0.200
     1.239    20.809     0.200
     1.252    21.051     0.200
     1.299    21.988     0.200
     1.321    21.660     0.200
     1.400    23.121     0.200
     1.400    23.324     0.200
     1.402    22.879     0.200
     1.408    23.438     0.200
     1.518    24.688     0.200
     1.519    24.648     0.200
     1.694    26.699     0.200
     1.798    29.570     0.200
     1.808    29.840     0.200
     1.831    28.879     0.200
     1.957    30.770     0.200
     2.086    33.438     0.200
     2.160    33.758     0.200
     2.169    33.328     0.200
     2.204    34.750     0.200
     2.237    34.230     0.200
     2.237    34.551     0.200
     2.416    37.777     0.200
     2.437    37.379     0.200
     2.437    37.504     0.200
     2.448    37.918     0.200
     2.454    37.148     0.200
     2.455    37.371     0.200
     2.493    38.480     0.200
     2.520    38.699     0.200
     2.562    38.809     0.200
     2.716    41.211     0.200
     2.891    43.500     0.200
     2.890    43.469     0.200
     2.897    44.340     0.200
     2.922    43.910     0.200
     2.995    45.211     0.200
     3.017    45.059     0.200
     3.022    45.430     0.200
     3.029    45.527     0.200
     3.075    45.824     0.200
     3.132    45.801     0.200
     3.132    46.594     0.200
     3.236    47.539     0.200
     3.269    48.141     0.200
     3.337    49.621     0.200
     3.352    49.527     0.200
     3.352    49.422     0.200
     3.367    50.301     0.200
     3.454    51.219     0.200
     3.657    53.996     0.200
     3.658    53.621     0.200
     3.669    53.918     0.200
     3.669    54.273     0.200
     3.726    56.027     0.200
     3.777    56.551     0.200
     3.773    55.438     0.200
     3.806    56.371     0.200
     3.824    56.688     0.200
     3.822    56.688     0.200
     3.897    56.879     0.200
     3.897    57.328     0.200
     3.942    57.898     0.200
     3.979    58.680     0.200
     4.069    58.770     0.200
     4.168    61.277     0.200
     4.184    61.129     0.200
     4.321    63.098     0.200
     4.321    63.246     0.200
     4.399    64.348     0.200
     4.435    65.348     0.200
     4.456    65.211     0.200
     4.479    65.770     0.200
     4.487    63.969     0.200
     4.487    64.145     0.200
     4.487    64.277     0.200
     4.487    64.828     0.200
     4.511    66.371     0.200
     4.620    65.520     0.200
     4.616    67.559     0.200
     4.666    68.270     0.200
     4.685    67.848     0.200
     4.715    69.340     0.200
     4.715    68.559     0.200
     4.779    68.480     0.200
     4.779    69.262     0.200
     4.939    71.930     0.200
     5.016    72.871     0.200
     5.047    72.801     0.200
     5.047    73.336     0.200
     5.049    73.238     0.200
     5.104    74.199     0.200
     5.141    74.098     0.200
     5.297    75.449     0.200
     5.292    76.488     0.200
     5.297    76.711     0.200
     5.324    76.551     0.200
     5.433    78.590     0.200
     5.481    78.039     0.200
     5.481    78.512     0.200
     5.570    79.891     0.200
     5.578    80.250     0.200
     5.606    81.160     0.200
     5.663    81.391     0.200
     5.664    80.758     0.200
     5.664    81.004     0.200
     5.694    81.621     0.200
     5.794    82.891     0.200
     5.798    83.891     0.200
     5.798    84.023     0.200
     5.825    84.461     0.200
     5.870    84.301     0.200
     5.870    84.688     0.200
     5.875    84.660     0.200
     5.880    84.629     0.200
     5.957    85.629     0.200
     5.957    86.102     0.200
     5.975    85.289     0.200
     5.984    85.480     0.200
     6.002    86.141     0.200
     6.043    87.277     0.200
     6.068    86.668     0.200
     6.063    87.840     0.200
     6.091    87.078     0.200
     6.118    87.129     0.200
     6.180    88.438     0.200
     6.187    88.391     0.200
     6.195    88.340     0.200
     6.216    89.527     0.200
     6.218    89.051     0.200
     6.236    89.680     0.200
     6.234    89.180     0.200
     6.269    89.430     0.200
     6.290    90.180     0.200
     6.290    90.031     0.200
     6.338    90.809     0.200
     6.386    91.930     0.200
     6.386    91.820     0.200
     6.400    91.340     0.200
     6.449    92.398     0.200
     6.479    92.551     0.200
     6.567    93.871     0.200
     6.567    94.188     0.200
     6.585    94.211     0.200
     6.648    95.211     0.200
     6.757    96.527     0.200
     6.766    96.391     0.200
     6.830    97.340     0.200
     6.866    98.234     0.200
     6.851    97.828     0.200
     6.869    98.230     0.200
     6.961    99.078     0.200
     7.073   100.918     0.200
     7.073   100.922     0.200
     7.312   103.699     0.200
     7.312   103.305     0.200
     7.367   105.410     0.200
     7.367   105.195     0.200
     7.399   104.730     0.200
     7.399   104.949     0.200
     7.390   104.559     0.200
     7.452   106.188     0.200
     7.607   107.238     0.200
     7.780   110.891     0.200
     7.794   110.211     0.200
     7.794   107.699     0.200
     7.794   109.699     0.200
     7.938   112.328     0.200
     7.960   112.828     0.200
     7.996   112.898     0.200
     8.026   114.129     0.200
     8.099   114.559     0.200
     8.111   114.660     0.200
     8.148   115.188     0.200
     8.203   115.898     0.200
     8.225   116.500     0.200
     8.308   118.738     0.200
     8.437   118.750     0.200
     8.750   124.309     0.200
     8.811   124.379     0.200
     8.965   124.570     0.200
     9.021   128.848     0.200
     9.194   129.051     0.200
     9.207   131.059     0.200
     9.241   129.121     0.200
     9.592   135.039     0.200
     9.801   138.258     0.200
     9.845   139.738     0.200
    10.107   142.180     0.200
    10.974   153.418     0.200
     1.378    23.438     0.200
     1.374    23.281     0.200
     1.365    24.156     0.200
     1.380    24.477     0.200
     1.394    24.867     0.200
     1.461    23.570     0.200
     1.464    25.203     0.200
     1.582    26.633     0.200
     1.622    26.562     0.200
     1.662    26.828     0.200
     1.643    27.109     0.200
     1.643    26.961     0.200
     1.686    28.086     0.200
     1.738    28.656     0.200
     1.874    30.312     0.200
     1.887    30.508     0.200
     2.056    32.570     0.200
     2.058    32.172     0.200
     2.292    36.219     0.200
     2.322    36.242     0.200
     2.340    36.359     0.200
     2.380    37.258     0.200
     2.411    37.578     0.200
     2.415    38.039     0.200
     2.494    38.508     0.200
     2.559    38.633     0.200
     2.903    44.461     0.200
     3.002    46.297     0.200
     3.047    46.812     0.200
     3.067    47.180     0.200
     3.068    46.297     0.200
     3.108    46.867     0.200
     3.187    48.531     0.200
     3.176    47.883     0.200
     3.247    48.289     0.200
     3.241    49.141     0.200
     3.301    50.172     0.200
     3.325    49.891     0.200
     3.420    51.383     0.200
     3.453    51.297     0.200
     3.570    52.883     0.200
     3.528    53.031     0.200
     3.660    53.469     0.200
     3.677    53.977     0.200
     3.687    54.930     0.200
     3.728    55.711     0.200
     3.796    54.812     0.200
     3.790    56.047     0.200
     3.815    56.961     0.200
     3.893    57.539     0.200
     3.965    57.758     0.200
     3.895    58.188     0.200
     4.051    59.930     0.200
     4.144    61.797     0.200
     4.275    63.203     0.200
     4.198    62.219     0.200
     4.217    62.570     0.200
     4.232    62.586     0.200
     4.342    63.922     0.200
     4.296    63.172     0.200
     4.324    63.711     0.200
     4.412    64.547     0.200
     4.384    65.016     0.200
     4.497    65.961     0.200
     4.522    66.719     0.200
     4.627    68.180     0.200
     4.603    68.648     0.200
     4.652    68.422     0.200
     4.782    70.242     0.200
     4.871    71.312     0.200
     5.008    72.477     0.200
     4.941    72.688     0.200
     5.046    72.820     0.200
     5.106    74.906     0.200
     5.037    73.547     0.200
     5.187    74.766     0.200
     5.193    75.289     0.200
     5.141    75.148     0.200
     5.249    75.867     0.200
     5.278    76.547     0.200
     5.228    75.828     0.200
     5.324    76.898     0.200
     5.263    76.648     0.200
     5.325    78.320     0.200
     5.385    79.117     0.200
     5.387    78.969     0.200
     5.485    79.453     0.200
     5.436    79.266     0.200
     5.529    80.703     0.200
     5.536    80.906     0.200
     5.490    80.016     0.200
     5.801    83.977     0.200
     5.754    83.547     0.200
     5.990    86.992     0.200
     5.931    85.422     0.200
     6.079    87.922     0.200
     6.063    87.789     0.200
     6.077    88.516     0.200
     6.179    89.477     0.200
     6.242    91.062     0.200
     6.266    91.008     0.200
     6.525    94.180     0.200
     6.608    94.891     0.200
     6.557    94.828     0.200
     6.606    95.531     0.200
     6.677    95.461     0.200
     6.872    98.102     0.200
     6.996   100.477     0.200
     7.022   100.148     0.200
     7.022   100.250     0.200
     7.074    99.359     0.200
     7.193   103.289     0.200
     7.262   104.406     0.200
     7.518   106.938     0.200
     7.495   107.578     0.200
     7.484   107.391     0.200
     7.592   107.797     0.200
     7.729   109.898     0.200
     7.728   110.281     0.200
     7.845   112.492     0.200
     7.939   113.242     0.200
     8.181   114.969     0.200
     8.255   116.477     0.200
     8.307   119.562     0.200
     8.366   118.031     0.200
     8.488   120.031     0.200
     8.581   121.352     0.200
     9.057   128.500     0.200
     9.052   127.602     0.200
     9.302   132.172     0.200
     9.581   138.117     0.200
     9.845   138.406     0.200
    10.034   143.508     0.200
    10.323   145.656     0.200
     1.759    29.551     0.200
     1.760    29.527     0.200
     1.750    29.088     0.200
     1.774    29.967     0.200
     1.775    29.736     0.200
     1.804    30.377     0.200
     1.826    30.787     0.200
     1.828    30.617     0.200
     1.893    31.207     0.200
     1.885    31.088     0.200
     1.926    31.428     0.200
     2.026    33.107     0.200
     2.026    33.277     0.200
     2.026    33.092     0.200
     2.024    32.646     0.200
     2.025    33.168     0.200
     2.055    34.377     0.200
     2.055    34.543     0.200
     2.098    33.977     0.200
     2.602    41.768     0.200
     2.711    42.117     0.200
     2.740    42.777     0.200
     2.763    44.168     0.200
     2.763    43.695     0.200
     2.816    44.396     0.200
     2.875    45.438     0.200
     2.875    45.145     0.200
     2.838    43.977     0.200
     2.902    45.316     0.200
     3.105    47.707     0.200
     3.097    47.787     0.200
     3.097    47.916     0.200
     3.094    48.127     0.200
     3.128    48.508     0.200
     3.171    49.098     0.200
     3.162    48.678     0.200
     3.162    48.842     0.200
     3.203    50.098     0.200
     3.366    51.768     0.200
     3.364    50.906     0.200
     3.397    51.617     0.200
     3.536    54.098     0.200
     3.572    54.396     0.200
     3.565    53.857     0.200
     3.603    54.807     0.200
     3.612    55.184     0.200
     3.611    54.758     0.200
     3.676    56.027     0.200
     3.705    55.906     0.200
     3.711    56.078     0.200
     3.746    55.617     0.200
     3.771    56.875     0.200
     3.922    58.748     0.200
     4.005    60.357     0.200
     4.005    60.215     0.200
     3.990    60.578     0.200
     3.990    60.279     0.200
     4.058    61.438     0.200
     4.058    61.023     0.200
     4.194    61.936     0.200
     4.212    63.057     0.200
     4.234    62.816     0.200
     4.320    63.797     0.200
     4.320    64.184     0.200
     4.340    65.051     0.200
     4.341    64.867     0.200
     4.400    66.057     0.200
     4.552    67.617     0.200
     4.552    67.445     0.200
     4.683    68.857     0.200
     4.683    68.756     0.200
     4.661    69.467     0.200
     4.642    69.018     0.200
     4.812    71.668     0.200
     4.922    71.848     0.200
     4.909    73.078     0.200
     4.927    72.688     0.200
     5.000    74.236     0.200
     5.000    73.385     0.200
     5.068    73.428     0.200
     5.033    74.887     0.200
     5.063    75.008     0.200
     5.063    74.551     0.200
     5.044    74.057     0.200
     5.122    75.197     0.200
     5.122    75.689     0.200
     5.132    74.777     0.200
     5.176    74.656     0.200
     5.122    76.008     0.200
     5.162    75.688     0.200
     5.162    75.500     0.200
     5.132    75.098     0.200
     5.177    76.107     0.200
     5.303    77.578     0.200
     5.303    77.264     0.200
     5.338    77.986     0.200
     5.373    79.787     0.200
     5.373    79.209     0.200
     5.498    80.748     0.200
     5.475    80.477     0.200
     5.629    81.607     0.200
     5.629    82.035     0.200
     5.612    82.156     0.200
     5.637    83.678     0.200
     5.637    82.639     0.200
     5.718    83.066     0.200
     5.765    84.287     0.200
     5.820    85.768     0.200
     5.820    84.840     0.200
     5.905    86.236     0.200
     5.905    85.721     0.200
     6.004    87.348     0.200
     6.004    86.771     0.200
     6.036    88.367     0.200
     6.000    87.318     0.200
     6.223    91.188     0.200
     6.304    92.258     0.200
     6.313    91.188     0.200
     6.429    93.447     0.200
     6.429    92.686     0.200
     6.350    91.348     0.200
     6.357    91.867     0.200
     6.393    93.787     0.200
     6.393    93.287     0.200
     6.428    93.457     0.200
     6.497    95.787     0.200
     6.563    95.877     0.200
     6.603    95.287     0.200
     6.606    95.607     0.200
     6.723    97.406     0.200
     6.765    98.258     0.200
     6.831    98.906     0.200
     6.827    99.477     0.200
     6.889   100.438     0.200
     6.889   100.205     0.200
     7.162   103.578     0.200
     7.226   104.688     0.200
     7.331   105.406     0.200
     7.321   105.998     0.200
     7.414   106.967     0.200
     7.748   112.486     0.200
     7.872   113.518     0.200
     8.241   117.957     0.200
     8.321   120.557     0.200
     8.388   121.418     0.200
     8.460   121.807     0.200
     8.460   121.566     0.200
     8.466   122.297     0.200
     8.474   120.627     0.200
     8.555   122.957     0.200
     8.712   125.457     0.200
     9.123   130.168     0.200
     9.467   135.957     0.200
     9.733   138.646     0.200
     9.855   140.688     0.200
     9.954   141.027     0.200
    10.260   147.777     0.200
    11.113   158.207     0.200
    11.895   169.357     0.200
    12.030   170.498     0.200
    12.441   178.143     0.200
    14.471   205.367     0.200
    14.471   205.217     0.200
    19.984   272.047     0.200
     0.514    12.158     0.200
     0.536    12.698     0.200
     0.536    12.573     0.200
     0.663    14.173     0.200
     0.664    14.238     0.200
     0.783    14.928     0.200
     0.787    15.088     0.200
     0.788    15.048     0.200
     0.813    15.749     0.200
     0.856    16.458     0.200
     0.899    16.648     0.200
     0.903    16.868     0.200
     0.936    17.148     0.200
     0.950    17.269     0.200
     0.967    17.968     0.200
     0.974    18.278     0.200
     0.986    17.948     0.200
     0.994    18.519     0.200
     1.026    18.328     0.200
     1.187    20.388     0.200
     1.187    20.198     0.200
     1.218    20.898     0.200
     1.220    20.898     0.200
     1.275    22.229     0.200
     1.314    21.749     0.200
     1.591    26.269     0.200
     1.610    26.328     0.200
     1.618    26.828     0.200
     1.634    26.398     0.200
     1.654    26.948     0.200
     1.665    27.499     0.200
     1.671    27.258     0.200
     1.687    27.438     0.200
     1.686    27.108     0.200
     1.688    27.218     0.200
     1.710    27.688     0.200
     1.763    28.878     0.200
     1.845    29.358     0.200
     1.868    29.289     0.200
     1.868    29.598     0.200
     1.958    30.638     0.200
     2.000    31.208     0.200
     2.073    32.678     0.200
     2.118    33.548     0.200
     2.135    33.519     0.200
     2.200    34.698     0.200
     2.240    35.398     0.200
     2.252    35.298     0.200
     2.268    35.378     0.200
     2.278    35.028     0.200
     2.280    35.468     0.200
     2.384    36.968     0.200
     2.469    38.249     0.200
     2.575    39.418     0.200
     2.624    40.058     0.200
     2.684    41.378     0.200
     2.729    40.928     0.200
     2.731    40.548     0.200
     2.807    41.718     0.200
     2.819    42.618     0.200
     2.825    42.828     0.200
     2.868    43.628     0.200
     2.877    42.999     0.200
     2.893    43.718     0.200
     2.893    43.499     0.200
     2.900    44.405     0.200
     2.901    44.408     0.200
     2.927    44.578     0.200
     2.940    45.258     0.200
     3.012    46.078     0.200
     3.015    46.458     0.200
     3.237    48.798     0.200
     3.304    49.499     0.200
     3.332    49.738     0.200
     3.340    50.148     0.200
     3.353    49.499     0.200
     3.353    49.898     0.200
     3.369    50.448     0.200
     3.396    51.188     0.200
     3.507    53.058     0.200
     3.564    52.828     0.200
     3.585    53.618     0.200
     3.585    53.473     0.200
     3.741    55.278     0.200
     3.741    55.146     0.200
     3.753    56.088     0.200
     3.781    56.658     0.200
     3.788    56.539     0.200
     3.788    56.323     0.200
     3.791    56.289     0.200
     3.852    57.168     0.200
     3.863    57.624     0.200
     3.862    57.628     0.200
     3.894    58.298     0.200
     3.894    56.567     0.200
     3.900    58.258     0.200
     3.911    56.668     0.200
     3.911    56.999     0.200
     3.980    57.789     0.200
     4.083    60.019     0.200
     4.101    60.749     0.200
     4.115    60.019     0.200
     4.132    58.958     0.200
     4.136    61.238     0.200
     4.142    60.088     0.200
     4.287    63.128     0.200
     4.317    62.618     0.200
     4.318    61.398     0.200
     4.347    63.078     0.200
     4.424    64.878     0.200
     4.441    65.398     0.200
     4.446    65.249     0.200
     4.446    65.073     0.200
     4.497    65.428     0.200
     4.545    65.168     0.200
     4.658    67.368     0.200
     4.704    68.948     0.200
     4.810    69.238     0.200
     4.857    70.428     0.200
     4.868    70.258     0.200
     4.873    70.550     0.200
     4.881    70.548     0.200
     4.919    71.568     0.200
     4.951    71.318     0.200
     4.964    71.838     0.200
     4.985    72.418     0.200
     5.020    72.148     0.200
     5.027    72.628     0.200
     5.093    73.298     0.200
     5.095    73.598     0.200
     5.097    73.249     0.200
     5.149    74.668     0.200
     5.233    74.778     0.200
     5.242    75.668     0.200
     5.323    76.789     0.200
     5.336    76.988     0.200
     5.382    76.638     0.200
     5.452    79.138     0.200
     5.480    78.808     0.200
     5.533    79.028     0.200
     5.542    79.738     0.200
     5.541    79.479     0.200
     5.553    80.769     0.200
     5.598    80.238     0.200
     5.664    80.858     0.200
     5.687    80.878     0.200
     5.704    82.198     0.200
     5.789    82.418     0.200
     5.800    83.358     0.200
     5.793    83.249     0.200
     5.809    83.798     0.200
     5.809    83.512     0.200
     5.811    83.308     0.200
     5.814    82.888     0.200
     5.834    82.883     0.200
     5.849    83.348     0.200
     5.855    83.938     0.200
     5.855    83.578     0.200
     5.862    83.898     0.200
     5.885    84.058     0.200
     5.983    85.808     0.200
     6.078    86.958     0.200
     6.141    87.718     0.200
     6.230    88.658     0.200
     6.230    88.868     0.200
     6.273    89.398     0.200
     6.584    92.878     0.200
     6.606    94.088     0.200
     6.641    94.168     0.200
     6.675    95.539     0.200
     6.715    95.787     0.200
     6.718    95.789     0.200
     6.796    96.749     0.200
     6.793    96.758     0.200
     6.821    96.698     0.200
     6.834    97.048     0.200
     6.838    98.298     0.200
     6.853    97.618     0.200
     7.050    99.428     0.200
     7.050   100.198     0.200
     7.047   100.188     0.200
     7.047   100.189     0.200
     7.061    99.778     0.200
     7.066    99.848     0.200
     7.148   102.418     0.200
     7.149   100.598     0.200
     7.149   100.448     0.200
     7.218   103.988     0.200
     7.221   102.539     0.200
     7.266   102.778     0.200
     7.299   103.528     0.200
     7.347   103.019     0.200
     7.368   103.708     0.200
     7.385   104.808     0.200
     7.420   105.648     0.200
     7.434   105.999     0.200
     7.597   107.488     0.200
     7.776   109.718     0.200
     7.907   111.539     0.200
     7.930   111.318     0.200
     8.152   115.658     0.200
     8.273   116.138     0.200
     8.498   118.898     0.200
     8.507   119.769     0.200
     8.505   120.738     0.200
     8.529   120.098     0.200
     8.710   123.249     0.200
     8.862   126.138     0.200
     9.500   134.999     0.200
    10.097   144.499     0.200
    12.337   172.648     0.200
    13.328   183.999     0.200
     0.256    12.969     0.200
     0.302    12.570     0.200
     0.380    13.449     0.200
     0.397    13.340     0.200
     0.441    13.980     0.200
     0.548    14.180     0.200
     0.596    14.770     0.200
     0.582    15.020     0.200
     0.576    15.242     0.200
     0.868    17.652     0.200
     0.948    18.270     0.200
     0.995    18.949     0.200
     1.052    19.840     0.200
     1.188    21.141     0.200
     1.227    21.879     0.200
     1.336    23.141     0.200
     1.385    24.492     0.200
     1.406    24.109     0.200
     1.474    25.730     0.200
     1.475    25.820     0.200
     1.563    25.770     0.200
     1.560    25.672     0.200
     1.781    29.660     0.200
     1.794    29.250     0.200
     1.920    30.711     0.200
     2.071    32.699     0.200
     2.098    33.691     0.200
     2.139    33.852     0.200
     2.156    34.441     0.200
     2.304    35.070     0.200
     2.284    35.402     0.200
     2.286    35.859     0.200
     2.306    36.730     0.200
     2.362    36.941     0.200
     2.572    39.930     0.200
     2.616    40.941     0.200
     2.622    40.820     0.200
     2.648    40.211     0.200
     2.668    40.902     0.200
     2.673    41.359     0.200
     2.700    40.770     0.200
     2.741    41.730     0.200
     2.750    42.340     0.200
     2.748    42.410     0.200
     2.792    43.062     0.200
     2.842    43.172     0.200
     3.054    46.062     0.200
     3.146    47.551     0.200
     3.390    50.730     0.200
     3.401    51.289     0.200
     3.434    51.590     0.200
     3.434    50.410     0.200
     3.462    51.820     0.200
     3.469    52.340     0.200
     3.569    52.949     0.200
     3.588    53.770     0.200
     3.629    54.152     0.200
     3.748    55.961     0.200
     3.910    58.500     0.200
     3.972    59.020     0.200
     3.973    58.301     0.200
     4.006    59.121     0.200
     4.148    60.609     0.200
     4.118    61.020     0.200
     4.248    62.719     0.200
     4.260    62.582     0.200
     4.286    62.730     0.200
     4.334    63.410     0.200
     4.379    64.230     0.200
     4.427    64.812     0.200
     4.529    66.121     0.200
     4.544    65.492     0.200
     4.640    67.152     0.200
     4.744    68.449     0.200
     4.861    70.312     0.200
     4.896    71.301     0.200
     4.905    70.852     0.200
     4.932    71.332     0.200
     4.968    71.191     0.200
     4.964    71.812     0.200
     4.961    70.961     0.200
     5.030    71.621     0.200
     5.155    74.609     0.200
     5.264    75.379     0.200
     5.310    76.840     0.200
     5.322    76.051     0.200
     5.394    77.570     0.200
     5.485    80.039     0.200
     5.517    79.121     0.200
     5.525    79.871     0.200
     5.609    80.031     0.200
     5.647    80.672     0.200
     5.721    81.371     0.200
     5.741    82.449     0.200
     5.814    83.332     0.200
     5.829    83.320     0.200
     5.915    84.781     0.200
     5.950    85.980     0.200
     5.950    84.602     0.200
     6.129    87.590     0.200
     6.157    87.402     0.200
     6.210    88.520     0.200
     6.246    88.902     0.200
     6.387    90.711     0.200
     6.501    92.281     0.200
     6.515    92.262     0.200
     6.536    93.141     0.200
     6.552    93.562     0.200
     6.566    93.191     0.200
     6.578    93.492     0.200
     6.585    93.922     0.200
     6.679    95.082     0.200
     6.738    95.961     0.200
     6.864    97.449     0.200
     6.953    98.949     0.200
     6.952    98.852     0.200
     6.993    99.730     0.200
     7.177   102.160     0.200
     7.298   103.461     0.200
     7.303   103.672     0.200
     7.318   103.770     0.200
     7.394   104.492     0.200
     7.397   104.930     0.200
     7.397   104.301     0.200
     7.441   105.512     0.200
     7.557   106.902     0.200
     7.584   106.219     0.200
     7.666   108.570     0.200
     7.711   108.379     0.200
     7.735   109.359     0.200
     7.951   112.879     0.200
     7.966   112.312     0.200
     8.438   117.219     0.200
     8.627   121.730     0.200
     9.219   129.832     0.200
     0.290     8.070     0.200
     0.290     8.469     0.200
     0.290     8.340     0.200
     0.753    14.059     0.200
     0.745    14.352     0.200
     0.745    14.672     0.200
     1.197    19.059     0.200
     1.329    22.020     0.200
     1.348    22.020     0.200
     1.394    22.742     0.200
     1.394    22.891     0.200
     1.481    24.000     0.200
     1.489    24.832     0.200
     1.502    24.379     0.200
     1.542    25.039     0.200
     1.573    25.832     0.200
     1.638    26.301     0.200
     1.652    26.395     0.200
     1.684    27.500     0.200
     1.787    28.879     0.200
     1.865    29.672     0.200
     1.864    29.547     0.200
     1.871    29.242     0.200
     2.104    33.047     0.200
     2.106    33.031     0.200
     2.119    32.480     0.200
     2.160    33.770     0.200
     2.160    34.027     0.200
     2.216    33.980     0.200
     2.216    34.648     0.200
     2.266    34.301     0.200
     2.616    39.398     0.200
     2.616    40.070     0.200
     2.599    40.461     0.200
     2.607    40.270     0.200
     2.924    43.410     0.200
     2.915    44.641     0.200
     2.915    44.320     0.200
     3.075    45.945     0.200
     3.201    48.199     0.200
     3.209    48.539     0.200
     3.209    48.367     0.200
     3.248    48.832     0.200
     3.283    48.691     0.200
     3.395    49.941     0.200
     3.395    50.484     0.200
     3.390    50.730     0.200
     3.410    51.660     0.200
     3.498    51.398     0.200
     3.513    52.059     0.200
     3.722    54.398     0.200
     3.717    55.172     0.200
     3.694    54.289     0.200
     3.694    54.770     0.200
     3.761    56.520     0.200
     3.776    56.082     0.200
     3.838    56.930     0.200
     3.881    57.641     0.200
     3.895    57.879     0.200
     3.914    57.840     0.200
     3.950    58.059     0.200
     3.950    58.273     0.200
     3.991    58.609     0.200
     4.010    59.461     0.200
     4.208    60.500     0.200
     4.336    63.500     0.200
     4.336    63.371     0.200
     4.305    62.359     0.200
     4.487    65.309     0.200
     4.487    65.590     0.200
     4.457    64.781     0.200
     4.545    66.395     0.200
     4.573    67.039     0.200
     4.583    67.031     0.200
     4.616    67.559     0.200
     4.745    69.039     0.200
     4.828    70.191     0.200
     4.854    70.789     0.200
     4.854    70.516     0.200
     4.884    71.121     0.200
     4.926    71.160     0.200
     5.033    73.242     0.200
     5.033    73.418     0.200
     5.126    75.141     0.200
     5.388    78.699     0.200
     5.388    77.309     0.200
     5.432    79.871     0.200
     5.482    78.129     0.200
     5.542    80.359     0.200
     5.509    78.691     0.200
     5.549    79.609     0.200
     5.549    79.160     0.200
     5.559    80.371     0.200
     5.541    79.262     0.200
     5.541    79.129     0.200
     5.576    78.660     0.200
     5.576    78.988     0.200
     5.714    81.922     0.200
     5.713    80.371     0.200
     5.873    83.090     0.200
     5.873    83.371     0.200
     5.899    84.500     0.200
     5.990    86.500     0.200
     5.990    85.180     0.200
     6.121    87.770     0.200
     6.186    89.590     0.200
     6.186    87.992     0.200
     6.219    89.102     0.200
     6.205    88.461     0.200
     6.205    88.637     0.200
     6.222    88.750     0.200
     6.228    89.371     0.200
     6.308    89.789     0.200
     6.412    91.461     0.200
     6.412    91.316     0.200
     6.566    94.480     0.200
     6.574    92.930     0.200
     6.574    93.242     0.200
     6.658    94.801     0.200
     6.652    94.570     0.200
     6.697    95.059     0.200
     6.728    96.648     0.200
     6.728    95.699     0.200
     6.719    95.309     0.200
     6.768    97.770     0.200
     6.767    96.191     0.200
     6.767    96.523     0.200
     6.875    97.289     0.200
     6.969    99.461     0.200
     6.969    99.055     0.200
     6.981    99.301     0.200
     6.963    99.250     0.200
     6.963    98.758     0.200
     6.945    98.879     0.200
     7.070   100.648     0.200
     7.172   101.922     0.200
     7.163   101.520     0.200
     7.227   102.859     0.200
     7.206   102.762     0.200
     7.206   102.141     0.200
     7.184   102.121     0.200
     7.195   101.480     0.200
     7.203   101.641     0.200
     7.314   104.172     0.200
     7.314   103.461     0.200
     7.388   105.551     0.200
     7.413   104.730     0.200
     7.519   107.449     0.200
     7.504   106.172     0.200
     7.486   105.629     0.200
     7.569   107.000     0.200
     7.636   108.301     0.200
     7.636   108.484     0.200
     7.665   108.559     0.200
     7.851   112.090     0.200
     7.951   113.281     0.200
     8.038   114.102     0.200
     8.159   115.969     0.200
     8.213   116.109     0.200
     8.230   114.930     0.200
     8.435   118.691     0.200
     8.382   118.391     0.200
     8.453   118.480     0.200
     8.477   119.320     0.200
     8.442   119.730     0.200
     8.427   118.371     0.200
     8.495   118.621     0.200
     8.573   121.648     0.200
     8.580   122.230     0.200
     8.544   121.559     0.200
     8.693   121.570     0.200
     8.713   121.691     0.200
     8.713   122.320     0.200
     8.698   123.141     0.200
     8.797   125.020     0.200
     8.785   123.082     0.200
     8.785   122.922     0.200
     8.838   124.590     0.200
     8.907   125.590     0.200
     8.888   125.879     0.200
     8.906   125.832     0.200
     8.984   126.172     0.200
     9.207   130.070     0.200
     9.243   130.160     0.200
     9.890   138.340     0.200
    10.289   146.129     0.200
    10.440   145.770     0.200
    10.866   151.969     0.200
    12.365   175.770     0.200
    14.909   208.445     0.200
     1.090    18.914     0.200
     1.090    19.172     0.200
     1.267    21.789     0.200
     1.743    28.281     0.200
     1.741    28.078     0.200
     1.768    28.359     0.200
     1.946    31.789     0.200
     1.944    31.391     0.200
     1.984    31.539     0.200
     1.999    31.500     0.200
     2.141    33.188     0.200
     2.175    33.578     0.200
     2.135    33.352     0.200
     2.135    33.344     0.200
     2.266    33.781     0.200
     2.198    35.219     0.200
     2.378    37.188     0.200
     2.377    37.070     0.200
     2.541    39.719     0.200
     2.542    39.352     0.200
     2.659    41.883     0.200
     2.659    41.680     0.200
     2.686    41.078     0.200
     2.902    42.945     0.200
     2.901    42.914     0.200
     3.100    48.078     0.200
     3.105    48.227     0.200
     3.132    47.312     0.200
     3.132    47.422     0.200
     3.362    49.617     0.200
     3.362    50.070     0.200
     3.410    51.969     0.200
     3.410    52.172     0.200
     3.587    51.211     0.200
     3.587    51.672     0.200
     3.587    51.773     0.200
     3.589    53.578     0.200
     3.589    53.922     0.200
     3.632    54.289     0.200
     3.744    55.977     0.200
     3.773    55.219     0.200
     3.773    55.445     0.200
     3.789    56.609     0.200
     3.855    56.352     0.200
     3.896    58.688     0.200
     3.896    58.844     0.200
     3.902    58.453     0.200
     3.927    57.500     0.200
     3.931    58.078     0.200
     4.112    59.969     0.200
     4.209    62.508     0.200
     4.254    63.078     0.200
     4.270    63.477     0.200
     4.463    65.492     0.200
     4.463    65.672     0.200
     4.490    65.391     0.200
     4.523    67.250     0.200
     4.523    67.070     0.200
     4.607    65.977     0.200
     4.607    66.867     0.200
     4.737    68.719     0.200
     4.737    68.898     0.200
     4.741    68.898     0.200
     4.785    69.812     0.200
     4.843    71.062     0.200
     4.850    71.039     0.200
     4.850    70.867     0.200
     4.921    71.562     0.200
     5.035    74.094     0.200
     5.036    73.617     0.200
     5.106    74.883     0.200
     5.218    74.203     0.200
     5.218    74.555     0.200
     5.258    76.570     0.200
     5.319    77.414     0.200
     5.308    76.781     0.200
     5.308    76.930     0.200
     5.357    77.609     0.200
     5.357    77.773     0.200
     5.366    77.172     0.200
     5.366    77.516     0.200
     5.370    78.297     0.200
     5.501    79.953     0.200
     5.501    80.336     0.200
     5.630    82.492     0.200
     5.630    82.672     0.200
     5.875    84.500     0.200
     5.902    85.719     0.200
     5.902    86.211     0.200
     5.980    86.391     0.200
     5.980    87.320     0.200
     5.964    85.070     0.200
     5.964    85.328     0.200
     6.033    86.328     0.200
     6.069    85.531     0.200
     6.054    87.312     0.200
     6.155    87.812     0.200
     6.204    88.828     0.200
     6.204    88.672     0.200
     6.204    89.102     0.200
     6.188    88.500     0.200
     6.188    88.906     0.200
     6.199    90.094     0.200
     6.276    90.367     0.200
     6.330    90.797     0.200
     6.392    91.273     0.200
     6.622    94.039     0.200
     6.618    94.953     0.200
     6.618    95.102     0.200
     6.648    95.297     0.200
     6.648    95.695     0.200
     6.700    96.523     0.200
     6.700    97.070     0.200
     6.700    97.688     0.200
     6.743    95.938     0.200
     6.703    97.117     0.200
     6.703    97.977     0.200
     6.889    95.992     0.200
     6.738    96.711     0.200
     6.788    96.539     0.200
     6.905    98.156     0.200
     6.938    97.914     0.200
     7.040   101.445     0.200
     7.077   101.641     0.200
     7.117   101.992     0.200
     7.136   102.062     0.200
     7.169   102.461     0.200
     7.208   102.469     0.200
     7.174   103.164     0.200
     7.228   104.320     0.200
     7.400   102.969     0.200
     7.282   105.008     0.200
     7.321   104.242     0.200
     7.321   104.719     0.200
     7.465   105.961     0.200
     7.453   106.617     0.200
     7.502   106.438     0.200
     7.605   108.961     0.200
     7.639   108.961     0.200
     7.650   108.898     0.200
     7.650   109.375     0.200
     7.675   108.859     0.200
     7.741   110.742     0.200
     7.741   111.062     0.200
     7.781   110.359     0.200
     7.878   111.508     0.200
     7.900   112.750     0.200
     7.942   112.531     0.200
     7.973   114.430     0.200
     7.998   114.133     0.200
     8.311   117.469     0.200
     8.352   118.648     0.200
     8.352   118.352     0.200
     8.597   121.641     0.200
     8.625   122.070     0.200
     8.790   124.953     0.200
     8.837   125.797     0.200
     8.931   125.602     0.200
     8.931   125.812     0.200
     8.980   126.672     0.200
     9.183   129.797     0.200
     9.200   129.742     0.200
     9.247   130.211     0.200
     9.247   130.898     0.200
     9.247   127.797     0.200
     9.276   131.570     0.200
     9.415   133.070     0.200
     9.461   133.867     0.200
     9.718   137.227     0.200
     9.885   139.969     0.200
     9.985   140.023     0.200
    10.599   148.641     0.200
    10.670   151.250     0.200
    10.688   150.852     0.200
    10.876   153.164     0.200
    10.803   152.617     0.200
    11.067   156.148     0.200
    11.274   159.430     0.200
    11.432   160.789     0.200
    11.931   167.289     0.200
    12.054   167.844     0.200
    13.273   186.242     0.200
    13.811   190.641     0.200
    13.813   192.031     0.200
    14.253   200.062     0.200
    15.327   214.023     0.200
    15.327   215.547     0.200
     1.168    20.188     0.200
     1.168    20.516     0.200
     1.368    23.312     0.200
     1.833    29.484     0.200
     1.833    29.945     0.200
     1.845    30.000     0.200
     1.845    29.859     0.200
     2.086    33.375     0.200
     2.100    33.234     0.200
     2.190    34.641     0.200
     2.235    35.117     0.200
     2.289    34.984     0.200
     2.300    36.852     0.200
     2.480    38.695     0.200
     2.480    38.922     0.200
     2.480    38.695     0.200
     2.627    40.875     0.200
     2.628    40.703     0.200
     2.756    43.117     0.200
     2.756    43.438     0.200
     2.924    45.414     0.200
     2.923    44.562     0.200
     3.209    47.914     0.200
     3.234    49.062     0.200
     3.234    48.898     0.200
     3.456    51.375     0.200
     3.506    53.242     0.200
     3.506    53.492     0.200
     3.583    53.055     0.200
     3.691    55.367     0.200
     3.691    55.625     0.200
     3.715    55.672     0.200
     3.822    57.422     0.200
     3.841    57.570     0.200
     3.951    58.844     0.200
     3.991    60.266     0.200
     4.010    59.031     0.200
     4.012    59.562     0.200
     4.197    61.891     0.200
     4.402    64.820     0.200
     4.349    65.062     0.200
     4.565    67.266     0.200
     4.591    66.820     0.200
     4.624    68.344     0.200
     4.624    68.477     0.200
     4.817    70.195     0.200
     4.817    70.461     0.200
     4.952    72.633     0.200
     5.013    73.375     0.200
     5.407    78.266     0.200
     5.459    79.211     0.200
     5.592    81.375     0.200
     5.884    84.250     0.200
     6.003    87.836     0.200
     6.070    88.344     0.200
     6.136    86.805     0.200
     6.132    89.172     0.200
     6.156    89.055     0.200
     6.442    92.445     0.200
     6.586    93.812     0.200
     6.697    95.992     0.200
     6.792    97.234     0.200
     6.802    98.586     0.200
     7.550   107.906     0.200
     7.565   107.188     0.200
     7.993   113.727     0.200
     8.361   118.445     0.200
     8.999   128.586     0.200
     9.028   127.727     0.200
     9.336   129.539     0.200
     9.460   134.172     0.200
     9.818   139.242     0.200
    12.144   170.023     0.200
    14.388   203.438     0.200
    15.406   217.094     0.200
    15.406   217.344     0.200
    20.920   282.086     0.200
     1.231    22.617     0.200
     1.433    25.734     0.200
     1.490    27.555     0.200
     1.637    28.594     0.200
     1.690    30.062     0.200
     1.885    32.141     0.200
     2.021    34.070     0.200
     2.072    35.016     0.200
     2.098    35.156     0.200
     2.147    36.242     0.200
     2.157    36.188     0.200
     2.201    36.992     0.200
     2.212    36.977     0.200
     2.287    37.938     0.200
     2.482    41.258     0.200
     2.493    41.195     0.200
     2.537    42.117     0.200
     2.550    41.914     0.200
     2.545    41.508     0.200
     2.672    43.625     0.200
     2.700    44.016     0.200
     2.779    44.742     0.200
     2.778    44.562     0.200
     2.878    44.797     0.200
     2.918    46.070     0.200
     3.147    49.320     0.200
     3.139    49.211     0.200
     3.146    50.102     0.200
     3.359    52.867     0.200
     3.375    53.086     0.200
     3.550    55.266     0.200
     3.703    58.188     0.200
     3.740    57.992     0.200
     3.852    58.883     0.200
     3.840    59.266     0.200
     4.162    63.586     0.200
     4.244    65.117     0.200
     4.299    66.164     0.200
     4.460    67.844     0.200
     4.530    68.703     0.200
     4.611    69.094     0.200
     4.795    73.172     0.200
     4.797    71.602     0.200
     4.980    75.055     0.200
     5.104    76.688     0.200
     5.139    77.391     0.200
     5.330    80.391     0.200
     5.408    81.875     0.200
     5.434    81.008     0.200
     5.432    80.891     0.200
     5.412    81.227     0.200
     5.492    82.266     0.200
     5.573    83.555     0.200
     5.609    83.492     0.200
     5.724    86.062     0.200
     5.754    86.852     0.200
     5.756    87.242     0.200
     6.021    89.406     0.200
     6.008    89.266     0.200
     6.119    90.203     0.200
     6.153    91.766     0.200
     6.238    92.742     0.200
     6.264    92.531     0.200
     6.275    92.438     0.200
     6.321    92.305     0.200
     6.417    94.375     0.200
     6.576    97.336     0.200
     6.562    97.453     0.200
     7.178   104.055     0.200
     7.280   105.984     0.200
     7.399   108.242     0.200
     7.510   109.883     0.200
     7.501   109.883     0.200
     7.604   110.625     0.200
     7.604   110.266     0.200
     7.668   111.992     0.200
     7.744   112.945     0.200
     7.768   113.312     0.200
     7.835   114.453     0.200
     7.920   114.977     0.200
     7.970   115.664     0.200
     8.252   120.031     0.200
     8.344   121.883     0.200
     8.449   122.305     0.200
     8.691   125.695     0.200
     8.910   128.906     0.200
     8.979   130.555     0.200
     8.969   129.852     0.200
     9.116   132.273     0.200
     9.190   132.836     0.200
    10.384   148.758     0.200
     0.174     6.762     0.200
     0.174     6.590     0.200
     0.679    12.492     0.200
     0.792    14.703     0.200
     0.793    14.699     0.200
     0.897    15.430     0.200
     1.090    18.562     0.200
     1.145    19.500     0.200
     1.286    21.902     0.200
     1.351    22.633     0.200
     1.376    22.910     0.200
     1.387    23.230     0.200
     1.487    23.730     0.200
     1.434    23.871     0.200
     1.627    26.223     0.200
     1.651    26.320     0.200
     1.806    29.109     0.200
     1.876    29.910     0.200
     1.913    30.422     0.200
     1.968    30.242     0.200
     2.171    33.383     0.200
     2.163    33.852     0.200
     2.176    33.840     0.200
     2.231    35.141     0.200
     2.299    35.262     0.200
     2.338    35.641     0.200
     2.457    37.812     0.200
     2.566    39.152     0.200
     2.602    39.699     0.200
     2.610    40.070     0.200
     2.635    40.082     0.200
     2.741    41.961     0.200
     2.863    42.230     0.200
     2.985    44.180     0.200
     3.074    46.383     0.200
     3.229    48.082     0.200
     3.223    47.902     0.200
     3.404    49.383     0.200
     3.366    50.152     0.200
     3.367    50.152     0.200
     3.474    51.699     0.200
     3.527    51.793     0.200
     3.612    53.301     0.200
     3.877    56.922     0.200
     3.974    57.879     0.200
     3.972    57.883     0.200
     3.936    57.812     0.200
     4.009    58.941     0.200
     4.036    59.402     0.200
     4.127    60.102     0.200
     4.187    60.391     0.200
     4.239    61.973     0.200
     4.400    64.680     0.200
     4.390    64.172     0.200
     4.438    65.012     0.200
     4.447    65.301     0.200
     4.611    66.793     0.200
     4.660    68.633     0.200
     4.821    69.211     0.200
     4.866    70.680     0.200
     4.912    71.340     0.200
     4.994    72.020     0.200
     5.067    72.980     0.200
     5.076    73.680     0.200
     5.100    73.590     0.200
     5.247    75.043     0.200
     5.362    76.609     0.200
     5.318    75.422     0.200
     5.380    77.211     0.200
     5.546    79.781     0.200
     5.622    80.871     0.200
     5.921    85.012     0.200
     6.079    88.102     0.200
     6.186    88.242     0.200
     6.204    89.062     0.200
     6.297    90.301     0.200
     6.368    90.961     0.200
     6.564    94.031     0.200
     6.660    95.371     0.200
     6.637    94.672     0.200
     6.758    96.449     0.200
     7.218   103.730     0.200
     7.505   103.270     0.200
     7.760   110.680     0.200
     7.857   112.141     0.200
     8.069   113.750     0.200
     8.163   116.410     0.200
     8.522   120.840     0.200
     8.692   123.672     0.200
     8.862   124.590     0.200
     8.792   124.121     0.200
     8.968   126.641     0.200
     9.059   128.102     0.200
     9.017   126.223     0.200
     9.315   132.430     0.200
     9.628   137.270     0.200
     9.835   139.371     0.200
    10.221   145.980     0.200
    10.913   151.449     0.200
    11.510   161.520     0.200
    19.373   263.777     0.200
     0.798    15.148     0.200
     1.099    19.508     0.200
     1.021    18.070     0.200
     1.304    22.367     0.200
     1.397    23.398     0.200
     1.395    23.297     0.200
     1.420    24.039     0.200
     1.513    24.984     0.200
     1.546    25.680     0.200
     1.579    25.805     0.200
     1.563    25.641     0.200
     1.661    26.875     0.200
     1.676    27.070     0.200
     1.627    26.250     0.200
     1.627    26.484     0.200
     1.627    25.938     0.200
     1.627    26.734     0.200
     1.687    27.789     0.200
     1.763    28.664     0.200
     1.824    29.266     0.200
     1.957    30.297     0.200
     2.051    31.703     0.200
     2.227    35.008     0.200
     2.270    35.500     0.200
     2.272    35.625     0.200
     2.381    37.070     0.200
     2.491    37.789     0.200
     2.535    39.539     0.200
     2.572    39.070     0.200
     2.573    39.750     0.200
     2.572    39.391     0.200
     2.720    41.227     0.200
     2.692    41.945     0.200
     2.982    45.789     0.200
     3.035    45.664     0.200
     3.150    46.719     0.200
     3.215    47.141     0.200
     3.215    47.523     0.200
     3.269    47.938     0.200
     3.275    48.055     0.200
     3.311    49.969     0.200
     3.364    50.695     0.200
     3.348    50.969     0.200
     3.348    50.367     0.200
     3.394    49.969     0.200
     3.394    50.578     0.200
     3.362    50.664     0.200
     3.403    50.539     0.200
     3.403    50.750     0.200
     3.403    50.250     0.200
     3.478    51.641     0.200
     3.493    52.594     0.200
     3.493    52.438     0.200
     3.660    53.859     0.200
     3.683    54.391     0.200
     3.785    56.594     0.200
     3.829    57.328     0.200
     3.878    56.703     0.200
     3.878    56.867     0.200
     3.889    56.977     0.200
     3.889    57.242     0.200
     3.897    58.273     0.200
     3.944    58.914     0.200
     3.963    58.930     0.200
     4.005    59.023     0.200
     4.005    59.383     0.200
     3.993    59.125     0.200
     4.023    59.320     0.200
     4.116    60.484     0.200
     4.148    60.828     0.200
     4.153    61.414     0.200
     4.279    62.523     0.200
     4.279    63.023     0.200
     4.290    62.594     0.200
     4.290    62.750     0.200
     4.393    63.242     0.200
     4.429    66.453     0.200
     4.429    66.047     0.200
     4.455    64.453     0.200
     4.585    66.344     0.200
     4.616    67.695     0.200
     4.675    67.875     0.200
     4.675    68.242     0.200
     4.686    68.500     0.200
     4.644    68.195     0.200
     4.647    68.578     0.200
     4.694    68.273     0.200
     4.694    68.539     0.200
     4.687    68.914     0.200
     4.704    69.398     0.200
     4.752    68.938     0.200
     4.752    69.336     0.200
     4.733    69.305     0.200
     4.873    70.734     0.200
     4.873    70.594     0.200
     4.960    72.227     0.200
     4.985    72.328     0.200
     5.099    73.938     0.200
     5.099    74.188     0.200
     5.068    73.000     0.200
     5.132    75.148     0.200
     5.132    74.164     0.200
     5.140    74.000     0.200
     5.140    74.484     0.200
     5.106    73.438     0.200
     5.106    74.383     0.200
     5.158    75.086     0.200
     5.158    75.828     0.200
     5.339    77.984     0.200
     5.339    77.398     0.200
     5.277    76.922     0.200
     5.344    77.086     0.200
     5.369    78.328     0.200
     5.369    78.062     0.200
     5.403    77.289     0.200
     5.403    77.461     0.200
     5.473    78.836     0.200
     5.473    79.156     0.200
     5.463    78.789     0.200
     5.463    78.648     0.200
     5.578    79.992     0.200
     5.536    80.586     0.200
     5.536    80.406     0.200
     5.646    82.055     0.200
     5.649    80.180     0.200
     5.649    81.016     0.200
     5.696    82.453     0.200
     5.696    82.766     0.200
     5.700    81.328     0.200
     5.705    81.555     0.200
     5.775    81.156     0.200
     5.775    81.992     0.200
     5.886    84.195     0.200
     5.886    84.297     0.200
     5.854    83.305     0.200
     5.924    83.680     0.200
     6.006    86.570     0.200
     6.006    86.461     0.200
     6.048    86.266     0.200
     6.048    85.906     0.200
     6.133    88.023     0.200
     6.141    88.453     0.200
     6.141    88.648     0.200
     6.141    88.039     0.200
     6.099    86.539     0.200
     6.099    86.945     0.200
     6.099    86.641     0.200
     6.217    89.297     0.200
     6.250    90.250     0.200
     6.250    90.492     0.200
     6.401    91.891     0.200
     6.401    92.023     0.200
     6.371    90.648     0.200
     6.371    90.531     0.200
     6.378    90.758     0.200
     6.378    90.875     0.200
     6.431    91.758     0.200
     6.469    92.539     0.200
     6.565    93.898     0.200
     6.565    94.203     0.200
     6.544    93.367     0.200
     6.608    94.195     0.200
     6.608    93.977     0.200
     6.627    93.953     0.200
     6.686    94.227     0.200
     6.711    96.156     0.200
     6.711    95.945     0.200
     6.770    96.430     0.200
     6.770    97.195     0.200
     6.713    95.445     0.200
     6.773    96.273     0.200
     6.730    95.594     0.200
     6.844    98.219     0.200
     6.844    97.789     0.200
     6.800    96.289     0.200
     6.800    96.445     0.200
     6.839    97.016     0.200
     6.839    97.250     0.200
     6.837    96.695     0.200
     6.892    97.984     0.200
     6.901    97.969     0.200
     6.943    99.305     0.200
     6.943    99.148     0.200
     7.051   100.117     0.200
     7.044    99.969     0.200
     7.046   100.070     0.200
     7.046   100.523     0.200
     7.025    99.617     0.200
     7.194   102.344     0.200
     7.194   103.281     0.200
     7.125   101.000     0.200
     7.201   103.164     0.200
     7.203   101.656     0.200
     7.203   101.945     0.200
     7.203   102.719     0.200
     7.171   101.656     0.200
     7.171   102.133     0.200
     7.205   102.328     0.200
     7.279   103.391     0.200
     7.331   105.039     0.200
     7.331   104.039     0.200
     7.316   103.758     0.200
     7.313   103.977     0.200
     7.384   104.758     0.200
     7.384   104.945     0.200
     7.332   103.789     0.200
     7.382   104.594     0.200
     7.449   105.484     0.200
     7.412   105.188     0.200
     7.448   105.586     0.200
     7.451   105.438     0.200
     7.507   106.719     0.200
     7.559   106.727     0.200
     7.559   106.852     0.200
     7.550   106.977     0.200
     7.616   107.516     0.200
     7.616   108.234     0.200
     7.601   107.609     0.200
     7.618   108.219     0.200
     7.618   108.383     0.200
     7.671   108.828     0.200
     7.668   108.398     0.200
     7.730   109.453     0.200
     7.799   110.469     0.200
     7.799   110.609     0.200
     7.806   110.664     0.200
     7.854   110.375     0.200
     7.917   112.195     0.200
     7.995   113.523     0.200
     7.998   113.727     0.200
     8.086   114.406     0.200
     8.096   114.188     0.200
     8.154   115.055     0.200
     8.197   116.109     0.200
     8.200   115.805     0.200
     8.255   117.477     0.200
     8.326   117.203     0.200
     8.311   115.812     0.200
     8.353   117.211     0.200
     8.380   116.773     0.200
     8.475   120.289     0.200
     8.395   117.914     0.200
     8.395   118.484     0.200
     8.507   120.750     0.200
     8.485   118.391     0.200
     8.485   118.766     0.200
     8.506   119.844     0.200
     8.590   121.164     0.200
     8.590   121.477     0.200
     8.527   121.391     0.200
     8.566   120.195     0.200
     8.566   120.328     0.200
     8.693   122.906     0.200
     8.693   123.125     0.200
     8.654   122.617     0.200
     8.658   121.484     0.200
     8.756   123.570     0.200
     8.709   121.891     0.200
     8.709   122.844     0.200
     8.709   122.352     0.200
     8.781   122.734     0.200
     8.781   122.430     0.200
     8.787   122.664     0.200
     8.787   123.648     0.200
     8.787   123.266     0.200
     8.787   122.484     0.200
     8.793   122.664     0.200
     8.859   126.344     0.200
     8.893   123.117     0.200
     8.921   125.898     0.200
     8.933   127.141     0.200
     8.995   126.438     0.200
     8.995   127.219     0.200
     9.026   128.992     0.200
     9.112   129.328     0.200
     9.085   126.938     0.200
     9.085   127.266     0.200
     9.086   128.148     0.200
     9.086   128.711     0.200
     9.083   129.406     0.200
     9.113   127.539     0.200
     9.103   128.891     0.200
     9.206   129.930     0.200
     9.261   131.164     0.200
     9.261   130.648     0.200
     9.259   129.633     0.200
     9.290   131.188     0.200
     9.260   130.742     0.200
     9.399   132.289     0.200
     9.510   133.289     0.200
     9.510   133.789     0.200
     9.529   133.953     0.200
     9.544   135.062     0.200
     9.549   136.250     0.200
     9.626   135.891     0.200
     9.657   134.086     0.200
     9.833   137.203     0.200
     9.910   139.758     0.200
    10.027   141.047     0.200
    10.027   140.391     0.200
    10.045   141.773     0.200
    10.085   141.953     0.200
    10.005   140.789     0.200
    10.073   141.867     0.200
    10.189   141.727     0.200
    10.231   143.250     0.200
    10.262   144.516     0.200
    10.260   143.328     0.200
    10.240   143.047     0.200
    10.197   141.617     0.200
    10.197   142.062     0.200
    10.293   144.695     0.200
    10.455   146.812     0.200
    10.430   146.023     0.200
    10.517   145.367     0.200
    10.520   147.914     0.200
    10.562   148.141     0.200
    10.566   147.469     0.200
    10.672   148.000     0.200
    10.720   151.320     0.200
    10.716   151.383     0.200
    10.767   151.891     0.200
    10.790   151.844     0.200
    10.722   151.148     0.200
    10.722   149.188     0.200
    10.753   149.461     0.200
    10.831   152.141     0.200
    10.886   152.344     0.200
    10.940   153.820     0.200
    11.127   156.328     0.200
    11.098   156.695     0.200
    11.123   155.977     0.200
    11.114   155.734     0.200
    11.220   154.602     0.200
    11.206   158.234     0.200
    11.170   158.445     0.200
    11.268   158.125     0.200
    11.382   159.258     0.200
    11.440   159.656     0.200
    11.425   158.266     0.200
    11.483   160.719     0.200
    11.554   161.570     0.200
    11.631   160.109     0.200
    11.672   160.805     0.200
    11.677   161.398     0.200
    11.793   164.883     0.200
    11.743   164.445     0.200
    11.951   167.594     0.200
    11.954   169.547     0.200
    11.954   167.211     0.200
    11.991   165.281     0.200
    12.106   168.133     0.200
    12.121   166.594     0.200
    12.121   166.469     0.200
    12.141   168.992     0.200
    12.064   167.414     0.200
    12.082   167.383     0.200
    12.186   169.703     0.200
    12.258   172.297     0.200
    12.267   171.164     0.200
    12.293   171.672     0.200
    12.335   171.953     0.200
    12.269   170.609     0.200
    12.375   172.641     0.200
    12.271   173.648     0.200
    12.271   172.438     0.200
    12.407   174.328     0.200
    12.407   172.836     0.200
    12.490   173.688     0.200
    12.476   173.094     0.200
    12.674   176.062     0.200
    12.843   177.672     0.200
    12.864   179.203     0.200
    12.864   178.969     0.200
    12.871   179.875     0.200
    12.938   181.328     0.200
    12.944   180.336     0.200
    13.112   181.188     0.200
    13.235   181.516     0.200
    13.138   180.766     0.200
    13.263   183.711     0.200
    13.258   185.250     0.200
    13.323   185.008     0.200
    13.416   187.445     0.200
    13.456   189.820     0.200
    13.511   186.492     0.200
    13.684   188.562     0.200
    13.861   192.188     0.200
    13.932   194.477     0.200
    13.940   194.578     0.200
    13.957   194.305     0.200
    13.983   194.859     0.200
    13.983   194.641     0.200
    14.459   200.273     0.200
    14.430   200.812     0.200
    14.567   200.578     0.200
    15.062   208.102     0.200
    15.062   207.844     0.200
    15.062   209.094     0.200
     1.332    24.594     0.200
     1.485    27.264     0.200
     1.700    29.895     0.200
     1.720    29.545     0.200
     1.783    31.555     0.200
     1.811    31.805     0.200
     1.811    31.225     0.200
     1.811    31.660     0.200
     1.946    33.264     0.200
     1.978    34.084     0.200
     1.998    33.975     0.200
     2.004    34.504     0.200
     2.014    34.943     0.200
     2.014    34.955     0.200
     2.054    34.965     0.200
     2.055    35.184     0.200
     2.120    35.965     0.200
     2.148    37.447     0.200
     2.244    37.475     0.200
     2.244    37.682     0.200
     2.257    38.475     0.200
     2.420    40.494     0.200
     2.420    40.199     0.200
     2.569    42.625     0.200
     2.572    42.264     0.200
     2.572    41.984     0.200
     2.636    43.125     0.200
     2.636    43.125     0.200
     2.658    43.574     0.200
     2.695    44.004     0.200
     2.709    44.385     0.200
     2.767    45.225     0.200
     2.854    46.273     0.200
     2.854    46.072     0.200
     2.856    47.004     0.200
     2.902    47.484     0.200
     2.962    47.205     0.200
     3.054    47.863     0.200
     3.054    47.447     0.200
     3.106    49.074     0.200
     3.106    48.877     0.200
     3.143    49.443     0.200
     3.186    49.174     0.200
     3.165    50.455     0.200
     3.265    52.193     0.200
     3.346    52.904     0.200
     3.335    52.834     0.200
     3.358    52.154     0.200
     3.370    53.523     0.200
     3.370    53.320     0.200
     3.412    54.035     0.200
     3.488    54.863     0.200
     3.488    54.531     0.200
     3.607    56.414     0.200
     3.612    56.604     0.200
     3.662    57.174     0.200
     3.696    57.295     0.200
     3.706    57.773     0.200
     3.707    58.273     0.200
     3.740    58.475     0.200
     3.740    58.332     0.200
     3.744    57.455     0.200
     3.809    58.943     0.200
     3.892    60.334     0.200
     3.892    59.953     0.200
     3.911    60.174     0.200
     4.010    61.404     0.200
     4.011    61.955     0.200
     4.058    61.824     0.200
     4.092    62.975     0.200
     4.190    63.305     0.200
     4.205    65.145     0.200
     4.277    66.285     0.200
     4.277    66.090     0.200
     4.309    65.975     0.200
     4.295    66.604     0.200
     4.315    66.924     0.200
     4.315    66.453     0.200
     4.329    65.324     0.200
     4.370    67.154     0.200
     4.406    67.385     0.200
     4.417    67.145     0.200
     4.436    67.564     0.200
     4.527    69.035     0.200
     4.528    68.834     0.200
     4.528    69.062     0.200
     4.604    69.254     0.200
     4.607    69.832     0.200
     4.614    71.035     0.200
     4.614    70.348     0.200
     4.640    70.035     0.200
     4.670    70.715     0.200
     4.727    70.943     0.200
     4.758    72.205     0.200
     4.782    72.654     0.200
     4.813    73.084     0.200
     4.832    73.625     0.200
     4.832    73.492     0.200
     4.831    72.875     0.200
     4.831    73.438     0.200
     4.823    73.779     0.200
     4.860    74.545     0.200
     4.860    74.152     0.200
     4.903    74.154     0.200
     4.929    73.863     0.200
     4.929    74.027     0.200
     4.925    74.824     0.200
     4.929    73.895     0.200
     4.929    75.125     0.200
     4.929    74.605     0.200
     4.955    74.947     0.200
     4.945    75.074     0.200
     4.954    74.664     0.200
     4.954    74.799     0.200
     4.975    75.125     0.200
     5.006    75.354     0.200
     5.071    76.215     0.200
     5.170    78.225     0.200
     5.170    77.830     0.200
     5.178    78.613     0.200
     5.178    78.049     0.200
     5.210    78.395     0.200
     5.235    79.375     0.200
     5.235    79.512     0.200
     5.304    79.854     0.200
     5.372    80.494     0.200
     5.410    81.414     0.200
     5.399    81.135     0.200
     5.399    81.301     0.200
     5.481    81.936     0.200
     5.485    82.004     0.200
     5.494    82.205     0.200
     5.494    81.953     0.200
     5.514    82.555     0.200
     5.554    82.475     0.200
     5.554    83.346     0.200
     5.589    83.324     0.200
     5.765    85.795     0.200
     5.752    85.424     0.200
     5.765    85.967     0.200
     5.799    86.584     0.200
     5.799    86.326     0.200
     5.915    88.125     0.200
     5.915    88.021     0.200
     5.968    88.094     0.200
     5.968    89.043     0.200
     6.037    90.244     0.200
     6.052    89.273     0.200
     6.045    89.684     0.200
     6.069    89.645     0.200
     6.062    88.625     0.200
     6.140    90.785     0.200
     6.140    90.824     0.200
     6.140    91.145     0.200
     6.248    92.174     0.200
     6.366    94.604     0.200
     6.379    93.725     0.200
     6.379    94.072     0.200
     6.383    94.975     0.200
     6.431    95.475     0.200
     6.431    95.051     0.200
     6.462    94.844     0.200
     6.462    95.324     0.200
     6.460    96.084     0.200
     6.490    95.914     0.200
     6.490    95.094     0.200
     6.490    95.523     0.200
     6.504    95.744     0.200
     6.553    97.004     0.200
     6.553    96.539     0.200
     6.600    96.943     0.200
     6.607    97.334     0.200
     6.607    96.873     0.200
     6.628    98.424     0.200
     6.628    98.266     0.200
     6.746    99.984     0.200
     6.746    99.627     0.200
     6.915   101.664     0.200
     6.915   101.549     0.200
     6.979   101.754     0.200
     6.979   102.010     0.200
     7.099   103.754     0.200
     7.099   104.004     0.200
     7.295   106.684     0.200
     7.333   107.574     0.200
     7.333   107.443     0.200
     7.355   108.074     0.200
     7.355   107.725     0.200
     7.376   108.285     0.200
     7.396   108.934     0.200
     7.396   108.670     0.200
     7.401   107.154     0.200
     7.401   108.797     0.200
     7.482   109.045     0.200
     7.564   111.193     0.200
     7.564   110.910     0.200
     7.683   111.814     0.200
     7.683   112.236     0.200
     7.778   113.145     0.200
     7.778   113.400     0.200
     7.848   114.514     0.200
     7.916   115.965     0.200
     7.992   116.574     0.200
     8.027   117.295     0.200
     8.093   116.914     0.200
     8.132   117.854     0.200
     8.204   119.785     0.200
     8.204   119.523     0.200
     8.419   122.225     0.200
     8.489   123.414     0.200
     8.645   125.863     0.200
     9.023   130.074     0.200
     9.047   130.363     0.200
     9.319   134.035     0.200
     9.849   141.045     0.200
    10.056   143.465     0.200
    11.039   159.049     0.200
    11.139   157.494     0.200
    11.258   161.924     0.200
    11.314   162.055     0.200
    11.806   168.094     0.200
    12.444   177.699     0.200
    15.836   221.475     0.200
    16.992   236.785     0.200
    18.206   253.023     0.200
     0.062    16.951     0.200
     0.027    17.012     0.200
     0.143    17.432     0.200
     0.196    17.242     0.200
     0.205    17.271     0.200
     0.242    17.211     0.200
     0.243    17.211     0.200
     0.286    17.281     0.200
     0.504    18.531     0.200
     0.556    19.002     0.200
     0.700    19.992     0.200
     0.796    20.621     0.200
     1.124    23.801     0.200
     1.191    24.461     0.200
     1.199    23.980     0.200
     1.199    24.182     0.200
     1.304    25.332     0.200
     1.518    27.162     0.200
     1.580    27.975     0.200
     1.571    28.592     0.200
     1.656    29.480     0.200
     1.658    29.641     0.200
     1.662    29.301     0.200
     1.793    30.891     0.200
     1.852    32.211     0.200
     1.960    33.111     0.200
     1.940    33.641     0.200
     2.081    34.352     0.200
     2.145    35.471     0.200
     2.209    36.461     0.200
     2.380    38.912     0.200
     2.497    39.881     0.200
     2.497    39.781     0.200
     2.488    39.871     0.200
     2.557    40.811     0.200
     2.498    39.342     0.200
     2.653    42.012     0.200
     2.665    42.441     0.200
     2.781    43.900     0.200
     2.832    43.662     0.200
     2.846    44.311     0.200
     2.896    44.641     0.200
     2.906    44.871     0.200
     2.906    45.281     0.200
     2.947    45.881     0.200
     2.945    45.881     0.200
     3.101    47.842     0.200
     3.213    49.332     0.200
     3.305    50.791     0.200
     3.346    51.291     0.200
     3.364    51.711     0.200
     3.535    53.441     0.200
     3.628    54.332     0.200
     3.663    54.881     0.200
     3.656    54.861     0.200
     3.715    55.791     0.200
     3.751    56.281     0.200
     3.751    56.707     0.200
     3.775    57.391     0.200
     3.870    58.881     0.200
     3.965    59.672     0.200
     4.004    60.162     0.200
     4.041    60.412     0.200
     3.981    58.461     0.200
     4.061    60.631     0.200
     4.095    60.400     0.200
     4.079    60.832     0.200
     4.095    61.631     0.200
     4.195    62.150     0.200
     4.193    61.980     0.200
     4.266    63.650     0.200
     4.520    65.912     0.200
     4.444    65.150     0.200
     4.654    67.682     0.200
     4.625    68.262     0.200
     4.619    67.980     0.200
     4.745    70.102     0.200
     4.753    70.131     0.200
     4.753    70.480     0.200
     4.775    68.631     0.200
     4.851    69.730     0.200
     4.827    70.941     0.200
     4.885    71.082     0.200
     4.890    71.281     0.200
     4.938    71.592     0.200
     5.025    72.752     0.200
     5.025    71.408     0.200
     5.079    72.412     0.200
     5.083    73.951     0.200
     5.102    74.771     0.200
     5.216    76.061     0.200
     5.235    74.602     0.200
     5.318    77.881     0.200
     5.460    78.480     0.200
     5.487    78.781     0.200
     5.487    78.980     0.200
     5.487    79.941     0.200
     5.507    79.971     0.200
     5.712    82.111     0.200
     5.691    82.291     0.200
     5.754    81.521     0.200
     5.818    82.432     0.200
     5.823    83.051     0.200
     5.813    84.252     0.200
     5.756    82.602     0.200
     5.936    85.102     0.200
     5.946    85.971     0.200
     5.971    85.820     0.200
     5.893    84.701     0.200
     6.060    86.391     0.200
     6.071    87.801     0.200
     6.134    87.281     0.200
     6.164    87.820     0.200
     6.164    87.312     0.200
     6.290    90.320     0.200
     6.433    92.012     0.200
     6.543    93.781     0.200
     6.560    93.971     0.200
     6.624    94.742     0.200
     6.633    94.570     0.200
     6.703    95.381     0.200
     6.727    96.320     0.200
     6.770    96.842     0.200
     6.773    96.871     0.200
     6.780    96.711     0.200
     6.790    96.842     0.200
     6.825    97.432     0.200
     6.852    97.682     0.200
     6.915    98.551     0.200
     6.928    98.832     0.200
     7.030    99.861     0.200
     7.108   101.371     0.200
     7.112   101.762     0.200
     7.184   102.012     0.200
     7.202   102.730     0.200
     7.209   102.932     0.200
     7.215   102.941     0.200
     7.419   105.521     0.200
     7.549   107.131     0.200
     7.585   108.631     0.200
     7.651   109.051     0.200
     7.674   109.275     0.200
     7.677   109.271     0.200
     7.752   108.031     0.200
     7.778   110.762     0.200
     7.799   110.752     0.200
     7.802   109.842     0.200
     7.919   112.262     0.200
     7.958   113.900     0.200
     8.034   113.730     0.200
     8.034   113.734     0.200
     8.281   117.881     0.200
     8.329   117.592     0.200
     8.428   118.891     0.200
     8.428   119.082     0.200
     8.882   125.271     0.200
     8.892   125.662     0.200
     9.268   130.461     0.200
     9.327   131.291     0.200
     9.423   132.832     0.200
     9.484   134.820     0.200
     9.681   136.221     0.200
     9.803   137.662     0.200
    10.164   142.172     0.200
    10.295   144.730     0.200
    10.497   147.412     0.200
    10.497   148.381     0.200
    10.747   150.492     0.200
    11.094   156.381     0.200
    11.135   156.441     0.200
    11.753   163.852     0.200
    12.103   169.531     0.200
    13.335   185.881     0.200
    14.039   192.502     0.200
    14.039   193.480     0.200
     0.079    18.801     0.200
     0.351    19.602     0.200
     0.419    19.980     0.200
     0.475    20.512     0.200
     0.559    20.652     0.200
     0.615    20.621     0.200
     0.616    20.617     0.200
     0.684    20.883     0.200
     0.782    22.012     0.200
     0.819    22.164     0.200
     0.850    22.441     0.200
     1.070    24.832     0.200
     1.086    25.070     0.200
     1.111    25.230     0.200
     1.145    25.164     0.200
     1.217    25.980     0.200
     1.341    27.594     0.200
     1.412    27.844     0.200
     1.414    27.844     0.200
     1.480    28.391     0.200
     1.537    29.172     0.200
     1.540    28.543     0.200
     1.621    29.293     0.200
     1.617    30.223     0.200
     1.749    31.723     0.200
     1.749    31.059     0.200
     1.778    30.980     0.200
     1.782    31.863     0.200
     1.782    31.711     0.200
     1.863    33.402     0.200
     2.011    35.023     0.200
     2.014    34.953     0.200
     2.077    35.730     0.200
     2.108    35.883     0.200
     2.108    36.027     0.200
     2.128    36.652     0.200
     2.128    36.500     0.200
     2.147    36.383     0.200
     2.153    36.633     0.200
     2.215    36.371     0.200
     2.244    37.664     0.200
     2.310    38.371     0.200
     2.403    39.023     0.200
     2.404    39.453     0.200
     2.480    39.941     0.200
     2.498    40.062     0.200
     2.573    41.453     0.200
     2.810    44.621     0.200
     2.884    45.539     0.200
     2.885    45.543     0.200
     2.914    44.684     0.200
     2.914    44.508     0.200
     2.919    46.414     0.200
     2.941    46.641     0.200
     2.941    46.473     0.200
     2.942    47.023     0.200
     2.942    46.441     0.200
     2.955    47.004     0.200
     3.010    47.551     0.200
     3.028    47.551     0.200
     3.059    48.152     0.200
     3.219    50.312     0.200
     3.219    50.070     0.200
     3.234    50.531     0.200
     3.252    50.262     0.200
     3.252    50.516     0.200
     3.242    49.941     0.200
     3.242    49.684     0.200
     3.324    51.691     0.200
     3.324    51.520     0.200
     3.463    53.211     0.200
     3.481    53.852     0.200
     3.481    53.523     0.200
     3.513    53.883     0.200
     3.513    53.523     0.200
     3.597    54.531     0.200
     3.597    54.312     0.200
     3.592    54.363     0.200
     3.605    54.754     0.200
     3.723    56.863     0.200
     3.723    56.699     0.200
     3.718    56.641     0.200
     3.718    56.309     0.200
     3.782    57.070     0.200
     3.824    57.883     0.200
     3.928    58.754     0.200
     3.928    58.484     0.200
     4.034    61.172     0.200
     4.139    61.312     0.200
     4.147    60.402     0.200
     4.147    61.793     0.200
     4.147    60.547     0.200
     4.255    63.543     0.200
     4.255    63.371     0.200
     4.286    62.871     0.200
     4.286    62.551     0.200
     4.314    64.613     0.200
     4.341    63.254     0.200
     4.400    64.852     0.200
     4.400    64.551     0.200
     4.431    67.469     0.200
     4.567    67.723     0.200
     4.567    67.613     0.200
     4.572    67.723     0.200
     4.577    66.344     0.200
     4.683    69.102     0.200
     4.685    69.082     0.200
     4.685    68.945     0.200
     4.793    69.211     0.200
     4.832    71.684     0.200
     4.832    71.484     0.200
     4.942    73.453     0.200
     4.942    72.570     0.200
     4.970    71.844     0.200
     4.970    71.594     0.200
     5.085    73.914     0.200
     5.085    74.492     0.200
     5.085    73.469     0.200
     5.140    74.004     0.200
     5.224    74.863     0.200
     5.258    76.402     0.200
     5.275    76.883     0.200
     5.292    76.973     0.200
     5.292    76.551     0.200
     5.301    75.703     0.200
     5.305    77.602     0.200
     5.305    77.391     0.200
     5.311    77.723     0.200
     5.311    77.301     0.200
     5.366    77.633     0.200
     5.366    77.359     0.200
     5.501    80.102     0.200
     5.501    79.734     0.200
     5.574    80.523     0.200
     5.574    80.215     0.200
     5.578    80.711     0.200
     5.595    80.012     0.200
     5.749    82.586     0.200
     5.752    82.453     0.200
     5.752    82.125     0.200
     5.771    82.332     0.200
     5.771    81.879     0.200
     5.845    84.031     0.200
     5.845    83.621     0.200
     5.986    86.672     0.200
     5.986    85.938     0.200
     6.030    87.094     0.200
     6.139    87.480     0.200
     6.197    89.363     0.200
     6.260    89.980     0.200
     6.266    90.254     0.200
     6.271    90.211     0.200
     6.306    90.820     0.200
     6.348    91.305     0.200
     6.362    91.301     0.200
     6.380    92.094     0.200
     6.401    91.926     0.200
     6.419    92.852     0.200
     6.455    92.902     0.200
     6.556    92.242     0.200
     6.556    91.953     0.200
     6.608    94.891     0.200
     6.608    94.715     0.200
     6.643    95.383     0.200
     6.643    95.008     0.200
     6.648    95.832     0.200
     6.648    95.508     0.200
     6.652    94.871     0.200
     6.652    94.746     0.200
     6.663    94.133     0.200
     6.663    93.816     0.200
     6.669    93.883     0.200
     6.732    96.672     0.200
     6.794    96.871     0.200
     6.807    97.512     0.200
     6.804    97.113     0.200
     6.884    96.434     0.200
     6.906    96.602     0.200
     6.996    98.281     0.200
     6.996    97.953     0.200
     7.011   100.461     0.200
     7.050   100.762     0.200
     7.050   100.238     0.200
     7.053    99.191     0.200
     7.064    99.102     0.200
     7.064    99.293     0.200
     7.174   102.730     0.200
     7.174   102.539     0.200
     7.212   101.043     0.200
     7.212   100.914     0.200
     7.212   100.742     0.200
     7.288   104.934     0.200
     7.323   104.164     0.200
     7.366   103.523     0.200
     7.366   103.391     0.200
     7.395   104.953     0.200
     7.395   104.793     0.200
     7.409   105.223     0.200
     7.500   105.301     0.200
     7.503   105.164     0.200
     7.793   110.594     0.200
     7.812   110.812     0.200
     8.158   114.113     0.200
     8.988   127.012     0.200
     9.231   129.914     0.200
    10.652   150.152     0.200
    13.513   184.719     0.200
     0.630    14.820     0.200
     0.676    15.156     0.200
     0.685    15.156     0.200
     0.701    15.578     0.200
     0.755    15.953     0.200
     0.827    16.703     0.200
     0.836    16.875     0.200
     0.827    16.453     0.200
     0.844    17.148     0.200
     0.956    18.234     0.200
     1.048    19.086     0.200
     1.110    20.359     0.200
     1.114    19.930     0.200
     1.319    22.484     0.200
     1.396    23.523     0.200
     1.388    23.797     0.200
     1.595    26.555     0.200
     1.715    27.609     0.200
     1.748    27.578     0.200
     1.775    29.398     0.200
     1.794    29.023     0.200
     1.803    29.773     0.200
     1.804    29.758     0.200
     1.854    29.656     0.200
     2.027    32.930     0.200
     2.047    32.938     0.200
     2.054    32.820     0.200
     2.124    33.336     0.200
     2.191    33.977     0.200
     2.317    36.125     0.200
     2.336    37.008     0.200
     2.460    37.898     0.200
     2.582    40.023     0.200
     2.576    39.383     0.200
     2.576    38.945     0.200
     2.692    41.359     0.200
     2.692    41.227     0.200
     2.713    41.984     0.200
     2.783    42.477     0.200
     2.796    43.195     0.200
     2.848    43.523     0.200
     2.859    44.328     0.200
     2.967    44.844     0.200
     3.130    47.797     0.200
     3.141    46.867     0.200
     3.170    47.664     0.200
     3.175    47.656     0.200
     3.175    47.477     0.200
     3.174    48.625     0.200
     3.182    47.555     0.200
     3.232    49.273     0.200
     3.296    50.094     0.200
     3.296    49.945     0.200
     3.348    50.555     0.200
     3.490    52.180     0.200
     3.572    53.227     0.200
     3.656    54.398     0.200
     3.656    53.961     0.200
     3.689    53.711     0.200
     3.684    55.086     0.200
     3.684    54.805     0.200
     3.695    54.438     0.200
     3.695    53.828     0.200
     3.697    52.656     0.200
     3.826    57.805     0.200
     3.906    57.008     0.200
     3.911    56.375     0.200
     3.911    56.562     0.200
     3.959    58.664     0.200
     3.960    58.664     0.200
     3.975    58.695     0.200
     4.004    59.406     0.200
     4.004    59.156     0.200
     4.031    60.250     0.200
     4.044    59.719     0.200
     4.080    60.727     0.200
     4.168    61.719     0.200
     4.240    62.133     0.200
     4.251    62.453     0.200
     4.265    62.656     0.200
     4.357    64.148     0.200
     4.389    64.523     0.200
     4.398    64.109     0.200
     4.468    66.258     0.200
     4.468    65.977     0.200
     4.501    65.656     0.200
     4.501    65.766     0.200
     4.521    66.500     0.200
     4.521    66.391     0.200
     4.655    68.445     0.200
     4.655    68.023     0.200
     4.725    68.336     0.200
     4.725    68.555     0.200
     4.713    68.102     0.200
     4.756    69.305     0.200
     4.756    69.430     0.200
     4.765    69.586     0.200
     4.807    69.695     0.200
     4.807    69.828     0.200
     4.874    70.586     0.200
     4.926    71.664     0.200
     4.990    72.594     0.200
     5.076    73.195     0.200
     5.134    74.625     0.200
     5.134    74.500     0.200
     5.158    74.008     0.200
     5.158    73.836     0.200
     5.253    75.883     0.200
     5.300    75.977     0.200
     5.417    78.375     0.200
     5.422    78.523     0.200
     5.422    78.648     0.200
     5.425    78.758     0.200
     5.425    78.492     0.200
     5.451    78.945     0.200
     5.488    78.773     0.200
     5.488    78.633     0.200
     5.569    80.258     0.200
     5.566    81.344     0.200
     5.566    80.906     0.200
     5.675    81.516     0.200
     5.701    81.711     0.200
     5.748    83.227     0.200
     5.748    82.617     0.200
     5.838    83.477     0.200
     5.838    83.258     0.200
     5.856    84.586     0.200
     5.856    84.102     0.200
     5.985    85.164     0.200
     5.992    86.273     0.200
     6.067    87.203     0.200
     6.067    86.484     0.200
     6.083    87.664     0.200
     6.083    87.516     0.200
     6.111    87.109     0.200
     6.132    87.680     0.200
     6.132    87.398     0.200
     6.159    87.320     0.200
     6.167    88.125     0.200
     6.232    88.406     0.200
     6.258    88.797     0.200
     6.282    89.547     0.200
     6.363    91.070     0.200
     6.374    90.805     0.200
     6.383    90.906     0.200
     6.389    91.117     0.200
     6.389    90.648     0.200
     6.395    90.609     0.200
     6.418    91.703     0.200
     6.424    91.430     0.200
     6.424    91.195     0.200
     6.477    92.664     0.200
     6.477    92.500     0.200
     6.561    93.266     0.200
     6.673    95.938     0.200
     6.673    95.125     0.200
     6.700    95.727     0.200
     6.702    95.500     0.200
     6.719    95.289     0.200
     6.751    95.633     0.200
     6.751    95.383     0.200
     6.881    97.344     0.200
     6.881    97.211     0.200
     6.899    98.438     0.200
     6.922    98.984     0.200
     6.959    98.359     0.200
     6.983    99.680     0.200
     6.977    99.406     0.200
     7.011    99.555     0.200
     7.037   100.227     0.200
     7.132   101.484     0.200
     7.254   102.719     0.200
     7.267   102.859     0.200
     7.267   103.203     0.200
     7.267   103.336     0.200
     7.284   102.539     0.200
     7.325   104.078     0.200
     7.325   103.883     0.200
     7.348   104.547     0.200
     7.371   104.609     0.200
     7.417   104.305     0.200
     7.417   104.992     0.200
     7.426   105.828     0.200
     7.517   106.234     0.200
     7.654   106.586     0.200
     7.654   106.703     0.200
     7.738   109.266     0.200
     7.740   107.406     0.200
     7.766   111.016     0.200
     7.791   110.906     0.200
     7.788   110.758     0.200
     7.802   108.977     0.200
     7.809   110.023     0.200
     7.833   111.203     0.200
     7.854   111.508     0.200
     7.946   111.258     0.200
     7.961   112.578     0.200
     8.021   114.320     0.200
     8.037   113.828     0.200
     8.113   113.086     0.200
     8.143   113.500     0.200
     8.209   116.344     0.200
     8.216   116.469     0.200
     8.266   114.828     0.200
     8.266   114.484     0.200
     8.266   114.625     0.200
     8.495   119.859     0.200
     8.545   121.195     0.200
     8.608   121.719     0.200
     8.603   121.469     0.200
     8.621   121.734     0.200
     8.680   122.859     0.200
     8.941   126.320     0.200
     9.209   128.648     0.200
    10.226   145.930     0.200
    10.988   152.227     0.200
    11.031   151.867     0.200
    11.192   154.367     0.200
    11.432   160.047     0.200
    11.475   161.539     0.200
    12.270   171.469     0.200
    12.496   172.344     0.200
    13.094   181.484     0.200
    13.442   185.453     0.200
    14.492   199.500     0.200
     1.517    25.686     0.200
     1.517    25.988     0.200
     2.100    33.586     0.200
     2.163    35.404     0.200
     2.172    34.654     0.200
     2.182    34.926     0.200
     2.208    35.164     0.200
     2.313    36.516     0.200
     2.313    36.955     0.200
     2.379    37.625     0.200
     2.380    37.998     0.200
     2.345    37.605     0.200
     2.346    37.525     0.200
     2.482    38.945     0.200
     2.493    39.564     0.200
     2.627    40.375     0.200
     2.627    40.742     0.200
     2.612    41.855     0.200
     2.612    41.979     0.200
     2.822    41.475     0.200
     2.955    44.846     0.200
     2.955    45.059     0.200
     3.245    48.125     0.200
     3.233    49.365     0.200
     3.317    50.164     0.200
     3.317    50.279     0.200
     3.334    51.904     0.200
     3.334    51.580     0.200
     3.457    51.527     0.200
     3.456    50.824     0.200
     3.399    51.775     0.200
     3.461    53.225     0.200
     3.461    53.502     0.200
     3.682    54.846     0.200
     3.671    55.555     0.200
     3.671    55.426     0.200
     3.667    55.805     0.200
     3.686    55.355     0.200
     3.847    54.711     0.200
     3.674    55.244     0.200
     3.674    55.424     0.200
     3.704    56.775     0.200
     3.851    54.555     0.200
     3.784    58.096     0.200
     3.784    57.986     0.200
     3.912    59.045     0.200
     3.987    59.574     0.200
     4.137    59.676     0.200
     4.137    59.195     0.200
     4.136    60.975     0.200
     4.114    62.125     0.200
     4.158    62.516     0.200
     4.181    63.055     0.200
     4.252    63.975     0.200
     4.285    64.586     0.200
     4.287    64.006     0.200
     4.291    64.455     0.200
     4.311    63.064     0.200
     4.311    63.625     0.200
     4.493    65.744     0.200
     4.493    66.086     0.200
     4.502    66.244     0.200
     4.537    67.994     0.200
     4.537    67.893     0.200
     4.563    67.664     0.200
     4.563    67.986     0.200
     4.580    67.395     0.200
     4.599    69.324     0.200
     4.599    69.777     0.200
     4.668    69.545     0.200
     4.896    69.705     0.200
     4.929    70.086     0.200
     4.929    70.285     0.200
     4.842    69.965     0.200
     4.842    70.250     0.200
     4.859    70.641     0.200
     4.863    70.096     0.200
     4.923    72.775     0.200
     4.922    73.434     0.200
     4.923    73.525     0.200
     4.949    74.295     0.200
     4.973    74.285     0.200
     4.992    74.885     0.200
     5.040    74.096     0.200
     5.040    74.250     0.200
     5.026    74.914     0.200
     5.065    75.455     0.200
     5.150    75.176     0.200
     5.097    75.275     0.200
     5.132    74.744     0.200
     5.132    75.133     0.200
     5.244    76.768     0.200
     5.245    77.596     0.200
     5.334    78.645     0.200
     5.325    77.904     0.200
     5.442    78.445     0.200
     5.511    81.164     0.200
     5.542    81.068     0.200
     5.573    82.834     0.200
     5.700    82.910     0.200
     5.690    83.455     0.200
     5.690    83.107     0.200
     5.695    82.266     0.200
     5.712    82.775     0.200
     5.712    82.154     0.200
     5.712    82.471     0.200
     5.746    83.994     0.200
     5.746    84.150     0.200
     5.896    83.975     0.200
     5.896    83.586     0.200
     5.896    83.428     0.200
     5.826    84.445     0.200
     5.816    84.074     0.200
     5.816    83.795     0.200
     5.922    86.600     0.200
     5.917    85.785     0.200
     5.949    85.926     0.200
     5.949    86.188     0.200
     6.101    86.096     0.200
     6.103    86.355     0.200
     6.073    87.615     0.200
     6.073    88.123     0.200
     6.113    87.756     0.200
     6.152    90.186     0.200
     6.176    89.936     0.200
     6.176    90.439     0.200
     6.199    89.855     0.200
     6.254    90.404     0.200
     6.215    89.385     0.200
     6.222    90.025     0.200
     6.321    91.525     0.200
     6.321    91.318     0.200
     6.298    90.975     0.200
     6.309    90.936     0.200
     6.352    92.215     0.200
     6.352    91.953     0.200
     6.331    91.285     0.200
     6.331    91.863     0.200
     6.449    93.037     0.200
     6.514    93.484     0.200
     6.534    95.361     0.200
     6.664    95.979     0.200
     6.750    95.225     0.200
     6.604    94.914     0.200
     6.616    96.914     0.200
     6.721    96.205     0.200
     6.759    98.574     0.200
     6.759    97.865     0.200
     6.759    98.021     0.200
     6.756    97.266     0.200
     6.811    97.605     0.200
     6.811    97.752     0.200
     6.883    99.891     0.200
     6.862    99.295     0.200
     6.862    99.408     0.200
     6.890    98.904     0.200
     6.890    99.266     0.200
     6.912    99.525     0.200
     6.977   100.195     0.200
     6.977   100.014     0.200
     6.960   100.375     0.200
     6.960   100.553     0.200
     6.958   100.215     0.200
     6.958   100.512     0.200
     7.019   100.625     0.200
     7.061   102.365     0.200
     7.061   102.592     0.200
     7.109   102.266     0.200
     7.117   101.695     0.200
     7.143   103.615     0.200
     7.143   104.055     0.200
     7.144   102.586     0.200
     7.144   102.898     0.200
     7.187   103.045     0.200
     7.298   105.342     0.200
     7.437   104.426     0.200
     7.309   105.545     0.200
     7.309   105.158     0.200
     7.322   105.506     0.200
     7.356   106.230     0.200
     7.349   106.914     0.200
     7.353   105.234     0.200
     7.369   105.965     0.200
     7.369   106.113     0.200
     7.390   106.545     0.200
     7.390   106.699     0.200
     7.410   106.186     0.200
     7.410   107.453     0.200
     7.450   106.975     0.200
     7.462   106.984     0.200
     7.500   107.225     0.200
     7.597   109.279     0.200
     7.651   109.926     0.200
     7.651   110.086     0.200
     7.621   109.404     0.200
     7.647   110.215     0.200
     7.713   109.855     0.200
     7.748   111.186     0.200
     7.748   112.184     0.200
     7.774   112.164     0.200
     7.761   111.025     0.200
     7.761   112.391     0.200
     7.794   111.482     0.200
     7.797   111.256     0.200
     7.946   110.275     0.200
     7.872   112.824     0.200
     7.872   113.096     0.200
     7.865   111.936     0.200
     7.885   113.676     0.200
     7.885   112.324     0.200
     7.885   113.105     0.200
     8.057   115.926     0.200
     8.101   116.045     0.200
     8.111   115.545     0.200
     8.129   116.775     0.200
     8.129   116.395     0.200
     8.259   118.020     0.200
     8.222   119.176     0.200
     8.222   118.645     0.200
     8.416   120.525     0.200
     8.416   121.154     0.200
     8.393   121.244     0.200
     8.393   121.090     0.200
     8.400   120.805     0.200
     8.400   121.164     0.200
     8.411   120.266     0.200
     8.411   120.967     0.200
     8.445   121.324     0.200
     8.515   122.309     0.200
     8.555   121.689     0.200
     8.560   122.814     0.200
     8.560   122.660     0.200
     8.571   122.215     0.200
     8.590   123.404     0.200
     8.590   123.146     0.200
     8.699   124.426     0.200
     8.699   125.117     0.200
     8.731   124.586     0.200
     8.731   124.840     0.200
     8.779   124.225     0.200
     8.813   126.605     0.200
     8.813   126.223     0.200
     8.825   126.131     0.200
     8.907   127.125     0.200
     8.905   127.717     0.200
     8.926   127.488     0.200
     8.922   127.275     0.200
     8.970   129.266     0.200
     8.970   127.898     0.200
     8.986   129.574     0.200
     8.986   128.379     0.200
     9.013   128.285     0.200
     9.043   129.125     0.200
     9.043   128.756     0.200
     9.043   129.025     0.200
     9.060   128.314     0.200
     9.060   129.242     0.200
     9.072   129.734     0.200
     9.072   129.178     0.200
     9.121   131.303     0.200
     9.184   131.287     0.200
     9.213   132.033     0.200
     9.189   131.514     0.200
     9.226   132.244     0.200
     9.226   131.562     0.200
     9.276   132.975     0.200
     9.276   131.570     0.200
     9.352   133.467     0.200
     9.365   133.377     0.200
     9.409   134.945     0.200
     9.414   134.805     0.200
     9.414   133.598     0.200
     9.446   133.516     0.200
     9.438   134.721     0.200
     9.507   135.205     0.200
     9.534   136.156     0.200
     9.566   136.514     0.200
     9.646   137.400     0.200
     9.691   138.654     0.200
     9.704   137.883     0.200
     9.742   138.928     0.200
     9.857   140.324     0.200
     9.847   139.385     0.200
     9.897   140.381     0.200
     9.932   140.707     0.200
     9.941   139.064     0.200
     9.941   138.828     0.200
     9.965   143.414     0.200
     9.965   141.600     0.200
    10.010   142.836     0.200
    10.046   142.125     0.200
    10.046   142.674     0.200
    10.086   143.396     0.200
    10.086   145.074     0.200
    10.086   143.125     0.200
    10.086   144.311     0.200
    10.135   144.689     0.200
    10.154   144.314     0.200
    10.154   144.658     0.200
    10.224   145.672     0.200
    10.239   145.479     0.200
    10.273   146.215     0.200
    10.330   145.336     0.200
    10.370   146.936     0.200
    10.362   147.564     0.200
    10.362   147.928     0.200
    10.390   147.164     0.200
    10.390   147.629     0.200
    10.441   150.275     0.200
    10.441   147.484     0.200
    10.476   148.625     0.200
    10.476   148.520     0.200
    10.538   149.025     0.200
    10.580   149.914     0.200
    10.580   150.484     0.200
    10.598   151.059     0.200
    10.667   151.592     0.200
    10.731   152.852     0.200
    10.747   152.984     0.200
    10.772   152.658     0.200
    10.819   154.023     0.200
    10.817   154.766     0.200
    10.866   154.217     0.200
    10.888   155.135     0.200
    10.890   155.234     0.200
    10.890   154.738     0.200
    10.919   153.695     0.200
    10.919   154.629     0.200
    10.934   155.801     0.200
    10.968   155.676     0.200
    11.017   156.439     0.200
    11.037   156.057     0.200
    11.032   157.303     0.200
    11.111   157.719     0.200
    11.210   159.137     0.200
    11.260   155.904     0.200
    11.260   157.264     0.200
    11.315   161.305     0.200
    11.315   160.619     0.200
    11.319   160.086     0.200
    11.319   160.248     0.200
    11.350   160.146     0.200
    11.383   159.674     0.200
    11.419   161.471     0.200
    11.471   162.324     0.200
    11.500   162.945     0.200
    11.514   161.975     0.200
    11.561   163.646     0.200
    11.567   163.574     0.200
    11.622   165.105     0.200
    11.586   162.600     0.200
    11.634   166.025     0.200
    11.634   165.258     0.200
    11.640   163.961     0.200
    11.785   166.535     0.200
    11.746   166.994     0.200
    11.746   167.332     0.200
    11.782   166.537     0.200
    11.857   167.875     0.200
    11.871   167.307     0.200
    11.864   167.244     0.200
    11.870   167.291     0.200
    11.898   167.781     0.200
    12.044   170.676     0.200
    12.131   172.271     0.200
    12.166   171.633     0.200
    12.176   171.854     0.200
    12.217   173.066     0.200
    12.253   172.322     0.200
    12.268   173.615     0.200
    12.288   173.445     0.200
    12.362   174.865     0.200
    12.362   174.406     0.200
    12.403   175.543     0.200
    12.477   176.234     0.200
    12.520   177.023     0.200
    12.603   178.105     0.200
    12.603   178.520     0.200
    12.713   179.436     0.200
    12.740   179.264     0.200
    12.740   181.650     0.200
    12.743   179.385     0.200
    12.792   179.496     0.200
    12.825   181.361     0.200
    12.868   181.936     0.200
    12.868   181.594     0.200
    12.894   182.006     0.200
    12.929   182.455     0.200
    12.929   182.900     0.200
    12.986   183.400     0.200
    13.033   182.873     0.200
    13.060   183.158     0.200
    13.128   184.465     0.200
    13.182   184.764     0.200
    13.159   184.871     0.200
    13.356   187.607     0.200
    13.363   188.182     0.200
    13.411   189.355     0.200
    13.619   192.021     0.200
    13.601   191.379     0.200
    13.614   191.113     0.200
    13.835   193.801     0.200
    13.820   194.842     0.200
    13.888   195.502     0.200
    13.904   195.016     0.200
    13.931   195.689     0.200
    13.999   197.365     0.200
    13.999   197.232     0.200
    14.067   196.117     0.200
    14.096   198.955     0.200
    14.139   199.244     0.200
    14.335   200.957     0.200
    14.385   202.145     0.200
    14.385   201.117     0.200
    14.585   205.111     0.200
    14.751   205.725     0.200
    15.032   211.586     0.200
    15.032   209.885     0.200
    15.032   211.926     0.200
    15.032   212.545     0.200
    15.119   210.990     0.200
    15.235   213.203     0.200
    15.819   220.889     0.200
    16.432   230.412     0.200
    19.584   267.676     0.200
    20.402   276.875     0.200
     1.555    25.830     0.200
     1.555    26.139     0.200
     2.116    33.850     0.200
     2.190    35.719     0.200
     2.198    34.939     0.200
     2.210    35.119     0.200
     2.233    35.340     0.200
     2.329    36.850     0.200
     2.341    37.160     0.200
     2.382    37.869     0.200
     2.383    37.410     0.200
     2.403    37.830     0.200
     2.403    37.828     0.200
     2.508    39.230     0.200
     2.523    39.799     0.200
     2.636    40.400     0.200
     2.667    40.219     0.200
     2.648    41.850     0.200
     2.648    42.094     0.200
     2.762    42.000     0.200
     2.812    41.586     0.200
     2.978    45.230     0.200
     3.198    47.219     0.200
     3.234    48.389     0.200
     3.264    49.010     0.200
     3.264    49.645     0.200
     3.344    50.379     0.200
     3.370    51.730     0.200
     3.370    52.094     0.200
     3.448    51.078     0.200
     3.447    51.080     0.200
     3.436    51.879     0.200
     3.498    53.738     0.200
     3.702    55.170     0.200
     3.703    55.600     0.200
     3.703    55.895     0.200
     3.703    56.010     0.200
     3.723    55.449     0.200
     3.711    55.660     0.200
     3.740    56.719     0.200
     3.824    54.707     0.200
     3.829    54.539     0.200
     3.820    58.299     0.200
     3.946    59.039     0.200
     3.946    59.395     0.200
     4.013    59.770     0.200
     4.120    59.869     0.200
     4.120    59.570     0.200
     4.159    61.430     0.200
     4.159    61.320     0.200
     4.151    62.279     0.200
     4.195    63.010     0.200
     4.217    63.150     0.200
     4.288    64.189     0.200
     4.322    64.910     0.200
     4.324    64.350     0.200
     4.327    64.670     0.200
     4.348    63.080     0.200
     4.509    65.949     0.200
     4.540    66.420     0.200
     4.572    67.740     0.200
     4.572    68.223     0.200
     4.595    67.900     0.200
     4.595    68.184     0.200
     4.617    67.170     0.200
     4.636    69.600     0.200
     4.697    69.430     0.200
     4.799    69.219     0.200
     4.880    69.920     0.200
     4.916    70.260     0.200
     4.916    70.695     0.200
     4.877    70.350     0.200
     4.938    71.260     0.200
     4.892    70.139     0.200
     4.895    70.160     0.200
     4.955    73.070     0.200
     4.955    72.600     0.200
     4.959    73.820     0.200
     4.960    73.820     0.200
     4.986    74.309     0.200
     5.009    74.529     0.200
     5.029    74.799     0.200
     5.065    74.309     0.200
     5.102    75.689     0.200
     5.135    75.520     0.200
     5.164    75.020     0.200
     5.170    74.830     0.200
     5.170    75.070     0.200
     5.265    77.066     0.200
     5.282    77.809     0.200
     5.362    78.170     0.200
     5.367    78.910     0.200
     5.541    81.420     0.200
     5.541    81.293     0.200
     5.568    80.859     0.200
     5.568    81.432     0.200
     5.609    82.629     0.200
     5.609    82.320     0.200
     5.716    83.000     0.200
     5.728    82.469     0.200
     5.732    82.170     0.200
     5.749    82.969     0.200
     5.749    83.340     0.200
     5.749    82.438     0.200
     5.783    84.619     0.200
     5.783    84.357     0.200
     5.879    83.969     0.200
     5.879    83.830     0.200
     5.848    84.939     0.200
     5.850    84.170     0.200
     5.850    83.709     0.200
     5.955    85.850     0.200
     5.957    87.209     0.200
     5.981    86.240     0.200
     5.981    86.062     0.200
     6.083    86.270     0.200
     6.086    86.830     0.200
     6.110    88.219     0.200
     6.147    87.709     0.200
     6.184    90.443     0.200
     6.212    90.139     0.200
     6.236    90.010     0.200
     6.249    89.869     0.200
     6.281    90.559     0.200
     6.281    90.812     0.200
     6.341    91.619     0.200
     6.341    91.484     0.200
     6.368    91.639     0.200
     6.368    91.830     0.200
     6.381    92.379     0.200
     6.485    93.039     0.200
     6.485    93.230     0.200
     6.549    93.680     0.200
     6.635    95.129     0.200
     6.680    96.639     0.200
     6.787    97.100     0.200
     6.792    98.869     0.200
     6.792    98.430     0.200
     6.792    98.629     0.200
     6.835    98.119     0.200
     6.899    99.559     0.200
     6.913    99.309     0.200
     6.913   100.424     0.200
     6.927    99.340     0.200
     6.950   100.100     0.200
     6.998   100.629     0.200
     6.993   100.469     0.200
     6.993    99.840     0.200
     6.997   100.410     0.200
     7.050   100.760     0.200
     7.096   102.959     0.200
     7.096   103.469     0.200
     7.143   102.029     0.200
     7.175   103.320     0.200
     7.179   103.850     0.200
     7.266   103.760     0.200
     7.323   105.500     0.200
     7.346   105.930     0.200
     7.386   105.529     0.200
     7.389   106.707     0.200
     7.387   106.629     0.200
     7.403   105.039     0.200
     7.403   105.918     0.200
     7.427   106.740     0.200
     7.447   106.600     0.200
     7.496   107.260     0.200
     7.488   107.850     0.200
     7.532   107.510     0.200
     7.634   110.580     0.200
     7.652   109.320     0.200
     7.677   110.160     0.200
     7.681   111.059     0.200
     7.681   110.078     0.200
     7.745   110.109     0.200
     7.808   112.289     0.200
     7.826   111.777     0.200
     7.928   110.670     0.200
     7.928   110.459     0.200
     7.897   112.770     0.200
     7.900   112.699     0.200
     7.900   112.498     0.200
     7.920   113.850     0.200
     7.923   112.580     0.200
     8.182   116.260     0.200
     8.139   115.500     0.200
     8.157   116.869     0.200
     8.157   116.619     0.200
     8.282   118.289     0.200
     8.431   121.480     0.200
     8.479   121.529     0.200
     8.592   122.539     0.200
     8.608   122.410     0.200
     8.623   123.600     0.200
     8.737   124.930     0.200
     8.737   124.154     0.200
     8.816   124.680     0.200
     8.847   126.400     0.200
     8.862   125.910     0.200
     8.952   128.160     0.200
     8.952   127.217     0.200
     9.023   129.270     0.200
     9.044   129.529     0.200
     9.050   129.490     0.200
     9.080   129.719     0.200
     9.103   129.359     0.200
     9.153   131.957     0.200
     9.217   131.340     0.200
     9.226   131.359     0.200
     9.244   131.959     0.200
     9.467   133.205     0.200
     9.544   135.209     0.200
     9.544   135.076     0.200
     9.959   139.469     0.200
     9.964   141.299     0.200
    10.003   141.410     0.200
    10.112   145.170     0.200
    10.463   149.369     0.200
    10.463   148.389     0.200
    10.575   149.189     0.200
    10.608   149.160     0.200
    11.349   161.090     0.200
    11.397   160.270     0.200
    11.666   165.949     0.200
    11.813   166.600     0.200
    12.762   182.469     0.200
    14.036   196.650     0.200
    15.068   210.240     0.200
    15.068   210.945     0.200
    20.431   276.369     0.200
     1.028    18.428     0.200
     1.337    21.408     0.200
     1.337    22.016     0.200
     1.642    26.678     0.200
     1.642    27.371     0.200
     2.195    35.248     0.200
     2.291    36.338     0.200
     2.304    36.627     0.200
     2.325    36.738     0.200
     2.493    39.158     0.200
     2.493    39.154     0.200
     2.472    39.178     0.200
     2.472    38.998     0.200
     2.619    41.168     0.200
     2.711    41.438     0.200
     2.744    43.678     0.200
     2.744    43.916     0.200
     2.807    43.447     0.200
     2.836    43.188     0.200
     2.836    42.961     0.200
     3.066    46.598     0.200
     3.256    49.348     0.200
     3.360    50.578     0.200
     3.360    50.936     0.200
     3.437    51.297     0.200
     3.471    52.539     0.200
     3.470    52.537     0.200
     3.465    53.277     0.200
     3.465    53.082     0.200
     3.521    53.117     0.200
     3.787    56.467     0.200
     3.800    57.168     0.200
     3.800    57.365     0.200
     3.810    55.363     0.200
     3.814    55.428     0.200
     3.807    56.787     0.200
     3.793    56.848     0.200
     3.913    59.408     0.200
     4.043    60.367     0.200
     4.106    61.178     0.200
     4.122    61.527     0.200
     4.122    60.658     0.200
     4.122    60.865     0.200
     4.247    62.387     0.200
     4.247    62.590     0.200
     4.244    63.896     0.200
     4.288    64.828     0.200
     4.311    64.537     0.200
     4.382    65.598     0.200
     4.416    65.307     0.200
     4.421    65.928     0.200
     4.425    64.908     0.200
     4.587    67.357     0.200
     4.623    67.678     0.200
     4.668    69.617     0.200
     4.668    69.441     0.200
     4.692    69.688     0.200
     4.806    70.207     0.200
     4.887    71.098     0.200
     4.930    71.598     0.200
     4.946    72.088     0.200
     4.941    71.607     0.200
     5.052    73.918     0.200
     5.155    75.727     0.200
     5.253    76.566     0.200
     5.253    76.322     0.200
     5.350    78.707     0.200
     5.350    78.547     0.200
     5.374    78.998     0.200
     5.464    80.158     0.200
     5.451    78.957     0.200
     5.451    79.398     0.200
     5.540    79.688     0.200
     5.637    82.727     0.200
     5.660    82.697     0.200
     5.703    84.277     0.200
     5.795    84.367     0.200
     5.912    85.527     0.200
     5.912    85.127     0.200
     6.053    88.387     0.200
     6.037    87.537     0.200
     6.084    87.348     0.200
     6.202    89.277     0.200
     6.280    91.816     0.200
     6.307    91.938     0.200
     6.306    91.057     0.200
     6.374    92.428     0.200
     6.425    94.277     0.200
     6.445    92.418     0.200
     6.555    94.457     0.200
     6.609    95.078     0.200
     6.889   100.227     0.200
     6.889    99.607     0.200
     6.924    99.887     0.200
     6.972    99.717     0.200
     7.059   101.418     0.200
     7.201   103.248     0.200
     7.213   103.178     0.200
     7.273   105.637     0.200
     7.926   112.127     0.200
     8.695   123.857     0.200
     8.821   125.938     0.200
     9.138   129.977     0.200
     9.165   131.217     0.200
     9.165   130.727     0.200
     9.621   137.387     0.200
    10.271   145.566     0.200
    11.446   163.387     0.200
    11.987   168.066     0.200
    13.994   196.787     0.200
    14.218   200.947     0.200
    15.143   211.947     0.200
    19.698   267.967     0.200
    20.468   277.877     0.200
     0.553    13.911     0.200
     0.621    15.011     0.200
     0.625    14.821     0.200
     0.680    15.291     0.200
     0.700    15.491     0.200
     0.654    15.241     0.200
     0.790    16.562     0.200
     0.924    17.381     0.200
     0.920    18.021     0.200
     0.906    17.691     0.200
     0.989    18.841     0.200
     1.154    20.241     0.200
     1.100    20.801     0.200
     1.259    21.191     0.200
     1.351    23.291     0.200
     1.437    24.392     0.200
     1.410    23.852     0.200
     1.547    25.991     0.200
     1.671    26.901     0.200
     1.753    27.392     0.200
     1.741    28.222     0.200
     1.791    29.441     0.200
     1.829    29.852     0.200
     1.890    30.401     0.200
     1.902    30.321     0.200
     1.919    31.521     0.200
     2.038    31.921     0.200
     2.168    34.161     0.200
     2.201    34.611     0.200
     2.180    33.682     0.200
     2.213    35.081     0.200
     2.227    34.751     0.200
     2.251    35.781     0.200
     2.257    35.941     0.200
     2.270    36.001     0.200
     2.330    36.821     0.200
     2.374    37.741     0.200
     2.391    37.661     0.200
     2.419    37.581     0.200
     2.477    37.722     0.200
     2.527    39.281     0.200
     2.567    39.472     0.200
     2.640    38.741     0.200
     2.756    41.251     0.200
     2.867    44.481     0.200
     2.911    43.421     0.200
     2.939    44.151     0.200
     2.960    43.591     0.200
     3.045    46.321     0.200
     3.121    46.161     0.200
     3.078    46.941     0.200
     3.094    46.142     0.200
     3.152    47.731     0.200
     3.115    47.451     0.200
     3.142    48.121     0.200
     3.160    48.142     0.200
     3.263    49.361     0.200
     3.323    50.051     0.200
     3.386    51.121     0.200
     3.435    51.621     0.200
     3.534    52.142     0.200
     3.553    52.682     0.200
     3.571    53.211     0.200
     3.639    54.182     0.200
     3.615    53.791     0.200
     3.615    54.231     0.200
     3.804    56.432     0.200
     3.890    57.701     0.200
     3.911    58.231     0.200
     4.110    59.041     0.200
     4.190    60.521     0.200
     4.274    63.001     0.200
     4.313    62.611     0.200
     4.379    63.841     0.200
     4.394    64.871     0.200
     4.521    64.631     0.200
     4.660    65.602     0.200
     4.743    68.591     0.200
     4.782    69.062     0.200
     4.870    70.201     0.200
     4.905    71.701     0.200
     5.050    73.441     0.200
     5.041    72.481     0.200
     5.177    74.441     0.200
     5.205    75.321     0.200
     5.215    75.071     0.200
     5.206    74.841     0.200
     5.217    75.801     0.200
     5.259    75.861     0.200
     5.276    76.041     0.200
     5.293    76.102     0.200
     5.328    76.722     0.200
     5.342    77.451     0.200
     5.393    77.921     0.200
     5.473    79.341     0.200
     5.458    78.241     0.200
     5.469    78.581     0.200
     5.473    79.161     0.200
     5.476    78.661     0.200
     5.504    79.321     0.200
     5.552    79.661     0.200
     5.675    80.831     0.200
     5.703    81.331     0.200
     5.761    82.642     0.200
     5.771    82.211     0.200
     5.789    81.812     0.200
     5.827    83.961     0.200
     5.892    84.731     0.200
     5.905    84.571     0.200
     5.943    85.421     0.200
     5.977    85.211     0.200
     5.995    86.161     0.200
     6.018    86.562     0.200
     6.035    85.841     0.200
     6.082    87.361     0.200
     6.113    87.972     0.200
     6.256    89.731     0.200
     6.286    89.551     0.200
     6.339    90.062     0.200
     6.382    91.291     0.200
     6.469    92.161     0.200
     6.471    92.751     0.200
     6.469    92.642     0.200
     6.479    94.171     0.200
     6.737    94.521     0.200
     6.806    94.911     0.200
     6.835    97.501     0.200
     6.833    97.821     0.200
     6.868    97.631     0.200
     6.916    99.111     0.200
     6.958    99.411     0.200
     6.998    98.491     0.200
     7.019    97.801     0.200
     7.034   100.451     0.200
     7.036    99.371     0.200
     7.056   101.021     0.200
     7.173   102.591     0.200
     7.211   101.541     0.200
     7.219   102.071     0.200
     7.261   103.651     0.200
     7.322   102.371     0.200
     7.322   102.371     0.200
     7.400   105.071     0.200
     7.448   105.972     0.200
     7.457   106.331     0.200
     7.470   105.571     0.200
     7.555   106.781     0.200
     7.580   106.501     0.200
     7.622   108.671     0.200
     7.643   108.491     0.200
     7.662   108.321     0.200
     7.674   108.771     0.200
     7.707   109.812     0.200
     7.831   109.731     0.200
     7.976   112.241     0.200
     8.083   113.321     0.200
     8.129   114.731     0.200
     8.149   115.941     0.200
     8.288   114.972     0.200
     8.244   116.182     0.200
     8.263   116.451     0.200
     8.731   124.861     0.200
     8.740   123.562     0.200
     8.811   125.691     0.200
     8.918   125.651     0.200
     9.106   128.451     0.200
     9.142   129.071     0.200
     9.301   132.511     0.200
     9.513   133.841     0.200
     9.750   137.281     0.200
     9.916   138.881     0.200
    10.103   140.062     0.200
    10.515   148.801     0.200
    10.548   145.591     0.200
    13.527   188.241     0.200
     0.459    10.086     0.200
     0.493    11.066     0.200
     0.495    10.977     0.200
     0.820    15.457     0.200
     1.003    16.969     0.200
     1.135    19.316     0.200
     1.162    19.957     0.200
     1.197    20.777     0.200
     1.184    20.168     0.200
     1.192    20.438     0.200
     1.194    21.148     0.200
     1.212    20.996     0.200
     1.272    21.426     0.200
     1.362    22.676     0.200
     1.462    24.746     0.200
     1.506    24.676     0.200
     1.569    25.543     0.200
     1.590    26.195     0.200
     1.603    26.828     0.200
     1.603    26.051     0.200
     1.692    26.508     0.200
     1.783    27.457     0.200
     1.789    28.777     0.200
     1.820    28.977     0.200
     1.888    29.828     0.200
     1.890    30.617     0.200
     1.906    30.137     0.200
     2.020    31.543     0.200
     2.034    31.656     0.200
     2.088    32.238     0.200
     2.124    32.969     0.200
     2.124    32.867     0.200
     2.268    35.738     0.200
     2.293    35.855     0.200
     2.673    40.129     0.200
     2.727    42.426     0.200
     2.737    41.527     0.200
     2.778    42.266     0.200
     2.812    43.617     0.200
     2.812    41.816     0.200
     2.910    43.766     0.200
     2.910    43.480     0.200
     3.024    45.539     0.200
     3.024    45.391     0.200
     3.028    45.742     0.200
     3.079    46.469     0.200
     3.097    46.906     0.200
     3.132    47.348     0.200
     3.193    47.426     0.200
     3.201    47.566     0.200
     3.316    49.117     0.200
     3.368    49.496     0.200
     3.451    51.266     0.200
     3.541    52.246     0.200
     3.541    52.527     0.200
     3.633    53.578     0.200
     3.608    53.242     0.200
     3.693    54.938     0.200
     3.732    55.398     0.200
     3.762    55.746     0.200
     3.785    56.195     0.200
     3.829    56.496     0.200
     3.853    56.879     0.200
     3.853    56.516     0.200
     3.899    56.629     0.200
     3.930    57.156     0.200
     3.930    57.020     0.200
     3.959    57.789     0.200
     3.935    58.246     0.200
     4.084    60.523     0.200
     4.082    60.527     0.200
     4.105    59.707     0.200
     4.106    60.469     0.200
     4.171    61.336     0.200
     4.181    61.336     0.200
     4.287    62.398     0.200
     4.287    62.191     0.200
     4.316    63.418     0.200
     4.446    64.656     0.200
     4.445    64.605     0.200
     4.474    65.668     0.200
     4.597    66.668     0.200
     4.718    68.398     0.200
     4.685    68.527     0.200
     4.724    68.867     0.200
     4.769    69.516     0.200
     4.820    69.477     0.200
     4.832    69.938     0.200
     4.832    69.566     0.200
     4.818    69.879     0.200
     4.818    69.738     0.200
     4.840    70.527     0.200
     5.005    70.836     0.200
     5.012    70.836     0.200
     4.981    72.047     0.200
     5.055    72.559     0.200
     5.062    73.066     0.200
     5.087    73.215     0.200
     5.118    73.555     0.200
     5.165    74.926     0.200
     5.210    74.797     0.200
     5.250    75.328     0.200
     5.251    75.969     0.200
     5.268    77.008     0.200
     5.268    76.230     0.200
     5.352    77.367     0.200
     5.402    77.988     0.200
     5.439    77.926     0.200
     5.421    78.219     0.200
     5.456    78.777     0.200
     5.550    79.617     0.200
     5.537    79.867     0.200
     5.594    80.398     0.200
     5.605    79.758     0.200
     5.598    80.754     0.200
     5.626    80.816     0.200
     5.624    80.410     0.200
     5.627    80.809     0.200
     5.595    80.438     0.200
     5.671    81.348     0.200
     5.705    81.938     0.200
     5.716    81.938     0.200
     5.744    82.137     0.200
     5.732    82.418     0.200
     5.707    81.695     0.200
     5.756    82.398     0.200
     5.781    83.195     0.200
     5.782    83.258     0.200
     5.848    84.289     0.200
     5.877    84.258     0.200
     5.916    85.137     0.200
     5.928    84.855     0.200
     5.978    85.668     0.200
     5.931    85.457     0.200
     5.997    85.836     0.200
     5.956    84.777     0.200
     6.022    86.059     0.200
     5.991    85.418     0.200
     6.027    86.129     0.200
     6.024    86.098     0.200
     6.080    86.996     0.200
     6.231    88.977     0.200
     6.217    88.867     0.200
     6.334    90.418     0.200
     6.389    91.148     0.200
     6.433    91.379     0.200
     6.482    92.289     0.200
     6.500    92.734     0.200
     6.504    92.738     0.200
     6.535    92.945     0.200
     6.610    93.879     0.200
     6.602    94.328     0.200
     6.658    94.719     0.200
     6.672    94.039     0.200
     6.704    94.566     0.200
     6.748    97.086     0.200
     6.802    96.996     0.200
     6.833    97.605     0.200
     6.833    98.578     0.200
     6.833    97.496     0.200
     6.856    97.387     0.200
     6.889    98.277     0.200
     6.914    97.598     0.200
     6.931    98.008     0.200
     6.975    98.746     0.200
     6.952    99.227     0.200
     7.040   100.617     0.200
     7.070   100.367     0.200
     7.153   101.309     0.200
     7.117   100.547     0.200
     7.137   100.488     0.200
     7.171   100.926     0.200
     7.193   101.039     0.200
     7.193   101.688     0.200
     7.193   100.969     0.200
     7.227   101.867     0.200
     7.309   104.766     0.200
     7.327   104.676     0.200
     7.377   103.797     0.200
     7.410   104.438     0.200
     7.435   104.898     0.200
     7.482   105.617     0.200
     7.531   107.059     0.200
     7.536   107.016     0.200
     7.649   109.605     0.200
     7.812   110.047     0.200
     7.819   111.086     0.200
     7.989   113.086     0.200
     7.989   112.590     0.200
     8.017   112.629     0.200
     8.124   114.289     0.200
     8.171   115.105     0.200
     8.202   115.605     0.200
     8.333   118.605     0.200
     8.333   117.684     0.200
     8.357   117.719     0.200
     8.348   117.855     0.200
     8.489   120.027     0.200
     8.475   120.488     0.200
     8.475   119.473     0.200
     8.656   122.008     0.200
     8.643   121.266     0.200
     8.762   124.727     0.200
     8.728   124.266     0.200
     8.890   125.086     0.200
     8.944   126.676     0.200
     8.971   127.297     0.200
     9.057   127.539     0.200
     9.121   128.656     0.200
     9.320   133.328     0.200
     9.496   135.289     0.200
     9.493   135.039     0.200
     9.886   139.387     0.200
    10.002   138.855     0.200
    10.583   149.309     0.200
    10.585   150.066     0.200
    10.720   151.438     0.200
    11.104   156.906     0.200
    11.521   160.367     0.200
    12.202   170.008     0.200
    13.298   184.418     0.200
     1.607    29.195     0.200
     1.758    30.613     0.200
     1.838    31.285     0.200
     1.838    31.734     0.200
     1.961    33.246     0.200
     1.961    33.609     0.200
     1.962    33.637     0.200
     2.073    35.266     0.200
     2.242    37.855     0.200
     2.410    39.496     0.200
     2.410    39.699     0.200
     2.443    39.844     0.200
     2.443    41.109     0.200
     2.514    42.316     0.200
     2.518    41.535     0.200
     2.519    41.547     0.200
     2.561    41.875     0.200
     2.552    41.844     0.200
     2.552    41.613     0.200
     2.617    43.836     0.200
     2.540    41.855     0.200
     2.647    43.336     0.200
     2.694    43.215     0.200
     2.706    44.246     0.200
     2.812    45.266     0.200
     2.827    45.766     0.200
     3.114    49.746     0.200
     3.114    50.266     0.200
     3.215    50.844     0.200
     3.292    52.887     0.200
     3.294    52.887     0.200
     3.336    53.766     0.200
     3.301    52.227     0.200
     3.301    52.809     0.200
     3.272    51.957     0.200
     3.316    52.695     0.200
     3.316    52.887     0.200
     3.643    57.914     0.200
     3.642    56.914     0.200
     3.642    57.160     0.200
     3.667    57.355     0.200
     3.748    59.074     0.200
     3.694    57.914     0.200
     3.904    61.254     0.200
     3.900    60.355     0.200
     3.998    61.797     0.200
     3.998    61.648     0.200
     4.024    62.273     0.200
     4.135    64.254     0.200
     4.136    63.387     0.200
     4.248    66.094     0.200
     4.208    64.055     0.200
     4.316    67.125     0.200
     4.514    68.957     0.200
     4.635    70.773     0.200
     4.612    70.246     0.200
     4.662    71.207     0.200
     4.680    71.484     0.200
     4.680    71.145     0.200
     4.654    70.637     0.200
     4.654    71.500     0.200
     4.804    73.836     0.200
     4.833    73.336     0.200
     4.833    73.688     0.200
     4.948    74.547     0.200
     4.940    75.273     0.200
     5.108    76.914     0.200
     5.078    77.176     0.200
     5.078    77.012     0.200
     5.232    79.023     0.200
     5.320    80.176     0.200
     5.320    80.309     0.200
     5.366    81.254     0.200
     5.366    81.672     0.200
     5.684    84.496     0.200
     5.684    84.715     0.200
     5.678    85.066     0.200
     5.644    83.816     0.200
     5.644    84.520     0.200
     5.708    85.816     0.200
     5.718    85.637     0.200
     5.920    88.574     0.200
     5.922    88.387     0.200
     5.988    89.656     0.200
     6.000    90.207     0.200
     6.056    90.555     0.200
     6.161    92.207     0.200
     6.157    92.004     0.200
     6.194    92.316     0.200
     6.295    92.246     0.200
     6.565    97.195     0.200
     6.644    97.805     0.200
     7.019   103.727     0.200
     7.034   103.734     0.200
     7.080   105.004     0.200
     7.087   104.934     0.200
     7.294   107.547     0.200
     7.277   107.414     0.200
     7.309   107.816     0.200
     7.332   108.535     0.200
     7.336   108.516     0.200
     7.434   109.613     0.200
     7.474   110.184     0.200
     7.619   112.164     0.200
     7.619   112.336     0.200
     7.745   113.305     0.200
     7.899   115.996     0.200
     7.931   116.363     0.200
     8.148   119.184     0.200
     8.564   125.266     0.200
     8.637   126.234     0.200
     8.764   127.523     0.200
     9.145   132.797     0.200
     9.157   133.594     0.200
     9.285   134.805     0.200
     9.335   135.406     0.200
     9.492   137.934     0.200
    10.156   147.105     0.200
    10.357   149.344     0.200
    10.763   155.445     0.200
    12.303   175.906     0.200
    12.889   183.836     0.200
    13.218   190.137     0.200
     1.199    21.580     0.200
     1.275    21.811     0.200
     1.309    23.109     0.200
     1.309    22.721     0.200
     1.576    26.154     0.200
     1.568    27.150     0.200
     1.620    27.584     0.200
     1.628    27.619     0.200
     1.628    27.754     0.200
     1.757    29.430     0.200
     1.830    30.549     0.200
     1.830    30.998     0.200
     1.908    31.561     0.200
     2.034    34.010     0.200
     2.053    34.150     0.200
     2.065    34.330     0.200
     2.085    33.641     0.200
     2.085    34.129     0.200
     2.220    35.939     0.200
     2.220    36.160     0.200
     2.288    36.539     0.200
     2.337    38.186     0.200
     2.375    37.750     0.200
     2.375    38.619     0.200
     2.589    41.629     0.200
     2.601    41.232     0.200
     2.600    42.100     0.200
     2.630    41.750     0.200
     2.708    43.160     0.200
     2.740    43.090     0.200
     2.855    44.830     0.200
     2.865    45.650     0.200
     2.925    46.340     0.200
     3.016    47.580     0.200
     3.016    46.896     0.200
     3.049    47.670     0.200
     3.120    49.061     0.200
     3.158    49.561     0.200
     3.166    49.850     0.200
     3.214    49.971     0.200
     3.212    50.240     0.200
     3.220    49.779     0.200
     3.220    50.510     0.200
     3.263    51.061     0.200
     3.266    51.439     0.200
     3.298    50.859     0.200
     3.344    52.020     0.200
     3.426    53.650     0.200
     3.426    53.459     0.200
     3.462    53.811     0.200
     3.462    53.340     0.200
     3.470    53.400     0.200
     3.470    53.859     0.200
     3.589    55.311     0.200
     3.589    54.330     0.200
     3.635    55.020     0.200
     3.819    58.186     0.200
     3.860    58.830     0.200
     3.892    59.061     0.200
     3.943    61.047     0.200
     3.944    60.721     0.200
     3.942    60.180     0.200
     3.997    61.830     0.200
     4.014    62.250     0.200
     4.055    61.289     0.200
     4.123    62.439     0.200
     4.123    61.887     0.200
     4.105    62.221     0.200
     4.109    62.850     0.200
     4.222    65.020     0.200
     4.292    65.789     0.200
     4.308    65.070     0.200
     4.416    67.240     0.200
     4.531    68.990     0.200
     4.543    68.520     0.200
     4.544    67.859     0.200
     4.548    68.080     0.200
     4.548    68.209     0.200
     4.562    68.410     0.200
     4.562    68.686     0.200
     4.626    69.369     0.200
     4.716    69.949     0.200
     4.788    72.039     0.200
     4.916    73.770     0.200
     4.916    73.936     0.200
     4.908    73.600     0.200
     4.908    73.984     0.200
     4.940    74.480     0.200
     5.052    74.660     0.200
     5.112    76.209     0.200
     5.112    75.680     0.200
     5.112    75.971     0.200
     5.210    76.010     0.200
     5.210    77.312     0.200
     5.203    76.660     0.200
     5.203    77.135     0.200
     5.273    77.760     0.200
     5.273    78.359     0.200
     5.312    78.699     0.200
     5.307    80.010     0.200
     5.307    78.699     0.200
     5.397    78.990     0.200
     5.397    79.420     0.200
     5.408    79.760     0.200
     5.520    83.850     0.200
     5.520    82.699     0.200
     5.530    81.270     0.200
     5.530    81.795     0.200
     5.555    81.580     0.200
     5.555    82.285     0.200
     5.586    81.189     0.200
     5.773    85.311     0.200
     5.773    85.584     0.200
     5.811    85.480     0.200
     5.811    84.947     0.200
     5.868    86.430     0.200
     5.868    86.709     0.200
     5.892    86.340     0.200
     6.033    88.799     0.200
     6.033    89.668     0.200
     6.168    91.240     0.200
     6.166    90.490     0.200
     6.204    91.439     0.200
     6.204    90.617     0.200
     6.189    89.840     0.200
     6.189    90.010     0.200
     6.212    89.990     0.200
     6.212    91.037     0.200
     6.245    91.920     0.200
     6.288    92.141     0.200
     6.340    94.090     0.200
     6.366    93.990     0.200
     6.370    93.000     0.200
     6.370    93.523     0.200
     6.484    94.340     0.200
     6.498    94.699     0.200
     6.498    94.990     0.200
     6.586    95.379     0.200
     6.586    96.582     0.200
     6.643    97.330     0.200
     6.754    98.049     0.200
     6.774    98.799     0.200
     6.774    99.078     0.200
     6.807    98.770     0.200
     6.807    98.621     0.200
     6.840    99.859     0.200
     6.840   100.512     0.200
     6.903   101.629     0.200
     6.903   100.875     0.200
     6.917   100.391     0.200
     7.046   102.590     0.200
     7.046   102.375     0.200
     7.117   103.180     0.200
     7.277   106.709     0.200
     7.300   105.939     0.200
     7.300   105.191     0.200
     7.491   107.439     0.200
     7.614   110.189     0.200
     7.614   110.686     0.200
     7.631   109.850     0.200
     7.631   110.150     0.200
     7.655   111.539     0.200
     7.655   110.846     0.200
     7.709   111.289     0.200
     7.730   110.900     0.200
     7.728   111.629     0.200
     7.728   111.463     0.200
     7.746   112.350     0.200
     7.746   111.775     0.200
     7.754   113.240     0.200
     7.754   113.016     0.200
     7.796   113.119     0.200
     7.868   113.971     0.200
     7.895   114.250     0.200
     7.918   114.670     0.200
     7.944   113.830     0.200
     7.949   114.580     0.200
     8.038   116.020     0.200
     8.084   117.670     0.200
     8.080   116.730     0.200
     8.080   117.209     0.200
     8.124   116.900     0.200
     8.141   117.650     0.200
     8.141   117.531     0.200
     8.263   118.480     0.200
     8.263   117.859     0.200
     8.408   121.350     0.200
     8.410   121.080     0.200
     8.415   121.209     0.200
     8.415   120.828     0.200
     8.427   121.689     0.200
     8.427   120.836     0.200
     8.457   122.250     0.200
     8.457   121.791     0.200
     8.476   121.270     0.200
     8.476   120.961     0.200
     8.488   121.480     0.200
     8.503   122.359     0.200
     8.528   121.930     0.200
     8.528   122.359     0.200
     8.560   122.510     0.200
     8.640   124.609     0.200
     8.676   124.520     0.200
     8.676   124.295     0.200
     8.677   125.350     0.200
     8.973   128.646     0.200
     8.972   128.660     0.200
     9.138   131.160     0.200
     9.208   132.100     0.200
     9.208   131.721     0.200
     9.390   133.369     0.200
     9.446   135.770     0.200
     9.475   134.830     0.200
     9.657   138.209     0.200
     9.753   139.590     0.200
     9.774   139.764     0.200
     9.820   139.451     0.200
     9.930   141.629     0.200
    10.088   144.359     0.200
    10.178   145.430     0.200
    10.291   144.869     0.200
    10.291   145.668     0.200
    10.706   152.529     0.200
    10.757   152.959     0.200
    10.936   155.340     0.200
    11.349   162.260     0.200
    11.426   161.330     0.200
    11.547   164.391     0.200
    11.850   168.549     0.200
    12.387   173.930     0.200
    12.421   175.270     0.200
    12.432   177.221     0.200
    12.777   180.529     0.200
    12.922   181.730     0.200
    13.486   189.410     0.200
    13.496   192.186     0.200
    13.947   195.260     0.200
    14.520   202.984     0.200
    16.643   232.709     0.200
     1.194    21.393     0.200
     1.313    22.713     0.200
     1.570    26.162     0.200
     1.577    27.432     0.200
     1.609    27.562     0.200
     1.621    27.963     0.200
     1.839    29.982     0.200
     1.906    31.633     0.200
     1.905    31.473     0.200
     2.023    33.533     0.200
     2.042    33.662     0.200
     2.054    33.693     0.200
     2.095    33.572     0.200
     2.210    35.992     0.200
     2.281    36.523     0.200
     2.327    38.252     0.200
     2.620    41.572     0.200
     2.637    42.033     0.200
     2.697    42.604     0.200
     2.739    43.203     0.200
     2.845    45.104     0.200
     2.915    46.363     0.200
     3.041    47.553     0.200
     3.109    48.373     0.200
     3.147    48.932     0.200
     3.152    49.963     0.200
     3.155    49.012     0.200
     3.202    49.803     0.200
     3.210    50.143     0.200
     3.292    51.012     0.200
     3.426    52.893     0.200
     3.467    53.572     0.200
     3.599    54.672     0.200
     3.813    58.312     0.200
     3.851    58.592     0.200
     3.884    59.172     0.200
     3.934    59.842     0.200
     3.949    59.613     0.200
     3.960    59.883     0.200
     3.941    60.143     0.200
     3.987    60.672     0.200
     4.051    61.383     0.200
     4.114    62.002     0.200
     4.231    63.963     0.200
     4.282    64.682     0.200
     4.298    64.883     0.200
     4.406    66.473     0.200
     4.521    68.873     0.200
     4.532    68.152     0.200
     4.538    67.832     0.200
     4.552    68.553     0.200
     4.545    68.023     0.200
     4.618    69.473     0.200
     4.709    70.033     0.200
     4.778    72.533     0.200
     4.906    73.012     0.200
     4.907    73.232     0.200
     5.047    74.723     0.200
     5.101    75.582     0.200
     5.199    76.752     0.200
     5.200    76.562     0.200
     5.266    77.822     0.200
     5.302    78.432     0.200
     5.298    79.303     0.200
     5.399    79.562     0.200
     5.520    81.793     0.200
     5.550    82.133     0.200
     5.764    84.992     0.200
     5.801    84.822     0.200
     5.860    86.143     0.200
     5.882    86.562     0.200
     6.023    89.363     0.200
     6.157    90.293     0.200
     6.202    90.533     0.200
     6.183    89.803     0.200
     6.277    91.932     0.200
     6.330    94.043     0.200
     6.355    93.822     0.200
     6.474    94.703     0.200
     6.494    94.723     0.200
     6.633    97.023     0.200
     6.764    98.383     0.200
     6.797    98.992     0.200
     7.719   111.072     0.200
     7.744   112.822     0.200
     7.909   114.232     0.200
     8.074   117.512     0.200
     8.070   116.912     0.200
     9.764   140.082     0.200
     1.101    20.759     0.200
     1.336    22.629     0.200
     1.336    22.766     0.200
     1.172    21.318     0.200
     1.589    26.429     0.200
     1.610    27.559     0.200
     1.610    27.394     0.200
     1.566    26.849     0.200
     1.602    27.459     0.200
     1.735    29.749     0.200
     1.735    29.321     0.200
     1.881    31.219     0.200
     1.881    31.467     0.200
     2.198    35.938     0.200
     2.198    35.619     0.200
     2.325    37.619     0.200
     2.261    36.068     0.200
     2.261    36.393     0.200
     2.347    37.929     0.200
     2.611    42.209     0.200
     2.611    41.113     0.200
     2.600    41.498     0.200
     2.599    41.499     0.200
     2.694    42.568     0.200
     2.715    43.238     0.200
     2.849    45.459     0.200
     2.853    45.519     0.200
     2.921    46.108     0.200
     2.990    46.649     0.200
     3.025    48.049     0.200
     3.025    47.046     0.200
     3.105    48.729     0.200
     3.143    49.238     0.200
     3.209    49.699     0.200
     3.259    50.829     0.200
     3.199    50.039     0.200
     3.199    49.729     0.200
     3.270    50.629     0.200
     3.439    53.479     0.200
     3.402    52.669     0.200
     3.443    53.799     0.200
     3.443    53.420     0.200
     3.792    58.299     0.200
     3.792    57.908     0.200
     3.836    58.238     0.200
     3.952    59.148     0.200
     3.928    59.151     0.200
     3.929    59.148     0.200
     3.866    58.979     0.200
     3.866    58.696     0.200
     3.992    60.449     0.200
     3.980    59.818     0.200
     3.916    59.759     0.200
     3.916    59.533     0.200
     4.028    61.068     0.200
     4.102    64.179     0.200
     4.102    62.062     0.200
     4.220    64.219     0.200
     4.277    63.889     0.200
     4.244    64.869     0.200
     4.287    64.619     0.200
     4.397    67.318     0.200
     4.519    68.479     0.200
     4.534    67.979     0.200
     4.540    67.929     0.200
     4.517    68.169     0.200
     4.517    67.393     0.200
     4.521    68.778     0.200
     4.521    67.811     0.200
     4.601    69.369     0.200
     4.601    68.632     0.200
     4.689    69.599     0.200
     4.689    69.867     0.200
     4.773    72.099     0.200
     4.896    72.488     0.200
     4.883    73.929     0.200
     5.102    75.999     0.200
     5.024    74.589     0.200
     5.202    77.079     0.200
     5.176    77.559     0.200
     5.176    76.730     0.200
     5.247    77.629     0.200
     5.407    79.949     0.200
     5.403    80.438     0.200
     5.521    81.839     0.200
     5.502    82.809     0.200
     5.584    81.238     0.200
     5.527    82.278     0.200
     5.527    81.722     0.200
     5.884    85.318     0.200
     6.015    89.309     0.200
     6.207    90.639     0.200
     6.163    90.199     0.200
     6.163    89.759     0.200
     6.323    93.818     0.200
     6.350    93.749     0.200
     6.278    93.148     0.200
     6.347    93.579     0.200
     6.499    94.438     0.200
     6.477    94.679     0.200
     6.471    94.789     0.200
     6.565    97.019     0.200
     6.629    96.839     0.200
     6.763    98.568     0.200
     6.803    99.349     0.200
     6.822    99.969     0.200
     6.888   100.709     0.200
     7.055   102.269     0.200
     7.108   102.619     0.200
     7.116   103.329     0.200
     7.292   106.238     0.200
     7.370   106.969     0.200
     7.396   107.699     0.200
     7.491   108.729     0.200
     7.615   110.139     0.200
     7.589   110.159     0.200
     7.630   110.329     0.200
     7.715   111.469     0.200
     7.736   112.879     0.200
     7.736   112.023     0.200
     7.858   113.869     0.200
     7.863   112.979     0.200
     7.921   113.729     0.200
     7.888   113.879     0.200
     7.978   114.148     0.200
     7.929   114.119     0.200
     7.936   114.898     0.200
     7.898   114.999     0.200
     8.090   116.479     0.200
     8.108   117.519     0.200
     8.120   117.309     0.200
     8.293   120.349     0.200
     8.249   118.519     0.200
     8.249   119.999     0.200
     8.415   122.329     0.200
     8.387   121.068     0.200
     8.466   122.209     0.200
     8.515   122.959     0.200
     8.515   121.812     0.200
     8.689   124.729     0.200
     8.963   129.259     0.200
     8.956   129.059     0.200
     8.956   128.450     0.200
     9.194   132.099     0.200
     9.772   140.108     0.200
     9.921   141.099     0.200
    10.130   145.349     0.200
    10.174   145.738     0.200
    10.741   154.879     0.200
    10.747   153.278     0.200
    10.997   155.389     0.200
    11.409   161.709     0.200
    11.736   167.738     0.200
    12.254   173.789     0.200
     0.052     7.812     0.200
     0.730    13.281     0.200
     0.792    15.223     0.200
     1.256    21.422     0.200
     1.556    24.203     0.200
     1.476    24.371     0.200
     1.541    25.164     0.200
     1.552    25.621     0.200
     1.574    25.871     0.200
     1.625    26.742     0.200
     1.815    28.812     0.200
     1.835    29.594     0.200
     1.840    29.332     0.200
     1.871    30.344     0.200
     1.897    30.301     0.200
     2.011    31.863     0.200
     2.125    32.574     0.200
     2.116    32.523     0.200
     2.266    35.762     0.200
     2.346    36.012     0.200
     2.472    37.973     0.200
     2.554    38.973     0.200
     2.678    40.754     0.200
     2.755    41.852     0.200
     2.778    41.844     0.200
     3.031    44.523     0.200
     3.119    46.773     0.200
     3.163    47.293     0.200
     3.346    49.602     0.200
     3.436    51.051     0.200
     3.404    50.730     0.200
     3.620    52.922     0.200
     3.704    54.863     0.200
     4.037    58.941     0.200
     4.064    59.621     0.200
     4.084    59.742     0.200
     4.137    59.684     0.200
     4.150    60.051     0.200
     4.172    60.812     0.200
     4.200    61.230     0.200
     4.200    61.121     0.200
     4.358    63.062     0.200
     4.370    63.824     0.200
     4.522    65.371     0.200
     4.526    65.844     0.200
     4.565    66.672     0.200
     4.592    66.844     0.200
     4.660    67.973     0.200
     4.707    67.852     0.200
     4.719    68.602     0.200
     4.793    68.891     0.200
     4.800    69.711     0.200
     4.799    69.613     0.200
     4.868    70.652     0.200
     4.951    70.992     0.200
     4.951    71.293     0.200
     4.879    70.523     0.200
     4.975    72.152     0.200
     5.039    72.801     0.200
     5.059    73.242     0.200
     5.130    73.832     0.200
     5.093    73.562     0.200
     5.199    75.184     0.200
     5.205    75.383     0.200
     5.246    75.633     0.200
     5.352    76.902     0.200
     5.335    76.613     0.200
     5.349    77.062     0.200
     5.450    77.980     0.200
     5.536    79.363     0.200
     5.519    78.934     0.200
     5.632    80.730     0.200
     5.604    80.922     0.200
     5.619    80.914     0.200
     5.718    81.824     0.200
     5.740    82.664     0.200
     5.779    82.844     0.200
     5.852    83.742     0.200
     5.926    84.902     0.200
     5.885    84.574     0.200
     5.954    85.094     0.200
     6.054    86.512     0.200
     6.131    87.422     0.200
     6.233    89.391     0.200
     6.248    89.582     0.200
     6.343    90.344     0.200
     6.420    91.652     0.200
     6.497    92.723     0.200
     6.524    92.934     0.200
     6.452    92.191     0.200
     6.972    98.824     0.200
     7.012    98.391     0.200
     7.478   106.141     0.200
     8.400   118.223     0.200
     1.348    23.871     0.200
     1.391    23.561     0.200
     1.413    24.922     0.200
     1.413    24.717     0.200
     1.514    26.371     0.200
     1.633    26.242     0.200
     1.633    26.641     0.200
     1.666    28.912     0.200
     1.863    31.271     0.200
     1.933    30.691     0.200
     1.903    31.381     0.200
     2.040    33.342     0.200
     2.182    34.531     0.200
     2.226    34.951     0.200
     2.212    35.682     0.200
     2.240    35.631     0.200
     2.280    36.361     0.200
     2.288    36.141     0.200
     2.301    36.842     0.200
     2.346    37.061     0.200
     2.365    37.371     0.200
    